-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_228
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_228`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_228` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_228`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','21','228','PURCHASES','','2022-03-23 12:49:28',5,0.00,0.00,'','764','2022-03-23 12:49:28','764',0,0),(2,7000,'',0,'20','21','228','SALES','','2022-03-23 12:50:04',5,0.00,0.00,'','764','2022-03-23 12:50:04','764',0,0),(3,500,'',0,'6.1','21','228','CASH','','2022-03-23 12:55:50',5,0.00,0.00,'','764','2022-03-23 12:55:50','764',0,0),(4,8000,'',0,'24','21','228','PURCHASES','','2022-03-23 12:57:24',5,0.00,0.00,'','764','2022-03-23 12:57:24','764',0,0),(5,8001,'',0,'24','21','228','SALARIES AND WAGES','','2022-03-23 12:57:48',5,0.00,0.00,'','764','2022-03-23 12:57:48','764',0,0),(6,2500,'',0,'2','21','228','ZENITH BANK','','2022-03-23 13:21:15',5,0.00,0.00,'','764','2022-03-23 13:21:15','764',0,0),(7,2501,'',0,'2','21','228','zenith Bank pos','','2022-03-23 13:21:24',5,0.00,0.00,'','764','2022-03-23 13:21:24','764',0,0),(8,2502,'',0,'2','21','228','ZENITH BANK TRANSFER ACC','','2022-03-23 13:21:34',5,0.00,0.00,'','764','2022-03-23 13:21:34','764',0,0),(9,2503,'',0,'2','21','228','FIRST BANK POS','','2022-03-23 13:21:43',5,0.00,0.00,'','764','2022-03-23 13:21:43','764',0,0),(10,2504,'',0,'2','21','228','FIRST BANK','','2022-03-23 13:22:03',5,0.00,0.00,'','764','2022-03-23 13:22:03','764',0,0),(11,2505,'',0,'2','21','228','FIRST BANK TRANSFER ACCOUNT','','2022-03-23 13:22:16',5,0.00,0.00,'','764','2022-03-23 13:22:16','764',0,0),(12,2506,'',0,'2','21','228','UBA BANK','','2022-03-23 13:22:26',5,0.00,0.00,'','764','2022-03-23 13:22:26','764',0,0),(13,2507,'',0,'2','21','228','UBA TRANSFER ACC','','2022-03-23 13:22:35',5,0.00,0.00,'','764','2022-03-23 13:22:35','764',0,0),(14,2508,'',0,'2','21','228','UBA POS','','2022-03-23 13:22:46',5,0.00,0.00,'','764','2022-03-23 13:22:46','764',0,0),(15,2509,'',0,'2','21','228','IBTC BANK','','2022-03-23 13:22:58',5,0.00,0.00,'','764','2022-03-23 13:22:58','764',0,0),(16,2510,'',0,'2','21','228','IBTC TRANSFER ACCOUNT','','2022-03-23 13:23:10',5,0.00,0.00,'','764','2022-03-23 13:23:10','764',0,0),(17,2511,'',0,'2','21','228','IBTC POS','','2022-03-23 13:23:19',5,0.00,0.00,'','764','2022-03-23 13:23:19','764',0,0),(18,2512,'',0,'2','21','228','GT BANK POS','','2022-03-23 13:23:28',5,0.00,0.00,'','764','2022-03-23 13:23:28','764',0,0),(19,2513,'',0,'2','21','228','GT BANK','','2022-03-23 13:23:39',5,0.00,0.00,'','764','2022-03-23 13:23:39','764',0,0),(20,2514,'',0,'2','21','228','GT BANK TRANSFER ACCOUNT','','2022-03-23 13:23:55',5,0.00,0.00,'','764','2022-03-23 13:23:55','764',0,0),(21,2515,'',0,'2','21','228','JAIZ BANK','','2022-03-23 13:24:08',5,0.00,0.00,'','764','2022-03-23 13:24:08','764',0,0),(22,2516,'',0,'2','21','228','JAIZ POS','','2022-03-23 13:24:19',5,0.00,0.00,'','764','2022-03-23 13:24:19','764',0,0),(23,2517,'',0,'2','21','228','JAIZ TRANSFER ACCOUNT','','2022-03-23 13:24:34',5,0.00,0.00,'','764','2022-03-23 13:24:34','764',0,0),(24,2518,'',0,'2','21','228','Sun trust POS','','2022-03-25 11:55:40',5,0.00,0.00,'','768','2022-03-25 11:55:40','768',0,0),(25,2519,'',0,'2','21','228','Unity Bank','','2022-03-26 17:41:16',5,0.00,0.00,'','764','2022-03-26 17:41:16','764',0,0),(26,2520,'',0,'2','21','228','Unity Bank POS','','2022-03-26 17:41:25',5,0.00,0.00,'','764','2022-03-26 17:41:25','764',0,0),(27,2521,'',0,'2','21','228','UNITY Bank Transfer account ','','2022-03-26 17:41:33',5,0.00,0.00,'','764','2022-03-26 17:41:33','764',0,0),(28,2522,'',0,'2','21','228','Ecobank POS','','2022-03-26 17:41:43',5,0.00,0.00,'','764','2022-03-26 17:41:43','764',0,0),(29,2523,'',0,'2','21','228','Ecobank ','','2022-03-26 17:41:50',5,0.00,0.00,'','764','2022-03-26 17:41:50','764',0,0),(30,2524,'',0,'2','21','228','Ecobank Transfer account ','','2022-03-26 17:41:57',5,0.00,0.00,'','764','2022-03-26 17:41:57','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','21','228','RUACH INTERNATIONAL LIMITED ','EMEKA','08036366366','emeka@gmail.com','ABUJA','ABUJA','Venus Mining Company Limited ','Nigeria',800000.00,0.00,0.00,'0000-00-00','2022-04-09 17:05:37',5,'768','2022-04-09 17:05:37','768'),(2,'','21','228','TOTAL CHILD ACADEMY ','MRS JANET ','08036722645','totalchildacademy@gmail.com','ABUJA','ABUJA','BEHIND POLICE SIGN BOARD DUTSE, ABUJA.','Nigeria',3000000.00,0.00,0.00,'0000-00-00','2022-04-11 17:42:00',5,'768','2022-05-12 11:15:45','764'),(3,'','21','228','SOROMAN','ALIMA ','07033950091','alima222@gmail.com','ABUJA','ABUJA','DUSTE ALHAJI ','Nigeria',300000.00,0.00,0.00,'0000-00-00','2022-04-11 17:43:27',5,'768','2022-04-11 17:43:27','768'),(4,'','21','228','BAKO TRUCKS ','BAKO','08162156068','bakotrucks2@gmail.com','ABUJA','ABUJA','TIPPER GARAGE DUTSEN ALHAJI','Nigeria',300000.00,0.00,0.00,'0000-00-00','2022-04-11 17:45:12',5,'768','2022-04-11 17:45:12','768');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','228',1,'1',0.00,2600.00,'2022-03-21','','2022-03-23 12:59:48','764','764',2022,'764','2022-03-23 12:59:48',5),('21','228',2,'3',0.00,1850.00,'2022-03-21','','2022-03-23 13:00:59','764','764',2022,'764','2022-03-23 13:00:59',5),('21','228',3,'4',0.00,100.00,'2022-03-21','','2022-03-23 13:01:24','764','764',2022,'764','2022-03-23 13:01:24',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','228','1',1,'5','PMS NOZZLE 3',2420970.69,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:02:31','768'),('21','228','1',2,'5','PMS NOZZLE 4',4527645.26,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:04:33','768'),('21','228','1',3,'5','PMS NOZZLE 7',2262256.60,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:05:20','768'),('21','228','1',4,'5','PMS NOZZLE 8',2546843.41,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:05:51','768'),('21','228','1',5,'5','PMS NOZZLE 11',2357471.53,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:06:25','768'),('21','228','1',6,'5','PMS NOZZLE 12',2111587.73,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:06:53','768'),('21','228','1',7,'5','PMS NOZZLE 15',2172328.88,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:07:19','768'),('21','228','1',8,'5','PMS NOZZLE 16',2900403.96,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:09:33','768'),('21','228','1',9,'5','PMS NOZZLE 19',2613777.47,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:09:59','768'),('21','228','1',10,'5','PMS NOZZLE 20',1893525.16,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:10:35','768'),('21','228','2',11,'5','PMS NOZZLE 1',3440145.28,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:11:07','768'),('21','228','2',12,'5','PMS NOZZLE 2',3922223.24,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:11:39','768'),('21','228','2',13,'5','PMS NOZZLE 5',2216768.52,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:12:11','768'),('21','228','2',14,'5','PMS NOZZLE 6',3705932.83,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:12:42','768'),('21','228','2',15,'5','PMS NOZZLE 9',3044202.52,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:14:13','768'),('21','228','2',16,'5','PMS NOZZLE 10',2784691.07,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:14:45','768'),('21','228','2',17,'5','PMS NOZZLE 13',2896098.90,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:15:21','768'),('21','228','2',18,'5','PMS NOZZLE 14',2824633.12,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:15:58','768'),('21','228','2',19,'5','PMS NOZZLE 17',2990511.04,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:16:32','768'),('21','228','2',20,'5','PMS NOZZLE 18',2923822.11,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:17:01','768'),('21','228','3',21,'5','AGO NOZZLE 1',1911229.17,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:17:41','768'),('21','228','3',22,'5','AGO NOZZLE 2',2017443.13,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:18:09','768'),('21','228','3',23,'5','AGO NOZZLE 3',2412353.06,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:18:33','768'),('21','228','3',24,'5','AGO NOZZLE 4',1119683.86,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:18:56','768'),('21','228','4',25,'5','DPK NOZZLE 1',410068.79,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:20:22','768'),('21','228','4',26,'5','DPK NOZZLE 2',69398.84,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:21:03','768'),('21','228','4',27,'5','DPK NOZZLE 3',510080.93,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:21:29','768'),('21','228','4',28,'5','DPK NOZZLE 4',960458.02,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-23 12:23:00','768');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','228',1,'DAILY','2022-03-23','2022-03-23 13:30:17','2022-03-24 13:30:17','768',9052214.80,9052214.80,'768','2022-03-23 13:38:51','768','2022-03-23 14:06:19',10,0),('21','228',2,'DAILY','2022-03-23','2022-03-23 14:16:17','2022-03-24 14:16:17','768',10873264.75,10873264.75,'768','2022-03-23 14:25:45','768','2022-03-24 10:51:39',10,0),('21','228',3,'DAILY SHIFT','2022-03-23','2022-03-25 11:38:13','2022-03-26 11:38:13','768',11162915.00,11162915.00,'768','2022-03-25 11:43:23','768','2022-03-25 12:01:51',10,0),('21','228',4,'DAILY SHIFT','2022-03-25','2022-03-25 12:28:31','2022-03-26 12:28:31','768',11144431.65,11144431.65,'768','2022-03-25 13:08:04','768','2022-03-28 15:21:51',10,0),('21','228',5,'DAILY','2022-03-25','2022-03-28 15:23:36','2022-03-29 15:23:36','768',11421042.65,11421042.65,'768','2022-03-28 15:28:14','768','2022-03-28 15:43:12',10,0),('21','228',6,'DAILY','2022-03-26','2022-03-28 15:56:43','2022-03-29 15:56:43','768',10873641.95,10873641.95,'768','2022-03-28 16:04:55','768','2022-03-28 16:39:25',10,0),('21','228',7,'DAILY','2022-03-27','2022-03-28 16:46:18','2022-03-29 16:46:18','768',8388512.50,8388512.50,'768','2022-03-28 16:50:26','768','2022-03-28 16:50:54',10,0),('21','228',8,'Daily','2022-03-28','2022-03-29 19:23:28','2022-03-30 19:23:28','768',11543180.15,11543180.15,'768','2022-03-29 19:33:12','768','2022-03-29 19:35:03',10,0),('21','228',9,'Daily','2022-03-29','2022-03-30 12:58:15','2022-03-31 12:58:15','768',12343786.55,12343786.55,'768','2022-03-30 13:31:22','768','2022-03-30 13:33:04',10,0),('21','228',10,'Daily','2022-03-30','2022-03-31 17:36:55','2022-04-01 17:36:55','768',13720971.15,13720971.15,'768','2022-03-31 17:52:07','768','2022-03-31 17:53:46',10,0),('21','228',11,'Daily','2022-03-31','2022-04-01 16:31:45','2022-04-02 16:31:45','768',3390505.00,3390505.00,'768','2022-04-01 16:36:45','768','2022-04-01 16:38:18',10,0),('21','228',12,'Daily','2022-04-01','2022-04-02 18:40:45','2022-04-03 18:40:45','768',10231742.55,10231742.55,'768','2022-04-02 19:11:07','768','2022-04-02 19:13:05',10,0),('21','228',13,'Daily','2022-04-02','2022-04-03 16:20:02','2022-04-04 16:20:02','768',10339599.65,10339599.65,'768','2022-04-03 18:18:32','768','2022-04-03 18:20:13',10,0),('21','228',14,'Daily','2022-04-03','2022-04-04 12:19:47','2022-04-05 12:19:47','768',9345833.80,9345833.80,'768','2022-04-04 12:26:40','768','2022-04-04 12:27:37',10,0),('21','228',15,'Daily','2022-04-04','2022-04-05 17:12:15','2022-04-06 17:12:15','768',11842330.25,11842330.25,'768','2022-04-06 14:19:28','768','2022-04-06 15:27:21',10,0),('21','228',16,'DAILY','2022-04-05','2022-04-06 15:41:12','2022-04-07 15:41:12','768',13868278.90,13868278.90,'768','2022-04-06 15:50:23','768','2022-04-07 15:52:24',10,0),('21','228',17,'DAILY','2022-04-06','2022-04-07 15:53:58','2022-04-08 15:53:58','768',18774097.70,18774097.70,'768','2022-04-07 17:51:27','768','2022-04-07 18:33:28',10,0),('21','228',18,'DAILY','2022-04-07','2022-04-08 12:25:14','2022-04-09 12:25:14','768',17504657.30,17504657.30,'768','2022-04-08 12:29:30','768','2022-04-08 12:44:47',10,0),('21','228',19,'DAILY','2022-04-08','2022-04-09 17:09:24','2022-04-10 17:09:24','768',0.00,0.00,'768','2022-04-10 18:16:36','768','2022-04-10 18:17:38',10,0),('21','228',20,'DAILY','2022-04-08','2022-04-10 18:24:15','2022-04-11 18:24:15','768',12315438.10,12315438.10,'768','2022-04-10 18:41:10','768','2022-04-10 19:55:18',10,0),('21','228',21,'DAILY','2022-04-09','2022-04-11 10:59:41','2022-04-12 10:59:41','768',12145864.90,12145864.90,'768','2022-04-11 11:05:03','768','2022-04-11 11:20:36',10,0),('21','228',22,'DAILY','2022-04-11','2022-04-11 14:24:24','2022-04-12 14:24:24','764',0.00,0.00,'768','2022-04-14 15:04:23','768','2022-04-14 15:04:37',10,0),('21','228',23,'DAILY','2022-04-10','2022-04-14 15:06:02','2022-04-15 15:06:02','768',11855818.75,11855818.75,'768','2022-04-14 15:21:02','768','2022-04-14 15:34:47',10,0),('21','228',24,'DAILY','2022-04-11','2022-04-14 15:43:45','2022-04-15 15:43:45','768',11267757.15,11267757.15,'768','2022-04-15 13:50:11','768','2022-04-15 14:05:17',10,0),('21','228',25,'DAILY','2022-04-12','2022-04-15 14:09:32','2022-04-16 14:09:32','768',9992156.10,9992156.10,'768','2022-04-15 14:14:06','768','2022-04-15 14:32:19',10,0),('21','228',26,'DAILY','2022-04-13','2022-04-15 14:48:11','2022-04-16 14:48:11','768',10223174.70,10223174.70,'768','2022-04-15 14:52:23','768','2022-04-15 16:13:45',10,0),('21','228',27,'DAILY','2022-04-14','2022-04-15 16:20:38','2022-04-16 16:20:38','768',11524084.55,11524084.55,'768','2022-04-15 16:26:12','768','2022-04-15 16:31:54',10,0),('21','228',28,'DAILY','2022-04-15','2022-04-16 18:35:59','2022-04-17 18:35:59','768',10441600.50,10441600.50,'768','2022-04-16 18:39:29','768','2022-04-16 18:46:29',10,0),('21','228',29,'DAILY','2022-04-16','2022-04-17 14:23:49','2022-04-18 14:23:49','768',10541319.25,10541319.25,'768','2022-04-17 14:28:21','768','2022-04-17 14:40:42',10,0),('21','228',30,'DAILY','2022-04-17','2022-04-18 20:11:48','2022-04-19 20:11:48','768',8560731.15,8560731.15,'768','2022-04-18 20:14:51','768','2022-04-18 20:24:35',10,0),('21','228',31,'DAILY','2022-04-18','2022-04-19 12:38:00','2022-04-20 12:38:00','768',11067576.50,11067576.50,'768','2022-04-19 13:06:30','768','2022-04-19 18:53:37',10,0),('21','228',32,'DAILY','2022-04-19','2022-04-20 18:49:19','2022-04-21 18:49:19','768',13822757.60,13822757.60,'768','2022-04-20 18:53:51','768','2022-04-20 19:20:44',10,0),('21','228',33,'DAILY','2022-04-20','2022-04-22 16:38:01','2022-04-23 16:38:01','768',14121093.63,14121093.63,'768','2022-04-22 16:43:53','768','2022-04-22 16:58:40',10,0),('21','228',34,'DAILY','2022-04-21','2022-04-22 17:00:53','2022-04-23 17:00:53','768',10759056.60,10759056.60,'768','2022-04-22 17:05:11','768','2022-04-22 17:46:27',10,0),('21','228',35,'DAILY','2022-04-22','2022-04-23 19:38:16','2022-04-24 19:38:16','768',13035106.25,13035106.25,'768','2022-04-23 19:46:12','768','2022-04-23 19:52:58',10,0),('21','228',36,'DAILY','2022-04-23','2022-04-24 19:39:02','2022-04-25 19:39:02','768',14673237.80,14673237.80,'768','2022-04-24 19:43:57','768','2022-04-26 19:12:49',10,0),('21','228',37,'DAILY','2022-04-24','2022-04-26 19:24:11','2022-04-27 19:24:11','768',11497581.90,11497581.90,'768','2022-04-26 19:30:27','768','2022-04-26 19:30:48',10,0),('21','228',38,'DAILY','2022-04-25','2022-04-26 20:21:26','2022-04-27 20:21:26','768',9772591.00,9772591.00,'768','2022-04-26 20:31:49','768','2022-04-26 20:32:11',10,0),('21','228',39,'DAILY','2022-04-26','2022-04-27 13:18:51','2022-04-28 13:18:51','768',12984635.60,12984635.60,'768','2022-04-27 13:25:46','768','2022-04-27 13:28:42',10,0),('21','228',40,'DAILY','2022-04-27','2022-04-28 20:40:00','2022-04-29 20:40:00','768',11649634.95,11649634.95,'768','2022-04-28 20:45:37','768','2022-04-28 20:45:59',10,0),('21','228',41,'DAILY','2022-04-28','2022-04-29 21:22:17','2022-04-30 21:22:17','768',12154179.40,12154179.40,'768','2022-04-29 21:27:03','768','2022-04-29 21:27:22',10,0),('21','228',42,'DAILY','2022-04-29','2022-04-30 11:33:13','2022-05-01 11:33:13','768',13775983.65,13775983.65,'768','2022-04-30 11:38:41','768','2022-04-30 12:27:44',10,0),('21','228',43,'Daily','2022-04-30','2022-05-01 21:48:06','2022-05-02 21:48:06','768',6493965.50,6493965.50,'768','2022-05-01 21:54:51','768','2022-05-01 21:55:31',10,0),('21','228',44,'DAILY','2022-05-01','2022-05-02 14:08:07','2022-05-03 14:08:07','768',5836990.20,5836990.20,'768','2022-05-02 14:17:48','768','2022-05-02 14:32:23',10,0),('21','228',45,'DAILY','2022-05-02','2022-05-03 09:53:43','2022-05-04 09:53:43','768',11859373.45,11859373.45,'768','2022-05-03 09:58:12','768','2022-05-03 09:58:34',10,0),('21','228',46,'DAILY','2022-05-03','2022-05-04 13:29:20','2022-05-05 13:29:20','768',5646762.85,5646762.85,'768','2022-05-04 13:35:29','768','2022-05-04 13:35:50',10,0),('21','228',47,'DAILY','2022-05-04','2022-05-05 13:38:42','2022-05-06 13:38:42','768',13767168.05,13767168.05,'768','2022-05-05 13:56:11','768','2022-05-05 13:57:02',10,0),('21','228',48,'DAILY','2022-05-05','2022-05-06 13:03:07','2022-05-07 13:03:07','768',15876913.40,15876913.40,'768','2022-05-06 13:12:35','768','2022-05-06 13:12:56',10,0),('21','228',49,'DAILY','2022-05-06','2022-05-07 13:30:50','2022-05-08 13:30:50','768',13937680.55,13937680.55,'768','2022-05-07 13:48:03','768','2022-05-07 13:48:24',10,0),('21','228',50,'DAILY','2022-05-07','2022-05-09 17:52:50','2022-05-10 17:52:50','768',12228485.10,12327679.10,'768','2022-05-09 17:57:25','768','2022-05-09 17:57:43',10,0),('21','228',51,'DAILY','2022-05-08','2022-05-09 18:17:51','2022-05-10 18:17:51','768',10930096.45,10995732.45,'768','2022-05-09 19:37:34','768','2022-05-09 19:37:55',10,0),('21','228',52,'DAILY','2022-05-09','2022-05-10 19:29:23','2022-05-11 19:29:23','768',3444020.50,3552679.50,'768','2022-05-10 19:36:58','768','2022-05-10 19:37:12',10,0),('21','228',53,'DAILY','2022-05-10','2022-05-11 18:23:16','2022-05-12 18:23:16','768',10311484.70,10442526.70,'768','2022-05-11 18:26:20','768','2022-05-11 18:26:36',10,0),('21','228',54,'Daily','2022-05-12','2022-05-12 11:12:44','2022-05-13 11:12:44','764',0.00,0.00,'768','2022-05-12 22:14:50','768','2022-05-12 22:15:07',10,0),('21','228',55,'DAILY','2022-05-11','2022-05-13 15:17:34','2022-05-14 15:17:34','768',11162537.89,11162537.89,'768','2022-05-13 15:21:07','768','2022-05-13 15:21:44',10,0),('21','228',56,'DAILY','2022-05-12','2022-05-13 15:43:31','2022-05-14 15:43:31','768',7765782.75,7765782.75,'768','2022-05-13 15:48:22','768','2022-05-13 15:48:36',10,0),('21','228',57,'DAILY','2022-05-13','2022-05-14 20:37:52','2022-05-15 20:37:52','768',13565605.05,13565605.05,'768','2022-05-14 20:54:07','768','2022-05-14 20:54:33',10,0),('21','228',58,'DAILY','2022-05-14','2022-05-15 19:24:51','2022-05-16 19:24:51','768',12439750.00,12439750.00,'768','2022-05-15 19:35:18','768','2022-05-15 19:35:40',10,0),('21','228',59,'DAILY','2022-05-15','2022-05-16 13:49:25','2022-05-17 13:49:25','768',14594686.80,14594686.80,'768','2022-05-16 13:54:17','768','2022-05-16 13:55:31',10,0),('21','228',60,'DAILY','2022-05-16','2022-05-17 11:57:35','2022-05-18 11:57:35','768',11367110.45,11367110.45,'768','2022-05-17 12:00:01','768','2022-05-17 12:00:26',10,0),('21','228',61,'DAILY','2022-05-17','2022-05-18 16:20:05','2022-05-19 16:20:05','768',17164419.40,17164419.40,'768','2022-05-18 16:44:34','768','2022-05-18 16:45:57',10,0),('21','228',62,'DAILY','2022-05-18','2022-05-19 18:55:50','2022-05-20 18:55:50','768',12597762.35,12597762.35,'768','2022-05-19 18:59:00','768','2022-05-19 19:01:29',10,0),('21','228',63,'DAILY','2022-05-19','2022-05-20 21:11:50','2022-05-21 21:11:50','768',12628130.00,12628130.00,'768','2022-05-20 21:17:33','768','2022-05-20 21:18:25',10,0),('21','228',64,'DAILY','2022-05-20','2022-05-21 11:21:32','2022-05-22 11:21:32','768',9090558.45,9090558.45,'768','2022-05-21 11:25:28','768','2022-05-21 11:26:03',10,0),('21','228',65,'DAILY','2022-05-21','2022-05-22 15:15:35','2022-05-23 15:15:35','768',12720321.70,12720321.70,'768','2022-05-22 15:19:43','768','2022-05-22 15:20:43',10,0),('21','228',66,'DAILY','2022-05-22','2022-05-23 19:03:26','2022-05-24 19:03:26','768',9842586.20,9842586.20,'768','2022-05-23 19:08:05','768','2022-05-23 19:08:20',10,0),('21','228',67,'DAILY','2022-05-23','2022-05-24 19:21:09','2022-05-25 19:21:09','768',13214388.45,13214388.45,'768','2022-05-24 19:25:47','768','2022-05-24 19:26:10',10,0),('21','228',68,'DAILY','2022-05-24','2022-05-25 18:17:37','2022-05-26 18:17:37','768',10526579.80,10526579.80,'768','2022-05-25 19:25:49','768','2022-05-25 19:26:10',10,0),('21','228',69,'DAILY','2022-05-25','2022-05-26 17:08:51','2022-05-27 17:08:51','768',11155933.25,11155933.25,'768','2022-05-26 17:19:43','768','2022-05-26 17:20:27',10,0),('21','228',70,'DAILY','2022-05-26','2022-05-27 14:32:30','2022-05-28 14:32:30','768',14319878.75,14319878.75,'768','2022-05-27 14:35:24','768','2022-05-27 14:36:35',10,0),('21','228',71,'DAILY','2022-05-27','2022-05-28 13:44:16','2022-05-29 13:44:16','768',7873243.85,7873243.85,'768','2022-05-28 13:54:45','768','2022-05-28 13:55:45',10,0),('21','228',72,'DAILY','2022-05-28','2022-05-29 21:39:49','2022-05-30 21:39:49','768',14968593.20,14968593.20,'768','2022-05-29 21:47:08','768','2022-05-29 21:47:39',10,0),('21','228',73,'DAILY','2022-05-29','2022-05-30 19:41:45','2022-05-31 19:41:45','768',10113058.25,10113058.25,'768','2022-05-30 19:47:25','768','2022-05-30 19:48:24',10,0),('21','228',74,'DAILY','2022-05-30','2022-05-31 15:16:20','2022-06-01 15:16:20','768',11701216.65,11701216.65,'768','2022-05-31 15:40:52','768','2022-05-31 15:41:10',10,0),('21','228',75,'DAILY','2022-05-31','2022-06-01 20:31:20','2022-06-02 20:31:20','768',9137864.60,9137864.60,'768','2022-06-01 20:47:35','768','2022-06-01 20:47:54',10,0),('21','228',76,'DAILY','2022-06-01','2022-06-02 16:22:05','2022-06-03 16:22:05','768',14163300.10,14163300.10,'768','2022-06-02 16:36:21','768','2022-06-02 16:40:38',10,0),('21','228',77,'DAILY','2022-06-02','2022-06-03 16:12:44','2022-06-04 16:12:44','768',10615832.05,10615832.05,'768','2022-06-03 16:15:16','768','2022-06-03 16:16:44',10,0),('21','228',78,'DAILY','2022-06-03','2022-06-04 13:20:45','2022-06-05 13:20:45','768',10897007.00,10897007.00,'768','2022-06-04 13:23:40','768','2022-06-04 13:24:08',10,0),('21','228',79,'DAILY','2022-06-04','2022-06-05 20:46:53','2022-06-06 20:46:53','768',12797566.25,12797566.25,'768','2022-06-06 17:34:50','768','2022-06-06 17:35:15',10,0),('21','228',80,'DAILY','2022-06-05','2022-06-06 18:02:15','2022-06-07 18:02:15','768',9670668.10,9670668.10,'768','2022-06-06 18:05:29','768','2022-06-06 18:05:56',10,0),('21','228',81,'DAILY','2022-06-06','2022-06-07 18:07:55','2022-06-08 18:07:55','768',9794398.80,9794398.80,'768','2022-06-07 18:12:40','768','2022-06-07 18:12:57',10,0),('21','228',82,'DAILY','2022-06-07','2022-06-08 17:57:34','2022-06-09 17:57:34','768',20110976.81,20110976.81,'768','2022-06-08 18:30:59','768','2022-06-08 18:31:15',10,0),('21','228',83,'DAILY','2022-06-08','2022-06-09 21:04:15','2022-06-10 21:04:15','768',12070559.70,12070559.70,'768','2022-06-09 21:10:04','768','2022-06-09 21:10:22',10,0),('21','228',84,'DAILY','2022-06-09','2022-06-10 15:40:21','2022-06-11 15:40:21','768',11117505.80,11117505.80,'768','2022-06-10 15:45:29','768','2022-06-10 15:49:43',10,0),('21','228',85,'DAILY','2022-06-10','2022-06-11 15:43:12','2022-06-12 15:43:12','768',12808802.75,12808802.75,'768','2022-06-11 15:46:16','768','2022-06-11 15:46:30',10,0),('21','228',86,'DAILY','2022-06-11','2022-06-12 19:44:43','2022-06-13 19:44:43','768',17305366.85,17305366.85,'768','2022-06-12 19:48:10','768','2022-06-12 19:48:28',10,0),('21','228',87,'DAILY','2022-06-12','2022-06-13 15:13:39','2022-06-14 15:13:39','768',7941239.15,7941239.15,'768','2022-06-13 15:20:58','768','2022-06-13 15:22:18',10,0),('21','228',88,'DAILY','2022-06-13','2022-06-14 21:08:10','2022-06-15 21:08:10','768',11189169.80,11189169.80,'768','2022-06-14 21:16:41','768','2022-06-14 21:16:58',10,0),('21','228',89,'DAILY','2022-06-14','2022-06-15 21:44:04','2022-06-16 21:44:04','768',13625760.15,13625760.15,'768','2022-06-15 21:50:25','768','2022-06-15 21:51:38',10,0),('21','228',90,'DAILY','2022-06-15','2022-06-16 21:59:06','2022-06-17 21:59:06','768',12908100.25,12908100.25,'768','2022-06-16 22:03:13','768','2022-06-16 22:03:46',10,0),('21','228',91,'DAILY','2022-06-16','2022-06-18 21:05:57','2022-06-19 21:05:57','768',12283502.90,12283502.90,'768','2022-06-18 21:09:58','768','2022-06-18 21:10:39',10,0),('21','228',92,'DAILY','2022-06-17','2022-06-18 21:20:43','2022-06-19 21:20:43','768',0.00,0.00,'768','2022-06-18 21:44:20','768','2022-06-18 21:44:38',10,0),('21','228',93,'DAILY','2022-06-17','2022-06-18 21:45:43','2022-06-19 21:45:43','768',14553914.40,14553914.40,'768','2022-06-18 21:53:03','768','2022-06-18 21:53:21',10,0),('21','228',94,'DAILY','2022-06-18','2022-06-19 19:28:03','2022-06-20 19:28:03','768',11509228.25,11509228.25,'768','2022-06-19 19:34:37','768','2022-06-19 19:34:57',10,0),('21','228',95,'DAILY','2022-06-19','2022-06-20 17:09:06','2022-06-21 17:09:06','768',11883160.20,11883160.20,'768','2022-06-20 17:22:40','768','2022-06-20 17:22:59',10,0),('21','228',96,'DAILY','2022-06-20','2022-06-21 18:09:53','2022-06-22 18:09:53','768',10395944.20,10395944.20,'768','2022-06-21 18:18:11','768','2022-06-21 18:18:27',10,0),('21','228',97,'DAILY','2022-06-21','2022-06-23 15:47:46','2022-06-24 15:47:46','768',9463478.60,9463478.60,'768','2022-06-23 16:07:39','768','2022-06-23 16:08:23',10,0),('21','228',98,'DAILY','2022-06-22','2022-06-23 16:26:06','2022-06-24 16:26:06','768',5888438.00,5888438.00,'768','2022-06-23 16:28:36','768','2022-06-23 16:29:17',10,0),('21','228',99,'DAILY','2022-06-23','2022-06-25 18:55:39','2022-06-26 18:55:39','768',14338582.35,14338582.35,'768','2022-06-25 19:00:19','768','2022-06-25 19:00:37',10,0),('21','228',100,'DAILY','2022-06-24','2022-06-25 19:38:02','2022-06-26 19:38:02','768',7287342.30,7287342.30,'768','2022-06-25 19:42:57','768','2022-06-25 19:43:13',10,0),('21','228',101,'DAILY','2022-06-24','2022-06-25 19:46:37','2022-06-26 19:46:37','768',9776076.70,9776076.70,'768','2022-06-27 19:42:59','768','2022-06-27 19:44:44',10,0),('21','228',102,'DAILY','2022-06-26','2022-06-27 20:39:41','2022-06-28 20:39:41','768',5714496.50,5714496.50,'768','2022-06-27 20:47:41','768','2022-06-27 20:50:01',10,0),('21','228',103,'DAILY','2022-06-27','2022-06-29 13:50:14','2022-06-30 13:50:14','768',12720008.40,12720008.40,'768','2022-06-29 13:54:28','768','2022-06-29 13:54:50',10,0),('21','228',104,'DAILY','2022-06-28','2022-06-29 14:07:36','2022-06-30 14:07:36','768',6041764.25,6041764.25,'768','2022-06-29 14:10:47','768','2022-06-29 14:14:29',10,0),('21','228',105,'DAILY','2022-06-29','2022-06-30 18:15:44','2022-07-01 18:15:44','768',11633289.35,11633289.35,'768','2022-06-30 18:18:47','768','2022-06-30 18:19:02',10,0),('21','228',106,'DAILY','2022-06-30','2022-07-01 21:03:51','2022-07-02 21:03:51','768',12705647.60,12705647.60,'768','2022-07-01 21:11:48','768','2022-07-01 21:12:47',10,0),('21','228',107,'DAILY','2022-07-01','2022-07-02 16:03:07','2022-07-03 16:03:07','768',13439793.60,13439793.60,'768','2022-07-02 16:09:46','768','2022-07-02 16:10:02',10,0),('21','228',108,'DAILY','2022-07-02','2022-07-03 18:15:30','2022-07-04 18:15:30','768',11013351.50,11013351.50,'768','2022-07-03 18:19:22','768','2022-07-03 18:20:31',10,0),('21','228',109,'DAILY','2022-07-03','2022-07-04 19:36:33','2022-07-05 19:36:33','768',4731285.30,4731285.30,'768','2022-07-04 19:42:53','768','2022-07-04 19:43:11',10,0),('21','228',110,'DAILY','2022-07-04','2022-07-08 15:50:48','2022-07-09 15:50:48','768',12659620.90,12659620.90,'768','2022-07-08 15:55:20','768','2022-07-08 15:56:48',10,0),('21','228',111,'DAILY','2022-07-05','2022-07-08 16:09:51','2022-07-09 16:09:51','768',10164559.05,10164559.05,'768','2022-07-08 16:13:01','768','2022-07-08 16:13:22',10,0),('21','228',112,'DAILY','2022-07-06','2022-07-08 16:25:05','2022-07-09 16:25:05','768',10537678.25,10537678.25,'768','2022-07-08 16:29:16','768','2022-07-08 16:29:34',10,0),('21','228',113,'DAILY','2022-07-07','2022-07-08 16:40:02','2022-07-09 16:40:02','768',13645429.90,13645429.90,'768','2022-07-08 16:43:19','768','2022-07-08 16:43:51',10,0),('21','228',114,'DAILY','2022-07-08','2022-07-09 14:16:27','2022-07-10 14:16:27','768',6239613.45,6239613.45,'768','2022-07-09 14:25:53','768','2022-07-09 14:26:20',10,0),('21','228',115,'DAILY','2022-07-09','2022-07-10 18:43:11','2022-07-11 18:43:11','768',3015837.80,3015837.80,'768','2022-07-10 18:44:53','768','2022-07-10 18:51:43',10,0),('21','228',116,'Daily','2022-07-10','2022-07-11 19:07:51','2022-07-12 19:07:51','768',1424526.00,1424526.00,'768','2022-07-11 19:10:09','768','2022-07-11 19:10:35',10,0),('21','228',117,'DAILY','2022-07-11','2022-07-12 21:11:06','2022-07-13 21:11:06','768',14338943.80,14338943.80,'768','2022-07-12 21:22:08','768','2022-07-12 21:25:55',10,0),('21','228',118,'DAILY','2022-07-12','2022-07-13 19:28:40','2022-07-14 19:28:40','768',12376985.15,12376985.15,'768','2022-07-13 20:02:44','768','2022-07-13 20:04:35',10,0),('21','228',119,'DAILY','2022-07-13','2022-07-14 17:00:38','2022-07-15 17:00:38','768',14379243.20,14379243.20,'768','2022-07-14 17:10:43','768','2022-07-14 17:10:59',10,0),('21','228',120,'DAILY','2022-07-14','2022-07-15 18:35:58','2022-07-16 18:35:58','768',10512478.30,10512478.30,'768','2022-07-15 18:40:15','768','2022-07-15 18:40:41',10,0),('21','228',121,'DAILY','2022-07-15','2022-07-16 20:27:47','2022-07-17 20:27:47','768',10566871.20,10566871.20,'768','2022-07-16 20:34:19','768','2022-07-16 20:34:50',10,0),('21','228',122,'DAILY','2022-07-16','2022-07-19 19:26:52','2022-07-20 19:26:52','768',10916803.15,11284983.45,'768','2022-07-19 19:30:20','768','2022-07-19 19:30:36',10,0),('21','228',123,'DAILY','2022-07-17','2022-07-19 19:45:41','2022-07-20 19:45:41','768',1590142.30,1590142.30,'768','2022-07-19 19:46:53','768','2022-07-19 19:47:12',10,0),('21','228',124,'DAILY','2022-07-18','2022-07-19 19:59:47','2022-07-20 19:59:47','768',4791124.90,4791124.90,'768','2022-07-19 20:01:05','768','2022-07-19 20:01:20',10,0),('21','228',125,'DAILY','2022-07-19','2022-07-21 14:41:41','2022-07-22 14:41:41','768',12577414.70,12577414.70,'768','2022-07-21 14:53:58','768','2022-07-21 14:54:12',10,0),('21','228',126,'DAILY','2022-07-20','2022-07-21 15:05:44','2022-07-22 15:05:44','768',8220268.20,8160301.35,'768','2022-07-21 15:10:17','768','2022-07-21 15:10:32',10,0),('21','228',127,'DAILY','2022-07-21','2022-07-22 19:52:26','2022-07-23 19:52:26','768',11632653.75,11632653.75,'768','2022-07-22 20:01:00','768','2022-07-22 20:01:16',10,0),('21','228',128,'DAILY','2022-07-22','2022-07-23 20:43:49','2022-07-24 20:43:49','768',2276414.30,2276414.30,'768','2022-07-23 20:45:07','768','2022-07-23 20:45:51',10,0),('21','228',129,'DAILY','2022-07-23','2022-07-24 17:49:17','2022-07-25 17:49:17','768',8183696.10,8183696.10,'768','2022-07-24 17:56:21','768','2022-07-24 17:56:37',10,0),('21','228',130,'DAILY','2022-07-24','2022-07-25 15:24:09','2022-07-26 15:24:09','768',8659284.15,8659284.15,'768','2022-07-25 15:27:51','768','2022-07-25 15:28:06',10,0),('21','228',131,'DAILY','2022-07-25','2022-07-26 14:47:21','2022-07-27 14:47:21','768',14766001.15,14766001.15,'768','2022-07-26 14:51:50','768','2022-07-26 14:53:22',10,0),('21','228',132,'DAILY','2022-07-26','2022-07-27 17:04:15','2022-07-28 17:04:15','768',0.00,0.00,'768','2022-07-27 18:23:29','768','2022-07-27 18:23:43',10,0),('21','228',133,'DAILY','2022-07-26','2022-07-27 18:52:02','2022-07-28 18:52:02','768',11495470.95,11495470.95,'768','2022-07-27 18:56:26','768','2022-07-27 18:56:43',10,0),('21','228',134,'DAILY','2022-07-27','2022-07-28 19:38:42','2022-07-29 19:38:42','768',14904225.35,14904225.35,'768','2022-07-28 19:44:30','768','2022-07-28 19:44:45',10,0),('21','228',135,'DAILY','2022-07-28','2022-07-29 20:20:01','2022-07-30 20:20:01','768',9951480.25,9951480.25,'768','2022-07-29 20:25:19','768','2022-07-29 20:31:25',10,0),('21','228',136,'DAILY','2022-07-29','2022-07-30 15:44:54','2022-07-31 15:44:54','768',11078391.05,11078391.05,'768','2022-07-30 15:53:17','768','2022-07-30 15:55:05',10,0),('21','228',137,'DAILY','2022-07-30','2022-07-31 16:13:23','2022-08-01 16:13:23','768',7966282.20,7966282.20,'768','2022-07-31 16:26:46','768','2022-07-31 16:27:14',10,0),('21','228',138,'DAILY','2022-07-31','2022-08-01 17:06:41','2022-08-02 17:06:41','768',5551347.50,5551347.50,'768','2022-08-01 17:15:34','768','2022-08-01 17:16:02',10,0),('21','228',139,'DAILY','2022-08-01','2022-08-02 13:52:12','2022-08-03 13:52:12','768',8380541.65,8380541.65,'768','2022-08-02 14:04:40','768','2022-08-02 14:10:16',10,0),('21','228',140,'DAILY','2022-08-02','2022-08-03 13:58:51','2022-08-04 13:58:51','768',5497020.40,5497020.40,'768','2022-08-03 14:03:11','768','2022-08-03 14:03:25',10,0),('21','228',141,'DAILY','2022-08-03','2022-08-04 16:43:28','2022-08-05 16:43:28','768',14323648.35,14323648.35,'768','2022-08-04 16:48:58','768','2022-08-04 16:49:35',10,0),('21','228',142,'DAILY','2022-08-04','2022-08-05 17:26:04','2022-08-06 17:26:04','768',7717681.90,7717681.90,'768','2022-08-05 17:29:58','768','2022-08-05 17:30:34',10,0),('21','228',143,'DAILY','2022-08-05','2022-08-06 17:22:35','2022-08-07 17:22:35','768',2888217.00,2888217.00,'768','2022-08-06 17:23:26','768','2022-08-06 17:23:52',10,0),('21','228',144,'DAILY','2022-08-06','2022-08-07 17:47:47','2022-08-08 17:47:47','768',11084392.05,11084392.05,'768','2022-08-07 18:00:40','768','2022-08-07 18:03:11',10,0),('21','228',145,'DAILY','2022-08-07','2022-08-08 17:33:33','2022-08-09 17:33:33','768',4715442.90,4715442.90,'768','2022-08-08 17:40:46','768','2022-08-08 17:41:29',10,0),('21','228',146,'DAILY','2022-08-08','2022-08-09 19:25:10','2022-08-10 19:25:10','768',7337901.10,7337901.10,'768','2022-08-09 19:31:05','768','2022-08-09 19:31:23',10,0),('21','228',147,'DAILY','2022-08-09','2022-08-10 19:42:39','2022-08-11 19:42:39','768',11343143.25,11343143.25,'768','2022-08-10 19:59:43','768','2022-08-10 20:00:58',10,0),('21','228',148,'DAILY','2022-08-11','2022-08-11 18:40:20','2022-08-12 18:40:20','768',0.00,0.00,'768','2022-08-11 19:11:22','768','2022-08-11 19:12:01',10,0),('21','228',149,'DAILY','2022-08-10','2022-08-11 19:12:38','2022-08-12 19:12:38','768',5603689.00,5603689.00,'768','2022-08-11 19:24:10','768','2022-08-11 19:26:13',10,0),('21','228',150,'Daily','2022-08-11','2022-08-14 15:10:49','2022-08-15 15:10:49','768',14470121.15,14470121.15,'768','2022-08-14 15:20:47','768','2022-08-14 15:21:08',10,0),('21','228',151,'Daily','2022-08-12','2022-08-14 16:09:11','2022-08-15 16:09:11','768',12057298.75,12057298.75,'768','2022-08-14 16:17:30','768','2022-08-14 16:18:35',10,0),('21','228',152,'Daily','2022-08-13','2022-08-14 16:39:28','2022-08-15 16:39:28','768',6022894.70,6022894.70,'768','2022-08-14 16:48:24','768','2022-08-14 16:48:47',10,0),('21','228',153,'Daily','2022-08-14','2022-08-15 17:29:51','2022-08-16 17:29:51','768',4240671.85,4240671.85,'768','2022-08-15 17:37:31','768','2022-08-15 17:38:13',10,0),('21','228',154,'Daily','2022-08-15','2022-08-16 18:18:52','2022-08-17 18:18:52','768',6175823.70,6175823.70,'768','2022-08-16 18:24:52','768','2022-08-16 18:26:04',10,0),('21','228',155,'Daily','2022-08-16','2022-08-17 19:07:39','2022-08-18 19:07:39','768',4188121.00,4188121.00,'768','2022-08-17 19:10:27','768','2022-08-17 19:10:56',10,0),('21','228',156,'Daily','2022-08-17','2022-08-18 16:53:45','2022-08-19 16:53:45','768',9975311.55,9975311.55,'768','2022-08-18 17:43:07','768','2022-08-18 17:43:33',10,0),('21','228',157,'Daily','2022-08-18','2022-08-19 21:02:35','2022-08-20 21:02:35','768',9045941.45,9045941.45,'768','2022-08-19 21:10:29','768','2022-08-19 21:10:54',10,0),('21','228',158,'Daily','2022-08-19','2022-08-21 18:33:04','2022-08-22 18:33:04','768',12604198.75,12604198.75,'768','2022-08-21 18:47:54','768','2022-08-21 18:48:34',10,0),('21','228',159,'Daily','2022-08-20','2022-08-21 19:05:06','2022-08-22 19:05:06','768',13111959.55,13111959.55,'768','2022-08-21 19:13:01','768','2022-08-21 19:13:38',10,0),('21','228',160,'Daily','2022-08-21','2022-08-22 19:08:33','2022-08-23 19:08:33','768',4161542.25,4161542.25,'768','2022-08-22 19:17:31','768','2022-08-22 19:17:57',10,0),('21','228',161,'Daily','2022-08-22','2022-08-24 20:20:31','2022-08-25 20:20:31','768',7768640.55,7768640.55,'768','2022-08-24 20:39:34','768','2022-08-24 20:41:00',10,0),('21','228',162,'Daily','2022-08-23','2022-08-24 21:01:39','2022-08-25 21:01:39','768',10896749.50,10896749.50,'768','2022-08-24 21:11:36','768','2022-08-24 21:12:02',10,0),('21','228',163,'Daily','2022-08-24','2022-08-25 19:18:39','2022-08-26 19:18:39','768',13248753.45,13248753.45,'768','2022-08-25 19:27:28','768','2022-08-25 19:28:23',10,0),('21','228',164,'Daily','2022-08-25','2022-08-27 19:10:21','2022-08-28 19:10:21','768',12820183.15,12820183.15,'768','2022-08-27 19:23:16','768','2022-08-27 19:24:21',10,0),('21','228',165,'Daily','2022-08-26','2022-08-27 21:06:46','2022-08-28 21:06:46','768',11788853.75,11788853.75,'768','2022-08-27 21:23:24','768','2022-08-27 21:29:16',10,0),('21','228',166,'Daily','2022-08-27','2022-08-28 14:10:41','2022-08-29 14:10:41','768',3291374.90,3291374.90,'768','2022-08-28 14:14:54','768','2022-08-28 14:15:24',10,0),('21','228',167,'Daily','2022-08-28','2022-08-29 18:17:06','2022-08-30 18:17:06','768',1520313.40,1520313.40,'768','2022-08-29 18:18:18','768','2022-08-29 18:18:37',10,0),('21','228',168,'Daily','2022-08-29','2022-08-30 21:14:41','2022-08-31 21:14:41','768',12388091.75,12388091.75,'768','2022-08-30 21:23:44','768','2022-08-30 21:24:27',10,0),('21','228',169,'Daily','2022-08-30','2022-09-01 15:16:44','2022-09-02 15:16:44','768',12851758.90,12851758.90,'768','2022-09-01 15:33:16','768','2022-09-01 15:33:49',10,0),('21','228',170,'Daily','2022-08-31','2022-09-01 17:24:48','2022-09-02 17:24:48','768',10076649.90,10076649.90,'768','2022-09-01 17:51:07','768','2022-09-01 17:59:29',10,0),('21','228',171,'Daily','2022-09-01','2022-09-02 18:28:53','2022-09-03 18:28:53','768',14118162.45,14118162.45,'768','2022-09-02 18:37:01','768','2022-09-02 18:37:59',10,0),('21','228',172,'Daily','2022-09-02','2022-09-03 21:29:21','2022-09-04 21:29:21','768',8146753.00,8146753.00,'768','2022-09-03 21:35:59','768','2022-09-03 21:36:42',10,0),('21','228',173,'Daily','2022-09-07','2022-09-07 16:36:08','2022-09-08 16:36:08','768',0.00,0.00,'768','2022-09-07 16:48:09','768','2022-09-07 16:49:11',10,0),('21','228',174,'Daily','2022-09-03','2022-09-07 16:50:00','2022-09-08 16:50:00','768',18027801.25,18027801.25,'768','2022-09-07 17:15:29','768','2022-09-07 20:59:38',10,0),('21','228',175,'Daily','2022-09-04','2022-09-08 13:14:28','2022-09-09 13:14:28','768',10833850.80,10833850.80,'768','2022-09-08 13:36:12','768','2022-09-08 14:12:34',10,0),('21','228',176,'Daily','2022-09-05','2022-09-08 14:15:06','2022-09-09 14:15:06','768',9608169.10,9608169.10,'768','2022-09-08 14:41:29','768','2022-09-08 15:13:17',10,0),('21','228',177,'Daily','2022-09-06','2022-09-08 15:19:14','2022-09-09 15:19:14','768',3071972.60,3071972.60,'768','2022-09-08 15:26:12','768','2022-09-08 15:49:21',10,0),('21','228',178,'Daily','2022-09-07','2022-09-08 15:50:16','2022-09-09 15:50:16','768',15879799.70,15879799.70,'768','2022-09-08 16:52:03','768','2022-09-08 17:19:34',10,0),('21','228',179,'Daily','2022-09-08','2022-09-09 15:43:28','2022-09-10 15:43:28','768',14962170.75,14962170.75,'768','2022-09-09 16:01:01','768','2022-09-09 16:43:04',10,0),('21','228',180,'Daily','2022-09-09','2022-09-10 17:01:41','2022-09-11 17:01:41','768',13618850.75,13618850.75,'768','2022-09-10 17:18:17','768','2022-09-10 17:35:46',10,0),('21','228',181,'Daily','2022-09-10','2022-09-12 16:49:23','2022-09-13 16:49:23','768',13440540.00,13440540.00,'768','2022-09-12 17:09:07','768','2022-09-12 17:44:12',10,0),('21','228',182,'Daily','2022-09-11','2022-09-12 17:55:35','2022-09-13 17:55:35','768',12716028.50,12716028.50,'768','2022-09-12 18:19:11','768','2022-09-12 18:45:33',10,0),('21','228',183,'Daily','2022-09-12','2022-09-13 16:59:58','2022-09-14 16:59:58','768',14240320.30,14240320.30,'768','2022-09-13 17:20:06','768','2022-09-13 17:38:47',10,0),('21','228',184,'DAILY','2022-09-13','2022-09-15 16:26:01','2022-09-16 16:26:01','768',12724170.20,12724170.20,'768','2022-09-15 16:41:12','768','2022-09-15 17:20:00',10,0),('21','228',185,'DAILY','2022-09-14','2022-09-15 17:32:39','2022-09-16 17:32:39','768',13303258.50,13303258.50,'768','2022-09-16 17:01:51','768','2022-09-16 17:10:33',10,0),('21','228',186,'Daily','2022-09-15','2022-09-16 18:41:44','2022-09-17 18:41:44','768',7254297.25,7380515.65,'768','2022-09-16 18:49:40','768','2022-09-16 18:50:00',10,0),('21','228',187,'Daily','2022-09-16','2022-09-18 15:38:04','2022-09-19 15:38:04','768',6503738.50,6731363.80,'768','2022-09-18 15:42:27','768','2022-09-18 15:52:19',10,0),('21','228',188,'Daily','2022-09-17','2022-09-18 16:43:53','2022-09-19 16:43:53','768',15075234.25,15296643.55,'768','2022-09-18 17:00:48','768','2022-09-18 17:22:32',10,0),('21','228',189,'Daily','2022-09-18','2022-09-19 17:50:35','2022-09-20 17:50:35','768',13251362.25,13393681.35,'768','2022-09-19 18:07:49','768','2022-09-19 18:31:53',10,0),('21','228',190,'Daily','2022-09-19','2022-09-20 19:13:21','2022-09-21 19:13:21','768',11371038.25,11467619.35,'768','2022-09-20 19:29:22','768','2022-09-20 19:51:23',10,0),('21','228',191,'Daily','2022-09-20','2022-09-21 21:39:48','2022-09-22 21:39:48','768',9946630.00,9946630.00,'768','2022-09-21 21:52:14','768','2022-09-21 22:13:50',10,0),('21','228',192,'Daily','2022-09-21','2022-09-23 12:36:39','2022-09-24 12:36:39','768',12610089.45,12610089.45,'768','2022-09-23 12:52:02','768','2022-09-23 13:13:36',10,0),('21','228',193,'Daily','2022-09-22','2022-09-23 13:27:46','2022-09-24 13:27:46','768',12108080.40,12108080.40,'768','2022-09-23 14:26:08','768','2022-09-23 14:52:16',10,0),('21','228',194,'Daily','2022-09-23','2022-09-24 13:42:15','2022-09-25 13:42:15','768',10009498.95,10009498.95,'768','2022-09-24 13:55:19','768','2022-09-24 14:12:57',10,0),('21','228',195,'Daily','2022-09-24','2022-09-25 19:42:57','2022-09-26 19:42:57','768',7925981.20,7925981.20,'768','2022-09-25 20:14:54','768','2022-09-25 20:41:44',10,0),('21','228',196,'Daily','2022-09-25','2022-09-26 20:34:34','2022-09-27 20:34:34','768',6774558.20,6774558.20,'768','2022-09-26 20:48:39','768','2022-09-26 21:39:07',10,0),('21','228',197,'Daily','2022-09-26','2022-09-27 13:41:33','2022-09-28 13:41:33','768',9703507.35,9703507.35,'768','2022-09-27 13:59:36','768','2022-09-27 14:27:00',10,0),('21','228',198,'Daily','2022-09-27','2022-09-28 17:05:10','2022-09-29 17:05:10','768',12040489.30,12040489.30,'768','2022-09-28 17:18:35','768','2022-09-28 17:54:10',10,0),('21','228',199,'Daily','2022-09-28','2022-09-29 21:40:40','2022-09-30 21:40:40','768',11167685.65,11167685.65,'768','2022-09-29 21:47:55','768','2022-09-29 21:48:22',10,0),('21','228',200,'DAILY','2022-09-29','2022-10-12 17:13:27','2022-10-13 17:13:27','768',12329359.65,12329359.65,'768','2022-10-12 17:47:21','768','2022-10-12 17:48:26',10,0),('21','228',201,'DAILY','2022-09-30','2022-10-12 18:15:42','2022-10-13 18:15:42','768',12310722.60,12310722.60,'768','2022-10-12 18:19:57','768','2022-10-12 18:20:11',10,0),('21','228',202,'DAILY','2022-10-01','2022-10-16 19:04:40','2022-10-17 19:04:40','768',10758285.30,10758285.30,'768','2022-10-16 19:08:50','768','2022-10-16 19:09:09',10,0),('21','228',203,'DAILY','2022-10-02','2022-10-16 19:26:56','2022-10-17 19:26:56','768',10045500.35,10045500.35,'768','2022-10-16 19:34:43','768','2022-10-16 19:35:07',10,0),('21','228',204,'DAILY','2022-10-03','2022-10-17 08:01:50','2022-10-18 08:01:50','768',9053792.70,9053792.70,'768','2022-10-17 08:05:11','768','2022-10-17 08:05:25',10,0),('21','228',205,'DAILY','2022-10-04','2022-10-17 08:35:34','2022-10-18 08:35:34','768',9975934.60,9975934.60,'768','2022-10-17 08:38:31','768','2022-10-17 08:38:53',10,0),('21','228',206,'DAILY','2022-10-05','2022-10-17 08:41:10','2022-10-18 08:41:10','768',4194725.55,4194725.55,'768','2022-10-17 08:42:52','768','2022-10-17 08:43:06',10,0),('21','228',207,'DAILY','2022-10-06','2022-10-17 08:43:51','2022-10-18 08:43:51','768',10937862.10,10937862.10,'768','2022-10-17 12:28:15','768','2022-10-17 12:29:50',10,0),('21','228',208,'DAILY','2022-10-07','2022-10-18 08:53:40','2022-10-19 08:53:40','768',4357240.70,4357240.70,'768','2022-10-18 08:56:55','768','2022-10-18 08:57:09',10,0),('21','228',209,'DAILY','2022-10-08','2022-10-18 08:57:43','2022-10-19 08:57:43','768',5813568.55,5813568.55,'768','2022-10-18 09:57:46','768','2022-10-18 09:58:13',10,0),('21','228',210,'DAILY','2022-10-09','2022-10-18 09:59:11','2022-10-19 09:59:11','768',11951063.45,11951063.45,'768','2022-10-18 10:21:45','768','2022-10-18 10:22:10',10,0),('21','228',211,'DAILY','2022-10-10','2022-10-18 10:36:33','2022-10-19 10:36:33','768',7851362.85,7851362.85,'768','2022-10-18 10:39:50','768','2022-10-18 10:40:03',10,0),('21','228',212,'DAILY','2022-10-11','2022-10-18 11:03:09','2022-10-19 11:03:09','768',11955976.75,11955976.75,'768','2022-10-18 11:06:52','768','2022-10-18 11:11:13',10,0),('21','228',213,'DAILY','2022-10-12','2022-10-18 11:12:31','2022-10-19 11:12:31','768',10492205.25,10492205.25,'768','2022-10-18 11:19:11','768','2022-10-18 11:19:39',10,0),('21','228',214,'DAILY','2022-10-13','2022-10-19 09:02:59','2022-10-20 09:02:59','768',8680269.25,8680269.25,'768','2022-10-19 09:06:41','768','2022-10-19 09:07:01',10,0),('21','228',215,'DAILY','2022-10-14','2022-10-19 09:07:35','2022-10-20 09:07:35','768',8276914.80,8276914.80,'768','2022-10-19 09:12:59','768','2022-10-19 09:13:11',10,0),('21','228',216,'DAILY','2022-10-19','2022-10-19 09:24:45','2022-10-20 09:24:45','768',9809006.65,9809006.65,'768','2022-10-19 09:29:47','768','2022-10-19 09:30:08',10,0),('21','228',217,'DAILY','2022-10-16','2022-10-19 09:32:13','2022-10-20 09:32:13','768',9665647.35,9665647.35,'768','2022-10-19 10:13:52','768','2022-10-19 10:14:21',10,0),('21','228',218,'DAILY','2022-10-17','2022-10-19 10:15:00','2022-10-20 10:15:00','768',9350610.05,9350610.05,'768','2022-10-19 10:17:47','768','2022-10-19 10:18:01',10,0),('21','228',219,'DAILY','2022-10-18','2022-10-19 10:55:00','2022-10-20 10:55:00','768',0.00,0.00,'768','2022-10-22 09:28:32','768','2022-10-22 09:28:51',10,0),('21','228',220,'DAILY','2022-10-18','2022-10-22 09:30:01','2022-10-23 09:30:01','768',10836785.15,10836785.15,'768','2022-10-22 09:32:56','768','2022-10-22 09:33:09',10,0),('21','228',221,'DAILY','2022-10-19','2022-10-22 09:34:53','2022-10-23 09:34:53','768',11859437.20,11859437.20,'768','2022-10-22 10:05:40','768','2022-10-22 10:05:57',10,0),('21','228',222,'DAILY','2022-10-20','2022-10-22 10:07:04','2022-10-23 10:07:04','768',2819288.10,2819288.10,'768','2022-10-22 10:08:24','768','2022-10-22 10:08:48',10,0),('21','228',223,'DAILY','2022-10-21','2022-10-22 10:09:40','2022-10-23 10:09:40','768',2835531.00,2835531.00,'768','2022-10-22 10:10:34','768','2022-10-22 10:10:46',10,0),('21','228',224,'DAILY','2022-10-22','2022-10-27 17:29:49','2022-10-28 17:29:49','768',11598392.50,11598392.50,'768','2022-10-27 17:33:11','768','2022-10-27 17:33:57',10,0),('21','228',225,'DAILY','2022-10-23','2022-10-27 17:42:26','2022-10-28 17:42:26','768',12701564.90,12701564.90,'768','2022-10-27 17:46:55','768','2022-10-27 17:47:13',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=6301 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','228','1','1',1,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',2,'2','1',3621169.76,3625934.16,4764.40,786126.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',3,'3','1',1609157.53,1612552.99,3395.46,560250.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',4,'4','1',2092107.57,2095491.49,3383.92,558346.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',5,'5','1',1841544.85,1844759.19,3214.34,530366.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',6,'6','1',1514435.07,1518038.67,3603.60,594594.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',7,'7','1',1641378.49,1644839.86,3461.37,571126.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',8,'8','1',2250244.70,2254017.72,3773.02,622548.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',9,'9','1',1843729.25,1848043.06,4313.81,711778.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','1',10,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',11,'11','1',3003807.34,3003807.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',12,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',13,'13','1',2083076.15,2083076.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',14,'14','1',3260395.27,3260395.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',15,'15','1',2614209.25,2614209.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',16,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',17,'17','1',2509256.89,2509256.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',18,'18','1',2486907.06,2486907.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',19,'19','1',2512954.23,2512954.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','1',20,'20','1',2536487.95,2536487.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','1',21,'21','2',1465638.11,1468165.92,2527.81,1769467.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','1',22,'22','2',1999701.76,1999703.62,1.86,1302.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','1',23,'23','2',2111733.42,2112866.28,1132.86,793002.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','1',24,'24','2',1060112.77,1062331.78,2219.01,1553307.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','1',25,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','1',26,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','1',27,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','1',28,'28','3',747482.23,747482.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',29,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',30,'2','1',3625934.16,3631502.02,5567.86,918696.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',31,'3','1',1612552.99,1617025.14,4472.15,737904.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',32,'4','1',2095491.49,2096898.15,1406.66,232098.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',33,'5','1',1844759.19,1849165.91,4406.72,727108.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',34,'6','1',1518038.67,1520072.18,2033.51,335529.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',35,'7','1',1644839.86,1647941.45,3101.59,511762.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',36,'8','1',2254017.72,2257658.63,3640.91,600750.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',37,'9','1',1848043.06,1853375.34,5332.28,879826.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','2',38,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',39,'11','1',3003807.34,3006813.19,3005.85,495965.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',40,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',41,'13','1',2083076.15,2083076.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',42,'14','1',3260395.27,3263572.95,3177.68,524317.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',43,'15','1',2614209.25,2616876.62,2667.37,440116.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',44,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',45,'17','1',2509256.89,2512287.56,3030.67,500060.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',46,'18','1',2486907.06,2486907.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',47,'19','1',2512954.23,2516055.33,3101.10,511681.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','2',48,'20','1',2536487.95,2536487.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','2',49,'21','2',1468165.92,1471574.53,3408.61,2386027.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','2',50,'22','2',1999703.62,1999705.76,2.14,1498.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','2',51,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','2',52,'24','2',1062331.78,1063860.24,1528.46,1069922.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','2',53,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','2',54,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','2',55,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','2',56,'28','3',747482.23,747482.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',57,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',58,'2','1',3631502.02,3638484.84,6982.82,1152165.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',59,'3','1',1617025.14,1622225.18,5200.04,858006.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',60,'4','1',2096898.15,2096898.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',61,'5','1',1849165.91,1852910.44,3744.53,617847.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',62,'6','1',1520072.18,1521542.11,1469.93,242538.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',63,'7','1',1647941.45,1650861.20,2919.75,481758.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',64,'8','1',2257658.63,2260573.99,2915.36,481034.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',65,'9','1',1853375.34,1859384.07,6008.73,991440.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','3',66,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',67,'11','1',3006813.19,3010384.45,3571.26,589257.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',68,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',69,'13','1',2083076.15,2083076.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',70,'14','1',3263572.95,3266708.09,3135.14,517298.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',71,'15','1',2616876.62,2619927.63,3051.01,503416.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',72,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',73,'17','1',2512287.56,2515461.88,3174.32,523762.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',74,'18','1',2486907.06,2486907.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',75,'19','1',2516055.33,2518209.27,2153.94,355400.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','3',76,'20','1',2536487.95,2537528.72,1040.77,171727.05,0.00,0.00,0.00,0.00,0.00),('21','228','3','3',77,'21','2',1471574.53,1474507.76,2933.23,2053261.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','3',78,'22','2',1999705.76,1999705.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','3',79,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','3',80,'24','2',1063860.24,1066180.24,2320.00,1624000.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','3',81,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','3',82,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','3',83,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','3',84,'28','3',747482.23,747482.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',85,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',86,'2','1',3638484.84,3645106.64,6576.80,1085172.00,0.00,0.00,45.00,0.00,0.00),('21','228','1','4',87,'3','1',1622225.18,1626702.09,4476.91,738690.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',88,'4','1',2096898.15,2101135.55,4237.40,699171.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',89,'5','1',1852910.44,1857808.20,4897.76,808130.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',90,'6','1',1521542.11,1525935.44,4393.33,724899.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',91,'7','1',1650861.20,1655430.47,4569.27,753929.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',92,'8','1',2260573.99,2265316.53,4742.54,782519.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',93,'9','1',1859384.07,1865324.27,5940.20,980133.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','4',94,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',95,'11','1',3010384.45,3010384.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',96,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',97,'13','1',2083076.15,2083076.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',98,'14','1',3266708.09,3266708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',99,'15','1',2619927.63,2619927.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',100,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',101,'17','1',2515461.88,2515461.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',102,'18','1',2486907.06,2486907.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',103,'19','1',2518209.27,2518209.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','4',104,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','4',105,'21','2',1474507.76,1477954.14,3446.38,2412466.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','4',106,'22','2',1999705.76,1999743.21,37.45,26215.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','4',107,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','4',108,'24','2',1066180.24,1068200.59,2020.35,1414245.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','4',109,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','4',110,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','4',111,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','4',112,'28','3',747482.23,748789.25,1307.02,718861.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',113,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',114,'2','1',3645106.64,3651360.50,6253.86,1031886.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',115,'3','1',1626702.09,1631044.37,4342.28,716476.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',116,'4','1',2101135.55,2105918.53,4782.98,789191.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',117,'5','1',1857808.20,1862194.27,4386.07,723701.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',118,'6','1',1525935.44,1530555.50,4620.06,762309.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',119,'7','1',1655430.47,1660087.92,4657.45,768479.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',120,'8','1',2265316.53,2269825.77,4509.24,744024.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',121,'9','1',1865324.27,1872126.34,6802.07,1122341.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','5',122,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',123,'11','1',3010384.45,3010384.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',124,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',125,'13','1',2083076.15,2083076.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',126,'14','1',3266708.09,3266708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',127,'15','1',2619927.63,2619927.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',128,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',129,'17','1',2515461.88,2515461.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',130,'18','1',2486907.06,2486907.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',131,'19','1',2518209.27,2518209.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','5',132,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','5',133,'21','2',1477954.14,1481188.23,3234.09,2263863.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','5',134,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','5',135,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','5',136,'24','2',1068200.59,1069911.40,1710.81,1197567.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','5',137,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','5',138,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','5',139,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','5',140,'28','3',748789.25,751155.07,2365.82,1301201.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',141,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',142,'2','1',3651360.50,3657820.02,6459.52,1065820.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',143,'3','1',1631044.37,1635381.11,4336.74,715562.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',144,'4','1',2105918.53,2110430.55,4512.02,744483.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',145,'5','1',1862194.27,1866552.06,4357.79,719035.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',146,'6','1',1530555.50,1535413.18,4857.68,801517.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',147,'7','1',1660087.92,1664646.50,4558.58,752165.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',148,'8','1',2269825.77,2275154.85,5329.08,879298.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',149,'9','1',1872126.34,1878217.36,6091.02,1005018.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','6',150,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',151,'11','1',3010384.45,3010384.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',152,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',153,'13','1',2083076.15,2083076.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',154,'14','1',3266708.09,3266708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',155,'15','1',2619927.63,2619927.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',156,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',157,'17','1',2515461.88,2515461.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',158,'18','1',2486907.06,2486907.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',159,'19','1',2518209.27,2518209.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','6',160,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','6',161,'21','2',1481188.23,1483661.90,2473.67,1731569.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','6',162,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','6',163,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','6',164,'24','2',1069911.40,1071532.11,1620.71,1134497.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','6',165,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','6',166,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','6',167,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','6',168,'28','3',751155.07,753563.57,2408.50,1324675.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',169,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',170,'2','1',3657820.02,3664570.20,6750.18,1113779.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',171,'3','1',1635381.11,1640190.71,4809.60,793584.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',172,'4','1',2110430.55,2114375.37,3944.82,650895.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',173,'5','1',1866552.06,1870100.07,3548.01,585421.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',174,'6','1',1535413.18,1540143.91,4730.73,780570.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',175,'7','1',1664646.50,1669333.69,4687.19,773386.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',176,'8','1',2275154.85,2280118.01,4963.16,818921.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',177,'9','1',1878217.36,1884864.27,6646.91,1096740.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','7',178,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',179,'11','1',3010384.45,3010384.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',180,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',181,'13','1',2083076.15,2083076.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',182,'14','1',3266708.09,3266708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',183,'15','1',2619927.63,2619927.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',184,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',185,'17','1',2515461.88,2515461.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',186,'18','1',2486907.06,2486907.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',187,'19','1',2518209.27,2518209.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','7',188,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','7',189,'21','2',1483661.90,1484882.12,1220.22,854154.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','7',190,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','7',191,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','7',192,'24','2',1071532.11,1071766.57,234.46,164122.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','7',193,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','7',194,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','7',195,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','7',196,'28','3',753563.57,754939.82,1376.25,756937.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',197,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',198,'2','1',3664570.20,3669665.70,5095.50,840757.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',199,'3','1',1640190.71,1643379.55,3188.84,526158.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',200,'4','1',2114375.37,2117893.31,3517.94,580460.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',201,'5','1',1870100.07,1873154.22,3054.15,503934.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',202,'6','1',1540143.91,1543816.07,3672.16,605906.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',203,'7','1',1669333.69,1672450.46,3116.77,514267.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',204,'8','1',2280118.01,2284088.54,3970.53,655137.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',205,'9','1',1884864.27,1889297.45,4433.18,731474.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','8',206,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',207,'11','1',3010384.45,3013111.34,2726.89,449936.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',208,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',209,'13','1',2083076.15,2083076.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',210,'14','1',3266708.09,3269968.56,3260.47,537977.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',211,'15','1',2619927.63,2622486.00,2558.37,422131.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',212,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',213,'17','1',2515461.88,2518858.58,3396.70,560455.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',214,'18','1',2486907.06,2486907.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',215,'19','1',2518209.27,2521188.78,2979.51,491619.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','8',216,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','8',217,'21','2',1484882.12,1487272.28,2390.16,1673112.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','8',218,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','8',219,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','8',220,'24','2',1071766.57,1073551.23,1784.66,1249262.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','8',221,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','8',222,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','8',223,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','8',224,'28','3',754939.82,757122.71,2182.89,1200589.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',225,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',226,'2','1',3669665.70,3676423.39,6757.69,1115018.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',227,'3','1',1643379.55,1649315.09,5935.54,979364.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',228,'4','1',2117893.31,2117893.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',229,'5','1',1873154.22,1876718.27,3564.05,588068.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',230,'6','1',1543816.07,1545960.60,2144.53,353847.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',231,'7','1',1672450.46,1672450.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',232,'8','1',2284088.54,2289884.33,5795.79,956305.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',233,'9','1',1889297.45,1894966.83,5669.38,935447.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','9',234,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',235,'11','1',3013111.34,3017264.33,4152.99,685243.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',236,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',237,'13','1',2083076.15,2083078.54,2.39,394.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',238,'14','1',3269968.56,3273851.25,3882.69,640643.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',239,'15','1',2622486.00,2626375.22,3889.22,641721.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',240,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',241,'17','1',2518858.58,2522599.55,3740.97,617260.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',242,'18','1',2486907.06,2486907.24,0.18,29.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',243,'19','1',2521188.78,2525371.63,4182.85,690170.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','9',244,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','9',245,'21','2',1487272.28,1490383.68,3111.40,2177980.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','9',246,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','9',247,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','9',248,'24','2',1073551.23,1075111.85,1560.62,1092434.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','9',249,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','9',250,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','9',251,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','9',252,'28','3',757122.71,758704.27,1581.56,869858.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',253,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',254,'2','1',3676423.39,3682961.59,6538.20,1078803.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',255,'3','1',1649315.09,1653015.06,3699.97,610495.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',256,'4','1',2117893.31,2120982.41,3089.10,509701.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',257,'5','1',1876718.27,1880534.02,3815.75,629598.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',258,'6','1',1545960.60,1550027.71,4067.11,671073.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',259,'7','1',1672450.46,1676861.60,4411.14,727838.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',260,'8','1',2289884.33,2293436.63,3552.30,586129.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',261,'9','1',1894966.83,1901235.69,6268.86,1034361.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','10',262,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',263,'11','1',3017264.33,3020019.89,2755.56,454667.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',264,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',265,'13','1',2083078.54,2083078.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',266,'14','1',3273851.25,3276660.66,2809.41,463552.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',267,'15','1',2626375.22,2629289.64,2914.42,480879.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',268,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',269,'17','1',2522599.55,2524473.30,1873.75,309168.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',270,'18','1',2486907.24,2488226.78,1319.54,217724.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',271,'19','1',2525371.63,2528049.33,2677.70,441820.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','10',272,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','10',273,'21','2',1490383.68,1494646.79,4263.11,2984177.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','10',274,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','10',275,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','10',276,'24','2',1075111.85,1077479.31,2367.46,1657222.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','10',277,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','10',278,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','10',279,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','10',280,'28','3',758704.27,760274.74,1570.47,863758.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',281,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',282,'2','1',3682961.59,3682961.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',283,'3','1',1653015.06,1653015.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',284,'4','1',2120982.41,2120982.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',285,'5','1',1880534.02,1880534.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',286,'6','1',1550027.71,1550027.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',287,'7','1',1676861.60,1676861.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',288,'8','1',2293436.63,2293436.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',289,'9','1',1901235.69,1901235.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','11',290,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',291,'11','1',3020019.89,3020019.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',292,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',293,'13','1',2083078.54,2083078.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',294,'14','1',3276660.66,3276660.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',295,'15','1',2629289.64,2629289.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',296,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',297,'17','1',2524473.30,2524473.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',298,'18','1',2488226.78,2488226.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',299,'19','1',2528049.33,2528049.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','11',300,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','11',301,'21','2',1494646.79,1497639.86,2993.07,2095149.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','11',302,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','11',303,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','11',304,'24','2',1077479.31,1078353.89,828.86,580202.00,0.00,0.00,45.72,0.00,0.00),('21','228','4','11',305,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','11',306,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','11',307,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','11',308,'28','3',760274.74,761575.02,1300.28,715154.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',309,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',310,'2','1',3682961.59,3689438.74,6477.15,1068729.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',311,'3','1',1653015.06,1659008.19,5993.13,988866.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',312,'4','1',2120982.41,2120982.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',313,'5','1',1880534.02,1882712.83,2178.81,359503.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',314,'6','1',1550027.71,1553771.16,3743.45,617669.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',315,'7','1',1676861.60,1679428.18,2566.58,423485.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',316,'8','1',2293436.63,2296719.54,3282.91,541680.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',317,'9','1',1901235.69,1907101.28,5865.59,967822.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','12',318,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',319,'11','1',3020019.89,3023045.05,2944.56,485852.40,0.00,0.00,80.60,0.00,0.00),('21','228','2','12',320,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',321,'13','1',2083078.54,2083082.69,4.15,684.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',322,'14','1',3276660.66,3279715.47,3054.81,504043.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',323,'15','1',2629289.64,2632161.92,2872.28,473926.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',324,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',325,'17','1',2524473.30,2527570.97,3097.67,511115.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',326,'18','1',2488226.78,2488226.85,0.07,11.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',327,'19','1',2528049.33,2531031.44,2982.11,492048.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','12',328,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','12',329,'21','2',1497639.86,1499721.73,2081.87,1457309.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','12',330,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','12',331,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','12',332,'24','2',1078353.89,1079249.71,895.82,627074.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','12',333,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','12',334,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','12',335,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','12',336,'28','3',761575.02,762869.42,1294.40,711920.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',337,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',338,'2','1',3689438.74,3695593.52,6154.78,1015538.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',339,'3','1',1659008.19,1663523.32,4515.13,744996.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',340,'4','1',2120982.41,2125527.34,4544.93,749913.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',341,'5','1',1882712.83,1886870.00,4157.17,685933.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',342,'6','1',1553771.16,1559372.76,5601.60,924264.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',343,'7','1',1679428.18,1683948.55,4520.37,745861.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',344,'8','1',2296719.54,2301159.81,4440.27,732644.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',345,'9','1',1907101.28,1913479.74,6378.46,1052445.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','13',346,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',347,'11','1',3023045.05,3023045.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',348,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',349,'13','1',2083082.69,2083082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',350,'14','1',3279715.47,3279715.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',351,'15','1',2632161.92,2632161.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',352,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',353,'17','1',2527570.97,2527570.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',354,'18','1',2488226.85,2488226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',355,'19','1',2531031.44,2531031.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','13',356,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','13',357,'21','2',1499721.73,1502159.95,2438.22,1706754.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','13',358,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','13',359,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','13',360,'24','2',1079249.71,1080246.75,997.04,697928.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','13',361,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','13',362,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','13',363,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','13',364,'28','3',762869.42,765202.73,2333.31,1283320.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',365,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',366,'2','1',3695593.52,3702159.10,6565.58,1083320.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',367,'3','1',1663523.32,1668484.97,4961.65,818672.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',368,'4','1',2125527.34,2130794.24,5266.90,869038.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',369,'5','1',1886870.00,1891815.34,4945.34,815981.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',370,'6','1',1559372.76,1564562.60,5189.84,856323.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',371,'7','1',1683948.55,1688577.09,4628.54,763709.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',372,'8','1',2301159.81,2307289.38,6129.57,1011379.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',373,'9','1',1913479.74,1920672.84,7193.10,1186861.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','14',374,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',375,'11','1',3023045.05,3023045.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',376,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',377,'13','1',2083082.69,2083082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',378,'14','1',3279715.47,3279715.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',379,'15','1',2632161.92,2632161.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',380,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',381,'17','1',2527570.97,2527570.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',382,'18','1',2488226.85,2488226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',383,'19','1',2531031.44,2531031.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','14',384,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','14',385,'21','2',1502159.95,1503883.28,1723.33,1206331.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','14',386,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','14',387,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','14',388,'24','2',1080246.75,1080246.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','14',389,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','14',390,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','14',391,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','14',392,'28','3',765202.73,766537.67,1334.94,734217.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',393,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',394,'2','1',3702159.10,3709631.14,7472.04,1232886.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',395,'3','1',1668484.97,1673817.59,5332.62,879882.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',396,'4','1',2130794.24,2135510.24,4716.00,778140.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',397,'5','1',1891815.34,1895961.65,4146.31,684141.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',398,'6','1',1564562.60,1570603.06,6040.46,996675.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',399,'7','1',1688577.09,1693429.82,4852.73,800700.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',400,'8','1',2307289.38,2313503.67,6214.29,1025357.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',401,'9','1',1920672.84,1927145.94,6473.10,1068061.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','15',402,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',403,'11','1',3023045.05,3023045.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',404,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',405,'13','1',2083082.69,2083082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',406,'14','1',3279715.47,3279715.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',407,'15','1',2632161.92,2632161.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',408,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',409,'17','1',2527570.97,2527570.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',410,'18','1',2488226.85,2488226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',411,'19','1',2531031.44,2531031.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','15',412,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','15',413,'21','2',1503883.28,1507524.06,3640.78,2548546.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','15',414,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','15',415,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','15',416,'24','2',1080246.75,1081855.15,1608.40,1125880.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','15',417,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','15',418,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','15',419,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','15',420,'28','3',766537.67,767814.14,1276.47,702058.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',421,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',422,'2','1',3709631.14,3717021.72,7390.58,1219445.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',423,'3','1',1673817.59,1680474.88,6657.29,1098452.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',424,'4','1',2135510.24,2135564.81,54.57,9004.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',425,'5','1',1895961.65,1900808.58,4846.93,799743.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',426,'6','1',1570603.06,1575238.05,4634.99,764773.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',427,'7','1',1693429.82,1698136.90,4707.08,776668.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',428,'8','1',2313503.67,2318673.83,5170.16,853076.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',429,'9','1',1927145.94,1933374.87,6228.93,1027773.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','16',430,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',431,'11','1',3023045.05,3028549.57,5504.52,908245.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',432,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',433,'13','1',2083082.69,2083082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',434,'14','1',3279715.47,3282697.80,2982.33,492084.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',435,'15','1',2632161.92,2634911.88,2749.96,453743.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',436,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',437,'17','1',2527570.97,2531115.03,3544.06,584769.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',438,'18','1',2488226.85,2488226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',439,'19','1',2531031.44,2536136.50,5105.06,842334.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','16',440,'20','1',2537528.72,2537528.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','16',441,'21','2',1507524.06,1511361.44,3837.38,2686166.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','16',442,'22','2',1999743.21,1999743.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','16',443,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','16',444,'24','2',1081855.15,1082764.69,909.54,636678.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','16',445,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','16',446,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','16',447,'27','3',461323.48,461323.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','16',448,'28','3',767814.14,769114.72,1300.58,715319.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',449,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',450,'2','1',3717021.72,3722999.11,5977.39,986269.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',451,'3','1',1680474.88,1684765.08,4290.20,707883.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',452,'4','1',2135564.81,2136713.69,1148.88,189565.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',453,'5','1',1900808.58,1904746.63,3938.05,649778.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',454,'6','1',1575238.05,1578149.59,2911.54,480404.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',455,'7','1',1698136.90,1701372.03,3235.13,533796.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',456,'8','1',2318673.83,2322825.04,4151.21,684949.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',457,'9','1',1933374.87,1937730.24,4355.37,718636.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','17',458,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',459,'11','1',3028549.57,3032387.85,3838.28,633316.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',460,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',461,'13','1',2083082.69,2083082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',462,'14','1',3282697.80,3285535.84,2838.04,468276.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',463,'15','1',2634911.88,2638198.98,3287.10,542371.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',464,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',465,'17','1',2531115.03,2533406.50,2291.47,378092.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',466,'18','1',2488226.85,2490497.17,2270.32,374602.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',467,'19','1',2536136.50,2539067.03,2930.53,483537.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','17',468,'20','1',2537528.72,2540205.99,2677.27,441749.55,0.00,0.00,0.00,0.00,0.00),('21','228','3','17',469,'21','2',1511361.44,1514837.58,3476.14,2433298.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','17',470,'22','2',1999743.21,1999764.39,21.18,14826.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','17',471,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','17',472,'24','2',1082764.69,1093125.24,10360.55,7252385.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','17',473,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','17',474,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','17',475,'27','3',461323.48,461323.64,0.16,88.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','17',476,'28','3',769114.72,770569.76,1455.04,800272.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',477,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',478,'2','1',3722999.11,3730091.70,7092.59,1170277.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',479,'3','1',1684765.08,1691038.90,6273.82,1035180.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',480,'4','1',2136713.69,2140008.53,3294.84,543648.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',481,'5','1',1904746.63,1909190.35,4443.72,733213.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',482,'6','1',1578149.59,1583223.61,5074.02,837213.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',483,'7','1',1701372.03,1707228.77,5856.74,966362.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',484,'8','1',2322825.04,2329690.70,6865.66,1132833.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',485,'9','1',1937730.24,1943914.87,6184.63,1020463.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','18',486,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',487,'11','1',3032387.85,3032387.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',488,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',489,'13','1',2083082.69,2083082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',490,'14','1',3285535.84,3285535.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',491,'15','1',2638198.98,2638198.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',492,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',493,'17','1',2533406.50,2533406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',494,'18','1',2490497.17,2490497.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',495,'19','1',2539067.03,2539067.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','18',496,'20','1',2540205.99,2540205.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','18',497,'21','2',1514837.58,1517980.17,3142.59,2199813.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','18',498,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','18',499,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','18',500,'24','2',1093125.24,1103775.49,10650.25,7455175.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','18',501,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','18',502,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','18',503,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','18',504,'28','3',770569.76,771316.08,746.32,410476.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',505,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',506,'2','1',3730091.70,3730091.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',507,'3','1',1691038.90,1691038.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',508,'4','1',2140008.53,2140008.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',509,'5','1',1909190.35,1909190.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',510,'6','1',1583223.61,1583223.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',511,'7','1',1707228.77,1707228.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',512,'8','1',2329690.70,2329690.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',513,'9','1',1943914.87,1943914.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','19',514,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',515,'11','1',3032387.85,3032387.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',516,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',517,'13','1',2083082.69,2083082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',518,'14','1',3285535.84,3285535.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',519,'15','1',2638198.98,2638198.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',520,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',521,'17','1',2533406.50,2533406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',522,'18','1',2490497.17,2490497.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',523,'19','1',2539067.03,2539067.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','19',524,'20','1',2540205.99,2540205.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','19',525,'21','2',1517980.17,1517980.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','19',526,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','19',527,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','19',528,'24','2',1103775.49,1103775.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','19',529,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','19',530,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','19',531,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','19',532,'28','3',771316.08,771316.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',533,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',534,'2','1',3730091.70,3735401.82,5310.12,876169.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',535,'3','1',1691038.90,1695372.80,4333.90,715093.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',536,'4','1',2140008.53,2142428.91,2420.38,399362.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',537,'5','1',1909190.35,1912266.07,3075.72,507493.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',538,'6','1',1583223.61,1586974.75,3751.14,618938.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',539,'7','1',1707228.77,1709923.97,2695.20,444708.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',540,'8','1',2329690.70,2333585.12,3894.42,642579.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',541,'9','1',1943914.87,1948413.71,4498.84,742308.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','20',542,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',543,'11','1',3032387.85,3035730.31,3342.46,551505.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',544,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',545,'13','1',2083082.69,2083083.80,1.11,183.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',546,'14','1',3285535.84,3288670.75,3134.91,517260.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',547,'15','1',2638198.98,2640882.64,2683.66,442803.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',548,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',549,'17','1',2533406.50,2536246.45,2839.95,468591.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',550,'18','1',2490497.17,2493609.80,3112.63,513583.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',551,'19','1',2539067.03,2541226.73,2159.70,356350.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','20',552,'20','1',2540205.99,2542887.79,2681.80,442497.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','20',553,'21','2',1517980.17,1521150.05,3169.88,2218916.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','20',554,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','20',555,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','20',556,'24','2',1103775.49,1105093.11,1317.62,922334.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','20',557,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','20',558,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','20',559,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','20',560,'28','3',771316.08,773015.64,1699.56,934758.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',561,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',562,'2','1',3735401.82,3742535.90,7134.08,1177123.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',563,'3','1',1695372.80,1700680.03,5307.23,875692.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',564,'4','1',2142428.91,2146646.63,4217.72,695923.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',565,'5','1',1912266.07,1916192.75,3926.68,647902.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',566,'6','1',1586974.75,1592297.91,5323.16,878321.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',567,'7','1',1709923.97,1715385.95,5461.98,901226.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',568,'8','1',2333585.12,2339376.59,5791.47,955592.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',569,'9','1',1948413.71,1956456.65,8042.94,1327085.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','21',570,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',571,'11','1',3035730.31,3035730.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',572,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',573,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',574,'14','1',3288670.75,3288670.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',575,'15','1',2640882.64,2640882.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',576,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',577,'17','1',2536246.45,2536246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',578,'18','1',2493609.80,2493609.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',579,'19','1',2541226.73,2541226.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','21',580,'20','1',2542887.79,2542887.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','21',581,'21','2',1521150.05,1524664.56,3514.51,2460157.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','21',582,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','21',583,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','21',584,'24','2',1105093.11,1106867.08,1773.97,1241779.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','21',585,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','21',586,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','21',587,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','21',588,'28','3',773015.64,774806.66,1791.02,985061.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',589,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',590,'2','1',3742535.90,3742535.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',591,'3','1',1700680.03,1700680.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',592,'4','1',2146646.63,2146646.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',593,'5','1',1916192.75,1916192.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',594,'6','1',1592297.91,1592297.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',595,'7','1',1715385.95,1715385.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',596,'8','1',2339376.59,2339376.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',597,'9','1',1956456.65,1956456.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','22',598,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',599,'11','1',3035730.31,3035730.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',600,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',601,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',602,'14','1',3288670.75,3288670.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',603,'15','1',2640882.64,2640882.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',604,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',605,'17','1',2536246.45,2536246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',606,'18','1',2493609.80,2493609.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',607,'19','1',2541226.73,2541226.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','22',608,'20','1',2542887.79,2542887.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','22',609,'21','2',1524664.56,1524664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','22',610,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','22',611,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','22',612,'24','2',1106867.08,1106867.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','22',613,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','22',614,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','22',615,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','22',616,'28','3',774806.66,774806.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',617,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',618,'2','1',3742535.90,3749343.99,6808.09,1123334.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',619,'3','1',1700680.03,1706323.25,5643.22,931131.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',620,'4','1',2146646.63,2148421.04,1774.41,292777.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',621,'5','1',1916192.75,1920149.49,3956.74,652862.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',622,'6','1',1592297.91,1597269.12,4971.21,820249.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',623,'7','1',1715385.95,1720351.50,4965.55,819315.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',624,'8','1',2339376.59,2344449.31,5072.72,836998.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',625,'9','1',1956456.65,1963210.39,6753.74,1114367.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','23',626,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',627,'11','1',3035730.31,3038947.37,3217.06,530814.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',628,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',629,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',630,'14','1',3288670.75,3291766.69,3095.94,510830.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',631,'15','1',2640882.64,2643847.44,2964.80,489192.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',632,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',633,'17','1',2536246.45,2539012.36,2765.91,456375.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',634,'18','1',2493609.80,2496053.36,2443.56,403187.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',635,'19','1',2541226.73,2544207.72,2980.99,491863.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','23',636,'20','1',2542887.79,2545365.80,2478.01,408871.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','23',637,'21','2',1524664.56,1526249.72,1585.16,1109612.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','23',638,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','23',639,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','23',640,'24','2',1106867.08,1107333.71,466.63,326641.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','23',641,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','23',642,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','23',643,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','23',644,'28','3',774806.66,775783.74,977.08,537394.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',645,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',646,'2','1',3749343.99,3756607.90,7263.91,1198545.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',647,'3','1',1706323.25,1711163.24,4839.99,798598.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',648,'4','1',2148421.04,2153492.48,5071.44,836787.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',649,'5','1',1920149.49,1924795.16,4645.67,766535.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',650,'6','1',1597269.12,1602478.49,5209.37,859546.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',651,'7','1',1720351.50,1725524.67,5173.17,853573.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',652,'8','1',2344449.31,2350038.88,5589.57,922279.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',653,'9','1',1963210.39,1970842.78,7632.39,1259344.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','24',654,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',655,'11','1',3038947.37,3038947.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',656,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',657,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',658,'14','1',3291766.69,3291766.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',659,'15','1',2643847.44,2643847.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',660,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',661,'17','1',2539012.36,2539012.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',662,'18','1',2496053.36,2496053.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',663,'19','1',2544207.72,2544207.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','24',664,'20','1',2545365.80,2545365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','24',665,'21','2',1526249.72,1529248.24,2998.52,2098964.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','24',666,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','24',667,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','24',668,'24','2',1107333.71,1108878.11,1544.40,1081080.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','24',669,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','24',670,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','24',671,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','24',672,'28','3',775783.74,776861.02,1077.28,592504.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',673,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',674,'2','1',3756607.90,3762457.54,5849.64,965190.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',675,'3','1',1711163.24,1715289.01,4125.77,680752.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',676,'4','1',2153492.48,2158562.64,5070.16,836576.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',677,'5','1',1924795.16,1929063.57,4268.41,704287.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',678,'6','1',1602478.49,1606752.16,4273.67,705155.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',679,'7','1',1725524.67,1729585.86,4061.19,670096.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',680,'8','1',2350038.88,2355176.07,5137.19,847636.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',681,'9','1',1970842.78,1977725.39,6882.61,1135630.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','25',682,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',683,'11','1',3038947.37,3038947.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',684,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',685,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',686,'14','1',3291766.69,3291766.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',687,'15','1',2643847.44,2643847.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',688,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',689,'17','1',2539012.36,2539012.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',690,'18','1',2496053.36,2496053.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',691,'19','1',2544207.72,2544207.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','25',692,'20','1',2545365.80,2545365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','25',693,'21','2',1529248.24,1531738.62,2490.38,1743266.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','25',694,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','25',695,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','25',696,'24','2',1108878.11,1109909.25,1031.14,721798.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','25',697,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','25',698,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','25',699,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','25',700,'28','3',776861.02,778646.05,1785.03,981766.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',701,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',702,'2','1',3762457.54,3769071.69,6614.15,1091334.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',703,'3','1',1715289.01,1719356.26,4067.25,671096.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',704,'4','1',2158562.64,2163087.49,4524.85,746600.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',705,'5','1',1929063.57,1932331.72,3268.15,539244.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',706,'6','1',1606752.16,1611962.02,5209.86,859626.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',707,'7','1',1729585.86,1733757.07,4171.21,688249.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',708,'8','1',2355176.07,2360352.46,5176.39,854104.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',709,'9','1',1977725.39,1984371.01,6645.62,1096527.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','26',710,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',711,'11','1',3038947.37,3038947.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',712,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',713,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',714,'14','1',3291766.69,3291766.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',715,'15','1',2643847.44,2643847.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',716,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',717,'17','1',2539012.36,2539012.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',718,'18','1',2496053.36,2496053.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',719,'19','1',2544207.72,2544207.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','26',720,'20','1',2545365.80,2545365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','26',721,'21','2',1531738.62,1534917.02,3178.40,2224880.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','26',722,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','26',723,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','26',724,'24','2',1109909.25,1111283.15,1373.90,961730.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','26',725,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','26',726,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','26',727,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','26',728,'28','3',778646.05,779536.56,890.51,489780.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',729,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',730,'2','1',3769071.69,3775617.38,6545.69,1080038.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',731,'3','1',1719356.26,1723329.68,3973.42,655614.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',732,'4','1',2163087.49,2166924.86,3837.37,633166.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',733,'5','1',1932331.72,1935765.27,3433.55,566535.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',734,'6','1',1611962.02,1616364.42,4402.40,726396.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',735,'7','1',1733757.07,1737623.27,3866.20,637923.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',736,'8','1',2360352.46,2364522.87,4170.41,688117.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',737,'9','1',1984371.01,1990010.73,5639.72,930553.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','27',738,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',739,'11','1',3038947.37,3041609.00,2661.63,439168.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',740,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',741,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',742,'14','1',3291766.69,3294008.93,2242.24,369969.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',743,'15','1',2643847.44,2645962.82,2115.38,349037.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',744,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',745,'17','1',2539012.36,2541282.52,2270.16,374576.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',746,'18','1',2496053.36,2497272.18,1218.82,201105.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',747,'19','1',2544207.72,2546053.49,1845.77,304552.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','27',748,'20','1',2545365.80,2547083.31,1717.51,283389.15,0.00,0.00,0.00,0.00,0.00),('21','228','3','27',749,'21','2',1534917.02,1537808.64,2891.62,2024134.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','27',750,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','27',751,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','27',752,'24','2',1111283.15,1111935.51,652.36,456652.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','27',753,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','27',754,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','27',755,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','27',756,'28','3',779536.56,780996.84,1460.28,803154.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',757,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',758,'2','1',3775617.38,3775617.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',759,'3','1',1723329.68,1723329.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',760,'4','1',2166924.86,2166924.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',761,'5','1',1935765.27,1935765.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',762,'6','1',1616364.42,1616364.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',763,'7','1',1737623.27,1737623.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',764,'8','1',2364522.87,2364522.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',765,'9','1',1990010.73,1990010.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','28',766,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',767,'11','1',3041609.00,3048271.43,6662.43,1099300.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',768,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',769,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',770,'14','1',3294008.93,3301725.17,7716.24,1273179.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',771,'15','1',2645962.82,2651099.76,5136.94,847595.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',772,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',773,'17','1',2541282.52,2547047.67,5765.15,951249.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',774,'18','1',2497272.18,2503868.28,6596.10,1088356.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',775,'19','1',2546053.49,2553378.04,7324.55,1208550.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','28',776,'20','1',2547083.31,2553040.30,5956.99,982903.35,0.00,0.00,0.00,0.00,0.00),('21','228','3','28',777,'21','2',1537808.64,1540118.19,2309.55,1616685.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','28',778,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','28',779,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','28',780,'24','2',1111935.51,1112798.28,862.77,603939.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','28',781,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','28',782,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','28',783,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','28',784,'28','3',780996.84,782396.55,1399.71,769840.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',785,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',786,'2','1',3775617.38,3783440.74,7823.36,1290854.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',787,'3','1',1723329.68,1728206.01,4876.33,804594.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',788,'4','1',2166924.86,2172194.10,5269.24,869424.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',789,'5','1',1935765.27,1940495.06,4729.79,780415.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',790,'6','1',1616364.42,1621349.62,4985.20,822558.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',791,'7','1',1737623.27,1742646.67,5023.40,828861.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',792,'8','1',2364522.87,2370070.83,5547.96,915413.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',793,'9','1',1990010.73,1997021.60,7010.87,1156793.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','29',794,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',795,'11','1',3048271.43,3048271.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',796,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',797,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',798,'14','1',3301725.17,3301725.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',799,'15','1',2651099.76,2651099.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',800,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',801,'17','1',2547047.67,2547047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',802,'18','1',2503868.28,2503868.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',803,'19','1',2553378.04,2553378.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','29',804,'20','1',2553040.30,2553040.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','29',805,'21','2',1540118.19,1542521.30,2403.11,1682177.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','29',806,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','29',807,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','29',808,'24','2',1112798.28,1113621.47,823.19,576233.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','29',809,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','29',810,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','29',811,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','29',812,'28','3',782396.55,783876.54,1479.99,813994.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',813,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',814,'2','1',3783440.74,3783440.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',815,'3','1',1728206.01,1728206.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',816,'4','1',2172194.10,2172194.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',817,'5','1',1940495.06,1940495.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',818,'6','1',1621349.62,1621349.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',819,'7','1',1742646.67,1742646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',820,'8','1',2370070.83,2370070.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',821,'9','1',1997021.60,1997021.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','30',822,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',823,'11','1',3048271.43,3054215.50,5944.07,980771.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',824,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',825,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',826,'14','1',3301725.17,3308383.21,6658.04,1098576.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',827,'15','1',2651099.76,2656945.03,5845.27,964469.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',828,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',829,'17','1',2547047.67,2552814.15,5766.48,951469.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',830,'18','1',2503868.28,2509220.11,5351.83,883051.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',831,'19','1',2553378.04,2558881.55,5503.51,908079.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','30',832,'20','1',2553040.30,2558100.61,5060.31,834951.15,0.00,0.00,0.00,0.00,0.00),('21','228','3','30',833,'21','2',1542521.30,1544390.18,1868.88,1308216.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','30',834,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','30',835,'23','2',2112866.28,2112866.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','30',836,'24','2',1113621.47,1113707.19,85.72,60004.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','30',837,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','30',838,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','30',839,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','30',840,'28','3',783876.54,784914.98,1038.44,571142.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',841,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',842,'2','1',3783440.74,3790865.67,7424.93,1225113.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',843,'3','1',1728206.01,1732852.46,4646.45,766664.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',844,'4','1',2172194.10,2176662.41,4468.31,737271.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',845,'5','1',1940495.06,1945131.36,4636.30,764989.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',846,'6','1',1621349.62,1626460.98,5111.36,843374.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',847,'7','1',1742646.67,1747785.54,5138.87,847913.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',848,'8','1',2370070.83,2375668.98,5598.15,923694.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',849,'9','1',1997021.60,2005155.93,8134.33,1342164.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','31',850,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',851,'11','1',3054215.50,3054215.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',852,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',853,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',854,'14','1',3308383.21,3308383.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',855,'15','1',2656945.03,2656945.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',856,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',857,'17','1',2552814.15,2552814.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',858,'18','1',2509220.11,2509220.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',859,'19','1',2558881.55,2558881.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','31',860,'20','1',2558100.61,2558100.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','31',861,'21','2',1544390.18,1548125.59,3735.41,2614787.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','31',862,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','31',863,'23','2',2112866.28,2112866.32,0.04,28.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','31',864,'24','2',1113707.19,1113875.04,167.85,117495.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','31',865,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','31',866,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','31',867,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','31',868,'28','3',784914.98,786522.40,1607.42,884081.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',869,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',870,'2','1',3790865.67,3795336.23,4470.56,737642.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',871,'3','1',1732852.46,1735104.42,2251.96,371573.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',872,'4','1',2176662.41,2178875.54,2213.13,365166.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',873,'5','1',1945131.36,1946687.46,1556.10,256756.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',874,'6','1',1626460.98,1628467.11,2006.13,331011.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',875,'7','1',1747785.54,1749920.00,2134.46,352185.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',876,'8','1',2375668.98,2377847.97,2178.99,359533.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',877,'9','1',2005155.93,2008604.15,3448.22,568956.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','32',878,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',879,'11','1',3054215.50,3060380.00,6164.50,1017142.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',880,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',881,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',882,'14','1',3308383.21,3313902.46,5519.25,910676.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',883,'15','1',2656945.03,2663472.44,6527.41,1077022.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',884,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',885,'17','1',2552814.15,2556628.53,3814.38,629372.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',886,'18','1',2509220.11,2514441.19,5221.08,861478.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',887,'19','1',2558881.55,2563574.11,4692.56,774272.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','32',888,'20','1',2558100.61,2564260.22,6159.61,1016335.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','32',889,'21','2',1548125.59,1551666.64,3541.05,2478735.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','32',890,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','32',891,'23','2',2112866.32,2112866.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','32',892,'24','2',1113875.04,1114751.68,876.64,613648.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','32',893,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','32',894,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','32',895,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','32',896,'28','3',786522.40,788524.67,2002.27,1101248.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',897,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',898,'2','1',3795336.23,3802629.80,7293.57,1203439.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',899,'3','1',1735104.42,1740450.57,5346.15,882114.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',900,'4','1',2178875.54,2182350.67,3475.13,573396.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',901,'5','1',1946687.46,1950341.51,3654.05,602918.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',902,'6','1',1628467.11,1633302.95,4835.84,797913.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',903,'7','1',1749920.00,1753535.57,3615.56,596568.22,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',904,'8','1',2377847.97,2382778.81,4930.84,813588.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',905,'9','1',2008604.15,2014979.13,6374.98,1051871.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','33',906,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',907,'11','1',3060380.00,3064893.69,4513.69,744758.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',908,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',909,'13','1',2083083.80,2083083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',910,'14','1',3313902.46,3318728.72,4826.26,796332.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',911,'15','1',2663472.44,2666448.32,2975.88,491020.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',912,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',913,'17','1',2556628.53,2557261.85,633.32,104497.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',914,'18','1',2514441.19,2518346.53,3905.34,644381.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',915,'19','1',2563574.11,2568279.34,4705.23,776362.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','33',916,'20','1',2564260.22,2567472.50,3212.28,530026.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','33',917,'21','2',1551666.64,1555130.81,3464.17,2424919.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','33',918,'22','2',1999764.39,1999764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','33',919,'23','2',2112866.32,2112866.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','33',920,'24','2',1114751.68,1115263.60,511.92,358344.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','33',921,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','33',922,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','33',923,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','33',924,'28','3',788524.67,789849.47,1324.80,728640.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',925,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',926,'2','1',3802629.80,3802629.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',927,'3','1',1740450.57,1740450.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',928,'4','1',2182350.67,2182350.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',929,'5','1',1950341.51,1950341.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',930,'6','1',1633302.95,1633302.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',931,'7','1',1753535.57,1753535.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',932,'8','1',2382778.81,2382778.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',933,'9','1',2014979.13,2014979.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','34',934,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',935,'11','1',3064893.69,3071222.51,6328.82,1044255.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',936,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',937,'13','1',2083083.80,2083088.95,5.15,849.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',938,'14','1',3318728.72,3325594.26,6865.54,1132814.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',939,'15','1',2666448.32,2673245.60,6797.28,1121551.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',940,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',941,'17','1',2557261.85,2563007.20,5745.35,947982.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',942,'18','1',2518346.53,2523687.67,5341.14,881288.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',943,'19','1',2568279.34,2573086.58,4807.24,793194.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','34',944,'20','1',2567472.50,2573622.42,6149.92,1014736.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','34',945,'21','2',1555130.81,1558802.29,3671.48,2570036.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','34',946,'22','2',1999764.39,1999771.53,7.14,4998.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','34',947,'23','2',2112866.32,2112866.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','34',948,'24','2',1115263.60,1116432.86,1169.26,818482.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','34',949,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','34',950,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','34',951,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','34',952,'28','3',789849.47,790629.23,779.76,428868.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',953,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',954,'2','1',3802629.80,3810899.19,8269.39,1364449.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',955,'3','1',1740450.57,1744949.37,4498.80,742302.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',956,'4','1',2182350.67,2188036.99,5686.32,938242.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',957,'5','1',1950341.51,1954233.02,3891.51,642099.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',958,'6','1',1633302.95,1638659.49,5356.54,883829.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',959,'7','1',1753535.57,1758141.63,4606.06,759999.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',960,'8','1',2382778.81,2388544.78,5765.97,951385.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',961,'9','1',2014979.13,2020414.62,5435.49,896855.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','35',962,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',963,'11','1',3071222.51,3074556.83,3334.32,550162.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',964,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',965,'13','1',2083088.95,2083088.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',966,'14','1',3325594.26,3328090.34,2496.08,411853.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',967,'15','1',2673245.60,2676389.91,3144.31,518811.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',968,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',969,'17','1',2563007.20,2564684.36,1677.16,276731.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',970,'18','1',2523687.67,2526339.46,2651.79,437545.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',971,'19','1',2573086.58,2573813.09,726.51,119874.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','35',972,'20','1',2573622.42,2576491.52,2869.10,473401.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','35',973,'21','2',1558802.29,1561594.09,2791.80,1954260.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','35',974,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','35',975,'23','2',2112866.32,2112866.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','35',976,'24','2',1116432.86,1116656.30,223.44,156408.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','35',977,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','35',978,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','35',979,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','35',980,'28','3',790629.23,792369.04,1739.81,956895.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',981,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',982,'2','1',3810899.19,3813873.28,2974.09,490724.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',983,'3','1',1744949.37,1745013.01,63.64,10500.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',984,'4','1',2188036.99,2188852.73,815.74,134597.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',985,'5','1',1954233.02,1954685.01,451.99,74578.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',986,'6','1',1638659.49,1641167.85,2508.36,413879.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',987,'7','1',1758141.63,1758623.32,481.69,79478.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',988,'8','1',2388544.78,2389500.69,955.91,157725.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',989,'9','1',2020414.62,2022823.37,2408.75,397443.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','36',990,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',991,'11','1',3074556.83,3082076.85,7520.02,1240803.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',992,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',993,'13','1',2083088.95,2083088.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',994,'14','1',3328090.34,3335674.97,7584.63,1251463.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',995,'15','1',2676389.91,2684538.49,8148.58,1344515.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',996,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',997,'17','1',2564684.36,2570748.50,6064.14,1000583.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',998,'18','1',2526339.46,2532556.66,6217.20,1025838.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',999,'19','1',2573813.09,2580682.10,6869.01,1133386.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','36',1000,'20','1',2576491.52,2583470.49,6978.97,1151530.05,0.00,0.00,0.00,0.00,0.00),('21','228','3','36',1001,'21','2',1561594.09,1566045.89,4451.80,3116260.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','36',1002,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','36',1003,'23','2',2112866.32,2112866.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','36',1004,'24','2',1116656.30,1118025.40,1369.10,958370.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','36',1005,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','36',1006,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','36',1007,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','36',1008,'28','3',792369.04,793626.42,1257.38,691559.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1009,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1010,'2','1',3813873.28,3822770.32,8897.04,1468011.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1011,'3','1',1745013.01,1750319.96,5306.95,875646.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1012,'4','1',2188852.73,2193805.24,4952.51,817164.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1013,'5','1',1954685.01,1958987.69,4302.68,709942.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1014,'6','1',1641167.85,1646271.35,5103.50,842077.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1015,'7','1',1758623.32,1763816.63,5193.31,856896.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1016,'8','1',2389500.69,2395046.87,5546.18,915119.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1017,'9','1',2022823.37,2029871.54,7048.17,1162948.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','37',1018,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1019,'11','1',3082076.85,3084174.39,2097.54,346094.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1020,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1021,'13','1',2083088.95,2083088.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1022,'14','1',3335674.97,3335674.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1023,'15','1',2684538.49,2685363.32,824.83,136096.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1024,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1025,'17','1',2570748.50,2570748.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1026,'18','1',2532556.66,2532556.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1027,'19','1',2580682.10,2580682.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','37',1028,'20','1',2583470.49,2585486.24,2015.75,332598.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','37',1029,'21','2',1566045.89,1568701.64,2655.75,1859025.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','37',1030,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','37',1031,'23','2',2112866.32,2112866.36,0.04,28.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','37',1032,'24','2',1118025.40,1118025.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','37',1033,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','37',1034,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','37',1035,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','37',1036,'28','3',793626.42,795764.48,2138.06,1175933.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1037,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1038,'2','1',3822770.32,3827562.78,4792.46,790755.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1039,'3','1',1750319.96,1753292.69,2972.73,490500.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1040,'4','1',2193805.24,2196406.14,2600.90,429148.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1041,'5','1',1958987.69,1961284.57,2296.88,378985.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1042,'6','1',1646271.35,1649504.18,3232.83,533416.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1043,'7','1',1763816.63,1766626.90,2810.27,463694.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1044,'8','1',2395046.87,2397705.77,2658.90,438718.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1045,'9','1',2029871.54,2034470.87,4599.33,758889.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','38',1046,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1047,'11','1',3084174.39,3085938.47,1764.08,291073.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1048,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1049,'13','1',2083088.95,2083088.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1050,'14','1',3335674.97,3337294.93,1619.96,267293.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1051,'15','1',2685363.32,2686991.48,1628.16,268646.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1052,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1053,'17','1',2570748.50,2571108.75,360.25,59441.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1054,'18','1',2532556.66,2533917.76,1361.10,224581.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1055,'19','1',2580682.10,2581274.04,591.94,97670.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','38',1056,'20','1',2585486.24,2586618.45,1132.21,186814.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','38',1057,'21','2',1568701.64,1571991.93,3290.29,2303203.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','38',1058,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','38',1059,'23','2',2112866.36,2112866.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','38',1060,'24','2',1118025.40,1119122.78,1097.38,768166.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','38',1061,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','38',1062,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','38',1063,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','38',1064,'28','3',795764.48,797621.92,1857.44,1021592.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1065,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1066,'2','1',3827562.78,3835516.42,7953.64,1312350.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1067,'3','1',1753292.69,1757945.55,4652.86,767721.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1068,'4','1',2196406.14,2201352.07,4945.93,816078.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1069,'5','1',1961284.57,1965610.63,4326.06,713799.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1070,'6','1',1649504.18,1653925.85,4421.67,729575.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1071,'7','1',1766626.90,1771229.37,4602.47,759407.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1072,'8','1',2397705.77,2403197.02,5491.25,906056.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1073,'9','1',2034470.87,2040643.95,6173.08,1018558.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','39',1074,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1075,'11','1',3085938.47,3088419.36,2480.89,409346.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1076,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1077,'13','1',2083088.95,2083088.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1078,'14','1',3337294.93,3339494.05,2199.12,362854.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1079,'15','1',2686991.48,2688940.34,1948.86,321561.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1080,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1081,'17','1',2571108.75,2572369.67,1260.92,208051.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1082,'18','1',2533917.76,2535360.96,1443.20,238128.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1083,'19','1',2581274.04,2582484.15,1210.11,199668.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','39',1084,'20','1',2586618.45,2587863.43,1244.98,205421.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','39',1085,'21','2',1571991.93,1575195.47,3203.54,2242478.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','39',1086,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','39',1087,'23','2',2112866.36,2112866.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','39',1088,'24','2',1119122.78,1119649.73,526.95,368865.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','39',1089,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','39',1090,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','39',1091,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','39',1092,'28','3',797621.92,800175.94,2554.02,1404711.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1093,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1094,'2','1',3835516.42,3841795.84,6279.42,1036104.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1095,'3','1',1757945.55,1759116.08,1170.53,193137.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1096,'4','1',2201352.07,2206387.57,5035.50,830857.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1097,'5','1',1965610.63,1967777.19,2166.56,357482.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1098,'6','1',1653925.85,1657323.92,3398.07,560681.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1099,'7','1',1771229.37,1772545.90,1316.53,217227.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1100,'8','1',2403197.02,2406635.37,3438.35,567327.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1101,'9','1',2040643.95,2045023.45,4379.50,722617.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','40',1102,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1103,'11','1',3088419.36,3093758.87,5339.51,881019.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1104,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1105,'13','1',2083088.95,2083090.21,1.26,207.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1106,'14','1',3339494.05,3344163.13,4669.08,770398.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1107,'15','1',2688940.34,2694433.01,5492.67,906290.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1108,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1109,'17','1',2572369.67,2575018.61,2648.94,437075.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1110,'18','1',2535360.96,2538200.86,2839.90,468583.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1111,'19','1',2582484.15,2585747.08,3262.93,538383.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','40',1112,'20','1',2587863.43,2591361.41,3497.98,577166.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','40',1113,'21','2',1575195.47,1577421.89,2226.42,1558494.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','40',1114,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','40',1115,'23','2',2112866.36,2112866.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','40',1116,'24','2',1119649.73,1119649.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','40',1117,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','40',1118,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','40',1119,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','40',1120,'28','3',800175.94,802042.45,1866.51,1026580.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1121,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1122,'2','1',3841795.84,3848823.17,7027.33,1159509.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1123,'3','1',1759116.08,1761143.29,2027.21,334489.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1124,'4','1',2206387.57,2212542.04,6154.47,1015487.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1125,'5','1',1967777.19,1971765.36,3988.17,658048.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1126,'6','1',1657323.92,1661206.12,3882.20,640563.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1127,'7','1',1772545.90,1773305.76,759.86,125376.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1128,'8','1',2406635.37,2412107.29,5471.92,902866.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1129,'9','1',2045023.45,2050969.01,5945.56,981017.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','41',1130,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1131,'11','1',3093758.87,3099623.06,5864.19,967591.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1132,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1133,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1134,'14','1',3344163.13,3350236.18,6073.05,1002053.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1135,'15','1',2694433.01,2700134.67,5701.66,940773.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1136,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1137,'17','1',2575018.61,2578742.23,3723.62,614397.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1138,'18','1',2538200.86,2541795.11,3594.25,593051.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1139,'19','1',2585747.08,2589152.65,3405.57,561919.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','41',1140,'20','1',2591361.41,2594696.21,3334.80,550242.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','41',1141,'21','2',1577421.89,1577421.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','41',1142,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','41',1143,'23','2',2112866.36,2112866.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','41',1144,'24','2',1119649.73,1119649.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','41',1145,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','41',1146,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','41',1147,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','41',1148,'28','3',802042.45,804054.80,2012.35,1106792.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1149,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1150,'2','1',3848823.17,3857986.33,9163.16,1511921.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1151,'3','1',1761143.29,1768391.11,7247.82,1195890.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1152,'4','1',2212542.04,2214987.78,2445.74,403547.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1153,'5','1',1971765.36,1975108.40,3343.04,551601.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1154,'6','1',1661206.12,1666737.26,5531.14,912638.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1155,'7','1',1773305.76,1777586.11,4280.35,706257.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1156,'8','1',2412107.29,2418419.94,6312.65,1041587.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1157,'9','1',2050969.01,2058762.51,7793.50,1285927.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','42',1158,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1159,'11','1',3099623.06,3106419.09,6796.03,1121344.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1160,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1161,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1162,'14','1',3350236.18,3351305.12,1068.94,176375.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1163,'15','1',2700134.67,2706743.53,6608.86,1090461.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1164,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1165,'17','1',2578742.23,2578742.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1166,'18','1',2541795.11,2547732.87,5937.76,979730.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1167,'19','1',2589152.65,2594059.47,4906.82,809625.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','42',1168,'20','1',2594696.21,2598385.31,3689.10,608701.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','42',1169,'21','2',1577421.89,1577421.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','42',1170,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','42',1171,'23','2',2112866.36,2112866.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','42',1172,'24','2',1119649.73,1119649.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','42',1173,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','42',1174,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','42',1175,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','42',1176,'28','3',804054.80,806564.57,2509.77,1380373.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1177,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1178,'2','1',3857986.33,3862484.81,4498.48,742249.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1179,'3','1',1768391.11,1771345.87,2954.76,487535.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1180,'4','1',2214987.78,2218212.39,3224.61,532060.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1181,'5','1',1975108.40,1978127.16,3018.76,498095.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1182,'6','1',1666737.26,1670172.05,3434.79,566740.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1183,'7','1',1777586.11,1780464.73,2878.62,474972.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1184,'8','1',2418419.94,2422188.73,3768.79,621850.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1185,'9','1',2058762.51,2063523.60,4761.09,785579.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','43',1186,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1187,'11','1',3106419.09,3106419.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1188,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1189,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1190,'14','1',3351305.12,3351305.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1191,'15','1',2706743.53,2706743.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1192,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1193,'17','1',2578742.23,2578742.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1194,'18','1',2547732.87,2547732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1195,'19','1',2594059.47,2594059.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','43',1196,'20','1',2598385.31,2598385.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','43',1197,'21','2',1577421.89,1577421.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','43',1198,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','43',1199,'23','2',2112866.36,2112866.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','43',1200,'24','2',1119649.73,1119649.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','43',1201,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','43',1202,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','43',1203,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','43',1204,'28','3',806564.57,809809.81,3245.24,1784882.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1205,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1206,'2','1',3862484.81,3865042.79,2557.98,422066.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1207,'3','1',1771345.87,1773044.30,1698.43,280240.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1208,'4','1',2218212.39,2218609.19,396.80,65472.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1209,'5','1',1978127.16,1978127.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1210,'6','1',1670172.05,1671758.49,1586.44,261762.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1211,'7','1',1780464.73,1780464.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1212,'8','1',2422188.73,2424166.55,1977.82,326340.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1213,'9','1',2063523.60,2065522.13,1998.53,329757.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','44',1214,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1215,'11','1',3106419.09,3108743.80,2324.71,383577.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1216,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1217,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1218,'14','1',3351305.12,3353759.92,2454.80,405042.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1219,'15','1',2706743.53,2708759.23,2015.70,332590.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1220,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1221,'17','1',2578742.23,2578742.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1222,'18','1',2547732.87,2550184.46,2451.59,404512.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1223,'19','1',2594059.47,2596532.24,2472.77,408007.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','44',1224,'20','1',2598385.31,2598424.32,39.01,6436.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','44',1225,'21','2',1577421.89,1579210.49,1788.60,1252020.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','44',1226,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','44',1227,'23','2',2112866.36,2112866.55,0.19,133.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','44',1228,'24','2',1119649.73,1119659.02,9.29,6503.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','44',1229,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','44',1230,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','44',1231,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','44',1232,'28','3',809809.81,811541.68,1731.87,952528.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1233,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1234,'2','1',3865042.79,3873112.98,8070.19,1331581.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1235,'3','1',1773044.30,1779898.34,6854.04,1130916.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1236,'4','1',2218609.19,2219027.73,418.54,69059.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1237,'5','1',1978127.16,1978127.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1238,'6','1',1671758.49,1677384.67,5626.18,928319.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1239,'7','1',1780464.73,1781160.29,695.56,114767.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1240,'8','1',2424166.55,2429543.32,5376.77,887167.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1241,'9','1',2065522.13,2070888.76,5366.63,885493.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','45',1242,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1243,'11','1',3108743.80,3114191.97,5448.17,898948.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1244,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1245,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1246,'14','1',3353759.92,3353759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1247,'15','1',2708759.23,2713964.32,5205.09,858839.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1248,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1249,'17','1',2578742.23,2578742.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1250,'18','1',2550184.46,2555179.74,4995.28,824221.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1251,'19','1',2596532.24,2601996.43,5464.19,901591.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','45',1252,'20','1',2598424.32,2598434.01,9.69,1598.85,0.00,0.00,0.00,0.00,0.00),('21','228','3','45',1253,'21','2',1579210.49,1580832.36,1621.87,1135309.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','45',1254,'22','2',1999771.53,1999771.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','45',1255,'23','2',2112866.55,2112866.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','45',1256,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','45',1257,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','45',1258,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','45',1259,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','45',1260,'28','3',811541.68,814980.88,3439.20,1891560.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1261,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1262,'2','1',3873112.98,3875930.70,2817.72,464923.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1263,'3','1',1779898.34,1781511.60,1613.26,266187.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1264,'4','1',2219027.73,2220768.24,1740.51,287184.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1265,'5','1',1978127.16,1978129.84,2.68,442.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1266,'6','1',1677384.67,1679412.47,2027.80,334587.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1267,'7','1',1781160.29,1782819.35,1659.06,273744.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1268,'8','1',2429543.32,2430937.94,1394.62,230112.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1269,'9','1',2070888.76,2073483.40,2594.64,428115.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','46',1270,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1271,'11','1',3114191.97,3114191.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1272,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1273,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1274,'14','1',3353759.92,3353759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1275,'15','1',2713964.32,2713964.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1276,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1277,'17','1',2578742.23,2578742.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1278,'18','1',2555179.74,2555179.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1279,'19','1',2601996.43,2601996.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','46',1280,'20','1',2598434.01,2598434.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','46',1281,'21','2',1580832.36,1583387.14,2554.78,1788346.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','46',1282,'22','2',1999771.53,2000041.75,270.22,189154.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','46',1283,'23','2',2112866.55,2112866.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','46',1284,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','46',1285,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','46',1286,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','46',1287,'27','3',461323.64,461323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','46',1288,'28','3',814980.88,817497.18,2516.30,1383965.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1289,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1290,'2','1',3875930.70,3880643.74,4713.04,777651.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1291,'3','1',1781511.60,1785123.72,3612.12,595999.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1292,'4','1',2220768.24,2221072.52,304.28,50206.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1293,'5','1',1978129.84,1979395.90,1266.06,208899.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1294,'6','1',1679412.47,1682241.25,2828.78,466748.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1295,'7','1',1782819.35,1783604.65,785.30,129574.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1296,'8','1',2430937.94,2433654.33,2716.39,448204.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1297,'9','1',2073483.40,2076763.34,3279.94,541190.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','47',1298,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1299,'11','1',3114191.97,3119816.26,5624.29,928007.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1300,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1301,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1302,'14','1',3353759.92,3358700.29,4940.37,815161.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1303,'15','1',2713964.32,2721319.85,7355.53,1213662.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1304,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1305,'17','1',2578742.23,2579950.99,1208.76,199445.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1306,'18','1',2555179.74,2558411.37,3231.63,533218.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1307,'19','1',2601996.43,2606604.49,4608.06,760329.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','47',1308,'20','1',2598434.01,2604423.23,5989.22,988221.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','47',1309,'21','2',1583387.14,1585530.92,2143.78,1500646.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','47',1310,'22','2',2000041.75,2001428.36,1386.61,970627.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','47',1311,'23','2',2112866.55,2112866.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','47',1312,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','47',1313,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','47',1314,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','47',1315,'27','3',461323.64,461323.81,0.17,93.50,0.00,0.00,0.00,0.00,0.00),('21','228','4','47',1316,'28','3',817497.18,822295.87,4798.69,2639279.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1317,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1318,'2','1',3880643.74,3885660.33,5016.59,827737.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1319,'3','1',1785123.72,1788716.57,3592.85,592820.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1320,'4','1',2221072.52,2223085.92,2013.40,332211.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1321,'5','1',1979395.90,1979395.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1322,'6','1',1682241.25,1686081.05,3839.80,633567.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1323,'7','1',1783604.65,1786025.89,2421.24,399504.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1324,'8','1',2433654.33,2434971.11,1316.78,217268.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1325,'9','1',2076763.34,2080486.15,3722.81,614263.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','48',1326,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1327,'11','1',3119816.26,3126306.22,6489.96,1070843.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1328,'12','1',3573037.92,3573037.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1329,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1330,'14','1',3358700.29,3365356.54,6656.25,1098281.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1331,'15','1',2721319.85,2723082.69,1762.84,290868.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1332,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1333,'17','1',2579950.99,2587171.88,7220.89,1191446.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1334,'18','1',2558411.37,2558411.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1335,'19','1',2606604.49,2608685.37,2080.88,343345.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','48',1336,'20','1',2604423.23,2610139.80,5716.57,943234.05,0.00,0.00,0.00,0.00,0.00),('21','228','3','48',1337,'21','2',1585530.92,1588169.32,2638.40,1846880.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','48',1338,'22','2',2001428.36,2002892.40,1464.04,1024828.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','48',1339,'23','2',2112866.55,2112866.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','48',1340,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','48',1341,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','48',1342,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','48',1343,'27','3',461323.81,461324.45,0.64,352.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','48',1344,'28','3',822295.87,830385.80,8089.93,4449461.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1345,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1346,'2','1',3885660.33,3894002.48,8342.15,1376454.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1347,'3','1',1788716.57,1792099.33,3382.76,558155.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1348,'4','1',2223085.92,2226687.92,3602.00,594330.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1349,'5','1',1979395.90,1982031.22,2635.32,434827.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1350,'6','1',1686081.05,1691025.85,4944.80,815892.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1351,'7','1',1786025.89,1788199.82,2173.93,358698.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1352,'8','1',2434971.11,2439246.36,4275.25,705416.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1353,'9','1',2080486.15,2084715.09,4228.94,697775.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','49',1354,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1355,'11','1',3126306.22,3132769.11,6462.89,1066376.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1356,'12','1',3573037.92,3573038.74,0.82,135.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1357,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1358,'14','1',3365356.54,3370831.08,5474.54,903299.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1359,'15','1',2723082.69,2727052.66,3969.97,655045.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1360,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1361,'17','1',2587171.88,2592532.65,5360.77,884527.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1362,'18','1',2558411.37,2560923.10,2511.73,414435.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1363,'19','1',2608685.37,2613143.01,4457.64,735510.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','49',1364,'20','1',2610139.80,2612026.36,1886.56,311282.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','49',1365,'21','2',1588169.32,1590183.98,2014.66,1410262.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','49',1366,'22','2',2002892.40,2003794.78,902.38,631666.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','49',1367,'23','2',2112866.55,2112866.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','49',1368,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','49',1369,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','49',1370,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','49',1371,'27','3',461324.45,461324.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','49',1372,'28','3',830385.80,832901.42,2515.62,1383591.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1373,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1374,'2','1',3894002.48,3902551.31,8548.83,1410556.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1375,'3','1',1792099.33,1798420.68,6321.35,1043022.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1376,'4','1',2226687.92,2232273.16,5585.24,921564.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1377,'5','1',1982031.22,1984710.44,2679.22,442071.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1378,'6','1',1691025.85,1696559.58,5533.73,913065.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1379,'7','1',1788199.82,1790737.48,2537.66,418713.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1380,'8','1',2439246.36,2444917.74,5671.38,935777.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1381,'9','1',2084715.09,2090989.90,6274.81,1035343.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','50',1382,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1383,'11','1',3132769.11,3135606.90,2837.79,468235.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1384,'12','1',3573038.74,3573038.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1385,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1386,'14','1',3370831.08,3372711.05,1879.97,310195.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1387,'15','1',2727052.66,2729417.20,2364.54,390149.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1388,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1389,'17','1',2592532.65,2595210.68,2678.03,441874.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1390,'18','1',2560923.10,2560923.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1391,'19','1',2613143.01,2616299.20,3156.19,520771.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','50',1392,'20','1',2612026.36,2612026.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','50',1393,'21','2',1590183.98,1592039.67,1855.69,1298983.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','50',1394,'22','2',2003794.78,2005412.77,1617.99,1132593.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','50',1395,'23','2',2112866.55,2112866.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','50',1396,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','50',1397,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','50',1398,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','50',1399,'27','3',461324.45,461324.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','50',1400,'28','3',832901.42,833893.36,991.94,644761.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1401,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1402,'2','1',3902551.31,3911193.69,8642.38,1425992.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1403,'3','1',1798420.68,1804864.12,6443.44,1063167.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1404,'4','1',2232273.16,2236893.54,4620.38,762362.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1405,'5','1',1984710.44,1987272.21,2561.77,422692.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1406,'6','1',1696559.58,1702682.12,6122.54,1010219.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1407,'7','1',1790737.48,1793050.68,2313.20,381678.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1408,'8','1',2444917.74,2450892.15,5974.41,985777.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1409,'9','1',2090989.90,2098425.75,7435.85,1226915.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','51',1410,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1411,'11','1',3135606.90,3138965.69,3358.79,554200.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1412,'12','1',3573038.74,3573038.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1413,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1414,'14','1',3372711.05,3375588.85,2877.80,474837.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1415,'15','1',2729417.20,2732569.40,3152.20,520113.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1416,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1417,'17','1',2595210.68,2599002.84,3792.16,625706.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1418,'18','1',2560923.10,2560923.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1419,'19','1',2616299.20,2616299.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','51',1420,'20','1',2612026.36,2615403.97,3377.61,557305.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','51',1421,'21','2',1592039.67,1592837.00,797.33,558131.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','51',1422,'22','2',2005412.77,2005412.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','51',1423,'23','2',2112866.55,2112866.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','51',1424,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','51',1425,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','51',1426,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','51',1427,'27','3',461324.45,461324.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','51',1428,'28','3',833893.36,834549.72,656.36,426634.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1429,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1430,'2','1',3911193.69,3911193.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1431,'3','1',1804864.12,1804864.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1432,'4','1',2236893.54,2236893.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1433,'5','1',1987272.21,1987272.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1434,'6','1',1702682.12,1702682.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1435,'7','1',1793050.68,1793050.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1436,'8','1',2450892.15,2450892.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1437,'9','1',2098425.75,2098425.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','52',1438,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1439,'11','1',3138965.69,3138965.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1440,'12','1',3573038.74,3573038.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1441,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1442,'14','1',3375588.85,3375588.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1443,'15','1',2732569.40,2732569.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1444,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1445,'17','1',2599002.84,2599002.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1446,'18','1',2560923.10,2560923.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1447,'19','1',2616299.20,2616299.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','52',1448,'20','1',2615403.97,2615403.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','52',1449,'21','2',1592837.00,1596903.28,4066.28,2846396.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','52',1450,'22','2',2005412.77,2005412.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','52',1451,'23','2',2112866.55,2112866.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','52',1452,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','52',1453,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','52',1454,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','52',1455,'27','3',461324.45,461964.78,640.33,416214.50,0.00,0.00,0.00,0.00,0.00),('21','228','4','52',1456,'28','3',834549.72,834995.98,446.26,290069.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1457,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1458,'2','1',3911193.69,3919254.26,8060.57,1329994.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1459,'3','1',1804864.12,1809833.73,4969.61,819985.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1460,'4','1',2236893.54,2241752.17,4858.63,801673.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1461,'5','1',1987272.21,1991961.98,4689.77,773812.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1462,'6','1',1702682.12,1707696.76,5014.64,827415.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1463,'7','1',1793050.68,1798347.75,5297.07,874016.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1464,'8','1',2450892.15,2456102.71,5210.56,859742.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1465,'9','1',2098425.75,2105357.88,6932.13,1143801.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','53',1466,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1467,'11','1',3138965.69,3138965.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1468,'12','1',3573038.74,3573038.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1469,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1470,'14','1',3375588.85,3375588.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1471,'15','1',2732569.40,2732569.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1472,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1473,'17','1',2599002.84,2599002.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1474,'18','1',2560923.10,2560923.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1475,'19','1',2616299.20,2616299.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','53',1476,'20','1',2615403.97,2615403.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','53',1477,'21','2',1596903.28,1598387.98,1484.70,1039290.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','53',1478,'22','2',2005412.77,2006204.61,791.84,554288.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','53',1479,'23','2',2112866.55,2113676.17,809.62,566734.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','53',1480,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','53',1481,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','53',1482,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','53',1483,'27','3',461964.78,461965.33,0.55,357.50,0.00,0.00,0.00,0.00,0.00),('21','228','4','53',1484,'28','3',834995.98,836305.85,1309.87,851415.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1485,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1486,'2','1',3919254.26,3919254.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1487,'3','1',1809833.73,1809833.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1488,'4','1',2241752.17,2241752.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1489,'5','1',1991961.98,1991961.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1490,'6','1',1707696.76,1707696.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1491,'7','1',1798347.75,1798347.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1492,'8','1',2456102.71,2456102.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1493,'9','1',2105357.88,2105357.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','54',1494,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1495,'11','1',3138965.69,3138965.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1496,'12','1',3573038.74,3573038.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1497,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1498,'14','1',3375588.85,3375588.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1499,'15','1',2732569.40,2732569.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1500,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1501,'17','1',2599002.84,2599002.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1502,'18','1',2560923.10,2560923.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1503,'19','1',2616299.20,2616299.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','54',1504,'20','1',2615403.97,2615403.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','54',1505,'21','2',1598387.98,1598387.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','54',1506,'22','2',2006204.61,2006204.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','54',1507,'23','2',2113676.17,2113676.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','54',1508,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','54',1509,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','54',1510,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','54',1511,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','54',1512,'28','3',836305.85,836305.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1513,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1514,'2','1',3919254.26,3927042.07,7787.81,1284988.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1515,'3','1',1809833.73,1814014.53,4180.80,689832.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1516,'4','1',2241752.17,2246537.36,4785.19,789556.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1517,'5','1',1991961.98,1996902.90,4940.92,815251.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1518,'6','1',1707696.76,1712957.24,5260.48,867978.54,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1519,'7','1',1798347.75,1802974.66,4626.91,763440.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1520,'8','1',2456102.71,2461850.90,5748.19,948451.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1521,'9','1',2105357.88,2112945.55,7587.67,1251965.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','55',1522,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1523,'11','1',3138965.69,3138965.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1524,'12','1',3573038.74,3573038.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1525,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1526,'14','1',3375588.85,3375588.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1527,'15','1',2732569.40,2732569.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1528,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1529,'17','1',2599002.84,2599002.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1530,'18','1',2560923.10,2560923.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1531,'19','1',2616299.20,2616299.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','55',1532,'20','1',2615403.97,2615403.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','55',1533,'21','2',1598387.98,1600323.66,1935.68,1354976.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','55',1534,'22','2',2006204.61,2006284.75,80.14,56098.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','55',1535,'23','2',2113676.17,2115487.45,1811.28,1267896.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','55',1536,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','55',1537,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','55',1538,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','55',1539,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','55',1540,'28','3',836305.85,837955.24,1649.39,1072103.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1541,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1542,'2','1',3927042.07,3930821.69,3779.62,623637.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1543,'3','1',1814014.53,1817561.54,3547.01,585256.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1544,'4','1',2246537.36,2246540.79,3.43,565.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1545,'5','1',1996902.90,1998354.25,1451.35,239472.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1546,'6','1',1712957.24,1714779.84,1822.60,300729.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1547,'7','1',1802974.66,1804258.07,1283.41,211762.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1548,'8','1',2461850.90,2463560.40,1709.50,282067.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1549,'9','1',2112945.55,2115918.02,2972.47,490457.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','56',1550,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1551,'11','1',3138965.69,3140656.62,1690.93,279003.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1552,'12','1',3573038.74,3573038.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1553,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1554,'14','1',3375588.85,3376913.19,1324.34,218516.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1555,'15','1',2732569.40,2734067.39,1497.99,247168.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1556,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1557,'17','1',2599002.84,2601384.88,2382.04,393036.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1558,'18','1',2560923.10,2560923.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1559,'19','1',2616299.20,2618422.06,2122.86,350271.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','56',1560,'20','1',2615403.97,2615403.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','56',1561,'21','2',1600323.66,1602540.15,2216.49,1551543.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','56',1562,'22','2',2006284.75,2006779.05,494.30,346010.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','56',1563,'23','2',2115487.45,2116715.49,1228.04,859628.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','56',1564,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','56',1565,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','56',1566,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','56',1567,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','56',1568,'28','3',837955.24,839165.48,1210.24,786656.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1569,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1570,'2','1',3930821.69,3935854.17,5032.48,830359.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1571,'3','1',1817561.54,1820943.18,3381.64,557970.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1572,'4','1',2246540.79,2246598.14,57.35,9462.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1573,'5','1',1998354.25,2000780.09,2425.84,400263.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1574,'6','1',1714779.84,1717623.92,2844.08,469273.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1575,'7','1',1804258.07,1806846.21,2588.14,427043.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1576,'8','1',2463560.40,2466250.28,2689.88,443830.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1577,'9','1',2115918.02,2119438.24,3520.22,580836.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','57',1578,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1579,'11','1',3140656.62,3143953.70,3297.08,544018.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1580,'12','1',3573038.74,3578251.85,5213.11,860163.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1581,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1582,'14','1',3376913.19,3381627.08,4713.89,777791.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1583,'15','1',2734067.39,2739254.16,5186.77,855817.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1584,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1585,'17','1',2601384.88,2606383.57,4998.69,824783.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1586,'18','1',2560923.10,2565709.79,4786.69,789803.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1587,'19','1',2618422.06,2623978.08,5556.02,916743.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','57',1588,'20','1',2615403.97,2619977.56,4573.59,754642.35,0.00,0.00,0.00,0.00,0.00),('21','228','3','57',1589,'21','2',1602540.15,1603862.39,1322.24,925568.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','57',1590,'22','2',2006779.05,2006896.98,117.93,82551.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','57',1591,'23','2',2116715.49,2118785.27,2069.78,1448846.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','57',1592,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','57',1593,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','57',1594,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','57',1595,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','57',1596,'28','3',839165.48,840805.23,1639.75,1065837.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1597,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1598,'2','1',3935854.17,3940683.31,4829.14,796808.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1599,'3','1',1820943.18,1825898.27,4955.09,817589.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1600,'4','1',2246598.14,2246599.20,1.06,174.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1601,'5','1',2000780.09,2002510.44,1730.35,285507.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1602,'6','1',1717623.92,1720595.07,2971.15,490239.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1603,'7','1',1806846.21,1810314.66,3468.45,572294.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1604,'8','1',2466250.28,2467702.91,1452.63,239683.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1605,'9','1',2119438.24,2123249.13,3810.89,628796.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','58',1606,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1607,'11','1',3143953.70,3147595.86,3642.16,600956.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1608,'12','1',3578251.85,3582439.08,4187.23,690892.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1609,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1610,'14','1',3381627.08,3385243.77,3616.69,596753.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1611,'15','1',2739254.16,2743353.23,4099.07,676346.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1612,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1613,'17','1',2606383.57,2610564.13,4180.56,689792.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1614,'18','1',2565709.79,2568527.51,2817.72,464923.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1615,'19','1',2623978.08,2629298.38,5320.30,877849.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','58',1616,'20','1',2619977.56,2622928.01,2950.45,486824.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','58',1617,'21','2',1603862.39,1605729.25,1866.86,1344139.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','58',1618,'22','2',2006896.98,2006896.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','58',1619,'23','2',2118785.27,2120162.03,1376.76,991267.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','58',1620,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','58',1621,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','58',1622,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','58',1623,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','58',1624,'28','3',840805.23,842634.32,1829.09,1188908.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1625,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1626,'2','1',3940683.31,3947863.02,7179.71,1184652.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1627,'3','1',1825898.27,1832438.89,6540.62,1079202.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1628,'4','1',2246599.20,2246599.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1629,'5','1',2002510.44,2007086.64,4576.20,755073.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1630,'6','1',1720595.07,1723769.54,3174.47,523787.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1631,'7','1',1810314.66,1815541.91,5227.25,862496.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1632,'8','1',2467702.91,2471127.70,3424.79,565090.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1633,'9','1',2123249.13,2129172.89,5923.76,977420.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','59',1634,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1635,'11','1',3147595.86,3151197.76,3601.90,594313.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1636,'12','1',3582439.08,3586869.28,4430.20,730983.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1637,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1638,'14','1',3385243.77,3390176.09,4932.32,813832.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1639,'15','1',2743353.23,2748254.83,4901.60,808764.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1640,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1641,'17','1',2610564.13,2614538.09,3973.96,655703.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1642,'18','1',2568527.51,2571937.45,3409.94,562640.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1643,'19','1',2629298.38,2634358.07,5059.69,834848.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','59',1644,'20','1',2622928.01,2626063.96,3135.95,517431.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','59',1645,'21','2',1605729.25,1605729.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','59',1646,'22','2',2006896.98,2006896.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','59',1647,'23','2',2120162.03,2122274.40,2112.37,1520906.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','59',1648,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','59',1649,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','59',1650,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','59',1651,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','59',1652,'28','3',842634.32,845107.46,2473.14,1607541.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1653,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1654,'2','1',3947863.02,3955076.29,7213.27,1190189.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1655,'3','1',1832438.89,1840493.49,8054.60,1329009.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1656,'4','1',2246599.20,2246653.81,54.61,9010.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1657,'5','1',2007086.64,2012825.26,5738.62,946872.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1658,'6','1',1723769.54,1728927.87,5158.33,851124.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1659,'7','1',1815541.91,1820746.84,5204.93,858813.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1660,'8','1',2471127.70,2477452.02,6324.32,1043512.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1661,'9','1',2129172.89,2137326.08,8153.19,1345276.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','60',1662,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1663,'11','1',3151197.76,3151197.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1664,'12','1',3586869.28,3586869.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1665,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1666,'14','1',3390176.09,3390176.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1667,'15','1',2748254.83,2748254.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1668,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1669,'17','1',2614538.09,2614538.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1670,'18','1',2571937.45,2571937.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1671,'19','1',2634358.07,2634358.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','60',1672,'20','1',2626063.96,2626063.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','60',1673,'21','2',1605729.25,1607741.32,2012.07,1448690.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','60',1674,'22','2',2006896.98,2007091.43,194.45,140004.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','60',1675,'23','2',2122274.40,2123766.65,1492.25,1074420.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','60',1676,'24','2',1119659.02,1119659.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','60',1677,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','60',1678,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','60',1679,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','60',1680,'28','3',845107.46,846846.21,1738.75,1130187.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1681,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1682,'2','1',3955076.29,3961609.89,6533.60,1078044.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1683,'3','1',1840493.49,1846777.80,6284.31,1036911.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1684,'4','1',2246653.81,2246653.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1685,'5','1',2012825.26,2015572.76,2747.50,453337.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1686,'6','1',1728927.87,1733512.52,4584.65,756467.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1687,'7','1',1820746.84,1825055.13,4308.29,710867.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1688,'8','1',2477452.02,2481687.11,4235.09,698789.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1689,'9','1',2137326.08,2142635.42,5309.34,876041.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','61',1690,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1691,'11','1',3151197.76,3157645.22,6447.46,1063830.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1692,'12','1',3586869.28,3594252.74,7383.46,1218270.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1693,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1694,'14','1',3390176.09,3394262.21,4086.12,674209.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1695,'15','1',2748254.83,2752806.69,4551.86,751056.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1696,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1697,'17','1',2614538.09,2616744.89,2206.80,364122.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1698,'18','1',2571937.45,2579821.44,7883.99,1300858.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1699,'19','1',2634358.07,2641695.48,7337.41,1210672.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','61',1700,'20','1',2626063.96,2631365.40,5301.44,874737.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','61',1701,'21','2',1607741.32,1610562.68,2821.36,2031379.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','61',1702,'22','2',2007091.43,2007091.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','61',1703,'23','2',2123766.65,2125096.09,1329.44,957196.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','61',1704,'24','2',1119659.02,1119668.30,9.28,6681.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','61',1705,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','61',1706,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','61',1707,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','61',1708,'28','3',846846.21,848539.97,1693.76,1100944.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1709,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1710,'2','1',3961609.89,3970129.96,8520.07,1405811.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1711,'3','1',1846777.80,1853761.19,6983.39,1152259.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1712,'4','1',2246653.81,2250734.67,4080.86,673341.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1713,'5','1',2015572.76,2020306.28,4733.52,781030.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1714,'6','1',1733512.52,1739113.25,5600.73,924120.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1715,'7','1',1825055.13,1830569.38,5514.25,909851.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1716,'8','1',2481687.11,2488302.34,6615.23,1091512.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1717,'9','1',2142635.42,2152079.84,9444.42,1558329.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','62',1718,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1719,'11','1',3157645.22,3157645.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1720,'12','1',3594252.74,3594252.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1721,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1722,'14','1',3394262.21,3394262.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1723,'15','1',2752806.69,2752806.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1724,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1725,'17','1',2616744.89,2616744.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1726,'18','1',2579821.44,2579821.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1727,'19','1',2641695.48,2641695.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','62',1728,'20','1',2631365.40,2631365.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','62',1729,'21','2',1610562.68,1612581.98,2019.30,1453896.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','62',1730,'22','2',2007091.43,2007223.16,131.73,94845.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','62',1731,'23','2',2125096.09,2127629.89,2533.80,1824336.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','62',1732,'24','2',1119668.30,1119678.86,10.56,7603.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','62',1733,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','62',1734,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','62',1735,'27','3',461965.33,461965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','62',1736,'28','3',848539.97,849648.93,1108.96,720824.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1737,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1738,'2','1',3970129.96,3976361.81,6231.85,1028255.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1739,'3','1',1853761.19,1857908.30,4147.11,684273.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1740,'4','1',2250734.67,2254097.10,3362.43,554800.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1741,'5','1',2020306.28,2023959.35,3653.07,602756.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1742,'6','1',1739113.25,1742649.93,3536.68,583552.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1743,'7','1',1830569.38,1834301.94,3732.56,615872.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1744,'8','1',2488302.34,2492033.98,3731.64,615720.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1745,'9','1',2152079.84,2158234.89,6155.05,1015583.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','63',1746,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1747,'11','1',3157645.22,3159864.14,2218.92,366121.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1748,'12','1',3594252.74,3596946.16,2693.42,444414.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1749,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1750,'14','1',3394262.21,3397601.36,3339.15,550959.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1751,'15','1',2752806.69,2754329.95,1523.26,251337.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1752,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1753,'17','1',2616744.89,2618856.20,2111.31,348366.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1754,'18','1',2579821.44,2582201.96,2380.52,392785.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1755,'19','1',2641695.48,2643543.88,1848.40,304986.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','63',1756,'20','1',2631365.40,2633740.07,2374.67,391820.55,0.00,0.00,0.00,0.00,0.00),('21','228','3','63',1757,'21','2',1612581.98,1614379.25,1797.27,1294034.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','63',1758,'22','2',2007223.16,2007223.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','63',1759,'23','2',2127629.89,2130144.74,2514.85,1810692.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','63',1760,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','63',1761,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','63',1762,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','63',1763,'27','3',461965.33,461965.43,0.10,65.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','63',1764,'28','3',849648.93,850836.21,1187.28,771732.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1765,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1766,'2','1',3976361.81,3978117.28,1755.47,289652.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1767,'3','1',1857908.30,1859438.61,1530.31,252501.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1768,'4','1',2254097.10,2254100.98,3.88,640.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1769,'5','1',2023959.35,2025054.39,1095.04,180681.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1770,'6','1',1742649.93,1743900.81,1250.88,206395.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1771,'7','1',1834301.94,1835477.68,1175.74,193997.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1772,'8','1',2492033.98,2493284.95,1250.97,206410.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1773,'9','1',2158234.89,2159582.19,1347.30,222304.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','64',1774,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1775,'11','1',3159864.14,3163746.42,3882.28,640576.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1776,'12','1',3596946.16,3600301.54,3355.38,553637.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1777,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1778,'14','1',3397601.36,3400920.59,3319.23,547672.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1779,'15','1',2754329.95,2757129.46,2799.51,461919.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1780,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1781,'17','1',2618856.20,2621946.25,3090.05,509858.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1782,'18','1',2582201.96,2585860.00,3658.04,603576.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1783,'19','1',2643543.88,2646930.26,3386.38,558752.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','64',1784,'20','1',2633740.07,2637027.44,3287.37,542416.05,0.00,0.00,0.00,0.00,0.00),('21','228','3','64',1785,'21','2',1614379.25,1615956.88,1577.63,1135893.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','64',1786,'22','2',2007223.16,2008103.42,880.26,633787.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','64',1787,'23','2',2130144.74,2130978.85,834.11,600559.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','64',1788,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','64',1789,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','64',1790,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','64',1791,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','64',1792,'28','3',850836.21,851989.02,1152.81,749326.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1793,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1794,'2','1',3978117.28,3986000.21,7882.93,1300683.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1795,'3','1',1859438.61,1864255.75,4817.14,794828.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1796,'4','1',2254100.98,2258597.45,4496.47,741917.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1797,'5','1',2025054.39,2029658.68,4604.29,759707.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1798,'6','1',1743900.81,1749247.64,5346.83,882226.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1799,'7','1',1835477.68,1840805.52,5327.84,879093.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1800,'8','1',2493284.95,2499384.70,6099.75,1006458.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1801,'9','1',2159582.19,2167397.52,7815.33,1289529.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','65',1802,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1803,'11','1',3163746.42,3163746.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1804,'12','1',3600301.54,3600301.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1805,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1806,'14','1',3400920.59,3400920.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1807,'15','1',2757129.46,2757129.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1808,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1809,'17','1',2621946.25,2621946.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1810,'18','1',2585860.00,2585860.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1811,'19','1',2646930.26,2646930.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','65',1812,'20','1',2637027.44,2637027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','65',1813,'21','2',1615956.88,1618238.62,2281.74,1642852.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','65',1814,'22','2',2008103.42,2008932.45,829.03,596901.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','65',1815,'23','2',2130978.85,2133838.38,2859.53,2058861.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','65',1816,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','65',1817,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','65',1818,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','65',1819,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','65',1820,'28','3',851989.02,853169.42,1180.40,767260.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1821,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1822,'2','1',3986000.21,3993484.06,7483.85,1234835.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1823,'3','1',1864255.75,1871406.94,7151.19,1179946.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1824,'4','1',2258597.45,2259777.65,1180.20,194733.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1825,'5','1',2029658.68,2034157.76,4499.08,742348.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1826,'6','1',1749247.64,1755094.88,5847.24,964794.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1827,'7','1',1840805.52,1846165.28,5359.76,884360.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1828,'8','1',2499384.70,2505451.64,6066.94,1001045.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1829,'9','1',2167397.52,2175753.06,8355.54,1378664.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','66',1830,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1831,'11','1',3163746.42,3163746.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1832,'12','1',3600301.54,3600301.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1833,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1834,'14','1',3400920.59,3400920.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1835,'15','1',2757129.46,2757129.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1836,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1837,'17','1',2621946.25,2621946.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1838,'18','1',2585860.00,2585860.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1839,'19','1',2646930.26,2646930.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','66',1840,'20','1',2637027.44,2637027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','66',1841,'21','2',1618238.62,1620300.88,2062.26,1484827.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','66',1842,'22','2',2008932.45,2008932.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','66',1843,'23','2',2133838.38,2134150.88,312.50,225000.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','66',1844,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','66',1845,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','66',1846,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','66',1847,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','66',1848,'28','3',853169.42,854018.70,849.28,552032.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1849,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1850,'2','1',3993484.06,4000336.15,6852.09,1130594.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1851,'3','1',1871406.94,1877811.28,6404.34,1056716.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1852,'4','1',2259777.65,2260962.38,1184.73,195480.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1853,'5','1',2034157.76,2038946.20,4788.44,790092.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1854,'6','1',1755094.88,1760931.83,5836.95,963096.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1855,'7','1',1846165.28,1852451.00,6285.72,1037143.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1856,'8','1',2505451.64,2511448.38,5996.74,989462.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1857,'9','1',2175753.06,2183857.00,8103.94,1337150.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','67',1858,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1859,'11','1',3163746.42,3163746.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1860,'12','1',3600301.54,3602217.19,1915.65,316082.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1861,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1862,'14','1',3400920.59,3402034.88,1114.29,183857.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1863,'15','1',2757129.46,2758451.27,1321.81,218098.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1864,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1865,'17','1',2621946.25,2623143.66,1197.41,197572.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1866,'18','1',2585860.00,2586085.48,225.48,37204.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1867,'19','1',2646930.26,2648324.96,1394.70,230125.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','67',1868,'20','1',2637027.44,2637027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','67',1869,'21','2',1620300.88,1622418.88,2118.00,1609680.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','67',1870,'22','2',2008932.45,2009697.92,765.47,581757.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','67',1871,'23','2',2134150.88,2135811.87,1660.99,1262352.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','67',1872,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','67',1873,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','67',1874,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','67',1875,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','67',1876,'28','3',854018.70,855677.04,1658.34,1077921.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1877,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1878,'2','1',4000336.15,4007200.90,6864.75,1132683.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1879,'3','1',1877811.28,1882745.39,4934.11,814128.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1880,'4','1',2260962.38,2262400.81,1438.43,237340.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1881,'5','1',2038946.20,2041992.35,3046.15,502614.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1882,'6','1',1760931.83,1765496.01,4564.18,753089.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1883,'7','1',1852451.00,1855489.26,3038.26,501312.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1884,'8','1',2511448.38,2516925.84,5477.46,903780.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1885,'9','1',2183857.00,2190425.50,6568.50,1083802.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','68',1886,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1887,'11','1',3163746.42,3165410.91,1664.49,274640.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1888,'12','1',3602217.19,3602906.89,689.70,113800.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1889,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1890,'14','1',3402034.88,3403536.10,1501.22,247701.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1891,'15','1',2758451.27,2759890.60,1439.33,237489.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1892,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1893,'17','1',2623143.66,2625337.13,2193.47,361922.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1894,'18','1',2586085.48,2586115.38,29.90,4933.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1895,'19','1',2648324.96,2649673.63,1348.67,222530.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','68',1896,'20','1',2637027.44,2637947.46,920.02,151803.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','68',1897,'21','2',1622418.88,1622964.33,545.45,414542.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','68',1898,'22','2',2009697.92,2010480.69,782.77,594905.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','68',1899,'23','2',2135811.87,2137314.62,1502.75,1142090.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','68',1900,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','68',1901,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','68',1902,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','68',1903,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','68',1904,'28','3',855677.04,856956.22,1279.18,831467.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1905,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1906,'2','1',4007200.90,4015470.63,8269.73,1364505.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1907,'3','1',1882745.39,1889892.78,7147.39,1179319.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1908,'4','1',2262400.81,2262551.26,150.45,24824.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1909,'5','1',2041992.35,2047177.13,5184.78,855488.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1910,'6','1',1765496.01,1772414.14,6918.13,1141491.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1911,'7','1',1855489.26,1860733.73,5244.47,865337.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1912,'8','1',2516925.84,2524873.91,7948.07,1311431.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1913,'9','1',2190425.50,2198595.37,8169.87,1348028.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','69',1914,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1915,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1916,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1917,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1918,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1919,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1920,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1921,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1922,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1923,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','69',1924,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','69',1925,'21','2',1622964.33,1624668.61,1704.28,1295252.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','69',1926,'22','2',2010480.69,2010666.18,185.49,140972.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','69',1927,'23','2',2137314.62,2138421.49,1106.87,841221.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','69',1928,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','69',1929,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','69',1930,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','69',1931,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','69',1932,'28','3',856956.22,858168.62,1212.40,788060.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1933,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1934,'2','1',4015470.63,4025887.07,10416.44,1718712.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1935,'3','1',1889892.78,1899355.52,9462.74,1561352.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1936,'4','1',2262551.26,2264418.51,1867.25,308096.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1937,'5','1',2047177.13,2053756.17,6579.04,1085541.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1938,'6','1',1772414.14,1780238.97,7824.83,1291096.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1939,'7','1',1860733.73,1867612.22,6878.49,1134950.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1940,'8','1',2524873.91,2533980.82,9106.91,1502640.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1941,'9','1',2198595.37,2208826.14,10230.77,1688077.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','70',1942,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1943,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1944,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1945,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1946,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1947,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1948,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1949,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1950,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1951,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','70',1952,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','70',1953,'21','2',1624668.61,1626138.83,1470.22,1117367.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','70',1954,'22','2',2010666.18,2010745.58,79.40,60344.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','70',1955,'23','2',2138421.49,2141025.04,2603.55,1978698.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','70',1956,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','70',1957,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','70',1958,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','70',1959,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','70',1960,'28','3',858168.62,859511.70,1343.08,873002.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1961,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1962,'2','1',4025887.07,4028481.35,2594.28,428056.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1963,'3','1',1899355.52,1901615.17,2259.65,372842.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1964,'4','1',2264418.51,2264418.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1965,'5','1',2053756.17,2055446.72,1690.55,278940.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1966,'6','1',1780238.97,1782164.40,1925.43,317695.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1967,'7','1',1867612.22,1869135.62,1523.40,251361.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1968,'8','1',2533980.82,2536525.57,2544.75,419883.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1969,'9','1',2208826.14,2211406.81,2580.67,425810.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','71',1970,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1971,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1972,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1973,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1974,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1975,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1976,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1977,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1978,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1979,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','71',1980,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','71',1981,'21','2',1626138.83,1629295.87,3157.04,2399350.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','71',1982,'22','2',2010745.58,2011874.58,1129.00,858040.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','71',1983,'23','2',2141025.04,2142921.69,1896.65,1441454.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','71',1984,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','71',1985,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','71',1986,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','71',1987,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','71',1988,'28','3',859511.70,860557.56,1045.86,679809.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1989,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1990,'2','1',4028481.35,4037050.18,8568.83,1413856.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1991,'3','1',1901615.17,1907909.67,6294.50,1038592.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1992,'4','1',2264418.51,2269998.06,5579.55,920625.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1993,'5','1',2055446.72,2060762.42,5315.70,877090.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1994,'6','1',1782164.40,1788905.30,6740.90,1112248.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1995,'7','1',1869135.62,1875786.29,6650.67,1097360.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1996,'8','1',2536525.57,2543073.16,6547.59,1080352.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1997,'9','1',2211406.81,2220001.87,8595.06,1418184.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','72',1998,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',1999,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2000,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2001,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2002,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2003,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2004,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2005,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2006,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2007,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','72',2008,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','72',2009,'21','2',1629295.87,1631212.11,1916.24,1456342.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','72',2010,'22','2',2011874.58,2012180.63,306.05,232598.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','72',2011,'23','2',2142921.69,2147476.22,4554.53,3461442.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','72',2012,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','72',2013,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','72',2014,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','72',2015,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','72',2016,'28','3',860557.56,861880.48,1322.92,859898.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2017,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2018,'2','1',4037050.18,4043463.69,6413.51,1058229.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2019,'3','1',1907909.67,1912393.57,4483.90,739843.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2020,'4','1',2269998.06,2274850.24,4852.18,800609.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2021,'5','1',2060762.42,2065517.93,4755.51,784659.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2022,'6','1',1788905.30,1793880.49,4975.19,820906.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2023,'7','1',1875786.29,1880740.41,4954.12,817429.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2024,'8','1',2543073.16,2548813.55,5740.39,947164.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2025,'9','1',2220001.87,2226722.16,6720.29,1108847.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','73',2026,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2027,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2028,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2029,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2030,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2031,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2032,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2033,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2034,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2035,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','73',2036,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','73',2037,'21','2',1631212.11,1633050.38,1838.27,1397085.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','73',2038,'22','2',2012180.63,2012180.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','73',2039,'23','2',2147476.22,2148566.54,1090.32,828643.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','73',2040,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','73',2041,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','73',2042,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','73',2043,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','73',2044,'28','3',861880.48,863126.08,1245.60,809640.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2045,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2046,'2','1',4043463.69,4049484.77,6021.08,993478.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2047,'3','1',1912393.57,1917232.02,4838.45,798344.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2048,'4','1',2274850.24,2278968.38,4118.14,679493.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2049,'5','1',2065517.93,2069676.61,4158.68,686182.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2050,'6','1',1793880.49,1798974.26,5093.77,840472.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2051,'7','1',1880740.41,1885113.80,4373.39,721609.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2052,'8','1',2548813.55,2554342.68,5529.13,912306.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2053,'9','1',2226722.16,2232798.97,6076.81,1002673.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','74',2054,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2055,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2056,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2057,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2058,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2059,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2060,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2061,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2062,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2063,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','74',2064,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','74',2065,'21','2',1633050.38,1635567.61,2517.23,1913094.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','74',2066,'22','2',2012180.63,2012184.31,3.68,2796.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','74',2067,'23','2',2148566.54,2151588.52,3021.98,2296704.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','74',2068,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','74',2069,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','74',2070,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','74',2071,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','74',2072,'28','3',863126.08,864440.02,1313.94,854061.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2073,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2074,'2','1',4049484.77,4053544.94,4060.17,669928.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2075,'3','1',1917232.02,1921145.62,3913.60,645744.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2076,'4','1',2278968.38,2282639.95,3671.57,605809.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2077,'5','1',2069676.61,2072629.56,2952.95,487236.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2078,'6','1',1798974.26,1802987.61,4013.35,662202.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2079,'7','1',1885113.80,1888905.86,3792.06,625689.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2080,'8','1',2554342.68,2558774.32,4431.64,731220.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2081,'9','1',2232798.97,2237280.93,4481.96,739523.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','75',2082,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2083,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2084,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2085,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2086,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2087,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2088,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2089,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2090,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2091,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','75',2092,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','75',2093,'21','2',1635567.61,1637730.38,2162.77,1643705.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','75',2094,'22','2',2012184.31,2012184.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','75',2095,'23','2',2151588.52,2153632.06,2043.54,1553090.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','75',2096,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','75',2097,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','75',2098,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','75',2099,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','75',2100,'28','3',864440.02,865630.35,1190.33,773714.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2101,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2102,'2','1',4053544.94,4063693.77,10148.83,1674556.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2103,'3','1',1921145.62,1927850.74,6705.12,1106344.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2104,'4','1',2282639.95,2290425.22,7785.27,1284569.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2105,'5','1',2072629.56,2079319.68,6690.12,1103869.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2106,'6','1',1802987.61,1810756.83,7769.22,1281921.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2107,'7','1',1888905.86,1895580.04,6674.18,1101239.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2108,'8','1',2558774.32,2568253.19,9478.87,1564013.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2109,'9','1',2237280.93,2246597.28,9316.35,1537197.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','76',2110,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2111,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2112,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2113,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2114,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2115,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2116,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2117,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2118,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2119,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','76',2120,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','76',2121,'21','2',1637730.38,1638740.65,1010.27,767805.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','76',2122,'22','2',2012184.31,2013295.75,1111.44,844694.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','76',2123,'23','2',2153632.06,2155211.77,1579.71,1200579.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','76',2124,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','76',2125,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','76',2126,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','76',2127,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','76',2128,'28','3',865630.35,866701.90,1071.55,696507.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2129,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2130,'2','1',4063693.77,4069024.63,5330.86,879591.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2131,'3','1',1927850.74,1932322.78,4472.04,737886.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2132,'4','1',2290425.22,2294817.74,4392.52,724765.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2133,'5','1',2079319.68,2083377.78,4058.10,669586.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2134,'6','1',1810756.83,1815911.43,5154.60,850509.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2135,'7','1',1895580.04,1899706.19,4126.15,680814.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2136,'8','1',2568253.19,2573183.49,4930.30,813499.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2137,'9','1',2246597.28,2252372.26,5774.98,952871.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','77',2138,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2139,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2140,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2141,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2142,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2143,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2144,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2145,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2146,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2147,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','77',2148,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','77',2149,'21','2',1638740.65,1641263.93,2523.28,1917692.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','77',2150,'22','2',2013295.75,2013645.28,349.53,265642.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','77',2151,'23','2',2155211.77,2156950.04,1738.27,1321085.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','77',2152,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','77',2153,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','77',2154,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','77',2155,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','77',2156,'28','3',866701.90,867935.57,1233.67,801885.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2157,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2158,'2','1',4069024.63,4075962.07,6937.44,1144677.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2159,'3','1',1932322.78,1936959.27,4636.49,765020.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2160,'4','1',2294817.74,2299280.01,4462.27,736274.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2161,'5','1',2083377.78,2087796.45,4418.67,729080.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2162,'6','1',1815911.43,1821161.92,5250.49,866330.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2163,'7','1',1899706.19,1904452.05,4745.86,783066.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2164,'8','1',2573183.49,2578201.27,5017.78,827933.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2165,'9','1',2252372.26,2257972.34,5600.08,924013.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','78',2166,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2167,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2168,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2169,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2170,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2171,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2172,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2173,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2174,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2175,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','78',2176,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','78',2177,'21','2',1641263.93,1644157.63,2893.70,2199212.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','78',2178,'22','2',2013645.28,2013645.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','78',2179,'23','2',2156950.04,2158435.97,1485.93,1129306.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','78',2180,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','78',2181,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','78',2182,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','78',2183,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','78',2184,'28','3',867935.57,869154.17,1218.60,792090.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2185,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2186,'2','1',4075962.07,4082144.49,6182.42,1020099.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2187,'3','1',1936959.27,1942353.86,5394.59,890107.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2188,'4','1',2299280.01,2304032.79,4752.78,784208.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2189,'5','1',2087796.45,2092848.15,5051.70,833530.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2190,'6','1',1821161.92,1826541.87,5379.95,887691.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2191,'7','1',1904452.05,1909404.70,4952.65,817187.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2192,'8','1',2578201.27,2583808.15,5606.88,925135.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2193,'9','1',2257972.34,2264417.42,6445.08,1063438.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','79',2194,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2195,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2196,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2197,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2198,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2199,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2200,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2201,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2202,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2203,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','79',2204,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','79',2205,'21','2',1644157.63,1646697.82,2540.19,1981348.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','79',2206,'22','2',2013645.28,2013645.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','79',2207,'23','2',2158435.97,2161170.78,2734.81,2133151.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','79',2208,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','79',2209,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','79',2210,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','79',2211,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','79',2212,'28','3',869154.17,871402.89,2248.72,1461668.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2213,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2214,'2','1',4082144.49,4088440.34,6295.85,1038815.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2215,'3','1',1942353.86,1947408.10,5054.24,833949.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2216,'4','1',2304032.79,2308779.41,4746.62,783192.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2217,'5','1',2092848.15,2097584.50,4736.35,781497.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2218,'6','1',1826541.87,1832027.17,5485.30,905074.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2219,'7','1',1909404.70,1914680.14,5275.44,870447.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2220,'8','1',2583808.15,2589802.83,5994.68,989122.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2221,'9','1',2264417.42,2270253.34,5835.92,962926.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','80',2222,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2223,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2224,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2225,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2226,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2227,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2228,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2229,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2230,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2231,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','80',2232,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','80',2233,'21','2',1646697.82,1649052.71,2354.89,1836814.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','80',2234,'22','2',2013645.28,2013645.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','80',2235,'23','2',2161170.78,2161231.01,60.23,46979.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','80',2236,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','80',2237,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','80',2238,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','80',2239,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','80',2240,'28','3',871402.89,872359.58,956.69,621848.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2241,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2242,'2','1',4088440.34,4091363.35,2923.01,482296.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2243,'3','1',1947408.10,1950087.57,2679.47,442112.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2244,'4','1',2308779.41,2311383.69,2604.28,429706.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2245,'5','1',2097584.50,2100036.14,2451.64,404520.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2246,'6','1',1832027.17,1834879.02,2851.85,470555.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2247,'7','1',1914680.14,1917102.00,2421.86,399606.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2248,'8','1',2589802.83,2593257.88,3455.05,570083.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2249,'9','1',2270253.34,2273458.32,3204.98,528821.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','81',2250,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2251,'11','1',3165410.91,3165410.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2252,'12','1',3602906.89,3602906.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2253,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2254,'14','1',3403536.10,3403536.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2255,'15','1',2759890.60,2759890.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2256,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2257,'17','1',2625337.13,2625337.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2258,'18','1',2586115.38,2586115.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2259,'19','1',2649673.63,2649673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','81',2260,'20','1',2637947.46,2637947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','81',2261,'21','2',1649052.71,1651614.80,2562.09,1998430.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','81',2262,'22','2',2013645.28,2013645.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','81',2263,'23','2',2161231.01,2165360.26,4129.25,3220815.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','81',2264,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','81',2265,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','81',2266,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','81',2267,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','81',2268,'28','3',872359.58,873663.35,1303.77,847450.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2269,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2270,'2','1',4091363.35,4101872.05,10508.70,1733935.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2271,'3','1',1950087.57,1958321.82,8234.25,1358651.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2272,'4','1',2311383.69,2318576.02,7192.33,1186734.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2273,'5','1',2100036.14,2106392.56,6356.42,1048809.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2274,'6','1',1834879.02,1842828.45,7949.43,1311655.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2275,'7','1',1917102.00,1925598.12,8496.12,1401859.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2276,'8','1',2593257.88,2601859.08,8601.20,1419198.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2277,'9','1',2273458.32,2282821.53,9363.21,1544929.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','82',2278,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2279,'11','1',3165410.91,3168043.39,2632.48,434359.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2280,'12','1',3602906.89,3604384.11,1477.22,243741.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2281,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2282,'14','1',3403536.10,3404886.74,1350.64,222856.26,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2283,'15','1',2759890.60,2761079.60,1189.00,196185.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2284,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2285,'17','1',2625337.13,2629733.63,4396.50,725422.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2286,'18','1',2586115.38,2586150.94,35.56,5867.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2287,'19','1',2649673.63,2653920.39,4246.76,700715.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','82',2288,'20','1',2637947.46,2639171.41,1223.95,201951.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','82',2289,'21','2',1651614.80,1654260.26,2645.46,2063458.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','82',2290,'22','2',2013645.28,2013645.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','82',2291,'23','2',2165360.26,2168442.77,3082.51,2404357.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','82',2292,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','82',2293,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','82',2294,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','82',2295,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','82',2296,'28','3',873663.35,876596.10,2932.75,1906287.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2297,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2298,'2','1',4101872.05,4105773.73,3901.68,643777.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2299,'3','1',1958321.82,1961135.43,2813.61,464245.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2300,'4','1',2318576.02,2321355.63,2779.61,458635.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2301,'5','1',2106392.56,2109059.72,2667.16,440081.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2302,'6','1',1842828.45,1845494.03,2665.58,439820.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2303,'7','1',1925598.12,1928710.00,3111.88,513460.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2304,'8','1',2601859.08,2605435.63,3576.55,590130.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2305,'9','1',2282821.53,2286635.66,3814.13,629331.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','83',2306,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2307,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2308,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2309,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2310,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2311,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2312,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2313,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2314,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2315,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','83',2316,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','83',2317,'21','2',1654260.26,1656644.60,2384.34,1859785.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','83',2318,'22','2',2013645.28,2013645.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','83',2319,'23','2',2168442.77,2171139.67,2696.90,2103582.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','83',2320,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','83',2321,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','83',2322,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','83',2323,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','83',2324,'28','3',876596.10,882638.73,6042.63,3927709.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2325,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2326,'2','1',4105773.73,4112477.22,6703.49,1106075.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2327,'3','1',1961135.43,1965767.16,4631.73,764235.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2328,'4','1',2321355.63,2326823.83,5468.20,902253.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2329,'5','1',2109059.72,2113898.39,4838.67,798380.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2330,'6','1',1845494.03,1850707.30,5213.27,860189.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2331,'7','1',1928710.00,1933928.59,5218.59,861067.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2332,'8','1',2605435.63,2611385.44,5949.81,981718.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2333,'9','1',2286635.66,2294199.02,7563.36,1247954.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','84',2334,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2335,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2336,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2337,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2338,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2339,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2340,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2341,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2342,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2343,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','84',2344,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','84',2345,'21','2',1656644.60,1658772.30,2127.70,1702160.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','84',2346,'22','2',2013645.28,2013645.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','84',2347,'23','2',2171139.67,2172845.91,1706.24,1364992.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','84',2348,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','84',2349,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','84',2350,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','84',2351,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','84',2352,'28','3',882638.73,883393.70,754.97,528479.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2353,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2354,'2','1',4112477.22,4119558.11,7080.89,1168346.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2355,'3','1',1965767.16,1970672.15,4904.99,809323.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2356,'4','1',2326823.83,2331525.25,4701.42,775734.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2357,'5','1',2113898.39,2118743.18,4844.79,799390.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2358,'6','1',1850707.30,1855983.87,5276.57,870634.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2359,'7','1',1933928.59,1939097.16,5168.57,852814.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2360,'8','1',2611385.44,2616936.97,5551.53,916002.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2361,'9','1',2294199.02,2302087.41,7888.39,1301584.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','85',2362,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2363,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2364,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2365,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2366,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2367,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2368,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2369,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2370,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2371,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','85',2372,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','85',2373,'21','2',1658772.30,1661375.29,2602.99,2082392.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','85',2374,'22','2',2013645.28,2013964.55,319.27,255416.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','85',2375,'23','2',2172845.91,2175830.03,2984.12,2387296.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','85',2376,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','85',2377,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','85',2378,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','85',2379,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','85',2380,'28','3',883393.70,884236.37,842.67,589869.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2381,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2382,'2','1',4119558.11,4128378.40,8820.29,1455347.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2383,'3','1',1970672.15,1976786.09,6113.94,1008800.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2384,'4','1',2331525.25,2337119.77,5594.52,923095.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2385,'5','1',2118743.18,2124230.41,5487.23,905392.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2386,'6','1',1855983.87,1862257.90,6274.03,1035214.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2387,'7','1',1939097.16,1946336.70,7239.54,1194524.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2388,'8','1',2616936.97,2623920.39,6983.42,1152264.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2389,'9','1',2302087.41,2312122.89,10035.48,1655854.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','86',2390,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2391,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2392,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2393,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2394,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2395,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2396,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2397,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2398,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2399,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','86',2400,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','86',2401,'21','2',1661375.29,1665639.25,4263.96,3496447.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','86',2402,'22','2',2013964.55,2014779.19,814.64,668004.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','86',2403,'23','2',2175830.03,2178802.86,2972.83,2437720.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','86',2404,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','86',2405,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','86',2406,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','86',2407,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','86',2408,'28','3',884236.37,886197.37,1961.00,1372700.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2409,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2410,'2','1',4128378.40,4134046.14,5667.74,935177.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2411,'3','1',1976786.09,1980302.06,3515.97,580135.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2412,'4','1',2337119.77,2341165.54,4045.77,667552.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2413,'5','1',2124230.41,2127652.04,3421.63,564568.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2414,'6','1',1862257.90,1865695.20,3437.30,567154.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2415,'7','1',1946336.70,1950460.40,4123.70,680410.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2416,'8','1',2623920.39,2627702.00,3781.61,623965.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2417,'9','1',2312122.89,2318776.48,6653.59,1097842.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','87',2418,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2419,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2420,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2421,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2422,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2423,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2424,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2425,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2426,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2427,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','87',2428,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','87',2429,'21','2',1665639.25,1666067.30,428.05,351001.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','87',2430,'22','2',2014779.19,2014779.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','87',2431,'23','2',2178802.86,2179946.61,1143.75,937875.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','87',2432,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','87',2433,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','87',2434,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','87',2435,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','87',2436,'28','3',886197.37,887533.88,1336.51,935557.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2437,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2438,'2','1',4134046.14,4140595.07,6548.93,1080573.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2439,'3','1',1980302.06,1984830.15,4528.09,747134.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2440,'4','1',2341165.54,2345095.58,3930.04,648456.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2441,'5','1',2127652.04,2130893.85,3241.81,534898.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2442,'6','1',1865695.20,1870076.05,4380.85,722840.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2443,'7','1',1950460.40,1954590.86,4130.46,681525.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2444,'8','1',2627702.00,2633108.82,5406.82,892125.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2445,'9','1',2318776.48,2326272.18,7495.70,1236790.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','88',2446,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2447,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2448,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2449,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2450,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2451,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2452,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2453,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2454,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2455,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','88',2456,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','88',2457,'21','2',1666067.30,1666541.69,474.39,388999.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','88',2458,'22','2',2014779.19,2016085.72,1306.53,1071354.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','88',2459,'23','2',2179946.61,2182020.68,2074.07,1700737.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','88',2460,'24','2',1119678.86,1119678.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','88',2461,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','88',2462,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','88',2463,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','88',2464,'28','3',887533.88,889512.19,1978.31,1483732.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2465,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2466,'2','1',4140595.07,4147368.75,6773.68,1117657.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2467,'3','1',1984830.15,1988866.98,4036.83,666076.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2468,'4','1',2345095.58,2350090.41,4994.83,824146.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2469,'5','1',2130893.85,2134988.71,4094.86,675651.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2470,'6','1',1870076.05,1875116.01,5039.96,831593.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2471,'7','1',1954590.86,1959661.44,5070.58,836645.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2472,'8','1',2633108.82,2638371.13,5262.31,868281.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2473,'9','1',2326272.18,2334286.46,8014.28,1322356.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','89',2474,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2475,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2476,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2477,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2478,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2479,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2480,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2481,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2482,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2483,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','89',2484,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','89',2485,'21','2',1666541.69,1669744.48,3202.79,2626287.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','89',2486,'22','2',2016085.72,2016675.46,589.74,483586.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','89',2487,'23','2',2182020.68,2185098.16,3077.48,2523533.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','89',2488,'24','2',1119678.86,1119683.86,5.00,4100.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','89',2489,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','89',2490,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','89',2491,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','89',2492,'28','3',889512.19,890639.98,1127.79,845842.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2493,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2494,'2','1',4147368.75,4153873.97,6505.22,1073361.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2495,'3','1',1988866.98,1993313.93,4446.95,733746.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2496,'4','1',2350090.41,2353248.74,3158.33,521124.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2497,'5','1',2134988.71,2139306.46,4317.75,712428.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2498,'6','1',1875116.01,1879349.94,4233.93,698598.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2499,'7','1',1959661.44,1964826.69,5165.25,852266.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2500,'8','1',2638371.13,2643706.66,5335.53,880362.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2501,'9','1',2334286.46,2341699.13,7412.67,1223090.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','90',2502,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2503,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2504,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2505,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2506,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2507,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2508,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2509,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2510,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2511,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','90',2512,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','90',2513,'21','2',1669744.48,1672150.57,2406.09,1972993.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','90',2514,'22','2',2016675.46,2016675.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','90',2515,'23','2',2185098.16,2188972.91,3874.75,3177295.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','90',2516,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','90',2517,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','90',2518,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','90',2519,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','90',2520,'28','3',890639.98,892057.09,1417.11,1062832.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2521,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2522,'2','1',4153873.97,4159431.43,5557.46,916980.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2523,'3','1',1993313.93,1996787.23,3473.30,573094.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2524,'4','1',2353248.74,2355911.12,2662.38,439292.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2525,'5','1',2139306.46,2142837.81,3531.35,582672.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2526,'6','1',1879349.94,1883526.37,4176.43,689110.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2527,'7','1',1964826.69,1969219.88,4393.19,724876.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2528,'8','1',2643706.66,2648742.42,5035.76,830900.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2529,'9','1',2341699.13,2348453.86,6754.73,1114530.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','91',2530,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2531,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2532,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2533,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2534,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2535,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2536,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2537,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2538,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2539,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','91',2540,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','91',2541,'21','2',1672150.57,1675586.26,3435.69,2817265.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','91',2542,'22','2',2016675.46,2016675.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','91',2543,'23','2',2188972.91,2191575.49,2602.58,2134115.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','91',2544,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','91',2545,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','91',2546,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','91',2547,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','91',2548,'28','3',892057.09,894004.64,1947.55,1460662.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2549,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2550,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2551,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2552,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2553,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2554,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2555,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2556,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2557,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','92',2558,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2559,'11','1',3168043.39,3168043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2560,'12','1',3604384.11,3604384.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2561,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2562,'14','1',3404886.74,3404886.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2563,'15','1',2761079.60,2761079.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2564,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2565,'17','1',2629733.63,2629733.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2566,'18','1',2586150.94,2586150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2567,'19','1',2653920.39,2653920.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','92',2568,'20','1',2639171.41,2639171.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','92',2569,'21','2',1675586.26,1675586.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','92',2570,'22','2',2016675.46,2016675.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','92',2571,'23','2',2191575.49,2191575.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','92',2572,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','92',2573,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','92',2574,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','92',2575,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','92',2576,'28','3',894004.64,894004.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2577,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2578,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2579,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2580,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2581,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2582,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2583,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2584,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2585,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','93',2586,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2587,'11','1',3168043.39,3174586.63,6543.24,1079634.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2588,'12','1',3604384.11,3612760.97,8376.86,1382181.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2589,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2590,'14','1',3404886.74,3413038.06,8151.32,1344967.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2591,'15','1',2761079.60,2769742.76,8663.16,1429421.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2592,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2593,'17','1',2629733.63,2635133.23,5399.60,890934.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2594,'18','1',2586150.94,2590834.97,4684.03,772864.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2595,'19','1',2653920.39,2661301.20,7380.81,1217833.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','93',2596,'20','1',2639171.41,2647377.25,8205.84,1353963.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','93',2597,'21','2',1675586.26,1678144.26,2558.00,2123140.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','93',2598,'22','2',2016675.46,2016675.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','93',2599,'23','2',2191575.49,2193898.49,2323.00,1928090.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','93',2600,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','93',2601,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','93',2602,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','93',2603,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','93',2604,'28','3',894004.64,895379.15,1374.51,1030882.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2605,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2606,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2607,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2608,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2609,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2610,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2611,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2612,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2613,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','94',2614,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2615,'11','1',3174586.63,3178209.68,3623.05,597803.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2616,'12','1',3612760.97,3618020.29,5259.32,867787.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2617,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2618,'14','1',3413038.06,3417886.86,4848.80,800052.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2619,'15','1',2769742.76,2774503.00,4760.24,785439.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2620,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2621,'17','1',2635133.23,2639885.15,4751.92,784066.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2622,'18','1',2590834.97,2592325.32,1490.35,245907.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2623,'19','1',2661301.20,2667218.16,5916.96,976298.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','94',2624,'20','1',2647377.25,2654036.54,6659.29,1098782.85,0.00,0.00,0.00,0.00,0.00),('21','228','3','94',2625,'21','2',1678144.26,1681768.12,3623.86,3007803.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','94',2626,'22','2',2016675.46,2016675.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','94',2627,'23','2',2193898.49,2195648.69,1750.20,1452666.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','94',2628,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','94',2629,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','94',2630,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','94',2631,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','94',2632,'28','3',895379.15,896569.31,1190.16,892620.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2633,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2634,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2635,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2636,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2637,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2638,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2639,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2640,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2641,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','95',2642,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2643,'11','1',3178209.68,3183383.28,5173.60,853644.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2644,'12','1',3618020.29,3625739.66,7719.37,1273696.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2645,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2646,'14','1',3417886.86,3424560.89,6674.03,1101214.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2647,'15','1',2774503.00,2781972.39,7469.39,1232449.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2648,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2649,'17','1',2639885.15,2645751.53,5866.38,967952.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2650,'18','1',2592325.32,2598474.96,6149.64,1014690.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2651,'19','1',2667218.16,2675529.87,8311.71,1371432.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','95',2652,'20','1',2654036.54,2662490.12,8453.58,1394840.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','95',2653,'21','2',1681768.12,1683294.74,1526.62,1267094.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','95',2654,'22','2',2016675.46,2016675.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','95',2655,'23','2',2195648.69,2196397.66,748.97,621645.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','95',2656,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','95',2657,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','95',2658,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','95',2659,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','95',2660,'28','3',896569.31,897615.31,1046.00,784500.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2661,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2662,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2663,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2664,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2665,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2666,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2667,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2668,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2669,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','96',2670,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2671,'11','1',3183383.28,3185949.30,2566.02,423393.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2672,'12','1',3625739.66,3629292.86,3553.20,586278.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2673,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2674,'14','1',3424560.89,3427573.06,3012.17,497008.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2675,'15','1',2781972.39,2785780.53,3808.14,628343.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2676,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2677,'17','1',2645751.53,2648797.83,3046.30,502639.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2678,'18','1',2598474.96,2599368.83,893.87,147488.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2679,'19','1',2675529.87,2678887.97,3358.10,554086.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','96',2680,'20','1',2662490.12,2665470.62,2980.50,491782.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','96',2681,'21','2',1683294.74,1686523.59,3228.85,2679945.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','96',2682,'22','2',2016675.46,2017042.70,367.24,304809.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','96',2683,'23','2',2196397.66,2199753.91,3356.25,2785687.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','96',2684,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','96',2685,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','96',2686,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','96',2687,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','96',2688,'28','3',897615.31,898674.62,1059.31,794482.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2689,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2690,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2691,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2692,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2693,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2694,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2695,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2696,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2697,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','97',2698,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2699,'11','1',3185949.30,3188306.66,2357.36,388964.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2700,'12','1',3629292.86,3633004.76,3711.90,612463.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2701,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2702,'14','1',3427573.06,3429599.70,2026.64,334395.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2703,'15','1',2785780.53,2789423.78,3643.25,601136.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2704,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2705,'17','1',2648797.83,2651493.04,2695.21,444709.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2706,'18','1',2599368.83,2602569.96,3201.13,528186.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2707,'19','1',2678887.97,2682644.11,3756.14,619763.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','97',2708,'20','1',2665470.62,2669677.09,4206.47,694067.55,0.00,0.00,0.00,0.00,0.00),('21','228','3','97',2709,'21','2',1686523.59,1688641.25,2117.66,1757657.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','97',2710,'22','2',2017042.70,2017067.82,25.12,20849.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','97',2711,'23','2',2199753.91,2202490.25,2736.34,2271162.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','97',2712,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','97',2713,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','97',2714,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','97',2715,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','97',2716,'28','3',898674.62,900261.45,1586.83,1190122.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2717,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2718,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2719,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2720,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2721,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2722,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2723,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2724,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2725,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','98',2726,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2727,'11','1',3188306.66,3189266.86,960.20,158433.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2728,'12','1',3633004.76,3634268.04,1263.28,208441.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2729,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2730,'14','1',3429599.70,3430879.60,1279.90,211183.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2731,'15','1',2789423.78,2790844.12,1420.34,234356.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2732,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2733,'17','1',2651493.04,2652356.47,863.43,142465.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2734,'18','1',2602569.96,2603837.40,1267.44,209127.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2735,'19','1',2682644.11,2683506.66,862.55,142320.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','98',2736,'20','1',2669677.09,2670907.47,1230.38,203012.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','98',2737,'21','2',1688641.25,1689914.56,1273.31,1056847.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','98',2738,'22','2',2017067.82,2017067.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','98',2739,'23','2',2202490.25,2205343.03,2852.78,2367807.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','98',2740,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','98',2741,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','98',2742,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','98',2743,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','98',2744,'28','3',900261.45,901534.04,1272.59,954442.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2745,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2746,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2747,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2748,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2749,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2750,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2751,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2752,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2753,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','99',2754,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2755,'11','1',3189266.86,3194168.18,4901.32,808717.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2756,'12','1',3634268.04,3642063.66,7795.62,1286277.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2757,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2758,'14','1',3430879.60,3436629.56,5749.96,948743.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2759,'15','1',2790844.12,2797609.98,6765.86,1116366.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2760,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2761,'17','1',2652356.47,2657357.62,5001.15,825189.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2762,'18','1',2603837.40,2609410.73,5573.33,919599.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2763,'19','1',2683506.66,2690257.34,6750.68,1113862.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','99',2764,'20','1',2670907.47,2678468.86,7561.39,1247629.35,0.00,0.00,0.00,0.00,0.00),('21','228','3','99',2765,'21','2',1689914.56,1693078.55,3163.99,2626111.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','99',2766,'22','2',2017067.82,2017397.99,330.17,274041.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','99',2767,'23','2',2205343.03,2208079.51,2736.48,2271278.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','99',2768,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','99',2769,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','99',2770,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','99',2771,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','99',2772,'28','3',901534.04,902735.06,1201.02,900765.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2773,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2774,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2775,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2776,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2777,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2778,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2779,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2780,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2781,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','100',2782,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2783,'11','1',3194168.18,3197028.22,2860.04,471906.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2784,'12','1',3642063.66,3645441.83,3378.17,557398.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2785,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2786,'14','1',3436629.56,3438317.42,1687.86,278496.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2787,'15','1',2797609.98,2801016.53,3406.55,562080.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2788,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2789,'17','1',2657357.62,2657357.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2790,'18','1',2609410.73,2612516.68,3105.95,512481.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2791,'19','1',2690257.34,2693268.93,3011.59,496912.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','100',2792,'20','1',2678468.86,2681864.94,3396.08,560353.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','100',2793,'21','2',1693078.55,1695738.82,2660.27,2208024.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','100',2794,'22','2',2017397.99,2017432.93,34.94,29000.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','100',2795,'23','2',2208079.51,2209290.99,1211.48,1005528.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','100',2796,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','100',2797,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','100',2798,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','100',2799,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','100',2800,'28','3',902735.06,903541.94,806.88,605160.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2801,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2802,'2','1',4159431.43,4159431.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2803,'3','1',1996787.23,1996787.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2804,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2805,'5','1',2142837.81,2142837.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2806,'6','1',1883526.37,1883526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2807,'7','1',1969219.88,1969219.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2808,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2809,'9','1',2348453.86,2348453.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','101',2810,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2811,'11','1',3197028.22,3200367.18,3338.96,550928.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2812,'12','1',3645441.83,3648665.65,3223.82,531930.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2813,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2814,'14','1',3438317.42,3441350.57,3033.15,500469.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2815,'15','1',2801016.53,2804682.35,3665.82,604860.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2816,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2817,'17','1',2657357.62,2659861.30,2503.68,413107.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2818,'18','1',2612516.68,2614891.07,2374.39,391774.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2819,'19','1',2693268.93,2696651.80,3382.87,558173.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','101',2820,'20','1',2681864.94,2685777.67,3912.73,645600.45,0.00,0.00,0.00,0.00,0.00),('21','228','3','101',2821,'21','2',1695738.82,1697787.94,2049.12,1700769.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','101',2822,'22','2',2017432.93,2017443.13,10.20,8466.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','101',2823,'23','2',2209290.99,2212998.20,3707.21,3076984.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','101',2824,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','101',2825,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','101',2826,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','101',2827,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','101',2828,'28','3',903541.94,904599.29,1057.35,793012.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2829,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2830,'2','1',4159431.43,4160796.96,1365.53,225312.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2831,'3','1',1996787.23,1997568.98,781.75,128988.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2832,'4','1',2355911.12,2355911.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2833,'5','1',2142837.81,2143296.70,458.89,75716.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2834,'6','1',1883526.37,1883861.93,335.56,55367.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2835,'7','1',1969219.88,1969728.00,508.12,83839.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2836,'8','1',2648742.42,2648742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2837,'9','1',2348453.86,2348753.69,299.83,49471.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','102',2838,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2839,'11','1',3200367.18,3201865.94,1498.76,247295.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2840,'12','1',3648665.65,3651350.01,2684.36,442919.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2841,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2842,'14','1',3441350.57,3443703.80,2353.23,388282.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2843,'15','1',2804682.35,2807623.90,2941.55,485355.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2844,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2845,'17','1',2659861.30,2661949.72,2088.42,344589.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2846,'18','1',2614891.07,2617246.04,2354.97,388570.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2847,'19','1',2696651.80,2698864.51,2212.71,365097.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','102',2848,'20','1',2685777.67,2688675.71,2898.04,478176.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','102',2849,'21','2',1697787.94,1698072.39,284.45,236093.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','102',2850,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','102',2851,'23','2',2212998.20,2214113.44,1115.24,925649.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','102',2852,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','102',2853,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','102',2854,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','102',2855,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','102',2856,'28','3',904599.29,905657.65,1058.36,793770.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2857,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2858,'2','1',4160796.96,4163771.44,2974.48,490789.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2859,'3','1',1997568.98,1999521.61,1952.63,322183.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2860,'4','1',2355911.12,2355969.80,58.68,9682.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2861,'5','1',2143296.70,2144742.78,1446.08,238603.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2862,'6','1',1883861.93,1885352.36,1490.43,245920.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2863,'7','1',1969728.00,1971972.00,2244.00,370260.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2864,'8','1',2648742.42,2649090.04,347.62,57357.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2865,'9','1',2348753.69,2351044.33,2290.64,377955.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','103',2866,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2867,'11','1',3201865.94,3204285.81,2419.87,399278.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2868,'12','1',3651350.01,3655139.89,3789.88,625330.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2869,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2870,'14','1',3443703.80,3447445.30,3741.50,617347.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2871,'15','1',2807623.90,2812159.74,4535.84,748413.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2872,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2873,'17','1',2661949.72,2664180.43,2230.71,368067.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2874,'18','1',2617246.04,2620946.77,3700.73,610620.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2875,'19','1',2698864.51,2702919.43,4054.92,669061.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','103',2876,'20','1',2688675.71,2693034.88,4359.17,719263.05,0.00,0.00,0.00,0.00,0.00),('21','228','3','103',2877,'21','2',1698072.39,1700732.83,2660.44,2208165.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','103',2878,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','103',2879,'23','2',2214113.44,2217682.14,3568.70,2962021.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','103',2880,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','103',2881,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','103',2882,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','103',2883,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','103',2884,'28','3',905657.65,906563.90,906.25,679687.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2885,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2886,'2','1',4163771.44,4163771.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2887,'3','1',1999521.61,1999521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2888,'4','1',2355969.80,2355969.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2889,'5','1',2144742.78,2144742.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2890,'6','1',1885352.36,1885352.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2891,'7','1',1971972.00,1971972.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2892,'8','1',2649090.04,2649090.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2893,'9','1',2351044.33,2351044.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','104',2894,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2895,'11','1',3204285.81,3204918.99,633.18,104474.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2896,'12','1',3655139.89,3656088.66,948.77,156547.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2897,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2898,'14','1',3447445.30,3448159.19,713.89,117791.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2899,'15','1',2812159.74,2813064.43,904.69,149273.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2900,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2901,'17','1',2664180.43,2664841.53,661.10,109081.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2902,'18','1',2620946.77,2621854.53,907.76,149780.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2903,'19','1',2702919.43,2703602.09,682.66,112638.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','104',2904,'20','1',2693034.88,2694034.96,1000.08,165013.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','104',2905,'21','2',1700732.83,1702553.85,1821.02,1511446.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','104',2906,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','104',2907,'23','2',2217682.14,2220764.78,3082.64,2558591.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','104',2908,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','104',2909,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','104',2910,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','104',2911,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','104',2912,'28','3',906563.90,907773.40,1209.50,907125.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2913,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2914,'2','1',4163771.44,4163771.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2915,'3','1',1999521.61,1999521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2916,'4','1',2355969.80,2355969.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2917,'5','1',2144742.78,2144742.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2918,'6','1',1885352.36,1885352.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2919,'7','1',1971972.00,1971972.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2920,'8','1',2649090.04,2649090.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2921,'9','1',2351044.33,2351044.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','105',2922,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2923,'11','1',3204918.99,3209903.01,4984.02,822363.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2924,'12','1',3656088.66,3662443.30,6354.64,1048515.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2925,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2926,'14','1',3448159.19,3454995.89,6836.70,1128055.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2927,'15','1',2813064.43,2819939.33,6874.90,1134358.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2928,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2929,'17','1',2664841.53,2667069.48,2227.95,367611.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2930,'18','1',2621854.53,2627763.54,5909.01,974986.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2931,'19','1',2703602.09,2710127.60,6525.51,1076709.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','105',2932,'20','1',2694034.96,2700711.46,6676.50,1101622.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','105',2933,'21','2',1702553.85,1702932.03,378.18,313889.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','105',2934,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','105',2935,'23','2',2220764.78,2224148.43,3383.65,2808429.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','105',2936,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','105',2937,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','105',2938,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','105',2939,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','105',2940,'28','3',907773.40,908915.73,1142.33,856747.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2941,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2942,'2','1',4163771.44,4165075.57,1304.13,215181.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2943,'3','1',1999521.61,2000625.05,1103.44,182067.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2944,'4','1',2355969.80,2355969.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2945,'5','1',2144742.78,2145733.56,990.78,163478.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2946,'6','1',1885352.36,1885352.42,0.06,9.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2947,'7','1',1971972.00,1972820.76,848.76,140045.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2948,'8','1',2649090.04,2649090.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2949,'9','1',2351044.33,2351044.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','106',2950,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2951,'11','1',3209903.01,3214422.96,4519.95,745791.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2952,'12','1',3662443.30,3667453.22,5009.92,826636.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2953,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2954,'14','1',3454995.89,3460884.27,5888.38,971582.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2955,'15','1',2819939.33,2825380.66,5441.33,897819.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2956,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2957,'17','1',2667069.48,2672166.86,5097.38,841067.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2958,'18','1',2627763.54,2632056.42,4292.88,708325.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2959,'19','1',2710127.60,2715712.53,5584.93,921513.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','106',2960,'20','1',2700711.46,2706686.30,5974.84,985848.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','106',2961,'21','2',1702932.03,1705673.08,2741.05,2275071.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','106',2962,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','106',2963,'23','2',2224148.43,2226728.46,2580.03,2141424.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','106',2964,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','106',2965,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','106',2966,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','106',2967,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','106',2968,'28','3',908915.73,909835.44,919.71,689782.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2969,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2970,'2','1',4165075.57,4170392.52,5316.95,877296.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2971,'3','1',2000625.05,2004471.72,3846.67,634700.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2972,'4','1',2355969.80,2356926.33,956.53,157827.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2973,'5','1',2145733.56,2145903.78,170.22,28086.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2974,'6','1',1885352.42,1889309.07,3956.65,652847.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2975,'7','1',1972820.76,1976046.01,3225.25,532166.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2976,'8','1',2649090.04,2650889.84,1799.80,296967.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2977,'9','1',2351044.33,2351044.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','107',2978,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2979,'11','1',3214422.96,3217455.40,3032.44,500352.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2980,'12','1',3667453.22,3671926.63,4473.41,738112.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2981,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2982,'14','1',3460884.27,3465734.75,4850.48,800329.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2983,'15','1',2825380.66,2829937.33,4556.67,751850.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2984,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2985,'17','1',2672166.86,2675900.49,3733.63,616048.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2986,'18','1',2632056.42,2636489.43,4433.01,731446.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2987,'19','1',2715712.53,2721250.53,5538.00,913770.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','107',2988,'20','1',2706686.30,2711916.51,5230.21,862984.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','107',2989,'21','2',1705673.08,1707694.98,2021.90,1678177.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','107',2990,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','107',2991,'23','2',2226728.46,2228395.27,1666.81,1383452.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','107',2992,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','107',2993,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','107',2994,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','107',2995,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','107',2996,'28','3',909835.44,911546.61,1711.17,1283377.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',2997,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',2998,'2','1',4170392.52,4174476.14,4083.62,673797.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',2999,'3','1',2004471.72,2007624.18,3152.46,520155.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',3000,'4','1',2356926.33,2357287.42,361.09,59579.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',3001,'5','1',2145903.78,2149090.42,3186.64,525795.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',3002,'6','1',1889309.07,1889309.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',3003,'7','1',1976046.01,1978262.52,2216.51,365724.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',3004,'8','1',2650889.84,2652304.40,1414.56,233402.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',3005,'9','1',2351044.33,2351044.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','108',3006,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3007,'11','1',3217455.40,3219515.87,2060.47,339977.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3008,'12','1',3671926.63,3675095.28,3168.65,522827.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3009,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3010,'14','1',3465734.75,3469457.63,3722.88,614275.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3011,'15','1',2829937.33,2833516.48,3579.15,590559.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3012,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3013,'17','1',2675900.49,2678386.77,2486.28,410236.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3014,'18','1',2636489.43,2639896.24,3406.81,562123.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3015,'19','1',2721250.53,2725391.37,4140.84,683238.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','108',3016,'20','1',2711916.51,2714984.85,3068.34,506276.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','108',3017,'21','2',1707694.98,1710629.30,2934.32,2435485.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','108',3018,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','108',3019,'23','2',2228395.27,2229378.60,983.33,816163.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','108',3020,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','108',3021,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','108',3022,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','108',3023,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','108',3024,'28','3',911546.61,913084.92,1538.31,1153732.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3025,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3026,'2','1',4174476.14,4176522.28,2046.14,337613.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3027,'3','1',2007624.18,2008967.76,1343.58,221690.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3028,'4','1',2357287.42,2357854.01,566.59,93487.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3029,'5','1',2149090.42,2150396.21,1305.79,215455.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3030,'6','1',1889309.07,1889911.08,602.01,99331.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3031,'7','1',1978262.52,1980027.21,1764.69,291173.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3032,'8','1',2652304.40,2653259.69,955.29,157622.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3033,'9','1',2351044.33,2351044.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','109',3034,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3035,'11','1',3219515.87,3220528.00,1012.13,167001.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3036,'12','1',3675095.28,3675484.03,388.75,64143.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3037,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3038,'14','1',3469457.63,3470335.53,877.90,144853.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3039,'15','1',2833516.48,2834475.80,959.32,158287.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3040,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3041,'17','1',2678386.77,2679151.94,765.17,126253.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3042,'18','1',2639896.24,2640627.66,731.42,120684.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3043,'19','1',2725391.37,2726483.11,1091.74,180137.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','109',3044,'20','1',2714984.85,2716073.09,1088.24,179559.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','109',3045,'21','2',1710629.30,1711527.73,898.43,745696.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','109',3046,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','109',3047,'23','2',2229378.60,2230208.30,829.70,688651.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','109',3048,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','109',3049,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','109',3050,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','109',3051,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','109',3052,'28','3',913084.92,914071.11,986.19,739642.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3053,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3054,'2','1',4176522.28,4178960.89,2438.61,402370.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3055,'3','1',2008967.76,2011218.10,2250.34,371306.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3056,'4','1',2357854.01,2357854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3057,'5','1',2150396.21,2152911.09,2514.88,414955.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3058,'6','1',1889911.08,1889911.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3059,'7','1',1980027.21,1980027.27,0.06,9.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3060,'8','1',2653259.69,2655648.36,2388.67,394130.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3061,'9','1',2351044.33,2352079.83,1035.50,170857.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','110',3062,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3063,'11','1',3220528.00,3222432.58,1904.58,314255.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3064,'12','1',3675484.03,3678021.81,2537.78,418733.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3065,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3066,'14','1',3470335.53,3473207.62,2872.09,473894.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3067,'15','1',2834475.80,2837203.83,2728.03,450124.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3068,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3069,'17','1',2679151.94,2681605.57,2453.63,404848.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3070,'18','1',2640627.66,2642347.72,1720.06,283809.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3071,'19','1',2726483.11,2729729.04,3245.93,535578.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','110',3072,'20','1',2716073.09,2719368.79,3295.70,543790.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','110',3073,'21','2',1711527.73,1716543.88,5016.15,4163404.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','110',3074,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','110',3075,'23','2',2230208.30,2233044.70,2836.40,2354212.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','110',3076,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','110',3077,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','110',3078,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','110',3079,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','110',3080,'28','3',914071.11,915355.56,1284.45,963337.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3081,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3082,'2','1',4178960.89,4181619.91,2659.02,438738.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3083,'3','1',2011218.10,2013815.01,2596.91,428490.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3084,'4','1',2357854.01,2357854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3085,'5','1',2152911.09,2154813.40,1902.31,313881.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3086,'6','1',1889911.08,1889911.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3087,'7','1',1980027.27,1981615.00,1587.73,261975.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3088,'8','1',2655648.36,2655943.45,295.09,48689.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3089,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','111',3090,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3091,'11','1',3222432.58,3224399.95,1967.37,324616.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3092,'12','1',3678021.81,3680421.28,2399.47,395912.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3093,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3094,'14','1',3473207.62,3476039.26,2831.64,467220.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3095,'15','1',2837203.83,2839378.50,2174.67,358820.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3096,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3097,'17','1',2681605.57,2683669.18,2063.61,340495.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3098,'18','1',2642347.72,2644973.08,2625.36,433184.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3099,'19','1',2729729.04,2732358.57,2629.53,433872.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','111',3100,'20','1',2719368.79,2722503.39,3134.60,517209.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','111',3101,'21','2',1716543.88,1718651.84,2107.96,1749606.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','111',3102,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','111',3103,'23','2',2233044.70,2234841.12,1796.42,1491028.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','111',3104,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','111',3105,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','111',3106,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','111',3107,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','111',3108,'28','3',915355.56,918236.65,2881.09,2160817.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3109,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3110,'2','1',4181619.91,4185287.78,3667.87,605198.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3111,'3','1',2013815.01,2017349.76,3534.75,583233.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3112,'4','1',2357854.01,2357854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3113,'5','1',2154813.40,2157710.44,2897.04,478011.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3114,'6','1',1889911.08,1891031.49,1120.41,184867.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3115,'7','1',1981615.00,1982905.36,1290.36,212909.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3116,'8','1',2655943.45,2659386.55,3443.10,568111.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3117,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','112',3118,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3119,'11','1',3224399.95,3226501.09,2101.14,346688.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3120,'12','1',3680421.28,3682976.63,2555.35,421632.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3121,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3122,'14','1',3476039.26,3478733.13,2693.87,444488.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3123,'15','1',2839378.50,2842108.72,2730.22,450486.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3124,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3125,'17','1',2683669.18,2685764.10,2094.92,345661.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3126,'18','1',2644973.08,2647577.07,2603.99,429658.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3127,'19','1',2732358.57,2735481.44,3122.87,515273.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','112',3128,'20','1',2722503.39,2725602.47,3099.08,511348.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','112',3129,'21','2',1718651.84,1720356.16,1704.32,1414585.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','112',3130,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','112',3131,'23','2',2234841.12,2236355.09,1513.97,1256595.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','112',3132,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','112',3133,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','112',3134,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','112',3135,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','112',3136,'28','3',918236.65,920595.22,2358.57,1768927.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3137,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3138,'2','1',4185287.78,4189634.19,4346.41,717157.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3139,'3','1',2017349.76,2021444.96,4095.20,675708.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3140,'4','1',2357854.01,2358727.71,873.70,144160.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3141,'5','1',2157710.44,2161726.43,4015.99,662638.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3142,'6','1',1891031.49,1891997.69,966.20,159423.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3143,'7','1',1982905.36,1984330.60,1425.24,235164.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3144,'8','1',2659386.55,2662880.06,3493.51,576429.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3145,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','113',3146,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3147,'11','1',3226501.09,3230103.88,3602.79,594460.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3148,'12','1',3682976.63,3687833.06,4856.43,801310.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3149,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3150,'14','1',3478733.13,3484403.81,5670.68,935662.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3151,'15','1',2842108.72,2847193.41,5084.69,838973.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3152,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3153,'17','1',2685764.10,2689861.84,4097.74,676127.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3154,'18','1',2647577.07,2652623.91,5046.84,832728.60,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3155,'19','1',2735481.44,2740768.69,5287.25,872396.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','113',3156,'20','1',2725602.47,2731855.38,6252.91,1031730.15,0.00,0.00,0.00,0.00,0.00),('21','228','3','113',3157,'21','2',1720356.16,1722724.30,2368.14,1965556.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','113',3158,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','113',3159,'23','2',2236355.09,2237646.94,1291.85,1072235.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','113',3160,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','113',3161,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','113',3162,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','113',3163,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','113',3164,'28','3',920595.22,921733.31,1138.09,853567.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3165,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3166,'2','1',4189634.19,4191042.98,1408.79,232450.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3167,'3','1',2021444.96,2022641.91,1196.95,197496.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3168,'4','1',2358727.71,2358727.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3169,'5','1',2161726.43,2161726.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3170,'6','1',1891997.69,1893082.56,1084.87,179003.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3171,'7','1',1984330.60,1984330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3172,'8','1',2662880.06,2664219.81,1339.75,221058.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3173,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','114',3174,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3175,'11','1',3230103.88,3230809.00,705.12,116344.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3176,'12','1',3687833.06,3688442.09,609.03,100489.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3177,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3178,'14','1',3484403.81,3485854.84,1451.03,239419.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3179,'15','1',2847193.41,2848471.87,1278.46,210945.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3180,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3181,'17','1',2689861.84,2690663.33,801.49,132245.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3182,'18','1',2652623.91,2653730.57,1106.66,182598.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3183,'19','1',2740768.69,2742030.86,1262.17,208258.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','114',3184,'20','1',2731855.38,2732985.73,1130.35,186507.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','114',3185,'21','2',1722724.30,1723375.65,651.35,540620.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','114',3186,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','114',3187,'23','2',2237646.94,2239657.22,2010.28,1668532.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','114',3188,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','114',3189,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','114',3190,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','114',3191,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','114',3192,'28','3',921733.31,924164.83,2431.52,1823640.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3193,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3194,'2','1',4191042.98,4191042.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3195,'3','1',2022641.91,2022641.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3196,'4','1',2358727.71,2358727.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3197,'5','1',2161726.43,2161726.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3198,'6','1',1893082.56,1893082.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3199,'7','1',1984330.60,1984330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3200,'8','1',2664219.81,2664219.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3201,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','115',3202,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3203,'11','1',3230809.00,3230809.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3204,'12','1',3688442.09,3688442.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3205,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3206,'14','1',3485854.84,3485854.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3207,'15','1',2848471.87,2848471.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3208,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3209,'17','1',2690663.33,2690663.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3210,'18','1',2653730.57,2653730.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3211,'19','1',2742030.86,2742030.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','115',3212,'20','1',2732985.73,2732985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','115',3213,'21','2',1723375.65,1724431.81,1056.16,876612.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','115',3214,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','115',3215,'23','2',2239657.22,2239657.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','115',3216,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','115',3217,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','115',3218,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','115',3219,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','115',3220,'28','3',924164.83,927017.13,2852.30,2139225.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3221,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3222,'2','1',4191042.98,4191042.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3223,'3','1',2022641.91,2022641.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3224,'4','1',2358727.71,2358727.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3225,'5','1',2161726.43,2161726.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3226,'6','1',1893082.56,1893082.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3227,'7','1',1984330.60,1984330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3228,'8','1',2664219.81,2664219.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3229,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','116',3230,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3231,'11','1',3230809.00,3230809.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3232,'12','1',3688442.09,3688442.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3233,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3234,'14','1',3485854.84,3485854.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3235,'15','1',2848471.87,2848471.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3236,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3237,'17','1',2690663.33,2690663.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3238,'18','1',2653730.57,2653730.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3239,'19','1',2742030.86,2742030.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','116',3240,'20','1',2732985.73,2732985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','116',3241,'21','2',1724431.81,1725165.01,733.20,608556.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','116',3242,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','116',3243,'23','2',2239657.22,2239657.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','116',3244,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','116',3245,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','116',3246,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','116',3247,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','116',3248,'28','3',927017.13,928105.09,1087.96,815970.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3249,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3250,'2','1',4191042.98,4197444.59,6401.61,1056265.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3251,'3','1',2022641.91,2027969.14,5327.23,878992.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3252,'4','1',2358727.71,2359533.78,806.07,133001.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3253,'5','1',2161726.43,2166597.26,4870.83,803686.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3254,'6','1',1893082.56,1893599.86,517.30,85354.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3255,'7','1',1984330.60,1989823.91,5493.31,906396.15,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3256,'8','1',2664219.81,2665042.69,822.88,135775.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3257,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','117',3258,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3259,'11','1',3230809.00,3234773.71,3964.71,654177.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3260,'12','1',3688442.09,3693389.79,4947.70,816370.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3261,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3262,'14','1',3485854.84,3491394.56,5539.72,914053.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3263,'15','1',2848471.87,2854211.23,5739.36,946994.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3264,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3265,'17','1',2690663.33,2693670.96,3007.63,496258.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3266,'18','1',2653730.57,2659260.43,5529.86,912426.90,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3267,'19','1',2742030.86,2747277.77,5246.91,865740.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','117',3268,'20','1',2732985.73,2739038.77,6053.04,998751.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','117',3269,'21','2',1725165.01,1728013.29,2848.28,2364072.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','117',3270,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','117',3271,'23','2',2239657.22,2239657.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','117',3272,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','117',3273,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','117',3274,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','117',3275,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','117',3276,'28','3',928105.09,929932.59,1827.50,1370625.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3277,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3278,'2','1',4197444.59,4206312.94,8868.35,1463277.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3279,'3','1',2027969.14,2034235.73,6266.59,1033987.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3280,'4','1',2359533.78,2364408.26,4874.48,804289.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3281,'5','1',2166597.26,2173025.94,6428.68,1060732.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3282,'6','1',1893599.86,1899902.85,6302.99,1039993.35,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3283,'7','1',1989823.91,1992460.52,2636.61,435040.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3284,'8','1',2665042.69,2673249.66,8206.97,1354150.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3285,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','118',3286,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3287,'11','1',3234773.71,3236170.03,1396.32,230392.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3288,'12','1',3693389.79,3694531.41,1141.62,188367.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3289,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3290,'14','1',3491394.56,3493311.50,1916.94,316295.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3291,'15','1',2854211.23,2855670.05,1458.82,240705.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3292,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3293,'17','1',2693670.96,2694488.35,817.39,134869.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3294,'18','1',2659260.43,2660440.78,1180.35,194757.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3295,'19','1',2747277.77,2749017.57,1739.80,287067.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','118',3296,'20','1',2739038.77,2740478.73,1439.96,237593.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','118',3297,'21','2',1728013.29,1730204.35,2191.06,1818579.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','118',3298,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','118',3299,'23','2',2239657.22,2240555.18,897.96,745306.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','118',3300,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','118',3301,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','118',3302,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','118',3303,'27','3',461965.43,461965.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','118',3304,'28','3',929932.59,930988.03,1055.44,791580.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3305,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3306,'2','1',4206312.94,4213664.56,7351.62,1213017.30,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3307,'3','1',2034235.73,2039542.11,5306.38,875552.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3308,'4','1',2364408.26,2368592.92,4184.66,690468.90,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3309,'5','1',2173025.94,2178430.77,5404.83,891796.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3310,'6','1',1899902.85,1904262.92,4360.07,719411.55,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3311,'7','1',1992460.52,1992460.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3312,'8','1',2673249.66,2679252.16,6002.50,990412.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3313,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','119',3314,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3315,'11','1',3236170.03,3238489.16,2319.13,382656.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3316,'12','1',3694531.41,3699135.97,4604.56,759752.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3317,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3318,'14','1',3493311.50,3498090.84,4779.34,788591.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3319,'15','1',2855670.05,2860096.52,4426.47,730367.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3320,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3321,'17','1',2694488.35,2699274.13,4785.78,789653.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3322,'18','1',2660440.78,2663012.53,2571.75,424338.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3323,'19','1',2749017.57,2752474.79,3457.22,570441.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','119',3324,'20','1',2740478.73,2744244.18,3765.45,621299.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','119',3325,'21','2',1730204.35,1732458.45,2254.10,1870903.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','119',3326,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','119',3327,'23','2',2240555.18,2241607.24,1052.06,873209.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','119',3328,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','119',3329,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','119',3330,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','119',3331,'27','3',461965.43,461965.68,0.25,187.50,0.00,0.00,0.00,0.00,0.00),('21','228','4','119',3332,'28','3',930988.03,932570.94,1582.91,1187182.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3333,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3334,'2','1',4213664.56,4215485.16,1820.60,336811.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3335,'3','1',2039542.11,2040714.51,1172.40,216894.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3336,'4','1',2368592.92,2369881.45,1288.53,238378.05,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3337,'5','1',2178430.77,2179960.82,1530.05,283059.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3338,'6','1',1904262.92,1904565.99,303.07,56067.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3339,'7','1',1992460.52,1992460.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3340,'8','1',2679252.16,2682091.53,2839.37,525283.45,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3341,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','120',3342,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3343,'11','1',3238489.16,3243045.05,4555.89,842839.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3344,'12','1',3699135.97,3702697.54,3561.57,658890.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3345,'13','1',2083090.21,2083090.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3346,'14','1',3498090.84,3501481.09,3390.25,627196.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3347,'15','1',2860096.52,2863283.99,3187.47,589681.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3348,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3349,'17','1',2699274.13,2702452.63,3178.50,588022.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3350,'18','1',2663012.53,2665245.50,2232.97,413099.45,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3351,'19','1',2752474.79,2755598.03,3123.24,577799.40,0.00,0.00,0.00,0.00,0.00),('21','228','2','120',3352,'20','1',2744244.18,2747823.19,3579.01,662116.85,0.00,0.00,0.00,0.00,0.00),('21','228','3','120',3353,'21','2',1732458.45,1734247.51,1789.06,1484919.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','120',3354,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','120',3355,'23','2',2241607.24,2243848.00,2240.76,1859830.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','120',3356,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','120',3357,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','120',3358,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','120',3359,'27','3',461965.68,461965.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','120',3360,'28','3',932570.94,933306.39,735.45,551587.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3361,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3362,'2','1',4215485.16,4219502.25,4017.09,743161.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3363,'3','1',2040714.51,2042756.26,2041.75,377723.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3364,'4','1',2369881.45,2371639.91,1758.46,325315.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3365,'5','1',2179960.82,2181002.08,1041.26,192633.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3366,'6','1',1904565.99,1906686.05,2120.06,392211.10,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3367,'7','1',1992460.52,1992460.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3368,'8','1',2682091.53,2684575.02,2483.49,459445.65,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3369,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','121',3370,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3371,'11','1',3243045.05,3246412.52,3367.47,622981.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3372,'12','1',3702697.54,3705758.72,3061.18,566318.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3373,'13','1',2083090.21,2083802.74,712.53,131818.05,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3374,'14','1',3501481.09,3504680.67,3199.58,591922.30,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3375,'15','1',2863283.99,2864714.06,1430.07,264562.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3376,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3377,'17','1',2702452.63,2705784.46,3331.83,616388.55,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3378,'18','1',2665245.50,2668798.11,3552.61,657232.85,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3379,'19','1',2755598.03,2759238.29,3640.26,673448.10,0.00,0.00,0.00,0.00,0.00),('21','228','2','121',3380,'20','1',2747823.19,2751490.71,3667.52,678491.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','121',3381,'21','2',1734247.51,1734915.42,667.91,554365.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','121',3382,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','121',3383,'23','2',2243848.00,2245982.36,2134.36,1771518.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','121',3384,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','121',3385,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','121',3386,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','121',3387,'27','3',461965.68,461965.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','121',3388,'28','3',933306.39,934569.50,1263.11,947332.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3389,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3390,'2','1',4219502.25,4222864.81,3362.56,622073.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3391,'3','1',2042756.26,2042756.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3392,'4','1',2371639.91,2374433.23,2793.32,516764.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3393,'5','1',2181002.08,2182583.03,1580.95,292475.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3394,'6','1',1906686.05,1908592.85,1906.80,352758.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3395,'7','1',1992460.52,1992460.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3396,'8','1',2684575.02,2687022.58,2447.56,452798.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3397,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','122',3398,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3399,'11','1',3246412.52,3250086.19,3673.67,679628.95,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3400,'12','1',3705758.72,3708691.21,2932.49,542510.65,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3401,'13','1',2083802.74,2087186.25,3383.51,625949.35,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3402,'14','1',3504680.67,3508961.55,4280.88,791962.80,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3403,'15','1',2864714.06,2864714.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3404,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3405,'17','1',2705784.46,2710793.48,5009.02,926668.70,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3406,'18','1',2668798.11,2668798.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3407,'19','1',2759238.29,2763377.68,4139.39,765787.15,0.00,0.00,0.00,0.00,0.00),('21','228','2','122',3408,'20','1',2751490.71,2752798.59,1307.88,241957.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','122',3409,'21','2',1734915.42,1737140.85,2225.43,1847106.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','122',3410,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','122',3411,'23','2',2245982.36,2246898.81,916.45,760653.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','122',3412,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','122',3413,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','122',3414,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','122',3415,'27','3',461965.68,461965.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','122',3416,'28','3',934569.50,937057.35,2487.85,1865887.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3417,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3418,'2','1',4222864.81,4222864.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3419,'3','1',2042756.26,2042756.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3420,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3421,'5','1',2182583.03,2182583.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3422,'6','1',1908592.85,1908592.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3423,'7','1',1992460.52,1992460.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3424,'8','1',2687022.58,2687022.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3425,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','123',3426,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3427,'11','1',3250086.19,3250086.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3428,'12','1',3708691.21,3708691.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3429,'13','1',2087186.25,2087186.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3430,'14','1',3508961.55,3508961.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3431,'15','1',2864714.06,2864714.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3432,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3433,'17','1',2710793.48,2710793.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3434,'18','1',2668798.11,2668798.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3435,'19','1',2763377.68,2763377.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','123',3436,'20','1',2752798.59,2752798.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','123',3437,'21','2',1737140.85,1737710.61,569.76,472900.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','123',3438,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','123',3439,'23','2',2246898.81,2247441.86,543.05,450731.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','123',3440,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','123',3441,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','123',3442,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','123',3443,'27','3',461965.68,461965.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','123',3444,'28','3',937057.35,937946.03,888.68,666510.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3445,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3446,'2','1',4222864.81,4222864.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3447,'3','1',2042756.26,2042756.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3448,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3449,'5','1',2182583.03,2182583.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3450,'6','1',1908592.85,1908592.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3451,'7','1',1992460.52,1992460.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3452,'8','1',2687022.58,2687022.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3453,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','124',3454,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3455,'11','1',3250086.19,3250086.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3456,'12','1',3708691.21,3708691.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3457,'13','1',2087186.25,2087186.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3458,'14','1',3508961.55,3508961.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3459,'15','1',2864714.06,2864714.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3460,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3461,'17','1',2710793.48,2710793.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3462,'18','1',2668798.11,2668798.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3463,'19','1',2763377.68,2763377.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','124',3464,'20','1',2752798.59,2752798.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','124',3465,'21','2',1737710.61,1739428.67,1718.06,1425989.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','124',3466,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','124',3467,'23','2',2247441.86,2249364.83,1922.97,1596065.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','124',3468,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','124',3469,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','124',3470,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','124',3471,'27','3',461965.68,461965.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','124',3472,'28','3',937946.03,940304.79,2358.76,1769070.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3473,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3474,'2','1',4222864.81,4225289.43,2424.62,424308.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3475,'3','1',2042756.26,2045415.67,2659.41,465396.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3476,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3477,'5','1',2182583.03,2182632.98,49.95,8741.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3478,'6','1',1908592.85,1910600.32,2007.47,351307.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3479,'7','1',1992460.52,1992460.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3480,'8','1',2687022.58,2689720.40,2697.82,472118.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3481,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','125',3482,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3483,'11','1',3250086.19,3250086.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3484,'12','1',3708691.21,3712309.66,3618.45,633228.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3485,'13','1',2087186.25,2088213.33,1027.08,179739.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3486,'14','1',3508961.55,3511529.85,2568.30,449452.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3487,'15','1',2864714.06,2868013.74,3299.68,577444.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3488,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3489,'17','1',2710793.48,2714088.32,3294.84,576597.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3490,'18','1',2668798.11,2668798.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3491,'19','1',2763377.68,2766537.17,3159.49,552910.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','125',3492,'20','1',2752798.59,2755315.42,2516.83,440445.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','125',3493,'21','2',1739428.67,1741522.32,2093.65,1737729.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','125',3494,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','125',3495,'23','2',2249364.83,2251778.62,2413.79,2003445.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','125',3496,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','125',3497,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','125',3498,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','125',3499,'27','3',461965.68,462177.43,211.75,158812.50,0.00,0.00,0.00,0.00,0.00),('21','228','4','125',3500,'28','3',940304.79,945032.44,4727.65,3545737.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3501,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3502,'2','1',4225289.43,4226702.13,1412.70,247222.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3503,'3','1',2045415.67,2046824.68,1409.01,246576.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3504,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3505,'5','1',2182632.98,2182632.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3506,'6','1',1910600.32,1911622.45,1022.13,178872.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3507,'7','1',1992460.52,1992460.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3508,'8','1',2689720.40,2690907.06,1186.66,207665.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3509,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','126',3510,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3511,'11','1',3250086.19,3251238.03,1151.84,201572.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3512,'12','1',3712309.66,3713284.75,975.09,170640.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3513,'13','1',2088213.33,2089215.06,1001.73,175302.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3514,'14','1',3511529.85,3512601.25,1071.40,187495.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3515,'15','1',2868013.74,2869222.71,1208.97,211569.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3516,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3517,'17','1',2714088.32,2715420.64,1332.32,233156.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3518,'18','1',2668798.11,2670178.99,1380.88,241654.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3519,'19','1',2766537.17,2767641.27,1104.10,193217.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','126',3520,'20','1',2755315.42,2756558.29,1242.87,217502.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','126',3521,'21','2',1741522.32,1743863.12,2340.80,1907752.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','126',3522,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','126',3523,'23','2',2251778.62,2253435.61,1656.99,1350446.85,0.00,0.00,0.00,0.00,0.00),('21','228','3','126',3524,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','126',3525,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','126',3526,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','126',3527,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','126',3528,'28','3',945032.44,947951.98,2919.54,2189655.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3529,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3530,'2','1',4226702.13,4230921.67,4219.54,738419.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3531,'3','1',2046824.68,2050335.88,3511.20,614460.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3532,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3533,'5','1',2182632.98,2183773.51,1140.53,199592.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3534,'6','1',1911622.45,1913945.17,2322.72,406476.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3535,'7','1',1992460.52,1992471.09,10.57,1849.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3536,'8','1',2690907.06,2694471.24,3564.18,623731.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3537,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','127',3538,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3539,'11','1',3251238.03,3253744.31,2506.28,438599.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3540,'12','1',3713284.75,3717074.27,3789.52,663166.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3541,'13','1',2089215.06,2091999.80,2784.74,487329.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3542,'14','1',3512601.25,3516119.00,3517.75,615606.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3543,'15','1',2869222.71,2873427.96,4205.25,735918.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3544,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3545,'17','1',2715420.64,2719791.30,4370.66,764865.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3546,'18','1',2670178.99,2671309.85,1130.86,197900.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3547,'19','1',2767641.27,2771585.23,3943.96,690193.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','127',3548,'20','1',2756558.29,2760323.77,3765.48,658959.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','127',3549,'21','2',1743863.12,1745404.98,1541.86,1256615.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','127',3550,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','127',3551,'23','2',2253435.61,2255077.70,1642.09,1338303.35,0.00,0.00,0.00,0.00,0.00),('21','228','3','127',3552,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','127',3553,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','127',3554,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','127',3555,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','127',3556,'28','3',947951.98,949552.87,1600.89,1200667.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3557,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3558,'2','1',4230921.67,4230921.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3559,'3','1',2050335.88,2050335.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3560,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3561,'5','1',2183773.51,2183773.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3562,'6','1',1913945.17,1913945.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3563,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3564,'8','1',2694471.24,2694471.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3565,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','128',3566,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3567,'11','1',3253744.31,3253744.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3568,'12','1',3717074.27,3717074.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3569,'13','1',2091999.80,2091999.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3570,'14','1',3516119.00,3516119.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3571,'15','1',2873427.96,2873427.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3572,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3573,'17','1',2719791.30,2719791.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3574,'18','1',2671309.85,2671309.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3575,'19','1',2771585.23,2771585.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','128',3576,'20','1',2760323.77,2760323.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','128',3577,'21','2',1745404.98,1746747.12,1342.14,1093844.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','128',3578,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','128',3579,'23','2',2255077.70,2256260.28,1182.58,963802.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','128',3580,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','128',3581,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','128',3582,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','128',3583,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','128',3584,'28','3',949552.87,949844.56,291.69,218767.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3585,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3586,'2','1',4230921.67,4233326.48,2404.81,420841.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3587,'3','1',2050335.88,2052329.14,1993.26,348820.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3588,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3589,'5','1',2183773.51,2183773.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3590,'6','1',1913945.17,1915593.92,1648.75,288531.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3591,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3592,'8','1',2694471.24,2696548.59,2077.35,363536.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3593,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','129',3594,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3595,'11','1',3253744.31,3255025.01,1280.70,224122.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3596,'12','1',3717074.27,3719332.10,2257.83,395120.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3597,'13','1',2091999.80,2093260.66,1260.86,220650.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3598,'14','1',3516119.00,3517604.80,1485.80,260015.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3599,'15','1',2873427.96,2875379.22,1951.26,341470.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3600,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3601,'17','1',2719791.30,2722039.79,2248.49,393485.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3602,'18','1',2671309.85,2673105.61,1795.76,314258.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3603,'19','1',2771585.23,2773582.05,1996.82,349443.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','129',3604,'20','1',2760323.77,2762678.31,2354.54,412044.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','129',3605,'21','2',1746747.12,1748807.52,2060.40,1679226.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','129',3606,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','129',3607,'23','2',2256260.28,2258925.47,2665.19,2172129.85,0.00,0.00,0.00,0.00,0.00),('21','228','3','129',3608,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','129',3609,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','129',3610,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','129',3611,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','129',3612,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3613,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3614,'2','1',4233326.48,4236924.14,3597.66,629590.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3615,'3','1',2052329.14,2056234.62,3905.48,683459.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3616,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3617,'5','1',2183773.51,2185065.69,1292.18,226131.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3618,'6','1',1915593.92,1917061.91,1467.99,256898.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3619,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3620,'8','1',2696548.59,2699901.71,3353.12,586796.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3621,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','130',3622,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3623,'11','1',3255025.01,3257461.10,2436.09,426315.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3624,'12','1',3719332.10,3722094.44,2762.34,483409.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3625,'13','1',2093260.66,2095273.52,2012.86,352250.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3626,'14','1',3517604.80,3520766.18,3161.38,553241.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3627,'15','1',2875379.22,2878701.81,3322.59,581453.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3628,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3629,'17','1',2722039.79,2724696.92,2657.13,464997.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3630,'18','1',2673105.61,2676345.22,3239.61,566931.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3631,'19','1',2773582.05,2777407.12,3825.07,669387.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','130',3632,'20','1',2762678.31,2765843.77,3165.46,553955.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','130',3633,'21','2',1748807.52,1750060.15,1252.63,1020893.45,0.00,0.00,0.00,0.00,0.00),('21','228','3','130',3634,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','130',3635,'23','2',2258925.47,2259666.05,740.58,603572.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','130',3636,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','130',3637,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','130',3638,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','130',3639,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','130',3640,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3641,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3642,'2','1',4236924.14,4241885.79,4961.65,868288.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3643,'3','1',2056234.62,2060794.19,4559.57,797924.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3644,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3645,'5','1',2185065.69,2187249.47,2183.78,382161.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3646,'6','1',1917061.91,1920058.82,2996.91,524459.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3647,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3648,'8','1',2699901.71,2705039.36,5137.65,899088.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3649,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','131',3650,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3651,'11','1',3257461.10,3261000.01,3538.91,619309.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3652,'12','1',3722094.44,3725941.26,3846.82,673193.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3653,'13','1',2095273.52,2096875.69,1602.17,280379.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3654,'14','1',3520766.18,3525471.89,4705.71,823499.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3655,'15','1',2878701.81,2884787.00,6085.19,1064908.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3656,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3657,'17','1',2724696.92,2727858.48,3161.56,553273.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3658,'18','1',2676345.22,2679930.72,3585.50,627462.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3659,'19','1',2777407.12,2782682.80,5275.68,923244.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','131',3660,'20','1',2765843.77,2770639.45,4795.68,839244.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','131',3661,'21','2',1750060.15,1754129.43,4069.28,3296116.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','131',3662,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','131',3663,'23','2',2259666.05,2261633.27,1967.22,1593448.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','131',3664,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','131',3665,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','131',3666,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','131',3667,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','131',3668,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3669,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3670,'2','1',4241885.79,4241885.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3671,'3','1',2060794.19,2060794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3672,'4','1',2374433.23,2374433.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3673,'5','1',2187249.47,2187249.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3674,'6','1',1920058.82,1920058.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3675,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3676,'8','1',2705039.36,2705039.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3677,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','132',3678,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3679,'11','1',3261000.01,3261000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3680,'12','1',3725941.26,3725941.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3681,'13','1',2096875.69,2096875.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3682,'14','1',3525471.89,3525471.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3683,'15','1',2884787.00,2884787.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3684,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3685,'17','1',2727858.48,2727858.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3686,'18','1',2679930.72,2679930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3687,'19','1',2782682.80,2782682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','132',3688,'20','1',2770639.45,2770639.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','132',3689,'21','2',1754129.43,1754129.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','132',3690,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','132',3691,'23','2',2261633.27,2261633.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','132',3692,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','132',3693,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','132',3694,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','132',3695,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','132',3696,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3697,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3698,'2','1',4241885.79,4246153.83,4268.04,746907.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3699,'3','1',2060794.19,2063961.56,3167.37,554289.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3700,'4','1',2374433.23,2374441.81,8.58,1501.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3701,'5','1',2187249.47,2189075.90,1826.43,319625.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3702,'6','1',1920058.82,1922754.75,2695.93,471787.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3703,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3704,'8','1',2705039.36,2708547.33,3507.97,613894.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3705,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','133',3706,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3707,'11','1',3261000.01,3264333.86,3333.85,583423.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3708,'12','1',3725941.26,3729176.70,3235.44,566202.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3709,'13','1',2096875.69,2096879.75,4.06,710.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3710,'14','1',3525471.89,3529423.86,3951.97,691594.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3711,'15','1',2884787.00,2889572.79,4785.79,837513.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3712,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3713,'17','1',2727858.48,2731371.30,3512.82,614743.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3714,'18','1',2679930.72,2681651.75,1721.03,301180.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3715,'19','1',2782682.80,2785223.15,2540.35,444561.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','133',3716,'20','1',2770639.45,2775064.99,4425.54,774469.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','133',3717,'21','2',1754129.43,1757491.32,3361.89,2723130.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','133',3718,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','133',3719,'23','2',2261633.27,2263176.40,1543.13,1249935.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','133',3720,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','133',3721,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','133',3722,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','133',3723,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','133',3724,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3725,'1','1',2241575.12,2241575.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3726,'2','1',4246153.83,4249357.21,3203.38,560591.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3727,'3','1',2063961.56,2066493.38,2531.82,443068.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3728,'4','1',2374441.81,2374441.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3729,'5','1',2189075.90,2191085.38,2009.48,351659.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3730,'6','1',1922754.75,1923854.67,1099.92,192486.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3731,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3732,'8','1',2708547.33,2710819.57,2272.24,397642.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3733,'9','1',2352079.83,2352079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','134',3734,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3735,'11','1',3264333.86,3267501.84,3167.98,554396.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3736,'12','1',3729176.70,3731913.44,2736.74,478929.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3737,'13','1',2096879.75,2096879.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3738,'14','1',3529423.86,3533022.37,3598.51,629739.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3739,'15','1',2889572.79,2892757.76,3184.97,557369.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3740,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3741,'17','1',2731371.30,2734923.64,3552.34,621659.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3742,'18','1',2681651.75,2682748.72,1096.97,191969.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3743,'19','1',2785223.15,2789547.32,4324.17,756729.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','134',3744,'20','1',2775064.99,2778282.26,3217.27,563022.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','134',3745,'21','2',1757491.32,1761312.27,3820.95,3094969.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','134',3746,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','134',3747,'23','2',2263176.40,2269978.86,6802.46,5509992.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','134',3748,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','134',3749,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','134',3750,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','134',3751,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','134',3752,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3753,'1','1',2241575.12,2241577.92,2.80,490.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3754,'2','1',4249357.21,4251493.50,2136.29,373850.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3755,'3','1',2066493.38,2068423.80,1930.42,337823.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3756,'4','1',2374441.81,2374441.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3757,'5','1',2191085.38,2192369.94,1284.56,224798.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3758,'6','1',1923854.67,1924922.25,1067.58,186826.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3759,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3760,'8','1',2710819.57,2712148.63,1329.06,232585.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3761,'9','1',2352079.83,2352100.04,20.21,3536.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','135',3762,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3763,'11','1',3267501.84,3270713.58,3211.74,562054.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3764,'12','1',3731913.44,3735785.75,3872.31,677654.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3765,'13','1',2096879.75,2096879.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3766,'14','1',3533022.37,3537286.28,4263.91,746184.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3767,'15','1',2892757.76,2896856.58,4098.82,717293.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3768,'16','1',2784637.15,2784637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3769,'17','1',2734923.64,2738136.55,3212.91,562259.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3770,'18','1',2682748.72,2686011.80,3263.08,571039.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3771,'19','1',2789547.32,2793880.78,4333.46,758355.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','135',3772,'20','1',2778282.26,2783219.48,4937.22,864013.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','135',3773,'21','2',1761312.27,1763151.64,1839.37,1489889.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','135',3774,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','135',3775,'23','2',2269978.86,2272007.04,2028.18,1642825.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','135',3776,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','135',3777,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','135',3778,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','135',3779,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','135',3780,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3781,'1','1',2241577.92,2242563.00,985.08,172389.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3782,'2','1',4251493.50,4252478.89,985.39,172443.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3783,'3','1',2068423.80,2069553.36,1129.56,197673.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3784,'4','1',2374441.81,2374441.85,0.04,7.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3785,'5','1',2192369.94,2192400.10,30.16,5278.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3786,'6','1',1924922.25,1925897.30,975.05,170633.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3787,'7','1',1992471.09,1992471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3788,'8','1',2712148.63,2713370.31,1221.68,213794.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3789,'9','1',2352100.04,2353161.27,1061.23,185715.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','136',3790,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3791,'11','1',3270713.58,3274429.18,3715.60,650230.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3792,'12','1',3735785.75,3739964.63,4178.88,731304.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3793,'13','1',2096879.75,2096927.25,47.50,8312.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3794,'14','1',3537286.28,3541937.22,4650.94,813914.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3795,'15','1',2896856.58,2901688.49,4831.91,845584.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3796,'16','1',2784637.15,2784691.07,53.92,9436.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3797,'17','1',2738136.55,2741888.26,3751.71,656549.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3798,'18','1',2686011.80,2689849.58,3837.78,671611.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3799,'19','1',2793880.78,2799014.07,5133.29,898325.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','136',3800,'20','1',2783219.48,2789329.47,6109.99,1069248.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','136',3801,'21','2',1763151.64,1764892.78,1741.14,1410323.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','136',3802,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','136',3803,'23','2',2272007.04,2274717.68,2710.64,2195618.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','136',3804,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','136',3805,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','136',3806,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','136',3807,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','136',3808,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3809,'1','1',2242563.00,2244223.53,1660.53,290592.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3810,'2','1',4252478.89,4254231.27,1752.38,306666.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3811,'3','1',2069553.36,2071373.88,1820.52,318591.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3812,'4','1',2374441.85,2374858.09,416.24,72842.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3813,'5','1',2192400.10,2192870.95,470.85,82398.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3814,'6','1',1925897.30,1927496.23,1598.93,279812.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3815,'7','1',1992471.09,1993088.79,617.70,108097.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3816,'8','1',2713370.31,2715245.49,1875.18,328156.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3817,'9','1',2353161.27,2355358.54,2197.27,384522.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','137',3818,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3819,'11','1',3274429.18,3277142.36,2713.18,474806.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3820,'12','1',3739964.63,3741712.95,1748.32,305956.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3821,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3822,'14','1',3541937.22,3544813.40,2876.18,503331.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3823,'15','1',2901688.49,2904313.82,2625.33,459432.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3824,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3825,'17','1',2741888.26,2744511.50,2623.24,459067.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3826,'18','1',2689849.58,2690834.02,984.44,172277.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3827,'19','1',2799014.07,2801479.19,2465.12,431396.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','137',3828,'20','1',2789329.47,2791953.56,2624.09,459215.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','137',3829,'21','2',1764892.78,1766173.82,1281.04,1037642.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','137',3830,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','137',3831,'23','2',2274717.68,2276559.01,1841.33,1491477.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','137',3832,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','137',3833,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','137',3834,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','137',3835,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','137',3836,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3837,'1','1',2244223.53,2245164.85,941.32,164731.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3838,'2','1',4254231.27,4255851.89,1620.62,283608.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3839,'3','1',2071373.88,2072561.60,1187.72,207851.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3840,'4','1',2374858.09,2375717.42,859.33,150382.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3841,'5','1',2192870.95,2194029.46,1158.51,202739.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3842,'6','1',1927496.23,1928130.52,634.29,111000.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3843,'7','1',1993088.79,1994128.02,1039.23,181865.95,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3844,'8','1',2715245.49,2715879.57,634.08,110964.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3845,'9','1',2355358.54,2356912.58,1554.04,271957.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','138',3846,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3847,'11','1',3277142.36,3278563.52,1421.16,248703.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3848,'12','1',3741712.95,3742865.54,1152.59,201703.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3849,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3850,'14','1',3544813.40,3546296.89,1483.49,259610.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3851,'15','1',2904313.82,2905475.15,1161.33,203232.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3852,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3853,'17','1',2744511.50,2746247.48,1735.98,303796.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3854,'18','1',2690834.02,2692511.41,1677.39,293543.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3855,'19','1',2801479.19,2803465.34,1986.15,347576.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','138',3856,'20','1',2791953.56,2793803.29,1849.73,323702.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','138',3857,'21','2',1766173.82,1768199.70,2025.88,1640962.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','138',3858,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','138',3859,'23','2',2276559.01,2276612.61,53.60,43416.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','138',3860,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','138',3861,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','138',3862,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','138',3863,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','138',3864,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3865,'1','1',2245164.85,2245852.22,687.37,120289.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3866,'2','1',4255851.89,4258100.79,2248.90,393557.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3867,'3','1',2072561.60,2074443.06,1881.46,329255.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3868,'4','1',2375717.42,2375797.43,80.01,14001.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3869,'5','1',2194029.46,2194057.12,27.66,4840.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3870,'6','1',1928130.52,1929513.22,1382.70,241972.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3871,'7','1',1994128.02,1996768.58,2640.56,462098.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3872,'8','1',2715879.57,2715879.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3873,'9','1',2356912.58,2358830.23,1917.65,335588.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','139',3874,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3875,'11','1',3278563.52,3280044.36,1480.84,259147.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3876,'12','1',3742865.54,3744560.52,1694.98,296621.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3877,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3878,'14','1',3546296.89,3548277.03,1980.14,346524.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3879,'15','1',2905475.15,2907191.27,1716.12,300321.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3880,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3881,'17','1',2746247.48,2747966.60,1719.12,300846.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3882,'18','1',2692511.41,2694644.75,2133.34,373335.20,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3883,'19','1',2803465.34,2804997.00,1531.66,268040.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','139',3884,'20','1',2793803.29,2795882.55,2079.26,363870.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','139',3885,'21','2',1768199.70,1770587.17,2387.47,1933850.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','139',3886,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','139',3887,'23','2',2276612.61,2279126.66,2514.05,2036380.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','139',3888,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','139',3889,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','139',3890,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','139',3891,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','139',3892,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3893,'1','1',2245852.22,2245852.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3894,'2','1',4258100.79,4259112.89,1012.10,177117.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3895,'3','1',2074443.06,2075170.78,727.72,127351.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3896,'4','1',2375797.43,2375797.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3897,'5','1',2194057.12,2194960.99,903.87,158177.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3898,'6','1',1929513.22,1929513.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3899,'7','1',1996768.58,1996768.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3900,'8','1',2715879.57,2716556.63,677.06,118485.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3901,'9','1',2358830.23,2359607.14,776.91,135959.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','140',3902,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3903,'11','1',3280044.36,3281600.70,1556.34,272359.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3904,'12','1',3744560.52,3746452.78,1892.26,331145.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3905,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3906,'14','1',3548277.03,3550151.24,1874.21,327986.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3907,'15','1',2907191.27,2909266.80,2075.53,363217.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3908,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3909,'17','1',2747966.60,2749662.93,1696.33,296857.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3910,'18','1',2694644.75,2696337.37,1692.62,296208.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3911,'19','1',2804997.00,2807280.04,2283.04,399532.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','140',3912,'20','1',2795882.55,2798434.38,2551.83,446570.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','140',3913,'21','2',1770587.17,1771573.45,986.28,798886.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','140',3914,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','140',3915,'23','2',2279126.66,2280666.37,1539.71,1247165.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','140',3916,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','140',3917,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','140',3918,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','140',3919,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','140',3920,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3921,'1','1',2245852.22,2248497.65,2645.43,462950.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3922,'2','1',4259112.89,4263468.36,4355.47,762207.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3923,'3','1',2075170.78,2078004.22,2833.44,495852.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3924,'4','1',2375797.43,2377408.43,1611.00,281925.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3925,'5','1',2194960.99,2196994.87,2033.88,355929.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3926,'6','1',1929513.22,1932419.83,2906.61,508656.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3927,'7','1',1996768.58,1998743.32,1974.74,345579.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3928,'8','1',2716556.63,2719403.19,2846.56,498148.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3929,'9','1',2359607.14,2363285.43,3678.29,643700.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','141',3930,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3931,'11','1',3281600.70,3286587.62,4986.92,872711.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3932,'12','1',3746452.78,3751337.46,4884.68,854819.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3933,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3934,'14','1',3550151.24,3555608.63,5457.39,955043.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3935,'15','1',2909266.80,2915167.79,5900.99,1032673.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3936,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3937,'17','1',2749662.93,2754396.59,4733.66,828390.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3938,'18','1',2696337.37,2700445.63,4108.26,718945.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3939,'19','1',2807280.04,2812954.47,5674.43,993025.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','141',3940,'20','1',2798434.38,2803317.08,4882.70,854472.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','141',3941,'21','2',1771573.45,1773661.72,2088.27,1691498.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','141',3942,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','141',3943,'23','2',2280666.37,2282107.26,1440.89,1167120.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','141',3944,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','141',3945,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','141',3946,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','141',3947,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','141',3948,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3949,'1','1',2248497.65,2249201.12,703.47,123107.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3950,'2','1',4263468.36,4264111.30,642.94,112514.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3951,'3','1',2078004.22,2078711.02,706.80,123690.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3952,'4','1',2377408.43,2377408.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3953,'5','1',2196994.87,2197742.38,747.51,130814.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3954,'6','1',1932419.83,1932419.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3955,'7','1',1998743.32,1999537.77,794.45,139028.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3956,'8','1',2719403.19,2719856.37,453.18,79306.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3957,'9','1',2363285.43,2364170.39,884.96,154868.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','142',3958,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3959,'11','1',3286587.62,3288599.23,2011.61,352031.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3960,'12','1',3751337.46,3753394.70,2057.24,360017.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3961,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3962,'14','1',3555608.63,3557836.02,2227.39,389793.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3963,'15','1',2915167.79,2917843.87,2676.08,468314.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3964,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3965,'17','1',2754396.59,2757087.14,2690.55,470846.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3966,'18','1',2700445.63,2702687.96,2242.33,392407.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3967,'19','1',2812954.47,2815262.95,2308.48,403984.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','142',3968,'20','1',2803317.08,2806125.55,2808.47,491482.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','142',3969,'21','2',1773661.72,1775117.16,1455.44,1178906.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','142',3970,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','142',3971,'23','2',2282107.26,2285004.26,2897.00,2346570.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','142',3972,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','142',3973,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','142',3974,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','142',3975,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','142',3976,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3977,'1','1',2249201.12,2249201.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3978,'2','1',4264111.30,4264111.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3979,'3','1',2078711.02,2078711.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3980,'4','1',2377408.43,2377408.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3981,'5','1',2197742.38,2197742.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3982,'6','1',1932419.83,1932419.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3983,'7','1',1999537.77,1999537.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3984,'8','1',2719856.37,2719856.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3985,'9','1',2364170.39,2364170.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','143',3986,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3987,'11','1',3288599.23,3288599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3988,'12','1',3753394.70,3753394.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3989,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3990,'14','1',3557836.02,3557836.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3991,'15','1',2917843.87,2917843.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3992,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3993,'17','1',2757087.14,2757087.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3994,'18','1',2702687.96,2702687.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3995,'19','1',2815262.95,2815262.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','143',3996,'20','1',2806125.55,2806125.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','143',3997,'21','2',1775117.16,1777291.36,2174.20,1761102.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','143',3998,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','143',3999,'23','2',2285004.26,2286395.76,1391.50,1127115.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','143',4000,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','143',4001,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','143',4002,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','143',4003,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','143',4004,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4005,'1','1',2249201.12,2252263.29,3062.17,535879.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4006,'2','1',4264111.30,4267855.02,3743.72,655151.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4007,'3','1',2078711.02,2081506.71,2795.69,489245.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4008,'4','1',2377408.43,2380487.85,3079.42,538898.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4009,'5','1',2197742.38,2200681.81,2939.43,514400.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4010,'6','1',1932419.83,1935949.43,3529.60,617680.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4011,'7','1',1999537.77,2002775.87,3238.10,566667.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4012,'8','1',2719856.37,2723531.85,3675.48,643209.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4013,'9','1',2364170.39,2367824.62,3654.23,639490.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','144',4014,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4015,'11','1',3288599.23,3290639.62,2040.39,357068.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4016,'12','1',3753394.70,3755057.56,1662.86,291000.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4017,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4018,'14','1',3557836.02,3560644.18,2808.16,491428.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4019,'15','1',2917843.87,2920028.99,2185.12,382396.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4020,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4021,'17','1',2757087.14,2759560.16,2473.02,432778.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4022,'18','1',2702687.96,2702687.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4023,'19','1',2815262.95,2817614.92,2351.97,411594.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','144',4024,'20','1',2806125.55,2807944.66,1819.11,318344.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','144',4025,'21','2',1777291.36,1778813.84,1522.48,1233208.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','144',4026,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','144',4027,'23','2',2286395.76,2288822.86,2427.10,1965951.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','144',4028,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','144',4029,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','144',4030,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','144',4031,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','144',4032,'28','3',949844.56,949844.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4033,'1','1',2252263.29,2252900.38,637.09,111490.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4034,'2','1',4267855.02,4269229.53,1374.51,240539.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4035,'3','1',2081506.71,2082173.52,666.81,116691.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4036,'4','1',2380487.85,2381445.81,957.96,167643.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4037,'5','1',2200681.81,2201474.22,792.41,138671.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4038,'6','1',1935949.43,1936945.63,996.20,174335.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4039,'7','1',2002775.87,2003843.16,1067.29,186775.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4040,'8','1',2723531.85,2723531.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4041,'9','1',2367824.62,2368997.16,1172.54,205194.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','145',4042,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4043,'11','1',3290639.62,3291534.41,894.79,156588.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4044,'12','1',3755057.56,3756302.28,1244.72,217826.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4045,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4046,'14','1',3560644.18,3561889.69,1245.51,217964.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4047,'15','1',2920028.99,2921274.67,1245.68,217994.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4048,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4049,'17','1',2759560.16,2760475.65,915.49,160210.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4050,'18','1',2702687.96,2703624.02,936.06,163810.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4051,'19','1',2817614.92,2818591.21,976.29,170850.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','145',4052,'20','1',2807944.66,2809182.53,1237.87,216627.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','145',4053,'21','2',1778813.84,1780155.41,1341.57,1086671.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','145',4054,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','145',4055,'23','2',2288822.86,2289116.26,293.40,237654.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','145',4056,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','145',4057,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','145',4058,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','145',4059,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','145',4060,'28','3',949844.56,950476.78,632.22,527903.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4061,'1','1',2252900.38,2253537.29,636.91,111459.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4062,'2','1',4269229.53,4270435.29,1205.76,211008.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4063,'3','1',2082173.52,2083464.67,1291.15,225951.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4064,'4','1',2381445.81,2381445.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4065,'5','1',2201474.22,2202733.80,1259.58,220426.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4066,'6','1',1936945.63,1936945.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4067,'7','1',2003843.16,2005088.63,1245.47,217957.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4068,'8','1',2723531.85,2723531.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4069,'9','1',2368997.16,2370078.62,1081.46,189255.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','146',4070,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4071,'11','1',3291534.41,3292286.47,752.06,131610.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4072,'12','1',3756302.28,3757043.48,741.20,129710.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4073,'13','1',2096927.25,2096927.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4074,'14','1',3561889.69,3562956.50,1066.81,186691.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4075,'15','1',2921274.67,2922177.27,902.60,157955.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4076,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4077,'17','1',2760475.65,2761243.30,767.65,134338.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4078,'18','1',2703624.02,2704231.32,607.30,106277.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4079,'19','1',2818591.21,2819489.75,898.54,157244.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','146',4080,'20','1',2809182.53,2810069.82,887.29,155275.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','146',4081,'21','2',1780155.41,1781791.70,1636.29,1325394.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','146',4082,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','146',4083,'23','2',2289116.26,2291967.43,2851.17,2309447.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','146',4084,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','146',4085,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','146',4086,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','146',4087,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','146',4088,'28','3',950476.78,952114.98,1638.20,1367897.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4089,'1','1',2253537.29,2254971.54,1434.25,250993.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4090,'2','1',4270435.29,4272767.91,2332.62,408208.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4091,'3','1',2083464.67,2085180.12,1715.45,300203.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4092,'4','1',2381445.81,2382923.38,1477.57,258574.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4093,'5','1',2202733.80,2204060.45,1326.65,232163.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4094,'6','1',1936945.63,1938566.68,1621.05,283683.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4095,'7','1',2005088.63,2006653.42,1564.79,273838.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4096,'8','1',2723531.85,2725641.84,2109.99,369248.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4097,'9','1',2370078.62,2372250.17,2171.55,380021.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','147',4098,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4099,'11','1',3292286.47,3294943.60,2657.13,464997.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4100,'12','1',3757043.48,3759390.27,2346.79,410688.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4101,'13','1',2096927.25,2096927.35,0.10,17.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4102,'14','1',3562956.50,3566438.23,3481.73,609302.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4103,'15','1',2922177.27,2925540.22,3362.95,588516.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4104,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4105,'17','1',2761243.30,2764116.13,2872.83,502745.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4106,'18','1',2704231.32,2706912.77,2681.45,469253.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4107,'19','1',2819489.75,2823201.62,3711.87,649577.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','147',4108,'20','1',2810069.82,2813155.94,3086.12,540071.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','147',4109,'21','2',1781791.70,1784096.67,2304.97,1867025.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','147',4110,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','147',4111,'23','2',2291967.43,2293875.09,1907.66,1545204.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','147',4112,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','147',4113,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','147',4114,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','147',4115,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','147',4116,'28','3',952114.98,953239.30,1124.32,938807.20,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4117,'1','1',2254971.54,2254971.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4118,'2','1',4272767.91,4272767.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4119,'3','1',2085180.12,2085180.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4120,'4','1',2382923.38,2382923.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4121,'5','1',2204060.45,2204060.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4122,'6','1',1938566.68,1938566.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4123,'7','1',2006653.42,2006653.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4124,'8','1',2725641.84,2725641.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4125,'9','1',2372250.17,2372250.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','148',4126,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4127,'11','1',3294943.60,3294943.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4128,'12','1',3759390.27,3759390.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4129,'13','1',2096927.35,2096927.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4130,'14','1',3566438.23,3566438.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4131,'15','1',2925540.22,2925540.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4132,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4133,'17','1',2764116.13,2764116.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4134,'18','1',2706912.77,2706912.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4135,'19','1',2823201.62,2823201.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','148',4136,'20','1',2813155.94,2813155.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','148',4137,'21','2',1784096.67,1784096.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','148',4138,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','148',4139,'23','2',2293875.09,2293875.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','148',4140,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','148',4141,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','148',4142,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','148',4143,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','148',4144,'28','3',953239.30,953239.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4145,'1','1',2254971.54,2255458.53,486.99,85223.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4146,'2','1',4272767.91,4273227.45,459.54,80419.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4147,'3','1',2085180.12,2085762.17,582.05,101858.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4148,'4','1',2382923.38,2383416.70,493.32,86331.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4149,'5','1',2204060.45,2204599.66,539.21,94361.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4150,'6','1',1938566.68,1939053.48,486.80,85190.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4151,'7','1',2006653.42,2007248.49,595.07,104137.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4152,'8','1',2725641.84,2726160.93,519.09,90840.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4153,'9','1',2372250.17,2373425.15,1174.98,205621.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','149',4154,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4155,'11','1',3294943.60,3294943.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4156,'12','1',3759390.27,3759390.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4157,'13','1',2096927.35,2096927.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4158,'14','1',3566438.23,3566438.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4159,'15','1',2925540.22,2925540.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4160,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4161,'17','1',2764116.13,2764116.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4162,'18','1',2706912.77,2706912.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4163,'19','1',2823201.62,2823201.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','149',4164,'20','1',2813155.94,2813155.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','149',4165,'21','2',1784096.67,1786992.84,2896.17,2345897.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','149',4166,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','149',4167,'23','2',2293875.09,2295480.86,1605.77,1300673.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','149',4168,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','149',4169,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','149',4170,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','149',4171,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','149',4172,'28','3',953239.30,954464.61,1225.31,1023133.85,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4173,'1','1',2255458.53,2258212.94,2754.41,482021.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4174,'2','1',4273227.45,4277361.54,4134.09,723465.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4175,'3','1',2085762.17,2088765.43,3003.26,525570.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4176,'4','1',2383416.70,2386567.96,3151.26,551470.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4177,'5','1',2204599.66,2206695.51,2095.85,366773.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4178,'6','1',1939053.48,1942158.49,3105.01,543376.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4179,'7','1',2007248.49,2009313.30,2064.81,361341.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4180,'8','1',2726160.93,2729520.10,3359.17,587854.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4181,'9','1',2373425.15,2377181.06,3755.91,657284.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','150',4182,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4183,'11','1',3294943.60,3298678.26,3734.66,653565.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4184,'12','1',3759390.27,3763383.73,3993.46,698855.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4185,'13','1',2096927.35,2096927.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4186,'14','1',3566438.23,3570740.93,4302.70,752972.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4187,'15','1',2925540.22,2929968.42,4428.20,774935.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4188,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4189,'17','1',2764116.13,2767710.74,3594.61,629056.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4190,'18','1',2706912.77,2709871.25,2958.48,517734.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4191,'19','1',2823201.62,2826397.56,3195.94,559289.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','150',4192,'20','1',2813155.94,2816888.09,3732.15,653126.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','150',4193,'21','2',1786992.84,1788579.59,1586.75,1285267.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','150',4194,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','150',4195,'23','2',2295480.86,2298312.68,2831.82,2293774.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','150',4196,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','150',4197,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','150',4198,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','150',4199,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','150',4200,'28','3',954464.61,955485.43,1020.82,852384.70,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4201,'1','1',2258212.94,2258712.99,500.05,87508.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4202,'2','1',4277361.54,4281464.13,4102.59,717953.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4203,'3','1',2088765.43,2091292.32,2526.89,442205.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4204,'4','1',2386567.96,2389784.92,3216.96,562968.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4205,'5','1',2206695.51,2209006.09,2310.58,404351.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4206,'6','1',1942158.49,1944729.77,2571.28,449974.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4207,'7','1',2009313.30,2011122.03,1808.73,316527.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4208,'8','1',2729520.10,2732254.74,2734.64,478562.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4209,'9','1',2377181.06,2380547.77,3366.71,589174.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','151',4210,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4211,'11','1',3298678.26,3300376.29,1698.03,297155.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4212,'12','1',3763383.73,3765896.04,2512.31,439654.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4213,'13','1',2096927.35,2096961.73,34.38,6016.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4214,'14','1',3570740.93,3572902.22,2161.29,378225.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4215,'15','1',2929968.42,2932262.74,2294.32,401506.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4216,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4217,'17','1',2767710.74,2770051.63,2340.89,409655.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4218,'18','1',2709871.25,2711380.96,1509.71,264199.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4219,'19','1',2826397.56,2828480.44,2082.88,364504.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','151',4220,'20','1',2816888.09,2819084.44,2196.35,384361.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','151',4221,'21','2',1788579.59,1790169.75,1590.16,1288029.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','151',4222,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','151',4223,'23','2',2298312.68,2301399.22,3086.54,2500097.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','151',4224,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','151',4225,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','151',4226,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','151',4227,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','151',4228,'28','3',955485.43,956985.04,1499.61,1274668.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4229,'1','1',2258712.99,2260372.42,1659.43,290400.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4230,'2','1',4281464.13,4283397.04,1932.91,338259.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4231,'3','1',2091292.32,2092705.38,1413.06,247285.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4232,'4','1',2389784.92,2391333.42,1548.50,270987.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4233,'5','1',2209006.09,2210275.92,1269.83,222220.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4234,'6','1',1944729.77,1946341.79,1612.02,282103.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4235,'7','1',2011122.03,2012525.48,1403.45,245603.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4236,'8','1',2732254.74,2734109.71,1854.97,324619.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4237,'9','1',2380547.77,2382874.68,2326.91,407209.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','152',4238,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4239,'11','1',3300376.29,3300376.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4240,'12','1',3765896.04,3765896.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4241,'13','1',2096961.73,2096961.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4242,'14','1',3572902.22,3572902.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4243,'15','1',2932262.74,2932262.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4244,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4245,'17','1',2770051.63,2770051.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4246,'18','1',2711380.96,2711380.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4247,'19','1',2828480.44,2828480.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','152',4248,'20','1',2819084.44,2819084.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','152',4249,'21','2',1790169.75,1792226.59,2056.84,1666040.40,0.00,0.00,0.00,0.00,0.00),('21','228','3','152',4250,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','152',4251,'23','2',2301399.22,2302706.40,1307.18,1058815.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','152',4252,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','152',4253,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','152',4254,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','152',4255,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','152',4256,'28','3',956985.04,957772.51,787.47,669349.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4257,'1','1',2260372.42,2261872.36,1499.94,262489.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4258,'2','1',4283397.04,4285498.92,2101.88,367829.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4259,'3','1',2092705.38,2094283.85,1578.47,276232.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4260,'4','1',2391333.42,2392693.34,1359.92,237986.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4261,'5','1',2210275.92,2211958.88,1682.96,294518.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4262,'6','1',1946341.79,1947771.08,1429.29,250125.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4263,'7','1',2012525.48,2014089.01,1563.53,273617.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4264,'8','1',2734109.71,2735827.16,1717.45,300553.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4265,'9','1',2382874.68,2384887.61,2012.93,352262.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','153',4266,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4267,'11','1',3300376.29,3300376.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4268,'12','1',3765896.04,3765896.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4269,'13','1',2096961.73,2096961.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4270,'14','1',3572902.22,3572902.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4271,'15','1',2932262.74,2932262.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4272,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4273,'17','1',2770051.63,2770051.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4274,'18','1',2711380.96,2711380.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4275,'19','1',2828480.44,2828480.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','153',4276,'20','1',2819084.44,2819084.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','153',4277,'21','2',1792226.59,1793179.45,952.86,771816.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','153',4278,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','153',4279,'23','2',2302706.40,2303332.80,626.40,507384.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','153',4280,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','153',4281,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','153',4282,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','153',4283,'27','3',462177.43,462177.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','153',4284,'28','3',957772.51,958179.40,406.89,345856.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4285,'1','1',2261872.36,2263142.56,1270.20,222285.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4286,'2','1',4285498.92,4288285.76,2786.84,487697.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4287,'3','1',2094283.85,2096321.20,2037.35,356536.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4288,'4','1',2392693.34,2394794.68,2101.34,367734.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4289,'5','1',2211958.88,2213827.06,1868.18,326931.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4290,'6','1',1947771.08,1950099.18,2328.10,407417.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4291,'7','1',2014089.01,2016215.92,2126.91,372209.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4292,'8','1',2735827.16,2737674.24,1847.08,323239.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4293,'9','1',2384887.61,2388495.39,3607.78,631361.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','154',4294,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4295,'11','1',3300376.29,3300376.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4296,'12','1',3765896.04,3765896.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4297,'13','1',2096961.73,2096961.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4298,'14','1',3572902.22,3572902.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4299,'15','1',2932262.74,2932262.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4300,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4301,'17','1',2770051.63,2770051.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4302,'18','1',2711380.96,2711380.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4303,'19','1',2828480.44,2828480.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','154',4304,'20','1',2819084.44,2819084.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','154',4305,'21','2',1793179.45,1794492.81,1313.36,1063821.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','154',4306,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','154',4307,'23','2',2303332.80,2304389.96,1057.16,856299.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','154',4308,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','154',4309,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','154',4310,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','154',4311,'27','3',462177.43,462512.59,335.16,284886.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','154',4312,'28','3',958179.40,958738.70,559.30,475405.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4313,'1','1',2263142.56,2263142.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4314,'2','1',4288285.76,4288285.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4315,'3','1',2096321.20,2096321.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4316,'4','1',2394794.68,2394794.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4317,'5','1',2213827.06,2213827.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4318,'6','1',1950099.18,1950099.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4319,'7','1',2016215.92,2016215.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4320,'8','1',2737674.24,2737674.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4321,'9','1',2388495.39,2388495.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','155',4322,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4323,'11','1',3300376.29,3300376.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4324,'12','1',3765896.04,3765896.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4325,'13','1',2096961.73,2096961.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4326,'14','1',3572902.22,3572902.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4327,'15','1',2932262.74,2932262.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4328,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4329,'17','1',2770051.63,2770051.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4330,'18','1',2711380.96,2711380.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4331,'19','1',2828480.44,2828480.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','155',4332,'20','1',2819084.44,2819084.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','155',4333,'21','2',1794492.81,1796692.29,2199.48,1781578.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','155',4334,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','155',4335,'23','2',2304389.96,2306389.03,1999.07,1619246.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','155',4336,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','155',4337,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','155',4338,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','155',4339,'27','3',462512.59,462512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','155',4340,'28','3',958738.70,959664.93,926.23,787295.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4341,'1','1',2263142.56,2266632.97,3490.41,610821.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4342,'2','1',4288285.76,4289353.14,1067.38,186791.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4343,'3','1',2096321.20,2099117.92,2796.72,489426.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4344,'4','1',2394794.68,2395289.08,494.40,86520.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4345,'5','1',2213827.06,2215682.54,1855.48,324709.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4346,'6','1',1950099.18,1952452.06,2352.88,411754.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4347,'7','1',2016215.92,2017934.12,1718.20,300685.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4348,'8','1',2737674.24,2740223.69,2549.45,446153.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4349,'9','1',2388495.39,2391546.19,3050.80,533890.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','156',4350,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4351,'11','1',3300376.29,3302609.87,2233.58,390876.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4352,'12','1',3765896.04,3768904.94,3008.90,526557.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4353,'13','1',2096961.73,2099184.37,2222.64,388962.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4354,'14','1',3572902.22,3575255.22,2353.00,411775.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4355,'15','1',2932262.74,2933829.73,1566.99,274223.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4356,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4357,'17','1',2770051.63,2772521.19,2469.56,432173.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4358,'18','1',2711380.96,2713705.94,2324.98,406871.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4359,'19','1',2828480.44,2830967.17,2486.73,435177.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','156',4360,'20','1',2819084.44,2821372.33,2287.89,400380.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','156',4361,'21','2',1796692.29,1798493.54,1801.25,1459012.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','156',4362,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','156',4363,'23','2',2306389.03,2307616.95,1227.92,994615.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','156',4364,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','156',4365,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','156',4366,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','156',4367,'27','3',462512.59,462824.72,312.13,268431.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','156',4368,'28','3',959664.93,959892.26,227.33,195503.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4369,'1','1',2266632.97,2268435.39,1802.42,315423.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4370,'2','1',4289353.14,4291532.88,2179.74,381454.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4371,'3','1',2099117.92,2100841.47,1723.55,301621.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4372,'4','1',2395289.08,2397035.80,1746.72,305676.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4373,'5','1',2215682.54,2217123.63,1441.09,252190.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4374,'6','1',1952452.06,1954287.85,1835.79,321263.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4375,'7','1',2017934.12,2019731.18,1797.06,314485.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4376,'8','1',2740223.69,2740604.51,380.82,66643.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4377,'9','1',2391546.19,2393676.95,2130.76,372883.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','157',4378,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4379,'11','1',3302609.87,3304392.39,1782.52,311941.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4380,'12','1',3768904.94,3770847.44,1942.50,339937.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4381,'13','1',2099184.37,2100168.59,984.22,172238.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4382,'14','1',3575255.22,3576752.32,1497.10,261992.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4383,'15','1',2933829.73,2933829.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4384,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4385,'17','1',2772521.19,2774303.78,1782.59,311953.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4386,'18','1',2713705.94,2715427.42,1721.48,301259.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4387,'19','1',2830967.17,2833019.84,2052.67,359217.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','157',4388,'20','1',2821372.33,2823037.97,1665.64,291487.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','157',4389,'21','2',1798493.54,1800480.55,1987.01,1589608.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','157',4390,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','157',4391,'23','2',2307616.95,2309856.55,2239.60,1791680.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','157',4392,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','157',4393,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','157',4394,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','157',4395,'27','3',462824.72,463386.10,561.38,482786.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','157',4396,'28','3',959892.26,960125.05,232.79,200199.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4397,'1','1',2268435.39,2271466.25,3030.86,530400.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4398,'2','1',4291532.88,4296578.02,5045.14,882899.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4399,'3','1',2100841.47,2103919.80,3078.33,538707.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4400,'4','1',2397035.80,2399923.35,2887.55,505321.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4401,'5','1',2217123.63,2219771.71,2648.08,463414.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4402,'6','1',1954287.85,1957767.45,3479.60,608930.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4403,'7','1',2019731.18,2022485.35,2754.17,481979.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4404,'8','1',2740604.51,2743377.86,2773.35,485336.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4405,'9','1',2393676.95,2397604.22,3927.27,687272.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','158',4406,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4407,'11','1',3304392.39,3307929.36,3536.97,618969.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4408,'12','1',3770847.44,3775143.09,4295.65,751738.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4409,'13','1',2100168.59,2100514.42,345.83,60520.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4410,'14','1',3576752.32,3576870.41,118.09,20665.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4411,'15','1',2933829.73,2937121.96,3292.23,576140.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4412,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4413,'17','1',2774303.78,2777870.01,3566.23,624090.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4414,'18','1',2715427.42,2719830.38,4402.96,770518.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4415,'19','1',2833019.84,2836693.94,3674.10,642967.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','158',4416,'20','1',2823037.97,2826942.17,3904.20,683235.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','158',4417,'21','2',1800480.55,1801941.21,1460.66,1168528.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','158',4418,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','158',4419,'23','2',2309856.55,2311132.54,1275.99,1020792.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','158',4420,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','158',4421,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','158',4422,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','158',4423,'27','3',463386.10,463682.11,296.01,254568.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','158',4424,'28','3',960125.05,960389.24,264.19,227203.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4425,'1','1',2271466.25,2274763.42,3297.17,577004.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4426,'2','1',4296578.02,4301542.84,4964.82,868843.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4427,'3','1',2103919.80,2107329.83,3410.03,596755.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4428,'4','1',2399923.35,2403593.12,3669.77,642209.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4429,'5','1',2219771.71,2222534.29,2762.58,483451.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4430,'6','1',1957767.45,1961756.92,3989.47,698157.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4431,'7','1',2022485.35,2025908.18,3422.83,598995.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4432,'8','1',2743377.86,2747533.94,4156.08,727314.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4433,'9','1',2397604.22,2401948.80,4344.58,760301.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','159',4434,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4435,'11','1',3307929.36,3310499.93,2570.57,449849.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4436,'12','1',3775143.09,3778313.57,3170.48,554834.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4437,'13','1',2100514.42,2100514.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4438,'14','1',3576870.41,3576870.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4439,'15','1',2937121.96,2940755.56,3633.60,635880.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4440,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4441,'17','1',2777870.01,2780753.90,2883.89,504680.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4442,'18','1',2719830.38,2722299.75,2469.37,432139.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4443,'19','1',2836693.94,2839359.67,2665.73,466502.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','159',4444,'20','1',2826942.17,2829519.29,2577.12,450996.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','159',4445,'21','2',1801941.21,1804050.20,2108.99,1687192.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','159',4446,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','159',4447,'23','2',2311132.54,2312542.87,1410.33,1128264.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','159',4448,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','159',4449,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','159',4450,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','159',4451,'27','3',463682.11,464658.63,976.52,839807.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','159',4452,'28','3',960389.24,960399.45,10.21,8780.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4453,'1','1',2274763.42,2275665.47,902.05,157858.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4454,'2','1',4301542.84,4302529.05,986.21,172586.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4455,'3','1',2107329.83,2108282.12,952.29,166650.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4456,'4','1',2403593.12,2404555.91,962.79,168488.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4457,'5','1',2222534.29,2223176.29,642.00,112350.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4458,'6','1',1961756.92,1962516.26,759.34,132884.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4459,'7','1',2025908.18,2026489.40,581.22,101713.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4460,'8','1',2747533.94,2748230.32,696.38,121866.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4461,'9','1',2401948.80,2402349.12,400.32,70056.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','160',4462,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4463,'11','1',3310499.93,3311370.27,870.34,152309.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4464,'12','1',3778313.57,3779812.56,1498.99,262323.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4465,'13','1',2100514.42,2100514.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4466,'14','1',3576870.41,3576870.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4467,'15','1',2940755.56,2942308.64,1553.08,271789.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4468,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4469,'17','1',2780753.90,2781887.73,1133.83,198420.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4470,'18','1',2722299.75,2723424.22,1124.47,196782.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4471,'19','1',2839359.67,2840351.36,991.69,173545.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','160',4472,'20','1',2829519.29,2830868.08,1348.79,236038.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','160',4473,'21','2',1804050.20,1804553.29,503.09,402472.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','160',4474,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','160',4475,'23','2',2312542.87,2313191.60,648.73,518984.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','160',4476,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','160',4477,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','160',4478,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','160',4479,'27','3',464658.63,465291.68,633.05,544423.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','160',4480,'28','3',960399.45,960399.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4481,'1','1',2275665.47,2277530.41,1864.94,326364.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4482,'2','1',4302529.05,4305403.19,2874.14,502974.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4483,'3','1',2108282.12,2110454.37,2172.25,380143.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4484,'4','1',2404555.91,2406835.09,2279.18,398856.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4485,'5','1',2223176.29,2224990.61,1814.32,317506.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4486,'6','1',1962516.26,1964665.82,2149.56,376173.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4487,'7','1',2026489.40,2028168.87,1679.47,293907.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4488,'8','1',2748230.32,2750319.63,2089.31,365629.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4489,'9','1',2402349.12,2405152.16,2803.04,490532.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','161',4490,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4491,'11','1',3311370.27,3311370.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4492,'12','1',3779812.56,3779812.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4493,'13','1',2100514.42,2100514.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4494,'14','1',3576870.41,3576870.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4495,'15','1',2942308.64,2942308.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4496,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4497,'17','1',2781887.73,2781887.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4498,'18','1',2723424.22,2723424.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4499,'19','1',2840351.36,2840351.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','161',4500,'20','1',2830868.08,2830868.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','161',4501,'21','2',1804553.29,1807366.43,2813.14,2250512.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','161',4502,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','161',4503,'23','2',2313191.60,2315142.88,1951.28,1561024.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','161',4504,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','161',4505,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','161',4506,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','161',4507,'27','3',465291.68,465878.91,587.23,505017.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','161',4508,'28','3',960399.45,960399.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4509,'1','1',2277530.41,2279682.56,2152.15,376626.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4510,'2','1',4305403.19,4309021.42,3618.23,633190.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4511,'3','1',2110454.37,2112577.13,2122.76,371483.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4512,'4','1',2406835.09,2410253.98,3418.89,598305.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4513,'5','1',2224990.61,2226971.20,1980.59,346603.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4514,'6','1',1964665.82,1967272.24,2606.42,456123.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4515,'7','1',2028168.87,2030277.78,2108.91,369059.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4516,'8','1',2750319.63,2752341.98,2022.35,353911.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4517,'9','1',2405152.16,2407570.10,2417.94,423139.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','162',4518,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4519,'11','1',3311370.27,3313948.57,2578.30,451202.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4520,'12','1',3779812.56,3782899.78,3087.22,540263.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4521,'13','1',2100514.42,2102098.61,1584.19,277233.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4522,'14','1',3576870.41,3576870.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4523,'15','1',2942308.64,2945818.60,3509.96,614243.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4524,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4525,'17','1',2781887.73,2783509.03,1621.30,283727.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4526,'18','1',2723424.22,2725831.07,2406.85,421198.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4527,'19','1',2840351.36,2842477.08,2125.72,372001.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','162',4528,'20','1',2830868.08,2833905.20,3037.12,531496.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','162',4529,'21','2',1807366.43,1809299.97,1933.54,1546832.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','162',4530,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','162',4531,'23','2',2315142.88,2317032.53,1889.65,1511720.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','162',4532,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','162',4533,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','162',4534,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','162',4535,'27','3',465878.91,466365.41,486.50,418390.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','162',4536,'28','3',960399.45,960399.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4537,'1','1',2279682.56,2282412.06,2729.50,477662.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4538,'2','1',4309021.42,4313445.43,4424.01,774201.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4539,'3','1',2112577.13,2115492.61,2915.48,510209.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4540,'4','1',2410253.98,2412326.23,2072.25,362643.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4541,'5','1',2226971.20,2228479.28,1508.08,263914.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4542,'6','1',1967272.24,1970229.92,2957.68,517594.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4543,'7','1',2030277.78,2032144.75,1866.97,326719.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4544,'8','1',2752341.98,2754700.11,2358.13,412672.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4545,'9','1',2407570.10,2410773.46,3203.36,560588.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','163',4546,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4547,'11','1',3313948.57,3317525.93,3577.36,626038.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4548,'12','1',3782899.78,3786819.08,3919.30,685877.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4549,'13','1',2102098.61,2103907.28,1808.67,316517.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4550,'14','1',3576870.41,3578408.66,1538.25,269193.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4551,'15','1',2945818.60,2951161.25,5342.65,934963.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4552,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4553,'17','1',2783509.03,2786603.51,3094.48,541534.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4554,'18','1',2725831.07,2729113.12,3282.05,574358.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4555,'19','1',2842477.08,2845616.47,3139.39,549393.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','163',4556,'20','1',2833905.20,2836837.42,2932.22,513138.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','163',4557,'21','2',1809299.97,1811653.20,2353.23,1882584.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','163',4558,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','163',4559,'23','2',2317032.53,2318900.19,1867.66,1494128.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','163',4560,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','163',4561,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','163',4562,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','163',4563,'27','3',466365.41,467126.25,760.84,654322.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','163',4564,'28','3',960399.45,960400.03,0.58,498.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4565,'1','1',2282412.06,2285211.27,2799.21,489861.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4566,'2','1',4313445.43,4318767.19,5321.76,931308.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4567,'3','1',2115492.61,2118278.18,2785.57,487474.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4568,'4','1',2412326.23,2415778.84,3452.61,604206.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4569,'5','1',2228479.28,2230410.48,1931.20,337960.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4570,'6','1',1970229.92,1973141.58,2911.66,509540.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4571,'7','1',2032144.75,2034254.68,2109.93,369237.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4572,'8','1',2754700.11,2757655.89,2955.78,517261.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4573,'9','1',2410773.46,2413831.37,3057.91,535134.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','164',4574,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4575,'11','1',3317525.93,3321226.34,3700.41,647571.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4576,'12','1',3786819.08,3789088.32,2269.24,397117.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4577,'13','1',2103907.28,2107116.22,3208.94,561564.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4578,'14','1',3578408.66,3581915.49,3506.83,613695.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4579,'15','1',2951161.25,2954691.79,3530.54,617844.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4580,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4581,'17','1',2786603.51,2789809.63,3206.12,561071.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4582,'18','1',2729113.12,2732414.28,3301.16,577703.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4583,'19','1',2845616.47,2849383.81,3767.34,659284.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','164',4584,'20','1',2836837.42,2839750.34,2912.92,509761.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','164',4585,'21','2',1811653.20,1813143.73,1490.53,1192424.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','164',4586,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','164',4587,'23','2',2318900.19,2320622.60,1722.41,1377928.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','164',4588,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','164',4589,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','164',4590,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','164',4591,'27','3',467126.25,467500.94,374.69,322233.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','164',4592,'28','3',960400.03,960400.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4593,'1','1',2285211.27,2289019.73,3808.46,666480.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4594,'2','1',4318767.19,4322942.03,4174.84,730597.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4595,'3','1',2118278.18,2120538.47,2260.29,395550.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4596,'4','1',2415778.84,2419163.18,3384.34,592259.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4597,'5','1',2230410.48,2232617.12,2206.64,386162.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4598,'6','1',1973141.58,1975628.35,2486.77,435184.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4599,'7','1',2034254.68,2036529.36,2274.68,398069.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4600,'8','1',2757655.89,2760754.66,3098.77,542284.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4601,'9','1',2413831.37,2416840.77,3009.40,526645.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','165',4602,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4603,'11','1',3321226.34,3323400.40,2174.06,380460.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4604,'12','1',3789088.32,3792809.19,3720.87,651152.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4605,'13','1',2107116.22,2110085.26,2969.04,519582.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4606,'14','1',3581915.49,3584875.39,2959.90,517982.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4607,'15','1',2954691.79,2957959.64,3267.85,571873.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4608,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4609,'17','1',2789809.63,2792017.37,2207.74,386354.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4610,'18','1',2732414.28,2734815.82,2401.54,420269.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4611,'19','1',2849383.81,2851935.27,2551.46,446505.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','165',4612,'20','1',2839750.34,2841161.30,1410.96,246918.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','165',4613,'21','2',1813143.73,1814886.75,1743.02,1394416.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','165',4614,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','165',4615,'23','2',2320622.60,2322143.33,1520.73,1216584.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','165',4616,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','165',4617,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','165',4618,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','165',4619,'27','3',467500.94,467923.55,422.61,363444.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','165',4620,'28','3',960400.03,960400.12,0.09,77.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4621,'1','1',2289019.73,2289019.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4622,'2','1',4322942.03,4323247.41,305.38,53441.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4623,'3','1',2120538.47,2120648.51,110.04,19257.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4624,'4','1',2419163.18,2419163.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4625,'5','1',2232617.12,2232880.99,263.87,46177.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4626,'6','1',1975628.35,1975628.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4627,'7','1',2036529.36,2036865.40,336.04,58807.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4628,'8','1',2760754.66,2760754.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4629,'9','1',2416840.77,2416937.34,96.57,16899.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','166',4630,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4631,'11','1',3323400.40,3323400.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4632,'12','1',3792809.19,3792809.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4633,'13','1',2110085.26,2110085.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4634,'14','1',3584875.39,3584875.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4635,'15','1',2957959.64,2957959.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4636,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4637,'17','1',2792017.37,2792017.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4638,'18','1',2734815.82,2734815.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4639,'19','1',2851935.27,2851935.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','166',4640,'20','1',2841161.30,2841161.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','166',4641,'21','2',1814886.75,1816507.44,1620.69,1296552.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','166',4642,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','166',4643,'23','2',2322143.33,2323603.57,1460.24,1168192.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','166',4644,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','166',4645,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','166',4646,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','166',4647,'27','3',467923.55,468658.49,734.94,632048.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','166',4648,'28','3',960400.12,960400.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4649,'1','1',2289019.73,2289019.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4650,'2','1',4323247.41,4323247.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4651,'3','1',2120648.51,2120648.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4652,'4','1',2419163.18,2419163.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4653,'5','1',2232880.99,2232880.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4654,'6','1',1975628.35,1975628.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4655,'7','1',2036865.40,2036865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4656,'8','1',2760754.66,2760754.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4657,'9','1',2416937.34,2416937.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','167',4658,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4659,'11','1',3323400.40,3323400.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4660,'12','1',3792809.19,3792809.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4661,'13','1',2110085.26,2110085.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4662,'14','1',3584875.39,3584875.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4663,'15','1',2957959.64,2957959.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4664,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4665,'17','1',2792017.37,2792017.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4666,'18','1',2734815.82,2734815.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4667,'19','1',2851935.27,2851935.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','167',4668,'20','1',2841161.30,2841161.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','167',4669,'21','2',1816507.44,1817047.84,540.40,432320.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','167',4670,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','167',4671,'23','2',2323603.57,2324182.37,578.80,463040.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','167',4672,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','167',4673,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','167',4674,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','167',4675,'27','3',468658.49,469384.95,726.46,624755.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','167',4676,'28','3',960400.12,960400.35,0.23,197.80,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4677,'1','1',2289019.73,2292265.01,3245.28,567924.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4678,'2','1',4323247.41,4327707.23,4459.82,780468.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4679,'3','1',2120648.51,2122618.27,1969.76,344708.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4680,'4','1',2419163.18,2421856.38,2693.20,471310.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4681,'5','1',2232880.99,2234815.98,1934.99,338623.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4682,'6','1',1975628.35,1978097.77,2469.42,432148.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4683,'7','1',2036865.40,2038372.71,1507.31,263779.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4684,'8','1',2760754.66,2762562.40,1807.74,316354.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4685,'9','1',2416937.34,2419591.76,2654.42,464523.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','168',4686,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4687,'11','1',3323400.40,3326640.67,3240.27,567047.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4688,'12','1',3792809.19,3797090.46,4281.27,749222.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4689,'13','1',2110085.26,2111470.99,1385.73,242502.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4690,'14','1',3584875.39,3588998.52,4123.13,721547.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4691,'15','1',2957959.64,2961837.60,3877.96,678643.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4692,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4693,'17','1',2792017.37,2794603.58,2586.21,452586.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4694,'18','1',2734815.82,2738022.00,3206.18,561081.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4695,'19','1',2851935.27,2854958.35,3023.08,529039.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','168',4696,'20','1',2841161.30,2843315.38,2154.08,376964.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','168',4697,'21','2',1817047.84,1818997.10,1949.26,1559408.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','168',4698,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','168',4699,'23','2',2324182.37,2325580.13,1397.76,1118208.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','168',4700,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','168',4701,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','168',4702,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','168',4703,'27','3',469384.95,470375.59,990.64,851950.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','168',4704,'28','3',960400.35,960400.41,0.06,51.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4705,'1','1',2292265.01,2293765.10,1500.09,262515.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4706,'2','1',4327707.23,4332328.20,4620.97,808669.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4707,'3','1',2122618.27,2125072.70,2454.43,429525.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4708,'4','1',2421856.38,2425045.30,3188.92,558061.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4709,'5','1',2234815.98,2236779.90,1963.92,343686.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4710,'6','1',1978097.77,1980971.44,2873.67,502892.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4711,'7','1',2038372.71,2039776.64,1403.93,245687.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4712,'8','1',2762562.40,2765065.30,2502.90,438007.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4713,'9','1',2419591.76,2422488.31,2896.55,506896.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','169',4714,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4715,'11','1',3326640.67,3330343.26,3702.59,647953.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4716,'12','1',3797090.46,3800859.97,3769.51,659664.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4717,'13','1',2111470.99,2114114.67,2643.68,462644.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4718,'14','1',3588998.52,3592473.81,3475.29,608175.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4719,'15','1',2961837.60,2966135.38,4297.78,752111.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4720,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4721,'17','1',2794603.58,2796962.24,2358.66,412765.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4722,'18','1',2738022.00,2741058.21,3036.21,531336.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4723,'19','1',2854958.35,2857285.75,2327.40,407295.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','169',4724,'20','1',2843315.38,2845743.70,2428.32,424956.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','169',4725,'21','2',1818997.10,1820841.88,1844.78,1475824.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','169',4726,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','169',4727,'23','2',2325580.13,2327734.88,2154.75,1723800.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','169',4728,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','169',4729,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','169',4730,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','169',4731,'27','3',470375.59,471130.58,754.99,649291.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','169',4732,'28','3',960400.41,960400.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4733,'1','1',2293765.10,2295258.70,1493.60,261380.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4734,'2','1',4332328.20,4335227.54,2899.34,507384.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4735,'3','1',2125072.70,2125839.35,766.65,134163.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4736,'4','1',2425045.30,2427436.20,2390.90,418407.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4737,'5','1',2236779.90,2238908.48,2128.58,372501.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4738,'6','1',1980971.44,1980971.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4739,'7','1',2039776.64,2041818.21,2041.57,357274.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4740,'8','1',2765065.30,2765065.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4741,'9','1',2422488.31,2424256.93,1768.62,309508.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','170',4742,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4743,'11','1',3330343.26,3332827.03,2483.77,434659.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4744,'12','1',3800859.97,3803875.90,3015.93,527787.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4745,'13','1',2114114.67,2116895.40,2780.73,486627.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4746,'14','1',3592473.81,3595143.13,2669.32,467131.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4747,'15','1',2966135.38,2969975.30,3839.92,671986.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4748,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4749,'17','1',2796962.24,2797535.47,573.23,100315.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4750,'18','1',2741058.21,2743564.17,2505.96,438543.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4751,'19','1',2857285.75,2860336.38,3050.63,533860.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','170',4752,'20','1',2845743.70,2848220.73,2477.03,433480.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','170',4753,'21','2',1820841.88,1822502.49,1660.61,1328488.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','170',4754,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','170',4755,'23','2',2327734.88,2329927.68,2192.80,1754240.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','170',4756,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','170',4757,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','170',4758,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','170',4759,'27','3',471130.58,471757.22,626.64,538910.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','170',4760,'28','3',960400.41,960400.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4761,'1','1',2295258.70,2297753.49,2494.79,436588.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4762,'2','1',4335227.54,4339255.05,4027.51,704814.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4763,'3','1',2125839.35,2128993.07,3153.72,551901.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4764,'4','1',2427436.20,2427692.24,256.04,44807.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4765,'5','1',2238908.48,2240624.25,1715.77,300259.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4766,'6','1',1980971.44,1983585.52,2614.08,457464.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4767,'7','1',2041818.21,2042896.19,1077.98,188646.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4768,'8','1',2765065.30,2767576.57,2511.27,439472.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4769,'9','1',2424256.93,2426194.01,1937.08,338989.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','171',4770,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4771,'11','1',3332827.03,3336801.69,3974.66,695565.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4772,'12','1',3803875.90,3809290.90,5415.00,947625.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4773,'13','1',2116895.40,2121115.27,4219.87,738477.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4774,'14','1',3595143.13,3599340.93,4197.80,734615.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4775,'15','1',2969975.30,2975985.52,5796.47,1014382.25,0.00,0.00,213.75,0.00,0.00),('21','228','2','171',4776,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4777,'17','1',2797535.47,2801759.91,4224.44,739277.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4778,'18','1',2743564.17,2747107.76,3543.59,620128.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4779,'19','1',2860336.38,2864590.67,4254.29,744500.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','171',4780,'20','1',2848220.73,2852449.60,4228.87,740052.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','171',4781,'21','2',1822502.49,1824684.55,2182.06,1745648.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','171',4782,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','171',4783,'23','2',2329927.68,2331695.97,1768.29,1414632.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','171',4784,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','171',4785,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','171',4786,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','171',4787,'27','3',471757.22,472362.24,605.02,520317.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','171',4788,'28','3',960400.41,960400.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4789,'1','1',2297753.49,2299526.26,1772.77,310234.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4790,'2','1',4339255.05,4341267.48,2012.43,352175.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4791,'3','1',2128993.07,2130063.74,1070.67,187367.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4792,'4','1',2427692.24,2429059.44,1367.20,239260.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4793,'5','1',2240624.25,2240885.29,261.04,45682.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4794,'6','1',1983585.52,1984889.40,1303.88,228179.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4795,'7','1',2042896.19,2043765.22,869.03,152080.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4796,'8','1',2767576.57,2768672.74,1096.17,191829.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4797,'9','1',2426194.01,2427300.66,1106.65,193663.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','172',4798,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4799,'11','1',3336801.69,3338976.80,2175.11,380644.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4800,'12','1',3809290.90,3812417.12,3126.22,547088.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4801,'13','1',2121115.27,2123813.62,2698.35,472211.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4802,'14','1',3599340.93,3601806.55,2465.62,431483.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4803,'15','1',2975985.52,2978149.47,2163.95,378691.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4804,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4805,'17','1',2801759.91,2804125.07,2365.16,413903.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4806,'18','1',2747107.76,2748857.92,1750.16,306278.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4807,'19','1',2864590.67,2867442.58,2851.91,499084.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','172',4808,'20','1',2852449.60,2853167.84,718.24,125692.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','172',4809,'21','2',1824684.55,1826904.34,2219.79,1775832.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','172',4810,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','172',4811,'23','2',2331695.97,2332340.58,644.61,515688.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','172',4812,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','172',4813,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','172',4814,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','172',4815,'27','3',472362.24,472826.99,464.75,399685.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','172',4816,'28','3',960400.41,960400.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4817,'1','1',2299526.26,2299526.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4818,'2','1',4341267.48,4341267.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4819,'3','1',2130063.74,2130063.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4820,'4','1',2429059.44,2429059.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4821,'5','1',2240885.29,2240885.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4822,'6','1',1984889.40,1984889.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4823,'7','1',2043765.22,2043765.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4824,'8','1',2768672.74,2768672.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4825,'9','1',2427300.66,2427300.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','173',4826,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4827,'11','1',3338976.80,3338976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4828,'12','1',3812417.12,3812417.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4829,'13','1',2123813.62,2123813.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4830,'14','1',3601806.55,3601806.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4831,'15','1',2978149.47,2978149.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4832,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4833,'17','1',2804125.07,2804125.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4834,'18','1',2748857.92,2748857.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4835,'19','1',2867442.58,2867442.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','173',4836,'20','1',2853167.84,2853167.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','173',4837,'21','2',1826904.34,1826904.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','173',4838,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','173',4839,'23','2',2332340.58,2332340.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','173',4840,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','173',4841,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','173',4842,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','173',4843,'27','3',472826.99,472826.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','173',4844,'28','3',960400.41,960400.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4845,'1','1',2299526.26,2302850.85,3324.59,581803.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4846,'2','1',4341267.48,4345551.82,4284.34,749759.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4847,'3','1',2130063.74,2134713.02,4649.28,813624.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4848,'4','1',2429059.44,2430077.48,1018.04,178157.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4849,'5','1',2240885.29,2244668.99,3783.70,662147.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4850,'6','1',1984889.40,1988389.46,3500.06,612510.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4851,'7','1',2043765.22,2046267.87,2502.65,437963.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4852,'8','1',2768672.74,2772172.89,3500.15,612526.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4853,'9','1',2427300.66,2430752.19,3451.53,604017.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','174',4854,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4855,'11','1',3338976.80,3343395.26,4418.46,773230.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4856,'12','1',3812417.12,3816570.63,4153.51,726864.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4857,'13','1',2123813.62,2128270.52,4456.90,779957.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4858,'14','1',3601806.55,3606011.85,4205.30,735927.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4859,'15','1',2978149.47,2978149.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4860,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4861,'17','1',2804125.07,2809610.12,5485.05,959883.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4862,'18','1',2748857.92,2751685.24,2827.32,494781.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4863,'19','1',2867442.58,2870952.39,3509.81,614216.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','174',4864,'20','1',2853167.84,2857137.78,3969.94,694739.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','174',4865,'21','2',1826904.34,1828812.39,1908.05,1526440.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','174',4866,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','174',4867,'23','2',2332340.58,2338439.64,6099.06,4879248.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','174',4868,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','174',4869,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','174',4870,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','174',4871,'27','3',472826.99,473513.04,686.05,590003.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','174',4872,'28','3',960400.41,960400.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4873,'1','1',2302850.85,2302962.72,111.87,19577.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4874,'2','1',4345551.82,4349589.60,4037.78,706611.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4875,'3','1',2134713.02,2136459.79,1746.77,305684.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4876,'4','1',2430077.48,2433304.87,3227.39,564793.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4877,'5','1',2244668.99,2246950.56,2281.57,399274.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4878,'6','1',1988389.46,1991316.87,2927.41,512296.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4879,'7','1',2046267.87,2047833.38,1565.51,273964.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4880,'8','1',2772172.89,2773797.01,1624.12,284221.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4881,'9','1',2430752.19,2434190.60,3438.41,601721.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','175',4882,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4883,'11','1',3343395.26,3347300.35,3905.09,683390.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4884,'12','1',3816570.63,3821315.20,4744.57,830299.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4885,'13','1',2128270.52,2130381.39,2110.87,369402.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4886,'14','1',3606011.85,3610990.65,4978.80,871290.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4887,'15','1',2978149.47,2979747.81,1598.34,279709.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4888,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4889,'17','1',2809610.12,2813137.79,3527.67,617342.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4890,'18','1',2751685.24,2755746.53,4061.29,710725.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4891,'19','1',2870952.39,2875228.58,4276.19,748333.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','175',4892,'20','1',2857137.78,2858832.05,1694.27,296497.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','175',4893,'21','2',1828812.39,1829728.78,916.39,733112.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','175',4894,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','175',4895,'23','2',2338439.64,2339022.27,582.63,466104.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','175',4896,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','175',4897,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','175',4898,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','175',4899,'27','3',473513.04,474163.56,650.52,559447.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','175',4900,'28','3',960400.41,960400.47,0.06,51.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4901,'1','1',2302962.72,2303651.58,688.86,120550.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4902,'2','1',4349589.60,4352443.39,2853.79,499413.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4903,'3','1',2136459.79,2138628.93,2169.14,379599.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4904,'4','1',2433304.87,2433996.70,691.83,121070.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4905,'5','1',2246950.56,2248631.41,1680.85,294148.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4906,'6','1',1991316.87,1993162.73,1845.86,323025.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4907,'7','1',2047833.38,2049361.73,1528.35,267461.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4908,'8','1',2773797.01,2775138.58,1341.57,234774.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4909,'9','1',2434190.60,2436336.97,2146.37,375614.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','176',4910,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4911,'11','1',3347300.35,3349589.26,2288.91,400559.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4912,'12','1',3821315.20,3825799.47,4484.27,784747.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4913,'13','1',2130381.39,2133508.58,3127.19,547258.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4914,'14','1',3610990.65,3613603.87,2613.22,457313.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4915,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4916,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4917,'17','1',2813137.79,2816053.27,2915.48,510209.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4918,'18','1',2755746.53,2758001.31,2254.78,394586.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4919,'19','1',2875228.58,2877499.43,2270.85,397398.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','176',4920,'20','1',2858832.05,2862458.47,3626.42,634623.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','176',4921,'21','2',1829728.78,1831617.34,1888.56,1510848.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','176',4922,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','176',4923,'23','2',2339022.27,2340106.55,1084.28,867424.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','176',4924,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','176',4925,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','176',4926,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','176',4927,'27','3',474163.56,474730.47,566.91,487542.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','176',4928,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4929,'1','1',2303651.58,2303651.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4930,'2','1',4352443.39,4352443.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4931,'3','1',2138628.93,2138628.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4932,'4','1',2433996.70,2433996.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4933,'5','1',2248631.41,2248631.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4934,'6','1',1993162.73,1993162.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4935,'7','1',2049361.73,2049361.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4936,'8','1',2775138.58,2775138.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4937,'9','1',2436336.97,2436336.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','177',4938,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4939,'11','1',3349589.26,3349589.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4940,'12','1',3825799.47,3825799.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4941,'13','1',2133508.58,2133508.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4942,'14','1',3613603.87,3613603.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4943,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4944,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4945,'17','1',2816053.27,2816053.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4946,'18','1',2758001.31,2758001.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4947,'19','1',2877499.43,2877499.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','177',4948,'20','1',2862458.47,2862458.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','177',4949,'21','2',1831617.34,1833271.94,1654.60,1323680.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','177',4950,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','177',4951,'23','2',2340106.55,2341641.96,1535.41,1228328.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','177',4952,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','177',4953,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','177',4954,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','177',4955,'27','3',474730.47,475335.08,604.61,519964.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','177',4956,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4957,'1','1',2303651.58,2305508.53,1856.95,324966.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4958,'2','1',4352443.39,4357600.31,5156.92,902461.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4959,'3','1',2138628.93,2141391.04,2762.11,483369.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4960,'4','1',2433996.70,2437932.70,3936.00,688800.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4961,'5','1',2248631.41,2250928.43,2297.02,401978.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4962,'6','1',1993162.73,1996929.89,3767.16,659253.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4963,'7','1',2049361.73,2052271.36,2909.63,509185.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4964,'8','1',2775138.58,2778624.21,3485.63,609985.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4965,'9','1',2436336.97,2440584.21,4247.24,743267.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','178',4966,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4967,'11','1',3349589.26,3353587.00,3997.74,699604.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4968,'12','1',3825799.47,3830344.51,4545.04,795382.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4969,'13','1',2133508.58,2139005.02,5496.44,961877.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4970,'14','1',3613603.87,3617074.96,3471.09,607440.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4971,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4972,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4973,'17','1',2816053.27,2820818.74,4765.47,833957.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4974,'18','1',2758001.31,2762316.64,4315.33,755182.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4975,'19','1',2877499.43,2882322.03,4822.60,843955.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','178',4976,'20','1',2862458.47,2867763.24,5304.77,928334.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','178',4977,'21','2',1833271.94,1835730.39,2458.45,1966760.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','178',4978,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','178',4979,'23','2',2341641.96,2343303.97,1662.01,1329608.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','178',4980,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','178',4981,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','178',4982,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','178',4983,'27','3',475335.08,476305.35,970.27,834432.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','178',4984,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4985,'1','1',2305508.53,2308867.24,3358.71,587774.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4986,'2','1',4357600.31,4363939.51,6339.20,1109360.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4987,'3','1',2141391.04,2143739.94,2348.90,411057.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4988,'4','1',2437932.70,2441305.14,3372.44,590177.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4989,'5','1',2250928.43,2253744.26,2815.83,492770.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4990,'6','1',1996929.89,2000514.08,3584.19,627233.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4991,'7','1',2052271.36,2055671.24,3399.88,594979.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4992,'8','1',2778624.21,2782943.25,4319.04,755832.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4993,'9','1',2440584.21,2444905.14,4320.93,756162.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','179',4994,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',4995,'11','1',3353587.00,3357259.31,3672.31,642654.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',4996,'12','1',3830344.51,3834124.22,3779.71,661449.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',4997,'13','1',2139005.02,2142350.02,3345.00,585375.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',4998,'14','1',3617074.96,3621312.41,4237.45,741553.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',4999,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',5000,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',5001,'17','1',2820818.74,2824145.29,3326.55,582146.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',5002,'18','1',2762316.64,2765877.46,3560.82,623143.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',5003,'19','1',2882322.03,2885403.96,3081.93,539337.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','179',5004,'20','1',2867763.24,2871679.44,3916.20,685335.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','179',5005,'21','2',1835730.39,1837402.19,1671.80,1337440.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','179',5006,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','179',5007,'23','2',2343303.97,2345950.40,2646.43,2117144.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','179',5008,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','179',5009,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','179',5010,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','179',5011,'27','3',476305.35,476911.45,606.10,521246.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','179',5012,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5013,'1','1',2308867.24,2312050.06,3182.82,556993.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5014,'2','1',4363939.51,4369846.76,5907.25,1033768.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5015,'3','1',2143739.94,2146766.60,3026.66,529665.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5016,'4','1',2441305.14,2444898.07,3592.93,628762.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5017,'5','1',2253744.26,2255732.32,1988.06,347910.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5018,'6','1',2000514.08,2003798.49,3284.41,574771.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5019,'7','1',2055671.24,2059428.43,3757.19,657508.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5020,'8','1',2782943.25,2785610.15,2666.90,466707.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5021,'9','1',2444905.14,2449174.70,4269.56,747173.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','180',5022,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5023,'11','1',3357259.31,3361058.01,3798.70,664772.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5024,'12','1',3834124.22,3839443.75,5319.53,930917.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5025,'13','1',2142350.02,2146505.53,4155.51,727214.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5026,'14','1',3621312.41,3626427.51,5115.10,895142.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5027,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5028,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5029,'17','1',2824145.29,2826464.11,2318.82,405793.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5030,'18','1',2765877.46,2770496.81,4619.35,808386.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5031,'19','1',2885403.96,2889697.84,4293.88,751429.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','180',5032,'20','1',2871679.44,2875235.54,3556.10,622317.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','180',5033,'21','2',1837402.19,1839188.31,1786.12,1428896.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','180',5034,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','180',5035,'23','2',2345950.40,2346491.75,541.35,433080.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','180',5036,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','180',5037,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','180',5038,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','180',5039,'27','3',476911.45,477385.45,474.00,407640.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','180',5040,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5041,'1','1',2312050.06,2314493.39,2443.33,427582.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5042,'2','1',4369846.76,4374445.37,4598.61,804756.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5043,'3','1',2146766.60,2149492.74,2726.14,477074.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5044,'4','1',2444898.07,2448775.39,3877.32,678531.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5045,'5','1',2255732.32,2256819.10,1086.78,190186.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5046,'6','1',2003798.49,2007547.25,3748.76,656033.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5047,'7','1',2059428.43,2062907.31,3478.88,608804.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5048,'8','1',2785610.15,2787934.24,2324.09,406715.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5049,'9','1',2449174.70,2453405.16,4230.46,740330.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','181',5050,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5051,'11','1',3361058.01,3365322.20,4264.19,746233.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5052,'12','1',3839443.75,3843060.76,3617.01,632976.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5053,'13','1',2146505.53,2149799.99,3294.46,576530.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5054,'14','1',3626427.51,3631161.53,4734.02,828453.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5055,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5056,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5057,'17','1',2826464.11,2830443.39,3979.28,696374.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5058,'18','1',2770496.81,2774009.57,3512.76,614733.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5059,'19','1',2889697.84,2892849.99,3152.15,551626.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','181',5060,'20','1',2875235.54,2878466.46,3230.92,565411.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','181',5061,'21','2',1839188.31,1840641.55,1453.24,1162592.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','181',5062,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','181',5063,'23','2',2346491.75,2348393.03,1901.28,1521024.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','181',5064,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','181',5065,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','181',5066,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','181',5067,'27','3',477385.45,478030.30,644.85,554571.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','181',5068,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5069,'1','1',2314493.39,2315603.89,1110.50,194337.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5070,'2','1',4374445.37,4380192.28,5746.91,1005709.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5071,'3','1',2149492.74,2151763.44,2270.70,397372.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5072,'4','1',2448775.39,2452942.88,4167.49,729310.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5073,'5','1',2256819.10,2259137.52,2318.42,405723.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5074,'6','1',2007547.25,2010288.68,2741.43,479750.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5075,'7','1',2062907.31,2065472.06,2564.75,448831.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5076,'8','1',2787934.24,2791964.26,4030.02,705253.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5077,'9','1',2453405.16,2457510.02,4104.86,718350.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','182',5078,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5079,'11','1',3365322.20,3369423.35,4101.15,717701.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5080,'12','1',3843060.76,3847855.82,4795.06,839135.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5081,'13','1',2149799.99,2154116.34,4316.35,755361.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5082,'14','1',3631161.53,3635967.20,4805.67,840992.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5083,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5084,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5085,'17','1',2830443.39,2832619.51,2176.12,380821.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5086,'18','1',2774009.57,2778951.50,4941.93,864837.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5087,'19','1',2892849.99,2897186.03,4336.04,758807.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','182',5088,'20','1',2878466.46,2882310.64,3844.18,672731.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','182',5089,'21','2',1840641.55,1841944.82,1303.27,1042616.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','182',5090,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','182',5091,'23','2',2348393.03,2348777.82,384.79,307832.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','182',5092,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','182',5093,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','182',5094,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','182',5095,'27','3',478030.30,478554.20,523.90,450554.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','182',5096,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5097,'1','1',2315603.89,2317819.67,2215.78,387761.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5098,'2','1',4380192.28,4384581.23,4388.95,768066.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5099,'3','1',2151763.44,2155487.09,3723.65,651638.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5100,'4','1',2452942.88,2454706.74,1763.86,308675.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5101,'5','1',2259137.52,2259732.29,594.77,104084.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5102,'6','1',2010288.68,2013388.82,3100.14,542524.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5103,'7','1',2065472.06,2068269.25,2797.19,489508.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5104,'8','1',2791964.26,2795444.20,3479.94,608989.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5105,'9','1',2457510.02,2461661.17,4151.15,726451.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','183',5106,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5107,'11','1',3369423.35,3374107.17,4683.82,819668.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5108,'12','1',3847855.82,3851827.07,3971.25,694968.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5109,'13','1',2154116.34,2158370.21,4253.87,744427.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5110,'14','1',3635967.20,3640421.26,4454.06,779460.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5111,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5112,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5113,'17','1',2832619.51,2836199.23,3579.72,626451.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5114,'18','1',2778951.50,2782894.45,3942.95,690016.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5115,'19','1',2897186.03,2901348.74,4162.71,728474.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','183',5116,'20','1',2882310.64,2886471.21,4160.57,728099.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','183',5117,'21','2',1841944.82,1844160.09,2215.27,1772216.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','183',5118,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','183',5119,'23','2',2348777.82,2350576.29,1798.47,1438776.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','183',5120,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','183',5121,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','183',5122,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','183',5123,'27','3',478554.20,479286.83,732.63,630061.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','183',5124,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5125,'1','1',2317819.67,2319617.74,1798.07,314662.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5126,'2','1',4384581.23,4388169.42,3588.19,627933.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5127,'3','1',2155487.09,2157740.44,2253.35,394336.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5128,'4','1',2454706.74,2457551.42,2844.68,497819.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5129,'5','1',2259732.29,2261438.75,1706.46,298630.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5130,'6','1',2013388.82,2015493.44,2104.62,368308.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5131,'7','1',2068269.25,2070237.64,1968.39,344468.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5132,'8','1',2795444.20,2797498.69,2054.49,359535.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5133,'9','1',2461661.17,2464405.92,2744.75,480331.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','184',5134,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5135,'11','1',3374107.17,3378141.13,4033.96,705943.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5136,'12','1',3851827.07,3856516.57,4689.50,820662.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5137,'13','1',2158370.21,2162090.73,3720.52,651091.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5138,'14','1',3640421.26,3645531.80,5110.54,894344.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5139,'15','1',2979747.81,2979747.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5140,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5141,'17','1',2836199.23,2840000.62,3801.39,665243.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5142,'18','1',2782894.45,2787548.33,4653.88,814429.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5143,'19','1',2901348.74,2905925.45,4576.71,800924.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','184',5144,'20','1',2886471.21,2890546.67,4075.46,713205.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','184',5145,'21','2',1844160.09,1846107.71,1947.62,1558096.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','184',5146,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','184',5147,'23','2',2350576.29,2351493.54,917.25,733800.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','184',5148,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','184',5149,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','184',5150,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','184',5151,'27','3',479286.83,480078.00,791.17,680406.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','184',5152,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','185',5153,'1','1',2319617.74,2321418.22,1790.28,313299.00,0.00,0.00,10.20,0.00,0.00),('21','228','1','185',5154,'2','1',4388169.42,4394429.10,6249.48,1093659.00,0.00,0.00,10.20,0.00,0.00),('21','228','1','185',5155,'3','1',2157740.44,2161042.20,3291.55,576021.25,0.00,0.00,10.21,0.00,0.00),('21','228','1','185',5156,'4','1',2457551.42,2461260.90,3699.28,647374.00,0.00,0.00,10.20,0.00,0.00),('21','228','1','185',5157,'5','1',2261438.75,2264369.39,2920.45,511078.75,0.00,0.00,10.19,0.00,0.00),('21','228','1','185',5158,'6','1',2015493.44,2019098.43,3594.78,629086.50,0.00,0.00,10.21,0.00,0.00),('21','228','1','185',5159,'7','1',2070237.64,2073828.32,3580.47,626582.25,0.00,0.00,10.21,0.00,0.00),('21','228','1','185',5160,'8','1',2797498.69,2801839.03,4330.12,757771.00,0.00,0.00,10.22,0.00,0.00),('21','228','1','185',5161,'9','1',2464405.92,2469907.01,5490.82,960893.50,0.00,0.00,10.27,0.00,0.00),('21','228','1','185',5162,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','185',5163,'11','1',3378141.13,3381363.98,3212.63,562210.25,0.00,0.00,10.22,0.00,0.00),('21','228','2','185',5164,'12','1',3856516.57,3859511.70,2984.92,522361.00,0.00,0.00,10.21,0.00,0.00),('21','228','2','185',5165,'13','1',2162090.73,2165603.03,3502.09,612865.75,0.00,0.00,10.21,0.00,0.00),('21','228','2','185',5166,'14','1',3645531.80,3647970.87,2428.85,425048.75,0.00,0.00,10.22,0.00,0.00),('21','228','2','185',5167,'15','1',2979747.81,2981278.81,1531.00,267925.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','185',5168,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','185',5169,'17','1',2840000.62,2840662.01,651.20,113960.00,0.00,0.00,10.19,0.00,0.00),('21','228','2','185',5170,'18','1',2787548.33,2788888.65,1330.12,232771.00,0.00,0.00,10.20,0.00,0.00),('21','228','2','185',5171,'19','1',2905925.45,2909112.66,3177.01,555976.75,0.00,0.00,10.20,0.00,0.00),('21','228','2','185',5172,'20','1',2890546.67,2894112.82,3555.93,622287.75,0.00,0.00,10.22,0.00,0.00),('21','228','3','185',5173,'21','2',1846107.71,1848048.54,1930.53,1544424.00,0.00,0.00,10.30,0.00,0.00),('21','228','3','185',5174,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','185',5175,'23','2',2351493.54,2353037.39,1533.66,1226928.00,0.00,0.00,10.19,0.00,0.00),('21','228','3','185',5176,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','185',5177,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','185',5178,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','185',5179,'27','3',480078.00,480660.25,582.25,500735.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','185',5180,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5181,'1','1',2321418.22,2323534.69,2116.47,370382.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5182,'2','1',4394429.10,4397877.26,3448.16,603428.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5183,'3','1',2161042.20,2162874.16,1831.96,320593.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5184,'4','1',2461260.90,2463741.28,2480.38,434066.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5185,'5','1',2264369.39,2266468.60,2099.21,367361.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5186,'6','1',2019098.43,2021400.35,2301.92,402836.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5187,'7','1',2073828.32,2075543.54,1715.22,300163.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5188,'8','1',2801839.03,2804320.57,2481.54,434269.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5189,'9','1',2469907.01,2473471.10,3564.09,623715.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','186',5190,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5191,'11','1',3381363.98,3381937.53,573.55,100371.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5192,'12','1',3859511.70,3860396.73,885.03,154880.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5193,'13','1',2165603.03,2166010.97,407.94,71389.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5194,'14','1',3647970.87,3648936.49,965.62,168983.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5195,'15','1',2981278.81,2982264.40,985.59,172478.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5196,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5197,'17','1',2840662.01,2841759.35,1097.34,192034.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5198,'18','1',2788888.65,2788888.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5199,'19','1',2909112.66,2909293.24,180.58,31601.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','186',5200,'20','1',2894112.82,2894878.09,765.27,133922.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','186',5201,'21','2',1848048.54,1849597.26,1548.72,1238976.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','186',5202,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','186',5203,'23','2',2353037.39,2353965.10,927.71,742168.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','186',5204,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','186',5205,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','186',5206,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','186',5207,'27','3',480660.25,481261.29,601.04,516894.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','186',5208,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5209,'1','1',2323534.69,2323534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5210,'2','1',4397877.26,4397877.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5211,'3','1',2162874.16,2162874.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5212,'4','1',2463741.28,2463741.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5213,'5','1',2266468.60,2266468.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5214,'6','1',2021400.35,2021400.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5215,'7','1',2075543.54,2075543.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5216,'8','1',2804320.57,2804320.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5217,'9','1',2473471.10,2473471.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','187',5218,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5219,'11','1',3381937.53,3381937.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5220,'12','1',3860396.73,3860396.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5221,'13','1',2166010.97,2166010.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5222,'14','1',3648936.49,3648936.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5223,'15','1',2982264.40,2982264.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5224,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5225,'17','1',2841759.35,2841759.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5226,'18','1',2788888.65,2788888.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5227,'19','1',2909293.24,2909293.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','187',5228,'20','1',2894878.09,2894878.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','187',5229,'21','2',1849597.26,1851076.47,1479.21,1183368.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','187',5230,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','187',5231,'23','2',2353965.10,2359734.87,5769.77,4615816.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','187',5232,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','187',5233,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','187',5234,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','187',5235,'27','3',481261.29,482345.22,1083.93,932179.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','187',5236,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5237,'1','1',2323534.69,2326673.99,3139.30,549377.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5238,'2','1',4397877.26,4403124.25,5246.99,918223.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5239,'3','1',2162874.16,2165956.77,3082.61,539456.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5240,'4','1',2463741.28,2467866.42,4125.14,721899.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5241,'5','1',2266468.60,2269012.70,2544.10,445217.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5242,'6','1',2021400.35,2025032.49,3632.14,635624.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5243,'7','1',2075543.54,2078915.97,3372.43,590175.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5244,'8','1',2804320.57,2807637.60,3317.03,580480.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5245,'9','1',2473471.10,2478540.47,5069.37,887139.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','188',5246,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5247,'11','1',3381937.53,3387345.36,5407.83,946370.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5248,'12','1',3860396.73,3861592.57,1195.84,209272.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5249,'13','1',2166010.97,2171382.87,5371.90,940082.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5250,'14','1',3648936.49,3651464.27,2527.78,442361.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5251,'15','1',2982264.40,2987219.05,4954.65,867063.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5252,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5253,'17','1',2841759.35,2845760.98,4001.63,700285.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5254,'18','1',2788888.65,2790957.32,2068.67,362017.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5255,'19','1',2909293.24,2914607.26,5314.02,929953.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','188',5256,'20','1',2894878.09,2896920.51,2042.42,357423.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','188',5257,'21','2',1851076.47,1853108.94,2032.47,1625976.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','188',5258,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','188',5259,'23','2',2359734.87,2361161.77,1426.90,1141520.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','188',5260,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','188',5261,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','188',5262,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','188',5263,'27','3',482345.22,483399.55,1054.33,906723.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','188',5264,'28','3',960400.47,960400.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5265,'1','1',2326673.99,2330479.70,3805.71,665999.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5266,'2','1',4403124.25,4407120.95,3996.70,699422.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5267,'3','1',2165956.77,2167940.80,1984.03,347205.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5268,'4','1',2467866.42,2471764.15,3897.73,682102.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5269,'5','1',2269012.70,2272609.31,3596.61,629406.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5270,'6','1',2025032.49,2026964.79,1932.30,338152.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5271,'7','1',2078915.97,2080485.70,1569.73,274702.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5272,'8','1',2807637.60,2811474.19,3836.59,671403.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5273,'9','1',2478540.47,2483090.93,4550.46,796330.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','189',5274,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5275,'11','1',3387345.36,3391424.32,4078.96,713818.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5276,'12','1',3861592.57,3866951.41,5358.84,937797.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5277,'13','1',2171382.87,2176283.74,4900.87,857652.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5278,'14','1',3651464.27,3653807.63,2343.36,410088.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5279,'15','1',2987219.05,2991557.31,4338.26,759195.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5280,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5281,'17','1',2845760.98,2850407.90,4646.92,813211.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5282,'18','1',2790957.32,2791029.94,72.62,12708.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5283,'19','1',2914607.26,2918595.15,3987.89,697880.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','189',5284,'20','1',2896920.51,2900270.58,3350.07,586262.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','189',5285,'21','2',1853108.94,1854514.95,1406.01,1124808.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','189',5286,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','189',5287,'23','2',2361161.77,2362152.65,990.88,792704.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','189',5288,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','189',5289,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','189',5290,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','189',5291,'27','3',483399.55,484047.35,647.80,557108.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','189',5292,'28','3',960400.47,960430.38,29.91,25722.60,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5293,'1','1',2330479.70,2333256.90,2777.20,486010.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5294,'2','1',4407120.95,4412763.06,5642.11,987369.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5295,'3','1',2167940.80,2171009.87,3069.07,537087.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5296,'4','1',2471764.15,2476194.87,4430.72,775376.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5297,'5','1',2272609.31,2275377.31,2768.00,484400.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5298,'6','1',2026964.79,2030614.21,3649.42,638648.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5299,'7','1',2080485.70,2082971.89,2486.19,435083.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5300,'8','1',2811474.19,2815051.71,3577.52,626066.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5301,'9','1',2483090.93,2487036.23,3945.30,690427.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','190',5302,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5303,'11','1',3391424.32,3393909.03,2484.71,434824.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5304,'12','1',3866951.41,3869757.32,2805.91,491034.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5305,'13','1',2176283.74,2178885.58,2601.84,455322.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5306,'14','1',3653807.63,3655963.78,2156.15,377326.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5307,'15','1',2991557.31,2994027.88,2470.57,432349.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5308,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5309,'17','1',2850407.90,2852356.49,1948.59,341003.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5310,'18','1',2791029.94,2792918.19,1888.25,330443.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5311,'19','1',2918595.15,2920966.53,2371.38,414991.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','190',5312,'20','1',2900270.58,2901744.26,1473.68,257894.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','190',5313,'21','2',1854514.95,1856243.66,1728.71,1382968.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','190',5314,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','190',5315,'23','2',2362152.65,2362769.49,616.84,493472.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','190',5316,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','190',5317,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','190',5318,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','190',5319,'27','3',484047.35,484479.62,432.27,371752.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','190',5320,'28','3',960430.38,960458.02,27.64,23770.40,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5321,'1','1',2333256.90,2336326.39,3069.49,537160.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5322,'2','1',4412763.06,4416232.24,3469.18,607106.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5323,'3','1',2171009.87,2173520.19,2510.32,439306.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5324,'4','1',2476194.87,2478798.83,2603.96,455693.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5325,'5','1',2275377.31,2277511.00,2133.69,373395.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5326,'6','1',2030614.21,2033627.48,3013.27,527322.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5327,'7','1',2082971.89,2085375.24,2403.35,420586.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5328,'8','1',2815051.71,2817632.72,2581.01,451676.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5329,'9','1',2487036.23,2490348.98,3312.75,579731.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','191',5330,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5331,'11','1',3393909.03,3394942.36,1033.33,180832.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5332,'12','1',3869757.32,3871412.02,1654.70,289572.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5333,'13','1',2178885.58,2179832.92,947.34,165784.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5334,'14','1',3655963.78,3656777.63,813.85,142423.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5335,'15','1',2994027.88,2995310.87,1282.99,224523.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5336,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5337,'17','1',2852356.49,2853055.60,699.11,122344.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5338,'18','1',2792918.19,2793676.85,758.66,132765.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5339,'19','1',2920966.53,2921938.20,971.67,170042.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','191',5340,'20','1',2901744.26,2902768.23,1023.97,179194.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','191',5341,'21','2',1856243.66,1857923.85,1680.19,1344152.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','191',5342,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','191',5343,'23','2',2362769.49,2364908.27,2138.78,1711024.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','191',5344,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','191',5345,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','191',5346,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','191',5347,'27','3',484479.62,485516.82,1037.20,891992.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','191',5348,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5349,'1','1',2336326.39,2340792.65,4466.26,781595.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5350,'2','1',4416232.24,4420919.68,4687.44,820302.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5351,'3','1',2173520.19,2177094.90,3574.71,625574.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5352,'4','1',2478798.83,2483080.34,4281.51,749264.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5353,'5','1',2277511.00,2280413.11,2902.11,507869.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5354,'6','1',2033627.48,2036803.49,3176.01,555801.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5355,'7','1',2085375.24,2088704.70,3329.46,582655.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5356,'8','1',2817632.72,2821212.20,3579.48,626409.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5357,'9','1',2490348.98,2495642.88,5293.90,926432.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','192',5358,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5359,'11','1',3394942.36,3398144.38,3202.02,560353.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5360,'12','1',3871412.02,3874130.00,2717.98,475646.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5361,'13','1',2179832.92,2182628.27,2795.35,489186.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5362,'14','1',3656777.63,3660089.21,3311.58,579526.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5363,'15','1',2995310.87,2998769.59,3458.72,605276.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5364,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5365,'17','1',2853055.60,2853055.66,0.06,10.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5366,'18','1',2793676.85,2793677.12,0.27,47.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5367,'19','1',2921938.20,2924690.43,2752.23,481640.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','192',5368,'20','1',2902768.23,2906020.45,3252.22,569138.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','192',5369,'21','2',1857923.85,1858959.90,1036.05,828840.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','192',5370,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','192',5371,'23','2',2364908.27,2366281.39,1373.12,1098496.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','192',5372,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','192',5373,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','192',5374,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','192',5375,'27','3',485516.82,486384.29,867.47,746024.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','192',5376,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5377,'1','1',2340792.65,2345022.63,4229.98,740246.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5378,'2','1',4420919.68,4425855.61,4935.93,863787.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5379,'3','1',2177094.90,2180861.46,3766.56,659148.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5380,'4','1',2483080.34,2487595.97,4515.63,790235.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5381,'5','1',2280413.11,2283652.38,3239.27,566872.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5382,'6','1',2036803.49,2039898.69,3095.20,541660.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5383,'7','1',2088704.70,2092231.84,3527.14,617249.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5384,'8','1',2821212.20,2825061.30,3849.10,673592.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5385,'9','1',2495642.88,2500780.66,5137.78,899111.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','193',5386,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5387,'11','1',3398144.38,3400553.28,2408.90,421557.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5388,'12','1',3874130.00,3876716.36,2586.36,452613.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5389,'13','1',2182628.27,2185035.08,2406.81,421191.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5390,'14','1',3660089.21,3662651.75,2562.54,448444.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5391,'15','1',2998769.59,3000951.25,2181.66,381790.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5392,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5393,'17','1',2853055.66,2853905.69,850.03,148755.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5394,'18','1',2793677.12,2794630.33,953.21,166811.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5395,'19','1',2924690.43,2926702.98,2012.55,352196.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','193',5396,'20','1',2906020.45,2908250.60,2230.15,390276.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','193',5397,'21','2',1858959.90,1859852.48,892.58,714064.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','193',5398,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','193',5399,'23','2',2366281.39,2367735.52,1454.13,1163304.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','193',5400,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','193',5401,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','193',5402,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','193',5403,'27','3',486384.29,487192.63,808.34,695172.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','193',5404,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5405,'1','1',2345022.63,2347556.01,2533.38,443341.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5406,'2','1',4425855.61,4428956.63,3101.02,542678.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5407,'3','1',2180861.46,2181639.62,778.16,136178.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5408,'4','1',2487595.97,2490403.99,2808.02,491403.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5409,'5','1',2283652.38,2285315.29,1662.91,291009.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5410,'6','1',2039898.69,2041789.85,1891.16,330953.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5411,'7','1',2092231.84,2093847.09,1615.25,282668.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5412,'8','1',2825061.30,2827487.34,2426.04,424557.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5413,'9','1',2500780.66,2503868.58,3087.92,540386.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','194',5414,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5415,'11','1',3400553.28,3402578.25,2024.97,354369.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5416,'12','1',3876716.36,3879044.69,2328.33,407457.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5417,'13','1',2185035.08,2187299.06,2263.98,396196.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5418,'14','1',3662651.75,3664339.89,1688.14,295424.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5419,'15','1',3000951.25,3003358.40,2407.15,421251.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5420,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5421,'17','1',2853905.69,2855228.14,1322.45,231428.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5422,'18','1',2794630.33,2796471.02,1840.69,322120.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5423,'19','1',2926702.98,2928587.61,1884.63,329810.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','194',5424,'20','1',2908250.60,2910089.89,1839.29,321875.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','194',5425,'21','2',1859852.48,1862208.87,2356.39,1885112.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','194',5426,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','194',5427,'23','2',2367735.52,2368901.43,1165.91,932728.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','194',5428,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','194',5429,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','194',5430,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','194',5431,'27','3',487192.63,487923.50,730.87,628548.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','194',5432,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5433,'1','1',2347556.01,2349711.99,2155.98,377296.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5434,'2','1',4428956.63,4431913.65,2957.02,517478.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5435,'3','1',2181639.62,2183131.79,1492.17,261129.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5436,'4','1',2490403.99,2492820.23,2416.24,422842.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5437,'5','1',2285315.29,2287191.83,1876.54,328394.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5438,'6','1',2041789.85,2043854.76,2064.91,361359.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5439,'7','1',2093847.09,2096001.77,2154.68,377069.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5440,'8','1',2827487.34,2830195.88,2708.54,473994.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5441,'9','1',2503868.58,2506580.73,2712.15,474626.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','195',5442,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5443,'11','1',3402578.25,3403120.95,542.70,94972.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5444,'12','1',3879044.69,3879833.85,789.16,138103.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5445,'13','1',2187299.06,2187735.98,436.92,76461.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5446,'14','1',3664339.89,3665086.96,747.07,130737.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5447,'15','1',3003358.40,3003891.09,532.69,93220.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5448,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5449,'17','1',2855228.14,2855737.94,509.80,89215.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5450,'18','1',2796471.02,2796894.20,423.18,74056.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5451,'19','1',2928587.61,2928851.27,263.66,46140.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','195',5452,'20','1',2910089.89,2910677.68,587.79,102863.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','195',5453,'21','2',1862208.87,1863949.92,1741.05,1392840.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','195',5454,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','195',5455,'23','2',2368901.43,2370477.93,1576.50,1261200.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','195',5456,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','195',5457,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','195',5458,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','195',5459,'27','3',487923.50,488890.92,967.42,831981.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','195',5460,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5461,'1','1',2349711.99,2351352.52,1640.53,287092.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5462,'2','1',4431913.65,4434245.26,2331.61,408031.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5463,'3','1',2183131.79,2184281.11,1149.32,201131.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5464,'4','1',2492820.23,2494591.67,1771.44,310002.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5465,'5','1',2287191.83,2288852.35,1660.52,290591.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5466,'6','1',2043854.76,2045170.53,1315.77,230259.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5467,'7','1',2096001.77,2097341.66,1339.89,234480.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5468,'8','1',2830195.88,2831778.99,1583.11,277044.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5469,'9','1',2506580.73,2508683.51,2102.78,367986.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','196',5470,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5471,'11','1',3403120.95,3404622.07,1501.12,262696.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5472,'12','1',3879833.85,3881697.72,1863.87,326177.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5473,'13','1',2187735.98,2189351.67,1615.69,282745.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5474,'14','1',3665086.96,3667073.77,1986.81,347691.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5475,'15','1',3003891.09,3005752.79,1861.70,325797.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5476,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5477,'17','1',2855737.94,2856955.20,1217.26,213020.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5478,'18','1',2796894.20,2798643.82,1749.62,306183.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5479,'19','1',2928851.27,2930175.19,1323.92,231686.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','196',5480,'20','1',2910677.68,2912603.60,1925.92,337036.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','196',5481,'21','2',1863949.92,1864436.22,486.30,389040.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','196',5482,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','196',5483,'23','2',2370477.93,2371144.57,666.64,533312.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','196',5484,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','196',5485,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','196',5486,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','196',5487,'27','3',488890.92,489603.19,712.27,612552.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','196',5488,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5489,'1','1',2351352.52,2353905.84,2553.32,446831.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5490,'2','1',4434245.26,4438949.04,4703.78,823161.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5491,'3','1',2184281.11,2187323.72,3042.61,532456.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5492,'4','1',2494591.67,2497721.09,3129.42,547648.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5493,'5','1',2288852.35,2291658.71,2806.36,491113.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5494,'6','1',2045170.53,2048396.32,3225.79,564513.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5495,'7','1',2097341.66,2100741.45,3399.79,594963.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5496,'8','1',2831778.99,2835191.78,3412.79,597238.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5497,'9','1',2508683.51,2514266.77,5583.26,977070.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','197',5498,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5499,'11','1',3404622.07,3405003.43,381.36,66738.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5500,'12','1',3881697.72,3882510.32,812.60,142205.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5501,'13','1',2189351.67,2189856.40,504.73,88327.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5502,'14','1',3667073.77,3667898.27,824.50,144287.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5503,'15','1',3005752.79,3006616.22,863.43,151100.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5504,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5505,'17','1',2856955.20,2857517.26,562.06,98360.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5506,'18','1',2798643.82,2799259.28,615.46,107705.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5507,'19','1',2930175.19,2930838.19,663.00,116025.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','197',5508,'20','1',2912603.60,2913341.99,738.39,129218.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','197',5509,'21','2',1864436.22,1865752.93,1316.71,1053368.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','197',5510,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','197',5511,'23','2',2371144.57,2372687.81,1543.24,1234592.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','197',5512,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','197',5513,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','197',5514,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','197',5515,'27','3',489603.19,490529.45,926.26,796583.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','197',5516,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5517,'1','1',2353905.84,2357924.41,4018.57,703249.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5518,'2','1',4438949.04,4443655.64,4706.60,823655.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5519,'3','1',2187323.72,2189739.93,2416.21,422836.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5520,'4','1',2497721.09,2501823.46,4102.37,717914.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5521,'5','1',2291658.71,2294959.17,3300.46,577580.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5522,'6','1',2048396.32,2051283.91,2887.59,505328.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5523,'7','1',2100741.45,2103795.15,3053.70,534397.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5524,'8','1',2835191.78,2839144.81,3953.03,691780.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5525,'9','1',2514266.77,2518684.01,4417.24,773017.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','198',5526,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5527,'11','1',3405003.43,3407214.40,2210.97,386919.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5528,'12','1',3882510.32,3885219.53,2709.21,474111.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5529,'13','1',2189856.40,2191501.11,1644.71,287824.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5530,'14','1',3667898.27,3670031.69,2133.42,373348.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5531,'15','1',3006616.22,3008549.84,1933.62,338383.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5532,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5533,'17','1',2857517.26,2859113.54,1596.28,279349.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5534,'18','1',2799259.28,2800846.41,1587.13,277747.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5535,'19','1',2930838.19,2932484.89,1646.70,288172.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','198',5536,'20','1',2913341.99,2914833.56,1491.57,261024.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','198',5537,'21','2',1865752.93,1867899.21,2146.28,1717024.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','198',5538,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','198',5539,'23','2',2372687.81,2373719.67,1031.86,825488.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','198',5540,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','198',5541,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','198',5542,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','198',5543,'27','3',490529.45,491437.98,908.53,781335.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','198',5544,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5545,'1','1',2357924.41,2360780.04,2855.63,499735.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5546,'2','1',4443655.64,4447546.19,3890.55,680846.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5547,'3','1',2189739.93,2191734.13,1994.20,348985.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5548,'4','1',2501823.46,2504924.97,3101.51,542764.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5549,'5','1',2294959.17,2297356.92,2397.75,419606.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5550,'6','1',2051283.91,2054190.36,2906.45,508628.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5551,'7','1',2103795.15,2106681.08,2885.93,505037.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5552,'8','1',2839144.81,2841941.58,2796.77,489434.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5553,'9','1',2518684.01,2522743.58,4059.57,710424.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','199',5554,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5555,'11','1',3407214.40,3408714.27,1499.87,262477.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5556,'12','1',3885219.53,3887495.26,2275.73,398252.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5557,'13','1',2191501.11,2192162.38,661.27,115722.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5558,'14','1',3670031.69,3672964.82,2933.13,513297.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5559,'15','1',3008549.84,3010771.42,2221.58,388776.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5560,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5561,'17','1',2859113.54,2860976.60,1863.06,326035.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5562,'18','1',2800846.41,2801711.29,864.88,151354.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5563,'19','1',2932484.89,2934412.25,1927.36,337288.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','199',5564,'20','1',2914833.56,2915619.79,786.23,137590.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','199',5565,'21','2',1867899.21,1870126.09,2226.88,1781504.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','199',5566,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','199',5567,'23','2',2373719.67,2375240.68,1521.01,1216808.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','199',5568,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','199',5569,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','199',5570,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','199',5571,'27','3',491437.98,492406.72,968.74,833116.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','199',5572,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5573,'1','1',2360780.04,2364204.27,3424.23,599240.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5574,'2','1',4447546.19,4452409.67,4863.48,851109.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5575,'3','1',2191734.13,2194776.34,3042.21,532386.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5576,'4','1',2504924.97,2508474.97,3550.00,621250.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5577,'5','1',2297356.92,2300466.54,3109.62,544183.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5578,'6','1',2054190.36,2057764.05,3573.69,625395.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5579,'7','1',2106681.08,2109863.02,3181.94,556839.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5580,'8','1',2841941.58,2845412.34,3470.76,607383.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5581,'9','1',2522743.58,2527415.55,4671.97,817594.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','200',5582,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5583,'11','1',3408714.27,3410588.65,1874.38,328016.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5584,'12','1',3887495.26,3888863.38,1368.12,239421.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5585,'13','1',2192162.38,2194215.68,2053.30,359327.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5586,'14','1',3672964.82,3674616.40,1651.58,289026.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5587,'15','1',3010771.42,3012945.02,2173.60,380380.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5588,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5589,'17','1',2860976.60,2863010.34,2033.74,355904.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5590,'18','1',2801711.29,2803398.27,1686.98,295221.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5591,'19','1',2934412.25,2936184.76,1772.51,310189.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','200',5592,'20','1',2915619.79,2917191.75,1571.96,275093.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','200',5593,'21','2',1870126.09,1872124.69,1998.60,1598880.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','200',5594,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','200',5595,'23','2',2375240.68,2377325.76,2085.08,1668064.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','200',5596,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','200',5597,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','200',5598,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','200',5599,'27','3',492406.72,492958.41,551.69,474453.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','200',5600,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5601,'1','1',2364204.27,2367543.37,3339.10,584342.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5602,'2','1',4452409.67,4457883.26,5473.59,957878.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5603,'3','1',2194776.34,2197951.29,3174.95,555616.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5604,'4','1',2508474.97,2512906.47,4431.50,775512.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5605,'5','1',2300466.54,2303018.75,2552.21,446636.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5606,'6','1',2057764.05,2061569.14,3805.09,665890.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5607,'7','1',2109863.02,2112683.52,2820.50,493587.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5608,'8','1',2845412.34,2849334.33,3921.99,686348.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5609,'9','1',2527415.55,2531823.78,4408.23,771440.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','201',5610,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5611,'11','1',3410588.65,3412625.49,2036.84,356447.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5612,'12','1',3888863.38,3890393.33,1529.95,267741.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5613,'13','1',2194215.68,2195666.94,1451.26,253970.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5614,'14','1',3674616.40,3676352.63,1736.23,303840.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5615,'15','1',3012945.02,3014846.94,1901.92,332836.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5616,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5617,'17','1',2863010.34,2864505.57,1495.23,261665.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5618,'18','1',2803398.27,2805070.69,1672.42,292673.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5619,'19','1',2936184.76,2936689.26,504.50,88287.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','201',5620,'20','1',2917191.75,2918665.68,1473.93,257937.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','201',5621,'21','2',1872124.69,1874077.29,1952.60,1562080.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','201',5622,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','201',5623,'23','2',2377325.76,2379665.31,2339.55,1871640.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','201',5624,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','201',5625,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','201',5626,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','201',5627,'27','3',492958.41,493568.12,609.71,524350.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','201',5628,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5629,'1','1',2367543.37,2370549.22,3005.85,526023.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5630,'2','1',4457883.26,4462264.00,4380.74,766629.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5631,'3','1',2197951.29,2199782.63,1831.34,320484.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5632,'4','1',2512906.47,2516443.41,3536.94,618964.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5633,'5','1',2303018.75,2305866.92,2848.17,498429.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5634,'6','1',2061569.14,2064109.11,2539.97,444494.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5635,'7','1',2112683.52,2115922.85,3239.33,566882.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5636,'8','1',2849334.33,2852590.02,3255.69,569745.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5637,'9','1',2531823.78,2536357.19,4533.41,793346.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','202',5638,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5639,'11','1',3412625.49,3414203.81,1578.32,276206.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5640,'12','1',3890393.33,3892640.34,2247.01,393226.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5641,'13','1',2195666.94,2196558.33,891.39,155993.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5642,'14','1',3676352.63,3678637.02,2284.39,399768.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5643,'15','1',3014846.94,3016332.89,1485.95,260041.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5644,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5645,'17','1',2864505.57,2865975.34,1469.77,257209.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5646,'18','1',2805070.69,2806643.71,1573.02,275278.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5647,'19','1',2936689.26,2938073.04,1383.78,242161.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','202',5648,'20','1',2918665.68,2920228.23,1562.55,273446.25,0.00,0.00,0.00,0.00,0.00),('21','228','3','202',5649,'21','2',1874077.29,1875945.00,1867.71,1494168.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','202',5650,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','202',5651,'23','2',2379665.31,2380652.07,986.76,789408.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','202',5652,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','202',5653,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','202',5654,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','202',5655,'27','3',493568.12,494540.65,972.53,836375.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','202',5656,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5657,'1','1',2370549.22,2373441.92,2892.70,506222.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5658,'2','1',4462264.00,4466518.06,4254.06,744460.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5659,'3','1',2199782.63,2202572.34,2789.71,488199.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5660,'4','1',2516443.41,2520085.78,3642.37,637414.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5661,'5','1',2305866.92,2308320.33,2453.41,429346.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5662,'6','1',2064109.11,2067517.13,3408.02,596403.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5663,'7','1',2115922.85,2119025.62,3102.77,542984.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5664,'8','1',2852590.02,2856222.63,3632.61,635706.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5665,'9','1',2536357.19,2541021.28,4664.09,816215.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','203',5666,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5667,'11','1',3414203.81,3416394.79,2190.98,383421.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5668,'12','1',3892640.34,3895280.74,2640.40,462070.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5669,'13','1',2196558.33,2198735.22,2176.89,380955.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5670,'14','1',3678637.02,3680442.87,1805.85,316023.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5671,'15','1',3016332.89,3018040.79,1707.90,298882.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5672,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5673,'17','1',2865975.34,2868328.12,2352.78,411736.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5674,'18','1',2806643.71,2808456.56,1812.85,317248.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5675,'19','1',2938073.04,2940251.96,2178.92,381311.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','203',5676,'20','1',2920228.23,2922446.37,2218.14,388174.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','203',5677,'21','2',1875945.00,1876590.13,645.13,516104.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','203',5678,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','203',5679,'23','2',2380652.07,2380805.46,153.39,122712.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','203',5680,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','203',5681,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','203',5682,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','203',5683,'27','3',494540.65,495319.61,778.96,669905.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','203',5684,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5685,'1','1',2373441.92,2375551.40,2109.48,369159.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5686,'2','1',4466518.06,4468500.92,1982.86,347000.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5687,'3','1',2202572.34,2204727.76,2155.42,377198.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5688,'4','1',2520085.78,2522530.41,2444.63,427810.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5689,'5','1',2308320.33,2310432.49,2112.16,369628.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5690,'6','1',2067517.13,2069818.71,2301.58,402776.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5691,'7','1',2119025.62,2121874.05,2848.43,498475.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5692,'8','1',2856222.63,2858255.60,2032.97,355769.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5693,'9','1',2541021.28,2544465.46,3444.18,602731.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','204',5694,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5695,'11','1',3416394.79,3416734.94,340.15,59526.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5696,'12','1',3895280.74,3896056.16,775.42,135698.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5697,'13','1',2198735.22,2198752.36,17.14,2999.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5698,'14','1',3680442.87,3681163.25,720.38,126066.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5699,'15','1',3018040.79,3018476.31,435.52,76216.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5700,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5701,'17','1',2868328.12,2868887.95,559.83,97970.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5702,'18','1',2808456.56,2808906.25,449.69,78695.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5703,'19','1',2940251.96,2940617.10,365.14,63899.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','204',5704,'20','1',2922446.37,2922924.77,478.40,83720.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','204',5705,'21','2',1876590.13,1879112.13,2522.00,2017600.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','204',5706,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','204',5707,'23','2',2380805.46,2383191.76,2386.30,1909040.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','204',5708,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','204',5709,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','204',5710,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','204',5711,'27','3',495319.61,496077.53,757.92,651811.20,0.00,0.00,0.00,0.00,0.00),('21','228','4','204',5712,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5713,'1','1',2375551.40,2379119.32,3476.00,608300.00,0.00,0.00,91.92,0.00,0.00),('21','228','1','205',5714,'2','1',4468500.92,4471925.15,3424.23,599240.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5715,'3','1',2204727.76,2207736.78,3009.02,526578.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5716,'4','1',2522530.41,2525698.70,3168.29,554450.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5717,'5','1',2310432.49,2313418.16,2985.67,522492.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5718,'6','1',2069818.71,2072698.70,2879.99,503998.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5719,'7','1',2121874.05,2124974.09,3100.04,542507.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5720,'8','1',2858255.60,2861860.63,3605.03,630880.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5721,'9','1',2544465.46,2548842.19,4376.73,765927.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','205',5722,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5723,'11','1',3416734.94,3416734.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5724,'12','1',3896056.16,3896056.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5725,'13','1',2198752.36,2198752.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5726,'14','1',3681163.25,3681163.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5727,'15','1',3018476.31,3018476.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5728,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5729,'17','1',2868887.95,2868887.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5730,'18','1',2808906.25,2808906.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5731,'19','1',2940617.10,2940617.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','205',5732,'20','1',2922924.77,2922924.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','205',5733,'21','2',1879112.13,1881854.98,2742.85,2235422.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','205',5734,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','205',5735,'23','2',2383191.76,2385439.67,2247.91,1832046.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','205',5736,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','205',5737,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','205',5738,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','205',5739,'27','3',496077.53,496848.30,760.57,654090.20,0.00,0.00,10.20,0.00,0.00),('21','228','4','205',5740,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5741,'1','1',2379119.32,2379119.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5742,'2','1',4471925.15,4471925.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5743,'3','1',2207736.78,2207736.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5744,'4','1',2525698.70,2525698.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5745,'5','1',2313418.16,2313418.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5746,'6','1',2072698.70,2072698.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5747,'7','1',2124974.09,2124974.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5748,'8','1',2861860.63,2861860.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5749,'9','1',2548842.19,2548842.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','206',5750,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5751,'11','1',3416734.94,3416734.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5752,'12','1',3896056.16,3896056.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5753,'13','1',2198752.36,2198752.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5754,'14','1',3681163.25,3681163.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5755,'15','1',3018476.31,3018476.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5756,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5757,'17','1',2868887.95,2868887.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5758,'18','1',2808906.25,2808906.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5759,'19','1',2940617.10,2940617.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','206',5760,'20','1',2922924.77,2922924.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','206',5761,'21','2',1881854.98,1884512.57,2657.59,2165935.85,0.00,0.00,0.00,0.00,0.00),('21','228','3','206',5762,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','206',5763,'23','2',2385439.67,2387207.49,1767.82,1440773.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','206',5764,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','206',5765,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','206',5766,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','206',5767,'27','3',496848.30,497532.04,683.74,588016.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','206',5768,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5769,'1','1',2379119.32,2380780.49,1661.17,290704.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5770,'2','1',4471925.15,4474630.25,2705.10,473392.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5771,'3','1',2207736.78,2209814.68,2077.90,363632.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5772,'4','1',2525698.70,2527294.69,1595.99,279298.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5773,'5','1',2313418.16,2315420.75,2002.59,350453.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5774,'6','1',2072698.70,2074280.29,1581.59,276778.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5775,'7','1',2124974.09,2126350.62,1376.53,240892.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5776,'8','1',2861860.63,2864161.39,2300.76,402633.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5777,'9','1',2548842.19,2551945.68,3103.49,543110.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','207',5778,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5779,'11','1',3416734.94,3418110.11,1375.17,240654.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5780,'12','1',3896056.16,3897924.73,1868.57,326999.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5781,'13','1',2198752.36,2200907.24,2154.88,377104.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5782,'14','1',3681163.25,3682857.83,1694.58,296551.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5783,'15','1',3018476.31,3019768.33,1292.02,226103.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5784,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5785,'17','1',2868887.95,2870751.47,1863.52,326116.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5786,'18','1',2808906.25,2810562.67,1656.42,289873.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5787,'19','1',2940617.10,2943418.50,2801.40,490245.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','207',5788,'20','1',2922924.77,2923113.55,188.78,33036.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','207',5789,'21','2',1884512.57,1886989.26,2476.69,2018502.35,0.00,0.00,0.00,0.00,0.00),('21','228','3','207',5790,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','207',5791,'23','2',2387207.49,2390344.92,3137.43,2557005.45,0.00,0.00,0.00,0.00,0.00),('21','228','3','207',5792,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','207',5793,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','207',5794,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','207',5795,'27','3',497532.04,498153.87,621.83,534773.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','207',5796,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5797,'1','1',2380780.49,2382085.17,1304.68,228319.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5798,'2','1',4474630.25,4476969.85,2339.60,409430.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5799,'3','1',2209814.68,2210830.02,1015.34,177684.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5800,'4','1',2527294.69,2528492.81,1198.12,209671.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5801,'5','1',2315420.75,2316302.71,881.96,154343.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5802,'6','1',2074280.29,2075306.56,1026.27,179597.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5803,'7','1',2126350.62,2127570.28,1219.66,213440.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5804,'8','1',2864161.39,2865322.62,1161.23,203215.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5805,'9','1',2551945.68,2553396.55,1450.87,253902.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','208',5806,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5807,'11','1',3418110.11,3418110.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5808,'12','1',3897924.73,3897924.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5809,'13','1',2200907.24,2200907.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5810,'14','1',3682857.83,3682857.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5811,'15','1',3019768.33,3019768.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5812,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5813,'17','1',2870751.47,2870751.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5814,'18','1',2810562.67,2810562.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5815,'19','1',2943418.50,2943418.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','208',5816,'20','1',2923113.55,2923113.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','208',5817,'21','2',1886989.26,1887382.54,393.28,320523.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','208',5818,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','208',5819,'23','2',2390344.92,2392013.81,1668.89,1360145.35,0.00,0.00,0.00,0.00,0.00),('21','228','3','208',5820,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','208',5821,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','208',5822,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','208',5823,'27','3',498153.87,498906.16,752.29,646969.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','208',5824,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5825,'1','1',2382085.17,2383701.76,1616.59,282903.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5826,'2','1',4476969.85,4479890.29,2920.44,511077.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5827,'3','1',2210830.02,2213119.91,2289.89,400730.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5828,'4','1',2528492.81,2530083.10,1590.29,278300.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5829,'5','1',2316302.71,2318502.34,2199.63,384935.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5830,'6','1',2075306.56,2076837.17,1530.61,267856.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5831,'7','1',2127570.28,2129605.54,2035.26,356170.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5832,'8','1',2865322.62,2867184.91,1862.29,325900.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5833,'9','1',2553396.55,2556293.63,2897.08,506989.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','209',5834,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5835,'11','1',3418110.11,3418110.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5836,'12','1',3897924.73,3897924.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5837,'13','1',2200907.24,2200907.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5838,'14','1',3682857.83,3682857.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5839,'15','1',3019768.33,3019768.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5840,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5841,'17','1',2870751.47,2870751.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5842,'18','1',2810562.67,2810562.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5843,'19','1',2943418.50,2943418.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','209',5844,'20','1',2923113.55,2923113.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','209',5845,'21','2',1887382.54,1888996.45,1613.91,1315336.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','209',5846,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','209',5847,'23','2',2392013.81,2392876.31,862.50,702937.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','209',5848,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','209',5849,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','209',5850,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','209',5851,'27','3',498906.16,499464.80,558.64,480430.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','209',5852,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5853,'1','1',2383701.76,2387668.51,3966.75,694181.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5854,'2','1',4479890.29,4483200.14,3309.85,579223.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5855,'3','1',2213119.91,2218943.94,5824.03,1019205.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5856,'4','1',2530083.10,2530211.47,128.37,22464.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5857,'5','1',2318502.34,2321481.72,2979.38,521391.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5858,'6','1',2076837.17,2078918.18,2081.01,364176.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5859,'7','1',2129605.54,2132917.61,3312.07,579612.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5860,'8','1',2867184.91,2869105.01,1920.10,336017.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5861,'9','1',2556293.63,2562034.30,5740.67,1004617.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','210',5862,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5863,'11','1',3418110.11,3423808.72,5698.61,997256.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5864,'12','1',3897924.73,3898183.72,258.99,45323.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5865,'13','1',2200907.24,2203070.27,2163.03,378530.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5866,'14','1',3682857.83,3686779.34,3921.51,686264.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5867,'15','1',3019768.33,3023049.64,3281.31,574229.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5868,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5869,'17','1',2870751.47,2873275.31,2523.84,441672.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5870,'18','1',2810562.67,2814055.47,3492.80,611240.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5871,'19','1',2943418.50,2950883.57,7465.07,1306387.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','210',5872,'20','1',2923113.55,2923351.15,237.60,41580.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','210',5873,'21','2',1888996.45,1889277.39,280.94,228966.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','210',5874,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','210',5875,'23','2',2392876.31,2393964.53,1088.22,886899.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','210',5876,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','210',5877,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','210',5878,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','210',5879,'27','3',499464.80,500199.48,734.68,631824.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','210',5880,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5881,'1','1',2387668.51,2390257.17,2588.66,453015.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5882,'2','1',4483200.14,4485945.33,2745.19,480408.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5883,'3','1',2218943.94,2221148.36,2204.42,385773.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5884,'4','1',2530211.47,2532338.70,2127.23,372265.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5885,'5','1',2321481.72,2323370.61,1888.89,330555.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5886,'6','1',2078918.18,2080885.57,1967.39,344293.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5887,'7','1',2132917.61,2135461.75,2544.14,445224.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5888,'8','1',2869105.01,2871443.90,2338.89,409305.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5889,'9','1',2562034.30,2564828.67,2794.37,489014.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','211',5890,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5891,'11','1',3423808.72,3423808.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5892,'12','1',3898183.72,3898183.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5893,'13','1',2203070.27,2203070.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5894,'14','1',3686779.34,3686779.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5895,'15','1',3023049.64,3023049.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5896,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5897,'17','1',2873275.31,2873275.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5898,'18','1',2814055.47,2814055.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5899,'19','1',2950883.57,2950883.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','211',5900,'20','1',2923351.15,2923351.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','211',5901,'21','2',1889277.39,1891749.19,2471.80,2014517.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','211',5902,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','211',5903,'23','2',2393964.53,2395819.58,1855.05,1511865.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','211',5904,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','211',5905,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','211',5906,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','211',5907,'27','3',500199.48,500914.74,715.26,615123.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','211',5908,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5909,'1','1',2390257.17,2393289.17,3032.00,530600.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5910,'2','1',4485945.33,4490506.16,4560.83,798145.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5911,'3','1',2221148.36,2224222.40,3074.04,537957.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5912,'4','1',2532338.70,2534874.66,2535.96,443793.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5913,'5','1',2323370.61,2326381.07,3010.46,526830.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5914,'6','1',2080885.57,2084183.22,3297.65,577088.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5915,'7','1',2135461.75,2138521.03,3059.28,535374.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5916,'8','1',2871443.90,2874815.60,3371.70,590047.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5917,'9','1',2564828.67,2569058.78,4230.11,740269.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','212',5918,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5919,'11','1',3423808.72,3428285.23,4476.51,783389.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5920,'12','1',3898183.72,3899093.33,909.61,159181.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5921,'13','1',2203070.27,2203070.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5922,'14','1',3686779.34,3689774.25,2994.91,524109.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5923,'15','1',3023049.64,3025046.64,1997.00,349475.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5924,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5925,'17','1',2873275.31,2876054.97,2779.66,486440.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5926,'18','1',2814055.47,2814055.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5927,'19','1',2950883.57,2953999.04,3115.47,545207.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','212',5928,'20','1',2923351.15,2923351.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','212',5929,'21','2',1891749.19,1894922.20,3173.01,2586003.15,0.00,0.00,0.00,0.00,0.00),('21','228','3','212',5930,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','212',5931,'23','2',2395819.58,2396770.51,950.93,775007.95,0.00,0.00,0.00,0.00,0.00),('21','228','3','212',5932,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','212',5933,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','212',5934,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','212',5935,'27','3',500914.74,501457.83,543.09,467057.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','212',5936,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5937,'1','1',2393289.17,2394846.95,1557.78,272611.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5938,'2','1',4490506.16,4495292.32,4786.16,837578.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5939,'3','1',2224222.40,2228715.43,4493.03,786280.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5940,'4','1',2534874.66,2535647.24,772.58,135201.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5941,'5','1',2326381.07,2331367.10,4986.03,872555.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5942,'6','1',2084183.22,2085214.10,1030.88,180404.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5943,'7','1',2138521.03,2143317.94,4796.91,839459.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5944,'8','1',2874815.60,2877078.41,2262.81,395991.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5945,'9','1',2569058.78,2573878.40,4819.62,843433.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','213',5946,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5947,'11','1',3428285.23,3430432.30,2147.07,375737.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5948,'12','1',3899093.33,3901278.16,2184.83,382345.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5949,'13','1',2203070.27,2205796.17,2725.90,477032.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5950,'14','1',3689774.25,3689774.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5951,'15','1',3025046.64,3026697.22,1650.58,288851.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5952,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5953,'17','1',2876054.97,2876054.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5954,'18','1',2814055.47,2816455.39,2399.92,419986.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5955,'19','1',2953999.04,2957338.75,3339.71,584449.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','213',5956,'20','1',2923351.15,2923351.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','213',5957,'21','2',1894922.20,1896180.17,1257.97,1025245.55,0.00,0.00,0.00,0.00,0.00),('21','228','3','213',5958,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','213',5959,'23','2',2396770.51,2398202.44,1431.93,1167022.95,0.00,0.00,0.00,0.00,0.00),('21','228','3','213',5960,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','213',5961,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','213',5962,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','213',5963,'27','3',501457.83,502164.83,707.00,608020.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','213',5964,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5965,'1','1',2394846.95,2399464.93,4617.98,808146.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5966,'2','1',4495292.32,4497614.94,2322.62,406458.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5967,'3','1',2228715.43,2232495.96,3780.53,661592.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5968,'4','1',2535647.24,2537121.93,1474.69,258070.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5969,'5','1',2331367.10,2333750.55,2383.45,417103.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5970,'6','1',2085214.10,2089679.07,4464.97,781369.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5971,'7','1',2143317.94,2147609.93,4291.99,751098.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5972,'8','1',2877078.41,2879445.88,2367.47,414307.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5973,'9','1',2573878.40,2578765.01,4886.61,855156.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','214',5974,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5975,'11','1',3430432.30,3431319.05,886.75,155181.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5976,'12','1',3901278.16,3904281.17,3003.01,525526.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5977,'13','1',2205796.17,2208860.97,3064.80,536340.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5978,'14','1',3689774.25,3689774.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5979,'15','1',3026697.22,3028605.41,1908.19,333933.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5980,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5981,'17','1',2876054.97,2878799.86,2744.89,480355.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5982,'18','1',2816455.39,2816455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5983,'19','1',2957338.75,2961210.24,3871.49,677510.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','214',5984,'20','1',2923351.15,2923351.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','214',5985,'21','2',1896180.17,1896198.88,18.71,15248.65,0.00,0.00,0.00,0.00,0.00),('21','228','3','214',5986,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','214',5987,'23','2',2398202.44,2398202.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','214',5988,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','214',5989,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','214',5990,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','214',5991,'27','3',502164.83,502865.84,701.01,602868.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','214',5992,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',5993,'1','1',2399464.93,2403337.59,3872.66,677715.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',5994,'2','1',4497614.94,4500630.00,3015.06,527635.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',5995,'3','1',2232495.96,2237128.11,4632.15,810626.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',5996,'4','1',2537121.93,2537132.00,10.07,1762.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',5997,'5','1',2333750.55,2337178.87,3428.32,599956.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',5998,'6','1',2089679.07,2093373.86,3694.79,646588.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',5999,'7','1',2147609.93,2151348.43,3738.50,654237.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',6000,'8','1',2879445.88,2881729.51,2283.63,399635.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',6001,'9','1',2578765.01,2583302.53,4537.52,794066.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','215',6002,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6003,'11','1',3431319.05,3432626.80,1307.75,228856.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6004,'12','1',3904281.17,3906166.87,1885.70,329997.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6005,'13','1',2208860.97,2211969.79,3108.82,544043.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6006,'14','1',3689774.25,3689774.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6007,'15','1',3028605.41,3030276.99,1671.58,292526.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6008,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6009,'17','1',2878799.86,2882416.80,3616.94,632964.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6010,'18','1',2816455.39,2816455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6011,'19','1',2961210.24,2965195.69,3985.45,697453.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','215',6012,'20','1',2923351.15,2923375.53,24.38,4266.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','215',6013,'21','2',1896198.88,1896198.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','215',6014,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','215',6015,'23','2',2398202.44,2398202.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','215',6016,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','215',6017,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','215',6018,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','215',6019,'27','3',502865.84,503371.17,505.33,434583.80,0.00,0.00,0.00,0.00,0.00),('21','228','4','215',6020,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6021,'1','1',2403337.59,2406010.53,2672.94,467764.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6022,'2','1',4500630.00,4504366.92,3736.92,653961.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6023,'3','1',2237128.11,2241592.45,4464.34,781259.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6024,'4','1',2537132.00,2537132.48,0.48,84.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6025,'5','1',2337178.87,2340084.79,2905.92,508536.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6026,'6','1',2093373.86,2096663.74,3289.88,575729.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6027,'7','1',2151348.43,2155137.80,3789.37,663139.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6028,'8','1',2881729.51,2886090.69,4361.18,763206.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6029,'9','1',2583302.53,2588277.23,4974.70,870572.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','216',6030,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6031,'11','1',3432626.80,3434888.41,2261.61,395781.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6032,'12','1',3906166.87,3908293.47,2126.60,372155.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6033,'13','1',2211969.79,2214991.44,3021.65,528788.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6034,'14','1',3689774.25,3690170.56,396.31,69354.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6035,'15','1',3030276.99,3031953.98,1676.99,293473.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6036,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6037,'17','1',2882416.80,2882417.23,0.43,75.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6038,'18','1',2816455.39,2819314.98,2859.59,500428.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6039,'19','1',2965195.69,2967769.22,2573.53,450367.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','216',6040,'20','1',2923375.53,2923439.74,64.21,11236.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','216',6041,'21','2',1896198.88,1896867.72,668.84,555137.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','216',6042,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','216',6043,'23','2',2398202.44,2398211.03,8.59,7129.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','216',6044,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','216',6045,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','216',6046,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','216',6047,'27','3',503371.17,504930.27,1559.10,1340826.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','216',6048,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6049,'1','1',2406010.53,2409903.59,3893.06,681285.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6050,'2','1',4504366.92,4506812.48,2445.56,427973.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6051,'3','1',2241592.45,2246601.81,5009.36,876638.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6052,'4','1',2537132.48,2537133.12,0.64,112.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6053,'5','1',2340084.79,2342880.94,2796.15,489326.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6054,'6','1',2096663.74,2100438.91,3775.17,660654.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6055,'7','1',2155137.80,2159579.70,4441.90,777332.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6056,'8','1',2886090.69,2886970.16,879.47,153907.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6057,'9','1',2588277.23,2593623.10,5345.87,935527.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','217',6058,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6059,'11','1',3434888.41,3434888.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6060,'12','1',3908293.47,3911505.67,3212.20,562135.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6061,'13','1',2214991.44,2215210.44,219.00,38325.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6062,'14','1',3690170.56,3693242.97,3072.41,537671.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6063,'15','1',3031953.98,3034152.12,2198.14,384674.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6064,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6065,'17','1',2882417.23,2885628.99,3211.76,562058.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6066,'18','1',2819314.98,2819314.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6067,'19','1',2967769.22,2971696.10,3926.88,687204.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','217',6068,'20','1',2923439.74,2923439.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','217',6069,'21','2',1896867.72,1896867.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','217',6070,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','217',6071,'23','2',2398211.03,2399738.65,1527.62,1267924.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','217',6072,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','217',6073,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','217',6074,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','217',6075,'27','3',504930.27,505654.57,724.30,622898.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','217',6076,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6077,'1','1',2409903.59,2412808.21,2904.62,508308.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6078,'2','1',4506812.48,4511196.77,4384.29,767250.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6079,'3','1',2246601.81,2249810.39,3208.58,561501.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6080,'4','1',2537133.12,2539337.20,2204.08,385714.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6081,'5','1',2342880.94,2345816.18,2935.24,513667.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6082,'6','1',2100438.91,2103864.54,3425.63,599485.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6083,'7','1',2159579.70,2162272.93,2693.23,471315.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6084,'8','1',2886970.16,2890546.22,3576.06,625810.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6085,'9','1',2593623.10,2598029.22,4406.12,771071.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','218',6086,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6087,'11','1',3434888.41,3435165.96,277.55,48571.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6088,'12','1',3911505.67,3911505.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6089,'13','1',2215210.44,2215210.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6090,'14','1',3693242.97,3693242.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6091,'15','1',3034152.12,3034358.08,205.96,36043.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6092,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6093,'17','1',2885628.99,2885628.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6094,'18','1',2819314.98,2819314.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6095,'19','1',2971696.10,2972078.25,382.15,66876.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','218',6096,'20','1',2923439.74,2923439.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','218',6097,'21','2',1896867.72,1898463.17,1595.45,1324223.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','218',6098,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','218',6099,'23','2',2399738.65,2402000.76,2262.11,1877551.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','218',6100,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','218',6101,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','218',6102,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','218',6103,'27','3',505654.57,506576.92,922.35,793221.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','218',6104,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6105,'1','1',2412808.21,2412808.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6106,'2','1',4511196.77,4511196.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6107,'3','1',2249810.39,2249810.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6108,'4','1',2539337.20,2539337.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6109,'5','1',2345816.18,2345816.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6110,'6','1',2103864.54,2103864.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6111,'7','1',2162272.93,2162272.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6112,'8','1',2890546.22,2890546.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6113,'9','1',2598029.22,2598029.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','219',6114,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6115,'11','1',3435165.96,3435165.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6116,'12','1',3911505.67,3911505.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6117,'13','1',2215210.44,2215210.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6118,'14','1',3693242.97,3693242.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6119,'15','1',3034358.08,3034358.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6120,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6121,'17','1',2885628.99,2885628.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6122,'18','1',2819314.98,2819314.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6123,'19','1',2972078.25,2972078.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','219',6124,'20','1',2923439.74,2923439.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','219',6125,'21','2',1898463.17,1898463.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','219',6126,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','219',6127,'23','2',2402000.76,2402000.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','219',6128,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','219',6129,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','219',6130,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','219',6131,'27','3',506576.92,506576.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','219',6132,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6133,'1','1',2412808.21,2415586.08,2777.87,486127.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6134,'2','1',4511196.77,4515581.03,4384.26,767245.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6135,'3','1',2249810.39,2252715.07,2904.68,508319.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6136,'4','1',2539337.20,2541968.43,2631.23,460465.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6137,'5','1',2345816.18,2349234.27,3418.09,598165.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6138,'6','1',2103864.54,2107161.27,3296.73,576927.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6139,'7','1',2162272.93,2164953.12,2680.19,469033.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6140,'8','1',2890546.22,2893902.23,3356.01,587301.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6141,'9','1',2598029.22,2602460.72,4431.50,775512.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','220',6142,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6143,'11','1',3435165.96,3435165.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6144,'12','1',3911505.67,3914068.63,2562.96,448518.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6145,'13','1',2215210.44,2215219.39,8.95,1566.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6146,'14','1',3693242.97,3696000.32,2757.35,482536.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6147,'15','1',3034358.08,3036426.95,2068.87,362052.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6148,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6149,'17','1',2885628.99,2888851.81,3222.82,563993.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6150,'18','1',2819314.98,2819314.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6151,'19','1',2972078.25,2976087.84,4009.59,701678.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','220',6152,'20','1',2923439.74,2923526.15,86.41,15121.75,0.00,0.00,0.00,0.00,0.00),('21','228','3','220',6153,'21','2',1898463.17,1899405.01,941.84,781727.20,0.00,0.00,0.00,0.00,0.00),('21','228','3','220',6154,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','220',6155,'23','2',2402000.76,2404226.35,2225.59,1847239.70,0.00,0.00,0.00,0.00,0.00),('21','228','3','220',6156,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','220',6157,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','220',6158,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','220',6159,'27','3',506576.92,507045.82,468.90,403254.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','220',6160,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6161,'1','1',2415586.08,2417817.53,2231.45,390503.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6162,'2','1',4515581.03,4518037.01,2455.98,429796.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6163,'3','1',2252715.07,2254568.98,1853.91,324434.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6164,'4','1',2541968.43,2543837.67,1869.24,327117.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6165,'5','1',2349234.27,2353224.64,3990.37,698314.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6166,'6','1',2107161.27,2107161.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6167,'7','1',2164953.12,2167771.99,2818.87,493302.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6168,'8','1',2893902.23,2895279.97,1377.74,241104.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6169,'9','1',2602460.72,2605751.68,3290.96,575918.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','221',6170,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6171,'11','1',3435165.96,3436845.58,1679.62,293933.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6172,'12','1',3914068.63,3916479.63,2411.00,421925.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6173,'13','1',2215219.39,2216756.52,1537.13,268997.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6174,'14','1',3696000.32,3698514.87,2514.55,440046.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6175,'15','1',3036426.95,3039202.50,2775.55,485721.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6176,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6177,'17','1',2888851.81,2890724.87,1873.06,327785.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6178,'18','1',2819314.98,2821272.36,1957.38,342541.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6179,'19','1',2976087.84,2981322.61,5234.77,916084.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','221',6180,'20','1',2923526.15,2923549.01,22.86,4000.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','221',6181,'21','2',1899405.01,1901730.08,2325.07,1929808.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','221',6182,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','221',6183,'23','2',2404226.35,2406863.52,2637.17,2188851.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','221',6184,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','221',6185,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','221',6186,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','221',6187,'27','3',507045.82,507928.67,882.85,759251.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','221',6188,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6189,'1','1',2417817.53,2417817.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6190,'2','1',4518037.01,4518037.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6191,'3','1',2254568.98,2254568.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6192,'4','1',2543837.67,2543837.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6193,'5','1',2353224.64,2353224.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6194,'6','1',2107161.27,2107161.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6195,'7','1',2167771.99,2167771.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6196,'8','1',2895279.97,2895279.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6197,'9','1',2605751.68,2605751.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','222',6198,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6199,'11','1',3436845.58,3436845.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6200,'12','1',3916479.63,3916479.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6201,'13','1',2216756.52,2216756.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6202,'14','1',3698514.87,3698514.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6203,'15','1',3039202.50,3039202.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6204,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6205,'17','1',2890724.87,2890724.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6206,'18','1',2821272.36,2821272.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6207,'19','1',2981322.61,2981322.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','222',6208,'20','1',2923549.01,2923549.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','222',6209,'21','2',1901730.08,1903397.81,1667.73,1384215.90,0.00,0.00,0.00,0.00,0.00),('21','228','3','222',6210,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','222',6211,'23','2',2406863.52,2408133.78,1270.26,1054315.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','222',6212,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','222',6213,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','222',6214,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','222',6215,'27','3',507928.67,508371.41,442.74,380756.40,0.00,0.00,0.00,0.00,0.00),('21','228','4','222',6216,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6217,'1','1',2417817.53,2417817.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6218,'2','1',4518037.01,4518037.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6219,'3','1',2254568.98,2254568.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6220,'4','1',2543837.67,2543837.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6221,'5','1',2353224.64,2353224.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6222,'6','1',2107161.27,2107161.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6223,'7','1',2167771.99,2167771.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6224,'8','1',2895279.97,2895279.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6225,'9','1',2605751.68,2605751.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','223',6226,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6227,'11','1',3436845.58,3436845.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6228,'12','1',3916479.63,3916479.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6229,'13','1',2216756.52,2216756.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6230,'14','1',3698514.87,3698514.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6231,'15','1',3039202.50,3039202.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6232,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6233,'17','1',2890724.87,2890724.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6234,'18','1',2821272.36,2821272.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6235,'19','1',2981322.61,2981322.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','223',6236,'20','1',2923549.01,2923549.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','223',6237,'21','2',1903397.81,1904443.98,1046.17,868321.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','223',6238,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','223',6239,'23','2',2408133.78,2409907.29,1773.51,1472013.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','223',6240,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','223',6241,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','223',6242,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','223',6243,'27','3',508371.41,508947.22,575.81,495196.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','223',6244,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6245,'1','1',2417817.53,2420970.69,3153.16,551803.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6246,'2','1',4518037.01,4522786.78,4749.77,831209.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6247,'3','1',2254568.98,2257910.29,3341.31,584729.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6248,'4','1',2543837.67,2546843.41,3005.74,526004.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6249,'5','1',2353224.64,2355771.53,2546.89,445705.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6250,'6','1',2107161.27,2110042.04,2880.77,504134.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6251,'7','1',2167771.99,2170400.98,2628.99,460073.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6252,'8','1',2895279.97,2898484.88,3204.91,560859.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6253,'9','1',2605751.68,2610019.34,4267.66,746840.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','224',6254,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6255,'11','1',3436845.58,3440145.28,3299.70,577447.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6256,'12','1',3916479.63,3917812.55,1332.92,233261.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6257,'13','1',2216756.52,2216768.52,12.00,2100.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6258,'14','1',3698514.87,3702096.72,3581.85,626823.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6259,'15','1',3039202.50,3041572.49,2369.99,414748.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6260,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6261,'17','1',2890724.87,2893915.65,3190.78,558386.50,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6262,'18','1',2821272.36,2822491.52,1219.16,213353.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6263,'19','1',2981322.61,2985912.77,4590.16,803278.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','224',6264,'20','1',2923549.01,2923549.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','224',6265,'21','2',1904443.98,1905863.05,1419.07,1177828.10,0.00,0.00,0.00,0.00,0.00),('21','228','3','224',6266,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','224',6267,'23','2',2409907.29,2411527.75,1620.46,1344981.80,0.00,0.00,0.00,0.00,0.00),('21','228','3','224',6268,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','224',6269,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','224',6270,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','224',6271,'27','3',508947.22,509452.83,505.61,434824.60,0.00,0.00,0.00,0.00,0.00),('21','228','4','224',6272,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6273,'1','1',2420970.69,2420970.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6274,'2','1',4522786.78,4527645.26,4858.48,850234.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6275,'3','1',2257910.29,2262256.60,4346.31,760604.25,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6276,'4','1',2546843.41,2546843.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6277,'5','1',2355771.53,2357471.53,1700.00,297500.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6278,'6','1',2110042.04,2111587.73,1545.69,270495.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6279,'7','1',2170400.98,2172328.88,1927.90,337382.50,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6280,'8','1',2898484.88,2900403.96,1919.08,335839.00,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6281,'9','1',2610019.34,2613777.47,3758.13,657672.75,0.00,0.00,0.00,0.00,0.00),('21','228','1','225',6282,'10','1',1893525.16,1893525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6283,'11','1',3440145.28,3440145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6284,'12','1',3917812.55,3922223.24,4410.69,771870.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6285,'13','1',2216768.52,2216768.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6286,'14','1',3702096.72,3705932.83,3836.11,671319.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6287,'15','1',3041572.49,3044202.52,2630.03,460255.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6288,'16','1',2784691.07,2784691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6289,'17','1',2893915.65,2896098.90,2183.25,382068.75,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6290,'18','1',2822491.52,2824633.12,2141.60,374780.00,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6291,'19','1',2985912.77,2990511.04,4598.27,804697.25,0.00,0.00,0.00,0.00,0.00),('21','228','2','225',6292,'20','1',2923549.01,2923822.11,273.10,47792.50,0.00,0.00,0.00,0.00,0.00),('21','228','3','225',6293,'21','2',1905863.05,1911229.17,5366.12,4453879.60,0.00,0.00,0.00,0.00,0.00),('21','228','3','225',6294,'22','2',2017443.13,2017443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','3','225',6295,'23','2',2411527.75,2412353.06,825.31,685007.30,0.00,0.00,0.00,0.00,0.00),('21','228','3','225',6296,'24','2',1119683.86,1119683.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','225',6297,'25','3',410068.79,410068.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','225',6298,'26','3',69398.84,69398.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','225',6299,'27','3',509452.83,510080.93,628.10,540166.00,0.00,0.00,0.00,0.00,0.00),('21','228','4','225',6300,'28','3',960458.02,960458.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=676 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','228','1','1',165.00,165.00,29909.92,0.00,0.00,0.00,0.00,1),('21','228','1','2',700.00,700.00,5881.54,0.00,0.00,0.00,0.00,2),('21','228','1','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,3),('21','228','2','2',700.00,700.00,4939.21,0.00,0.00,0.00,0.00,4),('21','228','2','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,5),('21','228','2','1',165.00,165.00,44944.35,0.00,0.00,0.00,0.00,6),('21','228','3','2',700.00,700.00,5253.23,0.00,0.00,0.00,0.00,7),('21','228','3','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,8),('21','228','3','1',165.00,165.00,45367.60,0.00,0.00,0.00,0.00,9),('21','228','4','2',700.00,700.00,5504.18,0.00,0.00,0.00,0.00,10),('21','228','4','3',550.00,550.00,1307.02,0.00,0.00,0.00,0.00,11),('21','228','4','1',165.00,165.00,39834.21,0.00,0.00,0.00,0.00,12),('21','228','5','2',700.00,700.00,4944.90,0.00,0.00,0.00,0.00,13),('21','228','5','3',550.00,550.00,2365.82,0.00,0.00,0.00,0.00,14),('21','228','5','1',165.00,165.00,40354.01,0.00,0.00,0.00,0.00,15),('21','228','6','1',165.00,165.00,40502.43,0.00,0.00,0.00,0.00,16),('21','228','6','2',700.00,700.00,4094.38,0.00,0.00,0.00,0.00,17),('21','228','6','3',550.00,550.00,2408.50,0.00,0.00,0.00,0.00,18),('21','228','7','1',165.00,165.00,40080.60,0.00,0.00,0.00,0.00,19),('21','228','7','2',700.00,700.00,1454.68,0.00,0.00,0.00,0.00,20),('21','228','7','3',550.00,550.00,1376.25,0.00,0.00,0.00,0.00,21),('21','228','8','1',165.00,165.00,44971.01,0.00,0.00,0.00,0.00,22),('21','228','8','2',700.00,700.00,4174.82,0.00,0.00,0.00,0.00,23),('21','228','8','3',550.00,550.00,2182.89,0.00,0.00,0.00,0.00,24),('21','228','9','1',165.00,165.00,49718.27,0.00,0.00,0.00,0.00,25),('21','228','9','2',700.00,700.00,4672.02,0.00,0.00,0.00,0.00,26),('21','228','9','3',550.00,550.00,1581.56,0.00,0.00,0.00,0.00,27),('21','228','10','1',165.00,165.00,49792.81,0.00,0.00,0.00,0.00,28),('21','228','10','2',700.00,700.00,6630.57,0.00,0.00,0.00,0.00,29),('21','228','10','3',550.00,550.00,1570.47,0.00,0.00,0.00,0.00,30),('21','228','11','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,31),('21','228','11','2',700.00,700.00,3821.93,0.00,0.00,0.00,0.00,32),('21','228','11','3',550.00,550.00,1300.28,0.00,0.00,0.00,0.00,33),('21','228','12','2',700.00,700.00,2977.69,0.00,0.00,0.00,0.00,34),('21','228','12','3',550.00,550.00,1294.40,0.00,0.00,0.00,0.00,35),('21','228','12','1',165.00,165.00,45063.27,0.00,0.00,0.00,0.00,36),('21','228','13','2',700.00,700.00,3435.26,0.00,0.00,0.00,0.00,37),('21','228','13','3',550.00,550.00,2333.31,0.00,0.00,0.00,0.00,38),('21','228','13','1',165.00,165.00,40312.71,0.00,0.00,0.00,0.00,39),('21','228','14','2',700.00,700.00,1723.33,0.00,0.00,0.00,0.00,40),('21','228','14','3',550.00,550.00,1334.94,0.00,0.00,0.00,0.00,41),('21','228','14','1',165.00,165.00,44880.52,0.00,0.00,0.00,0.00,42),('21','228','15','1',165.00,165.00,45247.55,0.00,0.00,0.00,0.00,43),('21','228','15','2',700.00,700.00,5249.18,0.00,0.00,0.00,0.00,44),('21','228','15','3',550.00,550.00,1276.47,0.00,0.00,0.00,0.00,45),('21','228','16','2',700.00,700.00,4746.92,0.00,0.00,0.00,0.00,46),('21','228','16','3',550.00,550.00,1300.58,0.00,0.00,0.00,0.00,47),('21','228','16','1',165.00,165.00,59576.46,0.00,0.00,0.00,0.00,48),('21','228','17','2',700.00,700.00,13857.87,0.00,0.00,0.00,0.00,49),('21','228','17','3',550.00,550.00,1455.20,0.00,0.00,0.00,0.00,50),('21','228','17','1',165.00,165.00,50140.78,0.00,0.00,0.00,0.00,51),('21','228','18','2',700.00,700.00,13792.84,0.00,0.00,0.00,0.00,52),('21','228','18','3',550.00,550.00,746.32,0.00,0.00,0.00,0.00,53),('21','228','18','1',165.00,165.00,45086.02,0.00,0.00,0.00,0.00,54),('21','228','19','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,55),('21','228','19','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,56),('21','228','19','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,57),('21','228','20','1',165.00,165.00,49935.94,0.00,0.00,0.00,0.00,58),('21','228','20','2',700.00,700.00,4487.50,0.00,0.00,0.00,0.00,59),('21','228','20','3',550.00,550.00,1699.56,0.00,0.00,0.00,0.00,60),('21','228','21','1',165.00,165.00,45205.26,0.00,0.00,0.00,0.00,61),('21','228','21','2',700.00,700.00,5288.48,0.00,0.00,0.00,0.00,62),('21','228','21','3',550.00,550.00,1791.02,0.00,0.00,0.00,0.00,63),('21','228','22','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,64),('21','228','22','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,65),('21','228','22','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,66),('21','228','23','1',165.00,165.00,59891.95,0.00,0.00,0.00,0.00,67),('21','228','23','2',700.00,700.00,2051.79,0.00,0.00,0.00,0.00,68),('21','228','23','3',550.00,550.00,977.08,0.00,0.00,0.00,0.00,69),('21','228','24','1',165.00,165.00,45425.51,0.00,0.00,0.00,0.00,70),('21','228','24','2',700.00,700.00,4542.92,0.00,0.00,0.00,0.00,71),('21','228','24','3',550.00,550.00,1077.28,0.00,0.00,0.00,0.00,72),('21','228','25','1',165.00,165.00,39668.64,0.00,0.00,0.00,0.00,73),('21','228','25','2',700.00,700.00,3521.52,0.00,0.00,0.00,0.00,74),('21','228','25','3',550.00,550.00,1785.03,0.00,0.00,0.00,0.00,75),('21','228','26','1',165.00,165.00,39677.48,0.00,0.00,0.00,0.00,76),('21','228','26','2',700.00,700.00,4552.30,0.00,0.00,0.00,0.00,77),('21','228','26','3',550.00,550.00,890.51,0.00,0.00,0.00,0.00,78),('21','228','27','1',165.00,165.00,49940.27,0.00,0.00,0.00,0.00,79),('21','228','27','2',700.00,700.00,3543.98,0.00,0.00,0.00,0.00,80),('21','228','27','3',550.00,550.00,1460.28,0.00,0.00,0.00,0.00,81),('21','228','28','1',165.00,165.00,45158.40,0.00,0.00,0.00,0.00,82),('21','228','28','2',700.00,700.00,3172.32,0.00,0.00,0.00,0.00,83),('21','228','28','3',550.00,550.00,1399.71,0.00,0.00,0.00,0.00,84),('21','228','29','1',165.00,165.00,45266.15,0.00,0.00,0.00,0.00,85),('21','228','29','2',700.00,700.00,3226.30,0.00,0.00,0.00,0.00,86),('21','228','29','3',550.00,550.00,1479.99,0.00,0.00,0.00,0.00,87),('21','228','30','2',700.00,700.00,1954.60,0.00,0.00,0.00,0.00,88),('21','228','30','3',550.00,550.00,1038.44,0.00,0.00,0.00,0.00,89),('21','228','30','1',165.00,165.00,40129.51,0.00,0.00,0.00,0.00,90),('21','228','31','2',700.00,700.00,3903.30,0.00,0.00,0.00,0.00,91),('21','228','31','3',550.00,550.00,1607.42,0.00,0.00,0.00,0.00,92),('21','228','31','1',165.00,165.00,45158.70,0.00,0.00,0.00,0.00,93),('21','228','32','1',165.00,165.00,58358.34,0.00,0.00,0.00,0.00,94),('21','228','32','2',700.00,700.00,4417.69,0.00,0.00,0.00,0.00,95),('21','228','32','3',550.00,550.00,2002.27,0.00,0.00,0.00,0.00,96),('21','228','33','1',165.00,165.00,64298.13,0.00,0.00,0.00,0.00,97),('21','228','33','2',700.00,700.00,3976.09,0.00,0.00,0.00,0.00,98),('21','228','33','3',550.00,550.00,1324.80,0.00,0.00,0.00,0.00,99),('21','228','34','1',165.00,165.00,42040.44,0.00,0.00,0.00,0.00,100),('21','228','34','2',700.00,700.00,4847.88,0.00,0.00,0.00,0.00,101),('21','228','34','3',550.00,550.00,779.76,0.00,0.00,0.00,0.00,102),('21','228','35','2',700.00,700.00,3015.24,0.00,0.00,0.00,0.00,103),('21','228','35','3',550.00,550.00,1739.81,0.00,0.00,0.00,0.00,104),('21','228','35','1',165.00,165.00,60409.35,0.00,0.00,0.00,0.00,105),('21','228','36','2',700.00,700.00,5820.90,0.00,0.00,0.00,0.00,106),('21','228','36','3',550.00,550.00,1257.38,0.00,0.00,0.00,0.00,107),('21','228','36','1',165.00,165.00,60042.72,0.00,0.00,0.00,0.00,108),('21','228','37','2',700.00,700.00,2655.79,0.00,0.00,0.00,0.00,109),('21','228','37','3',550.00,550.00,2138.06,0.00,0.00,0.00,0.00,110),('21','228','37','1',165.00,165.00,51288.46,0.00,0.00,0.00,0.00,111),('21','228','38','1',165.00,165.00,34422.00,0.00,0.00,0.00,0.00,112),('21','228','38','2',700.00,700.00,4387.67,0.00,0.00,0.00,0.00,113),('21','228','38','3',550.00,550.00,1857.44,0.00,0.00,0.00,0.00,114),('21','228','39','2',700.00,700.00,3730.49,0.00,0.00,0.00,0.00,115),('21','228','39','3',550.00,550.00,2554.02,0.00,0.00,0.00,0.00,116),('21','228','39','1',165.00,165.00,54355.04,0.00,0.00,0.00,0.00,117),('21','228','40','2',700.00,700.00,2226.42,0.00,0.00,0.00,0.00,118),('21','228','40','3',550.00,550.00,1866.51,0.00,0.00,0.00,0.00,119),('21','228','40','1',165.00,165.00,54936.73,0.00,0.00,0.00,0.00,120),('21','228','41','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,121),('21','228','41','3',550.00,550.00,2012.35,0.00,0.00,0.00,0.00,122),('21','228','41','1',165.00,165.00,66953.86,0.00,0.00,0.00,0.00,123),('21','228','42','1',165.00,165.00,75124.91,0.00,0.00,0.00,0.00,124),('21','228','42','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,125),('21','228','42','3',550.00,550.00,2509.77,0.00,0.00,0.00,0.00,126),('21','228','43','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,127),('21','228','43','3',550.00,550.00,3245.24,0.00,0.00,0.00,0.00,128),('21','228','43','1',165.00,165.00,28539.90,0.00,0.00,0.00,0.00,129),('21','228','44','1',165.00,165.00,21974.58,0.00,0.00,0.00,0.00,130),('21','228','44','2',700.00,700.00,1798.08,0.00,0.00,0.00,0.00,131),('21','228','44','3',550.00,550.00,1731.87,0.00,0.00,0.00,0.00,132),('21','228','45','2',700.00,700.00,1621.87,0.00,0.00,0.00,0.00,133),('21','228','45','3',550.00,550.00,3439.20,0.00,0.00,0.00,0.00,134),('21','228','45','1',165.00,165.00,53530.33,0.00,0.00,0.00,0.00,135),('21','228','46','1',165.00,165.00,13850.29,0.00,0.00,0.00,0.00,136),('21','228','46','2',700.00,700.00,2825.00,0.00,0.00,0.00,0.00,137),('21','228','46','3',550.00,550.00,2516.30,0.00,0.00,0.00,0.00,138),('21','228','47','1',165.00,165.00,52463.77,0.00,0.00,0.00,0.00,139),('21','228','47','2',700.00,700.00,3530.39,0.00,0.00,0.00,0.00,140),('21','228','47','3',550.00,550.00,4798.86,0.00,0.00,0.00,0.00,141),('21','228','48','1',165.00,165.00,51850.86,0.00,0.00,0.00,0.00,142),('21','228','48','2',700.00,700.00,4102.44,0.00,0.00,0.00,0.00,143),('21','228','48','3',550.00,550.00,8090.57,0.00,0.00,0.00,0.00,144),('21','228','49','1',165.00,165.00,63710.07,0.00,0.00,0.00,0.00,145),('21','228','49','2',700.00,700.00,2917.04,0.00,0.00,0.00,0.00,146),('21','228','49','3',550.00,550.00,2515.62,0.00,0.00,0.00,0.00,147),('21','228','50','1',165.00,165.00,56068.74,0.00,0.00,0.00,0.00,148),('21','228','50','2',700.00,700.00,3473.68,0.00,0.00,0.00,0.00,149),('21','228','50','3',550.00,650.00,991.94,0.00,0.00,0.00,0.00,150),('21','228','51','1',165.00,165.00,60672.53,0.00,0.00,0.00,0.00,151),('21','228','51','2',700.00,700.00,797.33,0.00,0.00,0.00,0.00,152),('21','228','51','3',550.00,650.00,656.36,0.00,0.00,0.00,0.00,153),('21','228','52','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,154),('21','228','52','2',700.00,700.00,4066.28,0.00,0.00,0.00,0.00,155),('21','228','52','3',550.00,650.00,1086.59,0.00,0.00,0.00,0.00,156),('21','228','53','1',165.00,165.00,45032.98,0.00,0.00,0.00,0.00,157),('21','228','53','2',700.00,700.00,3086.16,0.00,0.00,0.00,0.00,158),('21','228','53','3',550.00,650.00,1310.42,0.00,0.00,0.00,0.00,159),('21','228','54','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,160),('21','228','54','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,161),('21','228','54','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,162),('21','228','55','1',165.00,165.00,44917.97,0.00,0.00,0.00,0.00,163),('21','228','55','2',700.00,700.00,3827.10,0.00,0.00,0.00,0.00,164),('21','228','55','3',650.00,650.00,1649.39,0.00,0.00,0.00,0.00,165),('21','228','56','1',165.00,165.00,25587.55,0.00,0.00,0.00,0.00,166),('21','228','56','2',700.00,700.00,3938.83,0.00,0.00,0.00,0.00,167),('21','228','56','3',650.00,650.00,1210.24,0.00,0.00,0.00,0.00,168),('21','228','57','1',165.00,165.00,60865.47,0.00,0.00,0.00,0.00,169),('21','228','57','2',700.00,700.00,3509.95,0.00,0.00,0.00,0.00,170),('21','228','57','3',650.00,650.00,1639.75,0.00,0.00,0.00,0.00,171),('21','228','58','1',165.00,165.00,54032.94,0.00,0.00,0.00,0.00,172),('21','228','58','2',720.00,720.00,3243.62,0.00,0.00,0.00,0.00,173),('21','228','58','3',650.00,650.00,1829.09,0.00,0.00,0.00,0.00,174),('21','228','59','1',165.00,165.00,69492.36,0.00,0.00,0.00,0.00,175),('21','228','59','2',720.00,720.00,2112.37,0.00,0.00,0.00,0.00,176),('21','228','59','3',650.00,650.00,2473.14,0.00,0.00,0.00,0.00,177),('21','228','60','2',720.00,720.00,3698.77,0.00,0.00,0.00,0.00,178),('21','228','60','3',650.00,650.00,1738.75,0.00,0.00,0.00,0.00,179),('21','228','60','1',165.00,165.00,45901.87,0.00,0.00,0.00,0.00,180),('21','228','61','1',165.00,165.00,79201.32,0.00,0.00,0.00,0.00,181),('21','228','61','2',720.00,720.00,4160.08,0.00,0.00,0.00,0.00,182),('21','228','61','3',650.00,650.00,1693.76,0.00,0.00,0.00,0.00,183),('21','228','62','2',720.00,720.00,4695.39,0.00,0.00,0.00,0.00,184),('21','228','62','3',650.00,650.00,1108.96,0.00,0.00,0.00,0.00,185),('21','228','62','1',165.00,165.00,51492.47,0.00,0.00,0.00,0.00,186),('21','228','63','2',720.00,720.00,4312.12,0.00,0.00,0.00,0.00,187),('21','228','63','3',650.00,650.00,1187.38,0.00,0.00,0.00,0.00,188),('21','228','63','1',165.00,165.00,53040.04,0.00,0.00,0.00,0.00,189),('21','228','64','1',165.00,165.00,36187.83,0.00,0.00,0.00,0.00,190),('21','228','64','2',720.00,720.00,3292.00,0.00,0.00,0.00,0.00,191),('21','228','64','3',650.00,650.00,1152.81,0.00,0.00,0.00,0.00,192),('21','228','65','1',165.00,165.00,46390.58,0.00,0.00,0.00,0.00,193),('21','228','65','2',720.00,720.00,5970.30,0.00,0.00,0.00,0.00,194),('21','228','65','3',650.00,650.00,1180.40,0.00,0.00,0.00,0.00,195),('21','228','66','2',720.00,720.00,2374.76,0.00,0.00,0.00,0.00,196),('21','228','66','3',650.00,650.00,849.28,0.00,0.00,0.00,0.00,197),('21','228','66','1',165.00,165.00,45943.80,0.00,0.00,0.00,0.00,198),('21','228','67','1',165.00,165.00,52622.29,0.00,0.00,0.00,0.00,199),('21','228','67','2',760.00,760.00,4544.46,0.00,0.00,0.00,0.00,200),('21','228','67','3',650.00,650.00,1658.34,0.00,0.00,0.00,0.00,201),('21','228','68','1',165.00,165.00,45718.64,0.00,0.00,0.00,0.00,202),('21','228','68','2',760.00,760.00,2830.97,0.00,0.00,0.00,0.00,203),('21','228','68','3',650.00,650.00,1279.18,0.00,0.00,0.00,0.00,204),('21','228','69','1',165.00,165.00,49032.89,0.00,0.00,0.00,0.00,205),('21','228','69','2',760.00,760.00,2996.64,0.00,0.00,0.00,0.00,206),('21','228','69','3',650.00,650.00,1212.40,0.00,0.00,0.00,0.00,207),('21','228','70','1',165.00,165.00,62366.47,0.00,0.00,0.00,0.00,208),('21','228','70','2',760.00,760.00,4153.17,0.00,0.00,0.00,0.00,209),('21','228','70','3',650.00,650.00,1343.08,0.00,0.00,0.00,0.00,210),('21','228','71','1',165.00,165.00,15118.73,0.00,0.00,0.00,0.00,211),('21','228','71','2',760.00,760.00,6182.69,0.00,0.00,0.00,0.00,212),('21','228','71','3',650.00,650.00,1045.86,0.00,0.00,0.00,0.00,213),('21','228','72','2',760.00,760.00,6776.82,0.00,0.00,0.00,0.00,214),('21','228','72','3',650.00,650.00,1322.92,0.00,0.00,0.00,0.00,215),('21','228','72','1',165.00,165.00,54292.80,0.00,0.00,0.00,0.00,216),('21','228','73','2',760.00,760.00,2928.59,0.00,0.00,0.00,0.00,217),('21','228','73','3',650.00,650.00,1245.60,0.00,0.00,0.00,0.00,218),('21','228','73','1',165.00,165.00,42895.09,0.00,0.00,0.00,0.00,219),('21','228','74','1',165.00,165.00,40209.45,0.00,0.00,0.00,0.00,220),('21','228','74','2',760.00,760.00,5542.89,0.00,0.00,0.00,0.00,221),('21','228','74','3',650.00,650.00,1313.94,0.00,0.00,0.00,0.00,222),('21','228','75','1',165.00,165.00,31317.30,0.00,0.00,0.00,0.00,223),('21','228','75','2',760.00,760.00,4206.31,0.00,0.00,0.00,0.00,224),('21','228','75','3',650.00,650.00,1190.33,0.00,0.00,0.00,0.00,225),('21','228','76','1',165.00,165.00,64567.96,0.00,0.00,0.00,0.00,226),('21','228','76','2',760.00,760.00,3701.42,0.00,0.00,0.00,0.00,227),('21','228','76','3',650.00,650.00,1071.55,0.00,0.00,0.00,0.00,228),('21','228','77','1',165.00,165.00,38239.55,0.00,0.00,0.00,0.00,229),('21','228','77','2',760.00,760.00,4611.08,0.00,0.00,0.00,0.00,230),('21','228','77','3',650.00,650.00,1233.67,0.00,0.00,0.00,0.00,231),('21','228','78','1',165.00,165.00,41069.08,0.00,0.00,0.00,0.00,232),('21','228','78','2',760.00,760.00,4379.63,0.00,0.00,0.00,0.00,233),('21','228','78','3',650.00,650.00,1218.60,0.00,0.00,0.00,0.00,234),('21','228','79','2',780.00,780.00,5275.00,0.00,0.00,0.00,0.00,235),('21','228','79','3',650.00,650.00,2248.72,0.00,0.00,0.00,0.00,236),('21','228','79','1',165.00,165.00,43766.05,0.00,0.00,0.00,0.00,237),('21','228','80','1',165.00,165.00,43424.40,0.00,0.00,0.00,0.00,238),('21','228','80','2',780.00,780.00,2415.12,0.00,0.00,0.00,0.00,239),('21','228','80','3',650.00,650.00,956.69,0.00,0.00,0.00,0.00,240),('21','228','81','2',780.00,780.00,6691.34,0.00,0.00,0.00,0.00,241),('21','228','81','3',650.00,650.00,1303.77,0.00,0.00,0.00,0.00,242),('21','228','81','1',165.00,165.00,22592.14,0.00,0.00,0.00,0.00,243),('21','228','82','1',165.00,165.00,83253.77,0.00,0.00,0.00,0.00,244),('21','228','82','2',780.00,780.00,5727.97,0.00,0.00,0.00,0.00,245),('21','228','82','3',650.00,650.00,2932.75,0.00,0.00,0.00,0.00,246),('21','228','83','2',780.00,780.00,5081.24,0.00,0.00,0.00,0.00,247),('21','228','83','3',650.00,650.00,6042.63,0.00,0.00,0.00,0.00,248),('21','228','83','1',165.00,165.00,25330.20,0.00,0.00,0.00,0.00,249),('21','228','84','2',800.00,800.00,3833.94,0.00,0.00,0.00,0.00,250),('21','228','84','3',700.00,700.00,754.97,0.00,0.00,0.00,0.00,251),('21','228','84','1',165.00,165.00,45587.12,0.00,0.00,0.00,0.00,252),('21','228','85','1',165.00,165.00,45417.15,0.00,0.00,0.00,0.00,253),('21','228','85','2',800.00,800.00,5906.38,0.00,0.00,0.00,0.00,254),('21','228','85','3',700.00,700.00,842.67,0.00,0.00,0.00,0.00,255),('21','228','86','2',820.00,820.00,8051.43,0.00,0.00,0.00,0.00,256),('21','228','86','3',700.00,700.00,1961.00,0.00,0.00,0.00,0.00,257),('21','228','86','1',165.00,165.00,56548.45,0.00,0.00,0.00,0.00,258),('21','228','87','1',165.00,165.00,34647.31,0.00,0.00,0.00,0.00,259),('21','228','87','2',820.00,820.00,1571.80,0.00,0.00,0.00,0.00,260),('21','228','87','3',700.00,700.00,1336.51,0.00,0.00,0.00,0.00,261),('21','228','88','2',820.00,820.00,3854.99,0.00,0.00,0.00,0.00,262),('21','228','88','3',750.00,750.00,1978.31,0.00,0.00,0.00,0.00,263),('21','228','88','1',165.00,165.00,39662.70,0.00,0.00,0.00,0.00,264),('21','228','89','2',820.00,820.00,6875.01,0.00,0.00,0.00,0.00,265),('21','228','89','3',750.00,750.00,1127.79,0.00,0.00,0.00,0.00,266),('21','228','89','1',165.00,165.00,43287.33,0.00,0.00,0.00,0.00,267),('21','228','90','2',820.00,820.00,6280.84,0.00,0.00,0.00,0.00,268),('21','228','90','3',750.00,750.00,1417.11,0.00,0.00,0.00,0.00,269),('21','228','90','1',165.00,165.00,40575.63,0.00,0.00,0.00,0.00,270),('21','228','91','2',820.00,820.00,6038.27,0.00,0.00,0.00,0.00,271),('21','228','91','3',750.00,750.00,1947.55,0.00,0.00,0.00,0.00,272),('21','228','91','1',165.00,165.00,35584.60,0.00,0.00,0.00,0.00,273),('21','228','92','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,274),('21','228','92','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,275),('21','228','92','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,276),('21','228','93','2',830.00,830.00,4881.00,0.00,0.00,0.00,0.00,277),('21','228','93','3',750.00,750.00,1374.51,0.00,0.00,0.00,0.00,278),('21','228','93','1',165.00,165.00,57404.86,0.00,0.00,0.00,0.00,279),('21','228','94','2',830.00,830.00,5374.06,0.00,0.00,0.00,0.00,280),('21','228','94','3',750.00,750.00,1190.16,0.00,0.00,0.00,0.00,281),('21','228','94','1',165.00,165.00,37309.93,0.00,0.00,0.00,0.00,282),('21','228','95','1',165.00,165.00,55817.70,0.00,0.00,0.00,0.00,283),('21','228','95','2',830.00,830.00,2275.59,0.00,0.00,0.00,0.00,284),('21','228','95','3',750.00,750.00,1046.00,0.00,0.00,0.00,0.00,285),('21','228','96','1',165.00,165.00,23218.30,0.00,0.00,0.00,0.00,286),('21','228','96','2',830.00,830.00,6952.34,0.00,0.00,0.00,0.00,287),('21','228','96','3',750.00,750.00,1059.31,0.00,0.00,0.00,0.00,288),('21','228','97','1',165.00,165.00,25598.10,0.00,0.00,0.00,0.00,289),('21','228','97','2',830.00,830.00,4879.12,0.00,0.00,0.00,0.00,290),('21','228','97','3',750.00,750.00,1586.83,0.00,0.00,0.00,0.00,291),('21','228','98','1',165.00,165.00,9147.52,0.00,0.00,0.00,0.00,292),('21','228','98','2',830.00,830.00,4126.09,0.00,0.00,0.00,0.00,293),('21','228','98','3',750.00,750.00,1272.59,0.00,0.00,0.00,0.00,294),('21','228','99','2',830.00,830.00,6230.64,0.00,0.00,0.00,0.00,295),('21','228','99','3',750.00,750.00,1201.02,0.00,0.00,0.00,0.00,296),('21','228','99','1',165.00,165.00,50099.31,0.00,0.00,0.00,0.00,297),('21','228','100','1',165.00,165.00,20846.24,0.00,0.00,0.00,0.00,298),('21','228','100','2',830.00,830.00,3906.69,0.00,0.00,0.00,0.00,299),('21','228','100','3',750.00,750.00,806.88,0.00,0.00,0.00,0.00,300),('21','228','101','1',165.00,165.00,25435.42,0.00,0.00,0.00,0.00,301),('21','228','101','2',830.00,830.00,5766.53,0.00,0.00,0.00,0.00,302),('21','228','101','3',750.00,750.00,1057.35,0.00,0.00,0.00,0.00,303),('21','228','102','2',830.00,830.00,1399.69,0.00,0.00,0.00,0.00,304),('21','228','102','3',750.00,750.00,1058.36,0.00,0.00,0.00,0.00,305),('21','228','102','1',165.00,165.00,22781.72,0.00,0.00,0.00,0.00,306),('21','228','103','2',830.00,830.00,6229.14,0.00,0.00,0.00,0.00,307),('21','228','103','3',750.00,750.00,906.25,0.00,0.00,0.00,0.00,308),('21','228','103','1',165.00,165.00,41637.18,0.00,0.00,0.00,0.00,309),('21','228','104','1',165.00,165.00,6452.13,0.00,0.00,0.00,0.00,310),('21','228','104','2',830.00,830.00,4903.66,0.00,0.00,0.00,0.00,311),('21','228','104','3',750.00,750.00,1209.50,0.00,0.00,0.00,0.00,312),('21','228','105','1',165.00,165.00,46389.23,0.00,0.00,0.00,0.00,313),('21','228','105','2',830.00,830.00,3761.83,0.00,0.00,0.00,0.00,314),('21','228','105','3',750.00,750.00,1142.33,0.00,0.00,0.00,0.00,315),('21','228','106','2',830.00,830.00,5321.08,0.00,0.00,0.00,0.00,316),('21','228','106','3',750.00,750.00,919.71,0.00,0.00,0.00,0.00,317),('21','228','106','1',165.00,165.00,46056.78,0.00,0.00,0.00,0.00,318),('21','228','107','1',165.00,165.00,55119.92,0.00,0.00,0.00,0.00,319),('21','228','107','2',830.00,830.00,3688.71,0.00,0.00,0.00,0.00,320),('21','228','107','3',750.00,750.00,1711.17,0.00,0.00,0.00,0.00,321),('21','228','108','1',165.00,165.00,40048.30,0.00,0.00,0.00,0.00,322),('21','228','108','2',830.00,830.00,3917.65,0.00,0.00,0.00,0.00,323),('21','228','108','3',750.00,750.00,1538.31,0.00,0.00,0.00,0.00,324),('21','228','109','2',830.00,830.00,1728.13,0.00,0.00,0.00,0.00,325),('21','228','109','3',750.00,750.00,986.19,0.00,0.00,0.00,0.00,326),('21','228','109','1',165.00,165.00,15498.76,0.00,0.00,0.00,0.00,327),('21','228','110','1',165.00,165.00,31385.86,0.00,0.00,0.00,0.00,328),('21','228','110','2',830.00,830.00,7852.55,0.00,0.00,0.00,0.00,329),('21','228','110','3',750.00,750.00,1284.45,0.00,0.00,0.00,0.00,330),('21','228','111','1',165.00,165.00,28867.31,0.00,0.00,0.00,0.00,331),('21','228','111','2',830.00,830.00,3904.38,0.00,0.00,0.00,0.00,332),('21','228','111','3',750.00,750.00,2881.09,0.00,0.00,0.00,0.00,333),('21','228','112','1',165.00,165.00,36954.97,0.00,0.00,0.00,0.00,334),('21','228','112','2',830.00,830.00,3218.29,0.00,0.00,0.00,0.00,335),('21','228','112','3',750.00,750.00,2358.57,0.00,0.00,0.00,0.00,336),('21','228','113','1',165.00,165.00,59115.58,0.00,0.00,0.00,0.00,337),('21','228','113','2',830.00,830.00,3659.99,0.00,0.00,0.00,0.00,338),('21','228','113','3',750.00,750.00,1138.09,0.00,0.00,0.00,0.00,339),('21','228','114','1',165.00,165.00,13374.67,0.00,0.00,0.00,0.00,340),('21','228','114','2',830.00,830.00,2661.63,0.00,0.00,0.00,0.00,341),('21','228','114','3',750.00,750.00,2431.52,0.00,0.00,0.00,0.00,342),('21','228','115','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,343),('21','228','115','2',830.00,830.00,1056.16,0.00,0.00,0.00,0.00,344),('21','228','115','3',750.00,750.00,2852.30,0.00,0.00,0.00,0.00,345),('21','228','116','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,346),('21','228','116','2',830.00,830.00,733.20,0.00,0.00,0.00,0.00,347),('21','228','116','3',750.00,750.00,1087.96,0.00,0.00,0.00,0.00,348),('21','228','117','2',830.00,830.00,2848.28,0.00,0.00,0.00,0.00,349),('21','228','117','3',750.00,750.00,1827.50,0.00,0.00,0.00,0.00,350),('21','228','117','1',165.00,165.00,64268.16,0.00,0.00,0.00,0.00,351),('21','228','118','1',165.00,165.00,54675.87,0.00,0.00,0.00,0.00,352),('21','228','118','2',830.00,830.00,3089.02,0.00,0.00,0.00,0.00,353),('21','228','118','3',750.00,750.00,1055.44,0.00,0.00,0.00,0.00,354),('21','228','119','1',165.00,165.00,63319.76,0.00,0.00,0.00,0.00,355),('21','228','119','2',830.00,830.00,3306.16,0.00,0.00,0.00,0.00,356),('21','228','119','3',750.00,750.00,1583.16,0.00,0.00,0.00,0.00,357),('21','228','120','1',185.00,185.00,35762.92,0.00,0.00,0.00,0.00,358),('21','228','120','2',830.00,830.00,4029.82,0.00,0.00,0.00,0.00,359),('21','228','120','3',750.00,750.00,735.45,0.00,0.00,0.00,0.00,360),('21','228','121','1',185.00,185.00,39425.16,0.00,0.00,0.00,0.00,361),('21','228','121','2',830.00,830.00,2802.27,0.00,0.00,0.00,0.00,362),('21','228','121','3',750.00,750.00,1263.11,0.00,0.00,0.00,0.00,363),('21','228','122','2',830.00,830.00,3141.88,0.00,0.00,0.00,0.00,364),('21','228','122','3',750.00,750.00,2487.85,0.00,0.00,0.00,0.00,365),('21','228','122','1',175.00,185.00,36818.03,0.00,0.00,0.00,0.00,366),('21','228','123','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,367),('21','228','123','2',830.00,830.00,1112.81,0.00,0.00,0.00,0.00,368),('21','228','123','3',750.00,750.00,888.68,0.00,0.00,0.00,0.00,369),('21','228','124','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,370),('21','228','124','2',830.00,830.00,3641.03,0.00,0.00,0.00,0.00,371),('21','228','124','3',750.00,750.00,2358.76,0.00,0.00,0.00,0.00,372),('21','228','125','1',175.00,175.00,29323.94,0.00,0.00,0.00,0.00,373),('21','228','125','2',830.00,830.00,4507.44,0.00,0.00,0.00,0.00,374),('21','228','125','3',750.00,750.00,4939.40,0.00,0.00,0.00,0.00,375),('21','228','126','1',175.00,175.00,15499.70,0.00,0.00,0.00,0.00,376),('21','228','126','2',830.00,815.00,3997.79,0.00,0.00,0.00,0.00,377),('21','228','126','3',750.00,750.00,2919.54,0.00,0.00,0.00,0.00,378),('21','228','127','1',175.00,175.00,44783.24,0.00,0.00,0.00,0.00,379),('21','228','127','2',815.00,815.00,3183.95,0.00,0.00,0.00,0.00,380),('21','228','127','3',750.00,750.00,1600.89,0.00,0.00,0.00,0.00,381),('21','228','128','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,382),('21','228','128','2',815.00,815.00,2524.72,0.00,0.00,0.00,0.00,383),('21','228','128','3',750.00,750.00,291.69,0.00,0.00,0.00,0.00,384),('21','228','129','2',815.00,815.00,4725.59,0.00,0.00,0.00,0.00,385),('21','228','129','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,386),('21','228','129','1',175.00,175.00,24756.23,0.00,0.00,0.00,0.00,387),('21','228','130','1',175.00,175.00,40198.96,0.00,0.00,0.00,0.00,388),('21','228','130','2',815.00,815.00,1993.21,0.00,0.00,0.00,0.00,389),('21','228','130','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,390),('21','228','131','1',175.00,175.00,56436.78,0.00,0.00,0.00,0.00,391),('21','228','131','2',810.00,810.00,6036.50,0.00,0.00,0.00,0.00,392),('21','228','131','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,393),('21','228','132','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,394),('21','228','132','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,395),('21','228','132','1',835.00,835.00,0.00,0.00,0.00,0.00,0.00,396),('21','228','133','1',175.00,175.00,42985.17,0.00,0.00,0.00,0.00,397),('21','228','133','2',810.00,810.00,4905.02,0.00,0.00,0.00,0.00,398),('21','228','133','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,399),('21','228','134','2',810.00,810.00,10623.41,0.00,0.00,0.00,0.00,400),('21','228','134','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,401),('21','228','134','1',175.00,175.00,35995.79,0.00,0.00,0.00,0.00,402),('21','228','135','2',810.00,810.00,3867.55,0.00,0.00,0.00,0.00,403),('21','228','135','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,404),('21','228','135','1',175.00,175.00,38964.37,0.00,0.00,0.00,0.00,405),('21','228','136','1',175.00,175.00,42699.71,0.00,0.00,0.00,0.00,406),('21','228','136','2',810.00,810.00,4451.78,0.00,0.00,0.00,0.00,407),('21','228','136','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,408),('21','228','137','2',810.00,810.00,3122.37,0.00,0.00,0.00,0.00,409),('21','228','137','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,410),('21','228','137','1',175.00,175.00,31069.50,0.00,0.00,0.00,0.00,411),('21','228','138','1',175.00,175.00,22096.96,0.00,0.00,0.00,0.00,412),('21','228','138','2',810.00,810.00,2079.48,0.00,0.00,0.00,0.00,413),('21','228','138','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,414),('21','228','139','1',175.00,175.00,25201.77,0.00,0.00,0.00,0.00,415),('21','228','139','2',810.00,810.00,4901.52,0.00,0.00,0.00,0.00,416),('21','228','139','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,417),('21','228','140','1',175.00,175.00,19719.82,0.00,0.00,0.00,0.00,418),('21','228','140','2',810.00,810.00,2525.99,0.00,0.00,0.00,0.00,419),('21','228','140','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,420),('21','228','141','1',175.00,175.00,65514.45,0.00,0.00,0.00,0.00,421),('21','228','141','2',810.00,810.00,3529.16,0.00,0.00,0.00,0.00,422),('21','228','141','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,423),('21','228','142','1',175.00,175.00,23955.46,0.00,0.00,0.00,0.00,424),('21','228','142','2',810.00,810.00,4352.44,0.00,0.00,0.00,0.00,425),('21','228','142','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,426),('21','228','143','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,427),('21','228','143','2',810.00,810.00,3565.70,0.00,0.00,0.00,0.00,428),('21','228','143','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,429),('21','228','144','1',175.00,175.00,45058.47,0.00,0.00,0.00,0.00,430),('21','228','144','2',810.00,810.00,3949.58,0.00,0.00,0.00,0.00,431),('21','228','144','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,432),('21','228','145','1',175.00,175.00,16361.22,0.00,0.00,0.00,0.00,433),('21','228','145','2',810.00,810.00,1634.97,0.00,0.00,0.00,0.00,434),('21','228','145','3',835.00,835.00,632.22,0.00,0.00,0.00,0.00,435),('21','228','146','1',175.00,175.00,13343.78,0.00,0.00,0.00,0.00,436),('21','228','146','2',810.00,810.00,4487.46,0.00,0.00,0.00,0.00,437),('21','228','146','3',835.00,835.00,1638.20,0.00,0.00,0.00,0.00,438),('21','228','147','1',175.00,175.00,39954.89,0.00,0.00,0.00,0.00,439),('21','228','147','2',810.00,810.00,4212.63,0.00,0.00,0.00,0.00,440),('21','228','147','3',835.00,835.00,1124.32,0.00,0.00,0.00,0.00,441),('21','228','148','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,442),('21','228','148','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,443),('21','228','148','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,444),('21','228','149','2',810.00,810.00,4501.94,0.00,0.00,0.00,0.00,445),('21','228','149','3',835.00,835.00,1225.31,0.00,0.00,0.00,0.00,446),('21','228','149','1',175.00,175.00,5337.05,0.00,0.00,0.00,0.00,447),('21','228','150','1',175.00,175.00,57363.97,0.00,0.00,0.00,0.00,448),('21','228','150','2',810.00,810.00,4418.57,0.00,0.00,0.00,0.00,449),('21','228','150','3',835.00,835.00,1020.82,0.00,0.00,0.00,0.00,450),('21','228','151','1',175.00,175.00,39968.59,0.00,0.00,0.00,0.00,451),('21','228','151','2',810.00,810.00,4676.70,0.00,0.00,0.00,0.00,452),('21','228','151','3',850.00,850.00,1499.61,0.00,0.00,0.00,0.00,453),('21','228','152','1',175.00,175.00,15021.08,0.00,0.00,0.00,0.00,454),('21','228','152','2',810.00,810.00,3364.02,0.00,0.00,0.00,0.00,455),('21','228','152','3',850.00,850.00,787.47,0.00,0.00,0.00,0.00,456),('21','228','153','1',175.00,175.00,14946.37,0.00,0.00,0.00,0.00,457),('21','228','153','2',810.00,810.00,1579.26,0.00,0.00,0.00,0.00,458),('21','228','153','3',850.00,850.00,406.89,0.00,0.00,0.00,0.00,459),('21','228','154','1',175.00,175.00,19973.78,0.00,0.00,0.00,0.00,460),('21','228','154','2',810.00,810.00,2370.52,0.00,0.00,0.00,0.00,461),('21','228','154','3',850.00,850.00,894.46,0.00,0.00,0.00,0.00,462),('21','228','155','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,463),('21','228','155','2',810.00,810.00,4198.55,0.00,0.00,0.00,0.00,464),('21','228','155','3',850.00,850.00,926.23,0.00,0.00,0.00,0.00,465),('21','228','156','1',175.00,175.00,40329.99,0.00,0.00,0.00,0.00,466),('21','228','156','2',810.00,810.00,3029.17,0.00,0.00,0.00,0.00,467),('21','228','156','3',860.00,860.00,539.46,0.00,0.00,0.00,0.00,468),('21','228','157','2',800.00,800.00,4226.61,0.00,0.00,0.00,0.00,469),('21','228','157','3',860.00,860.00,794.17,0.00,0.00,0.00,0.00,470),('21','228','157','1',175.00,175.00,28466.67,0.00,0.00,0.00,0.00,471),('21','228','158','1',175.00,175.00,56760.61,0.00,0.00,0.00,0.00,472),('21','228','158','2',800.00,800.00,2736.65,0.00,0.00,0.00,0.00,473),('21','228','158','3',860.00,860.00,560.20,0.00,0.00,0.00,0.00,474),('21','228','159','1',175.00,175.00,53988.09,0.00,0.00,0.00,0.00,475),('21','228','159','2',800.00,800.00,3519.32,0.00,0.00,0.00,0.00,476),('21','228','159','3',860.00,860.00,986.73,0.00,0.00,0.00,0.00,477),('21','228','160','1',175.00,175.00,15403.79,0.00,0.00,0.00,0.00,478),('21','228','160','2',800.00,800.00,1151.82,0.00,0.00,0.00,0.00,479),('21','228','160','3',860.00,860.00,633.05,0.00,0.00,0.00,0.00,480),('21','228','161','2',800.00,800.00,4764.42,0.00,0.00,0.00,0.00,481),('21','228','161','3',860.00,860.00,587.23,0.00,0.00,0.00,0.00,482),('21','228','161','1',175.00,175.00,19726.21,0.00,0.00,0.00,0.00,483),('21','228','162','1',175.00,175.00,42398.90,0.00,0.00,0.00,0.00,484),('21','228','162','2',800.00,800.00,3823.19,0.00,0.00,0.00,0.00,485),('21','228','162','3',860.00,860.00,486.50,0.00,0.00,0.00,0.00,486),('21','228','163','2',800.00,800.00,4220.89,0.00,0.00,0.00,0.00,487),('21','228','163','3',860.00,860.00,761.42,0.00,0.00,0.00,0.00,488),('21','228','163','1',175.00,175.00,52669.83,0.00,0.00,0.00,0.00,489),('21','228','164','1',175.00,175.00,56729.13,0.00,0.00,0.00,0.00,490),('21','228','164','2',800.00,800.00,3212.94,0.00,0.00,0.00,0.00,491),('21','228','164','3',860.00,860.00,374.69,0.00,0.00,0.00,0.00,492),('21','228','165','1',175.00,175.00,50367.61,0.00,0.00,0.00,0.00,493),('21','228','165','2',800.00,800.00,3263.75,0.00,0.00,0.00,0.00,494),('21','228','165','3',860.00,860.00,422.70,0.00,0.00,0.00,0.00,495),('21','228','166','1',175.00,175.00,1111.90,0.00,0.00,0.00,0.00,496),('21','228','166','2',800.00,800.00,3080.93,0.00,0.00,0.00,0.00,497),('21','228','166','3',860.00,860.00,734.94,0.00,0.00,0.00,0.00,498),('21','228','167','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,499),('21','228','167','2',800.00,800.00,1119.20,0.00,0.00,0.00,0.00,500),('21','228','167','3',860.00,860.00,726.69,0.00,0.00,0.00,0.00,501),('21','228','168','2',800.00,800.00,3347.02,0.00,0.00,0.00,0.00,502),('21','228','168','3',860.00,860.00,990.70,0.00,0.00,0.00,0.00,503),('21','228','168','1',175.00,175.00,50619.85,0.00,0.00,0.00,0.00,504),('21','228','169','1',175.00,175.00,51444.82,0.00,0.00,0.00,0.00,505),('21','228','169','2',800.00,800.00,3999.53,0.00,0.00,0.00,0.00,506),('21','228','169','3',860.00,860.00,754.99,0.00,0.00,0.00,0.00,507),('21','228','170','1',175.00,175.00,36885.78,0.00,0.00,0.00,0.00,508),('21','228','170','2',800.00,800.00,3853.41,0.00,0.00,0.00,0.00,509),('21','228','170','3',860.00,860.00,626.64,0.00,0.00,0.00,0.00,510),('21','228','171','1',175.00,175.00,59643.23,0.00,0.00,0.00,0.00,511),('21','228','171','2',800.00,800.00,3950.35,0.00,0.00,0.00,0.00,512),('21','228','171','3',860.00,860.00,605.02,0.00,0.00,0.00,0.00,513),('21','228','172','2',800.00,800.00,2864.40,0.00,0.00,0.00,0.00,514),('21','228','172','3',860.00,860.00,464.75,0.00,0.00,0.00,0.00,515),('21','228','172','1',175.00,175.00,31174.56,0.00,0.00,0.00,0.00,516),('21','228','173','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,517),('21','228','173','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,518),('21','228','173','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,519),('21','228','174','2',800.00,800.00,8007.11,0.00,0.00,0.00,0.00,520),('21','228','174','3',860.00,860.00,686.05,0.00,0.00,0.00,0.00,521),('21','228','174','1',175.00,175.00,63040.63,0.00,0.00,0.00,0.00,522),('21','228','175','1',175.00,175.00,51857.92,0.00,0.00,0.00,0.00,523),('21','228','175','2',800.00,800.00,1499.02,0.00,0.00,0.00,0.00,524),('21','228','175','3',860.00,860.00,650.58,0.00,0.00,0.00,0.00,525),('21','228','176','1',175.00,175.00,38527.74,0.00,0.00,0.00,0.00,526),('21','228','176','2',800.00,800.00,2972.84,0.00,0.00,0.00,0.00,527),('21','228','176','3',860.00,860.00,566.91,0.00,0.00,0.00,0.00,528),('21','228','177','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,529),('21','228','177','2',800.00,800.00,3190.01,0.00,0.00,0.00,0.00,530),('21','228','177','3',860.00,860.00,604.61,0.00,0.00,0.00,0.00,531),('21','228','178','1',175.00,175.00,67137.14,0.00,0.00,0.00,0.00,532),('21','228','178','2',800.00,800.00,4120.46,0.00,0.00,0.00,0.00,533),('21','228','178','3',860.00,860.00,970.27,0.00,0.00,0.00,0.00,534),('21','228','179','1',175.00,175.00,62779.09,0.00,0.00,0.00,0.00,535),('21','228','179','2',800.00,800.00,4318.23,0.00,0.00,0.00,0.00,536),('21','228','179','3',860.00,860.00,606.10,0.00,0.00,0.00,0.00,537),('21','228','180','1',175.00,175.00,64852.77,0.00,0.00,0.00,0.00,538),('21','228','180','2',800.00,800.00,2327.47,0.00,0.00,0.00,0.00,539),('21','228','180','3',860.00,860.00,474.00,0.00,0.00,0.00,0.00,540),('21','228','181','1',175.00,175.00,58299.16,0.00,0.00,0.00,0.00,541),('21','228','181','2',800.00,800.00,3354.52,0.00,0.00,0.00,0.00,542),('21','228','181','3',860.00,860.00,644.85,0.00,0.00,0.00,0.00,543),('21','228','182','1',175.00,175.00,62371.58,0.00,0.00,0.00,0.00,544),('21','228','182','2',800.00,800.00,1688.06,0.00,0.00,0.00,0.00,545),('21','228','182','3',860.00,860.00,523.90,0.00,0.00,0.00,0.00,546),('21','228','183','1',175.00,175.00,59424.38,0.00,0.00,0.00,0.00,547),('21','228','183','2',800.00,800.00,4013.74,0.00,0.00,0.00,0.00,548),('21','228','183','3',860.00,860.00,732.63,0.00,0.00,0.00,0.00,549),('21','228','184','1',175.00,175.00,55724.96,0.00,0.00,0.00,0.00,550),('21','228','184','2',800.00,800.00,2864.87,0.00,0.00,0.00,0.00,551),('21','228','184','3',860.00,860.00,791.17,0.00,0.00,0.00,0.00,552),('21','228','185','1',175.00,175.00,57320.98,0.00,0.00,0.00,0.00,553),('21','228','185','2',800.00,800.00,3464.19,0.00,0.00,0.00,0.00,554),('21','228','185','3',860.00,860.00,582.25,0.00,0.00,0.00,0.00,555),('21','228','186','1',175.00,175.00,27899.87,0.00,0.00,0.00,0.00,556),('21','228','186','2',800.00,800.00,2476.43,0.00,0.00,0.00,0.00,557),('21','228','186','3',650.00,860.00,601.04,0.00,0.00,0.00,0.00,558),('21','228','187','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,559),('21','228','187','2',800.00,800.00,7248.98,0.00,0.00,0.00,0.00,560),('21','228','187','3',650.00,860.00,1083.93,0.00,0.00,0.00,0.00,561),('21','228','188','1',175.00,175.00,66413.85,0.00,0.00,0.00,0.00,562),('21','228','188','2',800.00,800.00,3459.37,0.00,0.00,0.00,0.00,563),('21','228','188','3',650.00,860.00,1054.33,0.00,0.00,0.00,0.00,564),('21','228','189','1',175.00,175.00,62247.65,0.00,0.00,0.00,0.00,565),('21','228','189','2',800.00,800.00,2396.89,0.00,0.00,0.00,0.00,566),('21','228','189','3',650.00,860.00,677.71,0.00,0.00,0.00,0.00,567),('21','228','190','1',175.00,175.00,52546.61,0.00,0.00,0.00,0.00,568),('21','228','190','2',800.00,800.00,2345.55,0.00,0.00,0.00,0.00,569),('21','228','190','3',650.00,860.00,459.91,0.00,0.00,0.00,0.00,570),('21','228','191','2',800.00,800.00,3818.97,0.00,0.00,0.00,0.00,571),('21','228','191','3',860.00,860.00,1037.20,0.00,0.00,0.00,0.00,572),('21','228','191','1',175.00,175.00,34282.64,0.00,0.00,0.00,0.00,573),('21','228','192','1',175.00,175.00,56781.31,0.00,0.00,0.00,0.00,574),('21','228','192','2',800.00,800.00,2409.17,0.00,0.00,0.00,0.00,575),('21','228','192','3',860.00,860.00,867.47,0.00,0.00,0.00,0.00,576),('21','228','193','1',175.00,175.00,54488.80,0.00,0.00,0.00,0.00,577),('21','228','193','2',800.00,800.00,2346.71,0.00,0.00,0.00,0.00,578),('21','228','193','3',860.00,860.00,808.34,0.00,0.00,0.00,0.00,579),('21','228','194','1',175.00,175.00,37503.49,0.00,0.00,0.00,0.00,580),('21','228','194','2',800.00,800.00,3522.30,0.00,0.00,0.00,0.00,581),('21','228','194','3',860.00,860.00,730.87,0.00,0.00,0.00,0.00,582),('21','228','195','1',175.00,175.00,25371.20,0.00,0.00,0.00,0.00,583),('21','228','195','2',800.00,800.00,3317.55,0.00,0.00,0.00,0.00,584),('21','228','195','3',860.00,860.00,967.42,0.00,0.00,0.00,0.00,585),('21','228','196','2',800.00,800.00,1152.94,0.00,0.00,0.00,0.00,586),('21','228','196','3',860.00,860.00,712.27,0.00,0.00,0.00,0.00,587),('21','228','196','1',175.00,175.00,29940.88,0.00,0.00,0.00,0.00,588),('21','228','197','1',175.00,175.00,37822.65,0.00,0.00,0.00,0.00,589),('21','228','197','2',800.00,800.00,2859.95,0.00,0.00,0.00,0.00,590),('21','228','197','3',860.00,860.00,926.26,0.00,0.00,0.00,0.00,591),('21','228','198','1',175.00,175.00,49809.38,0.00,0.00,0.00,0.00,592),('21','228','198','2',800.00,800.00,3178.14,0.00,0.00,0.00,0.00,593),('21','228','198','3',860.00,860.00,908.53,0.00,0.00,0.00,0.00,594),('21','228','199','2',800.00,800.00,3747.89,0.00,0.00,0.00,0.00,595),('21','228','199','3',860.00,860.00,968.74,0.00,0.00,0.00,0.00,596),('21','228','199','1',175.00,175.00,41921.47,0.00,0.00,0.00,0.00,597),('21','228','200','1',175.00,175.00,49074.07,0.00,0.00,0.00,0.00,598),('21','228','200','2',800.00,800.00,4083.68,0.00,0.00,0.00,0.00,599),('21','228','200','3',860.00,860.00,551.69,0.00,0.00,0.00,0.00,600),('21','228','201','1',175.00,175.00,47729.44,0.00,0.00,0.00,0.00,601),('21','228','201','2',800.00,800.00,4292.15,0.00,0.00,0.00,0.00,602),('21','228','201','3',860.00,860.00,609.71,0.00,0.00,0.00,0.00,603),('21','228','202','1',175.00,175.00,43647.62,0.00,0.00,0.00,0.00,604),('21','228','202','2',800.00,800.00,2854.47,0.00,0.00,0.00,0.00,605),('21','228','202','3',860.00,860.00,972.53,0.00,0.00,0.00,0.00,606),('21','228','203','2',800.00,800.00,798.52,0.00,0.00,0.00,0.00,607),('21','228','203','3',860.00,860.00,778.96,0.00,0.00,0.00,0.00,608),('21','228','203','1',175.00,175.00,49924.45,0.00,0.00,0.00,0.00,609),('21','228','204','1',175.00,175.00,25573.38,0.00,0.00,0.00,0.00,610),('21','228','204','2',800.00,800.00,4908.30,0.00,0.00,0.00,0.00,611),('21','228','204','3',860.00,860.00,757.92,0.00,0.00,0.00,0.00,612),('21','228','205','2',815.00,815.00,4990.76,0.00,0.00,0.00,0.00,613),('21','228','205','3',860.00,860.00,760.57,0.00,0.00,0.00,0.00,614),('21','228','205','1',175.00,175.00,30025.00,0.00,0.00,0.00,0.00,615),('21','228','206','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,616),('21','228','206','2',815.00,815.00,4425.41,0.00,0.00,0.00,0.00,617),('21','228','206','3',860.00,860.00,683.74,0.00,0.00,0.00,0.00,618),('21','228','207','1',175.00,175.00,33300.46,0.00,0.00,0.00,0.00,619),('21','228','207','2',815.00,815.00,5614.12,0.00,0.00,0.00,0.00,620),('21','228','207','3',860.00,860.00,621.83,0.00,0.00,0.00,0.00,621),('21','228','208','1',175.00,175.00,11597.73,0.00,0.00,0.00,0.00,622),('21','228','208','2',815.00,815.00,2062.17,0.00,0.00,0.00,0.00,623),('21','228','208','3',860.00,860.00,752.29,0.00,0.00,0.00,0.00,624),('21','228','209','1',175.00,175.00,18942.08,0.00,0.00,0.00,0.00,625),('21','228','209','2',815.00,815.00,2476.41,0.00,0.00,0.00,0.00,626),('21','228','209','3',860.00,860.00,558.64,0.00,0.00,0.00,0.00,627),('21','228','210','1',175.00,175.00,58304.99,0.00,0.00,0.00,0.00,628),('21','228','210','2',815.00,815.00,1369.16,0.00,0.00,0.00,0.00,629),('21','228','210','3',860.00,860.00,734.68,0.00,0.00,0.00,0.00,630),('21','228','211','1',175.00,175.00,21199.18,0.00,0.00,0.00,0.00,631),('21','228','211','2',815.00,815.00,4326.85,0.00,0.00,0.00,0.00,632),('21','228','211','3',860.00,860.00,715.26,0.00,0.00,0.00,0.00,633),('21','228','212','2',815.00,815.00,4123.94,0.00,0.00,0.00,0.00,634),('21','228','212','3',860.00,860.00,543.09,0.00,0.00,0.00,0.00,635),('21','228','212','1',175.00,175.00,46445.19,0.00,0.00,0.00,0.00,636),('21','228','213','1',175.00,175.00,43953.81,0.00,0.00,0.00,0.00,637),('21','228','213','2',815.00,815.00,2689.90,0.00,0.00,0.00,0.00,638),('21','228','213','3',860.00,860.00,707.00,0.00,0.00,0.00,0.00,639),('21','228','214','1',175.00,175.00,46069.44,0.00,0.00,0.00,0.00,640),('21','228','214','2',815.00,815.00,18.71,0.00,0.00,0.00,0.00,641),('21','228','214','3',860.00,860.00,701.01,0.00,0.00,0.00,0.00,642),('21','228','215','1',175.00,175.00,44813.32,0.00,0.00,0.00,0.00,643),('21','228','215','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,644),('21','228','215','3',860.00,860.00,505.33,0.00,0.00,0.00,0.00,645),('21','228','216','1',175.00,175.00,45176.65,0.00,0.00,0.00,0.00,646),('21','228','216','2',830.00,830.00,677.43,0.00,0.00,0.00,0.00,647),('21','228','216','3',860.00,860.00,1559.10,0.00,0.00,0.00,0.00,648),('21','228','217','2',830.00,830.00,1527.62,0.00,0.00,0.00,0.00,649),('21','228','217','3',860.00,860.00,724.30,0.00,0.00,0.00,0.00,650),('21','228','217','1',175.00,175.00,44427.57,0.00,0.00,0.00,0.00,651),('21','228','218','1',175.00,175.00,30603.51,0.00,0.00,0.00,0.00,652),('21','228','218','2',830.00,830.00,3857.56,0.00,0.00,0.00,0.00,653),('21','228','218','3',860.00,860.00,922.35,0.00,0.00,0.00,0.00,654),('21','228','219','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,655),('21','228','219','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,656),('21','228','219','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,657),('21','228','220','1',175.00,175.00,44597.51,0.00,0.00,0.00,0.00,658),('21','228','220','2',830.00,830.00,3167.43,0.00,0.00,0.00,0.00,659),('21','228','220','3',860.00,860.00,468.90,0.00,0.00,0.00,0.00,660),('21','228','221','1',175.00,175.00,39894.44,0.00,0.00,0.00,0.00,661),('21','228','221','2',830.00,830.00,4962.24,0.00,0.00,0.00,0.00,662),('21','228','221','3',860.00,860.00,882.85,0.00,0.00,0.00,0.00,663),('21','228','222','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,664),('21','228','222','2',830.00,830.00,2937.99,0.00,0.00,0.00,0.00,665),('21','228','222','3',860.00,860.00,442.74,0.00,0.00,0.00,0.00,666),('21','228','223','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,667),('21','228','223','2',830.00,830.00,2819.68,0.00,0.00,0.00,0.00,668),('21','228','223','3',860.00,860.00,575.81,0.00,0.00,0.00,0.00,669),('21','228','224','1',175.00,175.00,49375.76,0.00,0.00,0.00,0.00,670),('21','228','224','2',830.00,830.00,3039.53,0.00,0.00,0.00,0.00,671),('21','228','224','3',860.00,860.00,505.61,0.00,0.00,0.00,0.00,672),('21','228','225','1',175.00,175.00,40128.64,0.00,0.00,0.00,0.00,673),('21','228','225','2',830.00,830.00,6191.43,0.00,0.00,0.00,0.00,674),('21','228','225','3',860.00,860.00,628.10,0.00,0.00,0.00,0.00,675);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'228','PRODUCT TANK','TANKS CONTAINING PETROLEUM PRODUCT');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','228','1',1,0,'1','PMS  TANK 1 & 2',90000.00,0.00,NULL,'PRODUCT TANK','764','2022-03-03 16:12:16','2022-03-03 16:17:18','764',5,0),('21','228','1',2,0,'1','PMS TANK 3 & 4',90000.00,0.00,NULL,'PRODUCT TANK','764','2022-03-03 16:25:35','2022-03-03 16:25:35','764',5,0),('21','228','1',3,0,'2','AGO TANK 1 & 2',90000.00,0.00,NULL,'PRODUCT TANK','764','2022-03-03 16:31:28','2022-03-03 16:31:28','764',5,0),('21','228','1',4,0,'3','DPK TANK',45000.00,0.00,NULL,'PRODUCT TANK','764','2022-03-03 16:34:27','2022-03-03 16:34:27','764',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4954 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-23 12:58:43','',''),(2,'21','228','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 12:59:48','',''),(3,'21','228','1',0,'Inventory adjustment from tank dipping to 2600',0.00,0.00,2600.00,0.00,0.00,'2022-03-23 12:59:48','',''),(4,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,45430000.00,64900.00,0.00,0.00,'2022-03-23 13:00:16','',''),(5,'21','228','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 13:00:59','',''),(6,'21','228','3',0,'Inventory adjustment from tank dipping to 1850',0.00,0.00,1850.00,0.00,0.00,'2022-03-23 13:00:59','',''),(7,'21','228','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 13:01:24','',''),(8,'21','228','4',0,'Inventory adjustment from tank dipping to 100',0.00,0.00,100.00,0.00,0.00,'2022-03-23 13:01:24','',''),(9,'21','228',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,30000.00,0.00,'2022-03-23 13:24:32','',''),(10,'21','228','1',1,'Received from bridging 1',0.00,0.00,30000.00,0.00,0.00,'2022-03-23 13:24:32','',''),(11,'21','228',NULL,2,'Reception corrector for bridging 2',0.00,0.00,0.00,64900.00,0.00,'2022-03-23 13:27:24','',''),(12,'21','228','3',2,'Received from bridging 2',0.00,0.00,64900.00,0.00,0.00,'2022-03-23 13:27:24','',''),(13,'21','228','1',1,'Sale Id shift 1',0.00,0.00,0.00,4764.40,0.00,'2022-03-23 14:06:19','',''),(14,'21','228','1',1,'Sale Id shift 1',0.00,0.00,0.00,3395.46,0.00,'2022-03-23 14:06:19','',''),(15,'21','228','1',1,'Sale Id shift 1',0.00,0.00,0.00,3383.92,0.00,'2022-03-23 14:06:19','',''),(16,'21','228','1',1,'Sale Id shift 1',0.00,0.00,0.00,3214.34,0.00,'2022-03-23 14:06:19','',''),(17,'21','228','1',1,'Sale Id shift 1',0.00,0.00,0.00,3603.60,0.00,'2022-03-23 14:06:19','',''),(18,'21','228','1',1,'Sale Id shift 1',0.00,0.00,0.00,3461.37,0.00,'2022-03-23 14:06:19','',''),(19,'21','228','1',1,'Sale Id shift 1',0.00,0.00,0.00,3773.02,0.00,'2022-03-23 14:06:19','',''),(20,'21','228','1',1,'Sale Id shift 1',0.00,0.00,0.00,4313.81,0.00,'2022-03-23 14:06:19','',''),(21,'21','228','3',2,'Sale Id shift 1',0.00,0.00,0.00,2527.81,0.00,'2022-03-23 14:06:19','',''),(22,'21','228','3',2,'Sale Id shift 1',0.00,0.00,0.00,1.86,0.00,'2022-03-23 14:06:19','',''),(23,'21','228','3',2,'Sale Id shift 1',0.00,0.00,0.00,1132.86,0.00,'2022-03-23 14:06:19','',''),(24,'21','228','3',2,'Sale Id shift 1',0.00,0.00,0.00,2219.01,0.00,'2022-03-23 14:06:19','',''),(25,'21','228',NULL,1,'Sale Id shift 1',4935136.80,0.00,0.00,0.00,0.00,'2022-03-23 14:06:19','',''),(26,'21','228',NULL,2,'Sale Id shift 1',4117078.00,0.00,0.00,0.00,0.00,'2022-03-23 14:06:19','',''),(27,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-23 14:12:07','',''),(28,'21','228',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,16000.00,0.00,'2022-03-23 14:15:12','',''),(29,'21','228','2',1,'Received from bridging 4',0.00,0.00,16000.00,0.00,0.00,'2022-03-23 14:15:12','',''),(30,'21','228',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,29000.00,0.00,'2022-03-23 14:15:12','',''),(31,'21','228','1',1,'Received from bridging 3',0.00,0.00,29000.00,0.00,0.00,'2022-03-23 14:15:12','',''),(32,'21','228','2',1,'Sale Id shift 2',0.00,0.00,0.00,3005.85,0.00,'2022-03-24 10:51:39','',''),(33,'21','228','2',1,'Sale Id shift 2',0.00,0.00,0.00,3177.68,0.00,'2022-03-24 10:51:39','',''),(34,'21','228','2',1,'Sale Id shift 2',0.00,0.00,0.00,2667.37,0.00,'2022-03-24 10:51:39','',''),(35,'21','228','2',1,'Sale Id shift 2',0.00,0.00,0.00,3030.67,0.00,'2022-03-24 10:51:39','',''),(36,'21','228','2',1,'Sale Id shift 2',0.00,0.00,0.00,3101.10,0.00,'2022-03-24 10:51:39','',''),(37,'21','228','1',1,'Sale Id shift 2',0.00,0.00,0.00,5567.86,0.00,'2022-03-24 10:51:39','',''),(38,'21','228','3',2,'Sale Id shift 2',0.00,0.00,0.00,3408.61,0.00,'2022-03-24 10:51:39','',''),(39,'21','228','3',2,'Sale Id shift 2',0.00,0.00,0.00,2.14,0.00,'2022-03-24 10:51:39','',''),(40,'21','228','3',2,'Sale Id shift 2',0.00,0.00,0.00,1528.46,0.00,'2022-03-24 10:51:39','',''),(41,'21','228','1',1,'Sale Id shift 2',0.00,0.00,0.00,4472.15,0.00,'2022-03-24 10:51:39','',''),(42,'21','228','1',1,'Sale Id shift 2',0.00,0.00,0.00,1406.66,0.00,'2022-03-24 10:51:39','',''),(43,'21','228','1',1,'Sale Id shift 2',0.00,0.00,0.00,4406.72,0.00,'2022-03-24 10:51:39','',''),(44,'21','228','1',1,'Sale Id shift 2',0.00,0.00,0.00,2033.51,0.00,'2022-03-24 10:51:39','',''),(45,'21','228','1',1,'Sale Id shift 2',0.00,0.00,0.00,3101.59,0.00,'2022-03-24 10:51:39','',''),(46,'21','228','1',1,'Sale Id shift 2',0.00,0.00,0.00,3640.91,0.00,'2022-03-24 10:51:39','',''),(47,'21','228','1',1,'Sale Id shift 2',0.00,0.00,0.00,5332.28,0.00,'2022-03-24 10:51:39','',''),(48,'21','228',NULL,2,'Sale Id shift 2',3457447.00,0.00,0.00,0.00,0.00,'2022-03-24 10:51:39','',''),(49,'21','228',NULL,1,'Sale Id shift 2',7415817.75,0.00,0.00,0.00,0.00,'2022-03-24 10:51:39','',''),(50,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-03-25 11:05:34','',''),(51,'21','228',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,40000.00,0.00,'2022-03-25 11:12:51','',''),(52,'21','228','1',1,'Received from bridging 5',0.00,0.00,40000.00,0.00,0.00,'2022-03-25 11:12:51','',''),(53,'21','228','1',1,'Returned bridging 5',0.00,0.00,0.00,40000.00,0.00,'2022-03-25 11:16:41','',''),(54,'21','228',NULL,1,'Reception Return corrector for bridging 5',0.00,0.00,40000.00,0.00,0.00,'2022-03-25 11:16:41','',''),(55,'21','228',NULL,1,'Returned purchase #7 to AYM SHAFA NIGERIA LTD',6600000.00,0.00,0.00,40000.00,0.00,'2022-03-25 11:31:16','',''),(56,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-25 11:32:33','',''),(57,'21','228',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,16000.00,0.00,'2022-03-25 11:35:48','',''),(58,'21','228','2',1,'Received from bridging 7',0.00,0.00,16000.00,0.00,0.00,'2022-03-25 11:35:48','',''),(59,'21','228',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,29000.00,0.00,'2022-03-25 11:35:48','',''),(60,'21','228','1',1,'Received from bridging 6',0.00,0.00,29000.00,0.00,0.00,'2022-03-25 11:35:48','',''),(61,'21','228','2',1,'Sale Id shift 3',0.00,0.00,0.00,3571.26,0.00,'2022-03-25 12:01:51','',''),(62,'21','228','2',1,'Sale Id shift 3',0.00,0.00,0.00,3135.14,0.00,'2022-03-25 12:01:51','',''),(63,'21','228','2',1,'Sale Id shift 3',0.00,0.00,0.00,3051.01,0.00,'2022-03-25 12:01:51','',''),(64,'21','228','2',1,'Sale Id shift 3',0.00,0.00,0.00,3174.32,0.00,'2022-03-25 12:01:51','',''),(65,'21','228','2',1,'Sale Id shift 3',0.00,0.00,0.00,2153.94,0.00,'2022-03-25 12:01:51','',''),(66,'21','228','1',1,'Sale Id shift 3',0.00,0.00,0.00,6982.82,0.00,'2022-03-25 12:01:51','',''),(67,'21','228','2',1,'Sale Id shift 3',0.00,0.00,0.00,1040.77,0.00,'2022-03-25 12:01:51','',''),(68,'21','228','3',2,'Sale Id shift 3',0.00,0.00,0.00,2933.23,0.00,'2022-03-25 12:01:51','',''),(69,'21','228','3',2,'Sale Id shift 3',0.00,0.00,0.00,2320.00,0.00,'2022-03-25 12:01:51','',''),(70,'21','228','1',1,'Sale Id shift 3',0.00,0.00,0.00,5200.04,0.00,'2022-03-25 12:01:51','',''),(71,'21','228','1',1,'Sale Id shift 3',0.00,0.00,0.00,3744.53,0.00,'2022-03-25 12:01:51','',''),(72,'21','228','1',1,'Sale Id shift 3',0.00,0.00,0.00,1469.93,0.00,'2022-03-25 12:01:51','',''),(73,'21','228','1',1,'Sale Id shift 3',0.00,0.00,0.00,2919.75,0.00,'2022-03-25 12:01:51','',''),(74,'21','228','1',1,'Sale Id shift 3',0.00,0.00,0.00,2915.36,0.00,'2022-03-25 12:01:51','',''),(75,'21','228','1',1,'Sale Id shift 3',0.00,0.00,0.00,6008.73,0.00,'2022-03-25 12:01:51','',''),(76,'21','228',NULL,2,'Sale Id shift 3',3677261.00,0.00,0.00,0.00,0.00,'2022-03-25 12:01:51','',''),(77,'21','228',NULL,1,'Sale Id shift 3',7485654.00,0.00,0.00,0.00,0.00,'2022-03-25 12:01:51','',''),(78,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-03-25 12:25:22','',''),(79,'21','228',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,40000.00,0.00,'2022-03-25 12:27:00','',''),(80,'21','228','1',1,'Received from bridging 8',0.00,0.00,40000.00,0.00,0.00,'2022-03-25 12:27:00','',''),(81,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8800000.00,16000.00,0.00,0.00,'2022-03-25 13:00:19','',''),(82,'21','228',NULL,3,'Reception corrector for bridging 9',0.00,0.00,0.00,16000.00,0.00,'2022-03-25 13:02:07','',''),(83,'21','228','4',3,'Received from bridging 9',0.00,0.00,16000.00,0.00,0.00,'2022-03-25 13:02:07','',''),(84,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-03-26 17:18:02','',''),(85,'21','228',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,40000.00,0.00,'2022-03-28 15:16:58','',''),(86,'21','228','1',1,'Received from bridging 10',0.00,0.00,40000.00,0.00,0.00,'2022-03-28 15:16:58','',''),(87,'21','228','1',1,'Sale Id shift 4',0.00,0.00,0.00,6576.80,0.00,'2022-03-28 15:21:51','',''),(88,'21','228','3',2,'Sale Id shift 4',0.00,0.00,0.00,3446.38,0.00,'2022-03-28 15:21:51','',''),(89,'21','228','3',2,'Sale Id shift 4',0.00,0.00,0.00,37.45,0.00,'2022-03-28 15:21:51','',''),(90,'21','228','3',2,'Sale Id shift 4',0.00,0.00,0.00,2020.35,0.00,'2022-03-28 15:21:51','',''),(91,'21','228','4',3,'Sale Id shift 4',0.00,0.00,0.00,1307.02,0.00,'2022-03-28 15:21:51','',''),(92,'21','228','1',1,'Sale Id shift 4',0.00,0.00,0.00,4476.91,0.00,'2022-03-28 15:21:51','',''),(93,'21','228','1',1,'Sale Id shift 4',0.00,0.00,0.00,4237.40,0.00,'2022-03-28 15:21:51','',''),(94,'21','228','1',1,'Sale Id shift 4',0.00,0.00,0.00,4897.76,0.00,'2022-03-28 15:21:51','',''),(95,'21','228','1',1,'Sale Id shift 4',0.00,0.00,0.00,4393.33,0.00,'2022-03-28 15:21:51','',''),(96,'21','228','1',1,'Sale Id shift 4',0.00,0.00,0.00,4569.27,0.00,'2022-03-28 15:21:51','',''),(97,'21','228','1',1,'Sale Id shift 4',0.00,0.00,0.00,4742.54,0.00,'2022-03-28 15:21:51','',''),(98,'21','228','1',1,'Sale Id shift 4',0.00,0.00,0.00,5940.20,0.00,'2022-03-28 15:21:51','',''),(99,'21','228',NULL,2,'Sale Id shift 4',3852926.00,0.00,0.00,0.00,0.00,'2022-03-28 15:21:51','',''),(100,'21','228',NULL,3,'Sale Id shift 4',718861.00,0.00,0.00,0.00,0.00,'2022-03-28 15:21:51','',''),(101,'21','228',NULL,1,'Sale Id shift 4',6572644.65,0.00,0.00,0.00,0.00,'2022-03-28 15:21:51','',''),(102,'21','228','1',1,'Sale Id shift 5',0.00,0.00,0.00,6253.86,0.00,'2022-03-28 15:43:12','',''),(103,'21','228','3',2,'Sale Id shift 5',0.00,0.00,0.00,3234.09,0.00,'2022-03-28 15:43:12','',''),(104,'21','228','3',2,'Sale Id shift 5',0.00,0.00,0.00,1710.81,0.00,'2022-03-28 15:43:12','',''),(105,'21','228','4',3,'Sale Id shift 5',0.00,0.00,0.00,2365.82,0.00,'2022-03-28 15:43:12','',''),(106,'21','228','1',1,'Sale Id shift 5',0.00,0.00,0.00,4342.28,0.00,'2022-03-28 15:43:12','',''),(107,'21','228','1',1,'Sale Id shift 5',0.00,0.00,0.00,4782.98,0.00,'2022-03-28 15:43:12','',''),(108,'21','228','1',1,'Sale Id shift 5',0.00,0.00,0.00,4386.07,0.00,'2022-03-28 15:43:12','',''),(109,'21','228','1',1,'Sale Id shift 5',0.00,0.00,0.00,4620.06,0.00,'2022-03-28 15:43:12','',''),(110,'21','228','1',1,'Sale Id shift 5',0.00,0.00,0.00,4657.45,0.00,'2022-03-28 15:43:12','',''),(111,'21','228','1',1,'Sale Id shift 5',0.00,0.00,0.00,4509.24,0.00,'2022-03-28 15:43:12','',''),(112,'21','228','1',1,'Sale Id shift 5',0.00,0.00,0.00,6802.07,0.00,'2022-03-28 15:43:12','',''),(113,'21','228',NULL,2,'Sale Id shift 5',3461430.00,0.00,0.00,0.00,0.00,'2022-03-28 15:43:12','',''),(114,'21','228',NULL,3,'Sale Id shift 5',1301201.00,0.00,0.00,0.00,0.00,'2022-03-28 15:43:12','',''),(115,'21','228',NULL,1,'Sale Id shift 5',6658411.65,0.00,0.00,0.00,0.00,'2022-03-28 15:43:12','',''),(116,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-03-28 15:52:29','',''),(117,'21','228',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,40000.00,0.00,'2022-03-28 15:55:06','',''),(118,'21','228','1',1,'Received from bridging 11',0.00,0.00,40000.00,0.00,0.00,'2022-03-28 15:55:06','',''),(119,'21','228','1',1,'Sale Id shift 6',0.00,0.00,0.00,6459.52,0.00,'2022-03-28 16:39:25','',''),(120,'21','228','3',2,'Sale Id shift 6',0.00,0.00,0.00,2473.67,0.00,'2022-03-28 16:39:25','',''),(121,'21','228','3',2,'Sale Id shift 6',0.00,0.00,0.00,1620.71,0.00,'2022-03-28 16:39:25','',''),(122,'21','228','4',3,'Sale Id shift 6',0.00,0.00,0.00,2408.50,0.00,'2022-03-28 16:39:25','',''),(123,'21','228','1',1,'Sale Id shift 6',0.00,0.00,0.00,4336.74,0.00,'2022-03-28 16:39:25','',''),(124,'21','228','1',1,'Sale Id shift 6',0.00,0.00,0.00,4512.02,0.00,'2022-03-28 16:39:25','',''),(125,'21','228','1',1,'Sale Id shift 6',0.00,0.00,0.00,4357.79,0.00,'2022-03-28 16:39:25','',''),(126,'21','228','1',1,'Sale Id shift 6',0.00,0.00,0.00,4857.68,0.00,'2022-03-28 16:39:25','',''),(127,'21','228','1',1,'Sale Id shift 6',0.00,0.00,0.00,4558.58,0.00,'2022-03-28 16:39:25','',''),(128,'21','228','1',1,'Sale Id shift 6',0.00,0.00,0.00,5329.08,0.00,'2022-03-28 16:39:25','',''),(129,'21','228','1',1,'Sale Id shift 6',0.00,0.00,0.00,6091.02,0.00,'2022-03-28 16:39:25','',''),(130,'21','228',NULL,1,'Sale Id shift 6',6682900.95,0.00,0.00,0.00,0.00,'2022-03-28 16:39:25','',''),(131,'21','228',NULL,2,'Sale Id shift 6',2866066.00,0.00,0.00,0.00,0.00,'2022-03-28 16:39:25','',''),(132,'21','228',NULL,3,'Sale Id shift 6',1324675.00,0.00,0.00,0.00,0.00,'2022-03-28 16:39:25','',''),(133,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-03-28 16:43:11','',''),(134,'21','228',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,40000.00,0.00,'2022-03-28 16:45:01','',''),(135,'21','228','1',1,'Received from bridging 12',0.00,0.00,40000.00,0.00,0.00,'2022-03-28 16:45:01','',''),(136,'21','228','1',1,'Sale Id shift 7',0.00,0.00,0.00,6750.18,0.00,'2022-03-28 16:50:54','',''),(137,'21','228','3',2,'Sale Id shift 7',0.00,0.00,0.00,1220.22,0.00,'2022-03-28 16:50:54','',''),(138,'21','228','3',2,'Sale Id shift 7',0.00,0.00,0.00,234.46,0.00,'2022-03-28 16:50:54','',''),(139,'21','228','4',3,'Sale Id shift 7',0.00,0.00,0.00,1376.25,0.00,'2022-03-28 16:50:54','',''),(140,'21','228','1',1,'Sale Id shift 7',0.00,0.00,0.00,4809.60,0.00,'2022-03-28 16:50:54','',''),(141,'21','228','1',1,'Sale Id shift 7',0.00,0.00,0.00,3944.82,0.00,'2022-03-28 16:50:54','',''),(142,'21','228','1',1,'Sale Id shift 7',0.00,0.00,0.00,3548.01,0.00,'2022-03-28 16:50:54','',''),(143,'21','228','1',1,'Sale Id shift 7',0.00,0.00,0.00,4730.73,0.00,'2022-03-28 16:50:54','',''),(144,'21','228','1',1,'Sale Id shift 7',0.00,0.00,0.00,4687.19,0.00,'2022-03-28 16:50:54','',''),(145,'21','228','1',1,'Sale Id shift 7',0.00,0.00,0.00,4963.16,0.00,'2022-03-28 16:50:54','',''),(146,'21','228','1',1,'Sale Id shift 7',0.00,0.00,0.00,6646.91,0.00,'2022-03-28 16:50:54','',''),(147,'21','228',NULL,1,'Sale Id shift 7',6613299.00,0.00,0.00,0.00,0.00,'2022-03-28 16:50:54','',''),(148,'21','228',NULL,2,'Sale Id shift 7',1018276.00,0.00,0.00,0.00,0.00,'2022-03-28 16:50:54','',''),(149,'21','228',NULL,3,'Sale Id shift 7',756937.50,0.00,0.00,0.00,0.00,'2022-03-28 16:50:54','',''),(150,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-28 17:09:55','',''),(151,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,12600000.00,18000.00,0.00,0.00,'2022-03-28 17:14:28','',''),(152,'21','228',NULL,2,'Reception corrector for bridging 15',0.00,0.00,0.00,18000.00,0.00,'2022-03-28 17:16:31','',''),(153,'21','228','3',2,'Received from bridging 15',0.00,0.00,18000.00,0.00,0.00,'2022-03-28 17:16:31','',''),(154,'21','228',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,15000.00,0.00,'2022-03-28 17:16:58','',''),(155,'21','228','2',1,'Received from bridging 14',0.00,0.00,15000.00,0.00,0.00,'2022-03-28 17:16:58','',''),(156,'21','228',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,30000.00,0.00,'2022-03-28 17:16:58','',''),(157,'21','228','1',1,'Received from bridging 13',0.00,0.00,30000.00,0.00,0.00,'2022-03-28 17:16:58','',''),(158,'21','228','2',1,'Sale Id shift 8',0.00,0.00,0.00,2726.89,0.00,'2022-03-29 19:35:03','',''),(159,'21','228','2',1,'Sale Id shift 8',0.00,0.00,0.00,3260.47,0.00,'2022-03-29 19:35:03','',''),(160,'21','228','2',1,'Sale Id shift 8',0.00,0.00,0.00,2558.37,0.00,'2022-03-29 19:35:03','',''),(161,'21','228','2',1,'Sale Id shift 8',0.00,0.00,0.00,3396.70,0.00,'2022-03-29 19:35:03','',''),(162,'21','228','2',1,'Sale Id shift 8',0.00,0.00,0.00,2979.51,0.00,'2022-03-29 19:35:03','',''),(163,'21','228','1',1,'Sale Id shift 8',0.00,0.00,0.00,5095.50,0.00,'2022-03-29 19:35:03','',''),(164,'21','228','3',2,'Sale Id shift 8',0.00,0.00,0.00,2390.16,0.00,'2022-03-29 19:35:03','',''),(165,'21','228','3',2,'Sale Id shift 8',0.00,0.00,0.00,1784.66,0.00,'2022-03-29 19:35:03','',''),(166,'21','228','4',3,'Sale Id shift 8',0.00,0.00,0.00,2182.89,0.00,'2022-03-29 19:35:03','',''),(167,'21','228','1',1,'Sale Id shift 8',0.00,0.00,0.00,3188.84,0.00,'2022-03-29 19:35:03','',''),(168,'21','228','1',1,'Sale Id shift 8',0.00,0.00,0.00,3517.94,0.00,'2022-03-29 19:35:03','',''),(169,'21','228','1',1,'Sale Id shift 8',0.00,0.00,0.00,3054.15,0.00,'2022-03-29 19:35:03','',''),(170,'21','228','1',1,'Sale Id shift 8',0.00,0.00,0.00,3672.16,0.00,'2022-03-29 19:35:03','',''),(171,'21','228','1',1,'Sale Id shift 8',0.00,0.00,0.00,3116.77,0.00,'2022-03-29 19:35:03','',''),(172,'21','228','1',1,'Sale Id shift 8',0.00,0.00,0.00,3970.53,0.00,'2022-03-29 19:35:03','',''),(173,'21','228','1',1,'Sale Id shift 8',0.00,0.00,0.00,4433.18,0.00,'2022-03-29 19:35:03','',''),(174,'21','228',NULL,1,'Sale Id shift 8',7420216.65,0.00,0.00,0.00,0.00,'2022-03-29 19:35:03','',''),(175,'21','228',NULL,2,'Sale Id shift 8',2922374.00,0.00,0.00,0.00,0.00,'2022-03-29 19:35:03','',''),(176,'21','228',NULL,3,'Sale Id shift 8',1200589.50,0.00,0.00,0.00,0.00,'2022-03-29 19:35:03','',''),(177,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-03-29 20:06:54','',''),(178,'21','228',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,20000.00,0.00,'2022-03-29 20:13:29','',''),(179,'21','228','2',1,'Received from bridging 17',0.00,0.00,20000.00,0.00,0.00,'2022-03-29 20:13:29','',''),(180,'21','228',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,30000.00,0.00,'2022-03-29 20:13:29','',''),(181,'21','228','1',1,'Received from bridging 16',0.00,0.00,30000.00,0.00,0.00,'2022-03-29 20:13:29','',''),(182,'21','228','2',1,'Sale Id shift 9',0.00,0.00,0.00,4152.99,0.00,'2022-03-30 13:33:04','',''),(183,'21','228','2',1,'Sale Id shift 9',0.00,0.00,0.00,2.39,0.00,'2022-03-30 13:33:04','',''),(184,'21','228','2',1,'Sale Id shift 9',0.00,0.00,0.00,3882.69,0.00,'2022-03-30 13:33:04','',''),(185,'21','228','2',1,'Sale Id shift 9',0.00,0.00,0.00,3889.22,0.00,'2022-03-30 13:33:04','',''),(186,'21','228','2',1,'Sale Id shift 9',0.00,0.00,0.00,3740.97,0.00,'2022-03-30 13:33:04','',''),(187,'21','228','2',1,'Sale Id shift 9',0.00,0.00,0.00,0.18,0.00,'2022-03-30 13:33:04','',''),(188,'21','228','2',1,'Sale Id shift 9',0.00,0.00,0.00,4182.85,0.00,'2022-03-30 13:33:04','',''),(189,'21','228','1',1,'Sale Id shift 9',0.00,0.00,0.00,6757.69,0.00,'2022-03-30 13:33:04','',''),(190,'21','228','3',2,'Sale Id shift 9',0.00,0.00,0.00,3111.40,0.00,'2022-03-30 13:33:04','',''),(191,'21','228','3',2,'Sale Id shift 9',0.00,0.00,0.00,1560.62,0.00,'2022-03-30 13:33:04','',''),(192,'21','228','4',3,'Sale Id shift 9',0.00,0.00,0.00,1581.56,0.00,'2022-03-30 13:33:04','',''),(193,'21','228','1',1,'Sale Id shift 9',0.00,0.00,0.00,5935.54,0.00,'2022-03-30 13:33:04','',''),(194,'21','228','1',1,'Sale Id shift 9',0.00,0.00,0.00,3564.05,0.00,'2022-03-30 13:33:04','',''),(195,'21','228','1',1,'Sale Id shift 9',0.00,0.00,0.00,2144.53,0.00,'2022-03-30 13:33:04','',''),(196,'21','228','1',1,'Sale Id shift 9',0.00,0.00,0.00,5795.79,0.00,'2022-03-30 13:33:04','',''),(197,'21','228','1',1,'Sale Id shift 9',0.00,0.00,0.00,5669.38,0.00,'2022-03-30 13:33:04','',''),(198,'21','228',NULL,1,'Sale Id shift 9',8203514.55,0.00,0.00,0.00,0.00,'2022-03-30 13:33:04','',''),(199,'21','228',NULL,2,'Sale Id shift 9',3270414.00,0.00,0.00,0.00,0.00,'2022-03-30 13:33:04','',''),(200,'21','228',NULL,3,'Sale Id shift 9',869858.00,0.00,0.00,0.00,0.00,'2022-03-30 13:33:04','',''),(201,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-03-31 17:26:27','',''),(202,'21','228',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,14500.00,0.00,'2022-03-31 17:35:04','',''),(203,'21','228','2',1,'Received from bridging 19',0.00,0.00,14500.00,0.00,0.00,'2022-03-31 17:35:04','',''),(204,'21','228',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,35500.00,0.00,'2022-03-31 17:35:04','',''),(205,'21','228','1',1,'Received from bridging 18',0.00,0.00,35500.00,0.00,0.00,'2022-03-31 17:35:04','',''),(206,'21','228','2',1,'Sale Id shift 10',0.00,0.00,0.00,2755.56,0.00,'2022-03-31 17:53:46','',''),(207,'21','228','2',1,'Sale Id shift 10',0.00,0.00,0.00,2809.41,0.00,'2022-03-31 17:53:46','',''),(208,'21','228','2',1,'Sale Id shift 10',0.00,0.00,0.00,2914.42,0.00,'2022-03-31 17:53:46','',''),(209,'21','228','2',1,'Sale Id shift 10',0.00,0.00,0.00,1873.75,0.00,'2022-03-31 17:53:46','',''),(210,'21','228','2',1,'Sale Id shift 10',0.00,0.00,0.00,1319.54,0.00,'2022-03-31 17:53:46','',''),(211,'21','228','2',1,'Sale Id shift 10',0.00,0.00,0.00,2677.70,0.00,'2022-03-31 17:53:46','',''),(212,'21','228','1',1,'Sale Id shift 10',0.00,0.00,0.00,6538.20,0.00,'2022-03-31 17:53:46','',''),(213,'21','228','3',2,'Sale Id shift 10',0.00,0.00,0.00,4263.11,0.00,'2022-03-31 17:53:46','',''),(214,'21','228','3',2,'Sale Id shift 10',0.00,0.00,0.00,2367.46,0.00,'2022-03-31 17:53:46','',''),(215,'21','228','4',3,'Sale Id shift 10',0.00,0.00,0.00,1570.47,0.00,'2022-03-31 17:53:46','',''),(216,'21','228','1',1,'Sale Id shift 10',0.00,0.00,0.00,3699.97,0.00,'2022-03-31 17:53:46','',''),(217,'21','228','1',1,'Sale Id shift 10',0.00,0.00,0.00,3089.10,0.00,'2022-03-31 17:53:46','',''),(218,'21','228','1',1,'Sale Id shift 10',0.00,0.00,0.00,3815.75,0.00,'2022-03-31 17:53:46','',''),(219,'21','228','1',1,'Sale Id shift 10',0.00,0.00,0.00,4067.11,0.00,'2022-03-31 17:53:46','',''),(220,'21','228','1',1,'Sale Id shift 10',0.00,0.00,0.00,4411.14,0.00,'2022-03-31 17:53:46','',''),(221,'21','228','1',1,'Sale Id shift 10',0.00,0.00,0.00,3552.30,0.00,'2022-03-31 17:53:46','',''),(222,'21','228','1',1,'Sale Id shift 10',0.00,0.00,0.00,6268.86,0.00,'2022-03-31 17:53:46','',''),(223,'21','228',NULL,1,'Sale Id shift 10',8215813.65,0.00,0.00,0.00,0.00,'2022-03-31 17:53:46','',''),(224,'21','228',NULL,2,'Sale Id shift 10',4641399.00,0.00,0.00,0.00,0.00,'2022-03-31 17:53:46','',''),(225,'21','228',NULL,3,'Sale Id shift 10',863758.50,0.00,0.00,0.00,0.00,'2022-03-31 17:53:46','',''),(226,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,10010000.00,18200.00,0.00,0.00,'2022-03-31 18:29:43','',''),(227,'21','228',NULL,3,'Reception corrector for bridging 20',0.00,0.00,0.00,18200.00,0.00,'2022-03-31 18:33:15','',''),(228,'21','228','4',3,'Received from bridging 20',0.00,0.00,18200.00,0.00,0.00,'2022-03-31 18:33:15','',''),(229,'21','228','3',2,'Sale Id shift 11',0.00,0.00,0.00,2993.07,0.00,'2022-04-01 16:38:18','',''),(230,'21','228','3',2,'Sale Id shift 11',0.00,0.00,0.00,828.86,0.00,'2022-04-01 16:38:18','',''),(231,'21','228','4',3,'Sale Id shift 11',0.00,0.00,0.00,1300.28,0.00,'2022-04-01 16:38:18','',''),(232,'21','228',NULL,2,'Sale Id shift 11',2675351.00,0.00,0.00,0.00,0.00,'2022-04-01 16:38:18','',''),(233,'21','228',NULL,3,'Sale Id shift 11',715154.00,0.00,0.00,0.00,0.00,'2022-04-01 16:38:18','',''),(234,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,15000.00,0.00,0.00,'2022-04-02 18:20:24','',''),(235,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-02 18:26:20','',''),(236,'21','228',NULL,3,'Reception corrector for bridging 24',0.00,0.00,0.00,15000.00,0.00,'2022-04-02 18:38:22','',''),(237,'21','228','4',3,'Received from bridging 24',0.00,0.00,15000.00,0.00,0.00,'2022-04-02 18:38:22','',''),(238,'21','228',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,15000.00,0.00,'2022-04-02 18:38:51','',''),(239,'21','228','2',1,'Received from bridging 23',0.00,0.00,15000.00,0.00,0.00,'2022-04-02 18:38:51','',''),(240,'21','228',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,30000.00,0.00,'2022-04-02 18:38:51','',''),(241,'21','228','1',1,'Received from bridging 22',0.00,0.00,30000.00,0.00,0.00,'2022-04-02 18:38:51','',''),(242,'21','228','2',1,'Sale Id shift 12',0.00,0.00,0.00,2944.56,0.00,'2022-04-02 19:13:05','',''),(243,'21','228','2',1,'Sale Id shift 12',0.00,0.00,0.00,4.15,0.00,'2022-04-02 19:13:05','',''),(244,'21','228','2',1,'Sale Id shift 12',0.00,0.00,0.00,3054.81,0.00,'2022-04-02 19:13:05','',''),(245,'21','228','2',1,'Sale Id shift 12',0.00,0.00,0.00,2872.28,0.00,'2022-04-02 19:13:05','',''),(246,'21','228','2',1,'Sale Id shift 12',0.00,0.00,0.00,3097.67,0.00,'2022-04-02 19:13:05','',''),(247,'21','228','2',1,'Sale Id shift 12',0.00,0.00,0.00,0.07,0.00,'2022-04-02 19:13:05','',''),(248,'21','228','2',1,'Sale Id shift 12',0.00,0.00,0.00,2982.11,0.00,'2022-04-02 19:13:05','',''),(249,'21','228','1',1,'Sale Id shift 12',0.00,0.00,0.00,6477.15,0.00,'2022-04-02 19:13:05','',''),(250,'21','228','3',2,'Sale Id shift 12',0.00,0.00,0.00,2081.87,0.00,'2022-04-02 19:13:05','',''),(251,'21','228','3',2,'Sale Id shift 12',0.00,0.00,0.00,895.82,0.00,'2022-04-02 19:13:05','',''),(252,'21','228','4',3,'Sale Id shift 12',0.00,0.00,0.00,1294.40,0.00,'2022-04-02 19:13:05','',''),(253,'21','228','1',1,'Sale Id shift 12',0.00,0.00,0.00,5993.13,0.00,'2022-04-02 19:13:05','',''),(254,'21','228','1',1,'Sale Id shift 12',0.00,0.00,0.00,2178.81,0.00,'2022-04-02 19:13:05','',''),(255,'21','228','1',1,'Sale Id shift 12',0.00,0.00,0.00,3743.45,0.00,'2022-04-02 19:13:05','',''),(256,'21','228','1',1,'Sale Id shift 12',0.00,0.00,0.00,2566.58,0.00,'2022-04-02 19:13:05','',''),(257,'21','228','1',1,'Sale Id shift 12',0.00,0.00,0.00,3282.91,0.00,'2022-04-02 19:13:05','',''),(258,'21','228','1',1,'Sale Id shift 12',0.00,0.00,0.00,5865.59,0.00,'2022-04-02 19:13:05','',''),(259,'21','228',NULL,2,'Sale Id shift 12',2084383.00,0.00,0.00,0.00,0.00,'2022-04-02 19:13:05','',''),(260,'21','228',NULL,3,'Sale Id shift 12',711920.00,0.00,0.00,0.00,0.00,'2022-04-02 19:13:05','',''),(261,'21','228',NULL,1,'Sale Id shift 12',7435439.55,0.00,0.00,0.00,0.00,'2022-04-02 19:13:05','',''),(262,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-03 16:07:25','',''),(263,'21','228',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,40000.00,0.00,'2022-04-03 16:18:54','',''),(264,'21','228','1',1,'Received from bridging 26',0.00,0.00,40000.00,0.00,0.00,'2022-04-03 16:18:54','',''),(265,'21','228','1',1,'Sale Id shift 13',0.00,0.00,0.00,6154.78,0.00,'2022-04-03 18:20:13','',''),(266,'21','228','3',2,'Sale Id shift 13',0.00,0.00,0.00,2438.22,0.00,'2022-04-03 18:20:13','',''),(267,'21','228','3',2,'Sale Id shift 13',0.00,0.00,0.00,997.04,0.00,'2022-04-03 18:20:13','',''),(268,'21','228','4',3,'Sale Id shift 13',0.00,0.00,0.00,2333.31,0.00,'2022-04-03 18:20:13','',''),(269,'21','228','1',1,'Sale Id shift 13',0.00,0.00,0.00,4515.13,0.00,'2022-04-03 18:20:13','',''),(270,'21','228','1',1,'Sale Id shift 13',0.00,0.00,0.00,4544.93,0.00,'2022-04-03 18:20:13','',''),(271,'21','228','1',1,'Sale Id shift 13',0.00,0.00,0.00,4157.17,0.00,'2022-04-03 18:20:13','',''),(272,'21','228','1',1,'Sale Id shift 13',0.00,0.00,0.00,5601.60,0.00,'2022-04-03 18:20:13','',''),(273,'21','228','1',1,'Sale Id shift 13',0.00,0.00,0.00,4520.37,0.00,'2022-04-03 18:20:13','',''),(274,'21','228','1',1,'Sale Id shift 13',0.00,0.00,0.00,4440.27,0.00,'2022-04-03 18:20:13','',''),(275,'21','228','1',1,'Sale Id shift 13',0.00,0.00,0.00,6378.46,0.00,'2022-04-03 18:20:13','',''),(276,'21','228',NULL,2,'Sale Id shift 13',2404682.00,0.00,0.00,0.00,0.00,'2022-04-03 18:20:13','',''),(277,'21','228',NULL,3,'Sale Id shift 13',1283320.50,0.00,0.00,0.00,0.00,'2022-04-03 18:20:13','',''),(278,'21','228',NULL,1,'Sale Id shift 13',6651597.15,0.00,0.00,0.00,0.00,'2022-04-03 18:20:13','',''),(279,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-04 12:07:26','',''),(280,'21','228',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,45000.00,0.00,'2022-04-04 12:10:33','',''),(281,'21','228','1',1,'Received from bridging 27',0.00,0.00,45000.00,0.00,0.00,'2022-04-04 12:10:33','',''),(282,'21','228','1',1,'Sale Id shift 14',0.00,0.00,0.00,6565.58,0.00,'2022-04-04 12:27:37','',''),(283,'21','228','3',2,'Sale Id shift 14',0.00,0.00,0.00,1723.33,0.00,'2022-04-04 12:27:37','',''),(284,'21','228','4',3,'Sale Id shift 14',0.00,0.00,0.00,1334.94,0.00,'2022-04-04 12:27:37','',''),(285,'21','228','1',1,'Sale Id shift 14',0.00,0.00,0.00,4961.65,0.00,'2022-04-04 12:27:37','',''),(286,'21','228','1',1,'Sale Id shift 14',0.00,0.00,0.00,5266.90,0.00,'2022-04-04 12:27:37','',''),(287,'21','228','1',1,'Sale Id shift 14',0.00,0.00,0.00,4945.34,0.00,'2022-04-04 12:27:37','',''),(288,'21','228','1',1,'Sale Id shift 14',0.00,0.00,0.00,5189.84,0.00,'2022-04-04 12:27:37','',''),(289,'21','228','1',1,'Sale Id shift 14',0.00,0.00,0.00,4628.54,0.00,'2022-04-04 12:27:37','',''),(290,'21','228','1',1,'Sale Id shift 14',0.00,0.00,0.00,6129.57,0.00,'2022-04-04 12:27:37','',''),(291,'21','228','1',1,'Sale Id shift 14',0.00,0.00,0.00,7193.10,0.00,'2022-04-04 12:27:37','',''),(292,'21','228',NULL,2,'Sale Id shift 14',1206331.00,0.00,0.00,0.00,0.00,'2022-04-04 12:27:37','',''),(293,'21','228',NULL,3,'Sale Id shift 14',734217.00,0.00,0.00,0.00,0.00,'2022-04-04 12:27:37','',''),(294,'21','228',NULL,1,'Sale Id shift 14',7405285.80,0.00,0.00,0.00,0.00,'2022-04-04 12:27:37','',''),(295,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-04 13:05:38','',''),(296,'21','228',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,45000.00,0.00,'2022-04-04 13:07:41','',''),(297,'21','228','1',1,'Received from bridging 28',0.00,0.00,45000.00,0.00,0.00,'2022-04-04 13:07:41','',''),(298,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,31500000.00,45000.00,0.00,0.00,'2022-04-04 13:08:00','',''),(299,'21','228',NULL,2,'Reception corrector for bridging 29',0.00,0.00,0.00,45000.00,0.00,'2022-04-06 13:59:26','',''),(300,'21','228','3',2,'Received from bridging 29',0.00,0.00,45000.00,0.00,0.00,'2022-04-06 13:59:26','',''),(301,'21','228','1',1,'Sale Id shift 15',0.00,0.00,0.00,7472.04,0.00,'2022-04-06 15:27:21','',''),(302,'21','228','3',2,'Sale Id shift 15',0.00,0.00,0.00,3640.78,0.00,'2022-04-06 15:27:22','',''),(303,'21','228','3',2,'Sale Id shift 15',0.00,0.00,0.00,1608.40,0.00,'2022-04-06 15:27:22','',''),(304,'21','228','4',3,'Sale Id shift 15',0.00,0.00,0.00,1276.47,0.00,'2022-04-06 15:27:22','',''),(305,'21','228','1',1,'Sale Id shift 15',0.00,0.00,0.00,5332.62,0.00,'2022-04-06 15:27:22','',''),(306,'21','228','1',1,'Sale Id shift 15',0.00,0.00,0.00,4716.00,0.00,'2022-04-06 15:27:22','',''),(307,'21','228','1',1,'Sale Id shift 15',0.00,0.00,0.00,4146.31,0.00,'2022-04-06 15:27:22','',''),(308,'21','228','1',1,'Sale Id shift 15',0.00,0.00,0.00,6040.46,0.00,'2022-04-06 15:27:22','',''),(309,'21','228','1',1,'Sale Id shift 15',0.00,0.00,0.00,4852.73,0.00,'2022-04-06 15:27:22','',''),(310,'21','228','1',1,'Sale Id shift 15',0.00,0.00,0.00,6214.29,0.00,'2022-04-06 15:27:22','',''),(311,'21','228','1',1,'Sale Id shift 15',0.00,0.00,0.00,6473.10,0.00,'2022-04-06 15:27:22','',''),(312,'21','228',NULL,1,'Sale Id shift 15',7465845.75,0.00,0.00,0.00,0.00,'2022-04-06 15:27:22','',''),(313,'21','228',NULL,2,'Sale Id shift 15',3674426.00,0.00,0.00,0.00,0.00,'2022-04-06 15:27:22','',''),(314,'21','228',NULL,3,'Sale Id shift 15',702058.50,0.00,0.00,0.00,0.00,'2022-04-06 15:27:22','',''),(315,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-06 15:34:47','',''),(316,'21','228',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,20000.00,0.00,'2022-04-06 15:39:52','',''),(317,'21','228','2',1,'Received from bridging 31',0.00,0.00,20000.00,0.00,0.00,'2022-04-06 15:39:52','',''),(318,'21','228',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,40000.00,0.00,'2022-04-06 15:39:52','',''),(319,'21','228','1',1,'Received from bridging 30',0.00,0.00,40000.00,0.00,0.00,'2022-04-06 15:39:52','',''),(320,'21','228','2',1,'Sale Id shift 16',0.00,0.00,0.00,5504.52,0.00,'2022-04-07 15:52:24','',''),(321,'21','228','2',1,'Sale Id shift 16',0.00,0.00,0.00,2982.33,0.00,'2022-04-07 15:52:24','',''),(322,'21','228','2',1,'Sale Id shift 16',0.00,0.00,0.00,2749.96,0.00,'2022-04-07 15:52:24','',''),(323,'21','228','2',1,'Sale Id shift 16',0.00,0.00,0.00,3544.06,0.00,'2022-04-07 15:52:24','',''),(324,'21','228','2',1,'Sale Id shift 16',0.00,0.00,0.00,5105.06,0.00,'2022-04-07 15:52:24','',''),(325,'21','228','1',1,'Sale Id shift 16',0.00,0.00,0.00,7390.58,0.00,'2022-04-07 15:52:24','',''),(326,'21','228','3',2,'Sale Id shift 16',0.00,0.00,0.00,3837.38,0.00,'2022-04-07 15:52:24','',''),(327,'21','228','3',2,'Sale Id shift 16',0.00,0.00,0.00,909.54,0.00,'2022-04-07 15:52:24','',''),(328,'21','228','4',3,'Sale Id shift 16',0.00,0.00,0.00,1300.58,0.00,'2022-04-07 15:52:24','',''),(329,'21','228','1',1,'Sale Id shift 16',0.00,0.00,0.00,6657.29,0.00,'2022-04-07 15:52:24','',''),(330,'21','228','1',1,'Sale Id shift 16',0.00,0.00,0.00,54.57,0.00,'2022-04-07 15:52:24','',''),(331,'21','228','1',1,'Sale Id shift 16',0.00,0.00,0.00,4846.93,0.00,'2022-04-07 15:52:24','',''),(332,'21','228','1',1,'Sale Id shift 16',0.00,0.00,0.00,4634.99,0.00,'2022-04-07 15:52:24','',''),(333,'21','228','1',1,'Sale Id shift 16',0.00,0.00,0.00,4707.08,0.00,'2022-04-07 15:52:24','',''),(334,'21','228','1',1,'Sale Id shift 16',0.00,0.00,0.00,5170.16,0.00,'2022-04-07 15:52:24','',''),(335,'21','228','1',1,'Sale Id shift 16',0.00,0.00,0.00,6228.93,0.00,'2022-04-07 15:52:24','',''),(336,'21','228',NULL,2,'Sale Id shift 16',3322844.00,0.00,0.00,0.00,0.00,'2022-04-07 15:52:24','',''),(337,'21','228',NULL,3,'Sale Id shift 16',715319.00,0.00,0.00,0.00,0.00,'2022-04-07 15:52:24','',''),(338,'21','228',NULL,1,'Sale Id shift 16',9830115.90,0.00,0.00,0.00,0.00,'2022-04-07 15:52:24','',''),(339,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-07 16:10:19','',''),(340,'21','228',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,20000.00,0.00,'2022-04-07 16:12:57','',''),(341,'21','228','2',1,'Received from bridging 33',0.00,0.00,20000.00,0.00,0.00,'2022-04-07 16:12:57','',''),(342,'21','228',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,30000.00,0.00,'2022-04-07 16:12:58','',''),(343,'21','228','1',1,'Received from bridging 32',0.00,0.00,30000.00,0.00,0.00,'2022-04-07 16:12:58','',''),(344,'21','228','2',1,'Sale Id shift 17',0.00,0.00,0.00,3838.28,0.00,'2022-04-07 18:33:28','',''),(345,'21','228','2',1,'Sale Id shift 17',0.00,0.00,0.00,2838.04,0.00,'2022-04-07 18:33:28','',''),(346,'21','228','2',1,'Sale Id shift 17',0.00,0.00,0.00,3287.10,0.00,'2022-04-07 18:33:28','',''),(347,'21','228','2',1,'Sale Id shift 17',0.00,0.00,0.00,2291.47,0.00,'2022-04-07 18:33:28','',''),(348,'21','228','2',1,'Sale Id shift 17',0.00,0.00,0.00,2270.32,0.00,'2022-04-07 18:33:28','',''),(349,'21','228','2',1,'Sale Id shift 17',0.00,0.00,0.00,2930.53,0.00,'2022-04-07 18:33:28','',''),(350,'21','228','1',1,'Sale Id shift 17',0.00,0.00,0.00,5977.39,0.00,'2022-04-07 18:33:28','',''),(351,'21','228','2',1,'Sale Id shift 17',0.00,0.00,0.00,2677.27,0.00,'2022-04-07 18:33:28','',''),(352,'21','228','3',2,'Sale Id shift 17',0.00,0.00,0.00,3476.14,0.00,'2022-04-07 18:33:28','',''),(353,'21','228','3',2,'Sale Id shift 17',0.00,0.00,0.00,21.18,0.00,'2022-04-07 18:33:28','',''),(354,'21','228','3',2,'Sale Id shift 17',0.00,0.00,0.00,10360.55,0.00,'2022-04-07 18:33:28','',''),(355,'21','228','4',3,'Sale Id shift 17',0.00,0.00,0.00,0.16,0.00,'2022-04-07 18:33:28','',''),(356,'21','228','4',3,'Sale Id shift 17',0.00,0.00,0.00,1455.04,0.00,'2022-04-07 18:33:28','',''),(357,'21','228','1',1,'Sale Id shift 17',0.00,0.00,0.00,4290.20,0.00,'2022-04-07 18:33:28','',''),(358,'21','228','1',1,'Sale Id shift 17',0.00,0.00,0.00,1148.88,0.00,'2022-04-07 18:33:28','',''),(359,'21','228','1',1,'Sale Id shift 17',0.00,0.00,0.00,3938.05,0.00,'2022-04-07 18:33:28','',''),(360,'21','228','1',1,'Sale Id shift 17',0.00,0.00,0.00,2911.54,0.00,'2022-04-07 18:33:28','',''),(361,'21','228','1',1,'Sale Id shift 17',0.00,0.00,0.00,3235.13,0.00,'2022-04-07 18:33:28','',''),(362,'21','228','1',1,'Sale Id shift 17',0.00,0.00,0.00,4151.21,0.00,'2022-04-07 18:33:28','',''),(363,'21','228','1',1,'Sale Id shift 17',0.00,0.00,0.00,4355.37,0.00,'2022-04-07 18:33:28','',''),(364,'21','228',NULL,2,'Sale Id shift 17',9700509.00,0.00,0.00,0.00,0.00,'2022-04-07 18:33:28','',''),(365,'21','228',NULL,3,'Sale Id shift 17',800360.00,0.00,0.00,0.00,0.00,'2022-04-07 18:33:28','',''),(366,'21','228',NULL,1,'Sale Id shift 17',8273228.70,0.00,0.00,0.00,0.00,'2022-04-07 18:33:28','',''),(367,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-08 12:23:01','',''),(368,'21','228',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,45000.00,0.00,'2022-04-08 12:24:23','',''),(369,'21','228','1',1,'Received from bridging 34',0.00,0.00,45000.00,0.00,0.00,'2022-04-08 12:24:23','',''),(370,'21','228','1',1,'Sale Id shift 18',0.00,0.00,0.00,7092.59,0.00,'2022-04-08 12:44:47','',''),(371,'21','228','3',2,'Sale Id shift 18',0.00,0.00,0.00,3142.59,0.00,'2022-04-08 12:44:47','',''),(372,'21','228','3',2,'Sale Id shift 18',0.00,0.00,0.00,10650.25,0.00,'2022-04-08 12:44:47','',''),(373,'21','228','4',3,'Sale Id shift 18',0.00,0.00,0.00,746.32,0.00,'2022-04-08 12:44:47','',''),(374,'21','228','1',1,'Sale Id shift 18',0.00,0.00,0.00,6273.82,0.00,'2022-04-08 12:44:47','',''),(375,'21','228','1',1,'Sale Id shift 18',0.00,0.00,0.00,3294.84,0.00,'2022-04-08 12:44:47','',''),(376,'21','228','1',1,'Sale Id shift 18',0.00,0.00,0.00,4443.72,0.00,'2022-04-08 12:44:47','',''),(377,'21','228','1',1,'Sale Id shift 18',0.00,0.00,0.00,5074.02,0.00,'2022-04-08 12:44:47','',''),(378,'21','228','1',1,'Sale Id shift 18',0.00,0.00,0.00,5856.74,0.00,'2022-04-08 12:44:47','',''),(379,'21','228','1',1,'Sale Id shift 18',0.00,0.00,0.00,6865.66,0.00,'2022-04-08 12:44:47','',''),(380,'21','228','1',1,'Sale Id shift 18',0.00,0.00,0.00,6184.63,0.00,'2022-04-08 12:44:47','',''),(381,'21','228',NULL,2,'Sale Id shift 18',9654988.00,0.00,0.00,0.00,0.00,'2022-04-08 12:44:47','',''),(382,'21','228',NULL,3,'Sale Id shift 18',410476.00,0.00,0.00,0.00,0.00,'2022-04-08 12:44:47','',''),(383,'21','228',NULL,1,'Sale Id shift 18',7439193.30,0.00,0.00,0.00,0.00,'2022-04-08 12:44:47','',''),(384,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-09 16:41:56','',''),(385,'21','228',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,20000.00,0.00,'2022-04-09 16:43:36','',''),(386,'21','228','2',1,'Received from bridging 36',0.00,0.00,20000.00,0.00,0.00,'2022-04-09 16:43:36','',''),(387,'21','228',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,30000.00,0.00,'2022-04-09 16:43:36','',''),(388,'21','228','1',1,'Received from bridging 35',0.00,0.00,30000.00,0.00,0.00,'2022-04-09 16:43:36','',''),(389,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,11550000.00,16500.00,0.00,0.00,'2022-04-09 16:43:46','',''),(390,'21','228',NULL,2,'Reception corrector for bridging 37',0.00,0.00,0.00,16500.00,0.00,'2022-04-09 16:45:09','',''),(391,'21','228','3',2,'Received from bridging 37',0.00,0.00,16500.00,0.00,0.00,'2022-04-09 16:45:09','',''),(392,'21','228','2',1,'Sale Id shift 20',0.00,0.00,0.00,3342.46,0.00,'2022-04-10 19:55:18','',''),(393,'21','228','2',1,'Sale Id shift 20',0.00,0.00,0.00,1.11,0.00,'2022-04-10 19:55:18','',''),(394,'21','228','2',1,'Sale Id shift 20',0.00,0.00,0.00,3134.91,0.00,'2022-04-10 19:55:18','',''),(395,'21','228','2',1,'Sale Id shift 20',0.00,0.00,0.00,2683.66,0.00,'2022-04-10 19:55:18','',''),(396,'21','228','2',1,'Sale Id shift 20',0.00,0.00,0.00,2839.95,0.00,'2022-04-10 19:55:18','',''),(397,'21','228','2',1,'Sale Id shift 20',0.00,0.00,0.00,3112.63,0.00,'2022-04-10 19:55:18','',''),(398,'21','228','2',1,'Sale Id shift 20',0.00,0.00,0.00,2159.70,0.00,'2022-04-10 19:55:18','',''),(399,'21','228','1',1,'Sale Id shift 20',0.00,0.00,0.00,5310.12,0.00,'2022-04-10 19:55:18','',''),(400,'21','228','2',1,'Sale Id shift 20',0.00,0.00,0.00,2681.80,0.00,'2022-04-10 19:55:18','',''),(401,'21','228','3',2,'Sale Id shift 20',0.00,0.00,0.00,3169.88,0.00,'2022-04-10 19:55:18','',''),(402,'21','228','3',2,'Sale Id shift 20',0.00,0.00,0.00,1317.62,0.00,'2022-04-10 19:55:18','',''),(403,'21','228','4',3,'Sale Id shift 20',0.00,0.00,0.00,1699.56,0.00,'2022-04-10 19:55:18','',''),(404,'21','228','1',1,'Sale Id shift 20',0.00,0.00,0.00,4333.90,0.00,'2022-04-10 19:55:18','',''),(405,'21','228','1',1,'Sale Id shift 20',0.00,0.00,0.00,2420.38,0.00,'2022-04-10 19:55:18','',''),(406,'21','228','1',1,'Sale Id shift 20',0.00,0.00,0.00,3075.72,0.00,'2022-04-10 19:55:18','',''),(407,'21','228','1',1,'Sale Id shift 20',0.00,0.00,0.00,3751.14,0.00,'2022-04-10 19:55:18','',''),(408,'21','228','1',1,'Sale Id shift 20',0.00,0.00,0.00,2695.20,0.00,'2022-04-10 19:55:18','',''),(409,'21','228','1',1,'Sale Id shift 20',0.00,0.00,0.00,3894.42,0.00,'2022-04-10 19:55:18','',''),(410,'21','228','1',1,'Sale Id shift 20',0.00,0.00,0.00,4498.84,0.00,'2022-04-10 19:55:18','',''),(411,'21','228',NULL,1,'Sale Id shift 20',8239430.10,0.00,0.00,0.00,0.00,'2022-04-10 19:55:18','',''),(412,'21','228',NULL,2,'Sale Id shift 20',3141250.00,0.00,0.00,0.00,0.00,'2022-04-10 19:55:18','',''),(413,'21','228',NULL,3,'Sale Id shift 20',934758.00,0.00,0.00,0.00,0.00,'2022-04-10 19:55:18','',''),(414,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-11 10:52:19','',''),(415,'21','228',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,45000.00,0.00,'2022-04-11 10:56:01','',''),(416,'21','228','1',1,'Received from bridging 38',0.00,0.00,45000.00,0.00,0.00,'2022-04-11 10:56:01','',''),(417,'21','228','1',1,'Sale Id shift 21',0.00,0.00,0.00,7134.08,0.00,'2022-04-11 11:20:36','',''),(418,'21','228','3',2,'Sale Id shift 21',0.00,0.00,0.00,3514.51,0.00,'2022-04-11 11:20:36','',''),(419,'21','228','3',2,'Sale Id shift 21',0.00,0.00,0.00,1773.97,0.00,'2022-04-11 11:20:36','',''),(420,'21','228','4',3,'Sale Id shift 21',0.00,0.00,0.00,1791.02,0.00,'2022-04-11 11:20:36','',''),(421,'21','228','1',1,'Sale Id shift 21',0.00,0.00,0.00,5307.23,0.00,'2022-04-11 11:20:36','',''),(422,'21','228','1',1,'Sale Id shift 21',0.00,0.00,0.00,4217.72,0.00,'2022-04-11 11:20:36','',''),(423,'21','228','1',1,'Sale Id shift 21',0.00,0.00,0.00,3926.68,0.00,'2022-04-11 11:20:36','',''),(424,'21','228','1',1,'Sale Id shift 21',0.00,0.00,0.00,5323.16,0.00,'2022-04-11 11:20:36','',''),(425,'21','228','1',1,'Sale Id shift 21',0.00,0.00,0.00,5461.98,0.00,'2022-04-11 11:20:36','',''),(426,'21','228','1',1,'Sale Id shift 21',0.00,0.00,0.00,5791.47,0.00,'2022-04-11 11:20:36','',''),(427,'21','228','1',1,'Sale Id shift 21',0.00,0.00,0.00,8042.94,0.00,'2022-04-11 11:20:36','',''),(428,'21','228',NULL,1,'Sale Id shift 21',7458867.90,0.00,0.00,0.00,0.00,'2022-04-11 11:20:36','',''),(429,'21','228',NULL,2,'Sale Id shift 21',3701936.00,0.00,0.00,0.00,0.00,'2022-04-11 11:20:36','',''),(430,'21','228',NULL,3,'Sale Id shift 21',985061.00,0.00,0.00,0.00,0.00,'2022-04-11 11:20:36','',''),(431,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-11 17:56:50','',''),(432,'21','228',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,20000.00,0.00,'2022-04-11 17:58:29','',''),(433,'21','228','2',1,'Received from bridging 40',0.00,0.00,20000.00,0.00,0.00,'2022-04-11 17:58:29','',''),(434,'21','228',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,40000.00,0.00,'2022-04-11 17:58:29','',''),(435,'21','228','1',1,'Received from bridging 39',0.00,0.00,40000.00,0.00,0.00,'2022-04-11 17:58:29','',''),(436,'21','228','2',1,'Sale Id shift 23',0.00,0.00,0.00,3217.06,0.00,'2022-04-14 15:34:47','',''),(437,'21','228','2',1,'Sale Id shift 23',0.00,0.00,0.00,3095.94,0.00,'2022-04-14 15:34:47','',''),(438,'21','228','2',1,'Sale Id shift 23',0.00,0.00,0.00,2964.80,0.00,'2022-04-14 15:34:47','',''),(439,'21','228','2',1,'Sale Id shift 23',0.00,0.00,0.00,2765.91,0.00,'2022-04-14 15:34:47','',''),(440,'21','228','2',1,'Sale Id shift 23',0.00,0.00,0.00,2443.56,0.00,'2022-04-14 15:34:47','',''),(441,'21','228','2',1,'Sale Id shift 23',0.00,0.00,0.00,2980.99,0.00,'2022-04-14 15:34:47','',''),(442,'21','228','1',1,'Sale Id shift 23',0.00,0.00,0.00,6808.09,0.00,'2022-04-14 15:34:47','',''),(443,'21','228','2',1,'Sale Id shift 23',0.00,0.00,0.00,2478.01,0.00,'2022-04-14 15:34:47','',''),(444,'21','228','3',2,'Sale Id shift 23',0.00,0.00,0.00,1585.16,0.00,'2022-04-14 15:34:47','',''),(445,'21','228','3',2,'Sale Id shift 23',0.00,0.00,0.00,466.63,0.00,'2022-04-14 15:34:47','',''),(446,'21','228','4',3,'Sale Id shift 23',0.00,0.00,0.00,977.08,0.00,'2022-04-14 15:34:47','',''),(447,'21','228','1',1,'Sale Id shift 23',0.00,0.00,0.00,5643.22,0.00,'2022-04-14 15:34:47','',''),(448,'21','228','1',1,'Sale Id shift 23',0.00,0.00,0.00,1774.41,0.00,'2022-04-14 15:34:47','',''),(449,'21','228','1',1,'Sale Id shift 23',0.00,0.00,0.00,3956.74,0.00,'2022-04-14 15:34:47','',''),(450,'21','228','1',1,'Sale Id shift 23',0.00,0.00,0.00,4971.21,0.00,'2022-04-14 15:34:47','',''),(451,'21','228','1',1,'Sale Id shift 23',0.00,0.00,0.00,4965.55,0.00,'2022-04-14 15:34:47','',''),(452,'21','228','1',1,'Sale Id shift 23',0.00,0.00,0.00,5072.72,0.00,'2022-04-14 15:34:47','',''),(453,'21','228','1',1,'Sale Id shift 23',0.00,0.00,0.00,6753.74,0.00,'2022-04-14 15:34:47','',''),(454,'21','228',NULL,1,'Sale Id shift 23',9882171.75,0.00,0.00,0.00,0.00,'2022-04-14 15:34:47','',''),(455,'21','228',NULL,2,'Sale Id shift 23',1436253.00,0.00,0.00,0.00,0.00,'2022-04-14 15:34:48','',''),(456,'21','228',NULL,3,'Sale Id shift 23',537394.00,0.00,0.00,0.00,0.00,'2022-04-14 15:34:48','',''),(457,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-14 15:40:32','',''),(458,'21','228',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,45000.00,0.00,'2022-04-14 15:42:00','',''),(459,'21','228','1',1,'Received from bridging 41',0.00,0.00,45000.00,0.00,0.00,'2022-04-14 15:42:00','',''),(460,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6591750.00,39950.00,0.00,0.00,'2022-04-15 13:33:29','',''),(461,'21','228',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,39950.00,0.00,'2022-04-15 13:39:28','',''),(462,'21','228','1',1,'Received from bridging 43',0.00,0.00,39950.00,0.00,0.00,'2022-04-15 13:39:28','',''),(463,'21','228','1',1,'Sale Id shift 24',0.00,0.00,0.00,7263.91,0.00,'2022-04-15 14:05:17','',''),(464,'21','228','3',2,'Sale Id shift 24',0.00,0.00,0.00,2998.52,0.00,'2022-04-15 14:05:17','',''),(465,'21','228','3',2,'Sale Id shift 24',0.00,0.00,0.00,1544.40,0.00,'2022-04-15 14:05:17','',''),(466,'21','228','4',3,'Sale Id shift 24',0.00,0.00,0.00,1077.28,0.00,'2022-04-15 14:05:17','',''),(467,'21','228','1',1,'Sale Id shift 24',0.00,0.00,0.00,4839.99,0.00,'2022-04-15 14:05:17','',''),(468,'21','228','1',1,'Sale Id shift 24',0.00,0.00,0.00,5071.44,0.00,'2022-04-15 14:05:17','',''),(469,'21','228','1',1,'Sale Id shift 24',0.00,0.00,0.00,4645.67,0.00,'2022-04-15 14:05:17','',''),(470,'21','228','1',1,'Sale Id shift 24',0.00,0.00,0.00,5209.37,0.00,'2022-04-15 14:05:17','',''),(471,'21','228','1',1,'Sale Id shift 24',0.00,0.00,0.00,5173.17,0.00,'2022-04-15 14:05:17','',''),(472,'21','228','1',1,'Sale Id shift 24',0.00,0.00,0.00,5589.57,0.00,'2022-04-15 14:05:17','',''),(473,'21','228','1',1,'Sale Id shift 24',0.00,0.00,0.00,7632.39,0.00,'2022-04-15 14:05:17','',''),(474,'21','228',NULL,1,'Sale Id shift 24',7495209.15,0.00,0.00,0.00,0.00,'2022-04-15 14:05:17','',''),(475,'21','228',NULL,2,'Sale Id shift 24',3180044.00,0.00,0.00,0.00,0.00,'2022-04-15 14:05:17','',''),(476,'21','228',NULL,3,'Sale Id shift 24',592504.00,0.00,0.00,0.00,0.00,'2022-04-15 14:05:17','',''),(477,'21','228','1',1,'Sale Id shift 25',0.00,0.00,0.00,5849.64,0.00,'2022-04-15 14:32:19','',''),(478,'21','228','3',2,'Sale Id shift 25',0.00,0.00,0.00,2490.38,0.00,'2022-04-15 14:32:19','',''),(479,'21','228','3',2,'Sale Id shift 25',0.00,0.00,0.00,1031.14,0.00,'2022-04-15 14:32:19','',''),(480,'21','228','4',3,'Sale Id shift 25',0.00,0.00,0.00,1785.03,0.00,'2022-04-15 14:32:19','',''),(481,'21','228','1',1,'Sale Id shift 25',0.00,0.00,0.00,4125.77,0.00,'2022-04-15 14:32:19','',''),(482,'21','228','1',1,'Sale Id shift 25',0.00,0.00,0.00,5070.16,0.00,'2022-04-15 14:32:19','',''),(483,'21','228','1',1,'Sale Id shift 25',0.00,0.00,0.00,4268.41,0.00,'2022-04-15 14:32:19','',''),(484,'21','228','1',1,'Sale Id shift 25',0.00,0.00,0.00,4273.67,0.00,'2022-04-15 14:32:19','',''),(485,'21','228','1',1,'Sale Id shift 25',0.00,0.00,0.00,4061.19,0.00,'2022-04-15 14:32:19','',''),(486,'21','228','1',1,'Sale Id shift 25',0.00,0.00,0.00,5137.19,0.00,'2022-04-15 14:32:19','',''),(487,'21','228','1',1,'Sale Id shift 25',0.00,0.00,0.00,6882.61,0.00,'2022-04-15 14:32:19','',''),(488,'21','228',NULL,1,'Sale Id shift 25',6545325.60,0.00,0.00,0.00,0.00,'2022-04-15 14:32:19','',''),(489,'21','228',NULL,2,'Sale Id shift 25',2465064.00,0.00,0.00,0.00,0.00,'2022-04-15 14:32:19','',''),(490,'21','228',NULL,3,'Sale Id shift 25',981766.50,0.00,0.00,0.00,0.00,'2022-04-15 14:32:19','',''),(491,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-15 14:41:23','',''),(492,'21','228',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,40000.00,0.00,'2022-04-15 14:45:03','',''),(493,'21','228','1',1,'Received from bridging 44',0.00,0.00,40000.00,0.00,0.00,'2022-04-15 14:45:03','',''),(494,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,21000000.00,30000.00,0.00,0.00,'2022-04-15 14:45:27','',''),(495,'21','228',NULL,2,'Reception corrector for bridging 45',0.00,0.00,0.00,30000.00,0.00,'2022-04-15 14:47:13','',''),(496,'21','228','3',2,'Received from bridging 45',0.00,0.00,30000.00,0.00,0.00,'2022-04-15 14:47:13','',''),(497,'21','228','1',1,'Sale Id shift 26',0.00,0.00,0.00,6614.15,0.00,'2022-04-15 16:13:45','',''),(498,'21','228','3',2,'Sale Id shift 26',0.00,0.00,0.00,3178.40,0.00,'2022-04-15 16:13:45','',''),(499,'21','228','3',2,'Sale Id shift 26',0.00,0.00,0.00,1373.90,0.00,'2022-04-15 16:13:45','',''),(500,'21','228','4',3,'Sale Id shift 26',0.00,0.00,0.00,890.51,0.00,'2022-04-15 16:13:45','',''),(501,'21','228','1',1,'Sale Id shift 26',0.00,0.00,0.00,4067.25,0.00,'2022-04-15 16:13:45','',''),(502,'21','228','1',1,'Sale Id shift 26',0.00,0.00,0.00,4524.85,0.00,'2022-04-15 16:13:45','',''),(503,'21','228','1',1,'Sale Id shift 26',0.00,0.00,0.00,3268.15,0.00,'2022-04-15 16:13:45','',''),(504,'21','228','1',1,'Sale Id shift 26',0.00,0.00,0.00,5209.86,0.00,'2022-04-15 16:13:45','',''),(505,'21','228','1',1,'Sale Id shift 26',0.00,0.00,0.00,4171.21,0.00,'2022-04-15 16:13:45','',''),(506,'21','228','1',1,'Sale Id shift 26',0.00,0.00,0.00,5176.39,0.00,'2022-04-15 16:13:45','',''),(507,'21','228','1',1,'Sale Id shift 26',0.00,0.00,0.00,6645.62,0.00,'2022-04-15 16:13:45','',''),(508,'21','228',NULL,1,'Sale Id shift 26',6546784.20,0.00,0.00,0.00,0.00,'2022-04-15 16:13:45','',''),(509,'21','228',NULL,2,'Sale Id shift 26',3186610.00,0.00,0.00,0.00,0.00,'2022-04-15 16:13:45','',''),(510,'21','228',NULL,3,'Sale Id shift 26',489780.50,0.00,0.00,0.00,0.00,'2022-04-15 16:13:45','',''),(511,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-15 16:16:47','',''),(512,'21','228',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,14000.00,0.00,'2022-04-15 16:19:50','',''),(513,'21','228','2',1,'Received from bridging 47',0.00,0.00,14000.00,0.00,0.00,'2022-04-15 16:19:50','',''),(514,'21','228',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,36000.00,0.00,'2022-04-15 16:19:50','',''),(515,'21','228','1',1,'Received from bridging 46',0.00,0.00,36000.00,0.00,0.00,'2022-04-15 16:19:50','',''),(516,'21','228','2',1,'Sale Id shift 27',0.00,0.00,0.00,2661.63,0.00,'2022-04-15 16:31:54','',''),(517,'21','228','2',1,'Sale Id shift 27',0.00,0.00,0.00,2242.24,0.00,'2022-04-15 16:31:54','',''),(518,'21','228','2',1,'Sale Id shift 27',0.00,0.00,0.00,2115.38,0.00,'2022-04-15 16:31:54','',''),(519,'21','228','2',1,'Sale Id shift 27',0.00,0.00,0.00,2270.16,0.00,'2022-04-15 16:31:54','',''),(520,'21','228','2',1,'Sale Id shift 27',0.00,0.00,0.00,1218.82,0.00,'2022-04-15 16:31:54','',''),(521,'21','228','2',1,'Sale Id shift 27',0.00,0.00,0.00,1845.77,0.00,'2022-04-15 16:31:54','',''),(522,'21','228','1',1,'Sale Id shift 27',0.00,0.00,0.00,6545.69,0.00,'2022-04-15 16:31:54','',''),(523,'21','228','2',1,'Sale Id shift 27',0.00,0.00,0.00,1717.51,0.00,'2022-04-15 16:31:54','',''),(524,'21','228','3',2,'Sale Id shift 27',0.00,0.00,0.00,2891.62,0.00,'2022-04-15 16:31:54','',''),(525,'21','228','3',2,'Sale Id shift 27',0.00,0.00,0.00,652.36,0.00,'2022-04-15 16:31:54','',''),(526,'21','228','4',3,'Sale Id shift 27',0.00,0.00,0.00,1460.28,0.00,'2022-04-15 16:31:54','',''),(527,'21','228','1',1,'Sale Id shift 27',0.00,0.00,0.00,3973.42,0.00,'2022-04-15 16:31:54','',''),(528,'21','228','1',1,'Sale Id shift 27',0.00,0.00,0.00,3837.37,0.00,'2022-04-15 16:31:54','',''),(529,'21','228','1',1,'Sale Id shift 27',0.00,0.00,0.00,3433.55,0.00,'2022-04-15 16:31:54','',''),(530,'21','228','1',1,'Sale Id shift 27',0.00,0.00,0.00,4402.40,0.00,'2022-04-15 16:31:54','',''),(531,'21','228','1',1,'Sale Id shift 27',0.00,0.00,0.00,3866.20,0.00,'2022-04-15 16:31:54','',''),(532,'21','228','1',1,'Sale Id shift 27',0.00,0.00,0.00,4170.41,0.00,'2022-04-15 16:31:54','',''),(533,'21','228','1',1,'Sale Id shift 27',0.00,0.00,0.00,5639.72,0.00,'2022-04-15 16:31:54','',''),(534,'21','228',NULL,1,'Sale Id shift 27',8240144.55,0.00,0.00,0.00,0.00,'2022-04-15 16:31:54','',''),(535,'21','228',NULL,2,'Sale Id shift 27',2480786.00,0.00,0.00,0.00,0.00,'2022-04-15 16:31:54','',''),(536,'21','228',NULL,3,'Sale Id shift 27',803154.00,0.00,0.00,0.00,0.00,'2022-04-15 16:31:54','',''),(537,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-16 18:33:16','',''),(538,'21','228',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,45000.00,0.00,'2022-04-16 18:35:06','',''),(539,'21','228','2',1,'Received from bridging 48',0.00,0.00,45000.00,0.00,0.00,'2022-04-16 18:35:06','',''),(540,'21','228','2',1,'Sale Id shift 28',0.00,0.00,0.00,6662.43,0.00,'2022-04-16 18:46:29','',''),(541,'21','228','2',1,'Sale Id shift 28',0.00,0.00,0.00,7716.24,0.00,'2022-04-16 18:46:29','',''),(542,'21','228','2',1,'Sale Id shift 28',0.00,0.00,0.00,5136.94,0.00,'2022-04-16 18:46:29','',''),(543,'21','228','2',1,'Sale Id shift 28',0.00,0.00,0.00,5765.15,0.00,'2022-04-16 18:46:29','',''),(544,'21','228','2',1,'Sale Id shift 28',0.00,0.00,0.00,6596.10,0.00,'2022-04-16 18:46:29','',''),(545,'21','228','2',1,'Sale Id shift 28',0.00,0.00,0.00,7324.55,0.00,'2022-04-16 18:46:29','',''),(546,'21','228','2',1,'Sale Id shift 28',0.00,0.00,0.00,5956.99,0.00,'2022-04-16 18:46:29','',''),(547,'21','228','3',2,'Sale Id shift 28',0.00,0.00,0.00,2309.55,0.00,'2022-04-16 18:46:29','',''),(548,'21','228','3',2,'Sale Id shift 28',0.00,0.00,0.00,862.77,0.00,'2022-04-16 18:46:29','',''),(549,'21','228','4',3,'Sale Id shift 28',0.00,0.00,0.00,1399.71,0.00,'2022-04-16 18:46:29','',''),(550,'21','228',NULL,1,'Sale Id shift 28',7451136.00,0.00,0.00,0.00,0.00,'2022-04-16 18:46:29','',''),(551,'21','228',NULL,2,'Sale Id shift 28',2220624.00,0.00,0.00,0.00,0.00,'2022-04-16 18:46:29','',''),(552,'21','228',NULL,3,'Sale Id shift 28',769840.50,0.00,0.00,0.00,0.00,'2022-04-16 18:46:29','',''),(553,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-16 18:49:15','',''),(554,'21','228',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,45000.00,0.00,'2022-04-16 18:50:56','',''),(555,'21','228','1',1,'Received from bridging 49',0.00,0.00,45000.00,0.00,0.00,'2022-04-16 18:50:56','',''),(556,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,10450000.00,19000.00,0.00,0.00,'2022-04-16 18:51:06','',''),(557,'21','228',NULL,3,'Reception corrector for bridging 50',0.00,0.00,0.00,19000.00,0.00,'2022-04-16 18:51:59','',''),(558,'21','228','4',3,'Received from bridging 50',0.00,0.00,19000.00,0.00,0.00,'2022-04-16 18:51:59','',''),(559,'21','228','1',1,'Sale Id shift 29',0.00,0.00,0.00,7823.36,0.00,'2022-04-17 14:40:42','',''),(560,'21','228','3',2,'Sale Id shift 29',0.00,0.00,0.00,2403.11,0.00,'2022-04-17 14:40:42','',''),(561,'21','228','3',2,'Sale Id shift 29',0.00,0.00,0.00,823.19,0.00,'2022-04-17 14:40:42','',''),(562,'21','228','4',3,'Sale Id shift 29',0.00,0.00,0.00,1479.99,0.00,'2022-04-17 14:40:42','',''),(563,'21','228','1',1,'Sale Id shift 29',0.00,0.00,0.00,4876.33,0.00,'2022-04-17 14:40:42','',''),(564,'21','228','1',1,'Sale Id shift 29',0.00,0.00,0.00,5269.24,0.00,'2022-04-17 14:40:42','',''),(565,'21','228','1',1,'Sale Id shift 29',0.00,0.00,0.00,4729.79,0.00,'2022-04-17 14:40:42','',''),(566,'21','228','1',1,'Sale Id shift 29',0.00,0.00,0.00,4985.20,0.00,'2022-04-17 14:40:42','',''),(567,'21','228','1',1,'Sale Id shift 29',0.00,0.00,0.00,5023.40,0.00,'2022-04-17 14:40:42','',''),(568,'21','228','1',1,'Sale Id shift 29',0.00,0.00,0.00,5547.96,0.00,'2022-04-17 14:40:42','',''),(569,'21','228','1',1,'Sale Id shift 29',0.00,0.00,0.00,7010.87,0.00,'2022-04-17 14:40:42','',''),(570,'21','228',NULL,1,'Sale Id shift 29',7468914.75,0.00,0.00,0.00,0.00,'2022-04-17 14:40:42','',''),(571,'21','228',NULL,2,'Sale Id shift 29',2258410.00,0.00,0.00,0.00,0.00,'2022-04-17 14:40:42','',''),(572,'21','228',NULL,3,'Sale Id shift 29',813994.50,0.00,0.00,0.00,0.00,'2022-04-17 14:40:42','',''),(573,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-18 20:06:28','',''),(574,'21','228',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,40000.00,0.00,'2022-04-18 20:08:56','',''),(575,'21','228','2',1,'Received from bridging 51',0.00,0.00,40000.00,0.00,0.00,'2022-04-18 20:08:56','',''),(576,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-18 20:09:16','',''),(577,'21','228',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,45000.00,0.00,'2022-04-18 20:10:43','',''),(578,'21','228','1',1,'Received from bridging 52',0.00,0.00,45000.00,0.00,0.00,'2022-04-18 20:10:43','',''),(579,'21','228','2',1,'Sale Id shift 30',0.00,0.00,0.00,5944.07,0.00,'2022-04-18 20:24:35','',''),(580,'21','228','2',1,'Sale Id shift 30',0.00,0.00,0.00,6658.04,0.00,'2022-04-18 20:24:35','',''),(581,'21','228','2',1,'Sale Id shift 30',0.00,0.00,0.00,5845.27,0.00,'2022-04-18 20:24:35','',''),(582,'21','228','2',1,'Sale Id shift 30',0.00,0.00,0.00,5766.48,0.00,'2022-04-18 20:24:35','',''),(583,'21','228','2',1,'Sale Id shift 30',0.00,0.00,0.00,5351.83,0.00,'2022-04-18 20:24:35','',''),(584,'21','228','2',1,'Sale Id shift 30',0.00,0.00,0.00,5503.51,0.00,'2022-04-18 20:24:35','',''),(585,'21','228','2',1,'Sale Id shift 30',0.00,0.00,0.00,5060.31,0.00,'2022-04-18 20:24:35','',''),(586,'21','228','3',2,'Sale Id shift 30',0.00,0.00,0.00,1868.88,0.00,'2022-04-18 20:24:35','',''),(587,'21','228','3',2,'Sale Id shift 30',0.00,0.00,0.00,85.72,0.00,'2022-04-18 20:24:35','',''),(588,'21','228','4',3,'Sale Id shift 30',0.00,0.00,0.00,1038.44,0.00,'2022-04-18 20:24:35','',''),(589,'21','228',NULL,2,'Sale Id shift 30',1368220.00,0.00,0.00,0.00,0.00,'2022-04-18 20:24:35','',''),(590,'21','228',NULL,3,'Sale Id shift 30',571142.00,0.00,0.00,0.00,0.00,'2022-04-18 20:24:35','',''),(591,'21','228',NULL,1,'Sale Id shift 30',6621369.15,0.00,0.00,0.00,0.00,'2022-04-18 20:24:35','',''),(592,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-18 20:28:39','',''),(593,'21','228',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,40000.00,0.00,'2022-04-18 20:29:55','',''),(594,'21','228','2',1,'Received from bridging 54',0.00,0.00,40000.00,0.00,0.00,'2022-04-18 20:29:55','',''),(595,'21','228',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,20000.00,0.00,'2022-04-18 20:29:55','',''),(596,'21','228','1',1,'Received from bridging 53',0.00,0.00,20000.00,0.00,0.00,'2022-04-18 20:29:55','',''),(597,'21','228','1',1,'Sale Id shift 31',0.00,0.00,0.00,7424.93,0.00,'2022-04-19 18:53:37','',''),(598,'21','228','3',2,'Sale Id shift 31',0.00,0.00,0.00,3735.41,0.00,'2022-04-19 18:53:37','',''),(599,'21','228','3',2,'Sale Id shift 31',0.00,0.00,0.00,0.04,0.00,'2022-04-19 18:53:37','',''),(600,'21','228','3',2,'Sale Id shift 31',0.00,0.00,0.00,167.85,0.00,'2022-04-19 18:53:37','',''),(601,'21','228','4',3,'Sale Id shift 31',0.00,0.00,0.00,1607.42,0.00,'2022-04-19 18:53:37','',''),(602,'21','228','1',1,'Sale Id shift 31',0.00,0.00,0.00,4646.45,0.00,'2022-04-19 18:53:37','',''),(603,'21','228','1',1,'Sale Id shift 31',0.00,0.00,0.00,4468.31,0.00,'2022-04-19 18:53:37','',''),(604,'21','228','1',1,'Sale Id shift 31',0.00,0.00,0.00,4636.30,0.00,'2022-04-19 18:53:37','',''),(605,'21','228','1',1,'Sale Id shift 31',0.00,0.00,0.00,5111.36,0.00,'2022-04-19 18:53:37','',''),(606,'21','228','1',1,'Sale Id shift 31',0.00,0.00,0.00,5138.87,0.00,'2022-04-19 18:53:37','',''),(607,'21','228','1',1,'Sale Id shift 31',0.00,0.00,0.00,5598.15,0.00,'2022-04-19 18:53:37','',''),(608,'21','228','1',1,'Sale Id shift 31',0.00,0.00,0.00,8134.33,0.00,'2022-04-19 18:53:37','',''),(609,'21','228',NULL,2,'Sale Id shift 31',2732310.00,0.00,0.00,0.00,0.00,'2022-04-19 18:53:37','',''),(610,'21','228',NULL,3,'Sale Id shift 31',884081.00,0.00,0.00,0.00,0.00,'2022-04-19 18:53:37','',''),(611,'21','228',NULL,1,'Sale Id shift 31',7451185.50,0.00,0.00,0.00,0.00,'2022-04-19 18:53:37','',''),(612,'21','228','2',1,'Sale Id shift 32',0.00,0.00,0.00,6164.50,0.00,'2022-04-20 19:20:44','',''),(613,'21','228','2',1,'Sale Id shift 32',0.00,0.00,0.00,5519.25,0.00,'2022-04-20 19:20:44','',''),(614,'21','228','2',1,'Sale Id shift 32',0.00,0.00,0.00,6527.41,0.00,'2022-04-20 19:20:44','',''),(615,'21','228','2',1,'Sale Id shift 32',0.00,0.00,0.00,3814.38,0.00,'2022-04-20 19:20:44','',''),(616,'21','228','2',1,'Sale Id shift 32',0.00,0.00,0.00,5221.08,0.00,'2022-04-20 19:20:44','',''),(617,'21','228','2',1,'Sale Id shift 32',0.00,0.00,0.00,4692.56,0.00,'2022-04-20 19:20:44','',''),(618,'21','228','1',1,'Sale Id shift 32',0.00,0.00,0.00,4470.56,0.00,'2022-04-20 19:20:44','',''),(619,'21','228','2',1,'Sale Id shift 32',0.00,0.00,0.00,6159.61,0.00,'2022-04-20 19:20:44','',''),(620,'21','228','3',2,'Sale Id shift 32',0.00,0.00,0.00,3541.05,0.00,'2022-04-20 19:20:44','',''),(621,'21','228','3',2,'Sale Id shift 32',0.00,0.00,0.00,876.64,0.00,'2022-04-20 19:20:44','',''),(622,'21','228','4',3,'Sale Id shift 32',0.00,0.00,0.00,2002.27,0.00,'2022-04-20 19:20:44','',''),(623,'21','228','1',1,'Sale Id shift 32',0.00,0.00,0.00,2251.96,0.00,'2022-04-20 19:20:44','',''),(624,'21','228','1',1,'Sale Id shift 32',0.00,0.00,0.00,2213.13,0.00,'2022-04-20 19:20:44','',''),(625,'21','228','1',1,'Sale Id shift 32',0.00,0.00,0.00,1556.10,0.00,'2022-04-20 19:20:44','',''),(626,'21','228','1',1,'Sale Id shift 32',0.00,0.00,0.00,2006.13,0.00,'2022-04-20 19:20:44','',''),(627,'21','228','1',1,'Sale Id shift 32',0.00,0.00,0.00,2134.46,0.00,'2022-04-20 19:20:44','',''),(628,'21','228','1',1,'Sale Id shift 32',0.00,0.00,0.00,2178.99,0.00,'2022-04-20 19:20:44','',''),(629,'21','228','1',1,'Sale Id shift 32',0.00,0.00,0.00,3448.22,0.00,'2022-04-20 19:20:44','',''),(630,'21','228',NULL,1,'Sale Id shift 32',9629126.10,0.00,0.00,0.00,0.00,'2022-04-20 19:20:44','',''),(631,'21','228',NULL,2,'Sale Id shift 32',3092383.00,0.00,0.00,0.00,0.00,'2022-04-20 19:20:44','',''),(632,'21','228',NULL,3,'Sale Id shift 32',1101248.50,0.00,0.00,0.00,0.00,'2022-04-20 19:20:44','',''),(633,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-20 19:24:03','',''),(634,'21','228',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,20500.00,0.00,'2022-04-20 19:28:29','',''),(635,'21','228','2',1,'Received from bridging 56',0.00,0.00,20500.00,0.00,0.00,'2022-04-20 19:28:29','',''),(636,'21','228',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,39500.00,0.00,'2022-04-20 19:28:29','',''),(637,'21','228','1',1,'Received from bridging 55',0.00,0.00,39500.00,0.00,0.00,'2022-04-20 19:28:29','',''),(638,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-21 19:13:29','',''),(639,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,15000.00,0.00,0.00,'2022-04-21 19:14:42','',''),(640,'21','228',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,45000.00,0.00,'2022-04-21 19:15:45','',''),(641,'21','228','2',1,'Received from bridging 57',0.00,0.00,45000.00,0.00,0.00,'2022-04-21 19:15:45','',''),(642,'21','228',NULL,3,'Reception corrector for bridging 58',0.00,0.00,0.00,15000.00,0.00,'2022-04-21 19:15:55','',''),(643,'21','228','4',3,'Received from bridging 58',0.00,0.00,15000.00,0.00,0.00,'2022-04-21 19:15:55','',''),(644,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-22 16:28:57','',''),(645,'21','228',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,17000.00,0.00,'2022-04-22 16:31:47','',''),(646,'21','228','2',1,'Received from bridging 60',0.00,0.00,17000.00,0.00,0.00,'2022-04-22 16:31:47','',''),(647,'21','228',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,33000.00,0.00,'2022-04-22 16:31:47','',''),(648,'21','228','1',1,'Received from bridging 59',0.00,0.00,33000.00,0.00,0.00,'2022-04-22 16:31:47','',''),(649,'21','228','2',1,'Sale Id shift 33',0.00,0.00,0.00,4513.69,0.00,'2022-04-22 16:58:40','',''),(650,'21','228','2',1,'Sale Id shift 33',0.00,0.00,0.00,4826.26,0.00,'2022-04-22 16:58:40','',''),(651,'21','228','2',1,'Sale Id shift 33',0.00,0.00,0.00,2975.88,0.00,'2022-04-22 16:58:40','',''),(652,'21','228','2',1,'Sale Id shift 33',0.00,0.00,0.00,633.32,0.00,'2022-04-22 16:58:40','',''),(653,'21','228','2',1,'Sale Id shift 33',0.00,0.00,0.00,3905.34,0.00,'2022-04-22 16:58:40','',''),(654,'21','228','2',1,'Sale Id shift 33',0.00,0.00,0.00,4705.23,0.00,'2022-04-22 16:58:40','',''),(655,'21','228','1',1,'Sale Id shift 33',0.00,0.00,0.00,7293.57,0.00,'2022-04-22 16:58:40','',''),(656,'21','228','2',1,'Sale Id shift 33',0.00,0.00,0.00,3212.28,0.00,'2022-04-22 16:58:40','',''),(657,'21','228','3',2,'Sale Id shift 33',0.00,0.00,0.00,3464.17,0.00,'2022-04-22 16:58:40','',''),(658,'21','228','3',2,'Sale Id shift 33',0.00,0.00,0.00,511.92,0.00,'2022-04-22 16:58:40','',''),(659,'21','228','4',3,'Sale Id shift 33',0.00,0.00,0.00,1324.80,0.00,'2022-04-22 16:58:40','',''),(660,'21','228','1',1,'Sale Id shift 33',0.00,0.00,0.00,5346.15,0.00,'2022-04-22 16:58:40','',''),(661,'21','228','1',1,'Sale Id shift 33',0.00,0.00,0.00,3475.13,0.00,'2022-04-22 16:58:40','',''),(662,'21','228','1',1,'Sale Id shift 33',0.00,0.00,0.00,3654.05,0.00,'2022-04-22 16:58:40','',''),(663,'21','228','1',1,'Sale Id shift 33',0.00,0.00,0.00,4835.84,0.00,'2022-04-22 16:58:40','',''),(664,'21','228','1',1,'Sale Id shift 33',0.00,0.00,0.00,3615.56,0.00,'2022-04-22 16:58:40','',''),(665,'21','228','1',1,'Sale Id shift 33',0.00,0.00,0.00,4930.84,0.00,'2022-04-22 16:58:40','',''),(666,'21','228','1',1,'Sale Id shift 33',0.00,0.00,0.00,6374.98,0.00,'2022-04-22 16:58:40','',''),(667,'21','228',NULL,1,'Sale Id shift 33',10609189.80,0.00,0.00,0.00,0.00,'2022-04-22 16:58:40','',''),(668,'21','228',NULL,2,'Sale Id shift 33',2783263.00,0.00,0.00,0.00,0.00,'2022-04-22 16:58:40','',''),(669,'21','228',NULL,3,'Sale Id shift 33',728640.00,0.00,0.00,0.00,0.00,'2022-04-22 16:58:40','',''),(670,'21','228','2',1,'Sale Id shift 34',0.00,0.00,0.00,6328.82,0.00,'2022-04-22 17:46:27','',''),(671,'21','228','2',1,'Sale Id shift 34',0.00,0.00,0.00,5.15,0.00,'2022-04-22 17:46:27','',''),(672,'21','228','2',1,'Sale Id shift 34',0.00,0.00,0.00,6865.54,0.00,'2022-04-22 17:46:27','',''),(673,'21','228','2',1,'Sale Id shift 34',0.00,0.00,0.00,6797.28,0.00,'2022-04-22 17:46:27','',''),(674,'21','228','2',1,'Sale Id shift 34',0.00,0.00,0.00,5745.35,0.00,'2022-04-22 17:46:27','',''),(675,'21','228','2',1,'Sale Id shift 34',0.00,0.00,0.00,5341.14,0.00,'2022-04-22 17:46:27','',''),(676,'21','228','2',1,'Sale Id shift 34',0.00,0.00,0.00,4807.24,0.00,'2022-04-22 17:46:27','',''),(677,'21','228','2',1,'Sale Id shift 34',0.00,0.00,0.00,6149.92,0.00,'2022-04-22 17:46:27','',''),(678,'21','228','3',2,'Sale Id shift 34',0.00,0.00,0.00,3671.48,0.00,'2022-04-22 17:46:27','',''),(679,'21','228','3',2,'Sale Id shift 34',0.00,0.00,0.00,7.14,0.00,'2022-04-22 17:46:27','',''),(680,'21','228','3',2,'Sale Id shift 34',0.00,0.00,0.00,1169.26,0.00,'2022-04-22 17:46:27','',''),(681,'21','228','4',3,'Sale Id shift 34',0.00,0.00,0.00,779.76,0.00,'2022-04-22 17:46:27','',''),(682,'21','228',NULL,1,'Sale Id shift 34',6936672.60,0.00,0.00,0.00,0.00,'2022-04-22 17:46:27','',''),(683,'21','228',NULL,2,'Sale Id shift 34',3393516.00,0.00,0.00,0.00,0.00,'2022-04-22 17:46:27','',''),(684,'21','228',NULL,3,'Sale Id shift 34',428868.00,0.00,0.00,0.00,0.00,'2022-04-22 17:46:27','',''),(685,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-23 19:32:22','',''),(686,'21','228',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,34000.00,0.00,'2022-04-23 19:34:29','',''),(687,'21','228','2',1,'Received from bridging 62',0.00,0.00,34000.00,0.00,0.00,'2022-04-23 19:34:29','',''),(688,'21','228',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,16000.00,0.00,'2022-04-23 19:34:29','',''),(689,'21','228','1',1,'Received from bridging 61',0.00,0.00,16000.00,0.00,0.00,'2022-04-23 19:34:29','',''),(690,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-23 19:35:51','',''),(691,'21','228',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,20000.00,0.00,'2022-04-23 19:37:45','',''),(692,'21','228','2',1,'Received from bridging 64',0.00,0.00,20000.00,0.00,0.00,'2022-04-23 19:37:45','',''),(693,'21','228',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,30000.00,0.00,'2022-04-23 19:37:45','',''),(694,'21','228','1',1,'Received from bridging 63',0.00,0.00,30000.00,0.00,0.00,'2022-04-23 19:37:45','',''),(695,'21','228','2',1,'Sale Id shift 35',0.00,0.00,0.00,3334.32,0.00,'2022-04-23 19:52:58','',''),(696,'21','228','2',1,'Sale Id shift 35',0.00,0.00,0.00,2496.08,0.00,'2022-04-23 19:52:58','',''),(697,'21','228','2',1,'Sale Id shift 35',0.00,0.00,0.00,3144.31,0.00,'2022-04-23 19:52:58','',''),(698,'21','228','2',1,'Sale Id shift 35',0.00,0.00,0.00,1677.16,0.00,'2022-04-23 19:52:58','',''),(699,'21','228','2',1,'Sale Id shift 35',0.00,0.00,0.00,2651.79,0.00,'2022-04-23 19:52:58','',''),(700,'21','228','2',1,'Sale Id shift 35',0.00,0.00,0.00,726.51,0.00,'2022-04-23 19:52:58','',''),(701,'21','228','1',1,'Sale Id shift 35',0.00,0.00,0.00,8269.39,0.00,'2022-04-23 19:52:58','',''),(702,'21','228','2',1,'Sale Id shift 35',0.00,0.00,0.00,2869.10,0.00,'2022-04-23 19:52:58','',''),(703,'21','228','3',2,'Sale Id shift 35',0.00,0.00,0.00,2791.80,0.00,'2022-04-23 19:52:58','',''),(704,'21','228','3',2,'Sale Id shift 35',0.00,0.00,0.00,223.44,0.00,'2022-04-23 19:52:58','',''),(705,'21','228','4',3,'Sale Id shift 35',0.00,0.00,0.00,1739.81,0.00,'2022-04-23 19:52:58','',''),(706,'21','228','1',1,'Sale Id shift 35',0.00,0.00,0.00,4498.80,0.00,'2022-04-23 19:52:58','',''),(707,'21','228','1',1,'Sale Id shift 35',0.00,0.00,0.00,5686.32,0.00,'2022-04-23 19:52:58','',''),(708,'21','228','1',1,'Sale Id shift 35',0.00,0.00,0.00,3891.51,0.00,'2022-04-23 19:52:58','',''),(709,'21','228','1',1,'Sale Id shift 35',0.00,0.00,0.00,5356.54,0.00,'2022-04-23 19:52:58','',''),(710,'21','228','1',1,'Sale Id shift 35',0.00,0.00,0.00,4606.06,0.00,'2022-04-23 19:52:58','',''),(711,'21','228','1',1,'Sale Id shift 35',0.00,0.00,0.00,5765.97,0.00,'2022-04-23 19:52:58','',''),(712,'21','228','1',1,'Sale Id shift 35',0.00,0.00,0.00,5435.49,0.00,'2022-04-23 19:52:58','',''),(713,'21','228',NULL,2,'Sale Id shift 35',2110668.00,0.00,0.00,0.00,0.00,'2022-04-23 19:52:58','',''),(714,'21','228',NULL,3,'Sale Id shift 35',956895.50,0.00,0.00,0.00,0.00,'2022-04-23 19:52:58','',''),(715,'21','228',NULL,1,'Sale Id shift 35',9967542.75,0.00,0.00,0.00,0.00,'2022-04-23 19:52:58','',''),(716,'21','228','2',1,'Sale Id shift 36',0.00,0.00,0.00,7520.02,0.00,'2022-04-26 19:12:49','',''),(717,'21','228','2',1,'Sale Id shift 36',0.00,0.00,0.00,7584.63,0.00,'2022-04-26 19:12:49','',''),(718,'21','228','2',1,'Sale Id shift 36',0.00,0.00,0.00,8148.58,0.00,'2022-04-26 19:12:49','',''),(719,'21','228','2',1,'Sale Id shift 36',0.00,0.00,0.00,6064.14,0.00,'2022-04-26 19:12:49','',''),(720,'21','228','2',1,'Sale Id shift 36',0.00,0.00,0.00,6217.20,0.00,'2022-04-26 19:12:49','',''),(721,'21','228','2',1,'Sale Id shift 36',0.00,0.00,0.00,6869.01,0.00,'2022-04-26 19:12:49','',''),(722,'21','228','1',1,'Sale Id shift 36',0.00,0.00,0.00,2974.09,0.00,'2022-04-26 19:12:49','',''),(723,'21','228','2',1,'Sale Id shift 36',0.00,0.00,0.00,6978.97,0.00,'2022-04-26 19:12:49','',''),(724,'21','228','3',2,'Sale Id shift 36',0.00,0.00,0.00,4451.80,0.00,'2022-04-26 19:12:49','',''),(725,'21','228','3',2,'Sale Id shift 36',0.00,0.00,0.00,1369.10,0.00,'2022-04-26 19:12:49','',''),(726,'21','228','4',3,'Sale Id shift 36',0.00,0.00,0.00,1257.38,0.00,'2022-04-26 19:12:49','',''),(727,'21','228','1',1,'Sale Id shift 36',0.00,0.00,0.00,63.64,0.00,'2022-04-26 19:12:49','',''),(728,'21','228','1',1,'Sale Id shift 36',0.00,0.00,0.00,815.74,0.00,'2022-04-26 19:12:49','',''),(729,'21','228','1',1,'Sale Id shift 36',0.00,0.00,0.00,451.99,0.00,'2022-04-26 19:12:49','',''),(730,'21','228','1',1,'Sale Id shift 36',0.00,0.00,0.00,2508.36,0.00,'2022-04-26 19:12:49','',''),(731,'21','228','1',1,'Sale Id shift 36',0.00,0.00,0.00,481.69,0.00,'2022-04-26 19:12:49','',''),(732,'21','228','1',1,'Sale Id shift 36',0.00,0.00,0.00,955.91,0.00,'2022-04-26 19:12:49','',''),(733,'21','228','1',1,'Sale Id shift 36',0.00,0.00,0.00,2408.75,0.00,'2022-04-26 19:12:49','',''),(734,'21','228',NULL,2,'Sale Id shift 36',4074630.00,0.00,0.00,0.00,0.00,'2022-04-26 19:12:49','',''),(735,'21','228',NULL,3,'Sale Id shift 36',691559.00,0.00,0.00,0.00,0.00,'2022-04-26 19:12:49','',''),(736,'21','228',NULL,1,'Sale Id shift 36',9907048.80,0.00,0.00,0.00,0.00,'2022-04-26 19:12:49','',''),(737,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-26 19:20:45','',''),(738,'21','228',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,45000.00,0.00,'2022-04-26 19:22:59','',''),(739,'21','228','1',1,'Received from bridging 65',0.00,0.00,45000.00,0.00,0.00,'2022-04-26 19:22:59','',''),(740,'21','228','2',1,'Sale Id shift 37',0.00,0.00,0.00,2097.54,0.00,'2022-04-26 19:30:48','',''),(741,'21','228','2',1,'Sale Id shift 37',0.00,0.00,0.00,824.83,0.00,'2022-04-26 19:30:48','',''),(742,'21','228','1',1,'Sale Id shift 37',0.00,0.00,0.00,8897.04,0.00,'2022-04-26 19:30:48','',''),(743,'21','228','2',1,'Sale Id shift 37',0.00,0.00,0.00,2015.75,0.00,'2022-04-26 19:30:48','',''),(744,'21','228','3',2,'Sale Id shift 37',0.00,0.00,0.00,2655.75,0.00,'2022-04-26 19:30:48','',''),(745,'21','228','3',2,'Sale Id shift 37',0.00,0.00,0.00,0.04,0.00,'2022-04-26 19:30:48','',''),(746,'21','228','4',3,'Sale Id shift 37',0.00,0.00,0.00,2138.06,0.00,'2022-04-26 19:30:48','',''),(747,'21','228','1',1,'Sale Id shift 37',0.00,0.00,0.00,5306.95,0.00,'2022-04-26 19:30:48','',''),(748,'21','228','1',1,'Sale Id shift 37',0.00,0.00,0.00,4952.51,0.00,'2022-04-26 19:30:48','',''),(749,'21','228','1',1,'Sale Id shift 37',0.00,0.00,0.00,4302.68,0.00,'2022-04-26 19:30:48','',''),(750,'21','228','1',1,'Sale Id shift 37',0.00,0.00,0.00,5103.50,0.00,'2022-04-26 19:30:48','',''),(751,'21','228','1',1,'Sale Id shift 37',0.00,0.00,0.00,5193.31,0.00,'2022-04-26 19:30:48','',''),(752,'21','228','1',1,'Sale Id shift 37',0.00,0.00,0.00,5546.18,0.00,'2022-04-26 19:30:48','',''),(753,'21','228','1',1,'Sale Id shift 37',0.00,0.00,0.00,7048.17,0.00,'2022-04-26 19:30:48','',''),(754,'21','228',NULL,2,'Sale Id shift 37',1859053.00,0.00,0.00,0.00,0.00,'2022-04-26 19:30:48','',''),(755,'21','228',NULL,3,'Sale Id shift 37',1175933.00,0.00,0.00,0.00,0.00,'2022-04-26 19:30:48','',''),(756,'21','228',NULL,1,'Sale Id shift 37',8462595.90,0.00,0.00,0.00,0.00,'2022-04-26 19:30:48','',''),(757,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-26 20:14:05','',''),(758,'21','228',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,20000.00,0.00,'2022-04-26 20:16:55','',''),(759,'21','228','2',1,'Received from bridging 67',0.00,0.00,20000.00,0.00,0.00,'2022-04-26 20:16:55','',''),(760,'21','228',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,40000.00,0.00,'2022-04-26 20:16:55','',''),(761,'21','228','1',1,'Received from bridging 66',0.00,0.00,40000.00,0.00,0.00,'2022-04-26 20:16:55','',''),(762,'21','228','2',1,'Sale Id shift 38',0.00,0.00,0.00,1764.08,0.00,'2022-04-26 20:32:11','',''),(763,'21','228','2',1,'Sale Id shift 38',0.00,0.00,0.00,1619.96,0.00,'2022-04-26 20:32:11','',''),(764,'21','228','2',1,'Sale Id shift 38',0.00,0.00,0.00,1628.16,0.00,'2022-04-26 20:32:11','',''),(765,'21','228','2',1,'Sale Id shift 38',0.00,0.00,0.00,360.25,0.00,'2022-04-26 20:32:11','',''),(766,'21','228','2',1,'Sale Id shift 38',0.00,0.00,0.00,1361.10,0.00,'2022-04-26 20:32:11','',''),(767,'21','228','2',1,'Sale Id shift 38',0.00,0.00,0.00,591.94,0.00,'2022-04-26 20:32:11','',''),(768,'21','228','1',1,'Sale Id shift 38',0.00,0.00,0.00,4792.46,0.00,'2022-04-26 20:32:11','',''),(769,'21','228','2',1,'Sale Id shift 38',0.00,0.00,0.00,1132.21,0.00,'2022-04-26 20:32:11','',''),(770,'21','228','3',2,'Sale Id shift 38',0.00,0.00,0.00,3290.29,0.00,'2022-04-26 20:32:11','',''),(771,'21','228','3',2,'Sale Id shift 38',0.00,0.00,0.00,1097.38,0.00,'2022-04-26 20:32:11','',''),(772,'21','228','4',3,'Sale Id shift 38',0.00,0.00,0.00,1857.44,0.00,'2022-04-26 20:32:11','',''),(773,'21','228','1',1,'Sale Id shift 38',0.00,0.00,0.00,2972.73,0.00,'2022-04-26 20:32:11','',''),(774,'21','228','1',1,'Sale Id shift 38',0.00,0.00,0.00,2600.90,0.00,'2022-04-26 20:32:11','',''),(775,'21','228','1',1,'Sale Id shift 38',0.00,0.00,0.00,2296.88,0.00,'2022-04-26 20:32:11','',''),(776,'21','228','1',1,'Sale Id shift 38',0.00,0.00,0.00,3232.83,0.00,'2022-04-26 20:32:11','',''),(777,'21','228','1',1,'Sale Id shift 38',0.00,0.00,0.00,2810.27,0.00,'2022-04-26 20:32:11','',''),(778,'21','228','1',1,'Sale Id shift 38',0.00,0.00,0.00,2658.90,0.00,'2022-04-26 20:32:11','',''),(779,'21','228','1',1,'Sale Id shift 38',0.00,0.00,0.00,4599.33,0.00,'2022-04-26 20:32:11','',''),(780,'21','228',NULL,1,'Sale Id shift 38',5679630.00,0.00,0.00,0.00,0.00,'2022-04-26 20:32:11','',''),(781,'21','228',NULL,2,'Sale Id shift 38',3071369.00,0.00,0.00,0.00,0.00,'2022-04-26 20:32:11','',''),(782,'21','228',NULL,3,'Sale Id shift 38',1021592.00,0.00,0.00,0.00,0.00,'2022-04-26 20:32:11','',''),(783,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-26 21:10:44','',''),(784,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-26 21:12:44','',''),(785,'21','228',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,40000.00,0.00,'2022-04-26 21:13:38','',''),(786,'21','228','2',1,'Received from bridging 69',0.00,0.00,40000.00,0.00,0.00,'2022-04-26 21:13:38','',''),(787,'21','228',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,50000.00,0.00,'2022-04-26 21:13:48','',''),(788,'21','228','1',1,'Received from bridging 68',0.00,0.00,50000.00,0.00,0.00,'2022-04-26 21:13:48','',''),(789,'21','228','2',1,'Sale Id shift 39',0.00,0.00,0.00,2480.89,0.00,'2022-04-27 13:28:42','',''),(790,'21','228','2',1,'Sale Id shift 39',0.00,0.00,0.00,2199.12,0.00,'2022-04-27 13:28:42','',''),(791,'21','228','2',1,'Sale Id shift 39',0.00,0.00,0.00,1948.86,0.00,'2022-04-27 13:28:42','',''),(792,'21','228','2',1,'Sale Id shift 39',0.00,0.00,0.00,1260.92,0.00,'2022-04-27 13:28:42','',''),(793,'21','228','2',1,'Sale Id shift 39',0.00,0.00,0.00,1443.20,0.00,'2022-04-27 13:28:42','',''),(794,'21','228','2',1,'Sale Id shift 39',0.00,0.00,0.00,1210.11,0.00,'2022-04-27 13:28:42','',''),(795,'21','228','1',1,'Sale Id shift 39',0.00,0.00,0.00,7953.64,0.00,'2022-04-27 13:28:42','',''),(796,'21','228','2',1,'Sale Id shift 39',0.00,0.00,0.00,1244.98,0.00,'2022-04-27 13:28:42','',''),(797,'21','228','3',2,'Sale Id shift 39',0.00,0.00,0.00,3203.54,0.00,'2022-04-27 13:28:42','',''),(798,'21','228','3',2,'Sale Id shift 39',0.00,0.00,0.00,526.95,0.00,'2022-04-27 13:28:42','',''),(799,'21','228','4',3,'Sale Id shift 39',0.00,0.00,0.00,2554.02,0.00,'2022-04-27 13:28:42','',''),(800,'21','228','1',1,'Sale Id shift 39',0.00,0.00,0.00,4652.86,0.00,'2022-04-27 13:28:42','',''),(801,'21','228','1',1,'Sale Id shift 39',0.00,0.00,0.00,4945.93,0.00,'2022-04-27 13:28:42','',''),(802,'21','228','1',1,'Sale Id shift 39',0.00,0.00,0.00,4326.06,0.00,'2022-04-27 13:28:42','',''),(803,'21','228','1',1,'Sale Id shift 39',0.00,0.00,0.00,4421.67,0.00,'2022-04-27 13:28:42','',''),(804,'21','228','1',1,'Sale Id shift 39',0.00,0.00,0.00,4602.47,0.00,'2022-04-27 13:28:42','',''),(805,'21','228','1',1,'Sale Id shift 39',0.00,0.00,0.00,5491.25,0.00,'2022-04-27 13:28:42','',''),(806,'21','228','1',1,'Sale Id shift 39',0.00,0.00,0.00,6173.08,0.00,'2022-04-27 13:28:42','',''),(807,'21','228',NULL,2,'Sale Id shift 39',2611343.00,0.00,0.00,0.00,0.00,'2022-04-27 13:28:42','',''),(808,'21','228',NULL,3,'Sale Id shift 39',1404711.00,0.00,0.00,0.00,0.00,'2022-04-27 13:28:42','',''),(809,'21','228',NULL,1,'Sale Id shift 39',8968581.60,0.00,0.00,0.00,0.00,'2022-04-27 13:28:42','',''),(810,'21','228','2',1,'Sale Id shift 40',0.00,0.00,0.00,5339.51,0.00,'2022-04-28 20:45:59','',''),(811,'21','228','2',1,'Sale Id shift 40',0.00,0.00,0.00,1.26,0.00,'2022-04-28 20:45:59','',''),(812,'21','228','2',1,'Sale Id shift 40',0.00,0.00,0.00,4669.08,0.00,'2022-04-28 20:45:59','',''),(813,'21','228','2',1,'Sale Id shift 40',0.00,0.00,0.00,5492.67,0.00,'2022-04-28 20:45:59','',''),(814,'21','228','2',1,'Sale Id shift 40',0.00,0.00,0.00,2648.94,0.00,'2022-04-28 20:45:59','',''),(815,'21','228','2',1,'Sale Id shift 40',0.00,0.00,0.00,2839.90,0.00,'2022-04-28 20:45:59','',''),(816,'21','228','2',1,'Sale Id shift 40',0.00,0.00,0.00,3262.93,0.00,'2022-04-28 20:45:59','',''),(817,'21','228','1',1,'Sale Id shift 40',0.00,0.00,0.00,6279.42,0.00,'2022-04-28 20:45:59','',''),(818,'21','228','2',1,'Sale Id shift 40',0.00,0.00,0.00,3497.98,0.00,'2022-04-28 20:45:59','',''),(819,'21','228','3',2,'Sale Id shift 40',0.00,0.00,0.00,2226.42,0.00,'2022-04-28 20:45:59','',''),(820,'21','228','4',3,'Sale Id shift 40',0.00,0.00,0.00,1866.51,0.00,'2022-04-28 20:45:59','',''),(821,'21','228','1',1,'Sale Id shift 40',0.00,0.00,0.00,1170.53,0.00,'2022-04-28 20:45:59','',''),(822,'21','228','1',1,'Sale Id shift 40',0.00,0.00,0.00,5035.50,0.00,'2022-04-28 20:45:59','',''),(823,'21','228','1',1,'Sale Id shift 40',0.00,0.00,0.00,2166.56,0.00,'2022-04-28 20:45:59','',''),(824,'21','228','1',1,'Sale Id shift 40',0.00,0.00,0.00,3398.07,0.00,'2022-04-28 20:45:59','',''),(825,'21','228','1',1,'Sale Id shift 40',0.00,0.00,0.00,1316.53,0.00,'2022-04-28 20:45:59','',''),(826,'21','228','1',1,'Sale Id shift 40',0.00,0.00,0.00,3438.35,0.00,'2022-04-28 20:45:59','',''),(827,'21','228','1',1,'Sale Id shift 40',0.00,0.00,0.00,4379.50,0.00,'2022-04-28 20:45:59','',''),(828,'21','228',NULL,2,'Sale Id shift 40',1558494.00,0.00,0.00,0.00,0.00,'2022-04-28 20:45:59','',''),(829,'21','228',NULL,3,'Sale Id shift 40',1026580.50,0.00,0.00,0.00,0.00,'2022-04-28 20:45:59','',''),(830,'21','228',NULL,1,'Sale Id shift 40',9064560.45,0.00,0.00,0.00,0.00,'2022-04-28 20:45:59','',''),(831,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-29 21:12:54','',''),(832,'21','228',NULL,1,'Reception corrector for bridging 71',0.00,0.00,0.00,15000.00,0.00,'2022-04-29 21:18:20','',''),(833,'21','228','2',1,'Received from bridging 71',0.00,0.00,15000.00,0.00,0.00,'2022-04-29 21:18:20','',''),(834,'21','228',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,30000.00,0.00,'2022-04-29 21:18:20','',''),(835,'21','228','1',1,'Received from bridging 70',0.00,0.00,30000.00,0.00,0.00,'2022-04-29 21:18:20','',''),(836,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-29 21:18:48','',''),(837,'21','228',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,33000.00,0.00,'2022-04-29 21:20:29','',''),(838,'21','228','2',1,'Received from bridging 73',0.00,0.00,33000.00,0.00,0.00,'2022-04-29 21:20:29','',''),(839,'21','228',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,17000.00,0.00,'2022-04-29 21:20:29','',''),(840,'21','228','1',1,'Received from bridging 72',0.00,0.00,17000.00,0.00,0.00,'2022-04-29 21:20:29','',''),(841,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-29 21:20:43','',''),(842,'21','228','2',1,'Sale Id shift 41',0.00,0.00,0.00,5864.19,0.00,'2022-04-29 21:27:22','',''),(843,'21','228','2',1,'Sale Id shift 41',0.00,0.00,0.00,6073.05,0.00,'2022-04-29 21:27:22','',''),(844,'21','228','2',1,'Sale Id shift 41',0.00,0.00,0.00,5701.66,0.00,'2022-04-29 21:27:22','',''),(845,'21','228','2',1,'Sale Id shift 41',0.00,0.00,0.00,3723.62,0.00,'2022-04-29 21:27:22','',''),(846,'21','228','2',1,'Sale Id shift 41',0.00,0.00,0.00,3594.25,0.00,'2022-04-29 21:27:22','',''),(847,'21','228','2',1,'Sale Id shift 41',0.00,0.00,0.00,3405.57,0.00,'2022-04-29 21:27:22','',''),(848,'21','228','1',1,'Sale Id shift 41',0.00,0.00,0.00,7027.33,0.00,'2022-04-29 21:27:22','',''),(849,'21','228','2',1,'Sale Id shift 41',0.00,0.00,0.00,3334.80,0.00,'2022-04-29 21:27:22','',''),(850,'21','228','4',3,'Sale Id shift 41',0.00,0.00,0.00,2012.35,0.00,'2022-04-29 21:27:22','',''),(851,'21','228','1',1,'Sale Id shift 41',0.00,0.00,0.00,2027.21,0.00,'2022-04-29 21:27:22','',''),(852,'21','228','1',1,'Sale Id shift 41',0.00,0.00,0.00,6154.47,0.00,'2022-04-29 21:27:22','',''),(853,'21','228','1',1,'Sale Id shift 41',0.00,0.00,0.00,3988.17,0.00,'2022-04-29 21:27:22','',''),(854,'21','228','1',1,'Sale Id shift 41',0.00,0.00,0.00,3882.20,0.00,'2022-04-29 21:27:22','',''),(855,'21','228','1',1,'Sale Id shift 41',0.00,0.00,0.00,759.86,0.00,'2022-04-29 21:27:22','',''),(856,'21','228','1',1,'Sale Id shift 41',0.00,0.00,0.00,5471.92,0.00,'2022-04-29 21:27:22','',''),(857,'21','228','1',1,'Sale Id shift 41',0.00,0.00,0.00,5945.56,0.00,'2022-04-29 21:27:22','',''),(858,'21','228',NULL,3,'Sale Id shift 41',1106792.50,0.00,0.00,0.00,0.00,'2022-04-29 21:27:22','',''),(859,'21','228',NULL,1,'Sale Id shift 41',11047386.90,0.00,0.00,0.00,0.00,'2022-04-29 21:27:22','',''),(860,'21','228',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,45000.00,0.00,'2022-04-29 21:42:09','',''),(861,'21','228','1',1,'Received from bridging 74',0.00,0.00,45000.00,0.00,0.00,'2022-04-29 21:42:09','',''),(862,'21','228','2',1,'Sale Id shift 42',0.00,0.00,0.00,6796.03,0.00,'2022-04-30 12:27:44','',''),(863,'21','228','2',1,'Sale Id shift 42',0.00,0.00,0.00,1068.94,0.00,'2022-04-30 12:27:44','',''),(864,'21','228','2',1,'Sale Id shift 42',0.00,0.00,0.00,6608.86,0.00,'2022-04-30 12:27:44','',''),(865,'21','228','2',1,'Sale Id shift 42',0.00,0.00,0.00,5937.76,0.00,'2022-04-30 12:27:44','',''),(866,'21','228','2',1,'Sale Id shift 42',0.00,0.00,0.00,4906.82,0.00,'2022-04-30 12:27:44','',''),(867,'21','228','1',1,'Sale Id shift 42',0.00,0.00,0.00,9163.16,0.00,'2022-04-30 12:27:44','',''),(868,'21','228','2',1,'Sale Id shift 42',0.00,0.00,0.00,3689.10,0.00,'2022-04-30 12:27:44','',''),(869,'21','228','4',3,'Sale Id shift 42',0.00,0.00,0.00,2509.77,0.00,'2022-04-30 12:27:44','',''),(870,'21','228','1',1,'Sale Id shift 42',0.00,0.00,0.00,7247.82,0.00,'2022-04-30 12:27:44','',''),(871,'21','228','1',1,'Sale Id shift 42',0.00,0.00,0.00,2445.74,0.00,'2022-04-30 12:27:44','',''),(872,'21','228','1',1,'Sale Id shift 42',0.00,0.00,0.00,3343.04,0.00,'2022-04-30 12:27:44','',''),(873,'21','228','1',1,'Sale Id shift 42',0.00,0.00,0.00,5531.14,0.00,'2022-04-30 12:27:44','',''),(874,'21','228','1',1,'Sale Id shift 42',0.00,0.00,0.00,4280.35,0.00,'2022-04-30 12:27:44','',''),(875,'21','228','1',1,'Sale Id shift 42',0.00,0.00,0.00,6312.65,0.00,'2022-04-30 12:27:44','',''),(876,'21','228','1',1,'Sale Id shift 42',0.00,0.00,0.00,7793.50,0.00,'2022-04-30 12:27:44','',''),(877,'21','228',NULL,1,'Sale Id shift 42',12395610.15,0.00,0.00,0.00,0.00,'2022-04-30 12:27:44','',''),(878,'21','228',NULL,3,'Sale Id shift 42',1380373.50,0.00,0.00,0.00,0.00,'2022-04-30 12:27:44','',''),(879,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-01 19:59:54','',''),(880,'21','228',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,20000.00,0.00,'2022-05-01 20:02:28','',''),(881,'21','228','2',1,'Received from bridging 76',0.00,0.00,20000.00,0.00,0.00,'2022-05-01 20:02:28','',''),(882,'21','228','2',1,'Returned bridging 76',0.00,0.00,0.00,20000.00,0.00,'2022-05-01 20:05:19','',''),(883,'21','228',NULL,1,'Reception Return corrector for bridging 76',0.00,0.00,20000.00,0.00,0.00,'2022-05-01 20:05:19','',''),(884,'21','228',NULL,1,'Returned purchase #56 to AYM SHAFA NIGERIA LTD',7425000.00,0.00,0.00,45000.00,0.00,'2022-05-01 20:05:42','',''),(885,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-01 21:45:13','',''),(886,'21','228',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,40000.00,0.00,'2022-05-01 21:47:11','',''),(887,'21','228','1',1,'Received from bridging 77',0.00,0.00,40000.00,0.00,0.00,'2022-05-01 21:47:11','',''),(888,'21','228','1',1,'Sale Id shift 43',0.00,0.00,0.00,4498.48,0.00,'2022-05-01 21:55:31','',''),(889,'21','228','4',3,'Sale Id shift 43',0.00,0.00,0.00,3245.24,0.00,'2022-05-01 21:55:31','',''),(890,'21','228','1',1,'Sale Id shift 43',0.00,0.00,0.00,2954.76,0.00,'2022-05-01 21:55:31','',''),(891,'21','228','1',1,'Sale Id shift 43',0.00,0.00,0.00,3224.61,0.00,'2022-05-01 21:55:31','',''),(892,'21','228','1',1,'Sale Id shift 43',0.00,0.00,0.00,3018.76,0.00,'2022-05-01 21:55:31','',''),(893,'21','228','1',1,'Sale Id shift 43',0.00,0.00,0.00,3434.79,0.00,'2022-05-01 21:55:31','',''),(894,'21','228','1',1,'Sale Id shift 43',0.00,0.00,0.00,2878.62,0.00,'2022-05-01 21:55:31','',''),(895,'21','228','1',1,'Sale Id shift 43',0.00,0.00,0.00,3768.79,0.00,'2022-05-01 21:55:31','',''),(896,'21','228','1',1,'Sale Id shift 43',0.00,0.00,0.00,4761.09,0.00,'2022-05-01 21:55:31','',''),(897,'21','228',NULL,3,'Sale Id shift 43',1784882.00,0.00,0.00,0.00,0.00,'2022-05-01 21:55:31','',''),(898,'21','228',NULL,1,'Sale Id shift 43',4709083.50,0.00,0.00,0.00,0.00,'2022-05-01 21:55:31','',''),(899,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-02 13:58:06','',''),(900,'21','228',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,33000.00,0.00,'2022-05-02 14:00:52','',''),(901,'21','228','2',1,'Received from bridging 79',0.00,0.00,33000.00,0.00,0.00,'2022-05-02 14:00:52','',''),(902,'21','228',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,17000.00,0.00,'2022-05-02 14:00:52','',''),(903,'21','228','1',1,'Received from bridging 78',0.00,0.00,17000.00,0.00,0.00,'2022-05-02 14:00:52','',''),(904,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,25200000.00,36000.00,0.00,0.00,'2022-05-02 14:04:47','',''),(905,'21','228',NULL,2,'Reception corrector for bridging 80',0.00,0.00,0.00,36000.00,0.00,'2022-05-02 14:06:56','',''),(906,'21','228','3',2,'Received from bridging 80',0.00,0.00,36000.00,0.00,0.00,'2022-05-02 14:06:56','',''),(907,'21','228','2',1,'Sale Id shift 44',0.00,0.00,0.00,2324.71,0.00,'2022-05-02 14:32:23','',''),(908,'21','228','2',1,'Sale Id shift 44',0.00,0.00,0.00,2454.80,0.00,'2022-05-02 14:32:23','',''),(909,'21','228','2',1,'Sale Id shift 44',0.00,0.00,0.00,2015.70,0.00,'2022-05-02 14:32:23','',''),(910,'21','228','2',1,'Sale Id shift 44',0.00,0.00,0.00,2451.59,0.00,'2022-05-02 14:32:23','',''),(911,'21','228','2',1,'Sale Id shift 44',0.00,0.00,0.00,2472.77,0.00,'2022-05-02 14:32:23','',''),(912,'21','228','1',1,'Sale Id shift 44',0.00,0.00,0.00,2557.98,0.00,'2022-05-02 14:32:23','',''),(913,'21','228','2',1,'Sale Id shift 44',0.00,0.00,0.00,39.01,0.00,'2022-05-02 14:32:23','',''),(914,'21','228','3',2,'Sale Id shift 44',0.00,0.00,0.00,1788.60,0.00,'2022-05-02 14:32:23','',''),(915,'21','228','3',2,'Sale Id shift 44',0.00,0.00,0.00,0.19,0.00,'2022-05-02 14:32:23','',''),(916,'21','228','3',2,'Sale Id shift 44',0.00,0.00,0.00,9.29,0.00,'2022-05-02 14:32:23','',''),(917,'21','228','4',3,'Sale Id shift 44',0.00,0.00,0.00,1731.87,0.00,'2022-05-02 14:32:23','',''),(918,'21','228','1',1,'Sale Id shift 44',0.00,0.00,0.00,1698.43,0.00,'2022-05-02 14:32:23','',''),(919,'21','228','1',1,'Sale Id shift 44',0.00,0.00,0.00,396.80,0.00,'2022-05-02 14:32:23','',''),(920,'21','228','1',1,'Sale Id shift 44',0.00,0.00,0.00,1586.44,0.00,'2022-05-02 14:32:23','',''),(921,'21','228','1',1,'Sale Id shift 44',0.00,0.00,0.00,1977.82,0.00,'2022-05-02 14:32:23','',''),(922,'21','228','1',1,'Sale Id shift 44',0.00,0.00,0.00,1998.53,0.00,'2022-05-02 14:32:23','',''),(923,'21','228',NULL,1,'Sale Id shift 44',3625805.70,0.00,0.00,0.00,0.00,'2022-05-02 14:32:23','',''),(924,'21','228',NULL,2,'Sale Id shift 44',1258656.00,0.00,0.00,0.00,0.00,'2022-05-02 14:32:23','',''),(925,'21','228',NULL,3,'Sale Id shift 44',952528.50,0.00,0.00,0.00,0.00,'2022-05-02 14:32:23','',''),(926,'21','228','2',1,'Sale Id shift 45',0.00,0.00,0.00,5448.17,0.00,'2022-05-03 09:58:34','',''),(927,'21','228','2',1,'Sale Id shift 45',0.00,0.00,0.00,5205.09,0.00,'2022-05-03 09:58:34','',''),(928,'21','228','2',1,'Sale Id shift 45',0.00,0.00,0.00,4995.28,0.00,'2022-05-03 09:58:34','',''),(929,'21','228','2',1,'Sale Id shift 45',0.00,0.00,0.00,5464.19,0.00,'2022-05-03 09:58:34','',''),(930,'21','228','1',1,'Sale Id shift 45',0.00,0.00,0.00,8070.19,0.00,'2022-05-03 09:58:34','',''),(931,'21','228','2',1,'Sale Id shift 45',0.00,0.00,0.00,9.69,0.00,'2022-05-03 09:58:34','',''),(932,'21','228','3',2,'Sale Id shift 45',0.00,0.00,0.00,1621.87,0.00,'2022-05-03 09:58:34','',''),(933,'21','228','4',3,'Sale Id shift 45',0.00,0.00,0.00,3439.20,0.00,'2022-05-03 09:58:34','',''),(934,'21','228','1',1,'Sale Id shift 45',0.00,0.00,0.00,6854.04,0.00,'2022-05-03 09:58:34','',''),(935,'21','228','1',1,'Sale Id shift 45',0.00,0.00,0.00,418.54,0.00,'2022-05-03 09:58:34','',''),(936,'21','228','1',1,'Sale Id shift 45',0.00,0.00,0.00,5626.18,0.00,'2022-05-03 09:58:34','',''),(937,'21','228','1',1,'Sale Id shift 45',0.00,0.00,0.00,695.56,0.00,'2022-05-03 09:58:34','',''),(938,'21','228','1',1,'Sale Id shift 45',0.00,0.00,0.00,5376.77,0.00,'2022-05-03 09:58:34','',''),(939,'21','228','1',1,'Sale Id shift 45',0.00,0.00,0.00,5366.63,0.00,'2022-05-03 09:58:34','',''),(940,'21','228',NULL,2,'Sale Id shift 45',1135309.00,0.00,0.00,0.00,0.00,'2022-05-03 09:58:34','',''),(941,'21','228',NULL,3,'Sale Id shift 45',1891560.00,0.00,0.00,0.00,0.00,'2022-05-03 09:58:34','',''),(942,'21','228',NULL,1,'Sale Id shift 45',8832504.45,0.00,0.00,0.00,0.00,'2022-05-03 09:58:34','',''),(943,'21','228','1',1,'Sale Id shift 46',0.00,0.00,0.00,2817.72,0.00,'2022-05-04 13:35:50','',''),(944,'21','228','3',2,'Sale Id shift 46',0.00,0.00,0.00,2554.78,0.00,'2022-05-04 13:35:50','',''),(945,'21','228','3',2,'Sale Id shift 46',0.00,0.00,0.00,270.22,0.00,'2022-05-04 13:35:50','',''),(946,'21','228','4',3,'Sale Id shift 46',0.00,0.00,0.00,2516.30,0.00,'2022-05-04 13:35:50','',''),(947,'21','228','1',1,'Sale Id shift 46',0.00,0.00,0.00,1613.26,0.00,'2022-05-04 13:35:50','',''),(948,'21','228','1',1,'Sale Id shift 46',0.00,0.00,0.00,1740.51,0.00,'2022-05-04 13:35:50','',''),(949,'21','228','1',1,'Sale Id shift 46',0.00,0.00,0.00,2.68,0.00,'2022-05-04 13:35:50','',''),(950,'21','228','1',1,'Sale Id shift 46',0.00,0.00,0.00,2027.80,0.00,'2022-05-04 13:35:50','',''),(951,'21','228','1',1,'Sale Id shift 46',0.00,0.00,0.00,1659.06,0.00,'2022-05-04 13:35:50','',''),(952,'21','228','1',1,'Sale Id shift 46',0.00,0.00,0.00,1394.62,0.00,'2022-05-04 13:35:50','',''),(953,'21','228','1',1,'Sale Id shift 46',0.00,0.00,0.00,2594.64,0.00,'2022-05-04 13:35:50','',''),(954,'21','228',NULL,1,'Sale Id shift 46',2285297.85,0.00,0.00,0.00,0.00,'2022-05-04 13:35:50','',''),(955,'21','228',NULL,2,'Sale Id shift 46',1977500.00,0.00,0.00,0.00,0.00,'2022-05-04 13:35:50','',''),(956,'21','228',NULL,3,'Sale Id shift 46',1383965.00,0.00,0.00,0.00,0.00,'2022-05-04 13:35:50','',''),(957,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-04 13:48:09','',''),(958,'21','228',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,33000.00,0.00,'2022-05-04 13:50:34','',''),(959,'21','228','2',1,'Received from bridging 82',0.00,0.00,33000.00,0.00,0.00,'2022-05-04 13:50:34','',''),(960,'21','228',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,17000.00,0.00,'2022-05-04 13:50:34','',''),(961,'21','228','1',1,'Received from bridging 81',0.00,0.00,17000.00,0.00,0.00,'2022-05-04 13:50:34','',''),(962,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-05 13:32:49','',''),(963,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-05 13:33:55','',''),(964,'21','228',NULL,1,'Reception corrector for bridging 85',0.00,0.00,0.00,30000.00,0.00,'2022-05-05 13:35:18','',''),(965,'21','228','2',1,'Received from bridging 85',0.00,0.00,30000.00,0.00,0.00,'2022-05-05 13:35:18','',''),(966,'21','228',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,20000.00,0.00,'2022-05-05 13:35:18','',''),(967,'21','228','1',1,'Received from bridging 84',0.00,0.00,20000.00,0.00,0.00,'2022-05-05 13:35:18','',''),(968,'21','228',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,40000.00,0.00,'2022-05-05 13:35:25','',''),(969,'21','228','1',1,'Received from bridging 83',0.00,0.00,40000.00,0.00,0.00,'2022-05-05 13:35:25','',''),(970,'21','228','2',1,'Sale Id shift 47',0.00,0.00,0.00,5624.29,0.00,'2022-05-05 13:57:02','',''),(971,'21','228','2',1,'Sale Id shift 47',0.00,0.00,0.00,4940.37,0.00,'2022-05-05 13:57:02','',''),(972,'21','228','2',1,'Sale Id shift 47',0.00,0.00,0.00,7355.53,0.00,'2022-05-05 13:57:02','',''),(973,'21','228','2',1,'Sale Id shift 47',0.00,0.00,0.00,1208.76,0.00,'2022-05-05 13:57:02','',''),(974,'21','228','2',1,'Sale Id shift 47',0.00,0.00,0.00,3231.63,0.00,'2022-05-05 13:57:02','',''),(975,'21','228','2',1,'Sale Id shift 47',0.00,0.00,0.00,4608.06,0.00,'2022-05-05 13:57:02','',''),(976,'21','228','1',1,'Sale Id shift 47',0.00,0.00,0.00,4713.04,0.00,'2022-05-05 13:57:02','',''),(977,'21','228','2',1,'Sale Id shift 47',0.00,0.00,0.00,5989.22,0.00,'2022-05-05 13:57:02','',''),(978,'21','228','3',2,'Sale Id shift 47',0.00,0.00,0.00,2143.78,0.00,'2022-05-05 13:57:02','',''),(979,'21','228','3',2,'Sale Id shift 47',0.00,0.00,0.00,1386.61,0.00,'2022-05-05 13:57:02','',''),(980,'21','228','4',3,'Sale Id shift 47',0.00,0.00,0.00,0.17,0.00,'2022-05-05 13:57:02','',''),(981,'21','228','4',3,'Sale Id shift 47',0.00,0.00,0.00,4798.69,0.00,'2022-05-05 13:57:02','',''),(982,'21','228','1',1,'Sale Id shift 47',0.00,0.00,0.00,3612.12,0.00,'2022-05-05 13:57:02','',''),(983,'21','228','1',1,'Sale Id shift 47',0.00,0.00,0.00,304.28,0.00,'2022-05-05 13:57:02','',''),(984,'21','228','1',1,'Sale Id shift 47',0.00,0.00,0.00,1266.06,0.00,'2022-05-05 13:57:02','',''),(985,'21','228','1',1,'Sale Id shift 47',0.00,0.00,0.00,2828.78,0.00,'2022-05-05 13:57:02','',''),(986,'21','228','1',1,'Sale Id shift 47',0.00,0.00,0.00,785.30,0.00,'2022-05-05 13:57:02','',''),(987,'21','228','1',1,'Sale Id shift 47',0.00,0.00,0.00,2716.39,0.00,'2022-05-05 13:57:02','',''),(988,'21','228','1',1,'Sale Id shift 47',0.00,0.00,0.00,3279.94,0.00,'2022-05-05 13:57:02','',''),(989,'21','228',NULL,1,'Sale Id shift 47',8656522.05,0.00,0.00,0.00,0.00,'2022-05-05 13:57:02','',''),(990,'21','228',NULL,2,'Sale Id shift 47',2471273.00,0.00,0.00,0.00,0.00,'2022-05-05 13:57:02','',''),(991,'21','228',NULL,3,'Sale Id shift 47',2639373.00,0.00,0.00,0.00,0.00,'2022-05-05 13:57:02','',''),(992,'21','228','2',1,'Sale Id shift 48',0.00,0.00,0.00,6489.96,0.00,'2022-05-06 13:12:56','',''),(993,'21','228','2',1,'Sale Id shift 48',0.00,0.00,0.00,6656.25,0.00,'2022-05-06 13:12:56','',''),(994,'21','228','2',1,'Sale Id shift 48',0.00,0.00,0.00,1762.84,0.00,'2022-05-06 13:12:56','',''),(995,'21','228','2',1,'Sale Id shift 48',0.00,0.00,0.00,7220.89,0.00,'2022-05-06 13:12:56','',''),(996,'21','228','2',1,'Sale Id shift 48',0.00,0.00,0.00,2080.88,0.00,'2022-05-06 13:12:56','',''),(997,'21','228','1',1,'Sale Id shift 48',0.00,0.00,0.00,5016.59,0.00,'2022-05-06 13:12:56','',''),(998,'21','228','2',1,'Sale Id shift 48',0.00,0.00,0.00,5716.57,0.00,'2022-05-06 13:12:56','',''),(999,'21','228','3',2,'Sale Id shift 48',0.00,0.00,0.00,2638.40,0.00,'2022-05-06 13:12:56','',''),(1000,'21','228','3',2,'Sale Id shift 48',0.00,0.00,0.00,1464.04,0.00,'2022-05-06 13:12:56','',''),(1001,'21','228','4',3,'Sale Id shift 48',0.00,0.00,0.00,0.64,0.00,'2022-05-06 13:12:56','',''),(1002,'21','228','4',3,'Sale Id shift 48',0.00,0.00,0.00,8089.93,0.00,'2022-05-06 13:12:56','',''),(1003,'21','228','1',1,'Sale Id shift 48',0.00,0.00,0.00,3592.85,0.00,'2022-05-06 13:12:56','',''),(1004,'21','228','1',1,'Sale Id shift 48',0.00,0.00,0.00,2013.40,0.00,'2022-05-06 13:12:56','',''),(1005,'21','228','1',1,'Sale Id shift 48',0.00,0.00,0.00,3839.80,0.00,'2022-05-06 13:12:56','',''),(1006,'21','228','1',1,'Sale Id shift 48',0.00,0.00,0.00,2421.24,0.00,'2022-05-06 13:12:56','',''),(1007,'21','228','1',1,'Sale Id shift 48',0.00,0.00,0.00,1316.78,0.00,'2022-05-06 13:12:56','',''),(1008,'21','228','1',1,'Sale Id shift 48',0.00,0.00,0.00,3722.81,0.00,'2022-05-06 13:12:56','',''),(1009,'21','228',NULL,1,'Sale Id shift 48',8555391.90,0.00,0.00,0.00,0.00,'2022-05-06 13:12:56','',''),(1010,'21','228',NULL,2,'Sale Id shift 48',2871708.00,0.00,0.00,0.00,0.00,'2022-05-06 13:12:56','',''),(1011,'21','228',NULL,3,'Sale Id shift 48',4449813.50,0.00,0.00,0.00,0.00,'2022-05-06 13:12:56','',''),(1012,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-06 13:32:35','',''),(1013,'21','228',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,30000.00,0.00,'2022-05-06 13:35:11','',''),(1014,'21','228','2',1,'Received from bridging 87',0.00,0.00,30000.00,0.00,0.00,'2022-05-06 13:35:11','',''),(1015,'21','228',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,20000.00,0.00,'2022-05-06 13:35:11','',''),(1016,'21','228','1',1,'Received from bridging 86',0.00,0.00,20000.00,0.00,0.00,'2022-05-06 13:35:11','',''),(1017,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8800000.00,16000.00,0.00,0.00,'2022-05-07 13:42:19','',''),(1018,'21','228',NULL,3,'Reception corrector for bridging 88',0.00,0.00,0.00,16000.00,0.00,'2022-05-07 13:43:47','',''),(1019,'21','228','4',3,'Received from bridging 88',0.00,0.00,16000.00,0.00,0.00,'2022-05-07 13:43:47','',''),(1020,'21','228','2',1,'Sale Id shift 49',0.00,0.00,0.00,6462.89,0.00,'2022-05-07 13:48:24','',''),(1021,'21','228','2',1,'Sale Id shift 49',0.00,0.00,0.00,0.82,0.00,'2022-05-07 13:48:24','',''),(1022,'21','228','2',1,'Sale Id shift 49',0.00,0.00,0.00,5474.54,0.00,'2022-05-07 13:48:24','',''),(1023,'21','228','2',1,'Sale Id shift 49',0.00,0.00,0.00,3969.97,0.00,'2022-05-07 13:48:24','',''),(1024,'21','228','2',1,'Sale Id shift 49',0.00,0.00,0.00,5360.77,0.00,'2022-05-07 13:48:24','',''),(1025,'21','228','2',1,'Sale Id shift 49',0.00,0.00,0.00,2511.73,0.00,'2022-05-07 13:48:24','',''),(1026,'21','228','2',1,'Sale Id shift 49',0.00,0.00,0.00,4457.64,0.00,'2022-05-07 13:48:24','',''),(1027,'21','228','1',1,'Sale Id shift 49',0.00,0.00,0.00,8342.15,0.00,'2022-05-07 13:48:24','',''),(1028,'21','228','2',1,'Sale Id shift 49',0.00,0.00,0.00,1886.56,0.00,'2022-05-07 13:48:24','',''),(1029,'21','228','3',2,'Sale Id shift 49',0.00,0.00,0.00,2014.66,0.00,'2022-05-07 13:48:24','',''),(1030,'21','228','3',2,'Sale Id shift 49',0.00,0.00,0.00,902.38,0.00,'2022-05-07 13:48:24','',''),(1031,'21','228','4',3,'Sale Id shift 49',0.00,0.00,0.00,2515.62,0.00,'2022-05-07 13:48:24','',''),(1032,'21','228','1',1,'Sale Id shift 49',0.00,0.00,0.00,3382.76,0.00,'2022-05-07 13:48:24','',''),(1033,'21','228','1',1,'Sale Id shift 49',0.00,0.00,0.00,3602.00,0.00,'2022-05-07 13:48:24','',''),(1034,'21','228','1',1,'Sale Id shift 49',0.00,0.00,0.00,2635.32,0.00,'2022-05-07 13:48:24','',''),(1035,'21','228','1',1,'Sale Id shift 49',0.00,0.00,0.00,4944.80,0.00,'2022-05-07 13:48:24','',''),(1036,'21','228','1',1,'Sale Id shift 49',0.00,0.00,0.00,2173.93,0.00,'2022-05-07 13:48:24','',''),(1037,'21','228','1',1,'Sale Id shift 49',0.00,0.00,0.00,4275.25,0.00,'2022-05-07 13:48:24','',''),(1038,'21','228','1',1,'Sale Id shift 49',0.00,0.00,0.00,4228.94,0.00,'2022-05-07 13:48:24','',''),(1039,'21','228',NULL,1,'Sale Id shift 49',10512161.55,0.00,0.00,0.00,0.00,'2022-05-07 13:48:24','',''),(1040,'21','228',NULL,2,'Sale Id shift 49',2041928.00,0.00,0.00,0.00,0.00,'2022-05-07 13:48:24','',''),(1041,'21','228',NULL,3,'Sale Id shift 49',1383591.00,0.00,0.00,0.00,0.00,'2022-05-07 13:48:24','',''),(1042,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-09 17:32:48','',''),(1043,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7260000.00,44000.00,0.00,0.00,'2022-05-09 17:44:00','',''),(1044,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,10500000.00,15000.00,0.00,0.00,'2022-05-09 17:45:02','',''),(1045,'21','228',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,30000.00,0.00,'2022-05-09 17:46:25','',''),(1046,'21','228','2',1,'Received from bridging 90',0.00,0.00,30000.00,0.00,0.00,'2022-05-09 17:46:25','',''),(1047,'21','228',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,20000.00,0.00,'2022-05-09 17:46:25','',''),(1048,'21','228','1',1,'Received from bridging 89',0.00,0.00,20000.00,0.00,0.00,'2022-05-09 17:46:25','',''),(1049,'21','228',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,44000.00,0.00,'2022-05-09 17:46:40','',''),(1050,'21','228','1',1,'Received from bridging 91',0.00,0.00,44000.00,0.00,0.00,'2022-05-09 17:46:40','',''),(1051,'21','228',NULL,2,'Reception corrector for bridging 92',0.00,0.00,0.00,15000.00,0.00,'2022-05-09 17:46:53','',''),(1052,'21','228','3',2,'Received from bridging 92',0.00,0.00,15000.00,0.00,0.00,'2022-05-09 17:46:53','',''),(1053,'21','228','2',1,'Sale Id shift 50',0.00,0.00,0.00,2837.79,0.00,'2022-05-09 17:57:43','',''),(1054,'21','228','2',1,'Sale Id shift 50',0.00,0.00,0.00,1879.97,0.00,'2022-05-09 17:57:43','',''),(1055,'21','228','2',1,'Sale Id shift 50',0.00,0.00,0.00,2364.54,0.00,'2022-05-09 17:57:43','',''),(1056,'21','228','2',1,'Sale Id shift 50',0.00,0.00,0.00,2678.03,0.00,'2022-05-09 17:57:43','',''),(1057,'21','228','2',1,'Sale Id shift 50',0.00,0.00,0.00,3156.19,0.00,'2022-05-09 17:57:43','',''),(1058,'21','228','1',1,'Sale Id shift 50',0.00,0.00,0.00,8548.83,0.00,'2022-05-09 17:57:43','',''),(1059,'21','228','3',2,'Sale Id shift 50',0.00,0.00,0.00,1855.69,0.00,'2022-05-09 17:57:43','',''),(1060,'21','228','3',2,'Sale Id shift 50',0.00,0.00,0.00,1617.99,0.00,'2022-05-09 17:57:43','',''),(1061,'21','228','4',3,'Sale Id shift 50',0.00,0.00,0.00,991.94,0.00,'2022-05-09 17:57:43','',''),(1062,'21','228','1',1,'Sale Id shift 50',0.00,0.00,0.00,6321.35,0.00,'2022-05-09 17:57:43','',''),(1063,'21','228','1',1,'Sale Id shift 50',0.00,0.00,0.00,5585.24,0.00,'2022-05-09 17:57:43','',''),(1064,'21','228','1',1,'Sale Id shift 50',0.00,0.00,0.00,2679.22,0.00,'2022-05-09 17:57:43','',''),(1065,'21','228','1',1,'Sale Id shift 50',0.00,0.00,0.00,5533.73,0.00,'2022-05-09 17:57:43','',''),(1066,'21','228','1',1,'Sale Id shift 50',0.00,0.00,0.00,2537.66,0.00,'2022-05-09 17:57:43','',''),(1067,'21','228','1',1,'Sale Id shift 50',0.00,0.00,0.00,5671.38,0.00,'2022-05-09 17:57:43','',''),(1068,'21','228','1',1,'Sale Id shift 50',0.00,0.00,0.00,6274.81,0.00,'2022-05-09 17:57:43','',''),(1069,'21','228',NULL,1,'Sale Id shift 50',9251342.10,0.00,0.00,0.00,0.00,'2022-05-09 17:57:43','',''),(1070,'21','228',NULL,2,'Sale Id shift 50',2431576.00,0.00,0.00,0.00,0.00,'2022-05-09 17:57:43','',''),(1071,'21','228',NULL,3,'Sale Id shift 50',545567.00,0.00,0.00,0.00,0.00,'2022-05-09 17:57:43','',''),(1072,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-09 18:24:28','',''),(1073,'21','228',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,45000.00,0.00,'2022-05-09 19:27:29','',''),(1074,'21','228','1',1,'Received from bridging 93',0.00,0.00,45000.00,0.00,0.00,'2022-05-09 19:27:29','',''),(1075,'21','228','2',1,'Sale Id shift 51',0.00,0.00,0.00,3358.79,0.00,'2022-05-09 19:37:55','',''),(1076,'21','228','2',1,'Sale Id shift 51',0.00,0.00,0.00,2877.80,0.00,'2022-05-09 19:37:55','',''),(1077,'21','228','2',1,'Sale Id shift 51',0.00,0.00,0.00,3152.20,0.00,'2022-05-09 19:37:55','',''),(1078,'21','228','2',1,'Sale Id shift 51',0.00,0.00,0.00,3792.16,0.00,'2022-05-09 19:37:55','',''),(1079,'21','228','1',1,'Sale Id shift 51',0.00,0.00,0.00,8642.38,0.00,'2022-05-09 19:37:55','',''),(1080,'21','228','2',1,'Sale Id shift 51',0.00,0.00,0.00,3377.61,0.00,'2022-05-09 19:37:55','',''),(1081,'21','228','3',2,'Sale Id shift 51',0.00,0.00,0.00,797.33,0.00,'2022-05-09 19:37:55','',''),(1082,'21','228','4',3,'Sale Id shift 51',0.00,0.00,0.00,656.36,0.00,'2022-05-09 19:37:55','',''),(1083,'21','228','1',1,'Sale Id shift 51',0.00,0.00,0.00,6443.44,0.00,'2022-05-09 19:37:55','',''),(1084,'21','228','1',1,'Sale Id shift 51',0.00,0.00,0.00,4620.38,0.00,'2022-05-09 19:37:55','',''),(1085,'21','228','1',1,'Sale Id shift 51',0.00,0.00,0.00,2561.77,0.00,'2022-05-09 19:37:55','',''),(1086,'21','228','1',1,'Sale Id shift 51',0.00,0.00,0.00,6122.54,0.00,'2022-05-09 19:37:55','',''),(1087,'21','228','1',1,'Sale Id shift 51',0.00,0.00,0.00,2313.20,0.00,'2022-05-09 19:37:55','',''),(1088,'21','228','1',1,'Sale Id shift 51',0.00,0.00,0.00,5974.41,0.00,'2022-05-09 19:37:55','',''),(1089,'21','228','1',1,'Sale Id shift 51',0.00,0.00,0.00,7435.85,0.00,'2022-05-09 19:37:55','',''),(1090,'21','228',NULL,1,'Sale Id shift 51',10010967.45,0.00,0.00,0.00,0.00,'2022-05-09 19:37:55','',''),(1091,'21','228',NULL,2,'Sale Id shift 51',558131.00,0.00,0.00,0.00,0.00,'2022-05-09 19:37:55','',''),(1092,'21','228',NULL,3,'Sale Id shift 51',360998.00,0.00,0.00,0.00,0.00,'2022-05-09 19:37:55','',''),(1093,'21','228','3',2,'Sale Id shift 52',0.00,0.00,0.00,4066.28,0.00,'2022-05-10 19:37:12','',''),(1094,'21','228','4',3,'Sale Id shift 52',0.00,0.00,0.00,640.33,0.00,'2022-05-10 19:37:12','',''),(1095,'21','228','4',3,'Sale Id shift 52',0.00,0.00,0.00,446.26,0.00,'2022-05-10 19:37:12','',''),(1096,'21','228',NULL,2,'Sale Id shift 52',2846396.00,0.00,0.00,0.00,0.00,'2022-05-10 19:37:12','',''),(1097,'21','228',NULL,3,'Sale Id shift 52',597624.50,0.00,0.00,0.00,0.00,'2022-05-10 19:37:12','',''),(1098,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-11 18:15:59','',''),(1099,'21','228',NULL,1,'Reception corrector for bridging 94',0.00,0.00,0.00,45000.00,0.00,'2022-05-11 18:20:23','',''),(1100,'21','228','1',1,'Received from bridging 94',0.00,0.00,45000.00,0.00,0.00,'2022-05-11 18:20:23','',''),(1101,'21','228','1',1,'Sale Id shift 53',0.00,0.00,0.00,8060.57,0.00,'2022-05-11 18:26:36','',''),(1102,'21','228','3',2,'Sale Id shift 53',0.00,0.00,0.00,1484.70,0.00,'2022-05-11 18:26:36','',''),(1103,'21','228','3',2,'Sale Id shift 53',0.00,0.00,0.00,791.84,0.00,'2022-05-11 18:26:36','',''),(1104,'21','228','3',2,'Sale Id shift 53',0.00,0.00,0.00,809.62,0.00,'2022-05-11 18:26:36','',''),(1105,'21','228','4',3,'Sale Id shift 53',0.00,0.00,0.00,0.55,0.00,'2022-05-11 18:26:36','',''),(1106,'21','228','4',3,'Sale Id shift 53',0.00,0.00,0.00,1309.87,0.00,'2022-05-11 18:26:36','',''),(1107,'21','228','1',1,'Sale Id shift 53',0.00,0.00,0.00,4969.61,0.00,'2022-05-11 18:26:36','',''),(1108,'21','228','1',1,'Sale Id shift 53',0.00,0.00,0.00,4858.63,0.00,'2022-05-11 18:26:36','',''),(1109,'21','228','1',1,'Sale Id shift 53',0.00,0.00,0.00,4689.77,0.00,'2022-05-11 18:26:36','',''),(1110,'21','228','1',1,'Sale Id shift 53',0.00,0.00,0.00,5014.64,0.00,'2022-05-11 18:26:36','',''),(1111,'21','228','1',1,'Sale Id shift 53',0.00,0.00,0.00,5297.07,0.00,'2022-05-11 18:26:36','',''),(1112,'21','228','1',1,'Sale Id shift 53',0.00,0.00,0.00,5210.56,0.00,'2022-05-11 18:26:36','',''),(1113,'21','228','1',1,'Sale Id shift 53',0.00,0.00,0.00,6932.13,0.00,'2022-05-11 18:26:36','',''),(1114,'21','228',NULL,1,'Sale Id shift 53',7430441.70,0.00,0.00,0.00,0.00,'2022-05-11 18:26:36','',''),(1115,'21','228',NULL,2,'Sale Id shift 53',2160312.00,0.00,0.00,0.00,0.00,'2022-05-11 18:26:36','',''),(1116,'21','228',NULL,3,'Sale Id shift 53',720731.00,0.00,0.00,0.00,0.00,'2022-05-11 18:26:36','',''),(1117,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-12 20:10:10','',''),(1118,'21','228',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,33000.00,0.00,'2022-05-12 20:13:25','',''),(1119,'21','228','2',1,'Received from bridging 96',0.00,0.00,33000.00,0.00,0.00,'2022-05-12 20:13:25','',''),(1120,'21','228',NULL,1,'Reception corrector for bridging 95',0.00,0.00,0.00,17000.00,0.00,'2022-05-12 20:13:25','',''),(1121,'21','228','1',1,'Received from bridging 95',0.00,0.00,17000.00,0.00,0.00,'2022-05-12 20:13:25','',''),(1122,'21','228','1',1,'Sale Id shift 55',0.00,0.00,0.00,7787.81,0.00,'2022-05-13 15:21:44','',''),(1123,'21','228','3',2,'Sale Id shift 55',0.00,0.00,0.00,1935.68,0.00,'2022-05-13 15:21:44','',''),(1124,'21','228','3',2,'Sale Id shift 55',0.00,0.00,0.00,80.14,0.00,'2022-05-13 15:21:44','',''),(1125,'21','228','3',2,'Sale Id shift 55',0.00,0.00,0.00,1811.28,0.00,'2022-05-13 15:21:44','',''),(1126,'21','228','4',3,'Sale Id shift 55',0.00,0.00,0.00,1649.39,0.00,'2022-05-13 15:21:44','',''),(1127,'21','228','1',1,'Sale Id shift 55',0.00,0.00,0.00,4180.80,0.00,'2022-05-13 15:21:44','',''),(1128,'21','228','1',1,'Sale Id shift 55',0.00,0.00,0.00,4785.19,0.00,'2022-05-13 15:21:44','',''),(1129,'21','228','1',1,'Sale Id shift 55',0.00,0.00,0.00,4940.92,0.00,'2022-05-13 15:21:44','',''),(1130,'21','228','1',1,'Sale Id shift 55',0.00,0.00,0.00,5260.48,0.00,'2022-05-13 15:21:44','',''),(1131,'21','228','1',1,'Sale Id shift 55',0.00,0.00,0.00,4626.91,0.00,'2022-05-13 15:21:44','',''),(1132,'21','228','1',1,'Sale Id shift 55',0.00,0.00,0.00,5748.19,0.00,'2022-05-13 15:21:44','',''),(1133,'21','228','1',1,'Sale Id shift 55',0.00,0.00,0.00,7587.67,0.00,'2022-05-13 15:21:44','',''),(1134,'21','228',NULL,1,'Sale Id shift 55',7411465.05,0.00,0.00,0.00,0.00,'2022-05-13 15:21:44','',''),(1135,'21','228',NULL,2,'Sale Id shift 55',2678970.00,0.00,0.00,0.00,0.00,'2022-05-13 15:21:44','',''),(1136,'21','228',NULL,3,'Sale Id shift 55',1072103.50,0.00,0.00,0.00,0.00,'2022-05-13 15:21:44','',''),(1137,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-13 15:38:28','',''),(1138,'21','228',NULL,1,'Reception corrector for bridging 97',0.00,0.00,0.00,45000.00,0.00,'2022-05-13 15:39:54','',''),(1139,'21','228','1',1,'Received from bridging 97',0.00,0.00,45000.00,0.00,0.00,'2022-05-13 15:39:54','',''),(1140,'21','228','2',1,'Sale Id shift 56',0.00,0.00,0.00,1690.93,0.00,'2022-05-13 15:48:36','',''),(1141,'21','228','2',1,'Sale Id shift 56',0.00,0.00,0.00,1324.34,0.00,'2022-05-13 15:48:36','',''),(1142,'21','228','2',1,'Sale Id shift 56',0.00,0.00,0.00,1497.99,0.00,'2022-05-13 15:48:36','',''),(1143,'21','228','2',1,'Sale Id shift 56',0.00,0.00,0.00,2382.04,0.00,'2022-05-13 15:48:36','',''),(1144,'21','228','2',1,'Sale Id shift 56',0.00,0.00,0.00,2122.86,0.00,'2022-05-13 15:48:36','',''),(1145,'21','228','1',1,'Sale Id shift 56',0.00,0.00,0.00,3779.62,0.00,'2022-05-13 15:48:36','',''),(1146,'21','228','3',2,'Sale Id shift 56',0.00,0.00,0.00,2216.49,0.00,'2022-05-13 15:48:36','',''),(1147,'21','228','3',2,'Sale Id shift 56',0.00,0.00,0.00,494.30,0.00,'2022-05-13 15:48:36','',''),(1148,'21','228','3',2,'Sale Id shift 56',0.00,0.00,0.00,1228.04,0.00,'2022-05-13 15:48:36','',''),(1149,'21','228','4',3,'Sale Id shift 56',0.00,0.00,0.00,1210.24,0.00,'2022-05-13 15:48:36','',''),(1150,'21','228','1',1,'Sale Id shift 56',0.00,0.00,0.00,3547.01,0.00,'2022-05-13 15:48:36','',''),(1151,'21','228','1',1,'Sale Id shift 56',0.00,0.00,0.00,3.43,0.00,'2022-05-13 15:48:36','',''),(1152,'21','228','1',1,'Sale Id shift 56',0.00,0.00,0.00,1451.35,0.00,'2022-05-13 15:48:36','',''),(1153,'21','228','1',1,'Sale Id shift 56',0.00,0.00,0.00,1822.60,0.00,'2022-05-13 15:48:36','',''),(1154,'21','228','1',1,'Sale Id shift 56',0.00,0.00,0.00,1283.41,0.00,'2022-05-13 15:48:36','',''),(1155,'21','228','1',1,'Sale Id shift 56',0.00,0.00,0.00,1709.50,0.00,'2022-05-13 15:48:36','',''),(1156,'21','228','1',1,'Sale Id shift 56',0.00,0.00,0.00,2972.47,0.00,'2022-05-13 15:48:36','',''),(1157,'21','228',NULL,1,'Sale Id shift 56',4221945.75,0.00,0.00,0.00,0.00,'2022-05-13 15:48:36','',''),(1158,'21','228',NULL,2,'Sale Id shift 56',2757181.00,0.00,0.00,0.00,0.00,'2022-05-13 15:48:36','',''),(1159,'21','228',NULL,3,'Sale Id shift 56',786656.00,0.00,0.00,0.00,0.00,'2022-05-13 15:48:36','',''),(1160,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-14 20:30:12','',''),(1161,'21','228',NULL,1,'Reception corrector for bridging 98',0.00,0.00,0.00,45000.00,0.00,'2022-05-14 20:32:25','',''),(1162,'21','228','2',1,'Received from bridging 98',0.00,0.00,45000.00,0.00,0.00,'2022-05-14 20:32:25','',''),(1163,'21','228','2',1,'Sale Id shift 57',0.00,0.00,0.00,3297.08,0.00,'2022-05-14 20:54:33','',''),(1164,'21','228','2',1,'Sale Id shift 57',0.00,0.00,0.00,5213.11,0.00,'2022-05-14 20:54:33','',''),(1165,'21','228','2',1,'Sale Id shift 57',0.00,0.00,0.00,4713.89,0.00,'2022-05-14 20:54:33','',''),(1166,'21','228','2',1,'Sale Id shift 57',0.00,0.00,0.00,5186.77,0.00,'2022-05-14 20:54:33','',''),(1167,'21','228','2',1,'Sale Id shift 57',0.00,0.00,0.00,4998.69,0.00,'2022-05-14 20:54:33','',''),(1168,'21','228','2',1,'Sale Id shift 57',0.00,0.00,0.00,4786.69,0.00,'2022-05-14 20:54:33','',''),(1169,'21','228','2',1,'Sale Id shift 57',0.00,0.00,0.00,5556.02,0.00,'2022-05-14 20:54:33','',''),(1170,'21','228','1',1,'Sale Id shift 57',0.00,0.00,0.00,5032.48,0.00,'2022-05-14 20:54:33','',''),(1171,'21','228','2',1,'Sale Id shift 57',0.00,0.00,0.00,4573.59,0.00,'2022-05-14 20:54:33','',''),(1172,'21','228','3',2,'Sale Id shift 57',0.00,0.00,0.00,1322.24,0.00,'2022-05-14 20:54:33','',''),(1173,'21','228','3',2,'Sale Id shift 57',0.00,0.00,0.00,117.93,0.00,'2022-05-14 20:54:33','',''),(1174,'21','228','3',2,'Sale Id shift 57',0.00,0.00,0.00,2069.78,0.00,'2022-05-14 20:54:33','',''),(1175,'21','228','4',3,'Sale Id shift 57',0.00,0.00,0.00,1639.75,0.00,'2022-05-14 20:54:33','',''),(1176,'21','228','1',1,'Sale Id shift 57',0.00,0.00,0.00,3381.64,0.00,'2022-05-14 20:54:33','',''),(1177,'21','228','1',1,'Sale Id shift 57',0.00,0.00,0.00,57.35,0.00,'2022-05-14 20:54:33','',''),(1178,'21','228','1',1,'Sale Id shift 57',0.00,0.00,0.00,2425.84,0.00,'2022-05-14 20:54:33','',''),(1179,'21','228','1',1,'Sale Id shift 57',0.00,0.00,0.00,2844.08,0.00,'2022-05-14 20:54:33','',''),(1180,'21','228','1',1,'Sale Id shift 57',0.00,0.00,0.00,2588.14,0.00,'2022-05-14 20:54:33','',''),(1181,'21','228','1',1,'Sale Id shift 57',0.00,0.00,0.00,2689.88,0.00,'2022-05-14 20:54:33','',''),(1182,'21','228','1',1,'Sale Id shift 57',0.00,0.00,0.00,3520.22,0.00,'2022-05-14 20:54:33','',''),(1183,'21','228',NULL,1,'Sale Id shift 57',10042802.55,0.00,0.00,0.00,0.00,'2022-05-14 20:54:33','',''),(1184,'21','228',NULL,2,'Sale Id shift 57',2456965.00,0.00,0.00,0.00,0.00,'2022-05-14 20:54:33','',''),(1185,'21','228',NULL,3,'Sale Id shift 57',1065837.50,0.00,0.00,0.00,0.00,'2022-05-14 20:54:33','',''),(1186,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-14 21:09:41','',''),(1187,'21','228',NULL,1,'Reception corrector for bridging 100',0.00,0.00,0.00,17500.00,0.00,'2022-05-14 21:11:32','',''),(1188,'21','228','2',1,'Received from bridging 100',0.00,0.00,17500.00,0.00,0.00,'2022-05-14 21:11:32','',''),(1189,'21','228',NULL,1,'Reception corrector for bridging 99',0.00,0.00,0.00,32500.00,0.00,'2022-05-14 21:11:32','',''),(1190,'21','228','1',1,'Received from bridging 99',0.00,0.00,32500.00,0.00,0.00,'2022-05-14 21:11:32','',''),(1191,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,21600000.00,30000.00,0.00,0.00,'2022-05-15 19:14:56','',''),(1192,'21','228',NULL,2,'Reception corrector for bridging 101',0.00,0.00,0.00,30000.00,0.00,'2022-05-15 19:16:19','',''),(1193,'21','228','3',2,'Received from bridging 101',0.00,0.00,30000.00,0.00,0.00,'2022-05-15 19:16:19','',''),(1194,'21','228','2',1,'Sale Id shift 58',0.00,0.00,0.00,3642.16,0.00,'2022-05-15 19:35:40','',''),(1195,'21','228','2',1,'Sale Id shift 58',0.00,0.00,0.00,4187.23,0.00,'2022-05-15 19:35:40','',''),(1196,'21','228','2',1,'Sale Id shift 58',0.00,0.00,0.00,3616.69,0.00,'2022-05-15 19:35:40','',''),(1197,'21','228','2',1,'Sale Id shift 58',0.00,0.00,0.00,4099.07,0.00,'2022-05-15 19:35:40','',''),(1198,'21','228','2',1,'Sale Id shift 58',0.00,0.00,0.00,4180.56,0.00,'2022-05-15 19:35:40','',''),(1199,'21','228','2',1,'Sale Id shift 58',0.00,0.00,0.00,2817.72,0.00,'2022-05-15 19:35:40','',''),(1200,'21','228','2',1,'Sale Id shift 58',0.00,0.00,0.00,5320.30,0.00,'2022-05-15 19:35:40','',''),(1201,'21','228','1',1,'Sale Id shift 58',0.00,0.00,0.00,4829.14,0.00,'2022-05-15 19:35:40','',''),(1202,'21','228','2',1,'Sale Id shift 58',0.00,0.00,0.00,2950.45,0.00,'2022-05-15 19:35:40','',''),(1203,'21','228','3',2,'Sale Id shift 58',0.00,0.00,0.00,1866.86,0.00,'2022-05-15 19:35:40','',''),(1204,'21','228','3',2,'Sale Id shift 58',0.00,0.00,0.00,1376.76,0.00,'2022-05-15 19:35:40','',''),(1205,'21','228','4',3,'Sale Id shift 58',0.00,0.00,0.00,1829.09,0.00,'2022-05-15 19:35:40','',''),(1206,'21','228','1',1,'Sale Id shift 58',0.00,0.00,0.00,4955.09,0.00,'2022-05-15 19:35:40','',''),(1207,'21','228','1',1,'Sale Id shift 58',0.00,0.00,0.00,1.06,0.00,'2022-05-15 19:35:40','',''),(1208,'21','228','1',1,'Sale Id shift 58',0.00,0.00,0.00,1730.35,0.00,'2022-05-15 19:35:40','',''),(1209,'21','228','1',1,'Sale Id shift 58',0.00,0.00,0.00,2971.15,0.00,'2022-05-15 19:35:40','',''),(1210,'21','228','1',1,'Sale Id shift 58',0.00,0.00,0.00,3468.45,0.00,'2022-05-15 19:35:40','',''),(1211,'21','228','1',1,'Sale Id shift 58',0.00,0.00,0.00,1452.63,0.00,'2022-05-15 19:35:40','',''),(1212,'21','228','1',1,'Sale Id shift 58',0.00,0.00,0.00,3810.89,0.00,'2022-05-15 19:35:40','',''),(1213,'21','228',NULL,1,'Sale Id shift 58',8915435.10,0.00,0.00,0.00,0.00,'2022-05-15 19:35:40','',''),(1214,'21','228',NULL,2,'Sale Id shift 58',2335406.40,0.00,0.00,0.00,0.00,'2022-05-15 19:35:40','',''),(1215,'21','228',NULL,3,'Sale Id shift 58',1188908.50,0.00,0.00,0.00,0.00,'2022-05-15 19:35:40','',''),(1216,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-16 13:40:03','',''),(1217,'21','228',NULL,1,'Reception corrector for bridging 103',0.00,0.00,0.00,16000.00,0.00,'2022-05-16 13:41:37','',''),(1218,'21','228','2',1,'Received from bridging 103',0.00,0.00,16000.00,0.00,0.00,'2022-05-16 13:41:37','',''),(1219,'21','228',NULL,1,'Reception corrector for bridging 102',0.00,0.00,0.00,34000.00,0.00,'2022-05-16 13:41:37','',''),(1220,'21','228','1',1,'Received from bridging 102',0.00,0.00,34000.00,0.00,0.00,'2022-05-16 13:41:37','',''),(1221,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,19370000.00,29800.00,0.00,0.00,'2022-05-16 13:45:28','',''),(1222,'21','228',NULL,3,'Reception corrector for bridging 104',0.00,0.00,0.00,29800.00,0.00,'2022-05-16 13:46:47','',''),(1223,'21','228','4',3,'Received from bridging 104',0.00,0.00,29800.00,0.00,0.00,'2022-05-16 13:46:47','',''),(1224,'21','228','2',1,'Sale Id shift 59',0.00,0.00,0.00,3601.90,0.00,'2022-05-16 13:55:31','',''),(1225,'21','228','2',1,'Sale Id shift 59',0.00,0.00,0.00,4430.20,0.00,'2022-05-16 13:55:31','',''),(1226,'21','228','2',1,'Sale Id shift 59',0.00,0.00,0.00,4932.32,0.00,'2022-05-16 13:55:31','',''),(1227,'21','228','2',1,'Sale Id shift 59',0.00,0.00,0.00,4901.60,0.00,'2022-05-16 13:55:31','',''),(1228,'21','228','2',1,'Sale Id shift 59',0.00,0.00,0.00,3973.96,0.00,'2022-05-16 13:55:31','',''),(1229,'21','228','2',1,'Sale Id shift 59',0.00,0.00,0.00,3409.94,0.00,'2022-05-16 13:55:31','',''),(1230,'21','228','2',1,'Sale Id shift 59',0.00,0.00,0.00,5059.69,0.00,'2022-05-16 13:55:31','',''),(1231,'21','228','1',1,'Sale Id shift 59',0.00,0.00,0.00,7179.71,0.00,'2022-05-16 13:55:31','',''),(1232,'21','228','2',1,'Sale Id shift 59',0.00,0.00,0.00,3135.95,0.00,'2022-05-16 13:55:31','',''),(1233,'21','228','3',2,'Sale Id shift 59',0.00,0.00,0.00,2112.37,0.00,'2022-05-16 13:55:31','',''),(1234,'21','228','4',3,'Sale Id shift 59',0.00,0.00,0.00,2473.14,0.00,'2022-05-16 13:55:31','',''),(1235,'21','228','1',1,'Sale Id shift 59',0.00,0.00,0.00,6540.62,0.00,'2022-05-16 13:55:31','',''),(1236,'21','228','1',1,'Sale Id shift 59',0.00,0.00,0.00,4576.20,0.00,'2022-05-16 13:55:31','',''),(1237,'21','228','1',1,'Sale Id shift 59',0.00,0.00,0.00,3174.47,0.00,'2022-05-16 13:55:31','',''),(1238,'21','228','1',1,'Sale Id shift 59',0.00,0.00,0.00,5227.25,0.00,'2022-05-16 13:55:31','',''),(1239,'21','228','1',1,'Sale Id shift 59',0.00,0.00,0.00,3424.79,0.00,'2022-05-16 13:55:31','',''),(1240,'21','228','1',1,'Sale Id shift 59',0.00,0.00,0.00,5923.76,0.00,'2022-05-16 13:55:31','',''),(1241,'21','228',NULL,1,'Sale Id shift 59',11466239.40,0.00,0.00,0.00,0.00,'2022-05-16 13:55:31','',''),(1242,'21','228',NULL,2,'Sale Id shift 59',1520906.40,0.00,0.00,0.00,0.00,'2022-05-16 13:55:31','',''),(1243,'21','228',NULL,3,'Sale Id shift 59',1607541.00,0.00,0.00,0.00,0.00,'2022-05-16 13:55:31','',''),(1244,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-17 11:54:00','',''),(1245,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-17 11:55:35','',''),(1246,'21','228',NULL,1,'Reception corrector for bridging 106',0.00,0.00,0.00,45000.00,0.00,'2022-05-17 11:56:30','',''),(1247,'21','228','2',1,'Received from bridging 106',0.00,0.00,45000.00,0.00,0.00,'2022-05-17 11:56:30','',''),(1248,'21','228',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,45000.00,0.00,'2022-05-17 11:56:39','',''),(1249,'21','228','1',1,'Received from bridging 105',0.00,0.00,45000.00,0.00,0.00,'2022-05-17 11:56:39','',''),(1250,'21','228','1',1,'Sale Id shift 60',0.00,0.00,0.00,7213.27,0.00,'2022-05-17 12:00:26','',''),(1251,'21','228','3',2,'Sale Id shift 60',0.00,0.00,0.00,2012.07,0.00,'2022-05-17 12:00:26','',''),(1252,'21','228','3',2,'Sale Id shift 60',0.00,0.00,0.00,194.45,0.00,'2022-05-17 12:00:26','',''),(1253,'21','228','3',2,'Sale Id shift 60',0.00,0.00,0.00,1492.25,0.00,'2022-05-17 12:00:26','',''),(1254,'21','228','4',3,'Sale Id shift 60',0.00,0.00,0.00,1738.75,0.00,'2022-05-17 12:00:26','',''),(1255,'21','228','1',1,'Sale Id shift 60',0.00,0.00,0.00,8054.60,0.00,'2022-05-17 12:00:26','',''),(1256,'21','228','1',1,'Sale Id shift 60',0.00,0.00,0.00,54.61,0.00,'2022-05-17 12:00:26','',''),(1257,'21','228','1',1,'Sale Id shift 60',0.00,0.00,0.00,5738.62,0.00,'2022-05-17 12:00:26','',''),(1258,'21','228','1',1,'Sale Id shift 60',0.00,0.00,0.00,5158.33,0.00,'2022-05-17 12:00:26','',''),(1259,'21','228','1',1,'Sale Id shift 60',0.00,0.00,0.00,5204.93,0.00,'2022-05-17 12:00:26','',''),(1260,'21','228','1',1,'Sale Id shift 60',0.00,0.00,0.00,6324.32,0.00,'2022-05-17 12:00:26','',''),(1261,'21','228','1',1,'Sale Id shift 60',0.00,0.00,0.00,8153.19,0.00,'2022-05-17 12:00:26','',''),(1262,'21','228',NULL,2,'Sale Id shift 60',2663114.40,0.00,0.00,0.00,0.00,'2022-05-17 12:00:26','',''),(1263,'21','228',NULL,3,'Sale Id shift 60',1130187.50,0.00,0.00,0.00,0.00,'2022-05-17 12:00:26','',''),(1264,'21','228',NULL,1,'Sale Id shift 60',7573808.55,0.00,0.00,0.00,0.00,'2022-05-17 12:00:26','',''),(1265,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-18 16:29:41','',''),(1266,'21','228',NULL,1,'Reception corrector for bridging 107',0.00,0.00,0.00,45000.00,0.00,'2022-05-18 16:31:48','',''),(1267,'21','228','1',1,'Received from bridging 107',0.00,0.00,45000.00,0.00,0.00,'2022-05-18 16:31:48','',''),(1268,'21','228','2',1,'Sale Id shift 61',0.00,0.00,0.00,6447.46,0.00,'2022-05-18 16:45:57','',''),(1269,'21','228','2',1,'Sale Id shift 61',0.00,0.00,0.00,7383.46,0.00,'2022-05-18 16:45:57','',''),(1270,'21','228','2',1,'Sale Id shift 61',0.00,0.00,0.00,4086.12,0.00,'2022-05-18 16:45:57','',''),(1271,'21','228','2',1,'Sale Id shift 61',0.00,0.00,0.00,4551.86,0.00,'2022-05-18 16:45:57','',''),(1272,'21','228','2',1,'Sale Id shift 61',0.00,0.00,0.00,2206.80,0.00,'2022-05-18 16:45:57','',''),(1273,'21','228','2',1,'Sale Id shift 61',0.00,0.00,0.00,7883.99,0.00,'2022-05-18 16:45:57','',''),(1274,'21','228','2',1,'Sale Id shift 61',0.00,0.00,0.00,7337.41,0.00,'2022-05-18 16:45:57','',''),(1275,'21','228','1',1,'Sale Id shift 61',0.00,0.00,0.00,6533.60,0.00,'2022-05-18 16:45:57','',''),(1276,'21','228','2',1,'Sale Id shift 61',0.00,0.00,0.00,5301.44,0.00,'2022-05-18 16:45:57','',''),(1277,'21','228','3',2,'Sale Id shift 61',0.00,0.00,0.00,2821.36,0.00,'2022-05-18 16:45:57','',''),(1278,'21','228','3',2,'Sale Id shift 61',0.00,0.00,0.00,1329.44,0.00,'2022-05-18 16:45:57','',''),(1279,'21','228','3',2,'Sale Id shift 61',0.00,0.00,0.00,9.28,0.00,'2022-05-18 16:45:57','',''),(1280,'21','228','4',3,'Sale Id shift 61',0.00,0.00,0.00,1693.76,0.00,'2022-05-18 16:45:57','',''),(1281,'21','228','1',1,'Sale Id shift 61',0.00,0.00,0.00,6284.31,0.00,'2022-05-18 16:45:57','',''),(1282,'21','228','1',1,'Sale Id shift 61',0.00,0.00,0.00,2747.50,0.00,'2022-05-18 16:45:57','',''),(1283,'21','228','1',1,'Sale Id shift 61',0.00,0.00,0.00,4584.65,0.00,'2022-05-18 16:45:57','',''),(1284,'21','228','1',1,'Sale Id shift 61',0.00,0.00,0.00,4308.29,0.00,'2022-05-18 16:45:57','',''),(1285,'21','228','1',1,'Sale Id shift 61',0.00,0.00,0.00,4235.09,0.00,'2022-05-18 16:45:57','',''),(1286,'21','228','1',1,'Sale Id shift 61',0.00,0.00,0.00,5309.34,0.00,'2022-05-18 16:45:57','',''),(1287,'21','228',NULL,1,'Sale Id shift 61',13068217.80,0.00,0.00,0.00,0.00,'2022-05-18 16:45:57','',''),(1288,'21','228',NULL,2,'Sale Id shift 61',2995257.60,0.00,0.00,0.00,0.00,'2022-05-18 16:45:57','',''),(1289,'21','228',NULL,3,'Sale Id shift 61',1100944.00,0.00,0.00,0.00,0.00,'2022-05-18 16:45:57','',''),(1290,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 18:48:42','',''),(1291,'21','228',NULL,1,'Reception corrector for bridging 108',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 18:49:34','',''),(1292,'21','228','1',1,'Received from bridging 108',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 18:49:34','',''),(1293,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 18:53:34','',''),(1294,'21','228',NULL,1,'Reception corrector for bridging 109',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 18:54:26','',''),(1295,'21','228','2',1,'Received from bridging 109',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 18:54:26','',''),(1296,'21','228','1',1,'Sale Id shift 62',0.00,0.00,0.00,8520.07,0.00,'2022-05-19 19:01:29','',''),(1297,'21','228','3',2,'Sale Id shift 62',0.00,0.00,0.00,2019.30,0.00,'2022-05-19 19:01:29','',''),(1298,'21','228','3',2,'Sale Id shift 62',0.00,0.00,0.00,131.73,0.00,'2022-05-19 19:01:29','',''),(1299,'21','228','3',2,'Sale Id shift 62',0.00,0.00,0.00,2533.80,0.00,'2022-05-19 19:01:29','',''),(1300,'21','228','3',2,'Sale Id shift 62',0.00,0.00,0.00,10.56,0.00,'2022-05-19 19:01:29','',''),(1301,'21','228','4',3,'Sale Id shift 62',0.00,0.00,0.00,1108.96,0.00,'2022-05-19 19:01:29','',''),(1302,'21','228','1',1,'Sale Id shift 62',0.00,0.00,0.00,6983.39,0.00,'2022-05-19 19:01:29','',''),(1303,'21','228','1',1,'Sale Id shift 62',0.00,0.00,0.00,4080.86,0.00,'2022-05-19 19:01:29','',''),(1304,'21','228','1',1,'Sale Id shift 62',0.00,0.00,0.00,4733.52,0.00,'2022-05-19 19:01:29','',''),(1305,'21','228','1',1,'Sale Id shift 62',0.00,0.00,0.00,5600.73,0.00,'2022-05-19 19:01:29','',''),(1306,'21','228','1',1,'Sale Id shift 62',0.00,0.00,0.00,5514.25,0.00,'2022-05-19 19:01:29','',''),(1307,'21','228','1',1,'Sale Id shift 62',0.00,0.00,0.00,6615.23,0.00,'2022-05-19 19:01:29','',''),(1308,'21','228','1',1,'Sale Id shift 62',0.00,0.00,0.00,9444.42,0.00,'2022-05-19 19:01:29','',''),(1309,'21','228',NULL,2,'Sale Id shift 62',3380680.80,0.00,0.00,0.00,0.00,'2022-05-19 19:01:29','',''),(1310,'21','228',NULL,3,'Sale Id shift 62',720824.00,0.00,0.00,0.00,0.00,'2022-05-19 19:01:29','',''),(1311,'21','228',NULL,1,'Sale Id shift 62',8496257.55,0.00,0.00,0.00,0.00,'2022-05-19 19:01:29','',''),(1312,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-20 21:06:16','',''),(1313,'21','228',NULL,1,'Reception corrector for bridging 110',0.00,0.00,0.00,45000.00,0.00,'2022-05-20 21:08:06','',''),(1314,'21','228','1',1,'Received from bridging 110',0.00,0.00,45000.00,0.00,0.00,'2022-05-20 21:08:06','',''),(1315,'21','228','2',1,'Sale Id shift 63',0.00,0.00,0.00,2218.92,0.00,'2022-05-20 21:18:25','',''),(1316,'21','228','2',1,'Sale Id shift 63',0.00,0.00,0.00,2693.42,0.00,'2022-05-20 21:18:25','',''),(1317,'21','228','2',1,'Sale Id shift 63',0.00,0.00,0.00,3339.15,0.00,'2022-05-20 21:18:25','',''),(1318,'21','228','2',1,'Sale Id shift 63',0.00,0.00,0.00,1523.26,0.00,'2022-05-20 21:18:25','',''),(1319,'21','228','2',1,'Sale Id shift 63',0.00,0.00,0.00,2111.31,0.00,'2022-05-20 21:18:25','',''),(1320,'21','228','2',1,'Sale Id shift 63',0.00,0.00,0.00,2380.52,0.00,'2022-05-20 21:18:25','',''),(1321,'21','228','2',1,'Sale Id shift 63',0.00,0.00,0.00,1848.40,0.00,'2022-05-20 21:18:25','',''),(1322,'21','228','1',1,'Sale Id shift 63',0.00,0.00,0.00,6231.85,0.00,'2022-05-20 21:18:25','',''),(1323,'21','228','2',1,'Sale Id shift 63',0.00,0.00,0.00,2374.67,0.00,'2022-05-20 21:18:25','',''),(1324,'21','228','3',2,'Sale Id shift 63',0.00,0.00,0.00,1797.27,0.00,'2022-05-20 21:18:25','',''),(1325,'21','228','3',2,'Sale Id shift 63',0.00,0.00,0.00,2514.85,0.00,'2022-05-20 21:18:25','',''),(1326,'21','228','4',3,'Sale Id shift 63',0.00,0.00,0.00,0.10,0.00,'2022-05-20 21:18:25','',''),(1327,'21','228','4',3,'Sale Id shift 63',0.00,0.00,0.00,1187.28,0.00,'2022-05-20 21:18:25','',''),(1328,'21','228','1',1,'Sale Id shift 63',0.00,0.00,0.00,4147.11,0.00,'2022-05-20 21:18:25','',''),(1329,'21','228','1',1,'Sale Id shift 63',0.00,0.00,0.00,3362.43,0.00,'2022-05-20 21:18:25','',''),(1330,'21','228','1',1,'Sale Id shift 63',0.00,0.00,0.00,3653.07,0.00,'2022-05-20 21:18:25','',''),(1331,'21','228','1',1,'Sale Id shift 63',0.00,0.00,0.00,3536.68,0.00,'2022-05-20 21:18:25','',''),(1332,'21','228','1',1,'Sale Id shift 63',0.00,0.00,0.00,3732.56,0.00,'2022-05-20 21:18:25','',''),(1333,'21','228','1',1,'Sale Id shift 63',0.00,0.00,0.00,3731.64,0.00,'2022-05-20 21:18:25','',''),(1334,'21','228','1',1,'Sale Id shift 63',0.00,0.00,0.00,6155.05,0.00,'2022-05-20 21:18:25','',''),(1335,'21','228',NULL,2,'Sale Id shift 63',3104726.40,0.00,0.00,0.00,0.00,'2022-05-20 21:18:25','',''),(1336,'21','228',NULL,3,'Sale Id shift 63',771797.00,0.00,0.00,0.00,0.00,'2022-05-20 21:18:25','',''),(1337,'21','228',NULL,1,'Sale Id shift 63',8751606.60,0.00,0.00,0.00,0.00,'2022-05-20 21:18:25','',''),(1338,'21','228','2',1,'Sale Id shift 64',0.00,0.00,0.00,3882.28,0.00,'2022-05-21 11:26:03','',''),(1339,'21','228','2',1,'Sale Id shift 64',0.00,0.00,0.00,3355.38,0.00,'2022-05-21 11:26:03','',''),(1340,'21','228','2',1,'Sale Id shift 64',0.00,0.00,0.00,3319.23,0.00,'2022-05-21 11:26:03','',''),(1341,'21','228','2',1,'Sale Id shift 64',0.00,0.00,0.00,2799.51,0.00,'2022-05-21 11:26:03','',''),(1342,'21','228','2',1,'Sale Id shift 64',0.00,0.00,0.00,3090.05,0.00,'2022-05-21 11:26:03','',''),(1343,'21','228','2',1,'Sale Id shift 64',0.00,0.00,0.00,3658.04,0.00,'2022-05-21 11:26:03','',''),(1344,'21','228','2',1,'Sale Id shift 64',0.00,0.00,0.00,3386.38,0.00,'2022-05-21 11:26:03','',''),(1345,'21','228','1',1,'Sale Id shift 64',0.00,0.00,0.00,1755.47,0.00,'2022-05-21 11:26:03','',''),(1346,'21','228','2',1,'Sale Id shift 64',0.00,0.00,0.00,3287.37,0.00,'2022-05-21 11:26:03','',''),(1347,'21','228','3',2,'Sale Id shift 64',0.00,0.00,0.00,1577.63,0.00,'2022-05-21 11:26:03','',''),(1348,'21','228','3',2,'Sale Id shift 64',0.00,0.00,0.00,880.26,0.00,'2022-05-21 11:26:03','',''),(1349,'21','228','3',2,'Sale Id shift 64',0.00,0.00,0.00,834.11,0.00,'2022-05-21 11:26:03','',''),(1350,'21','228','4',3,'Sale Id shift 64',0.00,0.00,0.00,1152.81,0.00,'2022-05-21 11:26:03','',''),(1351,'21','228','1',1,'Sale Id shift 64',0.00,0.00,0.00,1530.31,0.00,'2022-05-21 11:26:03','',''),(1352,'21','228','1',1,'Sale Id shift 64',0.00,0.00,0.00,3.88,0.00,'2022-05-21 11:26:03','',''),(1353,'21','228','1',1,'Sale Id shift 64',0.00,0.00,0.00,1095.04,0.00,'2022-05-21 11:26:03','',''),(1354,'21','228','1',1,'Sale Id shift 64',0.00,0.00,0.00,1250.88,0.00,'2022-05-21 11:26:03','',''),(1355,'21','228','1',1,'Sale Id shift 64',0.00,0.00,0.00,1175.74,0.00,'2022-05-21 11:26:03','',''),(1356,'21','228','1',1,'Sale Id shift 64',0.00,0.00,0.00,1250.97,0.00,'2022-05-21 11:26:03','',''),(1357,'21','228','1',1,'Sale Id shift 64',0.00,0.00,0.00,1347.30,0.00,'2022-05-21 11:26:03','',''),(1358,'21','228',NULL,1,'Sale Id shift 64',5970991.95,0.00,0.00,0.00,0.00,'2022-05-21 11:26:03','',''),(1359,'21','228',NULL,2,'Sale Id shift 64',2370240.00,0.00,0.00,0.00,0.00,'2022-05-21 11:26:03','',''),(1360,'21','228',NULL,3,'Sale Id shift 64',749326.50,0.00,0.00,0.00,0.00,'2022-05-21 11:26:03','',''),(1361,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-22 15:10:34','',''),(1362,'21','228',NULL,1,'Reception corrector for bridging 111',0.00,0.00,0.00,45000.00,0.00,'2022-05-22 15:13:21','',''),(1363,'21','228','1',1,'Received from bridging 111',0.00,0.00,45000.00,0.00,0.00,'2022-05-22 15:13:21','',''),(1364,'21','228','1',1,'Sale Id shift 65',0.00,0.00,0.00,7882.93,0.00,'2022-05-22 15:20:43','',''),(1365,'21','228','3',2,'Sale Id shift 65',0.00,0.00,0.00,2281.74,0.00,'2022-05-22 15:20:43','',''),(1366,'21','228','3',2,'Sale Id shift 65',0.00,0.00,0.00,829.03,0.00,'2022-05-22 15:20:43','',''),(1367,'21','228','3',2,'Sale Id shift 65',0.00,0.00,0.00,2859.53,0.00,'2022-05-22 15:20:43','',''),(1368,'21','228','4',3,'Sale Id shift 65',0.00,0.00,0.00,1180.40,0.00,'2022-05-22 15:20:43','',''),(1369,'21','228','1',1,'Sale Id shift 65',0.00,0.00,0.00,4817.14,0.00,'2022-05-22 15:20:43','',''),(1370,'21','228','1',1,'Sale Id shift 65',0.00,0.00,0.00,4496.47,0.00,'2022-05-22 15:20:43','',''),(1371,'21','228','1',1,'Sale Id shift 65',0.00,0.00,0.00,4604.29,0.00,'2022-05-22 15:20:43','',''),(1372,'21','228','1',1,'Sale Id shift 65',0.00,0.00,0.00,5346.83,0.00,'2022-05-22 15:20:43','',''),(1373,'21','228','1',1,'Sale Id shift 65',0.00,0.00,0.00,5327.84,0.00,'2022-05-22 15:20:43','',''),(1374,'21','228','1',1,'Sale Id shift 65',0.00,0.00,0.00,6099.75,0.00,'2022-05-22 15:20:43','',''),(1375,'21','228','1',1,'Sale Id shift 65',0.00,0.00,0.00,7815.33,0.00,'2022-05-22 15:20:43','',''),(1376,'21','228',NULL,1,'Sale Id shift 65',7654445.70,0.00,0.00,0.00,0.00,'2022-05-22 15:20:43','',''),(1377,'21','228',NULL,2,'Sale Id shift 65',4298616.00,0.00,0.00,0.00,0.00,'2022-05-22 15:20:43','',''),(1378,'21','228',NULL,3,'Sale Id shift 65',767260.00,0.00,0.00,0.00,0.00,'2022-05-22 15:20:43','',''),(1379,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-23 19:00:40','',''),(1380,'21','228',NULL,1,'Reception corrector for bridging 112',0.00,0.00,0.00,45000.00,0.00,'2022-05-23 19:02:13','',''),(1381,'21','228','1',1,'Received from bridging 112',0.00,0.00,45000.00,0.00,0.00,'2022-05-23 19:02:13','',''),(1382,'21','228','1',1,'Sale Id shift 66',0.00,0.00,0.00,7483.85,0.00,'2022-05-23 19:08:20','',''),(1383,'21','228','3',2,'Sale Id shift 66',0.00,0.00,0.00,2062.26,0.00,'2022-05-23 19:08:20','',''),(1384,'21','228','3',2,'Sale Id shift 66',0.00,0.00,0.00,312.50,0.00,'2022-05-23 19:08:20','',''),(1385,'21','228','4',3,'Sale Id shift 66',0.00,0.00,0.00,849.28,0.00,'2022-05-23 19:08:20','',''),(1386,'21','228','1',1,'Sale Id shift 66',0.00,0.00,0.00,7151.19,0.00,'2022-05-23 19:08:20','',''),(1387,'21','228','1',1,'Sale Id shift 66',0.00,0.00,0.00,1180.20,0.00,'2022-05-23 19:08:20','',''),(1388,'21','228','1',1,'Sale Id shift 66',0.00,0.00,0.00,4499.08,0.00,'2022-05-23 19:08:20','',''),(1389,'21','228','1',1,'Sale Id shift 66',0.00,0.00,0.00,5847.24,0.00,'2022-05-23 19:08:20','',''),(1390,'21','228','1',1,'Sale Id shift 66',0.00,0.00,0.00,5359.76,0.00,'2022-05-23 19:08:20','',''),(1391,'21','228','1',1,'Sale Id shift 66',0.00,0.00,0.00,6066.94,0.00,'2022-05-23 19:08:20','',''),(1392,'21','228','1',1,'Sale Id shift 66',0.00,0.00,0.00,8355.54,0.00,'2022-05-23 19:08:20','',''),(1393,'21','228',NULL,2,'Sale Id shift 66',1709827.20,0.00,0.00,0.00,0.00,'2022-05-23 19:08:20','',''),(1394,'21','228',NULL,3,'Sale Id shift 66',552032.00,0.00,0.00,0.00,0.00,'2022-05-23 19:08:20','',''),(1395,'21','228',NULL,1,'Sale Id shift 66',7580727.00,0.00,0.00,0.00,0.00,'2022-05-23 19:08:20','',''),(1396,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-24 18:59:09','',''),(1397,'21','228',NULL,1,'Reception corrector for bridging 114',0.00,0.00,0.00,17000.00,0.00,'2022-05-24 19:01:35','',''),(1398,'21','228','2',1,'Received from bridging 114',0.00,0.00,17000.00,0.00,0.00,'2022-05-24 19:01:35','',''),(1399,'21','228',NULL,1,'Reception corrector for bridging 113',0.00,0.00,0.00,33000.00,0.00,'2022-05-24 19:01:35','',''),(1400,'21','228','1',1,'Received from bridging 113',0.00,0.00,33000.00,0.00,0.00,'2022-05-24 19:01:35','',''),(1401,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,20160000.00,28000.00,0.00,0.00,'2022-05-24 19:02:00','',''),(1402,'21','228',NULL,2,'Reception corrector for bridging 115',0.00,0.00,0.00,28000.00,0.00,'2022-05-24 19:09:33','',''),(1403,'21','228','3',2,'Received from bridging 115',0.00,0.00,28000.00,0.00,0.00,'2022-05-24 19:09:33','',''),(1404,'21','228','2',1,'Sale Id shift 67',0.00,0.00,0.00,1915.65,0.00,'2022-05-24 19:26:10','',''),(1405,'21','228','2',1,'Sale Id shift 67',0.00,0.00,0.00,1114.29,0.00,'2022-05-24 19:26:10','',''),(1406,'21','228','2',1,'Sale Id shift 67',0.00,0.00,0.00,1321.81,0.00,'2022-05-24 19:26:10','',''),(1407,'21','228','2',1,'Sale Id shift 67',0.00,0.00,0.00,1197.41,0.00,'2022-05-24 19:26:10','',''),(1408,'21','228','2',1,'Sale Id shift 67',0.00,0.00,0.00,225.48,0.00,'2022-05-24 19:26:10','',''),(1409,'21','228','2',1,'Sale Id shift 67',0.00,0.00,0.00,1394.70,0.00,'2022-05-24 19:26:10','',''),(1410,'21','228','1',1,'Sale Id shift 67',0.00,0.00,0.00,6852.09,0.00,'2022-05-24 19:26:10','',''),(1411,'21','228','3',2,'Sale Id shift 67',0.00,0.00,0.00,2118.00,0.00,'2022-05-24 19:26:10','',''),(1412,'21','228','3',2,'Sale Id shift 67',0.00,0.00,0.00,765.47,0.00,'2022-05-24 19:26:10','',''),(1413,'21','228','3',2,'Sale Id shift 67',0.00,0.00,0.00,1660.99,0.00,'2022-05-24 19:26:10','',''),(1414,'21','228','4',3,'Sale Id shift 67',0.00,0.00,0.00,1658.34,0.00,'2022-05-24 19:26:10','',''),(1415,'21','228','1',1,'Sale Id shift 67',0.00,0.00,0.00,6404.34,0.00,'2022-05-24 19:26:10','',''),(1416,'21','228','1',1,'Sale Id shift 67',0.00,0.00,0.00,1184.73,0.00,'2022-05-24 19:26:10','',''),(1417,'21','228','1',1,'Sale Id shift 67',0.00,0.00,0.00,4788.44,0.00,'2022-05-24 19:26:10','',''),(1418,'21','228','1',1,'Sale Id shift 67',0.00,0.00,0.00,5836.95,0.00,'2022-05-24 19:26:10','',''),(1419,'21','228','1',1,'Sale Id shift 67',0.00,0.00,0.00,6285.72,0.00,'2022-05-24 19:26:10','',''),(1420,'21','228','1',1,'Sale Id shift 67',0.00,0.00,0.00,5996.74,0.00,'2022-05-24 19:26:10','',''),(1421,'21','228','1',1,'Sale Id shift 67',0.00,0.00,0.00,8103.94,0.00,'2022-05-24 19:26:10','',''),(1422,'21','228',NULL,1,'Sale Id shift 67',8682677.85,0.00,0.00,0.00,0.00,'2022-05-24 19:26:10','',''),(1423,'21','228',NULL,2,'Sale Id shift 67',3453789.60,0.00,0.00,0.00,0.00,'2022-05-24 19:26:10','',''),(1424,'21','228',NULL,3,'Sale Id shift 67',1077921.00,0.00,0.00,0.00,0.00,'2022-05-24 19:26:10','',''),(1425,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-24 19:55:47','',''),(1426,'21','228',NULL,1,'Reception corrector for bridging 116',0.00,0.00,0.00,45000.00,0.00,'2022-05-24 19:56:35','',''),(1427,'21','228','1',1,'Received from bridging 116',0.00,0.00,45000.00,0.00,0.00,'2022-05-24 19:56:35','',''),(1428,'21','228','2',1,'Sale Id shift 68',0.00,0.00,0.00,1664.49,0.00,'2022-05-25 19:26:10','',''),(1429,'21','228','2',1,'Sale Id shift 68',0.00,0.00,0.00,689.70,0.00,'2022-05-25 19:26:10','',''),(1430,'21','228','2',1,'Sale Id shift 68',0.00,0.00,0.00,1501.22,0.00,'2022-05-25 19:26:10','',''),(1431,'21','228','2',1,'Sale Id shift 68',0.00,0.00,0.00,1439.33,0.00,'2022-05-25 19:26:10','',''),(1432,'21','228','2',1,'Sale Id shift 68',0.00,0.00,0.00,2193.47,0.00,'2022-05-25 19:26:10','',''),(1433,'21','228','2',1,'Sale Id shift 68',0.00,0.00,0.00,29.90,0.00,'2022-05-25 19:26:10','',''),(1434,'21','228','2',1,'Sale Id shift 68',0.00,0.00,0.00,1348.67,0.00,'2022-05-25 19:26:10','',''),(1435,'21','228','1',1,'Sale Id shift 68',0.00,0.00,0.00,6864.75,0.00,'2022-05-25 19:26:10','',''),(1436,'21','228','2',1,'Sale Id shift 68',0.00,0.00,0.00,920.02,0.00,'2022-05-25 19:26:10','',''),(1437,'21','228','3',2,'Sale Id shift 68',0.00,0.00,0.00,545.45,0.00,'2022-05-25 19:26:10','',''),(1438,'21','228','3',2,'Sale Id shift 68',0.00,0.00,0.00,782.77,0.00,'2022-05-25 19:26:10','',''),(1439,'21','228','3',2,'Sale Id shift 68',0.00,0.00,0.00,1502.75,0.00,'2022-05-25 19:26:10','',''),(1440,'21','228','4',3,'Sale Id shift 68',0.00,0.00,0.00,1279.18,0.00,'2022-05-25 19:26:10','',''),(1441,'21','228','1',1,'Sale Id shift 68',0.00,0.00,0.00,4934.11,0.00,'2022-05-25 19:26:10','',''),(1442,'21','228','1',1,'Sale Id shift 68',0.00,0.00,0.00,1438.43,0.00,'2022-05-25 19:26:10','',''),(1443,'21','228','1',1,'Sale Id shift 68',0.00,0.00,0.00,3046.15,0.00,'2022-05-25 19:26:10','',''),(1444,'21','228','1',1,'Sale Id shift 68',0.00,0.00,0.00,4564.18,0.00,'2022-05-25 19:26:10','',''),(1445,'21','228','1',1,'Sale Id shift 68',0.00,0.00,0.00,3038.26,0.00,'2022-05-25 19:26:10','',''),(1446,'21','228','1',1,'Sale Id shift 68',0.00,0.00,0.00,5477.46,0.00,'2022-05-25 19:26:10','',''),(1447,'21','228','1',1,'Sale Id shift 68',0.00,0.00,0.00,6568.50,0.00,'2022-05-25 19:26:10','',''),(1448,'21','228',NULL,1,'Sale Id shift 68',7543575.60,0.00,0.00,0.00,0.00,'2022-05-25 19:26:10','',''),(1449,'21','228',NULL,2,'Sale Id shift 68',2151537.20,0.00,0.00,0.00,0.00,'2022-05-25 19:26:10','',''),(1450,'21','228',NULL,3,'Sale Id shift 68',831467.00,0.00,0.00,0.00,0.00,'2022-05-25 19:26:10','',''),(1451,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 19:51:13','',''),(1452,'21','228',NULL,1,'Reception corrector for bridging 117',0.00,0.00,0.00,45000.00,0.00,'2022-05-25 19:52:38','',''),(1453,'21','228','1',1,'Received from bridging 117',0.00,0.00,45000.00,0.00,0.00,'2022-05-25 19:52:38','',''),(1454,'21','228','1',1,'Sale Id shift 69',0.00,0.00,0.00,8269.73,0.00,'2022-05-26 17:20:27','',''),(1455,'21','228','3',2,'Sale Id shift 69',0.00,0.00,0.00,1704.28,0.00,'2022-05-26 17:20:27','',''),(1456,'21','228','3',2,'Sale Id shift 69',0.00,0.00,0.00,185.49,0.00,'2022-05-26 17:20:27','',''),(1457,'21','228','3',2,'Sale Id shift 69',0.00,0.00,0.00,1106.87,0.00,'2022-05-26 17:20:27','',''),(1458,'21','228','4',3,'Sale Id shift 69',0.00,0.00,0.00,1212.40,0.00,'2022-05-26 17:20:27','',''),(1459,'21','228','1',1,'Sale Id shift 69',0.00,0.00,0.00,7147.39,0.00,'2022-05-26 17:20:27','',''),(1460,'21','228','1',1,'Sale Id shift 69',0.00,0.00,0.00,150.45,0.00,'2022-05-26 17:20:27','',''),(1461,'21','228','1',1,'Sale Id shift 69',0.00,0.00,0.00,5184.78,0.00,'2022-05-26 17:20:27','',''),(1462,'21','228','1',1,'Sale Id shift 69',0.00,0.00,0.00,6918.13,0.00,'2022-05-26 17:20:27','',''),(1463,'21','228','1',1,'Sale Id shift 69',0.00,0.00,0.00,5244.47,0.00,'2022-05-26 17:20:27','',''),(1464,'21','228','1',1,'Sale Id shift 69',0.00,0.00,0.00,7948.07,0.00,'2022-05-26 17:20:27','',''),(1465,'21','228','1',1,'Sale Id shift 69',0.00,0.00,0.00,8169.87,0.00,'2022-05-26 17:20:27','',''),(1466,'21','228',NULL,1,'Sale Id shift 69',8090426.85,0.00,0.00,0.00,0.00,'2022-05-26 17:20:27','',''),(1467,'21','228',NULL,2,'Sale Id shift 69',2277446.40,0.00,0.00,0.00,0.00,'2022-05-26 17:20:27','',''),(1468,'21','228',NULL,3,'Sale Id shift 69',788060.00,0.00,0.00,0.00,0.00,'2022-05-26 17:20:27','',''),(1469,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-27 14:30:02','',''),(1470,'21','228',NULL,1,'Reception corrector for bridging 118',0.00,0.00,0.00,45000.00,0.00,'2022-05-27 14:31:15','',''),(1471,'21','228','1',1,'Received from bridging 118',0.00,0.00,45000.00,0.00,0.00,'2022-05-27 14:31:15','',''),(1472,'21','228','1',1,'Sale Id shift 70',0.00,0.00,0.00,10416.44,0.00,'2022-05-27 14:36:35','',''),(1473,'21','228','3',2,'Sale Id shift 70',0.00,0.00,0.00,1470.22,0.00,'2022-05-27 14:36:35','',''),(1474,'21','228','3',2,'Sale Id shift 70',0.00,0.00,0.00,79.40,0.00,'2022-05-27 14:36:35','',''),(1475,'21','228','3',2,'Sale Id shift 70',0.00,0.00,0.00,2603.55,0.00,'2022-05-27 14:36:35','',''),(1476,'21','228','4',3,'Sale Id shift 70',0.00,0.00,0.00,1343.08,0.00,'2022-05-27 14:36:35','',''),(1477,'21','228','1',1,'Sale Id shift 70',0.00,0.00,0.00,9462.74,0.00,'2022-05-27 14:36:35','',''),(1478,'21','228','1',1,'Sale Id shift 70',0.00,0.00,0.00,1867.25,0.00,'2022-05-27 14:36:35','',''),(1479,'21','228','1',1,'Sale Id shift 70',0.00,0.00,0.00,6579.04,0.00,'2022-05-27 14:36:35','',''),(1480,'21','228','1',1,'Sale Id shift 70',0.00,0.00,0.00,7824.83,0.00,'2022-05-27 14:36:35','',''),(1481,'21','228','1',1,'Sale Id shift 70',0.00,0.00,0.00,6878.49,0.00,'2022-05-27 14:36:35','',''),(1482,'21','228','1',1,'Sale Id shift 70',0.00,0.00,0.00,9106.91,0.00,'2022-05-27 14:36:35','',''),(1483,'21','228','1',1,'Sale Id shift 70',0.00,0.00,0.00,10230.77,0.00,'2022-05-27 14:36:35','',''),(1484,'21','228',NULL,1,'Sale Id shift 70',10290467.55,0.00,0.00,0.00,0.00,'2022-05-27 14:36:35','',''),(1485,'21','228',NULL,2,'Sale Id shift 70',3156409.20,0.00,0.00,0.00,0.00,'2022-05-27 14:36:35','',''),(1486,'21','228',NULL,3,'Sale Id shift 70',873002.00,0.00,0.00,0.00,0.00,'2022-05-27 14:36:35','',''),(1487,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-28 13:38:53','',''),(1488,'21','228',NULL,1,'Reception corrector for bridging 119',0.00,0.00,0.00,45000.00,0.00,'2022-05-28 13:41:51','',''),(1489,'21','228','1',1,'Received from bridging 119',0.00,0.00,45000.00,0.00,0.00,'2022-05-28 13:41:51','',''),(1490,'21','228','1',1,'Sale Id shift 71',0.00,0.00,0.00,2594.28,0.00,'2022-05-28 13:55:45','',''),(1491,'21','228','3',2,'Sale Id shift 71',0.00,0.00,0.00,3157.04,0.00,'2022-05-28 13:55:45','',''),(1492,'21','228','3',2,'Sale Id shift 71',0.00,0.00,0.00,1129.00,0.00,'2022-05-28 13:55:45','',''),(1493,'21','228','3',2,'Sale Id shift 71',0.00,0.00,0.00,1896.65,0.00,'2022-05-28 13:55:45','',''),(1494,'21','228','4',3,'Sale Id shift 71',0.00,0.00,0.00,1045.86,0.00,'2022-05-28 13:55:45','',''),(1495,'21','228','1',1,'Sale Id shift 71',0.00,0.00,0.00,2259.65,0.00,'2022-05-28 13:55:45','',''),(1496,'21','228','1',1,'Sale Id shift 71',0.00,0.00,0.00,1690.55,0.00,'2022-05-28 13:55:45','',''),(1497,'21','228','1',1,'Sale Id shift 71',0.00,0.00,0.00,1925.43,0.00,'2022-05-28 13:55:45','',''),(1498,'21','228','1',1,'Sale Id shift 71',0.00,0.00,0.00,1523.40,0.00,'2022-05-28 13:55:45','',''),(1499,'21','228','1',1,'Sale Id shift 71',0.00,0.00,0.00,2544.75,0.00,'2022-05-28 13:55:45','',''),(1500,'21','228','1',1,'Sale Id shift 71',0.00,0.00,0.00,2580.67,0.00,'2022-05-28 13:55:45','',''),(1501,'21','228',NULL,1,'Sale Id shift 71',2494590.45,0.00,0.00,0.00,0.00,'2022-05-28 13:55:45','',''),(1502,'21','228',NULL,2,'Sale Id shift 71',4698844.40,0.00,0.00,0.00,0.00,'2022-05-28 13:55:45','',''),(1503,'21','228',NULL,3,'Sale Id shift 71',679809.00,0.00,0.00,0.00,0.00,'2022-05-28 13:55:45','',''),(1504,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-29 21:36:33','',''),(1505,'21','228',NULL,1,'Reception corrector for bridging 120',0.00,0.00,0.00,45000.00,0.00,'2022-05-29 21:37:41','',''),(1506,'21','228','1',1,'Received from bridging 120',0.00,0.00,45000.00,0.00,0.00,'2022-05-29 21:37:41','',''),(1507,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,13908000.00,18300.00,0.00,0.00,'2022-05-29 21:37:51','',''),(1508,'21','228',NULL,2,'Reception corrector for bridging 121',0.00,0.00,0.00,18300.00,0.00,'2022-05-29 21:38:53','',''),(1509,'21','228','3',2,'Received from bridging 121',0.00,0.00,18300.00,0.00,0.00,'2022-05-29 21:38:53','',''),(1510,'21','228','1',1,'Sale Id shift 72',0.00,0.00,0.00,8568.83,0.00,'2022-05-29 21:47:39','',''),(1511,'21','228','3',2,'Sale Id shift 72',0.00,0.00,0.00,1916.24,0.00,'2022-05-29 21:47:39','',''),(1512,'21','228','3',2,'Sale Id shift 72',0.00,0.00,0.00,306.05,0.00,'2022-05-29 21:47:39','',''),(1513,'21','228','3',2,'Sale Id shift 72',0.00,0.00,0.00,4554.53,0.00,'2022-05-29 21:47:39','',''),(1514,'21','228','4',3,'Sale Id shift 72',0.00,0.00,0.00,1322.92,0.00,'2022-05-29 21:47:39','',''),(1515,'21','228','1',1,'Sale Id shift 72',0.00,0.00,0.00,6294.50,0.00,'2022-05-29 21:47:39','',''),(1516,'21','228','1',1,'Sale Id shift 72',0.00,0.00,0.00,5579.55,0.00,'2022-05-29 21:47:39','',''),(1517,'21','228','1',1,'Sale Id shift 72',0.00,0.00,0.00,5315.70,0.00,'2022-05-29 21:47:39','',''),(1518,'21','228','1',1,'Sale Id shift 72',0.00,0.00,0.00,6740.90,0.00,'2022-05-29 21:47:39','',''),(1519,'21','228','1',1,'Sale Id shift 72',0.00,0.00,0.00,6650.67,0.00,'2022-05-29 21:47:39','',''),(1520,'21','228','1',1,'Sale Id shift 72',0.00,0.00,0.00,6547.59,0.00,'2022-05-29 21:47:39','',''),(1521,'21','228','1',1,'Sale Id shift 72',0.00,0.00,0.00,8595.06,0.00,'2022-05-29 21:47:39','',''),(1522,'21','228',NULL,2,'Sale Id shift 72',5150383.20,0.00,0.00,0.00,0.00,'2022-05-29 21:47:39','',''),(1523,'21','228',NULL,3,'Sale Id shift 72',859898.00,0.00,0.00,0.00,0.00,'2022-05-29 21:47:39','',''),(1524,'21','228',NULL,1,'Sale Id shift 72',8958312.00,0.00,0.00,0.00,0.00,'2022-05-29 21:47:39','',''),(1525,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-29 22:00:08','',''),(1526,'21','228',NULL,1,'Reception corrector for bridging 122',0.00,0.00,0.00,40000.00,0.00,'2022-05-29 22:01:18','',''),(1527,'21','228','1',1,'Received from bridging 122',0.00,0.00,40000.00,0.00,0.00,'2022-05-29 22:01:18','',''),(1528,'21','228','1',1,'Sale Id shift 73',0.00,0.00,0.00,6413.51,0.00,'2022-05-30 19:48:24','',''),(1529,'21','228','3',2,'Sale Id shift 73',0.00,0.00,0.00,1838.27,0.00,'2022-05-30 19:48:24','',''),(1530,'21','228','3',2,'Sale Id shift 73',0.00,0.00,0.00,1090.32,0.00,'2022-05-30 19:48:24','',''),(1531,'21','228','4',3,'Sale Id shift 73',0.00,0.00,0.00,1245.60,0.00,'2022-05-30 19:48:24','',''),(1532,'21','228','1',1,'Sale Id shift 73',0.00,0.00,0.00,4483.90,0.00,'2022-05-30 19:48:24','',''),(1533,'21','228','1',1,'Sale Id shift 73',0.00,0.00,0.00,4852.18,0.00,'2022-05-30 19:48:24','',''),(1534,'21','228','1',1,'Sale Id shift 73',0.00,0.00,0.00,4755.51,0.00,'2022-05-30 19:48:24','',''),(1535,'21','228','1',1,'Sale Id shift 73',0.00,0.00,0.00,4975.19,0.00,'2022-05-30 19:48:24','',''),(1536,'21','228','1',1,'Sale Id shift 73',0.00,0.00,0.00,4954.12,0.00,'2022-05-30 19:48:24','',''),(1537,'21','228','1',1,'Sale Id shift 73',0.00,0.00,0.00,5740.39,0.00,'2022-05-30 19:48:24','',''),(1538,'21','228','1',1,'Sale Id shift 73',0.00,0.00,0.00,6720.29,0.00,'2022-05-30 19:48:24','',''),(1539,'21','228',NULL,2,'Sale Id shift 73',2225728.40,0.00,0.00,0.00,0.00,'2022-05-30 19:48:24','',''),(1540,'21','228',NULL,3,'Sale Id shift 73',809640.00,0.00,0.00,0.00,0.00,'2022-05-30 19:48:24','',''),(1541,'21','228',NULL,1,'Sale Id shift 73',7077689.85,0.00,0.00,0.00,0.00,'2022-05-30 19:48:24','',''),(1542,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-31 15:22:25','',''),(1543,'21','228',NULL,1,'Reception corrector for bridging 123',0.00,0.00,0.00,45000.00,0.00,'2022-05-31 15:23:45','',''),(1544,'21','228','1',1,'Received from bridging 123',0.00,0.00,45000.00,0.00,0.00,'2022-05-31 15:23:45','',''),(1545,'21','228','1',1,'Sale Id shift 74',0.00,0.00,0.00,6021.08,0.00,'2022-05-31 15:41:10','',''),(1546,'21','228','3',2,'Sale Id shift 74',0.00,0.00,0.00,2517.23,0.00,'2022-05-31 15:41:10','',''),(1547,'21','228','3',2,'Sale Id shift 74',0.00,0.00,0.00,3.68,0.00,'2022-05-31 15:41:10','',''),(1548,'21','228','3',2,'Sale Id shift 74',0.00,0.00,0.00,3021.98,0.00,'2022-05-31 15:41:10','',''),(1549,'21','228','4',3,'Sale Id shift 74',0.00,0.00,0.00,1313.94,0.00,'2022-05-31 15:41:10','',''),(1550,'21','228','1',1,'Sale Id shift 74',0.00,0.00,0.00,4838.45,0.00,'2022-05-31 15:41:10','',''),(1551,'21','228','1',1,'Sale Id shift 74',0.00,0.00,0.00,4118.14,0.00,'2022-05-31 15:41:10','',''),(1552,'21','228','1',1,'Sale Id shift 74',0.00,0.00,0.00,4158.68,0.00,'2022-05-31 15:41:10','',''),(1553,'21','228','1',1,'Sale Id shift 74',0.00,0.00,0.00,5093.77,0.00,'2022-05-31 15:41:10','',''),(1554,'21','228','1',1,'Sale Id shift 74',0.00,0.00,0.00,4373.39,0.00,'2022-05-31 15:41:10','',''),(1555,'21','228','1',1,'Sale Id shift 74',0.00,0.00,0.00,5529.13,0.00,'2022-05-31 15:41:10','',''),(1556,'21','228','1',1,'Sale Id shift 74',0.00,0.00,0.00,6076.81,0.00,'2022-05-31 15:41:10','',''),(1557,'21','228',NULL,1,'Sale Id shift 74',6634559.25,0.00,0.00,0.00,0.00,'2022-05-31 15:41:10','',''),(1558,'21','228',NULL,2,'Sale Id shift 74',4212596.40,0.00,0.00,0.00,0.00,'2022-05-31 15:41:10','',''),(1559,'21','228',NULL,3,'Sale Id shift 74',854061.00,0.00,0.00,0.00,0.00,'2022-05-31 15:41:10','',''),(1560,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7268250.00,44050.00,0.00,0.00,'2022-06-01 20:39:39','',''),(1561,'21','228',NULL,1,'Reception corrector for bridging 124',0.00,0.00,0.00,44050.00,0.00,'2022-06-01 20:41:25','',''),(1562,'21','228','1',1,'Received from bridging 124',0.00,0.00,44050.00,0.00,0.00,'2022-06-01 20:41:25','',''),(1563,'21','228','1',1,'Sale Id shift 75',0.00,0.00,0.00,4060.17,0.00,'2022-06-01 20:47:54','',''),(1564,'21','228','3',2,'Sale Id shift 75',0.00,0.00,0.00,2162.77,0.00,'2022-06-01 20:47:54','',''),(1565,'21','228','3',2,'Sale Id shift 75',0.00,0.00,0.00,2043.54,0.00,'2022-06-01 20:47:54','',''),(1566,'21','228','4',3,'Sale Id shift 75',0.00,0.00,0.00,1190.33,0.00,'2022-06-01 20:47:54','',''),(1567,'21','228','1',1,'Sale Id shift 75',0.00,0.00,0.00,3913.60,0.00,'2022-06-01 20:47:54','',''),(1568,'21','228','1',1,'Sale Id shift 75',0.00,0.00,0.00,3671.57,0.00,'2022-06-01 20:47:54','',''),(1569,'21','228','1',1,'Sale Id shift 75',0.00,0.00,0.00,2952.95,0.00,'2022-06-01 20:47:54','',''),(1570,'21','228','1',1,'Sale Id shift 75',0.00,0.00,0.00,4013.35,0.00,'2022-06-01 20:47:54','',''),(1571,'21','228','1',1,'Sale Id shift 75',0.00,0.00,0.00,3792.06,0.00,'2022-06-01 20:47:54','',''),(1572,'21','228','1',1,'Sale Id shift 75',0.00,0.00,0.00,4431.64,0.00,'2022-06-01 20:47:54','',''),(1573,'21','228','1',1,'Sale Id shift 75',0.00,0.00,0.00,4481.96,0.00,'2022-06-01 20:47:54','',''),(1574,'21','228',NULL,1,'Sale Id shift 75',5167354.50,0.00,0.00,0.00,0.00,'2022-06-01 20:47:54','',''),(1575,'21','228',NULL,2,'Sale Id shift 75',3196795.60,0.00,0.00,0.00,0.00,'2022-06-01 20:47:54','',''),(1576,'21','228',NULL,3,'Sale Id shift 75',773714.50,0.00,0.00,0.00,0.00,'2022-06-01 20:47:54','',''),(1577,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-02 16:17:19','',''),(1578,'21','228',NULL,1,'Reception corrector for bridging 125',0.00,0.00,0.00,40000.00,0.00,'2022-06-02 16:18:57','',''),(1579,'21','228','1',1,'Received from bridging 125',0.00,0.00,40000.00,0.00,0.00,'2022-06-02 16:18:57','',''),(1580,'21','228','1',1,'Sale Id shift 76',0.00,0.00,0.00,10148.83,0.00,'2022-06-02 16:40:38','',''),(1581,'21','228','3',2,'Sale Id shift 76',0.00,0.00,0.00,1010.27,0.00,'2022-06-02 16:40:38','',''),(1582,'21','228','3',2,'Sale Id shift 76',0.00,0.00,0.00,1111.44,0.00,'2022-06-02 16:40:38','',''),(1583,'21','228','3',2,'Sale Id shift 76',0.00,0.00,0.00,1579.71,0.00,'2022-06-02 16:40:38','',''),(1584,'21','228','4',3,'Sale Id shift 76',0.00,0.00,0.00,1071.55,0.00,'2022-06-02 16:40:38','',''),(1585,'21','228','1',1,'Sale Id shift 76',0.00,0.00,0.00,6705.12,0.00,'2022-06-02 16:40:38','',''),(1586,'21','228','1',1,'Sale Id shift 76',0.00,0.00,0.00,7785.27,0.00,'2022-06-02 16:40:38','',''),(1587,'21','228','1',1,'Sale Id shift 76',0.00,0.00,0.00,6690.12,0.00,'2022-06-02 16:40:38','',''),(1588,'21','228','1',1,'Sale Id shift 76',0.00,0.00,0.00,7769.22,0.00,'2022-06-02 16:40:38','',''),(1589,'21','228','1',1,'Sale Id shift 76',0.00,0.00,0.00,6674.18,0.00,'2022-06-02 16:40:38','',''),(1590,'21','228','1',1,'Sale Id shift 76',0.00,0.00,0.00,9478.87,0.00,'2022-06-02 16:40:38','',''),(1591,'21','228','1',1,'Sale Id shift 76',0.00,0.00,0.00,9316.35,0.00,'2022-06-02 16:40:38','',''),(1592,'21','228',NULL,1,'Sale Id shift 76',10653713.40,0.00,0.00,0.00,0.00,'2022-06-02 16:40:38','',''),(1593,'21','228',NULL,2,'Sale Id shift 76',2813079.20,0.00,0.00,0.00,0.00,'2022-06-02 16:40:38','',''),(1594,'21','228',NULL,3,'Sale Id shift 76',696507.50,0.00,0.00,0.00,0.00,'2022-06-02 16:40:38','',''),(1595,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-03 16:01:18','',''),(1596,'21','228',NULL,1,'Reception corrector for bridging 126',0.00,0.00,0.00,45000.00,0.00,'2022-06-03 16:03:11','',''),(1597,'21','228','1',1,'Received from bridging 126',0.00,0.00,45000.00,0.00,0.00,'2022-06-03 16:03:11','',''),(1598,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,22800000.00,30000.00,0.00,0.00,'2022-06-03 16:03:32','',''),(1599,'21','228',NULL,2,'Reception corrector for bridging 127',0.00,0.00,0.00,30000.00,0.00,'2022-06-03 16:05:15','',''),(1600,'21','228','3',2,'Received from bridging 127',0.00,0.00,30000.00,0.00,0.00,'2022-06-03 16:05:15','',''),(1601,'21','228','1',1,'Sale Id shift 77',0.00,0.00,0.00,5330.86,0.00,'2022-06-03 16:16:44','',''),(1602,'21','228','3',2,'Sale Id shift 77',0.00,0.00,0.00,2523.28,0.00,'2022-06-03 16:16:44','',''),(1603,'21','228','3',2,'Sale Id shift 77',0.00,0.00,0.00,349.53,0.00,'2022-06-03 16:16:44','',''),(1604,'21','228','3',2,'Sale Id shift 77',0.00,0.00,0.00,1738.27,0.00,'2022-06-03 16:16:44','',''),(1605,'21','228','4',3,'Sale Id shift 77',0.00,0.00,0.00,1233.67,0.00,'2022-06-03 16:16:44','',''),(1606,'21','228','1',1,'Sale Id shift 77',0.00,0.00,0.00,4472.04,0.00,'2022-06-03 16:16:44','',''),(1607,'21','228','1',1,'Sale Id shift 77',0.00,0.00,0.00,4392.52,0.00,'2022-06-03 16:16:44','',''),(1608,'21','228','1',1,'Sale Id shift 77',0.00,0.00,0.00,4058.10,0.00,'2022-06-03 16:16:44','',''),(1609,'21','228','1',1,'Sale Id shift 77',0.00,0.00,0.00,5154.60,0.00,'2022-06-03 16:16:44','',''),(1610,'21','228','1',1,'Sale Id shift 77',0.00,0.00,0.00,4126.15,0.00,'2022-06-03 16:16:44','',''),(1611,'21','228','1',1,'Sale Id shift 77',0.00,0.00,0.00,4930.30,0.00,'2022-06-03 16:16:44','',''),(1612,'21','228','1',1,'Sale Id shift 77',0.00,0.00,0.00,5774.98,0.00,'2022-06-03 16:16:44','',''),(1613,'21','228',NULL,1,'Sale Id shift 77',6309525.75,0.00,0.00,0.00,0.00,'2022-06-03 16:16:44','',''),(1614,'21','228',NULL,2,'Sale Id shift 77',3504420.80,0.00,0.00,0.00,0.00,'2022-06-03 16:16:44','',''),(1615,'21','228',NULL,3,'Sale Id shift 77',801885.50,0.00,0.00,0.00,0.00,'2022-06-03 16:16:44','',''),(1616,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-04 13:09:24','',''),(1617,'21','228',NULL,1,'Reception corrector for bridging 128',0.00,0.00,0.00,45000.00,0.00,'2022-06-04 13:17:39','',''),(1618,'21','228','1',1,'Received from bridging 128',0.00,0.00,45000.00,0.00,0.00,'2022-06-04 13:17:39','',''),(1619,'21','228','1',1,'Sale Id shift 78',0.00,0.00,0.00,6937.44,0.00,'2022-06-04 13:24:08','',''),(1620,'21','228','3',2,'Sale Id shift 78',0.00,0.00,0.00,2893.70,0.00,'2022-06-04 13:24:08','',''),(1621,'21','228','3',2,'Sale Id shift 78',0.00,0.00,0.00,1485.93,0.00,'2022-06-04 13:24:08','',''),(1622,'21','228','4',3,'Sale Id shift 78',0.00,0.00,0.00,1218.60,0.00,'2022-06-04 13:24:08','',''),(1623,'21','228','1',1,'Sale Id shift 78',0.00,0.00,0.00,4636.49,0.00,'2022-06-04 13:24:08','',''),(1624,'21','228','1',1,'Sale Id shift 78',0.00,0.00,0.00,4462.27,0.00,'2022-06-04 13:24:08','',''),(1625,'21','228','1',1,'Sale Id shift 78',0.00,0.00,0.00,4418.67,0.00,'2022-06-04 13:24:08','',''),(1626,'21','228','1',1,'Sale Id shift 78',0.00,0.00,0.00,5250.49,0.00,'2022-06-04 13:24:08','',''),(1627,'21','228','1',1,'Sale Id shift 78',0.00,0.00,0.00,4745.86,0.00,'2022-06-04 13:24:08','',''),(1628,'21','228','1',1,'Sale Id shift 78',0.00,0.00,0.00,5017.78,0.00,'2022-06-04 13:24:08','',''),(1629,'21','228','1',1,'Sale Id shift 78',0.00,0.00,0.00,5600.08,0.00,'2022-06-04 13:24:08','',''),(1630,'21','228',NULL,1,'Sale Id shift 78',6776398.20,0.00,0.00,0.00,0.00,'2022-06-04 13:24:08','',''),(1631,'21','228',NULL,2,'Sale Id shift 78',3328518.80,0.00,0.00,0.00,0.00,'2022-06-04 13:24:08','',''),(1632,'21','228',NULL,3,'Sale Id shift 78',792090.00,0.00,0.00,0.00,0.00,'2022-06-04 13:24:08','',''),(1633,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-05 20:38:36','',''),(1634,'21','228',NULL,1,'Reception corrector for bridging 129',0.00,0.00,0.00,40000.00,0.00,'2022-06-05 20:41:19','',''),(1635,'21','228','1',1,'Received from bridging 129',0.00,0.00,40000.00,0.00,0.00,'2022-06-05 20:41:19','',''),(1636,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-05 20:43:52','',''),(1637,'21','228','1',1,'Sale Id shift 79',0.00,0.00,0.00,6182.42,0.00,'2022-06-06 17:35:15','',''),(1638,'21','228','3',2,'Sale Id shift 79',0.00,0.00,0.00,2540.19,0.00,'2022-06-06 17:35:15','',''),(1639,'21','228','3',2,'Sale Id shift 79',0.00,0.00,0.00,2734.81,0.00,'2022-06-06 17:35:15','',''),(1640,'21','228','4',3,'Sale Id shift 79',0.00,0.00,0.00,2248.72,0.00,'2022-06-06 17:35:15','',''),(1641,'21','228','1',1,'Sale Id shift 79',0.00,0.00,0.00,5394.59,0.00,'2022-06-06 17:35:15','',''),(1642,'21','228','1',1,'Sale Id shift 79',0.00,0.00,0.00,4752.78,0.00,'2022-06-06 17:35:15','',''),(1643,'21','228','1',1,'Sale Id shift 79',0.00,0.00,0.00,5051.70,0.00,'2022-06-06 17:35:15','',''),(1644,'21','228','1',1,'Sale Id shift 79',0.00,0.00,0.00,5379.95,0.00,'2022-06-06 17:35:15','',''),(1645,'21','228','1',1,'Sale Id shift 79',0.00,0.00,0.00,4952.65,0.00,'2022-06-06 17:35:15','',''),(1646,'21','228','1',1,'Sale Id shift 79',0.00,0.00,0.00,5606.88,0.00,'2022-06-06 17:35:15','',''),(1647,'21','228','1',1,'Sale Id shift 79',0.00,0.00,0.00,6445.08,0.00,'2022-06-06 17:35:15','',''),(1648,'21','228',NULL,2,'Sale Id shift 79',4114500.00,0.00,0.00,0.00,0.00,'2022-06-06 17:35:15','',''),(1649,'21','228',NULL,3,'Sale Id shift 79',1461668.00,0.00,0.00,0.00,0.00,'2022-06-06 17:35:15','',''),(1650,'21','228',NULL,1,'Sale Id shift 79',7221398.25,0.00,0.00,0.00,0.00,'2022-06-06 17:35:15','',''),(1651,'21','228',NULL,1,'Reception corrector for bridging 130',0.00,0.00,0.00,40000.00,0.00,'2022-06-06 17:59:37','',''),(1652,'21','228','1',1,'Received from bridging 130',0.00,0.00,40000.00,0.00,0.00,'2022-06-06 17:59:37','',''),(1653,'21','228','1',1,'Sale Id shift 80',0.00,0.00,0.00,6295.85,0.00,'2022-06-06 18:05:56','',''),(1654,'21','228','3',2,'Sale Id shift 80',0.00,0.00,0.00,2354.89,0.00,'2022-06-06 18:05:56','',''),(1655,'21','228','3',2,'Sale Id shift 80',0.00,0.00,0.00,60.23,0.00,'2022-06-06 18:05:56','',''),(1656,'21','228','4',3,'Sale Id shift 80',0.00,0.00,0.00,956.69,0.00,'2022-06-06 18:05:56','',''),(1657,'21','228','1',1,'Sale Id shift 80',0.00,0.00,0.00,5054.24,0.00,'2022-06-06 18:05:56','',''),(1658,'21','228','1',1,'Sale Id shift 80',0.00,0.00,0.00,4746.62,0.00,'2022-06-06 18:05:56','',''),(1659,'21','228','1',1,'Sale Id shift 80',0.00,0.00,0.00,4736.35,0.00,'2022-06-06 18:05:56','',''),(1660,'21','228','1',1,'Sale Id shift 80',0.00,0.00,0.00,5485.30,0.00,'2022-06-06 18:05:56','',''),(1661,'21','228','1',1,'Sale Id shift 80',0.00,0.00,0.00,5275.44,0.00,'2022-06-06 18:05:56','',''),(1662,'21','228','1',1,'Sale Id shift 80',0.00,0.00,0.00,5994.68,0.00,'2022-06-06 18:05:56','',''),(1663,'21','228','1',1,'Sale Id shift 80',0.00,0.00,0.00,5835.92,0.00,'2022-06-06 18:05:56','',''),(1664,'21','228',NULL,1,'Sale Id shift 80',7165026.00,0.00,0.00,0.00,0.00,'2022-06-06 18:05:56','',''),(1665,'21','228',NULL,2,'Sale Id shift 80',1883793.60,0.00,0.00,0.00,0.00,'2022-06-06 18:05:56','',''),(1666,'21','228',NULL,3,'Sale Id shift 80',621848.50,0.00,0.00,0.00,0.00,'2022-06-06 18:05:56','',''),(1667,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,19467500.00,29950.00,0.00,0.00,'2022-06-07 18:00:47','',''),(1668,'21','228',NULL,3,'Reception corrector for bridging 131',0.00,0.00,0.00,29950.00,0.00,'2022-06-07 18:02:23','',''),(1669,'21','228','4',3,'Received from bridging 131',0.00,0.00,29950.00,0.00,0.00,'2022-06-07 18:02:23','',''),(1670,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-07 18:02:37','',''),(1671,'21','228',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,16500.00,0.00,'2022-06-07 18:06:18','',''),(1672,'21','228','2',1,'Received from bridging 133',0.00,0.00,16500.00,0.00,0.00,'2022-06-07 18:06:18','',''),(1673,'21','228',NULL,1,'Reception corrector for bridging 132',0.00,0.00,0.00,33500.00,0.00,'2022-06-07 18:06:18','',''),(1674,'21','228','1',1,'Received from bridging 132',0.00,0.00,33500.00,0.00,0.00,'2022-06-07 18:06:18','',''),(1675,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-07 18:06:28','',''),(1676,'21','228','1',1,'Sale Id shift 81',0.00,0.00,0.00,2923.01,0.00,'2022-06-07 18:12:57','',''),(1677,'21','228','3',2,'Sale Id shift 81',0.00,0.00,0.00,2562.09,0.00,'2022-06-07 18:12:57','',''),(1678,'21','228','3',2,'Sale Id shift 81',0.00,0.00,0.00,4129.25,0.00,'2022-06-07 18:12:57','',''),(1679,'21','228','4',3,'Sale Id shift 81',0.00,0.00,0.00,1303.77,0.00,'2022-06-07 18:12:57','',''),(1680,'21','228','1',1,'Sale Id shift 81',0.00,0.00,0.00,2679.47,0.00,'2022-06-07 18:12:57','',''),(1681,'21','228','1',1,'Sale Id shift 81',0.00,0.00,0.00,2604.28,0.00,'2022-06-07 18:12:57','',''),(1682,'21','228','1',1,'Sale Id shift 81',0.00,0.00,0.00,2451.64,0.00,'2022-06-07 18:12:57','',''),(1683,'21','228','1',1,'Sale Id shift 81',0.00,0.00,0.00,2851.85,0.00,'2022-06-07 18:12:57','',''),(1684,'21','228','1',1,'Sale Id shift 81',0.00,0.00,0.00,2421.86,0.00,'2022-06-07 18:12:57','',''),(1685,'21','228','1',1,'Sale Id shift 81',0.00,0.00,0.00,3455.05,0.00,'2022-06-07 18:12:57','',''),(1686,'21','228','1',1,'Sale Id shift 81',0.00,0.00,0.00,3204.98,0.00,'2022-06-07 18:12:57','',''),(1687,'21','228',NULL,2,'Sale Id shift 81',5219245.20,0.00,0.00,0.00,0.00,'2022-06-07 18:12:57','',''),(1688,'21','228',NULL,3,'Sale Id shift 81',847450.50,0.00,0.00,0.00,0.00,'2022-06-07 18:12:57','',''),(1689,'21','228',NULL,1,'Sale Id shift 81',3727703.10,0.00,0.00,0.00,0.00,'2022-06-07 18:12:57','',''),(1690,'21','228',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,45000.00,0.00,'2022-06-07 18:13:25','',''),(1691,'21','228','1',1,'Received from bridging 134',0.00,0.00,45000.00,0.00,0.00,'2022-06-07 18:13:25','',''),(1692,'21','228','2',1,'Sale Id shift 82',0.00,0.00,0.00,2632.48,0.00,'2022-06-08 18:31:15','',''),(1693,'21','228','2',1,'Sale Id shift 82',0.00,0.00,0.00,1477.22,0.00,'2022-06-08 18:31:15','',''),(1694,'21','228','2',1,'Sale Id shift 82',0.00,0.00,0.00,1350.64,0.00,'2022-06-08 18:31:15','',''),(1695,'21','228','2',1,'Sale Id shift 82',0.00,0.00,0.00,1189.00,0.00,'2022-06-08 18:31:15','',''),(1696,'21','228','2',1,'Sale Id shift 82',0.00,0.00,0.00,4396.50,0.00,'2022-06-08 18:31:15','',''),(1697,'21','228','2',1,'Sale Id shift 82',0.00,0.00,0.00,35.56,0.00,'2022-06-08 18:31:15','',''),(1698,'21','228','2',1,'Sale Id shift 82',0.00,0.00,0.00,4246.76,0.00,'2022-06-08 18:31:15','',''),(1699,'21','228','1',1,'Sale Id shift 82',0.00,0.00,0.00,10508.70,0.00,'2022-06-08 18:31:15','',''),(1700,'21','228','2',1,'Sale Id shift 82',0.00,0.00,0.00,1223.95,0.00,'2022-06-08 18:31:15','',''),(1701,'21','228','3',2,'Sale Id shift 82',0.00,0.00,0.00,2645.46,0.00,'2022-06-08 18:31:15','',''),(1702,'21','228','3',2,'Sale Id shift 82',0.00,0.00,0.00,3082.51,0.00,'2022-06-08 18:31:15','',''),(1703,'21','228','4',3,'Sale Id shift 82',0.00,0.00,0.00,2932.75,0.00,'2022-06-08 18:31:15','',''),(1704,'21','228','1',1,'Sale Id shift 82',0.00,0.00,0.00,8234.25,0.00,'2022-06-08 18:31:15','',''),(1705,'21','228','1',1,'Sale Id shift 82',0.00,0.00,0.00,7192.33,0.00,'2022-06-08 18:31:15','',''),(1706,'21','228','1',1,'Sale Id shift 82',0.00,0.00,0.00,6356.42,0.00,'2022-06-08 18:31:15','',''),(1707,'21','228','1',1,'Sale Id shift 82',0.00,0.00,0.00,7949.43,0.00,'2022-06-08 18:31:15','',''),(1708,'21','228','1',1,'Sale Id shift 82',0.00,0.00,0.00,8496.12,0.00,'2022-06-08 18:31:15','',''),(1709,'21','228','1',1,'Sale Id shift 82',0.00,0.00,0.00,8601.20,0.00,'2022-06-08 18:31:15','',''),(1710,'21','228','1',1,'Sale Id shift 82',0.00,0.00,0.00,9363.21,0.00,'2022-06-08 18:31:15','',''),(1711,'21','228',NULL,1,'Sale Id shift 82',13736872.05,0.00,0.00,0.00,0.00,'2022-06-08 18:31:15','',''),(1712,'21','228',NULL,2,'Sale Id shift 82',4467816.60,0.00,0.00,0.00,0.00,'2022-06-08 18:31:15','',''),(1713,'21','228',NULL,3,'Sale Id shift 82',1906287.50,0.00,0.00,0.00,0.00,'2022-06-08 18:31:15','',''),(1714,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-09 18:41:18','',''),(1715,'21','228',NULL,1,'Reception corrector for bridging 135',0.00,0.00,0.00,45000.00,0.00,'2022-06-09 21:03:00','',''),(1716,'21','228','1',1,'Received from bridging 135',0.00,0.00,45000.00,0.00,0.00,'2022-06-09 21:03:00','',''),(1717,'21','228','1',1,'Sale Id shift 83',0.00,0.00,0.00,3901.68,0.00,'2022-06-09 21:10:22','',''),(1718,'21','228','3',2,'Sale Id shift 83',0.00,0.00,0.00,2384.34,0.00,'2022-06-09 21:10:22','',''),(1719,'21','228','3',2,'Sale Id shift 83',0.00,0.00,0.00,2696.90,0.00,'2022-06-09 21:10:22','',''),(1720,'21','228','4',3,'Sale Id shift 83',0.00,0.00,0.00,6042.63,0.00,'2022-06-09 21:10:22','',''),(1721,'21','228','1',1,'Sale Id shift 83',0.00,0.00,0.00,2813.61,0.00,'2022-06-09 21:10:22','',''),(1722,'21','228','1',1,'Sale Id shift 83',0.00,0.00,0.00,2779.61,0.00,'2022-06-09 21:10:22','',''),(1723,'21','228','1',1,'Sale Id shift 83',0.00,0.00,0.00,2667.16,0.00,'2022-06-09 21:10:22','',''),(1724,'21','228','1',1,'Sale Id shift 83',0.00,0.00,0.00,2665.58,0.00,'2022-06-09 21:10:22','',''),(1725,'21','228','1',1,'Sale Id shift 83',0.00,0.00,0.00,3111.88,0.00,'2022-06-09 21:10:22','',''),(1726,'21','228','1',1,'Sale Id shift 83',0.00,0.00,0.00,3576.55,0.00,'2022-06-09 21:10:22','',''),(1727,'21','228','1',1,'Sale Id shift 83',0.00,0.00,0.00,3814.13,0.00,'2022-06-09 21:10:22','',''),(1728,'21','228',NULL,2,'Sale Id shift 83',3963367.20,0.00,0.00,0.00,0.00,'2022-06-09 21:10:22','',''),(1729,'21','228',NULL,3,'Sale Id shift 83',3927709.50,0.00,0.00,0.00,0.00,'2022-06-09 21:10:22','',''),(1730,'21','228',NULL,1,'Sale Id shift 83',4179483.00,0.00,0.00,0.00,0.00,'2022-06-09 21:10:22','',''),(1731,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-09 21:14:28','',''),(1732,'21','228',NULL,1,'Reception corrector for bridging 136',0.00,0.00,0.00,45000.00,0.00,'2022-06-09 21:15:41','',''),(1733,'21','228','1',1,'Received from bridging 136',0.00,0.00,45000.00,0.00,0.00,'2022-06-09 21:15:41','',''),(1734,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,11400000.00,15000.00,0.00,0.00,'2022-06-09 21:23:01','',''),(1735,'21','228',NULL,2,'Reception corrector for bridging 137',0.00,0.00,0.00,15000.00,0.00,'2022-06-09 21:23:53','',''),(1736,'21','228','3',2,'Received from bridging 137',0.00,0.00,15000.00,0.00,0.00,'2022-06-09 21:23:53','',''),(1737,'21','228','1',1,'Sale Id shift 84',0.00,0.00,0.00,6703.49,0.00,'2022-06-10 15:49:43','',''),(1738,'21','228','3',2,'Sale Id shift 84',0.00,0.00,0.00,2127.70,0.00,'2022-06-10 15:49:43','',''),(1739,'21','228','3',2,'Sale Id shift 84',0.00,0.00,0.00,1706.24,0.00,'2022-06-10 15:49:43','',''),(1740,'21','228','4',3,'Sale Id shift 84',0.00,0.00,0.00,754.97,0.00,'2022-06-10 15:49:43','',''),(1741,'21','228','1',1,'Sale Id shift 84',0.00,0.00,0.00,4631.73,0.00,'2022-06-10 15:49:43','',''),(1742,'21','228','1',1,'Sale Id shift 84',0.00,0.00,0.00,5468.20,0.00,'2022-06-10 15:49:43','',''),(1743,'21','228','1',1,'Sale Id shift 84',0.00,0.00,0.00,4838.67,0.00,'2022-06-10 15:49:43','',''),(1744,'21','228','1',1,'Sale Id shift 84',0.00,0.00,0.00,5213.27,0.00,'2022-06-10 15:49:43','',''),(1745,'21','228','1',1,'Sale Id shift 84',0.00,0.00,0.00,5218.59,0.00,'2022-06-10 15:49:43','',''),(1746,'21','228','1',1,'Sale Id shift 84',0.00,0.00,0.00,5949.81,0.00,'2022-06-10 15:49:43','',''),(1747,'21','228','1',1,'Sale Id shift 84',0.00,0.00,0.00,7563.36,0.00,'2022-06-10 15:49:43','',''),(1748,'21','228',NULL,2,'Sale Id shift 84',3067152.00,0.00,0.00,0.00,0.00,'2022-06-10 15:49:43','',''),(1749,'21','228',NULL,3,'Sale Id shift 84',528479.00,0.00,0.00,0.00,0.00,'2022-06-10 15:49:43','',''),(1750,'21','228',NULL,1,'Sale Id shift 84',7521874.80,0.00,0.00,0.00,0.00,'2022-06-10 15:49:43','',''),(1751,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-11 15:38:19','',''),(1752,'21','228',NULL,1,'Reception corrector for bridging 138',0.00,0.00,0.00,45000.00,0.00,'2022-06-11 15:39:36','',''),(1753,'21','228','1',1,'Received from bridging 138',0.00,0.00,45000.00,0.00,0.00,'2022-06-11 15:39:36','',''),(1754,'21','228','1',1,'Sale Id shift 85',0.00,0.00,0.00,7080.89,0.00,'2022-06-11 15:46:30','',''),(1755,'21','228','3',2,'Sale Id shift 85',0.00,0.00,0.00,2602.99,0.00,'2022-06-11 15:46:30','',''),(1756,'21','228','3',2,'Sale Id shift 85',0.00,0.00,0.00,319.27,0.00,'2022-06-11 15:46:30','',''),(1757,'21','228','3',2,'Sale Id shift 85',0.00,0.00,0.00,2984.12,0.00,'2022-06-11 15:46:30','',''),(1758,'21','228','4',3,'Sale Id shift 85',0.00,0.00,0.00,842.67,0.00,'2022-06-11 15:46:30','',''),(1759,'21','228','1',1,'Sale Id shift 85',0.00,0.00,0.00,4904.99,0.00,'2022-06-11 15:46:30','',''),(1760,'21','228','1',1,'Sale Id shift 85',0.00,0.00,0.00,4701.42,0.00,'2022-06-11 15:46:30','',''),(1761,'21','228','1',1,'Sale Id shift 85',0.00,0.00,0.00,4844.79,0.00,'2022-06-11 15:46:30','',''),(1762,'21','228','1',1,'Sale Id shift 85',0.00,0.00,0.00,5276.57,0.00,'2022-06-11 15:46:30','',''),(1763,'21','228','1',1,'Sale Id shift 85',0.00,0.00,0.00,5168.57,0.00,'2022-06-11 15:46:30','',''),(1764,'21','228','1',1,'Sale Id shift 85',0.00,0.00,0.00,5551.53,0.00,'2022-06-11 15:46:30','',''),(1765,'21','228','1',1,'Sale Id shift 85',0.00,0.00,0.00,7888.39,0.00,'2022-06-11 15:46:30','',''),(1766,'21','228',NULL,1,'Sale Id shift 85',7493829.75,0.00,0.00,0.00,0.00,'2022-06-11 15:46:30','',''),(1767,'21','228',NULL,2,'Sale Id shift 85',4725104.00,0.00,0.00,0.00,0.00,'2022-06-11 15:46:30','',''),(1768,'21','228',NULL,3,'Sale Id shift 85',589869.00,0.00,0.00,0.00,0.00,'2022-06-11 15:46:30','',''),(1769,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-12 18:58:28','',''),(1770,'21','228',NULL,1,'Reception corrector for bridging 139',0.00,0.00,0.00,45000.00,0.00,'2022-06-12 19:01:16','',''),(1771,'21','228','1',1,'Received from bridging 139',0.00,0.00,45000.00,0.00,0.00,'2022-06-12 19:01:16','',''),(1772,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,28000000.00,40000.00,0.00,0.00,'2022-06-12 19:01:28','',''),(1773,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-12 19:04:00','',''),(1774,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,24682000.00,30100.00,0.00,0.00,'2022-06-12 19:39:26','',''),(1775,'21','228',NULL,2,'Returned purchase #113 to AYM SHAFA NIGERIA LTD',24682000.00,0.00,0.00,30100.00,0.00,'2022-06-12 19:41:21','',''),(1776,'21','228',NULL,3,'Returned purchase #111 to AYM SHAFA NIGERIA LTD',28000000.00,0.00,0.00,40000.00,0.00,'2022-06-12 19:41:49','',''),(1777,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,24846000.00,30300.00,0.00,0.00,'2022-06-12 19:42:08','',''),(1778,'21','228',NULL,2,'Reception corrector for bridging 141',0.00,0.00,0.00,30300.00,0.00,'2022-06-12 19:43:58','',''),(1779,'21','228','3',2,'Received from bridging 141',0.00,0.00,30300.00,0.00,0.00,'2022-06-12 19:43:58','',''),(1780,'21','228','1',1,'Sale Id shift 86',0.00,0.00,0.00,8820.29,0.00,'2022-06-12 19:48:28','',''),(1781,'21','228','3',2,'Sale Id shift 86',0.00,0.00,0.00,4263.96,0.00,'2022-06-12 19:48:28','',''),(1782,'21','228','3',2,'Sale Id shift 86',0.00,0.00,0.00,814.64,0.00,'2022-06-12 19:48:28','',''),(1783,'21','228','3',2,'Sale Id shift 86',0.00,0.00,0.00,2972.83,0.00,'2022-06-12 19:48:28','',''),(1784,'21','228','4',3,'Sale Id shift 86',0.00,0.00,0.00,1961.00,0.00,'2022-06-12 19:48:28','',''),(1785,'21','228','1',1,'Sale Id shift 86',0.00,0.00,0.00,6113.94,0.00,'2022-06-12 19:48:28','',''),(1786,'21','228','1',1,'Sale Id shift 86',0.00,0.00,0.00,5594.52,0.00,'2022-06-12 19:48:28','',''),(1787,'21','228','1',1,'Sale Id shift 86',0.00,0.00,0.00,5487.23,0.00,'2022-06-12 19:48:28','',''),(1788,'21','228','1',1,'Sale Id shift 86',0.00,0.00,0.00,6274.03,0.00,'2022-06-12 19:48:28','',''),(1789,'21','228','1',1,'Sale Id shift 86',0.00,0.00,0.00,7239.54,0.00,'2022-06-12 19:48:28','',''),(1790,'21','228','1',1,'Sale Id shift 86',0.00,0.00,0.00,6983.42,0.00,'2022-06-12 19:48:28','',''),(1791,'21','228','1',1,'Sale Id shift 86',0.00,0.00,0.00,10035.48,0.00,'2022-06-12 19:48:28','',''),(1792,'21','228',NULL,2,'Sale Id shift 86',6602172.60,0.00,0.00,0.00,0.00,'2022-06-12 19:48:28','',''),(1793,'21','228',NULL,3,'Sale Id shift 86',1372700.00,0.00,0.00,0.00,0.00,'2022-06-12 19:48:28','',''),(1794,'21','228',NULL,1,'Sale Id shift 86',9330494.25,0.00,0.00,0.00,0.00,'2022-06-12 19:48:28','',''),(1795,'21','228',NULL,1,'Reception corrector for bridging 140',0.00,0.00,0.00,40000.00,0.00,'2022-06-12 20:05:10','',''),(1796,'21','228','1',1,'Received from bridging 140',0.00,0.00,40000.00,0.00,0.00,'2022-06-12 20:05:10','',''),(1797,'21','228','1',1,'Sale Id shift 87',0.00,0.00,0.00,5667.74,0.00,'2022-06-13 15:22:18','',''),(1798,'21','228','3',2,'Sale Id shift 87',0.00,0.00,0.00,428.05,0.00,'2022-06-13 15:22:18','',''),(1799,'21','228','3',2,'Sale Id shift 87',0.00,0.00,0.00,1143.75,0.00,'2022-06-13 15:22:18','',''),(1800,'21','228','4',3,'Sale Id shift 87',0.00,0.00,0.00,1336.51,0.00,'2022-06-13 15:22:18','',''),(1801,'21','228','1',1,'Sale Id shift 87',0.00,0.00,0.00,3515.97,0.00,'2022-06-13 15:22:18','',''),(1802,'21','228','1',1,'Sale Id shift 87',0.00,0.00,0.00,4045.77,0.00,'2022-06-13 15:22:18','',''),(1803,'21','228','1',1,'Sale Id shift 87',0.00,0.00,0.00,3421.63,0.00,'2022-06-13 15:22:18','',''),(1804,'21','228','1',1,'Sale Id shift 87',0.00,0.00,0.00,3437.30,0.00,'2022-06-13 15:22:18','',''),(1805,'21','228','1',1,'Sale Id shift 87',0.00,0.00,0.00,4123.70,0.00,'2022-06-13 15:22:18','',''),(1806,'21','228','1',1,'Sale Id shift 87',0.00,0.00,0.00,3781.61,0.00,'2022-06-13 15:22:18','',''),(1807,'21','228','1',1,'Sale Id shift 87',0.00,0.00,0.00,6653.59,0.00,'2022-06-13 15:22:18','',''),(1808,'21','228',NULL,1,'Sale Id shift 87',5716806.15,0.00,0.00,0.00,0.00,'2022-06-13 15:22:18','',''),(1809,'21','228',NULL,2,'Sale Id shift 87',1288876.00,0.00,0.00,0.00,0.00,'2022-06-13 15:22:18','',''),(1810,'21','228',NULL,3,'Sale Id shift 87',935557.00,0.00,0.00,0.00,0.00,'2022-06-13 15:22:18','',''),(1811,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-14 21:00:39','',''),(1812,'21','228',NULL,1,'Reception corrector for bridging 142',0.00,0.00,0.00,45000.00,0.00,'2022-06-14 21:02:19','',''),(1813,'21','228','1',1,'Received from bridging 142',0.00,0.00,45000.00,0.00,0.00,'2022-06-14 21:02:19','',''),(1814,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-14 21:02:38','',''),(1815,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,36900000.00,45000.00,0.00,0.00,'2022-06-14 21:05:28','',''),(1816,'21','228',NULL,2,'Reception corrector for bridging 145',0.00,0.00,0.00,45000.00,0.00,'2022-06-14 21:06:18','',''),(1817,'21','228','3',2,'Received from bridging 145',0.00,0.00,45000.00,0.00,0.00,'2022-06-14 21:06:18','',''),(1818,'21','228','1',1,'Sale Id shift 88',0.00,0.00,0.00,6548.93,0.00,'2022-06-14 21:16:58','',''),(1819,'21','228','3',2,'Sale Id shift 88',0.00,0.00,0.00,474.39,0.00,'2022-06-14 21:16:58','',''),(1820,'21','228','3',2,'Sale Id shift 88',0.00,0.00,0.00,1306.53,0.00,'2022-06-14 21:16:58','',''),(1821,'21','228','3',2,'Sale Id shift 88',0.00,0.00,0.00,2074.07,0.00,'2022-06-14 21:16:58','',''),(1822,'21','228','4',3,'Sale Id shift 88',0.00,0.00,0.00,1978.31,0.00,'2022-06-14 21:16:58','',''),(1823,'21','228','1',1,'Sale Id shift 88',0.00,0.00,0.00,4528.09,0.00,'2022-06-14 21:16:58','',''),(1824,'21','228','1',1,'Sale Id shift 88',0.00,0.00,0.00,3930.04,0.00,'2022-06-14 21:16:58','',''),(1825,'21','228','1',1,'Sale Id shift 88',0.00,0.00,0.00,3241.81,0.00,'2022-06-14 21:16:58','',''),(1826,'21','228','1',1,'Sale Id shift 88',0.00,0.00,0.00,4380.85,0.00,'2022-06-14 21:16:58','',''),(1827,'21','228','1',1,'Sale Id shift 88',0.00,0.00,0.00,4130.46,0.00,'2022-06-14 21:16:58','',''),(1828,'21','228','1',1,'Sale Id shift 88',0.00,0.00,0.00,5406.82,0.00,'2022-06-14 21:16:58','',''),(1829,'21','228','1',1,'Sale Id shift 88',0.00,0.00,0.00,7495.70,0.00,'2022-06-14 21:16:58','',''),(1830,'21','228',NULL,2,'Sale Id shift 88',3161091.80,0.00,0.00,0.00,0.00,'2022-06-14 21:16:58','',''),(1831,'21','228',NULL,3,'Sale Id shift 88',1483732.50,0.00,0.00,0.00,0.00,'2022-06-14 21:16:58','',''),(1832,'21','228',NULL,1,'Sale Id shift 88',6544345.50,0.00,0.00,0.00,0.00,'2022-06-14 21:16:58','',''),(1833,'21','228',NULL,1,'Reception corrector for bridging 144',0.00,0.00,0.00,45000.00,0.00,'2022-06-14 21:26:24','',''),(1834,'21','228','1',1,'Received from bridging 144',0.00,0.00,45000.00,0.00,0.00,'2022-06-14 21:26:24','',''),(1835,'21','228','1',1,'Sale Id shift 89',0.00,0.00,0.00,6773.68,0.00,'2022-06-15 21:51:38','',''),(1836,'21','228','3',2,'Sale Id shift 89',0.00,0.00,0.00,3202.79,0.00,'2022-06-15 21:51:38','',''),(1837,'21','228','3',2,'Sale Id shift 89',0.00,0.00,0.00,589.74,0.00,'2022-06-15 21:51:38','',''),(1838,'21','228','3',2,'Sale Id shift 89',0.00,0.00,0.00,3077.48,0.00,'2022-06-15 21:51:38','',''),(1839,'21','228','3',2,'Sale Id shift 89',0.00,0.00,0.00,5.00,0.00,'2022-06-15 21:51:38','',''),(1840,'21','228','4',3,'Sale Id shift 89',0.00,0.00,0.00,1127.79,0.00,'2022-06-15 21:51:38','',''),(1841,'21','228','1',1,'Sale Id shift 89',0.00,0.00,0.00,4036.83,0.00,'2022-06-15 21:51:38','',''),(1842,'21','228','1',1,'Sale Id shift 89',0.00,0.00,0.00,4994.83,0.00,'2022-06-15 21:51:38','',''),(1843,'21','228','1',1,'Sale Id shift 89',0.00,0.00,0.00,4094.86,0.00,'2022-06-15 21:51:38','',''),(1844,'21','228','1',1,'Sale Id shift 89',0.00,0.00,0.00,5039.96,0.00,'2022-06-15 21:51:38','',''),(1845,'21','228','1',1,'Sale Id shift 89',0.00,0.00,0.00,5070.58,0.00,'2022-06-15 21:51:38','',''),(1846,'21','228','1',1,'Sale Id shift 89',0.00,0.00,0.00,5262.31,0.00,'2022-06-15 21:51:38','',''),(1847,'21','228','1',1,'Sale Id shift 89',0.00,0.00,0.00,8014.28,0.00,'2022-06-15 21:51:38','',''),(1848,'21','228',NULL,2,'Sale Id shift 89',5637508.20,0.00,0.00,0.00,0.00,'2022-06-15 21:51:38','',''),(1849,'21','228',NULL,3,'Sale Id shift 89',845842.50,0.00,0.00,0.00,0.00,'2022-06-15 21:51:38','',''),(1850,'21','228',NULL,1,'Sale Id shift 89',7142409.45,0.00,0.00,0.00,0.00,'2022-06-15 21:51:38','',''),(1851,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-16 21:51:45','',''),(1852,'21','228',NULL,1,'Reception corrector for bridging 146',0.00,0.00,0.00,45000.00,0.00,'2022-06-16 21:55:36','',''),(1853,'21','228','1',1,'Received from bridging 146',0.00,0.00,45000.00,0.00,0.00,'2022-06-16 21:55:36','',''),(1854,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,13530000.00,16500.00,0.00,0.00,'2022-06-16 21:55:53','',''),(1855,'21','228',NULL,2,'Reception corrector for bridging 147',0.00,0.00,0.00,16500.00,0.00,'2022-06-16 21:57:27','',''),(1856,'21','228','3',2,'Received from bridging 147',0.00,0.00,16500.00,0.00,0.00,'2022-06-16 21:57:27','',''),(1857,'21','228','1',1,'Sale Id shift 90',0.00,0.00,0.00,6505.22,0.00,'2022-06-16 22:03:46','',''),(1858,'21','228','3',2,'Sale Id shift 90',0.00,0.00,0.00,2406.09,0.00,'2022-06-16 22:03:46','',''),(1859,'21','228','3',2,'Sale Id shift 90',0.00,0.00,0.00,3874.75,0.00,'2022-06-16 22:03:46','',''),(1860,'21','228','4',3,'Sale Id shift 90',0.00,0.00,0.00,1417.11,0.00,'2022-06-16 22:03:46','',''),(1861,'21','228','1',1,'Sale Id shift 90',0.00,0.00,0.00,4446.95,0.00,'2022-06-16 22:03:46','',''),(1862,'21','228','1',1,'Sale Id shift 90',0.00,0.00,0.00,3158.33,0.00,'2022-06-16 22:03:46','',''),(1863,'21','228','1',1,'Sale Id shift 90',0.00,0.00,0.00,4317.75,0.00,'2022-06-16 22:03:46','',''),(1864,'21','228','1',1,'Sale Id shift 90',0.00,0.00,0.00,4233.93,0.00,'2022-06-16 22:03:46','',''),(1865,'21','228','1',1,'Sale Id shift 90',0.00,0.00,0.00,5165.25,0.00,'2022-06-16 22:03:46','',''),(1866,'21','228','1',1,'Sale Id shift 90',0.00,0.00,0.00,5335.53,0.00,'2022-06-16 22:03:46','',''),(1867,'21','228','1',1,'Sale Id shift 90',0.00,0.00,0.00,7412.67,0.00,'2022-06-16 22:03:46','',''),(1868,'21','228',NULL,2,'Sale Id shift 90',5150288.80,0.00,0.00,0.00,0.00,'2022-06-16 22:03:46','',''),(1869,'21','228',NULL,3,'Sale Id shift 90',1062832.50,0.00,0.00,0.00,0.00,'2022-06-16 22:03:46','',''),(1870,'21','228',NULL,1,'Sale Id shift 90',6694978.95,0.00,0.00,0.00,0.00,'2022-06-16 22:03:46','',''),(1871,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-18 20:19:42','',''),(1872,'21','228',NULL,1,'Returned purchase #119 to AYM SHAFA NIGERIA LTD',7425000.00,0.00,0.00,45000.00,0.00,'2022-06-18 20:48:58','',''),(1873,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6567000.00,39800.00,0.00,0.00,'2022-06-18 20:57:57','',''),(1874,'21','228',NULL,1,'Reception corrector for bridging 149',0.00,0.00,0.00,38300.00,0.00,'2022-06-18 21:00:08','',''),(1875,'21','228','2',1,'Received from bridging 149',0.00,0.00,38300.00,0.00,0.00,'2022-06-18 21:00:08','',''),(1876,'21','228',NULL,1,'Reception corrector for bridging 148',0.00,0.00,0.00,1500.00,0.00,'2022-06-18 21:00:08','',''),(1877,'21','228','1',1,'Received from bridging 148',0.00,0.00,1500.00,0.00,0.00,'2022-06-18 21:00:08','',''),(1878,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-18 21:00:19','',''),(1879,'21','228',NULL,1,'Reception corrector for bridging 150',0.00,0.00,0.00,40000.00,0.00,'2022-06-18 21:01:43','',''),(1880,'21','228','2',1,'Received from bridging 150',0.00,0.00,40000.00,0.00,0.00,'2022-06-18 21:01:43','',''),(1881,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-18 21:03:05','',''),(1882,'21','228','1',1,'Sale Id shift 91',0.00,0.00,0.00,5557.46,0.00,'2022-06-18 21:10:39','',''),(1883,'21','228','3',2,'Sale Id shift 91',0.00,0.00,0.00,3435.69,0.00,'2022-06-18 21:10:39','',''),(1884,'21','228','3',2,'Sale Id shift 91',0.00,0.00,0.00,2602.58,0.00,'2022-06-18 21:10:39','',''),(1885,'21','228','4',3,'Sale Id shift 91',0.00,0.00,0.00,1947.55,0.00,'2022-06-18 21:10:39','',''),(1886,'21','228','1',1,'Sale Id shift 91',0.00,0.00,0.00,3473.30,0.00,'2022-06-18 21:10:39','',''),(1887,'21','228','1',1,'Sale Id shift 91',0.00,0.00,0.00,2662.38,0.00,'2022-06-18 21:10:39','',''),(1888,'21','228','1',1,'Sale Id shift 91',0.00,0.00,0.00,3531.35,0.00,'2022-06-18 21:10:39','',''),(1889,'21','228','1',1,'Sale Id shift 91',0.00,0.00,0.00,4176.43,0.00,'2022-06-18 21:10:39','',''),(1890,'21','228','1',1,'Sale Id shift 91',0.00,0.00,0.00,4393.19,0.00,'2022-06-18 21:10:39','',''),(1891,'21','228','1',1,'Sale Id shift 91',0.00,0.00,0.00,5035.76,0.00,'2022-06-18 21:10:39','',''),(1892,'21','228','1',1,'Sale Id shift 91',0.00,0.00,0.00,6754.73,0.00,'2022-06-18 21:10:39','',''),(1893,'21','228',NULL,2,'Sale Id shift 91',4951381.40,0.00,0.00,0.00,0.00,'2022-06-18 21:10:39','',''),(1894,'21','228',NULL,3,'Sale Id shift 91',1460662.50,0.00,0.00,0.00,0.00,'2022-06-18 21:10:39','',''),(1895,'21','228',NULL,1,'Sale Id shift 91',5871459.00,0.00,0.00,0.00,0.00,'2022-06-18 21:10:39','',''),(1896,'21','228','2',1,'Sale Id shift 93',0.00,0.00,0.00,6543.24,0.00,'2022-06-18 21:53:21','',''),(1897,'21','228','2',1,'Sale Id shift 93',0.00,0.00,0.00,8376.86,0.00,'2022-06-18 21:53:21','',''),(1898,'21','228','2',1,'Sale Id shift 93',0.00,0.00,0.00,8151.32,0.00,'2022-06-18 21:53:21','',''),(1899,'21','228','2',1,'Sale Id shift 93',0.00,0.00,0.00,8663.16,0.00,'2022-06-18 21:53:21','',''),(1900,'21','228','2',1,'Sale Id shift 93',0.00,0.00,0.00,5399.60,0.00,'2022-06-18 21:53:21','',''),(1901,'21','228','2',1,'Sale Id shift 93',0.00,0.00,0.00,4684.03,0.00,'2022-06-18 21:53:21','',''),(1902,'21','228','2',1,'Sale Id shift 93',0.00,0.00,0.00,7380.81,0.00,'2022-06-18 21:53:21','',''),(1903,'21','228','2',1,'Sale Id shift 93',0.00,0.00,0.00,8205.84,0.00,'2022-06-18 21:53:21','',''),(1904,'21','228','3',2,'Sale Id shift 93',0.00,0.00,0.00,2558.00,0.00,'2022-06-18 21:53:21','',''),(1905,'21','228','3',2,'Sale Id shift 93',0.00,0.00,0.00,2323.00,0.00,'2022-06-18 21:53:21','',''),(1906,'21','228','4',3,'Sale Id shift 93',0.00,0.00,0.00,1374.51,0.00,'2022-06-18 21:53:21','',''),(1907,'21','228',NULL,2,'Sale Id shift 93',4051230.00,0.00,0.00,0.00,0.00,'2022-06-18 21:53:21','',''),(1908,'21','228',NULL,3,'Sale Id shift 93',1030882.50,0.00,0.00,0.00,0.00,'2022-06-18 21:53:21','',''),(1909,'21','228',NULL,1,'Sale Id shift 93',9471801.90,0.00,0.00,0.00,0.00,'2022-06-18 21:53:21','',''),(1910,'21','228',NULL,1,'Reception corrector for bridging 151',0.00,0.00,0.00,40000.00,0.00,'2022-06-18 21:56:27','',''),(1911,'21','228','2',1,'Received from bridging 151',0.00,0.00,40000.00,0.00,0.00,'2022-06-18 21:56:27','',''),(1912,'21','228','2',1,'Sale Id shift 94',0.00,0.00,0.00,3623.05,0.00,'2022-06-19 19:34:57','',''),(1913,'21','228','2',1,'Sale Id shift 94',0.00,0.00,0.00,5259.32,0.00,'2022-06-19 19:34:57','',''),(1914,'21','228','2',1,'Sale Id shift 94',0.00,0.00,0.00,4848.80,0.00,'2022-06-19 19:34:57','',''),(1915,'21','228','2',1,'Sale Id shift 94',0.00,0.00,0.00,4760.24,0.00,'2022-06-19 19:34:57','',''),(1916,'21','228','2',1,'Sale Id shift 94',0.00,0.00,0.00,4751.92,0.00,'2022-06-19 19:34:57','',''),(1917,'21','228','2',1,'Sale Id shift 94',0.00,0.00,0.00,1490.35,0.00,'2022-06-19 19:34:57','',''),(1918,'21','228','2',1,'Sale Id shift 94',0.00,0.00,0.00,5916.96,0.00,'2022-06-19 19:34:57','',''),(1919,'21','228','2',1,'Sale Id shift 94',0.00,0.00,0.00,6659.29,0.00,'2022-06-19 19:34:57','',''),(1920,'21','228','3',2,'Sale Id shift 94',0.00,0.00,0.00,3623.86,0.00,'2022-06-19 19:34:57','',''),(1921,'21','228','3',2,'Sale Id shift 94',0.00,0.00,0.00,1750.20,0.00,'2022-06-19 19:34:57','',''),(1922,'21','228','4',3,'Sale Id shift 94',0.00,0.00,0.00,1190.16,0.00,'2022-06-19 19:34:57','',''),(1923,'21','228',NULL,2,'Sale Id shift 94',4460469.80,0.00,0.00,0.00,0.00,'2022-06-19 19:34:57','',''),(1924,'21','228',NULL,3,'Sale Id shift 94',892620.00,0.00,0.00,0.00,0.00,'2022-06-19 19:34:57','',''),(1925,'21','228',NULL,1,'Sale Id shift 94',6156138.45,0.00,0.00,0.00,0.00,'2022-06-19 19:34:57','',''),(1926,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-19 20:03:19','',''),(1927,'21','228',NULL,1,'Reception corrector for bridging 152',0.00,0.00,0.00,40000.00,0.00,'2022-06-19 20:06:08','',''),(1928,'21','228','2',1,'Received from bridging 152',0.00,0.00,40000.00,0.00,0.00,'2022-06-19 20:06:08','',''),(1929,'21','228','2',1,'Sale Id shift 95',0.00,0.00,0.00,5173.60,0.00,'2022-06-20 17:22:59','',''),(1930,'21','228','2',1,'Sale Id shift 95',0.00,0.00,0.00,7719.37,0.00,'2022-06-20 17:22:59','',''),(1931,'21','228','2',1,'Sale Id shift 95',0.00,0.00,0.00,6674.03,0.00,'2022-06-20 17:22:59','',''),(1932,'21','228','2',1,'Sale Id shift 95',0.00,0.00,0.00,7469.39,0.00,'2022-06-20 17:22:59','',''),(1933,'21','228','2',1,'Sale Id shift 95',0.00,0.00,0.00,5866.38,0.00,'2022-06-20 17:22:59','',''),(1934,'21','228','2',1,'Sale Id shift 95',0.00,0.00,0.00,6149.64,0.00,'2022-06-20 17:22:59','',''),(1935,'21','228','2',1,'Sale Id shift 95',0.00,0.00,0.00,8311.71,0.00,'2022-06-20 17:22:59','',''),(1936,'21','228','2',1,'Sale Id shift 95',0.00,0.00,0.00,8453.58,0.00,'2022-06-20 17:22:59','',''),(1937,'21','228','3',2,'Sale Id shift 95',0.00,0.00,0.00,1526.62,0.00,'2022-06-20 17:22:59','',''),(1938,'21','228','3',2,'Sale Id shift 95',0.00,0.00,0.00,748.97,0.00,'2022-06-20 17:22:59','',''),(1939,'21','228','4',3,'Sale Id shift 95',0.00,0.00,0.00,1046.00,0.00,'2022-06-20 17:22:59','',''),(1940,'21','228',NULL,1,'Sale Id shift 95',9209920.50,0.00,0.00,0.00,0.00,'2022-06-20 17:22:59','',''),(1941,'21','228',NULL,2,'Sale Id shift 95',1888739.70,0.00,0.00,0.00,0.00,'2022-06-20 17:22:59','',''),(1942,'21','228',NULL,3,'Sale Id shift 95',784500.00,0.00,0.00,0.00,0.00,'2022-06-20 17:23:00','',''),(1943,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-21 18:00:57','',''),(1944,'21','228',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,40000.00,0.00,'2022-06-21 18:01:57','',''),(1945,'21','228','2',1,'Received from bridging 153',0.00,0.00,40000.00,0.00,0.00,'2022-06-21 18:01:57','',''),(1946,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,22500000.00,30000.00,0.00,0.00,'2022-06-21 18:02:13','',''),(1947,'21','228',NULL,3,'Reception corrector for bridging 154',0.00,0.00,0.00,30000.00,0.00,'2022-06-21 18:04:28','',''),(1948,'21','228','4',3,'Received from bridging 154',0.00,0.00,30000.00,0.00,0.00,'2022-06-21 18:04:28','',''),(1949,'21','228','2',1,'Sale Id shift 96',0.00,0.00,0.00,2566.02,0.00,'2022-06-21 18:18:27','',''),(1950,'21','228','2',1,'Sale Id shift 96',0.00,0.00,0.00,3553.20,0.00,'2022-06-21 18:18:27','',''),(1951,'21','228','2',1,'Sale Id shift 96',0.00,0.00,0.00,3012.17,0.00,'2022-06-21 18:18:27','',''),(1952,'21','228','2',1,'Sale Id shift 96',0.00,0.00,0.00,3808.14,0.00,'2022-06-21 18:18:27','',''),(1953,'21','228','2',1,'Sale Id shift 96',0.00,0.00,0.00,3046.30,0.00,'2022-06-21 18:18:27','',''),(1954,'21','228','2',1,'Sale Id shift 96',0.00,0.00,0.00,893.87,0.00,'2022-06-21 18:18:27','',''),(1955,'21','228','2',1,'Sale Id shift 96',0.00,0.00,0.00,3358.10,0.00,'2022-06-21 18:18:27','',''),(1956,'21','228','2',1,'Sale Id shift 96',0.00,0.00,0.00,2980.50,0.00,'2022-06-21 18:18:27','',''),(1957,'21','228','3',2,'Sale Id shift 96',0.00,0.00,0.00,3228.85,0.00,'2022-06-21 18:18:27','',''),(1958,'21','228','3',2,'Sale Id shift 96',0.00,0.00,0.00,367.24,0.00,'2022-06-21 18:18:27','',''),(1959,'21','228','3',2,'Sale Id shift 96',0.00,0.00,0.00,3356.25,0.00,'2022-06-21 18:18:27','',''),(1960,'21','228','4',3,'Sale Id shift 96',0.00,0.00,0.00,1059.31,0.00,'2022-06-21 18:18:27','',''),(1961,'21','228',NULL,1,'Sale Id shift 96',3831019.50,0.00,0.00,0.00,0.00,'2022-06-21 18:18:27','',''),(1962,'21','228',NULL,2,'Sale Id shift 96',5770442.20,0.00,0.00,0.00,0.00,'2022-06-21 18:18:27','',''),(1963,'21','228',NULL,3,'Sale Id shift 96',794482.50,0.00,0.00,0.00,0.00,'2022-06-21 18:18:27','',''),(1964,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-23 15:59:42','',''),(1965,'21','228',NULL,1,'Reception corrector for bridging 155',0.00,0.00,0.00,40000.00,0.00,'2022-06-23 16:02:47','',''),(1966,'21','228','2',1,'Received from bridging 155',0.00,0.00,40000.00,0.00,0.00,'2022-06-23 16:02:47','',''),(1967,'21','228','2',1,'Sale Id shift 97',0.00,0.00,0.00,2357.36,0.00,'2022-06-23 16:08:23','',''),(1968,'21','228','2',1,'Sale Id shift 97',0.00,0.00,0.00,3711.90,0.00,'2022-06-23 16:08:23','',''),(1969,'21','228','2',1,'Sale Id shift 97',0.00,0.00,0.00,2026.64,0.00,'2022-06-23 16:08:23','',''),(1970,'21','228','2',1,'Sale Id shift 97',0.00,0.00,0.00,3643.25,0.00,'2022-06-23 16:08:23','',''),(1971,'21','228','2',1,'Sale Id shift 97',0.00,0.00,0.00,2695.21,0.00,'2022-06-23 16:08:23','',''),(1972,'21','228','2',1,'Sale Id shift 97',0.00,0.00,0.00,3201.13,0.00,'2022-06-23 16:08:23','',''),(1973,'21','228','2',1,'Sale Id shift 97',0.00,0.00,0.00,3756.14,0.00,'2022-06-23 16:08:23','',''),(1974,'21','228','2',1,'Sale Id shift 97',0.00,0.00,0.00,4206.47,0.00,'2022-06-23 16:08:23','',''),(1975,'21','228','3',2,'Sale Id shift 97',0.00,0.00,0.00,2117.66,0.00,'2022-06-23 16:08:23','',''),(1976,'21','228','3',2,'Sale Id shift 97',0.00,0.00,0.00,25.12,0.00,'2022-06-23 16:08:23','',''),(1977,'21','228','3',2,'Sale Id shift 97',0.00,0.00,0.00,2736.34,0.00,'2022-06-23 16:08:23','',''),(1978,'21','228','4',3,'Sale Id shift 97',0.00,0.00,0.00,1586.83,0.00,'2022-06-23 16:08:23','',''),(1979,'21','228',NULL,1,'Sale Id shift 97',4223686.50,0.00,0.00,0.00,0.00,'2022-06-23 16:08:23','',''),(1980,'21','228',NULL,2,'Sale Id shift 97',4049669.60,0.00,0.00,0.00,0.00,'2022-06-23 16:08:23','',''),(1981,'21','228',NULL,3,'Sale Id shift 97',1190122.50,0.00,0.00,0.00,0.00,'2022-06-23 16:08:23','',''),(1982,'21','228','2',1,'Sale Id shift 98',0.00,0.00,0.00,960.20,0.00,'2022-06-23 16:29:17','',''),(1983,'21','228','2',1,'Sale Id shift 98',0.00,0.00,0.00,1263.28,0.00,'2022-06-23 16:29:17','',''),(1984,'21','228','2',1,'Sale Id shift 98',0.00,0.00,0.00,1279.90,0.00,'2022-06-23 16:29:17','',''),(1985,'21','228','2',1,'Sale Id shift 98',0.00,0.00,0.00,1420.34,0.00,'2022-06-23 16:29:17','',''),(1986,'21','228','2',1,'Sale Id shift 98',0.00,0.00,0.00,863.43,0.00,'2022-06-23 16:29:17','',''),(1987,'21','228','2',1,'Sale Id shift 98',0.00,0.00,0.00,1267.44,0.00,'2022-06-23 16:29:17','',''),(1988,'21','228','2',1,'Sale Id shift 98',0.00,0.00,0.00,862.55,0.00,'2022-06-23 16:29:17','',''),(1989,'21','228','2',1,'Sale Id shift 98',0.00,0.00,0.00,1230.38,0.00,'2022-06-23 16:29:17','',''),(1990,'21','228','3',2,'Sale Id shift 98',0.00,0.00,0.00,1273.31,0.00,'2022-06-23 16:29:17','',''),(1991,'21','228','3',2,'Sale Id shift 98',0.00,0.00,0.00,2852.78,0.00,'2022-06-23 16:29:17','',''),(1992,'21','228','4',3,'Sale Id shift 98',0.00,0.00,0.00,1272.59,0.00,'2022-06-23 16:29:17','',''),(1993,'21','228',NULL,1,'Sale Id shift 98',1509340.80,0.00,0.00,0.00,0.00,'2022-06-23 16:29:17','',''),(1994,'21','228',NULL,2,'Sale Id shift 98',3424654.70,0.00,0.00,0.00,0.00,'2022-06-23 16:29:17','',''),(1995,'21','228',NULL,3,'Sale Id shift 98',954442.50,0.00,0.00,0.00,0.00,'2022-06-23 16:29:17','',''),(1996,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-25 18:23:41','',''),(1997,'21','228',NULL,1,'Reception corrector for bridging 156',0.00,0.00,0.00,40000.00,0.00,'2022-06-25 18:50:01','',''),(1998,'21','228','2',1,'Received from bridging 156',0.00,0.00,40000.00,0.00,0.00,'2022-06-25 18:50:01','',''),(1999,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-25 18:53:21','',''),(2000,'21','228','2',1,'Sale Id shift 99',0.00,0.00,0.00,4901.32,0.00,'2022-06-25 19:00:37','',''),(2001,'21','228','2',1,'Sale Id shift 99',0.00,0.00,0.00,7795.62,0.00,'2022-06-25 19:00:37','',''),(2002,'21','228','2',1,'Sale Id shift 99',0.00,0.00,0.00,5749.96,0.00,'2022-06-25 19:00:37','',''),(2003,'21','228','2',1,'Sale Id shift 99',0.00,0.00,0.00,6765.86,0.00,'2022-06-25 19:00:37','',''),(2004,'21','228','2',1,'Sale Id shift 99',0.00,0.00,0.00,5001.15,0.00,'2022-06-25 19:00:37','',''),(2005,'21','228','2',1,'Sale Id shift 99',0.00,0.00,0.00,5573.33,0.00,'2022-06-25 19:00:37','',''),(2006,'21','228','2',1,'Sale Id shift 99',0.00,0.00,0.00,6750.68,0.00,'2022-06-25 19:00:37','',''),(2007,'21','228','2',1,'Sale Id shift 99',0.00,0.00,0.00,7561.39,0.00,'2022-06-25 19:00:37','',''),(2008,'21','228','3',2,'Sale Id shift 99',0.00,0.00,0.00,3163.99,0.00,'2022-06-25 19:00:37','',''),(2009,'21','228','3',2,'Sale Id shift 99',0.00,0.00,0.00,330.17,0.00,'2022-06-25 19:00:37','',''),(2010,'21','228','3',2,'Sale Id shift 99',0.00,0.00,0.00,2736.48,0.00,'2022-06-25 19:00:37','',''),(2011,'21','228','4',3,'Sale Id shift 99',0.00,0.00,0.00,1201.02,0.00,'2022-06-25 19:00:37','',''),(2012,'21','228',NULL,2,'Sale Id shift 99',5171431.20,0.00,0.00,0.00,0.00,'2022-06-25 19:00:37','',''),(2013,'21','228',NULL,3,'Sale Id shift 99',900765.00,0.00,0.00,0.00,0.00,'2022-06-25 19:00:37','',''),(2014,'21','228',NULL,1,'Sale Id shift 99',8266386.15,0.00,0.00,0.00,0.00,'2022-06-25 19:00:37','',''),(2015,'21','228',NULL,1,'Reception corrector for bridging 157',0.00,0.00,0.00,40000.00,0.00,'2022-06-25 19:05:46','',''),(2016,'21','228','2',1,'Received from bridging 157',0.00,0.00,40000.00,0.00,0.00,'2022-06-25 19:05:46','',''),(2017,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,14110000.00,17000.00,0.00,0.00,'2022-06-25 19:05:55','',''),(2018,'21','228',NULL,2,'Reception corrector for bridging 158',0.00,0.00,0.00,17000.00,0.00,'2022-06-25 19:06:51','',''),(2019,'21','228','3',2,'Received from bridging 158',0.00,0.00,17000.00,0.00,0.00,'2022-06-25 19:06:51','',''),(2020,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,14110000.00,17000.00,0.00,0.00,'2022-06-25 19:07:01','',''),(2021,'21','228',NULL,2,'Reception corrector for bridging 159',0.00,0.00,0.00,17000.00,0.00,'2022-06-25 19:07:57','',''),(2022,'21','228','3',2,'Received from bridging 159',0.00,0.00,17000.00,0.00,0.00,'2022-06-25 19:07:57','',''),(2023,'21','228','2',1,'Sale Id shift 100',0.00,0.00,0.00,2860.04,0.00,'2022-06-25 19:43:13','',''),(2024,'21','228','2',1,'Sale Id shift 100',0.00,0.00,0.00,3378.17,0.00,'2022-06-25 19:43:13','',''),(2025,'21','228','2',1,'Sale Id shift 100',0.00,0.00,0.00,1687.86,0.00,'2022-06-25 19:43:13','',''),(2026,'21','228','2',1,'Sale Id shift 100',0.00,0.00,0.00,3406.55,0.00,'2022-06-25 19:43:13','',''),(2027,'21','228','2',1,'Sale Id shift 100',0.00,0.00,0.00,3105.95,0.00,'2022-06-25 19:43:13','',''),(2028,'21','228','2',1,'Sale Id shift 100',0.00,0.00,0.00,3011.59,0.00,'2022-06-25 19:43:13','',''),(2029,'21','228','2',1,'Sale Id shift 100',0.00,0.00,0.00,3396.08,0.00,'2022-06-25 19:43:13','',''),(2030,'21','228','3',2,'Sale Id shift 100',0.00,0.00,0.00,2660.27,0.00,'2022-06-25 19:43:13','',''),(2031,'21','228','3',2,'Sale Id shift 100',0.00,0.00,0.00,34.94,0.00,'2022-06-25 19:43:13','',''),(2032,'21','228','3',2,'Sale Id shift 100',0.00,0.00,0.00,1211.48,0.00,'2022-06-25 19:43:13','',''),(2033,'21','228','4',3,'Sale Id shift 100',0.00,0.00,0.00,806.88,0.00,'2022-06-25 19:43:13','',''),(2034,'21','228',NULL,1,'Sale Id shift 100',3439629.60,0.00,0.00,0.00,0.00,'2022-06-25 19:43:13','',''),(2035,'21','228',NULL,2,'Sale Id shift 100',3242552.70,0.00,0.00,0.00,0.00,'2022-06-25 19:43:13','',''),(2036,'21','228',NULL,3,'Sale Id shift 100',605160.00,0.00,0.00,0.00,0.00,'2022-06-25 19:43:13','',''),(2037,'21','228','2',1,'Sale Id shift 101',0.00,0.00,0.00,3338.96,0.00,'2022-06-27 19:44:44','',''),(2038,'21','228','2',1,'Sale Id shift 101',0.00,0.00,0.00,3223.82,0.00,'2022-06-27 19:44:44','',''),(2039,'21','228','2',1,'Sale Id shift 101',0.00,0.00,0.00,3033.15,0.00,'2022-06-27 19:44:44','',''),(2040,'21','228','2',1,'Sale Id shift 101',0.00,0.00,0.00,3665.82,0.00,'2022-06-27 19:44:44','',''),(2041,'21','228','2',1,'Sale Id shift 101',0.00,0.00,0.00,2503.68,0.00,'2022-06-27 19:44:44','',''),(2042,'21','228','2',1,'Sale Id shift 101',0.00,0.00,0.00,2374.39,0.00,'2022-06-27 19:44:44','',''),(2043,'21','228','2',1,'Sale Id shift 101',0.00,0.00,0.00,3382.87,0.00,'2022-06-27 19:44:44','',''),(2044,'21','228','2',1,'Sale Id shift 101',0.00,0.00,0.00,3912.73,0.00,'2022-06-27 19:44:44','',''),(2045,'21','228','3',2,'Sale Id shift 101',0.00,0.00,0.00,2049.12,0.00,'2022-06-27 19:44:44','',''),(2046,'21','228','3',2,'Sale Id shift 101',0.00,0.00,0.00,10.20,0.00,'2022-06-27 19:44:44','',''),(2047,'21','228','3',2,'Sale Id shift 101',0.00,0.00,0.00,3707.21,0.00,'2022-06-27 19:44:44','',''),(2048,'21','228','4',3,'Sale Id shift 101',0.00,0.00,0.00,1057.35,0.00,'2022-06-27 19:44:44','',''),(2049,'21','228',NULL,1,'Sale Id shift 101',4196844.30,0.00,0.00,0.00,0.00,'2022-06-27 19:44:44','',''),(2050,'21','228',NULL,2,'Sale Id shift 101',4786219.90,0.00,0.00,0.00,0.00,'2022-06-27 19:44:44','',''),(2051,'21','228',NULL,3,'Sale Id shift 101',793012.50,0.00,0.00,0.00,0.00,'2022-06-27 19:44:44','',''),(2052,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-27 20:22:43','',''),(2053,'21','228',NULL,1,'Reception corrector for bridging 161',0.00,0.00,0.00,33500.00,0.00,'2022-06-27 20:32:50','',''),(2054,'21','228','2',1,'Received from bridging 161',0.00,0.00,33500.00,0.00,0.00,'2022-06-27 20:32:50','',''),(2055,'21','228',NULL,1,'Reception corrector for bridging 160',0.00,0.00,0.00,16500.00,0.00,'2022-06-27 20:32:50','',''),(2056,'21','228','1',1,'Received from bridging 160',0.00,0.00,16500.00,0.00,0.00,'2022-06-27 20:32:50','',''),(2057,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,12450000.00,15000.00,0.00,0.00,'2022-06-27 20:32:59','',''),(2058,'21','228',NULL,2,'Reception corrector for bridging 162',0.00,0.00,0.00,15000.00,0.00,'2022-06-27 20:34:46','',''),(2059,'21','228','3',2,'Received from bridging 162',0.00,0.00,15000.00,0.00,0.00,'2022-06-27 20:34:46','',''),(2060,'21','228','2',1,'Sale Id shift 102',0.00,0.00,0.00,1498.76,0.00,'2022-06-27 20:50:01','',''),(2061,'21','228','2',1,'Sale Id shift 102',0.00,0.00,0.00,2684.36,0.00,'2022-06-27 20:50:01','',''),(2062,'21','228','2',1,'Sale Id shift 102',0.00,0.00,0.00,2353.23,0.00,'2022-06-27 20:50:01','',''),(2063,'21','228','2',1,'Sale Id shift 102',0.00,0.00,0.00,2941.55,0.00,'2022-06-27 20:50:01','',''),(2064,'21','228','2',1,'Sale Id shift 102',0.00,0.00,0.00,2088.42,0.00,'2022-06-27 20:50:01','',''),(2065,'21','228','2',1,'Sale Id shift 102',0.00,0.00,0.00,2354.97,0.00,'2022-06-27 20:50:01','',''),(2066,'21','228','2',1,'Sale Id shift 102',0.00,0.00,0.00,2212.71,0.00,'2022-06-27 20:50:01','',''),(2067,'21','228','1',1,'Sale Id shift 102',0.00,0.00,0.00,1365.53,0.00,'2022-06-27 20:50:01','',''),(2068,'21','228','2',1,'Sale Id shift 102',0.00,0.00,0.00,2898.04,0.00,'2022-06-27 20:50:01','',''),(2069,'21','228','3',2,'Sale Id shift 102',0.00,0.00,0.00,284.45,0.00,'2022-06-27 20:50:01','',''),(2070,'21','228','3',2,'Sale Id shift 102',0.00,0.00,0.00,1115.24,0.00,'2022-06-27 20:50:01','',''),(2071,'21','228','4',3,'Sale Id shift 102',0.00,0.00,0.00,1058.36,0.00,'2022-06-27 20:50:01','',''),(2072,'21','228','1',1,'Sale Id shift 102',0.00,0.00,0.00,781.75,0.00,'2022-06-27 20:50:01','',''),(2073,'21','228','1',1,'Sale Id shift 102',0.00,0.00,0.00,458.89,0.00,'2022-06-27 20:50:01','',''),(2074,'21','228','1',1,'Sale Id shift 102',0.00,0.00,0.00,335.56,0.00,'2022-06-27 20:50:01','',''),(2075,'21','228','1',1,'Sale Id shift 102',0.00,0.00,0.00,508.12,0.00,'2022-06-27 20:50:01','',''),(2076,'21','228','1',1,'Sale Id shift 102',0.00,0.00,0.00,299.83,0.00,'2022-06-27 20:50:01','',''),(2077,'21','228',NULL,2,'Sale Id shift 102',1161742.70,0.00,0.00,0.00,0.00,'2022-06-27 20:50:01','',''),(2078,'21','228',NULL,3,'Sale Id shift 102',793770.00,0.00,0.00,0.00,0.00,'2022-06-27 20:50:01','',''),(2079,'21','228',NULL,1,'Sale Id shift 102',3758983.80,0.00,0.00,0.00,0.00,'2022-06-27 20:50:01','',''),(2080,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-29 13:45:47','',''),(2081,'21','228',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,39940.00,0.00,'2022-06-29 13:49:35','',''),(2082,'21','228','2',1,'Received from bridging 164',0.00,0.00,39940.00,0.00,0.00,'2022-06-29 13:49:35','',''),(2083,'21','228',NULL,1,'Reception corrector for bridging 163',0.00,0.00,0.00,60.00,0.00,'2022-06-29 13:49:35','',''),(2084,'21','228','1',1,'Received from bridging 163',0.00,0.00,60.00,0.00,0.00,'2022-06-29 13:49:35','',''),(2085,'21','228','2',1,'Sale Id shift 103',0.00,0.00,0.00,2419.87,0.00,'2022-06-29 13:54:50','',''),(2086,'21','228','2',1,'Sale Id shift 103',0.00,0.00,0.00,3789.88,0.00,'2022-06-29 13:54:50','',''),(2087,'21','228','2',1,'Sale Id shift 103',0.00,0.00,0.00,3741.50,0.00,'2022-06-29 13:54:50','',''),(2088,'21','228','2',1,'Sale Id shift 103',0.00,0.00,0.00,4535.84,0.00,'2022-06-29 13:54:50','',''),(2089,'21','228','2',1,'Sale Id shift 103',0.00,0.00,0.00,2230.71,0.00,'2022-06-29 13:54:50','',''),(2090,'21','228','2',1,'Sale Id shift 103',0.00,0.00,0.00,3700.73,0.00,'2022-06-29 13:54:50','',''),(2091,'21','228','2',1,'Sale Id shift 103',0.00,0.00,0.00,4054.92,0.00,'2022-06-29 13:54:50','',''),(2092,'21','228','1',1,'Sale Id shift 103',0.00,0.00,0.00,2974.48,0.00,'2022-06-29 13:54:50','',''),(2093,'21','228','2',1,'Sale Id shift 103',0.00,0.00,0.00,4359.17,0.00,'2022-06-29 13:54:50','',''),(2094,'21','228','3',2,'Sale Id shift 103',0.00,0.00,0.00,2660.44,0.00,'2022-06-29 13:54:50','',''),(2095,'21','228','3',2,'Sale Id shift 103',0.00,0.00,0.00,3568.70,0.00,'2022-06-29 13:54:50','',''),(2096,'21','228','4',3,'Sale Id shift 103',0.00,0.00,0.00,906.25,0.00,'2022-06-29 13:54:50','',''),(2097,'21','228','1',1,'Sale Id shift 103',0.00,0.00,0.00,1952.63,0.00,'2022-06-29 13:54:50','',''),(2098,'21','228','1',1,'Sale Id shift 103',0.00,0.00,0.00,58.68,0.00,'2022-06-29 13:54:50','',''),(2099,'21','228','1',1,'Sale Id shift 103',0.00,0.00,0.00,1446.08,0.00,'2022-06-29 13:54:50','',''),(2100,'21','228','1',1,'Sale Id shift 103',0.00,0.00,0.00,1490.43,0.00,'2022-06-29 13:54:50','',''),(2101,'21','228','1',1,'Sale Id shift 103',0.00,0.00,0.00,2244.00,0.00,'2022-06-29 13:54:50','',''),(2102,'21','228','1',1,'Sale Id shift 103',0.00,0.00,0.00,347.62,0.00,'2022-06-29 13:54:50','',''),(2103,'21','228','1',1,'Sale Id shift 103',0.00,0.00,0.00,2290.64,0.00,'2022-06-29 13:54:50','',''),(2104,'21','228',NULL,2,'Sale Id shift 103',5170186.20,0.00,0.00,0.00,0.00,'2022-06-29 13:54:50','',''),(2105,'21','228',NULL,3,'Sale Id shift 103',679687.50,0.00,0.00,0.00,0.00,'2022-06-29 13:54:50','',''),(2106,'21','228',NULL,1,'Sale Id shift 103',6870134.70,0.00,0.00,0.00,0.00,'2022-06-29 13:54:50','',''),(2107,'21','228','2',1,'Sale Id shift 104',0.00,0.00,0.00,633.18,0.00,'2022-06-29 14:14:29','',''),(2108,'21','228','2',1,'Sale Id shift 104',0.00,0.00,0.00,948.77,0.00,'2022-06-29 14:14:29','',''),(2109,'21','228','2',1,'Sale Id shift 104',0.00,0.00,0.00,713.89,0.00,'2022-06-29 14:14:29','',''),(2110,'21','228','2',1,'Sale Id shift 104',0.00,0.00,0.00,904.69,0.00,'2022-06-29 14:14:29','',''),(2111,'21','228','2',1,'Sale Id shift 104',0.00,0.00,0.00,661.10,0.00,'2022-06-29 14:14:29','',''),(2112,'21','228','2',1,'Sale Id shift 104',0.00,0.00,0.00,907.76,0.00,'2022-06-29 14:14:29','',''),(2113,'21','228','2',1,'Sale Id shift 104',0.00,0.00,0.00,682.66,0.00,'2022-06-29 14:14:29','',''),(2114,'21','228','2',1,'Sale Id shift 104',0.00,0.00,0.00,1000.08,0.00,'2022-06-29 14:14:29','',''),(2115,'21','228','3',2,'Sale Id shift 104',0.00,0.00,0.00,1821.02,0.00,'2022-06-29 14:14:29','',''),(2116,'21','228','3',2,'Sale Id shift 104',0.00,0.00,0.00,3082.64,0.00,'2022-06-29 14:14:29','',''),(2117,'21','228','4',3,'Sale Id shift 104',0.00,0.00,0.00,1209.50,0.00,'2022-06-29 14:14:29','',''),(2118,'21','228',NULL,1,'Sale Id shift 104',1064601.45,0.00,0.00,0.00,0.00,'2022-06-29 14:14:29','',''),(2119,'21','228',NULL,2,'Sale Id shift 104',4070037.80,0.00,0.00,0.00,0.00,'2022-06-29 14:14:29','',''),(2120,'21','228',NULL,3,'Sale Id shift 104',907125.00,0.00,0.00,0.00,0.00,'2022-06-29 14:14:29','',''),(2121,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-30 17:59:30','',''),(2122,'21','228',NULL,1,'Reception corrector for bridging 165',0.00,0.00,0.00,45000.00,0.00,'2022-06-30 18:11:56','',''),(2123,'21','228','2',1,'Received from bridging 165',0.00,0.00,45000.00,0.00,0.00,'2022-06-30 18:11:56','',''),(2124,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,12450000.00,15000.00,0.00,0.00,'2022-06-30 18:12:17','',''),(2125,'21','228',NULL,2,'Reception corrector for bridging 166',0.00,0.00,0.00,15000.00,0.00,'2022-06-30 18:13:36','',''),(2126,'21','228','3',2,'Received from bridging 166',0.00,0.00,15000.00,0.00,0.00,'2022-06-30 18:13:36','',''),(2127,'21','228','2',1,'Sale Id shift 105',0.00,0.00,0.00,4984.02,0.00,'2022-06-30 18:19:02','',''),(2128,'21','228','2',1,'Sale Id shift 105',0.00,0.00,0.00,6354.64,0.00,'2022-06-30 18:19:02','',''),(2129,'21','228','2',1,'Sale Id shift 105',0.00,0.00,0.00,6836.70,0.00,'2022-06-30 18:19:02','',''),(2130,'21','228','2',1,'Sale Id shift 105',0.00,0.00,0.00,6874.90,0.00,'2022-06-30 18:19:02','',''),(2131,'21','228','2',1,'Sale Id shift 105',0.00,0.00,0.00,2227.95,0.00,'2022-06-30 18:19:02','',''),(2132,'21','228','2',1,'Sale Id shift 105',0.00,0.00,0.00,5909.01,0.00,'2022-06-30 18:19:02','',''),(2133,'21','228','2',1,'Sale Id shift 105',0.00,0.00,0.00,6525.51,0.00,'2022-06-30 18:19:02','',''),(2134,'21','228','2',1,'Sale Id shift 105',0.00,0.00,0.00,6676.50,0.00,'2022-06-30 18:19:02','',''),(2135,'21','228','3',2,'Sale Id shift 105',0.00,0.00,0.00,378.18,0.00,'2022-06-30 18:19:02','',''),(2136,'21','228','3',2,'Sale Id shift 105',0.00,0.00,0.00,3383.65,0.00,'2022-06-30 18:19:02','',''),(2137,'21','228','4',3,'Sale Id shift 105',0.00,0.00,0.00,1142.33,0.00,'2022-06-30 18:19:02','',''),(2138,'21','228',NULL,1,'Sale Id shift 105',7654222.95,0.00,0.00,0.00,0.00,'2022-06-30 18:19:02','',''),(2139,'21','228',NULL,2,'Sale Id shift 105',3122318.90,0.00,0.00,0.00,0.00,'2022-06-30 18:19:02','',''),(2140,'21','228',NULL,3,'Sale Id shift 105',856747.50,0.00,0.00,0.00,0.00,'2022-06-30 18:19:02','',''),(2141,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-01 20:56:37','',''),(2142,'21','228',NULL,1,'Reception corrector for bridging 168',0.00,0.00,0.00,29500.00,0.00,'2022-07-01 20:59:33','',''),(2143,'21','228','2',1,'Received from bridging 168',0.00,0.00,29500.00,0.00,0.00,'2022-07-01 20:59:33','',''),(2144,'21','228',NULL,1,'Reception corrector for bridging 167',0.00,0.00,0.00,15500.00,0.00,'2022-07-01 20:59:33','',''),(2145,'21','228','1',1,'Received from bridging 167',0.00,0.00,15500.00,0.00,0.00,'2022-07-01 20:59:33','',''),(2146,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-01 20:59:55','',''),(2147,'21','228',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,26500.00,0.00,'2022-07-01 21:01:47','',''),(2148,'21','228','2',1,'Received from bridging 170',0.00,0.00,26500.00,0.00,0.00,'2022-07-01 21:01:47','',''),(2149,'21','228',NULL,1,'Reception corrector for bridging 169',0.00,0.00,0.00,13500.00,0.00,'2022-07-01 21:01:47','',''),(2150,'21','228','1',1,'Received from bridging 169',0.00,0.00,13500.00,0.00,0.00,'2022-07-01 21:01:47','',''),(2151,'21','228','2',1,'Sale Id shift 106',0.00,0.00,0.00,4519.95,0.00,'2022-07-01 21:12:47','',''),(2152,'21','228','2',1,'Sale Id shift 106',0.00,0.00,0.00,5009.92,0.00,'2022-07-01 21:12:47','',''),(2153,'21','228','2',1,'Sale Id shift 106',0.00,0.00,0.00,5888.38,0.00,'2022-07-01 21:12:47','',''),(2154,'21','228','2',1,'Sale Id shift 106',0.00,0.00,0.00,5441.33,0.00,'2022-07-01 21:12:47','',''),(2155,'21','228','2',1,'Sale Id shift 106',0.00,0.00,0.00,5097.38,0.00,'2022-07-01 21:12:47','',''),(2156,'21','228','2',1,'Sale Id shift 106',0.00,0.00,0.00,4292.88,0.00,'2022-07-01 21:12:47','',''),(2157,'21','228','2',1,'Sale Id shift 106',0.00,0.00,0.00,5584.93,0.00,'2022-07-01 21:12:47','',''),(2158,'21','228','1',1,'Sale Id shift 106',0.00,0.00,0.00,1304.13,0.00,'2022-07-01 21:12:47','',''),(2159,'21','228','2',1,'Sale Id shift 106',0.00,0.00,0.00,5974.84,0.00,'2022-07-01 21:12:47','',''),(2160,'21','228','3',2,'Sale Id shift 106',0.00,0.00,0.00,2741.05,0.00,'2022-07-01 21:12:47','',''),(2161,'21','228','3',2,'Sale Id shift 106',0.00,0.00,0.00,2580.03,0.00,'2022-07-01 21:12:47','',''),(2162,'21','228','4',3,'Sale Id shift 106',0.00,0.00,0.00,919.71,0.00,'2022-07-01 21:12:47','',''),(2163,'21','228','1',1,'Sale Id shift 106',0.00,0.00,0.00,1103.44,0.00,'2022-07-01 21:12:47','',''),(2164,'21','228','1',1,'Sale Id shift 106',0.00,0.00,0.00,990.78,0.00,'2022-07-01 21:12:47','',''),(2165,'21','228','1',1,'Sale Id shift 106',0.00,0.00,0.00,0.06,0.00,'2022-07-01 21:12:47','',''),(2166,'21','228','1',1,'Sale Id shift 106',0.00,0.00,0.00,848.76,0.00,'2022-07-01 21:12:47','',''),(2167,'21','228',NULL,2,'Sale Id shift 106',4416496.40,0.00,0.00,0.00,0.00,'2022-07-01 21:12:47','',''),(2168,'21','228',NULL,3,'Sale Id shift 106',689782.50,0.00,0.00,0.00,0.00,'2022-07-01 21:12:47','',''),(2169,'21','228',NULL,1,'Sale Id shift 106',7599368.70,0.00,0.00,0.00,0.00,'2022-07-01 21:12:47','',''),(2170,'21','228','2',1,'Sale Id shift 107',0.00,0.00,0.00,3032.44,0.00,'2022-07-02 16:10:02','',''),(2171,'21','228','2',1,'Sale Id shift 107',0.00,0.00,0.00,4473.41,0.00,'2022-07-02 16:10:02','',''),(2172,'21','228','2',1,'Sale Id shift 107',0.00,0.00,0.00,4850.48,0.00,'2022-07-02 16:10:02','',''),(2173,'21','228','2',1,'Sale Id shift 107',0.00,0.00,0.00,4556.67,0.00,'2022-07-02 16:10:02','',''),(2174,'21','228','2',1,'Sale Id shift 107',0.00,0.00,0.00,3733.63,0.00,'2022-07-02 16:10:02','',''),(2175,'21','228','2',1,'Sale Id shift 107',0.00,0.00,0.00,4433.01,0.00,'2022-07-02 16:10:02','',''),(2176,'21','228','2',1,'Sale Id shift 107',0.00,0.00,0.00,5538.00,0.00,'2022-07-02 16:10:02','',''),(2177,'21','228','1',1,'Sale Id shift 107',0.00,0.00,0.00,5316.95,0.00,'2022-07-02 16:10:02','',''),(2178,'21','228','2',1,'Sale Id shift 107',0.00,0.00,0.00,5230.21,0.00,'2022-07-02 16:10:02','',''),(2179,'21','228','3',2,'Sale Id shift 107',0.00,0.00,0.00,2021.90,0.00,'2022-07-02 16:10:02','',''),(2180,'21','228','3',2,'Sale Id shift 107',0.00,0.00,0.00,1666.81,0.00,'2022-07-02 16:10:02','',''),(2181,'21','228','4',3,'Sale Id shift 107',0.00,0.00,0.00,1711.17,0.00,'2022-07-02 16:10:02','',''),(2182,'21','228','1',1,'Sale Id shift 107',0.00,0.00,0.00,3846.67,0.00,'2022-07-02 16:10:02','',''),(2183,'21','228','1',1,'Sale Id shift 107',0.00,0.00,0.00,956.53,0.00,'2022-07-02 16:10:02','',''),(2184,'21','228','1',1,'Sale Id shift 107',0.00,0.00,0.00,170.22,0.00,'2022-07-02 16:10:02','',''),(2185,'21','228','1',1,'Sale Id shift 107',0.00,0.00,0.00,3956.65,0.00,'2022-07-02 16:10:02','',''),(2186,'21','228','1',1,'Sale Id shift 107',0.00,0.00,0.00,3225.25,0.00,'2022-07-02 16:10:02','',''),(2187,'21','228','1',1,'Sale Id shift 107',0.00,0.00,0.00,1799.80,0.00,'2022-07-02 16:10:02','',''),(2188,'21','228',NULL,1,'Sale Id shift 107',9094786.80,0.00,0.00,0.00,0.00,'2022-07-02 16:10:02','',''),(2189,'21','228',NULL,2,'Sale Id shift 107',3061629.30,0.00,0.00,0.00,0.00,'2022-07-02 16:10:02','',''),(2190,'21','228',NULL,3,'Sale Id shift 107',1283377.50,0.00,0.00,0.00,0.00,'2022-07-02 16:10:02','',''),(2191,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-03 18:10:06','',''),(2192,'21','228',NULL,1,'Reception corrector for bridging 172',0.00,0.00,0.00,22500.00,0.00,'2022-07-03 18:14:24','',''),(2193,'21','228','2',1,'Received from bridging 172',0.00,0.00,22500.00,0.00,0.00,'2022-07-03 18:14:24','',''),(2194,'21','228',NULL,1,'Reception corrector for bridging 171',0.00,0.00,0.00,17500.00,0.00,'2022-07-03 18:14:24','',''),(2195,'21','228','1',1,'Received from bridging 171',0.00,0.00,17500.00,0.00,0.00,'2022-07-03 18:14:24','',''),(2196,'21','228','2',1,'Sale Id shift 108',0.00,0.00,0.00,2060.47,0.00,'2022-07-03 18:20:31','',''),(2197,'21','228','2',1,'Sale Id shift 108',0.00,0.00,0.00,3168.65,0.00,'2022-07-03 18:20:31','',''),(2198,'21','228','2',1,'Sale Id shift 108',0.00,0.00,0.00,3722.88,0.00,'2022-07-03 18:20:31','',''),(2199,'21','228','2',1,'Sale Id shift 108',0.00,0.00,0.00,3579.15,0.00,'2022-07-03 18:20:31','',''),(2200,'21','228','2',1,'Sale Id shift 108',0.00,0.00,0.00,2486.28,0.00,'2022-07-03 18:20:31','',''),(2201,'21','228','2',1,'Sale Id shift 108',0.00,0.00,0.00,3406.81,0.00,'2022-07-03 18:20:31','',''),(2202,'21','228','2',1,'Sale Id shift 108',0.00,0.00,0.00,4140.84,0.00,'2022-07-03 18:20:31','',''),(2203,'21','228','1',1,'Sale Id shift 108',0.00,0.00,0.00,4083.62,0.00,'2022-07-03 18:20:31','',''),(2204,'21','228','2',1,'Sale Id shift 108',0.00,0.00,0.00,3068.34,0.00,'2022-07-03 18:20:31','',''),(2205,'21','228','3',2,'Sale Id shift 108',0.00,0.00,0.00,2934.32,0.00,'2022-07-03 18:20:31','',''),(2206,'21','228','3',2,'Sale Id shift 108',0.00,0.00,0.00,983.33,0.00,'2022-07-03 18:20:31','',''),(2207,'21','228','4',3,'Sale Id shift 108',0.00,0.00,0.00,1538.31,0.00,'2022-07-03 18:20:31','',''),(2208,'21','228','1',1,'Sale Id shift 108',0.00,0.00,0.00,3152.46,0.00,'2022-07-03 18:20:31','',''),(2209,'21','228','1',1,'Sale Id shift 108',0.00,0.00,0.00,361.09,0.00,'2022-07-03 18:20:31','',''),(2210,'21','228','1',1,'Sale Id shift 108',0.00,0.00,0.00,3186.64,0.00,'2022-07-03 18:20:31','',''),(2211,'21','228','1',1,'Sale Id shift 108',0.00,0.00,0.00,2216.51,0.00,'2022-07-03 18:20:31','',''),(2212,'21','228','1',1,'Sale Id shift 108',0.00,0.00,0.00,1414.56,0.00,'2022-07-03 18:20:31','',''),(2213,'21','228',NULL,1,'Sale Id shift 108',6607969.50,0.00,0.00,0.00,0.00,'2022-07-03 18:20:31','',''),(2214,'21','228',NULL,2,'Sale Id shift 108',3251649.50,0.00,0.00,0.00,0.00,'2022-07-03 18:20:31','',''),(2215,'21','228',NULL,3,'Sale Id shift 108',1153732.50,0.00,0.00,0.00,0.00,'2022-07-03 18:20:31','',''),(2216,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-04 19:34:13','',''),(2217,'21','228',NULL,1,'Reception corrector for bridging 174',0.00,0.00,0.00,26500.00,0.00,'2022-07-04 19:36:01','',''),(2218,'21','228','2',1,'Received from bridging 174',0.00,0.00,26500.00,0.00,0.00,'2022-07-04 19:36:01','',''),(2219,'21','228',NULL,1,'Reception corrector for bridging 173',0.00,0.00,0.00,13500.00,0.00,'2022-07-04 19:36:01','',''),(2220,'21','228','1',1,'Received from bridging 173',0.00,0.00,13500.00,0.00,0.00,'2022-07-04 19:36:01','',''),(2221,'21','228','2',1,'Sale Id shift 109',0.00,0.00,0.00,1012.13,0.00,'2022-07-04 19:43:11','',''),(2222,'21','228','2',1,'Sale Id shift 109',0.00,0.00,0.00,388.75,0.00,'2022-07-04 19:43:11','',''),(2223,'21','228','2',1,'Sale Id shift 109',0.00,0.00,0.00,877.90,0.00,'2022-07-04 19:43:11','',''),(2224,'21','228','2',1,'Sale Id shift 109',0.00,0.00,0.00,959.32,0.00,'2022-07-04 19:43:11','',''),(2225,'21','228','2',1,'Sale Id shift 109',0.00,0.00,0.00,765.17,0.00,'2022-07-04 19:43:11','',''),(2226,'21','228','2',1,'Sale Id shift 109',0.00,0.00,0.00,731.42,0.00,'2022-07-04 19:43:11','',''),(2227,'21','228','2',1,'Sale Id shift 109',0.00,0.00,0.00,1091.74,0.00,'2022-07-04 19:43:11','',''),(2228,'21','228','1',1,'Sale Id shift 109',0.00,0.00,0.00,2046.14,0.00,'2022-07-04 19:43:11','',''),(2229,'21','228','2',1,'Sale Id shift 109',0.00,0.00,0.00,1088.24,0.00,'2022-07-04 19:43:11','',''),(2230,'21','228','3',2,'Sale Id shift 109',0.00,0.00,0.00,898.43,0.00,'2022-07-04 19:43:11','',''),(2231,'21','228','3',2,'Sale Id shift 109',0.00,0.00,0.00,829.70,0.00,'2022-07-04 19:43:11','',''),(2232,'21','228','4',3,'Sale Id shift 109',0.00,0.00,0.00,986.19,0.00,'2022-07-04 19:43:11','',''),(2233,'21','228','1',1,'Sale Id shift 109',0.00,0.00,0.00,1343.58,0.00,'2022-07-04 19:43:11','',''),(2234,'21','228','1',1,'Sale Id shift 109',0.00,0.00,0.00,566.59,0.00,'2022-07-04 19:43:11','',''),(2235,'21','228','1',1,'Sale Id shift 109',0.00,0.00,0.00,1305.79,0.00,'2022-07-04 19:43:11','',''),(2236,'21','228','1',1,'Sale Id shift 109',0.00,0.00,0.00,602.01,0.00,'2022-07-04 19:43:11','',''),(2237,'21','228','1',1,'Sale Id shift 109',0.00,0.00,0.00,1764.69,0.00,'2022-07-04 19:43:11','',''),(2238,'21','228','1',1,'Sale Id shift 109',0.00,0.00,0.00,955.29,0.00,'2022-07-04 19:43:11','',''),(2239,'21','228',NULL,2,'Sale Id shift 109',1434347.90,0.00,0.00,0.00,0.00,'2022-07-04 19:43:11','',''),(2240,'21','228',NULL,3,'Sale Id shift 109',739642.50,0.00,0.00,0.00,0.00,'2022-07-04 19:43:11','',''),(2241,'21','228',NULL,1,'Sale Id shift 109',2557295.40,0.00,0.00,0.00,0.00,'2022-07-04 19:43:11','',''),(2242,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-08 15:39:16','',''),(2243,'21','228',NULL,1,'Reception corrector for bridging 176',0.00,0.00,0.00,24000.00,0.00,'2022-07-08 15:41:35','',''),(2244,'21','228','2',1,'Received from bridging 176',0.00,0.00,24000.00,0.00,0.00,'2022-07-08 15:41:35','',''),(2245,'21','228',NULL,1,'Reception corrector for bridging 175',0.00,0.00,0.00,16000.00,0.00,'2022-07-08 15:41:35','',''),(2246,'21','228','1',1,'Received from bridging 175',0.00,0.00,16000.00,0.00,0.00,'2022-07-08 15:41:35','',''),(2247,'21','228',NULL,2,'Purchased from AYM SHAFA NIGERIA LTD',0.00,28220000.00,34000.00,0.00,0.00,'2022-07-08 15:41:54','',''),(2248,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-08 15:43:59','',''),(2249,'21','228',NULL,1,'Reception corrector for bridging 179',0.00,0.00,0.00,29500.00,0.00,'2022-07-08 15:46:11','',''),(2250,'21','228','2',1,'Received from bridging 179',0.00,0.00,29500.00,0.00,0.00,'2022-07-08 15:46:11','',''),(2251,'21','228',NULL,1,'Reception corrector for bridging 178',0.00,0.00,0.00,15500.00,0.00,'2022-07-08 15:46:11','',''),(2252,'21','228','1',1,'Received from bridging 178',0.00,0.00,15500.00,0.00,0.00,'2022-07-08 15:46:11','',''),(2253,'21','228',NULL,3,'Purchased from AYM SHAFA NIGERIA LTD',0.00,11250000.00,15000.00,0.00,0.00,'2022-07-08 15:46:21','',''),(2254,'21','228',NULL,3,'Reception corrector for bridging 180',0.00,0.00,0.00,15000.00,0.00,'2022-07-08 15:47:17','',''),(2255,'21','228','4',3,'Received from bridging 180',0.00,0.00,15000.00,0.00,0.00,'2022-07-08 15:47:17','',''),(2256,'21','228',NULL,1,'Purchased from AYM SHAFA NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-08 15:47:32','',''),(2257,'21','228',NULL,1,'Reception corrector for bridging 181',0.00,0.00,0.00,15000.00,0.00,'2022-07-08 15:49:11','',''),(2258,'21','228','1',1,'Received from bridging 181',0.00,0.00,15000.00,0.00,0.00,'2022-07-08 15:49:11','',''),(2259,'21','228','2',1,'Sale Id shift 110',0.00,0.00,0.00,1904.58,0.00,'2022-07-08 15:56:48','',''),(2260,'21','228','2',1,'Sale Id shift 110',0.00,0.00,0.00,2537.78,0.00,'2022-07-08 15:56:48','',''),(2261,'21','228','2',1,'Sale Id shift 110',0.00,0.00,0.00,2872.09,0.00,'2022-07-08 15:56:48','',''),(2262,'21','228','2',1,'Sale Id shift 110',0.00,0.00,0.00,2728.03,0.00,'2022-07-08 15:56:48','',''),(2263,'21','228','2',1,'Sale Id shift 110',0.00,0.00,0.00,2453.63,0.00,'2022-07-08 15:56:48','',''),(2264,'21','228','2',1,'Sale Id shift 110',0.00,0.00,0.00,1720.06,0.00,'2022-07-08 15:56:48','',''),(2265,'21','228','2',1,'Sale Id shift 110',0.00,0.00,0.00,3245.93,0.00,'2022-07-08 15:56:48','',''),(2266,'21','228','1',1,'Sale Id shift 110',0.00,0.00,0.00,2438.61,0.00,'2022-07-08 15:56:48','',''),(2267,'21','228','2',1,'Sale Id shift 110',0.00,0.00,0.00,3295.70,0.00,'2022-07-08 15:56:48','',''),(2268,'21','228','3',2,'Sale Id shift 110',0.00,0.00,0.00,5016.15,0.00,'2022-07-08 15:56:48','',''),(2269,'21','228','3',2,'Sale Id shift 110',0.00,0.00,0.00,2836.40,0.00,'2022-07-08 15:56:48','',''),(2270,'21','228','4',3,'Sale Id shift 110',0.00,0.00,0.00,1284.45,0.00,'2022-07-08 15:56:48','',''),(2271,'21','228','1',1,'Sale Id shift 110',0.00,0.00,0.00,2250.34,0.00,'2022-07-08 15:56:48','',''),(2272,'21','228','1',1,'Sale Id shift 110',0.00,0.00,0.00,2514.88,0.00,'2022-07-08 15:56:48','',''),(2273,'21','228','1',1,'Sale Id shift 110',0.00,0.00,0.00,0.06,0.00,'2022-07-08 15:56:48','',''),(2274,'21','228','1',1,'Sale Id shift 110',0.00,0.00,0.00,2388.67,0.00,'2022-07-08 15:56:48','',''),(2275,'21','228','1',1,'Sale Id shift 110',0.00,0.00,0.00,1035.50,0.00,'2022-07-08 15:56:48','',''),(2276,'21','228',NULL,1,'Sale Id shift 110',5178666.90,0.00,0.00,0.00,0.00,'2022-07-08 15:56:48','',''),(2277,'21','228',NULL,2,'Sale Id shift 110',6517616.50,0.00,0.00,0.00,0.00,'2022-07-08 15:56:48','',''),(2278,'21','228',NULL,3,'Sale Id shift 110',963337.50,0.00,0.00,0.00,0.00,'2022-07-08 15:56:48','',''),(2279,'21','228',NULL,2,'Reception corrector for bridging 177',0.00,0.00,0.00,34000.00,0.00,'2022-07-08 16:08:38','',''),(2280,'21','228','3',2,'Received from bridging 177',0.00,0.00,34000.00,0.00,0.00,'2022-07-08 16:08:38','',''),(2281,'21','228',NULL,1,'Reception corrector for bridging 182',0.00,0.00,0.00,30000.00,0.00,'2022-07-08 16:08:59','',''),(2282,'21','228','2',1,'Received from bridging 182',0.00,0.00,30000.00,0.00,0.00,'2022-07-08 16:08:59','',''),(2283,'21','228','2',1,'Sale Id shift 111',0.00,0.00,0.00,1967.37,0.00,'2022-07-08 16:13:22','',''),(2284,'21','228','2',1,'Sale Id shift 111',0.00,0.00,0.00,2399.47,0.00,'2022-07-08 16:13:22','',''),(2285,'21','228','2',1,'Sale Id shift 111',0.00,0.00,0.00,2831.64,0.00,'2022-07-08 16:13:22','',''),(2286,'21','228','2',1,'Sale Id shift 111',0.00,0.00,0.00,2174.67,0.00,'2022-07-08 16:13:22','',''),(2287,'21','228','2',1,'Sale Id shift 111',0.00,0.00,0.00,2063.61,0.00,'2022-07-08 16:13:22','',''),(2288,'21','228','2',1,'Sale Id shift 111',0.00,0.00,0.00,2625.36,0.00,'2022-07-08 16:13:22','',''),(2289,'21','228','2',1,'Sale Id shift 111',0.00,0.00,0.00,2629.53,0.00,'2022-07-08 16:13:22','',''),(2290,'21','228','1',1,'Sale Id shift 111',0.00,0.00,0.00,2659.02,0.00,'2022-07-08 16:13:22','',''),(2291,'21','228','2',1,'Sale Id shift 111',0.00,0.00,0.00,3134.60,0.00,'2022-07-08 16:13:22','',''),(2292,'21','228','3',2,'Sale Id shift 111',0.00,0.00,0.00,2107.96,0.00,'2022-07-08 16:13:22','',''),(2293,'21','228','3',2,'Sale Id shift 111',0.00,0.00,0.00,1796.42,0.00,'2022-07-08 16:13:22','',''),(2294,'21','228','4',3,'Sale Id shift 111',0.00,0.00,0.00,2881.09,0.00,'2022-07-08 16:13:22','',''),(2295,'21','228','1',1,'Sale Id shift 111',0.00,0.00,0.00,2596.91,0.00,'2022-07-08 16:13:22','',''),(2296,'21','228','1',1,'Sale Id shift 111',0.00,0.00,0.00,1902.31,0.00,'2022-07-08 16:13:22','',''),(2297,'21','228','1',1,'Sale Id shift 111',0.00,0.00,0.00,1587.73,0.00,'2022-07-08 16:13:22','',''),(2298,'21','228','1',1,'Sale Id shift 111',0.00,0.00,0.00,295.09,0.00,'2022-07-08 16:13:22','',''),(2299,'21','228',NULL,1,'Sale Id shift 111',4763106.15,0.00,0.00,0.00,0.00,'2022-07-08 16:13:22','',''),(2300,'21','228',NULL,2,'Sale Id shift 111',3240635.40,0.00,0.00,0.00,0.00,'2022-07-08 16:13:22','',''),(2301,'21','228',NULL,3,'Sale Id shift 111',2160817.50,0.00,0.00,0.00,0.00,'2022-07-08 16:13:22','',''),(2302,'21','228','2',1,'Sale Id shift 112',0.00,0.00,0.00,2101.14,0.00,'2022-07-08 16:29:34','',''),(2303,'21','228','2',1,'Sale Id shift 112',0.00,0.00,0.00,2555.35,0.00,'2022-07-08 16:29:34','',''),(2304,'21','228','2',1,'Sale Id shift 112',0.00,0.00,0.00,2693.87,0.00,'2022-07-08 16:29:34','',''),(2305,'21','228','2',1,'Sale Id shift 112',0.00,0.00,0.00,2730.22,0.00,'2022-07-08 16:29:34','',''),(2306,'21','228','2',1,'Sale Id shift 112',0.00,0.00,0.00,2094.92,0.00,'2022-07-08 16:29:34','',''),(2307,'21','228','2',1,'Sale Id shift 112',0.00,0.00,0.00,2603.99,0.00,'2022-07-08 16:29:34','',''),(2308,'21','228','2',1,'Sale Id shift 112',0.00,0.00,0.00,3122.87,0.00,'2022-07-08 16:29:34','',''),(2309,'21','228','1',1,'Sale Id shift 112',0.00,0.00,0.00,3667.87,0.00,'2022-07-08 16:29:34','',''),(2310,'21','228','2',1,'Sale Id shift 112',0.00,0.00,0.00,3099.08,0.00,'2022-07-08 16:29:34','',''),(2311,'21','228','3',2,'Sale Id shift 112',0.00,0.00,0.00,1704.32,0.00,'2022-07-08 16:29:34','',''),(2312,'21','228','3',2,'Sale Id shift 112',0.00,0.00,0.00,1513.97,0.00,'2022-07-08 16:29:34','',''),(2313,'21','228','4',3,'Sale Id shift 112',0.00,0.00,0.00,2358.57,0.00,'2022-07-08 16:29:34','',''),(2314,'21','228','1',1,'Sale Id shift 112',0.00,0.00,0.00,3534.75,0.00,'2022-07-08 16:29:34','',''),(2315,'21','228','1',1,'Sale Id shift 112',0.00,0.00,0.00,2897.04,0.00,'2022-07-08 16:29:34','',''),(2316,'21','228','1',1,'Sale Id shift 112',0.00,0.00,0.00,1120.41,0.00,'2022-07-08 16:29:34','',''),(2317,'21','228','1',1,'Sale Id shift 112',0.00,0.00,0.00,1290.36,0.00,'2022-07-08 16:29:34','',''),(2318,'21','228','1',1,'Sale Id shift 112',0.00,0.00,0.00,3443.10,0.00,'2022-07-08 16:29:34','',''),(2319,'21','228',NULL,1,'Sale Id shift 112',6097570.05,0.00,0.00,0.00,0.00,'2022-07-08 16:29:34','',''),(2320,'21','228',NULL,2,'Sale Id shift 112',2671180.70,0.00,0.00,0.00,0.00,'2022-07-08 16:29:34','',''),(2321,'21','228',NULL,3,'Sale Id shift 112',1768927.50,0.00,0.00,0.00,0.00,'2022-07-08 16:29:34','',''),(2322,'21','228','2',1,'Sale Id shift 113',0.00,0.00,0.00,3602.79,0.00,'2022-07-08 16:43:51','',''),(2323,'21','228','2',1,'Sale Id shift 113',0.00,0.00,0.00,4856.43,0.00,'2022-07-08 16:43:51','',''),(2324,'21','228','2',1,'Sale Id shift 113',0.00,0.00,0.00,5670.68,0.00,'2022-07-08 16:43:51','',''),(2325,'21','228','2',1,'Sale Id shift 113',0.00,0.00,0.00,5084.69,0.00,'2022-07-08 16:43:51','',''),(2326,'21','228','2',1,'Sale Id shift 113',0.00,0.00,0.00,4097.74,0.00,'2022-07-08 16:43:51','',''),(2327,'21','228','2',1,'Sale Id shift 113',0.00,0.00,0.00,5046.84,0.00,'2022-07-08 16:43:51','',''),(2328,'21','228','2',1,'Sale Id shift 113',0.00,0.00,0.00,5287.25,0.00,'2022-07-08 16:43:51','',''),(2329,'21','228','1',1,'Sale Id shift 113',0.00,0.00,0.00,4346.41,0.00,'2022-07-08 16:43:51','',''),(2330,'21','228','2',1,'Sale Id shift 113',0.00,0.00,0.00,6252.91,0.00,'2022-07-08 16:43:51','',''),(2331,'21','228','3',2,'Sale Id shift 113',0.00,0.00,0.00,2368.14,0.00,'2022-07-08 16:43:51','',''),(2332,'21','228','3',2,'Sale Id shift 113',0.00,0.00,0.00,1291.85,0.00,'2022-07-08 16:43:51','',''),(2333,'21','228','4',3,'Sale Id shift 113',0.00,0.00,0.00,1138.09,0.00,'2022-07-08 16:43:51','',''),(2334,'21','228','1',1,'Sale Id shift 113',0.00,0.00,0.00,4095.20,0.00,'2022-07-08 16:43:51','',''),(2335,'21','228','1',1,'Sale Id shift 113',0.00,0.00,0.00,873.70,0.00,'2022-07-08 16:43:51','',''),(2336,'21','228','1',1,'Sale Id shift 113',0.00,0.00,0.00,4015.99,0.00,'2022-07-08 16:43:51','',''),(2337,'21','228','1',1,'Sale Id shift 113',0.00,0.00,0.00,966.20,0.00,'2022-07-08 16:43:51','',''),(2338,'21','228','1',1,'Sale Id shift 113',0.00,0.00,0.00,1425.24,0.00,'2022-07-08 16:43:51','',''),(2339,'21','228','1',1,'Sale Id shift 113',0.00,0.00,0.00,3493.51,0.00,'2022-07-08 16:43:51','',''),(2340,'21','228',NULL,1,'Sale Id shift 113',9754070.70,0.00,0.00,0.00,0.00,'2022-07-08 16:43:51','',''),(2341,'21','228',NULL,2,'Sale Id shift 113',3037791.70,0.00,0.00,0.00,0.00,'2022-07-08 16:43:51','',''),(2342,'21','228',NULL,3,'Sale Id shift 113',853567.50,0.00,0.00,0.00,0.00,'2022-07-08 16:43:51','',''),(2343,'21','228','2',1,'Sale Id shift 114',0.00,0.00,0.00,705.12,0.00,'2022-07-09 14:26:20','',''),(2344,'21','228','2',1,'Sale Id shift 114',0.00,0.00,0.00,609.03,0.00,'2022-07-09 14:26:20','',''),(2345,'21','228','2',1,'Sale Id shift 114',0.00,0.00,0.00,1451.03,0.00,'2022-07-09 14:26:20','',''),(2346,'21','228','2',1,'Sale Id shift 114',0.00,0.00,0.00,1278.46,0.00,'2022-07-09 14:26:20','',''),(2347,'21','228','2',1,'Sale Id shift 114',0.00,0.00,0.00,801.49,0.00,'2022-07-09 14:26:20','',''),(2348,'21','228','2',1,'Sale Id shift 114',0.00,0.00,0.00,1106.66,0.00,'2022-07-09 14:26:20','',''),(2349,'21','228','2',1,'Sale Id shift 114',0.00,0.00,0.00,1262.17,0.00,'2022-07-09 14:26:20','',''),(2350,'21','228','1',1,'Sale Id shift 114',0.00,0.00,0.00,1408.79,0.00,'2022-07-09 14:26:20','',''),(2351,'21','228','2',1,'Sale Id shift 114',0.00,0.00,0.00,1130.35,0.00,'2022-07-09 14:26:20','',''),(2352,'21','228','3',2,'Sale Id shift 114',0.00,0.00,0.00,651.35,0.00,'2022-07-09 14:26:20','',''),(2353,'21','228','3',2,'Sale Id shift 114',0.00,0.00,0.00,2010.28,0.00,'2022-07-09 14:26:20','',''),(2354,'21','228','4',3,'Sale Id shift 114',0.00,0.00,0.00,2431.52,0.00,'2022-07-09 14:26:20','',''),(2355,'21','228','1',1,'Sale Id shift 114',0.00,0.00,0.00,1196.95,0.00,'2022-07-09 14:26:20','',''),(2356,'21','228','1',1,'Sale Id shift 114',0.00,0.00,0.00,1084.87,0.00,'2022-07-09 14:26:20','',''),(2357,'21','228','1',1,'Sale Id shift 114',0.00,0.00,0.00,1339.75,0.00,'2022-07-09 14:26:20','',''),(2358,'21','228',NULL,1,'Sale Id shift 114',2206820.55,0.00,0.00,0.00,0.00,'2022-07-09 14:26:20','',''),(2359,'21','228',NULL,2,'Sale Id shift 114',2209152.90,0.00,0.00,0.00,0.00,'2022-07-09 14:26:20','',''),(2360,'21','228',NULL,3,'Sale Id shift 114',1823640.00,0.0