-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_227
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_227`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_227` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_227`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','21','227','PURCHASES','','2022-03-03 16:34:49',5,0.00,0.00,'','764','2022-03-03 16:34:49','764',0,0),(2,7000,'',0,'20','21','227','SALES','','2022-03-03 16:35:15',5,0.00,0.00,'','764','2022-03-03 16:35:15','764',0,0),(3,500,'',0,'6.1','21','227','CASH','','2022-03-03 16:35:36',5,0.00,0.00,'','764','2022-03-03 16:35:36','764',0,0),(4,8000,'',0,'24','21','227','SALARY & WAGES','','2022-03-03 16:35:54',5,0.00,0.00,'','764','2022-03-03 16:35:54','764',0,0),(5,8001,'',0,'24','21','227','PURCHASES','','2022-03-03 16:36:14',5,0.00,0.00,'','764','2022-03-03 16:36:14','764',0,0),(6,2500,'',0,'2','21','227','ZENITH BANK','','2022-03-23 14:08:10',5,0.00,0.00,'','764','2022-03-23 14:08:10','764',0,0),(7,2501,'',0,'2','21','227','zenith Bank pos','','2022-03-23 14:08:21',5,0.00,0.00,'','764','2022-03-23 14:08:21','764',0,0),(8,2502,'',0,'2','21','227','ZENITH BANK TRANSFER ACC','','2022-03-23 14:08:32',5,0.00,0.00,'','764','2022-03-23 14:08:32','764',0,0),(9,2503,'',0,'2','21','227','FIRST BANK','','2022-03-23 14:08:45',5,0.00,0.00,'','764','2022-03-23 14:08:45','764',0,0),(10,2504,'',0,'2','21','227','FIRST BANK TRANSFER ACCOUNT','','2022-03-23 14:08:56',5,0.00,0.00,'','764','2022-03-23 14:08:56','764',0,0),(11,2505,'',0,'2','21','227','FIRST BANK POS','','2022-03-23 14:09:06',5,0.00,0.00,'','764','2022-03-23 14:09:06','764',0,0),(12,2506,'',0,'2','21','227','UBA BANK','','2022-03-23 14:09:21',5,0.00,0.00,'','764','2022-03-23 14:09:21','764',0,0),(13,2507,'',0,'2','21','227','UBA TRANSFER ACC','','2022-03-23 14:09:35',5,0.00,0.00,'','764','2022-03-23 14:09:35','764',0,0),(14,2508,'',0,'2','21','227','UBA POS','','2022-03-23 14:09:47',5,0.00,0.00,'','764','2022-03-23 14:09:47','764',0,0),(15,2509,'',0,'2','21','227','IBTC POS','','2022-03-23 14:09:59',5,0.00,0.00,'','764','2022-03-23 14:09:59','764',0,0),(16,2510,'',0,'2','21','227','IBTC TRANSFER ACCOUNT','','2022-03-23 14:10:11',5,0.00,0.00,'','764','2022-03-23 14:10:11','764',0,0),(17,2511,'',0,'2','21','227','IBTC BANK','','2022-03-23 14:10:20',5,0.00,0.00,'','764','2022-03-23 14:10:20','764',0,0),(18,2512,'',0,'2','21','227','GT BANK POS','','2022-03-23 14:10:42',5,0.00,0.00,'','764','2022-03-23 14:10:42','764',0,0),(19,2513,'',0,'2','21','227','GT BANK TRANSFER ACCOUNT','','2022-03-23 14:10:53',5,0.00,0.00,'','764','2022-03-23 14:10:53','764',0,0),(20,2514,'',0,'2','21','227','GT BANK','','2022-03-23 14:11:06',5,0.00,0.00,'','764','2022-03-23 14:11:06','764',0,0),(21,2515,'',0,'2','21','227','JAIZ BANK','','2022-03-23 14:11:18',5,0.00,0.00,'','764','2022-03-23 14:11:18','764',0,0),(22,2516,'',0,'2','21','227','JAIZ POS','','2022-03-23 14:11:30',5,0.00,0.00,'','764','2022-03-23 14:11:30','764',0,0),(23,2517,'',0,'2','21','227','JAIZ TRANSFER ACCOUNT','','2022-03-23 14:11:40',5,0.00,0.00,'','764','2022-03-23 14:11:40','764',0,0),(24,2518,'',0,'2','21','227','Unity Bank','','2022-03-26 17:45:48',5,0.00,0.00,'','764','2022-03-26 17:45:48','764',0,0),(25,2519,'',0,'2','21','227','Unity Bank POS','','2022-03-26 17:45:56',5,0.00,0.00,'','764','2022-03-26 17:45:56','764',0,0),(26,2520,'',0,'2','21','227','UNITY Bank Transfer account ','','2022-03-26 17:46:05',5,0.00,0.00,'','764','2022-03-26 17:46:05','764',0,0),(27,2521,'',0,'2','21','227','Ecobank POS','','2022-03-26 17:46:14',5,0.00,0.00,'','764','2022-03-26 17:46:14','764',0,0),(28,2522,'',0,'2','21','227','Ecobank ','','2022-03-26 17:46:22',5,0.00,0.00,'','764','2022-03-26 17:46:22','764',0,0),(29,2523,'',0,'2','21','227','Ecobank Transfer account ','','2022-03-26 17:46:30',5,0.00,0.00,'','764','2022-03-26 17:46:30','764',0,0),(30,2524,'',0,'2','21','227','Keystone Bank','','2022-07-19 13:35:32',5,0.00,0.00,'','764','2022-07-19 13:35:32','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','227',1,'1',266.85,1.00,'2022-07-04','','2022-07-04 11:15:02','764','764',2022,'764','2022-07-04 11:15:02',5),('21','227',2,'1',0.25,494.00,'2022-07-15','','2022-07-17 13:20:45','764','764',2022,'764','2022-07-17 13:20:45',5),('21','227',3,'1',227.90,1.00,'2022-07-17','','2022-07-17 16:21:03','764','764',2022,'764','2022-07-17 16:21:03',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','227','1',1,'5','LPG NOZZLE 1A',20016.43,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('21','227','1',2,'5','LPG NOZZLE 1B',15485.52,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('21','227','1',3,'5','LPG NOZZLE 2A',5574.72,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('21','227','1',4,'5','LPG NOZZLE 2B',245.27,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','227',3,'Daily Shift','2022-06-07','2022-06-07 08:34:49','2022-06-08 08:34:49','770',0.00,0.00,'770','2022-06-07 19:23:12','764','2022-06-08 07:01:52',10,0),('21','227',4,'Daily Shift','2022-06-08','2022-06-08 07:11:13','2022-06-09 07:11:13','770',0.00,0.00,'770','2022-06-08 19:09:35','764','2022-06-09 06:07:17',10,0),('21','227',5,'Daily Shift','2022-06-09','2022-06-09 07:58:14','2022-06-10 07:58:14','770',0.00,0.00,'764','2022-06-09 19:27:26','770','2022-06-10 08:18:24',10,0),('21','227',6,'Daily Shift','2022-06-10','2022-06-10 08:19:26','2022-06-11 08:19:26','770',0.00,0.00,'764','2022-06-11 08:36:14','764','2022-06-11 08:37:08',10,0),('21','227',7,'Daily Shift','2022-06-11','2022-06-11 08:43:14','2022-06-12 08:43:14','770',0.00,0.00,'770','2022-06-12 16:30:01','770','2022-06-12 16:30:28',10,0),('21','227',8,'Daily Shift','2022-06-12','2022-06-12 16:30:51','2022-06-13 16:30:51','770',0.00,0.00,'764','2022-06-13 16:37:51','764','2022-06-13 16:39:12',10,0),('21','227',9,'Daily Shift','2022-06-13','2022-06-13 16:40:00','2022-06-14 16:40:00','770',0.00,0.00,'770','2022-06-14 08:27:21','770','2022-06-14 08:27:54',10,0),('21','227',10,'Daily Shift','2022-06-14','2022-06-14 08:28:21','2022-06-15 08:28:21','770',0.00,0.00,'764','2022-06-16 11:30:21','770','2022-06-17 09:28:26',10,0),('21','227',11,'Daily Shift','2022-06-17','2022-06-17 09:37:19','2022-06-18 09:37:19','770',0.00,0.00,'764','2022-06-18 09:19:32','764','2022-06-18 09:20:04',10,0),('21','227',12,'Daily Shift','2022-06-18','2022-06-18 09:20:51','2022-06-19 09:20:51','770',0.00,0.00,'770','2022-06-18 19:20:47','770','2022-06-18 19:21:05',10,0),('21','227',13,'DAILY','2022-06-19','2022-06-19 15:16:38','2022-06-20 15:16:38','770',0.00,0.00,'770','2022-06-19 18:50:21','770','2022-06-19 18:50:56',10,0),('21','227',14,'Daily Shift','2022-06-20','2022-06-20 09:08:30','2022-06-21 09:08:30','770',0.00,0.00,'770','2022-06-20 18:45:58','770','2022-06-20 18:46:11',10,0),('21','227',15,'Daily Shift','2022-06-21','2022-06-21 09:00:04','2022-06-22 09:00:04','770',0.00,0.00,'764','2022-06-22 09:37:44','764','2022-06-22 09:38:38',10,0),('21','227',16,'Daily Shift','2022-06-22','2022-06-22 09:44:17','2022-06-23 09:44:17','770',0.00,0.00,'770','2022-06-23 10:43:22','770','2022-06-23 10:43:41',10,0),('21','227',17,'Daily Shift','2022-06-23','2022-06-23 10:44:30','2022-06-24 10:44:30','770',0.00,0.00,'770','2022-06-24 11:42:25','770','2022-06-24 11:42:52',10,0),('21','227',18,'Daily Shift','2022-06-24','2022-06-24 11:43:15','2022-06-25 11:43:15','770',0.00,0.00,'770','2022-06-25 14:17:04','770','2022-06-25 14:17:27',10,0),('21','227',19,'DAILY','2022-06-25','2022-06-25 14:17:42','2022-06-26 14:17:42','770',0.00,0.00,'770','2022-06-25 14:32:05','770','2022-06-25 14:32:27',10,0),('21','227',20,'DAILY','2022-06-27','2022-06-27 09:39:38','2022-06-28 09:39:38','764',0.00,0.00,'770','2022-06-27 13:45:30','770','2022-06-27 13:45:44',10,0),('21','227',21,'Daily Shift','2022-06-27','2022-06-27 14:45:48','2022-06-28 14:45:48','770',0.00,0.00,'770','2022-06-28 09:06:23','770','2022-06-28 09:12:10',10,0),('21','227',22,'Daily Shift','2022-06-28','2022-06-28 09:12:53','2022-06-29 09:12:53','770',0.00,0.00,'770','2022-06-28 19:40:42','770','2022-06-28 19:41:08',10,0),('21','227',23,'DAILY','2022-06-29','2022-06-29 10:36:44','2022-06-30 10:36:44','770',0.00,0.00,'770','2022-06-30 14:44:32','770','2022-06-30 14:44:53',10,0),('21','227',24,'Daily Shift','2022-06-30','2022-06-30 14:47:27','2022-07-01 14:47:27','770',0.00,0.00,'770','2022-07-01 12:00:56','770','2022-07-01 12:01:17',10,0),('21','227',25,'Daily Shift','2022-07-01','2022-07-01 12:02:02','2022-07-02 12:02:02','770',0.00,0.00,'764','2022-07-02 16:34:09','764','2022-07-02 16:34:34',10,0),('21','227',26,'DAILY','2022-07-03','2022-07-03 14:29:27','2022-07-04 14:29:27','770',0.00,0.00,'770','2022-07-03 14:38:30','770','2022-07-03 14:38:44',10,0),('21','227',27,'DAILY','2022-07-02','2022-07-03 14:39:24','2022-07-04 14:39:24','770',0.00,0.00,'770','2022-07-03 15:03:26','770','2022-07-03 15:03:38',10,0),('21','227',28,'Daily Shift','2022-07-04','2022-07-04 11:17:50','2022-07-05 11:17:50','764',0.00,0.00,'764','2022-07-08 14:51:54','764','2022-07-08 14:52:43',10,0),('21','227',29,'Daily Shift','2022-07-08','2022-07-08 16:28:51','2022-07-09 16:28:51','770',0.00,0.00,'764','2022-07-09 13:37:15','764','2022-07-09 13:37:44',10,0),('21','227',30,'Daily Shift','2022-07-10','2022-07-10 09:07:55','2022-07-11 09:07:55','770',0.00,0.00,'764','2022-07-11 12:30:25','764','2022-07-11 12:30:49',10,0),('21','227',31,'DAILY','2022-07-10','2022-07-11 12:31:25','2022-07-12 12:31:25','764',0.00,0.00,'764','2022-07-11 12:40:59','764','2022-07-11 12:41:58',10,0),('21','227',32,'Daily Shift','2022-07-15','2022-07-15 08:40:34','2022-07-16 08:40:34','770',0.00,0.00,'770','2022-07-15 12:22:17','770','2022-07-15 12:22:45',10,0),('21','227',33,'DAILY','2022-07-05','2022-07-15 13:36:59','2022-07-16 13:36:59','770',0.00,0.00,'770','2022-07-15 13:56:43','770','2022-07-15 13:57:01',10,0),('21','227',34,'DAILY','2022-07-06','2022-07-15 13:57:31','2022-07-16 13:57:31','770',0.00,0.00,'770','2022-07-15 14:03:55','770','2022-07-15 14:04:08',10,0),('21','227',35,'DAILY','2022-07-07','2022-07-15 14:04:27','2022-07-16 14:04:27','770',0.00,0.00,'770','2022-07-15 14:15:25','770','2022-07-15 14:15:51',10,0),('21','227',36,'DAILY','2022-07-10','2022-07-15 14:16:32','2022-07-16 14:16:32','770',0.00,0.00,'770','2022-07-15 14:29:29','770','2022-07-15 14:29:54',10,0),('21','227',37,'DAILY','2022-07-11','2022-07-15 14:30:52','2022-07-16 14:30:52','770',0.00,0.00,'770','2022-07-15 14:38:13','770','2022-07-15 14:38:28',10,0),('21','227',38,'DAILY','2022-07-12','2022-07-15 14:39:53','2022-07-16 14:39:53','770',0.00,0.00,'770','2022-07-15 15:13:32','770','2022-07-15 15:13:42',10,0),('21','227',39,'Daily Shift','2022-07-13','2022-07-15 16:52:52','2022-07-16 16:52:52','770',0.00,0.00,'764','2022-07-16 14:32:43','764','2022-07-16 14:33:46',10,0),('21','227',40,'DAILY','2022-07-14','2022-07-16 14:40:19','2022-07-17 14:40:19','764',0.00,0.00,'764','2022-07-17 09:42:27','764','2022-07-17 09:43:04',10,0),('21','227',41,'DAILY','2022-07-15','2022-07-17 09:44:00','2022-07-18 09:44:00','764',0.00,0.00,'764','2022-07-18 10:56:57','764','2022-07-18 10:57:19',10,0),('21','227',42,'DAILY','2022-07-16','2022-07-18 10:58:41','2022-07-19 10:58:41','764',0.00,0.00,'764','2022-07-19 10:24:30','764','2022-07-19 10:24:56',10,0),('21','227',43,'DAILY','2022-07-17','2022-07-19 10:25:32','2022-07-20 10:25:32','764',0.00,0.00,'764','2022-07-19 11:48:49','764','2022-07-19 11:49:16',10,0),('21','227',44,'DAILY','2022-07-18','2022-07-19 11:49:58','2022-07-20 11:49:58','764',0.00,0.00,'764','2022-07-19 13:31:46','764','2022-07-19 13:32:04',10,0),('21','227',45,'DAILY','2022-07-19','2022-07-19 13:32:41','2022-07-20 13:32:41','764',0.00,0.00,'764','2022-07-20 10:52:01','764','2022-07-20 11:02:41',10,0),('21','227',46,'DAILY','2022-07-20','2022-07-20 11:03:22','2022-07-21 11:03:22','764',0.00,0.00,'764','2022-07-21 08:04:44','764','2022-07-21 08:05:15',10,0),('21','227',47,'Daily Shift','2022-07-21','2022-07-21 08:23:43','2022-07-22 08:23:43','770',0.00,0.00,'764','2022-07-21 20:10:30','764','2022-07-21 20:10:55',10,0),('21','227',48,'Daily Shift','2022-07-22','2022-07-22 15:07:06','2022-07-23 15:07:06','770',0.00,0.00,'764','2022-07-23 08:36:02','764','2022-07-23 08:36:30',10,0),('21','227',49,'Daily Shift','2022-07-23','2022-07-23 10:56:09','2022-07-24 10:56:09','770',0.00,0.00,'764','2022-07-24 07:40:55','764','2022-07-24 07:41:19',10,0),('21','227',50,'Daily Shift','2022-07-24','2022-07-24 10:10:39','2022-07-25 10:10:39','770',0.00,0.00,'770','2022-07-25 16:33:49','770','2022-07-25 16:34:08',10,0),('21','227',51,'Daily Shift','2022-07-25','2022-07-25 16:38:01','2022-07-26 16:38:01','770',0.00,0.00,'764','2022-07-26 07:58:35','764','2022-07-26 07:59:05',10,0),('21','227',52,'Daily Shift','2022-07-26','2022-07-26 08:01:28','2022-07-27 08:01:28','770',0.00,0.00,'764','2022-07-26 18:15:10','764','2022-07-26 18:15:21',10,0),('21','227',53,'Daily Shift','2022-07-27','2022-07-27 07:52:33','2022-07-28 07:52:33','770',0.00,0.00,'764','2022-07-28 05:21:03','764','2022-07-28 05:21:30',10,0),('21','227',54,'Daily Shift','2022-07-28','2022-07-28 09:09:05','2022-07-29 09:09:05','770',0.00,0.00,'764','2022-07-29 05:40:30','764','2022-07-29 05:40:56',10,0),('21','227',55,'Daily Shift','2022-07-29','2022-07-29 08:06:32','2022-07-30 08:06:32','770',0.00,0.00,'764','2022-07-29 18:06:32','764','2022-07-29 18:06:54',10,0),('21','227',56,'Daily Shift','2022-07-30','2022-07-30 10:07:03','2022-07-31 10:07:03','770',0.00,0.00,'764','2022-07-31 08:12:41','764','2022-07-31 08:13:19',10,0),('21','227',57,'Daily Shift','2022-07-31','2022-07-31 08:48:40','2022-08-01 08:48:40','770',0.00,0.00,'764','2022-08-01 00:05:10','764','2022-08-01 00:05:57',10,0),('21','227',58,'Daily Shift','2022-08-01','2022-08-01 09:15:42','2022-08-02 09:15:42','770',0.00,0.00,'770','2022-08-02 09:46:37','770','2022-08-02 09:46:58',10,0),('21','227',59,'Daily Shift','2022-08-02','2022-08-02 09:47:16','2022-08-03 09:47:16','770',0.00,0.00,'764','2022-08-02 17:55:54','764','2022-08-02 17:56:06',10,0),('21','227',60,'Daily Shift','2022-08-05','2022-08-05 15:40:08','2022-08-06 15:40:08','770',0.00,0.00,'770','2022-08-06 10:24:30','770','2022-08-06 10:24:56',10,0),('21','227',61,'Daily Shift','2022-08-06','2022-08-06 10:25:31','2022-08-07 10:25:31','770',0.00,0.00,'770','2022-08-07 11:16:39','770','2022-08-07 11:16:59',10,0),('21','227',62,'Daily Shift','2022-08-07','2022-08-07 11:17:19','2022-08-08 11:17:19','770',0.00,0.00,'770','2022-08-07 18:56:33','770','2022-08-07 18:56:49',10,0),('21','227',63,'Daily Shift','2022-08-08','2022-08-08 09:38:46','2022-08-09 09:38:46','770',0.00,0.00,'764','2022-08-09 05:52:16','764','2022-08-09 05:52:40',10,0),('21','227',64,'Daily Shift','2022-08-09','2022-08-09 10:25:58','2022-08-10 10:25:58','770',0.00,0.00,'764','2022-08-09 19:24:59','764','2022-08-09 19:26:03',10,0),('21','227',65,'DAILY','2022-08-10','2022-08-10 07:28:30','2022-08-11 07:28:30','764',0.00,0.00,'764','2022-08-10 19:30:46','764','2022-08-10 19:31:20',10,0),('21','227',66,'DAILY','2022-08-11','2022-08-11 10:39:55','2022-08-12 10:39:55','764',0.00,0.00,'764','2022-08-12 05:51:48','764','2022-08-12 05:52:22',10,0),('21','227',67,'DAILY','2022-08-12','2022-08-12 07:54:45','2022-08-13 07:54:45','764',0.00,0.00,'764','2022-08-13 04:27:26','764','2022-08-13 04:27:59',10,0),('21','227',68,'Daily Shift','2022-08-13','2022-08-13 09:16:24','2022-08-14 09:16:24','770',0.00,0.00,'770','2022-08-13 14:32:55','770','2022-08-13 14:33:28',10,0),('21','227',69,'Daily Shift','2022-08-15','2022-08-15 09:51:56','2022-08-16 09:51:56','770',0.00,0.00,'764','2022-08-16 05:16:14','764','2022-08-16 05:16:41',10,0),('21','227',70,'Daily Shift','2022-08-16','2022-08-16 10:19:20','2022-08-17 10:19:20','770',0.00,0.00,'764','2022-08-16 18:35:52','764','2022-08-16 19:15:59',10,0),('21','227',71,'Daily Shift','2022-08-17','2022-08-17 07:34:12','2022-08-18 07:34:12','770',0.00,0.00,'764','2022-08-18 07:48:26','764','2022-08-18 07:48:50',10,0),('21','227',72,'Daily Shift','2022-08-18','2022-08-18 08:43:43','2022-08-19 08:43:43','770',0.00,0.00,'764','2022-08-18 18:25:25','764','2022-08-18 18:25:42',10,0),('21','227',73,'Daily Shift','2022-08-19','2022-08-19 10:11:11','2022-08-20 10:11:11','770',0.00,0.00,'764','2022-08-19 23:52:03','764','2022-08-19 23:52:24',10,0),('21','227',74,'Daily Shift','2022-08-20','2022-08-20 08:40:35','2022-08-21 08:40:35','770',0.00,0.00,'770','2022-08-21 14:08:00','770','2022-08-21 14:08:36',10,0),('21','227',75,'DAILY','2022-10-09','2022-10-09 10:16:07','2022-10-10 10:16:07','764',0.00,0.00,'764','2022-10-09 10:42:51','770','2022-10-12 12:29:18',10,0),('21','227',76,'TRAINING','2022-10-12','2022-10-12 12:30:08','2022-10-13 12:30:08','770',0.00,0.00,'770','2022-10-12 13:47:49','770','2022-10-12 14:03:50',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=305 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','227','1','3',9,'1','1',80.00,461.27,0.00,0.00,381.27,289765.20,0.00,0.00,0.00),('21','227','1','3',10,'2','1',0.00,153.92,0.00,0.00,153.92,116979.20,0.00,0.00,0.00),('21','227','1','3',11,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','3',12,'4','1',0.00,1.31,0.00,0.00,1.31,995.60,0.00,0.00,0.00),('21','227','1','4',13,'1','1',461.27,816.26,0.00,0.00,354.99,269792.40,0.00,0.00,0.00),('21','227','1','4',14,'2','1',153.92,320.67,0.00,0.00,166.75,126730.00,0.00,0.00,0.00),('21','227','1','4',15,'3','1',0.00,6.57,0.00,0.00,6.57,4993.20,0.00,0.00,0.00),('21','227','1','4',16,'4','1',1.31,2.31,0.00,0.00,1.00,760.00,0.00,0.00,0.00),('21','227','1','5',17,'1','1',816.26,1053.67,0.00,0.00,237.41,180431.60,0.00,0.00,0.00),('21','227','1','5',18,'2','1',320.67,522.65,0.00,0.00,201.98,153504.80,0.00,0.00,0.00),('21','227','1','5',19,'3','1',6.57,10.51,0.00,0.00,3.94,2994.40,0.00,0.00,0.00),('21','227','1','5',20,'4','1',2.31,2.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','6',21,'1','1',1053.67,1302.12,0.00,0.00,248.45,188822.00,0.00,0.00,0.00),('21','227','1','6',22,'2','1',522.65,935.02,0.00,0.00,412.37,313401.20,0.00,0.00,0.00),('21','227','1','6',23,'3','1',10.51,166.66,0.00,0.00,156.15,118674.00,0.00,0.00,0.00),('21','227','1','6',24,'4','1',2.31,2.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','7',25,'1','1',1302.12,1787.64,0.00,0.00,485.52,368995.20,0.00,0.00,0.00),('21','227','1','7',26,'2','1',935.02,1213.14,0.00,0.00,278.12,211371.20,0.00,0.00,0.00),('21','227','1','7',27,'3','1',166.66,172.97,0.00,0.00,6.31,4795.60,0.00,0.00,0.00),('21','227','1','7',28,'4','1',2.31,2.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','8',29,'1','1',1787.64,1998.51,0.00,0.00,210.87,160261.20,0.00,0.00,0.00),('21','227','1','8',30,'2','1',1213.14,1681.32,0.00,0.00,468.18,355816.80,0.00,0.00,0.00),('21','227','1','8',31,'3','1',172.97,196.06,0.00,0.00,23.09,17548.40,0.00,0.00,0.00),('21','227','1','8',32,'4','1',2.31,2.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','9',33,'1','1',1998.51,2243.11,0.00,0.00,244.60,185896.00,0.00,0.00,0.00),('21','227','1','9',34,'2','1',1681.32,2013.92,0.00,0.00,332.60,252776.00,0.00,0.00,0.00),('21','227','1','9',35,'3','1',196.06,228.57,0.00,0.00,32.51,24707.60,0.00,0.00,0.00),('21','227','1','9',36,'4','1',2.31,2.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','10',37,'1','1',2243.11,2347.40,0.00,0.00,104.29,79260.40,0.00,0.00,0.00),('21','227','1','10',38,'2','1',2013.92,2257.64,0.00,0.00,243.72,185227.20,0.00,0.00,0.00),('21','227','1','10',39,'3','1',228.57,296.90,0.00,0.00,68.33,51930.80,0.00,0.00,0.00),('21','227','1','10',40,'4','1',2.31,2.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','11',41,'1','1',2347.40,2528.14,0.00,0.00,180.74,137362.40,0.00,0.00,0.00),('21','227','1','11',42,'2','1',2257.64,2592.69,0.00,0.00,335.05,254638.00,0.00,0.00,0.00),('21','227','1','11',43,'3','1',296.90,321.59,0.00,0.00,24.69,18764.40,0.00,0.00,0.00),('21','227','1','11',44,'4','1',2.31,2.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','12',45,'1','1',2528.14,2826.46,0.00,0.00,298.32,226723.20,0.00,0.00,0.00),('21','227','1','12',46,'2','1',2592.69,2796.44,0.00,0.00,203.75,154850.00,0.00,0.00,0.00),('21','227','1','12',47,'3','1',321.59,325.53,0.00,0.00,3.94,2994.40,0.00,0.00,0.00),('21','227','1','12',48,'4','1',2.31,2.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','13',49,'1','1',2826.46,2921.13,0.00,0.00,94.67,71949.20,0.00,0.00,0.00),('21','227','1','13',50,'2','1',2796.44,3156.40,0.00,0.00,359.96,273569.60,0.00,0.00,0.00),('21','227','1','13',51,'3','1',325.53,381.46,0.00,0.00,55.93,42506.80,0.00,0.00,0.00),('21','227','1','13',52,'4','1',2.31,3.62,0.00,0.00,1.31,995.60,0.00,0.00,0.00),('21','227','1','14',53,'1','1',2921.13,3349.30,0.00,0.00,428.17,325409.20,0.00,0.00,0.00),('21','227','1','14',54,'2','1',3156.40,3370.24,0.00,0.00,213.84,162518.40,0.00,0.00,0.00),('21','227','1','14',55,'3','1',381.46,381.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','14',56,'4','1',3.62,3.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','15',57,'1','1',3349.30,3423.07,0.00,0.00,73.77,56065.20,0.00,0.00,0.00),('21','227','1','15',58,'2','1',3370.24,3758.64,0.00,0.00,388.40,295184.00,0.00,0.00,0.00),('21','227','1','15',59,'3','1',381.46,489.05,0.00,0.00,107.59,81768.40,0.00,0.00,0.00),('21','227','1','15',60,'4','1',3.62,12.58,0.00,0.00,8.96,6809.60,0.00,0.00,0.00),('21','227','1','16',61,'1','1',3423.07,3674.29,0.00,0.00,251.22,190927.20,0.00,0.00,0.00),('21','227','1','16',62,'2','1',3758.64,4083.86,0.00,0.00,325.22,247167.20,0.00,0.00,0.00),('21','227','1','16',63,'3','1',489.05,494.65,0.00,0.00,5.60,4256.00,0.00,0.00,0.00),('21','227','1','16',64,'4','1',12.58,12.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','17',65,'1','1',3674.29,3891.48,0.00,0.00,217.19,165064.40,0.00,0.00,0.00),('21','227','1','17',66,'2','1',4083.86,4339.38,0.00,0.00,255.52,194195.20,0.00,0.00,0.00),('21','227','1','17',67,'3','1',494.65,572.92,0.00,0.00,78.27,59485.20,0.00,0.00,0.00),('21','227','1','17',68,'4','1',12.58,19.52,0.00,0.00,6.94,5274.40,0.00,0.00,0.00),('21','227','1','18',69,'1','1',3891.48,4019.07,0.00,0.00,127.59,96968.40,0.00,0.00,0.00),('21','227','1','18',70,'2','1',4339.38,4874.85,0.00,0.00,535.47,406957.20,0.00,0.00,0.00),('21','227','1','18',71,'3','1',572.92,643.03,0.00,0.00,70.11,53283.60,0.00,0.00,0.00),('21','227','1','18',72,'4','1',19.52,60.96,0.00,0.00,41.44,31494.40,0.00,0.00,0.00),('21','227','1','19',73,'1','1',4019.07,4019.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','19',74,'2','1',4874.85,4982.20,0.00,0.00,107.35,81586.00,0.00,0.00,0.00),('21','227','1','19',75,'3','1',643.03,729.98,0.00,0.00,86.95,66082.00,0.00,0.00,0.00),('21','227','1','19',76,'4','1',60.96,60.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','20',77,'1','1',4019.07,4059.85,0.00,0.00,40.78,30992.80,0.00,0.00,0.00),('21','227','1','20',78,'2','1',4982.20,5176.04,0.00,0.00,193.84,147318.40,0.00,0.00,0.00),('21','227','1','20',79,'3','1',729.98,1057.54,0.00,0.00,327.56,248945.60,0.00,0.00,0.00),('21','227','1','20',80,'4','1',60.96,78.72,0.00,0.00,17.76,13497.60,0.00,0.00,0.00),('21','227','1','21',81,'1','1',4059.85,4445.31,0.00,0.00,385.46,292949.60,0.00,0.00,0.00),('21','227','1','21',82,'2','1',5176.04,5428.64,0.00,0.00,252.60,191976.00,0.00,0.00,0.00),('21','227','1','21',83,'3','1',1057.54,1067.47,0.00,0.00,9.93,7546.80,0.00,0.00,0.00),('21','227','1','21',84,'4','1',78.72,78.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','22',85,'1','1',4445.31,4835.13,0.00,0.00,389.82,296263.20,0.00,0.00,0.00),('21','227','1','22',86,'2','1',5428.64,5587.47,0.00,0.00,158.83,120710.80,0.00,0.00,0.00),('21','227','1','22',87,'3','1',1067.47,1120.67,0.00,0.00,53.20,40432.00,0.00,0.00,0.00),('21','227','1','22',88,'4','1',78.72,84.72,0.00,0.00,6.00,4560.00,0.00,0.00,0.00),('21','227','1','23',89,'1','1',4835.13,5090.91,0.00,0.00,255.78,194392.80,0.00,0.00,0.00),('21','227','1','23',90,'2','1',5587.47,5771.25,0.00,0.00,183.78,139672.80,0.00,0.00,0.00),('21','227','1','23',91,'3','1',1120.67,1125.30,0.00,0.00,4.63,3518.80,0.00,0.00,0.00),('21','227','1','23',92,'4','1',84.72,84.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','24',93,'1','1',5090.91,5306.43,0.00,0.00,215.52,163795.20,0.00,0.00,0.00),('21','227','1','24',94,'2','1',5771.25,6169.59,0.00,0.00,398.34,302738.40,0.00,0.00,0.00),('21','227','1','24',95,'3','1',1125.30,1289.82,0.00,0.00,164.52,125035.20,0.00,0.00,0.00),('21','227','1','24',96,'4','1',84.72,90.72,0.00,0.00,6.00,4560.00,0.00,0.00,0.00),('21','227','1','25',97,'1','1',5306.43,5747.95,0.00,0.00,441.52,335555.20,0.00,0.00,0.00),('21','227','1','25',98,'2','1',6169.59,6484.23,0.00,0.00,314.64,239126.40,0.00,0.00,0.00),('21','227','1','25',99,'3','1',1289.82,1346.26,0.00,0.00,56.44,42894.40,0.00,0.00,0.00),('21','227','1','25',100,'4','1',90.72,90.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','26',101,'1','1',5747.95,5747.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','26',102,'2','1',6484.23,6525.70,0.00,0.00,41.47,31517.20,0.00,0.00,0.00),('21','227','1','26',103,'3','1',1346.26,1538.34,0.00,0.00,192.08,145980.80,0.00,0.00,0.00),('21','227','1','26',104,'4','1',90.72,99.26,0.00,0.00,8.54,6490.40,0.00,0.00,0.00),('21','227','1','27',105,'1','1',5747.95,5750.95,0.00,0.00,3.00,2280.00,0.00,0.00,0.00),('21','227','1','27',106,'2','1',6525.70,7031.69,0.00,0.00,505.99,384552.40,0.00,0.00,0.00),('21','227','1','27',107,'3','1',1538.34,1918.75,0.00,0.00,380.41,289111.60,0.00,0.00,0.00),('21','227','1','27',108,'4','1',99.26,111.76,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('21','227','1','28',109,'1','1',5750.95,5994.19,0.00,0.00,243.24,184862.40,0.00,0.00,0.00),('21','227','1','28',110,'2','1',7031.69,7333.89,0.00,0.00,302.20,229672.00,0.00,0.00,0.00),('21','227','1','28',111,'3','1',1918.75,2028.77,0.00,0.00,110.02,83615.20,0.00,0.00,0.00),('21','227','1','28',112,'4','1',111.76,116.35,0.00,0.00,4.59,3488.40,0.00,0.00,0.00),('21','227','1','29',113,'1','1',5994.19,6230.41,0.00,0.00,236.22,179527.20,0.00,0.00,0.00),('21','227','1','29',114,'2','1',7333.89,7438.28,0.00,0.00,104.39,79336.40,0.00,0.00,0.00),('21','227','1','29',115,'3','1',2028.77,2028.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','29',116,'4','1',116.35,116.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','30',117,'1','1',6230.41,6342.32,0.00,0.00,111.91,85051.60,0.00,0.00,0.00),('21','227','1','30',118,'2','1',7438.28,7543.47,0.00,0.00,105.19,79944.40,0.00,0.00,0.00),('21','227','1','30',119,'3','1',2028.77,2028.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','30',120,'4','1',116.35,116.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','31',121,'1','1',6342.32,6342.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','31',122,'2','1',7543.47,7726.48,0.00,0.00,183.01,139087.60,0.00,0.00,0.00),('21','227','1','31',123,'3','1',2028.77,2118.77,0.00,0.00,90.00,68400.00,0.00,0.00,0.00),('21','227','1','31',124,'4','1',116.35,146.99,0.00,0.00,30.64,23286.40,0.00,0.00,0.00),('21','227','1','32',125,'1','1',6342.32,6342.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','32',126,'2','1',7726.48,7726.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','32',127,'3','1',2118.77,2118.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','32',128,'4','1',146.99,146.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','33',129,'1','1',6342.32,6391.67,0.00,0.00,49.35,37506.00,0.00,0.00,0.00),('21','227','1','33',130,'2','1',7726.48,8215.74,0.00,0.00,489.26,371837.60,0.00,0.00,0.00),('21','227','1','33',131,'3','1',2118.77,2256.57,0.00,0.00,137.80,104728.00,0.00,0.00,0.00),('21','227','1','33',132,'4','1',146.99,159.49,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('21','227','1','34',133,'1','1',6391.67,6391.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','34',134,'2','1',8215.74,8365.59,0.00,0.00,149.85,113886.00,0.00,0.00,0.00),('21','227','1','34',135,'3','1',2256.57,2307.95,0.00,0.00,51.38,39048.80,0.00,0.00,0.00),('21','227','1','34',136,'4','1',159.49,184.49,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('21','227','1','35',137,'1','1',6391.67,6391.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','35',138,'2','1',8365.59,8450.59,0.00,0.00,85.00,64600.00,0.00,0.00,0.00),('21','227','1','35',139,'3','1',2307.95,2454.83,0.00,0.00,146.88,111628.80,0.00,0.00,0.00),('21','227','1','35',140,'4','1',184.49,186.02,0.00,0.00,1.53,1162.80,0.00,0.00,0.00),('21','227','1','36',141,'1','1',6391.67,6404.17,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('21','227','1','36',142,'2','1',8450.59,8807.22,0.00,0.00,356.63,271038.80,0.00,0.00,0.00),('21','227','1','36',143,'3','1',2454.83,2606.31,0.00,0.00,151.48,115124.80,0.00,0.00,0.00),('21','227','1','36',144,'4','1',186.02,186.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','37',145,'1','1',6404.17,6424.17,0.00,0.00,20.00,15200.00,0.00,0.00,0.00),('21','227','1','37',146,'2','1',8807.22,8978.63,0.00,0.00,171.41,130271.60,0.00,0.00,0.00),('21','227','1','37',147,'3','1',2606.31,2683.82,0.00,0.00,77.51,58907.60,0.00,0.00,0.00),('21','227','1','37',148,'4','1',186.02,192.02,0.00,0.00,6.00,4560.00,0.00,0.00,0.00),('21','227','1','38',149,'1','1',6424.17,6429.17,0.00,0.00,5.00,3800.00,0.00,0.00,0.00),('21','227','1','38',150,'2','1',8978.63,9056.82,0.00,0.00,78.19,59424.40,0.00,0.00,0.00),('21','227','1','38',151,'3','1',2683.82,2740.76,0.00,0.00,56.94,43274.40,0.00,0.00,0.00),('21','227','1','38',152,'4','1',192.02,209.78,0.00,0.00,17.76,13497.60,0.00,0.00,0.00),('21','227','1','39',153,'1','1',6429.17,7037.08,0.00,0.00,607.91,462011.60,0.00,0.00,0.00),('21','227','1','39',154,'2','1',9056.82,9151.47,0.00,0.00,94.65,71934.00,0.00,0.00,0.00),('21','227','1','39',155,'3','1',2740.76,2740.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','39',156,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','40',157,'1','1',7037.08,7486.64,0.00,0.00,449.56,341665.60,0.00,0.00,0.00),('21','227','1','40',158,'2','1',9151.47,9269.16,0.00,0.00,117.69,89444.40,0.00,0.00,0.00),('21','227','1','40',159,'3','1',2740.76,2740.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','40',160,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','41',161,'1','1',7486.64,7742.83,0.00,0.00,256.19,194704.40,0.00,0.00,0.00),('21','227','1','41',162,'2','1',9269.16,9466.78,0.00,0.00,197.62,150191.20,0.00,0.00,0.00),('21','227','1','41',163,'3','1',2740.76,2740.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','41',164,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','42',165,'1','1',7742.83,8300.05,0.00,0.00,557.22,423487.20,0.00,0.00,0.00),('21','227','1','42',166,'2','1',9466.78,9681.43,0.00,0.00,214.65,163134.00,0.00,0.00,0.00),('21','227','1','42',167,'3','1',2740.76,2740.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','42',168,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','43',169,'1','1',8300.05,8756.08,0.00,0.00,456.03,346582.80,0.00,0.00,0.00),('21','227','1','43',170,'2','1',9681.43,9764.72,0.00,0.00,83.29,63300.40,0.00,0.00,0.00),('21','227','1','43',171,'3','1',2740.76,2740.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','43',172,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','44',173,'1','1',8756.08,9098.66,0.00,0.00,342.58,260360.80,0.00,0.00,0.00),('21','227','1','44',174,'2','1',9764.72,10019.49,0.00,0.00,254.77,193625.20,0.00,0.00,0.00),('21','227','1','44',175,'3','1',2740.76,2740.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','44',176,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','45',177,'1','1',9098.66,9542.04,0.00,0.00,443.38,336968.80,0.00,0.00,0.00),('21','227','1','45',178,'2','1',10019.49,10215.27,0.00,0.00,195.78,148792.80,0.00,0.00,0.00),('21','227','1','45',179,'3','1',2740.76,2740.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','45',180,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','46',181,'1','1',9542.04,9972.44,0.00,0.00,430.40,327104.00,0.00,0.00,0.00),('21','227','1','46',182,'2','1',10215.27,10332.07,0.00,0.00,116.80,88768.00,0.00,0.00,0.00),('21','227','1','46',183,'3','1',2740.76,2740.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','46',184,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','47',185,'1','1',9972.44,10263.83,0.00,0.00,291.39,221456.40,0.00,0.00,0.00),('21','227','1','47',186,'2','1',10332.07,10508.76,0.00,0.00,176.69,134284.40,0.00,0.00,0.00),('21','227','1','47',187,'3','1',2740.76,2747.07,0.00,0.00,6.31,4795.60,0.00,0.00,0.00),('21','227','1','47',188,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','48',189,'1','1',10263.83,10483.76,0.00,0.00,219.93,167146.80,0.00,0.00,0.00),('21','227','1','48',190,'2','1',10508.76,10603.19,0.00,0.00,94.43,71766.80,0.00,0.00,0.00),('21','227','1','48',191,'3','1',2747.07,2747.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','48',192,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','49',193,'1','1',10483.76,10867.86,0.00,0.00,384.10,291916.00,0.00,0.00,0.00),('21','227','1','49',194,'2','1',10603.19,10727.52,0.00,0.00,124.33,94490.80,0.00,0.00,0.00),('21','227','1','49',195,'3','1',2747.07,2761.61,0.00,0.00,14.54,11050.40,0.00,0.00,0.00),('21','227','1','49',196,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','50',197,'1','1',10867.86,11202.65,0.00,0.00,334.79,254440.40,0.00,0.00,0.00),('21','227','1','50',198,'2','1',10727.52,10817.81,0.00,0.00,90.29,68620.40,0.00,0.00,0.00),('21','227','1','50',199,'3','1',2761.61,2767.26,0.00,0.00,5.65,4294.00,0.00,0.00,0.00),('21','227','1','50',200,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','51',201,'1','1',11202.65,11284.84,0.00,0.00,82.19,62464.40,0.00,0.00,0.00),('21','227','1','51',202,'2','1',10817.81,10864.33,0.00,0.00,46.52,35355.20,0.00,0.00,0.00),('21','227','1','51',203,'3','1',2767.26,2767.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','51',204,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','52',205,'1','1',11284.84,11667.66,0.00,0.00,382.82,290943.20,0.00,0.00,0.00),('21','227','1','52',206,'2','1',10864.33,11106.97,0.00,0.00,242.64,184406.40,0.00,0.00,0.00),('21','227','1','52',207,'3','1',2767.26,2767.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','52',208,'4','1',209.78,209.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','53',209,'1','1',11667.66,11962.79,0.00,0.00,295.13,224298.80,0.00,0.00,0.00),('21','227','1','53',210,'2','1',11106.97,11283.15,0.00,0.00,176.18,133896.80,0.00,0.00,0.00),('21','227','1','53',211,'3','1',2767.26,2779.44,0.00,0.00,12.18,9256.80,0.00,0.00,0.00),('21','227','1','53',212,'4','1',209.78,213.72,0.00,0.00,3.94,2994.40,0.00,0.00,0.00),('21','227','1','54',213,'1','1',11962.79,12390.31,0.00,0.00,427.52,324915.20,0.00,0.00,0.00),('21','227','1','54',214,'2','1',11283.15,11415.52,0.00,0.00,132.37,100601.20,0.00,0.00,0.00),('21','227','1','54',215,'3','1',2779.44,2792.83,0.00,0.00,13.39,10176.40,0.00,0.00,0.00),('21','227','1','54',216,'4','1',213.72,213.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','55',217,'1','1',12390.31,12820.20,0.00,0.00,429.89,326716.40,0.00,0.00,0.00),('21','227','1','55',218,'2','1',11415.52,11502.80,0.00,0.00,87.28,66332.80,0.00,0.00,0.00),('21','227','1','55',219,'3','1',2792.83,2799.13,0.00,0.00,6.30,4788.00,0.00,0.00,0.00),('21','227','1','55',220,'4','1',213.72,213.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','56',221,'1','1',12820.20,13469.41,0.00,0.00,649.21,493399.60,0.00,0.00,0.00),('21','227','1','56',222,'2','1',11502.80,11536.48,0.00,0.00,33.68,25596.80,0.00,0.00,0.00),('21','227','1','56',223,'3','1',2799.13,2799.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','56',224,'4','1',213.72,213.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','57',225,'1','1',13469.41,14192.97,0.00,0.00,723.56,549905.60,0.00,0.00,0.00),('21','227','1','57',226,'2','1',11536.48,11702.83,0.00,0.00,166.35,126426.00,0.00,0.00,0.00),('21','227','1','57',227,'3','1',2799.13,2805.18,0.00,0.00,6.05,4598.00,0.00,0.00,0.00),('21','227','1','57',228,'4','1',213.72,213.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','58',229,'1','1',14192.97,14433.47,0.00,0.00,240.50,182780.00,0.00,0.00,0.00),('21','227','1','58',230,'2','1',11702.83,12214.26,0.00,0.00,511.43,388686.80,0.00,0.00,0.00),('21','227','1','58',231,'3','1',2805.18,2967.78,0.00,0.00,162.60,123576.00,0.00,0.00,0.00),('21','227','1','58',232,'4','1',213.72,223.45,0.00,0.00,9.73,7394.80,0.00,0.00,0.00),('21','227','1','59',233,'1','1',14433.47,14596.60,0.00,0.00,163.13,123978.80,0.00,0.00,0.00),('21','227','1','59',234,'2','1',12214.26,12239.26,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('21','227','1','59',235,'3','1',2967.78,2967.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','59',236,'4','1',223.45,223.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','60',237,'1','1',14596.60,14656.43,0.00,0.00,59.83,45470.80,0.00,0.00,0.00),('21','227','1','60',238,'2','1',12239.26,12367.86,0.00,0.00,128.60,97736.00,0.00,0.00,0.00),('21','227','1','60',239,'3','1',2967.78,2994.56,0.00,0.00,26.78,20352.80,0.00,0.00,0.00),('21','227','1','60',240,'4','1',223.45,223.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','61',241,'1','1',14656.43,15074.03,0.00,0.00,417.60,317376.00,0.00,0.00,0.00),('21','227','1','61',242,'2','1',12367.86,12599.85,0.00,0.00,231.99,176312.40,0.00,0.00,0.00),('21','227','1','61',243,'3','1',2994.56,3021.63,0.00,0.00,27.07,20573.20,0.00,0.00,0.00),('21','227','1','61',244,'4','1',223.45,225.42,0.00,0.00,1.97,1497.20,0.00,0.00,0.00),('21','227','1','62',245,'1','1',15074.03,15466.51,0.00,0.00,392.48,298284.80,0.00,0.00,0.00),('21','227','1','62',246,'2','1',12599.85,12842.45,0.00,0.00,242.60,184376.00,0.00,0.00,0.00),('21','227','1','62',247,'3','1',3021.63,3045.10,0.00,0.00,23.47,17837.20,0.00,0.00,0.00),('21','227','1','62',248,'4','1',225.42,226.73,0.00,0.00,1.31,995.60,0.00,0.00,0.00),('21','227','1','63',249,'1','1',15466.51,15780.62,0.00,0.00,314.11,238723.60,0.00,0.00,0.00),('21','227','1','63',250,'2','1',12842.45,13003.26,0.00,0.00,160.81,122215.60,0.00,0.00,0.00),('21','227','1','63',251,'3','1',3045.10,3117.36,0.00,0.00,72.26,54917.60,0.00,0.00,0.00),('21','227','1','63',252,'4','1',226.73,226.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','64',253,'1','1',15780.62,16203.35,0.00,0.00,422.73,321274.80,0.00,0.00,0.00),('21','227','1','64',254,'2','1',13003.26,13210.28,0.00,0.00,207.02,157335.20,0.00,0.00,0.00),('21','227','1','64',255,'3','1',3117.36,3153.35,0.00,0.00,35.99,27352.40,0.00,0.00,0.00),('21','227','1','64',256,'4','1',226.73,226.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','65',257,'1','1',16203.35,16793.52,0.00,0.00,590.17,448529.20,0.00,0.00,0.00),('21','227','1','65',258,'2','1',13210.28,13377.03,0.00,0.00,166.75,126730.00,0.00,0.00,0.00),('21','227','1','65',259,'3','1',3153.35,3161.98,0.00,0.00,8.63,6558.80,0.00,0.00,0.00),('21','227','1','65',260,'4','1',226.73,226.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','66',261,'1','1',16793.52,17155.58,0.00,0.00,362.06,275165.60,0.00,0.00,0.00),('21','227','1','66',262,'2','1',13377.03,13507.31,0.00,0.00,130.28,99012.80,0.00,0.00,0.00),('21','227','1','66',263,'3','1',3161.98,3184.03,0.00,0.00,22.05,16758.00,0.00,0.00,0.00),('21','227','1','66',264,'4','1',226.73,227.78,0.00,0.00,1.05,798.00,0.00,0.00,0.00),('21','227','1','67',265,'1','1',17155.58,17402.60,0.00,0.00,247.02,187735.20,0.00,0.00,0.00),('21','227','1','67',266,'2','1',13507.31,13788.19,0.00,0.00,280.88,213468.80,0.00,0.00,0.00),('21','227','1','67',267,'3','1',3184.03,3250.69,0.00,0.00,66.66,50661.60,0.00,0.00,0.00),('21','227','1','67',268,'4','1',227.78,233.70,0.00,0.00,5.92,4499.20,0.00,0.00,0.00),('21','227','1','68',269,'1','1',17402.60,17677.62,0.00,0.00,275.02,209015.20,0.00,0.00,0.00),('21','227','1','68',270,'2','1',13788.19,13829.63,0.00,0.00,41.44,31494.40,0.00,0.00,0.00),('21','227','1','68',271,'3','1',3250.69,3250.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','68',272,'4','1',233.70,233.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','69',273,'1','1',17677.62,18385.99,0.00,0.00,708.37,538361.20,0.00,0.00,0.00),('21','227','1','69',274,'2','1',13829.63,13924.37,0.00,0.00,94.74,72002.40,0.00,0.00,0.00),('21','227','1','69',275,'3','1',3250.69,3250.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','69',276,'4','1',233.70,233.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','70',277,'1','1',18385.99,18796.51,0.00,0.00,410.52,311995.20,0.00,0.00,0.00),('21','227','1','70',278,'2','1',13924.37,14042.07,0.00,0.00,117.70,89452.00,0.00,0.00,0.00),('21','227','1','70',279,'3','1',3250.69,3263.04,0.00,0.00,12.35,9386.00,0.00,0.00,0.00),('21','227','1','70',280,'4','1',233.70,233.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','71',281,'1','1',18796.51,19293.63,0.00,0.00,497.12,377811.20,0.00,0.00,0.00),('21','227','1','71',282,'2','1',14042.07,14125.34,0.00,0.00,83.27,63285.20,0.00,0.00,0.00),('21','227','1','71',283,'3','1',3263.04,3272.04,0.00,0.00,9.00,6840.00,0.00,0.00,0.00),('21','227','1','71',284,'4','1',233.70,233.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','72',285,'1','1',19293.63,19698.49,0.00,0.00,404.86,307693.60,0.00,0.00,0.00),('21','227','1','72',286,'2','1',14125.34,14322.94,0.00,0.00,197.60,150176.00,0.00,0.00,0.00),('21','227','1','72',287,'3','1',3272.04,3341.03,0.00,0.00,68.99,52432.40,0.00,0.00,0.00),('21','227','1','72',288,'4','1',233.70,240.27,0.00,0.00,6.57,4993.20,0.00,0.00,0.00),('21','227','1','73',289,'1','1',19698.49,19996.96,0.00,0.00,298.47,226837.20,0.00,0.00,0.00),('21','227','1','73',290,'2','1',14322.94,14572.49,0.00,0.00,249.55,189658.00,0.00,0.00,0.00),('21','227','1','73',291,'3','1',3341.03,4799.93,0.00,0.00,1458.90,1108764.00,0.00,0.00,0.00),('21','227','1','73',292,'4','1',240.27,240.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','74',293,'1','1',19996.96,19996.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','74',294,'2','1',14572.49,14572.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','74',295,'3','1',4799.93,4799.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','74',296,'4','1',240.27,240.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','227','1','75',297,'1','1',19996.96,20001.96,0.00,0.00,5.00,3800.00,0.00,0.00,0.00),('21','227','1','75',298,'2','1',14572.49,14582.49,0.00,0.00,10.00,7600.00,0.00,0.00,0.00),('21','227','1','75',299,'3','1',4799.93,4824.93,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('21','227','1','75',300,'4','1',240.27,245.27,0.00,0.00,5.00,3800.00,0.00,0.00,0.00),('21','227','1','76',301,'1','1',20001.96,20016.43,0.00,0.00,14.47,10997.20,0.00,0.00,0.00),('21','227','1','76',302,'2','1',14582.49,15485.52,0.00,0.00,903.03,686299.00,0.00,0.00,0.00),('21','227','1','76',303,'3','1',4824.93,5574.72,0.00,0.00,749.79,569841.16,0.00,0.00,0.00),('21','227','1','76',304,'4','1',245.27,245.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','227','3','1',760.00,760.00,0.00,536.50,407740.00,407740.00,0.00,3),('21','227','4','1',760.00,760.00,0.00,529.31,402275.60,402275.60,0.00,4),('21','227','5','1',760.00,760.00,0.00,443.33,336930.80,336930.80,0.00,5),('21','227','6','1',760.00,760.00,0.00,816.97,620897.20,620897.20,0.00,6),('21','227','7','1',760.00,760.00,0.00,769.95,585162.00,585162.00,0.00,7),('21','227','8','1',760.00,760.00,0.00,702.14,533626.40,533626.40,0.00,8),('21','227','9','1',760.00,760.00,0.00,609.71,463379.60,463379.60,0.00,9),('21','227','10','1',760.00,760.00,0.00,416.34,316418.40,316418.40,0.00,10),('21','227','11','1',760.00,760.00,0.00,540.48,410764.80,410764.80,0.00,11),('21','227','12','1',760.00,760.00,0.00,506.01,384567.60,384567.60,0.00,12),('21','227','13','1',760.00,760.00,0.00,511.87,389021.20,389021.20,0.00,13),('21','227','14','1',760.00,760.00,0.00,642.01,487927.60,487927.60,0.00,14),('21','227','15','1',760.00,760.00,0.00,578.72,439827.20,439827.20,0.00,15),('21','227','16','1',760.00,760.00,0.00,582.04,442350.40,442350.40,0.00,16),('21','227','17','1',760.00,760.00,0.00,557.92,424019.20,424019.20,0.00,17),('21','227','18','1',760.00,760.00,0.00,774.61,588703.60,588703.60,0.00,18),('21','227','19','1',760.00,760.00,0.00,194.30,147668.00,147668.00,0.00,19),('21','227','20','1',760.00,760.00,0.00,579.94,440754.40,440754.40,0.00,20),('21','227','21','1',760.00,760.00,0.00,647.99,492472.40,492472.40,0.00,21),('21','227','22','1',760.00,760.00,0.00,607.85,461966.00,461966.00,0.00,22),('21','227','23','1',760.00,760.00,0.00,444.19,337584.40,337584.40,0.00,23),('21','227','24','1',760.00,760.00,0.00,784.38,596128.80,596128.80,0.00,24),('21','227','25','1',760.00,760.00,0.00,812.60,617576.00,617576.00,0.00,25),('21','227','26','1',760.00,760.00,0.00,242.09,183988.40,183988.40,0.00,26),('21','227','27','1',760.00,760.00,0.00,901.90,685444.00,685444.00,0.00,27),('21','227','28','1',760.00,760.00,0.00,660.05,501638.00,501638.00,0.00,28),('21','227','29','1',760.00,760.00,0.00,340.61,258863.60,258863.60,0.00,29),('21','227','30','1',760.00,760.00,0.00,217.10,164996.00,164996.00,0.00,30),('21','227','31','1',760.00,760.00,0.00,303.65,230774.00,230774.00,0.00,31),('21','227','32','1',760.00,760.00,0.00,0.00,0.00,0.00,0.00,32),('21','227','33','1',760.00,760.00,0.00,688.91,523571.60,523571.60,0.00,33),('21','227','34','1',760.00,760.00,0.00,226.23,171934.80,171934.80,0.00,34),('21','227','35','1',760.00,760.00,0.00,233.41,177391.60,177391.60,0.00,35),('21','227','36','1',760.00,760.00,0.00,520.61,395663.60,395663.60,0.00,36),('21','227','37','1',760.00,760.00,0.00,274.92,208939.20,208939.20,0.00,37),('21','227','38','1',760.00,760.00,0.00,157.89,119996.40,119996.40,0.00,38),('21','227','39','1',760.00,760.00,0.00,702.56,533945.60,533945.60,0.00,39),('21','227','40','1',760.00,760.00,0.00,567.25,431110.00,431110.00,0.00,40),('21','227','41','1',760.00,760.00,0.00,453.81,344895.60,344895.60,0.00,41),('21','227','42','1',760.00,760.00,0.00,771.87,586621.20,586621.20,0.00,42),('21','227','43','1',760.00,760.00,0.00,539.32,409883.20,409883.20,0.00,43),('21','227','44','1',760.00,760.00,0.00,597.35,453986.00,453986.00,0.00,44),('21','227','45','1',760.00,760.00,0.00,639.16,485761.60,485761.60,0.00,45),('21','227','46','1',760.00,760.00,0.00,547.20,415872.00,415872.00,0.00,46),('21','227','47','1',760.00,760.00,0.00,474.39,360536.40,360536.40,0.00,47),('21','227','48','1',760.00,760.00,0.00,314.36,238913.60,238913.60,0.00,48),('21','227','49','1',760.00,760.00,0.00,522.97,397457.20,397457.20,0.00,49),('21','227','50','1',760.00,760.00,0.00,430.73,327354.80,327354.80,0.00,50),('21','227','51','1',760.00,760.00,0.00,128.71,97819.60,97819.60,0.00,51),('21','227','52','1',760.00,760.00,0.00,625.46,475349.60,475349.60,0.00,52),('21','227','53','1',760.00,760.00,0.00,487.43,370446.80,370446.80,0.00,53),('21','227','54','1',760.00,760.00,0.00,573.28,435692.80,435692.80,0.00,54),('21','227','55','1',760.00,760.00,0.00,523.47,397837.20,397837.20,0.00,55),('21','227','56','1',760.00,760.00,0.00,682.89,518996.40,518996.40,0.00,56),('21','227','57','1',760.00,760.00,0.00,895.96,680929.60,680929.60,0.00,57),('21','227','58','1',760.00,760.00,0.00,924.26,702437.60,702437.60,0.00,58),('21','227','59','1',760.00,760.00,0.00,188.13,142978.80,142978.80,0.00,59),('21','227','60','1',760.00,760.00,0.00,215.21,163559.60,163559.60,0.00,60),('21','227','61','1',760.00,760.00,0.00,678.63,515758.80,515758.80,0.00,61),('21','227','62','1',760.00,760.00,0.00,659.86,501493.60,501493.60,0.00,62),('21','227','63','1',760.00,760.00,0.00,547.18,415856.80,415856.80,0.00,63),('21','227','64','1',760.00,760.00,0.00,665.74,505962.40,505962.40,0.00,64),('21','227','65','1',760.00,760.00,0.00,765.55,581818.00,581818.00,0.00,65),('21','227','66','1',760.00,760.00,0.00,515.44,391734.40,391734.40,0.00,66),('21','227','67','1',760.00,760.00,0.00,600.48,456364.80,456364.80,0.00,67),('21','227','68','1',760.00,760.00,0.00,316.46,240509.60,240509.60,0.00,68),('21','227','69','1',760.00,760.00,0.00,803.11,610363.60,610363.60,0.00,69),('21','227','70','1',760.00,760.00,0.00,540.57,410833.20,410833.20,0.00,70),('21','227','71','1',760.00,760.00,0.00,589.39,447936.40,447936.40,0.00,71),('21','227','72','1',760.00,760.00,0.00,678.02,515295.20,515295.20,0.00,72),('21','227','73','1',760.00,760.00,0.00,2006.92,1525259.20,1525259.20,0.00,73),('21','227','74','1',760.00,760.00,0.00,0.00,0.00,0.00,0.00,74),('21','227','75','1',760.00,760.00,0.00,45.00,34200.00,34200.00,0.00,75),('21','227','76','1',760.00,760.00,0.00,1667.29,1267137.36,1267137.36,0.00,76);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'227','LPG PRODUCT TANKS','TANK CONTAINING LPG PRODCUT');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','227','1',1,1,'1','LPG TANK',5000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT.','764','2022-03-03 16:29:58','2022-03-03 16:29:58','764',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=6907 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (10,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-06-07 08:31:30','',''),(11,'21','227',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,5000.00,0.00,'2022-06-07 08:34:20','',''),(12,'21','227','1',1,'Received from bridging 3',0.00,0.00,5000.00,0.00,0.00,'2022-06-07 08:34:20','',''),(13,'21','227','1',1,'Retail Sale Id 4',4560.00,0.00,0.00,6.00,0.00,'2022-06-07 08:39:53','',''),(14,'21','227','1',1,'Retail Sale Id 5',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 08:42:30','',''),(15,'21','227','1',1,'Retail Sale Id 6',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 08:44:18','',''),(16,'21','227','1',1,'Retail Sale Id 7',995.60,0.00,0.00,1.31,0.00,'2022-06-07 08:45:54','',''),(17,'21','227','1',1,'Retail Sale Id 8',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 08:47:16','',''),(18,'21','227','1',1,'Retail Sale Id 9',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 08:49:04','',''),(19,'21','227','1',1,'Retail Sale Id 10',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 08:50:54','',''),(20,'21','227','1',1,'Retail Sale Id 11',1504.80,0.00,0.00,1.98,0.00,'2022-06-07 08:52:19','',''),(21,'21','227','1',1,'Retail Sale Id 12',1140.00,0.00,0.00,1.50,0.00,'2022-06-07 08:58:20','',''),(22,'21','227','1',1,'Retail Sale Id 13',7600.00,0.00,0.00,10.00,0.00,'2022-06-07 08:59:45','',''),(23,'21','227','1',1,'Retail Sale Id 14',1140.00,0.00,0.00,1.50,0.00,'2022-06-07 09:01:21','',''),(24,'21','227','1',1,'Retail Sale Id 14',1398.40,0.00,0.00,1.84,0.00,'2022-06-07 09:01:21','',''),(25,'21','227','1',1,'Retail Sale Id 15',2492.80,0.00,0.00,3.28,0.00,'2022-06-07 09:02:44','',''),(26,'21','227','1',1,'Retail Sale Id 16',4993.20,0.00,0.00,6.57,0.00,'2022-06-07 09:04:16','',''),(27,'21','227','1',1,'Retail Sale Id 17',760.00,0.00,0.00,1.00,0.00,'2022-06-07 09:05:29','',''),(28,'21','227','1',1,'Retail Sale Id 18',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 09:07:26','',''),(29,'21','227','1',1,'Retail Sale Id 19',798.00,0.00,0.00,1.05,0.00,'2022-06-07 09:10:47','',''),(30,'21','227','1',1,'Retail Sale Id 20',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 09:16:57','',''),(31,'21','227','1',1,'Retail Sale Id 21',1041.20,0.00,0.00,1.37,0.00,'2022-06-07 09:20:30','',''),(32,'21','227','1',1,'Retail Sale Id 23',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 09:28:12','',''),(33,'21','227','1',1,'Retail Sale Id 24',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 09:29:27','',''),(34,'21','227','1',1,'Retail Sale Id 25',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 09:33:45','',''),(35,'21','227','1',1,'Retail Sale Id 27',1193.20,0.00,0.00,1.57,0.00,'2022-06-07 09:35:43','',''),(36,'21','227','1',1,'Retail Sale Id 28',4560.00,0.00,0.00,6.00,0.00,'2022-06-07 09:39:49','',''),(37,'21','227','1',1,'Retail Sale Id 29',995.60,0.00,0.00,1.31,0.00,'2022-06-07 10:01:51','',''),(38,'21','227','1',1,'Retail Sale Id 30',699.20,0.00,0.00,0.92,0.00,'2022-06-07 10:05:33','',''),(39,'21','227','1',1,'Retail Sale Id 31',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 10:10:15','',''),(40,'21','227','1',1,'Retail Sale Id 32',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 10:17:27','',''),(41,'21','227','1',1,'Retail Sale Id 33',995.60,0.00,0.00,1.31,0.00,'2022-06-07 11:12:57','',''),(42,'21','227','1',1,'Retail Sale Id 34',3982.40,0.00,0.00,5.24,0.00,'2022-06-07 11:15:03','',''),(43,'21','227','1',1,'Retail Sale Id 36',1520.00,0.00,0.00,2.00,0.00,'2022-06-07 11:18:18','',''),(44,'21','227','1',1,'Retail Sale Id 37',4993.20,0.00,0.00,6.57,0.00,'2022-06-07 11:31:57','',''),(45,'21','227','1',1,'Retail Sale Id 38',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 11:39:39','',''),(46,'21','227','1',1,'Retail Sale Id 39',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 11:43:04','',''),(47,'21','227','1',1,'Retail Sale Id 40',2994.40,0.00,0.00,3.94,0.00,'2022-06-07 11:45:12','',''),(48,'21','227','1',1,'Retail Sale Id 41',1520.00,0.00,0.00,2.00,0.00,'2022-06-07 11:47:03','',''),(49,'21','227','1',1,'Retail Sale Id 42',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 11:49:34','',''),(50,'21','227','1',1,'Retail Sale Id 43',9500.00,0.00,0.00,12.50,0.00,'2022-06-07 11:51:27','',''),(51,'21','227','1',1,'Retail Sale Id 44',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 12:27:48','',''),(52,'21','227','1',1,'Retail Sale Id 45',7600.00,0.00,0.00,10.00,0.00,'2022-06-07 12:29:40','',''),(53,'21','227','1',1,'Retail Sale Id 46',4560.00,0.00,0.00,6.00,0.00,'2022-06-07 12:31:47','',''),(54,'21','227','1',1,'Retail Sale Id 47',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 12:38:32','',''),(55,'21','227','1',1,'Retail Sale Id 48',798.00,0.00,0.00,1.05,0.00,'2022-06-07 12:43:06','',''),(56,'21','227','1',1,'Return of Retail Sale Id 39',0.00,1998.80,2.63,0.00,0.00,'2022-06-07 12:53:00','',''),(57,'21','227','1',1,'Retail Sale Id 49',9500.00,0.00,0.00,12.50,0.00,'2022-06-07 13:31:38','',''),(58,'21','227','1',1,'Retail Sale Id 50',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 13:32:36','',''),(59,'21','227','1',1,'Retail Sale Id 51',1520.00,0.00,0.00,2.00,0.00,'2022-06-07 13:33:23','',''),(60,'21','227','1',1,'Retail Sale Id 52',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 13:34:09','',''),(61,'21','227','1',1,'Retail Sale Id 53',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 13:35:03','',''),(62,'21','227','1',1,'Retail Sale Id 54',995.60,0.00,0.00,1.31,0.00,'2022-06-07 13:35:58','',''),(63,'21','227','1',1,'Retail Sale Id 55',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 13:36:41','',''),(64,'21','227','1',1,'Retail Sale Id 56',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 13:37:20','',''),(65,'21','227','1',1,'Retail Sale Id 57',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 13:37:54','',''),(66,'21','227','1',1,'Retail Sale Id 58',9500.00,0.00,0.00,12.50,0.00,'2022-06-07 13:38:34','',''),(67,'21','227','1',1,'Retail Sale Id 59',995.60,0.00,0.00,1.31,0.00,'2022-06-07 13:39:12','',''),(68,'21','227','1',1,'Retail Sale Id 60',896.80,0.00,0.00,1.18,0.00,'2022-06-07 13:39:53','',''),(69,'21','227','1',1,'Retail Sale Id 61',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 13:40:34','',''),(70,'21','227','1',1,'Retail Sale Id 62',995.60,0.00,0.00,1.31,0.00,'2022-06-07 13:41:07','',''),(71,'21','227','1',1,'Retail Sale Id 63',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 13:41:40','',''),(72,'21','227','1',1,'Retail Sale Id 64',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 13:42:09','',''),(73,'21','227','1',1,'Retail Sale Id 65',4392.80,0.00,0.00,5.78,0.00,'2022-06-07 13:42:40','',''),(74,'21','227','1',1,'Retail Sale Id 66',896.80,0.00,0.00,1.18,0.00,'2022-06-07 13:47:01','',''),(75,'21','227','1',1,'Retail Sale Id 67',9500.00,0.00,0.00,12.50,0.00,'2022-06-07 13:49:55','',''),(76,'21','227','1',1,'Retail Sale Id 68',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 13:57:40','',''),(77,'21','227','1',1,'Retail Sale Id 69',1520.00,0.00,0.00,2.00,0.00,'2022-06-07 14:00:10','',''),(78,'21','227','1',1,'Retail Sale Id 70',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 14:10:21','',''),(79,'21','227','1',1,'Retail Sale Id 71',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 14:11:19','',''),(80,'21','227','1',1,'Retail Sale Id 72',4560.00,0.00,0.00,6.00,0.00,'2022-06-07 14:26:46','',''),(81,'21','227','1',1,'Retail Sale Id 73',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 14:33:17','',''),(82,'21','227','1',1,'Retail Sale Id 75',2994.40,0.00,0.00,3.94,0.00,'2022-06-07 14:39:53','',''),(83,'21','227','1',1,'Retail Sale Id 75',4560.00,0.00,0.00,6.00,0.00,'2022-06-07 14:39:53','',''),(84,'21','227','1',1,'Retail Sale Id 75',9500.00,0.00,0.00,12.50,0.00,'2022-06-07 14:39:53','',''),(85,'21','227','1',1,'Retail Sale Id 76',4560.00,0.00,0.00,6.00,0.00,'2022-06-07 14:42:57','',''),(86,'21','227','1',1,'Retail Sale Id 77',2994.40,0.00,0.00,3.94,0.00,'2022-06-07 14:46:43','',''),(87,'21','227','1',1,'Retail Sale Id 78',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 14:54:04','',''),(88,'21','227','1',1,'Retail Sale Id 79',6999.60,0.00,0.00,9.21,0.00,'2022-06-07 15:00:18','',''),(89,'21','227','1',1,'Retail Sale Id 80',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 15:26:57','',''),(90,'21','227','1',1,'Retail Sale Id 81',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 15:28:23','',''),(91,'21','227','1',1,'Retail Sale Id 82',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 15:32:28','',''),(92,'21','227','1',1,'Retail Sale Id 83',1694.80,0.00,0.00,2.23,0.00,'2022-06-07 15:41:09','',''),(93,'21','227','1',1,'Retail Sale Id 84',1193.20,0.00,0.00,1.57,0.00,'2022-06-07 15:43:18','',''),(94,'21','227','1',1,'Retail Sale Id 85',995.60,0.00,0.00,1.31,0.00,'2022-06-07 15:44:52','',''),(95,'21','227','1',1,'Retail Sale Id 86',995.60,0.00,0.00,1.31,0.00,'2022-06-07 15:46:38','',''),(96,'21','227','1',1,'Retail Sale Id 87',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 15:48:00','',''),(97,'21','227','1',1,'Retail Sale Id 88',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 15:49:29','',''),(98,'21','227','1',1,'Retail Sale Id 89',995.60,0.00,0.00,1.31,0.00,'2022-06-07 15:51:07','',''),(99,'21','227','1',1,'Retail Sale Id 91',995.60,0.00,0.00,1.31,0.00,'2022-06-07 16:07:30','',''),(100,'21','227','1',1,'Retail Sale Id 91',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 16:07:30','',''),(101,'21','227','1',1,'Retail Sale Id 92',1520.00,0.00,0.00,2.00,0.00,'2022-06-07 16:08:49','',''),(102,'21','227','1',1,'Retail Sale Id 93',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 16:10:05','',''),(103,'21','227','1',1,'Retail Sale Id 95',995.60,0.00,0.00,1.31,0.00,'2022-06-07 16:10:54','',''),(104,'21','227','1',1,'Retail Sale Id 96',2796.80,0.00,0.00,3.68,0.00,'2022-06-07 16:12:56','',''),(105,'21','227','1',1,'Retail Sale Id 97',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 16:14:02','',''),(106,'21','227','1',1,'Retail Sale Id 98',4993.20,0.00,0.00,6.57,0.00,'2022-06-07 16:15:14','',''),(107,'21','227','1',1,'Retail Sale Id 99',995.60,0.00,0.00,1.31,0.00,'2022-06-07 16:21:26','',''),(108,'21','227','1',1,'Retail Sale Id 100',2994.40,0.00,0.00,3.94,0.00,'2022-06-07 16:22:26','',''),(109,'21','227','1',1,'Retail Sale Id 101',9500.00,0.00,0.00,12.50,0.00,'2022-06-07 16:23:38','',''),(110,'21','227','1',1,'Retail Sale Id 102',1520.00,0.00,0.00,2.00,0.00,'2022-06-07 16:24:33','',''),(111,'21','227','1',1,'Retail Sale Id 103',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 16:25:50','',''),(112,'21','227','1',1,'Retail Sale Id 104',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 16:27:27','',''),(113,'21','227','1',1,'Retail Sale Id 105',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 16:28:34','',''),(114,'21','227','1',1,'Retail Sale Id 106',494.00,0.00,0.00,0.65,0.00,'2022-06-07 16:29:36','',''),(115,'21','227','1',1,'Retail Sale Id 107',995.60,0.00,0.00,1.31,0.00,'2022-06-07 16:30:51','',''),(116,'21','227','1',1,'Retail Sale Id 108',592.80,0.00,0.00,0.78,0.00,'2022-06-07 16:31:47','',''),(117,'21','227','1',1,'Retail Sale Id 109',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 16:35:55','',''),(118,'21','227','1',1,'Retail Sale Id 110',1900.00,0.00,0.00,2.50,0.00,'2022-06-07 16:38:09','',''),(119,'21','227','1',1,'Retail Sale Id 111',995.60,0.00,0.00,1.31,0.00,'2022-06-07 16:42:42','',''),(120,'21','227','1',1,'Retail Sale Id 112',1694.80,0.00,0.00,2.23,0.00,'2022-06-07 16:43:56','',''),(121,'21','227','1',1,'Retail Sale Id 113',995.60,0.00,0.00,1.31,0.00,'2022-06-07 16:45:25','',''),(122,'21','227','1',1,'Retail Sale Id 114',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 16:46:05','',''),(123,'21','227','1',1,'Retail Sale Id 115',760.00,0.00,0.00,1.00,0.00,'2022-06-07 16:49:32','',''),(124,'21','227','1',1,'Retail Sale Id 116',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 16:52:18','',''),(125,'21','227','1',1,'Retail Sale Id 117',760.00,0.00,0.00,1.00,0.00,'2022-06-07 16:55:35','',''),(126,'21','227','1',1,'Retail Sale Id 118',4993.20,0.00,0.00,6.57,0.00,'2022-06-07 16:56:32','',''),(127,'21','227','1',1,'Retail Sale Id 119',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 16:57:15','',''),(128,'21','227','1',1,'Retail Sale Id 120',995.60,0.00,0.00,1.31,0.00,'2022-06-07 17:06:29','',''),(129,'21','227','1',1,'Retail Sale Id 121',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 17:08:26','',''),(130,'21','227','1',1,'Retail Sale Id 122',2994.40,0.00,0.00,3.94,0.00,'2022-06-07 17:09:19','',''),(131,'21','227','1',1,'Retail Sale Id 123',995.60,0.00,0.00,1.31,0.00,'2022-06-07 17:15:51','',''),(132,'21','227','1',1,'Retail Sale Id 123',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 17:15:51','',''),(133,'21','227','1',1,'Retail Sale Id 124',4993.20,0.00,0.00,6.57,0.00,'2022-06-07 17:19:39','',''),(134,'21','227','1',1,'Retail Sale Id 125',995.60,0.00,0.00,1.31,0.00,'2022-06-07 17:20:37','',''),(135,'21','227','1',1,'Retail Sale Id 126',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 17:22:41','',''),(136,'21','227','1',1,'Retail Sale Id 127',995.60,0.00,0.00,1.31,0.00,'2022-06-07 17:25:05','',''),(137,'21','227','1',1,'Retail Sale Id 128',995.60,0.00,0.00,1.31,0.00,'2022-06-07 17:26:25','',''),(138,'21','227','1',1,'Retail Sale Id 129',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 17:30:57','',''),(139,'21','227','1',1,'Retail Sale Id 130',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 17:32:04','',''),(140,'21','227','1',1,'Retail Sale Id 131',1299.60,0.00,0.00,1.71,0.00,'2022-06-07 17:45:27','',''),(141,'21','227','1',1,'Retail Sale Id 132',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 17:48:47','',''),(142,'21','227','1',1,'Retail Sale Id 133',760.00,0.00,0.00,1.00,0.00,'2022-06-07 17:51:29','',''),(143,'21','227','1',1,'Retail Sale Id 134',2492.80,0.00,0.00,3.28,0.00,'2022-06-07 17:52:23','',''),(144,'21','227','1',1,'Retail Sale Id 135',1520.00,0.00,0.00,2.00,0.00,'2022-06-07 17:53:42','',''),(145,'21','227','1',1,'Retail Sale Id 136',4560.00,0.00,0.00,6.00,0.00,'2022-06-07 17:54:26','',''),(146,'21','227','1',1,'Retail Sale Id 137',3997.60,0.00,0.00,5.26,0.00,'2022-06-07 17:57:37','',''),(147,'21','227','1',1,'Retail Sale Id 138',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 17:59:16','',''),(148,'21','227','1',1,'Retail Sale Id 139',760.00,0.00,0.00,1.00,0.00,'2022-06-07 18:00:12','',''),(149,'21','227','1',1,'Retail Sale Id 140',1193.20,0.00,0.00,1.57,0.00,'2022-06-07 18:00:58','',''),(150,'21','227','1',1,'Retail Sale Id 141',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 18:02:25','',''),(151,'21','227','1',1,'Retail Sale Id 142',995.60,0.00,0.00,1.31,0.00,'2022-06-07 18:04:31','',''),(152,'21','227','1',1,'Retail Sale Id 143',995.60,0.00,0.00,1.31,0.00,'2022-06-07 18:07:54','',''),(153,'21','227','1',1,'Retail Sale Id 144',995.60,0.00,0.00,1.31,0.00,'2022-06-07 18:13:29','',''),(154,'21','227','1',1,'Retail Sale Id 145',995.60,0.00,0.00,1.31,0.00,'2022-06-07 18:14:04','',''),(155,'21','227','1',1,'Retail Sale Id 146',995.60,0.00,0.00,1.31,0.00,'2022-06-07 18:15:03','',''),(156,'21','227','1',1,'Retail Sale Id 147',494.00,0.00,0.00,0.65,0.00,'2022-06-07 18:15:38','',''),(157,'21','227','1',1,'Retail Sale Id 148',995.60,0.00,0.00,1.31,0.00,'2022-06-07 18:16:24','',''),(158,'21','227','1',1,'Retail Sale Id 149',995.60,0.00,0.00,1.31,0.00,'2022-06-07 18:17:07','',''),(159,'21','227','1',1,'Retail Sale Id 150',9500.00,0.00,0.00,12.50,0.00,'2022-06-07 18:23:40','',''),(160,'21','227','1',1,'Retail Sale Id 151',1520.00,0.00,0.00,2.00,0.00,'2022-06-07 18:25:16','',''),(161,'21','227','1',1,'Retail Sale Id 152',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 18:26:15','',''),(162,'21','227','1',1,'Retail Sale Id 153',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 18:33:08','',''),(163,'21','227','1',1,'Retail Sale Id 154',9500.00,0.00,0.00,12.50,0.00,'2022-06-07 18:34:50','',''),(164,'21','227','1',1,'Retail Sale Id 155',3997.60,0.00,0.00,5.26,0.00,'2022-06-07 18:40:10','',''),(165,'21','227','1',1,'Retail Sale Id 156',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 18:41:20','',''),(166,'21','227','1',1,'Retail Sale Id 157',798.00,0.00,0.00,1.05,0.00,'2022-06-07 18:42:32','',''),(167,'21','227','1',1,'Retail Sale Id 158',1497.20,0.00,0.00,1.97,0.00,'2022-06-07 18:45:12','',''),(168,'21','227','1',1,'Retail Sale Id 159',2280.00,0.00,0.00,3.00,0.00,'2022-06-07 18:50:32','',''),(169,'21','227','1',1,'Retail Sale Id 160',3800.00,0.00,0.00,5.00,0.00,'2022-06-07 18:51:26','',''),(170,'21','227','1',1,'Retail Sale Id 161',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 18:54:40','',''),(171,'21','227','1',1,'Retail Sale Id 162',995.60,0.00,0.00,1.31,0.00,'2022-06-07 18:55:51','',''),(172,'21','227','1',1,'Retail Sale Id 163',4560.00,0.00,0.00,6.00,0.00,'2022-06-07 18:56:46','',''),(173,'21','227','1',1,'Retail Sale Id 164',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 18:57:57','',''),(174,'21','227','1',1,'Retail Sale Id 165',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 19:06:13','',''),(175,'21','227','1',1,'Retail Sale Id 90',1998.80,0.00,0.00,2.63,0.00,'2022-06-07 19:07:38','',''),(176,'21','227','1',1,'Retail Sale Id 94',760.00,0.00,0.00,1.00,0.00,'2022-06-07 19:19:23','',''),(177,'21','227','1',1,'Retail Sale Id 166',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 07:15:48','',''),(178,'21','227','1',1,'Retail Sale Id 167',760.00,0.00,0.00,1.00,0.00,'2022-06-08 07:18:23','',''),(179,'21','227','1',1,'Retail Sale Id 168',4499.20,0.00,0.00,5.92,0.00,'2022-06-08 07:40:40','',''),(180,'21','227','1',1,'Retail Sale Id 169',4993.20,0.00,0.00,6.57,0.00,'2022-06-08 07:41:55','',''),(181,'21','227','1',1,'Retail Sale Id 170',2492.80,0.00,0.00,3.28,0.00,'2022-06-08 07:43:56','',''),(182,'21','227','1',1,'Retail Sale Id 171',760.00,0.00,0.00,1.00,0.00,'2022-06-08 07:47:25','',''),(183,'21','227','1',1,'Retail Sale Id 172',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 08:09:23','',''),(184,'21','227','1',1,'Retail Sale Id 173',1299.60,0.00,0.00,1.71,0.00,'2022-06-08 08:11:05','',''),(185,'21','227','1',1,'Retail Sale Id 174',1193.20,0.00,0.00,1.57,0.00,'2022-06-08 08:26:22','',''),(186,'21','227','1',1,'Retail Sale Id 175',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 08:36:48','',''),(187,'21','227','1',1,'Retail Sale Id 176',995.60,0.00,0.00,1.31,0.00,'2022-06-08 08:42:09','',''),(188,'21','227','1',1,'Retail Sale Id 177',760.00,0.00,0.00,1.00,0.00,'2022-06-08 08:48:25','',''),(189,'21','227','1',1,'Retail Sale Id 178',760.00,0.00,0.00,1.00,0.00,'2022-06-08 08:49:57','',''),(190,'21','227','1',1,'Retail Sale Id 179',995.60,0.00,0.00,1.31,0.00,'2022-06-08 08:51:32','',''),(191,'21','227','1',1,'Retail Sale Id 180',2994.40,0.00,0.00,3.94,0.00,'2022-06-08 09:00:42','',''),(192,'21','227','1',1,'Retail Sale Id 181',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 09:01:55','',''),(193,'21','227','1',1,'Retail Sale Id 182',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 09:04:00','',''),(194,'21','227','1',1,'Retail Sale Id 183',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 09:07:06','',''),(195,'21','227','1',1,'Retail Sale Id 184',494.00,0.00,0.00,0.65,0.00,'2022-06-08 09:12:39','',''),(196,'21','227','1',1,'Retail Sale Id 185',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 09:17:15','',''),(197,'21','227','1',1,'Retail Sale Id 187',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 09:29:43','',''),(198,'21','227','1',1,'Retail Sale Id 188',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 09:32:55','',''),(199,'21','227','1',1,'Retail Sale Id 189',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 09:34:21','',''),(200,'21','227','1',1,'Retail Sale Id 190',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 09:36:34','',''),(201,'21','227','1',1,'Retail Sale Id 191',995.60,0.00,0.00,1.31,0.00,'2022-06-08 09:38:16','',''),(202,'21','227','1',1,'Retail Sale Id 192',2492.80,0.00,0.00,3.28,0.00,'2022-06-08 09:43:52','',''),(203,'21','227','1',1,'Retail Sale Id 193',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 09:52:27','',''),(204,'21','227','1',1,'Retail Sale Id 194',8360.00,0.00,0.00,11.00,0.00,'2022-06-08 10:08:24','',''),(205,'21','227','1',1,'Retail Sale Id 195',3496.00,0.00,0.00,4.60,0.00,'2022-06-08 10:14:01','',''),(206,'21','227','1',1,'Retail Sale Id 196',1193.20,0.00,0.00,1.57,0.00,'2022-06-08 10:15:23','',''),(207,'21','227','1',1,'Retail Sale Id 197',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 10:18:52','',''),(208,'21','227','1',1,'Retail Sale Id 198',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 10:21:36','',''),(209,'21','227','1',1,'Retail Sale Id 199',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 10:26:35','',''),(210,'21','227','1',1,'Retail Sale Id 200',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 10:28:51','',''),(211,'21','227','1',1,'Retail Sale Id 201',3997.60,0.00,0.00,5.26,0.00,'2022-06-08 10:30:19','',''),(212,'21','227','1',1,'Retail Sale Id 202',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 10:31:58','',''),(213,'21','227','1',1,'Retail Sale Id 203',995.60,0.00,0.00,1.31,0.00,'2022-06-08 10:37:41','',''),(214,'21','227','1',1,'Retail Sale Id 203',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 10:37:41','',''),(215,'21','227','1',1,'Retail Sale Id 204',995.60,0.00,0.00,1.31,0.00,'2022-06-08 10:53:20','',''),(216,'21','227','1',1,'Retail Sale Id 205',7600.00,0.00,0.00,10.00,0.00,'2022-06-08 10:58:00','',''),(217,'21','227','1',1,'Retail Sale Id 205',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 10:58:00','',''),(218,'21','227','1',1,'Retail Sale Id 205',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 10:58:00','',''),(219,'21','227','1',1,'Retail Sale Id 206',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 11:02:52','',''),(220,'21','227','1',1,'Retail Sale Id 207',3997.60,0.00,0.00,5.26,0.00,'2022-06-08 11:04:52','',''),(221,'21','227','1',1,'Retail Sale Id 208',995.60,0.00,0.00,1.31,0.00,'2022-06-08 11:11:07','',''),(222,'21','227','1',1,'Retail Sale Id 209',760.00,0.00,0.00,1.00,0.00,'2022-06-08 11:21:26','',''),(223,'21','227','1',1,'Retail Sale Id 210',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 11:23:56','',''),(224,'21','227','1',1,'Retail Sale Id 211',760.00,0.00,0.00,1.00,0.00,'2022-06-08 11:34:32','',''),(225,'21','227','1',1,'Retail Sale Id 212',699.20,0.00,0.00,0.92,0.00,'2022-06-08 11:46:04','',''),(226,'21','227','1',1,'Retail Sale Id 213',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 11:50:01','',''),(227,'21','227','1',1,'Retail Sale Id 214',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 11:52:41','',''),(228,'21','227','1',1,'Retail Sale Id 215',2994.40,0.00,0.00,3.94,0.00,'2022-06-08 11:55:46','',''),(229,'21','227','1',1,'Retail Sale Id 216',995.60,0.00,0.00,1.31,0.00,'2022-06-08 12:11:22','',''),(230,'21','227','1',1,'Retail Sale Id 217',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 12:14:06','',''),(231,'21','227','1',1,'Retail Sale Id 218',995.60,0.00,0.00,1.31,0.00,'2022-06-08 12:16:00','',''),(232,'21','227','1',1,'Retail Sale Id 219',1520.00,0.00,0.00,2.00,0.00,'2022-06-08 12:17:45','',''),(233,'21','227','1',1,'Retail Sale Id 220',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 12:39:52','',''),(234,'21','227','1',1,'Retail Sale Id 221',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 12:53:15','',''),(235,'21','227','1',1,'Retail Sale Id 222',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 13:00:15','',''),(236,'21','227','1',1,'Retail Sale Id 223',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 13:05:29','',''),(237,'21','227','1',1,'Retail Sale Id 224',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 13:20:55','',''),(238,'21','227','1',1,'Retail Sale Id 225',798.00,0.00,0.00,1.05,0.00,'2022-06-08 13:24:13','',''),(239,'21','227','1',1,'Retail Sale Id 226',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 13:30:50','',''),(240,'21','227','1',1,'Retail Sale Id 227',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 13:33:43','',''),(241,'21','227','1',1,'Retail Sale Id 228',995.60,0.00,0.00,1.31,0.00,'2022-06-08 13:38:04','',''),(242,'21','227','1',1,'Retail Sale Id 229',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 14:16:40','',''),(243,'21','227','1',1,'Retail Sale Id 230',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 14:19:05','',''),(244,'21','227','1',1,'Retail Sale Id 231',995.60,0.00,0.00,1.31,0.00,'2022-06-08 14:45:20','',''),(245,'21','227','1',1,'Retail Sale Id 232',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 14:55:56','',''),(246,'21','227','1',1,'Retail Sale Id 233',995.60,0.00,0.00,1.31,0.00,'2022-06-08 14:57:38','',''),(247,'21','227','1',1,'Retail Sale Id 234',4993.20,0.00,0.00,6.57,0.00,'2022-06-08 15:02:16','',''),(248,'21','227','1',1,'Retail Sale Id 234',4993.20,0.00,0.00,6.57,0.00,'2022-06-08 15:02:16','',''),(249,'21','227','1',1,'Retail Sale Id 235',1520.00,0.00,0.00,2.00,0.00,'2022-06-08 15:03:36','',''),(250,'21','227','1',1,'Retail Sale Id 236',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 15:13:03','',''),(251,'21','227','1',1,'Retail Sale Id 237',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 15:20:11','',''),(252,'21','227','1',1,'Retail Sale Id 238',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 15:25:30','',''),(253,'21','227','1',1,'Retail Sale Id 239',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 15:33:34','',''),(254,'21','227','1',1,'Retail Sale Id 240',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 15:40:15','',''),(255,'21','227','1',1,'Retail Sale Id 241',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 15:47:56','',''),(256,'21','227','1',1,'Retail Sale Id 242',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 15:56:51','',''),(257,'21','227','1',1,'Retail Sale Id 243',995.60,0.00,0.00,1.31,0.00,'2022-06-08 15:59:11','',''),(258,'21','227','1',1,'Retail Sale Id 244',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 16:01:59','',''),(259,'21','227','1',1,'Retail Sale Id 245',2196.40,0.00,0.00,2.89,0.00,'2022-06-08 16:04:19','',''),(260,'21','227','1',1,'Retail Sale Id 246',2994.40,0.00,0.00,3.94,0.00,'2022-06-08 16:06:05','',''),(261,'21','227','1',1,'Retail Sale Id 247',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 16:11:24','',''),(262,'21','227','1',1,'Retail Sale Id 248',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 16:15:36','',''),(263,'21','227','1',1,'Retail Sale Id 249',2994.40,0.00,0.00,3.94,0.00,'2022-06-08 16:22:47','',''),(264,'21','227','1',1,'Retail Sale Id 250',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 16:24:37','',''),(265,'21','227','1',1,'Retail Sale Id 251',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 16:27:53','',''),(266,'21','227','1',1,'Retail Sale Id 252',995.60,0.00,0.00,1.31,0.00,'2022-06-08 16:46:39','',''),(267,'21','227','1',1,'Retail Sale Id 253',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 16:47:28','',''),(268,'21','227','1',1,'Retail Sale Id 254',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 16:48:24','',''),(269,'21','227','1',1,'Retail Sale Id 255',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 16:51:16','',''),(270,'21','227','1',1,'Retail Sale Id 256',2994.40,0.00,0.00,3.94,0.00,'2022-06-08 16:52:39','',''),(271,'21','227','1',1,'Retail Sale Id 257',1900.00,0.00,0.00,2.50,0.00,'2022-06-08 16:53:52','',''),(272,'21','227','1',1,'Retail Sale Id 258',1793.60,0.00,0.00,2.36,0.00,'2022-06-08 16:54:42','',''),(273,'21','227','1',1,'Retail Sale Id 259',3040.00,0.00,0.00,4.00,0.00,'2022-06-08 16:57:12','',''),(274,'21','227','1',1,'Retail Sale Id 260',995.60,0.00,0.00,1.31,0.00,'2022-06-08 17:08:27','',''),(275,'21','227','1',1,'Retail Sale Id 261',3997.60,0.00,0.00,5.26,0.00,'2022-06-08 17:10:23','',''),(276,'21','227','1',1,'Retail Sale Id 262',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 17:41:00','',''),(277,'21','227','1',1,'Retail Sale Id 263',4499.20,0.00,0.00,5.92,0.00,'2022-06-08 17:42:13','',''),(278,'21','227','1',1,'Retail Sale Id 264',1900.00,0.00,0.00,2.50,0.00,'2022-06-08 17:46:01','',''),(279,'21','227','1',1,'Retail Sale Id 265',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 17:46:49','',''),(280,'21','227','1',1,'Retail Sale Id 266',995.60,0.00,0.00,1.31,0.00,'2022-06-08 17:47:39','',''),(281,'21','227','1',1,'Retail Sale Id 267',995.60,0.00,0.00,1.31,0.00,'2022-06-08 17:48:20','',''),(282,'21','227','1',1,'Retail Sale Id 268',3040.00,0.00,0.00,4.00,0.00,'2022-06-08 17:49:05','',''),(283,'21','227','1',1,'Retail Sale Id 269',1170.40,0.00,0.00,1.54,0.00,'2022-06-08 17:50:19','',''),(284,'21','227','1',1,'Retail Sale Id 270',995.60,0.00,0.00,1.31,0.00,'2022-06-08 17:51:25','',''),(285,'21','227','1',1,'Retail Sale Id 271',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 17:52:20','',''),(286,'21','227','1',1,'Retail Sale Id 272',1520.00,0.00,0.00,2.00,0.00,'2022-06-08 17:55:11','',''),(287,'21','227','1',1,'Retail Sale Id 273',995.60,0.00,0.00,1.31,0.00,'2022-06-08 17:56:00','',''),(288,'21','227','1',1,'Retail Sale Id 274',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 17:56:33','',''),(289,'21','227','1',1,'Retail Sale Id 275',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 17:57:24','',''),(290,'21','227','1',1,'Retail Sale Id 276',3199.60,0.00,0.00,4.21,0.00,'2022-06-08 18:03:17','',''),(291,'21','227','1',1,'Retail Sale Id 277',2994.40,0.00,0.00,3.94,0.00,'2022-06-08 18:04:18','',''),(292,'21','227','1',1,'Retail Sale Id 278',995.60,0.00,0.00,1.31,0.00,'2022-06-08 18:07:12','',''),(293,'21','227','1',1,'Retail Sale Id 279',592.80,0.00,0.00,0.78,0.00,'2022-06-08 18:08:46','',''),(294,'21','227','1',1,'Retail Sale Id 280',3997.60,0.00,0.00,5.26,0.00,'2022-06-08 18:09:35','',''),(295,'21','227','1',1,'Retail Sale Id 281',3997.60,0.00,0.00,5.26,0.00,'2022-06-08 18:10:39','',''),(296,'21','227','1',1,'Retail Sale Id 282',798.00,0.00,0.00,1.05,0.00,'2022-06-08 18:16:22','',''),(297,'21','227','1',1,'Retail Sale Id 283',995.60,0.00,0.00,1.31,0.00,'2022-06-08 18:21:31','',''),(298,'21','227','1',1,'Retail Sale Id 284',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 18:28:54','',''),(299,'21','227','1',1,'Retail Sale Id 285',995.60,0.00,0.00,1.31,0.00,'2022-06-08 18:29:39','',''),(300,'21','227','1',1,'Retail Sale Id 286',760.00,0.00,0.00,1.00,0.00,'2022-06-08 18:30:27','',''),(301,'21','227','1',1,'Retail Sale Id 287',995.60,0.00,0.00,1.31,0.00,'2022-06-08 18:31:12','',''),(302,'21','227','1',1,'Retail Sale Id 288',995.60,0.00,0.00,1.31,0.00,'2022-06-08 18:31:54','',''),(303,'21','227','1',1,'Retail Sale Id 289',2492.80,0.00,0.00,3.28,0.00,'2022-06-08 18:32:54','',''),(304,'21','227','1',1,'Retail Sale Id 290',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 18:33:43','',''),(305,'21','227','1',1,'Retail Sale Id 291',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 18:34:33','',''),(306,'21','227','1',1,'Retail Sale Id 292',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 18:39:56','',''),(307,'21','227','1',1,'Retail Sale Id 293',699.20,0.00,0.00,0.92,0.00,'2022-06-08 18:42:48','',''),(308,'21','227','1',1,'Retail Sale Id 294',1520.00,0.00,0.00,2.00,0.00,'2022-06-08 18:44:18','',''),(309,'21','227','1',1,'Retail Sale Id 295',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 18:46:27','',''),(310,'21','227','1',1,'Retail Sale Id 296',3040.00,0.00,0.00,4.00,0.00,'2022-06-08 18:47:35','',''),(311,'21','227','1',1,'Retail Sale Id 297',494.00,0.00,0.00,0.65,0.00,'2022-06-08 18:50:00','',''),(312,'21','227','1',1,'Retail Sale Id 298',995.60,0.00,0.00,1.31,0.00,'2022-06-08 18:50:56','',''),(313,'21','227','1',1,'Retail Sale Id 299',494.00,0.00,0.00,0.65,0.00,'2022-06-08 18:52:57','',''),(314,'21','227','1',1,'Retail Sale Id 300',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 18:54:02','',''),(315,'21','227','1',1,'Retail Sale Id 300',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 18:54:02','',''),(316,'21','227','1',1,'Retail Sale Id 301',7600.00,0.00,0.00,10.00,0.00,'2022-06-08 18:55:18','',''),(317,'21','227','1',1,'Retail Sale Id 302',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 18:56:46','',''),(318,'21','227','1',1,'Retail Sale Id 303',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 08:09:21','',''),(319,'21','227','1',1,'Retail Sale Id 304',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 08:12:20','',''),(320,'21','227','1',1,'Retail Sale Id 305',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 08:14:07','',''),(321,'21','227','1',1,'Retail Sale Id 306',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 08:17:35','',''),(322,'21','227','1',1,'Retail Sale Id 307',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 08:24:54','',''),(323,'21','227','1',1,'Retail Sale Id 308',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 08:28:48','',''),(324,'21','227','1',1,'Retail Sale Id 309',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 08:34:06','',''),(325,'21','227','1',1,'Retail Sale Id 310',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 08:51:16','',''),(326,'21','227','1',1,'Retail Sale Id 312',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 08:55:13','',''),(327,'21','227','1',1,'Retail Sale Id 313',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 09:01:14','',''),(328,'21','227','1',1,'Retail Sale Id 314',1451.60,0.00,0.00,1.91,0.00,'2022-06-09 09:02:00','',''),(329,'21','227','1',1,'Retail Sale Id 315',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 09:03:03','',''),(330,'21','227','1',1,'Retail Sale Id 315',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 09:03:03','',''),(331,'21','227','1',1,'Retail Sale Id 316',995.60,0.00,0.00,1.31,0.00,'2022-06-09 09:04:13','',''),(332,'21','227','1',1,'Retail Sale Id 317',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 09:08:25','',''),(333,'21','227','1',1,'Retail Sale Id 318',1246.40,0.00,0.00,1.64,0.00,'2022-06-09 09:09:12','',''),(334,'21','227','1',1,'Retail Sale Id 319',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 09:21:28','',''),(335,'21','227','1',1,'Retail Sale Id 321',760.00,0.00,0.00,1.00,0.00,'2022-06-09 09:35:52','',''),(336,'21','227','1',1,'Retail Sale Id 322',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 09:49:52','',''),(337,'21','227','1',1,'Retail Sale Id 324',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 10:02:02','',''),(338,'21','227','1',1,'Retail Sale Id 324',3997.60,0.00,0.00,5.26,0.00,'2022-06-09 10:02:02','',''),(339,'21','227','1',1,'Retail Sale Id 326',3040.00,0.00,0.00,4.00,0.00,'2022-06-09 10:04:23','',''),(340,'21','227','1',1,'Retail Sale Id 327',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 10:06:26','',''),(341,'21','227','1',1,'Retail Sale Id 328',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 10:12:40','',''),(342,'21','227','1',1,'Retail Sale Id 329',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 10:14:25','',''),(343,'21','227','1',1,'Retail Sale Id 330',1520.00,0.00,0.00,2.00,0.00,'2022-06-09 10:18:07','',''),(344,'21','227','1',1,'Retail Sale Id 331',760.00,0.00,0.00,1.00,0.00,'2022-06-09 10:22:46','',''),(345,'21','227','1',1,'Retail Sale Id 332',4993.20,0.00,0.00,6.57,0.00,'2022-06-09 10:43:31','',''),(346,'21','227','1',1,'Retail Sale Id 333',1900.00,0.00,0.00,2.50,0.00,'2022-06-09 10:46:52','',''),(347,'21','227','1',1,'Retail Sale Id 334',494.00,0.00,0.00,0.65,0.00,'2022-06-09 11:04:50','',''),(348,'21','227','1',1,'Retail Sale Id 335',1094.40,0.00,0.00,1.44,0.00,'2022-06-09 11:11:54','',''),(349,'21','227','1',1,'Retail Sale Id 336',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 11:13:07','',''),(350,'21','227','1',1,'Retail Sale Id 337',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 11:18:12','',''),(351,'21','227','1',1,'Retail Sale Id 338',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 11:23:12','',''),(352,'21','227','1',1,'Retail Sale Id 339',3496.00,0.00,0.00,4.60,0.00,'2022-06-09 11:47:54','',''),(353,'21','227','1',1,'Retail Sale Id 340',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 11:53:51','',''),(354,'21','227','1',1,'Retail Sale Id 341',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 12:02:53','',''),(355,'21','227','1',1,'Retail Sale Id 342',1520.00,0.00,0.00,2.00,0.00,'2022-06-09 12:04:30','',''),(356,'21','227','1',1,'Retail Sale Id 343',2492.80,0.00,0.00,3.28,0.00,'2022-06-09 12:06:21','',''),(357,'21','227','1',1,'Retail Sale Id 343',2492.80,0.00,0.00,3.28,0.00,'2022-06-09 12:06:21','',''),(358,'21','227','1',1,'Retail Sale Id 344',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 12:10:02','',''),(359,'21','227','1',1,'Retail Sale Id 345',995.60,0.00,0.00,1.31,0.00,'2022-06-09 12:11:33','',''),(360,'21','227','1',1,'Retail Sale Id 346',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 12:12:54','',''),(361,'21','227','1',1,'Retail Sale Id 347',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 12:16:24','',''),(362,'21','227','1',1,'Retail Sale Id 348',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 12:18:55','',''),(363,'21','227','1',1,'Retail Sale Id 349',1520.00,0.00,0.00,2.00,0.00,'2022-06-09 12:23:33','',''),(364,'21','227','1',1,'Retail Sale Id 350',494.00,0.00,0.00,0.65,0.00,'2022-06-09 12:26:36','',''),(365,'21','227','1',1,'Retail Sale Id 351',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 12:28:59','',''),(366,'21','227','1',1,'Retail Sale Id 352',760.00,0.00,0.00,1.00,0.00,'2022-06-09 12:30:35','',''),(367,'21','227','1',1,'Retail Sale Id 353',760.00,0.00,0.00,1.00,0.00,'2022-06-09 12:31:20','',''),(368,'21','227','1',1,'Retail Sale Id 354',995.60,0.00,0.00,1.31,0.00,'2022-06-09 12:41:09','',''),(369,'21','227','1',1,'Retail Sale Id 355',1520.00,0.00,0.00,2.00,0.00,'2022-06-09 12:42:30','',''),(370,'21','227','1',1,'Retail Sale Id 356',3997.60,0.00,0.00,5.26,0.00,'2022-06-09 12:47:12','',''),(371,'21','227','1',1,'Retail Sale Id 357',1398.40,0.00,0.00,1.84,0.00,'2022-06-09 12:57:19','',''),(372,'21','227','1',1,'Retail Sale Id 358',1398.40,0.00,0.00,1.84,0.00,'2022-06-09 13:15:43','',''),(373,'21','227','1',1,'Retail Sale Id 358',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 13:15:43','',''),(374,'21','227','1',1,'Retail Sale Id 359',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 13:20:03','',''),(375,'21','227','1',1,'Retail Sale Id 360',798.00,0.00,0.00,1.05,0.00,'2022-06-09 13:22:14','',''),(376,'21','227','1',1,'Retail Sale Id 361',3496.00,0.00,0.00,4.60,0.00,'2022-06-09 13:30:10','',''),(377,'21','227','1',1,'Retail Sale Id 362',798.00,0.00,0.00,1.05,0.00,'2022-06-09 13:34:55','',''),(378,'21','227','1',1,'Retail Sale Id 363',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 13:40:12','',''),(379,'21','227','1',1,'Retail Sale Id 363',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 13:40:12','',''),(380,'21','227','1',1,'Retail Sale Id 364',1520.00,0.00,0.00,2.00,0.00,'2022-06-09 13:45:20','',''),(381,'21','227','1',1,'Retail Sale Id 365',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 13:47:19','',''),(382,'21','227','1',1,'Retail Sale Id 366',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 13:58:29','',''),(383,'21','227','1',1,'Retail Sale Id 366',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 13:58:29','',''),(384,'21','227','1',1,'Retail Sale Id 367',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 14:02:12','',''),(385,'21','227','1',1,'Retail Sale Id 368',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 14:05:36','',''),(386,'21','227','1',1,'Retail Sale Id 369',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 14:11:02','',''),(387,'21','227','1',1,'Retail Sale Id 370',760.00,0.00,0.00,1.00,0.00,'2022-06-09 14:18:45','',''),(388,'21','227','1',1,'Retail Sale Id 371',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 14:34:05','',''),(389,'21','227','1',1,'Retail Sale Id 372',995.60,0.00,0.00,1.31,0.00,'2022-06-09 14:36:14','',''),(390,'21','227','1',1,'Retail Sale Id 373',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 14:37:12','',''),(391,'21','227','1',1,'Retail Sale Id 374',494.00,0.00,0.00,0.65,0.00,'2022-06-09 14:40:39','',''),(392,'21','227','1',1,'Retail Sale Id 375',995.60,0.00,0.00,1.31,0.00,'2022-06-09 14:42:19','',''),(393,'21','227','1',1,'Retail Sale Id 376',995.60,0.00,0.00,1.31,0.00,'2022-06-09 14:43:29','',''),(394,'21','227','1',1,'Retail Sale Id 377',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 14:45:41','',''),(395,'21','227','1',1,'Retail Sale Id 378',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 14:52:06','',''),(396,'21','227','1',1,'Retail Sale Id 380',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 14:58:56','',''),(397,'21','227','1',1,'Retail Sale Id 381',995.60,0.00,0.00,1.31,0.00,'2022-06-09 15:04:35','',''),(398,'21','227','1',1,'Retail Sale Id 382',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 15:11:01','',''),(399,'21','227','1',1,'Retail Sale Id 383',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 15:13:38','',''),(400,'21','227','1',1,'Retail Sale Id 384',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 15:15:01','',''),(401,'21','227','1',1,'Retail Sale Id 385',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 15:27:44','',''),(402,'21','227','1',1,'Retail Sale Id 386',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 15:29:05','',''),(403,'21','227','1',1,'Retail Sale Id 388',3997.60,0.00,0.00,5.26,0.00,'2022-06-09 16:05:30','',''),(404,'21','227','1',1,'Retail Sale Id 389',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 16:06:40','',''),(405,'21','227','1',1,'Retail Sale Id 390',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 16:13:38','',''),(406,'21','227','1',1,'Retail Sale Id 391',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 16:16:04','',''),(407,'21','227','1',1,'Retail Sale Id 392',760.00,0.00,0.00,1.00,0.00,'2022-06-09 16:18:04','',''),(408,'21','227','1',1,'Retail Sale Id 393',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 16:20:15','',''),(409,'21','227','1',1,'Retail Sale Id 394',995.60,0.00,0.00,1.31,0.00,'2022-06-09 16:21:38','',''),(410,'21','227','1',1,'Retail Sale Id 396',8998.40,0.00,0.00,11.84,0.00,'2022-06-09 16:24:29','',''),(411,'21','227','1',1,'Retail Sale Id 396',8998.40,0.00,0.00,11.84,0.00,'2022-06-09 16:24:29','',''),(412,'21','227','1',1,'Retail Sale Id 397',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 16:37:18','',''),(413,'21','227','1',1,'Retail Sale Id 398',1520.00,0.00,0.00,2.00,0.00,'2022-06-09 16:47:28','',''),(414,'21','227','1',1,'Retail Sale Id 399',995.60,0.00,0.00,1.31,0.00,'2022-06-09 16:48:53','',''),(415,'21','227','1',1,'Retail Sale Id 400',2994.40,0.00,0.00,3.94,0.00,'2022-06-09 16:50:44','',''),(416,'21','227','1',1,'Retail Sale Id 401',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 16:53:06','',''),(417,'21','227','1',1,'Retail Sale Id 402',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 17:00:29','',''),(418,'21','227','1',1,'Retail Sale Id 403',995.60,0.00,0.00,1.31,0.00,'2022-06-09 17:02:44','',''),(419,'21','227','1',1,'Retail Sale Id 404',2994.40,0.00,0.00,3.94,0.00,'2022-06-09 17:04:17','',''),(420,'21','227','1',1,'Retail Sale Id 405',995.60,0.00,0.00,1.31,0.00,'2022-06-09 17:06:46','',''),(421,'21','227','1',1,'Retail Sale Id 407',4993.20,0.00,0.00,6.57,0.00,'2022-06-09 17:12:59','',''),(422,'21','227','1',1,'Retail Sale Id 408',760.00,0.00,0.00,1.00,0.00,'2022-06-09 17:13:42','',''),(423,'21','227','1',1,'Retail Sale Id 409',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 17:14:13','',''),(424,'21','227','1',1,'Retail Sale Id 410',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 17:17:04','',''),(425,'21','227','1',1,'Retail Sale Id 411',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 17:20:18','',''),(426,'21','227','1',1,'Return of Retail Sale Id 410',0.00,2280.00,3.00,0.00,0.00,'2022-06-09 17:21:10','',''),(427,'21','227','1',1,'Retail Sale Id 412',760.00,0.00,0.00,1.00,0.00,'2022-06-09 17:29:02','',''),(428,'21','227','1',1,'Retail Sale Id 413',1193.20,0.00,0.00,1.57,0.00,'2022-06-09 17:31:46','',''),(429,'21','227','1',1,'Retail Sale Id 414',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 17:35:11','',''),(430,'21','227','1',1,'Retail Sale Id 415',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 17:36:33','',''),(431,'21','227','1',1,'Retail Sale Id 416',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 17:37:16','',''),(432,'21','227','1',1,'Retail Sale Id 417',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 17:38:05','',''),(433,'21','227','1',1,'Retail Sale Id 418',1299.60,0.00,0.00,1.71,0.00,'2022-06-09 17:42:23','',''),(434,'21','227','1',1,'Retail Sale Id 419',896.80,0.00,0.00,1.18,0.00,'2022-06-09 17:48:21','',''),(435,'21','227','1',1,'Retail Sale Id 420',995.60,0.00,0.00,1.31,0.00,'2022-06-09 17:49:28','',''),(436,'21','227','1',1,'Retail Sale Id 421',7600.00,0.00,0.00,10.00,0.00,'2022-06-09 18:01:44','',''),(437,'21','227','1',1,'Retail Sale Id 422',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 18:04:18','',''),(438,'21','227','1',1,'Retail Sale Id 423',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 18:05:41','',''),(439,'21','227','1',1,'Retail Sale Id 424',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 18:12:31','',''),(440,'21','227','1',1,'Retail Sale Id 425',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 18:13:40','',''),(441,'21','227','1',1,'Retail Sale Id 426',18240.00,0.00,0.00,24.00,0.00,'2022-06-09 18:16:44','',''),(442,'21','227','1',1,'Retail Sale Id 427',995.60,0.00,0.00,1.31,0.00,'2022-06-09 18:20:02','',''),(443,'21','227','1',1,'Retail Sale Id 428',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 18:23:18','',''),(444,'21','227','1',1,'Retail Sale Id 430',995.60,0.00,0.00,1.31,0.00,'2022-06-09 18:25:56','',''),(445,'21','227','1',1,'Retail Sale Id 431',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 18:27:45','',''),(446,'21','227','1',1,'Retail Sale Id 432',798.00,0.00,0.00,1.05,0.00,'2022-06-09 18:29:32','',''),(447,'21','227','1',1,'Retail Sale Id 433',1497.20,0.00,0.00,1.97,0.00,'2022-06-09 18:32:47','',''),(448,'21','227','1',1,'Retail Sale Id 434',995.60,0.00,0.00,1.31,0.00,'2022-06-09 18:39:27','',''),(449,'21','227','1',1,'Retail Sale Id 435',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 18:43:39','',''),(450,'21','227','1',1,'Retail Sale Id 436',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 18:45:13','',''),(451,'21','227','1',1,'Retail Sale Id 437',4993.20,0.00,0.00,6.57,0.00,'2022-06-09 18:46:07','',''),(452,'21','227','1',1,'Retail Sale Id 438',1193.20,0.00,0.00,1.57,0.00,'2022-06-09 18:48:09','',''),(453,'21','227','1',1,'Retail Sale Id 439',1193.20,0.00,0.00,1.57,0.00,'2022-06-09 18:54:36','',''),(454,'21','227','1',1,'Retail Sale Id 440',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 19:01:39','',''),(455,'21','227','1',1,'Retail Sale Id 441',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 08:20:30','',''),(456,'21','227','1',1,'Retail Sale Id 442',995.60,0.00,0.00,1.31,0.00,'2022-06-10 08:22:01','',''),(457,'21','227','1',1,'Retail Sale Id 443',2492.80,0.00,0.00,3.28,0.00,'2022-06-10 08:22:47','',''),(458,'21','227','1',1,'Retail Sale Id 444',2492.80,0.00,0.00,3.28,0.00,'2022-06-10 08:23:19','',''),(459,'21','227','1',1,'Retail Sale Id 445',3997.60,0.00,0.00,5.26,0.00,'2022-06-10 08:23:54','',''),(460,'21','227','1',1,'Retail Sale Id 446',5996.40,0.00,0.00,7.89,0.00,'2022-06-10 08:24:30','',''),(461,'21','227','1',1,'Retail Sale Id 447',2295.20,0.00,0.00,3.02,0.00,'2022-06-10 08:25:04','',''),(462,'21','227','1',1,'Retail Sale Id 448',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 08:26:08','',''),(463,'21','227','1',1,'Retail Sale Id 449',494.00,0.00,0.00,0.65,0.00,'2022-06-10 08:27:07','',''),(464,'21','227','1',1,'Retail Sale Id 450',995.60,0.00,0.00,1.31,0.00,'2022-06-10 08:27:55','',''),(465,'21','227','1',1,'Retail Sale Id 451',592.80,0.00,0.00,0.78,0.00,'2022-06-10 08:28:27','',''),(466,'21','227','1',1,'Retail Sale Id 452',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 08:28:56','',''),(467,'21','227','1',1,'Retail Sale Id 453',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 08:29:45','',''),(468,'21','227','1',1,'Retail Sale Id 453',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 08:29:45','',''),(469,'21','227','1',1,'Retail Sale Id 454',3997.60,0.00,0.00,5.26,0.00,'2022-06-10 08:31:24','',''),(470,'21','227','1',1,'Retail Sale Id 455',1900.00,0.00,0.00,2.50,0.00,'2022-06-10 08:32:31','',''),(471,'21','227','1',1,'Retail Sale Id 456',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 08:33:15','',''),(472,'21','227','1',1,'Retail Sale Id 457',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 08:45:14','',''),(473,'21','227','1',1,'Retail Sale Id 458',2295.20,0.00,0.00,3.02,0.00,'2022-06-10 09:13:15','',''),(474,'21','227','1',1,'Retail Sale Id 459',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 09:14:34','',''),(475,'21','227','1',1,'Retail Sale Id 460',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 09:15:45','',''),(476,'21','227','1',1,'Retail Sale Id 461',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 09:16:25','',''),(477,'21','227','1',1,'Retail Sale Id 462',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 09:17:02','',''),(478,'21','227','1',1,'Retail Sale Id 463',995.60,0.00,0.00,1.31,0.00,'2022-06-10 09:17:34','',''),(479,'21','227','1',1,'Retail Sale Id 464',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 09:18:02','',''),(480,'21','227','1',1,'Retail Sale Id 465',8496.80,0.00,0.00,11.18,0.00,'2022-06-10 09:33:10','',''),(481,'21','227','1',1,'Retail Sale Id 466',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 09:41:38','',''),(482,'21','227','1',1,'Retail Sale Id 467',995.60,0.00,0.00,1.31,0.00,'2022-06-10 09:42:33','',''),(483,'21','227','1',1,'Retail Sale Id 468',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 09:43:26','',''),(484,'21','227','1',1,'Retail Sale Id 469',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 09:55:28','',''),(485,'21','227','1',1,'Retail Sale Id 470',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 10:05:12','',''),(486,'21','227','1',1,'Retail Sale Id 471',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 10:06:03','',''),(487,'21','227','1',1,'Retail Sale Id 472',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 10:07:14','',''),(488,'21','227','1',1,'Retail Sale Id 473',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 10:08:20','',''),(489,'21','227','1',1,'Retail Sale Id 474',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 11:27:55','',''),(490,'21','227','1',1,'Retail Sale Id 475',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 11:28:41','',''),(491,'21','227','1',1,'Retail Sale Id 476',1900.00,0.00,0.00,2.50,0.00,'2022-06-10 11:29:40','',''),(492,'21','227','1',1,'Retail Sale Id 477',798.00,0.00,0.00,1.05,0.00,'2022-06-10 11:31:31','',''),(493,'21','227','1',1,'Retail Sale Id 478',2196.40,0.00,0.00,2.89,0.00,'2022-06-10 11:32:14','',''),(494,'21','227','1',1,'Retail Sale Id 479',995.60,0.00,0.00,1.31,0.00,'2022-06-10 11:32:48','',''),(495,'21','227','1',1,'Retail Sale Id 480',760.00,0.00,0.00,1.00,0.00,'2022-06-10 11:33:24','',''),(496,'21','227','1',1,'Retail Sale Id 481',1793.60,0.00,0.00,2.36,0.00,'2022-06-10 11:34:05','',''),(497,'21','227','1',1,'Retail Sale Id 482',995.60,0.00,0.00,1.31,0.00,'2022-06-10 11:34:39','',''),(498,'21','227','1',1,'Retail Sale Id 483',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 11:35:19','',''),(499,'21','227','1',1,'Retail Sale Id 484',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 11:36:05','',''),(500,'21','227','1',1,'Retail Sale Id 485',4993.20,0.00,0.00,6.57,0.00,'2022-06-10 11:36:40','',''),(501,'21','227','1',1,'Retail Sale Id 486',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 11:37:19','',''),(502,'21','227','1',1,'Retail Sale Id 487',4499.20,0.00,0.00,5.92,0.00,'2022-06-10 11:37:51','',''),(503,'21','227','1',1,'Retail Sale Id 488',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 11:38:24','',''),(504,'21','227','1',1,'Retail Sale Id 489',1793.60,0.00,0.00,2.36,0.00,'2022-06-10 11:39:05','',''),(505,'21','227','1',1,'Retail Sale Id 490',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 11:39:43','',''),(506,'21','227','1',1,'Retail Sale Id 491',3040.00,0.00,0.00,4.00,0.00,'2022-06-10 11:40:45','',''),(507,'21','227','1',1,'Retail Sale Id 492',995.60,0.00,0.00,1.31,0.00,'2022-06-10 11:43:05','',''),(508,'21','227','1',1,'Retail Sale Id 493',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 11:49:00','',''),(509,'21','227','1',1,'Retail Sale Id 494',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 12:02:25','',''),(510,'21','227','1',1,'Retail Sale Id 494',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 12:02:25','',''),(511,'21','227','1',1,'Retail Sale Id 495',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 12:05:02','',''),(512,'21','227','1',1,'Retail Sale Id 495',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 12:05:02','',''),(513,'21','227','1',1,'Retail Sale Id 496',995.60,0.00,0.00,1.31,0.00,'2022-06-10 12:05:56','',''),(514,'21','227','1',1,'Retail Sale Id 497',7600.00,0.00,0.00,10.00,0.00,'2022-06-10 12:06:42','',''),(515,'21','227','1',1,'Retail Sale Id 498',1596.00,0.00,0.00,2.10,0.00,'2022-06-10 12:07:55','',''),(516,'21','227','1',1,'Retail Sale Id 499',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 12:10:08','',''),(517,'21','227','1',1,'Retail Sale Id 499',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 12:10:08','',''),(518,'21','227','1',1,'Retail Sale Id 500',760.00,0.00,0.00,1.00,0.00,'2022-06-10 12:10:44','',''),(519,'21','227','1',1,'Retail Sale Id 501',6992.00,0.00,0.00,9.20,0.00,'2022-06-10 12:23:19','',''),(520,'21','227','1',1,'Retail Sale Id 502',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 12:23:48','',''),(521,'21','227','1',1,'Retail Sale Id 503',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 12:24:21','',''),(522,'21','227','1',1,'Retail Sale Id 504',235.60,0.00,0.00,0.31,0.00,'2022-06-10 12:25:38','',''),(523,'21','227','1',1,'Retail Sale Id 506',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 12:31:54','',''),(524,'21','227','1',1,'Retail Sale Id 507',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 12:35:21','',''),(525,'21','227','1',1,'Retail Sale Id 508',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 12:36:34','',''),(526,'21','227','1',1,'Retail Sale Id 509',699.20,0.00,0.00,0.92,0.00,'2022-06-10 12:46:39','',''),(527,'21','227','1',1,'Retail Sale Id 510',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 12:49:37','',''),(528,'21','227','1',1,'Retail Sale Id 511',995.60,0.00,0.00,1.31,0.00,'2022-06-10 13:46:55','',''),(529,'21','227','1',1,'Retail Sale Id 512',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 13:49:44','',''),(530,'21','227','1',1,'Retail Sale Id 513',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 13:50:29','',''),(531,'21','227','1',1,'Retail Sale Id 514',1520.00,0.00,0.00,2.00,0.00,'2022-06-10 13:51:57','',''),(532,'21','227','1',1,'Retail Sale Id 514',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 13:51:57','',''),(533,'21','227','1',1,'Retail Sale Id 514',7600.00,0.00,0.00,10.00,0.00,'2022-06-10 13:51:57','',''),(534,'21','227','1',1,'Retail Sale Id 515',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 13:52:29','',''),(535,'21','227','1',1,'Retail Sale Id 516',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 13:54:35','',''),(536,'21','227','1',1,'Retail Sale Id 517',5996.40,0.00,0.00,7.89,0.00,'2022-06-10 13:55:29','',''),(537,'21','227','1',1,'Retail Sale Id 518',494.00,0.00,0.00,0.65,0.00,'2022-06-10 14:10:02','',''),(538,'21','227','1',1,'Retail Sale Id 519',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 14:15:14','',''),(539,'21','227','1',1,'Retail Sale Id 520',1520.00,0.00,0.00,2.00,0.00,'2022-06-10 14:15:50','',''),(540,'21','227','1',1,'Retail Sale Id 521',995.60,0.00,0.00,1.31,0.00,'2022-06-10 14:16:25','',''),(541,'21','227','1',1,'Retail Sale Id 522',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 14:16:56','',''),(542,'21','227','1',1,'Retail Sale Id 523',896.80,0.00,0.00,1.18,0.00,'2022-06-10 14:19:27','',''),(543,'21','227','1',1,'Retail Sale Id 524',1520.00,0.00,0.00,2.00,0.00,'2022-06-10 14:20:17','',''),(544,'21','227','1',1,'Retail Sale Id 525',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 14:21:11','',''),(545,'21','227','1',1,'Retail Sale Id 526',798.00,0.00,0.00,1.05,0.00,'2022-06-10 14:22:00','',''),(546,'21','227','1',1,'Retail Sale Id 527',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 14:23:25','',''),(547,'21','227','1',1,'Retail Sale Id 528',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 14:24:19','',''),(548,'21','227','1',1,'Retail Sale Id 529',1520.00,0.00,0.00,2.00,0.00,'2022-06-10 14:29:59','',''),(549,'21','227','1',1,'Retail Sale Id 530',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 14:30:56','',''),(550,'21','227','1',1,'Retail Sale Id 531',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 14:33:44','',''),(551,'21','227','1',1,'Retail Sale Id 532',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 14:35:30','',''),(552,'21','227','1',1,'Retail Sale Id 533',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 14:36:16','',''),(553,'21','227','1',1,'Retail Sale Id 534',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 14:37:30','',''),(554,'21','227','1',1,'Retail Sale Id 535',3496.00,0.00,0.00,4.60,0.00,'2022-06-10 14:52:58','',''),(555,'21','227','1',1,'Retail Sale Id 536',7980.00,0.00,0.00,10.50,0.00,'2022-06-10 14:56:04','',''),(556,'21','227','1',1,'Retail Sale Id 537',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 14:58:30','',''),(557,'21','227','1',1,'Retail Sale Id 538',1520.00,0.00,0.00,2.00,0.00,'2022-06-10 15:00:21','',''),(558,'21','227','1',1,'Retail Sale Id 539',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 15:04:23','',''),(559,'21','227','1',1,'Retail Sale Id 540',4993.20,0.00,0.00,6.57,0.00,'2022-06-10 17:29:40','',''),(560,'21','227','1',1,'Retail Sale Id 541',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 17:30:44','',''),(561,'21','227','1',1,'Retail Sale Id 542',60800.00,0.00,0.00,80.00,0.00,'2022-06-10 17:33:50','',''),(562,'21','227','1',1,'Retail Sale Id 543',995.60,0.00,0.00,1.31,0.00,'2022-06-10 17:34:28','',''),(563,'21','227','1',1,'Retail Sale Id 544',995.60,0.00,0.00,1.31,0.00,'2022-06-10 17:35:28','',''),(564,'21','227','1',1,'Retail Sale Id 545',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 17:36:03','',''),(565,'21','227','1',1,'Retail Sale Id 546',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:36:39','',''),(566,'21','227','1',1,'Retail Sale Id 547',3040.00,0.00,0.00,4.00,0.00,'2022-06-10 17:37:12','',''),(567,'21','227','1',1,'Retail Sale Id 548',1398.40,0.00,0.00,1.84,0.00,'2022-06-10 17:37:59','',''),(568,'21','227','1',1,'Retail Sale Id 549',3040.00,0.00,0.00,4.00,0.00,'2022-06-10 17:38:34','',''),(569,'21','227','1',1,'Retail Sale Id 550',995.60,0.00,0.00,1.31,0.00,'2022-06-10 17:39:10','',''),(570,'21','227','1',1,'Retail Sale Id 551',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 17:40:02','',''),(571,'21','227','1',1,'Retail Sale Id 552',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:40:58','',''),(572,'21','227','1',1,'Retail Sale Id 553',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:41:44','',''),(573,'21','227','1',1,'Retail Sale Id 554',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:43:50','',''),(574,'21','227','1',1,'Retail Sale Id 554',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:43:50','',''),(575,'21','227','1',1,'Retail Sale Id 555',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:44:31','',''),(576,'21','227','1',1,'Retail Sale Id 556',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 17:45:17','',''),(577,'21','227','1',1,'Retail Sale Id 557',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:46:00','',''),(578,'21','227','1',1,'Retail Sale Id 558',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:46:52','',''),(579,'21','227','1',1,'Retail Sale Id 559',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:47:39','',''),(580,'21','227','1',1,'Retail Sale Id 559',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 17:47:39','',''),(581,'21','227','1',1,'Retail Sale Id 560',2492.80,0.00,0.00,3.28,0.00,'2022-06-10 17:49:09','',''),(582,'21','227','1',1,'Retail Sale Id 561',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 17:51:29','',''),(583,'21','227','1',1,'Retail Sale Id 562',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 17:52:00','',''),(584,'21','227','1',1,'Retail Sale Id 563',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 17:52:39','',''),(585,'21','227','1',1,'Retail Sale Id 564',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 17:53:44','',''),(586,'21','227','1',1,'Retail Sale Id 565',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 17:54:16','',''),(587,'21','227','1',1,'Retail Sale Id 566',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 17:54:50','',''),(588,'21','227','1',1,'Retail Sale Id 567',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 17:55:29','',''),(589,'21','227','1',1,'Retail Sale Id 568',1193.20,0.00,0.00,1.57,0.00,'2022-06-10 17:56:30','',''),(590,'21','227','1',1,'Retail Sale Id 569',995.60,0.00,0.00,1.31,0.00,'2022-06-10 17:57:24','',''),(591,'21','227','1',1,'Retail Sale Id 570',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 17:58:16','',''),(592,'21','227','1',1,'Retail Sale Id 571',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 17:58:59','',''),(593,'21','227','1',1,'Retail Sale Id 572',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 18:00:06','',''),(594,'21','227','1',1,'Retail Sale Id 573',995.60,0.00,0.00,1.31,0.00,'2022-06-10 18:00:51','',''),(595,'21','227','1',1,'Retail Sale Id 574',2492.80,0.00,0.00,3.28,0.00,'2022-06-10 18:01:35','',''),(596,'21','227','1',1,'Retail Sale Id 575',4993.20,0.00,0.00,6.57,0.00,'2022-06-10 18:02:18','',''),(597,'21','227','1',1,'Retail Sale Id 576',494.00,0.00,0.00,0.65,0.00,'2022-06-10 18:03:22','',''),(598,'21','227','1',1,'Retail Sale Id 576',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 18:03:22','',''),(599,'21','227','1',1,'Retail Sale Id 577',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 18:05:51','',''),(600,'21','227','1',1,'Retail Sale Id 578',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 18:10:26','',''),(601,'21','227','1',1,'Retail Sale Id 579',995.60,0.00,0.00,1.31,0.00,'2022-06-10 18:11:20','',''),(602,'21','227','1',1,'Retail Sale Id 580',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 18:14:40','',''),(603,'21','227','1',1,'Retail Sale Id 581',995.60,0.00,0.00,1.31,0.00,'2022-06-10 18:15:47','',''),(604,'21','227','1',1,'Retail Sale Id 581',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 18:15:47','',''),(605,'21','227','1',1,'Retail Sale Id 582',995.60,0.00,0.00,1.31,0.00,'2022-06-10 18:16:31','',''),(606,'21','227','1',1,'Retail Sale Id 583',798.00,0.00,0.00,1.05,0.00,'2022-06-10 18:17:36','',''),(607,'21','227','1',1,'Retail Sale Id 584',798.00,0.00,0.00,1.05,0.00,'2022-06-10 18:20:40','',''),(608,'21','227','1',1,'Retail Sale Id 585',2994.40,0.00,0.00,3.94,0.00,'2022-06-10 18:22:03','',''),(609,'21','227','1',1,'Retail Sale Id 586',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 18:25:14','',''),(610,'21','227','1',1,'Retail Sale Id 587',995.60,0.00,0.00,1.31,0.00,'2022-06-10 18:28:06','',''),(611,'21','227','1',1,'Retail Sale Id 588',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 18:43:27','',''),(612,'21','227','1',1,'Retail Sale Id 588',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 18:43:27','',''),(613,'21','227','1',1,'Retail Sale Id 589',15200.00,0.00,0.00,20.00,0.00,'2022-06-10 18:44:14','',''),(614,'21','227','1',1,'Retail Sale Id 590',11400.00,0.00,0.00,15.00,0.00,'2022-06-10 18:44:40','',''),(615,'21','227','1',1,'Retail Sale Id 591',13680.00,0.00,0.00,18.00,0.00,'2022-06-10 18:45:19','',''),(616,'21','227','1',1,'Retail Sale Id 592',16720.00,0.00,0.00,22.00,0.00,'2022-06-10 18:45:48','',''),(617,'21','227','1',1,'Retail Sale Id 593',4278.80,0.00,0.00,5.63,0.00,'2022-06-10 18:46:20','',''),(618,'21','227','1',1,'Retail Sale Id 594',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 08:45:56','',''),(619,'21','227','1',1,'Retail Sale Id 595',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 08:47:34','',''),(620,'21','227','1',1,'Retail Sale Id 596',494.00,0.00,0.00,0.65,0.00,'2022-06-11 08:48:52','',''),(621,'21','227','1',1,'Retail Sale Id 597',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 08:50:05','',''),(622,'21','227','1',1,'Retail Sale Id 598',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 08:51:35','',''),(623,'21','227','1',1,'Retail Sale Id 599',995.60,0.00,0.00,1.31,0.00,'2022-06-11 08:53:19','',''),(624,'21','227','1',1,'Retail Sale Id 600',2492.80,0.00,0.00,3.28,0.00,'2022-06-11 08:54:42','',''),(625,'21','227','1',1,'Retail Sale Id 601',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 08:56:10','',''),(626,'21','227','1',1,'Retail Sale Id 602',7995.20,0.00,0.00,10.52,0.00,'2022-06-11 08:58:39','',''),(627,'21','227','1',1,'Retail Sale Id 603',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 08:59:44','',''),(628,'21','227','1',1,'Retail Sale Id 604',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 09:01:57','',''),(629,'21','227','1',1,'Retail Sale Id 605',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 09:03:45','',''),(630,'21','227','1',1,'Retail Sale Id 606',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 09:05:22','',''),(631,'21','227','1',1,'Retail Sale Id 607',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 09:07:16','',''),(632,'21','227','1',1,'Retail Sale Id 608',4499.20,0.00,0.00,5.92,0.00,'2022-06-11 09:10:44','',''),(633,'21','227','1',1,'Retail Sale Id 609',2492.80,0.00,0.00,3.28,0.00,'2022-06-11 09:14:08','',''),(634,'21','227','1',1,'Retail Sale Id 610',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 09:15:42','',''),(635,'21','227','1',1,'Retail Sale Id 611',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 09:16:46','',''),(636,'21','227','1',1,'Retail Sale Id 613',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 09:20:38','',''),(637,'21','227','1',1,'Retail Sale Id 614',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 09:22:37','',''),(638,'21','227','1',1,'Retail Sale Id 616',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 09:24:04','',''),(639,'21','227','1',1,'Retail Sale Id 617',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 09:26:36','',''),(640,'21','227','1',1,'Retail Sale Id 618',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 09:28:00','',''),(641,'21','227','1',1,'Retail Sale Id 619',995.60,0.00,0.00,1.31,0.00,'2022-06-11 09:29:10','',''),(642,'21','227','1',1,'Retail Sale Id 620',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 09:30:23','',''),(643,'21','227','1',1,'Retail Sale Id 621',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 09:34:56','',''),(644,'21','227','1',1,'Retail Sale Id 622',7995.20,0.00,0.00,10.52,0.00,'2022-06-11 09:37:16','',''),(645,'21','227','1',1,'Retail Sale Id 623',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 09:38:55','',''),(646,'21','227','1',1,'Retail Sale Id 624',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 09:42:14','',''),(647,'21','227','1',1,'Retail Sale Id 625',760.00,0.00,0.00,1.00,0.00,'2022-06-11 09:46:32','',''),(648,'21','227','1',1,'Retail Sale Id 626',2492.80,0.00,0.00,3.28,0.00,'2022-06-11 09:48:35','',''),(649,'21','227','1',1,'Retail Sale Id 627',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 09:49:41','',''),(650,'21','227','1',1,'Retail Sale Id 628',760.00,0.00,0.00,1.00,0.00,'2022-06-11 09:50:59','',''),(651,'21','227','1',1,'Retail Sale Id 629',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 09:55:00','',''),(652,'21','227','1',1,'Retail Sale Id 630',995.60,0.00,0.00,1.31,0.00,'2022-06-11 09:56:23','',''),(653,'21','227','1',1,'Retail Sale Id 631',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 09:57:21','',''),(654,'21','227','1',1,'Retail Sale Id 632',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 10:01:25','',''),(655,'21','227','1',1,'Retail Sale Id 632',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 10:01:25','',''),(656,'21','227','1',1,'Retail Sale Id 1114',760.00,0.00,0.00,1.00,0.00,'2022-06-11 10:32:07','',''),(657,'21','227','1',1,'Retail Sale Id 1115',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 10:33:40','',''),(658,'21','227','1',1,'Retail Sale Id 1116',149720.00,0.00,0.00,197.00,0.00,'2022-06-11 10:34:41','',''),(659,'21','227','1',1,'Retail Sale Id 1117',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 10:36:55','',''),(660,'21','227','1',1,'Retail Sale Id 1118',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 12:06:02','',''),(661,'21','227','1',1,'Retail Sale Id 1119',6999.60,0.00,0.00,9.21,0.00,'2022-06-11 12:11:05','',''),(662,'21','227','1',1,'Retail Sale Id 1120',798.00,0.00,0.00,1.05,0.00,'2022-06-11 12:14:58','',''),(663,'21','227','1',1,'Retail Sale Id 1121',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 12:16:01','',''),(664,'21','227','1',1,'Retail Sale Id 1122',798.00,0.00,0.00,1.05,0.00,'2022-06-11 12:17:05','',''),(665,'21','227','1',1,'Retail Sale Id 1123',699.20,0.00,0.00,0.92,0.00,'2022-06-11 12:19:00','',''),(666,'21','227','1',1,'Retail Sale Id 1124',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 12:20:58','',''),(667,'21','227','1',1,'Retail Sale Id 1125',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 12:22:05','',''),(668,'21','227','1',1,'Retail Sale Id 1126',3496.00,0.00,0.00,4.60,0.00,'2022-06-11 12:24:49','',''),(669,'21','227','1',1,'Retail Sale Id 1127',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 12:26:25','',''),(670,'21','227','1',1,'Retail Sale Id 1128',995.60,0.00,0.00,1.31,0.00,'2022-06-11 12:27:28','',''),(671,'21','227','1',1,'Retail Sale Id 1129',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 12:36:09','',''),(672,'21','227','1',1,'Retail Sale Id 1130',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 13:43:13','',''),(673,'21','227','1',1,'Retail Sale Id 1131',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 13:48:12','',''),(674,'21','227','1',1,'Retail Sale Id 1132',760.00,0.00,0.00,1.00,0.00,'2022-06-11 14:12:46','',''),(675,'21','227','1',1,'Retail Sale Id 1133',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 14:56:34','',''),(676,'21','227','1',1,'Retail Sale Id 1134',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 14:58:27','',''),(677,'21','227','1',1,'Retail Sale Id 1135',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 14:59:51','',''),(678,'21','227','1',1,'Retail Sale Id 1136',995.60,0.00,0.00,1.31,0.00,'2022-06-11 15:01:04','',''),(679,'21','227','1',1,'Retail Sale Id 1137',3496.00,0.00,0.00,4.60,0.00,'2022-06-11 15:07:29','',''),(680,'21','227','1',1,'Retail Sale Id 1138',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 15:09:54','',''),(681,'21','227','1',1,'Retail Sale Id 1139',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 15:15:43','',''),(682,'21','227','1',1,'Retail Sale Id 1140',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 15:16:51','',''),(683,'21','227','1',1,'Retail Sale Id 1141',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 15:17:53','',''),(684,'21','227','1',1,'Retail Sale Id 1142',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 15:19:03','',''),(685,'21','227','1',1,'Retail Sale Id 1143',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 15:21:28','',''),(686,'21','227','1',1,'Retail Sale Id 1144',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 15:22:27','',''),(687,'21','227','1',1,'Retail Sale Id 1145',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 15:24:27','',''),(688,'21','227','1',1,'Retail Sale Id 1146',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 15:46:19','',''),(689,'21','227','1',1,'Retail Sale Id 1147',995.60,0.00,0.00,1.31,0.00,'2022-06-11 15:48:32','',''),(690,'21','227','1',1,'Retail Sale Id 1148',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 15:58:27','',''),(691,'21','227','1',1,'Retail Sale Id 1149',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 16:08:32','',''),(692,'21','227','1',1,'Retail Sale Id 1150',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:26:26','',''),(693,'21','227','1',1,'Retail Sale Id 1151',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 16:28:21','',''),(694,'21','227','1',1,'Retail Sale Id 1152',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:42:38','',''),(695,'21','227','1',1,'Retail Sale Id 1153',11400.00,0.00,0.00,15.00,0.00,'2022-06-11 16:54:57','',''),(696,'21','227','1',1,'Retail Sale Id 1154',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:55:56','',''),(697,'21','227','1',1,'Retail Sale Id 1155',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 16:57:07','',''),(698,'21','227','1',1,'Retail Sale Id 1156',760.00,0.00,0.00,1.00,0.00,'2022-06-11 16:59:47','',''),(699,'21','227','1',1,'Retail Sale Id 1157',760.00,0.00,0.00,1.00,0.00,'2022-06-11 17:02:02','',''),(700,'21','227','1',1,'Retail Sale Id 1158',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 17:02:35','',''),(701,'21','227','1',1,'Retail Sale Id 1159',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 17:06:14','',''),(702,'21','227','1',1,'Retail Sale Id 1160',995.60,0.00,0.00,1.31,0.00,'2022-06-11 17:07:20','',''),(703,'21','227','1',1,'Retail Sale Id 1161',7995.20,0.00,0.00,10.52,0.00,'2022-06-11 17:11:53','',''),(704,'21','227','1',1,'Retail Sale Id 1162',1193.20,0.00,0.00,1.57,0.00,'2022-06-11 17:13:42','',''),(705,'21','227','1',1,'Retail Sale Id 1162',1193.20,0.00,0.00,1.57,0.00,'2022-06-11 17:13:42','',''),(706,'21','227','1',1,'Retail Sale Id 1163',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 17:14:44','',''),(707,'21','227','1',1,'Retail Sale Id 1164',494.00,0.00,0.00,0.65,0.00,'2022-06-11 17:15:46','',''),(708,'21','227','1',1,'Retail Sale Id 1165',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 17:16:59','',''),(709,'21','227','1',1,'Retail Sale Id 1166',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 17:19:37','',''),(710,'21','227','1',1,'Retail Sale Id 1167',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 17:23:29','',''),(711,'21','227','1',1,'Retail Sale Id 1168',38000.00,0.00,0.00,50.00,0.00,'2022-06-11 17:31:39','',''),(712,'21','227','1',1,'Retail Sale Id 1169',425.60,0.00,0.00,0.56,0.00,'2022-06-11 17:36:05','',''),(713,'21','227','1',1,'Retail Sale Id 1170',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 17:36:49','',''),(714,'21','227','1',1,'Retail Sale Id 1171',699.20,0.00,0.00,0.92,0.00,'2022-06-11 17:38:08','',''),(715,'21','227','1',1,'Retail Sale Id 1172',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 17:38:54','',''),(716,'21','227','1',1,'Retail Sale Id 1173',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 17:40:23','',''),(717,'21','227','1',1,'Retail Sale Id 1174',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 17:46:57','',''),(718,'21','227','1',1,'Retail Sale Id 1175',2994.40,0.00,0.00,3.94,0.00,'2022-06-11 17:47:49','',''),(719,'21','227','1',1,'Retail Sale Id 1176',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 17:48:48','',''),(720,'21','227','1',1,'Retail Sale Id 1177',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 17:50:15','',''),(721,'21','227','1',1,'Retail Sale Id 1178',995.60,0.00,0.00,1.31,0.00,'2022-06-11 18:00:56','',''),(722,'21','227','1',1,'Retail Sale Id 1179',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 18:02:22','',''),(723,'21','227','1',1,'Retail Sale Id 1180',995.60,0.00,0.00,1.31,0.00,'2022-06-11 18:04:02','',''),(724,'21','227','1',1,'Retail Sale Id 1181',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 18:05:35','',''),(725,'21','227','1',1,'Retail Sale Id 1182',7600.00,0.00,0.00,10.00,0.00,'2022-06-11 18:06:49','',''),(726,'21','227','1',1,'Retail Sale Id 1183',995.60,0.00,0.00,1.31,0.00,'2022-06-11 18:10:10','',''),(727,'21','227','1',1,'Retail Sale Id 1184',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 18:10:47','',''),(728,'21','227','1',1,'Retail Sale Id 1185',798.00,0.00,0.00,1.05,0.00,'2022-06-11 18:11:42','',''),(729,'21','227','1',1,'Retail Sale Id 1186',7600.00,0.00,0.00,10.00,0.00,'2022-06-11 18:14:54','',''),(730,'21','227','1',1,'Retail Sale Id 1187',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 18:16:21','',''),(731,'21','227','1',1,'Retail Sale Id 1187',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 18:16:21','',''),(732,'21','227','1',1,'Retail Sale Id 1188',798.00,0.00,0.00,1.05,0.00,'2022-06-11 18:17:14','',''),(733,'21','227','1',1,'Retail Sale Id 1189',4993.20,0.00,0.00,6.57,0.00,'2022-06-11 18:19:14','',''),(734,'21','227','1',1,'Retail Sale Id 1190',2196.40,0.00,0.00,2.89,0.00,'2022-06-11 18:21:20','',''),(735,'21','227','1',1,'Retail Sale Id 1191',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 18:23:21','',''),(736,'21','227','1',1,'Retail Sale Id 1192',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 18:26:21','',''),(737,'21','227','1',1,'Retail Sale Id 1193',2796.80,0.00,0.00,3.68,0.00,'2022-06-11 18:31:29','',''),(738,'21','227','1',1,'Retail Sale Id 1194',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 18:33:11','',''),(739,'21','227','1',1,'Retail Sale Id 1195',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 18:34:15','',''),(740,'21','227','1',1,'Retail Sale Id 1196',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 18:36:51','',''),(741,'21','227','1',1,'Retail Sale Id 1197',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 18:39:30','',''),(742,'21','227','1',1,'Retail Sale Id 1198',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 18:40:43','',''),(743,'21','227','1',1,'Retail Sale Id 1199',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 18:45:02','',''),(744,'21','227','1',1,'Retail Sale Id 1200',2196.40,0.00,0.00,2.89,0.00,'2022-06-11 18:49:43','',''),(745,'21','227','1',1,'Retail Sale Id 1201',1520.00,0.00,0.00,2.00,0.00,'2022-06-12 16:32:17','',''),(746,'21','227','1',1,'Retail Sale Id 1202',33994.80,0.00,0.00,44.73,0.00,'2022-06-12 16:33:33','',''),(747,'21','227','1',1,'Retail Sale Id 1203',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 16:34:01','',''),(748,'21','227','1',1,'Retail Sale Id 1204',7600.00,0.00,0.00,10.00,0.00,'2022-06-12 16:34:40','',''),(749,'21','227','1',1,'Retail Sale Id 1205',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 16:35:09','',''),(750,'21','227','1',1,'Retail Sale Id 1206',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 16:35:39','',''),(751,'21','227','1',1,'Retail Sale Id 1207',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 16:36:11','',''),(752,'21','227','1',1,'Retail Sale Id 1208',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 16:36:43','',''),(753,'21','227','1',1,'Retail Sale Id 1209',995.60,0.00,0.00,1.31,0.00,'2022-06-12 16:37:15','',''),(754,'21','227','1',1,'Retail Sale Id 1210',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 16:38:00','',''),(755,'21','227','1',1,'Retail Sale Id 1211',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 16:38:35','',''),(756,'21','227','1',1,'Retail Sale Id 1212',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 16:39:05','',''),(757,'21','227','1',1,'Retail Sale Id 1213',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 16:39:35','',''),(758,'21','227','1',1,'Retail Sale Id 1214',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 16:40:26','',''),(759,'21','227','1',1,'Retail Sale Id 1215',3040.00,0.00,0.00,4.00,0.00,'2022-06-12 16:41:02','',''),(760,'21','227','1',1,'Retail Sale Id 1216',995.60,0.00,0.00,1.31,0.00,'2022-06-12 16:42:19','',''),(761,'21','227','1',1,'Retail Sale Id 1217',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 16:43:57','',''),(762,'21','227','1',1,'Retail Sale Id 1218',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 16:44:25','',''),(763,'21','227','1',1,'Retail Sale Id 1219',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 16:44:56','',''),(764,'21','227','1',1,'Retail Sale Id 1220',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 16:45:22','',''),(765,'21','227','1',1,'Retail Sale Id 1221',699.20,0.00,0.00,0.92,0.00,'2022-06-12 16:45:52','',''),(766,'21','227','1',1,'Retail Sale Id 1222',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 16:46:26','',''),(767,'21','227','1',1,'Retail Sale Id 1223',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 16:47:12','',''),(768,'21','227','1',1,'Retail Sale Id 1224',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 16:47:55','',''),(769,'21','227','1',1,'Retail Sale Id 1225',1900.00,0.00,0.00,2.50,0.00,'2022-06-12 16:49:14','',''),(770,'21','227','1',1,'Retail Sale Id 1226',995.60,0.00,0.00,1.31,0.00,'2022-06-12 16:49:48','',''),(771,'21','227','1',1,'Retail Sale Id 1227',4499.20,0.00,0.00,5.92,0.00,'2022-06-12 16:50:25','',''),(772,'21','227','1',1,'Retail Sale Id 1228',760.00,0.00,0.00,1.00,0.00,'2022-06-12 16:51:00','',''),(773,'21','227','1',1,'Retail Sale Id 1229',995.60,0.00,0.00,1.31,0.00,'2022-06-12 16:54:14','',''),(774,'21','227','1',1,'Retail Sale Id 1230',1193.20,0.00,0.00,1.57,0.00,'2022-06-12 16:54:44','',''),(775,'21','227','1',1,'Retail Sale Id 1231',995.60,0.00,0.00,1.31,0.00,'2022-06-12 16:55:18','',''),(776,'21','227','1',1,'Retail Sale Id 1232',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 16:55:57','',''),(777,'21','227','1',1,'Retail Sale Id 1233',995.60,0.00,0.00,1.31,0.00,'2022-06-12 16:56:38','',''),(778,'21','227','1',1,'Retail Sale Id 1234',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 16:57:24','',''),(779,'21','227','1',1,'Retail Sale Id 1235',760.00,0.00,0.00,1.00,0.00,'2022-06-12 16:58:03','',''),(780,'21','227','1',1,'Retail Sale Id 1236',2295.20,0.00,0.00,3.02,0.00,'2022-06-12 16:58:43','',''),(781,'21','227','1',1,'Retail Sale Id 1237',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 16:59:25','',''),(782,'21','227','1',1,'Retail Sale Id 1238',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 16:59:54','',''),(783,'21','227','1',1,'Retail Sale Id 1239',760.00,0.00,0.00,1.00,0.00,'2022-06-12 17:00:19','',''),(784,'21','227','1',1,'Retail Sale Id 1240',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:00:48','',''),(785,'21','227','1',1,'Retail Sale Id 1241',7600.00,0.00,0.00,10.00,0.00,'2022-06-12 17:01:19','',''),(786,'21','227','1',1,'Retail Sale Id 1242',4499.20,0.00,0.00,5.92,0.00,'2022-06-12 17:01:54','',''),(787,'21','227','1',1,'Retail Sale Id 1243',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 17:02:34','',''),(788,'21','227','1',1,'Retail Sale Id 1244',7600.00,0.00,0.00,10.00,0.00,'2022-06-12 17:03:06','',''),(789,'21','227','1',1,'Retail Sale Id 1245',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:03:33','',''),(790,'21','227','1',1,'Retail Sale Id 1246',2492.80,0.00,0.00,3.28,0.00,'2022-06-12 17:04:24','',''),(791,'21','227','1',1,'Retail Sale Id 1247',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 17:05:07','',''),(792,'21','227','1',1,'Retail Sale Id 1248',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 17:05:51','',''),(793,'21','227','1',1,'Retail Sale Id 1249',4256.00,0.00,0.00,5.60,0.00,'2022-06-12 17:08:53','',''),(794,'21','227','1',1,'Retail Sale Id 1250',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 17:10:26','',''),(795,'21','227','1',1,'Retail Sale Id 1251',2492.80,0.00,0.00,3.28,0.00,'2022-06-12 17:10:57','',''),(796,'21','227','1',1,'Retail Sale Id 1252',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:11:45','',''),(797,'21','227','1',1,'Retail Sale Id 1253',1520.00,0.00,0.00,2.00,0.00,'2022-06-12 17:12:43','',''),(798,'21','227','1',1,'Retail Sale Id 1254',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 17:13:33','',''),(799,'21','227','1',1,'Retail Sale Id 1255',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:14:14','',''),(800,'21','227','1',1,'Retail Sale Id 1256',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:14:53','',''),(801,'21','227','1',1,'Retail Sale Id 1257',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 17:15:39','',''),(802,'21','227','1',1,'Retail Sale Id 1258',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 17:16:23','',''),(803,'21','227','1',1,'Retail Sale Id 1259',1299.60,0.00,0.00,1.71,0.00,'2022-06-12 17:16:56','',''),(804,'21','227','1',1,'Retail Sale Id 1260',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 17:17:31','',''),(805,'21','227','1',1,'Retail Sale Id 1261',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 17:17:57','',''),(806,'21','227','1',1,'Retail Sale Id 1262',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:18:29','',''),(807,'21','227','1',1,'Retail Sale Id 1263',760.00,0.00,0.00,1.00,0.00,'2022-06-12 17:19:04','',''),(808,'21','227','1',1,'Retail Sale Id 1264',1694.80,0.00,0.00,2.23,0.00,'2022-06-12 17:19:34','',''),(809,'21','227','1',1,'Retail Sale Id 1265',13999.20,0.00,0.00,18.42,0.00,'2022-06-12 17:20:08','',''),(810,'21','227','1',1,'Retail Sale Id 1266',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 17:20:40','',''),(811,'21','227','1',1,'Retail Sale Id 1267',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 17:21:10','',''),(812,'21','227','1',1,'Retail Sale Id 1268',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:21:44','',''),(813,'21','227','1',1,'Retail Sale Id 1269',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 17:22:22','',''),(814,'21','227','1',1,'Retail Sale Id 1270',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 17:22:59','',''),(815,'21','227','1',1,'Retail Sale Id 1271',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 17:24:17','',''),(816,'21','227','1',1,'Retail Sale Id 1272',3997.60,0.00,0.00,5.26,0.00,'2022-06-12 17:25:03','',''),(817,'21','227','1',1,'Retail Sale Id 1273',798.00,0.00,0.00,1.05,0.00,'2022-06-12 17:25:40','',''),(818,'21','227','1',1,'Retail Sale Id 1274',19000.00,0.00,0.00,25.00,0.00,'2022-06-12 17:26:29','',''),(819,'21','227','1',1,'Retail Sale Id 1275',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 17:27:37','',''),(820,'21','227','1',1,'Retail Sale Id 1276',494.00,0.00,0.00,0.65,0.00,'2022-06-12 17:28:20','',''),(821,'21','227','1',1,'Retail Sale Id 1277',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:28:59','',''),(822,'21','227','1',1,'Retail Sale Id 1278',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 17:29:44','',''),(823,'21','227','1',1,'Retail Sale Id 1279',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:30:26','',''),(824,'21','227','1',1,'Retail Sale Id 1280',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 17:31:56','',''),(825,'21','227','1',1,'Retail Sale Id 1281',494.00,0.00,0.00,0.65,0.00,'2022-06-12 17:32:41','',''),(826,'21','227','1',1,'Retail Sale Id 1282',1793.60,0.00,0.00,2.36,0.00,'2022-06-12 17:33:20','',''),(827,'21','227','1',1,'Retail Sale Id 1283',494.00,0.00,0.00,0.65,0.00,'2022-06-12 17:34:13','',''),(828,'21','227','1',1,'Retail Sale Id 1284',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:34:42','',''),(829,'21','227','1',1,'Retail Sale Id 1285',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:35:30','',''),(830,'21','227','1',1,'Retail Sale Id 1286',6992.00,0.00,0.00,9.20,0.00,'2022-06-12 17:35:59','',''),(831,'21','227','1',1,'Retail Sale Id 1287',2796.80,0.00,0.00,3.68,0.00,'2022-06-12 17:36:26','',''),(832,'21','227','1',1,'Retail Sale Id 1288',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 17:37:09','',''),(833,'21','227','1',1,'Retail Sale Id 1289',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:37:59','',''),(834,'21','227','1',1,'Retail Sale Id 1290',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:38:52','',''),(835,'21','227','1',1,'Retail Sale Id 1291',760.00,0.00,0.00,1.00,0.00,'2022-06-12 17:39:28','',''),(836,'21','227','1',1,'Retail Sale Id 1292',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:40:13','',''),(837,'21','227','1',1,'Retail Sale Id 1293',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 17:40:46','',''),(838,'21','227','1',1,'Retail Sale Id 1294',3997.60,0.00,0.00,5.26,0.00,'2022-06-12 17:41:19','',''),(839,'21','227','1',1,'Retail Sale Id 1295',3997.60,0.00,0.00,5.26,0.00,'2022-06-12 17:42:22','',''),(840,'21','227','1',1,'Retail Sale Id 1296',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 17:42:53','',''),(841,'21','227','1',1,'Retail Sale Id 1297',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 17:43:25','',''),(842,'21','227','1',1,'Retail Sale Id 1298',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:43:55','',''),(843,'21','227','1',1,'Retail Sale Id 1299',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:44:31','',''),(844,'21','227','1',1,'Retail Sale Id 1300',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 17:45:02','',''),(845,'21','227','1',1,'Retail Sale Id 1301',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 17:45:43','',''),(846,'21','227','1',1,'Retail Sale Id 1302',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:46:21','',''),(847,'21','227','1',1,'Retail Sale Id 1303',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 17:46:55','',''),(848,'21','227','1',1,'Retail Sale Id 1304',995.60,0.00,0.00,1.31,0.00,'2022-06-12 17:47:41','',''),(849,'21','227','1',1,'Retail Sale Id 1305',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:48:09','',''),(850,'21','227','1',1,'Retail Sale Id 1306',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:48:41','',''),(851,'21','227','1',1,'Retail Sale Id 1307',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:49:15','',''),(852,'21','227','1',1,'Retail Sale Id 1308',4993.20,0.00,0.00,6.57,0.00,'2022-06-12 17:55:19','',''),(853,'21','227','1',1,'Retail Sale Id 1309',592.80,0.00,0.00,0.78,0.00,'2022-06-12 17:55:56','',''),(854,'21','227','1',1,'Retail Sale Id 1310',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 17:56:37','',''),(855,'21','227','1',1,'Retail Sale Id 1311',2492.80,0.00,0.00,3.28,0.00,'2022-06-12 17:57:11','',''),(856,'21','227','1',1,'Retail Sale Id 1312',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 17:57:54','',''),(857,'21','227','1',1,'Retail Sale Id 1313',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 17:58:20','',''),(858,'21','227','1',1,'Retail Sale Id 1314',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 17:58:48','',''),(859,'21','227','1',1,'Retail Sale Id 1315',7600.00,0.00,0.00,10.00,0.00,'2022-06-12 17:59:16','',''),(860,'21','227','1',1,'Retail Sale Id 1316',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 17:59:42','',''),(861,'21','227','1',1,'Retail Sale Id 1317',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 18:00:06','',''),(862,'21','227','1',1,'Retail Sale Id 1318',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 18:00:39','',''),(863,'21','227','1',1,'Retail Sale Id 1319',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 18:01:07','',''),(864,'21','227','1',1,'Retail Sale Id 1320',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 18:01:36','',''),(865,'21','227','1',1,'Retail Sale Id 1321',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 18:02:09','',''),(866,'21','227','1',1,'Retail Sale Id 1322',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:02:40','',''),(867,'21','227','1',1,'Retail Sale Id 1323',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 18:03:10','',''),(868,'21','227','1',1,'Retail Sale Id 1324',3997.60,0.00,0.00,5.26,0.00,'2022-06-12 18:03:58','',''),(869,'21','227','1',1,'Retail Sale Id 1325',1793.60,0.00,0.00,2.36,0.00,'2022-06-12 18:04:45','',''),(870,'21','227','1',1,'Retail Sale Id 1326',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:05:18','',''),(871,'21','227','1',1,'Retail Sale Id 1327',14994.80,0.00,0.00,19.73,0.00,'2022-06-12 18:05:47','',''),(872,'21','227','1',1,'Retail Sale Id 1328',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 18:06:17','',''),(873,'21','227','1',1,'Retail Sale Id 1329',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 18:06:47','',''),(874,'21','227','1',1,'Retail Sale Id 1330',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:07:10','',''),(875,'21','227','1',1,'Retail Sale Id 1331',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 18:07:34','',''),(876,'21','227','1',1,'Retail Sale Id 1332',760.00,0.00,0.00,1.00,0.00,'2022-06-12 18:08:02','',''),(877,'21','227','1',1,'Retail Sale Id 1333',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 18:08:43','',''),(878,'21','227','1',1,'Retail Sale Id 1334',896.80,0.00,0.00,1.18,0.00,'2022-06-12 18:09:30','',''),(879,'21','227','1',1,'Retail Sale Id 1335',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:10:08','',''),(880,'21','227','1',1,'Retail Sale Id 1336',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 18:10:41','',''),(881,'21','227','1',1,'Retail Sale Id 1337',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 18:11:21','',''),(882,'21','227','1',1,'Retail Sale Id 1338',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 18:12:13','',''),(883,'21','227','1',1,'Retail Sale Id 1339',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:12:46','',''),(884,'21','227','1',1,'Retail Sale Id 1340',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:13:36','',''),(885,'21','227','1',1,'Retail Sale Id 1341',6794.40,0.00,0.00,8.94,0.00,'2022-06-12 18:14:12','',''),(886,'21','227','1',1,'Retail Sale Id 1342',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 18:14:46','',''),(887,'21','227','1',1,'Retail Sale Id 1343',2994.40,0.00,0.00,3.94,0.00,'2022-06-12 18:15:25','',''),(888,'21','227','1',1,'Retail Sale Id 1344',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 18:15:55','',''),(889,'21','227','1',1,'Retail Sale Id 1345',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:16:39','',''),(890,'21','227','1',1,'Retail Sale Id 1346',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:17:10','',''),(891,'21','227','1',1,'Retail Sale Id 1347',798.00,0.00,0.00,1.05,0.00,'2022-06-12 18:17:44','',''),(892,'21','227','1',1,'Retail Sale Id 1348',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:23:03','',''),(893,'21','227','1',1,'Retail Sale Id 1349',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:30:34','',''),(894,'21','227','1',1,'Retail Sale Id 1350',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 18:31:25','',''),(895,'21','227','1',1,'Retail Sale Id 1351',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 18:32:39','',''),(896,'21','227','1',1,'Retail Sale Id 1352',1193.20,0.00,0.00,1.57,0.00,'2022-06-12 18:34:04','',''),(897,'21','227','1',1,'Retail Sale Id 1353',995.60,0.00,0.00,1.31,0.00,'2022-06-12 18:35:15','',''),(898,'21','227','1',1,'Retail Sale Id 1354',760.00,0.00,0.00,1.00,0.00,'2022-06-12 18:37:49','',''),(899,'21','227','1',1,'Retail Sale Id 1355',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 18:39:13','',''),(900,'21','227','1',1,'Retail Sale Id 1356',760.00,0.00,0.00,1.00,0.00,'2022-06-12 18:52:29','',''),(901,'21','227','1',1,'Retail Sale Id 1357',1193.20,0.00,0.00,1.57,0.00,'2022-06-13 16:42:27','',''),(902,'21','227','1',1,'Retail Sale Id 1358',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 16:42:57','',''),(903,'21','227','1',1,'Retail Sale Id 1359',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 16:43:36','',''),(904,'21','227','1',1,'Retail Sale Id 1360',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 16:44:06','',''),(905,'21','227','1',1,'Retail Sale Id 1361',7600.00,0.00,0.00,10.00,0.00,'2022-06-13 16:44:42','',''),(906,'21','227','1',1,'Retail Sale Id 1362',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 16:45:20','',''),(907,'21','227','1',1,'Retail Sale Id 1363',3800.00,0.00,0.00,5.00,0.00,'2022-06-13 16:45:51','',''),(908,'21','227','1',1,'Retail Sale Id 1364',7600.00,0.00,0.00,10.00,0.00,'2022-06-13 16:46:26','',''),(909,'21','227','1',1,'Retail Sale Id 1365',1398.40,0.00,0.00,1.84,0.00,'2022-06-13 16:47:08','',''),(910,'21','227','1',1,'Retail Sale Id 1366',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 16:47:37','',''),(911,'21','227','1',1,'Retail Sale Id 1367',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 16:48:05','',''),(912,'21','227','1',1,'Retail Sale Id 1368',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 16:48:34','',''),(913,'21','227','1',1,'Retail Sale Id 1369',995.60,0.00,0.00,1.31,0.00,'2022-06-13 16:49:06','',''),(914,'21','227','1',1,'Retail Sale Id 1370',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 16:49:44','',''),(915,'21','227','1',1,'Retail Sale Id 1371',3800.00,0.00,0.00,5.00,0.00,'2022-06-13 16:50:08','',''),(916,'21','227','1',1,'Retail Sale Id 1372',3800.00,0.00,0.00,5.00,0.00,'2022-06-13 16:50:37','',''),(917,'21','227','1',1,'Retail Sale Id 1373',7600.00,0.00,0.00,10.00,0.00,'2022-06-13 16:51:04','',''),(918,'21','227','1',1,'Retail Sale Id 1374',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 16:51:31','',''),(919,'21','227','1',1,'Retail Sale Id 1375',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 16:52:06','',''),(920,'21','227','1',1,'Retail Sale Id 1376',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 16:52:33','',''),(921,'21','227','1',1,'Retail Sale Id 1377',2994.40,0.00,0.00,3.94,0.00,'2022-06-13 16:53:01','',''),(922,'21','227','1',1,'Retail Sale Id 1378',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 16:53:28','',''),(923,'21','227','1',1,'Retail Sale Id 1379',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 16:53:56','',''),(924,'21','227','1',1,'Retail Sale Id 1380',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 16:54:26','',''),(925,'21','227','1',1,'Retail Sale Id 1381',995.60,0.00,0.00,1.31,0.00,'2022-06-13 16:54:56','',''),(926,'21','227','1',1,'Retail Sale Id 1382',995.60,0.00,0.00,1.31,0.00,'2022-06-13 16:55:42','',''),(927,'21','227','1',1,'Retail Sale Id 1383',896.80,0.00,0.00,1.18,0.00,'2022-06-13 16:56:12','',''),(928,'21','227','1',1,'Retail Sale Id 1384',5996.40,0.00,0.00,7.89,0.00,'2022-06-13 16:56:43','',''),(929,'21','227','1',1,'Retail Sale Id 1385',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 16:57:24','',''),(930,'21','227','1',1,'Retail Sale Id 1386',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 16:58:01','',''),(931,'21','227','1',1,'Retail Sale Id 1387',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 16:58:50','',''),(932,'21','227','1',1,'Retail Sale Id 1388',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 16:59:19','',''),(933,'21','227','1',1,'Retail Sale Id 1389',3040.00,0.00,0.00,4.00,0.00,'2022-06-13 16:59:45','',''),(934,'21','227','1',1,'Retail Sale Id 1390',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 17:00:36','',''),(935,'21','227','1',1,'Retail Sale Id 1391',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 17:01:23','',''),(936,'21','227','1',1,'Retail Sale Id 1392',798.00,0.00,0.00,1.05,0.00,'2022-06-13 17:01:56','',''),(937,'21','227','1',1,'Retail Sale Id 1393',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 17:02:22','',''),(938,'21','227','1',1,'Retail Sale Id 1394',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 17:02:53','',''),(939,'21','227','1',1,'Retail Sale Id 1395',3800.00,0.00,0.00,5.00,0.00,'2022-06-13 17:03:24','',''),(940,'21','227','1',1,'Retail Sale Id 1396',7600.00,0.00,0.00,10.00,0.00,'2022-06-13 17:03:48','',''),(941,'21','227','1',1,'Retail Sale Id 1397',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 17:04:16','',''),(942,'21','227','1',1,'Retail Sale Id 1398',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:04:46','',''),(943,'21','227','1',1,'Retail Sale Id 1399',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 17:05:17','',''),(944,'21','227','1',1,'Retail Sale Id 1400',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:19:45','',''),(945,'21','227','1',1,'Retail Sale Id 1401',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 17:20:16','',''),(946,'21','227','1',1,'Retail Sale Id 1402',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:20:43','',''),(947,'21','227','1',1,'Retail Sale Id 1403',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 17:21:09','',''),(948,'21','227','1',1,'Retail Sale Id 1404',3496.00,0.00,0.00,4.60,0.00,'2022-06-13 17:21:54','',''),(949,'21','227','1',1,'Retail Sale Id 1405',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:22:22','',''),(950,'21','227','1',1,'Retail Sale Id 1406',995.60,0.00,0.00,1.31,0.00,'2022-06-13 17:22:55','',''),(951,'21','227','1',1,'Retail Sale Id 1407',4993.20,0.00,0.00,6.57,0.00,'2022-06-13 17:23:24','',''),(952,'21','227','1',1,'Retail Sale Id 1408',995.60,0.00,0.00,1.31,0.00,'2022-06-13 17:23:53','',''),(953,'21','227','1',1,'Retail Sale Id 1409',6498.00,0.00,0.00,8.55,0.00,'2022-06-13 17:24:24','',''),(954,'21','227','1',1,'Retail Sale Id 1410',4947.60,0.00,0.00,6.51,0.00,'2022-06-13 17:24:49','',''),(955,'21','227','1',1,'Retail Sale Id 1411',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 17:25:14','',''),(956,'21','227','1',1,'Retail Sale Id 1412',2994.40,0.00,0.00,3.94,0.00,'2022-06-13 17:25:39','',''),(957,'21','227','1',1,'Retail Sale Id 1413',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:26:08','',''),(958,'21','227','1',1,'Retail Sale Id 1414',2994.40,0.00,0.00,3.94,0.00,'2022-06-13 17:26:35','',''),(959,'21','227','1',1,'Retail Sale Id 1415',760.00,0.00,0.00,1.00,0.00,'2022-06-13 17:27:02','',''),(960,'21','227','1',1,'Retail Sale Id 1416',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 17:27:37','',''),(961,'21','227','1',1,'Retail Sale Id 1417',7600.00,0.00,0.00,10.00,0.00,'2022-06-13 17:28:06','',''),(962,'21','227','1',1,'Retail Sale Id 1418',2994.40,0.00,0.00,3.94,0.00,'2022-06-13 17:28:34','',''),(963,'21','227','1',1,'Retail Sale Id 1419',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 17:29:03','',''),(964,'21','227','1',1,'Retail Sale Id 1420',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 17:29:28','',''),(965,'21','227','1',1,'Retail Sale Id 1421',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 17:29:56','',''),(966,'21','227','1',1,'Retail Sale Id 1422',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:30:26','',''),(967,'21','227','1',1,'Retail Sale Id 1423',3997.60,0.00,0.00,5.26,0.00,'2022-06-13 17:30:54','',''),(968,'21','227','1',1,'Retail Sale Id 1424',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:31:30','',''),(969,'21','227','1',1,'Retail Sale Id 1425',2994.40,0.00,0.00,3.94,0.00,'2022-06-13 17:31:57','',''),(970,'21','227','1',1,'Retail Sale Id 1426',995.60,0.00,0.00,1.31,0.00,'2022-06-13 17:32:24','',''),(971,'21','227','1',1,'Retail Sale Id 1427',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 17:32:53','',''),(972,'21','227','1',1,'Retail Sale Id 1428',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:33:19','',''),(973,'21','227','1',1,'Retail Sale Id 1429',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:33:46','',''),(974,'21','227','1',1,'Retail Sale Id 1430',995.60,0.00,0.00,1.31,0.00,'2022-06-13 17:34:10','',''),(975,'21','227','1',1,'Retail Sale Id 1431',3800.00,0.00,0.00,5.00,0.00,'2022-06-13 17:34:34','',''),(976,'21','227','1',1,'Retail Sale Id 1432',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:35:08','',''),(977,'21','227','1',1,'Retail Sale Id 1433',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:35:40','',''),(978,'21','227','1',1,'Retail Sale Id 1434',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:36:06','',''),(979,'21','227','1',1,'Retail Sale Id 1435',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:36:35','',''),(980,'21','227','1',1,'Retail Sale Id 1436',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 17:37:30','',''),(981,'21','227','1',1,'Retail Sale Id 1436',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 17:37:30','',''),(982,'21','227','1',1,'Retail Sale Id 1437',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:37:56','',''),(983,'21','227','1',1,'Retail Sale Id 1438',6999.60,0.00,0.00,9.21,0.00,'2022-06-13 17:38:21','',''),(984,'21','227','1',1,'Retail Sale Id 1439',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:38:49','',''),(985,'21','227','1',1,'Retail Sale Id 1440',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:39:31','',''),(986,'21','227','1',1,'Retail Sale Id 1441',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 17:40:04','',''),(987,'21','227','1',1,'Retail Sale Id 1442',3997.60,0.00,0.00,5.26,0.00,'2022-06-13 17:40:36','',''),(988,'21','227','1',1,'Retail Sale Id 1443',4993.20,0.00,0.00,6.57,0.00,'2022-06-13 17:41:11','',''),(989,'21','227','1',1,'Retail Sale Id 1444',1793.60,0.00,0.00,2.36,0.00,'2022-06-13 17:41:47','',''),(990,'21','227','1',1,'Retail Sale Id 1445',3040.00,0.00,0.00,4.00,0.00,'2022-06-13 17:42:29','',''),(991,'21','227','1',1,'Retail Sale Id 1446',3997.60,0.00,0.00,5.26,0.00,'2022-06-13 17:43:40','',''),(992,'21','227','1',1,'Retail Sale Id 1447',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:44:09','',''),(993,'21','227','1',1,'Retail Sale Id 1448',2994.40,0.00,0.00,3.94,0.00,'2022-06-13 17:44:42','',''),(994,'21','227','1',1,'Retail Sale Id 1449',494.00,0.00,0.00,0.65,0.00,'2022-06-13 17:45:15','',''),(995,'21','227','1',1,'Retail Sale Id 1450',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:45:42','',''),(996,'21','227','1',1,'Retail Sale Id 1451',995.60,0.00,0.00,1.31,0.00,'2022-06-13 17:46:11','',''),(997,'21','227','1',1,'Retail Sale Id 1452',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 17:46:37','',''),(998,'21','227','1',1,'Retail Sale Id 1453',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:47:06','',''),(999,'21','227','1',1,'Retail Sale Id 1454',4993.20,0.00,0.00,6.57,0.00,'2022-06-13 17:47:36','',''),(1000,'21','227','1',1,'Retail Sale Id 1455',1193.20,0.00,0.00,1.57,0.00,'2022-06-13 17:48:18','',''),(1001,'21','227','1',1,'Retail Sale Id 1455',9500.00,0.00,0.00,12.50,0.00,'2022-06-13 17:48:18','',''),(1002,'21','227','1',1,'Retail Sale Id 1456',3017.20,0.00,0.00,3.97,0.00,'2022-06-13 17:48:42','',''),(1003,'21','227','1',1,'Retail Sale Id 1457',995.60,0.00,0.00,1.31,0.00,'2022-06-13 17:49:11','',''),(1004,'21','227','1',1,'Retail Sale Id 1458',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:49:37','',''),(1005,'21','227','1',1,'Retail Sale Id 1459',3800.00,0.00,0.00,5.00,0.00,'2022-06-13 17:50:07','',''),(1006,'21','227','1',1,'Retail Sale Id 1460',995.60,0.00,0.00,1.31,0.00,'2022-06-13 17:50:33','',''),(1007,'21','227','1',1,'Retail Sale Id 1461',1900.00,0.00,0.00,2.50,0.00,'2022-06-13 17:51:04','',''),(1008,'21','227','1',1,'Retail Sale Id 1462',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 17:51:37','',''),(1009,'21','227','1',1,'Retail Sale Id 1463',1193.20,0.00,0.00,1.57,0.00,'2022-06-13 18:13:52','',''),(1010,'21','227','1',1,'Retail Sale Id 1464',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 18:14:28','',''),(1011,'21','227','1',1,'Retail Sale Id 1465',995.60,0.00,0.00,1.31,0.00,'2022-06-13 18:15:14','',''),(1012,'21','227','1',1,'Retail Sale Id 1466',3997.60,0.00,0.00,5.26,0.00,'2022-06-13 18:15:49','',''),(1013,'21','227','1',1,'Retail Sale Id 1467',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 18:16:27','',''),(1014,'21','227','1',1,'Retail Sale Id 1468',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 18:16:55','',''),(1015,'21','227','1',1,'Retail Sale Id 1469',995.60,0.00,0.00,1.31,0.00,'2022-06-13 18:17:28','',''),(1016,'21','227','1',1,'Retail Sale Id 1470',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 18:18:01','',''),(1017,'21','227','1',1,'Retail Sale Id 1471',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 18:18:36','',''),(1018,'21','227','1',1,'Retail Sale Id 1472',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 18:19:10','',''),(1019,'21','227','1',1,'Retail Sale Id 1473',2994.40,0.00,0.00,3.94,0.00,'2022-06-13 18:19:42','',''),(1020,'21','227','1',1,'Retail Sale Id 1474',1520.00,0.00,0.00,2.00,0.00,'2022-06-13 18:20:12','',''),(1021,'21','227','1',1,'Retail Sale Id 1475',4560.00,0.00,0.00,6.00,0.00,'2022-06-13 18:20:46','',''),(1022,'21','227','1',1,'Retail Sale Id 1476',1193.20,0.00,0.00,1.57,0.00,'2022-06-13 18:21:18','',''),(1023,'21','227','1',1,'Retail Sale Id 1477',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 18:21:59','',''),(1024,'21','227','1',1,'Retail Sale Id 1478',995.60,0.00,0.00,1.31,0.00,'2022-06-13 18:22:28','',''),(1025,'21','227','1',1,'Retail Sale Id 1479',2492.80,0.00,0.00,3.28,0.00,'2022-06-13 18:23:04','',''),(1026,'21','227','1',1,'Retail Sale Id 1480',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 18:23:35','',''),(1027,'21','227','1',1,'Retail Sale Id 1481',760.00,0.00,0.00,1.00,0.00,'2022-06-13 18:24:04','',''),(1028,'21','227','1',1,'Retail Sale Id 1482',1998.80,0.00,0.00,2.63,0.00,'2022-06-13 18:24:37','',''),(1029,'21','227','1',1,'Retail Sale Id 1483',760.00,0.00,0.00,1.00,0.00,'2022-06-13 18:25:12','',''),(1030,'21','227','1',1,'Retail Sale Id 1484',2492.80,0.00,0.00,3.28,0.00,'2022-06-13 18:26:15','',''),(1031,'21','227','1',1,'Retail Sale Id 1485',995.60,0.00,0.00,1.31,0.00,'2022-06-13 18:26:43','',''),(1032,'21','227','1',1,'Retail Sale Id 1486',995.60,0.00,0.00,1.31,0.00,'2022-06-13 18:27:16','',''),(1033,'21','227','1',1,'Retail Sale Id 1487',4993.20,0.00,0.00,6.57,0.00,'2022-06-13 18:27:45','',''),(1034,'21','227','1',1,'Retail Sale Id 1488',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 18:28:13','',''),(1035,'21','227','1',1,'Retail Sale Id 1489',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 18:28:45','',''),(1036,'21','227','1',1,'Retail Sale Id 1490',2280.00,0.00,0.00,3.00,0.00,'2022-06-13 18:29:15','',''),(1037,'21','227','1',1,'Retail Sale Id 1491',2994.40,0.00,0.00,3.94,0.00,'2022-06-13 18:34:59','',''),(1038,'21','227','1',1,'Retail Sale Id 1492',1497.20,0.00,0.00,1.97,0.00,'2022-06-13 18:35:28','',''),(1039,'21','227','1',1,'Retail Sale Id 1493',995.60,0.00,0.00,1.31,0.00,'2022-06-13 18:35:58','',''),(1040,'21','227','1',1,'Retail Sale Id 1494',1520.00,0.00,0.00,2.00,0.00,'2022-06-13 18:36:27','',''),(1041,'21','227','1',1,'Retail Sale Id 1495',995.60,0.00,0.00,1.31,0.00,'2022-06-13 18:36:55','',''),(1042,'21','227','1',1,'Retail Sale Id 1496',2211.60,0.00,0.00,2.91,0.00,'2022-06-14 08:26:03','',''),(1043,'21','227','1',1,'Retail Sale Id 1497',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 08:29:13','',''),(1044,'21','227','1',1,'Retail Sale Id 1498',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 08:29:44','',''),(1045,'21','227','1',1,'Retail Sale Id 1499',2994.40,0.00,0.00,3.94,0.00,'2022-06-14 08:30:14','',''),(1046,'21','227','1',1,'Retail Sale Id 1500',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 08:30:40','',''),(1047,'21','227','1',1,'Retail Sale Id 1501',7600.00,0.00,0.00,10.00,0.00,'2022-06-14 08:31:09','',''),(1048,'21','227','1',1,'Retail Sale Id 1502',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 08:31:54','',''),(1049,'21','227','1',1,'Retail Sale Id 1503',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 08:34:07','',''),(1050,'21','227','1',1,'Retail Sale Id 1504',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 08:34:58','',''),(1051,'21','227','1',1,'Retail Sale Id 1505',798.00,0.00,0.00,1.05,0.00,'2022-06-14 08:35:26','',''),(1052,'21','227','1',1,'Retail Sale Id 1506',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 08:36:15','',''),(1053,'21','227','1',1,'Retail Sale Id 1507',995.60,0.00,0.00,1.31,0.00,'2022-06-14 08:36:58','',''),(1054,'21','227','1',1,'Retail Sale Id 1508',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 08:37:48','',''),(1055,'21','227','1',1,'Retail Sale Id 1509',995.60,0.00,0.00,1.31,0.00,'2022-06-14 08:39:14','',''),(1056,'21','227','1',1,'Retail Sale Id 1510',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 08:45:26','',''),(1057,'21','227','1',1,'Retail Sale Id 1511',3693.60,0.00,0.00,4.86,0.00,'2022-06-14 08:47:09','',''),(1058,'21','227','1',1,'Retail Sale Id 1512',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 08:52:40','',''),(1059,'21','227','1',1,'Retail Sale Id 1513',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 08:53:56','',''),(1060,'21','227','1',1,'Retail Sale Id 1514',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 08:55:15','',''),(1061,'21','227','1',1,'Retail Sale Id 1515',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 09:08:52','',''),(1062,'21','227','1',1,'Retail Sale Id 1516',1793.60,0.00,0.00,2.36,0.00,'2022-06-14 09:10:43','',''),(1063,'21','227','1',1,'Retail Sale Id 1517',2097.60,0.00,0.00,2.76,0.00,'2022-06-14 09:11:57','',''),(1064,'21','227','1',1,'Retail Sale Id 1518',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 09:21:37','',''),(1065,'21','227','1',1,'Retail Sale Id 1519',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 09:22:29','',''),(1066,'21','227','1',1,'Retail Sale Id 1520',760.00,0.00,0.00,1.00,0.00,'2022-06-14 09:33:56','',''),(1067,'21','227','1',1,'Retail Sale Id 1521',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 09:35:50','',''),(1068,'21','227','1',1,'Retail Sale Id 1522',760.00,0.00,0.00,1.00,0.00,'2022-06-14 09:37:11','',''),(1069,'21','227','1',1,'Retail Sale Id 1523',494.00,0.00,0.00,0.65,0.00,'2022-06-14 09:39:47','',''),(1070,'21','227','1',1,'Retail Sale Id 1524',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 09:42:07','',''),(1071,'21','227','1',1,'Retail Sale Id 1525',1900.00,0.00,0.00,2.50,0.00,'2022-06-14 09:45:30','',''),(1072,'21','227','1',1,'Retail Sale Id 1526',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 10:02:04','',''),(1073,'21','227','1',1,'Retail Sale Id 1527',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 10:12:22','',''),(1074,'21','227','1',1,'Retail Sale Id 1528',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 10:17:35','',''),(1075,'21','227','1',1,'Retail Sale Id 1529',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 10:19:25','',''),(1076,'21','227','1',1,'Retail Sale Id 1529',3997.60,0.00,0.00,5.26,0.00,'2022-06-14 10:19:25','',''),(1077,'21','227','1',1,'Retail Sale Id 1530',995.60,0.00,0.00,1.31,0.00,'2022-06-14 10:24:39','',''),(1078,'21','227','1',1,'Retail Sale Id 1531',4750.00,0.00,0.00,6.25,0.00,'2022-06-14 10:36:05','',''),(1079,'21','227','1',1,'Retail Sale Id 1532',2994.40,0.00,0.00,3.94,0.00,'2022-06-14 10:38:58','',''),(1080,'21','227','1',1,'Retail Sale Id 1533',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 10:40:07','',''),(1081,'21','227','1',1,'Retail Sale Id 1534',1520.00,0.00,0.00,2.00,0.00,'2022-06-14 10:42:53','',''),(1082,'21','227','1',1,'Retail Sale Id 1535',995.60,0.00,0.00,1.31,0.00,'2022-06-14 10:46:05','',''),(1083,'21','227','1',1,'Retail Sale Id 1536',5996.40,0.00,0.00,7.89,0.00,'2022-06-14 10:46:36','',''),(1084,'21','227','1',1,'Retail Sale Id 1537',7493.60,0.00,0.00,9.86,0.00,'2022-06-14 10:47:45','',''),(1085,'21','227','1',1,'Retail Sale Id 1538',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 11:01:42','',''),(1086,'21','227','1',1,'Retail Sale Id 1539',995.60,0.00,0.00,1.31,0.00,'2022-06-14 11:03:15','',''),(1087,'21','227','1',1,'Retail Sale Id 1540',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 11:07:57','',''),(1088,'21','227','1',1,'Retail Sale Id 1541',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 11:12:26','',''),(1089,'21','227','1',1,'Retail Sale Id 1542',995.60,0.00,0.00,1.31,0.00,'2022-06-14 11:14:35','',''),(1090,'21','227','1',1,'Retail Sale Id 1543',995.60,0.00,0.00,1.31,0.00,'2022-06-14 11:19:13','',''),(1091,'21','227','1',1,'Retail Sale Id 1545',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 11:25:27','',''),(1092,'21','227','1',1,'Retail Sale Id 1546',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 13:40:37','',''),(1093,'21','227','1',1,'Retail Sale Id 1547',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 13:41:14','',''),(1094,'21','227','1',1,'Retail Sale Id 1548',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 13:42:22','',''),(1095,'21','227','1',1,'Retail Sale Id 1549',1520.00,0.00,0.00,2.00,0.00,'2022-06-14 13:43:13','',''),(1096,'21','227','1',1,'Retail Sale Id 1550',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 13:43:47','',''),(1097,'21','227','1',1,'Retail Sale Id 1551',1299.60,0.00,0.00,1.71,0.00,'2022-06-14 13:44:21','',''),(1098,'21','227','1',1,'Retail Sale Id 1552',1520.00,0.00,0.00,2.00,0.00,'2022-06-14 13:44:54','',''),(1099,'21','227','1',1,'Retail Sale Id 1553',995.60,0.00,0.00,1.31,0.00,'2022-06-14 13:45:27','',''),(1100,'21','227','1',1,'Retail Sale Id 1554',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 13:45:58','',''),(1101,'21','227','1',1,'Retail Sale Id 1555',8998.40,0.00,0.00,11.84,0.00,'2022-06-14 13:46:34','',''),(1102,'21','227','1',1,'Retail Sale Id 1556',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 13:47:10','',''),(1103,'21','227','1',1,'Retail Sale Id 1557',995.60,0.00,0.00,1.31,0.00,'2022-06-14 13:47:46','',''),(1104,'21','227','1',1,'Retail Sale Id 1558',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 13:48:18','',''),(1105,'21','227','1',1,'Retail Sale Id 1559',8998.40,0.00,0.00,11.84,0.00,'2022-06-14 13:48:59','',''),(1106,'21','227','1',1,'Retail Sale Id 1560',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 13:49:40','',''),(1107,'21','227','1',1,'Retail Sale Id 1561',995.60,0.00,0.00,1.31,0.00,'2022-06-14 13:50:19','',''),(1108,'21','227','1',1,'Retail Sale Id 1562',1520.00,0.00,0.00,2.00,0.00,'2022-06-14 13:51:27','',''),(1109,'21','227','1',1,'Retail Sale Id 1563',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 13:52:15','',''),(1110,'21','227','1',1,'Retail Sale Id 1564',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 13:52:45','',''),(1111,'21','227','1',1,'Retail Sale Id 1565',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 13:53:16','',''),(1112,'21','227','1',1,'Retail Sale Id 1566',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 13:53:52','',''),(1113,'21','227','1',1,'Retail Sale Id 1567',7600.00,0.00,0.00,10.00,0.00,'2022-06-14 13:54:25','',''),(1114,'21','227','1',1,'Retail Sale Id 1568',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 13:54:53','',''),(1115,'21','227','1',1,'Retail Sale Id 1569',896.80,0.00,0.00,1.18,0.00,'2022-06-14 13:55:33','',''),(1116,'21','227','1',1,'Retail Sale Id 1570',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 13:56:09','',''),(1117,'21','227','1',1,'Retail Sale Id 1571',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 13:56:43','',''),(1118,'21','227','1',1,'Retail Sale Id 1572',995.60,0.00,0.00,1.31,0.00,'2022-06-14 13:57:24','',''),(1119,'21','227','1',1,'Retail Sale Id 1573',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 13:58:22','',''),(1120,'21','227','1',1,'Retail Sale Id 1574',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 14:00:14','',''),(1121,'21','227','1',1,'Retail Sale Id 1575',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 14:05:31','',''),(1122,'21','227','1',1,'Retail Sale Id 1576',995.60,0.00,0.00,1.31,0.00,'2022-06-14 14:16:13','',''),(1123,'21','227','1',1,'Retail Sale Id 1577',1520.00,0.00,0.00,2.00,0.00,'2022-06-14 14:38:57','',''),(1124,'21','227','1',1,'Retail Sale Id 1578',760.00,0.00,0.00,1.00,0.00,'2022-06-14 14:40:01','',''),(1125,'21','227','1',1,'Retail Sale Id 1579',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 14:41:05','',''),(1126,'21','227','1',1,'Retail Sale Id 1580',995.60,0.00,0.00,1.31,0.00,'2022-06-14 14:42:08','',''),(1127,'21','227','1',1,'Retail Sale Id 1580',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 14:42:08','',''),(1128,'21','227','1',1,'Retail Sale Id 1581',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 14:43:26','',''),(1129,'21','227','1',1,'Retail Sale Id 1582',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 14:44:10','',''),(1130,'21','227','1',1,'Retail Sale Id 1583',760.00,0.00,0.00,1.00,0.00,'2022-06-14 14:45:07','',''),(1131,'21','227','1',1,'Retail Sale Id 1584',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 14:45:41','',''),(1132,'21','227','1',1,'Retail Sale Id 1585',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 14:47:00','',''),(1133,'21','227','1',1,'Retail Sale Id 1587',798.00,0.00,0.00,1.05,0.00,'2022-06-14 14:47:50','',''),(1134,'21','227','1',1,'Retail Sale Id 1588',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 14:48:33','',''),(1135,'21','227','1',1,'Retail Sale Id 1589',995.60,0.00,0.00,1.31,0.00,'2022-06-14 14:49:45','',''),(1136,'21','227','1',1,'Retail Sale Id 1590',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 14:50:34','',''),(1137,'21','227','1',1,'Retail Sale Id 1591',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 14:53:03','',''),(1138,'21','227','1',1,'Retail Sale Id 1592',2994.40,0.00,0.00,3.94,0.00,'2022-06-14 17:44:42','',''),(1139,'21','227','1',1,'Retail Sale Id 1593',494.00,0.00,0.00,0.65,0.00,'2022-06-14 17:45:14','',''),(1140,'21','227','1',1,'Retail Sale Id 1594',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 17:45:43','',''),(1141,'21','227','1',1,'Retail Sale Id 1595',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 17:46:08','',''),(1142,'21','227','1',1,'Retail Sale Id 1596',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 17:46:31','',''),(1143,'21','227','1',1,'Retail Sale Id 1597',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 17:46:57','',''),(1144,'21','227','1',1,'Retail Sale Id 1598',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 17:47:24','',''),(1145,'21','227','1',1,'Retail Sale Id 1599',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 17:47:48','',''),(1146,'21','227','1',1,'Retail Sale Id 1600',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 17:48:22','',''),(1147,'21','227','1',1,'Retail Sale Id 1601',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 18:17:13','',''),(1148,'21','227','1',1,'Retail Sale Id 1602',13680.00,0.00,0.00,18.00,0.00,'2022-06-14 18:18:23','',''),(1149,'21','227','1',1,'Retail Sale Id 1603',8436.00,0.00,0.00,11.10,0.00,'2022-06-14 18:19:00','',''),(1150,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-06-17 09:32:02','',''),(1151,'21','227',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,3000.00,0.00,'2022-06-17 09:35:14','',''),(1152,'21','227','1',1,'Received from bridging 4',0.00,0.00,3000.00,0.00,0.00,'2022-06-17 09:35:14','',''),(1153,'21','227','1',1,'Retail Sale Id 1604',3997.60,0.00,0.00,5.26,0.00,'2022-06-17 09:38:30','',''),(1154,'21','227','1',1,'Retail Sale Id 1605',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 09:40:24','',''),(1155,'21','227','1',1,'Retail Sale Id 1606',760.00,0.00,0.00,1.00,0.00,'2022-06-17 09:41:50','',''),(1156,'21','227','1',1,'Retail Sale Id 1607',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 09:43:02','',''),(1157,'21','227','1',1,'Retail Sale Id 1608',2492.80,0.00,0.00,3.28,0.00,'2022-06-17 09:44:01','',''),(1158,'21','227','1',1,'Retail Sale Id 1609',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 09:44:41','',''),(1159,'21','227','1',1,'Retail Sale Id 1610',4750.00,0.00,0.00,6.25,0.00,'2022-06-17 09:45:20','',''),(1160,'21','227','1',1,'Retail Sale Id 1611',2994.40,0.00,0.00,3.94,0.00,'2022-06-17 09:46:02','',''),(1161,'21','227','1',1,'Retail Sale Id 1612',896.80,0.00,0.00,1.18,0.00,'2022-06-17 09:47:14','',''),(1162,'21','227','1',1,'Retail Sale Id 1613',798.00,0.00,0.00,1.05,0.00,'2022-06-17 09:48:20','',''),(1163,'21','227','1',1,'Retail Sale Id 1614',995.60,0.00,0.00,1.31,0.00,'2022-06-17 09:49:31','',''),(1164,'21','227','1',1,'Retail Sale Id 1615',995.60,0.00,0.00,1.31,0.00,'2022-06-17 09:50:53','',''),(1165,'21','227','1',1,'Retail Sale Id 1616',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 09:51:41','',''),(1166,'21','227','1',1,'Retail Sale Id 1617',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 09:52:25','',''),(1167,'21','227','1',1,'Retail Sale Id 1618',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 09:53:05','',''),(1168,'21','227','1',1,'Retail Sale Id 1619',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 09:53:39','',''),(1169,'21','227','1',1,'Retail Sale Id 1620',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 09:54:22','',''),(1170,'21','227','1',1,'Retail Sale Id 1621',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 09:54:53','',''),(1171,'21','227','1',1,'Retail Sale Id 1622',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 09:56:37','',''),(1172,'21','227','1',1,'Retail Sale Id 1623',2796.80,0.00,0.00,3.68,0.00,'2022-06-17 09:59:56','',''),(1173,'21','227','1',1,'Retail Sale Id 1624',995.60,0.00,0.00,1.31,0.00,'2022-06-17 10:00:36','',''),(1174,'21','227','1',1,'Retail Sale Id 1625',1900.00,0.00,0.00,2.50,0.00,'2022-06-17 10:04:36','',''),(1175,'21','227','1',1,'Retail Sale Id 1626',2994.40,0.00,0.00,3.94,0.00,'2022-06-17 10:05:34','',''),(1176,'21','227','1',1,'Retail Sale Id 1627',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 10:06:26','',''),(1177,'21','227','1',1,'Retail Sale Id 1628',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 10:07:30','',''),(1178,'21','227','1',1,'Retail Sale Id 1629',995.60,0.00,0.00,1.31,0.00,'2022-06-17 10:08:30','',''),(1179,'21','227','1',1,'Retail Sale Id 1630',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 10:10:05','',''),(1180,'21','227','1',1,'Retail Sale Id 1631',798.00,0.00,0.00,1.05,0.00,'2022-06-17 10:12:37','',''),(1181,'21','227','1',1,'Retail Sale Id 1632',896.80,0.00,0.00,1.18,0.00,'2022-06-17 10:18:19','',''),(1182,'21','227','1',1,'Retail Sale Id 1633',896.80,0.00,0.00,1.18,0.00,'2022-06-17 10:23:49','',''),(1183,'21','227','1',1,'Retail Sale Id 1634',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 10:24:41','',''),(1184,'21','227','1',1,'Retail Sale Id 1635',798.00,0.00,0.00,1.05,0.00,'2022-06-17 10:27:04','',''),(1185,'21','227','1',1,'Retail Sale Id 1636',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 10:28:14','',''),(1186,'21','227','1',1,'Retail Sale Id 1637',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 10:31:57','',''),(1187,'21','227','1',1,'Retail Sale Id 1638',6999.60,0.00,0.00,9.21,0.00,'2022-06-17 10:32:57','',''),(1188,'21','227','1',1,'Retail Sale Id 1639',760.00,0.00,0.00,1.00,0.00,'2022-06-17 10:33:50','',''),(1189,'21','227','1',1,'Retail Sale Id 1640',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 10:36:51','',''),(1190,'21','227','1',1,'Retail Sale Id 1641',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 10:37:31','',''),(1191,'21','227','1',1,'Retail Sale Id 1642',995.60,0.00,0.00,1.31,0.00,'2022-06-17 10:38:30','',''),(1192,'21','227','1',1,'Retail Sale Id 1643',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 10:39:11','',''),(1193,'21','227','1',1,'Retail Sale Id 1644',4993.20,0.00,0.00,6.57,0.00,'2022-06-17 10:40:52','',''),(1194,'21','227','1',1,'Retail Sale Id 1645',3997.60,0.00,0.00,5.26,0.00,'2022-06-17 10:42:15','',''),(1195,'21','227','1',1,'Retail Sale Id 1646',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 10:57:53','',''),(1196,'21','227','1',1,'Retail Sale Id 1647',995.60,0.00,0.00,1.31,0.00,'2022-06-17 11:18:34','',''),(1197,'21','227','1',1,'Retail Sale Id 1648',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 11:28:36','',''),(1198,'21','227','1',1,'Retail Sale Id 1649',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 11:32:43','',''),(1199,'21','227','1',1,'Retail Sale Id 1650',995.60,0.00,0.00,1.31,0.00,'2022-06-17 11:34:14','',''),(1200,'21','227','1',1,'Retail Sale Id 1651',494.00,0.00,0.00,0.65,0.00,'2022-06-17 11:37:03','',''),(1201,'21','227','1',1,'Retail Sale Id 1652',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 11:39:38','',''),(1202,'21','227','1',1,'Retail Sale Id 1653',995.60,0.00,0.00,1.31,0.00,'2022-06-17 11:40:35','',''),(1203,'21','227','1',1,'Retail Sale Id 1654',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 11:47:01','',''),(1204,'21','227','1',1,'Retail Sale Id 1655',1520.00,0.00,0.00,2.00,0.00,'2022-06-17 11:49:37','',''),(1205,'21','227','1',1,'Retail Sale Id 1656',995.60,0.00,0.00,1.31,0.00,'2022-06-17 11:51:04','',''),(1206,'21','227','1',1,'Retail Sale Id 1657',6999.60,0.00,0.00,9.21,0.00,'2022-06-17 11:54:05','',''),(1207,'21','227','1',1,'Retail Sale Id 1658',3496.00,0.00,0.00,4.60,0.00,'2022-06-17 11:57:02','',''),(1208,'21','227','1',1,'Retail Sale Id 1659',995.60,0.00,0.00,1.31,0.00,'2022-06-17 11:59:46','',''),(1209,'21','227','1',1,'Retail Sale Id 1660',995.60,0.00,0.00,1.31,0.00,'2022-06-17 12:01:52','',''),(1210,'21','227','1',1,'Retail Sale Id 1661',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 12:03:50','',''),(1211,'21','227','1',1,'Retail Sale Id 1662',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 12:07:36','',''),(1212,'21','227',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,2000.00,0.00,'2022-06-17 12:09:44','',''),(1213,'21','227','1',1,'Received from bridging 5',0.00,0.00,2000.00,0.00,0.00,'2022-06-17 12:09:44','',''),(1214,'21','227','1',1,'Retail Sale Id 1663',896.80,0.00,0.00,1.18,0.00,'2022-06-17 12:13:37','',''),(1215,'21','227','1',1,'Retail Sale Id 1664',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 12:14:45','',''),(1216,'21','227','1',1,'Retail Sale Id 1665',995.60,0.00,0.00,1.31,0.00,'2022-06-17 12:16:05','',''),(1217,'21','227','1',1,'Retail Sale Id 1665',995.60,0.00,0.00,1.31,0.00,'2022-06-17 12:16:05','',''),(1218,'21','227','1',1,'Retail Sale Id 1666',995.60,0.00,0.00,1.31,0.00,'2022-06-17 12:23:17','',''),(1219,'21','227','1',1,'Retail Sale Id 1667',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 12:36:14','',''),(1220,'21','227','1',1,'Retail Sale Id 1668',995.60,0.00,0.00,1.31,0.00,'2022-06-17 12:37:44','',''),(1221,'21','227','1',1,'Retail Sale Id 1669',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 12:42:01','',''),(1222,'21','227','1',1,'Retail Sale Id 1670',3496.00,0.00,0.00,4.60,0.00,'2022-06-17 12:51:21','',''),(1223,'21','227','1',1,'Retail Sale Id 1671',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 14:31:44','',''),(1224,'21','227','1',1,'Retail Sale Id 1672',2994.40,0.00,0.00,3.94,0.00,'2022-06-17 14:34:48','',''),(1225,'21','227','1',1,'Retail Sale Id 1674',4993.20,0.00,0.00,6.57,0.00,'2022-06-17 14:37:40','',''),(1226,'21','227','1',1,'Retail Sale Id 1675',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 14:40:07','',''),(1227,'21','227','1',1,'Retail Sale Id 1676',1793.60,0.00,0.00,2.36,0.00,'2022-06-17 14:42:16','',''),(1228,'21','227','1',1,'Retail Sale Id 1677',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 14:43:27','',''),(1229,'21','227','1',1,'Retail Sale Id 1678',995.60,0.00,0.00,1.31,0.00,'2022-06-17 14:44:49','',''),(1230,'21','227','1',1,'Retail Sale Id 1679',995.60,0.00,0.00,1.31,0.00,'2022-06-17 14:50:12','',''),(1231,'21','227','1',1,'Retail Sale Id 1680',7600.00,0.00,0.00,10.00,0.00,'2022-06-17 14:51:19','',''),(1232,'21','227','1',1,'Retail Sale Id 1681',760.00,0.00,0.00,1.00,0.00,'2022-06-17 14:52:59','',''),(1233,'21','227','1',1,'Retail Sale Id 1682',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 14:55:37','',''),(1234,'21','227','1',1,'Retail Sale Id 1683',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 14:58:41','',''),(1235,'21','227','1',1,'Retail Sale Id 1685',995.60,0.00,0.00,1.31,0.00,'2022-06-17 15:28:34','',''),(1236,'21','227','1',1,'Retail Sale Id 1686',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 15:29:27','',''),(1237,'21','227','1',1,'Retail Sale Id 1687',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 15:30:24','',''),(1238,'21','227','1',1,'Retail Sale Id 1688',995.60,0.00,0.00,1.31,0.00,'2022-06-17 15:31:14','',''),(1239,'21','227','1',1,'Retail Sale Id 1689',995.60,0.00,0.00,1.31,0.00,'2022-06-17 15:31:55','',''),(1240,'21','227','1',1,'Retail Sale Id 1690',3496.00,0.00,0.00,4.60,0.00,'2022-06-17 15:32:53','',''),(1241,'21','227','1',1,'Retail Sale Id 1691',995.60,0.00,0.00,1.31,0.00,'2022-06-17 15:33:20','',''),(1242,'21','227','1',1,'Retail Sale Id 1692',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 15:34:05','',''),(1243,'21','227','1',1,'Retail Sale Id 1693',494.00,0.00,0.00,0.65,0.00,'2022-06-17 15:34:47','',''),(1244,'21','227','1',1,'Retail Sale Id 1694',3040.00,0.00,0.00,4.00,0.00,'2022-06-17 15:35:34','',''),(1245,'21','227','1',1,'Retail Sale Id 1695',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 15:36:30','',''),(1246,'21','227','1',1,'Retail Sale Id 1696',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 15:37:13','',''),(1247,'21','227','1',1,'Retail Sale Id 1697',2994.40,0.00,0.00,3.94,0.00,'2022-06-17 15:37:46','',''),(1248,'21','227','1',1,'Retail Sale Id 1698',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 15:38:29','',''),(1249,'21','227','1',1,'Retail Sale Id 1699',995.60,0.00,0.00,1.31,0.00,'2022-06-17 15:39:47','',''),(1250,'21','227','1',1,'Retail Sale Id 1700',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 15:40:38','',''),(1251,'21','227','1',1,'Retail Sale Id 1701',2492.80,0.00,0.00,3.28,0.00,'2022-06-17 15:42:33','',''),(1252,'21','227','1',1,'Retail Sale Id 1702',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 15:50:04','',''),(1253,'21','227','1',1,'Retail Sale Id 1703',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 15:55:52','',''),(1254,'21','227','1',1,'Retail Sale Id 1704',995.60,0.00,0.00,1.31,0.00,'2022-06-17 15:58:01','',''),(1255,'21','227','1',1,'Retail Sale Id 1705',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 16:06:16','',''),(1256,'21','227','1',1,'Retail Sale Id 1706',1520.00,0.00,0.00,2.00,0.00,'2022-06-17 16:08:15','',''),(1257,'21','227','1',1,'Retail Sale Id 1707',3040.00,0.00,0.00,4.00,0.00,'2022-06-17 16:15:37','',''),(1258,'21','227','1',1,'Retail Sale Id 1708',1900.00,0.00,0.00,2.50,0.00,'2022-06-17 16:18:03','',''),(1259,'21','227','1',1,'Retail Sale Id 1709',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 16:19:01','',''),(1260,'21','227','1',1,'Retail Sale Id 1710',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 16:20:11','',''),(1261,'21','227','1',1,'Retail Sale Id 1710',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 16:20:11','',''),(1262,'21','227','1',1,'Retail Sale Id 1711',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 16:28:57','',''),(1263,'21','227','1',1,'Retail Sale Id 1712',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 16:29:45','',''),(1264,'21','227','1',1,'Retail Sale Id 1713',4598.00,0.00,0.00,6.05,0.00,'2022-06-17 16:32:02','',''),(1265,'21','227','1',1,'Retail Sale Id 1714',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 16:32:49','',''),(1266,'21','227','1',1,'Retail Sale Id 1715',3997.60,0.00,0.00,5.26,0.00,'2022-06-17 16:33:45','',''),(1267,'21','227','1',1,'Retail Sale Id 1716',995.60,0.00,0.00,1.31,0.00,'2022-06-17 16:34:44','',''),(1268,'21','227','1',1,'Retail Sale Id 1717',1094.40,0.00,0.00,1.44,0.00,'2022-06-17 16:35:40','',''),(1269,'21','227','1',1,'Retail Sale Id 1718',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 16:36:23','',''),(1270,'21','227','1',1,'Retail Sale Id 1719',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 16:37:48','',''),(1271,'21','227','1',1,'Retail Sale Id 1720',798.00,0.00,0.00,1.05,0.00,'2022-06-17 16:38:33','',''),(1272,'21','227','1',1,'Retail Sale Id 1721',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 16:39:30','',''),(1273,'21','227','1',1,'Retail Sale Id 1723',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 16:43:13','',''),(1274,'21','227','1',1,'Retail Sale Id 1724',2994.40,0.00,0.00,3.94,0.00,'2022-06-17 16:45:41','',''),(1275,'21','227','1',1,'Retail Sale Id 1726',3496.00,0.00,0.00,4.60,0.00,'2022-06-17 16:51:29','',''),(1276,'21','227','1',1,'Retail Sale Id 1727',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 16:52:54','',''),(1277,'21','227','1',1,'Retail Sale Id 1728',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 16:54:01','',''),(1278,'21','227','1',1,'Retail Sale Id 1729',1793.60,0.00,0.00,2.36,0.00,'2022-06-17 16:55:15','',''),(1279,'21','227','1',1,'Retail Sale Id 1730',4993.20,0.00,0.00,6.57,0.00,'2022-06-17 16:56:28','',''),(1280,'21','227','1',1,'Retail Sale Id 1731',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 16:57:14','',''),(1281,'21','227','1',1,'Retail Sale Id 1732',2492.80,0.00,0.00,3.28,0.00,'2022-06-17 16:58:17','',''),(1282,'21','227','1',1,'Retail Sale Id 1733',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 16:59:06','',''),(1283,'21','227','1',1,'Retail Sale Id 1734',3496.00,0.00,0.00,4.60,0.00,'2022-06-17 17:00:14','',''),(1284,'21','227','1',1,'Retail Sale Id 1735',760.00,0.00,0.00,1.00,0.00,'2022-06-17 17:01:08','',''),(1285,'21','227','1',1,'Retail Sale Id 1736',995.60,0.00,0.00,1.31,0.00,'2022-06-17 17:01:57','',''),(1286,'21','227','1',1,'Retail Sale Id 1737',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 17:03:25','',''),(1287,'21','227','1',1,'Retail Sale Id 1738',995.60,0.00,0.00,1.31,0.00,'2022-06-17 17:05:33','',''),(1288,'21','227','1',1,'Retail Sale Id 1739',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 17:07:32','',''),(1289,'21','227','1',1,'Retail Sale Id 1740',3997.60,0.00,0.00,5.26,0.00,'2022-06-17 17:15:13','',''),(1290,'21','227','1',1,'Retail Sale Id 1741',494.00,0.00,0.00,0.65,0.00,'2022-06-17 17:21:21','',''),(1291,'21','227','1',1,'Retail Sale Id 1742',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 17:23:17','',''),(1292,'21','227','1',1,'Retail Sale Id 1743',760.00,0.00,0.00,1.00,0.00,'2022-06-17 17:25:38','',''),(1293,'21','227','1',1,'Retail Sale Id 1744',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 17:30:40','',''),(1294,'21','227','1',1,'Retail Sale Id 1745',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 17:34:22','',''),(1295,'21','227','1',1,'Retail Sale Id 1746',995.60,0.00,0.00,1.31,0.00,'2022-06-17 17:41:43','',''),(1296,'21','227','1',1,'Retail Sale Id 1747',995.60,0.00,0.00,1.31,0.00,'2022-06-17 17:49:01','',''),(1297,'21','227','1',1,'Retail Sale Id 1748',33440.00,0.00,0.00,44.00,0.00,'2022-06-17 17:51:27','',''),(1298,'21','227','1',1,'Retail Sale Id 1749',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 17:52:32','',''),(1299,'21','227','1',1,'Retail Sale Id 1750',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 17:58:43','',''),(1300,'21','227','1',1,'Retail Sale Id 1751',3997.60,0.00,0.00,5.26,0.00,'2022-06-17 18:08:46','',''),(1301,'21','227','1',1,'Retail Sale Id 1752',3997.60,0.00,0.00,5.26,0.00,'2022-06-17 18:11:18','',''),(1302,'21','227','1',1,'Retail Sale Id 1753',1694.80,0.00,0.00,2.23,0.00,'2022-06-17 18:13:25','',''),(1303,'21','227','1',1,'Retail Sale Id 1754',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 18:14:20','',''),(1304,'21','227','1',1,'Retail Sale Id 1755',995.60,0.00,0.00,1.31,0.00,'2022-06-17 18:26:16','',''),(1305,'21','227','1',1,'Retail Sale Id 1756',995.60,0.00,0.00,1.31,0.00,'2022-06-17 18:28:28','',''),(1306,'21','227','1',1,'Retail Sale Id 1757',1497.20,0.00,0.00,1.97,0.00,'2022-06-17 18:29:32','',''),(1307,'21','227','1',1,'Retail Sale Id 1758',3800.00,0.00,0.00,5.00,0.00,'2022-06-17 18:30:13','',''),(1308,'21','227','1',1,'Retail Sale Id 1759',995.60,0.00,0.00,1.31,0.00,'2022-06-18 09:22:16','',''),(1309,'21','227','1',1,'Retail Sale Id 1760',995.60,0.00,0.00,1.31,0.00,'2022-06-18 09:23:54','',''),(1310,'21','227','1',1,'Retail Sale Id 1761',995.60,0.00,0.00,1.31,0.00,'2022-06-18 09:25:05','',''),(1311,'21','227','1',1,'Retail Sale Id 1762',760.00,0.00,0.00,1.00,0.00,'2022-06-18 09:26:22','',''),(1312,'21','227','1',1,'Retail Sale Id 1763',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 09:30:43','',''),(1313,'21','227','1',1,'Retail Sale Id 1764',995.60,0.00,0.00,1.31,0.00,'2022-06-18 09:32:00','',''),(1314,'21','227','1',1,'Retail Sale Id 1765',1520.00,0.00,0.00,2.00,0.00,'2022-06-18 09:35:03','',''),(1315,'21','227','1',1,'Retail Sale Id 1766',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 09:36:10','',''),(1316,'21','227','1',1,'Retail Sale Id 1767',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 09:40:35','',''),(1317,'21','227','1',1,'Retail Sale Id 1768',4750.00,0.00,0.00,6.25,0.00,'2022-06-18 09:41:34','',''),(1318,'21','227','1',1,'Retail Sale Id 1769',494.00,0.00,0.00,0.65,0.00,'2022-06-18 09:42:18','',''),(1319,'21','227','1',1,'Retail Sale Id 1770',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 09:44:08','',''),(1320,'21','227','1',1,'Retail Sale Id 1771',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 09:47:49','',''),(1321,'21','227','1',1,'Retail Sale Id 1772',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 09:50:08','',''),(1322,'21','227','1',1,'Retail Sale Id 1773',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 09:51:40','',''),(1323,'21','227','1',1,'Retail Sale Id 1774',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 09:52:59','',''),(1324,'21','227','1',1,'Retail Sale Id 1775',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 09:54:17','',''),(1325,'21','227','1',1,'Retail Sale Id 1776',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 09:55:09','',''),(1326,'21','227','1',1,'Retail Sale Id 1777',7980.00,0.00,0.00,10.50,0.00,'2022-06-18 09:56:12','',''),(1327,'21','227','1',1,'Retail Sale Id 1778',2492.80,0.00,0.00,3.28,0.00,'2022-06-18 09:57:46','',''),(1328,'21','227','1',1,'Retail Sale Id 1779',494.00,0.00,0.00,0.65,0.00,'2022-06-18 09:58:50','',''),(1329,'21','227','1',1,'Retail Sale Id 1780',995.60,0.00,0.00,1.31,0.00,'2022-06-18 10:02:45','',''),(1330,'21','227','1',1,'Retail Sale Id 1781',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 10:03:52','',''),(1331,'21','227','1',1,'Retail Sale Id 1783',1299.60,0.00,0.00,1.71,0.00,'2022-06-18 10:05:11','',''),(1332,'21','227','1',1,'Retail Sale Id 1784',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 10:06:03','',''),(1333,'21','227','1',1,'Retail Sale Id 1785',12494.40,0.00,0.00,16.44,0.00,'2022-06-18 10:07:31','',''),(1334,'21','227','1',1,'Retail Sale Id 1786',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 10:09:08','',''),(1335,'21','227','1',1,'Retail Sale Id 1787',995.60,0.00,0.00,1.31,0.00,'2022-06-18 10:10:18','',''),(1336,'21','227','1',1,'Retail Sale Id 1788',995.60,0.00,0.00,1.31,0.00,'2022-06-18 10:11:08','',''),(1337,'21','227','1',1,'Retail Sale Id 1789',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 10:12:13','',''),(1338,'21','227','1',1,'Retail Sale Id 1790',3997.60,0.00,0.00,5.26,0.00,'2022-06-18 10:13:23','',''),(1339,'21','227','1',1,'Retail Sale Id 1791',3040.00,0.00,0.00,4.00,0.00,'2022-06-18 10:14:12','',''),(1340,'21','227','1',1,'Retail Sale Id 1792',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 10:16:20','',''),(1341,'21','227','1',1,'Retail Sale Id 1793',8360.00,0.00,0.00,11.00,0.00,'2022-06-18 10:17:10','',''),(1342,'21','227','1',1,'Retail Sale Id 1794',1398.40,0.00,0.00,1.84,0.00,'2022-06-18 10:20:40','',''),(1343,'21','227','1',1,'Retail Sale Id 1795',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 10:22:00','',''),(1344,'21','227','1',1,'Retail Sale Id 1796',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 10:22:46','',''),(1345,'21','227','1',1,'Retail Sale Id 1797',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 10:24:44','',''),(1346,'21','227','1',1,'Retail Sale Id 1798',2492.80,0.00,0.00,3.28,0.00,'2022-06-18 10:25:36','',''),(1347,'21','227','1',1,'Retail Sale Id 1799',995.60,0.00,0.00,1.31,0.00,'2022-06-18 10:26:56','',''),(1348,'21','227','1',1,'Retail Sale Id 1800',995.60,0.00,0.00,1.31,0.00,'2022-06-18 10:28:15','',''),(1349,'21','227','1',1,'Retail Sale Id 1801',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 10:28:59','',''),(1350,'21','227','1',1,'Retail Sale Id 1802',494.00,0.00,0.00,0.65,0.00,'2022-06-18 10:41:52','',''),(1351,'21','227','1',1,'Retail Sale Id 1803',995.60,0.00,0.00,1.31,0.00,'2022-06-18 10:42:56','',''),(1352,'21','227','1',1,'Retail Sale Id 1804',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 10:43:54','',''),(1353,'21','227','1',1,'Retail Sale Id 1805',995.60,0.00,0.00,1.31,0.00,'2022-06-18 10:45:19','',''),(1354,'21','227','1',1,'Retail Sale Id 1806',4993.20,0.00,0.00,6.57,0.00,'2022-06-18 10:47:27','',''),(1355,'21','227','1',1,'Retail Sale Id 1807',995.60,0.00,0.00,1.31,0.00,'2022-06-18 11:09:04','',''),(1356,'21','227','1',1,'Retail Sale Id 1808',7600.00,0.00,0.00,10.00,0.00,'2022-06-18 11:09:53','',''),(1357,'21','227','1',1,'Retail Sale Id 1809',995.60,0.00,0.00,1.31,0.00,'2022-06-18 11:13:24','',''),(1358,'21','227','1',1,'Retail Sale Id 1810',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 11:14:39','',''),(1359,'21','227','1',1,'Retail Sale Id 1811',995.60,0.00,0.00,1.31,0.00,'2022-06-18 11:15:41','',''),(1360,'21','227','1',1,'Retail Sale Id 1812',995.60,0.00,0.00,1.31,0.00,'2022-06-18 11:17:08','',''),(1361,'21','227','1',1,'Retail Sale Id 1813',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 11:18:28','',''),(1362,'21','227','1',1,'Retail Sale Id 1814',494.00,0.00,0.00,0.65,0.00,'2022-06-18 11:21:04','',''),(1363,'21','227','1',1,'Retail Sale Id 1815',494.00,0.00,0.00,0.65,0.00,'2022-06-18 11:26:17','',''),(1364,'21','227','1',1,'Retail Sale Id 1816',8998.40,0.00,0.00,11.84,0.00,'2022-06-18 11:37:00','',''),(1365,'21','227','1',1,'Retail Sale Id 1817',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 11:38:12','',''),(1366,'21','227','1',1,'Retail Sale Id 1818',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 11:44:37','',''),(1367,'21','227','1',1,'Retail Sale Id 1819',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 11:46:32','',''),(1368,'21','227','1',1,'Retail Sale Id 1820',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 12:02:53','',''),(1369,'21','227','1',1,'Retail Sale Id 1821',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 12:06:24','',''),(1370,'21','227','1',1,'Retail Sale Id 1822',1299.60,0.00,0.00,1.71,0.00,'2022-06-18 12:11:49','',''),(1371,'21','227','1',1,'Retail Sale Id 1823',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 12:27:00','',''),(1372,'21','227','1',1,'Retail Sale Id 1824',995.60,0.00,0.00,1.31,0.00,'2022-06-18 12:31:44','',''),(1373,'21','227','1',1,'Retail Sale Id 1825',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 12:33:27','',''),(1374,'21','227','1',1,'Retail Sale Id 1826',2492.80,0.00,0.00,3.28,0.00,'2022-06-18 12:39:40','',''),(1375,'21','227','1',1,'Retail Sale Id 1827',494.00,0.00,0.00,0.65,0.00,'2022-06-18 12:46:10','',''),(1376,'21','227','1',1,'Retail Sale Id 1828',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 12:54:08','',''),(1377,'21','227','1',1,'Retail Sale Id 1829',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 13:00:15','',''),(1378,'21','227','1',1,'Retail Sale Id 1830',2492.80,0.00,0.00,3.28,0.00,'2022-06-18 13:01:38','',''),(1379,'21','227','1',1,'Retail Sale Id 1831',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 13:02:43','',''),(1380,'21','227','1',1,'Retail Sale Id 1832',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 13:03:45','',''),(1381,'21','227','1',1,'Retail Sale Id 1833',1793.60,0.00,0.00,2.36,0.00,'2022-06-18 13:05:00','',''),(1382,'21','227','1',1,'Retail Sale Id 1834',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 13:08:17','',''),(1383,'21','227','1',1,'Retail Sale Id 1835',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 13:15:18','',''),(1384,'21','227','1',1,'Retail Sale Id 1836',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 13:17:42','',''),(1385,'21','227','1',1,'Retail Sale Id 1837',1694.80,0.00,0.00,2.23,0.00,'2022-06-18 13:18:59','',''),(1386,'21','227','1',1,'Retail Sale Id 1838',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 13:22:10','',''),(1387,'21','227','1',1,'Retail Sale Id 1839',995.60,0.00,0.00,1.31,0.00,'2022-06-18 13:22:59','',''),(1388,'21','227','1',1,'Retail Sale Id 1840',995.60,0.00,0.00,1.31,0.00,'2022-06-18 13:24:15','',''),(1389,'21','227','1',1,'Retail Sale Id 1841',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 13:26:09','',''),(1390,'21','227','1',1,'Retail Sale Id 1842',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 13:27:29','',''),(1391,'21','227','1',1,'Retail Sale Id 1843',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 13:29:00','',''),(1392,'21','227','1',1,'Retail Sale Id 1844',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 13:36:47','',''),(1393,'21','227','1',1,'Retail Sale Id 1845',760.00,0.00,0.00,1.00,0.00,'2022-06-18 13:38:08','',''),(1394,'21','227','1',1,'Retail Sale Id 1846',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 13:46:38','',''),(1395,'21','227','1',1,'Retail Sale Id 1847',3997.60,0.00,0.00,5.26,0.00,'2022-06-18 13:57:15','',''),(1396,'21','227','1',1,'Retail Sale Id 1848',995.60,0.00,0.00,1.31,0.00,'2022-06-18 14:01:17','',''),(1397,'21','227','1',1,'Retail Sale Id 1849',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 14:57:38','',''),(1398,'21','227','1',1,'Retail Sale Id 1850',995.60,0.00,0.00,1.31,0.00,'2022-06-18 14:59:11','',''),(1399,'21','227','1',1,'Retail Sale Id 1851',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 15:01:07','',''),(1400,'21','227','1',1,'Retail Sale Id 1852',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 15:01:56','',''),(1401,'21','227','1',1,'Retail Sale Id 1853',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 15:02:51','',''),(1402,'21','227','1',1,'Retail Sale Id 1854',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 15:04:05','',''),(1403,'21','227','1',1,'Retail Sale Id 1855',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 15:06:50','',''),(1404,'21','227','1',1,'Retail Sale Id 1856',7600.00,0.00,0.00,10.00,0.00,'2022-06-18 15:07:57','',''),(1405,'21','227','1',1,'Retail Sale Id 1857',1694.80,0.00,0.00,2.23,0.00,'2022-06-18 15:10:08','',''),(1406,'21','227','1',1,'Retail Sale Id 1858',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 15:11:15','',''),(1407,'21','227','1',1,'Retail Sale Id 1859',1694.80,0.00,0.00,2.23,0.00,'2022-06-18 15:12:08','',''),(1408,'21','227','1',1,'Retail Sale Id 1860',2698.00,0.00,0.00,3.55,0.00,'2022-06-18 15:13:12','',''),(1409,'21','227','1',1,'Retail Sale Id 1861',995.60,0.00,0.00,1.31,0.00,'2022-06-18 15:14:34','',''),(1410,'21','227','1',1,'Retail Sale Id 1862',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 15:16:06','',''),(1411,'21','227','1',1,'Retail Sale Id 1863',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 15:16:55','',''),(1412,'21','227','1',1,'Retail Sale Id 1864',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 15:17:47','',''),(1413,'21','227','1',1,'Retail Sale Id 1865',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 15:22:24','',''),(1414,'21','227','1',1,'Retail Sale Id 1866',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 15:23:46','',''),(1415,'21','227','1',1,'Retail Sale Id 1867',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 15:25:02','',''),(1416,'21','227','1',1,'Retail Sale Id 1868',995.60,0.00,0.00,1.31,0.00,'2022-06-18 15:25:59','',''),(1417,'21','227','1',1,'Retail Sale Id 1869',3496.00,0.00,0.00,4.60,0.00,'2022-06-18 15:27:20','',''),(1418,'21','227','1',1,'Retail Sale Id 1870',995.60,0.00,0.00,1.31,0.00,'2022-06-18 15:38:53','',''),(1419,'21','227','1',1,'Retail Sale Id 1871',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 15:40:45','',''),(1420,'21','227','1',1,'Retail Sale Id 1872',3997.60,0.00,0.00,5.26,0.00,'2022-06-18 15:43:24','',''),(1421,'21','227','1',1,'Retail Sale Id 1873',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 15:53:10','',''),(1422,'21','227','1',1,'Retail Sale Id 1874',995.60,0.00,0.00,1.31,0.00,'2022-06-18 16:08:06','',''),(1423,'21','227','1',1,'Retail Sale Id 1875',3800.00,0.00,0.00,5.00,0.00,'2022-06-18 16:10:04','',''),(1424,'21','227','1',1,'Retail Sale Id 1876',995.60,0.00,0.00,1.31,0.00,'2022-06-18 16:14:26','',''),(1425,'21','227','1',1,'Retail Sale Id 1877',494.00,0.00,0.00,0.65,0.00,'2022-06-18 16:20:48','',''),(1426,'21','227','1',1,'Retail Sale Id 1878',995.60,0.00,0.00,1.31,0.00,'2022-06-18 16:39:39','',''),(1427,'21','227','1',1,'Retail Sale Id 1879',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 16:40:55','',''),(1428,'21','227','1',1,'Retail Sale Id 1880',8998.40,0.00,0.00,11.84,0.00,'2022-06-18 16:47:08','',''),(1429,'21','227','1',1,'Retail Sale Id 1881',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 16:51:48','',''),(1430,'21','227','1',1,'Retail Sale Id 1882',760.00,0.00,0.00,1.00,0.00,'2022-06-18 16:52:29','',''),(1431,'21','227','1',1,'Retail Sale Id 1883',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 16:55:24','',''),(1432,'21','227','1',1,'Retail Sale Id 1884',2295.20,0.00,0.00,3.02,0.00,'2022-06-18 16:58:26','',''),(1433,'21','227','1',1,'Retail Sale Id 1885',995.60,0.00,0.00,1.31,0.00,'2022-06-18 17:00:30','',''),(1434,'21','227','1',1,'Retail Sale Id 1886',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 17:03:24','',''),(1435,'21','227','1',1,'Retail Sale Id 1887',2492.80,0.00,0.00,3.28,0.00,'2022-06-18 17:06:55','',''),(1436,'21','227','1',1,'Retail Sale Id 1888',592.80,0.00,0.00,0.78,0.00,'2022-06-18 17:08:50','',''),(1437,'21','227','1',1,'Retail Sale Id 1889',995.60,0.00,0.00,1.31,0.00,'2022-06-18 17:15:01','',''),(1438,'21','227','1',1,'Retail Sale Id 1890',995.60,0.00,0.00,1.31,0.00,'2022-06-18 17:16:43','',''),(1439,'21','227','1',1,'Retail Sale Id 1891',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 17:18:41','',''),(1440,'21','227','1',1,'Retail Sale Id 1892',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 17:21:04','',''),(1441,'21','227','1',1,'Retail Sale Id 1893',3496.00,0.00,0.00,4.60,0.00,'2022-06-18 17:22:45','',''),(1442,'21','227','1',1,'Retail Sale Id 1894',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 17:26:13','',''),(1443,'21','227','1',1,'Retail Sale Id 1894',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 17:26:13','',''),(1444,'21','227','1',1,'Retail Sale Id 1895',995.60,0.00,0.00,1.31,0.00,'2022-06-18 17:47:55','',''),(1445,'21','227','1',1,'Retail Sale Id 1896',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 17:49:25','',''),(1446,'21','227','1',1,'Retail Sale Id 1897',494.00,0.00,0.00,0.65,0.00,'2022-06-18 18:08:59','',''),(1447,'21','227','1',1,'Retail Sale Id 1898',2492.80,0.00,0.00,3.28,0.00,'2022-06-18 18:10:20','',''),(1448,'21','227','1',1,'Retail Sale Id 1899',2994.40,0.00,0.00,3.94,0.00,'2022-06-18 18:11:40','',''),(1449,'21','227','1',1,'Retail Sale Id 1900',995.60,0.00,0.00,1.31,0.00,'2022-06-18 18:13:39','',''),(1450,'21','227','1',1,'Retail Sale Id 1901',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 18:19:05','',''),(1451,'21','227','1',1,'Retail Sale Id 1902',798.00,0.00,0.00,1.05,0.00,'2022-06-18 18:20:54','',''),(1452,'21','227','1',1,'Retail Sale Id 1903',995.60,0.00,0.00,1.31,0.00,'2022-06-18 18:24:31','',''),(1453,'21','227','1',1,'Retail Sale Id 1904',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 18:25:47','',''),(1454,'21','227','1',1,'Retail Sale Id 1905',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 18:27:21','',''),(1455,'21','227','1',1,'Retail Sale Id 1906',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 18:29:41','',''),(1456,'21','227','1',1,'Retail Sale Id 1907',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 18:31:05','',''),(1457,'21','227','1',1,'Retail Sale Id 1908',1998.80,0.00,0.00,2.63,0.00,'2022-06-18 18:34:24','',''),(1458,'21','227','1',1,'Retail Sale Id 1909',798.00,0.00,0.00,1.05,0.00,'2022-06-18 18:35:50','',''),(1459,'21','227','1',1,'Retail Sale Id 1910',1094.40,0.00,0.00,1.44,0.00,'2022-06-18 18:36:49','',''),(1460,'21','227','1',1,'Retail Sale Id 1911',6999.60,0.00,0.00,9.21,0.00,'2022-06-18 18:38:51','',''),(1461,'21','227','1',1,'Retail Sale Id 1912',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 18:42:05','',''),(1462,'21','227','1',1,'Retail Sale Id 1913',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:17:13','',''),(1463,'21','227','1',1,'Retail Sale Id 1914',2994.40,0.00,0.00,3.94,0.00,'2022-06-19 15:17:53','',''),(1464,'21','227','1',1,'Retail Sale Id 1915',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:18:17','',''),(1465,'21','227','1',1,'Retail Sale Id 1916',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 15:19:12','',''),(1466,'21','227','1',1,'Retail Sale Id 1917',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:19:37','',''),(1467,'21','227','1',1,'Retail Sale Id 1918',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 15:20:01','',''),(1468,'21','227','1',1,'Retail Sale Id 1919',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:20:25','',''),(1469,'21','227','1',1,'Retail Sale Id 1920',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 15:20:49','',''),(1470,'21','227','1',1,'Retail Sale Id 1921',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:21:18','',''),(1471,'21','227','1',1,'Retail Sale Id 1922',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 15:21:41','',''),(1472,'21','227','1',1,'Retail Sale Id 1923',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 15:22:03','',''),(1473,'21','227','1',1,'Retail Sale Id 1924',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:22:28','',''),(1474,'21','227','1',1,'Retail Sale Id 1925',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 15:22:50','',''),(1475,'21','227','1',1,'Retail Sale Id 1926',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:23:10','',''),(1476,'21','227','1',1,'Retail Sale Id 1927',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:23:38','',''),(1477,'21','227','1',1,'Retail Sale Id 1928',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 15:24:01','',''),(1478,'21','227','1',1,'Retail Sale Id 1929',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 15:24:21','',''),(1479,'21','227','1',1,'Retail Sale Id 1930',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 15:24:44','',''),(1480,'21','227','1',1,'Retail Sale Id 1931',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:25:08','',''),(1481,'21','227','1',1,'Retail Sale Id 1932',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 15:25:30','',''),(1482,'21','227','1',1,'Retail Sale Id 1933',995.60,0.00,0.00,1.31,0.00,'2022-06-19 15:25:54','',''),(1483,'21','227','1',1,'Retail Sale Id 1934',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 15:26:19','',''),(1484,'21','227','1',1,'Retail Sale Id 1935',8398.00,0.00,0.00,11.05,0.00,'2022-06-19 15:26:51','',''),(1485,'21','227','1',1,'Retail Sale Id 1936',995.60,0.00,0.00,1.31,0.00,'2022-06-19 15:27:15','',''),(1486,'21','227','1',1,'Retail Sale Id 1937',798.00,0.00,0.00,1.05,0.00,'2022-06-19 15:27:39','',''),(1487,'21','227','1',1,'Retail Sale Id 1938',6999.60,0.00,0.00,9.21,0.00,'2022-06-19 15:28:04','',''),(1488,'21','227','1',1,'Retail Sale Id 1939',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:28:30','',''),(1489,'21','227','1',1,'Retail Sale Id 1940',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 15:29:00','',''),(1490,'21','227','1',1,'Retail Sale Id 1941',2492.80,0.00,0.00,3.28,0.00,'2022-06-19 15:29:22','',''),(1491,'21','227','1',1,'Retail Sale Id 1942',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:29:45','',''),(1492,'21','227','1',1,'Retail Sale Id 1943',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 15:30:08','',''),(1493,'21','227','1',1,'Retail Sale Id 1944',995.60,0.00,0.00,1.31,0.00,'2022-06-19 15:30:31','',''),(1494,'21','227','1',1,'Retail Sale Id 1945',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 15:30:54','',''),(1495,'21','227','1',1,'Retail Sale Id 1946',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:31:17','',''),(1496,'21','227','1',1,'Retail Sale Id 1947',3040.00,0.00,0.00,4.00,0.00,'2022-06-19 15:31:41','',''),(1497,'21','227','1',1,'Retail Sale Id 1948',1094.40,0.00,0.00,1.44,0.00,'2022-06-19 15:32:05','',''),(1498,'21','227','1',1,'Retail Sale Id 1949',995.60,0.00,0.00,1.31,0.00,'2022-06-19 15:32:34','',''),(1499,'21','227','1',1,'Retail Sale Id 1950',4993.20,0.00,0.00,6.57,0.00,'2022-06-19 15:33:09','',''),(1500,'21','227','1',1,'Retail Sale Id 1951',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:33:33','',''),(1501,'21','227','1',1,'Retail Sale Id 1952',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 15:33:57','',''),(1502,'21','227','1',1,'Retail Sale Id 1953',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 15:34:20','',''),(1503,'21','227','1',1,'Retail Sale Id 1954',760.00,0.00,0.00,1.00,0.00,'2022-06-19 15:35:07','',''),(1504,'21','227','1',1,'Retail Sale Id 1954',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:35:07','',''),(1505,'21','227','1',1,'Retail Sale Id 1954',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 15:35:07','',''),(1506,'21','227','1',1,'Retail Sale Id 1955',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 15:35:44','',''),(1507,'21','227','1',1,'Retail Sale Id 1955',4993.20,0.00,0.00,6.57,0.00,'2022-06-19 15:35:44','',''),(1508,'21','227','1',1,'Retail Sale Id 1956',995.60,0.00,0.00,1.31,0.00,'2022-06-19 15:36:17','',''),(1509,'21','227','1',1,'Retail Sale Id 1957',760.00,0.00,0.00,1.00,0.00,'2022-06-19 15:37:05','',''),(1510,'21','227','1',1,'Retail Sale Id 1957',1193.20,0.00,0.00,1.57,0.00,'2022-06-19 15:37:05','',''),(1511,'21','227','1',1,'Retail Sale Id 1957',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 15:37:05','',''),(1512,'21','227','1',1,'Retail Sale Id 1958',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:37:42','',''),(1513,'21','227','1',1,'Retail Sale Id 1959',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:38:03','',''),(1514,'21','227','1',1,'Retail Sale Id 1960',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 15:38:32','',''),(1515,'21','227','1',1,'Retail Sale Id 1961',995.60,0.00,0.00,1.31,0.00,'2022-06-19 15:38:54','',''),(1516,'21','227','1',1,'Retail Sale Id 1962',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 15:39:18','',''),(1517,'21','227','1',1,'Retail Sale Id 1963',1345.20,0.00,0.00,1.77,0.00,'2022-06-19 15:39:42','',''),(1518,'21','227','1',1,'Retail Sale Id 1965',995.60,0.00,0.00,1.31,0.00,'2022-06-19 15:40:33','',''),(1519,'21','227','1',1,'Retail Sale Id 1966',1299.60,0.00,0.00,1.71,0.00,'2022-06-19 15:49:29','',''),(1520,'21','227','1',1,'Retail Sale Id 1967',995.60,0.00,0.00,1.31,0.00,'2022-06-19 15:49:54','',''),(1521,'21','227','1',1,'Retail Sale Id 1968',798.00,0.00,0.00,1.05,0.00,'2022-06-19 15:50:17','',''),(1522,'21','227','1',1,'Retail Sale Id 1969',2394.00,0.00,0.00,3.15,0.00,'2022-06-19 15:50:40','',''),(1523,'21','227','1',1,'Retail Sale Id 1970',3496.00,0.00,0.00,4.60,0.00,'2022-06-19 15:51:05','',''),(1524,'21','227','1',1,'Retail Sale Id 1971',4499.20,0.00,0.00,5.92,0.00,'2022-06-19 15:51:29','',''),(1525,'21','227','1',1,'Retail Sale Id 1972',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 15:51:50','',''),(1526,'21','227','1',1,'Retail Sale Id 1973',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:52:09','',''),(1527,'21','227','1',1,'Retail Sale Id 1974',1292.00,0.00,0.00,1.70,0.00,'2022-06-19 15:52:32','',''),(1528,'21','227','1',1,'Retail Sale Id 1975',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 16:04:23','',''),(1529,'21','227','1',1,'Retail Sale Id 1976',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:04:46','',''),(1530,'21','227','1',1,'Retail Sale Id 1977',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 16:05:07','',''),(1531,'21','227','1',1,'Retail Sale Id 1978',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 16:05:31','',''),(1532,'21','227','1',1,'Retail Sale Id 1979',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 16:05:59','',''),(1533,'21','227','1',1,'Retail Sale Id 1980',2994.40,0.00,0.00,3.94,0.00,'2022-06-19 16:06:23','',''),(1534,'21','227','1',1,'Retail Sale Id 1981',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 16:06:47','',''),(1535,'21','227','1',1,'Retail Sale Id 1982',4499.20,0.00,0.00,5.92,0.00,'2022-06-19 16:07:16','',''),(1536,'21','227','1',1,'Retail Sale Id 1983',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 16:07:40','',''),(1537,'21','227','1',1,'Retail Sale Id 1985',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:08:47','',''),(1538,'21','227','1',1,'Retail Sale Id 1986',2994.40,0.00,0.00,3.94,0.00,'2022-06-19 16:09:08','',''),(1539,'21','227','1',1,'Retail Sale Id 1987',896.80,0.00,0.00,1.18,0.00,'2022-06-19 16:09:34','',''),(1540,'21','227','1',1,'Retail Sale Id 1988',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 16:09:56','',''),(1541,'21','227','1',1,'Retail Sale Id 1989',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:10:20','',''),(1542,'21','227','1',1,'Retail Sale Id 1990',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:10:50','',''),(1543,'21','227','1',1,'Retail Sale Id 1991',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 16:11:11','',''),(1544,'21','227','1',1,'Retail Sale Id 1992',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 16:15:58','',''),(1545,'21','227','1',1,'Retail Sale Id 1993',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:16:48','',''),(1546,'21','227','1',1,'Retail Sale Id 1994',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:19:15','',''),(1547,'21','227','1',1,'Retail Sale Id 1995',68.40,0.00,0.00,0.09,0.00,'2022-06-19 16:20:00','',''),(1548,'21','227','1',1,'Retail Sale Id 1996',494.00,0.00,0.00,0.65,0.00,'2022-06-19 16:20:33','',''),(1549,'21','227','1',1,'Retail Sale Id 1997',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 16:21:47','',''),(1550,'21','227','1',1,'Retail Sale Id 1997',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 16:21:47','',''),(1551,'21','227','1',1,'Retail Sale Id 1998',760.00,0.00,0.00,1.00,0.00,'2022-06-19 16:22:13','',''),(1552,'21','227','1',1,'Retail Sale Id 1999',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 16:22:45','',''),(1553,'21','227','1',1,'Retail Sale Id 2000',2994.40,0.00,0.00,3.94,0.00,'2022-06-19 16:23:13','',''),(1554,'21','227','1',1,'Retail Sale Id 2001',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:23:39','',''),(1555,'21','227','1',1,'Retail Sale Id 2002',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 16:24:18','',''),(1556,'21','227','1',1,'Retail Sale Id 2003',4294.00,0.00,0.00,5.65,0.00,'2022-06-19 16:24:53','',''),(1557,'21','227','1',1,'Retail Sale Id 2004',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 16:25:16','',''),(1558,'21','227','1',1,'Retail Sale Id 2005',760.00,0.00,0.00,1.00,0.00,'2022-06-19 16:25:46','',''),(1559,'21','227','1',1,'Retail Sale Id 2006',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 16:26:14','',''),(1560,'21','227','1',1,'Retail Sale Id 2007',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:26:48','',''),(1561,'21','227','1',1,'Retail Sale Id 2008',798.00,0.00,0.00,1.05,0.00,'2022-06-19 16:27:19','',''),(1562,'21','227','1',1,'Retail Sale Id 2009',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 16:27:48','',''),(1563,'21','227','1',1,'Retail Sale Id 2010',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 16:28:30','',''),(1564,'21','227','1',1,'Retail Sale Id 2011',494.00,0.00,0.00,0.65,0.00,'2022-06-19 16:28:52','',''),(1565,'21','227','1',1,'Retail Sale Id 2012',3496.00,0.00,0.00,4.60,0.00,'2022-06-19 16:29:38','',''),(1566,'21','227','1',1,'Retail Sale Id 2013',494.00,0.00,0.00,0.65,0.00,'2022-06-19 16:30:14','',''),(1567,'21','227','1',1,'Retail Sale Id 2014',798.00,0.00,0.00,1.05,0.00,'2022-06-19 16:30:45','',''),(1568,'21','227','1',1,'Retail Sale Id 2015',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 16:31:28','',''),(1569,'21','227','1',1,'Retail Sale Id 2016',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:37:30','',''),(1570,'21','227','1',1,'Retail Sale Id 2017',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 16:39:30','',''),(1571,'21','227','1',1,'Retail Sale Id 2018',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 16:42:15','',''),(1572,'21','227','1',1,'Retail Sale Id 2019',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:43:42','',''),(1573,'21','227','1',1,'Retail Sale Id 2020',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 16:44:28','',''),(1574,'21','227','1',1,'Retail Sale Id 2021',1193.20,0.00,0.00,1.57,0.00,'2022-06-19 16:46:35','',''),(1575,'21','227','1',1,'Retail Sale Id 2021',1596.00,0.00,0.00,2.10,0.00,'2022-06-19 16:46:35','',''),(1576,'21','227','1',1,'Retail Sale Id 2022',760.00,0.00,0.00,1.00,0.00,'2022-06-19 16:51:41','',''),(1577,'21','227','1',1,'Retail Sale Id 2023',494.00,0.00,0.00,0.65,0.00,'2022-06-19 16:52:12','',''),(1578,'21','227','1',1,'Retail Sale Id 2024',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 16:53:11','',''),(1579,'21','227','1',1,'Retail Sale Id 2025',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 16:56:50','',''),(1580,'21','227','1',1,'Retail Sale Id 2026',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 16:58:24','',''),(1581,'21','227','1',1,'Retail Sale Id 2027',1793.60,0.00,0.00,2.36,0.00,'2022-06-19 16:59:00','',''),(1582,'21','227','1',1,'Retail Sale Id 2028',995.60,0.00,0.00,1.31,0.00,'2022-06-19 16:59:30','',''),(1583,'21','227','1',1,'Retail Sale Id 2029',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 17:01:20','',''),(1584,'21','227','1',1,'Retail Sale Id 2030',4993.20,0.00,0.00,6.57,0.00,'2022-06-19 17:02:51','',''),(1585,'21','227','1',1,'Retail Sale Id 2031',995.60,0.00,0.00,1.31,0.00,'2022-06-19 17:07:51','',''),(1586,'21','227','1',1,'Retail Sale Id 2032',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 17:14:52','',''),(1587,'21','227','1',1,'Retail Sale Id 2033',995.60,0.00,0.00,1.31,0.00,'2022-06-19 17:15:39','',''),(1588,'21','227','1',1,'Retail Sale Id 2033',995.60,0.00,0.00,1.31,0.00,'2022-06-19 17:15:39','',''),(1589,'21','227','1',1,'Retail Sale Id 2034',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 17:21:40','',''),(1590,'21','227','1',1,'Retail Sale Id 2035',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 17:22:29','',''),(1591,'21','227','1',1,'Retail Sale Id 2036',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 17:23:06','',''),(1592,'21','227','1',1,'Retail Sale Id 2037',798.00,0.00,0.00,1.05,0.00,'2022-06-19 17:23:50','',''),(1593,'21','227','1',1,'Retail Sale Id 2038',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 17:25:06','',''),(1594,'21','227','1',1,'Retail Sale Id 2039',798.00,0.00,0.00,1.05,0.00,'2022-06-19 17:26:04','',''),(1595,'21','227','1',1,'Retail Sale Id 2040',494.00,0.00,0.00,0.65,0.00,'2022-06-19 17:32:36','',''),(1596,'21','227','1',1,'Retail Sale Id 2040',494.00,0.00,0.00,0.65,0.00,'2022-06-19 17:32:36','',''),(1597,'21','227','1',1,'Retail Sale Id 2041',995.60,0.00,0.00,1.31,0.00,'2022-06-19 17:35:32','',''),(1598,'21','227','1',1,'Retail Sale Id 2042',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 17:42:17','',''),(1599,'21','227','1',1,'Retail Sale Id 2043',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 17:43:28','',''),(1600,'21','227','1',1,'Retail Sale Id 2044',2196.40,0.00,0.00,2.89,0.00,'2022-06-19 17:46:29','',''),(1601,'21','227','1',1,'Retail Sale Id 2045',995.60,0.00,0.00,1.31,0.00,'2022-06-19 17:47:24','',''),(1602,'21','227','1',1,'Retail Sale Id 2046',1793.60,0.00,0.00,2.36,0.00,'2022-06-19 17:50:28','',''),(1603,'21','227','1',1,'Retail Sale Id 2047',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 17:53:25','',''),(1604,'21','227','1',1,'Retail Sale Id 2048',2994.40,0.00,0.00,3.94,0.00,'2022-06-19 17:59:36','',''),(1605,'21','227','1',1,'Retail Sale Id 2052',2492.80,0.00,0.00,3.28,0.00,'2022-06-19 18:01:24','',''),(1606,'21','227','1',1,'Retail Sale Id 2053',995.60,0.00,0.00,1.31,0.00,'2022-06-19 18:02:19','',''),(1607,'21','227','1',1,'Retail Sale Id 2054',995.60,0.00,0.00,1.31,0.00,'2022-06-19 18:06:31','',''),(1608,'21','227','1',1,'Retail Sale Id 2055',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 18:07:54','',''),(1609,'21','227','1',1,'Retail Sale Id 2056',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 18:08:57','',''),(1610,'21','227','1',1,'Retail Sale Id 2057',995.60,0.00,0.00,1.31,0.00,'2022-06-19 18:13:52','',''),(1611,'21','227','1',1,'Retail Sale Id 2058',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 18:15:55','',''),(1612,'21','227','1',1,'Retail Sale Id 2059',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 18:28:06','',''),(1613,'21','227','1',1,'Retail Sale Id 2060',2196.40,0.00,0.00,2.89,0.00,'2022-06-19 18:28:56','',''),(1614,'21','227','1',1,'Retail Sale Id 2051',2492.80,0.00,0.00,3.28,0.00,'2022-06-19 18:30:44','',''),(1615,'21','227','1',1,'Retail Sale Id 2061',2994.40,0.00,0.00,3.94,0.00,'2022-06-19 18:32:23','',''),(1616,'21','227','1',1,'Retail Sale Id 2062',995.60,0.00,0.00,1.31,0.00,'2022-06-19 18:32:56','',''),(1617,'21','227','1',1,'Retail Sale Id 2063',995.60,0.00,0.00,1.31,0.00,'2022-06-19 18:33:28','',''),(1618,'21','227','1',1,'Retail Sale Id 2064',4993.20,0.00,0.00,6.57,0.00,'2022-06-19 18:34:25','',''),(1619,'21','227','1',1,'Retail Sale Id 2065',798.00,0.00,0.00,1.05,0.00,'2022-06-19 18:35:04','',''),(1620,'21','227','1',1,'Retail Sale Id 2066',995.60,0.00,0.00,1.31,0.00,'2022-06-19 18:35:35','',''),(1621,'21','227','1',1,'Retail Sale Id 2067',995.60,0.00,0.00,1.31,0.00,'2022-06-19 18:38:50','',''),(1622,'21','227','1',1,'Retail Sale Id 1964',1345.20,0.00,0.00,1.77,0.00,'2022-06-19 18:48:03','',''),(1623,'21','227','1',1,'Retail Sale Id 2068',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 09:16:04','',''),(1624,'21','227','1',1,'Retail Sale Id 2069',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 09:18:29','',''),(1625,'21','227','1',1,'Retail Sale Id 2070',995.60,0.00,0.00,1.31,0.00,'2022-06-20 09:19:34','',''),(1626,'21','227','1',1,'Retail Sale Id 2071',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 09:21:00','',''),(1627,'21','227','1',1,'Retail Sale Id 2072',7600.00,0.00,0.00,10.00,0.00,'2022-06-20 09:22:56','',''),(1628,'21','227','1',1,'Retail Sale Id 2073',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 09:24:27','',''),(1629,'21','227','1',1,'Retail Sale Id 2074',1694.80,0.00,0.00,2.23,0.00,'2022-06-20 09:26:33','',''),(1630,'21','227','1',1,'Retail Sale Id 2075',798.00,0.00,0.00,1.05,0.00,'2022-06-20 09:28:43','',''),(1631,'21','227','1',1,'Retail Sale Id 2076',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 09:37:07','',''),(1632,'21','227','1',1,'Retail Sale Id 2077',4993.20,0.00,0.00,6.57,0.00,'2022-06-20 09:59:56','',''),(1633,'21','227','1',1,'Retail Sale Id 2078',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 10:01:27','',''),(1634,'21','227','1',1,'Retail Sale Id 2079',2492.80,0.00,0.00,3.28,0.00,'2022-06-20 10:08:51','',''),(1635,'21','227','1',1,'Retail Sale Id 2080',1793.60,0.00,0.00,2.36,0.00,'2022-06-20 10:14:47','',''),(1636,'21','227','1',1,'Retail Sale Id 2081',995.60,0.00,0.00,1.31,0.00,'2022-06-20 10:18:15','',''),(1637,'21','227','1',1,'Retail Sale Id 2082',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 10:40:46','',''),(1638,'21','227','1',1,'Retail Sale Id 2083',1398.40,0.00,0.00,1.84,0.00,'2022-06-20 10:49:29','',''),(1639,'21','227','1',1,'Retail Sale Id 2084',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 10:51:10','',''),(1640,'21','227','1',1,'Retail Sale Id 2085',7995.20,0.00,0.00,10.52,0.00,'2022-06-20 10:52:23','',''),(1641,'21','227','1',1,'Retail Sale Id 2086',4993.20,0.00,0.00,6.57,0.00,'2022-06-20 10:53:23','',''),(1642,'21','227','1',1,'Retail Sale Id 2087',1193.20,0.00,0.00,1.57,0.00,'2022-06-20 10:56:15','',''),(1643,'21','227','1',1,'Retail Sale Id 2088',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 10:58:04','',''),(1644,'21','227','1',1,'Retail Sale Id 2089',760.00,0.00,0.00,1.00,0.00,'2022-06-20 11:12:10','',''),(1645,'21','227','1',1,'Retail Sale Id 2090',798.00,0.00,0.00,1.05,0.00,'2022-06-20 11:13:13','',''),(1646,'21','227','1',1,'Retail Sale Id 2091',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 11:25:18','',''),(1647,'21','227','1',1,'Retail Sale Id 2092',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 11:29:11','',''),(1648,'21','227','1',1,'Retail Sale Id 2093',995.60,0.00,0.00,1.31,0.00,'2022-06-20 11:30:15','',''),(1649,'21','227','1',1,'Retail Sale Id 2094',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 11:41:33','',''),(1650,'21','227','1',1,'Retail Sale Id 2095',124640.00,0.00,0.00,164.00,0.00,'2022-06-20 12:06:38','',''),(1651,'21','227','1',1,'Retail Sale Id 2096',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 12:11:32','',''),(1652,'21','227','1',1,'Retail Sale Id 2097',995.60,0.00,0.00,1.31,0.00,'2022-06-20 12:12:18','',''),(1653,'21','227','1',1,'Retail Sale Id 2098',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 13:10:44','',''),(1654,'21','227','1',1,'Retail Sale Id 2099',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 13:13:44','',''),(1655,'21','227','1',1,'Retail Sale Id 2100',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 13:14:27','',''),(1656,'21','227','1',1,'Retail Sale Id 2101',995.60,0.00,0.00,1.31,0.00,'2022-06-20 13:22:52','',''),(1657,'21','227','1',1,'Retail Sale Id 2102',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 13:29:59','',''),(1658,'21','227','1',1,'Retail Sale Id 2103',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 13:35:27','',''),(1659,'21','227','1',1,'Retail Sale Id 2104',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 13:43:00','',''),(1660,'21','227','1',1,'Retail Sale Id 2105',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 13:45:28','',''),(1661,'21','227','1',1,'Retail Sale Id 2106',995.60,0.00,0.00,1.31,0.00,'2022-06-20 13:48:29','',''),(1662,'21','227','1',1,'Retail Sale Id 2107',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 13:50:10','',''),(1663,'21','227','1',1,'Retail Sale Id 2108',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 13:58:00','',''),(1664,'21','227','1',1,'Retail Sale Id 2109',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 13:59:02','',''),(1665,'21','227','1',1,'Retail Sale Id 2110',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 14:06:59','',''),(1666,'21','227','1',1,'Retail Sale Id 2111',14440.00,0.00,0.00,19.00,0.00,'2022-06-20 14:57:27','',''),(1667,'21','227','1',1,'Retail Sale Id 2112',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 15:02:22','',''),(1668,'21','227','1',1,'Retail Sale Id 2113',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 15:13:38','',''),(1669,'21','227','1',1,'Retail Sale Id 2114',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 15:19:48','',''),(1670,'21','227','1',1,'Retail Sale Id 2115',896.80,0.00,0.00,1.18,0.00,'2022-06-20 15:23:22','',''),(1671,'21','227','1',1,'Retail Sale Id 2116',1520.00,0.00,0.00,2.00,0.00,'2022-06-20 15:24:20','',''),(1672,'21','227','1',1,'Retail Sale Id 2117',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 15:26:35','',''),(1673,'21','227','1',1,'Retail Sale Id 2118',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 15:32:33','',''),(1674,'21','227','1',1,'Retail Sale Id 2119',494.00,0.00,0.00,0.65,0.00,'2022-06-20 15:34:04','',''),(1675,'21','227','1',1,'Retail Sale Id 2120',14440.00,0.00,0.00,19.00,0.00,'2022-06-20 16:09:04','',''),(1676,'21','227','1',1,'Retail Sale Id 2121',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 16:15:58','',''),(1677,'21','227','1',1,'Retail Sale Id 2122',699.20,0.00,0.00,0.92,0.00,'2022-06-20 16:25:29','',''),(1678,'21','227','1',1,'Retail Sale Id 2123',995.60,0.00,0.00,1.31,0.00,'2022-06-20 16:47:19','',''),(1679,'21','227','1',1,'Retail Sale Id 2124',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 16:48:20','',''),(1680,'21','227','1',1,'Retail Sale Id 2125',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 16:52:06','',''),(1681,'21','227','1',1,'Retail Sale Id 2126',995.60,0.00,0.00,1.31,0.00,'2022-06-20 16:56:33','',''),(1682,'21','227','1',1,'Retail Sale Id 2127',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 16:59:55','',''),(1683,'21','227','1',1,'Retail Sale Id 2128',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 17:01:40','',''),(1684,'21','227','1',1,'Retail Sale Id 2129',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 17:04:24','',''),(1685,'21','227','1',1,'Retail Sale Id 2130',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 17:15:10','',''),(1686,'21','227','1',1,'Retail Sale Id 2131',494.00,0.00,0.00,0.65,0.00,'2022-06-20 17:17:55','',''),(1687,'21','227','1',1,'Retail Sale Id 2132',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 17:20:59','',''),(1688,'21','227','1',1,'Retail Sale Id 2133',2492.80,0.00,0.00,3.28,0.00,'2022-06-20 17:21:59','',''),(1689,'21','227','1',1,'Retail Sale Id 2134',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 17:24:52','',''),(1690,'21','227','1',1,'Retail Sale Id 2136',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 17:25:39','',''),(1691,'21','227','1',1,'Retail Sale Id 2137',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 17:26:44','',''),(1692,'21','227','1',1,'Retail Sale Id 2138',2492.80,0.00,0.00,3.28,0.00,'2022-06-20 17:27:41','',''),(1693,'21','227','1',1,'Retail Sale Id 2140',995.60,0.00,0.00,1.31,0.00,'2022-06-20 17:30:00','',''),(1694,'21','227','1',1,'Retail Sale Id 2141',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 17:30:48','',''),(1695,'21','227','1',1,'Retail Sale Id 2142',798.00,0.00,0.00,1.05,0.00,'2022-06-20 17:32:18','',''),(1696,'21','227','1',1,'Retail Sale Id 2143',1793.60,0.00,0.00,2.36,0.00,'2022-06-20 17:39:42','',''),(1697,'21','227','1',1,'Retail Sale Id 2144',2196.40,0.00,0.00,2.89,0.00,'2022-06-20 17:42:09','',''),(1698,'21','227','1',1,'Retail Sale Id 2145',4598.00,0.00,0.00,6.05,0.00,'2022-06-20 17:43:46','',''),(1699,'21','227','1',1,'Retail Sale Id 2146',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 17:47:29','',''),(1700,'21','227','1',1,'Retail Sale Id 2147',1520.00,0.00,0.00,2.00,0.00,'2022-06-20 17:49:55','',''),(1701,'21','227','1',1,'Retail Sale Id 2148',798.00,0.00,0.00,1.05,0.00,'2022-06-20 17:52:30','',''),(1702,'21','227','1',1,'Retail Sale Id 2149',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 17:57:33','',''),(1703,'21','227','1',1,'Retail Sale Id 2150',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 18:03:52','',''),(1704,'21','227','1',1,'Retail Sale Id 2151',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 18:05:12','',''),(1705,'21','227','1',1,'Retail Sale Id 2151',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 18:05:12','',''),(1706,'21','227','1',1,'Retail Sale Id 2152',995.60,0.00,0.00,1.31,0.00,'2022-06-20 18:07:45','',''),(1707,'21','227','1',1,'Retail Sale Id 2152',995.60,0.00,0.00,1.31,0.00,'2022-06-20 18:07:45','',''),(1708,'21','227','1',1,'Retail Sale Id 2153',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 18:08:35','',''),(1709,'21','227','1',1,'Retail Sale Id 2154',2295.20,0.00,0.00,3.02,0.00,'2022-06-20 18:09:36','',''),(1710,'21','227','1',1,'Retail Sale Id 2155',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 18:10:28','',''),(1711,'21','227','1',1,'Retail Sale Id 2156',995.60,0.00,0.00,1.31,0.00,'2022-06-20 18:11:22','',''),(1712,'21','227','1',1,'Retail Sale Id 2156',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 18:11:22','',''),(1713,'21','227','1',1,'Retail Sale Id 2157',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 18:12:18','',''),(1714,'21','227','1',1,'Retail Sale Id 2158',18240.00,0.00,0.00,24.00,0.00,'2022-06-20 18:16:17','',''),(1715,'21','227','1',1,'Retail Sale Id 2159',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 18:20:11','',''),(1716,'21','227','1',1,'Retail Sale Id 2160',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 18:21:05','',''),(1717,'21','227','1',1,'Retail Sale Id 2139',995.60,0.00,0.00,1.31,0.00,'2022-06-20 18:24:53','',''),(1718,'21','227','1',1,'Retail Sale Id 2161',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 18:25:51','',''),(1719,'21','227','1',1,'Retail Sale Id 2135',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 18:26:36','',''),(1720,'21','227','1',1,'Retail Sale Id 2162',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 18:29:34','',''),(1721,'21','227','1',1,'Retail Sale Id 2163',4993.20,0.00,0.00,6.57,0.00,'2022-06-20 18:30:45','',''),(1722,'21','227','1',1,'Retail Sale Id 2164',7995.20,0.00,0.00,10.52,0.00,'2022-06-20 18:31:59','',''),(1723,'21','227','1',1,'Retail Sale Id 2165',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 18:32:52','',''),(1724,'21','227','1',1,'Retail Sale Id 2166',2994.40,0.00,0.00,3.94,0.00,'2022-06-20 18:34:13','',''),(1725,'21','227','1',1,'Retail Sale Id 2167',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 18:34:54','',''),(1726,'21','227','1',1,'Retail Sale Id 2168',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 18:35:39','',''),(1727,'21','227','1',1,'Retail Sale Id 2169',995.60,0.00,0.00,1.31,0.00,'2022-06-20 18:36:19','',''),(1728,'21','227','1',1,'Retail Sale Id 2170',4993.20,0.00,0.00,6.57,0.00,'2022-06-20 18:38:10','',''),(1729,'21','227','1',1,'Retail Sale Id 2171',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 09:00:52','',''),(1730,'21','227','1',1,'Retail Sale Id 2172',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 09:01:31','',''),(1731,'21','227','1',1,'Retail Sale Id 2173',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 09:02:26','',''),(1732,'21','227','1',1,'Retail Sale Id 2174',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 09:05:16','',''),(1733,'21','227','1',1,'Retail Sale Id 2175',1299.60,0.00,0.00,1.71,0.00,'2022-06-21 09:05:46','',''),(1734,'21','227','1',1,'Retail Sale Id 2176',2492.80,0.00,0.00,3.28,0.00,'2022-06-21 09:06:16','',''),(1735,'21','227','1',1,'Retail Sale Id 2177',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 09:06:42','',''),(1736,'21','227','1',1,'Retail Sale Id 2178',4499.20,0.00,0.00,5.92,0.00,'2022-06-21 09:07:09','',''),(1737,'21','227','1',1,'Retail Sale Id 2179',995.60,0.00,0.00,1.31,0.00,'2022-06-21 12:34:29','',''),(1738,'21','227','1',1,'Retail Sale Id 2180',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 12:34:51','',''),(1739,'21','227','1',1,'Retail Sale Id 2181',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 12:35:18','',''),(1740,'21','227','1',1,'Retail Sale Id 2182',798.00,0.00,0.00,1.05,0.00,'2022-06-21 12:35:44','',''),(1741,'21','227','1',1,'Retail Sale Id 2183',995.60,0.00,0.00,1.31,0.00,'2022-06-21 12:36:18','',''),(1742,'21','227','1',1,'Retail Sale Id 2184',4499.20,0.00,0.00,5.92,0.00,'2022-06-21 12:36:49','',''),(1743,'21','227','1',1,'Retail Sale Id 2185',1299.60,0.00,0.00,1.71,0.00,'2022-06-21 12:37:17','',''),(1744,'21','227','1',1,'Retail Sale Id 2186',2492.80,0.00,0.00,3.28,0.00,'2022-06-21 12:37:47','',''),(1745,'21','227','1',1,'Retail Sale Id 2187',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 12:38:31','',''),(1746,'21','227','1',1,'Retail Sale Id 2188',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 12:38:54','',''),(1747,'21','227','1',1,'Retail Sale Id 2189',1694.80,0.00,0.00,2.23,0.00,'2022-06-21 14:00:28','',''),(1748,'21','227','1',1,'Retail Sale Id 2190',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 14:01:29','',''),(1749,'21','227','1',1,'Retail Sale Id 2191',995.60,0.00,0.00,1.31,0.00,'2022-06-21 14:06:32','',''),(1750,'21','227','1',1,'Retail Sale Id 2192',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 14:09:45','',''),(1751,'21','227','1',1,'Retail Sale Id 2193',995.60,0.00,0.00,1.31,0.00,'2022-06-21 14:15:43','',''),(1752,'21','227','1',1,'Retail Sale Id 2194',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 14:16:19','',''),(1753,'21','227','1',1,'Retail Sale Id 2195',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 14:16:42','',''),(1754,'21','227','1',1,'Retail Sale Id 2196',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 14:17:04','',''),(1755,'21','227','1',1,'Retail Sale Id 2197',995.60,0.00,0.00,1.31,0.00,'2022-06-21 14:17:29','',''),(1756,'21','227','1',1,'Retail Sale Id 2198',2796.80,0.00,0.00,3.68,0.00,'2022-06-21 14:18:35','',''),(1757,'21','227','1',1,'Retail Sale Id 2199',19000.00,0.00,0.00,25.00,0.00,'2022-06-21 14:19:05','',''),(1758,'21','227','1',1,'Retail Sale Id 2200',2295.20,0.00,0.00,3.02,0.00,'2022-06-21 14:19:28','',''),(1759,'21','227','1',1,'Retail Sale Id 2201',2295.20,0.00,0.00,3.02,0.00,'2022-06-21 14:19:55','',''),(1760,'21','227','1',1,'Retail Sale Id 2202',1193.20,0.00,0.00,1.57,0.00,'2022-06-21 14:20:16','',''),(1761,'21','227','1',1,'Retail Sale Id 2203',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 14:20:49','',''),(1762,'21','227','1',1,'Retail Sale Id 2204',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 14:21:10','',''),(1763,'21','227','1',1,'Retail Sale Id 2205',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 14:21:38','',''),(1764,'21','227','1',1,'Retail Sale Id 2206',798.00,0.00,0.00,1.05,0.00,'2022-06-21 14:22:24','',''),(1765,'21','227','1',1,'Retail Sale Id 2206',4993.20,0.00,0.00,6.57,0.00,'2022-06-21 14:22:24','',''),(1766,'21','227','1',1,'Retail Sale Id 2207',699.20,0.00,0.00,0.92,0.00,'2022-06-21 14:22:50','',''),(1767,'21','227','1',1,'Retail Sale Id 2208',494.00,0.00,0.00,0.65,0.00,'2022-06-21 16:56:29','',''),(1768,'21','227','1',1,'Retail Sale Id 2209',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 16:56:52','',''),(1769,'21','227','1',1,'Retail Sale Id 2210',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 16:57:09','',''),(1770,'21','227','1',1,'Retail Sale Id 2211',1793.60,0.00,0.00,2.36,0.00,'2022-06-21 16:57:32','',''),(1771,'21','227','1',1,'Retail Sale Id 2212',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 16:57:59','',''),(1772,'21','227','1',1,'Retail Sale Id 2213',1793.60,0.00,0.00,2.36,0.00,'2022-06-21 16:58:29','',''),(1773,'21','227','1',1,'Retail Sale Id 2214',1793.60,0.00,0.00,2.36,0.00,'2022-06-21 16:58:55','',''),(1774,'21','227','1',1,'Retail Sale Id 2215',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 16:59:17','',''),(1775,'21','227','1',1,'Retail Sale Id 2216',2295.20,0.00,0.00,3.02,0.00,'2022-06-21 16:59:50','',''),(1776,'21','227','1',1,'Retail Sale Id 2217',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 17:00:14','',''),(1777,'21','227','1',1,'Retail Sale Id 2218',1094.40,0.00,0.00,1.44,0.00,'2022-06-21 17:00:57','',''),(1778,'21','227','1',1,'Retail Sale Id 2218',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 17:00:57','',''),(1779,'21','227','1',1,'Retail Sale Id 2218',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 17:00:57','',''),(1780,'21','227','1',1,'Retail Sale Id 2219',988.00,0.00,0.00,1.30,0.00,'2022-06-21 17:01:42','',''),(1781,'21','227','1',1,'Retail Sale Id 2219',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 17:01:42','',''),(1782,'21','227','1',1,'Retail Sale Id 2219',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 17:01:42','',''),(1783,'21','227','1',1,'Retail Sale Id 2220',2196.40,0.00,0.00,2.89,0.00,'2022-06-21 17:02:27','',''),(1784,'21','227','1',1,'Retail Sale Id 2220',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 17:02:27','',''),(1785,'21','227','1',1,'Retail Sale Id 2220',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 17:02:27','',''),(1786,'21','227','1',1,'Retail Sale Id 2221',1193.20,0.00,0.00,1.57,0.00,'2022-06-21 17:03:21','',''),(1787,'21','227','1',1,'Retail Sale Id 2221',2492.80,0.00,0.00,3.28,0.00,'2022-06-21 17:03:21','',''),(1788,'21','227','1',1,'Retail Sale Id 2221',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 17:03:21','',''),(1789,'21','227','1',1,'Retail Sale Id 2223',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:04:46','',''),(1790,'21','227','1',1,'Retail Sale Id 2223',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 17:04:46','',''),(1791,'21','227','1',1,'Retail Sale Id 2223',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:04:46','',''),(1792,'21','227','1',1,'Retail Sale Id 2223',2492.80,0.00,0.00,3.28,0.00,'2022-06-21 17:04:46','',''),(1793,'21','227','1',1,'Retail Sale Id 2224',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 17:06:31','',''),(1794,'21','227','1',1,'Retail Sale Id 2225',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 17:07:16','',''),(1795,'21','227','1',1,'Retail Sale Id 2225',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:07:16','',''),(1796,'21','227','1',1,'Retail Sale Id 2225',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 17:07:16','',''),(1797,'21','227','1',1,'Retail Sale Id 2226',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 17:08:11','',''),(1798,'21','227','1',1,'Retail Sale Id 2226',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:08:11','',''),(1799,'21','227','1',1,'Retail Sale Id 2226',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 17:08:11','',''),(1800,'21','227','1',1,'Retail Sale Id 2226',3997.60,0.00,0.00,5.26,0.00,'2022-06-21 17:08:11','',''),(1801,'21','227','1',1,'Retail Sale Id 2227',760.00,0.00,0.00,1.00,0.00,'2022-06-21 17:09:19','',''),(1802,'21','227','1',1,'Retail Sale Id 2227',798.00,0.00,0.00,1.05,0.00,'2022-06-21 17:09:19','',''),(1803,'21','227','1',1,'Retail Sale Id 2227',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:09:19','',''),(1804,'21','227','1',1,'Retail Sale Id 2227',2204.00,0.00,0.00,2.90,0.00,'2022-06-21 17:09:19','',''),(1805,'21','227','1',1,'Retail Sale Id 2227',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 17:09:19','',''),(1806,'21','227','1',1,'Retail Sale Id 2228',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:10:02','',''),(1807,'21','227','1',1,'Retail Sale Id 2228',1094.40,0.00,0.00,1.44,0.00,'2022-06-21 17:10:02','',''),(1808,'21','227','1',1,'Retail Sale Id 2228',1193.20,0.00,0.00,1.57,0.00,'2022-06-21 17:10:02','',''),(1809,'21','227','1',1,'Retail Sale Id 2229',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 17:10:58','',''),(1810,'21','227','1',1,'Retail Sale Id 2229',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 17:10:58','',''),(1811,'21','227','1',1,'Retail Sale Id 2230',1299.60,0.00,0.00,1.71,0.00,'2022-06-21 17:11:45','',''),(1812,'21','227','1',1,'Retail Sale Id 2230',1755.60,0.00,0.00,2.31,0.00,'2022-06-21 17:11:45','',''),(1813,'21','227','1',1,'Retail Sale Id 2230',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:11:45','',''),(1814,'21','227','1',1,'Retail Sale Id 2231',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 17:12:23','',''),(1815,'21','227','1',1,'Retail Sale Id 2231',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 17:12:23','',''),(1816,'21','227','1',1,'Retail Sale Id 2232',699.20,0.00,0.00,0.92,0.00,'2022-06-21 17:12:58','',''),(1817,'21','227','1',1,'Retail Sale Id 2232',798.00,0.00,0.00,1.05,0.00,'2022-06-21 17:12:58','',''),(1818,'21','227','1',1,'Retail Sale Id 2233',76000.00,0.00,0.00,100.00,0.00,'2022-06-21 17:23:22','',''),(1819,'21','227','1',1,'Retail Sale Id 2234',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:25:05','',''),(1820,'21','227','1',1,'Retail Sale Id 2234',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:25:05','',''),(1821,'21','227','1',1,'Retail Sale Id 2234',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:25:05','',''),(1822,'21','227','1',1,'Retail Sale Id 2235',1193.20,0.00,0.00,1.57,0.00,'2022-06-21 17:25:38','',''),(1823,'21','227','1',1,'Retail Sale Id 2236',1299.60,0.00,0.00,1.71,0.00,'2022-06-21 17:26:25','',''),(1824,'21','227','1',1,'Retail Sale Id 2237',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:27:26','',''),(1825,'21','227','1',1,'Retail Sale Id 2238',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:29:31','',''),(1826,'21','227','1',1,'Retail Sale Id 2238',4993.20,0.00,0.00,6.57,0.00,'2022-06-21 17:29:31','',''),(1827,'21','227','1',1,'Retail Sale Id 2238',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 17:29:31','',''),(1828,'21','227','1',1,'Retail Sale Id 2239',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 17:30:18','',''),(1829,'21','227','1',1,'Retail Sale Id 2240',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:31:37','',''),(1830,'21','227','1',1,'Retail Sale Id 2240',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:31:37','',''),(1831,'21','227','1',1,'Retail Sale Id 2240',1140.00,0.00,0.00,1.50,0.00,'2022-06-21 17:31:37','',''),(1832,'21','227','1',1,'Retail Sale Id 2241',2994.40,0.00,0.00,3.94,0.00,'2022-06-21 17:32:21','',''),(1833,'21','227','1',1,'Retail Sale Id 2242',798.00,0.00,0.00,1.05,0.00,'2022-06-21 17:32:49','',''),(1834,'21','227','1',1,'Retail Sale Id 2243',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:33:14','',''),(1835,'21','227','1',1,'Retail Sale Id 2244',1520.00,0.00,0.00,2.00,0.00,'2022-06-21 17:34:31','',''),(1836,'21','227','1',1,'Retail Sale Id 2245',2196.40,0.00,0.00,2.89,0.00,'2022-06-21 17:35:16','',''),(1837,'21','227','1',1,'Retail Sale Id 2246',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:36:39','',''),(1838,'21','227','1',1,'Retail Sale Id 2246',2492.80,0.00,0.00,3.28,0.00,'2022-06-21 17:36:39','',''),(1839,'21','227','1',1,'Retail Sale Id 2246',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 17:36:40','',''),(1840,'21','227','1',1,'Retail Sale Id 2247',3040.00,0.00,0.00,4.00,0.00,'2022-06-21 17:37:41','',''),(1841,'21','227','1',1,'Retail Sale Id 2247',7600.00,0.00,0.00,10.00,0.00,'2022-06-21 17:37:41','',''),(1842,'21','227','1',1,'Retail Sale Id 2247',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 17:37:41','',''),(1843,'21','227','1',1,'Retail Sale Id 2248',1793.60,0.00,0.00,2.36,0.00,'2022-06-21 17:38:43','',''),(1844,'21','227','1',1,'Retail Sale Id 2248',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:38:43','',''),(1845,'21','227','1',1,'Retail Sale Id 2248',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:38:43','',''),(1846,'21','227','1',1,'Retail Sale Id 2249',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:39:28','',''),(1847,'21','227','1',1,'Retail Sale Id 2249',1793.60,0.00,0.00,2.36,0.00,'2022-06-21 17:39:28','',''),(1848,'21','227','1',1,'Retail Sale Id 2250',2097.60,0.00,0.00,2.76,0.00,'2022-06-21 17:39:59','',''),(1849,'21','227','1',1,'Retail Sale Id 2251',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:40:45','',''),(1850,'21','227','1',1,'Retail Sale Id 2252',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 17:41:20','',''),(1851,'21','227','1',1,'Retail Sale Id 2253',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:42:53','',''),(1852,'21','227','1',1,'Retail Sale Id 2253',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 17:42:53','',''),(1853,'21','227','1',1,'Retail Sale Id 2254',995.60,0.00,0.00,1.31,0.00,'2022-06-21 17:43:47','',''),(1854,'21','227','1',1,'Retail Sale Id 2254',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 17:43:47','',''),(1855,'21','227','1',1,'Retail Sale Id 2255',896.80,0.00,0.00,1.18,0.00,'2022-06-21 17:44:46','',''),(1856,'21','227','1',1,'Retail Sale Id 2255',1193.20,0.00,0.00,1.57,0.00,'2022-06-21 17:44:46','',''),(1857,'21','227','1',1,'Retail Sale Id 2255',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 17:44:46','',''),(1858,'21','227','1',1,'Retail Sale Id 2256',3040.00,0.00,0.00,4.00,0.00,'2022-06-21 17:46:41','',''),(1859,'21','227','1',1,'Retail Sale Id 2258',2492.80,0.00,0.00,3.28,0.00,'2022-06-21 19:14:09','',''),(1860,'21','227','1',1,'Retail Sale Id 2259',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 19:14:29','',''),(1861,'21','227','1',1,'Retail Sale Id 2260',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 19:14:50','',''),(1862,'21','227','1',1,'Retail Sale Id 2261',4993.20,0.00,0.00,6.57,0.00,'2022-06-21 19:15:14','',''),(1863,'21','227','1',1,'Retail Sale Id 2262',995.60,0.00,0.00,1.31,0.00,'2022-06-21 19:15:38','',''),(1864,'21','227','1',1,'Retail Sale Id 2263',798.00,0.00,0.00,1.05,0.00,'2022-06-21 19:16:00','',''),(1865,'21','227','1',1,'Retail Sale Id 2264',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 19:16:22','',''),(1866,'21','227','1',1,'Retail Sale Id 2265',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 19:16:44','',''),(1867,'21','227','1',1,'Retail Sale Id 2266',5494.80,0.00,0.00,7.23,0.00,'2022-06-21 19:17:07','',''),(1868,'21','227','1',1,'Retail Sale Id 2267',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 19:17:30','',''),(1869,'21','227','1',1,'Retail Sale Id 2268',1998.80,0.00,0.00,2.63,0.00,'2022-06-21 19:18:15','',''),(1870,'21','227','1',1,'Retail Sale Id 2269',995.60,0.00,0.00,1.31,0.00,'2022-06-21 19:18:43','',''),(1871,'21','227','1',1,'Retail Sale Id 2270',1497.20,0.00,0.00,1.97,0.00,'2022-06-21 19:19:07','',''),(1872,'21','227','1',1,'Retail Sale Id 2271',995.60,0.00,0.00,1.31,0.00,'2022-06-21 19:19:32','',''),(1873,'21','227','1',1,'Retail Sale Id 2272',4560.00,0.00,0.00,6.00,0.00,'2022-06-21 19:19:54','',''),(1874,'21','227','1',1,'Retail Sale Id 2273',1398.40,0.00,0.00,1.84,0.00,'2022-06-21 19:20:21','',''),(1875,'21','227','1',1,'Retail Sale Id 2274',2295.20,0.00,0.00,3.02,0.00,'2022-06-21 19:20:44','',''),(1876,'21','227','1',1,'Retail Sale Id 2275',6057.20,0.00,0.00,7.97,0.00,'2022-06-21 19:22:45','',''),(1877,'21','227','1',1,'Retail Sale Id 2276',3040.00,0.00,0.00,4.00,0.00,'2022-06-22 08:42:53','',''),(1878,'21','227','1',1,'Retail Sale Id 2277',798.00,0.00,0.00,1.05,0.00,'2022-06-22 09:45:35','',''),(1879,'21','227','1',1,'Retail Sale Id 2278',995.60,0.00,0.00,1.31,0.00,'2022-06-22 09:49:28','',''),(1880,'21','227','1',1,'Retail Sale Id 2279',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 09:50:38','',''),(1881,'21','227','1',1,'Retail Sale Id 2280',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 09:53:00','',''),(1882,'21','227','1',1,'Retail Sale Id 2281',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 09:56:57','',''),(1883,'21','227','1',1,'Retail Sale Id 2282',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 10:00:58','',''),(1884,'21','227','1',1,'Retail Sale Id 2283',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:05:00','',''),(1885,'21','227','1',1,'Retail Sale Id 2284',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:06:55','',''),(1886,'21','227','1',1,'Retail Sale Id 2285',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 10:08:08','',''),(1887,'21','227','1',1,'Retail Sale Id 2286',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:12:19','',''),(1888,'21','227','1',1,'Retail Sale Id 2287',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 10:13:11','',''),(1889,'21','227','1',1,'Retail Sale Id 2288',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 10:14:07','',''),(1890,'21','227','1',1,'Retail Sale Id 2289',1520.00,0.00,0.00,2.00,0.00,'2022-06-22 10:15:16','',''),(1891,'21','227','1',1,'Retail Sale Id 2290',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 10:17:17','',''),(1892,'21','227','1',1,'Retail Sale Id 2291',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 10:18:14','',''),(1893,'21','227','1',1,'Retail Sale Id 2292',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 10:28:21','',''),(1894,'21','227','1',1,'Retail Sale Id 2293',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:29:07','',''),(1895,'21','227','1',1,'Retail Sale Id 2294',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:45:31','',''),(1896,'21','227','1',1,'Retail Sale Id 2295',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:56:09','',''),(1897,'21','227','1',1,'Retail Sale Id 2296',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 10:57:26','',''),(1898,'21','227','1',1,'Retail Sale Id 2297',15960.00,0.00,0.00,21.00,0.00,'2022-06-22 10:59:25','',''),(1899,'21','227','1',1,'Retail Sale Id 2298',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 11:00:50','',''),(1900,'21','227','1',1,'Retail Sale Id 2299',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 11:35:00','',''),(1901,'21','227','1',1,'Retail Sale Id 2300',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 11:35:38','',''),(1902,'21','227','1',1,'Retail Sale Id 2301',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 11:41:41','',''),(1903,'21','227','1',1,'Retail Sale Id 2302',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 12:06:37','',''),(1904,'21','227','1',1,'Retail Sale Id 2303',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 12:07:17','',''),(1905,'21','227','1',1,'Retail Sale Id 2304',995.60,0.00,0.00,1.31,0.00,'2022-06-22 12:24:08','',''),(1906,'21','227','1',1,'Retail Sale Id 2305',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 12:46:47','',''),(1907,'21','227','1',1,'Retail Sale Id 2306',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 13:26:17','',''),(1908,'21','227','1',1,'Retail Sale Id 2307',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 13:36:15','',''),(1909,'21','227','1',1,'Retail Sale Id 2308',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 13:44:45','',''),(1910,'21','227','1',1,'Retail Sale Id 2309',896.80,0.00,0.00,1.18,0.00,'2022-06-22 13:50:46','',''),(1911,'21','227','1',1,'Retail Sale Id 2310',11400.00,0.00,0.00,15.00,0.00,'2022-06-22 13:59:41','',''),(1912,'21','227','1',1,'Retail Sale Id 2311',4750.00,0.00,0.00,6.25,0.00,'2022-06-22 14:00:33','',''),(1913,'21','227','1',1,'Retail Sale Id 2312',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 14:03:58','',''),(1914,'21','227','1',1,'Retail Sale Id 2313',2112.80,0.00,0.00,2.78,0.00,'2022-06-22 14:12:44','',''),(1915,'21','227','1',1,'Retail Sale Id 2314',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 14:20:50','',''),(1916,'21','227','1',1,'Retail Sale Id 2315',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 14:21:40','',''),(1917,'21','227','1',1,'Retail Sale Id 2316',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 14:27:33','',''),(1918,'21','227','1',1,'Retail Sale Id 2317',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 14:29:01','',''),(1919,'21','227','1',1,'Retail Sale Id 2318',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 14:49:36','',''),(1920,'21','227','1',1,'Retail Sale Id 2319',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 15:10:26','',''),(1921,'21','227','1',1,'Retail Sale Id 2320',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 15:11:35','',''),(1922,'21','227','1',1,'Retail Sale Id 2321',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 15:32:20','',''),(1923,'21','227','1',1,'Retail Sale Id 2322',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 15:57:34','',''),(1924,'21','227','1',1,'Retail Sale Id 2323',6794.40,0.00,0.00,8.94,0.00,'2022-06-22 15:59:53','',''),(1925,'21','227','1',1,'Retail Sale Id 2324',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 16:11:38','',''),(1926,'21','227','1',1,'Retail Sale Id 2325',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 16:13:33','',''),(1927,'21','227','1',1,'Retail Sale Id 2326',995.60,0.00,0.00,1.31,0.00,'2022-06-22 16:15:17','',''),(1928,'21','227','1',1,'Retail Sale Id 2327',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 16:18:45','',''),(1929,'21','227','1',1,'Retail Sale Id 2328',760.00,0.00,0.00,1.00,0.00,'2022-06-22 16:21:38','',''),(1930,'21','227','1',1,'Retail Sale Id 2329',995.60,0.00,0.00,1.31,0.00,'2022-06-22 16:26:01','',''),(1931,'21','227','1',1,'Retail Sale Id 2330',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 16:30:34','',''),(1932,'21','227','1',1,'Retail Sale Id 2331',4499.20,0.00,0.00,5.92,0.00,'2022-06-22 16:33:21','',''),(1933,'21','227','1',1,'Retail Sale Id 2332',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 16:35:35','',''),(1934,'21','227','1',1,'Retail Sale Id 2333',4499.20,0.00,0.00,5.92,0.00,'2022-06-22 16:38:14','',''),(1935,'21','227','1',1,'Retail Sale Id 2334',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 16:39:19','',''),(1936,'21','227','1',1,'Retail Sale Id 2335',494.00,0.00,0.00,0.65,0.00,'2022-06-22 16:43:41','',''),(1937,'21','227','1',1,'Retail Sale Id 2336',798.00,0.00,0.00,1.05,0.00,'2022-06-22 16:45:25','',''),(1938,'21','227','1',1,'Retail Sale Id 2337',5996.40,0.00,0.00,7.89,0.00,'2022-06-22 16:47:25','',''),(1939,'21','227','1',1,'Retail Sale Id 2338',2492.80,0.00,0.00,3.28,0.00,'2022-06-22 16:47:58','',''),(1940,'21','227','1',1,'Retail Sale Id 2339',798.00,0.00,0.00,1.05,0.00,'2022-06-22 16:49:07','',''),(1941,'21','227','1',1,'Retail Sale Id 2340',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 16:49:51','',''),(1942,'21','227','1',1,'Retail Sale Id 2341',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 16:50:56','',''),(1943,'21','227','1',1,'Retail Sale Id 2342',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 16:51:34','',''),(1944,'21','227','1',1,'Retail Sale Id 2343',760.00,0.00,0.00,1.00,0.00,'2022-06-22 16:52:24','',''),(1945,'21','227','1',1,'Retail Sale Id 2344',995.60,0.00,0.00,1.31,0.00,'2022-06-22 16:58:03','',''),(1946,'21','227','1',1,'Retail Sale Id 2345',1520.00,0.00,0.00,2.00,0.00,'2022-06-22 16:59:54','',''),(1947,'21','227','1',1,'Retail Sale Id 2346',3997.60,0.00,0.00,5.26,0.00,'2022-06-22 17:01:06','',''),(1948,'21','227','1',1,'Retail Sale Id 2347',798.00,0.00,0.00,1.05,0.00,'2022-06-22 17:02:04','',''),(1949,'21','227','1',1,'Retail Sale Id 2348',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 17:06:22','',''),(1950,'21','227','1',1,'Retail Sale Id 2349',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 17:07:15','',''),(1951,'21','227','1',1,'Retail Sale Id 2350',494.00,0.00,0.00,0.65,0.00,'2022-06-22 17:08:28','',''),(1952,'21','227','1',1,'Retail Sale Id 2351',2492.80,0.00,0.00,3.28,0.00,'2022-06-22 17:09:37','',''),(1953,'21','227','1',1,'Retail Sale Id 2351',2994.40,0.00,0.00,3.94,0.00,'2022-06-22 17:09:37','',''),(1954,'21','227','1',1,'Retail Sale Id 2352',995.60,0.00,0.00,1.31,0.00,'2022-06-22 17:10:20','',''),(1955,'21','227','1',1,'Retail Sale Id 2353',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 17:11:14','',''),(1956,'21','227','1',1,'Retail Sale Id 2354',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 17:12:05','',''),(1957,'21','227','1',1,'Retail Sale Id 2355',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 17:16:21','',''),(1958,'21','227','1',1,'Retail Sale Id 2356',798.00,0.00,0.00,1.05,0.00,'2022-06-22 17:17:36','',''),(1959,'21','227','1',1,'Retail Sale Id 2357',7493.60,0.00,0.00,9.86,0.00,'2022-06-22 17:24:40','',''),(1960,'21','227','1',1,'Retail Sale Id 2358',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 17:29:46','',''),(1961,'21','227','1',1,'Retail Sale Id 2359',1900.00,0.00,0.00,2.50,0.00,'2022-06-22 17:37:00','',''),(1962,'21','227','1',1,'Retail Sale Id 2360',3997.60,0.00,0.00,5.26,0.00,'2022-06-22 17:41:42','',''),(1963,'21','227','1',1,'Retail Sale Id 2361',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 17:43:29','',''),(1964,'21','227','1',1,'Retail Sale Id 2362',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 17:44:24','',''),(1965,'21','227','1',1,'Retail Sale Id 2363',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 17:45:13','',''),(1966,'21','227','1',1,'Retail Sale Id 2364',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 17:45:53','',''),(1967,'21','227','1',1,'Retail Sale Id 2365',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 17:46:55','',''),(1968,'21','227','1',1,'Retail Sale Id 2366',494.00,0.00,0.00,0.65,0.00,'2022-06-22 17:49:02','',''),(1969,'21','227','1',1,'Retail Sale Id 2367',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 17:50:09','',''),(1970,'21','227','1',1,'Retail Sale Id 2368',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 17:51:11','',''),(1971,'21','227','1',1,'Retail Sale Id 2369',4993.20,0.00,0.00,6.57,0.00,'2022-06-22 17:55:37','',''),(1972,'21','227','1',1,'Retail Sale Id 2370',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 17:57:12','',''),(1973,'21','227','1',1,'Retail Sale Id 2371',896.80,0.00,0.00,1.18,0.00,'2022-06-22 17:58:11','',''),(1974,'21','227','1',1,'Retail Sale Id 2372',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 18:04:29','',''),(1975,'21','227','1',1,'Retail Sale Id 2373',995.60,0.00,0.00,1.31,0.00,'2022-06-22 18:05:18','',''),(1976,'21','227','1',1,'Retail Sale Id 2374',995.60,0.00,0.00,1.31,0.00,'2022-06-22 18:09:29','',''),(1977,'21','227','1',1,'Retail Sale Id 2375',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 18:11:01','',''),(1978,'21','227','1',1,'Retail Sale Id 2376',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 18:20:16','',''),(1979,'21','227','1',1,'Retail Sale Id 2377',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 18:23:08','',''),(1980,'21','227','1',1,'Retail Sale Id 2377',2994.40,0.00,0.00,3.94,0.00,'2022-06-22 18:23:08','',''),(1981,'21','227','1',1,'Retail Sale Id 2378',995.60,0.00,0.00,1.31,0.00,'2022-06-22 18:24:36','',''),(1982,'21','227','1',1,'Retail Sale Id 2379',4993.20,0.00,0.00,6.57,0.00,'2022-06-22 18:28:16','',''),(1983,'21','227','1',1,'Retail Sale Id 2380',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 18:30:46','',''),(1984,'21','227','1',1,'Retail Sale Id 2381',4993.20,0.00,0.00,6.57,0.00,'2022-06-22 18:32:32','',''),(1985,'21','227','1',1,'Retail Sale Id 2382',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 18:36:56','',''),(1986,'21','227','1',1,'Retail Sale Id 2383',1520.00,0.00,0.00,2.00,0.00,'2022-06-22 18:37:37','',''),(1987,'21','227','1',1,'Retail Sale Id 2384',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 18:43:49','',''),(1988,'21','227','1',1,'Retail Sale Id 2386',995.60,0.00,0.00,1.31,0.00,'2022-06-22 18:47:00','',''),(1989,'21','227','1',1,'Retail Sale Id 2387',6999.60,0.00,0.00,9.21,0.00,'2022-06-23 10:49:49','',''),(1990,'21','227','1',1,'Retail Sale Id 2388',798.00,0.00,0.00,1.05,0.00,'2022-06-23 10:52:51','',''),(1991,'21','227','1',1,'Retail Sale Id 2389',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 10:54:19','',''),(1992,'21','227','1',1,'Retail Sale Id 2390',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 10:55:38','',''),(1993,'21','227','1',1,'Retail Sale Id 2391',995.60,0.00,0.00,1.31,0.00,'2022-06-23 10:57:45','',''),(1994,'21','227','1',1,'Retail Sale Id 2392',2994.40,0.00,0.00,3.94,0.00,'2022-06-23 11:11:41','',''),(1995,'21','227','1',1,'Retail Sale Id 2393',995.60,0.00,0.00,1.31,0.00,'2022-06-23 12:02:27','',''),(1996,'21','227','1',1,'Retail Sale Id 2394',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 12:04:49','',''),(1997,'21','227','1',1,'Retail Sale Id 2395',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 12:06:31','',''),(1998,'21','227','1',1,'Retail Sale Id 2396',3997.60,0.00,0.00,5.26,0.00,'2022-06-23 12:08:10','',''),(1999,'21','227','1',1,'Retail Sale Id 2397',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:08:50','',''),(2000,'21','227','1',1,'Retail Sale Id 2398',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 12:09:44','',''),(2001,'21','227','1',1,'Retail Sale Id 2399',3040.00,0.00,0.00,4.00,0.00,'2022-06-23 12:10:55','',''),(2002,'21','227','1',1,'Retail Sale Id 2400',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 12:11:45','',''),(2003,'21','227','1',1,'Retail Sale Id 2401',5996.40,0.00,0.00,7.89,0.00,'2022-06-23 12:12:46','',''),(2004,'21','227','1',1,'Retail Sale Id 2402',494.00,0.00,0.00,0.65,0.00,'2022-06-23 12:14:52','',''),(2005,'21','227','1',1,'Retail Sale Id 2403',3040.00,0.00,0.00,4.00,0.00,'2022-06-23 12:16:14','',''),(2006,'21','227','1',1,'Retail Sale Id 2404',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 12:20:13','',''),(2007,'21','227','1',1,'Retail Sale Id 2405',4993.20,0.00,0.00,6.57,0.00,'2022-06-23 12:21:06','',''),(2008,'21','227','1',1,'Retail Sale Id 2406',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 12:21:51','',''),(2009,'21','227','1',1,'Retail Sale Id 2407',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 12:22:37','',''),(2010,'21','227','1',1,'Retail Sale Id 2408',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 12:23:39','',''),(2011,'21','227','1',1,'Retail Sale Id 2409',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:24:38','',''),(2012,'21','227','1',1,'Retail Sale Id 2410',1520.00,0.00,0.00,2.00,0.00,'2022-06-23 12:25:35','',''),(2013,'21','227','1',1,'Retail Sale Id 2411',1520.00,0.00,0.00,2.00,0.00,'2022-06-23 12:26:16','',''),(2014,'21','227','1',1,'Retail Sale Id 2412',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 12:27:02','',''),(2015,'21','227','1',1,'Retail Sale Id 2413',3997.60,0.00,0.00,5.26,0.00,'2022-06-23 12:28:00','',''),(2016,'21','227','1',1,'Retail Sale Id 2414',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 12:28:55','',''),(2017,'21','227','1',1,'Retail Sale Id 2415',6080.00,0.00,0.00,8.00,0.00,'2022-06-23 12:29:46','',''),(2018,'21','227','1',1,'Retail Sale Id 2417',3496.00,0.00,0.00,4.60,0.00,'2022-06-23 12:31:18','',''),(2019,'21','227','1',1,'Retail Sale Id 2416',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:32:20','',''),(2020,'21','227','1',1,'Retail Sale Id 2418',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:37:47','',''),(2021,'21','227','1',1,'Retail Sale Id 2419',15200.00,0.00,0.00,20.00,0.00,'2022-06-23 13:08:24','',''),(2022,'21','227','1',1,'Retail Sale Id 2420',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 13:14:24','',''),(2023,'21','227','1',1,'Retail Sale Id 2421',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 13:15:04','',''),(2024,'21','227','1',1,'Retail Sale Id 2422',2994.40,0.00,0.00,3.94,0.00,'2022-06-23 13:17:28','',''),(2025,'21','227','1',1,'Retail Sale Id 2423',3997.60,0.00,0.00,5.26,0.00,'2022-06-23 13:29:01','',''),(2026,'21','227','1',1,'Retail Sale Id 2424',2994.40,0.00,0.00,3.94,0.00,'2022-06-23 13:31:19','',''),(2027,'21','227','1',1,'Retail Sale Id 2425',995.60,0.00,0.00,1.31,0.00,'2022-06-23 13:34:21','',''),(2028,'21','227','1',1,'Retail Sale Id 2426',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 13:40:40','',''),(2029,'21','227','1',1,'Retail Sale Id 2427',995.60,0.00,0.00,1.31,0.00,'2022-06-23 13:42:18','',''),(2030,'21','227','1',1,'Retail Sale Id 2427',4993.20,0.00,0.00,6.57,0.00,'2022-06-23 13:42:18','',''),(2031,'21','227','1',1,'Retail Sale Id 2428',760.00,0.00,0.00,1.00,0.00,'2022-06-23 13:44:18','',''),(2032,'21','227','1',1,'Retail Sale Id 2429',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 13:54:11','',''),(2033,'21','227','1',1,'Retail Sale Id 2430',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:00:19','',''),(2034,'21','227','1',1,'Retail Sale Id 2431',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 14:05:44','',''),(2035,'21','227','1',1,'Retail Sale Id 2432',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 14:16:35','',''),(2036,'21','227','1',1,'Retail Sale Id 2433',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 14:21:16','',''),(2037,'21','227','1',1,'Retail Sale Id 2434',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 14:22:54','',''),(2038,'21','227','1',1,'Retail Sale Id 2435',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:23:48','',''),(2039,'21','227','1',1,'Retail Sale Id 2436',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:26:49','',''),(2040,'21','227','1',1,'Retail Sale Id 2437',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:29:43','',''),(2041,'21','227','1',1,'Retail Sale Id 2438',4993.20,0.00,0.00,6.57,0.00,'2022-06-23 14:33:40','',''),(2042,'21','227','1',1,'Retail Sale Id 2439',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:34:45','',''),(2043,'21','227','1',1,'Retail Sale Id 2440',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:36:15','',''),(2044,'21','227','1',1,'Retail Sale Id 2441',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:36:56','',''),(2045,'21','227','1',1,'Retail Sale Id 2442',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 14:37:41','',''),(2046,'21','227','1',1,'Retail Sale Id 2443',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 14:38:44','',''),(2047,'21','227','1',1,'Retail Sale Id 2444',494.00,0.00,0.00,0.65,0.00,'2022-06-23 14:39:24','',''),(2048,'21','227','1',1,'Retail Sale Id 2445',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:40:05','',''),(2049,'21','227','1',1,'Retail Sale Id 2446',4993.20,0.00,0.00,6.57,0.00,'2022-06-23 14:47:45','',''),(2050,'21','227','1',1,'Retail Sale Id 2447',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 14:49:06','',''),(2051,'21','227','1',1,'Retail Sale Id 2448',995.60,0.00,0.00,1.31,0.00,'2022-06-23 14:55:33','',''),(2052,'21','227','1',1,'Retail Sale Id 2449',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 15:00:25','',''),(2053,'21','227','1',1,'Retail Sale Id 2450',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 18:07:57','',''),(2054,'21','227','1',1,'Retail Sale Id 2451',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 18:08:56','',''),(2055,'21','227','1',1,'Retail Sale Id 2452',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:09:25','',''),(2056,'21','227','1',1,'Retail Sale Id 2453',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:10:32','',''),(2057,'21','227','1',1,'Retail Sale Id 2453',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 18:10:32','',''),(2058,'21','227','1',1,'Retail Sale Id 2453',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 18:10:32','',''),(2059,'21','227','1',1,'Retail Sale Id 2454',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 18:11:36','',''),(2060,'21','227','1',1,'Retail Sale Id 2454',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 18:11:36','',''),(2061,'21','227','1',1,'Retail Sale Id 2454',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 18:11:36','',''),(2062,'21','227','1',1,'Retail Sale Id 2455',1299.60,0.00,0.00,1.71,0.00,'2022-06-23 18:12:37','',''),(2063,'21','227','1',1,'Retail Sale Id 2455',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 18:12:37','',''),(2064,'21','227','1',1,'Retail Sale Id 2455',2994.40,0.00,0.00,3.94,0.00,'2022-06-23 18:12:37','',''),(2065,'21','227','1',1,'Retail Sale Id 2456',494.00,0.00,0.00,0.65,0.00,'2022-06-23 18:13:37','',''),(2066,'21','227','1',1,'Retail Sale Id 2456',1520.00,0.00,0.00,2.00,0.00,'2022-06-23 18:13:37','',''),(2067,'21','227','1',1,'Retail Sale Id 2456',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:13:37','',''),(2068,'21','227','1',1,'Retail Sale Id 2457',494.00,0.00,0.00,0.65,0.00,'2022-06-23 18:14:42','',''),(2069,'21','227','1',1,'Retail Sale Id 2457',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:14:42','',''),(2070,'21','227','1',1,'Retail Sale Id 2457',2698.00,0.00,0.00,3.55,0.00,'2022-06-23 18:14:42','',''),(2071,'21','227','1',1,'Retail Sale Id 2458',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 18:15:43','',''),(2072,'21','227','1',1,'Retail Sale Id 2458',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:15:43','',''),(2073,'21','227','1',1,'Retail Sale Id 2458',4993.20,0.00,0.00,6.57,0.00,'2022-06-23 18:15:43','',''),(2074,'21','227','1',1,'Retail Sale Id 2459',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:16:55','',''),(2075,'21','227','1',1,'Retail Sale Id 2459',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:16:55','',''),(2076,'21','227','1',1,'Retail Sale Id 2459',3693.60,0.00,0.00,4.86,0.00,'2022-06-23 18:16:55','',''),(2077,'21','227','1',1,'Retail Sale Id 2459',4993.20,0.00,0.00,6.57,0.00,'2022-06-23 18:16:55','',''),(2078,'21','227','1',1,'Retail Sale Id 2460',2994.40,0.00,0.00,3.94,0.00,'2022-06-23 18:18:33','',''),(2079,'21','227','1',1,'Retail Sale Id 2460',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 18:18:33','',''),(2080,'21','227','1',1,'Retail Sale Id 2460',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 18:18:33','',''),(2081,'21','227','1',1,'Retail Sale Id 2460',4993.20,0.00,0.00,6.57,0.00,'2022-06-23 18:18:33','',''),(2082,'21','227','1',1,'Retail Sale Id 2460',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 18:18:33','',''),(2083,'21','227','1',1,'Retail Sale Id 2460',14440.00,0.00,0.00,19.00,0.00,'2022-06-23 18:18:33','',''),(2084,'21','227','1',1,'Retail Sale Id 2461',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 18:20:11','',''),(2085,'21','227','1',1,'Retail Sale Id 2461',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:20:11','',''),(2086,'21','227','1',1,'Retail Sale Id 2461',2492.80,0.00,0.00,3.28,0.00,'2022-06-23 18:20:11','',''),(2087,'21','227','1',1,'Retail Sale Id 2461',2492.80,0.00,0.00,3.28,0.00,'2022-06-23 18:20:11','',''),(2088,'21','227','1',1,'Retail Sale Id 2461',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 18:20:11','',''),(2089,'21','227','1',1,'Retail Sale Id 2462',995.60,0.00,0.00,1.31,0.00,'2022-06-23 18:21:16','',''),(2090,'21','227','1',1,'Retail Sale Id 2462',995.60,0.00,0.00,1.31,0.00,'2022-06-23 18:21:16','',''),(2091,'21','227','1',1,'Retail Sale Id 2462',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:21:16','',''),(2092,'21','227','1',1,'Retail Sale Id 2462',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 18:21:16','',''),(2093,'21','227','1',1,'Retail Sale Id 2463',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 18:22:26','',''),(2094,'21','227','1',1,'Retail Sale Id 2463',2394.00,0.00,0.00,3.15,0.00,'2022-06-23 18:22:26','',''),(2095,'21','227','1',1,'Retail Sale Id 2463',2492.80,0.00,0.00,3.28,0.00,'2022-06-23 18:22:26','',''),(2096,'21','227','1',1,'Retail Sale Id 2463',8360.00,0.00,0.00,11.00,0.00,'2022-06-23 18:22:26','',''),(2097,'21','227','1',1,'Retail Sale Id 2464',1398.40,0.00,0.00,1.84,0.00,'2022-06-23 18:23:17','',''),(2098,'21','227','1',1,'Retail Sale Id 2464',1900.00,0.00,0.00,2.50,0.00,'2022-06-23 18:23:17','',''),(2099,'21','227','1',1,'Retail Sale Id 2465',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 18:24:17','',''),(2100,'21','227','1',1,'Retail Sale Id 2466',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 18:25:05','',''),(2101,'21','227','1',1,'Retail Sale Id 2467',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:25:57','',''),(2102,'21','227','1',1,'Retail Sale Id 2468',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:30:03','',''),(2103,'21','227','1',1,'Retail Sale Id 2469',995.60,0.00,0.00,1.31,0.00,'2022-06-23 18:31:53','',''),(2104,'21','227','1',1,'Retail Sale Id 2470',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 18:32:51','',''),(2105,'21','227','1',1,'Retail Sale Id 2471',9196.00,0.00,0.00,12.10,0.00,'2022-06-23 18:33:41','',''),(2106,'21','227','1',1,'Retail Sale Id 2472',995.60,0.00,0.00,1.31,0.00,'2022-06-23 18:35:37','',''),(2107,'21','227','1',1,'Retail Sale Id 2473',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 18:36:30','',''),(2108,'21','227','1',1,'Retail Sale Id 2474',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 18:37:34','',''),(2109,'21','227','1',1,'Retail Sale Id 2475',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 18:38:05','',''),(2110,'21','227','1',1,'Retail Sale Id 2476',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 18:38:52','',''),(2111,'21','227','1',1,'Retail Sale Id 2477',995.60,0.00,0.00,1.31,0.00,'2022-06-23 18:39:31','',''),(2112,'21','227','1',1,'Retail Sale Id 2478',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:40:05','',''),(2113,'21','227','1',1,'Retail Sale Id 2479',995.60,0.00,0.00,1.31,0.00,'2022-06-23 18:40:55','',''),(2114,'21','227','1',1,'Retail Sale Id 2480',995.60,0.00,0.00,1.31,0.00,'2022-06-23 18:42:24','',''),(2115,'21','227','1',1,'Retail Sale Id 2481',798.00,0.00,0.00,1.05,0.00,'2022-06-23 18:43:26','',''),(2116,'21','227','1',1,'Retail Sale Id 2482',995.60,0.00,0.00,1.31,0.00,'2022-06-23 18:44:33','',''),(2117,'21','227','1',1,'Retail Sale Id 2483',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 11:46:47','',''),(2118,'21','227','1',1,'Retail Sale Id 2484',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 11:48:05','',''),(2119,'21','227','1',1,'Retail Sale Id 2485',11992.80,0.00,0.00,15.78,0.00,'2022-06-24 11:48:41','',''),(2120,'21','227','1',1,'Retail Sale Id 2486',7995.20,0.00,0.00,10.52,0.00,'2022-06-24 11:49:23','',''),(2121,'21','227','1',1,'Retail Sale Id 2487',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 11:50:07','',''),(2122,'21','227','1',1,'Retail Sale Id 2488',14994.80,0.00,0.00,19.73,0.00,'2022-06-24 11:50:40','',''),(2123,'21','227','1',1,'Retail Sale Id 2489',19995.60,0.00,0.00,26.31,0.00,'2022-06-24 11:51:30','',''),(2124,'21','227','1',1,'Retail Sale Id 2490',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 11:52:07','',''),(2125,'21','227','1',1,'Retail Sale Id 2491',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 11:53:59','',''),(2126,'21','227','1',1,'Retail Sale Id 2492',4993.20,0.00,0.00,6.57,0.00,'2022-06-24 11:55:36','',''),(2127,'21','227','1',1,'Retail Sale Id 2493',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 11:56:04','',''),(2128,'21','227','1',1,'Retail Sale Id 2494',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 11:56:33','',''),(2129,'21','227','1',1,'Retail Sale Id 2495',494.00,0.00,0.00,0.65,0.00,'2022-06-24 11:58:57','',''),(2130,'21','227','1',1,'Retail Sale Id 2496',14326.00,0.00,0.00,18.85,0.00,'2022-06-24 12:00:38','',''),(2131,'21','227','1',1,'Retail Sale Id 2497',798.00,0.00,0.00,1.05,0.00,'2022-06-24 12:01:43','',''),(2132,'21','227','1',1,'Retail Sale Id 2498',2280.00,0.00,0.00,3.00,0.00,'2022-06-24 12:06:51','',''),(2133,'21','227','1',1,'Retail Sale Id 2499',4499.20,0.00,0.00,5.92,0.00,'2022-06-24 12:07:44','',''),(2134,'21','227','1',1,'Retail Sale Id 2500',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 12:13:03','',''),(2135,'21','227','1',1,'Retail Sale Id 2501',714.40,0.00,0.00,0.94,0.00,'2022-06-24 12:13:52','',''),(2136,'21','227','1',1,'Retail Sale Id 2502',1497.20,0.00,0.00,1.97,0.00,'2022-06-24 12:17:25','',''),(2137,'21','227','1',1,'Retail Sale Id 2503',1497.20,0.00,0.00,1.97,0.00,'2022-06-24 12:18:26','',''),(2138,'21','227','1',1,'Retail Sale Id 2504',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 12:19:05','',''),(2139,'21','227','1',1,'Retail Sale Id 2505',494.00,0.00,0.00,0.65,0.00,'2022-06-24 12:19:55','',''),(2140,'21','227','1',1,'Retail Sale Id 2506',4499.20,0.00,0.00,5.92,0.00,'2022-06-24 12:25:34','',''),(2141,'21','227','1',1,'Retail Sale Id 2507',995.60,0.00,0.00,1.31,0.00,'2022-06-24 12:26:25','',''),(2142,'21','227','1',1,'Retail Sale Id 2508',995.60,0.00,0.00,1.31,0.00,'2022-06-24 12:27:03','',''),(2143,'21','227','1',1,'Retail Sale Id 2509',798.00,0.00,0.00,1.05,0.00,'2022-06-24 12:27:44','',''),(2144,'21','227','1',1,'Retail Sale Id 2510',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 12:28:56','',''),(2145,'21','227','1',1,'Retail Sale Id 2511',995.60,0.00,0.00,1.31,0.00,'2022-06-24 12:30:40','',''),(2146,'21','227','1',1,'Retail Sale Id 2512',798.00,0.00,0.00,1.05,0.00,'2022-06-24 12:32:40','',''),(2147,'21','227','1',1,'Retail Sale Id 2513',32999.20,0.00,0.00,43.42,0.00,'2022-06-24 12:42:38','',''),(2148,'21','227','1',1,'Retail Sale Id 2514',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 12:48:56','',''),(2149,'21','227','1',1,'Retail Sale Id 2515',760.00,0.00,0.00,1.00,0.00,'2022-06-24 12:51:02','',''),(2150,'21','227','1',1,'Retail Sale Id 2516',2280.00,0.00,0.00,3.00,0.00,'2022-06-24 12:51:40','',''),(2151,'21','227','1',1,'Retail Sale Id 2517',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 14:14:01','',''),(2152,'21','227','1',1,'Retail Sale Id 2518',995.60,0.00,0.00,1.31,0.00,'2022-06-24 14:15:06','',''),(2153,'21','227','1',1,'Retail Sale Id 2518',2492.80,0.00,0.00,3.28,0.00,'2022-06-24 14:15:06','',''),(2154,'21','227','1',1,'Retail Sale Id 2519',1542.80,0.00,0.00,2.03,0.00,'2022-06-24 14:16:16','',''),(2155,'21','227','1',1,'Retail Sale Id 2520',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 14:16:55','',''),(2156,'21','227','1',1,'Retail Sale Id 2521',9994.00,0.00,0.00,13.15,0.00,'2022-06-24 14:18:18','',''),(2157,'21','227','1',1,'Retail Sale Id 2523',1497.20,0.00,0.00,1.97,0.00,'2022-06-24 14:19:28','',''),(2158,'21','227','1',1,'Retail Sale Id 2524',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 14:20:26','',''),(2159,'21','227','1',1,'Retail Sale Id 2525',16742.80,0.00,0.00,22.03,0.00,'2022-06-24 14:21:50','',''),(2160,'21','227','1',1,'Retail Sale Id 2526',5434.00,0.00,0.00,7.15,0.00,'2022-06-24 14:22:53','',''),(2161,'21','227','1',1,'Retail Sale Id 2527',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 14:23:39','',''),(2162,'21','227','1',1,'Retail Sale Id 2528',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 14:24:20','',''),(2163,'21','227','1',1,'Retail Sale Id 2529',1497.20,0.00,0.00,1.97,0.00,'2022-06-24 15:12:27','',''),(2164,'21','227','1',1,'Retail Sale Id 2530',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 15:13:06','',''),(2165,'21','227','1',1,'Retail Sale Id 2531',4499.20,0.00,0.00,5.92,0.00,'2022-06-24 15:13:35','',''),(2166,'21','227','1',1,'Retail Sale Id 2532',2280.00,0.00,0.00,3.00,0.00,'2022-06-24 15:14:05','',''),(2167,'21','227','1',1,'Retail Sale Id 2533',1497.20,0.00,0.00,1.97,0.00,'2022-06-24 15:14:40','',''),(2168,'21','227','1',1,'Retail Sale Id 2534',798.00,0.00,0.00,1.05,0.00,'2022-06-24 15:15:13','',''),(2169,'21','227','1',1,'Retail Sale Id 2535',494.00,0.00,0.00,0.65,0.00,'2022-06-24 15:15:39','',''),(2170,'21','227','1',1,'Retail Sale Id 2536',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 15:16:06','',''),(2171,'21','227','1',1,'Retail Sale Id 2537',5494.80,0.00,0.00,7.23,0.00,'2022-06-24 15:16:38','',''),(2172,'21','227','1',1,'Retail Sale Id 2538',2599.20,0.00,0.00,3.42,0.00,'2022-06-24 16:51:13','',''),(2173,'21','227','1',1,'Retail Sale Id 2539',760.00,0.00,0.00,1.00,0.00,'2022-06-24 16:52:23','',''),(2174,'21','227','1',1,'Retail Sale Id 2540',7600.00,0.00,0.00,10.00,0.00,'2022-06-24 16:53:08','',''),(2175,'21','227','1',1,'Retail Sale Id 2541',995.60,0.00,0.00,1.31,0.00,'2022-06-24 16:53:48','',''),(2176,'21','227','1',1,'Retail Sale Id 2542',4560.00,0.00,0.00,6.00,0.00,'2022-06-24 16:54:40','',''),(2177,'21','227','1',1,'Retail Sale Id 2543',995.60,0.00,0.00,1.31,0.00,'2022-06-24 16:55:37','',''),(2178,'21','227','1',1,'Retail Sale Id 2544',1497.20,0.00,0.00,1.97,0.00,'2022-06-24 16:56:30','',''),(2179,'21','227','1',1,'Retail Sale Id 2545',1368.00,0.00,0.00,1.80,0.00,'2022-06-24 16:57:38','',''),(2180,'21','227','1',1,'Retail Sale Id 2546',1520.00,0.00,0.00,2.00,0.00,'2022-06-24 16:58:46','',''),(2181,'21','227','1',1,'Retail Sale Id 2547',1436.40,0.00,0.00,1.89,0.00,'2022-06-24 17:00:07','',''),(2182,'21','227','1',1,'Retail Sale Id 2548',2492.80,0.00,0.00,3.28,0.00,'2022-06-24 17:01:01','',''),(2183,'21','227','1',1,'Retail Sale Id 2549',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 17:01:50','',''),(2184,'21','227','1',1,'Retail Sale Id 2550',7600.00,0.00,0.00,10.00,0.00,'2022-06-24 17:03:05','',''),(2185,'21','227','1',1,'Retail Sale Id 2550',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 17:03:05','',''),(2186,'21','227','1',1,'Retail Sale Id 2550',22898.80,0.00,0.00,30.13,0.00,'2022-06-24 17:03:05','',''),(2187,'21','227','1',1,'Retail Sale Id 2551',760.00,0.00,0.00,1.00,0.00,'2022-06-24 17:04:09','',''),(2188,'21','227','1',1,'Retail Sale Id 2551',7600.00,0.00,0.00,10.00,0.00,'2022-06-24 17:04:09','',''),(2189,'21','227','1',1,'Retail Sale Id 2551',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 17:04:09','',''),(2190,'21','227','1',1,'Retail Sale Id 2552',2295.20,0.00,0.00,3.02,0.00,'2022-06-24 17:05:40','',''),(2191,'21','227','1',1,'Retail Sale Id 2553',760.00,0.00,0.00,1.00,0.00,'2022-06-24 17:08:51','',''),(2192,'21','227','1',1,'Retail Sale Id 2554',995.60,0.00,0.00,1.31,0.00,'2022-06-24 17:10:11','',''),(2193,'21','227','1',1,'Retail Sale Id 2555',2994.40,0.00,0.00,3.94,0.00,'2022-06-24 17:12:00','',''),(2194,'21','227','1',1,'Retail Sale Id 2555',3997.60,0.00,0.00,5.26,0.00,'2022-06-24 17:12:00','',''),(2195,'21','227','1',1,'Retail Sale Id 2555',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 17:12:00','',''),(2196,'21','227','1',1,'Retail Sale Id 2556',995.60,0.00,0.00,1.31,0.00,'2022-06-24 17:12:55','',''),(2197,'21','227','1',1,'Retail Sale Id 2557',995.60,0.00,0.00,1.31,0.00,'2022-06-24 17:13:50','',''),(2198,'21','227','1',1,'Retail Sale Id 2558',34998.00,0.00,0.00,46.05,0.00,'2022-06-24 17:17:23','',''),(2199,'21','227','1',1,'Retail Sale Id 2559',995.60,0.00,0.00,1.31,0.00,'2022-06-24 17:18:04','',''),(2200,'21','227','1',1,'Retail Sale Id 2560',21994.40,0.00,0.00,28.94,0.00,'2022-06-24 17:18:53','',''),(2201,'21','227','1',1,'Retail Sale Id 2561',995.60,0.00,0.00,1.31,0.00,'2022-06-24 17:22:43','',''),(2202,'21','227','1',1,'Retail Sale Id 2562',3040.00,0.00,0.00,4.00,0.00,'2022-06-24 17:23:26','',''),(2203,'21','227','1',1,'Retail Sale Id 2563',995.60,0.00,0.00,1.31,0.00,'2022-06-24 17:24:16','',''),(2204,'21','227','1',1,'Retail Sale Id 2564',798.00,0.00,0.00,1.05,0.00,'2022-06-24 17:24:59','',''),(2205,'21','227','1',1,'Retail Sale Id 2565',995.60,0.00,0.00,1.31,0.00,'2022-06-24 17:26:01','',''),(2206,'21','227','1',1,'Retail Sale Id 2566',2280.00,0.00,0.00,3.00,0.00,'2022-06-24 17:26:40','',''),(2207,'21','227','1',1,'Retail Sale Id 2567',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 17:27:19','',''),(2208,'21','227','1',1,'Retail Sale Id 2568',2280.00,0.00,0.00,3.00,0.00,'2022-06-24 17:28:20','',''),(2209,'21','227','1',1,'Retail Sale Id 2569',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 17:38:31','',''),(2210,'21','227','1',1,'Retail Sale Id 2570',2994.40,0.00,0.00,3.94,0.00,'2022-06-24 17:40:39','',''),(2211,'21','227','1',1,'Retail Sale Id 2571',1520.00,0.00,0.00,2.00,0.00,'2022-06-24 17:45:42','',''),(2212,'21','227','1',1,'Retail Sale Id 2572',1193.20,0.00,0.00,1.57,0.00,'2022-06-24 17:46:42','',''),(2213,'21','227','1',1,'Retail Sale Id 2573',1140.00,0.00,0.00,1.50,0.00,'2022-06-24 17:47:25','',''),(2214,'21','227','1',1,'Retail Sale Id 2574',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 17:53:37','',''),(2215,'21','227','1',1,'Retail Sale Id 2575',798.00,0.00,0.00,1.05,0.00,'2022-06-24 17:54:51','',''),(2216,'21','227','1',1,'Retail Sale Id 2576',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 17:55:38','',''),(2217,'21','227','1',1,'Retail Sale Id 2577',1497.20,0.00,0.00,1.97,0.00,'2022-06-24 17:56:22','',''),(2218,'21','227','1',1,'Retail Sale Id 2578',1497.20,0.00,0.00,1.97,0.00,'2022-06-24 17:57:05','',''),(2219,'21','227','1',1,'Retail Sale Id 2579',2280.00,0.00,0.00,3.00,0.00,'2022-06-24 17:57:49','',''),(2220,'21','227','1',1,'Retail Sale Id 2580',1520.00,0.00,0.00,2.00,0.00,'2022-06-24 17:59:19','',''),(2221,'21','227','1',1,'Retail Sale Id 2581',798.00,0.00,0.00,1.05,0.00,'2022-06-24 18:00:58','',''),(2222,'21','227','1',1,'Retail Sale Id 2582',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 18:14:02','',''),(2223,'21','227','1',1,'Retail Sale Id 2583',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 18:23:31','',''),(2224,'21','227','1',1,'Retail Sale Id 2584',9568.40,0.00,0.00,12.59,0.00,'2022-06-24 18:41:38','',''),(2225,'21','227','1',1,'Retail Sale Id 2585',4864.00,0.00,0.00,6.40,0.00,'2022-06-25 09:51:44','',''),(2226,'21','227','1',1,'Retail Sale Id 2586',3997.60,0.00,0.00,5.26,0.00,'2022-06-25 14:18:30','',''),(2227,'21','227','1',1,'Retail Sale Id 2586',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 14:18:30','',''),(2228,'21','227','1',1,'Retail Sale Id 2587',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 14:19:04','',''),(2229,'21','227','1',1,'Retail Sale Id 2587',7600.00,0.00,0.00,10.00,0.00,'2022-06-25 14:19:04','',''),(2230,'21','227','1',1,'Retail Sale Id 2588',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 14:19:41','',''),(2231,'21','227','1',1,'Retail Sale Id 2588',4993.20,0.00,0.00,6.57,0.00,'2022-06-25 14:19:41','',''),(2232,'21','227','1',1,'Retail Sale Id 2589',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 14:20:43','',''),(2233,'21','227','1',1,'Retail Sale Id 2589',3199.60,0.00,0.00,4.21,0.00,'2022-06-25 14:20:43','',''),(2234,'21','227','1',1,'Retail Sale Id 2590',2492.80,0.00,0.00,3.28,0.00,'2022-06-25 14:22:55','',''),(2235,'21','227','1',1,'Retail Sale Id 2590',3997.60,0.00,0.00,5.26,0.00,'2022-06-25 14:22:55','',''),(2236,'21','227','1',1,'Retail Sale Id 2591',995.60,0.00,0.00,1.31,0.00,'2022-06-25 14:24:00','',''),(2237,'21','227','1',1,'Retail Sale Id 2591',1596.00,0.00,0.00,2.10,0.00,'2022-06-25 14:24:00','',''),(2238,'21','227','1',1,'Retail Sale Id 2592',2492.80,0.00,0.00,3.28,0.00,'2022-06-25 14:25:11','',''),(2239,'21','227','1',1,'Retail Sale Id 2592',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 14:25:11','',''),(2240,'21','227','1',1,'Retail Sale Id 2592',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 14:25:11','',''),(2241,'21','227','1',1,'Retail Sale Id 2593',4993.20,0.00,0.00,6.57,0.00,'2022-06-25 14:25:50','',''),(2242,'21','227','1',1,'Retail Sale Id 2593',11400.00,0.00,0.00,15.00,0.00,'2022-06-25 14:25:50','',''),(2243,'21','227','1',1,'Retail Sale Id 2594',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 14:26:38','',''),(2244,'21','227','1',1,'Retail Sale Id 2594',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 14:26:38','',''),(2245,'21','227','1',1,'Retail Sale Id 2594',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 14:26:38','',''),(2246,'21','227','1',1,'Retail Sale Id 2595',4993.20,0.00,0.00,6.57,0.00,'2022-06-25 14:27:31','',''),(2247,'21','227','1',1,'Retail Sale Id 2595',7600.00,0.00,0.00,10.00,0.00,'2022-06-25 14:27:31','',''),(2248,'21','227','1',1,'Retail Sale Id 2595',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 14:27:31','',''),(2249,'21','227','1',1,'Retail Sale Id 2596',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 14:28:51','',''),(2250,'21','227','1',1,'Retail Sale Id 2596',3997.60,0.00,0.00,5.26,0.00,'2022-06-25 14:28:51','',''),(2251,'21','227','1',1,'Retail Sale Id 2596',6080.00,0.00,0.00,8.00,0.00,'2022-06-25 14:28:51','',''),(2252,'21','227','1',1,'Retail Sale Id 2597',8740.00,0.00,0.00,11.50,0.00,'2022-06-25 14:29:39','',''),(2253,'21','227','1',1,'Retail Sale Id 2598',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 09:41:30','',''),(2254,'21','227','1',1,'Retail Sale Id 2599',995.60,0.00,0.00,1.31,0.00,'2022-06-27 12:03:04','',''),(2255,'21','227','1',1,'Retail Sale Id 2599',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 12:03:04','',''),(2256,'21','227','1',1,'Retail Sale Id 2599',4993.20,0.00,0.00,6.57,0.00,'2022-06-27 12:03:04','',''),(2257,'21','227','1',1,'Retail Sale Id 2600',995.60,0.00,0.00,1.31,0.00,'2022-06-27 12:05:11','',''),(2258,'21','227','1',1,'Retail Sale Id 2600',995.60,0.00,0.00,1.31,0.00,'2022-06-27 12:05:11','',''),(2259,'21','227','1',1,'Retail Sale Id 2600',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 12:05:11','',''),(2260,'21','227','1',1,'Retail Sale Id 2600',11400.00,0.00,0.00,15.00,0.00,'2022-06-27 12:05:11','',''),(2261,'21','227','1',1,'Retail Sale Id 2601',995.60,0.00,0.00,1.31,0.00,'2022-06-27 12:08:16','',''),(2262,'21','227','1',1,'Retail Sale Id 2601',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 12:08:16','',''),(2263,'21','227','1',1,'Retail Sale Id 2601',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 12:08:16','',''),(2264,'21','227','1',1,'Retail Sale Id 2601',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:08:16','',''),(2265,'21','227','1',1,'Retail Sale Id 2601',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:08:16','',''),(2266,'21','227','1',1,'Retail Sale Id 2602',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 12:11:09','',''),(2267,'21','227','1',1,'Retail Sale Id 2602',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 12:11:09','',''),(2268,'21','227','1',1,'Retail Sale Id 2602',4993.20,0.00,0.00,6.57,0.00,'2022-06-27 12:11:09','',''),(2269,'21','227','1',1,'Retail Sale Id 2602',7600.00,0.00,0.00,10.00,0.00,'2022-06-27 12:11:09','',''),(2270,'21','227','1',1,'Retail Sale Id 2602',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:11:09','',''),(2271,'21','227','1',1,'Retail Sale Id 2603',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 12:18:13','',''),(2272,'21','227','1',1,'Retail Sale Id 2603',7600.00,0.00,0.00,10.00,0.00,'2022-06-27 12:18:13','',''),(2273,'21','227','1',1,'Retail Sale Id 2603',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:18:13','',''),(2274,'21','227','1',1,'Retail Sale Id 2604',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 12:21:39','',''),(2275,'21','227','1',1,'Retail Sale Id 2604',3997.60,0.00,0.00,5.26,0.00,'2022-06-27 12:21:39','',''),(2276,'21','227','1',1,'Retail Sale Id 2604',7995.20,0.00,0.00,10.52,0.00,'2022-06-27 12:21:39','',''),(2277,'21','227','1',1,'Retail Sale Id 2604',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:21:39','',''),(2278,'21','227','1',1,'Retail Sale Id 2604',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:21:39','',''),(2279,'21','227','1',1,'Retail Sale Id 2604',38000.00,0.00,0.00,50.00,0.00,'2022-06-27 12:21:39','',''),(2280,'21','227','1',1,'Retail Sale Id 2605',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 12:29:20','',''),(2281,'21','227','1',1,'Retail Sale Id 2605',7600.00,0.00,0.00,10.00,0.00,'2022-06-27 12:29:20','',''),(2282,'21','227','1',1,'Retail Sale Id 2605',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:29:20','',''),(2286,'21','227','1',1,'Retail Sale Id 2606',3997.60,0.00,0.00,5.26,0.00,'2022-06-27 12:33:52','',''),(2287,'21','227','1',1,'Retail Sale Id 2606',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 12:33:52','',''),(2288,'21','227','1',1,'Retail Sale Id 2606',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:33:52','',''),(2289,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-06-27 13:26:36','',''),(2290,'21','227',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,3000.00,0.00,'2022-06-27 13:28:06','',''),(2291,'21','227','1',1,'Received from bridging 6',0.00,0.00,3000.00,0.00,0.00,'2022-06-27 13:28:06','',''),(2292,'21','227','1',1,'Retail Sale Id 2607',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 13:30:11','',''),(2293,'21','227','1',1,'Retail Sale Id 2607',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 13:30:11','',''),(2294,'21','227','1',1,'Retail Sale Id 2607',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 13:30:11','',''),(2295,'21','227','1',1,'Retail Sale Id 2607',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:30:11','',''),(2296,'21','227','1',1,'Retail Sale Id 2607',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:30:11','',''),(2297,'21','227','1',1,'Retail Sale Id 2607',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:30:11','',''),(2298,'21','227','1',1,'Retail Sale Id 2607',11400.00,0.00,0.00,15.00,0.00,'2022-06-27 13:30:11','',''),(2299,'21','227','1',1,'Retail Sale Id 2608',995.60,0.00,0.00,1.31,0.00,'2022-06-27 13:31:57','',''),(2300,'21','227','1',1,'Retail Sale Id 2608',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 13:31:57','',''),(2301,'21','227','1',1,'Retail Sale Id 2608',2492.80,0.00,0.00,3.28,0.00,'2022-06-27 13:31:57','',''),(2302,'21','227','1',1,'Retail Sale Id 2608',4750.00,0.00,0.00,6.25,0.00,'2022-06-27 13:31:57','',''),(2303,'21','227','1',1,'Retail Sale Id 2608',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:31:57','',''),(2304,'21','227','1',1,'Retail Sale Id 2608',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:31:57','',''),(2305,'21','227','1',1,'Retail Sale Id 2609',760.00,0.00,0.00,1.00,0.00,'2022-06-27 13:33:46','',''),(2306,'21','227','1',1,'Retail Sale Id 2609',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 13:33:46','',''),(2307,'21','227','1',1,'Retail Sale Id 2609',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 13:33:46','',''),(2308,'21','227','1',1,'Retail Sale Id 2609',2492.80,0.00,0.00,3.28,0.00,'2022-06-27 13:33:46','',''),(2309,'21','227','1',1,'Retail Sale Id 2609',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:33:46','',''),(2310,'21','227','1',1,'Retail Sale Id 2610',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 13:35:15','',''),(2311,'21','227','1',1,'Retail Sale Id 2610',7600.00,0.00,0.00,10.00,0.00,'2022-06-27 13:35:15','',''),(2312,'21','227','1',1,'Retail Sale Id 2610',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:35:15','',''),(2313,'21','227','1',1,'Retail Sale Id 2611',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 13:36:46','',''),(2314,'21','227','1',1,'Retail Sale Id 2611',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 13:36:46','',''),(2315,'21','227','1',1,'Retail Sale Id 2611',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 13:36:46','',''),(2316,'21','227','1',1,'Retail Sale Id 2611',4993.20,0.00,0.00,6.57,0.00,'2022-06-27 13:36:46','',''),(2317,'21','227','1',1,'Retail Sale Id 2611',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:36:46','',''),(2318,'21','227','1',1,'Retail Sale Id 2612',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 13:38:18','',''),(2319,'21','227','1',1,'Retail Sale Id 2612',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 13:38:18','',''),(2320,'21','227','1',1,'Retail Sale Id 2612',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 13:38:18','',''),(2321,'21','227','1',1,'Retail Sale Id 2612',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 13:38:18','',''),(2322,'21','227','1',1,'Retail Sale Id 2612',3997.60,0.00,0.00,5.26,0.00,'2022-06-27 13:38:18','',''),(2323,'21','227','1',1,'Retail Sale Id 2612',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:38:18','',''),(2324,'21','227','1',1,'Retail Sale Id 2613',995.60,0.00,0.00,1.31,0.00,'2022-06-27 13:40:03','',''),(2325,'21','227','1',1,'Retail Sale Id 2613',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 13:40:03','',''),(2326,'21','227','1',1,'Retail Sale Id 2613',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 13:40:03','',''),(2327,'21','227','1',1,'Retail Sale Id 2613',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 13:40:03','',''),(2328,'21','227','1',1,'Retail Sale Id 2613',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:40:03','',''),(2329,'21','227','1',1,'Retail Sale Id 2613',19000.00,0.00,0.00,25.00,0.00,'2022-06-27 13:40:03','',''),(2330,'21','227','1',1,'Retail Sale Id 2614',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 13:41:21','',''),(2331,'21','227','1',1,'Retail Sale Id 2614',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 13:41:21','',''),(2332,'21','227','1',1,'Retail Sale Id 2614',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 13:41:21','',''),(2333,'21','227','1',1,'Retail Sale Id 2614',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:41:21','',''),(2334,'21','227',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,2000.00,0.00,'2022-06-27 13:47:09','',''),(2335,'21','227','1',1,'Received from bridging 7',0.00,0.00,2000.00,0.00,0.00,'2022-06-27 13:47:09','',''),(2336,'21','227','1',1,'Retail Sale Id 2615',995.60,0.00,0.00,1.31,0.00,'2022-06-27 14:46:45','',''),(2337,'21','227','1',1,'Retail Sale Id 2616',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 14:48:03','',''),(2338,'21','227','1',1,'Retail Sale Id 2617',995.60,0.00,0.00,1.31,0.00,'2022-06-27 14:49:08','',''),(2339,'21','227','1',1,'Retail Sale Id 2618',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 14:49:47','',''),(2340,'21','227','1',1,'Retail Sale Id 2619',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 14:52:54','',''),(2341,'21','227','1',1,'Retail Sale Id 2620',1299.60,0.00,0.00,1.71,0.00,'2022-06-27 14:57:40','',''),(2342,'21','227','1',1,'Retail Sale Id 2621',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 15:02:52','',''),(2343,'21','227','1',1,'Retail Sale Id 2622',3496.00,0.00,0.00,4.60,0.00,'2022-06-27 15:06:39','',''),(2344,'21','227','1',1,'Retail Sale Id 2623',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:07:37','',''),(2345,'21','227','1',1,'Retail Sale Id 2624',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:12:09','',''),(2346,'21','227','1',1,'Retail Sale Id 2625',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 15:14:20','',''),(2347,'21','227','1',1,'Retail Sale Id 2626',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 15:15:47','',''),(2348,'21','227','1',1,'Retail Sale Id 2627',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:17:52','',''),(2349,'21','227','1',1,'Retail Sale Id 2628',995.60,0.00,0.00,1.31,0.00,'2022-06-27 15:19:09','',''),(2350,'21','227','1',1,'Retail Sale Id 2629',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 15:22:43','',''),(2351,'21','227','1',1,'Retail Sale Id 2630',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 15:26:32','',''),(2352,'21','227','1',1,'Retail Sale Id 2631',2492.80,0.00,0.00,3.28,0.00,'2022-06-27 15:27:39','',''),(2353,'21','227','1',1,'Retail Sale Id 2632',798.00,0.00,0.00,1.05,0.00,'2022-06-27 15:28:18','',''),(2354,'21','227','1',1,'Retail Sale Id 2633',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:29:00','',''),(2355,'21','227','1',1,'Retail Sale Id 2634',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:30:05','',''),(2356,'21','227','1',1,'Retail Sale Id 2635',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 15:31:20','',''),(2357,'21','227','1',1,'Retail Sale Id 2636',995.60,0.00,0.00,1.31,0.00,'2022-06-27 15:34:15','',''),(2358,'21','227','1',1,'Retail Sale Id 2637',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 15:35:41','',''),(2359,'21','227','1',1,'Retail Sale Id 2638',7600.00,0.00,0.00,10.00,0.00,'2022-06-27 15:36:23','',''),(2360,'21','227','1',1,'Retail Sale Id 2639',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:37:04','',''),(2361,'21','227','1',1,'Retail Sale Id 2640',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:38:33','',''),(2362,'21','227','1',1,'Retail Sale Id 2641',1520.00,0.00,0.00,2.00,0.00,'2022-06-27 15:39:23','',''),(2363,'21','227','1',1,'Retail Sale Id 2642',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:39:59','',''),(2364,'21','227','1',1,'Retail Sale Id 2643',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 15:40:34','',''),(2365,'21','227','1',1,'Retail Sale Id 2644',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:43:15','',''),(2366,'21','227','1',1,'Retail Sale Id 2645',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 15:43:52','',''),(2367,'21','227','1',1,'Retail Sale Id 2647',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 15:44:32','',''),(2368,'21','227','1',1,'Retail Sale Id 2648',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 15:45:18','',''),(2369,'21','227','1',1,'Retail Sale Id 2649',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:46:02','',''),(2370,'21','227','1',1,'Retail Sale Id 2650',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 15:46:40','',''),(2371,'21','227','1',1,'Retail Sale Id 2651',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 15:47:17','',''),(2372,'21','227','1',1,'Retail Sale Id 2652',4993.20,0.00,0.00,6.57,0.00,'2022-06-27 15:48:02','',''),(2373,'21','227','1',1,'Retail Sale Id 2653',7600.00,0.00,0.00,10.00,0.00,'2022-06-27 15:48:54','',''),(2374,'21','227','1',1,'Retail Sale Id 2654',7995.20,0.00,0.00,10.52,0.00,'2022-06-27 15:50:04','',''),(2375,'21','227','1',1,'Retail Sale Id 2655',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:50:53','',''),(2376,'21','227','1',1,'Retail Sale Id 2656',4993.20,0.00,0.00,6.57,0.00,'2022-06-27 15:51:42','',''),(2377,'21','227','1',1,'Retail Sale Id 2657',3997.60,0.00,0.00,5.26,0.00,'2022-06-27 15:52:24','',''),(2378,'21','227','1',1,'Retail Sale Id 2658',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:54:03','',''),(2379,'21','227','1',1,'Retail Sale Id 2659',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 15:55:25','',''),(2380,'21','227','1',1,'Retail Sale Id 2660',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 15:58:40','',''),(2381,'21','227','1',1,'Retail Sale Id 2661',896.80,0.00,0.00,1.18,0.00,'2022-06-27 15:59:31','',''),(2382,'21','227','1',1,'Retail Sale Id 2662',995.60,0.00,0.00,1.31,0.00,'2022-06-27 16:00:34','',''),(2383,'21','227','1',1,'Retail Sale Id 2663',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 16:01:31','',''),(2384,'21','227','1',1,'Retail Sale Id 2664',995.60,0.00,0.00,1.31,0.00,'2022-06-27 16:03:05','',''),(2385,'21','227','1',1,'Retail Sale Id 2665',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 16:04:05','',''),(2386,'21','227','1',1,'Retail Sale Id 2666',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 16:07:23','',''),(2387,'21','227','1',1,'Retail Sale Id 2668',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 16:09:17','',''),(2388,'21','227','1',1,'Retail Sale Id 2669',8740.00,0.00,0.00,11.50,0.00,'2022-06-27 16:11:06','',''),(2389,'21','227','1',1,'Retail Sale Id 2667',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 16:12:09','',''),(2390,'21','227','1',1,'Retail Sale Id 2670',3040.00,0.00,0.00,4.00,0.00,'2022-06-27 16:12:57','',''),(2391,'21','227','1',1,'Retail Sale Id 2671',494.00,0.00,0.00,0.65,0.00,'2022-06-27 16:15:44','',''),(2392,'21','227','1',1,'Retail Sale Id 2672',760.00,0.00,0.00,1.00,0.00,'2022-06-27 16:17:47','',''),(2393,'21','227','1',1,'Retail Sale Id 2673',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 16:18:54','',''),(2394,'21','227','1',1,'Retail Sale Id 2674',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 16:22:51','',''),(2395,'21','227','1',1,'Retail Sale Id 2675',3040.00,0.00,0.00,4.00,0.00,'2022-06-27 16:29:31','',''),(2396,'21','227','1',1,'Retail Sale Id 2676',1520.00,0.00,0.00,2.00,0.00,'2022-06-27 16:30:35','',''),(2397,'21','227','1',1,'Retail Sale Id 2677',995.60,0.00,0.00,1.31,0.00,'2022-06-27 16:31:39','',''),(2398,'21','227','1',1,'Retail Sale Id 2678',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 16:35:08','',''),(2399,'21','227','1',1,'Retail Sale Id 2679',995.60,0.00,0.00,1.31,0.00,'2022-06-27 16:36:04','',''),(2400,'21','227','1',1,'Retail Sale Id 2680',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 16:39:30','',''),(2401,'21','227','1',1,'Retail Sale Id 2681',1520.00,0.00,0.00,2.00,0.00,'2022-06-27 16:40:10','',''),(2402,'21','227','1',1,'Retail Sale Id 2682',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 16:40:50','',''),(2403,'21','227','1',1,'Retail Sale Id 2683',760.00,0.00,0.00,1.00,0.00,'2022-06-27 16:45:29','',''),(2404,'21','227','1',1,'Retail Sale Id 2684',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 16:46:05','',''),(2405,'21','227','1',1,'Retail Sale Id 2685',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 16:47:33','',''),(2406,'21','227','1',1,'Retail Sale Id 2686',995.60,0.00,0.00,1.31,0.00,'2022-06-27 16:48:33','',''),(2407,'21','227','1',1,'Retail Sale Id 2687',995.60,0.00,0.00,1.31,0.00,'2022-06-27 16:49:56','',''),(2408,'21','227','1',1,'Retail Sale Id 2688',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 16:50:44','',''),(2409,'21','227','1',1,'Retail Sale Id 2689',798.00,0.00,0.00,1.05,0.00,'2022-06-27 16:51:21','',''),(2410,'21','227','1',1,'Retail Sale Id 2690',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 16:53:21','',''),(2411,'21','227','1',1,'Retail Sale Id 2691',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 16:54:24','',''),(2412,'21','227','1',1,'Retail Sale Id 2692',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 16:55:14','',''),(2413,'21','227','1',1,'Retail Sale Id 2693',7600.00,0.00,0.00,10.00,0.00,'2022-06-27 16:55:57','',''),(2414,'21','227','1',1,'Retail Sale Id 2694',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 16:56:35','',''),(2415,'21','227','1',1,'Retail Sale Id 2695',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 16:57:16','',''),(2416,'21','227','1',1,'Retail Sale Id 2696',760.00,0.00,0.00,1.00,0.00,'2022-06-27 16:59:36','',''),(2417,'21','227','1',1,'Retail Sale Id 2697',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 17:02:27','',''),(2418,'21','227','1',1,'Retail Sale Id 2698',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 17:03:37','',''),(2419,'21','227','1',1,'Retail Sale Id 2699',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 17:04:22','',''),(2420,'21','227','1',1,'Retail Sale Id 2700',995.60,0.00,0.00,1.31,0.00,'2022-06-27 17:05:58','',''),(2421,'21','227','1',1,'Retail Sale Id 2701',6080.00,0.00,0.00,8.00,0.00,'2022-06-27 17:07:57','',''),(2422,'21','227','1',1,'Retail Sale Id 2702',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 17:08:44','',''),(2423,'21','227','1',1,'Retail Sale Id 2703',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 17:12:20','',''),(2424,'21','227','1',1,'Retail Sale Id 2704',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 17:13:04','',''),(2425,'21','227','1',1,'Retail Sale Id 2705',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 17:16:23','',''),(2426,'21','227','1',1,'Retail Sale Id 2706',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 17:18:16','',''),(2427,'21','227','1',1,'Retail Sale Id 2707',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 17:18:57','',''),(2428,'21','227','1',1,'Retail Sale Id 2708',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 17:20:17','',''),(2429,'21','227','1',1,'Retail Sale Id 2709',760.00,0.00,0.00,1.00,0.00,'2022-06-27 17:20:53','',''),(2430,'21','227','1',1,'Retail Sale Id 2710',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 17:21:36','',''),(2431,'21','227','1',1,'Retail Sale Id 2712',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 17:23:01','',''),(2432,'21','227','1',1,'Retail Sale Id 2713',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 17:24:33','',''),(2433,'21','227','1',1,'Retail Sale Id 2714',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 17:25:16','',''),(2434,'21','227','1',1,'Retail Sale Id 2715',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 17:25:52','',''),(2435,'21','227','1',1,'Retail Sale Id 2716',760.00,0.00,0.00,1.00,0.00,'2022-06-27 17:26:37','',''),(2436,'21','227','1',1,'Retail Sale Id 2717',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 17:31:03','',''),(2437,'21','227','1',1,'Retail Sale Id 2718',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 17:32:02','',''),(2438,'21','227','1',1,'Retail Sale Id 2719',760.00,0.00,0.00,1.00,0.00,'2022-06-27 17:32:59','',''),(2439,'21','227','1',1,'Retail Sale Id 2720',798.00,0.00,0.00,1.05,0.00,'2022-06-27 17:33:50','',''),(2440,'21','227','1',1,'Retail Sale Id 2721',950.00,0.00,0.00,1.25,0.00,'2022-06-27 17:34:42','',''),(2441,'21','227','1',1,'Retail Sale Id 2722',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 17:35:13','',''),(2442,'21','227','1',1,'Retail Sale Id 2723',5996.40,0.00,0.00,7.89,0.00,'2022-06-27 17:36:00','',''),(2443,'21','227','1',1,'Retail Sale Id 2724',3997.60,0.00,0.00,5.26,0.00,'2022-06-27 17:41:00','',''),(2444,'21','227','1',1,'Retail Sale Id 2725',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 17:42:56','',''),(2445,'21','227','1',1,'Retail Sale Id 2726',995.60,0.00,0.00,1.31,0.00,'2022-06-27 17:43:57','',''),(2446,'21','227','1',1,'Retail Sale Id 2727',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 17:45:35','',''),(2447,'21','227','1',1,'Retail Sale Id 2728',1520.00,0.00,0.00,2.00,0.00,'2022-06-27 17:48:12','',''),(2448,'21','227','1',1,'Retail Sale Id 2729',1520.00,0.00,0.00,2.00,0.00,'2022-06-27 17:49:40','',''),(2449,'21','227','1',1,'Retail Sale Id 2730',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 17:51:07','',''),(2450,'21','227','1',1,'Retail Sale Id 2731',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 17:52:42','',''),(2451,'21','227','1',1,'Retail Sale Id 2732',2196.40,0.00,0.00,2.89,0.00,'2022-06-27 17:53:26','',''),(2452,'21','227','1',1,'Retail Sale Id 2733',995.60,0.00,0.00,1.31,0.00,'2022-06-27 17:54:13','',''),(2453,'21','227','1',1,'Retail Sale Id 2734',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 17:57:55','',''),(2454,'21','227','1',1,'Retail Sale Id 2735',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 18:00:41','',''),(2455,'21','227','1',1,'Retail Sale Id 2736',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 18:02:44','',''),(2456,'21','227','1',1,'Retail Sale Id 2737',2994.40,0.00,0.00,3.94,0.00,'2022-06-27 18:05:08','',''),(2457,'21','227','1',1,'Retail Sale Id 2738',1193.20,0.00,0.00,1.57,0.00,'2022-06-27 18:06:19','',''),(2458,'21','227','1',1,'Retail Sale Id 2739',1497.20,0.00,0.00,1.97,0.00,'2022-06-27 18:07:45','',''),(2459,'21','227','1',1,'Retail Sale Id 2740',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 18:09:50','',''),(2460,'21','227','1',1,'Retail Sale Id 2741',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 18:11:13','',''),(2461,'21','227','1',1,'Retail Sale Id 2742',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 18:12:26','',''),(2462,'21','227','1',1,'Retail Sale Id 2743',19000.00,0.00,0.00,25.00,0.00,'2022-06-27 18:18:40','',''),(2463,'21','227','1',1,'Retail Sale Id 2744',3040.00,0.00,0.00,4.00,0.00,'2022-06-27 18:33:55','',''),(2464,'21','227','1',1,'Retail Sale Id 2745',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 18:34:58','',''),(2465,'21','227','1',1,'Retail Sale Id 2746',38000.00,0.00,0.00,50.00,0.00,'2022-06-27 18:38:09','',''),(2466,'21','227','1',1,'Retail Sale Id 2747',1520.00,0.00,0.00,2.00,0.00,'2022-06-27 18:38:50','',''),(2467,'21','227','1',1,'Retail Sale Id 2748',7995.20,0.00,0.00,10.52,0.00,'2022-06-27 18:39:53','',''),(2468,'21','227','1',1,'Retail Sale Id 2749',4560.00,0.00,0.00,6.00,0.00,'2022-06-28 09:14:12','',''),(2469,'21','227','1',1,'Retail Sale Id 2751',2994.40,0.00,0.00,3.94,0.00,'2022-06-28 09:15:26','',''),(2470,'21','227','1',1,'Retail Sale Id 2752',1520.00,0.00,0.00,2.00,0.00,'2022-06-28 09:16:29','',''),(2471,'21','227','1',1,'Retail Sale Id 2753',7600.00,0.00,0.00,10.00,0.00,'2022-06-28 09:17:59','',''),(2472,'21','227','1',1,'Retail Sale Id 2754',4993.20,0.00,0.00,6.57,0.00,'2022-06-28 09:18:36','',''),(2473,'21','227','1',1,'Retail Sale Id 2755',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 09:19:22','',''),(2474,'21','227','1',1,'Retail Sale Id 2755',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 09:19:22','',''),(2475,'21','227','1',1,'Retail Sale Id 2756',494.00,0.00,0.00,0.65,0.00,'2022-06-28 09:20:25','',''),(2476,'21','227','1',1,'Retail Sale Id 2756',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 09:20:25','',''),(2477,'21','227','1',1,'Retail Sale Id 2756',2994.40,0.00,0.00,3.94,0.00,'2022-06-28 09:20:25','',''),(2478,'21','227','1',1,'Retail Sale Id 2757',995.60,0.00,0.00,1.31,0.00,'2022-06-28 09:21:15','',''),(2479,'21','227','1',1,'Retail Sale Id 2757',995.60,0.00,0.00,1.31,0.00,'2022-06-28 09:21:15','',''),(2480,'21','227','1',1,'Retail Sale Id 2758',2280.00,0.00,0.00,3.00,0.00,'2022-06-28 09:21:42','',''),(2481,'21','227','1',1,'Retail Sale Id 2759',760.00,0.00,0.00,1.00,0.00,'2022-06-28 09:25:45','',''),(2482,'21','227','1',1,'Retail Sale Id 2760',1299.60,0.00,0.00,1.71,0.00,'2022-06-28 09:31:45','',''),(2483,'21','227','1',1,'Retail Sale Id 2761',1497.20,0.00,0.00,1.97,0.00,'2022-06-28 09:41:49','',''),(2484,'21','227','1',1,'Retail Sale Id 2761',6999.60,0.00,0.00,9.21,0.00,'2022-06-28 09:41:49','',''),(2485,'21','227','1',1,'Retail Sale Id 2762',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 09:44:09','',''),(2486,'21','227','1',1,'Retail Sale Id 2763',4560.00,0.00,0.00,6.00,0.00,'2022-06-28 09:47:29','',''),(2487,'21','227','1',1,'Retail Sale Id 2764',2280.00,0.00,0.00,3.00,0.00,'2022-06-28 10:14:01','',''),(2488,'21','227','1',1,'Retail Sale Id 2765',995.60,0.00,0.00,1.31,0.00,'2022-06-28 10:15:24','',''),(2489,'21','227','1',1,'Retail Sale Id 2766',1520.00,0.00,0.00,2.00,0.00,'2022-06-28 10:30:52','',''),(2490,'21','227','1',1,'Retail Sale Id 2767',494.00,0.00,0.00,0.65,0.00,'2022-06-28 10:31:42','',''),(2491,'21','227','1',1,'Retail Sale Id 2768',4993.20,0.00,0.00,6.57,0.00,'2022-06-28 10:39:35','',''),(2492,'21','227','1',1,'Retail Sale Id 2769',3040.00,0.00,0.00,4.00,0.00,'2022-06-28 10:40:26','',''),(2493,'21','227','1',1,'Retail Sale Id 2770',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 10:47:05','',''),(2494,'21','227','1',1,'Retail Sale Id 2771',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 10:51:00','',''),(2495,'21','227','1',1,'Retail Sale Id 2772',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 12:01:01','',''),(2496,'21','227','1',1,'Retail Sale Id 2773',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 12:02:15','',''),(2497,'21','227','1',1,'Retail Sale Id 2774',7600.00,0.00,0.00,10.00,0.00,'2022-06-28 12:02:56','',''),(2498,'21','227','1',1,'Retail Sale Id 2775',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 12:23:32','',''),(2499,'21','227','1',1,'Retail Sale Id 2776',7600.00,0.00,0.00,10.00,0.00,'2022-06-28 12:26:15','',''),(2500,'21','227','1',1,'Retail Sale Id 2777',1497.20,0.00,0.00,1.97,0.00,'2022-06-28 13:29:37','',''),(2501,'21','227','1',1,'Retail Sale Id 2778',4993.20,0.00,0.00,6.57,0.00,'2022-06-28 13:30:29','',''),(2502,'21','227','1',1,'Retail Sale Id 2779',4560.00,0.00,0.00,6.00,0.00,'2022-06-28 13:36:04','',''),(2503,'21','227','1',1,'Retail Sale Id 2780',2280.00,0.00,0.00,3.00,0.00,'2022-06-28 14:55:35','',''),(2504,'21','227','1',1,'Retail Sale Id 2781',995.60,0.00,0.00,1.31,0.00,'2022-06-28 15:16:36','',''),(2505,'21','227','1',1,'Retail Sale Id 2782',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 15:22:15','',''),(2506,'21','227','1',1,'Retail Sale Id 2783',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 15:30:03','',''),(2507,'21','227','1',1,'Retail Sale Id 2784',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 15:38:17','',''),(2508,'21','227','1',1,'Retail Sale Id 2785',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 15:38:56','',''),(2509,'21','227','1',1,'Retail Sale Id 2790',8496.80,0.00,0.00,11.18,0.00,'2022-06-28 16:24:49','',''),(2510,'21','227','1',1,'Retail Sale Id 2791',4560.00,0.00,0.00,6.00,0.00,'2022-06-28 16:25:49','',''),(2511,'21','227','1',1,'Retail Sale Id 2792',1497.20,0.00,0.00,1.97,0.00,'2022-06-28 16:26:28','',''),(2512,'21','227','1',1,'Retail Sale Id 2793',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 16:32:26','',''),(2513,'21','227','1',1,'Retail Sale Id 2794',3496.00,0.00,0.00,4.60,0.00,'2022-06-28 16:33:20','',''),(2514,'21','227','1',1,'Retail Sale Id 2795',798.00,0.00,0.00,1.05,0.00,'2022-06-28 16:35:07','',''),(2515,'21','227','1',1,'Retail Sale Id 2796',995.60,0.00,0.00,1.31,0.00,'2022-06-28 16:38:17','',''),(2516,'21','227','1',1,'Retail Sale Id 2796',1497.20,0.00,0.00,1.97,0.00,'2022-06-28 16:38:17','',''),(2517,'21','227','1',1,'Retail Sale Id 2798',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 16:41:24','',''),(2518,'21','227','1',1,'Retail Sale Id 2799',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 16:42:08','',''),(2519,'21','227','1',1,'Retail Sale Id 2801',7995.20,0.00,0.00,10.52,0.00,'2022-06-28 16:43:58','',''),(2520,'21','227','1',1,'Retail Sale Id 2802',4560.00,0.00,0.00,6.00,0.00,'2022-06-28 16:44:44','',''),(2521,'21','227','1',1,'Retail Sale Id 2803',995.60,0.00,0.00,1.31,0.00,'2022-06-28 16:47:06','',''),(2522,'21','227','1',1,'Retail Sale Id 2804',995.60,0.00,0.00,1.31,0.00,'2022-06-28 16:48:41','',''),(2523,'21','227','1',1,'Retail Sale Id 2805',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 16:50:42','',''),(2524,'21','227','1',1,'Retail Sale Id 2806',3997.60,0.00,0.00,5.26,0.00,'2022-06-28 16:52:35','',''),(2525,'21','227','1',1,'Retail Sale Id 2807',494.00,0.00,0.00,0.65,0.00,'2022-06-28 16:56:18','',''),(2526,'21','227','1',1,'Retail Sale Id 2808',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 17:00:47','',''),(2527,'21','227','1',1,'Retail Sale Id 2809',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 17:01:38','',''),(2528,'21','227','1',1,'Retail Sale Id 2810',995.60,0.00,0.00,1.31,0.00,'2022-06-28 17:14:24','',''),(2529,'21','227','1',1,'Retail Sale Id 2811',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 17:17:31','',''),(2530,'21','227','1',1,'Retail Sale Id 2813',1497.20,0.00,0.00,1.97,0.00,'2022-06-28 17:18:20','',''),(2531,'21','227','1',1,'Retail Sale Id 2814',4993.20,0.00,0.00,6.57,0.00,'2022-06-28 17:19:31','',''),(2532,'21','227','1',1,'Retail Sale Id 2815',699.20,0.00,0.00,0.92,0.00,'2022-06-28 17:20:18','',''),(2533,'21','227','1',1,'Retail Sale Id 2816',4506.80,0.00,0.00,5.93,0.00,'2022-06-28 17:23:14','',''),(2534,'21','227','1',1,'Retail Sale Id 2817',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 17:30:42','',''),(2535,'21','227','1',1,'Retail Sale Id 2818',3496.00,0.00,0.00,4.60,0.00,'2022-06-28 17:33:20','',''),(2536,'21','227','1',1,'Retail Sale Id 2819',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 17:34:42','',''),(2537,'21','227','1',1,'Retail Sale Id 2820',1520.00,0.00,0.00,2.00,0.00,'2022-06-28 17:36:49','',''),(2538,'21','227','1',1,'Retail Sale Id 2821',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 17:37:24','',''),(2539,'21','227','1',1,'Retail Sale Id 2822',2280.00,0.00,0.00,3.00,0.00,'2022-06-28 17:38:08','',''),(2540,'21','227','1',1,'Retail Sale Id 2823',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 17:38:50','',''),(2541,'21','227','1',1,'Retail Sale Id 2824',1793.60,0.00,0.00,2.36,0.00,'2022-06-28 17:49:25','',''),(2542,'21','227','1',1,'Retail Sale Id 2825',4195.20,0.00,0.00,5.52,0.00,'2022-06-28 17:50:29','',''),(2543,'21','227','1',1,'Retail Sale Id 2826',3693.60,0.00,0.00,4.86,0.00,'2022-06-28 17:55:14','',''),(2544,'21','227','1',1,'Retail Sale Id 2827',494.00,0.00,0.00,0.65,0.00,'2022-06-28 17:57:20','',''),(2545,'21','227','1',1,'Retail Sale Id 2828',896.80,0.00,0.00,1.18,0.00,'2022-06-28 17:58:32','',''),(2546,'21','227','1',1,'Retail Sale Id 2829',995.60,0.00,0.00,1.31,0.00,'2022-06-28 18:01:32','',''),(2547,'21','227','1',1,'Retail Sale Id 2830',995.60,0.00,0.00,1.31,0.00,'2022-06-28 18:02:15','',''),(2548,'21','227','1',1,'Retail Sale Id 2831',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 18:04:49','',''),(2549,'21','227','1',1,'Retail Sale Id 2832',3496.00,0.00,0.00,4.60,0.00,'2022-06-28 18:06:47','',''),(2550,'21','227','1',1,'Retail Sale Id 2833',2280.00,0.00,0.00,3.00,0.00,'2022-06-28 18:10:13','',''),(2551,'21','227','1',1,'Retail Sale Id 2834',995.60,0.00,0.00,1.31,0.00,'2022-06-28 18:12:20','',''),(2552,'21','227','1',1,'Retail Sale Id 2835',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 18:15:46','',''),(2553,'21','227','1',1,'Retail Sale Id 2836',2994.40,0.00,0.00,3.94,0.00,'2022-06-28 18:16:29','',''),(2554,'21','227','1',1,'Retail Sale Id 2837',4560.00,0.00,0.00,6.00,0.00,'2022-06-28 18:22:32','',''),(2555,'21','227','1',1,'Retail Sale Id 2838',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 18:33:28','',''),(2556,'21','227','1',1,'Retail Sale Id 2839',2994.40,0.00,0.00,3.94,0.00,'2022-06-28 18:34:46','',''),(2557,'21','227','1',1,'Retail Sale Id 2840',995.60,0.00,0.00,1.31,0.00,'2022-06-28 18:36:32','',''),(2558,'21','227','1',1,'Retail Sale Id 2841',2280.00,0.00,0.00,3.00,0.00,'2022-06-28 18:37:22','',''),(2559,'21','227','1',1,'Retail Sale Id 2842',995.60,0.00,0.00,1.31,0.00,'2022-06-28 18:38:05','',''),(2560,'21','227','1',1,'Retail Sale Id 2843',1998.80,0.00,0.00,2.63,0.00,'2022-06-28 18:38:39','',''),(2561,'21','227','1',1,'Retail Sale Id 2844',2492.80,0.00,0.00,3.28,0.00,'2022-06-28 18:39:19','',''),(2562,'21','227','1',1,'Retail Sale Id 2845',1497.20,0.00,0.00,1.97,0.00,'2022-06-28 18:39:58','',''),(2563,'21','227','1',1,'Retail Sale Id 2846',798.00,0.00,0.00,1.05,0.00,'2022-06-28 18:43:25','',''),(2564,'21','227','1',1,'Retail Sale Id 2847',2280.00,0.00,0.00,3.00,0.00,'2022-06-28 18:44:03','',''),(2565,'21','227','1',1,'Retail Sale Id 2848',1497.20,0.00,0.00,1.97,0.00,'2022-06-28 18:44:42','',''),(2566,'21','227','1',1,'Retail Sale Id 2849',995.60,0.00,0.00,1.31,0.00,'2022-06-28 18:47:05','',''),(2567,'21','227','1',1,'Retail Sale Id 2850',760.00,0.00,0.00,1.00,0.00,'2022-06-28 18:49:40','',''),(2568,'21','227','1',1,'Retail Sale Id 2851',3800.00,0.00,0.00,5.00,0.00,'2022-06-28 18:50:50','',''),(2569,'21','227','1',1,'Retail Sale Id 2797',995.60,0.00,0.00,1.31,0.00,'2022-06-28 19:38:16','',''),(2570,'21','227','1',1,'Retail Sale Id 2797',1497.20,0.00,0.00,1.97,0.00,'2022-06-28 19:38:16','',''),(2571,'21','227','1',1,'Retail Sale Id 2852',24548.00,0.00,0.00,32.30,0.00,'2022-06-28 19:39:58','',''),(2572,'21','227','1',1,'Retail Sale Id 2853',2994.40,0.00,0.00,3.94,0.00,'2022-06-29 10:37:14','',''),(2573,'21','227','1',1,'Retail Sale Id 2854',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 10:37:40','',''),(2574,'21','227','1',1,'Retail Sale Id 2855',1520.00,0.00,0.00,2.00,0.00,'2022-06-29 10:38:05','',''),(2575,'21','227','1',1,'Retail Sale Id 2856',3040.00,0.00,0.00,4.00,0.00,'2022-06-29 10:38:28','',''),(2576,'21','227','1',1,'Retail Sale Id 2857',2492.80,0.00,0.00,3.28,0.00,'2022-06-29 10:38:51','',''),(2577,'21','227','1',1,'Retail Sale Id 2858',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 10:39:16','',''),(2578,'21','227','1',1,'Retail Sale Id 2859',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 10:39:45','',''),(2579,'21','227','1',1,'Retail Sale Id 2860',8496.80,0.00,0.00,11.18,0.00,'2022-06-29 10:40:16','',''),(2580,'21','227','1',1,'Retail Sale Id 2861',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 10:40:42','',''),(2581,'21','227','1',1,'Retail Sale Id 2862',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 10:46:19','',''),(2582,'21','227','1',1,'Retail Sale Id 2863',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 10:51:50','',''),(2583,'21','227','1',1,'Retail Sale Id 2864',2196.40,0.00,0.00,2.89,0.00,'2022-06-29 10:55:33','',''),(2584,'21','227','1',1,'Retail Sale Id 2865',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 10:57:23','',''),(2585,'21','227','1',1,'Retail Sale Id 2866',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 10:59:41','',''),(2586,'21','227','1',1,'Retail Sale Id 2867',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 11:01:35','',''),(2587,'21','227','1',1,'Retail Sale Id 2868',995.60,0.00,0.00,1.31,0.00,'2022-06-29 11:02:21','',''),(2588,'21','227','1',1,'Retail Sale Id 2869',1793.60,0.00,0.00,2.36,0.00,'2022-06-29 11:04:28','',''),(2589,'21','227','1',1,'Retail Sale Id 2870',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 11:05:02','',''),(2590,'21','227','1',1,'Retail Sale Id 2871',995.60,0.00,0.00,1.31,0.00,'2022-06-29 11:06:34','',''),(2591,'21','227','1',1,'Retail Sale Id 2872',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 11:07:51','',''),(2592,'21','227','1',1,'Retail Sale Id 2873',7600.00,0.00,0.00,10.00,0.00,'2022-06-29 11:08:42','',''),(2593,'21','227','1',1,'Retail Sale Id 2874',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 11:09:20','',''),(2594,'21','227','1',1,'Retail Sale Id 2875',995.60,0.00,0.00,1.31,0.00,'2022-06-29 11:13:42','',''),(2595,'21','227','1',1,'Retail Sale Id 2876',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 11:20:08','',''),(2596,'21','227','1',1,'Retail Sale Id 2877',896.80,0.00,0.00,1.18,0.00,'2022-06-29 11:45:52','',''),(2597,'21','227','1',1,'Retail Sale Id 2878',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 11:55:32','',''),(2598,'21','227','1',1,'Retail Sale Id 2879',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 12:02:58','',''),(2599,'21','227','1',1,'Retail Sale Id 2880',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 12:08:54','',''),(2600,'21','227','1',1,'Retail Sale Id 2881',7600.00,0.00,0.00,10.00,0.00,'2022-06-29 12:24:07','',''),(2601,'21','227','1',1,'Retail Sale Id 2882',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 12:24:52','',''),(2602,'21','227','1',1,'Retail Sale Id 2883',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 12:28:31','',''),(2603,'21','227','1',1,'Retail Sale Id 2884',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 12:42:34','',''),(2604,'21','227','1',1,'Retail Sale Id 2885',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 13:01:27','',''),(2605,'21','227','1',1,'Retail Sale Id 2886',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 13:26:17','',''),(2606,'21','227','1',1,'Retail Sale Id 2887',3997.60,0.00,0.00,5.26,0.00,'2022-06-29 13:30:20','',''),(2607,'21','227','1',1,'Retail Sale Id 2888',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 13:43:59','',''),(2608,'21','227','1',1,'Retail Sale Id 2889',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 13:51:30','',''),(2609,'21','227','1',1,'Retail Sale Id 2890',798.00,0.00,0.00,1.05,0.00,'2022-06-29 13:53:45','',''),(2610,'21','227','1',1,'Retail Sale Id 2891',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 13:54:58','',''),(2611,'21','227','1',1,'Retail Sale Id 2892',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 13:56:50','',''),(2612,'21','227','1',1,'Retail Sale Id 2893',995.60,0.00,0.00,1.31,0.00,'2022-06-29 13:59:21','',''),(2613,'21','227','1',1,'Retail Sale Id 2894',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 14:01:04','',''),(2614,'21','227','1',1,'Retail Sale Id 2895',2492.80,0.00,0.00,3.28,0.00,'2022-06-29 14:01:51','',''),(2615,'21','227','1',1,'Retail Sale Id 2896',11400.00,0.00,0.00,15.00,0.00,'2022-06-29 14:04:41','',''),(2616,'21','227','1',1,'Retail Sale Id 2897',7600.00,0.00,0.00,10.00,0.00,'2022-06-29 14:39:38','',''),(2617,'21','227','1',1,'Retail Sale Id 2898',5996.40,0.00,0.00,7.89,0.00,'2022-06-29 14:50:08','',''),(2618,'21','227','1',1,'Retail Sale Id 2899',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 14:52:09','',''),(2619,'21','227','1',1,'Retail Sale Id 2900',3496.00,0.00,0.00,4.60,0.00,'2022-06-29 14:55:22','',''),(2620,'21','227','1',1,'Retail Sale Id 2901',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 14:57:25','',''),(2621,'21','227','1',1,'Retail Sale Id 2902',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 14:58:37','',''),(2622,'21','227','1',1,'Retail Sale Id 2903',995.60,0.00,0.00,1.31,0.00,'2022-06-29 15:00:51','',''),(2623,'21','227','1',1,'Retail Sale Id 2904',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 15:05:08','',''),(2624,'21','227','1',1,'Retail Sale Id 2905',1793.60,0.00,0.00,2.36,0.00,'2022-06-29 15:06:52','',''),(2625,'21','227','1',1,'Retail Sale Id 2906',1094.40,0.00,0.00,1.44,0.00,'2022-06-29 15:14:13','',''),(2626,'21','227','1',1,'Retail Sale Id 2907',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 16:07:49','',''),(2627,'21','227','1',1,'Retail Sale Id 2908',19000.00,0.00,0.00,25.00,0.00,'2022-06-29 16:08:38','',''),(2628,'21','227','1',1,'Retail Sale Id 2909',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 16:13:16','',''),(2629,'21','227','1',1,'Retail Sale Id 2910',1793.60,0.00,0.00,2.36,0.00,'2022-06-29 16:16:55','',''),(2630,'21','227','1',1,'Retail Sale Id 2911',798.00,0.00,0.00,1.05,0.00,'2022-06-29 16:20:54','',''),(2631,'21','227','1',1,'Retail Sale Id 2912',995.60,0.00,0.00,1.31,0.00,'2022-06-29 16:27:33','',''),(2632,'21','227','1',1,'Retail Sale Id 2913',2994.40,0.00,0.00,3.94,0.00,'2022-06-29 16:29:17','',''),(2633,'21','227','1',1,'Retail Sale Id 2914',3997.60,0.00,0.00,5.26,0.00,'2022-06-29 16:30:45','',''),(2634,'21','227','1',1,'Retail Sale Id 2915',1193.20,0.00,0.00,1.57,0.00,'2022-06-29 16:32:29','',''),(2635,'21','227','1',1,'Retail Sale Id 2916',4993.20,0.00,0.00,6.57,0.00,'2022-06-29 16:34:07','',''),(2636,'21','227','1',1,'Retail Sale Id 2917',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 16:36:49','',''),(2637,'21','227','1',1,'Retail Sale Id 2918',3997.60,0.00,0.00,5.26,0.00,'2022-06-29 16:39:47','',''),(2638,'21','227','1',1,'Retail Sale Id 2919',3997.60,0.00,0.00,5.26,0.00,'2022-06-29 16:55:27','',''),(2639,'21','227','1',1,'Retail Sale Id 2920',995.60,0.00,0.00,1.31,0.00,'2022-06-29 16:56:04','',''),(2640,'21','227','1',1,'Retail Sale Id 2921',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 16:59:20','',''),(2641,'21','227','1',1,'Retail Sale Id 2922',798.00,0.00,0.00,1.05,0.00,'2022-06-29 17:07:04','',''),(2642,'21','227','1',1,'Retail Sale Id 2924',995.60,0.00,0.00,1.31,0.00,'2022-06-29 17:10:06','',''),(2643,'21','227','1',1,'Retail Sale Id 2926',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 17:10:46','',''),(2644,'21','227','1',1,'Retail Sale Id 2927',798.00,0.00,0.00,1.05,0.00,'2022-06-29 17:15:50','',''),(2645,'21','227','1',1,'Retail Sale Id 2928',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 17:22:54','',''),(2646,'21','227','1',1,'Retail Sale Id 2929',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 17:24:55','',''),(2647,'21','227','1',1,'Retail Sale Id 2930',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 17:33:48','',''),(2648,'21','227','1',1,'Retail Sale Id 2931',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 17:34:36','',''),(2649,'21','227','1',1,'Retail Sale Id 2932',798.00,0.00,0.00,1.05,0.00,'2022-06-29 17:36:04','',''),(2650,'21','227','1',1,'Retail Sale Id 2933',2492.80,0.00,0.00,3.28,0.00,'2022-06-29 17:41:07','',''),(2651,'21','227','1',1,'Retail Sale Id 2934',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 17:44:35','',''),(2652,'21','227','1',1,'Retail Sale Id 2935',995.60,0.00,0.00,1.31,0.00,'2022-06-29 17:47:00','',''),(2653,'21','227','1',1,'Retail Sale Id 2936',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 17:48:14','',''),(2654,'21','227','1',1,'Retail Sale Id 2937',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 17:49:50','',''),(2655,'21','227','1',1,'Retail Sale Id 2938',3040.00,0.00,0.00,4.00,0.00,'2022-06-29 17:51:30','',''),(2656,'21','227','1',1,'Retail Sale Id 2939',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 17:52:27','',''),(2657,'21','227','1',1,'Retail Sale Id 2940',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 17:54:44','',''),(2658,'21','227','1',1,'Retail Sale Id 2941',995.60,0.00,0.00,1.31,0.00,'2022-06-29 17:56:00','',''),(2659,'21','227','1',1,'Retail Sale Id 2942',1520.00,0.00,0.00,2.00,0.00,'2022-06-29 18:00:11','',''),(2660,'21','227','1',1,'Retail Sale Id 2943',7600.00,0.00,0.00,10.00,0.00,'2022-06-29 18:01:39','',''),(2661,'21','227','1',1,'Retail Sale Id 2944',2994.40,0.00,0.00,3.94,0.00,'2022-06-29 18:02:28','',''),(2662,'21','227','1',1,'Retail Sale Id 2945',2994.40,0.00,0.00,3.94,0.00,'2022-06-29 18:05:22','',''),(2663,'21','227','1',1,'Retail Sale Id 2946',2994.40,0.00,0.00,3.94,0.00,'2022-06-29 18:07:04','',''),(2664,'21','227','1',1,'Retail Sale Id 2947',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 18:08:22','',''),(2665,'21','227','1',1,'Retail Sale Id 2948',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 18:11:34','',''),(2666,'21','227','1',1,'Retail Sale Id 2949',10640.00,0.00,0.00,14.00,0.00,'2022-06-29 18:17:39','',''),(2667,'21','227','1',1,'Retail Sale Id 2950',896.80,0.00,0.00,1.18,0.00,'2022-06-29 18:25:15','',''),(2668,'21','227','1',1,'Retail Sale Id 2951',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 18:27:04','',''),(2669,'21','227','1',1,'Retail Sale Id 2952',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 18:31:07','',''),(2670,'21','227','1',1,'Retail Sale Id 2953',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 18:31:54','',''),(2671,'21','227','1',1,'Retail Sale Id 2954',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 18:34:24','',''),(2672,'21','227','1',1,'Retail Sale Id 2955',1140.00,0.00,0.00,1.50,0.00,'2022-06-29 18:47:44','',''),(2673,'21','227','1',1,'Retail Sale Id 2956',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 14:48:34','',''),(2674,'21','227','1',1,'Retail Sale Id 2957',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 14:51:46','',''),(2675,'21','227','1',1,'Retail Sale Id 2958',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 14:53:12','',''),(2676,'21','227','1',1,'Retail Sale Id 2959',798.00,0.00,0.00,1.05,0.00,'2022-06-30 14:54:50','',''),(2677,'21','227','1',1,'Retail Sale Id 2959',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 14:54:50','',''),(2678,'21','227','1',1,'Retail Sale Id 2959',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 14:54:50','',''),(2679,'21','227','1',1,'Retail Sale Id 2959',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 14:54:50','',''),(2680,'21','227','1',1,'Retail Sale Id 2960',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 14:56:23','',''),(2681,'21','227','1',1,'Retail Sale Id 2960',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 14:56:23','',''),(2682,'21','227','1',1,'Retail Sale Id 2960',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 14:56:23','',''),(2683,'21','227','1',1,'Retail Sale Id 2961',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 14:57:41','',''),(2684,'21','227','1',1,'Retail Sale Id 2961',3496.00,0.00,0.00,4.60,0.00,'2022-06-30 14:57:41','',''),(2685,'21','227','1',1,'Retail Sale Id 2961',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 14:57:41','',''),(2686,'21','227','1',1,'Retail Sale Id 2961',4993.20,0.00,0.00,6.57,0.00,'2022-06-30 14:57:41','',''),(2687,'21','227','1',1,'Retail Sale Id 2962',798.00,0.00,0.00,1.05,0.00,'2022-06-30 14:58:14','',''),(2688,'21','227','1',1,'Retail Sale Id 2963',494.00,0.00,0.00,0.65,0.00,'2022-06-30 14:59:16','',''),(2689,'21','227','1',1,'Retail Sale Id 2964',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 15:00:32','',''),(2690,'21','227','1',1,'Retail Sale Id 2964',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 15:00:32','',''),(2691,'21','227','1',1,'Retail Sale Id 2964',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 15:00:32','',''),(2692,'21','227','1',1,'Retail Sale Id 2966',2994.40,0.00,0.00,3.94,0.00,'2022-06-30 15:01:29','',''),(2693,'21','227','1',1,'Retail Sale Id 2968',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 15:02:44','',''),(2694,'21','227','1',1,'Retail Sale Id 2969',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 15:04:08','',''),(2695,'21','227','1',1,'Retail Sale Id 2969',2698.00,0.00,0.00,3.55,0.00,'2022-06-30 15:04:08','',''),(2696,'21','227','1',1,'Retail Sale Id 2969',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 15:04:08','',''),(2697,'21','227','1',1,'Retail Sale Id 2969',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 15:04:08','',''),(2698,'21','227','1',1,'Retail Sale Id 2970',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 15:06:27','',''),(2699,'21','227','1',1,'Retail Sale Id 2970',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 15:06:27','',''),(2700,'21','227','1',1,'Retail Sale Id 2970',2599.20,0.00,0.00,3.42,0.00,'2022-06-30 15:06:27','',''),(2701,'21','227','1',1,'Retail Sale Id 2970',2994.40,0.00,0.00,3.94,0.00,'2022-06-30 15:06:27','',''),(2702,'21','227','1',1,'Retail Sale Id 2970',5320.00,0.00,0.00,7.00,0.00,'2022-06-30 15:06:27','',''),(2703,'21','227','1',1,'Retail Sale Id 2971',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 15:07:37','',''),(2704,'21','227','1',1,'Retail Sale Id 2972',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 15:09:19','',''),(2705,'21','227','1',1,'Retail Sale Id 2973',995.60,0.00,0.00,1.31,0.00,'2022-06-30 15:10:07','',''),(2706,'21','227','1',1,'Retail Sale Id 2974',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 15:13:09','',''),(2707,'21','227','1',1,'Retail Sale Id 2975',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 15:15:29','',''),(2708,'21','227','1',1,'Retail Sale Id 2976',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 15:16:34','',''),(2709,'21','227','1',1,'Retail Sale Id 2977',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 15:22:49','',''),(2710,'21','227','1',1,'Retail Sale Id 2978',760.00,0.00,0.00,1.00,0.00,'2022-06-30 15:24:41','',''),(2711,'21','227','1',1,'Retail Sale Id 2978',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 15:24:41','',''),(2712,'21','227','1',1,'Retail Sale Id 2978',4993.20,0.00,0.00,6.57,0.00,'2022-06-30 15:24:41','',''),(2713,'21','227','1',1,'Retail Sale Id 2979',995.60,0.00,0.00,1.31,0.00,'2022-06-30 15:25:26','',''),(2714,'21','227','1',1,'Retail Sale Id 2980',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 15:27:56','',''),(2715,'21','227','1',1,'Retail Sale Id 2981',995.60,0.00,0.00,1.31,0.00,'2022-06-30 15:34:39','',''),(2716,'21','227','1',1,'Retail Sale Id 2981',995.60,0.00,0.00,1.31,0.00,'2022-06-30 15:34:39','',''),(2717,'21','227','1',1,'Retail Sale Id 2981',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 15:34:39','',''),(2718,'21','227','1',1,'Retail Sale Id 2981',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 15:34:39','',''),(2719,'21','227','1',1,'Retail Sale Id 2981',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 15:34:39','',''),(2720,'21','227','1',1,'Retail Sale Id 2981',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 15:34:39','',''),(2721,'21','227','1',1,'Retail Sale Id 2981',11780.00,0.00,0.00,15.50,0.00,'2022-06-30 15:34:39','',''),(2722,'21','227','1',1,'Retail Sale Id 2982',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 15:35:21','',''),(2723,'21','227','1',1,'Retail Sale Id 2983',896.80,0.00,0.00,1.18,0.00,'2022-06-30 15:36:02','',''),(2724,'21','227','1',1,'Retail Sale Id 2984',995.60,0.00,0.00,1.31,0.00,'2022-06-30 15:36:43','',''),(2725,'21','227','1',1,'Retail Sale Id 2985',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 15:38:29','',''),(2726,'21','227','1',1,'Retail Sale Id 2985',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 15:38:29','',''),(2727,'21','227','1',1,'Retail Sale Id 2986',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 15:52:40','',''),(2728,'21','227','1',1,'Retail Sale Id 2987',8998.40,0.00,0.00,11.84,0.00,'2022-06-30 15:53:30','',''),(2729,'21','227','1',1,'Retail Sale Id 2988',760.00,0.00,0.00,1.00,0.00,'2022-06-30 16:03:00','',''),(2730,'21','227','1',1,'Retail Sale Id 2989',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 16:03:51','',''),(2731,'21','227','1',1,'Retail Sale Id 2990',494.00,0.00,0.00,0.65,0.00,'2022-06-30 16:05:07','',''),(2732,'21','227','1',1,'Retail Sale Id 2990',699.20,0.00,0.00,0.92,0.00,'2022-06-30 16:05:07','',''),(2733,'21','227','1',1,'Retail Sale Id 2990',699.20,0.00,0.00,0.92,0.00,'2022-06-30 16:05:07','',''),(2734,'21','227','1',1,'Retail Sale Id 2990',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:05:07','',''),(2735,'21','227','1',1,'Retail Sale Id 2991',4993.20,0.00,0.00,6.57,0.00,'2022-06-30 16:06:25','',''),(2736,'21','227','1',1,'Retail Sale Id 2991',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 16:06:25','',''),(2737,'21','227','1',1,'Retail Sale Id 2991',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:06:25','',''),(2738,'21','227','1',1,'Retail Sale Id 2991',19000.00,0.00,0.00,25.00,0.00,'2022-06-30 16:06:25','',''),(2739,'21','227','1',1,'Retail Sale Id 2992',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:07:50','',''),(2740,'21','227','1',1,'Retail Sale Id 2992',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:07:50','',''),(2741,'21','227','1',1,'Retail Sale Id 2992',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:07:50','',''),(2742,'21','227','1',1,'Retail Sale Id 2992',11400.00,0.00,0.00,15.00,0.00,'2022-06-30 16:07:50','',''),(2743,'21','227','1',1,'Retail Sale Id 2993',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 16:08:53','',''),(2744,'21','227','1',1,'Retail Sale Id 2993',4993.20,0.00,0.00,6.57,0.00,'2022-06-30 16:08:53','',''),(2745,'21','227','1',1,'Retail Sale Id 2993',7995.20,0.00,0.00,10.52,0.00,'2022-06-30 16:08:53','',''),(2746,'21','227','1',1,'Retail Sale Id 2994',7995.20,0.00,0.00,10.52,0.00,'2022-06-30 16:10:49','',''),(2747,'21','227','1',1,'Retail Sale Id 2994',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:10:49','',''),(2748,'21','227','1',1,'Retail Sale Id 2994',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:10:49','',''),(2749,'21','227','1',1,'Retail Sale Id 2994',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:10:49','',''),(2750,'21','227','1',1,'Retail Sale Id 2995',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 16:11:27','',''),(2751,'21','227','1',1,'Retail Sale Id 2995',11400.00,0.00,0.00,15.00,0.00,'2022-06-30 16:11:27','',''),(2752,'21','227','1',1,'Retail Sale Id 2996',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 16:14:58','',''),(2753,'21','227','1',1,'Retail Sale Id 2997',2143.20,0.00,0.00,2.82,0.00,'2022-06-30 16:16:31','',''),(2754,'21','227','1',1,'Retail Sale Id 2998',995.60,0.00,0.00,1.31,0.00,'2022-06-30 16:17:27','',''),(2755,'21','227','1',1,'Retail Sale Id 2998',995.60,0.00,0.00,1.31,0.00,'2022-06-30 16:17:27','',''),(2756,'21','227','1',1,'Retail Sale Id 2999',494.00,0.00,0.00,0.65,0.00,'2022-06-30 16:20:48','',''),(2757,'21','227','1',1,'Retail Sale Id 3000',2994.40,0.00,0.00,3.94,0.00,'2022-06-30 16:25:13','',''),(2758,'21','227','1',1,'Retail Sale Id 3001',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 16:27:42','',''),(2759,'21','227','1',1,'Retail Sale Id 3002',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 16:29:42','',''),(2760,'21','227','1',1,'Retail Sale Id 3003',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 16:31:40','',''),(2761,'21','227','1',1,'Retail Sale Id 3004',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:32:57','',''),(2762,'21','227','1',1,'Retail Sale Id 3005',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 16:34:30','',''),(2763,'21','227','1',1,'Retail Sale Id 3006',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 16:35:14','',''),(2764,'21','227','1',1,'Retail Sale Id 3007',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 16:37:46','',''),(2765,'21','227','1',1,'Retail Sale Id 3008',995.60,0.00,0.00,1.31,0.00,'2022-06-30 16:38:41','',''),(2766,'21','227','1',1,'Retail Sale Id 3008',995.60,0.00,0.00,1.31,0.00,'2022-06-30 16:38:41','',''),(2767,'21','227','1',1,'Retail Sale Id 3009',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 16:39:27','',''),(2768,'21','227','1',1,'Retail Sale Id 3010',2492.80,0.00,0.00,3.28,0.00,'2022-06-30 16:45:48','',''),(2769,'21','227','1',1,'Retail Sale Id 3011',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 16:48:24','',''),(2770,'21','227','1',1,'Retail Sale Id 3012',995.60,0.00,0.00,1.31,0.00,'2022-06-30 16:49:30','',''),(2771,'21','227','1',1,'Retail Sale Id 3013',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 16:54:31','',''),(2772,'21','227','1',1,'Retail Sale Id 3014',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:58:37','',''),(2773,'21','227','1',1,'Retail Sale Id 3015',798.00,0.00,0.00,1.05,0.00,'2022-06-30 17:02:20','',''),(2774,'21','227','1',1,'Retail Sale Id 3016',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 17:03:50','',''),(2775,'21','227','1',1,'Retail Sale Id 3017',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:04:48','',''),(2776,'21','227','1',1,'Retail Sale Id 3018',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:05:55','',''),(2777,'21','227','1',1,'Retail Sale Id 3019',995.60,0.00,0.00,1.31,0.00,'2022-06-30 17:07:06','',''),(2778,'21','227','1',1,'Retail Sale Id 3020',995.60,0.00,0.00,1.31,0.00,'2022-06-30 17:08:04','',''),(2779,'21','227','1',1,'Retail Sale Id 3021',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 17:09:25','',''),(2780,'21','227','1',1,'Retail Sale Id 3022',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:10:30','',''),(2781,'21','227','1',1,'Retail Sale Id 3023',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:12:18','',''),(2782,'21','227','1',1,'Retail Sale Id 3024',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 17:14:16','',''),(2783,'21','227','1',1,'Retail Sale Id 3025',494.00,0.00,0.00,0.65,0.00,'2022-06-30 17:15:07','',''),(2784,'21','227','1',1,'Retail Sale Id 3026',760.00,0.00,0.00,1.00,0.00,'2022-06-30 17:17:16','',''),(2785,'21','227','1',1,'Retail Sale Id 3027',995.60,0.00,0.00,1.31,0.00,'2022-06-30 17:18:10','',''),(2786,'21','227','1',1,'Retail Sale Id 3028',4993.20,0.00,0.00,6.57,0.00,'2022-06-30 17:19:04','',''),(2787,'21','227','1',1,'Retail Sale Id 3029',6999.60,0.00,0.00,9.21,0.00,'2022-06-30 17:24:39','',''),(2788,'21','227','1',1,'Retail Sale Id 3030',494.00,0.00,0.00,0.65,0.00,'2022-06-30 17:25:45','',''),(2789,'21','227','1',1,'Retail Sale Id 3031',995.60,0.00,0.00,1.31,0.00,'2022-06-30 17:29:13','',''),(2790,'21','227','1',1,'Retail Sale Id 3032',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:32:07','',''),(2791,'21','227','1',1,'Retail Sale Id 3033',995.60,0.00,0.00,1.31,0.00,'2022-06-30 17:33:32','',''),(2792,'21','227','1',1,'Retail Sale Id 3034',1596.00,0.00,0.00,2.10,0.00,'2022-06-30 17:34:31','',''),(2793,'21','227','1',1,'Retail Sale Id 3035',2994.40,0.00,0.00,3.94,0.00,'2022-06-30 17:35:30','',''),(2794,'21','227','1',1,'Retail Sale Id 3036',798.00,0.00,0.00,1.05,0.00,'2022-06-30 17:39:59','',''),(2795,'21','227','1',1,'Retail Sale Id 3038',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 17:41:30','',''),(2796,'21','227','1',1,'Retail Sale Id 3037',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 17:42:50','',''),(2797,'21','227','1',1,'Retail Sale Id 3039',995.60,0.00,0.00,1.31,0.00,'2022-06-30 17:43:33','',''),(2798,'21','227','1',1,'Retail Sale Id 3040',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 17:44:59','',''),(2799,'21','227','1',1,'Retail Sale Id 3041',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 17:48:09','',''),(2800,'21','227','1',1,'Retail Sale Id 3042',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 17:51:02','',''),(2801,'21','227','1',1,'Retail Sale Id 3043',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 17:52:28','',''),(2802,'21','227','1',1,'Retail Sale Id 3044',4499.20,0.00,0.00,5.92,0.00,'2022-06-30 17:54:26','',''),(2803,'21','227','1',1,'Retail Sale Id 3045',995.60,0.00,0.00,1.31,0.00,'2022-06-30 17:56:41','',''),(2804,'21','227','1',1,'Retail Sale Id 3046',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 18:00:58','',''),(2805,'21','227','1',1,'Retail Sale Id 3047',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 18:03:40','',''),(2806,'21','227','1',1,'Retail Sale Id 3048',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 18:05:11','',''),(2807,'21','227','1',1,'Retail Sale Id 3049',2994.40,0.00,0.00,3.94,0.00,'2022-06-30 18:06:03','',''),(2808,'21','227','1',1,'Retail Sale Id 3050',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 18:07:47','',''),(2809,'21','227','1',1,'Retail Sale Id 3051',760.00,0.00,0.00,1.00,0.00,'2022-06-30 18:09:07','',''),(2810,'21','227','1',1,'Retail Sale Id 3052',760.00,0.00,0.00,1.00,0.00,'2022-06-30 18:09:48','',''),(2811,'21','227','1',1,'Retail Sale Id 3053',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 18:10:44','',''),(2812,'21','227','1',1,'Retail Sale Id 3054',760.00,0.00,0.00,1.00,0.00,'2022-06-30 18:11:47','',''),(2813,'21','227','1',1,'Retail Sale Id 3055',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 18:12:38','',''),(2814,'21','227','1',1,'Retail Sale Id 3056',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 18:13:51','',''),(2815,'21','227','1',1,'Retail Sale Id 3057',798.00,0.00,0.00,1.05,0.00,'2022-06-30 18:14:32','',''),(2816,'21','227','1',1,'Retail Sale Id 3058',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 18:15:26','',''),(2817,'21','227','1',1,'Retail Sale Id 3059',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 18:17:45','',''),(2818,'21','227','1',1,'Retail Sale Id 3060',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 18:19:19','',''),(2819,'21','227','1',1,'Retail Sale Id 3061',995.60,0.00,0.00,1.31,0.00,'2022-06-30 18:20:06','',''),(2820,'21','227','1',1,'Retail Sale Id 3062',4499.20,0.00,0.00,5.92,0.00,'2022-06-30 18:21:07','',''),(2821,'21','227','1',1,'Retail Sale Id 3063',494.00,0.00,0.00,0.65,0.00,'2022-06-30 18:22:12','',''),(2822,'21','227','1',1,'Retail Sale Id 3064',494.00,0.00,0.00,0.65,0.00,'2022-06-30 18:23:12','',''),(2823,'21','227','1',1,'Retail Sale Id 3065',995.60,0.00,0.00,1.31,0.00,'2022-06-30 18:23:46','',''),(2824,'21','227','1',1,'Retail Sale Id 3066',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 18:24:40','',''),(2825,'21','227','1',1,'Retail Sale Id 3067',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 18:25:28','',''),(2826,'21','227','1',1,'Retail Sale Id 3068',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 18:26:00','',''),(2827,'21','227','1',1,'Retail Sale Id 3069',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 18:28:54','',''),(2828,'21','227','1',1,'Retail Sale Id 3070',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 18:31:23','',''),(2829,'21','227','1',1,'Retail Sale Id 3071',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 18:32:37','',''),(2830,'21','227','1',1,'Retail Sale Id 3073',2492.80,0.00,0.00,3.28,0.00,'2022-06-30 18:33:56','',''),(2831,'21','227','1',1,'Retail Sale Id 3074',995.60,0.00,0.00,1.31,0.00,'2022-06-30 18:34:48','',''),(2832,'21','227','1',1,'Retail Sale Id 3075',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 18:38:56','',''),(2833,'21','227','1',1,'Retail Sale Id 3076',760.00,0.00,0.00,1.00,0.00,'2022-06-30 18:39:48','',''),(2834,'21','227','1',1,'Retail Sale Id 3079',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 12:04:42','',''),(2835,'21','227','1',1,'Retail Sale Id 3080',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 12:26:44','',''),(2836,'21','227','1',1,'Retail Sale Id 3081',4499.20,0.00,0.00,5.92,0.00,'2022-07-01 12:27:27','',''),(2837,'21','227','1',1,'Retail Sale Id 3082',2994.40,0.00,0.00,3.94,0.00,'2022-07-01 12:30:47','',''),(2838,'21','227','1',1,'Retail Sale Id 3083',995.60,0.00,0.00,1.31,0.00,'2022-07-01 12:31:37','',''),(2839,'21','227','1',1,'Retail Sale Id 3084',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 12:34:48','',''),(2840,'21','227','1',1,'Retail Sale Id 3085',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 12:35:29','',''),(2841,'21','227','1',1,'Retail Sale Id 3086',7600.00,0.00,0.00,10.00,0.00,'2022-07-01 12:36:10','',''),(2842,'21','227','1',1,'Retail Sale Id 3087',3040.00,0.00,0.00,4.00,0.00,'2022-07-01 12:36:46','',''),(2843,'21','227','1',1,'Retail Sale Id 3088',995.60,0.00,0.00,1.31,0.00,'2022-07-01 12:37:25','',''),(2844,'21','227','1',1,'Retail Sale Id 3089',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 12:41:11','',''),(2845,'21','227','1',1,'Retail Sale Id 3090',995.60,0.00,0.00,1.31,0.00,'2022-07-01 12:41:50','',''),(2846,'21','227','1',1,'Retail Sale Id 3091',2994.40,0.00,0.00,3.94,0.00,'2022-07-01 12:42:39','',''),(2847,'21','227','1',1,'Retail Sale Id 3092',3739.20,0.00,0.00,4.92,0.00,'2022-07-01 12:43:27','',''),(2848,'21','227','1',1,'Retail Sale Id 3093',2994.40,0.00,0.00,3.94,0.00,'2022-07-01 12:44:14','',''),(2849,'21','227','1',1,'Retail Sale Id 3094',7600.00,0.00,0.00,10.00,0.00,'2022-07-01 12:45:33','',''),(2850,'21','227','1',1,'Retail Sale Id 3095',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 12:46:17','',''),(2851,'21','227','1',1,'Retail Sale Id 3096',4993.20,0.00,0.00,6.57,0.00,'2022-07-01 12:47:04','',''),(2852,'21','227','1',1,'Retail Sale Id 3097',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 12:47:42','',''),(2853,'21','227','1',1,'Retail Sale Id 3098',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 12:48:42','',''),(2854,'21','227','1',1,'Retail Sale Id 3099',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 12:49:18','',''),(2855,'21','227','1',1,'Retail Sale Id 3100',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 14:19:36','',''),(2856,'21','227','1',1,'Retail Sale Id 3101',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 14:20:29','',''),(2857,'21','227','1',1,'Retail Sale Id 3102',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 14:23:29','',''),(2858,'21','227','1',1,'Retail Sale Id 3103',6840.00,0.00,0.00,9.00,0.00,'2022-07-01 14:28:40','',''),(2859,'21','227','1',1,'Retail Sale Id 3104',3997.60,0.00,0.00,5.26,0.00,'2022-07-01 14:29:30','',''),(2860,'21','227','1',1,'Retail Sale Id 3105',2492.80,0.00,0.00,3.28,0.00,'2022-07-01 14:35:26','',''),(2861,'21','227','1',1,'Retail Sale Id 3106',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 14:36:17','',''),(2862,'21','227','1',1,'Retail Sale Id 3107',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 14:37:00','',''),(2863,'21','227','1',1,'Retail Sale Id 3108',995.60,0.00,0.00,1.31,0.00,'2022-07-01 14:37:38','',''),(2864,'21','227','1',1,'Retail Sale Id 3109',4993.20,0.00,0.00,6.57,0.00,'2022-07-01 14:41:57','',''),(2865,'21','227','1',1,'Retail Sale Id 3110',760.00,0.00,0.00,1.00,0.00,'2022-07-01 14:44:18','',''),(2866,'21','227','1',1,'Retail Sale Id 3111',4993.20,0.00,0.00,6.57,0.00,'2022-07-01 14:45:03','',''),(2867,'21','227','1',1,'Retail Sale Id 3112',3997.60,0.00,0.00,5.26,0.00,'2022-07-01 14:47:32','',''),(2868,'21','227','1',1,'Retail Sale Id 3113',1497.20,0.00,0.00,1.97,0.00,'2022-07-01 14:48:23','',''),(2869,'21','227','1',1,'Retail Sale Id 3114',1497.20,0.00,0.00,1.97,0.00,'2022-07-01 14:51:07','',''),(2870,'21','227','1',1,'Retail Sale Id 3115',4993.20,0.00,0.00,6.57,0.00,'2022-07-01 14:52:03','',''),(2871,'21','227','1',1,'Retail Sale Id 3116',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 14:52:46','',''),(2872,'21','227','1',1,'Retail Sale Id 3117',4560.00,0.00,0.00,6.00,0.00,'2022-07-01 14:53:23','',''),(2873,'21','227','1',1,'Retail Sale Id 3118',1497.20,0.00,0.00,1.97,0.00,'2022-07-01 14:54:55','',''),(2874,'21','227','1',1,'Retail Sale Id 3119',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 14:59:44','',''),(2875,'21','227','1',1,'Retail Sale Id 3121',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 15:00:44','',''),(2876,'21','227','1',1,'Retail Sale Id 3122',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 15:01:23','',''),(2877,'21','227','1',1,'Retail Sale Id 3123',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 15:02:13','',''),(2878,'21','227','1',1,'Retail Sale Id 3124',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 15:02:55','',''),(2879,'21','227','1',1,'Retail Sale Id 3125',1520.00,0.00,0.00,2.00,0.00,'2022-07-01 15:03:38','',''),(2880,'21','227','1',1,'Retail Sale Id 3126',494.00,0.00,0.00,0.65,0.00,'2022-07-01 15:04:34','',''),(2881,'21','227','1',1,'Retail Sale Id 3127',995.60,0.00,0.00,1.31,0.00,'2022-07-01 15:05:15','',''),(2882,'21','227','1',1,'Retail Sale Id 3128',1520.00,0.00,0.00,2.00,0.00,'2022-07-01 15:05:51','',''),(2883,'21','227','1',1,'Retail Sale Id 3129',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 15:06:37','',''),(2884,'21','227','1',1,'Retail Sale Id 3130',1497.20,0.00,0.00,1.97,0.00,'2022-07-01 15:07:34','',''),(2885,'21','227','1',1,'Retail Sale Id 3131',4993.20,0.00,0.00,6.57,0.00,'2022-07-01 15:10:11','',''),(2886,'21','227','1',1,'Retail Sale Id 3132',15960.00,0.00,0.00,21.00,0.00,'2022-07-01 15:10:52','',''),(2887,'21','227','1',1,'Retail Sale Id 3133',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 15:11:30','',''),(2888,'21','227','1',1,'Retail Sale Id 3134',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 15:14:38','',''),(2889,'21','227','1',1,'Retail Sale Id 3135',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 15:16:39','',''),(2890,'21','227','1',1,'Retail Sale Id 3136',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 15:17:36','',''),(2891,'21','227','1',1,'Retail Sale Id 3137',995.60,0.00,0.00,1.31,0.00,'2022-07-01 15:18:27','',''),(2892,'21','227','1',1,'Retail Sale Id 3138',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 15:19:16','',''),(2893,'21','227','1',1,'Retail Sale Id 3139',1694.80,0.00,0.00,2.23,0.00,'2022-07-01 15:20:22','',''),(2894,'21','227','1',1,'Retail Sale Id 3140',4560.00,0.00,0.00,6.00,0.00,'2022-07-01 15:22:53','',''),(2895,'21','227','1',1,'Retail Sale Id 3141',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 15:24:37','',''),(2896,'21','227','1',1,'Retail Sale Id 3142',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 15:25:08','',''),(2897,'21','227','1',1,'Retail Sale Id 3143',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 15:25:45','',''),(2898,'21','227','1',1,'Retail Sale Id 3144',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 15:28:52','',''),(2899,'21','227','1',1,'Retail Sale Id 3145',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 15:30:22','',''),(2900,'21','227','1',1,'Retail Sale Id 3146',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 15:31:01','',''),(2901,'21','227','1',1,'Retail Sale Id 3147',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 15:33:44','',''),(2902,'21','227','1',1,'Retail Sale Id 3148',19000.00,0.00,0.00,25.00,0.00,'2022-07-01 15:35:47','',''),(2903,'21','227','1',1,'Retail Sale Id 3078',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 15:37:46','',''),(2904,'21','227','1',1,'Retail Sale Id 3149',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 15:39:52','',''),(2905,'21','227','1',1,'Retail Sale Id 3150',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 15:47:33','',''),(2906,'21','227','1',1,'Retail Sale Id 3151',4560.00,0.00,0.00,6.00,0.00,'2022-07-01 15:53:18','',''),(2907,'21','227','1',1,'Retail Sale Id 3152',995.60,0.00,0.00,1.31,0.00,'2022-07-01 16:07:58','',''),(2908,'21','227','1',1,'Retail Sale Id 3153',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 16:09:44','',''),(2909,'21','227','1',1,'Retail Sale Id 3154',1497.20,0.00,0.00,1.97,0.00,'2022-07-01 16:10:35','',''),(2910,'21','227','1',1,'Retail Sale Id 3155',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 16:12:30','',''),(2911,'21','227','1',1,'Retail Sale Id 3156',4560.00,0.00,0.00,6.00,0.00,'2022-07-01 16:19:24','',''),(2912,'21','227','1',1,'Retail Sale Id 3157',3997.60,0.00,0.00,5.26,0.00,'2022-07-01 16:22:32','',''),(2913,'21','227','1',1,'Retail Sale Id 3158',995.60,0.00,0.00,1.31,0.00,'2022-07-01 16:30:47','',''),(2914,'21','227','1',1,'Retail Sale Id 3159',5996.40,0.00,0.00,7.89,0.00,'2022-07-01 16:32:01','',''),(2915,'21','227','1',1,'Retail Sale Id 3160',1520.00,0.00,0.00,2.00,0.00,'2022-07-01 16:36:28','',''),(2916,'21','227','1',1,'Retail Sale Id 3161',995.60,0.00,0.00,1.31,0.00,'2022-07-01 16:37:25','',''),(2917,'21','227','1',1,'Retail Sale Id 3162',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 16:38:11','',''),(2918,'21','227','1',1,'Retail Sale Id 3163',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 16:39:03','',''),(2919,'21','227','1',1,'Retail Sale Id 3164',699.20,0.00,0.00,0.92,0.00,'2022-07-01 16:42:58','',''),(2920,'21','227','1',1,'Retail Sale Id 3165',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 16:44:24','',''),(2921,'21','227','1',1,'Retail Sale Id 3166',3997.60,0.00,0.00,5.26,0.00,'2022-07-01 16:45:07','',''),(2922,'21','227','1',1,'Retail Sale Id 3167',1520.00,0.00,0.00,2.00,0.00,'2022-07-01 16:45:51','',''),(2923,'21','227','1',1,'Retail Sale Id 3168',4993.20,0.00,0.00,6.57,0.00,'2022-07-01 16:46:42','',''),(2924,'21','227','1',1,'Retail Sale Id 3169',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 16:48:25','',''),(2925,'21','227','1',1,'Retail Sale Id 3170',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 16:54:14','',''),(2926,'21','227','1',1,'Retail Sale Id 3171',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 16:57:13','',''),(2927,'21','227','1',1,'Retail Sale Id 3171',4560.00,0.00,0.00,6.00,0.00,'2022-07-01 16:57:13','',''),(2928,'21','227','1',1,'Retail Sale Id 3172',494.00,0.00,0.00,0.65,0.00,'2022-07-01 16:59:42','',''),(2929,'21','227','1',1,'Retail Sale Id 3173',2295.20,0.00,0.00,3.02,0.00,'2022-07-01 17:00:32','',''),(2930,'21','227','1',1,'Retail Sale Id 3174',494.00,0.00,0.00,0.65,0.00,'2022-07-01 17:01:39','',''),(2931,'21','227','1',1,'Retail Sale Id 3175',3800.00,0.00,0.00,5.00,0.00,'2022-07-01 17:02:38','',''),(2932,'21','227','1',1,'Retail Sale Id 3176',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 17:04:50','',''),(2933,'21','227','1',1,'Retail Sale Id 3177',1497.20,0.00,0.00,1.97,0.00,'2022-07-01 17:06:00','',''),(2934,'21','227','1',1,'Retail Sale Id 3177',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 17:06:00','',''),(2935,'21','227','1',1,'Retail Sale Id 3178',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 17:07:19','',''),(2936,'21','227','1',1,'Retail Sale Id 3179',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 17:11:02','',''),(2937,'21','227','1',1,'Retail Sale Id 3180',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 17:12:19','',''),(2938,'21','227','1',1,'Retail Sale Id 3181',1497.20,0.00,0.00,1.97,0.00,'2022-07-01 17:13:43','',''),(2939,'21','227','1',1,'Retail Sale Id 3183',4560.00,0.00,0.00,6.00,0.00,'2022-07-01 17:18:32','',''),(2940,'21','227','1',1,'Retail Sale Id 3184',896.80,0.00,0.00,1.18,0.00,'2022-07-01 17:39:24','',''),(2941,'21','227','1',1,'Retail Sale Id 3185',1793.60,0.00,0.00,2.36,0.00,'2022-07-01 17:40:04','',''),(2942,'21','227','1',1,'Retail Sale Id 3186',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 17:41:00','',''),(2943,'21','227','1',1,'Retail Sale Id 3187',4993.20,0.00,0.00,6.57,0.00,'2022-07-01 17:41:46','',''),(2944,'21','227','1',1,'Retail Sale Id 3188',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 17:42:44','',''),(2945,'21','227','1',1,'Retail Sale Id 3189',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 17:43:26','',''),(2946,'21','227','1',1,'Retail Sale Id 3190',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 17:44:28','',''),(2947,'21','227','1',1,'Retail Sale Id 3191',995.60,0.00,0.00,1.31,0.00,'2022-07-01 17:46:48','',''),(2948,'21','227','1',1,'Retail Sale Id 3192',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 17:47:35','',''),(2949,'21','227','1',1,'Retail Sale Id 3193',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 17:49:46','',''),(2950,'21','227','1',1,'Retail Sale Id 3194',3997.60,0.00,0.00,5.26,0.00,'2022-07-01 17:52:39','',''),(2951,'21','227','1',1,'Retail Sale Id 3195',995.60,0.00,0.00,1.31,0.00,'2022-07-01 17:53:53','',''),(2952,'21','227','1',1,'Retail Sale Id 3196',494.00,0.00,0.00,0.65,0.00,'2022-07-01 17:54:35','',''),(2953,'21','227','1',1,'Retail Sale Id 3197',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 17:55:40','',''),(2954,'21','227','1',1,'Retail Sale Id 3198',2492.80,0.00,0.00,3.28,0.00,'2022-07-01 17:56:23','',''),(2955,'21','227','1',1,'Retail Sale Id 3199',2280.00,0.00,0.00,3.00,0.00,'2022-07-01 17:57:11','',''),(2956,'21','227','1',1,'Retail Sale Id 3200',995.60,0.00,0.00,1.31,0.00,'2022-07-01 18:05:40','',''),(2957,'21','227','1',1,'Retail Sale Id 3201',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 18:06:59','',''),(2958,'21','227','1',1,'Retail Sale Id 3202',995.60,0.00,0.00,1.31,0.00,'2022-07-01 18:08:37','',''),(2959,'21','227','1',1,'Retail Sale Id 3203',3040.00,0.00,0.00,4.00,0.00,'2022-07-01 18:10:38','',''),(2960,'21','227','1',1,'Retail Sale Id 3204',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 18:21:41','',''),(2961,'21','227','1',1,'Retail Sale Id 3205',1998.80,0.00,0.00,2.63,0.00,'2022-07-01 18:25:13','',''),(2962,'21','227','1',1,'Retail Sale Id 3206',19000.00,0.00,0.00,25.00,0.00,'2022-07-01 18:32:20','',''),(2963,'21','227','1',1,'Retail Sale Id 3207',63080.00,0.00,0.00,83.00,0.00,'2022-07-01 18:41:05','',''),(2964,'21','227','1',1,'Retail Sale Id 3208',995.60,0.00,0.00,1.31,0.00,'2022-07-01 18:44:53','',''),(2965,'21','227','1',1,'Retail Sale Id 3209',995.60,0.00,0.00,1.31,0.00,'2022-07-01 18:46:56','',''),(2966,'21','227','1',1,'Retail Sale Id 3210',494.00,0.00,0.00,0.65,0.00,'2022-07-01 18:49:05','',''),(2967,'21','227','1',1,'Retail Sale Id 3211',4560.00,0.00,0.00,6.00,0.00,'2022-07-01 18:52:35','',''),(2968,'21','227','1',1,'Retail Sale Id 3211',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 18:52:35','',''),(2969,'21','227','1',1,'Retail Sale Id 3212',995.60,0.00,0.00,1.31,0.00,'2022-07-01 19:14:48','',''),(2970,'21','227','1',1,'Retail Sale Id 3213',4993.20,0.00,0.00,6.57,0.00,'2022-07-03 14:30:32','',''),(2971,'21','227','1',1,'Retail Sale Id 3213',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:30:32','',''),(2972,'21','227','1',1,'Retail Sale Id 3214',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 14:31:27','',''),(2973,'21','227','1',1,'Retail Sale Id 3214',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:31:27','',''),(2974,'21','227','1',1,'Retail Sale Id 3214',7600.00,0.00,0.00,10.00,0.00,'2022-07-03 14:31:27','',''),(2975,'21','227','1',1,'Retail Sale Id 3214',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:31:27','',''),(2976,'21','227','1',1,'Retail Sale Id 3215',1520.00,0.00,0.00,2.00,0.00,'2022-07-03 14:32:48','',''),(2977,'21','227','1',1,'Retail Sale Id 3215',4993.20,0.00,0.00,6.57,0.00,'2022-07-03 14:32:48','',''),(2978,'21','227','1',1,'Retail Sale Id 3215',6840.00,0.00,0.00,9.00,0.00,'2022-07-03 14:32:48','',''),(2979,'21','227','1',1,'Retail Sale Id 3215',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:32:48','',''),(2980,'21','227','1',1,'Retail Sale Id 3216',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 14:33:58','',''),(2981,'21','227','1',1,'Retail Sale Id 3216',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:33:58','',''),(2982,'21','227','1',1,'Retail Sale Id 3216',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:33:58','',''),(2983,'21','227','1',1,'Retail Sale Id 3217',4993.20,0.00,0.00,6.57,0.00,'2022-07-03 14:35:10','',''),(2984,'21','227','1',1,'Retail Sale Id 3217',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:35:10','',''),(2985,'21','227','1',1,'Retail Sale Id 3217',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 14:35:10','',''),(2986,'21','227','1',1,'Retail Sale Id 3218',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 14:36:22','',''),(2987,'21','227','1',1,'Retail Sale Id 3218',7600.00,0.00,0.00,10.00,0.00,'2022-07-03 14:36:22','',''),(2988,'21','227','1',1,'Retail Sale Id 3218',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:36:22','',''),(2989,'21','227','1',1,'Retail Sale Id 3218',11400.00,0.00,0.00,15.00,0.00,'2022-07-03 14:36:22','',''),(2990,'21','227','1',1,'Retail Sale Id 3219',1900.00,0.00,0.00,2.50,0.00,'2022-07-03 14:37:21','',''),(2991,'21','227','1',1,'Retail Sale Id 3219',2994.40,0.00,0.00,3.94,0.00,'2022-07-03 14:37:21','',''),(2992,'21','227','1',1,'Retail Sale Id 3219',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 14:37:21','',''),(2993,'21','227','1',1,'Retail Sale Id 3219',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:37:21','',''),(2994,'21','227','1',1,'Retail Sale Id 3220',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 14:41:08','',''),(2995,'21','227','1',1,'Retail Sale Id 3220',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 14:41:08','',''),(2996,'21','227','1',1,'Retail Sale Id 3220',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:41:08','',''),(2997,'21','227','1',1,'Retail Sale Id 3220',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:41:08','',''),(2998,'21','227','1',1,'Retail Sale Id 3221',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 14:42:04','',''),(2999,'21','227','1',1,'Retail Sale Id 3221',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:42:04','',''),(3000,'21','227','1',1,'Retail Sale Id 3221',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:42:04','',''),(3001,'21','227','1',1,'Retail Sale Id 3222',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:43:04','',''),(3002,'21','227','1',1,'Retail Sale Id 3222',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:43:04','',''),(3003,'21','227','1',1,'Retail Sale Id 3222',7600.00,0.00,0.00,10.00,0.00,'2022-07-03 14:43:04','',''),(3004,'21','227','1',1,'Retail Sale Id 3222',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:43:04','',''),(3005,'21','227','1',1,'Retail Sale Id 3223',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 14:44:35','',''),(3006,'21','227','1',1,'Retail Sale Id 3223',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 14:44:35','',''),(3007,'21','227','1',1,'Retail Sale Id 3223',2994.40,0.00,0.00,3.94,0.00,'2022-07-03 14:44:35','',''),(3008,'21','227','1',1,'Retail Sale Id 3223',3997.60,0.00,0.00,5.26,0.00,'2022-07-03 14:44:35','',''),(3009,'21','227','1',1,'Retail Sale Id 3223',4993.20,0.00,0.00,6.57,0.00,'2022-07-03 14:44:35','',''),(3010,'21','227','1',1,'Retail Sale Id 3223',7600.00,0.00,0.00,10.00,0.00,'2022-07-03 14:44:35','',''),(3011,'21','227','1',1,'Retail Sale Id 3223',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:44:35','',''),(3012,'21','227','1',1,'Retail Sale Id 3223',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:44:35','',''),(3013,'21','227','1',1,'Retail Sale Id 3224',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 14:46:40','',''),(3014,'21','227','1',1,'Retail Sale Id 3224',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 14:46:40','',''),(3015,'21','227','1',1,'Retail Sale Id 3224',7600.00,0.00,0.00,10.00,0.00,'2022-07-03 14:46:40','',''),(3016,'21','227','1',1,'Retail Sale Id 3224',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:46:40','',''),(3017,'21','227','1',1,'Retail Sale Id 3224',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 14:46:40','',''),(3018,'21','227','1',1,'Retail Sale Id 3225',2994.40,0.00,0.00,3.94,0.00,'2022-07-03 14:47:31','',''),(3019,'21','227','1',1,'Retail Sale Id 3225',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:47:31','',''),(3020,'21','227','1',1,'Retail Sale Id 3225',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:47:31','',''),(3021,'21','227','1',1,'Retail Sale Id 3226',1520.00,0.00,0.00,2.00,0.00,'2022-07-03 14:49:29','',''),(3022,'21','227','1',1,'Retail Sale Id 3226',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:49:29','',''),(3023,'21','227','1',1,'Retail Sale Id 3226',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:49:29','',''),(3024,'21','227','1',1,'Retail Sale Id 3226',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:49:29','',''),(3025,'21','227','1',1,'Retail Sale Id 3226',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:49:29','',''),(3026,'21','227','1',1,'Retail Sale Id 3227',798.00,0.00,0.00,1.05,0.00,'2022-07-03 14:50:42','',''),(3027,'21','227','1',1,'Retail Sale Id 3227',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 14:50:42','',''),(3028,'21','227','1',1,'Retail Sale Id 3227',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 14:50:42','',''),(3029,'21','227','1',1,'Retail Sale Id 3227',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 14:50:42','',''),(3030,'21','227','1',1,'Retail Sale Id 3227',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:50:42','',''),(3031,'21','227','1',1,'Retail Sale Id 3228',73013.20,0.00,0.00,96.07,0.00,'2022-07-03 14:57:20','',''),(3032,'21','227','1',1,'Retail Sale Id 3229',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 14:57:55','',''),(3033,'21','227','1',1,'Retail Sale Id 3230',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 14:58:23','',''),(3034,'21','227','1',1,'Retail Sale Id 3231',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 14:58:46','',''),(3035,'21','227','1',1,'Retail Sale Id 3232',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 14:59:06','',''),(3036,'21','227','1',1,'Retail Sale Id 3233',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 14:59:37','',''),(3037,'21','227','1',1,'Retail Sale Id 3234',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 15:00:02','',''),(3038,'21','227','1',1,'Retail Sale Id 3235',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 15:00:46','',''),(3039,'21','227','1',1,'Retail Sale Id 3235',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 15:00:46','',''),(3040,'21','227','1',1,'Retail Sale Id 3236',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 15:01:08','',''),(3041,'21','227','1',1,'Retail Sale Id 3237',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 15:01:48','',''),(3042,'21','227','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,266.85,0.00,'2022-07-04 11:15:02','',''),(3043,'21','227','1',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-07-04 11:15:02','',''),(3044,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-07-04 11:16:48','',''),(3045,'21','227',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,3000.00,0.00,'2022-07-04 11:17:32','',''),(3046,'21','227','1',1,'Received from bridging 8',0.00,0.00,3000.00,0.00,0.00,'2022-07-04 11:17:32','',''),(3047,'21','227','1',1,'Retail Sale Id 3238',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 11:18:31','',''),(3048,'21','227',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,2000.00,0.00,'2022-07-04 11:22:31','',''),(3049,'21','227','1',1,'Received from bridging 9',0.00,0.00,2000.00,0.00,0.00,'2022-07-04 11:22:31','',''),(3050,'21','227','1',1,'Retail Sale Id 3239',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 11:23:39','',''),(3051,'21','227','1',1,'Retail Sale Id 3239',1520.00,0.00,0.00,2.00,0.00,'2022-07-04 11:23:39','',''),(3052,'21','227','1',1,'Retail Sale Id 3239',1900.00,0.00,0.00,2.50,0.00,'2022-07-04 11:23:39','',''),(3053,'21','227','1',1,'Retail Sale Id 3240',995.60,0.00,0.00,1.31,0.00,'2022-07-04 11:24:36','',''),(3054,'21','227','1',1,'Retail Sale Id 3240',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 11:24:36','',''),(3055,'21','227','1',1,'Retail Sale Id 3240',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 11:24:36','',''),(3056,'21','227','1',1,'Retail Sale Id 3241',995.60,0.00,0.00,1.31,0.00,'2022-07-04 11:26:20','',''),(3057,'21','227','1',1,'Retail Sale Id 3242',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 11:27:34','',''),(3058,'21','227','1',1,'Retail Sale Id 3242',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 11:27:34','',''),(3059,'21','227','1',1,'Retail Sale Id 3243',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 11:28:15','',''),(3060,'21','227','1',1,'Retail Sale Id 3243',7600.00,0.00,0.00,10.00,0.00,'2022-07-04 11:28:15','',''),(3061,'21','227','1',1,'Retail Sale Id 3244',995.60,0.00,0.00,1.31,0.00,'2022-07-04 11:29:04','',''),(3062,'21','227','1',1,'Retail Sale Id 3244',4993.20,0.00,0.00,6.57,0.00,'2022-07-04 11:29:04','',''),(3063,'21','227','1',1,'Retail Sale Id 3245',760.00,0.00,0.00,1.00,0.00,'2022-07-04 11:29:33','',''),(3064,'21','227','1',1,'Retail Sale Id 3246',760.00,0.00,0.00,1.00,0.00,'2022-07-04 11:30:46','',''),(3065,'21','227','1',1,'Retail Sale Id 3246',995.60,0.00,0.00,1.31,0.00,'2022-07-04 11:30:46','',''),(3066,'21','227','1',1,'Retail Sale Id 3246',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 11:30:46','',''),(3067,'21','227','1',1,'Retail Sale Id 3247',995.60,0.00,0.00,1.31,0.00,'2022-07-04 11:31:48','',''),(3068,'21','227','1',1,'Retail Sale Id 3247',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 11:31:48','',''),(3069,'21','227','1',1,'Retail Sale Id 3247',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 11:31:48','',''),(3070,'21','227','1',1,'Retail Sale Id 3248',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 11:32:49','',''),(3071,'21','227','1',1,'Retail Sale Id 3248',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 11:32:49','',''),(3072,'21','227','1',1,'Retail Sale Id 3248',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 11:32:49','',''),(3073,'21','227','1',1,'Retail Sale Id 3249',995.60,0.00,0.00,1.31,0.00,'2022-07-04 11:33:38','',''),(3074,'21','227','1',1,'Retail Sale Id 3249',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 11:33:38','',''),(3075,'21','227','1',1,'Retail Sale Id 3250',995.60,0.00,0.00,1.31,0.00,'2022-07-04 11:34:13','',''),(3076,'21','227','1',1,'Retail Sale Id 3250',995.60,0.00,0.00,1.31,0.00,'2022-07-04 11:34:13','',''),(3077,'21','227','1',1,'Retail Sale Id 3251',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 11:35:17','',''),(3078,'21','227','1',1,'Retail Sale Id 3252',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 11:44:38','',''),(3079,'21','227','1',1,'Retail Sale Id 3253',4499.20,0.00,0.00,5.92,0.00,'2022-07-04 11:50:47','',''),(3080,'21','227','1',1,'Retail Sale Id 3254',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 11:52:43','',''),(3081,'21','227','1',1,'Retail Sale Id 3255',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 11:57:35','',''),(3082,'21','227','1',1,'Retail Sale Id 3256',995.60,0.00,0.00,1.31,0.00,'2022-07-04 12:03:03','',''),(3083,'21','227','1',1,'Retail Sale Id 3257',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 12:18:23','',''),(3084,'21','227','1',1,'Retail Sale Id 3258',995.60,0.00,0.00,1.31,0.00,'2022-07-04 12:23:21','',''),(3085,'21','227','1',1,'Retail Sale Id 3259',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 12:26:21','',''),(3086,'21','227','1',1,'Retail Sale Id 3260',1748.00,0.00,0.00,2.30,0.00,'2022-07-04 12:28:53','',''),(3087,'21','227','1',1,'Retail Sale Id 3261',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 12:35:00','',''),(3088,'21','227','1',1,'Retail Sale Id 3262',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 12:37:47','',''),(3089,'21','227','1',1,'Retail Sale Id 3263',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 12:39:23','',''),(3090,'21','227','1',1,'Retail Sale Id 3264',3997.60,0.00,0.00,5.26,0.00,'2022-07-04 12:40:29','',''),(3091,'21','227','1',1,'Retail Sale Id 3265',6999.60,0.00,0.00,9.21,0.00,'2022-07-04 12:43:29','',''),(3092,'21','227','1',1,'Retail Sale Id 3266',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 12:45:09','',''),(3093,'21','227','1',1,'Retail Sale Id 3267',798.00,0.00,0.00,1.05,0.00,'2022-07-04 12:47:57','',''),(3094,'21','227','1',1,'Retail Sale Id 3268',1193.20,0.00,0.00,1.57,0.00,'2022-07-04 12:49:50','',''),(3095,'21','227','1',1,'Retail Sale Id 3269',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 12:53:03','',''),(3096,'21','227','1',1,'Retail Sale Id 3270',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 13:01:40','',''),(3097,'21','227','1',1,'Retail Sale Id 3271',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 13:08:07','',''),(3098,'21','227','1',1,'Retail Sale Id 3272',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 13:08:49','',''),(3099,'21','227','1',1,'Retail Sale Id 3273',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 13:10:54','',''),(3100,'21','227','1',1,'Retail Sale Id 3274',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 13:12:44','',''),(3101,'21','227','1',1,'Retail Sale Id 3275',760.00,0.00,0.00,1.00,0.00,'2022-07-04 13:13:56','',''),(3102,'21','227','1',1,'Retail Sale Id 3276',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 13:17:18','',''),(3103,'21','227','1',1,'Retail Sale Id 3277',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 13:20:18','',''),(3104,'21','227','1',1,'Retail Sale Id 3278',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 13:21:05','',''),(3105,'21','227','1',1,'Retail Sale Id 3279',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 13:22:16','',''),(3106,'21','227','1',1,'Retail Sale Id 3280',1299.60,0.00,0.00,1.71,0.00,'2022-07-04 13:28:41','',''),(3107,'21','227','1',1,'Retail Sale Id 3281',995.60,0.00,0.00,1.31,0.00,'2022-07-04 13:29:33','',''),(3108,'21','227','1',1,'Retail Sale Id 3283',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 13:30:58','',''),(3109,'21','227','1',1,'Retail Sale Id 3283',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 13:30:58','',''),(3110,'21','227','1',1,'Retail Sale Id 3283',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 13:30:58','',''),(3111,'21','227','1',1,'Retail Sale Id 3284',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 13:36:06','',''),(3112,'21','227','1',1,'Retail Sale Id 3285',760.00,0.00,0.00,1.00,0.00,'2022-07-04 13:37:05','',''),(3113,'21','227','1',1,'Retail Sale Id 3286',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 13:38:20','',''),(3114,'21','227','1',1,'Retail Sale Id 3287',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 13:40:04','',''),(3115,'21','227','1',1,'Retail Sale Id 3288',995.60,0.00,0.00,1.31,0.00,'2022-07-04 13:40:38','',''),(3116,'21','227','1',1,'Retail Sale Id 3289',1520.00,0.00,0.00,2.00,0.00,'2022-07-04 14:04:46','',''),(3117,'21','227','1',1,'Retail Sale Id 3290',8998.40,0.00,0.00,11.84,0.00,'2022-07-04 14:09:25','',''),(3118,'21','227','1',1,'Retail Sale Id 3291',995.60,0.00,0.00,1.31,0.00,'2022-07-04 14:10:13','',''),(3119,'21','227','1',1,'Retail Sale Id 3292',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 14:11:01','',''),(3120,'21','227','1',1,'Retail Sale Id 3293',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 14:12:01','',''),(3121,'21','227','1',1,'Retail Sale Id 3294',1520.00,0.00,0.00,2.00,0.00,'2022-07-04 14:13:16','',''),(3122,'21','227','1',1,'Retail Sale Id 3295',995.60,0.00,0.00,1.31,0.00,'2022-07-04 14:13:53','',''),(3123,'21','227','1',1,'Retail Sale Id 3296',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 14:14:34','',''),(3124,'21','227','1',1,'Retail Sale Id 3297',1520.00,0.00,0.00,2.00,0.00,'2022-07-04 14:18:58','',''),(3125,'21','227','1',1,'Retail Sale Id 3298',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 14:28:11','',''),(3126,'21','227','1',1,'Retail Sale Id 3299',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 14:30:03','',''),(3127,'21','227','1',1,'Retail Sale Id 3300',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 14:34:00','',''),(3128,'21','227','1',1,'Retail Sale Id 3301',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 14:34:41','',''),(3129,'21','227','1',1,'Retail Sale Id 3302',995.60,0.00,0.00,1.31,0.00,'2022-07-04 14:37:11','',''),(3130,'21','227','1',1,'Retail Sale Id 3303',760.00,0.00,0.00,1.00,0.00,'2022-07-04 14:39:25','',''),(3131,'21','227','1',1,'Retail Sale Id 3304',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 14:41:40','',''),(3132,'21','227','1',1,'Retail Sale Id 3304',6999.60,0.00,0.00,9.21,0.00,'2022-07-04 14:41:40','',''),(3133,'21','227','1',1,'Retail Sale Id 3305',1520.00,0.00,0.00,2.00,0.00,'2022-07-04 14:42:42','',''),(3134,'21','227','1',1,'Retail Sale Id 3306',3997.60,0.00,0.00,5.26,0.00,'2022-07-04 15:11:10','',''),(3135,'21','227','1',1,'Retail Sale Id 3307',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 15:12:16','',''),(3136,'21','227','1',1,'Retail Sale Id 3308',760.00,0.00,0.00,1.00,0.00,'2022-07-04 15:13:03','',''),(3137,'21','227','1',1,'Retail Sale Id 3309',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 15:13:47','',''),(3138,'21','227','1',1,'Retail Sale Id 3310',4993.20,0.00,0.00,6.57,0.00,'2022-07-04 15:14:36','',''),(3139,'21','227','1',1,'Retail Sale Id 3311',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 15:15:19','',''),(3140,'21','227','1',1,'Retail Sale Id 3312',3997.60,0.00,0.00,5.26,0.00,'2022-07-04 15:16:15','',''),(3141,'21','227','1',1,'Retail Sale Id 3313',3997.60,0.00,0.00,5.26,0.00,'2022-07-04 15:17:03','',''),(3142,'21','227','1',1,'Retail Sale Id 3313',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 15:17:03','',''),(3143,'21','227','1',1,'Retail Sale Id 3313',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 15:17:03','',''),(3144,'21','227','1',1,'Retail Sale Id 3314',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 15:18:27','',''),(3145,'21','227','1',1,'Retail Sale Id 3315',995.60,0.00,0.00,1.31,0.00,'2022-07-04 15:20:04','',''),(3146,'21','227','1',1,'Retail Sale Id 3316',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 15:29:45','',''),(3147,'21','227','1',1,'Retail Sale Id 3317',1793.60,0.00,0.00,2.36,0.00,'2022-07-04 15:32:50','',''),(3148,'21','227','1',1,'Retail Sale Id 3317',1793.60,0.00,0.00,2.36,0.00,'2022-07-04 15:32:51','',''),(3149,'21','227','1',1,'Retail Sale Id 3319',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 15:39:07','',''),(3150,'21','227','1',1,'Retail Sale Id 3320',1900.00,0.00,0.00,2.50,0.00,'2022-07-04 15:40:04','',''),(3151,'21','227','1',1,'Retail Sale Id 3321',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 15:41:29','',''),(3152,'21','227','1',1,'Retail Sale Id 3322',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 15:42:46','',''),(3153,'21','227','1',1,'Retail Sale Id 3323',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 15:43:22','',''),(3154,'21','227','1',1,'Retail Sale Id 3324',760.00,0.00,0.00,1.00,0.00,'2022-07-04 15:53:13','',''),(3155,'21','227','1',1,'Retail Sale Id 3325',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 15:53:56','',''),(3156,'21','227','1',1,'Retail Sale Id 3326',3496.00,0.00,0.00,4.60,0.00,'2022-07-04 15:56:21','',''),(3157,'21','227','1',1,'Retail Sale Id 3327',1793.60,0.00,0.00,2.36,0.00,'2022-07-04 15:57:06','',''),(3158,'21','227','1',1,'Retail Sale Id 3328',760.00,0.00,0.00,1.00,0.00,'2022-07-04 15:59:50','',''),(3159,'21','227','1',1,'Retail Sale Id 3329',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 16:14:54','',''),(3160,'21','227','1',1,'Retail Sale Id 3330',3997.60,0.00,0.00,5.26,0.00,'2022-07-04 16:15:57','',''),(3161,'21','227','1',1,'Retail Sale Id 3331',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 16:16:39','',''),(3162,'21','227','1',1,'Retail Sale Id 3332',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 16:17:22','',''),(3163,'21','227','1',1,'Retail Sale Id 3333',494.00,0.00,0.00,0.65,0.00,'2022-07-04 16:20:48','',''),(3164,'21','227','1',1,'Retail Sale Id 3334',494.00,0.00,0.00,0.65,0.00,'2022-07-04 16:21:39','',''),(3165,'21','227','1',1,'Retail Sale Id 3335',995.60,0.00,0.00,1.31,0.00,'2022-07-04 16:25:53','',''),(3166,'21','227','1',1,'Retail Sale Id 3336',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 16:27:49','',''),(3167,'21','227','1',1,'Retail Sale Id 3337',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 16:28:26','',''),(3168,'21','227','1',1,'Retail Sale Id 3338',1520.00,0.00,0.00,2.00,0.00,'2022-07-04 16:29:17','',''),(3169,'21','227','1',1,'Retail Sale Id 3339',494.00,0.00,0.00,0.65,0.00,'2022-07-04 16:29:51','',''),(3170,'21','227','1',1,'Retail Sale Id 3340',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 16:34:29','',''),(3171,'21','227','1',1,'Retail Sale Id 3341',4993.20,0.00,0.00,6.57,0.00,'2022-07-04 16:38:15','',''),(3172,'21','227','1',1,'Retail Sale Id 3342',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 16:40:07','',''),(3173,'21','227','1',1,'Retail Sale Id 3343',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 16:40:52','',''),(3174,'21','227','1',1,'Retail Sale Id 3344',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 16:45:00','',''),(3175,'21','227','1',1,'Retail Sale Id 3345',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 16:47:04','',''),(3176,'21','227','1',1,'Retail Sale Id 3346',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 16:49:30','',''),(3177,'21','227','1',1,'Retail Sale Id 3347',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 16:51:47','',''),(3178,'21','227','1',1,'Retail Sale Id 3348',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 16:53:01','',''),(3179,'21','227','1',1,'Retail Sale Id 3349',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 16:54:42','',''),(3180,'21','227','1',1,'Retail Sale Id 3350',995.60,0.00,0.00,1.31,0.00,'2022-07-04 16:56:00','',''),(3181,'21','227','1',1,'Retail Sale Id 3351',2599.20,0.00,0.00,3.42,0.00,'2022-07-04 16:57:32','',''),(3182,'21','227','1',1,'Retail Sale Id 3352',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 16:58:43','',''),(3183,'21','227','1',1,'Retail Sale Id 3353',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 16:59:43','',''),(3184,'21','227','1',1,'Retail Sale Id 3354',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 17:01:04','',''),(3185,'21','227','1',1,'Retail Sale Id 3355',2492.80,0.00,0.00,3.28,0.00,'2022-07-04 17:02:31','',''),(3186,'21','227','1',1,'Retail Sale Id 3356',760.00,0.00,0.00,1.00,0.00,'2022-07-04 17:03:30','',''),(3187,'21','227','1',1,'Retail Sale Id 3357',2994.40,0.00,0.00,3.94,0.00,'2022-07-04 17:05:55','',''),(3188,'21','227','1',1,'Retail Sale Id 3358',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 17:06:56','',''),(3189,'21','227','1',1,'Retail Sale Id 3359',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 17:07:38','',''),(3190,'21','227','1',1,'Retail Sale Id 3360',3997.60,0.00,0.00,5.26,0.00,'2022-07-04 17:08:29','',''),(3191,'21','227','1',1,'Retail Sale Id 3361',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 17:09:18','',''),(3192,'21','227','1',1,'Retail Sale Id 3362',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 17:10:04','',''),(3193,'21','227','1',1,'Retail Sale Id 3363',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 17:10:48','',''),(3194,'21','227','1',1,'Retail Sale Id 3364',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 17:11:25','',''),(3195,'21','227','1',1,'Retail Sale Id 3365',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 17:13:28','',''),(3196,'21','227','1',1,'Retail Sale Id 3366',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 17:17:28','',''),(3197,'21','227','1',1,'Retail Sale Id 3367',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 17:19:19','',''),(3198,'21','227','1',1,'Retail Sale Id 3368',1998.80,0.00,0.00,2.63,0.00,'2022-07-04 17:20:51','',''),(3199,'21','227','1',1,'Retail Sale Id 3369',8998.40,0.00,0.00,11.84,0.00,'2022-07-04 17:23:27','',''),(3200,'21','227','1',1,'Retail Sale Id 3370',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 17:24:19','',''),(3201,'21','227','1',1,'Retail Sale Id 3371',4993.20,0.00,0.00,6.57,0.00,'2022-07-04 17:33:56','',''),(3202,'21','227','1',1,'Retail Sale Id 3372',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 17:35:11','',''),(3203,'21','227','1',1,'Retail Sale Id 3373',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 17:38:25','',''),(3204,'21','227','1',1,'Retail Sale Id 3374',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 17:39:48','',''),(3205,'21','227','1',1,'Retail Sale Id 3375',4560.00,0.00,0.00,6.00,0.00,'2022-07-04 17:41:38','',''),(3206,'21','227','1',1,'Retail Sale Id 3376',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 17:43:14','',''),(3207,'21','227','1',1,'Retail Sale Id 3377',5996.40,0.00,0.00,7.89,0.00,'2022-07-04 17:44:05','',''),(3208,'21','227','1',1,'Retail Sale Id 3378',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 17:44:49','',''),(3209,'21','227','1',1,'Retail Sale Id 3379',1520.00,0.00,0.00,2.00,0.00,'2022-07-04 17:45:51','',''),(3210,'21','227','1',1,'Retail Sale Id 3379',1520.00,0.00,0.00,2.00,0.00,'2022-07-04 17:45:51','',''),(3211,'21','227','1',1,'Retail Sale Id 3380',3997.60,0.00,0.00,5.26,0.00,'2022-07-04 17:47:37','',''),(3212,'21','227','1',1,'Retail Sale Id 3381',3800.00,0.00,0.00,5.00,0.00,'2022-07-04 17:48:50','',''),(3213,'21','227','1',1,'Retail Sale Id 3382',2280.00,0.00,0.00,3.00,0.00,'2022-07-04 17:49:34','',''),(3214,'21','227','1',1,'Retail Sale Id 3383',1793.60,0.00,0.00,2.36,0.00,'2022-07-04 17:50:19','',''),(3215,'21','227','1',1,'Retail Sale Id 3384',1497.20,0.00,0.00,1.97,0.00,'2022-07-04 17:51:54','',''),(3216,'21','227','1',1,'Retail Sale Id 3385',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 16:39:56','',''),(3217,'21','227','1',1,'Retail Sale Id 3386',760.00,0.00,0.00,1.00,0.00,'2022-07-08 16:42:52','',''),(3218,'21','227','1',1,'Retail Sale Id 3387',7600.00,0.00,0.00,10.00,0.00,'2022-07-08 16:44:59','',''),(3219,'21','227','1',1,'Retail Sale Id 3388',6999.60,0.00,0.00,9.21,0.00,'2022-07-08 16:45:51','',''),(3220,'21','227','1',1,'Retail Sale Id 3389',1497.20,0.00,0.00,1.97,0.00,'2022-07-08 16:46:32','',''),(3221,'21','227','1',1,'Retail Sale Id 3390',2994.40,0.00,0.00,3.94,0.00,'2022-07-08 16:50:23','',''),(3222,'21','227','1',1,'Retail Sale Id 3391',5996.40,0.00,0.00,7.89,0.00,'2022-07-08 16:51:05','',''),(3223,'21','227','1',1,'Retail Sale Id 3392',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 16:51:45','',''),(3224,'21','227','1',1,'Retail Sale Id 3393',4750.00,0.00,0.00,6.25,0.00,'2022-07-08 16:52:58','',''),(3225,'21','227','1',1,'Retail Sale Id 3394',3997.60,0.00,0.00,5.26,0.00,'2022-07-08 17:02:03','',''),(3226,'21','227','1',1,'Retail Sale Id 3395',38000.00,0.00,0.00,50.00,0.00,'2022-07-08 17:04:17','',''),(3227,'21','227','1',1,'Retail Sale Id 3396',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:05:25','',''),(3228,'21','227','1',1,'Retail Sale Id 3397',6498.00,0.00,0.00,8.55,0.00,'2022-07-08 17:06:07','',''),(3229,'21','227','1',1,'Retail Sale Id 3398',798.00,0.00,0.00,1.05,0.00,'2022-07-08 17:06:42','',''),(3230,'21','227','1',1,'Retail Sale Id 3399',7600.00,0.00,0.00,10.00,0.00,'2022-07-08 17:07:23','',''),(3231,'21','227','1',1,'Retail Sale Id 3400',2280.00,0.00,0.00,3.00,0.00,'2022-07-08 17:07:59','',''),(3232,'21','227','1',1,'Retail Sale Id 3401',995.60,0.00,0.00,1.31,0.00,'2022-07-08 17:08:32','',''),(3233,'21','227','1',1,'Retail Sale Id 3402',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:09:55','',''),(3234,'21','227','1',1,'Retail Sale Id 3403',1793.60,0.00,0.00,2.36,0.00,'2022-07-08 17:12:12','',''),(3235,'21','227','1',1,'Retail Sale Id 3404',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:14:18','',''),(3236,'21','227','1',1,'Retail Sale Id 3406',995.60,0.00,0.00,1.31,0.00,'2022-07-08 17:15:09','',''),(3237,'21','227','1',1,'Retail Sale Id 3407',1497.20,0.00,0.00,1.97,0.00,'2022-07-08 17:15:57','',''),(3238,'21','227','1',1,'Retail Sale Id 3408',4993.20,0.00,0.00,6.57,0.00,'2022-07-08 17:16:36','',''),(3239,'21','227','1',1,'Retail Sale Id 3409',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:17:11','',''),(3240,'21','227','1',1,'Retail Sale Id 3410',798.00,0.00,0.00,1.05,0.00,'2022-07-08 17:18:22','',''),(3241,'21','227','1',1,'Retail Sale Id 3411',2492.80,0.00,0.00,3.28,0.00,'2022-07-08 17:19:08','',''),(3242,'21','227','1',1,'Retail Sale Id 3412',2492.80,0.00,0.00,3.28,0.00,'2022-07-08 17:21:11','',''),(3243,'21','227','1',1,'Retail Sale Id 3413',1998.80,0.00,0.00,2.63,0.00,'2022-07-08 17:23:06','',''),(3244,'21','227','1',1,'Retail Sale Id 3414',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:25:33','',''),(3245,'21','227','1',1,'Retail Sale Id 3415',1497.20,0.00,0.00,1.97,0.00,'2022-07-08 17:26:11','',''),(3246,'21','227','1',1,'Retail Sale Id 3416',2280.00,0.00,0.00,3.00,0.00,'2022-07-08 17:26:46','',''),(3247,'21','227','1',1,'Retail Sale Id 3417',995.60,0.00,0.00,1.31,0.00,'2022-07-08 17:27:16','',''),(3248,'21','227','1',1,'Retail Sale Id 3418',7600.00,0.00,0.00,10.00,0.00,'2022-07-08 17:28:19','',''),(3249,'21','227','1',1,'Retail Sale Id 3419',1497.20,0.00,0.00,1.97,0.00,'2022-07-08 17:29:29','',''),(3250,'21','227','1',1,'Retail Sale Id 3420',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:32:05','',''),(3251,'21','227','1',1,'Retail Sale Id 3421',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:33:07','',''),(3252,'21','227','1',1,'Retail Sale Id 3422',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:34:02','',''),(3253,'21','227','1',1,'Retail Sale Id 3423',995.60,0.00,0.00,1.31,0.00,'2022-07-08 17:34:43','',''),(3254,'21','227','1',1,'Retail Sale Id 3424',798.00,0.00,0.00,1.05,0.00,'2022-07-08 17:35:14','',''),(3255,'21','227','1',1,'Retail Sale Id 3425',2280.00,0.00,0.00,3.00,0.00,'2022-07-08 17:35:50','',''),(3256,'21','227','1',1,'Retail Sale Id 3426',3800.00,0.00,0.00,5.00,0.00,'2022-07-08 17:36:42','',''),(3257,'21','227','1',1,'Retail Sale Id 3427',5320.00,0.00,0.00,7.00,0.00,'2022-07-08 17:39:14','',''),(3258,'21','227','1',1,'Retail Sale Id 3428',1497.20,0.00,0.00,1.97,0.00,'2022-07-08 17:39:55','',''),(3259,'21','227','1',1,'Retail Sale Id 3429',995.60,0.00,0.00,1.31,0.00,'2022-07-08 17:44:11','',''),(3260,'21','227','1',1,'Retail Sale Id 3430',1998.80,0.00,0.00,2.63,0.00,'2022-07-08 17:46:08','',''),(3261,'21','227','1',1,'Retail Sale Id 3431',4993.20,0.00,0.00,6.57,0.00,'2022-07-08 17:49:24','',''),(3262,'21','227','1',1,'Retail Sale Id 3432',9500.00,0.00,0.00,12.50,0.00,'2022-07-08 17:53:42','',''),(3263,'21','227','1',1,'Retail Sale Id 3433',4993.20,0.00,0.00,6.57,0.00,'2022-07-08 18:02:05','',''),(3264,'21','227','1',1,'Retail Sale Id 3434',3997.60,0.00,0.00,5.26,0.00,'2022-07-08 18:07:27','',''),(3265,'21','227','1',1,'Retail Sale Id 3405',995.60,0.00,0.00,1.31,0.00,'2022-07-09 13:36:28','',''),(3266,'21','227','1',1,'Retail Sale Id 3435',1497.20,0.00,0.00,1.97,0.00,'2022-07-10 09:09:20','',''),(3267,'21','227','1',1,'Retail Sale Id 3436',1998.80,0.00,0.00,2.63,0.00,'2022-07-10 09:21:14','',''),(3268,'21','227','1',1,'Retail Sale Id 3437',798.00,0.00,0.00,1.05,0.00,'2022-07-10 09:21:49','',''),(3269,'21','227','1',1,'Retail Sale Id 3438',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 09:22:24','',''),(3270,'21','227','1',1,'Retail Sale Id 3439',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 09:40:59','',''),(3271,'21','227','1',1,'Retail Sale Id 3440',2280.00,0.00,0.00,3.00,0.00,'2022-07-10 10:53:44','',''),(3272,'21','227','1',1,'Retail Sale Id 3441',1497.20,0.00,0.00,1.97,0.00,'2022-07-10 10:56:33','',''),(3273,'21','227','1',1,'Retail Sale Id 3442',1193.20,0.00,0.00,1.57,0.00,'2022-07-10 10:58:01','',''),(3274,'21','227','1',1,'Retail Sale Id 3443',2280.00,0.00,0.00,3.00,0.00,'2022-07-10 11:25:26','',''),(3275,'21','227','1',1,'Retail Sale Id 3444',3040.00,0.00,0.00,4.00,0.00,'2022-07-10 11:27:15','',''),(3276,'21','227','1',1,'Retail Sale Id 3445',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:33:34','',''),(3277,'21','227','1',1,'Retail Sale Id 3446',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:34:36','',''),(3278,'21','227','1',1,'Retail Sale Id 3447',7600.00,0.00,0.00,10.00,0.00,'2022-07-10 11:36:53','',''),(3279,'21','227','1',1,'Retail Sale Id 3448',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:40:55','',''),(3280,'21','227','1',1,'Retail Sale Id 3449',995.60,0.00,0.00,1.31,0.00,'2022-07-10 11:51:25','',''),(3281,'21','227','1',1,'Retail Sale Id 3450',4993.20,0.00,0.00,6.57,0.00,'2022-07-10 11:52:16','',''),(3282,'21','227','1',1,'Retail Sale Id 3451',7600.00,0.00,0.00,10.00,0.00,'2022-07-10 11:53:08','',''),(3283,'21','227','1',1,'Retail Sale Id 3452',995.60,0.00,0.00,1.31,0.00,'2022-07-10 11:57:08','',''),(3284,'21','227','1',1,'Retail Sale Id 3453',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:59:24','',''),(3285,'21','227','1',1,'Retail Sale Id 3454',4560.00,0.00,0.00,6.00,0.00,'2022-07-10 12:00:17','',''),(3286,'21','227','1',1,'Retail Sale Id 3455',2994.40,0.00,0.00,3.94,0.00,'2022-07-10 12:01:21','',''),(3287,'21','227','1',1,'Retail Sale Id 3456',4560.00,0.00,0.00,6.00,0.00,'2022-07-10 12:02:31','',''),(3288,'21','227','1',1,'Retail Sale Id 3457',1520.00,0.00,0.00,2.00,0.00,'2022-07-10 12:03:15','',''),(3289,'21','227','1',1,'Retail Sale Id 3458',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 12:06:02','',''),(3290,'21','227','1',1,'Retail Sale Id 3459',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 12:07:25','',''),(3291,'21','227','1',1,'Retail Sale Id 3460',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 12:09:30','',''),(3292,'21','227','1',1,'Retail Sale Id 3461',2492.80,0.00,0.00,3.28,0.00,'2022-07-10 12:25:33','',''),(3293,'21','227','1',1,'Retail Sale Id 3462',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 12:27:47','',''),(3294,'21','227','1',1,'Retail Sale Id 3463',3800.00,0.00,0.00,5.00,0.00,'2022-07-10 13:29:04','',''),(3295,'21','227','1',1,'Retail Sale Id 3464',38000.00,0.00,0.00,50.00,0.00,'2022-07-11 12:33:04','',''),(3296,'21','227','1',1,'Retail Sale Id 3464',38000.00,0.00,0.00,50.00,0.00,'2022-07-11 12:33:04','',''),(3297,'21','227','1',1,'Retail Sale Id 3465',23286.40,0.00,0.00,30.64,0.00,'2022-07-11 12:35:04','',''),(3298,'21','227','1',1,'Retail Sale Id 3465',30400.00,0.00,0.00,40.00,0.00,'2022-07-11 12:35:04','',''),(3299,'21','227','1',1,'Retail Sale Id 3466',38000.00,0.00,0.00,50.00,0.00,'2022-07-11 12:37:36','',''),(3300,'21','227','1',1,'Retail Sale Id 3466',45600.00,0.00,0.00,60.00,0.00,'2022-07-11 12:37:36','',''),(3301,'21','227','1',1,'Retail Sale Id 3467',17487.60,0.00,0.00,23.01,0.00,'2022-07-11 12:39:02','',''),(3302,'21','227','1',1,'Retail Sale Id 3468',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 09:38:21','',''),(3303,'21','227','1',1,'Retail Sale Id 3469',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 09:39:12','',''),(3304,'21','227','1',1,'Return of Retail Sale Id 3469',0.00,1497.20,1.97,0.00,0.00,'2022-07-15 12:20:51','',''),(3305,'21','227','1',1,'Return of Retail Sale Id 3468',0.00,9500.00,12.50,0.00,0.00,'2022-07-15 12:21:44','',''),(3306,'21','227','1',1,'Retail Sale Id 3470',1998.80,0.00,0.00,2.63,0.00,'2022-07-15 13:38:38','',''),(3307,'21','227','1',1,'Retail Sale Id 3470',1998.80,0.00,0.00,2.63,0.00,'2022-07-15 13:38:38','',''),(3308,'21','227','1',1,'Retail Sale Id 3470',2994.40,0.00,0.00,3.94,0.00,'2022-07-15 13:38:38','',''),(3309,'21','227','1',1,'Retail Sale Id 3471',995.60,0.00,0.00,1.31,0.00,'2022-07-15 13:41:22','',''),(3310,'21','227','1',1,'Retail Sale Id 3471',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 13:41:22','',''),(3311,'21','227','1',1,'Retail Sale Id 3471',2994.40,0.00,0.00,3.94,0.00,'2022-07-15 13:41:22','',''),(3312,'21','227','1',1,'Retail Sale Id 3471',2994.40,0.00,0.00,3.94,0.00,'2022-07-15 13:41:22','',''),(3313,'21','227','1',1,'Retail Sale Id 3471',2994.40,0.00,0.00,3.94,0.00,'2022-07-15 13:41:22','',''),(3314,'21','227','1',1,'Retail Sale Id 3471',4993.20,0.00,0.00,6.57,0.00,'2022-07-15 13:41:22','',''),(3315,'21','227','1',1,'Retail Sale Id 3471',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 13:41:22','',''),(3316,'21','227','1',1,'Retail Sale Id 3472',896.80,0.00,0.00,1.18,0.00,'2022-07-15 13:42:46','',''),(3317,'21','227','1',1,'Retail Sale Id 3472',2492.80,0.00,0.00,3.28,0.00,'2022-07-15 13:42:46','',''),(3318,'21','227','1',1,'Retail Sale Id 3472',7600.00,0.00,0.00,10.00,0.00,'2022-07-15 13:42:46','',''),(3319,'21','227','1',1,'Retail Sale Id 3472',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 13:42:46','',''),(3320,'21','227','1',1,'Retail Sale Id 3472',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:42:46','',''),(3321,'21','227','1',1,'Retail Sale Id 3473',950.00,0.00,0.00,1.25,0.00,'2022-07-15 13:43:49','',''),(3322,'21','227','1',1,'Retail Sale Id 3473',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 13:43:49','',''),(3323,'21','227','1',1,'Retail Sale Id 3473',3496.00,0.00,0.00,4.60,0.00,'2022-07-15 13:43:49','',''),(3324,'21','227','1',1,'Retail Sale Id 3473',3997.60,0.00,0.00,5.26,0.00,'2022-07-15 13:43:49','',''),(3325,'21','227','1',1,'Retail Sale Id 3473',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 13:43:49','',''),(3326,'21','227','1',1,'Retail Sale Id 3474',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 13:44:54','',''),(3327,'21','227','1',1,'Retail Sale Id 3475',18407.20,0.00,0.00,24.22,0.00,'2022-07-15 13:45:24','',''),(3328,'21','227','1',1,'Retail Sale Id 3476',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:45:50','',''),(3329,'21','227','1',1,'Retail Sale Id 3477',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:46:21','',''),(3330,'21','227','1',1,'Retail Sale Id 3478',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:46:45','',''),(3331,'21','227','1',1,'Retail Sale Id 3479',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:47:14','',''),(3332,'21','227','1',1,'Retail Sale Id 3480',32505.20,0.00,0.00,42.77,0.00,'2022-07-15 13:48:05','',''),(3333,'21','227','1',1,'Retail Sale Id 3481',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:48:30','',''),(3334,'21','227','1',1,'Retail Sale Id 3482',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:48:56','',''),(3335,'21','227','1',1,'Retail Sale Id 3483',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:49:21','',''),(3336,'21','227','1',1,'Retail Sale Id 3484',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 13:49:41','',''),(3337,'21','227','1',1,'Retail Sale Id 3485',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 13:50:13','',''),(3338,'21','227','1',1,'Retail Sale Id 3486',1998.80,0.00,0.00,2.63,0.00,'2022-07-15 13:51:17','',''),(3339,'21','227','1',1,'Retail Sale Id 3486',3800.00,0.00,0.00,5.00,0.00,'2022-07-15 13:51:17','',''),(3340,'21','227','1',1,'Retail Sale Id 3486',4993.20,0.00,0.00,6.57,0.00,'2022-07-15 13:51:17','',''),(3341,'21','227','1',1,'Retail Sale Id 3486',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 13:51:17','',''),(3342,'21','227','1',1,'Retail Sale Id 3487',3997.60,0.00,0.00,5.26,0.00,'2022-07-15 13:52:27','',''),(3343,'21','227','1',1,'Retail Sale Id 3487',4560.00,0.00,0.00,6.00,0.00,'2022-07-15 13:52:27','',''),(3344,'21','227','1',1,'Retail Sale Id 3487',7600.00,0.00,0.00,10.00,0.00,'2022-07-15 13:52:27','',''),(3345,'21','227','1',1,'Retail Sale Id 3487',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 13:52:27','',''),(3346,'21','227','1',1,'Retail Sale Id 3487',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 13:52:27','',''),(3347,'21','227','1',1,'Retail Sale Id 3488',1900.00,0.00,0.00,2.50,0.00,'2022-07-15 13:53:37','',''),(3348,'21','227','1',1,'Retail Sale Id 3488',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 13:53:37','',''),(3349,'21','227','1',1,'Retail Sale Id 3488',3800.00,0.00,0.00,5.00,0.00,'2022-07-15 13:53:37','',''),(3350,'21','227','1',1,'Retail Sale Id 3488',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 13:53:37','',''),(3351,'21','227','1',1,'Retail Sale Id 3489',4560.00,0.00,0.00,6.00,0.00,'2022-07-15 13:54:21','',''),(3352,'21','227','1',1,'Retail Sale Id 3489',7995.20,0.00,0.00,10.52,0.00,'2022-07-15 13:54:21','',''),(3353,'21','227','1',1,'Retail Sale Id 3489',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 13:54:21','',''),(3354,'21','227','1',1,'Retail Sale Id 3490',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 13:59:11','',''),(3355,'21','227','1',1,'Retail Sale Id 3490',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 13:59:11','',''),(3356,'21','227','1',1,'Retail Sale Id 3490',4993.20,0.00,0.00,6.57,0.00,'2022-07-15 13:59:11','',''),(3357,'21','227','1',1,'Retail Sale Id 3490',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 13:59:11','',''),(3358,'21','227','1',1,'Retail Sale Id 3490',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 13:59:11','',''),(3359,'21','227','1',1,'Retail Sale Id 3491',494.00,0.00,0.00,0.65,0.00,'2022-07-15 14:00:17','',''),(3360,'21','227','1',1,'Retail Sale Id 3491',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 14:00:17','',''),(3361,'21','227','1',1,'Retail Sale Id 3491',3800.00,0.00,0.00,5.00,0.00,'2022-07-15 14:00:17','',''),(3362,'21','227','1',1,'Retail Sale Id 3491',3997.60,0.00,0.00,5.26,0.00,'2022-07-15 14:00:17','',''),(3363,'21','227','1',1,'Retail Sale Id 3491',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:00:17','',''),(3364,'21','227','1',1,'Retail Sale Id 3492',48092.80,0.00,0.00,63.28,0.00,'2022-07-15 14:00:53','',''),(3365,'21','227','1',1,'Retail Sale Id 3493',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:01:18','',''),(3366,'21','227','1',1,'Retail Sale Id 3494',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:01:37','',''),(3367,'21','227','1',1,'Retail Sale Id 3495',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:02:04','',''),(3368,'21','227','1',1,'Retail Sale Id 3496',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:02:39','',''),(3369,'21','227','1',1,'Retail Sale Id 3497',1428.80,0.00,0.00,1.88,0.00,'2022-07-15 14:06:44','',''),(3370,'21','227','1',1,'Retail Sale Id 3498',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:07:14','',''),(3371,'21','227','1',1,'Retail Sale Id 3499',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:07:33','',''),(3372,'21','227','1',1,'Retail Sale Id 3500',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:07:59','',''),(3373,'21','227','1',1,'Retail Sale Id 3501',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:08:44','',''),(3374,'21','227','1',1,'Retail Sale Id 3502',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:09:11','',''),(3375,'21','227','1',1,'Retail Sale Id 3503',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:09:44','',''),(3376,'21','227','1',1,'Retail Sale Id 3504',1162.80,0.00,0.00,1.53,0.00,'2022-07-15 14:10:46','',''),(3377,'21','227','1',1,'Retail Sale Id 3505',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:11:23','',''),(3378,'21','227','1',1,'Retail Sale Id 3506',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:11:43','',''),(3379,'21','227','1',1,'Retail Sale Id 3507',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:12:14','',''),(3380,'21','227','1',1,'Retail Sale Id 3508',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:12:39','',''),(3381,'21','227','1',1,'Retail Sale Id 3509',2964.00,0.00,0.00,3.90,0.00,'2022-07-15 14:18:11','',''),(3382,'21','227','1',1,'Retail Sale Id 3509',3997.60,0.00,0.00,5.26,0.00,'2022-07-15 14:18:11','',''),(3383,'21','227','1',1,'Retail Sale Id 3509',4993.20,0.00,0.00,6.57,0.00,'2022-07-15 14:18:11','',''),(3384,'21','227','1',1,'Retail Sale Id 3509',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:18:11','',''),(3385,'21','227','1',1,'Retail Sale Id 3509',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:18:11','',''),(3386,'21','227','1',1,'Retail Sale Id 3509',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:18:11','',''),(3387,'21','227','1',1,'Retail Sale Id 3510',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 14:19:18','',''),(3388,'21','227','1',1,'Retail Sale Id 3510',3997.60,0.00,0.00,5.26,0.00,'2022-07-15 14:19:18','',''),(3389,'21','227','1',1,'Retail Sale Id 3510',4560.00,0.00,0.00,6.00,0.00,'2022-07-15 14:19:18','',''),(3390,'21','227','1',1,'Retail Sale Id 3510',4993.20,0.00,0.00,6.57,0.00,'2022-07-15 14:19:18','',''),(3391,'21','227','1',1,'Retail Sale Id 3510',7995.20,0.00,0.00,10.52,0.00,'2022-07-15 14:19:18','',''),(3392,'21','227','1',1,'Retail Sale Id 3511',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 14:20:21','',''),(3393,'21','227','1',1,'Retail Sale Id 3511',4499.20,0.00,0.00,5.92,0.00,'2022-07-15 14:20:21','',''),(3394,'21','227','1',1,'Retail Sale Id 3511',7600.00,0.00,0.00,10.00,0.00,'2022-07-15 14:20:21','',''),(3395,'21','227','1',1,'Retail Sale Id 3511',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:20:21','',''),(3396,'21','227','1',1,'Retail Sale Id 3512',1900.00,0.00,0.00,2.50,0.00,'2022-07-15 14:21:06','',''),(3397,'21','227','1',1,'Retail Sale Id 3512',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 14:21:06','',''),(3398,'21','227','1',1,'Retail Sale Id 3512',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:21:06','',''),(3399,'21','227','1',1,'Retail Sale Id 3513',53686.40,0.00,0.00,70.64,0.00,'2022-07-15 14:21:39','',''),(3400,'21','227','1',1,'Retail Sale Id 3514',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:22:02','',''),(3401,'21','227','1',1,'Retail Sale Id 3515',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:22:25','',''),(3402,'21','227','1',1,'Retail Sale Id 3516',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:22:51','',''),(3403,'21','227','1',1,'Retail Sale Id 3516',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:22:51','',''),(3404,'21','227','1',1,'Retail Sale Id 3517',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:23:21','',''),(3405,'21','227','1',1,'Retail Sale Id 3518',12920.00,0.00,0.00,17.00,0.00,'2022-07-15 14:27:00','',''),(3406,'21','227','1',1,'Retail Sale Id 3519',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 14:27:29','',''),(3407,'21','227','1',1,'Retail Sale Id 3520',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 14:27:59','',''),(3408,'21','227','1',1,'Retail Sale Id 3521',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:28:42','',''),(3409,'21','227','1',1,'Retail Sale Id 3521',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:28:42','',''),(3410,'21','227','1',1,'Retail Sale Id 3521',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:28:42','',''),(3411,'21','227','1',1,'Retail Sale Id 3521',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:28:42','',''),(3412,'21','227','1',1,'Retail Sale Id 3522',34511.60,0.00,0.00,45.41,0.00,'2022-07-15 14:31:43','',''),(3413,'21','227','1',1,'Retail Sale Id 3523',15200.00,0.00,0.00,20.00,0.00,'2022-07-15 14:32:18','',''),(3414,'21','227','1',1,'Retail Sale Id 3523',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 14:32:18','',''),(3415,'21','227','1',1,'Retail Sale Id 3524',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:32:49','',''),(3416,'21','227','1',1,'Retail Sale Id 3524',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:32:49','',''),(3417,'21','227','1',1,'Retail Sale Id 3525',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:33:17','',''),(3418,'21','227','1',1,'Retail Sale Id 3525',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 14:33:17','',''),(3419,'21','227','1',1,'Retail Sale Id 3526',1520.00,0.00,0.00,2.00,0.00,'2022-07-15 14:35:05','',''),(3420,'21','227','1',1,'Retail Sale Id 3526',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 14:35:05','',''),(3421,'21','227','1',1,'Retail Sale Id 3526',2994.40,0.00,0.00,3.94,0.00,'2022-07-15 14:35:05','',''),(3422,'21','227','1',1,'Retail Sale Id 3526',3040.00,0.00,0.00,4.00,0.00,'2022-07-15 14:35:05','',''),(3423,'21','227','1',1,'Retail Sale Id 3526',4560.00,0.00,0.00,6.00,0.00,'2022-07-15 14:35:05','',''),(3424,'21','227','1',1,'Retail Sale Id 3526',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:35:05','',''),(3425,'21','227','1',1,'Retail Sale Id 3527',3800.00,0.00,0.00,5.00,0.00,'2022-07-15 14:37:05','',''),(3426,'21','227','1',1,'Retail Sale Id 3527',3800.00,0.00,0.00,5.00,0.00,'2022-07-15 14:37:05','',''),(3427,'21','227','1',1,'Retail Sale Id 3527',4940.00,0.00,0.00,6.50,0.00,'2022-07-15 14:37:05','',''),(3428,'21','227','1',1,'Retail Sale Id 3527',4993.20,0.00,0.00,6.57,0.00,'2022-07-15 14:37:05','',''),(3429,'21','227','1',1,'Retail Sale Id 3527',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:37:05','',''),(3430,'21','227','1',1,'Retail Sale Id 3527',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 14:37:05','',''),(3431,'21','227','1',1,'Retail Sale Id 3528',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 14:47:00','',''),(3432,'21','227','1',1,'Retail Sale Id 3529',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 14:51:13','',''),(3433,'21','227','1',1,'Retail Sale Id 3530',1998.80,0.00,0.00,2.63,0.00,'2022-07-15 14:53:32','',''),(3434,'21','227','1',1,'Retail Sale Id 3531',1140.00,0.00,0.00,1.50,0.00,'2022-07-15 14:56:02','',''),(3435,'21','227','1',1,'Retail Sale Id 3532',1520.00,0.00,0.00,2.00,0.00,'2022-07-15 14:56:32','',''),(3436,'21','227','1',1,'Retail Sale Id 3533',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 15:03:49','',''),(3437,'21','227','1',1,'Retail Sale Id 3533',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 15:03:49','',''),(3438,'21','227','1',1,'Retail Sale Id 3534',2280.00,0.00,0.00,3.00,0.00,'2022-07-15 15:05:16','',''),(3439,'21','227','1',1,'Retail Sale Id 3534',3800.00,0.00,0.00,5.00,0.00,'2022-07-15 15:05:16','',''),(3440,'21','227','1',1,'Retail Sale Id 3534',4993.20,0.00,0.00,6.57,0.00,'2022-07-15 15:05:16','',''),(3441,'21','227','1',1,'Retail Sale Id 3535',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 15:06:52','',''),(3442,'21','227','1',1,'Retail Sale Id 3535',1953.20,0.00,0.00,2.57,0.00,'2022-07-15 15:06:52','',''),(3443,'21','227','1',1,'Retail Sale Id 3535',1998.80,0.00,0.00,2.63,0.00,'2022-07-15 15:06:52','',''),(3444,'21','227','1',1,'Retail Sale Id 3535',7600.00,0.00,0.00,10.00,0.00,'2022-07-15 15:06:52','',''),(3445,'21','227','1',1,'Retail Sale Id 3535',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 15:06:52','',''),(3446,'21','227','1',1,'Retail Sale Id 3536',1140.00,0.00,0.00,1.50,0.00,'2022-07-15 15:09:01','',''),(3447,'21','227','1',1,'Retail Sale Id 3536',4560.00,0.00,0.00,6.00,0.00,'2022-07-15 15:09:01','',''),(3448,'21','227','1',1,'Retail Sale Id 3536',4560.00,0.00,0.00,6.00,0.00,'2022-07-15 15:09:01','',''),(3449,'21','227','1',1,'Retail Sale Id 3536',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 15:09:01','',''),(3450,'21','227','1',1,'Retail Sale Id 3537',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 15:10:32','',''),(3451,'21','227','1',1,'Retail Sale Id 3537',3997.60,0.00,0.00,5.26,0.00,'2022-07-15 15:10:32','',''),(3452,'21','227','1',1,'Retail Sale Id 3537',7600.00,0.00,0.00,10.00,0.00,'2022-07-15 15:10:32','',''),(3453,'21','227','1',1,'Retail Sale Id 3537',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 15:10:32','',''),(3454,'21','227','1',1,'Retail Sale Id 3538',23803.20,0.00,0.00,31.32,0.00,'2022-07-15 15:12:45','',''),(3455,'21','227','1',1,'Retail Sale Id 3539',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 21:28:12','',''),(3456,'21','227','1',1,'Retail Sale Id 3541',4993.20,0.00,0.00,6.57,0.00,'2022-07-15 21:30:55','',''),(3457,'21','227','1',1,'Retail Sale Id 3542',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 21:34:44','',''),(3458,'21','227','1',1,'Retail Sale Id 3543',7600.00,0.00,0.00,10.00,0.00,'2022-07-15 21:35:35','',''),(3459,'21','227','1',1,'Retail Sale Id 3544',7493.60,0.00,0.00,9.86,0.00,'2022-07-15 21:36:19','',''),(3460,'21','227','1',1,'Retail Sale Id 3545',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 21:37:47','',''),(3461,'21','227','1',1,'Retail Sale Id 3546',4499.20,0.00,0.00,5.92,0.00,'2022-07-15 21:38:31','',''),(3462,'21','227','1',1,'Retail Sale Id 3547',5320.00,0.00,0.00,7.00,0.00,'2022-07-15 21:39:30','',''),(3463,'21','227','1',1,'Retail Sale Id 3548',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 21:40:42','',''),(3464,'21','227','1',1,'Retail Sale Id 3549',798.00,0.00,0.00,1.05,0.00,'2022-07-15 21:41:24','',''),(3465,'21','227','1',1,'Retail Sale Id 3550',7600.00,0.00,0.00,10.00,0.00,'2022-07-15 21:42:56','',''),(3466,'21','227','1',1,'Retail Sale Id 3551',760.00,0.00,0.00,1.00,0.00,'2022-07-15 21:48:17','',''),(3467,'21','227','1',1,'Retail Sale Id 3552',1497.20,0.00,0.00,1.97,0.00,'2022-07-15 21:49:05','',''),(3468,'21','227','1',1,'Retail Sale Id 3554',11400.00,0.00,0.00,15.00,0.00,'2022-07-15 21:49:52','',''),(3469,'21','227','1',1,'Retail Sale Id 3555',995.60,0.00,0.00,1.31,0.00,'2022-07-15 21:50:31','',''),(3470,'21','227','1',1,'Return of Retail Sale Id 3550',0.00,7600.00,10.00,0.00,0.00,'2022-07-15 21:55:32','',''),(3471,'21','227','1',1,'Retail Sale Id 3553',11400.00,0.00,0.00,15.00,0.00,'2022-07-15 21:57:59','',''),(3472,'21','227','1',1,'Retail Sale Id 3556',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 22:02:12','',''),(3473,'21','227','1',1,'Retail Sale Id 3557',91200.00,0.00,0.00,120.00,0.00,'2022-07-15 22:03:05','',''),(3474,'21','227','1',1,'Retail Sale Id 3558',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 11:58:25','',''),(3475,'21','227','1',1,'Retail Sale Id 3559',7600.00,0.00,0.00,10.00,0.00,'2022-07-16 11:59:58','',''),(3476,'21','227','1',1,'Retail Sale Id 3560',1497.20,0.00,0.00,1.97,0.00,'2022-07-16 12:01:04','',''),(3477,'21','227','1',1,'Retail Sale Id 3561',6498.00,0.00,0.00,8.55,0.00,'2022-07-16 12:03:04','',''),(3478,'21','227','1',1,'Retail Sale Id 3562',4750.00,0.00,0.00,6.25,0.00,'2022-07-16 12:03:54','',''),(3479,'21','227','1',1,'Retail Sale Id 3563',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 12:05:00','',''),(3480,'21','227','1',1,'Retail Sale Id 3564',798.00,0.00,0.00,1.05,0.00,'2022-07-16 12:05:40','',''),(3481,'21','227','1',1,'Retail Sale Id 3565',3693.60,0.00,0.00,4.86,0.00,'2022-07-16 12:08:22','',''),(3482,'21','227','1',1,'Retail Sale Id 3566',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 12:09:10','',''),(3483,'21','227','1',1,'Retail Sale Id 3567',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 12:09:54','',''),(3484,'21','227','1',1,'Retail Sale Id 3568',11400.00,0.00,0.00,15.00,0.00,'2022-07-16 12:10:47','',''),(3485,'21','227','1',1,'Retail Sale Id 3569',2280.00,0.00,0.00,3.00,0.00,'2022-07-16 12:11:57','',''),(3486,'21','227','1',1,'Retail Sale Id 3570',38000.00,0.00,0.00,50.00,0.00,'2022-07-16 12:12:49','',''),(3487,'21','227','1',1,'Retail Sale Id 3571',995.60,0.00,0.00,1.31,0.00,'2022-07-16 12:15:47','',''),(3488,'21','227','1',1,'Retail Sale Id 3572',5996.40,0.00,0.00,7.89,0.00,'2022-07-16 12:18:05','',''),(3489,'21','227','1',1,'Retail Sale Id 3573',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 12:18:53','',''),(3490,'21','227','1',1,'Retail Sale Id 3574',4499.20,0.00,0.00,5.92,0.00,'2022-07-16 12:20:00','',''),(3491,'21','227','1',1,'Retail Sale Id 3575',1900.00,0.00,0.00,2.50,0.00,'2022-07-16 12:20:47','',''),(3492,'21','227','1',1,'Retail Sale Id 3576',6999.60,0.00,0.00,9.21,0.00,'2022-07-16 12:22:12','',''),(3493,'21','227','1',1,'Retail Sale Id 3577',5996.40,0.00,0.00,7.89,0.00,'2022-07-16 12:24:24','',''),(3494,'21','227','1',1,'Retail Sale Id 3578',1998.80,0.00,0.00,2.63,0.00,'2022-07-16 12:25:40','',''),(3495,'21','227','1',1,'Retail Sale Id 3579',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 12:26:52','',''),(3496,'21','227','1',1,'Retail Sale Id 3580',7600.00,0.00,0.00,10.00,0.00,'2022-07-16 12:29:37','',''),(3497,'21','227','1',1,'Retail Sale Id 3581',6498.00,0.00,0.00,8.55,0.00,'2022-07-16 12:31:28','',''),(3498,'21','227','1',1,'Retail Sale Id 3582',3739.20,0.00,0.00,4.92,0.00,'2022-07-16 12:32:51','',''),(3499,'21','227','1',1,'Retail Sale Id 3583',63080.00,0.00,0.00,83.00,0.00,'2022-07-16 12:33:49','',''),(3500,'21','227','1',1,'Retail Sale Id 3584',9120.00,0.00,0.00,12.00,0.00,'2022-07-16 12:36:47','',''),(3501,'21','227','1',1,'Retail Sale Id 3585',4560.00,0.00,0.00,6.00,0.00,'2022-07-16 12:37:40','',''),(3502,'21','227','1',1,'Retail Sale Id 3586',1497.20,0.00,0.00,1.97,0.00,'2022-07-16 12:38:27','',''),(3503,'21','227','1',1,'Retail Sale Id 3587',4195.20,0.00,0.00,5.52,0.00,'2022-07-16 12:39:33','',''),(3504,'21','227','1',1,'Retail Sale Id 3589',6080.00,0.00,0.00,8.00,0.00,'2022-07-16 12:42:02','',''),(3505,'21','227','1',1,'Retail Sale Id 3590',19000.00,0.00,0.00,25.00,0.00,'2022-07-16 12:43:54','',''),(3506,'21','227','1',1,'Retail Sale Id 3588',6080.00,0.00,0.00,8.00,0.00,'2022-07-16 12:44:53','',''),(3507,'21','227','1',1,'Retail Sale Id 3591',1497.20,0.00,0.00,1.97,0.00,'2022-07-16 12:46:02','',''),(3508,'21','227','1',1,'Retail Sale Id 3592',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 12:47:18','',''),(3509,'21','227','1',1,'Retail Sale Id 3593',7600.00,0.00,0.00,10.00,0.00,'2022-07-16 12:48:08','',''),(3510,'21','227','1',1,'Retail Sale Id 3594',7600.00,0.00,0.00,10.00,0.00,'2022-07-16 12:49:15','',''),(3511,'21','227','1',1,'Retail Sale Id 3595',15200.00,0.00,0.00,20.00,0.00,'2022-07-16 12:50:23','',''),(3512,'21','227','1',1,'Retail Sale Id 3596',4142.00,0.00,0.00,5.45,0.00,'2022-07-16 12:53:15','',''),(3513,'21','227','1',1,'Retail Sale Id 3597',7600.00,0.00,0.00,10.00,0.00,'2022-07-16 12:54:13','',''),(3514,'21','227','1',1,'Retail Sale Id 3598',1497.20,0.00,0.00,1.97,0.00,'2022-07-16 15:42:09','',''),(3515,'21','227','1',1,'Retail Sale Id 3599',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:45:23','',''),(3516,'21','227','1',1,'Retail Sale Id 3600',7600.00,0.00,0.00,10.00,0.00,'2022-07-16 15:46:50','',''),(3517,'21','227','1',1,'Retail Sale Id 3601',5434.00,0.00,0.00,7.15,0.00,'2022-07-16 15:48:10','',''),(3518,'21','227','1',1,'Retail Sale Id 3602',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:49:02','',''),(3519,'21','227','1',1,'Retail Sale Id 3603',798.00,0.00,0.00,1.05,0.00,'2022-07-16 15:49:59','',''),(3520,'21','227','1',1,'Retail Sale Id 3604',4993.20,0.00,0.00,6.57,0.00,'2022-07-16 16:05:13','',''),(3521,'21','227','1',1,'Retail Sale Id 3605',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 16:06:03','',''),(3522,'21','227','1',1,'Retail Sale Id 3606',7600.00,0.00,0.00,10.00,0.00,'2022-07-16 16:06:57','',''),(3523,'21','227','1',1,'Retail Sale Id 3607',3800.00,0.00,0.00,5.00,0.00,'2022-07-16 16:07:47','',''),(3524,'21','227','1',1,'Retail Sale Id 3608',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 16:08:29','',''),(3525,'21','227','1',1,'Retail Sale Id 3609',4993.20,0.00,0.00,6.57,0.00,'2022-07-16 16:10:06','',''),(3526,'21','227','1',1,'Retail Sale Id 3610',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 16:10:47','',''),(3527,'21','227','1',1,'Retail Sale Id 3611',798.00,0.00,0.00,1.05,0.00,'2022-07-16 16:11:31','',''),(3528,'21','227','1',1,'Retail Sale Id 3612',995.60,0.00,0.00,1.31,0.00,'2022-07-16 16:12:12','',''),(3529,'21','227','1',1,'Retail Sale Id 3613',3997.60,0.00,0.00,5.26,0.00,'2022-07-16 16:13:01','',''),(3530,'21','227','1',1,'Retail Sale Id 3614',995.60,0.00,0.00,1.31,0.00,'2022-07-16 16:13:42','',''),(3531,'21','227','1',1,'Retail Sale Id 3615',3040.00,0.00,0.00,4.00,0.00,'2022-07-16 16:14:35','',''),(3532,'21','227','1',1,'Retail Sale Id 3616',760.00,0.00,0.00,1.00,0.00,'2022-07-16 16:15:27','',''),(3533,'21','227','1',1,'Retail Sale Id 3617',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 16:17:55','',''),(3534,'21','227','1',1,'Retail Sale Id 3618',34200.00,0.00,0.00,45.00,0.00,'2022-07-16 16:18:47','',''),(3535,'21','227','1',1,'Retail Sale Id 3619',2280.00,0.00,0.00,3.00,0.00,'2022-07-16 16:19:40','',''),(3536,'21','227','1',1,'Retail Sale Id 3620',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 16:20:44','',''),(3537,'21','227','1',1,'Retail Sale Id 3621',19000.00,0.00,0.00,25.00,0.00,'2022-07-16 16:21:40','',''),(3538,'21','227','1',1,'Retail Sale Id 3622',995.60,0.00,0.00,1.31,0.00,'2022-07-16 16:22:52','',''),(3539,'21','227','1',1,'Retail Sale Id 3623',38000.00,0.00,0.00,50.00,0.00,'2022-07-16 16:23:40','',''),(3540,'21','227','1',1,'Retail Sale Id 3624',760.00,0.00,0.00,1.00,0.00,'2022-07-16 16:25:32','',''),(3541,'21','227','1',1,'Retail Sale Id 3625',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 16:26:19','',''),(3542,'21','227','1',1,'Retail Sale Id 3626',760.00,0.00,0.00,1.00,0.00,'2022-07-16 17:23:21','',''),(3543,'21','227','1',1,'Retail Sale Id 3627',4750.00,0.00,0.00,6.25,0.00,'2022-07-16 17:24:19','',''),(3544,'21','227','1',1,'Retail Sale Id 3628',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 17:58:00','',''),(3545,'21','227','1',1,'Retail Sale Id 3629',7600.00,0.00,0.00,10.00,0.00,'2022-07-16 17:58:43','',''),(3546,'21','227','1',1,'Retail Sale Id 3630',15200.00,0.00,0.00,20.00,0.00,'2022-07-16 17:59:49','',''),(3547,'21','227','1',1,'Retail Sale Id 3631',995.60,0.00,0.00,1.31,0.00,'2022-07-16 18:00:59','',''),(3548,'21','227','1',1,'Retail Sale Id 3632',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 18:01:57','',''),(3549,'21','227','1',1,'Retail Sale Id 3633',4993.20,0.00,0.00,6.57,0.00,'2022-07-16 18:03:42','',''),(3550,'21','227','1',1,'Retail Sale Id 3634',5996.40,0.00,0.00,7.89,0.00,'2022-07-16 18:04:30','',''),(3551,'21','227','1',1,'Retail Sale Id 3636',4993.20,0.00,0.00,6.57,0.00,'2022-07-16 18:08:56','',''),(3552,'21','227','1',1,'Retail Sale Id 3637',114000.00,0.00,0.00,150.00,0.00,'2022-07-16 18:21:40','',''),(3553,'21','227','1',1,'Retail Sale Id 3638',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 18:22:34','',''),(3554,'21','227','1',1,'Retail Sale Id 3639',4993.20,0.00,0.00,6.57,0.00,'2022-07-16 18:23:23','',''),(3555,'21','227','1',1,'Retail Sale Id 3640',3800.00,0.00,0.00,5.00,0.00,'2022-07-16 18:24:16','',''),(3556,'21','227','1',1,'Retail Sale Id 3641',7957.20,0.00,0.00,10.47,0.00,'2022-07-16 18:26:19','',''),(3557,'21','227','1',1,'Retail Sale Id 3642',3040.00,0.00,0.00,4.00,0.00,'2022-07-16 18:27:11','',''),(3558,'21','227','1',1,'Retail Sale Id 3635',4993.20,0.00,0.00,6.57,0.00,'2022-07-17 09:39:34','',''),(3559,'21','227','1',1,'Retail Sale Id 3643',2994.40,0.00,0.00,3.94,0.00,'2022-07-17 11:57:45','',''),(3560,'21','227','1',1,'Retail Sale Id 3644',1998.80,0.00,0.00,2.63,0.00,'2022-07-17 11:58:41','',''),(3561,'21','227','1',1,'Retail Sale Id 3645',2280.00,0.00,0.00,3.00,0.00,'2022-07-17 12:00:42','',''),(3562,'21','227','1',1,'Retail Sale Id 3646',3496.00,0.00,0.00,4.60,0.00,'2022-07-17 12:01:35','',''),(3563,'21','227','1',1,'Retail Sale Id 3647',1497.20,0.00,0.00,1.97,0.00,'2022-07-17 12:02:53','',''),(3564,'21','227','1',1,'Retail Sale Id 3648',4499.20,0.00,0.00,5.92,0.00,'2022-07-17 12:03:42','',''),(3565,'21','227','1',1,'Retail Sale Id 3649',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 12:04:18','',''),(3566,'21','227','1',1,'Retail Sale Id 3650',7600.00,0.00,0.00,10.00,0.00,'2022-07-17 12:04:56','',''),(3567,'21','227','1',1,'Retail Sale Id 3651',6794.40,0.00,0.00,8.94,0.00,'2022-07-17 12:06:31','',''),(3568,'21','227','1',1,'Retail Sale Id 3652',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 12:07:17','',''),(3569,'21','227','1',1,'Retail Sale Id 3653',1497.20,0.00,0.00,1.97,0.00,'2022-07-17 12:08:09','',''),(3570,'21','227','1',1,'Retail Sale Id 3654',3800.00,0.00,0.00,5.00,0.00,'2022-07-17 12:08:56','',''),(3571,'21','227','1',1,'Retail Sale Id 3655',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 12:09:34','',''),(3572,'21','227','1',1,'Retail Sale Id 3657',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 12:11:15','',''),(3573,'21','227','1',1,'Retail Sale Id 3658',4993.20,0.00,0.00,6.57,0.00,'2022-07-17 12:12:07','',''),(3574,'21','227','1',1,'Retail Sale Id 3661',798.00,0.00,0.00,1.05,0.00,'2022-07-17 12:16:54','',''),(3575,'21','227','1',1,'Retail Sale Id 3656',1497.20,0.00,0.00,1.97,0.00,'2022-07-17 12:20:57','',''),(3576,'21','227','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.25,0.00,'2022-07-17 13:20:45','',''),(3577,'21','227','1',0,'Inventory adjustment from tank dipping to 494',0.00,0.00,494.00,0.00,0.00,'2022-07-17 13:20:45','',''),(3578,'21','227','1',1,'Retail Sale Id 3664',4993.20,0.00,0.00,6.57,0.00,'2022-07-17 13:24:50','',''),(3579,'21','227','1',1,'Retail Sale Id 3665',1497.20,0.00,0.00,1.97,0.00,'2022-07-17 13:25:40','',''),(3580,'21','227','1',1,'Retail Sale Id 3666',3800.00,0.00,0.00,5.00,0.00,'2022-07-17 13:26:29','',''),(3581,'21','227','1',1,'Retail Sale Id 3667',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 13:27:22','',''),(3582,'21','227','1',1,'Retail Sale Id 3668',7600.00,0.00,0.00,10.00,0.00,'2022-07-17 13:33:17','',''),(3583,'21','227','1',1,'Retail Sale Id 3669',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 13:34:31','',''),(3584,'21','227','1',1,'Retail Sale Id 3670',995.60,0.00,0.00,1.31,0.00,'2022-07-17 13:35:17','',''),(3585,'21','227','1',1,'Retail Sale Id 3671',1497.20,0.00,0.00,1.97,0.00,'2022-07-17 13:35:57','',''),(3586,'21','227','1',1,'Retail Sale Id 3672',3040.00,0.00,0.00,4.00,0.00,'2022-07-17 13:36:37','',''),(3587,'21','227','1',1,'Retail Sale Id 3673',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 13:37:17','',''),(3588,'21','227','1',1,'Retail Sale Id 3674',5320.00,0.00,0.00,7.00,0.00,'2022-07-17 13:37:56','',''),(3589,'21','227','1',1,'Retail Sale Id 3675',3800.00,0.00,0.00,5.00,0.00,'2022-07-17 13:38:44','',''),(3590,'21','227','1',1,'Retail Sale Id 3676',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 13:39:23','',''),(3591,'21','227','1',1,'Retail Sale Id 3677',2280.00,0.00,0.00,3.00,0.00,'2022-07-17 13:39:56','',''),(3592,'21','227','1',1,'Retail Sale Id 3678',3800.00,0.00,0.00,5.00,0.00,'2022-07-17 13:40:41','',''),(3593,'21','227','1',1,'Retail Sale Id 3679',1998.80,0.00,0.00,2.63,0.00,'2022-07-17 13:41:22','',''),(3594,'21','227','1',1,'Retail Sale Id 3680',7600.00,0.00,0.00,10.00,0.00,'2022-07-17 13:42:15','',''),(3595,'21','227','1',1,'Retail Sale Id 3681',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 13:43:19','',''),(3596,'21','227','1',1,'Retail Sale Id 3682',7600.00,0.00,0.00,10.00,0.00,'2022-07-17 13:44:01','',''),(3597,'21','227','1',1,'Retail Sale Id 3683',6794.40,0.00,0.00,8.94,0.00,'2022-07-17 13:45:07','',''),(3598,'21','227','1',1,'Retail Sale Id 3684',1998.80,0.00,0.00,2.63,0.00,'2022-07-17 13:47:41','',''),(3599,'21','227','1',1,'Retail Sale Id 3685',11992.80,0.00,0.00,15.78,0.00,'2022-07-17 13:48:49','',''),(3600,'21','227','1',1,'Retail Sale Id 3686',4993.20,0.00,0.00,6.57,0.00,'2022-07-17 13:49:28','',''),(3601,'21','227','1',1,'Retail Sale Id 3687',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 13:50:04','',''),(3602,'21','227','1',1,'Retail Sale Id 3688',3040.00,0.00,0.00,4.00,0.00,'2022-07-17 13:51:15','',''),(3603,'21','227','1',1,'Retail Sale Id 3689',30400.00,0.00,0.00,40.00,0.00,'2022-07-17 13:52:18','',''),(3604,'21','227','1',1,'Retail Sale Id 3690',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 13:52:58','',''),(3605,'21','227','1',1,'Retail Sale Id 3691',4750.00,0.00,0.00,6.25,0.00,'2022-07-17 13:54:00','',''),(3606,'21','227','1',1,'Retail Sale Id 3692',5996.40,0.00,0.00,7.89,0.00,'2022-07-17 13:54:41','',''),(3607,'21','227','1',1,'Retail Sale Id 3693',7600.00,0.00,0.00,10.00,0.00,'2022-07-17 13:55:29','',''),(3608,'21','227','1',1,'Retail Sale Id 3694',2348.40,0.00,0.00,3.09,0.00,'2022-07-17 13:57:41','',''),(3609,'21','227','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,227.90,0.00,'2022-07-17 16:21:03','',''),(3610,'21','227','1',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-07-17 16:21:03','',''),(3611,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3973280.00,5228.00,0.00,0.00,'2022-07-17 16:24:10','',''),(3612,'21','227',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,2228.00,0.00,'2022-07-17 16:26:28','',''),(3613,'21','227','1',1,'Received from bridging 10',0.00,0.00,2228.00,0.00,0.00,'2022-07-17 16:26:28','',''),(3614,'21','227','1',1,'Retail Sale Id 3695',4993.20,0.00,0.00,6.57,0.00,'2022-07-17 17:19:06','',''),(3615,'21','227','1',1,'Retail Sale Id 3696',7600.00,0.00,0.00,10.00,0.00,'2022-07-17 17:19:47','',''),(3616,'21','227','1',1,'Retail Sale Id 3697',2994.40,0.00,0.00,3.94,0.00,'2022-07-17 17:20:25','',''),(3617,'21','227','1',1,'Retail Sale Id 3698',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 17:21:19','',''),(3618,'21','227','1',1,'Retail Sale Id 3699',1497.20,0.00,0.00,1.97,0.00,'2022-07-17 17:21:59','',''),(3619,'21','227','1',1,'Retail Sale Id 3700',9500.00,0.00,0.00,12.50,0.00,'2022-07-17 17:23:44','',''),(3620,'21','227','1',1,'Retail Sale Id 3701',7600.00,0.00,0.00,10.00,0.00,'2022-07-17 17:24:27','',''),(3621,'21','227','1',1,'Retail Sale Id 3702',4993.20,0.00,0.00,6.57,0.00,'2022-07-17 17:25:23','',''),(3622,'21','227','1',1,'Retail Sale Id 3703',4499.20,0.00,0.00,5.92,0.00,'2022-07-17 17:26:16','',''),(3623,'21','227','1',1,'Retail Sale Id 3704',6840.00,0.00,0.00,9.00,0.00,'2022-07-17 17:27:28','',''),(3624,'21','227','1',1,'Retail Sale Id 3705',896.80,0.00,0.00,1.18,0.00,'2022-07-17 17:30:37','',''),(3625,'21','227','1',1,'Retail Sale Id 3706',995.60,0.00,0.00,1.31,0.00,'2022-07-18 11:49:04','',''),(3626,'21','227','1',1,'Retail Sale Id 3707',1497.20,0.00,0.00,1.97,0.00,'2022-07-18 11:50:13','',''),(3627,'21','227','1',1,'Retail Sale Id 3708',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 11:50:51','',''),(3628,'21','227','1',1,'Retail Sale Id 3709',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 11:51:43','',''),(3629,'21','227','1',1,'Retail Sale Id 3710',7600.00,0.00,0.00,10.00,0.00,'2022-07-18 11:53:46','',''),(3630,'21','227','1',1,'Retail Sale Id 3711',4993.20,0.00,0.00,6.57,0.00,'2022-07-18 11:54:36','',''),(3631,'21','227','1',1,'Retail Sale Id 3712',995.60,0.00,0.00,1.31,0.00,'2022-07-18 11:56:17','',''),(3632,'21','227','1',1,'Retail Sale Id 3713',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 11:57:38','',''),(3633,'21','227','1',1,'Retail Sale Id 3714',4750.00,0.00,0.00,6.25,0.00,'2022-07-18 12:04:46','',''),(3634,'21','227','1',1,'Retail Sale Id 3715',3800.00,0.00,0.00,5.00,0.00,'2022-07-18 12:05:41','',''),(3635,'21','227','1',1,'Retail Sale Id 3716',5996.40,0.00,0.00,7.89,0.00,'2022-07-18 12:06:41','',''),(3636,'21','227','1',1,'Retail Sale Id 3717',6999.60,0.00,0.00,9.21,0.00,'2022-07-18 12:07:39','',''),(3637,'21','227','1',1,'Retail Sale Id 3718',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:08:33','',''),(3638,'21','227','1',1,'Retail Sale Id 3719',995.60,0.00,0.00,1.31,0.00,'2022-07-18 12:09:15','',''),(3639,'21','227','1',1,'Retail Sale Id 3720',7600.00,0.00,0.00,10.00,0.00,'2022-07-18 12:10:14','',''),(3640,'21','227','1',1,'Retail Sale Id 3721',1998.80,0.00,0.00,2.63,0.00,'2022-07-18 12:11:43','',''),(3641,'21','227','1',1,'Retail Sale Id 3722',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:12:29','',''),(3642,'21','227','1',1,'Retail Sale Id 3723',3800.00,0.00,0.00,5.00,0.00,'2022-07-18 12:13:25','',''),(3643,'21','227','1',1,'Retail Sale Id 3724',3800.00,0.00,0.00,5.00,0.00,'2022-07-18 12:14:14','',''),(3644,'21','227','1',1,'Retail Sale Id 3725',6794.40,0.00,0.00,8.94,0.00,'2022-07-18 12:15:03','',''),(3645,'21','227','1',1,'Retail Sale Id 3726',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:15:50','',''),(3646,'21','227','1',1,'Retail Sale Id 3727',38000.00,0.00,0.00,50.00,0.00,'2022-07-18 12:17:21','',''),(3647,'21','227','1',1,'Retail Sale Id 3728',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:19:19','',''),(3648,'21','227','1',1,'Retail Sale Id 3729',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:21:04','',''),(3649,'21','227','1',1,'Retail Sale Id 3731',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:22:24','',''),(3650,'21','227','1',1,'Retail Sale Id 3732',1497.20,0.00,0.00,1.97,0.00,'2022-07-18 12:24:12','',''),(3651,'21','227','1',1,'Retail Sale Id 3733',7600.00,0.00,0.00,10.00,0.00,'2022-07-18 12:26:44','',''),(3652,'21','227','1',1,'Retail Sale Id 3734',4560.00,0.00,0.00,6.00,0.00,'2022-07-18 12:29:30','',''),(3653,'21','227','1',1,'Retail Sale Id 3735',2280.00,0.00,0.00,3.00,0.00,'2022-07-18 12:30:15','',''),(3654,'21','227','1',1,'Retail Sale Id 3736',798.00,0.00,0.00,1.05,0.00,'2022-07-18 12:31:05','',''),(3655,'21','227','1',1,'Retail Sale Id 3737',7600.00,0.00,0.00,10.00,0.00,'2022-07-18 12:32:18','',''),(3656,'21','227','1',1,'Retail Sale Id 3738',38000.00,0.00,0.00,50.00,0.00,'2022-07-18 12:36:02','',''),(3657,'21','227','1',1,'Retail Sale Id 3739',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:39:02','',''),(3658,'21','227','1',1,'Retail Sale Id 3740',5320.00,0.00,0.00,7.00,0.00,'2022-07-18 12:40:06','',''),(3659,'21','227','1',1,'Retail Sale Id 3741',4993.20,0.00,0.00,6.57,0.00,'2022-07-18 12:41:43','',''),(3660,'21','227','1',1,'Retail Sale Id 3742',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:42:30','',''),(3661,'21','227','1',1,'Retail Sale Id 3743',4499.20,0.00,0.00,5.92,0.00,'2022-07-18 12:43:14','',''),(3662,'21','227','1',1,'Retail Sale Id 3744',4195.20,0.00,0.00,5.52,0.00,'2022-07-18 12:45:55','',''),(3663,'21','227','1',1,'Retail Sale Id 3745',4750.00,0.00,0.00,6.25,0.00,'2022-07-18 12:47:01','',''),(3664,'21','227','1',1,'Retail Sale Id 3746',2280.00,0.00,0.00,3.00,0.00,'2022-07-18 12:55:57','',''),(3665,'21','227','1',1,'Retail Sale Id 3747',995.60,0.00,0.00,1.31,0.00,'2022-07-18 12:56:31','',''),(3666,'21','227','1',1,'Retail Sale Id 3748',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 12:57:25','',''),(3667,'21','227','1',1,'Retail Sale Id 3749',4947.60,0.00,0.00,6.51,0.00,'2022-07-18 12:58:29','',''),(3668,'21','227','1',1,'Retail Sale Id 3750',4750.00,0.00,0.00,6.25,0.00,'2022-07-18 12:59:58','',''),(3669,'21','227','1',1,'Retail Sale Id 3752',7600.00,0.00,0.00,10.00,0.00,'2022-07-18 13:00:34','',''),(3670,'21','227','1',1,'Retail Sale Id 3753',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 22:28:49','',''),(3671,'21','227','1',1,'Retail Sale Id 3754',798.00,0.00,0.00,1.05,0.00,'2022-07-18 22:29:49','',''),(3672,'21','227','1',1,'Retail Sale Id 3755',3800.00,0.00,0.00,5.00,0.00,'2022-07-18 22:32:13','',''),(3673,'21','227','1',1,'Retail Sale Id 3756',995.60,0.00,0.00,1.31,0.00,'2022-07-18 22:33:49','',''),(3674,'21','227','1',1,'Retail Sale Id 3757',2994.40,0.00,0.00,3.94,0.00,'2022-07-18 22:35:16','',''),(3675,'21','227','1',1,'Retail Sale Id 3758',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 22:37:05','',''),(3676,'21','227','1',1,'Retail Sale Id 3759',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 22:41:52','',''),(3677,'21','227','1',1,'Retail Sale Id 3760',1998.80,0.00,0.00,2.63,0.00,'2022-07-18 22:43:58','',''),(3678,'21','227','1',1,'Retail Sale Id 3761',7600.00,0.00,0.00,10.00,0.00,'2022-07-18 22:46:07','',''),(3679,'21','227','1',1,'Retail Sale Id 3762',5996.40,0.00,0.00,7.89,0.00,'2022-07-18 22:46:56','',''),(3680,'21','227','1',1,'Retail Sale Id 3763',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 22:58:13','',''),(3681,'21','227','1',1,'Retail Sale Id 3764',760.00,0.00,0.00,1.00,0.00,'2022-07-18 23:05:25','',''),(3682,'21','227','1',1,'Retail Sale Id 3765',6794.40,0.00,0.00,8.94,0.00,'2022-07-19 09:33:28','',''),(3683,'21','227','1',1,'Retail Sale Id 3766',91200.00,0.00,0.00,120.00,0.00,'2022-07-19 09:35:32','',''),(3684,'21','227','1',1,'Retail Sale Id 3767',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 09:36:17','',''),(3685,'21','227','1',1,'Retail Sale Id 3768',38000.00,0.00,0.00,50.00,0.00,'2022-07-19 09:37:18','',''),(3686,'21','227','1',1,'Retail Sale Id 3769',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 09:37:54','',''),(3687,'21','227','1',1,'Retail Sale Id 3770',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 09:38:43','',''),(3688,'21','227','1',1,'Retail Sale Id 3771',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 09:46:25','',''),(3689,'21','227','1',1,'Retail Sale Id 3772',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 09:47:27','',''),(3690,'21','227','1',1,'Retail Sale Id 3773',19000.00,0.00,0.00,25.00,0.00,'2022-07-19 09:52:12','',''),(3691,'21','227','1',1,'Retail Sale Id 3774',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 09:53:49','',''),(3692,'21','227','1',1,'Retail Sale Id 3775',6080.00,0.00,0.00,8.00,0.00,'2022-07-19 10:01:31','',''),(3693,'21','227','1',1,'Retail Sale Id 3776',798.00,0.00,0.00,1.05,0.00,'2022-07-19 10:02:54','',''),(3694,'21','227','1',1,'Retail Sale Id 3751',4750.00,0.00,0.00,6.25,0.00,'2022-07-19 10:23:42','',''),(3695,'21','227','1',1,'Retail Sale Id 3777',760.00,0.00,0.00,1.00,0.00,'2022-07-19 10:30:24','',''),(3696,'21','227','1',1,'Retail Sale Id 3779',995.60,0.00,0.00,1.31,0.00,'2022-07-19 10:31:13','',''),(3697,'21','227','1',1,'Retail Sale Id 3780',995.60,0.00,0.00,1.31,0.00,'2022-07-19 10:32:30','',''),(3698,'21','227','1',1,'Retail Sale Id 3781',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 10:33:09','',''),(3699,'21','227','1',1,'Retail Sale Id 3782',6498.00,0.00,0.00,8.55,0.00,'2022-07-19 10:34:45','',''),(3700,'21','227','1',1,'Retail Sale Id 3783',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:35:22','',''),(3701,'21','227','1',1,'Retail Sale Id 3784',798.00,0.00,0.00,1.05,0.00,'2022-07-19 10:36:02','',''),(3702,'21','227','1',1,'Retail Sale Id 3785',4993.20,0.00,0.00,6.57,0.00,'2022-07-19 10:36:46','',''),(3703,'21','227','1',1,'Retail Sale Id 3786',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:37:28','',''),(3704,'21','227','1',1,'Retail Sale Id 3789',6999.60,0.00,0.00,9.21,0.00,'2022-07-19 10:38:22','',''),(3705,'21','227','1',1,'Retail Sale Id 3790',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 10:39:09','',''),(3706,'21','227','1',1,'Retail Sale Id 3791',5996.40,0.00,0.00,7.89,0.00,'2022-07-19 10:39:53','',''),(3707,'21','227','1',1,'Retail Sale Id 3792',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:40:53','',''),(3708,'21','227','1',1,'Retail Sale Id 3793',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 10:41:43','',''),(3709,'21','227','1',1,'Retail Sale Id 3794',19000.00,0.00,0.00,25.00,0.00,'2022-07-19 10:43:00','',''),(3710,'21','227','1',1,'Retail Sale Id 3795',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:43:48','',''),(3711,'21','227','1',1,'Retail Sale Id 3796',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 10:44:40','',''),(3712,'21','227','1',1,'Retail Sale Id 3797',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 10:45:25','',''),(3713,'21','227','1',1,'Retail Sale Id 3798',19000.00,0.00,0.00,25.00,0.00,'2022-07-19 10:46:09','',''),(3714,'21','227','1',1,'Retail Sale Id 3799',995.60,0.00,0.00,1.31,0.00,'2022-07-19 10:46:49','',''),(3715,'21','227','1',1,'Retail Sale Id 3800',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:48:14','',''),(3716,'21','227','1',1,'Retail Sale Id 3801',3739.20,0.00,0.00,4.92,0.00,'2022-07-19 10:48:58','',''),(3717,'21','227','1',1,'Retail Sale Id 3802',7493.60,0.00,0.00,9.86,0.00,'2022-07-19 10:50:11','',''),(3718,'21','227','1',1,'Retail Sale Id 3803',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:50:49','',''),(3719,'21','227','1',1,'Retail Sale Id 3804',38000.00,0.00,0.00,50.00,0.00,'2022-07-19 10:51:36','',''),(3720,'21','227','1',1,'Retail Sale Id 3805',6498.00,0.00,0.00,8.55,0.00,'2022-07-19 10:52:48','',''),(3721,'21','227','1',1,'Retail Sale Id 3806',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:53:27','',''),(3722,'21','227','1',1,'Retail Sale Id 3807',6840.00,0.00,0.00,9.00,0.00,'2022-07-19 10:54:12','',''),(3723,'21','227','1',1,'Retail Sale Id 3808',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:55:08','',''),(3724,'21','227','1',1,'Retail Sale Id 3809',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:55:51','',''),(3725,'21','227','1',1,'Retail Sale Id 3810',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 10:57:04','',''),(3726,'21','227','1',1,'Retail Sale Id 3811',995.60,0.00,0.00,1.31,0.00,'2022-07-19 10:58:50','',''),(3727,'21','227','1',1,'Retail Sale Id 3812',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 10:59:31','',''),(3728,'21','227','1',1,'Retail Sale Id 3813',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 11:00:37','',''),(3729,'21','227','1',1,'Retail Sale Id 3814',11400.00,0.00,0.00,15.00,0.00,'2022-07-19 11:01:32','',''),(3730,'21','227','1',1,'Retail Sale Id 3815',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 11:02:35','',''),(3731,'21','227','1',1,'Retail Sale Id 3817',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 11:03:30','',''),(3732,'21','227','1',1,'Retail Sale Id 3818',4993.20,0.00,0.00,6.57,0.00,'2022-07-19 11:04:52','',''),(3733,'21','227','1',1,'Retail Sale Id 3820',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 11:07:24','',''),(3734,'21','227','1',1,'Retail Sale Id 3821',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 11:10:59','',''),(3735,'21','227','1',1,'Retail Sale Id 3822',798.00,0.00,0.00,1.05,0.00,'2022-07-19 11:11:34','',''),(3736,'21','227','1',1,'Retail Sale Id 3823',995.60,0.00,0.00,1.31,0.00,'2022-07-19 11:12:10','',''),(3737,'21','227','1',1,'Retail Sale Id 3824',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 11:12:54','',''),(3738,'21','227','1',1,'Retail Sale Id 3825',995.60,0.00,0.00,1.31,0.00,'2022-07-19 11:13:37','',''),(3739,'21','227','1',1,'Retail Sale Id 3826',38000.00,0.00,0.00,50.00,0.00,'2022-07-19 11:14:58','',''),(3740,'21','227','1',1,'Retail Sale Id 3827',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 11:15:49','',''),(3741,'21','227','1',1,'Retail Sale Id 3828',4993.20,0.00,0.00,6.57,0.00,'2022-07-19 11:16:37','',''),(3742,'21','227','1',1,'Retail Sale Id 3829',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 11:18:05','',''),(3743,'21','227','1',1,'Retail Sale Id 3830',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 11:18:51','',''),(3744,'21','227','1',1,'Retail Sale Id 3831',995.60,0.00,0.00,1.31,0.00,'2022-07-19 11:19:24','',''),(3745,'21','227','1',1,'Retail Sale Id 3832',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 11:21:15','',''),(3746,'21','227','1',1,'Retail Sale Id 3833',6498.00,0.00,0.00,8.55,0.00,'2022-07-19 11:23:21','',''),(3747,'21','227','1',1,'Retail Sale Id 3834',4750.00,0.00,0.00,6.25,0.00,'2022-07-19 11:24:19','',''),(3748,'21','227','1',1,'Retail Sale Id 3819',4993.20,0.00,0.00,6.57,0.00,'2022-07-19 11:32:53','',''),(3749,'21','227','1',1,'Retail Sale Id 3816',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 11:33:39','',''),(3750,'21','227','1',1,'Retail Sale Id 3787',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 11:35:38','',''),(3751,'21','227','1',1,'Retail Sale Id 3788',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 11:39:02','',''),(3752,'21','227','1',1,'Retail Sale Id 3835',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 11:57:55','',''),(3753,'21','227','1',1,'Retail Sale Id 3836',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 11:58:50','',''),(3754,'21','227','1',1,'Retail Sale Id 3837',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 11:59:29','',''),(3755,'21','227','1',1,'Retail Sale Id 3838',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:00:41','',''),(3756,'21','227','1',1,'Retail Sale Id 3839',38000.00,0.00,0.00,50.00,0.00,'2022-07-19 12:01:51','',''),(3757,'21','227','1',1,'Retail Sale Id 3841',1900.00,0.00,0.00,2.50,0.00,'2022-07-19 12:18:52','',''),(3758,'21','227','1',1,'Retail Sale Id 3842',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 12:19:57','',''),(3759,'21','227','1',1,'Retail Sale Id 3843',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 12:20:54','',''),(3760,'21','227','1',1,'Retail Sale Id 3844',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:21:48','',''),(3761,'21','227','1',1,'Retail Sale Id 3845',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 12:22:37','',''),(3762,'21','227','1',1,'Retail Sale Id 3846',7995.20,0.00,0.00,10.52,0.00,'2022-07-19 12:23:17','',''),(3763,'21','227','1',1,'Retail Sale Id 3847',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:23:56','',''),(3764,'21','227','1',1,'Retail Sale Id 3848',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 12:24:40','',''),(3765,'21','227','1',1,'Retail Sale Id 3849',4993.20,0.00,0.00,6.57,0.00,'2022-07-19 12:26:06','',''),(3766,'21','227','1',1,'Retail Sale Id 3850',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 12:27:03','',''),(3767,'21','227','1',1,'Retail Sale Id 3851',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:27:53','',''),(3768,'21','227','1',1,'Retail Sale Id 3852',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 12:28:47','',''),(3769,'21','227','1',1,'Retail Sale Id 3853',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 12:29:33','',''),(3770,'21','227','1',1,'Retail Sale Id 3854',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:30:27','',''),(3771,'21','227','1',1,'Retail Sale Id 3855',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 12:31:12','',''),(3772,'21','227','1',1,'Retail Sale Id 3856',5320.00,0.00,0.00,7.00,0.00,'2022-07-19 12:33:53','',''),(3773,'21','227','1',1,'Retail Sale Id 3857',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:34:37','',''),(3774,'21','227','1',1,'Retail Sale Id 3858',4993.20,0.00,0.00,6.57,0.00,'2022-07-19 12:35:47','',''),(3775,'21','227','1',1,'Retail Sale Id 3859',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 12:36:28','',''),(3776,'21','227','1',1,'Retail Sale Id 3860',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 12:37:10','',''),(3777,'21','227','1',1,'Retail Sale Id 3861',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:39:21','',''),(3778,'21','227','1',1,'Retail Sale Id 3862',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 12:40:21','',''),(3779,'21','227','1',1,'Retail Sale Id 3863',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 12:41:16','',''),(3780,'21','227','1',1,'Retail Sale Id 3864',1900.00,0.00,0.00,2.50,0.00,'2022-07-19 12:42:35','',''),(3781,'21','227','1',1,'Retail Sale Id 3865',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 12:43:15','',''),(3782,'21','227','1',1,'Retail Sale Id 3866',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:44:02','',''),(3783,'21','227','1',1,'Retail Sale Id 3867',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 12:44:59','',''),(3784,'21','227','1',1,'Retail Sale Id 3868',3997.60,0.00,0.00,5.26,0.00,'2022-07-19 12:46:10','',''),(3785,'21','227','1',1,'Retail Sale Id 3869',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 12:47:11','',''),(3786,'21','227','1',1,'Retail Sale Id 3870',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:48:01','',''),(3787,'21','227','1',1,'Retail Sale Id 3871',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 12:48:36','',''),(3788,'21','227','1',1,'Retail Sale Id 3872',3997.60,0.00,0.00,5.26,0.00,'2022-07-19 12:50:52','',''),(3789,'21','227','1',1,'Retail Sale Id 3873',798.00,0.00,0.00,1.05,0.00,'2022-07-19 12:51:51','',''),(3790,'21','227','1',1,'Retail Sale Id 3874',38000.00,0.00,0.00,50.00,0.00,'2022-07-19 12:53:07','',''),(3791,'21','227','1',1,'Retail Sale Id 3875',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 12:54:43','',''),(3792,'21','227','1',1,'Retail Sale Id 3876',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 12:55:33','',''),(3793,'21','227','1',1,'Retail Sale Id 3877',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 12:56:34','',''),(3794,'21','227','1',1,'Retail Sale Id 3878',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 12:57:18','',''),(3795,'21','227','1',1,'Retail Sale Id 3879',4499.20,0.00,0.00,5.92,0.00,'2022-07-19 12:58:13','',''),(3796,'21','227','1',1,'Retail Sale Id 3880',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 12:59:01','',''),(3797,'21','227','1',1,'Retail Sale Id 3881',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 13:00:08','',''),(3798,'21','227','1',1,'Retail Sale Id 3882',4750.00,0.00,0.00,6.25,0.00,'2022-07-19 13:00:59','',''),(3799,'21','227','1',1,'Retail Sale Id 3883',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 13:01:52','',''),(3800,'21','227','1',1,'Retail Sale Id 3884',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 13:02:35','',''),(3801,'21','227','1',1,'Retail Sale Id 3885',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 13:03:17','',''),(3802,'21','227','1',1,'Retail Sale Id 3886',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 13:04:00','',''),(3803,'21','227','1',1,'Retail Sale Id 3887',4993.20,0.00,0.00,6.57,0.00,'2022-07-19 13:05:44','',''),(3804,'21','227','1',1,'Retail Sale Id 3888',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 13:06:38','',''),(3805,'21','227','1',1,'Retail Sale Id 3889',38000.00,0.00,0.00,50.00,0.00,'2022-07-19 13:08:07','',''),(3806,'21','227','1',1,'Retail Sale Id 3890',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 13:08:49','',''),(3807,'21','227','1',1,'Retail Sale Id 3891',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 13:09:45','',''),(3808,'21','227','1',1,'Retail Sale Id 3892',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 13:11:06','',''),(3809,'21','227','1',1,'Retail Sale Id 3893',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 13:11:58','',''),(3810,'21','227','1',1,'Retail Sale Id 3894',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 13:12:47','',''),(3811,'21','227','1',1,'Retail Sale Id 3895',22800.00,0.00,0.00,30.00,0.00,'2022-07-19 13:15:06','',''),(3812,'21','227','1',1,'Retail Sale Id 3896',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 13:16:50','',''),(3813,'21','227','1',1,'Retail Sale Id 3897',684.00,0.00,0.00,0.90,0.00,'2022-07-19 13:17:38','',''),(3814,'21','227','1',1,'Retail Sale Id 3840',1900.00,0.00,0.00,2.50,0.00,'2022-07-19 13:31:13','',''),(3815,'21','227','1',1,'Retail Sale Id 3898',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 13:53:01','',''),(3816,'21','227','1',1,'Retail Sale Id 3899',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 13:54:08','',''),(3817,'21','227','1',1,'Retail Sale Id 3900',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 13:55:32','',''),(3818,'21','227','1',1,'Retail Sale Id 3901',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 13:56:08','',''),(3819,'21','227','1',1,'Retail Sale Id 3902',7995.20,0.00,0.00,10.52,0.00,'2022-07-19 13:56:52','',''),(3820,'21','227','1',1,'Retail Sale Id 3904',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 13:57:34','',''),(3821,'21','227','1',1,'Retail Sale Id 3905',2492.80,0.00,0.00,3.28,0.00,'2022-07-19 13:59:49','',''),(3822,'21','227','1',1,'Retail Sale Id 3906',15200.00,0.00,0.00,20.00,0.00,'2022-07-19 14:00:36','',''),(3823,'21','227','1',1,'Retail Sale Id 3907',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 14:01:49','',''),(3824,'21','227','1',1,'Retail Sale Id 3908',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 14:02:48','',''),(3825,'21','227','1',1,'Retail Sale Id 3909',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 14:03:38','',''),(3826,'21','227','1',1,'Retail Sale Id 3910',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 14:04:10','',''),(3827,'21','227','1',1,'Retail Sale Id 3911',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 14:05:21','',''),(3828,'21','227','1',1,'Retail Sale Id 3914',1793.60,0.00,0.00,2.36,0.00,'2022-07-19 14:06:43','',''),(3829,'21','227','1',1,'Retail Sale Id 3915',19000.00,0.00,0.00,25.00,0.00,'2022-07-19 14:08:08','',''),(3830,'21','227',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,3000.00,0.00,'2022-07-19 15:37:33','',''),(3831,'21','227','1',1,'Received from bridging 11',0.00,0.00,3000.00,0.00,0.00,'2022-07-19 15:37:33','',''),(3832,'21','227','1',1,'Retail Sale Id 3916',4795.60,0.00,0.00,6.31,0.00,'2022-07-19 17:10:42','',''),(3833,'21','227','1',1,'Retail Sale Id 3917',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 17:11:17','',''),(3834,'21','227','1',1,'Retail Sale Id 3919',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 17:12:05','',''),(3835,'21','227','1',1,'Retail Sale Id 3920',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:12:35','',''),(3836,'21','227','1',1,'Retail Sale Id 3921',4993.20,0.00,0.00,6.57,0.00,'2022-07-19 17:22:49','',''),(3837,'21','227','1',1,'Retail Sale Id 3922',798.00,0.00,0.00,1.05,0.00,'2022-07-19 17:23:21','',''),(3838,'21','227','1',1,'Retail Sale Id 3923',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 17:24:23','',''),(3839,'21','227','1',1,'Retail Sale Id 3924',995.60,0.00,0.00,1.31,0.00,'2022-07-19 17:24:56','',''),(3840,'21','227','1',1,'Retail Sale Id 3925',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:25:27','',''),(3841,'21','227','1',1,'Retail Sale Id 3926',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 17:25:53','',''),(3842,'21','227','1',1,'Retail Sale Id 3927',19000.00,0.00,0.00,25.00,0.00,'2022-07-19 17:26:24','',''),(3843,'21','227','1',1,'Retail Sale Id 3928',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 17:27:42','',''),(3844,'21','227','1',1,'Retail Sale Id 3929',6080.00,0.00,0.00,8.00,0.00,'2022-07-19 17:28:22','',''),(3845,'21','227','1',1,'Retail Sale Id 3930',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:29:12','',''),(3846,'21','227','1',1,'Retail Sale Id 3932',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:30:16','',''),(3847,'21','227','1',1,'Retail Sale Id 3933',3997.60,0.00,0.00,5.26,0.00,'2022-07-19 17:30:54','',''),(3848,'21','227','1',1,'Retail Sale Id 3934',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:32:10','',''),(3849,'21','227','1',1,'Retail Sale Id 3935',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 17:33:20','',''),(3850,'21','227','1',1,'Retail Sale Id 3936',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 17:34:20','',''),(3851,'21','227','1',1,'Retail Sale Id 3937',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:34:58','',''),(3852,'21','227','1',1,'Retail Sale Id 3938',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 17:36:03','',''),(3853,'21','227','1',1,'Retail Sale Id 3939',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 17:36:44','',''),(3854,'21','227','1',1,'Retail Sale Id 3940',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 17:37:37','',''),(3855,'21','227','1',1,'Retail Sale Id 3941',995.60,0.00,0.00,1.31,0.00,'2022-07-19 17:38:46','',''),(3856,'21','227','1',1,'Retail Sale Id 3942',5320.00,0.00,0.00,7.00,0.00,'2022-07-19 17:39:39','',''),(3857,'21','227','1',1,'Retail Sale Id 3943',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 17:40:19','',''),(3858,'21','227','1',1,'Retail Sale Id 3944',6999.60,0.00,0.00,9.21,0.00,'2022-07-19 17:41:14','',''),(3859,'21','227','1',1,'Retail Sale Id 3945',798.00,0.00,0.00,1.05,0.00,'2022-07-19 17:42:42','',''),(3860,'21','227','1',1,'Retail Sale Id 3946',7493.60,0.00,0.00,9.86,0.00,'2022-07-19 17:43:19','',''),(3861,'21','227','1',1,'Retail Sale Id 3947',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:44:41','',''),(3862,'21','227','1',1,'Retail Sale Id 3948',13680.00,0.00,0.00,18.00,0.00,'2022-07-19 17:45:11','',''),(3863,'21','227','1',1,'Retail Sale Id 3949',798.00,0.00,0.00,1.05,0.00,'2022-07-19 17:45:48','',''),(3864,'21','227','1',1,'Retail Sale Id 3950',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 17:46:20','',''),(3865,'21','227','1',1,'Retail Sale Id 3951',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:46:53','',''),(3866,'21','227','1',1,'Retail Sale Id 3952',5996.40,0.00,0.00,7.89,0.00,'2022-07-19 17:48:15','',''),(3867,'21','227','1',1,'Retail Sale Id 3954',4499.20,0.00,0.00,5.92,0.00,'2022-07-19 17:49:05','',''),(3868,'21','227','1',1,'Retail Sale Id 3955',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 17:50:13','',''),(3869,'21','227','1',1,'Retail Sale Id 3956',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:50:41','',''),(3870,'21','227','1',1,'Retail Sale Id 3957',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:51:33','',''),(3871,'21','227','1',1,'Retail Sale Id 3959',11400.00,0.00,0.00,15.00,0.00,'2022-07-19 17:52:59','',''),(3872,'21','227','1',1,'Retail Sale Id 3960',995.60,0.00,0.00,1.31,0.00,'2022-07-19 17:53:35','',''),(3873,'21','227','1',1,'Retail Sale Id 3961',38000.00,0.00,0.00,50.00,0.00,'2022-07-19 17:54:26','',''),(3874,'21','227','1',1,'Retail Sale Id 3962',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:55:51','',''),(3875,'21','227','1',1,'Retail Sale Id 3963',798.00,0.00,0.00,1.05,0.00,'2022-07-19 17:56:24','',''),(3876,'21','227','1',1,'Retail Sale Id 3964',6080.00,0.00,0.00,8.00,0.00,'2022-07-19 17:57:24','',''),(3877,'21','227','1',1,'Retail Sale Id 3965',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 17:58:34','',''),(3878,'21','227','1',1,'Retail Sale Id 3966',494.00,0.00,0.00,0.65,0.00,'2022-07-19 17:59:28','',''),(3879,'21','227','1',1,'Retail Sale Id 3967',494.00,0.00,0.00,0.65,0.00,'2022-07-19 18:01:06','',''),(3880,'21','227','1',1,'Retail Sale Id 3968',2492.80,0.00,0.00,3.28,0.00,'2022-07-19 18:01:39','',''),(3881,'21','227','1',1,'Retail Sale Id 3969',995.60,0.00,0.00,1.31,0.00,'2022-07-19 18:02:22','',''),(3882,'21','227','1',1,'Retail Sale Id 3970',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 18:04:12','',''),(3883,'21','227','1',1,'Retail Sale Id 3971',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 18:04:44','',''),(3884,'21','227','1',1,'Retail Sale Id 3972',11400.00,0.00,0.00,15.00,0.00,'2022-07-19 18:05:47','',''),(3885,'21','227','1',1,'Retail Sale Id 3953',5996.40,0.00,0.00,7.89,0.00,'2022-07-19 18:06:31','',''),(3886,'21','227','1',1,'Retail Sale Id 3958',11400.00,0.00,0.00,15.00,0.00,'2022-07-19 18:07:16','',''),(3887,'21','227','1',1,'Retail Sale Id 3931',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 18:08:22','',''),(3888,'21','227','1',1,'Retail Sale Id 3912',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 18:11:14','',''),(3889,'21','227','1',1,'Retail Sale Id 3973',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 18:15:47','',''),(3890,'21','227','1',1,'Retail Sale Id 3974',5320.00,0.00,0.00,7.00,0.00,'2022-07-19 18:17:03','',''),(3891,'21','227','1',1,'Retail Sale Id 3975',2994.40,0.00,0.00,3.94,0.00,'2022-07-19 18:18:56','',''),(3892,'21','227','1',1,'Retail Sale Id 3976',7600.00,0.00,0.00,10.00,0.00,'2022-07-20 10:37:33','',''),(3893,'21','227','1',1,'Retail Sale Id 3977',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 10:49:34','',''),(3894,'21','227','1',1,'Retail Sale Id 3978',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 10:50:34','',''),(3895,'21','227','1',1,'Retail Sale Id 3979',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 10:51:22','',''),(3896,'21','227','1',1,'Retail Sale Id 3980',995.60,0.00,0.00,1.31,0.00,'2022-07-20 11:15:43','',''),(3897,'21','227','1',1,'Retail Sale Id 3981',995.60,0.00,0.00,1.31,0.00,'2022-07-20 11:18:02','',''),(3898,'21','227','1',1,'Retail Sale Id 3982',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 11:18:58','',''),(3899,'21','227','1',1,'Retail Sale Id 3983',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 11:19:53','',''),(3900,'21','227','1',1,'Retail Sale Id 3984',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 11:21:41','',''),(3901,'21','227','1',1,'Retail Sale Id 3985',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 11:22:27','',''),(3902,'21','227','1',1,'Retail Sale Id 3986',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 11:23:02','',''),(3903,'21','227','1',1,'Retail Sale Id 3987',4993.20,0.00,0.00,6.57,0.00,'2022-07-20 11:23:49','',''),(3904,'21','227','1',1,'Retail Sale Id 3988',798.00,0.00,0.00,1.05,0.00,'2022-07-20 11:24:44','',''),(3905,'21','227','1',1,'Retail Sale Id 3989',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 11:25:31','',''),(3906,'21','227','1',1,'Retail Sale Id 3990',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 11:26:29','',''),(3907,'21','227','1',1,'Retail Sale Id 3991',7600.00,0.00,0.00,10.00,0.00,'2022-07-20 11:39:28','',''),(3908,'21','227','1',1,'Retail Sale Id 3992',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 11:40:02','',''),(3909,'21','227','1',1,'Retail Sale Id 3993',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 11:41:06','',''),(3910,'21','227','1',1,'Retail Sale Id 3994',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 11:41:53','',''),(3911,'21','227','1',1,'Retail Sale Id 3995',995.60,0.00,0.00,1.31,0.00,'2022-07-20 11:42:30','',''),(3912,'21','227','1',1,'Retail Sale Id 3996',760.00,0.00,0.00,1.00,0.00,'2022-07-20 11:43:48','',''),(3913,'21','227','1',1,'Retail Sale Id 3997',2994.40,0.00,0.00,3.94,0.00,'2022-07-20 11:44:45','',''),(3914,'21','227','1',1,'Retail Sale Id 3998',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 11:51:51','',''),(3915,'21','227','1',1,'Retail Sale Id 3999',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 11:54:30','',''),(3916,'21','227','1',1,'Retail Sale Id 4000',4993.20,0.00,0.00,6.57,0.00,'2022-07-20 11:55:24','',''),(3917,'21','227','1',1,'Retail Sale Id 4001',7600.00,0.00,0.00,10.00,0.00,'2022-07-20 11:56:12','',''),(3918,'21','227','1',1,'Retail Sale Id 4002',494.00,0.00,0.00,0.65,0.00,'2022-07-20 11:58:01','',''),(3919,'21','227','1',1,'Retail Sale Id 4003',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 12:01:22','',''),(3920,'21','227','1',1,'Retail Sale Id 4004',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 12:06:51','',''),(3921,'21','227','1',1,'Retail Sale Id 4005',4499.20,0.00,0.00,5.92,0.00,'2022-07-20 12:07:28','',''),(3922,'21','227','1',1,'Retail Sale Id 4006',494.00,0.00,0.00,0.65,0.00,'2022-07-20 12:09:56','',''),(3923,'21','227','1',1,'Retail Sale Id 4007',2492.80,0.00,0.00,3.28,0.00,'2022-07-20 12:19:10','',''),(3924,'21','227','1',1,'Retail Sale Id 4008',995.60,0.00,0.00,1.31,0.00,'2022-07-20 12:30:10','',''),(3925,'21','227','1',1,'Retail Sale Id 4009',1520.00,0.00,0.00,2.00,0.00,'2022-07-20 12:32:20','',''),(3926,'21','227','1',1,'Retail Sale Id 4010',760.00,0.00,0.00,1.00,0.00,'2022-07-20 12:39:35','',''),(3927,'21','227','1',1,'Retail Sale Id 4011',1793.60,0.00,0.00,2.36,0.00,'2022-07-20 12:41:16','',''),(3928,'21','227','1',1,'Retail Sale Id 4012',2295.20,0.00,0.00,3.02,0.00,'2022-07-20 12:43:41','',''),(3929,'21','227','1',1,'Retail Sale Id 4013',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 12:49:06','',''),(3930,'21','227','1',1,'Retail Sale Id 4014',995.60,0.00,0.00,1.31,0.00,'2022-07-20 12:53:34','',''),(3931,'21','227','1',1,'Retail Sale Id 4015',3496.00,0.00,0.00,4.60,0.00,'2022-07-20 12:55:07','',''),(3932,'21','227','1',1,'Retail Sale Id 4016',2796.80,0.00,0.00,3.68,0.00,'2022-07-20 13:09:34','',''),(3933,'21','227','1',1,'Retail Sale Id 4017',995.60,0.00,0.00,1.31,0.00,'2022-07-20 13:10:35','',''),(3934,'21','227','1',1,'Retail Sale Id 4018',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 13:22:17','',''),(3935,'21','227','1',1,'Retail Sale Id 4019',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 13:26:36','',''),(3936,'21','227','1',1,'Retail Sale Id 4020',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 13:28:08','',''),(3937,'21','227','1',1,'Retail Sale Id 4021',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 15:47:37','',''),(3938,'21','227','1',1,'Retail Sale Id 4022',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 15:48:28','',''),(3939,'21','227','1',1,'Retail Sale Id 4023',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 15:49:24','',''),(3940,'21','227','1',1,'Retail Sale Id 4024',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 15:50:18','',''),(3941,'21','227','1',1,'Retail Sale Id 4025',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 15:50:50','',''),(3942,'21','227','1',1,'Retail Sale Id 4026',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 15:51:23','',''),(3943,'21','227','1',1,'Retail Sale Id 4027',4993.20,0.00,0.00,6.57,0.00,'2022-07-20 15:52:12','',''),(3944,'21','227','1',1,'Retail Sale Id 4028',2994.40,0.00,0.00,3.94,0.00,'2022-07-20 15:52:44','',''),(3945,'21','227','1',1,'Retail Sale Id 4029',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 15:53:29','',''),(3946,'21','227','1',1,'Retail Sale Id 4030',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 15:54:24','',''),(3947,'21','227','1',1,'Retail Sale Id 4031',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 15:55:42','',''),(3948,'21','227','1',1,'Retail Sale Id 4032',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 15:56:56','',''),(3949,'21','227','1',1,'Retail Sale Id 4033',995.60,0.00,0.00,1.31,0.00,'2022-07-20 15:57:38','',''),(3950,'21','227','1',1,'Retail Sale Id 4034',995.60,0.00,0.00,1.31,0.00,'2022-07-20 16:04:49','',''),(3951,'21','227','1',1,'Retail Sale Id 4035',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 16:05:38','',''),(3952,'21','227','1',1,'Retail Sale Id 4036',995.60,0.00,0.00,1.31,0.00,'2022-07-20 16:07:09','',''),(3953,'21','227','1',1,'Retail Sale Id 4037',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 16:08:13','',''),(3954,'21','227','1',1,'Retail Sale Id 4038',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 16:09:05','',''),(3955,'21','227','1',1,'Retail Sale Id 4039',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 16:10:20','',''),(3956,'21','227','1',1,'Retail Sale Id 4040',995.60,0.00,0.00,1.31,0.00,'2022-07-20 16:12:17','',''),(3957,'21','227','1',1,'Retail Sale Id 4041',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 16:13:10','',''),(3958,'21','227','1',1,'Retail Sale Id 4042',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 16:42:02','',''),(3959,'21','227','1',1,'Retail Sale Id 4043',4993.20,0.00,0.00,6.57,0.00,'2022-07-20 16:43:22','',''),(3960,'21','227','1',1,'Retail Sale Id 4044',2492.80,0.00,0.00,3.28,0.00,'2022-07-20 16:48:22','',''),(3961,'21','227','1',1,'Retail Sale Id 4045',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 16:49:31','',''),(3962,'21','227','1',1,'Retail Sale Id 4046',798.00,0.00,0.00,1.05,0.00,'2022-07-20 16:52:46','',''),(3963,'21','227','1',1,'Retail Sale Id 4047',9120.00,0.00,0.00,12.00,0.00,'2022-07-20 16:54:08','',''),(3964,'21','227','1',1,'Retail Sale Id 4048',995.60,0.00,0.00,1.31,0.00,'2022-07-20 16:57:25','',''),(3965,'21','227','1',1,'Retail Sale Id 4049',2492.80,0.00,0.00,3.28,0.00,'2022-07-20 17:02:21','',''),(3966,'21','227','1',1,'Retail Sale Id 4050',2492.80,0.00,0.00,3.28,0.00,'2022-07-20 17:05:17','',''),(3967,'21','227','1',1,'Retail Sale Id 4051',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 17:06:26','',''),(3968,'21','227','1',1,'Retail Sale Id 4052',995.60,0.00,0.00,1.31,0.00,'2022-07-20 17:07:19','',''),(3969,'21','227','1',1,'Retail Sale Id 4053',494.00,0.00,0.00,0.65,0.00,'2022-07-20 17:07:51','',''),(3970,'21','227','1',1,'Retail Sale Id 4054',2599.20,0.00,0.00,3.42,0.00,'2022-07-20 17:08:27','',''),(3971,'21','227','1',1,'Retail Sale Id 4055',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 17:09:58','',''),(3972,'21','227','1',1,'Retail Sale Id 4056',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 17:12:42','',''),(3973,'21','227','1',1,'Retail Sale Id 4057',1398.40,0.00,0.00,1.84,0.00,'2022-07-20 17:14:36','',''),(3974,'21','227','1',1,'Retail Sale Id 4058',995.60,0.00,0.00,1.31,0.00,'2022-07-20 17:15:16','',''),(3975,'21','227','1',1,'Retail Sale Id 4059',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 17:49:55','',''),(3976,'21','227','1',1,'Retail Sale Id 4060',995.60,0.00,0.00,1.31,0.00,'2022-07-20 17:50:34','',''),(3977,'21','227','1',1,'Retail Sale Id 4061',995.60,0.00,0.00,1.31,0.00,'2022-07-20 17:51:23','',''),(3978,'21','227','1',1,'Retail Sale Id 4062',896.80,0.00,0.00,1.18,0.00,'2022-07-20 17:51:55','',''),(3979,'21','227','1',1,'Retail Sale Id 4063',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 17:53:20','',''),(3980,'21','227','1',1,'Retail Sale Id 4064',2994.40,0.00,0.00,3.94,0.00,'2022-07-20 17:54:06','',''),(3981,'21','227','1',1,'Retail Sale Id 4065',1398.40,0.00,0.00,1.84,0.00,'2022-07-20 17:54:52','',''),(3982,'21','227','1',1,'Retail Sale Id 4066',4993.20,0.00,0.00,6.57,0.00,'2022-07-20 17:55:36','',''),(3983,'21','227','1',1,'Retail Sale Id 4067',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 17:56:05','',''),(3984,'21','227','1',1,'Retail Sale Id 4068',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 17:56:53','',''),(3985,'21','227','1',1,'Retail Sale Id 4069',5320.00,0.00,0.00,7.00,0.00,'2022-07-20 17:57:44','',''),(3986,'21','227','1',1,'Retail Sale Id 4070',2994.40,0.00,0.00,3.94,0.00,'2022-07-20 18:01:25','',''),(3987,'21','227','1',1,'Retail Sale Id 4071',2492.80,0.00,0.00,3.28,0.00,'2022-07-20 18:03:01','',''),(3988,'21','227','1',1,'Retail Sale Id 4072',494.00,0.00,0.00,0.65,0.00,'2022-07-21 08:24:42','',''),(3989,'21','227','1',1,'Retail Sale Id 4073',1998.80,0.00,0.00,2.63,0.00,'2022-07-21 08:25:30','',''),(3990,'21','227','1',1,'Retail Sale Id 4074',995.60,0.00,0.00,1.31,0.00,'2022-07-21 08:26:07','',''),(3991,'21','227','1',1,'Retail Sale Id 4075',1497.20,0.00,0.00,1.97,0.00,'2022-07-21 08:27:17','',''),(3992,'21','227','1',1,'Retail Sale Id 4076',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 09:19:42','',''),(3993,'21','227','1',1,'Retail Sale Id 4077',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 09:20:44','',''),(3994,'21','227','1',1,'Retail Sale Id 4078',995.60,0.00,0.00,1.31,0.00,'2022-07-21 09:21:49','',''),(3995,'21','227','1',1,'Retail Sale Id 4079',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 09:22:41','',''),(3996,'21','227','1',1,'Retail Sale Id 4080',2280.00,0.00,0.00,3.00,0.00,'2022-07-21 10:24:30','',''),(3997,'21','227','1',1,'Retail Sale Id 4081',1998.80,0.00,0.00,2.63,0.00,'2022-07-21 10:26:46','',''),(3998,'21','227','1',1,'Retail Sale Id 4082',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 10:33:05','',''),(3999,'21','227','1',1,'Retail Sale Id 4083',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 10:35:19','',''),(4000,'21','227','1',1,'Retail Sale Id 4084',2994.40,0.00,0.00,3.94,0.00,'2022-07-21 10:36:10','',''),(4001,'21','227','1',1,'Retail Sale Id 4085',995.60,0.00,0.00,1.31,0.00,'2022-07-21 10:42:04','',''),(4002,'21','227','1',1,'Retail Sale Id 4086',3800.00,0.00,0.00,5.00,0.00,'2022-07-21 10:43:36','',''),(4003,'21','227','1',1,'Retail Sale Id 4087',1497.20,0.00,0.00,1.97,0.00,'2022-07-21 11:01:27','',''),(4004,'21','227','1',1,'Retail Sale Id 4088',5996.40,0.00,0.00,7.89,0.00,'2022-07-21 11:05:34','',''),(4005,'21','227','1',1,'Retail Sale Id 4089',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 11:07:15','',''),(4006,'21','227','1',1,'Retail Sale Id 4090',1998.80,0.00,0.00,2.63,0.00,'2022-07-21 11:10:58','',''),(4007,'21','227','1',1,'Retail Sale Id 4091',3800.00,0.00,0.00,5.00,0.00,'2022-07-21 11:17:06','',''),(4008,'21','227','1',1,'Retail Sale Id 4092',995.60,0.00,0.00,1.31,0.00,'2022-07-21 11:20:27','',''),(4009,'21','227','1',1,'Retail Sale Id 4093',19000.00,0.00,0.00,25.00,0.00,'2022-07-21 16:31:16','',''),(4010,'21','227','1',1,'Retail Sale Id 4094',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 16:32:12','',''),(4011,'21','227','1',1,'Retail Sale Id 4095',3040.00,0.00,0.00,4.00,0.00,'2022-07-21 16:35:58','',''),(4012,'21','227','1',1,'Retail Sale Id 4096',1497.20,0.00,0.00,1.97,0.00,'2022-07-21 16:37:15','',''),(4013,'21','227','1',1,'Retail Sale Id 4097',995.60,0.00,0.00,1.31,0.00,'2022-07-21 16:39:02','',''),(4014,'21','227','1',1,'Retail Sale Id 4098',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 16:39:57','',''),(4015,'21','227','1',1,'Retail Sale Id 4100',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 16:41:18','',''),(4016,'21','227','1',1,'Retail Sale Id 4101',6999.60,0.00,0.00,9.21,0.00,'2022-07-21 16:42:15','',''),(4017,'21','227','1',1,'Retail Sale Id 4102',995.60,0.00,0.00,1.31,0.00,'2022-07-21 16:43:06','',''),(4018,'21','227','1',1,'Retail Sale Id 4103',1497.20,0.00,0.00,1.97,0.00,'2022-07-21 16:44:04','',''),(4019,'21','227','1',1,'Retail Sale Id 4104',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 16:44:59','',''),(4020,'21','227','1',1,'Retail Sale Id 4105',760.00,0.00,0.00,1.00,0.00,'2022-07-21 16:45:35','',''),(4021,'21','227','1',1,'Retail Sale Id 4106',995.60,0.00,0.00,1.31,0.00,'2022-07-21 16:46:31','',''),(4022,'21','227','1',1,'Retail Sale Id 4107',2994.40,0.00,0.00,3.94,0.00,'2022-07-21 16:47:44','',''),(4023,'21','227','1',1,'Retail Sale Id 4108',38000.00,0.00,0.00,50.00,0.00,'2022-07-21 16:48:47','',''),(4024,'21','227','1',1,'Retail Sale Id 4109',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 16:52:05','',''),(4025,'21','227','1',1,'Retail Sale Id 4110',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 16:52:54','',''),(4026,'21','227','1',1,'Retail Sale Id 4111',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 16:54:49','',''),(4027,'21','227','1',1,'Retail Sale Id 4112',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 17:06:47','',''),(4028,'21','227','1',1,'Retail Sale Id 4113',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 17:08:02','',''),(4029,'21','227','1',1,'Retail Sale Id 4114',1497.20,0.00,0.00,1.97,0.00,'2022-07-21 17:08:54','',''),(4030,'21','227','1',1,'Retail Sale Id 4115',4560.00,0.00,0.00,6.00,0.00,'2022-07-21 17:09:37','',''),(4031,'21','227','1',1,'Retail Sale Id 4116',995.60,0.00,0.00,1.31,0.00,'2022-07-21 17:10:18','',''),(4032,'21','227','1',1,'Retail Sale Id 4117',2280.00,0.00,0.00,3.00,0.00,'2022-07-21 17:10:58','',''),(4033,'21','227','1',1,'Retail Sale Id 4118',5320.00,0.00,0.00,7.00,0.00,'2022-07-21 17:12:03','',''),(4034,'21','227','1',1,'Retail Sale Id 4119',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 17:39:07','',''),(4035,'21','227','1',1,'Retail Sale Id 4120',5996.40,0.00,0.00,7.89,0.00,'2022-07-21 17:40:14','',''),(4036,'21','227','1',1,'Retail Sale Id 4121',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 17:42:17','',''),(4037,'21','227','1',1,'Retail Sale Id 4122',30400.00,0.00,0.00,40.00,0.00,'2022-07-21 17:42:51','',''),(4038,'21','227','1',1,'Retail Sale Id 4123',11400.00,0.00,0.00,15.00,0.00,'2022-07-21 17:44:52','',''),(4039,'21','227','1',1,'Retail Sale Id 4124',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 17:55:26','',''),(4040,'21','227','1',1,'Retail Sale Id 4125',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 17:56:14','',''),(4041,'21','227','1',1,'Retail Sale Id 4126',4993.20,0.00,0.00,6.57,0.00,'2022-07-21 17:57:03','',''),(4042,'21','227','1',1,'Retail Sale Id 4127',2994.40,0.00,0.00,3.94,0.00,'2022-07-21 17:57:46','',''),(4043,'21','227','1',1,'Retail Sale Id 4128',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 17:58:28','',''),(4044,'21','227','1',1,'Retail Sale Id 4129',995.60,0.00,0.00,1.31,0.00,'2022-07-21 18:00:40','',''),(4045,'21','227','1',1,'Retail Sale Id 4130',798.00,0.00,0.00,1.05,0.00,'2022-07-21 18:03:25','',''),(4046,'21','227','1',1,'Retail Sale Id 4131',995.60,0.00,0.00,1.31,0.00,'2022-07-21 18:05:12','',''),(4047,'21','227','1',1,'Retail Sale Id 4132',1497.20,0.00,0.00,1.97,0.00,'2022-07-21 18:11:09','',''),(4048,'21','227','1',1,'Retail Sale Id 4133',798.00,0.00,0.00,1.05,0.00,'2022-07-22 15:08:47','',''),(4049,'21','227','1',1,'Retail Sale Id 4134',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 15:10:00','',''),(4050,'21','227','1',1,'Retail Sale Id 4135',995.60,0.00,0.00,1.31,0.00,'2022-07-22 15:10:48','',''),(4051,'21','227','1',1,'Retail Sale Id 4136',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:32:24','',''),(4052,'21','227','1',1,'Retail Sale Id 4137',2994.40,0.00,0.00,3.94,0.00,'2022-07-22 16:34:19','',''),(4053,'21','227','1',1,'Retail Sale Id 4138',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 16:38:49','',''),(4054,'21','227','1',1,'Retail Sale Id 4139',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 16:39:26','',''),(4055,'21','227','1',1,'Retail Sale Id 4140',995.60,0.00,0.00,1.31,0.00,'2022-07-22 16:40:17','',''),(4056,'21','227','1',1,'Retail Sale Id 4141',1497.20,0.00,0.00,1.97,0.00,'2022-07-22 16:41:52','',''),(4057,'21','227','1',1,'Retail Sale Id 4142',3800.00,0.00,0.00,5.00,0.00,'2022-07-22 16:43:25','',''),(4058,'21','227','1',1,'Retail Sale Id 4143',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:44:39','',''),(4059,'21','227','1',1,'Retail Sale Id 4144',4993.20,0.00,0.00,6.57,0.00,'2022-07-22 16:45:49','',''),(4060,'21','227','1',1,'Retail Sale Id 4145',2280.00,0.00,0.00,3.00,0.00,'2022-07-22 16:47:02','',''),(4061,'21','227','1',1,'Retail Sale Id 4146',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 16:49:02','',''),(4062,'21','227','1',1,'Retail Sale Id 4147',3800.00,0.00,0.00,5.00,0.00,'2022-07-22 16:51:09','',''),(4063,'21','227','1',1,'Retail Sale Id 4148',2280.00,0.00,0.00,3.00,0.00,'2022-07-22 16:51:53','',''),(4064,'21','227','1',1,'Retail Sale Id 4149',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 16:52:58','',''),(4065,'21','227','1',1,'Retail Sale Id 4150',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:54:12','',''),(4066,'21','227','1',1,'Retail Sale Id 4151',12160.00,0.00,0.00,16.00,0.00,'2022-07-22 16:56:08','',''),(4067,'21','227','1',1,'Retail Sale Id 4152',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:56:59','',''),(4068,'21','227','1',1,'Retail Sale Id 4153',2280.00,0.00,0.00,3.00,0.00,'2022-07-22 16:57:44','',''),(4069,'21','227','1',1,'Retail Sale Id 4154',995.60,0.00,0.00,1.31,0.00,'2022-07-22 17:00:19','',''),(4070,'21','227','1',1,'Retail Sale Id 4155',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 17:01:02','',''),(4071,'21','227','1',1,'Retail Sale Id 4156',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:01:53','',''),(4072,'21','227','1',1,'Retail Sale Id 4157',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 17:02:25','',''),(4073,'21','227','1',1,'Retail Sale Id 4158',995.60,0.00,0.00,1.31,0.00,'2022-07-22 17:03:09','',''),(4074,'21','227','1',1,'Retail Sale Id 4159',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:04:11','',''),(4075,'21','227','1',1,'Retail Sale Id 4160',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 17:05:13','',''),(4076,'21','227','1',1,'Retail Sale Id 4162',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:06:18','',''),(4077,'21','227','1',1,'Retail Sale Id 4164',38000.00,0.00,0.00,50.00,0.00,'2022-07-22 17:09:12','',''),(4078,'21','227','1',1,'Retail Sale Id 4165',4993.20,0.00,0.00,6.57,0.00,'2022-07-22 17:10:50','',''),(4079,'21','227','1',1,'Retail Sale Id 4166',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 17:11:26','',''),(4080,'21','227','1',1,'Retail Sale Id 4167',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:12:16','',''),(4081,'21','227','1',1,'Retail Sale Id 4168',19000.00,0.00,0.00,25.00,0.00,'2022-07-22 17:13:21','',''),(4082,'21','227','1',1,'Retail Sale Id 4169',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:13:59','',''),(4083,'21','227','1',1,'Retail Sale Id 4170',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 17:21:49','',''),(4084,'21','227','1',1,'Retail Sale Id 4171',494.00,0.00,0.00,0.65,0.00,'2022-07-23 10:59:06','',''),(4085,'21','227','1',1,'Retail Sale Id 4172',3800.00,0.00,0.00,5.00,0.00,'2022-07-23 11:01:02','',''),(4086,'21','227','1',1,'Retail Sale Id 4173',4560.00,0.00,0.00,6.00,0.00,'2022-07-23 11:01:42','',''),(4087,'21','227','1',1,'Retail Sale Id 4174',3040.00,0.00,0.00,4.00,0.00,'2022-07-23 11:03:29','',''),(4088,'21','227','1',1,'Retail Sale Id 4175',3997.60,0.00,0.00,5.26,0.00,'2022-07-23 11:04:07','',''),(4089,'21','227','1',1,'Retail Sale Id 4176',19000.00,0.00,0.00,25.00,0.00,'2022-07-23 11:05:20','',''),(4090,'21','227','1',1,'Retail Sale Id 4177',995.60,0.00,0.00,1.31,0.00,'2022-07-23 11:05:58','',''),(4091,'21','227','1',1,'Retail Sale Id 4178',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 11:06:56','',''),(4092,'21','227','1',1,'Retail Sale Id 4179',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 11:07:50','',''),(4093,'21','227','1',1,'Retail Sale Id 4180',494.00,0.00,0.00,0.65,0.00,'2022-07-23 11:08:39','',''),(4094,'21','227','1',1,'Retail Sale Id 4181',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 11:10:36','',''),(4095,'21','227','1',1,'Retail Sale Id 4181',3800.00,0.00,0.00,5.00,0.00,'2022-07-23 11:10:36','',''),(4096,'21','227','1',1,'Retail Sale Id 4182',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 11:12:08','',''),(4097,'21','227','1',1,'Retail Sale Id 4183',1520.00,0.00,0.00,2.00,0.00,'2022-07-23 11:12:51','',''),(4098,'21','227','1',1,'Retail Sale Id 4184',2994.40,0.00,0.00,3.94,0.00,'2022-07-23 11:14:01','',''),(4099,'21','227','1',1,'Retail Sale Id 4185',1193.20,0.00,0.00,1.57,0.00,'2022-07-23 11:15:38','',''),(4100,'21','227','1',1,'Retail Sale Id 4186',4993.20,0.00,0.00,6.57,0.00,'2022-07-23 11:17:00','',''),(4101,'21','227','1',1,'Retail Sale Id 4187',4560.00,0.00,0.00,6.00,0.00,'2022-07-23 11:17:48','',''),(4102,'21','227','1',1,'Retail Sale Id 4188',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 11:18:33','',''),(4103,'21','227','1',1,'Retail Sale Id 4189',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 11:19:19','',''),(4104,'21','227','1',1,'Retail Sale Id 4190',11400.00,0.00,0.00,15.00,0.00,'2022-07-23 11:20:40','',''),(4105,'21','227','1',1,'Retail Sale Id 4191',19000.00,0.00,0.00,25.00,0.00,'2022-07-23 11:22:14','',''),(4106,'21','227','1',1,'Retail Sale Id 4193',4499.20,0.00,0.00,5.92,0.00,'2022-07-23 11:25:29','',''),(4107,'21','227','1',1,'Retail Sale Id 4194',2994.40,0.00,0.00,3.94,0.00,'2022-07-23 11:56:12','',''),(4108,'21','227','1',1,'Retail Sale Id 4195',3093.20,0.00,0.00,4.07,0.00,'2022-07-23 12:01:41','',''),(4109,'21','227','1',1,'Retail Sale Id 4196',494.00,0.00,0.00,0.65,0.00,'2022-07-23 12:02:37','',''),(4110,'21','227','1',1,'Retail Sale Id 4196',798.00,0.00,0.00,1.05,0.00,'2022-07-23 12:02:37','',''),(4111,'21','227','1',1,'Retail Sale Id 4197',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 12:10:56','',''),(4112,'21','227','1',1,'Retail Sale Id 4198',8496.80,0.00,0.00,11.18,0.00,'2022-07-23 14:40:03','',''),(4113,'21','227','1',1,'Retail Sale Id 4199',4795.60,0.00,0.00,6.31,0.00,'2022-07-23 14:50:04','',''),(4114,'21','227','1',1,'Retail Sale Id 4200',4993.20,0.00,0.00,6.57,0.00,'2022-07-23 14:51:41','',''),(4115,'21','227','1',1,'Retail Sale Id 4201',2994.40,0.00,0.00,3.94,0.00,'2022-07-23 14:55:19','',''),(4116,'21','227','1',1,'Retail Sale Id 4202',4499.20,0.00,0.00,5.92,0.00,'2022-07-23 14:57:39','',''),(4117,'21','227','1',1,'Retail Sale Id 4203',2492.80,0.00,0.00,3.28,0.00,'2022-07-23 15:00:05','',''),(4118,'21','227','1',1,'Retail Sale Id 4204',3496.00,0.00,0.00,4.60,0.00,'2022-07-23 15:03:57','',''),(4119,'21','227','1',1,'Retail Sale Id 4205',4993.20,0.00,0.00,6.57,0.00,'2022-07-23 15:05:02','',''),(4120,'21','227','1',1,'Retail Sale Id 4206',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 15:07:24','',''),(4121,'21','227','1',1,'Retail Sale Id 4207',3800.00,0.00,0.00,5.00,0.00,'2022-07-23 15:10:30','',''),(4122,'21','227','1',1,'Retail Sale Id 4208',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 15:11:53','',''),(4123,'21','227','1',1,'Retail Sale Id 4209',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 15:13:00','',''),(4124,'21','227','1',1,'Retail Sale Id 4210',3800.00,0.00,0.00,5.00,0.00,'2022-07-23 15:14:13','',''),(4125,'21','227','1',1,'Retail Sale Id 4211',995.60,0.00,0.00,1.31,0.00,'2022-07-23 15:15:17','',''),(4126,'21','227','1',1,'Retail Sale Id 4212',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 15:18:34','',''),(4127,'21','227','1',1,'Retail Sale Id 4213',798.00,0.00,0.00,1.05,0.00,'2022-07-23 15:20:41','',''),(4128,'21','227','1',1,'Retail Sale Id 4214',798.00,0.00,0.00,1.05,0.00,'2022-07-23 15:21:34','',''),(4129,'21','227','1',1,'Retail Sale Id 4216',798.00,0.00,0.00,1.05,0.00,'2022-07-23 15:22:44','',''),(4130,'21','227','1',1,'Retail Sale Id 4217',995.60,0.00,0.00,1.31,0.00,'2022-07-23 15:23:43','',''),(4131,'21','227','1',1,'Retail Sale Id 4218',2492.80,0.00,0.00,3.28,0.00,'2022-07-23 15:24:42','',''),(4132,'21','227','1',1,'Retail Sale Id 4219',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 15:29:26','',''),(4133,'21','227','1',1,'Retail Sale Id 4220',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 15:35:05','',''),(4134,'21','227','1',1,'Retail Sale Id 4221',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 15:52:37','',''),(4135,'21','227','1',1,'Retail Sale Id 4222',2994.40,0.00,0.00,3.94,0.00,'2022-07-23 15:53:48','',''),(4136,'21','227','1',1,'Retail Sale Id 4223',4560.00,0.00,0.00,6.00,0.00,'2022-07-23 15:57:06','',''),(4137,'21','227','1',1,'Retail Sale Id 4224',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 15:58:56','',''),(4138,'21','227','1',1,'Retail Sale Id 4225',19000.00,0.00,0.00,25.00,0.00,'2022-07-23 15:59:48','',''),(4139,'21','227','1',1,'Retail Sale Id 4226',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 16:00:34','',''),(4140,'21','227','1',1,'Retail Sale Id 4227',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 16:01:26','',''),(4141,'21','227','1',1,'Retail Sale Id 4227',3040.00,0.00,0.00,4.00,0.00,'2022-07-23 16:01:26','',''),(4142,'21','227','1',1,'Retail Sale Id 4215',798.00,0.00,0.00,1.05,0.00,'2022-07-23 16:02:05','',''),(4143,'21','227','1',1,'Retail Sale Id 4228',995.60,0.00,0.00,1.31,0.00,'2022-07-23 16:05:12','',''),(4144,'21','227','1',1,'Retail Sale Id 4229',5996.40,0.00,0.00,7.89,0.00,'2022-07-23 16:06:44','',''),(4145,'21','227','1',1,'Retail Sale Id 4230',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 16:07:49','',''),(4146,'21','227','1',1,'Retail Sale Id 4231',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 16:09:33','',''),(4147,'21','227','1',1,'Retail Sale Id 4232',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 16:11:58','',''),(4148,'21','227','1',1,'Retail Sale Id 4232',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 16:11:58','',''),(4149,'21','227','1',1,'Retail Sale Id 4232',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 16:11:58','',''),(4150,'21','227','1',1,'Retail Sale Id 4232',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 16:11:58','',''),(4151,'21','227','1',1,'Retail Sale Id 4232',2796.80,0.00,0.00,3.68,0.00,'2022-07-23 16:11:58','',''),(4152,'21','227','1',1,'Retail Sale Id 4233',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 16:13:28','',''),(4153,'21','227','1',1,'Retail Sale Id 4234',2796.80,0.00,0.00,3.68,0.00,'2022-07-23 16:19:38','',''),(4154,'21','227','1',1,'Retail Sale Id 4235',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 16:20:45','',''),(4155,'21','227','1',1,'Retail Sale Id 4236',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 16:25:50','',''),(4156,'21','227','1',1,'Retail Sale Id 4237',1520.00,0.00,0.00,2.00,0.00,'2022-07-23 16:27:13','',''),(4157,'21','227','1',1,'Retail Sale Id 4238',3800.00,0.00,0.00,5.00,0.00,'2022-07-23 16:30:49','',''),(4158,'21','227','1',1,'Retail Sale Id 4239',995.60,0.00,0.00,1.31,0.00,'2022-07-23 16:31:48','',''),(4159,'21','227','1',1,'Retail Sale Id 4240',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 16:35:24','',''),(4160,'21','227','1',1,'Retail Sale Id 4241',494.00,0.00,0.00,0.65,0.00,'2022-07-23 16:36:13','',''),(4161,'21','227','1',1,'Retail Sale Id 4242',3800.00,0.00,0.00,5.00,0.00,'2022-07-23 16:40:37','',''),(4162,'21','227','1',1,'Retail Sale Id 4243',995.60,0.00,0.00,1.31,0.00,'2022-07-23 16:43:46','',''),(4163,'21','227','1',1,'Retail Sale Id 4244',1497.20,0.00,0.00,1.97,0.00,'2022-07-23 16:44:51','',''),(4164,'21','227','1',1,'Retail Sale Id 4245',38000.00,0.00,0.00,50.00,0.00,'2022-07-23 16:47:46','',''),(4165,'21','227','1',1,'Retail Sale Id 4246',995.60,0.00,0.00,1.31,0.00,'2022-07-23 16:48:15','',''),(4166,'21','227','1',1,'Retail Sale Id 4247',798.00,0.00,0.00,1.05,0.00,'2022-07-23 16:49:26','',''),(4167,'21','227','1',1,'Retail Sale Id 4248',2994.40,0.00,0.00,3.94,0.00,'2022-07-23 16:50:30','',''),(4168,'21','227','1',1,'Retail Sale Id 4249',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 16:53:46','',''),(4169,'21','227','1',1,'Retail Sale Id 4250',3800.00,0.00,0.00,5.00,0.00,'2022-07-23 16:55:55','',''),(4170,'21','227','1',1,'Retail Sale Id 4251',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 16:58:18','',''),(4171,'21','227','1',1,'Retail Sale Id 4252',995.60,0.00,0.00,1.31,0.00,'2022-07-23 16:59:00','',''),(4172,'21','227','1',1,'Retail Sale Id 4253',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 17:02:44','',''),(4173,'21','227','1',1,'Retail Sale Id 4254',494.00,0.00,0.00,0.65,0.00,'2022-07-23 17:03:31','',''),(4174,'21','227','1',1,'Retail Sale Id 4255',1398.40,0.00,0.00,1.84,0.00,'2022-07-23 17:04:41','',''),(4175,'21','227','1',1,'Retail Sale Id 4256',3040.00,0.00,0.00,4.00,0.00,'2022-07-23 17:05:28','',''),(4176,'21','227','1',1,'Retail Sale Id 4257',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 17:06:07','',''),(4177,'21','227','1',1,'Retail Sale Id 4258',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 17:12:26','',''),(4178,'21','227','1',1,'Retail Sale Id 4259',995.60,0.00,0.00,1.31,0.00,'2022-07-23 17:16:47','',''),(4179,'21','227','1',1,'Retail Sale Id 4260',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 17:17:54','',''),(4180,'21','227','1',1,'Retail Sale Id 4261',7995.20,0.00,0.00,10.52,0.00,'2022-07-23 17:19:03','',''),(4181,'21','227','1',1,'Retail Sale Id 4262',2994.40,0.00,0.00,3.94,0.00,'2022-07-23 17:25:19','',''),(4182,'21','227','1',1,'Retail Sale Id 4263',995.60,0.00,0.00,1.31,0.00,'2022-07-23 17:26:29','',''),(4183,'21','227','1',1,'Retail Sale Id 4264',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 17:27:01','',''),(4184,'21','227','1',1,'Retail Sale Id 4265',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 17:28:41','',''),(4185,'21','227','1',1,'Retail Sale Id 4266',2492.80,0.00,0.00,3.28,0.00,'2022-07-23 17:30:09','',''),(4186,'21','227','1',1,'Retail Sale Id 4267',798.00,0.00,0.00,1.05,0.00,'2022-07-23 17:34:26','',''),(4187,'21','227','1',1,'Retail Sale Id 4267',995.60,0.00,0.00,1.31,0.00,'2022-07-23 17:34:26','',''),(4188,'21','227','1',1,'Retail Sale Id 4268',4560.00,0.00,0.00,6.00,0.00,'2022-07-23 17:35:44','',''),(4189,'21','227','1',1,'Retail Sale Id 4269',3040.00,0.00,0.00,4.00,0.00,'2022-07-23 17:37:01','',''),(4190,'21','227','1',1,'Retail Sale Id 4270',995.60,0.00,0.00,1.31,0.00,'2022-07-23 17:38:09','',''),(4191,'21','227','1',1,'Retail Sale Id 4271',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 17:39:31','',''),(4192,'21','227','1',1,'Retail Sale Id 4272',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 17:40:43','',''),(4193,'21','227','1',1,'Retail Sale Id 4273',995.60,0.00,0.00,1.31,0.00,'2022-07-23 17:42:12','',''),(4194,'21','227','1',1,'Retail Sale Id 4274',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 17:42:56','',''),(4195,'21','227','1',1,'Retail Sale Id 4275',798.00,0.00,0.00,1.05,0.00,'2022-07-23 17:44:02','',''),(4196,'21','227','1',1,'Retail Sale Id 4276',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 17:45:33','',''),(4197,'21','227','1',1,'Retail Sale Id 4277',1998.80,0.00,0.00,2.63,0.00,'2022-07-23 17:46:30','',''),(4198,'21','227','1',1,'Retail Sale Id 4278',995.60,0.00,0.00,1.31,0.00,'2022-07-23 17:47:22','',''),(4199,'21','227','1',1,'Retail Sale Id 4279',3496.00,0.00,0.00,4.60,0.00,'2022-07-23 17:51:13','',''),(4200,'21','227','1',1,'Retail Sale Id 4280',995.60,0.00,0.00,1.31,0.00,'2022-07-24 10:12:24','',''),(4201,'21','227','1',1,'Retail Sale Id 4281',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 10:14:26','',''),(4202,'21','227','1',1,'Retail Sale Id 4282',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 10:15:04','',''),(4203,'21','227','1',1,'Retail Sale Id 4283',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 10:16:28','',''),(4204,'21','227','1',1,'Retail Sale Id 4284',4499.20,0.00,0.00,5.92,0.00,'2022-07-24 10:17:32','',''),(4205,'21','227','1',1,'Retail Sale Id 4285',798.00,0.00,0.00,1.05,0.00,'2022-07-24 10:18:15','',''),(4206,'21','227','1',1,'Retail Sale Id 4286',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 10:19:37','',''),(4207,'21','227','1',1,'Retail Sale Id 4287',2492.80,0.00,0.00,3.28,0.00,'2022-07-24 10:20:17','',''),(4208,'21','227','1',1,'Retail Sale Id 4288',2994.40,0.00,0.00,3.94,0.00,'2022-07-24 10:21:07','',''),(4209,'21','227','1',1,'Retail Sale Id 4289',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 10:21:44','',''),(4210,'21','227','1',1,'Retail Sale Id 4290',4499.20,0.00,0.00,5.92,0.00,'2022-07-24 10:22:40','',''),(4211,'21','227','1',1,'Retail Sale Id 4291',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 10:23:20','',''),(4212,'21','227','1',1,'Retail Sale Id 4292',995.60,0.00,0.00,1.31,0.00,'2022-07-24 10:24:06','',''),(4213,'21','227','1',1,'Retail Sale Id 4293',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 10:24:46','',''),(4214,'21','227','1',1,'Retail Sale Id 4294',2492.80,0.00,0.00,3.28,0.00,'2022-07-24 10:25:24','',''),(4215,'21','227','1',1,'Retail Sale Id 4295',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 10:25:58','',''),(4216,'21','227','1',1,'Retail Sale Id 4296',995.60,0.00,0.00,1.31,0.00,'2022-07-24 10:26:40','',''),(4217,'21','227','1',1,'Retail Sale Id 4297',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 10:27:33','',''),(4218,'21','227','1',1,'Retail Sale Id 4298',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 10:28:10','',''),(4219,'21','227','1',1,'Retail Sale Id 4299',6999.60,0.00,0.00,9.21,0.00,'2022-07-24 10:28:41','',''),(4220,'21','227','1',1,'Retail Sale Id 4300',3997.60,0.00,0.00,5.26,0.00,'2022-07-24 10:30:04','',''),(4221,'21','227','1',1,'Retail Sale Id 4300',3997.60,0.00,0.00,5.26,0.00,'2022-07-24 10:30:04','',''),(4222,'21','227','1',1,'Retail Sale Id 4301',2994.40,0.00,0.00,3.94,0.00,'2022-07-24 10:30:55','',''),(4223,'21','227','1',1,'Retail Sale Id 4302',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 10:31:47','',''),(4224,'21','227','1',1,'Retail Sale Id 4304',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 10:33:35','',''),(4225,'21','227','1',1,'Retail Sale Id 4305',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 10:34:34','',''),(4226,'21','227','1',1,'Retail Sale Id 4303',995.60,0.00,0.00,1.31,0.00,'2022-07-24 10:35:14','',''),(4227,'21','227','1',1,'Retail Sale Id 4306',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 10:36:43','',''),(4228,'21','227','1',1,'Retail Sale Id 4307',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 10:37:51','',''),(4229,'21','227','1',1,'Retail Sale Id 4308',995.60,0.00,0.00,1.31,0.00,'2022-07-24 10:40:22','',''),(4230,'21','227','1',1,'Retail Sale Id 4309',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 10:44:41','',''),(4231,'21','227','1',1,'Retail Sale Id 4310',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 10:46:38','',''),(4232,'21','227','1',1,'Retail Sale Id 4311',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 10:51:59','',''),(4233,'21','227','1',1,'Retail Sale Id 4312',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 10:54:27','',''),(4234,'21','227','1',1,'Retail Sale Id 4313',1793.60,0.00,0.00,2.36,0.00,'2022-07-24 10:55:42','',''),(4235,'21','227','1',1,'Retail Sale Id 4314',995.60,0.00,0.00,1.31,0.00,'2022-07-24 10:56:24','',''),(4236,'21','227','1',1,'Retail Sale Id 4315',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 11:14:26','',''),(4237,'21','227','1',1,'Retail Sale Id 4316',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 11:16:28','',''),(4238,'21','227','1',1,'Retail Sale Id 4317',995.60,0.00,0.00,1.31,0.00,'2022-07-24 11:19:41','',''),(4239,'21','227','1',1,'Retail Sale Id 4318',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 11:35:41','',''),(4240,'21','227','1',1,'Retail Sale Id 4319',494.00,0.00,0.00,0.65,0.00,'2022-07-24 11:36:34','',''),(4241,'21','227','1',1,'Retail Sale Id 4320',2994.40,0.00,0.00,3.94,0.00,'2022-07-24 11:38:18','',''),(4242,'21','227','1',1,'Retail Sale Id 4321',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 11:43:05','',''),(4243,'21','227','1',1,'Retail Sale Id 4322',4848.80,0.00,0.00,6.38,0.00,'2022-07-24 11:52:35','',''),(4244,'21','227','1',1,'Retail Sale Id 4323',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 11:53:35','',''),(4245,'21','227','1',1,'Retail Sale Id 4324',1520.00,0.00,0.00,2.00,0.00,'2022-07-24 11:54:18','',''),(4246,'21','227','1',1,'Retail Sale Id 4325',995.60,0.00,0.00,1.31,0.00,'2022-07-24 11:55:23','',''),(4247,'21','227','1',1,'Retail Sale Id 4326',1094.40,0.00,0.00,1.44,0.00,'2022-07-24 11:56:13','',''),(4248,'21','227','1',1,'Retail Sale Id 4327',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 11:59:09','',''),(4249,'21','227','1',1,'Retail Sale Id 4328',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 12:10:52','',''),(4250,'21','227','1',1,'Retail Sale Id 4329',494.00,0.00,0.00,0.65,0.00,'2022-07-24 12:11:59','',''),(4251,'21','227','1',1,'Retail Sale Id 4330',2492.80,0.00,0.00,3.28,0.00,'2022-07-24 12:18:43','',''),(4252,'21','227','1',1,'Retail Sale Id 4331',995.60,0.00,0.00,1.31,0.00,'2022-07-24 12:20:12','',''),(4253,'21','227','1',1,'Retail Sale Id 4333',995.60,0.00,0.00,1.31,0.00,'2022-07-24 12:25:11','',''),(4254,'21','227','1',1,'Retail Sale Id 4334',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 12:27:46','',''),(4255,'21','227','1',1,'Retail Sale Id 4335',798.00,0.00,0.00,1.05,0.00,'2022-07-24 12:31:25','',''),(4256,'21','227','1',1,'Retail Sale Id 4336',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:33:07','',''),(4257,'21','227','1',1,'Retail Sale Id 4337',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 12:41:41','',''),(4258,'21','227','1',1,'Retail Sale Id 4338',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 12:44:38','',''),(4259,'21','227','1',1,'Retail Sale Id 4339',699.20,0.00,0.00,0.92,0.00,'2022-07-24 12:48:22','',''),(4260,'21','227','1',1,'Retail Sale Id 4340',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 12:49:22','',''),(4261,'21','227','1',1,'Retail Sale Id 4341',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 13:00:49','',''),(4262,'21','227','1',1,'Retail Sale Id 4342',995.60,0.00,0.00,1.31,0.00,'2022-07-24 13:02:32','',''),(4263,'21','227','1',1,'Retail Sale Id 4343',896.80,0.00,0.00,1.18,0.00,'2022-07-24 13:09:44','',''),(4264,'21','227','1',1,'Retail Sale Id 4344',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 13:17:43','',''),(4265,'21','227','1',1,'Retail Sale Id 4345',4499.20,0.00,0.00,5.92,0.00,'2022-07-24 13:23:55','',''),(4266,'21','227','1',1,'Retail Sale Id 4346',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 13:25:54','',''),(4267,'21','227','1',1,'Retail Sale Id 4347',995.60,0.00,0.00,1.31,0.00,'2022-07-24 13:27:07','',''),(4268,'21','227','1',1,'Retail Sale Id 4348',2994.40,0.00,0.00,3.94,0.00,'2022-07-24 14:50:19','',''),(4269,'21','227','1',1,'Retail Sale Id 4349',38000.00,0.00,0.00,50.00,0.00,'2022-07-24 14:51:27','',''),(4270,'21','227','1',1,'Retail Sale Id 4350',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:52:22','',''),(4271,'21','227','1',1,'Retail Sale Id 4351',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 14:54:49','',''),(4272,'21','227','1',1,'Retail Sale Id 4352',11400.00,0.00,0.00,15.00,0.00,'2022-07-24 14:56:40','',''),(4273,'21','227','1',1,'Retail Sale Id 4353',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 14:57:24','',''),(4274,'21','227','1',1,'Retail Sale Id 4354',995.60,0.00,0.00,1.31,0.00,'2022-07-24 14:58:43','',''),(4275,'21','227','1',1,'Retail Sale Id 4355',760.00,0.00,0.00,1.00,0.00,'2022-07-24 15:00:09','',''),(4276,'21','227','1',1,'Retail Sale Id 4356',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 15:00:53','',''),(4277,'21','227','1',1,'Retail Sale Id 4357',2492.80,0.00,0.00,3.28,0.00,'2022-07-24 15:01:29','',''),(4278,'21','227','1',1,'Retail Sale Id 4358',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 15:06:40','',''),(4279,'21','227','1',1,'Retail Sale Id 4359',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 15:07:10','',''),(4280,'21','227','1',1,'Retail Sale Id 4360',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 15:08:31','',''),(4281,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3822800.00,5030.00,0.00,0.00,'2022-07-25 16:35:52','',''),(4282,'21','227',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,3000.00,0.00,'2022-07-25 16:37:24','',''),(4283,'21','227','1',1,'Received from bridging 12',0.00,0.00,3000.00,0.00,0.00,'2022-07-25 16:37:24','',''),(4284,'21','227','1',1,'Retail Sale Id 4361',1497.20,0.00,0.00,1.97,0.00,'2022-07-25 16:39:04','',''),(4285,'21','227','1',1,'Retail Sale Id 4362',995.60,0.00,0.00,1.31,0.00,'2022-07-25 16:39:51','',''),(4286,'21','227','1',1,'Retail Sale Id 4363',3997.60,0.00,0.00,5.26,0.00,'2022-07-25 16:40:46','',''),(4287,'21','227','1',1,'Retail Sale Id 4364',2492.80,0.00,0.00,3.28,0.00,'2022-07-25 16:41:32','',''),(4288,'21','227','1',1,'Retail Sale Id 4365',6840.00,0.00,0.00,9.00,0.00,'2022-07-25 16:42:29','',''),(4289,'21','227','1',1,'Retail Sale Id 4366',995.60,0.00,0.00,1.31,0.00,'2022-07-25 16:43:18','',''),(4290,'21','227','1',1,'Retail Sale Id 4367',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 16:44:02','',''),(4291,'21','227','1',1,'Retail Sale Id 4368',4499.20,0.00,0.00,5.92,0.00,'2022-07-25 16:45:19','',''),(4292,'21','227','1',1,'Retail Sale Id 4369',4993.20,0.00,0.00,6.57,0.00,'2022-07-25 16:46:02','',''),(4293,'21','227','1',1,'Retail Sale Id 4370',1998.80,0.00,0.00,2.63,0.00,'2022-07-25 16:46:48','',''),(4294,'21','227','1',1,'Retail Sale Id 4371',995.60,0.00,0.00,1.31,0.00,'2022-07-25 16:47:27','',''),(4295,'21','227','1',1,'Retail Sale Id 4372',1998.80,0.00,0.00,2.63,0.00,'2022-07-25 16:49:34','',''),(4296,'21','227','1',1,'Retail Sale Id 4373',798.00,0.00,0.00,1.05,0.00,'2022-07-25 16:50:29','',''),(4297,'21','227','1',1,'Retail Sale Id 4374',1998.80,0.00,0.00,2.63,0.00,'2022-07-25 16:51:23','',''),(4298,'21','227','1',1,'Retail Sale Id 4375',1998.80,0.00,0.00,2.63,0.00,'2022-07-25 16:52:05','',''),(4299,'21','227','1',1,'Retail Sale Id 4376',798.00,0.00,0.00,1.05,0.00,'2022-07-25 16:52:46','',''),(4300,'21','227','1',1,'Retail Sale Id 4377',995.60,0.00,0.00,1.31,0.00,'2022-07-25 16:53:31','',''),(4301,'21','227','1',1,'Retail Sale Id 4378',995.60,0.00,0.00,1.31,0.00,'2022-07-25 16:54:10','',''),(4302,'21','227','1',1,'Retail Sale Id 4379',1497.20,0.00,0.00,1.97,0.00,'2022-07-25 16:54:50','',''),(4303,'21','227','1',1,'Retail Sale Id 4380',2994.40,0.00,0.00,3.94,0.00,'2022-07-25 16:55:53','',''),(4304,'21','227','1',1,'Retail Sale Id 4382',1998.80,0.00,0.00,2.63,0.00,'2022-07-25 16:56:38','',''),(4305,'21','227','1',1,'Retail Sale Id 4383',3997.60,0.00,0.00,5.26,0.00,'2022-07-25 16:57:47','',''),(4306,'21','227','1',1,'Retail Sale Id 4384',995.60,0.00,0.00,1.31,0.00,'2022-07-25 16:58:28','',''),(4307,'21','227','1',1,'Retail Sale Id 4385',995.60,0.00,0.00,1.31,0.00,'2022-07-25 16:59:31','',''),(4308,'21','227','1',1,'Retail Sale Id 4386',1900.00,0.00,0.00,2.50,0.00,'2022-07-25 17:04:54','',''),(4309,'21','227','1',1,'Retail Sale Id 4387',1497.20,0.00,0.00,1.97,0.00,'2022-07-25 17:06:05','',''),(4310,'21','227','1',1,'Retail Sale Id 4388',995.60,0.00,0.00,1.31,0.00,'2022-07-25 17:06:57','',''),(4311,'21','227','1',1,'Retail Sale Id 4389',2295.20,0.00,0.00,3.02,0.00,'2022-07-25 17:09:22','',''),(4312,'21','227','1',1,'Retail Sale Id 4391',1998.80,0.00,0.00,2.63,0.00,'2022-07-25 17:15:34','',''),(4313,'21','227','1',1,'Retail Sale Id 4392',4499.20,0.00,0.00,5.92,0.00,'2022-07-25 17:26:44','',''),(4314,'21','227','1',1,'Retail Sale Id 4393',995.60,0.00,0.00,1.31,0.00,'2022-07-25 17:35:53','',''),(4315,'21','227','1',1,'Retail Sale Id 4394',760.00,0.00,0.00,1.00,0.00,'2022-07-25 17:37:19','',''),(4316,'21','227','1',1,'Retail Sale Id 4395',3997.60,0.00,0.00,5.26,0.00,'2022-07-25 17:41:29','',''),(4317,'21','227','1',1,'Retail Sale Id 4396',896.80,0.00,0.00,1.18,0.00,'2022-07-25 17:42:47','',''),(4318,'21','227','1',1,'Retail Sale Id 4397',2994.40,0.00,0.00,3.94,0.00,'2022-07-25 17:43:31','',''),(4319,'21','227','1',1,'Retail Sale Id 4398',8496.80,0.00,0.00,11.18,0.00,'2022-07-25 17:45:07','',''),(4320,'21','227','1',1,'Retail Sale Id 4399',1998.80,0.00,0.00,2.63,0.00,'2022-07-25 17:47:12','',''),(4321,'21','227','1',1,'Retail Sale Id 4400',1193.20,0.00,0.00,1.57,0.00,'2022-07-25 17:49:57','',''),(4322,'21','227','1',1,'Retail Sale Id 4400',1193.20,0.00,0.00,1.57,0.00,'2022-07-25 17:49:57','',''),(4323,'21','227','1',1,'Retail Sale Id 4401',2994.40,0.00,0.00,3.94,0.00,'2022-07-25 17:51:29','',''),(4324,'21','227','1',1,'Retail Sale Id 4402',1497.20,0.00,0.00,1.97,0.00,'2022-07-25 17:55:31','',''),(4325,'21','227','1',1,'Retail Sale Id 4403',494.00,0.00,0.00,0.65,0.00,'2022-07-25 17:56:20','',''),(4326,'21','227','1',1,'Retail Sale Id 4404',1193.20,0.00,0.00,1.57,0.00,'2022-07-25 17:57:21','',''),(4327,'21','227','1',1,'Retail Sale Id 4405',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 08:03:45','',''),(4328,'21','227','1',1,'Retail Sale Id 4406',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:05:08','',''),(4329,'21','227','1',1,'Retail Sale Id 4407',995.60,0.00,0.00,1.31,0.00,'2022-07-26 08:06:04','',''),(4330,'21','227','1',1,'Retail Sale Id 4408',2994.40,0.00,0.00,3.94,0.00,'2022-07-26 08:07:21','',''),(4331,'21','227','1',1,'Retail Sale Id 4409',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:08:26','',''),(4332,'21','227','1',1,'Retail Sale Id 4409',19000.00,0.00,0.00,25.00,0.00,'2022-07-26 08:08:26','',''),(4333,'21','227','1',1,'Retail Sale Id 4410',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 08:09:31','',''),(4334,'21','227','1',1,'Retail Sale Id 4411',7600.00,0.00,0.00,10.00,0.00,'2022-07-26 08:11:40','',''),(4335,'21','227','1',1,'Retail Sale Id 4412',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 08:13:24','',''),(4336,'21','227','1',1,'Retail Sale Id 4413',699.20,0.00,0.00,0.92,0.00,'2022-07-26 08:16:21','',''),(4337,'21','227','1',1,'Retail Sale Id 4413',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 08:16:21','',''),(4338,'21','227','1',1,'Retail Sale Id 4414',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:17:06','',''),(4339,'21','227','1',1,'Retail Sale Id 4415',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:17:58','',''),(4340,'21','227','1',1,'Retail Sale Id 4416',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 08:24:49','',''),(4341,'21','227','1',1,'Retail Sale Id 4417',2492.80,0.00,0.00,3.28,0.00,'2022-07-26 08:25:42','',''),(4342,'21','227','1',1,'Retail Sale Id 4418',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 08:27:25','',''),(4343,'21','227','1',1,'Retail Sale Id 4419',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 08:33:29','',''),(4344,'21','227','1',1,'Retail Sale Id 4420',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 08:37:42','',''),(4345,'21','227','1',1,'Retail Sale Id 4421',2994.40,0.00,0.00,3.94,0.00,'2022-07-26 08:55:11','',''),(4346,'21','227','1',1,'Retail Sale Id 4422',6999.60,0.00,0.00,9.21,0.00,'2022-07-26 08:57:58','',''),(4347,'21','227','1',1,'Retail Sale Id 4423',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 09:00:04','',''),(4348,'21','227','1',1,'Retail Sale Id 4424',995.60,0.00,0.00,1.31,0.00,'2022-07-26 09:02:52','',''),(4349,'21','227','1',1,'Retail Sale Id 4425',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 09:06:04','',''),(4350,'21','227','1',1,'Retail Sale Id 4426',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 09:09:06','',''),(4351,'21','227','1',1,'Retail Sale Id 4427',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 09:24:42','',''),(4352,'21','227','1',1,'Retail Sale Id 4428',1299.60,0.00,0.00,1.71,0.00,'2022-07-26 09:25:48','',''),(4353,'21','227','1',1,'Retail Sale Id 4429',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 09:26:41','',''),(4354,'21','227','1',1,'Retail Sale Id 4430',995.60,0.00,0.00,1.31,0.00,'2022-07-26 09:27:35','',''),(4355,'21','227','1',1,'Retail Sale Id 4431',995.60,0.00,0.00,1.31,0.00,'2022-07-26 09:28:24','',''),(4356,'21','227','1',1,'Retail Sale Id 4432',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 09:29:28','',''),(4357,'21','227','1',1,'Retail Sale Id 4433',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 09:30:25','',''),(4358,'21','227','1',1,'Retail Sale Id 4434',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 09:33:07','',''),(4359,'21','227','1',1,'Retail Sale Id 4435',2196.40,0.00,0.00,2.89,0.00,'2022-07-26 09:34:56','',''),(4360,'21','227','1',1,'Retail Sale Id 4436',995.60,0.00,0.00,1.31,0.00,'2022-07-26 09:40:43','',''),(4361,'21','227','1',1,'Retail Sale Id 4437',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 09:42:18','',''),(4362,'21','227','1',1,'Retail Sale Id 4438',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 09:43:43','',''),(4363,'21','227','1',1,'Retail Sale Id 4439',3496.00,0.00,0.00,4.60,0.00,'2022-07-26 09:46:41','',''),(4364,'21','227','1',1,'Retail Sale Id 4440',7600.00,0.00,0.00,10.00,0.00,'2022-07-26 09:49:01','',''),(4365,'21','227','1',1,'Retail Sale Id 4441',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 09:50:40','',''),(4366,'21','227','1',1,'Retail Sale Id 4442',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 09:54:49','',''),(4367,'21','227','1',1,'Retail Sale Id 4443',3997.60,0.00,0.00,5.26,0.00,'2022-07-26 10:04:23','',''),(4368,'21','227','1',1,'Retail Sale Id 4445',995.60,0.00,0.00,1.31,0.00,'2022-07-26 10:05:14','',''),(4369,'21','227','1',1,'Retail Sale Id 4446',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 10:07:33','',''),(4370,'21','227','1',1,'Retail Sale Id 4447',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 10:14:33','',''),(4371,'21','227','1',1,'Retail Sale Id 4448',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 10:25:42','',''),(4372,'21','227','1',1,'Retail Sale Id 4449',995.60,0.00,0.00,1.31,0.00,'2022-07-26 10:35:16','',''),(4373,'21','227','1',1,'Retail Sale Id 4450',2994.40,0.00,0.00,3.94,0.00,'2022-07-26 10:46:07','',''),(4374,'21','227','1',1,'Retail Sale Id 4451',995.60,0.00,0.00,1.31,0.00,'2022-07-26 10:57:01','',''),(4375,'21','227','1',1,'Retail Sale Id 4452',995.60,0.00,0.00,1.31,0.00,'2022-07-26 10:58:16','',''),(4376,'21','227','1',1,'Retail Sale Id 4453',995.60,0.00,0.00,1.31,0.00,'2022-07-26 11:05:38','',''),(4377,'21','227','1',1,'Retail Sale Id 4454',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 11:17:30','',''),(4378,'21','227','1',1,'Retail Sale Id 4455',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 11:18:55','',''),(4379,'21','227','1',1,'Retail Sale Id 4456',995.60,0.00,0.00,1.31,0.00,'2022-07-26 11:19:39','',''),(4380,'21','227','1',1,'Retail Sale Id 4457',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 11:21:14','',''),(4381,'21','227','1',1,'Retail Sale Id 4458',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 11:24:53','',''),(4382,'21','227','1',1,'Retail Sale Id 4459',995.60,0.00,0.00,1.31,0.00,'2022-07-26 11:27:09','',''),(4383,'21','227','1',1,'Retail Sale Id 4460',2994.40,0.00,0.00,3.94,0.00,'2022-07-26 11:28:40','',''),(4384,'21','227','1',1,'Retail Sale Id 4461',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 11:29:32','',''),(4385,'21','227','1',1,'Retail Sale Id 4462',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 11:34:45','',''),(4386,'21','227','1',1,'Retail Sale Id 4462',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 11:34:45','',''),(4387,'21','227','1',1,'Retail Sale Id 4463',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 11:42:50','',''),(4388,'21','227','1',1,'Retail Sale Id 4464',4499.20,0.00,0.00,5.92,0.00,'2022-07-26 11:43:55','',''),(4389,'21','227','1',1,'Retail Sale Id 4465',4993.20,0.00,0.00,6.57,0.00,'2022-07-26 11:46:09','',''),(4390,'21','227','1',1,'Retail Sale Id 4466',2492.80,0.00,0.00,3.28,0.00,'2022-07-26 11:52:29','',''),(4391,'21','227','1',1,'Retail Sale Id 4467',995.60,0.00,0.00,1.31,0.00,'2022-07-26 11:54:31','',''),(4392,'21','227','1',1,'Retail Sale Id 4468',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 11:55:22','',''),(4393,'21','227','1',1,'Retail Sale Id 4469',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 11:56:14','',''),(4394,'21','227','1',1,'Retail Sale Id 4470',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 12:04:25','',''),(4395,'21','227','1',1,'Retail Sale Id 4471',995.60,0.00,0.00,1.31,0.00,'2022-07-26 12:19:24','',''),(4396,'21','227','1',1,'Retail Sale Id 4472',1193.20,0.00,0.00,1.57,0.00,'2022-07-26 12:21:40','',''),(4397,'21','227','1',1,'Retail Sale Id 4473',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 12:25:06','',''),(4398,'21','227','1',1,'Retail Sale Id 4474',760.00,0.00,0.00,1.00,0.00,'2022-07-26 12:32:14','',''),(4399,'21','227','1',1,'Retail Sale Id 4475',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 12:35:48','',''),(4400,'21','227','1',1,'Retail Sale Id 4476',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 12:43:18','',''),(4401,'21','227','1',1,'Retail Sale Id 4477',2196.40,0.00,0.00,2.89,0.00,'2022-07-26 12:45:10','',''),(4402,'21','227','1',1,'Retail Sale Id 4478',995.60,0.00,0.00,1.31,0.00,'2022-07-26 12:51:02','',''),(4403,'21','227','1',1,'Retail Sale Id 4479',995.60,0.00,0.00,1.31,0.00,'2022-07-26 12:52:27','',''),(4404,'21','227','1',1,'Retail Sale Id 4480',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 12:58:45','',''),(4405,'21','227','1',1,'Retail Sale Id 4481',494.00,0.00,0.00,0.65,0.00,'2022-07-26 13:02:04','',''),(4406,'21','227','1',1,'Retail Sale Id 4482',760.00,0.00,0.00,1.00,0.00,'2022-07-26 13:02:47','',''),(4407,'21','227','1',1,'Retail Sale Id 4483',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 13:03:49','',''),(4408,'21','227','1',1,'Retail Sale Id 4485',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 13:26:15','',''),(4409,'21','227','1',1,'Retail Sale Id 4486',995.60,0.00,0.00,1.31,0.00,'2022-07-26 13:28:10','',''),(4410,'21','227','1',1,'Retail Sale Id 4487',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 13:29:52','',''),(4411,'21','227','1',1,'Retail Sale Id 4488',798.00,0.00,0.00,1.05,0.00,'2022-07-26 13:35:24','',''),(4412,'21','227','1',1,'Retail Sale Id 4489',995.60,0.00,0.00,1.31,0.00,'2022-07-26 13:36:10','',''),(4413,'21','227','1',1,'Retail Sale Id 4490',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 13:38:29','',''),(4414,'21','227','1',1,'Retail Sale Id 4491',2492.80,0.00,0.00,3.28,0.00,'2022-07-26 13:43:50','',''),(4415,'21','227','1',1,'Retail Sale Id 4492',6999.60,0.00,0.00,9.21,0.00,'2022-07-26 14:14:32','',''),(4416,'21','227','1',1,'Retail Sale Id 4493',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 14:18:47','',''),(4417,'21','227','1',1,'Retail Sale Id 4494',3040.00,0.00,0.00,4.00,0.00,'2022-07-26 14:26:26','',''),(4418,'21','227','1',1,'Retail Sale Id 4495',4499.20,0.00,0.00,5.92,0.00,'2022-07-26 14:27:00','',''),(4419,'21','227','1',1,'Retail Sale Id 4496',3997.60,0.00,0.00,5.26,0.00,'2022-07-26 14:28:15','',''),(4420,'21','227','1',1,'Retail Sale Id 4497',3997.60,0.00,0.00,5.26,0.00,'2022-07-26 14:34:28','',''),(4421,'21','227','1',1,'Retail Sale Id 4498',8496.80,0.00,0.00,11.18,0.00,'2022-07-26 14:45:56','',''),(4422,'21','227','1',1,'Retail Sale Id 4499',995.60,0.00,0.00,1.31,0.00,'2022-07-26 14:49:02','',''),(4423,'21','227','1',1,'Retail Sale Id 4500',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 14:49:56','',''),(4424,'21','227','1',1,'Retail Sale Id 4501',2994.40,0.00,0.00,3.94,0.00,'2022-07-26 14:58:19','',''),(4425,'21','227','1',1,'Retail Sale Id 4502',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 15:00:29','',''),(4426,'21','227','1',1,'Retail Sale Id 4503',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 15:03:20','',''),(4427,'21','227','1',1,'Retail Sale Id 4504',2492.80,0.00,0.00,3.28,0.00,'2022-07-26 15:09:49','',''),(4428,'21','227','1',1,'Retail Sale Id 4505',896.80,0.00,0.00,1.18,0.00,'2022-07-26 15:10:30','',''),(4429,'21','227','1',1,'Retail Sale Id 4506',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 15:14:26','',''),(4430,'21','227','1',1,'Retail Sale Id 4507',2492.80,0.00,0.00,3.28,0.00,'2022-07-26 15:23:33','',''),(4431,'21','227','1',1,'Retail Sale Id 4508',1520.00,0.00,0.00,2.00,0.00,'2022-07-26 15:26:25','',''),(4432,'21','227','1',1,'Retail Sale Id 4509',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 15:29:29','',''),(4433,'21','227','1',1,'Retail Sale Id 4510',2994.40,0.00,0.00,3.94,0.00,'2022-07-26 15:34:46','',''),(4434,'21','227','1',1,'Retail Sale Id 4511',494.00,0.00,0.00,0.65,0.00,'2022-07-26 15:37:34','',''),(4435,'21','227','1',1,'Retail Sale Id 4512',1520.00,0.00,0.00,2.00,0.00,'2022-07-26 15:43:01','',''),(4436,'21','227','1',1,'Retail Sale Id 4512',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 15:43:01','',''),(4437,'21','227','1',1,'Retail Sale Id 4513',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 15:44:37','',''),(4438,'21','227','1',1,'Retail Sale Id 4514',995.60,0.00,0.00,1.31,0.00,'2022-07-26 15:47:24','',''),(4439,'21','227','1',1,'Retail Sale Id 4515',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 15:48:30','',''),(4440,'21','227','1',1,'Retail Sale Id 4516',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 15:49:15','',''),(4441,'21','227','1',1,'Retail Sale Id 4517',995.60,0.00,0.00,1.31,0.00,'2022-07-26 15:53:25','',''),(4442,'21','227','1',1,'Retail Sale Id 4518',798.00,0.00,0.00,1.05,0.00,'2022-07-26 15:55:14','',''),(4443,'21','227','1',1,'Retail Sale Id 4519',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 15:56:07','',''),(4444,'21','227','1',1,'Retail Sale Id 4520',1596.00,0.00,0.00,2.10,0.00,'2022-07-26 15:58:36','',''),(4445,'21','227','1',1,'Retail Sale Id 4521',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 15:59:40','',''),(4446,'21','227','1',1,'Retail Sale Id 4522',995.60,0.00,0.00,1.31,0.00,'2022-07-26 16:02:47','',''),(4447,'21','227','1',1,'Retail Sale Id 4523',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 16:04:25','',''),(4448,'21','227','1',1,'Retail Sale Id 4524',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 16:05:04','',''),(4449,'21','227','1',1,'Retail Sale Id 4525',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 16:12:37','',''),(4450,'21','227','1',1,'Retail Sale Id 4525',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 16:12:37','',''),(4451,'21','227','1',1,'Retail Sale Id 4526',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 16:15:17','',''),(4452,'21','227','1',1,'Retail Sale Id 4527',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 16:16:02','',''),(4453,'21','227','1',1,'Retail Sale Id 4528',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 16:17:42','',''),(4454,'21','227','1',1,'Retail Sale Id 4529',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 16:19:37','',''),(4455,'21','227','1',1,'Retail Sale Id 4530',3040.00,0.00,0.00,4.00,0.00,'2022-07-26 16:20:25','',''),(4456,'21','227','1',1,'Retail Sale Id 4531',798.00,0.00,0.00,1.05,0.00,'2022-07-26 16:21:32','',''),(4457,'21','227','1',1,'Retail Sale Id 4532',2295.20,0.00,0.00,3.02,0.00,'2022-07-26 16:24:38','',''),(4458,'21','227','1',1,'Retail Sale Id 4533',7600.00,0.00,0.00,10.00,0.00,'2022-07-26 16:26:21','',''),(4459,'21','227','1',1,'Retail Sale Id 4534',995.60,0.00,0.00,1.31,0.00,'2022-07-26 16:27:31','',''),(4460,'21','227','1',1,'Retail Sale Id 4535',760.00,0.00,0.00,1.00,0.00,'2022-07-26 16:28:55','',''),(4461,'21','227','1',1,'Retail Sale Id 4536',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 16:29:40','',''),(4462,'21','227','1',1,'Retail Sale Id 4537',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 16:33:39','',''),(4463,'21','227','1',1,'Retail Sale Id 4538',3997.60,0.00,0.00,5.26,0.00,'2022-07-26 16:34:58','',''),(4464,'21','227','1',1,'Retail Sale Id 4539',2295.20,0.00,0.00,3.02,0.00,'2022-07-26 16:38:18','',''),(4465,'21','227','1',1,'Retail Sale Id 4540',7995.20,0.00,0.00,10.52,0.00,'2022-07-26 16:55:44','',''),(4466,'21','227','1',1,'Retail Sale Id 4541',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 17:04:43','',''),(4467,'21','227','1',1,'Retail Sale Id 4542',995.60,0.00,0.00,1.31,0.00,'2022-07-26 17:06:48','',''),(4468,'21','227','1',1,'Retail Sale Id 4543',995.60,0.00,0.00,1.31,0.00,'2022-07-26 17:09:42','',''),(4469,'21','227','1',1,'Retail Sale Id 4544',1398.40,0.00,0.00,1.84,0.00,'2022-07-26 17:11:02','',''),(4470,'21','227','1',1,'Retail Sale Id 4545',494.00,0.00,0.00,0.65,0.00,'2022-07-26 17:12:07','',''),(4471,'21','227','1',1,'Retail Sale Id 4546',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 17:15:42','',''),(4472,'21','227','1',1,'Retail Sale Id 4547',995.60,0.00,0.00,1.31,0.00,'2022-07-26 17:16:28','',''),(4473,'21','227','1',1,'Retail Sale Id 4548',995.60,0.00,0.00,1.31,0.00,'2022-07-26 17:25:50','',''),(4474,'21','227','1',1,'Retail Sale Id 4549',2994.40,0.00,0.00,3.94,0.00,'2022-07-26 17:28:34','',''),(4475,'21','227','1',1,'Retail Sale Id 4551',995.60,0.00,0.00,1.31,0.00,'2022-07-26 17:31:16','',''),(4476,'21','227','1',1,'Retail Sale Id 4552',1998.80,0.00,0.00,2.63,0.00,'2022-07-26 17:34:18','',''),(4477,'21','227','1',1,'Retail Sale Id 4553',4499.20,0.00,0.00,5.92,0.00,'2022-07-26 17:35:31','',''),(4478,'21','227','1',1,'Retail Sale Id 4554',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 17:40:28','',''),(4479,'21','227','1',1,'Retail Sale Id 4554',3496.00,0.00,0.00,4.60,0.00,'2022-07-26 17:40:28','',''),(4480,'21','227','1',1,'Retail Sale Id 4555',995.60,0.00,0.00,1.31,0.00,'2022-07-26 17:44:22','',''),(4481,'21','227','1',1,'Retail Sale Id 4557',995.60,0.00,0.00,1.31,0.00,'2022-07-26 17:45:16','',''),(4482,'21','227','1',1,'Retail Sale Id 4558',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 17:48:32','',''),(4483,'21','227','1',1,'Retail Sale Id 4559',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 17:49:47','',''),(4484,'21','227','1',1,'Retail Sale Id 4560',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 17:53:04','',''),(4485,'21','227','1',1,'Retail Sale Id 4561',995.60,0.00,0.00,1.31,0.00,'2022-07-26 17:54:20','',''),(4486,'21','227','1',1,'Retail Sale Id 4562',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 17:55:16','',''),(4487,'21','227','1',1,'Retail Sale Id 4563',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 17:57:02','',''),(4488,'21','227','1',1,'Retail Sale Id 4564',1193.20,0.00,0.00,1.57,0.00,'2022-07-26 17:59:36','',''),(4489,'21','227','1',1,'Retail Sale Id 4565',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 08:01:51','',''),(4490,'21','227','1',1,'Retail Sale Id 4566',995.60,0.00,0.00,1.31,0.00,'2022-07-27 08:17:40','',''),(4491,'21','227','1',1,'Retail Sale Id 4567',4993.20,0.00,0.00,6.57,0.00,'2022-07-27 08:50:42','',''),(4492,'21','227','1',1,'Retail Sale Id 4568',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 09:03:55','',''),(4493,'21','227','1',1,'Retail Sale Id 4569',5996.40,0.00,0.00,7.89,0.00,'2022-07-27 09:05:16','',''),(4494,'21','227','1',1,'Retail Sale Id 4570',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 09:06:38','',''),(4495,'21','227','1',1,'Retail Sale Id 4571',4499.20,0.00,0.00,5.92,0.00,'2022-07-27 09:08:13','',''),(4496,'21','227','1',1,'Retail Sale Id 4572',995.60,0.00,0.00,1.31,0.00,'2022-07-27 09:09:21','',''),(4497,'21','227','1',1,'Retail Sale Id 4573',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 09:15:03','',''),(4498,'21','227','1',1,'Retail Sale Id 4574',4499.20,0.00,0.00,5.92,0.00,'2022-07-27 09:16:13','',''),(4499,'21','227','1',1,'Retail Sale Id 4575',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 09:17:45','',''),(4500,'21','227','1',1,'Retail Sale Id 4576',1520.00,0.00,0.00,2.00,0.00,'2022-07-27 09:21:24','',''),(4501,'21','227','1',1,'Retail Sale Id 4577',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 09:22:40','',''),(4502,'21','227','1',1,'Retail Sale Id 4578',995.60,0.00,0.00,1.31,0.00,'2022-07-27 09:30:02','',''),(4503,'21','227','1',1,'Retail Sale Id 4579',2994.40,0.00,0.00,3.94,0.00,'2022-07-27 09:30:45','',''),(4504,'21','227','1',1,'Retail Sale Id 4580',995.60,0.00,0.00,1.31,0.00,'2022-07-27 09:31:33','',''),(4505,'21','227','1',1,'Retail Sale Id 4581',1520.00,0.00,0.00,2.00,0.00,'2022-07-27 09:41:48','',''),(4506,'21','227','1',1,'Retail Sale Id 4582',2994.40,0.00,0.00,3.94,0.00,'2022-07-27 09:54:46','',''),(4507,'21','227','1',1,'Retail Sale Id 4583',995.60,0.00,0.00,1.31,0.00,'2022-07-27 09:57:03','',''),(4508,'21','227','1',1,'Retail Sale Id 4584',798.00,0.00,0.00,1.05,0.00,'2022-07-27 09:59:46','',''),(4509,'21','227','1',1,'Retail Sale Id 4585',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 10:02:35','',''),(4510,'21','227','1',1,'Retail Sale Id 4586',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 10:03:39','',''),(4511,'21','227','1',1,'Retail Sale Id 4587',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 10:05:40','',''),(4512,'21','227','1',1,'Retail Sale Id 4588',995.60,0.00,0.00,1.31,0.00,'2022-07-27 10:06:42','',''),(4513,'21','227','1',1,'Retail Sale Id 4589',2994.40,0.00,0.00,3.94,0.00,'2022-07-27 10:24:17','',''),(4514,'21','227','1',1,'Retail Sale Id 4590',995.60,0.00,0.00,1.31,0.00,'2022-07-27 10:27:58','',''),(4515,'21','227','1',1,'Retail Sale Id 4591',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 10:28:55','',''),(4516,'21','227','1',1,'Retail Sale Id 4592',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 10:29:54','',''),(4517,'21','227','1',1,'Retail Sale Id 4593',494.00,0.00,0.00,0.65,0.00,'2022-07-27 10:32:40','',''),(4518,'21','227','1',1,'Retail Sale Id 4594',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 10:34:45','',''),(4519,'21','227','1',1,'Retail Sale Id 4595',995.60,0.00,0.00,1.31,0.00,'2022-07-27 10:37:20','',''),(4520,'21','227','1',1,'Retail Sale Id 4596',1193.20,0.00,0.00,1.57,0.00,'2022-07-27 10:38:15','',''),(4521,'21','227','1',1,'Retail Sale Id 4597',995.60,0.00,0.00,1.31,0.00,'2022-07-27 10:39:00','',''),(4522,'21','227','1',1,'Retail Sale Id 4598',995.60,0.00,0.00,1.31,0.00,'2022-07-27 10:43:18','',''),(4523,'21','227','1',1,'Retail Sale Id 4599',995.60,0.00,0.00,1.31,0.00,'2022-07-27 10:44:26','',''),(4524,'21','227','1',1,'Retail Sale Id 4600',995.60,0.00,0.00,1.31,0.00,'2022-07-27 10:48:51','',''),(4525,'21','227','1',1,'Retail Sale Id 4601',2994.40,0.00,0.00,3.94,0.00,'2022-07-27 10:55:04','',''),(4526,'21','227','1',1,'Retail Sale Id 4602',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 11:13:20','',''),(4527,'21','227','1',1,'Retail Sale Id 4603',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 11:16:21','',''),(4528,'21','227','1',1,'Retail Sale Id 4604',2280.00,0.00,0.00,3.00,0.00,'2022-07-27 11:18:13','',''),(4529,'21','227','1',1,'Retail Sale Id 4605',1596.00,0.00,0.00,2.10,0.00,'2022-07-27 11:19:41','',''),(4530,'21','227','1',1,'Retail Sale Id 4606',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 11:22:02','',''),(4531,'21','227','1',1,'Retail Sale Id 4607',995.60,0.00,0.00,1.31,0.00,'2022-07-27 11:24:18','',''),(4532,'21','227','1',1,'Retail Sale Id 4608',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:27:26','',''),(4533,'21','227','1',1,'Retail Sale Id 4609',1193.20,0.00,0.00,1.57,0.00,'2022-07-27 11:27:59','',''),(4534,'21','227','1',1,'Retail Sale Id 4610',1520.00,0.00,0.00,2.00,0.00,'2022-07-27 11:32:47','',''),(4535,'21','227','1',1,'Retail Sale Id 4611',4560.00,0.00,0.00,6.00,0.00,'2022-07-27 11:38:40','',''),(4536,'21','227','1',1,'Retail Sale Id 4612',995.60,0.00,0.00,1.31,0.00,'2022-07-27 11:39:33','',''),(4537,'21','227','1',1,'Retail Sale Id 4613',2280.00,0.00,0.00,3.00,0.00,'2022-07-27 11:43:07','',''),(4538,'21','227','1',1,'Retail Sale Id 4614',995.60,0.00,0.00,1.31,0.00,'2022-07-27 11:53:46','',''),(4539,'21','227','1',1,'Retail Sale Id 4615',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 11:57:10','',''),(4540,'21','227','1',1,'Retail Sale Id 4616',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 12:00:52','',''),(4541,'21','227','1',1,'Retail Sale Id 4617',494.00,0.00,0.00,0.65,0.00,'2022-07-27 12:04:57','',''),(4542,'21','227','1',1,'Retail Sale Id 4618',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 12:09:39','',''),(4543,'21','227','1',1,'Retail Sale Id 4619',995.60,0.00,0.00,1.31,0.00,'2022-07-27 12:10:26','',''),(4544,'21','227','1',1,'Retail Sale Id 4620',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 12:23:38','',''),(4545,'21','227','1',1,'Retail Sale Id 4621',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 12:35:07','',''),(4546,'21','227','1',1,'Retail Sale Id 4622',2280.00,0.00,0.00,3.00,0.00,'2022-07-27 12:37:03','',''),(4547,'21','227','1',1,'Retail Sale Id 4623',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 12:37:41','',''),(4548,'21','227','1',1,'Retail Sale Id 4624',798.00,0.00,0.00,1.05,0.00,'2022-07-27 13:15:56','',''),(4549,'21','227','1',1,'Retail Sale Id 4625',3997.60,0.00,0.00,5.26,0.00,'2022-07-27 13:27:12','',''),(4550,'21','227','1',1,'Retail Sale Id 4626',1520.00,0.00,0.00,2.00,0.00,'2022-07-27 13:28:07','',''),(4551,'21','227','1',1,'Retail Sale Id 4627',995.60,0.00,0.00,1.31,0.00,'2022-07-27 13:28:58','',''),(4552,'21','227','1',1,'Retail Sale Id 4628',995.60,0.00,0.00,1.31,0.00,'2022-07-27 13:29:32','',''),(4553,'21','227','1',1,'Retail Sale Id 4629',995.60,0.00,0.00,1.31,0.00,'2022-07-27 13:30:13','',''),(4554,'21','227','1',1,'Retail Sale Id 4630',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 13:31:00','',''),(4555,'21','227','1',1,'Retail Sale Id 4631',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 13:31:42','',''),(4556,'21','227','1',1,'Retail Sale Id 4632',896.80,0.00,0.00,1.18,0.00,'2022-07-27 13:35:26','',''),(4557,'21','227','1',1,'Retail Sale Id 4633',2280.00,0.00,0.00,3.00,0.00,'2022-07-27 13:43:48','',''),(4558,'21','227','1',1,'Retail Sale Id 4634',2994.40,0.00,0.00,3.94,0.00,'2022-07-27 13:45:09','',''),(4559,'21','227','1',1,'Retail Sale Id 4635',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 13:45:37','',''),(4560,'21','227','1',1,'Retail Sale Id 4636',2280.00,0.00,0.00,3.00,0.00,'2022-07-27 13:46:30','',''),(4561,'21','227','1',1,'Retail Sale Id 4637',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 13:49:57','',''),(4562,'21','227','1',1,'Retail Sale Id 4638',2280.00,0.00,0.00,3.00,0.00,'2022-07-27 13:55:43','',''),(4563,'21','227','1',1,'Retail Sale Id 4639',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 13:57:09','',''),(4564,'21','227','1',1,'Retail Sale Id 4640',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 13:58:10','',''),(4565,'21','227','1',1,'Retail Sale Id 4641',3997.60,0.00,0.00,5.26,0.00,'2022-07-27 14:24:41','',''),(4566,'21','227','1',1,'Retail Sale Id 4642',17077.20,0.00,0.00,22.47,0.00,'2022-07-27 14:26:36','',''),(4567,'21','227','1',1,'Retail Sale Id 4643',4560.00,0.00,0.00,6.00,0.00,'2022-07-27 14:31:17','',''),(4568,'21','227','1',1,'Retail Sale Id 4644',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 14:33:21','',''),(4569,'21','227','1',1,'Retail Sale Id 4645',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 14:34:41','',''),(4570,'21','227','1',1,'Retail Sale Id 4646',4993.20,0.00,0.00,6.57,0.00,'2022-07-27 14:41:29','',''),(4571,'21','227','1',1,'Retail Sale Id 4647',995.60,0.00,0.00,1.31,0.00,'2022-07-27 14:44:31','',''),(4572,'21','227','1',1,'Retail Sale Id 4648',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 14:47:28','',''),(4573,'21','227','1',1,'Retail Sale Id 4649',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 14:50:03','',''),(4574,'21','227','1',1,'Retail Sale Id 4650',3040.00,0.00,0.00,4.00,0.00,'2022-07-27 14:52:36','',''),(4575,'21','227','1',1,'Retail Sale Id 4651',7600.00,0.00,0.00,10.00,0.00,'2022-07-27 15:04:36','',''),(4576,'21','227','1',1,'Retail Sale Id 4652',995.60,0.00,0.00,1.31,0.00,'2022-07-27 15:06:53','',''),(4577,'21','227','1',1,'Retail Sale Id 4653',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 15:09:07','',''),(4578,'21','227','1',1,'Retail Sale Id 4654',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 15:13:41','',''),(4579,'21','227','1',1,'Retail Sale Id 4655',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 15:15:04','',''),(4580,'21','227','1',1,'Retail Sale Id 4656',2492.80,0.00,0.00,3.28,0.00,'2022-07-27 15:18:11','',''),(4581,'21','227','1',1,'Retail Sale Id 4657',4347.20,0.00,0.00,5.72,0.00,'2022-07-27 15:20:59','',''),(4582,'21','227','1',1,'Retail Sale Id 4658',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 15:22:07','',''),(4583,'21','227','1',1,'Retail Sale Id 4659',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 15:28:28','',''),(4584,'21','227','1',1,'Retail Sale Id 4660',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 15:29:27','',''),(4585,'21','227','1',1,'Retail Sale Id 4661',1520.00,0.00,0.00,2.00,0.00,'2022-07-27 15:30:59','',''),(4586,'21','227','1',1,'Retail Sale Id 4662',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 15:32:02','',''),(4587,'21','227','1',1,'Retail Sale Id 4663',1299.60,0.00,0.00,1.71,0.00,'2022-07-27 15:33:43','',''),(4588,'21','227','1',1,'Retail Sale Id 4664',995.60,0.00,0.00,1.31,0.00,'2022-07-27 15:44:10','',''),(4589,'21','227','1',1,'Retail Sale Id 4665',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 15:45:02','',''),(4590,'21','227','1',1,'Retail Sale Id 4666',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 15:45:45','',''),(4591,'21','227','1',1,'Retail Sale Id 4667',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 15:47:48','',''),(4592,'21','227','1',1,'Retail Sale Id 4668',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 15:48:34','',''),(4593,'21','227','1',1,'Retail Sale Id 4669',995.60,0.00,0.00,1.31,0.00,'2022-07-27 15:50:03','',''),(4594,'21','227','1',1,'Retail Sale Id 4670',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 15:57:16','',''),(4595,'21','227','1',1,'Retail Sale Id 4671',995.60,0.00,0.00,1.31,0.00,'2022-07-27 16:03:04','',''),(4596,'21','227','1',1,'Retail Sale Id 4672',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 16:12:27','',''),(4597,'21','227','1',1,'Retail Sale Id 4673',2994.40,0.00,0.00,3.94,0.00,'2022-07-27 16:14:43','',''),(4598,'21','227','1',1,'Retail Sale Id 4674',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 16:18:38','',''),(4599,'21','227','1',1,'Retail Sale Id 4675',4560.00,0.00,0.00,6.00,0.00,'2022-07-27 16:20:45','',''),(4600,'21','227','1',1,'Retail Sale Id 4676',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 16:23:49','',''),(4601,'21','227','1',1,'Retail Sale Id 4677',995.60,0.00,0.00,1.31,0.00,'2022-07-27 16:26:12','',''),(4602,'21','227','1',1,'Retail Sale Id 4678',2492.80,0.00,0.00,3.28,0.00,'2022-07-27 16:27:30','',''),(4603,'21','227','1',1,'Retail Sale Id 4679',2492.80,0.00,0.00,3.28,0.00,'2022-07-27 16:30:19','',''),(4604,'21','227','1',1,'Retail Sale Id 4681',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 16:32:54','',''),(4605,'21','227','1',1,'Retail Sale Id 4682',995.60,0.00,0.00,1.31,0.00,'2022-07-27 16:33:39','',''),(4606,'21','227','1',1,'Retail Sale Id 4683',1520.00,0.00,0.00,2.00,0.00,'2022-07-27 16:36:21','',''),(4607,'21','227','1',1,'Retail Sale Id 4684',995.60,0.00,0.00,1.31,0.00,'2022-07-27 16:37:04','',''),(4608,'21','227','1',1,'Retail Sale Id 4685',6999.60,0.00,0.00,9.21,0.00,'2022-07-27 16:44:20','',''),(4609,'21','227','1',1,'Retail Sale Id 4686',2994.40,0.00,0.00,3.94,0.00,'2022-07-27 16:45:27','',''),(4610,'21','227','1',1,'Retail Sale Id 4687',995.60,0.00,0.00,1.31,0.00,'2022-07-27 16:46:47','',''),(4611,'21','227','1',1,'Retail Sale Id 4687',995.60,0.00,0.00,1.31,0.00,'2022-07-27 16:46:47','',''),(4612,'21','227','1',1,'Retail Sale Id 4688',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 16:47:52','',''),(4613,'21','227','1',1,'Retail Sale Id 4689',1520.00,0.00,0.00,2.00,0.00,'2022-07-27 16:48:38','',''),(4614,'21','227','1',1,'Retail Sale Id 4690',798.00,0.00,0.00,1.05,0.00,'2022-07-27 16:53:20','',''),(4615,'21','227','1',1,'Retail Sale Id 4691',1398.40,0.00,0.00,1.84,0.00,'2022-07-27 17:02:14','',''),(4616,'21','227','1',1,'Retail Sale Id 4692',4560.00,0.00,0.00,6.00,0.00,'2022-07-27 17:08:12','',''),(4617,'21','227','1',1,'Retail Sale Id 4693',3040.00,0.00,0.00,4.00,0.00,'2022-07-27 17:09:50','',''),(4618,'21','227','1',1,'Retail Sale Id 4694',3040.00,0.00,0.00,4.00,0.00,'2022-07-27 17:10:44','',''),(4619,'21','227','1',1,'Retail Sale Id 4695',494.00,0.00,0.00,0.65,0.00,'2022-07-27 17:11:34','',''),(4620,'21','227','1',1,'Retail Sale Id 4696',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 17:20:38','',''),(4621,'21','227','1',1,'Retail Sale Id 4697',798.00,0.00,0.00,1.05,0.00,'2022-07-27 17:22:40','',''),(4622,'21','227','1',1,'Retail Sale Id 4698',2994.40,0.00,0.00,3.94,0.00,'2022-07-27 17:37:10','',''),(4623,'21','227','1',1,'Retail Sale Id 4699',2280.00,0.00,0.00,3.00,0.00,'2022-07-27 17:40:03','',''),(4624,'21','227','1',1,'Retail Sale Id 4700',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 17:40:55','',''),(4625,'21','227','1',1,'Retail Sale Id 4701',3997.60,0.00,0.00,5.26,0.00,'2022-07-27 17:44:17','',''),(4626,'21','227','1',1,'Retail Sale Id 4702',995.60,0.00,0.00,1.31,0.00,'2022-07-28 09:11:48','',''),(4627,'21','227','1',1,'Retail Sale Id 4703',2994.40,0.00,0.00,3.94,0.00,'2022-07-28 09:12:29','',''),(4628,'21','227','1',1,'Retail Sale Id 4704',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 09:13:11','',''),(4629,'21','227','1',1,'Retail Sale Id 4705',2994.40,0.00,0.00,3.94,0.00,'2022-07-28 09:14:31','',''),(4630,'21','227','1',1,'Retail Sale Id 4706',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 09:15:31','',''),(4631,'21','227','1',1,'Retail Sale Id 4707',4993.20,0.00,0.00,6.57,0.00,'2022-07-28 09:18:58','',''),(4632,'21','227','1',1,'Retail Sale Id 4708',3496.00,0.00,0.00,4.60,0.00,'2022-07-28 09:20:21','',''),(4633,'21','227','1',1,'Retail Sale Id 4709',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 09:24:24','',''),(4634,'21','227','1',1,'Retail Sale Id 4710',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 09:34:15','',''),(4635,'21','227','1',1,'Retail Sale Id 4711',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 09:37:30','',''),(4636,'21','227','1',1,'Retail Sale Id 4712',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 09:38:57','',''),(4637,'21','227','1',1,'Retail Sale Id 4713',2895.60,0.00,0.00,3.81,0.00,'2022-07-28 09:41:18','',''),(4638,'21','227','1',1,'Retail Sale Id 4714',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 09:43:48','',''),(4639,'21','227','1',1,'Retail Sale Id 4715',2295.20,0.00,0.00,3.02,0.00,'2022-07-28 09:51:05','',''),(4640,'21','227','1',1,'Retail Sale Id 4716',995.60,0.00,0.00,1.31,0.00,'2022-07-28 09:53:03','',''),(4641,'21','227','1',1,'Retail Sale Id 4717',3997.60,0.00,0.00,5.26,0.00,'2022-07-28 10:18:35','',''),(4642,'21','227','1',1,'Retail Sale Id 4718',896.80,0.00,0.00,1.18,0.00,'2022-07-28 10:24:00','',''),(4643,'21','227','1',1,'Retail Sale Id 4719',896.80,0.00,0.00,1.18,0.00,'2022-07-28 10:25:17','',''),(4644,'21','227','1',1,'Retail Sale Id 4720',995.60,0.00,0.00,1.31,0.00,'2022-07-28 10:27:18','',''),(4645,'21','227','1',1,'Retail Sale Id 4721',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 10:31:36','',''),(4646,'21','227','1',1,'Retail Sale Id 4722',9994.00,0.00,0.00,13.15,0.00,'2022-07-28 10:34:21','',''),(4647,'21','227','1',1,'Retail Sale Id 4723',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 10:35:00','',''),(4648,'21','227','1',1,'Retail Sale Id 4724',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 10:40:04','',''),(4649,'21','227','1',1,'Retail Sale Id 4725',1694.80,0.00,0.00,2.23,0.00,'2022-07-28 10:48:03','',''),(4650,'21','227','1',1,'Retail Sale Id 4726',995.60,0.00,0.00,1.31,0.00,'2022-07-28 10:49:53','',''),(4651,'21','227','1',1,'Retail Sale Id 4727',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 11:00:10','',''),(4652,'21','227','1',1,'Retail Sale Id 4728',760.00,0.00,0.00,1.00,0.00,'2022-07-28 11:01:30','',''),(4653,'21','227','1',1,'Retail Sale Id 4731',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 11:03:51','',''),(4654,'21','227','1',1,'Retail Sale Id 4732',995.60,0.00,0.00,1.31,0.00,'2022-07-28 11:05:54','',''),(4655,'21','227','1',1,'Retail Sale Id 4732',2796.80,0.00,0.00,3.68,0.00,'2022-07-28 11:05:54','',''),(4656,'21','227','1',1,'Retail Sale Id 4733',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 11:06:52','',''),(4657,'21','227','1',1,'Retail Sale Id 4734',2994.40,0.00,0.00,3.94,0.00,'2022-07-28 11:07:54','',''),(4658,'21','227','1',1,'Retail Sale Id 4735',798.00,0.00,0.00,1.05,0.00,'2022-07-28 11:08:51','',''),(4659,'21','227','1',1,'Retail Sale Id 4736',1900.00,0.00,0.00,2.50,0.00,'2022-07-28 11:09:36','',''),(4660,'21','227','1',1,'Retail Sale Id 4737',760.00,0.00,0.00,1.00,0.00,'2022-07-28 11:10:40','',''),(4661,'21','227','1',1,'Retail Sale Id 4738',2994.40,0.00,0.00,3.94,0.00,'2022-07-28 11:11:28','',''),(4662,'21','227','1',1,'Retail Sale Id 4739',494.00,0.00,0.00,0.65,0.00,'2022-07-28 11:13:13','',''),(4663,'21','227','1',1,'Retail Sale Id 4740',995.60,0.00,0.00,1.31,0.00,'2022-07-28 11:14:51','',''),(4664,'21','227','1',1,'Retail Sale Id 4741',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 11:17:16','',''),(4665,'21','227','1',1,'Retail Sale Id 4742',1520.00,0.00,0.00,2.00,0.00,'2022-07-28 11:18:40','',''),(4666,'21','227','1',1,'Retail Sale Id 4743',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 11:19:45','',''),(4667,'21','227','1',1,'Retail Sale Id 4744',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 11:23:59','',''),(4668,'21','227','1',1,'Retail Sale Id 4745',995.60,0.00,0.00,1.31,0.00,'2022-07-28 11:25:52','',''),(4669,'21','227','1',1,'Retail Sale Id 4746',995.60,0.00,0.00,1.31,0.00,'2022-07-28 11:30:15','',''),(4670,'21','227','1',1,'Retail Sale Id 4747',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 11:35:09','',''),(4671,'21','227','1',1,'Retail Sale Id 4748',4993.20,0.00,0.00,6.57,0.00,'2022-07-28 11:37:15','',''),(4672,'21','227','1',1,'Retail Sale Id 4749',798.00,0.00,0.00,1.05,0.00,'2022-07-28 11:38:13','',''),(4673,'21','227','1',1,'Retail Sale Id 4750',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 11:38:59','',''),(4674,'21','227','1',1,'Retail Sale Id 4751',2994.40,0.00,0.00,3.94,0.00,'2022-07-28 11:44:53','',''),(4675,'21','227','1',1,'Retail Sale Id 4752',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 11:45:30','',''),(4676,'21','227','1',1,'Retail Sale Id 4753',7600.00,0.00,0.00,10.00,0.00,'2022-07-28 11:48:19','',''),(4677,'21','227','1',1,'Retail Sale Id 4754',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 11:53:51','',''),(4678,'21','227','1',1,'Retail Sale Id 4755',494.00,0.00,0.00,0.65,0.00,'2022-07-28 11:57:48','',''),(4679,'21','227','1',1,'Retail Sale Id 4756',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 12:00:25','',''),(4680,'21','227','1',1,'Retail Sale Id 4757',995.60,0.00,0.00,1.31,0.00,'2022-07-28 12:01:17','',''),(4681,'21','227','1',1,'Retail Sale Id 4757',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 12:01:17','',''),(4682,'21','227','1',1,'Retail Sale Id 4758',3997.60,0.00,0.00,5.26,0.00,'2022-07-28 12:15:53','',''),(4683,'21','227','1',1,'Retail Sale Id 4759',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 12:25:40','',''),(4684,'21','227','1',1,'Retail Sale Id 4760',1520.00,0.00,0.00,2.00,0.00,'2022-07-28 12:29:00','',''),(4685,'21','227','1',1,'Retail Sale Id 4761',4993.20,0.00,0.00,6.57,0.00,'2022-07-28 12:32:51','',''),(4686,'21','227','1',1,'Retail Sale Id 4762',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 12:36:15','',''),(4687,'21','227','1',1,'Retail Sale Id 4763',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 12:39:25','',''),(4688,'21','227','1',1,'Retail Sale Id 4764',995.60,0.00,0.00,1.31,0.00,'2022-07-28 12:44:43','',''),(4689,'21','227','1',1,'Retail Sale Id 4765',995.60,0.00,0.00,1.31,0.00,'2022-07-28 12:52:00','',''),(4690,'21','227','1',1,'Retail Sale Id 4766',494.00,0.00,0.00,0.65,0.00,'2022-07-28 12:55:29','',''),(4691,'21','227','1',1,'Retail Sale Id 4767',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 12:58:18','',''),(4692,'21','227','1',1,'Retail Sale Id 4768',1793.60,0.00,0.00,2.36,0.00,'2022-07-28 13:01:57','',''),(4693,'21','227','1',1,'Retail Sale Id 4769',995.60,0.00,0.00,1.31,0.00,'2022-07-28 13:05:57','',''),(4694,'21','227','1',1,'Retail Sale Id 4770',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 13:07:37','',''),(4695,'21','227','1',1,'Retail Sale Id 4771',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 13:10:21','',''),(4696,'21','227','1',1,'Retail Sale Id 4772',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 13:14:42','',''),(4697,'21','227','1',1,'Retail Sale Id 4773',494.00,0.00,0.00,0.65,0.00,'2022-07-28 13:17:26','',''),(4698,'21','227','1',1,'Retail Sale Id 4774',995.60,0.00,0.00,1.31,0.00,'2022-07-28 13:18:00','',''),(4699,'21','227','1',1,'Retail Sale Id 4775',760.00,0.00,0.00,1.00,0.00,'2022-07-28 13:20:15','',''),(4700,'21','227','1',1,'Retail Sale Id 4776',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 13:28:48','',''),(4701,'21','227','1',1,'Retail Sale Id 4777',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 13:41:13','',''),(4702,'21','227','1',1,'Retail Sale Id 4778',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 13:44:19','',''),(4703,'21','227','1',1,'Retail Sale Id 4779',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 13:47:04','',''),(4704,'21','227','1',1,'Retail Sale Id 4780',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 13:47:48','',''),(4705,'21','227','1',1,'Retail Sale Id 4781',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 13:51:31','',''),(4706,'21','227',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,2030.00,0.00,'2022-07-28 13:53:03','',''),(4707,'21','227','1',1,'Received from bridging 13',0.00,0.00,2030.00,0.00,0.00,'2022-07-28 13:53:03','',''),(4708,'21','227','1',1,'Retail Sale Id 4782',760.00,0.00,0.00,1.00,0.00,'2022-07-28 13:53:46','',''),(4709,'21','227','1',1,'Retail Sale Id 4783',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 13:58:56','',''),(4710,'21','227','1',1,'Retail Sale Id 4784',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 14:01:30','',''),(4711,'21','227','1',1,'Retail Sale Id 4785',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 14:13:23','',''),(4712,'21','227','1',1,'Retail Sale Id 4786',1520.00,0.00,0.00,2.00,0.00,'2022-07-28 14:15:21','',''),(4713,'21','227','1',1,'Retail Sale Id 4787',995.60,0.00,0.00,1.31,0.00,'2022-07-28 14:15:52','',''),(4714,'21','227','1',1,'Retail Sale Id 4788',798.00,0.00,0.00,1.05,0.00,'2022-07-28 14:36:44','',''),(4715,'21','227','1',1,'Retail Sale Id 4789',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 14:38:24','',''),(4716,'21','227','1',1,'Retail Sale Id 4790',1520.00,0.00,0.00,2.00,0.00,'2022-07-28 14:44:01','',''),(4717,'21','227','1',1,'Retail Sale Id 4791',995.60,0.00,0.00,1.31,0.00,'2022-07-28 14:48:32','',''),(4718,'21','227','1',1,'Retail Sale Id 4792',798.00,0.00,0.00,1.05,0.00,'2022-07-28 14:51:11','',''),(4719,'21','227','1',1,'Retail Sale Id 4793',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 14:59:00','',''),(4720,'21','227','1',1,'Retail Sale Id 4794',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 15:01:26','',''),(4721,'21','227','1',1,'Retail Sale Id 4795',995.60,0.00,0.00,1.31,0.00,'2022-07-28 15:13:08','',''),(4722,'21','227','1',1,'Retail Sale Id 4796',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 15:14:12','',''),(4723,'21','227','1',1,'Retail Sale Id 4797',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 15:15:56','',''),(4724,'21','227','1',1,'Retail Sale Id 4798',699.20,0.00,0.00,0.92,0.00,'2022-07-28 15:17:47','',''),(4725,'21','227','1',1,'Retail Sale Id 4799',995.60,0.00,0.00,1.31,0.00,'2022-07-28 15:45:15','',''),(4726,'21','227','1',1,'Retail Sale Id 4800',2492.80,0.00,0.00,3.28,0.00,'2022-07-28 15:53:18','',''),(4727,'21','227','1',1,'Retail Sale Id 4801',798.00,0.00,0.00,1.05,0.00,'2022-07-28 16:14:34','',''),(4728,'21','227','1',1,'Retail Sale Id 4802',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 16:15:19','',''),(4729,'21','227','1',1,'Retail Sale Id 4803',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 16:17:10','',''),(4730,'21','227','1',1,'Retail Sale Id 4804',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 16:18:41','',''),(4731,'21','227','1',1,'Retail Sale Id 4805',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 16:22:47','',''),(4732,'21','227','1',1,'Retail Sale Id 4806',7600.00,0.00,0.00,10.00,0.00,'2022-07-28 16:23:45','',''),(4733,'21','227','1',1,'Retail Sale Id 4807',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 16:25:40','',''),(4734,'21','227','1',1,'Retail Sale Id 4808',1520.00,0.00,0.00,2.00,0.00,'2022-07-28 16:28:16','',''),(4735,'21','227','1',1,'Retail Sale Id 4809',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 16:30:10','',''),(4736,'21','227','1',1,'Retail Sale Id 4810',798.00,0.00,0.00,1.05,0.00,'2022-07-28 16:31:04','',''),(4737,'21','227','1',1,'Retail Sale Id 4811',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 16:33:32','',''),(4738,'21','227','1',1,'Retail Sale Id 4812',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 16:34:33','',''),(4739,'21','227','1',1,'Retail Sale Id 4813',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 16:36:00','',''),(4740,'21','227','1',1,'Retail Sale Id 4814',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 16:39:20','',''),(4741,'21','227','1',1,'Retail Sale Id 4815',896.80,0.00,0.00,1.18,0.00,'2022-07-28 16:40:13','',''),(4742,'21','227','1',1,'Retail Sale Id 4816',995.60,0.00,0.00,1.31,0.00,'2022-07-28 16:41:03','',''),(4743,'21','227','1',1,'Retail Sale Id 4817',494.00,0.00,0.00,0.65,0.00,'2022-07-28 16:41:32','',''),(4744,'21','227','1',1,'Retail Sale Id 4818',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 16:42:21','',''),(4745,'21','227','1',1,'Retail Sale Id 4819',995.60,0.00,0.00,1.31,0.00,'2022-07-28 16:43:07','',''),(4746,'21','227','1',1,'Retail Sale Id 4820',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 16:44:01','',''),(4747,'21','227','1',1,'Retail Sale Id 4821',2660.00,0.00,0.00,3.50,0.00,'2022-07-28 16:46:12','',''),(4748,'21','227','1',1,'Retail Sale Id 4821',2660.00,0.00,0.00,3.50,0.00,'2022-07-28 16:46:12','',''),(4749,'21','227','1',1,'Retail Sale Id 4821',5320.00,0.00,0.00,7.00,0.00,'2022-07-28 16:46:12','',''),(4750,'21','227','1',1,'Retail Sale Id 4822',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 16:47:41','',''),(4751,'21','227','1',1,'Retail Sale Id 4823',494.00,0.00,0.00,0.65,0.00,'2022-07-28 16:51:22','',''),(4752,'21','227','1',1,'Retail Sale Id 4824',2994.40,0.00,0.00,3.94,0.00,'2022-07-28 16:52:35','',''),(4753,'21','227','1',1,'Retail Sale Id 4825',995.60,0.00,0.00,1.31,0.00,'2022-07-28 16:56:31','',''),(4754,'21','227','1',1,'Retail Sale Id 4826',3997.60,0.00,0.00,5.26,0.00,'2022-07-28 16:57:10','',''),(4755,'21','227','1',1,'Retail Sale Id 4827',5494.80,0.00,0.00,7.23,0.00,'2022-07-28 16:59:30','',''),(4756,'21','227','1',1,'Retail Sale Id 4828',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 17:00:55','',''),(4757,'21','227','1',1,'Retail Sale Id 4829',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 17:02:11','',''),(4758,'21','227','1',1,'Retail Sale Id 4830',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 17:04:03','',''),(4759,'21','227','1',1,'Retail Sale Id 4831',995.60,0.00,0.00,1.31,0.00,'2022-07-28 17:05:09','',''),(4760,'21','227','1',1,'Retail Sale Id 4832',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 17:05:49','',''),(4761,'21','227','1',1,'Retail Sale Id 4833',995.60,0.00,0.00,1.31,0.00,'2022-07-28 17:06:35','',''),(4762,'21','227','1',1,'Retail Sale Id 4834',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 17:09:21','',''),(4763,'21','227','1',1,'Retail Sale Id 4835',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 17:09:57','',''),(4764,'21','227','1',1,'Retail Sale Id 4836',5320.00,0.00,0.00,7.00,0.00,'2022-07-28 17:12:21','',''),(4765,'21','227','1',1,'Retail Sale Id 4837',7600.00,0.00,0.00,10.00,0.00,'2022-07-28 17:13:46','',''),(4766,'21','227','1',1,'Retail Sale Id 4838',7600.00,0.00,0.00,10.00,0.00,'2022-07-28 17:15:01','',''),(4767,'21','227','1',1,'Retail Sale Id 4839',760.00,0.00,0.00,1.00,0.00,'2022-07-28 17:18:46','',''),(4768,'21','227','1',1,'Retail Sale Id 4840',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 17:19:33','',''),(4769,'21','227','1',1,'Retail Sale Id 4841',1793.60,0.00,0.00,2.36,0.00,'2022-07-28 17:21:54','',''),(4770,'21','227','1',1,'Retail Sale Id 4842',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 17:23:29','',''),(4771,'21','227','1',1,'Retail Sale Id 4843',995.60,0.00,0.00,1.31,0.00,'2022-07-28 17:24:16','',''),(4772,'21','227','1',1,'Retail Sale Id 4844',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 17:39:52','',''),(4773,'21','227','1',1,'Retail Sale Id 4845',995.60,0.00,0.00,1.31,0.00,'2022-07-28 17:40:58','',''),(4774,'21','227','1',1,'Retail Sale Id 4846',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 17:41:42','',''),(4775,'21','227','1',1,'Retail Sale Id 4847',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 17:42:55','',''),(4776,'21','227','1',1,'Retail Sale Id 4848',2994.40,0.00,0.00,3.94,0.00,'2022-07-28 17:44:10','',''),(4777,'21','227','1',1,'Retail Sale Id 4849',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 17:45:02','',''),(4778,'21','227','1',1,'Retail Sale Id 4850',3997.60,0.00,0.00,5.26,0.00,'2022-07-28 17:45:42','',''),(4779,'21','227','1',1,'Retail Sale Id 4851',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 17:46:20','',''),(4780,'21','227','1',1,'Retail Sale Id 4852',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 17:50:31','',''),(4781,'21','227','1',1,'Retail Sale Id 4853',1793.60,0.00,0.00,2.36,0.00,'2022-07-28 17:51:12','',''),(4782,'21','227','1',1,'Retail Sale Id 4854',4499.20,0.00,0.00,5.92,0.00,'2022-07-28 17:51:50','',''),(4783,'21','227','1',1,'Retail Sale Id 4855',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 17:54:42','',''),(4784,'21','227','1',1,'Retail Sale Id 4856',4993.20,0.00,0.00,6.57,0.00,'2022-07-28 17:56:18','',''),(4785,'21','227','1',1,'Retail Sale Id 4859',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 17:58:31','',''),(4786,'21','227','1',1,'Retail Sale Id 4857',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 18:01:27','',''),(4787,'21','227','1',1,'Retail Sale Id 4860',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 08:11:27','',''),(4788,'21','227','1',1,'Retail Sale Id 4861',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 08:13:07','',''),(4789,'21','227','1',1,'Retail Sale Id 4862',1520.00,0.00,0.00,2.00,0.00,'2022-07-29 08:24:36','',''),(4790,'21','227','1',1,'Retail Sale Id 4863',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 08:27:49','',''),(4791,'21','227','1',1,'Retail Sale Id 4864',1793.60,0.00,0.00,2.36,0.00,'2022-07-29 08:30:06','',''),(4792,'21','227','1',1,'Retail Sale Id 4865',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 08:38:20','',''),(4793,'21','227','1',1,'Retail Sale Id 4866',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 08:44:40','',''),(4794,'21','227','1',1,'Retail Sale Id 4867',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 08:46:48','',''),(4795,'21','227','1',1,'Retail Sale Id 4868',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 08:48:50','',''),(4796,'21','227','1',1,'Retail Sale Id 4869',995.60,0.00,0.00,1.31,0.00,'2022-07-29 08:49:34','',''),(4797,'21','227','1',1,'Retail Sale Id 4870',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 08:50:36','',''),(4798,'21','227','1',1,'Retail Sale Id 4871',2196.40,0.00,0.00,2.89,0.00,'2022-07-29 08:57:49','',''),(4799,'21','227','1',1,'Retail Sale Id 4872',995.60,0.00,0.00,1.31,0.00,'2022-07-29 09:04:08','',''),(4800,'21','227','1',1,'Retail Sale Id 4873',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 09:08:55','',''),(4801,'21','227','1',1,'Retail Sale Id 4874',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 09:11:48','',''),(4802,'21','227','1',1,'Retail Sale Id 4875',4993.20,0.00,0.00,6.57,0.00,'2022-07-29 09:29:03','',''),(4803,'21','227','1',1,'Retail Sale Id 4876',2492.80,0.00,0.00,3.28,0.00,'2022-07-29 09:39:32','',''),(4804,'21','227','1',1,'Retail Sale Id 4877',3800.00,0.00,0.00,5.00,0.00,'2022-07-29 09:46:00','',''),(4805,'21','227','1',1,'Retail Sale Id 4877',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 09:46:00','',''),(4806,'21','227','1',1,'Retail Sale Id 4878',5996.40,0.00,0.00,7.89,0.00,'2022-07-29 09:52:12','',''),(4807,'21','227','1',1,'Retail Sale Id 4879',4993.20,0.00,0.00,6.57,0.00,'2022-07-29 10:00:49','',''),(4808,'21','227','1',1,'Retail Sale Id 4880',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 10:01:34','',''),(4809,'21','227','1',1,'Retail Sale Id 4881',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 10:03:04','',''),(4810,'21','227','1',1,'Retail Sale Id 4882',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 10:07:34','',''),(4811,'21','227','1',1,'Retail Sale Id 4883',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 10:12:38','',''),(4812,'21','227','1',1,'Retail Sale Id 4884',699.20,0.00,0.00,0.92,0.00,'2022-07-29 10:14:12','',''),(4813,'21','227','1',1,'Retail Sale Id 4885',2492.80,0.00,0.00,3.28,0.00,'2022-07-29 10:17:17','',''),(4814,'21','227','1',1,'Retail Sale Id 4886',995.60,0.00,0.00,1.31,0.00,'2022-07-29 10:18:55','',''),(4815,'21','227','1',1,'Retail Sale Id 4887',995.60,0.00,0.00,1.31,0.00,'2022-07-29 10:19:32','',''),(4816,'21','227','1',1,'Retail Sale Id 4888',995.60,0.00,0.00,1.31,0.00,'2022-07-29 10:20:33','',''),(4817,'21','227','1',1,'Retail Sale Id 4889',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 10:25:38','',''),(4818,'21','227','1',1,'Retail Sale Id 4890',995.60,0.00,0.00,1.31,0.00,'2022-07-29 10:27:20','',''),(4819,'21','227','1',1,'Retail Sale Id 4891',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 10:29:12','',''),(4820,'21','227','1',1,'Retail Sale Id 4892',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 10:40:03','',''),(4821,'21','227','1',1,'Retail Sale Id 4893',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 10:43:00','',''),(4822,'21','227','1',1,'Retail Sale Id 4894',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 10:44:32','',''),(4823,'21','227','1',1,'Retail Sale Id 4895',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 10:59:34','',''),(4824,'21','227','1',1,'Retail Sale Id 4895',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 10:59:34','',''),(4825,'21','227','1',1,'Retail Sale Id 4896',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 11:01:03','',''),(4826,'21','227','1',1,'Retail Sale Id 4897',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 11:07:05','',''),(4827,'21','227','1',1,'Retail Sale Id 4898',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 11:08:15','',''),(4828,'21','227','1',1,'Retail Sale Id 4899',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 11:09:28','',''),(4829,'21','227','1',1,'Retail Sale Id 4900',995.60,0.00,0.00,1.31,0.00,'2022-07-29 11:14:43','',''),(4830,'21','227','1',1,'Retail Sale Id 4901',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 11:16:35','',''),(4831,'21','227','1',1,'Retail Sale Id 4902',1793.60,0.00,0.00,2.36,0.00,'2022-07-29 11:24:21','',''),(4832,'21','227','1',1,'Retail Sale Id 4903',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 11:36:57','',''),(4833,'21','227','1',1,'Retail Sale Id 4904',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 11:38:54','',''),(4834,'21','227','1',1,'Retail Sale Id 4905',760.00,0.00,0.00,1.00,0.00,'2022-07-29 11:45:05','',''),(4835,'21','227','1',1,'Retail Sale Id 4906',2295.20,0.00,0.00,3.02,0.00,'2022-07-29 11:51:01','',''),(4836,'21','227','1',1,'Retail Sale Id 4907',2492.80,0.00,0.00,3.28,0.00,'2022-07-29 11:52:46','',''),(4837,'21','227','1',1,'Retail Sale Id 4908',995.60,0.00,0.00,1.31,0.00,'2022-07-29 11:55:17','',''),(4838,'21','227','1',1,'Retail Sale Id 4909',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 11:59:18','',''),(4839,'21','227','1',1,'Retail Sale Id 4910',995.60,0.00,0.00,1.31,0.00,'2022-07-29 12:01:07','',''),(4840,'21','227','1',1,'Retail Sale Id 4911',494.00,0.00,0.00,0.65,0.00,'2022-07-29 12:02:08','',''),(4841,'21','227','1',1,'Retail Sale Id 4912',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 12:07:23','',''),(4842,'21','227','1',1,'Retail Sale Id 4913',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 12:10:32','',''),(4843,'21','227','1',1,'Retail Sale Id 4914',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 12:11:56','',''),(4844,'21','227','1',1,'Retail Sale Id 4915',68400.00,0.00,0.00,90.00,0.00,'2022-07-29 12:16:22','',''),(4845,'21','227','1',1,'Retail Sale Id 4916',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 12:16:54','',''),(4846,'21','227','1',1,'Retail Sale Id 4917',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 12:19:44','',''),(4847,'21','227','1',1,'Retail Sale Id 4918',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 12:33:02','',''),(4848,'21','227','1',1,'Retail Sale Id 4919',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 12:38:16','',''),(4849,'21','227','1',1,'Retail Sale Id 4920',2492.80,0.00,0.00,3.28,0.00,'2022-07-29 12:51:32','',''),(4850,'21','227','1',1,'Retail Sale Id 4921',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 12:55:49','',''),(4851,'21','227','1',1,'Retail Sale Id 4922',8496.80,0.00,0.00,11.18,0.00,'2022-07-29 12:57:43','',''),(4852,'21','227','1',1,'Retail Sale Id 4923',995.60,0.00,0.00,1.31,0.00,'2022-07-29 12:58:25','',''),(4853,'21','227','1',1,'Retail Sale Id 4924',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 13:25:12','',''),(4854,'21','227','1',1,'Retail Sale Id 4925',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 13:25:57','',''),(4855,'21','227','1',1,'Retail Sale Id 4926',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 13:27:22','',''),(4856,'21','227','1',1,'Retail Sale Id 4927',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 13:28:56','',''),(4857,'21','227','1',1,'Retail Sale Id 4928',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 13:29:52','',''),(4858,'21','227','1',1,'Retail Sale Id 4929',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 13:34:16','',''),(4859,'21','227','1',1,'Retail Sale Id 4930',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 13:35:40','',''),(4860,'21','227','1',1,'Retail Sale Id 4931',3997.60,0.00,0.00,5.26,0.00,'2022-07-29 13:40:47','',''),(4861,'21','227','1',1,'Retail Sale Id 4932',3800.00,0.00,0.00,5.00,0.00,'2022-07-29 13:48:37','',''),(4862,'21','227','1',1,'Retail Sale Id 4933',3997.60,0.00,0.00,5.26,0.00,'2022-07-29 13:52:20','',''),(4863,'21','227','1',1,'Retail Sale Id 4934',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 13:55:00','',''),(4864,'21','227','1',1,'Retail Sale Id 4935',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 13:57:13','',''),(4865,'21','227','1',1,'Retail Sale Id 4936',3997.60,0.00,0.00,5.26,0.00,'2022-07-29 14:00:14','',''),(4866,'21','227','1',1,'Retail Sale Id 4937',798.00,0.00,0.00,1.05,0.00,'2022-07-29 14:03:11','',''),(4867,'21','227','1',1,'Retail Sale Id 4938',995.60,0.00,0.00,1.31,0.00,'2022-07-29 14:04:37','',''),(4868,'21','227','1',1,'Retail Sale Id 4939',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 14:16:57','',''),(4869,'21','227','1',1,'Retail Sale Id 4939',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 14:16:57','',''),(4870,'21','227','1',1,'Retail Sale Id 4940',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 14:19:48','',''),(4871,'21','227','1',1,'Retail Sale Id 4941',2295.20,0.00,0.00,3.02,0.00,'2022-07-29 14:23:56','',''),(4872,'21','227','1',1,'Retail Sale Id 4942',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 14:30:25','',''),(4873,'21','227','1',1,'Retail Sale Id 4943',699.20,0.00,0.00,0.92,0.00,'2022-07-29 14:33:36','',''),(4874,'21','227','1',1,'Retail Sale Id 4944',4499.20,0.00,0.00,5.92,0.00,'2022-07-29 14:35:52','',''),(4875,'21','227','1',1,'Retail Sale Id 4945',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 14:36:23','',''),(4876,'21','227','1',1,'Retail Sale Id 4946',3800.00,0.00,0.00,5.00,0.00,'2022-07-29 14:39:04','',''),(4877,'21','227','1',1,'Retail Sale Id 4947',2196.40,0.00,0.00,2.89,0.00,'2022-07-29 14:59:39','',''),(4878,'21','227','1',1,'Retail Sale Id 4948',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 15:02:15','',''),(4879,'21','227','1',1,'Retail Sale Id 4949',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 15:06:51','',''),(4880,'21','227','1',1,'Retail Sale Id 4949',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 15:06:51','',''),(4881,'21','227','1',1,'Retail Sale Id 4950',1694.80,0.00,0.00,2.23,0.00,'2022-07-29 15:39:31','',''),(4882,'21','227','1',1,'Retail Sale Id 4951',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 15:40:22','',''),(4883,'21','227','1',1,'Retail Sale Id 4952',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 15:43:30','',''),(4884,'21','227','1',1,'Retail Sale Id 4953',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 15:47:12','',''),(4885,'21','227','1',1,'Retail Sale Id 4954',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 15:49:54','',''),(4886,'21','227','1',1,'Retail Sale Id 4955',6999.60,0.00,0.00,9.21,0.00,'2022-07-29 15:52:20','',''),(4887,'21','227','1',1,'Retail Sale Id 4956',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 15:53:16','',''),(4888,'21','227','1',1,'Retail Sale Id 4957',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 15:57:40','',''),(4889,'21','227','1',1,'Retail Sale Id 4958',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 15:58:10','',''),(4890,'21','227','1',1,'Retail Sale Id 4959',494.00,0.00,0.00,0.65,0.00,'2022-07-29 15:59:01','',''),(4891,'21','227','1',1,'Retail Sale Id 4961',6840.00,0.00,0.00,9.00,0.00,'2022-07-29 15:59:57','',''),(4892,'21','227','1',1,'Retail Sale Id 4962',2394.00,0.00,0.00,3.15,0.00,'2022-07-29 16:00:38','',''),(4893,'21','227','1',1,'Retail Sale Id 4963',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 16:33:25','',''),(4894,'21','227','1',1,'Retail Sale Id 4964',995.60,0.00,0.00,1.31,0.00,'2022-07-29 16:41:33','',''),(4895,'21','227','1',1,'Retail Sale Id 4965',3800.00,0.00,0.00,5.00,0.00,'2022-07-29 16:49:54','',''),(4896,'21','227','1',1,'Retail Sale Id 4966',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 17:01:38','',''),(4897,'21','227','1',1,'Retail Sale Id 4967',995.60,0.00,0.00,1.31,0.00,'2022-07-29 17:06:49','',''),(4898,'21','227','1',1,'Retail Sale Id 4968',1497.20,0.00,0.00,1.97,0.00,'2022-07-29 17:14:22','',''),(4899,'21','227','1',1,'Retail Sale Id 4969',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 17:24:14','',''),(4900,'21','227','1',1,'Retail Sale Id 4970',995.60,0.00,0.00,1.31,0.00,'2022-07-29 17:26:06','',''),(4901,'21','227','1',1,'Retail Sale Id 4971',1520.00,0.00,0.00,2.00,0.00,'2022-07-29 17:31:12','',''),(4902,'21','227','1',1,'Retail Sale Id 4972',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 17:35:35','',''),(4903,'21','227','1',1,'Retail Sale Id 4973',2492.80,0.00,0.00,3.28,0.00,'2022-07-29 17:37:59','',''),(4904,'21','227','1',1,'Retail Sale Id 4974',995.60,0.00,0.00,1.31,0.00,'2022-07-29 17:43:13','',''),(4905,'21','227','1',1,'Retail Sale Id 4975',2994.40,0.00,0.00,3.94,0.00,'2022-07-29 17:54:01','',''),(4906,'21','227','1',1,'Retail Sale Id 4976',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 10:08:15','',''),(4907,'21','227','1',1,'Retail Sale Id 4977',1520.00,0.00,0.00,2.00,0.00,'2022-07-30 10:09:14','',''),(4908,'21','227','1',1,'Retail Sale Id 4978',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 10:10:48','',''),(4909,'21','227','1',1,'Retail Sale Id 4979',995.60,0.00,0.00,1.31,0.00,'2022-07-30 10:11:56','',''),(4910,'21','227','1',1,'Retail Sale Id 4980',2796.80,0.00,0.00,3.68,0.00,'2022-07-30 10:13:02','',''),(4911,'21','227','1',1,'Retail Sale Id 4981',995.60,0.00,0.00,1.31,0.00,'2022-07-30 10:14:18','',''),(4912,'21','227','1',1,'Retail Sale Id 4982',2280.00,0.00,0.00,3.00,0.00,'2022-07-30 10:16:41','',''),(4913,'21','227','1',1,'Retail Sale Id 4983',4993.20,0.00,0.00,6.57,0.00,'2022-07-30 10:17:31','',''),(4914,'21','227','1',1,'Retail Sale Id 4984',995.60,0.00,0.00,1.31,0.00,'2022-07-30 10:20:13','',''),(4915,'21','227','1',1,'Retail Sale Id 4985',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 10:22:49','',''),(4916,'21','227','1',1,'Retail Sale Id 4986',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 10:23:55','',''),(4917,'21','227','1',1,'Retail Sale Id 4987',995.60,0.00,0.00,1.31,0.00,'2022-07-30 10:26:27','',''),(4918,'21','227','1',1,'Retail Sale Id 4988',3040.00,0.00,0.00,4.00,0.00,'2022-07-30 10:27:51','',''),(4919,'21','227','1',1,'Retail Sale Id 4989',699.20,0.00,0.00,0.92,0.00,'2022-07-30 10:29:43','',''),(4920,'21','227','1',1,'Retail Sale Id 4990',6498.00,0.00,0.00,8.55,0.00,'2022-07-30 10:32:23','',''),(4921,'21','227','1',1,'Retail Sale Id 4991',2994.40,0.00,0.00,3.94,0.00,'2022-07-30 10:34:21','',''),(4922,'21','227','1',1,'Retail Sale Id 4992',3800.00,0.00,0.00,5.00,0.00,'2022-07-30 10:36:13','',''),(4923,'21','227','1',1,'Retail Sale Id 4993',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 10:38:53','',''),(4924,'21','227','1',1,'Retail Sale Id 4994',2280.00,0.00,0.00,3.00,0.00,'2022-07-30 10:44:35','',''),(4925,'21','227','1',1,'Retail Sale Id 4995',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 10:46:10','',''),(4926,'21','227','1',1,'Retail Sale Id 4996',995.60,0.00,0.00,1.31,0.00,'2022-07-30 10:47:33','',''),(4927,'21','227','1',1,'Retail Sale Id 4997',760.00,0.00,0.00,1.00,0.00,'2022-07-30 10:49:24','',''),(4928,'21','227','1',1,'Retail Sale Id 4998',995.60,0.00,0.00,1.31,0.00,'2022-07-30 10:52:50','',''),(4929,'21','227','1',1,'Retail Sale Id 4999',995.60,0.00,0.00,1.31,0.00,'2022-07-30 10:56:18','',''),(4930,'21','227','1',1,'Retail Sale Id 5000',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 10:58:44','',''),(4931,'21','227','1',1,'Retail Sale Id 5001',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 11:00:30','',''),(4932,'21','227','1',1,'Retail Sale Id 5002',3800.00,0.00,0.00,5.00,0.00,'2022-07-30 11:01:42','',''),(4933,'21','227','1',1,'Retail Sale Id 5003',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 11:04:06','',''),(4934,'21','227','1',1,'Retail Sale Id 5004',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 11:08:09','',''),(4935,'21','227','1',1,'Retail Sale Id 5005',3800.00,0.00,0.00,5.00,0.00,'2022-07-30 11:10:10','',''),(4936,'21','227','1',1,'Retail Sale Id 5006',798.00,0.00,0.00,1.05,0.00,'2022-07-30 11:11:07','',''),(4937,'21','227','1',1,'Retail Sale Id 5007',2994.40,0.00,0.00,3.94,0.00,'2022-07-30 11:12:33','',''),(4938,'21','227','1',1,'Retail Sale Id 5008',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 11:17:07','',''),(4939,'21','227','1',1,'Retail Sale Id 5009',1520.00,0.00,0.00,2.00,0.00,'2022-07-30 11:18:04','',''),(4940,'21','227','1',1,'Retail Sale Id 5010',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 11:20:30','',''),(4941,'21','227','1',1,'Retail Sale Id 5011',3800.00,0.00,0.00,5.00,0.00,'2022-07-30 11:21:41','',''),(4942,'21','227','1',1,'Retail Sale Id 5012',4499.20,0.00,0.00,5.92,0.00,'2022-07-30 11:22:48','',''),(4943,'21','227','1',1,'Retail Sale Id 5014',3496.00,0.00,0.00,4.60,0.00,'2022-07-30 11:24:13','',''),(4944,'21','227','1',1,'Retail Sale Id 5015',2994.40,0.00,0.00,3.94,0.00,'2022-07-30 11:26:57','',''),(4945,'21','227','1',1,'Retail Sale Id 5016',2280.00,0.00,0.00,3.00,0.00,'2022-07-30 11:28:08','',''),(4946,'21','227','1',1,'Retail Sale Id 5017',2994.40,0.00,0.00,3.94,0.00,'2022-07-30 11:30:07','',''),(4947,'21','227','1',1,'Retail Sale Id 5018',995.60,0.00,0.00,1.31,0.00,'2022-07-30 11:35:45','',''),(4948,'21','227','1',1,'Retail Sale Id 5020',2280.00,0.00,0.00,3.00,0.00,'2022-07-30 11:40:57','',''),(4949,'21','227','1',1,'Retail Sale Id 5021',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 11:46:41','',''),(4950,'21','227','1',1,'Retail Sale Id 5022',7600.00,0.00,0.00,10.00,0.00,'2022-07-30 11:47:42','',''),(4951,'21','227','1',1,'Retail Sale Id 5023',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 11:48:59','',''),(4952,'21','227','1',1,'Retail Sale Id 5024',995.60,0.00,0.00,1.31,0.00,'2022-07-30 11:50:43','',''),(4953,'21','227','1',1,'Retail Sale Id 5025',3997.60,0.00,0.00,5.26,0.00,'2022-07-30 11:51:48','',''),(4954,'21','227','1',1,'Retail Sale Id 5026',2994.40,0.00,0.00,3.94,0.00,'2022-07-30 11:53:03','',''),(4955,'21','227','1',1,'Retail Sale Id 5027',3800.00,0.00,0.00,5.00,0.00,'2022-07-30 11:55:46','',''),(4956,'21','227','1',1,'Retail Sale Id 5028',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 12:00:17','',''),(4957,'21','227','1',1,'Retail Sale Id 5029',2492.80,0.00,0.00,3.28,0.00,'2022-07-30 12:01:28','',''),(4958,'21','227','1',1,'Retail Sale Id 5030',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 12:03:10','',''),(4959,'21','227','1',1,'Retail Sale Id 5031',995.60,0.00,0.00,1.31,0.00,'2022-07-30 12:04:59','',''),(4960,'21','227','1',1,'Retail Sale Id 5032',995.60,0.00,0.00,1.31,0.00,'2022-07-30 12:10:44','',''),(4961,'21','227','1',1,'Retail Sale Id 5033',995.60,0.00,0.00,1.31,0.00,'2022-07-30 12:11:44','',''),(4962,'21','227','1',1,'Retail Sale Id 5034',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 12:12:36','',''),(4963,'21','227','1',1,'Retail Sale Id 5035',2994.40,0.00,0.00,3.94,0.00,'2022-07-30 12:23:13','',''),(4964,'21','227','1',1,'Retail Sale Id 5036',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 12:26:43','',''),(4965,'21','227','1',1,'Retail Sale Id 5037',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 12:28:16','',''),(4966,'21','227','1',1,'Retail Sale Id 5038',896.80,0.00,0.00,1.18,0.00,'2022-07-30 12:30:30','',''),(4967,'21','227','1',1,'Retail Sale Id 5039',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 12:31:35','',''),(4968,'21','227','1',1,'Retail Sale Id 5040',494.00,0.00,0.00,0.65,0.00,'2022-07-30 12:32:59','',''),(4969,'21','227','1',1,'Retail Sale Id 5041',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 12:38:13','',''),(4970,'21','227','1',1,'Retail Sale Id 5042',4993.20,0.00,0.00,6.57,0.00,'2022-07-30 12:39:25','',''),(4971,'21','227','1',1,'Retail Sale Id 5043',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 12:41:55','',''),(4972,'21','227','1',1,'Retail Sale Id 5044',798.00,0.00,0.00,1.05,0.00,'2022-07-30 12:47:33','',''),(4973,'21','227','1',1,'Retail Sale Id 5045',2994.40,0.00,0.00,3.94,0.00,'2022-07-30 12:49:38','',''),(4974,'21','227','1',1,'Retail Sale Id 5046',1193.20,0.00,0.00,1.57,0.00,'2022-07-30 12:50:59','',''),(4975,'21','227','1',1,'Retail Sale Id 5047',995.60,0.00,0.00,1.31,0.00,'2022-07-30 12:52:07','',''),(4976,'21','227','1',1,'Retail Sale Id 5048',4993.20,0.00,0.00,6.57,0.00,'2022-07-30 12:53:19','',''),(4977,'21','227','1',1,'Retail Sale Id 5049',995.60,0.00,0.00,1.31,0.00,'2022-07-30 12:55:10','',''),(4978,'21','227','1',1,'Retail Sale Id 5050',995.60,0.00,0.00,1.31,0.00,'2022-07-30 13:00:10','',''),(4979,'21','227','1',1,'Retail Sale Id 5051',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 13:01:10','',''),(4980,'21','227','1',1,'Retail Sale Id 5052',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 13:02:28','',''),(4981,'21','227','1',1,'Retail Sale Id 5053',1793.60,0.00,0.00,2.36,0.00,'2022-07-30 13:04:25','',''),(4982,'21','227','1',1,'Retail Sale Id 5054',995.60,0.00,0.00,1.31,0.00,'2022-07-30 13:06:35','',''),(4983,'21','227','1',1,'Retail Sale Id 5055',1497.20,0.00,0.00,1.97,0.00,'2022-07-30 13:11:19','',''),(4984,'21','227','1',1,'Retail Sale Id 5057',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 13:18:01','',''),(4985,'21','227','1',1,'Retail Sale Id 5059',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 13:20:18','',''),(4986,'21','227','1',1,'Retail Sale Id 5060',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 13:21:39','',''),(4987,'21','227','1',1,'Retail Sale Id 5061',3693.60,0.00,0.00,4.86,0.00,'2022-07-30 13:23:18','',''),(4988,'21','227','1',1,'Retail Sale Id 5062',2492.80,0.00,0.00,3.28,0.00,'2022-07-30 13:24:32','',''),(4989,'21','227','1',1,'Retail Sale Id 5063',2280.00,0.00,0.00,3.00,0.00,'2022-07-30 13:27:32','',''),(4990,'21','227','1',1,'Retail Sale Id 5064',3040.00,0.00,0.00,4.00,0.00,'2022-07-30 13:32:39','',''),(4991,'21','227','1',1,'Retail Sale Id 5065',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 13:40:17','',''),(4992,'21','227','1',1,'Retail Sale Id 5066',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 13:41:35','',''),(4993,'21','227','1',1,'Retail Sale Id 5067',1596.00,0.00,0.00,2.10,0.00,'2022-07-30 13:43:03','',''),(4994,'21','227','1',1,'Retail Sale Id 5068',1520.00,0.00,0.00,2.00,0.00,'2022-07-30 13:44:18','',''),(4995,'21','227','1',1,'Retail Sale Id 5069',1520.00,0.00,0.00,2.00,0.00,'2022-07-30 13:46:43','',''),(4996,'21','227','1',1,'Retail Sale Id 5070',4993.20,0.00,0.00,6.57,0.00,'2022-07-30 13:47:50','',''),(4997,'21','227','1',1,'Retail Sale Id 5071',2280.00,0.00,0.00,3.00,0.00,'2022-07-30 13:49:32','',''),(4998,'21','227','1',1,'Retail Sale Id 5072',2295.20,0.00,0.00,3.02,0.00,'2022-07-30 13:51:55','',''),(4999,'21','227','1',1,'Retail Sale Id 5073',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 13:53:04','',''),(5000,'21','227','1',1,'Retail Sale Id 5074',2280.00,0.00,0.00,3.00,0.00,'2022-07-30 13:57:42','',''),(5001,'21','227','1',1,'Retail Sale Id 5075',26600.00,0.00,0.00,35.00,0.00,'2022-07-30 14:20:05','',''),(5002,'21','227','1',1,'Retail Sale Id 5076',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 14:21:59','',''),(5003,'21','227','1',1,'Retail Sale Id 5077',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 14:25:32','',''),(5004,'21','227','1',1,'Retail Sale Id 5078',4993.20,0.00,0.00,6.57,0.00,'2022-07-30 14:36:11','',''),(5005,'21','227','1',1,'Retail Sale Id 5079',1998.80,0.00,0.00,2.63,0.00,'2022-07-30 14:37:02','',''),(5006,'21','227','1',1,'Retail Sale Id 5080',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 16:06:54','',''),(5007,'21','227','1',1,'Retail Sale Id 5081',20998.80,0.00,0.00,27.63,0.00,'2022-07-30 16:09:19','',''),(5008,'21','227','1',1,'Retail Sale Id 5082',6999.60,0.00,0.00,9.21,0.00,'2022-07-30 16:11:38','',''),(5009,'21','227','1',1,'Retail Sale Id 5083',129200.00,0.00,0.00,170.00,0.00,'2022-07-30 18:04:14','',''),(5010,'21','227','1',1,'Retail Sale Id 5084',2698.00,0.00,0.00,3.55,0.00,'2022-07-30 18:06:05','',''),(5011,'21','227','1',1,'Retail Sale Id 5085',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 08:53:00','',''),(5012,'21','227','1',1,'Retail Sale Id 5086',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 08:53:33','',''),(5013,'21','227','1',1,'Retail Sale Id 5087',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 08:54:00','',''),(5014,'21','227','1',1,'Retail Sale Id 5088',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 08:54:33','',''),(5015,'21','227','1',1,'Retail Sale Id 5089',4499.20,0.00,0.00,5.92,0.00,'2022-07-31 08:55:14','',''),(5016,'21','227','1',1,'Retail Sale Id 5090',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 09:01:06','',''),(5017,'21','227','1',1,'Retail Sale Id 5091',19000.00,0.00,0.00,25.00,0.00,'2022-07-31 09:10:52','',''),(5018,'21','227','1',1,'Retail Sale Id 5092',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 09:23:49','',''),(5019,'21','227','1',1,'Retail Sale Id 5093',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 09:26:25','',''),(5020,'21','227','1',1,'Retail Sale Id 5094',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 09:27:47','',''),(5021,'21','227','1',1,'Retail Sale Id 5095',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 09:28:50','',''),(5022,'21','227','1',1,'Retail Sale Id 5096',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 09:31:21','',''),(5023,'21','227','1',1,'Retail Sale Id 5097',995.60,0.00,0.00,1.31,0.00,'2022-07-31 09:32:10','',''),(5024,'21','227','1',1,'Retail Sale Id 5099',3496.00,0.00,0.00,4.60,0.00,'2022-07-31 09:35:52','',''),(5025,'21','227','1',1,'Retail Sale Id 5100',4499.20,0.00,0.00,5.92,0.00,'2022-07-31 09:37:29','',''),(5026,'21','227','1',1,'Retail Sale Id 5101',2492.80,0.00,0.00,3.28,0.00,'2022-07-31 09:38:29','',''),(5027,'21','227','1',1,'Retail Sale Id 5102',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 09:39:36','',''),(5028,'21','227','1',1,'Retail Sale Id 5103',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 09:47:12','',''),(5029,'21','227','1',1,'Retail Sale Id 5104',995.60,0.00,0.00,1.31,0.00,'2022-07-31 09:49:07','',''),(5030,'21','227','1',1,'Retail Sale Id 5105',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 09:58:28','',''),(5031,'21','227','1',1,'Retail Sale Id 5106',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 09:59:46','',''),(5032,'21','227','1',1,'Retail Sale Id 5107',2599.20,0.00,0.00,3.42,0.00,'2022-07-31 10:04:18','',''),(5033,'21','227','1',1,'Retail Sale Id 5108',798.00,0.00,0.00,1.05,0.00,'2022-07-31 10:08:24','',''),(5034,'21','227','1',1,'Retail Sale Id 5109',995.60,0.00,0.00,1.31,0.00,'2022-07-31 10:09:15','',''),(5035,'21','227','1',1,'Retail Sale Id 5110',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 10:10:21','',''),(5036,'21','227','1',1,'Retail Sale Id 5111',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 10:12:34','',''),(5037,'21','227','1',1,'Retail Sale Id 5112',995.60,0.00,0.00,1.31,0.00,'2022-07-31 10:14:04','',''),(5038,'21','227','1',1,'Retail Sale Id 5113',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 10:17:46','',''),(5039,'21','227','1',1,'Retail Sale Id 5114',798.00,0.00,0.00,1.05,0.00,'2022-07-31 10:23:13','',''),(5040,'21','227','1',1,'Retail Sale Id 5115',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 10:26:50','',''),(5041,'21','227','1',1,'Retail Sale Id 5116',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 10:27:48','',''),(5042,'21','227','1',1,'Retail Sale Id 5117',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 10:28:52','',''),(5043,'21','227','1',1,'Retail Sale Id 5118',995.60,0.00,0.00,1.31,0.00,'2022-07-31 10:31:12','',''),(5044,'21','227','1',1,'Retail Sale Id 5119',2295.20,0.00,0.00,3.02,0.00,'2022-07-31 10:32:40','',''),(5045,'21','227','1',1,'Retail Sale Id 5120',494.00,0.00,0.00,0.65,0.00,'2022-07-31 10:34:24','',''),(5046,'21','227','1',1,'Retail Sale Id 5121',4499.20,0.00,0.00,5.92,0.00,'2022-07-31 10:35:12','',''),(5047,'21','227','1',1,'Retail Sale Id 5122',4499.20,0.00,0.00,5.92,0.00,'2022-07-31 10:38:35','',''),(5048,'21','227','1',1,'Retail Sale Id 5123',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 10:39:10','',''),(5049,'21','227','1',1,'Retail Sale Id 5124',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 10:57:04','',''),(5050,'21','227','1',1,'Retail Sale Id 5125',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 10:58:38','',''),(5051,'21','227','1',1,'Retail Sale Id 5126',2492.80,0.00,0.00,3.28,0.00,'2022-07-31 10:59:34','',''),(5052,'21','227','1',1,'Retail Sale Id 5127',2492.80,0.00,0.00,3.28,0.00,'2022-07-31 11:01:04','',''),(5053,'21','227','1',1,'Retail Sale Id 5128',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 11:03:35','',''),(5054,'21','227','1',1,'Retail Sale Id 5129',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 11:05:17','',''),(5055,'21','227','1',1,'Retail Sale Id 5130',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 11:14:36','',''),(5056,'21','227','1',1,'Retail Sale Id 5131',995.60,0.00,0.00,1.31,0.00,'2022-07-31 11:18:06','',''),(5057,'21','227','1',1,'Retail Sale Id 5132',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:19:33','',''),(5058,'21','227','1',1,'Retail Sale Id 5133',2492.80,0.00,0.00,3.28,0.00,'2022-07-31 11:24:02','',''),(5059,'21','227','1',1,'Retail Sale Id 5134',4499.20,0.00,0.00,5.92,0.00,'2022-07-31 11:26:41','',''),(5060,'21','227','1',1,'Retail Sale Id 5135',995.60,0.00,0.00,1.31,0.00,'2022-07-31 11:29:46','',''),(5061,'21','227','1',1,'Retail Sale Id 5136',2492.80,0.00,0.00,3.28,0.00,'2022-07-31 11:30:38','',''),(5062,'21','227','1',1,'Retail Sale Id 5137',798.00,0.00,0.00,1.05,0.00,'2022-07-31 11:31:54','',''),(5063,'21','227','1',1,'Retail Sale Id 5138',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 11:32:45','',''),(5064,'21','227','1',1,'Retail Sale Id 5139',1801.20,0.00,0.00,2.37,0.00,'2022-07-31 11:34:04','',''),(5065,'21','227','1',1,'Retail Sale Id 5140',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 11:36:30','',''),(5066,'21','227','1',1,'Retail Sale Id 5141',2492.80,0.00,0.00,3.28,0.00,'2022-07-31 11:41:52','',''),(5067,'21','227','1',1,'Retail Sale Id 5142',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 11:46:50','',''),(5068,'21','227','1',1,'Retail Sale Id 5143',3040.00,0.00,0.00,4.00,0.00,'2022-07-31 12:02:20','',''),(5069,'21','227','1',1,'Retail Sale Id 5144',995.60,0.00,0.00,1.31,0.00,'2022-07-31 12:11:54','',''),(5070,'21','227','1',1,'Retail Sale Id 5145',2492.80,0.00,0.00,3.28,0.00,'2022-07-31 12:13:05','',''),(5071,'21','227','1',1,'Retail Sale Id 5146',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 12:13:48','',''),(5072,'21','227','1',1,'Retail Sale Id 5147',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 12:15:38','',''),(5073,'21','227','1',1,'Retail Sale Id 5148',995.60,0.00,0.00,1.31,0.00,'2022-07-31 12:19:39','',''),(5074,'21','227','1',1,'Retail Sale Id 5148',1793.60,0.00,0.00,2.36,0.00,'2022-07-31 12:19:39','',''),(5075,'21','227','1',1,'Retail Sale Id 5149',7995.20,0.00,0.00,10.52,0.00,'2022-07-31 12:21:29','',''),(5076,'21','227','1',1,'Retail Sale Id 5150',45600.00,0.00,0.00,60.00,0.00,'2022-07-31 12:22:37','',''),(5077,'21','227','1',1,'Retail Sale Id 5151',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:23:26','',''),(5078,'21','227','1',1,'Retail Sale Id 5152',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:24:06','',''),(5079,'21','227','1',1,'Retail Sale Id 5153',1793.60,0.00,0.00,2.36,0.00,'2022-07-31 12:38:59','',''),(5080,'21','227','1',1,'Retail Sale Id 5154',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 12:44:38','',''),(5081,'21','227','1',1,'Retail Sale Id 5155',995.60,0.00,0.00,1.31,0.00,'2022-07-31 12:46:46','',''),(5082,'21','227','1',1,'Retail Sale Id 5156',1694.80,0.00,0.00,2.23,0.00,'2022-07-31 12:50:08','',''),(5083,'21','227','1',1,'Retail Sale Id 5157',2994.40,0.00,0.00,3.94,0.00,'2022-07-31 12:57:59','',''),(5084,'21','227','1',1,'Retail Sale Id 5158',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:02:00','',''),(5085,'21','227','1',1,'Retail Sale Id 5159',76000.00,0.00,0.00,100.00,0.00,'2022-07-31 13:49:41','',''),(5086,'21','227','1',1,'Retail Sale Id 5160',22800.00,0.00,0.00,30.00,0.00,'2022-07-31 13:50:40','',''),(5087,'21','227','1',1,'Retail Sale Id 5161',995.60,0.00,0.00,1.31,0.00,'2022-07-31 15:00:25','',''),(5088,'21','227','1',1,'Retail Sale Id 5162',494.00,0.00,0.00,0.65,0.00,'2022-07-31 15:01:42','',''),(5089,'21','227','1',1,'Retail Sale Id 5162',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 15:01:42','',''),(5090,'21','227','1',1,'Retail Sale Id 5163',2599.20,0.00,0.00,3.42,0.00,'2022-07-31 15:02:59','',''),(5091,'21','227','1',1,'Retail Sale Id 5164',760.00,0.00,0.00,1.00,0.00,'2022-07-31 15:03:45','',''),(5092,'21','227','1',1,'Retail Sale Id 5165',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 15:07:42','',''),(5093,'21','227','1',1,'Retail Sale Id 5166',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 15:10:03','',''),(5094,'21','227','1',1,'Retail Sale Id 5167',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 15:12:20','',''),(5095,'21','227','1',1,'Retail Sale Id 5168',98800.00,0.00,0.00,130.00,0.00,'2022-07-31 15:16:09','',''),(5096,'21','227','1',1,'Retail Sale Id 5169',995.60,0.00,0.00,1.31,0.00,'2022-07-31 15:17:18','',''),(5097,'21','227','1',1,'Retail Sale Id 5170',995.60,0.00,0.00,1.31,0.00,'2022-07-31 15:43:17','',''),(5098,'21','227','1',1,'Retail Sale Id 5171',798.00,0.00,0.00,1.05,0.00,'2022-07-31 15:45:10','',''),(5099,'21','227','1',1,'Retail Sale Id 5172',995.60,0.00,0.00,1.31,0.00,'2022-07-31 15:45:58','',''),(5100,'21','227','1',1,'Retail Sale Id 5173',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 15:46:53','',''),(5101,'21','227','1',1,'Retail Sale Id 5174',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 15:47:55','',''),(5102,'21','227','1',1,'Retail Sale Id 5175',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 15:49:35','',''),(5103,'21','227','1',1,'Retail Sale Id 5176',798.00,0.00,0.00,1.05,0.00,'2022-07-31 15:50:48','',''),(5104,'21','227','1',1,'Retail Sale Id 5177',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 15:52:01','',''),(5105,'21','227','1',1,'Retail Sale Id 5177',2994.40,0.00,0.00,3.94,0.00,'2022-07-31 15:52:01','',''),(5106,'21','227','1',1,'Retail Sale Id 5178',3997.60,0.00,0.00,5.26,0.00,'2022-07-31 15:52:52','',''),(5107,'21','227','1',1,'Retail Sale Id 5179',4499.20,0.00,0.00,5.92,0.00,'2022-07-31 15:54:14','',''),(5108,'21','227','1',1,'Retail Sale Id 5180',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 15:55:13','',''),(5109,'21','227','1',1,'Retail Sale Id 5181',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 16:19:25','',''),(5110,'21','227','1',1,'Retail Sale Id 5182',3040.00,0.00,0.00,4.00,0.00,'2022-07-31 16:21:56','',''),(5111,'21','227','1',1,'Retail Sale Id 5183',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 16:23:48','',''),(5112,'21','227','1',1,'Retail Sale Id 5184',60800.00,0.00,0.00,80.00,0.00,'2022-07-31 16:31:49','',''),(5113,'21','227','1',1,'Retail Sale Id 5185',995.60,0.00,0.00,1.31,0.00,'2022-07-31 16:33:17','',''),(5114,'21','227','1',1,'Retail Sale Id 5186',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 16:35:09','',''),(5115,'21','227','1',1,'Retail Sale Id 5187',2492.80,0.00,0.00,3.28,0.00,'2022-07-31 16:42:39','',''),(5116,'21','227','1',1,'Retail Sale Id 5188',3496.00,0.00,0.00,4.60,0.00,'2022-07-31 16:48:51','',''),(5117,'21','227','1',1,'Retail Sale Id 5189',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 16:51:08','',''),(5118,'21','227','1',1,'Retail Sale Id 5190',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 17:27:56','',''),(5119,'21','227','1',1,'Retail Sale Id 5191',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 17:28:57','',''),(5120,'21','227','1',1,'Retail Sale Id 5192',4993.20,0.00,0.00,6.57,0.00,'2022-07-31 17:30:00','',''),(5121,'21','227','1',1,'Retail Sale Id 5193',2295.20,0.00,0.00,3.02,0.00,'2022-07-31 17:32:15','',''),(5122,'21','227','1',1,'Retail Sale Id 5195',2994.40,0.00,0.00,3.94,0.00,'2022-07-31 17:33:31','',''),(5123,'21','227','1',1,'Retail Sale Id 5196',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 17:34:38','',''),(5124,'21','227','1',1,'Retail Sale Id 5197',995.60,0.00,0.00,1.31,0.00,'2022-07-31 17:35:33','',''),(5125,'21','227','1',1,'Retail Sale Id 5198',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 17:36:45','',''),(5126,'21','227','1',1,'Retail Sale Id 5199',2994.40,0.00,0.00,3.94,0.00,'2022-07-31 17:38:05','',''),(5127,'21','227','1',1,'Retail Sale Id 5200',494.00,0.00,0.00,0.65,0.00,'2022-07-31 17:39:10','',''),(5128,'21','227','1',1,'Retail Sale Id 5201',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 17:40:13','',''),(5129,'21','227','1',1,'Retail Sale Id 5202',2994.40,0.00,0.00,3.94,0.00,'2022-07-31 17:47:26','',''),(5130,'21','227','1',1,'Retail Sale Id 5202',2994.40,0.00,0.00,3.94,0.00,'2022-07-31 17:47:26','',''),(5131,'21','227','1',1,'Retail Sale Id 5203',995.60,0.00,0.00,1.31,0.00,'2022-07-31 17:48:21','',''),(5132,'21','227','1',1,'Retail Sale Id 5204',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 17:49:08','',''),(5133,'21','227','1',1,'Retail Sale Id 5205',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 17:55:19','',''),(5134,'21','227','1',1,'Retail Sale Id 5206',2994.40,0.00,0.00,3.94,0.00,'2022-07-31 17:56:41','',''),(5135,'21','227','1',1,'Retail Sale Id 5207',494.00,0.00,0.00,0.65,0.00,'2022-07-31 17:57:46','',''),(5136,'21','227','1',1,'Retail Sale Id 5208',798.00,0.00,0.00,1.05,0.00,'2022-07-31 17:58:46','',''),(5137,'21','227','1',1,'Retail Sale Id 5209',3800.00,0.00,0.00,5.00,0.00,'2022-08-01 00:04:39','',''),(5138,'21','227','1',1,'Retail Sale Id 5210',3040.00,0.00,0.00,4.00,0.00,'2022-08-01 09:16:30','',''),(5139,'21','227','1',1,'Retail Sale Id 5211',3040.00,0.00,0.00,4.00,0.00,'2022-08-01 10:46:38','',''),(5140,'21','227','1',1,'Retail Sale Id 5211',4993.20,0.00,0.00,6.57,0.00,'2022-08-01 10:46:38','',''),(5141,'21','227','1',1,'Retail Sale Id 5211',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 10:46:38','',''),(5142,'21','227','1',1,'Retail Sale Id 5211',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 10:46:38','',''),(5143,'21','227','1',1,'Retail Sale Id 5212',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 10:47:53','',''),(5144,'21','227','1',1,'Retail Sale Id 5212',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 10:47:53','',''),(5145,'21','227','1',1,'Retail Sale Id 5212',3496.00,0.00,0.00,4.60,0.00,'2022-08-01 10:47:53','',''),(5146,'21','227','1',1,'Retail Sale Id 5212',3997.60,0.00,0.00,5.26,0.00,'2022-08-01 10:47:53','',''),(5147,'21','227','1',1,'Retail Sale Id 5213',2196.40,0.00,0.00,2.89,0.00,'2022-08-01 10:49:45','',''),(5148,'21','227','1',1,'Retail Sale Id 5213',3997.60,0.00,0.00,5.26,0.00,'2022-08-01 10:49:45','',''),(5149,'21','227','1',1,'Retail Sale Id 5213',4499.20,0.00,0.00,5.92,0.00,'2022-08-01 10:49:45','',''),(5150,'21','227','1',1,'Retail Sale Id 5213',4499.20,0.00,0.00,5.92,0.00,'2022-08-01 10:49:45','',''),(5151,'21','227','1',1,'Retail Sale Id 5213',4499.20,0.00,0.00,5.92,0.00,'2022-08-01 10:49:45','',''),(5152,'21','227','1',1,'Retail Sale Id 5213',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 10:49:45','',''),(5153,'21','227','1',1,'Retail Sale Id 5213',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 10:49:45','',''),(5154,'21','227','1',1,'Retail Sale Id 5214',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 10:52:49','',''),(5155,'21','227','1',1,'Retail Sale Id 5214',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 10:52:49','',''),(5156,'21','227','1',1,'Retail Sale Id 5214',1793.60,0.00,0.00,2.36,0.00,'2022-08-01 10:52:49','',''),(5157,'21','227','1',1,'Retail Sale Id 5214',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 10:52:49','',''),(5158,'21','227','1',1,'Retail Sale Id 5214',2994.40,0.00,0.00,3.94,0.00,'2022-08-01 10:52:49','',''),(5159,'21','227','1',1,'Retail Sale Id 5214',8496.80,0.00,0.00,11.18,0.00,'2022-08-01 10:52:49','',''),(5160,'21','227','1',1,'Retail Sale Id 5215',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 10:54:47','',''),(5161,'21','227','1',1,'Retail Sale Id 5215',2295.20,0.00,0.00,3.02,0.00,'2022-08-01 10:54:47','',''),(5162,'21','227','1',1,'Retail Sale Id 5215',2994.40,0.00,0.00,3.94,0.00,'2022-08-01 10:54:47','',''),(5163,'21','227','1',1,'Retail Sale Id 5215',2994.40,0.00,0.00,3.94,0.00,'2022-08-01 10:54:47','',''),(5164,'21','227','1',1,'Retail Sale Id 5215',5076.80,0.00,0.00,6.68,0.00,'2022-08-01 10:54:47','',''),(5165,'21','227','1',1,'Retail Sale Id 5215',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 10:54:47','',''),(5166,'21','227','1',1,'Retail Sale Id 5216',995.60,0.00,0.00,1.31,0.00,'2022-08-01 10:56:44','',''),(5167,'21','227','1',1,'Retail Sale Id 5216',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 10:56:44','',''),(5168,'21','227','1',1,'Retail Sale Id 5216',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 10:56:44','',''),(5169,'21','227','1',1,'Retail Sale Id 5217',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 10:57:42','',''),(5170,'21','227','1',1,'Retail Sale Id 5218',2994.40,0.00,0.00,3.94,0.00,'2022-08-01 10:59:33','',''),(5171,'21','227','1',1,'Retail Sale Id 5219',4993.20,0.00,0.00,6.57,0.00,'2022-08-01 11:01:37','',''),(5172,'21','227','1',1,'Retail Sale Id 5220',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 11:02:20','',''),(5173,'21','227','1',1,'Retail Sale Id 5221',995.60,0.00,0.00,1.31,0.00,'2022-08-01 11:04:15','',''),(5174,'21','227','1',1,'Retail Sale Id 5222',798.00,0.00,0.00,1.05,0.00,'2022-08-01 11:06:00','',''),(5175,'21','227','1',1,'Retail Sale Id 5223',63209.20,0.00,0.00,83.17,0.00,'2022-08-01 11:08:37','',''),(5176,'21','227','1',1,'Retail Sale Id 5224',3800.00,0.00,0.00,5.00,0.00,'2022-08-01 11:09:57','',''),(5177,'21','227','1',1,'Retail Sale Id 5225',1520.00,0.00,0.00,2.00,0.00,'2022-08-01 11:11:41','',''),(5178,'21','227','1',1,'Retail Sale Id 5226',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 11:12:39','',''),(5179,'21','227','1',1,'Retail Sale Id 5227',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 11:14:48','',''),(5180,'21','227','1',1,'Retail Sale Id 5228',3997.60,0.00,0.00,5.26,0.00,'2022-08-01 11:15:44','',''),(5181,'21','227','1',1,'Retail Sale Id 5229',494.00,0.00,0.00,0.65,0.00,'2022-08-01 11:16:28','',''),(5182,'21','227','1',1,'Retail Sale Id 5230',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 11:18:13','',''),(5183,'21','227','1',1,'Retail Sale Id 5231',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 11:24:54','',''),(5184,'21','227','1',1,'Retail Sale Id 5232',494.00,0.00,0.00,0.65,0.00,'2022-08-01 11:26:13','',''),(5185,'21','227','1',1,'Retail Sale Id 5233',2295.20,0.00,0.00,3.02,0.00,'2022-08-01 11:27:45','',''),(5186,'21','227','1',1,'Retail Sale Id 5234',494.00,0.00,0.00,0.65,0.00,'2022-08-01 11:28:57','',''),(5187,'21','227','1',1,'Retail Sale Id 5235',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 11:29:53','',''),(5188,'21','227','1',1,'Retail Sale Id 5236',14493.20,0.00,0.00,19.07,0.00,'2022-08-01 11:45:29','',''),(5189,'21','227','1',1,'Retail Sale Id 5237',2994.40,0.00,0.00,3.94,0.00,'2022-08-01 11:57:32','',''),(5190,'21','227','1',1,'Retail Sale Id 5238',2492.80,0.00,0.00,3.28,0.00,'2022-08-01 12:08:38','',''),(5191,'21','227','1',1,'Retail Sale Id 5239',995.60,0.00,0.00,1.31,0.00,'2022-08-01 12:14:17','',''),(5192,'21','227','1',1,'Retail Sale Id 5240',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 12:16:45','',''),(5193,'21','227','1',1,'Retail Sale Id 5241',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 12:19:13','',''),(5194,'21','227','1',1,'Retail Sale Id 5242',1193.20,0.00,0.00,1.57,0.00,'2022-08-01 12:21:25','',''),(5195,'21','227','1',1,'Retail Sale Id 5243',4993.20,0.00,0.00,6.57,0.00,'2022-08-01 12:22:19','',''),(5196,'21','227','1',1,'Retail Sale Id 5244',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 12:23:14','',''),(5197,'21','227','1',1,'Retail Sale Id 5245',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 12:25:26','',''),(5198,'21','227','1',1,'Retail Sale Id 5246',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 12:27:17','',''),(5199,'21','227','1',1,'Retail Sale Id 5247',995.60,0.00,0.00,1.31,0.00,'2022-08-01 12:28:09','',''),(5200,'21','227','1',1,'Retail Sale Id 5248',995.60,0.00,0.00,1.31,0.00,'2022-08-01 12:33:29','',''),(5201,'21','227','1',1,'Retail Sale Id 5249',1193.20,0.00,0.00,1.57,0.00,'2022-08-01 12:34:19','',''),(5202,'21','227','1',1,'Retail Sale Id 5250',995.60,0.00,0.00,1.31,0.00,'2022-08-01 12:35:36','',''),(5203,'21','227','1',1,'Retail Sale Id 5251',7600.00,0.00,0.00,10.00,0.00,'2022-08-01 12:39:23','',''),(5204,'21','227','1',1,'Retail Sale Id 5252',4499.20,0.00,0.00,5.92,0.00,'2022-08-01 12:40:10','',''),(5205,'21','227','1',1,'Retail Sale Id 5253',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 12:41:52','',''),(5206,'21','227','1',1,'Retail Sale Id 5254',8998.40,0.00,0.00,11.84,0.00,'2022-08-01 12:45:12','',''),(5207,'21','227','1',1,'Retail Sale Id 5255',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 12:46:32','',''),(5208,'21','227','1',1,'Retail Sale Id 5256',995.60,0.00,0.00,1.31,0.00,'2022-08-01 12:49:18','',''),(5209,'21','227','1',1,'Retail Sale Id 5257',995.60,0.00,0.00,1.31,0.00,'2022-08-01 12:50:00','',''),(5210,'21','227','1',1,'Retail Sale Id 5258',995.60,0.00,0.00,1.31,0.00,'2022-08-01 12:52:48','',''),(5211,'21','227','1',1,'Retail Sale Id 5258',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 12:52:48','',''),(5212,'21','227','1',1,'Retail Sale Id 5259',2492.80,0.00,0.00,3.28,0.00,'2022-08-01 12:54:57','',''),(5213,'21','227','1',1,'Retail Sale Id 5260',3997.60,0.00,0.00,5.26,0.00,'2022-08-01 12:57:54','',''),(5214,'21','227','1',1,'Retail Sale Id 5261',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 13:01:23','',''),(5215,'21','227','1',1,'Retail Sale Id 5262',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 13:02:44','',''),(5216,'21','227','1',1,'Retail Sale Id 5263',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 13:09:30','',''),(5217,'21','227','1',1,'Retail Sale Id 5264',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 13:12:52','',''),(5218,'21','227','1',1,'Retail Sale Id 5265',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 13:16:35','',''),(5219,'21','227','1',1,'Retail Sale Id 5266',2492.80,0.00,0.00,3.28,0.00,'2022-08-01 13:20:14','',''),(5220,'21','227','1',1,'Retail Sale Id 5267',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 13:21:27','',''),(5221,'21','227','1',1,'Retail Sale Id 5268',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 13:23:40','',''),(5222,'21','227','1',1,'Retail Sale Id 5269',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 13:50:35','',''),(5223,'21','227','1',1,'Retail Sale Id 5270',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 13:54:08','',''),(5224,'21','227','1',1,'Retail Sale Id 5270',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 13:54:08','',''),(5225,'21','227','1',1,'Retail Sale Id 5270',1520.00,0.00,0.00,2.00,0.00,'2022-08-01 13:54:08','',''),(5226,'21','227','1',1,'Retail Sale Id 5270',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 13:54:08','',''),(5227,'21','227','1',1,'Retail Sale Id 5270',2994.40,0.00,0.00,3.94,0.00,'2022-08-01 13:54:08','',''),(5228,'21','227','1',1,'Retail Sale Id 5270',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 13:54:08','',''),(5229,'21','227','1',1,'Retail Sale Id 5270',4993.20,0.00,0.00,6.57,0.00,'2022-08-01 13:54:08','',''),(5230,'21','227','1',1,'Retail Sale Id 5271',3997.60,0.00,0.00,5.26,0.00,'2022-08-01 13:57:00','',''),(5231,'21','227','1',1,'Retail Sale Id 5272',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 13:59:09','',''),(5232,'21','227','1',1,'Retail Sale Id 5273',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 14:00:14','',''),(5233,'21','227','1',1,'Retail Sale Id 5274',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 14:02:53','',''),(5234,'21','227','1',1,'Retail Sale Id 5275',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 14:04:30','',''),(5235,'21','227','1',1,'Retail Sale Id 5276',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 14:05:29','',''),(5236,'21','227','1',1,'Retail Sale Id 5277',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 14:07:23','',''),(5237,'21','227','1',1,'Retail Sale Id 5278',3800.00,0.00,0.00,5.00,0.00,'2022-08-01 14:09:42','',''),(5238,'21','227','1',1,'Retail Sale Id 5279',1900.00,0.00,0.00,2.50,0.00,'2022-08-01 14:14:30','',''),(5239,'21','227','1',1,'Retail Sale Id 5280',7600.00,0.00,0.00,10.00,0.00,'2022-08-01 14:22:49','',''),(5240,'21','227','1',1,'Retail Sale Id 5281',995.60,0.00,0.00,1.31,0.00,'2022-08-01 14:23:44','',''),(5241,'21','227','1',1,'Retail Sale Id 5282',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 14:25:01','',''),(5242,'21','227','1',1,'Retail Sale Id 5283',1520.00,0.00,0.00,2.00,0.00,'2022-08-01 14:28:16','',''),(5243,'21','227','1',1,'Retail Sale Id 5284',2994.40,0.00,0.00,3.94,0.00,'2022-08-01 14:28:58','',''),(5244,'21','227','1',1,'Retail Sale Id 5285',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 14:29:54','',''),(5245,'21','227','1',1,'Retail Sale Id 5286',2492.80,0.00,0.00,3.28,0.00,'2022-08-01 14:33:20','',''),(5246,'21','227','1',1,'Retail Sale Id 5287',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 14:35:19','',''),(5247,'21','227','1',1,'Retail Sale Id 5288',1193.20,0.00,0.00,1.57,0.00,'2022-08-01 14:38:10','',''),(5248,'21','227','1',1,'Retail Sale Id 5289',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 14:39:18','',''),(5249,'21','227','1',1,'Retail Sale Id 5290',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 14:39:57','',''),(5250,'21','227','1',1,'Retail Sale Id 5291',1520.00,0.00,0.00,2.00,0.00,'2022-08-01 14:40:51','',''),(5251,'21','227','1',1,'Retail Sale Id 5292',1793.60,0.00,0.00,2.36,0.00,'2022-08-01 14:41:55','',''),(5252,'21','227','1',1,'Retail Sale Id 5293',798.00,0.00,0.00,1.05,0.00,'2022-08-01 14:45:06','',''),(5253,'21','227','1',1,'Retail Sale Id 5294',3997.60,0.00,0.00,5.26,0.00,'2022-08-01 14:46:07','',''),(5254,'21','227','1',1,'Retail Sale Id 5295',34998.00,0.00,0.00,46.05,0.00,'2022-08-01 14:49:51','',''),(5255,'21','227','1',1,'Retail Sale Id 5296',3800.00,0.00,0.00,5.00,0.00,'2022-08-01 14:56:28','',''),(5256,'21','227','1',1,'Retail Sale Id 5298',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 14:59:55','',''),(5257,'21','227','1',1,'Retail Sale Id 5299',760.00,0.00,0.00,1.00,0.00,'2022-08-01 17:40:17','',''),(5258,'21','227','1',1,'Retail Sale Id 5299',798.00,0.00,0.00,1.05,0.00,'2022-08-01 17:40:17','',''),(5259,'21','227','1',1,'Retail Sale Id 5299',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 17:40:17','',''),(5260,'21','227','1',1,'Retail Sale Id 5299',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 17:40:17','',''),(5261,'21','227','1',1,'Retail Sale Id 5299',3800.00,0.00,0.00,5.00,0.00,'2022-08-01 17:40:17','',''),(5262,'21','227','1',1,'Retail Sale Id 5300',798.00,0.00,0.00,1.05,0.00,'2022-08-01 17:42:03','',''),(5263,'21','227','1',1,'Retail Sale Id 5300',995.60,0.00,0.00,1.31,0.00,'2022-08-01 17:42:03','',''),(5264,'21','227','1',1,'Retail Sale Id 5300',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 17:42:03','',''),(5265,'21','227','1',1,'Retail Sale Id 5300',1520.00,0.00,0.00,2.00,0.00,'2022-08-01 17:42:03','',''),(5266,'21','227','1',1,'Retail Sale Id 5300',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 17:42:03','',''),(5267,'21','227','1',1,'Retail Sale Id 5300',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 17:42:03','',''),(5268,'21','227','1',1,'Retail Sale Id 5300',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 17:42:03','',''),(5269,'21','227','1',1,'Retail Sale Id 5301',699.20,0.00,0.00,0.92,0.00,'2022-08-01 17:43:42','',''),(5270,'21','227','1',1,'Retail Sale Id 5301',1998.80,0.00,0.00,2.63,0.00,'2022-08-01 17:43:42','',''),(5271,'21','227','1',1,'Retail Sale Id 5301',2295.20,0.00,0.00,3.02,0.00,'2022-08-01 17:43:42','',''),(5272,'21','227','1',1,'Retail Sale Id 5301',2492.80,0.00,0.00,3.28,0.00,'2022-08-01 17:43:42','',''),(5273,'21','227','1',1,'Retail Sale Id 5301',2492.80,0.00,0.00,3.28,0.00,'2022-08-01 17:43:42','',''),(5274,'21','227','1',1,'Retail Sale Id 5301',3997.60,0.00,0.00,5.26,0.00,'2022-08-01 17:43:42','',''),(5275,'21','227','1',1,'Retail Sale Id 5302',995.60,0.00,0.00,1.31,0.00,'2022-08-01 17:44:21','',''),(5276,'21','227','1',1,'Retail Sale Id 5302',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 17:44:21','',''),(5277,'21','227','1',1,'Retail Sale Id 5303',995.60,0.00,0.00,1.31,0.00,'2022-08-01 17:45:00','',''),(5278,'21','227','1',1,'Retail Sale Id 5304',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 17:46:23','',''),(5279,'21','227','1',1,'Retail Sale Id 5305',1497.20,0.00,0.00,1.97,0.00,'2022-08-01 17:47:04','',''),(5280,'21','227','1',1,'Retail Sale Id 5306',995.60,0.00,0.00,1.31,0.00,'2022-08-01 17:47:44','',''),(5281,'21','227','1',1,'Retail Sale Id 5307',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 17:48:20','',''),(5282,'21','227','1',1,'Retail Sale Id 5308',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 17:49:20','',''),(5283,'21','227','1',1,'Retail Sale Id 5309',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 17:57:51','',''),(5284,'21','227','1',1,'Retail Sale Id 5310',22800.00,0.00,0.00,30.00,0.00,'2022-08-01 17:58:53','',''),(5285,'21','227','1',1,'Retail Sale Id 5310',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 17:58:53','',''),(5286,'21','227','1',1,'Retail Sale Id 5310',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 17:58:53','',''),(5287,'21','227','1',1,'Retail Sale Id 5311',12236.00,0.00,0.00,16.10,0.00,'2022-08-01 17:59:52','',''),(5288,'21','227','1',1,'Retail Sale Id 5312',3800.00,0.00,0.00,5.00,0.00,'2022-08-02 09:48:03','',''),(5289,'21','227','1',1,'Retail Sale Id 5313',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 09:51:14','',''),(5290,'21','227','1',1,'Retail Sale Id 5314',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 10:19:04','',''),(5291,'21','227','1',1,'Retail Sale Id 5315',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 10:20:52','',''),(5292,'21','227','1',1,'Retail Sale Id 5316',3800.00,0.00,0.00,5.00,0.00,'2022-08-02 10:22:04','',''),(5293,'21','227','1',1,'Retail Sale Id 5317',11400.00,0.00,0.00,15.00,0.00,'2022-08-02 10:28:19','',''),(5294,'21','227','1',1,'Retail Sale Id 5318',22800.00,0.00,0.00,30.00,0.00,'2022-08-02 10:33:32','',''),(5295,'21','227','1',1,'Retail Sale Id 5319',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 10:34:17','',''),(5296,'21','227','1',1,'Retail Sale Id 5320',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 10:35:15','',''),(5297,'21','227','1',1,'Retail Sale Id 5321',11400.00,0.00,0.00,15.00,0.00,'2022-08-02 10:37:34','',''),(5298,'21','227','1',1,'Retail Sale Id 5322',7600.00,0.00,0.00,10.00,0.00,'2022-08-02 10:38:54','',''),(5299,'21','227','1',1,'Retail Sale Id 5323',1998.80,0.00,0.00,2.63,0.00,'2022-08-02 10:39:58','',''),(5300,'21','227','1',1,'Retail Sale Id 5324',5320.00,0.00,0.00,7.00,0.00,'2022-08-02 10:41:00','',''),(5301,'21','227','1',1,'Retail Sale Id 5325',3800.00,0.00,0.00,5.00,0.00,'2022-08-02 10:41:40','',''),(5302,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-08-05 15:37:17','',''),(5303,'21','227',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,3000.00,0.00,'2022-08-05 15:38:33','',''),(5304,'21','227','1',1,'Received from bridging 14',0.00,0.00,3000.00,0.00,0.00,'2022-08-05 15:38:33','',''),(5305,'21','227','1',1,'Retail Sale Id 5326',3040.00,0.00,0.00,4.00,0.00,'2022-08-05 15:41:54','',''),(5306,'21','227','1',1,'Retail Sale Id 5327',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 15:42:43','',''),(5307,'21','227','1',1,'Retail Sale Id 5328',995.60,0.00,0.00,1.31,0.00,'2022-08-05 15:44:03','',''),(5308,'21','227','1',1,'Retail Sale Id 5330',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 15:45:01','',''),(5309,'21','227','1',1,'Retail Sale Id 5331',1998.80,0.00,0.00,2.63,0.00,'2022-08-05 15:46:09','',''),(5310,'21','227','1',1,'Retail Sale Id 5332',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 15:47:15','',''),(5311,'21','227','1',1,'Retail Sale Id 5333',995.60,0.00,0.00,1.31,0.00,'2022-08-05 15:47:57','',''),(5312,'21','227','1',1,'Retail Sale Id 5334',1520.00,0.00,0.00,2.00,0.00,'2022-08-05 16:29:40','',''),(5313,'21','227','1',1,'Retail Sale Id 5335',896.80,0.00,0.00,1.18,0.00,'2022-08-05 16:33:26','',''),(5314,'21','227','1',1,'Retail Sale Id 5336',798.00,0.00,0.00,1.05,0.00,'2022-08-05 16:34:09','',''),(5315,'21','227','1',1,'Retail Sale Id 5337',1520.00,0.00,0.00,2.00,0.00,'2022-08-05 16:34:46','',''),(5316,'21','227','1',1,'Retail Sale Id 5338',995.60,0.00,0.00,1.31,0.00,'2022-08-05 16:37:58','',''),(5317,'21','227','1',1,'Retail Sale Id 5339',995.60,0.00,0.00,1.31,0.00,'2022-08-05 16:38:38','',''),(5318,'21','227','1',1,'Retail Sale Id 5340',1497.20,0.00,0.00,1.97,0.00,'2022-08-05 16:39:19','',''),(5319,'21','227','1',1,'Retail Sale Id 5342',995.60,0.00,0.00,1.31,0.00,'2022-08-05 16:40:01','',''),(5320,'21','227','1',1,'Retail Sale Id 5343',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 16:41:33','',''),(5321,'21','227','1',1,'Retail Sale Id 5344',995.60,0.00,0.00,1.31,0.00,'2022-08-05 16:42:51','',''),(5322,'21','227','1',1,'Retail Sale Id 5345',2492.80,0.00,0.00,3.28,0.00,'2022-08-05 16:46:09','',''),(5323,'21','227','1',1,'Retail Sale Id 5346',2492.80,0.00,0.00,3.28,0.00,'2022-08-05 16:48:30','',''),(5324,'21','227','1',1,'Retail Sale Id 5347',1299.60,0.00,0.00,1.71,0.00,'2022-08-05 16:50:06','',''),(5325,'21','227','1',1,'Retail Sale Id 5347',1497.20,0.00,0.00,1.97,0.00,'2022-08-05 16:50:06','',''),(5326,'21','227','1',1,'Retail Sale Id 5348',995.60,0.00,0.00,1.31,0.00,'2022-08-05 16:50:46','',''),(5327,'21','227','1',1,'Retail Sale Id 5348',3800.00,0.00,0.00,5.00,0.00,'2022-08-05 16:50:46','',''),(5328,'21','227','1',1,'Retail Sale Id 5349',2196.40,0.00,0.00,2.89,0.00,'2022-08-05 16:51:38','',''),(5329,'21','227','1',1,'Retail Sale Id 5349',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 16:51:38','',''),(5330,'21','227','1',1,'Retail Sale Id 5349',3800.00,0.00,0.00,5.00,0.00,'2022-08-05 16:51:38','',''),(5331,'21','227','1',1,'Retail Sale Id 5350',3800.00,0.00,0.00,5.00,0.00,'2022-08-05 16:52:17','',''),(5332,'21','227','1',1,'Retail Sale Id 5350',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 16:52:17','',''),(5333,'21','227','1',1,'Retail Sale Id 5351',896.80,0.00,0.00,1.18,0.00,'2022-08-05 16:53:11','',''),(5334,'21','227','1',1,'Retail Sale Id 5351',995.60,0.00,0.00,1.31,0.00,'2022-08-05 16:53:11','',''),(5335,'21','227','1',1,'Retail Sale Id 5351',3800.00,0.00,0.00,5.00,0.00,'2022-08-05 16:53:11','',''),(5336,'21','227','1',1,'Retail Sale Id 5352',1998.80,0.00,0.00,2.63,0.00,'2022-08-05 16:53:51','',''),(5337,'21','227','1',1,'Retail Sale Id 5353',1497.20,0.00,0.00,1.97,0.00,'2022-08-05 16:58:48','',''),(5338,'21','227','1',1,'Retail Sale Id 5354',1998.80,0.00,0.00,2.63,0.00,'2022-08-05 16:59:55','',''),(5339,'21','227','1',1,'Retail Sale Id 5355',2295.20,0.00,0.00,3.02,0.00,'2022-08-05 17:01:15','',''),(5340,'21','227','1',1,'Retail Sale Id 5356',2492.80,0.00,0.00,3.28,0.00,'2022-08-05 17:03:03','',''),(5341,'21','227','1',1,'Retail Sale Id 5357',4993.20,0.00,0.00,6.57,0.00,'2022-08-05 17:03:51','',''),(5342,'21','227','1',1,'Retail Sale Id 5358',798.00,0.00,0.00,1.05,0.00,'2022-08-05 17:06:06','',''),(5343,'21','227','1',1,'Retail Sale Id 5359',995.60,0.00,0.00,1.31,0.00,'2022-08-05 17:10:34','',''),(5344,'21','227','1',1,'Retail Sale Id 5360',3040.00,0.00,0.00,4.00,0.00,'2022-08-05 17:11:53','',''),(5345,'21','227','1',1,'Retail Sale Id 5361',896.80,0.00,0.00,1.18,0.00,'2022-08-05 17:13:06','',''),(5346,'21','227','1',1,'Retail Sale Id 5362',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 17:13:49','',''),(5347,'21','227','1',1,'Retail Sale Id 5363',494.00,0.00,0.00,0.65,0.00,'2022-08-05 17:16:32','',''),(5348,'21','227','1',1,'Retail Sale Id 5364',3496.00,0.00,0.00,4.60,0.00,'2022-08-05 17:17:46','',''),(5349,'21','227','1',1,'Retail Sale Id 5365',995.60,0.00,0.00,1.31,0.00,'2022-08-05 17:19:32','',''),(5350,'21','227','1',1,'Retail Sale Id 5366',1497.20,0.00,0.00,1.97,0.00,'2022-08-05 17:24:37','',''),(5351,'21','227','1',1,'Retail Sale Id 5367',2994.40,0.00,0.00,3.94,0.00,'2022-08-05 17:25:25','',''),(5352,'21','227','1',1,'Retail Sale Id 5368',2500.40,0.00,0.00,3.29,0.00,'2022-08-05 17:26:36','',''),(5353,'21','227','1',1,'Retail Sale Id 5369',995.60,0.00,0.00,1.31,0.00,'2022-08-05 17:27:35','',''),(5354,'21','227','1',1,'Retail Sale Id 5369',995.60,0.00,0.00,1.31,0.00,'2022-08-05 17:27:35','',''),(5355,'21','227','1',1,'Retail Sale Id 5370',1520.00,0.00,0.00,2.00,0.00,'2022-08-05 17:28:08','',''),(5356,'21','227','1',1,'Retail Sale Id 5371',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 17:28:51','',''),(5357,'21','227','1',1,'Retail Sale Id 5372',2994.40,0.00,0.00,3.94,0.00,'2022-08-05 17:29:35','',''),(5358,'21','227','1',1,'Retail Sale Id 5373',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 17:30:12','',''),(5359,'21','227','1',1,'Retail Sale Id 5374',4560.00,0.00,0.00,6.00,0.00,'2022-08-05 17:30:56','',''),(5360,'21','227','1',1,'Retail Sale Id 5375',995.60,0.00,0.00,1.31,0.00,'2022-08-05 17:31:31','',''),(5361,'21','227','1',1,'Retail Sale Id 5376',1497.20,0.00,0.00,1.97,0.00,'2022-08-05 17:32:07','',''),(5362,'21','227','1',1,'Retail Sale Id 5377',1998.80,0.00,0.00,2.63,0.00,'2022-08-05 17:36:12','',''),(5363,'21','227','1',1,'Retail Sale Id 5378',798.00,0.00,0.00,1.05,0.00,'2022-08-05 17:37:18','',''),(5364,'21','227','1',1,'Retail Sale Id 5379',1497.20,0.00,0.00,1.97,0.00,'2022-08-05 17:38:29','',''),(5365,'21','227','1',1,'Retail Sale Id 5380',1998.80,0.00,0.00,2.63,0.00,'2022-08-05 17:39:15','',''),(5366,'21','227','1',1,'Retail Sale Id 5381',1998.80,0.00,0.00,2.63,0.00,'2022-08-05 17:46:43','',''),(5367,'21','227','1',1,'Retail Sale Id 5382',798.00,0.00,0.00,1.05,0.00,'2022-08-05 17:47:31','',''),(5368,'21','227','1',1,'Retail Sale Id 5383',8998.40,0.00,0.00,11.84,0.00,'2022-08-05 17:49:09','',''),(5369,'21','227','1',1,'Retail Sale Id 5384',1520.00,0.00,0.00,2.00,0.00,'2022-08-05 17:52:02','',''),(5370,'21','227','1',1,'Retail Sale Id 5385',798.00,0.00,0.00,1.05,0.00,'2022-08-05 17:55:38','',''),(5371,'21','227','1',1,'Retail Sale Id 5386',4993.20,0.00,0.00,6.57,0.00,'2022-08-05 17:57:09','',''),(5372,'21','227','1',1,'Retail Sale Id 5387',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 18:05:30','',''),(5373,'21','227','1',1,'Retail Sale Id 5388',995.60,0.00,0.00,1.31,0.00,'2022-08-05 18:06:31','',''),(5374,'21','227','1',1,'Retail Sale Id 5389',1998.80,0.00,0.00,2.63,0.00,'2022-08-05 18:14:04','',''),(5375,'21','227','1',1,'Retail Sale Id 5390',798.00,0.00,0.00,1.05,0.00,'2022-08-05 18:14:57','',''),(5376,'21','227','1',1,'Retail Sale Id 5391',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 18:15:45','',''),(5377,'21','227','1',1,'Retail Sale Id 5392',1998.80,0.00,0.00,2.63,0.00,'2022-08-05 18:17:04','',''),(5378,'21','227','1',1,'Retail Sale Id 5393',995.60,0.00,0.00,1.31,0.00,'2022-08-05 18:19:26','',''),(5379,'21','227','1',1,'Retail Sale Id 5394',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 10:26:38','',''),(5380,'21','227','1',1,'Retail Sale Id 5395',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 10:28:12','',''),(5381,'21','227','1',1,'Retail Sale Id 5396',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 10:48:46','',''),(5382,'21','227','1',1,'Retail Sale Id 5397',995.60,0.00,0.00,1.31,0.00,'2022-08-06 10:49:41','',''),(5383,'21','227','1',1,'Retail Sale Id 5398',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 10:52:25','',''),(5384,'21','227','1',1,'Retail Sale Id 5399',1520.00,0.00,0.00,2.00,0.00,'2022-08-06 10:53:46','',''),(5385,'21','227','1',1,'Retail Sale Id 5400',494.00,0.00,0.00,0.65,0.00,'2022-08-06 10:54:38','',''),(5386,'21','227','1',1,'Retail Sale Id 5401',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 10:55:30','',''),(5387,'21','227','1',1,'Retail Sale Id 5402',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 10:56:20','',''),(5388,'21','227','1',1,'Retail Sale Id 5403',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 10:57:10','',''),(5389,'21','227','1',1,'Retail Sale Id 5404',2196.40,0.00,0.00,2.89,0.00,'2022-08-06 10:58:11','',''),(5390,'21','227','1',1,'Retail Sale Id 5405',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 10:59:39','',''),(5391,'21','227','1',1,'Retail Sale Id 5406',2492.80,0.00,0.00,3.28,0.00,'2022-08-06 11:00:32','',''),(5392,'21','227','1',1,'Retail Sale Id 5407',2492.80,0.00,0.00,3.28,0.00,'2022-08-06 11:03:27','',''),(5393,'21','227','1',1,'Retail Sale Id 5408',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 11:04:11','',''),(5394,'21','227','1',1,'Retail Sale Id 5409',1900.00,0.00,0.00,2.50,0.00,'2022-08-06 11:04:59','',''),(5395,'21','227','1',1,'Retail Sale Id 5410',3040.00,0.00,0.00,4.00,0.00,'2022-08-06 11:10:45','',''),(5396,'21','227','1',1,'Retail Sale Id 5411',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 11:20:24','',''),(5397,'21','227','1',1,'Retail Sale Id 5412',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 11:21:48','',''),(5398,'21','227','1',1,'Retail Sale Id 5413',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 11:22:45','',''),(5399,'21','227','1',1,'Retail Sale Id 5414',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 11:23:31','',''),(5400,'21','227','1',1,'Retail Sale Id 5415',4499.20,0.00,0.00,5.92,0.00,'2022-08-06 11:24:30','',''),(5401,'21','227','1',1,'Retail Sale Id 5416',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 11:25:37','',''),(5402,'21','227','1',1,'Retail Sale Id 5417',798.00,0.00,0.00,1.05,0.00,'2022-08-06 11:26:35','',''),(5403,'21','227','1',1,'Retail Sale Id 5418',760.00,0.00,0.00,1.00,0.00,'2022-08-06 11:27:26','',''),(5404,'21','227','1',1,'Retail Sale Id 5420',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 11:29:54','',''),(5405,'21','227','1',1,'Retail Sale Id 5421',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 11:30:44','',''),(5406,'21','227','1',1,'Retail Sale Id 5422',995.60,0.00,0.00,1.31,0.00,'2022-08-06 11:31:40','',''),(5407,'21','227','1',1,'Retail Sale Id 5423',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 11:32:54','',''),(5408,'21','227','1',1,'Retail Sale Id 5424',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 11:33:43','',''),(5409,'21','227','1',1,'Retail Sale Id 5425',6498.00,0.00,0.00,8.55,0.00,'2022-08-06 11:34:34','',''),(5410,'21','227','1',1,'Retail Sale Id 5426',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 11:35:45','',''),(5411,'21','227','1',1,'Retail Sale Id 5427',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 11:37:15','',''),(5412,'21','227','1',1,'Retail Sale Id 5428',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 11:38:17','',''),(5413,'21','227','1',1,'Retail Sale Id 5429',4499.20,0.00,0.00,5.92,0.00,'2022-08-06 11:39:27','',''),(5414,'21','227','1',1,'Retail Sale Id 5430',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 11:40:25','',''),(5415,'21','227','1',1,'Retail Sale Id 5431',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 11:41:12','',''),(5416,'21','227','1',1,'Retail Sale Id 5432',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 11:42:08','',''),(5417,'21','227','1',1,'Retail Sale Id 5433',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 11:42:59','',''),(5418,'21','227','1',1,'Retail Sale Id 5434',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 11:43:50','',''),(5419,'21','227','1',1,'Retail Sale Id 5435',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 11:44:30','',''),(5420,'21','227','1',1,'Retail Sale Id 5436',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 11:46:36','',''),(5421,'21','227','1',1,'Retail Sale Id 5437',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 11:48:19','',''),(5422,'21','227','1',1,'Retail Sale Id 5438',3997.60,0.00,0.00,5.26,0.00,'2022-08-06 11:50:06','',''),(5423,'21','227','1',1,'Retail Sale Id 5439',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 11:50:43','',''),(5424,'21','227','1',1,'Retail Sale Id 5440',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 11:54:44','',''),(5425,'21','227','1',1,'Retail Sale Id 5441',798.00,0.00,0.00,1.05,0.00,'2022-08-06 11:55:28','',''),(5426,'21','227','1',1,'Retail Sale Id 5442',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 11:56:11','',''),(5427,'21','227','1',1,'Retail Sale Id 5443',995.60,0.00,0.00,1.31,0.00,'2022-08-06 11:58:01','',''),(5428,'21','227','1',1,'Retail Sale Id 5444',3496.00,0.00,0.00,4.60,0.00,'2022-08-06 11:58:38','',''),(5429,'21','227','1',1,'Retail Sale Id 5445',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 12:00:11','',''),(5430,'21','227','1',1,'Retail Sale Id 5446',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 12:13:56','',''),(5431,'21','227','1',1,'Retail Sale Id 5447',798.00,0.00,0.00,1.05,0.00,'2022-08-06 12:16:16','',''),(5432,'21','227','1',1,'Retail Sale Id 5448',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 12:18:37','',''),(5433,'21','227','1',1,'Retail Sale Id 5449',1520.00,0.00,0.00,2.00,0.00,'2022-08-06 12:20:43','',''),(5434,'21','227','1',1,'Retail Sale Id 5450',1003.20,0.00,0.00,1.32,0.00,'2022-08-06 12:21:27','',''),(5435,'21','227','1',1,'Retail Sale Id 5451',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 12:27:01','',''),(5436,'21','227','1',1,'Retail Sale Id 5452',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 12:27:46','',''),(5437,'21','227','1',1,'Retail Sale Id 5454',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 12:28:35','',''),(5438,'21','227','1',1,'Retail Sale Id 5455',2295.20,0.00,0.00,3.02,0.00,'2022-08-06 12:29:23','',''),(5439,'21','227','1',1,'Retail Sale Id 5456',2492.80,0.00,0.00,3.28,0.00,'2022-08-06 12:30:20','',''),(5440,'21','227','1',1,'Retail Sale Id 5457',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 12:30:59','',''),(5441,'21','227','1',1,'Retail Sale Id 5458',4993.20,0.00,0.00,6.57,0.00,'2022-08-06 12:31:54','',''),(5442,'21','227','1',1,'Retail Sale Id 5459',3997.60,0.00,0.00,5.26,0.00,'2022-08-06 12:32:52','',''),(5443,'21','227','1',1,'Retail Sale Id 5460',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 12:33:43','',''),(5444,'21','227','1',1,'Retail Sale Id 5461',1398.40,0.00,0.00,1.84,0.00,'2022-08-06 12:35:13','',''),(5445,'21','227','1',1,'Retail Sale Id 5462',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 12:36:07','',''),(5446,'21','227','1',1,'Retail Sale Id 5463',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 12:36:43','',''),(5447,'21','227','1',1,'Retail Sale Id 5464',1398.40,0.00,0.00,1.84,0.00,'2022-08-06 12:37:35','',''),(5448,'21','227','1',1,'Retail Sale Id 5465',760.00,0.00,0.00,1.00,0.00,'2022-08-06 12:38:25','',''),(5449,'21','227','1',1,'Retail Sale Id 5466',4993.20,0.00,0.00,6.57,0.00,'2022-08-06 12:40:56','',''),(5450,'21','227','1',1,'Retail Sale Id 5467',3040.00,0.00,0.00,4.00,0.00,'2022-08-06 12:41:55','',''),(5451,'21','227','1',1,'Retail Sale Id 5468',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 12:44:12','',''),(5452,'21','227','1',1,'Retail Sale Id 5469',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 12:46:51','',''),(5453,'21','227','1',1,'Retail Sale Id 5469',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 12:46:51','',''),(5454,'21','227','1',1,'Retail Sale Id 5470',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 12:47:39','',''),(5455,'21','227','1',1,'Retail Sale Id 5471',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 12:50:02','',''),(5456,'21','227','1',1,'Retail Sale Id 5472',3199.60,0.00,0.00,4.21,0.00,'2022-08-06 12:50:53','',''),(5457,'21','227','1',1,'Retail Sale Id 5473',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 12:52:36','',''),(5458,'21','227','1',1,'Retail Sale Id 5474',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 12:58:03','',''),(5459,'21','227','1',1,'Retail Sale Id 5475',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 13:01:17','',''),(5460,'21','227','1',1,'Retail Sale Id 5475',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 13:01:17','',''),(5461,'21','227','1',1,'Retail Sale Id 5476',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 13:02:01','',''),(5462,'21','227','1',1,'Retail Sale Id 5477',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 13:04:50','',''),(5463,'21','227','1',1,'Retail Sale Id 5478',995.60,0.00,0.00,1.31,0.00,'2022-08-06 13:09:47','',''),(5464,'21','227','1',1,'Retail Sale Id 5479',1520.00,0.00,0.00,2.00,0.00,'2022-08-06 13:10:22','',''),(5465,'21','227','1',1,'Retail Sale Id 5480',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 13:12:43','',''),(5466,'21','227','1',1,'Retail Sale Id 5481',3997.60,0.00,0.00,5.26,0.00,'2022-08-06 13:24:57','',''),(5467,'21','227','1',1,'Retail Sale Id 5482',699.20,0.00,0.00,0.92,0.00,'2022-08-06 13:29:59','',''),(5468,'21','227','1',1,'Retail Sale Id 5483',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 13:38:11','',''),(5469,'21','227','1',1,'Retail Sale Id 5484',1193.20,0.00,0.00,1.57,0.00,'2022-08-06 13:42:53','',''),(5470,'21','227','1',1,'Retail Sale Id 5485',494.00,0.00,0.00,0.65,0.00,'2022-08-06 13:44:15','',''),(5471,'21','227','1',1,'Retail Sale Id 5486',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 13:45:29','',''),(5472,'21','227','1',1,'Retail Sale Id 5487',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 13:50:08','',''),(5473,'21','227','1',1,'Retail Sale Id 5488',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 13:50:49','',''),(5474,'21','227','1',1,'Retail Sale Id 5489',3997.60,0.00,0.00,5.26,0.00,'2022-08-06 13:52:48','',''),(5475,'21','227','1',1,'Retail Sale Id 5490',3496.00,0.00,0.00,4.60,0.00,'2022-08-06 13:53:39','',''),(5476,'21','227','1',1,'Retail Sale Id 5491',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 13:55:10','',''),(5477,'21','227','1',1,'Retail Sale Id 5492',995.60,0.00,0.00,1.31,0.00,'2022-08-06 13:57:20','',''),(5478,'21','227','1',1,'Retail Sale Id 5493',3002.00,0.00,0.00,3.95,0.00,'2022-08-06 14:01:54','',''),(5479,'21','227','1',1,'Retail Sale Id 5494',5000.80,0.00,0.00,6.58,0.00,'2022-08-06 14:03:30','',''),(5480,'21','227','1',1,'Retail Sale Id 5495',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 14:05:26','',''),(5481,'21','227','1',1,'Retail Sale Id 5496',995.60,0.00,0.00,1.31,0.00,'2022-08-06 14:24:35','',''),(5482,'21','227','1',1,'Retail Sale Id 5497',1299.60,0.00,0.00,1.71,0.00,'2022-08-06 14:25:22','',''),(5483,'21','227','1',1,'Retail Sale Id 5498',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 14:25:56','',''),(5484,'21','227','1',1,'Retail Sale Id 5499',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 14:26:42','',''),(5485,'21','227','1',1,'Retail Sale Id 5500',760.00,0.00,0.00,1.00,0.00,'2022-08-06 14:27:48','',''),(5486,'21','227','1',1,'Retail Sale Id 5501',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 14:34:18','',''),(5487,'21','227','1',1,'Retail Sale Id 5502',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 14:37:16','',''),(5488,'21','227','1',1,'Retail Sale Id 5502',2295.20,0.00,0.00,3.02,0.00,'2022-08-06 14:37:16','',''),(5489,'21','227','1',1,'Retail Sale Id 5503',995.60,0.00,0.00,1.31,0.00,'2022-08-06 14:43:59','',''),(5490,'21','227','1',1,'Retail Sale Id 5505',494.00,0.00,0.00,0.65,0.00,'2022-08-06 14:50:33','',''),(5491,'21','227','1',1,'Retail Sale Id 5505',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 14:50:33','',''),(5492,'21','227','1',1,'Retail Sale Id 5506',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 14:51:12','',''),(5493,'21','227','1',1,'Retail Sale Id 5507',2006.40,0.00,0.00,2.64,0.00,'2022-08-06 15:06:13','',''),(5494,'21','227','1',1,'Retail Sale Id 5508',1299.60,0.00,0.00,1.71,0.00,'2022-08-06 15:09:42','',''),(5495,'21','227','1',1,'Retail Sale Id 5509',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 15:14:18','',''),(5496,'21','227','1',1,'Retail Sale Id 5510',1793.60,0.00,0.00,2.36,0.00,'2022-08-06 15:16:17','',''),(5497,'21','227','1',1,'Retail Sale Id 5511',3496.00,0.00,0.00,4.60,0.00,'2022-08-06 15:20:45','',''),(5498,'21','227','1',1,'Retail Sale Id 5512',798.00,0.00,0.00,1.05,0.00,'2022-08-06 15:22:46','',''),(5499,'21','227','1',1,'Retail Sale Id 5513',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 15:23:22','',''),(5500,'21','227','1',1,'Retail Sale Id 5514',798.00,0.00,0.00,1.05,0.00,'2022-08-06 15:24:00','',''),(5501,'21','227','1',1,'Retail Sale Id 5515',3040.00,0.00,0.00,4.00,0.00,'2022-08-06 15:26:00','',''),(5502,'21','227','1',1,'Retail Sale Id 5516',4499.20,0.00,0.00,5.92,0.00,'2022-08-06 15:30:18','',''),(5503,'21','227','1',1,'Retail Sale Id 5517',2500.40,0.00,0.00,3.29,0.00,'2022-08-06 15:31:22','',''),(5504,'21','227','1',1,'Retail Sale Id 5518',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 15:32:33','',''),(5505,'21','227','1',1,'Retail Sale Id 5519',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 15:37:39','',''),(5506,'21','227','1',1,'Retail Sale Id 5520',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 15:38:30','',''),(5507,'21','227','1',1,'Retail Sale Id 5521',1504.80,0.00,0.00,1.98,0.00,'2022-08-06 15:39:05','',''),(5508,'21','227','1',1,'Retail Sale Id 5522',699.20,0.00,0.00,0.92,0.00,'2022-08-06 15:40:02','',''),(5509,'21','227','1',1,'Retail Sale Id 5522',1793.60,0.00,0.00,2.36,0.00,'2022-08-06 15:40:02','',''),(5510,'21','227','1',1,'Retail Sale Id 5523',1520.00,0.00,0.00,2.00,0.00,'2022-08-06 15:42:59','',''),(5511,'21','227','1',1,'Retail Sale Id 5524',2492.80,0.00,0.00,3.28,0.00,'2022-08-06 15:43:43','',''),(5512,'21','227','1',1,'Retail Sale Id 5525',2492.80,0.00,0.00,3.28,0.00,'2022-08-06 15:44:33','',''),(5513,'21','227','1',1,'Retail Sale Id 5526',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 15:45:32','',''),(5514,'21','227','1',1,'Retail Sale Id 5527',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 15:49:51','',''),(5515,'21','227','1',1,'Retail Sale Id 5528',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 15:51:56','',''),(5516,'21','227','1',1,'Retail Sale Id 5529',1398.40,0.00,0.00,1.84,0.00,'2022-08-06 15:54:41','',''),(5517,'21','227','1',1,'Retail Sale Id 5530',1193.20,0.00,0.00,1.57,0.00,'2022-08-06 15:57:08','',''),(5518,'21','227','1',1,'Retail Sale Id 5531',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 15:58:00','',''),(5519,'21','227','1',1,'Retail Sale Id 5532',2492.80,0.00,0.00,3.28,0.00,'2022-08-06 16:03:26','',''),(5520,'21','227','1',1,'Retail Sale Id 5533',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 16:07:19','',''),(5521,'21','227','1',1,'Retail Sale Id 5534',2295.20,0.00,0.00,3.02,0.00,'2022-08-06 16:08:29','',''),(5522,'21','227','1',1,'Retail Sale Id 5535',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 16:13:23','',''),(5523,'21','227','1',1,'Retail Sale Id 5536',798.00,0.00,0.00,1.05,0.00,'2022-08-06 16:14:02','',''),(5524,'21','227','1',1,'Retail Sale Id 5537',995.60,0.00,0.00,1.31,0.00,'2022-08-06 16:20:36','',''),(5525,'21','227','1',1,'Retail Sale Id 5538',995.60,0.00,0.00,1.31,0.00,'2022-08-06 16:22:42','',''),(5526,'21','227','1',1,'Retail Sale Id 5539',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 16:23:24','',''),(5527,'21','227','1',1,'Retail Sale Id 5540',995.60,0.00,0.00,1.31,0.00,'2022-08-06 16:26:16','',''),(5528,'21','227','1',1,'Retail Sale Id 5541',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 16:31:24','',''),(5529,'21','227','1',1,'Retail Sale Id 5542',4993.20,0.00,0.00,6.57,0.00,'2022-08-06 16:32:11','',''),(5530,'21','227','1',1,'Retail Sale Id 5543',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 16:32:52','',''),(5531,'21','227','1',1,'Retail Sale Id 5544',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 16:37:31','',''),(5532,'21','227','1',1,'Retail Sale Id 5545',995.60,0.00,0.00,1.31,0.00,'2022-08-06 16:41:19','',''),(5533,'21','227','1',1,'Retail Sale Id 5546',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 16:42:10','',''),(5534,'21','227','1',1,'Retail Sale Id 5547',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 16:42:59','',''),(5535,'21','227','1',1,'Retail Sale Id 5548',798.00,0.00,0.00,1.05,0.00,'2022-08-06 16:46:35','',''),(5536,'21','227','1',1,'Retail Sale Id 5549',1520.00,0.00,0.00,2.00,0.00,'2022-08-06 16:50:09','',''),(5537,'21','227','1',1,'Retail Sale Id 5550',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 16:56:33','',''),(5538,'21','227','1',1,'Retail Sale Id 5551',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 16:57:24','',''),(5539,'21','227','1',1,'Retail Sale Id 5552',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 16:58:43','',''),(5540,'21','227','1',1,'Retail Sale Id 5553',699.20,0.00,0.00,0.92,0.00,'2022-08-06 17:00:59','',''),(5541,'21','227','1',1,'Retail Sale Id 5554',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 17:02:33','',''),(5542,'21','227','1',1,'Retail Sale Id 5555',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 17:03:14','',''),(5543,'21','227','1',1,'Retail Sale Id 5557',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 17:04:03','',''),(5544,'21','227','1',1,'Retail Sale Id 5558',995.60,0.00,0.00,1.31,0.00,'2022-08-06 17:05:48','',''),(5545,'21','227','1',1,'Retail Sale Id 5559',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 17:10:04','',''),(5546,'21','227','1',1,'Retail Sale Id 5560',995.60,0.00,0.00,1.31,0.00,'2022-08-06 17:13:44','',''),(5547,'21','227','1',1,'Retail Sale Id 5561',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 17:15:22','',''),(5548,'21','227','1',1,'Retail Sale Id 5562',995.60,0.00,0.00,1.31,0.00,'2022-08-06 17:20:44','',''),(5549,'21','227','1',1,'Retail Sale Id 5562',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 17:20:44','',''),(5550,'21','227','1',1,'Retail Sale Id 5563',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 17:21:32','',''),(5551,'21','227','1',1,'Retail Sale Id 5564',995.60,0.00,0.00,1.31,0.00,'2022-08-06 17:23:07','',''),(5552,'21','227','1',1,'Retail Sale Id 5565',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 17:24:00','',''),(5553,'21','227','1',1,'Retail Sale Id 5566',798.00,0.00,0.00,1.05,0.00,'2022-08-06 17:25:02','',''),(5554,'21','227','1',1,'Retail Sale Id 5567',995.60,0.00,0.00,1.31,0.00,'2022-08-06 17:27:25','',''),(5555,'21','227','1',1,'Retail Sale Id 5568',4499.20,0.00,0.00,5.92,0.00,'2022-08-06 17:28:51','',''),(5556,'21','227','1',1,'Retail Sale Id 5569',995.60,0.00,0.00,1.31,0.00,'2022-08-06 17:31:12','',''),(5557,'21','227','1',1,'Retail Sale Id 5570',1998.80,0.00,0.00,2.63,0.00,'2022-08-06 17:32:08','',''),(5558,'21','227','1',1,'Retail Sale Id 5571',3997.60,0.00,0.00,5.26,0.00,'2022-08-06 17:32:44','',''),(5559,'21','227','1',1,'Retail Sale Id 5572',1504.80,0.00,0.00,1.98,0.00,'2022-08-06 17:38:11','',''),(5560,'21','227','1',1,'Retail Sale Id 5573',995.60,0.00,0.00,1.31,0.00,'2022-08-06 17:49:52','',''),(5561,'21','227','1',1,'Retail Sale Id 5574',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 17:50:51','',''),(5562,'21','227','1',1,'Retail Sale Id 5575',8360.00,0.00,0.00,11.00,0.00,'2022-08-06 17:53:34','',''),(5563,'21','227','1',1,'Retail Sale Id 5576',3997.60,0.00,0.00,5.26,0.00,'2022-08-06 17:56:20','',''),(5564,'21','227','1',1,'Retail Sale Id 5576',3997.60,0.00,0.00,5.26,0.00,'2022-08-06 17:56:20','',''),(5565,'21','227','1',1,'Retail Sale Id 5577',494.00,0.00,0.00,0.65,0.00,'2022-08-06 17:56:56','',''),(5566,'21','227','1',1,'Retail Sale Id 5578',995.60,0.00,0.00,1.31,0.00,'2022-08-06 17:57:32','',''),(5567,'21','227','1',1,'Retail Sale Id 5579',600.40,0.00,0.00,0.79,0.00,'2022-08-06 17:59:40','',''),(5568,'21','227','1',1,'Retail Sale Id 5580',1801.20,0.00,0.00,2.37,0.00,'2022-08-06 18:00:32','',''),(5569,'21','227','1',1,'Retail Sale Id 5581',760.00,0.00,0.00,1.00,0.00,'2022-08-06 18:02:17','',''),(5570,'21','227','1',1,'Retail Sale Id 5581',1299.60,0.00,0.00,1.71,0.00,'2022-08-06 18:02:17','',''),(5571,'21','227','1',1,'Retail Sale Id 5581',2994.40,0.00,0.00,3.94,0.00,'2022-08-06 18:02:17','',''),(5572,'21','227','1',1,'Retail Sale Id 5582',1504.80,0.00,0.00,1.98,0.00,'2022-08-06 18:02:51','',''),(5573,'21','227','1',1,'Retail Sale Id 5583',1520.00,0.00,0.00,2.00,0.00,'2022-08-06 18:03:39','',''),(5574,'21','227','1',1,'Retail Sale Id 5584',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 11:17:59','',''),(5575,'21','227','1',1,'Retail Sale Id 5585',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 11:19:05','',''),(5576,'21','227','1',1,'Retail Sale Id 5586',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:20:28','',''),(5577,'21','227','1',1,'Retail Sale Id 5586',2295.20,0.00,0.00,3.02,0.00,'2022-08-07 11:20:28','',''),(5578,'21','227','1',1,'Retail Sale Id 5586',15200.00,0.00,0.00,20.00,0.00,'2022-08-07 11:20:28','',''),(5579,'21','227','1',1,'Retail Sale Id 5587',798.00,0.00,0.00,1.05,0.00,'2022-08-07 11:21:29','',''),(5580,'21','227','1',1,'Retail Sale Id 5587',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:21:29','',''),(5581,'21','227','1',1,'Retail Sale Id 5587',4947.60,0.00,0.00,6.51,0.00,'2022-08-07 11:21:29','',''),(5582,'21','227','1',1,'Retail Sale Id 5588',995.60,0.00,0.00,1.31,0.00,'2022-08-07 11:22:05','',''),(5583,'21','227','1',1,'Retail Sale Id 5588',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:22:05','',''),(5584,'21','227','1',1,'Retail Sale Id 5589',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 11:22:33','',''),(5585,'21','227','1',1,'Retail Sale Id 5590',2492.80,0.00,0.00,3.28,0.00,'2022-08-07 11:23:07','',''),(5586,'21','227','1',1,'Retail Sale Id 5591',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:23:48','',''),(5587,'21','227','1',1,'Retail Sale Id 5592',798.00,0.00,0.00,1.05,0.00,'2022-08-07 11:25:15','',''),(5588,'21','227','1',1,'Retail Sale Id 5592',2994.40,0.00,0.00,3.94,0.00,'2022-08-07 11:25:15','',''),(5589,'21','227','1',1,'Retail Sale Id 5592',4993.20,0.00,0.00,6.57,0.00,'2022-08-07 11:25:15','',''),(5590,'21','227','1',1,'Retail Sale Id 5592',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:25:15','',''),(5591,'21','227','1',1,'Retail Sale Id 5593',1193.20,0.00,0.00,1.57,0.00,'2022-08-07 11:26:28','',''),(5592,'21','227','1',1,'Retail Sale Id 5593',2492.80,0.00,0.00,3.28,0.00,'2022-08-07 11:26:28','',''),(5593,'21','227','1',1,'Retail Sale Id 5593',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:26:28','',''),(5594,'21','227','1',1,'Retail Sale Id 5594',995.60,0.00,0.00,1.31,0.00,'2022-08-07 11:26:54','',''),(5595,'21','227','1',1,'Retail Sale Id 5595',995.60,0.00,0.00,1.31,0.00,'2022-08-07 11:28:37','',''),(5596,'21','227','1',1,'Retail Sale Id 5595',2994.40,0.00,0.00,3.94,0.00,'2022-08-07 11:28:37','',''),(5597,'21','227','1',1,'Retail Sale Id 5595',2994.40,0.00,0.00,3.94,0.00,'2022-08-07 11:28:37','',''),(5598,'21','227','1',1,'Retail Sale Id 5595',3997.60,0.00,0.00,5.26,0.00,'2022-08-07 11:28:37','',''),(5599,'21','227','1',1,'Retail Sale Id 5595',4499.20,0.00,0.00,5.92,0.00,'2022-08-07 11:28:37','',''),(5600,'21','227','1',1,'Retail Sale Id 5596',3997.60,0.00,0.00,5.26,0.00,'2022-08-07 11:29:34','',''),(5601,'21','227','1',1,'Retail Sale Id 5596',3997.60,0.00,0.00,5.26,0.00,'2022-08-07 11:29:34','',''),(5602,'21','227','1',1,'Retail Sale Id 5596',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:29:34','',''),(5603,'21','227','1',1,'Retail Sale Id 5597',2196.40,0.00,0.00,2.89,0.00,'2022-08-07 11:31:04','',''),(5604,'21','227','1',1,'Retail Sale Id 5597',2295.20,0.00,0.00,3.02,0.00,'2022-08-07 11:31:04','',''),(5605,'21','227','1',1,'Retail Sale Id 5597',2394.00,0.00,0.00,3.15,0.00,'2022-08-07 11:31:04','',''),(5606,'21','227','1',1,'Retail Sale Id 5597',2492.80,0.00,0.00,3.28,0.00,'2022-08-07 11:31:04','',''),(5607,'21','227','1',1,'Retail Sale Id 5597',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 11:31:04','',''),(5608,'21','227','1',1,'Retail Sale Id 5598',995.60,0.00,0.00,1.31,0.00,'2022-08-07 11:31:35','',''),(5609,'21','227','1',1,'Retail Sale Id 5599',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 11:32:14','',''),(5610,'21','227','1',1,'Retail Sale Id 5600',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 11:32:46','',''),(5611,'21','227','1',1,'Retail Sale Id 5601',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 11:34:13','',''),(5612,'21','227','1',1,'Retail Sale Id 5601',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 11:34:13','',''),(5613,'21','227','1',1,'Retail Sale Id 5601',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:34:13','',''),(5614,'21','227','1',1,'Retail Sale Id 5601',2295.20,0.00,0.00,3.02,0.00,'2022-08-07 11:34:13','',''),(5615,'21','227','1',1,'Retail Sale Id 5601',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:34:13','',''),(5616,'21','227','1',1,'Retail Sale Id 5602',798.00,0.00,0.00,1.05,0.00,'2022-08-07 11:34:40','',''),(5617,'21','227','1',1,'Retail Sale Id 5603',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:35:31','',''),(5618,'21','227','1',1,'Retail Sale Id 5604',995.60,0.00,0.00,1.31,0.00,'2022-08-07 11:36:14','',''),(5619,'21','227','1',1,'Retail Sale Id 5605',2994.40,0.00,0.00,3.94,0.00,'2022-08-07 11:37:44','',''),(5620,'21','227','1',1,'Retail Sale Id 5605',3496.00,0.00,0.00,4.60,0.00,'2022-08-07 11:37:44','',''),(5621,'21','227','1',1,'Retail Sale Id 5605',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 11:37:44','',''),(5622,'21','227','1',1,'Retail Sale Id 5605',4499.20,0.00,0.00,5.92,0.00,'2022-08-07 11:37:44','',''),(5623,'21','227','1',1,'Retail Sale Id 5606',995.60,0.00,0.00,1.31,0.00,'2022-08-07 11:39:22','',''),(5624,'21','227','1',1,'Retail Sale Id 5606',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 11:39:22','',''),(5625,'21','227','1',1,'Retail Sale Id 5606',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:39:22','',''),(5626,'21','227','1',1,'Retail Sale Id 5606',8998.40,0.00,0.00,11.84,0.00,'2022-08-07 11:39:22','',''),(5627,'21','227','1',1,'Retail Sale Id 5607',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:40:28','',''),(5628,'21','227','1',1,'Retail Sale Id 5607',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 11:40:28','',''),(5629,'21','227','1',1,'Retail Sale Id 5607',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 11:40:28','',''),(5630,'21','227','1',1,'Retail Sale Id 5608',995.60,0.00,0.00,1.31,0.00,'2022-08-07 11:41:38','',''),(5631,'21','227','1',1,'Retail Sale Id 5608',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 11:41:38','',''),(5632,'21','227','1',1,'Retail Sale Id 5609',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 11:42:22','',''),(5633,'21','227','1',1,'Retail Sale Id 5610',760.00,0.00,0.00,1.00,0.00,'2022-08-07 11:44:36','',''),(5634,'21','227','1',1,'Retail Sale Id 5611',995.60,0.00,0.00,1.31,0.00,'2022-08-07 11:45:08','',''),(5635,'21','227','1',1,'Retail Sale Id 5612',5000.80,0.00,0.00,6.58,0.00,'2022-08-07 11:48:55','',''),(5636,'21','227','1',1,'Retail Sale Id 5613',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:49:38','',''),(5637,'21','227','1',1,'Retail Sale Id 5614',699.20,0.00,0.00,0.92,0.00,'2022-08-07 11:51:11','',''),(5638,'21','227','1',1,'Retail Sale Id 5615',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:52:53','',''),(5639,'21','227','1',1,'Retail Sale Id 5616',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 11:53:36','',''),(5640,'21','227','1',1,'Retail Sale Id 5617',1200.80,0.00,0.00,1.58,0.00,'2022-08-07 12:02:49','',''),(5641,'21','227','1',1,'Retail Sale Id 5618',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 12:03:38','',''),(5642,'21','227','1',1,'Retail Sale Id 5619',2401.60,0.00,0.00,3.16,0.00,'2022-08-07 12:04:22','',''),(5643,'21','227','1',1,'Retail Sale Id 5620',1504.80,0.00,0.00,1.98,0.00,'2022-08-07 12:08:04','',''),(5644,'21','227','1',1,'Retail Sale Id 5621',2394.00,0.00,0.00,3.15,0.00,'2022-08-07 12:09:03','',''),(5645,'21','227','1',1,'Retail Sale Id 5622',4005.20,0.00,0.00,5.27,0.00,'2022-08-07 12:10:48','',''),(5646,'21','227','1',1,'Retail Sale Id 5623',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 12:21:24','',''),(5647,'21','227','1',1,'Retail Sale Id 5624',995.60,0.00,0.00,1.31,0.00,'2022-08-07 12:27:38','',''),(5648,'21','227','1',1,'Retail Sale Id 5625',798.00,0.00,0.00,1.05,0.00,'2022-08-07 12:30:06','',''),(5649,'21','227','1',1,'Retail Sale Id 5626',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 12:30:46','',''),(5650,'21','227','1',1,'Retail Sale Id 5627',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 12:32:32','',''),(5651,'21','227','1',1,'Retail Sale Id 5628',805.60,0.00,0.00,1.06,0.00,'2022-08-07 12:35:17','',''),(5652,'21','227','1',1,'Retail Sale Id 5629',1193.20,0.00,0.00,1.57,0.00,'2022-08-07 12:36:01','',''),(5653,'21','227','1',1,'Retail Sale Id 5630',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 12:36:51','',''),(5654,'21','227','1',1,'Retail Sale Id 5631',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 12:37:41','',''),(5655,'21','227','1',1,'Retail Sale Id 5632',1299.60,0.00,0.00,1.71,0.00,'2022-08-07 12:38:15','',''),(5656,'21','227','1',1,'Retail Sale Id 5633',995.60,0.00,0.00,1.31,0.00,'2022-08-07 12:40:27','',''),(5657,'21','227','1',1,'Retail Sale Id 5634',798.00,0.00,0.00,1.05,0.00,'2022-08-07 12:42:50','',''),(5658,'21','227','1',1,'Retail Sale Id 5635',1504.80,0.00,0.00,1.98,0.00,'2022-08-07 12:48:55','',''),(5659,'21','227','1',1,'Retail Sale Id 5636',995.60,0.00,0.00,1.31,0.00,'2022-08-07 12:49:30','',''),(5660,'21','227','1',1,'Retail Sale Id 5637',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 12:53:11','',''),(5661,'21','227','1',1,'Retail Sale Id 5638',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 12:53:49','',''),(5662,'21','227','1',1,'Retail Sale Id 5639',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 12:54:42','',''),(5663,'21','227','1',1,'Retail Sale Id 5640',2500.40,0.00,0.00,3.29,0.00,'2022-08-07 12:55:28','',''),(5664,'21','227','1',1,'Retail Sale Id 5641',995.60,0.00,0.00,1.31,0.00,'2022-08-07 12:57:14','',''),(5665,'21','227','1',1,'Retail Sale Id 5642',995.60,0.00,0.00,1.31,0.00,'2022-08-07 12:57:48','',''),(5666,'21','227','1',1,'Retail Sale Id 5643',798.00,0.00,0.00,1.05,0.00,'2022-08-07 13:00:38','',''),(5667,'21','227','1',1,'Retail Sale Id 5644',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 13:02:52','',''),(5668,'21','227','1',1,'Retail Sale Id 5645',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 13:03:38','',''),(5669,'21','227','1',1,'Retail Sale Id 5645',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 13:03:38','',''),(5670,'21','227','1',1,'Retail Sale Id 5646',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 13:05:17','',''),(5671,'21','227','1',1,'Retail Sale Id 5647',501.60,0.00,0.00,0.66,0.00,'2022-08-07 13:06:35','',''),(5672,'21','227','1',1,'Retail Sale Id 5648',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 13:07:20','',''),(5673,'21','227','1',1,'Retail Sale Id 5649',995.60,0.00,0.00,1.31,0.00,'2022-08-07 13:07:49','',''),(5674,'21','227','1',1,'Retail Sale Id 5650',2994.40,0.00,0.00,3.94,0.00,'2022-08-07 13:12:51','',''),(5675,'21','227','1',1,'Retail Sale Id 5651',2994.40,0.00,0.00,3.94,0.00,'2022-08-07 13:13:48','',''),(5676,'21','227','1',1,'Retail Sale Id 5652',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 13:21:36','',''),(5677,'21','227','1',1,'Retail Sale Id 5653',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 13:24:24','',''),(5678,'21','227','1',1,'Retail Sale Id 5654',3997.60,0.00,0.00,5.26,0.00,'2022-08-07 13:30:10','',''),(5679,'21','227','1',1,'Retail Sale Id 5656',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 13:38:56','',''),(5680,'21','227','1',1,'Retail Sale Id 5657',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 13:55:15','',''),(5681,'21','227','1',1,'Retail Sale Id 5658',494.00,0.00,0.00,0.65,0.00,'2022-08-07 13:56:40','',''),(5682,'21','227','1',1,'Retail Sale Id 5659',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 14:07:12','',''),(5683,'21','227','1',1,'Retail Sale Id 5660',1200.80,0.00,0.00,1.58,0.00,'2022-08-07 14:08:46','',''),(5684,'21','227','1',1,'Retail Sale Id 5661',995.60,0.00,0.00,1.31,0.00,'2022-08-07 14:10:08','',''),(5685,'21','227','1',1,'Retail Sale Id 5662',4499.20,0.00,0.00,5.92,0.00,'2022-08-07 14:12:30','',''),(5686,'21','227','1',1,'Retail Sale Id 5663',2994.40,0.00,0.00,3.94,0.00,'2022-08-07 14:16:50','',''),(5687,'21','227','1',1,'Retail Sale Id 5664',798.00,0.00,0.00,1.05,0.00,'2022-08-07 14:17:26','',''),(5688,'21','227','1',1,'Retail Sale Id 5665',995.60,0.00,0.00,1.31,0.00,'2022-08-07 14:21:31','',''),(5689,'21','227','1',1,'Retail Sale Id 5666',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 14:22:23','',''),(5690,'21','227','1',1,'Retail Sale Id 5667',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 14:30:02','',''),(5691,'21','227','1',1,'Retail Sale Id 5668',1504.80,0.00,0.00,1.98,0.00,'2022-08-07 14:35:27','',''),(5692,'21','227','1',1,'Retail Sale Id 5669',7007.20,0.00,0.00,9.22,0.00,'2022-08-07 14:43:18','',''),(5693,'21','227','1',1,'Retail Sale Id 5670',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 14:46:51','',''),(5694,'21','227','1',1,'Retail Sale Id 5671',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 14:47:31','',''),(5695,'21','227','1',1,'Retail Sale Id 5672',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 14:50:01','',''),(5696,'21','227','1',1,'Retail Sale Id 5673',3040.00,0.00,0.00,4.00,0.00,'2022-08-07 14:53:13','',''),(5697,'21','227','1',1,'Retail Sale Id 5674',1504.80,0.00,0.00,1.98,0.00,'2022-08-07 14:53:50','',''),(5698,'21','227','1',1,'Retail Sale Id 5675',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 14:56:16','',''),(5699,'21','227','1',1,'Retail Sale Id 5676',1193.20,0.00,0.00,1.57,0.00,'2022-08-07 15:01:19','',''),(5700,'21','227','1',1,'Retail Sale Id 5677',1003.20,0.00,0.00,1.32,0.00,'2022-08-07 15:01:56','',''),(5701,'21','227','1',1,'Retail Sale Id 5678',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 15:08:50','',''),(5702,'21','227','1',1,'Retail Sale Id 5679',798.00,0.00,0.00,1.05,0.00,'2022-08-07 15:09:39','',''),(5703,'21','227','1',1,'Retail Sale Id 5680',2500.40,0.00,0.00,3.29,0.00,'2022-08-07 15:10:40','',''),(5704,'21','227','1',1,'Retail Sale Id 5681',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 15:11:59','',''),(5705,'21','227','1',1,'Retail Sale Id 5681',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 15:11:59','',''),(5706,'21','227','1',1,'Retail Sale Id 5682',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 15:12:49','',''),(5707,'21','227','1',1,'Retail Sale Id 5683',3040.00,0.00,0.00,4.00,0.00,'2022-08-07 15:14:04','',''),(5708,'21','227','1',1,'Retail Sale Id 5684',798.00,0.00,0.00,1.05,0.00,'2022-08-07 15:16:31','',''),(5709,'21','227','1',1,'Retail Sale Id 5685',798.00,0.00,0.00,1.05,0.00,'2022-08-07 15:17:10','',''),(5710,'21','227','1',1,'Retail Sale Id 5686',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 15:19:50','',''),(5711,'21','227','1',1,'Retail Sale Id 5687',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 15:23:41','',''),(5712,'21','227','1',1,'Retail Sale Id 5688',2006.40,0.00,0.00,2.64,0.00,'2022-08-07 15:24:18','',''),(5713,'21','227','1',1,'Retail Sale Id 5689',1003.20,0.00,0.00,1.32,0.00,'2022-08-07 15:34:00','',''),(5714,'21','227','1',1,'Retail Sale Id 5689',1504.80,0.00,0.00,1.98,0.00,'2022-08-07 15:34:00','',''),(5715,'21','227','1',1,'Retail Sale Id 5690',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 15:35:31','',''),(5716,'21','227','1',1,'Retail Sale Id 5691',1504.80,0.00,0.00,1.98,0.00,'2022-08-07 15:36:38','',''),(5717,'21','227','1',1,'Retail Sale Id 5692',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 15:39:03','',''),(5718,'21','227','1',1,'Retail Sale Id 5693',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 15:43:22','',''),(5719,'21','227','1',1,'Retail Sale Id 5694',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 15:50:17','',''),(5720,'21','227','1',1,'Retail Sale Id 5695',494.00,0.00,0.00,0.65,0.00,'2022-08-07 15:53:45','',''),(5721,'21','227','1',1,'Retail Sale Id 5696',494.00,0.00,0.00,0.65,0.00,'2022-08-07 16:15:11','',''),(5722,'21','227','1',1,'Retail Sale Id 5697',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 16:16:08','',''),(5723,'21','227','1',1,'Retail Sale Id 5698',995.60,0.00,0.00,1.31,0.00,'2022-08-07 16:23:23','',''),(5724,'21','227','1',1,'Retail Sale Id 5699',3040.00,0.00,0.00,4.00,0.00,'2022-08-07 16:24:03','',''),(5725,'21','227','1',1,'Retail Sale Id 5700',592.80,0.00,0.00,0.78,0.00,'2022-08-07 16:24:53','',''),(5726,'21','227','1',1,'Retail Sale Id 5701',995.60,0.00,0.00,1.31,0.00,'2022-08-07 16:25:43','',''),(5727,'21','227','1',1,'Retail Sale Id 5703',3997.60,0.00,0.00,5.26,0.00,'2022-08-07 16:27:36','',''),(5728,'21','227','1',1,'Retail Sale Id 5705',494.00,0.00,0.00,0.65,0.00,'2022-08-07 16:30:12','',''),(5729,'21','227','1',1,'Retail Sale Id 5706',798.00,0.00,0.00,1.05,0.00,'2022-08-07 16:31:46','',''),(5730,'21','227','1',1,'Retail Sale Id 5707',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 16:34:56','',''),(5731,'21','227','1',1,'Retail Sale Id 5708',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 16:35:32','',''),(5732,'21','227','1',1,'Retail Sale Id 5709',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 16:45:23','',''),(5733,'21','227','1',1,'Retail Sale Id 5710',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 16:46:06','',''),(5734,'21','227','1',1,'Retail Sale Id 5711',1299.60,0.00,0.00,1.71,0.00,'2022-08-07 16:47:46','',''),(5735,'21','227','1',1,'Retail Sale Id 5712',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 16:48:27','',''),(5736,'21','227','1',1,'Retail Sale Id 5713',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 16:56:36','',''),(5737,'21','227','1',1,'Retail Sale Id 5713',1504.80,0.00,0.00,1.98,0.00,'2022-08-07 16:56:36','',''),(5738,'21','227','1',1,'Retail Sale Id 5714',896.80,0.00,0.00,1.18,0.00,'2022-08-07 17:00:34','',''),(5739,'21','227','1',1,'Retail Sale Id 5715',5000.80,0.00,0.00,6.58,0.00,'2022-08-07 17:04:49','',''),(5740,'21','227','1',1,'Retail Sale Id 5716',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 17:09:22','',''),(5741,'21','227','1',1,'Retail Sale Id 5717',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 17:11:29','',''),(5742,'21','227','1',1,'Retail Sale Id 5718',995.60,0.00,0.00,1.31,0.00,'2022-08-07 17:13:09','',''),(5743,'21','227','1',1,'Retail Sale Id 5719',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 17:13:47','',''),(5744,'21','227','1',1,'Retail Sale Id 5720',995.60,0.00,0.00,1.31,0.00,'2022-08-07 17:14:41','',''),(5745,'21','227','1',1,'Retail Sale Id 5721',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 17:15:12','',''),(5746,'21','227','1',1,'Retail Sale Id 5722',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 17:15:44','',''),(5747,'21','227','1',1,'Retail Sale Id 5723',995.60,0.00,0.00,1.31,0.00,'2022-08-07 17:16:15','',''),(5748,'21','227','1',1,'Retail Sale Id 5724',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 17:16:37','',''),(5749,'21','227','1',1,'Retail Sale Id 5725',995.60,0.00,0.00,1.31,0.00,'2022-08-07 17:17:09','',''),(5750,'21','227','1',1,'Retail Sale Id 5726',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 17:20:34','',''),(5751,'21','227','1',1,'Retail Sale Id 5727',995.60,0.00,0.00,1.31,0.00,'2022-08-07 17:23:30','',''),(5752,'21','227','1',1,'Retail Sale Id 5728',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 17:30:27','',''),(5753,'21','227','1',1,'Retail Sale Id 5729',1193.20,0.00,0.00,1.57,0.00,'2022-08-07 17:33:49','',''),(5754,'21','227','1',1,'Retail Sale Id 5730',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 17:37:37','',''),(5755,'21','227','1',1,'Retail Sale Id 5731',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 17:38:34','',''),(5756,'21','227','1',1,'Retail Sale Id 5731',2006.40,0.00,0.00,2.64,0.00,'2022-08-07 17:38:34','',''),(5757,'21','227','1',1,'Retail Sale Id 5732',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 17:39:15','',''),(5758,'21','227','1',1,'Retail Sale Id 5733',798.00,0.00,0.00,1.05,0.00,'2022-08-07 17:40:12','',''),(5759,'21','227','1',1,'Retail Sale Id 5734',798.00,0.00,0.00,1.05,0.00,'2022-08-07 17:40:42','',''),(5760,'21','227','1',1,'Retail Sale Id 5735',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 17:43:22','',''),(5761,'21','227','1',1,'Retail Sale Id 5736',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 17:47:16','',''),(5762,'21','227','1',1,'Retail Sale Id 5737',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 17:52:42','',''),(5763,'21','227','1',1,'Retail Sale Id 5738',2796.80,0.00,0.00,3.68,0.00,'2022-08-07 17:56:04','',''),(5764,'21','227','1',1,'Retail Sale Id 5739',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 17:56:43','',''),(5765,'21','227','1',1,'Retail Sale Id 5740',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 18:01:26','',''),(5766,'21','227','1',1,'Retail Sale Id 5741',995.60,0.00,0.00,1.31,0.00,'2022-08-07 18:02:18','',''),(5767,'21','227','1',1,'Retail Sale Id 5742',2006.40,0.00,0.00,2.64,0.00,'2022-08-07 18:04:38','',''),(5768,'21','227','1',1,'Retail Sale Id 5743',1930.40,0.00,0.00,2.54,0.00,'2022-08-07 18:12:12','',''),(5769,'21','227','1',1,'Retail Sale Id 5702',995.60,0.00,0.00,1.31,0.00,'2022-08-07 18:54:29','',''),(5770,'21','227','1',1,'Retail Sale Id 5704',494.00,0.00,0.00,0.65,0.00,'2022-08-07 18:54:54','',''),(5771,'21','227','1',1,'Retail Sale Id 5655',3997.60,0.00,0.00,5.26,0.00,'2022-08-07 18:55:26','',''),(5772,'21','227','1',1,'Retail Sale Id 5744',995.60,0.00,0.00,1.31,0.00,'2022-08-08 09:40:17','',''),(5773,'21','227','1',1,'Retail Sale Id 5744',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 09:40:17','',''),(5774,'21','227','1',1,'Retail Sale Id 5744',4560.00,0.00,0.00,6.00,0.00,'2022-08-08 09:40:17','',''),(5775,'21','227','1',1,'Retail Sale Id 5745',1596.00,0.00,0.00,2.10,0.00,'2022-08-08 09:41:33','',''),(5776,'21','227','1',1,'Retail Sale Id 5745',2994.40,0.00,0.00,3.94,0.00,'2022-08-08 09:41:33','',''),(5777,'21','227','1',1,'Retail Sale Id 5745',4598.00,0.00,0.00,6.05,0.00,'2022-08-08 09:41:33','',''),(5778,'21','227','1',1,'Retail Sale Id 5746',2302.80,0.00,0.00,3.03,0.00,'2022-08-08 09:42:28','',''),(5779,'21','227','1',1,'Retail Sale Id 5747',995.60,0.00,0.00,1.31,0.00,'2022-08-08 09:43:47','',''),(5780,'21','227','1',1,'Retail Sale Id 5747',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 09:43:47','',''),(5781,'21','227','1',1,'Retail Sale Id 5747',1900.00,0.00,0.00,2.50,0.00,'2022-08-08 09:43:47','',''),(5782,'21','227','1',1,'Retail Sale Id 5747',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 09:43:47','',''),(5783,'21','227','1',1,'Retail Sale Id 5748',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 09:44:56','',''),(5784,'21','227','1',1,'Retail Sale Id 5748',2295.20,0.00,0.00,3.02,0.00,'2022-08-08 09:44:56','',''),(5785,'21','227','1',1,'Retail Sale Id 5748',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 09:44:56','',''),(5786,'21','227','1',1,'Retail Sale Id 5748',9500.00,0.00,0.00,12.50,0.00,'2022-08-08 09:44:56','',''),(5787,'21','227','1',1,'Retail Sale Id 5749',995.60,0.00,0.00,1.31,0.00,'2022-08-08 09:46:16','',''),(5788,'21','227','1',1,'Retail Sale Id 5749',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 09:46:16','',''),(5789,'21','227','1',1,'Retail Sale Id 5749',1520.00,0.00,0.00,2.00,0.00,'2022-08-08 09:46:16','',''),(5790,'21','227','1',1,'Retail Sale Id 5749',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 09:46:16','',''),(5791,'21','227','1',1,'Retail Sale Id 5749',4499.20,0.00,0.00,5.92,0.00,'2022-08-08 09:46:16','',''),(5792,'21','227','1',1,'Retail Sale Id 5750',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 09:47:47','',''),(5793,'21','227','1',1,'Retail Sale Id 5751',3496.00,0.00,0.00,4.60,0.00,'2022-08-08 09:52:06','',''),(5794,'21','227','1',1,'Retail Sale Id 5752',9500.00,0.00,0.00,12.50,0.00,'2022-08-08 09:56:24','',''),(5795,'21','227','1',1,'Retail Sale Id 5753',1504.80,0.00,0.00,1.98,0.00,'2022-08-08 09:57:30','',''),(5796,'21','227','1',1,'Retail Sale Id 5754',798.00,0.00,0.00,1.05,0.00,'2022-08-08 10:02:00','',''),(5797,'21','227','1',1,'Retail Sale Id 5755',3002.00,0.00,0.00,3.95,0.00,'2022-08-08 10:03:15','',''),(5798,'21','227','1',1,'Retail Sale Id 5756',2006.40,0.00,0.00,2.64,0.00,'2022-08-08 10:06:46','',''),(5799,'21','227','1',1,'Retail Sale Id 5757',3002.00,0.00,0.00,3.95,0.00,'2022-08-08 10:12:20','',''),(5800,'21','227','1',1,'Retail Sale Id 5758',2994.40,0.00,0.00,3.94,0.00,'2022-08-08 10:14:57','',''),(5801,'21','227','1',1,'Retail Sale Id 5759',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 10:16:25','',''),(5802,'21','227','1',1,'Retail Sale Id 5760',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 10:21:51','',''),(5803,'21','227','1',1,'Retail Sale Id 5761',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 10:24:44','',''),(5804,'21','227','1',1,'Retail Sale Id 5762',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 10:25:37','',''),(5805,'21','227','1',1,'Retail Sale Id 5763',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 10:29:58','',''),(5806,'21','227','1',1,'Retail Sale Id 5764',1398.40,0.00,0.00,1.84,0.00,'2022-08-08 10:30:50','',''),(5807,'21','227','1',1,'Retail Sale Id 5765',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 10:31:28','',''),(5808,'21','227','1',1,'Retail Sale Id 5766',995.60,0.00,0.00,1.31,0.00,'2022-08-08 10:39:57','',''),(5809,'21','227','1',1,'Retail Sale Id 5767',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 10:40:34','',''),(5810,'21','227','1',1,'Retail Sale Id 5768',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 10:41:23','',''),(5811,'21','227','1',1,'Retail Sale Id 5769',4993.20,0.00,0.00,6.57,0.00,'2022-08-08 10:42:06','',''),(5812,'21','227','1',1,'Retail Sale Id 5770',9500.00,0.00,0.00,12.50,0.00,'2022-08-08 10:45:15','',''),(5813,'21','227','1',1,'Retail Sale Id 5771',995.60,0.00,0.00,1.31,0.00,'2022-08-08 10:48:50','',''),(5814,'21','227','1',1,'Retail Sale Id 5772',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 10:51:05','',''),(5815,'21','227','1',1,'Retail Sale Id 5773',2994.40,0.00,0.00,3.94,0.00,'2022-08-08 11:08:36','',''),(5816,'21','227','1',1,'Retail Sale Id 5774',494.00,0.00,0.00,0.65,0.00,'2022-08-08 11:15:41','',''),(5817,'21','227','1',1,'Retail Sale Id 5775',2994.40,0.00,0.00,3.94,0.00,'2022-08-08 11:16:12','',''),(5818,'21','227','1',1,'Retail Sale Id 5776',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 11:16:51','',''),(5819,'21','227','1',1,'Retail Sale Id 5777',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 11:17:33','',''),(5820,'21','227','1',1,'Retail Sale Id 5778',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 11:21:56','',''),(5821,'21','227','1',1,'Retail Sale Id 5779',4560.00,0.00,0.00,6.00,0.00,'2022-08-08 11:23:44','',''),(5822,'21','227','1',1,'Retail Sale Id 5780',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 11:24:26','',''),(5823,'21','227','1',1,'Retail Sale Id 5781',798.00,0.00,0.00,1.05,0.00,'2022-08-08 11:25:05','',''),(5824,'21','227','1',1,'Retail Sale Id 5782',1520.00,0.00,0.00,2.00,0.00,'2022-08-08 11:25:41','',''),(5825,'21','227','1',1,'Retail Sale Id 5783',9500.00,0.00,0.00,12.50,0.00,'2022-08-08 11:26:22','',''),(5826,'21','227','1',1,'Retail Sale Id 5784',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 11:35:17','',''),(5827,'21','227','1',1,'Retail Sale Id 5785',1520.00,0.00,0.00,2.00,0.00,'2022-08-08 11:36:51','',''),(5828,'21','227','1',1,'Retail Sale Id 5786',4560.00,0.00,0.00,6.00,0.00,'2022-08-08 11:37:42','',''),(5829,'21','227','1',1,'Retail Sale Id 5787',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 11:38:46','',''),(5830,'21','227','1',1,'Retail Sale Id 5788',805.60,0.00,0.00,1.06,0.00,'2022-08-08 11:45:15','',''),(5831,'21','227','1',1,'Retail Sale Id 5789',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 11:51:06','',''),(5832,'21','227','1',1,'Retail Sale Id 5790',1504.80,0.00,0.00,1.98,0.00,'2022-08-08 11:52:45','',''),(5833,'21','227','1',1,'Retail Sale Id 5791',9500.00,0.00,0.00,12.50,0.00,'2022-08-08 11:56:04','',''),(5834,'21','227','1',1,'Retail Sale Id 5792',2295.20,0.00,0.00,3.02,0.00,'2022-08-08 11:57:44','',''),(5835,'21','227','1',1,'Retail Sale Id 5793',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 12:01:47','',''),(5836,'21','227','1',1,'Retail Sale Id 5794',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 12:09:48','',''),(5837,'21','227','1',1,'Retail Sale Id 5795',6277.60,0.00,0.00,8.26,0.00,'2022-08-08 12:11:35','',''),(5838,'21','227','1',1,'Retail Sale Id 5796',5320.00,0.00,0.00,7.00,0.00,'2022-08-08 12:17:44','',''),(5839,'21','227','1',1,'Retail Sale Id 5797',4499.20,0.00,0.00,5.92,0.00,'2022-08-08 12:25:59','',''),(5840,'21','227','1',1,'Retail Sale Id 5798',2994.40,0.00,0.00,3.94,0.00,'2022-08-08 12:31:27','',''),(5841,'21','227','1',1,'Retail Sale Id 5799',7995.20,0.00,0.00,10.52,0.00,'2022-08-08 12:43:23','',''),(5842,'21','227','1',1,'Retail Sale Id 5800',494.00,0.00,0.00,0.65,0.00,'2022-08-08 12:45:53','',''),(5843,'21','227','1',1,'Retail Sale Id 5801',995.60,0.00,0.00,1.31,0.00,'2022-08-08 12:46:45','',''),(5844,'21','227','1',1,'Retail Sale Id 5803',1520.00,0.00,0.00,2.00,0.00,'2022-08-08 12:50:33','',''),(5845,'21','227','1',1,'Retail Sale Id 5804',1193.20,0.00,0.00,1.57,0.00,'2022-08-08 12:51:45','',''),(5846,'21','227','1',1,'Retail Sale Id 5805',2492.80,0.00,0.00,3.28,0.00,'2022-08-08 12:53:22','',''),(5847,'21','227','1',1,'Retail Sale Id 5806',995.60,0.00,0.00,1.31,0.00,'2022-08-08 13:24:01','',''),(5848,'21','227','1',1,'Retail Sale Id 5807',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 13:24:40','',''),(5849,'21','227','1',1,'Retail Sale Id 5808',4560.00,0.00,0.00,6.00,0.00,'2022-08-08 13:30:15','',''),(5850,'21','227','1',1,'Retail Sale Id 5809',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 13:34:31','',''),(5851,'21','227','1',1,'Retail Sale Id 5810',896.80,0.00,0.00,1.18,0.00,'2022-08-08 13:36:06','',''),(5852,'21','227','1',1,'Retail Sale Id 5811',4560.00,0.00,0.00,6.00,0.00,'2022-08-08 13:47:01','',''),(5853,'21','227','1',1,'Retail Sale Id 5812',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 13:48:34','',''),(5854,'21','227','1',1,'Retail Sale Id 5813',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 13:52:41','',''),(5855,'21','227','1',1,'Retail Sale Id 5814',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 14:16:01','',''),(5856,'21','227','1',1,'Retail Sale Id 5815',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 14:27:33','',''),(5857,'21','227','1',1,'Retail Sale Id 5816',4499.20,0.00,0.00,5.92,0.00,'2022-08-08 14:34:31','',''),(5858,'21','227','1',1,'Retail Sale Id 5817',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 14:37:21','',''),(5859,'21','227','1',1,'Retail Sale Id 5818',4993.20,0.00,0.00,6.57,0.00,'2022-08-08 14:38:27','',''),(5860,'21','227','1',1,'Retail Sale Id 5819',4560.00,0.00,0.00,6.00,0.00,'2022-08-08 14:45:33','',''),(5861,'21','227','1',1,'Retail Sale Id 5820',995.60,0.00,0.00,1.31,0.00,'2022-08-08 14:46:22','',''),(5862,'21','227','1',1,'Retail Sale Id 5821',9500.00,0.00,0.00,12.50,0.00,'2022-08-08 14:50:14','',''),(5863,'21','227','1',1,'Retail Sale Id 5822',995.60,0.00,0.00,1.31,0.00,'2022-08-08 14:57:30','',''),(5864,'21','227','1',1,'Retail Sale Id 5823',1520.00,0.00,0.00,2.00,0.00,'2022-08-08 15:02:30','',''),(5865,'21','227','1',1,'Retail Sale Id 5824',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 15:05:39','',''),(5866,'21','227','1',1,'Retail Sale Id 5825',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 15:11:26','',''),(5867,'21','227','1',1,'Retail Sale Id 5826',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 15:15:24','',''),(5868,'21','227','1',1,'Retail Sale Id 5827',1193.20,0.00,0.00,1.57,0.00,'2022-08-08 15:17:45','',''),(5869,'21','227','1',1,'Retail Sale Id 5828',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 15:20:20','',''),(5870,'21','227','1',1,'Retail Sale Id 5830',2492.80,0.00,0.00,3.28,0.00,'2022-08-08 15:24:05','',''),(5871,'21','227','1',1,'Retail Sale Id 5831',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 15:39:46','',''),(5872,'21','227','1',1,'Retail Sale Id 5832',1900.00,0.00,0.00,2.50,0.00,'2022-08-08 15:40:39','',''),(5873,'21','227','1',1,'Retail Sale Id 5833',1748.00,0.00,0.00,2.30,0.00,'2022-08-08 15:42:55','',''),(5874,'21','227','1',1,'Retail Sale Id 5834',2257.20,0.00,0.00,2.97,0.00,'2022-08-08 15:53:26','',''),(5875,'21','227','1',1,'Retail Sale Id 5835',1520.00,0.00,0.00,2.00,0.00,'2022-08-08 16:01:53','',''),(5876,'21','227','1',1,'Retail Sale Id 5836',699.20,0.00,0.00,0.92,0.00,'2022-08-08 16:02:31','',''),(5877,'21','227','1',1,'Retail Sale Id 5837',995.60,0.00,0.00,1.31,0.00,'2022-08-08 16:09:15','',''),(5878,'21','227','1',1,'Retail Sale Id 5839',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 16:12:56','',''),(5879,'21','227','1',1,'Retail Sale Id 5840',798.00,0.00,0.00,1.05,0.00,'2022-08-08 16:13:34','',''),(5880,'21','227','1',1,'Retail Sale Id 5841',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 16:17:52','',''),(5881,'21','227','1',1,'Retail Sale Id 5842',4560.00,0.00,0.00,6.00,0.00,'2022-08-08 16:22:39','',''),(5882,'21','227','1',1,'Retail Sale Id 5843',995.60,0.00,0.00,1.31,0.00,'2022-08-08 16:23:22','',''),(5883,'21','227','1',1,'Retail Sale Id 5844',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 16:24:56','',''),(5884,'21','227','1',1,'Retail Sale Id 5845',995.60,0.00,0.00,1.31,0.00,'2022-08-08 16:27:42','',''),(5885,'21','227','1',1,'Retail Sale Id 5846',1694.80,0.00,0.00,2.23,0.00,'2022-08-08 16:30:49','',''),(5886,'21','227','1',1,'Retail Sale Id 5847',19000.00,0.00,0.00,25.00,0.00,'2022-08-08 16:31:58','',''),(5887,'21','227','1',1,'Retail Sale Id 5848',3800.00,0.00,0.00,5.00,0.00,'2022-08-08 16:33:46','',''),(5888,'21','227','1',1,'Retail Sale Id 5849',995.60,0.00,0.00,1.31,0.00,'2022-08-08 16:41:03','',''),(5889,'21','227','1',1,'Retail Sale Id 5850',1520.00,0.00,0.00,2.00,0.00,'2022-08-08 16:42:23','',''),(5890,'21','227','1',1,'Retail Sale Id 5852',995.60,0.00,0.00,1.31,0.00,'2022-08-08 16:47:15','',''),(5891,'21','227','1',1,'Retail Sale Id 5854',494.00,0.00,0.00,0.65,0.00,'2022-08-08 16:50:12','',''),(5892,'21','227','1',1,'Retail Sale Id 5856',1193.20,0.00,0.00,1.57,0.00,'2022-08-08 16:52:59','',''),(5893,'21','227','1',1,'Retail Sale Id 5857',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 16:56:36','',''),(5894,'21','227','1',1,'Retail Sale Id 5858',1694.80,0.00,0.00,2.23,0.00,'2022-08-08 16:57:47','',''),(5895,'21','227','1',1,'Retail Sale Id 5859',1520.00,0.00,0.00,2.00,0.00,'2022-08-08 17:06:56','',''),(5896,'21','227','1',1,'Retail Sale Id 5860',1793.60,0.00,0.00,2.36,0.00,'2022-08-08 17:07:48','',''),(5897,'21','227','1',1,'Retail Sale Id 5861',1998.80,0.00,0.00,2.63,0.00,'2022-08-08 17:11:44','',''),(5898,'21','227','1',1,'Retail Sale Id 5862',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 17:15:43','',''),(5899,'21','227','1',1,'Retail Sale Id 5863',3496.00,0.00,0.00,4.60,0.00,'2022-08-08 17:19:33','',''),(5900,'21','227','1',1,'Retail Sale Id 5864',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 17:23:50','',''),(5901,'21','227','1',1,'Retail Sale Id 5865',2994.40,0.00,0.00,3.94,0.00,'2022-08-08 17:24:45','',''),(5902,'21','227','1',1,'Retail Sale Id 5866',4993.20,0.00,0.00,6.57,0.00,'2022-08-08 17:25:43','',''),(5903,'21','227','1',1,'Retail Sale Id 5867',3040.00,0.00,0.00,4.00,0.00,'2022-08-08 17:29:17','',''),(5904,'21','227','1',1,'Retail Sale Id 5868',995.60,0.00,0.00,1.31,0.00,'2022-08-08 17:32:13','',''),(5905,'21','227','1',1,'Retail Sale Id 5869',2698.00,0.00,0.00,3.55,0.00,'2022-08-08 17:38:24','',''),(5906,'21','227','1',1,'Retail Sale Id 5870',2994.40,0.00,0.00,3.94,0.00,'2022-08-08 17:39:50','',''),(5907,'21','227','1',1,'Retail Sale Id 5871',995.60,0.00,0.00,1.31,0.00,'2022-08-08 17:46:22','',''),(5908,'21','227','1',1,'Retail Sale Id 5872',2280.00,0.00,0.00,3.00,0.00,'2022-08-08 17:47:10','',''),(5909,'21','227','1',1,'Retail Sale Id 5873',995.60,0.00,0.00,1.31,0.00,'2022-08-08 17:49:17','',''),(5910,'21','227','1',1,'Retail Sale Id 5874',9500.00,0.00,0.00,12.50,0.00,'2022-08-08 17:51:08','',''),(5911,'21','227','1',1,'Retail Sale Id 5875',2994.40,0.00,0.00,3.94,0.00,'2022-08-08 17:53:22','',''),(5912,'21','227','1',1,'Retail Sale Id 5876',4499.20,0.00,0.00,5.92,0.00,'2022-08-08 17:54:08','',''),(5913,'21','227','1',1,'Retail Sale Id 5877',1497.20,0.00,0.00,1.97,0.00,'2022-08-08 17:55:03','',''),(5914,'21','227','1',1,'Retail Sale Id 5878',3997.60,0.00,0.00,5.26,0.00,'2022-08-08 17:56:45','',''),(5915,'21','227','1',1,'Retail Sale Id 5855',1193.20,0.00,0.00,1.57,0.00,'2022-08-09 05:42:58','',''),(5916,'21','227','1',1,'Retail Sale Id 5853',995.60,0.00,0.00,1.31,0.00,'2022-08-09 05:43:51','',''),(5917,'21','227','1',1,'Retail Sale Id 5851',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 05:44:46','',''),(5918,'21','227','1',1,'Retail Sale Id 5838',995.60,0.00,0.00,1.31,0.00,'2022-08-09 05:45:55','',''),(5919,'21','227','1',1,'Retail Sale Id 5829',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 05:46:55','',''),(5920,'21','227','1',1,'Retail Sale Id 5802',995.60,0.00,0.00,1.31,0.00,'2022-08-09 05:48:01','',''),(5921,'21','227','1',1,'Retail Sale Id 5879',5776.00,0.00,0.00,7.60,0.00,'2022-08-09 05:51:07','',''),(5922,'21','227','1',1,'Retail Sale Id 5880',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 10:27:38','',''),(5923,'21','227','1',1,'Retail Sale Id 5881',995.60,0.00,0.00,1.31,0.00,'2022-08-09 10:28:23','',''),(5924,'21','227','1',1,'Retail Sale Id 5882',2492.80,0.00,0.00,3.28,0.00,'2022-08-09 10:29:11','',''),(5925,'21','227','1',1,'Retail Sale Id 5883',2994.40,0.00,0.00,3.94,0.00,'2022-08-09 10:30:06','',''),(5926,'21','227','1',1,'Retail Sale Id 5884',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 10:30:44','',''),(5927,'21','227','1',1,'Retail Sale Id 5885',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 10:31:29','',''),(5928,'21','227','1',1,'Retail Sale Id 5886',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 10:32:15','',''),(5929,'21','227','1',1,'Retail Sale Id 5887',4499.20,0.00,0.00,5.92,0.00,'2022-08-09 10:33:21','',''),(5930,'21','227','1',1,'Retail Sale Id 5888',2994.40,0.00,0.00,3.94,0.00,'2022-08-09 10:34:12','',''),(5931,'21','227','1',1,'Retail Sale Id 5889',995.60,0.00,0.00,1.31,0.00,'2022-08-09 10:37:14','',''),(5932,'21','227','1',1,'Retail Sale Id 5890',2492.80,0.00,0.00,3.28,0.00,'2022-08-09 10:38:10','',''),(5933,'21','227','1',1,'Retail Sale Id 5891',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 10:39:10','',''),(5934,'21','227','1',1,'Retail Sale Id 5892',995.60,0.00,0.00,1.31,0.00,'2022-08-09 10:40:01','',''),(5935,'21','227','1',1,'Retail Sale Id 5893',2994.40,0.00,0.00,3.94,0.00,'2022-08-09 10:40:41','',''),(5936,'21','227','1',1,'Retail Sale Id 5894',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 10:41:27','',''),(5937,'21','227','1',1,'Retail Sale Id 5895',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 10:42:21','',''),(5938,'21','227','1',1,'Retail Sale Id 5896',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 10:44:47','',''),(5939,'21','227','1',1,'Retail Sale Id 5897',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 10:45:32','',''),(5940,'21','227','1',1,'Retail Sale Id 5898',995.60,0.00,0.00,1.31,0.00,'2022-08-09 10:46:11','',''),(5941,'21','227','1',1,'Retail Sale Id 5899',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 10:49:21','',''),(5942,'21','227','1',1,'Retail Sale Id 5900',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 10:50:04','',''),(5943,'21','227','1',1,'Retail Sale Id 5901',2492.80,0.00,0.00,3.28,0.00,'2022-08-09 10:50:46','',''),(5944,'21','227','1',1,'Retail Sale Id 5902',4993.20,0.00,0.00,6.57,0.00,'2022-08-09 10:51:35','',''),(5945,'21','227','1',1,'Retail Sale Id 5903',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 10:57:59','',''),(5946,'21','227','1',1,'Retail Sale Id 5904',995.60,0.00,0.00,1.31,0.00,'2022-08-09 10:58:52','',''),(5947,'21','227','1',1,'Retail Sale Id 5905',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 10:59:37','',''),(5948,'21','227','1',1,'Retail Sale Id 5906',4499.20,0.00,0.00,5.92,0.00,'2022-08-09 11:00:25','',''),(5949,'21','227','1',1,'Retail Sale Id 5907',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 11:01:07','',''),(5950,'21','227','1',1,'Retail Sale Id 5908',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 11:01:41','',''),(5951,'21','227','1',1,'Retail Sale Id 5909',5320.00,0.00,0.00,7.00,0.00,'2022-08-09 11:03:34','',''),(5952,'21','227','1',1,'Retail Sale Id 5910',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 11:04:18','',''),(5953,'21','227','1',1,'Retail Sale Id 5911',3997.60,0.00,0.00,5.26,0.00,'2022-08-09 11:04:57','',''),(5954,'21','227','1',1,'Retail Sale Id 5912',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 11:05:37','',''),(5955,'21','227','1',1,'Retail Sale Id 5913',995.60,0.00,0.00,1.31,0.00,'2022-08-09 11:12:46','',''),(5956,'21','227','1',1,'Retail Sale Id 5914',995.60,0.00,0.00,1.31,0.00,'2022-08-09 11:15:44','',''),(5957,'21','227','1',1,'Retail Sale Id 5915',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 11:21:43','',''),(5958,'21','227','1',1,'Retail Sale Id 5916',4476.40,0.00,0.00,5.89,0.00,'2022-08-09 11:42:11','',''),(5959,'21','227','1',1,'Retail Sale Id 5917',6999.60,0.00,0.00,9.21,0.00,'2022-08-09 11:45:13','',''),(5960,'21','227','1',1,'Retail Sale Id 5918',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 11:54:03','',''),(5961,'21','227','1',1,'Retail Sale Id 5919',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 12:05:52','',''),(5962,'21','227','1',1,'Retail Sale Id 5920',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 12:11:40','',''),(5963,'21','227','1',1,'Retail Sale Id 5921',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 12:15:45','',''),(5964,'21','227','1',1,'Retail Sale Id 5922',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 12:22:55','',''),(5965,'21','227','1',1,'Retail Sale Id 5923',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 12:25:53','',''),(5966,'21','227','1',1,'Retail Sale Id 5924',2492.80,0.00,0.00,3.28,0.00,'2022-08-09 12:28:27','',''),(5967,'21','227','1',1,'Retail Sale Id 5925',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 12:31:45','',''),(5968,'21','227','1',1,'Retail Sale Id 5926',3496.00,0.00,0.00,4.60,0.00,'2022-08-09 12:35:00','',''),(5969,'21','227','1',1,'Retail Sale Id 5927',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 12:42:51','',''),(5970,'21','227','1',1,'Retail Sale Id 5928',995.60,0.00,0.00,1.31,0.00,'2022-08-09 12:44:33','',''),(5971,'21','227','1',1,'Retail Sale Id 5929',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 12:52:41','',''),(5972,'21','227','1',1,'Retail Sale Id 5930',995.60,0.00,0.00,1.31,0.00,'2022-08-09 12:53:48','',''),(5973,'21','227','1',1,'Retail Sale Id 5931',8360.00,0.00,0.00,11.00,0.00,'2022-08-09 13:00:06','',''),(5974,'21','227','1',1,'Retail Sale Id 5932',2492.80,0.00,0.00,3.28,0.00,'2022-08-09 13:01:14','',''),(5975,'21','227','1',1,'Retail Sale Id 5933',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 13:02:26','',''),(5976,'21','227','1',1,'Retail Sale Id 5934',4993.20,0.00,0.00,6.57,0.00,'2022-08-09 13:04:49','',''),(5977,'21','227','1',1,'Retail Sale Id 5935',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 13:06:40','',''),(5978,'21','227','1',1,'Retail Sale Id 5936',19000.00,0.00,0.00,25.00,0.00,'2022-08-09 13:12:57','',''),(5979,'21','227','1',1,'Retail Sale Id 5937',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 13:29:07','',''),(5980,'21','227','1',1,'Retail Sale Id 5938',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 14:08:45','',''),(5981,'21','227','1',1,'Retail Sale Id 5939',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 14:09:32','',''),(5982,'21','227','1',1,'Retail Sale Id 5940',2994.40,0.00,0.00,3.94,0.00,'2022-08-09 14:10:09','',''),(5983,'21','227','1',1,'Retail Sale Id 5941',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 14:10:47','',''),(5984,'21','227','1',1,'Retail Sale Id 5942',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 14:22:20','',''),(5985,'21','227','1',1,'Retail Sale Id 5943',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 14:23:09','',''),(5986,'21','227','1',1,'Retail Sale Id 5944',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 14:23:41','',''),(5987,'21','227','1',1,'Retail Sale Id 5945',2492.80,0.00,0.00,3.28,0.00,'2022-08-09 14:25:27','',''),(5988,'21','227','1',1,'Retail Sale Id 5946',494.00,0.00,0.00,0.65,0.00,'2022-08-09 14:26:59','',''),(5989,'21','227','1',1,'Retail Sale Id 5947',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 14:27:52','',''),(5990,'21','227','1',1,'Retail Sale Id 5948',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 14:35:36','',''),(5991,'21','227','1',1,'Retail Sale Id 5949',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 14:39:56','',''),(5992,'21','227','1',1,'Retail Sale Id 5950',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 14:53:15','',''),(5993,'21','227','1',1,'Retail Sale Id 5951',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 14:59:23','',''),(5994,'21','227','1',1,'Retail Sale Id 5952',995.60,0.00,0.00,1.31,0.00,'2022-08-09 15:04:45','',''),(5995,'21','227','1',1,'Retail Sale Id 5953',7600.00,0.00,0.00,10.00,0.00,'2022-08-09 15:13:35','',''),(5996,'21','227','1',1,'Retail Sale Id 5954',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 15:16:10','',''),(5997,'21','227','1',1,'Retail Sale Id 5955',34998.00,0.00,0.00,46.05,0.00,'2022-08-09 15:19:57','',''),(5998,'21','227','1',1,'Retail Sale Id 5956',995.60,0.00,0.00,1.31,0.00,'2022-08-09 15:20:46','',''),(5999,'21','227','1',1,'Retail Sale Id 5957',501.60,0.00,0.00,0.66,0.00,'2022-08-09 15:21:56','',''),(6000,'21','227','1',1,'Retail Sale Id 5958',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 15:26:15','',''),(6001,'21','227','1',1,'Retail Sale Id 5959',995.60,0.00,0.00,1.31,0.00,'2022-08-09 15:26:55','',''),(6002,'21','227','1',1,'Retail Sale Id 5960',3997.60,0.00,0.00,5.26,0.00,'2022-08-09 15:31:25','',''),(6003,'21','227','1',1,'Retail Sale Id 5961',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 15:31:55','',''),(6004,'21','227','1',1,'Retail Sale Id 5962',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 15:36:44','',''),(6005,'21','227','1',1,'Retail Sale Id 5963',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 15:40:55','',''),(6006,'21','227','1',1,'Retail Sale Id 5964',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 15:41:33','',''),(6007,'21','227','1',1,'Retail Sale Id 5965',995.60,0.00,0.00,1.31,0.00,'2022-08-09 15:44:32','',''),(6008,'21','227','1',1,'Retail Sale Id 5966',1003.20,0.00,0.00,1.32,0.00,'2022-08-09 15:48:48','',''),(6009,'21','227','1',1,'Retail Sale Id 5967',1003.20,0.00,0.00,1.32,0.00,'2022-08-09 15:50:13','',''),(6010,'21','227','1',1,'Retail Sale Id 5968',14060.00,0.00,0.00,18.50,0.00,'2022-08-09 15:59:08','',''),(6011,'21','227','1',1,'Retail Sale Id 5969',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 16:05:14','',''),(6012,'21','227','1',1,'Retail Sale Id 5970',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 16:15:28','',''),(6013,'21','227','1',1,'Retail Sale Id 5971',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 16:16:15','',''),(6014,'21','227','1',1,'Retail Sale Id 5972',798.00,0.00,0.00,1.05,0.00,'2022-08-09 16:16:55','',''),(6015,'21','227','1',1,'Retail Sale Id 5973',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 16:17:37','',''),(6016,'21','227','1',1,'Retail Sale Id 5974',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 16:23:37','',''),(6017,'21','227','1',1,'Retail Sale Id 5975',1003.20,0.00,0.00,1.32,0.00,'2022-08-09 16:31:25','',''),(6018,'21','227','1',1,'Retail Sale Id 5976',8496.80,0.00,0.00,11.18,0.00,'2022-08-09 16:39:06','',''),(6019,'21','227','1',1,'Retail Sale Id 5977',798.00,0.00,0.00,1.05,0.00,'2022-08-09 16:39:42','',''),(6020,'21','227','1',1,'Retail Sale Id 5978',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 16:40:42','',''),(6021,'21','227','1',1,'Retail Sale Id 5980',3997.60,0.00,0.00,5.26,0.00,'2022-08-09 16:46:51','',''),(6022,'21','227','1',1,'Retail Sale Id 5981',3002.00,0.00,0.00,3.95,0.00,'2022-08-09 16:47:25','',''),(6023,'21','227','1',1,'Retail Sale Id 5982',1793.60,0.00,0.00,2.36,0.00,'2022-08-09 16:50:00','',''),(6024,'21','227','1',1,'Retail Sale Id 5983',494.00,0.00,0.00,0.65,0.00,'2022-08-09 16:50:40','',''),(6025,'21','227','1',1,'Retail Sale Id 5984',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 16:51:20','',''),(6026,'21','227','1',1,'Retail Sale Id 5985',798.00,0.00,0.00,1.05,0.00,'2022-08-09 16:52:05','',''),(6027,'21','227','1',1,'Retail Sale Id 5986',1003.20,0.00,0.00,1.32,0.00,'2022-08-09 16:53:48','',''),(6028,'21','227','1',1,'Retail Sale Id 5987',3997.60,0.00,0.00,5.26,0.00,'2022-08-09 16:57:20','',''),(6029,'21','227','1',1,'Retail Sale Id 5988',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 16:58:00','',''),(6030,'21','227','1',1,'Retail Sale Id 5989',3997.60,0.00,0.00,5.26,0.00,'2022-08-09 16:58:42','',''),(6031,'21','227','1',1,'Retail Sale Id 5990',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 17:02:34','',''),(6032,'21','227','1',1,'Retail Sale Id 5991',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 17:08:54','',''),(6033,'21','227','1',1,'Retail Sale Id 5992',2994.40,0.00,0.00,3.94,0.00,'2022-08-09 17:09:58','',''),(6034,'21','227','1',1,'Retail Sale Id 5993',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 17:10:36','',''),(6035,'21','227','1',1,'Retail Sale Id 5994',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 17:11:14','',''),(6036,'21','227','1',1,'Retail Sale Id 5995',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 17:18:24','',''),(6037,'21','227','1',1,'Retail Sale Id 5996',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 17:19:08','',''),(6038,'21','227','1',1,'Retail Sale Id 5997',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 17:20:03','',''),(6039,'21','227','1',1,'Retail Sale Id 5998',3496.00,0.00,0.00,4.60,0.00,'2022-08-09 17:20:42','',''),(6040,'21','227','1',1,'Retail Sale Id 5999',995.60,0.00,0.00,1.31,0.00,'2022-08-09 17:23:23','',''),(6041,'21','227','1',1,'Retail Sale Id 6000',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 17:24:05','',''),(6042,'21','227','1',1,'Retail Sale Id 6001',995.60,0.00,0.00,1.31,0.00,'2022-08-09 17:28:49','',''),(6043,'21','227','1',1,'Retail Sale Id 6002',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 17:29:40','',''),(6044,'21','227','1',1,'Retail Sale Id 6003',2994.40,0.00,0.00,3.94,0.00,'2022-08-09 17:30:18','',''),(6045,'21','227','1',1,'Retail Sale Id 6004',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 17:31:34','',''),(6046,'21','227','1',1,'Retail Sale Id 6005',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 17:38:37','',''),(6047,'21','227','1',1,'Retail Sale Id 6006',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 17:39:30','',''),(6048,'21','227','1',1,'Retail Sale Id 6007',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 17:51:17','',''),(6049,'21','227','1',1,'Retail Sale Id 6008',2994.40,0.00,0.00,3.94,0.00,'2022-08-09 17:51:50','',''),(6050,'21','227','1',1,'Retail Sale Id 6009',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 17:52:34','',''),(6051,'21','227','1',1,'Retail Sale Id 6010',995.60,0.00,0.00,1.31,0.00,'2022-08-09 17:53:11','',''),(6052,'21','227','1',1,'Retail Sale Id 6012',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 17:53:57','',''),(6053,'21','227','1',1,'Retail Sale Id 6013',1504.80,0.00,0.00,1.98,0.00,'2022-08-09 18:00:05','',''),(6054,'21','227','1',1,'Retail Sale Id 6015',1003.20,0.00,0.00,1.32,0.00,'2022-08-09 18:01:11','',''),(6055,'21','227','1',1,'Retail Sale Id 6016',1497.20,0.00,0.00,1.97,0.00,'2022-08-09 18:02:36','',''),(6056,'21','227','1',1,'Retail Sale Id 6017',1003.20,0.00,0.00,1.32,0.00,'2022-08-09 18:03:38','',''),(6057,'21','227','1',1,'Retail Sale Id 6018',2006.40,0.00,0.00,2.64,0.00,'2022-08-09 18:04:22','',''),(6058,'21','227','1',1,'Retail Sale Id 6019',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 18:05:27','',''),(6059,'21','227','1',1,'Retail Sale Id 6011',995.60,0.00,0.00,1.31,0.00,'2022-08-09 18:06:20','',''),(6060,'21','227','1',1,'Retail Sale Id 6020',40743.60,0.00,0.00,53.61,0.00,'2022-08-09 19:23:34','',''),(6061,'21','227','1',1,'Retail Sale Id 6021',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 07:45:26','',''),(6062,'21','227','1',1,'Retail Sale Id 6022',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 07:47:29','',''),(6063,'21','227','1',1,'Retail Sale Id 6023',7995.20,0.00,0.00,10.52,0.00,'2022-08-10 07:55:11','',''),(6064,'21','227','1',1,'Retail Sale Id 6024',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 07:56:08','',''),(6065,'21','227','1',1,'Retail Sale Id 6025',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 07:58:25','',''),(6066,'21','227','1',1,'Retail Sale Id 6026',1497.20,0.00,0.00,1.97,0.00,'2022-08-10 08:10:46','',''),(6067,'21','227','1',1,'Retail Sale Id 6027',2280.00,0.00,0.00,3.00,0.00,'2022-08-10 08:15:19','',''),(6068,'21','227','1',1,'Retail Sale Id 6028',2492.80,0.00,0.00,3.28,0.00,'2022-08-10 08:24:52','',''),(6069,'21','227','1',1,'Retail Sale Id 6029',995.60,0.00,0.00,1.31,0.00,'2022-08-10 08:37:28','',''),(6070,'21','227','1',1,'Retail Sale Id 6030',3800.00,0.00,0.00,5.00,0.00,'2022-08-10 08:38:31','',''),(6071,'21','227','1',1,'Retail Sale Id 6031',2492.80,0.00,0.00,3.28,0.00,'2022-08-10 08:40:31','',''),(6072,'21','227','1',1,'Retail Sale Id 6032',4993.20,0.00,0.00,6.57,0.00,'2022-08-10 08:51:24','',''),(6073,'21','227','1',1,'Retail Sale Id 6033',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 08:54:21','',''),(6074,'21','227','1',1,'Retail Sale Id 6034',995.60,0.00,0.00,1.31,0.00,'2022-08-10 08:55:52','',''),(6075,'21','227','1',1,'Retail Sale Id 6035',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 09:02:44','',''),(6076,'21','227','1',1,'Retail Sale Id 6036',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 09:35:09','',''),(6077,'21','227','1',1,'Retail Sale Id 6037',4993.20,0.00,0.00,6.57,0.00,'2022-08-10 09:35:47','',''),(6078,'21','227','1',1,'Retail Sale Id 6038',2280.00,0.00,0.00,3.00,0.00,'2022-08-10 09:40:02','',''),(6079,'21','227','1',1,'Retail Sale Id 6039',7600.00,0.00,0.00,10.00,0.00,'2022-08-10 09:40:44','',''),(6080,'21','227','1',1,'Retail Sale Id 6040',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 09:41:38','',''),(6081,'21','227','1',1,'Retail Sale Id 6041',2280.00,0.00,0.00,3.00,0.00,'2022-08-10 09:42:19','',''),(6082,'21','227','1',1,'Retail Sale Id 6042',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 09:48:07','',''),(6083,'21','227','1',1,'Retail Sale Id 6043',2196.40,0.00,0.00,2.89,0.00,'2022-08-10 09:49:20','',''),(6084,'21','227','1',1,'Retail Sale Id 6044',4499.20,0.00,0.00,5.92,0.00,'2022-08-10 10:05:50','',''),(6085,'21','227','1',1,'Retail Sale Id 6045',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 10:06:50','',''),(6086,'21','227','1',1,'Retail Sale Id 6046',5996.40,0.00,0.00,7.89,0.00,'2022-08-10 10:12:21','',''),(6087,'21','227','1',1,'Retail Sale Id 6047',8496.80,0.00,0.00,11.18,0.00,'2022-08-10 10:23:25','',''),(6088,'21','227','1',1,'Retail Sale Id 6048',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 10:24:23','',''),(6089,'21','227','1',1,'Retail Sale Id 6049',2492.80,0.00,0.00,3.28,0.00,'2022-08-10 10:25:11','',''),(6090,'21','227','1',1,'Retail Sale Id 6050',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 10:26:07','',''),(6091,'21','227','1',1,'Retail Sale Id 6051',8360.00,0.00,0.00,11.00,0.00,'2022-08-10 10:26:58','',''),(6092,'21','227','1',1,'Retail Sale Id 6052',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 10:31:29','',''),(6093,'21','227','1',1,'Retail Sale Id 6053',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 10:32:13','',''),(6094,'21','227','1',1,'Retail Sale Id 6054',4993.20,0.00,0.00,6.57,0.00,'2022-08-10 10:37:01','',''),(6095,'21','227','1',1,'Retail Sale Id 6055',3997.60,0.00,0.00,5.26,0.00,'2022-08-10 10:37:46','',''),(6096,'21','227','1',1,'Retail Sale Id 6056',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 10:38:20','',''),(6097,'21','227','1',1,'Retail Sale Id 6057',1497.20,0.00,0.00,1.97,0.00,'2022-08-10 10:43:29','',''),(6098,'21','227','1',1,'Retail Sale Id 6058',4993.20,0.00,0.00,6.57,0.00,'2022-08-10 10:47:53','',''),(6099,'21','227','1',1,'Retail Sale Id 6059',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 10:51:25','',''),(6100,'21','227','1',1,'Retail Sale Id 6060',2295.20,0.00,0.00,3.02,0.00,'2022-08-10 10:52:04','',''),(6101,'21','227','1',1,'Retail Sale Id 6062',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 11:07:00','',''),(6102,'21','227','1',1,'Retail Sale Id 6063',85500.00,0.00,0.00,112.50,0.00,'2022-08-10 11:08:24','',''),(6103,'21','227','1',1,'Retail Sale Id 6064',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 11:09:04','',''),(6104,'21','227','1',1,'Retail Sale Id 6065',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 11:09:38','',''),(6105,'21','227','1',1,'Retail Sale Id 6066',12160.00,0.00,0.00,16.00,0.00,'2022-08-10 11:15:15','',''),(6106,'21','227','1',1,'Retail Sale Id 6067',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 11:15:57','',''),(6107,'21','227','1',1,'Retail Sale Id 6068',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 11:16:50','',''),(6108,'21','227','1',1,'Retail Sale Id 6069',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 11:17:34','',''),(6109,'21','227','1',1,'Retail Sale Id 6070',4993.20,0.00,0.00,6.57,0.00,'2022-08-10 11:27:44','',''),(6110,'21','227','1',1,'Retail Sale Id 6071',4499.20,0.00,0.00,5.92,0.00,'2022-08-10 11:28:40','',''),(6111,'21','227','1',1,'Retail Sale Id 6072',3496.00,0.00,0.00,4.60,0.00,'2022-08-10 12:01:49','',''),(6112,'21','227','1',1,'Retail Sale Id 6073',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 12:03:19','',''),(6113,'21','227','1',1,'Retail Sale Id 6074',4993.20,0.00,0.00,6.57,0.00,'2022-08-10 12:10:01','',''),(6114,'21','227','1',1,'Retail Sale Id 6075',2280.00,0.00,0.00,3.00,0.00,'2022-08-10 12:17:10','',''),(6115,'21','227','1',1,'Retail Sale Id 6076',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 12:23:37','',''),(6116,'21','227','1',1,'Retail Sale Id 6077',798.00,0.00,0.00,1.05,0.00,'2022-08-10 12:26:11','',''),(6117,'21','227','1',1,'Retail Sale Id 6078',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 12:36:52','',''),(6118,'21','227','1',1,'Retail Sale Id 6079',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 12:44:08','',''),(6119,'21','227','1',1,'Retail Sale Id 6080',8360.00,0.00,0.00,11.00,0.00,'2022-08-10 12:45:07','',''),(6120,'21','227','1',1,'Retail Sale Id 6081',2492.80,0.00,0.00,3.28,0.00,'2022-08-10 12:48:35','',''),(6121,'21','227','1',1,'Retail Sale Id 6082',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 12:49:34','',''),(6122,'21','227','1',1,'Retail Sale Id 6083',3800.00,0.00,0.00,5.00,0.00,'2022-08-10 12:56:32','',''),(6123,'21','227','1',1,'Retail Sale Id 6084',4499.20,0.00,0.00,5.92,0.00,'2022-08-10 12:57:13','',''),(6124,'21','227','1',1,'Retail Sale Id 6085',2280.00,0.00,0.00,3.00,0.00,'2022-08-10 13:01:06','',''),(6125,'21','227','1',1,'Retail Sale Id 6086',7995.20,0.00,0.00,10.52,0.00,'2022-08-10 13:03:37','',''),(6126,'21','227','1',1,'Retail Sale Id 6087',2280.00,0.00,0.00,3.00,0.00,'2022-08-10 13:04:14','',''),(6127,'21','227','1',1,'Retail Sale Id 6088',3800.00,0.00,0.00,5.00,0.00,'2022-08-10 13:16:34','',''),(6128,'21','227','1',1,'Retail Sale Id 6089',1497.20,0.00,0.00,1.97,0.00,'2022-08-10 13:17:32','',''),(6129,'21','227','1',1,'Retail Sale Id 6090',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 13:20:09','',''),(6130,'21','227','1',1,'Retail Sale Id 6091',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 13:24:07','',''),(6131,'21','227','1',1,'Retail Sale Id 6092',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 13:26:18','',''),(6132,'21','227','1',1,'Retail Sale Id 6093',3997.60,0.00,0.00,5.26,0.00,'2022-08-10 13:40:56','',''),(6133,'21','227','1',1,'Retail Sale Id 6094',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 14:10:36','',''),(6134,'21','227','1',1,'Retail Sale Id 6095',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 14:11:41','',''),(6135,'21','227','1',1,'Retail Sale Id 6096',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 14:12:27','',''),(6136,'21','227','1',1,'Retail Sale Id 6097',3800.00,0.00,0.00,5.00,0.00,'2022-08-10 14:16:49','',''),(6137,'21','227','1',1,'Retail Sale Id 6098',2492.80,0.00,0.00,3.28,0.00,'2022-08-10 14:21:37','',''),(6138,'21','227','1',1,'Retail Sale Id 6099',2492.80,0.00,0.00,3.28,0.00,'2022-08-10 14:23:53','',''),(6139,'21','227','1',1,'Retail Sale Id 6100',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 14:34:13','',''),(6140,'21','227','1',1,'Retail Sale Id 6101',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 14:47:16','',''),(6141,'21','227','1',1,'Retail Sale Id 6102',995.60,0.00,0.00,1.31,0.00,'2022-08-10 15:00:13','',''),(6142,'21','227','1',1,'Retail Sale Id 6103',2994.40,0.00,0.00,3.94,0.00,'2022-08-10 15:08:41','',''),(6143,'21','227',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,2000.00,0.00,'2022-08-10 15:30:28','',''),(6144,'21','227','1',1,'Received from bridging 15',0.00,0.00,2000.00,0.00,0.00,'2022-08-10 15:30:28','',''),(6145,'21','227','1',1,'Retail Sale Id 6107',760.00,0.00,0.00,1.00,0.00,'2022-08-10 15:31:56','',''),(6146,'21','227','1',1,'Retail Sale Id 6108',4993.20,0.00,0.00,6.57,0.00,'2022-08-10 15:35:06','',''),(6147,'21','227','1',1,'Retail Sale Id 6109',4499.20,0.00,0.00,5.92,0.00,'2022-08-10 15:46:15','',''),(6148,'21','227','1',1,'Retail Sale Id 6106',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 16:09:09','',''),(6149,'21','227','1',1,'Retail Sale Id 6105',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 16:09:50','',''),(6150,'21','227','1',1,'Retail Sale Id 6110',7600.00,0.00,0.00,10.00,0.00,'2022-08-10 16:15:27','',''),(6151,'21','227','1',1,'Retail Sale Id 6111',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 16:17:12','',''),(6152,'21','227','1',1,'Retail Sale Id 6112',7600.00,0.00,0.00,10.00,0.00,'2022-08-10 16:30:54','',''),(6153,'21','227','1',1,'Retail Sale Id 6113',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 16:59:00','',''),(6154,'21','227','1',1,'Retail Sale Id 6114',7600.00,0.00,0.00,10.00,0.00,'2022-08-10 16:59:43','',''),(6155,'21','227','1',1,'Retail Sale Id 6115',995.60,0.00,0.00,1.31,0.00,'2022-08-10 17:00:31','',''),(6156,'21','227','1',1,'Retail Sale Id 6116',1998.80,0.00,0.00,2.63,0.00,'2022-08-10 17:01:14','',''),(6157,'21','227','1',1,'Retail Sale Id 6117',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 17:08:54','',''),(6158,'21','227','1',1,'Retail Sale Id 6118',3800.00,0.00,0.00,5.00,0.00,'2022-08-10 17:09:29','',''),(6159,'21','227','1',1,'Retail Sale Id 6119',1497.20,0.00,0.00,1.97,0.00,'2022-08-10 17:25:45','',''),(6160,'21','227','1',1,'Retail Sale Id 6120',7600.00,0.00,0.00,10.00,0.00,'2022-08-10 17:53:39','',''),(6161,'21','227','1',1,'Retail Sale Id 6121',65968.00,0.00,0.00,86.80,0.00,'2022-08-10 19:24:18','',''),(6162,'21','227','1',1,'Retail Sale Id 6104',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 19:27:32','',''),(6163,'21','227','1',1,'Retail Sale Id 6061',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 19:28:44','',''),(6164,'21','227','1',1,'Retail Sale Id 6122',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 10:42:45','',''),(6165,'21','227','1',1,'Retail Sale Id 6123',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 10:43:24','',''),(6166,'21','227','1',1,'Retail Sale Id 6124',3496.00,0.00,0.00,4.60,0.00,'2022-08-11 10:44:04','',''),(6167,'21','227','1',1,'Retail Sale Id 6125',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 10:44:57','',''),(6168,'21','227','1',1,'Retail Sale Id 6126',995.60,0.00,0.00,1.31,0.00,'2022-08-11 10:48:25','',''),(6169,'21','227','1',1,'Retail Sale Id 6127',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 11:03:24','',''),(6170,'21','227','1',1,'Retail Sale Id 6128',3997.60,0.00,0.00,5.26,0.00,'2022-08-11 11:04:08','',''),(6171,'21','227','1',1,'Retail Sale Id 6129',1520.00,0.00,0.00,2.00,0.00,'2022-08-11 11:06:28','',''),(6172,'21','227','1',1,'Retail Sale Id 6130',5996.40,0.00,0.00,7.89,0.00,'2022-08-11 12:12:59','',''),(6173,'21','227','1',1,'Retail Sale Id 6131',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 12:16:59','',''),(6174,'21','227','1',1,'Retail Sale Id 6132',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 12:18:28','',''),(6175,'21','227','1',1,'Retail Sale Id 6133',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 12:24:22','',''),(6176,'21','227','1',1,'Retail Sale Id 6134',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 12:25:28','',''),(6177,'21','227','1',1,'Retail Sale Id 6135',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 12:29:37','',''),(6178,'21','227','1',1,'Retail Sale Id 6136',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 12:30:35','',''),(6179,'21','227','1',1,'Retail Sale Id 6137',4598.00,0.00,0.00,6.05,0.00,'2022-08-11 12:32:17','',''),(6180,'21','227','1',1,'Retail Sale Id 6138',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 12:33:30','',''),(6181,'21','227','1',1,'Retail Sale Id 6139',1497.20,0.00,0.00,1.97,0.00,'2022-08-11 12:34:39','',''),(6182,'21','227','1',1,'Retail Sale Id 6140',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 12:52:56','',''),(6183,'21','227','1',1,'Retail Sale Id 6141',4499.20,0.00,0.00,5.92,0.00,'2022-08-11 12:53:34','',''),(6184,'21','227','1',1,'Retail Sale Id 6142',4499.20,0.00,0.00,5.92,0.00,'2022-08-11 12:54:16','',''),(6185,'21','227','1',1,'Retail Sale Id 6143',995.60,0.00,0.00,1.31,0.00,'2022-08-11 12:54:55','',''),(6186,'21','227','1',1,'Retail Sale Id 6144',4993.20,0.00,0.00,6.57,0.00,'2022-08-11 12:55:34','',''),(6187,'21','227','1',1,'Retail Sale Id 6145',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 12:58:44','',''),(6188,'21','227','1',1,'Retail Sale Id 6146',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 12:59:25','',''),(6189,'21','227','1',1,'Retail Sale Id 6147',7600.00,0.00,0.00,10.00,0.00,'2022-08-11 13:00:08','',''),(6190,'21','227','1',1,'Retail Sale Id 6148',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 13:29:19','',''),(6191,'21','227','1',1,'Retail Sale Id 6149',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 13:30:59','',''),(6192,'21','227','1',1,'Retail Sale Id 6150',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 13:39:27','',''),(6193,'21','227','1',1,'Retail Sale Id 6151',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 13:41:38','',''),(6194,'21','227','1',1,'Retail Sale Id 6152',4993.20,0.00,0.00,6.57,0.00,'2022-08-11 13:51:11','',''),(6195,'21','227','1',1,'Retail Sale Id 6153',1520.00,0.00,0.00,2.00,0.00,'2022-08-11 13:55:14','',''),(6196,'21','227','1',1,'Retail Sale Id 6154',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 14:01:16','',''),(6197,'21','227','1',1,'Retail Sale Id 6155',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 14:02:44','',''),(6198,'21','227','1',1,'Retail Sale Id 6156',3093.20,0.00,0.00,4.07,0.00,'2022-08-11 14:03:25','',''),(6199,'21','227','1',1,'Retail Sale Id 6157',2994.40,0.00,0.00,3.94,0.00,'2022-08-11 14:06:14','',''),(6200,'21','227','1',1,'Retail Sale Id 6158',1497.20,0.00,0.00,1.97,0.00,'2022-08-11 14:07:45','',''),(6201,'21','227','1',1,'Retail Sale Id 6159',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 14:31:34','',''),(6202,'21','227','1',1,'Retail Sale Id 6160',7600.00,0.00,0.00,10.00,0.00,'2022-08-11 14:32:26','',''),(6203,'21','227','1',1,'Retail Sale Id 6161',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 14:33:26','',''),(6204,'21','227','1',1,'Retail Sale Id 6162',1497.20,0.00,0.00,1.97,0.00,'2022-08-11 14:36:33','',''),(6205,'21','227','1',1,'Retail Sale Id 6163',7600.00,0.00,0.00,10.00,0.00,'2022-08-11 14:50:41','',''),(6206,'21','227','1',1,'Retail Sale Id 6164',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 15:03:20','',''),(6207,'21','227','1',1,'Retail Sale Id 6165',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 15:09:20','',''),(6208,'21','227','1',1,'Retail Sale Id 6166',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 15:15:11','',''),(6209,'21','227','1',1,'Retail Sale Id 6167',1520.00,0.00,0.00,2.00,0.00,'2022-08-11 15:18:47','',''),(6210,'21','227','1',1,'Retail Sale Id 6168',1520.00,0.00,0.00,2.00,0.00,'2022-08-11 15:23:22','',''),(6211,'21','227','1',1,'Retail Sale Id 6169',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 15:27:09','',''),(6212,'21','227','1',1,'Retail Sale Id 6170',798.00,0.00,0.00,1.05,0.00,'2022-08-11 15:30:40','',''),(6213,'21','227','1',1,'Retail Sale Id 6171',5996.40,0.00,0.00,7.89,0.00,'2022-08-11 15:32:04','',''),(6214,'21','227','1',1,'Retail Sale Id 6172',995.60,0.00,0.00,1.31,0.00,'2022-08-11 15:37:27','',''),(6215,'21','227','1',1,'Retail Sale Id 6173',494.00,0.00,0.00,0.65,0.00,'2022-08-11 15:40:00','',''),(6216,'21','227','1',1,'Retail Sale Id 6174',995.60,0.00,0.00,1.31,0.00,'2022-08-11 15:40:48','',''),(6217,'21','227','1',1,'Retail Sale Id 6175',5320.00,0.00,0.00,7.00,0.00,'2022-08-11 15:46:06','',''),(6218,'21','227','1',1,'Retail Sale Id 6177',995.60,0.00,0.00,1.31,0.00,'2022-08-11 15:47:38','',''),(6219,'21','227','1',1,'Retail Sale Id 6178',1140.00,0.00,0.00,1.50,0.00,'2022-08-11 15:48:18','',''),(6220,'21','227','1',1,'Retail Sale Id 6179',2280.00,0.00,0.00,3.00,0.00,'2022-08-11 15:48:50','',''),(6221,'21','227','1',1,'Retail Sale Id 6180',699.20,0.00,0.00,0.92,0.00,'2022-08-11 15:50:05','',''),(6222,'21','227','1',1,'Retail Sale Id 6181',2280.00,0.00,0.00,3.00,0.00,'2022-08-11 15:52:17','',''),(6223,'21','227','1',1,'Retail Sale Id 6182',2006.40,0.00,0.00,2.64,0.00,'2022-08-11 16:16:46','',''),(6224,'21','227','1',1,'Retail Sale Id 6183',904.40,0.00,0.00,1.19,0.00,'2022-08-11 16:19:52','',''),(6225,'21','227','1',1,'Retail Sale Id 6184',1694.80,0.00,0.00,2.23,0.00,'2022-08-11 16:20:54','',''),(6226,'21','227','1',1,'Retail Sale Id 6185',494.00,0.00,0.00,0.65,0.00,'2022-08-11 16:21:41','',''),(6227,'21','227','1',1,'Retail Sale Id 6186',1504.80,0.00,0.00,1.98,0.00,'2022-08-11 16:22:24','',''),(6228,'21','227','1',1,'Retail Sale Id 6187',805.60,0.00,0.00,1.06,0.00,'2022-08-11 16:28:34','',''),(6229,'21','227','1',1,'Retail Sale Id 6188',2280.00,0.00,0.00,3.00,0.00,'2022-08-11 16:30:45','',''),(6230,'21','227','1',1,'Retail Sale Id 6189',995.60,0.00,0.00,1.31,0.00,'2022-08-11 16:34:18','',''),(6231,'21','227','1',1,'Retail Sale Id 6190',995.60,0.00,0.00,1.31,0.00,'2022-08-11 16:38:59','',''),(6232,'21','227','1',1,'Retail Sale Id 6191',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 16:43:20','',''),(6233,'21','227','1',1,'Retail Sale Id 6192',798.00,0.00,0.00,1.05,0.00,'2022-08-11 16:43:59','',''),(6234,'21','227','1',1,'Retail Sale Id 6193',2994.40,0.00,0.00,3.94,0.00,'2022-08-11 16:44:36','',''),(6235,'21','227','1',1,'Retail Sale Id 6194',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 16:45:09','',''),(6236,'21','227','1',1,'Retail Sale Id 6195',2994.40,0.00,0.00,3.94,0.00,'2022-08-11 16:45:45','',''),(6237,'21','227','1',1,'Retail Sale Id 6196',1003.20,0.00,0.00,1.32,0.00,'2022-08-11 16:46:39','',''),(6238,'21','227','1',1,'Retail Sale Id 6197',7995.20,0.00,0.00,10.52,0.00,'2022-08-11 16:47:51','',''),(6239,'21','227','1',1,'Retail Sale Id 6198',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 16:48:45','',''),(6240,'21','227','1',1,'Retail Sale Id 6199',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 16:49:31','',''),(6241,'21','227','1',1,'Retail Sale Id 6200',805.60,0.00,0.00,1.06,0.00,'2022-08-11 16:50:27','',''),(6242,'21','227','1',1,'Retail Sale Id 6201',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 16:51:24','',''),(6243,'21','227','1',1,'Retail Sale Id 6202',2006.40,0.00,0.00,2.64,0.00,'2022-08-11 16:55:00','',''),(6244,'21','227','1',1,'Retail Sale Id 6203',995.60,0.00,0.00,1.31,0.00,'2022-08-11 16:57:38','',''),(6245,'21','227','1',1,'Retail Sale Id 6205',1003.20,0.00,0.00,1.32,0.00,'2022-08-11 17:00:03','',''),(6246,'21','227','1',1,'Retail Sale Id 6206',995.60,0.00,0.00,1.31,0.00,'2022-08-11 17:05:06','',''),(6247,'21','227','1',1,'Retail Sale Id 6207',1003.20,0.00,0.00,1.32,0.00,'2022-08-11 17:08:13','',''),(6248,'21','227','1',1,'Retail Sale Id 6208',2006.40,0.00,0.00,2.64,0.00,'2022-08-11 17:12:38','',''),(6249,'21','227','1',1,'Retail Sale Id 6209',2006.40,0.00,0.00,2.64,0.00,'2022-08-11 17:13:16','',''),(6250,'21','227','1',1,'Retail Sale Id 6210',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 17:13:59','',''),(6251,'21','227','1',1,'Retail Sale Id 6211',2492.80,0.00,0.00,3.28,0.00,'2022-08-11 17:14:46','',''),(6252,'21','227','1',1,'Retail Sale Id 6212',995.60,0.00,0.00,1.31,0.00,'2022-08-11 17:15:17','',''),(6253,'21','227','1',1,'Retail Sale Id 6213',2006.40,0.00,0.00,2.64,0.00,'2022-08-11 17:15:51','',''),(6254,'21','227','1',1,'Retail Sale Id 6214',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 17:17:20','',''),(6255,'21','227','1',1,'Retail Sale Id 6215',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 17:19:01','',''),(6256,'21','227','1',1,'Retail Sale Id 6216',1003.20,0.00,0.00,1.32,0.00,'2022-08-11 17:23:39','',''),(6257,'21','227','1',1,'Retail Sale Id 6217',2006.40,0.00,0.00,2.64,0.00,'2022-08-11 17:24:23','',''),(6258,'21','227','1',1,'Retail Sale Id 6218',3997.60,0.00,0.00,5.26,0.00,'2022-08-11 17:25:27','',''),(6259,'21','227','1',1,'Retail Sale Id 6219',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 17:28:20','',''),(6260,'21','227','1',1,'Retail Sale Id 6220',1520.00,0.00,0.00,2.00,0.00,'2022-08-11 17:32:18','',''),(6261,'21','227','1',1,'Retail Sale Id 6221',4750.00,0.00,0.00,6.25,0.00,'2022-08-11 17:35:08','',''),(6262,'21','227','1',1,'Retail Sale Id 6222',995.60,0.00,0.00,1.31,0.00,'2022-08-11 17:36:30','',''),(6263,'21','227','1',1,'Retail Sale Id 6223',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 17:37:20','',''),(6264,'21','227','1',1,'Retail Sale Id 6224',995.60,0.00,0.00,1.31,0.00,'2022-08-11 17:41:50','',''),(6265,'21','227','1',1,'Retail Sale Id 6224',1504.80,0.00,0.00,1.98,0.00,'2022-08-11 17:41:50','',''),(6266,'21','227','1',1,'Retail Sale Id 6225',3997.60,0.00,0.00,5.26,0.00,'2022-08-11 17:45:06','',''),(6267,'21','227','1',1,'Retail Sale Id 6226',798.00,0.00,0.00,1.05,0.00,'2022-08-11 17:48:08','',''),(6268,'21','227','1',1,'Retail Sale Id 6227',1003.20,0.00,0.00,1.32,0.00,'2022-08-11 17:53:05','',''),(6269,'21','227','1',1,'Retail Sale Id 6228',2500.40,0.00,0.00,3.29,0.00,'2022-08-11 17:55:15','',''),(6270,'21','227','1',1,'Retail Sale Id 6229',2006.40,0.00,0.00,2.64,0.00,'2022-08-11 17:59:58','',''),(6271,'21','227','1',1,'Retail Sale Id 6230',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 18:00:35','',''),(6272,'21','227','1',1,'Retail Sale Id 6231',760.00,0.00,0.00,1.00,0.00,'2022-08-11 18:01:54','',''),(6273,'21','227','1',1,'Retail Sale Id 6232',2280.00,0.00,0.00,3.00,0.00,'2022-08-11 18:02:31','',''),(6274,'21','227','1',1,'Retail Sale Id 6233',4005.20,0.00,0.00,5.27,0.00,'2022-08-11 18:03:07','',''),(6275,'21','227','1',1,'Retail Sale Id 6234',2492.80,0.00,0.00,3.28,0.00,'2022-08-11 18:06:40','',''),(6276,'21','227','1',1,'Retail Sale Id 6235',46147.20,0.00,0.00,60.72,0.00,'2022-08-12 05:51:09','',''),(6277,'21','227','1',1,'Retail Sale Id 6236',3997.60,0.00,0.00,5.26,0.00,'2022-08-12 07:58:38','',''),(6278,'21','227','1',1,'Retail Sale Id 6237',1193.20,0.00,0.00,1.57,0.00,'2022-08-12 08:00:27','',''),(6279,'21','227','1',1,'Retail Sale Id 6238',1193.20,0.00,0.00,1.57,0.00,'2022-08-12 08:02:08','',''),(6280,'21','227','1',1,'Retail Sale Id 6239',1497.20,0.00,0.00,1.97,0.00,'2022-08-12 08:19:24','',''),(6281,'21','227','1',1,'Retail Sale Id 6240',2295.20,0.00,0.00,3.02,0.00,'2022-08-12 08:28:22','',''),(6282,'21','227','1',1,'Retail Sale Id 6241',1520.00,0.00,0.00,2.00,0.00,'2022-08-12 08:33:22','',''),(6283,'21','227','1',1,'Retail Sale Id 6242',3093.20,0.00,0.00,4.07,0.00,'2022-08-12 08:38:52','',''),(6284,'21','227','1',1,'Retail Sale Id 6243',1497.20,0.00,0.00,1.97,0.00,'2022-08-12 08:43:39','',''),(6285,'21','227','1',1,'Retail Sale Id 6244',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 08:46:40','',''),(6286,'21','227','1',1,'Retail Sale Id 6245',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 08:48:42','',''),(6287,'21','227','1',1,'Retail Sale Id 6246',2280.00,0.00,0.00,3.00,0.00,'2022-08-12 08:52:18','',''),(6288,'21','227','1',1,'Retail Sale Id 6247',995.60,0.00,0.00,1.31,0.00,'2022-08-12 08:53:35','',''),(6289,'21','227','1',1,'Retail Sale Id 6248',2994.40,0.00,0.00,3.94,0.00,'2022-08-12 09:10:46','',''),(6290,'21','227','1',1,'Retail Sale Id 6249',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 09:13:19','',''),(6291,'21','227','1',1,'Retail Sale Id 6250',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 09:15:29','',''),(6292,'21','227','1',1,'Retail Sale Id 6251',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 09:27:58','',''),(6293,'21','227','1',1,'Retail Sale Id 6252',4993.20,0.00,0.00,6.57,0.00,'2022-08-12 09:35:07','',''),(6294,'21','227','1',1,'Retail Sale Id 6253',4294.00,0.00,0.00,5.65,0.00,'2022-08-12 09:56:01','',''),(6295,'21','227','1',1,'Retail Sale Id 6254',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 10:07:39','',''),(6296,'21','227','1',1,'Retail Sale Id 6255',995.60,0.00,0.00,1.31,0.00,'2022-08-12 10:09:33','',''),(6297,'21','227','1',1,'Retail Sale Id 6256',3997.60,0.00,0.00,5.26,0.00,'2022-08-12 10:12:37','',''),(6298,'21','227','1',1,'Retail Sale Id 6257',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 10:13:38','',''),(6299,'21','227','1',1,'Retail Sale Id 6258',896.80,0.00,0.00,1.18,0.00,'2022-08-12 10:14:27','',''),(6300,'21','227','1',1,'Retail Sale Id 6259',2280.00,0.00,0.00,3.00,0.00,'2022-08-12 10:22:32','',''),(6301,'21','227','1',1,'Retail Sale Id 6260',4993.20,0.00,0.00,6.57,0.00,'2022-08-12 10:47:08','',''),(6302,'21','227','1',1,'Retail Sale Id 6261',1497.20,0.00,0.00,1.97,0.00,'2022-08-12 10:48:26','',''),(6303,'21','227','1',1,'Retail Sale Id 6262',3800.00,0.00,0.00,5.00,0.00,'2022-08-12 10:53:43','',''),(6304,'21','227','1',1,'Retail Sale Id 6263',2994.40,0.00,0.00,3.94,0.00,'2022-08-12 10:56:51','',''),(6305,'21','227','1',1,'Retail Sale Id 6264',1497.20,0.00,0.00,1.97,0.00,'2022-08-12 11:16:28','',''),(6306,'21','227','1',1,'Retail Sale Id 6265',4499.20,0.00,0.00,5.92,0.00,'2022-08-12 11:18:34','',''),(6307,'21','227','1',1,'Retail Sale Id 6266',995.60,0.00,0.00,1.31,0.00,'2022-08-12 11:33:35','',''),(6308,'21','227','1',1,'Retail Sale Id 6267',1003.20,0.00,0.00,1.32,0.00,'2022-08-12 11:34:29','',''),(6309,'21','227','1',1,'Retail Sale Id 6268',1504.80,0.00,0.00,1.98,0.00,'2022-08-12 11:35:12','',''),(6310,'21','227','1',1,'Retail Sale Id 6269',4993.20,0.00,0.00,6.57,0.00,'2022-08-12 11:36:22','',''),(6311,'21','227','1',1,'Retail Sale Id 6270',2006.40,0.00,0.00,2.64,0.00,'2022-08-12 11:44:14','',''),(6312,'21','227','1',1,'Retail Sale Id 6271',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 11:50:20','',''),(6313,'21','227','1',1,'Retail Sale Id 6272',2280.00,0.00,0.00,3.00,0.00,'2022-08-12 11:51:10','',''),(6314,'21','227','1',1,'Retail Sale Id 6273',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 11:52:58','',''),(6315,'21','227','1',1,'Retail Sale Id 6274',3040.00,0.00,0.00,4.00,0.00,'2022-08-12 11:55:20','',''),(6316,'21','227','1',1,'Retail Sale Id 6275',7995.20,0.00,0.00,10.52,0.00,'2022-08-12 11:59:47','',''),(6317,'21','227','1',1,'Retail Sale Id 6276',2006.40,0.00,0.00,2.64,0.00,'2022-08-12 12:01:09','',''),(6318,'21','227','1',1,'Retail Sale Id 6277',699.20,0.00,0.00,0.92,0.00,'2022-08-12 12:02:39','',''),(6319,'21','227','1',1,'Retail Sale Id 6278',4506.80,0.00,0.00,5.93,0.00,'2022-08-12 12:05:41','',''),(6320,'21','227','1',1,'Retail Sale Id 6279',2280.00,0.00,0.00,3.00,0.00,'2022-08-12 12:08:31','',''),(6321,'21','227','1',1,'Retail Sale Id 6280',2994.40,0.00,0.00,3.94,0.00,'2022-08-12 12:10:13','',''),(6322,'21','227','1',1,'Retail Sale Id 6281',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 12:17:30','',''),(6323,'21','227','1',1,'Retail Sale Id 6282',3800.00,0.00,0.00,5.00,0.00,'2022-08-12 12:34:20','',''),(6324,'21','227','1',1,'Retail Sale Id 6283',3997.60,0.00,0.00,5.26,0.00,'2022-08-12 12:36:55','',''),(6325,'21','227','1',1,'Retail Sale Id 6284',1497.20,0.00,0.00,1.97,0.00,'2022-08-12 12:38:40','',''),(6326,'21','227','1',1,'Retail Sale Id 6285',1497.20,0.00,0.00,1.97,0.00,'2022-08-12 12:40:51','',''),(6327,'21','227','1',1,'Retail Sale Id 6286',2006.40,0.00,0.00,2.64,0.00,'2022-08-12 12:44:56','',''),(6328,'21','227','1',1,'Retail Sale Id 6287',1793.60,0.00,0.00,2.36,0.00,'2022-08-12 12:45:38','',''),(6329,'21','227','1',1,'Retail Sale Id 6288',995.60,0.00,0.00,1.31,0.00,'2022-08-12 12:50:04','',''),(6330,'21','227','1',1,'Retail Sale Id 6289',995.60,0.00,0.00,1.31,0.00,'2022-08-12 13:28:15','',''),(6331,'21','227','1',1,'Retail Sale Id 6290',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 13:55:51','',''),(6332,'21','227','1',1,'Retail Sale Id 6291',2280.00,0.00,0.00,3.00,0.00,'2022-08-12 14:15:45','',''),(6333,'21','227','1',1,'Retail Sale Id 6292',494.00,0.00,0.00,0.65,0.00,'2022-08-12 14:24:43','',''),(6334,'21','227','1',1,'Retail Sale Id 6293',3800.00,0.00,0.00,5.00,0.00,'2022-08-12 14:27:43','',''),(6335,'21','227','1',1,'Retail Sale Id 6294',3800.00,0.00,0.00,5.00,0.00,'2022-08-12 14:35:02','',''),(6336,'21','227','1',1,'Retail Sale Id 6295',494.00,0.00,0.00,0.65,0.00,'2022-08-12 14:36:08','',''),(6337,'21','227','1',1,'Retail Sale Id 6296',494.00,0.00,0.00,0.65,0.00,'2022-08-12 14:39:55','',''),(6338,'21','227','1',1,'Retail Sale Id 6297',8504.40,0.00,0.00,11.19,0.00,'2022-08-12 14:41:44','',''),(6339,'21','227','1',1,'Retail Sale Id 6298',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 14:46:56','',''),(6340,'21','227','1',1,'Retail Sale Id 6299',1398.40,0.00,0.00,1.84,0.00,'2022-08-12 14:50:39','',''),(6341,'21','227','1',1,'Retail Sale Id 6300',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 15:05:44','',''),(6342,'21','227','1',1,'Retail Sale Id 6301',798.00,0.00,0.00,1.05,0.00,'2022-08-12 15:11:58','',''),(6343,'21','227','1',1,'Retail Sale Id 6302',798.00,0.00,0.00,1.05,0.00,'2022-08-12 15:12:39','',''),(6344,'21','227','1',1,'Retail Sale Id 6303',2994.40,0.00,0.00,3.94,0.00,'2022-08-12 15:35:33','',''),(6345,'21','227','1',1,'Retail Sale Id 6304',2994.40,0.00,0.00,3.94,0.00,'2022-08-12 15:56:28','',''),(6346,'21','227','1',1,'Retail Sale Id 6305',1497.20,0.00,0.00,1.97,0.00,'2022-08-12 16:26:05','',''),(6347,'21','227','1',1,'Retail Sale Id 6306',2280.00,0.00,0.00,3.00,0.00,'2022-08-12 16:26:47','',''),(6348,'21','227','1',1,'Retail Sale Id 6307',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 16:28:38','',''),(6349,'21','227','1',1,'Retail Sale Id 6308',2796.80,0.00,0.00,3.68,0.00,'2022-08-12 16:29:29','',''),(6350,'21','227','1',1,'Retail Sale Id 6309',798.00,0.00,0.00,1.05,0.00,'2022-08-12 16:30:07','',''),(6351,'21','227','1',1,'Retail Sale Id 6310',2006.40,0.00,0.00,2.64,0.00,'2022-08-12 16:30:47','',''),(6352,'21','227','1',1,'Retail Sale Id 6311',798.00,0.00,0.00,1.05,0.00,'2022-08-12 16:31:31','',''),(6353,'21','227','1',1,'Retail Sale Id 6312',4993.20,0.00,0.00,6.57,0.00,'2022-08-12 16:35:07','',''),(6354,'21','227','1',1,'Retail Sale Id 6313',1497.20,0.00,0.00,1.97,0.00,'2022-08-12 16:37:35','',''),(6355,'21','227','1',1,'Retail Sale Id 6314',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 16:39:37','',''),(6356,'21','227','1',1,'Retail Sale Id 6315',2660.00,0.00,0.00,3.50,0.00,'2022-08-12 16:41:58','',''),(6357,'21','227','1',1,'Retail Sale Id 6316',4499.20,0.00,0.00,5.92,0.00,'2022-08-12 16:42:48','',''),(6358,'21','227','1',1,'Retail Sale Id 6317',3800.00,0.00,0.00,5.00,0.00,'2022-08-12 16:43:40','',''),(6359,'21','227','1',1,'Retail Sale Id 6318',1504.80,0.00,0.00,1.98,0.00,'2022-08-12 16:45:09','',''),(6360,'21','227','1',1,'Retail Sale Id 6319',3800.00,0.00,0.00,5.00,0.00,'2022-08-12 16:46:44','',''),(6361,'21','227','1',1,'Retail Sale Id 6320',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 16:50:36','',''),(6362,'21','227','1',1,'Retail Sale Id 6321',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 16:52:40','',''),(6363,'21','227','1',1,'Retail Sale Id 6321',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 16:52:40','',''),(6364,'21','227','1',1,'Retail Sale Id 6322',995.60,0.00,0.00,1.31,0.00,'2022-08-12 16:54:15','',''),(6365,'21','227','1',1,'Retail Sale Id 6323',494.00,0.00,0.00,0.65,0.00,'2022-08-12 16:55:02','',''),(6366,'21','227','1',1,'Retail Sale Id 6324',2994.40,0.00,0.00,3.94,0.00,'2022-08-12 17:02:37','',''),(6367,'21','227','1',1,'Retail Sale Id 6325',995.60,0.00,0.00,1.31,0.00,'2022-08-12 17:03:28','',''),(6368,'21','227','1',1,'Retail Sale Id 6326',4560.00,0.00,0.00,6.00,0.00,'2022-08-12 17:05:27','',''),(6369,'21','227','1',1,'Retail Sale Id 6327',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 17:06:14','',''),(6370,'21','227','1',1,'Retail Sale Id 6328',5000.80,0.00,0.00,6.58,0.00,'2022-08-12 17:07:13','',''),(6371,'21','227','1',1,'Retail Sale Id 6330',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 17:08:49','',''),(6372,'21','227','1',1,'Retail Sale Id 6331',2796.80,0.00,0.00,3.68,0.00,'2022-08-12 17:20:20','',''),(6373,'21','227','1',1,'Retail Sale Id 6333',2492.80,0.00,0.00,3.28,0.00,'2022-08-12 17:30:06','',''),(6374,'21','227','1',1,'Retail Sale Id 6335',1504.80,0.00,0.00,1.98,0.00,'2022-08-12 17:34:19','',''),(6375,'21','227','1',1,'Retail Sale Id 6336',4560.00,0.00,0.00,6.00,0.00,'2022-08-12 17:35:37','',''),(6376,'21','227','1',1,'Retail Sale Id 6337',2006.40,0.00,0.00,2.64,0.00,'2022-08-12 17:36:46','',''),(6377,'21','227','1',1,'Retail Sale Id 6338',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 17:37:57','',''),(6378,'21','227','1',1,'Retail Sale Id 6339',2492.80,0.00,0.00,3.28,0.00,'2022-08-12 17:42:40','',''),(6379,'21','227','1',1,'Retail Sale Id 6340',2280.00,0.00,0.00,3.00,0.00,'2022-08-12 17:43:33','',''),(6380,'21','227','1',1,'Retail Sale Id 6341',1003.20,0.00,0.00,1.32,0.00,'2022-08-12 17:44:15','',''),(6381,'21','227','1',1,'Retail Sale Id 6342',1003.20,0.00,0.00,1.32,0.00,'2022-08-12 17:46:07','',''),(6382,'21','227','1',1,'Retail Sale Id 6343',1520.00,0.00,0.00,2.00,0.00,'2022-08-12 17:47:29','',''),(6383,'21','227','1',1,'Retail Sale Id 6344',995.60,0.00,0.00,1.31,0.00,'2022-08-12 17:48:11','',''),(6384,'21','227','1',1,'Retail Sale Id 6345',4993.20,0.00,0.00,6.57,0.00,'2022-08-12 17:49:43','',''),(6385,'21','227','1',1,'Retail Sale Id 6346',1998.80,0.00,0.00,2.63,0.00,'2022-08-12 17:51:43','',''),(6386,'21','227','1',1,'Retail Sale Id 6346',2006.40,0.00,0.00,2.64,0.00,'2022-08-12 17:51:43','',''),(6387,'21','227','1',1,'Retail Sale Id 6347',5996.40,0.00,0.00,7.89,0.00,'2022-08-12 17:56:17','',''),(6388,'21','227','1',1,'Retail Sale Id 6348',2994.40,0.00,0.00,3.94,0.00,'2022-08-12 18:00:32','',''),(6389,'21','227','1',1,'Retail Sale Id 6332',2492.80,0.00,0.00,3.28,0.00,'2022-08-12 18:01:25','',''),(6390,'21','227','1',1,'Retail Sale Id 6334',2492.80,0.00,0.00,3.28,0.00,'2022-08-12 18:01:50','',''),(6391,'21','227','1',1,'Retail Sale Id 6349',23742.40,0.00,0.00,31.24,0.00,'2022-08-13 04:22:28','',''),(6392,'21','227','1',1,'Retail Sale Id 6350',45600.00,0.00,0.00,60.00,0.00,'2022-08-13 04:23:42','',''),(6393,'21','227','1',1,'Retail Sale Id 6351',30400.00,0.00,0.00,40.00,0.00,'2022-08-13 04:24:51','',''),(6394,'21','227','1',1,'Retail Sale Id 6329',5000.80,0.00,0.00,6.58,0.00,'2022-08-13 04:26:53','',''),(6395,'21','227','1',1,'Retail Sale Id 6352',2994.40,0.00,0.00,3.94,0.00,'2022-08-13 09:21:10','',''),(6396,'21','227','1',1,'Retail Sale Id 6353',1998.80,0.00,0.00,2.63,0.00,'2022-08-13 09:23:19','',''),(6397,'21','227','1',1,'Retail Sale Id 6354',9515.20,0.00,0.00,12.52,0.00,'2022-08-13 09:24:26','',''),(6398,'21','227','1',1,'Retail Sale Id 6355',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 09:25:17','',''),(6399,'21','227','1',1,'Retail Sale Id 6356',2994.40,0.00,0.00,3.94,0.00,'2022-08-13 09:26:34','',''),(6400,'21','227','1',1,'Retail Sale Id 6357',7600.00,0.00,0.00,10.00,0.00,'2022-08-13 09:29:06','',''),(6401,'21','227','1',1,'Retail Sale Id 6358',2280.00,0.00,0.00,3.00,0.00,'2022-08-13 09:30:19','',''),(6402,'21','227','1',1,'Retail Sale Id 6359',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:41:04','',''),(6403,'21','227','1',1,'Retail Sale Id 6362',2280.00,0.00,0.00,3.00,0.00,'2022-08-13 12:41:35','',''),(6404,'21','227','1',1,'Retail Sale Id 6363',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:45:45','',''),(6405,'21','227','1',1,'Retail Sale Id 6364',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 12:46:43','',''),(6406,'21','227','1',1,'Retail Sale Id 6365',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:48:41','',''),(6407,'21','227','1',1,'Retail Sale Id 6366',7600.00,0.00,0.00,10.00,0.00,'2022-08-13 12:49:12','',''),(6408,'21','227','1',1,'Retail Sale Id 6367',2994.40,0.00,0.00,3.94,0.00,'2022-08-13 12:49:51','',''),(6409,'21','227','1',1,'Retail Sale Id 6368',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:50:22','',''),(6410,'21','227','1',1,'Retail Sale Id 6369',7600.00,0.00,0.00,10.00,0.00,'2022-08-13 12:56:09','',''),(6411,'21','227','1',1,'Retail Sale Id 6370',2280.00,0.00,0.00,3.00,0.00,'2022-08-13 12:56:47','',''),(6412,'21','227','1',1,'Retail Sale Id 6371',3800.00,0.00,0.00,5.00,0.00,'2022-08-13 12:58:11','',''),(6413,'21','227','1',1,'Retail Sale Id 6372',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:58:47','',''),(6414,'21','227','1',1,'Retail Sale Id 6373',2994.40,0.00,0.00,3.94,0.00,'2022-08-13 12:59:31','',''),(6415,'21','227','1',1,'Retail Sale Id 6374',3800.00,0.00,0.00,5.00,0.00,'2022-08-13 13:00:05','',''),(6416,'21','227','1',1,'Retail Sale Id 6375',798.00,0.00,0.00,1.05,0.00,'2022-08-13 13:00:35','',''),(6417,'21','227','1',1,'Retail Sale Id 6361',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 13:01:31','',''),(6418,'21','227','1',1,'Retail Sale Id 6376',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 13:14:25','',''),(6419,'21','227','1',1,'Retail Sale Id 6377',45600.00,0.00,0.00,60.00,0.00,'2022-08-13 13:15:22','',''),(6420,'21','227','1',1,'Retail Sale Id 6379',2280.00,0.00,0.00,3.00,0.00,'2022-08-13 13:20:55','',''),(6421,'21','227','1',1,'Retail Sale Id 6380',7600.00,0.00,0.00,10.00,0.00,'2022-08-13 13:25:12','',''),(6422,'21','227','1',1,'Retail Sale Id 6381',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 13:28:50','',''),(6423,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-08-15 00:25:18','',''),(6424,'21','227',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,3000.00,0.00,'2022-08-15 00:27:05','',''),(6425,'21','227','1',1,'Received from bridging 16',0.00,0.00,3000.00,0.00,0.00,'2022-08-15 00:27:05','',''),(6426,'21','227','1',1,'Retail Sale Id 6382',995.60,0.00,0.00,1.31,0.00,'2022-08-15 09:52:45','',''),(6427,'21','227','1',1,'Retail Sale Id 6383',1497.20,0.00,0.00,1.97,0.00,'2022-08-15 09:55:41','',''),(6428,'21','227','1',1,'Retail Sale Id 6384',1497.20,0.00,0.00,1.97,0.00,'2022-08-15 09:56:15','',''),(6429,'21','227','1',1,'Retail Sale Id 6385',3496.00,0.00,0.00,4.60,0.00,'2022-08-15 09:58:27','',''),(6430,'21','227','1',1,'Retail Sale Id 6386',1520.00,0.00,0.00,2.00,0.00,'2022-08-15 10:00:01','',''),(6431,'21','227','1',1,'Retail Sale Id 6387',3800.00,0.00,0.00,5.00,0.00,'2022-08-15 10:02:53','',''),(6432,'21','227','1',1,'Retail Sale Id 6388',1998.80,0.00,0.00,2.63,0.00,'2022-08-15 10:05:50','',''),(6433,'21','227','1',1,'Retail Sale Id 6389',995.60,0.00,0.00,1.31,0.00,'2022-08-15 10:07:46','',''),(6434,'21','227','1',1,'Retail Sale Id 6391',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 10:09:02','',''),(6435,'21','227','1',1,'Retail Sale Id 6392',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 10:51:00','',''),(6436,'21','227','1',1,'Retail Sale Id 6393',2994.40,0.00,0.00,3.94,0.00,'2022-08-15 10:53:04','',''),(6437,'21','227','1',1,'Retail Sale Id 6394',7600.00,0.00,0.00,10.00,0.00,'2022-08-15 10:54:10','',''),(6438,'21','227','1',1,'Retail Sale Id 6396',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 10:54:45','',''),(6439,'21','227','1',1,'Retail Sale Id 6397',4993.20,0.00,0.00,6.57,0.00,'2022-08-15 10:55:19','',''),(6440,'21','227','1',1,'Retail Sale Id 6398',4560.00,0.00,0.00,6.00,0.00,'2022-08-15 11:12:05','',''),(6441,'21','227','1',1,'Retail Sale Id 6399',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 11:25:24','',''),(6442,'21','227','1',1,'Retail Sale Id 6402',5320.00,0.00,0.00,7.00,0.00,'2022-08-15 11:26:39','',''),(6443,'21','227','1',1,'Retail Sale Id 6401',5320.00,0.00,0.00,7.00,0.00,'2022-08-15 11:27:27','',''),(6444,'21','227','1',1,'Retail Sale Id 6403',2994.40,0.00,0.00,3.94,0.00,'2022-08-15 11:30:03','',''),(6445,'21','227','1',1,'Retail Sale Id 6404',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 11:32:53','',''),(6446,'21','227','1',1,'Retail Sale Id 6405',1520.00,0.00,0.00,2.00,0.00,'2022-08-15 11:33:56','',''),(6447,'21','227','1',1,'Retail Sale Id 6406',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 11:50:53','',''),(6448,'21','227','1',1,'Retail Sale Id 6407',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 11:51:33','',''),(6449,'21','227','1',1,'Retail Sale Id 6408',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 11:53:34','',''),(6450,'21','227','1',1,'Retail Sale Id 6409',1497.20,0.00,0.00,1.97,0.00,'2022-08-15 11:54:09','',''),(6451,'21','227','1',1,'Retail Sale Id 6410',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 14:55:45','',''),(6452,'21','227','1',1,'Retail Sale Id 6411',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 14:56:35','',''),(6453,'21','227','1',1,'Retail Sale Id 6412',7600.00,0.00,0.00,10.00,0.00,'2022-08-15 15:01:33','',''),(6454,'21','227','1',1,'Retail Sale Id 6413',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 15:03:15','',''),(6455,'21','227','1',1,'Retail Sale Id 6414',4560.00,0.00,0.00,6.00,0.00,'2022-08-15 15:03:54','',''),(6456,'21','227','1',1,'Retail Sale Id 6415',3800.00,0.00,0.00,5.00,0.00,'2022-08-15 15:05:36','',''),(6457,'21','227','1',1,'Retail Sale Id 6416',5996.40,0.00,0.00,7.89,0.00,'2022-08-15 15:06:32','',''),(6458,'21','227','1',1,'Retail Sale Id 6417',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 15:07:29','',''),(6459,'21','227','1',1,'Retail Sale Id 6418',1497.20,0.00,0.00,1.97,0.00,'2022-08-15 15:08:19','',''),(6460,'21','227','1',1,'Retail Sale Id 6419',11400.00,0.00,0.00,15.00,0.00,'2022-08-15 15:09:09','',''),(6461,'21','227','1',1,'Retail Sale Id 6420',6999.60,0.00,0.00,9.21,0.00,'2022-08-15 15:15:14','',''),(6462,'21','227','1',1,'Retail Sale Id 6421',995.60,0.00,0.00,1.31,0.00,'2022-08-15 15:16:12','',''),(6463,'21','227','1',1,'Retail Sale Id 6422',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 15:16:55','',''),(6464,'21','227','1',1,'Retail Sale Id 6423',2994.40,0.00,0.00,3.94,0.00,'2022-08-15 15:18:19','',''),(6465,'21','227','1',1,'Retail Sale Id 6424',7600.00,0.00,0.00,10.00,0.00,'2022-08-15 15:20:20','',''),(6466,'21','227','1',1,'Retail Sale Id 6425',19000.00,0.00,0.00,25.00,0.00,'2022-08-15 15:26:10','',''),(6467,'21','227','1',1,'Retail Sale Id 6426',995.60,0.00,0.00,1.31,0.00,'2022-08-15 15:29:15','',''),(6468,'21','227','1',1,'Retail Sale Id 6427',2280.00,0.00,0.00,3.00,0.00,'2022-08-15 15:30:01','',''),(6469,'21','227','1',1,'Retail Sale Id 6429',4560.00,0.00,0.00,6.00,0.00,'2022-08-15 15:33:28','',''),(6470,'21','227','1',1,'Retail Sale Id 6430',3040.00,0.00,0.00,4.00,0.00,'2022-08-15 15:37:22','',''),(6471,'21','227','1',1,'Retail Sale Id 6431',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 15:39:32','',''),(6472,'21','227','1',1,'Retail Sale Id 6432',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 15:46:10','',''),(6473,'21','227','1',1,'Retail Sale Id 6433',995.60,0.00,0.00,1.31,0.00,'2022-08-15 15:46:51','',''),(6474,'21','227','1',1,'Retail Sale Id 6434',1497.20,0.00,0.00,1.97,0.00,'2022-08-15 15:47:31','',''),(6475,'21','227','1',1,'Retail Sale Id 6435',2280.00,0.00,0.00,3.00,0.00,'2022-08-15 15:48:26','',''),(6476,'21','227','1',1,'Retail Sale Id 6436',3800.00,0.00,0.00,5.00,0.00,'2022-08-15 15:54:15','',''),(6477,'21','227','1',1,'Retail Sale Id 6437',4560.00,0.00,0.00,6.00,0.00,'2022-08-15 15:56:53','',''),(6478,'21','227','1',1,'Retail Sale Id 6438',5320.00,0.00,0.00,7.00,0.00,'2022-08-15 15:58:56','',''),(6479,'21','227','1',1,'Retail Sale Id 6439',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 17:34:56','',''),(6480,'21','227','1',1,'Retail Sale Id 6440',1497.20,0.00,0.00,1.97,0.00,'2022-08-15 17:35:46','',''),(6481,'21','227','1',1,'Retail Sale Id 6441',2280.00,0.00,0.00,3.00,0.00,'2022-08-15 17:36:54','',''),(6482,'21','227','1',1,'Retail Sale Id 6442',7600.00,0.00,0.00,10.00,0.00,'2022-08-15 17:37:36','',''),(6483,'21','227','1',1,'Retail Sale Id 6443',5996.40,0.00,0.00,7.89,0.00,'2022-08-15 17:38:10','',''),(6484,'21','227','1',1,'Retail Sale Id 6444',2994.40,0.00,0.00,3.94,0.00,'2022-08-15 17:38:57','',''),(6485,'21','227','1',1,'Retail Sale Id 6445',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 17:39:27','',''),(6486,'21','227','1',1,'Retail Sale Id 6446',6794.40,0.00,0.00,8.94,0.00,'2022-08-15 17:41:45','',''),(6487,'21','227','1',1,'Retail Sale Id 6447',19000.00,0.00,0.00,25.00,0.00,'2022-08-15 17:42:22','',''),(6488,'21','227','1',1,'Retail Sale Id 6448',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 17:42:57','',''),(6489,'21','227','1',1,'Retail Sale Id 6449',995.60,0.00,0.00,1.31,0.00,'2022-08-15 17:43:26','',''),(6490,'21','227','1',1,'Retail Sale Id 6450',5000.80,0.00,0.00,6.58,0.00,'2022-08-15 17:44:39','',''),(6491,'21','227','1',1,'Retail Sale Id 6451',1497.20,0.00,0.00,1.97,0.00,'2022-08-15 17:46:24','',''),(6492,'21','227','1',1,'Retail Sale Id 6452',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 17:47:21','',''),(6493,'21','227','1',1,'Retail Sale Id 6453',3040.00,0.00,0.00,4.00,0.00,'2022-08-15 17:49:18','',''),(6494,'21','227','1',1,'Retail Sale Id 6454',6999.60,0.00,0.00,9.21,0.00,'2022-08-15 17:50:14','',''),(6495,'21','227','1',1,'Retail Sale Id 6455',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 17:51:04','',''),(6496,'21','227','1',1,'Retail Sale Id 6456',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 17:55:33','',''),(6497,'21','227','1',1,'Retail Sale Id 6457',798.00,0.00,0.00,1.05,0.00,'2022-08-15 17:58:02','',''),(6498,'21','227','1',1,'Retail Sale Id 6458',2280.00,0.00,0.00,3.00,0.00,'2022-08-15 17:58:50','',''),(6499,'21','227','1',1,'Retail Sale Id 6459',9500.00,0.00,0.00,12.50,0.00,'2022-08-15 17:59:29','',''),(6500,'21','227','1',1,'Retail Sale Id 6460',1998.80,0.00,0.00,2.63,0.00,'2022-08-15 18:03:43','',''),(6501,'21','227','1',1,'Retail Sale Id 6461',19000.00,0.00,0.00,25.00,0.00,'2022-08-15 18:42:03','',''),(6502,'21','227','1',1,'Retail Sale Id 6462',7600.00,0.00,0.00,10.00,0.00,'2022-08-15 18:42:55','',''),(6503,'21','227','1',1,'Retail Sale Id 6463',9120.00,0.00,0.00,12.00,0.00,'2022-08-15 18:44:33','',''),(6504,'21','227','1',1,'Retail Sale Id 6464',896.80,0.00,0.00,1.18,0.00,'2022-08-16 10:21:02','',''),(6505,'21','227','1',1,'Retail Sale Id 6465',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 10:22:28','',''),(6506,'21','227','1',1,'Retail Sale Id 6466',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 10:25:27','',''),(6507,'21','227','1',1,'Retail Sale Id 6467',4993.20,0.00,0.00,6.57,0.00,'2022-08-16 10:25:55','',''),(6508,'21','227','1',1,'Retail Sale Id 6468',7600.00,0.00,0.00,10.00,0.00,'2022-08-16 10:26:38','',''),(6509,'21','227','1',1,'Retail Sale Id 6469',19000.00,0.00,0.00,25.00,0.00,'2022-08-16 10:27:50','',''),(6510,'21','227','1',1,'Retail Sale Id 6470',995.60,0.00,0.00,1.31,0.00,'2022-08-16 10:28:21','',''),(6511,'21','227','1',1,'Retail Sale Id 6471',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 10:28:53','',''),(6512,'21','227','1',1,'Retail Sale Id 6472',798.00,0.00,0.00,1.05,0.00,'2022-08-16 10:29:24','',''),(6513,'21','227','1',1,'Retail Sale Id 6473',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 10:31:55','',''),(6514,'21','227','1',1,'Retail Sale Id 6474',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 10:32:47','',''),(6515,'21','227','1',1,'Retail Sale Id 6475',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 10:33:46','',''),(6516,'21','227','1',1,'Retail Sale Id 6476',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 10:34:31','',''),(6517,'21','227','1',1,'Retail Sale Id 6477',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 10:35:15','',''),(6518,'21','227','1',1,'Retail Sale Id 6478',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 10:36:07','',''),(6519,'21','227','1',1,'Retail Sale Id 6479',4993.20,0.00,0.00,6.57,0.00,'2022-08-16 10:37:05','',''),(6520,'21','227','1',1,'Retail Sale Id 6480',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 10:38:10','',''),(6521,'21','227','1',1,'Retail Sale Id 6481',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 10:39:06','',''),(6522,'21','227','1',1,'Retail Sale Id 6482',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 10:40:18','',''),(6523,'21','227','1',1,'Retail Sale Id 6483',4993.20,0.00,0.00,6.57,0.00,'2022-08-16 10:40:49','',''),(6524,'21','227','1',1,'Retail Sale Id 6484',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 10:41:18','',''),(6525,'21','227','1',1,'Retail Sale Id 6485',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 10:41:44','',''),(6526,'21','227','1',1,'Retail Sale Id 6486',760.00,0.00,0.00,1.00,0.00,'2022-08-16 10:42:55','',''),(6527,'21','227','1',1,'Retail Sale Id 6487',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 10:43:38','',''),(6528,'21','227','1',1,'Retail Sale Id 6488',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 10:47:47','',''),(6529,'21','227','1',1,'Retail Sale Id 6489',4993.20,0.00,0.00,6.57,0.00,'2022-08-16 10:48:57','',''),(6530,'21','227','1',1,'Retail Sale Id 6490',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 10:49:46','',''),(6531,'21','227','1',1,'Retail Sale Id 6491',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 10:54:04','',''),(6532,'21','227','1',1,'Retail Sale Id 6492',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 10:56:02','',''),(6533,'21','227','1',1,'Retail Sale Id 6493',2994.40,0.00,0.00,3.94,0.00,'2022-08-16 11:01:48','',''),(6534,'21','227','1',1,'Retail Sale Id 6494',3496.00,0.00,0.00,4.60,0.00,'2022-08-16 11:03:32','',''),(6535,'21','227','1',1,'Retail Sale Id 6495',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 11:06:57','',''),(6536,'21','227','1',1,'Retail Sale Id 6496',995.60,0.00,0.00,1.31,0.00,'2022-08-16 11:08:32','',''),(6537,'21','227','1',1,'Retail Sale Id 6497',8496.80,0.00,0.00,11.18,0.00,'2022-08-16 11:11:17','',''),(6538,'21','227','1',1,'Retail Sale Id 6498',995.60,0.00,0.00,1.31,0.00,'2022-08-16 11:13:01','',''),(6539,'21','227','1',1,'Retail Sale Id 6499',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 11:17:10','',''),(6540,'21','227','1',1,'Retail Sale Id 6500',3040.00,0.00,0.00,4.00,0.00,'2022-08-16 11:19:49','',''),(6541,'21','227','1',1,'Retail Sale Id 6501',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 11:21:55','',''),(6542,'21','227','1',1,'Retail Sale Id 6502',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 11:25:11','',''),(6543,'21','227','1',1,'Retail Sale Id 6503',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 11:39:31','',''),(6544,'21','227','1',1,'Retail Sale Id 6504',760.00,0.00,0.00,1.00,0.00,'2022-08-16 11:43:57','',''),(6545,'21','227','1',1,'Retail Sale Id 6505',4993.20,0.00,0.00,6.57,0.00,'2022-08-16 11:47:59','',''),(6546,'21','227','1',1,'Retail Sale Id 6506',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 11:53:47','',''),(6547,'21','227','1',1,'Retail Sale Id 6507',2994.40,0.00,0.00,3.94,0.00,'2022-08-16 11:57:41','',''),(6548,'21','227','1',1,'Retail Sale Id 6508',4993.20,0.00,0.00,6.57,0.00,'2022-08-16 11:59:24','',''),(6549,'21','227','1',1,'Retail Sale Id 6509',1998.80,0.00,0.00,2.63,0.00,'2022-08-16 12:00:20','',''),(6550,'21','227','1',1,'Retail Sale Id 6510',3997.60,0.00,0.00,5.26,0.00,'2022-08-16 12:09:30','',''),(6551,'21','227','1',1,'Retail Sale Id 6511',1998.80,0.00,0.00,2.63,0.00,'2022-08-16 12:10:47','',''),(6552,'21','227','1',1,'Retail Sale Id 6512',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 12:11:11','',''),(6553,'21','227','1',1,'Retail Sale Id 6513',2796.80,0.00,0.00,3.68,0.00,'2022-08-16 12:20:49','',''),(6554,'21','227','1',1,'Retail Sale Id 6514',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 12:32:46','',''),(6555,'21','227','1',1,'Retail Sale Id 6515',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 12:44:14','',''),(6556,'21','227','1',1,'Retail Sale Id 6516',995.60,0.00,0.00,1.31,0.00,'2022-08-16 12:58:36','',''),(6557,'21','227','1',1,'Retail Sale Id 6517',2994.40,0.00,0.00,3.94,0.00,'2022-08-16 13:01:02','',''),(6558,'21','227','1',1,'Retail Sale Id 6518',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 13:02:53','',''),(6559,'21','227','1',1,'Retail Sale Id 6519',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 13:05:41','',''),(6560,'21','227','1',1,'Retail Sale Id 6520',494.00,0.00,0.00,0.65,0.00,'2022-08-16 13:26:45','',''),(6561,'21','227','1',1,'Retail Sale Id 6521',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 13:51:01','',''),(6562,'21','227','1',1,'Retail Sale Id 6522',2994.40,0.00,0.00,3.94,0.00,'2022-08-16 14:21:23','',''),(6563,'21','227','1',1,'Retail Sale Id 6523',995.60,0.00,0.00,1.31,0.00,'2022-08-16 14:26:48','',''),(6564,'21','227','1',1,'Retail Sale Id 6524',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 14:29:10','',''),(6565,'21','227','1',1,'Retail Sale Id 6525',1998.80,0.00,0.00,2.63,0.00,'2022-08-16 15:00:12','',''),(6566,'21','227','1',1,'Retail Sale Id 6526',1398.40,0.00,0.00,1.84,0.00,'2022-08-16 15:04:36','',''),(6567,'21','227','1',1,'Retail Sale Id 6527',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 15:05:53','',''),(6568,'21','227','1',1,'Retail Sale Id 6528',995.60,0.00,0.00,1.31,0.00,'2022-08-16 15:20:06','',''),(6569,'21','227','1',1,'Retail Sale Id 6529',2994.40,0.00,0.00,3.94,0.00,'2022-08-16 15:26:53','',''),(6570,'21','227','1',1,'Retail Sale Id 6530',2796.80,0.00,0.00,3.68,0.00,'2022-08-16 15:31:44','',''),(6571,'21','227','1',1,'Retail Sale Id 6531',995.60,0.00,0.00,1.31,0.00,'2022-08-16 15:34:24','',''),(6572,'21','227','1',1,'Retail Sale Id 6532',699.20,0.00,0.00,0.92,0.00,'2022-08-16 16:06:02','',''),(6573,'21','227','1',1,'Retail Sale Id 6533',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 16:06:48','',''),(6574,'21','227','1',1,'Retail Sale Id 6534',995.60,0.00,0.00,1.31,0.00,'2022-08-16 16:08:10','',''),(6575,'21','227','1',1,'Retail Sale Id 6535',995.60,0.00,0.00,1.31,0.00,'2022-08-16 16:09:11','',''),(6576,'21','227','1',1,'Retail Sale Id 6536',896.80,0.00,0.00,1.18,0.00,'2022-08-16 16:10:28','',''),(6577,'21','227','1',1,'Retail Sale Id 6537',3040.00,0.00,0.00,4.00,0.00,'2022-08-16 16:12:15','',''),(6578,'21','227','1',1,'Retail Sale Id 6538',2492.80,0.00,0.00,3.28,0.00,'2022-08-16 16:16:00','',''),(6579,'21','227','1',1,'Retail Sale Id 6539',2994.40,0.00,0.00,3.94,0.00,'2022-08-16 16:16:35','',''),(6580,'21','227','1',1,'Retail Sale Id 6540',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 16:17:10','',''),(6581,'21','227','1',1,'Retail Sale Id 6541',699.20,0.00,0.00,0.92,0.00,'2022-08-16 16:18:33','',''),(6582,'21','227','1',1,'Retail Sale Id 6542',19000.00,0.00,0.00,25.00,0.00,'2022-08-16 16:22:30','',''),(6583,'21','227','1',1,'Retail Sale Id 6543',995.60,0.00,0.00,1.31,0.00,'2022-08-16 16:26:04','',''),(6584,'21','227','1',1,'Retail Sale Id 6544',1998.80,0.00,0.00,2.63,0.00,'2022-08-16 16:33:02','',''),(6585,'21','227','1',1,'Retail Sale Id 6545',5494.80,0.00,0.00,7.23,0.00,'2022-08-16 16:47:27','',''),(6586,'21','227','1',1,'Retail Sale Id 6546',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 16:53:10','',''),(6587,'21','227','1',1,'Retail Sale Id 6547',2492.80,0.00,0.00,3.28,0.00,'2022-08-16 16:55:54','',''),(6588,'21','227','1',1,'Retail Sale Id 6548',995.60,0.00,0.00,1.31,0.00,'2022-08-16 16:57:48','',''),(6589,'21','227','1',1,'Retail Sale Id 6549',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 16:58:29','',''),(6590,'21','227','1',1,'Retail Sale Id 6550',2492.80,0.00,0.00,3.28,0.00,'2022-08-16 16:59:05','',''),(6591,'21','227','1',1,'Retail Sale Id 6551',995.60,0.00,0.00,1.31,0.00,'2022-08-16 16:59:39','',''),(6592,'21','227','1',1,'Retail Sale Id 6552',896.80,0.00,0.00,1.18,0.00,'2022-08-16 17:00:36','',''),(6593,'21','227','1',1,'Retail Sale Id 6553',995.60,0.00,0.00,1.31,0.00,'2022-08-16 17:01:47','',''),(6594,'21','227','1',1,'Retail Sale Id 6554',896.80,0.00,0.00,1.18,0.00,'2022-08-16 17:04:16','',''),(6595,'21','227','1',1,'Retail Sale Id 6555',995.60,0.00,0.00,1.31,0.00,'2022-08-16 17:04:52','',''),(6596,'21','227','1',1,'Retail Sale Id 6556',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 17:06:04','',''),(6597,'21','227','1',1,'Retail Sale Id 6557',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 17:07:38','',''),(6598,'21','227','1',1,'Retail Sale Id 6558',3298.40,0.00,0.00,4.34,0.00,'2022-08-16 17:08:48','',''),(6599,'21','227','1',1,'Retail Sale Id 6559',995.60,0.00,0.00,1.31,0.00,'2022-08-16 17:13:22','',''),(6600,'21','227','1',1,'Retail Sale Id 6560',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 17:16:47','',''),(6601,'21','227','1',1,'Retail Sale Id 6561',1520.00,0.00,0.00,2.00,0.00,'2022-08-16 17:18:16','',''),(6602,'21','227','1',1,'Retail Sale Id 6562',995.60,0.00,0.00,1.31,0.00,'2022-08-16 17:19:34','',''),(6603,'21','227','1',1,'Retail Sale Id 6563',995.60,0.00,0.00,1.31,0.00,'2022-08-16 17:20:57','',''),(6604,'21','227','1',1,'Retail Sale Id 6564',1998.80,0.00,0.00,2.63,0.00,'2022-08-16 17:22:35','',''),(6605,'21','227','1',1,'Retail Sale Id 6565',19000.00,0.00,0.00,25.00,0.00,'2022-08-16 17:23:06','',''),(6606,'21','227','1',1,'Retail Sale Id 6566',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 17:29:07','',''),(6607,'21','227','1',1,'Retail Sale Id 6567',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 17:29:32','',''),(6608,'21','227','1',1,'Retail Sale Id 6568',2796.80,0.00,0.00,3.68,0.00,'2022-08-16 17:37:33','',''),(6609,'21','227','1',1,'Retail Sale Id 6569',1497.20,0.00,0.00,1.97,0.00,'2022-08-16 17:39:24','',''),(6610,'21','227','1',1,'Retail Sale Id 6570',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 17:41:45','',''),(6611,'21','227','1',1,'Retail Sale Id 6571',2994.40,0.00,0.00,3.94,0.00,'2022-08-16 17:49:01','',''),(6612,'21','227','1',1,'Retail Sale Id 6571',4993.20,0.00,0.00,6.57,0.00,'2022-08-16 17:49:01','',''),(6613,'21','227','1',1,'Retail Sale Id 6572',1998.80,0.00,0.00,2.63,0.00,'2022-08-16 18:09:10','',''),(6614,'21','227','1',1,'Retail Sale Id 6573',2492.80,0.00,0.00,3.28,0.00,'2022-08-16 18:13:16','',''),(6615,'21','227','1',1,'Retail Sale Id 6574',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 18:14:49','',''),(6616,'21','227','1',1,'Retail Sale Id 6575',995.60,0.00,0.00,1.31,0.00,'2022-08-17 07:35:10','',''),(6617,'21','227','1',1,'Retail Sale Id 6576',5320.00,0.00,0.00,7.00,0.00,'2022-08-17 08:14:46','',''),(6618,'21','227','1',1,'Retail Sale Id 6577',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 08:16:30','',''),(6619,'21','227','1',1,'Retail Sale Id 6578',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 08:41:18','',''),(6620,'21','227','1',1,'Retail Sale Id 6579',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 08:41:56','',''),(6621,'21','227','1',1,'Retail Sale Id 6580',7600.00,0.00,0.00,10.00,0.00,'2022-08-17 08:42:25','',''),(6622,'21','227','1',1,'Retail Sale Id 6581',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 08:43:12','',''),(6623,'21','227','1',1,'Retail Sale Id 6582',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 08:52:23','',''),(6624,'21','227','1',1,'Retail Sale Id 6583',995.60,0.00,0.00,1.31,0.00,'2022-08-17 08:53:22','',''),(6625,'21','227','1',1,'Retail Sale Id 6584',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 08:54:11','',''),(6626,'21','227','1',1,'Retail Sale Id 6585',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 08:55:09','',''),(6627,'21','227','1',1,'Retail Sale Id 6586',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 08:56:27','',''),(6628,'21','227','1',1,'Retail Sale Id 6586',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 08:56:27','',''),(6629,'21','227','1',1,'Retail Sale Id 6587',995.60,0.00,0.00,1.31,0.00,'2022-08-17 09:02:32','',''),(6630,'21','227','1',1,'Retail Sale Id 6588',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 09:04:42','',''),(6631,'21','227','1',1,'Retail Sale Id 6589',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 09:19:05','',''),(6632,'21','227','1',1,'Retail Sale Id 6590',4499.20,0.00,0.00,5.92,0.00,'2022-08-17 09:20:20','',''),(6633,'21','227','1',1,'Retail Sale Id 6591',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 09:22:13','',''),(6634,'21','227','1',1,'Retail Sale Id 6592',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 09:23:45','',''),(6635,'21','227','1',1,'Retail Sale Id 6593',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 09:29:05','',''),(6636,'21','227','1',1,'Retail Sale Id 6594',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 09:38:11','',''),(6637,'21','227','1',1,'Retail Sale Id 6595',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 09:52:35','',''),(6638,'21','227','1',1,'Retail Sale Id 6596',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 09:55:38','',''),(6639,'21','227','1',1,'Retail Sale Id 6597',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 09:58:27','',''),(6640,'21','227','1',1,'Retail Sale Id 6598',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 09:59:59','',''),(6641,'21','227','1',1,'Retail Sale Id 6599',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 10:22:29','',''),(6642,'21','227','1',1,'Retail Sale Id 6600',995.60,0.00,0.00,1.31,0.00,'2022-08-17 10:23:18','',''),(6643,'21','227','1',1,'Retail Sale Id 6601',798.00,0.00,0.00,1.05,0.00,'2022-08-17 10:24:13','',''),(6644,'21','227','1',1,'Retail Sale Id 6602',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 10:28:34','',''),(6645,'21','227','1',1,'Retail Sale Id 6603',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 10:34:43','',''),(6646,'21','227','1',1,'Retail Sale Id 6604',3040.00,0.00,0.00,4.00,0.00,'2022-08-17 10:38:44','',''),(6647,'21','227','1',1,'Retail Sale Id 6605',699.20,0.00,0.00,0.92,0.00,'2022-08-17 10:42:03','',''),(6648,'21','227','1',1,'Retail Sale Id 6606',995.60,0.00,0.00,1.31,0.00,'2022-08-17 10:43:27','',''),(6649,'21','227','1',1,'Retail Sale Id 6607',3040.00,0.00,0.00,4.00,0.00,'2022-08-17 10:45:21','',''),(6650,'21','227','1',1,'Retail Sale Id 6608',798.00,0.00,0.00,1.05,0.00,'2022-08-17 10:49:25','',''),(6651,'21','227','1',1,'Retail Sale Id 6609',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 10:51:41','',''),(6652,'21','227','1',1,'Retail Sale Id 6610',3040.00,0.00,0.00,4.00,0.00,'2022-08-17 10:57:04','',''),(6653,'21','227','1',1,'Retail Sale Id 6611',494.00,0.00,0.00,0.65,0.00,'2022-08-17 11:08:14','',''),(6654,'21','227','1',1,'Retail Sale Id 6612',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 11:12:05','',''),(6655,'21','227','1',1,'Retail Sale Id 6613',995.60,0.00,0.00,1.31,0.00,'2022-08-17 11:32:25','',''),(6656,'21','227','1',1,'Retail Sale Id 6614',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 11:37:24','',''),(6657,'21','227','1',1,'Retail Sale Id 6615',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 12:12:08','',''),(6658,'21','227','1',1,'Retail Sale Id 6616',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 12:20:43','',''),(6659,'21','227','1',1,'Retail Sale Id 6617',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 12:21:50','',''),(6660,'21','227','1',1,'Retail Sale Id 6618',4499.20,0.00,0.00,5.92,0.00,'2022-08-17 12:22:35','',''),(6661,'21','227','1',1,'Retail Sale Id 6619',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 12:26:24','',''),(6662,'21','227','1',1,'Retail Sale Id 6620',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 12:27:05','',''),(6663,'21','227','1',1,'Retail Sale Id 6621',4499.20,0.00,0.00,5.92,0.00,'2022-08-17 12:27:56','',''),(6664,'21','227','1',1,'Retail Sale Id 6622',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 12:42:40','',''),(6665,'21','227','1',1,'Retail Sale Id 6623',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 12:43:29','',''),(6666,'21','227','1',1,'Retail Sale Id 6624',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 12:44:47','',''),(6667,'21','227','1',1,'Retail Sale Id 6625',8998.40,0.00,0.00,11.84,0.00,'2022-08-17 12:46:47','',''),(6668,'21','227','1',1,'Retail Sale Id 6626',995.60,0.00,0.00,1.31,0.00,'2022-08-17 12:47:34','',''),(6669,'21','227','1',1,'Retail Sale Id 6627',995.60,0.00,0.00,1.31,0.00,'2022-08-17 12:59:04','',''),(6670,'21','227','1',1,'Retail Sale Id 6628',4499.20,0.00,0.00,5.92,0.00,'2022-08-17 13:00:05','',''),(6671,'21','227','1',1,'Retail Sale Id 6629',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 13:04:52','',''),(6672,'21','227','1',1,'Retail Sale Id 6629',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 13:04:52','',''),(6673,'21','227','1',1,'Retail Sale Id 6630',4993.20,0.00,0.00,6.57,0.00,'2022-08-17 13:06:42','',''),(6674,'21','227','1',1,'Retail Sale Id 6631',995.60,0.00,0.00,1.31,0.00,'2022-08-17 13:10:21','',''),(6675,'21','227','1',1,'Retail Sale Id 6632',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 13:16:03','',''),(6676,'21','227','1',1,'Retail Sale Id 6633',7600.00,0.00,0.00,10.00,0.00,'2022-08-17 13:16:44','',''),(6677,'21','227','1',1,'Retail Sale Id 6634',5320.00,0.00,0.00,7.00,0.00,'2022-08-17 13:17:38','',''),(6678,'21','227','1',1,'Retail Sale Id 6635',6999.60,0.00,0.00,9.21,0.00,'2022-08-17 13:26:33','',''),(6679,'21','227','1',1,'Retail Sale Id 6636',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 13:27:43','',''),(6680,'21','227','1',1,'Retail Sale Id 6637',760.00,0.00,0.00,1.00,0.00,'2022-08-17 13:36:14','',''),(6681,'21','227','1',1,'Retail Sale Id 6638',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 14:43:09','',''),(6682,'21','227','1',1,'Retail Sale Id 6639',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 14:44:18','',''),(6683,'21','227','1',1,'Retail Sale Id 6640',2295.20,0.00,0.00,3.02,0.00,'2022-08-17 14:45:42','',''),(6684,'21','227','1',1,'Retail Sale Id 6641',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 14:46:57','',''),(6685,'21','227','1',1,'Retail Sale Id 6642',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 14:48:44','',''),(6686,'21','227','1',1,'Retail Sale Id 6643',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 14:49:40','',''),(6687,'21','227','1',1,'Retail Sale Id 6644',699.20,0.00,0.00,0.92,0.00,'2022-08-17 14:50:25','',''),(6688,'21','227','1',1,'Retail Sale Id 6645',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 14:51:02','',''),(6689,'21','227','1',1,'Retail Sale Id 6646',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 14:56:52','',''),(6690,'21','227','1',1,'Retail Sale Id 6647',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 14:57:55','',''),(6691,'21','227','1',1,'Retail Sale Id 6648',798.00,0.00,0.00,1.05,0.00,'2022-08-17 15:05:13','',''),(6692,'21','227','1',1,'Retail Sale Id 6649',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 15:06:19','',''),(6693,'21','227','1',1,'Retail Sale Id 6650',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 15:08:24','',''),(6694,'21','227','1',1,'Retail Sale Id 6651',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 15:11:58','',''),(6695,'21','227','1',1,'Retail Sale Id 6652',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 15:19:16','',''),(6696,'21','227','1',1,'Retail Sale Id 6652',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 15:19:16','',''),(6697,'21','227','1',1,'Retail Sale Id 6653',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 15:21:42','',''),(6698,'21','227','1',1,'Retail Sale Id 6654',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 15:22:55','',''),(6699,'21','227','1',1,'Retail Sale Id 6655',995.60,0.00,0.00,1.31,0.00,'2022-08-17 15:24:31','',''),(6700,'21','227','1',1,'Retail Sale Id 6656',995.60,0.00,0.00,1.31,0.00,'2022-08-17 15:26:37','',''),(6701,'21','227','1',1,'Retail Sale Id 6657',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 15:28:17','',''),(6702,'21','227','1',1,'Retail Sale Id 6658',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 15:31:00','',''),(6703,'21','227','1',1,'Retail Sale Id 6659',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 16:06:23','',''),(6704,'21','227','1',1,'Retail Sale Id 6660',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 16:07:55','',''),(6705,'21','227','1',1,'Retail Sale Id 6661',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 16:09:38','',''),(6706,'21','227','1',1,'Retail Sale Id 6662',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 16:10:59','',''),(6707,'21','227','1',1,'Retail Sale Id 6663',995.60,0.00,0.00,1.31,0.00,'2022-08-17 16:15:27','',''),(6708,'21','227','1',1,'Retail Sale Id 6664',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 16:18:09','',''),(6709,'21','227','1',1,'Retail Sale Id 6665',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 16:19:23','',''),(6710,'21','227','1',1,'Retail Sale Id 6666',995.60,0.00,0.00,1.31,0.00,'2022-08-17 16:23:44','',''),(6711,'21','227','1',1,'Retail Sale Id 6667',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 16:25:37','',''),(6712,'21','227','1',1,'Retail Sale Id 6668',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 16:30:18','',''),(6713,'21','227','1',1,'Retail Sale Id 6669',4598.00,0.00,0.00,6.05,0.00,'2022-08-17 16:36:32','',''),(6714,'21','227','1',1,'Retail Sale Id 6670',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 16:41:26','',''),(6715,'21','227','1',1,'Retail Sale Id 6671',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 16:43:10','',''),(6716,'21','227','1',1,'Retail Sale Id 6672',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 16:48:19','',''),(6717,'21','227','1',1,'Retail Sale Id 6673',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 16:49:37','',''),(6718,'21','227','1',1,'Retail Sale Id 6674',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 16:51:17','',''),(6719,'21','227','1',1,'Retail Sale Id 6675',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 16:52:16','',''),(6720,'21','227','1',1,'Retail Sale Id 6675',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 16:52:16','',''),(6721,'21','227','1',1,'Retail Sale Id 6676',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 16:54:08','',''),(6722,'21','227','1',1,'Retail Sale Id 6677',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 16:57:14','',''),(6723,'21','227','1',1,'Retail Sale Id 6678',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 16:58:02','',''),(6724,'21','227','1',1,'Retail Sale Id 6679',995.60,0.00,0.00,1.31,0.00,'2022-08-17 16:59:14','',''),(6725,'21','227','1',1,'Retail Sale Id 6680',995.60,0.00,0.00,1.31,0.00,'2022-08-17 17:00:03','',''),(6726,'21','227','1',1,'Retail Sale Id 6681',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 17:01:47','',''),(6727,'21','227','1',1,'Retail Sale Id 6681',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 17:01:47','',''),(6728,'21','227','1',1,'Retail Sale Id 6681',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 17:01:47','',''),(6729,'21','227','1',1,'Retail Sale Id 6682',995.60,0.00,0.00,1.31,0.00,'2022-08-17 17:03:26','',''),(6730,'21','227','1',1,'Retail Sale Id 6683',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 17:04:20','',''),(6731,'21','227','1',1,'Retail Sale Id 6684',995.60,0.00,0.00,1.31,0.00,'2022-08-17 17:05:39','',''),(6732,'21','227','1',1,'Retail Sale Id 6685',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 17:10:15','',''),(6733,'21','227','1',1,'Retail Sale Id 6686',760.00,0.00,0.00,1.00,0.00,'2022-08-17 17:11:17','',''),(6734,'21','227','1',1,'Retail Sale Id 6686',995.60,0.00,0.00,1.31,0.00,'2022-08-17 17:11:17','',''),(6735,'21','227','1',1,'Retail Sale Id 6687',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 17:12:51','',''),(6736,'21','227','1',1,'Retail Sale Id 6688',1793.60,0.00,0.00,2.36,0.00,'2022-08-17 17:14:32','',''),(6737,'21','227','1',1,'Retail Sale Id 6689',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 17:19:20','',''),(6738,'21','227','1',1,'Retail Sale Id 6690',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 17:22:04','',''),(6739,'21','227','1',1,'Retail Sale Id 6691',2994.40,0.00,0.00,3.94,0.00,'2022-08-17 17:23:29','',''),(6740,'21','227','1',1,'Retail Sale Id 6692',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 17:31:07','',''),(6741,'21','227','1',1,'Retail Sale Id 6693',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 17:33:22','',''),(6742,'21','227','1',1,'Retail Sale Id 6694',995.60,0.00,0.00,1.31,0.00,'2022-08-17 17:41:55','',''),(6743,'21','227','1',1,'Retail Sale Id 6695',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 17:51:06','',''),(6744,'21','227','1',1,'Retail Sale Id 6696',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 17:51:49','',''),(6745,'21','227','1',1,'Retail Sale Id 6697',7600.00,0.00,0.00,10.00,0.00,'2022-08-17 17:52:41','',''),(6746,'21','227','1',1,'Retail Sale Id 6698',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 08:50:26','',''),(6747,'21','227','1',1,'Retail Sale Id 6699',3800.00,0.00,0.00,5.00,0.00,'2022-08-18 08:52:18','',''),(6748,'21','227','1',1,'Retail Sale Id 6700',4294.00,0.00,0.00,5.65,0.00,'2022-08-18 08:55:03','',''),(6749,'21','227','1',1,'Retail Sale Id 6701',4560.00,0.00,0.00,6.00,0.00,'2022-08-18 09:01:25','',''),(6750,'21','227','1',1,'Retail Sale Id 6702',4499.20,0.00,0.00,5.92,0.00,'2022-08-18 09:03:08','',''),(6751,'21','227','1',1,'Retail Sale Id 6703',7600.00,0.00,0.00,10.00,0.00,'2022-08-18 09:06:53','',''),(6752,'21','227','1',1,'Retail Sale Id 6704',995.60,0.00,0.00,1.31,0.00,'2022-08-18 09:10:20','',''),(6753,'21','227','1',1,'Retail Sale Id 6705',995.60,0.00,0.00,1.31,0.00,'2022-08-18 09:10:48','',''),(6754,'21','227','1',1,'Retail Sale Id 6706',494.00,0.00,0.00,0.65,0.00,'2022-08-18 09:12:29','',''),(6755,'21','227','1',1,'Retail Sale Id 6707',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 09:14:28','',''),(6756,'21','227','1',1,'Retail Sale Id 6708',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 09:25:02','',''),(6757,'21','227','1',1,'Retail Sale Id 6709',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 09:31:09','',''),(6758,'21','227','1',1,'Retail Sale Id 6710',4499.20,0.00,0.00,5.92,0.00,'2022-08-18 09:32:06','',''),(6759,'21','227','1',1,'Retail Sale Id 6711',3800.00,0.00,0.00,5.00,0.00,'2022-08-18 09:39:53','',''),(6760,'21','227','1',1,'Retail Sale Id 6712',1793.60,0.00,0.00,2.36,0.00,'2022-08-18 09:42:41','',''),(6761,'21','227','1',1,'Retail Sale Id 6713',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 09:45:27','',''),(6762,'21','227','1',1,'Retail Sale Id 6714',896.80,0.00,0.00,1.18,0.00,'2022-08-18 09:46:24','',''),(6763,'21','227','1',1,'Retail Sale Id 6715',19000.00,0.00,0.00,25.00,0.00,'2022-08-18 09:47:38','',''),(6764,'21','227','1',1,'Retail Sale Id 6716',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 09:48:18','',''),(6765,'21','227','1',1,'Retail Sale Id 6717',7600.00,0.00,0.00,10.00,0.00,'2022-08-18 09:48:44','',''),(6766,'21','227','1',1,'Retail Sale Id 6718',3800.00,0.00,0.00,5.00,0.00,'2022-08-18 09:50:32','',''),(6767,'21','227','1',1,'Retail Sale Id 6719',1497.20,0.00,0.00,1.97,0.00,'2022-08-18 09:51:58','',''),(6768,'21','227','1',1,'Retail Sale Id 6720',1497.20,0.00,0.00,1.97,0.00,'2022-08-18 09:52:44','',''),(6769,'21','227','1',1,'Retail Sale Id 6721',4993.20,0.00,0.00,6.57,0.00,'2022-08-18 09:57:01','',''),(6770,'21','227','1',1,'Retail Sale Id 6722',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 10:24:54','',''),(6771,'21','227','1',1,'Retail Sale Id 6723',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 10:26:15','',''),(6772,'21','227','1',1,'Retail Sale Id 6724',2698.00,0.00,0.00,3.55,0.00,'2022-08-18 10:33:40','',''),(6773,'21','227','1',1,'Retail Sale Id 6725',1497.20,0.00,0.00,1.97,0.00,'2022-08-18 10:37:54','',''),(6774,'21','227','1',1,'Retail Sale Id 6726',995.60,0.00,0.00,1.31,0.00,'2022-08-18 10:38:31','',''),(6775,'21','227','1',1,'Retail Sale Id 6727',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 10:57:30','',''),(6776,'21','227','1',1,'Retail Sale Id 6728',1520.00,0.00,0.00,2.00,0.00,'2022-08-18 10:59:09','',''),(6777,'21','227','1',1,'Retail Sale Id 6729',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 11:13:08','',''),(6778,'21','227','1',1,'Retail Sale Id 6730',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 11:16:02','',''),(6779,'21','227','1',1,'Retail Sale Id 6731',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 11:19:25','',''),(6780,'21','227','1',1,'Retail Sale Id 6733',3997.60,0.00,0.00,5.26,0.00,'2022-08-18 11:23:01','',''),(6781,'21','227','1',1,'Retail Sale Id 6734',1497.20,0.00,0.00,1.97,0.00,'2022-08-18 11:25:13','',''),(6782,'21','227','1',1,'Retail Sale Id 6734',6999.60,0.00,0.00,9.21,0.00,'2022-08-18 11:25:13','',''),(6783,'21','227','1',1,'Retail Sale Id 6734',6999.60,0.00,0.00,9.21,0.00,'2022-08-18 11:25:13','',''),(6784,'21','227','1',1,'Retail Sale Id 6735',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 11:26:32','',''),(6785,'21','227','1',1,'Retail Sale Id 6736',995.60,0.00,0.00,1.31,0.00,'2022-08-18 11:27:46','',''),(6786,'21','227','1',1,'Retail Sale Id 6737',494.00,0.00,0.00,0.65,0.00,'2022-08-18 11:30:32','',''),(6787,'21','227','1',1,'Retail Sale Id 6738',2492.80,0.00,0.00,3.28,0.00,'2022-08-18 11:31:45','',''),(6788,'21','227','1',1,'Retail Sale Id 6739',11400.00,0.00,0.00,15.00,0.00,'2022-08-18 11:33:00','',''),(6789,'21','227','1',1,'Retail Sale Id 6740',1497.20,0.00,0.00,1.97,0.00,'2022-08-18 11:36:50','',''),(6790,'21','227','1',1,'Retail Sale Id 6741',4993.20,0.00,0.00,6.57,0.00,'2022-08-18 11:51:35','',''),(6791,'21','227','1',1,'Retail Sale Id 6742',995.60,0.00,0.00,1.31,0.00,'2022-08-18 11:53:27','',''),(6792,'21','227','1',1,'Retail Sale Id 6743',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 11:55:43','',''),(6793,'21','227','1',1,'Retail Sale Id 6744',760.00,0.00,0.00,1.00,0.00,'2022-08-18 11:58:04','',''),(6794,'21','227','1',1,'Retail Sale Id 6745',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 12:10:35','',''),(6795,'21','227','1',1,'Retail Sale Id 6746',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 12:11:35','',''),(6796,'21','227','1',1,'Retail Sale Id 6747',995.60,0.00,0.00,1.31,0.00,'2022-08-18 12:13:00','',''),(6797,'21','227','1',1,'Retail Sale Id 6749',3800.00,0.00,0.00,5.00,0.00,'2022-08-18 12:16:21','',''),(6798,'21','227','1',1,'Retail Sale Id 6750',2097.60,0.00,0.00,2.76,0.00,'2022-08-18 12:17:53','',''),(6799,'21','227','1',1,'Retail Sale Id 6751',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 12:18:37','',''),(6800,'21','227','1',1,'Retail Sale Id 6752',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 12:19:36','',''),(6801,'21','227','1',1,'Retail Sale Id 6753',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 12:27:51','',''),(6802,'21','227','1',1,'Retail Sale Id 6754',798.00,0.00,0.00,1.05,0.00,'2022-08-18 12:28:50','',''),(6803,'21','227','1',1,'Retail Sale Id 6755',995.60,0.00,0.00,1.31,0.00,'2022-08-18 12:29:25','',''),(6804,'21','227','1',1,'Retail Sale Id 6756',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 12:31:48','',''),(6805,'21','227','1',1,'Retail Sale Id 6757',3800.00,0.00,0.00,5.00,0.00,'2022-08-18 12:34:09','',''),(6806,'21','227','1',1,'Retail Sale Id 6758',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 12:39:52','',''),(6807,'21','227','1',1,'Retail Sale Id 6759',3800.00,0.00,0.00,5.00,0.00,'2022-08-18 12:44:29','',''),(6808,'21','227','1',1,'Retail Sale Id 6760',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 12:45:56','',''),(6809,'21','227','1',1,'Retail Sale Id 6761',3800.00,0.00,0.00,5.00,0.00,'2022-08-18 12:49:03','',''),(6810,'21','227','1',1,'Retail Sale Id 6762',1998.80,0.00,0.00,2.63,0.00,'2022-08-18 12:49:49','',''),(6811,'21','227','1',1,'Retail Sale Id 6763',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 12:51:06','',''),(6812,'21','227','1',1,'Retail Sale Id 6764',2994.40,0.00,0.00,3.94,0.00,'2022-08-18 12:53:05','',''),(6813,'21','227','1',1,'Retail Sale Id 6765',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 12:55:59','',''),(6814,'21','227','1',1,'Retail Sale Id 6766',2492.80,0.00,0.00,3.28,0.00,'2022-08-18 13:03:44','',''),(6815,'21','227','1',1,'Retail Sale Id 6767',1504.80,0.00,0.00,1.98,0.00,'2022-08-18 13:04:21','',''),(6816,'21','227','1',1,'Retail Sale Id 6768',1504.80,0.00,0.00,1.98,0.00,'2022-08-18 13:04:54','',''),(6817,'21','227','1',1,'Retail Sale Id 6769',4993.20,0.00,0.00,6.57,0.00,'2022-08-18 13:06:04','',''),(6818,'21','227','1',1,'Retail Sale Id 6770',19000.00,0.00,0.00,25.00,0.00,'2022-08-18 13:46:34','',''),(6819,'21','227','1',1,'Retail Sale Id 6771',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 13:58:39','',''),(6820,'21','227','1',1,'Retail Sale Id 6772',4993.20,0.00,0.00,6.57,0.00,'2022-08-18 14:00:08','',''),(6821,'21','227','1',1,'Retail Sale Id 6773',5996.40,0.00,0.00,7.89,0.00,'2022-08-18 14:00:49','',''),(6822,'21','227','1',1,'Retail Sale Id 6774',4560.00,0.00,0.00,6.00,0.00,'2022-08-18 14:01:13','',''),(6823,'21','227','1',1,'Retail Sale Id 6775',4993.20,0.00,0.00,6.57,0.00,'2022-08-18 14:02:06','',''),(6824,'21','227','1',1,'Retail Sale Id 6776',2994.40,0.00,0.00,3.94,0.00,'2022-08-18 14:13:58','',''),(6825,'21','227','1',1,'Retail Sale Id 6777',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 18:21:05','',''),(6826,'21','227','1',1,'Retail Sale Id 6778',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 18:21:46','',''),(6827,'21','227','1',1,'Retail Sale Id 6779',11400.00,0.00,0.00,15.00,0.00,'2022-08-18 18:22:47','',''),(6828,'21','227','1',1,'Retail Sale Id 6779',19000.00,0.00,0.00,25.00,0.00,'2022-08-18 18:22:47','',''),(6829,'21','227','1',1,'Retail Sale Id 6779',22800.00,0.00,0.00,30.00,0.00,'2022-08-18 18:22:47','',''),(6830,'21','227','1',1,'Retail Sale Id 6780',32224.00,0.00,0.00,42.40,0.00,'2022-08-18 18:23:14','',''),(6831,'21','227','1',1,'Retail Sale Id 6748',3800.00,0.00,0.00,5.00,0.00,'2022-08-18 18:24:16','',''),(6832,'21','227','1',1,'Retail Sale Id 6732',4499.20,0.00,0.00,5.92,0.00,'2022-08-18 18:24:42','',''),(6833,'21','227',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,2000.00,0.00,'2022-08-18 18:27:10','',''),(6834,'21','227','1',1,'Received from bridging 17',0.00,0.00,2000.00,0.00,0.00,'2022-08-18 18:27:10','',''),(6835,'21','227','1',1,'Retail Sale Id 6781',1497.20,0.00,0.00,1.97,0.00,'2022-08-19 10:13:00','',''),(6836,'21','227','1',1,'Retail Sale Id 6782',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 11:51:15','',''),(6837,'21','227','1',1,'Retail Sale Id 6783',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 13:37:19','',''),(6838,'21','227','1',1,'Retail Sale Id 6784',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 13:38:03','',''),(6839,'21','227','1',1,'Retail Sale Id 6785',7600.00,0.00,0.00,10.00,0.00,'2022-08-19 13:39:04','',''),(6840,'21','227','1',1,'Retail Sale Id 6786',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 14:48:16','',''),(6841,'21','227','1',1,'Retail Sale Id 6787',1793.60,0.00,0.00,2.36,0.00,'2022-08-19 15:00:23','',''),(6842,'21','227','1',1,'Retail Sale Id 6788',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 15:01:38','',''),(6843,'21','227','1',1,'Retail Sale Id 6789',1497.20,0.00,0.00,1.97,0.00,'2022-08-19 15:02:17','',''),(6844,'21','227','1',1,'Retail Sale Id 6790',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 15:03:26','',''),(6845,'21','227','1',1,'Retail Sale Id 6791',3800.00,0.00,0.00,5.00,0.00,'2022-08-19 15:04:35','',''),(6846,'21','227','1',1,'Retail Sale Id 6792',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 15:14:42','',''),(6847,'21','227','1',1,'Retail Sale Id 6793',995.60,0.00,0.00,1.31,0.00,'2022-08-19 15:17:43','',''),(6848,'21','227','1',1,'Retail Sale Id 6794',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 15:23:53','',''),(6849,'21','227','1',1,'Retail Sale Id 6795',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 15:25:05','',''),(6850,'21','227','1',1,'Retail Sale Id 6796',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 15:26:53','',''),(6851,'21','227','1',1,'Retail Sale Id 6797',1094.40,0.00,0.00,1.44,0.00,'2022-08-19 15:31:28','',''),(6852,'21','227','1',1,'Retail Sale Id 6798',1193.20,0.00,0.00,1.57,0.00,'2022-08-19 15:36:14','',''),(6853,'21','227','1',1,'Retail Sale Id 6799',2994.40,0.00,0.00,3.94,0.00,'2022-08-19 15:38:08','',''),(6854,'21','227','1',1,'Retail Sale Id 6799',3800.00,0.00,0.00,5.00,0.00,'2022-08-19 15:38:08','',''),(6855,'21','227','1',1,'Retail Sale Id 6800',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 15:41:13','',''),(6856,'21','227','1',1,'Retail Sale Id 6801',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 15:42:03','',''),(6857,'21','227','1',1,'Retail Sale Id 6802',2280.00,0.00,0.00,3.00,0.00,'2022-08-19 15:42:39','',''),(6858,'21','227','1',1,'Retail Sale Id 6803',1497.20,0.00,0.00,1.97,0.00,'2022-08-19 15:43:36','',''),(6859,'21','227','1',1,'Retail Sale Id 6804',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 15:45:16','',''),(6860,'21','227','1',1,'Retail Sale Id 6804',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 15:45:16','',''),(6861,'21','227','1',1,'Retail Sale Id 6805',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 15:46:02','',''),(6862,'21','227','1',1,'Retail Sale Id 6806',1497.20,0.00,0.00,1.97,0.00,'2022-08-19 15:46:41','',''),(6863,'21','227','1',1,'Retail Sale Id 6807',2280.00,0.00,0.00,3.00,0.00,'2022-08-19 15:47:54','',''),(6864,'21','227','1',1,'Retail Sale Id 6808',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 15:48:55','',''),(6865,'21','227','1',1,'Retail Sale Id 6809',995.60,0.00,0.00,1.31,0.00,'2022-08-19 15:49:43','',''),(6866,'21','227','1',1,'Retail Sale Id 6810',1520.00,0.00,0.00,2.00,0.00,'2022-08-19 16:20:21','',''),(6867,'21','227','1',1,'Retail Sale Id 6811',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 16:27:44','',''),(6868,'21','227','1',1,'Retail Sale Id 6812',3997.60,0.00,0.00,5.26,0.00,'2022-08-19 16:32:41','',''),(6869,'21','227','1',1,'Retail Sale Id 6813',1998.80,0.00,0.00,2.63,0.00,'2022-08-19 16:36:57','',''),(6870,'21','227','1',1,'Retail Sale Id 6814',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 16:40:37','',''),(6871,'21','227','1',1,'Retail Sale Id 6815',7600.00,0.00,0.00,10.00,0.00,'2022-08-19 16:41:38','',''),(6872,'21','227','1',1,'Retail Sale Id 6816',4499.20,0.00,0.00,5.92,0.00,'2022-08-19 16:42:42','',''),(6873,'21','227','1',1,'Retail Sale Id 6817',2280.00,0.00,0.00,3.00,0.00,'2022-08-19 16:43:42','',''),(6874,'21','227','1',1,'Retail Sale Id 6818',1497.20,0.00,0.00,1.97,0.00,'2022-08-19 16:46:38','',''),(6875,'21','227','1',1,'Retail Sale Id 6819',4499.20,0.00,0.00,5.92,0.00,'2022-08-19 16:47:49','',''),(6876,'21','227','1',1,'Retail Sale Id 6820',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 16:48:56','',''),(6877,'21','227','1',1,'Retail Sale Id 6822',3800.00,0.00,0.00,5.00,0.00,'2022-08-19 16:59:39','',''),(6878,'21','227','1',1,'Retail Sale Id 6823',1497.20,0.00,0.00,1.97,0.00,'2022-08-19 17:02:07','',''),(6879,'21','227','1',1,'Retail Sale Id 6825',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 17:55:46','',''),(6880,'21','227','1',1,'Retail Sale Id 6826',1039224.00,0.00,0.00,1367.40,0.00,'2022-08-19 18:00:24','',''),(6881,'21','227','1',1,'Retail Sale Id 6821',3800.00,0.00,0.00,5.00,0.00,'2022-08-19 18:04:44','',''),(6882,'21','227','1',1,'Retail Sale Id 6824',3800.00,0.00,0.00,5.00,0.00,'2022-08-19 18:07:21','',''),(6883,'21','227','1',1,'Retail Sale Id 6827',15200.00,0.00,0.00,20.00,0.00,'2022-08-19 23:35:40','',''),(6884,'21','227','1',1,'Retail Sale Id 6827',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 23:35:40','',''),(6885,'21','227','1',1,'Retail Sale Id 6828',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 23:37:20','',''),(6886,'21','227','1',1,'Retail Sale Id 6828',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 23:37:20','',''),(6887,'21','227','1',1,'Retail Sale Id 6828',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 23:37:20','',''),(6888,'21','227','1',1,'Retail Sale Id 6829',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 23:38:35','',''),(6889,'21','227','1',1,'Retail Sale Id 6829',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 23:38:35','',''),(6890,'21','227','1',1,'Retail Sale Id 6830',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 23:44:43','',''),(6891,'21','227','1',1,'Retail Sale Id 6830',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 23:44:43','',''),(6892,'21','227','1',1,'Retail Sale Id 6831',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 23:51:24','',''),(6893,'21','227',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,772920.00,1017.00,0.00,0.00,'2022-08-21 14:05:14','',''),(6894,'21','227',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,1017.00,0.00,'2022-08-21 14:06:25','',''),(6895,'21','227','1',1,'Received from bridging 18',0.00,0.00,1017.00,0.00,0.00,'2022-08-21 14:06:25','',''),(6896,'21','227','1',1,'Retail Sale Id 6833',3800.00,0.00,0.00,5.00,0.00,'2022-10-09 10:29:36','',''),(6897,'21','227','1',1,'Retail Sale Id 6833',7600.00,0.00,0.00,10.00,0.00,'2022-10-09 10:29:36','',''),(6898,'21','227','1',1,'Retail Sale Id 6834',3800.00,0.00,0.00,5.00,0.00,'2022-10-09 10:35:39','',''),(6899,'21','227','1',1,'Retail Sale Id 6835',7600.00,0.00,0.00,10.00,0.00,'2022-10-09 10:36:05','',''),(6900,'21','227','1',1,'Retail Sale Id 6836',11400.00,0.00,0.00,15.00,0.00,'2022-10-09 10:38:02','',''),(6901,'21','227','1',1,'Retail Sale Id 6837',1140.00,0.00,0.00,1.50,0.00,'2022-10-12 12:36:01','',''),(6902,'21','227','1',1,'Retail Sale Id 6837',9500.00,0.00,0.00,12.50,0.00,'2022-10-12 12:36:01','',''),(6903,'21','227','1',1,'Retail Sale Id 6838',684155.80,0.00,0.00,900.21,0.00,'2022-10-12 12:37:42','',''),(6904,'21','227','1',1,'Retail Sale Id 6839',569841.16,0.00,0.00,749.79,0.00,'2022-10-12 12:38:29','',''),(6905,'21','227','1',1,'Retail Sale Id 6840',1497.20,0.00,0.00,1.97,0.00,'2022-10-12 12:39:11','',''),(6906,'21','227','1',1,'Retail Sale Id 6841',1003.20,0.00,0.00,1.32,0.00,'2022-10-12 12:41:53','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6863 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (4,'21','227',1,'Retail Sale Id 4',0.00,4560.00,760.00,4560.00,0.00,'2022-06-07 08:39:53'),(5,'21','227',1,'Retail Sale Id 5',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 08:42:30'),(6,'21','227',1,'Retail Sale Id 6',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 08:44:18'),(7,'21','227',1,'Retail Sale Id 7',0.00,995.60,760.00,995.60,0.00,'2022-06-07 08:45:54'),(8,'21','227',1,'Retail Sale Id 8',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 08:47:16'),(9,'21','227',1,'Retail Sale Id 9',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 08:49:04'),(10,'21','227',1,'Retail Sale Id 10',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 08:50:54'),(11,'21','227',1,'Retail Sale Id 11',0.00,1504.80,760.00,1504.80,0.00,'2022-06-07 08:52:19'),(12,'21','227',1,'Retail Sale Id 12',0.00,1140.00,760.00,1140.00,0.00,'2022-06-07 08:58:20'),(13,'21','227',1,'Retail Sale Id 13',0.00,7600.00,760.00,7600.00,0.00,'2022-06-07 08:59:45'),(14,'21','227',1,'Retail Sale Id 14',0.00,1140.00,760.00,1140.00,0.00,'2022-06-07 09:01:21'),(15,'21','227',1,'Retail Sale Id 14',0.00,1398.40,760.00,1398.40,0.00,'2022-06-07 09:01:21'),(16,'21','227',1,'Retail Sale Id 15',0.00,2492.80,760.00,2492.80,0.00,'2022-06-07 09:02:44'),(17,'21','227',1,'Retail Sale Id 16',0.00,4993.20,760.00,4993.20,0.00,'2022-06-07 09:04:16'),(18,'21','227',1,'Retail Sale Id 17',0.00,760.00,760.00,760.00,0.00,'2022-06-07 09:05:29'),(19,'21','227',1,'Retail Sale Id 18',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 09:07:26'),(20,'21','227',1,'Retail Sale Id 19',0.00,798.00,760.00,798.00,0.00,'2022-06-07 09:10:47'),(21,'21','227',1,'Retail Sale Id 20',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 09:16:57'),(22,'21','227',1,'Retail Sale Id 21',0.00,1041.20,760.00,1041.20,0.00,'2022-06-07 09:20:30'),(23,'21','227',1,'Retail Sale Id 23',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 09:28:12'),(24,'21','227',1,'Retail Sale Id 24',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 09:29:27'),(25,'21','227',1,'Retail Sale Id 25',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 09:33:45'),(26,'21','227',1,'Retail Sale Id 27',0.00,1193.20,760.00,1193.20,0.00,'2022-06-07 09:35:43'),(27,'21','227',1,'Retail Sale Id 28',0.00,4560.00,760.00,4560.00,0.00,'2022-06-07 09:39:49'),(28,'21','227',1,'Retail Sale Id 29',0.00,995.60,760.00,995.60,0.00,'2022-06-07 10:01:51'),(29,'21','227',1,'Retail Sale Id 30',0.00,699.20,760.00,699.20,0.00,'2022-06-07 10:05:33'),(30,'21','227',1,'Retail Sale Id 31',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 10:10:15'),(31,'21','227',1,'Retail Sale Id 32',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 10:17:27'),(32,'21','227',1,'Retail Sale Id 33',0.00,995.60,760.00,995.60,0.00,'2022-06-07 11:12:57'),(33,'21','227',1,'Retail Sale Id 34',0.00,3982.40,760.00,3982.40,0.00,'2022-06-07 11:15:03'),(34,'21','227',1,'Retail Sale Id 36',0.00,1520.00,760.00,1520.00,0.00,'2022-06-07 11:18:18'),(35,'21','227',1,'Retail Sale Id 37',0.00,4993.20,760.00,4993.20,0.00,'2022-06-07 11:31:57'),(36,'21','227',1,'Retail Sale Id 38',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 11:39:39'),(37,'21','227',1,'Retail Sale Id 39',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 11:43:04'),(38,'21','227',1,'Retail Sale Id 40',0.00,2994.40,760.00,2994.40,0.00,'2022-06-07 11:45:12'),(39,'21','227',1,'Retail Sale Id 41',0.00,1520.00,760.00,1520.00,0.00,'2022-06-07 11:47:03'),(40,'21','227',1,'Retail Sale Id 42',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 11:49:34'),(41,'21','227',1,'Retail Sale Id 43',0.00,9500.00,760.00,9500.00,0.00,'2022-06-07 11:51:27'),(42,'21','227',1,'Retail Sale Id 44',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 12:27:48'),(43,'21','227',1,'Retail Sale Id 45',0.00,7600.00,760.00,7600.00,0.00,'2022-06-07 12:29:40'),(44,'21','227',1,'Retail Sale Id 46',0.00,4560.00,760.00,4560.00,0.00,'2022-06-07 12:31:47'),(45,'21','227',1,'Retail Sale Id 47',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 12:38:32'),(46,'21','227',1,'Retail Sale Id 48',0.00,798.00,760.00,798.00,0.00,'2022-06-07 12:43:06'),(47,'21','227',1,'Return of Retail Sale Id 39',1998.80,0.00,760.00,-1998.80,0.00,'2022-06-07 12:53:00'),(48,'21','227',1,'Retail Sale Id 49',0.00,9500.00,760.00,9500.00,0.00,'2022-06-07 13:31:38'),(49,'21','227',1,'Retail Sale Id 50',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 13:32:36'),(50,'21','227',1,'Retail Sale Id 51',0.00,1520.00,760.00,1520.00,0.00,'2022-06-07 13:33:23'),(51,'21','227',1,'Retail Sale Id 52',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 13:34:09'),(52,'21','227',1,'Retail Sale Id 53',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 13:35:03'),(53,'21','227',1,'Retail Sale Id 54',0.00,995.60,760.00,995.60,0.00,'2022-06-07 13:35:58'),(54,'21','227',1,'Retail Sale Id 55',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 13:36:41'),(55,'21','227',1,'Retail Sale Id 56',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 13:37:20'),(56,'21','227',1,'Retail Sale Id 57',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 13:37:54'),(57,'21','227',1,'Retail Sale Id 58',0.00,9500.00,760.00,9500.00,0.00,'2022-06-07 13:38:34'),(58,'21','227',1,'Retail Sale Id 59',0.00,995.60,760.00,995.60,0.00,'2022-06-07 13:39:12'),(59,'21','227',1,'Retail Sale Id 60',0.00,896.80,760.00,896.80,0.00,'2022-06-07 13:39:53'),(60,'21','227',1,'Retail Sale Id 61',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 13:40:34'),(61,'21','227',1,'Retail Sale Id 62',0.00,995.60,760.00,995.60,0.00,'2022-06-07 13:41:07'),(62,'21','227',1,'Retail Sale Id 63',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 13:41:40'),(63,'21','227',1,'Retail Sale Id 64',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 13:42:09'),(64,'21','227',1,'Retail Sale Id 65',0.00,4392.80,760.00,4392.80,0.00,'2022-06-07 13:42:40'),(65,'21','227',1,'Retail Sale Id 66',0.00,896.80,760.00,896.80,0.00,'2022-06-07 13:47:01'),(66,'21','227',1,'Retail Sale Id 67',0.00,9500.00,760.00,9500.00,0.00,'2022-06-07 13:49:55'),(67,'21','227',1,'Retail Sale Id 68',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 13:57:40'),(68,'21','227',1,'Retail Sale Id 69',0.00,1520.00,760.00,1520.00,0.00,'2022-06-07 14:00:10'),(69,'21','227',1,'Retail Sale Id 70',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 14:10:21'),(70,'21','227',1,'Retail Sale Id 71',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 14:11:19'),(71,'21','227',1,'Retail Sale Id 72',0.00,4560.00,760.00,4560.00,0.00,'2022-06-07 14:26:46'),(72,'21','227',1,'Retail Sale Id 73',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 14:33:17'),(73,'21','227',1,'Retail Sale Id 75',0.00,2994.40,760.00,2994.40,0.00,'2022-06-07 14:39:52'),(74,'21','227',1,'Retail Sale Id 75',0.00,4560.00,760.00,4560.00,0.00,'2022-06-07 14:39:53'),(75,'21','227',1,'Retail Sale Id 75',0.00,9500.00,760.00,9500.00,0.00,'2022-06-07 14:39:53'),(76,'21','227',1,'Retail Sale Id 76',0.00,4560.00,760.00,4560.00,0.00,'2022-06-07 14:42:57'),(77,'21','227',1,'Retail Sale Id 77',0.00,2994.40,760.00,2994.40,0.00,'2022-06-07 14:46:43'),(78,'21','227',1,'Retail Sale Id 78',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 14:54:04'),(79,'21','227',1,'Retail Sale Id 79',0.00,6999.60,760.00,6999.60,0.00,'2022-06-07 15:00:18'),(80,'21','227',1,'Retail Sale Id 80',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 15:26:57'),(81,'21','227',1,'Retail Sale Id 81',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 15:28:23'),(82,'21','227',1,'Retail Sale Id 82',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 15:32:28'),(83,'21','227',1,'Retail Sale Id 83',0.00,1694.80,760.00,1694.80,0.00,'2022-06-07 15:41:09'),(84,'21','227',1,'Retail Sale Id 84',0.00,1193.20,760.00,1193.20,0.00,'2022-06-07 15:43:18'),(85,'21','227',1,'Retail Sale Id 85',0.00,995.60,760.00,995.60,0.00,'2022-06-07 15:44:52'),(86,'21','227',1,'Retail Sale Id 86',0.00,995.60,760.00,995.60,0.00,'2022-06-07 15:46:38'),(87,'21','227',1,'Retail Sale Id 87',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 15:48:00'),(88,'21','227',1,'Retail Sale Id 88',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 15:49:29'),(89,'21','227',1,'Retail Sale Id 89',0.00,995.60,760.00,995.60,0.00,'2022-06-07 15:51:07'),(90,'21','227',1,'Retail Sale Id 91',0.00,995.60,760.00,995.60,0.00,'2022-06-07 16:07:30'),(91,'21','227',1,'Retail Sale Id 91',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 16:07:30'),(92,'21','227',1,'Retail Sale Id 92',0.00,1520.00,760.00,1520.00,0.00,'2022-06-07 16:08:49'),(93,'21','227',1,'Retail Sale Id 93',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 16:10:05'),(94,'21','227',1,'Retail Sale Id 95',0.00,995.60,760.00,995.60,0.00,'2022-06-07 16:10:54'),(95,'21','227',1,'Retail Sale Id 96',0.00,2796.80,760.00,2796.80,0.00,'2022-06-07 16:12:56'),(96,'21','227',1,'Retail Sale Id 97',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 16:14:02'),(97,'21','227',1,'Retail Sale Id 98',0.00,4993.20,760.00,4993.20,0.00,'2022-06-07 16:15:14'),(98,'21','227',1,'Retail Sale Id 99',0.00,995.60,760.00,995.60,0.00,'2022-06-07 16:21:26'),(99,'21','227',1,'Retail Sale Id 100',0.00,2994.40,760.00,2994.40,0.00,'2022-06-07 16:22:26'),(100,'21','227',1,'Retail Sale Id 101',0.00,9500.00,760.00,9500.00,0.00,'2022-06-07 16:23:38'),(101,'21','227',1,'Retail Sale Id 102',0.00,1520.00,760.00,1520.00,0.00,'2022-06-07 16:24:33'),(102,'21','227',1,'Retail Sale Id 103',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 16:25:50'),(103,'21','227',1,'Retail Sale Id 104',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 16:27:27'),(104,'21','227',1,'Retail Sale Id 105',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 16:28:34'),(105,'21','227',1,'Retail Sale Id 106',0.00,494.00,760.00,494.00,0.00,'2022-06-07 16:29:36'),(106,'21','227',1,'Retail Sale Id 107',0.00,995.60,760.00,995.60,0.00,'2022-06-07 16:30:51'),(107,'21','227',1,'Retail Sale Id 108',0.00,592.80,760.00,592.80,0.00,'2022-06-07 16:31:47'),(108,'21','227',1,'Retail Sale Id 109',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 16:35:55'),(109,'21','227',1,'Retail Sale Id 110',0.00,1900.00,760.00,1900.00,0.00,'2022-06-07 16:38:09'),(110,'21','227',1,'Retail Sale Id 111',0.00,995.60,760.00,995.60,0.00,'2022-06-07 16:42:42'),(111,'21','227',1,'Retail Sale Id 112',0.00,1694.80,760.00,1694.80,0.00,'2022-06-07 16:43:56'),(112,'21','227',1,'Retail Sale Id 113',0.00,995.60,760.00,995.60,0.00,'2022-06-07 16:45:25'),(113,'21','227',1,'Retail Sale Id 114',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 16:46:05'),(114,'21','227',1,'Retail Sale Id 115',0.00,760.00,760.00,760.00,0.00,'2022-06-07 16:49:32'),(115,'21','227',1,'Retail Sale Id 116',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 16:52:18'),(116,'21','227',1,'Retail Sale Id 117',0.00,760.00,760.00,760.00,0.00,'2022-06-07 16:55:35'),(117,'21','227',1,'Retail Sale Id 118',0.00,4993.20,760.00,4993.20,0.00,'2022-06-07 16:56:32'),(118,'21','227',1,'Retail Sale Id 119',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 16:57:15'),(119,'21','227',1,'Retail Sale Id 120',0.00,995.60,760.00,995.60,0.00,'2022-06-07 17:06:29'),(120,'21','227',1,'Retail Sale Id 121',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 17:08:26'),(121,'21','227',1,'Retail Sale Id 122',0.00,2994.40,760.00,2994.40,0.00,'2022-06-07 17:09:19'),(122,'21','227',1,'Retail Sale Id 123',0.00,995.60,760.00,995.60,0.00,'2022-06-07 17:15:51'),(123,'21','227',1,'Retail Sale Id 123',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 17:15:51'),(124,'21','227',1,'Retail Sale Id 124',0.00,4993.20,760.00,4993.20,0.00,'2022-06-07 17:19:39'),(125,'21','227',1,'Retail Sale Id 125',0.00,995.60,760.00,995.60,0.00,'2022-06-07 17:20:37'),(126,'21','227',1,'Retail Sale Id 126',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 17:22:41'),(127,'21','227',1,'Retail Sale Id 127',0.00,995.60,760.00,995.60,0.00,'2022-06-07 17:25:05'),(128,'21','227',1,'Retail Sale Id 128',0.00,995.60,760.00,995.60,0.00,'2022-06-07 17:26:25'),(129,'21','227',1,'Retail Sale Id 129',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 17:30:57'),(130,'21','227',1,'Retail Sale Id 130',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 17:32:04'),(131,'21','227',1,'Retail Sale Id 131',0.00,1299.60,760.00,1299.60,0.00,'2022-06-07 17:45:27'),(132,'21','227',1,'Retail Sale Id 132',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 17:48:47'),(133,'21','227',1,'Retail Sale Id 133',0.00,760.00,760.00,760.00,0.00,'2022-06-07 17:51:29'),(134,'21','227',1,'Retail Sale Id 134',0.00,2492.80,760.00,2492.80,0.00,'2022-06-07 17:52:23'),(135,'21','227',1,'Retail Sale Id 135',0.00,1520.00,760.00,1520.00,0.00,'2022-06-07 17:53:42'),(136,'21','227',1,'Retail Sale Id 136',0.00,4560.00,760.00,4560.00,0.00,'2022-06-07 17:54:26'),(137,'21','227',1,'Retail Sale Id 137',0.00,3997.60,760.00,3997.60,0.00,'2022-06-07 17:57:37'),(138,'21','227',1,'Retail Sale Id 138',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 17:59:16'),(139,'21','227',1,'Retail Sale Id 139',0.00,760.00,760.00,760.00,0.00,'2022-06-07 18:00:12'),(140,'21','227',1,'Retail Sale Id 140',0.00,1193.20,760.00,1193.20,0.00,'2022-06-07 18:00:58'),(141,'21','227',1,'Retail Sale Id 141',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 18:02:25'),(142,'21','227',1,'Retail Sale Id 142',0.00,995.60,760.00,995.60,0.00,'2022-06-07 18:04:31'),(143,'21','227',1,'Retail Sale Id 143',0.00,995.60,760.00,995.60,0.00,'2022-06-07 18:07:54'),(144,'21','227',1,'Retail Sale Id 144',0.00,995.60,760.00,995.60,0.00,'2022-06-07 18:13:29'),(145,'21','227',1,'Retail Sale Id 145',0.00,995.60,760.00,995.60,0.00,'2022-06-07 18:14:04'),(146,'21','227',1,'Retail Sale Id 146',0.00,995.60,760.00,995.60,0.00,'2022-06-07 18:15:03'),(147,'21','227',1,'Retail Sale Id 147',0.00,494.00,760.00,494.00,0.00,'2022-06-07 18:15:38'),(148,'21','227',1,'Retail Sale Id 148',0.00,995.60,760.00,995.60,0.00,'2022-06-07 18:16:24'),(149,'21','227',1,'Retail Sale Id 149',0.00,995.60,760.00,995.60,0.00,'2022-06-07 18:17:07'),(150,'21','227',1,'Retail Sale Id 150',0.00,9500.00,760.00,9500.00,0.00,'2022-06-07 18:23:40'),(151,'21','227',1,'Retail Sale Id 151',0.00,1520.00,760.00,1520.00,0.00,'2022-06-07 18:25:16'),(152,'21','227',1,'Retail Sale Id 152',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 18:26:15'),(153,'21','227',1,'Retail Sale Id 153',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 18:33:08'),(154,'21','227',1,'Retail Sale Id 154',0.00,9500.00,760.00,9500.00,0.00,'2022-06-07 18:34:50'),(155,'21','227',1,'Retail Sale Id 155',0.00,3997.60,760.00,3997.60,0.00,'2022-06-07 18:40:10'),(156,'21','227',1,'Retail Sale Id 156',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 18:41:20'),(157,'21','227',1,'Retail Sale Id 157',0.00,798.00,760.00,798.00,0.00,'2022-06-07 18:42:32'),(158,'21','227',1,'Retail Sale Id 158',0.00,1497.20,760.00,1497.20,0.00,'2022-06-07 18:45:12'),(159,'21','227',1,'Retail Sale Id 159',0.00,2280.00,760.00,2280.00,0.00,'2022-06-07 18:50:32'),(160,'21','227',1,'Retail Sale Id 160',0.00,3800.00,760.00,3800.00,0.00,'2022-06-07 18:51:26'),(161,'21','227',1,'Retail Sale Id 161',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 18:54:40'),(162,'21','227',1,'Retail Sale Id 162',0.00,995.60,760.00,995.60,0.00,'2022-06-07 18:55:51'),(163,'21','227',1,'Retail Sale Id 163',0.00,4560.00,760.00,4560.00,0.00,'2022-06-07 18:56:46'),(164,'21','227',1,'Retail Sale Id 164',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 18:57:57'),(165,'21','227',1,'Retail Sale Id 165',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 19:06:13'),(166,'21','227',1,'Retail Sale Id 90',0.00,1998.80,760.00,1998.80,0.00,'2022-06-07 19:07:38'),(167,'21','227',1,'Retail Sale Id 94',0.00,760.00,760.00,760.00,0.00,'2022-06-07 19:19:23'),(168,'21','227',1,'Retail Sale Id 166',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 07:15:48'),(169,'21','227',1,'Retail Sale Id 167',0.00,760.00,760.00,760.00,0.00,'2022-06-08 07:18:23'),(170,'21','227',1,'Retail Sale Id 168',0.00,4499.20,760.00,4499.20,0.00,'2022-06-08 07:40:40'),(171,'21','227',1,'Retail Sale Id 169',0.00,4993.20,760.00,4993.20,0.00,'2022-06-08 07:41:55'),(172,'21','227',1,'Retail Sale Id 170',0.00,2492.80,760.00,2492.80,0.00,'2022-06-08 07:43:56'),(173,'21','227',1,'Retail Sale Id 171',0.00,760.00,760.00,760.00,0.00,'2022-06-08 07:47:25'),(174,'21','227',1,'Retail Sale Id 172',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 08:09:23'),(175,'21','227',1,'Retail Sale Id 173',0.00,1299.60,760.00,1299.60,0.00,'2022-06-08 08:11:05'),(176,'21','227',1,'Retail Sale Id 174',0.00,1193.20,760.00,1193.20,0.00,'2022-06-08 08:26:22'),(177,'21','227',1,'Retail Sale Id 175',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 08:36:48'),(178,'21','227',1,'Retail Sale Id 176',0.00,995.60,760.00,995.60,0.00,'2022-06-08 08:42:09'),(179,'21','227',1,'Retail Sale Id 177',0.00,760.00,760.00,760.00,0.00,'2022-06-08 08:48:25'),(180,'21','227',1,'Retail Sale Id 178',0.00,760.00,760.00,760.00,0.00,'2022-06-08 08:49:57'),(181,'21','227',1,'Retail Sale Id 179',0.00,995.60,760.00,995.60,0.00,'2022-06-08 08:51:32'),(182,'21','227',1,'Retail Sale Id 180',0.00,2994.40,760.00,2994.40,0.00,'2022-06-08 09:00:42'),(183,'21','227',1,'Retail Sale Id 181',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 09:01:55'),(184,'21','227',1,'Retail Sale Id 182',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 09:04:00'),(185,'21','227',1,'Retail Sale Id 183',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 09:07:06'),(186,'21','227',1,'Retail Sale Id 184',0.00,494.00,760.00,494.00,0.00,'2022-06-08 09:12:39'),(187,'21','227',1,'Retail Sale Id 185',0.00,3800.00,760.00,3800.00,0.00,'2022-06-08 09:17:15'),(188,'21','227',1,'Retail Sale Id 187',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 09:29:43'),(189,'21','227',1,'Retail Sale Id 188',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 09:32:55'),(190,'21','227',1,'Retail Sale Id 189',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 09:34:21'),(191,'21','227',1,'Retail Sale Id 190',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 09:36:34'),(192,'21','227',1,'Retail Sale Id 191',0.00,995.60,760.00,995.60,0.00,'2022-06-08 09:38:16'),(193,'21','227',1,'Retail Sale Id 192',0.00,2492.80,760.00,2492.80,0.00,'2022-06-08 09:43:52'),(194,'21','227',1,'Retail Sale Id 193',0.00,3800.00,760.00,3800.00,0.00,'2022-06-08 09:52:27'),(195,'21','227',1,'Retail Sale Id 194',0.00,8360.00,760.00,8360.00,0.00,'2022-06-08 10:08:24'),(196,'21','227',1,'Retail Sale Id 195',0.00,3496.00,760.00,3496.00,0.00,'2022-06-08 10:14:01'),(197,'21','227',1,'Retail Sale Id 196',0.00,1193.20,760.00,1193.20,0.00,'2022-06-08 10:15:23'),(198,'21','227',1,'Retail Sale Id 197',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 10:18:52'),(199,'21','227',1,'Retail Sale Id 198',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 10:21:36'),(200,'21','227',1,'Retail Sale Id 199',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 10:26:35'),(201,'21','227',1,'Retail Sale Id 200',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 10:28:51'),(202,'21','227',1,'Retail Sale Id 201',0.00,3997.60,760.00,3997.60,0.00,'2022-06-08 10:30:19'),(203,'21','227',1,'Retail Sale Id 202',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 10:31:58'),(204,'21','227',1,'Retail Sale Id 203',0.00,995.60,760.00,995.60,0.00,'2022-06-08 10:37:41'),(205,'21','227',1,'Retail Sale Id 203',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 10:37:41'),(206,'21','227',1,'Retail Sale Id 204',0.00,995.60,760.00,995.60,0.00,'2022-06-08 10:53:20'),(207,'21','227',1,'Retail Sale Id 205',0.00,7600.00,760.00,7600.00,0.00,'2022-06-08 10:58:00'),(208,'21','227',1,'Retail Sale Id 205',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 10:58:00'),(209,'21','227',1,'Retail Sale Id 205',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 10:58:00'),(210,'21','227',1,'Retail Sale Id 206',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 11:02:52'),(211,'21','227',1,'Retail Sale Id 207',0.00,3997.60,760.00,3997.60,0.00,'2022-06-08 11:04:52'),(212,'21','227',1,'Retail Sale Id 208',0.00,995.60,760.00,995.60,0.00,'2022-06-08 11:11:07'),(213,'21','227',1,'Retail Sale Id 209',0.00,760.00,760.00,760.00,0.00,'2022-06-08 11:21:26'),(214,'21','227',1,'Retail Sale Id 210',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 11:23:56'),(215,'21','227',1,'Retail Sale Id 211',0.00,760.00,760.00,760.00,0.00,'2022-06-08 11:34:32'),(216,'21','227',1,'Retail Sale Id 212',0.00,699.20,760.00,699.20,0.00,'2022-06-08 11:46:04'),(217,'21','227',1,'Retail Sale Id 213',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 11:50:01'),(218,'21','227',1,'Retail Sale Id 214',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 11:52:41'),(219,'21','227',1,'Retail Sale Id 215',0.00,2994.40,760.00,2994.40,0.00,'2022-06-08 11:55:46'),(220,'21','227',1,'Retail Sale Id 216',0.00,995.60,760.00,995.60,0.00,'2022-06-08 12:11:22'),(221,'21','227',1,'Retail Sale Id 217',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 12:14:06'),(222,'21','227',1,'Retail Sale Id 218',0.00,995.60,760.00,995.60,0.00,'2022-06-08 12:16:00'),(223,'21','227',1,'Retail Sale Id 219',0.00,1520.00,760.00,1520.00,0.00,'2022-06-08 12:17:45'),(224,'21','227',1,'Retail Sale Id 220',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 12:39:52'),(225,'21','227',1,'Retail Sale Id 221',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 12:53:15'),(226,'21','227',1,'Retail Sale Id 222',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 13:00:15'),(227,'21','227',1,'Retail Sale Id 223',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 13:05:29'),(228,'21','227',1,'Retail Sale Id 224',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 13:20:55'),(229,'21','227',1,'Retail Sale Id 225',0.00,798.00,760.00,798.00,0.00,'2022-06-08 13:24:13'),(230,'21','227',1,'Retail Sale Id 226',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 13:30:50'),(231,'21','227',1,'Retail Sale Id 227',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 13:33:43'),(232,'21','227',1,'Retail Sale Id 228',0.00,995.60,760.00,995.60,0.00,'2022-06-08 13:38:04'),(233,'21','227',1,'Retail Sale Id 229',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 14:16:40'),(234,'21','227',1,'Retail Sale Id 230',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 14:19:05'),(235,'21','227',1,'Retail Sale Id 231',0.00,995.60,760.00,995.60,0.00,'2022-06-08 14:45:20'),(236,'21','227',1,'Retail Sale Id 232',0.00,3800.00,760.00,3800.00,0.00,'2022-06-08 14:55:56'),(237,'21','227',1,'Retail Sale Id 233',0.00,995.60,760.00,995.60,0.00,'2022-06-08 14:57:38'),(238,'21','227',1,'Retail Sale Id 234',0.00,4993.20,760.00,4993.20,0.00,'2022-06-08 15:02:16'),(239,'21','227',1,'Retail Sale Id 234',0.00,4993.20,760.00,4993.20,0.00,'2022-06-08 15:02:16'),(240,'21','227',1,'Retail Sale Id 235',0.00,1520.00,760.00,1520.00,0.00,'2022-06-08 15:03:36'),(241,'21','227',1,'Retail Sale Id 236',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 15:13:03'),(242,'21','227',1,'Retail Sale Id 237',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 15:20:11'),(243,'21','227',1,'Retail Sale Id 238',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 15:25:30'),(244,'21','227',1,'Retail Sale Id 239',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 15:33:34'),(245,'21','227',1,'Retail Sale Id 240',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 15:40:15'),(246,'21','227',1,'Retail Sale Id 241',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 15:47:56'),(247,'21','227',1,'Retail Sale Id 242',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 15:56:51'),(248,'21','227',1,'Retail Sale Id 243',0.00,995.60,760.00,995.60,0.00,'2022-06-08 15:59:11'),(249,'21','227',1,'Retail Sale Id 244',0.00,4560.00,760.00,4560.00,0.00,'2022-06-08 16:01:59'),(250,'21','227',1,'Retail Sale Id 245',0.00,2196.40,760.00,2196.40,0.00,'2022-06-08 16:04:19'),(251,'21','227',1,'Retail Sale Id 246',0.00,2994.40,760.00,2994.40,0.00,'2022-06-08 16:06:05'),(252,'21','227',1,'Retail Sale Id 247',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 16:11:24'),(253,'21','227',1,'Retail Sale Id 248',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 16:15:36'),(254,'21','227',1,'Retail Sale Id 249',0.00,2994.40,760.00,2994.40,0.00,'2022-06-08 16:22:47'),(255,'21','227',1,'Retail Sale Id 250',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 16:24:37'),(256,'21','227',1,'Retail Sale Id 251',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 16:27:53'),(257,'21','227',1,'Retail Sale Id 252',0.00,995.60,760.00,995.60,0.00,'2022-06-08 16:46:39'),(258,'21','227',1,'Retail Sale Id 253',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 16:47:28'),(259,'21','227',1,'Retail Sale Id 254',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 16:48:24'),(260,'21','227',1,'Retail Sale Id 255',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 16:51:16'),(261,'21','227',1,'Retail Sale Id 256',0.00,2994.40,760.00,2994.40,0.00,'2022-06-08 16:52:39'),(262,'21','227',1,'Retail Sale Id 257',0.00,1900.00,760.00,1900.00,0.00,'2022-06-08 16:53:52'),(263,'21','227',1,'Retail Sale Id 258',0.00,1793.60,760.00,1793.60,0.00,'2022-06-08 16:54:42'),(264,'21','227',1,'Retail Sale Id 259',0.00,3040.00,760.00,3040.00,0.00,'2022-06-08 16:57:12'),(265,'21','227',1,'Retail Sale Id 260',0.00,995.60,760.00,995.60,0.00,'2022-06-08 17:08:27'),(266,'21','227',1,'Retail Sale Id 261',0.00,3997.60,760.00,3997.60,0.00,'2022-06-08 17:10:23'),(267,'21','227',1,'Retail Sale Id 262',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 17:41:00'),(268,'21','227',1,'Retail Sale Id 263',0.00,4499.20,760.00,4499.20,0.00,'2022-06-08 17:42:13'),(269,'21','227',1,'Retail Sale Id 264',0.00,1900.00,760.00,1900.00,0.00,'2022-06-08 17:46:01'),(270,'21','227',1,'Retail Sale Id 265',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 17:46:49'),(271,'21','227',1,'Retail Sale Id 266',0.00,995.60,760.00,995.60,0.00,'2022-06-08 17:47:39'),(272,'21','227',1,'Retail Sale Id 267',0.00,995.60,760.00,995.60,0.00,'2022-06-08 17:48:20'),(273,'21','227',1,'Retail Sale Id 268',0.00,3040.00,760.00,3040.00,0.00,'2022-06-08 17:49:05'),(274,'21','227',1,'Retail Sale Id 269',0.00,1170.40,760.00,1170.40,0.00,'2022-06-08 17:50:19'),(275,'21','227',1,'Retail Sale Id 270',0.00,995.60,760.00,995.60,0.00,'2022-06-08 17:51:25'),(276,'21','227',1,'Retail Sale Id 271',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 17:52:20'),(277,'21','227',1,'Retail Sale Id 272',0.00,1520.00,760.00,1520.00,0.00,'2022-06-08 17:55:11'),(278,'21','227',1,'Retail Sale Id 273',0.00,995.60,760.00,995.60,0.00,'2022-06-08 17:56:00'),(279,'21','227',1,'Retail Sale Id 274',0.00,3800.00,760.00,3800.00,0.00,'2022-06-08 17:56:33'),(280,'21','227',1,'Retail Sale Id 275',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 17:57:24'),(281,'21','227',1,'Retail Sale Id 276',0.00,3199.60,760.00,3199.60,0.00,'2022-06-08 18:03:17'),(282,'21','227',1,'Retail Sale Id 277',0.00,2994.40,760.00,2994.40,0.00,'2022-06-08 18:04:18'),(283,'21','227',1,'Retail Sale Id 278',0.00,995.60,760.00,995.60,0.00,'2022-06-08 18:07:12'),(284,'21','227',1,'Retail Sale Id 279',0.00,592.80,760.00,592.80,0.00,'2022-06-08 18:08:46'),(285,'21','227',1,'Retail Sale Id 280',0.00,3997.60,760.00,3997.60,0.00,'2022-06-08 18:09:35'),(286,'21','227',1,'Retail Sale Id 281',0.00,3997.60,760.00,3997.60,0.00,'2022-06-08 18:10:39'),(287,'21','227',1,'Retail Sale Id 282',0.00,798.00,760.00,798.00,0.00,'2022-06-08 18:16:22'),(288,'21','227',1,'Retail Sale Id 283',0.00,995.60,760.00,995.60,0.00,'2022-06-08 18:21:31'),(289,'21','227',1,'Retail Sale Id 284',0.00,9500.00,760.00,9500.00,0.00,'2022-06-08 18:28:54'),(290,'21','227',1,'Retail Sale Id 285',0.00,995.60,760.00,995.60,0.00,'2022-06-08 18:29:39'),(291,'21','227',1,'Retail Sale Id 286',0.00,760.00,760.00,760.00,0.00,'2022-06-08 18:30:27'),(292,'21','227',1,'Retail Sale Id 287',0.00,995.60,760.00,995.60,0.00,'2022-06-08 18:31:12'),(293,'21','227',1,'Retail Sale Id 288',0.00,995.60,760.00,995.60,0.00,'2022-06-08 18:31:54'),(294,'21','227',1,'Retail Sale Id 289',0.00,2492.80,760.00,2492.80,0.00,'2022-06-08 18:32:54'),(295,'21','227',1,'Retail Sale Id 290',0.00,1998.80,760.00,1998.80,0.00,'2022-06-08 18:33:43'),(296,'21','227',1,'Retail Sale Id 291',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 18:34:33'),(297,'21','227',1,'Retail Sale Id 292',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 18:39:56'),(298,'21','227',1,'Retail Sale Id 293',0.00,699.20,760.00,699.20,0.00,'2022-06-08 18:42:48'),(299,'21','227',1,'Retail Sale Id 294',0.00,1520.00,760.00,1520.00,0.00,'2022-06-08 18:44:18'),(300,'21','227',1,'Retail Sale Id 295',0.00,1497.20,760.00,1497.20,0.00,'2022-06-08 18:46:27'),(301,'21','227',1,'Retail Sale Id 296',0.00,3040.00,760.00,3040.00,0.00,'2022-06-08 18:47:35'),(302,'21','227',1,'Retail Sale Id 297',0.00,494.00,760.00,494.00,0.00,'2022-06-08 18:50:00'),(303,'21','227',1,'Retail Sale Id 298',0.00,995.60,760.00,995.60,0.00,'2022-06-08 18:50:56'),(304,'21','227',1,'Retail Sale Id 299',0.00,494.00,760.00,494.00,0.00,'2022-06-08 18:52:57'),(305,'21','227',1,'Retail Sale Id 300',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 18:54:02'),(306,'21','227',1,'Retail Sale Id 300',0.00,3800.00,760.00,3800.00,0.00,'2022-06-08 18:54:02'),(307,'21','227',1,'Retail Sale Id 301',0.00,7600.00,760.00,7600.00,0.00,'2022-06-08 18:55:18'),(308,'21','227',1,'Retail Sale Id 302',0.00,2280.00,760.00,2280.00,0.00,'2022-06-08 18:56:46'),(309,'21','227',1,'Retail Sale Id 303',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 08:09:21'),(310,'21','227',1,'Retail Sale Id 304',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 08:12:20'),(311,'21','227',1,'Retail Sale Id 305',0.00,4560.00,760.00,4560.00,0.00,'2022-06-09 08:14:07'),(312,'21','227',1,'Retail Sale Id 306',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 08:17:35'),(313,'21','227',1,'Retail Sale Id 307',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 08:24:54'),(314,'21','227',1,'Retail Sale Id 308',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 08:28:48'),(315,'21','227',1,'Retail Sale Id 309',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 08:34:06'),(316,'21','227',1,'Retail Sale Id 310',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 08:51:16'),(317,'21','227',1,'Retail Sale Id 312',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 08:55:13'),(318,'21','227',1,'Retail Sale Id 313',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 09:01:14'),(319,'21','227',1,'Retail Sale Id 314',0.00,1451.60,760.00,1451.60,0.00,'2022-06-09 09:02:00'),(320,'21','227',1,'Retail Sale Id 315',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 09:03:03'),(321,'21','227',1,'Retail Sale Id 315',0.00,4560.00,760.00,4560.00,0.00,'2022-06-09 09:03:03'),(322,'21','227',1,'Retail Sale Id 316',0.00,995.60,760.00,995.60,0.00,'2022-06-09 09:04:13'),(323,'21','227',1,'Retail Sale Id 317',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 09:08:25'),(324,'21','227',1,'Retail Sale Id 318',0.00,1246.40,760.00,1246.40,0.00,'2022-06-09 09:09:12'),(325,'21','227',1,'Retail Sale Id 319',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 09:21:28'),(326,'21','227',1,'Retail Sale Id 321',0.00,760.00,760.00,760.00,0.00,'2022-06-09 09:35:52'),(327,'21','227',1,'Retail Sale Id 322',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 09:49:52'),(328,'21','227',1,'Retail Sale Id 324',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 10:02:02'),(329,'21','227',1,'Retail Sale Id 324',0.00,3997.60,760.00,3997.60,0.00,'2022-06-09 10:02:02'),(330,'21','227',1,'Retail Sale Id 326',0.00,3040.00,760.00,3040.00,0.00,'2022-06-09 10:04:23'),(331,'21','227',1,'Retail Sale Id 327',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 10:06:26'),(332,'21','227',1,'Retail Sale Id 328',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 10:12:40'),(333,'21','227',1,'Retail Sale Id 329',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 10:14:25'),(334,'21','227',1,'Retail Sale Id 330',0.00,1520.00,760.00,1520.00,0.00,'2022-06-09 10:18:07'),(335,'21','227',1,'Retail Sale Id 331',0.00,760.00,760.00,760.00,0.00,'2022-06-09 10:22:46'),(336,'21','227',1,'Retail Sale Id 332',0.00,4993.20,760.00,4993.20,0.00,'2022-06-09 10:43:31'),(337,'21','227',1,'Retail Sale Id 333',0.00,1900.00,760.00,1900.00,0.00,'2022-06-09 10:46:52'),(338,'21','227',1,'Retail Sale Id 334',0.00,494.00,760.00,494.00,0.00,'2022-06-09 11:04:50'),(339,'21','227',1,'Retail Sale Id 335',0.00,1094.40,760.00,1094.40,0.00,'2022-06-09 11:11:54'),(340,'21','227',1,'Retail Sale Id 336',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 11:13:07'),(341,'21','227',1,'Retail Sale Id 337',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 11:18:12'),(342,'21','227',1,'Retail Sale Id 338',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 11:23:12'),(343,'21','227',1,'Retail Sale Id 339',0.00,3496.00,760.00,3496.00,0.00,'2022-06-09 11:47:54'),(344,'21','227',1,'Retail Sale Id 340',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 11:53:51'),(345,'21','227',1,'Retail Sale Id 341',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 12:02:53'),(346,'21','227',1,'Retail Sale Id 342',0.00,1520.00,760.00,1520.00,0.00,'2022-06-09 12:04:30'),(347,'21','227',1,'Retail Sale Id 343',0.00,2492.80,760.00,2492.80,0.00,'2022-06-09 12:06:21'),(348,'21','227',1,'Retail Sale Id 343',0.00,2492.80,760.00,2492.80,0.00,'2022-06-09 12:06:21'),(349,'21','227',1,'Retail Sale Id 344',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 12:10:02'),(350,'21','227',1,'Retail Sale Id 345',0.00,995.60,760.00,995.60,0.00,'2022-06-09 12:11:33'),(351,'21','227',1,'Retail Sale Id 346',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 12:12:54'),(352,'21','227',1,'Retail Sale Id 347',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 12:16:24'),(353,'21','227',1,'Retail Sale Id 348',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 12:18:55'),(354,'21','227',1,'Retail Sale Id 349',0.00,1520.00,760.00,1520.00,0.00,'2022-06-09 12:23:33'),(355,'21','227',1,'Retail Sale Id 350',0.00,494.00,760.00,494.00,0.00,'2022-06-09 12:26:36'),(356,'21','227',1,'Retail Sale Id 351',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 12:28:59'),(357,'21','227',1,'Retail Sale Id 352',0.00,760.00,760.00,760.00,0.00,'2022-06-09 12:30:35'),(358,'21','227',1,'Retail Sale Id 353',0.00,760.00,760.00,760.00,0.00,'2022-06-09 12:31:20'),(359,'21','227',1,'Retail Sale Id 354',0.00,995.60,760.00,995.60,0.00,'2022-06-09 12:41:09'),(360,'21','227',1,'Retail Sale Id 355',0.00,1520.00,760.00,1520.00,0.00,'2022-06-09 12:42:30'),(361,'21','227',1,'Retail Sale Id 356',0.00,3997.60,760.00,3997.60,0.00,'2022-06-09 12:47:12'),(362,'21','227',1,'Retail Sale Id 357',0.00,1398.40,760.00,1398.40,0.00,'2022-06-09 12:57:19'),(363,'21','227',1,'Retail Sale Id 358',0.00,1398.40,760.00,1398.40,0.00,'2022-06-09 13:15:43'),(364,'21','227',1,'Retail Sale Id 358',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 13:15:43'),(365,'21','227',1,'Retail Sale Id 359',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 13:20:03'),(366,'21','227',1,'Retail Sale Id 360',0.00,798.00,760.00,798.00,0.00,'2022-06-09 13:22:14'),(367,'21','227',1,'Retail Sale Id 361',0.00,3496.00,760.00,3496.00,0.00,'2022-06-09 13:30:10'),(368,'21','227',1,'Retail Sale Id 362',0.00,798.00,760.00,798.00,0.00,'2022-06-09 13:34:55'),(369,'21','227',1,'Retail Sale Id 363',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 13:40:12'),(370,'21','227',1,'Retail Sale Id 363',0.00,9500.00,760.00,9500.00,0.00,'2022-06-09 13:40:12'),(371,'21','227',1,'Retail Sale Id 364',0.00,1520.00,760.00,1520.00,0.00,'2022-06-09 13:45:20'),(372,'21','227',1,'Retail Sale Id 365',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 13:47:19'),(373,'21','227',1,'Retail Sale Id 366',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 13:58:29'),(374,'21','227',1,'Retail Sale Id 366',0.00,4560.00,760.00,4560.00,0.00,'2022-06-09 13:58:29'),(375,'21','227',1,'Retail Sale Id 367',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 14:02:12'),(376,'21','227',1,'Retail Sale Id 368',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 14:05:36'),(377,'21','227',1,'Retail Sale Id 369',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 14:11:02'),(378,'21','227',1,'Retail Sale Id 370',0.00,760.00,760.00,760.00,0.00,'2022-06-09 14:18:45'),(379,'21','227',1,'Retail Sale Id 371',0.00,4560.00,760.00,4560.00,0.00,'2022-06-09 14:34:05'),(380,'21','227',1,'Retail Sale Id 372',0.00,995.60,760.00,995.60,0.00,'2022-06-09 14:36:14'),(381,'21','227',1,'Retail Sale Id 373',0.00,4560.00,760.00,4560.00,0.00,'2022-06-09 14:37:12'),(382,'21','227',1,'Retail Sale Id 374',0.00,494.00,760.00,494.00,0.00,'2022-06-09 14:40:39'),(383,'21','227',1,'Retail Sale Id 375',0.00,995.60,760.00,995.60,0.00,'2022-06-09 14:42:19'),(384,'21','227',1,'Retail Sale Id 376',0.00,995.60,760.00,995.60,0.00,'2022-06-09 14:43:29'),(385,'21','227',1,'Retail Sale Id 377',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 14:45:41'),(386,'21','227',1,'Retail Sale Id 378',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 14:52:06'),(387,'21','227',1,'Retail Sale Id 380',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 14:58:56'),(388,'21','227',1,'Retail Sale Id 381',0.00,995.60,760.00,995.60,0.00,'2022-06-09 15:04:35'),(389,'21','227',1,'Retail Sale Id 382',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 15:11:01'),(390,'21','227',1,'Retail Sale Id 383',0.00,4560.00,760.00,4560.00,0.00,'2022-06-09 15:13:38'),(391,'21','227',1,'Retail Sale Id 384',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 15:15:01'),(392,'21','227',1,'Retail Sale Id 385',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 15:27:44'),(393,'21','227',1,'Retail Sale Id 386',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 15:29:05'),(394,'21','227',1,'Retail Sale Id 388',0.00,3997.60,760.00,3997.60,0.00,'2022-06-09 16:05:30'),(395,'21','227',1,'Retail Sale Id 389',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 16:06:40'),(396,'21','227',1,'Retail Sale Id 390',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 16:13:38'),(397,'21','227',1,'Retail Sale Id 391',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 16:16:04'),(398,'21','227',1,'Retail Sale Id 392',0.00,760.00,760.00,760.00,0.00,'2022-06-09 16:18:04'),(399,'21','227',1,'Retail Sale Id 393',0.00,4560.00,760.00,4560.00,0.00,'2022-06-09 16:20:15'),(400,'21','227',1,'Retail Sale Id 394',0.00,995.60,760.00,995.60,0.00,'2022-06-09 16:21:38'),(401,'21','227',1,'Retail Sale Id 396',0.00,8998.40,760.00,8998.40,0.00,'2022-06-09 16:24:29'),(402,'21','227',1,'Retail Sale Id 396',0.00,8998.40,760.00,8998.40,0.00,'2022-06-09 16:24:29'),(403,'21','227',1,'Retail Sale Id 397',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 16:37:18'),(404,'21','227',1,'Retail Sale Id 398',0.00,1520.00,760.00,1520.00,0.00,'2022-06-09 16:47:28'),(405,'21','227',1,'Retail Sale Id 399',0.00,995.60,760.00,995.60,0.00,'2022-06-09 16:48:53'),(406,'21','227',1,'Retail Sale Id 400',0.00,2994.40,760.00,2994.40,0.00,'2022-06-09 16:50:44'),(407,'21','227',1,'Retail Sale Id 401',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 16:53:06'),(408,'21','227',1,'Retail Sale Id 402',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 17:00:29'),(409,'21','227',1,'Retail Sale Id 403',0.00,995.60,760.00,995.60,0.00,'2022-06-09 17:02:44'),(410,'21','227',1,'Retail Sale Id 404',0.00,2994.40,760.00,2994.40,0.00,'2022-06-09 17:04:17'),(411,'21','227',1,'Retail Sale Id 405',0.00,995.60,760.00,995.60,0.00,'2022-06-09 17:06:46'),(412,'21','227',1,'Retail Sale Id 407',0.00,4993.20,760.00,4993.20,0.00,'2022-06-09 17:12:59'),(413,'21','227',1,'Retail Sale Id 408',0.00,760.00,760.00,760.00,0.00,'2022-06-09 17:13:42'),(414,'21','227',1,'Retail Sale Id 409',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 17:14:13'),(415,'21','227',1,'Retail Sale Id 410',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 17:17:04'),(416,'21','227',1,'Retail Sale Id 411',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 17:20:18'),(417,'21','227',1,'Return of Retail Sale Id 410',2280.00,0.00,760.00,-2280.00,0.00,'2022-06-09 17:21:10'),(418,'21','227',1,'Retail Sale Id 412',0.00,760.00,760.00,760.00,0.00,'2022-06-09 17:29:02'),(419,'21','227',1,'Retail Sale Id 413',0.00,1193.20,760.00,1193.20,0.00,'2022-06-09 17:31:46'),(420,'21','227',1,'Retail Sale Id 414',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 17:35:11'),(421,'21','227',1,'Retail Sale Id 415',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 17:36:33'),(422,'21','227',1,'Retail Sale Id 416',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 17:37:16'),(423,'21','227',1,'Retail Sale Id 417',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 17:38:05'),(424,'21','227',1,'Retail Sale Id 418',0.00,1299.60,760.00,1299.60,0.00,'2022-06-09 17:42:23'),(425,'21','227',1,'Retail Sale Id 419',0.00,896.80,760.00,896.80,0.00,'2022-06-09 17:48:21'),(426,'21','227',1,'Retail Sale Id 420',0.00,995.60,760.00,995.60,0.00,'2022-06-09 17:49:28'),(427,'21','227',1,'Retail Sale Id 421',0.00,7600.00,760.00,7600.00,0.00,'2022-06-09 18:01:44'),(428,'21','227',1,'Retail Sale Id 422',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 18:04:18'),(429,'21','227',1,'Retail Sale Id 423',0.00,3800.00,760.00,3800.00,0.00,'2022-06-09 18:05:41'),(430,'21','227',1,'Retail Sale Id 424',0.00,1998.80,760.00,1998.80,0.00,'2022-06-09 18:12:31'),(431,'21','227',1,'Retail Sale Id 425',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 18:13:40'),(432,'21','227',1,'Retail Sale Id 426',0.00,18240.00,760.00,18240.00,0.00,'2022-06-09 18:16:44'),(433,'21','227',1,'Retail Sale Id 427',0.00,995.60,760.00,995.60,0.00,'2022-06-09 18:20:02'),(434,'21','227',1,'Retail Sale Id 428',0.00,9500.00,760.00,9500.00,0.00,'2022-06-09 18:23:18'),(435,'21','227',1,'Retail Sale Id 430',0.00,995.60,760.00,995.60,0.00,'2022-06-09 18:25:56'),(436,'21','227',1,'Retail Sale Id 431',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 18:27:45'),(437,'21','227',1,'Retail Sale Id 432',0.00,798.00,760.00,798.00,0.00,'2022-06-09 18:29:32'),(438,'21','227',1,'Retail Sale Id 433',0.00,1497.20,760.00,1497.20,0.00,'2022-06-09 18:32:47'),(439,'21','227',1,'Retail Sale Id 434',0.00,995.60,760.00,995.60,0.00,'2022-06-09 18:39:27'),(440,'21','227',1,'Retail Sale Id 435',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 18:43:39'),(441,'21','227',1,'Retail Sale Id 436',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 18:45:13'),(442,'21','227',1,'Retail Sale Id 437',0.00,4993.20,760.00,4993.20,0.00,'2022-06-09 18:46:07'),(443,'21','227',1,'Retail Sale Id 438',0.00,1193.20,760.00,1193.20,0.00,'2022-06-09 18:48:09'),(444,'21','227',1,'Retail Sale Id 439',0.00,1193.20,760.00,1193.20,0.00,'2022-06-09 18:54:36'),(445,'21','227',1,'Retail Sale Id 440',0.00,2280.00,760.00,2280.00,0.00,'2022-06-09 19:01:39'),(446,'21','227',1,'Retail Sale Id 441',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 08:20:30'),(447,'21','227',1,'Retail Sale Id 442',0.00,995.60,760.00,995.60,0.00,'2022-06-10 08:22:01'),(448,'21','227',1,'Retail Sale Id 443',0.00,2492.80,760.00,2492.80,0.00,'2022-06-10 08:22:47'),(449,'21','227',1,'Retail Sale Id 444',0.00,2492.80,760.00,2492.80,0.00,'2022-06-10 08:23:19'),(450,'21','227',1,'Retail Sale Id 445',0.00,3997.60,760.00,3997.60,0.00,'2022-06-10 08:23:54'),(451,'21','227',1,'Retail Sale Id 446',0.00,5996.40,760.00,5996.40,0.00,'2022-06-10 08:24:30'),(452,'21','227',1,'Retail Sale Id 447',0.00,2295.20,760.00,2295.20,0.00,'2022-06-10 08:25:04'),(453,'21','227',1,'Retail Sale Id 448',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 08:26:08'),(454,'21','227',1,'Retail Sale Id 449',0.00,494.00,760.00,494.00,0.00,'2022-06-10 08:27:07'),(455,'21','227',1,'Retail Sale Id 450',0.00,995.60,760.00,995.60,0.00,'2022-06-10 08:27:55'),(456,'21','227',1,'Retail Sale Id 451',0.00,592.80,760.00,592.80,0.00,'2022-06-10 08:28:27'),(457,'21','227',1,'Retail Sale Id 452',0.00,1497.20,760.00,1497.20,0.00,'2022-06-10 08:28:56'),(458,'21','227',1,'Retail Sale Id 453',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 08:29:45'),(459,'21','227',1,'Retail Sale Id 453',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 08:29:45'),(460,'21','227',1,'Retail Sale Id 454',0.00,3997.60,760.00,3997.60,0.00,'2022-06-10 08:31:24'),(461,'21','227',1,'Retail Sale Id 455',0.00,1900.00,760.00,1900.00,0.00,'2022-06-10 08:32:31'),(462,'21','227',1,'Retail Sale Id 456',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 08:33:15'),(463,'21','227',1,'Retail Sale Id 457',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 08:45:14'),(464,'21','227',1,'Retail Sale Id 458',0.00,2295.20,760.00,2295.20,0.00,'2022-06-10 09:13:15'),(465,'21','227',1,'Retail Sale Id 459',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 09:14:34'),(466,'21','227',1,'Retail Sale Id 460',0.00,1497.20,760.00,1497.20,0.00,'2022-06-10 09:15:45'),(467,'21','227',1,'Retail Sale Id 461',0.00,4560.00,760.00,4560.00,0.00,'2022-06-10 09:16:25'),(468,'21','227',1,'Retail Sale Id 462',0.00,4560.00,760.00,4560.00,0.00,'2022-06-10 09:17:02'),(469,'21','227',1,'Retail Sale Id 463',0.00,995.60,760.00,995.60,0.00,'2022-06-10 09:17:34'),(470,'21','227',1,'Retail Sale Id 464',0.00,4560.00,760.00,4560.00,0.00,'2022-06-10 09:18:02'),(471,'21','227',1,'Retail Sale Id 465',0.00,8496.80,760.00,8496.80,0.00,'2022-06-10 09:33:10'),(472,'21','227',1,'Retail Sale Id 466',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 09:41:38'),(473,'21','227',1,'Retail Sale Id 467',0.00,995.60,760.00,995.60,0.00,'2022-06-10 09:42:33'),(474,'21','227',1,'Retail Sale Id 468',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 09:43:26'),(475,'21','227',1,'Retail Sale Id 469',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 09:55:28'),(476,'21','227',1,'Retail Sale Id 470',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 10:05:12'),(477,'21','227',1,'Retail Sale Id 471',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 10:06:03'),(478,'21','227',1,'Retail Sale Id 472',0.00,4560.00,760.00,4560.00,0.00,'2022-06-10 10:07:14'),(479,'21','227',1,'Retail Sale Id 473',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 10:08:20'),(480,'21','227',1,'Retail Sale Id 474',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 11:27:55'),(481,'21','227',1,'Retail Sale Id 475',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 11:28:41'),(482,'21','227',1,'Retail Sale Id 476',0.00,1900.00,760.00,1900.00,0.00,'2022-06-10 11:29:40'),(483,'21','227',1,'Retail Sale Id 477',0.00,798.00,760.00,798.00,0.00,'2022-06-10 11:31:31'),(484,'21','227',1,'Retail Sale Id 478',0.00,2196.40,760.00,2196.40,0.00,'2022-06-10 11:32:14'),(485,'21','227',1,'Retail Sale Id 479',0.00,995.60,760.00,995.60,0.00,'2022-06-10 11:32:48'),(486,'21','227',1,'Retail Sale Id 480',0.00,760.00,760.00,760.00,0.00,'2022-06-10 11:33:24'),(487,'21','227',1,'Retail Sale Id 481',0.00,1793.60,760.00,1793.60,0.00,'2022-06-10 11:34:05'),(488,'21','227',1,'Retail Sale Id 482',0.00,995.60,760.00,995.60,0.00,'2022-06-10 11:34:39'),(489,'21','227',1,'Retail Sale Id 483',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 11:35:19'),(490,'21','227',1,'Retail Sale Id 484',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 11:36:05'),(491,'21','227',1,'Retail Sale Id 485',0.00,4993.20,760.00,4993.20,0.00,'2022-06-10 11:36:40'),(492,'21','227',1,'Retail Sale Id 486',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 11:37:19'),(493,'21','227',1,'Retail Sale Id 487',0.00,4499.20,760.00,4499.20,0.00,'2022-06-10 11:37:51'),(494,'21','227',1,'Retail Sale Id 488',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 11:38:24'),(495,'21','227',1,'Retail Sale Id 489',0.00,1793.60,760.00,1793.60,0.00,'2022-06-10 11:39:05'),(496,'21','227',1,'Retail Sale Id 490',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 11:39:43'),(497,'21','227',1,'Retail Sale Id 491',0.00,3040.00,760.00,3040.00,0.00,'2022-06-10 11:40:45'),(498,'21','227',1,'Retail Sale Id 492',0.00,995.60,760.00,995.60,0.00,'2022-06-10 11:43:05'),(499,'21','227',1,'Retail Sale Id 493',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 11:49:00'),(500,'21','227',1,'Retail Sale Id 494',0.00,4560.00,760.00,4560.00,0.00,'2022-06-10 12:02:25'),(501,'21','227',1,'Retail Sale Id 494',0.00,4560.00,760.00,4560.00,0.00,'2022-06-10 12:02:25'),(502,'21','227',1,'Retail Sale Id 495',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 12:05:02'),(503,'21','227',1,'Retail Sale Id 495',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 12:05:02'),(504,'21','227',1,'Retail Sale Id 496',0.00,995.60,760.00,995.60,0.00,'2022-06-10 12:05:56'),(505,'21','227',1,'Retail Sale Id 497',0.00,7600.00,760.00,7600.00,0.00,'2022-06-10 12:06:42'),(506,'21','227',1,'Retail Sale Id 498',0.00,1596.00,760.00,1596.00,0.00,'2022-06-10 12:07:55'),(507,'21','227',1,'Retail Sale Id 499',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 12:10:08'),(508,'21','227',1,'Retail Sale Id 499',0.00,3800.00,760.00,3800.00,0.00,'2022-06-10 12:10:08'),(509,'21','227',1,'Retail Sale Id 500',0.00,760.00,760.00,760.00,0.00,'2022-06-10 12:10:44'),(510,'21','227',1,'Retail Sale Id 501',0.00,6992.00,760.00,6992.00,0.00,'2022-06-10 12:23:19'),(511,'21','227',1,'Retail Sale Id 502',0.00,1497.20,760.00,1497.20,0.00,'2022-06-10 12:23:48'),(512,'21','227',1,'Retail Sale Id 503',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 12:24:21'),(513,'21','227',1,'Retail Sale Id 504',0.00,235.60,760.00,235.60,0.00,'2022-06-10 12:25:38'),(514,'21','227',1,'Retail Sale Id 506',0.00,1497.20,760.00,1497.20,0.00,'2022-06-10 12:31:54'),(515,'21','227',1,'Retail Sale Id 507',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 12:35:21'),(516,'21','227',1,'Retail Sale Id 508',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 12:36:34'),(517,'21','227',1,'Retail Sale Id 509',0.00,699.20,760.00,699.20,0.00,'2022-06-10 12:46:39'),(518,'21','227',1,'Retail Sale Id 510',0.00,1497.20,760.00,1497.20,0.00,'2022-06-10 12:49:37'),(519,'21','227',1,'Retail Sale Id 511',0.00,995.60,760.00,995.60,0.00,'2022-06-10 13:46:55'),(520,'21','227',1,'Retail Sale Id 512',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 13:49:44'),(521,'21','227',1,'Retail Sale Id 513',0.00,3800.00,760.00,3800.00,0.00,'2022-06-10 13:50:29'),(522,'21','227',1,'Retail Sale Id 514',0.00,1520.00,760.00,1520.00,0.00,'2022-06-10 13:51:57'),(523,'21','227',1,'Retail Sale Id 514',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 13:51:57'),(524,'21','227',1,'Retail Sale Id 514',0.00,7600.00,760.00,7600.00,0.00,'2022-06-10 13:51:57'),(525,'21','227',1,'Retail Sale Id 515',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 13:52:29'),(526,'21','227',1,'Retail Sale Id 516',0.00,3800.00,760.00,3800.00,0.00,'2022-06-10 13:54:35'),(527,'21','227',1,'Retail Sale Id 517',0.00,5996.40,760.00,5996.40,0.00,'2022-06-10 13:55:29'),(528,'21','227',1,'Retail Sale Id 518',0.00,494.00,760.00,494.00,0.00,'2022-06-10 14:10:02'),(529,'21','227',1,'Retail Sale Id 519',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 14:15:14'),(530,'21','227',1,'Retail Sale Id 520',0.00,1520.00,760.00,1520.00,0.00,'2022-06-10 14:15:50'),(531,'21','227',1,'Retail Sale Id 521',0.00,995.60,760.00,995.60,0.00,'2022-06-10 14:16:25'),(532,'21','227',1,'Retail Sale Id 522',0.00,3800.00,760.00,3800.00,0.00,'2022-06-10 14:16:56'),(533,'21','227',1,'Retail Sale Id 523',0.00,896.80,760.00,896.80,0.00,'2022-06-10 14:19:27'),(534,'21','227',1,'Retail Sale Id 524',0.00,1520.00,760.00,1520.00,0.00,'2022-06-10 14:20:17'),(535,'21','227',1,'Retail Sale Id 525',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 14:21:11'),(536,'21','227',1,'Retail Sale Id 526',0.00,798.00,760.00,798.00,0.00,'2022-06-10 14:22:00'),(537,'21','227',1,'Retail Sale Id 527',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 14:23:25'),(538,'21','227',1,'Retail Sale Id 528',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 14:24:19'),(539,'21','227',1,'Retail Sale Id 529',0.00,1520.00,760.00,1520.00,0.00,'2022-06-10 14:29:59'),(540,'21','227',1,'Retail Sale Id 530',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 14:30:56'),(541,'21','227',1,'Retail Sale Id 531',0.00,4560.00,760.00,4560.00,0.00,'2022-06-10 14:33:44'),(542,'21','227',1,'Retail Sale Id 532',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 14:35:30'),(543,'21','227',1,'Retail Sale Id 533',0.00,1497.20,760.00,1497.20,0.00,'2022-06-10 14:36:16'),(544,'21','227',1,'Retail Sale Id 534',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 14:37:30'),(545,'21','227',1,'Retail Sale Id 535',0.00,3496.00,760.00,3496.00,0.00,'2022-06-10 14:52:58'),(546,'21','227',1,'Retail Sale Id 536',0.00,7980.00,760.00,7980.00,0.00,'2022-06-10 14:56:04'),(547,'21','227',1,'Retail Sale Id 537',0.00,3800.00,760.00,3800.00,0.00,'2022-06-10 14:58:30'),(548,'21','227',1,'Retail Sale Id 538',0.00,1520.00,760.00,1520.00,0.00,'2022-06-10 15:00:21'),(549,'21','227',1,'Retail Sale Id 539',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 15:04:23'),(550,'21','227',1,'Retail Sale Id 540',0.00,4993.20,760.00,4993.20,0.00,'2022-06-10 17:29:40'),(551,'21','227',1,'Retail Sale Id 541',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 17:30:44'),(552,'21','227',1,'Retail Sale Id 542',0.00,60800.00,760.00,60800.00,0.00,'2022-06-10 17:33:50'),(553,'21','227',1,'Retail Sale Id 543',0.00,995.60,760.00,995.60,0.00,'2022-06-10 17:34:28'),(554,'21','227',1,'Retail Sale Id 544',0.00,995.60,760.00,995.60,0.00,'2022-06-10 17:35:28'),(555,'21','227',1,'Retail Sale Id 545',0.00,3800.00,760.00,3800.00,0.00,'2022-06-10 17:36:03'),(556,'21','227',1,'Retail Sale Id 546',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:36:39'),(557,'21','227',1,'Retail Sale Id 547',0.00,3040.00,760.00,3040.00,0.00,'2022-06-10 17:37:12'),(558,'21','227',1,'Retail Sale Id 548',0.00,1398.40,760.00,1398.40,0.00,'2022-06-10 17:37:59'),(559,'21','227',1,'Retail Sale Id 549',0.00,3040.00,760.00,3040.00,0.00,'2022-06-10 17:38:34'),(560,'21','227',1,'Retail Sale Id 550',0.00,995.60,760.00,995.60,0.00,'2022-06-10 17:39:10'),(561,'21','227',1,'Retail Sale Id 551',0.00,4560.00,760.00,4560.00,0.00,'2022-06-10 17:40:02'),(562,'21','227',1,'Retail Sale Id 552',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:40:58'),(563,'21','227',1,'Retail Sale Id 553',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:41:44'),(564,'21','227',1,'Retail Sale Id 554',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:43:50'),(565,'21','227',1,'Retail Sale Id 554',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:43:50'),(566,'21','227',1,'Retail Sale Id 555',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:44:31'),(567,'21','227',1,'Retail Sale Id 556',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 17:45:17'),(568,'21','227',1,'Retail Sale Id 557',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:46:00'),(569,'21','227',1,'Retail Sale Id 558',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:46:52'),(570,'21','227',1,'Retail Sale Id 559',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:47:39'),(571,'21','227',1,'Retail Sale Id 559',0.00,3800.00,760.00,3800.00,0.00,'2022-06-10 17:47:39'),(572,'21','227',1,'Retail Sale Id 560',0.00,2492.80,760.00,2492.80,0.00,'2022-06-10 17:49:09'),(573,'21','227',1,'Retail Sale Id 561',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 17:51:29'),(574,'21','227',1,'Retail Sale Id 562',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 17:52:00'),(575,'21','227',1,'Retail Sale Id 563',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 17:52:39'),(576,'21','227',1,'Retail Sale Id 564',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 17:53:44'),(577,'21','227',1,'Retail Sale Id 565',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 17:54:16'),(578,'21','227',1,'Retail Sale Id 566',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 17:54:50'),(579,'21','227',1,'Retail Sale Id 567',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 17:55:29'),(580,'21','227',1,'Retail Sale Id 568',0.00,1193.20,760.00,1193.20,0.00,'2022-06-10 17:56:30'),(581,'21','227',1,'Retail Sale Id 569',0.00,995.60,760.00,995.60,0.00,'2022-06-10 17:57:24'),(582,'21','227',1,'Retail Sale Id 570',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 17:58:16'),(583,'21','227',1,'Retail Sale Id 571',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 17:58:59'),(584,'21','227',1,'Retail Sale Id 572',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 18:00:06'),(585,'21','227',1,'Retail Sale Id 573',0.00,995.60,760.00,995.60,0.00,'2022-06-10 18:00:51'),(586,'21','227',1,'Retail Sale Id 574',0.00,2492.80,760.00,2492.80,0.00,'2022-06-10 18:01:35'),(587,'21','227',1,'Retail Sale Id 575',0.00,4993.20,760.00,4993.20,0.00,'2022-06-10 18:02:18'),(588,'21','227',1,'Retail Sale Id 576',0.00,494.00,760.00,494.00,0.00,'2022-06-10 18:03:22'),(589,'21','227',1,'Retail Sale Id 576',0.00,1998.80,760.00,1998.80,0.00,'2022-06-10 18:03:22'),(590,'21','227',1,'Retail Sale Id 577',0.00,3800.00,760.00,3800.00,0.00,'2022-06-10 18:05:51'),(591,'21','227',1,'Retail Sale Id 578',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 18:10:26'),(592,'21','227',1,'Retail Sale Id 579',0.00,995.60,760.00,995.60,0.00,'2022-06-10 18:11:20'),(593,'21','227',1,'Retail Sale Id 580',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 18:14:40'),(594,'21','227',1,'Retail Sale Id 581',0.00,995.60,760.00,995.60,0.00,'2022-06-10 18:15:47'),(595,'21','227',1,'Retail Sale Id 581',0.00,1497.20,760.00,1497.20,0.00,'2022-06-10 18:15:47'),(596,'21','227',1,'Retail Sale Id 582',0.00,995.60,760.00,995.60,0.00,'2022-06-10 18:16:31'),(597,'21','227',1,'Retail Sale Id 583',0.00,798.00,760.00,798.00,0.00,'2022-06-10 18:17:36'),(598,'21','227',1,'Retail Sale Id 584',0.00,798.00,760.00,798.00,0.00,'2022-06-10 18:20:40'),(599,'21','227',1,'Retail Sale Id 585',0.00,2994.40,760.00,2994.40,0.00,'2022-06-10 18:22:03'),(600,'21','227',1,'Retail Sale Id 586',0.00,2280.00,760.00,2280.00,0.00,'2022-06-10 18:25:14'),(601,'21','227',1,'Retail Sale Id 587',0.00,995.60,760.00,995.60,0.00,'2022-06-10 18:28:06'),(602,'21','227',1,'Retail Sale Id 588',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 18:43:27'),(603,'21','227',1,'Retail Sale Id 588',0.00,9500.00,760.00,9500.00,0.00,'2022-06-10 18:43:27'),(604,'21','227',1,'Retail Sale Id 589',0.00,15200.00,760.00,15200.00,0.00,'2022-06-10 18:44:14'),(605,'21','227',1,'Retail Sale Id 590',0.00,11400.00,760.00,11400.00,0.00,'2022-06-10 18:44:40'),(606,'21','227',1,'Retail Sale Id 591',0.00,13680.00,760.00,13680.00,0.00,'2022-06-10 18:45:19'),(607,'21','227',1,'Retail Sale Id 592',0.00,16720.00,760.00,16720.00,0.00,'2022-06-10 18:45:48'),(608,'21','227',1,'Retail Sale Id 593',0.00,4278.80,760.00,4278.80,0.00,'2022-06-10 18:46:20'),(609,'21','227',1,'Retail Sale Id 594',0.00,3800.00,760.00,3800.00,0.00,'2022-06-11 08:45:56'),(610,'21','227',1,'Retail Sale Id 595',0.00,3800.00,760.00,3800.00,0.00,'2022-06-11 08:47:34'),(611,'21','227',1,'Retail Sale Id 596',0.00,494.00,760.00,494.00,0.00,'2022-06-11 08:48:52'),(612,'21','227',1,'Retail Sale Id 597',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 08:50:05'),(613,'21','227',1,'Retail Sale Id 598',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 08:51:35'),(614,'21','227',1,'Retail Sale Id 599',0.00,995.60,760.00,995.60,0.00,'2022-06-11 08:53:19'),(615,'21','227',1,'Retail Sale Id 600',0.00,2492.80,760.00,2492.80,0.00,'2022-06-11 08:54:42'),(616,'21','227',1,'Retail Sale Id 601',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 08:56:10'),(617,'21','227',1,'Retail Sale Id 602',0.00,7995.20,760.00,7995.20,0.00,'2022-06-11 08:58:39'),(618,'21','227',1,'Retail Sale Id 603',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 08:59:44'),(619,'21','227',1,'Retail Sale Id 604',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 09:01:57'),(620,'21','227',1,'Retail Sale Id 605',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 09:03:45'),(621,'21','227',1,'Retail Sale Id 606',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 09:05:22'),(622,'21','227',1,'Retail Sale Id 607',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 09:07:16'),(623,'21','227',1,'Retail Sale Id 608',0.00,4499.20,760.00,4499.20,0.00,'2022-06-11 09:10:44'),(624,'21','227',1,'Retail Sale Id 609',0.00,2492.80,760.00,2492.80,0.00,'2022-06-11 09:14:08'),(625,'21','227',1,'Retail Sale Id 610',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 09:15:42'),(626,'21','227',1,'Retail Sale Id 611',0.00,1520.00,760.00,1520.00,0.00,'2022-06-11 09:16:46'),(627,'21','227',1,'Retail Sale Id 613',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 09:20:38'),(628,'21','227',1,'Retail Sale Id 614',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 09:22:37'),(629,'21','227',1,'Retail Sale Id 616',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 09:24:04'),(630,'21','227',1,'Retail Sale Id 617',0.00,3800.00,760.00,3800.00,0.00,'2022-06-11 09:26:36'),(631,'21','227',1,'Retail Sale Id 618',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 09:28:00'),(632,'21','227',1,'Retail Sale Id 619',0.00,995.60,760.00,995.60,0.00,'2022-06-11 09:29:10'),(633,'21','227',1,'Retail Sale Id 620',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 09:30:23'),(634,'21','227',1,'Retail Sale Id 621',0.00,3800.00,760.00,3800.00,0.00,'2022-06-11 09:34:56'),(635,'21','227',1,'Retail Sale Id 622',0.00,7995.20,760.00,7995.20,0.00,'2022-06-11 09:37:16'),(636,'21','227',1,'Retail Sale Id 623',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 09:38:55'),(637,'21','227',1,'Retail Sale Id 624',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 09:42:14'),(638,'21','227',1,'Retail Sale Id 625',0.00,760.00,760.00,760.00,0.00,'2022-06-11 09:46:32'),(639,'21','227',1,'Retail Sale Id 626',0.00,2492.80,760.00,2492.80,0.00,'2022-06-11 09:48:35'),(640,'21','227',1,'Retail Sale Id 627',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 09:49:41'),(641,'21','227',1,'Retail Sale Id 628',0.00,760.00,760.00,760.00,0.00,'2022-06-11 09:50:59'),(642,'21','227',1,'Retail Sale Id 629',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 09:55:00'),(643,'21','227',1,'Retail Sale Id 630',0.00,995.60,760.00,995.60,0.00,'2022-06-11 09:56:23'),(644,'21','227',1,'Retail Sale Id 631',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 09:57:21'),(645,'21','227',1,'Retail Sale Id 632',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 10:01:25'),(646,'21','227',1,'Retail Sale Id 632',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 10:01:25'),(647,'21','227',1,'Retail Sale Id 1114',0.00,760.00,760.00,760.00,0.00,'2022-06-11 10:32:07'),(648,'21','227',1,'Retail Sale Id 1115',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 10:33:40'),(649,'21','227',1,'Retail Sale Id 1116',0.00,149720.00,760.00,149720.00,0.00,'2022-06-11 10:34:41'),(650,'21','227',1,'Retail Sale Id 1117',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 10:36:55'),(651,'21','227',1,'Retail Sale Id 1118',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 12:06:02'),(652,'21','227',1,'Retail Sale Id 1119',0.00,6999.60,760.00,6999.60,0.00,'2022-06-11 12:11:05'),(653,'21','227',1,'Retail Sale Id 1120',0.00,798.00,760.00,798.00,0.00,'2022-06-11 12:14:58'),(654,'21','227',1,'Retail Sale Id 1121',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 12:16:01'),(655,'21','227',1,'Retail Sale Id 1122',0.00,798.00,760.00,798.00,0.00,'2022-06-11 12:17:05'),(656,'21','227',1,'Retail Sale Id 1123',0.00,699.20,760.00,699.20,0.00,'2022-06-11 12:19:00'),(657,'21','227',1,'Retail Sale Id 1124',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 12:20:58'),(658,'21','227',1,'Retail Sale Id 1125',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 12:22:05'),(659,'21','227',1,'Retail Sale Id 1126',0.00,3496.00,760.00,3496.00,0.00,'2022-06-11 12:24:49'),(660,'21','227',1,'Retail Sale Id 1127',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 12:26:25'),(661,'21','227',1,'Retail Sale Id 1128',0.00,995.60,760.00,995.60,0.00,'2022-06-11 12:27:28'),(662,'21','227',1,'Retail Sale Id 1129',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 12:36:09'),(663,'21','227',1,'Retail Sale Id 1130',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 13:43:13'),(664,'21','227',1,'Retail Sale Id 1131',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 13:48:12'),(665,'21','227',1,'Retail Sale Id 1132',0.00,760.00,760.00,760.00,0.00,'2022-06-11 14:12:46'),(666,'21','227',1,'Retail Sale Id 1133',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 14:56:34'),(667,'21','227',1,'Retail Sale Id 1134',0.00,1520.00,760.00,1520.00,0.00,'2022-06-11 14:58:27'),(668,'21','227',1,'Retail Sale Id 1135',0.00,1520.00,760.00,1520.00,0.00,'2022-06-11 14:59:51'),(669,'21','227',1,'Retail Sale Id 1136',0.00,995.60,760.00,995.60,0.00,'2022-06-11 15:01:04'),(670,'21','227',1,'Retail Sale Id 1137',0.00,3496.00,760.00,3496.00,0.00,'2022-06-11 15:07:29'),(671,'21','227',1,'Retail Sale Id 1138',0.00,3800.00,760.00,3800.00,0.00,'2022-06-11 15:09:54'),(672,'21','227',1,'Retail Sale Id 1139',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 15:15:43'),(673,'21','227',1,'Retail Sale Id 1140',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 15:16:51'),(674,'21','227',1,'Retail Sale Id 1141',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 15:17:53'),(675,'21','227',1,'Retail Sale Id 1142',0.00,1520.00,760.00,1520.00,0.00,'2022-06-11 15:19:03'),(676,'21','227',1,'Retail Sale Id 1143',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 15:21:28'),(677,'21','227',1,'Retail Sale Id 1144',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 15:22:27'),(678,'21','227',1,'Retail Sale Id 1145',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 15:24:27'),(679,'21','227',1,'Retail Sale Id 1146',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 15:46:19'),(680,'21','227',1,'Retail Sale Id 1147',0.00,995.60,760.00,995.60,0.00,'2022-06-11 15:48:32'),(681,'21','227',1,'Retail Sale Id 1148',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 15:58:27'),(682,'21','227',1,'Retail Sale Id 1149',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 16:08:32'),(683,'21','227',1,'Retail Sale Id 1150',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 16:26:26'),(684,'21','227',1,'Retail Sale Id 1151',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 16:28:21'),(685,'21','227',1,'Retail Sale Id 1152',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 16:42:38'),(686,'21','227',1,'Retail Sale Id 1153',0.00,11400.00,760.00,11400.00,0.00,'2022-06-11 16:54:57'),(687,'21','227',1,'Retail Sale Id 1154',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 16:55:56'),(688,'21','227',1,'Retail Sale Id 1155',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 16:57:07'),(689,'21','227',1,'Retail Sale Id 1156',0.00,760.00,760.00,760.00,0.00,'2022-06-11 16:59:47'),(690,'21','227',1,'Retail Sale Id 1157',0.00,760.00,760.00,760.00,0.00,'2022-06-11 17:02:02'),(691,'21','227',1,'Retail Sale Id 1158',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 17:02:35'),(692,'21','227',1,'Retail Sale Id 1159',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 17:06:14'),(693,'21','227',1,'Retail Sale Id 1160',0.00,995.60,760.00,995.60,0.00,'2022-06-11 17:07:20'),(694,'21','227',1,'Retail Sale Id 1161',0.00,7995.20,760.00,7995.20,0.00,'2022-06-11 17:11:53'),(695,'21','227',1,'Retail Sale Id 1162',0.00,1193.20,760.00,1193.20,0.00,'2022-06-11 17:13:42'),(696,'21','227',1,'Retail Sale Id 1162',0.00,1193.20,760.00,1193.20,0.00,'2022-06-11 17:13:42'),(697,'21','227',1,'Retail Sale Id 1163',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 17:14:44'),(698,'21','227',1,'Retail Sale Id 1164',0.00,494.00,760.00,494.00,0.00,'2022-06-11 17:15:46'),(699,'21','227',1,'Retail Sale Id 1165',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 17:16:59'),(700,'21','227',1,'Retail Sale Id 1166',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 17:19:37'),(701,'21','227',1,'Retail Sale Id 1167',0.00,3800.00,760.00,3800.00,0.00,'2022-06-11 17:23:29'),(702,'21','227',1,'Retail Sale Id 1168',0.00,38000.00,760.00,38000.00,0.00,'2022-06-11 17:31:39'),(703,'21','227',1,'Retail Sale Id 1169',0.00,425.60,760.00,425.60,0.00,'2022-06-11 17:36:05'),(704,'21','227',1,'Retail Sale Id 1170',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 17:36:49'),(705,'21','227',1,'Retail Sale Id 1171',0.00,699.20,760.00,699.20,0.00,'2022-06-11 17:38:08'),(706,'21','227',1,'Retail Sale Id 1172',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 17:38:54'),(707,'21','227',1,'Retail Sale Id 1173',0.00,1520.00,760.00,1520.00,0.00,'2022-06-11 17:40:23'),(708,'21','227',1,'Retail Sale Id 1174',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 17:46:57'),(709,'21','227',1,'Retail Sale Id 1175',0.00,2994.40,760.00,2994.40,0.00,'2022-06-11 17:47:49'),(710,'21','227',1,'Retail Sale Id 1176',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 17:48:48'),(711,'21','227',1,'Retail Sale Id 1177',0.00,3800.00,760.00,3800.00,0.00,'2022-06-11 17:50:15'),(712,'21','227',1,'Retail Sale Id 1178',0.00,995.60,760.00,995.60,0.00,'2022-06-11 18:00:56'),(713,'21','227',1,'Retail Sale Id 1179',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 18:02:22'),(714,'21','227',1,'Retail Sale Id 1180',0.00,995.60,760.00,995.60,0.00,'2022-06-11 18:04:02'),(715,'21','227',1,'Retail Sale Id 1181',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 18:05:35'),(716,'21','227',1,'Retail Sale Id 1182',0.00,7600.00,760.00,7600.00,0.00,'2022-06-11 18:06:49'),(717,'21','227',1,'Retail Sale Id 1183',0.00,995.60,760.00,995.60,0.00,'2022-06-11 18:10:10'),(718,'21','227',1,'Retail Sale Id 1184',0.00,4560.00,760.00,4560.00,0.00,'2022-06-11 18:10:47'),(719,'21','227',1,'Retail Sale Id 1185',0.00,798.00,760.00,798.00,0.00,'2022-06-11 18:11:42'),(720,'21','227',1,'Retail Sale Id 1186',0.00,7600.00,760.00,7600.00,0.00,'2022-06-11 18:14:54'),(721,'21','227',1,'Retail Sale Id 1187',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 18:16:21'),(722,'21','227',1,'Retail Sale Id 1187',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 18:16:21'),(723,'21','227',1,'Retail Sale Id 1188',0.00,798.00,760.00,798.00,0.00,'2022-06-11 18:17:14'),(724,'21','227',1,'Retail Sale Id 1189',0.00,4993.20,760.00,4993.20,0.00,'2022-06-11 18:19:14'),(725,'21','227',1,'Retail Sale Id 1190',0.00,2196.40,760.00,2196.40,0.00,'2022-06-11 18:21:20'),(726,'21','227',1,'Retail Sale Id 1191',0.00,3800.00,760.00,3800.00,0.00,'2022-06-11 18:23:21'),(727,'21','227',1,'Retail Sale Id 1192',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 18:26:21'),(728,'21','227',1,'Retail Sale Id 1193',0.00,2796.80,760.00,2796.80,0.00,'2022-06-11 18:31:29'),(729,'21','227',1,'Retail Sale Id 1194',0.00,2280.00,760.00,2280.00,0.00,'2022-06-11 18:33:11'),(730,'21','227',1,'Retail Sale Id 1195',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 18:34:15'),(731,'21','227',1,'Retail Sale Id 1196',0.00,1998.80,760.00,1998.80,0.00,'2022-06-11 18:36:51'),(732,'21','227',1,'Retail Sale Id 1197',0.00,1497.20,760.00,1497.20,0.00,'2022-06-11 18:39:30'),(733,'21','227',1,'Retail Sale Id 1198',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 18:40:43'),(734,'21','227',1,'Retail Sale Id 1199',0.00,9500.00,760.00,9500.00,0.00,'2022-06-11 18:45:02'),(735,'21','227',1,'Retail Sale Id 1200',0.00,2196.40,760.00,2196.40,0.00,'2022-06-11 18:49:43'),(736,'21','227',1,'Retail Sale Id 1201',0.00,1520.00,760.00,1520.00,0.00,'2022-06-12 16:32:17'),(737,'21','227',1,'Retail Sale Id 1202',0.00,33994.80,760.00,33994.80,0.00,'2022-06-12 16:33:33'),(738,'21','227',1,'Retail Sale Id 1203',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 16:34:01'),(739,'21','227',1,'Retail Sale Id 1204',0.00,7600.00,760.00,7600.00,0.00,'2022-06-12 16:34:40'),(740,'21','227',1,'Retail Sale Id 1205',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 16:35:09'),(741,'21','227',1,'Retail Sale Id 1206',0.00,4560.00,760.00,4560.00,0.00,'2022-06-12 16:35:39'),(742,'21','227',1,'Retail Sale Id 1207',0.00,4560.00,760.00,4560.00,0.00,'2022-06-12 16:36:11'),(743,'21','227',1,'Retail Sale Id 1208',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 16:36:43'),(744,'21','227',1,'Retail Sale Id 1209',0.00,995.60,760.00,995.60,0.00,'2022-06-12 16:37:15'),(745,'21','227',1,'Retail Sale Id 1210',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 16:38:00'),(746,'21','227',1,'Retail Sale Id 1211',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 16:38:35'),(747,'21','227',1,'Retail Sale Id 1212',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 16:39:05'),(748,'21','227',1,'Retail Sale Id 1213',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 16:39:35'),(749,'21','227',1,'Retail Sale Id 1214',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 16:40:26'),(750,'21','227',1,'Retail Sale Id 1215',0.00,3040.00,760.00,3040.00,0.00,'2022-06-12 16:41:02'),(751,'21','227',1,'Retail Sale Id 1216',0.00,995.60,760.00,995.60,0.00,'2022-06-12 16:42:19'),(752,'21','227',1,'Retail Sale Id 1217',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 16:43:57'),(753,'21','227',1,'Retail Sale Id 1218',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 16:44:25'),(754,'21','227',1,'Retail Sale Id 1219',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 16:44:56'),(755,'21','227',1,'Retail Sale Id 1220',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 16:45:22'),(756,'21','227',1,'Retail Sale Id 1221',0.00,699.20,760.00,699.20,0.00,'2022-06-12 16:45:52'),(757,'21','227',1,'Retail Sale Id 1222',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 16:46:26'),(758,'21','227',1,'Retail Sale Id 1223',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 16:47:12'),(759,'21','227',1,'Retail Sale Id 1224',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 16:47:55'),(760,'21','227',1,'Retail Sale Id 1225',0.00,1900.00,760.00,1900.00,0.00,'2022-06-12 16:49:14'),(761,'21','227',1,'Retail Sale Id 1226',0.00,995.60,760.00,995.60,0.00,'2022-06-12 16:49:48'),(762,'21','227',1,'Retail Sale Id 1227',0.00,4499.20,760.00,4499.20,0.00,'2022-06-12 16:50:25'),(763,'21','227',1,'Retail Sale Id 1228',0.00,760.00,760.00,760.00,0.00,'2022-06-12 16:51:00'),(764,'21','227',1,'Retail Sale Id 1229',0.00,995.60,760.00,995.60,0.00,'2022-06-12 16:54:14'),(765,'21','227',1,'Retail Sale Id 1230',0.00,1193.20,760.00,1193.20,0.00,'2022-06-12 16:54:44'),(766,'21','227',1,'Retail Sale Id 1231',0.00,995.60,760.00,995.60,0.00,'2022-06-12 16:55:18'),(767,'21','227',1,'Retail Sale Id 1232',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 16:55:57'),(768,'21','227',1,'Retail Sale Id 1233',0.00,995.60,760.00,995.60,0.00,'2022-06-12 16:56:38'),(769,'21','227',1,'Retail Sale Id 1234',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 16:57:24'),(770,'21','227',1,'Retail Sale Id 1235',0.00,760.00,760.00,760.00,0.00,'2022-06-12 16:58:03'),(771,'21','227',1,'Retail Sale Id 1236',0.00,2295.20,760.00,2295.20,0.00,'2022-06-12 16:58:43'),(772,'21','227',1,'Retail Sale Id 1237',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 16:59:25'),(773,'21','227',1,'Retail Sale Id 1238',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 16:59:54'),(774,'21','227',1,'Retail Sale Id 1239',0.00,760.00,760.00,760.00,0.00,'2022-06-12 17:00:19'),(775,'21','227',1,'Retail Sale Id 1240',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:00:48'),(776,'21','227',1,'Retail Sale Id 1241',0.00,7600.00,760.00,7600.00,0.00,'2022-06-12 17:01:19'),(777,'21','227',1,'Retail Sale Id 1242',0.00,4499.20,760.00,4499.20,0.00,'2022-06-12 17:01:54'),(778,'21','227',1,'Retail Sale Id 1243',0.00,4560.00,760.00,4560.00,0.00,'2022-06-12 17:02:34'),(779,'21','227',1,'Retail Sale Id 1244',0.00,7600.00,760.00,7600.00,0.00,'2022-06-12 17:03:06'),(780,'21','227',1,'Retail Sale Id 1245',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:03:33'),(781,'21','227',1,'Retail Sale Id 1246',0.00,2492.80,760.00,2492.80,0.00,'2022-06-12 17:04:24'),(782,'21','227',1,'Retail Sale Id 1247',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 17:05:07'),(783,'21','227',1,'Retail Sale Id 1248',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 17:05:51'),(784,'21','227',1,'Retail Sale Id 1249',0.00,4256.00,760.00,4256.00,0.00,'2022-06-12 17:08:53'),(785,'21','227',1,'Retail Sale Id 1250',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 17:10:26'),(786,'21','227',1,'Retail Sale Id 1251',0.00,2492.80,760.00,2492.80,0.00,'2022-06-12 17:10:57'),(787,'21','227',1,'Retail Sale Id 1252',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:11:45'),(788,'21','227',1,'Retail Sale Id 1253',0.00,1520.00,760.00,1520.00,0.00,'2022-06-12 17:12:43'),(789,'21','227',1,'Retail Sale Id 1254',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 17:13:33'),(790,'21','227',1,'Retail Sale Id 1255',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:14:14'),(791,'21','227',1,'Retail Sale Id 1256',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:14:53'),(792,'21','227',1,'Retail Sale Id 1257',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 17:15:39'),(793,'21','227',1,'Retail Sale Id 1258',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 17:16:23'),(794,'21','227',1,'Retail Sale Id 1259',0.00,1299.60,760.00,1299.60,0.00,'2022-06-12 17:16:56'),(795,'21','227',1,'Retail Sale Id 1260',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 17:17:31'),(796,'21','227',1,'Retail Sale Id 1261',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 17:17:57'),(797,'21','227',1,'Retail Sale Id 1262',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:18:29'),(798,'21','227',1,'Retail Sale Id 1263',0.00,760.00,760.00,760.00,0.00,'2022-06-12 17:19:04'),(799,'21','227',1,'Retail Sale Id 1264',0.00,1694.80,760.00,1694.80,0.00,'2022-06-12 17:19:34'),(800,'21','227',1,'Retail Sale Id 1265',0.00,13999.20,760.00,13999.20,0.00,'2022-06-12 17:20:08'),(801,'21','227',1,'Retail Sale Id 1266',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 17:20:40'),(802,'21','227',1,'Retail Sale Id 1267',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 17:21:10'),(803,'21','227',1,'Retail Sale Id 1268',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:21:44'),(804,'21','227',1,'Retail Sale Id 1269',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 17:22:22'),(805,'21','227',1,'Retail Sale Id 1270',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 17:22:59'),(806,'21','227',1,'Retail Sale Id 1271',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 17:24:17'),(807,'21','227',1,'Retail Sale Id 1272',0.00,3997.60,760.00,3997.60,0.00,'2022-06-12 17:25:03'),(808,'21','227',1,'Retail Sale Id 1273',0.00,798.00,760.00,798.00,0.00,'2022-06-12 17:25:40'),(809,'21','227',1,'Retail Sale Id 1274',0.00,19000.00,760.00,19000.00,0.00,'2022-06-12 17:26:29'),(810,'21','227',1,'Retail Sale Id 1275',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 17:27:37'),(811,'21','227',1,'Retail Sale Id 1276',0.00,494.00,760.00,494.00,0.00,'2022-06-12 17:28:20'),(812,'21','227',1,'Retail Sale Id 1277',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:28:59'),(813,'21','227',1,'Retail Sale Id 1278',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 17:29:44'),(814,'21','227',1,'Retail Sale Id 1279',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:30:26'),(815,'21','227',1,'Retail Sale Id 1280',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 17:31:56'),(816,'21','227',1,'Retail Sale Id 1281',0.00,494.00,760.00,494.00,0.00,'2022-06-12 17:32:41'),(817,'21','227',1,'Retail Sale Id 1282',0.00,1793.60,760.00,1793.60,0.00,'2022-06-12 17:33:20'),(818,'21','227',1,'Retail Sale Id 1283',0.00,494.00,760.00,494.00,0.00,'2022-06-12 17:34:13'),(819,'21','227',1,'Retail Sale Id 1284',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:34:42'),(820,'21','227',1,'Retail Sale Id 1285',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:35:30'),(821,'21','227',1,'Retail Sale Id 1286',0.00,6992.00,760.00,6992.00,0.00,'2022-06-12 17:35:59'),(822,'21','227',1,'Retail Sale Id 1287',0.00,2796.80,760.00,2796.80,0.00,'2022-06-12 17:36:26'),(823,'21','227',1,'Retail Sale Id 1288',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 17:37:09'),(824,'21','227',1,'Retail Sale Id 1289',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:37:59'),(825,'21','227',1,'Retail Sale Id 1290',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:38:52'),(826,'21','227',1,'Retail Sale Id 1291',0.00,760.00,760.00,760.00,0.00,'2022-06-12 17:39:28'),(827,'21','227',1,'Retail Sale Id 1292',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:40:13'),(828,'21','227',1,'Retail Sale Id 1293',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 17:40:46'),(829,'21','227',1,'Retail Sale Id 1294',0.00,3997.60,760.00,3997.60,0.00,'2022-06-12 17:41:19'),(830,'21','227',1,'Retail Sale Id 1295',0.00,3997.60,760.00,3997.60,0.00,'2022-06-12 17:42:22'),(831,'21','227',1,'Retail Sale Id 1296',0.00,4560.00,760.00,4560.00,0.00,'2022-06-12 17:42:53'),(832,'21','227',1,'Retail Sale Id 1297',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 17:43:25'),(833,'21','227',1,'Retail Sale Id 1298',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:43:55'),(834,'21','227',1,'Retail Sale Id 1299',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:44:31'),(835,'21','227',1,'Retail Sale Id 1300',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 17:45:02'),(836,'21','227',1,'Retail Sale Id 1301',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 17:45:43'),(837,'21','227',1,'Retail Sale Id 1302',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:46:21'),(838,'21','227',1,'Retail Sale Id 1303',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 17:46:55'),(839,'21','227',1,'Retail Sale Id 1304',0.00,995.60,760.00,995.60,0.00,'2022-06-12 17:47:41'),(840,'21','227',1,'Retail Sale Id 1305',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:48:09'),(841,'21','227',1,'Retail Sale Id 1306',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:48:41'),(842,'21','227',1,'Retail Sale Id 1307',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:49:15'),(843,'21','227',1,'Retail Sale Id 1308',0.00,4993.20,760.00,4993.20,0.00,'2022-06-12 17:55:19'),(844,'21','227',1,'Retail Sale Id 1309',0.00,592.80,760.00,592.80,0.00,'2022-06-12 17:55:56'),(845,'21','227',1,'Retail Sale Id 1310',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 17:56:37'),(846,'21','227',1,'Retail Sale Id 1311',0.00,2492.80,760.00,2492.80,0.00,'2022-06-12 17:57:11'),(847,'21','227',1,'Retail Sale Id 1312',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 17:57:54'),(848,'21','227',1,'Retail Sale Id 1313',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 17:58:20'),(849,'21','227',1,'Retail Sale Id 1314',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 17:58:48'),(850,'21','227',1,'Retail Sale Id 1315',0.00,7600.00,760.00,7600.00,0.00,'2022-06-12 17:59:16'),(851,'21','227',1,'Retail Sale Id 1316',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 17:59:42'),(852,'21','227',1,'Retail Sale Id 1317',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 18:00:06'),(853,'21','227',1,'Retail Sale Id 1318',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 18:00:39'),(854,'21','227',1,'Retail Sale Id 1319',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 18:01:07'),(855,'21','227',1,'Retail Sale Id 1320',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 18:01:36'),(856,'21','227',1,'Retail Sale Id 1321',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 18:02:09'),(857,'21','227',1,'Retail Sale Id 1322',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:02:40'),(858,'21','227',1,'Retail Sale Id 1323',0.00,2280.00,760.00,2280.00,0.00,'2022-06-12 18:03:10'),(859,'21','227',1,'Retail Sale Id 1324',0.00,3997.60,760.00,3997.60,0.00,'2022-06-12 18:03:58'),(860,'21','227',1,'Retail Sale Id 1325',0.00,1793.60,760.00,1793.60,0.00,'2022-06-12 18:04:45'),(861,'21','227',1,'Retail Sale Id 1326',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:05:18'),(862,'21','227',1,'Retail Sale Id 1327',0.00,14994.80,760.00,14994.80,0.00,'2022-06-12 18:05:47'),(863,'21','227',1,'Retail Sale Id 1328',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 18:06:17'),(864,'21','227',1,'Retail Sale Id 1329',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 18:06:47'),(865,'21','227',1,'Retail Sale Id 1330',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:07:10'),(866,'21','227',1,'Retail Sale Id 1331',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 18:07:34'),(867,'21','227',1,'Retail Sale Id 1332',0.00,760.00,760.00,760.00,0.00,'2022-06-12 18:08:02'),(868,'21','227',1,'Retail Sale Id 1333',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 18:08:43'),(869,'21','227',1,'Retail Sale Id 1334',0.00,896.80,760.00,896.80,0.00,'2022-06-12 18:09:30'),(870,'21','227',1,'Retail Sale Id 1335',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:10:08'),(871,'21','227',1,'Retail Sale Id 1336',0.00,3800.00,760.00,3800.00,0.00,'2022-06-12 18:10:41'),(872,'21','227',1,'Retail Sale Id 1337',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 18:11:21'),(873,'21','227',1,'Retail Sale Id 1338',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 18:12:13'),(874,'21','227',1,'Retail Sale Id 1339',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:12:46'),(875,'21','227',1,'Retail Sale Id 1340',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:13:36'),(876,'21','227',1,'Retail Sale Id 1341',0.00,6794.40,760.00,6794.40,0.00,'2022-06-12 18:14:12'),(877,'21','227',1,'Retail Sale Id 1342',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 18:14:46'),(878,'21','227',1,'Retail Sale Id 1343',0.00,2994.40,760.00,2994.40,0.00,'2022-06-12 18:15:25'),(879,'21','227',1,'Retail Sale Id 1344',0.00,1998.80,760.00,1998.80,0.00,'2022-06-12 18:15:55'),(880,'21','227',1,'Retail Sale Id 1345',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:16:39'),(881,'21','227',1,'Retail Sale Id 1346',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:17:10'),(882,'21','227',1,'Retail Sale Id 1347',0.00,798.00,760.00,798.00,0.00,'2022-06-12 18:17:44'),(883,'21','227',1,'Retail Sale Id 1348',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:23:03'),(884,'21','227',1,'Retail Sale Id 1349',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:30:34'),(885,'21','227',1,'Retail Sale Id 1350',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 18:31:25'),(886,'21','227',1,'Retail Sale Id 1351',0.00,1497.20,760.00,1497.20,0.00,'2022-06-12 18:32:38'),(887,'21','227',1,'Retail Sale Id 1352',0.00,1193.20,760.00,1193.20,0.00,'2022-06-12 18:34:04'),(888,'21','227',1,'Retail Sale Id 1353',0.00,995.60,760.00,995.60,0.00,'2022-06-12 18:35:15'),(889,'21','227',1,'Retail Sale Id 1354',0.00,760.00,760.00,760.00,0.00,'2022-06-12 18:37:49'),(890,'21','227',1,'Retail Sale Id 1355',0.00,9500.00,760.00,9500.00,0.00,'2022-06-12 18:39:13'),(891,'21','227',1,'Retail Sale Id 1356',0.00,760.00,760.00,760.00,0.00,'2022-06-12 18:52:29'),(892,'21','227',1,'Retail Sale Id 1357',0.00,1193.20,760.00,1193.20,0.00,'2022-06-13 16:42:27'),(893,'21','227',1,'Retail Sale Id 1358',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 16:42:57'),(894,'21','227',1,'Retail Sale Id 1359',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 16:43:36'),(895,'21','227',1,'Retail Sale Id 1360',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 16:44:06'),(896,'21','227',1,'Retail Sale Id 1361',0.00,7600.00,760.00,7600.00,0.00,'2022-06-13 16:44:42'),(897,'21','227',1,'Retail Sale Id 1362',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 16:45:20'),(898,'21','227',1,'Retail Sale Id 1363',0.00,3800.00,760.00,3800.00,0.00,'2022-06-13 16:45:51'),(899,'21','227',1,'Retail Sale Id 1364',0.00,7600.00,760.00,7600.00,0.00,'2022-06-13 16:46:26'),(900,'21','227',1,'Retail Sale Id 1365',0.00,1398.40,760.00,1398.40,0.00,'2022-06-13 16:47:08'),(901,'21','227',1,'Retail Sale Id 1366',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 16:47:37'),(902,'21','227',1,'Retail Sale Id 1367',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 16:48:05'),(903,'21','227',1,'Retail Sale Id 1368',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 16:48:34'),(904,'21','227',1,'Retail Sale Id 1369',0.00,995.60,760.00,995.60,0.00,'2022-06-13 16:49:06'),(905,'21','227',1,'Retail Sale Id 1370',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 16:49:44'),(906,'21','227',1,'Retail Sale Id 1371',0.00,3800.00,760.00,3800.00,0.00,'2022-06-13 16:50:08'),(907,'21','227',1,'Retail Sale Id 1372',0.00,3800.00,760.00,3800.00,0.00,'2022-06-13 16:50:37'),(908,'21','227',1,'Retail Sale Id 1373',0.00,7600.00,760.00,7600.00,0.00,'2022-06-13 16:51:04'),(909,'21','227',1,'Retail Sale Id 1374',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 16:51:31'),(910,'21','227',1,'Retail Sale Id 1375',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 16:52:06'),(911,'21','227',1,'Retail Sale Id 1376',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 16:52:33'),(912,'21','227',1,'Retail Sale Id 1377',0.00,2994.40,760.00,2994.40,0.00,'2022-06-13 16:53:01'),(913,'21','227',1,'Retail Sale Id 1378',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 16:53:28'),(914,'21','227',1,'Retail Sale Id 1379',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 16:53:56'),(915,'21','227',1,'Retail Sale Id 1380',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 16:54:26'),(916,'21','227',1,'Retail Sale Id 1381',0.00,995.60,760.00,995.60,0.00,'2022-06-13 16:54:56'),(917,'21','227',1,'Retail Sale Id 1382',0.00,995.60,760.00,995.60,0.00,'2022-06-13 16:55:42'),(918,'21','227',1,'Retail Sale Id 1383',0.00,896.80,760.00,896.80,0.00,'2022-06-13 16:56:12'),(919,'21','227',1,'Retail Sale Id 1384',0.00,5996.40,760.00,5996.40,0.00,'2022-06-13 16:56:43'),(920,'21','227',1,'Retail Sale Id 1385',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 16:57:24'),(921,'21','227',1,'Retail Sale Id 1386',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 16:58:01'),(922,'21','227',1,'Retail Sale Id 1387',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 16:58:50'),(923,'21','227',1,'Retail Sale Id 1388',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 16:59:19'),(924,'21','227',1,'Retail Sale Id 1389',0.00,3040.00,760.00,3040.00,0.00,'2022-06-13 16:59:45'),(925,'21','227',1,'Retail Sale Id 1390',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 17:00:36'),(926,'21','227',1,'Retail Sale Id 1391',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 17:01:23'),(927,'21','227',1,'Retail Sale Id 1392',0.00,798.00,760.00,798.00,0.00,'2022-06-13 17:01:56'),(928,'21','227',1,'Retail Sale Id 1393',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 17:02:22'),(929,'21','227',1,'Retail Sale Id 1394',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 17:02:53'),(930,'21','227',1,'Retail Sale Id 1395',0.00,3800.00,760.00,3800.00,0.00,'2022-06-13 17:03:24'),(931,'21','227',1,'Retail Sale Id 1396',0.00,7600.00,760.00,7600.00,0.00,'2022-06-13 17:03:48'),(932,'21','227',1,'Retail Sale Id 1397',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 17:04:16'),(933,'21','227',1,'Retail Sale Id 1398',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:04:46'),(934,'21','227',1,'Retail Sale Id 1399',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 17:05:17'),(935,'21','227',1,'Retail Sale Id 1400',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:19:45'),(936,'21','227',1,'Retail Sale Id 1401',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 17:20:16'),(937,'21','227',1,'Retail Sale Id 1402',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:20:43'),(938,'21','227',1,'Retail Sale Id 1403',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 17:21:09'),(939,'21','227',1,'Retail Sale Id 1404',0.00,3496.00,760.00,3496.00,0.00,'2022-06-13 17:21:54'),(940,'21','227',1,'Retail Sale Id 1405',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:22:22'),(941,'21','227',1,'Retail Sale Id 1406',0.00,995.60,760.00,995.60,0.00,'2022-06-13 17:22:55'),(942,'21','227',1,'Retail Sale Id 1407',0.00,4993.20,760.00,4993.20,0.00,'2022-06-13 17:23:24'),(943,'21','227',1,'Retail Sale Id 1408',0.00,995.60,760.00,995.60,0.00,'2022-06-13 17:23:53'),(944,'21','227',1,'Retail Sale Id 1409',0.00,6498.00,760.00,6498.00,0.00,'2022-06-13 17:24:24'),(945,'21','227',1,'Retail Sale Id 1410',0.00,4947.60,760.00,4947.60,0.00,'2022-06-13 17:24:49'),(946,'21','227',1,'Retail Sale Id 1411',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 17:25:14'),(947,'21','227',1,'Retail Sale Id 1412',0.00,2994.40,760.00,2994.40,0.00,'2022-06-13 17:25:39'),(948,'21','227',1,'Retail Sale Id 1413',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:26:08'),(949,'21','227',1,'Retail Sale Id 1414',0.00,2994.40,760.00,2994.40,0.00,'2022-06-13 17:26:35'),(950,'21','227',1,'Retail Sale Id 1415',0.00,760.00,760.00,760.00,0.00,'2022-06-13 17:27:02'),(951,'21','227',1,'Retail Sale Id 1416',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 17:27:37'),(952,'21','227',1,'Retail Sale Id 1417',0.00,7600.00,760.00,7600.00,0.00,'2022-06-13 17:28:06'),(953,'21','227',1,'Retail Sale Id 1418',0.00,2994.40,760.00,2994.40,0.00,'2022-06-13 17:28:34'),(954,'21','227',1,'Retail Sale Id 1419',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 17:29:03'),(955,'21','227',1,'Retail Sale Id 1420',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 17:29:28'),(956,'21','227',1,'Retail Sale Id 1421',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 17:29:56'),(957,'21','227',1,'Retail Sale Id 1422',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:30:26'),(958,'21','227',1,'Retail Sale Id 1423',0.00,3997.60,760.00,3997.60,0.00,'2022-06-13 17:30:54'),(959,'21','227',1,'Retail Sale Id 1424',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:31:30'),(960,'21','227',1,'Retail Sale Id 1425',0.00,2994.40,760.00,2994.40,0.00,'2022-06-13 17:31:57'),(961,'21','227',1,'Retail Sale Id 1426',0.00,995.60,760.00,995.60,0.00,'2022-06-13 17:32:24'),(962,'21','227',1,'Retail Sale Id 1427',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 17:32:53'),(963,'21','227',1,'Retail Sale Id 1428',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:33:19'),(964,'21','227',1,'Retail Sale Id 1429',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:33:46'),(965,'21','227',1,'Retail Sale Id 1430',0.00,995.60,760.00,995.60,0.00,'2022-06-13 17:34:10'),(966,'21','227',1,'Retail Sale Id 1431',0.00,3800.00,760.00,3800.00,0.00,'2022-06-13 17:34:34'),(967,'21','227',1,'Retail Sale Id 1432',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:35:08'),(968,'21','227',1,'Retail Sale Id 1433',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:35:40'),(969,'21','227',1,'Retail Sale Id 1434',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:36:06'),(970,'21','227',1,'Retail Sale Id 1435',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:36:35'),(971,'21','227',1,'Retail Sale Id 1436',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 17:37:30'),(972,'21','227',1,'Retail Sale Id 1436',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 17:37:30'),(973,'21','227',1,'Retail Sale Id 1437',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:37:56'),(974,'21','227',1,'Retail Sale Id 1438',0.00,6999.60,760.00,6999.60,0.00,'2022-06-13 17:38:21'),(975,'21','227',1,'Retail Sale Id 1439',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:38:49'),(976,'21','227',1,'Retail Sale Id 1440',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:39:31'),(977,'21','227',1,'Retail Sale Id 1441',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 17:40:04'),(978,'21','227',1,'Retail Sale Id 1442',0.00,3997.60,760.00,3997.60,0.00,'2022-06-13 17:40:36'),(979,'21','227',1,'Retail Sale Id 1443',0.00,4993.20,760.00,4993.20,0.00,'2022-06-13 17:41:11'),(980,'21','227',1,'Retail Sale Id 1444',0.00,1793.60,760.00,1793.60,0.00,'2022-06-13 17:41:47'),(981,'21','227',1,'Retail Sale Id 1445',0.00,3040.00,760.00,3040.00,0.00,'2022-06-13 17:42:29'),(982,'21','227',1,'Retail Sale Id 1446',0.00,3997.60,760.00,3997.60,0.00,'2022-06-13 17:43:40'),(983,'21','227',1,'Retail Sale Id 1447',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:44:09'),(984,'21','227',1,'Retail Sale Id 1448',0.00,2994.40,760.00,2994.40,0.00,'2022-06-13 17:44:42'),(985,'21','227',1,'Retail Sale Id 1449',0.00,494.00,760.00,494.00,0.00,'2022-06-13 17:45:15'),(986,'21','227',1,'Retail Sale Id 1450',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:45:42'),(987,'21','227',1,'Retail Sale Id 1451',0.00,995.60,760.00,995.60,0.00,'2022-06-13 17:46:11'),(988,'21','227',1,'Retail Sale Id 1452',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 17:46:37'),(989,'21','227',1,'Retail Sale Id 1453',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:47:06'),(990,'21','227',1,'Retail Sale Id 1454',0.00,4993.20,760.00,4993.20,0.00,'2022-06-13 17:47:36'),(991,'21','227',1,'Retail Sale Id 1455',0.00,1193.20,760.00,1193.20,0.00,'2022-06-13 17:48:18'),(992,'21','227',1,'Retail Sale Id 1455',0.00,9500.00,760.00,9500.00,0.00,'2022-06-13 17:48:18'),(993,'21','227',1,'Retail Sale Id 1456',0.00,3017.20,760.00,3017.20,0.00,'2022-06-13 17:48:42'),(994,'21','227',1,'Retail Sale Id 1457',0.00,995.60,760.00,995.60,0.00,'2022-06-13 17:49:11'),(995,'21','227',1,'Retail Sale Id 1458',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:49:37'),(996,'21','227',1,'Retail Sale Id 1459',0.00,3800.00,760.00,3800.00,0.00,'2022-06-13 17:50:07'),(997,'21','227',1,'Retail Sale Id 1460',0.00,995.60,760.00,995.60,0.00,'2022-06-13 17:50:33'),(998,'21','227',1,'Retail Sale Id 1461',0.00,1900.00,760.00,1900.00,0.00,'2022-06-13 17:51:04'),(999,'21','227',1,'Retail Sale Id 1462',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 17:51:37'),(1000,'21','227',1,'Retail Sale Id 1463',0.00,1193.20,760.00,1193.20,0.00,'2022-06-13 18:13:52'),(1001,'21','227',1,'Retail Sale Id 1464',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 18:14:28'),(1002,'21','227',1,'Retail Sale Id 1465',0.00,995.60,760.00,995.60,0.00,'2022-06-13 18:15:14'),(1003,'21','227',1,'Retail Sale Id 1466',0.00,3997.60,760.00,3997.60,0.00,'2022-06-13 18:15:49'),(1004,'21','227',1,'Retail Sale Id 1467',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 18:16:27'),(1005,'21','227',1,'Retail Sale Id 1468',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 18:16:55'),(1006,'21','227',1,'Retail Sale Id 1469',0.00,995.60,760.00,995.60,0.00,'2022-06-13 18:17:28'),(1007,'21','227',1,'Retail Sale Id 1470',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 18:18:01'),(1008,'21','227',1,'Retail Sale Id 1471',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 18:18:36'),(1009,'21','227',1,'Retail Sale Id 1472',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 18:19:10'),(1010,'21','227',1,'Retail Sale Id 1473',0.00,2994.40,760.00,2994.40,0.00,'2022-06-13 18:19:42'),(1011,'21','227',1,'Retail Sale Id 1474',0.00,1520.00,760.00,1520.00,0.00,'2022-06-13 18:20:12'),(1012,'21','227',1,'Retail Sale Id 1475',0.00,4560.00,760.00,4560.00,0.00,'2022-06-13 18:20:46'),(1013,'21','227',1,'Retail Sale Id 1476',0.00,1193.20,760.00,1193.20,0.00,'2022-06-13 18:21:18'),(1014,'21','227',1,'Retail Sale Id 1477',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 18:21:59'),(1015,'21','227',1,'Retail Sale Id 1478',0.00,995.60,760.00,995.60,0.00,'2022-06-13 18:22:28'),(1016,'21','227',1,'Retail Sale Id 1479',0.00,2492.80,760.00,2492.80,0.00,'2022-06-13 18:23:04'),(1017,'21','227',1,'Retail Sale Id 1480',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 18:23:35'),(1018,'21','227',1,'Retail Sale Id 1481',0.00,760.00,760.00,760.00,0.00,'2022-06-13 18:24:04'),(1019,'21','227',1,'Retail Sale Id 1482',0.00,1998.80,760.00,1998.80,0.00,'2022-06-13 18:24:37'),(1020,'21','227',1,'Retail Sale Id 1483',0.00,760.00,760.00,760.00,0.00,'2022-06-13 18:25:12'),(1021,'21','227',1,'Retail Sale Id 1484',0.00,2492.80,760.00,2492.80,0.00,'2022-06-13 18:26:15'),(1022,'21','227',1,'Retail Sale Id 1485',0.00,995.60,760.00,995.60,0.00,'2022-06-13 18:26:43'),(1023,'21','227',1,'Retail Sale Id 1486',0.00,995.60,760.00,995.60,0.00,'2022-06-13 18:27:16'),(1024,'21','227',1,'Retail Sale Id 1487',0.00,4993.20,760.00,4993.20,0.00,'2022-06-13 18:27:45'),(1025,'21','227',1,'Retail Sale Id 1488',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 18:28:13'),(1026,'21','227',1,'Retail Sale Id 1489',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 18:28:45'),(1027,'21','227',1,'Retail Sale Id 1490',0.00,2280.00,760.00,2280.00,0.00,'2022-06-13 18:29:15'),(1028,'21','227',1,'Retail Sale Id 1491',0.00,2994.40,760.00,2994.40,0.00,'2022-06-13 18:34:59'),(1029,'21','227',1,'Retail Sale Id 1492',0.00,1497.20,760.00,1497.20,0.00,'2022-06-13 18:35:28'),(1030,'21','227',1,'Retail Sale Id 1493',0.00,995.60,760.00,995.60,0.00,'2022-06-13 18:35:58'),(1031,'21','227',1,'Retail Sale Id 1494',0.00,1520.00,760.00,1520.00,0.00,'2022-06-13 18:36:27'),(1032,'21','227',1,'Retail Sale Id 1495',0.00,995.60,760.00,995.60,0.00,'2022-06-13 18:36:55'),(1033,'21','227',1,'Retail Sale Id 1496',0.00,2211.60,760.00,2211.60,0.00,'2022-06-14 08:26:03'),(1034,'21','227',1,'Retail Sale Id 1497',0.00,9500.00,760.00,9500.00,0.00,'2022-06-14 08:29:13'),(1035,'21','227',1,'Retail Sale Id 1498',0.00,4560.00,760.00,4560.00,0.00,'2022-06-14 08:29:44'),(1036,'21','227',1,'Retail Sale Id 1499',0.00,2994.40,760.00,2994.40,0.00,'2022-06-14 08:30:14'),(1037,'21','227',1,'Retail Sale Id 1500',0.00,3800.00,760.00,3800.00,0.00,'2022-06-14 08:30:40'),(1038,'21','227',1,'Retail Sale Id 1501',0.00,7600.00,760.00,7600.00,0.00,'2022-06-14 08:31:09'),(1039,'21','227',1,'Retail Sale Id 1502',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 08:31:54'),(1040,'21','227',1,'Retail Sale Id 1503',0.00,4560.00,760.00,4560.00,0.00,'2022-06-14 08:34:07'),(1041,'21','227',1,'Retail Sale Id 1504',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 08:34:58'),(1042,'21','227',1,'Retail Sale Id 1505',0.00,798.00,760.00,798.00,0.00,'2022-06-14 08:35:26'),(1043,'21','227',1,'Retail Sale Id 1506',0.00,3800.00,760.00,3800.00,0.00,'2022-06-14 08:36:15'),(1044,'21','227',1,'Retail Sale Id 1507',0.00,995.60,760.00,995.60,0.00,'2022-06-14 08:36:58'),(1045,'21','227',1,'Retail Sale Id 1508',0.00,9500.00,760.00,9500.00,0.00,'2022-06-14 08:37:48'),(1046,'21','227',1,'Retail Sale Id 1509',0.00,995.60,760.00,995.60,0.00,'2022-06-14 08:39:14'),(1047,'21','227',1,'Retail Sale Id 1510',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 08:45:26'),(1048,'21','227',1,'Retail Sale Id 1511',0.00,3693.60,760.00,3693.60,0.00,'2022-06-14 08:47:09'),(1049,'21','227',1,'Retail Sale Id 1512',0.00,9500.00,760.00,9500.00,0.00,'2022-06-14 08:52:40'),(1050,'21','227',1,'Retail Sale Id 1513',0.00,9500.00,760.00,9500.00,0.00,'2022-06-14 08:53:56'),(1051,'21','227',1,'Retail Sale Id 1514',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 08:55:15'),(1052,'21','227',1,'Retail Sale Id 1515',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 09:08:52'),(1053,'21','227',1,'Retail Sale Id 1516',0.00,1793.60,760.00,1793.60,0.00,'2022-06-14 09:10:43'),(1054,'21','227',1,'Retail Sale Id 1517',0.00,2097.60,760.00,2097.60,0.00,'2022-06-14 09:11:57'),(1055,'21','227',1,'Retail Sale Id 1518',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 09:21:37'),(1056,'21','227',1,'Retail Sale Id 1519',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 09:22:29'),(1057,'21','227',1,'Retail Sale Id 1520',0.00,760.00,760.00,760.00,0.00,'2022-06-14 09:33:56'),(1058,'21','227',1,'Retail Sale Id 1521',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 09:35:50'),(1059,'21','227',1,'Retail Sale Id 1522',0.00,760.00,760.00,760.00,0.00,'2022-06-14 09:37:11'),(1060,'21','227',1,'Retail Sale Id 1523',0.00,494.00,760.00,494.00,0.00,'2022-06-14 09:39:47'),(1061,'21','227',1,'Retail Sale Id 1524',0.00,3800.00,760.00,3800.00,0.00,'2022-06-14 09:42:07'),(1062,'21','227',1,'Retail Sale Id 1525',0.00,1900.00,760.00,1900.00,0.00,'2022-06-14 09:45:30'),(1063,'21','227',1,'Retail Sale Id 1526',0.00,4560.00,760.00,4560.00,0.00,'2022-06-14 10:02:04'),(1064,'21','227',1,'Retail Sale Id 1527',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 10:12:22'),(1065,'21','227',1,'Retail Sale Id 1528',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 10:17:35'),(1066,'21','227',1,'Retail Sale Id 1529',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 10:19:25'),(1067,'21','227',1,'Retail Sale Id 1529',0.00,3997.60,760.00,3997.60,0.00,'2022-06-14 10:19:25'),(1068,'21','227',1,'Retail Sale Id 1530',0.00,995.60,760.00,995.60,0.00,'2022-06-14 10:24:39'),(1069,'21','227',1,'Retail Sale Id 1531',0.00,4750.00,760.00,4750.00,0.00,'2022-06-14 10:36:05'),(1070,'21','227',1,'Retail Sale Id 1532',0.00,2994.40,760.00,2994.40,0.00,'2022-06-14 10:38:58'),(1071,'21','227',1,'Retail Sale Id 1533',0.00,3800.00,760.00,3800.00,0.00,'2022-06-14 10:40:07'),(1072,'21','227',1,'Retail Sale Id 1534',0.00,1520.00,760.00,1520.00,0.00,'2022-06-14 10:42:53'),(1073,'21','227',1,'Retail Sale Id 1535',0.00,995.60,760.00,995.60,0.00,'2022-06-14 10:46:05'),(1074,'21','227',1,'Retail Sale Id 1536',0.00,5996.40,760.00,5996.40,0.00,'2022-06-14 10:46:36'),(1075,'21','227',1,'Retail Sale Id 1537',0.00,7493.60,760.00,7493.60,0.00,'2022-06-14 10:47:45'),(1076,'21','227',1,'Retail Sale Id 1538',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 11:01:42'),(1077,'21','227',1,'Retail Sale Id 1539',0.00,995.60,760.00,995.60,0.00,'2022-06-14 11:03:15'),(1078,'21','227',1,'Retail Sale Id 1540',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 11:07:57'),(1079,'21','227',1,'Retail Sale Id 1541',0.00,4560.00,760.00,4560.00,0.00,'2022-06-14 11:12:26'),(1080,'21','227',1,'Retail Sale Id 1542',0.00,995.60,760.00,995.60,0.00,'2022-06-14 11:14:35'),(1081,'21','227',1,'Retail Sale Id 1543',0.00,995.60,760.00,995.60,0.00,'2022-06-14 11:19:13'),(1082,'21','227',1,'Retail Sale Id 1545',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 11:25:27'),(1083,'21','227',1,'Retail Sale Id 1546',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 13:40:37'),(1084,'21','227',1,'Retail Sale Id 1547',0.00,9500.00,760.00,9500.00,0.00,'2022-06-14 13:41:14'),(1085,'21','227',1,'Retail Sale Id 1548',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 13:42:22'),(1086,'21','227',1,'Retail Sale Id 1549',0.00,1520.00,760.00,1520.00,0.00,'2022-06-14 13:43:13'),(1087,'21','227',1,'Retail Sale Id 1550',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 13:43:47'),(1088,'21','227',1,'Retail Sale Id 1551',0.00,1299.60,760.00,1299.60,0.00,'2022-06-14 13:44:21'),(1089,'21','227',1,'Retail Sale Id 1552',0.00,1520.00,760.00,1520.00,0.00,'2022-06-14 13:44:54'),(1090,'21','227',1,'Retail Sale Id 1553',0.00,995.60,760.00,995.60,0.00,'2022-06-14 13:45:27'),(1091,'21','227',1,'Retail Sale Id 1554',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 13:45:58'),(1092,'21','227',1,'Retail Sale Id 1555',0.00,8998.40,760.00,8998.40,0.00,'2022-06-14 13:46:34'),(1093,'21','227',1,'Retail Sale Id 1556',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 13:47:10'),(1094,'21','227',1,'Retail Sale Id 1557',0.00,995.60,760.00,995.60,0.00,'2022-06-14 13:47:46'),(1095,'21','227',1,'Retail Sale Id 1558',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 13:48:18'),(1096,'21','227',1,'Retail Sale Id 1559',0.00,8998.40,760.00,8998.40,0.00,'2022-06-14 13:48:59'),(1097,'21','227',1,'Retail Sale Id 1560',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 13:49:40'),(1098,'21','227',1,'Retail Sale Id 1561',0.00,995.60,760.00,995.60,0.00,'2022-06-14 13:50:19'),(1099,'21','227',1,'Retail Sale Id 1562',0.00,1520.00,760.00,1520.00,0.00,'2022-06-14 13:51:27'),(1100,'21','227',1,'Retail Sale Id 1563',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 13:52:15'),(1101,'21','227',1,'Retail Sale Id 1564',0.00,3800.00,760.00,3800.00,0.00,'2022-06-14 13:52:45'),(1102,'21','227',1,'Retail Sale Id 1565',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 13:53:16'),(1103,'21','227',1,'Retail Sale Id 1566',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 13:53:52'),(1104,'21','227',1,'Retail Sale Id 1567',0.00,7600.00,760.00,7600.00,0.00,'2022-06-14 13:54:25'),(1105,'21','227',1,'Retail Sale Id 1568',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 13:54:53'),(1106,'21','227',1,'Retail Sale Id 1569',0.00,896.80,760.00,896.80,0.00,'2022-06-14 13:55:33'),(1107,'21','227',1,'Retail Sale Id 1570',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 13:56:09'),(1108,'21','227',1,'Retail Sale Id 1571',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 13:56:43'),(1109,'21','227',1,'Retail Sale Id 1572',0.00,995.60,760.00,995.60,0.00,'2022-06-14 13:57:24'),(1110,'21','227',1,'Retail Sale Id 1573',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 13:58:22'),(1111,'21','227',1,'Retail Sale Id 1574',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 14:00:14'),(1112,'21','227',1,'Retail Sale Id 1575',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 14:05:31'),(1113,'21','227',1,'Retail Sale Id 1576',0.00,995.60,760.00,995.60,0.00,'2022-06-14 14:16:13'),(1114,'21','227',1,'Retail Sale Id 1577',0.00,1520.00,760.00,1520.00,0.00,'2022-06-14 14:38:57'),(1115,'21','227',1,'Retail Sale Id 1578',0.00,760.00,760.00,760.00,0.00,'2022-06-14 14:40:01'),(1116,'21','227',1,'Retail Sale Id 1579',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 14:41:05'),(1117,'21','227',1,'Retail Sale Id 1580',0.00,995.60,760.00,995.60,0.00,'2022-06-14 14:42:08'),(1118,'21','227',1,'Retail Sale Id 1580',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 14:42:08'),(1119,'21','227',1,'Retail Sale Id 1581',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 14:43:26'),(1120,'21','227',1,'Retail Sale Id 1582',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 14:44:10'),(1121,'21','227',1,'Retail Sale Id 1583',0.00,760.00,760.00,760.00,0.00,'2022-06-14 14:45:07'),(1122,'21','227',1,'Retail Sale Id 1584',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 14:45:41'),(1123,'21','227',1,'Retail Sale Id 1585',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 14:47:00'),(1124,'21','227',1,'Retail Sale Id 1587',0.00,798.00,760.00,798.00,0.00,'2022-06-14 14:47:50'),(1125,'21','227',1,'Retail Sale Id 1588',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 14:48:33'),(1126,'21','227',1,'Retail Sale Id 1589',0.00,995.60,760.00,995.60,0.00,'2022-06-14 14:49:45'),(1127,'21','227',1,'Retail Sale Id 1590',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 14:50:34'),(1128,'21','227',1,'Retail Sale Id 1591',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 14:53:03'),(1129,'21','227',1,'Retail Sale Id 1592',0.00,2994.40,760.00,2994.40,0.00,'2022-06-14 17:44:42'),(1130,'21','227',1,'Retail Sale Id 1593',0.00,494.00,760.00,494.00,0.00,'2022-06-14 17:45:14'),(1131,'21','227',1,'Retail Sale Id 1594',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 17:45:43'),(1132,'21','227',1,'Retail Sale Id 1595',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 17:46:08'),(1133,'21','227',1,'Retail Sale Id 1596',0.00,2280.00,760.00,2280.00,0.00,'2022-06-14 17:46:31'),(1134,'21','227',1,'Retail Sale Id 1597',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 17:46:57'),(1135,'21','227',1,'Retail Sale Id 1598',0.00,1497.20,760.00,1497.20,0.00,'2022-06-14 17:47:24'),(1136,'21','227',1,'Retail Sale Id 1599',0.00,1998.80,760.00,1998.80,0.00,'2022-06-14 17:47:48'),(1137,'21','227',1,'Retail Sale Id 1600',0.00,9500.00,760.00,9500.00,0.00,'2022-06-14 17:48:22'),(1138,'21','227',1,'Retail Sale Id 1601',0.00,9500.00,760.00,9500.00,0.00,'2022-06-14 18:17:13'),(1139,'21','227',1,'Retail Sale Id 1602',0.00,13680.00,760.00,13680.00,0.00,'2022-06-14 18:18:23'),(1140,'21','227',1,'Retail Sale Id 1603',0.00,8436.00,760.00,8436.00,0.00,'2022-06-14 18:19:00'),(1141,'21','227',1,'Retail Sale Id 1604',0.00,3997.60,760.00,3997.60,0.00,'2022-06-17 09:38:30'),(1142,'21','227',1,'Retail Sale Id 1605',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 09:40:24'),(1143,'21','227',1,'Retail Sale Id 1606',0.00,760.00,760.00,760.00,0.00,'2022-06-17 09:41:50'),(1144,'21','227',1,'Retail Sale Id 1607',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 09:43:02'),(1145,'21','227',1,'Retail Sale Id 1608',0.00,2492.80,760.00,2492.80,0.00,'2022-06-17 09:44:01'),(1146,'21','227',1,'Retail Sale Id 1609',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 09:44:41'),(1147,'21','227',1,'Retail Sale Id 1610',0.00,4750.00,760.00,4750.00,0.00,'2022-06-17 09:45:20'),(1148,'21','227',1,'Retail Sale Id 1611',0.00,2994.40,760.00,2994.40,0.00,'2022-06-17 09:46:02'),(1149,'21','227',1,'Retail Sale Id 1612',0.00,896.80,760.00,896.80,0.00,'2022-06-17 09:47:14'),(1150,'21','227',1,'Retail Sale Id 1613',0.00,798.00,760.00,798.00,0.00,'2022-06-17 09:48:20'),(1151,'21','227',1,'Retail Sale Id 1614',0.00,995.60,760.00,995.60,0.00,'2022-06-17 09:49:31'),(1152,'21','227',1,'Retail Sale Id 1615',0.00,995.60,760.00,995.60,0.00,'2022-06-17 09:50:53'),(1153,'21','227',1,'Retail Sale Id 1616',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 09:51:41'),(1154,'21','227',1,'Retail Sale Id 1617',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 09:52:25'),(1155,'21','227',1,'Retail Sale Id 1618',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 09:53:05'),(1156,'21','227',1,'Retail Sale Id 1619',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 09:53:39'),(1157,'21','227',1,'Retail Sale Id 1620',0.00,9500.00,760.00,9500.00,0.00,'2022-06-17 09:54:22'),(1158,'21','227',1,'Retail Sale Id 1621',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 09:54:53'),(1159,'21','227',1,'Retail Sale Id 1622',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 09:56:37'),(1160,'21','227',1,'Retail Sale Id 1623',0.00,2796.80,760.00,2796.80,0.00,'2022-06-17 09:59:56'),(1161,'21','227',1,'Retail Sale Id 1624',0.00,995.60,760.00,995.60,0.00,'2022-06-17 10:00:36'),(1162,'21','227',1,'Retail Sale Id 1625',0.00,1900.00,760.00,1900.00,0.00,'2022-06-17 10:04:36'),(1163,'21','227',1,'Retail Sale Id 1626',0.00,2994.40,760.00,2994.40,0.00,'2022-06-17 10:05:34'),(1164,'21','227',1,'Retail Sale Id 1627',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 10:06:26'),(1165,'21','227',1,'Retail Sale Id 1628',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 10:07:30'),(1166,'21','227',1,'Retail Sale Id 1629',0.00,995.60,760.00,995.60,0.00,'2022-06-17 10:08:30'),(1167,'21','227',1,'Retail Sale Id 1630',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 10:10:05'),(1168,'21','227',1,'Retail Sale Id 1631',0.00,798.00,760.00,798.00,0.00,'2022-06-17 10:12:37'),(1169,'21','227',1,'Retail Sale Id 1632',0.00,896.80,760.00,896.80,0.00,'2022-06-17 10:18:19'),(1170,'21','227',1,'Retail Sale Id 1633',0.00,896.80,760.00,896.80,0.00,'2022-06-17 10:23:49'),(1171,'21','227',1,'Retail Sale Id 1634',0.00,9500.00,760.00,9500.00,0.00,'2022-06-17 10:24:41'),(1172,'21','227',1,'Retail Sale Id 1635',0.00,798.00,760.00,798.00,0.00,'2022-06-17 10:27:04'),(1173,'21','227',1,'Retail Sale Id 1636',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 10:28:14'),(1174,'21','227',1,'Retail Sale Id 1637',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 10:31:57'),(1175,'21','227',1,'Retail Sale Id 1638',0.00,6999.60,760.00,6999.60,0.00,'2022-06-17 10:32:57'),(1176,'21','227',1,'Retail Sale Id 1639',0.00,760.00,760.00,760.00,0.00,'2022-06-17 10:33:50'),(1177,'21','227',1,'Retail Sale Id 1640',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 10:36:51'),(1178,'21','227',1,'Retail Sale Id 1641',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 10:37:31'),(1179,'21','227',1,'Retail Sale Id 1642',0.00,995.60,760.00,995.60,0.00,'2022-06-17 10:38:30'),(1180,'21','227',1,'Retail Sale Id 1643',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 10:39:11'),(1181,'21','227',1,'Retail Sale Id 1644',0.00,4993.20,760.00,4993.20,0.00,'2022-06-17 10:40:52'),(1182,'21','227',1,'Retail Sale Id 1645',0.00,3997.60,760.00,3997.60,0.00,'2022-06-17 10:42:15'),(1183,'21','227',1,'Retail Sale Id 1646',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 10:57:53'),(1184,'21','227',1,'Retail Sale Id 1647',0.00,995.60,760.00,995.60,0.00,'2022-06-17 11:18:34'),(1185,'21','227',1,'Retail Sale Id 1648',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 11:28:36'),(1186,'21','227',1,'Retail Sale Id 1649',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 11:32:43'),(1187,'21','227',1,'Retail Sale Id 1650',0.00,995.60,760.00,995.60,0.00,'2022-06-17 11:34:14'),(1188,'21','227',1,'Retail Sale Id 1651',0.00,494.00,760.00,494.00,0.00,'2022-06-17 11:37:03'),(1189,'21','227',1,'Retail Sale Id 1652',0.00,9500.00,760.00,9500.00,0.00,'2022-06-17 11:39:38'),(1190,'21','227',1,'Retail Sale Id 1653',0.00,995.60,760.00,995.60,0.00,'2022-06-17 11:40:35'),(1191,'21','227',1,'Retail Sale Id 1654',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 11:47:01'),(1192,'21','227',1,'Retail Sale Id 1655',0.00,1520.00,760.00,1520.00,0.00,'2022-06-17 11:49:37'),(1193,'21','227',1,'Retail Sale Id 1656',0.00,995.60,760.00,995.60,0.00,'2022-06-17 11:51:04'),(1194,'21','227',1,'Retail Sale Id 1657',0.00,6999.60,760.00,6999.60,0.00,'2022-06-17 11:54:05'),(1195,'21','227',1,'Retail Sale Id 1658',0.00,3496.00,760.00,3496.00,0.00,'2022-06-17 11:57:02'),(1196,'21','227',1,'Retail Sale Id 1659',0.00,995.60,760.00,995.60,0.00,'2022-06-17 11:59:46'),(1197,'21','227',1,'Retail Sale Id 1660',0.00,995.60,760.00,995.60,0.00,'2022-06-17 12:01:52'),(1198,'21','227',1,'Retail Sale Id 1661',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 12:03:50'),(1199,'21','227',1,'Retail Sale Id 1662',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 12:07:36'),(1200,'21','227',1,'Retail Sale Id 1663',0.00,896.80,760.00,896.80,0.00,'2022-06-17 12:13:37'),(1201,'21','227',1,'Retail Sale Id 1664',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 12:14:45'),(1202,'21','227',1,'Retail Sale Id 1665',0.00,995.60,760.00,995.60,0.00,'2022-06-17 12:16:05'),(1203,'21','227',1,'Retail Sale Id 1665',0.00,995.60,760.00,995.60,0.00,'2022-06-17 12:16:05'),(1204,'21','227',1,'Retail Sale Id 1666',0.00,995.60,760.00,995.60,0.00,'2022-06-17 12:23:17'),(1205,'21','227',1,'Retail Sale Id 1667',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 12:36:14'),(1206,'21','227',1,'Retail Sale Id 1668',0.00,995.60,760.00,995.60,0.00,'2022-06-17 12:37:44'),(1207,'21','227',1,'Retail Sale Id 1669',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 12:42:01'),(1208,'21','227',1,'Retail Sale Id 1670',0.00,3496.00,760.00,3496.00,0.00,'2022-06-17 12:51:21'),(1209,'21','227',1,'Retail Sale Id 1671',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 14:31:44'),(1210,'21','227',1,'Retail Sale Id 1672',0.00,2994.40,760.00,2994.40,0.00,'2022-06-17 14:34:48'),(1211,'21','227',1,'Retail Sale Id 1674',0.00,4993.20,760.00,4993.20,0.00,'2022-06-17 14:37:40'),(1212,'21','227',1,'Retail Sale Id 1675',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 14:40:07'),(1213,'21','227',1,'Retail Sale Id 1676',0.00,1793.60,760.00,1793.60,0.00,'2022-06-17 14:42:16'),(1214,'21','227',1,'Retail Sale Id 1677',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 14:43:27'),(1215,'21','227',1,'Retail Sale Id 1678',0.00,995.60,760.00,995.60,0.00,'2022-06-17 14:44:49'),(1216,'21','227',1,'Retail Sale Id 1679',0.00,995.60,760.00,995.60,0.00,'2022-06-17 14:50:12'),(1217,'21','227',1,'Retail Sale Id 1680',0.00,7600.00,760.00,7600.00,0.00,'2022-06-17 14:51:19'),(1218,'21','227',1,'Retail Sale Id 1681',0.00,760.00,760.00,760.00,0.00,'2022-06-17 14:52:59'),(1219,'21','227',1,'Retail Sale Id 1682',0.00,9500.00,760.00,9500.00,0.00,'2022-06-17 14:55:37'),(1220,'21','227',1,'Retail Sale Id 1683',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 14:58:41'),(1221,'21','227',1,'Retail Sale Id 1685',0.00,995.60,760.00,995.60,0.00,'2022-06-17 15:28:34'),(1222,'21','227',1,'Retail Sale Id 1686',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 15:29:27'),(1223,'21','227',1,'Retail Sale Id 1687',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 15:30:24'),(1224,'21','227',1,'Retail Sale Id 1688',0.00,995.60,760.00,995.60,0.00,'2022-06-17 15:31:14'),(1225,'21','227',1,'Retail Sale Id 1689',0.00,995.60,760.00,995.60,0.00,'2022-06-17 15:31:55'),(1226,'21','227',1,'Retail Sale Id 1690',0.00,3496.00,760.00,3496.00,0.00,'2022-06-17 15:32:53'),(1227,'21','227',1,'Retail Sale Id 1691',0.00,995.60,760.00,995.60,0.00,'2022-06-17 15:33:20'),(1228,'21','227',1,'Retail Sale Id 1692',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 15:34:05'),(1229,'21','227',1,'Retail Sale Id 1693',0.00,494.00,760.00,494.00,0.00,'2022-06-17 15:34:47'),(1230,'21','227',1,'Retail Sale Id 1694',0.00,3040.00,760.00,3040.00,0.00,'2022-06-17 15:35:34'),(1231,'21','227',1,'Retail Sale Id 1695',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 15:36:30'),(1232,'21','227',1,'Retail Sale Id 1696',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 15:37:13'),(1233,'21','227',1,'Retail Sale Id 1697',0.00,2994.40,760.00,2994.40,0.00,'2022-06-17 15:37:46'),(1234,'21','227',1,'Retail Sale Id 1698',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 15:38:29'),(1235,'21','227',1,'Retail Sale Id 1699',0.00,995.60,760.00,995.60,0.00,'2022-06-17 15:39:47'),(1236,'21','227',1,'Retail Sale Id 1700',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 15:40:38'),(1237,'21','227',1,'Retail Sale Id 1701',0.00,2492.80,760.00,2492.80,0.00,'2022-06-17 15:42:33'),(1238,'21','227',1,'Retail Sale Id 1702',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 15:50:04'),(1239,'21','227',1,'Retail Sale Id 1703',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 15:55:52'),(1240,'21','227',1,'Retail Sale Id 1704',0.00,995.60,760.00,995.60,0.00,'2022-06-17 15:58:01'),(1241,'21','227',1,'Retail Sale Id 1705',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 16:06:16'),(1242,'21','227',1,'Retail Sale Id 1706',0.00,1520.00,760.00,1520.00,0.00,'2022-06-17 16:08:15'),(1243,'21','227',1,'Retail Sale Id 1707',0.00,3040.00,760.00,3040.00,0.00,'2022-06-17 16:15:37'),(1244,'21','227',1,'Retail Sale Id 1708',0.00,1900.00,760.00,1900.00,0.00,'2022-06-17 16:18:03'),(1245,'21','227',1,'Retail Sale Id 1709',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 16:19:01'),(1246,'21','227',1,'Retail Sale Id 1710',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 16:20:11'),(1247,'21','227',1,'Retail Sale Id 1710',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 16:20:11'),(1248,'21','227',1,'Retail Sale Id 1711',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 16:28:57'),(1249,'21','227',1,'Retail Sale Id 1712',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 16:29:45'),(1250,'21','227',1,'Retail Sale Id 1713',0.00,4598.00,760.00,4598.00,0.00,'2022-06-17 16:32:02'),(1251,'21','227',1,'Retail Sale Id 1714',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 16:32:49'),(1252,'21','227',1,'Retail Sale Id 1715',0.00,3997.60,760.00,3997.60,0.00,'2022-06-17 16:33:45'),(1253,'21','227',1,'Retail Sale Id 1716',0.00,995.60,760.00,995.60,0.00,'2022-06-17 16:34:44'),(1254,'21','227',1,'Retail Sale Id 1717',0.00,1094.40,760.00,1094.40,0.00,'2022-06-17 16:35:39'),(1255,'21','227',1,'Retail Sale Id 1718',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 16:36:23'),(1256,'21','227',1,'Retail Sale Id 1719',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 16:37:48'),(1257,'21','227',1,'Retail Sale Id 1720',0.00,798.00,760.00,798.00,0.00,'2022-06-17 16:38:33'),(1258,'21','227',1,'Retail Sale Id 1721',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 16:39:30'),(1259,'21','227',1,'Retail Sale Id 1723',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 16:43:13'),(1260,'21','227',1,'Retail Sale Id 1724',0.00,2994.40,760.00,2994.40,0.00,'2022-06-17 16:45:41'),(1261,'21','227',1,'Retail Sale Id 1726',0.00,3496.00,760.00,3496.00,0.00,'2022-06-17 16:51:29'),(1262,'21','227',1,'Retail Sale Id 1727',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 16:52:54'),(1263,'21','227',1,'Retail Sale Id 1728',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 16:54:01'),(1264,'21','227',1,'Retail Sale Id 1729',0.00,1793.60,760.00,1793.60,0.00,'2022-06-17 16:55:15'),(1265,'21','227',1,'Retail Sale Id 1730',0.00,4993.20,760.00,4993.20,0.00,'2022-06-17 16:56:28'),(1266,'21','227',1,'Retail Sale Id 1731',0.00,2280.00,760.00,2280.00,0.00,'2022-06-17 16:57:14'),(1267,'21','227',1,'Retail Sale Id 1732',0.00,2492.80,760.00,2492.80,0.00,'2022-06-17 16:58:17'),(1268,'21','227',1,'Retail Sale Id 1733',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 16:59:06'),(1269,'21','227',1,'Retail Sale Id 1734',0.00,3496.00,760.00,3496.00,0.00,'2022-06-17 17:00:14'),(1270,'21','227',1,'Retail Sale Id 1735',0.00,760.00,760.00,760.00,0.00,'2022-06-17 17:01:08'),(1271,'21','227',1,'Retail Sale Id 1736',0.00,995.60,760.00,995.60,0.00,'2022-06-17 17:01:57'),(1272,'21','227',1,'Retail Sale Id 1737',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 17:03:25'),(1273,'21','227',1,'Retail Sale Id 1738',0.00,995.60,760.00,995.60,0.00,'2022-06-17 17:05:33'),(1274,'21','227',1,'Retail Sale Id 1739',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 17:07:32'),(1275,'21','227',1,'Retail Sale Id 1740',0.00,3997.60,760.00,3997.60,0.00,'2022-06-17 17:15:13'),(1276,'21','227',1,'Retail Sale Id 1741',0.00,494.00,760.00,494.00,0.00,'2022-06-17 17:21:21'),(1277,'21','227',1,'Retail Sale Id 1742',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 17:23:17'),(1278,'21','227',1,'Retail Sale Id 1743',0.00,760.00,760.00,760.00,0.00,'2022-06-17 17:25:38'),(1279,'21','227',1,'Retail Sale Id 1744',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 17:30:40'),(1280,'21','227',1,'Retail Sale Id 1745',0.00,1998.80,760.00,1998.80,0.00,'2022-06-17 17:34:22'),(1281,'21','227',1,'Retail Sale Id 1746',0.00,995.60,760.00,995.60,0.00,'2022-06-17 17:41:43'),(1282,'21','227',1,'Retail Sale Id 1747',0.00,995.60,760.00,995.60,0.00,'2022-06-17 17:49:01'),(1283,'21','227',1,'Retail Sale Id 1748',0.00,33440.00,760.00,33440.00,0.00,'2022-06-17 17:51:27'),(1284,'21','227',1,'Retail Sale Id 1749',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 17:52:32'),(1285,'21','227',1,'Retail Sale Id 1750',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 17:58:43'),(1286,'21','227',1,'Retail Sale Id 1751',0.00,3997.60,760.00,3997.60,0.00,'2022-06-17 18:08:46'),(1287,'21','227',1,'Retail Sale Id 1752',0.00,3997.60,760.00,3997.60,0.00,'2022-06-17 18:11:18'),(1288,'21','227',1,'Retail Sale Id 1753',0.00,1694.80,760.00,1694.80,0.00,'2022-06-17 18:13:25'),(1289,'21','227',1,'Retail Sale Id 1754',0.00,4560.00,760.00,4560.00,0.00,'2022-06-17 18:14:20'),(1290,'21','227',1,'Retail Sale Id 1755',0.00,995.60,760.00,995.60,0.00,'2022-06-17 18:26:16'),(1291,'21','227',1,'Retail Sale Id 1756',0.00,995.60,760.00,995.60,0.00,'2022-06-17 18:28:28'),(1292,'21','227',1,'Retail Sale Id 1757',0.00,1497.20,760.00,1497.20,0.00,'2022-06-17 18:29:32'),(1293,'21','227',1,'Retail Sale Id 1758',0.00,3800.00,760.00,3800.00,0.00,'2022-06-17 18:30:13'),(1294,'21','227',1,'Retail Sale Id 1759',0.00,995.60,760.00,995.60,0.00,'2022-06-18 09:22:16'),(1295,'21','227',1,'Retail Sale Id 1760',0.00,995.60,760.00,995.60,0.00,'2022-06-18 09:23:54'),(1296,'21','227',1,'Retail Sale Id 1761',0.00,995.60,760.00,995.60,0.00,'2022-06-18 09:25:05'),(1297,'21','227',1,'Retail Sale Id 1762',0.00,760.00,760.00,760.00,0.00,'2022-06-18 09:26:22'),(1298,'21','227',1,'Retail Sale Id 1763',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 09:30:43'),(1299,'21','227',1,'Retail Sale Id 1764',0.00,995.60,760.00,995.60,0.00,'2022-06-18 09:32:00'),(1300,'21','227',1,'Retail Sale Id 1765',0.00,1520.00,760.00,1520.00,0.00,'2022-06-18 09:35:03'),(1301,'21','227',1,'Retail Sale Id 1766',0.00,4560.00,760.00,4560.00,0.00,'2022-06-18 09:36:10'),(1302,'21','227',1,'Retail Sale Id 1767',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 09:40:35'),(1303,'21','227',1,'Retail Sale Id 1768',0.00,4750.00,760.00,4750.00,0.00,'2022-06-18 09:41:34'),(1304,'21','227',1,'Retail Sale Id 1769',0.00,494.00,760.00,494.00,0.00,'2022-06-18 09:42:18'),(1305,'21','227',1,'Retail Sale Id 1770',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 09:44:08'),(1306,'21','227',1,'Retail Sale Id 1771',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 09:47:49'),(1307,'21','227',1,'Retail Sale Id 1772',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 09:50:08'),(1308,'21','227',1,'Retail Sale Id 1773',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 09:51:40'),(1309,'21','227',1,'Retail Sale Id 1774',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 09:52:59'),(1310,'21','227',1,'Retail Sale Id 1775',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 09:54:17'),(1311,'21','227',1,'Retail Sale Id 1776',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 09:55:09'),(1312,'21','227',1,'Retail Sale Id 1777',0.00,7980.00,760.00,7980.00,0.00,'2022-06-18 09:56:12'),(1313,'21','227',1,'Retail Sale Id 1778',0.00,2492.80,760.00,2492.80,0.00,'2022-06-18 09:57:46'),(1314,'21','227',1,'Retail Sale Id 1779',0.00,494.00,760.00,494.00,0.00,'2022-06-18 09:58:50'),(1315,'21','227',1,'Retail Sale Id 1780',0.00,995.60,760.00,995.60,0.00,'2022-06-18 10:02:45'),(1316,'21','227',1,'Retail Sale Id 1781',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 10:03:52'),(1317,'21','227',1,'Retail Sale Id 1783',0.00,1299.60,760.00,1299.60,0.00,'2022-06-18 10:05:11'),(1318,'21','227',1,'Retail Sale Id 1784',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 10:06:03'),(1319,'21','227',1,'Retail Sale Id 1785',0.00,12494.40,760.00,12494.40,0.00,'2022-06-18 10:07:31'),(1320,'21','227',1,'Retail Sale Id 1786',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 10:09:08'),(1321,'21','227',1,'Retail Sale Id 1787',0.00,995.60,760.00,995.60,0.00,'2022-06-18 10:10:18'),(1322,'21','227',1,'Retail Sale Id 1788',0.00,995.60,760.00,995.60,0.00,'2022-06-18 10:11:08'),(1323,'21','227',1,'Retail Sale Id 1789',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 10:12:13'),(1324,'21','227',1,'Retail Sale Id 1790',0.00,3997.60,760.00,3997.60,0.00,'2022-06-18 10:13:23'),(1325,'21','227',1,'Retail Sale Id 1791',0.00,3040.00,760.00,3040.00,0.00,'2022-06-18 10:14:12'),(1326,'21','227',1,'Retail Sale Id 1792',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 10:16:20'),(1327,'21','227',1,'Retail Sale Id 1793',0.00,8360.00,760.00,8360.00,0.00,'2022-06-18 10:17:10'),(1328,'21','227',1,'Retail Sale Id 1794',0.00,1398.40,760.00,1398.40,0.00,'2022-06-18 10:20:40'),(1329,'21','227',1,'Retail Sale Id 1795',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 10:22:00'),(1330,'21','227',1,'Retail Sale Id 1796',0.00,9500.00,760.00,9500.00,0.00,'2022-06-18 10:22:46'),(1331,'21','227',1,'Retail Sale Id 1797',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 10:24:44'),(1332,'21','227',1,'Retail Sale Id 1798',0.00,2492.80,760.00,2492.80,0.00,'2022-06-18 10:25:36'),(1333,'21','227',1,'Retail Sale Id 1799',0.00,995.60,760.00,995.60,0.00,'2022-06-18 10:26:56'),(1334,'21','227',1,'Retail Sale Id 1800',0.00,995.60,760.00,995.60,0.00,'2022-06-18 10:28:15'),(1335,'21','227',1,'Retail Sale Id 1801',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 10:28:59'),(1336,'21','227',1,'Retail Sale Id 1802',0.00,494.00,760.00,494.00,0.00,'2022-06-18 10:41:52'),(1337,'21','227',1,'Retail Sale Id 1803',0.00,995.60,760.00,995.60,0.00,'2022-06-18 10:42:56'),(1338,'21','227',1,'Retail Sale Id 1804',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 10:43:54'),(1339,'21','227',1,'Retail Sale Id 1805',0.00,995.60,760.00,995.60,0.00,'2022-06-18 10:45:18'),(1340,'21','227',1,'Retail Sale Id 1806',0.00,4993.20,760.00,4993.20,0.00,'2022-06-18 10:47:27'),(1341,'21','227',1,'Retail Sale Id 1807',0.00,995.60,760.00,995.60,0.00,'2022-06-18 11:09:04'),(1342,'21','227',1,'Retail Sale Id 1808',0.00,7600.00,760.00,7600.00,0.00,'2022-06-18 11:09:53'),(1343,'21','227',1,'Retail Sale Id 1809',0.00,995.60,760.00,995.60,0.00,'2022-06-18 11:13:24'),(1344,'21','227',1,'Retail Sale Id 1810',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 11:14:39'),(1345,'21','227',1,'Retail Sale Id 1811',0.00,995.60,760.00,995.60,0.00,'2022-06-18 11:15:41'),(1346,'21','227',1,'Retail Sale Id 1812',0.00,995.60,760.00,995.60,0.00,'2022-06-18 11:17:08'),(1347,'21','227',1,'Retail Sale Id 1813',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 11:18:28'),(1348,'21','227',1,'Retail Sale Id 1814',0.00,494.00,760.00,494.00,0.00,'2022-06-18 11:21:04'),(1349,'21','227',1,'Retail Sale Id 1815',0.00,494.00,760.00,494.00,0.00,'2022-06-18 11:26:17'),(1350,'21','227',1,'Retail Sale Id 1816',0.00,8998.40,760.00,8998.40,0.00,'2022-06-18 11:37:00'),(1351,'21','227',1,'Retail Sale Id 1817',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 11:38:12'),(1352,'21','227',1,'Retail Sale Id 1818',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 11:44:37'),(1353,'21','227',1,'Retail Sale Id 1819',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 11:46:32'),(1354,'21','227',1,'Retail Sale Id 1820',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 12:02:53'),(1355,'21','227',1,'Retail Sale Id 1821',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 12:06:24'),(1356,'21','227',1,'Retail Sale Id 1822',0.00,1299.60,760.00,1299.60,0.00,'2022-06-18 12:11:49'),(1357,'21','227',1,'Retail Sale Id 1823',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 12:27:00'),(1358,'21','227',1,'Retail Sale Id 1824',0.00,995.60,760.00,995.60,0.00,'2022-06-18 12:31:44'),(1359,'21','227',1,'Retail Sale Id 1825',0.00,9500.00,760.00,9500.00,0.00,'2022-06-18 12:33:27'),(1360,'21','227',1,'Retail Sale Id 1826',0.00,2492.80,760.00,2492.80,0.00,'2022-06-18 12:39:40'),(1361,'21','227',1,'Retail Sale Id 1827',0.00,494.00,760.00,494.00,0.00,'2022-06-18 12:46:10'),(1362,'21','227',1,'Retail Sale Id 1828',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 12:54:08'),(1363,'21','227',1,'Retail Sale Id 1829',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 13:00:15'),(1364,'21','227',1,'Retail Sale Id 1830',0.00,2492.80,760.00,2492.80,0.00,'2022-06-18 13:01:38'),(1365,'21','227',1,'Retail Sale Id 1831',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 13:02:43'),(1366,'21','227',1,'Retail Sale Id 1832',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 13:03:45'),(1367,'21','227',1,'Retail Sale Id 1833',0.00,1793.60,760.00,1793.60,0.00,'2022-06-18 13:05:00'),(1368,'21','227',1,'Retail Sale Id 1834',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 13:08:17'),(1369,'21','227',1,'Retail Sale Id 1835',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 13:15:17'),(1370,'21','227',1,'Retail Sale Id 1836',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 13:17:42'),(1371,'21','227',1,'Retail Sale Id 1837',0.00,1694.80,760.00,1694.80,0.00,'2022-06-18 13:18:59'),(1372,'21','227',1,'Retail Sale Id 1838',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 13:22:10'),(1373,'21','227',1,'Retail Sale Id 1839',0.00,995.60,760.00,995.60,0.00,'2022-06-18 13:22:59'),(1374,'21','227',1,'Retail Sale Id 1840',0.00,995.60,760.00,995.60,0.00,'2022-06-18 13:24:15'),(1375,'21','227',1,'Retail Sale Id 1841',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 13:26:09'),(1376,'21','227',1,'Retail Sale Id 1842',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 13:27:29'),(1377,'21','227',1,'Retail Sale Id 1843',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 13:29:00'),(1378,'21','227',1,'Retail Sale Id 1844',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 13:36:47'),(1379,'21','227',1,'Retail Sale Id 1845',0.00,760.00,760.00,760.00,0.00,'2022-06-18 13:38:08'),(1380,'21','227',1,'Retail Sale Id 1846',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 13:46:38'),(1381,'21','227',1,'Retail Sale Id 1847',0.00,3997.60,760.00,3997.60,0.00,'2022-06-18 13:57:15'),(1382,'21','227',1,'Retail Sale Id 1848',0.00,995.60,760.00,995.60,0.00,'2022-06-18 14:01:17'),(1383,'21','227',1,'Retail Sale Id 1849',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 14:57:38'),(1384,'21','227',1,'Retail Sale Id 1850',0.00,995.60,760.00,995.60,0.00,'2022-06-18 14:59:11'),(1385,'21','227',1,'Retail Sale Id 1851',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 15:01:07'),(1386,'21','227',1,'Retail Sale Id 1852',0.00,4560.00,760.00,4560.00,0.00,'2022-06-18 15:01:56'),(1387,'21','227',1,'Retail Sale Id 1853',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 15:02:51'),(1388,'21','227',1,'Retail Sale Id 1854',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 15:04:05'),(1389,'21','227',1,'Retail Sale Id 1855',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 15:06:50'),(1390,'21','227',1,'Retail Sale Id 1856',0.00,7600.00,760.00,7600.00,0.00,'2022-06-18 15:07:57'),(1391,'21','227',1,'Retail Sale Id 1857',0.00,1694.80,760.00,1694.80,0.00,'2022-06-18 15:10:08'),(1392,'21','227',1,'Retail Sale Id 1858',0.00,4560.00,760.00,4560.00,0.00,'2022-06-18 15:11:15'),(1393,'21','227',1,'Retail Sale Id 1859',0.00,1694.80,760.00,1694.80,0.00,'2022-06-18 15:12:08'),(1394,'21','227',1,'Retail Sale Id 1860',0.00,2698.00,760.00,2698.00,0.00,'2022-06-18 15:13:12'),(1395,'21','227',1,'Retail Sale Id 1861',0.00,995.60,760.00,995.60,0.00,'2022-06-18 15:14:34'),(1396,'21','227',1,'Retail Sale Id 1862',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 15:16:06'),(1397,'21','227',1,'Retail Sale Id 1863',0.00,4560.00,760.00,4560.00,0.00,'2022-06-18 15:16:55'),(1398,'21','227',1,'Retail Sale Id 1864',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 15:17:47'),(1399,'21','227',1,'Retail Sale Id 1865',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 15:22:24'),(1400,'21','227',1,'Retail Sale Id 1866',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 15:23:46'),(1401,'21','227',1,'Retail Sale Id 1867',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 15:25:02'),(1402,'21','227',1,'Retail Sale Id 1868',0.00,995.60,760.00,995.60,0.00,'2022-06-18 15:25:59'),(1403,'21','227',1,'Retail Sale Id 1869',0.00,3496.00,760.00,3496.00,0.00,'2022-06-18 15:27:20'),(1404,'21','227',1,'Retail Sale Id 1870',0.00,995.60,760.00,995.60,0.00,'2022-06-18 15:38:53'),(1405,'21','227',1,'Retail Sale Id 1871',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 15:40:45'),(1406,'21','227',1,'Retail Sale Id 1872',0.00,3997.60,760.00,3997.60,0.00,'2022-06-18 15:43:24'),(1407,'21','227',1,'Retail Sale Id 1873',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 15:53:10'),(1408,'21','227',1,'Retail Sale Id 1874',0.00,995.60,760.00,995.60,0.00,'2022-06-18 16:08:06'),(1409,'21','227',1,'Retail Sale Id 1875',0.00,3800.00,760.00,3800.00,0.00,'2022-06-18 16:10:04'),(1410,'21','227',1,'Retail Sale Id 1876',0.00,995.60,760.00,995.60,0.00,'2022-06-18 16:14:26'),(1411,'21','227',1,'Retail Sale Id 1877',0.00,494.00,760.00,494.00,0.00,'2022-06-18 16:20:48'),(1412,'21','227',1,'Retail Sale Id 1878',0.00,995.60,760.00,995.60,0.00,'2022-06-18 16:39:39'),(1413,'21','227',1,'Retail Sale Id 1879',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 16:40:55'),(1414,'21','227',1,'Retail Sale Id 1880',0.00,8998.40,760.00,8998.40,0.00,'2022-06-18 16:47:08'),(1415,'21','227',1,'Retail Sale Id 1881',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 16:51:48'),(1416,'21','227',1,'Retail Sale Id 1882',0.00,760.00,760.00,760.00,0.00,'2022-06-18 16:52:29'),(1417,'21','227',1,'Retail Sale Id 1883',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 16:55:24'),(1418,'21','227',1,'Retail Sale Id 1884',0.00,2295.20,760.00,2295.20,0.00,'2022-06-18 16:58:26'),(1419,'21','227',1,'Retail Sale Id 1885',0.00,995.60,760.00,995.60,0.00,'2022-06-18 17:00:30'),(1420,'21','227',1,'Retail Sale Id 1886',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 17:03:24'),(1421,'21','227',1,'Retail Sale Id 1887',0.00,2492.80,760.00,2492.80,0.00,'2022-06-18 17:06:55'),(1422,'21','227',1,'Retail Sale Id 1888',0.00,592.80,760.00,592.80,0.00,'2022-06-18 17:08:50'),(1423,'21','227',1,'Retail Sale Id 1889',0.00,995.60,760.00,995.60,0.00,'2022-06-18 17:15:01'),(1424,'21','227',1,'Retail Sale Id 1890',0.00,995.60,760.00,995.60,0.00,'2022-06-18 17:16:43'),(1425,'21','227',1,'Retail Sale Id 1891',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 17:18:41'),(1426,'21','227',1,'Retail Sale Id 1892',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 17:21:04'),(1427,'21','227',1,'Retail Sale Id 1893',0.00,3496.00,760.00,3496.00,0.00,'2022-06-18 17:22:45'),(1428,'21','227',1,'Retail Sale Id 1894',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 17:26:13'),(1429,'21','227',1,'Retail Sale Id 1894',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 17:26:13'),(1430,'21','227',1,'Retail Sale Id 1895',0.00,995.60,760.00,995.60,0.00,'2022-06-18 17:47:55'),(1431,'21','227',1,'Retail Sale Id 1896',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 17:49:25'),(1432,'21','227',1,'Retail Sale Id 1897',0.00,494.00,760.00,494.00,0.00,'2022-06-18 18:08:59'),(1433,'21','227',1,'Retail Sale Id 1898',0.00,2492.80,760.00,2492.80,0.00,'2022-06-18 18:10:20'),(1434,'21','227',1,'Retail Sale Id 1899',0.00,2994.40,760.00,2994.40,0.00,'2022-06-18 18:11:40'),(1435,'21','227',1,'Retail Sale Id 1900',0.00,995.60,760.00,995.60,0.00,'2022-06-18 18:13:39'),(1436,'21','227',1,'Retail Sale Id 1901',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 18:19:05'),(1437,'21','227',1,'Retail Sale Id 1902',0.00,798.00,760.00,798.00,0.00,'2022-06-18 18:20:54'),(1438,'21','227',1,'Retail Sale Id 1903',0.00,995.60,760.00,995.60,0.00,'2022-06-18 18:24:31'),(1439,'21','227',1,'Retail Sale Id 1904',0.00,1497.20,760.00,1497.20,0.00,'2022-06-18 18:25:47'),(1440,'21','227',1,'Retail Sale Id 1905',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 18:27:21'),(1441,'21','227',1,'Retail Sale Id 1906',0.00,4560.00,760.00,4560.00,0.00,'2022-06-18 18:29:41'),(1442,'21','227',1,'Retail Sale Id 1907',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 18:31:05'),(1443,'21','227',1,'Retail Sale Id 1908',0.00,1998.80,760.00,1998.80,0.00,'2022-06-18 18:34:24'),(1444,'21','227',1,'Retail Sale Id 1909',0.00,798.00,760.00,798.00,0.00,'2022-06-18 18:35:50'),(1445,'21','227',1,'Retail Sale Id 1910',0.00,1094.40,760.00,1094.40,0.00,'2022-06-18 18:36:49'),(1446,'21','227',1,'Retail Sale Id 1911',0.00,6999.60,760.00,6999.60,0.00,'2022-06-18 18:38:51'),(1447,'21','227',1,'Retail Sale Id 1912',0.00,2280.00,760.00,2280.00,0.00,'2022-06-18 18:42:05'),(1448,'21','227',1,'Retail Sale Id 1913',0.00,9500.00,760.00,9500.00,0.00,'2022-06-19 15:17:13'),(1449,'21','227',1,'Retail Sale Id 1914',0.00,2994.40,760.00,2994.40,0.00,'2022-06-19 15:17:53'),(1450,'21','227',1,'Retail Sale Id 1915',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 15:18:17'),(1451,'21','227',1,'Retail Sale Id 1916',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 15:19:12'),(1452,'21','227',1,'Retail Sale Id 1917',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 15:19:37'),(1453,'21','227',1,'Retail Sale Id 1918',0.00,1520.00,760.00,1520.00,0.00,'2022-06-19 15:20:01'),(1454,'21','227',1,'Retail Sale Id 1919',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 15:20:25'),(1455,'21','227',1,'Retail Sale Id 1920',0.00,4560.00,760.00,4560.00,0.00,'2022-06-19 15:20:49'),(1456,'21','227',1,'Retail Sale Id 1921',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 15:21:18'),(1457,'21','227',1,'Retail Sale Id 1922',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 15:21:41'),(1458,'21','227',1,'Retail Sale Id 1923',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 15:22:03'),(1459,'21','227',1,'Retail Sale Id 1924',0.00,9500.00,760.00,9500.00,0.00,'2022-06-19 15:22:28'),(1460,'21','227',1,'Retail Sale Id 1925',0.00,7600.00,760.00,7600.00,0.00,'2022-06-19 15:22:50'),(1461,'21','227',1,'Retail Sale Id 1926',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 15:23:10'),(1462,'21','227',1,'Retail Sale Id 1927',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 15:23:38'),(1463,'21','227',1,'Retail Sale Id 1928',0.00,4560.00,760.00,4560.00,0.00,'2022-06-19 15:24:01'),(1464,'21','227',1,'Retail Sale Id 1929',0.00,4560.00,760.00,4560.00,0.00,'2022-06-19 15:24:21'),(1465,'21','227',1,'Retail Sale Id 1930',0.00,7600.00,760.00,7600.00,0.00,'2022-06-19 15:24:44'),(1466,'21','227',1,'Retail Sale Id 1931',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 15:25:08'),(1467,'21','227',1,'Retail Sale Id 1932',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 15:25:30'),(1468,'21','227',1,'Retail Sale Id 1933',0.00,995.60,760.00,995.60,0.00,'2022-06-19 15:25:54'),(1469,'21','227',1,'Retail Sale Id 1934',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 15:26:19'),(1470,'21','227',1,'Retail Sale Id 1935',0.00,8398.00,760.00,8398.00,0.00,'2022-06-19 15:26:51'),(1471,'21','227',1,'Retail Sale Id 1936',0.00,995.60,760.00,995.60,0.00,'2022-06-19 15:27:15'),(1472,'21','227',1,'Retail Sale Id 1937',0.00,798.00,760.00,798.00,0.00,'2022-06-19 15:27:39'),(1473,'21','227',1,'Retail Sale Id 1938',0.00,6999.60,760.00,6999.60,0.00,'2022-06-19 15:28:04'),(1474,'21','227',1,'Retail Sale Id 1939',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 15:28:30'),(1475,'21','227',1,'Retail Sale Id 1940',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 15:29:00'),(1476,'21','227',1,'Retail Sale Id 1941',0.00,2492.80,760.00,2492.80,0.00,'2022-06-19 15:29:22'),(1477,'21','227',1,'Retail Sale Id 1942',0.00,9500.00,760.00,9500.00,0.00,'2022-06-19 15:29:45'),(1478,'21','227',1,'Retail Sale Id 1943',0.00,1520.00,760.00,1520.00,0.00,'2022-06-19 15:30:08'),(1479,'21','227',1,'Retail Sale Id 1944',0.00,995.60,760.00,995.60,0.00,'2022-06-19 15:30:31'),(1480,'21','227',1,'Retail Sale Id 1945',0.00,3997.60,760.00,3997.60,0.00,'2022-06-19 15:30:54'),(1481,'21','227',1,'Retail Sale Id 1946',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 15:31:17'),(1482,'21','227',1,'Retail Sale Id 1947',0.00,3040.00,760.00,3040.00,0.00,'2022-06-19 15:31:41'),(1483,'21','227',1,'Retail Sale Id 1948',0.00,1094.40,760.00,1094.40,0.00,'2022-06-19 15:32:05'),(1484,'21','227',1,'Retail Sale Id 1949',0.00,995.60,760.00,995.60,0.00,'2022-06-19 15:32:34'),(1485,'21','227',1,'Retail Sale Id 1950',0.00,4993.20,760.00,4993.20,0.00,'2022-06-19 15:33:09'),(1486,'21','227',1,'Retail Sale Id 1951',0.00,9500.00,760.00,9500.00,0.00,'2022-06-19 15:33:33'),(1487,'21','227',1,'Retail Sale Id 1952',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 15:33:57'),(1488,'21','227',1,'Retail Sale Id 1953',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 15:34:20'),(1489,'21','227',1,'Retail Sale Id 1954',0.00,760.00,760.00,760.00,0.00,'2022-06-19 15:35:07'),(1490,'21','227',1,'Retail Sale Id 1954',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 15:35:07'),(1491,'21','227',1,'Retail Sale Id 1954',0.00,4560.00,760.00,4560.00,0.00,'2022-06-19 15:35:07'),(1492,'21','227',1,'Retail Sale Id 1955',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 15:35:44'),(1493,'21','227',1,'Retail Sale Id 1955',0.00,4993.20,760.00,4993.20,0.00,'2022-06-19 15:35:44'),(1494,'21','227',1,'Retail Sale Id 1956',0.00,995.60,760.00,995.60,0.00,'2022-06-19 15:36:17'),(1495,'21','227',1,'Retail Sale Id 1957',0.00,760.00,760.00,760.00,0.00,'2022-06-19 15:37:05'),(1496,'21','227',1,'Retail Sale Id 1957',0.00,1193.20,760.00,1193.20,0.00,'2022-06-19 15:37:05'),(1497,'21','227',1,'Retail Sale Id 1957',0.00,7600.00,760.00,7600.00,0.00,'2022-06-19 15:37:05'),(1498,'21','227',1,'Retail Sale Id 1958',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 15:37:42'),(1499,'21','227',1,'Retail Sale Id 1959',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 15:38:03'),(1500,'21','227',1,'Retail Sale Id 1960',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 15:38:32'),(1501,'21','227',1,'Retail Sale Id 1961',0.00,995.60,760.00,995.60,0.00,'2022-06-19 15:38:54'),(1502,'21','227',1,'Retail Sale Id 1962',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 15:39:18'),(1503,'21','227',1,'Retail Sale Id 1963',0.00,1345.20,760.00,1345.20,0.00,'2022-06-19 15:39:42'),(1504,'21','227',1,'Retail Sale Id 1965',0.00,995.60,760.00,995.60,0.00,'2022-06-19 15:40:33'),(1505,'21','227',1,'Retail Sale Id 1966',0.00,1299.60,760.00,1299.60,0.00,'2022-06-19 15:49:29'),(1506,'21','227',1,'Retail Sale Id 1967',0.00,995.60,760.00,995.60,0.00,'2022-06-19 15:49:54'),(1507,'21','227',1,'Retail Sale Id 1968',0.00,798.00,760.00,798.00,0.00,'2022-06-19 15:50:17'),(1508,'21','227',1,'Retail Sale Id 1969',0.00,2394.00,760.00,2394.00,0.00,'2022-06-19 15:50:40'),(1509,'21','227',1,'Retail Sale Id 1970',0.00,3496.00,760.00,3496.00,0.00,'2022-06-19 15:51:05'),(1510,'21','227',1,'Retail Sale Id 1971',0.00,4499.20,760.00,4499.20,0.00,'2022-06-19 15:51:29'),(1511,'21','227',1,'Retail Sale Id 1972',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 15:51:50'),(1512,'21','227',1,'Retail Sale Id 1973',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 15:52:09'),(1513,'21','227',1,'Retail Sale Id 1974',0.00,1292.00,760.00,1292.00,0.00,'2022-06-19 15:52:32'),(1514,'21','227',1,'Retail Sale Id 1975',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 16:04:23'),(1515,'21','227',1,'Retail Sale Id 1976',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:04:46'),(1516,'21','227',1,'Retail Sale Id 1977',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 16:05:07'),(1517,'21','227',1,'Retail Sale Id 1978',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 16:05:31'),(1518,'21','227',1,'Retail Sale Id 1979',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 16:05:59'),(1519,'21','227',1,'Retail Sale Id 1980',0.00,2994.40,760.00,2994.40,0.00,'2022-06-19 16:06:23'),(1520,'21','227',1,'Retail Sale Id 1981',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 16:06:47'),(1521,'21','227',1,'Retail Sale Id 1982',0.00,4499.20,760.00,4499.20,0.00,'2022-06-19 16:07:16'),(1522,'21','227',1,'Retail Sale Id 1983',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 16:07:40'),(1523,'21','227',1,'Retail Sale Id 1985',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:08:47'),(1524,'21','227',1,'Retail Sale Id 1986',0.00,2994.40,760.00,2994.40,0.00,'2022-06-19 16:09:08'),(1525,'21','227',1,'Retail Sale Id 1987',0.00,896.80,760.00,896.80,0.00,'2022-06-19 16:09:34'),(1526,'21','227',1,'Retail Sale Id 1988',0.00,9500.00,760.00,9500.00,0.00,'2022-06-19 16:09:56'),(1527,'21','227',1,'Retail Sale Id 1989',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:10:20'),(1528,'21','227',1,'Retail Sale Id 1990',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:10:50'),(1529,'21','227',1,'Retail Sale Id 1991',0.00,9500.00,760.00,9500.00,0.00,'2022-06-19 16:11:11'),(1530,'21','227',1,'Retail Sale Id 1992',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 16:15:58'),(1531,'21','227',1,'Retail Sale Id 1993',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:16:48'),(1532,'21','227',1,'Retail Sale Id 1994',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:19:15'),(1533,'21','227',1,'Retail Sale Id 1995',0.00,68.40,760.00,68.40,0.00,'2022-06-19 16:20:00'),(1534,'21','227',1,'Retail Sale Id 1996',0.00,494.00,760.00,494.00,0.00,'2022-06-19 16:20:33'),(1535,'21','227',1,'Retail Sale Id 1997',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 16:21:46'),(1536,'21','227',1,'Retail Sale Id 1997',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 16:21:47'),(1537,'21','227',1,'Retail Sale Id 1998',0.00,760.00,760.00,760.00,0.00,'2022-06-19 16:22:13'),(1538,'21','227',1,'Retail Sale Id 1999',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 16:22:45'),(1539,'21','227',1,'Retail Sale Id 2000',0.00,2994.40,760.00,2994.40,0.00,'2022-06-19 16:23:13'),(1540,'21','227',1,'Retail Sale Id 2001',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:23:39'),(1541,'21','227',1,'Retail Sale Id 2002',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 16:24:18'),(1542,'21','227',1,'Retail Sale Id 2003',0.00,4294.00,760.00,4294.00,0.00,'2022-06-19 16:24:53'),(1543,'21','227',1,'Retail Sale Id 2004',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 16:25:16'),(1544,'21','227',1,'Retail Sale Id 2005',0.00,760.00,760.00,760.00,0.00,'2022-06-19 16:25:46'),(1545,'21','227',1,'Retail Sale Id 2006',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 16:26:14'),(1546,'21','227',1,'Retail Sale Id 2007',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:26:48'),(1547,'21','227',1,'Retail Sale Id 2008',0.00,798.00,760.00,798.00,0.00,'2022-06-19 16:27:19'),(1548,'21','227',1,'Retail Sale Id 2009',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 16:27:48'),(1549,'21','227',1,'Retail Sale Id 2010',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 16:28:30'),(1550,'21','227',1,'Retail Sale Id 2011',0.00,494.00,760.00,494.00,0.00,'2022-06-19 16:28:52'),(1551,'21','227',1,'Retail Sale Id 2012',0.00,3496.00,760.00,3496.00,0.00,'2022-06-19 16:29:38'),(1552,'21','227',1,'Retail Sale Id 2013',0.00,494.00,760.00,494.00,0.00,'2022-06-19 16:30:14'),(1553,'21','227',1,'Retail Sale Id 2014',0.00,798.00,760.00,798.00,0.00,'2022-06-19 16:30:45'),(1554,'21','227',1,'Retail Sale Id 2015',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 16:31:28'),(1555,'21','227',1,'Retail Sale Id 2016',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:37:30'),(1556,'21','227',1,'Retail Sale Id 2017',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 16:39:30'),(1557,'21','227',1,'Retail Sale Id 2018',0.00,1520.00,760.00,1520.00,0.00,'2022-06-19 16:42:15'),(1558,'21','227',1,'Retail Sale Id 2019',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:43:42'),(1559,'21','227',1,'Retail Sale Id 2020',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 16:44:28'),(1560,'21','227',1,'Retail Sale Id 2021',0.00,1193.20,760.00,1193.20,0.00,'2022-06-19 16:46:35'),(1561,'21','227',1,'Retail Sale Id 2021',0.00,1596.00,760.00,1596.00,0.00,'2022-06-19 16:46:35'),(1562,'21','227',1,'Retail Sale Id 2022',0.00,760.00,760.00,760.00,0.00,'2022-06-19 16:51:41'),(1563,'21','227',1,'Retail Sale Id 2023',0.00,494.00,760.00,494.00,0.00,'2022-06-19 16:52:12'),(1564,'21','227',1,'Retail Sale Id 2024',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 16:53:11'),(1565,'21','227',1,'Retail Sale Id 2025',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 16:56:50'),(1566,'21','227',1,'Retail Sale Id 2026',0.00,4560.00,760.00,4560.00,0.00,'2022-06-19 16:58:24'),(1567,'21','227',1,'Retail Sale Id 2027',0.00,1793.60,760.00,1793.60,0.00,'2022-06-19 16:59:00'),(1568,'21','227',1,'Retail Sale Id 2028',0.00,995.60,760.00,995.60,0.00,'2022-06-19 16:59:30'),(1569,'21','227',1,'Retail Sale Id 2029',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 17:01:20'),(1570,'21','227',1,'Retail Sale Id 2030',0.00,4993.20,760.00,4993.20,0.00,'2022-06-19 17:02:51'),(1571,'21','227',1,'Retail Sale Id 2031',0.00,995.60,760.00,995.60,0.00,'2022-06-19 17:07:51'),(1572,'21','227',1,'Retail Sale Id 2032',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 17:14:52'),(1573,'21','227',1,'Retail Sale Id 2033',0.00,995.60,760.00,995.60,0.00,'2022-06-19 17:15:39'),(1574,'21','227',1,'Retail Sale Id 2033',0.00,995.60,760.00,995.60,0.00,'2022-06-19 17:15:39'),(1575,'21','227',1,'Retail Sale Id 2034',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 17:21:40'),(1576,'21','227',1,'Retail Sale Id 2035',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 17:22:29'),(1577,'21','227',1,'Retail Sale Id 2036',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 17:23:06'),(1578,'21','227',1,'Retail Sale Id 2037',0.00,798.00,760.00,798.00,0.00,'2022-06-19 17:23:50'),(1579,'21','227',1,'Retail Sale Id 2038',0.00,1520.00,760.00,1520.00,0.00,'2022-06-19 17:25:06'),(1580,'21','227',1,'Retail Sale Id 2039',0.00,798.00,760.00,798.00,0.00,'2022-06-19 17:26:04'),(1581,'21','227',1,'Retail Sale Id 2040',0.00,494.00,760.00,494.00,0.00,'2022-06-19 17:32:36'),(1582,'21','227',1,'Retail Sale Id 2040',0.00,494.00,760.00,494.00,0.00,'2022-06-19 17:32:36'),(1583,'21','227',1,'Retail Sale Id 2041',0.00,995.60,760.00,995.60,0.00,'2022-06-19 17:35:32'),(1584,'21','227',1,'Retail Sale Id 2042',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 17:42:17'),(1585,'21','227',1,'Retail Sale Id 2043',0.00,1497.20,760.00,1497.20,0.00,'2022-06-19 17:43:28'),(1586,'21','227',1,'Retail Sale Id 2044',0.00,2196.40,760.00,2196.40,0.00,'2022-06-19 17:46:29'),(1587,'21','227',1,'Retail Sale Id 2045',0.00,995.60,760.00,995.60,0.00,'2022-06-19 17:47:24'),(1588,'21','227',1,'Retail Sale Id 2046',0.00,1793.60,760.00,1793.60,0.00,'2022-06-19 17:50:28'),(1589,'21','227',1,'Retail Sale Id 2047',0.00,2280.00,760.00,2280.00,0.00,'2022-06-19 17:53:25'),(1590,'21','227',1,'Retail Sale Id 2048',0.00,2994.40,760.00,2994.40,0.00,'2022-06-19 17:59:36'),(1591,'21','227',1,'Retail Sale Id 2052',0.00,2492.80,760.00,2492.80,0.00,'2022-06-19 18:01:23'),(1592,'21','227',1,'Retail Sale Id 2053',0.00,995.60,760.00,995.60,0.00,'2022-06-19 18:02:19'),(1593,'21','227',1,'Retail Sale Id 2054',0.00,995.60,760.00,995.60,0.00,'2022-06-19 18:06:31'),(1594,'21','227',1,'Retail Sale Id 2055',0.00,1998.80,760.00,1998.80,0.00,'2022-06-19 18:07:54'),(1595,'21','227',1,'Retail Sale Id 2056',0.00,3800.00,760.00,3800.00,0.00,'2022-06-19 18:08:57'),(1596,'21','227',1,'Retail Sale Id 2057',0.00,995.60,760.00,995.60,0.00,'2022-06-19 18:13:52'),(1597,'21','227',1,'Retail Sale Id 2058',0.00,1520.00,760.00,1520.00,0.00,'2022-06-19 18:15:55'),(1598,'21','227',1,'Retail Sale Id 2059',0.00,3997.60,760.00,3997.60,0.00,'2022-06-19 18:28:06'),(1599,'21','227',1,'Retail Sale Id 2060',0.00,2196.40,760.00,2196.40,0.00,'2022-06-19 18:28:56'),(1600,'21','227',1,'Retail Sale Id 2051',0.00,2492.80,760.00,2492.80,0.00,'2022-06-19 18:30:44'),(1601,'21','227',1,'Retail Sale Id 2061',0.00,2994.40,760.00,2994.40,0.00,'2022-06-19 18:32:23'),(1602,'21','227',1,'Retail Sale Id 2062',0.00,995.60,760.00,995.60,0.00,'2022-06-19 18:32:56'),(1603,'21','227',1,'Retail Sale Id 2063',0.00,995.60,760.00,995.60,0.00,'2022-06-19 18:33:28'),(1604,'21','227',1,'Retail Sale Id 2064',0.00,4993.20,760.00,4993.20,0.00,'2022-06-19 18:34:25'),(1605,'21','227',1,'Retail Sale Id 2065',0.00,798.00,760.00,798.00,0.00,'2022-06-19 18:35:04'),(1606,'21','227',1,'Retail Sale Id 2066',0.00,995.60,760.00,995.60,0.00,'2022-06-19 18:35:35'),(1607,'21','227',1,'Retail Sale Id 2067',0.00,995.60,760.00,995.60,0.00,'2022-06-19 18:38:50'),(1608,'21','227',1,'Retail Sale Id 1964',0.00,1345.20,760.00,1345.20,0.00,'2022-06-19 18:48:03'),(1609,'21','227',1,'Retail Sale Id 2068',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 09:16:04'),(1610,'21','227',1,'Retail Sale Id 2069',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 09:18:29'),(1611,'21','227',1,'Retail Sale Id 2070',0.00,995.60,760.00,995.60,0.00,'2022-06-20 09:19:34'),(1612,'21','227',1,'Retail Sale Id 2071',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 09:21:00'),(1613,'21','227',1,'Retail Sale Id 2072',0.00,7600.00,760.00,7600.00,0.00,'2022-06-20 09:22:56'),(1614,'21','227',1,'Retail Sale Id 2073',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 09:24:27'),(1615,'21','227',1,'Retail Sale Id 2074',0.00,1694.80,760.00,1694.80,0.00,'2022-06-20 09:26:33'),(1616,'21','227',1,'Retail Sale Id 2075',0.00,798.00,760.00,798.00,0.00,'2022-06-20 09:28:42'),(1617,'21','227',1,'Retail Sale Id 2076',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 09:37:07'),(1618,'21','227',1,'Retail Sale Id 2077',0.00,4993.20,760.00,4993.20,0.00,'2022-06-20 09:59:56'),(1619,'21','227',1,'Retail Sale Id 2078',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 10:01:27'),(1620,'21','227',1,'Retail Sale Id 2079',0.00,2492.80,760.00,2492.80,0.00,'2022-06-20 10:08:51'),(1621,'21','227',1,'Retail Sale Id 2080',0.00,1793.60,760.00,1793.60,0.00,'2022-06-20 10:14:47'),(1622,'21','227',1,'Retail Sale Id 2081',0.00,995.60,760.00,995.60,0.00,'2022-06-20 10:18:15'),(1623,'21','227',1,'Retail Sale Id 2082',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 10:40:46'),(1624,'21','227',1,'Retail Sale Id 2083',0.00,1398.40,760.00,1398.40,0.00,'2022-06-20 10:49:29'),(1625,'21','227',1,'Retail Sale Id 2084',0.00,4560.00,760.00,4560.00,0.00,'2022-06-20 10:51:10'),(1626,'21','227',1,'Retail Sale Id 2085',0.00,7995.20,760.00,7995.20,0.00,'2022-06-20 10:52:23'),(1627,'21','227',1,'Retail Sale Id 2086',0.00,4993.20,760.00,4993.20,0.00,'2022-06-20 10:53:23'),(1628,'21','227',1,'Retail Sale Id 2087',0.00,1193.20,760.00,1193.20,0.00,'2022-06-20 10:56:15'),(1629,'21','227',1,'Retail Sale Id 2088',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 10:58:04'),(1630,'21','227',1,'Retail Sale Id 2089',0.00,760.00,760.00,760.00,0.00,'2022-06-20 11:12:10'),(1631,'21','227',1,'Retail Sale Id 2090',0.00,798.00,760.00,798.00,0.00,'2022-06-20 11:13:13'),(1632,'21','227',1,'Retail Sale Id 2091',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 11:25:18'),(1633,'21','227',1,'Retail Sale Id 2092',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 11:29:11'),(1634,'21','227',1,'Retail Sale Id 2093',0.00,995.60,760.00,995.60,0.00,'2022-06-20 11:30:15'),(1635,'21','227',1,'Retail Sale Id 2094',0.00,3800.00,760.00,3800.00,0.00,'2022-06-20 11:41:33'),(1636,'21','227',1,'Retail Sale Id 2095',0.00,124640.00,760.00,124640.00,0.00,'2022-06-20 12:06:38'),(1637,'21','227',1,'Retail Sale Id 2096',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 12:11:32'),(1638,'21','227',1,'Retail Sale Id 2097',0.00,995.60,760.00,995.60,0.00,'2022-06-20 12:12:18'),(1639,'21','227',1,'Retail Sale Id 2098',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 13:10:44'),(1640,'21','227',1,'Retail Sale Id 2099',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 13:13:44'),(1641,'21','227',1,'Retail Sale Id 2100',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 13:14:27'),(1642,'21','227',1,'Retail Sale Id 2101',0.00,995.60,760.00,995.60,0.00,'2022-06-20 13:22:52'),(1643,'21','227',1,'Retail Sale Id 2102',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 13:29:59'),(1644,'21','227',1,'Retail Sale Id 2103',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 13:35:27'),(1645,'21','227',1,'Retail Sale Id 2104',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 13:43:00'),(1646,'21','227',1,'Retail Sale Id 2105',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 13:45:28'),(1647,'21','227',1,'Retail Sale Id 2106',0.00,995.60,760.00,995.60,0.00,'2022-06-20 13:48:29'),(1648,'21','227',1,'Retail Sale Id 2107',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 13:50:10'),(1649,'21','227',1,'Retail Sale Id 2108',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 13:58:00'),(1650,'21','227',1,'Retail Sale Id 2109',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 13:59:02'),(1651,'21','227',1,'Retail Sale Id 2110',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 14:06:59'),(1652,'21','227',1,'Retail Sale Id 2111',0.00,14440.00,760.00,14440.00,0.00,'2022-06-20 14:57:27'),(1653,'21','227',1,'Retail Sale Id 2112',0.00,3800.00,760.00,3800.00,0.00,'2022-06-20 15:02:22'),(1654,'21','227',1,'Retail Sale Id 2113',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 15:13:38'),(1655,'21','227',1,'Retail Sale Id 2114',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 15:19:48'),(1656,'21','227',1,'Retail Sale Id 2115',0.00,896.80,760.00,896.80,0.00,'2022-06-20 15:23:22'),(1657,'21','227',1,'Retail Sale Id 2116',0.00,1520.00,760.00,1520.00,0.00,'2022-06-20 15:24:20'),(1658,'21','227',1,'Retail Sale Id 2117',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 15:26:35'),(1659,'21','227',1,'Retail Sale Id 2118',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 15:32:33'),(1660,'21','227',1,'Retail Sale Id 2119',0.00,494.00,760.00,494.00,0.00,'2022-06-20 15:34:04'),(1661,'21','227',1,'Retail Sale Id 2120',0.00,14440.00,760.00,14440.00,0.00,'2022-06-20 16:09:04'),(1662,'21','227',1,'Retail Sale Id 2121',0.00,4560.00,760.00,4560.00,0.00,'2022-06-20 16:15:58'),(1663,'21','227',1,'Retail Sale Id 2122',0.00,699.20,760.00,699.20,0.00,'2022-06-20 16:25:29'),(1664,'21','227',1,'Retail Sale Id 2123',0.00,995.60,760.00,995.60,0.00,'2022-06-20 16:47:19'),(1665,'21','227',1,'Retail Sale Id 2124',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 16:48:20'),(1666,'21','227',1,'Retail Sale Id 2125',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 16:52:06'),(1667,'21','227',1,'Retail Sale Id 2126',0.00,995.60,760.00,995.60,0.00,'2022-06-20 16:56:33'),(1668,'21','227',1,'Retail Sale Id 2127',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 16:59:55'),(1669,'21','227',1,'Retail Sale Id 2128',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 17:01:40'),(1670,'21','227',1,'Retail Sale Id 2129',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 17:04:24'),(1671,'21','227',1,'Retail Sale Id 2130',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 17:15:10'),(1672,'21','227',1,'Retail Sale Id 2131',0.00,494.00,760.00,494.00,0.00,'2022-06-20 17:17:55'),(1673,'21','227',1,'Retail Sale Id 2132',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 17:20:59'),(1674,'21','227',1,'Retail Sale Id 2133',0.00,2492.80,760.00,2492.80,0.00,'2022-06-20 17:21:59'),(1675,'21','227',1,'Retail Sale Id 2134',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 17:24:52'),(1676,'21','227',1,'Retail Sale Id 2136',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 17:25:39'),(1677,'21','227',1,'Retail Sale Id 2137',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 17:26:44'),(1678,'21','227',1,'Retail Sale Id 2138',0.00,2492.80,760.00,2492.80,0.00,'2022-06-20 17:27:41'),(1679,'21','227',1,'Retail Sale Id 2140',0.00,995.60,760.00,995.60,0.00,'2022-06-20 17:30:00'),(1680,'21','227',1,'Retail Sale Id 2141',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 17:30:48'),(1681,'21','227',1,'Retail Sale Id 2142',0.00,798.00,760.00,798.00,0.00,'2022-06-20 17:32:18'),(1682,'21','227',1,'Retail Sale Id 2143',0.00,1793.60,760.00,1793.60,0.00,'2022-06-20 17:39:42'),(1683,'21','227',1,'Retail Sale Id 2144',0.00,2196.40,760.00,2196.40,0.00,'2022-06-20 17:42:09'),(1684,'21','227',1,'Retail Sale Id 2145',0.00,4598.00,760.00,4598.00,0.00,'2022-06-20 17:43:46'),(1685,'21','227',1,'Retail Sale Id 2146',0.00,4560.00,760.00,4560.00,0.00,'2022-06-20 17:47:29'),(1686,'21','227',1,'Retail Sale Id 2147',0.00,1520.00,760.00,1520.00,0.00,'2022-06-20 17:49:55'),(1687,'21','227',1,'Retail Sale Id 2148',0.00,798.00,760.00,798.00,0.00,'2022-06-20 17:52:30'),(1688,'21','227',1,'Retail Sale Id 2149',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 17:57:33'),(1689,'21','227',1,'Retail Sale Id 2150',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 18:03:52'),(1690,'21','227',1,'Retail Sale Id 2151',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 18:05:12'),(1691,'21','227',1,'Retail Sale Id 2151',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 18:05:12'),(1692,'21','227',1,'Retail Sale Id 2152',0.00,995.60,760.00,995.60,0.00,'2022-06-20 18:07:45'),(1693,'21','227',1,'Retail Sale Id 2152',0.00,995.60,760.00,995.60,0.00,'2022-06-20 18:07:45'),(1694,'21','227',1,'Retail Sale Id 2153',0.00,9500.00,760.00,9500.00,0.00,'2022-06-20 18:08:35'),(1695,'21','227',1,'Retail Sale Id 2154',0.00,2295.20,760.00,2295.20,0.00,'2022-06-20 18:09:36'),(1696,'21','227',1,'Retail Sale Id 2155',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 18:10:28'),(1697,'21','227',1,'Retail Sale Id 2156',0.00,995.60,760.00,995.60,0.00,'2022-06-20 18:11:22'),(1698,'21','227',1,'Retail Sale Id 2156',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 18:11:22'),(1699,'21','227',1,'Retail Sale Id 2157',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 18:12:18'),(1700,'21','227',1,'Retail Sale Id 2158',0.00,18240.00,760.00,18240.00,0.00,'2022-06-20 18:16:17'),(1701,'21','227',1,'Retail Sale Id 2159',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 18:20:11'),(1702,'21','227',1,'Retail Sale Id 2160',0.00,3800.00,760.00,3800.00,0.00,'2022-06-20 18:21:05'),(1703,'21','227',1,'Retail Sale Id 2139',0.00,995.60,760.00,995.60,0.00,'2022-06-20 18:24:53'),(1704,'21','227',1,'Retail Sale Id 2161',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 18:25:51'),(1705,'21','227',1,'Retail Sale Id 2135',0.00,2280.00,760.00,2280.00,0.00,'2022-06-20 18:26:36'),(1706,'21','227',1,'Retail Sale Id 2162',0.00,1998.80,760.00,1998.80,0.00,'2022-06-20 18:29:34'),(1707,'21','227',1,'Retail Sale Id 2163',0.00,4993.20,760.00,4993.20,0.00,'2022-06-20 18:30:45'),(1708,'21','227',1,'Retail Sale Id 2164',0.00,7995.20,760.00,7995.20,0.00,'2022-06-20 18:31:59'),(1709,'21','227',1,'Retail Sale Id 2165',0.00,3800.00,760.00,3800.00,0.00,'2022-06-20 18:32:52'),(1710,'21','227',1,'Retail Sale Id 2166',0.00,2994.40,760.00,2994.40,0.00,'2022-06-20 18:34:13'),(1711,'21','227',1,'Retail Sale Id 2167',0.00,1497.20,760.00,1497.20,0.00,'2022-06-20 18:34:54'),(1712,'21','227',1,'Retail Sale Id 2168',0.00,4560.00,760.00,4560.00,0.00,'2022-06-20 18:35:39'),(1713,'21','227',1,'Retail Sale Id 2169',0.00,995.60,760.00,995.60,0.00,'2022-06-20 18:36:19'),(1714,'21','227',1,'Retail Sale Id 2170',0.00,4993.20,760.00,4993.20,0.00,'2022-06-20 18:38:10'),(1715,'21','227',1,'Retail Sale Id 2171',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 09:00:52'),(1716,'21','227',1,'Retail Sale Id 2172',0.00,9500.00,760.00,9500.00,0.00,'2022-06-21 09:01:31'),(1717,'21','227',1,'Retail Sale Id 2173',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 09:02:26'),(1718,'21','227',1,'Retail Sale Id 2174',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 09:05:16'),(1719,'21','227',1,'Retail Sale Id 2175',0.00,1299.60,760.00,1299.60,0.00,'2022-06-21 09:05:46'),(1720,'21','227',1,'Retail Sale Id 2176',0.00,2492.80,760.00,2492.80,0.00,'2022-06-21 09:06:16'),(1721,'21','227',1,'Retail Sale Id 2177',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 09:06:42'),(1722,'21','227',1,'Retail Sale Id 2178',0.00,4499.20,760.00,4499.20,0.00,'2022-06-21 09:07:09'),(1723,'21','227',1,'Retail Sale Id 2179',0.00,995.60,760.00,995.60,0.00,'2022-06-21 12:34:29'),(1724,'21','227',1,'Retail Sale Id 2180',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 12:34:51'),(1725,'21','227',1,'Retail Sale Id 2181',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 12:35:18'),(1726,'21','227',1,'Retail Sale Id 2182',0.00,798.00,760.00,798.00,0.00,'2022-06-21 12:35:44'),(1727,'21','227',1,'Retail Sale Id 2183',0.00,995.60,760.00,995.60,0.00,'2022-06-21 12:36:18'),(1728,'21','227',1,'Retail Sale Id 2184',0.00,4499.20,760.00,4499.20,0.00,'2022-06-21 12:36:49'),(1729,'21','227',1,'Retail Sale Id 2185',0.00,1299.60,760.00,1299.60,0.00,'2022-06-21 12:37:17'),(1730,'21','227',1,'Retail Sale Id 2186',0.00,2492.80,760.00,2492.80,0.00,'2022-06-21 12:37:47'),(1731,'21','227',1,'Retail Sale Id 2187',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 12:38:31'),(1732,'21','227',1,'Retail Sale Id 2188',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 12:38:54'),(1733,'21','227',1,'Retail Sale Id 2189',0.00,1694.80,760.00,1694.80,0.00,'2022-06-21 14:00:28'),(1734,'21','227',1,'Retail Sale Id 2190',0.00,2280.00,760.00,2280.00,0.00,'2022-06-21 14:01:29'),(1735,'21','227',1,'Retail Sale Id 2191',0.00,995.60,760.00,995.60,0.00,'2022-06-21 14:06:32'),(1736,'21','227',1,'Retail Sale Id 2192',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 14:09:45'),(1737,'21','227',1,'Retail Sale Id 2193',0.00,995.60,760.00,995.60,0.00,'2022-06-21 14:15:43'),(1738,'21','227',1,'Retail Sale Id 2194',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 14:16:19'),(1739,'21','227',1,'Retail Sale Id 2195',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 14:16:42'),(1740,'21','227',1,'Retail Sale Id 2196',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 14:17:04'),(1741,'21','227',1,'Retail Sale Id 2197',0.00,995.60,760.00,995.60,0.00,'2022-06-21 14:17:29'),(1742,'21','227',1,'Retail Sale Id 2198',0.00,2796.80,760.00,2796.80,0.00,'2022-06-21 14:18:35'),(1743,'21','227',1,'Retail Sale Id 2199',0.00,19000.00,760.00,19000.00,0.00,'2022-06-21 14:19:05'),(1744,'21','227',1,'Retail Sale Id 2200',0.00,2295.20,760.00,2295.20,0.00,'2022-06-21 14:19:28'),(1745,'21','227',1,'Retail Sale Id 2201',0.00,2295.20,760.00,2295.20,0.00,'2022-06-21 14:19:55'),(1746,'21','227',1,'Retail Sale Id 2202',0.00,1193.20,760.00,1193.20,0.00,'2022-06-21 14:20:16'),(1747,'21','227',1,'Retail Sale Id 2203',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 14:20:49'),(1748,'21','227',1,'Retail Sale Id 2204',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 14:21:10'),(1749,'21','227',1,'Retail Sale Id 2205',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 14:21:38'),(1750,'21','227',1,'Retail Sale Id 2206',0.00,798.00,760.00,798.00,0.00,'2022-06-21 14:22:24'),(1751,'21','227',1,'Retail Sale Id 2206',0.00,4993.20,760.00,4993.20,0.00,'2022-06-21 14:22:24'),(1752,'21','227',1,'Retail Sale Id 2207',0.00,699.20,760.00,699.20,0.00,'2022-06-21 14:22:50'),(1753,'21','227',1,'Retail Sale Id 2208',0.00,494.00,760.00,494.00,0.00,'2022-06-21 16:56:29'),(1754,'21','227',1,'Retail Sale Id 2209',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 16:56:52'),(1755,'21','227',1,'Retail Sale Id 2210',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 16:57:09'),(1756,'21','227',1,'Retail Sale Id 2211',0.00,1793.60,760.00,1793.60,0.00,'2022-06-21 16:57:32'),(1757,'21','227',1,'Retail Sale Id 2212',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 16:57:59'),(1758,'21','227',1,'Retail Sale Id 2213',0.00,1793.60,760.00,1793.60,0.00,'2022-06-21 16:58:29'),(1759,'21','227',1,'Retail Sale Id 2214',0.00,1793.60,760.00,1793.60,0.00,'2022-06-21 16:58:55'),(1760,'21','227',1,'Retail Sale Id 2215',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 16:59:17'),(1761,'21','227',1,'Retail Sale Id 2216',0.00,2295.20,760.00,2295.20,0.00,'2022-06-21 16:59:50'),(1762,'21','227',1,'Retail Sale Id 2217',0.00,2280.00,760.00,2280.00,0.00,'2022-06-21 17:00:14'),(1763,'21','227',1,'Retail Sale Id 2218',0.00,1094.40,760.00,1094.40,0.00,'2022-06-21 17:00:57'),(1764,'21','227',1,'Retail Sale Id 2218',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 17:00:57'),(1765,'21','227',1,'Retail Sale Id 2218',0.00,9500.00,760.00,9500.00,0.00,'2022-06-21 17:00:57'),(1766,'21','227',1,'Retail Sale Id 2219',0.00,988.00,760.00,988.00,0.00,'2022-06-21 17:01:42'),(1767,'21','227',1,'Retail Sale Id 2219',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 17:01:42'),(1768,'21','227',1,'Retail Sale Id 2219',0.00,2280.00,760.00,2280.00,0.00,'2022-06-21 17:01:42'),(1769,'21','227',1,'Retail Sale Id 2220',0.00,2196.40,760.00,2196.40,0.00,'2022-06-21 17:02:27'),(1770,'21','227',1,'Retail Sale Id 2220',0.00,2280.00,760.00,2280.00,0.00,'2022-06-21 17:02:27'),(1771,'21','227',1,'Retail Sale Id 2220',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 17:02:27'),(1772,'21','227',1,'Retail Sale Id 2221',0.00,1193.20,760.00,1193.20,0.00,'2022-06-21 17:03:21'),(1773,'21','227',1,'Retail Sale Id 2221',0.00,2492.80,760.00,2492.80,0.00,'2022-06-21 17:03:21'),(1774,'21','227',1,'Retail Sale Id 2221',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 17:03:21'),(1775,'21','227',1,'Retail Sale Id 2223',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:04:46'),(1776,'21','227',1,'Retail Sale Id 2223',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 17:04:46'),(1777,'21','227',1,'Retail Sale Id 2223',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:04:46'),(1778,'21','227',1,'Retail Sale Id 2223',0.00,2492.80,760.00,2492.80,0.00,'2022-06-21 17:04:46'),(1779,'21','227',1,'Retail Sale Id 2224',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 17:06:31'),(1780,'21','227',1,'Retail Sale Id 2225',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 17:07:16'),(1781,'21','227',1,'Retail Sale Id 2225',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:07:16'),(1782,'21','227',1,'Retail Sale Id 2225',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 17:07:16'),(1783,'21','227',1,'Retail Sale Id 2226',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 17:08:11'),(1784,'21','227',1,'Retail Sale Id 2226',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:08:11'),(1785,'21','227',1,'Retail Sale Id 2226',0.00,2280.00,760.00,2280.00,0.00,'2022-06-21 17:08:11'),(1786,'21','227',1,'Retail Sale Id 2226',0.00,3997.60,760.00,3997.60,0.00,'2022-06-21 17:08:11'),(1787,'21','227',1,'Retail Sale Id 2227',0.00,760.00,760.00,760.00,0.00,'2022-06-21 17:09:19'),(1788,'21','227',1,'Retail Sale Id 2227',0.00,798.00,760.00,798.00,0.00,'2022-06-21 17:09:19'),(1789,'21','227',1,'Retail Sale Id 2227',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:09:19'),(1790,'21','227',1,'Retail Sale Id 2227',0.00,2204.00,760.00,2204.00,0.00,'2022-06-21 17:09:19'),(1791,'21','227',1,'Retail Sale Id 2227',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 17:09:19'),(1792,'21','227',1,'Retail Sale Id 2228',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:10:02'),(1793,'21','227',1,'Retail Sale Id 2228',0.00,1094.40,760.00,1094.40,0.00,'2022-06-21 17:10:02'),(1794,'21','227',1,'Retail Sale Id 2228',0.00,1193.20,760.00,1193.20,0.00,'2022-06-21 17:10:02'),(1795,'21','227',1,'Retail Sale Id 2229',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 17:10:58'),(1796,'21','227',1,'Retail Sale Id 2229',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 17:10:58'),(1797,'21','227',1,'Retail Sale Id 2230',0.00,1299.60,760.00,1299.60,0.00,'2022-06-21 17:11:45'),(1798,'21','227',1,'Retail Sale Id 2230',0.00,1755.60,760.00,1755.60,0.00,'2022-06-21 17:11:45'),(1799,'21','227',1,'Retail Sale Id 2230',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:11:45'),(1800,'21','227',1,'Retail Sale Id 2231',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 17:12:23'),(1801,'21','227',1,'Retail Sale Id 2231',0.00,9500.00,760.00,9500.00,0.00,'2022-06-21 17:12:23'),(1802,'21','227',1,'Retail Sale Id 2232',0.00,699.20,760.00,699.20,0.00,'2022-06-21 17:12:58'),(1803,'21','227',1,'Retail Sale Id 2232',0.00,798.00,760.00,798.00,0.00,'2022-06-21 17:12:58'),(1804,'21','227',1,'Retail Sale Id 2233',0.00,76000.00,760.00,76000.00,0.00,'2022-06-21 17:23:22'),(1805,'21','227',1,'Retail Sale Id 2234',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:25:05'),(1806,'21','227',1,'Retail Sale Id 2234',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:25:05'),(1807,'21','227',1,'Retail Sale Id 2234',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:25:05'),(1808,'21','227',1,'Retail Sale Id 2235',0.00,1193.20,760.00,1193.20,0.00,'2022-06-21 17:25:38'),(1809,'21','227',1,'Retail Sale Id 2236',0.00,1299.60,760.00,1299.60,0.00,'2022-06-21 17:26:25'),(1810,'21','227',1,'Retail Sale Id 2237',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:27:26'),(1811,'21','227',1,'Retail Sale Id 2238',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:29:31'),(1812,'21','227',1,'Retail Sale Id 2238',0.00,4993.20,760.00,4993.20,0.00,'2022-06-21 17:29:31'),(1813,'21','227',1,'Retail Sale Id 2238',0.00,9500.00,760.00,9500.00,0.00,'2022-06-21 17:29:31'),(1814,'21','227',1,'Retail Sale Id 2239',0.00,2280.00,760.00,2280.00,0.00,'2022-06-21 17:30:18'),(1815,'21','227',1,'Retail Sale Id 2240',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:31:37'),(1816,'21','227',1,'Retail Sale Id 2240',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:31:37'),(1817,'21','227',1,'Retail Sale Id 2240',0.00,1140.00,760.00,1140.00,0.00,'2022-06-21 17:31:37'),(1818,'21','227',1,'Retail Sale Id 2241',0.00,2994.40,760.00,2994.40,0.00,'2022-06-21 17:32:21'),(1819,'21','227',1,'Retail Sale Id 2242',0.00,798.00,760.00,798.00,0.00,'2022-06-21 17:32:49'),(1820,'21','227',1,'Retail Sale Id 2243',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:33:14'),(1821,'21','227',1,'Retail Sale Id 2244',0.00,1520.00,760.00,1520.00,0.00,'2022-06-21 17:34:31'),(1822,'21','227',1,'Retail Sale Id 2245',0.00,2196.40,760.00,2196.40,0.00,'2022-06-21 17:35:16'),(1823,'21','227',1,'Retail Sale Id 2246',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:36:39'),(1824,'21','227',1,'Retail Sale Id 2246',0.00,2492.80,760.00,2492.80,0.00,'2022-06-21 17:36:39'),(1825,'21','227',1,'Retail Sale Id 2246',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 17:36:39'),(1826,'21','227',1,'Retail Sale Id 2247',0.00,3040.00,760.00,3040.00,0.00,'2022-06-21 17:37:41'),(1827,'21','227',1,'Retail Sale Id 2247',0.00,7600.00,760.00,7600.00,0.00,'2022-06-21 17:37:41'),(1828,'21','227',1,'Retail Sale Id 2247',0.00,9500.00,760.00,9500.00,0.00,'2022-06-21 17:37:41'),(1829,'21','227',1,'Retail Sale Id 2248',0.00,1793.60,760.00,1793.60,0.00,'2022-06-21 17:38:43'),(1830,'21','227',1,'Retail Sale Id 2248',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:38:43'),(1831,'21','227',1,'Retail Sale Id 2248',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:38:43'),(1832,'21','227',1,'Retail Sale Id 2249',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:39:28'),(1833,'21','227',1,'Retail Sale Id 2249',0.00,1793.60,760.00,1793.60,0.00,'2022-06-21 17:39:28'),(1834,'21','227',1,'Retail Sale Id 2250',0.00,2097.60,760.00,2097.60,0.00,'2022-06-21 17:39:59'),(1835,'21','227',1,'Retail Sale Id 2251',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:40:45'),(1836,'21','227',1,'Retail Sale Id 2252',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 17:41:20'),(1837,'21','227',1,'Retail Sale Id 2253',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:42:53'),(1838,'21','227',1,'Retail Sale Id 2253',0.00,2280.00,760.00,2280.00,0.00,'2022-06-21 17:42:53'),(1839,'21','227',1,'Retail Sale Id 2254',0.00,995.60,760.00,995.60,0.00,'2022-06-21 17:43:47'),(1840,'21','227',1,'Retail Sale Id 2254',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 17:43:47'),(1841,'21','227',1,'Retail Sale Id 2255',0.00,896.80,760.00,896.80,0.00,'2022-06-21 17:44:46'),(1842,'21','227',1,'Retail Sale Id 2255',0.00,1193.20,760.00,1193.20,0.00,'2022-06-21 17:44:46'),(1843,'21','227',1,'Retail Sale Id 2255',0.00,2280.00,760.00,2280.00,0.00,'2022-06-21 17:44:46'),(1844,'21','227',1,'Retail Sale Id 2256',0.00,3040.00,760.00,3040.00,0.00,'2022-06-21 17:46:41'),(1845,'21','227',1,'Retail Sale Id 2258',0.00,2492.80,760.00,2492.80,0.00,'2022-06-21 19:14:09'),(1846,'21','227',1,'Retail Sale Id 2259',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 19:14:29'),(1847,'21','227',1,'Retail Sale Id 2260',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 19:14:50'),(1848,'21','227',1,'Retail Sale Id 2261',0.00,4993.20,760.00,4993.20,0.00,'2022-06-21 19:15:14'),(1849,'21','227',1,'Retail Sale Id 2262',0.00,995.60,760.00,995.60,0.00,'2022-06-21 19:15:38'),(1850,'21','227',1,'Retail Sale Id 2263',0.00,798.00,760.00,798.00,0.00,'2022-06-21 19:16:00'),(1851,'21','227',1,'Retail Sale Id 2264',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 19:16:22'),(1852,'21','227',1,'Retail Sale Id 2265',0.00,3800.00,760.00,3800.00,0.00,'2022-06-21 19:16:44'),(1853,'21','227',1,'Retail Sale Id 2266',0.00,5494.80,760.00,5494.80,0.00,'2022-06-21 19:17:07'),(1854,'21','227',1,'Retail Sale Id 2267',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 19:17:30'),(1855,'21','227',1,'Retail Sale Id 2268',0.00,1998.80,760.00,1998.80,0.00,'2022-06-21 19:18:15'),(1856,'21','227',1,'Retail Sale Id 2269',0.00,995.60,760.00,995.60,0.00,'2022-06-21 19:18:42'),(1857,'21','227',1,'Retail Sale Id 2270',0.00,1497.20,760.00,1497.20,0.00,'2022-06-21 19:19:07'),(1858,'21','227',1,'Retail Sale Id 2271',0.00,995.60,760.00,995.60,0.00,'2022-06-21 19:19:32'),(1859,'21','227',1,'Retail Sale Id 2272',0.00,4560.00,760.00,4560.00,0.00,'2022-06-21 19:19:54'),(1860,'21','227',1,'Retail Sale Id 2273',0.00,1398.40,760.00,1398.40,0.00,'2022-06-21 19:20:21'),(1861,'21','227',1,'Retail Sale Id 2274',0.00,2295.20,760.00,2295.20,0.00,'2022-06-21 19:20:44'),(1862,'21','227',1,'Retail Sale Id 2275',0.00,6057.20,760.00,6057.20,0.00,'2022-06-21 19:22:45'),(1863,'21','227',1,'Retail Sale Id 2276',0.00,3040.00,760.00,3040.00,0.00,'2022-06-22 08:42:53'),(1864,'21','227',1,'Retail Sale Id 2277',0.00,798.00,760.00,798.00,0.00,'2022-06-22 09:45:35'),(1865,'21','227',1,'Retail Sale Id 2278',0.00,995.60,760.00,995.60,0.00,'2022-06-22 09:49:28'),(1866,'21','227',1,'Retail Sale Id 2279',0.00,3800.00,760.00,3800.00,0.00,'2022-06-22 09:50:38'),(1867,'21','227',1,'Retail Sale Id 2280',0.00,7600.00,760.00,7600.00,0.00,'2022-06-22 09:53:00'),(1868,'21','227',1,'Retail Sale Id 2281',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 09:56:57'),(1869,'21','227',1,'Retail Sale Id 2282',0.00,3800.00,760.00,3800.00,0.00,'2022-06-22 10:00:58'),(1870,'21','227',1,'Retail Sale Id 2283',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 10:05:00'),(1871,'21','227',1,'Retail Sale Id 2284',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 10:06:55'),(1872,'21','227',1,'Retail Sale Id 2285',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 10:08:08'),(1873,'21','227',1,'Retail Sale Id 2286',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 10:12:19'),(1874,'21','227',1,'Retail Sale Id 2287',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 10:13:11'),(1875,'21','227',1,'Retail Sale Id 2288',0.00,2280.00,760.00,2280.00,0.00,'2022-06-22 10:14:07'),(1876,'21','227',1,'Retail Sale Id 2289',0.00,1520.00,760.00,1520.00,0.00,'2022-06-22 10:15:16'),(1877,'21','227',1,'Retail Sale Id 2290',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 10:17:17'),(1878,'21','227',1,'Retail Sale Id 2291',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 10:18:14'),(1879,'21','227',1,'Retail Sale Id 2292',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 10:28:21'),(1880,'21','227',1,'Retail Sale Id 2293',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 10:29:07'),(1881,'21','227',1,'Retail Sale Id 2294',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 10:45:31'),(1882,'21','227',1,'Retail Sale Id 2295',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 10:56:09'),(1883,'21','227',1,'Retail Sale Id 2296',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 10:57:26'),(1884,'21','227',1,'Retail Sale Id 2297',0.00,15960.00,760.00,15960.00,0.00,'2022-06-22 10:59:25'),(1885,'21','227',1,'Retail Sale Id 2298',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 11:00:50'),(1886,'21','227',1,'Retail Sale Id 2299',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 11:35:00'),(1887,'21','227',1,'Retail Sale Id 2300',0.00,7600.00,760.00,7600.00,0.00,'2022-06-22 11:35:38'),(1888,'21','227',1,'Retail Sale Id 2301',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 11:41:41'),(1889,'21','227',1,'Retail Sale Id 2302',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 12:06:37'),(1890,'21','227',1,'Retail Sale Id 2303',0.00,3800.00,760.00,3800.00,0.00,'2022-06-22 12:07:17'),(1891,'21','227',1,'Retail Sale Id 2304',0.00,995.60,760.00,995.60,0.00,'2022-06-22 12:24:08'),(1892,'21','227',1,'Retail Sale Id 2305',0.00,2280.00,760.00,2280.00,0.00,'2022-06-22 12:46:47'),(1893,'21','227',1,'Retail Sale Id 2306',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 13:26:17'),(1894,'21','227',1,'Retail Sale Id 2307',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 13:36:15'),(1895,'21','227',1,'Retail Sale Id 2308',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 13:44:45'),(1896,'21','227',1,'Retail Sale Id 2309',0.00,896.80,760.00,896.80,0.00,'2022-06-22 13:50:46'),(1897,'21','227',1,'Retail Sale Id 2310',0.00,11400.00,760.00,11400.00,0.00,'2022-06-22 13:59:41'),(1898,'21','227',1,'Retail Sale Id 2311',0.00,4750.00,760.00,4750.00,0.00,'2022-06-22 14:00:33'),(1899,'21','227',1,'Retail Sale Id 2312',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 14:03:58'),(1900,'21','227',1,'Retail Sale Id 2313',0.00,2112.80,760.00,2112.80,0.00,'2022-06-22 14:12:44'),(1901,'21','227',1,'Retail Sale Id 2314',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 14:20:50'),(1902,'21','227',1,'Retail Sale Id 2315',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 14:21:40'),(1903,'21','227',1,'Retail Sale Id 2316',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 14:27:33'),(1904,'21','227',1,'Retail Sale Id 2317',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 14:29:01'),(1905,'21','227',1,'Retail Sale Id 2318',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 14:49:36'),(1906,'21','227',1,'Retail Sale Id 2319',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 15:10:26'),(1907,'21','227',1,'Retail Sale Id 2320',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 15:11:35'),(1908,'21','227',1,'Retail Sale Id 2321',0.00,7600.00,760.00,7600.00,0.00,'2022-06-22 15:32:20'),(1909,'21','227',1,'Retail Sale Id 2322',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 15:57:34'),(1910,'21','227',1,'Retail Sale Id 2323',0.00,6794.40,760.00,6794.40,0.00,'2022-06-22 15:59:53'),(1911,'21','227',1,'Retail Sale Id 2324',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 16:11:38'),(1912,'21','227',1,'Retail Sale Id 2325',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 16:13:33'),(1913,'21','227',1,'Retail Sale Id 2326',0.00,995.60,760.00,995.60,0.00,'2022-06-22 16:15:17'),(1914,'21','227',1,'Retail Sale Id 2327',0.00,3800.00,760.00,3800.00,0.00,'2022-06-22 16:18:45'),(1915,'21','227',1,'Retail Sale Id 2328',0.00,760.00,760.00,760.00,0.00,'2022-06-22 16:21:38'),(1916,'21','227',1,'Retail Sale Id 2329',0.00,995.60,760.00,995.60,0.00,'2022-06-22 16:26:01'),(1917,'21','227',1,'Retail Sale Id 2330',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 16:30:34'),(1918,'21','227',1,'Retail Sale Id 2331',0.00,4499.20,760.00,4499.20,0.00,'2022-06-22 16:33:21'),(1919,'21','227',1,'Retail Sale Id 2332',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 16:35:35'),(1920,'21','227',1,'Retail Sale Id 2333',0.00,4499.20,760.00,4499.20,0.00,'2022-06-22 16:38:14'),(1921,'21','227',1,'Retail Sale Id 2334',0.00,2280.00,760.00,2280.00,0.00,'2022-06-22 16:39:19'),(1922,'21','227',1,'Retail Sale Id 2335',0.00,494.00,760.00,494.00,0.00,'2022-06-22 16:43:41'),(1923,'21','227',1,'Retail Sale Id 2336',0.00,798.00,760.00,798.00,0.00,'2022-06-22 16:45:25'),(1924,'21','227',1,'Retail Sale Id 2337',0.00,5996.40,760.00,5996.40,0.00,'2022-06-22 16:47:25'),(1925,'21','227',1,'Retail Sale Id 2338',0.00,2492.80,760.00,2492.80,0.00,'2022-06-22 16:47:58'),(1926,'21','227',1,'Retail Sale Id 2339',0.00,798.00,760.00,798.00,0.00,'2022-06-22 16:49:07'),(1927,'21','227',1,'Retail Sale Id 2340',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 16:49:51'),(1928,'21','227',1,'Retail Sale Id 2341',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 16:50:56'),(1929,'21','227',1,'Retail Sale Id 2342',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 16:51:34'),(1930,'21','227',1,'Retail Sale Id 2343',0.00,760.00,760.00,760.00,0.00,'2022-06-22 16:52:24'),(1931,'21','227',1,'Retail Sale Id 2344',0.00,995.60,760.00,995.60,0.00,'2022-06-22 16:58:03'),(1932,'21','227',1,'Retail Sale Id 2345',0.00,1520.00,760.00,1520.00,0.00,'2022-06-22 16:59:54'),(1933,'21','227',1,'Retail Sale Id 2346',0.00,3997.60,760.00,3997.60,0.00,'2022-06-22 17:01:06'),(1934,'21','227',1,'Retail Sale Id 2347',0.00,798.00,760.00,798.00,0.00,'2022-06-22 17:02:04'),(1935,'21','227',1,'Retail Sale Id 2348',0.00,3800.00,760.00,3800.00,0.00,'2022-06-22 17:06:22'),(1936,'21','227',1,'Retail Sale Id 2349',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 17:07:15'),(1937,'21','227',1,'Retail Sale Id 2350',0.00,494.00,760.00,494.00,0.00,'2022-06-22 17:08:28'),(1938,'21','227',1,'Retail Sale Id 2351',0.00,2492.80,760.00,2492.80,0.00,'2022-06-22 17:09:37'),(1939,'21','227',1,'Retail Sale Id 2351',0.00,2994.40,760.00,2994.40,0.00,'2022-06-22 17:09:37'),(1940,'21','227',1,'Retail Sale Id 2352',0.00,995.60,760.00,995.60,0.00,'2022-06-22 17:10:20'),(1941,'21','227',1,'Retail Sale Id 2353',0.00,2280.00,760.00,2280.00,0.00,'2022-06-22 17:11:14'),(1942,'21','227',1,'Retail Sale Id 2354',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 17:12:05'),(1943,'21','227',1,'Retail Sale Id 2355',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 17:16:21'),(1944,'21','227',1,'Retail Sale Id 2356',0.00,798.00,760.00,798.00,0.00,'2022-06-22 17:17:36'),(1945,'21','227',1,'Retail Sale Id 2357',0.00,7493.60,760.00,7493.60,0.00,'2022-06-22 17:24:40'),(1946,'21','227',1,'Retail Sale Id 2358',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 17:29:46'),(1947,'21','227',1,'Retail Sale Id 2359',0.00,1900.00,760.00,1900.00,0.00,'2022-06-22 17:37:00'),(1948,'21','227',1,'Retail Sale Id 2360',0.00,3997.60,760.00,3997.60,0.00,'2022-06-22 17:41:42'),(1949,'21','227',1,'Retail Sale Id 2361',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 17:43:29'),(1950,'21','227',1,'Retail Sale Id 2362',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 17:44:24'),(1951,'21','227',1,'Retail Sale Id 2363',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 17:45:13'),(1952,'21','227',1,'Retail Sale Id 2364',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 17:45:53'),(1953,'21','227',1,'Retail Sale Id 2365',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 17:46:55'),(1954,'21','227',1,'Retail Sale Id 2366',0.00,494.00,760.00,494.00,0.00,'2022-06-22 17:49:02'),(1955,'21','227',1,'Retail Sale Id 2367',0.00,9500.00,760.00,9500.00,0.00,'2022-06-22 17:50:09'),(1956,'21','227',1,'Retail Sale Id 2368',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 17:51:11'),(1957,'21','227',1,'Retail Sale Id 2369',0.00,4993.20,760.00,4993.20,0.00,'2022-06-22 17:55:37'),(1958,'21','227',1,'Retail Sale Id 2370',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 17:57:12'),(1959,'21','227',1,'Retail Sale Id 2371',0.00,896.80,760.00,896.80,0.00,'2022-06-22 17:58:11'),(1960,'21','227',1,'Retail Sale Id 2372',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 18:04:29'),(1961,'21','227',1,'Retail Sale Id 2373',0.00,995.60,760.00,995.60,0.00,'2022-06-22 18:05:18'),(1962,'21','227',1,'Retail Sale Id 2374',0.00,995.60,760.00,995.60,0.00,'2022-06-22 18:09:29'),(1963,'21','227',1,'Retail Sale Id 2375',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 18:11:01'),(1964,'21','227',1,'Retail Sale Id 2376',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 18:20:16'),(1965,'21','227',1,'Retail Sale Id 2377',0.00,1497.20,760.00,1497.20,0.00,'2022-06-22 18:23:08'),(1966,'21','227',1,'Retail Sale Id 2377',0.00,2994.40,760.00,2994.40,0.00,'2022-06-22 18:23:08'),(1967,'21','227',1,'Retail Sale Id 2378',0.00,995.60,760.00,995.60,0.00,'2022-06-22 18:24:36'),(1968,'21','227',1,'Retail Sale Id 2379',0.00,4993.20,760.00,4993.20,0.00,'2022-06-22 18:28:16'),(1969,'21','227',1,'Retail Sale Id 2380',0.00,7600.00,760.00,7600.00,0.00,'2022-06-22 18:30:46'),(1970,'21','227',1,'Retail Sale Id 2381',0.00,4993.20,760.00,4993.20,0.00,'2022-06-22 18:32:32'),(1971,'21','227',1,'Retail Sale Id 2382',0.00,4560.00,760.00,4560.00,0.00,'2022-06-22 18:36:56'),(1972,'21','227',1,'Retail Sale Id 2383',0.00,1520.00,760.00,1520.00,0.00,'2022-06-22 18:37:37'),(1973,'21','227',1,'Retail Sale Id 2384',0.00,1998.80,760.00,1998.80,0.00,'2022-06-22 18:43:49'),(1974,'21','227',1,'Retail Sale Id 2386',0.00,995.60,760.00,995.60,0.00,'2022-06-22 18:47:00'),(1975,'21','227',1,'Retail Sale Id 2387',0.00,6999.60,760.00,6999.60,0.00,'2022-06-23 10:49:49'),(1976,'21','227',1,'Retail Sale Id 2388',0.00,798.00,760.00,798.00,0.00,'2022-06-23 10:52:51'),(1977,'21','227',1,'Retail Sale Id 2389',0.00,1497.20,760.00,1497.20,0.00,'2022-06-23 10:54:19'),(1978,'21','227',1,'Retail Sale Id 2390',0.00,4560.00,760.00,4560.00,0.00,'2022-06-23 10:55:38'),(1979,'21','227',1,'Retail Sale Id 2391',0.00,995.60,760.00,995.60,0.00,'2022-06-23 10:57:45'),(1980,'21','227',1,'Retail Sale Id 2392',0.00,2994.40,760.00,2994.40,0.00,'2022-06-23 11:11:41'),(1981,'21','227',1,'Retail Sale Id 2393',0.00,995.60,760.00,995.60,0.00,'2022-06-23 12:02:27'),(1982,'21','227',1,'Retail Sale Id 2394',0.00,4560.00,760.00,4560.00,0.00,'2022-06-23 12:04:49'),(1983,'21','227',1,'Retail Sale Id 2395',0.00,1998.80,760.00,1998.80,0.00,'2022-06-23 12:06:31'),(1984,'21','227',1,'Retail Sale Id 2396',0.00,3997.60,760.00,3997.60,0.00,'2022-06-23 12:08:10'),(1985,'21','227',1,'Retail Sale Id 2397',0.00,9500.00,760.00,9500.00,0.00,'2022-06-23 12:08:50'),(1986,'21','227',1,'Retail Sale Id 2398',0.00,2280.00,760.00,2280.00,0.00,'2022-06-23 12:09:44'),(1987,'21','227',1,'Retail Sale Id 2399',0.00,3040.00,760.00,3040.00,0.00,'2022-06-23 12:10:55'),(1988,'21','227',1,'Retail Sale Id 2400',0.00,1497.20,760.00,1497.20,0.00,'2022-06-23 12:11:45'),(1989,'21','227',1,'Retail Sale Id 2401',0.00,5996.40,760.00,5996.40,0.00,'2022-06-23 12:12:46'),(1990,'21','227',1,'Retail Sale Id 2402',0.00,494.00,760.00,494.00,0.00,'2022-06-23 12:14:52'),(1991,'21','227',1,'Retail Sale Id 2403',0.00,3040.00,760.00,3040.00,0.00,'2022-06-23 12:16:14'),(1992,'21','227',1,'Retail Sale Id 2404',0.00,7600.00,760.00,7600.00,0.00,'2022-06-23 12:20:13'),(1993,'21','227',1,'Retail Sale Id 2405',0.00,4993.20,760.00,4993.20,0.00,'2022-06-23 12:21:06'),(1994,'21','227',1,'Retail Sale Id 2406',0.00,3800.00,760.00,3800.00,0.00,'2022-06-23 12:21:51'),(1995,'21','227',1,'Retail Sale Id 2407',0.00,4560.00,760.00,4560.00,0.00,'2022-06-23 12:22:37'),(1996,'21','227',1,'Retail Sale Id 2408',0.00,1497.20,760.00,1497.20,0.00,'2022-06-23 12:23:39'),(1997,'21','227',1,'Retail Sale Id 2409',0.00,9500.00,760.00,9500.00,0.00,'2022-06-23 12:24:38'),(1998,'21','227',1,'Retail Sale Id 2410',0.00,1520.00,760.00,1520.00,0.00,'2022-06-23 12:25:35'),(1999,'21','227',1,'Retail Sale Id 2411',0.00,1520.00,760.00,1520.00,0.00,'2022-06-23 12:26:16'),(2000,'21','227',1,'Retail Sale Id 2412',0.00,4560.00,760.00,4560.00,0.00,'2022-06-23 12:27:02'),(2001,'21','227',1,'Retail Sale Id 2413',0.00,3997.60,760.00,3997.60,0.00,'2022-06-23 12:28:00'),(2002,'21','227',1,'Retail Sale Id 2414',0.00,7600.00,760.00,7600.00,0.00,'2022-06-23 12:28:55'),(2003,'21','227',1,'Retail Sale Id 2415',0.00,6080.00,760.00,6080.00,0.00,'2022-06-23 12:29:46'),(2004,'21','227',1,'Retail Sale Id 2417',0.00,3496.00,760.00,3496.00,0.00,'2022-06-23 12:31:18'),(2005,'21','227',1,'Retail Sale Id 2416',0.00,9500.00,760.00,9500.00,0.00,'2022-06-23 12:32:20'),(2006,'21','227',1,'Retail Sale Id 2418',0.00,9500.00,760.00,9500.00,0.00,'2022-06-23 12:37:47'),(2007,'21','227',1,'Retail Sale Id 2419',0.00,15200.00,760.00,15200.00,0.00,'2022-06-23 13:08:24'),(2008,'21','227',1,'Retail Sale Id 2420',0.00,9500.00,760.00,9500.00,0.00,'2022-06-23 13:14:24'),(2009,'21','227',1,'Retail Sale Id 2421',0.00,3800.00,760.00,3800.00,0.00,'2022-06-23 13:15:04'),(2010,'21','227',1,'Retail Sale Id 2422',0.00,2994.40,760.00,2994.40,0.00,'2022-06-23 13:17:28'),(2011,'21','227',1,'Retail Sale Id 2423',0.00,3997.60,760.00,3997.60,0.00,'2022-06-23 13:29:01'),(2012,'21','227',1,'Retail Sale Id 2424',0.00,2994.40,760.00,2994.40,0.00,'2022-06-23 13:31:19'),(2013,'21','227',1,'Retail Sale Id 2425',0.00,995.60,760.00,995.60,0.00,'2022-06-23 13:34:21'),(2014,'21','227',1,'Retail Sale Id 2426',0.00,1497.20,760.00,1497.20,0.00,'2022-06-23 13:40:40'),(2015,'21','227',1,'Retail Sale Id 2427',0.00,995.60,760.00,995.60,0.00,'2022-06-23 13:42:18'),(2016,'21','227',1,'Retail Sale Id 2427',0.00,4993.20,760.00,4993.20,0.00,'2022-06-23 13:42:18'),(2017,'21','227',1,'Retail Sale Id 2428',0.00,760.00,760.00,760.00,0.00,'2022-06-23 13:44:18'),(2018,'21','227',1,'Retail Sale Id 2429',0.00,4560.00,760.00,4560.00,0.00,'2022-06-23 13:54:11'),(2019,'21','227',1,'Retail Sale Id 2430',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:00:19'),(2020,'21','227',1,'Retail Sale Id 2431',0.00,9500.00,760.00,9500.00,0.00,'2022-06-23 14:05:44'),(2021,'21','227',1,'Retail Sale Id 2432',0.00,2280.00,760.00,2280.00,0.00,'2022-06-23 14:16:35'),(2022,'21','227',1,'Retail Sale Id 2433',0.00,1497.20,760.00,1497.20,0.00,'2022-06-23 14:21:16'),(2023,'21','227',1,'Retail Sale Id 2434',0.00,3800.00,760.00,3800.00,0.00,'2022-06-23 14:22:54'),(2024,'21','227',1,'Retail Sale Id 2435',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:23:48'),(2025,'21','227',1,'Retail Sale Id 2436',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:26:49'),(2026,'21','227',1,'Retail Sale Id 2437',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:29:43'),(2027,'21','227',1,'Retail Sale Id 2438',0.00,4993.20,760.00,4993.20,0.00,'2022-06-23 14:33:40'),(2028,'21','227',1,'Retail Sale Id 2439',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:34:45'),(2029,'21','227',1,'Retail Sale Id 2440',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:36:15'),(2030,'21','227',1,'Retail Sale Id 2441',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:36:56'),(2031,'21','227',1,'Retail Sale Id 2442',0.00,3800.00,760.00,3800.00,0.00,'2022-06-23 14:37:41'),(2032,'21','227',1,'Retail Sale Id 2443',0.00,1998.80,760.00,1998.80,0.00,'2022-06-23 14:38:44'),(2033,'21','227',1,'Retail Sale Id 2444',0.00,494.00,760.00,494.00,0.00,'2022-06-23 14:39:24'),(2034,'21','227',1,'Retail Sale Id 2445',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:40:05'),(2035,'21','227',1,'Retail Sale Id 2446',0.00,4993.20,760.00,4993.20,0.00,'2022-06-23 14:47:45'),(2036,'21','227',1,'Retail Sale Id 2447',0.00,2280.00,760.00,2280.00,0.00,'2022-06-23 14:49:06'),(2037,'21','227',1,'Retail Sale Id 2448',0.00,995.60,760.00,995.60,0.00,'2022-06-23 14:55:33'),(2038,'21','227',1,'Retail Sale Id 2449',0.00,3800.00,760.00,3800.00,0.00,'2022-06-23 15:00:25'),(2039,'21','227',1,'Retail Sale Id 2450',0.00,4560.00,760.00,4560.00,0.00,'2022-06-23 18:07:57'),(2040,'21','227',1,'Retail Sale Id 2451',0.00,3800.00,760.00,3800.00,0.00,'2022-06-23 18:08:56'),(2041,'21','227',1,'Retail Sale Id 2452',0.00,1998.80,760.00,1998.80,0.00,'2022-06-23 18:09:25'),(2042,'21','227',1,'Retail Sale Id 2453',0.00,1998.80,760.00,1998.80,0.00,'2022-06-23 18:10:32'),(2043,'21','227',1,'Retail Sale Id 2453',0.00,2280.00,760.00,2280.00,0.00,'2022-06-23 18:10:32'),(2044,'21','227',1,'Retail Sale Id 2453',0.00,3800.00,760.00,3800.00,0.00,'2022-06-23 18:10:32'),(2045,'21','227',1,'Retail Sale Id 2454',0.00,1497.