-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_226
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_226`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_226` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_226`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','21','226','PURCHASES','','2022-03-03 16:22:36',5,0.00,0.00,'','764','2022-03-03 16:22:36','764',0,0),(2,8000,'',0,'24','21','226','PURCHASES','','2022-03-03 16:23:00',5,0.00,0.00,'','764','2022-03-03 16:23:00','764',0,0),(3,500,'',0,'6.1','21','226','CASH','','2022-03-03 16:23:17',5,0.00,0.00,'','764','2022-03-03 16:23:17','764',0,0),(4,7000,'',0,'20','21','226','SALES','','2022-03-03 16:23:34',5,0.00,0.00,'','764','2022-03-03 16:23:34','764',0,0),(5,8001,'',0,'24','21','226','SALARY & WAGES','','2022-03-03 16:24:00',5,0.00,0.00,'','764','2022-03-03 16:24:00','764',0,0),(6,2500,'',0,'2','21','226','GT Bank POS','','2022-03-07 10:35:13',5,0.00,0.00,'','764','2022-03-07 10:35:13','764',0,0),(7,2501,'',0,'2','21','226','First Bank POS','','2022-03-07 10:35:33',5,0.00,0.00,'','764','2022-03-07 10:35:33','764',0,0),(8,2502,'',0,'2','21','226','FiDELITY Bank POS','','2022-03-07 10:36:15',5,0.00,0.00,'','764','2022-03-07 10:36:15','764',0,0),(9,2503,'',0,'2','21','226','UBA BANK','','2022-03-07 10:49:52',5,0.00,0.00,'','764','2022-03-07 10:49:52','764',0,0),(10,2504,'',0,'2','21','226','zenith Bank pos','','2022-03-07 10:50:53',5,0.00,0.00,'','764','2022-03-07 10:50:53','764',0,0),(11,2505,'',0,'2','21','226','STANBIIC BANK POS','','2022-03-07 10:51:04',5,0.00,0.00,'','764','2022-03-07 10:51:04','764',0,0),(12,2506,'',0,'2','21','226','UBA TRANSFER ACC','','2022-03-07 10:51:28',5,0.00,0.00,'','764','2022-03-07 10:51:28','764',0,0),(13,2507,'',0,'2','21','226','Ecobank POS','','2022-03-26 17:47:03',5,0.00,0.00,'','764','2022-03-26 17:47:03','764',0,0),(14,2508,'',0,'2','21','226','Ecobank ','','2022-03-26 17:47:11',5,0.00,0.00,'','764','2022-03-26 17:47:11','764',0,0),(15,2509,'',0,'2','21','226','Ecobank Transfer account ','','2022-03-26 17:47:18',5,0.00,0.00,'','764','2022-03-26 17:47:18','764',0,0),(16,2510,'',0,'2','21','226','Unity Bank','','2022-03-26 17:47:26',5,0.00,0.00,'','764','2022-03-26 17:47:26','764',0,0),(17,2511,'',0,'2','21','226','Unity Bank POS','','2022-03-26 17:47:36',5,0.00,0.00,'','764','2022-03-26 17:47:36','764',0,0),(18,2512,'',0,'2','21','226','UNITY Bank Transfer account ','','2022-03-26 17:47:47',5,0.00,0.00,'','764','2022-03-26 17:47:47','764',0,0),(19,2513,'',0,'2','21','226','SunTrust Pos','','2022-04-04 11:52:53',5,0.00,0.00,'','764','2022-04-04 11:52:53','764',0,0),(20,2514,'',0,'2','21','226','Polaris Bank - surplus Acct','','2022-04-12 17:34:04',5,0.00,0.00,'','764','2022-04-12 17:34:04','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
INSERT INTO `attendants` VALUES ('21','226',1,'ABUBAKAR','MUAZU','TUKUR','08166611598','','NSUK STAFF QTRS','KEFFI','NASARAWA','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-08-04 14:17:37','769','2022-08-04 14:17:37','769'),('21','226',2,'MANASSEH','GYARA','DAUDA','09065700653','','ANGWAN TANKO EXTENSION','KEFFI','NASARAWA','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-08-04 14:18:27','769','2022-08-04 14:18:27','769');
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','21','226','DRIVER SHORTAGE','DRIVER','08011111111','info@ayamshafaltd.com','BAUCHI','BAUCHI','B38 Jos Road/ Jolly Nyame Crescent Bauchi Bauchi','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-07 10:39:39',5,'764','2022-03-07 10:39:39','764'),(2,'','21','226','AHF NIGERIA ','ANTHONY ','08166611598','anthony@gmail.com','ABUJA','ABJUA','ABUJA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-14 15:43:59',5,'764','2022-05-14 15:43:59','764');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','226',1,'1',7500.00,7508.00,'2022-03-22','','2022-03-22 09:18:17','769','769',2022,'769','2022-03-22 09:18:17',5),('21','226',2,'1',7508.00,7510.00,'2022-03-22','','2022-03-22 09:25:04','769','769',2022,'769','2022-03-22 09:25:04',5),('21','226',3,'1',14935.29,16185.00,'2022-03-21','','2022-03-23 13:38:22','764','764',2022,'764','2022-03-23 13:38:22',5),('21','226',4,'2',-13603.52,800.00,'2022-03-21','','2022-03-23 13:38:44','764','764',2022,'764','2022-03-23 13:38:44',5),('21','226',5,'3',19598.69,20399.00,'2022-03-21','','2022-03-23 13:39:15','764','764',2022,'764','2022-03-23 13:39:15',5),('21','226',6,'4',6156.99,6557.00,'2022-03-21','','2022-03-23 13:39:52','764','764',2022,'764','2022-03-23 13:39:52',5),('21','226',7,'1',1215.55,16200.00,'2022-03-23','','2022-04-04 09:08:53','764','764',2022,'764','2022-04-04 09:08:53',5),('21','226',8,'2',14372.42,15800.00,'2022-03-23','','2022-04-04 09:09:52','764','764',2022,'764','2022-04-04 09:09:52',5),('21','226',9,'3',16174.50,16400.00,'2022-03-23','','2022-04-04 09:11:24','764','764',2022,'764','2022-04-04 09:11:24',5),('21','226',10,'4',5501.05,5650.00,'2022-03-23','','2022-04-04 09:12:22','764','764',2022,'764','2022-04-04 09:12:22',5),('21','226',11,'1',16898.91,17700.00,'2022-04-02','','2022-04-04 17:22:01','764','764',2022,'764','2022-04-04 17:22:01',5),('21','226',12,'4',506.05,1200.00,'2022-03-20','','2022-04-05 11:23:12','764','764',2022,'764','2022-04-05 11:23:12',5),('21','226',13,'3',1476.46,1523.00,'2022-04-15','','2022-04-15 11:54:59','764','764',2022,'764','2022-04-15 11:54:59',5),('21','226',14,'2',1240.76,3350.00,'2022-04-26','','2022-04-26 10:03:42','764','764',2022,'764','2022-04-26 10:03:42',5),('21','226',15,'3',4433.12,5550.00,'2022-04-28','','2022-04-29 18:45:11','764','764',2022,'764','2022-04-29 18:45:11',5),('21','226',16,'2',14882.57,15140.00,'2022-07-18','','2022-07-20 18:08:45','764','764',2022,'764','2022-07-20 18:08:45',5),('21','226',17,'1',-4301.65,2.00,'2022-07-24','','2022-07-24 14:00:03','764','764',2022,'764','2022-07-24 14:00:03',5),('21','226',18,'1',29948.58,31000.00,'2022-07-26','','2022-07-26 16:12:27','764','764',2022,'764','2022-07-26 16:12:27',5),('21','226',19,'2',29441.83,29600.00,'2022-07-27','','2022-07-27 12:08:18','764','764',2022,'764','2022-07-27 12:08:18',5),('21','226',20,'1',23623.40,23880.00,'2022-08-07','','2022-08-07 17:42:51','764','764',2022,'764','2022-08-07 17:42:51',5),('21','226',21,'2',2069.43,2070.00,'2022-08-07','','2022-08-07 17:44:17','764','764',2022,'764','2022-08-07 17:44:17',5),('21','226',22,'1',17910.72,19000.00,'2022-08-16','','2022-08-16 14:55:33','764','764',2022,'764','2022-08-16 14:55:33',5),('21','226',23,'2',1348.92,2050.00,'2022-08-16','','2022-08-16 14:57:39','764','764',2022,'764','2022-08-16 14:57:39',5),('21','226',24,'2',15142.13,16200.00,'2022-09-06','','2022-09-06 09:20:58','764','764',2022,'764','2022-09-06 09:20:58',5),('21','226',25,'1',22816.08,24000.00,'2022-09-06','','2022-09-06 09:22:23','764','764',2022,'764','2022-09-06 09:22:23',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','226','1',1,'5','PMS NOZZLE 1A',1472762.07,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:13:28','769'),('21','226','1',2,'5','PMS NOZZLE 1B',1238654.00,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:14:14','769'),('21','226','1',3,'5','PMS NOZZLE 2A',1906969.98,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-04 09:15:33','764'),('21','226','1',4,'5','PMS NOZZLE 2B',1378884.00,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:16:07','769'),('21','226','1',5,'5','PMS NOZZLE 3A',1157442.63,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:17:17','769'),('21','226','1',6,'5','PMS NOZZLE 3B',1229212.76,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:18:32','769'),('21','226','1',7,'5','PMS NOZZLE 4A',1300408.20,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:19:47','769'),('21','226','1',8,'5','PMS NOZZLE 4B',1233646.36,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:20:58','769'),('21','226','2',17,'5','PMS NOZZLE 5AA',930531.08,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:22:07','769'),('21','226','2',18,'5','PMS NOZZLE 5BB',981846.89,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:23:06','769'),('21','226','2',19,'5','PMS NOZZLE 6AA',1017380.96,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:24:53','769'),('21','226','2',20,'5','PMS NOZZLE 6BB',1169513.30,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:25:50','769'),('21','226','2',21,'5','PMS NOZZLE 7AA',842191.46,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:26:44','769'),('21','226','2',22,'5','PMS NOZZLE 7BB',1092919.64,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:27:31','769'),('21','226','2',23,'5','PMS NOZZLE 8AA',1021659.48,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:28:52','769'),('21','226','2',24,'5','PMS NOZZLE 8BB',1079741.44,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:29:47','769'),('21','226','3',25,'5','AGO NOZZLE 1A',913832.24,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:30:39','769'),('21','226','3',26,'5','AGO NOZZLE 1B',608980.83,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:31:23','769'),('21','226','3',27,'5','AGO NOZZLE 2A',675396.15,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:32:09','769'),('21','226','3',28,'5','AGO NOZZLE 2B',405759.82,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:32:53','769'),('21','226','4',29,'5','DPK NOZZLE 1A',275386.25,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:33:38','769'),('21','226','4',30,'5','DPK NOZZLE 1B',91278.01,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-22 08:34:46','769');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','226',6,'DAILY ','2022-03-22','2022-03-22 08:39:09','2022-03-23 08:39:09','769',4083943.40,4083943.40,'769','2022-03-22 09:29:45','769','2022-03-22 10:50:31',10,0),('21','226',7,'DAILY','2022-03-23','2022-03-23 09:24:10','2022-03-24 09:24:10','769',6350039.25,6350039.25,'769','2022-03-23 09:33:02','769','2022-03-23 09:34:33',10,0),('21','226',8,'DAILY','2022-03-24','2022-03-24 08:12:03','2022-03-25 08:12:03','769',8718433.55,8718433.55,'769','2022-03-24 08:22:57','769','2022-03-24 09:00:47',10,0),('21','226',9,'DAILY','2022-04-04','2022-04-04 09:18:27','2022-04-05 09:18:27','769',7113697.30,7113697.30,'769','2022-04-04 09:53:26','769','2022-04-04 10:22:22',10,0),('21','226',10,'DAILY','2022-03-25','2022-04-04 10:41:08','2022-04-05 10:41:08','769',8023349.40,8023349.40,'769','2022-04-04 10:47:32','769','2022-04-04 11:08:35',10,0),('21','226',11,'DAILY','2022-03-26','2022-04-04 11:23:54','2022-04-05 11:23:54','769',4604493.60,4604493.60,'769','2022-04-04 11:33:25','769','2022-04-04 12:03:33',10,0),('21','226',12,'DAILY','2022-03-27','2022-04-04 12:06:36','2022-04-05 12:06:36','769',4033507.95,4033507.95,'769','2022-04-04 12:17:54','769','2022-04-04 12:39:15',10,0),('21','226',13,'DAILY','2022-03-28','2022-04-04 12:47:21','2022-04-05 12:47:21','769',7325357.30,7325357.30,'769','2022-04-04 12:55:32','769','2022-04-04 13:58:29',10,0),('21','226',14,'DAILY','2022-03-29','2022-04-04 14:07:18','2022-04-05 14:07:18','769',6734824.75,6734824.75,'769','2022-04-04 14:15:23','769','2022-04-04 15:04:10',10,0),('21','226',15,'DAILY','2022-03-30','2022-04-04 15:10:58','2022-04-05 15:10:58','769',5098807.35,5098807.35,'769','2022-04-04 15:25:51','769','2022-04-04 15:42:27',10,0),('21','226',16,'DAILY','2022-03-31','2022-04-04 15:44:04','2022-04-05 15:44:04','769',4128349.25,4128349.25,'769','2022-04-04 16:25:46','769','2022-04-04 16:42:18',10,0),('21','226',17,'DAILY','2022-04-01','2022-04-04 16:44:03','2022-04-05 16:44:03','769',361788.90,361788.90,'769','2022-04-04 16:45:32','769','2022-04-04 16:56:17',10,0),('21','226',18,'DAILY','2022-04-02','2022-04-04 16:56:39','2022-04-05 16:56:39','769',5431406.20,5431406.20,'769','2022-04-04 17:00:21','769','2022-04-04 17:10:13',10,0),('21','226',19,'DAILY','2022-04-03','2022-04-04 17:14:45','2022-04-05 17:14:45','769',4935352.95,4935352.95,'769','2022-04-04 17:23:34','769','2022-04-04 17:34:08',10,0),('21','226',20,'DAILY','2022-04-04','2022-04-05 10:10:47','2022-04-06 10:10:47','769',6870614.30,6870614.30,'769','2022-04-05 11:41:03','769','2022-04-06 09:33:57',10,0),('21','226',21,'DAILY','2022-04-05','2022-04-06 09:35:08','2022-04-07 09:35:08','769',5160462.45,5160462.45,'769','2022-04-06 09:47:59','769','2022-04-06 15:31:14',10,0),('21','226',22,'DAILY','2022-04-06','2022-04-07 07:33:44','2022-04-08 07:33:44','769',6459657.27,6459657.27,'769','2022-04-07 07:47:03','769','2022-04-07 07:48:22',10,0),('21','226',23,'DAILY','2022-04-07','2022-04-08 11:49:31','2022-04-09 11:49:31','769',10584008.80,10584008.80,'769','2022-04-08 12:00:26','769','2022-04-09 10:47:59',10,0),('21','226',24,'DAILY','2022-04-08','2022-04-09 10:50:57','2022-04-10 10:50:57','769',10052293.75,10052293.75,'769','2022-04-10 09:35:01','769','2022-04-10 09:35:52',10,0),('21','226',25,'DAILY','2022-04-08','2022-04-10 09:50:07','2022-04-11 09:50:07','769',9403325.00,9403325.00,'769','2022-04-10 11:36:38','769','2022-04-11 10:55:34',10,0),('21','226',26,'DAILY','2022-04-10','2022-04-11 11:10:17','2022-04-12 11:10:17','769',6888560.90,6888560.90,'769','2022-04-11 11:17:00','769','2022-04-12 16:16:51',10,0),('21','226',27,'DAILY','2022-04-11','2022-04-12 17:07:39','2022-04-13 17:07:39','769',6007452.05,6007452.05,'769','2022-04-12 17:12:39','769','2022-04-12 17:13:14',10,0),('21','226',28,'DAILY','2022-04-12','2022-04-13 10:51:55','2022-04-14 10:51:55','769',1751356.10,1751356.10,'769','2022-04-13 10:55:24','769','2022-04-13 10:56:28',10,0),('21','226',29,'DAILY','2022-04-13','2022-04-14 09:13:32','2022-04-15 09:13:32','769',8247096.85,8247096.85,'769','2022-04-14 09:18:54','769','2022-04-15 10:50:54',10,0),('21','226',30,'DAILY','2022-04-14','2022-04-15 10:51:31','2022-04-16 10:51:31','769',6596221.05,6596221.05,'769','2022-04-15 12:02:03','769','2022-04-15 12:03:26',10,0),('21','226',31,'DAILY','2022-04-15','2022-04-16 11:03:49','2022-04-17 11:03:49','769',5394969.80,5394969.80,'769','2022-04-16 11:10:52','764','2022-04-16 18:00:53',10,0),('21','226',32,'DAILY','2022-04-16','2022-04-17 14:38:43','2022-04-18 14:38:43','769',6771673.70,6771673.70,'769','2022-04-17 14:41:54','764','2022-04-18 10:16:29',10,0),('21','226',33,'DAILY','2022-04-17','2022-04-18 10:24:00','2022-04-19 10:24:00','769',6360447.75,6360447.75,'769','2022-04-18 10:44:03','764','2022-04-18 21:20:04',10,0),('21','226',34,'DAILY','2022-04-18','2022-04-19 11:39:05','2022-04-20 11:39:05','769',8602146.55,8602146.55,'769','2022-04-19 12:49:15','764','2022-04-19 20:47:34',10,0),('21','226',35,'DAILY','2022-04-19','2022-04-20 11:21:25','2022-04-21 11:21:25','769',9872937.60,9872937.60,'769','2022-04-20 11:32:33','764','2022-04-20 23:12:07',10,0),('21','226',36,'DAILY','2022-04-20','2022-04-21 12:00:02','2022-04-22 12:00:02','769',10204889.20,10204889.20,'769','2022-04-22 09:41:02','764','2022-04-22 09:52:58',10,0),('21','226',37,'DAILY','2022-04-21','2022-04-22 10:02:26','2022-04-23 10:02:26','769',933345.00,933345.00,'769','2022-04-22 10:10:14','764','2022-04-22 10:12:21',10,0),('21','226',38,'DAILY','2022-04-21','2022-04-22 10:15:35','2022-04-23 10:15:35','769',8817262.35,8817262.35,'769','2022-04-22 10:21:22','764','2022-04-22 10:24:03',10,0),('21','226',39,'DAILY','2022-04-22','2022-04-23 13:34:16','2022-04-24 13:34:16','769',10198456.30,10198456.30,'769','2022-04-23 13:47:01','764','2022-04-23 18:39:24',10,0),('21','226',40,'DAILY','2022-04-23','2022-04-24 16:48:22','2022-04-25 16:48:22','769',7733960.40,7733960.40,'769','2022-04-24 16:53:06','764','2022-04-24 20:03:55',10,0),('21','226',41,'DAILY','2022-04-24','2022-04-25 10:09:18','2022-04-26 10:09:18','769',9466688.15,9466688.15,'769','2022-04-25 12:02:25','764','2022-04-26 09:56:11',10,0),('21','226',42,'DAILY','2022-04-25','2022-04-26 10:11:54','2022-04-27 10:11:54','769',3818818.75,3818818.75,'769','2022-04-26 10:26:50','764','2022-04-27 09:52:02',10,0),('21','226',43,'DAILY','2022-04-26','2022-04-27 10:27:27','2022-04-28 10:27:27','769',10903497.55,10903497.55,'769','2022-04-27 11:03:26','764','2022-04-28 14:42:55',10,0),('21','226',44,'DAILY','2022-04-27','2022-04-28 14:53:13','2022-04-29 14:53:13','769',10799837.45,10799837.45,'769','2022-04-28 14:59:44','764','2022-04-28 21:50:07',10,0),('21','226',45,'DAILY','2022-04-28','2022-04-29 18:27:58','2022-04-30 18:27:58','769',15288449.55,15288449.55,'769','2022-04-29 18:46:22','764','2022-04-29 19:34:37',10,0),('21','226',46,'DAILY','2022-04-29','2022-04-30 16:39:07','2022-05-01 16:39:07','769',7421881.50,7421881.50,'769','2022-04-30 16:43:41','764','2022-04-30 19:41:01',10,0),('21','226',47,'DAILY','2022-04-30','2022-05-01 13:24:31','2022-05-02 13:24:31','769',7163559.40,7163559.40,'769','2022-05-01 13:34:03','764','2022-05-02 18:01:48',10,0),('21','226',48,'DAILY','2022-05-01','2022-05-04 06:57:02','2022-05-05 06:57:02','769',5190763.05,5190763.05,'769','2022-05-04 07:00:43','764','2022-05-04 11:21:10',10,0),('21','226',49,'DAILY','2022-05-02','2022-05-04 11:24:24','2022-05-05 11:24:24','769',3103651.65,3103651.65,'769','2022-05-04 11:27:37','764','2022-05-04 11:47:53',10,0),('21','226',50,'DAILY','2022-05-03','2022-05-04 12:43:43','2022-05-05 12:43:43','769',2255073.70,2255073.70,'769','2022-05-04 12:46:40','764','2022-05-05 17:22:13',10,0),('21','226',51,'DAILY','2022-05-04','2022-05-05 18:10:28','2022-05-06 18:10:28','769',6864257.90,6864257.90,'769','2022-05-05 18:14:01','764','2022-05-05 19:05:22',10,0),('21','226',52,'DAILY','2022-05-05','2022-05-07 11:57:43','2022-05-08 11:57:43','769',9066569.05,9066569.05,'769','2022-05-07 12:00:39','764','2022-05-07 13:45:22',10,0),('21','226',53,'DAILY','2022-05-06','2022-05-07 15:18:39','2022-05-08 15:18:39','769',9167752.55,9167752.55,'769','2022-05-08 13:57:16','764','2022-05-08 20:07:20',10,0),('21','226',54,'DAILY','2022-05-07','2022-05-09 16:17:27','2022-05-10 16:17:27','769',9786289.70,9786289.70,'769','2022-05-09 16:32:26','764','2022-05-09 16:49:02',10,0),('21','226',55,'DAILY','2022-05-07','2022-05-09 16:51:03','2022-05-10 16:51:03','769',109714.80,109714.80,'769','2022-05-09 16:53:41','764','2022-05-09 17:09:14',10,0),('21','226',56,'DAILY','2022-05-08','2022-05-09 17:25:58','2022-05-10 17:25:58','769',4807869.30,4807869.30,'769','2022-05-10 18:22:15','764','2022-05-11 13:39:42',10,0),('21','226',57,'DAILY','2022-05-09','2022-05-12 09:37:10','2022-05-13 09:37:10','769',5847027.65,5847027.65,'769','2022-05-12 09:39:29','764','2022-05-12 11:09:57',10,0),('21','226',58,'DAILY','2022-05-10','2022-05-12 11:31:29','2022-05-13 11:31:29','769',7021934.55,7021934.55,'769','2022-05-12 11:35:00','764','2022-05-12 14:12:25',10,0),('21','226',59,'DAILY','2022-05-11','2022-05-14 09:21:01','2022-05-15 09:21:01','769',5535992.35,5535992.35,'769','2022-05-14 09:23:07','764','2022-05-14 09:46:45',10,0),('21','226',60,'DAILY','2022-05-12','2022-05-14 09:49:27','2022-05-15 09:49:27','769',4373106.50,4373106.50,'769','2022-05-14 09:56:02','764','2022-05-14 15:09:04',10,0),('21','226',61,'DAILY','2022-05-13','2022-05-14 15:40:33','2022-05-15 15:40:33','764',7437435.65,7437435.65,'764','2022-05-14 15:58:52','764','2022-05-15 16:08:15',10,0),('21','226',62,'DAILY','2022-05-15','2022-05-15 16:09:26','2022-05-16 16:09:26','764',0.00,0.00,'764','2022-05-15 16:10:19','764','2022-05-15 16:10:32',10,0),('21','226',63,'DAILY','2022-05-14','2022-05-15 16:10:54','2022-05-16 16:10:54','764',5877455.70,5877455.70,'764','2022-05-15 16:22:45','764','2022-05-15 16:29:03',10,0),('21','226',64,'DAILY','2022-05-14','2022-05-15 16:29:26','2022-05-16 16:29:26','764',0.00,0.00,'764','2022-05-15 16:31:15','764','2022-05-15 16:31:27',10,0),('21','226',65,'DAILY','2022-05-14','2022-05-15 16:33:50','2022-05-16 16:33:50','764',1738886.40,1738886.40,'764','2022-05-15 16:35:43','764','2022-05-15 16:36:54',10,0),('21','226',66,'DAILY','2022-05-15','2022-05-16 12:55:54','2022-05-17 12:55:54','769',8666224.80,8666224.80,'769','2022-05-18 08:50:25','764','2022-05-18 09:09:44',10,0),('21','226',67,'DAILY','2022-05-16','2022-05-18 09:12:10','2022-05-19 09:12:10','769',6142667.75,6142667.75,'769','2022-05-18 09:15:05','764','2022-05-18 09:22:56',10,0),('21','226',68,'DAILY','2022-05-17','2022-05-18 09:37:33','2022-05-19 09:37:33','769',10753031.45,10753031.45,'769','2022-05-18 09:50:50','764','2022-05-18 10:30:42',10,0),('21','226',69,'DAILY','2022-05-18','2022-05-19 10:57:54','2022-05-20 10:57:54','769',10861231.60,10861231.60,'769','2022-05-19 12:40:40','764','2022-05-19 18:12:00',10,0),('21','226',70,'DAILY','2022-05-19','2022-05-20 18:01:47','2022-05-21 18:01:47','769',10525558.05,10525558.05,'769','2022-05-20 18:06:47','764','2022-05-21 11:46:02',10,0),('21','226',71,'DAILY','2022-05-20','2022-05-21 11:56:11','2022-05-22 11:56:11','769',4416420.45,4416420.45,'769','2022-05-21 11:58:24','764','2022-05-21 14:34:49',10,0),('21','226',72,'DAILY','2022-05-21','2022-05-23 14:20:58','2022-05-24 14:20:58','769',9152869.65,9152869.65,'769','2022-05-23 14:23:32','764','2022-05-23 14:35:08',10,0),('21','226',73,'DAILY','2022-05-22','2022-05-23 14:38:05','2022-05-24 14:38:05','769',2474192.20,2474192.20,'769','2022-05-23 14:43:30','764','2022-05-23 15:02:21',10,0),('21','226',74,'DAILY','2022-05-22','2022-05-23 15:04:08','2022-05-24 15:04:08','769',1436453.20,1436453.20,'769','2022-05-23 15:04:50','764','2022-05-25 08:35:48',10,0),('21','226',75,'DAILY','2022-05-23','2022-05-25 08:39:18','2022-05-26 08:39:18','769',5756686.18,5756686.18,'769','2022-05-25 08:42:36','764','2022-05-25 09:25:47',10,0),('21','226',76,'DAILY','2022-05-24','2022-05-26 09:33:09','2022-05-27 09:33:09','769',8883726.75,8883726.75,'769','2022-05-26 09:35:23','764','2022-05-26 09:45:35',10,0),('21','226',77,'DAILY','2022-05-25','2022-05-26 09:49:18','2022-05-27 09:49:18','769',2817654.40,2817654.40,'769','2022-05-26 09:50:31','764','2022-05-26 10:07:23',10,0),('21','226',78,'DAILY','2022-05-26','2022-05-28 12:52:44','2022-05-29 12:52:44','769',12980181.45,12980181.45,'769','2022-05-28 12:55:30','764','2022-05-28 13:05:30',10,0),('21','226',79,'DAILY','2022-05-27','2022-05-28 13:24:36','2022-05-29 13:24:36','769',7020510.40,7020510.40,'769','2022-05-28 13:26:27','764','2022-05-28 13:47:03',10,0),('21','226',80,'DAILY','2022-05-28','2022-05-31 07:49:21','2022-06-03 07:49:21','769',7643815.35,7643815.35,'769','2022-05-31 17:57:05','764','2022-05-31 18:04:20',10,0),('21','226',81,'DAILY','2022-05-29','2022-06-01 17:43:33','2022-06-02 17:43:33','769',2982437.60,2982437.60,'769','2022-06-01 17:45:18','764','2022-06-01 18:02:25',10,0),('21','226',82,'DAILY','2022-05-30','2022-06-01 18:03:48','2022-06-02 18:03:48','769',9642438.30,9642438.30,'769','2022-06-01 18:09:04','764','2022-06-01 18:20:05',10,0),('21','226',83,'DAILY','2022-05-31','2022-06-03 12:36:29','2022-06-04 12:36:29','769',8079975.65,8079975.65,'769','2022-06-03 15:35:05','764','2022-06-03 17:10:09',10,0),('21','226',84,'DAILY','2022-06-01','2022-06-03 18:26:38','2022-06-04 18:26:38','769',6090864.05,6090864.05,'769','2022-06-03 18:28:37','764','2022-06-03 18:37:25',10,0),('21','226',85,'DAILY','2022-06-02','2022-06-03 18:40:24','2022-06-04 18:40:24','769',4175569.55,4175569.55,'769','2022-06-03 18:42:29','764','2022-06-03 18:51:26',10,0),('21','226',86,'DAILY','2022-06-03','2022-06-05 16:56:45','2022-06-06 16:56:45','769',8546080.00,8546080.00,'769','2022-06-05 16:58:42','764','2022-06-05 17:09:23',10,0),('21','226',87,'DAILY','2022-06-04','2022-06-05 17:11:51','2022-06-06 17:11:51','769',667135.60,667135.60,'769','2022-06-05 17:12:34','764','2022-06-05 17:16:31',10,0),('21','226',88,'DAILY','2022-06-04','2022-06-05 17:21:50','2022-06-06 17:21:50','769',9643425.55,9643425.55,'769','2022-06-05 17:24:17','764','2022-06-05 17:36:50',10,0),('21','226',89,'DAILY','2022-06-05','2022-06-05 17:37:50','2022-06-06 17:37:50','769',842087.40,842087.40,'769','2022-06-05 17:38:30','764','2022-06-06 18:38:18',10,0),('21','226',90,'DAILY','2022-06-05','2022-06-06 18:39:35','2022-06-07 18:39:35','769',7964521.95,7964521.95,'769','2022-06-06 18:42:07','764','2022-06-06 18:53:51',10,0),('21','226',91,'DAILY','2022-06-06','2022-06-08 08:40:14','2022-06-09 08:40:14','769',8324362.20,8324362.20,'769','2022-06-08 08:46:41','764','2022-06-08 12:35:47',10,0),('21','226',92,'DAILY','2022-06-07','2022-06-09 11:00:18','2022-06-10 11:00:18','769',6399317.55,6399317.55,'769','2022-06-09 11:02:49','764','2022-06-09 11:22:21',10,0),('21','226',93,'DAILY','2022-06-10','2022-06-12 13:52:13','2022-06-13 13:52:13','769',6927118.05,6927118.05,'769','2022-06-12 14:20:20','764','2022-06-12 15:07:35',10,0),('21','226',94,'DAILY','2022-06-08','2022-06-12 15:10:56','2022-06-13 15:10:56','769',1271960.00,1271960.00,'769','2022-06-12 15:12:59','764','2022-06-12 15:15:47',10,0),('21','226',95,'DAILY','2022-06-09','2022-06-12 15:19:51','2022-06-13 15:19:51','769',8097449.25,8097449.25,'769','2022-06-12 15:52:51','764','2022-06-12 17:09:15',10,0),('21','226',96,'DAILY','2022-06-10','2022-06-12 17:12:28','2022-06-13 17:12:28','769',6683219.50,6683219.50,'769','2022-06-12 17:19:01','764','2022-06-12 19:11:52',10,0),('21','226',97,'DAILY','2022-06-11','2022-06-16 11:34:51','2022-06-17 11:34:51','769',2519760.00,2519760.00,'769','2022-06-16 11:35:41','764','2022-06-16 11:38:27',10,0),('21','226',98,'DAILY','2022-06-11','2022-06-16 11:45:21','2022-06-17 11:45:21','769',6243162.75,6243162.75,'769','2022-06-16 11:49:28','769','2022-06-16 12:04:43',10,0),('21','226',99,'DAILY','2022-06-12','2022-06-16 12:11:50','2022-06-17 12:11:50','769',8611856.00,8611856.00,'769','2022-06-16 12:19:01','769','2022-06-16 12:37:32',10,0),('21','226',100,'DAILY','2022-06-14','2022-06-16 14:00:39','2022-06-17 14:00:39','769',8821378.70,8821378.70,'769','2022-06-16 14:02:41','764','2022-06-16 14:14:03',10,0),('21','226',101,'DAILY','2022-06-15','2022-06-16 14:15:30','2022-06-17 14:15:30','769',3462138.40,3462138.40,'769','2022-06-16 14:16:16','764','2022-06-16 14:22:25',10,0),('21','226',102,'DAILY','2022-06-16','2022-06-21 11:22:49','2022-06-22 11:22:49','769',3100903.80,3100903.80,'769','2022-06-21 11:23:28','764','2022-06-21 11:30:12',10,0),('21','226',103,'DAILY','2022-06-16','2022-06-21 11:31:31','2022-06-22 11:31:31','769',7076554.25,7076554.25,'769','2022-06-21 11:32:44','764','2022-06-21 11:48:27',10,0),('21','226',104,'DAILY','2022-06-17','2022-06-21 11:50:39','2022-06-22 11:50:39','769',8415385.25,8415385.25,'769','2022-06-21 11:56:25','764','2022-06-21 12:02:01',10,0),('21','226',105,'DAILY','2022-06-18','2022-06-21 12:02:45','2022-06-22 12:02:45','769',6883781.85,6883781.85,'769','2022-06-21 12:04:20','764','2022-06-21 12:10:42',10,0),('21','226',106,'DAILY','2022-06-19','2022-06-21 12:11:52','2022-06-22 12:11:52','769',2317501.10,2317501.10,'769','2022-06-21 12:12:31','764','2022-06-21 12:16:40',10,0),('21','226',107,'DAILY','2022-06-20','2022-06-21 12:17:37','2022-06-22 12:17:37','769',1026046.00,1026046.00,'769','2022-06-21 12:18:53','764','2022-06-27 10:21:39',10,0),('21','226',108,'DAILY','2022-06-21','2022-06-27 10:23:37','2022-06-28 10:23:37','769',5239298.90,5239298.90,'769','2022-06-27 10:43:59','764','2022-06-27 11:07:58',10,0),('21','226',109,'DAILY','2022-06-22','2022-06-27 11:15:21','2022-06-28 11:15:21','769',3386596.20,3386596.20,'769','2022-06-27 11:17:45','764','2022-06-27 11:25:52',10,0),('21','226',110,'DAILY','2022-06-23','2022-06-27 11:28:50','2022-06-28 11:28:50','764',5568519.55,5568519.55,'769','2022-06-27 11:42:58','764','2022-06-27 11:49:35',10,0),('21','226',111,'DAILY','2022-06-27','2022-06-27 11:57:50','2022-06-28 11:57:50','769',0.00,0.00,'769','2022-06-27 11:59:07','764','2022-06-27 12:00:13',10,0),('21','226',112,'DAILY','2022-06-24','2022-06-27 12:01:08','2022-06-28 12:01:08','769',4885251.70,4885251.70,'769','2022-06-27 12:48:42','764','2022-07-01 11:59:39',10,0),('21','226',113,'DAILY','2022-06-25','2022-07-01 12:10:12','2022-07-02 12:10:12','764',10090850.95,10090850.95,'764','2022-07-01 12:24:26','764','2022-07-01 15:07:39',10,0),('21','226',114,'DAILY','2022-06-26','2022-07-01 15:09:31','2022-07-02 15:09:31','764',6814217.85,6814217.85,'764','2022-07-01 15:22:53','764','2022-07-01 15:44:33',10,0),('21','226',115,'DAILY','2022-06-27','2022-07-01 15:51:58','2022-07-02 15:51:58','769',6312958.15,6312958.15,'769','2022-07-01 15:54:21','764','2022-07-01 16:05:27',10,0),('21','226',116,'DAILY','2022-06-28','2022-07-01 16:05:48','2022-07-02 16:05:48','769',7602484.25,7602484.25,'769','2022-07-01 16:07:06','764','2022-07-01 16:18:34',10,0),('21','226',117,'DAILY','2022-06-29','2022-07-01 16:19:44','2022-07-02 16:19:44','769',3525923.00,3525923.00,'769','2022-07-01 16:20:20','764','2022-07-01 16:24:28',10,0),('21','226',118,'DAILY','2022-06-30','2022-07-02 16:14:55','2022-07-03 16:14:55','769',4839726.15,4839726.15,'769','2022-07-02 16:20:27','764','2022-07-02 16:32:27',10,0),('21','226',119,'DAILY','2022-07-01','2022-07-02 16:35:31','2022-07-03 16:35:31','769',2012937.00,2012937.00,'769','2022-07-02 16:42:11','769','2022-07-08 13:09:46',10,0),('21','226',120,'DAILY','2022-07-02','2022-07-08 13:20:00','2022-07-09 13:20:00','769',4559741.20,4559741.20,'769','2022-07-08 13:23:37','764','2022-07-13 14:52:21',10,0),('21','226',121,'DAILY','2022-07-03','2022-07-13 14:54:35','2022-07-14 14:54:35','769',3095651.00,3095651.00,'769','2022-07-13 14:55:33','764','2022-07-13 15:03:20',10,0),('21','226',122,'DAILY','2022-07-04','2022-07-13 15:04:17','2022-07-14 15:04:17','769',1613744.35,1613744.35,'769','2022-07-13 15:05:27','764','2022-07-13 15:35:31',10,0),('21','226',123,'DAILY','2022-07-05','2022-07-13 15:37:41','2022-07-14 15:37:41','769',2583648.90,2583648.90,'769','2022-07-13 15:38:18','764','2022-07-13 15:49:34',10,0),('21','226',124,'DAILY','2022-07-06','2022-07-13 15:50:57','2022-07-14 15:50:57','769',4288256.15,4288256.15,'769','2022-07-13 16:06:21','764','2022-07-13 16:07:17',10,0),('21','226',125,'DAILY','2022-07-07','2022-07-13 16:37:00','2022-07-14 16:37:00','769',6667412.10,6667412.10,'769','2022-07-13 16:38:40','764','2022-07-13 16:44:01',10,0),('21','226',126,'DAILY','2022-07-08','2022-07-13 16:47:42','2022-07-14 16:47:42','769',3248452.10,3248452.10,'769','2022-07-13 16:55:37','764','2022-07-13 17:21:39',10,0),('21','226',127,'DAILY','2022-07-09','2022-07-14 08:36:31','2022-07-15 08:36:31','769',1177155.80,1177155.80,'769','2022-07-14 08:40:10','764','2022-07-14 09:03:55',10,0),('21','226',128,'DAILY','2022-07-10','2022-07-14 09:11:56','2022-07-15 09:11:56','769',7134666.55,7134666.55,'769','2022-07-14 09:14:21','764','2022-07-14 09:35:08',10,0),('21','226',129,'DAILY','2022-07-11','2022-07-14 09:36:32','2022-07-15 09:36:32','769',10620927.05,10620927.05,'769','2022-07-14 09:40:02','764','2022-07-14 09:56:46',10,0),('21','226',130,'DAILY','2022-07-12','2022-07-14 10:01:56','2022-07-15 10:01:56','769',7396479.80,7396479.80,'769','2022-07-14 10:04:16','764','2022-07-14 10:09:53',10,0),('21','226',131,'DAILY','2022-07-13','2022-07-14 10:11:22','2022-07-15 10:11:22','769',10445817.45,10445817.45,'769','2022-07-14 10:14:26','764','2022-07-14 10:36:25',10,0),('21','226',132,'DAILY','2022-07-14','2022-07-19 09:07:15','2022-07-20 09:07:15','769',10291967.05,10291967.05,'769','2022-07-20 16:03:20','769','2022-07-20 16:48:10',10,0),('21','226',133,'DAILY','2022-07-15','2022-07-20 17:15:43','2022-07-21 17:15:43','769',8515189.90,8515189.90,'769','2022-07-20 17:23:55','764','2022-07-20 17:26:07',10,0),('21','226',134,'DAILY','2022-07-16','2022-07-20 17:32:37','2022-07-21 17:32:37','769',6047037.35,6047037.35,'769','2022-07-20 17:53:38','764','2022-07-20 17:55:25',10,0),('21','226',135,'DAILY','2022-07-17','2022-07-20 18:03:30','2022-07-21 18:03:30','769',7618703.10,7618703.10,'769','2022-07-20 18:11:00','764','2022-07-20 18:11:43',10,0),('21','226',136,'DAILY','2022-07-18','2022-07-20 18:17:35','2022-07-21 18:17:35','769',1358751.50,1358751.50,'769','2022-07-20 18:18:22','764','2022-07-20 18:19:25',10,0),('21','226',137,'DAILY','2022-07-19','2022-07-20 18:26:04','2022-07-21 18:26:04','769',1190432.50,1190432.50,'769','2022-07-20 18:27:34','764','2022-07-20 18:32:24',10,0),('21','226',138,'DAILY','2022-07-20','2022-07-20 18:33:16','2022-07-21 18:33:16','769',2297697.30,2297697.30,'769','2022-07-20 18:33:54','764','2022-07-20 18:36:02',10,0),('21','226',139,'DAILY','2022-07-20','2022-07-21 15:08:48','2022-07-22 15:08:48','769',6286355.60,6286355.60,'769','2022-07-21 16:23:48','764','2022-07-21 16:30:31',10,0),('21','226',140,'DAILY','2022-07-20','2022-07-21 16:32:53','2022-07-22 16:32:53','764',0.00,0.00,'764','2022-07-21 16:40:05','769','2022-07-21 16:40:24',10,0),('21','226',141,'DAILY','2022-07-21','2022-07-24 14:08:59','2022-07-25 14:08:59','764',979515.90,979515.90,'764','2022-07-24 14:09:46','764','2022-07-24 14:15:21',10,0),('21','226',142,'DAILY','2022-07-22','2022-07-24 14:21:11','2022-07-25 14:21:11','769',193035.55,193035.55,'769','2022-07-24 14:22:35','764','2022-07-24 14:27:48',10,0),('21','226',143,'DAILY','2022-07-23','2022-07-24 14:28:55','2022-07-25 14:28:55','769',5337838.80,5337838.80,'769','2022-07-24 14:31:06','764','2022-07-24 16:20:28',10,0),('21','226',144,'DAILY','2022-07-24','2022-07-25 10:05:14','2022-07-26 10:05:14','769',5567346.25,5567346.25,'769','2022-07-25 15:01:19','764','2022-07-26 11:09:31',10,0),('21','226',145,'DAILY','2022-07-25','2022-07-26 16:12:49','2022-07-27 16:12:49','769',6833071.25,6833071.25,'769','2022-07-26 16:21:37','764','2022-07-26 16:50:38',10,0),('21','226',146,'DAILY','2022-07-25','2022-07-26 16:53:01','2022-07-27 16:53:01','769',1015407.90,1015407.90,'769','2022-07-26 16:54:13','764','2022-07-27 12:03:31',10,0),('21','226',147,'DAILY','2022-07-26','2022-07-27 12:05:53','2022-07-28 12:05:53','769',8824834.80,8824834.80,'769','2022-07-27 12:11:57','764','2022-07-27 12:39:34',10,0),('21','226',148,'DAILY','2022-07-27','2022-07-28 15:40:30','2022-07-29 15:40:30','769',7733799.90,7733799.90,'769','2022-07-28 15:41:58','764','2022-07-28 16:23:33',10,0),('21','226',149,'DAILY','2022-07-28','2022-07-29 17:13:54','2022-07-30 17:13:54','769',8536026.60,8536026.60,'769','2022-07-29 17:16:29','764','2022-07-29 17:30:50',10,0),('21','226',150,'DAILY','2022-07-29','2022-07-30 14:44:22','2022-07-31 14:44:22','769',0.00,0.00,'764','2022-07-31 15:48:47','764','2022-07-31 15:49:16',10,0),('21','226',151,'DAILY','2022-07-29','2022-07-31 15:50:57','2022-08-01 15:50:57','764',8961045.30,8961045.30,'769','2022-07-31 17:28:22','764','2022-07-31 17:41:30',10,0),('21','226',152,'DAILY','2022-07-30','2022-07-31 17:47:22','2022-08-01 17:47:22','769',6543112.50,6543112.50,'769','2022-07-31 17:51:05','764','2022-07-31 17:57:01',10,0),('21','226',153,'DAILY','2022-07-31','2022-08-01 15:03:42','2022-08-02 15:03:42','769',7562546.96,7562546.96,'769','2022-08-01 15:13:48','769','2022-08-02 16:31:11',10,0),('21','226',154,'DAILY','2022-08-01','2022-08-02 16:32:20','2022-08-03 16:32:20','769',8804388.66,8804388.66,'769','2022-08-02 16:41:00','764','2022-08-03 14:20:01',10,0),('21','226',155,'DAILY','2022-08-02','2022-08-03 14:26:06','2022-08-04 14:26:06','769',11952134.92,11952134.92,'769','2022-08-03 14:27:57','764','2022-08-03 16:42:51',10,0),('21','226',156,'DAILY','2022-08-03','2022-08-04 13:54:27','2022-08-05 13:54:27','769',9676818.01,9676818.01,'769','2022-08-04 14:06:52','764','2022-08-04 14:18:34',10,0),('21','226',157,'DAILY','2022-08-04','2022-08-05 16:54:40','2022-08-06 16:54:40','769',10099734.35,10099734.35,'769','2022-08-05 16:56:51','764','2022-08-05 17:21:49',10,0),('21','226',158,'DAILY','2022-08-05','2022-08-06 17:33:19','2022-08-07 17:33:19','769',5724443.73,5724443.73,'769','2022-08-06 17:35:22','764','2022-08-06 19:28:42',10,0),('21','226',159,'DAILY','2022-08-06','2022-08-07 17:07:30','2022-08-08 17:07:30','769',6969490.30,6969490.30,'769','2022-08-07 17:47:48','764','2022-08-10 10:16:51',10,0),('21','226',160,'DAILY','2022-08-07','2022-08-10 10:17:18','2022-08-11 10:17:18','769',2691956.66,2691956.66,'769','2022-08-10 10:18:03','764','2022-08-10 10:28:15',10,0),('21','226',161,'DAILY','2022-08-08','2022-08-10 10:28:39','2022-08-11 10:28:39','769',2556458.89,2556458.89,'769','2022-08-10 10:29:35','764','2022-08-10 10:38:20',10,0),('21','226',162,'DAILY','2022-08-09','2022-08-10 10:41:14','2022-08-11 10:41:14','769',9607065.81,9607065.81,'769','2022-08-10 10:43:27','764','2022-08-10 10:53:30',10,0),('21','226',163,'DAILY','2022-08-10','2022-08-11 17:09:18','2022-08-12 17:09:18','769',8044816.41,8044816.41,'769','2022-08-11 17:24:30','764','2022-08-11 18:44:55',10,0),('21','226',164,'DAILY','2022-08-11','2022-08-13 08:22:17','2022-08-14 08:22:17','769',7640710.44,7640710.44,'769','2022-08-13 08:33:40','764','2022-08-14 05:48:33',10,0),('21','226',165,'DAILY','2022-08-12','2022-08-16 09:25:41','2022-08-17 09:25:41','769',7523827.15,7523827.15,'769','2022-08-16 09:27:35','764','2022-08-16 13:28:30',10,0),('21','226',166,'DAILY','2022-08-12','2022-08-16 14:19:18','2022-08-17 14:19:18','769',90485.90,90485.90,'769','2022-08-16 14:20:00','764','2022-08-16 14:24:14',10,0),('21','226',167,'DAILY','2022-08-13','2022-08-16 14:26:06','2022-08-17 14:26:06','769',2691676.40,2691676.40,'769','2022-08-16 14:26:46','764','2022-08-16 14:34:31',10,0),('21','226',168,'DAILY','2022-08-14','2022-08-16 14:35:12','2022-08-17 14:35:12','769',8602112.25,8602112.25,'769','2022-08-16 14:37:27','764','2022-08-16 14:41:23',10,0),('21','226',169,'DAILY','2022-08-15','2022-08-16 14:55:28','2022-08-17 14:55:28','769',6983286.85,6983286.85,'769','2022-08-16 15:00:02','764','2022-08-16 15:15:40',10,0),('21','226',170,'DAILY','2022-08-16','2022-08-19 14:51:02','2022-08-20 14:51:02','769',2564418.50,2564418.50,'769','2022-08-19 14:52:21','764','2022-08-19 15:06:46',10,0),('21','226',171,'DAILY','2022-08-17','2022-08-19 15:07:36','2022-08-20 15:07:36','769',8564055.50,8564055.50,'769','2022-08-19 15:16:36','764','2022-08-19 15:28:29',10,0),('21','226',172,'DAILY','2022-08-17','2022-08-19 15:34:50','2022-08-20 15:34:50','769',40351.20,40351.20,'769','2022-08-19 15:35:23','764','2022-08-19 16:16:17',10,0),('21','226',173,'DAILY','2022-08-18','2022-08-22 11:12:31','2022-08-23 11:12:31','769',2882654.50,2882654.50,'769','2022-08-22 11:13:32','764','2022-08-22 11:28:36',10,0),('21','226',174,'DAILY','2022-08-18','2022-08-22 11:34:12','2022-08-23 11:34:12','769',389896.00,389896.00,'769','2022-08-22 11:34:55','764','2022-08-22 11:37:56',10,0),('21','226',175,'DAILY','2022-08-18','2022-08-22 11:38:32','2022-08-23 11:38:32','769',100783.80,100783.80,'769','2022-08-22 11:44:53','764','2022-08-22 11:46:03',10,0),('21','226',176,'DAILY','2022-08-19','2022-08-22 11:47:05','2022-08-23 11:47:05','769',3111680.78,3111680.78,'769','2022-08-22 11:47:46','764','2022-08-22 11:52:46',10,0),('21','226',177,'DAILY','2022-08-20','2022-08-22 11:53:51','2022-08-23 11:53:51','769',1660147.78,1660147.78,'769','2022-08-22 11:55:26','764','2022-08-22 12:00:21',10,0),('21','226',178,'DAILY','2022-08-21','2022-08-22 12:02:44','2022-08-23 12:02:44','769',9635528.32,9635528.32,'769','2022-08-22 12:07:38','764','2022-08-22 12:24:29',10,0),('21','226',179,'DAILY','2022-08-22','2022-09-01 09:21:53','2022-09-02 09:21:53','769',9589843.50,9589843.50,'769','2022-09-01 09:24:30','764','2022-09-01 09:40:09',10,0),('21','226',180,'DAILY','2022-08-23','2022-09-03 08:23:32','2022-09-04 08:23:32','769',6921592.56,6921592.56,'769','2022-09-03 08:26:15','764','2022-09-03 08:36:17',10,0),('21','226',181,'DAILY','2022-08-24','2022-09-03 08:36:34','2022-09-04 08:36:34','769',7987365.46,7987365.46,'769','2022-09-03 08:39:47','764','2022-09-03 08:48:58',10,0),('21','226',182,'DAILY','2022-08-25','2022-09-03 08:49:39','2022-09-04 08:49:39','769',9163771.22,9163771.22,'769','2022-09-03 08:59:32','764','2022-09-03 09:05:27',10,0),('21','226',183,'DAILY','2022-08-26','2022-09-03 09:06:27','2022-09-04 09:06:27','769',2714800.36,2714800.36,'769','2022-09-03 09:08:56','764','2022-09-03 09:13:29',10,0),('21','226',184,'DAILY','2022-08-27','2022-09-03 09:14:14','2022-09-04 09:14:14','769',9349971.48,9349971.48,'769','2022-09-03 09:18:13','764','2022-09-03 09:24:58',10,0),('21','226',185,'DAILY','2022-08-28','2022-09-03 09:26:01','2022-09-04 09:26:01','769',1822271.42,1822271.42,'769','2022-09-03 09:26:49','764','2022-09-03 09:31:05',10,0),('21','226',186,'DAILY','2022-08-29','2022-09-03 09:31:18','2022-09-04 09:31:18','769',2307247.88,2307247.88,'769','2022-09-03 09:32:27','764','2022-09-03 09:38:16',10,0),('21','226',187,'DAILY','2022-08-30','2022-09-03 09:39:34','2022-09-04 09:39:34','769',7955307.64,7955307.64,'769','2022-09-03 09:42:25','764','2022-09-03 09:55:26',10,0),('21','226',188,'DAILY','2022-08-31','2022-09-03 11:38:09','2022-09-04 11:38:09','769',4494654.94,4494654.94,'769','2022-09-03 11:39:35','764','2022-09-03 11:54:11',10,0),('21','226',189,'DAILY','2022-09-01','2022-09-06 08:13:51','2022-09-07 08:13:51','769',7692350.42,7692350.42,'769','2022-09-06 08:21:30','764','2022-09-06 08:33:05',10,0),('21','226',190,'DAILY','2022-09-02','2022-09-06 08:37:10','2022-09-07 08:37:10','769',7375648.50,7375648.50,'769','2022-09-06 08:39:37','764','2022-09-06 08:45:25',10,0),('21','226',191,'DAILY','2022-09-03','2022-09-06 08:46:24','2022-09-07 08:46:24','769',7493310.46,7493310.46,'769','2022-09-06 08:48:25','764','2022-09-06 08:53:36',10,0),('21','226',192,'DAILY','2022-09-04','2022-09-06 08:56:07','2022-09-07 08:56:07','769',9173786.22,9173786.22,'769','2022-09-06 08:58:39','764','2022-09-06 09:06:58',10,0),('21','226',193,'DAILY','2022-09-05','2022-09-06 09:11:16','2022-09-07 09:11:16','769',10450002.48,10450002.48,'769','2022-09-06 09:28:41','764','2022-09-06 09:34:19',10,0),('21','226',194,'DAILY','2022-09-06','2022-09-15 12:04:03','2022-09-16 12:04:03','769',2505269.56,2505269.56,'769','2022-09-15 12:06:26','764','2022-09-15 12:31:28',10,0),('21','226',195,'DAILY','2022-09-07','2022-09-15 12:34:41','2022-09-16 12:34:41','769',10515388.58,10515388.58,'769','2022-09-15 12:44:13','764','2022-09-15 13:05:16',10,0),('21','226',196,'DAILY','2022-09-08','2022-09-15 13:08:41','2022-09-16 13:08:41','769',9840303.42,9840303.42,'769','2022-09-15 13:12:01','764','2022-09-15 13:30:05',10,0),('21','226',197,'DAILY','2022-09-09','2022-09-15 13:30:30','2022-09-16 13:30:30','769',9615412.78,9615412.78,'769','2022-09-15 13:36:05','764','2022-09-15 13:57:01',10,0),('21','226',198,'DAILY','2022-09-10','2022-09-15 13:58:53','2022-09-16 13:58:53','769',10993048.10,10993048.10,'769','2022-09-15 14:11:46','764','2022-09-15 14:27:56',10,0),('21','226',199,'DAILY','2022-09-11','2022-09-15 14:32:02','2022-09-16 14:32:02','769',8120640.78,8120640.78,'769','2022-09-15 14:35:35','764','2022-09-15 14:47:20',10,0),('21','226',200,'DAILY','2022-09-12','2022-09-15 14:49:05','2022-09-16 14:49:05','769',2759383.34,2759383.34,'769','2022-09-15 14:51:40','764','2022-09-15 15:08:53',10,0),('21','226',201,'DAILY','2022-09-13','2022-09-15 15:10:47','2022-09-16 15:10:47','769',9053075.90,9053075.90,'769','2022-09-15 15:14:36','764','2022-09-15 15:22:19',10,0),('21','226',202,'DAILY','2022-09-14','2022-09-15 15:23:28','2022-09-16 15:23:28','769',7034362.34,7034362.34,'769','2022-09-15 15:26:56','764','2022-09-15 15:54:05',10,0),('21','226',203,'DAILY','2022-09-15','2022-09-28 14:02:04','2022-09-29 14:02:04','769',6848128.76,6848128.76,'769','2022-09-28 14:09:24','764','2022-09-28 16:21:35',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4482 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','226','1','6',126,'1','1',1215470.53,1216247.39,776.86,128181.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','6',127,'2','1',1028665.71,1029392.92,727.21,119989.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','6',128,'3','1',1507572.29,1508346.45,774.16,127736.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','6',129,'4','1',1053448.50,1055127.80,1679.30,277084.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','6',130,'5','1',885382.55,886085.05,702.50,115912.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','6',131,'6','1',946796.57,948635.41,1838.84,303408.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','6',132,'7','1',833891.66,834449.82,558.16,92096.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','6',133,'8','1',796074.54,796525.59,451.05,74423.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','6',134,'17','1',760073.65,760073.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','6',135,'18','1',818443.58,818443.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','6',136,'19','1',774520.51,774520.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','6',137,'20','1',925845.10,925845.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','6',138,'21','1',697255.88,697255.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','6',139,'22','1',932101.45,932101.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','6',140,'23','1',747143.62,747143.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','6',141,'24','1',780604.30,780604.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','6',142,'25','2',686310.75,687216.83,906.08,634256.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','6',143,'26','2',601933.39,603222.08,1288.69,902083.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','6',144,'27','2',363331.85,363331.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','6',145,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','6',146,'29','3',213974.35,216353.93,2379.58,1308771.20,0.00,0.00,0.00,0.00,0.00),('21','226','4','6',147,'30','3',91021.48,91021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','7',148,'1','1',1216247.39,1216247.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','7',149,'2','1',1029392.92,1029392.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','7',150,'3','1',1508346.45,1508628.39,281.94,46520.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','7',151,'4','1',1055127.80,1056108.55,980.75,161823.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','7',152,'5','1',886085.05,889802.07,3717.02,613308.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','7',153,'6','1',948635.41,952473.05,3837.64,633210.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','7',154,'7','1',834449.82,837474.65,3024.83,499096.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','7',155,'8','1',796525.59,799750.04,3224.45,532034.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','7',156,'17','1',760073.65,760683.42,609.77,100612.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','7',157,'18','1',818443.58,819055.31,611.73,100935.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','7',158,'19','1',774520.51,774826.80,306.29,50537.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','7',159,'20','1',925845.10,926007.36,162.26,26772.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','7',160,'21','1',697255.88,700646.60,3390.72,559468.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','7',161,'22','1',932101.45,935495.97,3394.52,560095.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','7',162,'23','1',747143.62,749669.24,2525.62,416727.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','7',163,'24','1',780604.30,783206.91,2602.61,429430.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','7',164,'25','2',687216.83,688558.54,1341.71,939197.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','7',165,'26','2',603222.08,603986.91,764.83,535381.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','7',166,'27','2',363331.85,363331.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','7',167,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','7',168,'29','3',216353.93,216617.36,263.43,144886.50,0.00,0.00,0.00,0.00,0.00),('21','226','4','7',169,'30','3',91021.48,91021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','8',170,'1','1',1216247.39,1222760.26,6512.87,1074623.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','8',171,'2','1',1029392.92,1035291.52,5898.60,973269.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','8',172,'3','1',1508628.39,1515415.05,6786.66,1119798.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','8',173,'4','1',1056108.55,1062248.94,6140.39,1013164.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','8',174,'5','1',889802.07,891806.57,2004.50,330742.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','8',175,'6','1',952473.05,954041.15,1568.10,258736.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','8',176,'7','1',837474.65,837646.04,149.69,24698.85,0.00,0.00,21.70,0.00,0.00),('21','226','1','8',177,'8','1',799750.04,800680.38,908.64,149925.60,0.00,0.00,21.70,0.00,0.00),('21','226','2','8',178,'17','1',760683.42,760889.19,205.77,33952.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','8',179,'18','1',819055.31,819231.76,176.45,29114.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','8',180,'19','1',774826.80,775360.42,533.62,88047.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','8',181,'20','1',926007.36,926519.10,511.74,84437.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','8',182,'21','1',700646.60,700646.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','8',183,'22','1',935495.97,935495.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','8',184,'23','1',749669.24,749669.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','8',185,'24','1',783206.91,783206.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','8',186,'25','2',688558.54,691124.41,2565.87,1796109.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','8',187,'26','2',603986.91,604932.84,945.93,662151.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','8',188,'27','2',363331.85,364044.55,712.70,498890.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','8',189,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','8',190,'29','3',216617.36,217772.05,1055.95,580773.60,0.00,0.00,98.74,0.00,0.00),('21','226','4','8',191,'30','3',91021.48,91021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','9',192,'1','1',1222760.26,1222760.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','9',193,'2','1',1035291.52,1035291.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','9',194,'3','1',1515415.04,1515415.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','9',195,'4','1',1062248.94,1062248.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','9',196,'5','1',891806.57,895392.68,3586.11,591708.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','9',197,'6','1',954041.15,957878.23,3837.08,633118.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','9',198,'7','1',837646.04,841335.90,3689.86,608826.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','9',199,'8','1',800680.38,804605.46,3925.08,647638.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','9',200,'17','1',760889.19,763161.30,2272.11,374898.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','9',201,'18','1',819231.76,821778.93,2547.17,420283.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','9',202,'19','1',775360.42,776274.04,913.62,150747.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','9',203,'20','1',926519.10,927549.31,1030.21,169984.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','9',204,'21','1',700646.60,700646.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','9',205,'22','1',935495.97,935495.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','9',206,'23','1',749669.24,751005.06,1335.82,220410.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','9',207,'24','1',783206.91,784634.41,1427.50,235537.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','9',208,'25','2',691124.41,692961.49,1837.08,1285956.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','9',209,'26','2',604932.84,604933.34,0.50,350.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','9',210,'27','2',364044.55,366219.62,2175.07,1522549.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','9',211,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','9',212,'29','3',217772.05,218229.67,457.62,251689.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','9',213,'30','3',91021.48,91021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','10',214,'1','1',1222760.26,1226857.04,4096.78,675968.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','10',215,'2','1',1035291.52,1039133.61,3842.09,633944.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','10',216,'3','1',1515415.04,1520072.22,4657.18,768434.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','10',217,'4','1',1062248.94,1067204.17,4955.23,817612.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','10',218,'5','1',895392.68,899151.50,3758.82,620205.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','10',219,'6','1',957878.23,962333.52,4455.29,735122.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','10',220,'7','1',841335.90,842200.22,864.32,142612.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','10',221,'8','1',804605.46,805424.19,818.73,135090.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','10',222,'17','1',763161.30,763161.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','10',223,'18','1',821778.93,821778.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','10',224,'19','1',776274.04,776997.97,723.93,119448.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','10',225,'20','1',927549.31,928115.03,565.72,93343.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','10',226,'21','1',700646.60,703398.86,2752.26,454122.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','10',227,'22','1',935495.97,938596.37,3100.40,511566.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','10',228,'23','1',751005.06,751583.19,578.13,95391.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','10',229,'24','1',784634.41,785226.59,592.18,97709.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','10',230,'25','2',692961.49,694106.81,1145.32,801724.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','10',231,'26','2',604933.34,604933.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','10',232,'27','2',366219.62,367884.69,1665.07,1165549.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','10',233,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','10',234,'29','3',218229.67,218512.40,282.73,155501.50,0.00,0.00,0.00,0.00,0.00),('21','226','4','10',235,'30','3',91021.48,91021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','11',236,'1','1',1226857.04,1228467.74,1610.70,265765.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','11',237,'2','1',1039133.61,1040582.23,1448.62,239022.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','11',238,'3','1',1520072.22,1526671.10,6598.88,1088815.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','11',239,'4','1',1067204.17,1073406.86,6202.69,1023443.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','11',240,'5','1',899151.50,900005.71,854.21,140944.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','11',241,'6','1',962333.52,963711.44,1377.92,227356.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','11',242,'7','1',842200.22,842200.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','11',243,'8','1',805424.19,805424.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','11',244,'17','1',763161.30,763493.04,331.74,54737.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','11',245,'18','1',821778.93,821778.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','11',246,'19','1',776997.97,776997.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','11',247,'20','1',928115.03,928115.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','11',248,'21','1',703398.86,703398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','11',249,'22','1',938596.37,938596.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','11',250,'23','1',751583.19,751583.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','11',251,'24','1',785226.59,785226.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','11',252,'25','2',694106.81,694729.64,622.83,435981.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','11',253,'26','2',604933.34,604933.38,0.04,28.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','11',254,'27','2',367884.69,369136.31,1251.62,876134.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','11',255,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','11',256,'29','3',218512.40,218971.06,458.66,252265.20,0.00,0.00,0.00,0.00,0.00),('21','226','4','11',257,'30','3',91021.48,91021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','12',258,'1','1',1228467.74,1228467.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','12',259,'2','1',1040582.23,1040582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','12',260,'3','1',1526671.10,1526701.57,30.47,5027.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','12',261,'4','1',1073406.86,1073463.82,56.96,9398.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','12',262,'5','1',900005.71,900005.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','12',263,'6','1',963711.44,963711.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','12',264,'7','1',842200.22,842200.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','12',265,'8','1',805424.19,805424.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','12',266,'17','1',763493.04,763493.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','12',267,'18','1',821778.93,821778.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','12',268,'19','1',776997.97,777045.93,47.96,7913.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','12',269,'20','1',928115.03,928115.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','12',270,'21','1',703398.86,709463.57,6064.71,1000677.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','12',271,'22','1',938596.37,945085.09,6488.72,1070638.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','12',272,'23','1',751583.19,752383.83,800.64,132105.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','12',273,'24','1',785226.59,786012.71,786.12,129709.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','12',274,'25','2',694729.64,694817.62,87.98,61586.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','12',275,'26','2',604933.38,604933.68,0.30,210.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','12',276,'27','2',369136.31,371224.79,2088.48,1461936.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','12',277,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','12',278,'29','3',218971.06,219251.62,280.55,154305.25,0.00,0.00,0.00,0.00,0.00),('21','226','4','12',279,'30','3',91021.48,91021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','13',280,'1','1',1228467.74,1228467.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','13',281,'2','1',1040582.23,1040582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','13',282,'3','1',1526701.57,1526701.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','13',283,'4','1',1073463.82,1073463.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','13',284,'5','1',900005.71,900005.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','13',285,'6','1',963711.44,963711.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','13',286,'7','1',842200.22,842515.11,314.89,51956.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','13',287,'8','1',805424.19,805761.18,336.99,55603.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','13',288,'17','1',763493.04,770455.97,6962.93,1148883.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','13',289,'18','1',821778.93,828764.31,6985.38,1152587.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','13',290,'19','1',777045.93,777045.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','13',291,'20','1',928115.03,928115.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','13',292,'21','1',709463.57,709463.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','13',293,'22','1',945085.09,945085.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','13',294,'23','1',752383.83,759903.96,7520.13,1240821.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','13',295,'24','1',786012.71,793452.03,7439.32,1227487.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','13',296,'25','2',694817.62,695580.41,762.79,533953.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','13',297,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','13',298,'27','2',371224.79,373642.12,2417.33,1692131.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','13',299,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','13',300,'29','3',219251.62,219655.13,403.51,221932.70,0.00,0.00,0.00,0.00,0.00),('21','226','4','13',301,'30','3',91021.48,91021.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','14',302,'1','1',1228467.74,1236653.80,8186.06,1350699.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','14',303,'2','1',1040582.23,1048324.53,7742.30,1277479.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','14',304,'3','1',1526701.57,1534533.49,7831.92,1292266.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','14',305,'4','1',1073463.82,1081368.88,7905.06,1304334.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','14',306,'5','1',900005.71,900005.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','14',307,'6','1',963711.44,963711.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','14',308,'7','1',842515.11,842515.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','14',309,'8','1',805761.18,805761.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','14',310,'17','1',770455.97,770455.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','14',311,'18','1',828764.31,828764.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','14',312,'19','1',777045.93,777045.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','14',313,'20','1',928115.03,928115.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','14',314,'21','1',709463.57,709463.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','14',315,'22','1',945085.09,945085.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','14',316,'23','1',759903.96,760025.39,121.43,20035.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','14',317,'24','1',793452.03,793452.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','14',318,'25','2',695580.41,696479.85,899.44,629608.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','14',319,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','14',320,'27','2',373642.12,374439.25,797.13,557991.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','14',321,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','14',322,'29','3',219655.13,220194.05,538.92,296406.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','14',323,'30','3',91021.48,91032.39,10.91,6002.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','15',324,'1','1',1236653.80,1236653.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','15',325,'2','1',1048324.53,1048324.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','15',326,'3','1',1534533.49,1540433.72,5900.23,973537.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','15',327,'4','1',1081368.88,1087509.11,6140.23,1013137.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','15',328,'5','1',900005.71,904250.74,4245.03,700429.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','15',329,'6','1',963711.44,968579.14,4867.70,803170.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','15',330,'7','1',842515.11,842919.65,404.54,66749.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','15',331,'8','1',805761.18,806415.24,654.06,107919.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','15',332,'17','1',770455.97,773031.06,2575.09,424889.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','15',333,'18','1',828764.31,831604.95,2840.64,468705.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','15',334,'19','1',777045.93,777045.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','15',335,'20','1',928115.03,928115.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','15',336,'21','1',709463.57,709463.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','15',337,'22','1',945085.09,945085.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','15',338,'23','1',760025.39,760025.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','15',339,'24','1',793452.03,793452.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','15',340,'25','2',696479.85,696535.56,55.71,38997.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','15',341,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','15',342,'27','2',374439.25,374850.68,411.43,288001.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','15',343,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','15',344,'29','3',220194.05,220581.81,387.76,213268.55,0.00,0.00,0.00,0.00,0.00),('21','226','4','15',345,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','16',346,'1','1',1236653.80,1236653.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','16',347,'2','1',1048324.53,1048324.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','16',348,'3','1',1540433.72,1540433.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','16',349,'4','1',1087509.11,1087509.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','16',350,'5','1',904250.74,904250.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','16',351,'6','1',968579.14,968579.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','16',352,'7','1',842919.65,842919.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','16',353,'8','1',806415.24,806415.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','16',354,'17','1',773031.06,777759.84,4728.78,780248.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','16',355,'18','1',831604.95,836544.42,4939.47,815012.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','16',356,'19','1',777045.93,777205.22,159.29,26282.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','16',357,'20','1',928115.03,928235.41,120.38,19862.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','16',358,'21','1',709463.57,711344.47,1880.90,310348.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','16',359,'22','1',945085.09,946932.51,1847.42,304824.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','16',360,'23','1',760025.39,764742.82,4717.43,778375.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','16',361,'24','1',793452.03,798643.40,5191.37,856576.05,0.00,0.00,0.00,0.00,0.00),('21','226','3','16',362,'25','2',696535.56,696573.82,38.26,26782.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','16',363,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','16',364,'27','2',374850.68,374850.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','16',365,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','16',366,'29','3',220581.81,220963.69,381.88,210035.65,0.00,0.00,0.00,0.00,0.00),('21','226','4','16',367,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','17',368,'1','1',1236653.80,1236653.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','17',369,'2','1',1048324.53,1048324.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','17',370,'3','1',1540433.72,1540433.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','17',371,'4','1',1087509.11,1087509.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','17',372,'5','1',904250.74,904250.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','17',373,'6','1',968579.14,968579.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','17',374,'7','1',842919.65,842919.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','17',375,'8','1',806415.24,806415.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','17',376,'17','1',777759.84,777759.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','17',377,'18','1',836544.42,836544.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','17',378,'19','1',777205.22,777699.12,493.90,81493.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','17',379,'20','1',928235.41,928257.49,22.08,3643.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','17',380,'21','1',711344.47,711344.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','17',381,'22','1',946932.51,946932.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','17',382,'23','1',764742.82,764742.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','17',383,'24','1',798643.40,798643.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','17',384,'25','2',696573.82,696573.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','17',385,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','17',386,'27','2',374850.68,374850.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','17',387,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','17',388,'29','3',220963.69,221466.69,503.00,276652.20,0.00,0.00,0.00,0.00,0.00),('21','226','4','17',389,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','18',390,'1','1',1236653.80,1244032.80,7379.00,1217535.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','18',391,'2','1',1048324.53,1055467.21,7142.68,1178542.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','18',392,'3','1',1540433.72,1548073.73,7640.01,1260601.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','18',393,'4','1',1087509.11,1094661.70,7152.59,1180177.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','18',394,'5','1',904250.74,904250.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','18',395,'6','1',968579.14,968579.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','18',396,'7','1',842919.65,843165.45,245.80,40557.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','18',397,'8','1',806415.24,806460.22,44.98,7421.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','18',398,'17','1',777759.84,777759.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','18',399,'18','1',836544.42,836544.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','18',400,'19','1',777699.12,777953.13,254.01,41911.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','18',401,'20','1',928257.49,928496.41,238.92,39421.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','18',402,'21','1',711344.47,711344.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','18',403,'22','1',946932.51,946932.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','18',404,'23','1',764742.82,764742.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','18',405,'24','1',798643.40,798643.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','18',406,'25','2',696573.82,696573.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','18',407,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','18',408,'27','2',374850.68,374850.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','18',409,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','18',410,'29','3',221466.69,222312.58,845.89,465237.85,0.00,0.00,0.00,0.00,0.00),('21','226','4','18',411,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','19',412,'1','1',1244032.80,1245694.05,1661.25,274106.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','19',413,'2','1',1055467.21,1057403.92,1936.71,319557.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','19',414,'3','1',1548073.73,1552012.01,3938.28,649816.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','19',415,'4','1',1094661.70,1097971.48,3309.78,546113.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','19',416,'5','1',904250.74,907003.04,2752.30,454129.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','19',417,'6','1',968579.14,972015.81,3436.67,567050.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','19',418,'7','1',843165.45,843165.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','19',419,'8','1',806460.22,806460.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','19',420,'17','1',777759.84,780408.47,2648.63,437023.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','19',421,'18','1',836544.42,839311.00,2766.58,456485.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','19',422,'19','1',777953.13,777953.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','19',423,'20','1',928496.41,928496.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','19',424,'21','1',711344.47,711344.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','19',425,'22','1',946932.51,946932.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','19',426,'23','1',764742.82,767378.51,2635.69,434888.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','19',427,'24','1',798643.40,801493.69,2850.29,470297.85,0.00,0.00,0.00,0.00,0.00),('21','226','3','19',428,'25','2',696573.82,696573.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','19',429,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','19',430,'27','2',374850.68,374850.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','19',431,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','19',432,'29','3',222312.58,222905.10,592.52,325883.25,0.00,0.00,0.00,0.00,0.00),('21','226','4','19',433,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','20',434,'1','1',1245694.05,1249601.48,3907.43,644725.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','20',435,'2','1',1057403.92,1060706.73,3302.81,544963.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','20',436,'3','1',1552012.01,1558030.24,6018.23,993007.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','20',437,'4','1',1097971.48,1103051.49,5080.01,838201.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','20',438,'5','1',907003.04,908283.34,1280.30,211249.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','20',439,'6','1',972015.81,973354.47,1338.66,220878.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','20',440,'7','1',843165.45,843165.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','20',441,'8','1',806460.22,806460.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','20',442,'17','1',780408.47,784885.03,4476.56,738632.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','20',443,'18','1',839311.00,843469.96,4158.96,686228.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','20',444,'19','1',777953.13,777959.19,6.06,999.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','20',445,'20','1',928496.41,928496.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','20',446,'21','1',711344.47,712927.74,1583.27,261239.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','20',447,'22','1',946932.51,948719.04,1786.53,294777.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','20',448,'23','1',767378.51,770557.85,3179.34,524591.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','20',449,'24','1',801493.69,805185.82,3692.13,609201.45,0.00,0.00,0.00,0.00,0.00),('21','226','3','20',450,'25','2',696573.82,696573.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','20',451,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','20',452,'27','2',374850.68,374850.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','20',453,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','20',454,'29','3',222905.10,223454.04,548.94,301916.45,0.00,0.00,0.00,0.00,0.00),('21','226','4','20',455,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','21',456,'1','1',1249601.48,1249732.18,130.70,21565.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','21',457,'2','1',1060706.73,1060889.74,183.01,30196.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','21',458,'3','1',1558030.24,1564109.83,6079.59,1003132.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','21',459,'4','1',1103051.49,1109349.43,6297.94,1039160.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','21',460,'5','1',908283.34,914004.40,5721.06,943974.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','21',461,'6','1',973354.47,979325.35,5970.88,985195.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','21',462,'7','1',843165.45,843204.85,39.40,6501.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','21',463,'8','1',806460.22,806460.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','21',464,'17','1',784885.03,784885.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','21',465,'18','1',843469.96,843469.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','21',466,'19','1',777959.19,777959.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','21',467,'20','1',928496.41,928496.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','21',468,'21','1',712927.74,714683.01,1755.27,289619.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','21',469,'22','1',948719.04,950352.56,1633.52,269530.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','21',470,'23','1',770557.85,771970.30,1412.45,233054.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','21',471,'24','1',805185.82,806774.64,1588.82,262155.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','21',472,'25','2',696573.82,696573.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','21',473,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','21',474,'27','2',374850.68,374850.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','21',475,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','21',476,'29','3',223454.04,223633.65,138.87,76376.85,0.00,0.00,40.74,0.00,0.00),('21','226','4','21',477,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','22',478,'1','1',1249732.18,1250625.85,893.67,147455.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','22',479,'2','1',1060889.74,1061476.06,586.32,96742.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','22',480,'3','1',1564109.83,1571219.04,7109.21,1173019.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','22',481,'4','1',1109349.43,1115097.26,5747.83,948391.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','22',482,'5','1',914004.40,919954.36,5949.96,981743.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','22',483,'6','1',979325.35,985406.21,6080.86,1003341.08,0.00,0.00,0.00,0.00,0.00),('21','226','1','22',484,'7','1',843204.85,844679.91,1475.06,243384.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','22',485,'8','1',806460.22,807767.47,1307.25,215696.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','22',486,'17','1',784885.03,785550.48,665.45,109799.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','22',487,'18','1',843469.96,844237.95,767.99,126718.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','22',488,'19','1',777959.19,778289.60,330.41,54517.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','22',489,'20','1',928496.41,928793.23,296.82,48975.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','22',490,'21','1',714683.01,714683.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','22',491,'22','1',950352.56,950352.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','22',492,'23','1',771970.30,775830.48,3860.18,636930.19,0.00,0.00,0.00,0.00,0.00),('21','226','2','22',493,'24','1',806774.64,810853.07,4078.43,672940.95,0.00,0.00,0.00,0.00,0.00),('21','226','3','22',494,'25','2',696573.82,696573.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','22',495,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','22',496,'27','2',374850.68,374850.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','22',497,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','22',498,'29','3',223633.65,223633.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','22',499,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','23',500,'1','1',1250625.85,1250783.61,157.76,26030.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','23',501,'2','1',1061476.06,1061682.66,206.60,34089.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','23',502,'3','1',1571219.04,1577582.87,6363.83,1050031.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','23',503,'4','1',1115097.26,1119882.62,4785.36,789584.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','23',504,'5','1',919954.36,924420.59,4466.23,736927.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','23',505,'6','1',985406.21,988894.45,3488.24,575559.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','23',506,'7','1',844679.91,848777.58,4097.67,676115.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','23',507,'8','1',807767.47,811567.00,3799.53,626922.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','23',508,'17','1',785550.48,788208.94,2658.46,438645.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','23',509,'18','1',844237.95,845902.00,1664.05,274568.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','23',510,'19','1',778289.60,780408.34,2118.74,349592.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','23',511,'20','1',928793.23,931051.14,2257.91,372555.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','23',512,'21','1',714683.01,716604.23,1921.22,317001.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','23',513,'22','1',950352.56,952317.39,1964.83,324196.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','23',514,'23','1',775830.48,777457.81,1627.33,268509.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','23',515,'24','1',810853.07,812911.03,2057.96,339563.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','23',516,'25','2',696573.82,698472.73,1898.91,1329237.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','23',517,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','23',518,'27','2',374850.68,377786.22,2935.54,2054878.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','23',519,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','23',520,'29','3',223633.65,223633.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','23',521,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','24',522,'1','1',1250783.61,1250783.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','24',523,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','24',524,'3','1',1577582.87,1583846.66,6263.79,1033525.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','24',525,'4','1',1119882.62,1125240.96,5358.34,884126.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','24',526,'5','1',924420.59,930220.60,5800.01,957001.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','24',527,'6','1',988894.45,993839.00,4944.55,815850.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','24',528,'7','1',848777.58,852235.57,3457.99,570568.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','24',529,'8','1',811567.00,814355.28,2788.28,460066.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','24',530,'17','1',788208.94,791160.77,2951.83,487051.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','24',531,'18','1',845902.00,849492.28,3590.28,592396.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','24',532,'19','1',780408.34,783146.78,2738.44,451842.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','24',533,'20','1',931051.14,933471.50,2420.36,399359.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','24',534,'21','1',716604.23,718609.82,2005.59,330922.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','24',535,'22','1',952317.39,955039.41,2722.02,449133.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','24',536,'23','1',777457.81,779979.20,2521.39,416029.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','24',537,'24','1',812911.03,816128.11,3217.08,530818.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','24',538,'25','2',698472.73,699650.23,1177.50,824250.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','24',539,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','24',540,'27','2',377786.22,378999.58,1213.36,849352.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','24',541,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','24',542,'29','3',223633.65,223633.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','24',543,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','25',544,'1','1',1250783.61,1250783.66,0.05,8.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','25',545,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','25',546,'3','1',1583846.66,1589938.48,6091.82,1005150.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','25',547,'4','1',1125240.96,1130151.25,4910.29,810197.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','25',548,'5','1',930220.60,935574.33,5353.73,883365.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','25',549,'6','1',993839.00,997982.08,4143.08,683608.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','25',550,'7','1',852235.57,856031.64,3796.07,626351.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','25',551,'8','1',814355.28,818159.12,3803.84,627633.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','25',552,'17','1',791160.77,794559.91,3399.14,560858.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','25',553,'18','1',849492.28,853084.06,3591.78,592643.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','25',554,'19','1',783146.78,783146.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','25',555,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','25',556,'21','1',718609.82,719277.13,667.31,110106.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','25',557,'22','1',955039.41,955615.18,575.77,95002.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','25',558,'23','1',779979.20,783941.38,3962.18,653759.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','25',559,'24','1',816128.11,819603.25,3475.14,573398.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','25',560,'25','2',699650.23,701826.81,2176.58,1523606.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','25',561,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','25',562,'27','2',378999.58,379939.06,939.48,657636.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','25',563,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','25',564,'29','3',223633.65,223633.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','25',565,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','26',566,'1','1',1250783.66,1250783.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','26',567,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','26',568,'3','1',1589938.48,1596396.46,6457.98,1065566.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','26',569,'4','1',1130151.25,1136935.78,6784.53,1119447.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','26',570,'5','1',935574.33,936313.60,739.27,121979.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','26',571,'6','1',997982.08,998848.10,866.02,142893.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','26',572,'7','1',856031.64,856031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','26',573,'8','1',818159.12,818159.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','26',574,'17','1',794559.91,794559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','26',575,'18','1',853084.06,853084.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','26',576,'19','1',783146.78,783146.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','26',577,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','26',578,'21','1',719277.13,721727.68,2450.55,404340.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','26',579,'22','1',955615.18,958303.49,2688.31,443571.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','26',580,'23','1',783941.38,783941.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','26',581,'24','1',819603.25,819603.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','26',582,'25','2',701826.81,703042.11,1215.30,850710.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','26',583,'26','2',604933.68,604933.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','26',584,'27','2',379939.06,383853.42,3914.36,2740052.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','26',585,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','26',586,'29','3',223633.65,223633.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','26',587,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','27',588,'1','1',1250783.66,1250783.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','27',589,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','27',590,'3','1',1596396.46,1602953.98,6557.52,1081990.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','27',591,'4','1',1136935.78,1143353.41,6417.63,1058908.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','27',592,'5','1',936313.60,943252.02,6918.06,1141479.90,0.00,0.00,20.36,0.00,0.00),('21','226','1','27',593,'6','1',998848.10,1005808.38,6960.28,1148446.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','27',594,'7','1',856031.64,856031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','27',595,'8','1',818159.12,818163.36,4.24,699.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','27',596,'17','1',794559.91,794559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','27',597,'18','1',853084.06,853084.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','27',598,'19','1',783146.78,783146.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','27',599,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','27',600,'21','1',721727.68,721727.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','27',601,'22','1',958303.49,958303.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','27',602,'23','1',783941.38,783953.50,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','27',603,'24','1',819603.25,819615.37,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','27',604,'25','2',703042.11,703994.84,952.73,666911.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','27',605,'26','2',604933.68,604948.68,15.00,10500.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','27',606,'27','2',383853.42,385131.30,1277.88,894516.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','27',607,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','27',608,'29','3',223633.65,223633.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','27',609,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','28',610,'1','1',1250783.66,1250783.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','28',611,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','28',612,'3','1',1602953.98,1602953.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','28',613,'4','1',1143353.41,1143353.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','28',614,'5','1',943252.02,943252.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','28',615,'6','1',1005808.38,1005808.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','28',616,'7','1',856031.64,856031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','28',617,'8','1',818163.36,818163.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','28',618,'17','1',794559.91,794559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','28',619,'18','1',853084.06,853084.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','28',620,'19','1',783146.78,783146.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','28',621,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','28',622,'21','1',721727.68,721909.77,182.09,30044.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','28',623,'22','1',958303.49,958452.34,148.85,24560.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','28',624,'23','1',783953.50,783953.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','28',625,'24','1',819615.37,819615.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','28',626,'25','2',703994.84,705744.79,1749.95,1224965.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','28',627,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','28',628,'27','2',385131.30,385805.28,673.98,471786.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','28',629,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','28',630,'29','3',223633.65,223633.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','28',631,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','29',632,'1','1',1250783.66,1250783.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','29',633,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','29',634,'3','1',1602953.98,1610299.53,7345.55,1212015.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','29',635,'4','1',1143353.41,1150504.79,7151.38,1179977.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','29',636,'5','1',943252.02,950452.41,7200.39,1188064.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','29',637,'6','1',1005808.38,1014071.76,8263.38,1363457.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','29',638,'7','1',856031.64,856031.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','29',639,'8','1',818163.36,818163.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','29',640,'17','1',794559.91,794559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','29',641,'18','1',853084.06,853084.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','29',642,'19','1',783146.78,783146.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','29',643,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','29',644,'21','1',721909.77,721909.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','29',645,'22','1',958452.34,958452.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','29',646,'23','1',783953.50,783953.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','29',647,'24','1',819615.37,819615.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','29',648,'25','2',705744.79,707420.84,1676.05,1173235.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','29',649,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','29',650,'27','2',385805.28,388655.82,2850.54,1995378.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','29',651,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','29',652,'29','3',223633.65,223879.05,245.40,134968.35,0.00,0.00,0.00,0.00,0.00),('21','226','4','29',653,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','30',654,'1','1',1250783.66,1250783.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','30',655,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','30',656,'3','1',1610299.53,1614818.69,4519.16,745661.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','30',657,'4','1',1150504.79,1154980.51,4475.72,738493.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','30',658,'5','1',950452.41,952473.25,2020.84,333438.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','30',659,'6','1',1014071.76,1016419.29,2347.53,387342.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','30',660,'7','1',856031.64,857712.62,1680.98,277361.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','30',661,'8','1',818163.36,819976.31,1812.95,299136.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','30',662,'17','1',794559.91,798546.79,3986.88,657835.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','30',663,'18','1',853084.06,857124.45,4040.39,666664.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','30',664,'19','1',783146.78,783186.17,39.39,6499.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','30',665,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','30',666,'21','1',721909.77,721909.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','30',667,'22','1',958452.34,958452.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','30',668,'23','1',783953.50,787598.58,3645.08,601438.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','30',669,'24','1',819615.37,823291.21,3675.84,606513.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','30',670,'25','2',707420.84,708015.38,594.54,416178.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','30',671,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','30',672,'27','2',388655.82,389583.60,927.78,649446.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','30',673,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','30',674,'29','3',223879.05,224261.25,382.20,210211.65,0.00,0.00,0.00,0.00,0.00),('21','226','4','30',675,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','31',676,'1','1',1250783.66,1250783.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','31',677,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','31',678,'3','1',1614818.69,1619308.07,4489.38,740747.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','31',679,'4','1',1154980.51,1158830.01,3849.50,635167.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','31',680,'5','1',952473.25,956697.28,4224.03,696964.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','31',681,'6','1',1016419.29,1019971.76,3552.47,586157.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','31',682,'7','1',857712.62,857712.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','31',683,'8','1',819976.31,819976.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','31',684,'17','1',798546.79,799651.64,1104.85,182300.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','31',685,'18','1',857124.45,858272.06,1147.61,189355.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','31',686,'19','1',783186.17,783186.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','31',687,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','31',688,'21','1',721909.77,725262.36,3352.59,553177.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','31',689,'22','1',958452.34,962017.76,3565.42,588294.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','31',690,'23','1',787598.58,790836.16,3237.58,534200.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','31',691,'24','1',823291.21,826603.82,3312.61,546580.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','31',692,'25','2',708015.38,708015.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','31',693,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','31',694,'27','2',389583.60,389583.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','31',695,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','31',696,'29','3',224261.25,224519.47,258.22,142023.20,0.00,0.00,0.00,0.00,0.00),('21','226','4','31',697,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','32',698,'1','1',1250783.66,1250783.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','32',699,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','32',700,'3','1',1619308.07,1625465.25,6157.18,1015934.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','32',701,'4','1',1158830.01,1164316.95,5486.94,905345.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','32',702,'5','1',956697.28,962234.85,5537.57,913699.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','32',703,'6','1',1019971.76,1026602.69,6630.93,1094103.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','32',704,'7','1',857712.62,857712.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','32',705,'8','1',819976.31,819976.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','32',706,'17','1',799651.64,799651.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','32',707,'18','1',858272.06,858272.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','32',708,'19','1',783186.17,783186.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','32',709,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','32',710,'21','1',725262.36,725262.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','32',711,'22','1',962017.76,962017.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','32',712,'23','1',790836.16,795077.98,4241.82,699900.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','32',713,'24','1',826603.82,831335.34,4731.52,780700.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','32',714,'25','2',708015.38,708015.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','32',715,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','32',716,'27','2',389583.60,389583.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','32',717,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','32',718,'29','3',224519.47,226995.82,2476.35,1361990.30,0.00,0.00,0.00,0.00,0.00),('21','226','4','32',719,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','33',720,'1','1',1250783.66,1250783.88,0.22,36.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','33',721,'2','1',1061682.66,1061682.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','33',722,'3','1',1625465.25,1631102.08,5636.83,930076.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','33',723,'4','1',1164316.95,1169605.73,5288.78,872648.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','33',724,'5','1',962234.85,966049.79,3814.94,629465.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','33',725,'6','1',1026602.69,1030310.72,3708.03,611824.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','33',726,'7','1',857712.62,857712.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','33',727,'8','1',819976.31,819976.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','33',728,'17','1',799651.64,804842.86,5191.22,856551.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','33',729,'18','1',858272.06,863653.65,5381.59,887962.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','33',730,'19','1',783186.17,783186.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','33',731,'20','1',933471.50,933471.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','33',732,'21','1',725262.36,725552.47,290.11,47868.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','33',733,'22','1',962017.76,962362.18,344.42,56829.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','33',734,'23','1',795077.98,795626.98,549.00,90585.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','33',735,'24','1',831335.34,831774.21,438.87,72413.55,0.00,0.00,0.00,0.00,0.00),('21','226','3','33',736,'25','2',708015.38,708915.07,899.69,629783.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','33',737,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','33',738,'27','2',389583.60,390445.58,861.98,603386.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','33',739,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','33',740,'29','3',226995.82,227124.94,129.12,71014.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','33',741,'30','3',91032.39,91032.39,0.00,2.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','34',742,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','34',743,'2','1',1061682.66,1062003.41,320.75,52923.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','34',744,'3','1',1631102.08,1636276.21,5174.13,853731.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','34',745,'4','1',1169605.73,1174659.34,5053.61,833845.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','34',746,'5','1',966049.79,971614.55,5564.76,918185.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','34',747,'6','1',1030310.72,1035442.79,5132.07,846791.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','34',748,'7','1',857712.62,858274.05,561.43,92635.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','34',749,'8','1',819976.31,820392.30,415.99,68638.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','34',750,'17','1',804842.86,807180.67,2337.81,385738.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','34',751,'18','1',863653.65,865859.08,2205.43,363895.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','34',752,'19','1',783186.17,785254.27,2068.10,341236.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','34',753,'20','1',933471.50,935539.24,2067.74,341177.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','34',754,'21','1',725552.47,728008.62,2456.15,405264.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','34',755,'22','1',962362.18,965235.53,2873.35,474102.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','34',756,'23','1',795626.98,798019.74,2392.76,394805.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','34',757,'24','1',831774.21,834283.70,2509.49,414065.85,0.00,0.00,0.00,0.00,0.00),('21','226','3','34',758,'25','2',708915.07,709458.19,543.12,380184.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','34',759,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','34',760,'27','2',390445.58,392161.44,1715.86,1201102.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','34',761,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','34',762,'29','3',227124.94,227550.07,425.13,233821.50,0.00,0.00,0.00,0.00,0.00),('21','226','4','34',763,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','35',764,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','35',765,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','35',766,'3','1',1636276.21,1641826.62,5550.41,915817.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','35',767,'4','1',1174659.34,1178768.17,4108.83,677956.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','35',768,'5','1',971614.55,974570.67,2956.12,487759.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','35',769,'6','1',1035442.79,1037886.09,2443.30,403144.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','35',770,'7','1',858274.05,862434.64,4160.59,686497.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','35',771,'8','1',820392.30,824068.07,3675.77,606502.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','35',772,'17','1',807180.67,809795.42,2614.75,431433.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','35',773,'18','1',865859.08,868045.60,2186.52,360775.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','35',774,'19','1',785254.27,789190.26,3935.99,649438.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','35',775,'20','1',935539.24,939423.57,3884.33,640914.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','35',776,'21','1',728008.62,731348.60,3339.98,551096.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','35',777,'22','1',965235.53,970128.88,4893.35,807402.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','35',778,'23','1',798019.74,801931.23,3911.49,645395.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','35',779,'24','1',834283.70,838046.84,3763.14,620918.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','35',780,'25','2',709458.19,710273.29,815.10,570570.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','35',781,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','35',782,'27','2',392161.44,393026.09,864.65,605255.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','35',783,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','35',784,'29','3',227550.07,227935.63,385.56,212058.55,0.00,0.00,0.00,0.00,0.00),('21','226','4','35',785,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','36',786,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','36',787,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','36',788,'3','1',1641826.62,1648461.04,6634.42,1094679.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','36',789,'4','1',1178768.17,1184579.03,5810.86,958791.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','36',790,'5','1',974570.67,978887.96,4317.29,712352.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','36',791,'6','1',1037886.09,1042004.29,4118.20,679503.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','36',792,'7','1',862434.64,865735.36,3300.72,544618.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','36',793,'8','1',824068.07,828052.46,3984.39,657424.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','36',794,'17','1',809795.42,809795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','36',795,'18','1',868045.60,868045.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','36',796,'19','1',789190.26,791734.26,2544.00,419760.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','36',797,'20','1',939423.57,943011.31,3587.74,591977.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','36',798,'21','1',731348.60,733076.40,1727.80,285087.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','36',799,'22','1',970128.88,971948.16,1819.28,300181.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','36',800,'23','1',801931.23,805118.60,3187.37,525916.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','36',801,'24','1',838046.84,841720.91,3674.07,606221.55,0.00,0.00,0.00,0.00,0.00),('21','226','3','36',802,'25','2',710273.29,711098.61,825.32,577724.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','36',803,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','36',804,'27','2',393026.09,395938.46,2912.37,2038659.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','36',805,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','36',806,'29','3',227935.63,228321.07,385.44,211993.10,0.00,0.00,0.00,0.00,0.00),('21','226','4','36',807,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','37',808,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','37',809,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','37',810,'3','1',1648461.04,1648461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','37',811,'4','1',1184579.03,1184579.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','37',812,'5','1',978887.96,978887.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','37',813,'6','1',1042004.29,1042004.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','37',814,'7','1',865735.36,865735.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','37',815,'8','1',828052.46,828052.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','37',816,'17','1',809795.42,809795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','37',817,'18','1',868045.60,868045.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','37',818,'19','1',791734.26,791734.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','37',819,'20','1',943011.31,943011.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','37',820,'21','1',733076.40,733076.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','37',821,'22','1',971948.16,971948.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','37',822,'23','1',805118.60,805118.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','37',823,'24','1',841720.91,841720.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','37',824,'25','2',711098.61,711996.27,897.66,628362.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','37',825,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','37',826,'27','2',395938.46,396374.15,435.69,304983.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','37',827,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','37',828,'29','3',228321.07,228321.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','37',829,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','38',830,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','38',831,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','38',832,'3','1',1648461.04,1654034.04,5573.00,919545.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','38',833,'4','1',1184579.03,1189868.62,5289.59,872782.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','38',834,'5','1',978887.96,982893.86,4005.90,660973.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','38',835,'6','1',1042004.29,1046110.13,4105.84,677463.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','38',836,'7','1',865735.36,866653.64,918.28,151516.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','38',837,'8','1',828052.46,828795.83,743.37,122656.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','38',838,'17','1',809795.42,813101.17,3305.75,545448.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','38',839,'18','1',868045.60,871900.65,3855.05,636083.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','38',840,'19','1',791734.26,794209.05,2474.79,408340.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','38',841,'20','1',943011.31,945419.99,2408.68,397432.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','38',842,'21','1',733076.40,734769.68,1693.28,279391.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','38',843,'22','1',971948.16,973921.67,1973.51,325629.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','38',844,'23','1',805118.60,808175.24,3056.64,504345.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','38',845,'24','1',841720.91,845264.77,3543.86,584736.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','38',846,'25','2',711996.27,713638.13,1641.86,1116464.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','38',847,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','38',848,'27','2',396374.15,396891.18,517.03,351580.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','38',849,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','38',850,'29','3',228321.07,228799.02,477.95,262873.05,0.00,0.00,0.00,0.00,0.00),('21','226','4','38',851,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','39',852,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','39',853,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','39',854,'3','1',1654034.04,1659808.04,5774.00,952710.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','39',855,'4','1',1189868.62,1194640.52,4771.90,787363.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','39',856,'5','1',982893.86,985939.68,3045.82,502560.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','39',857,'6','1',1046110.13,1049567.28,3457.15,570429.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','39',858,'7','1',866653.64,871819.76,5166.12,852409.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','39',859,'8','1',828795.83,834449.84,5654.01,932911.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','39',860,'17','1',813101.17,813101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','39',861,'18','1',871900.65,871900.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','39',862,'19','1',794209.05,798441.18,4232.13,698301.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','39',863,'20','1',945419.99,950222.16,4802.17,792358.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','39',864,'21','1',734769.68,737111.89,2342.21,386464.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','39',865,'22','1',973921.67,976475.36,2553.69,421358.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','39',866,'23','1',808175.24,810473.61,2298.37,379231.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','39',867,'24','1',845264.77,847848.26,2583.49,426275.85,0.00,0.00,0.00,0.00,0.00),('21','226','3','39',868,'25','2',713638.13,714139.36,501.23,340836.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','39',869,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','39',870,'27','2',396891.18,399689.89,2798.71,1903122.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','39',871,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','39',872,'29','3',228799.02,229257.42,458.40,252122.20,0.00,0.00,0.00,0.00,0.00),('21','226','4','39',873,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','40',874,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','40',875,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','40',876,'3','1',1659808.04,1659808.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','40',877,'4','1',1194640.52,1194640.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','40',878,'5','1',985939.68,986256.90,317.22,52341.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','40',879,'6','1',1049567.28,1049973.58,406.30,67039.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','40',880,'7','1',871819.76,877884.02,6064.26,1000602.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','40',881,'8','1',834449.84,841094.71,6644.87,1096403.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','40',882,'17','1',813101.17,813101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','40',883,'18','1',871900.65,871900.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','40',884,'19','1',798441.18,799740.07,1298.89,214316.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','40',885,'20','1',950222.16,951388.81,1166.65,192497.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','40',886,'21','1',737111.89,737111.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','40',887,'22','1',976475.36,976475.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','40',888,'23','1',810473.61,813815.03,3341.42,551334.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','40',889,'24','1',847848.26,851540.86,3692.60,609279.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','40',890,'25','2',714139.36,716403.24,2263.88,1539438.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','40',891,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','40',892,'27','2',399689.89,402630.50,2940.61,1999614.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','40',893,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','40',894,'29','3',229257.42,230004.86,747.44,411092.55,0.00,0.00,0.00,0.00,0.00),('21','226','4','40',895,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','41',896,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','41',897,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','41',898,'3','1',1659808.04,1666714.52,6906.48,1139569.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','41',899,'4','1',1194640.52,1201351.30,6710.78,1107278.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','41',900,'5','1',986256.90,986540.92,284.02,46863.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','41',901,'6','1',1049973.58,1050287.36,313.78,51773.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','41',902,'7','1',877884.02,877884.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','41',903,'8','1',841094.71,841094.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','41',904,'17','1',813101.17,813101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','41',905,'18','1',871900.65,871900.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','41',906,'19','1',799740.07,805448.43,5708.36,941879.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','41',907,'20','1',951388.81,957373.50,5984.69,987473.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','41',908,'21','1',737111.89,737111.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','41',909,'22','1',976475.36,976475.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','41',910,'23','1',813815.03,818987.68,5172.65,853487.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','41',911,'24','1',851540.86,857179.75,5638.89,930416.85,0.00,0.00,0.00,0.00,0.00),('21','226','3','41',912,'25','2',716403.24,718160.75,1757.51,1195106.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','41',913,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','41',914,'27','2',402630.50,405625.52,2995.02,2036613.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','41',915,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','41',916,'29','3',230004.86,230325.27,320.41,176225.50,0.00,0.00,0.00,0.00,0.00),('21','226','4','41',917,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','42',918,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','42',919,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','42',920,'3','1',1666714.52,1666714.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','42',921,'4','1',1201351.30,1201351.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','42',922,'5','1',986540.92,986914.13,373.21,61579.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','42',923,'6','1',1050287.36,1050633.54,346.18,57119.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','42',924,'7','1',877884.02,877884.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','42',925,'8','1',841094.71,841132.29,37.58,6200.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','42',926,'17','1',813101.17,813101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','42',927,'18','1',871900.65,871900.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','42',928,'19','1',805448.43,806622.23,1173.80,193677.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','42',929,'20','1',957373.50,958581.64,1208.14,199343.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','42',930,'21','1',737111.89,737111.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','42',931,'22','1',976475.36,976475.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','42',932,'23','1',818987.68,818987.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','42',933,'24','1',857179.75,857179.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','42',934,'25','2',718160.75,719613.64,1452.89,987965.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','42',935,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','42',936,'27','2',405625.52,408698.30,3072.78,2089490.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','42',937,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','42',938,'29','3',230325.27,230731.53,406.26,223443.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','42',939,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','43',940,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','43',941,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','43',942,'3','1',1666714.52,1674475.37,7760.85,1280540.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','43',943,'4','1',1201351.30,1208351.40,7000.10,1155016.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','43',944,'5','1',986914.13,993441.41,6527.28,1077001.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','43',945,'6','1',1050633.54,1057433.67,6800.13,1122021.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','43',946,'7','1',877884.02,883476.41,5592.39,922744.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','43',947,'8','1',841132.29,847617.45,6485.16,1070051.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','43',948,'17','1',813101.17,813101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','43',949,'18','1',871900.65,871900.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','43',950,'19','1',806622.23,806622.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','43',951,'20','1',958581.64,958581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','43',952,'21','1',737111.89,737111.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','43',953,'22','1',976475.36,976475.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','43',954,'23','1',818987.68,818987.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','43',955,'24','1',857179.75,857179.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','43',956,'25','2',719613.64,722970.43,3356.79,2282617.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','43',957,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','43',958,'27','2',408698.30,410484.56,1786.26,1214656.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','43',959,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','43',960,'29','3',230731.53,232147.62,1416.09,778848.40,0.00,0.00,0.00,0.00,0.00),('21','226','4','43',961,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','44',962,'1','1',1250783.88,1250783.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','44',963,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','44',964,'3','1',1674475.37,1676123.98,1648.61,272020.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','44',965,'4','1',1208351.40,1210147.10,1795.70,296290.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','44',966,'5','1',993441.41,994692.01,1250.60,206349.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','44',967,'6','1',1057433.67,1058635.92,1202.25,198371.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','44',968,'7','1',883476.41,888156.33,4679.92,772186.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','44',969,'8','1',847617.45,852052.52,4435.07,731786.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','44',970,'17','1',813101.17,816057.40,2956.23,487777.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','44',971,'18','1',871900.65,874097.17,2196.52,362425.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','44',972,'19','1',806622.23,809879.86,3257.63,537508.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','44',973,'20','1',958581.64,961832.02,3250.38,536312.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','44',974,'21','1',737111.89,739471.70,2359.81,389368.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','44',975,'22','1',976475.36,979696.62,3221.26,531507.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','44',976,'23','1',818987.68,821833.70,2846.02,469593.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','44',977,'24','1',857179.75,860414.48,3234.73,533730.45,0.00,0.00,0.00,0.00,0.00),('21','226','3','44',978,'25','2',722970.43,726706.06,3735.63,2540228.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','44',979,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','44',980,'27','2',410484.56,411460.48,975.92,663625.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','44',981,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','44',982,'29','3',232147.62,234458.08,2310.46,1270753.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','44',983,'30','3',91032.39,91032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','45',984,'1','1',1250783.88,1250784.00,0.12,19.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','45',985,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','45',986,'3','1',1676123.98,1680993.21,4869.23,803422.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','45',987,'4','1',1210147.10,1213212.85,3065.75,505848.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','45',988,'5','1',994692.01,998623.58,3931.57,648709.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','45',989,'6','1',1058635.92,1062138.07,3502.15,577854.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','45',990,'7','1',888156.33,891526.50,3370.17,556078.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','45',991,'8','1',852052.52,855191.30,3138.78,517898.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','45',992,'17','1',816057.40,818619.07,2561.67,422675.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','45',993,'18','1',874097.17,876329.61,2232.44,368352.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','45',994,'19','1',809879.86,812006.72,2126.86,350931.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','45',995,'20','1',961832.02,963557.79,1725.77,284752.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','45',996,'21','1',739471.70,741339.82,1868.12,308239.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','45',997,'22','1',979696.62,982267.11,2570.49,424130.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','45',998,'23','1',821833.70,823929.11,2095.41,345742.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','45',999,'24','1',860414.48,862730.56,2316.08,382153.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','45',1000,'25','2',726706.06,730017.97,3311.91,2252098.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','45',1001,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','45',1002,'27','2',411460.48,412618.97,1158.49,787773.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','45',1003,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','45',1004,'29','3',234458.08,244815.36,10357.28,5696502.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','45',1005,'30','3',91032.39,91132.87,100.48,55264.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','46',1006,'1','1',1250784.00,1250784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','46',1007,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','46',1008,'3','1',1680993.21,1686167.33,5174.12,853729.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','46',1009,'4','1',1213212.85,1217106.52,3893.67,642455.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','46',1010,'5','1',998623.58,1002543.06,3919.48,646714.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','46',1011,'6','1',1062138.07,1065599.16,3461.09,571079.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','46',1012,'7','1',891526.50,895506.92,3980.42,656769.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','46',1013,'8','1',855191.30,858037.29,2845.99,469588.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','46',1014,'17','1',818619.07,822190.04,3570.97,589210.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','46',1015,'18','1',876329.61,879899.61,3570.00,589050.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','46',1016,'19','1',812006.72,814027.53,2020.81,333433.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','46',1017,'20','1',963557.79,965620.83,2063.04,340401.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','46',1018,'21','1',741339.82,743149.04,1809.22,298521.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','46',1019,'22','1',982267.11,984891.64,2624.53,433047.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','46',1020,'23','1',823929.11,826258.17,2329.06,384294.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','46',1021,'24','1',862730.56,865251.71,2521.15,415989.75,0.00,0.00,0.00,0.00,0.00),('21','226','3','46',1022,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','46',1023,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','46',1024,'27','2',412618.97,412618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','46',1025,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','46',1026,'29','3',244815.36,245174.63,359.27,197595.75,0.00,0.00,0.00,0.00,0.00),('21','226','4','46',1027,'30','3',91132.87,91132.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','47',1028,'1','1',1250784.00,1250784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','47',1029,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','47',1030,'3','1',1686167.33,1692180.05,5972.72,985498.80,0.00,0.00,40.00,0.00,0.00),('21','226','1','47',1031,'4','1',1217106.52,1222381.63,5275.11,870393.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','47',1032,'5','1',1002543.06,1006010.32,3467.26,572097.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','47',1033,'6','1',1065599.16,1068593.30,2994.14,494033.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','47',1034,'7','1',895506.92,899810.52,4303.60,710094.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','47',1035,'8','1',858037.29,862880.19,4842.90,799078.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','47',1036,'17','1',822190.04,823389.30,1199.26,197877.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','47',1037,'18','1',879899.61,881475.67,1576.06,260049.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','47',1038,'19','1',814027.53,815576.65,1549.12,255604.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','47',1039,'20','1',965620.83,967217.25,1596.42,263409.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','47',1040,'21','1',743149.04,744461.90,1312.86,216621.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','47',1041,'22','1',984891.64,986551.05,1659.41,273802.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','47',1042,'23','1',826258.17,828337.24,2079.07,343046.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','47',1043,'24','1',865251.71,867742.40,2490.69,410963.85,0.00,0.00,0.00,0.00,0.00),('21','226','3','47',1044,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','47',1045,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','47',1046,'27','2',412618.97,412807.66,188.69,128309.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','47',1047,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','47',1048,'29','3',245174.63,245870.41,695.78,382677.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','47',1049,'30','3',91132.87,91132.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','48',1050,'1','1',1250784.00,1250784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','48',1051,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','48',1052,'3','1',1692180.05,1696079.33,3899.28,643381.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','48',1053,'4','1',1222381.63,1225249.16,2867.53,473142.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','48',1054,'5','1',1006010.32,1009254.57,3244.25,535301.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','48',1055,'6','1',1068593.30,1071753.57,3160.27,521444.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','48',1056,'7','1',899810.52,901585.23,1774.71,292827.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','48',1057,'8','1',862880.19,864786.66,1906.47,314567.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','48',1058,'17','1',823389.30,825222.70,1833.40,302511.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','48',1059,'18','1',881475.67,882986.87,1511.20,249348.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','48',1060,'19','1',815576.65,817371.53,1794.88,296155.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','48',1061,'20','1',967217.25,969052.59,1835.34,302831.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','48',1062,'21','1',744461.90,745917.47,1455.57,240169.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','48',1063,'22','1',986551.05,988037.19,1486.14,245213.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','48',1064,'23','1',828337.24,830125.24,1788.00,295020.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','48',1065,'24','1',867742.40,869480.18,1737.78,286733.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','48',1066,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','48',1067,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','48',1068,'27','2',412807.66,412807.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','48',1069,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','48',1070,'29','3',245870.41,246219.72,349.30,192117.75,0.00,0.00,0.00,0.00,0.00),('21','226','4','48',1071,'30','3',91132.87,91132.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','49',1072,'1','1',1250784.00,1250784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','49',1073,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','49',1074,'3','1',1696079.33,1696120.52,41.19,6796.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','49',1075,'4','1',1225249.16,1225306.07,56.91,9390.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','49',1076,'5','1',1009254.57,1009254.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','49',1077,'6','1',1071753.57,1071753.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','49',1078,'7','1',901585.23,901585.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','49',1079,'8','1',864786.66,864786.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','49',1080,'17','1',825222.70,827572.66,2349.96,387743.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','49',1081,'18','1',882986.87,884553.15,1566.28,258436.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','49',1082,'19','1',817371.53,820378.33,3006.80,496122.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','49',1083,'20','1',969052.59,971673.03,2620.44,432372.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','49',1084,'21','1',745917.47,748128.21,2210.74,364772.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','49',1085,'22','1',988037.19,990352.92,2315.73,382095.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','49',1086,'23','1',830125.24,831872.59,1747.35,288312.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','49',1087,'24','1',869480.18,870909.60,1429.42,235854.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','49',1088,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','49',1089,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','49',1090,'27','2',412807.66,412952.64,144.98,98586.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','49',1091,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','49',1092,'29','3',246219.72,246480.03,260.31,143169.95,0.00,0.00,0.00,0.00,0.00),('21','226','4','49',1093,'30','3',91132.87,91132.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','50',1094,'1','1',1250784.00,1250784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','50',1095,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','50',1096,'3','1',1696120.52,1696120.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','50',1097,'4','1',1225306.07,1225306.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','50',1098,'5','1',1009254.57,1009254.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','50',1099,'6','1',1071753.57,1071753.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','50',1100,'7','1',901585.23,901585.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','50',1101,'8','1',864786.66,864786.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','50',1102,'17','1',827572.66,827572.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','50',1103,'18','1',884553.15,884553.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','50',1104,'19','1',820378.33,820378.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','50',1105,'20','1',971673.03,971673.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','50',1106,'21','1',748128.21,748128.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','50',1107,'22','1',990352.92,990352.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','50',1108,'23','1',831872.59,831872.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','50',1109,'24','1',870909.60,870909.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','50',1110,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','50',1111,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','50',1112,'27','2',412952.64,412952.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','50',1113,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','50',1114,'29','3',246480.03,250534.34,4054.31,2229871.05,0.00,0.00,0.00,0.00,0.00),('21','226','4','50',1115,'30','3',91132.87,91178.69,45.82,25202.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','51',1116,'1','1',1250784.00,1250784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','51',1117,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','51',1118,'3','1',1696120.52,1700845.19,4724.67,779570.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','51',1119,'4','1',1225306.07,1228807.18,3501.11,577683.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','51',1120,'5','1',1009254.57,1012980.34,3725.77,614752.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','51',1121,'6','1',1071753.57,1074976.07,3222.50,531712.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','51',1122,'7','1',901585.23,904889.75,3304.52,545245.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','51',1123,'8','1',864786.66,867742.79,2956.13,487761.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','51',1124,'17','1',827572.66,830030.38,2457.72,405523.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','51',1125,'18','1',884553.15,886668.61,2115.46,349050.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','51',1126,'19','1',820378.33,822657.91,2279.58,376130.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','51',1127,'20','1',971673.03,973971.57,2298.54,379259.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','51',1128,'21','1',748128.21,750499.78,2371.57,391309.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','51',1129,'22','1',990352.92,992169.25,1816.33,299694.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','51',1130,'23','1',831872.59,833949.82,2077.23,342742.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','51',1131,'24','1',870909.60,873295.52,2385.92,393676.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','51',1132,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','51',1133,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','51',1134,'27','2',412952.64,413057.66,105.02,71413.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','51',1135,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','51',1136,'29','3',250534.34,251113.85,579.51,318731.05,0.00,0.00,0.00,0.00,0.00),('21','226','4','51',1137,'30','3',91178.69,91178.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','52',1138,'1','1',1250784.00,1250784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','52',1139,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','52',1140,'3','1',1700845.19,1705625.73,4780.54,788789.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','52',1141,'4','1',1228807.18,1232484.66,3677.48,606784.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','52',1142,'5','1',1012980.34,1016439.11,3458.77,570697.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','52',1143,'6','1',1074976.07,1078146.30,3170.23,523087.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','52',1144,'7','1',904889.75,907758.36,2868.61,473320.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','52',1145,'8','1',867742.79,870570.74,2827.95,466611.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','52',1146,'17','1',830030.38,831451.02,1420.64,234405.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','52',1147,'18','1',886668.61,888673.02,2004.41,330727.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','52',1148,'19','1',822657.91,825418.77,2760.86,455541.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','52',1149,'20','1',973971.57,976831.23,2859.66,471843.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','52',1150,'21','1',750499.78,752749.98,2250.20,371283.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','52',1151,'22','1',992169.25,994845.06,2675.81,441508.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','52',1152,'23','1',833949.82,836122.67,2172.85,358520.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','52',1153,'24','1',873295.52,876296.28,3000.76,495125.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','52',1154,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','52',1155,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','52',1156,'27','2',413057.66,413057.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','52',1157,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','52',1158,'29','3',251113.85,255552.35,4438.50,2441173.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','52',1159,'30','3',91178.69,91246.23,67.54,37148.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','53',1160,'1','1',1250784.00,1250784.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','53',1161,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','53',1162,'3','1',1705625.73,1712014.53,6388.80,1054152.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','53',1163,'4','1',1232484.66,1236466.89,3982.23,657067.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','53',1164,'5','1',1016439.11,1021004.50,4565.39,753289.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','53',1165,'6','1',1078146.30,1081803.63,3657.33,603459.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','53',1166,'7','1',907758.36,911144.81,3386.45,558764.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','53',1167,'8','1',870570.74,873745.93,3175.19,523906.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','53',1168,'17','1',831451.02,834288.86,2837.84,468243.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','53',1169,'18','1',888673.02,890717.03,2044.01,337261.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','53',1170,'19','1',825418.77,828129.07,2710.30,447199.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','53',1171,'20','1',976831.23,979335.45,2504.22,413196.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','53',1172,'21','1',752749.98,755220.43,2470.45,407624.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','53',1173,'22','1',994845.06,997943.49,3098.43,511240.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','53',1174,'23','1',836122.67,838284.48,2161.81,356698.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','53',1175,'24','1',876296.28,879556.49,3260.21,537934.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','53',1176,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','53',1177,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','53',1178,'27','2',413057.66,413057.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','53',1179,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','53',1180,'29','3',255552.35,258329.64,2777.29,1527511.15,0.00,0.00,0.00,0.00,0.00),('21','226','4','53',1181,'30','3',91246.23,91264.78,18.55,10202.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','54',1182,'1','1',1250784.00,1250784.37,0.37,61.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','54',1183,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','54',1184,'3','1',1712014.53,1718901.76,6887.23,1136392.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','54',1185,'4','1',1236466.89,1241613.21,5146.32,849142.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','54',1186,'5','1',1021004.50,1024594.01,3589.51,592269.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','54',1187,'6','1',1081803.63,1085683.94,3880.31,640251.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','54',1188,'7','1',911144.81,916481.63,5336.82,880575.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','54',1189,'8','1',873745.93,879240.03,5494.10,906526.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','54',1190,'17','1',834288.86,836326.88,2038.02,336273.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','54',1191,'18','1',890717.03,892986.76,2269.73,374505.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','54',1192,'19','1',828129.07,831340.92,3211.85,529955.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','54',1193,'20','1',979335.45,982618.67,3283.22,541731.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','54',1194,'21','1',755220.43,757531.27,2310.84,381288.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','54',1195,'22','1',997943.49,1000487.20,2543.71,419712.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','54',1196,'23','1',838284.48,841802.29,3517.81,580438.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','54',1197,'24','1',879556.49,884229.59,4673.10,771061.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','54',1198,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','54',1199,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','54',1200,'27','2',413057.66,413057.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','54',1201,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','54',1202,'29','3',258329.64,259868.01,1538.37,846104.60,0.00,0.00,0.00,0.00,0.00),('21','226','4','54',1203,'30','3',91264.78,91264.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','55',1204,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','55',1205,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','55',1206,'3','1',1718901.76,1718901.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','55',1207,'4','1',1241613.21,1241613.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','55',1208,'5','1',1024594.01,1024594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','55',1209,'6','1',1085683.94,1085683.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','55',1210,'7','1',916481.63,916481.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','55',1211,'8','1',879240.03,879240.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','55',1212,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','55',1213,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','55',1214,'19','1',831340.92,831340.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','55',1215,'20','1',982618.67,982618.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','55',1216,'21','1',757531.27,757531.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','55',1217,'22','1',1000487.20,1000487.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','55',1218,'23','1',841802.29,841802.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','55',1219,'24','1',884229.59,884229.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','55',1220,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','55',1221,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','55',1222,'27','2',413057.66,413057.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','55',1223,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','55',1224,'29','3',259868.01,260036.80,168.79,109714.80,0.00,0.00,0.00,0.00,0.00),('21','226','4','55',1225,'30','3',91264.78,91264.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','56',1226,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','56',1227,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','56',1228,'3','1',1718901.76,1724860.58,5958.82,983205.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','56',1229,'4','1',1241613.21,1247069.29,5456.08,900253.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','56',1230,'5','1',1024594.01,1024594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','56',1231,'6','1',1085683.94,1085683.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','56',1232,'7','1',916481.63,922398.66,5917.03,976309.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','56',1233,'8','1',879240.03,884611.13,5371.10,886231.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','56',1234,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','56',1235,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','56',1236,'19','1',831340.92,834201.56,2860.64,472005.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','56',1237,'20','1',982618.67,985859.88,3241.21,534799.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','56',1238,'21','1',757531.27,757531.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','56',1239,'22','1',1000487.20,1000487.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','56',1240,'23','1',841802.29,841802.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','56',1241,'24','1',884229.59,884229.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','56',1242,'25','2',730017.97,730017.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','56',1243,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','56',1244,'27','2',413057.66,413057.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','56',1245,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','56',1246,'29','3',260036.80,260162.53,84.71,55064.10,0.00,0.00,41.02,0.00,0.00),('21','226','4','56',1247,'30','3',91264.78,91264.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','57',1248,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','57',1249,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','57',1250,'3','1',1724860.58,1724860.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','57',1251,'4','1',1247069.29,1247069.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','57',1252,'5','1',1024594.01,1024594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','57',1253,'6','1',1085683.94,1085683.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','57',1254,'7','1',922398.66,922398.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','57',1255,'8','1',884611.13,884611.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','57',1256,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','57',1257,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','57',1258,'19','1',834201.56,838333.05,4131.49,681695.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','57',1259,'20','1',985859.88,989241.64,3381.76,557990.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','57',1260,'21','1',757531.27,757531.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','57',1261,'22','1',1000487.20,1000487.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','57',1262,'23','1',841802.29,845101.17,3298.88,544315.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','57',1263,'24','1',884229.59,888114.34,3884.75,640983.75,0.00,0.00,0.00,0.00,0.00),('21','226','3','57',1264,'25','2',730017.97,732461.07,2443.10,1661308.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','57',1265,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','57',1266,'27','2',413057.66,415322.59,2264.93,1540152.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','57',1267,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','57',1268,'29','3',260162.53,260551.89,339.36,220582.05,0.00,0.00,50.00,0.00,0.00),('21','226','4','57',1269,'30','3',91264.78,91264.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','58',1270,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','58',1271,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','58',1272,'3','1',1724860.58,1731665.85,6745.88,1113070.20,0.00,0.00,59.39,0.00,0.00),('21','226','1','58',1273,'4','1',1247069.29,1254365.95,7296.66,1203948.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','58',1274,'5','1',1024594.01,1024594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','58',1275,'6','1',1085683.94,1085683.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','58',1276,'7','1',922398.66,922398.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','58',1277,'8','1',884611.13,884611.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','58',1278,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','58',1279,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','58',1280,'19','1',838333.05,838686.03,352.98,58241.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','58',1281,'20','1',989241.64,989241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','58',1282,'21','1',757531.27,757531.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','58',1283,'22','1',1000487.20,1000487.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','58',1284,'23','1',845101.17,850659.87,5558.70,917185.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','58',1285,'24','1',888114.34,894152.78,6038.44,996342.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','58',1286,'25','2',732461.07,733419.05,957.98,651426.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','58',1287,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','58',1288,'27','2',415322.59,417295.21,1972.62,1341381.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','58',1289,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','58',1290,'29','3',260551.89,261688.56,1136.67,738836.80,0.00,0.00,0.00,0.00,0.00),('21','226','4','58',1291,'30','3',91264.78,91267.09,2.31,1500.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','59',1292,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','59',1293,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','59',1294,'3','1',1731665.85,1731665.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','59',1295,'4','1',1254365.95,1254365.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','59',1296,'5','1',1024594.01,1024594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','59',1297,'6','1',1085683.94,1085683.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','59',1298,'7','1',922398.66,923177.12,778.46,128445.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','59',1299,'8','1',884611.13,884881.21,270.08,44563.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','59',1300,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','59',1301,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','59',1302,'19','1',838686.03,840704.61,2018.58,333065.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','59',1303,'20','1',989241.64,991137.58,1895.94,312830.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','59',1304,'21','1',757531.27,757531.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','59',1305,'22','1',1000487.20,1000487.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','59',1306,'23','1',850659.87,850659.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','59',1307,'24','1',894152.78,894152.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','59',1308,'25','2',733419.05,735586.20,2167.15,1473662.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','59',1309,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','59',1310,'27','2',417295.21,421777.66,4482.45,3048066.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','59',1311,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','59',1312,'29','3',261688.56,261989.11,300.55,195359.45,0.00,0.00,0.00,0.00,0.00),('21','226','4','59',1313,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','60',1314,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','60',1315,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','60',1316,'3','1',1731665.85,1731665.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','60',1317,'4','1',1254365.95,1254365.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','60',1318,'5','1',1024594.01,1024594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','60',1319,'6','1',1085683.94,1085683.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','60',1320,'7','1',923177.12,923177.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','60',1321,'8','1',884881.21,884881.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','60',1322,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','60',1323,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','60',1324,'19','1',840704.61,841341.61,637.00,105105.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','60',1325,'20','1',991137.58,991904.09,766.51,126474.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','60',1326,'21','1',757531.27,757923.56,392.29,64727.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','60',1327,'22','1',1000487.20,1000829.62,342.42,56499.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','60',1328,'23','1',850659.87,850659.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','60',1329,'24','1',894152.78,894152.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','60',1330,'25','2',735586.20,736737.08,1150.88,782598.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','60',1331,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','60',1332,'27','2',421777.66,426117.53,4339.87,2951111.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','60',1333,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','60',1334,'29','3',261989.11,262430.02,440.91,286590.20,0.00,0.00,0.00,0.00,0.00),('21','226','4','60',1335,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','61',1336,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','61',1337,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','61',1338,'3','1',1731665.85,1738921.48,7255.63,1197178.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','61',1339,'4','1',1254365.95,1261044.80,6678.85,1102010.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','61',1340,'5','1',1024594.01,1024594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','61',1341,'6','1',1085683.94,1085683.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','61',1342,'7','1',923177.12,923723.26,546.14,90113.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','61',1343,'8','1',884881.21,885537.59,656.38,108302.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','61',1344,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','61',1345,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','61',1346,'19','1',841341.61,844520.52,3178.91,524520.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','61',1347,'20','1',991904.09,995259.89,3355.80,553707.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','61',1348,'21','1',757923.56,758926.42,1002.86,165471.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','61',1349,'22','1',1000829.62,1001899.94,1070.32,176602.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','61',1350,'23','1',850659.87,850659.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','61',1351,'24','1',894152.78,894152.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','61',1352,'25','2',736737.08,738437.30,1700.22,1156149.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','61',1353,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','61',1354,'27','2',426117.53,429268.86,3151.33,2142904.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','61',1355,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','61',1356,'29','3',262430.02,262769.21,339.19,220474.80,0.00,0.00,0.00,0.00,0.00),('21','226','4','61',1357,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','62',1358,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','62',1359,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','62',1360,'3','1',1738921.48,1738921.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','62',1361,'4','1',1261044.80,1261044.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','62',1362,'5','1',1024594.01,1024594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','62',1363,'6','1',1085683.94,1085683.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','62',1364,'7','1',923723.26,923723.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','62',1365,'8','1',885537.59,885537.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','62',1366,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','62',1367,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','62',1368,'19','1',844520.52,844520.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','62',1369,'20','1',995259.89,995259.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','62',1370,'21','1',758926.42,758926.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','62',1371,'22','1',1001899.94,1001899.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','62',1372,'23','1',850659.87,850659.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','62',1373,'24','1',894152.78,894152.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','62',1374,'25','2',738437.30,738437.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','62',1375,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','62',1376,'27','2',429268.86,429268.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','62',1377,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','62',1378,'29','3',262769.21,262769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','62',1379,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','63',1380,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','63',1381,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','63',1382,'3','1',1738921.48,1738921.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','63',1383,'4','1',1261044.80,1261044.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','63',1384,'5','1',1024594.01,1029356.50,4762.49,785810.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','63',1385,'6','1',1085683.94,1090829.18,5145.24,848964.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','63',1386,'7','1',923723.26,931647.85,7924.59,1307557.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','63',1387,'8','1',885537.59,893610.38,8072.79,1332010.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','63',1388,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','63',1389,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','63',1390,'19','1',844520.52,844639.02,118.50,19552.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','63',1391,'20','1',995259.89,995332.58,72.69,11993.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','63',1392,'21','1',758926.42,758926.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','63',1393,'22','1',1001899.94,1001899.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','63',1394,'23','1',850659.87,853707.64,3047.77,502882.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','63',1395,'24','1',894152.78,897291.39,3138.61,517870.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','63',1396,'25','2',738437.30,738437.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','63',1397,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','63',1398,'27','2',429268.86,429805.92,537.06,365200.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','63',1399,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','63',1400,'29','3',262769.21,263054.77,285.56,185612.70,0.00,0.00,0.00,0.00,0.00),('21','226','4','63',1401,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','64',1402,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','64',1403,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','64',1404,'3','1',1738921.48,1738921.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','64',1405,'4','1',1261044.80,1261044.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','64',1406,'5','1',1029356.50,1029356.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','64',1407,'6','1',1090829.18,1090829.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','64',1408,'7','1',931647.85,931647.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','64',1409,'8','1',893610.38,893610.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','64',1410,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','64',1411,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','64',1412,'19','1',844639.02,844639.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','64',1413,'20','1',995332.58,995332.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','64',1414,'21','1',758926.42,758926.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','64',1415,'22','1',1001899.94,1001899.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','64',1416,'23','1',853707.64,853707.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','64',1417,'24','1',897291.39,897291.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','64',1418,'25','2',738437.30,738437.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','64',1419,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','64',1420,'27','2',429805.92,429805.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','64',1421,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','64',1422,'29','3',263054.77,263054.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','64',1423,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','65',1424,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','65',1425,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','65',1426,'3','1',1738921.48,1738921.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','65',1427,'4','1',1261044.80,1261044.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','65',1428,'5','1',1029356.50,1029356.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','65',1429,'6','1',1090829.18,1090829.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','65',1430,'7','1',931647.85,931647.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','65',1431,'8','1',893610.38,893610.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','65',1432,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','65',1433,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','65',1434,'19','1',844639.02,844639.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','65',1435,'20','1',995332.58,995332.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','65',1436,'21','1',758926.42,758926.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','65',1437,'22','1',1001899.94,1001899.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','65',1438,'23','1',853707.64,853707.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','65',1439,'24','1',897291.39,897291.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','65',1440,'25','2',738437.30,738886.24,448.94,323236.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','65',1441,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','65',1442,'27','2',429805.92,431772.10,1966.18,1415649.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','65',1443,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','65',1444,'29','3',263054.77,263054.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','65',1445,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','66',1446,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','66',1447,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','66',1448,'3','1',1738921.48,1744753.70,5832.22,962316.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','66',1449,'4','1',1261044.80,1266594.19,5549.39,915649.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','66',1450,'5','1',1029356.50,1029356.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','66',1451,'6','1',1090829.18,1090829.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','66',1452,'7','1',931647.85,936834.82,5186.97,855850.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','66',1453,'8','1',893610.38,898665.73,5055.35,834132.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','66',1454,'17','1',836326.88,836326.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','66',1455,'18','1',892986.76,892986.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','66',1456,'19','1',844639.02,848262.58,3623.56,597887.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','66',1457,'20','1',995332.58,999043.64,3711.06,612324.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','66',1458,'21','1',758926.42,758926.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','66',1459,'22','1',1001899.94,1001899.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','66',1460,'23','1',853707.64,856477.74,2770.10,457066.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','66',1461,'24','1',897291.39,900278.44,2987.05,492863.25,0.00,0.00,0.00,0.00,0.00),('21','226','3','66',1462,'25','2',738886.24,742052.01,3165.77,2279354.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','66',1463,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','66',1464,'27','2',431772.10,432451.94,679.84,489484.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','66',1465,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','66',1466,'29','3',263054.77,263315.22,260.45,169295.10,0.00,0.00,0.00,0.00,0.00),('21','226','4','66',1467,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','67',1468,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','67',1469,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','67',1470,'3','1',1744753.70,1744753.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','67',1471,'4','1',1266594.19,1266594.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','67',1472,'5','1',1029356.50,1029356.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','67',1473,'6','1',1090829.18,1090829.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','67',1474,'7','1',936834.82,936834.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','67',1475,'8','1',898665.73,898665.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','67',1476,'17','1',836326.88,839794.00,3467.12,572074.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','67',1477,'18','1',892986.76,896580.08,3593.32,592897.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','67',1478,'19','1',848262.58,851913.57,3650.99,602413.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','67',1479,'20','1',999043.64,1003284.84,4241.20,699798.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','67',1480,'21','1',758926.42,758926.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','67',1481,'22','1',1001899.94,1001899.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','67',1482,'23','1',856477.74,856477.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','67',1483,'24','1',900278.44,900278.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','67',1484,'25','2',742052.01,742781.67,729.66,525355.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','67',1485,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','67',1486,'27','2',432451.94,436420.93,3968.99,2857672.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','67',1487,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','67',1488,'29','3',263315.22,263765.15,449.93,292455.80,0.00,0.00,0.00,0.00,0.00),('21','226','4','67',1489,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','68',1490,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','68',1491,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','68',1492,'3','1',1744753.70,1750221.28,5447.39,898819.35,0.00,0.00,20.19,0.00,0.00),('21','226','1','68',1493,'4','1',1266594.19,1271328.08,4713.66,777753.90,0.00,0.00,20.23,0.00,0.00),('21','226','1','68',1494,'5','1',1029356.50,1031216.41,1839.69,303548.85,0.00,0.00,20.22,0.00,0.00),('21','226','1','68',1495,'6','1',1090829.18,1092705.05,1855.63,306178.95,0.00,0.00,20.24,0.00,0.00),('21','226','1','68',1496,'7','1',936834.82,941137.85,4282.82,706665.30,0.00,0.00,20.21,0.00,0.00),('21','226','1','68',1497,'8','1',898665.73,903318.90,4632.96,764438.40,0.00,0.00,20.21,0.00,0.00),('21','226','2','68',1498,'17','1',839794.00,840647.43,833.24,137484.60,0.00,0.00,20.19,0.00,0.00),('21','226','2','68',1499,'18','1',896580.08,897347.25,746.95,123246.75,0.00,0.00,20.22,0.00,0.00),('21','226','2','68',1500,'19','1',851913.57,852745.59,811.81,133948.65,0.00,0.00,20.21,0.00,0.00),('21','226','2','68',1501,'20','1',1003284.84,1004189.33,888.09,146534.85,0.00,0.00,16.40,0.00,0.00),('21','226','2','68',1502,'21','1',758926.42,761756.99,2830.57,467044.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','68',1503,'22','1',1001899.94,1004906.90,3006.96,496148.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','68',1504,'23','1',856477.74,859034.20,2556.46,421815.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','68',1505,'24','1',900278.44,903710.45,3432.01,566281.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','68',1506,'25','2',742781.67,745298.86,2517.19,1812376.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','68',1507,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','68',1508,'27','2',436420.93,439789.20,3368.27,2425154.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','68',1509,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','68',1510,'29','3',263765.15,264173.75,408.60,265590.65,0.00,0.00,0.00,0.00,0.00),('21','226','4','68',1511,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','69',1512,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','69',1513,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','69',1514,'3','1',1750221.28,1750221.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','69',1515,'4','1',1271328.08,1271328.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','69',1516,'5','1',1031216.41,1031216.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','69',1517,'6','1',1092705.05,1092715.05,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','69',1518,'7','1',941137.85,945019.41,3881.56,640457.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','69',1519,'8','1',903318.90,906765.12,3446.22,568626.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','69',1520,'17','1',840647.43,846305.35,5657.92,933556.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','69',1521,'18','1',897347.25,902484.42,5137.17,847633.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','69',1522,'19','1',852745.59,857374.19,4628.60,763719.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','69',1523,'20','1',1004189.33,1008579.78,4390.45,724424.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','69',1524,'21','1',761756.99,765937.83,4180.84,689838.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','69',1525,'22','1',1004906.90,1009873.09,4966.19,819421.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','69',1526,'23','1',859034.20,862829.28,3795.08,626188.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','69',1527,'24','1',903710.45,907779.83,4069.38,671447.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','69',1528,'25','2',745298.86,749647.91,4349.05,3131316.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','69',1529,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','69',1530,'27','2',439789.20,440099.00,309.80,223056.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','69',1531,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','69',1532,'29','3',264173.75,264512.05,338.30,219896.95,0.00,0.00,0.00,0.00,0.00),('21','226','4','69',1533,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','70',1534,'1','1',1250784.37,1250784.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','70',1535,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','70',1536,'3','1',1750221.28,1756014.89,5773.38,952607.70,0.00,0.00,20.23,0.00,0.00),('21','226','1','70',1537,'4','1',1271328.08,1276306.23,4957.93,818058.45,0.00,0.00,20.22,0.00,0.00),('21','226','1','70',1538,'5','1',1031216.41,1034718.48,3481.84,574503.60,0.00,0.00,20.23,0.00,0.00),('21','226','1','70',1539,'6','1',1092715.05,1096450.68,3715.39,613039.35,0.00,0.00,20.24,0.00,0.00),('21','226','1','70',1540,'7','1',945019.41,949945.98,4906.36,809549.40,0.00,0.00,20.21,0.00,0.00),('21','226','1','70',1541,'8','1',906765.12,911980.57,5195.24,857214.60,0.00,0.00,20.21,0.00,0.00),('21','226','2','70',1542,'17','1',846305.35,846305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','70',1543,'18','1',902484.42,902484.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','70',1544,'19','1',857374.19,859625.91,2231.48,368194.20,0.00,0.00,20.24,0.00,0.00),('21','226','2','70',1545,'20','1',1008579.78,1011079.74,2479.74,409157.10,0.00,0.00,20.22,0.00,0.00),('21','226','2','70',1546,'21','1',765937.83,765937.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','70',1547,'22','1',1009873.09,1009873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','70',1548,'23','1',862829.28,864065.59,1216.10,200656.50,0.00,0.00,20.21,0.00,0.00),('21','226','2','70',1549,'24','1',907779.83,909819.48,2023.36,333854.40,0.00,0.00,16.29,0.00,0.00),('21','226','3','70',1550,'25','2',749647.91,753241.46,3593.55,2587356.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','70',1551,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','70',1552,'27','2',440099.00,442602.38,2503.38,1802433.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','70',1553,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','70',1554,'29','3',264512.05,264818.10,306.05,198933.15,0.00,0.00,0.00,0.00,0.00),('21','226','4','70',1555,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','71',1556,'1','1',1250784.37,1250784.47,0.10,16.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','71',1557,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','71',1558,'3','1',1756014.89,1761059.20,5044.31,832311.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','71',1559,'4','1',1276306.23,1281212.52,4906.29,809537.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','71',1560,'5','1',1034718.48,1034718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','71',1561,'6','1',1096450.68,1096450.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','71',1562,'7','1',949945.98,953513.79,3567.81,588688.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','71',1563,'8','1',911980.57,915723.90,3743.33,617649.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','71',1564,'17','1',846305.35,846305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','71',1565,'18','1',902484.42,902484.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','71',1566,'19','1',859625.91,859625.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','71',1567,'20','1',1011079.74,1011079.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','71',1568,'21','1',765937.83,765937.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','71',1569,'22','1',1009873.09,1009873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','71',1570,'23','1',864065.59,864065.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','71',1571,'24','1',909819.48,909819.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','71',1572,'25','2',753241.46,754739.38,1497.92,1078502.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','71',1573,'26','2',604948.68,604948.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','71',1574,'27','2',442602.38,443021.35,418.97,301658.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','71',1575,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','71',1576,'29','3',264818.10,265107.42,289.32,188056.05,0.00,0.00,0.00,0.00,0.00),('21','226','4','71',1577,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','72',1578,'1','1',1250784.47,1250784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','72',1579,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','72',1580,'3','1',1761059.20,1768138.51,7079.31,1168086.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','72',1581,'4','1',1281212.52,1287801.56,6589.04,1087191.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','72',1582,'5','1',1034718.48,1039249.17,4530.69,747563.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','72',1583,'6','1',1096450.68,1101042.41,4591.73,757635.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','72',1584,'7','1',953513.79,959186.64,5672.85,936020.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','72',1585,'8','1',915723.90,921479.63,5755.73,949695.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','72',1586,'17','1',846305.35,846305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','72',1587,'18','1',902484.42,902484.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','72',1588,'19','1',859625.91,859625.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','72',1589,'20','1',1011079.74,1011079.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','72',1590,'21','1',765937.83,765937.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','72',1591,'22','1',1009873.09,1009873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','72',1592,'23','1',864065.59,864065.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','72',1593,'24','1',909819.48,909819.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','72',1594,'25','2',754739.38,757479.72,2740.34,1973044.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','72',1595,'26','2',604948.68,604948.82,0.14,100.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','72',1596,'27','2',443021.35,444907.25,1885.90,1357848.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','72',1597,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','72',1598,'29','3',265107.42,265377.70,270.28,175683.30,0.00,0.00,0.00,0.00,0.00),('21','226','4','72',1599,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','73',1600,'1','1',1250784.47,1250784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','73',1601,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','73',1602,'3','1',1768138.51,1768185.48,26.77,4417.05,0.00,0.00,20.20,0.00,0.00),('21','226','1','73',1603,'4','1',1287801.56,1287881.93,59.17,9763.05,0.00,0.00,21.20,0.00,0.00),('21','226','1','73',1604,'5','1',1039249.17,1039327.26,42.94,7085.10,0.00,0.00,35.15,0.00,0.00),('21','226','1','73',1605,'6','1',1101042.41,1101111.23,43.62,7197.30,0.00,0.00,25.20,0.00,0.00),('21','226','1','73',1606,'7','1',959186.64,963344.03,4134.19,682141.35,0.00,0.00,23.20,0.00,0.00),('21','226','1','73',1607,'8','1',921479.63,925539.24,4028.41,664687.65,0.00,0.00,31.20,0.00,0.00),('21','226','2','73',1608,'17','1',846305.35,846305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','73',1609,'18','1',902484.42,902484.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','73',1610,'19','1',859625.91,859625.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','73',1611,'20','1',1011079.74,1011079.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','73',1612,'21','1',765937.83,765937.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','73',1613,'22','1',1009873.09,1009873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','73',1614,'23','1',864065.59,864065.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','73',1615,'24','1',909819.48,909819.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','73',1616,'25','2',757479.72,758227.94,748.22,568647.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','73',1617,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','73',1618,'27','2',444907.25,445360.93,453.68,344796.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','73',1619,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','73',1620,'29','3',265377.70,265663.02,285.32,185456.70,0.00,0.00,0.00,0.00,0.00),('21','226','4','73',1621,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','74',1622,'1','1',1250784.47,1250784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','74',1623,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','74',1624,'3','1',1768185.48,1768185.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','74',1625,'4','1',1287881.93,1287881.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','74',1626,'5','1',1039327.26,1039327.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','74',1627,'6','1',1101111.23,1101111.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','74',1628,'7','1',963344.03,963344.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','74',1629,'8','1',925539.24,925539.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','74',1630,'17','1',846305.35,846305.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','74',1631,'18','1',902484.42,902484.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','74',1632,'19','1',859625.91,859625.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','74',1633,'20','1',1011079.74,1011079.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','74',1634,'21','1',765937.83,765937.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','74',1635,'22','1',1009873.09,1009873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','74',1636,'23','1',864065.59,864065.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','74',1637,'24','1',909819.48,909819.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','74',1638,'25','2',758227.94,758565.39,337.45,256462.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','74',1639,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','74',1640,'27','2',445360.93,446913.55,1552.62,1179991.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','74',1641,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','74',1642,'29','3',265663.02,265663.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','74',1643,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','75',1644,'1','1',1250784.47,1250784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','75',1645,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','75',1646,'3','1',1768185.48,1770509.17,2323.69,383408.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','75',1647,'4','1',1287881.93,1290646.55,2764.62,456162.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','75',1648,'5','1',1039327.26,1039327.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','75',1649,'6','1',1101111.23,1101111.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','75',1650,'7','1',963344.03,963453.28,109.25,18026.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','75',1651,'8','1',925539.24,925581.66,42.42,6999.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','75',1652,'17','1',846305.35,846706.65,401.30,66214.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','75',1653,'18','1',902484.42,902945.10,460.68,76012.53,0.00,0.00,0.00,0.00,0.00),('21','226','2','75',1654,'19','1',859625.91,861865.23,2239.32,369487.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','75',1655,'20','1',1011079.74,1013240.46,2160.72,356518.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','75',1656,'21','1',765937.83,765937.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','75',1657,'22','1',1009873.09,1009873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','75',1658,'23','1',864065.59,866611.83,2546.24,420129.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','75',1659,'24','1',909819.48,912234.75,2415.27,398519.55,0.00,0.00,0.00,0.00,0.00),('21','226','3','75',1660,'25','2',758565.39,760777.73,2212.34,1681378.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','75',1661,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','75',1662,'27','2',446913.55,448598.31,1684.76,1280417.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','75',1663,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','75',1664,'29','3',265663.02,266037.50,374.48,243410.70,0.00,0.00,0.00,0.00,0.00),('21','226','4','75',1665,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','76',1666,'1','1',1250784.47,1250784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','76',1667,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','76',1668,'3','1',1770509.17,1773858.11,3348.94,552575.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','76',1669,'4','1',1290646.55,1293572.02,2925.47,482702.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','76',1670,'5','1',1039327.26,1039327.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','76',1671,'6','1',1101111.23,1101111.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','76',1672,'7','1',963453.28,966301.84,2848.56,470012.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','76',1673,'8','1',925581.66,928643.97,3062.31,505281.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','76',1674,'17','1',846706.65,846706.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','76',1675,'18','1',902945.10,902945.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','76',1676,'19','1',861865.23,866157.80,4292.57,708274.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','76',1677,'20','1',1013240.46,1018464.85,5224.39,862024.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','76',1678,'21','1',765937.83,765937.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','76',1679,'22','1',1009873.09,1009873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','76',1680,'23','1',866611.83,871021.96,4410.13,727671.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','76',1681,'24','1',912234.75,917478.65,5243.90,865243.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','76',1682,'25','2',760777.73,762560.81,1783.08,1355140.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','76',1683,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','76',1684,'27','2',448598.31,449984.65,1386.34,1053618.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','76',1685,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','76',1686,'29','3',266037.50,268039.32,2001.82,1301183.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','76',1687,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','77',1688,'1','1',1250784.47,1250784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','77',1689,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','77',1690,'3','1',1773858.11,1773858.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','77',1691,'4','1',1293572.02,1293572.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','77',1692,'5','1',1039327.26,1039327.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','77',1693,'6','1',1101111.23,1101111.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','77',1694,'7','1',966301.84,966301.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','77',1695,'8','1',928643.97,928643.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','77',1696,'17','1',846706.65,846706.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','77',1697,'18','1',902945.10,902945.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','77',1698,'19','1',866157.80,866157.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','77',1699,'20','1',1018464.85,1018464.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','77',1700,'21','1',765937.83,765937.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','77',1701,'22','1',1009873.09,1009873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','77',1702,'23','1',871021.96,871021.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','77',1703,'24','1',917478.65,917478.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','77',1704,'25','2',762560.81,764916.21,2355.40,1790104.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','77',1705,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','77',1706,'27','2',449984.65,451336.69,1352.04,1027550.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','77',1707,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','77',1708,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','77',1709,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','78',1710,'1','1',1250784.47,1250784.81,0.34,56.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','78',1711,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','78',1712,'3','1',1773858.11,1781181.09,7322.98,1208291.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','78',1713,'4','1',1293572.02,1300788.00,7215.98,1190636.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','78',1714,'5','1',1039327.26,1040266.05,938.79,154900.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','78',1715,'6','1',1101111.23,1102127.13,1015.90,167623.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','78',1716,'7','1',966301.84,973723.81,7421.97,1224625.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','78',1717,'8','1',928643.97,936798.74,8154.77,1345537.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','78',1718,'17','1',846706.65,846822.57,115.92,19126.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','78',1719,'18','1',902945.10,903081.64,136.54,22529.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','78',1720,'19','1',866157.80,870476.12,4318.32,712522.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','78',1721,'20','1',1018464.85,1022541.65,4076.80,672672.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','78',1722,'21','1',765937.83,766070.54,132.71,21897.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','78',1723,'22','1',1009873.09,1010048.61,175.52,28960.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','78',1724,'23','1',871021.96,875333.12,4311.16,711341.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','78',1725,'24','1',917478.65,922100.20,4621.55,762555.75,0.00,0.00,0.00,0.00,0.00),('21','226','3','78',1726,'25','2',764916.21,768648.73,3732.52,2836715.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','78',1727,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','78',1728,'27','2',451336.69,453836.94,2500.25,1900190.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','78',1729,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','78',1730,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','78',1731,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','79',1732,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','79',1733,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','79',1734,'3','1',1781181.09,1781181.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','79',1735,'4','1',1300788.00,1300788.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','79',1736,'5','1',1040266.05,1040266.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','79',1737,'6','1',1102127.13,1102127.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','79',1738,'7','1',973723.81,973723.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','79',1739,'8','1',936798.74,936798.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','79',1740,'17','1',846822.57,847913.53,1090.96,180008.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','79',1741,'18','1',903081.64,904059.41,977.77,161332.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','79',1742,'19','1',870476.12,876192.75,5716.63,943243.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','79',1743,'20','1',1022541.65,1027716.96,5175.31,853926.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','79',1744,'21','1',766070.54,767275.59,1205.05,198833.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','79',1745,'22','1',1010048.61,1011184.85,1136.24,187479.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','79',1746,'23','1',875333.12,881384.04,6050.92,998401.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','79',1747,'24','1',922100.20,928448.60,6348.40,1047486.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','79',1748,'25','2',768648.73,770329.57,1680.84,1277438.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','79',1749,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','79',1750,'27','2',453836.94,455379.52,1542.58,1172360.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','79',1751,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','79',1752,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','79',1753,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','80',1754,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','80',1755,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','80',1756,'3','1',1781181.09,1787820.05,6638.96,1095428.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','80',1757,'4','1',1300788.00,1306599.66,5811.66,958923.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','80',1758,'5','1',1040266.05,1040266.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','80',1759,'6','1',1102127.13,1102127.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','80',1760,'7','1',973723.81,979983.28,6259.47,1032812.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','80',1761,'8','1',936798.74,943404.43,6605.69,1089938.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','80',1762,'17','1',847913.53,847926.36,12.83,2116.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','80',1763,'18','1',904059.41,904059.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','80',1764,'19','1',876192.75,876192.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','80',1765,'20','1',1027716.96,1027716.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','80',1766,'21','1',767275.59,767275.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','80',1767,'22','1',1011184.85,1011184.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','80',1768,'23','1',881384.04,884910.03,3525.99,581788.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','80',1769,'24','1',928448.60,931491.07,3042.47,502007.55,0.00,0.00,0.00,0.00,0.00),('21','226','3','80',1770,'25','2',770329.57,771883.32,1553.75,1180850.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','80',1771,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','80',1772,'27','2',455379.52,456958.40,1578.88,1199948.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','80',1773,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','80',1774,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','80',1775,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','81',1776,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','81',1777,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','81',1778,'3','1',1787820.05,1787820.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','81',1779,'4','1',1306599.66,1306599.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','81',1780,'5','1',1040266.05,1040266.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','81',1781,'6','1',1102127.13,1102127.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','81',1782,'7','1',979983.28,979983.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','81',1783,'8','1',943404.43,943404.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','81',1784,'17','1',847926.36,847926.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','81',1785,'18','1',904059.41,904059.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','81',1786,'19','1',876192.75,876304.71,111.96,18473.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','81',1787,'20','1',1027716.96,1027716.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','81',1788,'21','1',767275.59,768439.50,1163.91,192045.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','81',1789,'22','1',1011184.85,1012537.20,1352.35,223137.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','81',1790,'23','1',884910.03,887914.17,3004.14,495683.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','81',1791,'24','1',931491.07,934752.23,3261.16,538091.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','81',1792,'25','2',771883.32,773632.60,1749.28,1329452.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','81',1793,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','81',1794,'27','2',456958.40,457202.55,244.15,185554.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','81',1795,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','81',1796,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','81',1797,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','82',1798,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','82',1799,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','82',1800,'3','1',1787820.05,1794658.76,6838.71,1128387.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','82',1801,'4','1',1306599.66,1313349.86,6750.20,1113783.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','82',1802,'5','1',1040266.05,1040266.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','82',1803,'6','1',1102127.13,1102127.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','82',1804,'7','1',979983.28,986323.78,6340.50,1046182.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','82',1805,'8','1',943404.43,949520.50,6116.07,1009151.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','82',1806,'17','1',847926.36,847926.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','82',1807,'18','1',904059.41,904059.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','82',1808,'19','1',876304.71,880058.48,3753.77,619372.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','82',1809,'20','1',1027716.96,1031661.66,3944.70,650875.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','82',1810,'21','1',768439.50,768439.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','82',1811,'22','1',1012537.20,1012537.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','82',1812,'23','1',887914.17,891825.20,3911.03,645319.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','82',1813,'24','1',934752.23,938989.55,4237.32,699157.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','82',1814,'25','2',773632.60,775735.21,2102.61,1597983.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','82',1815,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','82',1816,'27','2',457202.55,458692.32,1489.77,1132225.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','82',1817,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','82',1818,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','82',1819,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','83',1820,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','83',1821,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','83',1822,'3','1',1794658.76,1796450.68,1791.92,295666.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','83',1823,'4','1',1313349.86,1315237.03,1887.17,311383.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','83',1824,'5','1',1040266.05,1040266.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','83',1825,'6','1',1102127.13,1102127.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','83',1826,'7','1',986323.78,986452.51,128.73,21240.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','83',1827,'8','1',949520.50,949520.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','83',1828,'17','1',847926.36,850501.53,2575.17,424903.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','83',1829,'18','1',904059.41,906801.64,2742.23,452467.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','83',1830,'19','1',880058.48,886145.46,6086.98,1004351.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','83',1831,'20','1',1031661.66,1037506.49,5844.83,964396.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','83',1832,'21','1',768439.50,772034.53,3595.03,593179.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','83',1833,'22','1',1012537.20,1015764.75,3227.55,532545.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','83',1834,'23','1',891825.20,894953.24,3128.04,516126.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','83',1835,'24','1',938989.55,942300.63,3311.08,546328.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','83',1836,'25','2',775735.21,777182.82,1447.61,1100183.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','83',1837,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','83',1838,'27','2',458692.32,460425.48,1733.16,1317201.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','83',1839,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','83',1840,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','83',1841,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','84',1842,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','84',1843,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','84',1844,'3','1',1796450.68,1801087.43,4636.75,765063.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','84',1845,'4','1',1315237.03,1319617.71,4380.68,722812.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','84',1846,'5','1',1040266.05,1044899.56,4633.51,764529.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','84',1847,'6','1',1102127.13,1107200.33,5073.20,837078.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','84',1848,'7','1',986452.51,989643.17,3190.66,526458.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','84',1849,'8','1',949520.50,952772.27,3251.77,536542.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','84',1850,'17','1',850501.53,850501.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','84',1851,'18','1',906801.64,906801.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','84',1852,'19','1',886145.46,886145.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','84',1853,'20','1',1037506.49,1037506.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','84',1854,'21','1',772034.53,772034.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','84',1855,'22','1',1015764.75,1015764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','84',1856,'23','1',894953.24,894953.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','84',1857,'24','1',942300.63,942300.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','84',1858,'25','2',777182.82,778436.19,1253.37,952561.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','84',1859,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','84',1860,'27','2',460425.48,461722.61,1297.13,985818.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','84',1861,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','84',1862,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','84',1863,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','85',1864,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','85',1865,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','85',1866,'3','1',1801087.43,1801087.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','85',1867,'4','1',1319617.71,1319617.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','85',1868,'5','1',1044899.56,1045856.87,947.11,156273.15,0.00,0.00,10.20,0.00,0.00),('21','226','1','85',1869,'6','1',1107200.33,1108393.99,1183.45,195269.25,0.00,0.00,10.21,0.00,0.00),('21','226','1','85',1870,'7','1',989643.17,991025.45,1362.09,224744.85,0.00,0.00,20.19,0.00,0.00),('21','226','1','85',1871,'8','1',952772.27,954037.57,1245.10,205441.50,0.00,0.00,20.20,0.00,0.00),('21','226','2','85',1872,'17','1',850501.53,850501.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','85',1873,'18','1',906801.64,906801.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','85',1874,'19','1',886145.46,886145.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','85',1875,'20','1',1037506.49,1037506.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','85',1876,'21','1',772034.53,772034.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','85',1877,'22','1',1015764.75,1015764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','85',1878,'23','1',894953.24,894953.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','85',1879,'24','1',942300.63,942300.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','85',1880,'25','2',778436.19,780793.46,2357.27,1791525.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','85',1881,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','85',1882,'27','2',461722.61,463830.92,2108.31,1602315.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','85',1883,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','85',1884,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','85',1885,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','86',1886,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','86',1887,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','86',1888,'3','1',1801087.43,1801087.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','86',1889,'4','1',1319617.71,1319617.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','86',1890,'5','1',1045856.87,1045856.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','86',1891,'6','1',1108393.99,1108393.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','86',1892,'7','1',991025.45,991025.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','86',1893,'8','1',954037.57,954037.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','86',1894,'17','1',850501.53,857304.09,6802.56,1122422.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','86',1895,'18','1',906801.64,913533.63,6731.99,1110778.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','86',1896,'19','1',886145.46,892895.57,6750.11,1113768.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','86',1897,'20','1',1037506.49,1044931.67,7425.18,1225154.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','86',1898,'21','1',772034.53,772034.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','86',1899,'22','1',1015764.75,1015764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','86',1900,'23','1',894953.24,894953.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','86',1901,'24','1',942300.63,942300.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','86',1902,'25','2',780793.46,782583.80,1790.34,1360658.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','86',1903,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','86',1904,'27','2',463830.92,467269.47,3438.55,2613298.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','86',1905,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','86',1906,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','86',1907,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','87',1908,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','87',1909,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','87',1910,'3','1',1801087.43,1801087.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','87',1911,'4','1',1319617.71,1319617.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','87',1912,'5','1',1045856.87,1045856.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','87',1913,'6','1',1108393.99,1108393.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','87',1914,'7','1',991025.45,991025.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','87',1915,'8','1',954037.57,954037.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','87',1916,'17','1',857304.09,857304.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','87',1917,'18','1',913533.63,913533.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','87',1918,'19','1',892895.57,892895.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','87',1919,'20','1',1044931.67,1044931.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','87',1920,'21','1',772034.53,772034.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','87',1921,'22','1',1015764.75,1015764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','87',1922,'23','1',894953.24,894953.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','87',1923,'24','1',942300.63,942300.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','87',1924,'25','2',782583.80,783015.93,432.13,328418.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','87',1925,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','87',1926,'27','2',467269.47,467715.15,445.68,338716.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','87',1927,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','87',1928,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','87',1929,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','88',1930,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','88',1931,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','88',1932,'3','1',1801087.43,1801087.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','88',1933,'4','1',1319617.71,1319617.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','88',1934,'5','1',1045856.87,1053439.67,7582.80,1251162.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','88',1935,'6','1',1108393.99,1116793.59,8399.60,1385934.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','88',1936,'7','1',991025.45,998271.84,7246.39,1195654.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','88',1937,'8','1',954037.57,960947.56,6909.99,1140148.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','88',1938,'17','1',857304.09,857304.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','88',1939,'18','1',913533.63,913533.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','88',1940,'19','1',892895.57,892945.86,50.29,8297.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','88',1941,'20','1',1044931.67,1044931.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','88',1942,'21','1',772034.53,772034.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','88',1943,'22','1',1015764.75,1015764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','88',1944,'23','1',894953.24,895829.85,876.61,144640.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','88',1945,'24','1',942300.63,942977.38,676.75,111663.75,0.00,0.00,0.00,0.00,0.00),('21','226','3','88',1946,'25','2',783015.93,784233.07,1217.14,937197.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','88',1947,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','88',1948,'27','2',467715.15,472219.99,4504.84,3468726.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','88',1949,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','88',1950,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','88',1951,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','89',1952,'1','1',1250784.81,1250784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','89',1953,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','89',1954,'3','1',1801087.43,1801087.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','89',1955,'4','1',1319617.71,1319617.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','89',1956,'5','1',1053439.67,1053439.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','89',1957,'6','1',1116793.59,1116793.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','89',1958,'7','1',998271.84,998271.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','89',1959,'8','1',960947.56,960947.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','89',1960,'17','1',857304.09,857304.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','89',1961,'18','1',913533.63,913533.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','89',1962,'19','1',892945.86,892945.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','89',1963,'20','1',1044931.67,1044931.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','89',1964,'21','1',772034.53,772034.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','89',1965,'22','1',1015764.75,1015764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','89',1966,'23','1',895829.85,895829.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','89',1967,'24','1',942977.38,942977.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','89',1968,'25','2',784233.07,784504.28,271.21,208831.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','89',1969,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','89',1970,'27','2',472219.99,473042.40,822.41,633255.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','89',1971,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','89',1972,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','89',1973,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','90',1974,'1','1',1250784.81,1250785.00,0.19,31.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','90',1975,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','90',1976,'3','1',1801087.43,1804513.44,3426.01,565291.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','90',1977,'4','1',1319617.71,1323273.92,3656.21,603274.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','90',1978,'5','1',1053439.67,1053980.21,540.54,89189.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','90',1979,'6','1',1116793.59,1117355.26,561.67,92675.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','90',1980,'7','1',998271.84,1001761.66,3489.82,575820.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','90',1981,'8','1',960947.56,964204.57,3257.01,537406.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','90',1982,'17','1',857304.09,861129.16,3825.07,631136.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','90',1983,'18','1',913533.63,917483.43,3949.80,651717.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','90',1984,'19','1',892945.86,894749.80,1803.94,297650.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','90',1985,'20','1',1044931.67,1047002.71,2071.04,341721.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','90',1986,'21','1',772034.53,772034.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','90',1987,'22','1',1015764.75,1015764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','90',1988,'23','1',895829.85,897263.76,1433.91,236595.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','90',1989,'24','1',942977.38,944811.50,1834.12,302629.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','90',1990,'25','2',784504.28,786702.97,2198.69,1692991.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','90',1991,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','90',1992,'27','2',473042.40,474790.96,1748.56,1346391.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','90',1993,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','90',1994,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','90',1995,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','91',1996,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','91',1997,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','91',1998,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','91',1999,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','91',2000,'5','1',1053980.21,1061181.79,7201.58,1188260.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','91',2001,'6','1',1117355.26,1125178.70,7823.44,1290867.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','91',2002,'7','1',1001761.66,1009142.67,7381.01,1217866.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','91',2003,'8','1',964204.57,971836.10,7631.53,1259202.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','91',2004,'17','1',861129.16,861129.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','91',2005,'18','1',917483.43,917483.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','91',2006,'19','1',894749.80,894749.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','91',2007,'20','1',1047002.71,1047002.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','91',2008,'21','1',772034.53,772034.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','91',2009,'22','1',1015764.75,1015764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','91',2010,'23','1',897263.76,897263.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','91',2011,'24','1',944811.50,944811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','91',2012,'25','2',786702.97,788781.99,2079.02,1621635.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','91',2013,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','91',2014,'27','2',474790.96,477030.10,2239.14,1746529.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','91',2015,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','91',2016,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','91',2017,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','92',2018,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','92',2019,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','92',2020,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','92',2021,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','92',2022,'5','1',1061181.79,1061181.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','92',2023,'6','1',1125178.70,1125178.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','92',2024,'7','1',1009142.67,1009142.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','92',2025,'8','1',971836.10,971836.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','92',2026,'17','1',861129.16,868123.08,6993.92,1153996.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','92',2027,'18','1',917483.43,925636.74,8153.31,1345296.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','92',2028,'19','1',894749.80,901034.41,6264.23,1033597.95,0.00,0.00,20.38,0.00,0.00),('21','226','2','92',2029,'20','1',1047002.71,1053977.59,6974.88,1150855.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','92',2030,'21','1',772034.53,772224.87,190.34,31406.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','92',2031,'22','1',1015764.75,1015913.37,148.62,24522.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','92',2032,'23','1',897263.76,897479.83,216.07,35651.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','92',2033,'24','1',944811.50,945006.36,194.86,32151.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','92',2034,'25','2',788781.99,790160.04,1378.05,1074879.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','92',2035,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','92',2036,'27','2',477030.10,477692.87,662.77,516960.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','92',2037,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','92',2038,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','92',2039,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','93',2040,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','93',2041,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','93',2042,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','93',2043,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','93',2044,'5','1',1061181.79,1068528.63,7346.84,1212228.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','93',2045,'6','1',1125178.70,1132603.10,7424.40,1225026.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','93',2046,'7','1',1009142.67,1016932.19,7789.52,1285270.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','93',2047,'8','1',971836.10,979272.80,7436.70,1227055.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','93',2048,'17','1',868123.08,868123.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','93',2049,'18','1',925636.74,925636.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','93',2050,'19','1',901034.41,901280.95,246.54,40679.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','93',2051,'20','1',1053977.59,1053977.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','93',2052,'21','1',772224.87,772348.54,123.67,20405.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','93',2053,'22','1',1015913.37,1016082.69,169.32,27937.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','93',2054,'23','1',897479.83,897702.18,222.35,36687.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','93',2055,'24','1',945006.36,945248.43,242.07,39941.55,0.00,0.00,0.00,0.00,0.00),('21','226','3','93',2056,'25','2',790160.04,791921.99,1761.95,1374321.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','93',2057,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','93',2058,'27','2',477692.87,478253.85,560.98,437564.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','93',2059,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','93',2060,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','93',2061,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','94',2062,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','94',2063,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','94',2064,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','94',2065,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','94',2066,'5','1',1068528.63,1068528.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','94',2067,'6','1',1132603.10,1132603.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','94',2068,'7','1',1016932.19,1016932.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','94',2069,'8','1',979272.80,979272.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','94',2070,'17','1',868123.08,868123.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','94',2071,'18','1',925636.74,925636.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','94',2072,'19','1',901280.95,901280.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','94',2073,'20','1',1053977.59,1053977.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','94',2074,'21','1',772348.54,772348.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','94',2075,'22','1',1016082.69,1016082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','94',2076,'23','1',897702.18,897702.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','94',2077,'24','1',945248.43,945248.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','94',2078,'25','2',791921.99,793058.95,1136.96,909568.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','94',2079,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','94',2080,'27','2',478253.85,478706.84,452.99,362392.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','94',2081,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','94',2082,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','94',2083,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','95',2084,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','95',2085,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','95',2086,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','95',2087,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','95',2088,'5','1',1068528.63,1076137.47,7608.84,1255458.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','95',2089,'6','1',1132603.10,1140149.98,7546.88,1245235.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','95',2090,'7','1',1016932.19,1024504.14,7571.95,1249371.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','95',2091,'8','1',979272.80,986678.18,7405.38,1221887.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','95',2092,'17','1',868123.08,868123.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','95',2093,'18','1',925636.74,925636.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','95',2094,'19','1',901280.95,901280.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','95',2095,'20','1',1053977.59,1053977.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','95',2096,'21','1',772348.54,772348.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','95',2097,'22','1',1016082.69,1016082.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','95',2098,'23','1',897702.18,897702.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','95',2099,'24','1',945248.43,945248.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','95',2100,'25','2',793058.95,795123.93,2064.98,1651984.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','95',2101,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','95',2102,'27','2',478706.84,480548.73,1841.89,1473512.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','95',2103,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','95',2104,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','95',2105,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','96',2106,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','96',2107,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','96',2108,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','96',2109,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','96',2110,'5','1',1076137.47,1076137.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','96',2111,'6','1',1140149.98,1140149.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','96',2112,'7','1',1024504.14,1024504.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','96',2113,'8','1',986678.18,986678.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','96',2114,'17','1',868123.08,869247.50,1124.42,185529.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','96',2115,'18','1',925636.74,926913.55,1276.81,210673.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','96',2116,'19','1',901280.95,907869.76,6588.81,1087153.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','96',2117,'20','1',1053977.59,1060481.88,6504.29,1073207.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','96',2118,'21','1',772348.54,777302.85,4954.31,817461.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','96',2119,'22','1',1016082.69,1021646.08,5563.39,917959.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','96',2120,'23','1',897702.18,898128.36,426.18,70319.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','96',2121,'24','1',945248.43,945897.32,648.89,107066.85,0.00,0.00,0.00,0.00,0.00),('21','226','3','96',2122,'25','2',795123.93,795922.68,798.75,639000.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','96',2123,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','96',2124,'27','2',480548.73,482517.29,1968.56,1574848.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','96',2125,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','96',2126,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','96',2127,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','97',2128,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','97',2129,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','97',2130,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','97',2131,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','97',2132,'5','1',1076137.47,1076137.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','97',2133,'6','1',1140149.98,1140149.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','97',2134,'7','1',1024504.14,1024504.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','97',2135,'8','1',986678.18,986678.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','97',2136,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','97',2137,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','97',2138,'19','1',907869.76,907869.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','97',2139,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','97',2140,'21','1',777302.85,777302.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','97',2141,'22','1',1021646.08,1021646.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','97',2142,'23','1',898128.36,898128.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','97',2143,'24','1',945897.32,945897.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','97',2144,'25','2',795922.68,797020.05,1097.37,877896.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','97',2145,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','97',2146,'27','2',482517.29,484569.62,2052.33,1641864.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','97',2147,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','97',2148,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','97',2149,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','98',2150,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','98',2151,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','98',2152,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','98',2153,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','98',2154,'5','1',1076137.47,1084093.54,7956.07,1312751.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','98',2155,'6','1',1140149.98,1147868.46,7718.48,1273549.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','98',2156,'7','1',1024504.14,1031835.28,7331.14,1209638.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','98',2157,'8','1',986678.18,993893.68,7215.50,1190557.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','98',2158,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','98',2159,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','98',2160,'19','1',907869.76,907869.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','98',2161,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','98',2162,'21','1',777302.85,777302.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','98',2163,'22','1',1021646.08,1021646.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','98',2164,'23','1',898128.36,898128.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','98',2165,'24','1',945897.32,945897.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','98',2166,'25','2',797020.05,798021.44,1001.39,821139.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','98',2167,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','98',2168,'27','2',484569.62,485100.75,531.13,435526.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','98',2169,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','98',2170,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','98',2171,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','99',2172,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','99',2173,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','99',2174,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','99',2175,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','99',2176,'5','1',1084093.54,1090254.61,6161.07,1016576.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','99',2177,'6','1',1147868.46,1153342.25,5473.79,903175.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','99',2178,'7','1',1031835.28,1032021.75,186.47,30767.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','99',2179,'8','1',993893.68,994183.23,289.55,47775.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','99',2180,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','99',2181,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','99',2182,'19','1',907869.76,907869.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','99',2183,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','99',2184,'21','1',777302.85,778476.02,1173.17,193573.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','99',2185,'22','1',1021646.08,1022913.42,1267.34,209111.10,0.00,0.00,0.00,0.00,0.00),('21','226','2','99',2186,'23','1',898128.36,904593.26,6464.90,1066708.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','99',2187,'24','1',945897.32,952384.99,6487.67,1070465.55,0.00,0.00,0.00,0.00,0.00),('21','226','3','99',2188,'25','2',798021.44,801285.74,3264.30,2676726.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','99',2189,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','99',2190,'27','2',485100.75,486804.38,1703.63,1396976.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','99',2191,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','99',2192,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','99',2193,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','100',2194,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','100',2195,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','100',2196,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','100',2197,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','100',2198,'5','1',1090254.61,1090254.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','100',2199,'6','1',1153342.25,1153342.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','100',2200,'7','1',1032021.75,1039966.16,7944.41,1310827.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','100',2201,'8','1',994183.23,1002032.84,7849.61,1295185.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','100',2202,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','100',2203,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','100',2204,'19','1',907869.76,907869.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','100',2205,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','100',2206,'21','1',778476.02,784199.77,5723.75,944418.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','100',2207,'22','1',1022913.42,1029212.43,6299.01,1039336.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','100',2208,'23','1',904593.26,904593.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','100',2209,'24','1',952384.99,952384.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','100',2210,'25','2',801285.74,803450.43,2164.69,1775045.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','100',2211,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','100',2212,'27','2',486804.38,489800.19,2995.81,2456564.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','100',2213,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','100',2214,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','100',2215,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','101',2216,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','101',2217,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','101',2218,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','101',2219,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','101',2220,'5','1',1090254.61,1090254.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','101',2221,'6','1',1153342.25,1153342.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','101',2222,'7','1',1039966.16,1039966.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','101',2223,'8','1',1002032.84,1002032.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','101',2224,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','101',2225,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','101',2226,'19','1',907869.76,907869.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','101',2227,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','101',2228,'21','1',784199.77,784199.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','101',2229,'22','1',1029212.43,1029212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','101',2230,'23','1',904593.26,904593.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','101',2231,'24','1',952384.99,952384.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','101',2232,'25','2',803450.43,805038.35,1587.92,1302094.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','101',2233,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','101',2234,'27','2',489800.19,492434.39,2634.20,2160044.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','101',2235,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','101',2236,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','101',2237,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','102',2238,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','102',2239,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','102',2240,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','102',2241,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','102',2242,'5','1',1090254.61,1090254.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','102',2243,'6','1',1153342.25,1153342.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','102',2244,'7','1',1039966.16,1039966.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','102',2245,'8','1',1002032.84,1002032.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','102',2246,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','102',2247,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','102',2248,'19','1',907869.76,907869.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','102',2249,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','102',2250,'21','1',784199.77,784199.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','102',2251,'22','1',1029212.43,1029212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','102',2252,'23','1',904593.26,904593.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','102',2253,'24','1',952384.99,952384.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','102',2254,'25','2',805038.35,807222.98,2184.63,1791396.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','102',2255,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','102',2256,'27','2',492434.39,494031.35,1596.96,1309507.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','102',2257,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','102',2258,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','102',2259,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','103',2260,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','103',2261,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','103',2262,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','103',2263,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','103',2264,'5','1',1090254.61,1098408.37,8153.76,1345370.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','103',2265,'6','1',1153342.25,1161150.85,7808.60,1288419.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','103',2266,'7','1',1039966.16,1048384.81,8418.65,1389077.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','103',2267,'8','1',1002032.84,1009929.72,7896.88,1302985.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','103',2268,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','103',2269,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','103',2270,'19','1',907869.76,907869.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','103',2271,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','103',2272,'21','1',784199.77,784199.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','103',2273,'22','1',1029212.43,1029212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','103',2274,'23','1',904593.26,904593.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','103',2275,'24','1',952384.99,952384.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','103',2276,'25','2',807222.98,808069.78,846.80,702844.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','103',2277,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','103',2278,'27','2',494031.35,495293.83,1262.48,1047858.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','103',2279,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','103',2280,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','103',2281,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','104',2282,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','104',2283,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','104',2284,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','104',2285,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','104',2286,'5','1',1098408.37,1105161.35,6752.98,1114241.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','104',2287,'6','1',1161150.85,1167949.77,6798.92,1121821.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','104',2288,'7','1',1048384.81,1054970.18,6585.37,1086586.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','104',2289,'8','1',1009929.72,1015802.00,5872.28,968926.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','104',2290,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','104',2291,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','104',2292,'19','1',907869.76,907869.95,0.19,31.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','104',2293,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','104',2294,'21','1',784199.77,784199.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','104',2295,'22','1',1029212.43,1029212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','104',2296,'23','1',904593.26,911565.06,6971.80,1150347.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','104',2297,'24','1',952384.99,959548.58,7163.59,1181992.35,0.00,0.00,0.00,0.00,0.00),('21','226','3','104',2298,'25','2',808069.78,809201.65,1131.87,939452.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','104',2299,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','104',2300,'27','2',495293.83,496320.32,1026.49,851986.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','104',2301,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','104',2302,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','104',2303,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','105',2304,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','105',2305,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','105',2306,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','105',2307,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','105',2308,'5','1',1105161.35,1108935.13,3773.78,622673.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','105',2309,'6','1',1167949.77,1171612.47,3662.70,604345.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','105',2310,'7','1',1054970.18,1058788.97,3818.79,630100.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','105',2311,'8','1',1015802.00,1019546.59,3744.59,617857.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','105',2312,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','105',2313,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','105',2314,'19','1',907869.95,907869.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','105',2315,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','105',2316,'21','1',784199.77,787336.23,3136.46,517515.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','105',2317,'22','1',1029212.43,1032262.09,3049.66,503193.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','105',2318,'23','1',911565.06,914853.76,3288.70,542635.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','105',2319,'24','1',959548.58,963115.39,3566.81,588523.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','105',2320,'25','2',809201.65,809896.81,695.16,576982.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','105',2321,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','105',2322,'27','2',496320.32,498344.36,2024.04,1679953.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','105',2323,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','105',2324,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','105',2325,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','106',2326,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','106',2327,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','106',2328,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','106',2329,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','106',2330,'5','1',1108935.13,1108935.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','106',2331,'6','1',1171612.47,1171612.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','106',2332,'7','1',1058788.97,1058788.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','106',2333,'8','1',1019546.59,1019546.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','106',2334,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','106',2335,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','106',2336,'19','1',907869.95,907869.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','106',2337,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','106',2338,'21','1',787336.23,787336.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','106',2339,'22','1',1032262.09,1032262.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','106',2340,'23','1',914853.76,914853.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','106',2341,'24','1',963115.39,963115.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','106',2342,'25','2',809896.81,810172.60,275.79,228905.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','106',2343,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','106',2344,'27','2',498344.36,500860.74,2516.38,2088595.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','106',2345,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','106',2346,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','106',2347,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','107',2348,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','107',2349,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','107',2350,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','107',2351,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','107',2352,'5','1',1108935.13,1108935.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','107',2353,'6','1',1171612.47,1171612.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','107',2354,'7','1',1058788.97,1058788.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','107',2355,'8','1',1019546.59,1019546.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','107',2356,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','107',2357,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','107',2358,'19','1',907869.95,907869.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','107',2359,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','107',2360,'21','1',787336.23,787336.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','107',2361,'22','1',1032262.09,1032262.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','107',2362,'23','1',914853.76,914853.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','107',2363,'24','1',963115.39,963115.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','107',2364,'25','2',810172.60,811024.35,851.75,706952.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','107',2365,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','107',2366,'27','2',500860.74,501245.19,384.45,319093.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','107',2367,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','107',2368,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','107',2369,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','108',2370,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','108',2371,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','108',2372,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','108',2373,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','108',2374,'5','1',1108935.13,1113000.01,4064.88,670705.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','108',2375,'6','1',1171612.47,1175521.41,3908.94,644975.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','108',2376,'7','1',1058788.97,1062599.41,3810.44,628722.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','108',2377,'8','1',1019546.59,1023246.82,3700.23,610537.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','108',2378,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','108',2379,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','108',2380,'19','1',907869.95,907953.18,83.23,13732.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','108',2381,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','108',2382,'21','1',787336.23,790291.47,2955.24,487614.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','108',2383,'22','1',1032262.09,1035326.07,3063.98,505556.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','108',2384,'23','1',914853.76,917943.19,3089.43,509755.95,0.00,0.00,0.00,0.00,0.00),('21','226','2','108',2385,'24','1',963115.39,966278.62,3163.23,521932.95,0.00,0.00,0.00,0.00,0.00),('21','226','3','108',2386,'25','2',811024.35,811253.84,229.49,190476.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','108',2387,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','108',2388,'27','2',501245.19,501793.73,548.54,455288.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','108',2389,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','108',2390,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','108',2391,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','109',2392,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','109',2393,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','109',2394,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','109',2395,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','109',2396,'5','1',1113000.01,1113000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','109',2397,'6','1',1175521.41,1175521.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','109',2398,'7','1',1062599.41,1062599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','109',2399,'8','1',1023246.82,1023246.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','109',2400,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','109',2401,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','109',2402,'19','1',907953.18,907953.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','109',2403,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','109',2404,'21','1',790291.47,790292.68,1.21,199.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','109',2405,'22','1',1035326.07,1035326.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','109',2406,'23','1',917943.19,918150.39,207.20,34188.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','109',2407,'24','1',966278.62,966479.91,201.29,33212.85,0.00,0.00,0.00,0.00,0.00),('21','226','3','109',2408,'25','2',811253.84,813731.13,2477.29,2056150.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','109',2409,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','109',2410,'27','2',501793.73,503315.23,1521.50,1262845.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','109',2411,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','109',2412,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','109',2413,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','110',2414,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','110',2415,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','110',2416,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','110',2417,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','110',2418,'5','1',1113000.01,1113000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','110',2419,'6','1',1175521.41,1175521.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','110',2420,'7','1',1062599.41,1062599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','110',2421,'8','1',1023246.82,1023246.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','110',2422,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','110',2423,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','110',2424,'19','1',907953.18,907953.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','110',2425,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','110',2426,'21','1',790292.68,790397.36,104.68,17272.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','110',2427,'22','1',1035326.07,1035422.86,96.79,15970.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','110',2428,'23','1',918150.39,920045.40,1895.01,312676.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','110',2429,'24','1',966479.91,968324.52,1844.61,304360.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','110',2430,'25','2',813731.13,815935.15,2204.02,1829336.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','110',2431,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','110',2432,'27','2',503315.23,507036.80,3721.57,3088903.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','110',2433,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','110',2434,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','110',2435,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','111',2436,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','111',2437,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','111',2438,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','111',2439,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','111',2440,'5','1',1113000.01,1113000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','111',2441,'6','1',1175521.41,1175521.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','111',2442,'7','1',1062599.41,1062599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','111',2443,'8','1',1023246.82,1023246.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','111',2444,'17','1',869247.50,869247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','111',2445,'18','1',926913.55,926913.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','111',2446,'19','1',907953.18,907953.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','111',2447,'20','1',1060481.88,1060481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','111',2448,'21','1',790397.36,790397.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','111',2449,'22','1',1035422.86,1035422.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','111',2450,'23','1',920045.40,920045.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','111',2451,'24','1',968324.52,968324.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','111',2452,'25','2',815935.15,815935.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','111',2453,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','111',2454,'27','2',507036.80,507036.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','111',2455,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','111',2456,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','111',2457,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','112',2458,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','112',2459,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','112',2460,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','112',2461,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','112',2462,'5','1',1113000.01,1116389.58,3389.57,559279.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','112',2463,'6','1',1175521.41,1179125.66,3604.25,594701.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','112',2464,'7','1',1062599.41,1066062.88,3440.07,567611.55,0.00,0.00,23.40,0.00,0.00),('21','226','1','112',2465,'8','1',1023246.82,1026555.05,3283.83,541831.95,0.00,0.00,24.40,0.00,0.00),('21','226','2','112',2466,'17','1',869247.50,871244.81,1916.66,316248.90,0.00,0.00,80.65,0.00,0.00),('21','226','2','112',2467,'18','1',926913.55,928933.21,1952.65,322187.25,0.00,0.00,67.01,0.00,0.00),('21','226','2','112',2468,'19','1',907953.18,910002.94,2043.70,337210.50,0.00,0.00,6.06,0.00,0.00),('21','226','2','112',2469,'20','1',1060481.88,1062678.35,2159.66,356343.90,0.00,0.00,36.81,0.00,0.00),('21','226','2','112',2470,'21','1',790397.36,790397.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','112',2471,'22','1',1035422.86,1035422.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','112',2472,'23','1',920045.40,920082.72,27.11,4473.15,0.00,0.00,10.21,0.00,0.00),('21','226','2','112',2473,'24','1',968324.52,968385.13,18.62,3072.30,0.00,0.00,41.99,0.00,0.00),('21','226','3','112',2474,'25','2',815935.15,816123.34,188.19,156197.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','112',2475,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','112',2476,'27','2',507036.80,508393.54,1356.74,1126094.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','112',2477,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','112',2478,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','112',2479,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','113',2480,'1','1',1250785.00,1250785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','113',2481,'2','1',1062003.41,1062003.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','113',2482,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','113',2483,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','113',2484,'5','1',1116389.58,1120134.15,3744.57,617854.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','113',2485,'6','1',1179125.66,1182910.83,3785.17,624553.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','113',2486,'7','1',1066062.88,1069797.93,3735.05,616283.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','113',2487,'8','1',1026555.05,1030206.25,3651.20,602448.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','113',2488,'17','1',871244.81,872051.63,806.82,133125.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','113',2489,'18','1',928933.21,929752.02,818.81,135103.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','113',2490,'19','1',910002.94,910862.59,859.65,141842.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','113',2491,'20','1',1062678.35,1063663.87,985.52,162610.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','113',2492,'21','1',790397.36,790397.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','113',2493,'22','1',1035422.86,1035422.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','113',2494,'23','1',920082.72,920236.24,153.52,25330.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','113',2495,'24','1',968385.13,968433.71,48.58,8015.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','113',2496,'25','2',816123.34,816818.57,695.23,577040.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','113',2497,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','113',2498,'27','2',508393.54,516160.58,7767.04,6446643.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','113',2499,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','113',2500,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','113',2501,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','114',2502,'1','1',1250785.00,1254573.23,3775.81,623008.65,0.00,0.00,12.42,0.00,0.00),('21','226','1','114',2503,'2','1',1062003.41,1065477.01,3473.60,573144.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','114',2504,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','114',2505,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','114',2506,'5','1',1120134.15,1120134.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','114',2507,'6','1',1182910.83,1182910.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','114',2508,'7','1',1069797.93,1073644.14,3846.21,634624.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','114',2509,'8','1',1030206.25,1034083.49,3877.24,639744.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','114',2510,'17','1',872051.63,874600.12,2548.49,420500.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','114',2511,'18','1',929752.02,932690.30,2938.28,484816.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','114',2512,'19','1',910862.59,913403.89,2541.30,419314.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','114',2513,'20','1',1063663.87,1066582.99,2919.12,481654.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','114',2514,'21','1',790397.36,790397.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','114',2515,'22','1',1035422.86,1035422.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','114',2516,'23','1',920236.24,920236.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','114',2517,'24','1',968433.71,968433.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','114',2518,'25','2',816818.57,817320.78,502.21,416834.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','114',2519,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','114',2520,'27','2',516160.58,518715.49,2554.91,2120575.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','114',2521,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','114',2522,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','114',2523,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','115',2524,'1','1',1254573.23,1258441.60,3868.37,638281.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','115',2525,'2','1',1065477.01,1068816.47,3339.46,551010.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','115',2526,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','115',2527,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','115',2528,'5','1',1120134.15,1120134.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','115',2529,'6','1',1182910.83,1182910.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','115',2530,'7','1',1073644.14,1077443.45,3799.31,626886.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','115',2531,'8','1',1034083.49,1038147.84,4064.35,670617.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','115',2532,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','115',2533,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','115',2534,'19','1',913403.89,913620.91,217.02,35808.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','115',2535,'20','1',1066582.99,1066730.58,147.59,24352.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','115',2536,'21','1',790397.36,792161.63,1764.27,291104.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','115',2537,'22','1',1035422.86,1037438.88,2016.02,332643.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','115',2538,'23','1',920236.24,922103.60,1867.36,308114.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','115',2539,'24','1',968433.71,970376.09,1942.38,320492.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','115',2540,'25','2',817320.78,817724.32,403.54,334938.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','115',2541,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','115',2542,'27','2',518715.49,521340.44,2624.95,2178708.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','115',2543,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','115',2544,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','115',2545,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','116',2546,'1','1',1258441.60,1264951.65,6510.05,1074158.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','116',2547,'2','1',1068816.47,1075597.61,6781.14,1118888.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','116',2548,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','116',2549,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','116',2550,'5','1',1120134.15,1120134.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','116',2551,'6','1',1182910.83,1182910.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','116',2552,'7','1',1077443.45,1084028.21,6584.76,1086485.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','116',2553,'8','1',1038147.84,1044973.34,6825.50,1126207.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','116',2554,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','116',2555,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','116',2556,'19','1',913620.91,913620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','116',2557,'20','1',1066730.58,1066730.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','116',2558,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','116',2559,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','116',2560,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','116',2561,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','116',2562,'25','2',817724.32,818310.65,586.33,486653.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','116',2563,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','116',2564,'27','2',521340.44,524605.61,3265.17,2710091.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','116',2565,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','116',2566,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','116',2567,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','117',2568,'1','1',1264951.65,1264951.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','117',2569,'2','1',1075597.61,1075597.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','117',2570,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','117',2571,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','117',2572,'5','1',1120134.15,1120134.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','117',2573,'6','1',1182910.83,1182910.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','117',2574,'7','1',1084028.21,1084028.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','117',2575,'8','1',1044973.34,1044973.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','117',2576,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','117',2577,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','117',2578,'19','1',913620.91,913620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','117',2579,'20','1',1066730.58,1066730.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','117',2580,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','117',2581,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','117',2582,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','117',2583,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','117',2584,'25','2',818310.65,820392.29,2081.64,1727761.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','117',2585,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','117',2586,'27','2',524605.61,526772.07,2166.46,1798161.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','117',2587,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','117',2588,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','117',2589,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','118',2590,'1','1',1264951.65,1270945.23,5993.58,988940.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','118',2591,'2','1',1075597.61,1081425.69,5828.08,961633.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','118',2592,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','118',2593,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','118',2594,'5','1',1120134.15,1120134.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','118',2595,'6','1',1182910.83,1182910.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','118',2596,'7','1',1084028.21,1090246.88,6218.67,1026080.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','118',2597,'8','1',1044973.34,1051918.20,6944.86,1145901.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','118',2598,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','118',2599,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','118',2600,'19','1',913620.91,913620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','118',2601,'20','1',1066730.58,1066730.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','118',2602,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','118',2603,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','118',2604,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','118',2605,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','118',2606,'25','2',820392.29,820756.96,364.67,302676.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','118',2607,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','118',2608,'27','2',526772.07,527271.46,499.39,414493.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','118',2609,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','118',2610,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','118',2611,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','119',2612,'1','1',1270945.23,1270945.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','119',2613,'2','1',1081425.69,1081425.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','119',2614,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','119',2615,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','119',2616,'5','1',1120134.15,1120210.82,46.03,7594.95,0.00,0.00,30.64,0.00,0.00),('21','226','1','119',2617,'6','1',1182910.83,1182932.11,0.00,0.00,0.00,0.00,21.28,0.00,0.00),('21','226','1','119',2618,'7','1',1090246.88,1090538.84,261.06,43074.90,0.00,0.00,30.90,0.00,0.00),('21','226','1','119',2619,'8','1',1051918.20,1052284.73,335.91,55425.15,0.00,0.00,30.62,0.00,0.00),('21','226','2','119',2620,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','119',2621,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','119',2622,'19','1',913620.91,913620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','119',2623,'20','1',1066730.58,1066730.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','119',2624,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','119',2625,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','119',2626,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','119',2627,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','119',2628,'25','2',820756.96,821211.21,454.25,377027.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','119',2629,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','119',2630,'27','2',527271.46,529114.61,1843.15,1529814.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','119',2631,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','119',2632,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','119',2633,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','120',2634,'1','1',1270945.23,1274686.36,3741.13,617286.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','120',2635,'2','1',1081425.69,1084829.28,3403.59,561592.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','120',2636,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','120',2637,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','120',2638,'5','1',1120210.82,1120210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','120',2639,'6','1',1182932.11,1182932.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','120',2640,'7','1',1090538.84,1093663.63,3124.79,515590.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','120',2641,'8','1',1052284.73,1056096.92,3812.19,629011.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','120',2642,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','120',2643,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','120',2644,'19','1',913620.91,913620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','120',2645,'20','1',1066730.58,1066730.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','120',2646,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','120',2647,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','120',2648,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','120',2649,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','120',2650,'25','2',821211.21,822325.01,1113.80,924454.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','120',2651,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','120',2652,'27','2',529114.61,530695.10,1580.49,1311806.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','120',2653,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','120',2654,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','120',2655,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','121',2656,'1','1',1274686.36,1274686.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','121',2657,'2','1',1084829.28,1084829.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','121',2658,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','121',2659,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','121',2660,'5','1',1120210.82,1120210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','121',2661,'6','1',1182932.11,1182932.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','121',2662,'7','1',1093663.63,1093663.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','121',2663,'8','1',1056096.92,1056096.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','121',2664,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','121',2665,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','121',2666,'19','1',913620.91,913620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','121',2667,'20','1',1066730.58,1066730.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','121',2668,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','121',2669,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','121',2670,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','121',2671,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','121',2672,'25','2',822325.01,824095.35,1770.34,1469382.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','121',2673,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','121',2674,'27','2',530695.10,532654.46,1959.36,1626268.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','121',2675,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','121',2676,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','121',2677,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','122',2678,'1','1',1274686.36,1274686.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','122',2679,'2','1',1084829.28,1084829.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','122',2680,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','122',2681,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','122',2682,'5','1',1120210.82,1120210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','122',2683,'6','1',1182932.11,1183071.63,139.52,23020.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','122',2684,'7','1',1093663.63,1094002.57,338.94,55925.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','122',2685,'8','1',1056096.92,1056175.97,79.05,13043.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','122',2686,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','122',2687,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','122',2688,'19','1',913620.91,913620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','122',2689,'20','1',1066730.58,1066730.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','122',2690,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','122',2691,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','122',2692,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','122',2693,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','122',2694,'25','2',824095.35,824537.98,442.63,367382.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','122',2695,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','122',2696,'27','2',532654.46,534045.27,1390.81,1154372.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','122',2697,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','122',2698,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','122',2699,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','123',2700,'1','1',1274686.36,1274686.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','123',2701,'2','1',1084829.28,1084829.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','123',2702,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','123',2703,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','123',2704,'5','1',1120210.82,1120210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','123',2705,'6','1',1183071.63,1183071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','123',2706,'7','1',1094002.57,1094002.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','123',2707,'8','1',1056175.97,1056175.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','123',2708,'17','1',874600.12,874600.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','123',2709,'18','1',932690.30,932690.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','123',2710,'19','1',913620.91,913620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','123',2711,'20','1',1066730.58,1066730.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','123',2712,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','123',2713,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','123',2714,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','123',2715,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','123',2716,'25','2',824537.98,826026.72,1488.74,1235654.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','123',2717,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','123',2718,'27','2',534045.27,535669.36,1624.09,1347994.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','123',2719,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','123',2720,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','123',2721,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','124',2722,'1','1',1274686.36,1274686.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','124',2723,'2','1',1084829.28,1084829.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','124',2724,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','124',2725,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','124',2726,'5','1',1120210.82,1120210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','124',2727,'6','1',1183071.63,1183071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','124',2728,'7','1',1094002.57,1095421.53,1418.96,234128.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','124',2729,'8','1',1056175.97,1056175.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','124',2730,'17','1',874600.12,876988.47,2388.35,394077.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','124',2731,'18','1',932690.30,935021.80,2331.50,384697.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','124',2732,'19','1',913620.91,916338.16,2717.25,448346.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','124',2733,'20','1',1066730.58,1069388.55,2657.97,438565.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','124',2734,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','124',2735,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','124',2736,'23','1',922103.60,922103.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','124',2737,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','124',2738,'25','2',826026.72,828150.36,2123.64,1762621.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','124',2739,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','124',2740,'27','2',535669.36,536423.36,754.00,625820.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','124',2741,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','124',2742,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','124',2743,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','125',2744,'1','1',1274686.36,1274686.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','125',2745,'2','1',1084829.28,1084829.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','125',2746,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','125',2747,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','125',2748,'5','1',1120210.82,1120210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','125',2749,'6','1',1183071.63,1183071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','125',2750,'7','1',1095421.53,1095421.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','125',2751,'8','1',1056175.97,1056175.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','125',2752,'17','1',876988.47,877005.36,16.89,2786.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','125',2753,'18','1',935021.80,935155.25,133.45,22019.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','125',2754,'19','1',916338.16,916700.01,361.85,59705.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','125',2755,'20','1',1069388.55,1070318.74,930.19,153481.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','125',2756,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','125',2757,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','125',2758,'23','1',922103.60,922124.82,21.22,3501.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','125',2759,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','125',2760,'25','2',828150.36,835315.60,7165.24,5947149.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','125',2761,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','125',2762,'27','2',536423.36,537000.19,576.83,478768.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','125',2763,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','125',2764,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','125',2765,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','126',2766,'1','1',1274686.36,1276475.49,1789.13,295206.45,0.00,0.00,0.00,0.00,0.00),('21','226','1','126',2767,'2','1',1084829.28,1086105.27,1275.99,210538.35,0.00,0.00,0.00,0.00,0.00),('21','226','1','126',2768,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','126',2769,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','126',2770,'5','1',1120210.82,1120210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','126',2771,'6','1',1183071.63,1183071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','126',2772,'7','1',1095421.53,1097221.83,1800.30,297049.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','126',2773,'8','1',1056175.97,1058133.15,1957.18,322934.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','126',2774,'17','1',877005.36,877005.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','126',2775,'18','1',935155.25,935155.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','126',2776,'19','1',916700.01,916845.47,145.46,24000.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','126',2777,'20','1',1070318.74,1070727.96,409.22,67521.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','126',2778,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','126',2779,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','126',2780,'23','1',922124.82,922124.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','126',2781,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','126',2782,'25','2',835315.60,837114.01,1798.41,1492680.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','126',2783,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','126',2784,'27','2',537000.19,537649.01,648.82,538520.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','126',2785,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','126',2786,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','126',2787,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','127',2788,'1','1',1276475.49,1276475.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','127',2789,'2','1',1086105.27,1086105.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','127',2790,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','127',2791,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','127',2792,'5','1',1120210.82,1120210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','127',2793,'6','1',1183071.63,1183071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','127',2794,'7','1',1097221.83,1097221.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','127',2795,'8','1',1058133.15,1058133.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','127',2796,'17','1',877005.36,877005.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','127',2797,'18','1',935155.25,935155.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','127',2798,'19','1',916845.47,916845.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','127',2799,'20','1',1070727.96,1070727.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','127',2800,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','127',2801,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','127',2802,'23','1',922124.82,922124.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','127',2803,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','127',2804,'25','2',837114.01,838065.01,951.00,789330.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','127',2805,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','127',2806,'27','2',537649.01,538116.27,467.26,387825.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','127',2807,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','127',2808,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','127',2809,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','128',2810,'1','1',1276475.49,1283889.33,7413.84,1371560.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','128',2811,'2','1',1086105.27,1092531.39,6426.12,1188832.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','128',2812,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','128',2813,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','128',2814,'5','1',1120210.82,1120358.09,147.27,27244.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','128',2815,'6','1',1183071.63,1183071.78,0.15,27.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','128',2816,'7','1',1097221.83,1105037.61,7815.78,1445919.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','128',2817,'8','1',1058133.15,1066549.32,8416.17,1556991.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','128',2818,'17','1',877005.36,877005.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','128',2819,'18','1',935155.25,935155.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','128',2820,'19','1',916845.47,916845.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','128',2821,'20','1',1070727.96,1070727.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','128',2822,'21','1',792161.63,792161.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','128',2823,'22','1',1037438.88,1037438.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','128',2824,'23','1',922124.82,922124.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','128',2825,'24','1',970376.09,970376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','128',2826,'25','2',838065.01,838887.71,822.70,682841.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','128',2827,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','128',2828,'27','2',538116.27,539153.92,1037.65,861249.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','128',2829,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','128',2830,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','128',2831,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','129',2832,'1','1',1283889.33,1290850.05,6960.72,1287733.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','129',2833,'2','1',1092531.39,1098162.44,5631.05,1041744.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','129',2834,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','129',2835,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','129',2836,'5','1',1120358.09,1125809.02,5450.93,1008422.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','129',2837,'6','1',1183071.78,1189538.38,6466.60,1196321.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','129',2838,'7','1',1105037.61,1111068.14,6030.53,1115648.05,0.00,0.00,0.00,0.00,0.00),('21','226','1','129',2839,'8','1',1066549.32,1070721.63,4172.31,771877.35,0.00,0.00,0.00,0.00,0.00),('21','226','2','129',2840,'17','1',877005.36,878990.94,1985.58,367332.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','129',2841,'18','1',935155.25,936869.95,1714.70,317219.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','129',2842,'19','1',916845.47,919139.02,2293.55,424306.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','129',2843,'20','1',1070727.96,1072383.19,1655.23,306217.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','129',2844,'21','1',792161.63,793742.87,1581.24,292529.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','129',2845,'22','1',1037438.88,1039475.21,2036.33,376721.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','129',2846,'23','1',922124.82,924154.41,2029.59,375474.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','129',2847,'24','1',970376.09,972245.56,1869.47,345851.95,0.00,0.00,0.00,0.00,0.00),('21','226','3','129',2848,'25','2',838887.71,840354.83,1467.12,1217709.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','129',2849,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','129',2850,'27','2',539153.92,539365.75,211.83,175818.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','129',2851,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','129',2852,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','129',2853,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','130',2854,'1','1',1290850.05,1290850.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','130',2855,'2','1',1098162.44,1098162.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','130',2856,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','130',2857,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','130',2858,'5','1',1125809.02,1130668.92,4859.90,899081.50,0.00,0.00,0.00,0.00,0.00),('21','226','1','130',2859,'6','1',1189538.38,1194857.38,5319.00,984015.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','130',2860,'7','1',1111068.14,1115890.48,4822.34,892132.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','130',2861,'8','1',1070721.63,1074389.21,3667.58,678502.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','130',2862,'17','1',878990.94,878990.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','130',2863,'18','1',936869.95,936869.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','130',2864,'19','1',919139.02,919139.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','130',2865,'20','1',1072383.19,1072383.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','130',2866,'21','1',793742.87,797447.41,3704.54,685339.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','130',2867,'22','1',1039475.21,1043606.21,4131.00,764235.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','130',2868,'23','1',924154.41,927820.02,3665.61,678137.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','130',2869,'24','1',972245.56,975857.09,3611.53,668133.05,0.00,0.00,0.00,0.00,0.00),('21','226','3','130',2870,'25','2',840354.83,840782.17,427.34,354692.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','130',2871,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','130',2872,'27','2',539365.75,540320.22,954.47,792210.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','130',2873,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','130',2874,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','130',2875,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','131',2876,'1','1',1290850.05,1296832.19,5982.14,1106695.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','131',2877,'2','1',1098162.44,1103022.20,4859.76,899055.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','131',2878,'3','1',1804513.44,1804513.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','131',2879,'4','1',1323273.92,1323273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','131',2880,'5','1',1130668.92,1134766.91,4097.99,758128.15,0.00,0.00,0.00,0.00,0.00),('21','226','1','131',2881,'6','1',1194857.38,1200635.59,5778.21,1068968.85,0.00,0.00,0.00,0.00,0.00),('21','226','1','131',2882,'7','1',1115890.48,1120859.88,4969.40,919339.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','131',2883,'8','1',1074389.21,1078677.13,4287.92,793265.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','131',2884,'17','1',878990.94,881217.07,2226.13,411834.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','131',2885,'18','1',936869.95,939082.84,2212.89,409384.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','131',2886,'19','1',919139.02,921029.51,1890.49,349740.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','131',2887,'20','1',1072383.19,1073574.61,1191.42,220412.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','131',2888,'21','1',797447.41,798318.74,871.33,161196.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','131',2889,'22','1',1043606.21,1045715.50,2109.29,390218.65,0.00,0.00,0.00,0.00,0.00),('21','226','2','131',2890,'23','1',927820.02,930029.56,2209.54,408764.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','131',2891,'24','1',975857.09,978186.47,2329.38,430935.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','131',2892,'25','2',840782.17,842943.43,2161.26,1793845.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','131',2893,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','131',2894,'27','2',540320.22,540710.62,390.40,324032.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','131',2895,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','131',2896,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','131',2897,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','132',2898,'1','1',1296832.19,1302280.27,5448.08,1007894.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','132',2899,'2','1',1103022.20,1107255.66,4233.46,783190.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','132',2900,'3','1',1804513.44,1806555.87,2042.43,377849.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','132',2901,'4','1',1323273.92,1324349.14,1075.22,198915.70,0.00,0.00,0.00,0.00,0.00),('21','226','1','132',2902,'5','1',1134766.91,1137755.11,2988.20,552817.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','132',2903,'6','1',1200635.59,1204195.77,3560.18,658633.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','132',2904,'7','1',1120859.88,1124041.31,3181.43,588564.55,0.00,0.00,0.00,0.00,0.00),('21','226','1','132',2905,'8','1',1078677.13,1080729.68,2052.55,379721.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','132',2906,'17','1',881217.07,883374.01,2156.94,399033.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','132',2907,'18','1',939082.84,941279.85,2197.01,406446.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','132',2908,'19','1',921029.51,922802.85,1773.34,328067.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','132',2909,'20','1',1073574.61,1075613.58,2038.97,377209.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','132',2910,'21','1',798318.74,800203.34,1884.60,348651.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','132',2911,'22','1',1045715.50,1048624.52,2909.02,538168.70,0.00,0.00,0.00,0.00,0.00),('21','226','2','132',2912,'23','1',930029.56,932084.97,2055.41,380250.85,0.00,0.00,0.00,0.00,0.00),('21','226','2','132',2913,'24','1',978186.47,980284.30,2097.83,388098.55,0.00,0.00,0.00,0.00,0.00),('21','226','3','132',2914,'25','2',842943.43,845201.75,2258.32,1874405.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','132',2915,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','132',2916,'27','2',540710.62,541558.87,848.25,704047.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','132',2917,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','132',2918,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','132',2919,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','133',2920,'1','1',1302280.27,1302280.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','133',2921,'2','1',1107255.66,1107255.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','133',2922,'3','1',1806555.87,1811484.05,4928.18,911713.30,0.00,0.00,0.00,0.00,0.00),('21','226','1','133',2923,'4','1',1324349.14,1328500.08,4150.94,767923.90,0.00,0.00,0.00,0.00,0.00),('21','226','1','133',2924,'5','1',1137755.11,1137755.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','133',2925,'6','1',1204195.77,1204195.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','133',2926,'7','1',1124041.31,1128222.83,4181.52,773581.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','133',2927,'8','1',1080729.68,1084841.13,4111.45,760618.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','133',2928,'17','1',883374.01,885103.80,1729.79,320011.15,0.00,0.00,0.00,0.00,0.00),('21','226','2','133',2929,'18','1',941279.85,943379.18,2099.33,388376.05,0.00,0.00,0.00,0.00,0.00),('21','226','2','133',2930,'19','1',922802.85,924960.73,2157.88,399207.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','133',2931,'20','1',1075613.58,1077947.72,2334.14,431815.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','133',2932,'21','1',800203.34,801228.92,1025.58,189732.30,0.00,0.00,0.00,0.00,0.00),('21','226','2','133',2933,'22','1',1048624.52,1050010.95,1386.43,256489.55,0.00,0.00,0.00,0.00,0.00),('21','226','2','133',2934,'23','1',932084.97,933809.91,1724.94,319113.90,0.00,0.00,0.00,0.00,0.00),('21','226','2','133',2935,'24','1',980284.30,982771.74,2487.44,460176.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','133',2936,'25','2',845201.75,847078.15,1876.40,1557412.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','133',2937,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','133',2938,'27','2',541558.87,542738.41,1179.54,979018.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','133',2939,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','133',2940,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','133',2941,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','134',2942,'1','1',1302280.27,1303004.34,724.07,133952.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','134',2943,'2','1',1107255.66,1107959.94,704.28,130291.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','134',2944,'3','1',1811484.05,1814071.72,2587.67,478718.95,0.00,0.00,0.00,0.00,0.00),('21','226','1','134',2945,'4','1',1328500.08,1330761.88,2261.80,418433.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','134',2946,'5','1',1137755.11,1138431.80,676.69,125187.65,0.00,0.00,0.00,0.00,0.00),('21','226','1','134',2947,'6','1',1204195.77,1204988.52,792.75,146658.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','134',2948,'7','1',1128222.83,1131000.69,2777.86,513904.10,0.00,0.00,0.00,0.00,0.00),('21','226','1','134',2949,'8','1',1084841.13,1087611.70,2770.57,512555.45,0.00,0.00,0.00,0.00,0.00),('21','226','2','134',2950,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','134',2951,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','134',2952,'19','1',924960.73,924960.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','134',2953,'20','1',1077947.72,1077947.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','134',2954,'21','1',801228.92,801228.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','134',2955,'22','1',1050010.95,1050010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','134',2956,'23','1',933809.91,933809.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','134',2957,'24','1',982771.74,982771.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','134',2958,'25','2',847078.15,849405.68,2327.53,1931849.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','134',2959,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','134',2960,'27','2',542738.41,544732.97,1994.56,1655484.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','134',2961,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','134',2962,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','134',2963,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','135',2964,'1','1',1303004.34,1303004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','135',2965,'2','1',1107959.94,1107959.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','135',2966,'3','1',1814071.72,1818493.76,4422.04,773857.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','135',2967,'4','1',1330761.88,1334505.45,3743.57,655124.75,0.00,0.00,0.00,0.00,0.00),('21','226','1','135',2968,'5','1',1138431.80,1138431.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','135',2969,'6','1',1204988.52,1204988.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','135',2970,'7','1',1131000.69,1135414.32,4413.63,772385.25,0.00,0.00,0.00,0.00,0.00),('21','226','1','135',2971,'8','1',1087611.70,1091437.38,3825.68,669494.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','135',2972,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','135',2973,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','135',2974,'19','1',924960.73,927852.26,2891.53,506017.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','135',2975,'20','1',1077947.72,1080998.43,3050.71,533874.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','135',2976,'21','1',801228.92,802829.47,1600.55,280096.25,0.00,0.00,0.00,0.00,0.00),('21','226','2','135',2977,'22','1',1050010.95,1051979.84,1968.89,344555.75,0.00,0.00,0.00,0.00,0.00),('21','226','2','135',2978,'23','1',933809.91,936332.13,2522.22,441388.50,0.00,0.00,0.00,0.00,0.00),('21','226','2','135',2979,'24','1',982771.74,985877.38,3105.64,543487.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','135',2980,'25','2',849405.68,850928.67,1522.99,1264081.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','135',2981,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','135',2982,'27','2',544732.97,545738.20,1005.23,834340.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','135',2983,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','135',2984,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','135',2985,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','136',2986,'1','1',1303004.34,1303004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','136',2987,'2','1',1107959.94,1107959.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','136',2988,'3','1',1818493.76,1818493.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','136',2989,'4','1',1334505.45,1334505.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','136',2990,'5','1',1138431.80,1138431.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','136',2991,'6','1',1204988.52,1204988.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','136',2992,'7','1',1135414.32,1135414.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','136',2993,'8','1',1091437.38,1091437.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','136',2994,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','136',2995,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','136',2996,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','136',2997,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','136',2998,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','136',2999,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','136',3000,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','136',3001,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','136',3002,'25','2',850928.67,852018.02,1089.35,904160.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','136',3003,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','136',3004,'27','2',545738.20,546285.90,547.70,454591.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','136',3005,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','136',3006,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','136',3007,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','137',3008,'1','1',1303004.34,1303004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','137',3009,'2','1',1107959.94,1107959.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','137',3010,'3','1',1818493.76,1818493.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','137',3011,'4','1',1334505.45,1334505.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','137',3012,'5','1',1138431.80,1138431.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','137',3013,'6','1',1204988.52,1204988.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','137',3014,'7','1',1135414.32,1135729.59,315.27,56748.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','137',3015,'8','1',1091437.38,1091479.96,42.58,7664.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','137',3016,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','137',3017,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','137',3018,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','137',3019,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','137',3020,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','137',3021,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','137',3022,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','137',3023,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','137',3024,'25','2',852018.02,853089.50,1071.48,889328.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','137',3025,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','137',3026,'27','2',546285.90,546571.07,285.17,236691.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','137',3027,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','137',3028,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','137',3029,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','138',3030,'1','1',1303004.34,1303004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','138',3031,'2','1',1107959.94,1107959.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','138',3032,'3','1',1818493.76,1818493.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','138',3033,'4','1',1334505.45,1334505.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','138',3034,'5','1',1138431.80,1138431.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','138',3035,'6','1',1204988.52,1204988.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','138',3036,'7','1',1135729.59,1135729.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','138',3037,'8','1',1091479.96,1091479.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','138',3038,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','138',3039,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','138',3040,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','138',3041,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','138',3042,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','138',3043,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','138',3044,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','138',3045,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','138',3046,'25','2',853089.50,855246.51,2157.01,1790318.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','138',3047,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','138',3048,'27','2',546571.07,547182.37,611.30,507379.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','138',3049,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','138',3050,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','138',3051,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','139',3052,'1','1',1303004.34,1303004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','139',3053,'2','1',1107959.94,1107959.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','139',3054,'3','1',1818493.76,1818493.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','139',3055,'4','1',1334505.45,1334505.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','139',3056,'5','1',1138431.80,1145962.87,7531.07,1355592.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','139',3057,'6','1',1204988.52,1213097.81,8109.29,1459672.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','139',3058,'7','1',1135729.59,1143130.14,7400.55,1332099.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','139',3059,'8','1',1091479.96,1098708.33,7228.37,1301106.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','139',3060,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','139',3061,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','139',3062,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','139',3063,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','139',3064,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','139',3065,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','139',3066,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','139',3067,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','139',3068,'25','2',855246.51,856168.96,922.45,751796.75,0.00,0.00,0.00,0.00,0.00),('21','226','3','139',3069,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','139',3070,'27','2',547182.37,547288.00,105.63,86088.45,0.00,0.00,0.00,0.00,0.00),('21','226','3','139',3071,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','139',3072,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','139',3073,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','140',3074,'1','1',1303004.34,1303004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','140',3075,'2','1',1107959.94,1107959.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','140',3076,'3','1',1818493.76,1818493.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','140',3077,'4','1',1334505.45,1334505.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','140',3078,'5','1',1145962.87,1145962.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','140',3079,'6','1',1213097.81,1213097.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','140',3080,'7','1',1143130.14,1143130.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','140',3081,'8','1',1098708.33,1098708.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','140',3082,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','140',3083,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','140',3084,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','140',3085,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','140',3086,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','140',3087,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','140',3088,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','140',3089,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','140',3090,'25','2',856168.96,856168.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','140',3091,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','140',3092,'27','2',547288.00,547288.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','140',3093,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','140',3094,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','140',3095,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','141',3096,'1','1',1303004.34,1303004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','141',3097,'2','1',1107959.94,1107959.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','141',3098,'3','1',1818493.76,1818493.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','141',3099,'4','1',1334505.45,1334505.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','141',3100,'5','1',1145962.87,1145962.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','141',3101,'6','1',1213097.81,1213097.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','141',3102,'7','1',1143130.14,1143130.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','141',3103,'8','1',1098708.33,1098708.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','141',3104,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','141',3105,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','141',3106,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','141',3107,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','141',3108,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','141',3109,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','141',3110,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','141',3111,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','141',3112,'25','2',856168.96,856647.07,478.11,389659.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','141',3113,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','141',3114,'27','2',547288.00,548011.75,723.75,589856.25,0.00,0.00,0.00,0.00,0.00),('21','226','3','141',3115,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','141',3116,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','141',3117,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','142',3118,'1','1',1303004.34,1303004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','142',3119,'2','1',1107959.94,1107959.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','142',3120,'3','1',1818493.76,1818493.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','142',3121,'4','1',1334505.45,1334505.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','142',3122,'5','1',1145962.87,1146139.97,177.10,31878.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','142',3123,'6','1',1213097.81,1213130.89,33.08,5954.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','142',3124,'7','1',1143130.14,1143724.28,594.14,106945.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','142',3125,'8','1',1098708.33,1098740.94,32.61,5869.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','142',3126,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','142',3127,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','142',3128,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','142',3129,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','142',3130,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','142',3131,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','142',3132,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','142',3133,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','142',3134,'25','2',856647.07,856647.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','142',3135,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','142',3136,'27','2',548011.75,548063.76,52.01,42388.15,0.00,0.00,0.00,0.00,0.00),('21','226','3','142',3137,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','142',3138,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','142',3139,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','143',3140,'1','1',1303004.34,1306658.81,3654.47,657804.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','143',3141,'2','1',1107959.94,1111762.64,3802.70,684486.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','143',3142,'3','1',1818493.76,1822171.27,3677.51,661951.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','143',3143,'4','1',1334505.45,1337929.74,3424.29,616372.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','143',3144,'5','1',1146139.97,1146147.05,7.08,1274.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','143',3145,'6','1',1213130.89,1213170.32,39.43,7097.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','143',3146,'7','1',1143724.28,1151321.38,7538.22,1356879.60,0.00,0.00,58.88,0.00,0.00),('21','226','1','143',3147,'8','1',1098740.94,1106251.90,7510.96,1351972.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','143',3148,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','143',3149,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','143',3150,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','143',3151,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','143',3152,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','143',3153,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','143',3154,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','143',3155,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','143',3156,'25','2',856647.07,856647.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','143',3157,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','143',3158,'27','2',548063.76,548063.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','143',3159,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','143',3160,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','143',3161,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','144',3162,'1','1',1306658.81,1310186.86,3498.55,629739.00,0.00,0.00,29.50,0.00,0.00),('21','226','1','144',3163,'2','1',1111762.64,1115145.59,3353.45,603621.00,0.00,0.00,29.50,0.00,0.00),('21','226','1','144',3164,'3','1',1822171.27,1822171.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','144',3165,'4','1',1337929.74,1337929.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','144',3166,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','144',3167,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','144',3168,'7','1',1151321.38,1155296.00,3945.12,710121.60,0.00,0.00,29.50,0.00,0.00),('21','226','1','144',3169,'8','1',1106251.90,1110046.11,3764.71,677647.80,0.00,0.00,29.50,0.00,0.00),('21','226','2','144',3170,'17','1',885103.80,885103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','144',3171,'18','1',943379.18,943379.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','144',3172,'19','1',927852.26,927852.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','144',3173,'20','1',1080998.43,1080998.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','144',3174,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','144',3175,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','144',3176,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','144',3177,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','144',3178,'25','2',856647.07,858628.38,1981.31,1614767.65,0.00,0.00,0.00,0.00,0.00),('21','226','3','144',3179,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','144',3180,'27','2',548063.76,549697.44,1633.68,1331449.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','144',3181,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','144',3182,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','144',3183,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','145',3184,'1','1',1310186.86,1316981.19,6794.33,1222979.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','145',3185,'2','1',1115145.59,1121227.98,6082.39,1094830.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','145',3186,'3','1',1822171.27,1824590.57,2419.30,435474.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','145',3187,'4','1',1337929.74,1339957.73,2027.99,365038.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','145',3188,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','145',3189,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','145',3190,'7','1',1155296.00,1162024.05,6728.05,1211049.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','145',3191,'8','1',1110046.11,1116927.14,6881.03,1238585.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','145',3192,'17','1',885103.80,885192.67,88.87,15996.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','145',3193,'18','1',943379.18,943452.17,72.99,13138.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','145',3194,'19','1',927852.26,928050.28,198.02,35643.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','145',3195,'20','1',1080998.43,1081197.18,198.75,35775.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','145',3196,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','145',3197,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','145',3198,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','145',3199,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','145',3200,'25','2',858628.38,859359.37,730.99,595756.85,0.00,0.00,0.00,0.00,0.00),('21','226','3','145',3201,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','145',3202,'27','2',549697.44,550395.36,697.92,568804.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','145',3203,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','145',3204,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','145',3205,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','146',3206,'1','1',1316981.19,1316981.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','146',3207,'2','1',1121227.98,1121227.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','146',3208,'3','1',1824590.57,1824590.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','146',3209,'4','1',1339957.73,1339957.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','146',3210,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','146',3211,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','146',3212,'7','1',1162024.05,1162024.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','146',3213,'8','1',1116927.14,1116927.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','146',3214,'17','1',885192.67,885192.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','146',3215,'18','1',943452.17,943452.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','146',3216,'19','1',928050.28,928050.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','146',3217,'20','1',1081197.18,1081197.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','146',3218,'21','1',802829.47,802829.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','146',3219,'22','1',1051979.84,1051979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','146',3220,'23','1',936332.13,936332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','146',3221,'24','1',985877.38,985877.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','146',3222,'25','2',859359.37,860562.96,1203.59,974907.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','146',3223,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','146',3224,'27','2',550395.36,550445.36,50.00,40500.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','146',3225,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','146',3226,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','146',3227,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','147',3228,'1','1',1316981.19,1316981.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','147',3229,'2','1',1121227.98,1121227.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','147',3230,'3','1',1824590.57,1824590.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','147',3231,'4','1',1339957.73,1339957.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','147',3232,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','147',3233,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','147',3234,'7','1',1162024.05,1162024.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','147',3235,'8','1',1116927.14,1116927.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','147',3236,'17','1',885192.67,888771.86,3579.19,644254.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','147',3237,'18','1',943452.17,946872.74,3420.57,615702.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','147',3238,'19','1',928050.28,931267.85,3217.57,579162.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','147',3239,'20','1',1081197.18,1083558.47,2361.29,425032.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','147',3240,'21','1',802829.47,806748.94,3919.47,705504.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','147',3241,'22','1',1051979.84,1056303.78,4323.94,778309.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','147',3242,'23','1',936332.13,940691.67,4359.54,784717.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','147',3243,'24','1',985877.38,990294.55,4417.17,795090.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','147',3244,'25','2',860562.96,862205.40,1642.44,1330376.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','147',3245,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','147',3246,'27','2',550445.36,553120.28,2674.92,2166685.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','147',3247,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','147',3248,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','147',3249,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','148',3250,'1','1',1316981.19,1322065.31,5084.12,915141.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','148',3251,'2','1',1121227.98,1126185.26,4957.28,892310.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','148',3252,'3','1',1824590.57,1830331.42,5740.85,1033353.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','148',3253,'4','1',1339957.73,1344526.25,4568.52,822333.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','148',3254,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','148',3255,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','148',3256,'7','1',1162024.05,1166793.65,4769.60,858528.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','148',3257,'8','1',1116927.14,1121920.55,4993.41,898813.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','148',3258,'17','1',888771.86,888771.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','148',3259,'18','1',946872.74,946872.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','148',3260,'19','1',931267.85,931267.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','148',3261,'20','1',1083558.47,1083558.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','148',3262,'21','1',806748.94,806748.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','148',3263,'22','1',1056303.78,1056303.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','148',3264,'23','1',940691.67,940691.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','148',3265,'24','1',990294.55,990294.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','148',3266,'25','2',862205.40,863177.43,972.03,787344.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','148',3267,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','148',3268,'27','2',553120.28,555004.20,1883.92,1525975.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','148',3269,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','148',3270,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','148',3271,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','149',3272,'1','1',1322065.31,1322811.04,745.73,134231.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','149',3273,'2','1',1126185.26,1127007.01,821.75,147915.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','149',3274,'3','1',1830331.42,1834727.30,4395.88,791258.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','149',3275,'4','1',1344526.25,1348584.48,4058.23,730481.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','149',3276,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','149',3277,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','149',3278,'7','1',1166793.65,1169573.20,2779.55,500319.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','149',3279,'8','1',1121920.55,1124298.15,2377.60,427968.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','149',3280,'17','1',888771.86,889575.13,803.27,144588.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','149',3281,'18','1',946872.74,947689.08,816.34,146941.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','149',3282,'19','1',931267.85,933803.97,2536.12,456501.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','149',3283,'20','1',1083558.47,1085508.27,1949.80,350964.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','149',3284,'21','1',806748.94,808593.03,1844.09,331936.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','149',3285,'22','1',1056303.78,1058028.70,1724.92,310485.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','149',3286,'23','1',940691.67,943198.77,2507.10,451278.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','149',3287,'24','1',990294.55,993239.89,2945.34,530161.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','149',3288,'25','2',863177.43,863936.13,758.70,614547.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','149',3289,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','149',3290,'27','2',555004.20,558049.20,3045.00,2466450.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','149',3291,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','149',3292,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','149',3293,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','150',3294,'1','1',1322811.04,1322811.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','150',3295,'2','1',1127007.01,1127007.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','150',3296,'3','1',1834727.30,1834727.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','150',3297,'4','1',1348584.48,1348584.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','150',3298,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','150',3299,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','150',3300,'7','1',1169573.20,1169573.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','150',3301,'8','1',1124298.15,1124298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','150',3302,'17','1',889575.13,889575.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','150',3303,'18','1',947689.08,947689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','150',3304,'19','1',933803.97,933803.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','150',3305,'20','1',1085508.27,1085508.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','150',3306,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','150',3307,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','150',3308,'23','1',943198.77,943198.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','150',3309,'24','1',993239.89,993239.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','150',3310,'25','2',863936.13,863936.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','150',3311,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','150',3312,'27','2',558049.20,558049.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','150',3313,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','150',3314,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','150',3315,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','151',3316,'1','1',1322811.04,1326132.50,3321.46,597862.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','151',3317,'2','1',1127007.01,1130021.45,3014.44,542599.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','151',3318,'3','1',1834727.30,1836130.00,1402.70,252486.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','151',3319,'4','1',1348584.48,1349471.19,886.71,159607.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','151',3320,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','151',3321,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','151',3322,'7','1',1169573.20,1172598.22,3025.02,544503.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','151',3323,'8','1',1124298.15,1127541.47,3243.32,583797.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','151',3324,'17','1',889575.13,890755.00,1179.87,212376.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','151',3325,'18','1',947689.08,948922.08,1233.00,221940.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','151',3326,'19','1',933803.97,937278.74,3474.77,625458.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','151',3327,'20','1',1085508.27,1089374.71,3866.44,695959.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','151',3328,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','151',3329,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','151',3330,'23','1',943198.77,945680.16,2481.39,446650.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','151',3331,'24','1',993239.89,995971.28,2731.39,491650.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','151',3332,'25','2',863936.13,863936.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','151',3333,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','151',3334,'27','2',558049.20,562476.55,4427.35,3586153.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','151',3335,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','151',3336,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','151',3337,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','152',3338,'1','1',1326132.50,1329897.87,3765.37,677766.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','152',3339,'2','1',1130021.45,1133684.44,3662.99,659338.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','152',3340,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','152',3341,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','152',3342,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','152',3343,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','152',3344,'7','1',1172598.22,1176589.16,3990.94,718369.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','152',3345,'8','1',1127541.47,1131161.58,3620.11,651619.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','152',3346,'17','1',890755.00,892068.94,1313.94,236509.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','152',3347,'18','1',948922.08,950192.23,1270.15,228627.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','152',3348,'19','1',937278.74,940863.13,3584.39,645190.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','152',3349,'20','1',1089374.71,1092727.04,3352.33,603419.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','152',3350,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','152',3351,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','152',3352,'23','1',945680.16,948440.25,2760.09,496816.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','152',3353,'24','1',995971.28,998855.72,2884.44,519199.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','152',3354,'25','2',863936.13,864023.92,87.79,71109.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','152',3355,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','152',3356,'27','2',562476.55,563754.51,1277.96,1035147.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','152',3357,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','152',3358,'29','3',268039.32,268039.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','152',3359,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','153',3360,'1','1',1329897.87,1334005.18,4107.31,739315.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','153',3361,'2','1',1133684.44,1137356.13,3671.69,660904.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','153',3362,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','153',3363,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','153',3364,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','153',3365,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','153',3366,'7','1',1176589.16,1180142.32,3553.16,639568.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','153',3367,'8','1',1131161.58,1134941.47,3779.89,680380.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','153',3368,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','153',3369,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','153',3370,'19','1',940863.13,944397.00,3533.87,636096.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','153',3371,'20','1',1092727.04,1096608.50,3881.46,698662.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','153',3372,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','153',3373,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','153',3374,'23','1',948440.25,951951.74,3511.49,632068.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','153',3375,'24','1',998855.72,1002955.42,4099.70,737946.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','153',3376,'25','2',864023.92,864123.92,100.00,81000.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','153',3377,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','153',3378,'27','2',563754.51,566251.82,2497.31,2022821.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','153',3379,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','153',3380,'29','3',268039.32,268079.78,40.46,33783.26,0.00,0.00,0.00,0.00,0.00),('21','226','4','153',3381,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','154',3382,'1','1',1334005.18,1338107.31,4102.13,738383.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','154',3383,'2','1',1137356.13,1140921.21,3565.08,641714.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','154',3384,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','154',3385,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','154',3386,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','154',3387,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','154',3388,'7','1',1180142.32,1184070.29,3927.97,707034.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','154',3389,'8','1',1134941.47,1138962.18,4020.71,723727.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','154',3390,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','154',3391,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','154',3392,'19','1',944397.00,948018.94,3621.94,651949.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','154',3393,'20','1',1096608.50,1100051.09,3442.59,619666.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','154',3394,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','154',3395,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','154',3396,'23','1',951951.74,955592.72,3640.98,655376.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','154',3397,'24','1',1002955.42,1006341.34,3385.92,609465.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','154',3398,'25','2',864123.92,864123.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','154',3399,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','154',3400,'27','2',566251.82,570427.76,4175.94,3382511.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','154',3401,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','154',3402,'29','3',268079.78,268169.07,89.29,74559.65,0.00,0.00,0.00,0.00,0.00),('21','226','4','154',3403,'30','3',91267.09,91267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','155',3404,'1','1',1338107.31,1344192.66,6085.35,1095363.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','155',3405,'2','1',1140921.21,1146641.23,5720.02,1029603.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','155',3406,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','155',3407,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','155',3408,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','155',3409,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','155',3410,'7','1',1184070.29,1190336.11,6265.82,1127847.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','155',3411,'8','1',1138962.18,1144740.37,5778.19,1040074.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','155',3412,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','155',3413,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','155',3414,'19','1',948018.94,951659.15,3640.21,655237.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','155',3415,'20','1',1100051.09,1104452.50,4401.41,792253.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','155',3416,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','155',3417,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','155',3418,'23','1',955592.72,959709.32,4116.60,740988.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','155',3419,'24','1',1006341.34,1010572.00,4230.66,761518.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','155',3420,'25','2',864123.92,864123.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','155',3421,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','155',3422,'27','2',570427.76,576037.32,5609.56,4543743.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','155',3423,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','155',3424,'29','3',268169.07,268367.12,198.05,165369.25,0.00,0.00,0.00,0.00,0.00),('21','226','4','155',3425,'30','3',91267.09,91267.25,0.16,135.27,0.00,0.00,0.00,0.00,0.00),('21','226','1','156',3426,'1','1',1344192.66,1349118.19,4925.53,886595.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','156',3427,'2','1',1146641.23,1150875.99,4234.76,762256.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','156',3428,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','156',3429,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','156',3430,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','156',3431,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','156',3432,'7','1',1190336.11,1195135.19,4799.08,863834.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','156',3433,'8','1',1144740.37,1148845.53,4105.16,738928.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','156',3434,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','156',3435,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','156',3436,'19','1',951659.15,954654.40,2995.25,539145.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','156',3437,'20','1',1104452.50,1107618.69,3166.19,569914.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','156',3438,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','156',3439,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','156',3440,'23','1',959709.32,962480.45,2771.13,498803.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','156',3441,'24','1',1010572.00,1013749.44,3177.44,571939.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','156',3442,'25','2',864123.92,864146.92,23.00,18630.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','156',3443,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','156',3444,'27','2',576037.32,581165.39,5128.07,4153736.70,0.00,0.00,0.00,0.00,0.00),('21','226','3','156',3445,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','156',3446,'29','3',268367.12,268454.59,87.47,73034.11,0.00,0.00,0.00,0.00,0.00),('21','226','4','156',3447,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','157',3448,'1','1',1349118.19,1353445.93,4327.74,778993.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','157',3449,'2','1',1150875.99,1154822.74,3946.75,710415.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','157',3450,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','157',3451,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','157',3452,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','157',3453,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','157',3454,'7','1',1195135.19,1198604.96,3469.77,624558.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','157',3455,'8','1',1148845.53,1152178.63,3333.10,599958.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','157',3456,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','157',3457,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','157',3458,'19','1',954654.40,958467.41,3813.01,686341.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','157',3459,'20','1',1107618.69,1111887.03,4268.34,768301.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','157',3460,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','157',3461,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','157',3462,'23','1',962480.45,965748.38,3267.93,588227.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','157',3463,'24','1',1013749.44,1017501.77,3752.33,675419.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','157',3464,'25','2',864146.92,864719.46,572.54,463757.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','157',3465,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','157',3466,'27','2',581165.39,586204.15,5038.76,4081395.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','157',3467,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','157',3468,'29','3',268454.59,268601.14,146.55,122366.74,0.00,0.00,0.00,0.00,0.00),('21','226','4','157',3469,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','158',3470,'1','1',1353445.93,1353457.03,11.10,1998.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','158',3471,'2','1',1154822.74,1154825.51,2.77,498.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','158',3472,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','158',3473,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','158',3474,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','158',3475,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','158',3476,'7','1',1198604.96,1201720.75,3115.79,560842.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','158',3477,'8','1',1152178.63,1154547.69,2369.06,426430.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','158',3478,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','158',3479,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','158',3480,'19','1',958467.41,961557.82,3090.41,556273.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','158',3481,'20','1',1111887.03,1115105.47,3218.44,579319.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','158',3482,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','158',3483,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','158',3484,'23','1',965748.38,969176.25,3427.87,617016.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','158',3485,'24','1',1017501.77,1020719.25,3217.48,579146.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','158',3486,'25','2',864719.46,864719.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','158',3487,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','158',3488,'27','2',586204.15,589107.57,2903.42,2351770.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','158',3489,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','158',3490,'29','3',268601.14,268662.40,61.26,51147.93,0.00,0.00,0.00,0.00,0.00),('21','226','4','158',3491,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','159',3492,'1','1',1353457.03,1359943.02,6485.99,1167478.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','159',3493,'2','1',1154825.51,1160862.02,6036.51,1086571.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','159',3494,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','159',3495,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','159',3496,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','159',3497,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','159',3498,'7','1',1201720.75,1207509.41,5788.66,1041958.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','159',3499,'8','1',1154547.69,1160110.21,5562.52,1001253.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','159',3500,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','159',3501,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','159',3502,'19','1',961557.82,961557.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','159',3503,'20','1',1115105.47,1115105.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','159',3504,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','159',3505,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','159',3506,'23','1',969176.25,970373.10,1196.85,215433.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','159',3507,'24','1',1020719.25,1021592.02,872.77,157098.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','159',3508,'25','2',864719.46,866148.22,1428.76,1157295.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','159',3509,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','159',3510,'27','2',589107.57,590325.75,1218.18,986725.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','159',3511,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','159',3512,'29','3',268662.40,268848.84,186.44,155674.89,0.00,0.00,0.00,0.00,0.00),('21','226','4','159',3513,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','160',3514,'1','1',1359943.02,1359943.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','160',3515,'2','1',1160862.02,1160862.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','160',3516,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','160',3517,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','160',3518,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','160',3519,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','160',3520,'7','1',1207509.41,1207509.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','160',3521,'8','1',1160110.21,1160110.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','160',3522,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','160',3523,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','160',3524,'19','1',961557.82,961557.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','160',3525,'20','1',1115105.47,1115105.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','160',3526,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','160',3527,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','160',3528,'23','1',970373.10,970373.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','160',3529,'24','1',1021592.02,1021592.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','160',3530,'25','2',866148.22,867519.07,1370.85,1110388.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','160',3531,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','160',3532,'27','2',590325.75,592177.86,1852.11,1500209.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','160',3533,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','160',3534,'29','3',268848.84,268946.28,97.44,81359.06,0.00,0.00,0.00,0.00,0.00),('21','226','4','160',3535,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','161',3536,'1','1',1359943.02,1359943.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','161',3537,'2','1',1160862.02,1160862.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','161',3538,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','161',3539,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','161',3540,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','161',3541,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','161',3542,'7','1',1207509.41,1207509.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','161',3543,'8','1',1160110.21,1160110.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','161',3544,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','161',3545,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','161',3546,'19','1',961557.82,961557.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','161',3547,'20','1',1115105.47,1115105.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','161',3548,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','161',3549,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','161',3550,'23','1',970373.10,970373.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','161',3551,'24','1',1021592.02,1021592.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','161',3552,'25','2',867519.07,868803.43,1284.36,1040331.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','161',3553,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','161',3554,'27','2',592177.86,593974.77,1796.91,1455497.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','161',3555,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','161',3556,'29','3',268946.28,269018.89,72.61,60630.18,0.00,0.00,0.00,0.00,0.00),('21','226','4','161',3557,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','162',3558,'1','1',1359943.02,1365178.25,5235.23,942341.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','162',3559,'2','1',1160862.02,1164969.74,4107.72,739389.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','162',3560,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','162',3561,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','162',3562,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','162',3563,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','162',3564,'7','1',1207509.41,1211039.90,3530.49,635488.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','162',3565,'8','1',1160110.21,1162616.40,2506.19,451114.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','162',3566,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','162',3567,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','162',3568,'19','1',961557.82,965286.47,3728.65,671157.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','162',3569,'20','1',1115105.47,1118824.46,3718.99,669418.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','162',3570,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','162',3571,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','162',3572,'23','1',970373.10,974064.28,3691.18,664412.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','162',3573,'24','1',1021592.02,1025676.97,4084.95,735291.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','162',3574,'25','2',868803.43,870958.59,2155.16,1745679.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','162',3575,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','162',3576,'27','2',593974.77,596779.88,2805.11,2272139.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','162',3577,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','162',3578,'29','3',269018.89,269115.46,96.57,80635.11,0.00,0.00,0.00,0.00,0.00),('21','226','4','162',3579,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','163',3580,'1','1',1365178.25,1369934.53,4756.28,856130.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','163',3581,'2','1',1164969.74,1169373.53,4403.79,792682.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','163',3582,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','163',3583,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','163',3584,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','163',3585,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','163',3586,'7','1',1211039.90,1214247.01,3207.11,577279.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','163',3587,'8','1',1162616.40,1165265.36,2648.96,476812.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','163',3588,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','163',3589,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','163',3590,'19','1',965286.47,968640.42,3333.58,600044.40,0.00,0.00,20.37,0.00,0.00),('21','226','2','163',3591,'20','1',1118824.46,1122829.86,4005.40,720972.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','163',3592,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','163',3593,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','163',3594,'23','1',974064.28,977603.89,3539.61,637129.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','163',3595,'24','1',1025676.97,1029876.51,4199.54,755917.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','163',3596,'25','2',870958.59,872964.03,2005.44,1624406.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','163',3597,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','163',3598,'27','2',596779.88,597957.79,1177.91,954107.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','163',3599,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','163',3600,'29','3',269115.46,269174.54,59.08,49334.30,0.00,0.00,0.00,0.00,0.00),('21','226','4','163',3601,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','164',3602,'1','1',1369934.53,1374315.55,4381.02,788583.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','164',3603,'2','1',1169373.53,1172984.02,3610.49,649888.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','164',3604,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','164',3605,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','164',3606,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','164',3607,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','164',3608,'7','1',1214247.01,1217933.56,3686.55,663579.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','164',3609,'8','1',1165265.36,1168614.60,3349.24,602863.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','164',3610,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','164',3611,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','164',3612,'19','1',968640.42,971640.83,3000.41,540073.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','164',3613,'20','1',1122829.86,1125822.60,2992.74,538693.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','164',3614,'21','1',808593.03,808593.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','164',3615,'22','1',1058028.70,1058028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','164',3616,'23','1',977603.89,980187.32,2583.43,465017.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','164',3617,'24','1',1029876.51,1032714.69,2838.18,510872.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','164',3618,'25','2',872964.03,875128.17,2164.14,1752953.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','164',3619,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','164',3620,'27','2',597957.79,599279.42,1321.63,1070520.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','164',3621,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','164',3622,'29','3',269174.54,269243.60,69.06,57665.94,0.00,0.00,0.00,0.00,0.00),('21','226','4','164',3623,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','165',3624,'1','1',1374315.55,1378780.36,4464.81,803665.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','165',3625,'2','1',1172984.02,1176471.82,3487.80,627804.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','165',3626,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','165',3627,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','165',3628,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','165',3629,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','165',3630,'7','1',1217933.56,1221549.08,3615.52,650793.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','165',3631,'8','1',1168614.60,1171980.97,3366.37,605946.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','165',3632,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','165',3633,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','165',3634,'19','1',971640.83,975328.74,3687.91,663823.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','165',3635,'20','1',1125822.60,1129661.66,3839.06,691030.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','165',3636,'21','1',808593.03,813836.87,5243.84,943891.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','165',3637,'22','1',1058028.70,1063369.85,5341.15,961407.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','165',3638,'23','1',980187.32,980187.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','165',3639,'24','1',1032714.69,1032714.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','165',3640,'25','2',875128.17,876816.21,1688.04,1367312.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','165',3641,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','165',3642,'27','2',599279.42,599519.54,240.12,194497.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','165',3643,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','165',3644,'29','3',269243.60,269259.95,16.35,13654.76,0.00,0.00,0.00,0.00,0.00),('21','226','4','165',3645,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','166',3646,'1','1',1378780.36,1378780.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','166',3647,'2','1',1176471.82,1176471.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','166',3648,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','166',3649,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','166',3650,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','166',3651,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','166',3652,'7','1',1221549.08,1221549.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','166',3653,'8','1',1171980.97,1171980.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','166',3654,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','166',3655,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','166',3656,'19','1',975328.74,975328.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','166',3657,'20','1',1129661.66,1129661.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','166',3658,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','166',3659,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','166',3660,'23','1',980187.32,980187.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','166',3661,'24','1',1032714.69,1032714.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','166',3662,'25','2',876816.21,876816.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','166',3663,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','166',3664,'27','2',599519.54,599519.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','166',3665,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','166',3666,'29','3',269259.95,269366.40,106.45,90485.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','166',3667,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','167',3668,'1','1',1378780.36,1378780.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','167',3669,'2','1',1176471.82,1176471.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','167',3670,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','167',3671,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','167',3672,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','167',3673,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','167',3674,'7','1',1221549.08,1221549.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','167',3675,'8','1',1171980.97,1171980.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','167',3676,'17','1',892068.94,892068.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','167',3677,'18','1',950192.23,950192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','167',3678,'19','1',975328.74,975328.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','167',3679,'20','1',1129661.66,1129661.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','167',3680,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','167',3681,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','167',3682,'23','1',980187.32,980187.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','167',3683,'24','1',1032714.69,1032714.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','167',3684,'25','2',876816.21,878298.56,1482.35,1200703.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','167',3685,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','167',3686,'27','2',599519.54,601276.24,1756.70,1422927.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','167',3687,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','167',3688,'29','3',269366.40,269446.45,80.05,68045.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','167',3689,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','168',3690,'1','1',1378780.36,1383972.16,5191.80,934524.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','168',3691,'2','1',1176471.82,1180446.75,3974.93,715487.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','168',3692,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','168',3693,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','168',3694,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','168',3695,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','168',3696,'7','1',1221549.08,1226028.70,4479.62,806331.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','168',3697,'8','1',1171980.97,1176072.65,4091.68,736502.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','168',3698,'17','1',892068.94,895223.12,3154.18,567752.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','168',3699,'18','1',950192.23,952963.97,2771.74,498913.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','168',3700,'19','1',975328.74,975446.15,117.41,21133.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','168',3701,'20','1',1129661.66,1129855.22,193.56,34840.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','168',3702,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','168',3703,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','168',3704,'23','1',980187.32,983497.73,3310.41,595873.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','168',3705,'24','1',1032714.69,1035990.23,3275.54,589597.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','168',3706,'25','2',878298.56,879303.99,1005.43,814398.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','168',3707,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','168',3708,'27','2',601276.24,603993.95,2717.71,2201345.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','168',3709,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','168',3710,'29','3',269446.45,269546.94,100.48,85412.25,0.00,0.00,0.00,0.00,0.00),('21','226','4','168',3711,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','169',3712,'1','1',1383972.16,1388614.95,4642.79,835702.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','169',3713,'2','1',1180446.75,1184669.11,4222.36,760024.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','169',3714,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','169',3715,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','169',3716,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','169',3717,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','169',3718,'7','1',1226028.70,1230761.57,4732.87,851916.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','169',3719,'8','1',1176072.65,1180912.31,4839.66,871138.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','169',3720,'17','1',895223.12,895223.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','169',3721,'18','1',952963.97,952963.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','169',3722,'19','1',975446.15,975446.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','169',3723,'20','1',1129855.22,1129855.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','169',3724,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','169',3725,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','169',3726,'23','1',983497.73,984457.89,960.16,172828.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','169',3727,'24','1',1035990.23,1037077.50,1087.27,195708.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','169',3728,'25','2',879303.99,881827.42,2523.43,2043978.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','169',3729,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','169',3730,'27','2',603993.95,605340.84,1346.89,1090980.90,0.00,0.00,0.00,0.00,0.00),('21','226','3','169',3731,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','169',3732,'29','3',269546.94,269736.36,189.42,161007.85,0.00,0.00,0.00,0.00,0.00),('21','226','4','169',3733,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','170',3734,'1','1',1388614.95,1388614.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','170',3735,'2','1',1184669.11,1184669.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','170',3736,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','170',3737,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','170',3738,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','170',3739,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','170',3740,'7','1',1230761.57,1230761.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','170',3741,'8','1',1180912.31,1180912.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','170',3742,'17','1',895223.12,895223.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','170',3743,'18','1',952963.97,952963.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','170',3744,'19','1',975446.15,975446.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','170',3745,'20','1',1129855.22,1129855.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','170',3746,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','170',3747,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','170',3748,'23','1',984457.89,984457.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','170',3749,'24','1',1037077.50,1037077.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','170',3750,'25','2',881827.42,883122.13,1294.71,1048715.10,0.00,0.00,0.00,0.00,0.00),('21','226','3','170',3751,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','170',3752,'27','2',605340.84,607094.89,1754.05,1420780.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','170',3753,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','170',3754,'29','3',269736.36,269848.03,111.67,94922.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','170',3755,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','171',3756,'1','1',1388614.95,1392100.06,3485.11,627319.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','171',3757,'2','1',1184669.11,1187468.48,2799.37,503886.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','171',3758,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','171',3759,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','171',3760,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','171',3761,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','171',3762,'7','1',1230761.57,1235813.26,5051.69,909304.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','171',3763,'8','1',1180912.31,1184618.63,3706.32,667137.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','171',3764,'17','1',895223.12,895223.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','171',3765,'18','1',952963.97,952963.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','171',3766,'19','1',975446.15,979475.12,4028.97,725214.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','171',3767,'20','1',1129855.22,1133378.27,3523.05,634149.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','171',3768,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','171',3769,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','171',3770,'23','1',984457.89,988008.92,3551.03,639185.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','171',3771,'24','1',1037077.50,1040846.67,3769.17,678450.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','171',3772,'25','2',883122.13,884926.66,1804.53,1461669.30,0.00,0.00,0.00,0.00,0.00),('21','226','3','171',3773,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','171',3774,'27','2',607094.89,609113.37,2018.48,1634968.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','171',3775,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','171',3776,'29','3',269848.03,269945.41,97.38,82769.60,0.00,0.00,0.00,0.00,0.00),('21','226','4','171',3777,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','172',3778,'1','1',1392100.06,1392100.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','172',3779,'2','1',1187468.48,1187468.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','172',3780,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','172',3781,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','172',3782,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','172',3783,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','172',3784,'7','1',1235813.26,1235813.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','172',3785,'8','1',1184618.63,1184618.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','172',3786,'17','1',895223.12,895223.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','172',3787,'18','1',952963.97,952963.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','172',3788,'19','1',979475.12,979475.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','172',3789,'20','1',1133378.27,1133378.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','172',3790,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','172',3791,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','172',3792,'23','1',988008.92,988008.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','172',3793,'24','1',1040846.67,1040846.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','172',3794,'25','2',884926.66,884926.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','172',3795,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','172',3796,'27','2',609113.37,609113.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','172',3797,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','172',3798,'29','3',269945.41,269992.88,47.47,40351.20,0.00,0.00,0.00,0.00,0.00),('21','226','4','172',3799,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','173',3800,'1','1',1392100.06,1392100.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','173',3801,'2','1',1187468.48,1187468.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','173',3802,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','173',3803,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','173',3804,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','173',3805,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','173',3806,'7','1',1235813.26,1235813.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','173',3807,'8','1',1184618.63,1184618.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','173',3808,'17','1',895223.12,895223.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','173',3809,'18','1',952963.97,952963.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','173',3810,'19','1',979475.12,979475.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','173',3811,'20','1',1133378.27,1133378.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','173',3812,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','173',3813,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','173',3814,'23','1',988008.92,988008.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','173',3815,'24','1',1040846.67,1040846.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','173',3816,'25','2',884926.66,886746.01,1819.35,1473673.50,0.00,0.00,0.00,0.00,0.00),('21','226','3','173',3817,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','173',3818,'27','2',609113.37,610792.95,1679.58,1360459.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','173',3819,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','173',3820,'29','3',269992.88,270049.30,56.42,48521.20,0.00,0.00,0.00,0.00,0.00),('21','226','4','173',3821,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','174',3822,'1','1',1392100.06,1392100.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','174',3823,'2','1',1187468.48,1187468.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','174',3824,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','174',3825,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','174',3826,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','174',3827,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','174',3828,'7','1',1235813.26,1235813.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','174',3829,'8','1',1184618.63,1184618.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','174',3830,'17','1',895223.12,895223.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','174',3831,'18','1',952963.97,952963.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','174',3832,'19','1',979475.12,979475.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','174',3833,'20','1',1133378.27,1133378.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','174',3834,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','174',3835,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','174',3836,'23','1',988008.92,988008.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','174',3837,'24','1',1040846.67,1040846.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','174',3838,'25','2',886746.01,886824.44,78.43,62744.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','174',3839,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','174',3840,'27','2',610792.95,611201.89,408.94,327152.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','174',3841,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','174',3842,'29','3',270049.30,270049.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','174',3843,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','175',3844,'1','1',1392100.06,1392100.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','175',3845,'2','1',1187468.48,1187468.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','175',3846,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','175',3847,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','175',3848,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','175',3849,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','175',3850,'7','1',1235813.26,1235813.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','175',3851,'8','1',1184618.63,1184618.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','175',3852,'17','1',895223.12,895331.04,107.92,19425.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','175',3853,'18','1',952963.97,953063.28,99.31,17875.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','175',3854,'19','1',979475.12,979621.96,146.84,26431.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','175',3855,'20','1',1133378.27,1133584.11,205.84,37051.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','175',3856,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','175',3857,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','175',3858,'23','1',988008.92,988008.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','175',3859,'24','1',1040846.67,1040846.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','175',3860,'25','2',886824.44,886824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','175',3861,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','175',3862,'27','2',611201.89,611201.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','175',3863,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','175',3864,'29','3',270049.30,270049.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','175',3865,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','176',3866,'1','1',1392100.06,1392100.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','176',3867,'2','1',1187468.48,1187468.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','176',3868,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','176',3869,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','176',3870,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','176',3871,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','176',3872,'7','1',1235813.26,1235813.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','176',3873,'8','1',1184618.63,1184618.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','176',3874,'17','1',895331.04,895331.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','176',3875,'18','1',953063.28,953063.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','176',3876,'19','1',979621.96,979621.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','176',3877,'20','1',1133584.11,1133584.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','176',3878,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','176',3879,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','176',3880,'23','1',988008.92,988008.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','176',3881,'24','1',1040846.67,1040846.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','176',3882,'25','2',886824.44,888308.34,1483.90,1187120.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','176',3883,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','176',3884,'27','2',611201.89,613488.94,2287.05,1829640.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','176',3885,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','176',3886,'29','3',270049.30,270159.67,110.37,94920.78,0.00,0.00,0.00,0.00,0.00),('21','226','4','176',3887,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','177',3888,'1','1',1392100.06,1392100.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','177',3889,'2','1',1187468.48,1187468.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','177',3890,'3','1',1836130.00,1836130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','177',3891,'4','1',1349471.19,1349471.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','177',3892,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','177',3893,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','177',3894,'7','1',1235813.26,1235813.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','177',3895,'8','1',1184618.63,1184618.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','177',3896,'17','1',895331.04,895331.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','177',3897,'18','1',953063.28,953063.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','177',3898,'19','1',979621.96,979621.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','177',3899,'20','1',1133584.11,1133584.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','177',3900,'21','1',813836.87,813836.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','177',3901,'22','1',1063369.85,1063369.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','177',3902,'23','1',988008.92,988008.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','177',3903,'24','1',1040846.67,1040846.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','177',3904,'25','2',888308.34,889006.42,698.08,558464.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','177',3905,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','177',3906,'27','2',613488.94,614772.28,1283.34,1026672.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','177',3907,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','177',3908,'29','3',270159.67,270246.89,87.22,75011.78,0.00,0.00,0.00,0.00,0.00),('21','226','4','177',3909,'30','3',91267.25,91267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','178',3910,'1','1',1392100.06,1396189.18,4089.12,736041.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','178',3911,'2','1',1187468.48,1190963.57,3495.09,629116.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','178',3912,'3','1',1836130.00,1838053.35,1923.35,346203.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','178',3913,'4','1',1349471.19,1349472.25,1.06,190.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','178',3914,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','178',3915,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','178',3916,'7','1',1235813.26,1239483.16,3669.90,660582.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','178',3917,'8','1',1184618.63,1187378.67,2760.04,496807.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','178',3918,'17','1',895331.04,896544.06,1213.02,218343.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','178',3919,'18','1',953063.28,953988.79,925.51,166591.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','178',3920,'19','1',979621.96,980687.58,1065.62,191811.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','178',3921,'20','1',1133584.11,1134853.03,1268.92,228405.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','178',3922,'21','1',813836.87,814568.93,732.06,131770.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','178',3923,'22','1',1063369.85,1064530.03,1160.18,208832.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','178',3924,'23','1',988008.92,990915.88,2906.96,523252.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','178',3925,'24','1',1040846.67,1043449.38,2602.71,468487.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','178',3926,'25','2',889006.42,889759.33,752.91,602328.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','178',3927,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','178',3928,'27','2',614772.28,617858.81,3086.53,2469224.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','178',3929,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','178',3930,'29','3',270246.89,272047.22,1800.33,1548286.38,0.00,0.00,0.00,0.00,0.00),('21','226','4','178',3931,'30','3',91267.25,91278.01,10.76,9252.74,0.00,0.00,0.00,0.00,0.00),('21','226','1','179',3932,'1','1',1396189.18,1400556.34,4367.16,786088.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','179',3933,'2','1',1190963.57,1194255.77,3292.20,592596.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','179',3934,'3','1',1838053.35,1838053.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','179',3935,'4','1',1349472.25,1349472.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','179',3936,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','179',3937,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','179',3938,'7','1',1239483.16,1243772.77,4289.61,772129.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','179',3939,'8','1',1187378.67,1190467.65,3088.98,556016.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','179',3940,'17','1',896544.06,897035.35,491.29,88432.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','179',3941,'18','1',953988.79,954499.01,510.22,91839.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','179',3942,'19','1',980687.58,984369.96,3682.38,662828.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','179',3943,'20','1',1134853.03,1138183.30,3330.27,599448.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','179',3944,'21','1',814568.93,814805.24,236.31,42535.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','179',3945,'22','1',1064530.03,1064845.25,315.22,56739.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','179',3946,'23','1',990915.88,993232.01,2316.13,416903.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','179',3947,'24','1',1043449.38,1046160.17,2710.79,487942.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','179',3948,'25','2',889759.33,891668.71,1909.38,1527504.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','179',3949,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','179',3950,'27','2',617858.81,621334.42,3475.61,2780488.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','179',3951,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','179',3952,'29','3',272047.22,272196.47,149.25,128350.70,0.00,0.00,0.00,0.00,0.00),('21','226','4','179',3953,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','180',3954,'1','1',1400556.34,1404596.59,4040.25,727245.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','180',3955,'2','1',1194255.77,1197083.72,2827.95,509031.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','180',3956,'3','1',1838053.35,1839725.56,1672.21,300997.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','180',3957,'4','1',1349472.25,1349472.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','180',3958,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','180',3959,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','180',3960,'7','1',1243772.77,1246799.66,3026.89,544840.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','180',3961,'8','1',1190467.65,1192636.31,2168.66,390358.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','180',3962,'17','1',897035.35,898251.00,1215.65,218817.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','180',3963,'18','1',954499.01,955313.83,814.82,146667.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','180',3964,'19','1',984369.96,986759.75,2389.79,430162.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','180',3965,'20','1',1138183.30,1140391.33,2208.03,397445.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','180',3966,'21','1',814805.24,815851.97,1046.73,188411.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','180',3967,'22','1',1064845.25,1065618.49,773.24,139183.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','180',3968,'23','1',993232.01,995135.05,1903.04,342547.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','180',3969,'24','1',1046160.17,1048313.78,2153.61,387649.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','180',3970,'25','2',891668.71,892795.99,1127.28,901824.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','180',3971,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','180',3972,'27','2',621334.42,622840.14,1505.72,1204576.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','180',3973,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','180',3974,'29','3',272196.47,272303.26,106.79,91835.96,0.00,0.00,0.00,0.00,0.00),('21','226','4','180',3975,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','181',3976,'1','1',1404596.59,1408309.01,3712.42,668235.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','181',3977,'2','1',1197083.72,1199023.48,1939.76,349156.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','181',3978,'3','1',1839725.56,1843635.43,3909.87,703776.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','181',3979,'4','1',1349472.25,1350339.82,867.57,156162.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','181',3980,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','181',3981,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','181',3982,'7','1',1246799.66,1249488.03,2688.37,483906.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','181',3983,'8','1',1192636.31,1194307.34,1671.03,300785.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','181',3984,'17','1',898251.00,900441.49,2190.49,394288.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','181',3985,'18','1',955313.83,957597.93,2284.10,411138.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','181',3986,'19','1',986759.75,988925.61,2165.86,389854.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','181',3987,'20','1',1140391.33,1142593.96,2202.63,396473.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','181',3988,'21','1',815851.97,817533.59,1681.62,302691.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','181',3989,'22','1',1065618.49,1067498.03,1879.54,338317.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','181',3990,'23','1',995135.05,997252.89,2117.84,381211.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','181',3991,'24','1',1048313.78,1050149.99,1836.21,330517.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','181',3992,'25','2',892795.99,895187.39,2391.40,1913120.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','181',3993,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','181',3994,'27','2',622840.14,623341.08,500.94,400752.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','181',3995,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','181',3996,'29','3',272303.26,272381.14,77.88,66977.66,0.00,0.00,0.00,0.00,0.00),('21','226','4','181',3997,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','182',3998,'1','1',1408309.01,1412205.03,3896.02,701283.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','182',3999,'2','1',1199023.48,1201324.73,2301.25,414225.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','182',4000,'3','1',1843635.43,1847615.75,3980.32,716457.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','182',4001,'4','1',1350339.82,1351179.44,839.62,151131.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','182',4002,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','182',4003,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','182',4004,'7','1',1249488.03,1252187.15,2699.12,485841.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','182',4005,'8','1',1194307.34,1195886.91,1579.57,284322.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','182',4006,'17','1',900441.49,903133.13,2691.64,484495.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','182',4007,'18','1',957597.93,959992.02,2394.09,430936.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','182',4008,'19','1',988925.61,991328.32,2402.71,432487.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','182',4009,'20','1',1142593.96,1144807.83,2213.87,398496.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','182',4010,'21','1',817533.59,819278.94,1745.35,314163.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','182',4011,'22','1',1067498.03,1069805.80,2307.77,415398.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','182',4012,'23','1',997252.89,998683.17,1430.28,257450.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','182',4013,'24','1',1050149.99,1052765.65,2615.66,470818.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','182',4014,'25','2',895187.39,896347.16,1159.77,927816.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','182',4015,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','182',4016,'27','2',623341.08,626098.39,2757.31,2205848.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','182',4017,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','182',4018,'29','3',272381.14,272465.56,84.42,72598.62,0.00,0.00,0.00,0.00,0.00),('21','226','4','182',4019,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','183',4020,'1','1',1412205.03,1412568.62,363.59,65446.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','183',4021,'2','1',1201324.73,1201574.49,249.76,44956.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','183',4022,'3','1',1847615.75,1847963.75,348.00,62640.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','183',4023,'4','1',1351179.44,1351179.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','183',4024,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','183',4025,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','183',4026,'7','1',1252187.15,1252187.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','183',4027,'8','1',1195886.91,1195886.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','183',4028,'17','1',903133.13,903133.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','183',4029,'18','1',959992.02,959992.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','183',4030,'19','1',991328.32,991328.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','183',4031,'20','1',1144807.83,1144807.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','183',4032,'21','1',819278.94,819278.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','183',4033,'22','1',1069805.80,1069805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','183',4034,'23','1',998683.17,998683.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','183',4035,'24','1',1052765.65,1052765.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','183',4036,'25','2',896347.16,896747.16,400.00,320000.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','183',4037,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','183',4038,'27','2',626098.39,628755.32,2656.93,2125544.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','183',4039,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','183',4040,'29','3',272465.56,272577.44,111.88,96213.36,0.00,0.00,0.00,0.00,0.00),('21','226','4','183',4041,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','184',4042,'1','1',1412568.62,1415554.00,2985.38,537368.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','184',4043,'2','1',1201574.49,1203247.95,1673.46,301222.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','184',4044,'3','1',1847963.75,1851686.14,3722.39,670030.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','184',4045,'4','1',1351179.44,1353264.38,2084.94,375289.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','184',4046,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','184',4047,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','184',4048,'7','1',1252187.15,1254919.95,2732.80,491904.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','184',4049,'8','1',1195886.91,1198264.79,2377.88,428018.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','184',4050,'17','1',903133.13,905216.97,2083.84,375091.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','184',4051,'18','1',959992.02,961424.76,1432.74,257893.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','184',4052,'19','1',991328.32,993261.15,1932.83,347909.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','184',4053,'20','1',1144807.83,1147353.06,2545.23,458141.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','184',4054,'21','1',819278.94,820903.85,1624.91,292483.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','184',4055,'22','1',1069805.80,1071796.68,1990.88,358358.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','184',4056,'23','1',998683.17,1000107.56,1424.39,256390.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','184',4057,'24','1',1052765.65,1054704.49,1938.84,348991.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','184',4058,'25','2',896747.16,897993.48,1246.32,997056.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','184',4059,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','184',4060,'27','2',628755.32,632221.24,3465.92,2772736.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','184',4061,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','184',4062,'29','3',272577.44,272671.73,94.29,81087.68,0.00,0.00,0.00,0.00,0.00),('21','226','4','184',4063,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','185',4064,'1','1',1415554.00,1415554.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','185',4065,'2','1',1203247.95,1203247.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','185',4066,'3','1',1851686.14,1851686.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','185',4067,'4','1',1353264.38,1353264.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','185',4068,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','185',4069,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','185',4070,'7','1',1254919.95,1254919.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','185',4071,'8','1',1198264.79,1198264.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','185',4072,'17','1',905216.97,905216.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','185',4073,'18','1',961424.76,961424.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','185',4074,'19','1',993261.15,993261.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','185',4075,'20','1',1147353.06,1147353.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','185',4076,'21','1',820903.85,820903.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','185',4077,'22','1',1071796.68,1071796.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','185',4078,'23','1',1000107.56,1000107.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','185',4079,'24','1',1054704.49,1054704.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','185',4080,'25','2',897993.48,898462.85,469.37,375496.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','185',4081,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','185',4082,'27','2',632221.24,633928.77,1707.53,1366024.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','185',4083,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','185',4084,'29','3',272671.73,272765.63,93.90,80751.42,0.00,0.00,0.00,0.00,0.00),('21','226','4','185',4085,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','186',4086,'1','1',1415554.00,1415554.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','186',4087,'2','1',1203247.95,1203247.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','186',4088,'3','1',1851686.14,1851686.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','186',4089,'4','1',1353264.38,1353264.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','186',4090,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','186',4091,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','186',4092,'7','1',1254919.95,1254919.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','186',4093,'8','1',1198264.79,1198264.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','186',4094,'17','1',905216.97,905216.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','186',4095,'18','1',961424.76,961424.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','186',4096,'19','1',993261.15,993261.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','186',4097,'20','1',1147353.06,1147353.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','186',4098,'21','1',820903.85,820903.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','186',4099,'22','1',1071796.68,1071796.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','186',4100,'23','1',1000107.56,1000107.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','186',4101,'24','1',1054704.49,1054704.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','186',4102,'25','2',898462.85,899527.22,1064.37,851496.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','186',4103,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','186',4104,'27','2',633928.77,635489.86,1561.09,1248872.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','186',4105,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','186',4106,'29','3',272765.63,273006.19,240.56,206879.88,0.00,0.00,0.00,0.00,0.00),('21','226','4','186',4107,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','187',4108,'1','1',1415554.00,1420613.86,5059.86,910774.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','187',4109,'2','1',1203247.95,1206908.02,3660.07,658812.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','187',4110,'3','1',1851686.14,1855583.27,3897.13,701483.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','187',4111,'4','1',1353264.38,1355811.70,2547.32,458517.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','187',4112,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','187',4113,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','187',4114,'7','1',1254919.95,1258588.91,3668.96,660412.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','187',4115,'8','1',1198264.79,1201595.05,3330.26,599446.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','187',4116,'17','1',905216.97,907748.27,2531.30,455634.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','187',4117,'18','1',961424.76,963398.77,1974.01,355321.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','187',4118,'19','1',993261.15,994703.11,1441.96,259552.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','187',4119,'20','1',1147353.06,1149301.64,1948.58,350744.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','187',4120,'21','1',820903.85,822272.71,1368.86,246394.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','187',4121,'22','1',1071796.68,1072720.37,923.69,166264.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','187',4122,'23','1',1000107.56,1002071.35,1963.79,353482.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','187',4123,'24','1',1054704.49,1056516.83,1812.34,326221.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','187',4124,'25','2',899527.22,899592.24,65.02,52016.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','187',4125,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','187',4126,'27','2',635489.86,637115.57,1625.71,1300568.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','187',4127,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','187',4128,'29','3',273006.19,273122.07,115.88,99660.24,0.00,0.00,0.00,0.00,0.00),('21','226','4','187',4129,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','188',4130,'1','1',1420613.86,1420613.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','188',4131,'2','1',1206908.02,1206908.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','188',4132,'3','1',1855583.27,1855583.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','188',4133,'4','1',1355811.70,1355811.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','188',4134,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','188',4135,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','188',4136,'7','1',1258588.91,1263089.12,4500.21,810037.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','188',4137,'8','1',1201595.05,1205187.11,3592.06,646570.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','188',4138,'17','1',907748.27,907748.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','188',4139,'18','1',963398.77,963398.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','188',4140,'19','1',994703.11,994703.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','188',4141,'20','1',1149301.64,1149301.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','188',4142,'21','1',822272.71,823006.01,733.30,131994.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','188',4143,'22','1',1072720.37,1073204.15,483.78,87080.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','188',4144,'23','1',1002071.35,1002071.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','188',4145,'24','1',1056516.83,1056516.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','188',4146,'25','2',899592.24,901583.72,1991.48,1593184.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','188',4147,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','188',4148,'27','2',637115.57,638510.98,1395.41,1116328.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','188',4149,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','188',4150,'29','3',273122.07,273249.35,127.28,109459.94,0.00,0.00,0.00,0.00,0.00),('21','226','4','188',4151,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','189',4152,'1','1',1420613.86,1424000.31,3386.45,609561.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','189',4153,'2','1',1206908.02,1208840.36,1932.34,347821.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','189',4154,'3','1',1855583.27,1860267.08,4683.81,843085.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','189',4155,'4','1',1355811.70,1358123.62,2311.92,416145.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','189',4156,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','189',4157,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','189',4158,'7','1',1263089.12,1266021.28,2932.16,527788.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','189',4159,'8','1',1205187.11,1207399.79,2212.68,398282.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','189',4160,'17','1',907748.27,909803.80,2055.53,369995.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','189',4161,'18','1',963398.77,965109.98,1711.21,308017.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','189',4162,'19','1',994703.11,996441.69,1738.58,312944.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','189',4163,'20','1',1149301.64,1151203.08,1901.44,342259.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','189',4164,'21','1',823006.01,824347.36,1341.35,241443.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','189',4165,'22','1',1073204.15,1074631.23,1427.08,256874.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','189',4166,'23','1',1002071.35,1003714.69,1643.34,295801.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','189',4167,'24','1',1056516.83,1058322.03,1805.20,324936.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','189',4168,'25','2',901583.72,902296.58,712.86,570288.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','189',4169,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','189',4170,'27','2',638510.98,640326.47,1815.49,1452392.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','189',4171,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','189',4172,'29','3',273249.35,273336.23,86.88,74714.22,0.00,0.00,0.00,0.00,0.00),('21','226','4','189',4173,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','190',4174,'1','1',1424000.31,1428367.82,4367.51,786151.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','190',4175,'2','1',1208840.36,1211901.48,3061.12,551001.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','190',4176,'3','1',1860267.08,1862783.10,2516.02,452883.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','190',4177,'4','1',1358123.62,1359557.66,1434.04,258127.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','190',4178,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','190',4179,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','190',4180,'7','1',1266021.28,1269329.07,3307.79,595402.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','190',4181,'8','1',1207399.79,1210533.81,3134.02,564123.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','190',4182,'17','1',909803.80,911550.62,1746.82,314427.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','190',4183,'18','1',965109.98,966201.88,1091.90,196542.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','190',4184,'19','1',996441.69,997723.61,1281.92,230745.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','190',4185,'20','1',1151203.08,1152353.01,1149.93,206987.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','190',4186,'21','1',824347.36,825427.81,1080.45,194481.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','190',4187,'22','1',1074631.23,1076173.83,1542.60,277668.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','190',4188,'23','1',1003714.69,1005235.94,1521.25,273825.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','190',4189,'24','1',1058322.03,1059724.53,1402.50,252450.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','190',4190,'25','2',902296.58,903009.29,712.71,570168.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','190',4191,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','190',4192,'27','2',640326.47,642210.42,1883.95,1507160.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','190',4193,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','190',4194,'29','3',273336.23,273503.10,166.86,143503.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','190',4195,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','191',4196,'1','1',1428367.82,1432940.35,4572.53,823055.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','191',4197,'2','1',1211901.48,1215245.61,3344.13,601943.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','191',4198,'3','1',1862783.10,1867057.05,4273.95,769311.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','191',4199,'4','1',1359557.66,1362592.29,3034.63,546233.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','191',4200,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','191',4201,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','191',4202,'7','1',1269329.07,1272290.94,2961.87,533136.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','191',4203,'8','1',1210533.81,1213806.85,3273.04,589147.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','191',4204,'17','1',911550.62,911550.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','191',4205,'18','1',966201.88,966201.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','191',4206,'19','1',997723.61,998627.30,903.69,162664.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','191',4207,'20','1',1152353.01,1153449.00,1095.99,197278.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','191',4208,'21','1',825427.81,825427.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','191',4209,'22','1',1076173.83,1076173.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','191',4210,'23','1',1005235.94,1006377.75,1141.81,205525.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','191',4211,'24','1',1059724.53,1060751.60,1027.07,184872.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','191',4212,'25','2',903009.29,903678.81,669.52,535616.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','191',4213,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','191',4214,'27','2',642210.42,644833.81,2623.39,2098712.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','191',4215,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','191',4216,'29','3',273503.10,273788.93,285.83,245814.66,0.00,0.00,0.00,0.00,0.00),('21','226','4','191',4217,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','192',4218,'1','1',1432940.35,1437132.06,4191.71,754507.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','192',4219,'2','1',1215245.61,1218024.04,2778.43,500117.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','192',4220,'3','1',1867057.05,1871449.97,4392.92,790725.42,0.00,0.00,0.00,0.00,0.00),('21','226','1','192',4221,'4','1',1362592.29,1365150.80,2558.51,460531.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','192',4222,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','192',4223,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','192',4224,'7','1',1272290.94,1276090.65,3799.71,683947.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','192',4225,'8','1',1213806.85,1217456.85,3650.00,657000.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','192',4226,'17','1',911550.62,913875.25,2324.63,418433.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','192',4227,'18','1',966201.88,968137.08,1935.20,348336.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','192',4228,'19','1',998627.30,1000906.42,2279.12,410241.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','192',4229,'20','1',1153449.00,1154944.35,1495.35,269163.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','192',4230,'21','1',825427.81,827010.98,1583.17,284970.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','192',4231,'22','1',1076173.83,1078007.08,1833.25,329985.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','192',4232,'23','1',1006377.75,1008387.06,2009.31,361675.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','192',4233,'24','1',1060751.60,1062321.79,1570.19,282634.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','192',4234,'25','2',903678.81,904933.92,1255.11,1004088.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','192',4235,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','192',4236,'27','2',644833.81,646712.04,1878.23,1502584.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','192',4237,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','192',4238,'29','3',273788.93,273922.47,133.54,114844.40,0.00,0.00,0.00,0.00,0.00),('21','226','4','192',4239,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','193',4240,'1','1',1437132.06,1441750.06,4618.00,831240.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','193',4241,'2','1',1218024.04,1221274.56,3250.52,585093.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','193',4242,'3','1',1871449.97,1876334.63,4884.66,879238.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','193',4243,'4','1',1365150.80,1368572.51,3421.71,615907.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','193',4244,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','193',4245,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','193',4246,'7','1',1276090.65,1279139.54,3048.89,548800.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','193',4247,'8','1',1217456.85,1219546.60,2089.75,376155.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','193',4248,'17','1',913875.25,916067.59,2192.34,394621.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','193',4249,'18','1',968137.08,970090.65,1953.57,351642.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','193',4250,'19','1',1000906.42,1003094.78,2188.36,393904.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','193',4251,'20','1',1154944.35,1156550.93,1606.58,289184.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','193',4252,'21','1',827010.98,828964.02,1953.04,351547.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','193',4253,'22','1',1078007.08,1079898.86,1891.78,340520.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','193',4254,'23','1',1008387.06,1010462.07,2075.01,373501.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','193',4255,'24','1',1062321.79,1064588.34,2266.55,407979.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','193',4256,'25','2',904933.92,905791.18,857.26,685808.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','193',4257,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','193',4258,'27','2',646712.04,650357.89,3645.85,2916680.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','193',4259,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','193',4260,'29','3',273922.47,274048.26,125.79,108177.68,0.00,0.00,0.00,0.00,0.00),('21','226','4','193',4261,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','194',4262,'1','1',1441750.06,1441750.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','194',4263,'2','1',1221274.56,1221274.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','194',4264,'3','1',1876334.63,1876334.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','194',4265,'4','1',1368572.51,1368572.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','194',4266,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','194',4267,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','194',4268,'7','1',1279139.54,1279139.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','194',4269,'8','1',1219546.60,1219546.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','194',4270,'17','1',916067.59,916067.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','194',4271,'18','1',970090.65,970090.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','194',4272,'19','1',1003094.78,1003094.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','194',4273,'20','1',1156550.93,1156550.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','194',4274,'21','1',828964.02,828964.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','194',4275,'22','1',1079898.86,1079898.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','194',4276,'23','1',1010462.07,1010462.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','194',4277,'24','1',1064588.34,1064588.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','194',4278,'25','2',905791.18,906288.11,496.93,397544.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','194',4279,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','194',4280,'27','2',650357.89,652756.75,2398.86,1919088.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','194',4281,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','194',4282,'29','3',274048.26,274267.61,219.35,188637.56,0.00,0.00,0.00,0.00,0.00),('21','226','4','194',4283,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','195',4284,'1','1',1441750.06,1446770.75,5020.69,903724.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','195',4285,'2','1',1221274.56,1224463.43,3188.87,573996.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','195',4286,'3','1',1876334.63,1882355.54,6020.91,1083763.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','195',4287,'4','1',1368572.51,1368988.68,416.17,74910.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','195',4288,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','195',4289,'6','1',1213170.32,1213170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','195',4290,'7','1',1279139.54,1283006.91,3867.37,696126.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','195',4291,'8','1',1219546.60,1222541.01,2994.41,538993.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','195',4292,'17','1',916067.59,918170.73,2103.14,378565.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','195',4293,'18','1',970090.65,972081.01,1990.36,358264.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','195',4294,'19','1',1003094.78,1005120.21,2025.43,364577.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','195',4295,'20','1',1156550.93,1158365.31,1814.38,326588.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','195',4296,'21','1',828964.02,830262.75,1298.73,233771.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','195',4297,'22','1',1079898.86,1081802.86,1904.00,342720.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','195',4298,'23','1',1010462.07,1011903.32,1441.25,259425.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','195',4299,'24','1',1064588.34,1066917.21,2328.87,419196.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','195',4300,'25','2',906288.11,907047.75,759.64,607712.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','195',4301,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','195',4302,'27','2',652756.75,656806.42,4049.67,3239736.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','195',4303,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','195',4304,'29','3',274267.61,274399.37,131.76,113316.18,0.00,0.00,0.00,0.00,0.00),('21','226','4','195',4305,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','196',4306,'1','1',1446770.75,1451051.33,4280.58,770504.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','196',4307,'2','1',1224463.43,1227265.07,2801.64,504295.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','196',4308,'3','1',1882355.54,1887246.44,4890.90,880362.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','196',4309,'4','1',1368988.68,1370281.45,1292.77,232698.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','196',4310,'5','1',1146147.05,1146147.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','196',4311,'6','1',1213170.32,1216571.50,3401.18,612212.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','196',4312,'7','1',1283006.91,1285679.24,2672.33,481019.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','196',4313,'8','1',1222541.01,1224409.80,1868.79,336382.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','196',4314,'17','1',918170.73,920483.95,2313.22,416379.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','196',4315,'18','1',972081.01,974393.02,2312.01,416161.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','196',4316,'19','1',1005120.21,1007753.60,2633.39,474010.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','196',4317,'20','1',1158365.31,1160697.22,2331.91,419743.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','196',4318,'21','1',830262.75,832682.05,2419.30,435474.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','196',4319,'22','1',1081802.86,1083987.28,2184.42,393195.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','196',4320,'23','1',1011903.32,1013525.52,1622.20,291996.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','196',4321,'24','1',1066917.21,1069619.02,2701.81,486325.80,0.00,0.00,0.00,0.00,0.00),('21','226','3','196',4322,'25','2',907047.75,907520.25,472.50,378000.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','196',4323,'26','2',604948.82,604948.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','196',4324,'27','2',656806.42,659544.33,2737.91,2190328.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','196',4325,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','196',4326,'29','3',274399.37,274540.32,140.95,121214.42,0.00,0.00,0.00,0.00,0.00),('21','226','4','196',4327,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','197',4328,'1','1',1451051.33,1455727.44,4676.11,841699.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','197',4329,'2','1',1227265.07,1229967.45,2702.38,486428.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','197',4330,'3','1',1887246.44,1890624.31,3377.87,608016.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','197',4331,'4','1',1370281.45,1371594.95,1313.50,236430.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','197',4332,'5','1',1146147.05,1146455.67,308.62,55551.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','197',4333,'6','1',1216571.50,1219389.54,2818.04,507247.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','197',4334,'7','1',1285679.24,1288573.12,2893.88,520898.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','197',4335,'8','1',1224409.80,1225999.68,1589.88,286178.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','197',4336,'17','1',920483.95,923093.11,2609.16,469648.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','197',4337,'18','1',974393.02,976341.58,1948.56,350740.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','197',4338,'19','1',1007753.60,1009800.01,2046.41,368353.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','197',4339,'20','1',1160697.22,1162640.00,1942.78,349700.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','197',4340,'21','1',832682.05,835118.49,2436.44,438559.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','197',4341,'22','1',1083987.28,1085900.70,1913.42,344415.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','197',4342,'23','1',1013525.52,1015505.25,1979.73,356351.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','197',4343,'24','1',1069619.02,1071752.11,2133.09,383956.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','197',4344,'25','2',907520.25,908749.50,1229.25,983400.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','197',4345,'26','2',604948.82,604990.66,41.84,33472.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','197',4346,'27','2',659544.33,661864.68,2320.35,1856280.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','197',4347,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','197',4348,'29','3',274540.32,274700.88,160.56,138084.18,0.00,0.00,0.00,0.00,0.00),('21','226','4','197',4349,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','198',4350,'1','1',1455727.44,1460105.71,4378.27,788088.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','198',4351,'2','1',1229967.45,1232001.00,2033.55,366039.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','198',4352,'3','1',1890624.31,1895161.18,4536.87,816636.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','198',4353,'4','1',1371594.95,1373420.16,1825.21,328537.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','198',4354,'5','1',1146455.67,1149164.34,2708.67,487560.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','198',4355,'6','1',1219389.54,1222222.35,2832.81,509905.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','198',4356,'7','1',1288573.12,1292067.68,3494.56,629020.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','198',4357,'8','1',1225999.68,1228195.96,2196.28,395330.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','198',4358,'17','1',923093.11,925488.58,2395.47,431184.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','198',4359,'18','1',976341.58,978065.61,1724.03,310325.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','198',4360,'19','1',1009800.01,1012265.41,2465.40,443772.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','198',4361,'20','1',1162640.00,1164494.39,1854.39,333790.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','198',4362,'21','1',835118.49,837526.83,2408.34,433501.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','198',4363,'22','1',1085900.70,1087702.36,1801.66,324298.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','198',4364,'23','1',1015505.25,1017145.90,1640.65,295317.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','198',4365,'24','1',1071752.11,1074130.83,2378.72,428169.60,0.00,0.00,0.00,0.00,0.00),('21','226','3','198',4366,'25','2',908749.50,909824.97,1075.47,860376.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','198',4367,'26','2',604990.66,605450.27,459.61,367688.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','198',4368,'27','2',661864.68,664832.10,2967.42,2373936.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','198',4369,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','198',4370,'29','3',274700.88,274781.78,80.90,69569.70,0.00,0.00,0.00,0.00,0.00),('21','226','4','198',4371,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','199',4372,'1','1',1460105.71,1463767.37,3661.66,659098.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','199',4373,'2','1',1232001.00,1233833.15,1832.15,329787.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','199',4374,'3','1',1895161.18,1898806.21,3645.03,656105.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','199',4375,'4','1',1373420.16,1375064.52,1644.36,295984.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','199',4376,'5','1',1149164.34,1152154.71,2990.37,538266.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','199',4377,'6','1',1222222.35,1224764.19,2541.84,457531.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','199',4378,'7','1',1292067.68,1294641.73,2574.05,463329.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','199',4379,'8','1',1228195.96,1230177.99,1982.03,356765.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','199',4380,'17','1',925488.58,926503.22,1014.64,182635.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','199',4381,'18','1',978065.61,978968.50,902.89,162520.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','199',4382,'19','1',1012265.41,1013597.03,1331.62,239691.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','199',4383,'20','1',1164494.39,1165547.05,1052.66,189478.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','199',4384,'21','1',837526.83,838456.89,930.06,167410.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','199',4385,'22','1',1087702.36,1088712.01,1009.65,181737.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','199',4386,'23','1',1017145.90,1017980.95,835.05,150309.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','199',4387,'24','1',1074130.83,1075376.18,1245.35,224163.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','199',4388,'25','2',909824.97,910624.45,799.48,639584.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','199',4389,'26','2',605450.27,605971.51,521.24,416992.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','199',4390,'27','2',664832.10,666934.41,2102.31,1681848.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','199',4391,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','199',4392,'29','3',274781.78,274929.92,148.14,127402.98,0.00,0.00,0.00,0.00,0.00),('21','226','4','199',4393,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','200',4394,'1','1',1463767.37,1463767.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','200',4395,'2','1',1233833.15,1233833.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','200',4396,'3','1',1898806.21,1898806.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','200',4397,'4','1',1375064.52,1375064.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','200',4398,'5','1',1152154.71,1152154.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','200',4399,'6','1',1224764.19,1224764.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','200',4400,'7','1',1294641.73,1294641.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','200',4401,'8','1',1230177.99,1230177.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','200',4402,'17','1',926503.22,926503.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','200',4403,'18','1',978968.50,978968.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','200',4404,'19','1',1013597.03,1013597.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','200',4405,'20','1',1165547.05,1165547.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','200',4406,'21','1',838456.89,838456.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','200',4407,'22','1',1088712.01,1088712.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','200',4408,'23','1',1017980.95,1017980.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','200',4409,'24','1',1075376.18,1075376.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','200',4410,'25','2',910624.45,911570.17,945.72,756576.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','200',4411,'26','2',605971.51,606194.64,223.13,178504.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','200',4412,'27','2',666934.41,669084.21,2149.80,1719840.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','200',4413,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','200',4414,'29','3',274929.92,275051.39,121.47,104463.34,0.00,0.00,0.00,0.00,0.00),('21','226','4','200',4415,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','201',4416,'1','1',1463767.37,1467238.26,3470.89,624760.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','201',4417,'2','1',1233833.15,1235552.60,1719.45,309501.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','201',4418,'3','1',1898806.21,1901650.33,2823.72,508269.60,0.00,0.00,20.40,0.00,0.00),('21','226','1','201',4419,'4','1',1375064.52,1376390.78,1326.26,238726.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','201',4420,'5','1',1152154.71,1154106.03,1930.92,347565.60,0.00,0.00,20.40,0.00,0.00),('21','226','1','201',4421,'6','1',1224764.19,1225871.75,1087.15,195687.00,0.00,0.00,20.41,0.00,0.00),('21','226','1','201',4422,'7','1',1294641.73,1296315.05,1663.11,299359.80,0.00,0.00,10.21,0.00,0.00),('21','226','1','201',4423,'8','1',1230177.99,1231035.22,846.30,152334.00,0.00,0.00,10.93,0.00,0.00),('21','226','2','201',4424,'17','1',926503.22,928498.61,1995.39,359170.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','201',4425,'18','1',978968.50,980238.04,1269.54,228517.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','201',4426,'19','1',1013597.03,1015434.39,1837.36,330724.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','201',4427,'20','1',1165547.05,1167337.57,1790.52,322293.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','201',4428,'21','1',838456.89,840446.49,1989.60,358128.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','201',4429,'22','1',1088712.01,1090977.48,2265.47,407784.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','201',4430,'23','1',1017980.95,1019417.58,1436.63,258593.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','201',4431,'24','1',1075376.18,1077220.92,1844.74,332053.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','201',4432,'25','2',911570.17,912648.38,1078.21,862568.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','201',4433,'26','2',606194.64,607272.47,1077.83,862264.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','201',4434,'27','2',669084.21,671485.93,2401.72,1921376.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','201',4435,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','201',4436,'29','3',275051.39,275206.51,155.11,133398.90,0.00,0.00,0.00,0.00,0.00),('21','226','4','201',4437,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','202',4438,'1','1',1467238.26,1470406.59,3168.33,570299.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','202',4439,'2','1',1235552.60,1236882.72,1330.12,239421.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','202',4440,'3','1',1901650.33,1904326.42,2676.09,481696.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','202',4441,'4','1',1376390.78,1377727.56,1336.78,240620.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','202',4442,'5','1',1154106.03,1155695.29,1589.26,286066.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','202',4443,'6','1',1225871.75,1227291.82,1420.07,255612.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','202',4444,'7','1',1296315.05,1298176.62,1861.57,335082.60,0.00,0.00,0.00,0.00,0.00),('21','226','1','202',4445,'8','1',1231035.22,1231993.82,958.60,172548.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','202',4446,'17','1',928498.61,930153.18,1654.57,297822.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','202',4447,'18','1',980238.04,981711.97,1473.93,265307.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','202',4448,'19','1',1015434.39,1016739.69,1305.30,234954.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','202',4449,'20','1',1167337.57,1168965.71,1628.14,293065.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','202',4450,'21','1',840446.49,841963.90,1517.41,273133.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','202',4451,'22','1',1090977.48,1092642.11,1664.63,299633.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','202',4452,'23','1',1019417.58,1021074.10,1656.52,298173.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','202',4453,'24','1',1077220.92,1078980.96,1760.04,316807.20,0.00,0.00,0.00,0.00,0.00),('21','226','3','202',4454,'25','2',912648.38,913070.13,421.75,337400.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','202',4455,'26','2',607272.47,607666.09,393.62,314896.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','202',4456,'27','2',671485.93,673300.66,1814.73,1451784.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','202',4457,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','202',4458,'29','3',275206.51,275287.95,81.44,70037.54,0.00,0.00,0.00,0.00,0.00),('21','226','4','202',4459,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','1','203',4460,'1','1',1470406.59,1472762.07,2355.48,423986.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','203',4461,'2','1',1236882.72,1238654.00,1771.28,318830.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','203',4462,'3','1',1904326.42,1906969.98,2643.56,475840.80,0.00,0.00,0.00,0.00,0.00),('21','226','1','203',4463,'4','1',1377727.56,1378884.00,1156.44,208159.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','203',4464,'5','1',1155695.29,1157442.63,1747.34,314521.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','203',4465,'6','1',1227291.82,1229212.76,1920.94,345769.20,0.00,0.00,0.00,0.00,0.00),('21','226','1','203',4466,'7','1',1298176.62,1300408.20,2231.58,401684.40,0.00,0.00,0.00,0.00,0.00),('21','226','1','203',4467,'8','1',1231993.82,1233646.36,1652.54,297457.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','203',4468,'17','1',930153.18,930531.08,377.90,68022.00,0.00,0.00,0.00,0.00,0.00),('21','226','2','203',4469,'18','1',981711.97,981846.89,134.92,24285.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','203',4470,'19','1',1016739.69,1017380.96,641.27,115428.60,0.00,0.00,0.00,0.00,0.00),('21','226','2','203',4471,'20','1',1168965.71,1169513.30,547.59,98566.20,0.00,0.00,0.00,0.00,0.00),('21','226','2','203',4472,'21','1',841963.90,842191.46,227.56,40960.80,0.00,0.00,0.00,0.00,0.00),('21','226','2','203',4473,'22','1',1092642.11,1092919.64,277.53,49955.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','203',4474,'23','1',1021074.10,1021659.48,585.38,105368.40,0.00,0.00,0.00,0.00,0.00),('21','226','2','203',4475,'24','1',1078980.96,1079741.44,760.48,136886.40,0.00,0.00,0.00,0.00,0.00),('21','226','3','203',4476,'25','2',913070.13,913832.24,762.11,609688.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','203',4477,'26','2',607666.09,608980.83,1314.74,1051792.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','203',4478,'27','2',673300.66,675396.15,2095.49,1676392.00,0.00,0.00,0.00,0.00,0.00),('21','226','3','203',4479,'28','2',405759.82,405759.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','226','4','203',4480,'29','3',275287.95,275386.25,98.30,84534.56,0.00,0.00,0.00,0.00,0.00),('21','226','4','203',4481,'30','3',91278.01,91278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=610 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','226','6','1',165.00,165.00,7508.08,0.00,0.00,0.00,0.00,16),('21','226','6','2',700.00,700.00,2194.77,0.00,0.00,0.00,0.00,17),('21','226','6','3',550.00,550.00,2379.58,0.00,0.00,0.00,0.00,18),('21','226','7','2',700.00,700.00,2106.54,0.00,0.00,0.00,0.00,19),('21','226','7','3',550.00,550.00,263.43,0.00,0.00,0.00,0.00,20),('21','226','7','1',165.00,165.00,28670.15,0.00,0.00,0.00,0.00,21),('21','226','8','2',700.00,700.00,4224.50,0.00,0.00,0.00,0.00,22),('21','226','8','3',550.00,550.00,1055.95,0.00,0.00,0.00,0.00,23),('21','226','8','1',165.00,165.00,31397.03,0.00,0.00,0.00,0.00,24),('21','226','9','2',700.00,700.00,4012.65,0.00,0.00,0.00,0.00,25),('21','226','9','3',550.00,550.00,457.62,0.00,0.00,0.00,0.00,26),('21','226','9','1',165.00,165.00,24564.56,0.00,0.00,0.00,0.00,27),('21','226','10','2',700.00,700.00,2810.39,0.00,0.00,0.00,0.00,28),('21','226','10','3',550.00,550.00,282.73,0.00,0.00,0.00,0.00,29),('21','226','10','1',165.00,165.00,35761.06,0.00,0.00,0.00,0.00,30),('21','226','11','1',165.00,165.00,18424.76,0.00,0.00,0.00,0.00,31),('21','226','11','2',700.00,700.00,1874.49,0.00,0.00,0.00,0.00,32),('21','226','11','3',550.00,550.00,458.66,0.00,0.00,0.00,0.00,33),('21','226','12','1',165.00,165.00,14275.58,0.00,0.00,0.00,0.00,34),('21','226','12','2',700.00,700.00,2176.76,0.00,0.00,0.00,0.00,35),('21','226','12','3',550.00,550.00,280.55,0.00,0.00,0.00,0.00,36),('21','226','13','1',165.00,165.00,29559.64,0.00,0.00,0.00,0.00,37),('21','226','13','2',700.00,700.00,3180.12,0.00,0.00,0.00,0.00,38),('21','226','13','3',550.00,550.00,403.51,0.00,0.00,0.00,0.00,39),('21','226','14','2',700.00,700.00,1696.57,0.00,0.00,0.00,0.00,40),('21','226','14','3',550.00,550.00,549.83,0.00,0.00,0.00,0.00,41),('21','226','14','1',165.00,165.00,31786.77,0.00,0.00,0.00,0.00,42),('21','226','15','2',700.00,700.00,467.14,0.00,0.00,0.00,0.00,43),('21','226','15','3',550.00,550.00,387.76,0.00,0.00,0.00,0.00,44),('21','226','15','1',165.00,165.00,27627.52,0.00,0.00,0.00,0.00,45),('21','226','16','1',165.00,165.00,23585.04,0.00,0.00,0.00,0.00,46),('21','226','16','2',700.00,700.00,38.26,0.00,0.00,0.00,0.00,47),('21','226','16','3',550.00,550.00,381.88,0.00,0.00,0.00,0.00,48),('21','226','17','1',165.00,165.00,515.98,0.00,0.00,0.00,0.00,49),('21','226','17','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,50),('21','226','17','3',550.00,550.00,503.00,0.00,0.00,0.00,0.00,51),('21','226','18','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,52),('21','226','18','3',550.00,550.00,845.89,0.00,0.00,0.00,0.00,53),('21','226','18','1',165.00,165.00,30097.99,0.00,0.00,0.00,0.00,54),('21','226','19','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,55),('21','226','19','3',550.00,550.00,592.52,0.00,0.00,0.00,0.00,56),('21','226','19','1',165.00,165.00,27936.18,0.00,0.00,0.00,0.00,57),('21','226','20','1',165.00,165.00,39810.29,0.00,0.00,0.00,0.00,58),('21','226','20','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,59),('21','226','20','3',550.00,550.00,548.94,0.00,0.00,0.00,0.00,60),('21','226','21','1',165.00,165.00,30812.64,0.00,0.00,0.00,0.00,61),('21','226','21','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,62),('21','226','21','3',550.00,550.00,138.87,0.00,0.00,0.00,0.00,63),('21','226','22','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,64),('21','226','22','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,65),('21','226','22','1',165.00,165.00,39149.44,0.00,0.00,0.00,0.00,66),('21','226','23','2',700.00,700.00,4834.45,0.00,0.00,0.00,0.00,67),('21','226','23','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,68),('21','226','23','1',165.00,165.00,43635.72,0.00,0.00,0.00,0.00,69),('21','226','24','1',165.00,165.00,50779.95,0.00,0.00,0.00,0.00,70),('21','226','24','2',700.00,700.00,2390.86,0.00,0.00,0.00,0.00,71),('21','226','24','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,72),('21','226','25','1',165.00,165.00,43770.20,0.00,0.00,0.00,0.00,73),('21','226','25','2',700.00,700.00,3116.06,0.00,0.00,0.00,0.00,74),('21','226','25','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,75),('21','226','26','2',700.00,700.00,5129.66,0.00,0.00,0.00,0.00,76),('21','226','26','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,77),('21','226','26','1',165.00,165.00,19986.66,0.00,0.00,0.00,0.00,78),('21','226','27','1',165.00,165.00,26881.97,0.00,0.00,0.00,0.00,79),('21','226','27','2',700.00,700.00,2245.61,0.00,0.00,0.00,0.00,80),('21','226','27','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,81),('21','226','28','1',165.00,165.00,330.94,0.00,0.00,0.00,0.00,82),('21','226','28','2',700.00,700.00,2423.93,0.00,0.00,0.00,0.00,83),('21','226','28','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,84),('21','226','29','2',700.00,700.00,4526.59,0.00,0.00,0.00,0.00,85),('21','226','29','3',550.00,550.00,245.40,0.00,0.00,0.00,0.00,86),('21','226','29','1',165.00,165.00,29960.70,0.00,0.00,0.00,0.00,87),('21','226','30','1',165.00,165.00,32244.76,0.00,0.00,0.00,0.00,88),('21','226','30','2',700.00,700.00,1522.32,0.00,0.00,0.00,0.00,89),('21','226','30','3',550.00,550.00,382.20,0.00,0.00,0.00,0.00,90),('21','226','31','1',165.00,165.00,31836.04,0.00,0.00,0.00,0.00,91),('21','226','31','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,92),('21','226','31','3',550.00,550.00,258.22,0.00,0.00,0.00,0.00,93),('21','226','32','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,94),('21','226','32','3',550.00,550.00,2476.35,0.00,0.00,0.00,0.00,95),('21','226','32','1',165.00,165.00,32785.96,0.00,0.00,0.00,0.00,96),('21','226','33','1',165.00,165.00,30644.01,0.00,0.00,0.00,0.00,97),('21','226','33','2',700.00,700.00,1761.67,0.00,0.00,0.00,0.00,98),('21','226','33','3',550.00,550.00,129.12,0.00,0.00,0.00,0.00,99),('21','226','34','1',165.00,165.00,41133.57,0.00,0.00,0.00,0.00,100),('21','226','34','2',700.00,700.00,2258.98,0.00,0.00,0.00,0.00,101),('21','226','34','3',550.00,550.00,425.13,0.00,0.00,0.00,0.00,102),('21','226','35','1',165.00,165.00,51424.57,0.00,0.00,0.00,0.00,103),('21','226','35','2',700.00,700.00,1679.75,0.00,0.00,0.00,0.00,104),('21','226','35','3',550.00,550.00,385.56,0.00,0.00,0.00,0.00,105),('21','226','36','1',165.00,165.00,44706.14,0.00,0.00,0.00,0.00,106),('21','226','36','2',700.00,700.00,3737.69,0.00,0.00,0.00,0.00,107),('21','226','36','3',550.00,550.00,385.44,0.00,0.00,0.00,0.00,108),('21','226','37','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,109),('21','226','37','2',700.00,700.00,1333.35,0.00,0.00,0.00,0.00,110),('21','226','37','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,111),('21','226','38','2',680.00,680.00,2158.89,0.00,0.00,0.00,0.00,112),('21','226','38','3',550.00,550.00,477.95,0.00,0.00,0.00,0.00,113),('21','226','38','1',165.00,165.00,42947.54,0.00,0.00,0.00,0.00,114),('21','226','39','1',165.00,165.00,46681.06,0.00,0.00,0.00,0.00,115),('21','226','39','2',680.00,680.00,3299.94,0.00,0.00,0.00,0.00,116),('21','226','39','3',550.00,550.00,458.40,0.00,0.00,0.00,0.00,117),('21','226','40','1',165.00,165.00,22932.21,0.00,0.00,0.00,0.00,118),('21','226','40','2',680.00,680.00,5204.49,0.00,0.00,0.00,0.00,119),('21','226','40','3',550.00,550.00,747.44,0.00,0.00,0.00,0.00,120),('21','226','41','2',680.00,680.00,4752.53,0.00,0.00,0.00,0.00,121),('21','226','41','3',550.00,550.00,320.41,0.00,0.00,0.00,0.00,122),('21','226','41','1',165.00,165.00,36719.65,0.00,0.00,0.00,0.00,123),('21','226','42','1',165.00,165.00,3138.91,0.00,0.00,0.00,0.00,124),('21','226','42','2',680.00,680.00,4525.67,0.00,0.00,0.00,0.00,125),('21','226','42','3',550.00,550.00,406.26,0.00,0.00,0.00,0.00,126),('21','226','43','2',680.00,680.00,5143.05,0.00,0.00,0.00,0.00,127),('21','226','43','3',550.00,550.00,1416.09,0.00,0.00,0.00,0.00,128),('21','226','43','1',165.00,165.00,40165.91,0.00,0.00,0.00,0.00,129),('21','226','44','1',165.00,165.00,38334.73,0.00,0.00,0.00,0.00,130),('21','226','44','2',680.00,680.00,4711.55,0.00,0.00,0.00,0.00,131),('21','226','44','3',550.00,550.00,2310.46,0.00,0.00,0.00,0.00,132),('21','226','45','1',165.00,165.00,39374.61,0.00,0.00,0.00,0.00,133),('21','226','45','2',680.00,680.00,4470.40,0.00,0.00,0.00,0.00,134),('21','226','45','3',550.00,550.00,10457.76,0.00,0.00,0.00,0.00,135),('21','226','46','1',165.00,165.00,43783.55,0.00,0.00,0.00,0.00,136),('21','226','46','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,137),('21','226','46','3',550.00,550.00,359.27,0.00,0.00,0.00,0.00,138),('21','226','47','1',165.00,165.00,40318.62,0.00,0.00,0.00,0.00,139),('21','226','47','2',680.00,680.00,188.69,0.00,0.00,0.00,0.00,140),('21','226','47','3',550.00,550.00,695.78,0.00,0.00,0.00,0.00,141),('21','226','48','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,142),('21','226','48','3',550.00,550.00,349.30,0.00,0.00,0.00,0.00,143),('21','226','48','1',165.00,165.00,30294.82,0.00,0.00,0.00,0.00,144),('21','226','49','2',680.00,680.00,144.98,0.00,0.00,0.00,0.00,145),('21','226','49','3',550.00,550.00,260.31,0.00,0.00,0.00,0.00,146),('21','226','49','1',165.00,165.00,17344.82,0.00,0.00,0.00,0.00,147),('21','226','50','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,148),('21','226','50','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,149),('21','226','50','3',550.00,550.00,4100.13,0.00,0.00,0.00,0.00,150),('21','226','51','1',165.00,165.00,39237.05,0.00,0.00,0.00,0.00,151),('21','226','51','2',680.00,680.00,105.02,0.00,0.00,0.00,0.00,152),('21','226','51','3',550.00,550.00,579.51,0.00,0.00,0.00,0.00,153),('21','226','52','1',165.00,165.00,39928.77,0.00,0.00,0.00,0.00,154),('21','226','52','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,155),('21','226','52','3',550.00,550.00,4506.04,0.00,0.00,0.00,0.00,156),('21','226','53','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,157),('21','226','53','3',550.00,550.00,2795.84,0.00,0.00,0.00,0.00,158),('21','226','53','1',165.00,165.00,46242.66,0.00,0.00,0.00,0.00,159),('21','226','54','1',165.00,165.00,54182.94,0.00,0.00,0.00,0.00,160),('21','226','54','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,161),('21','226','54','3',550.00,550.00,1538.37,0.00,0.00,0.00,0.00,162),('21','226','55','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,163),('21','226','55','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,164),('21','226','55','3',650.00,650.00,168.79,0.00,0.00,0.00,0.00,165),('21','226','56','1',165.00,165.00,28804.88,0.00,0.00,0.00,0.00,166),('21','226','56','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,167),('21','226','56','3',650.00,650.00,84.71,0.00,0.00,0.00,0.00,168),('21','226','57','1',165.00,165.00,14696.88,0.00,0.00,0.00,0.00,169),('21','226','57','2',680.00,680.00,4708.03,0.00,0.00,0.00,0.00,170),('21','226','57','3',650.00,650.00,339.36,0.00,0.00,0.00,0.00,171),('21','226','58','1',165.00,165.00,25992.66,0.00,0.00,0.00,0.00,172),('21','226','58','2',680.00,680.00,2930.60,0.00,0.00,0.00,0.00,173),('21','226','58','3',650.00,650.00,1138.98,0.00,0.00,0.00,0.00,174),('21','226','59','1',165.00,165.00,4963.06,0.00,0.00,0.00,0.00,175),('21','226','59','2',680.00,680.00,6649.60,0.00,0.00,0.00,0.00,176),('21','226','59','3',650.00,650.00,300.55,0.00,0.00,0.00,0.00,177),('21','226','60','1',165.00,165.00,2138.22,0.00,0.00,0.00,0.00,178),('21','226','60','2',680.00,680.00,5490.75,0.00,0.00,0.00,0.00,179),('21','226','60','3',650.00,650.00,440.91,0.00,0.00,0.00,0.00,180),('21','226','61','1',165.00,165.00,23744.89,0.00,0.00,0.00,0.00,181),('21','226','61','2',680.00,680.00,4851.55,0.00,0.00,0.00,0.00,182),('21','226','61','3',650.00,650.00,339.19,0.00,0.00,0.00,0.00,183),('21','226','62','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,184),('21','226','62','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,185),('21','226','62','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,186),('21','226','63','2',680.00,680.00,537.06,0.00,0.00,0.00,0.00,187),('21','226','63','3',650.00,650.00,285.56,0.00,0.00,0.00,0.00,188),('21','226','63','1',165.00,165.00,32282.68,0.00,0.00,0.00,0.00,189),('21','226','64','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,190),('21','226','64','2',680.00,680.00,0.00,0.00,0.00,0.00,0.00,191),('21','226','64','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,192),('21','226','65','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,193),('21','226','65','2',720.00,720.00,2415.12,0.00,0.00,0.00,0.00,194),('21','226','65','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,195),('21','226','66','2',720.00,720.00,3845.61,0.00,0.00,0.00,0.00,196),('21','226','66','3',650.00,650.00,260.45,0.00,0.00,0.00,0.00,197),('21','226','66','1',165.00,165.00,34715.70,0.00,0.00,0.00,0.00,198),('21','226','67','2',720.00,720.00,4698.65,0.00,0.00,0.00,0.00,199),('21','226','67','3',650.00,650.00,449.93,0.00,0.00,0.00,0.00,200),('21','226','67','1',165.00,165.00,14952.63,0.00,0.00,0.00,0.00,201),('21','226','68','1',165.00,165.00,37878.24,0.00,0.00,0.00,0.00,202),('21','226','68','2',720.00,720.00,5885.46,0.00,0.00,0.00,0.00,203),('21','226','68','3',650.00,650.00,408.60,0.00,0.00,0.00,0.00,204),('21','226','69','1',165.00,165.00,44163.41,0.00,0.00,0.00,0.00,205),('21','226','69','2',720.00,720.00,4658.85,0.00,0.00,0.00,0.00,206),('21','226','69','3',650.00,650.00,338.30,0.00,0.00,0.00,0.00,207),('21','226','70','1',165.00,165.00,35980.82,0.00,0.00,0.00,0.00,208),('21','226','70','2',720.00,720.00,6096.93,0.00,0.00,0.00,0.00,209),('21','226','70','3',650.00,650.00,306.05,0.00,0.00,0.00,0.00,210),('21','226','71','2',720.00,720.00,1916.89,0.00,0.00,0.00,0.00,211),('21','226','71','3',650.00,650.00,289.32,0.00,0.00,0.00,0.00,212),('21','226','71','1',165.00,165.00,17261.84,0.00,0.00,0.00,0.00,213),('21','226','72','2',720.00,720.00,4626.38,0.00,0.00,0.00,0.00,214),('21','226','72','3',650.00,650.00,270.28,0.00,0.00,0.00,0.00,215),('21','226','72','1',165.00,165.00,34219.35,0.00,0.00,0.00,0.00,216),('21','226','73','2',760.00,760.00,1201.90,0.00,0.00,0.00,0.00,217),('21','226','73','3',650.00,650.00,285.32,0.00,0.00,0.00,0.00,218),('21','226','73','1',165.00,165.00,8335.10,0.00,0.00,0.00,0.00,219),('21','226','74','2',760.00,760.00,1890.07,0.00,0.00,0.00,0.00,220),('21','226','74','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,221),('21','226','74','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,222),('21','226','75','1',165.00,165.00,15463.51,0.00,0.00,0.00,0.00,223),('21','226','75','2',760.00,760.00,3897.10,0.00,0.00,0.00,0.00,224),('21','226','75','3',650.00,650.00,374.48,0.00,0.00,0.00,0.00,225),('21','226','76','2',760.00,760.00,3169.42,0.00,0.00,0.00,0.00,226),('21','226','76','3',650.00,650.00,2001.82,0.00,0.00,0.00,0.00,227),('21','226','76','1',165.00,165.00,31356.27,0.00,0.00,0.00,0.00,228),('21','226','77','2',760.00,760.00,3707.44,0.00,0.00,0.00,0.00,229),('21','226','77','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,230),('21','226','77','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,231),('21','226','78','1',165.00,165.00,49959.25,0.00,0.00,0.00,0.00,232),('21','226','78','2',760.00,760.00,6232.77,0.00,0.00,0.00,0.00,233),('21','226','78','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,234),('21','226','79','1',165.00,165.00,27701.28,0.00,0.00,0.00,0.00,235),('21','226','79','2',760.00,760.00,3223.42,0.00,0.00,0.00,0.00,236),('21','226','79','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,237),('21','226','80','1',165.00,165.00,31897.07,0.00,0.00,0.00,0.00,238),('21','226','80','2',760.00,760.00,3132.63,0.00,0.00,0.00,0.00,239),('21','226','80','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,240),('21','226','81','1',165.00,165.00,8893.52,0.00,0.00,0.00,0.00,241),('21','226','81','2',760.00,760.00,1993.43,0.00,0.00,0.00,0.00,242),('21','226','81','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,243),('21','226','82','2',760.00,760.00,3592.38,0.00,0.00,0.00,0.00,244),('21','226','82','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,245),('21','226','82','1',165.00,165.00,41892.30,0.00,0.00,0.00,0.00,246),('21','226','83','1',165.00,165.00,34318.73,0.00,0.00,0.00,0.00,247),('21','226','83','2',760.00,760.00,3180.77,0.00,0.00,0.00,0.00,248),('21','226','83','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,249),('21','226','84','1',165.00,165.00,25166.57,0.00,0.00,0.00,0.00,250),('21','226','84','2',760.00,760.00,2550.50,0.00,0.00,0.00,0.00,251),('21','226','84','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,252),('21','226','85','1',165.00,165.00,4737.75,0.00,0.00,0.00,0.00,253),('21','226','85','2',760.00,760.00,4465.58,0.00,0.00,0.00,0.00,254),('21','226','85','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,255),('21','226','86','1',165.00,165.00,27709.84,0.00,0.00,0.00,0.00,256),('21','226','86','2',760.00,760.00,5228.89,0.00,0.00,0.00,0.00,257),('21','226','86','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,258),('21','226','87','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,259),('21','226','87','2',760.00,760.00,877.81,0.00,0.00,0.00,0.00,260),('21','226','87','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,261),('21','226','88','2',770.00,770.00,5721.98,0.00,0.00,0.00,0.00,262),('21','226','88','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,263),('21','226','88','1',165.00,165.00,31742.43,0.00,0.00,0.00,0.00,264),('21','226','89','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,265),('21','226','89','2',770.00,770.00,1093.62,0.00,0.00,0.00,0.00,266),('21','226','89','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,267),('21','226','90','1',165.00,165.00,29849.33,0.00,0.00,0.00,0.00,268),('21','226','90','2',770.00,770.00,3947.25,0.00,0.00,0.00,0.00,269),('21','226','90','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,270),('21','226','91','1',165.00,165.00,30037.56,0.00,0.00,0.00,0.00,271),('21','226','91','2',780.00,780.00,4318.16,0.00,0.00,0.00,0.00,272),('21','226','91','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,273),('21','226','92','2',780.00,780.00,2040.82,0.00,0.00,0.00,0.00,274),('21','226','92','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,275),('21','226','92','1',165.00,165.00,29136.23,0.00,0.00,0.00,0.00,276),('21','226','93','1',165.00,165.00,31001.41,0.00,0.00,0.00,0.00,277),('21','226','93','2',780.00,780.00,2322.93,0.00,0.00,0.00,0.00,278),('21','226','93','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,279),('21','226','94','2',800.00,800.00,1589.95,0.00,0.00,0.00,0.00,280),('21','226','94','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,281),('21','226','94','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,282),('21','226','95','1',165.00,165.00,30133.05,0.00,0.00,0.00,0.00,283),('21','226','95','2',800.00,800.00,3906.87,0.00,0.00,0.00,0.00,284),('21','226','95','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,285),('21','226','96','1',165.00,165.00,27087.10,0.00,0.00,0.00,0.00,286),('21','226','96','2',800.00,800.00,2767.31,0.00,0.00,0.00,0.00,287),('21','226','96','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,288),('21','226','97','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,289),('21','226','97','2',800.00,800.00,3149.70,0.00,0.00,0.00,0.00,290),('21','226','97','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,291),('21','226','98','2',820.00,820.00,1532.52,0.00,0.00,0.00,0.00,292),('21','226','98','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,293),('21','226','98','1',165.00,165.00,30221.19,0.00,0.00,0.00,0.00,294),('21','226','99','1',165.00,165.00,27503.96,0.00,0.00,0.00,0.00,295),('21','226','99','2',820.00,820.00,4967.93,0.00,0.00,0.00,0.00,296),('21','226','99','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,297),('21','226','100','1',165.00,165.00,27816.78,0.00,0.00,0.00,0.00,298),('21','226','100','2',820.00,820.00,5160.50,0.00,0.00,0.00,0.00,299),('21','226','100','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,300),('21','226','101','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,301),('21','226','101','2',820.00,820.00,4222.12,0.00,0.00,0.00,0.00,302),('21','226','101','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,303),('21','226','102','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,304),('21','226','102','2',820.00,820.00,3781.59,0.00,0.00,0.00,0.00,305),('21','226','102','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,306),('21','226','103','2',830.00,830.00,2109.28,0.00,0.00,0.00,0.00,307),('21','226','103','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,308),('21','226','103','1',165.00,165.00,32277.89,0.00,0.00,0.00,0.00,309),('21','226','104','1',165.00,165.00,40145.13,0.00,0.00,0.00,0.00,310),('21','226','104','2',830.00,830.00,2158.36,0.00,0.00,0.00,0.00,311),('21','226','104','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,312),('21','226','105','2',830.00,830.00,2719.20,0.00,0.00,0.00,0.00,313),('21','226','105','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,314),('21','226','105','1',165.00,165.00,28041.49,0.00,0.00,0.00,0.00,315),('21','226','106','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,316),('21','226','106','2',830.00,830.00,2792.17,0.00,0.00,0.00,0.00,317),('21','226','106','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,318),('21','226','107','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,319),('21','226','107','2',830.00,830.00,1236.20,0.00,0.00,0.00,0.00,320),('21','226','107','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,321),('21','226','108','1',165.00,165.00,27839.60,0.00,0.00,0.00,0.00,322),('21','226','108','2',830.00,830.00,778.03,0.00,0.00,0.00,0.00,323),('21','226','108','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,324),('21','226','109','1',165.00,165.00,409.70,0.00,0.00,0.00,0.00,325),('21','226','109','2',830.00,830.00,3998.79,0.00,0.00,0.00,0.00,326),('21','226','109','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,327),('21','226','110','1',165.00,165.00,3941.09,0.00,0.00,0.00,0.00,328),('21','226','110','2',830.00,830.00,5925.59,0.00,0.00,0.00,0.00,329),('21','226','110','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,330),('21','226','111','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,331),('21','226','111','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,332),('21','226','111','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,333),('21','226','112','1',165.00,165.00,21836.12,0.00,0.00,0.00,0.00,334),('21','226','112','2',830.00,830.00,1544.93,0.00,0.00,0.00,0.00,335),('21','226','112','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,336),('21','226','113','1',165.00,165.00,18588.89,0.00,0.00,0.00,0.00,337),('21','226','113','2',830.00,830.00,8462.27,0.00,0.00,0.00,0.00,338),('21','226','113','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,339),('21','226','114','1',165.00,165.00,25920.05,0.00,0.00,0.00,0.00,340),('21','226','114','2',830.00,830.00,3057.12,0.00,0.00,0.00,0.00,341),('21','226','114','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,342),('21','226','115','1',165.00,165.00,23026.13,0.00,0.00,0.00,0.00,343),('21','226','115','2',830.00,830.00,3028.49,0.00,0.00,0.00,0.00,344),('21','226','115','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,345),('21','226','116','1',165.00,165.00,26701.45,0.00,0.00,0.00,0.00,346),('21','226','116','2',830.00,830.00,3851.50,0.00,0.00,0.00,0.00,347),('21','226','116','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,348),('21','226','117','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,349),('21','226','117','2',830.00,830.00,4248.10,0.00,0.00,0.00,0.00,350),('21','226','117','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,351),('21','226','118','1',165.00,165.00,24985.19,0.00,0.00,0.00,0.00,352),('21','226','118','2',830.00,830.00,864.06,0.00,0.00,0.00,0.00,353),('21','226','118','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,354),('21','226','119','1',165.00,165.00,643.00,0.00,0.00,0.00,0.00,355),('21','226','119','2',830.00,830.00,2297.40,0.00,0.00,0.00,0.00,356),('21','226','119','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,357),('21','226','120','1',165.00,165.00,14081.70,0.00,0.00,0.00,0.00,358),('21','226','120','2',830.00,830.00,2694.29,0.00,0.00,0.00,0.00,359),('21','226','120','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,360),('21','226','121','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,361),('21','226','121','2',830.00,830.00,3729.70,0.00,0.00,0.00,0.00,362),('21','226','121','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,363),('21','226','122','1',165.00,165.00,557.51,0.00,0.00,0.00,0.00,364),('21','226','122','2',830.00,830.00,1833.44,0.00,0.00,0.00,0.00,365),('21','226','122','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,366),('21','226','123','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,367),('21','226','123','2',830.00,830.00,3112.83,0.00,0.00,0.00,0.00,368),('21','226','123','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,369),('21','226','124','1',165.00,165.00,11514.03,0.00,0.00,0.00,0.00,370),('21','226','124','2',830.00,830.00,2877.64,0.00,0.00,0.00,0.00,371),('21','226','124','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,372),('21','226','125','1',165.00,165.00,1463.60,0.00,0.00,0.00,0.00,373),('21','226','125','2',830.00,830.00,7742.07,0.00,0.00,0.00,0.00,374),('21','226','125','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,375),('21','226','126','1',165.00,165.00,7377.28,0.00,0.00,0.00,0.00,376),('21','226','126','2',830.00,830.00,2447.23,0.00,0.00,0.00,0.00,377),('21','226','126','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,378),('21','226','127','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,379),('21','226','127','2',830.00,830.00,1418.26,0.00,0.00,0.00,0.00,380),('21','226','127','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,381),('21','226','128','1',185.00,185.00,30219.33,0.00,0.00,0.00,0.00,382),('21','226','128','2',830.00,830.00,1860.35,0.00,0.00,0.00,0.00,383),('21','226','128','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,384),('21','226','129','1',185.00,185.00,49877.83,0.00,0.00,0.00,0.00,385),('21','226','129','2',830.00,830.00,1678.95,0.00,0.00,0.00,0.00,386),('21','226','129','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,387),('21','226','130','2',830.00,830.00,1381.81,0.00,0.00,0.00,0.00,388),('21','226','130','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,389),('21','226','130','1',185.00,185.00,33781.50,0.00,0.00,0.00,0.00,390),('21','226','131','1',185.00,185.00,45015.89,0.00,0.00,0.00,0.00,391),('21','226','131','2',830.00,830.00,2551.66,0.00,0.00,0.00,0.00,392),('21','226','131','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,393),('21','226','132','1',185.00,185.00,41694.67,0.00,0.00,0.00,0.00,394),('21','226','132','2',830.00,830.00,3106.57,0.00,0.00,0.00,0.00,395),('21','226','132','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,396),('21','226','133','1',185.00,185.00,32317.62,0.00,0.00,0.00,0.00,397),('21','226','133','2',830.00,830.00,3055.94,0.00,0.00,0.00,0.00,398),('21','226','133','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,399),('21','226','134','1',185.00,185.00,13295.69,0.00,0.00,0.00,0.00,400),('21','226','134','2',830.00,830.00,4322.09,0.00,0.00,0.00,0.00,401),('21','226','134','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,402),('21','226','135','2',830.00,830.00,2528.22,0.00,0.00,0.00,0.00,403),('21','226','135','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,404),('21','226','135','1',175.00,175.00,31544.46,0.00,0.00,0.00,0.00,405),('21','226','136','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,406),('21','226','136','2',830.00,830.00,1637.05,0.00,0.00,0.00,0.00,407),('21','226','136','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,408),('21','226','137','1',180.00,180.00,357.85,0.00,0.00,0.00,0.00,409),('21','226','137','2',830.00,830.00,1356.65,0.00,0.00,0.00,0.00,410),('21','226','137','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,411),('21','226','138','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,412),('21','226','138','2',830.00,830.00,2768.31,0.00,0.00,0.00,0.00,413),('21','226','138','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,414),('21','226','139','2',815.00,815.00,1028.08,0.00,0.00,0.00,0.00,415),('21','226','139','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,416),('21','226','139','1',180.00,180.00,30269.28,0.00,0.00,0.00,0.00,417),('21','226','140','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,418),('21','226','140','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,419),('21','226','140','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,420),('21','226','141','2',815.00,815.00,1201.86,0.00,0.00,0.00,0.00,421),('21','226','141','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,422),('21','226','141','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,423),('21','226','142','2',815.00,815.00,52.01,0.00,0.00,0.00,0.00,424),('21','226','142','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,425),('21','226','142','1',180.00,180.00,836.93,0.00,0.00,0.00,0.00,426),('21','226','143','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,427),('21','226','143','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,428),('21','226','143','1',180.00,180.00,29654.66,0.00,0.00,0.00,0.00,429),('21','226','144','2',815.00,815.00,3614.99,0.00,0.00,0.00,0.00,430),('21','226','144','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,431),('21','226','144','1',180.00,180.00,14561.83,0.00,0.00,0.00,0.00,432),('21','226','145','1',180.00,180.00,31491.72,0.00,0.00,0.00,0.00,433),('21','226','145','2',815.00,815.00,1428.91,0.00,0.00,0.00,0.00,434),('21','226','145','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,435),('21','226','146','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,436),('21','226','146','2',810.00,810.00,1253.59,0.00,0.00,0.00,0.00,437),('21','226','146','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,438),('21','226','147','1',180.00,180.00,29598.74,0.00,0.00,0.00,0.00,439),('21','226','147','2',810.00,810.00,4317.36,0.00,0.00,0.00,0.00,440),('21','226','147','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,441),('21','226','148','2',810.00,810.00,2855.95,0.00,0.00,0.00,0.00,442),('21','226','148','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,443),('21','226','148','1',180.00,180.00,30113.78,0.00,0.00,0.00,0.00,444),('21','226','149','1',180.00,180.00,30305.72,0.00,0.00,0.00,0.00,445),('21','226','149','2',810.00,810.00,3803.70,0.00,0.00,0.00,0.00,446),('21','226','149','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,447),('21','226','150','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,448),('21','226','150','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,449),('21','226','150','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,450),('21','226','151','1',180.00,180.00,29860.51,0.00,0.00,0.00,0.00,451),('21','226','151','2',810.00,810.00,4427.35,0.00,0.00,0.00,0.00,452),('21','226','151','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,453),('21','226','152','1',180.00,180.00,30204.75,0.00,0.00,0.00,0.00,454),('21','226','152','2',810.00,810.00,1365.75,0.00,0.00,0.00,0.00,455),('21','226','152','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,456),('21','226','153','1',180.00,180.00,30138.57,0.00,0.00,0.00,0.00,457),('21','226','153','2',810.00,810.00,2597.31,0.00,0.00,0.00,0.00,458),('21','226','153','3',835.00,835.00,40.46,0.00,0.00,0.00,0.00,459),('21','226','154','1',180.00,180.00,29707.32,0.00,0.00,0.00,0.00,460),('21','226','154','2',810.00,810.00,4175.94,0.00,0.00,0.00,0.00,461),('21','226','154','3',835.00,835.00,89.29,0.00,0.00,0.00,0.00,462),('21','226','155','2',810.00,810.00,5609.56,0.00,0.00,0.00,0.00,463),('21','226','155','3',835.00,835.00,198.21,0.00,0.00,0.00,0.00,464),('21','226','155','1',180.00,180.00,40238.26,0.00,0.00,0.00,0.00,465),('21','226','156','2',810.00,810.00,5151.07,0.00,0.00,0.00,0.00,466),('21','226','156','3',835.00,835.00,87.47,0.00,0.00,0.00,0.00,467),('21','226','156','1',180.00,180.00,30174.54,0.00,0.00,0.00,0.00,468),('21','226','157','1',180.00,180.00,30178.97,0.00,0.00,0.00,0.00,469),('21','226','157','2',810.00,810.00,5611.30,0.00,0.00,0.00,0.00,470),('21','226','157','3',835.00,835.00,146.55,0.00,0.00,0.00,0.00,471),('21','226','158','1',180.00,180.00,18452.92,0.00,0.00,0.00,0.00,472),('21','226','158','2',810.00,810.00,2903.42,0.00,0.00,0.00,0.00,473),('21','226','158','3',835.00,835.00,61.26,0.00,0.00,0.00,0.00,474),('21','226','159','1',180.00,180.00,25943.30,0.00,0.00,0.00,0.00,475),('21','226','159','2',810.00,810.00,2646.94,0.00,0.00,0.00,0.00,476),('21','226','159','3',835.00,835.00,186.44,0.00,0.00,0.00,0.00,477),('21','226','160','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,478),('21','226','160','2',810.00,810.00,3222.96,0.00,0.00,0.00,0.00,479),('21','226','160','3',835.00,835.00,97.44,0.00,0.00,0.00,0.00,480),('21','226','161','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,481),('21','226','161','2',810.00,810.00,3081.27,0.00,0.00,0.00,0.00,482),('21','226','161','3',835.00,835.00,72.61,0.00,0.00,0.00,0.00,483),('21','226','162','1',180.00,180.00,30603.40,0.00,0.00,0.00,0.00,484),('21','226','162','2',810.00,810.00,4960.27,0.00,0.00,0.00,0.00,485),('21','226','162','3',835.00,835.00,96.57,0.00,0.00,0.00,0.00,486),('21','226','163','1',180.00,180.00,30094.27,0.00,0.00,0.00,0.00,487),('21','226','163','2',810.00,810.00,3183.35,0.00,0.00,0.00,0.00,488),('21','226','163','3',835.00,835.00,59.08,0.00,0.00,0.00,0.00,489),('21','226','164','1',180.00,180.00,26442.06,0.00,0.00,0.00,0.00,490),('21','226','164','2',810.00,810.00,3485.77,0.00,0.00,0.00,0.00,491),('21','226','164','3',835.00,835.00,69.06,0.00,0.00,0.00,0.00,492),('21','226','165','1',180.00,180.00,33046.46,0.00,0.00,0.00,0.00,493),('21','226','165','2',810.00,810.00,1928.16,0.00,0.00,0.00,0.00,494),('21','226','165','3',835.00,835.00,16.35,0.00,0.00,0.00,0.00,495),('21','226','166','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,496),('21','226','166','3',850.00,850.00,106.45,0.00,0.00,0.00,0.00,497),('21','226','166','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,498),('21','226','167','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,499),('21','226','167','2',810.00,810.00,3239.05,0.00,0.00,0.00,0.00,500),('21','226','167','3',850.00,850.00,80.05,0.00,0.00,0.00,0.00,501),('21','226','168','1',180.00,180.00,30560.87,0.00,0.00,0.00,0.00,502),('21','226','168','2',810.00,810.00,3723.14,0.00,0.00,0.00,0.00,503),('21','226','168','3',850.00,850.00,100.48,0.00,0.00,0.00,0.00,504),('21','226','169','2',810.00,810.00,3870.32,0.00,0.00,0.00,0.00,505),('21','226','169','3',850.00,850.00,189.42,0.00,0.00,0.00,0.00,506),('21','226','169','1',180.00,180.00,20485.11,0.00,0.00,0.00,0.00,507),('21','226','170','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,508),('21','226','170','2',810.00,810.00,3048.76,0.00,0.00,0.00,0.00,509),('21','226','170','3',850.00,850.00,111.67,0.00,0.00,0.00,0.00,510),('21','226','171','1',180.00,180.00,29914.71,0.00,0.00,0.00,0.00,511),('21','226','171','2',810.00,810.00,3823.01,0.00,0.00,0.00,0.00,512),('21','226','171','3',850.00,850.00,97.38,0.00,0.00,0.00,0.00,513),('21','226','172','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,514),('21','226','172','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,515),('21','226','172','3',850.00,850.00,47.47,0.00,0.00,0.00,0.00,516),('21','226','173','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,517),('21','226','173','2',810.00,810.00,3498.93,0.00,0.00,0.00,0.00,518),('21','226','173','3',860.00,860.00,56.42,0.00,0.00,0.00,0.00,519),('21','226','174','2',800.00,800.00,487.37,0.00,0.00,0.00,0.00,520),('21','226','174','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,521),('21','226','174','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,522),('21','226','175','1',180.00,180.00,559.91,0.00,0.00,0.00,0.00,523),('21','226','175','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,524),('21','226','175','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,525),('21','226','176','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,526),('21','226','176','2',800.00,800.00,3770.95,0.00,0.00,0.00,0.00,527),('21','226','176','3',860.00,860.00,110.37,0.00,0.00,0.00,0.00,528),('21','226','177','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,529),('21','226','177','2',800.00,800.00,1981.42,0.00,0.00,0.00,0.00,530),('21','226','177','3',860.00,860.00,87.22,0.00,0.00,0.00,0.00,531),('21','226','178','1',180.00,180.00,27813.54,0.00,0.00,0.00,0.00,532),('21','226','178','2',800.00,800.00,3839.44,0.00,0.00,0.00,0.00,533),('21','226','178','3',860.00,860.00,1811.09,0.00,0.00,0.00,0.00,534),('21','226','179','1',180.00,180.00,28630.56,0.00,0.00,0.00,0.00,535),('21','226','179','2',800.00,800.00,5384.99,0.00,0.00,0.00,0.00,536),('21','226','179','3',860.00,860.00,149.25,0.00,0.00,0.00,0.00,537),('21','226','180','2',800.00,800.00,2633.00,0.00,0.00,0.00,0.00,538),('21','226','180','3',860.00,860.00,106.79,0.00,0.00,0.00,0.00,539),('21','226','180','1',180.00,180.00,26240.87,0.00,0.00,0.00,0.00,540),('21','226','181','1',180.00,180.00,31147.31,0.00,0.00,0.00,0.00,541),('21','226','181','2',800.00,800.00,2892.34,0.00,0.00,0.00,0.00,542),('21','226','181','3',860.00,860.00,77.88,0.00,0.00,0.00,0.00,543),('21','226','182','2',800.00,800.00,3917.08,0.00,0.00,0.00,0.00,544),('21','226','182','3',860.00,860.00,84.42,0.00,0.00,0.00,0.00,545),('21','226','182','1',180.00,180.00,33097.27,0.00,0.00,0.00,0.00,546),('21','226','183','2',800.00,800.00,3056.93,0.00,0.00,0.00,0.00,547),('21','226','183','3',860.00,860.00,111.88,0.00,0.00,0.00,0.00,548),('21','226','183','1',180.00,180.00,961.35,0.00,0.00,0.00,0.00,549),('21','226','184','2',800.00,800.00,4712.24,0.00,0.00,0.00,0.00,550),('21','226','184','3',860.00,860.00,94.29,0.00,0.00,0.00,0.00,551),('21','226','184','1',180.00,180.00,30550.51,0.00,0.00,0.00,0.00,552),('21','226','185','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,553),('21','226','185','2',800.00,800.00,2176.90,0.00,0.00,0.00,0.00,554),('21','226','185','3',860.00,860.00,93.90,0.00,0.00,0.00,0.00,555),('21','226','186','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,556),('21','226','186','2',800.00,800.00,2625.46,0.00,0.00,0.00,0.00,557),('21','226','186','3',860.00,860.00,240.56,0.00,0.00,0.00,0.00,558),('21','226','187','1',180.00,180.00,36128.13,0.00,0.00,0.00,0.00,559),('21','226','187','2',800.00,800.00,1690.73,0.00,0.00,0.00,0.00,560),('21','226','187','3',860.00,860.00,115.88,0.00,0.00,0.00,0.00,561),('21','226','188','1',180.00,180.00,9309.35,0.00,0.00,0.00,0.00,562),('21','226','188','2',800.00,800.00,3386.89,0.00,0.00,0.00,0.00,563),('21','226','188','3',860.00,860.00,127.28,0.00,0.00,0.00,0.00,564),('21','226','189','1',180.00,180.00,31083.09,0.00,0.00,0.00,0.00,565),('21','226','189','2',800.00,800.00,2528.35,0.00,0.00,0.00,0.00,566),('21','226','189','3',860.00,860.00,86.88,0.00,0.00,0.00,0.00,567),('21','226','190','2',800.00,800.00,2596.66,0.00,0.00,0.00,0.00,568),('21','226','190','3',860.00,860.00,166.86,0.00,0.00,0.00,0.00,569),('21','226','190','1',180.00,180.00,28637.87,0.00,0.00,0.00,0.00,570),('21','226','191','1',180.00,180.00,25628.71,0.00,0.00,0.00,0.00,571),('21','226','191','2',800.00,800.00,3292.91,0.00,0.00,0.00,0.00,572),('21','226','191','3',860.00,860.00,285.83,0.00,0.00,0.00,0.00,573),('21','226','192','1',180.00,180.00,36401.50,0.00,0.00,0.00,0.00,574),('21','226','192','2',800.00,800.00,3133.34,0.00,0.00,0.00,0.00,575),('21','226','192','3',860.00,860.00,133.54,0.00,0.00,0.00,0.00,576),('21','226','193','1',180.00,180.00,37440.76,0.00,0.00,0.00,0.00,577),('21','226','193','2',800.00,800.00,4503.11,0.00,0.00,0.00,0.00,578),('21','226','193','3',860.00,860.00,125.79,0.00,0.00,0.00,0.00,579),('21','226','194','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,580),('21','226','194','2',800.00,800.00,2895.79,0.00,0.00,0.00,0.00,581),('21','226','194','3',860.00,860.00,219.35,0.00,0.00,0.00,0.00,582),('21','226','195','1',180.00,180.00,36414.58,0.00,0.00,0.00,0.00,583),('21','226','195','2',800.00,800.00,4809.31,0.00,0.00,0.00,0.00,584),('21','226','195','3',860.00,860.00,131.76,0.00,0.00,0.00,0.00,585),('21','226','196','1',180.00,180.00,39726.45,0.00,0.00,0.00,0.00,586),('21','226','196','2',800.00,800.00,3210.41,0.00,0.00,0.00,0.00,587),('21','226','196','3',860.00,860.00,140.95,0.00,0.00,0.00,0.00,588),('21','226','197','1',180.00,180.00,36689.87,0.00,0.00,0.00,0.00,589),('21','226','197','2',800.00,800.00,3591.44,0.00,0.00,0.00,0.00,590),('21','226','197','3',860.00,860.00,160.56,0.00,0.00,0.00,0.00,591),('21','226','198','1',180.00,180.00,40674.88,0.00,0.00,0.00,0.00,592),('21','226','198','2',800.00,800.00,4502.50,0.00,0.00,0.00,0.00,593),('21','226','198','3',860.00,860.00,80.90,0.00,0.00,0.00,0.00,594),('21','226','199','1',180.00,180.00,29193.41,0.00,0.00,0.00,0.00,595),('21','226','199','2',800.00,800.00,3423.03,0.00,0.00,0.00,0.00,596),('21','226','199','3',860.00,860.00,148.14,0.00,0.00,0.00,0.00,597),('21','226','200','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,598),('21','226','200','2',800.00,800.00,3318.65,0.00,0.00,0.00,0.00,599),('21','226','200','3',860.00,860.00,121.47,0.00,0.00,0.00,0.00,600),('21','226','201','1',180.00,180.00,29297.05,0.00,0.00,0.00,0.00,601),('21','226','201','2',800.00,800.00,4557.76,0.00,0.00,0.00,0.00,602),('21','226','201','3',860.00,860.00,155.11,0.00,0.00,0.00,0.00,603),('21','226','202','2',800.00,800.00,2630.10,0.00,0.00,0.00,0.00,604),('21','226','202','3',860.00,860.00,81.44,0.00,0.00,0.00,0.00,605),('21','226','202','1',180.00,180.00,27001.36,0.00,0.00,0.00,0.00,606),('21','226','203','1',180.00,180.00,19031.79,0.00,0.00,0.00,0.00,607),('21','226','203','2',800.00,800.00,4172.34,0.00,0.00,0.00,0.00,608),('21','226','203','3',860.00,860.00,98.30,0.00,0.00,0.00,0.00,609);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'226','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCTS');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','226','1',1,0,'1','PMS TANK 1 & 2',90000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 15:42:23','2022-03-17 14:38:44','769',5,0),('21','226','1',2,0,'1','PMS TANK 3',46000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 15:59:26','2022-07-26 11:11:40','764',5,0),('21','226','1',3,0,'2','AGO TANK',45000.00,0.00,NULL,'TANK CONTAINING DEISEL PRODUCTS','764','2022-03-03 16:08:37','2022-04-18 21:20:55','764',5,0),('21','226','1',4,0,'3','DPK TANK ',45000.00,0.00,NULL,'TANK CONTAINING KEROSINE PRODUCTS','764','2022-03-03 16:12:53','2022-03-03 16:16:14','764',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=3114 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (56,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,16730000.00,23900.00,0.00,0.00,'2022-03-22 07:41:10','',''),(57,'21','226',NULL,2,'Reception corrector for bridging 14',0.00,0.00,0.00,23900.00,0.00,'2022-03-22 07:48:39','',''),(58,'21','226','3',2,'Received from bridging 14',0.00,0.00,23900.00,0.00,0.00,'2022-03-22 07:48:39','',''),(59,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,1237500.00,7500.00,0.00,0.00,'2022-03-22 07:52:00','',''),(60,'21','226',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,7500.00,0.00,'2022-03-22 08:01:09','',''),(61,'21','226','1',1,'Received from bridging 15',0.00,0.00,7500.00,0.00,0.00,'2022-03-22 08:01:09','',''),(62,'21','226',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4840000.00,8800.00,0.00,0.00,'2022-03-22 08:03:02','',''),(63,'21','226',NULL,3,'Reception corrector for bridging 16',0.00,0.00,0.00,8800.00,0.00,'2022-03-22 08:06:49','',''),(64,'21','226','4',3,'Received from bridging 16',0.00,0.00,8800.00,0.00,0.00,'2022-03-22 08:06:49','',''),(65,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,7500.00,0.00,'2022-03-22 09:18:17','',''),(66,'21','226','1',0,'Inventory adjustment from tank dipping to 7508',0.00,0.00,7508.00,0.00,0.00,'2022-03-22 09:18:17','',''),(67,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,7508.00,0.00,'2022-03-22 09:25:04','',''),(68,'21','226','1',0,'Inventory adjustment from tank dipping to 7510',0.00,0.00,7510.00,0.00,0.00,'2022-03-22 09:25:04','',''),(69,'21','226','1',1,'Sale Id shift 6',0.00,0.00,0.00,776.86,0.00,'2022-03-22 10:50:31','',''),(70,'21','226','1',1,'Sale Id shift 6',0.00,0.00,0.00,727.21,0.00,'2022-03-22 10:50:31','',''),(71,'21','226','1',1,'Sale Id shift 6',0.00,0.00,0.00,774.16,0.00,'2022-03-22 10:50:31','',''),(72,'21','226','1',1,'Sale Id shift 6',0.00,0.00,0.00,1679.30,0.00,'2022-03-22 10:50:31','',''),(73,'21','226','1',1,'Sale Id shift 6',0.00,0.00,0.00,702.50,0.00,'2022-03-22 10:50:31','',''),(74,'21','226','1',1,'Sale Id shift 6',0.00,0.00,0.00,1838.84,0.00,'2022-03-22 10:50:31','',''),(75,'21','226','1',1,'Sale Id shift 6',0.00,0.00,0.00,558.16,0.00,'2022-03-22 10:50:31','',''),(76,'21','226','1',1,'Sale Id shift 6',0.00,0.00,0.00,451.05,0.00,'2022-03-22 10:50:31','',''),(77,'21','226','3',2,'Sale Id shift 6',0.00,0.00,0.00,906.08,0.00,'2022-03-22 10:50:31','',''),(78,'21','226','3',2,'Sale Id shift 6',0.00,0.00,0.00,1288.69,0.00,'2022-03-22 10:50:31','',''),(79,'21','226','4',3,'Sale Id shift 6',0.00,0.00,0.00,2379.58,0.00,'2022-03-22 10:50:31','',''),(80,'21','226',NULL,1,'Sale Id shift 6',1238833.20,0.00,0.00,0.00,0.00,'2022-03-22 10:50:31','',''),(81,'21','226',NULL,2,'Sale Id shift 6',1536339.00,0.00,0.00,0.00,0.00,'2022-03-22 10:50:31','',''),(82,'21','226',NULL,3,'Sale Id shift 6',1308769.00,0.00,0.00,0.00,0.00,'2022-03-22 10:50:31','',''),(83,'21','226',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5060000.00,9200.00,0.00,0.00,'2022-03-22 17:56:21','',''),(84,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,17290000.00,24700.00,0.00,0.00,'2022-03-22 17:58:42','',''),(85,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-23 09:19:39','',''),(86,'21','226',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,30000.00,0.00,'2022-03-23 09:22:30','',''),(87,'21','226','1',1,'Received from bridging 17',0.00,0.00,30000.00,0.00,0.00,'2022-03-23 09:22:30','',''),(88,'21','226','2',1,'Sale Id shift 7',0.00,0.00,0.00,609.77,0.00,'2022-03-23 09:34:33','',''),(89,'21','226','2',1,'Sale Id shift 7',0.00,0.00,0.00,611.73,0.00,'2022-03-23 09:34:33','',''),(90,'21','226','2',1,'Sale Id shift 7',0.00,0.00,0.00,306.29,0.00,'2022-03-23 09:34:33','',''),(91,'21','226','2',1,'Sale Id shift 7',0.00,0.00,0.00,162.26,0.00,'2022-03-23 09:34:33','',''),(92,'21','226','2',1,'Sale Id shift 7',0.00,0.00,0.00,3390.72,0.00,'2022-03-23 09:34:33','',''),(93,'21','226','2',1,'Sale Id shift 7',0.00,0.00,0.00,3394.52,0.00,'2022-03-23 09:34:33','',''),(94,'21','226','2',1,'Sale Id shift 7',0.00,0.00,0.00,2525.62,0.00,'2022-03-23 09:34:33','',''),(95,'21','226','2',1,'Sale Id shift 7',0.00,0.00,0.00,2602.61,0.00,'2022-03-23 09:34:33','',''),(96,'21','226','3',2,'Sale Id shift 7',0.00,0.00,0.00,1341.71,0.00,'2022-03-23 09:34:33','',''),(97,'21','226','3',2,'Sale Id shift 7',0.00,0.00,0.00,764.83,0.00,'2022-03-23 09:34:33','',''),(98,'21','226','4',3,'Sale Id shift 7',0.00,0.00,0.00,263.43,0.00,'2022-03-23 09:34:33','',''),(99,'21','226','1',1,'Sale Id shift 7',0.00,0.00,0.00,281.94,0.00,'2022-03-23 09:34:33','',''),(100,'21','226','1',1,'Sale Id shift 7',0.00,0.00,0.00,980.75,0.00,'2022-03-23 09:34:33','',''),(101,'21','226','1',1,'Sale Id shift 7',0.00,0.00,0.00,3717.02,0.00,'2022-03-23 09:34:33','',''),(102,'21','226','1',1,'Sale Id shift 7',0.00,0.00,0.00,3837.64,0.00,'2022-03-23 09:34:33','',''),(103,'21','226','1',1,'Sale Id shift 7',0.00,0.00,0.00,3024.83,0.00,'2022-03-23 09:34:33','',''),(104,'21','226','1',1,'Sale Id shift 7',0.00,0.00,0.00,3224.45,0.00,'2022-03-23 09:34:33','',''),(105,'21','226',NULL,2,'Sale Id shift 7',1474578.00,0.00,0.00,0.00,0.00,'2022-03-23 09:34:33','',''),(106,'21','226',NULL,3,'Sale Id shift 7',144886.50,0.00,0.00,0.00,0.00,'2022-03-23 09:34:33','',''),(107,'21','226',NULL,1,'Sale Id shift 7',4730574.75,0.00,0.00,0.00,0.00,'2022-03-23 09:34:33','',''),(108,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,14935.29,0.00,'2022-03-23 13:38:22','',''),(109,'21','226','1',0,'Inventory adjustment from tank dipping to 16185',0.00,0.00,16185.00,0.00,0.00,'2022-03-23 13:38:22','',''),(110,'21','226','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,-13603.52,0.00,'2022-03-23 13:38:44','',''),(111,'21','226','2',0,'Inventory adjustment from tank dipping to 800',0.00,0.00,800.00,0.00,0.00,'2022-03-23 13:38:44','',''),(112,'21','226','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,19598.69,0.00,'2022-03-23 13:39:15','',''),(113,'21','226','3',0,'Inventory adjustment from tank dipping to 20399',0.00,0.00,20399.00,0.00,0.00,'2022-03-23 13:39:15','',''),(114,'21','226','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,6156.99,0.00,'2022-03-23 13:39:52','',''),(115,'21','226','4',0,'Inventory adjustment from tank dipping to 6557',0.00,0.00,6557.00,0.00,0.00,'2022-03-23 13:39:52','',''),(116,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-24 08:06:14','',''),(117,'21','226',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,15000.00,0.00,'2022-03-24 08:09:22','',''),(118,'21','226','2',1,'Received from bridging 19',0.00,0.00,15000.00,0.00,0.00,'2022-03-24 08:09:22','',''),(119,'21','226',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,15000.00,0.00,'2022-03-24 08:09:22','',''),(120,'21','226','1',1,'Received from bridging 18',0.00,0.00,15000.00,0.00,0.00,'2022-03-24 08:09:22','',''),(121,'21','226','1',1,'Sale Id shift 8',0.00,0.00,0.00,6512.87,0.00,'2022-03-24 09:00:47','',''),(122,'21','226','2',1,'Sale Id shift 8',0.00,0.00,0.00,205.77,0.00,'2022-03-24 09:00:47','',''),(123,'21','226','2',1,'Sale Id shift 8',0.00,0.00,0.00,176.45,0.00,'2022-03-24 09:00:47','',''),(124,'21','226','2',1,'Sale Id shift 8',0.00,0.00,0.00,533.62,0.00,'2022-03-24 09:00:47','',''),(125,'21','226','1',1,'Sale Id shift 8',0.00,0.00,0.00,5898.60,0.00,'2022-03-24 09:00:47','',''),(126,'21','226','2',1,'Sale Id shift 8',0.00,0.00,0.00,511.74,0.00,'2022-03-24 09:00:47','',''),(127,'21','226','3',2,'Sale Id shift 8',0.00,0.00,0.00,2565.87,0.00,'2022-03-24 09:00:47','',''),(128,'21','226','3',2,'Sale Id shift 8',0.00,0.00,0.00,945.93,0.00,'2022-03-24 09:00:47','',''),(129,'21','226','3',2,'Sale Id shift 8',0.00,0.00,0.00,712.70,0.00,'2022-03-24 09:00:47','',''),(130,'21','226','4',3,'Sale Id shift 8',0.00,0.00,0.00,1055.95,0.00,'2022-03-24 09:00:47','',''),(131,'21','226','1',1,'Sale Id shift 8',0.00,0.00,0.00,6786.66,0.00,'2022-03-24 09:00:47','',''),(132,'21','226','1',1,'Sale Id shift 8',0.00,0.00,0.00,6140.39,0.00,'2022-03-24 09:00:47','',''),(133,'21','226','1',1,'Sale Id shift 8',0.00,0.00,0.00,2004.50,0.00,'2022-03-24 09:00:47','',''),(134,'21','226','1',1,'Sale Id shift 8',0.00,0.00,0.00,1568.10,0.00,'2022-03-24 09:00:47','',''),(135,'21','226','1',1,'Sale Id shift 8',0.00,0.00,0.00,149.69,0.00,'2022-03-24 09:00:47','',''),(136,'21','226','1',1,'Sale Id shift 8',0.00,0.00,0.00,908.64,0.00,'2022-03-24 09:00:47','',''),(137,'21','226',NULL,2,'Sale Id shift 8',2957150.00,0.00,0.00,0.00,0.00,'2022-03-24 09:00:47','',''),(138,'21','226',NULL,3,'Sale Id shift 8',580772.50,0.00,0.00,0.00,0.00,'2022-03-24 09:00:47','',''),(139,'21','226',NULL,1,'Sale Id shift 8',5180509.95,0.00,0.00,0.00,0.00,'2022-03-24 09:00:47','',''),(140,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,1215.55,0.00,'2022-04-04 09:08:53','',''),(141,'21','226','1',0,'Inventory adjustment from tank dipping to 16200',0.00,0.00,16200.00,0.00,0.00,'2022-04-04 09:08:53','',''),(142,'21','226','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,14372.42,0.00,'2022-04-04 09:09:52','',''),(143,'21','226','2',0,'Inventory adjustment from tank dipping to 15800',0.00,0.00,15800.00,0.00,0.00,'2022-04-04 09:09:52','',''),(144,'21','226','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,16174.50,0.00,'2022-04-04 09:11:24','',''),(145,'21','226','3',0,'Inventory adjustment from tank dipping to 16400',0.00,0.00,16400.00,0.00,0.00,'2022-04-04 09:11:24','',''),(146,'21','226','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,5501.05,0.00,'2022-04-04 09:12:22','',''),(147,'21','226','4',0,'Inventory adjustment from tank dipping to 5650',0.00,0.00,5650.00,0.00,0.00,'2022-04-04 09:12:22','',''),(148,'21','226','2',1,'Sale Id shift 9',0.00,0.00,0.00,2272.11,0.00,'2022-04-04 10:22:22','',''),(149,'21','226','2',1,'Sale Id shift 9',0.00,0.00,0.00,2547.17,0.00,'2022-04-04 10:22:22','',''),(150,'21','226','2',1,'Sale Id shift 9',0.00,0.00,0.00,913.62,0.00,'2022-04-04 10:22:22','',''),(151,'21','226','2',1,'Sale Id shift 9',0.00,0.00,0.00,1030.21,0.00,'2022-04-04 10:22:22','',''),(152,'21','226','2',1,'Sale Id shift 9',0.00,0.00,0.00,1335.82,0.00,'2022-04-04 10:22:22','',''),(153,'21','226','2',1,'Sale Id shift 9',0.00,0.00,0.00,1427.50,0.00,'2022-04-04 10:22:22','',''),(154,'21','226','3',2,'Sale Id shift 9',0.00,0.00,0.00,1837.08,0.00,'2022-04-04 10:22:22','',''),(155,'21','226','3',2,'Sale Id shift 9',0.00,0.00,0.00,0.50,0.00,'2022-04-04 10:22:22','',''),(156,'21','226','3',2,'Sale Id shift 9',0.00,0.00,0.00,2175.07,0.00,'2022-04-04 10:22:22','',''),(157,'21','226','4',3,'Sale Id shift 9',0.00,0.00,0.00,457.62,0.00,'2022-04-04 10:22:22','',''),(158,'21','226','1',1,'Sale Id shift 9',0.00,0.00,0.00,3586.11,0.00,'2022-04-04 10:22:22','',''),(159,'21','226','1',1,'Sale Id shift 9',0.00,0.00,0.00,3837.08,0.00,'2022-04-04 10:22:22','',''),(160,'21','226','1',1,'Sale Id shift 9',0.00,0.00,0.00,3689.86,0.00,'2022-04-04 10:22:22','',''),(161,'21','226','1',1,'Sale Id shift 9',0.00,0.00,0.00,3925.08,0.00,'2022-04-04 10:22:22','',''),(162,'21','226',NULL,2,'Sale Id shift 9',2808855.00,0.00,0.00,0.00,0.00,'2022-04-04 10:22:22','',''),(163,'21','226',NULL,3,'Sale Id shift 9',251691.00,0.00,0.00,0.00,0.00,'2022-04-04 10:22:22','',''),(164,'21','226',NULL,1,'Sale Id shift 9',4053152.40,0.00,0.00,0.00,0.00,'2022-04-04 10:22:22','',''),(165,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4455000.00,27000.00,0.00,0.00,'2022-04-04 10:31:46','',''),(166,'21','226',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,27000.00,0.00,'2022-04-04 10:34:29','',''),(167,'21','226','1',1,'Received from bridging 20',0.00,0.00,27000.00,0.00,0.00,'2022-04-04 10:34:29','',''),(168,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2970000.00,18000.00,0.00,0.00,'2022-04-04 10:38:02','',''),(169,'21','226',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,18000.00,0.00,'2022-04-04 10:39:10','',''),(170,'21','226','2',1,'Received from bridging 21',0.00,0.00,18000.00,0.00,0.00,'2022-04-04 10:39:10','',''),(171,'21','226','1',1,'Sale Id shift 10',0.00,0.00,0.00,4096.78,0.00,'2022-04-04 11:08:35','',''),(172,'21','226','2',1,'Sale Id shift 10',0.00,0.00,0.00,723.93,0.00,'2022-04-04 11:08:35','',''),(173,'21','226','1',1,'Sale Id shift 10',0.00,0.00,0.00,3842.09,0.00,'2022-04-04 11:08:35','',''),(174,'21','226','2',1,'Sale Id shift 10',0.00,0.00,0.00,565.72,0.00,'2022-04-04 11:08:35','',''),(175,'21','226','2',1,'Sale Id shift 10',0.00,0.00,0.00,2752.26,0.00,'2022-04-04 11:08:35','',''),(176,'21','226','2',1,'Sale Id shift 10',0.00,0.00,0.00,3100.40,0.00,'2022-04-04 11:08:35','',''),(177,'21','226','2',1,'Sale Id shift 10',0.00,0.00,0.00,578.13,0.00,'2022-04-04 11:08:35','',''),(178,'21','226','2',1,'Sale Id shift 10',0.00,0.00,0.00,592.18,0.00,'2022-04-04 11:08:35','',''),(179,'21','226','3',2,'Sale Id shift 10',0.00,0.00,0.00,1145.32,0.00,'2022-04-04 11:08:35','',''),(180,'21','226','3',2,'Sale Id shift 10',0.00,0.00,0.00,1665.07,0.00,'2022-04-04 11:08:35','',''),(181,'21','226','4',3,'Sale Id shift 10',0.00,0.00,0.00,282.73,0.00,'2022-04-04 11:08:35','',''),(182,'21','226','1',1,'Sale Id shift 10',0.00,0.00,0.00,4657.18,0.00,'2022-04-04 11:08:35','',''),(183,'21','226','1',1,'Sale Id shift 10',0.00,0.00,0.00,4955.23,0.00,'2022-04-04 11:08:35','',''),(184,'21','226','1',1,'Sale Id shift 10',0.00,0.00,0.00,3758.82,0.00,'2022-04-04 11:08:35','',''),(185,'21','226','1',1,'Sale Id shift 10',0.00,0.00,0.00,4455.29,0.00,'2022-04-04 11:08:35','',''),(186,'21','226','1',1,'Sale Id shift 10',0.00,0.00,0.00,864.32,0.00,'2022-04-04 11:08:35','',''),(187,'21','226','1',1,'Sale Id shift 10',0.00,0.00,0.00,818.73,0.00,'2022-04-04 11:08:35','',''),(188,'21','226',NULL,2,'Sale Id shift 10',1967273.00,0.00,0.00,0.00,0.00,'2022-04-04 11:08:35','',''),(189,'21','226',NULL,3,'Sale Id shift 10',155501.50,0.00,0.00,0.00,0.00,'2022-04-04 11:08:35','',''),(190,'21','226',NULL,1,'Sale Id shift 10',5900574.90,0.00,0.00,0.00,0.00,'2022-04-04 11:08:35','',''),(191,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4455000.00,27000.00,0.00,0.00,'2022-04-04 11:18:44','',''),(192,'21','226',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,27000.00,0.00,'2022-04-04 11:21:34','',''),(193,'21','226','1',1,'Received from bridging 22',0.00,0.00,27000.00,0.00,0.00,'2022-04-04 11:21:34','',''),(194,'21','226','1',1,'Sale Id shift 11',0.00,0.00,0.00,1610.70,0.00,'2022-04-04 12:03:33','',''),(195,'21','226','2',1,'Sale Id shift 11',0.00,0.00,0.00,331.74,0.00,'2022-04-04 12:03:33','',''),(196,'21','226','1',1,'Sale Id shift 11',0.00,0.00,0.00,1448.62,0.00,'2022-04-04 12:03:33','',''),(197,'21','226','3',2,'Sale Id shift 11',0.00,0.00,0.00,622.83,0.00,'2022-04-04 12:03:33','',''),(198,'21','226','3',2,'Sale Id shift 11',0.00,0.00,0.00,0.04,0.00,'2022-04-04 12:03:33','',''),(199,'21','226','3',2,'Sale Id shift 11',0.00,0.00,0.00,1251.62,0.00,'2022-04-04 12:03:33','',''),(200,'21','226','4',3,'Sale Id shift 11',0.00,0.00,0.00,458.66,0.00,'2022-04-04 12:03:33','',''),(201,'21','226','1',1,'Sale Id shift 11',0.00,0.00,0.00,6598.88,0.00,'2022-04-04 12:03:33','',''),(202,'21','226','1',1,'Sale Id shift 11',0.00,0.00,0.00,6202.69,0.00,'2022-04-04 12:03:33','',''),(203,'21','226','1',1,'Sale Id shift 11',0.00,0.00,0.00,854.21,0.00,'2022-04-04 12:03:33','',''),(204,'21','226','1',1,'Sale Id shift 11',0.00,0.00,0.00,1377.92,0.00,'2022-04-04 12:03:33','',''),(205,'21','226',NULL,1,'Sale Id shift 11',3040085.40,0.00,0.00,0.00,0.00,'2022-04-04 12:03:33','',''),(206,'21','226',NULL,2,'Sale Id shift 11',1312143.00,0.00,0.00,0.00,0.00,'2022-04-04 12:03:33','',''),(207,'21','226',NULL,3,'Sale Id shift 11',252263.00,0.00,0.00,0.00,0.00,'2022-04-04 12:03:33','',''),(208,'21','226','2',1,'Sale Id shift 12',0.00,0.00,0.00,47.96,0.00,'2022-04-04 12:39:15','',''),(209,'21','226','2',1,'Sale Id shift 12',0.00,0.00,0.00,6064.71,0.00,'2022-04-04 12:39:15','',''),(210,'21','226','2',1,'Sale Id shift 12',0.00,0.00,0.00,6488.72,0.00,'2022-04-04 12:39:15','',''),(211,'21','226','2',1,'Sale Id shift 12',0.00,0.00,0.00,800.64,0.00,'2022-04-04 12:39:15','',''),(212,'21','226','2',1,'Sale Id shift 12',0.00,0.00,0.00,786.12,0.00,'2022-04-04 12:39:15','',''),(213,'21','226','3',2,'Sale Id shift 12',0.00,0.00,0.00,87.98,0.00,'2022-04-04 12:39:15','',''),(214,'21','226','3',2,'Sale Id shift 12',0.00,0.00,0.00,0.30,0.00,'2022-04-04 12:39:15','',''),(215,'21','226','3',2,'Sale Id shift 12',0.00,0.00,0.00,2088.48,0.00,'2022-04-04 12:39:15','',''),(216,'21','226','4',3,'Sale Id shift 12',0.00,0.00,0.00,280.55,0.00,'2022-04-04 12:39:15','',''),(217,'21','226','1',1,'Sale Id shift 12',0.00,0.00,0.00,30.47,0.00,'2022-04-04 12:39:15','',''),(218,'21','226','1',1,'Sale Id shift 12',0.00,0.00,0.00,56.96,0.00,'2022-04-04 12:39:15','',''),(219,'21','226',NULL,1,'Sale Id shift 12',2355470.70,0.00,0.00,0.00,0.00,'2022-04-04 12:39:15','',''),(220,'21','226',NULL,2,'Sale Id shift 12',1523732.00,0.00,0.00,0.00,0.00,'2022-04-04 12:39:15','',''),(221,'21','226',NULL,3,'Sale Id shift 12',154302.50,0.00,0.00,0.00,0.00,'2022-04-04 12:39:15','',''),(222,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-04 12:41:32','',''),(223,'21','226',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,30000.00,0.00,'2022-04-04 12:43:46','',''),(224,'21','226','2',1,'Received from bridging 23',0.00,0.00,30000.00,0.00,0.00,'2022-04-04 12:43:46','',''),(225,'21','226','2',1,'Sale Id shift 13',0.00,0.00,0.00,6962.93,0.00,'2022-04-04 13:58:29','',''),(226,'21','226','2',1,'Sale Id shift 13',0.00,0.00,0.00,6985.38,0.00,'2022-04-04 13:58:29','',''),(227,'21','226','2',1,'Sale Id shift 13',0.00,0.00,0.00,7520.13,0.00,'2022-04-04 13:58:29','',''),(228,'21','226','2',1,'Sale Id shift 13',0.00,0.00,0.00,7439.32,0.00,'2022-04-04 13:58:29','',''),(229,'21','226','3',2,'Sale Id shift 13',0.00,0.00,0.00,762.79,0.00,'2022-04-04 13:58:29','',''),(230,'21','226','3',2,'Sale Id shift 13',0.00,0.00,0.00,2417.33,0.00,'2022-04-04 13:58:29','',''),(231,'21','226','4',3,'Sale Id shift 13',0.00,0.00,0.00,403.51,0.00,'2022-04-04 13:58:29','',''),(232,'21','226','1',1,'Sale Id shift 13',0.00,0.00,0.00,314.89,0.00,'2022-04-04 13:58:29','',''),(233,'21','226','1',1,'Sale Id shift 13',0.00,0.00,0.00,336.99,0.00,'2022-04-04 13:58:29','',''),(234,'21','226',NULL,1,'Sale Id shift 13',4877340.60,0.00,0.00,0.00,0.00,'2022-04-04 13:58:29','',''),(235,'21','226',NULL,2,'Sale Id shift 13',2226084.00,0.00,0.00,0.00,0.00,'2022-04-04 13:58:29','',''),(236,'21','226',NULL,3,'Sale Id shift 13',221930.50,0.00,0.00,0.00,0.00,'2022-04-04 13:58:29','',''),(237,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-04 14:03:06','',''),(238,'21','226',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,30000.00,0.00,'2022-04-04 14:06:06','',''),(239,'21','226','1',1,'Received from bridging 24',0.00,0.00,30000.00,0.00,0.00,'2022-04-04 14:06:06','',''),(240,'21','226','1',1,'Sale Id shift 14',0.00,0.00,0.00,8186.06,0.00,'2022-04-04 15:04:10','',''),(241,'21','226','1',1,'Sale Id shift 14',0.00,0.00,0.00,7742.30,0.00,'2022-04-04 15:04:10','',''),(242,'21','226','2',1,'Sale Id shift 14',0.00,0.00,0.00,121.43,0.00,'2022-04-04 15:04:10','',''),(243,'21','226','3',2,'Sale Id shift 14',0.00,0.00,0.00,899.44,0.00,'2022-04-04 15:04:10','',''),(244,'21','226','3',2,'Sale Id shift 14',0.00,0.00,0.00,797.13,0.00,'2022-04-04 15:04:10','',''),(245,'21','226','4',3,'Sale Id shift 14',0.00,0.00,0.00,538.92,0.00,'2022-04-04 15:04:10','',''),(246,'21','226','1',1,'Sale Id shift 14',0.00,0.00,0.00,7831.92,0.00,'2022-04-04 15:04:10','',''),(247,'21','226','4',3,'Sale Id shift 14',0.00,0.00,0.00,10.91,0.00,'2022-04-04 15:04:10','',''),(248,'21','226','1',1,'Sale Id shift 14',0.00,0.00,0.00,7905.06,0.00,'2022-04-04 15:04:10','',''),(249,'21','226',NULL,2,'Sale Id shift 14',1187599.00,0.00,0.00,0.00,0.00,'2022-04-04 15:04:10','',''),(250,'21','226',NULL,3,'Sale Id shift 14',302406.50,0.00,0.00,0.00,0.00,'2022-04-04 15:04:10','',''),(251,'21','226',NULL,1,'Sale Id shift 14',5244817.05,0.00,0.00,0.00,0.00,'2022-04-04 15:04:10','',''),(252,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-04 15:07:48','',''),(253,'21','226',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,30000.00,0.00,'2022-04-04 15:09:49','',''),(254,'21','226','2',1,'Received from bridging 25',0.00,0.00,30000.00,0.00,0.00,'2022-04-04 15:09:49','',''),(255,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-04 15:20:50','',''),(256,'21','226',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,15000.00,0.00,'2022-04-04 15:22:16','',''),(257,'21','226','1',1,'Received from bridging 26',0.00,0.00,15000.00,0.00,0.00,'2022-04-04 15:22:16','',''),(258,'21','226','2',1,'Sale Id shift 15',0.00,0.00,0.00,2575.09,0.00,'2022-04-04 15:42:27','',''),(259,'21','226','2',1,'Sale Id shift 15',0.00,0.00,0.00,2840.64,0.00,'2022-04-04 15:42:27','',''),(260,'21','226','3',2,'Sale Id shift 15',0.00,0.00,0.00,55.71,0.00,'2022-04-04 15:42:27','',''),(261,'21','226','3',2,'Sale Id shift 15',0.00,0.00,0.00,411.43,0.00,'2022-04-04 15:42:27','',''),(262,'21','226','4',3,'Sale Id shift 15',0.00,0.00,0.00,387.76,0.00,'2022-04-04 15:42:27','',''),(263,'21','226','1',1,'Sale Id shift 15',0.00,0.00,0.00,5900.23,0.00,'2022-04-04 15:42:27','',''),(264,'21','226','1',1,'Sale Id shift 15',0.00,0.00,0.00,6140.23,0.00,'2022-04-04 15:42:27','',''),(265,'21','226','1',1,'Sale Id shift 15',0.00,0.00,0.00,4245.03,0.00,'2022-04-04 15:42:27','',''),(266,'21','226','1',1,'Sale Id shift 15',0.00,0.00,0.00,4867.70,0.00,'2022-04-04 15:42:27','',''),(267,'21','226','1',1,'Sale Id shift 15',0.00,0.00,0.00,404.54,0.00,'2022-04-04 15:42:27','',''),(268,'21','226','1',1,'Sale Id shift 15',0.00,0.00,0.00,654.06,0.00,'2022-04-04 15:42:27','',''),(269,'21','226',NULL,2,'Sale Id shift 15',326998.00,0.00,0.00,0.00,0.00,'2022-04-04 15:42:27','',''),(270,'21','226',NULL,3,'Sale Id shift 15',213268.00,0.00,0.00,0.00,0.00,'2022-04-04 15:42:27','',''),(271,'21','226',NULL,1,'Sale Id shift 15',4558540.80,0.00,0.00,0.00,0.00,'2022-04-04 15:42:27','',''),(272,'21','226','2',1,'Sale Id shift 16',0.00,0.00,0.00,4728.78,0.00,'2022-04-04 16:42:18','',''),(273,'21','226','2',1,'Sale Id shift 16',0.00,0.00,0.00,4939.47,0.00,'2022-04-04 16:42:18','',''),(274,'21','226','2',1,'Sale Id shift 16',0.00,0.00,0.00,159.29,0.00,'2022-04-04 16:42:18','',''),(275,'21','226','2',1,'Sale Id shift 16',0.00,0.00,0.00,120.38,0.00,'2022-04-04 16:42:18','',''),(276,'21','226','2',1,'Sale Id shift 16',0.00,0.00,0.00,1880.90,0.00,'2022-04-04 16:42:18','',''),(277,'21','226','2',1,'Sale Id shift 16',0.00,0.00,0.00,1847.42,0.00,'2022-04-04 16:42:18','',''),(278,'21','226','2',1,'Sale Id shift 16',0.00,0.00,0.00,4717.43,0.00,'2022-04-04 16:42:18','',''),(279,'21','226','2',1,'Sale Id shift 16',0.00,0.00,0.00,5191.37,0.00,'2022-04-04 16:42:18','',''),(280,'21','226','3',2,'Sale Id shift 16',0.00,0.00,0.00,38.26,0.00,'2022-04-04 16:42:18','',''),(281,'21','226','4',3,'Sale Id shift 16',0.00,0.00,0.00,381.88,0.00,'2022-04-04 16:42:18','',''),(282,'21','226',NULL,1,'Sale Id shift 16',3891531.60,0.00,0.00,0.00,0.00,'2022-04-04 16:42:18','',''),(283,'21','226',NULL,2,'Sale Id shift 16',26782.00,0.00,0.00,0.00,0.00,'2022-04-04 16:42:18','',''),(284,'21','226',NULL,3,'Sale Id shift 16',210034.00,0.00,0.00,0.00,0.00,'2022-04-04 16:42:18','',''),(285,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-04 16:53:52','',''),(286,'21','226',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,14000.00,0.00,'2022-04-04 16:55:45','',''),(287,'21','226','2',1,'Received from bridging 28',0.00,0.00,14000.00,0.00,0.00,'2022-04-04 16:55:45','',''),(288,'21','226',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,31000.00,0.00,'2022-04-04 16:55:45','',''),(289,'21','226','1',1,'Received from bridging 27',0.00,0.00,31000.00,0.00,0.00,'2022-04-04 16:55:45','',''),(290,'21','226','2',1,'Sale Id shift 17',0.00,0.00,0.00,493.90,0.00,'2022-04-04 16:56:17','',''),(291,'21','226','2',1,'Sale Id shift 17',0.00,0.00,0.00,22.08,0.00,'2022-04-04 16:56:17','',''),(292,'21','226','4',3,'Sale Id shift 17',0.00,0.00,0.00,503.00,0.00,'2022-04-04 16:56:17','',''),(293,'21','226',NULL,1,'Sale Id shift 17',85136.70,0.00,0.00,0.00,0.00,'2022-04-04 16:56:17','',''),(294,'21','226',NULL,3,'Sale Id shift 17',276650.00,0.00,0.00,0.00,0.00,'2022-04-04 16:56:17','',''),(295,'21','226','1',1,'Sale Id shift 18',0.00,0.00,0.00,7379.00,0.00,'2022-04-04 17:10:13','',''),(296,'21','226','2',1,'Sale Id shift 18',0.00,0.00,0.00,254.01,0.00,'2022-04-04 17:10:13','',''),(297,'21','226','1',1,'Sale Id shift 18',0.00,0.00,0.00,7142.68,0.00,'2022-04-04 17:10:13','',''),(298,'21','226','2',1,'Sale Id shift 18',0.00,0.00,0.00,238.92,0.00,'2022-04-04 17:10:13','',''),(299,'21','226','4',3,'Sale Id shift 18',0.00,0.00,0.00,845.89,0.00,'2022-04-04 17:10:13','',''),(300,'21','226','1',1,'Sale Id shift 18',0.00,0.00,0.00,7640.01,0.00,'2022-04-04 17:10:13','',''),(301,'21','226','1',1,'Sale Id shift 18',0.00,0.00,0.00,7152.59,0.00,'2022-04-04 17:10:13','',''),(302,'21','226','1',1,'Sale Id shift 18',0.00,0.00,0.00,245.80,0.00,'2022-04-04 17:10:13','',''),(303,'21','226','1',1,'Sale Id shift 18',0.00,0.00,0.00,44.98,0.00,'2022-04-04 17:10:13','',''),(304,'21','226',NULL,3,'Sale Id shift 18',465239.50,0.00,0.00,0.00,0.00,'2022-04-04 17:10:13','',''),(305,'21','226',NULL,1,'Sale Id shift 18',4966168.35,0.00,0.00,0.00,0.00,'2022-04-04 17:10:13','',''),(306,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2557500.00,15500.00,0.00,0.00,'2022-04-04 17:12:39','',''),(307,'21','226',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,15500.00,0.00,'2022-04-04 17:14:08','',''),(308,'21','226','1',1,'Received from bridging 29',0.00,0.00,15500.00,0.00,0.00,'2022-04-04 17:14:08','',''),(309,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,16898.91,0.00,'2022-04-04 17:22:01','',''),(310,'21','226','1',0,'Inventory adjustment from tank dipping to 17700',0.00,0.00,17700.00,0.00,0.00,'2022-04-04 17:22:01','',''),(311,'21','226','1',1,'Sale Id shift 19',0.00,0.00,0.00,1661.25,0.00,'2022-04-04 17:34:08','',''),(312,'21','226','2',1,'Sale Id shift 19',0.00,0.00,0.00,2648.63,0.00,'2022-04-04 17:34:08','',''),(313,'21','226','2',1,'Sale Id shift 19',0.00,0.00,0.00,2766.58,0.00,'2022-04-04 17:34:08','',''),(314,'21','226','1',1,'Sale Id shift 19',0.00,0.00,0.00,1936.71,0.00,'2022-04-04 17:34:08','',''),(315,'21','226','2',1,'Sale Id shift 19',0.00,0.00,0.00,2635.69,0.00,'2022-04-04 17:34:08','',''),(316,'21','226','2',1,'Sale Id shift 19',0.00,0.00,0.00,2850.29,0.00,'2022-04-04 17:34:08','',''),(317,'21','226','4',3,'Sale Id shift 19',0.00,0.00,0.00,592.52,0.00,'2022-04-04 17:34:08','',''),(318,'21','226','1',1,'Sale Id shift 19',0.00,0.00,0.00,3938.28,0.00,'2022-04-04 17:34:08','',''),(319,'21','226','1',1,'Sale Id shift 19',0.00,0.00,0.00,3309.78,0.00,'2022-04-04 17:34:08','',''),(320,'21','226','1',1,'Sale Id shift 19',0.00,0.00,0.00,2752.30,0.00,'2022-04-04 17:34:08','',''),(321,'21','226','1',1,'Sale Id shift 19',0.00,0.00,0.00,3436.67,0.00,'2022-04-04 17:34:08','',''),(322,'21','226',NULL,3,'Sale Id shift 19',325886.00,0.00,0.00,0.00,0.00,'2022-04-04 17:34:08','',''),(323,'21','226',NULL,1,'Sale Id shift 19',4609469.70,0.00,0.00,0.00,0.00,'2022-04-04 17:34:08','',''),(324,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-04 17:37:42','',''),(325,'21','226',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,15000.00,0.00,'2022-04-04 17:38:37','',''),(326,'21','226','2',1,'Received from bridging 30',0.00,0.00,15000.00,0.00,0.00,'2022-04-04 17:38:37','',''),(327,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-05 10:00:32','',''),(328,'21','226',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,45000.00,0.00,'2022-04-05 10:04:00','',''),(329,'21','226','1',1,'Received from bridging 31',0.00,0.00,45000.00,0.00,0.00,'2022-04-05 10:04:00','',''),(330,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-05 10:06:43','',''),(331,'21','226',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,15000.00,0.00,'2022-04-05 10:09:44','',''),(332,'21','226','2',1,'Received from bridging 32',0.00,0.00,15000.00,0.00,0.00,'2022-04-05 10:09:44','',''),(333,'21','226','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,506.05,0.00,'2022-04-05 11:23:12','',''),(334,'21','226','4',0,'Inventory adjustment from tank dipping to 1200',0.00,0.00,1200.00,0.00,0.00,'2022-04-05 11:23:12','',''),(335,'21','226','1',1,'Sale Id shift 20',0.00,0.00,0.00,3907.43,0.00,'2022-04-06 09:33:57','',''),(336,'21','226','2',1,'Sale Id shift 20',0.00,0.00,0.00,4476.56,0.00,'2022-04-06 09:33:57','',''),(337,'21','226','2',1,'Sale Id shift 20',0.00,0.00,0.00,4158.96,0.00,'2022-04-06 09:33:57','',''),(338,'21','226','2',1,'Sale Id shift 20',0.00,0.00,0.00,6.06,0.00,'2022-04-06 09:33:57','',''),(339,'21','226','1',1,'Sale Id shift 20',0.00,0.00,0.00,3302.81,0.00,'2022-04-06 09:33:57','',''),(340,'21','226','2',1,'Sale Id shift 20',0.00,0.00,0.00,1583.27,0.00,'2022-04-06 09:33:57','',''),(341,'21','226','2',1,'Sale Id shift 20',0.00,0.00,0.00,1786.53,0.00,'2022-04-06 09:33:57','',''),(342,'21','226','2',1,'Sale Id shift 20',0.00,0.00,0.00,3179.34,0.00,'2022-04-06 09:33:57','',''),(343,'21','226','2',1,'Sale Id shift 20',0.00,0.00,0.00,3692.13,0.00,'2022-04-06 09:33:57','',''),(344,'21','226','4',3,'Sale Id shift 20',0.00,0.00,0.00,548.94,0.00,'2022-04-06 09:33:57','',''),(345,'21','226','1',1,'Sale Id shift 20',0.00,0.00,0.00,6018.23,0.00,'2022-04-06 09:33:57','',''),(346,'21','226','1',1,'Sale Id shift 20',0.00,0.00,0.00,5080.01,0.00,'2022-04-06 09:33:57','',''),(347,'21','226','1',1,'Sale Id shift 20',0.00,0.00,0.00,1280.30,0.00,'2022-04-06 09:33:57','',''),(348,'21','226','1',1,'Sale Id shift 20',0.00,0.00,0.00,1338.66,0.00,'2022-04-06 09:33:57','',''),(349,'21','226',NULL,1,'Sale Id shift 20',6568697.85,0.00,0.00,0.00,0.00,'2022-04-06 09:33:57','',''),(350,'21','226',NULL,3,'Sale Id shift 20',301917.00,0.00,0.00,0.00,0.00,'2022-04-06 09:33:57','',''),(351,'21','226','1',1,'Sale Id shift 21',0.00,0.00,0.00,130.70,0.00,'2022-04-06 15:31:14','',''),(352,'21','226','1',1,'Sale Id shift 21',0.00,0.00,0.00,183.01,0.00,'2022-04-06 15:31:14','',''),(353,'21','226','2',1,'Sale Id shift 21',0.00,0.00,0.00,1755.27,0.00,'2022-04-06 15:31:14','',''),(354,'21','226','2',1,'Sale Id shift 21',0.00,0.00,0.00,1633.52,0.00,'2022-04-06 15:31:14','',''),(355,'21','226','2',1,'Sale Id shift 21',0.00,0.00,0.00,1412.45,0.00,'2022-04-06 15:31:14','',''),(356,'21','226','2',1,'Sale Id shift 21',0.00,0.00,0.00,1588.82,0.00,'2022-04-06 15:31:14','',''),(357,'21','226','4',3,'Sale Id shift 21',0.00,0.00,0.00,138.87,0.00,'2022-04-06 15:31:14','',''),(358,'21','226','1',1,'Sale Id shift 21',0.00,0.00,0.00,6079.59,0.00,'2022-04-06 15:31:14','',''),(359,'21','226','1',1,'Sale Id shift 21',0.00,0.00,0.00,6297.94,0.00,'2022-04-06 15:31:14','',''),(360,'21','226','1',1,'Sale Id shift 21',0.00,0.00,0.00,5721.06,0.00,'2022-04-06 15:31:14','',''),(361,'21','226','1',1,'Sale Id shift 21',0.00,0.00,0.00,5970.88,0.00,'2022-04-06 15:31:14','',''),(362,'21','226','1',1,'Sale Id shift 21',0.00,0.00,0.00,39.40,0.00,'2022-04-06 15:31:14','',''),(363,'21','226',NULL,1,'Sale Id shift 21',5084085.60,0.00,0.00,0.00,0.00,'2022-04-06 15:31:14','',''),(364,'21','226',NULL,3,'Sale Id shift 21',76378.50,0.00,0.00,0.00,0.00,'2022-04-06 15:31:14','',''),(365,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-07 07:29:30','',''),(366,'21','226',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,45000.00,0.00,'2022-04-07 07:32:31','',''),(367,'21','226','1',1,'Received from bridging 33',0.00,0.00,45000.00,0.00,0.00,'2022-04-07 07:32:31','',''),(368,'21','226','1',1,'Sale Id shift 22',0.00,0.00,0.00,893.67,0.00,'2022-04-07 07:48:22','',''),(369,'21','226','2',1,'Sale Id shift 22',0.00,0.00,0.00,665.45,0.00,'2022-04-07 07:48:22','',''),(370,'21','226','2',1,'Sale Id shift 22',0.00,0.00,0.00,767.99,0.00,'2022-04-07 07:48:22','',''),(371,'21','226','2',1,'Sale Id shift 22',0.00,0.00,0.00,330.41,0.00,'2022-04-07 07:48:22','',''),(372,'21','226','1',1,'Sale Id shift 22',0.00,0.00,0.00,586.32,0.00,'2022-04-07 07:48:22','',''),(373,'21','226','2',1,'Sale Id shift 22',0.00,0.00,0.00,296.82,0.00,'2022-04-07 07:48:22','',''),(374,'21','226','2',1,'Sale Id shift 22',0.00,0.00,0.00,3860.18,0.00,'2022-04-07 07:48:22','',''),(375,'21','226','2',1,'Sale Id shift 22',0.00,0.00,0.00,4078.43,0.00,'2022-04-07 07:48:22','',''),(376,'21','226','1',1,'Sale Id shift 22',0.00,0.00,0.00,7109.21,0.00,'2022-04-07 07:48:22','',''),(377,'21','226','1',1,'Sale Id shift 22',0.00,0.00,0.00,5747.83,0.00,'2022-04-07 07:48:22','',''),(378,'21','226','1',1,'Sale Id shift 22',0.00,0.00,0.00,5949.96,0.00,'2022-04-07 07:48:22','',''),(379,'21','226','1',1,'Sale Id shift 22',0.00,0.00,0.00,6080.86,0.00,'2022-04-07 07:48:22','',''),(380,'21','226','1',1,'Sale Id shift 22',0.00,0.00,0.00,1475.06,0.00,'2022-04-07 07:48:22','',''),(381,'21','226','1',1,'Sale Id shift 22',0.00,0.00,0.00,1307.25,0.00,'2022-04-07 07:48:22','',''),(382,'21','226',NULL,1,'Sale Id shift 22',6459657.60,0.00,0.00,0.00,0.00,'2022-04-07 07:48:22','',''),(383,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-08 11:41:24','',''),(384,'21','226',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,30000.00,0.00,'2022-04-08 11:44:27','',''),(385,'21','226','2',1,'Received from bridging 35',0.00,0.00,30000.00,0.00,0.00,'2022-04-08 11:44:27','',''),(386,'21','226',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,15000.00,0.00,'2022-04-08 11:44:27','',''),(387,'21','226','1',1,'Received from bridging 34',0.00,0.00,15000.00,0.00,0.00,'2022-04-08 11:44:27','',''),(388,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,18200000.00,26000.00,0.00,0.00,'2022-04-08 11:46:35','',''),(389,'21','226',NULL,2,'Reception corrector for bridging 36',0.00,0.00,0.00,26000.00,0.00,'2022-04-08 11:48:41','',''),(390,'21','226','3',2,'Received from bridging 36',0.00,0.00,26000.00,0.00,0.00,'2022-04-08 11:48:41','',''),(391,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-09 10:39:17','',''),(392,'21','226','1',1,'Sale Id shift 23',0.00,0.00,0.00,157.76,0.00,'2022-04-09 10:47:59','',''),(393,'21','226','2',1,'Sale Id shift 23',0.00,0.00,0.00,2658.46,0.00,'2022-04-09 10:47:59','',''),(394,'21','226','2',1,'Sale Id shift 23',0.00,0.00,0.00,1664.05,0.00,'2022-04-09 10:47:59','',''),(395,'21','226','2',1,'Sale Id shift 23',0.00,0.00,0.00,2118.74,0.00,'2022-04-09 10:47:59','',''),(396,'21','226','1',1,'Sale Id shift 23',0.00,0.00,0.00,206.60,0.00,'2022-04-09 10:47:59','',''),(397,'21','226','2',1,'Sale Id shift 23',0.00,0.00,0.00,2257.91,0.00,'2022-04-09 10:47:59','',''),(398,'21','226','2',1,'Sale Id shift 23',0.00,0.00,0.00,1921.22,0.00,'2022-04-09 10:47:59','',''),(399,'21','226','2',1,'Sale Id shift 23',0.00,0.00,0.00,1964.83,0.00,'2022-04-09 10:47:59','',''),(400,'21','226','2',1,'Sale Id shift 23',0.00,0.00,0.00,1627.33,0.00,'2022-04-09 10:47:59','',''),(401,'21','226','2',1,'Sale Id shift 23',0.00,0.00,0.00,2057.96,0.00,'2022-04-09 10:47:59','',''),(402,'21','226','3',2,'Sale Id shift 23',0.00,0.00,0.00,1898.91,0.00,'2022-04-09 10:47:59','',''),(403,'21','226','3',2,'Sale Id shift 23',0.00,0.00,0.00,2935.54,0.00,'2022-04-09 10:47:59','',''),(404,'21','226','1',1,'Sale Id shift 23',0.00,0.00,0.00,6363.83,0.00,'2022-04-09 10:47:59','',''),(405,'21','226','1',1,'Sale Id shift 23',0.00,0.00,0.00,4785.36,0.00,'2022-04-09 10:47:59','',''),(406,'21','226','1',1,'Sale Id shift 23',0.00,0.00,0.00,4466.23,0.00,'2022-04-09 10:47:59','',''),(407,'21','226','1',1,'Sale Id shift 23',0.00,0.00,0.00,3488.24,0.00,'2022-04-09 10:47:59','',''),(408,'21','226','1',1,'Sale Id shift 23',0.00,0.00,0.00,4097.67,0.00,'2022-04-09 10:47:59','',''),(409,'21','226','1',1,'Sale Id shift 23',0.00,0.00,0.00,3799.53,0.00,'2022-04-09 10:47:59','',''),(410,'21','226',NULL,2,'Sale Id shift 23',3384115.00,0.00,0.00,0.00,0.00,'2022-04-09 10:47:59','',''),(411,'21','226',NULL,1,'Sale Id shift 23',7199893.80,0.00,0.00,0.00,0.00,'2022-04-09 10:47:59','',''),(412,'21','226',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,15000.00,0.00,'2022-04-10 09:22:39','',''),(413,'21','226','2',1,'Received from bridging 38',0.00,0.00,15000.00,0.00,0.00,'2022-04-10 09:22:39','',''),(414,'21','226',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,35000.00,0.00,'2022-04-10 09:22:39','',''),(415,'21','226','1',1,'Received from bridging 37',0.00,0.00,35000.00,0.00,0.00,'2022-04-10 09:22:39','',''),(416,'21','226','2',1,'Sale Id shift 24',0.00,0.00,0.00,2951.83,0.00,'2022-04-10 09:35:52','',''),(417,'21','226','2',1,'Sale Id shift 24',0.00,0.00,0.00,3590.28,0.00,'2022-04-10 09:35:52','',''),(418,'21','226','2',1,'Sale Id shift 24',0.00,0.00,0.00,2738.44,0.00,'2022-04-10 09:35:52','',''),(419,'21','226','2',1,'Sale Id shift 24',0.00,0.00,0.00,2420.36,0.00,'2022-04-10 09:35:52','',''),(420,'21','226','2',1,'Sale Id shift 24',0.00,0.00,0.00,2005.59,0.00,'2022-04-10 09:35:52','',''),(421,'21','226','2',1,'Sale Id shift 24',0.00,0.00,0.00,2722.02,0.00,'2022-04-10 09:35:52','',''),(422,'21','226','2',1,'Sale Id shift 24',0.00,0.00,0.00,2521.39,0.00,'2022-04-10 09:35:52','',''),(423,'21','226','2',1,'Sale Id shift 24',0.00,0.00,0.00,3217.08,0.00,'2022-04-10 09:35:52','',''),(424,'21','226','3',2,'Sale Id shift 24',0.00,0.00,0.00,1177.50,0.00,'2022-04-10 09:35:52','',''),(425,'21','226','3',2,'Sale Id shift 24',0.00,0.00,0.00,1213.36,0.00,'2022-04-10 09:35:52','',''),(426,'21','226','1',1,'Sale Id shift 24',0.00,0.00,0.00,6263.79,0.00,'2022-04-10 09:35:52','',''),(427,'21','226','1',1,'Sale Id shift 24',0.00,0.00,0.00,5358.34,0.00,'2022-04-10 09:35:52','',''),(428,'21','226','1',1,'Sale Id shift 24',0.00,0.00,0.00,5800.01,0.00,'2022-04-10 09:35:52','',''),(429,'21','226','1',1,'Sale Id shift 24',0.00,0.00,0.00,4944.55,0.00,'2022-04-10 09:35:52','',''),(430,'21','226','1',1,'Sale Id shift 24',0.00,0.00,0.00,3457.99,0.00,'2022-04-10 09:35:52','',''),(431,'21','226','1',1,'Sale Id shift 24',0.00,0.00,0.00,2788.28,0.00,'2022-04-10 09:35:52','',''),(432,'21','226',NULL,1,'Sale Id shift 24',8378691.75,0.00,0.00,0.00,0.00,'2022-04-10 09:35:52','',''),(433,'21','226',NULL,2,'Sale Id shift 24',1673602.00,0.00,0.00,0.00,0.00,'2022-04-10 09:35:52','',''),(434,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-10 10:26:29','',''),(435,'21','226',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,15000.00,0.00,'2022-04-10 10:32:04','',''),(436,'21','226','2',1,'Received from bridging 40',0.00,0.00,15000.00,0.00,0.00,'2022-04-10 10:32:04','',''),(437,'21','226',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,30000.00,0.00,'2022-04-10 10:32:04','',''),(438,'21','226','1',1,'Received from bridging 39',0.00,0.00,30000.00,0.00,0.00,'2022-04-10 10:32:04','',''),(439,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-11 10:20:33','',''),(440,'21','226',NULL,1,'Returned purchase #34 to AYM SHAFA NIGERIA. LTD',4950000.00,0.00,0.00,30000.00,0.00,'2022-04-11 10:40:18','',''),(441,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-11 10:51:22','',''),(442,'21','226',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,30000.00,0.00,'2022-04-11 10:53:58','',''),(443,'21','226','1',1,'Received from bridging 41',0.00,0.00,30000.00,0.00,0.00,'2022-04-11 10:53:58','',''),(444,'21','226','1',1,'Sale Id shift 25',0.00,0.00,0.00,0.05,0.00,'2022-04-11 10:55:35','',''),(445,'21','226','2',1,'Sale Id shift 25',0.00,0.00,0.00,3399.14,0.00,'2022-04-11 10:55:35','',''),(446,'21','226','2',1,'Sale Id shift 25',0.00,0.00,0.00,3591.78,0.00,'2022-04-11 10:55:35','',''),(447,'21','226','2',1,'Sale Id shift 25',0.00,0.00,0.00,667.31,0.00,'2022-04-11 10:55:35','',''),(448,'21','226','2',1,'Sale Id shift 25',0.00,0.00,0.00,575.77,0.00,'2022-04-11 10:55:35','',''),(449,'21','226','2',1,'Sale Id shift 25',0.00,0.00,0.00,3962.18,0.00,'2022-04-11 10:55:35','',''),(450,'21','226','2',1,'Sale Id shift 25',0.00,0.00,0.00,3475.14,0.00,'2022-04-11 10:55:35','',''),(451,'21','226','3',2,'Sale Id shift 25',0.00,0.00,0.00,2176.58,0.00,'2022-04-11 10:55:35','',''),(452,'21','226','3',2,'Sale Id shift 25',0.00,0.00,0.00,939.48,0.00,'2022-04-11 10:55:35','',''),(453,'21','226','1',1,'Sale Id shift 25',0.00,0.00,0.00,6091.82,0.00,'2022-04-11 10:55:35','',''),(454,'21','226','1',1,'Sale Id shift 25',0.00,0.00,0.00,4910.29,0.00,'2022-04-11 10:55:35','',''),(455,'21','226','1',1,'Sale Id shift 25',0.00,0.00,0.00,5353.73,0.00,'2022-04-11 10:55:35','',''),(456,'21','226','1',1,'Sale Id shift 25',0.00,0.00,0.00,4143.08,0.00,'2022-04-11 10:55:35','',''),(457,'21','226','1',1,'Sale Id shift 25',0.00,0.00,0.00,3796.07,0.00,'2022-04-11 10:55:35','',''),(458,'21','226','1',1,'Sale Id shift 25',0.00,0.00,0.00,3803.84,0.00,'2022-04-11 10:55:35','',''),(459,'21','226',NULL,1,'Sale Id shift 25',7222083.00,0.00,0.00,0.00,0.00,'2022-04-11 10:55:35','',''),(460,'21','226',NULL,2,'Sale Id shift 25',2181242.00,0.00,0.00,0.00,0.00,'2022-04-11 10:55:35','',''),(461,'21','226','2',1,'Sale Id shift 26',0.00,0.00,0.00,2450.55,0.00,'2022-04-12 16:16:51','',''),(462,'21','226','2',1,'Sale Id shift 26',0.00,0.00,0.00,2688.31,0.00,'2022-04-12 16:16:51','',''),(463,'21','226','3',2,'Sale Id shift 26',0.00,0.00,0.00,1215.30,0.00,'2022-04-12 16:16:51','',''),(464,'21','226','3',2,'Sale Id shift 26',0.00,0.00,0.00,3914.36,0.00,'2022-04-12 16:16:51','',''),(465,'21','226','1',1,'Sale Id shift 26',0.00,0.00,0.00,6457.98,0.00,'2022-04-12 16:16:51','',''),(466,'21','226','1',1,'Sale Id shift 26',0.00,0.00,0.00,6784.53,0.00,'2022-04-12 16:16:51','',''),(467,'21','226','1',1,'Sale Id shift 26',0.00,0.00,0.00,739.27,0.00,'2022-04-12 16:16:51','',''),(468,'21','226','1',1,'Sale Id shift 26',0.00,0.00,0.00,866.02,0.00,'2022-04-12 16:16:51','',''),(469,'21','226',NULL,2,'Sale Id shift 26',3590762.00,0.00,0.00,0.00,0.00,'2022-04-12 16:16:51','',''),(470,'21','226',NULL,1,'Sale Id shift 26',3297798.90,0.00,0.00,0.00,0.00,'2022-04-12 16:16:51','',''),(471,'21','226','2',1,'Sale Id shift 27',0.00,0.00,0.00,12.12,0.00,'2022-04-12 17:13:14','',''),(472,'21','226','2',1,'Sale Id shift 27',0.00,0.00,0.00,12.12,0.00,'2022-04-12 17:13:14','',''),(473,'21','226','3',2,'Sale Id shift 27',0.00,0.00,0.00,952.73,0.00,'2022-04-12 17:13:14','',''),(474,'21','226','3',2,'Sale Id shift 27',0.00,0.00,0.00,15.00,0.00,'2022-04-12 17:13:14','',''),(475,'21','226','3',2,'Sale Id shift 27',0.00,0.00,0.00,1277.88,0.00,'2022-04-12 17:13:14','',''),(476,'21','226','1',1,'Sale Id shift 27',0.00,0.00,0.00,6557.52,0.00,'2022-04-12 17:13:14','',''),(477,'21','226','1',1,'Sale Id shift 27',0.00,0.00,0.00,6417.63,0.00,'2022-04-12 17:13:14','',''),(478,'21','226','1',1,'Sale Id shift 27',0.00,0.00,0.00,6918.06,0.00,'2022-04-12 17:13:14','',''),(479,'21','226','1',1,'Sale Id shift 27',0.00,0.00,0.00,6960.28,0.00,'2022-04-12 17:13:14','',''),(480,'21','226','1',1,'Sale Id shift 27',0.00,0.00,0.00,4.24,0.00,'2022-04-12 17:13:14','',''),(481,'21','226',NULL,1,'Sale Id shift 27',4435525.05,0.00,0.00,0.00,0.00,'2022-04-12 17:13:14','',''),(482,'21','226',NULL,2,'Sale Id shift 27',1571927.00,0.00,0.00,0.00,0.00,'2022-04-12 17:13:14','',''),(483,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-13 10:43:46','',''),(484,'21','226',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,15000.00,0.00,'2022-04-13 10:49:00','',''),(485,'21','226','2',1,'Received from bridging 43',0.00,0.00,15000.00,0.00,0.00,'2022-04-13 10:49:00','',''),(486,'21','226',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,30000.00,0.00,'2022-04-13 10:49:01','',''),(487,'21','226','1',1,'Received from bridging 42',0.00,0.00,30000.00,0.00,0.00,'2022-04-13 10:49:01','',''),(488,'21','226','2',1,'Sale Id shift 28',0.00,0.00,0.00,182.09,0.00,'2022-04-13 10:56:28','',''),(489,'21','226','2',1,'Sale Id shift 28',0.00,0.00,0.00,148.85,0.00,'2022-04-13 10:56:28','',''),(490,'21','226','3',2,'Sale Id shift 28',0.00,0.00,0.00,1749.95,0.00,'2022-04-13 10:56:28','',''),(491,'21','226','3',2,'Sale Id shift 28',0.00,0.00,0.00,673.98,0.00,'2022-04-13 10:56:28','',''),(492,'21','226',NULL,1,'Sale Id shift 28',54605.10,0.00,0.00,0.00,0.00,'2022-04-13 10:56:28','',''),(493,'21','226',NULL,2,'Sale Id shift 28',1696751.00,0.00,0.00,0.00,0.00,'2022-04-13 10:56:28','',''),(494,'21','226',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24255000.00,44100.00,0.00,0.00,'2022-04-14 09:08:37','',''),(495,'21','226',NULL,3,'Reception corrector for bridging 44',0.00,0.00,0.00,44100.00,0.00,'2022-04-14 09:10:40','',''),(496,'21','226','4',3,'Received from bridging 44',0.00,0.00,44100.00,0.00,0.00,'2022-04-14 09:10:40','',''),(497,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-15 10:42:52','',''),(498,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-15 10:46:24','',''),(499,'21','226','3',2,'Sale Id shift 29',0.00,0.00,0.00,1676.05,0.00,'2022-04-15 10:50:54','',''),(500,'21','226','3',2,'Sale Id shift 29',0.00,0.00,0.00,2850.54,0.00,'2022-04-15 10:50:54','',''),(501,'21','226','4',3,'Sale Id shift 29',0.00,0.00,0.00,245.40,0.00,'2022-04-15 10:50:54','',''),(502,'21','226','1',1,'Sale Id shift 29',0.00,0.00,0.00,7345.55,0.00,'2022-04-15 10:50:54','',''),(503,'21','226','1',1,'Sale Id shift 29',0.00,0.00,0.00,7151.38,0.00,'2022-04-15 10:50:54','',''),(504,'21','226','1',1,'Sale Id shift 29',0.00,0.00,0.00,7200.39,0.00,'2022-04-15 10:50:54','',''),(505,'21','226','1',1,'Sale Id shift 29',0.00,0.00,0.00,8263.38,0.00,'2022-04-15 10:50:54','',''),(506,'21','226',NULL,2,'Sale Id shift 29',3168613.00,0.00,0.00,0.00,0.00,'2022-04-15 10:50:54','',''),(507,'21','226',NULL,3,'Sale Id shift 29',134970.00,0.00,0.00,0.00,0.00,'2022-04-15 10:50:54','',''),(508,'21','226',NULL,1,'Sale Id shift 29',4943515.50,0.00,0.00,0.00,0.00,'2022-04-15 10:50:54','',''),(509,'21','226',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,45000.00,0.00,'2022-04-15 11:09:05','',''),(510,'21','226','1',1,'Received from bridging 46',0.00,0.00,45000.00,0.00,0.00,'2022-04-15 11:09:05','',''),(511,'21','226','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,1476.46,0.00,'2022-04-15 11:54:59','',''),(512,'21','226','3',0,'Inventory adjustment from tank dipping to 1523',0.00,0.00,1523.00,0.00,0.00,'2022-04-15 11:54:59','',''),(513,'21','226','2',1,'Sale Id shift 30',0.00,0.00,0.00,3986.88,0.00,'2022-04-15 12:03:26','',''),(514,'21','226','2',1,'Sale Id shift 30',0.00,0.00,0.00,4040.39,0.00,'2022-04-15 12:03:26','',''),(515,'21','226','2',1,'Sale Id shift 30',0.00,0.00,0.00,39.39,0.00,'2022-04-15 12:03:26','',''),(516,'21','226','2',1,'Sale Id shift 30',0.00,0.00,0.00,3645.08,0.00,'2022-04-15 12:03:26','',''),(517,'21','226','2',1,'Sale Id shift 30',0.00,0.00,0.00,3675.84,0.00,'2022-04-15 12:03:26','',''),(518,'21','226','3',2,'Sale Id shift 30',0.00,0.00,0.00,594.54,0.00,'2022-04-15 12:03:26','',''),(519,'21','226','3',2,'Sale Id shift 30',0.00,0.00,0.00,927.78,0.00,'2022-04-15 12:03:26','',''),(520,'21','226','4',3,'Sale Id shift 30',0.00,0.00,0.00,382.20,0.00,'2022-04-15 12:03:26','',''),(521,'21','226','1',1,'Sale Id shift 30',0.00,0.00,0.00,4519.16,0.00,'2022-04-15 12:03:26','',''),(522,'21','226','1',1,'Sale Id shift 30',0.00,0.00,0.00,4475.72,0.00,'2022-04-15 12:03:26','',''),(523,'21','226','1',1,'Sale Id shift 30',0.00,0.00,0.00,2020.84,0.00,'2022-04-15 12:03:26','',''),(524,'21','226','1',1,'Sale Id shift 30',0.00,0.00,0.00,2347.53,0.00,'2022-04-15 12:03:26','',''),(525,'21','226','1',1,'Sale Id shift 30',0.00,0.00,0.00,1680.98,0.00,'2022-04-15 12:03:26','',''),(526,'21','226','1',1,'Sale Id shift 30',0.00,0.00,0.00,1812.95,0.00,'2022-04-15 12:03:26','',''),(527,'21','226',NULL,1,'Sale Id shift 30',5320385.40,0.00,0.00,0.00,0.00,'2022-04-15 12:03:26','',''),(528,'21','226',NULL,2,'Sale Id shift 30',1065624.00,0.00,0.00,0.00,0.00,'2022-04-15 12:03:26','',''),(529,'21','226',NULL,3,'Sale Id shift 30',210210.00,0.00,0.00,0.00,0.00,'2022-04-15 12:03:26','',''),(530,'21','226',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,40000.00,0.00,'2022-04-15 13:52:44','',''),(531,'21','226','2',1,'Received from bridging 47',0.00,0.00,40000.00,0.00,0.00,'2022-04-15 13:52:44','',''),(532,'21','226','2',1,'Sale Id shift 31',0.00,0.00,0.00,1104.85,0.00,'2022-04-16 18:00:53','',''),(533,'21','226','2',1,'Sale Id shift 31',0.00,0.00,0.00,1147.61,0.00,'2022-04-16 18:00:53','',''),(534,'21','226','2',1,'Sale Id shift 31',0.00,0.00,0.00,3352.59,0.00,'2022-04-16 18:00:53','',''),(535,'21','226','2',1,'Sale Id shift 31',0.00,0.00,0.00,3565.42,0.00,'2022-04-16 18:00:53','',''),(536,'21','226','2',1,'Sale Id shift 31',0.00,0.00,0.00,3237.58,0.00,'2022-04-16 18:00:53','',''),(537,'21','226','2',1,'Sale Id shift 31',0.00,0.00,0.00,3312.61,0.00,'2022-04-16 18:00:53','',''),(538,'21','226','4',3,'Sale Id shift 31',0.00,0.00,0.00,258.22,0.00,'2022-04-16 18:00:53','',''),(539,'21','226','1',1,'Sale Id shift 31',0.00,0.00,0.00,4489.38,0.00,'2022-04-16 18:00:53','',''),(540,'21','226','1',1,'Sale Id shift 31',0.00,0.00,0.00,3849.50,0.00,'2022-04-16 18:00:53','',''),(541,'21','226','1',1,'Sale Id shift 31',0.00,0.00,0.00,4224.03,0.00,'2022-04-16 18:00:53','',''),(542,'21','226','1',1,'Sale Id shift 31',0.00,0.00,0.00,3552.47,0.00,'2022-04-16 18:00:53','',''),(543,'21','226',NULL,1,'Sale Id shift 31',5252946.60,0.00,0.00,0.00,0.00,'2022-04-16 18:00:53','',''),(544,'21','226',NULL,3,'Sale Id shift 31',142021.00,0.00,0.00,0.00,0.00,'2022-04-16 18:00:53','',''),(545,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-17 14:35:00','',''),(546,'21','226',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,15000.00,0.00,'2022-04-17 14:37:35','',''),(547,'21','226','2',1,'Received from bridging 49',0.00,0.00,15000.00,0.00,0.00,'2022-04-17 14:37:35','',''),(548,'21','226',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,30000.00,0.00,'2022-04-17 14:37:35','',''),(549,'21','226','1',1,'Received from bridging 48',0.00,0.00,30000.00,0.00,0.00,'2022-04-17 14:37:35','',''),(550,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,31500000.00,45000.00,0.00,0.00,'2022-04-18 10:09:23','',''),(551,'21','226','2',1,'Sale Id shift 32',0.00,0.00,0.00,4241.82,0.00,'2022-04-18 10:16:29','',''),(552,'21','226','2',1,'Sale Id shift 32',0.00,0.00,0.00,4731.52,0.00,'2022-04-18 10:16:29','',''),(553,'21','226','4',3,'Sale Id shift 32',0.00,0.00,0.00,2476.35,0.00,'2022-04-18 10:16:29','',''),(554,'21','226','1',1,'Sale Id shift 32',0.00,0.00,0.00,6157.18,0.00,'2022-04-18 10:16:29','',''),(555,'21','226','1',1,'Sale Id shift 32',0.00,0.00,0.00,5486.94,0.00,'2022-04-18 10:16:29','',''),(556,'21','226','1',1,'Sale Id shift 32',0.00,0.00,0.00,5537.57,0.00,'2022-04-18 10:16:29','',''),(557,'21','226','1',1,'Sale Id shift 32',0.00,0.00,0.00,6630.93,0.00,'2022-04-18 10:16:29','',''),(558,'21','226',NULL,3,'Sale Id shift 32',1361992.50,0.00,0.00,0.00,0.00,'2022-04-18 10:16:29','',''),(559,'21','226',NULL,1,'Sale Id shift 32',5409683.40,0.00,0.00,0.00,0.00,'2022-04-18 10:16:29','',''),(560,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-18 10:17:20','',''),(561,'21','226',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,45000.00,0.00,'2022-04-18 10:19:40','',''),(562,'21','226','1',1,'Received from bridging 51',0.00,0.00,45000.00,0.00,0.00,'2022-04-18 10:19:40','',''),(563,'21','226',NULL,2,'Reception corrector for bridging 50',0.00,0.00,0.00,45000.00,0.00,'2022-04-18 10:30:34','',''),(564,'21','226','3',2,'Received from bridging 50',0.00,0.00,45000.00,0.00,0.00,'2022-04-18 10:30:34','',''),(565,'21','226','1',1,'Sale Id shift 33',0.00,0.00,0.00,0.22,0.00,'2022-04-18 21:20:04','',''),(566,'21','226','2',1,'Sale Id shift 33',0.00,0.00,0.00,5191.22,0.00,'2022-04-18 21:20:04','',''),(567,'21','226','2',1,'Sale Id shift 33',0.00,0.00,0.00,5381.59,0.00,'2022-04-18 21:20:04','',''),(568,'21','226','2',1,'Sale Id shift 33',0.00,0.00,0.00,290.11,0.00,'2022-04-18 21:20:04','',''),(569,'21','226','2',1,'Sale Id shift 33',0.00,0.00,0.00,344.42,0.00,'2022-04-18 21:20:04','',''),(570,'21','226','2',1,'Sale Id shift 33',0.00,0.00,0.00,549.00,0.00,'2022-04-18 21:20:04','',''),(571,'21','226','2',1,'Sale Id shift 33',0.00,0.00,0.00,438.87,0.00,'2022-04-18 21:20:04','',''),(572,'21','226','3',2,'Sale Id shift 33',0.00,0.00,0.00,899.69,0.00,'2022-04-18 21:20:04','',''),(573,'21','226','3',2,'Sale Id shift 33',0.00,0.00,0.00,861.98,0.00,'2022-04-18 21:20:04','',''),(574,'21','226','4',3,'Sale Id shift 33',0.00,0.00,0.00,129.12,0.00,'2022-04-18 21:20:04','',''),(575,'21','226','1',1,'Sale Id shift 33',0.00,0.00,0.00,5636.83,0.00,'2022-04-18 21:20:04','',''),(576,'21','226','1',1,'Sale Id shift 33',0.00,0.00,0.00,5288.78,0.00,'2022-04-18 21:20:04','',''),(577,'21','226','1',1,'Sale Id shift 33',0.00,0.00,0.00,3814.94,0.00,'2022-04-18 21:20:04','',''),(578,'21','226','1',1,'Sale Id shift 33',0.00,0.00,0.00,3708.03,0.00,'2022-04-18 21:20:04','',''),(579,'21','226',NULL,1,'Sale Id shift 33',5056261.65,0.00,0.00,0.00,0.00,'2022-04-18 21:20:04','',''),(580,'21','226',NULL,2,'Sale Id shift 33',1233169.00,0.00,0.00,0.00,0.00,'2022-04-18 21:20:04','',''),(581,'21','226',NULL,3,'Sale Id shift 33',71016.00,0.00,0.00,0.00,0.00,'2022-04-18 21:20:04','',''),(582,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-19 12:34:27','',''),(583,'21','226',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,15000.00,0.00,'2022-04-19 12:40:46','',''),(584,'21','226','2',1,'Received from bridging 52',0.00,0.00,15000.00,0.00,0.00,'2022-04-19 12:40:46','',''),(585,'21','226','2',1,'Sale Id shift 34',0.00,0.00,0.00,2337.81,0.00,'2022-04-19 20:47:34','',''),(586,'21','226','2',1,'Sale Id shift 34',0.00,0.00,0.00,2205.43,0.00,'2022-04-19 20:47:34','',''),(587,'21','226','2',1,'Sale Id shift 34',0.00,0.00,0.00,2068.10,0.00,'2022-04-19 20:47:34','',''),(588,'21','226','1',1,'Sale Id shift 34',0.00,0.00,0.00,320.75,0.00,'2022-04-19 20:47:34','',''),(589,'21','226','2',1,'Sale Id shift 34',0.00,0.00,0.00,2067.74,0.00,'2022-04-19 20:47:34','',''),(590,'21','226','2',1,'Sale Id shift 34',0.00,0.00,0.00,2456.15,0.00,'2022-04-19 20:47:34','',''),(591,'21','226','2',1,'Sale Id shift 34',0.00,0.00,0.00,2873.35,0.00,'2022-04-19 20:47:34','',''),(592,'21','226','2',1,'Sale Id shift 34',0.00,0.00,0.00,2392.76,0.00,'2022-04-19 20:47:34','',''),(593,'21','226','2',1,'Sale Id shift 34',0.00,0.00,0.00,2509.49,0.00,'2022-04-19 20:47:34','',''),(594,'21','226','3',2,'Sale Id shift 34',0.00,0.00,0.00,543.12,0.00,'2022-04-19 20:47:34','',''),(595,'21','226','3',2,'Sale Id shift 34',0.00,0.00,0.00,1715.86,0.00,'2022-04-19 20:47:34','',''),(596,'21','226','4',3,'Sale Id shift 34',0.00,0.00,0.00,425.13,0.00,'2022-04-19 20:47:34','',''),(597,'21','226','1',1,'Sale Id shift 34',0.00,0.00,0.00,5174.13,0.00,'2022-04-19 20:47:34','',''),(598,'21','226','1',1,'Sale Id shift 34',0.00,0.00,0.00,5053.61,0.00,'2022-04-19 20:47:34','',''),(599,'21','226','1',1,'Sale Id shift 34',0.00,0.00,0.00,5564.76,0.00,'2022-04-19 20:47:34','',''),(600,'21','226','1',1,'Sale Id shift 34',0.00,0.00,0.00,5132.07,0.00,'2022-04-19 20:47:34','',''),(601,'21','226','1',1,'Sale Id shift 34',0.00,0.00,0.00,561.43,0.00,'2022-04-19 20:47:34','',''),(602,'21','226','1',1,'Sale Id shift 34',0.00,0.00,0.00,415.99,0.00,'2022-04-19 20:47:34','',''),(603,'21','226',NULL,1,'Sale Id shift 34',6787039.05,0.00,0.00,0.00,0.00,'2022-04-19 20:47:34','',''),(604,'21','226',NULL,2,'Sale Id shift 34',1581286.00,0.00,0.00,0.00,0.00,'2022-04-19 20:47:34','',''),(605,'21','226',NULL,3,'Sale Id shift 34',233821.50,0.00,0.00,0.00,0.00,'2022-04-19 20:47:34','',''),(606,'21','226',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 20:51:35','',''),(607,'21','226','2',1,'Received from bridging 53',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 20:51:35','',''),(608,'21','226','2',1,'Sale Id shift 35',0.00,0.00,0.00,2614.75,0.00,'2022-04-20 23:12:07','',''),(609,'21','226','2',1,'Sale Id shift 35',0.00,0.00,0.00,2186.52,0.00,'2022-04-20 23:12:07','',''),(610,'21','226','2',1,'Sale Id shift 35',0.00,0.00,0.00,3935.99,0.00,'2022-04-20 23:12:07','',''),(611,'21','226','2',1,'Sale Id shift 35',0.00,0.00,0.00,3884.33,0.00,'2022-04-20 23:12:07','',''),(612,'21','226','2',1,'Sale Id shift 35',0.00,0.00,0.00,3339.98,0.00,'2022-04-20 23:12:07','',''),(613,'21','226','2',1,'Sale Id shift 35',0.00,0.00,0.00,4893.35,0.00,'2022-04-20 23:12:07','',''),(614,'21','226','2',1,'Sale Id shift 35',0.00,0.00,0.00,3911.49,0.00,'2022-04-20 23:12:07','',''),(615,'21','226','2',1,'Sale Id shift 35',0.00,0.00,0.00,3763.14,0.00,'2022-04-20 23:12:07','',''),(616,'21','226','3',2,'Sale Id shift 35',0.00,0.00,0.00,815.10,0.00,'2022-04-20 23:12:07','',''),(617,'21','226','3',2,'Sale Id shift 35',0.00,0.00,0.00,864.65,0.00,'2022-04-20 23:12:07','',''),(618,'21','226','4',3,'Sale Id shift 35',0.00,0.00,0.00,385.56,0.00,'2022-04-20 23:12:07','',''),(619,'21','226','1',1,'Sale Id shift 35',0.00,0.00,0.00,5550.41,0.00,'2022-04-20 23:12:07','',''),(620,'21','226','1',1,'Sale Id shift 35',0.00,0.00,0.00,4108.83,0.00,'2022-04-20 23:12:07','',''),(621,'21','226','1',1,'Sale Id shift 35',0.00,0.00,0.00,2956.12,0.00,'2022-04-20 23:12:07','',''),(622,'21','226','1',1,'Sale Id shift 35',0.00,0.00,0.00,2443.30,0.00,'2022-04-20 23:12:07','',''),(623,'21','226','1',1,'Sale Id shift 35',0.00,0.00,0.00,4160.59,0.00,'2022-04-20 23:12:07','',''),(624,'21','226','1',1,'Sale Id shift 35',0.00,0.00,0.00,3675.77,0.00,'2022-04-20 23:12:07','',''),(625,'21','226',NULL,1,'Sale Id shift 35',8485054.05,0.00,0.00,0.00,0.00,'2022-04-20 23:12:07','',''),(626,'21','226',NULL,2,'Sale Id shift 35',1175825.00,0.00,0.00,0.00,0.00,'2022-04-20 23:12:07','',''),(627,'21','226',NULL,3,'Sale Id shift 35',212058.00,0.00,0.00,0.00,0.00,'2022-04-20 23:12:07','',''),(628,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-21 12:30:25','',''),(629,'21','226',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,45000.00,0.00,'2022-04-21 12:32:20','',''),(630,'21','226','1',1,'Received from bridging 54',0.00,0.00,45000.00,0.00,0.00,'2022-04-21 12:32:20','',''),(631,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-22 09:31:55','',''),(632,'21','226',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,15000.00,0.00,'2022-04-22 09:34:16','',''),(633,'21','226','2',1,'Received from bridging 55',0.00,0.00,15000.00,0.00,0.00,'2022-04-22 09:34:16','',''),(634,'21','226','2',1,'Sale Id shift 36',0.00,0.00,0.00,2544.00,0.00,'2022-04-22 09:52:58','',''),(635,'21','226','2',1,'Sale Id shift 36',0.00,0.00,0.00,3587.74,0.00,'2022-04-22 09:52:58','',''),(636,'21','226','2',1,'Sale Id shift 36',0.00,0.00,0.00,1727.80,0.00,'2022-04-22 09:52:58','',''),(637,'21','226','2',1,'Sale Id shift 36',0.00,0.00,0.00,1819.28,0.00,'2022-04-22 09:52:58','',''),(638,'21','226','2',1,'Sale Id shift 36',0.00,0.00,0.00,3187.37,0.00,'2022-04-22 09:52:58','',''),(639,'21','226','2',1,'Sale Id shift 36',0.00,0.00,0.00,3674.07,0.00,'2022-04-22 09:52:58','',''),(640,'21','226','3',2,'Sale Id shift 36',0.00,0.00,0.00,825.32,0.00,'2022-04-22 09:52:58','',''),(641,'21','226','3',2,'Sale Id shift 36',0.00,0.00,0.00,2912.37,0.00,'2022-04-22 09:52:58','',''),(642,'21','226','4',3,'Sale Id shift 36',0.00,0.00,0.00,385.44,0.00,'2022-04-22 09:52:58','',''),(643,'21','226','1',1,'Sale Id shift 36',0.00,0.00,0.00,6634.42,0.00,'2022-04-22 09:52:58','',''),(644,'21','226','1',1,'Sale Id shift 36',0.00,0.00,0.00,5810.86,0.00,'2022-04-22 09:52:58','',''),(645,'21','226','1',1,'Sale Id shift 36',0.00,0.00,0.00,4317.29,0.00,'2022-04-22 09:52:58','',''),(646,'21','226','1',1,'Sale Id shift 36',0.00,0.00,0.00,4118.20,0.00,'2022-04-22 09:52:58','',''),(647,'21','226','1',1,'Sale Id shift 36',0.00,0.00,0.00,3300.72,0.00,'2022-04-22 09:52:58','',''),(648,'21','226','1',1,'Sale Id shift 36',0.00,0.00,0.00,3984.39,0.00,'2022-04-22 09:52:58','',''),(649,'21','226',NULL,1,'Sale Id shift 36',7376513.10,0.00,0.00,0.00,0.00,'2022-04-22 09:52:58','',''),(650,'21','226',NULL,2,'Sale Id shift 36',2616383.00,0.00,0.00,0.00,0.00,'2022-04-22 09:52:58','',''),(651,'21','226',NULL,3,'Sale Id shift 36',211992.00,0.00,0.00,0.00,0.00,'2022-04-22 09:52:58','',''),(652,'21','226',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,30000.00,0.00,'2022-04-22 09:55:12','',''),(653,'21','226','2',1,'Received from bridging 56',0.00,0.00,30000.00,0.00,0.00,'2022-04-22 09:55:12','',''),(654,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-22 09:55:31','',''),(655,'21','226',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,45000.00,0.00,'2022-04-22 09:56:57','',''),(656,'21','226','1',1,'Received from bridging 57',0.00,0.00,45000.00,0.00,0.00,'2022-04-22 09:56:57','',''),(657,'21','226','3',2,'Sale Id shift 37',0.00,0.00,0.00,897.66,0.00,'2022-04-22 10:12:21','',''),(658,'21','226','3',2,'Sale Id shift 37',0.00,0.00,0.00,435.69,0.00,'2022-04-22 10:12:21','',''),(659,'21','226',NULL,2,'Sale Id shift 37',933345.00,0.00,0.00,0.00,0.00,'2022-04-22 10:12:21','',''),(660,'21','226','2',1,'Sale Id shift 38',0.00,0.00,0.00,3305.75,0.00,'2022-04-22 10:24:03','',''),(661,'21','226','2',1,'Sale Id shift 38',0.00,0.00,0.00,3855.05,0.00,'2022-04-22 10:24:03','',''),(662,'21','226','2',1,'Sale Id shift 38',0.00,0.00,0.00,2474.79,0.00,'2022-04-22 10:24:03','',''),(663,'21','226','2',1,'Sale Id shift 38',0.00,0.00,0.00,2408.68,0.00,'2022-04-22 10:24:03','',''),(664,'21','226','2',1,'Sale Id shift 38',0.00,0.00,0.00,1693.28,0.00,'2022-04-22 10:24:03','',''),(665,'21','226','2',1,'Sale Id shift 38',0.00,0.00,0.00,1973.51,0.00,'2022-04-22 10:24:03','',''),(666,'21','226','2',1,'Sale Id shift 38',0.00,0.00,0.00,3056.64,0.00,'2022-04-22 10:24:03','',''),(667,'21','226','2',1,'Sale Id shift 38',0.00,0.00,0.00,3543.86,0.00,'2022-04-22 10:24:03','',''),(668,'21','226','3',2,'Sale Id shift 38',0.00,0.00,0.00,1641.86,0.00,'2022-04-22 10:24:03','',''),(669,'21','226','3',2,'Sale Id shift 38',0.00,0.00,0.00,517.03,0.00,'2022-04-22 10:24:03','',''),(670,'21','226','4',3,'Sale Id shift 38',0.00,0.00,0.00,477.95,0.00,'2022-04-22 10:24:03','',''),(671,'21','226','1',1,'Sale Id shift 38',0.00,0.00,0.00,5573.00,0.00,'2022-04-22 10:24:03','',''),(672,'21','226','1',1,'Sale Id shift 38',0.00,0.00,0.00,5289.59,0.00,'2022-04-22 10:24:03','',''),(673,'21','226','1',1,'Sale Id shift 38',0.00,0.00,0.00,4005.90,0.00,'2022-04-22 10:24:03','',''),(674,'21','226','1',1,'Sale Id shift 38',0.00,0.00,0.00,4105.84,0.00,'2022-04-22 10:24:03','',''),(675,'21','226','1',1,'Sale Id shift 38',0.00,0.00,0.00,918.28,0.00,'2022-04-22 10:24:03','',''),(676,'21','226','1',1,'Sale Id shift 38',0.00,0.00,0.00,743.37,0.00,'2022-04-22 10:24:03','',''),(677,'21','226',NULL,2,'Sale Id shift 38',1468045.20,0.00,0.00,0.00,0.00,'2022-04-22 10:24:03','',''),(678,'21','226',NULL,3,'Sale Id shift 38',262872.50,0.00,0.00,0.00,0.00,'2022-04-22 10:24:03','',''),(679,'21','226',NULL,1,'Sale Id shift 38',7086344.10,0.00,0.00,0.00,0.00,'2022-04-22 10:24:03','',''),(680,'21','226','2',1,'Sale Id shift 39',0.00,0.00,0.00,4232.13,0.00,'2022-04-23 18:39:24','',''),(681,'21','226','2',1,'Sale Id shift 39',0.00,0.00,0.00,4802.17,0.00,'2022-04-23 18:39:24','',''),(682,'21','226','2',1,'Sale Id shift 39',0.00,0.00,0.00,2342.21,0.00,'2022-04-23 18:39:24','',''),(683,'21','226','2',1,'Sale Id shift 39',0.00,0.00,0.00,2553.69,0.00,'2022-04-23 18:39:24','',''),(684,'21','226','2',1,'Sale Id shift 39',0.00,0.00,0.00,2298.37,0.00,'2022-04-23 18:39:24','',''),(685,'21','226','2',1,'Sale Id shift 39',0.00,0.00,0.00,2583.49,0.00,'2022-04-23 18:39:24','',''),(686,'21','226','3',2,'Sale Id shift 39',0.00,0.00,0.00,501.23,0.00,'2022-04-23 18:39:24','',''),(687,'21','226','3',2,'Sale Id shift 39',0.00,0.00,0.00,2798.71,0.00,'2022-04-23 18:39:24','',''),(688,'21','226','4',3,'Sale Id shift 39',0.00,0.00,0.00,458.40,0.00,'2022-04-23 18:39:24','',''),(689,'21','226','1',1,'Sale Id shift 39',0.00,0.00,0.00,5774.00,0.00,'2022-04-23 18:39:24','',''),(690,'21','226','1',1,'Sale Id shift 39',0.00,0.00,0.00,4771.90,0.00,'2022-04-23 18:39:24','',''),(691,'21','226','1',1,'Sale Id shift 39',0.00,0.00,0.00,3045.82,0.00,'2022-04-23 18:39:24','',''),(692,'21','226','1',1,'Sale Id shift 39',0.00,0.00,0.00,3457.15,0.00,'2022-04-23 18:39:24','',''),(693,'21','226','1',1,'Sale Id shift 39',0.00,0.00,0.00,5166.12,0.00,'2022-04-23 18:39:24','',''),(694,'21','226','1',1,'Sale Id shift 39',0.00,0.00,0.00,5654.01,0.00,'2022-04-23 18:39:24','',''),(695,'21','226',NULL,1,'Sale Id shift 39',7702374.90,0.00,0.00,0.00,0.00,'2022-04-23 18:39:24','',''),(696,'21','226',NULL,2,'Sale Id shift 39',2243959.20,0.00,0.00,0.00,0.00,'2022-04-23 18:39:24','',''),(697,'21','226',NULL,3,'Sale Id shift 39',252120.00,0.00,0.00,0.00,0.00,'2022-04-23 18:39:24','',''),(698,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-24 16:45:41','',''),(699,'21','226',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,30000.00,0.00,'2022-04-24 16:47:25','',''),(700,'21','226','2',1,'Received from bridging 59',0.00,0.00,30000.00,0.00,0.00,'2022-04-24 16:47:25','',''),(701,'21','226',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,15000.00,0.00,'2022-04-24 16:47:25','',''),(702,'21','226','1',1,'Received from bridging 58',0.00,0.00,15000.00,0.00,0.00,'2022-04-24 16:47:25','',''),(703,'21','226','2',1,'Sale Id shift 40',0.00,0.00,0.00,1298.89,0.00,'2022-04-24 20:03:55','',''),(704,'21','226','2',1,'Sale Id shift 40',0.00,0.00,0.00,1166.65,0.00,'2022-04-24 20:03:55','',''),(705,'21','226','2',1,'Sale Id shift 40',0.00,0.00,0.00,3341.42,0.00,'2022-04-24 20:03:55','',''),(706,'21','226','2',1,'Sale Id shift 40',0.00,0.00,0.00,3692.60,0.00,'2022-04-24 20:03:55','',''),(707,'21','226','3',2,'Sale Id shift 40',0.00,0.00,0.00,2263.88,0.00,'2022-04-24 20:03:55','',''),(708,'21','226','3',2,'Sale Id shift 40',0.00,0.00,0.00,2940.61,0.00,'2022-04-24 20:03:55','',''),(709,'21','226','4',3,'Sale Id shift 40',0.00,0.00,0.00,747.44,0.00,'2022-04-24 20:03:55','',''),(710,'21','226','1',1,'Sale Id shift 40',0.00,0.00,0.00,317.22,0.00,'2022-04-24 20:03:55','',''),(711,'21','226','1',1,'Sale Id shift 40',0.00,0.00,0.00,406.30,0.00,'2022-04-24 20:03:55','',''),(712,'21','226','1',1,'Sale Id shift 40',0.00,0.00,0.00,6064.26,0.00,'2022-04-24 20:03:55','',''),(713,'21','226','1',1,'Sale Id shift 40',0.00,0.00,0.00,6644.87,0.00,'2022-04-24 20:03:55','',''),(714,'21','226',NULL,1,'Sale Id shift 40',3783814.65,0.00,0.00,0.00,0.00,'2022-04-24 20:03:55','',''),(715,'21','226',NULL,2,'Sale Id shift 40',3539053.20,0.00,0.00,0.00,0.00,'2022-04-24 20:03:55','',''),(716,'21','226',NULL,3,'Sale Id shift 40',411092.00,0.00,0.00,0.00,0.00,'2022-04-24 20:03:55','',''),(717,'21','226','2',1,'Sale Id shift 41',0.00,0.00,0.00,5708.36,0.00,'2022-04-26 09:56:11','',''),(718,'21','226','2',1,'Sale Id shift 41',0.00,0.00,0.00,5984.69,0.00,'2022-04-26 09:56:11','',''),(719,'21','226','2',1,'Sale Id shift 41',0.00,0.00,0.00,5172.65,0.00,'2022-04-26 09:56:11','',''),(720,'21','226','2',1,'Sale Id shift 41',0.00,0.00,0.00,5638.89,0.00,'2022-04-26 09:56:11','',''),(721,'21','226','3',2,'Sale Id shift 41',0.00,0.00,0.00,1757.51,0.00,'2022-04-26 09:56:11','',''),(722,'21','226','3',2,'Sale Id shift 41',0.00,0.00,0.00,2995.02,0.00,'2022-04-26 09:56:11','',''),(723,'21','226','4',3,'Sale Id shift 41',0.00,0.00,0.00,320.41,0.00,'2022-04-26 09:56:11','',''),(724,'21','226','1',1,'Sale Id shift 41',0.00,0.00,0.00,6906.48,0.00,'2022-04-26 09:56:11','',''),(725,'21','226','1',1,'Sale Id shift 41',0.00,0.00,0.00,6710.78,0.00,'2022-04-26 09:56:11','',''),(726,'21','226','1',1,'Sale Id shift 41',0.00,0.00,0.00,284.02,0.00,'2022-04-26 09:56:11','',''),(727,'21','226','1',1,'Sale Id shift 41',0.00,0.00,0.00,313.78,0.00,'2022-04-26 09:56:11','',''),(728,'21','226',NULL,2,'Sale Id shift 41',3231720.40,0.00,0.00,0.00,0.00,'2022-04-26 09:56:11','',''),(729,'21','226',NULL,3,'Sale Id shift 41',176225.50,0.00,0.00,0.00,0.00,'2022-04-26 09:56:11','',''),(730,'21','226',NULL,1,'Sale Id shift 41',6058742.25,0.00,0.00,0.00,0.00,'2022-04-26 09:56:11','',''),(731,'21','226','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,1240.76,0.00,'2022-04-26 10:03:42','',''),(732,'21','226','2',0,'Inventory adjustment from tank dipping to 3350',0.00,0.00,3350.00,0.00,0.00,'2022-04-26 10:03:42','',''),(733,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-26 10:08:06','',''),(734,'21','226',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,40000.00,0.00,'2022-04-26 10:10:41','',''),(735,'21','226','1',1,'Received from bridging 60',0.00,0.00,40000.00,0.00,0.00,'2022-04-26 10:10:41','',''),(736,'21','226','2',1,'Sale Id shift 42',0.00,0.00,0.00,1173.80,0.00,'2022-04-27 09:52:02','',''),(737,'21','226','2',1,'Sale Id shift 42',0.00,0.00,0.00,1208.14,0.00,'2022-04-27 09:52:02','',''),(738,'21','226','3',2,'Sale Id shift 42',0.00,0.00,0.00,1452.89,0.00,'2022-04-27 09:52:02','',''),(739,'21','226','3',2,'Sale Id shift 42',0.00,0.00,0.00,3072.78,0.00,'2022-04-27 09:52:02','',''),(740,'21','226','4',3,'Sale Id shift 42',0.00,0.00,0.00,406.26,0.00,'2022-04-27 09:52:02','',''),(741,'21','226','1',1,'Sale Id shift 42',0.00,0.00,0.00,373.21,0.00,'2022-04-27 09:52:02','',''),(742,'21','226','1',1,'Sale Id shift 42',0.00,0.00,0.00,346.18,0.00,'2022-04-27 09:52:02','',''),(743,'21','226','1',1,'Sale Id shift 42',0.00,0.00,0.00,37.58,0.00,'2022-04-27 09:52:02','',''),(744,'21','226',NULL,1,'Sale Id shift 42',517920.15,0.00,0.00,0.00,0.00,'2022-04-27 09:52:02','',''),(745,'21','226',NULL,2,'Sale Id shift 42',3077455.60,0.00,0.00,0.00,0.00,'2022-04-27 09:52:02','',''),(746,'21','226',NULL,3,'Sale Id shift 42',223443.00,0.00,0.00,0.00,0.00,'2022-04-27 09:52:02','',''),(747,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-27 10:53:37','',''),(748,'21','226',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,45000.00,0.00,'2022-04-27 10:58:48','',''),(749,'21','226','1',1,'Received from bridging 61',0.00,0.00,45000.00,0.00,0.00,'2022-04-27 10:58:48','',''),(750,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-28 14:38:33','',''),(751,'21','226','3',2,'Sale Id shift 43',0.00,0.00,0.00,3356.79,0.00,'2022-04-28 14:42:55','',''),(752,'21','226','3',2,'Sale Id shift 43',0.00,0.00,0.00,1786.26,0.00,'2022-04-28 14:42:55','',''),(753,'21','226','4',3,'Sale Id shift 43',0.00,0.00,0.00,1416.09,0.00,'2022-04-28 14:42:55','',''),(754,'21','226','1',1,'Sale Id shift 43',0.00,0.00,0.00,7760.85,0.00,'2022-04-28 14:42:55','',''),(755,'21','226','1',1,'Sale Id shift 43',0.00,0.00,0.00,7000.10,0.00,'2022-04-28 14:42:55','',''),(756,'21','226','1',1,'Sale Id shift 43',0.00,0.00,0.00,6527.28,0.00,'2022-04-28 14:42:55','',''),(757,'21','226','1',1,'Sale Id shift 43',0.00,0.00,0.00,6800.13,0.00,'2022-04-28 14:42:55','',''),(758,'21','226','1',1,'Sale Id shift 43',0.00,0.00,0.00,5592.39,0.00,'2022-04-28 14:42:55','',''),(759,'21','226','1',1,'Sale Id shift 43',0.00,0.00,0.00,6485.16,0.00,'2022-04-28 14:42:55','',''),(760,'21','226',NULL,2,'Sale Id shift 43',3497274.00,0.00,0.00,0.00,0.00,'2022-04-28 14:42:55','',''),(761,'21','226',NULL,3,'Sale Id shift 43',778849.50,0.00,0.00,0.00,0.00,'2022-04-28 14:42:55','',''),(762,'21','226',NULL,1,'Sale Id shift 43',6627375.15,0.00,0.00,0.00,0.00,'2022-04-28 14:42:55','',''),(763,'21','226',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,30000.00,0.00,'2022-04-28 14:51:29','',''),(764,'21','226','2',1,'Received from bridging 63',0.00,0.00,30000.00,0.00,0.00,'2022-04-28 14:51:29','',''),(765,'21','226',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,15000.00,0.00,'2022-04-28 14:51:29','',''),(766,'21','226','1',1,'Received from bridging 62',0.00,0.00,15000.00,0.00,0.00,'2022-04-28 14:51:29','',''),(767,'21','226','2',1,'Sale Id shift 44',0.00,0.00,0.00,2956.23,0.00,'2022-04-28 21:50:07','',''),(768,'21','226','2',1,'Sale Id shift 44',0.00,0.00,0.00,2196.52,0.00,'2022-04-28 21:50:07','',''),(769,'21','226','2',1,'Sale Id shift 44',0.00,0.00,0.00,3257.63,0.00,'2022-04-28 21:50:07','',''),(770,'21','226','2',1,'Sale Id shift 44',0.00,0.00,0.00,3250.38,0.00,'2022-04-28 21:50:07','',''),(771,'21','226','2',1,'Sale Id shift 44',0.00,0.00,0.00,2359.81,0.00,'2022-04-28 21:50:07','',''),(772,'21','226','2',1,'Sale Id shift 44',0.00,0.00,0.00,3221.26,0.00,'2022-04-28 21:50:07','',''),(773,'21','226','2',1,'Sale Id shift 44',0.00,0.00,0.00,2846.02,0.00,'2022-04-28 21:50:07','',''),(774,'21','226','2',1,'Sale Id shift 44',0.00,0.00,0.00,3234.73,0.00,'2022-04-28 21:50:07','',''),(775,'21','226','3',2,'Sale Id shift 44',0.00,0.00,0.00,3735.63,0.00,'2022-04-28 21:50:07','',''),(776,'21','226','3',2,'Sale Id shift 44',0.00,0.00,0.00,975.92,0.00,'2022-04-28 21:50:07','',''),(777,'21','226','4',3,'Sale Id shift 44',0.00,0.00,0.00,2310.46,0.00,'2022-04-28 21:50:07','',''),(778,'21','226','1',1,'Sale Id shift 44',0.00,0.00,0.00,1648.61,0.00,'2022-04-28 21:50:07','',''),(779,'21','226','1',1,'Sale Id shift 44',0.00,0.00,0.00,1795.70,0.00,'2022-04-28 21:50:07','',''),(780,'21','226','1',1,'Sale Id shift 44',0.00,0.00,0.00,1250.60,0.00,'2022-04-28 21:50:07','',''),(781,'21','226','1',1,'Sale Id shift 44',0.00,0.00,0.00,1202.25,0.00,'2022-04-28 21:50:07','',''),(782,'21','226','1',1,'Sale Id shift 44',0.00,0.00,0.00,4679.92,0.00,'2022-04-28 21:50:07','',''),(783,'21','226','1',1,'Sale Id shift 44',0.00,0.00,0.00,4435.07,0.00,'2022-04-28 21:50:07','',''),(784,'21','226',NULL,1,'Sale Id shift 44',6325230.45,0.00,0.00,0.00,0.00,'2022-04-28 21:50:07','',''),(785,'21','226',NULL,2,'Sale Id shift 44',3203854.00,0.00,0.00,0.00,0.00,'2022-04-28 21:50:07','',''),(786,'21','226',NULL,3,'Sale Id shift 44',1270753.00,0.00,0.00,0.00,0.00,'2022-04-28 21:50:07','',''),(787,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-29 18:24:56','',''),(788,'21','226',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,30000.00,0.00,'2022-04-29 18:26:22','',''),(789,'21','226','2',1,'Received from bridging 65',0.00,0.00,30000.00,0.00,0.00,'2022-04-29 18:26:22','',''),(790,'21','226',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,15000.00,0.00,'2022-04-29 18:26:22','',''),(791,'21','226','1',1,'Received from bridging 64',0.00,0.00,15000.00,0.00,0.00,'2022-04-29 18:26:22','',''),(792,'21','226','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,4433.12,0.00,'2022-04-29 18:45:11','',''),(793,'21','226','3',0,'Inventory adjustment from tank dipping to 5550',0.00,0.00,5550.00,0.00,0.00,'2022-04-29 18:45:11','',''),(794,'21','226','1',1,'Sale Id shift 45',0.00,0.00,0.00,0.12,0.00,'2022-04-29 19:34:37','',''),(795,'21','226','2',1,'Sale Id shift 45',0.00,0.00,0.00,2561.67,0.00,'2022-04-29 19:34:37','',''),(796,'21','226','2',1,'Sale Id shift 45',0.00,0.00,0.00,2232.44,0.00,'2022-04-29 19:34:37','',''),(797,'21','226','2',1,'Sale Id shift 45',0.00,0.00,0.00,2126.86,0.00,'2022-04-29 19:34:37','',''),(798,'21','226','2',1,'Sale Id shift 45',0.00,0.00,0.00,1725.77,0.00,'2022-04-29 19:34:37','',''),(799,'21','226','2',1,'Sale Id shift 45',0.00,0.00,0.00,1868.12,0.00,'2022-04-29 19:34:37','',''),(800,'21','226','2',1,'Sale Id shift 45',0.00,0.00,0.00,2570.49,0.00,'2022-04-29 19:34:37','',''),(801,'21','226','2',1,'Sale Id shift 45',0.00,0.00,0.00,2095.41,0.00,'2022-04-29 19:34:37','',''),(802,'21','226','2',1,'Sale Id shift 45',0.00,0.00,0.00,2316.08,0.00,'2022-04-29 19:34:37','',''),(803,'21','226','3',2,'Sale Id shift 45',0.00,0.00,0.00,3311.91,0.00,'2022-04-29 19:34:37','',''),(804,'21','226','3',2,'Sale Id shift 45',0.00,0.00,0.00,1158.49,0.00,'2022-04-29 19:34:37','',''),(805,'21','226','4',3,'Sale Id shift 45',0.00,0.00,0.00,10357.28,0.00,'2022-04-29 19:34:37','',''),(806,'21','226','1',1,'Sale Id shift 45',0.00,0.00,0.00,4869.23,0.00,'2022-04-29 19:34:37','',''),(807,'21','226','4',3,'Sale Id shift 45',0.00,0.00,0.00,100.48,0.00,'2022-04-29 19:34:37','',''),(808,'21','226','1',1,'Sale Id shift 45',0.00,0.00,0.00,3065.75,0.00,'2022-04-29 19:34:37','',''),(809,'21','226','1',1,'Sale Id shift 45',0.00,0.00,0.00,3931.57,0.00,'2022-04-29 19:34:37','',''),(810,'21','226','1',1,'Sale Id shift 45',0.00,0.00,0.00,3502.15,0.00,'2022-04-29 19:34:37','',''),(811,'21','226','1',1,'Sale Id shift 45',0.00,0.00,0.00,3370.17,0.00,'2022-04-29 19:34:37','',''),(812,'21','226','1',1,'Sale Id shift 45',0.00,0.00,0.00,3138.78,0.00,'2022-04-29 19:34:37','',''),(813,'21','226',NULL,1,'Sale Id shift 45',6496810.65,0.00,0.00,0.00,0.00,'2022-04-29 19:34:37','',''),(814,'21','226',NULL,2,'Sale Id shift 45',3039872.00,0.00,0.00,0.00,0.00,'2022-04-29 19:34:37','',''),(815,'21','226',NULL,3,'Sale Id shift 45',5751768.00,0.00,0.00,0.00,0.00,'2022-04-29 19:34:37','',''),(816,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4867500.00,29500.00,0.00,0.00,'2022-04-30 09:56:44','',''),(817,'21','226',NULL,1,'Returned purchase #52 to AYM SHAFA NIGERIA. LTD',4867500.00,0.00,0.00,29500.00,0.00,'2022-04-30 09:57:09','',''),(818,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4859250.00,29450.00,0.00,0.00,'2022-04-30 16:36:02','',''),(819,'21','226',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,15000.00,0.00,'2022-04-30 16:37:58','',''),(820,'21','226','2',1,'Received from bridging 67',0.00,0.00,15000.00,0.00,0.00,'2022-04-30 16:37:58','',''),(821,'21','226',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,14450.00,0.00,'2022-04-30 16:38:14','',''),(822,'21','226','1',1,'Received from bridging 66',0.00,0.00,14450.00,0.00,0.00,'2022-04-30 16:38:14','',''),(823,'21','226','2',1,'Sale Id shift 46',0.00,0.00,0.00,3570.97,0.00,'2022-04-30 19:41:01','',''),(824,'21','226','2',1,'Sale Id shift 46',0.00,0.00,0.00,3570.00,0.00,'2022-04-30 19:41:01','',''),(825,'21','226','2',1,'Sale Id shift 46',0.00,0.00,0.00,2020.81,0.00,'2022-04-30 19:41:01','',''),(826,'21','226','2',1,'Sale Id shift 46',0.00,0.00,0.00,2063.04,0.00,'2022-04-30 19:41:01','',''),(827,'21','226','2',1,'Sale Id shift 46',0.00,0.00,0.00,1809.22,0.00,'2022-04-30 19:41:01','',''),(828,'21','226','2',1,'Sale Id shift 46',0.00,0.00,0.00,2624.53,0.00,'2022-04-30 19:41:01','',''),(829,'21','226','2',1,'Sale Id shift 46',0.00,0.00,0.00,2329.06,0.00,'2022-04-30 19:41:01','',''),(830,'21','226','2',1,'Sale Id shift 46',0.00,0.00,0.00,2521.15,0.00,'2022-04-30 19:41:01','',''),(831,'21','226','4',3,'Sale Id shift 46',0.00,0.00,0.00,359.27,0.00,'2022-04-30 19:41:01','',''),(832,'21','226','1',1,'Sale Id shift 46',0.00,0.00,0.00,5174.12,0.00,'2022-04-30 19:41:01','',''),(833,'21','226','1',1,'Sale Id shift 46',0.00,0.00,0.00,3893.67,0.00,'2022-04-30 19:41:01','',''),(834,'21','226','1',1,'Sale Id shift 46',0.00,0.00,0.00,3919.48,0.00,'2022-04-30 19:41:01','',''),(835,'21','226','1',1,'Sale Id shift 46',0.00,0.00,0.00,3461.09,0.00,'2022-04-30 19:41:01','',''),(836,'21','226','1',1,'Sale Id shift 46',0.00,0.00,0.00,3980.42,0.00,'2022-04-30 19:41:01','',''),(837,'21','226','1',1,'Sale Id shift 46',0.00,0.00,0.00,2845.99,0.00,'2022-04-30 19:41:01','',''),(838,'21','226',NULL,1,'Sale Id shift 46',7224285.75,0.00,0.00,0.00,0.00,'2022-04-30 19:41:01','',''),(839,'21','226',NULL,3,'Sale Id shift 46',197598.50,0.00,0.00,0.00,0.00,'2022-04-30 19:41:01','',''),(840,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-01 13:20:07','',''),(841,'21','226',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,14500.00,0.00,'2022-05-01 13:23:23','',''),(842,'21','226','1',1,'Received from bridging 68',0.00,0.00,14500.00,0.00,0.00,'2022-05-01 13:23:23','',''),(843,'21','226','2',1,'Sale Id shift 47',0.00,0.00,0.00,1199.26,0.00,'2022-05-02 18:01:48','',''),(844,'21','226','2',1,'Sale Id shift 47',0.00,0.00,0.00,1576.06,0.00,'2022-05-02 18:01:48','',''),(845,'21','226','2',1,'Sale Id shift 47',0.00,0.00,0.00,1549.12,0.00,'2022-05-02 18:01:48','',''),(846,'21','226','2',1,'Sale Id shift 47',0.00,0.00,0.00,1596.42,0.00,'2022-05-02 18:01:48','',''),(847,'21','226','2',1,'Sale Id shift 47',0.00,0.00,0.00,1312.86,0.00,'2022-05-02 18:01:48','',''),(848,'21','226','2',1,'Sale Id shift 47',0.00,0.00,0.00,1659.41,0.00,'2022-05-02 18:01:48','',''),(849,'21','226','2',1,'Sale Id shift 47',0.00,0.00,0.00,2079.07,0.00,'2022-05-02 18:01:48','',''),(850,'21','226','2',1,'Sale Id shift 47',0.00,0.00,0.00,2490.69,0.00,'2022-05-02 18:01:48','',''),(851,'21','226','3',2,'Sale Id shift 47',0.00,0.00,0.00,188.69,0.00,'2022-05-02 18:01:48','',''),(852,'21','226','4',3,'Sale Id shift 47',0.00,0.00,0.00,695.78,0.00,'2022-05-02 18:01:48','',''),(853,'21','226','1',1,'Sale Id shift 47',0.00,0.00,0.00,5972.72,0.00,'2022-05-02 18:01:48','',''),(854,'21','226','1',1,'Sale Id shift 47',0.00,0.00,0.00,5275.11,0.00,'2022-05-02 18:01:48','',''),(855,'21','226','1',1,'Sale Id shift 47',0.00,0.00,0.00,3467.26,0.00,'2022-05-02 18:01:48','',''),(856,'21','226','1',1,'Sale Id shift 47',0.00,0.00,0.00,2994.14,0.00,'2022-05-02 18:01:48','',''),(857,'21','226','1',1,'Sale Id shift 47',0.00,0.00,0.00,4303.60,0.00,'2022-05-02 18:01:48','',''),(858,'21','226','1',1,'Sale Id shift 47',0.00,0.00,0.00,4842.90,0.00,'2022-05-02 18:01:48','',''),(859,'21','226',NULL,1,'Sale Id shift 47',6652572.30,0.00,0.00,0.00,0.00,'2022-05-02 18:01:48','',''),(860,'21','226',NULL,2,'Sale Id shift 47',128309.20,0.00,0.00,0.00,0.00,'2022-05-02 18:01:48','',''),(861,'21','226',NULL,3,'Sale Id shift 47',382679.00,0.00,0.00,0.00,0.00,'2022-05-02 18:01:48','',''),(862,'21','226',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,30500.00,0.00,'2022-05-02 18:04:03','',''),(863,'21','226','2',1,'Received from bridging 69',0.00,0.00,30500.00,0.00,0.00,'2022-05-02 18:04:03','',''),(864,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-04 06:50:04','',''),(865,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-04 06:51:05','',''),(866,'21','226',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,45000.00,0.00,'2022-05-04 06:53:40','',''),(867,'21','226','1',1,'Received from bridging 70',0.00,0.00,45000.00,0.00,0.00,'2022-05-04 06:53:40','',''),(868,'21','226','2',1,'Sale Id shift 48',0.00,0.00,0.00,1833.40,0.00,'2022-05-04 11:21:10','',''),(869,'21','226','2',1,'Sale Id shift 48',0.00,0.00,0.00,1511.20,0.00,'2022-05-04 11:21:10','',''),(870,'21','226','2',1,'Sale Id shift 48',0.00,0.00,0.00,1794.88,0.00,'2022-05-04 11:21:10','',''),(871,'21','226','2',1,'Sale Id shift 48',0.00,0.00,0.00,1835.34,0.00,'2022-05-04 11:21:10','',''),(872,'21','226','2',1,'Sale Id shift 48',0.00,0.00,0.00,1455.57,0.00,'2022-05-04 11:21:10','',''),(873,'21','226','2',1,'Sale Id shift 48',0.00,0.00,0.00,1486.14,0.00,'2022-05-04 11:21:10','',''),(874,'21','226','2',1,'Sale Id shift 48',0.00,0.00,0.00,1788.00,0.00,'2022-05-04 11:21:10','',''),(875,'21','226','2',1,'Sale Id shift 48',0.00,0.00,0.00,1737.78,0.00,'2022-05-04 11:21:10','',''),(876,'21','226','4',3,'Sale Id shift 48',0.00,0.00,0.00,349.30,0.00,'2022-05-04 11:21:10','',''),(877,'21','226','1',1,'Sale Id shift 48',0.00,0.00,0.00,3899.28,0.00,'2022-05-04 11:21:10','',''),(878,'21','226','1',1,'Sale Id shift 48',0.00,0.00,0.00,2867.53,0.00,'2022-05-04 11:21:10','',''),(879,'21','226','1',1,'Sale Id shift 48',0.00,0.00,0.00,3244.25,0.00,'2022-05-04 11:21:10','',''),(880,'21','226','1',1,'Sale Id shift 48',0.00,0.00,0.00,3160.27,0.00,'2022-05-04 11:21:10','',''),(881,'21','226','1',1,'Sale Id shift 48',0.00,0.00,0.00,1774.71,0.00,'2022-05-04 11:21:10','',''),(882,'21','226','1',1,'Sale Id shift 48',0.00,0.00,0.00,1906.47,0.00,'2022-05-04 11:21:10','',''),(883,'21','226',NULL,3,'Sale Id shift 48',192115.00,0.00,0.00,0.00,0.00,'2022-05-04 11:21:10','',''),(884,'21','226',NULL,1,'Sale Id shift 48',4998645.30,0.00,0.00,0.00,0.00,'2022-05-04 11:21:10','',''),(885,'21','226','2',1,'Sale Id shift 49',0.00,0.00,0.00,2349.96,0.00,'2022-05-04 11:47:53','',''),(886,'21','226','2',1,'Sale Id shift 49',0.00,0.00,0.00,1566.28,0.00,'2022-05-04 11:47:53','',''),(887,'21','226','2',1,'Sale Id shift 49',0.00,0.00,0.00,3006.80,0.00,'2022-05-04 11:47:53','',''),(888,'21','226','2',1,'Sale Id shift 49',0.00,0.00,0.00,2620.44,0.00,'2022-05-04 11:47:53','',''),(889,'21','226','2',1,'Sale Id shift 49',0.00,0.00,0.00,2210.74,0.00,'2022-05-04 11:47:53','',''),(890,'21','226','2',1,'Sale Id shift 49',0.00,0.00,0.00,2315.73,0.00,'2022-05-04 11:47:53','',''),(891,'21','226','2',1,'Sale Id shift 49',0.00,0.00,0.00,1747.35,0.00,'2022-05-04 11:47:53','',''),(892,'21','226','2',1,'Sale Id shift 49',0.00,0.00,0.00,1429.42,0.00,'2022-05-04 11:47:53','',''),(893,'21','226','3',2,'Sale Id shift 49',0.00,0.00,0.00,144.98,0.00,'2022-05-04 11:47:53','',''),(894,'21','226','4',3,'Sale Id shift 49',0.00,0.00,0.00,260.31,0.00,'2022-05-04 11:47:53','',''),(895,'21','226','1',1,'Sale Id shift 49',0.00,0.00,0.00,41.19,0.00,'2022-05-04 11:47:53','',''),(896,'21','226','1',1,'Sale Id shift 49',0.00,0.00,0.00,56.91,0.00,'2022-05-04 11:47:53','',''),(897,'21','226',NULL,2,'Sale Id shift 49',98586.40,0.00,0.00,0.00,0.00,'2022-05-04 11:47:53','',''),(898,'21','226',NULL,3,'Sale Id shift 49',143170.50,0.00,0.00,0.00,0.00,'2022-05-04 11:47:53','',''),(899,'21','226',NULL,1,'Sale Id shift 49',2861895.30,0.00,0.00,0.00,0.00,'2022-05-04 11:47:53','',''),(900,'21','226',NULL,1,'Returned purchase #56 to AYM SHAFA NIGERIA. LTD',7425000.00,0.00,0.00,45000.00,0.00,'2022-05-05 15:12:45','',''),(901,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-05 15:14:05','',''),(902,'21','226',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,30000.00,0.00,'2022-05-05 15:15:06','',''),(903,'21','226','2',1,'Received from bridging 74',0.00,0.00,30000.00,0.00,0.00,'2022-05-05 15:15:06','',''),(904,'21','226','4',3,'Sale Id shift 50',0.00,0.00,0.00,4054.31,0.00,'2022-05-05 17:22:13','',''),(905,'21','226','4',3,'Sale Id shift 50',0.00,0.00,0.00,45.82,0.00,'2022-05-05 17:22:13','',''),(906,'21','226',NULL,3,'Sale Id shift 50',2255071.50,0.00,0.00,0.00,0.00,'2022-05-05 17:22:13','',''),(907,'21','226','2',1,'Sale Id shift 51',0.00,0.00,0.00,2457.72,0.00,'2022-05-05 19:05:22','',''),(908,'21','226','2',1,'Sale Id shift 51',0.00,0.00,0.00,2115.46,0.00,'2022-05-05 19:05:22','',''),(909,'21','226','2',1,'Sale Id shift 51',0.00,0.00,0.00,2279.58,0.00,'2022-05-05 19:05:22','',''),(910,'21','226','2',1,'Sale Id shift 51',0.00,0.00,0.00,2298.54,0.00,'2022-05-05 19:05:22','',''),(911,'21','226','2',1,'Sale Id shift 51',0.00,0.00,0.00,2371.57,0.00,'2022-05-05 19:05:22','',''),(912,'21','226','2',1,'Sale Id shift 51',0.00,0.00,0.00,1816.33,0.00,'2022-05-05 19:05:22','',''),(913,'21','226','2',1,'Sale Id shift 51',0.00,0.00,0.00,2077.23,0.00,'2022-05-05 19:05:22','',''),(914,'21','226','2',1,'Sale Id shift 51',0.00,0.00,0.00,2385.92,0.00,'2022-05-05 19:05:22','',''),(915,'21','226','3',2,'Sale Id shift 51',0.00,0.00,0.00,105.02,0.00,'2022-05-05 19:05:22','',''),(916,'21','226','4',3,'Sale Id shift 51',0.00,0.00,0.00,579.51,0.00,'2022-05-05 19:05:22','',''),(917,'21','226','1',1,'Sale Id shift 51',0.00,0.00,0.00,4724.67,0.00,'2022-05-05 19:05:22','',''),(918,'21','226','1',1,'Sale Id shift 51',0.00,0.00,0.00,3501.11,0.00,'2022-05-05 19:05:22','',''),(919,'21','226','1',1,'Sale Id shift 51',0.00,0.00,0.00,3725.77,0.00,'2022-05-05 19:05:22','',''),(920,'21','226','1',1,'Sale Id shift 51',0.00,0.00,0.00,3222.50,0.00,'2022-05-05 19:05:22','',''),(921,'21','226','1',1,'Sale Id shift 51',0.00,0.00,0.00,3304.52,0.00,'2022-05-05 19:05:22','',''),(922,'21','226','1',1,'Sale Id shift 51',0.00,0.00,0.00,2956.13,0.00,'2022-05-05 19:05:22','',''),(923,'21','226',NULL,1,'Sale Id shift 51',6474113.25,0.00,0.00,0.00,0.00,'2022-05-05 19:05:22','',''),(924,'21','226',NULL,2,'Sale Id shift 51',71413.60,0.00,0.00,0.00,0.00,'2022-05-05 19:05:22','',''),(925,'21','226',NULL,3,'Sale Id shift 51',318730.50,0.00,0.00,0.00,0.00,'2022-05-05 19:05:22','',''),(926,'21','226',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,15000.00,0.00,'2022-05-07 11:57:09','',''),(927,'21','226','2',1,'Received from bridging 75',0.00,0.00,15000.00,0.00,0.00,'2022-05-07 11:57:09','',''),(928,'21','226','2',1,'Sale Id shift 52',0.00,0.00,0.00,1420.64,0.00,'2022-05-07 13:45:23','',''),(929,'21','226','2',1,'Sale Id shift 52',0.00,0.00,0.00,2004.41,0.00,'2022-05-07 13:45:23','',''),(930,'21','226','2',1,'Sale Id shift 52',0.00,0.00,0.00,2760.86,0.00,'2022-05-07 13:45:23','',''),(931,'21','226','2',1,'Sale Id shift 52',0.00,0.00,0.00,2859.66,0.00,'2022-05-07 13:45:23','',''),(932,'21','226','2',1,'Sale Id shift 52',0.00,0.00,0.00,2250.20,0.00,'2022-05-07 13:45:23','',''),(933,'21','226','2',1,'Sale Id shift 52',0.00,0.00,0.00,2675.81,0.00,'2022-05-07 13:45:23','',''),(934,'21','226','2',1,'Sale Id shift 52',0.00,0.00,0.00,2172.85,0.00,'2022-05-07 13:45:23','',''),(935,'21','226','2',1,'Sale Id shift 52',0.00,0.00,0.00,3000.76,0.00,'2022-05-07 13:45:23','',''),(936,'21','226','4',3,'Sale Id shift 52',0.00,0.00,0.00,4438.50,0.00,'2022-05-07 13:45:23','',''),(937,'21','226','1',1,'Sale Id shift 52',0.00,0.00,0.00,4780.54,0.00,'2022-05-07 13:45:23','',''),(938,'21','226','4',3,'Sale Id shift 52',0.00,0.00,0.00,67.54,0.00,'2022-05-07 13:45:23','',''),(939,'21','226','1',1,'Sale Id shift 52',0.00,0.00,0.00,3677.48,0.00,'2022-05-07 13:45:23','',''),(940,'21','226','1',1,'Sale Id shift 52',0.00,0.00,0.00,3458.77,0.00,'2022-05-07 13:45:23','',''),(941,'21','226','1',1,'Sale Id shift 52',0.00,0.00,0.00,3170.23,0.00,'2022-05-07 13:45:23','',''),(942,'21','226','1',1,'Sale Id shift 52',0.00,0.00,0.00,2868.61,0.00,'2022-05-07 13:45:23','',''),(943,'21','226','1',1,'Sale Id shift 52',0.00,0.00,0.00,2827.95,0.00,'2022-05-07 13:45:23','',''),(944,'21','226',NULL,1,'Sale Id shift 52',6588247.05,0.00,0.00,0.00,0.00,'2022-05-07 13:45:23','',''),(945,'21','226',NULL,3,'Sale Id shift 52',2478322.00,0.00,0.00,0.00,0.00,'2022-05-07 13:45:23','',''),(946,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-07 15:16:40','',''),(947,'21','226',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,15000.00,0.00,'2022-05-07 15:18:01','',''),(948,'21','226','2',1,'Received from bridging 77',0.00,0.00,15000.00,0.00,0.00,'2022-05-07 15:18:01','',''),(949,'21','226',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,30000.00,0.00,'2022-05-07 15:18:01','',''),(950,'21','226','1',1,'Received from bridging 76',0.00,0.00,30000.00,0.00,0.00,'2022-05-07 15:18:01','',''),(951,'21','226','2',1,'Sale Id shift 53',0.00,0.00,0.00,2837.84,0.00,'2022-05-08 20:07:20','',''),(952,'21','226','2',1,'Sale Id shift 53',0.00,0.00,0.00,2044.01,0.00,'2022-05-08 20:07:20','',''),(953,'21','226','2',1,'Sale Id shift 53',0.00,0.00,0.00,2710.30,0.00,'2022-05-08 20:07:20','',''),(954,'21','226','2',1,'Sale Id shift 53',0.00,0.00,0.00,2504.22,0.00,'2022-05-08 20:07:20','',''),(955,'21','226','2',1,'Sale Id shift 53',0.00,0.00,0.00,2470.45,0.00,'2022-05-08 20:07:20','',''),(956,'21','226','2',1,'Sale Id shift 53',0.00,0.00,0.00,3098.43,0.00,'2022-05-08 20:07:20','',''),(957,'21','226','2',1,'Sale Id shift 53',0.00,0.00,0.00,2161.81,0.00,'2022-05-08 20:07:20','',''),(958,'21','226','2',1,'Sale Id shift 53',0.00,0.00,0.00,3260.21,0.00,'2022-05-08 20:07:20','',''),(959,'21','226','4',3,'Sale Id shift 53',0.00,0.00,0.00,2777.29,0.00,'2022-05-08 20:07:20','',''),(960,'21','226','1',1,'Sale Id shift 53',0.00,0.00,0.00,6388.80,0.00,'2022-05-08 20:07:20','',''),(961,'21','226','4',3,'Sale Id shift 53',0.00,0.00,0.00,18.55,0.00,'2022-05-08 20:07:20','',''),(962,'21','226','1',1,'Sale Id shift 53',0.00,0.00,0.00,3982.23,0.00,'2022-05-08 20:07:20','',''),(963,'21','226','1',1,'Sale Id shift 53',0.00,0.00,0.00,4565.39,0.00,'2022-05-08 20:07:20','',''),(964,'21','226','1',1,'Sale Id shift 53',0.00,0.00,0.00,3657.33,0.00,'2022-05-08 20:07:20','',''),(965,'21','226','1',1,'Sale Id shift 53',0.00,0.00,0.00,3386.45,0.00,'2022-05-08 20:07:20','',''),(966,'21','226','1',1,'Sale Id shift 53',0.00,0.00,0.00,3175.19,0.00,'2022-05-08 20:07:20','',''),(967,'21','226',NULL,3,'Sale Id shift 53',1537712.00,0.00,0.00,0.00,0.00,'2022-05-08 20:07:20','',''),(968,'21','226',NULL,1,'Sale Id shift 53',7630038.90,0.00,0.00,0.00,0.00,'2022-05-08 20:07:20','',''),(969,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-09 16:19:26','',''),(970,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-09 16:20:46','',''),(971,'21','226',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,30000.00,0.00,'2022-05-09 16:23:08','',''),(972,'21','226','2',1,'Received from bridging 78',0.00,0.00,30000.00,0.00,0.00,'2022-05-09 16:23:08','',''),(973,'21','226',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,45000.00,0.00,'2022-05-09 16:23:16','',''),(974,'21','226','1',1,'Received from bridging 79',0.00,0.00,45000.00,0.00,0.00,'2022-05-09 16:23:16','',''),(975,'21','226','1',1,'Sale Id shift 54',0.00,0.00,0.00,0.37,0.00,'2022-05-09 16:49:03','',''),(976,'21','226','2',1,'Sale Id shift 54',0.00,0.00,0.00,2038.02,0.00,'2022-05-09 16:49:03','',''),(977,'21','226','2',1,'Sale Id shift 54',0.00,0.00,0.00,2269.73,0.00,'2022-05-09 16:49:03','',''),(978,'21','226','2',1,'Sale Id shift 54',0.00,0.00,0.00,3211.85,0.00,'2022-05-09 16:49:03','',''),(979,'21','226','2',1,'Sale Id shift 54',0.00,0.00,0.00,3283.22,0.00,'2022-05-09 16:49:03','',''),(980,'21','226','2',1,'Sale Id shift 54',0.00,0.00,0.00,2310.84,0.00,'2022-05-09 16:49:03','',''),(981,'21','226','2',1,'Sale Id shift 54',0.00,0.00,0.00,2543.71,0.00,'2022-05-09 16:49:03','',''),(982,'21','226','2',1,'Sale Id shift 54',0.00,0.00,0.00,3517.81,0.00,'2022-05-09 16:49:03','',''),(983,'21','226','2',1,'Sale Id shift 54',0.00,0.00,0.00,4673.10,0.00,'2022-05-09 16:49:03','',''),(984,'21','226','4',3,'Sale Id shift 54',0.00,0.00,0.00,1538.37,0.00,'2022-05-09 16:49:03','',''),(985,'21','226','1',1,'Sale Id shift 54',0.00,0.00,0.00,6887.23,0.00,'2022-05-09 16:49:03','',''),(986,'21','226','1',1,'Sale Id shift 54',0.00,0.00,0.00,5146.32,0.00,'2022-05-09 16:49:03','',''),(987,'21','226','1',1,'Sale Id shift 54',0.00,0.00,0.00,3589.51,0.00,'2022-05-09 16:49:03','',''),(988,'21','226','1',1,'Sale Id shift 54',0.00,0.00,0.00,3880.31,0.00,'2022-05-09 16:49:03','',''),(989,'21','226','1',1,'Sale Id shift 54',0.00,0.00,0.00,5336.82,0.00,'2022-05-09 16:49:03','',''),(990,'21','226','1',1,'Sale Id shift 54',0.00,0.00,0.00,5494.10,0.00,'2022-05-09 16:49:03','',''),(991,'21','226',NULL,1,'Sale Id shift 54',8940185.10,0.00,0.00,0.00,0.00,'2022-05-09 16:49:03','',''),(992,'21','226',NULL,3,'Sale Id shift 54',846103.50,0.00,0.00,0.00,0.00,'2022-05-09 16:49:03','',''),(993,'21','226',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,15000.00,0.00,'2022-05-09 16:52:38','',''),(994,'21','226','2',1,'Received from bridging 80',0.00,0.00,15000.00,0.00,0.00,'2022-05-09 16:52:38','',''),(995,'21','226','4',3,'Sale Id shift 55',0.00,0.00,0.00,168.79,0.00,'2022-05-09 17:09:14','',''),(996,'21','226',NULL,3,'Sale Id shift 55',109713.50,0.00,0.00,0.00,0.00,'2022-05-09 17:09:14','',''),(997,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,27200000.00,40000.00,0.00,0.00,'2022-05-10 17:24:08','',''),(998,'21','226',NULL,2,'Reception corrector for bridging 81',0.00,0.00,0.00,40000.00,0.00,'2022-05-10 17:25:06','',''),(999,'21','226','3',2,'Received from bridging 81',0.00,0.00,40000.00,0.00,0.00,'2022-05-10 17:25:06','',''),(1000,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-10 17:25:16','',''),(1001,'21','226',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,15000.00,0.00,'2022-05-10 17:26:27','',''),(1002,'21','226','1',1,'Received from bridging 82',0.00,0.00,15000.00,0.00,0.00,'2022-05-10 17:26:27','',''),(1003,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-10 17:26:40','',''),(1004,'21','226',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,15000.00,0.00,'2022-05-10 17:27:41','',''),(1005,'21','226','2',1,'Received from bridging 83',0.00,0.00,15000.00,0.00,0.00,'2022-05-10 17:27:41','',''),(1006,'21','226','2',1,'Sale Id shift 56',0.00,0.00,0.00,2860.64,0.00,'2022-05-11 13:39:42','',''),(1007,'21','226','2',1,'Sale Id shift 56',0.00,0.00,0.00,3241.21,0.00,'2022-05-11 13:39:42','',''),(1008,'21','226','4',3,'Sale Id shift 56',0.00,0.00,0.00,84.71,0.00,'2022-05-11 13:39:42','',''),(1009,'21','226','1',1,'Sale Id shift 56',0.00,0.00,0.00,5958.82,0.00,'2022-05-11 13:39:42','',''),(1010,'21','226','1',1,'Sale Id shift 56',0.00,0.00,0.00,5456.08,0.00,'2022-05-11 13:39:42','',''),(1011,'21','226','1',1,'Sale Id shift 56',0.00,0.00,0.00,5917.03,0.00,'2022-05-11 13:39:42','',''),(1012,'21','226','1',1,'Sale Id shift 56',0.00,0.00,0.00,5371.10,0.00,'2022-05-11 13:39:42','',''),(1013,'21','226',NULL,1,'Sale Id shift 56',4752805.20,0.00,0.00,0.00,0.00,'2022-05-11 13:39:42','',''),(1014,'21','226',NULL,3,'Sale Id shift 56',55061.50,0.00,0.00,0.00,0.00,'2022-05-11 13:39:42','',''),(1015,'21','226','2',1,'Sale Id shift 57',0.00,0.00,0.00,4131.49,0.00,'2022-05-12 11:09:57','',''),(1016,'21','226','2',1,'Sale Id shift 57',0.00,0.00,0.00,3381.76,0.00,'2022-05-12 11:09:57','',''),(1017,'21','226','2',1,'Sale Id shift 57',0.00,0.00,0.00,3298.88,0.00,'2022-05-12 11:09:57','',''),(1018,'21','226','2',1,'Sale Id shift 57',0.00,0.00,0.00,3884.75,0.00,'2022-05-12 11:09:57','',''),(1019,'21','226','3',2,'Sale Id shift 57',0.00,0.00,0.00,2443.10,0.00,'2022-05-12 11:09:57','',''),(1020,'21','226','3',2,'Sale Id shift 57',0.00,0.00,0.00,2264.93,0.00,'2022-05-12 11:09:57','',''),(1021,'21','226','4',3,'Sale Id shift 57',0.00,0.00,0.00,339.36,0.00,'2022-05-12 11:09:57','',''),(1022,'21','226',NULL,1,'Sale Id shift 57',2424985.20,0.00,0.00,0.00,0.00,'2022-05-12 11:09:57','',''),(1023,'21','226',NULL,2,'Sale Id shift 57',3201460.40,0.00,0.00,0.00,0.00,'2022-05-12 11:09:57','',''),(1024,'21','226',NULL,3,'Sale Id shift 57',220584.00,0.00,0.00,0.00,0.00,'2022-05-12 11:09:57','',''),(1025,'21','226','2',1,'Sale Id shift 58',0.00,0.00,0.00,352.98,0.00,'2022-05-12 14:12:25','',''),(1026,'21','226','2',1,'Sale Id shift 58',0.00,0.00,0.00,5558.70,0.00,'2022-05-12 14:12:25','',''),(1027,'21','226','2',1,'Sale Id shift 58',0.00,0.00,0.00,6038.44,0.00,'2022-05-12 14:12:25','',''),(1028,'21','226','3',2,'Sale Id shift 58',0.00,0.00,0.00,957.98,0.00,'2022-05-12 14:12:25','',''),(1029,'21','226','3',2,'Sale Id shift 58',0.00,0.00,0.00,1972.62,0.00,'2022-05-12 14:12:25','',''),(1030,'21','226','4',3,'Sale Id shift 58',0.00,0.00,0.00,1136.67,0.00,'2022-05-12 14:12:25','',''),(1031,'21','226','1',1,'Sale Id shift 58',0.00,0.00,0.00,6745.88,0.00,'2022-05-12 14:12:25','',''),(1032,'21','226','4',3,'Sale Id shift 58',0.00,0.00,0.00,2.31,0.00,'2022-05-12 14:12:25','',''),(1033,'21','226','1',1,'Sale Id shift 58',0.00,0.00,0.00,7296.66,0.00,'2022-05-12 14:12:25','',''),(1034,'21','226',NULL,1,'Sale Id shift 58',4288788.90,0.00,0.00,0.00,0.00,'2022-05-12 14:12:25','',''),(1035,'21','226',NULL,2,'Sale Id shift 58',1992808.00,0.00,0.00,0.00,0.00,'2022-05-12 14:12:25','',''),(1036,'21','226',NULL,3,'Sale Id shift 58',740337.00,0.00,0.00,0.00,0.00,'2022-05-12 14:12:25','',''),(1037,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-14 09:18:05','',''),(1038,'21','226',NULL,1,'Reception corrector for bridging 85',0.00,0.00,0.00,15000.00,0.00,'2022-05-14 09:20:06','',''),(1039,'21','226','2',1,'Received from bridging 85',0.00,0.00,15000.00,0.00,0.00,'2022-05-14 09:20:06','',''),(1040,'21','226',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,15000.00,0.00,'2022-05-14 09:20:06','',''),(1041,'21','226','1',1,'Received from bridging 84',0.00,0.00,15000.00,0.00,0.00,'2022-05-14 09:20:06','',''),(1042,'21','226','2',1,'Sale Id shift 59',0.00,0.00,0.00,2018.58,0.00,'2022-05-14 09:46:45','',''),(1043,'21','226','2',1,'Sale Id shift 59',0.00,0.00,0.00,1895.94,0.00,'2022-05-14 09:46:45','',''),(1044,'21','226','3',2,'Sale Id shift 59',0.00,0.00,0.00,2167.15,0.00,'2022-05-14 09:46:45','',''),(1045,'21','226','3',2,'Sale Id shift 59',0.00,0.00,0.00,4482.45,0.00,'2022-05-14 09:46:45','',''),(1046,'21','226','4',3,'Sale Id shift 59',0.00,0.00,0.00,300.55,0.00,'2022-05-14 09:46:45','',''),(1047,'21','226','1',1,'Sale Id shift 59',0.00,0.00,0.00,778.46,0.00,'2022-05-14 09:46:45','',''),(1048,'21','226','1',1,'Sale Id shift 59',0.00,0.00,0.00,270.08,0.00,'2022-05-14 09:46:45','',''),(1049,'21','226',NULL,1,'Sale Id shift 59',818904.90,0.00,0.00,0.00,0.00,'2022-05-14 09:46:45','',''),(1050,'21','226',NULL,2,'Sale Id shift 59',4521728.00,0.00,0.00,0.00,0.00,'2022-05-14 09:46:45','',''),(1051,'21','226',NULL,3,'Sale Id shift 59',195357.50,0.00,0.00,0.00,0.00,'2022-05-14 09:46:45','',''),(1052,'21','226','2',1,'Sale Id shift 60',0.00,0.00,0.00,637.00,0.00,'2022-05-14 15:09:04','',''),(1053,'21','226','2',1,'Sale Id shift 60',0.00,0.00,0.00,766.51,0.00,'2022-05-14 15:09:04','',''),(1054,'21','226','2',1,'Sale Id shift 60',0.00,0.00,0.00,392.29,0.00,'2022-05-14 15:09:04','',''),(1055,'21','226','2',1,'Sale Id shift 60',0.00,0.00,0.00,342.42,0.00,'2022-05-14 15:09:04','',''),(1056,'21','226','3',2,'Sale Id shift 60',0.00,0.00,0.00,1150.88,0.00,'2022-05-14 15:09:04','',''),(1057,'21','226','3',2,'Sale Id shift 60',0.00,0.00,0.00,4339.87,0.00,'2022-05-14 15:09:04','',''),(1058,'21','226','4',3,'Sale Id shift 60',0.00,0.00,0.00,440.91,0.00,'2022-05-14 15:09:04','',''),(1059,'21','226',NULL,1,'Sale Id shift 60',352806.30,0.00,0.00,0.00,0.00,'2022-05-14 15:09:04','',''),(1060,'21','226',NULL,2,'Sale Id shift 60',3733710.00,0.00,0.00,0.00,0.00,'2022-05-14 15:09:04','',''),(1061,'21','226',NULL,3,'Sale Id shift 60',286591.50,0.00,0.00,0.00,0.00,'2022-05-14 15:09:04','',''),(1062,'21','226',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,15000.00,0.00,'2022-05-14 15:12:48','',''),(1063,'21','226','1',1,'Received from bridging 86',0.00,0.00,15000.00,0.00,0.00,'2022-05-14 15:12:48','',''),(1064,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-14 15:37:09','',''),(1065,'21','226',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,45000.00,0.00,'2022-05-14 15:39:24','',''),(1066,'21','226','1',1,'Received from bridging 87',0.00,0.00,45000.00,0.00,0.00,'2022-05-14 15:39:24','',''),(1067,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:1',2475000.00,0.00,0.00,15000.00,0.00,'2022-05-14 15:54:38','',''),(1068,'21','226','2',1,'Sale Id shift 61',0.00,0.00,0.00,3178.91,0.00,'2022-05-15 16:08:15','',''),(1069,'21','226','2',1,'Sale Id shift 61',0.00,0.00,0.00,3355.80,0.00,'2022-05-15 16:08:15','',''),(1070,'21','226','2',1,'Sale Id shift 61',0.00,0.00,0.00,1002.86,0.00,'2022-05-15 16:08:15','',''),(1071,'21','226','2',1,'Sale Id shift 61',0.00,0.00,0.00,1070.32,0.00,'2022-05-15 16:08:15','',''),(1072,'21','226','3',2,'Sale Id shift 61',0.00,0.00,0.00,1700.22,0.00,'2022-05-15 16:08:15','',''),(1073,'21','226','3',2,'Sale Id shift 61',0.00,0.00,0.00,3151.33,0.00,'2022-05-15 16:08:15','',''),(1074,'21','226','4',3,'Sale Id shift 61',0.00,0.00,0.00,339.19,0.00,'2022-05-15 16:08:15','',''),(1075,'21','226','1',1,'Sale Id shift 61',0.00,0.00,0.00,7255.63,0.00,'2022-05-15 16:08:15','',''),(1076,'21','226','1',1,'Sale Id shift 61',0.00,0.00,0.00,6678.85,0.00,'2022-05-15 16:08:15','',''),(1077,'21','226','1',1,'Sale Id shift 61',0.00,0.00,0.00,546.14,0.00,'2022-05-15 16:08:15','',''),(1078,'21','226','1',1,'Sale Id shift 61',0.00,0.00,0.00,656.38,0.00,'2022-05-15 16:08:15','',''),(1079,'21','226',NULL,1,'Sale Id shift 61',3917906.85,0.00,0.00,0.00,0.00,'2022-05-15 16:08:15','',''),(1080,'21','226',NULL,2,'Sale Id shift 61',3299054.00,0.00,0.00,0.00,0.00,'2022-05-15 16:08:15','',''),(1081,'21','226',NULL,3,'Sale Id shift 61',220473.50,0.00,0.00,0.00,0.00,'2022-05-15 16:08:15','',''),(1082,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:2',2475000.00,0.00,0.00,15000.00,0.00,'2022-05-15 16:15:58','',''),(1083,'21','226','2',1,'Sale Id shift 63',0.00,0.00,0.00,118.50,0.00,'2022-05-15 16:29:03','',''),(1084,'21','226','2',1,'Sale Id shift 63',0.00,0.00,0.00,72.69,0.00,'2022-05-15 16:29:03','',''),(1085,'21','226','2',1,'Sale Id shift 63',0.00,0.00,0.00,3047.77,0.00,'2022-05-15 16:29:03','',''),(1086,'21','226','2',1,'Sale Id shift 63',0.00,0.00,0.00,3138.61,0.00,'2022-05-15 16:29:03','',''),(1087,'21','226','3',2,'Sale Id shift 63',0.00,0.00,0.00,537.06,0.00,'2022-05-15 16:29:03','',''),(1088,'21','226','4',3,'Sale Id shift 63',0.00,0.00,0.00,285.56,0.00,'2022-05-15 16:29:03','',''),(1089,'21','226','1',1,'Sale Id shift 63',0.00,0.00,0.00,4762.49,0.00,'2022-05-15 16:29:03','',''),(1090,'21','226','1',1,'Sale Id shift 63',0.00,0.00,0.00,5145.24,0.00,'2022-05-15 16:29:03','',''),(1091,'21','226','1',1,'Sale Id shift 63',0.00,0.00,0.00,7924.59,0.00,'2022-05-15 16:29:03','',''),(1092,'21','226','1',1,'Sale Id shift 63',0.00,0.00,0.00,8072.79,0.00,'2022-05-15 16:29:03','',''),(1093,'21','226',NULL,2,'Sale Id shift 63',365200.80,0.00,0.00,0.00,0.00,'2022-05-15 16:29:03','',''),(1094,'21','226',NULL,3,'Sale Id shift 63',185614.00,0.00,0.00,0.00,0.00,'2022-05-15 16:29:03','',''),(1095,'21','226',NULL,1,'Sale Id shift 63',5326642.20,0.00,0.00,0.00,0.00,'2022-05-15 16:29:03','',''),(1096,'21','226','3',2,'Sale Id shift 65',0.00,0.00,0.00,448.94,0.00,'2022-05-15 16:36:54','',''),(1097,'21','226','3',2,'Sale Id shift 65',0.00,0.00,0.00,1966.18,0.00,'2022-05-15 16:36:54','',''),(1098,'21','226',NULL,2,'Sale Id shift 65',1738886.40,0.00,0.00,0.00,0.00,'2022-05-15 16:36:54','',''),(1099,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 12:46:08','',''),(1100,'21','226',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,28000.00,0.00,'2022-05-16 12:52:21','',''),(1101,'21','226','2',1,'Received from bridging 89',0.00,0.00,28000.00,0.00,0.00,'2022-05-16 12:52:21','',''),(1102,'21','226',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,17000.00,0.00,'2022-05-16 12:52:21','',''),(1103,'21','226','1',1,'Received from bridging 88',0.00,0.00,17000.00,0.00,0.00,'2022-05-16 12:52:21','',''),(1104,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10800000.00,15000.00,0.00,0.00,'2022-05-16 12:52:46','',''),(1105,'21','226',NULL,2,'Reception corrector for bridging 90',0.00,0.00,0.00,15000.00,0.00,'2022-05-16 12:54:06','',''),(1106,'21','226','3',2,'Received from bridging 90',0.00,0.00,15000.00,0.00,0.00,'2022-05-16 12:54:06','',''),(1107,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-18 08:41:42','',''),(1108,'21','226',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,30000.00,0.00,'2022-05-18 08:44:32','',''),(1109,'21','226','1',1,'Received from bridging 91',0.00,0.00,30000.00,0.00,0.00,'2022-05-18 08:44:32','',''),(1110,'21','226','2',1,'Sale Id shift 66',0.00,0.00,0.00,3623.56,0.00,'2022-05-18 09:09:44','',''),(1111,'21','226','2',1,'Sale Id shift 66',0.00,0.00,0.00,3711.06,0.00,'2022-05-18 09:09:44','',''),(1112,'21','226','2',1,'Sale Id shift 66',0.00,0.00,0.00,2770.10,0.00,'2022-05-18 09:09:44','',''),(1113,'21','226','2',1,'Sale Id shift 66',0.00,0.00,0.00,2987.05,0.00,'2022-05-18 09:09:44','',''),(1114,'21','226','3',2,'Sale Id shift 66',0.00,0.00,0.00,3165.77,0.00,'2022-05-18 09:09:44','',''),(1115,'21','226','3',2,'Sale Id shift 66',0.00,0.00,0.00,679.84,0.00,'2022-05-18 09:09:44','',''),(1116,'21','226','4',3,'Sale Id shift 66',0.00,0.00,0.00,260.45,0.00,'2022-05-18 09:09:44','',''),(1117,'21','226','1',1,'Sale Id shift 66',0.00,0.00,0.00,5832.22,0.00,'2022-05-18 09:09:44','',''),(1118,'21','226','1',1,'Sale Id shift 66',0.00,0.00,0.00,5549.39,0.00,'2022-05-18 09:09:44','',''),(1119,'21','226','1',1,'Sale Id shift 66',0.00,0.00,0.00,5186.97,0.00,'2022-05-18 09:09:44','',''),(1120,'21','226','1',1,'Sale Id shift 66',0.00,0.00,0.00,5055.35,0.00,'2022-05-18 09:09:44','',''),(1121,'21','226',NULL,2,'Sale Id shift 66',2768839.20,0.00,0.00,0.00,0.00,'2022-05-18 09:09:44','',''),(1122,'21','226',NULL,3,'Sale Id shift 66',169292.50,0.00,0.00,0.00,0.00,'2022-05-18 09:09:44','',''),(1123,'21','226',NULL,1,'Sale Id shift 66',5728090.50,0.00,0.00,0.00,0.00,'2022-05-18 09:09:44','',''),(1124,'21','226',NULL,1,'Reception corrector for bridging 92',0.00,0.00,0.00,15000.00,0.00,'2022-05-18 09:11:41','',''),(1125,'21','226','2',1,'Received from bridging 92',0.00,0.00,15000.00,0.00,0.00,'2022-05-18 09:11:41','',''),(1126,'21','226','2',1,'Sale Id shift 67',0.00,0.00,0.00,3467.12,0.00,'2022-05-18 09:22:56','',''),(1127,'21','226','2',1,'Sale Id shift 67',0.00,0.00,0.00,3593.32,0.00,'2022-05-18 09:22:56','',''),(1128,'21','226','2',1,'Sale Id shift 67',0.00,0.00,0.00,3650.99,0.00,'2022-05-18 09:22:56','',''),(1129,'21','226','2',1,'Sale Id shift 67',0.00,0.00,0.00,4241.20,0.00,'2022-05-18 09:22:56','',''),(1130,'21','226','3',2,'Sale Id shift 67',0.00,0.00,0.00,729.66,0.00,'2022-05-18 09:22:56','',''),(1131,'21','226','3',2,'Sale Id shift 67',0.00,0.00,0.00,3968.99,0.00,'2022-05-18 09:22:56','',''),(1132,'21','226','4',3,'Sale Id shift 67',0.00,0.00,0.00,449.93,0.00,'2022-05-18 09:22:56','',''),(1133,'21','226',NULL,2,'Sale Id shift 67',3383028.00,0.00,0.00,0.00,0.00,'2022-05-18 09:22:56','',''),(1134,'21','226',NULL,3,'Sale Id shift 67',292454.50,0.00,0.00,0.00,0.00,'2022-05-18 09:22:56','',''),(1135,'21','226',NULL,1,'Sale Id shift 67',2467183.95,0.00,0.00,0.00,0.00,'2022-05-18 09:22:56','',''),(1136,'21','226','2',1,'Sale Id shift 68',0.00,0.00,0.00,833.24,0.00,'2022-05-18 10:30:42','',''),(1137,'21','226','2',1,'Sale Id shift 68',0.00,0.00,0.00,746.95,0.00,'2022-05-18 10:30:42','',''),(1138,'21','226','2',1,'Sale Id shift 68',0.00,0.00,0.00,811.81,0.00,'2022-05-18 10:30:42','',''),(1139,'21','226','2',1,'Sale Id shift 68',0.00,0.00,0.00,888.09,0.00,'2022-05-18 10:30:42','',''),(1140,'21','226','2',1,'Sale Id shift 68',0.00,0.00,0.00,2830.57,0.00,'2022-05-18 10:30:42','',''),(1141,'21','226','2',1,'Sale Id shift 68',0.00,0.00,0.00,3006.96,0.00,'2022-05-18 10:30:42','',''),(1142,'21','226','2',1,'Sale Id shift 68',0.00,0.00,0.00,2556.46,0.00,'2022-05-18 10:30:42','',''),(1143,'21','226','2',1,'Sale Id shift 68',0.00,0.00,0.00,3432.01,0.00,'2022-05-18 10:30:42','',''),(1144,'21','226','3',2,'Sale Id shift 68',0.00,0.00,0.00,2517.19,0.00,'2022-05-18 10:30:42','',''),(1145,'21','226','3',2,'Sale Id shift 68',0.00,0.00,0.00,3368.27,0.00,'2022-05-18 10:30:42','',''),(1146,'21','226','4',3,'Sale Id shift 68',0.00,0.00,0.00,408.60,0.00,'2022-05-18 10:30:42','',''),(1147,'21','226','1',1,'Sale Id shift 68',0.00,0.00,0.00,5447.39,0.00,'2022-05-18 10:30:42','',''),(1148,'21','226','1',1,'Sale Id shift 68',0.00,0.00,0.00,4713.66,0.00,'2022-05-18 10:30:42','',''),(1149,'21','226','1',1,'Sale Id shift 68',0.00,0.00,0.00,1839.69,0.00,'2022-05-18 10:30:42','',''),(1150,'21','226','1',1,'Sale Id shift 68',0.00,0.00,0.00,1855.63,0.00,'2022-05-18 10:30:42','',''),(1151,'21','226','1',1,'Sale Id shift 68',0.00,0.00,0.00,4282.82,0.00,'2022-05-18 10:30:42','',''),(1152,'21','226','1',1,'Sale Id shift 68',0.00,0.00,0.00,4632.96,0.00,'2022-05-18 10:30:42','',''),(1153,'21','226',NULL,1,'Sale Id shift 68',6249909.60,0.00,0.00,0.00,0.00,'2022-05-18 10:30:42','',''),(1154,'21','226',NULL,2,'Sale Id shift 68',4237531.20,0.00,0.00,0.00,0.00,'2022-05-18 10:30:42','',''),(1155,'21','226',NULL,3,'Sale Id shift 68',265590.00,0.00,0.00,0.00,0.00,'2022-05-18 10:30:42','',''),(1156,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 10:58:46','',''),(1157,'21','226',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,30000.00,0.00,'2022-05-19 11:00:05','',''),(1158,'21','226','2',1,'Received from bridging 93',0.00,0.00,30000.00,0.00,0.00,'2022-05-19 11:00:05','',''),(1159,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 11:00:51','',''),(1160,'21','226',NULL,1,'Reception corrector for bridging 94',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 11:01:43','',''),(1161,'21','226','1',1,'Received from bridging 94',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 11:01:43','',''),(1162,'21','226',NULL,1,'Reception corrector for bridging 95',0.00,0.00,0.00,10000.00,0.00,'2022-05-19 12:36:11','',''),(1163,'21','226','2',1,'Received from bridging 95',0.00,0.00,10000.00,0.00,0.00,'2022-05-19 12:36:11','',''),(1164,'21','226','2',1,'Sale Id shift 69',0.00,0.00,0.00,5657.92,0.00,'2022-05-19 18:12:00','',''),(1165,'21','226','2',1,'Sale Id shift 69',0.00,0.00,0.00,5137.17,0.00,'2022-05-19 18:12:00','',''),(1166,'21','226','2',1,'Sale Id shift 69',0.00,0.00,0.00,4628.60,0.00,'2022-05-19 18:12:00','',''),(1167,'21','226','2',1,'Sale Id shift 69',0.00,0.00,0.00,4390.45,0.00,'2022-05-19 18:12:00','',''),(1168,'21','226','2',1,'Sale Id shift 69',0.00,0.00,0.00,4180.84,0.00,'2022-05-19 18:12:00','',''),(1169,'21','226','2',1,'Sale Id shift 69',0.00,0.00,0.00,4966.19,0.00,'2022-05-19 18:12:00','',''),(1170,'21','226','2',1,'Sale Id shift 69',0.00,0.00,0.00,3795.08,0.00,'2022-05-19 18:12:00','',''),(1171,'21','226','2',1,'Sale Id shift 69',0.00,0.00,0.00,4069.38,0.00,'2022-05-19 18:12:00','',''),(1172,'21','226','3',2,'Sale Id shift 69',0.00,0.00,0.00,4349.05,0.00,'2022-05-19 18:12:00','',''),(1173,'21','226','3',2,'Sale Id shift 69',0.00,0.00,0.00,309.80,0.00,'2022-05-19 18:12:00','',''),(1174,'21','226','4',3,'Sale Id shift 69',0.00,0.00,0.00,338.30,0.00,'2022-05-19 18:12:00','',''),(1175,'21','226','1',1,'Sale Id shift 69',0.00,0.00,0.00,10.00,0.00,'2022-05-19 18:12:00','',''),(1176,'21','226','1',1,'Sale Id shift 69',0.00,0.00,0.00,3881.56,0.00,'2022-05-19 18:12:00','',''),(1177,'21','226','1',1,'Sale Id shift 69',0.00,0.00,0.00,3446.22,0.00,'2022-05-19 18:12:00','',''),(1178,'21','226',NULL,1,'Sale Id shift 69',7286962.65,0.00,0.00,0.00,0.00,'2022-05-19 18:12:00','',''),(1179,'21','226',NULL,2,'Sale Id shift 69',3354372.00,0.00,0.00,0.00,0.00,'2022-05-19 18:12:01','',''),(1180,'21','226',NULL,3,'Sale Id shift 69',219895.00,0.00,0.00,0.00,0.00,'2022-05-19 18:12:01','',''),(1181,'21','226',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,5000.00,0.00,'2022-05-20 18:01:19','',''),(1182,'21','226','2',1,'Received from bridging 96',0.00,0.00,5000.00,0.00,0.00,'2022-05-20 18:01:19','',''),(1183,'21','226','2',1,'Sale Id shift 70',0.00,0.00,0.00,2231.48,0.00,'2022-05-21 11:46:02','',''),(1184,'21','226','2',1,'Sale Id shift 70',0.00,0.00,0.00,2479.74,0.00,'2022-05-21 11:46:02','',''),(1185,'21','226','2',1,'Sale Id shift 70',0.00,0.00,0.00,1216.10,0.00,'2022-05-21 11:46:02','',''),(1186,'21','226','2',1,'Sale Id shift 70',0.00,0.00,0.00,2023.36,0.00,'2022-05-21 11:46:02','',''),(1187,'21','226','3',2,'Sale Id shift 70',0.00,0.00,0.00,3593.55,0.00,'2022-05-21 11:46:02','',''),(1188,'21','226','3',2,'Sale Id shift 70',0.00,0.00,0.00,2503.38,0.00,'2022-05-21 11:46:02','',''),(1189,'21','226','4',3,'Sale Id shift 70',0.00,0.00,0.00,306.05,0.00,'2022-05-21 11:46:02','',''),(1190,'21','226','1',1,'Sale Id shift 70',0.00,0.00,0.00,5773.38,0.00,'2022-05-21 11:46:02','',''),(1191,'21','226','1',1,'Sale Id shift 70',0.00,0.00,0.00,4957.93,0.00,'2022-05-21 11:46:02','',''),(1192,'21','226','1',1,'Sale Id shift 70',0.00,0.00,0.00,3481.84,0.00,'2022-05-21 11:46:02','',''),(1193,'21','226','1',1,'Sale Id shift 70',0.00,0.00,0.00,3715.39,0.00,'2022-05-21 11:46:02','',''),(1194,'21','226','1',1,'Sale Id shift 70',0.00,0.00,0.00,4906.36,0.00,'2022-05-21 11:46:02','',''),(1195,'21','226','1',1,'Sale Id shift 70',0.00,0.00,0.00,5195.24,0.00,'2022-05-21 11:46:02','',''),(1196,'21','226',NULL,1,'Sale Id shift 70',5936835.30,0.00,0.00,0.00,0.00,'2022-05-21 11:46:02','',''),(1197,'21','226',NULL,2,'Sale Id shift 70',4389789.60,0.00,0.00,0.00,0.00,'2022-05-21 11:46:02','',''),(1198,'21','226',NULL,3,'Sale Id shift 70',198932.50,0.00,0.00,0.00,0.00,'2022-05-21 11:46:02','',''),(1199,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-21 11:51:30','',''),(1200,'21','226',NULL,1,'Reception corrector for bridging 97',0.00,0.00,0.00,45000.00,0.00,'2022-05-21 11:52:32','',''),(1201,'21','226','1',1,'Received from bridging 97',0.00,0.00,45000.00,0.00,0.00,'2022-05-21 11:52:32','',''),(1202,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,40000.00,0.00,0.00,'2022-05-21 11:53:25','',''),(1203,'21','226',NULL,2,'Reception corrector for bridging 98',0.00,0.00,0.00,40000.00,0.00,'2022-05-21 11:55:50','',''),(1204,'21','226','3',2,'Received from bridging 98',0.00,0.00,40000.00,0.00,0.00,'2022-05-21 11:55:50','',''),(1205,'21','226','1',1,'Sale Id shift 71',0.00,0.00,0.00,0.10,0.00,'2022-05-21 14:34:49','',''),(1206,'21','226','3',2,'Sale Id shift 71',0.00,0.00,0.00,1497.92,0.00,'2022-05-21 14:34:49','',''),(1207,'21','226','3',2,'Sale Id shift 71',0.00,0.00,0.00,418.97,0.00,'2022-05-21 14:34:49','',''),(1208,'21','226','4',3,'Sale Id shift 71',0.00,0.00,0.00,289.32,0.00,'2022-05-21 14:34:49','',''),(1209,'21','226','1',1,'Sale Id shift 71',0.00,0.00,0.00,5044.31,0.00,'2022-05-21 14:34:49','',''),(1210,'21','226','1',1,'Sale Id shift 71',0.00,0.00,0.00,4906.29,0.00,'2022-05-21 14:34:49','',''),(1211,'21','226','1',1,'Sale Id shift 71',0.00,0.00,0.00,3567.81,0.00,'2022-05-21 14:34:49','',''),(1212,'21','226','1',1,'Sale Id shift 71',0.00,0.00,0.00,3743.33,0.00,'2022-05-21 14:34:49','',''),(1213,'21','226',NULL,2,'Sale Id shift 71',1380160.80,0.00,0.00,0.00,0.00,'2022-05-21 14:34:49','',''),(1214,'21','226',NULL,3,'Sale Id shift 71',188058.00,0.00,0.00,0.00,0.00,'2022-05-21 14:34:49','',''),(1215,'21','226',NULL,1,'Sale Id shift 71',2848203.60,0.00,0.00,0.00,0.00,'2022-05-21 14:34:49','',''),(1216,'21','226','3',2,'Sale Id shift 72',0.00,0.00,0.00,2740.34,0.00,'2022-05-23 14:35:08','',''),(1217,'21','226','3',2,'Sale Id shift 72',0.00,0.00,0.00,0.14,0.00,'2022-05-23 14:35:08','',''),(1218,'21','226','3',2,'Sale Id shift 72',0.00,0.00,0.00,1885.90,0.00,'2022-05-23 14:35:08','',''),(1219,'21','226','4',3,'Sale Id shift 72',0.00,0.00,0.00,270.28,0.00,'2022-05-23 14:35:08','',''),(1220,'21','226','1',1,'Sale Id shift 72',0.00,0.00,0.00,7079.31,0.00,'2022-05-23 14:35:08','',''),(1221,'21','226','1',1,'Sale Id shift 72',0.00,0.00,0.00,6589.04,0.00,'2022-05-23 14:35:08','',''),(1222,'21','226','1',1,'Sale Id shift 72',0.00,0.00,0.00,4530.69,0.00,'2022-05-23 14:35:08','',''),(1223,'21','226','1',1,'Sale Id shift 72',0.00,0.00,0.00,4591.73,0.00,'2022-05-23 14:35:08','',''),(1224,'21','226','1',1,'Sale Id shift 72',0.00,0.00,0.00,5672.85,0.00,'2022-05-23 14:35:08','',''),(1225,'21','226','1',1,'Sale Id shift 72',0.00,0.00,0.00,5755.73,0.00,'2022-05-23 14:35:08','',''),(1226,'21','226',NULL,2,'Sale Id shift 72',3330993.60,0.00,0.00,0.00,0.00,'2022-05-23 14:35:08','',''),(1227,'21','226',NULL,3,'Sale Id shift 72',175682.00,0.00,0.00,0.00,0.00,'2022-05-23 14:35:08','',''),(1228,'21','226',NULL,1,'Sale Id shift 72',5646192.75,0.00,0.00,0.00,0.00,'2022-05-23 14:35:08','',''),(1229,'21','226','3',2,'Sale Id shift 73',0.00,0.00,0.00,748.22,0.00,'2022-05-23 15:02:21','',''),(1230,'21','226','3',2,'Sale Id shift 73',0.00,0.00,0.00,453.68,0.00,'2022-05-23 15:02:21','',''),(1231,'21','226','4',3,'Sale Id shift 73',0.00,0.00,0.00,285.32,0.00,'2022-05-23 15:02:21','',''),(1232,'21','226','1',1,'Sale Id shift 73',0.00,0.00,0.00,26.77,0.00,'2022-05-23 15:02:21','',''),(1233,'21','226','1',1,'Sale Id shift 73',0.00,0.00,0.00,59.17,0.00,'2022-05-23 15:02:21','',''),(1234,'21','226','1',1,'Sale Id shift 73',0.00,0.00,0.00,42.94,0.00,'2022-05-23 15:02:21','',''),(1235,'21','226','1',1,'Sale Id shift 73',0.00,0.00,0.00,43.62,0.00,'2022-05-23 15:02:21','',''),(1236,'21','226','1',1,'Sale Id shift 73',0.00,0.00,0.00,4134.19,0.00,'2022-05-23 15:02:21','',''),(1237,'21','226','1',1,'Sale Id shift 73',0.00,0.00,0.00,4028.41,0.00,'2022-05-23 15:02:21','',''),(1238,'21','226',NULL,2,'Sale Id shift 73',913444.00,0.00,0.00,0.00,0.00,'2022-05-23 15:02:21','',''),(1239,'21','226',NULL,3,'Sale Id shift 73',185458.00,0.00,0.00,0.00,0.00,'2022-05-23 15:02:21','',''),(1240,'21','226',NULL,1,'Sale Id shift 73',1375291.50,0.00,0.00,0.00,0.00,'2022-05-23 15:02:21','',''),(1241,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 08:27:55','',''),(1242,'21','226',NULL,1,'Reception corrector for bridging 100',0.00,0.00,0.00,30000.00,0.00,'2022-05-25 08:29:32','',''),(1243,'21','226','2',1,'Received from bridging 100',0.00,0.00,30000.00,0.00,0.00,'2022-05-25 08:29:32','',''),(1244,'21','226',NULL,1,'Reception corrector for bridging 99',0.00,0.00,0.00,15000.00,0.00,'2022-05-25 08:29:32','',''),(1245,'21','226','1',1,'Received from bridging 99',0.00,0.00,15000.00,0.00,0.00,'2022-05-25 08:29:32','',''),(1246,'21','226','3',2,'Sale Id shift 74',0.00,0.00,0.00,337.45,0.00,'2022-05-25 08:35:48','',''),(1247,'21','226','3',2,'Sale Id shift 74',0.00,0.00,0.00,1552.62,0.00,'2022-05-25 08:35:48','',''),(1248,'21','226',NULL,2,'Sale Id shift 74',1436453.20,0.00,0.00,0.00,0.00,'2022-05-25 08:35:48','',''),(1249,'21','226','2',1,'Sale Id shift 75',0.00,0.00,0.00,401.30,0.00,'2022-05-25 09:25:47','',''),(1250,'21','226','2',1,'Sale Id shift 75',0.00,0.00,0.00,460.68,0.00,'2022-05-25 09:25:47','',''),(1251,'21','226','2',1,'Sale Id shift 75',0.00,0.00,0.00,2239.32,0.00,'2022-05-25 09:25:47','',''),(1252,'21','226','2',1,'Sale Id shift 75',0.00,0.00,0.00,2160.72,0.00,'2022-05-25 09:25:47','',''),(1253,'21','226','2',1,'Sale Id shift 75',0.00,0.00,0.00,2546.24,0.00,'2022-05-25 09:25:47','',''),(1254,'21','226','2',1,'Sale Id shift 75',0.00,0.00,0.00,2415.27,0.00,'2022-05-25 09:25:47','',''),(1255,'21','226','3',2,'Sale Id shift 75',0.00,0.00,0.00,2212.34,0.00,'2022-05-25 09:25:47','',''),(1256,'21','226','3',2,'Sale Id shift 75',0.00,0.00,0.00,1684.76,0.00,'2022-05-25 09:25:47','',''),(1257,'21','226','4',3,'Sale Id shift 75',0.00,0.00,0.00,374.48,0.00,'2022-05-25 09:25:47','',''),(1258,'21','226','1',1,'Sale Id shift 75',0.00,0.00,0.00,2323.69,0.00,'2022-05-25 09:25:47','',''),(1259,'21','226','1',1,'Sale Id shift 75',0.00,0.00,0.00,2764.62,0.00,'2022-05-25 09:25:47','',''),(1260,'21','226','1',1,'Sale Id shift 75',0.00,0.00,0.00,109.25,0.00,'2022-05-25 09:25:47','',''),(1261,'21','226','1',1,'Sale Id shift 75',0.00,0.00,0.00,42.42,0.00,'2022-05-25 09:25:47','',''),(1262,'21','226',NULL,1,'Sale Id shift 75',2551479.15,0.00,0.00,0.00,0.00,'2022-05-25 09:25:47','',''),(1263,'21','226',NULL,2,'Sale Id shift 75',2961796.00,0.00,0.00,0.00,0.00,'2022-05-25 09:25:47','',''),(1264,'21','226',NULL,3,'Sale Id shift 75',243412.00,0.00,0.00,0.00,0.00,'2022-05-25 09:25:47','',''),(1265,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5280000.00,32000.00,0.00,0.00,'2022-05-26 09:31:35','',''),(1266,'21','226',NULL,1,'Reception corrector for bridging 101',0.00,0.00,0.00,32000.00,0.00,'2022-05-26 09:32:36','',''),(1267,'21','226','1',1,'Received from bridging 101',0.00,0.00,32000.00,0.00,0.00,'2022-05-26 09:32:36','',''),(1268,'21','226','2',1,'Sale Id shift 76',0.00,0.00,0.00,4292.57,0.00,'2022-05-26 09:45:36','',''),(1269,'21','226','2',1,'Sale Id shift 76',0.00,0.00,0.00,5224.39,0.00,'2022-05-26 09:45:36','',''),(1270,'21','226','2',1,'Sale Id shift 76',0.00,0.00,0.00,4410.13,0.00,'2022-05-26 09:45:36','',''),(1271,'21','226','2',1,'Sale Id shift 76',0.00,0.00,0.00,5243.90,0.00,'2022-05-26 09:45:36','',''),(1272,'21','226','3',2,'Sale Id shift 76',0.00,0.00,0.00,1783.08,0.00,'2022-05-26 09:45:36','',''),(1273,'21','226','3',2,'Sale Id shift 76',0.00,0.00,0.00,1386.34,0.00,'2022-05-26 09:45:36','',''),(1274,'21','226','4',3,'Sale Id shift 76',0.00,0.00,0.00,2001.82,0.00,'2022-05-26 09:45:36','',''),(1275,'21','226','1',1,'Sale Id shift 76',0.00,0.00,0.00,3348.94,0.00,'2022-05-26 09:45:36','',''),(1276,'21','226','1',1,'Sale Id shift 76',0.00,0.00,0.00,2925.47,0.00,'2022-05-26 09:45:36','',''),(1277,'21','226','1',1,'Sale Id shift 76',0.00,0.00,0.00,2848.56,0.00,'2022-05-26 09:45:36','',''),(1278,'21','226','1',1,'Sale Id shift 76',0.00,0.00,0.00,3062.31,0.00,'2022-05-26 09:45:36','',''),(1279,'21','226',NULL,2,'Sale Id shift 76',2408759.20,0.00,0.00,0.00,0.00,'2022-05-26 09:45:36','',''),(1280,'21','226',NULL,3,'Sale Id shift 76',1301183.00,0.00,0.00,0.00,0.00,'2022-05-26 09:45:36','',''),(1281,'21','226',NULL,1,'Sale Id shift 76',5173784.55,0.00,0.00,0.00,0.00,'2022-05-26 09:45:36','',''),(1282,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11400000.00,15000.00,0.00,0.00,'2022-05-26 09:46:38','',''),(1283,'21','226',NULL,2,'Reception corrector for bridging 102',0.00,0.00,0.00,15000.00,0.00,'2022-05-26 09:47:22','',''),(1284,'21','226','3',2,'Received from bridging 102',0.00,0.00,15000.00,0.00,0.00,'2022-05-26 09:47:22','',''),(1285,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-26 09:48:07','',''),(1286,'21','226',NULL,1,'Reception corrector for bridging 103',0.00,0.00,0.00,40000.00,0.00,'2022-05-26 09:49:02','',''),(1287,'21','226','2',1,'Received from bridging 103',0.00,0.00,40000.00,0.00,0.00,'2022-05-26 09:49:02','',''),(1288,'21','226','3',2,'Sale Id shift 77',0.00,0.00,0.00,2355.40,0.00,'2022-05-26 10:07:23','',''),(1289,'21','226','3',2,'Sale Id shift 77',0.00,0.00,0.00,1352.04,0.00,'2022-05-26 10:07:23','',''),(1290,'21','226',NULL,2,'Sale Id shift 77',2817654.40,0.00,0.00,0.00,0.00,'2022-05-26 10:07:23','',''),(1291,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-27 17:51:20','',''),(1292,'21','226',NULL,1,'Reception corrector for bridging 104',0.00,0.00,0.00,30000.00,0.00,'2022-05-27 17:52:33','',''),(1293,'21','226','1',1,'Received from bridging 104',0.00,0.00,30000.00,0.00,0.00,'2022-05-27 17:52:33','',''),(1294,'21','226','1',1,'Sale Id shift 78',0.00,0.00,0.00,0.34,0.00,'2022-05-28 13:05:30','',''),(1295,'21','226','2',1,'Sale Id shift 78',0.00,0.00,0.00,115.92,0.00,'2022-05-28 13:05:30','',''),(1296,'21','226','2',1,'Sale Id shift 78',0.00,0.00,0.00,136.54,0.00,'2022-05-28 13:05:30','',''),(1297,'21','226','2',1,'Sale Id shift 78',0.00,0.00,0.00,4318.32,0.00,'2022-05-28 13:05:30','',''),(1298,'21','226','2',1,'Sale Id shift 78',0.00,0.00,0.00,4076.80,0.00,'2022-05-28 13:05:30','',''),(1299,'21','226','2',1,'Sale Id shift 78',0.00,0.00,0.00,132.71,0.00,'2022-05-28 13:05:30','',''),(1300,'21','226','2',1,'Sale Id shift 78',0.00,0.00,0.00,175.52,0.00,'2022-05-28 13:05:30','',''),(1301,'21','226','2',1,'Sale Id shift 78',0.00,0.00,0.00,4311.16,0.00,'2022-05-28 13:05:30','',''),(1302,'21','226','2',1,'Sale Id shift 78',0.00,0.00,0.00,4621.55,0.00,'2022-05-28 13:05:30','',''),(1303,'21','226','3',2,'Sale Id shift 78',0.00,0.00,0.00,3732.52,0.00,'2022-05-28 13:05:30','',''),(1304,'21','226','3',2,'Sale Id shift 78',0.00,0.00,0.00,2500.25,0.00,'2022-05-28 13:05:30','',''),(1305,'21','226','1',1,'Sale Id shift 78',0.00,0.00,0.00,7322.98,0.00,'2022-05-28 13:05:30','',''),(1306,'21','226','1',1,'Sale Id shift 78',0.00,0.00,0.00,7215.98,0.00,'2022-05-28 13:05:30','',''),(1307,'21','226','1',1,'Sale Id shift 78',0.00,0.00,0.00,938.79,0.00,'2022-05-28 13:05:30','',''),(1308,'21','226','1',1,'Sale Id shift 78',0.00,0.00,0.00,1015.90,0.00,'2022-05-28 13:05:30','',''),(1309,'21','226','1',1,'Sale Id shift 78',0.00,0.00,0.00,7421.97,0.00,'2022-05-28 13:05:30','',''),(1310,'21','226','1',1,'Sale Id shift 78',0.00,0.00,0.00,8154.77,0.00,'2022-05-28 13:05:30','',''),(1311,'21','226',NULL,1,'Sale Id shift 78',8243276.25,0.00,0.00,0.00,0.00,'2022-05-28 13:05:30','',''),(1312,'21','226',NULL,2,'Sale Id shift 78',4736905.20,0.00,0.00,0.00,0.00,'2022-05-28 13:05:30','',''),(1313,'21','226',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,5000.00,0.00,'2022-05-28 13:15:15','',''),(1314,'21','226','1',1,'Received from bridging 105',0.00,0.00,5000.00,0.00,0.00,'2022-05-28 13:15:15','',''),(1315,'21','226','1',1,'Returned bridging 104',0.00,0.00,0.00,30000.00,0.00,'2022-05-28 13:15:37','',''),(1316,'21','226',NULL,1,'Reception Return corrector for bridging 104',0.00,0.00,30000.00,0.00,0.00,'2022-05-28 13:15:37','',''),(1317,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-28 13:17:58','',''),(1318,'21','226',NULL,1,'Returned purchase #78 to AYM SHAFA NIGERIA. LTD',6600000.00,0.00,0.00,40000.00,0.00,'2022-05-28 13:18:52','',''),(1319,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-28 13:20:30','',''),(1320,'21','226',NULL,1,'Returned purchase #77 to AYM SHAFA NIGERIA. LTD',7425000.00,0.00,0.00,45000.00,0.00,'2022-05-28 13:21:46','',''),(1321,'21','226',NULL,1,'Reception corrector for bridging 109',0.00,0.00,0.00,20000.00,0.00,'2022-05-28 13:23:45','',''),(1322,'21','226','2',1,'Received from bridging 109',0.00,0.00,20000.00,0.00,0.00,'2022-05-28 13:23:45','',''),(1323,'21','226',NULL,1,'Reception corrector for bridging 108',0.00,0.00,0.00,20000.00,0.00,'2022-05-28 13:23:45','',''),(1324,'21','226','1',1,'Received from bridging 108',0.00,0.00,20000.00,0.00,0.00,'2022-05-28 13:23:45','',''),(1325,'21','226','2',1,'Sale Id shift 79',0.00,0.00,0.00,1090.96,0.00,'2022-05-28 13:47:03','',''),(1326,'21','226','2',1,'Sale Id shift 79',0.00,0.00,0.00,977.77,0.00,'2022-05-28 13:47:03','',''),(1327,'21','226','2',1,'Sale Id shift 79',0.00,0.00,0.00,5716.63,0.00,'2022-05-28 13:47:03','',''),(1328,'21','226','2',1,'Sale Id shift 79',0.00,0.00,0.00,5175.31,0.00,'2022-05-28 13:47:03','',''),(1329,'21','226','2',1,'Sale Id shift 79',0.00,0.00,0.00,1205.05,0.00,'2022-05-28 13:47:03','',''),(1330,'21','226','2',1,'Sale Id shift 79',0.00,0.00,0.00,1136.24,0.00,'2022-05-28 13:47:03','',''),(1331,'21','226','2',1,'Sale Id shift 79',0.00,0.00,0.00,6050.92,0.00,'2022-05-28 13:47:03','',''),(1332,'21','226','2',1,'Sale Id shift 79',0.00,0.00,0.00,6348.40,0.00,'2022-05-28 13:47:03','',''),(1333,'21','226','3',2,'Sale Id shift 79',0.00,0.00,0.00,1680.84,0.00,'2022-05-28 13:47:03','',''),(1334,'21','226','3',2,'Sale Id shift 79',0.00,0.00,0.00,1542.58,0.00,'2022-05-28 13:47:03','',''),(1335,'21','226',NULL,1,'Sale Id shift 79',4570711.20,0.00,0.00,0.00,0.00,'2022-05-28 13:47:03','',''),(1336,'21','226',NULL,2,'Sale Id shift 79',2449799.20,0.00,0.00,0.00,0.00,'2022-05-28 13:47:03','',''),(1337,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-31 07:45:52','',''),(1338,'21','226',NULL,1,'Reception corrector for bridging 111',0.00,0.00,0.00,15000.00,0.00,'2022-05-31 07:47:25','',''),(1339,'21','226','2',1,'Received from bridging 111',0.00,0.00,15000.00,0.00,0.00,'2022-05-31 07:47:25','',''),(1340,'21','226',NULL,1,'Reception corrector for bridging 110',0.00,0.00,0.00,30000.00,0.00,'2022-05-31 07:47:25','',''),(1341,'21','226','1',1,'Received from bridging 110',0.00,0.00,30000.00,0.00,0.00,'2022-05-31 07:47:25','',''),(1342,'21','226','2',1,'Sale Id shift 80',0.00,0.00,0.00,12.83,0.00,'2022-05-31 18:04:20','',''),(1343,'21','226','2',1,'Sale Id shift 80',0.00,0.00,0.00,3525.99,0.00,'2022-05-31 18:04:20','',''),(1344,'21','226','2',1,'Sale Id shift 80',0.00,0.00,0.00,3042.47,0.00,'2022-05-31 18:04:20','',''),(1345,'21','226','3',2,'Sale Id shift 80',0.00,0.00,0.00,1553.75,0.00,'2022-05-31 18:04:20','',''),(1346,'21','226','3',2,'Sale Id shift 80',0.00,0.00,0.00,1578.88,0.00,'2022-05-31 18:04:20','',''),(1347,'21','226','1',1,'Sale Id shift 80',0.00,0.00,0.00,6638.96,0.00,'2022-05-31 18:04:20','',''),(1348,'21','226','1',1,'Sale Id shift 80',0.00,0.00,0.00,5811.66,0.00,'2022-05-31 18:04:20','',''),(1349,'21','226','1',1,'Sale Id shift 80',0.00,0.00,0.00,6259.47,0.00,'2022-05-31 18:04:20','',''),(1350,'21','226','1',1,'Sale Id shift 80',0.00,0.00,0.00,6605.69,0.00,'2022-05-31 18:04:20','',''),(1351,'21','226',NULL,1,'Sale Id shift 80',5263016.55,0.00,0.00,0.00,0.00,'2022-05-31 18:04:20','',''),(1352,'21','226',NULL,2,'Sale Id shift 80',2380798.80,0.00,0.00,0.00,0.00,'2022-05-31 18:04:20','',''),(1353,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5032500.00,30500.00,0.00,0.00,'2022-06-01 18:00:10','',''),(1354,'21','226',NULL,1,'Reception corrector for bridging 112',0.00,0.00,0.00,15500.00,0.00,'2022-06-01 18:01:08','',''),(1355,'21','226','2',1,'Received from bridging 112',0.00,0.00,15500.00,0.00,0.00,'2022-06-01 18:01:08','',''),(1356,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-01 18:02:07','',''),(1357,'21','226','2',1,'Sale Id shift 81',0.00,0.00,0.00,111.96,0.00,'2022-06-01 18:02:25','',''),(1358,'21','226','2',1,'Sale Id shift 81',0.00,0.00,0.00,1163.91,0.00,'2022-06-01 18:02:25','',''),(1359,'21','226','2',1,'Sale Id shift 81',0.00,0.00,0.00,1352.35,0.00,'2022-06-01 18:02:25','',''),(1360,'21','226','2',1,'Sale Id shift 81',0.00,0.00,0.00,3004.14,0.00,'2022-06-01 18:02:25','',''),(1361,'21','226','2',1,'Sale Id shift 81',0.00,0.00,0.00,3261.16,0.00,'2022-06-01 18:02:25','',''),(1362,'21','226','3',2,'Sale Id shift 81',0.00,0.00,0.00,1749.28,0.00,'2022-06-01 18:02:25','',''),(1363,'21','226','3',2,'Sale Id shift 81',0.00,0.00,0.00,244.15,0.00,'2022-06-01 18:02:25','',''),(1364,'21','226',NULL,1,'Sale Id shift 81',1467430.80,0.00,0.00,0.00,0.00,'2022-06-01 18:02:25','',''),(1365,'21','226',NULL,2,'Sale Id shift 81',1515006.80,0.00,0.00,0.00,0.00,'2022-06-01 18:02:25','',''),(1366,'21','226',NULL,1,'Reception corrector for bridging 113',0.00,0.00,0.00,30000.00,0.00,'2022-06-01 18:02:53','',''),(1367,'21','226','1',1,'Received from bridging 113',0.00,0.00,30000.00,0.00,0.00,'2022-06-01 18:02:53','',''),(1368,'21','226','2',1,'Sale Id shift 82',0.00,0.00,0.00,3753.77,0.00,'2022-06-01 18:20:05','',''),(1369,'21','226','2',1,'Sale Id shift 82',0.00,0.00,0.00,3944.70,0.00,'2022-06-01 18:20:05','',''),(1370,'21','226','2',1,'Sale Id shift 82',0.00,0.00,0.00,3911.03,0.00,'2022-06-01 18:20:05','',''),(1371,'21','226','2',1,'Sale Id shift 82',0.00,0.00,0.00,4237.32,0.00,'2022-06-01 18:20:05','',''),(1372,'21','226','3',2,'Sale Id shift 82',0.00,0.00,0.00,2102.61,0.00,'2022-06-01 18:20:05','',''),(1373,'21','226','3',2,'Sale Id shift 82',0.00,0.00,0.00,1489.77,0.00,'2022-06-01 18:20:05','',''),(1374,'21','226','1',1,'Sale Id shift 82',0.00,0.00,0.00,6838.71,0.00,'2022-06-01 18:20:05','',''),(1375,'21','226','1',1,'Sale Id shift 82',0.00,0.00,0.00,6750.20,0.00,'2022-06-01 18:20:05','',''),(1376,'21','226','1',1,'Sale Id shift 82',0.00,0.00,0.00,6340.50,0.00,'2022-06-01 18:20:05','',''),(1377,'21','226','1',1,'Sale Id shift 82',0.00,0.00,0.00,6116.07,0.00,'2022-06-01 18:20:05','',''),(1378,'21','226',NULL,2,'Sale Id shift 82',2730208.80,0.00,0.00,0.00,0.00,'2022-06-01 18:20:05','',''),(1379,'21','226',NULL,1,'Sale Id shift 82',6912229.50,0.00,0.00,0.00,0.00,'2022-06-01 18:20:05','',''),(1380,'21','226',NULL,1,'Reception corrector for bridging 114',0.00,0.00,0.00,15000.00,0.00,'2022-06-01 18:52:47','',''),(1381,'21','226','2',1,'Received from bridging 114',0.00,0.00,15000.00,0.00,0.00,'2022-06-01 18:52:47','',''),(1382,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4785000.00,29000.00,0.00,0.00,'2022-06-03 15:10:03','',''),(1383,'21','226',NULL,1,'Reception corrector for bridging 116',0.00,0.00,0.00,14000.00,0.00,'2022-06-03 15:30:56','',''),(1384,'21','226','2',1,'Received from bridging 116',0.00,0.00,14000.00,0.00,0.00,'2022-06-03 15:30:56','',''),(1385,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-03 15:39:07','',''),(1386,'21','226',NULL,1,'Returned purchase #84 to AYM SHAFA NIGERIA. LTD',2475000.00,0.00,0.00,15000.00,0.00,'2022-06-03 16:57:42','',''),(1387,'21','226','2',1,'Sale Id shift 83',0.00,0.00,0.00,2575.17,0.00,'2022-06-03 17:10:09','',''),(1388,'21','226','2',1,'Sale Id shift 83',0.00,0.00,0.00,2742.23,0.00,'2022-06-03 17:10:09','',''),(1389,'21','226','2',1,'Sale Id shift 83',0.00,0.00,0.00,6086.98,0.00,'2022-06-03 17:10:09','',''),(1390,'21','226','2',1,'Sale Id shift 83',0.00,0.00,0.00,5844.83,0.00,'2022-06-03 17:10:09','',''),(1391,'21','226','2',1,'Sale Id shift 83',0.00,0.00,0.00,3595.03,0.00,'2022-06-03 17:10:09','',''),(1392,'21','226','2',1,'Sale Id shift 83',0.00,0.00,0.00,3227.55,0.00,'2022-06-03 17:10:09','',''),(1393,'21','226','2',1,'Sale Id shift 83',0.00,0.00,0.00,3128.04,0.00,'2022-06-03 17:10:09','',''),(1394,'21','226','2',1,'Sale Id shift 83',0.00,0.00,0.00,3311.08,0.00,'2022-06-03 17:10:09','',''),(1395,'21','226','3',2,'Sale Id shift 83',0.00,0.00,0.00,1447.61,0.00,'2022-06-03 17:10:09','',''),(1396,'21','226','3',2,'Sale Id shift 83',0.00,0.00,0.00,1733.16,0.00,'2022-06-03 17:10:09','',''),(1397,'21','226','1',1,'Sale Id shift 83',0.00,0.00,0.00,1791.92,0.00,'2022-06-03 17:10:09','',''),(1398,'21','226','1',1,'Sale Id shift 83',0.00,0.00,0.00,1887.17,0.00,'2022-06-03 17:10:09','',''),(1399,'21','226','1',1,'Sale Id shift 83',0.00,0.00,0.00,128.73,0.00,'2022-06-03 17:10:09','',''),(1400,'21','226',NULL,1,'Sale Id shift 83',5662590.45,0.00,0.00,0.00,0.00,'2022-06-03 17:10:09','',''),(1401,'21','226',NULL,2,'Sale Id shift 83',2417385.20,0.00,0.00,0.00,0.00,'2022-06-03 17:10:09','',''),(1402,'21','226',NULL,1,'Reception corrector for bridging 118',0.00,0.00,0.00,15000.00,0.00,'2022-06-03 17:21:08','',''),(1403,'21','226','2',1,'Received from bridging 118',0.00,0.00,15000.00,0.00,0.00,'2022-06-03 17:21:08','',''),(1404,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,26600000.00,35000.00,0.00,0.00,'2022-06-03 18:37:21','',''),(1405,'21','226','3',2,'Sale Id shift 84',0.00,0.00,0.00,1253.37,0.00,'2022-06-03 18:37:25','',''),(1406,'21','226','3',2,'Sale Id shift 84',0.00,0.00,0.00,1297.13,0.00,'2022-06-03 18:37:25','',''),(1407,'21','226','1',1,'Sale Id shift 84',0.00,0.00,0.00,4636.75,0.00,'2022-06-03 18:37:25','',''),(1408,'21','226','1',1,'Sale Id shift 84',0.00,0.00,0.00,4380.68,0.00,'2022-06-03 18:37:25','',''),(1409,'21','226','1',1,'Sale Id shift 84',0.00,0.00,0.00,4633.51,0.00,'2022-06-03 18:37:25','',''),(1410,'21','226','1',1,'Sale Id shift 84',0.00,0.00,0.00,5073.20,0.00,'2022-06-03 18:37:25','',''),(1411,'21','226','1',1,'Sale Id shift 84',0.00,0.00,0.00,3190.66,0.00,'2022-06-03 18:37:25','',''),(1412,'21','226','1',1,'Sale Id shift 84',0.00,0.00,0.00,3251.77,0.00,'2022-06-03 18:37:25','',''),(1413,'21','226',NULL,1,'Sale Id shift 84',4152484.05,0.00,0.00,0.00,0.00,'2022-06-03 18:37:25','',''),(1414,'21','226',NULL,2,'Sale Id shift 84',1938380.00,0.00,0.00,0.00,0.00,'2022-06-03 18:37:25','',''),(1415,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-03 18:39:01','',''),(1416,'21','226',NULL,1,'Reception corrector for bridging 119',0.00,0.00,0.00,30000.00,0.00,'2022-06-03 18:39:57','',''),(1417,'21','226','1',1,'Received from bridging 119',0.00,0.00,30000.00,0.00,0.00,'2022-06-03 18:39:57','',''),(1418,'21','226','3',2,'Sale Id shift 85',0.00,0.00,0.00,2357.27,0.00,'2022-06-03 18:51:26','',''),(1419,'21','226','3',2,'Sale Id shift 85',0.00,0.00,0.00,2108.31,0.00,'2022-06-03 18:51:26','',''),(1420,'21','226','1',1,'Sale Id shift 85',0.00,0.00,0.00,947.11,0.00,'2022-06-03 18:51:26','',''),(1421,'21','226','1',1,'Sale Id shift 85',0.00,0.00,0.00,1183.45,0.00,'2022-06-03 18:51:26','',''),(1422,'21','226','1',1,'Sale Id shift 85',0.00,0.00,0.00,1362.09,0.00,'2022-06-03 18:51:26','',''),(1423,'21','226','1',1,'Sale Id shift 85',0.00,0.00,0.00,1245.10,0.00,'2022-06-03 18:51:26','',''),(1424,'21','226',NULL,1,'Sale Id shift 85',781728.75,0.00,0.00,0.00,0.00,'2022-06-03 18:51:26','',''),(1425,'21','226',NULL,2,'Sale Id shift 85',3393840.80,0.00,0.00,0.00,0.00,'2022-06-03 18:51:26','',''),(1426,'21','226','2',1,'Sale Id shift 86',0.00,0.00,0.00,6802.56,0.00,'2022-06-05 17:09:23','',''),(1427,'21','226','2',1,'Sale Id shift 86',0.00,0.00,0.00,6731.99,0.00,'2022-06-05 17:09:23','',''),(1428,'21','226','2',1,'Sale Id shift 86',0.00,0.00,0.00,6750.11,0.00,'2022-06-05 17:09:23','',''),(1429,'21','226','2',1,'Sale Id shift 86',0.00,0.00,0.00,7425.18,0.00,'2022-06-05 17:09:23','',''),(1430,'21','226','3',2,'Sale Id shift 86',0.00,0.00,0.00,1790.34,0.00,'2022-06-05 17:09:23','',''),(1431,'21','226','3',2,'Sale Id shift 86',0.00,0.00,0.00,3438.55,0.00,'2022-06-05 17:09:23','',''),(1432,'21','226',NULL,1,'Sale Id shift 86',4572123.60,0.00,0.00,0.00,0.00,'2022-06-05 17:09:23','',''),(1433,'21','226',NULL,2,'Sale Id shift 86',3973956.40,0.00,0.00,0.00,0.00,'2022-06-05 17:09:23','',''),(1434,'21','226','3',2,'Sale Id shift 87',0.00,0.00,0.00,432.13,0.00,'2022-06-05 17:16:31','',''),(1435,'21','226','3',2,'Sale Id shift 87',0.00,0.00,0.00,445.68,0.00,'2022-06-05 17:16:31','',''),(1436,'21','226',NULL,2,'Sale Id shift 87',667135.60,0.00,0.00,0.00,0.00,'2022-06-05 17:16:31','',''),(1437,'21','226',NULL,2,'Reception corrector for bridging 120',0.00,0.00,0.00,35000.00,0.00,'2022-06-05 17:16:39','',''),(1438,'21','226','3',2,'Received from bridging 120',0.00,0.00,35000.00,0.00,0.00,'2022-06-05 17:16:39','',''),(1439,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-05 17:18:02','',''),(1440,'21','226',NULL,1,'Reception corrector for bridging 122',0.00,0.00,0.00,15000.00,0.00,'2022-06-05 17:19:21','',''),(1441,'21','226','2',1,'Received from bridging 122',0.00,0.00,15000.00,0.00,0.00,'2022-06-05 17:19:21','',''),(1442,'21','226',NULL,1,'Reception corrector for bridging 121',0.00,0.00,0.00,15000.00,0.00,'2022-06-05 17:19:21','',''),(1443,'21','226','1',1,'Received from bridging 121',0.00,0.00,15000.00,0.00,0.00,'2022-06-05 17:19:21','',''),(1444,'21','226','2',1,'Sale Id shift 88',0.00,0.00,0.00,50.29,0.00,'2022-06-05 17:36:50','',''),(1445,'21','226','2',1,'Sale Id shift 88',0.00,0.00,0.00,876.61,0.00,'2022-06-05 17:36:50','',''),(1446,'21','226','2',1,'Sale Id shift 88',0.00,0.00,0.00,676.75,0.00,'2022-06-05 17:36:50','',''),(1447,'21','226','3',2,'Sale Id shift 88',0.00,0.00,0.00,1217.14,0.00,'2022-06-05 17:36:50','',''),(1448,'21','226','3',2,'Sale Id shift 88',0.00,0.00,0.00,4504.84,0.00,'2022-06-05 17:36:50','',''),(1449,'21','226','1',1,'Sale Id shift 88',0.00,0.00,0.00,7582.80,0.00,'2022-06-05 17:36:50','',''),(1450,'21','226','1',1,'Sale Id shift 88',0.00,0.00,0.00,8399.60,0.00,'2022-06-05 17:36:50','',''),(1451,'21','226','1',1,'Sale Id shift 88',0.00,0.00,0.00,7246.39,0.00,'2022-06-05 17:36:50','',''),(1452,'21','226','1',1,'Sale Id shift 88',0.00,0.00,0.00,6909.99,0.00,'2022-06-05 17:36:50','',''),(1453,'21','226',NULL,2,'Sale Id shift 88',4405924.60,0.00,0.00,0.00,0.00,'2022-06-05 17:36:50','',''),(1454,'21','226',NULL,1,'Sale Id shift 88',5237500.95,0.00,0.00,0.00,0.00,'2022-06-05 17:36:50','',''),(1455,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-06 18:33:48','',''),(1456,'21','226',NULL,1,'Reception corrector for bridging 124',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 18:35:17','',''),(1457,'21','226','2',1,'Received from bridging 124',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 18:35:17','',''),(1458,'21','226',NULL,1,'Reception corrector for bridging 123',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 18:35:17','',''),(1459,'21','226','1',1,'Received from bridging 123',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 18:35:17','',''),(1460,'21','226','3',2,'Sale Id shift 89',0.00,0.00,0.00,271.21,0.00,'2022-06-06 18:38:18','',''),(1461,'21','226','3',2,'Sale Id shift 89',0.00,0.00,0.00,822.41,0.00,'2022-06-06 18:38:18','',''),(1462,'21','226',NULL,2,'Sale Id shift 89',842087.40,0.00,0.00,0.00,0.00,'2022-06-06 18:38:18','',''),(1463,'21','226','1',1,'Sale Id shift 90',0.00,0.00,0.00,0.19,0.00,'2022-06-06 18:53:51','',''),(1464,'21','226','2',1,'Sale Id shift 90',0.00,0.00,0.00,3825.07,0.00,'2022-06-06 18:53:51','',''),(1465,'21','226','2',1,'Sale Id shift 90',0.00,0.00,0.00,3949.80,0.00,'2022-06-06 18:53:51','',''),(1466,'21','226','2',1,'Sale Id shift 90',0.00,0.00,0.00,1803.94,0.00,'2022-06-06 18:53:51','',''),(1467,'21','226','2',1,'Sale Id shift 90',0.00,0.00,0.00,2071.04,0.00,'2022-06-06 18:53:51','',''),(1468,'21','226','2',1,'Sale Id shift 90',0.00,0.00,0.00,1433.91,0.00,'2022-06-06 18:53:51','',''),(1469,'21','226','2',1,'Sale Id shift 90',0.00,0.00,0.00,1834.12,0.00,'2022-06-06 18:53:51','',''),(1470,'21','226','3',2,'Sale Id shift 90',0.00,0.00,0.00,2198.69,0.00,'2022-06-06 18:53:51','',''),(1471,'21','226','3',2,'Sale Id shift 90',0.00,0.00,0.00,1748.56,0.00,'2022-06-06 18:53:51','',''),(1472,'21','226','1',1,'Sale Id shift 90',0.00,0.00,0.00,3426.01,0.00,'2022-06-06 18:53:51','',''),(1473,'21','226','1',1,'Sale Id shift 90',0.00,0.00,0.00,3656.21,0.00,'2022-06-06 18:53:51','',''),(1474,'21','226','1',1,'Sale Id shift 90',0.00,0.00,0.00,540.54,0.00,'2022-06-06 18:53:51','',''),(1475,'21','226','1',1,'Sale Id shift 90',0.00,0.00,0.00,561.67,0.00,'2022-06-06 18:53:51','',''),(1476,'21','226','1',1,'Sale Id shift 90',0.00,0.00,0.00,3489.82,0.00,'2022-06-06 18:53:51','',''),(1477,'21','226','1',1,'Sale Id shift 90',0.00,0.00,0.00,3257.01,0.00,'2022-06-06 18:53:51','',''),(1478,'21','226',NULL,1,'Sale Id shift 90',4925139.45,0.00,0.00,0.00,0.00,'2022-06-06 18:53:51','',''),(1479,'21','226',NULL,2,'Sale Id shift 90',3039382.50,0.00,0.00,0.00,0.00,'2022-06-06 18:53:51','',''),(1480,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-08 08:38:41','',''),(1481,'21','226',NULL,1,'Reception corrector for bridging 126',0.00,0.00,0.00,15000.00,0.00,'2022-06-08 08:39:54','',''),(1482,'21','226','2',1,'Received from bridging 126',0.00,0.00,15000.00,0.00,0.00,'2022-06-08 08:39:54','',''),(1483,'21','226',NULL,1,'Reception corrector for bridging 125',0.00,0.00,0.00,15000.00,0.00,'2022-06-08 08:39:54','',''),(1484,'21','226','1',1,'Received from bridging 125',0.00,0.00,15000.00,0.00,0.00,'2022-06-08 08:39:54','',''),(1485,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-08 08:44:52','',''),(1486,'21','226',NULL,1,'Reception corrector for bridging 127',0.00,0.00,0.00,30000.00,0.00,'2022-06-08 08:45:37','',''),(1487,'21','226','1',1,'Received from bridging 127',0.00,0.00,30000.00,0.00,0.00,'2022-06-08 08:45:37','',''),(1488,'21','226','3',2,'Sale Id shift 91',0.00,0.00,0.00,2079.02,0.00,'2022-06-08 12:35:47','',''),(1489,'21','226','3',2,'Sale Id shift 91',0.00,0.00,0.00,2239.14,0.00,'2022-06-08 12:35:47','',''),(1490,'21','226','1',1,'Sale Id shift 91',0.00,0.00,0.00,7201.58,0.00,'2022-06-08 12:35:47','',''),(1491,'21','226','1',1,'Sale Id shift 91',0.00,0.00,0.00,7823.44,0.00,'2022-06-08 12:35:47','',''),(1492,'21','226','1',1,'Sale Id shift 91',0.00,0.00,0.00,7381.01,0.00,'2022-06-08 12:35:47','',''),(1493,'21','226','1',1,'Sale Id shift 91',0.00,0.00,0.00,7631.53,0.00,'2022-06-08 12:35:47','',''),(1494,'21','226',NULL,1,'Sale Id shift 91',4956197.40,0.00,0.00,0.00,0.00,'2022-06-08 12:35:47','',''),(1495,'21','226',NULL,2,'Sale Id shift 91',3368164.80,0.00,0.00,0.00,0.00,'2022-06-08 12:35:47','',''),(1496,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-09 10:58:02','',''),(1497,'21','226',NULL,1,'Reception corrector for bridging 129',0.00,0.00,0.00,15000.00,0.00,'2022-06-09 10:59:01','',''),(1498,'21','226','2',1,'Received from bridging 129',0.00,0.00,15000.00,0.00,0.00,'2022-06-09 10:59:01','',''),(1499,'21','226',NULL,1,'Reception corrector for bridging 128',0.00,0.00,0.00,15000.00,0.00,'2022-06-09 10:59:01','',''),(1500,'21','226','1',1,'Received from bridging 128',0.00,0.00,15000.00,0.00,0.00,'2022-06-09 10:59:01','',''),(1501,'21','226','2',1,'Sale Id shift 92',0.00,0.00,0.00,6993.92,0.00,'2022-06-09 11:22:21','',''),(1502,'21','226','2',1,'Sale Id shift 92',0.00,0.00,0.00,8153.31,0.00,'2022-06-09 11:22:21','',''),(1503,'21','226','2',1,'Sale Id shift 92',0.00,0.00,0.00,6264.23,0.00,'2022-06-09 11:22:21','',''),(1504,'21','226','2',1,'Sale Id shift 92',0.00,0.00,0.00,6974.88,0.00,'2022-06-09 11:22:21','',''),(1505,'21','226','2',1,'Sale Id shift 92',0.00,0.00,0.00,190.34,0.00,'2022-06-09 11:22:21','',''),(1506,'21','226','2',1,'Sale Id shift 92',0.00,0.00,0.00,148.62,0.00,'2022-06-09 11:22:21','',''),(1507,'21','226','2',1,'Sale Id shift 92',0.00,0.00,0.00,216.07,0.00,'2022-06-09 11:22:21','',''),(1508,'21','226','2',1,'Sale Id shift 92',0.00,0.00,0.00,194.86,0.00,'2022-06-09 11:22:21','',''),(1509,'21','226','3',2,'Sale Id shift 92',0.00,0.00,0.00,1378.05,0.00,'2022-06-09 11:22:21','',''),(1510,'21','226','3',2,'Sale Id shift 92',0.00,0.00,0.00,662.77,0.00,'2022-06-09 11:22:21','',''),(1511,'21','226',NULL,2,'Sale Id shift 92',1591839.60,0.00,0.00,0.00,0.00,'2022-06-09 11:22:21','',''),(1512,'21','226',NULL,1,'Sale Id shift 92',4807477.95,0.00,0.00,0.00,0.00,'2022-06-09 11:22:21','',''),(1513,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4455000.00,27000.00,0.00,0.00,'2022-06-12 13:44:13','',''),(1514,'21','226',NULL,1,'Reception corrector for bridging 131',0.00,0.00,0.00,12000.00,0.00,'2022-06-12 13:45:33','',''),(1515,'21','226','2',1,'Received from bridging 131',0.00,0.00,12000.00,0.00,0.00,'2022-06-12 13:45:33','',''),(1516,'21','226',NULL,1,'Reception corrector for bridging 130',0.00,0.00,0.00,15000.00,0.00,'2022-06-12 13:45:33','',''),(1517,'21','226','1',1,'Received from bridging 130',0.00,0.00,15000.00,0.00,0.00,'2022-06-12 13:45:33','',''),(1518,'21','226','2',1,'Sale Id shift 93',0.00,0.00,0.00,246.54,0.00,'2022-06-12 15:07:35','',''),(1519,'21','226','2',1,'Sale Id shift 93',0.00,0.00,0.00,123.67,0.00,'2022-06-12 15:07:35','',''),(1520,'21','226','2',1,'Sale Id shift 93',0.00,0.00,0.00,169.32,0.00,'2022-06-12 15:07:35','',''),(1521,'21','226','2',1,'Sale Id shift 93',0.00,0.00,0.00,222.35,0.00,'2022-06-12 15:07:35','',''),(1522,'21','226','2',1,'Sale Id shift 93',0.00,0.00,0.00,242.07,0.00,'2022-06-12 15:07:35','',''),(1523,'21','226','3',2,'Sale Id shift 93',0.00,0.00,0.00,1761.95,0.00,'2022-06-12 15:07:35','',''),(1524,'21','226','3',2,'Sale Id shift 93',0.00,0.00,0.00,560.98,0.00,'2022-06-12 15:07:35','',''),(1525,'21','226','1',1,'Sale Id shift 93',0.00,0.00,0.00,7346.84,0.00,'2022-06-12 15:07:35','',''),(1526,'21','226','1',1,'Sale Id shift 93',0.00,0.00,0.00,7424.40,0.00,'2022-06-12 15:07:35','',''),(1527,'21','226','1',1,'Sale Id shift 93',0.00,0.00,0.00,7789.52,0.00,'2022-06-12 15:07:35','',''),(1528,'21','226','1',1,'Sale Id shift 93',0.00,0.00,0.00,7436.70,0.00,'2022-06-12 15:07:35','',''),(1529,'21','226',NULL,1,'Sale Id shift 93',5115232.65,0.00,0.00,0.00,0.00,'2022-06-12 15:07:35','',''),(1530,'21','226',NULL,2,'Sale Id shift 93',1811885.40,0.00,0.00,0.00,0.00,'2022-06-12 15:07:35','',''),(1531,'21','226','3',2,'Sale Id shift 94',0.00,0.00,0.00,1136.96,0.00,'2022-06-12 15:15:47','',''),(1532,'21','226','3',2,'Sale Id shift 94',0.00,0.00,0.00,452.99,0.00,'2022-06-12 15:15:47','',''),(1533,'21','226',NULL,2,'Sale Id shift 94',1271960.00,0.00,0.00,0.00,0.00,'2022-06-12 15:15:47','',''),(1534,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-12 15:27:48','',''),(1535,'21','226',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,15000.00,0.00,'2022-06-12 15:40:21','',''),(1536,'21','226','2',1,'Received from bridging 133',0.00,0.00,15000.00,0.00,0.00,'2022-06-12 15:40:21','',''),(1537,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4548555.00,27567.00,0.00,0.00,'2022-06-12 15:41:59','',''),(1538,'21','226',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,16117.00,0.00,'2022-06-12 15:43:04','',''),(1539,'21','226','1',1,'Received from bridging 134',0.00,0.00,16117.00,0.00,0.00,'2022-06-12 15:43:04','',''),(1540,'21','226','3',2,'Sale Id shift 95',0.00,0.00,0.00,2064.98,0.00,'2022-06-12 17:09:15','',''),(1541,'21','226','3',2,'Sale Id shift 95',0.00,0.00,0.00,1841.89,0.00,'2022-06-12 17:09:15','',''),(1542,'21','226','1',1,'Sale Id shift 95',0.00,0.00,0.00,7608.84,0.00,'2022-06-12 17:09:15','',''),(1543,'21','226','1',1,'Sale Id shift 95',0.00,0.00,0.00,7546.88,0.00,'2022-06-12 17:09:15','',''),(1544,'21','226','1',1,'Sale Id shift 95',0.00,0.00,0.00,7571.95,0.00,'2022-06-12 17:09:15','',''),(1545,'21','226','1',1,'Sale Id shift 95',0.00,0.00,0.00,7405.38,0.00,'2022-06-12 17:09:15','',''),(1546,'21','226',NULL,1,'Sale Id shift 95',4971953.25,0.00,0.00,0.00,0.00,'2022-06-12 17:09:15','',''),(1547,'21','226',NULL,2,'Sale Id shift 95',3125496.00,0.00,0.00,0.00,0.00,'2022-06-12 17:09:15','',''),(1548,'21','226','2',1,'Sale Id shift 96',0.00,0.00,0.00,1124.42,0.00,'2022-06-12 19:11:52','',''),(1549,'21','226','2',1,'Sale Id shift 96',0.00,0.00,0.00,1276.81,0.00,'2022-06-12 19:11:52','',''),(1550,'21','226','2',1,'Sale Id shift 96',0.00,0.00,0.00,6588.81,0.00,'2022-06-12 19:11:52','',''),(1551,'21','226','2',1,'Sale Id shift 96',0.00,0.00,0.00,6504.29,0.00,'2022-06-12 19:11:52','',''),(1552,'21','226','2',1,'Sale Id shift 96',0.00,0.00,0.00,4954.31,0.00,'2022-06-12 19:11:52','',''),(1553,'21','226','2',1,'Sale Id shift 96',0.00,0.00,0.00,5563.39,0.00,'2022-06-12 19:11:52','',''),(1554,'21','226','2',1,'Sale Id shift 96',0.00,0.00,0.00,426.18,0.00,'2022-06-12 19:11:52','',''),(1555,'21','226','2',1,'Sale Id shift 96',0.00,0.00,0.00,648.89,0.00,'2022-06-12 19:11:52','',''),(1556,'21','226','3',2,'Sale Id shift 96',0.00,0.00,0.00,798.75,0.00,'2022-06-12 19:11:52','',''),(1557,'21','226','3',2,'Sale Id shift 96',0.00,0.00,0.00,1968.56,0.00,'2022-06-12 19:11:52','',''),(1558,'21','226',NULL,1,'Sale Id shift 96',4469371.50,0.00,0.00,0.00,0.00,'2022-06-12 19:11:52','',''),(1559,'21','226',NULL,2,'Sale Id shift 96',2213848.00,0.00,0.00,0.00,0.00,'2022-06-12 19:11:52','',''),(1560,'21','226','3',2,'Sale Id shift 97',0.00,0.00,0.00,1097.37,0.00,'2022-06-16 11:38:27','',''),(1561,'21','226','3',2,'Sale Id shift 97',0.00,0.00,0.00,2052.33,0.00,'2022-06-16 11:38:27','',''),(1562,'21','226',NULL,2,'Sale Id shift 97',2519760.00,0.00,0.00,0.00,0.00,'2022-06-16 11:38:27','',''),(1563,'21','226',NULL,1,'Reception corrector for bridging 135',0.00,0.00,0.00,15000.00,0.00,'2022-06-16 11:38:55','',''),(1564,'21','226','1',1,'Received from bridging 135',0.00,0.00,15000.00,0.00,0.00,'2022-06-16 11:38:55','',''),(1565,'21','226',NULL,1,'Reception corrector for bridging 136',0.00,0.00,0.00,11450.00,0.00,'2022-06-16 11:40:58','',''),(1566,'21','226','2',1,'Received from bridging 136',0.00,0.00,11450.00,0.00,0.00,'2022-06-16 11:40:58','',''),(1567,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-16 11:41:50','',''),(1568,'21','226',NULL,1,'Reception corrector for bridging 138',0.00,0.00,0.00,12800.00,0.00,'2022-06-16 11:43:19','',''),(1569,'21','226','2',1,'Received from bridging 138',0.00,0.00,12800.00,0.00,0.00,'2022-06-16 11:43:19','',''),(1570,'21','226',NULL,1,'Reception corrector for bridging 137',0.00,0.00,0.00,17200.00,0.00,'2022-06-16 11:43:19','',''),(1571,'21','226','1',1,'Received from bridging 137',0.00,0.00,17200.00,0.00,0.00,'2022-06-16 11:43:19','',''),(1572,'21','226','3',2,'Sale Id shift 98',0.00,0.00,0.00,1001.39,0.00,'2022-06-16 12:04:43','',''),(1573,'21','226','3',2,'Sale Id shift 98',0.00,0.00,0.00,531.13,0.00,'2022-06-16 12:04:43','',''),(1574,'21','226','1',1,'Sale Id shift 98',0.00,0.00,0.00,7956.07,0.00,'2022-06-16 12:04:43','',''),(1575,'21','226','1',1,'Sale Id shift 98',0.00,0.00,0.00,7718.48,0.00,'2022-06-16 12:04:43','',''),(1576,'21','226','1',1,'Sale Id shift 98',0.00,0.00,0.00,7331.14,0.00,'2022-06-16 12:04:43','',''),(1577,'21','226','1',1,'Sale Id shift 98',0.00,0.00,0.00,7215.50,0.00,'2022-06-16 12:04:43','',''),(1578,'21','226',NULL,2,'Sale Id shift 98',1256666.40,0.00,0.00,0.00,0.00,'2022-06-16 12:04:43','',''),(1579,'21','226',NULL,1,'Sale Id shift 98',4986496.35,0.00,0.00,0.00,0.00,'2022-06-16 12:04:43','',''),(1580,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,36900000.00,45000.00,0.00,0.00,'2022-06-16 12:27:21','',''),(1581,'21','226',NULL,2,'Reception corrector for bridging 139',0.00,0.00,0.00,30000.00,0.00,'2022-06-16 12:28:36','',''),(1582,'21','226','3',2,'Received from bridging 139',0.00,0.00,30000.00,0.00,0.00,'2022-06-16 12:28:36','',''),(1583,'21','226','2',1,'Sale Id shift 99',0.00,0.00,0.00,1173.17,0.00,'2022-06-16 12:37:32','',''),(1584,'21','226','2',1,'Sale Id shift 99',0.00,0.00,0.00,1267.34,0.00,'2022-06-16 12:37:32','',''),(1585,'21','226','2',1,'Sale Id shift 99',0.00,0.00,0.00,6464.90,0.00,'2022-06-16 12:37:32','',''),(1586,'21','226','2',1,'Sale Id shift 99',0.00,0.00,0.00,6487.67,0.00,'2022-06-16 12:37:32','',''),(1587,'21','226','3',2,'Sale Id shift 99',0.00,0.00,0.00,3264.30,0.00,'2022-06-16 12:37:32','',''),(1588,'21','226','3',2,'Sale Id shift 99',0.00,0.00,0.00,1703.63,0.00,'2022-06-16 12:37:32','',''),(1589,'21','226','1',1,'Sale Id shift 99',0.00,0.00,0.00,6161.07,0.00,'2022-06-16 12:37:32','',''),(1590,'21','226','1',1,'Sale Id shift 99',0.00,0.00,0.00,5473.79,0.00,'2022-06-16 12:37:32','',''),(1591,'21','226','1',1,'Sale Id shift 99',0.00,0.00,0.00,186.47,0.00,'2022-06-16 12:37:32','',''),(1592,'21','226','1',1,'Sale Id shift 99',0.00,0.00,0.00,289.55,0.00,'2022-06-16 12:37:32','',''),(1593,'21','226',NULL,1,'Sale Id shift 99',4538153.40,0.00,0.00,0.00,0.00,'2022-06-16 12:37:32','',''),(1594,'21','226',NULL,2,'Sale Id shift 99',4073702.60,0.00,0.00,0.00,0.00,'2022-06-16 12:37:32','',''),(1595,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-16 12:55:37','',''),(1596,'21','226',NULL,1,'Reception corrector for bridging 140',0.00,0.00,0.00,30000.00,0.00,'2022-06-16 12:57:04','',''),(1597,'21','226','1',1,'Received from bridging 140',0.00,0.00,30000.00,0.00,0.00,'2022-06-16 12:57:04','',''),(1598,'21','226','2',1,'Sale Id shift 100',0.00,0.00,0.00,5723.75,0.00,'2022-06-16 14:14:03','',''),(1599,'21','226','2',1,'Sale Id shift 100',0.00,0.00,0.00,6299.01,0.00,'2022-06-16 14:14:03','',''),(1600,'21','226','3',2,'Sale Id shift 100',0.00,0.00,0.00,2164.69,0.00,'2022-06-16 14:14:03','',''),(1601,'21','226','3',2,'Sale Id shift 100',0.00,0.00,0.00,2995.81,0.00,'2022-06-16 14:14:03','',''),(1602,'21','226','1',1,'Sale Id shift 100',0.00,0.00,0.00,7944.41,0.00,'2022-06-16 14:14:03','',''),(1603,'21','226','1',1,'Sale Id shift 100',0.00,0.00,0.00,7849.61,0.00,'2022-06-16 14:14:03','',''),(1604,'21','226',NULL,1,'Sale Id shift 100',4589768.70,0.00,0.00,0.00,0.00,'2022-06-16 14:14:03','',''),(1605,'21','226',NULL,2,'Sale Id shift 100',4231610.00,0.00,0.00,0.00,0.00,'2022-06-16 14:14:03','',''),(1606,'21','226','3',2,'Sale Id shift 101',0.00,0.00,0.00,1587.92,0.00,'2022-06-16 14:22:25','',''),(1607,'21','226','3',2,'Sale Id shift 101',0.00,0.00,0.00,2634.20,0.00,'2022-06-16 14:22:25','',''),(1608,'21','226',NULL,2,'Sale Id shift 101',3462138.40,0.00,0.00,0.00,0.00,'2022-06-16 14:22:25','',''),(1609,'21','226',NULL,2,'Reception corrector for bridging 141',0.00,0.00,0.00,15000.00,0.00,'2022-06-16 14:22:47','',''),(1610,'21','226','3',2,'Received from bridging 141',0.00,0.00,15000.00,0.00,0.00,'2022-06-16 14:22:47','',''),(1611,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-21 11:19:31','',''),(1612,'21','226',NULL,1,'Reception corrector for bridging 143',0.00,0.00,0.00,4000.00,0.00,'2022-06-21 11:20:49','',''),(1613,'21','226','2',1,'Received from bridging 143',0.00,0.00,4000.00,0.00,0.00,'2022-06-21 11:20:49','',''),(1614,'21','226',NULL,1,'Reception corrector for bridging 142',0.00,0.00,0.00,36000.00,0.00,'2022-06-21 11:20:49','',''),(1615,'21','226','1',1,'Received from bridging 142',0.00,0.00,36000.00,0.00,0.00,'2022-06-21 11:20:49','',''),(1616,'21','226','3',2,'Sale Id shift 102',0.00,0.00,0.00,2184.63,0.00,'2022-06-21 11:30:12','',''),(1617,'21','226','3',2,'Sale Id shift 102',0.00,0.00,0.00,1596.96,0.00,'2022-06-21 11:30:12','',''),(1618,'21','226',NULL,2,'Sale Id shift 102',3100903.80,0.00,0.00,0.00,0.00,'2022-06-21 11:30:12','',''),(1619,'21','226','3',2,'Sale Id shift 103',0.00,0.00,0.00,846.80,0.00,'2022-06-21 11:48:27','',''),(1620,'21','226','3',2,'Sale Id shift 103',0.00,0.00,0.00,1262.48,0.00,'2022-06-21 11:48:27','',''),(1621,'21','226','1',1,'Sale Id shift 103',0.00,0.00,0.00,8153.76,0.00,'2022-06-21 11:48:27','',''),(1622,'21','226','1',1,'Sale Id shift 103',0.00,0.00,0.00,7808.60,0.00,'2022-06-21 11:48:27','',''),(1623,'21','226','1',1,'Sale Id shift 103',0.00,0.00,0.00,8418.65,0.00,'2022-06-21 11:48:27','',''),(1624,'21','226','1',1,'Sale Id shift 103',0.00,0.00,0.00,7896.88,0.00,'2022-06-21 11:48:27','',''),(1625,'21','226',NULL,2,'Sale Id shift 103',1750702.40,0.00,0.00,0.00,0.00,'2022-06-21 11:48:27','',''),(1626,'21','226',NULL,1,'Sale Id shift 103',5325851.85,0.00,0.00,0.00,0.00,'2022-06-21 11:48:27','',''),(1627,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-21 11:51:50','',''),(1628,'21','226',NULL,1,'Reception corrector for bridging 145',0.00,0.00,0.00,15000.00,0.00,'2022-06-21 11:52:44','',''),(1629,'21','226','2',1,'Received from bridging 145',0.00,0.00,15000.00,0.00,0.00,'2022-06-21 11:52:44','',''),(1630,'21','226',NULL,1,'Reception corrector for bridging 144',0.00,0.00,0.00,15000.00,0.00,'2022-06-21 11:52:44','',''),(1631,'21','226','1',1,'Received from bridging 144',0.00,0.00,15000.00,0.00,0.00,'2022-06-21 11:52:44','',''),(1632,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-21 11:53:32','',''),(1633,'21','226',NULL,1,'Reception corrector for bridging 147',0.00,0.00,0.00,15000.00,0.00,'2022-06-21 11:54:22','',''),(1634,'21','226','2',1,'Received from bridging 147',0.00,0.00,15000.00,0.00,0.00,'2022-06-21 11:54:22','',''),(1635,'21','226',NULL,1,'Reception corrector for bridging 146',0.00,0.00,0.00,15000.00,0.00,'2022-06-21 11:54:22','',''),(1636,'21','226','1',1,'Received from bridging 146',0.00,0.00,15000.00,0.00,0.00,'2022-06-21 11:54:22','',''),(1637,'21','226','2',1,'Sale Id shift 104',0.00,0.00,0.00,0.19,0.00,'2022-06-21 12:02:01','',''),(1638,'21','226','2',1,'Sale Id shift 104',0.00,0.00,0.00,6971.80,0.00,'2022-06-21 12:02:01','',''),(1639,'21','226','2',1,'Sale Id shift 104',0.00,0.00,0.00,7163.59,0.00,'2022-06-21 12:02:01','',''),(1640,'21','226','3',2,'Sale Id shift 104',0.00,0.00,0.00,1131.87,0.00,'2022-06-21 12:02:01','',''),(1641,'21','226','3',2,'Sale Id shift 104',0.00,0.00,0.00,1026.49,0.00,'2022-06-21 12:02:01','',''),(1642,'21','226','1',1,'Sale Id shift 104',0.00,0.00,0.00,6752.98,0.00,'2022-06-21 12:02:01','',''),(1643,'21','226','1',1,'Sale Id shift 104',0.00,0.00,0.00,6798.92,0.00,'2022-06-21 12:02:01','',''),(1644,'21','226','1',1,'Sale Id shift 104',0.00,0.00,0.00,6585.37,0.00,'2022-06-21 12:02:01','',''),(1645,'21','226','1',1,'Sale Id shift 104',0.00,0.00,0.00,5872.28,0.00,'2022-06-21 12:02:01','',''),(1646,'21','226',NULL,1,'Sale Id shift 104',6623946.45,0.00,0.00,0.00,0.00,'2022-06-21 12:02:01','',''),(1647,'21','226',NULL,2,'Sale Id shift 104',1791438.80,0.00,0.00,0.00,0.00,'2022-06-21 12:02:01','',''),(1648,'21','226','2',1,'Sale Id shift 105',0.00,0.00,0.00,3136.46,0.00,'2022-06-21 12:10:42','',''),(1649,'21','226','2',1,'Sale Id shift 105',0.00,0.00,0.00,3049.66,0.00,'2022-06-21 12:10:42','',''),(1650,'21','226','2',1,'Sale Id shift 105',0.00,0.00,0.00,3288.70,0.00,'2022-06-21 12:10:42','',''),(1651,'21','226','2',1,'Sale Id shift 105',0.00,0.00,0.00,3566.81,0.00,'2022-06-21 12:10:42','',''),(1652,'21','226','3',2,'Sale Id shift 105',0.00,0.00,0.00,695.16,0.00,'2022-06-21 12:10:42','',''),(1653,'21','226','3',2,'Sale Id shift 105',0.00,0.00,0.00,2024.04,0.00,'2022-06-21 12:10:42','',''),(1654,'21','226','1',1,'Sale Id shift 105',0.00,0.00,0.00,3773.78,0.00,'2022-06-21 12:10:42','',''),(1655,'21','226','1',1,'Sale Id shift 105',0.00,0.00,0.00,3662.70,0.00,'2022-06-21 12:10:42','',''),(1656,'21','226','1',1,'Sale Id shift 105',0.00,0.00,0.00,3818.79,0.00,'2022-06-21 12:10:42','',''),(1657,'21','226','1',1,'Sale Id shift 105',0.00,0.00,0.00,3744.59,0.00,'2022-06-21 12:10:42','',''),(1658,'21','226',NULL,2,'Sale Id shift 105',2256936.00,0.00,0.00,0.00,0.00,'2022-06-21 12:10:42','',''),(1659,'21','226',NULL,1,'Sale Id shift 105',4626845.85,0.00,0.00,0.00,0.00,'2022-06-21 12:10:42','',''),(1660,'21','226','3',2,'Sale Id shift 106',0.00,0.00,0.00,275.79,0.00,'2022-06-21 12:16:40','',''),(1661,'21','226','3',2,'Sale Id shift 106',0.00,0.00,0.00,2516.38,0.00,'2022-06-21 12:16:40','',''),(1662,'21','226',NULL,2,'Sale Id shift 106',2317501.10,0.00,0.00,0.00,0.00,'2022-06-21 12:16:40','',''),(1663,'21','226','3',2,'Sale Id shift 107',0.00,0.00,0.00,851.75,0.00,'2022-06-27 10:21:39','',''),(1664,'21','226','3',2,'Sale Id shift 107',0.00,0.00,0.00,384.45,0.00,'2022-06-27 10:21:39','',''),(1665,'21','226',NULL,2,'Sale Id shift 107',1026046.00,0.00,0.00,0.00,0.00,'2022-06-27 10:21:39','',''),(1666,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-27 10:38:36','',''),(1667,'21','226',NULL,1,'Reception corrector for bridging 149',0.00,0.00,0.00,15500.00,0.00,'2022-06-27 10:41:09','',''),(1668,'21','226','2',1,'Received from bridging 149',0.00,0.00,15500.00,0.00,0.00,'2022-06-27 10:41:09','',''),(1669,'21','226',NULL,1,'Reception corrector for bridging 148',0.00,0.00,0.00,14000.00,0.00,'2022-06-27 10:41:09','',''),(1670,'21','226','1',1,'Received from bridging 148',0.00,0.00,14000.00,0.00,0.00,'2022-06-27 10:41:09','',''),(1671,'21','226','2',1,'Sale Id shift 108',0.00,0.00,0.00,83.23,0.00,'2022-06-27 11:07:58','',''),(1672,'21','226','2',1,'Sale Id shift 108',0.00,0.00,0.00,2955.24,0.00,'2022-06-27 11:07:58','',''),(1673,'21','226','2',1,'Sale Id shift 108',0.00,0.00,0.00,3063.98,0.00,'2022-06-27 11:07:58','',''),(1674,'21','226','2',1,'Sale Id shift 108',0.00,0.00,0.00,3089.43,0.00,'2022-06-27 11:07:58','',''),(1675,'21','226','2',1,'Sale Id shift 108',0.00,0.00,0.00,3163.23,0.00,'2022-06-27 11:07:58','',''),(1676,'21','226','3',2,'Sale Id shift 108',0.00,0.00,0.00,229.49,0.00,'2022-06-27 11:07:58','',''),(1677,'21','226','3',2,'Sale Id shift 108',0.00,0.00,0.00,548.54,0.00,'2022-06-27 11:07:58','',''),(1678,'21','226','1',1,'Sale Id shift 108',0.00,0.00,0.00,4064.88,0.00,'2022-06-27 11:07:58','',''),(1679,'21','226','1',1,'Sale Id shift 108',0.00,0.00,0.00,3908.94,0.00,'2022-06-27 11:07:58','',''),(1680,'21','226','1',1,'Sale Id shift 108',0.00,0.00,0.00,3810.44,0.00,'2022-06-27 11:07:58','',''),(1681,'21','226','1',1,'Sale Id shift 108',0.00,0.00,0.00,3700.23,0.00,'2022-06-27 11:07:58','',''),(1682,'21','226',NULL,1,'Sale Id shift 108',4593534.00,0.00,0.00,0.00,0.00,'2022-06-27 11:07:58','',''),(1683,'21','226',NULL,2,'Sale Id shift 108',645764.90,0.00,0.00,0.00,0.00,'2022-06-27 11:07:58','',''),(1684,'21','226','2',1,'Sale Id shift 109',0.00,0.00,0.00,1.21,0.00,'2022-06-27 11:25:52','',''),(1685,'21','226','2',1,'Sale Id shift 109',0.00,0.00,0.00,207.20,0.00,'2022-06-27 11:25:52','',''),(1686,'21','226','2',1,'Sale Id shift 109',0.00,0.00,0.00,201.29,0.00,'2022-06-27 11:25:52','',''),(1687,'21','226','3',2,'Sale Id shift 109',0.00,0.00,0.00,2477.29,0.00,'2022-06-27 11:25:52','',''),(1688,'21','226','3',2,'Sale Id shift 109',0.00,0.00,0.00,1521.50,0.00,'2022-06-27 11:25:52','',''),(1689,'21','226',NULL,1,'Sale Id shift 109',67600.50,0.00,0.00,0.00,0.00,'2022-06-27 11:25:52','',''),(1690,'21','226',NULL,2,'Sale Id shift 109',3318995.70,0.00,0.00,0.00,0.00,'2022-06-27 11:25:52','',''),(1691,'21','226','2',1,'Distributed to AHF NIGERIA  for sales id:3',2557500.00,0.00,0.00,15500.00,0.00,'2022-06-27 11:39:16','',''),(1692,'21','226','2',1,'Sale Id shift 110',0.00,0.00,0.00,104.68,0.00,'2022-06-27 11:49:35','',''),(1693,'21','226','2',1,'Sale Id shift 110',0.00,0.00,0.00,96.79,0.00,'2022-06-27 11:49:35','',''),(1694,'21','226','2',1,'Sale Id shift 110',0.00,0.00,0.00,1895.01,0.00,'2022-06-27 11:49:35','',''),(1695,'21','226','2',1,'Sale Id shift 110',0.00,0.00,0.00,1844.61,0.00,'2022-06-27 11:49:35','',''),(1696,'21','226','3',2,'Sale Id shift 110',0.00,0.00,0.00,2204.02,0.00,'2022-06-27 11:49:35','',''),(1697,'21','226','3',2,'Sale Id shift 110',0.00,0.00,0.00,3721.57,0.00,'2022-06-27 11:49:35','',''),(1698,'21','226',NULL,1,'Sale Id shift 110',650279.85,0.00,0.00,0.00,0.00,'2022-06-27 11:49:35','',''),(1699,'21','226',NULL,2,'Sale Id shift 110',4918239.70,0.00,0.00,0.00,0.00,'2022-06-27 11:49:35','',''),(1700,'21','226',NULL,1,'Reception corrector for bridging 150',0.00,0.00,0.00,15500.00,0.00,'2022-06-27 12:27:23','',''),(1701,'21','226','2',1,'Received from bridging 150',0.00,0.00,15500.00,0.00,0.00,'2022-06-27 12:27:23','',''),(1702,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-27 12:31:29','',''),(1703,'21','226',NULL,1,'Reception corrector for bridging 151',0.00,0.00,0.00,30000.00,0.00,'2022-06-27 12:32:50','',''),(1704,'21','226','1',1,'Received from bridging 151',0.00,0.00,30000.00,0.00,0.00,'2022-06-27 12:32:50','',''),(1705,'21','226','2',1,'Sale Id shift 112',0.00,0.00,0.00,1916.66,0.00,'2022-07-01 11:59:39','',''),(1706,'21','226','2',1,'Sale Id shift 112',0.00,0.00,0.00,1952.65,0.00,'2022-07-01 11:59:39','',''),(1707,'21','226','2',1,'Sale Id shift 112',0.00,0.00,0.00,2043.70,0.00,'2022-07-01 11:59:39','',''),(1708,'21','226','2',1,'Sale Id shift 112',0.00,0.00,0.00,2159.66,0.00,'2022-07-01 11:59:39','',''),(1709,'21','226','2',1,'Sale Id shift 112',0.00,0.00,0.00,27.11,0.00,'2022-07-01 11:59:39','',''),(1710,'21','226','2',1,'Sale Id shift 112',0.00,0.00,0.00,18.62,0.00,'2022-07-01 11:59:39','',''),(1711,'21','226','3',2,'Sale Id shift 112',0.00,0.00,0.00,188.19,0.00,'2022-07-01 11:59:39','',''),(1712,'21','226','3',2,'Sale Id shift 112',0.00,0.00,0.00,1356.74,0.00,'2022-07-01 11:59:39','',''),(1713,'21','226','1',1,'Sale Id shift 112',0.00,0.00,0.00,3389.57,0.00,'2022-07-01 11:59:39','',''),(1714,'21','226','1',1,'Sale Id shift 112',0.00,0.00,0.00,3604.25,0.00,'2022-07-01 11:59:39','',''),(1715,'21','226','1',1,'Sale Id shift 112',0.00,0.00,0.00,3440.07,0.00,'2022-07-01 11:59:39','',''),(1716,'21','226','1',1,'Sale Id shift 112',0.00,0.00,0.00,3283.83,0.00,'2022-07-01 11:59:39','',''),(1717,'21','226',NULL,1,'Sale Id shift 112',3602959.80,0.00,0.00,0.00,0.00,'2022-07-01 11:59:39','',''),(1718,'21','226',NULL,2,'Sale Id shift 112',1282291.90,0.00,0.00,0.00,0.00,'2022-07-01 11:59:39','',''),(1719,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-01 12:18:37','',''),(1720,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:4',2475000.00,0.00,0.00,15000.00,0.00,'2022-07-01 12:18:58','',''),(1721,'21','226',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,15500.00,0.00,'2022-07-01 12:20:54','',''),(1722,'21','226','2',1,'Received from bridging 153',0.00,0.00,15500.00,0.00,0.00,'2022-07-01 12:20:54','',''),(1723,'21','226',NULL,1,'Reception corrector for bridging 152',0.00,0.00,0.00,29500.00,0.00,'2022-07-01 12:20:54','',''),(1724,'21','226','1',1,'Received from bridging 152',0.00,0.00,29500.00,0.00,0.00,'2022-07-01 12:20:54','',''),(1725,'21','226','2',1,'Sale Id shift 113',0.00,0.00,0.00,806.82,0.00,'2022-07-01 15:07:39','',''),(1726,'21','226','2',1,'Sale Id shift 113',0.00,0.00,0.00,818.81,0.00,'2022-07-01 15:07:39','',''),(1727,'21','226','2',1,'Sale Id shift 113',0.00,0.00,0.00,859.65,0.00,'2022-07-01 15:07:39','',''),(1728,'21','226','2',1,'Sale Id shift 113',0.00,0.00,0.00,985.52,0.00,'2022-07-01 15:07:39','',''),(1729,'21','226','2',1,'Sale Id shift 113',0.00,0.00,0.00,153.52,0.00,'2022-07-01 15:07:39','',''),(1730,'21','226','2',1,'Sale Id shift 113',0.00,0.00,0.00,48.58,0.00,'2022-07-01 15:07:39','',''),(1731,'21','226','3',2,'Sale Id shift 113',0.00,0.00,0.00,695.23,0.00,'2022-07-01 15:07:39','',''),(1732,'21','226','3',2,'Sale Id shift 113',0.00,0.00,0.00,7767.04,0.00,'2022-07-01 15:07:39','',''),(1733,'21','226','1',1,'Sale Id shift 113',0.00,0.00,0.00,3744.57,0.00,'2022-07-01 15:07:39','',''),(1734,'21','226','1',1,'Sale Id shift 113',0.00,0.00,0.00,3785.17,0.00,'2022-07-01 15:07:39','',''),(1735,'21','226','1',1,'Sale Id shift 113',0.00,0.00,0.00,3735.05,0.00,'2022-07-01 15:07:39','',''),(1736,'21','226','1',1,'Sale Id shift 113',0.00,0.00,0.00,3651.20,0.00,'2022-07-01 15:07:39','',''),(1737,'21','226',NULL,1,'Sale Id shift 113',3067166.85,0.00,0.00,0.00,0.00,'2022-07-01 15:07:39','',''),(1738,'21','226',NULL,2,'Sale Id shift 113',7023684.10,0.00,0.00,0.00,0.00,'2022-07-01 15:07:39','',''),(1739,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24792100.00,29870.00,0.00,0.00,'2022-07-01 15:17:34','',''),(1740,'21','226',NULL,2,'Reception corrector for bridging 154',0.00,0.00,0.00,29870.00,0.00,'2022-07-01 15:18:48','',''),(1741,'21','226','3',2,'Received from bridging 154',0.00,0.00,29870.00,0.00,0.00,'2022-07-01 15:18:48','',''),(1742,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:5',2425500.00,0.00,0.00,14700.00,0.00,'2022-07-01 15:23:24','',''),(1743,'21','226','1',1,'Sale Id shift 114',0.00,0.00,0.00,3775.81,0.00,'2022-07-01 15:44:33','',''),(1744,'21','226','2',1,'Sale Id shift 114',0.00,0.00,0.00,2548.49,0.00,'2022-07-01 15:44:33','',''),(1745,'21','226','2',1,'Sale Id shift 114',0.00,0.00,0.00,2938.28,0.00,'2022-07-01 15:44:33','',''),(1746,'21','226','2',1,'Sale Id shift 114',0.00,0.00,0.00,2541.30,0.00,'2022-07-01 15:44:33','',''),(1747,'21','226','1',1,'Sale Id shift 114',0.00,0.00,0.00,3473.60,0.00,'2022-07-01 15:44:33','',''),(1748,'21','226','2',1,'Sale Id shift 114',0.00,0.00,0.00,2919.12,0.00,'2022-07-01 15:44:33','',''),(1749,'21','226','3',2,'Sale Id shift 114',0.00,0.00,0.00,502.21,0.00,'2022-07-01 15:44:33','',''),(1750,'21','226','3',2,'Sale Id shift 114',0.00,0.00,0.00,2554.91,0.00,'2022-07-01 15:44:33','',''),(1751,'21','226','1',1,'Sale Id shift 114',0.00,0.00,0.00,3846.21,0.00,'2022-07-01 15:44:33','',''),(1752,'21','226','1',1,'Sale Id shift 114',0.00,0.00,0.00,3877.24,0.00,'2022-07-01 15:44:33','',''),(1753,'21','226',NULL,1,'Sale Id shift 114',4276808.25,0.00,0.00,0.00,0.00,'2022-07-01 15:44:33','',''),(1754,'21','226',NULL,2,'Sale Id shift 114',2537409.60,0.00,0.00,0.00,0.00,'2022-07-01 15:44:33','',''),(1755,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-07-01 15:45:52','',''),(1756,'21','226',NULL,1,'Reception corrector for bridging 155',0.00,0.00,0.00,15000.00,0.00,'2022-07-01 15:46:37','',''),(1757,'21','226','1',1,'Received from bridging 155',0.00,0.00,15000.00,0.00,0.00,'2022-07-01 15:46:37','',''),(1758,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4455000.00,27000.00,0.00,0.00,'2022-07-01 15:47:51','',''),(1759,'21','226',NULL,1,'Reception corrector for bridging 156',0.00,0.00,0.00,27000.00,0.00,'2022-07-01 15:48:25','',''),(1760,'21','226','1',1,'Received from bridging 156',0.00,0.00,27000.00,0.00,0.00,'2022-07-01 15:48:25','',''),(1761,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-01 15:49:39','',''),(1762,'21','226',NULL,1,'Reception corrector for bridging 157',0.00,0.00,0.00,26000.00,0.00,'2022-07-01 15:50:25','',''),(1763,'21','226','1',1,'Received from bridging 157',0.00,0.00,26000.00,0.00,0.00,'2022-07-01 15:50:25','',''),(1764,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,22410000.00,27000.00,0.00,0.00,'2022-07-01 15:51:31','',''),(1765,'21','226','1',1,'Sale Id shift 115',0.00,0.00,0.00,3868.37,0.00,'2022-07-01 16:05:27','',''),(1766,'21','226','2',1,'Sale Id shift 115',0.00,0.00,0.00,217.02,0.00,'2022-07-01 16:05:27','',''),(1767,'21','226','1',1,'Sale Id shift 115',0.00,0.00,0.00,3339.46,0.00,'2022-07-01 16:05:27','',''),(1768,'21','226','2',1,'Sale Id shift 115',0.00,0.00,0.00,147.59,0.00,'2022-07-01 16:05:27','',''),(1769,'21','226','2',1,'Sale Id shift 115',0.00,0.00,0.00,1764.27,0.00,'2022-07-01 16:05:27','',''),(1770,'21','226','2',1,'Sale Id shift 115',0.00,0.00,0.00,2016.02,0.00,'2022-07-01 16:05:27','',''),(1771,'21','226','2',1,'Sale Id shift 115',0.00,0.00,0.00,1867.36,0.00,'2022-07-01 16:05:27','',''),(1772,'21','226','2',1,'Sale Id shift 115',0.00,0.00,0.00,1942.38,0.00,'2022-07-01 16:05:27','',''),(1773,'21','226','3',2,'Sale Id shift 115',0.00,0.00,0.00,403.54,0.00,'2022-07-01 16:05:27','',''),(1774,'21','226','3',2,'Sale Id shift 115',0.00,0.00,0.00,2624.95,0.00,'2022-07-01 16:05:27','',''),(1775,'21','226','1',1,'Sale Id shift 115',0.00,0.00,0.00,3799.31,0.00,'2022-07-01 16:05:27','',''),(1776,'21','226','1',1,'Sale Id shift 115',0.00,0.00,0.00,4064.35,0.00,'2022-07-01 16:05:27','',''),(1777,'21','226',NULL,1,'Sale Id shift 115',3799311.45,0.00,0.00,0.00,0.00,'2022-07-01 16:05:27','',''),(1778,'21','226',NULL,2,'Sale Id shift 115',2513646.70,0.00,0.00,0.00,0.00,'2022-07-01 16:05:27','',''),(1779,'21','226','1',1,'Sale Id shift 116',0.00,0.00,0.00,6510.05,0.00,'2022-07-01 16:18:34','',''),(1780,'21','226','1',1,'Sale Id shift 116',0.00,0.00,0.00,6781.14,0.00,'2022-07-01 16:18:34','',''),(1781,'21','226','3',2,'Sale Id shift 116',0.00,0.00,0.00,586.33,0.00,'2022-07-01 16:18:34','',''),(1782,'21','226','3',2,'Sale Id shift 116',0.00,0.00,0.00,3265.17,0.00,'2022-07-01 16:18:34','',''),(1783,'21','226','1',1,'Sale Id shift 116',0.00,0.00,0.00,6584.76,0.00,'2022-07-01 16:18:34','',''),(1784,'21','226','1',1,'Sale Id shift 116',0.00,0.00,0.00,6825.50,0.00,'2022-07-01 16:18:34','',''),(1785,'21','226',NULL,1,'Sale Id shift 116',4405739.25,0.00,0.00,0.00,0.00,'2022-07-01 16:18:34','',''),(1786,'21','226',NULL,2,'Sale Id shift 116',3196745.00,0.00,0.00,0.00,0.00,'2022-07-01 16:18:34','',''),(1787,'21','226','3',2,'Sale Id shift 117',0.00,0.00,0.00,2081.64,0.00,'2022-07-01 16:24:28','',''),(1788,'21','226','3',2,'Sale Id shift 117',0.00,0.00,0.00,2166.46,0.00,'2022-07-01 16:24:28','',''),(1789,'21','226',NULL,2,'Sale Id shift 117',3525923.00,0.00,0.00,0.00,0.00,'2022-07-01 16:24:28','',''),(1790,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-07-02 16:16:20','',''),(1791,'21','226',NULL,1,'Reception corrector for bridging 158',0.00,0.00,0.00,15000.00,0.00,'2022-07-02 16:17:10','',''),(1792,'21','226','1',1,'Received from bridging 158',0.00,0.00,15000.00,0.00,0.00,'2022-07-02 16:17:10','',''),(1793,'21','226',NULL,1,'Reception corrector for bridging 159',0.00,0.00,0.00,14000.00,0.00,'2022-07-02 16:18:27','',''),(1794,'21','226','1',1,'Received from bridging 159',0.00,0.00,14000.00,0.00,0.00,'2022-07-02 16:18:27','',''),(1795,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:6',2310000.00,0.00,0.00,14000.00,0.00,'2022-07-02 16:18:30','',''),(1796,'21','226','1',1,'Sale Id shift 118',0.00,0.00,0.00,5993.58,0.00,'2022-07-02 16:32:27','',''),(1797,'21','226','1',1,'Sale Id shift 118',0.00,0.00,0.00,5828.08,0.00,'2022-07-02 16:32:27','',''),(1798,'21','226','3',2,'Sale Id shift 118',0.00,0.00,0.00,364.67,0.00,'2022-07-02 16:32:27','',''),(1799,'21','226','3',2,'Sale Id shift 118',0.00,0.00,0.00,499.39,0.00,'2022-07-02 16:32:27','',''),(1800,'21','226','1',1,'Sale Id shift 118',0.00,0.00,0.00,6218.67,0.00,'2022-07-02 16:32:27','',''),(1801,'21','226','1',1,'Sale Id shift 118',0.00,0.00,0.00,6944.86,0.00,'2022-07-02 16:32:27','',''),(1802,'21','226',NULL,1,'Sale Id shift 118',4122556.35,0.00,0.00,0.00,0.00,'2022-07-02 16:32:27','',''),(1803,'21','226',NULL,2,'Sale Id shift 118',717169.80,0.00,0.00,0.00,0.00,'2022-07-02 16:32:27','',''),(1804,'21','226',NULL,2,'Reception corrector for bridging 160',0.00,0.00,0.00,27000.00,0.00,'2022-07-02 16:37:31','',''),(1805,'21','226','3',2,'Received from bridging 160',0.00,0.00,27000.00,0.00,0.00,'2022-07-02 16:37:31','',''),(1806,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4620000.00,28000.00,0.00,0.00,'2022-07-08 12:00:27','',''),(1807,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-07-08 12:12:21','',''),(1808,'21','226',NULL,1,'Reception corrector for bridging 162',0.00,0.00,0.00,30000.00,0.00,'2022-07-08 13:07:20','',''),(1809,'21','226','1',1,'Received from bridging 162',0.00,0.00,30000.00,0.00,0.00,'2022-07-08 13:07:20','',''),(1810,'21','226',NULL,1,'Reception corrector for bridging 161',0.00,0.00,0.00,28000.00,0.00,'2022-07-08 13:07:45','',''),(1811,'21','226','2',1,'Received from bridging 161',0.00,0.00,28000.00,0.00,0.00,'2022-07-08 13:07:45','',''),(1812,'21','226','3',2,'Sale Id shift 119',0.00,0.00,0.00,454.25,0.00,'2022-07-08 13:09:46','',''),(1813,'21','226','3',2,'Sale Id shift 119',0.00,0.00,0.00,1843.15,0.00,'2022-07-08 13:09:46','',''),(1814,'21','226','1',1,'Sale Id shift 119',0.00,0.00,0.00,46.03,0.00,'2022-07-08 13:09:46','',''),(1815,'21','226','1',1,'Sale Id shift 119',0.00,0.00,0.00,261.06,0.00,'2022-07-08 13:09:46','',''),(1816,'21','226','1',1,'Sale Id shift 119',0.00,0.00,0.00,335.91,0.00,'2022-07-08 13:09:46','',''),(1817,'21','226',NULL,1,'Sale Id shift 119',106095.00,0.00,0.00,0.00,0.00,'2022-07-08 13:09:46','',''),(1818,'21','226',NULL,2,'Sale Id shift 119',1906842.00,0.00,0.00,0.00,0.00,'2022-07-08 13:09:46','',''),(1819,'21','226','1',1,'Sale Id shift 120',0.00,0.00,0.00,3741.13,0.00,'2022-07-13 14:52:22','',''),(1820,'21','226','1',1,'Sale Id shift 120',0.00,0.00,0.00,3403.59,0.00,'2022-07-13 14:52:22','',''),(1821,'21','226','3',2,'Sale Id shift 120',0.00,0.00,0.00,1113.80,0.00,'2022-07-13 14:52:22','',''),(1822,'21','226','3',2,'Sale Id shift 120',0.00,0.00,0.00,1580.49,0.00,'2022-07-13 14:52:22','',''),(1823,'21','226','1',1,'Sale Id shift 120',0.00,0.00,0.00,3124.79,0.00,'2022-07-13 14:52:22','',''),(1824,'21','226','1',1,'Sale Id shift 120',0.00,0.00,0.00,3812.19,0.00,'2022-07-13 14:52:22','',''),(1825,'21','226',NULL,1,'Sale Id shift 120',2323480.50,0.00,0.00,0.00,0.00,'2022-07-13 14:52:22','',''),(1826,'21','226',NULL,2,'Sale Id shift 120',2236260.70,0.00,0.00,0.00,0.00,'2022-07-13 14:52:22','',''),(1827,'21','226','3',2,'Sale Id shift 121',0.00,0.00,0.00,1770.34,0.00,'2022-07-13 15:03:20','',''),(1828,'21','226','3',2,'Sale Id shift 121',0.00,0.00,0.00,1959.36,0.00,'2022-07-13 15:03:20','',''),(1829,'21','226',NULL,2,'Sale Id shift 121',3095651.00,0.00,0.00,0.00,0.00,'2022-07-13 15:03:20','',''),(1830,'21','226','3',2,'Sale Id shift 122',0.00,0.00,0.00,442.63,0.00,'2022-07-13 15:35:31','',''),(1831,'21','226','3',2,'Sale Id shift 122',0.00,0.00,0.00,1390.81,0.00,'2022-07-13 15:35:31','',''),(1832,'21','226','1',1,'Sale Id shift 122',0.00,0.00,0.00,139.52,0.00,'2022-07-13 15:35:31','',''),(1833,'21','226','1',1,'Sale Id shift 122',0.00,0.00,0.00,338.94,0.00,'2022-07-13 15:35:31','',''),(1834,'21','226','1',1,'Sale Id shift 122',0.00,0.00,0.00,79.05,0.00,'2022-07-13 15:35:31','',''),(1835,'21','226',NULL,1,'Sale Id shift 122',91989.15,0.00,0.00,0.00,0.00,'2022-07-13 15:35:31','',''),(1836,'21','226',NULL,2,'Sale Id shift 122',1521755.20,0.00,0.00,0.00,0.00,'2022-07-13 15:35:31','',''),(1837,'21','226','3',2,'Sale Id shift 123',0.00,0.00,0.00,1488.74,0.00,'2022-07-13 15:49:34','',''),(1838,'21','226','3',2,'Sale Id shift 123',0.00,0.00,0.00,1624.09,0.00,'2022-07-13 15:49:34','',''),(1839,'21','226',NULL,2,'Sale Id shift 123',2583648.90,0.00,0.00,0.00,0.00,'2022-07-13 15:49:34','',''),(1840,'21','226','2',1,'Distributed to AHF NIGERIA  for sales id:7',2640000.00,0.00,0.00,16000.00,0.00,'2022-07-13 16:06:24','',''),(1841,'21','226','2',1,'Sale Id shift 124',0.00,0.00,0.00,2388.35,0.00,'2022-07-13 16:07:17','',''),(1842,'21','226','2',1,'Sale Id shift 124',0.00,0.00,0.00,2331.50,0.00,'2022-07-13 16:07:17','',''),(1843,'21','226','2',1,'Sale Id shift 124',0.00,0.00,0.00,2717.25,0.00,'2022-07-13 16:07:17','',''),(1844,'21','226','2',1,'Sale Id shift 124',0.00,0.00,0.00,2657.97,0.00,'2022-07-13 16:07:17','',''),(1845,'21','226','3',2,'Sale Id shift 124',0.00,0.00,0.00,2123.64,0.00,'2022-07-13 16:07:17','',''),(1846,'21','226','3',2,'Sale Id shift 124',0.00,0.00,0.00,754.00,0.00,'2022-07-13 16:07:17','',''),(1847,'21','226','1',1,'Sale Id shift 124',0.00,0.00,0.00,1418.96,0.00,'2022-07-13 16:07:17','',''),(1848,'21','226',NULL,1,'Sale Id shift 124',1899814.95,0.00,0.00,0.00,0.00,'2022-07-13 16:07:17','',''),(1849,'21','226',NULL,2,'Sale Id shift 124',2388441.20,0.00,0.00,0.00,0.00,'2022-07-13 16:07:17','',''),(1850,'21','226','2',1,'Sale Id shift 125',0.00,0.00,0.00,16.89,0.00,'2022-07-13 16:44:01','',''),(1851,'21','226','2',1,'Sale Id shift 125',0.00,0.00,0.00,133.45,0.00,'2022-07-13 16:44:01','',''),(1852,'21','226','2',1,'Sale Id shift 125',0.00,0.00,0.00,361.85,0.00,'2022-07-13 16:44:01','',''),(1853,'21','226','2',1,'Sale Id shift 125',0.00,0.00,0.00,930.19,0.00,'2022-07-13 16:44:01','',''),(1854,'21','226','2',1,'Sale Id shift 125',0.00,0.00,0.00,21.22,0.00,'2022-07-13 16:44:01','',''),(1855,'21','226','3',2,'Sale Id shift 125',0.00,0.00,0.00,7165.24,0.00,'2022-07-13 16:44:01','',''),(1856,'21','226','3',2,'Sale Id shift 125',0.00,0.00,0.00,576.83,0.00,'2022-07-13 16:44:01','',''),(1857,'21','226',NULL,1,'Sale Id shift 125',241494.00,0.00,0.00,0.00,0.00,'2022-07-13 16:44:01','',''),(1858,'21','226',NULL,2,'Sale Id shift 125',6425918.10,0.00,0.00,0.00,0.00,'2022-07-13 16:44:01','',''),(1859,'21','226','1',1,'Sale Id shift 126',0.00,0.00,0.00,1789.13,0.00,'2022-07-13 17:21:39','',''),(1860,'21','226','2',1,'Sale Id shift 126',0.00,0.00,0.00,145.46,0.00,'2022-07-13 17:21:39','',''),(1861,'21','226','1',1,'Sale Id shift 126',0.00,0.00,0.00,1275.99,0.00,'2022-07-13 17:21:39','',''),(1862,'21','226','2',1,'Sale Id shift 126',0.00,0.00,0.00,409.22,0.00,'2022-07-13 17:21:39','',''),(1863,'21','226','3',2,'Sale Id shift 126',0.00,0.00,0.00,1798.41,0.00,'2022-07-13 17:21:39','',''),(1864,'21','226','3',2,'Sale Id shift 126',0.00,0.00,0.00,648.82,0.00,'2022-07-13 17:21:39','',''),(1865,'21','226','1',1,'Sale Id shift 126',0.00,0.00,0.00,1800.30,0.00,'2022-07-13 17:21:39','',''),(1866,'21','226','1',1,'Sale Id shift 126',0.00,0.00,0.00,1957.18,0.00,'2022-07-13 17:21:39','',''),(1867,'21','226',NULL,1,'Sale Id shift 126',1217251.20,0.00,0.00,0.00,0.00,'2022-07-13 17:21:39','',''),(1868,'21','226',NULL,2,'Sale Id shift 126',2031200.90,0.00,0.00,0.00,0.00,'2022-07-13 17:21:39','',''),(1869,'21','226','3',2,'Sale Id shift 127',0.00,0.00,0.00,951.00,0.00,'2022-07-14 09:03:55','',''),(1870,'21','226','3',2,'Sale Id shift 127',0.00,0.00,0.00,467.26,0.00,'2022-07-14 09:03:55','',''),(1871,'21','226',NULL,2,'Sale Id shift 127',1177155.80,0.00,0.00,0.00,0.00,'2022-07-14 09:03:55','',''),(1872,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-07-14 09:10:24','',''),(1873,'21','226',NULL,1,'Reception corrector for bridging 163',0.00,0.00,0.00,15000.00,0.00,'2022-07-14 09:11:07','',''),(1874,'21','226','1',1,'Received from bridging 163',0.00,0.00,15000.00,0.00,0.00,'2022-07-14 09:11:07','',''),(1875,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-14 09:31:43','',''),(1876,'21','226',NULL,1,'Reception corrector for bridging 165',0.00,0.00,0.00,15000.00,0.00,'2022-07-14 09:32:45','',''),(1877,'21','226','2',1,'Received from bridging 165',0.00,0.00,15000.00,0.00,0.00,'2022-07-14 09:32:45','',''),(1878,'21','226',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,30000.00,0.00,'2022-07-14 09:32:45','',''),(1879,'21','226','1',1,'Received from bridging 164',0.00,0.00,30000.00,0.00,0.00,'2022-07-14 09:32:45','',''),(1880,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-07-14 09:33:39','',''),(1881,'21','226',NULL,1,'Reception corrector for bridging 167',0.00,0.00,0.00,15000.00,0.00,'2022-07-14 09:34:32','',''),(1882,'21','226','2',1,'Received from bridging 167',0.00,0.00,15000.00,0.00,0.00,'2022-07-14 09:34:32','',''),(1883,'21','226',NULL,1,'Reception corrector for bridging 166',0.00,0.00,0.00,15000.00,0.00,'2022-07-14 09:34:32','',''),(1884,'21','226','1',1,'Received from bridging 166',0.00,0.00,15000.00,0.00,0.00,'2022-07-14 09:34:32','',''),(1885,'21','226','1',1,'Sale Id shift 128',0.00,0.00,0.00,7413.84,0.00,'2022-07-14 09:35:08','',''),(1886,'21','226','1',1,'Sale Id shift 128',0.00,0.00,0.00,6426.12,0.00,'2022-07-14 09:35:08','',''),(1887,'21','226','3',2,'Sale Id shift 128',0.00,0.00,0.00,822.70,0.00,'2022-07-14 09:35:08','',''),(1888,'21','226','3',2,'Sale Id shift 128',0.00,0.00,0.00,1037.65,0.00,'2022-07-14 09:35:08','',''),(1889,'21','226','1',1,'Sale Id shift 128',0.00,0.00,0.00,147.27,0.00,'2022-07-14 09:35:08','',''),(1890,'21','226','1',1,'Sale Id shift 128',0.00,0.00,0.00,0.15,0.00,'2022-07-14 09:35:08','',''),(1891,'21','226','1',1,'Sale Id shift 128',0.00,0.00,0.00,7815.78,0.00,'2022-07-14 09:35:08','',''),(1892,'21','226','1',1,'Sale Id shift 128',0.00,0.00,0.00,8416.17,0.00,'2022-07-14 09:35:08','',''),(1893,'21','226',NULL,1,'Sale Id shift 128',5590576.05,0.00,0.00,0.00,0.00,'2022-07-14 09:35:08','',''),(1894,'21','226',NULL,2,'Sale Id shift 128',1544090.50,0.00,0.00,0.00,0.00,'2022-07-14 09:35:08','',''),(1895,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-14 09:35:33','',''),(1896,'21','226',NULL,1,'Reception corrector for bridging 168',0.00,0.00,0.00,30000.00,0.00,'2022-07-14 09:49:23','',''),(1897,'21','226','1',1,'Received from bridging 168',0.00,0.00,30000.00,0.00,0.00,'2022-07-14 09:49:23','',''),(1898,'21','226','1',1,'Sale Id shift 129',0.00,0.00,0.00,6960.72,0.00,'2022-07-14 09:56:46','',''),(1899,'21','226','2',1,'Sale Id shift 129',0.00,0.00,0.00,1985.58,0.00,'2022-07-14 09:56:46','',''),(1900,'21','226','2',1,'Sale Id shift 129',0.00,0.00,0.00,1714.70,0.00,'2022-07-14 09:56:46','',''),(1901,'21','226','2',1,'Sale Id shift 129',0.00,0.00,0.00,2293.55,0.00,'2022-07-14 09:56:46','',''),(1902,'21','226','1',1,'Sale Id shift 129',0.00,0.00,0.00,5631.05,0.00,'2022-07-14 09:56:46','',''),(1903,'21','226','2',1,'Sale Id shift 129',0.00,0.00,0.00,1655.23,0.00,'2022-07-14 09:56:46','',''),(1904,'21','226','2',1,'Sale Id shift 129',0.00,0.00,0.00,1581.24,0.00,'2022-07-14 09:56:46','',''),(1905,'21','226','2',1,'Sale Id shift 129',0.00,0.00,0.00,2036.33,0.00,'2022-07-14 09:56:46','',''),(1906,'21','226','2',1,'Sale Id shift 129',0.00,0.00,0.00,2029.59,0.00,'2022-07-14 09:56:46','',''),(1907,'21','226','2',1,'Sale Id shift 129',0.00,0.00,0.00,1869.47,0.00,'2022-07-14 09:56:46','',''),(1908,'21','226','3',2,'Sale Id shift 129',0.00,0.00,0.00,1467.12,0.00,'2022-07-14 09:56:46','',''),(1909,'21','226','3',2,'Sale Id shift 129',0.00,0.00,0.00,211.83,0.00,'2022-07-14 09:56:46','',''),(1910,'21','226','1',1,'Sale Id shift 129',0.00,0.00,0.00,5450.93,0.00,'2022-07-14 09:56:46','',''),(1911,'21','226','1',1,'Sale Id shift 129',0.00,0.00,0.00,6466.60,0.00,'2022-07-14 09:56:46','',''),(1912,'21','226','1',1,'Sale Id shift 129',0.00,0.00,0.00,6030.53,0.00,'2022-07-14 09:56:46','',''),(1913,'21','226','1',1,'Sale Id shift 129',0.00,0.00,0.00,4172.31,0.00,'2022-07-14 09:56:46','',''),(1914,'21','226',NULL,1,'Sale Id shift 129',9227398.55,0.00,0.00,0.00,0.00,'2022-07-14 09:56:46','',''),(1915,'21','226',NULL,2,'Sale Id shift 129',1393528.50,0.00,0.00,0.00,0.00,'2022-07-14 09:56:46','',''),(1916,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8297250.00,44850.00,0.00,0.00,'2022-07-14 10:00:11','',''),(1917,'21','226',NULL,1,'Reception corrector for bridging 171',0.00,0.00,0.00,17000.00,0.00,'2022-07-14 10:01:33','',''),(1918,'21','226','2',1,'Received from bridging 171',0.00,0.00,17000.00,0.00,0.00,'2022-07-14 10:01:33','',''),(1919,'21','226',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,27850.00,0.00,'2022-07-14 10:01:33','',''),(1920,'21','226','1',1,'Received from bridging 170',0.00,0.00,27850.00,0.00,0.00,'2022-07-14 10:01:33','',''),(1921,'21','226','2',1,'Sale Id shift 130',0.00,0.00,0.00,3704.54,0.00,'2022-07-14 10:09:53','',''),(1922,'21','226','2',1,'Sale Id shift 130',0.00,0.00,0.00,4131.00,0.00,'2022-07-14 10:09:53','',''),(1923,'21','226','2',1,'Sale Id shift 130',0.00,0.00,0.00,3665.61,0.00,'2022-07-14 10:09:53','',''),(1924,'21','226','2',1,'Sale Id shift 130',0.00,0.00,0.00,3611.53,0.00,'2022-07-14 10:09:53','',''),(1925,'21','226','3',2,'Sale Id shift 130',0.00,0.00,0.00,427.34,0.00,'2022-07-14 10:09:53','',''),(1926,'21','226','3',2,'Sale Id shift 130',0.00,0.00,0.00,954.47,0.00,'2022-07-14 10:09:53','',''),(1927,'21','226','1',1,'Sale Id shift 130',0.00,0.00,0.00,4859.90,0.00,'2022-07-14 10:09:53','',''),(1928,'21','226','1',1,'Sale Id shift 130',0.00,0.00,0.00,5319.00,0.00,'2022-07-14 10:09:53','',''),(1929,'21','226','1',1,'Sale Id shift 130',0.00,0.00,0.00,4822.34,0.00,'2022-07-14 10:09:53','',''),(1930,'21','226','1',1,'Sale Id shift 130',0.00,0.00,0.00,3667.58,0.00,'2022-07-14 10:09:53','',''),(1931,'21','226',NULL,2,'Sale Id shift 130',1146902.30,0.00,0.00,0.00,0.00,'2022-07-14 10:09:53','',''),(1932,'21','226',NULL,1,'Sale Id shift 130',6249577.50,0.00,0.00,0.00,0.00,'2022-07-14 10:09:53','',''),(1933,'21','226',NULL,1,'Reception corrector for bridging 169',0.00,0.00,0.00,15000.00,0.00,'2022-07-14 10:10:36','',''),(1934,'21','226','2',1,'Received from bridging 169',0.00,0.00,15000.00,0.00,0.00,'2022-07-14 10:10:36','',''),(1935,'21','226','1',1,'Sale Id shift 131',0.00,0.00,0.00,5982.14,0.00,'2022-07-14 10:36:25','',''),(1936,'21','226','2',1,'Sale Id shift 131',0.00,0.00,0.00,2226.13,0.00,'2022-07-14 10:36:25','',''),(1937,'21','226','2',1,'Sale Id shift 131',0.00,0.00,0.00,2212.89,0.00,'2022-07-14 10:36:25','',''),(1938,'21','226','2',1,'Sale Id shift 131',0.00,0.00,0.00,1890.49,0.00,'2022-07-14 10:36:25','',''),(1939,'21','226','1',1,'Sale Id shift 131',0.00,0.00,0.00,4859.76,0.00,'2022-07-14 10:36:25','',''),(1940,'21','226','2',1,'Sale Id shift 131',0.00,0.00,0.00,1191.42,0.00,'2022-07-14 10:36:25','',''),(1941,'21','226','2',1,'Sale Id shift 131',0.00,0.00,0.00,871.33,0.00,'2022-07-14 10:36:25','',''),(1942,'21','226','2',1,'Sale Id shift 131',0.00,0.00,0.00,2109.29,0.00,'2022-07-14 10:36:25','',''),(1943,'21','226','2',1,'Sale Id shift 131',0.00,0.00,0.00,2209.54,0.00,'2022-07-14 10:36:25','',''),(1944,'21','226','2',1,'Sale Id shift 131',0.00,0.00,0.00,2329.38,0.00,'2022-07-14 10:36:25','',''),(1945,'21','226','3',2,'Sale Id shift 131',0.00,0.00,0.00,2161.26,0.00,'2022-07-14 10:36:25','',''),(1946,'21','226','3',2,'Sale Id shift 131',0.00,0.00,0.00,390.40,0.00,'2022-07-14 10:36:25','',''),(1947,'21','226','1',1,'Sale Id shift 131',0.00,0.00,0.00,4097.99,0.00,'2022-07-14 10:36:25','',''),(1948,'21','226','1',1,'Sale Id shift 131',0.00,0.00,0.00,5778.21,0.00,'2022-07-14 10:36:25','',''),(1949,'21','226','1',1,'Sale Id shift 131',0.00,0.00,0.00,4969.40,0.00,'2022-07-14 10:36:25','',''),(1950,'21','226','1',1,'Sale Id shift 131',0.00,0.00,0.00,4287.92,0.00,'2022-07-14 10:36:25','',''),(1951,'21','226',NULL,1,'Sale Id shift 131',8327939.65,0.00,0.00,0.00,0.00,'2022-07-14 10:36:25','',''),(1952,'21','226',NULL,2,'Sale Id shift 131',2117877.80,0.00,0.00,0.00,0.00,'2022-07-14 10:36:25','',''),(1953,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-19 09:05:37','',''),(1954,'21','226',NULL,1,'Reception corrector for bridging 173',0.00,0.00,0.00,14500.00,0.00,'2022-07-20 15:59:32','',''),(1955,'21','226','2',1,'Received from bridging 173',0.00,0.00,14500.00,0.00,0.00,'2022-07-20 15:59:32','',''),(1956,'21','226',NULL,1,'Reception corrector for bridging 172',0.00,0.00,0.00,30500.00,0.00,'2022-07-20 15:59:32','',''),(1957,'21','226','1',1,'Received from bridging 172',0.00,0.00,30500.00,0.00,0.00,'2022-07-20 15:59:32','',''),(1958,'21','226','1',1,'Sale Id shift 132',0.00,0.00,0.00,5448.08,0.00,'2022-07-20 16:48:10','',''),(1959,'21','226','2',1,'Sale Id shift 132',0.00,0.00,0.00,2156.94,0.00,'2022-07-20 16:48:10','',''),(1960,'21','226','2',1,'Sale Id shift 132',0.00,0.00,0.00,2197.01,0.00,'2022-07-20 16:48:10','',''),(1961,'21','226','2',1,'Sale Id shift 132',0.00,0.00,0.00,1773.34,0.00,'2022-07-20 16:48:10','',''),(1962,'21','226','1',1,'Sale Id shift 132',0.00,0.00,0.00,4233.46,0.00,'2022-07-20 16:48:10','',''),(1963,'21','226','2',1,'Sale Id shift 132',0.00,0.00,0.00,2038.97,0.00,'2022-07-20 16:48:10','',''),(1964,'21','226','2',1,'Sale Id shift 132',0.00,0.00,0.00,1884.60,0.00,'2022-07-20 16:48:10','',''),(1965,'21','226','2',1,'Sale Id shift 132',0.00,0.00,0.00,2909.02,0.00,'2022-07-20 16:48:10','',''),(1966,'21','226','2',1,'Sale Id shift 132',0.00,0.00,0.00,2055.41,0.00,'2022-07-20 16:48:10','',''),(1967,'21','226','2',1,'Sale Id shift 132',0.00,0.00,0.00,2097.83,0.00,'2022-07-20 16:48:10','',''),(1968,'21','226','3',2,'Sale Id shift 132',0.00,0.00,0.00,2258.32,0.00,'2022-07-20 16:48:10','',''),(1969,'21','226','3',2,'Sale Id shift 132',0.00,0.00,0.00,848.25,0.00,'2022-07-20 16:48:10','',''),(1970,'21','226','1',1,'Sale Id shift 132',0.00,0.00,0.00,2042.43,0.00,'2022-07-20 16:48:10','',''),(1971,'21','226','1',1,'Sale Id shift 132',0.00,0.00,0.00,1075.22,0.00,'2022-07-20 16:48:10','',''),(1972,'21','226','1',1,'Sale Id shift 132',0.00,0.00,0.00,2988.20,0.00,'2022-07-20 16:48:10','',''),(1973,'21','226','1',1,'Sale Id shift 132',0.00,0.00,0.00,3560.18,0.00,'2022-07-20 16:48:10','',''),(1974,'21','226','1',1,'Sale Id shift 132',0.00,0.00,0.00,3181.43,0.00,'2022-07-20 16:48:10','',''),(1975,'21','226','1',1,'Sale Id shift 132',0.00,0.00,0.00,2052.55,0.00,'2022-07-20 16:48:10','',''),(1976,'21','226',NULL,1,'Sale Id shift 132',7713513.95,0.00,0.00,0.00,0.00,'2022-07-20 16:48:10','',''),(1977,'21','226',NULL,2,'Sale Id shift 132',2578453.10,0.00,0.00,0.00,0.00,'2022-07-20 16:48:10','',''),(1978,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-20 17:20:34','',''),(1979,'21','226',NULL,1,'Reception corrector for bridging 175',0.00,0.00,0.00,15000.00,0.00,'2022-07-20 17:21:34','',''),(1980,'21','226','2',1,'Received from bridging 175',0.00,0.00,15000.00,0.00,0.00,'2022-07-20 17:21:34','',''),(1981,'21','226',NULL,1,'Reception corrector for bridging 174',0.00,0.00,0.00,30000.00,0.00,'2022-07-20 17:21:34','',''),(1982,'21','226','1',1,'Received from bridging 174',0.00,0.00,30000.00,0.00,0.00,'2022-07-20 17:21:34','',''),(1983,'21','226','2',1,'Sale Id shift 133',0.00,0.00,0.00,1729.79,0.00,'2022-07-20 17:26:07','',''),(1984,'21','226','2',1,'Sale Id shift 133',0.00,0.00,0.00,2099.33,0.00,'2022-07-20 17:26:07','',''),(1985,'21','226','2',1,'Sale Id shift 133',0.00,0.00,0.00,2157.88,0.00,'2022-07-20 17:26:07','',''),(1986,'21','226','2',1,'Sale Id shift 133',0.00,0.00,0.00,2334.14,0.00,'2022-07-20 17:26:07','',''),(1987,'21','226','2',1,'Sale Id shift 133',0.00,0.00,0.00,1025.58,0.00,'2022-07-20 17:26:07','',''),(1988,'21','226','2',1,'Sale Id shift 133',0.00,0.00,0.00,1386.43,0.00,'2022-07-20 17:26:07','',''),(1989,'21','226','2',1,'Sale Id shift 133',0.00,0.00,0.00,1724.94,0.00,'2022-07-20 17:26:07','',''),(1990,'21','226','2',1,'Sale Id shift 133',0.00,0.00,0.00,2487.44,0.00,'2022-07-20 17:26:07','',''),(1991,'21','226','3',2,'Sale Id shift 133',0.00,0.00,0.00,1876.40,0.00,'2022-07-20 17:26:07','',''),(1992,'21','226','3',2,'Sale Id shift 133',0.00,0.00,0.00,1179.54,0.00,'2022-07-20 17:26:07','',''),(1993,'21','226','1',1,'Sale Id shift 133',0.00,0.00,0.00,4928.18,0.00,'2022-07-20 17:26:07','',''),(1994,'21','226','1',1,'Sale Id shift 133',0.00,0.00,0.00,4150.94,0.00,'2022-07-20 17:26:07','',''),(1995,'21','226','1',1,'Sale Id shift 133',0.00,0.00,0.00,4181.52,0.00,'2022-07-20 17:26:07','',''),(1996,'21','226','1',1,'Sale Id shift 133',0.00,0.00,0.00,4111.45,0.00,'2022-07-20 17:26:07','',''),(1997,'21','226',NULL,1,'Sale Id shift 133',5978759.70,0.00,0.00,0.00,0.00,'2022-07-20 17:26:07','',''),(1998,'21','226',NULL,2,'Sale Id shift 133',2536430.20,0.00,0.00,0.00,0.00,'2022-07-20 17:26:07','',''),(1999,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10790000.00,13000.00,0.00,0.00,'2022-07-20 17:51:10','',''),(2000,'21','226',NULL,2,'Reception corrector for bridging 176',0.00,0.00,0.00,13000.00,0.00,'2022-07-20 17:52:10','',''),(2001,'21','226','3',2,'Received from bridging 176',0.00,0.00,13000.00,0.00,0.00,'2022-07-20 17:52:10','',''),(2002,'21','226','1',1,'Sale Id shift 134',0.00,0.00,0.00,724.07,0.00,'2022-07-20 17:55:25','',''),(2003,'21','226','1',1,'Sale Id shift 134',0.00,0.00,0.00,704.28,0.00,'2022-07-20 17:55:25','',''),(2004,'21','226','3',2,'Sale Id shift 134',0.00,0.00,0.00,2327.53,0.00,'2022-07-20 17:55:25','',''),(2005,'21','226','3',2,'Sale Id shift 134',0.00,0.00,0.00,1994.56,0.00,'2022-07-20 17:55:25','',''),(2006,'21','226','1',1,'Sale Id shift 134',0.00,0.00,0.00,2587.67,0.00,'2022-07-20 17:55:25','',''),(2007,'21','226','1',1,'Sale Id shift 134',0.00,0.00,0.00,2261.80,0.00,'2022-07-20 17:55:25','',''),(2008,'21','226','1',1,'Sale Id shift 134',0.00,0.00,0.00,676.69,0.00,'2022-07-20 17:55:25','',''),(2009,'21','226','1',1,'Sale Id shift 134',0.00,0.00,0.00,792.75,0.00,'2022-07-20 17:55:25','',''),(2010,'21','226','1',1,'Sale Id shift 134',0.00,0.00,0.00,2777.86,0.00,'2022-07-20 17:55:25','',''),(2011,'21','226','1',1,'Sale Id shift 134',0.00,0.00,0.00,2770.57,0.00,'2022-07-20 17:55:25','',''),(2012,'21','226',NULL,1,'Sale Id shift 134',2459702.65,0.00,0.00,0.00,0.00,'2022-07-20 17:55:25','',''),(2013,'21','226',NULL,2,'Sale Id shift 134',3587334.70,0.00,0.00,0.00,0.00,'2022-07-20 17:55:25','',''),(2014,'21','226','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,14882.57,0.00,'2022-07-20 18:08:45','',''),(2015,'21','226','2',0,'Inventory adjustment from tank dipping to 15140',0.00,0.00,15140.00,0.00,0.00,'2022-07-20 18:08:45','',''),(2016,'21','226','2',1,'Sale Id shift 135',0.00,0.00,0.00,2891.53,0.00,'2022-07-20 18:11:43','',''),(2017,'21','226','2',1,'Sale Id shift 135',0.00,0.00,0.00,3050.71,0.00,'2022-07-20 18:11:43','',''),(2018,'21','226','2',1,'Sale Id shift 135',0.00,0.00,0.00,1600.55,0.00,'2022-07-20 18:11:43','',''),(2019,'21','226','2',1,'Sale Id shift 135',0.00,0.00,0.00,1968.89,0.00,'2022-07-20 18:11:43','',''),(2020,'21','226','2',1,'Sale Id shift 135',0.00,0.00,0.00,2522.22,0.00,'2022-07-20 18:11:43','',''),(2021,'21','226','2',1,'Sale Id shift 135',0.00,0.00,0.00,3105.64,0.00,'2022-07-20 18:11:43','',''),(2022,'21','226','3',2,'Sale Id shift 135',0.00,0.00,0.00,1522.99,0.00,'2022-07-20 18:11:43','',''),(2023,'21','226','3',2,'Sale Id shift 135',0.00,0.00,0.00,1005.23,0.00,'2022-07-20 18:11:43','',''),(2024,'21','226','1',1,'Sale Id shift 135',0.00,0.00,0.00,4422.04,0.00,'2022-07-20 18:11:43','',''),(2025,'21','226','1',1,'Sale Id shift 135',0.00,0.00,0.00,3743.57,0.00,'2022-07-20 18:11:43','',''),(2026,'21','226','1',1,'Sale Id shift 135',0.00,0.00,0.00,4413.63,0.00,'2022-07-20 18:11:43','',''),(2027,'21','226','1',1,'Sale Id shift 135',0.00,0.00,0.00,3825.68,0.00,'2022-07-20 18:11:43','',''),(2028,'21','226',NULL,2,'Sale Id shift 135',2098422.60,0.00,0.00,0.00,0.00,'2022-07-20 18:11:43','',''),(2029,'21','226',NULL,1,'Sale Id shift 135',5520280.50,0.00,0.00,0.00,0.00,'2022-07-20 18:11:43','',''),(2030,'21','226','3',2,'Sale Id shift 136',0.00,0.00,0.00,1089.35,0.00,'2022-07-20 18:19:25','',''),(2031,'21','226','3',2,'Sale Id shift 136',0.00,0.00,0.00,547.70,0.00,'2022-07-20 18:19:25','',''),(2032,'21','226',NULL,2,'Sale Id shift 136',1358751.50,0.00,0.00,0.00,0.00,'2022-07-20 18:19:25','',''),(2033,'21','226','3',2,'Sale Id shift 137',0.00,0.00,0.00,1071.48,0.00,'2022-07-20 18:32:24','',''),(2034,'21','226','3',2,'Sale Id shift 137',0.00,0.00,0.00,285.17,0.00,'2022-07-20 18:32:24','',''),(2035,'21','226','1',1,'Sale Id shift 137',0.00,0.00,0.00,315.27,0.00,'2022-07-20 18:32:24','',''),(2036,'21','226','1',1,'Sale Id shift 137',0.00,0.00,0.00,42.58,0.00,'2022-07-20 18:32:24','',''),(2037,'21','226',NULL,1,'Sale Id shift 137',64413.00,0.00,0.00,0.00,0.00,'2022-07-20 18:32:24','',''),(2038,'21','226',NULL,2,'Sale Id shift 137',1126019.50,0.00,0.00,0.00,0.00,'2022-07-20 18:32:24','',''),(2039,'21','226','3',2,'Sale Id shift 138',0.00,0.00,0.00,2157.01,0.00,'2022-07-20 18:36:02','',''),(2040,'21','226','3',2,'Sale Id shift 138',0.00,0.00,0.00,611.30,0.00,'2022-07-20 18:36:02','',''),(2041,'21','226',NULL,2,'Sale Id shift 138',2297697.30,0.00,0.00,0.00,0.00,'2022-07-20 18:36:02','',''),(2042,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-07-21 15:06:29','',''),(2043,'21','226',NULL,1,'Reception corrector for bridging 178',0.00,0.00,0.00,15000.00,0.00,'2022-07-21 15:08:21','',''),(2044,'21','226','2',1,'Received from bridging 178',0.00,0.00,15000.00,0.00,0.00,'2022-07-21 15:08:21','',''),(2045,'21','226',NULL,1,'Reception corrector for bridging 177',0.00,0.00,0.00,30000.00,0.00,'2022-07-21 15:08:22','',''),(2046,'21','226','1',1,'Received from bridging 177',0.00,0.00,30000.00,0.00,0.00,'2022-07-21 15:08:22','',''),(2047,'21','226','3',2,'Sale Id shift 139',0.00,0.00,0.00,922.45,0.00,'2022-07-21 16:30:31','',''),(2048,'21','226','3',2,'Sale Id shift 139',0.00,0.00,0.00,105.63,0.00,'2022-07-21 16:30:31','',''),(2049,'21','226','1',1,'Sale Id shift 139',0.00,0.00,0.00,7531.07,0.00,'2022-07-21 16:30:31','',''),(2050,'21','226','1',1,'Sale Id shift 139',0.00,0.00,0.00,8109.29,0.00,'2022-07-21 16:30:31','',''),(2051,'21','226','1',1,'Sale Id shift 139',0.00,0.00,0.00,7400.55,0.00,'2022-07-21 16:30:31','',''),(2052,'21','226','1',1,'Sale Id shift 139',0.00,0.00,0.00,7228.37,0.00,'2022-07-21 16:30:31','',''),(2053,'21','226',NULL,2,'Sale Id shift 139',837885.20,0.00,0.00,0.00,0.00,'2022-07-21 16:30:31','',''),(2054,'21','226',NULL,1,'Sale Id shift 139',5448470.40,0.00,0.00,0.00,0.00,'2022-07-21 16:30:31','',''),(2055,'21','226','2',1,'Distributed to AHF NIGERIA  for sales id:9',2700000.00,0.00,0.00,15000.00,0.00,'2022-07-21 16:36:50','',''),(2056,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:8',2775000.00,0.00,0.00,15000.00,0.00,'2022-07-21 16:39:26','',''),(2057,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,-4301.65,0.00,'2022-07-24 14:00:03','',''),(2058,'21','226','1',0,'Inventory adjustment from tank dipping to 2',0.00,0.00,2.00,0.00,0.00,'2022-07-24 14:00:03','',''),(2059,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,16300000.00,20000.00,0.00,0.00,'2022-07-24 14:07:45','',''),(2060,'21','226',NULL,2,'Reception corrector for bridging 179',0.00,0.00,0.00,20000.00,0.00,'2022-07-24 14:08:41','',''),(2061,'21','226','3',2,'Received from bridging 179',0.00,0.00,20000.00,0.00,0.00,'2022-07-24 14:08:41','',''),(2062,'21','226','3',2,'Sale Id shift 141',0.00,0.00,0.00,478.11,0.00,'2022-07-24 14:15:21','',''),(2063,'21','226','3',2,'Sale Id shift 141',0.00,0.00,0.00,723.75,0.00,'2022-07-24 14:15:21','',''),(2064,'21','226',NULL,2,'Sale Id shift 141',979515.90,0.00,0.00,0.00,0.00,'2022-07-24 14:15:21','',''),(2065,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5580000.00,31000.00,0.00,0.00,'2022-07-24 14:16:57','',''),(2066,'21','226',NULL,1,'Reception corrector for bridging 180',0.00,0.00,0.00,31000.00,0.00,'2022-07-24 14:17:48','',''),(2067,'21','226','1',1,'Received from bridging 180',0.00,0.00,31000.00,0.00,0.00,'2022-07-24 14:17:48','',''),(2068,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-07-24 14:18:52','',''),(2069,'21','226',NULL,1,'Reception corrector for bridging 181',0.00,0.00,0.00,30000.00,0.00,'2022-07-24 14:20:02','',''),(2070,'21','226','1',1,'Received from bridging 181',0.00,0.00,30000.00,0.00,0.00,'2022-07-24 14:20:02','',''),(2071,'21','226','3',2,'Sale Id shift 142',0.00,0.00,0.00,52.01,0.00,'2022-07-24 14:27:48','',''),(2072,'21','226','1',1,'Sale Id shift 142',0.00,0.00,0.00,177.10,0.00,'2022-07-24 14:27:48','',''),(2073,'21','226','1',1,'Sale Id shift 142',0.00,0.00,0.00,33.08,0.00,'2022-07-24 14:27:48','',''),(2074,'21','226','1',1,'Sale Id shift 142',0.00,0.00,0.00,594.14,0.00,'2022-07-24 14:27:48','',''),(2075,'21','226','1',1,'Sale Id shift 142',0.00,0.00,0.00,32.61,0.00,'2022-07-24 14:27:48','',''),(2076,'21','226',NULL,2,'Sale Id shift 142',42388.15,0.00,0.00,0.00,0.00,'2022-07-24 14:27:48','',''),(2077,'21','226',NULL,1,'Sale Id shift 142',150647.40,0.00,0.00,0.00,0.00,'2022-07-24 14:27:48','',''),(2078,'21','226','1',1,'Sale Id shift 143',0.00,0.00,0.00,3654.47,0.00,'2022-07-24 16:20:28','',''),(2079,'21','226','1',1,'Sale Id shift 143',0.00,0.00,0.00,3802.70,0.00,'2022-07-24 16:20:28','',''),(2080,'21','226','1',1,'Sale Id shift 143',0.00,0.00,0.00,3677.51,0.00,'2022-07-24 16:20:28','',''),(2081,'21','226','1',1,'Sale Id shift 143',0.00,0.00,0.00,3424.29,0.00,'2022-07-24 16:20:28','',''),(2082,'21','226','1',1,'Sale Id shift 143',0.00,0.00,0.00,7.08,0.00,'2022-07-24 16:20:28','',''),(2083,'21','226','1',1,'Sale Id shift 143',0.00,0.00,0.00,39.43,0.00,'2022-07-24 16:20:28','',''),(2084,'21','226','1',1,'Sale Id shift 143',0.00,0.00,0.00,7538.22,0.00,'2022-07-24 16:20:28','',''),(2085,'21','226','1',1,'Sale Id shift 143',0.00,0.00,0.00,7510.96,0.00,'2022-07-24 16:20:28','',''),(2086,'21','226',NULL,1,'Sale Id shift 143',5337838.80,0.00,0.00,0.00,0.00,'2022-07-24 16:20:28','',''),(2087,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:10',2880000.00,0.00,0.00,16000.00,0.00,'2022-07-25 10:32:54','',''),(2088,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,16300000.00,20000.00,0.00,0.00,'2022-07-25 11:27:25','',''),(2089,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-07-25 14:57:56','',''),(2090,'21','226',NULL,2,'Returned purchase #124 to AYM SHAFA NIGERIA. LTD',16300000.00,0.00,0.00,20000.00,0.00,'2022-07-25 14:59:17','',''),(2091,'21','226',NULL,1,'Reception corrector for bridging 182',0.00,0.00,0.00,30000.00,0.00,'2022-07-25 14:59:28','',''),(2092,'21','226','1',1,'Received from bridging 182',0.00,0.00,30000.00,0.00,0.00,'2022-07-25 14:59:28','',''),(2093,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-07-26 10:59:18','',''),(2094,'21','226','1',1,'Sale Id shift 144',0.00,0.00,0.00,3498.55,0.00,'2022-07-26 11:09:31','',''),(2095,'21','226','1',1,'Sale Id shift 144',0.00,0.00,0.00,3353.45,0.00,'2022-07-26 11:09:31','',''),(2096,'21','226','3',2,'Sale Id shift 144',0.00,0.00,0.00,1981.31,0.00,'2022-07-26 11:09:31','',''),(2097,'21','226','3',2,'Sale Id shift 144',0.00,0.00,0.00,1633.68,0.00,'2022-07-26 11:09:31','',''),(2098,'21','226','1',1,'Sale Id shift 144',0.00,0.00,0.00,3945.12,0.00,'2022-07-26 11:09:31','',''),(2099,'21','226','1',1,'Sale Id shift 144',0.00,0.00,0.00,3764.71,0.00,'2022-07-26 11:09:31','',''),(2100,'21','226',NULL,2,'Sale Id shift 144',2946216.85,0.00,0.00,0.00,0.00,'2022-07-26 11:09:31','',''),(2101,'21','226',NULL,1,'Sale Id shift 144',2621129.40,0.00,0.00,0.00,0.00,'2022-07-26 11:09:31','',''),(2102,'21','226',NULL,1,'Reception corrector for bridging 183',0.00,0.00,0.00,45000.00,0.00,'2022-07-26 11:12:33','',''),(2103,'21','226','2',1,'Received from bridging 183',0.00,0.00,45000.00,0.00,0.00,'2022-07-26 11:12:33','',''),(2104,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,29948.58,0.00,'2022-07-26 16:12:27','',''),(2105,'21','226','1',0,'Inventory adjustment from tank dipping to 31000',0.00,0.00,31000.00,0.00,0.00,'2022-07-26 16:12:27','',''),(2106,'21','226','2',1,'Distributed to AHF NIGERIA  for sales id:11',2700000.00,0.00,0.00,15000.00,0.00,'2022-07-26 16:16:32','',''),(2107,'21','226','1',1,'Sale Id shift 145',0.00,0.00,0.00,6794.33,0.00,'2022-07-26 16:50:38','',''),(2108,'21','226','2',1,'Sale Id shift 145',0.00,0.00,0.00,88.87,0.00,'2022-07-26 16:50:38','',''),(2109,'21','226','2',1,'Sale Id shift 145',0.00,0.00,0.00,72.99,0.00,'2022-07-26 16:50:38','',''),(2110,'21','226','2',1,'Sale Id shift 145',0.00,0.00,0.00,198.02,0.00,'2022-07-26 16:50:38','',''),(2111,'21','226','1',1,'Sale Id shift 145',0.00,0.00,0.00,6082.39,0.00,'2022-07-26 16:50:38','',''),(2112,'21','226','2',1,'Sale Id shift 145',0.00,0.00,0.00,198.75,0.00,'2022-07-26 16:50:38','',''),(2113,'21','226','3',2,'Sale Id shift 145',0.00,0.00,0.00,730.99,0.00,'2022-07-26 16:50:38','',''),(2114,'21','226','3',2,'Sale Id shift 145',0.00,0.00,0.00,697.92,0.00,'2022-07-26 16:50:38','',''),(2115,'21','226','1',1,'Sale Id shift 145',0.00,0.00,0.00,2419.30,0.00,'2022-07-26 16:50:38','',''),(2116,'21','226','1',1,'Sale Id shift 145',0.00,0.00,0.00,2027.99,0.00,'2022-07-26 16:50:38','',''),(2117,'21','226','1',1,'Sale Id shift 145',0.00,0.00,0.00,6728.05,0.00,'2022-07-26 16:50:38','',''),(2118,'21','226','1',1,'Sale Id shift 145',0.00,0.00,0.00,6881.03,0.00,'2022-07-26 16:50:38','',''),(2119,'21','226',NULL,1,'Sale Id shift 145',5668509.60,0.00,0.00,0.00,0.00,'2022-07-26 16:50:38','',''),(2120,'21','226',NULL,2,'Sale Id shift 145',1164561.65,0.00,0.00,0.00,0.00,'2022-07-26 16:50:38','',''),(2121,'21','226','3',2,'Sale Id shift 146',0.00,0.00,0.00,1203.59,0.00,'2022-07-27 12:03:31','',''),(2122,'21','226','3',2,'Sale Id shift 146',0.00,0.00,0.00,50.00,0.00,'2022-07-27 12:03:31','',''),(2123,'21','226',NULL,2,'Sale Id shift 146',1015407.90,0.00,0.00,0.00,0.00,'2022-07-27 12:03:31','',''),(2124,'21','226','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,29441.83,0.00,'2022-07-27 12:08:18','',''),(2125,'21','226','2',0,'Inventory adjustment from tank dipping to 29600',0.00,0.00,29600.00,0.00,0.00,'2022-07-27 12:08:18','',''),(2126,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-07-27 12:08:43','',''),(2127,'21','226',NULL,1,'Reception corrector for bridging 184',0.00,0.00,0.00,30000.00,0.00,'2022-07-27 12:09:34','',''),(2128,'21','226','1',1,'Received from bridging 184',0.00,0.00,30000.00,0.00,0.00,'2022-07-27 12:09:34','',''),(2129,'21','226','2',1,'Sale Id shift 147',0.00,0.00,0.00,3579.19,0.00,'2022-07-27 12:39:34','',''),(2130,'21','226','2',1,'Sale Id shift 147',0.00,0.00,0.00,3420.57,0.00,'2022-07-27 12:39:34','',''),(2131,'21','226','2',1,'Sale Id shift 147',0.00,0.00,0.00,3217.57,0.00,'2022-07-27 12:39:34','',''),(2132,'21','226','2',1,'Sale Id shift 147',0.00,0.00,0.00,2361.29,0.00,'2022-07-27 12:39:34','',''),(2133,'21','226','2',1,'Sale Id shift 147',0.00,0.00,0.00,3919.47,0.00,'2022-07-27 12:39:34','',''),(2134,'21','226','2',1,'Sale Id shift 147',0.00,0.00,0.00,4323.94,0.00,'2022-07-27 12:39:34','',''),(2135,'21','226','2',1,'Sale Id shift 147',0.00,0.00,0.00,4359.54,0.00,'2022-07-27 12:39:34','',''),(2136,'21','226','2',1,'Sale Id shift 147',0.00,0.00,0.00,4417.17,0.00,'2022-07-27 12:39:34','',''),(2137,'21','226','3',2,'Sale Id shift 147',0.00,0.00,0.00,1642.44,0.00,'2022-07-27 12:39:34','',''),(2138,'21','226','3',2,'Sale Id shift 147',0.00,0.00,0.00,2674.92,0.00,'2022-07-27 12:39:34','',''),(2139,'21','226',NULL,1,'Sale Id shift 147',5327773.20,0.00,0.00,0.00,0.00,'2022-07-27 12:39:34','',''),(2140,'21','226',NULL,2,'Sale Id shift 147',3497061.60,0.00,0.00,0.00,0.00,'2022-07-27 12:39:34','',''),(2141,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-07-28 15:39:17','',''),(2142,'21','226',NULL,1,'Reception corrector for bridging 186',0.00,0.00,0.00,15000.00,0.00,'2022-07-28 15:40:11','',''),(2143,'21','226','2',1,'Received from bridging 186',0.00,0.00,15000.00,0.00,0.00,'2022-07-28 15:40:11','',''),(2144,'21','226',NULL,1,'Reception corrector for bridging 185',0.00,0.00,0.00,15000.00,0.00,'2022-07-28 15:40:11','',''),(2145,'21','226','1',1,'Received from bridging 185',0.00,0.00,15000.00,0.00,0.00,'2022-07-28 15:40:11','',''),(2146,'21','226','1',1,'Sale Id shift 148',0.00,0.00,0.00,5084.12,0.00,'2022-07-28 16:23:33','',''),(2147,'21','226','1',1,'Sale Id shift 148',0.00,0.00,0.00,4957.28,0.00,'2022-07-28 16:23:33','',''),(2148,'21','226','3',2,'Sale Id shift 148',0.00,0.00,0.00,972.03,0.00,'2022-07-28 16:23:33','',''),(2149,'21','226','3',2,'Sale Id shift 148',0.00,0.00,0.00,1883.92,0.00,'2022-07-28 16:23:33','',''),(2150,'21','226','1',1,'Sale Id shift 148',0.00,0.00,0.00,5740.85,0.00,'2022-07-28 16:23:33','',''),(2151,'21','226','1',1,'Sale Id shift 148',0.00,0.00,0.00,4568.52,0.00,'2022-07-28 16:23:33','',''),(2152,'21','226','1',1,'Sale Id shift 148',0.00,0.00,0.00,4769.60,0.00,'2022-07-28 16:23:33','',''),(2153,'21','226','1',1,'Sale Id shift 148',0.00,0.00,0.00,4993.41,0.00,'2022-07-28 16:23:33','',''),(2154,'21','226',NULL,2,'Sale Id shift 148',2313319.50,0.00,0.00,0.00,0.00,'2022-07-28 16:23:33','',''),(2155,'21','226',NULL,1,'Sale Id shift 148',5420480.40,0.00,0.00,0.00,0.00,'2022-07-28 16:23:33','',''),(2156,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-07-29 17:12:21','',''),(2157,'21','226',NULL,1,'Reception corrector for bridging 188',0.00,0.00,0.00,15000.00,0.00,'2022-07-29 17:13:18','',''),(2158,'21','226','2',1,'Received from bridging 188',0.00,0.00,15000.00,0.00,0.00,'2022-07-29 17:13:18','',''),(2159,'21','226',NULL,1,'Reception corrector for bridging 187',0.00,0.00,0.00,15000.00,0.00,'2022-07-29 17:13:18','',''),(2160,'21','226','1',1,'Received from bridging 187',0.00,0.00,15000.00,0.00,0.00,'2022-07-29 17:13:18','',''),(2161,'21','226','1',1,'Sale Id shift 149',0.00,0.00,0.00,745.73,0.00,'2022-07-29 17:30:50','',''),(2162,'21','226','2',1,'Sale Id shift 149',0.00,0.00,0.00,803.27,0.00,'2022-07-29 17:30:50','',''),(2163,'21','226','2',1,'Sale Id shift 149',0.00,0.00,0.00,816.34,0.00,'2022-07-29 17:30:50','',''),(2164,'21','226','2',1,'Sale Id shift 149',0.00,0.00,0.00,2536.12,0.00,'2022-07-29 17:30:50','',''),(2165,'21','226','1',1,'Sale Id shift 149',0.00,0.00,0.00,821.75,0.00,'2022-07-29 17:30:50','',''),(2166,'21','226','2',1,'Sale Id shift 149',0.00,0.00,0.00,1949.80,0.00,'2022-07-29 17:30:50','',''),(2167,'21','226','2',1,'Sale Id shift 149',0.00,0.00,0.00,1844.09,0.00,'2022-07-29 17:30:50','',''),(2168,'21','226','2',1,'Sale Id shift 149',0.00,0.00,0.00,1724.92,0.00,'2022-07-29 17:30:50','',''),(2169,'21','226','2',1,'Sale Id shift 149',0.00,0.00,0.00,2507.10,0.00,'2022-07-29 17:30:50','',''),(2170,'21','226','2',1,'Sale Id shift 149',0.00,0.00,0.00,2945.34,0.00,'2022-07-29 17:30:50','',''),(2171,'21','226','3',2,'Sale Id shift 149',0.00,0.00,0.00,758.70,0.00,'2022-07-29 17:30:50','',''),(2172,'21','226','3',2,'Sale Id shift 149',0.00,0.00,0.00,3045.00,0.00,'2022-07-29 17:30:50','',''),(2173,'21','226','1',1,'Sale Id shift 149',0.00,0.00,0.00,4395.88,0.00,'2022-07-29 17:30:50','',''),(2174,'21','226','1',1,'Sale Id shift 149',0.00,0.00,0.00,4058.23,0.00,'2022-07-29 17:30:50','',''),(2175,'21','226','1',1,'Sale Id shift 149',0.00,0.00,0.00,2779.55,0.00,'2022-07-29 17:30:50','',''),(2176,'21','226','1',1,'Sale Id shift 149',0.00,0.00,0.00,2377.60,0.00,'2022-07-29 17:30:50','',''),(2177,'21','226',NULL,1,'Sale Id shift 149',5455029.60,0.00,0.00,0.00,0.00,'2022-07-29 17:30:50','',''),(2178,'21','226',NULL,2,'Sale Id shift 149',3080997.00,0.00,0.00,0.00,0.00,'2022-07-29 17:30:50','',''),(2179,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,36450000.00,45000.00,0.00,0.00,'2022-07-30 14:35:52','',''),(2180,'21','226',NULL,2,'Reception corrector for bridging 189',0.00,0.00,0.00,30000.00,0.00,'2022-07-30 14:37:35','',''),(2181,'21','226','3',2,'Received from bridging 189',0.00,0.00,30000.00,0.00,0.00,'2022-07-30 14:37:35','',''),(2182,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2700000.00,15000.00,0.00,0.00,'2022-07-30 14:38:27','',''),(2183,'21','226',NULL,1,'Reception corrector for bridging 190',0.00,0.00,0.00,15000.00,0.00,'2022-07-30 14:39:48','',''),(2184,'21','226','1',1,'Received from bridging 190',0.00,0.00,15000.00,0.00,0.00,'2022-07-30 14:39:48','',''),(2185,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-07-30 14:40:07','',''),(2186,'21','226',NULL,1,'Reception corrector for bridging 192',0.00,0.00,0.00,30000.00,0.00,'2022-07-30 14:42:13','',''),(2187,'21','226','2',1,'Received from bridging 192',0.00,0.00,30000.00,0.00,0.00,'2022-07-30 14:42:13','',''),(2188,'21','226',NULL,1,'Reception corrector for bridging 191',0.00,0.00,0.00,15000.00,0.00,'2022-07-30 14:42:13','',''),(2189,'21','226','1',1,'Received from bridging 191',0.00,0.00,15000.00,0.00,0.00,'2022-07-30 14:42:13','',''),(2190,'21','226','2',1,'Distributed to AHF NIGERIA  for sales id:12',5400000.00,0.00,0.00,30000.00,0.00,'2022-07-31 17:19:32','',''),(2191,'21','226','1',1,'Returned bridging 190',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 17:24:15','',''),(2192,'21','226',NULL,1,'Reception Return corrector for bridging 190',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 17:24:15','',''),(2193,'21','226',NULL,1,'Reception corrector for bridging 193',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 17:25:25','',''),(2194,'21','226','2',1,'Received from bridging 193',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 17:25:25','',''),(2195,'21','226','1',1,'Sale Id shift 151',0.00,0.00,0.00,3321.46,0.00,'2022-07-31 17:41:31','',''),(2196,'21','226','2',1,'Sale Id shift 151',0.00,0.00,0.00,1179.87,0.00,'2022-07-31 17:41:31','',''),(2197,'21','226','2',1,'Sale Id shift 151',0.00,0.00,0.00,1233.00,0.00,'2022-07-31 17:41:31','',''),(2198,'21','226','2',1,'Sale Id shift 151',0.00,0.00,0.00,3474.77,0.00,'2022-07-31 17:41:31','',''),(2199,'21','226','1',1,'Sale Id shift 151',0.00,0.00,0.00,3014.44,0.00,'2022-07-31 17:41:31','',''),(2200,'21','226','2',1,'Sale Id shift 151',0.00,0.00,0.00,3866.44,0.00,'2022-07-31 17:41:31','',''),(2201,'21','226','2',1,'Sale Id shift 151',0.00,0.00,0.00,2481.39,0.00,'2022-07-31 17:41:31','',''),(2202,'21','226','2',1,'Sale Id shift 151',0.00,0.00,0.00,2731.39,0.00,'2022-07-31 17:41:31','',''),(2203,'21','226','3',2,'Sale Id shift 151',0.00,0.00,0.00,4427.35,0.00,'2022-07-31 17:41:31','',''),(2204,'21','226','1',1,'Sale Id shift 151',0.00,0.00,0.00,1402.70,0.00,'2022-07-31 17:41:31','',''),(2205,'21','226','1',1,'Sale Id shift 151',0.00,0.00,0.00,886.71,0.00,'2022-07-31 17:41:31','',''),(2206,'21','226','1',1,'Sale Id shift 151',0.00,0.00,0.00,3025.02,0.00,'2022-07-31 17:41:31','',''),(2207,'21','226','1',1,'Sale Id shift 151',0.00,0.00,0.00,3243.32,0.00,'2022-07-31 17:41:31','',''),(2208,'21','226',NULL,1,'Sale Id shift 151',5374891.80,0.00,0.00,0.00,0.00,'2022-07-31 17:41:31','',''),(2209,'21','226',NULL,2,'Sale Id shift 151',3586153.50,0.00,0.00,0.00,0.00,'2022-07-31 17:41:31','',''),(2210,'21','226',NULL,2,'Reception corrector for bridging 194',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 17:44:05','',''),(2211,'21','226','3',2,'Received from bridging 194',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 17:44:05','',''),(2212,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-07-31 17:45:38','',''),(2213,'21','226',NULL,1,'Reception corrector for bridging 196',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 17:46:53','',''),(2214,'21','226','2',1,'Received from bridging 196',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 17:46:53','',''),(2215,'21','226',NULL,1,'Reception corrector for bridging 195',0.00,0.00,0.00,30000.00,0.00,'2022-07-31 17:46:53','',''),(2216,'21','226','1',1,'Received from bridging 195',0.00,0.00,30000.00,0.00,0.00,'2022-07-31 17:46:53','',''),(2217,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:13',2700000.00,0.00,0.00,15000.00,0.00,'2022-07-31 17:49:41','',''),(2218,'21','226','1',1,'Sale Id shift 152',0.00,0.00,0.00,3765.37,0.00,'2022-07-31 17:57:01','',''),(2219,'21','226','2',1,'Sale Id shift 152',0.00,0.00,0.00,1313.94,0.00,'2022-07-31 17:57:01','',''),(2220,'21','226','2',1,'Sale Id shift 152',0.00,0.00,0.00,1270.15,0.00,'2022-07-31 17:57:01','',''),(2221,'21','226','2',1,'Sale Id shift 152',0.00,0.00,0.00,3584.39,0.00,'2022-07-31 17:57:01','',''),(2222,'21','226','1',1,'Sale Id shift 152',0.00,0.00,0.00,3662.99,0.00,'2022-07-31 17:57:01','',''),(2223,'21','226','2',1,'Sale Id shift 152',0.00,0.00,0.00,3352.33,0.00,'2022-07-31 17:57:01','',''),(2224,'21','226','2',1,'Sale Id shift 152',0.00,0.00,0.00,2760.09,0.00,'2022-07-31 17:57:01','',''),(2225,'21','226','2',1,'Sale Id shift 152',0.00,0.00,0.00,2884.44,0.00,'2022-07-31 17:57:01','',''),(2226,'21','226','3',2,'Sale Id shift 152',0.00,0.00,0.00,87.79,0.00,'2022-07-31 17:57:01','',''),(2227,'21','226','3',2,'Sale Id shift 152',0.00,0.00,0.00,1277.96,0.00,'2022-07-31 17:57:01','',''),(2228,'21','226','1',1,'Sale Id shift 152',0.00,0.00,0.00,3990.94,0.00,'2022-07-31 17:57:01','',''),(2229,'21','226','1',1,'Sale Id shift 152',0.00,0.00,0.00,3620.11,0.00,'2022-07-31 17:57:01','',''),(2230,'21','226',NULL,1,'Sale Id shift 152',5436855.00,0.00,0.00,0.00,0.00,'2022-07-31 17:57:01','',''),(2231,'21','226',NULL,2,'Sale Id shift 152',1106257.50,0.00,0.00,0.00,0.00,'2022-07-31 17:57:01','',''),(2232,'21','226',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,27471500.00,32900.00,0.00,0.00,'2022-07-31 17:57:52','',''),(2233,'21','226',NULL,3,'Reception corrector for bridging 197',0.00,0.00,0.00,32900.00,0.00,'2022-07-31 17:59:37','',''),(2234,'21','226','4',3,'Received from bridging 197',0.00,0.00,32900.00,0.00,0.00,'2022-07-31 17:59:37','',''),(2235,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-08-01 15:10:11','',''),(2236,'21','226',NULL,1,'Reception corrector for bridging 199',0.00,0.00,0.00,15000.00,0.00,'2022-08-01 15:11:21','',''),(2237,'21','226','2',1,'Received from bridging 199',0.00,0.00,15000.00,0.00,0.00,'2022-08-01 15:11:21','',''),(2238,'21','226',NULL,1,'Reception corrector for bridging 198',0.00,0.00,0.00,30000.00,0.00,'2022-08-01 15:11:21','',''),(2239,'21','226','1',1,'Received from bridging 198',0.00,0.00,30000.00,0.00,0.00,'2022-08-01 15:11:21','',''),(2240,'21','226','1',1,'Sale Id shift 153',0.00,0.00,0.00,4107.31,0.00,'2022-08-02 16:31:11','',''),(2241,'21','226','2',1,'Sale Id shift 153',0.00,0.00,0.00,3533.87,0.00,'2022-08-02 16:31:11','',''),(2242,'21','226','1',1,'Sale Id shift 153',0.00,0.00,0.00,3671.69,0.00,'2022-08-02 16:31:11','',''),(2243,'21','226','2',1,'Sale Id shift 153',0.00,0.00,0.00,3881.46,0.00,'2022-08-02 16:31:11','',''),(2244,'21','226','2',1,'Sale Id shift 153',0.00,0.00,0.00,3511.49,0.00,'2022-08-02 16:31:11','',''),(2245,'21','226','2',1,'Sale Id shift 153',0.00,0.00,0.00,4099.70,0.00,'2022-08-02 16:31:11','',''),(2246,'21','226','3',2,'Sale Id shift 153',0.00,0.00,0.00,100.00,0.00,'2022-08-02 16:31:11','',''),(2247,'21','226','3',2,'Sale Id shift 153',0.00,0.00,0.00,2497.31,0.00,'2022-08-02 16:31:11','',''),(2248,'21','226','4',3,'Sale Id shift 153',0.00,0.00,0.00,40.46,0.00,'2022-08-02 16:31:11','',''),(2249,'21','226','1',1,'Sale Id shift 153',0.00,0.00,0.00,3553.16,0.00,'2022-08-02 16:31:11','',''),(2250,'21','226','1',1,'Sale Id shift 153',0.00,0.00,0.00,3779.89,0.00,'2022-08-02 16:31:11','',''),(2251,'21','226',NULL,1,'Sale Id shift 153',5424942.60,0.00,0.00,0.00,0.00,'2022-08-02 16:31:11','',''),(2252,'21','226',NULL,2,'Sale Id shift 153',2103821.10,0.00,0.00,0.00,0.00,'2022-08-02 16:31:11','',''),(2253,'21','226',NULL,3,'Sale Id shift 153',33784.10,0.00,0.00,0.00,0.00,'2022-08-02 16:31:11','',''),(2254,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-08-02 16:37:30','',''),(2255,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:14',2700000.00,0.00,0.00,15000.00,0.00,'2022-08-02 16:37:54','',''),(2256,'21','226',NULL,1,'Reception corrector for bridging 201',0.00,0.00,0.00,16000.00,0.00,'2022-08-02 16:38:28','',''),(2257,'21','226','2',1,'Received from bridging 201',0.00,0.00,16000.00,0.00,0.00,'2022-08-02 16:38:28','',''),(2258,'21','226',NULL,1,'Reception corrector for bridging 200',0.00,0.00,0.00,24000.00,0.00,'2022-08-02 16:38:28','',''),(2259,'21','226','1',1,'Received from bridging 200',0.00,0.00,24000.00,0.00,0.00,'2022-08-02 16:38:28','',''),(2260,'21','226','1',1,'Sale Id shift 154',0.00,0.00,0.00,4102.13,0.00,'2022-08-03 14:20:01','',''),(2261,'21','226','2',1,'Sale Id shift 154',0.00,0.00,0.00,3621.94,0.00,'2022-08-03 14:20:01','',''),(2262,'21','226','1',1,'Sale Id shift 154',0.00,0.00,0.00,3565.08,0.00,'2022-08-03 14:20:01','',''),(2263,'21','226','2',1,'Sale Id shift 154',0.00,0.00,0.00,3442.59,0.00,'2022-08-03 14:20:01','',''),(2264,'21','226','2',1,'Sale Id shift 154',0.00,0.00,0.00,3640.98,0.00,'2022-08-03 14:20:01','',''),(2265,'21','226','2',1,'Sale Id shift 154',0.00,0.00,0.00,3385.92,0.00,'2022-08-03 14:20:01','',''),(2266,'21','226','3',2,'Sale Id shift 154',0.00,0.00,0.00,4175.94,0.00,'2022-08-03 14:20:01','',''),(2267,'21','226','4',3,'Sale Id shift 154',0.00,0.00,0.00,89.29,0.00,'2022-08-03 14:20:01','',''),(2268,'21','226','1',1,'Sale Id shift 154',0.00,0.00,0.00,3927.97,0.00,'2022-08-03 14:20:01','',''),(2269,'21','226','1',1,'Sale Id shift 154',0.00,0.00,0.00,4020.71,0.00,'2022-08-03 14:20:01','',''),(2270,'21','226',NULL,1,'Sale Id shift 154',5347317.60,0.00,0.00,0.00,0.00,'2022-08-03 14:20:01','',''),(2271,'21','226',NULL,2,'Sale Id shift 154',3382511.40,0.00,0.00,0.00,0.00,'2022-08-03 14:20:01','',''),(2272,'21','226',NULL,3,'Sale Id shift 154',74557.15,0.00,0.00,0.00,0.00,'2022-08-03 14:20:01','',''),(2273,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-08-03 14:25:10','',''),(2274,'21','226',NULL,1,'Reception corrector for bridging 203',0.00,0.00,0.00,12000.00,0.00,'2022-08-03 14:25:52','',''),(2275,'21','226','2',1,'Received from bridging 203',0.00,0.00,12000.00,0.00,0.00,'2022-08-03 14:25:52','',''),(2276,'21','226',NULL,1,'Reception corrector for bridging 202',0.00,0.00,0.00,18000.00,0.00,'2022-08-03 14:25:52','',''),(2277,'21','226','1',1,'Received from bridging 202',0.00,0.00,18000.00,0.00,0.00,'2022-08-03 14:25:52','',''),(2278,'21','226','1',1,'Sale Id shift 155',0.00,0.00,0.00,6085.35,0.00,'2022-08-03 16:42:51','',''),(2279,'21','226','2',1,'Sale Id shift 155',0.00,0.00,0.00,3640.21,0.00,'2022-08-03 16:42:51','',''),(2280,'21','226','1',1,'Sale Id shift 155',0.00,0.00,0.00,5720.02,0.00,'2022-08-03 16:42:51','',''),(2281,'21','226','2',1,'Sale Id shift 155',0.00,0.00,0.00,4401.41,0.00,'2022-08-03 16:42:51','',''),(2282,'21','226','2',1,'Sale Id shift 155',0.00,0.00,0.00,4116.60,0.00,'2022-08-03 16:42:51','',''),(2283,'21','226','2',1,'Sale Id shift 155',0.00,0.00,0.00,4230.66,0.00,'2022-08-03 16:42:51','',''),(2284,'21','226','3',2,'Sale Id shift 155',0.00,0.00,0.00,5609.56,0.00,'2022-08-03 16:42:51','',''),(2285,'21','226','4',3,'Sale Id shift 155',0.00,0.00,0.00,198.05,0.00,'2022-08-03 16:42:51','',''),(2286,'21','226','4',3,'Sale Id shift 155',0.00,0.00,0.00,0.16,0.00,'2022-08-03 16:42:51','',''),(2287,'21','226','1',1,'Sale Id shift 155',0.00,0.00,0.00,6265.82,0.00,'2022-08-03 16:42:51','',''),(2288,'21','226','1',1,'Sale Id shift 155',0.00,0.00,0.00,5778.19,0.00,'2022-08-03 16:42:51','',''),(2289,'21','226',NULL,2,'Sale Id shift 155',4543743.60,0.00,0.00,0.00,0.00,'2022-08-03 16:42:51','',''),(2290,'21','226',NULL,3,'Sale Id shift 155',165505.35,0.00,0.00,0.00,0.00,'2022-08-03 16:42:51','',''),(2291,'21','226',NULL,1,'Sale Id shift 155',7242886.80,0.00,0.00,0.00,0.00,'2022-08-03 16:42:51','',''),(2292,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-08-04 13:53:19','',''),(2293,'21','226',NULL,1,'Reception corrector for bridging 205',0.00,0.00,0.00,15000.00,0.00,'2022-08-04 13:54:10','',''),(2294,'21','226','2',1,'Received from bridging 205',0.00,0.00,15000.00,0.00,0.00,'2022-08-04 13:54:10','',''),(2295,'21','226',NULL,1,'Reception corrector for bridging 204',0.00,0.00,0.00,30000.00,0.00,'2022-08-04 13:54:10','',''),(2296,'21','226','1',1,'Received from bridging 204',0.00,0.00,30000.00,0.00,0.00,'2022-08-04 13:54:10','',''),(2297,'21','226','1',1,'Distributed to AHF NIGERIA  for sales id:16',2700000.00,0.00,0.00,15000.00,0.00,'2022-08-04 14:05:22','',''),(2298,'21','226','1',1,'Sale Id shift 156',0.00,0.00,0.00,4925.53,0.00,'2022-08-04 14:18:34','',''),(2299,'21','226','2',1,'Sale Id shift 156',0.00,0.00,0.00,2995.25,0.00,'2022-08-04 14:18:34','',''),(2300,'21','226','1',1,'Sale Id shift 156',0.00,0.00,0.00,4234.76,0.00,'2022-08-04 14:18:34','',''),(2301,'21','226','2',1,'Sale Id shift 156',0.00,0.00,0.00,3166.19,0.00,'2022-08-04 14:18:34','',''),(2302,'21','226','2',1,'Sale Id shift 156',0.00,0.00,0.00,2771.13,0.00,'2022-08-04 14:18:34','',''),(2303,'21','226','2',1,'Sale Id shift 156',0.00,0.00,0.00,3177.44,0.00,'2022-08-04 14:18:34','',''),(2304,'21','226','3',2,'Sale Id shift 156',0.00,0.00,0.00,23.00,0.00,'2022-08-04 14:18:34','',''),(2305,'21','226','3',2,'Sale Id shift 156',0.00,0.00,0.00,5128.07,0.00,'2022-08-04 14:18:34','',''),(2306,'21','226','4',3,'Sale Id shift 156',0.00,0.00,0.00,87.47,0.00,'2022-08-04 14:18:34','',''),(2307,'21','226','1',1,'Sale Id shift 156',0.00,0.00,0.00,4799.08,0.00,'2022-08-04 14:18:34','',''),(2308,'21','226','1',1,'Sale Id shift 156',0.00,0.00,0.00,4105.16,0.00,'2022-08-04 14:18:34','',''),(2309,'21','226',NULL,2,'Sale Id shift 156',4172366.70,0.00,0.00,0.00,0.00,'2022-08-04 14:18:34','',''),(2310,'21','226',NULL,3,'Sale Id shift 156',73037.45,0.00,0.00,0.00,0.00,'2022-08-04 14:18:34','',''),(2311,'21','226',NULL,1,'Sale Id shift 156',5431417.20,0.00,0.00,0.00,0.00,'2022-08-04 14:18:34','',''),(2312,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-08-05 16:53:22','',''),(2313,'21','226',NULL,1,'Reception corrector for bridging 207',0.00,0.00,0.00,15000.00,0.00,'2022-08-05 16:54:24','',''),(2314,'21','226','2',1,'Received from bridging 207',0.00,0.00,15000.00,0.00,0.00,'2022-08-05 16:54:24','',''),(2315,'21','226',NULL,1,'Reception corrector for bridging 206',0.00,0.00,0.00,30000.00,0.00,'2022-08-05 16:54:24','',''),(2316,'21','226','1',1,'Received from bridging 206',0.00,0.00,30000.00,0.00,0.00,'2022-08-05 16:54:24','',''),(2317,'21','226','1',1,'Sale Id shift 157',0.00,0.00,0.00,4327.74,0.00,'2022-08-05 17:21:49','',''),(2318,'21','226','2',1,'Sale Id shift 157',0.00,0.00,0.00,3813.01,0.00,'2022-08-05 17:21:49','',''),(2319,'21','226','1',1,'Sale Id shift 157',0.00,0.00,0.00,3946.75,0.00,'2022-08-05 17:21:49','',''),(2320,'21','226','2',1,'Sale Id shift 157',0.00,0.00,0.00,4268.34,0.00,'2022-08-05 17:21:49','',''),(2321,'21','226','2',1,'Sale Id shift 157',0.00,0.00,0.00,3267.93,0.00,'2022-08-05 17:21:49','',''),(2322,'21','226','2',1,'Sale Id shift 157',0.00,0.00,0.00,3752.33,0.00,'2022-08-05 17:21:49','',''),(2323,'21','226','3',2,'Sale Id shift 157',0.00,0.00,0.00,572.54,0.00,'2022-08-05 17:21:49','',''),(2324,'21','226','3',2,'Sale Id shift 157',0.00,0.00,0.00,5038.76,0.00,'2022-08-05 17:21:49','',''),(2325,'21','226','4',3,'Sale Id shift 157',0.00,0.00,0.00,146.55,0.00,'2022-08-05 17:21:49','',''),(2326,'21','226','1',1,'Sale Id shift 157',0.00,0.00,0.00,3469.77,0.00,'2022-08-05 17:21:49','',''),(2327,'21','226','1',1,'Sale Id shift 157',0.00,0.00,0.00,3333.10,0.00,'2022-08-05 17:21:49','',''),(2328,'21','226',NULL,1,'Sale Id shift 157',5432214.60,0.00,0.00,0.00,0.00,'2022-08-05 17:21:49','',''),(2329,'21','226',NULL,2,'Sale Id shift 157',4545153.00,0.00,0.00,0.00,0.00,'2022-08-05 17:21:49','',''),(2330,'21','226',NULL,3,'Sale Id shift 157',122369.25,0.00,0.00,0.00,0.00,'2022-08-05 17:21:49','',''),(2331,'21','226','1',1,'Sale Id shift 158',0.00,0.00,0.00,11.10,0.00,'2022-08-06 19:28:42','',''),(2332,'21','226','2',1,'Sale Id shift 158',0.00,0.00,0.00,3090.41,0.00,'2022-08-06 19:28:42','',''),(2333,'21','226','1',1,'Sale Id shift 158',0.00,0.00,0.00,2.77,0.00,'2022-08-06 19:28:42','',''),(2334,'21','226','2',1,'Sale Id shift 158',0.00,0.00,0.00,3218.44,0.00,'2022-08-06 19:28:42','',''),(2335,'21','226','2',1,'Sale Id shift 158',0.00,0.00,0.00,3427.87,0.00,'2022-08-06 19:28:42','',''),(2336,'21','226','2',1,'Sale Id shift 158',0.00,0.00,0.00,3217.48,0.00,'2022-08-06 19:28:42','',''),(2337,'21','226','3',2,'Sale Id shift 158',0.00,0.00,0.00,2903.42,0.00,'2022-08-06 19:28:42','',''),(2338,'21','226','4',3,'Sale Id shift 158',0.00,0.00,0.00,61.26,0.00,'2022-08-06 19:28:42','',''),(2339,'21','226','1',1,'Sale Id shift 158',0.00,0.00,0.00,3115.79,0.00,'2022-08-06 19:28:42','',''),(2340,'21','226','1',1,'Sale Id shift 158',0.00,0.00,0.00,2369.06,0.00,'2022-08-06 19:28:42','',''),(2341,'21','226',NULL,1,'Sale Id shift 158',3321525.60,0.00,0.00,0.00,0.00,'2022-08-06 19:28:42','',''),(2342,'21','226',NULL,2,'Sale Id shift 158',2351770.20,0.00,0.00,0.00,0.00,'2022-08-06 19:28:42','',''),(2343,'21','226',NULL,3,'Sale Id shift 158',51152.10,0.00,0.00,0.00,0.00,'2022-08-06 19:28:42','',''),(2344,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,23623.40,0.00,'2022-08-07 17:42:51','',''),(2345,'21','226','1',0,'Inventory adjustment from tank dipping to 23880',0.00,0.00,23880.00,0.00,0.00,'2022-08-07 17:42:51','',''),(2346,'21','226','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,2069.43,0.00,'2022-08-07 17:44:17','',''),(2347,'21','226','2',0,'Inventory adjustment from tank dipping to 2070',0.00,0.00,2070.00,0.00,0.00,'2022-08-07 17:44:17','',''),(2348,'21','226','1',1,'Sale Id shift 159',0.00,0.00,0.00,6485.99,0.00,'2022-08-10 10:16:51','',''),(2349,'21','226','1',1,'Sale Id shift 159',0.00,0.00,0.00,6036.51,0.00,'2022-08-10 10:16:51','',''),(2350,'21','226','2',1,'Sale Id shift 159',0.00,0.00,0.00,1196.85,0.00,'2022-08-10 10:16:51','',''),(2351,'21','226','2',1,'Sale Id shift 159',0.00,0.00,0.00,872.77,0.00,'2022-08-10 10:16:51','',''),(2352,'21','226','3',2,'Sale Id shift 159',0.00,0.00,0.00,1428.76,0.00,'2022-08-10 10:16:51','',''),(2353,'21','226','3',2,'Sale Id shift 159',0.00,0.00,0.00,1218.18,0.00,'2022-08-10 10:16:51','',''),(2354,'21','226','4',3,'Sale Id shift 159',0.00,0.00,0.00,186.44,0.00,'2022-08-10 10:16:51','',''),(2355,'21','226','1',1,'Sale Id shift 159',0.00,0.00,0.00,5788.66,0.00,'2022-08-10 10:16:51','',''),(2356,'21','226','1',1,'Sale Id shift 159',0.00,0.00,0.00,5562.52,0.00,'2022-08-10 10:16:51','',''),(2357,'21','226',NULL,1,'Sale Id shift 159',4669794.00,0.00,0.00,0.00,0.00,'2022-08-10 10:16:51','',''),(2358,'21','226',NULL,2,'Sale Id shift 159',2144021.40,0.00,0.00,0.00,0.00,'2022-08-10 10:16:51','',''),(2359,'21','226',NULL,3,'Sale Id shift 159',155677.40,0.00,0.00,0.00,0.00,'2022-08-10 10:16:51','',''),(2360,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,27135000.00,33500.00,0.00,0.00,'2022-08-10 10:23:41','',''),(2361,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-08-10 10:25:49','',''),(2362,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-08-10 10:27:01','',''),(2363,'21','226',NULL,1,'Reception corrector for bridging 209',0.00,0.00,0.00,15000.00,0.00,'2022-08-10 10:28:01','',''),(2364,'21','226','2',1,'Received from bridging 209',0.00,0.00,15000.00,0.00,0.00,'2022-08-10 10:28:01','',''),(2365,'21','226',NULL,1,'Reception corrector for bridging 208',0.00,0.00,0.00,15000.00,0.00,'2022-08-10 10:28:01','',''),(2366,'21','226','1',1,'Received from bridging 208',0.00,0.00,15000.00,0.00,0.00,'2022-08-10 10:28:01','',''),(2367,'21','226',NULL,1,'Reception corrector for bridging 211',0.00,0.00,0.00,15000.00,0.00,'2022-08-10 10:28:09','',''),(2368,'21','226','2',1,'Received from bridging 211',0.00,0.00,15000.00,0.00,0.00,'2022-08-10 10:28:09','',''),(2369,'21','226',NULL,1,'Reception corrector for bridging 210',0.00,0.00,0.00,15000.00,0.00,'2022-08-10 10:28:09','',''),(2370,'21','226','1',1,'Received from bridging 210',0.00,0.00,15000.00,0.00,0.00,'2022-08-10 10:28:09','',''),(2371,'21','226','3',2,'Sale Id shift 160',0.00,0.00,0.00,1370.85,0.00,'2022-08-10 10:28:15','',''),(2372,'21','226','3',2,'Sale Id shift 160',0.00,0.00,0.00,1852.11,0.00,'2022-08-10 10:28:15','',''),(2373,'21','226','4',3,'Sale Id shift 160',0.00,0.00,0.00,97.44,0.00,'2022-08-10 10:28:15','',''),(2374,'21','226',NULL,2,'Sale Id shift 160',2610597.60,0.00,0.00,0.00,0.00,'2022-08-10 10:28:15','',''),(2375,'21','226',NULL,3,'Sale Id shift 160',81362.40,0.00,0.00,0.00,0.00,'2022-08-10 10:28:15','',''),(2376,'21','226','3',2,'Sale Id shift 161',0.00,0.00,0.00,1284.36,0.00,'2022-08-10 10:38:20','',''),(2377,'21','226','3',2,'Sale Id shift 161',0.00,0.00,0.00,1796.91,0.00,'2022-08-10 10:38:20','',''),(2378,'21','226','4',3,'Sale Id shift 161',0.00,0.00,0.00,72.61,0.00,'2022-08-10 10:38:20','',''),(2379,'21','226',NULL,2,'Sale Id shift 161',2495828.70,0.00,0.00,0.00,0.00,'2022-08-10 10:38:20','',''),(2380,'21','226',NULL,3,'Sale Id shift 161',60629.35,0.00,0.00,0.00,0.00,'2022-08-10 10:38:20','',''),(2381,'21','226','1',1,'Sale Id shift 162',0.00,0.00,0.00,5235.23,0.00,'2022-08-10 10:53:30','',''),(2382,'21','226','2',1,'Sale Id shift 162',0.00,0.00,0.00,3728.65,0.00,'2022-08-10 10:53:30','',''),(2383,'21','226','1',1,'Sale Id shift 162',0.00,0.00,0.00,4107.72,0.00,'2022-08-10 10:53:30','',''),(2384,'21','226','2',1,'Sale Id shift 162',0.00,0.00,0.00,3718.99,0.00,'2022-08-10 10:53:30','',''),(2385,'21','226','2',1,'Sale Id shift 162',0.00,0.00,0.00,3691.18,0.00,'2022-08-10 10:53:30','',''),(2386,'21','226','2',1,'Sale Id shift 162',0.00,0.00,0.00,4084.95,0.00,'2022-08-10 10:53:30','',''),(2387,'21','226','3',2,'Sale Id shift 162',0.00,0.00,0.00,2155.16,0.00,'2022-08-10 10:53:30','',''),(2388,'21','226','3',2,'Sale Id shift 162',0.00,0.00,0.00,2805.11,0.00,'2022-08-10 10:53:30','',''),(2389,'21','226','4',3,'Sale Id shift 162',0.00,0.00,0.00,96.57,0.00,'2022-08-10 10:53:30','',''),(2390,'21','226','1',1,'Sale Id shift 162',0.00,0.00,0.00,3530.49,0.00,'2022-08-10 10:53:30','',''),(2391,'21','226','1',1,'Sale Id shift 162',0.00,0.00,0.00,2506.19,0.00,'2022-08-10 10:53:30','',''),(2392,'21','226',NULL,1,'Sale Id shift 162',5508612.00,0.00,0.00,0.00,0.00,'2022-08-10 10:53:30','',''),(2393,'21','226',NULL,2,'Sale Id shift 162',4017818.70,0.00,0.00,0.00,0.00,'2022-08-10 10:53:30','',''),(2394,'21','226',NULL,3,'Sale Id shift 162',80635.95,0.00,0.00,0.00,0.00,'2022-08-10 10:53:30','',''),(2395,'21','226',NULL,2,'Reception corrector for bridging 212',0.00,0.00,0.00,33500.00,0.00,'2022-08-11 17:09:54','',''),(2396,'21','226','3',2,'Received from bridging 212',0.00,0.00,33500.00,0.00,0.00,'2022-08-11 17:09:54','',''),(2397,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-08-11 17:12:29','',''),(2398,'21','226',NULL,1,'Reception corrector for bridging 214',0.00,0.00,0.00,15000.00,0.00,'2022-08-11 17:22:57','',''),(2399,'21','226','2',1,'Received from bridging 214',0.00,0.00,15000.00,0.00,0.00,'2022-08-11 17:22:57','',''),(2400,'21','226',NULL,1,'Reception corrector for bridging 213',0.00,0.00,0.00,15000.00,0.00,'2022-08-11 17:22:57','',''),(2401,'21','226','1',1,'Received from bridging 213',0.00,0.00,15000.00,0.00,0.00,'2022-08-11 17:22:57','',''),(2402,'21','226','1',1,'Sale Id shift 163',0.00,0.00,0.00,4756.28,0.00,'2022-08-11 18:44:55','',''),(2403,'21','226','2',1,'Sale Id shift 163',0.00,0.00,0.00,3333.58,0.00,'2022-08-11 18:44:55','',''),(2404,'21','226','1',1,'Sale Id shift 163',0.00,0.00,0.00,4403.79,0.00,'2022-08-11 18:44:55','',''),(2405,'21','226','2',1,'Sale Id shift 163',0.00,0.00,0.00,4005.40,0.00,'2022-08-11 18:44:55','',''),(2406,'21','226','2',1,'Sale Id shift 163',0.00,0.00,0.00,3539.61,0.00,'2022-08-11 18:44:55','',''),(2407,'21','226','2',1,'Sale Id shift 163',0.00,0.00,0.00,4199.54,0.00,'2022-08-11 18:44:55','',''),(2408,'21','226','3',2,'Sale Id shift 163',0.00,0.00,0.00,2005.44,0.00,'2022-08-11 18:44:55','',''),(2409,'21','226','3',2,'Sale Id shift 163',0.00,0.00,0.00,1177.91,0.00,'2022-08-11 18:44:55','',''),(2410,'21','226','4',3,'Sale Id shift 163',0.00,0.00,0.00,59.08,0.00,'2022-08-11 18:44:55','',''),(2411,'21','226','1',1,'Sale Id shift 163',0.00,0.00,0.00,3207.11,0.00,'2022-08-11 18:44:55','',''),(2412,'21','226','1',1,'Sale Id shift 163',0.00,0.00,0.00,2648.96,0.00,'2022-08-11 18:44:55','',''),(2413,'21','226',NULL,1,'Sale Id shift 163',5416968.60,0.00,0.00,0.00,0.00,'2022-08-11 18:44:55','',''),(2414,'21','226',NULL,2,'Sale Id shift 163',2578513.50,0.00,0.00,0.00,0.00,'2022-08-11 18:44:55','',''),(2415,'21','226',NULL,3,'Sale Id shift 163',49331.80,0.00,0.00,0.00,0.00,'2022-08-11 18:44:55','',''),(2416,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2700000.00,15000.00,0.00,0.00,'2022-08-13 08:24:27','',''),(2417,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-08-13 08:25:30','',''),(2418,'21','226',NULL,1,'Returned purchase #144 to AYM SHAFA NIGERIA. LTD',2700000.00,0.00,0.00,15000.00,0.00,'2022-08-13 08:26:31','',''),(2419,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12150000.00,15000.00,0.00,0.00,'2022-08-13 08:27:21','',''),(2420,'21','226',NULL,1,'Reception corrector for bridging 216',0.00,0.00,0.00,15000.00,0.00,'2022-08-13 08:30:53','',''),(2421,'21','226','2',1,'Received from bridging 216',0.00,0.00,15000.00,0.00,0.00,'2022-08-13 08:30:53','',''),(2422,'21','226',NULL,1,'Reception corrector for bridging 215',0.00,0.00,0.00,15000.00,0.00,'2022-08-13 08:30:53','',''),(2423,'21','226','1',1,'Received from bridging 215',0.00,0.00,15000.00,0.00,0.00,'2022-08-13 08:30:53','',''),(2424,'21','226','1',1,'Sale Id shift 164',0.00,0.00,0.00,4381.02,0.00,'2022-08-14 05:48:33','',''),(2425,'21','226','2',1,'Sale Id shift 164',0.00,0.00,0.00,3000.41,0.00,'2022-08-14 05:48:33','',''),(2426,'21','226','1',1,'Sale Id shift 164',0.00,0.00,0.00,3610.49,0.00,'2022-08-14 05:48:33','',''),(2427,'21','226','2',1,'Sale Id shift 164',0.00,0.00,0.00,2992.74,0.00,'2022-08-14 05:48:33','',''),(2428,'21','226','2',1,'Sale Id shift 164',0.00,0.00,0.00,2583.43,0.00,'2022-08-14 05:48:33','',''),(2429,'21','226','2',1,'Sale Id shift 164',0.00,0.00,0.00,2838.18,0.00,'2022-08-14 05:48:33','',''),(2430,'21','226','3',2,'Sale Id shift 164',0.00,0.00,0.00,2164.14,0.00,'2022-08-14 05:48:33','',''),(2431,'21','226','3',2,'Sale Id shift 164',0.00,0.00,0.00,1321.63,0.00,'2022-08-14 05:48:33','',''),(2432,'21','226','4',3,'Sale Id shift 164',0.00,0.00,0.00,69.06,0.00,'2022-08-14 05:48:33','',''),(2433,'21','226','1',1,'Sale Id shift 164',0.00,0.00,0.00,3686.55,0.00,'2022-08-14 05:48:33','',''),(2434,'21','226','1',1,'Sale Id shift 164',0.00,0.00,0.00,3349.24,0.00,'2022-08-14 05:48:33','',''),(2435,'21','226',NULL,1,'Sale Id shift 164',4759570.80,0.00,0.00,0.00,0.00,'2022-08-14 05:48:33','',''),(2436,'21','226',NULL,2,'Sale Id shift 164',2823473.70,0.00,0.00,0.00,0.00,'2022-08-14 05:48:33','',''),(2437,'21','226',NULL,3,'Sale Id shift 164',57665.10,0.00,0.00,0.00,0.00,'2022-08-14 05:48:33','',''),(2438,'21','226',NULL,2,'Reception corrector for bridging 217',0.00,0.00,0.00,15000.00,0.00,'2022-08-16 09:23:25','',''),(2439,'21','226','3',2,'Received from bridging 217',0.00,0.00,15000.00,0.00,0.00,'2022-08-16 09:23:25','',''),(2440,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5760000.00,32000.00,0.00,0.00,'2022-08-16 09:24:27','',''),(2441,'21','226',NULL,1,'Reception corrector for bridging 219',0.00,0.00,0.00,14000.00,0.00,'2022-08-16 09:25:20','',''),(2442,'21','226','2',1,'Received from bridging 219',0.00,0.00,14000.00,0.00,0.00,'2022-08-16 09:25:20','',''),(2443,'21','226',NULL,1,'Reception corrector for bridging 218',0.00,0.00,0.00,18000.00,0.00,'2022-08-16 09:25:20','',''),(2444,'21','226','1',1,'Received from bridging 218',0.00,0.00,18000.00,0.00,0.00,'2022-08-16 09:25:20','',''),(2445,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3240000.00,18000.00,0.00,0.00,'2022-08-16 09:39:04','',''),(2446,'21','226',NULL,1,'Reception corrector for bridging 220',0.00,0.00,0.00,18000.00,0.00,'2022-08-16 09:39:51','',''),(2447,'21','226','1',1,'Received from bridging 220',0.00,0.00,18000.00,0.00,0.00,'2022-08-16 09:39:51','',''),(2448,'21','226','1',1,'Sale Id shift 165',0.00,0.00,0.00,4464.81,0.00,'2022-08-16 13:28:30','',''),(2449,'21','226','2',1,'Sale Id shift 165',0.00,0.00,0.00,3687.91,0.00,'2022-08-16 13:28:30','',''),(2450,'21','226','1',1,'Sale Id shift 165',0.00,0.00,0.00,3487.80,0.00,'2022-08-16 13:28:30','',''),(2451,'21','226','2',1,'Sale Id shift 165',0.00,0.00,0.00,3839.06,0.00,'2022-08-16 13:28:30','',''),(2452,'21','226','2',1,'Sale Id shift 165',0.00,0.00,0.00,5243.84,0.00,'2022-08-16 13:28:30','',''),(2453,'21','226','2',1,'Sale Id shift 165',0.00,0.00,0.00,5341.15,0.00,'2022-08-16 13:28:30','',''),(2454,'21','226','3',2,'Sale Id shift 165',0.00,0.00,0.00,1688.04,0.00,'2022-08-16 13:28:30','',''),(2455,'21','226','3',2,'Sale Id shift 165',0.00,0.00,0.00,240.12,0.00,'2022-08-16 13:28:30','',''),(2456,'21','226','4',3,'Sale Id shift 165',0.00,0.00,0.00,16.35,0.00,'2022-08-16 13:28:30','',''),(2457,'21','226','1',1,'Sale Id shift 165',0.00,0.00,0.00,3615.52,0.00,'2022-08-16 13:28:30','',''),(2458,'21','226','1',1,'Sale Id shift 165',0.00,0.00,0.00,3366.37,0.00,'2022-08-16 13:28:30','',''),(2459,'21','226',NULL,1,'Sale Id shift 165',5948362.80,0.00,0.00,0.00,0.00,'2022-08-16 13:28:30','',''),(2460,'21','226',NULL,2,'Sale Id shift 165',1561809.60,0.00,0.00,0.00,0.00,'2022-08-16 13:28:30','',''),(2461,'21','226',NULL,3,'Sale Id shift 165',13652.25,0.00,0.00,0.00,0.00,'2022-08-16 13:28:30','',''),(2462,'21','226','4',3,'Sale Id shift 166',0.00,0.00,0.00,106.45,0.00,'2022-08-16 14:24:14','',''),(2463,'21','226',NULL,3,'Sale Id shift 166',90482.50,0.00,0.00,0.00,0.00,'2022-08-16 14:24:14','',''),(2464,'21','226','3',2,'Sale Id shift 167',0.00,0.00,0.00,1482.35,0.00,'2022-08-16 14:34:31','',''),(2465,'21','226','3',2,'Sale Id shift 167',0.00,0.00,0.00,1756.70,0.00,'2022-08-16 14:34:31','',''),(2466,'21','226','4',3,'Sale Id shift 167',0.00,0.00,0.00,80.05,0.00,'2022-08-16 14:34:31','',''),(2467,'21','226',NULL,2,'Sale Id shift 167',2623630.50,0.00,0.00,0.00,0.00,'2022-08-16 14:34:31','',''),(2468,'21','226',NULL,3,'Sale Id shift 167',68042.50,0.00,0.00,0.00,0.00,'2022-08-16 14:34:31','',''),(2469,'21','226','1',1,'Sale Id shift 168',0.00,0.00,0.00,5191.80,0.00,'2022-08-16 14:41:23','',''),(2470,'21','226','2',1,'Sale Id shift 168',0.00,0.00,0.00,3154.18,0.00,'2022-08-16 14:41:23','',''),(2471,'21','226','2',1,'Sale Id shift 168',0.00,0.00,0.00,2771.74,0.00,'2022-08-16 14:41:23','',''),(2472,'21','226','2',1,'Sale Id shift 168',0.00,0.00,0.00,117.41,0.00,'2022-08-16 14:41:23','',''),(2473,'21','226','1',1,'Sale Id shift 168',0.00,0.00,0.00,3974.93,0.00,'2022-08-16 14:41:23','',''),(2474,'21','226','2',1,'Sale Id shift 168',0.00,0.00,0.00,193.56,0.00,'2022-08-16 14:41:23','',''),(2475,'21','226','2',1,'Sale Id shift 168',0.00,0.00,0.00,3310.41,0.00,'2022-08-16 14:41:23','',''),(2476,'21','226','2',1,'Sale Id shift 168',0.00,0.00,0.00,3275.54,0.00,'2022-08-16 14:41:23','',''),(2477,'21','226','3',2,'Sale Id shift 168',0.00,0.00,0.00,1005.43,0.00,'2022-08-16 14:41:23','',''),(2478,'21','226','3',2,'Sale Id shift 168',0.00,0.00,0.00,2717.71,0.00,'2022-08-16 14:41:23','',''),(2479,'21','226','4',3,'Sale Id shift 168',0.00,0.00,0.00,100.48,0.00,'2022-08-16 14:41:23','',''),(2480,'21','226','1',1,'Sale Id shift 168',0.00,0.00,0.00,4479.62,0.00,'2022-08-16 14:41:23','',''),(2481,'21','226','1',1,'Sale Id shift 168',0.00,0.00,0.00,4091.68,0.00,'2022-08-16 14:41:23','',''),(2482,'21','226',NULL,1,'Sale Id shift 168',5500956.60,0.00,0.00,0.00,0.00,'2022-08-16 14:41:23','',''),(2483,'21','226',NULL,2,'Sale Id shift 168',3015743.40,0.00,0.00,0.00,0.00,'2022-08-16 14:41:23','',''),(2484,'21','226',NULL,3,'Sale Id shift 168',85408.00,0.00,0.00,0.00,0.00,'2022-08-16 14:41:23','',''),(2485,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,17910.72,0.00,'2022-08-16 14:55:33','',''),(2486,'21','226','1',0,'Inventory adjustment from tank dipping to 19000',0.00,0.00,19000.00,0.00,0.00,'2022-08-16 14:55:33','',''),(2487,'21','226','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,1348.92,0.00,'2022-08-16 14:57:39','',''),(2488,'21','226','2',0,'Inventory adjustment from tank dipping to 2050',0.00,0.00,2050.00,0.00,0.00,'2022-08-16 14:57:39','',''),(2489,'21','226','1',1,'Sale Id shift 169',0.00,0.00,0.00,4642.79,0.00,'2022-08-16 15:15:40','',''),(2490,'21','226','1',1,'Sale Id shift 169',0.00,0.00,0.00,4222.36,0.00,'2022-08-16 15:15:40','',''),(2491,'21','226','2',1,'Sale Id shift 169',0.00,0.00,0.00,960.16,0.00,'2022-08-16 15:15:40','',''),(2492,'21','226','2',1,'Sale Id shift 169',0.00,0.00,0.00,1087.27,0.00,'2022-08-16 15:15:40','',''),(2493,'21','226','3',2,'Sale Id shift 169',0.00,0.00,0.00,2523.43,0.00,'2022-08-16 15:15:40','',''),(2494,'21','226','3',2,'Sale Id shift 169',0.00,0.00,0.00,1346.89,0.00,'2022-08-16 15:15:40','',''),(2495,'21','226','4',3,'Sale Id shift 169',0.00,0.00,0.00,189.42,0.00,'2022-08-16 15:15:40','',''),(2496,'21','226','1',1,'Sale Id shift 169',0.00,0.00,0.00,4732.87,0.00,'2022-08-16 15:15:40','',''),(2497,'21','226','1',1,'Sale Id shift 169',0.00,0.00,0.00,4839.66,0.00,'2022-08-16 15:15:40','',''),(2498,'21','226',NULL,2,'Sale Id shift 169',3134959.20,0.00,0.00,0.00,0.00,'2022-08-16 15:15:40','',''),(2499,'21','226',NULL,3,'Sale Id shift 169',161007.00,0.00,0.00,0.00,0.00,'2022-08-16 15:15:40','',''),(2500,'21','226',NULL,1,'Sale Id shift 169',3687319.80,0.00,0.00,0.00,0.00,'2022-08-16 15:15:40','',''),(2501,'21','226','3',2,'Sale Id shift 170',0.00,0.00,0.00,1294.71,0.00,'2022-08-19 15:06:46','',''),(2502,'21','226','3',2,'Sale Id shift 170',0.00,0.00,0.00,1754.05,0.00,'2022-08-19 15:06:46','',''),(2503,'21','226','4',3,'Sale Id shift 170',0.00,0.00,0.00,111.67,0.00,'2022-08-19 15:06:46','',''),(2504,'21','226',NULL,2,'Sale Id shift 170',2469495.60,0.00,0.00,0.00,0.00,'2022-08-19 15:06:46','',''),(2505,'21','226',NULL,3,'Sale Id shift 170',94919.50,0.00,0.00,0.00,0.00,'2022-08-19 15:06:46','',''),(2506,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-08-19 15:09:39','',''),(2507,'21','226',NULL,1,'Reception corrector for bridging 222',0.00,0.00,0.00,15000.00,0.00,'2022-08-19 15:10:59','',''),(2508,'21','226','2',1,'Received from bridging 222',0.00,0.00,15000.00,0.00,0.00,'2022-08-19 15:10:59','',''),(2509,'21','226',NULL,1,'Reception corrector for bridging 221',0.00,0.00,0.00,15000.00,0.00,'2022-08-19 15:10:59','',''),(2510,'21','226','1',1,'Received from bridging 221',0.00,0.00,15000.00,0.00,0.00,'2022-08-19 15:10:59','',''),(2511,'21','226','1',1,'Sale Id shift 171',0.00,0.00,0.00,3485.11,0.00,'2022-08-19 15:28:29','',''),(2512,'21','226','2',1,'Sale Id shift 171',0.00,0.00,0.00,4028.97,0.00,'2022-08-19 15:28:29','',''),(2513,'21','226','1',1,'Sale Id shift 171',0.00,0.00,0.00,2799.37,0.00,'2022-08-19 15:28:29','',''),(2514,'21','226','2',1,'Sale Id shift 171',0.00,0.00,0.00,3523.05,0.00,'2022-08-19 15:28:29','',''),(2515,'21','226','2',1,'Sale Id shift 171',0.00,0.00,0.00,3551.03,0.00,'2022-08-19 15:28:29','',''),(2516,'21','226','2',1,'Sale Id shift 171',0.00,0.00,0.00,3769.17,0.00,'2022-08-19 15:28:29','',''),(2517,'21','226','3',2,'Sale Id shift 171',0.00,0.00,0.00,1804.53,0.00,'2022-08-19 15:28:29','',''),(2518,'21','226','3',2,'Sale Id shift 171',0.00,0.00,0.00,2018.48,0.00,'2022-08-19 15:28:29','',''),(2519,'21','226','4',3,'Sale Id shift 171',0.00,0.00,0.00,97.38,0.00,'2022-08-19 15:28:29','',''),(2520,'21','226','1',1,'Sale Id shift 171',0.00,0.00,0.00,5051.69,0.00,'2022-08-19 15:28:29','',''),(2521,'21','226','1',1,'Sale Id shift 171',0.00,0.00,0.00,3706.32,0.00,'2022-08-19 15:28:29','',''),(2522,'21','226',NULL,1,'Sale Id shift 171',5384647.80,0.00,0.00,0.00,0.00,'2022-08-19 15:28:29','',''),(2523,'21','226',NULL,2,'Sale Id shift 171',3096638.10,0.00,0.00,0.00,0.00,'2022-08-19 15:28:29','',''),(2524,'21','226',NULL,3,'Sale Id shift 171',82773.00,0.00,0.00,0.00,0.00,'2022-08-19 15:28:29','',''),(2525,'21','226','4',3,'Sale Id shift 172',0.00,0.00,0.00,47.47,0.00,'2022-08-19 16:16:17','',''),(2526,'21','226',NULL,3,'Sale Id shift 172',40349.50,0.00,0.00,0.00,0.00,'2022-08-19 16:16:17','',''),(2527,'21','226','3',2,'Sale Id shift 173',0.00,0.00,0.00,1819.35,0.00,'2022-08-22 11:28:36','',''),(2528,'21','226','3',2,'Sale Id shift 173',0.00,0.00,0.00,1679.58,0.00,'2022-08-22 11:28:36','',''),(2529,'21','226','4',3,'Sale Id shift 173',0.00,0.00,0.00,56.42,0.00,'2022-08-22 11:28:36','',''),(2530,'21','226',NULL,2,'Sale Id shift 173',2834133.30,0.00,0.00,0.00,0.00,'2022-08-22 11:28:36','',''),(2531,'21','226',NULL,3,'Sale Id shift 173',48521.20,0.00,0.00,0.00,0.00,'2022-08-22 11:28:36','',''),(2532,'21','226','3',2,'Sale Id shift 174',0.00,0.00,0.00,78.43,0.00,'2022-08-22 11:37:56','',''),(2533,'21','226','3',2,'Sale Id shift 174',0.00,0.00,0.00,408.94,0.00,'2022-08-22 11:37:56','',''),(2534,'21','226',NULL,2,'Sale Id shift 174',389896.00,0.00,0.00,0.00,0.00,'2022-08-22 11:37:56','',''),(2535,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5040000.00,28000.00,0.00,0.00,'2022-08-22 11:40:38','',''),(2536,'21','226',NULL,1,'Reception corrector for bridging 224',0.00,0.00,0.00,12000.00,0.00,'2022-08-22 11:42:08','',''),(2537,'21','226','2',1,'Received from bridging 224',0.00,0.00,12000.00,0.00,0.00,'2022-08-22 11:42:08','',''),(2538,'21','226',NULL,1,'Reception corrector for bridging 223',0.00,0.00,0.00,16000.00,0.00,'2022-08-22 11:42:08','',''),(2539,'21','226','1',1,'Received from bridging 223',0.00,0.00,16000.00,0.00,0.00,'2022-08-22 11:42:08','',''),(2540,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-08-22 11:43:05','',''),(2541,'21','226',NULL,1,'Reception corrector for bridging 226',0.00,0.00,0.00,15000.00,0.00,'2022-08-22 11:43:58','',''),(2542,'21','226','2',1,'Received from bridging 226',0.00,0.00,15000.00,0.00,0.00,'2022-08-22 11:43:58','',''),(2543,'21','226',NULL,1,'Reception corrector for bridging 225',0.00,0.00,0.00,15000.00,0.00,'2022-08-22 11:43:58','',''),(2544,'21','226','1',1,'Received from bridging 225',0.00,0.00,15000.00,0.00,0.00,'2022-08-22 11:43:58','',''),(2545,'21','226','2',1,'Sale Id shift 175',0.00,0.00,0.00,107.92,0.00,'2022-08-22 11:46:03','',''),(2546,'21','226','2',1,'Sale Id shift 175',0.00,0.00,0.00,99.31,0.00,'2022-08-22 11:46:03','',''),(2547,'21','226','2',1,'Sale Id shift 175',0.00,0.00,0.00,146.84,0.00,'2022-08-22 11:46:03','',''),(2548,'21','226','2',1,'Sale Id shift 175',0.00,0.00,0.00,205.84,0.00,'2022-08-22 11:46:03','',''),(2549,'21','226',NULL,1,'Sale Id shift 175',100783.80,0.00,0.00,0.00,0.00,'2022-08-22 11:46:03','',''),(2550,'21','226','3',2,'Sale Id shift 176',0.00,0.00,0.00,1483.90,0.00,'2022-08-22 11:52:46','',''),(2551,'21','226','3',2,'Sale Id shift 176',0.00,0.00,0.00,2287.05,0.00,'2022-08-22 11:52:46','',''),(2552,'21','226','4',3,'Sale Id shift 176',0.00,0.00,0.00,110.37,0.00,'2022-08-22 11:52:46','',''),(2553,'21','226',NULL,2,'Sale Id shift 176',3016760.00,0.00,0.00,0.00,0.00,'2022-08-22 11:52:46','',''),(2554,'21','226',NULL,3,'Sale Id shift 176',94918.20,0.00,0.00,0.00,0.00,'2022-08-22 11:52:46','',''),(2555,'21','226','3',2,'Sale Id shift 177',0.00,0.00,0.00,698.08,0.00,'2022-08-22 12:00:21','',''),(2556,'21','226','3',2,'Sale Id shift 177',0.00,0.00,0.00,1283.34,0.00,'2022-08-22 12:00:21','',''),(2557,'21','226','4',3,'Sale Id shift 177',0.00,0.00,0.00,87.22,0.00,'2022-08-22 12:00:21','',''),(2558,'21','226',NULL,2,'Sale Id shift 177',1585136.00,0.00,0.00,0.00,0.00,'2022-08-22 12:00:21','',''),(2559,'21','226',NULL,3,'Sale Id shift 177',75009.20,0.00,0.00,0.00,0.00,'2022-08-22 12:00:21','',''),(2560,'21','226','1',1,'Sale Id shift 178',0.00,0.00,0.00,4089.12,0.00,'2022-08-22 12:24:29','',''),(2561,'21','226','2',1,'Sale Id shift 178',0.00,0.00,0.00,1213.02,0.00,'2022-08-22 12:24:29','',''),(2562,'21','226','2',1,'Sale Id shift 178',0.00,0.00,0.00,925.51,0.00,'2022-08-22 12:24:29','',''),(2563,'21','226','2',1,'Sale Id shift 178',0.00,0.00,0.00,1065.62,0.00,'2022-08-22 12:24:29','',''),(2564,'21','226','1',1,'Sale Id shift 178',0.00,0.00,0.00,3495.09,0.00,'2022-08-22 12:24:29','',''),(2565,'21','226','2',1,'Sale Id shift 178',0.00,0.00,0.00,1268.92,0.00,'2022-08-22 12:24:29','',''),(2566,'21','226','2',1,'Sale Id shift 178',0.00,0.00,0.00,732.06,0.00,'2022-08-22 12:24:29','',''),(2567,'21','226','2',1,'Sale Id shift 178',0.00,0.00,0.00,1160.18,0.00,'2022-08-22 12:24:29','',''),(2568,'21','226','2',1,'Sale Id shift 178',0.00,0.00,0.00,2906.96,0.00,'2022-08-22 12:24:29','',''),(2569,'21','226','2',1,'Sale Id shift 178',0.00,0.00,0.00,2602.71,0.00,'2022-08-22 12:24:29','',''),(2570,'21','226','3',2,'Sale Id shift 178',0.00,0.00,0.00,752.91,0.00,'2022-08-22 12:24:29','',''),(2571,'21','226','3',2,'Sale Id shift 178',0.00,0.00,0.00,3086.53,0.00,'2022-08-22 12:24:29','',''),(2572,'21','226','4',3,'Sale Id shift 178',0.00,0.00,0.00,1800.33,0.00,'2022-08-22 12:24:29','',''),(2573,'21','226','1',1,'Sale Id shift 178',0.00,0.00,0.00,1923.35,0.00,'2022-08-22 12:24:29','',''),(2574,'21','226','4',3,'Sale Id shift 178',0.00,0.00,0.00,10.76,0.00,'2022-08-22 12:24:29','',''),(2575,'21','226','1',1,'Sale Id shift 178',0.00,0.00,0.00,1.06,0.00,'2022-08-22 12:24:29','',''),(2576,'21','226','1',1,'Sale Id shift 178',0.00,0.00,0.00,3669.90,0.00,'2022-08-22 12:24:29','',''),(2577,'21','226','1',1,'Sale Id shift 178',0.00,0.00,0.00,2760.04,0.00,'2022-08-22 12:24:29','',''),(2578,'21','226',NULL,1,'Sale Id shift 178',5006437.20,0.00,0.00,0.00,0.00,'2022-08-22 12:24:29','',''),(2579,'21','226',NULL,2,'Sale Id shift 178',3071552.00,0.00,0.00,0.00,0.00,'2022-08-22 12:24:29','',''),(2580,'21','226',NULL,3,'Sale Id shift 178',1557537.40,0.00,0.00,0.00,0.00,'2022-08-22 12:24:29','',''),(2581,'21','226','1',1,'Sale Id shift 179',0.00,0.00,0.00,4367.16,0.00,'2022-09-01 09:40:09','',''),(2582,'21','226','2',1,'Sale Id shift 179',0.00,0.00,0.00,491.29,0.00,'2022-09-01 09:40:09','',''),(2583,'21','226','2',1,'Sale Id shift 179',0.00,0.00,0.00,510.22,0.00,'2022-09-01 09:40:09','',''),(2584,'21','226','2',1,'Sale Id shift 179',0.00,0.00,0.00,3682.38,0.00,'2022-09-01 09:40:09','',''),(2585,'21','226','1',1,'Sale Id shift 179',0.00,0.00,0.00,3292.20,0.00,'2022-09-01 09:40:09','',''),(2586,'21','226','2',1,'Sale Id shift 179',0.00,0.00,0.00,3330.27,0.00,'2022-09-01 09:40:09','',''),(2587,'21','226','2',1,'Sale Id shift 179',0.00,0.00,0.00,236.31,0.00,'2022-09-01 09:40:09','',''),(2588,'21','226','2',1,'Sale Id shift 179',0.00,0.00,0.00,315.22,0.00,'2022-09-01 09:40:09','',''),(2589,'21','226','2',1,'Sale Id shift 179',0.00,0.00,0.00,2316.13,0.00,'2022-09-01 09:40:09','',''),(2590,'21','226','2',1,'Sale Id shift 179',0.00,0.00,0.00,2710.79,0.00,'2022-09-01 09:40:09','',''),(2591,'21','226','3',2,'Sale Id shift 179',0.00,0.00,0.00,1909.38,0.00,'2022-09-01 09:40:09','',''),(2592,'21','226','3',2,'Sale Id shift 179',0.00,0.00,0.00,3475.61,0.00,'2022-09-01 09:40:09','',''),(2593,'21','226','4',3,'Sale Id shift 179',0.00,0.00,0.00,149.25,0.00,'2022-09-01 09:40:09','',''),(2594,'21','226','1',1,'Sale Id shift 179',0.00,0.00,0.00,4289.61,0.00,'2022-09-01 09:40:09','',''),(2595,'21','226','1',1,'Sale Id shift 179',0.00,0.00,0.00,3088.98,0.00,'2022-09-01 09:40:09','',''),(2596,'21','226',NULL,1,'Sale Id shift 179',5153500.80,0.00,0.00,0.00,0.00,'2022-09-01 09:40:09','',''),(2597,'21','226',NULL,2,'Sale Id shift 179',4307992.00,0.00,0.00,0.00,0.00,'2022-09-01 09:40:09','',''),(2598,'21','226',NULL,3,'Sale Id shift 179',128355.00,0.00,0.00,0.00,0.00,'2022-09-01 09:40:09','',''),(2599,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24000000.00,30000.00,0.00,0.00,'2022-09-03 08:21:04','',''),(2600,'21','226',NULL,2,'Reception corrector for bridging 227',0.00,0.00,0.00,30000.00,0.00,'2022-09-03 08:21:43','',''),(2601,'21','226','3',2,'Received from bridging 227',0.00,0.00,30000.00,0.00,0.00,'2022-09-03 08:21:43','',''),(2602,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5399640.00,29998.00,0.00,0.00,'2022-09-03 08:21:55','',''),(2603,'21','226',NULL,1,'Reception corrector for bridging 229',0.00,0.00,0.00,14999.00,0.00,'2022-09-03 08:23:09','',''),(2604,'21','226','2',1,'Received from bridging 229',0.00,0.00,14999.00,0.00,0.00,'2022-09-03 08:23:09','',''),(2605,'21','226',NULL,1,'Reception corrector for bridging 228',0.00,0.00,0.00,14999.00,0.00,'2022-09-03 08:23:09','',''),(2606,'21','226','1',1,'Received from bridging 228',0.00,0.00,14999.00,0.00,0.00,'2022-09-03 08:23:09','',''),(2607,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-09-03 08:34:05','',''),(2608,'21','226',NULL,1,'Reception corrector for bridging 231',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 08:34:51','',''),(2609,'21','226','2',1,'Received from bridging 231',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 08:34:51','',''),(2610,'21','226',NULL,1,'Reception corrector for bridging 230',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 08:34:51','',''),(2611,'21','226','1',1,'Received from bridging 230',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 08:34:51','',''),(2612,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-09-03 08:35:46','',''),(2613,'21','226','1',1,'Sale Id shift 180',0.00,0.00,0.00,4040.25,0.00,'2022-09-03 08:36:17','',''),(2614,'21','226','2',1,'Sale Id shift 180',0.00,0.00,0.00,1215.65,0.00,'2022-09-03 08:36:17','',''),(2615,'21','226','2',1,'Sale Id shift 180',0.00,0.00,0.00,814.82,0.00,'2022-09-03 08:36:17','',''),(2616,'21','226','2',1,'Sale Id shift 180',0.00,0.00,0.00,2389.79,0.00,'2022-09-03 08:36:17','',''),(2617,'21','226','1',1,'Sale Id shift 180',0.00,0.00,0.00,2827.95,0.00,'2022-09-03 08:36:17','',''),(2618,'21','226','2',1,'Sale Id shift 180',0.00,0.00,0.00,2208.03,0.00,'2022-09-03 08:36:17','',''),(2619,'21','226','2',1,'Sale Id shift 180',0.00,0.00,0.00,1046.73,0.00,'2022-09-03 08:36:17','',''),(2620,'21','226','2',1,'Sale Id shift 180',0.00,0.00,0.00,773.24,0.00,'2022-09-03 08:36:17','',''),(2621,'21','226','2',1,'Sale Id shift 180',0.00,0.00,0.00,1903.04,0.00,'2022-09-03 08:36:17','',''),(2622,'21','226','2',1,'Sale Id shift 180',0.00,0.00,0.00,2153.61,0.00,'2022-09-03 08:36:17','',''),(2623,'21','226','3',2,'Sale Id shift 180',0.00,0.00,0.00,1127.28,0.00,'2022-09-03 08:36:17','',''),(2624,'21','226','3',2,'Sale Id shift 180',0.00,0.00,0.00,1505.72,0.00,'2022-09-03 08:36:17','',''),(2625,'21','226','4',3,'Sale Id shift 180',0.00,0.00,0.00,106.79,0.00,'2022-09-03 08:36:17','',''),(2626,'21','226','1',1,'Sale Id shift 180',0.00,0.00,0.00,1672.21,0.00,'2022-09-03 08:36:17','',''),(2627,'21','226','1',1,'Sale Id shift 180',0.00,0.00,0.00,3026.89,0.00,'2022-09-03 08:36:17','',''),(2628,'21','226','1',1,'Sale Id shift 180',0.00,0.00,0.00,2168.66,0.00,'2022-09-03 08:36:17','',''),(2629,'21','226',NULL,2,'Sale Id shift 180',2106400.00,0.00,0.00,0.00,0.00,'2022-09-03 08:36:17','',''),(2630,'21','226',NULL,3,'Sale Id shift 180',91839.40,0.00,0.00,0.00,0.00,'2022-09-03 08:36:17','',''),(2631,'21','226',NULL,1,'Sale Id shift 180',4723356.60,0.00,0.00,0.00,0.00,'2022-09-03 08:36:17','',''),(2632,'21','226',NULL,1,'Reception corrector for bridging 233',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 08:47:50','',''),(2633,'21','226','2',1,'Received from bridging 233',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 08:47:50','',''),(2634,'21','226',NULL,1,'Reception corrector for bridging 232',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 08:47:50','',''),(2635,'21','226','1',1,'Received from bridging 232',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 08:47:50','',''),(2636,'21','226','1',1,'Sale Id shift 181',0.00,0.00,0.00,3712.42,0.00,'2022-09-03 08:48:58','',''),(2637,'21','226','2',1,'Sale Id shift 181',0.00,0.00,0.00,2190.49,0.00,'2022-09-03 08:48:58','',''),(2638,'21','226','2',1,'Sale Id shift 181',0.00,0.00,0.00,2284.10,0.00,'2022-09-03 08:48:58','',''),(2639,'21','226','2',1,'Sale Id shift 181',0.00,0.00,0.00,2165.86,0.00,'2022-09-03 08:48:58','',''),(2640,'21','226','1',1,'Sale Id shift 181',0.00,0.00,0.00,1939.76,0.00,'2022-09-03 08:48:58','',''),(2641,'21','226','2',1,'Sale Id shift 181',0.00,0.00,0.00,2202.63,0.00,'2022-09-03 08:48:58','',''),(2642,'21','226','2',1,'Sale Id shift 181',0.00,0.00,0.00,1681.62,0.00,'2022-09-03 08:48:58','',''),(2643,'21','226','2',1,'Sale Id shift 181',0.00,0.00,0.00,1879.54,0.00,'2022-09-03 08:48:58','',''),(2644,'21','226','2',1,'Sale Id shift 181',0.00,0.00,0.00,2117.84,0.00,'2022-09-03 08:48:58','',''),(2645,'21','226','2',1,'Sale Id shift 181',0.00,0.00,0.00,1836.21,0.00,'2022-09-03 08:48:58','',''),(2646,'21','226','3',2,'Sale Id shift 181',0.00,0.00,0.00,2391.40,0.00,'2022-09-03 08:48:58','',''),(2647,'21','226','3',2,'Sale Id shift 181',0.00,0.00,0.00,500.94,0.00,'2022-09-03 08:48:58','',''),(2648,'21','226','4',3,'Sale Id shift 181',0.00,0.00,0.00,77.88,0.00,'2022-09-03 08:48:58','',''),(2649,'21','226','1',1,'Sale Id shift 181',0.00,0.00,0.00,3909.87,0.00,'2022-09-03 08:48:58','',''),(2650,'21','226','1',1,'Sale Id shift 181',0.00,0.00,0.00,867.57,0.00,'2022-09-03 08:48:58','',''),(2651,'21','226','1',1,'Sale Id shift 181',0.00,0.00,0.00,2688.37,0.00,'2022-09-03 08:48:58','',''),(2652,'21','226','1',1,'Sale Id shift 181',0.00,0.00,0.00,1671.03,0.00,'2022-09-03 08:48:58','',''),(2653,'21','226',NULL,1,'Sale Id shift 181',5606515.80,0.00,0.00,0.00,0.00,'2022-09-03 08:48:58','',''),(2654,'21','226',NULL,2,'Sale Id shift 181',2313872.00,0.00,0.00,0.00,0.00,'2022-09-03 08:48:58','',''),(2655,'21','226',NULL,3,'Sale Id shift 181',66976.80,0.00,0.00,0.00,0.00,'2022-09-03 08:48:58','',''),(2656,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-09-03 08:52:51','',''),(2657,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-09-03 08:54:33','',''),(2658,'21','226',NULL,1,'Reception corrector for bridging 235',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 08:55:20','',''),(2659,'21','226','2',1,'Received from bridging 235',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 08:55:20','',''),(2660,'21','226',NULL,1,'Reception corrector for bridging 234',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 08:55:20','',''),(2661,'21','226','1',1,'Received from bridging 234',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 08:55:20','',''),(2662,'21','226',NULL,1,'Reception corrector for bridging 236',0.00,0.00,0.00,30000.00,0.00,'2022-09-03 08:55:35','',''),(2663,'21','226','1',1,'Received from bridging 236',0.00,0.00,30000.00,0.00,0.00,'2022-09-03 08:55:35','',''),(2664,'21','226','1',1,'Returned bridging 236',0.00,0.00,0.00,30000.00,0.00,'2022-09-03 08:56:52','',''),(2665,'21','226',NULL,1,'Reception Return corrector for bridging 236',0.00,0.00,30000.00,0.00,0.00,'2022-09-03 08:56:52','',''),(2666,'21','226',NULL,1,'Returned purchase #157 to AYM SHAFA NIGERIA. LTD',5400000.00,0.00,0.00,30000.00,0.00,'2022-09-03 08:57:11','',''),(2667,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-03 09:05:20','',''),(2668,'21','226','1',1,'Sale Id shift 182',0.00,0.00,0.00,3896.02,0.00,'2022-09-03 09:05:27','',''),(2669,'21','226','2',1,'Sale Id shift 182',0.00,0.00,0.00,2691.64,0.00,'2022-09-03 09:05:27','',''),(2670,'21','226','2',1,'Sale Id shift 182',0.00,0.00,0.00,2394.09,0.00,'2022-09-03 09:05:27','',''),(2671,'21','226','2',1,'Sale Id shift 182',0.00,0.00,0.00,2402.71,0.00,'2022-09-03 09:05:27','',''),(2672,'21','226','1',1,'Sale Id shift 182',0.00,0.00,0.00,2301.25,0.00,'2022-09-03 09:05:27','',''),(2673,'21','226','2',1,'Sale Id shift 182',0.00,0.00,0.00,2213.87,0.00,'2022-09-03 09:05:27','',''),(2674,'21','226','2',1,'Sale Id shift 182',0.00,0.00,0.00,1745.35,0.00,'2022-09-03 09:05:27','',''),(2675,'21','226','2',1,'Sale Id shift 182',0.00,0.00,0.00,2307.77,0.00,'2022-09-03 09:05:27','',''),(2676,'21','226','2',1,'Sale Id shift 182',0.00,0.00,0.00,1430.28,0.00,'2022-09-03 09:05:27','',''),(2677,'21','226','2',1,'Sale Id shift 182',0.00,0.00,0.00,2615.66,0.00,'2022-09-03 09:05:27','',''),(2678,'21','226','3',2,'Sale Id shift 182',0.00,0.00,0.00,1159.77,0.00,'2022-09-03 09:05:27','',''),(2679,'21','226','3',2,'Sale Id shift 182',0.00,0.00,0.00,2757.31,0.00,'2022-09-03 09:05:27','',''),(2680,'21','226','4',3,'Sale Id shift 182',0.00,0.00,0.00,84.42,0.00,'2022-09-03 09:05:27','',''),(2681,'21','226','1',1,'Sale Id shift 182',0.00,0.00,0.00,3980.32,0.00,'2022-09-03 09:05:27','',''),(2682,'21','226','1',1,'Sale Id shift 182',0.00,0.00,0.00,839.62,0.00,'2022-09-03 09:05:27','',''),(2683,'21','226','1',1,'Sale Id shift 182',0.00,0.00,0.00,2699.12,0.00,'2022-09-03 09:05:27','',''),(2684,'21','226','1',1,'Sale Id shift 182',0.00,0.00,0.00,1579.57,0.00,'2022-09-03 09:05:27','',''),(2685,'21','226',NULL,2,'Sale Id shift 182',3133664.00,0.00,0.00,0.00,0.00,'2022-09-03 09:05:27','',''),(2686,'21','226',NULL,3,'Sale Id shift 182',72601.20,0.00,0.00,0.00,0.00,'2022-09-03 09:05:27','',''),(2687,'21','226',NULL,1,'Sale Id shift 182',5957508.60,0.00,0.00,0.00,0.00,'2022-09-03 09:05:27','',''),(2688,'21','226',NULL,1,'Reception corrector for bridging 239',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 09:06:13','',''),(2689,'21','226','2',1,'Received from bridging 239',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 09:06:13','',''),(2690,'21','226',NULL,1,'Reception corrector for bridging 238',0.00,0.00,0.00,30000.00,0.00,'2022-09-03 09:06:13','',''),(2691,'21','226','1',1,'Received from bridging 238',0.00,0.00,30000.00,0.00,0.00,'2022-09-03 09:06:13','',''),(2692,'21','226','1',1,'Sale Id shift 183',0.00,0.00,0.00,363.59,0.00,'2022-09-03 09:13:29','',''),(2693,'21','226','1',1,'Sale Id shift 183',0.00,0.00,0.00,249.76,0.00,'2022-09-03 09:13:29','',''),(2694,'21','226','3',2,'Sale Id shift 183',0.00,0.00,0.00,400.00,0.00,'2022-09-03 09:13:29','',''),(2695,'21','226','3',2,'Sale Id shift 183',0.00,0.00,0.00,2656.93,0.00,'2022-09-03 09:13:29','',''),(2696,'21','226','4',3,'Sale Id shift 183',0.00,0.00,0.00,111.88,0.00,'2022-09-03 09:13:29','',''),(2697,'21','226','1',1,'Sale Id shift 183',0.00,0.00,0.00,348.00,0.00,'2022-09-03 09:13:29','',''),(2698,'21','226',NULL,2,'Sale Id shift 183',2445544.00,0.00,0.00,0.00,0.00,'2022-09-03 09:13:29','',''),(2699,'21','226',NULL,3,'Sale Id shift 183',96216.80,0.00,0.00,0.00,0.00,'2022-09-03 09:13:29','',''),(2700,'21','226',NULL,1,'Sale Id shift 183',173043.00,0.00,0.00,0.00,0.00,'2022-09-03 09:13:29','',''),(2701,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7200000.00,40000.00,0.00,0.00,'2022-09-03 09:24:43','',''),(2702,'21','226','1',1,'Sale Id shift 184',0.00,0.00,0.00,2985.38,0.00,'2022-09-03 09:24:58','',''),(2703,'21','226','2',1,'Sale Id shift 184',0.00,0.00,0.00,2083.84,0.00,'2022-09-03 09:24:58','',''),(2704,'21','226','2',1,'Sale Id shift 184',0.00,0.00,0.00,1432.74,0.00,'2022-09-03 09:24:58','',''),(2705,'21','226','2',1,'Sale Id shift 184',0.00,0.00,0.00,1932.83,0.00,'2022-09-03 09:24:58','',''),(2706,'21','226','1',1,'Sale Id shift 184',0.00,0.00,0.00,1673.46,0.00,'2022-09-03 09:24:58','',''),(2707,'21','226','2',1,'Sale Id shift 184',0.00,0.00,0.00,2545.23,0.00,'2022-09-03 09:24:58','',''),(2708,'21','226','2',1,'Sale Id shift 184',0.00,0.00,0.00,1624.91,0.00,'2022-09-03 09:24:58','',''),(2709,'21','226','2',1,'Sale Id shift 184',0.00,0.00,0.00,1990.88,0.00,'2022-09-03 09:24:58','',''),(2710,'21','226','2',1,'Sale Id shift 184',0.00,0.00,0.00,1424.39,0.00,'2022-09-03 09:24:58','',''),(2711,'21','226','2',1,'Sale Id shift 184',0.00,0.00,0.00,1938.84,0.00,'2022-09-03 09:24:58','',''),(2712,'21','226','3',2,'Sale Id shift 184',0.00,0.00,0.00,1246.32,0.00,'2022-09-03 09:24:58','',''),(2713,'21','226','3',2,'Sale Id shift 184',0.00,0.00,0.00,3465.92,0.00,'2022-09-03 09:24:58','',''),(2714,'21','226','4',3,'Sale Id shift 184',0.00,0.00,0.00,94.29,0.00,'2022-09-03 09:24:58','',''),(2715,'21','226','1',1,'Sale Id shift 184',0.00,0.00,0.00,3722.39,0.00,'2022-09-03 09:24:58','',''),(2716,'21','226','1',1,'Sale Id shift 184',0.00,0.00,0.00,2084.94,0.00,'2022-09-03 09:24:58','',''),(2717,'21','226','1',1,'Sale Id shift 184',0.00,0.00,0.00,2732.80,0.00,'2022-09-03 09:24:58','',''),(2718,'21','226','1',1,'Sale Id shift 184',0.00,0.00,0.00,2377.88,0.00,'2022-09-03 09:24:58','',''),(2719,'21','226',NULL,2,'Sale Id shift 184',3769792.00,0.00,0.00,0.00,0.00,'2022-09-03 09:24:58','',''),(2720,'21','226',NULL,3,'Sale Id shift 184',81089.40,0.00,0.00,0.00,0.00,'2022-09-03 09:24:58','',''),(2721,'21','226',NULL,1,'Sale Id shift 184',5499091.80,0.00,0.00,0.00,0.00,'2022-09-03 09:24:58','',''),(2722,'21','226',NULL,1,'Reception corrector for bridging 241',0.00,0.00,0.00,13500.00,0.00,'2022-09-03 09:25:46','',''),(2723,'21','226','2',1,'Received from bridging 241',0.00,0.00,13500.00,0.00,0.00,'2022-09-03 09:25:46','',''),(2724,'21','226',NULL,1,'Reception corrector for bridging 240',0.00,0.00,0.00,26500.00,0.00,'2022-09-03 09:25:46','',''),(2725,'21','226','1',1,'Received from bridging 240',0.00,0.00,26500.00,0.00,0.00,'2022-09-03 09:25:46','',''),(2726,'21','226','3',2,'Sale Id shift 185',0.00,0.00,0.00,469.37,0.00,'2022-09-03 09:31:05','',''),(2727,'21','226','3',2,'Sale Id shift 185',0.00,0.00,0.00,1707.53,0.00,'2022-09-03 09:31:05','',''),(2728,'21','226','4',3,'Sale Id shift 185',0.00,0.00,0.00,93.90,0.00,'2022-09-03 09:31:05','',''),(2729,'21','226',NULL,2,'Sale Id shift 185',1741520.00,0.00,0.00,0.00,0.00,'2022-09-03 09:31:05','',''),(2730,'21','226',NULL,3,'Sale Id shift 185',80754.00,0.00,0.00,0.00,0.00,'2022-09-03 09:31:05','',''),(2731,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-03 09:37:08','',''),(2732,'21','226','3',2,'Sale Id shift 186',0.00,0.00,0.00,1064.37,0.00,'2022-09-03 09:38:16','',''),(2733,'21','226','3',2,'Sale Id shift 186',0.00,0.00,0.00,1561.09,0.00,'2022-09-03 09:38:16','',''),(2734,'21','226','4',3,'Sale Id shift 186',0.00,0.00,0.00,240.56,0.00,'2022-09-03 09:38:16','',''),(2735,'21','226',NULL,2,'Sale Id shift 186',2100368.00,0.00,0.00,0.00,0.00,'2022-09-03 09:38:16','',''),(2736,'21','226',NULL,3,'Sale Id shift 186',206881.60,0.00,0.00,0.00,0.00,'2022-09-03 09:38:16','',''),(2737,'21','226',NULL,1,'Reception corrector for bridging 243',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 09:39:22','',''),(2738,'21','226','2',1,'Received from bridging 243',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 09:39:22','',''),(2739,'21','226',NULL,1,'Reception corrector for bridging 242',0.00,0.00,0.00,30000.00,0.00,'2022-09-03 09:39:22','',''),(2740,'21','226','1',1,'Received from bridging 242',0.00,0.00,30000.00,0.00,0.00,'2022-09-03 09:39:22','',''),(2741,'21','226','1',1,'Sale Id shift 187',0.00,0.00,0.00,5059.86,0.00,'2022-09-03 09:55:26','',''),(2742,'21','226','2',1,'Sale Id shift 187',0.00,0.00,0.00,2531.30,0.00,'2022-09-03 09:55:26','',''),(2743,'21','226','2',1,'Sale Id shift 187',0.00,0.00,0.00,1974.01,0.00,'2022-09-03 09:55:26','',''),(2744,'21','226','2',1,'Sale Id shift 187',0.00,0.00,0.00,1441.96,0.00,'2022-09-03 09:55:26','',''),(2745,'21','226','1',1,'Sale Id shift 187',0.00,0.00,0.00,3660.07,0.00,'2022-09-03 09:55:26','',''),(2746,'21','226','2',1,'Sale Id shift 187',0.00,0.00,0.00,1948.58,0.00,'2022-09-03 09:55:26','',''),(2747,'21','226','2',1,'Sale Id shift 187',0.00,0.00,0.00,1368.86,0.00,'2022-09-03 09:55:26','',''),(2748,'21','226','2',1,'Sale Id shift 187',0.00,0.00,0.00,923.69,0.00,'2022-09-03 09:55:26','',''),(2749,'21','226','2',1,'Sale Id shift 187',0.00,0.00,0.00,1963.79,0.00,'2022-09-03 09:55:26','',''),(2750,'21','226','2',1,'Sale Id shift 187',0.00,0.00,0.00,1812.34,0.00,'2022-09-03 09:55:26','',''),(2751,'21','226','3',2,'Sale Id shift 187',0.00,0.00,0.00,65.02,0.00,'2022-09-03 09:55:26','',''),(2752,'21','226','3',2,'Sale Id shift 187',0.00,0.00,0.00,1625.71,0.00,'2022-09-03 09:55:26','',''),(2753,'21','226','4',3,'Sale Id shift 187',0.00,0.00,0.00,115.88,0.00,'2022-09-03 09:55:26','',''),(2754,'21','226','1',1,'Sale Id shift 187',0.00,0.00,0.00,3897.13,0.00,'2022-09-03 09:55:26','',''),(2755,'21','226','1',1,'Sale Id shift 187',0.00,0.00,0.00,2547.32,0.00,'2022-09-03 09:55:26','',''),(2756,'21','226','1',1,'Sale Id shift 187',0.00,0.00,0.00,3668.96,0.00,'2022-09-03 09:55:26','',''),(2757,'21','226','1',1,'Sale Id shift 187',0.00,0.00,0.00,3330.26,0.00,'2022-09-03 09:55:26','',''),(2758,'21','226',NULL,1,'Sale Id shift 187',6503063.40,0.00,0.00,0.00,0.00,'2022-09-03 09:55:26','',''),(2759,'21','226',NULL,2,'Sale Id shift 187',1352584.00,0.00,0.00,0.00,0.00,'2022-09-03 09:55:26','',''),(2760,'21','226',NULL,3,'Sale Id shift 187',99656.80,0.00,0.00,0.00,0.00,'2022-09-03 09:55:26','',''),(2761,'21','226','2',1,'Sale Id shift 188',0.00,0.00,0.00,733.30,0.00,'2022-09-03 11:54:11','',''),(2762,'21','226','2',1,'Sale Id shift 188',0.00,0.00,0.00,483.78,0.00,'2022-09-03 11:54:11','',''),(2763,'21','226','3',2,'Sale Id shift 188',0.00,0.00,0.00,1991.48,0.00,'2022-09-03 11:54:11','',''),(2764,'21','226','3',2,'Sale Id shift 188',0.00,0.00,0.00,1395.41,0.00,'2022-09-03 11:54:11','',''),(2765,'21','226','4',3,'Sale Id shift 188',0.00,0.00,0.00,127.28,0.00,'2022-09-03 11:54:11','',''),(2766,'21','226','1',1,'Sale Id shift 188',0.00,0.00,0.00,4500.21,0.00,'2022-09-03 11:54:11','',''),(2767,'21','226','1',1,'Sale Id shift 188',0.00,0.00,0.00,3592.06,0.00,'2022-09-03 11:54:11','',''),(2768,'21','226',NULL,1,'Sale Id shift 188',1675683.00,0.00,0.00,0.00,0.00,'2022-09-03 11:54:11','',''),(2769,'21','226',NULL,2,'Sale Id shift 188',2709512.00,0.00,0.00,0.00,0.00,'2022-09-03 11:54:11','',''),(2770,'21','226',NULL,3,'Sale Id shift 188',109460.80,0.00,0.00,0.00,0.00,'2022-09-03 11:54:11','',''),(2771,'21','226','1',1,'Sale Id shift 189',0.00,0.00,0.00,3386.45,0.00,'2022-09-06 08:33:05','',''),(2772,'21','226','2',1,'Sale Id shift 189',0.00,0.00,0.00,2055.53,0.00,'2022-09-06 08:33:05','',''),(2773,'21','226','2',1,'Sale Id shift 189',0.00,0.00,0.00,1711.21,0.00,'2022-09-06 08:33:05','',''),(2774,'21','226','2',1,'Sale Id shift 189',0.00,0.00,0.00,1738.58,0.00,'2022-09-06 08:33:05','',''),(2775,'21','226','1',1,'Sale Id shift 189',0.00,0.00,0.00,1932.34,0.00,'2022-09-06 08:33:05','',''),(2776,'21','226','2',1,'Sale Id shift 189',0.00,0.00,0.00,1901.44,0.00,'2022-09-06 08:33:05','',''),(2777,'21','226','2',1,'Sale Id shift 189',0.00,0.00,0.00,1341.35,0.00,'2022-09-06 08:33:05','',''),(2778,'21','226','2',1,'Sale Id shift 189',0.00,0.00,0.00,1427.08,0.00,'2022-09-06 08:33:05','',''),(2779,'21','226','2',1,'Sale Id shift 189',0.00,0.00,0.00,1643.34,0.00,'2022-09-06 08:33:05','',''),(2780,'21','226','2',1,'Sale Id shift 189',0.00,0.00,0.00,1805.20,0.00,'2022-09-06 08:33:05','',''),(2781,'21','226','3',2,'Sale Id shift 189',0.00,0.00,0.00,712.86,0.00,'2022-09-06 08:33:05','',''),(2782,'21','226','3',2,'Sale Id shift 189',0.00,0.00,0.00,1815.49,0.00,'2022-09-06 08:33:05','',''),(2783,'21','226','4',3,'Sale Id shift 189',0.00,0.00,0.00,86.88,0.00,'2022-09-06 08:33:05','',''),(2784,'21','226','1',1,'Sale Id shift 189',0.00,0.00,0.00,4683.81,0.00,'2022-09-06 08:33:05','',''),(2785,'21','226','1',1,'Sale Id shift 189',0.00,0.00,0.00,2311.92,0.00,'2022-09-06 08:33:05','',''),(2786,'21','226','1',1,'Sale Id shift 189',0.00,0.00,0.00,2932.16,0.00,'2022-09-06 08:33:05','',''),(2787,'21','226','1',1,'Sale Id shift 189',0.00,0.00,0.00,2212.68,0.00,'2022-09-06 08:33:05','',''),(2788,'21','226',NULL,1,'Sale Id shift 189',5594956.20,0.00,0.00,0.00,0.00,'2022-09-06 08:33:05','',''),(2789,'21','226',NULL,2,'Sale Id shift 189',2022680.00,0.00,0.00,0.00,0.00,'2022-09-06 08:33:05','',''),(2790,'21','226',NULL,3,'Sale Id shift 189',74716.80,0.00,0.00,0.00,0.00,'2022-09-06 08:33:05','',''),(2791,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,36000000.00,45000.00,0.00,0.00,'2022-09-06 08:33:16','',''),(2792,'21','226',NULL,2,'Reception corrector for bridging 244',0.00,0.00,0.00,30000.00,0.00,'2022-09-06 08:34:04','',''),(2793,'21','226','3',2,'Received from bridging 244',0.00,0.00,30000.00,0.00,0.00,'2022-09-06 08:34:04','',''),(2794,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-06 08:34:13','',''),(2795,'21','226',NULL,1,'Reception corrector for bridging 246',0.00,0.00,0.00,15000.00,0.00,'2022-09-06 08:35:05','',''),(2796,'21','226','2',1,'Received from bridging 246',0.00,0.00,15000.00,0.00,0.00,'2022-09-06 08:35:05','',''),(2797,'21','226',NULL,1,'Reception corrector for bridging 245',0.00,0.00,0.00,30000.00,0.00,'2022-09-06 08:35:05','',''),(2798,'21','226','1',1,'Received from bridging 245',0.00,0.00,30000.00,0.00,0.00,'2022-09-06 08:35:05','',''),(2799,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5490000.00,30500.00,0.00,0.00,'2022-09-06 08:35:57','',''),(2800,'21','226',NULL,1,'Reception corrector for bridging 248',0.00,0.00,0.00,16000.00,0.00,'2022-09-06 08:36:57','',''),(2801,'21','226','2',1,'Received from bridging 248',0.00,0.00,16000.00,0.00,0.00,'2022-09-06 08:36:57','',''),(2802,'21','226',NULL,1,'Reception corrector for bridging 247',0.00,0.00,0.00,14500.00,0.00,'2022-09-06 08:36:57','',''),(2803,'21','226','1',1,'Received from bridging 247',0.00,0.00,14500.00,0.00,0.00,'2022-09-06 08:36:57','',''),(2804,'21','226','1',1,'Sale Id shift 190',0.00,0.00,0.00,4367.51,0.00,'2022-09-06 08:45:25','',''),(2805,'21','226','2',1,'Sale Id shift 190',0.00,0.00,0.00,1746.82,0.00,'2022-09-06 08:45:25','',''),(2806,'21','226','2',1,'Sale Id shift 190',0.00,0.00,0.00,1091.90,0.00,'2022-09-06 08:45:25','',''),(2807,'21','226','2',1,'Sale Id shift 190',0.00,0.00,0.00,1281.92,0.00,'2022-09-06 08:45:25','',''),(2808,'21','226','1',1,'Sale Id shift 190',0.00,0.00,0.00,3061.12,0.00,'2022-09-06 08:45:25','',''),(2809,'21','226','2',1,'Sale Id shift 190',0.00,0.00,0.00,1149.93,0.00,'2022-09-06 08:45:25','',''),(2810,'21','226','2',1,'Sale Id shift 190',0.00,0.00,0.00,1080.45,0.00,'2022-09-06 08:45:25','',''),(2811,'21','226','2',1,'Sale Id shift 190',0.00,0.00,0.00,1542.60,0.00,'2022-09-06 08:45:25','',''),(2812,'21','226','2',1,'Sale Id shift 190',0.00,0.00,0.00,1521.25,0.00,'2022-09-06 08:45:25','',''),(2813,'21','226','2',1,'Sale Id shift 190',0.00,0.00,0.00,1402.50,0.00,'2022-09-06 08:45:25','',''),(2814,'21','226','3',2,'Sale Id shift 190',0.00,0.00,0.00,712.71,0.00,'2022-09-06 08:45:25','',''),(2815,'21','226','3',2,'Sale Id shift 190',0.00,0.00,0.00,1883.95,0.00,'2022-09-06 08:45:25','',''),(2816,'21','226','4',3,'Sale Id shift 190',0.00,0.00,0.00,166.86,0.00,'2022-09-06 08:45:25','',''),(2817,'21','226','1',1,'Sale Id shift 190',0.00,0.00,0.00,2516.02,0.00,'2022-09-06 08:45:25','',''),(2818,'21','226','1',1,'Sale Id shift 190',0.00,0.00,0.00,1434.04,0.00,'2022-09-06 08:45:25','',''),(2819,'21','226','1',1,'Sale Id shift 190',0.00,0.00,0.00,3307.79,0.00,'2022-09-06 08:45:25','',''),(2820,'21','226','1',1,'Sale Id shift 190',0.00,0.00,0.00,3134.02,0.00,'2022-09-06 08:45:25','',''),(2821,'21','226',NULL,2,'Sale Id shift 190',2077328.00,0.00,0.00,0.00,0.00,'2022-09-06 08:45:25','',''),(2822,'21','226',NULL,3,'Sale Id shift 190',143499.60,0.00,0.00,0.00,0.00,'2022-09-06 08:45:25','',''),(2823,'21','226',NULL,1,'Sale Id shift 190',5154816.60,0.00,0.00,0.00,0.00,'2022-09-06 08:45:25','',''),(2824,'21','226','1',1,'Sale Id shift 191',0.00,0.00,0.00,4572.53,0.00,'2022-09-06 08:53:36','',''),(2825,'21','226','2',1,'Sale Id shift 191',0.00,0.00,0.00,903.69,0.00,'2022-09-06 08:53:36','',''),(2826,'21','226','1',1,'Sale Id shift 191',0.00,0.00,0.00,3344.13,0.00,'2022-09-06 08:53:36','',''),(2827,'21','226','2',1,'Sale Id shift 191',0.00,0.00,0.00,1095.99,0.00,'2022-09-06 08:53:36','',''),(2828,'21','226','2',1,'Sale Id shift 191',0.00,0.00,0.00,1141.81,0.00,'2022-09-06 08:53:36','',''),(2829,'21','226','2',1,'Sale Id shift 191',0.00,0.00,0.00,1027.07,0.00,'2022-09-06 08:53:36','',''),(2830,'21','226','3',2,'Sale Id shift 191',0.00,0.00,0.00,669.52,0.00,'2022-09-06 08:53:36','',''),(2831,'21','226','3',2,'Sale Id shift 191',0.00,0.00,0.00,2623.39,0.00,'2022-09-06 08:53:36','',''),(2832,'21','226','4',3,'Sale Id shift 191',0.00,0.00,0.00,285.83,0.00,'2022-09-06 08:53:36','',''),(2833,'21','226','1',1,'Sale Id shift 191',0.00,0.00,0.00,4273.95,0.00,'2022-09-06 08:53:36','',''),(2834,'21','226','1',1,'Sale Id shift 191',0.00,0.00,0.00,3034.63,0.00,'2022-09-06 08:53:36','',''),(2835,'21','226','1',1,'Sale Id shift 191',0.00,0.00,0.00,2961.87,0.00,'2022-09-06 08:53:36','',''),(2836,'21','226','1',1,'Sale Id shift 191',0.00,0.00,0.00,3273.04,0.00,'2022-09-06 08:53:36','',''),(2837,'21','226',NULL,1,'Sale Id shift 191',4613167.80,0.00,0.00,0.00,0.00,'2022-09-06 08:53:36','',''),(2838,'21','226',NULL,2,'Sale Id shift 191',2634328.00,0.00,0.00,0.00,0.00,'2022-09-06 08:53:36','',''),(2839,'21','226',NULL,3,'Sale Id shift 191',245813.80,0.00,0.00,0.00,0.00,'2022-09-06 08:53:36','',''),(2840,'21','226',NULL,2,'Reception corrector for bridging 249',0.00,0.00,0.00,15000.00,0.00,'2022-09-06 09:06:23','',''),(2841,'21','226','3',2,'Received from bridging 249',0.00,0.00,15000.00,0.00,0.00,'2022-09-06 09:06:23','',''),(2842,'21','226','1',1,'Sale Id shift 192',0.00,0.00,0.00,4191.71,0.00,'2022-09-06 09:06:58','',''),(2843,'21','226','2',1,'Sale Id shift 192',0.00,0.00,0.00,2324.63,0.00,'2022-09-06 09:06:58','',''),(2844,'21','226','2',1,'Sale Id shift 192',0.00,0.00,0.00,1935.20,0.00,'2022-09-06 09:06:58','',''),(2845,'21','226','2',1,'Sale Id shift 192',0.00,0.00,0.00,2279.12,0.00,'2022-09-06 09:06:58','',''),(2846,'21','226','1',1,'Sale Id shift 192',0.00,0.00,0.00,2778.43,0.00,'2022-09-06 09:06:58','',''),(2847,'21','226','2',1,'Sale Id shift 192',0.00,0.00,0.00,1495.35,0.00,'2022-09-06 09:06:58','',''),(2848,'21','226','2',1,'Sale Id shift 192',0.00,0.00,0.00,1583.17,0.00,'2022-09-06 09:06:58','',''),(2849,'21','226','2',1,'Sale Id shift 192',0.00,0.00,0.00,1833.25,0.00,'2022-09-06 09:06:58','',''),(2850,'21','226','2',1,'Sale Id shift 192',0.00,0.00,0.00,2009.31,0.00,'2022-09-06 09:06:58','',''),(2851,'21','226','2',1,'Sale Id shift 192',0.00,0.00,0.00,1570.19,0.00,'2022-09-06 09:06:58','',''),(2852,'21','226','3',2,'Sale Id shift 192',0.00,0.00,0.00,1255.11,0.00,'2022-09-06 09:06:58','',''),(2853,'21','226','3',2,'Sale Id shift 192',0.00,0.00,0.00,1878.23,0.00,'2022-09-06 09:06:58','',''),(2854,'21','226','4',3,'Sale Id shift 192',0.00,0.00,0.00,133.54,0.00,'2022-09-06 09:06:58','',''),(2855,'21','226','1',1,'Sale Id shift 192',0.00,0.00,0.00,4392.92,0.00,'2022-09-06 09:06:58','',''),(2856,'21','226','1',1,'Sale Id shift 192',0.00,0.00,0.00,2558.51,0.00,'2022-09-06 09:06:58','',''),(2857,'21','226','1',1,'Sale Id shift 192',0.00,0.00,0.00,3799.71,0.00,'2022-09-06 09:06:58','',''),(2858,'21','226','1',1,'Sale Id shift 192',0.00,0.00,0.00,3650.00,0.00,'2022-09-06 09:06:58','',''),(2859,'21','226',NULL,1,'Sale Id shift 192',6552270.00,0.00,0.00,0.00,0.00,'2022-09-06 09:06:58','',''),(2860,'21','226',NULL,2,'Sale Id shift 192',2506672.00,0.00,0.00,0.00,0.00,'2022-09-06 09:06:58','',''),(2861,'21','226',NULL,3,'Sale Id shift 192',114844.40,0.00,0.00,0.00,0.00,'2022-09-06 09:06:58','',''),(2862,'21','226','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,15142.13,0.00,'2022-09-06 09:20:58','',''),(2863,'21','226','2',0,'Inventory adjustment from tank dipping to 16200',0.00,0.00,16200.00,0.00,0.00,'2022-09-06 09:20:58','',''),(2864,'21','226','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,22816.08,0.00,'2022-09-06 09:22:23','',''),(2865,'21','226','1',0,'Inventory adjustment from tank dipping to 24000',0.00,0.00,24000.00,0.00,0.00,'2022-09-06 09:22:23','',''),(2866,'21','226','1',1,'Sale Id shift 193',0.00,0.00,0.00,4618.00,0.00,'2022-09-06 09:34:19','',''),(2867,'21','226','2',1,'Sale Id shift 193',0.00,0.00,0.00,2192.34,0.00,'2022-09-06 09:34:19','',''),(2868,'21','226','2',1,'Sale Id shift 193',0.00,0.00,0.00,1953.57,0.00,'2022-09-06 09:34:19','',''),(2869,'21','226','2',1,'Sale Id shift 193',0.00,0.00,0.00,2188.36,0.00,'2022-09-06 09:34:19','',''),(2870,'21','226','1',1,'Sale Id shift 193',0.00,0.00,0.00,3250.52,0.00,'2022-09-06 09:34:19','',''),(2871,'21','226','2',1,'Sale Id shift 193',0.00,0.00,0.00,1606.58,0.00,'2022-09-06 09:34:19','',''),(2872,'21','226','2',1,'Sale Id shift 193',0.00,0.00,0.00,1953.04,0.00,'2022-09-06 09:34:19','',''),(2873,'21','226','2',1,'Sale Id shift 193',0.00,0.00,0.00,1891.78,0.00,'2022-09-06 09:34:19','',''),(2874,'21','226','2',1,'Sale Id shift 193',0.00,0.00,0.00,2075.01,0.00,'2022-09-06 09:34:19','',''),(2875,'21','226','2',1,'Sale Id shift 193',0.00,0.00,0.00,2266.55,0.00,'2022-09-06 09:34:19','',''),(2876,'21','226','3',2,'Sale Id shift 193',0.00,0.00,0.00,857.26,0.00,'2022-09-06 09:34:19','',''),(2877,'21','226','3',2,'Sale Id shift 193',0.00,0.00,0.00,3645.85,0.00,'2022-09-06 09:34:19','',''),(2878,'21','226','4',3,'Sale Id shift 193',0.00,0.00,0.00,125.79,0.00,'2022-09-06 09:34:19','',''),(2879,'21','226','1',1,'Sale Id shift 193',0.00,0.00,0.00,4884.66,0.00,'2022-09-06 09:34:19','',''),(2880,'21','226','1',1,'Sale Id shift 193',0.00,0.00,0.00,3421.71,0.00,'2022-09-06 09:34:19','',''),(2881,'21','226','1',1,'Sale Id shift 193',0.00,0.00,0.00,3048.89,0.00,'2022-09-06 09:34:19','',''),(2882,'21','226','1',1,'Sale Id shift 193',0.00,0.00,0.00,2089.75,0.00,'2022-09-06 09:34:19','',''),(2883,'21','226',NULL,1,'Sale Id shift 193',6739336.80,0.00,0.00,0.00,0.00,'2022-09-06 09:34:19','',''),(2884,'21','226',NULL,2,'Sale Id shift 193',3602488.00,0.00,0.00,0.00,0.00,'2022-09-06 09:34:19','',''),(2885,'21','226',NULL,3,'Sale Id shift 193',108179.40,0.00,0.00,0.00,0.00,'2022-09-06 09:34:19','',''),(2886,'21','226','3',2,'Sale Id shift 194',0.00,0.00,0.00,496.93,0.00,'2022-09-15 12:31:28','',''),(2887,'21','226','3',2,'Sale Id shift 194',0.00,0.00,0.00,2398.86,0.00,'2022-09-15 12:31:28','',''),(2888,'21','226','4',3,'Sale Id shift 194',0.00,0.00,0.00,219.35,0.00,'2022-09-15 12:31:28','',''),(2889,'21','226',NULL,2,'Sale Id shift 194',2316632.00,0.00,0.00,0.00,0.00,'2022-09-15 12:31:28','',''),(2890,'21','226',NULL,3,'Sale Id shift 194',188641.00,0.00,0.00,0.00,0.00,'2022-09-15 12:31:28','',''),(2891,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-15 12:36:23','',''),(2892,'21','226',NULL,1,'Reception corrector for bridging 251',0.00,0.00,0.00,15000.00,0.00,'2022-09-15 12:37:17','',''),(2893,'21','226','2',1,'Received from bridging 251',0.00,0.00,15000.00,0.00,0.00,'2022-09-15 12:37:17','',''),(2894,'21','226',NULL,1,'Reception corrector for bridging 250',0.00,0.00,0.00,30000.00,0.00,'2022-09-15 12:37:17','',''),(2895,'21','226','1',1,'Received from bridging 250',0.00,0.00,30000.00,0.00,0.00,'2022-09-15 12:37:17','',''),(2896,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-15 12:39:07','',''),(2897,'21','226',NULL,1,'Reception corrector for bridging 253',0.00,0.00,0.00,30000.00,0.00,'2022-09-15 12:40:46','',''),(2898,'21','226','2',1,'Received from bridging 253',0.00,0.00,30000.00,0.00,0.00,'2022-09-15 12:40:46','',''),(2899,'21','226',NULL,1,'Reception corrector for bridging 252',0.00,0.00,0.00,15000.00,0.00,'2022-09-15 12:40:46','',''),(2900,'21','226','1',1,'Received from bridging 252',0.00,0.00,15000.00,0.00,0.00,'2022-09-15 12:40:46','',''),(2901,'21','226','1',1,'Sale Id shift 195',0.00,0.00,0.00,5020.69,0.00,'2022-09-15 13:05:16','',''),(2902,'21','226','2',1,'Sale Id shift 195',0.00,0.00,0.00,2103.14,0.00,'2022-09-15 13:05:16','',''),(2903,'21','226','2',1,'Sale Id shift 195',0.00,0.00,0.00,1990.36,0.00,'2022-09-15 13:05:16','',''),(2904,'21','226','2',1,'Sale Id shift 195',0.00,0.00,0.00,2025.43,0.00,'2022-09-15 13:05:16','',''),(2905,'21','226','1',1,'Sale Id shift 195',0.00,0.00,0.00,3188.87,0.00,'2022-09-15 13:05:16','',''),(2906,'21','226','2',1,'Sale Id shift 195',0.00,0.00,0.00,1814.38,0.00,'2022-09-15 13:05:16','',''),(2907,'21','226','2',1,'Sale Id shift 195',0.00,0.00,0.00,1298.73,0.00,'2022-09-15 13:05:16','',''),(2908,'21','226','2',1,'Sale Id shift 195',0.00,0.00,0.00,1904.00,0.00,'2022-09-15 13:05:16','',''),(2909,'21','226','2',1,'Sale Id shift 195',0.00,0.00,0.00,1441.25,0.00,'2022-09-15 13:05:16','',''),(2910,'21','226','2',1,'Sale Id shift 195',0.00,0.00,0.00,2328.87,0.00,'2022-09-15 13:05:16','',''),(2911,'21','226','3',2,'Sale Id shift 195',0.00,0.00,0.00,759.64,0.00,'2022-09-15 13:05:16','',''),(2912,'21','226','3',2,'Sale Id shift 195',0.00,0.00,0.00,4049.67,0.00,'2022-09-15 13:05:16','',''),(2913,'21','226','4',3,'Sale Id shift 195',0.00,0.00,0.00,131.76,0.00,'2022-09-15 13:05:16','',''),(2914,'21','226','1',1,'Sale Id shift 195',0.00,0.00,0.00,6020.91,0.00,'2022-09-15 13:05:16','',''),(2915,'21','226','1',1,'Sale Id shift 195',0.00,0.00,0.00,416.17,0.00,'2022-09-15 13:05:16','',''),(2916,'21','226','1',1,'Sale Id shift 195',0.00,0.00,0.00,3867.37,0.00,'2022-09-15 13:05:16','',''),(2917,'21','226','1',1,'Sale Id shift 195',0.00,0.00,0.00,2994.41,0.00,'2022-09-15 13:05:16','',''),(2918,'21','226',NULL,1,'Sale Id shift 195',6554624.40,0.00,0.00,0.00,0.00,'2022-09-15 13:05:16','',''),(2919,'21','226',NULL,2,'Sale Id shift 195',3847448.00,0.00,0.00,0.00,0.00,'2022-09-15 13:05:16','',''),(2920,'21','226',NULL,3,'Sale Id shift 195',113313.60,0.00,0.00,0.00,0.00,'2022-09-15 13:05:16','',''),(2921,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-15 13:19:56','',''),(2922,'21','226',NULL,1,'Reception corrector for bridging 255',0.00,0.00,0.00,15000.00,0.00,'2022-09-15 13:21:14','',''),(2923,'21','226','2',1,'Received from bridging 255',0.00,0.00,15000.00,0.00,0.00,'2022-09-15 13:21:14','',''),(2924,'21','226',NULL,1,'Reception corrector for bridging 254',0.00,0.00,0.00,30000.00,0.00,'2022-09-15 13:21:14','',''),(2925,'21','226','1',1,'Received from bridging 254',0.00,0.00,30000.00,0.00,0.00,'2022-09-15 13:21:14','',''),(2926,'21','226','1',1,'Sale Id shift 196',0.00,0.00,0.00,4280.58,0.00,'2022-09-15 13:30:05','',''),(2927,'21','226','2',1,'Sale Id shift 196',0.00,0.00,0.00,2313.22,0.00,'2022-09-15 13:30:05','',''),(2928,'21','226','2',1,'Sale Id shift 196',0.00,0.00,0.00,2312.01,0.00,'2022-09-15 13:30:05','',''),(2929,'21','226','2',1,'Sale Id shift 196',0.00,0.00,0.00,2633.39,0.00,'2022-09-15 13:30:05','',''),(2930,'21','226','1',1,'Sale Id shift 196',0.00,0.00,0.00,2801.64,0.00,'2022-09-15 13:30:05','',''),(2931,'21','226','2',1,'Sale Id shift 196',0.00,0.00,0.00,2331.91,0.00,'2022-09-15 13:30:05','',''),(2932,'21','226','2',1,'Sale Id shift 196',0.00,0.00,0.00,2419.30,0.00,'2022-09-15 13:30:05','',''),(2933,'21','226','2',1,'Sale Id shift 196',0.00,0.00,0.00,2184.42,0.00,'2022-09-15 13:30:05','',''),(2934,'21','226','2',1,'Sale Id shift 196',0.00,0.00,0.00,1622.20,0.00,'2022-09-15 13:30:05','',''),(2935,'21','226','2',1,'Sale Id shift 196',0.00,0.00,0.00,2701.81,0.00,'2022-09-15 13:30:05','',''),(2936,'21','226','3',2,'Sale Id shift 196',0.00,0.00,0.00,472.50,0.00,'2022-09-15 13:30:05','',''),(2937,'21','226','3',2,'Sale Id shift 196',0.00,0.00,0.00,2737.91,0.00,'2022-09-15 13:30:05','',''),(2938,'21','226','4',3,'Sale Id shift 196',0.00,0.00,0.00,140.95,0.00,'2022-09-15 13:30:05','',''),(2939,'21','226','1',1,'Sale Id shift 196',0.00,0.00,0.00,4890.90,0.00,'2022-09-15 13:30:05','',''),(2940,'21','226','1',1,'Sale Id shift 196',0.00,0.00,0.00,1292.77,0.00,'2022-09-15 13:30:05','',''),(2941,'21','226','1',1,'Sale Id shift 196',0.00,0.00,0.00,3401.18,0.00,'2022-09-15 13:30:05','',''),(2942,'21','226','1',1,'Sale Id shift 196',0.00,0.00,0.00,2672.33,0.00,'2022-09-15 13:30:05','',''),(2943,'21','226','1',1,'Sale Id shift 196',0.00,0.00,0.00,1868.79,0.00,'2022-09-15 13:30:05','',''),(2944,'21','226',NULL,1,'Sale Id shift 196',7150761.00,0.00,0.00,0.00,0.00,'2022-09-15 13:30:05','',''),(2945,'21','226',NULL,2,'Sale Id shift 196',2568328.00,0.00,0.00,0.00,0.00,'2022-09-15 13:30:05','',''),(2946,'21','226',NULL,3,'Sale Id shift 196',121217.00,0.00,0.00,0.00,0.00,'2022-09-15 13:30:05','',''),(2947,'21','226','1',1,'Sale Id shift 197',0.00,0.00,0.00,4676.11,0.00,'2022-09-15 13:57:01','',''),(2948,'21','226','2',1,'Sale Id shift 197',0.00,0.00,0.00,2609.16,0.00,'2022-09-15 13:57:01','',''),(2949,'21','226','2',1,'Sale Id shift 197',0.00,0.00,0.00,1948.56,0.00,'2022-09-15 13:57:01','',''),(2950,'21','226','2',1,'Sale Id shift 197',0.00,0.00,0.00,2046.41,0.00,'2022-09-15 13:57:01','',''),(2951,'21','226','1',1,'Sale Id shift 197',0.00,0.00,0.00,2702.38,0.00,'2022-09-15 13:57:01','',''),(2952,'21','226','2',1,'Sale Id shift 197',0.00,0.00,0.00,1942.78,0.00,'2022-09-15 13:57:01','',''),(2953,'21','226','2',1,'Sale Id shift 197',0.00,0.00,0.00,2436.44,0.00,'2022-09-15 13:57:01','',''),(2954,'21','226','2',1,'Sale Id shift 197',0.00,0.00,0.00,1913.42,0.00,'2022-09-15 13:57:01','',''),(2955,'21','226','2',1,'Sale Id shift 197',0.00,0.00,0.00,1979.73,0.00,'2022-09-15 13:57:01','',''),(2956,'21','226','2',1,'Sale Id shift 197',0.00,0.00,0.00,2133.09,0.00,'2022-09-15 13:57:01','',''),(2957,'21','226','3',2,'Sale Id shift 197',0.00,0.00,0.00,1229.25,0.00,'2022-09-15 13:57:01','',''),(2958,'21','226','3',2,'Sale Id shift 197',0.00,0.00,0.00,41.84,0.00,'2022-09-15 13:57:01','',''),(2959,'21','226','3',2,'Sale Id shift 197',0.00,0.00,0.00,2320.35,0.00,'2022-09-15 13:57:01','',''),(2960,'21','226','4',3,'Sale Id shift 197',0.00,0.00,0.00,160.56,0.00,'2022-09-15 13:57:01','',''),(2961,'21','226','1',1,'Sale Id shift 197',0.00,0.00,0.00,3377.87,0.00,'2022-09-15 13:57:01','',''),(2962,'21','226','1',1,'Sale Id shift 197',0.00,0.00,0.00,1313.50,0.00,'2022-09-15 13:57:01','',''),(2963,'21','226','1',1,'Sale Id shift 197',0.00,0.00,0.00,308.62,0.00,'2022-09-15 13:57:01','',''),(2964,'21','226','1',1,'Sale Id shift 197',0.00,0.00,0.00,2818.04,0.00,'2022-09-15 13:57:01','',''),(2965,'21','226','1',1,'Sale Id shift 197',0.00,0.00,0.00,2893.88,0.00,'2022-09-15 13:57:01','',''),(2966,'21','226','1',1,'Sale Id shift 197',0.00,0.00,0.00,1589.88,0.00,'2022-09-15 13:57:01','',''),(2967,'21','226',NULL,1,'Sale Id shift 197',6604176.60,0.00,0.00,0.00,0.00,'2022-09-15 13:57:01','',''),(2968,'21','226',NULL,2,'Sale Id shift 197',2873152.00,0.00,0.00,0.00,0.00,'2022-09-15 13:57:01','',''),(2969,'21','226',NULL,3,'Sale Id shift 197',138081.60,0.00,0.00,0.00,0.00,'2022-09-15 13:57:01','',''),(2970,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-15 14:03:10','',''),(2971,'21','226',NULL,1,'Reception corrector for bridging 257',0.00,0.00,0.00,15000.00,0.00,'2022-09-15 14:06:40','',''),(2972,'21','226','2',1,'Received from bridging 257',0.00,0.00,15000.00,0.00,0.00,'2022-09-15 14:06:40','',''),(2973,'21','226',NULL,1,'Reception corrector for bridging 256',0.00,0.00,0.00,30000.00,0.00,'2022-09-15 14:06:40','',''),(2974,'21','226','1',1,'Received from bridging 256',0.00,0.00,30000.00,0.00,0.00,'2022-09-15 14:06:40','',''),(2975,'21','226','1',1,'Sale Id shift 198',0.00,0.00,0.00,4378.27,0.00,'2022-09-15 14:27:56','',''),(2976,'21','226','2',1,'Sale Id shift 198',0.00,0.00,0.00,2395.47,0.00,'2022-09-15 14:27:56','',''),(2977,'21','226','2',1,'Sale Id shift 198',0.00,0.00,0.00,1724.03,0.00,'2022-09-15 14:27:56','',''),(2978,'21','226','2',1,'Sale Id shift 198',0.00,0.00,0.00,2465.40,0.00,'2022-09-15 14:27:56','',''),(2979,'21','226','1',1,'Sale Id shift 198',0.00,0.00,0.00,2033.55,0.00,'2022-09-15 14:27:56','',''),(2980,'21','226','2',1,'Sale Id shift 198',0.00,0.00,0.00,1854.39,0.00,'2022-09-15 14:27:56','',''),(2981,'21','226','2',1,'Sale Id shift 198',0.00,0.00,0.00,2408.34,0.00,'2022-09-15 14:27:56','',''),(2982,'21','226','2',1,'Sale Id shift 198',0.00,0.00,0.00,1801.66,0.00,'2022-09-15 14:27:56','',''),(2983,'21','226','2',1,'Sale Id shift 198',0.00,0.00,0.00,1640.65,0.00,'2022-09-15 14:27:56','',''),(2984,'21','226','2',1,'Sale Id shift 198',0.00,0.00,0.00,2378.72,0.00,'2022-09-15 14:27:56','',''),(2985,'21','226','3',2,'Sale Id shift 198',0.00,0.00,0.00,1075.47,0.00,'2022-09-15 14:27:56','',''),(2986,'21','226','3',2,'Sale Id shift 198',0.00,0.00,0.00,459.61,0.00,'2022-09-15 14:27:56','',''),(2987,'21','226','3',2,'Sale Id shift 198',0.00,0.00,0.00,2967.42,0.00,'2022-09-15 14:27:56','',''),(2988,'21','226','4',3,'Sale Id shift 198',0.00,0.00,0.00,80.90,0.00,'2022-09-15 14:27:56','',''),(2989,'21','226','1',1,'Sale Id shift 198',0.00,0.00,0.00,4536.87,0.00,'2022-09-15 14:27:56','',''),(2990,'21','226','1',1,'Sale Id shift 198',0.00,0.00,0.00,1825.21,0.00,'2022-09-15 14:27:56','',''),(2991,'21','226','1',1,'Sale Id shift 198',0.00,0.00,0.00,2708.67,0.00,'2022-09-15 14:27:56','',''),(2992,'21','226','1',1,'Sale Id shift 198',0.00,0.00,0.00,2832.81,0.00,'2022-09-15 14:27:56','',''),(2993,'21','226','1',1,'Sale Id shift 198',0.00,0.00,0.00,3494.56,0.00,'2022-09-15 14:27:56','',''),(2994,'21','226','1',1,'Sale Id shift 198',0.00,0.00,0.00,2196.28,0.00,'2022-09-15 14:27:56','',''),(2995,'21','226',NULL,1,'Sale Id shift 198',7321478.40,0.00,0.00,0.00,0.00,'2022-09-15 14:27:56','',''),(2996,'21','226',NULL,2,'Sale Id shift 198',3602000.00,0.00,0.00,0.00,0.00,'2022-09-15 14:27:56','',''),(2997,'21','226',NULL,3,'Sale Id shift 198',69574.00,0.00,0.00,0.00,0.00,'2022-09-15 14:27:56','',''),(2998,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5400000.00,30000.00,0.00,0.00,'2022-09-15 14:29:08','',''),(2999,'21','226',NULL,1,'Reception corrector for bridging 259',0.00,0.00,0.00,15000.00,0.00,'2022-09-15 14:31:42','',''),(3000,'21','226','2',1,'Received from bridging 259',0.00,0.00,15000.00,0.00,0.00,'2022-09-15 14:31:42','',''),(3001,'21','226',NULL,1,'Reception corrector for bridging 258',0.00,0.00,0.00,15000.00,0.00,'2022-09-15 14:31:42','',''),(3002,'21','226','1',1,'Received from bridging 258',0.00,0.00,15000.00,0.00,0.00,'2022-09-15 14:31:42','',''),(3003,'21','226','1',1,'Sale Id shift 199',0.00,0.00,0.00,3661.66,0.00,'2022-09-15 14:47:20','',''),(3004,'21','226','2',1,'Sale Id shift 199',0.00,0.00,0.00,1014.64,0.00,'2022-09-15 14:47:20','',''),(3005,'21','226','2',1,'Sale Id shift 199',0.00,0.00,0.00,902.89,0.00,'2022-09-15 14:47:20','',''),(3006,'21','226','2',1,'Sale Id shift 199',0.00,0.00,0.00,1331.62,0.00,'2022-09-15 14:47:20','',''),(3007,'21','226','1',1,'Sale Id shift 199',0.00,0.00,0.00,1832.15,0.00,'2022-09-15 14:47:20','',''),(3008,'21','226','2',1,'Sale Id shift 199',0.00,0.00,0.00,1052.66,0.00,'2022-09-15 14:47:20','',''),(3009,'21','226','2',1,'Sale Id shift 199',0.00,0.00,0.00,930.06,0.00,'2022-09-15 14:47:20','',''),(3010,'21','226','2',1,'Sale Id shift 199',0.00,0.00,0.00,1009.65,0.00,'2022-09-15 14:47:20','',''),(3011,'21','226','2',1,'Sale Id shift 199',0.00,0.00,0.00,835.05,0.00,'2022-09-15 14:47:20','',''),(3012,'21','226','2',1,'Sale Id shift 199',0.00,0.00,0.00,1245.35,0.00,'2022-09-15 14:47:20','',''),(3013,'21','226','3',2,'Sale Id shift 199',0.00,0.00,0.00,799.48,0.00,'2022-09-15 14:47:20','',''),(3014,'21','226','3',2,'Sale Id shift 199',0.00,0.00,0.00,521.24,0.00,'2022-09-15 14:47:20','',''),(3015,'21','226','3',2,'Sale Id shift 199',0.00,0.00,0.00,2102.31,0.00,'2022-09-15 14:47:20','',''),(3016,'21','226','4',3,'Sale Id shift 199',0.00,0.00,0.00,148.14,0.00,'2022-09-15 14:47:20','',''),(3017,'21','226','1',1,'Sale Id shift 199',0.00,0.00,0.00,3645.03,0.00,'2022-09-15 14:47:20','',''),(3018,'21','226','1',1,'Sale Id shift 199',0.00,0.00,0.00,1644.36,0.00,'2022-09-15 14:47:20','',''),(3019,'21','226','1',1,'Sale Id shift 199',0.00,0.00,0.00,2990.37,0.00,'2022-09-15 14:47:20','',''),(3020,'21','226','1',1,'Sale Id shift 199',0.00,0.00,0.00,2541.84,0.00,'2022-09-15 14:47:20','',''),(3021,'21','226','1',1,'Sale Id shift 199',0.00,0.00,0.00,2574.05,0.00,'2022-09-15 14:47:20','',''),(3022,'21','226','1',1,'Sale Id shift 199',0.00,0.00,0.00,1982.03,0.00,'2022-09-15 14:47:20','',''),(3023,'21','226',NULL,1,'Sale Id shift 199',5254813.80,0.00,0.00,0.00,0.00,'2022-09-15 14:47:20','',''),(3024,'21','226',NULL,2,'Sale Id shift 199',2738424.00,0.00,0.00,0.00,0.00,'2022-09-15 14:47:20','',''),(3025,'21','226',NULL,3,'Sale Id shift 199',127400.40,0.00,0.00,0.00,0.00,'2022-09-15 14:47:20','',''),(3026,'21','226','3',2,'Sale Id shift 200',0.00,0.00,0.00,945.72,0.00,'2022-09-15 15:08:53','',''),(3027,'21','226','3',2,'Sale Id shift 200',0.00,0.00,0.00,223.13,0.00,'2022-09-15 15:08:53','',''),(3028,'21','226','3',2,'Sale Id shift 200',0.00,0.00,0.00,2149.80,0.00,'2022-09-15 15:08:53','',''),(3029,'21','226','4',3,'Sale Id shift 200',0.00,0.00,0.00,121.47,0.00,'2022-09-15 15:08:53','',''),(3030,'21','226',NULL,2,'Sale Id shift 200',2654920.00,0.00,0.00,0.00,0.00,'2022-09-15 15:08:53','',''),(3031,'21','226',NULL,3,'Sale Id shift 200',104464.20,0.00,0.00,0.00,0.00,'2022-09-15 15:08:53','',''),(3032,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-15 15:22:14','',''),(3033,'21','226','1',1,'Sale Id shift 201',0.00,0.00,0.00,3470.89,0.00,'2022-09-15 15:22:19','',''),(3034,'21','226','2',1,'Sale Id shift 201',0.00,0.00,0.00,1995.39,0.00,'2022-09-15 15:22:19','',''),(3035,'21','226','2',1,'Sale Id shift 201',0.00,0.00,0.00,1269.54,0.00,'2022-09-15 15:22:19','',''),(3036,'21','226','2',1,'Sale Id shift 201',0.00,0.00,0.00,1837.36,0.00,'2022-09-15 15:22:19','',''),(3037,'21','226','1',1,'Sale Id shift 201',0.00,0.00,0.00,1719.45,0.00,'2022-09-15 15:22:19','',''),(3038,'21','226','2',1,'Sale Id shift 201',0.00,0.00,0.00,1790.52,0.00,'2022-09-15 15:22:19','',''),(3039,'21','226','2',1,'Sale Id shift 201',0.00,0.00,0.00,1989.60,0.00,'2022-09-15 15:22:19','',''),(3040,'21','226','2',1,'Sale Id shift 201',0.00,0.00,0.00,2265.47,0.00,'2022-09-15 15:22:19','',''),(3041,'21','226','2',1,'Sale Id shift 201',0.00,0.00,0.00,1436.63,0.00,'2022-09-15 15:22:19','',''),(3042,'21','226','2',1,'Sale Id shift 201',0.00,0.00,0.00,1844.74,0.00,'2022-09-15 15:22:19','',''),(3043,'21','226','3',2,'Sale Id shift 201',0.00,0.00,0.00,1078.21,0.00,'2022-09-15 15:22:19','',''),(3044,'21','226','3',2,'Sale Id shift 201',0.00,0.00,0.00,1077.83,0.00,'2022-09-15 15:22:19','',''),(3045,'21','226','3',2,'Sale Id shift 201',0.00,0.00,0.00,2401.72,0.00,'2022-09-15 15:22:19','',''),(3046,'21','226','4',3,'Sale Id shift 201',0.00,0.00,0.00,155.11,0.00,'2022-09-15 15:22:19','',''),(3047,'21','226','1',1,'Sale Id shift 201',0.00,0.00,0.00,2823.72,0.00,'2022-09-15 15:22:19','',''),(3048,'21','226','1',1,'Sale Id shift 201',0.00,0.00,0.00,1326.26,0.00,'2022-09-15 15:22:19','',''),(3049,'21','226','1',1,'Sale Id shift 201',0.00,0.00,0.00,1930.92,0.00,'2022-09-15 15:22:19','',''),(3050,'21','226','1',1,'Sale Id shift 201',0.00,0.00,0.00,1087.15,0.00,'2022-09-15 15:22:19','',''),(3051,'21','226','1',1,'Sale Id shift 201',0.00,0.00,0.00,1663.11,0.00,'2022-09-15 15:22:19','',''),(3052,'21','226','1',1,'Sale Id shift 201',0.00,0.00,0.00,846.30,0.00,'2022-09-15 15:22:19','',''),(3053,'21','226',NULL,1,'Sale Id shift 201',5273469.00,0.00,0.00,0.00,0.00,'2022-09-15 15:22:19','',''),(3054,'21','226',NULL,2,'Sale Id shift 201',3646208.00,0.00,0.00,0.00,0.00,'2022-09-15 15:22:19','',''),(3055,'21','226',NULL,3,'Sale Id shift 201',133394.60,0.00,0.00,0.00,0.00,'2022-09-15 15:22:19','',''),(3056,'21','226',NULL,1,'Reception corrector for bridging 261',0.00,0.00,0.00,15000.00,0.00,'2022-09-15 15:23:01','',''),(3057,'21','226','2',1,'Received from bridging 261',0.00,0.00,15000.00,0.00,0.00,'2022-09-15 15:23:01','',''),(3058,'21','226',NULL,1,'Reception corrector for bridging 260',0.00,0.00,0.00,30000.00,0.00,'2022-09-15 15:23:01','',''),(3059,'21','226','1',1,'Received from bridging 260',0.00,0.00,30000.00,0.00,0.00,'2022-09-15 15:23:01','',''),(3060,'21','226','1',1,'Sale Id shift 202',0.00,0.00,0.00,3168.33,0.00,'2022-09-15 15:54:05','',''),(3061,'21','226','2',1,'Sale Id shift 202',0.00,0.00,0.00,1654.57,0.00,'2022-09-15 15:54:05','',''),(3062,'21','226','2',1,'Sale Id shift 202',0.00,0.00,0.00,1473.93,0.00,'2022-09-15 15:54:05','',''),(3063,'21','226','2',1,'Sale Id shift 202',0.00,0.00,0.00,1305.30,0.00,'2022-09-15 15:54:05','',''),(3064,'21','226','1',1,'Sale Id shift 202',0.00,0.00,0.00,1330.12,0.00,'2022-09-15 15:54:05','',''),(3065,'21','226','2',1,'Sale Id shift 202',0.00,0.00,0.00,1628.14,0.00,'2022-09-15 15:54:05','',''),(3066,'21','226','2',1,'Sale Id shift 202',0.00,0.00,0.00,1517.41,0.00,'2022-09-15 15:54:05','',''),(3067,'21','226','2',1,'Sale Id shift 202',0.00,0.00,0.00,1664.63,0.00,'2022-09-15 15:54:05','',''),(3068,'21','226','2',1,'Sale Id shift 202',0.00,0.00,0.00,1656.52,0.00,'2022-09-15 15:54:05','',''),(3069,'21','226','2',1,'Sale Id shift 202',0.00,0.00,0.00,1760.04,0.00,'2022-09-15 15:54:05','',''),(3070,'21','226','3',2,'Sale Id shift 202',0.00,0.00,0.00,421.75,0.00,'2022-09-15 15:54:05','',''),(3071,'21','226','3',2,'Sale Id shift 202',0.00,0.00,0.00,393.62,0.00,'2022-09-15 15:54:05','',''),(3072,'21','226','3',2,'Sale Id shift 202',0.00,0.00,0.00,1814.73,0.00,'2022-09-15 15:54:05','',''),(3073,'21','226','4',3,'Sale Id shift 202',0.00,0.00,0.00,81.44,0.00,'2022-09-15 15:54:05','',''),(3074,'21','226','1',1,'Sale Id shift 202',0.00,0.00,0.00,2676.09,0.00,'2022-09-15 15:54:05','',''),(3075,'21','226','1',1,'Sale Id shift 202',0.00,0.00,0.00,1336.78,0.00,'2022-09-15 15:54:05','',''),(3076,'21','226','1',1,'Sale Id shift 202',0.00,0.00,0.00,1589.26,0.00,'2022-09-15 15:54:05','',''),(3077,'21','226','1',1,'Sale Id shift 202',0.00,0.00,0.00,1420.07,0.00,'2022-09-15 15:54:05','',''),(3078,'21','226','1',1,'Sale Id shift 202',0.00,0.00,0.00,1861.57,0.00,'2022-09-15 15:54:05','',''),(3079,'21','226','1',1,'Sale Id shift 202',0.00,0.00,0.00,958.60,0.00,'2022-09-15 15:54:05','',''),(3080,'21','226',NULL,2,'Sale Id shift 202',2104080.00,0.00,0.00,0.00,0.00,'2022-09-15 15:54:05','',''),(3081,'21','226',NULL,3,'Sale Id shift 202',70038.40,0.00,0.00,0.00,0.00,'2022-09-15 15:54:05','',''),(3082,'21','226',NULL,1,'Sale Id shift 202',4860244.80,0.00,0.00,0.00,0.00,'2022-09-15 15:54:05','',''),(3083,'21','226',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-09-28 13:52:45','',''),(3084,'21','226',NULL,1,'Reception corrector for bridging 263',0.00,0.00,0.00,15000.00,0.00,'2022-09-28 13:53:46','',''),(3085,'21','226','2',1,'Received from bridging 263',0.00,0.00,15000.00,0.00,0.00,'2022-09-28 13:53:46','',''),(3086,'21','226',NULL,1,'Reception corrector for bridging 262',0.00,0.00,0.00,30000.00,0.00,'2022-09-28 13:53:46','',''),(3087,'21','226','1',1,'Received from bridging 262',0.00,0.00,30000.00,0.00,0.00,'2022-09-28 13:53:46','',''),(3088,'21','226',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,36000000.00,45000.00,0.00,0.00,'2022-09-28 13:57:05','',''),(3089,'21','226',NULL,2,'Reception corrector for bridging 264',0.00,0.00,0.00,30000.00,0.00,'2022-09-28 13:57:51','',''),(3090,'21','226','3',2,'Received from bridging 264',0.00,0.00,30000.00,0.00,0.00,'2022-09-28 13:57:51','',''),(3091,'21','226','1',1,'Sale Id shift 203',0.00,0.00,0.00,2355.48,0.00,'2022-09-28 16:21:35','',''),(3092,'21','226','2',1,'Sale Id shift 203',0.00,0.00,0.00,377.90,0.00,'2022-09-28 16:21:35','',''),(3093,'21','226','2',1,'Sale Id shift 203',0.00,0.00,0.00,134.92,0.00,'2022-09-28 16:21:35','',''),(3094,'21','226','2',1,'Sale Id shift 203',0.00,0.00,0.00,641.27,0.00,'2022-09-28 16:21:35','',''),(3095,'21','226','1',1,'Sale Id shift 203',0.00,0.00,0.00,1771.28,0.00,'2022-09-28 16:21:35','',''),(3096,'21','226','2',1,'Sale Id shift 203',0.00,0.00,0.00,547.59,0.00,'2022-09-28 16:21:35','',''),(3097,'21','226','2',1,'Sale Id shift 203',0.00,0.00,0.00,227.56,0.00,'2022-09-28 16:21:35','',''),(3098,'21','226','2',1,'Sale Id shift 203',0.00,0.00,0.00,277.53,0.00,'2022-09-28 16:21:35','',''),(3099,'21','226','2',1,'Sale Id shift 203',0.00,0.00,0.00,585.38,0.00,'2022-09-28 16:21:35','',''),(3100,'21','226','2',1,'Sale Id shift 203',0.00,0.00,0.00,760.48,0.00,'2022-09-28 16:21:35','',''),(3101,'21','226','3',2,'Sale Id shift 203',0.00,0.00,0.00,762.11,0.00,'2022-09-28 16:21:35','',''),(3102,'21','226','3',2,'Sale Id shift 203',0.00,0.00,0.00,1314.74,0.00,'2022-09-28 16:21:35','',''),(3103,'21','226','3',2,'Sale Id shift 203',0.00,0.00,0.00,2095.49,0.00,'2022-09-28 16:21:35','',''),(3104,'21','226','4',3,'Sale Id shift 203',0.00,0.00,0.00,98.30,0.00,'2022-09-28 16:21:35','',''),(3105,'21','226','1',1,'Sale Id shift 203',0.00,0.00,0.00,2643.56,0.00,'2022-09-28 16:21:35','',''),(3106,'21','226','1',1,'Sale Id shift 203',0.00,0.00,0.00,1156.44,0.00,'2022-09-28 16:21:35','',''),(3107,'21','226','1',1,'Sale Id shift 203',0.00,0.00,0.00,1747.34,0.00,'2022-09-28 16:21:35','',''),(3108,'21','226','1',1,'Sale Id shift 203',0.00,0.00,0.00,1920.94,0.00,'2022-09-28 16:21:35','',''),(3109,'21','226','1',1,'Sale Id shift 203',0.00,0.00,0.00,2231.58,0.00,'2022-09-28 16:21:35','',''),(3110,'21','226','1',1,'Sale Id shift 203',0.00,0.00,0.00,1652.54,0.00,'2022-09-28 16:21:35','',''),(3111,'21','226',NULL,1,'Sale Id shift 203',3425722.20,0.00,0.00,0.00,0.00,'2022-09-28 16:21:35','',''),(3112,'21','226',NULL,2,'Sale Id shift 203',3337872.00,0.00,0.00,0.00,0.00,'2022-09-28 16:21:35','',''),(3113,'21','226',NULL,3,'Sale Id shift 203',84538.00,0.00,0.00,0.00,0.00,'2022-09-28 16:21:35','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=460 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (7,'21','226',1,'Sale Id shift 6',0.00,1238833.20,165.00,1238833.20,0.00,'2022-03-22 10:50:31'),(8,'21','226',2,'Sale Id shift 6',0.00,1536339.00,700.00,1536339.00,0.00,'2022-03-22 10:50:31'),(9,'21','226',3,'Sale Id shift 6',0.00,1308769.00,550.00,1308769.00,0.00,'2022-03-22 10:50:31'),(10,'21','226',2,'Sale Id shift 7',0.00,1474578.00,700.00,1474578.00,0.00,'2022-03-23 09:34:33'),(11,'21','226',3,'Sale Id shift 7',0.00,144886.50,550.00,144886.50,0.00,'2022-03-23 09:34:33'),(12,'21','226',1,'Sale Id shift 7',0.00,4730574.75,165.00,4730574.75,0.00,'2022-03-23 09:34:33'),(13,'21','226',2,'Sale Id shift 8',0.00,2957150.00,700.00,2957150.00,0.00,'2022-03-24 09:00:47'),(14,'21','226',3,'Sale Id shift 8',0.00,580772.50,550.00,580772.50,0.00,'2022-03-24 09:00:47'),(15,'21','226',1,'Sale Id shift 8',0.00,5180509.95,165.00,5180509.95,0.00,'2022-03-24 09:00:47'),(16,'21','226',2,'Sale Id shift 9',0.00,2808855.00,700.00,2808855.00,0.00,'2022-04-04 10:22:22'),(17,'21','226',3,'Sale Id shift 9',0.00,251691.00,550.00,251691.00,0.00,'2022-04-04 10:22:22'),(18,'21','226',1,'Sale Id shift 9',0.00,4053152.40,165.00,4053152.40,0.00,'2022-04-04 10:22:22'),(19,'21','226',2,'Sale Id shift 10',0.00,1967273.00,700.00,1967273.00,0.00,'2022-04-04 11:08:35'),(20,'21','226',3,'Sale Id shift 10',0.00,155501.50,550.00,155501.50,0.00,'2022-04-04 11:08:35'),(21,'21','226',1,'Sale Id shift 10',0.00,5900574.90,165.00,5900574.90,0.00,'2022-04-04 11:08:35'),(22,'21','226',1,'Sale Id shift 11',0.00,3040085.40,165.00,3040085.40,0.00,'2022-04-04 12:03:33'),(23,'21','226',2,'Sale Id shift 11',0.00,1312143.00,700.00,1312143.00,0.00,'2022-04-04 12:03:33'),(24,'21','226',3,'Sale Id shift 11',0.00,252263.00,550.00,252263.00,0.00,'2022-04-04 12:03:33'),(25,'21','226',1,'Sale Id shift 12',0.00,2355470.70,165.00,2355470.70,0.00,'2022-04-04 12:39:15'),(26,'21','226',2,'Sale Id shift 12',0.00,1523732.00,700.00,1523732.00,0.00,'2022-04-04 12:39:15'),(27,'21','226',3,'Sale Id shift 12',0.00,154302.50,550.00,154302.50,0.00,'2022-04-04 12:39:15'),(28,'21','226',1,'Sale Id shift 13',0.00,4877340.60,165.00,4877340.60,0.00,'2022-04-04 13:58:29'),(29,'21','226',2,'Sale Id shift 13',0.00,2226084.00,700.00,2226084.00,0.00,'2022-04-04 13:58:29'),(30,'21','226',3,'Sale Id shift 13',0.00,221930.50,550.00,221930.50,0.00,'2022-04-04 13:58:29'),(31,'21','226',2,'Sale Id shift 14',0.00,1187599.00,700.00,1187599.00,0.00,'2022-04-04 15:04:10'),(32,'21','226',3,'Sale Id shift 14',0.00,302406.50,550.00,302406.50,0.00,'2022-04-04 15:04:10'),(33,'21','226',1,'Sale Id shift 14',0.00,5244817.05,165.00,5244817.05,0.00,'2022-04-04 15:04:10'),(34,'21','226',2,'Sale Id shift 15',0.00,326998.00,700.00,326998.00,0.00,'2022-04-04 15:42:27'),(35,'21','226',3,'Sale Id shift 15',0.00,213268.00,550.00,213268.00,0.00,'2022-04-04 15:42:27'),(36,'21','226',1,'Sale Id shift 15',0.00,4558540.80,165.00,4558540.80,0.00,'2022-04-04 15:42:27'),(37,'21','226',1,'Sale Id shift 16',0.00,3891531.60,165.00,3891531.60,0.00,'2022-04-04 16:42:18'),(38,'21','226',2,'Sale Id shift 16',0.00,26782.00,700.00,26782.00,0.00,'2022-04-04 16:42:18'),(39,'21','226',3,'Sale Id shift 16',0.00,210034.00,550.00,210034.00,0.00,'2022-04-04 16:42:18'),(40,'21','226',1,'Sale Id shift 17',0.00,85136.70,165.00,85136.70,0.00,'2022-04-04 16:56:17'),(41,'21','226',3,'Sale Id shift 17',0.00,276650.00,550.00,276650.00,0.00,'2022-04-04 16:56:17'),(42,'21','226',3,'Sale Id shift 18',0.00,465239.50,550.00,465239.50,0.00,'2022-04-04 17:10:13'),(43,'21','226',1,'Sale Id shift 18',0.00,4966168.35,165.00,4966168.35,0.00,'2022-04-04 17:10:13'),(44,'21','226',3,'Sale Id shift 19',0.00,325886.00,550.00,325886.00,0.00,'2022-04-04 17:34:08'),(45,'21','226',1,'Sale Id shift 19',0.00,4609469.70,165.00,4609469.70,0.00,'2022-04-04 17:34:08'),(46,'21','226',1,'Sale Id shift 20',0.00,6568697.85,165.00,6568697.85,0.00,'2022-04-06 09:33:57'),(47,'21','226',3,'Sale Id shift 20',0.00,301917.00,550.00,301917.00,0.00,'2022-04-06 09:33:57'),(48,'21','226',1,'Sale Id shift 21',0.00,5084085.60,165.00,5084085.60,0.00,'2022-04-06 15:31:14'),(49,'21','226',3,'Sale Id shift 21',0.00,76378.50,550.00,76378.50,0.00,'2022-04-06 15:31:14'),(50,'21','226',1,'Sale Id shift 22',0.00,6459657.60,165.00,6459657.60,0.00,'2022-04-07 07:48:22'),(51,'21','226',2,'Sale Id shift 23',0.00,3384115.00,700.00,3384115.00,0.00,'2022-04-09 10:47:59'),(52,'21','226',1,'Sale Id shift 23',0.00,7199893.80,165.00,7199893.80,0.00,'2022-04-09 10:47:59'),(53,'21','226',1,'Sale Id shift 24',0.00,8378691.75,165.00,8378691.75,0.00,'2022-04-10 09:35:52'),(54,'21','226',2,'Sale Id shift 24',0.00,1673602.00,700.00,1673602.00,0.00,'2022-04-10 09:35:52'),(55,'21','226',1,'Sale Id shift 25',0.00,7222083.00,165.00,7222083.00,0.00,'2022-04-11 10:55:35'),(56,'21','226',2,'Sale Id shift 25',0.00,2181242.00,700.00,2181242.00,0.00,'2022-04-11 10:55:35'),(57,'21','226',2,'Sale Id shift 26',0.00,3590762.00,700.00,3590762.00,0.00,'2022-04-12 16:16:51'),(58,'21','226',1,'Sale Id shift 26',0.00,3297798.90,165.00,3297798.90,0.00,'2022-04-12 16:16:51'),(59,'21','226',1,'Sale Id shift 27',0.00,4435525.05,165.00,4435525.05,0.00,'2022-04-12 17:13:14'),(60,'21','226',2,'Sale Id shift 27',0.00,1571927.00,700.00,1571927.00,0.00,'2022-04-12 17:13:14'),(61,'21','226',1,'Sale Id shift 28',0.00,54605.10,165.00,54605.10,0.00,'2022-04-13 10:56:28'),(62,'21','226',2,'Sale Id shift 28',0.00,1696751.00,700.00,1696751.00,0.00,'2022-04-13 10:56:28'),(63,'21','226',2,'Sale Id shift 29',0.00,3168613.00,700.00,3168613.00,0.00,'2022-04-15 10:50:54'),(64,'21','226',3,'Sale Id shift 29',0.00,134970.00,550.00,134970.00,0.00,'2022-04-15 10:50:54'),(65,'21','226',1,'Sale Id shift 29',0.00,4943515.50,165.00,4943515.50,0.00,'2022-04-15 10:50:54'),(66,'21','226',1,'Sale Id shift 30',0.00,5320385.40,165.00,5320385.40,0.00,'2022-04-15 12:03:26'),(67,'21','226',2,'Sale Id shift 30',0.00,1065624.00,700.00,1065624.00,0.00,'2022-04-15 12:03:26'),(68,'21','226',3,'Sale Id shift 30',0.00,210210.00,550.00,210210.00,0.00,'2022-04-15 12:03:26'),(69,'21','226',1,'Sale Id shift 31',0.00,5252946.60,165.00,5252946.60,0.00,'2022-04-16 18:00:53'),(70,'21','226',3,'Sale Id shift 31',0.00,142021.00,550.00,142021.00,0.00,'2022-04-16 18:00:53'),(71,'21','226',3,'Sale Id shift 32',0.00,1361992.50,550.00,1361992.50,0.00,'2022-04-18 10:16:29'),(72,'21','226',1,'Sale Id shift 32',0.00,5409683.40,165.00,5409683.40,0.00,'2022-04-18 10:16:29'),(73,'21','226',1,'Sale Id shift 33',0.00,5056261.65,165.00,5056261.65,0.00,'2022-04-18 21:20:04'),(74,'21','226',2,'Sale Id shift 33',0.00,1233169.00,700.00,1233169.00,0.00,'2022-04-18 21:20:04'),(75,'21','226',3,'Sale Id shift 33',0.00,71016.00,550.00,71016.00,0.00,'2022-04-18 21:20:04'),(76,'21','226',1,'Sale Id shift 34',0.00,6787039.05,165.00,6787039.05,0.00,'2022-04-19 20:47:34'),(77,'21','226',2,'Sale Id shift 34',0.00,1581286.00,700.00,1581286.00,0.00,'2022-04-19 20:47:34'),(78,'21','226',3,'Sale Id shift 34',0.00,233821.50,550.00,233821.50,0.00,'2022-04-19 20:47:34'),(79,'21','226',1,'Sale Id shift 35',0.00,8485054.05,165.00,8485054.05,0.00,'2022-04-20 23:12:07'),(80,'21','226',2,'Sale Id shift 35',0.00,1175825.00,700.00,1175825.00,0.00,'2022-04-20 23:12:07'),(81,'21','226',3,'Sale Id shift 35',0.00,212058.00,550.00,212058.00,0.00,'2022-04-20 23:12:07'),(82,'21','226',1,'Sale Id shift 36',0.00,7376513.10,165.00,7376513.10,0.00,'2022-04-22 09:52:58'),(83,'21','226',2,'Sale Id shift 36',0.00,2616383.00,700.00,2616383.00,0.00,'2022-04-22 09:52:58'),(84,'21','226',3,'Sale Id shift 36',0.00,211992.00,550.00,211992.00,0.00,'2022-04-22 09:52:58'),(85,'21','226',2,'Sale Id shift 37',0.00,933345.00,700.00,933345.00,0.00,'2022-04-22 10:12:21'),(86,'21','226',2,'Sale Id shift 38',0.00,1468045.20,680.00,1468045.20,0.00,'2022-04-22 10:24:03'),(87,'21','226',3,'Sale Id shift 38',0.00,262872.50,550.00,262872.50,0.00,'2022-04-22 10:24:03'),(88,'21','226',1,'Sale Id shift 38',0.00,7086344.10,165.00,7086344.10,0.00,'2022-04-22 10:24:03'),(89,'21','226',1,'Sale Id shift 39',0.00,7702374.90,165.00,7702374.90,0.00,'2022-04-23 18:39:24'),(90,'21','226',2,'Sale Id shift 39',0.00,2243959.20,680.00,2243959.20,0.00,'2022-04-23 18:39:24'),(91,'21','226',3,'Sale Id shift 39',0.00,252120.00,550.00,252120.00,0.00,'2022-04-23 18:39:24'),(92,'21','226',1,'Sale Id shift 40',0.00,3783814.65,165.00,3783814.65,0.00,'2022-04-24 20:03:55'),(93,'21','226',2,'Sale Id shift 40',0.00,3539053.20,680.00,3539053.20,0.00,'2022-04-24 20:03:55'),(94,'21','226',3,'Sale Id shift 40',0.00,411092.00,550.00,411092.00,0.00,'2022-04-24 20:03:55'),(95,'21','226',2,'Sale Id shift 41',0.00,3231720.40,680.00,3231720.40,0.00,'2022-04-26 09:56:11'),(96,'21','226',3,'Sale Id shift 41',0.00,176225.50,550.00,176225.50,0.00,'2022-04-26 09:56:11'),(97,'21','226',1,'Sale Id shift 41',0.00,6058742.25,165.00,6058742.25,0.00,'2022-04-26 09:56:11'),(98,'21','226',1,'Sale Id shift 42',0.00,517920.15,165.00,517920.15,0.00,'2022-04-27 09:52:02'),(99,'21','226',2,'Sale Id shift 42',0.00,3077455.60,680.00,3077455.60,0.00,'2022-04-27 09:52:02'),(100,'21','226',3,'Sale Id shift 42',0.00,223443.00,550.00,223443.00,0.00,'2022-04-27 09:52:02'),(101,'21','226',2,'Sale Id shift 43',0.00,3497274.00,680.00,3497274.00,0.00,'2022-04-28 14:42:55'),(102,'21','226',3,'Sale Id shift 43',0.00,778849.50,550.00,778849.50,0.00,'2022-04-28 14:42:55'),(103,'21','226',1,'Sale Id shift 43',0.00,6627375.15,165.00,6627375.15,0.00,'2022-04-28 14:42:55'),(104,'21','226',1,'Sale Id shift 44',0.00,6325230.45,165.00,6325230.45,0.00,'2022-04-28 21:50:07'),(105,'21','226',2,'Sale Id shift 44',0.00,3203854.00,680.00,3203854.00,0.00,'2022-04-28 21:50:07'),(106,'21','226',3,'Sale Id shift 44',0.00,1270753.00,550.00,1270753.00,0.00,'2022-04-28 21:50:07'),(107,'21','226',1,'Sale Id shift 45',0.00,6496810.65,165.00,6496810.65,0.00,'2022-04-29 19:34:37'),(108,'21','226',2,'Sale Id shift 45',0.00,3039872.00,680.00,3039872.00,0.00,'2022-04-29 19:34:37'),(109,'21','226',3,'Sale Id shift 45',0.00,5751768.00,550.00,5751768.00,0.00,'2022-04-29 19:34:37'),(110,'21','226',1,'Sale Id shift 46',0.00,7224285.75,165.00,7224285.75,0.00,'2022-04-30 19:41:01'),(111,'21','226',3,'Sale Id shift 46',0.00,197598.50,550.00,197598.50,0.00,'2022-04-30 19:41:01'),(112,'21','226',1,'Sale Id shift 47',0.00,6652572.30,165.00,6652572.30,0.00,'2022-05-02 18:01:48'),(113,'21','226',2,'Sale Id shift 47',0.00,128309.20,680.00,128309.20,0.00,'2022-05-02 18:01:48'),(114,'21','226',3,'Sale Id shift 47',0.00,382679.00,550.00,382679.00,0.00,'2022-05-02 18:01:48'),(115,'21','226',3,'Sale Id shift 48',0.00,192115.00,550.00,192115.00,0.00,'2022-05-04 11:21:10'),(116,'21','226',1,'Sale Id shift 48',0.00,4998645.30,165.00,4998645.30,0.00,'2022-05-04 11:21:10'),(117,'21','226',2,'Sale Id shift 49',0.00,98586.40,680.00,98586.40,0.00,'2022-05-04 11:47:53'),(118,'21','226',3,'Sale Id shift 49',0.00,143170.50,550.00,143170.50,0.00,'2022-05-04 11:47:53'),(119,'21','226',1,'Sale Id shift 49',0.00,2861895.30,165.00,2861895.30,0.00,'2022-05-04 11:47:53'),(120,'21','226',3,'Sale Id shift 50',0.00,2255071.50,550.00,2255071.50,0.00,'2022-05-05 17:22:13'),(121,'21','226',1,'Sale Id shift 51',0.00,6474113.25,165.00,6474113.25,0.00,'2022-05-05 19:05:22'),(122,'21','226',2,'Sale Id shift 51',0.00,71413.60,680.00,71413.60,0.00,'2022-05-05 19:05:22'),(123,'21','226',3,'Sale Id shift 51',0.00,318730.50,550.00,318730.50,0.00,'2022-05-05 19:05:22'),(124,'21','226',1,'Sale Id shift 52',0.00,6588247.05,165.00,6588247.05,0.00,'2022-05-07 13:45:23'),(125,'21','226',3,'Sale Id shift 52',0.00,2478322.00,550.00,2478322.00,0.00,'2022-05-07 13:45:23'),(126,'21','226',3,'Sale Id shift 53',0.00,1537712.00,550.00,1537712.00,0.00,'2022-05-08 20:07:20'),(127,'21','226',1,'Sale Id shift 53',0.00,7630038.90,165.00,7630038.90,0.00,'2022-05-08 20:07:20'),(128,'21','226',1,'Sale Id shift 54',0.00,8940185.10,165.00,8940185.10,0.00,'2022-05-09 16:49:03'),(129,'21','226',3,'Sale Id shift 54',0.00,846103.50,550.00,846103.50,0.00,'2022-05-09 16:49:03'),(130,'21','226',3,'Sale Id shift 55',0.00,109713.50,650.00,109713.50,0.00,'2022-05-09 17:09:14'),(131,'21','226',1,'Sale Id shift 56',0.00,4752805.20,165.00,4752805.20,0.00,'2022-05-11 13:39:42'),(132,'21','226',3,'Sale Id shift 56',0.00,55061.50,650.00,55061.50,0.00,'2022-05-11 13:39:42'),(133,'21','226',1,'Sale Id shift 57',0.00,2424985.20,165.00,2424985.20,0.00,'2022-05-12 11:09:57'),(134,'21','226',2,'Sale Id shift 57',0.00,3201460.40,680.00,3201460.40,0.00,'2022-05-12 11:09:57'),(135,'21','226',3,'Sale Id shift 57',0.00,220584.00,650.00,220584.00,0.00,'2022-05-12 11:09:57'),(136,'21','226',1,'Sale Id shift 58',0.00,4288788.90,165.00,4288788.90,0.00,'2022-05-12 14:12:25'),(137,'21','226',2,'Sale Id shift 58',0.00,1992808.00,680.00,1992808.00,0.00,'2022-05-12 14:12:25'),(138,'21','226',3,'Sale Id shift 58',0.00,740337.00,650.00,740337.00,0.00,'2022-05-12 14:12:25'),(139,'21','226',1,'Sale Id shift 59',0.00,818904.90,165.00,818904.90,0.00,'2022-05-14 09:46:45'),(140,'21','226',2,'Sale Id shift 59',0.00,4521728.00,680.00,4521728.00,0.00,'2022-05-14 09:46:45'),(141,'21','226',3,'Sale Id shift 59',0.00,195357.50,650.00,195357.50,0.00,'2022-05-14 09:46:45'),(142,'21','226',1,'Sale Id shift 60',0.00,352806.30,165.00,352806.30,0.00,'2022-05-14 15:09:04'),(143,'21','226',2,'Sale Id shift 60',0.00,3733710.00,680.00,3733710.00,0.00,'2022-05-14 15:09:04'),(144,'21','226',3,'Sale Id shift 60',0.00,286591.50,650.00,286591.50,0.00,'2022-05-14 15:09:04'),(145,'21','226',1,'Sale Id 1',0.00,2475000.00,165.00,2475000.00,0.00,'2022-05-14 15:52:52'),(146,'21','226',1,'Sale Id shift 61',0.00,3917906.85,165.00,3917906.85,0.00,'2022-05-15 16:08:15'),(147,'21','226',2,'Sale Id shift 61',0.00,3299054.00,680.00,3299054.00,0.00,'2022-05-15 16:08:15'),(148,'21','226',3,'Sale Id shift 61',0.00,220473.50,650.00,220473.50,0.00,'2022-05-15 16:08:15'),(149,'21','226',1,'Sale Id 2',0.00,2475000.00,165.00,2475000.00,0.00,'2022-05-15 16:14:08'),(150,'21','226',2,'Sale Id shift 63',0.00,365200.80,680.00,365200.80,0.00,'2022-05-15 16:29:03'),(151,'21','226',3,'Sale Id shift 63',0.00,185614.00,650.00,185614.00,0.00,'2022-05-15 16:29:03'),(152,'21','226',1,'Sale Id shift 63',0.00,5326642.20,165.00,5326642.20,0.00,'2022-05-15 16:29:03'),(153,'21','226',2,'Sale Id shift 65',0.00,1738886.40,720.00,1738886.40,0.00,'2022-05-15 16:36:54'),(154,'21','226',2,'Sale Id shift 66',0.00,2768839.20,720.00,2768839.20,0.00,'2022-05-18 09:09:44'),(155,'21','226',3,'Sale Id shift 66',0.00,169292.50,650.00,169292.50,0.00,'2022-05-18 09:09:44'),(156,'21','226',1,'Sale Id shift 66',0.00,5728090.50,165.00,5728090.50,0.00,'2022-05-18 09:09:44'),(157,'21','226',2,'Sale Id shift 67',0.00,3383028.00,720.00,3383028.00,0.00,'2022-05-18 09:22:56'),(158,'21','226',3,'Sale Id shift 67',0.00,292454.50,650.00,292454.50,0.00,'2022-05-18 09:22:56'),(159,'21','226',1,'Sale Id shift 67',0.00,2467183.95,165.00,2467183.95,0.00,'2022-05-18 09:22:56'),(160,'21','226',1,'Sale Id shift 68',0.00,6249909.60,165.00,6249909.60,0.00,'2022-05-18 10:30:42'),(161,'21','226',2,'Sale Id shift 68',0.00,4237531.20,720.00,4237531.20,0.00,'2022-05-18 10:30:42'),(162,'21','226',3,'Sale Id shift 68',0.00,265590.00,650.00,265590.00,0.00,'2022-05-18 10:30:42'),(163,'21','226',1,'Sale Id shift 69',0.00,7286962.65,165.00,7286962.65,0.00,'2022-05-19 18:12:00'),(164,'21','226',2,'Sale Id shift 69',0.00,3354372.00,720.00,3354372.00,0.00,'2022-05-19 18:12:01'),(165,'21','226',3,'Sale Id shift 69',0.00,219895.00,650.00,219895.00,0.00,'2022-05-19 18:12:01'),(166,'21','226',1,'Sale Id shift 70',0.00,5936835.30,165.00,5936835.30,0.00,'2022-05-21 11:46:02'),(167,'21','226',2,'Sale Id shift 70',0.00,4389789.60,720.00,4389789.60,0.00,'2022-05-21 11:46:02'),(168,'21','226',3,'Sale Id shift 70',0.00,198932.50,650.00,198932.50,0.00,'2022-05-21 11:46:02'),(169,'21','226',2,'Sale Id shift 71',0.00,1380160.80,720.00,1380160.80,0.00,'2022-05-21 14:34:49'),(170,'21','226',3,'Sale Id shift 71',0.00,188058.00,650.00,188058.00,0.00,'2022-05-21 14:34:49'),(171,'21','226',1,'Sale Id shift 71',0.00,2848203.60,165.00,2848203.60,0.00,'2022-05-21 14:34:49'),(172,'21','226',2,'Sale Id shift 72',0.00,3330993.60,720.00,3330993.60,0.00,'2022-05-23 14:35:08'),(173,'21','226',3,'Sale Id shift 72',0.00,175682.00,650.00,175682.00,0.00,'2022-05-23 14:35:08'),(174,'21','226',1,'Sale Id shift 72',0.00,5646192.75,165.00,5646192.75,0.00,'2022-05-23 14:35:08'),(175,'21','226',2,'Sale Id shift 73',0.00,913444.00,760.00,913444.00,0.00,'2022-05-23 15:02:21'),(176,'21','226',3,'Sale Id shift 73',0.00,185458.00,650.00,185458.00,0.00,'2022-05-23 15:02:21'),(177,'21','226',1,'Sale Id shift 73',0.00,1375291.50,165.00,1375291.50,0.00,'2022-05-23 15:02:21'),(178,'21','226',2,'Sale Id shift 74',0.00,1436453.20,760.00,1436453.20,0.00,'2022-05-25 08:35:48'),(179,'21','226',1,'Sale Id shift 75',0.00,2551479.15,165.00,2551479.15,0.00,'2022-05-25 09:25:47'),(180,'21','226',2,'Sale Id shift 75',0.00,2961796.00,760.00,2961796.00,0.00,'2022-05-25 09:25:47'),(181,'21','226',3,'Sale Id shift 75',0.00,243412.00,650.00,243412.00,0.00,'2022-05-25 09:25:47'),(182,'21','226',2,'Sale Id shift 76',0.00,2408759.20,760.00,2408759.20,0.00,'2022-05-26 09:45:36'),(183,'21','226',3,'Sale Id shift 76',0.00,1301183.00,650.00,1301183.00,0.00,'2022-05-26 09:45:36'),(184,'21','226',1,'Sale Id shift 76',0.00,5173784.55,165.00,5173784.55,0.00,'2022-05-26 09:45:36'),(185,'21','226',2,'Sale Id shift 77',0.00,2817654.40,760.00,2817654.40,0.00,'2022-05-26 10:07:23'),(186,'21','226',1,'Sale Id shift 78',0.00,8243276.25,165.00,8243276.25,0.00,'2022-05-28 13:05:30'),(187,'21','226',2,'Sale Id shift 78',0.00,4736905.20,760.00,4736905.20,0.00,'2022-05-28 13:05:30'),(188,'21','226',1,'Sale Id shift 79',0.00,4570711.20,165.00,4570711.20,0.00,'2022-05-28 13:47:03'),(189,'21','226',2,'Sale Id shift 79',0.00,2449799.20,760.00,2449799.20,0.00,'2022-05-28 13:47:03'),(190,'21','226',1,'Sale Id shift 80',0.00,5263016.55,165.00,5263016.55,0.00,'2022-05-31 18:04:20'),(191,'21','226',2,'Sale Id shift 80',0.00,2380798.80,760.00,2380798.80,0.00,'2022-05-31 18:04:20'),(192,'21','226',1,'Sale Id shift 81',0.00,1467430.80,165.00,1467430.80,0.00,'2022-06-01 18:02:25'),(193,'21','226',2,'Sale Id shift 81',0.00,1515006.80,760.00,1515006.80,0.00,'2022-06-01 18:02:25'),(194,'21','226',2,'Sale Id shift 82',0.00,2730208.80,760.00,2730208.80,0.00,'2022-06-01 18:20:05'),(195,'21','226',1,'Sale Id shift 82',0.00,6912229.50,165.00,6912229.50,0.00,'2022-06-01 18:20:05'),(196,'21','226',1,'Sale Id shift 83',0.00,5662590.45,165.00,5662590.45,0.00,'2022-06-03 17:10:09'),(197,'21','226',2,'Sale Id shift 83',0.00,2417385.20,760.00,2417385.20,0.00,'2022-06-03 17:10:09'),(198,'21','226',1,'Sale Id shift 84',0.00,4152484.05,165.00,4152484.05,0.00,'2022-06-03 18:37:25'),(199,'21','226',2,'Sale Id shift 84',0.00,1938380.00,760.00,1938380.00,0.00,'2022-06-03 18:37:25'),(200,'21','226',1,'Sale Id shift 85',0.00,781728.75,165.00,781728.75,0.00,'2022-06-03 18:51:26'),(201,'21','226',2,'Sale Id shift 85',0.00,3393840.80,760.00,3393840.80,0.00,'2022-06-03 18:51:26'),(202,'21','226',1,'Sale Id shift 86',0.00,4572123.60,165.00,4572123.60,0.00,'2022-06-05 17:09:23'),(203,'21','226',2,'Sale Id shift 86',0.00,3973956.40,760.00,3973956.40,0.00,'2022-06-05 17:09:23'),(204,'21','226',2,'Sale Id shift 87',0.00,667135.60,760.00,667135.60,0.00,'2022-06-05 17:16:31'),(205,'21','226',2,'Sale Id shift 88',0.00,4405924.60,770.00,4405924.60,0.00,'2022-06-05 17:36:50'),(206,'21','226',1,'Sale Id shift 88',0.00,5237500.95,165.00,5237500.95,0.00,'2022-06-05 17:36:50'),(207,'21','226',2,'Sale Id shift 89',0.00,842087.40,770.00,842087.40,0.00,'2022-06-06 18:38:18'),(208,'21','226',1,'Sale Id shift 90',0.00,4925139.45,165.00,4925139.45,0.00,'2022-06-06 18:53:51'),(209,'21','226',2,'Sale Id shift 90',0.00,3039382.50,770.00,3039382.50,0.00,'2022-06-06 18:53:51'),(210,'21','226',1,'Sale Id shift 91',0.00,4956197.40,165.00,4956197.40,0.00,'2022-06-08 12:35:47'),(211,'21','226',2,'Sale Id shift 91',0.00,3368164.80,780.00,3368164.80,0.00,'2022-06-08 12:35:47'),(212,'21','226',2,'Sale Id shift 92',0.00,1591839.60,780.00,1591839.60,0.00,'2022-06-09 11:22:21'),(213,'21','226',1,'Sale Id shift 92',0.00,4807477.95,165.00,4807477.95,0.00,'2022-06-09 11:22:21'),(214,'21','226',1,'Sale Id shift 93',0.00,5115232.65,165.00,5115232.65,0.00,'2022-06-12 15:07:35'),(215,'21','226',2,'Sale Id shift 93',0.00,1811885.40,780.00,1811885.40,0.00,'2022-06-12 15:07:35'),(216,'21','226',2,'Sale Id shift 94',0.00,1271960.00,800.00,1271960.00,0.00,'2022-06-12 15:15:47'),(217,'21','226',1,'Sale Id shift 95',0.00,4971953.25,165.00,4971953.25,0.00,'2022-06-12 17:09:15'),(218,'21','226',2,'Sale Id shift 95',0.00,3125496.00,800.00,3125496.00,0.00,'2022-06-12 17:09:15'),(219,'21','226',1,'Sale Id shift 96',0.00,4469371.50,165.00,4469371.50,0.00,'2022-06-12 19:11:52'),(220,'21','226',2,'Sale Id shift 96',0.00,2213848.00,800.00,2213848.00,0.00,'2022-06-12 19:11:52'),(221,'21','226',2,'Sale Id shift 97',0.00,2519760.00,800.00,2519760.00,0.00,'2022-06-16 11:38:27'),(222,'21','226',2,'Sale Id shift 98',0.00,1256666.40,820.00,1256666.40,0.00,'2022-06-16 12:04:43'),(223,'21','226',1,'Sale Id shift 98',0.00,4986496.35,165.00,4986496.35,0.00,'2022-06-16 12:04:43'),(224,'21','226',1,'Sale Id shift 99',0.00,4538153.40,165.00,4538153.40,0.00,'2022-06-16 12:37:32'),(225,'21','226',2,'Sale Id shift 99',0.00,4073702.60,820.00,4073702.60,0.00,'2022-06-16 12:37:32'),(226,'21','226',1,'Sale Id shift 100',0.00,4589768.70,165.00,4589768.70,0.00,'2022-06-16 14:14:03'),(227,'21','226',2,'Sale Id shift 100',0.00,4231610.00,820.00,4231610.00,0.00,'2022-06-16 14:14:03'),(228,'21','226',2,'Sale Id shift 101',0.00,3462138.40,820.00,3462138.40,0.00,'2022-06-16 14:22:25'),(229,'21','226',2,'Sale Id shift 102',0.00,3100903.80,820.00,3100903.80,0.00,'2022-06-21 11:30:12'),(230,'21','226',2,'Sale Id shift 103',0.00,1750702.40,830.00,1750702.40,0.00,'2022-06-21 11:48:27'),(231,'21','226',1,'Sale Id shift 103',0.00,5325851.85,165.00,5325851.85,0.00,'2022-06-21 11:48:27'),(232,'21','226',1,'Sale Id shift 104',0.00,6623946.45,165.00,6623946.45,0.00,'2022-06-21 12:02:01'),(233,'21','226',2,'Sale Id shift 104',0.00,1791438.80,830.00,1791438.80,0.00,'2022-06-21 12:02:01'),(234,'21','226',2,'Sale Id shift 105',0.00,2256936.00,830.00,2256936.00,0.00,'2022-06-21 12:10:42'),(235,'21','226',1,'Sale Id shift 105',0.00,4626845.85,165.00,4626845.85,0.00,'2022-06-21 12:10:42'),(236,'21','226',2,'Sale Id shift 106',0.00,2317501.10,830.00,2317501.10,0.00,'2022-06-21 12:16:40'),(237,'21','226',2,'Sale Id shift 107',0.00,1026046.00,830.00,1026046.00,0.00,'2022-06-27 10:21:39'),(238,'21','226',1,'Sale Id shift 108',0.00,4593534.00,165.00,4593534.00,0.00,'2022-06-27 11:07:58'),(239,'21','226',2,'Sale Id shift 108',0.00,645764.90,830.00,645764.90,0.00,'2022-06-27 11:07:58'),(240,'21','226',1,'Sale Id shift 109',0.00,67600.50,165.00,67600.50,0.00,'2022-06-27 11:25:52'),(241,'21','226',2,'Sale Id shift 109',0.00,3318995.70,830.00,3318995.70,0.00,'2022-06-27 11:25:52'),(242,'21','226',1,'Sale Id 3',0.00,2557500.00,165.00,2557500.00,0.00,'2022-06-27 11:36:09'),(243,'21','226',1,'Sale Id shift 110',0.00,650279.85,165.00,650279.85,0.00,'2022-06-27 11:49:35'),(244,'21','226',2,'Sale Id shift 110',0.00,4918239.70,830.00,4918239.70,0.00,'2022-06-27 11:49:35'),(245,'21','226',1,'Sale Id shift 112',0.00,3602959.80,165.00,3602959.80,0.00,'2022-07-01 11:59:39'),(246,'21','226',2,'Sale Id shift 112',0.00,1282291.90,830.00,1282291.90,0.00,'2022-07-01 11:59:39'),(247,'21','226',1,'Sale Id 4',0.00,2475000.00,165.00,2475000.00,0.00,'2022-07-01 12:15:29'),(248,'21','226',1,'Sale Id shift 113',0.00,3067166.85,165.00,3067166.85,0.00,'2022-07-01 15:07:39'),(249,'21','226',2,'Sale Id shift 113',0.00,7023684.10,830.00,7023684.10,0.00,'2022-07-01 15:07:39'),(250,'21','226',1,'Sale Id 5',0.00,2425500.00,165.00,2425500.00,0.00,'2022-07-01 15:18:42'),(251,'21','226',1,'Sale Id shift 114',0.00,4276808.25,165.00,4276808.25,0.00,'2022-07-01 15:44:33'),(252,'21','226',2,'Sale Id shift 114',0.00,2537409.60,830.00,2537409.60,0.00,'2022-07-01 15:44:33'),(253,'21','226',1,'Sale Id shift 115',0.00,3799311.45,165.00,3799311.45,0.00,'2022-07-01 16:05:27'),(254,'21','226',2,'Sale Id shift 115',0.00,2513646.70,830.00,2513646.70,0.00,'2022-07-01 16:05:27'),(255,'21','226',1,'Sale Id shift 116',0.00,4405739.25,165.00,4405739.25,0.00,'2022-07-01 16:18:34'),(256,'21','226',2,'Sale Id shift 116',0.00,3196745.00,830.00,3196745.00,0.00,'2022-07-01 16:18:34'),(257,'21','226',2,'Sale Id shift 117',0.00,3525923.00,830.00,3525923.00,0.00,'2022-07-01 16:24:28'),(258,'21','226',1,'Sale Id 6',0.00,2310000.00,165.00,2310000.00,0.00,'2022-07-02 16:16:47'),(259,'21','226',1,'Sale Id shift 118',0.00,4122556.35,165.00,4122556.35,0.00,'2022-07-02 16:32:27'),(260,'21','226',2,'Sale Id shift 118',0.00,717169.80,830.00,717169.80,0.00,'2022-07-02 16:32:27'),(261,'21','226',1,'Sale Id shift 119',0.00,106095.00,165.00,106095.00,0.00,'2022-07-08 13:09:46'),(262,'21','226',2,'Sale Id shift 119',0.00,1906842.00,830.00,1906842.00,0.00,'2022-07-08 13:09:46'),(263,'21','226',1,'Sale Id shift 120',0.00,2323480.50,165.00,2323480.50,0.00,'2022-07-13 14:52:22'),(264,'21','226',2,'Sale Id shift 120',0.00,2236260.70,830.00,2236260.70,0.00,'2022-07-13 14:52:22'),(265,'21','226',2,'Sale Id shift 121',0.00,3095651.00,830.00,3095651.00,0.00,'2022-07-13 15:03:20'),(266,'21','226',1,'Sale Id shift 122',0.00,91989.15,165.00,91989.15,0.00,'2022-07-13 15:35:31'),(267,'21','226',2,'Sale Id shift 122',0.00,1521755.20,830.00,1521755.20,0.00,'2022-07-13 15:35:31'),(268,'21','226',2,'Sale Id shift 123',0.00,2583648.90,830.00,2583648.90,0.00,'2022-07-13 15:49:34'),(269,'21','226',1,'Sale Id 7',0.00,2640000.00,165.00,2640000.00,0.00,'2022-07-13 16:04:15'),(270,'21','226',1,'Sale Id shift 124',0.00,1899814.95,165.00,1899814.95,0.00,'2022-07-13 16:07:17'),(271,'21','226',2,'Sale Id shift 124',0.00,2388441.20,830.00,2388441.20,0.00,'2022-07-13 16:07:17'),(272,'21','226',1,'Sale Id shift 125',0.00,241494.00,165.00,241494.00,0.00,'2022-07-13 16:44:01'),(273,'21','226',2,'Sale Id shift 125',0.00,6425918.10,830.00,6425918.10,0.00,'2022-07-13 16:44:01'),(274,'21','226',1,'Sale Id shift 126',0.00,1217251.20,165.00,1217251.20,0.00,'2022-07-13 17:21:39'),(275,'21','226',2,'Sale Id shift 126',0.00,2031200.90,830.00,2031200.90,0.00,'2022-07-13 17:21:39'),(276,'21','226',2,'Sale Id shift 127',0.00,1177155.80,830.00,1177155.80,0.00,'2022-07-14 09:03:55'),(277,'21','226',1,'Sale Id shift 128',0.00,5590576.05,185.00,5590576.05,0.00,'2022-07-14 09:35:08'),(278,'21','226',2,'Sale Id shift 128',0.00,1544090.50,830.00,1544090.50,0.00,'2022-07-14 09:35:08'),(279,'21','226',1,'Sale Id shift 129',0.00,9227398.55,185.00,9227398.55,0.00,'2022-07-14 09:56:46'),(280,'21','226',2,'Sale Id shift 129',0.00,1393528.50,830.00,1393528.50,0.00,'2022-07-14 09:56:46'),(281,'21','226',2,'Sale Id shift 130',0.00,1146902.30,830.00,1146902.30,0.00,'2022-07-14 10:09:53'),(282,'21','226',1,'Sale Id shift 130',0.00,6249577.50,185.00,6249577.50,0.00,'2022-07-14 10:09:53'),(283,'21','226',1,'Sale Id shift 131',0.00,8327939.65,185.00,8327939.65,0.00,'2022-07-14 10:36:25'),(284,'21','226',2,'Sale Id shift 131',0.00,2117877.80,830.00,2117877.80,0.00,'2022-07-14 10:36:25'),(285,'21','226',1,'Sale Id 8',0.00,2775000.00,185.00,2775000.00,0.00,'2022-07-19 21:53:50'),(286,'21','226',1,'Sale Id shift 132',0.00,7713513.95,185.00,7713513.95,0.00,'2022-07-20 16:48:10'),(287,'21','226',2,'Sale Id shift 132',0.00,2578453.10,830.00,2578453.10,0.00,'2022-07-20 16:48:10'),(288,'21','226',1,'Sale Id shift 133',0.00,5978759.70,185.00,5978759.70,0.00,'2022-07-20 17:26:07'),(289,'21','226',2,'Sale Id shift 133',0.00,2536430.20,830.00,2536430.20,0.00,'2022-07-20 17:26:07'),(290,'21','226',1,'Sale Id shift 134',0.00,2459702.65,185.00,2459702.65,0.00,'2022-07-20 17:55:25'),(291,'21','226',2,'Sale Id shift 134',0.00,3587334.70,830.00,3587334.70,0.00,'2022-07-20 17:55:25'),(292,'21','226',2,'Sale Id shift 135',0.00,2098422.60,830.00,2098422.60,0.00,'2022-07-20 18:11:43'),(293,'21','226',1,'Sale Id shift 135',0.00,5520280.50,175.00,5520280.50,0.00,'2022-07-20 18:11:43'),(294,'21','226',2,'Sale Id shift 136',0.00,1358751.50,830.00,1358751.50,0.00,'2022-07-20 18:19:25'),(295,'21','226',1,'Sale Id shift 137',0.00,64413.00,180.00,64413.00,0.00,'2022-07-20 18:32:24'),(296,'21','226',2,'Sale Id shift 137',0.00,1126019.50,830.00,1126019.50,0.00,'2022-07-20 18:32:24'),(297,'21','226',2,'Sale Id shift 138',0.00,2297697.30,830.00,2297697.30,0.00,'2022-07-20 18:36:02'),(298,'21','226',2,'Sale Id shift 139',0.00,837885.20,815.00,837885.20,0.00,'2022-07-21 16:30:31'),(299,'21','226',1,'Sale Id shift 139',0.00,5448470.40,180.00,5448470.40,0.00,'2022-07-21 16:30:31'),(300,'21','226',1,'Sale Id 9',0.00,2700000.00,180.00,2700000.00,0.00,'2022-07-21 16:34:13'),(301,'21','226',2,'Sale Id shift 141',0.00,979515.90,815.00,979515.90,0.00,'2022-07-24 14:15:21'),(302,'21','226',2,'Sale Id shift 142',0.00,42388.15,815.00,42388.15,0.00,'2022-07-24 14:27:48'),(303,'21','226',1,'Sale Id shift 142',0.00,150647.40,180.00,150647.40,0.00,'2022-07-24 14:27:48'),(304,'21','226',1,'Sale Id shift 143',0.00,5337838.80,180.00,5337838.80,0.00,'2022-07-24 16:20:28'),(305,'21','226',1,'Sale Id 10',0.00,2880000.00,180.00,2880000.00,0.00,'2022-07-25 10:31:08'),(306,'21','226',2,'Sale Id shift 144',0.00,2946216.85,815.00,2946216.85,0.00,'2022-07-26 11:09:31'),(307,'21','226',1,'Sale Id shift 144',0.00,2621129.40,180.00,2621129.40,0.00,'2022-07-26 11:09:31'),(308,'21','226',1,'Sale Id 11',0.00,2700000.00,180.00,2700000.00,0.00,'2022-07-26 16:14:37'),(309,'21','226',1,'Sale Id shift 145',0.00,5668509.60,180.00,5668509.60,0.00,'2022-07-26 16:50:38'),(310,'21','226',2,'Sale Id shift 145',0.00,1164561.65,815.00,1164561.65,0.00,'2022-07-26 16:50:38'),(311,'21','226',2,'Sale Id shift 146',0.00,1015407.90,810.00,1015407.90,0.00,'2022-07-27 12:03:31'),(312,'21','226',1,'Sale Id shift 147',0.00,5327773.20,180.00,5327773.20,0.00,'2022-07-27 12:39:34'),(313,'21','226',2,'Sale Id shift 147',0.00,3497061.60,810.00,3497061.60,0.00,'2022-07-27 12:39:34'),(314,'21','226',2,'Sale Id shift 148',0.00,2313319.50,810.00,2313319.50,0.00,'2022-07-28 16:23:33'),(315,'21','226',1,'Sale Id shift 148',0.00,5420480.40,180.00,5420480.40,0.00,'2022-07-28 16:23:33'),(316,'21','226',1,'Sale Id shift 149',0.00,5455029.60,180.00,5455029.60,0.00,'2022-07-29 17:30:50'),(317,'21','226',2,'Sale Id shift 149',0.00,3080997.00,810.00,3080997.00,0.00,'2022-07-29 17:30:50'),(318,'21','226',1,'Sale Id 12',0.00,5400000.00,180.00,5400000.00,0.00,'2022-07-31 17:17:46'),(319,'21','226',1,'Sale Id shift 151',0.00,5374891.80,180.00,5374891.80,0.00,'2022-07-31 17:41:31'),(320,'21','226',2,'Sale Id shift 151',0.00,3586153.50,810.00,3586153.50,0.00,'2022-07-31 17:41:31'),(321,'21','226',1,'Sale Id 13',0.00,2700000.00,180.00,2700000.00,0.00,'2022-07-31 17:48:38'),(322,'21','226',1,'Sale Id shift 152',0.00,5436855.00,180.00,5436855.00,0.00,'2022-07-31 17:57:01'),(323,'21','226',2,'Sale Id shift 152',0.00,1106257.50,810.00,1106257.50,0.00,'2022-07-31 17:57:01'),(324,'21','226',1,'Sale Id shift 153',0.00,5424942.60,180.00,5424942.60,0.00,'2022-08-02 16:31:11'),(325,'21','226',2,'Sale Id shift 153',0.00,2103821.10,810.00,2103821.10,0.00,'2022-08-02 16:31:11'),(326,'21','226',3,'Sale Id shift 153',0.00,33784.10,835.00,33784.10,0.00,'2022-08-02 16:31:11'),(327,'21','226',1,'Sale Id 14',0.00,2700000.00,180.00,2700000.00,0.00,'2022-08-02 16:36:32'),(328,'21','226',1,'Sale Id shift 154',0.00,5347317.60,180.00,5347317.60,0.00,'2022-08-03 14:20:01'),(329,'21','226',2,'Sale Id shift 154',0.00,3382511.40,810.00,3382511.40,0.00,'2022-08-03 14:20:01'),(330,'21','226',3,'Sale Id shift 154',0.00,74557.15,835.00,74557.15,0.00,'2022-08-03 14:20:01'),(331,'21','226',2,'Sale Id shift 155',0.00,4543743.60,810.00,4543743.60,0.00,'2022-08-03 16:42:51'),(332,'21','226',3,'Sale Id shift 155',0.00,165505.35,835.00,165505.35,0.00,'2022-08-03 16:42:51'),(333,'21','226',1,'Sale Id shift 155',0.00,7242886.80,180.00,7242886.80,0.00,'2022-08-03 16:42:51'),(334,'21','226',1,'Sale Id 16',0.00,2700000.00,180.00,2700000.00,0.00,'2022-08-04 14:03:58'),(335,'21','226',2,'Sale Id shift 156',0.00,4172366.70,810.00,4172366.70,0.00,'2022-08-04 14:18:34'),(336,'21','226',3,'Sale Id shift 156',0.00,73037.45,835.00,73037.45,0.00,'2022-08-04 14:18:34'),(337,'21','226',1,'Sale Id shift 156',0.00,5431417.20,180.00,5431417.20,0.00,'2022-08-04 14:18:34'),(338,'21','226',1,'Sale Id shift 157',0.00,5432214.60,180.00,5432214.60,0.00,'2022-08-05 17:21:49'),(339,'21','226',2,'Sale Id shift 157',0.00,4545153.00,810.00,4545153.00,0.00,'2022-08-05 17:21:49'),(340,'21','226',3,'Sale Id shift 157',0.00,122369.25,835.00,122369.25,0.00,'2022-08-05 17:21:49'),(341,'21','226',1,'Sale Id shift 158',0.00,3321525.60,180.00,3321525.60,0.00,'2022-08-06 19:28:42'),(342,'21','226',2,'Sale Id shift 158',0.00,2351770.20,810.00,2351770.20,0.00,'2022-08-06 19:28:42'),(343,'21','226',3,'Sale Id shift 158',0.00,51152.10,835.00,51152.10,0.00,'2022-08-06 19:28:42'),(344,'21','226',1,'Sale Id shift 159',0.00,4669794.00,180.00,4669794.00,0.00,'2022-08-10 10:16:51'),(345,'21','226',2,'Sale Id shift 159',0.00,2144021.40,810.00,2144021.40,0.00,'2022-08-10 10:16:51'),(346,'21','226',3,'Sale Id shift 159',0.00,155677.40,835.00,155677.40,0.00,'2022-08-10 10:16:51'),(347,'21','226',2,'Sale Id shift 160',0.00,2610597.60,810.00,2610597.60,0.00,'2022-08-10 10:28:15'),(348,'21','226',3,'Sale Id shift 160',0.00,81362.40,835.00,81362.40,0.00,'2022-08-10 10:28:15'),(349,'21','226',2,'Sale Id shift 161',0.00,2495828.70,810.00,2495828.70,0.00,'2022-08-10 10:38:20'),(350,'21','226',3,'Sale Id shift 161',0.00,60629.35,835.00,60629.35,0.00,'2022-08-10 10:38:20'),(351,'21','226',1,'Sale Id shift 162',0.00,5508612.00,180.00,5508612.00,0.00,'2022-08-10 10:53:30'),(352,'21','226',2,'Sale Id shift 162',0.00,4017818.70,810.00,4017818.70,0.00,'2022-08-10 10:53:30'),(353,'21','226',3,'Sale Id shift 162',0.00,80635.95,835.00,80635.95,0.00,'2022-08-10 10:53:30'),(354,'21','226',1,'Sale Id shift 163',0.00,5416968.60,180.00,5416968.60,0.00,'2022-08-11 18:44:55'),(355,'21','226',2,'Sale Id shift 163',0.00,2578513.50,810.00,2578513.50,0.00,'2022-08-11 18:44:55'),(356,'21','226',3,'Sale Id shift 163',0.00,49331.80,835.00,49331.80,0.00,'2022-08-11 18:44:55'),(357,'21','226',1,'Sale Id shift 164',0.00,4759570.80,180.00,4759570.80,0.00,'2022-08-14 05:48:33'),(358,'21','226',2,'Sale Id shift 164',0.00,2823473.70,810.00,2823473.70,0.00,'2022-08-14 05:48:33'),(359,'21','226',3,'Sale Id shift 164',0.00,57665.10,835.00,57665.10,0.00,'2022-08-14 05:48:33'),(360,'21','226',1,'Sale Id shift 165',0.00,5948362.80,180.00,5948362.80,0.00,'2022-08-16 13:28:30'),(361,'21','226',2,'Sale Id shift 165',0.00,1561809.60,810.00,1561809.60,0.00,'2022-08-16 13:28:30'),(362,'21','226',3,'Sale Id shift 165',0.00,13652.25,835.00,13652.25,0.00,'2022-08-16 13:28:30'),(363,'21','226',3,'Sale Id shift 166',0.00,90482.50,850.00,90482.50,0.00,'2022-08-16 14:24:14'),(364,'21','226',2,'Sale Id shift 167',0.00,2623630.50,810.00,2623630.50,0.00,'2022-08-16 14:34:31'),(365,'21','226',3,'Sale Id shift 167',0.00,68042.50,850.00,68042.50,0.00,'2022-08-16 14:34:31'),(366,'21','226',1,'Sale Id shift 168',0.00,5500956.60,180.00,5500956.60,0.00,'2022-08-16 14:41:23'),(367,'21','226',2,'Sale Id shift 168',0.00,3015743.40,810.00,3015743.40,0.00,'2022-08-16 14:41:23'),(368,'21','226',3,'Sale Id shift 168',0.00,85408.00,850.00,85408.00,0.00,'2022-08-16 14:41:23'),(369,'21','226',2,'Sale Id shift 169',0.00,3134959.20,810.00,3134959.20,0.00,'2022-08-16 15:15:40'),(370,'21','226',3,'Sale Id shift 169',0.00,161007.00,850.00,161007.00,0.00,'2022-08-16 15:15:40'),(371,'21','226',1,'Sale Id shift 169',0.00,3687319.80,180.00,3687319.80,0.00,'2022-08-16 15:15:40'),(372,'21','226',2,'Sale Id shift 170',0.00,2469495.60,810.00,2469495.60,0.00,'2022-08-19 15:06:46'),(373,'21','226',3,'Sale Id shift 170',0.00,94919.50,850.00,94919.50,0.00,'2022-08-19 15:06:46'),(374,'21','226',1,'Sale Id shift 171',0.00,5384647.80,180.00,5384647.80,0.00,'2022-08-19 15:28:29'),(375,'21','226',2,'Sale Id shift 171',0.00,3096638.10,810.00,3096638.10,0.00,'2022-08-19 15:28:29'),(376,'21','226',3,'Sale Id shift 171',0.00,82773.00,850.00,82773.00,0.00,'2022-08-19 15:28:29'),(377,'21','226',3,'Sale Id shift 172',0.00,40349.50,850.00,40349.50,0.00,'2022-08-19 16:16:17'),(378,'21','226',2,'Sale Id shift 173',0.00,2834133.30,810.00,2834133.30,0.00,'2022-08-22 11:28:36'),(379,'21','226',3,'Sale Id shift 173',0.00,48521.20,860.00,48521.20,0.00,'2022-08-22 11:28:36'),(380,'21','226',2,'Sale Id shift 174',0.00,389896.00,800.00,389896.00,0.00,'2022-08-22 11:37:56'),(381,'21','226',1,'Sale Id shift 175',0.00,100783.80,180.00,100783.80,0.00,'2022-08-22 11:46:03'),(382,'21','226',2,'Sale Id shift 176',0.00,3016760.00,800.00,3016760.00,0.00,'2022-08-22 11:52:46'),(383,'21','226',3,'Sale Id shift 176',0.00,94918.20,860.00,94918.20,0.00,'2022-08-22 11:52:46'),(384,'21','226',2,'Sale Id shift 177',0.00,1585136.00,800.00,1585136.00,0.00,'2022-08-22 12:00:21'),(385,'21','226',3,'Sale Id shift 177',0.00,75009.20,860.00,75009.20,0.00,'2022-08-22 12:00:21'),(386,'21','226',1,'Sale Id shift 178',0.00,5006437.20,180.00,5006437.20,0.00,'2022-08-22 12:24:29'),(387,'21','226',2,'Sale Id shift 178',0.00,3071552.00,800.00,3071552.00,0.00,'2022-08-22 12:24:29'),(388,'21','226',3,'Sale Id shift 178',0.00,1557537.40,860.00,1557537.40,0.00,'2022-08-22 12:24:29'),(389,'21','226',1,'Sale Id shift 179',0.00,5153500.80,180.00,5153500.80,0.00,'2022-09-01 09:40:09'),(390,'21','226',2,'Sale Id shift 179',0.00,4307992.00,800.00,4307992.00,0.00,'2022-09-01 09:40:09'),(391,'21','226',3,'Sale Id shift 179',0.00,128355.00,860.00,128355.00,0.00,'2022-09-01 09:40:09'),(392,'21','226',2,'Sale Id shift 180',0.00,2106400.00,800.00,2106400.00,0.00,'2022-09-03 08:36:17'),(393,'21','226',3,'Sale Id shift 180',0.00,91839.40,860.00,91839.40,0.00,'2022-09-03 08:36:17'),(394,'21','226',1,'Sale Id shift 180',0.00,4723356.60,180.00,4723356.60,0.00,'2022-09-03 08:36:17'),(395,'21','226',1,'Sale Id shift 181',0.00,5606515.80,180.00,5606515.80,0.00,'2022-09-03 08:48:58'),(396,'21','226',2,'Sale Id shift 181',0.00,2313872.00,800.00,2313872.00,0.00,'2022-09-03 08:48:58'),(397,'21','226',3,'Sale Id shift 181',0.00,66976.80,860.00,66976.80,0.00,'2022-09-03 08:48:58'),(398,'21','226',2,'Sale Id shift 182',0.00,3133664.00,800.00,3133664.00,0.00,'2022-09-03 09:05:27'),(399,'21','226',3,'Sale Id shift 182',0.00,72601.20,860.00,72601.20,0.00,'2022-09-03 09:05:27'),(400,'21','226',1,'Sale Id shift 182',0.00,5957508.60,180.00,5957508.60,0.00,'2022-09-03 09:05:27'),(401,'21','226',2,'Sale Id shift 183',0.00,2445544.00,800.00,2445544.00,0.00,'2022-09-03 09:13:29'),(402,'21','226',3,'Sale Id shift 183',0.00,96216.80,860.00,96216.80,0.00,'2022-09-03 09:13:29'),(403,'21','226',1,'Sale Id shift 183',0.00,173043.00,180.00,173043.00,0.00,'2022-09-03 09:13:29'),(404,'21','226',2,'Sale Id shift 184',0.00,3769792.00,800.00,3769792.00,0.00,'2022-09-03 09:24:58'),(405,'21','226',3,'Sale Id shift 184',0.00,81089.40,860.00,81089.40,0.00,'2022-09-03 09:24:58'),(406,'21','226',1,'Sale Id shift 184',0.00,5499091.80,180.00,5499091.80,0.00,'2022-09-03 09:24:58'),(407,'21','226',2,'Sale Id shift 185',0.00,1741520.00,800.00,1741520.00,0.00,'2022-09-03 09:31:05'),(408,'21','226',3,'Sale Id shift 185',0.00,80754.00,860.00,80754.00,0.00,'2022-09-03 09:31:05'),(409,'21','226',2,'Sale Id shift 186',0.00,2100368.00,800.00,2100368.00,0.00,'2022-09-03 09:38:16'),(410,'21','226',3,'Sale Id shift 186',0.00,206881.60,860.00,206881.60,0.00,'2022-09-03 09:38:16'),(411,'21','226',1,'Sale Id shift 187',0.00,6503063.40,180.00,6503063.40,0.00,'2022-09-03 09:55:26'),(412,'21','226',2,'Sale Id shift 187',0.00,1352584.00,800.00,1352584.00,0.00,'2022-09-03 09:55:26'),(413,'21','226',3,'Sale Id shift 187',0.00,99656.80,860.00,99656.80,0.00,'2022-09-03 09:55:26'),(414,'21','226',1,'Sale Id shift 188',0.00,1675683.00,180.00,1675683.00,0.00,'2022-09-03 11:54:11'),(415,'21','226',2,'Sale Id shift 188',0.00,2709512.00,800.00,2709512.00,0.00,'2022-09-03 11:54:11'),(416,'21','226',3,'Sale Id shift 188',0.00,109460.80,860.00,109460.80,0.00,'2022-09-03 11:54:11'),(417,'21','226',1,'Sale Id shift 189',0.00,5594956.20,180.00,5594956.20,0.00,'2022-09-06 08:33:05'),(418,'21','226',2,'Sale Id shift 189',0.00,2022680.00,800.00,2022680.00,0.00,'2022-09-06 08:33:05'),(419,'21','226',3,'Sale Id shift 189',0.00,74716.80,860.00,74716.80,0.00,'2022-09-06 08:33:05'),(420,'21','226',2,'Sale Id shift 190',0.00,2077328.00,800.00,2077328.00,0.00,'2022-09-06 08:45:25'),(421,'21','226',3,'Sale Id shift 190',0.00,143499.60,860.00,143499.60,0.00,'2022-09-06 08:45:25'),(422,'21','226',1,'Sale Id shift 190',0.00,5154816.60,180.00,5154816.60,0.00,'2022-09-06 08:45:25'),(423,'21','226',1,'Sale Id shift 191',0.00,4613167.80,180.00,4613167.80,0.00,'2022-09-06 08:53:36'),(424,'21','226',2,'Sale Id shift 191',0.00,2634328.00,800.00,2634328.00,0.00,'2022-09-06 08:53:36'),(425,'21','226',3,'Sale Id shift 191',0.00,245813.80,860.00,245813.80,0.00,'2022-09-06 08:53:36'),(426,'21','226',1,'Sale Id shift 192',0.00,6552270.00,180.00,6552270.00,0.00,'2022-09-06 09:06:58'),(427,'21','226',2,'Sale Id shift 192',0.00,2506672.00,800.00,2506672.00,0.00,'2022-09-06 09:06:58'),(428,'21','226',3,'Sale Id shift 192',0.00,114844.40,860.00,114844.40,0.00,'2022-09-06 09:06:58'),(429,'21','226',1,'Sale Id shift 193',0.00,6739336.80,180.00,6739336.80,0.00,'2022-09-06 09:34:19'),(430,'21','226',2,'Sale Id shift 193',0.00,3602488.00,800.00,3602488.00,0.00,'2022-09-06 09:34:19'),(431,'21','226',3,'Sale Id shift 193',0.00,108179.40,860.00,108179.40,0.00,'2022-09-06 09:34:19'),(432,'21','226',2,'Sale Id shift 194',0.00,2316632.00,800.00,2316632.00,0.00,'2022-09-15 12:31:28'),(433,'21','226',3,'Sale Id shift 194',0.00,188641.00,860.00,188641.00,0.00,'2022-09-15 12:31:28'),(434,'21','226',1,'Sale Id shift 195',0.00,6554624.40,180.00,6554624.40,0.00,'2022-09-15 13:05:16'),(435,'21','226',2,'Sale Id shift 195',0.00,3847448.00,800.00,3847448.00,0.00,'2022-09-15 13:05:16'),(436,'21','226',3,'Sale Id shift 195',0.00,113313.60,860.00,113313.60,0.00,'2022-09-15 13:05:16'),(437,'21','226',1,'Sale Id shift 196',0.00,7150761.00,180.00,7150761.00,0.00,'2022-09-15 13:30:05'),(438,'21','226',2,'Sale Id shift 196',0.00,2568328.00,800.00,2568328.00,0.00,'2022-09-15 13:30:05'),(439,'21','226',3,'Sale Id shift 196',0.00,121217.00,860.00,121217.00,0.00,'2022-09-15 13:30:05'),(440,'21','226',1,'Sale Id shift 197',0.00,6604176.60,180.00,6604176.60,0.00,'2022-09-15 13:57:01'),(441,'21','226',2,'Sale Id shift 197',0.00,2873152.00,800.00,2873152.00,0.00,'2022-09-15 13:57:01'),(442,'21','226',3,'Sale Id shift 197',0.00,138081.60,860.00,138081.60,0.00,'2022-09-15 13:57:01'),(443,'21','226',1,'Sale Id shift 198',0.00,7321478.40,180.00,7321478.40,0.00,'2022-09-15 14:27:56'),(444,'21','226',2,'Sale Id shift 198',0.00,3602000.00,800.00,3602000.00,0.00,'2022-09-15 14:27:56'),(445,'21','226',3,'Sale Id shift 198',0.00,69574.00,860.00,69574.00,0.00,'2022-09-15 14:27:56'),(446,'21','226',1,'Sale Id shift 199',0.00,5254813.80,180.00,5254813.80,0.00,'2022-09-15 14:47:20'),(447,'21','226',2,'Sale Id shift 199',0.00,2738424.00,800.00,2738424.00,0.00,'2022-09-15 14:47:20'),(448,'21','226',3,'Sale Id shift 199',0.00,127400.40,860.00,127400.40,0.00,'2022-09-15 14:47:20'),(449,'21','226',2,'Sale Id shift 200',0.00,2654920.00,800.00,2654920.00,0.00,'2022-09-15 15:08:53'),(450,'21','226',3,'Sale Id shift 200',0.00,104464.20,860.00,104464.20,0.00,'2022-09-15 15:08:53'),(451,'21','226',1,'Sale Id shift 201',0.00,5273469.00,180.00,5273469.00,0.00,'2022-09-15 15:22:19'),(452,'21','226',2,'Sale Id shift 201',0.00,3646208.00,800.00,3646208.00,0.00,'2022-09-15 15:22:19'),(453,'21','226',3,'Sale Id shift 201',0.00,133394.60,860.00,133394.60,0.00,'2022-09-15 15:22:19'),(454,'21','226',2,'Sale Id shift 202',0.00,2104080.00,800.00,2104080.00,0.00,'2022-09-15 15:54:05'),(455,'21','226',3,'Sale Id shift 202',0.00,70038.40,860.00,70038.40,0.00,'2022-09-15 15:54:05'),(456,'21','226',1,'Sale Id shift 202',0.00,4860244.80,180.00,4860244.80,0.00,'2022-09-15 15:54:05'),(457,'21','226',1,'Sale Id shift 203',0.00,3425722.20,180.00,3425722.20,0.00,'2022-09-28 16:21:35'),(458,'21','226',2,'Sale Id shift 203',0.00,3337872.00,800.00,3337872.00,0.00,'2022-09-28 16:21:35'),(459,'21','226',3,'Sale Id shift 203',0.00,84538.00,860.00,84538.00,0.00,'2022-09-28 16:21:35');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1678 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('21','226',27,'','24','2',0.00,16730000.00,'Purchase Id 14 for 23,900.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-22 07:41:10','',''),('21','226',28,'','supplier','1',16730000.00,0.00,'Purchase Id 14 for 23,900.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-22 07:41:10','',''),('21','226',29,'','24','2',0.00,1237500.00,'Purchase Id 10 for 7,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-22 07:52:00','',''),('21','226',30,'','supplier','1',1237500.00,0.00,'Purchase Id 10 for 7,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-22 07:52:00','',''),('21','226',31,'','24','2',0.00,4840000.00,'Purchase Id 13 for 8,800.00 litters of Kerosene - DPK from AYM SHAFA NIGERIA. LTD','2022-03-22 08:03:02','',''),('21','226',32,'','supplier','1',4840000.00,0.00,'Purchase Id 13 for 8,800.00 litters of Kerosene - DPK from AYM SHAFA NIGERIA. LTD','2022-03-22 08:03:02','',''),('21','226',33,'','20','4',4083943.40,0.00,'Sales from shift 6 on 2022-03-22 10:50:31 ','2022-03-22 10:50:31','',''),('21','226',34,'','6.1','3',0.00,4083943.40,'Sales from shift 6 on 2022-03-22 10:50:31 ','2022-03-22 10:50:31','',''),('21','226',35,'','24','2',0.00,5060000.00,'Purchase Id 12 for 9,200.00 litters of Kerosene - DPK from AYM SHAFA NIGERIA. LTD','2022-03-22 17:56:21','',''),('21','226',36,'','supplier','1',5060000.00,0.00,'Purchase Id 12 for 9,200.00 litters of Kerosene - DPK from AYM SHAFA NIGERIA. LTD','2022-03-22 17:56:21','',''),('21','226',37,'','24','2',0.00,17290000.00,'Purchase Id 11 for 24,700.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-22 17:58:42','',''),('21','226',38,'','supplier','1',17290000.00,0.00,'Purchase Id 11 for 24,700.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-22 17:58:42','',''),('21','226',39,'','6.1','3',485640.00,0.00,'Payment Id 25 for invoice:6, receipt: UBA CSH by AYM SHAFA NIGERIA. LTD','2022-03-23 08:45:58','',''),('21','226',40,'','supplier','1',0.00,485640.00,'Payment Id 25 for invoice:6, receipt: UBA CSH by AYM SHAFA NIGERIA. LTD','2022-03-23 08:45:58','',''),('21','226',41,'','6.1','3',2333000.00,0.00,'Payment Id 24 for invoice:6, receipt: UBA CSH by AYM SHAFA NIGERIA. LTD','2022-03-23 08:46:46','',''),('21','226',42,'','supplier','1',0.00,2333000.00,'Payment Id 24 for invoice:6, receipt: UBA CSH by AYM SHAFA NIGERIA. LTD','2022-03-23 08:46:46','',''),('21','226',43,'','2','12',914000.00,0.00,'Payment Id 23 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:47:48','',''),('21','226',44,'','supplier','1',0.00,914000.00,'Payment Id 23 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:47:48','',''),('21','226',45,'','2','11',197800.00,0.00,'Payment Id 22 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:48:36','',''),('21','226',46,'','supplier','1',0.00,197800.00,'Payment Id 22 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:48:36','',''),('21','226',47,'','2','10',69500.00,0.00,'Payment Id 20 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:49:13','',''),('21','226',48,'','supplier','1',0.00,69500.00,'Payment Id 20 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:49:13','',''),('21','226',49,'','6.1','3',49000.00,0.00,'Payment Id 19 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:49:13','',''),('21','226',50,'','supplier','1',0.00,49000.00,'Payment Id 19 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:49:13','',''),('21','226',51,'','6.1','3',35000.00,0.00,'Payment Id 18 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:50:26','',''),('21','226',52,'','supplier','1',0.00,35000.00,'Payment Id 18 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 08:50:26','',''),('21','226',53,'','24','2',0.00,4950000.00,'Purchase Id 15 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-23 09:19:39','',''),('21','226',54,'','supplier','1',4950000.00,0.00,'Purchase Id 15 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-23 09:19:39','',''),('21','226',55,'','20','4',6350039.25,0.00,'Sales from shift 7 on 2022-03-23 09:34:33 ','2022-03-23 09:34:33','',''),('21','226',56,'','6.1','3',0.00,6350039.25,'Sales from shift 7 on 2022-03-23 09:34:33 ','2022-03-23 09:34:33','',''),('21','226',57,'','2','9',1199035.00,0.00,'Payment Id 33 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',58,'','supplier','1',0.00,1199035.00,'Payment Id 33 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',59,'','2','12',140000.00,0.00,'Payment Id 32 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',60,'','supplier','1',0.00,140000.00,'Payment Id 32 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',61,'','2','9',1055500.00,0.00,'Payment Id 31 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',62,'','supplier','1',0.00,1055500.00,'Payment Id 31 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',63,'','2','9',2316500.00,0.00,'Payment Id 30 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',64,'','supplier','1',0.00,2316500.00,'Payment Id 30 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',65,'','2','10',641443.54,0.00,'Payment Id 29 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',66,'','supplier','1',0.00,641443.54,'Payment Id 29 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',67,'','2','6',343556.91,0.00,'Payment Id 28 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',68,'','supplier','1',0.00,343556.91,'Payment Id 28 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',69,'','6.1','3',49000.00,0.00,'Payment Id 27 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',70,'','supplier','1',0.00,49000.00,'Payment Id 27 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:26:49','',''),('21','226',71,'','6.1','3',605000.00,0.00,'Payment Id 26 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:27:40','',''),('21','226',72,'','supplier','1',0.00,605000.00,'Payment Id 26 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-23 13:27:40','',''),('21','226',73,'','24','2',0.00,4950000.00,'Purchase Id 16 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-24 08:06:14','',''),('21','226',74,'','supplier','1',4950000.00,0.00,'Purchase Id 16 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-24 08:06:14','',''),('21','226',75,'','20','4',8718433.55,0.00,'Sales from shift 8 on 2022-03-24 09:00:47 ','2022-03-24 09:00:47','',''),('21','226',76,'','6.1','3',0.00,8718433.55,'Sales from shift 8 on 2022-03-24 09:00:47 ','2022-03-24 09:00:47','',''),('21','226',77,'','2','9',1443440.00,0.00,'Payment Id 46 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:24','',''),('21','226',78,'','supplier','1',0.00,1443440.00,'Payment Id 46 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:24','',''),('21','226',79,'','6.1','3',35000.00,0.00,'Payment Id 45 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:24','',''),('21','226',80,'','supplier','1',0.00,35000.00,'Payment Id 45 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:24','',''),('21','226',81,'','6.1','3',35800.00,0.00,'Payment Id 44 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:24','',''),('21','226',82,'','supplier','1',0.00,35800.00,'Payment Id 44 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:24','',''),('21','226',83,'','6.1','3',570000.00,0.00,'Payment Id 43 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:24','',''),('21','226',84,'','supplier','1',0.00,570000.00,'Payment Id 43 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:24','',''),('21','226',85,'','6.1','3',35000.00,0.00,'Payment Id 42 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',86,'','supplier','1',0.00,35000.00,'Payment Id 42 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',87,'','6.1','3',525000.00,0.00,'Payment Id 41 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',88,'','supplier','1',0.00,525000.00,'Payment Id 41 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',89,'','6.1','3',49000.00,0.00,'Payment Id 40 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',90,'','supplier','1',0.00,49000.00,'Payment Id 40 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',91,'','2','9',799000.00,0.00,'Payment Id 39 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',92,'','supplier','1',0.00,799000.00,'Payment Id 39 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',93,'','2','9',3100000.00,0.00,'Payment Id 38 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',94,'','supplier','1',0.00,3100000.00,'Payment Id 38 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',95,'','2','12',605000.00,0.00,'Payment Id 37 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',96,'','supplier','1',0.00,605000.00,'Payment Id 37 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:03:25','',''),('21','226',97,'','2','11',248794.36,0.00,'Payment Id 36 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:04:02','',''),('21','226',98,'','supplier','1',0.00,248794.36,'Payment Id 36 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:04:02','',''),('21','226',99,'','2','6',118600.00,0.00,'Payment Id 35 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:04:02','',''),('21','226',100,'','supplier','1',0.00,118600.00,'Payment Id 35 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:04:02','',''),('21','226',101,'','2','10',1153899.15,0.00,'Payment Id 34 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:04:02','',''),('21','226',102,'','supplier','1',0.00,1153899.15,'Payment Id 34 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-24 22:04:02','',''),('21','226',103,'','20','4',7113697.30,0.00,'Sales from shift 9 on 2022-04-04 10:22:22 ','2022-04-04 10:22:22','',''),('21','226',104,'','6.1','3',0.00,7113697.30,'Sales from shift 9 on 2022-04-04 10:22:22 ','2022-04-04 10:22:22','',''),('21','226',105,'','24','2',0.00,4455000.00,'Purchase Id 17 for 27,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 10:31:46','',''),('21','226',106,'','supplier','1',4455000.00,0.00,'Purchase Id 17 for 27,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 10:31:46','',''),('21','226',107,'','24','2',0.00,2970000.00,'Purchase Id 18 for 18,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 10:38:02','',''),('21','226',108,'','supplier','1',2970000.00,0.00,'Purchase Id 18 for 18,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 10:38:02','',''),('21','226',109,'','20','4',8023349.40,0.00,'Sales from shift 10 on 2022-04-04 11:08:35 ','2022-04-04 11:08:35','',''),('21','226',110,'','6.1','3',0.00,8023349.40,'Sales from shift 10 on 2022-04-04 11:08:35 ','2022-04-04 11:08:35','',''),('21','226',111,'','24','2',0.00,4455000.00,'Purchase Id 19 for 27,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 11:18:44','',''),('21','226',112,'','supplier','1',4455000.00,0.00,'Purchase Id 19 for 27,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 11:18:44','',''),('21','226',113,'','20','4',4604493.60,0.00,'Sales from shift 11 on 2022-04-04 12:03:33 ','2022-04-04 12:03:33','',''),('21','226',114,'','6.1','3',0.00,4604493.60,'Sales from shift 11 on 2022-04-04 12:03:33 ','2022-04-04 12:03:33','',''),('21','226',115,'','20','4',4033507.95,0.00,'Sales from shift 12 on 2022-04-04 12:39:15 ','2022-04-04 12:39:15','',''),('21','226',116,'','6.1','3',0.00,4033507.95,'Sales from shift 12 on 2022-04-04 12:39:15 ','2022-04-04 12:39:15','',''),('21','226',117,'','24','2',0.00,4950000.00,'Purchase Id 20 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 12:41:32','',''),('21','226',118,'','supplier','1',4950000.00,0.00,'Purchase Id 20 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 12:41:32','',''),('21','226',119,'','20','4',7325357.30,0.00,'Sales from shift 13 on 2022-04-04 13:58:29 ','2022-04-04 13:58:29','',''),('21','226',120,'','6.1','3',0.00,7325357.30,'Sales from shift 13 on 2022-04-04 13:58:29 ','2022-04-04 13:58:29','',''),('21','226',121,'','24','2',0.00,4950000.00,'Purchase Id 21 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 14:03:06','',''),('21','226',122,'','supplier','1',4950000.00,0.00,'Purchase Id 21 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 14:03:06','',''),('21','226',123,'','20','4',6734824.75,0.00,'Sales from shift 14 on 2022-04-04 15:04:10 ','2022-04-04 15:04:10','',''),('21','226',124,'','6.1','3',0.00,6734824.75,'Sales from shift 14 on 2022-04-04 15:04:10 ','2022-04-04 15:04:10','',''),('21','226',125,'','24','2',0.00,4950000.00,'Purchase Id 22 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 15:07:48','',''),('21','226',126,'','supplier','1',4950000.00,0.00,'Purchase Id 22 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 15:07:48','',''),('21','226',127,'','24','2',0.00,2475000.00,'Purchase Id 23 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 15:20:50','',''),('21','226',128,'','supplier','1',2475000.00,0.00,'Purchase Id 23 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 15:20:50','',''),('21','226',129,'','20','4',5098807.35,0.00,'Sales from shift 15 on 2022-04-04 15:42:27 ','2022-04-04 15:42:27','',''),('21','226',130,'','6.1','3',0.00,5098807.35,'Sales from shift 15 on 2022-04-04 15:42:27 ','2022-04-04 15:42:27','',''),('21','226',131,'','6.1','3',40000.00,0.00,'Payment Id 122 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',132,'','supplier','1',0.00,40000.00,'Payment Id 122 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',133,'','6.1','3',30000.00,0.00,'Payment Id 121 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',134,'','supplier','1',0.00,30000.00,'Payment Id 121 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',135,'','6.1','3',444000.00,0.00,'Payment Id 120 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',136,'','supplier','1',0.00,444000.00,'Payment Id 120 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',137,'','6.1','3',49000.00,0.00,'Payment Id 119 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',138,'','supplier','1',0.00,49000.00,'Payment Id 119 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',139,'','6.1','3',35000.00,0.00,'Payment Id 118 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',140,'','supplier','1',0.00,35000.00,'Payment Id 118 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',141,'','6.1','3',535000.00,0.00,'Payment Id 117 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',142,'','supplier','1',0.00,535000.00,'Payment Id 117 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',143,'','6.1','3',49000.00,0.00,'Payment Id 116 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',144,'','supplier','1',0.00,49000.00,'Payment Id 116 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',145,'','2','9',958230.00,0.00,'Payment Id 115 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',146,'','supplier','1',0.00,958230.00,'Payment Id 115 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',147,'','2','9',2195000.00,0.00,'Payment Id 114 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',148,'','supplier','1',0.00,2195000.00,'Payment Id 114 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',149,'','2','12',514000.00,0.00,'Payment Id 113 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',150,'','supplier','1',0.00,514000.00,'Payment Id 113 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:09','',''),('21','226',151,'','2','10',118150.00,0.00,'Payment Id 123 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:18','',''),('21','226',152,'','supplier','1',0.00,118150.00,'Payment Id 123 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:18','',''),('21','226',153,'','2','6',207200.00,0.00,'Payment Id 112 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',154,'','supplier','1',0.00,207200.00,'Payment Id 112 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',155,'','2','6',66515.20,0.00,'Payment Id 111 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',156,'','supplier','1',0.00,66515.20,'Payment Id 111 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',157,'','2','11',257182.50,0.00,'Payment Id 110 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',158,'','supplier','1',0.00,257182.50,'Payment Id 110 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',159,'','2','10',281680.10,0.00,'Payment Id 109 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',160,'','supplier','1',0.00,281680.10,'Payment Id 109 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',161,'','6.1','3',535000.00,0.00,'Payment Id 108 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',162,'','supplier','1',0.00,535000.00,'Payment Id 108 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',163,'','6.1','3',535000.00,0.00,'Payment Id 107 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',164,'','supplier','1',0.00,535000.00,'Payment Id 107 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',165,'','6.1','3',35000.00,0.00,'Payment Id 106 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',166,'','supplier','1',0.00,35000.00,'Payment Id 106 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',167,'','6.1','3',49000.00,0.00,'Payment Id 105 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',168,'','supplier','1',0.00,49000.00,'Payment Id 105 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',169,'','2','9',1685330.00,0.00,'Payment Id 104 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',170,'','supplier','1',0.00,1685330.00,'Payment Id 104 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:33:41','',''),('21','226',171,'','2','9',1000000.00,0.00,'Payment Id 103 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',172,'','supplier','1',0.00,1000000.00,'Payment Id 103 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',173,'','2','9',1775000.00,0.00,'Payment Id 102 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',174,'','supplier','1',0.00,1775000.00,'Payment Id 102 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',175,'','2','12',238800.00,0.00,'Payment Id 101 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',176,'','supplier','1',0.00,238800.00,'Payment Id 101 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',177,'','2','11',146749.45,0.00,'Payment Id 100 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',178,'','supplier','1',0.00,146749.45,'Payment Id 100 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',179,'','2','6',207489.30,0.00,'Payment Id 99 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',180,'','supplier','1',0.00,207489.30,'Payment Id 99 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',181,'','2','19',129925.00,0.00,'Payment Id 98 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',182,'','supplier','1',0.00,129925.00,'Payment Id 98 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',183,'','2','10',397525.20,0.00,'Payment Id 97 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',184,'','supplier','1',0.00,397525.20,'Payment Id 97 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',185,'','6.1','3',35000.00,0.00,'Payment Id 96 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',186,'','supplier','1',0.00,35000.00,'Payment Id 96 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',187,'','6.1','3',10000.00,0.00,'Payment Id 95 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',188,'','supplier','1',0.00,10000.00,'Payment Id 95 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',189,'','6.1','3',20000.00,0.00,'Payment Id 94 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',190,'','supplier','1',0.00,20000.00,'Payment Id 94 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:34:18','',''),('21','226',191,'','2','12',858286.00,0.00,'Payment Id 93 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',192,'','supplier','1',0.00,858286.00,'Payment Id 93 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',193,'','2','9',2055000.00,0.00,'Payment Id 92 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',194,'','supplier','1',0.00,2055000.00,'Payment Id 92 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',195,'','2','9',700000.00,0.00,'Payment Id 91 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',196,'','supplier','1',0.00,700000.00,'Payment Id 91 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',197,'','2','9',1913880.00,0.00,'Payment Id 90 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',198,'','supplier','1',0.00,1913880.00,'Payment Id 90 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',199,'','2','11',612432.12,0.00,'Payment Id 89 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',200,'','supplier','1',0.00,612432.12,'Payment Id 89 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',201,'','2','19',7000.00,0.00,'Payment Id 88 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',202,'','supplier','1',0.00,7000.00,'Payment Id 88 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',203,'','2','6',201670.00,0.00,'Payment Id 87 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',204,'','supplier','1',0.00,201670.00,'Payment Id 87 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',205,'','6.1','3',49000.00,0.00,'Payment Id 86 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',206,'','supplier','1',0.00,49000.00,'Payment Id 86 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',207,'','2','10',293091.80,0.00,'Payment Id 85 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',208,'','supplier','1',0.00,293091.80,'Payment Id 85 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',209,'','6.1','3',535000.00,0.00,'Payment Id 84 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',210,'','supplier','1',0.00,535000.00,'Payment Id 84 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:07','',''),('21','226',211,'','2','6',128575.05,0.00,'Payment Id 124 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:16','',''),('21','226',212,'','supplier','1',0.00,128575.05,'Payment Id 124 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:16','',''),('21','226',213,'','6.1','3',35000.00,0.00,'Payment Id 83 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',214,'','supplier','1',0.00,35000.00,'Payment Id 83 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',215,'','2','12',644000.00,0.00,'Payment Id 82 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',216,'','supplier','1',0.00,644000.00,'Payment Id 82 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',217,'','2','9',223365.00,0.00,'Payment Id 81 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',218,'','supplier','1',0.00,223365.00,'Payment Id 81 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',219,'','2','9',1696500.00,0.00,'Payment Id 80 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',220,'','supplier','1',0.00,1696500.00,'Payment Id 80 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',221,'','2','11',419461.44,0.00,'Payment Id 79 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',222,'','supplier','1',0.00,419461.44,'Payment Id 79 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',223,'','2','6',150000.00,0.00,'Payment Id 78 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',224,'','supplier','1',0.00,150000.00,'Payment Id 78 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',225,'','2','6',101678.00,0.00,'Payment Id 77 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',226,'','supplier','1',0.00,101678.00,'Payment Id 77 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',227,'','2','10',179600.00,0.00,'Payment Id 76 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',228,'','supplier','1',0.00,179600.00,'Payment Id 76 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',229,'','6.1','3',570000.00,0.00,'Payment Id 75 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',230,'','supplier','1',0.00,570000.00,'Payment Id 75 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:35:43','',''),('21','226',231,'','2','6',239574.70,0.00,'Payment Id 125 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:00','',''),('21','226',232,'','supplier','1',0.00,239574.70,'Payment Id 125 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:00','',''),('21','226',233,'','6.1','3',49000.00,0.00,'Payment Id 74 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',234,'','supplier','1',0.00,49000.00,'Payment Id 74 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',235,'','6.1','3',35000.00,0.00,'Payment Id 73 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',236,'','supplier','1',0.00,35000.00,'Payment Id 73 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',237,'','6.1','3',49000.00,0.00,'Payment Id 72 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',238,'','supplier','1',0.00,49000.00,'Payment Id 72 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',239,'','2','19',23800.00,0.00,'Payment Id 71 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',240,'','supplier','1',0.00,23800.00,'Payment Id 71 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',241,'','2','9',1693360.00,0.00,'Payment Id 70 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',242,'','supplier','1',0.00,1693360.00,'Payment Id 70 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',243,'','2','9',2095000.00,0.00,'Payment Id 69 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',244,'','supplier','1',0.00,2095000.00,'Payment Id 69 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',245,'','2','12',133700.00,0.00,'Payment Id 68 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',246,'','supplier','1',0.00,133700.00,'Payment Id 68 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',247,'','2','6',488600.00,0.00,'Payment Id 67 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',248,'','supplier','1',0.00,488600.00,'Payment Id 67 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',249,'','2','10',86033.65,0.00,'Payment Id 66 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',250,'','supplier','1',0.00,86033.65,'Payment Id 66 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:24','',''),('21','226',251,'','2','11',223455.45,0.00,'Payment Id 126 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:32','',''),('21','226',252,'','supplier','1',0.00,223455.45,'Payment Id 126 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:36:32','',''),('21','226',253,'','6.1','3',570000.00,0.00,'Payment Id 65 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',254,'','supplier','1',0.00,570000.00,'Payment Id 65 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',255,'','6.1','3',49000.00,0.00,'Payment Id 64 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',256,'','supplier','1',0.00,49000.00,'Payment Id 64 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',257,'','6.1','3',35000.00,0.00,'Payment Id 63 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',258,'','supplier','1',0.00,35000.00,'Payment Id 63 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',259,'','2','9',1346030.00,0.00,'Payment Id 62 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',260,'','supplier','1',0.00,1346030.00,'Payment Id 62 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',261,'','2','12',165000.00,0.00,'Payment Id 61 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',262,'','supplier','1',0.00,165000.00,'Payment Id 61 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',263,'','2','9',4375000.00,0.00,'Payment Id 60 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',264,'','supplier','1',0.00,4375000.00,'Payment Id 60 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',265,'','2','11',717251.50,0.00,'Payment Id 59 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',266,'','supplier','1',0.00,717251.50,'Payment Id 59 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',267,'','2','6',343196.09,0.00,'Payment Id 58 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',268,'','supplier','1',0.00,343196.09,'Payment Id 58 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',269,'','2','10',422872.20,0.00,'Payment Id 57 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',270,'','supplier','1',0.00,422872.20,'Payment Id 57 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:26','',''),('21','226',271,'','2','19',36575.00,0.00,'Payment Id 127 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:32','',''),('21','226',272,'','supplier','1',0.00,36575.00,'Payment Id 127 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:32','',''),('21','226',273,'','2','12',274950.00,0.00,'Payment Id 128 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:57','',''),('21','226',274,'','supplier','1',0.00,274950.00,'Payment Id 128 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:37:57','',''),('21','226',275,'','6.1','3',30545.00,0.00,'Payment Id 56 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',276,'','supplier','1',0.00,30545.00,'Payment Id 56 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',277,'','6.1','3',535000.00,0.00,'Payment Id 55 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',278,'','supplier','1',0.00,535000.00,'Payment Id 55 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',279,'','6.1','3',49000.00,0.00,'Payment Id 54 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',280,'','supplier','1',0.00,49000.00,'Payment Id 54 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',281,'','2','9',919635.00,0.00,'Payment Id 53 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',282,'','supplier','1',0.00,919635.00,'Payment Id 53 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',283,'','2','9',1275000.00,0.00,'Payment Id 52 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',284,'','supplier','1',0.00,1275000.00,'Payment Id 52 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',285,'','2','9',2705000.00,0.00,'Payment Id 51 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',286,'','supplier','1',0.00,2705000.00,'Payment Id 51 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',287,'','2','12',806000.00,0.00,'Payment Id 50 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',288,'','supplier','1',0.00,806000.00,'Payment Id 50 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',289,'','2','11',162352.00,0.00,'Payment Id 49 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',290,'','supplier','1',0.00,162352.00,'Payment Id 49 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:38:22','',''),('21','226',291,'','2','9',1066000.00,0.00,'Payment Id 129 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:39:00','',''),('21','226',292,'','supplier','1',0.00,1066000.00,'Payment Id 129 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:39:00','',''),('21','226',293,'','2','6',246193.64,0.00,'Payment Id 48 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:39:37','',''),('21','226',294,'','supplier','1',0.00,246193.64,'Payment Id 48 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:39:37','',''),('21','226',295,'','2','10',384972.09,0.00,'Payment Id 47 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:39:37','',''),('21','226',296,'','supplier','1',0.00,384972.09,'Payment Id 47 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:39:37','',''),('21','226',297,'','2','9',550000.00,0.00,'Payment Id 130 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:40:32','',''),('21','226',298,'','supplier','1',0.00,550000.00,'Payment Id 130 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:40:32','',''),('21','226',299,'','2','9',918070.00,0.00,'Payment Id 131 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:41:05','',''),('21','226',300,'','supplier','1',0.00,918070.00,'Payment Id 131 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:41:05','',''),('21','226',301,'','20','4',4128349.25,0.00,'Sales from shift 16 on 2022-04-04 16:42:18 ','2022-04-04 16:42:18','',''),('21','226',302,'','6.1','3',0.00,4128349.25,'Sales from shift 16 on 2022-04-04 16:42:18 ','2022-04-04 16:42:18','',''),('21','226',303,'','24','2',0.00,7425000.00,'Purchase Id 24 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 16:53:52','',''),('21','226',304,'','supplier','1',7425000.00,0.00,'Purchase Id 24 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 16:53:52','',''),('21','226',305,'','20','4',361788.90,0.00,'Sales from shift 17 on 2022-04-04 16:56:17 ','2022-04-04 16:56:17','',''),('21','226',306,'','6.1','3',0.00,361788.90,'Sales from shift 17 on 2022-04-04 16:56:17 ','2022-04-04 16:56:17','',''),('21','226',307,'','20','4',5431406.20,0.00,'Sales from shift 18 on 2022-04-04 17:10:13 ','2022-04-04 17:10:13','',''),('21','226',308,'','6.1','3',0.00,5431406.20,'Sales from shift 18 on 2022-04-04 17:10:13 ','2022-04-04 17:10:13','',''),('21','226',309,'','24','2',0.00,2557500.00,'Purchase Id 25 for 15,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 17:12:39','',''),('21','226',310,'','supplier','1',2557500.00,0.00,'Purchase Id 25 for 15,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 17:12:39','',''),('21','226',311,'','20','4',4935352.95,0.00,'Sales from shift 19 on 2022-04-04 17:34:08 ','2022-04-04 17:34:08','',''),('21','226',312,'','6.1','3',0.00,4935352.95,'Sales from shift 19 on 2022-04-04 17:34:08 ','2022-04-04 17:34:08','',''),('21','226',313,'','24','2',0.00,2475000.00,'Purchase Id 26 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 17:37:42','',''),('21','226',314,'','supplier','1',2475000.00,0.00,'Purchase Id 26 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 17:37:42','',''),('21','226',315,'','24','2',0.00,7425000.00,'Purchase Id 27 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-05 10:00:32','',''),('21','226',316,'','supplier','1',7425000.00,0.00,'Purchase Id 27 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-05 10:00:32','',''),('21','226',317,'','24','2',0.00,2475000.00,'Purchase Id 28 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-05 10:06:43','',''),('21','226',318,'','supplier','1',2475000.00,0.00,'Purchase Id 28 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-05 10:06:43','',''),('21','226',319,'','2','9',1642980.00,0.00,'Payment Id 170 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',320,'','supplier','1',0.00,1642980.00,'Payment Id 170 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',321,'','2','9',1300000.00,0.00,'Payment Id 169 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',322,'','supplier','1',0.00,1300000.00,'Payment Id 169 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',323,'','2','9',2797000.00,0.00,'Payment Id 168 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',324,'','supplier','1',0.00,2797000.00,'Payment Id 168 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',325,'','6.1','3',8000.00,0.00,'Payment Id 167 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',326,'','supplier','1',0.00,8000.00,'Payment Id 167 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',327,'','6.1','3',49000.00,0.00,'Payment Id 166 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',328,'','supplier','1',0.00,49000.00,'Payment Id 166 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',329,'','6.1','3',49000.00,0.00,'Payment Id 165 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',330,'','supplier','1',0.00,49000.00,'Payment Id 165 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',331,'','6.1','3',35000.00,0.00,'Payment Id 164 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',332,'','supplier','1',0.00,35000.00,'Payment Id 164 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',333,'','2','12',30070.00,0.00,'Payment Id 163 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',334,'','supplier','1',0.00,30070.00,'Payment Id 163 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',335,'','2','19',37158.00,0.00,'Payment Id 162 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',336,'','supplier','1',0.00,37158.00,'Payment Id 162 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',337,'','2','11',145769.27,0.00,'Payment Id 161 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',338,'','supplier','1',0.00,145769.27,'Payment Id 161 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:44:40','',''),('21','226',339,'','2','6',80801.40,0.00,'Payment Id 160 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',340,'','supplier','1',0.00,80801.40,'Payment Id 160 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',341,'','2','6',240354.59,0.00,'Payment Id 159 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',342,'','supplier','1',0.00,240354.59,'Payment Id 159 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',343,'','2','10',455483.35,0.00,'Payment Id 158 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',344,'','supplier','1',0.00,455483.35,'Payment Id 158 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',345,'','2','12',5000.00,0.00,'Payment Id 157 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',346,'','supplier','1',0.00,5000.00,'Payment Id 157 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',347,'','6.1','3',5000.00,0.00,'Payment Id 156 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',348,'','supplier','1',0.00,5000.00,'Payment Id 156 for invoice:16, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',349,'','2','9',740685.00,0.00,'Payment Id 155 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',350,'','supplier','1',0.00,740685.00,'Payment Id 155 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',351,'','2','9',2305000.00,0.00,'Payment Id 154 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',352,'','supplier','1',0.00,2305000.00,'Payment Id 154 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',353,'','2','12',630700.00,0.00,'Payment Id 153 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',354,'','supplier','1',0.00,630700.00,'Payment Id 153 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',355,'','2','19',10500.00,0.00,'Payment Id 152 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',356,'','supplier','1',0.00,10500.00,'Payment Id 152 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',357,'','2','11',495586.84,0.00,'Payment Id 151 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',358,'','supplier','1',0.00,495586.84,'Payment Id 151 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:45:36','',''),('21','226',359,'','2','6',383198.66,0.00,'Payment Id 150 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',360,'','supplier','1',0.00,383198.66,'Payment Id 150 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',361,'','2','6',285683.00,0.00,'Payment Id 149 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',362,'','supplier','1',0.00,285683.00,'Payment Id 149 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',363,'','6.1','3',35000.00,0.00,'Payment Id 148 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',364,'','supplier','1',0.00,35000.00,'Payment Id 148 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',365,'','6.1','3',49000.00,0.00,'Payment Id 147 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',366,'','supplier','1',0.00,49000.00,'Payment Id 147 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',367,'','2','9',330255.00,0.00,'Payment Id 146 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',368,'','supplier','1',0.00,330255.00,'Payment Id 146 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',369,'','2','9',3350000.00,0.00,'Payment Id 145 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',370,'','supplier','1',0.00,3350000.00,'Payment Id 145 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',371,'','2','12',630440.00,0.00,'Payment Id 144 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',372,'','supplier','1',0.00,630440.00,'Payment Id 144 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',373,'','2','19',13294.00,0.00,'Payment Id 143 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',374,'','supplier','1',0.00,13294.00,'Payment Id 143 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',375,'','2','11',338349.66,0.00,'Payment Id 142 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',376,'','supplier','1',0.00,338349.66,'Payment Id 142 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',377,'','2','6',397472.76,0.00,'Payment Id 141 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',378,'','supplier','1',0.00,397472.76,'Payment Id 141 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:46:28','',''),('21','226',379,'','2','6',217589.66,0.00,'Payment Id 140 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',380,'','supplier','1',0.00,217589.66,'Payment Id 140 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',381,'','6.1','3',70000.00,0.00,'Payment Id 139 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',382,'','supplier','1',0.00,70000.00,'Payment Id 139 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',383,'','6.1','3',35000.00,0.00,'Payment Id 138 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',384,'','supplier','1',0.00,35000.00,'Payment Id 138 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',385,'','6.1','3',49000.00,0.00,'Payment Id 137 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',386,'','supplier','1',0.00,49000.00,'Payment Id 137 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',387,'','6.1','3',35000.00,0.00,'Payment Id 136 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',388,'','supplier','1',0.00,35000.00,'Payment Id 136 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',389,'','6.1','3',49000.00,0.00,'Payment Id 135 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',390,'','supplier','1',0.00,49000.00,'Payment Id 135 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',391,'','2','9',101135.00,0.00,'Payment Id 134 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',392,'','supplier','1',0.00,101135.00,'Payment Id 134 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',393,'','2','12',120000.00,0.00,'Payment Id 133 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',394,'','supplier','1',0.00,120000.00,'Payment Id 133 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',395,'','2','11',56650.00,0.00,'Payment Id 132 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',396,'','supplier','1',0.00,56650.00,'Payment Id 132 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:48:13','',''),('21','226',397,'','20','4',6870614.30,0.00,'Sales from shift 20 on 2022-04-06 09:33:57 ','2022-04-06 09:33:57','',''),('21','226',398,'','6.1','3',0.00,6870614.30,'Sales from shift 20 on 2022-04-06 09:33:57 ','2022-04-06 09:33:57','',''),('21','226',399,'','20','4',5160462.45,0.00,'Sales from shift 21 on 2022-04-06 15:31:14 ','2022-04-06 15:31:14','',''),('21','226',400,'','6.1','3',0.00,5160462.45,'Sales from shift 21 on 2022-04-06 15:31:14 ','2022-04-06 15:31:14','',''),('21','226',401,'','24','2',0.00,7425000.00,'Purchase Id 29 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-07 07:29:30','',''),('21','226',402,'','supplier','1',7425000.00,0.00,'Purchase Id 29 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-07 07:29:30','',''),('21','226',403,'','20','4',6459657.27,0.00,'Sales from shift 22 on 2022-04-07 07:48:22 ','2022-04-07 07:48:22','',''),('21','226',404,'','6.1','3',0.00,6459657.27,'Sales from shift 22 on 2022-04-07 07:48:22 ','2022-04-07 07:48:22','',''),('21','226',405,'','24','2',0.00,7425000.00,'Purchase Id 30 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-08 11:41:24','',''),('21','226',406,'','supplier','1',7425000.00,0.00,'Purchase Id 30 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-08 11:41:24','',''),('21','226',407,'','24','2',0.00,18200000.00,'Purchase Id 31 for 26,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-08 11:46:35','',''),('21','226',408,'','supplier','1',18200000.00,0.00,'Purchase Id 31 for 26,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-08 11:46:35','',''),('21','226',409,'','24','2',0.00,8250000.00,'Purchase Id 32 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-09 10:39:17','',''),('21','226',410,'','supplier','1',8250000.00,0.00,'Purchase Id 32 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-09 10:39:17','',''),('21','226',411,'','20','4',10584008.80,0.00,'Sales from shift 23 on 2022-04-09 10:47:59 ','2022-04-09 10:47:59','',''),('21','226',412,'','6.1','3',0.00,10584008.80,'Sales from shift 23 on 2022-04-09 10:47:59 ','2022-04-09 10:47:59','',''),('21','226',413,'','20','4',10052293.75,0.00,'Sales from shift 24 on 2022-04-10 09:35:52 ','2022-04-10 09:35:52','',''),('21','226',414,'','6.1','3',0.00,10052293.75,'Sales from shift 24 on 2022-04-10 09:35:52 ','2022-04-10 09:35:52','',''),('21','226',415,'','24','2',0.00,7425000.00,'Purchase Id 33 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-10 10:26:29','',''),('21','226',416,'','supplier','1',7425000.00,0.00,'Purchase Id 33 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-10 10:26:29','',''),('21','226',417,'','24','2',0.00,4950000.00,'Purchase Id 34 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-11 10:20:33','',''),('21','226',418,'','supplier','1',4950000.00,0.00,'Purchase Id 34 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-11 10:20:33','',''),('21','226',419,'','supplier','1',0.00,4950000.00,'Purchase Id 34 for 30,000.00 litters of Petrol - PMS returned to AYM SHAFA NIGERIA. LTD','2022-04-11 10:40:18','',''),('21','226',420,'','24','2',0.00,4950000.00,'Purchase Id 35 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-11 10:51:22','',''),('21','226',421,'','supplier','1',4950000.00,0.00,'Purchase Id 35 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-11 10:51:22','',''),('21','226',422,'','20','4',9403325.00,0.00,'Sales from shift 25 on 2022-04-11 10:55:34 ','2022-04-11 10:55:34','',''),('21','226',423,'','6.1','3',0.00,9403325.00,'Sales from shift 25 on 2022-04-11 10:55:34 ','2022-04-11 10:55:34','',''),('21','226',424,'','2','10',32600.00,0.00,'Payment Id 182 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 11:54:21','',''),('21','226',425,'','supplier','1',0.00,32600.00,'Payment Id 182 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 11:54:21','',''),('21','226',426,'','2','6',424376.09,0.00,'Payment Id 184 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 12:08:38','',''),('21','226',427,'','supplier','1',0.00,424376.09,'Payment Id 184 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 12:08:38','',''),('21','226',428,'','2','9',2800000.00,0.00,'Payment Id 186 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 12:11:58','',''),('21','226',429,'','supplier','1',0.00,2800000.00,'Payment Id 186 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 12:11:58','',''),('21','226',430,'','2','11',580373.38,0.00,'Payment Id 188 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 12:48:24','',''),('21','226',431,'','supplier','1',0.00,580373.38,'Payment Id 188 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 12:48:24','',''),('21','226',432,'','2','9',750000.00,0.00,'Payment Id 189 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 13:53:55','',''),('21','226',433,'','supplier','1',0.00,750000.00,'Payment Id 189 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-11 13:53:55','',''),('21','226',434,'','20','4',6888560.90,0.00,'Sales from shift 26 on 2022-04-12 16:16:51 ','2022-04-12 16:16:51','',''),('21','226',435,'','6.1','3',0.00,6888560.90,'Sales from shift 26 on 2022-04-12 16:16:51 ','2022-04-12 16:16:51','',''),('21','226',436,'','20','4',6007452.05,0.00,'Sales from shift 27 on 2022-04-12 17:13:14 ','2022-04-12 17:13:14','',''),('21','226',437,'','6.1','3',0.00,6007452.05,'Sales from shift 27 on 2022-04-12 17:13:14 ','2022-04-12 17:13:14','',''),('21','226',438,'','24','2',0.00,7425000.00,'Purchase Id 36 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-13 10:43:46','',''),('21','226',439,'','supplier','1',7425000.00,0.00,'Purchase Id 36 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-13 10:43:46','',''),('21','226',440,'','20','4',1751356.10,0.00,'Sales from shift 28 on 2022-04-13 10:56:28 ','2022-04-13 10:56:28','',''),('21','226',441,'','6.1','3',0.00,1751356.10,'Sales from shift 28 on 2022-04-13 10:56:28 ','2022-04-13 10:56:28','',''),('21','226',442,'','2','10',909175.28,0.00,'Payment Id 205 for invoice:24, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 12:28:10','',''),('21','226',443,'','supplier','1',0.00,909175.28,'Payment Id 205 for invoice:24, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 12:28:10','',''),('21','226',444,'','2','6',157218.34,0.00,'Payment Id 206 for invoice:24, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 12:32:24','',''),('21','226',445,'','supplier','1',0.00,157218.34,'Payment Id 206 for invoice:24, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 12:32:24','',''),('21','226',446,'','2','19',43661.05,0.00,'Payment Id 183 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 16:33:50','',''),('21','226',447,'','supplier','1',0.00,43661.05,'Payment Id 183 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 16:33:50','',''),('21','226',448,'','2','6',357231.72,0.00,'Payment Id 229 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 17:06:51','',''),('21','226',449,'','supplier','1',0.00,357231.72,'Payment Id 229 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 17:06:51','',''),('21','226',450,'','24','2',0.00,24255000.00,'Purchase Id 37 for 44,100.00 litters of Kerosene - DPK from AYM SHAFA NIGERIA. LTD','2022-04-14 09:08:37','',''),('21','226',451,'','supplier','1',24255000.00,0.00,'Purchase Id 37 for 44,100.00 litters of Kerosene - DPK from AYM SHAFA NIGERIA. LTD','2022-04-14 09:08:37','',''),('21','226',452,'','2','10',177265.00,0.00,'Payment Id 171 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:27:04','',''),('21','226',453,'','supplier','1',0.00,177265.00,'Payment Id 171 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:27:04','',''),('21','226',454,'','2','6',387195.09,0.00,'Payment Id 172 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:28:51','',''),('21','226',455,'','supplier','1',0.00,387195.09,'Payment Id 172 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:28:51','',''),('21','226',456,'','2','9',2470000.00,0.00,'Payment Id 177 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:32:31','',''),('21','226',457,'','supplier','1',0.00,2470000.00,'Payment Id 177 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:32:31','',''),('21','226',458,'','2','9',1020830.00,0.00,'Payment Id 178 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:34:06','',''),('21','226',459,'','supplier','1',0.00,1020830.00,'Payment Id 178 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:34:06','',''),('21','226',460,'','2','10',739107.15,0.00,'Payment Id 194 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:42:11','',''),('21','226',461,'','supplier','1',0.00,739107.15,'Payment Id 194 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:42:11','',''),('21','226',462,'','2','11',437900.00,0.00,'Payment Id 195 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:43:48','',''),('21','226',463,'','supplier','1',0.00,437900.00,'Payment Id 195 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:43:48','',''),('21','226',464,'','2','6',284255.15,0.00,'Payment Id 197 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:45:47','',''),('21','226',465,'','supplier','1',0.00,284255.15,'Payment Id 197 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:45:47','',''),('21','226',466,'','2','10',98761.15,0.00,'Payment Id 243 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:54:16','',''),('21','226',467,'','supplier','1',0.00,98761.15,'Payment Id 243 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:54:16','',''),('21','226',468,'','2','11',462540.06,0.00,'Payment Id 245 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:56:36','',''),('21','226',469,'','supplier','1',0.00,462540.06,'Payment Id 245 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:56:36','',''),('21','226',470,'','2','12',335000.00,0.00,'Payment Id 256 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 18:11:02','',''),('21','226',471,'','supplier','1',0.00,335000.00,'Payment Id 256 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 18:11:02','',''),('21','226',472,'','24','2',0.00,7425000.00,'Purchase Id 38 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-15 10:42:52','',''),('21','226',473,'','supplier','1',7425000.00,0.00,'Purchase Id 38 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-15 10:42:52','',''),('21','226',474,'','24','2',0.00,6600000.00,'Purchase Id 39 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-15 10:46:24','',''),('21','226',475,'','supplier','1',6600000.00,0.00,'Purchase Id 39 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-15 10:46:24','',''),('21','226',476,'','20','4',8247096.85,0.00,'Sales from shift 29 on 2022-04-15 10:50:54 ','2022-04-15 10:50:54','',''),('21','226',477,'','6.1','3',0.00,8247096.85,'Sales from shift 29 on 2022-04-15 10:50:54 ','2022-04-15 10:50:54','',''),('21','226',478,'','20','4',6596221.05,0.00,'Sales from shift 30 on 2022-04-15 12:03:26 ','2022-04-15 12:03:26','',''),('21','226',479,'','6.1','3',0.00,6596221.05,'Sales from shift 30 on 2022-04-15 12:03:26 ','2022-04-15 12:03:26','',''),('21','226',480,'','20','4',5394969.80,0.00,'Sales from shift 31 on 2022-04-16 18:00:53 ','2022-04-16 18:00:53','',''),('21','226',481,'','6.1','3',0.00,5394969.80,'Sales from shift 31 on 2022-04-16 18:00:53 ','2022-04-16 18:00:53','',''),('21','226',482,'','24','2',0.00,7425000.00,'Purchase Id 40 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-17 14:35:00','',''),('21','226',483,'','supplier','1',7425000.00,0.00,'Purchase Id 40 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-17 14:35:00','',''),('21','226',484,'','24','2',0.00,31500000.00,'Purchase Id 41 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-18 10:09:23','',''),('21','226',485,'','supplier','1',31500000.00,0.00,'Purchase Id 41 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-18 10:09:23','',''),('21','226',486,'','20','4',6771673.70,0.00,'Sales from shift 32 on 2022-04-18 10:16:29 ','2022-04-18 10:16:29','',''),('21','226',487,'','6.1','3',0.00,6771673.70,'Sales from shift 32 on 2022-04-18 10:16:29 ','2022-04-18 10:16:29','',''),('21','226',488,'','24','2',0.00,7425000.00,'Purchase Id 42 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-18 10:17:20','',''),('21','226',489,'','supplier','1',7425000.00,0.00,'Purchase Id 42 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-18 10:17:20','',''),('21','226',490,'','2','6',350700.00,0.00,'Payment Id 254 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 12:11:31','',''),('21','226',491,'','supplier','1',0.00,350700.00,'Payment Id 254 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 12:11:31','',''),('21','226',492,'','2','11',326000.00,0.00,'Payment Id 255 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 12:12:09','',''),('21','226',493,'','supplier','1',0.00,326000.00,'Payment Id 255 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 12:12:09','',''),('21','226',494,'','20','4',6360447.75,0.00,'Sales from shift 33 on 2022-04-18 21:20:04 ','2022-04-18 21:20:04','',''),('21','226',495,'','6.1','3',0.00,6360447.75,'Sales from shift 33 on 2022-04-18 21:20:04 ','2022-04-18 21:20:04','',''),('21','226',496,'','24','2',0.00,7425000.00,'Purchase Id 43 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-19 12:34:27','',''),('21','226',497,'','supplier','1',7425000.00,0.00,'Purchase Id 43 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-19 12:34:27','',''),('21','226',498,'','20','4',8602146.55,0.00,'Sales from shift 34 on 2022-04-19 20:47:34 ','2022-04-19 20:47:34','',''),('21','226',499,'','6.1','3',0.00,8602146.55,'Sales from shift 34 on 2022-04-19 20:47:34 ','2022-04-19 20:47:34','',''),('21','226',500,'','20','4',9872937.60,0.00,'Sales from shift 35 on 2022-04-20 23:12:07 ','2022-04-20 23:12:07','',''),('21','226',501,'','6.1','3',0.00,9872937.60,'Sales from shift 35 on 2022-04-20 23:12:07 ','2022-04-20 23:12:07','',''),('21','226',502,'','24','2',0.00,7425000.00,'Purchase Id 44 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-21 12:30:25','',''),('21','226',503,'','supplier','1',7425000.00,0.00,'Purchase Id 44 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-21 12:30:25','',''),('21','226',504,'','24','2',0.00,7425000.00,'Purchase Id 45 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-22 09:31:55','',''),('21','226',505,'','supplier','1',7425000.00,0.00,'Purchase Id 45 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-22 09:31:55','',''),('21','226',506,'','20','4',10204889.20,0.00,'Sales from shift 36 on 2022-04-22 09:52:58 ','2022-04-22 09:52:58','',''),('21','226',507,'','6.1','3',0.00,10204889.20,'Sales from shift 36 on 2022-04-22 09:52:58 ','2022-04-22 09:52:58','',''),('21','226',508,'','24','2',0.00,7425000.00,'Purchase Id 46 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-22 09:55:31','',''),('21','226',509,'','supplier','1',7425000.00,0.00,'Purchase Id 46 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-22 09:55:31','',''),('21','226',510,'','20','4',933345.00,0.00,'Sales from shift 37 on 2022-04-22 10:12:21 ','2022-04-22 10:12:21','',''),('21','226',511,'','6.1','3',0.00,933345.00,'Sales from shift 37 on 2022-04-22 10:12:21 ','2022-04-22 10:12:21','',''),('21','226',512,'','20','4',8817262.35,0.00,'Sales from shift 38 on 2022-04-22 10:24:03 ','2022-04-22 10:24:03','',''),('21','226',513,'','6.1','3',0.00,8817262.35,'Sales from shift 38 on 2022-04-22 10:24:03 ','2022-04-22 10:24:03','',''),('21','226',514,'','2','10',511497.70,0.00,'Payment Id 297 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-22 16:22:28','',''),('21','226',515,'','supplier','1',0.00,511497.70,'Payment Id 297 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-22 16:22:28','',''),('21','226',516,'','2','11',506782.59,0.00,'Payment Id 263 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-23 11:01:12','',''),('21','226',517,'','supplier','1',0.00,506782.59,'Payment Id 263 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-23 11:01:12','',''),('21','226',518,'','2','10',450983.45,0.00,'Payment Id 261 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-23 11:01:45','',''),('21','226',519,'','supplier','1',0.00,450983.45,'Payment Id 261 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-23 11:01:45','',''),('21','226',520,'','20','4',10198456.30,0.00,'Sales from shift 39 on 2022-04-23 18:39:24 ','2022-04-23 18:39:24','',''),('21','226',521,'','6.1','3',0.00,10198456.30,'Sales from shift 39 on 2022-04-23 18:39:24 ','2022-04-23 18:39:24','',''),('21','226',522,'','24','2',0.00,7425000.00,'Purchase Id 47 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-24 16:45:41','',''),('21','226',523,'','supplier','1',7425000.00,0.00,'Purchase Id 47 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-24 16:45:41','',''),('21','226',524,'','20','4',7733960.40,0.00,'Sales from shift 40 on 2022-04-24 20:03:55 ','2022-04-24 20:03:55','',''),('21','226',525,'','6.1','3',0.00,7733960.40,'Sales from shift 40 on 2022-04-24 20:03:55 ','2022-04-24 20:03:55','',''),('21','226',526,'','20','4',9466688.15,0.00,'Sales from shift 41 on 2022-04-26 09:56:11 ','2022-04-26 09:56:11','',''),('21','226',527,'','6.1','3',0.00,9466688.15,'Sales from shift 41 on 2022-04-26 09:56:11 ','2022-04-26 09:56:11','',''),('21','226',528,'','24','2',0.00,6600000.00,'Purchase Id 48 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-26 10:08:06','',''),('21','226',529,'','supplier','1',6600000.00,0.00,'Purchase Id 48 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-26 10:08:06','',''),('21','226',530,'','2','6',127112.85,0.00,'Payment Id 327 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:56:32','',''),('21','226',531,'','supplier','1',0.00,127112.85,'Payment Id 327 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:56:32','',''),('21','226',532,'','2','11',806119.94,0.00,'Payment Id 328 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:57:09','',''),('21','226',533,'','supplier','1',0.00,806119.94,'Payment Id 328 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:57:09','',''),('21','226',534,'','2','9',4720000.00,0.00,'Payment Id 330 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:57:48','',''),('21','226',535,'','supplier','1',0.00,4720000.00,'Payment Id 330 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:57:48','',''),('21','226',536,'','2','9',1370000.00,0.00,'Payment Id 331 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:58:19','',''),('21','226',537,'','supplier','1',0.00,1370000.00,'Payment Id 331 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:58:19','',''),('21','226',538,'','2','9',2262180.00,0.00,'Payment Id 332 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:58:45','',''),('21','226',539,'','supplier','1',0.00,2262180.00,'Payment Id 332 for invoice:36, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:58:45','',''),('21','226',540,'','2','10',605841.41,0.00,'Payment Id 307 for invoice:34, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:05:26','',''),('21','226',541,'','supplier','1',0.00,605841.41,'Payment Id 307 for invoice:34, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:05:26','',''),('21','226',542,'','2','9',4200000.00,0.00,'Payment Id 311 for invoice:34, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:05:52','',''),('21','226',543,'','supplier','1',0.00,4200000.00,'Payment Id 311 for invoice:34, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:05:52','',''),('21','226',544,'','2','9',1936565.00,0.00,'Payment Id 312 for invoice:34, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:06:22','',''),('21','226',545,'','supplier','1',0.00,1936565.00,'Payment Id 312 for invoice:34, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:06:22','',''),('21','226',546,'','2','9',1818905.00,0.00,'Payment Id 286 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:23:11','',''),('21','226',547,'','supplier','1',0.00,1818905.00,'Payment Id 286 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:23:11','',''),('21','226',548,'','2','10',1387260.60,0.00,'Payment Id 288 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:23:40','',''),('21','226',549,'','supplier','1',0.00,1387260.60,'Payment Id 288 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:23:40','',''),('21','226',550,'','2','9',3250000.00,0.00,'Payment Id 292 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:26:03','',''),('21','226',551,'','supplier','1',0.00,3250000.00,'Payment Id 292 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:26:03','',''),('21','226',552,'','2','9',1651100.00,0.00,'Payment Id 293 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:26:27','',''),('21','226',553,'','supplier','1',0.00,1651100.00,'Payment Id 293 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:26:27','',''),('21','226',554,'','2','9',1432885.00,0.00,'Payment Id 266 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:35:04','',''),('21','226',555,'','supplier','1',0.00,1432885.00,'Payment Id 266 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:35:04','',''),('21','226',556,'','2','9',1148000.00,0.00,'Payment Id 267 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:35:25','',''),('21','226',557,'','supplier','1',0.00,1148000.00,'Payment Id 267 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:35:25','',''),('21','226',558,'','2','10',620475.81,0.00,'Payment Id 274 for invoice:30, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:35:55','',''),('21','226',559,'','supplier','1',0.00,620475.81,'Payment Id 274 for invoice:30, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:35:55','',''),('21','226',560,'','2','12',284906.00,0.00,'Payment Id 246 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:41:37','',''),('21','226',561,'','supplier','1',0.00,284906.00,'Payment Id 246 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:41:37','',''),('21','226',562,'','2','9',3430000.00,0.00,'Payment Id 247 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:42:14','',''),('21','226',563,'','supplier','1',0.00,3430000.00,'Payment Id 247 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:42:14','',''),('21','226',564,'','2','9',145735.00,0.00,'Payment Id 248 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:42:49','',''),('21','226',565,'','supplier','1',0.00,145735.00,'Payment Id 248 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:42:49','',''),('21','226',566,'','2','9',1059810.00,0.00,'Payment Id 249 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:47:26','',''),('21','226',567,'','supplier','1',0.00,1059810.00,'Payment Id 249 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 17:47:26','',''),('21','226',568,'','20','4',3818818.75,0.00,'Sales from shift 42 on 2022-04-27 09:52:02 ','2022-04-27 09:52:02','',''),('21','226',569,'','6.1','3',0.00,3818818.75,'Sales from shift 42 on 2022-04-27 09:52:02 ','2022-04-27 09:52:02','',''),('21','226',570,'','24','2',0.00,7425000.00,'Purchase Id 49 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-27 10:53:37','',''),('21','226',571,'','supplier','1',7425000.00,0.00,'Purchase Id 49 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-27 10:53:37','',''),('21','226',572,'','2','10',145145.00,0.00,'Payment Id 361 for invoice:40, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:39:13','',''),('21','226',573,'','supplier','1',0.00,145145.00,'Payment Id 361 for invoice:40, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:39:13','',''),('21','226',574,'','2','6',910798.31,0.00,'Payment Id 368 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:39:37','',''),('21','226',575,'','supplier','1',0.00,910798.31,'Payment Id 368 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:39:37','',''),('21','226',576,'','2','10',393798.50,0.00,'Payment Id 367 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:40:01','',''),('21','226',577,'','supplier','1',0.00,393798.50,'Payment Id 367 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:40:01','',''),('21','226',578,'','2','6',468175.00,0.00,'Payment Id 363 for invoice:40, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:40:32','',''),('21','226',579,'','supplier','1',0.00,468175.00,'Payment Id 363 for invoice:40, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:40:32','',''),('21','226',580,'','2','9',1575000.00,0.00,'Payment Id 347 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:49:32','',''),('21','226',581,'','supplier','1',0.00,1575000.00,'Payment Id 347 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:49:32','',''),('21','226',582,'','2','9',3026440.00,0.00,'Payment Id 345 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:50:17','',''),('21','226',583,'','supplier','1',0.00,3026440.00,'Payment Id 345 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:50:17','',''),('21','226',584,'','2','9',2670000.00,0.00,'Payment Id 344 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:50:40','',''),('21','226',585,'','supplier','1',0.00,2670000.00,'Payment Id 344 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 17:50:40','',''),('21','226',586,'','2','10',560090.60,0.00,'Payment Id 340 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:31:17','',''),('21','226',587,'','supplier','1',0.00,560090.60,'Payment Id 340 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:31:17','',''),('21','226',588,'','2','6',539417.00,0.00,'Payment Id 341 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:31:45','',''),('21','226',589,'','supplier','1',0.00,539417.00,'Payment Id 341 for invoice:38, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:31:45','',''),('21','226',590,'','2','6',341881.62,0.00,'Payment Id 319 for invoice:35, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:41:24','',''),('21','226',591,'','supplier','1',0.00,341881.62,'Payment Id 319 for invoice:35, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:41:24','',''),('21','226',592,'','2','6',98000.00,0.00,'Payment Id 298 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:47:49','',''),('21','226',593,'','supplier','1',0.00,98000.00,'Payment Id 298 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:47:49','',''),('21','226',594,'','2','9',940620.00,0.00,'Payment Id 302 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:48:24','',''),('21','226',595,'','supplier','1',0.00,940620.00,'Payment Id 302 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:48:24','',''),('21','226',596,'','2','9',2886000.00,0.00,'Payment Id 301 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:48:49','',''),('21','226',597,'','supplier','1',0.00,2886000.00,'Payment Id 301 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 08:48:49','',''),('21','226',598,'','2','10',1096902.79,0.00,'Payment Id 280 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:01:09','',''),('21','226',599,'','supplier','1',0.00,1096902.79,'Payment Id 280 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:01:09','',''),('21','226',600,'','2','6',160712.55,0.00,'Payment Id 282 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:01:43','',''),('21','226',601,'','supplier','1',0.00,160712.55,'Payment Id 282 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:01:43','',''),('21','226',602,'','2','9',1700000.00,0.00,'Payment Id 285 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:02:20','',''),('21','226',603,'','supplier','1',0.00,1700000.00,'Payment Id 285 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:02:20','',''),('21','226',604,'','2','9',2820000.00,0.00,'Payment Id 265 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:14:36','',''),('21','226',605,'','supplier','1',0.00,2820000.00,'Payment Id 265 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:14:36','',''),('21','226',606,'','2','6',221446.00,0.00,'Payment Id 262 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:15:07','',''),('21','226',607,'','supplier','1',0.00,221446.00,'Payment Id 262 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 09:15:07','',''),('21','226',608,'','24','2',0.00,7425000.00,'Purchase Id 50 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-28 14:38:33','',''),('21','226',609,'','supplier','1',7425000.00,0.00,'Purchase Id 50 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-28 14:38:33','',''),('21','226',610,'','20','4',10903497.55,0.00,'Sales from shift 43 on 2022-04-28 14:42:55 ','2022-04-28 14:42:55','',''),('21','226',611,'','6.1','3',0.00,10903497.55,'Sales from shift 43 on 2022-04-28 14:42:55 ','2022-04-28 14:42:55','',''),('21','226',612,'','20','4',10799837.45,0.00,'Sales from shift 44 on 2022-04-28 21:50:07 ','2022-04-28 21:50:07','',''),('21','226',613,'','6.1','3',0.00,10799837.45,'Sales from shift 44 on 2022-04-28 21:50:07 ','2022-04-28 21:50:07','',''),('21','226',614,'','2','9',1588000.00,0.00,'Payment Id 379 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 09:37:49','',''),('21','226',615,'','supplier','1',0.00,1588000.00,'Payment Id 379 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 09:37:49','',''),('21','226',616,'','2','12',988100.00,0.00,'Payment Id 377 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 09:38:19','',''),('21','226',617,'','supplier','1',0.00,988100.00,'Payment Id 377 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 09:38:19','',''),('21','226',618,'','2','11',13244.00,0.00,'Payment Id 376 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 09:38:41','',''),('21','226',619,'','supplier','1',0.00,13244.00,'Payment 