-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_224
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_224`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_224` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_224`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,2500,'',0,'2','21','224','Zenith Bank','','2022-03-03 08:24:32',5,0.00,0.00,'','764','2022-03-03 08:24:32','764',0,0),(2,2501,'',0,'2','21','224','First Bank POS','','2022-03-03 08:24:56',5,0.00,0.00,'','764','2022-03-03 08:24:56','764',0,0),(3,2502,'',0,'2','21','224','GTB POS','','2022-03-03 08:25:13',5,0.00,0.00,'','764','2022-03-03 08:25:13','764',0,0),(4,2503,'',0,'2','21','224','UBA Bank POS','','2022-03-03 08:25:38',5,0.00,0.00,'','764','2022-03-03 08:25:38','764',0,0),(5,2504,'',0,'2','21','224','Sterling Bank POS','','2022-03-03 08:25:59',5,0.00,0.00,'','764','2022-03-03 08:25:59','764',0,0),(6,2505,'',0,'2','21','224','Stanbic Bank POS','','2022-03-03 08:26:13',5,0.00,0.00,'','764','2022-03-03 08:26:13','764',0,0),(7,2506,'',0,'2','21','224','UBA Bank','','2022-03-03 08:26:40',5,0.00,0.00,'','764','2022-03-03 08:26:40','764',0,0),(8,2507,'',0,'2','21','224','GT Bank','','2022-03-03 08:27:11',5,0.00,0.00,'','764','2022-03-03 08:27:11','764',0,0),(9,4000,'',0,'22','21','224','PURCHASES','','2022-03-03 09:28:35',5,0.00,0.00,'','766','2022-03-03 09:28:35','766',0,0),(10,7000,'',0,'20','21','224','SALES','','2022-03-03 09:28:46',5,0.00,0.00,'','766','2022-03-03 09:28:46','766',0,0),(11,8000,'',0,'24','21','224','SALARIES & WAGES','','2022-03-03 09:28:57',5,0.00,0.00,'','766','2022-03-03 09:28:57','766',0,0),(12,8001,'',0,'24','21','224','PURCHASES','','2022-03-03 09:29:08',5,0.00,0.00,'','766','2022-03-03 09:29:08','766',0,0),(13,500,'',0,'6.1','21','224','CASH','','2022-03-03 09:29:22',5,0.00,0.00,'','766','2022-03-03 09:29:22','766',0,0),(14,2508,'',0,'2','21','224','UBA Bank Transfer','','2022-03-03 11:25:01',5,0.00,0.00,'','764','2022-03-03 11:25:01','764',0,0),(15,2509,'',0,'2','21','224','GTB Transfer','','2022-03-03 11:25:38',5,0.00,0.00,'','764','2022-03-03 11:25:38','764',0,0),(16,2510,'',0,'2','21','224','GT BANK POS (20586S85)','','2022-03-04 10:37:08',5,0.00,0.00,'','764','2022-03-04 10:37:08','764',0,0),(17,2511,'',0,'2','21','224','STANBIC BANK POS (2039BA79)','','2022-03-04 10:37:42',5,0.00,0.00,'','764','2022-03-04 10:37:42','764',0,0),(18,2512,'',0,'2','21','224','Ecobank POS','','2022-03-26 17:52:16',5,0.00,0.00,'','764','2022-03-26 17:52:16','764',0,0),(19,2513,'',0,'2','21','224','Ecobank ','','2022-03-26 17:52:24',5,0.00,0.00,'','764','2022-03-26 17:52:24','764',0,0),(20,2514,'',0,'2','21','224','Ecobank Transfer account ','','2022-03-26 17:52:32',5,0.00,0.00,'','764','2022-03-26 17:52:32','764',0,0),(21,2515,'',0,'2','21','224','Unity Bank','','2022-03-26 17:52:40',5,0.00,0.00,'','764','2022-03-26 17:52:40','764',0,0),(22,2516,'',0,'2','21','224','Unity Bank POS','','2022-03-26 17:52:50',5,0.00,0.00,'','764','2022-03-26 17:52:50','764',0,0),(23,2517,'',0,'2','21','224','UNITY Bank Transfer account ','','2022-03-26 17:52:59',5,0.00,0.00,'','764','2022-03-26 17:52:59','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','21','224','FCDA','FDCA','080111111','fdca@gmail.com','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:28:16',5,'764','2022-03-03 08:28:16','764'),(2,'','21','224','ORS Hotel','ORS','08011111111','ors@gmail.com','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:32:20',5,'764','2022-03-03 08:32:20','764'),(3,'','21','224','Ladela School','Ladela','08011111111','ladela@gmail.com','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:33:12',5,'764','2022-03-03 08:33:12','764'),(4,'','21','224','Turkish University','Turkish','08011111111','turkish@gmail.com','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:34:04',5,'764','2022-03-03 08:34:04','764'),(5,'','21','224','Nile University','Nile','08011111111','nile@gmail.com','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:35:07',5,'764','2022-03-03 08:35:07','764'),(6,'','21','224','A A Shafa','A.A','08011111111','aa@gmail.com','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:36:11',5,'764','2022-03-03 08:36:11','764'),(7,'','21','224','Inuwa Waya NNPC','Inwa','08011111111','inwa@gmial.com','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:37:14',5,'764','2022-03-07 14:38:33','764'),(8,'','21','224','Dogara Farms','Dogara','08011111111','dogara@gmail.com','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:38:24',5,'764','2022-03-07 14:39:00','764'),(9,'','21','224','MUHAMMED AKHRAM','MUHAMMED AKHRAM','08011111111','muhammed@gmail.com','Abuja','Abuja','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-04 10:51:26',5,'764','2022-03-04 10:51:26','764'),(10,'','21','224','DOVE LAND','DOVE','08011111111','dove@gmaail.com','Abuja','Abuja','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-04 10:52:35',5,'764','2022-03-04 10:52:35','764'),(11,'','21','224','IPT','IPT','08011111111','ipt@gmail.com','Abuja','Abuja','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-04 10:53:21',5,'764','2022-03-04 10:53:21','764'),(12,'','21','224','DRIVER SHORTAGE','DRIVER','08011111111','info@ayamshafaltd.com','BAUCHI','BAUCHI','B38 Jos Road/ Jolly Nyame Crescent Bauchi Bauchi','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-07 10:40:41',5,'764','2022-03-07 10:40:41','764'),(13,'','21','224','Wisman Environment ','HEAD OFFICE','07034515975','info@ayamshafaltd.com','BAUCHI','BAUCHI','No B38 Jos Road/ Jolly Nyame Crescent Bauchi Bauchi','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 11:36:10',5,'764','2022-07-29 14:58:50','766'),(14,'','21','224','FIRST BANK NIG LTD','FIRST BANK','08011111111','fbn@gmail.com','Abuja','Abuja','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 11:44:23',5,'764','2022-03-08 11:44:23','764'),(15,'','21','224','Doveland High School ','Nil','0000000000','nil@yahoo.com','FCT','Abuja','Nil','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:03:01',5,'766','2022-05-13 13:03:01','766'),(16,'','21','224','Merosa Academy','Nil','000000000','nil@yahoo.com','FCT ','Abuja','Nil','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:03:53',5,'766','2022-05-13 13:03:53','766'),(17,'','21','224','Gratis Bakery ','Nil ','000000000','nil@yahoo.com','FCT','Abuja','Nil ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:04:46',5,'766','2022-05-13 13:04:46','766'),(18,'','21','224','Skyrest accadymy','Nii','000000000000','sadikko07@yahoo.com','FCT ','Abuja ','Nil ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:06:38',5,'766','2022-05-13 13:06:38','766'),(19,'','21','224','Giacoville diaistion contre ',' Nil ','0000000000','sadikko07@yahoo.com','FCT ','Abuja ','Nil ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:11:07',5,'766','2022-05-13 13:11:07','766'),(20,'','21','224','Folton charis','Nii ','000000000000000','sadikko07@yahoo.com','FCT ','Abuja ','Nil ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:13:49',5,'766','2022-05-14 19:31:14','766'),(21,'','21','224','Coan weot africa ltd ','Nil ','00000000','sadikko07@yahoo.com','FCT ','Abuja ','Nil ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:16:08',5,'766','2022-05-13 13:16:08','766'),(22,'','21','224','Eat and go ','Eat and go ','00000000','sadikko07@yahoo.com','FCT ','Abuja ','Nil ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:17:37',5,'766','2022-05-13 13:17:37','766'),(23,'','21','224','Bankys private school ','Nil ','00000000','sadikko07@yahoo.com','FCT ','Abuja ','Nil ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:19:41',5,'766','2022-05-13 13:19:41','766'),(24,'','21','224','Greme ouintessence school Abuj','Nil ','00000000','sadikko07@yahoo.com','FCT ','Abuja ','Nil ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 13:22:20',5,'766','2022-05-13 13:22:20','766'),(25,'','21','224','Madam Dora','Madam Dora','000000000','nil@yahoo.com','FCT','Abuja','Madam Dora','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 14:12:51',5,'766','2022-05-13 14:12:51','766'),(26,'','21','224','YS Worldwide Concern Limited','YS Worldwide Concern Limited','00000000','nil@yahoo.com','FCT','Abuja ','WWC','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-13 14:28:59',5,'766','2022-05-29 22:45:59','766'),(27,'','21','224','Wazobia','Waziri','08036722645','adam@gmail.com','Kano','Kano','Adamma','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-14 12:20:28',5,'764','2022-05-14 12:20:28','764');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','224',1,'4',0.00,500.00,'2022-03-21','','2022-03-23 12:42:56','764','764',2022,'764','2022-03-23 12:42:56',5),('21','224',2,'5',0.00,1900.00,'2022-03-21','','2022-03-23 12:43:25','764','764',2022,'764','2022-03-23 12:43:25',5),('21','224',3,'6',0.00,1300.00,'2022-03-21','','2022-03-23 12:43:52','764','764',2022,'764','2022-03-23 12:43:52',5),('21','224',4,'1',0.00,2300.00,'2022-03-20','','2022-03-24 09:14:12','766','766',2022,'766','2022-03-24 09:14:12',5),('21','224',5,'2',0.00,2500.00,'2022-03-20','','2022-03-24 09:17:48','766','766',2022,'766','2022-03-24 09:17:48',5),('21','224',6,'4',500.00,15300.00,'2022-03-20','','2022-03-24 09:19:53','766','766',2022,'766','2022-03-24 09:19:53',5),('21','224',7,'5',1900.00,27350.00,'2022-03-20','','2022-03-24 09:20:33','766','766',2022,'766','2022-03-24 09:20:33',5),('21','224',8,'5',8852.92,11000.00,'2022-03-23','','2022-04-05 17:06:04','764','764',2022,'764','2022-04-05 17:06:04',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','224','1',1,'5','PMS PUMP 3',2141266.35,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:37:51','764'),('21','224','1',2,'5','PMS PUMP 4',2204421.88,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:38:45','764'),('21','224','1',3,'5','PMS PUMP 15',2190910.90,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:40:33','764'),('21','224','1',4,'5','PMS PUMP 16',979396.10,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:41:36','764'),('21','224','1',5,'5','PMS PUMP 11',1789233.00,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:43:57','764'),('21','224','1',6,'5','PMS PUMP 12',2344929.30,'','',NULL,NULL,'',5,'2022-04-10 15:51:40','764'),('21','224','1',7,'5','PMS PUMP 8',2150384.25,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 17:34:11','764'),('21','224','1',8,'5','PMS PUMP 7',1809493.12,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:54:40','764'),('21','224','2',9,'5','PMS PUMP 1',1992533.68,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:56:17','764'),('21','224','2',10,'5','PMS PUMP 2',2175484.48,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:58:09','764'),('21','224','2',13,'5','PMS PUMP 5',2032160.46,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 15:59:54','764'),('21','224','2',14,'5','PMS PUMP 6',1536454.40,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 16:05:38','764'),('21','224','2',15,'5','PMS PUMP 9',1863040.01,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 16:15:48','764'),('21','224','2',16,'5','PMS PUMP 10',1915493.14,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 16:18:40','764'),('21','224','3',17,'5','PMS PUMP 17',1497341.61,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 16:20:04','764'),('21','224','3',18,'5','PMS PUMP 18',1644954.63,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-04-10 16:21:40','764'),('21','224','6',21,'5','DPK PUMP 1',333292.12,'DPK DISPENSER.','',NULL,NULL,'',5,'2022-03-24 09:42:04','766'),('21','224','6',22,'5','DPK PUMP 2',943316.96,'DPK DISPENSER.','',NULL,NULL,'',5,'2022-03-24 09:42:45','766'),('21','224','3',25,'5','PMS PUMP 19',1350169.01,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-10 16:24:52','764'),('21','224','3',26,'5','PMS PUMP 20',1548158.77,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-10 16:25:54','764'),('21','224','4',29,'5','AGO PUMP 1',1465877.27,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-24 09:44:13','766'),('21','224','4',30,'5','AGO PUMP 2',118919.76,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-24 09:44:40','766'),('21','224','5',31,'5','AGO PUMP 3',842316.72,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-24 09:45:15','766'),('21','224','5',32,'5','AGO PUMP 4',32971.91,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-24 09:47:28','766'),('21','224','6',33,'5','DPK PUMP 3',613.95,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-24 09:47:56','766'),('21','224','6',34,'5','DPK PUMP 4',738796.80,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-24 09:48:21','766'),('21','224','2',35,'5','PMS  PUMP 14',1073539.46,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-10 16:27:57','764'),('21','224','2',36,'5','PMS PUMP 13',2257610.99,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-10 16:28:59','764');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=249 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','224',4,'DAILY','2022-03-21','2022-03-24 10:12:16','2022-03-25 10:12:16','766',11897816.55,11897816.55,'766','2022-03-24 10:20:18','766','2022-03-24 10:36:52',10,0),('21','224',5,'DAILY','2022-03-22','2022-03-24 10:52:06','2022-03-25 10:52:06','766',11222015.15,11222015.15,'766','2022-03-24 11:00:37','766','2022-03-24 11:26:11',10,0),('21','224',6,'DAILY SHIFT','2022-03-25','2022-03-25 16:02:50','2022-03-26 16:02:50','766',11891665.25,11891665.25,'766','2022-03-25 16:21:55','766','2022-03-25 16:52:31',10,0),('21','224',7,'DAILY SHIFT','2022-03-25','2022-03-25 17:09:57','2022-03-26 17:09:57','766',0.00,0.00,'766','2022-03-29 15:26:54','766','2022-03-29 15:29:24',10,0),('21','224',8,'DAILY','2022-03-24','2022-03-29 15:30:21','2022-03-30 15:30:21','766',0.00,0.00,'766','2022-03-30 23:35:38','766','2022-03-30 23:36:39',10,0),('21','224',9,'DAILY SHIFT','2022-03-24','2022-03-30 23:39:06','2022-03-31 23:39:06','766',0.00,0.00,'766','2022-03-31 00:07:20','766','2022-03-31 00:07:37',10,0),('21','224',10,'DAILY','2022-03-25','2022-03-31 00:08:17','2022-04-01 00:08:17','766',0.00,0.00,'764','2022-04-05 17:15:37','764','2022-04-05 17:18:12',10,0),('21','224',11,'DAILY SHIFT','2022-03-24','2022-04-06 15:29:38','2022-04-07 15:29:38','766',0.00,0.00,'766','2022-04-06 16:33:22','766','2022-04-06 16:33:48',10,0),('21','224',12,'Daily shift','2022-03-24','2022-04-06 17:31:49','2022-04-07 17:31:49','766',26499608.00,26499608.00,'766','2022-04-06 17:47:29','766','2022-04-06 18:14:16',10,0),('21','224',13,'DAILY','2022-03-25','2022-04-08 15:12:19','2022-04-09 15:12:19','766',17428833.00,17428833.00,'766','2022-04-08 15:31:01','766','2022-04-08 16:29:02',10,0),('21','224',14,'DAILY','2022-04-04','2022-04-10 14:19:56','2022-04-11 14:19:56','766',0.00,0.00,'764','2022-04-10 15:36:00','764','2022-04-10 15:36:46',10,0),('21','224',15,'Daily shift','2022-04-10','2022-04-10 17:08:13','2022-04-11 17:08:13','766',0.00,0.00,'764','2022-04-10 17:32:31','764','2022-04-10 17:33:00',10,0),('21','224',16,'Daily shift on 26/03/2022','2022-04-10','2022-04-10 18:25:12','2022-04-11 18:25:12','766',14140609.20,14140609.20,'766','2022-04-10 18:44:26','766','2022-04-10 22:46:24',10,0),('21','224',17,'Daily shift on 27/03/2022','2022-04-11','2022-04-11 06:10:13','2022-04-12 06:10:13','766',9952437.00,9952437.00,'766','2022-04-11 07:39:07','766','2022-04-11 07:39:47',10,0),('21','224',18,'Daily Shift on 28/03/2022','2022-04-15','2022-04-15 23:14:44','2022-04-16 23:14:44','766',11999188.00,11999188.00,'766','2022-04-15 23:25:36','766','2022-04-15 23:26:45',10,0),('21','224',19,'Daily Shift on 29/03/2022','2022-04-16','2022-04-16 22:28:17','2022-04-17 22:28:17','766',17900041.05,17900041.05,'766','2022-04-16 22:37:41','766','2022-04-16 22:48:29',10,0),('21','224',20,'Daily Shift on 30/03/2022','2022-04-16','2022-04-16 22:55:55','2022-04-17 22:55:55','766',14114776.70,14114776.70,'766','2022-04-16 23:03:34','766','2022-04-16 23:04:55',10,0),('21','224',21,'Daily Shift on 31/03/2022','2022-04-19','2022-04-19 06:06:52','2022-04-20 06:06:52','766',13748738.50,13748738.50,'766','2022-04-19 06:17:18','766','2022-04-19 06:19:33',10,0),('21','224',22,'Daily Shift on 01/04/2022','2022-04-19','2022-04-19 07:34:02','2022-04-20 07:34:02','766',14072833.00,14072833.00,'766','2022-04-19 07:43:28','766','2022-04-19 07:44:20',10,0),('21','224',23,'DAILY SHIFT ON 02/04/2022','2022-04-19','2022-04-19 14:31:38','2022-04-20 14:31:38','766',10576616.65,10576616.65,'766','2022-04-19 14:46:04','766','2022-04-19 14:50:07',10,0),('21','224',24,'Daily Shift','2022-04-03','2022-05-13 14:03:04','2022-05-14 14:03:04','766',11541401.90,11541401.90,'766','2022-05-13 15:44:53','766','2022-05-13 15:58:50',10,0),('21','224',25,'Daily Shift','2022-04-04','2022-05-13 21:37:42','2022-05-14 21:37:42','766',12205407.95,12205407.95,'766','2022-05-13 21:51:56','766','2022-05-14 00:12:01',10,0),('21','224',26,'Daily Shift ','2022-04-05','2022-05-14 00:13:07','2022-05-15 00:13:07','766',12438193.20,12438193.20,'766','2022-05-14 00:40:54','766','2022-05-14 00:46:17',10,0),('21','224',27,'Daily Shift','2022-04-06','2022-05-14 00:48:36','2022-05-15 00:48:36','766',13078933.75,13078933.75,'766','2022-05-14 00:58:28','766','2022-05-14 01:06:51',10,0),('21','224',28,'Daily Shift ','2022-04-07','2022-05-14 05:42:24','2022-05-15 05:42:24','766',12484854.14,12484854.14,'766','2022-05-14 05:53:32','766','2022-05-14 06:03:14',10,0),('21','224',29,'Daily Shift','2022-04-08','2022-05-14 06:05:39','2022-05-15 06:05:39','766',11593444.35,11593444.35,'766','2022-05-14 06:17:40','766','2022-05-14 06:24:24',10,0),('21','224',30,'Daily','2022-05-14','2022-05-14 12:10:18','2022-05-15 12:10:18','764',15368284.10,15368284.10,'766','2022-05-15 15:30:09','766','2022-05-15 15:55:44',10,0),('21','224',31,'Daily Shift','2022-04-10','2022-05-15 16:13:51','2022-05-16 16:13:51','766',12742965.55,12742965.55,'766','2022-05-15 16:29:35','766','2022-05-15 16:47:54',10,0),('21','224',32,'Daily Shift','2022-04-11','2022-05-15 16:53:21','2022-05-16 16:53:21','766',17093788.25,17093788.25,'766','2022-05-15 17:29:25','766','2022-05-15 17:37:43',10,0),('21','224',33,'Daily Shift','2022-04-12','2022-05-15 18:27:59','2022-05-16 18:27:59','766',17873662.25,17873662.25,'766','2022-05-16 12:04:48','766','2022-05-16 12:14:57',10,0),('21','224',34,'Daily Shift','2022-04-13','2022-05-16 12:28:19','2022-05-17 12:28:19','766',12209210.90,12209210.90,'766','2022-05-16 12:36:40','766','2022-05-16 12:40:33',10,0),('21','224',35,'Daily Shift ','2022-04-14','2022-05-16 12:51:50','2022-05-17 12:51:50','766',16173627.50,16173627.50,'766','2022-05-16 13:03:21','766','2022-05-16 13:08:53',10,0),('21','224',36,'Daily shift','2022-04-15','2022-05-16 13:52:46','2022-05-17 13:52:46','766',13367208.60,13367208.60,'766','2022-05-16 14:05:50','766','2022-05-16 14:12:37',10,0),('21','224',37,'Daily shift','2022-04-16','2022-05-16 14:19:37','2022-05-17 14:19:37','766',11157379.45,11157379.45,'766','2022-05-16 14:30:44','766','2022-05-16 14:42:11',10,0),('21','224',38,'Daily Shift','2022-04-17','2022-05-16 14:44:40','2022-05-17 14:44:40','766',10110354.80,10110354.80,'766','2022-05-16 14:57:46','766','2022-05-16 15:06:43',10,0),('21','224',39,'Daily Shift','2022-04-18','2022-05-16 15:27:23','2022-05-17 15:27:23','766',12069579.20,12069579.20,'766','2022-05-16 15:42:19','766','2022-05-16 15:52:00',10,0),('21','224',40,'Daily Shift ','2022-04-19','2022-05-16 16:26:38','2022-05-17 16:26:38','766',16567699.85,16567699.85,'766','2022-05-16 16:54:26','766','2022-05-16 17:08:10',10,0),('21','224',41,'Daily Shift','2022-04-20','2022-05-16 17:11:45','2022-05-17 17:11:45','766',17179332.48,17179332.48,'766','2022-05-17 11:01:48','766','2022-05-17 11:16:37',10,0),('21','224',42,'Daily Shift ','2022-04-21','2022-05-17 11:48:09','2022-05-18 11:48:09','766',15694584.90,15694584.90,'766','2022-05-17 12:14:01','766','2022-05-17 12:34:09',10,0),('21','224',43,'Daily Shift','2022-04-22','2022-05-17 12:53:30','2022-05-18 12:53:30','766',15751891.05,15751891.05,'766','2022-05-17 17:42:18','766','2022-05-17 17:57:09',10,0),('21','224',44,'Daily Shift','2022-04-23','2022-05-17 18:02:03','2022-05-18 18:02:03','766',15239511.40,15239511.40,'766','2022-05-17 18:35:57','766','2022-05-17 19:19:47',10,0),('21','224',45,'Daily Shift','2022-04-24','2022-05-17 19:27:48','2022-05-18 19:27:48','766',11736073.40,11736073.40,'766','2022-05-17 23:19:34','766','2022-05-17 23:45:18',10,0),('21','224',46,'Daily Shift','2022-04-25','2022-05-17 23:48:13','2022-05-18 23:48:13','766',16993404.05,16993404.05,'766','2022-05-18 23:21:51','766','2022-05-18 23:44:12',10,0),('21','224',47,'Daily Shift','2022-04-26','2022-05-18 23:45:04','2022-05-19 23:45:04','766',9595068.75,9595068.75,'766','2022-05-18 23:56:59','766','2022-05-19 00:11:16',10,0),('21','224',48,'Daily Shift','2022-04-27','2022-05-19 00:13:19','2022-05-20 00:13:19','766',36695416.80,36695416.80,'766','2022-05-19 00:50:19','766','2022-05-19 00:51:00',10,0),('21','224',49,'Daily shift ','2022-04-28','2022-05-19 01:32:15','2022-05-20 01:32:15','766',8104720.60,8104720.60,'766','2022-05-19 01:45:10','766','2022-05-19 02:00:15',10,0),('21','224',50,'Daily shift','2022-04-29','2022-05-19 02:01:06','2022-05-20 02:01:06','766',19425393.10,19425393.10,'766','2022-05-19 02:24:39','766','2022-05-19 02:35:01',10,0),('21','224',51,'Daily shift','2022-04-30','2022-05-21 15:24:32','2022-05-22 15:24:32','766',9997014.65,9997014.65,'766','2022-05-21 15:46:25','766','2022-05-21 16:39:36',10,0),('21','224',52,'Daily shift','2022-05-01','2022-05-21 16:40:28','2022-05-22 16:40:28','766',12626259.50,12626259.50,'766','2022-05-21 16:58:11','766','2022-05-21 17:11:11',10,0),('21','224',53,'Daily Shift','2022-05-02','2022-05-21 17:24:48','2022-05-22 17:24:48','766',11513035.35,11513035.35,'766','2022-05-21 17:33:31','766','2022-05-21 17:43:13',10,0),('21','224',54,'Daily Shift','2022-05-03','2022-05-21 17:44:42','2022-05-22 17:44:42','766',10232823.35,10232823.35,'766','2022-05-21 18:17:35','766','2022-05-21 18:29:59',10,0),('21','224',55,'Daily Shift ','2022-05-04','2022-05-21 18:36:26','2022-05-22 18:36:26','766',13896595.05,13896595.05,'766','2022-05-21 21:05:05','766','2022-05-21 21:16:43',10,0),('21','224',56,'Daily Shift','2022-05-05','2022-05-21 21:29:27','2022-05-22 21:29:27','766',16483453.60,16483453.60,'766','2022-05-21 21:45:00','766','2022-05-21 21:51:47',10,0),('21','224',57,'Daily Shift','2022-05-06','2022-05-22 15:07:18','2022-05-23 15:07:18','766',17228634.30,17228634.30,'766','2022-05-22 15:25:47','766','2022-05-22 15:42:20',10,0),('21','224',58,'Daily Shift','2022-05-07','2022-05-23 14:44:28','2022-05-24 14:44:28','766',17170435.75,17170435.75,'766','2022-05-23 15:11:50','766','2022-05-23 15:37:25',10,0),('21','224',59,'Daily Shift','2022-05-08','2022-05-23 15:48:42','2022-05-24 15:48:42','766',18751835.45,18751835.45,'766','2022-05-23 16:23:40','766','2022-05-23 16:32:30',10,0),('21','224',60,'Daily Shift','2022-05-09','2022-05-23 16:33:03','2022-05-24 16:33:03','766',5275383.50,5275383.50,'766','2022-05-23 16:40:43','766','2022-05-23 16:47:56',10,0),('21','224',61,'Daily Shift ','2022-05-10','2022-05-23 18:50:15','2022-05-24 18:50:15','766',15361587.45,15361587.45,'766','2022-05-25 06:16:20','766','2022-05-25 06:27:11',10,0),('21','224',62,'Daily Shift','2022-05-11','2022-05-25 06:33:26','2022-05-26 06:33:26','766',14847090.20,14847090.20,'766','2022-05-25 06:50:42','766','2022-05-25 07:00:47',10,0),('21','224',63,'Daily Shift','2022-05-12','2022-05-25 07:01:59','2022-05-26 07:01:59','766',19086153.80,19086153.80,'766','2022-05-25 07:19:04','766','2022-05-25 07:31:55',10,0),('21','224',64,'Daily Shift','2022-05-13','2022-05-25 07:32:23','2022-05-26 07:32:23','766',17940398.10,17940398.10,'766','2022-05-25 07:53:50','766','2022-05-25 08:18:58',10,0),('21','224',65,'Daily shift','2022-05-14','2022-05-25 08:25:22','2022-05-26 08:25:22','766',21825292.45,21825292.45,'766','2022-05-25 08:44:00','766','2022-05-25 08:51:42',10,0),('21','224',66,'Daily shift','2022-05-15','2022-05-25 11:11:27','2022-05-26 11:11:27','766',15696186.75,15696186.75,'766','2022-05-25 11:36:49','766','2022-05-25 11:47:49',10,0),('21','224',67,'Daily Shift','2022-05-16','2022-05-25 11:53:02','2022-05-26 11:53:02','766',23214640.25,23214640.25,'766','2022-05-25 12:10:31','766','2022-05-25 12:24:29',10,0),('21','224',68,'Daily Shift','2022-05-17','2022-05-25 12:25:04','2022-05-26 12:25:04','766',19989558.15,19989558.15,'766','2022-05-25 13:01:13','766','2022-05-25 13:42:47',10,0),('21','224',69,'Daily Shift','2022-05-18','2022-05-25 13:46:14','2022-05-26 13:46:14','766',20817511.95,20817511.95,'766','2022-05-25 14:16:47','766','2022-05-25 14:45:40',10,0),('21','224',70,'Daily Shift','2022-05-19','2022-05-25 14:47:01','2022-05-26 14:47:01','766',18230820.89,18230820.89,'766','2022-05-25 15:17:57','766','2022-05-25 15:29:58',10,0),('21','224',71,'Daily shift','2022-05-20','2022-05-25 15:31:53','2022-05-26 15:31:53','766',20538223.60,20538223.60,'766','2022-05-25 16:29:50','766','2022-05-25 16:51:53',10,0),('21','224',72,'Daily shift','2022-05-21','2022-05-25 17:44:00','2022-05-26 17:44:00','766',14962951.49,14962951.49,'766','2022-05-25 18:42:35','766','2022-05-25 20:26:30',10,0),('21','224',73,'Daily shift','2022-05-22','2022-05-25 20:28:35','2022-05-26 20:28:35','766',9750087.45,9750087.45,'766','2022-05-25 20:41:01','766','2022-05-25 20:49:31',10,0),('21','224',74,'Daily shift','2022-05-23','2022-05-25 20:54:26','2022-05-26 20:54:26','766',0.00,0.00,'766','2022-05-25 20:57:04','766','2022-05-25 20:57:29',10,0),('21','224',75,'Daily shift','2022-05-23','2022-05-25 20:58:45','2022-05-26 20:58:45','766',25324111.50,25324111.50,'766','2022-05-26 13:09:23','766','2022-05-26 16:52:57',10,0),('21','224',76,'Daily shift on 24/05/2022','2022-05-26','2022-05-26 16:54:10','2022-05-27 16:54:10','766',18025254.90,18025254.90,'766','2022-05-26 18:07:05','766','2022-05-26 18:08:25',10,0),('21','224',77,'Daily shift on 25/05/2022','2022-05-26','2022-05-26 19:40:20','2022-05-27 19:40:20','766',13051763.45,13051763.45,'766','2022-05-27 15:41:39','766','2022-05-27 15:56:16',10,0),('21','224',78,'Daily shift on 26/05/2022','2022-05-27','2022-05-27 16:39:03','2022-05-28 16:39:03','766',17242316.05,17242316.05,'766','2022-05-27 16:53:34','766','2022-05-27 16:54:39',10,0),('21','224',79,'Daily shift on 27/05/2022','2022-05-28','2022-05-28 17:15:45','2022-05-29 17:15:45','766',14079051.30,14079051.30,'766','2022-05-28 17:29:39','766','2022-05-28 17:30:12',10,0),('21','224',80,'Daily shift on 28/05/2022','2022-05-29','2022-05-29 22:21:39','2022-05-30 22:21:39','766',16341678.45,16341678.45,'766','2022-05-29 22:33:48','766','2022-05-29 22:34:45',10,0),('21','224',81,'Daily shift on 29/05/2022','2022-05-30','2022-05-30 18:19:02','2022-05-31 18:19:02','766',13761734.20,13761734.20,'766','2022-05-30 18:28:57','766','2022-05-30 18:30:02',10,0),('21','224',82,'Daily Shift on 30/05/2022','2022-05-31','2022-06-01 15:30:02','2022-06-02 15:30:02','766',15829385.35,15829385.35,'766','2022-06-01 15:41:44','766','2022-06-01 15:52:22',10,0),('21','224',83,'Daily shift on 31/05/2022','2022-06-01','2022-06-01 17:36:30','2022-06-02 17:36:30','766',16377933.15,16377933.15,'766','2022-06-01 17:48:41','766','2022-06-01 17:49:10',10,0),('21','224',84,'Daily shift on 01/06/2022','2022-06-02','2022-06-02 16:32:23','2022-06-03 16:32:23','766',11264035.80,11264035.80,'766','2022-06-02 16:41:19','766','2022-06-02 16:42:47',10,0),('21','224',85,'Daily shift on 02/06/2022','2022-06-03','2022-06-03 16:07:48','2022-06-04 16:07:48','766',18978702.40,18978702.40,'766','2022-06-03 16:41:40','766','2022-06-03 16:44:12',10,0),('21','224',86,'Daily shift on 03/06/2022','2022-06-06','2022-06-06 07:46:29','2022-06-07 07:46:29','766',19470869.90,19470869.90,'766','2022-06-06 07:59:34','766','2022-06-06 08:00:30',10,0),('21','224',87,'Daily shift on 04/06/2022','2022-06-09','2022-06-09 07:14:11','2022-06-10 07:14:11','766',16483964.10,16483964.10,'766','2022-06-09 07:35:37','766','2022-06-09 07:46:35',10,0),('21','224',88,'Daily shift on 05/06/2022','2022-06-09','2022-06-09 08:01:36','2022-06-10 08:01:36','766',17432744.80,17432744.80,'766','2022-06-09 08:09:28','766','2022-06-09 08:09:59',10,0),('21','224',89,'Daily shift on 06/06/2022','2022-06-09','2022-06-09 08:33:47','2022-06-10 08:33:47','766',16164850.55,16164850.55,'766','2022-06-09 11:48:47','766','2022-06-09 12:00:40',10,0),('21','224',90,'Daily shift on 07/06/2022','2022-06-10','2022-06-10 16:27:20','2022-06-11 16:27:20','766',23246843.55,23246843.55,'766','2022-06-10 16:38:58','766','2022-06-10 16:39:39',10,0),('21','224',91,'Daily shift on 08/06/2022','2022-06-10','2022-06-10 17:11:49','2022-06-11 17:11:49','766',21087112.90,21087112.90,'766','2022-06-10 17:21:32','766','2022-06-10 17:22:15',10,0),('21','224',92,'Daily shift on 09/06/2022','2022-06-10','2022-06-10 17:37:44','2022-06-11 17:37:44','766',20107691.00,20107691.00,'766','2022-06-10 18:07:12','766','2022-06-10 18:07:37',10,0),('21','224',93,'Daily shift on 10/06/2022','2022-06-11','2022-06-11 17:04:53','2022-06-12 17:04:53','766',21899010.45,21899010.45,'766','2022-06-11 17:15:52','766','2022-06-11 17:16:44',10,0),('21','224',94,'Daily shift on 11/06/2022','2022-06-13','2022-06-13 19:52:17','2022-06-14 19:52:17','766',10268567.15,10268567.15,'766','2022-06-13 19:59:29','766','2022-06-13 19:59:50',10,0),('21','224',95,'Daily shift on 12/06/2022','2022-06-13','2022-06-13 20:55:44','2022-06-14 20:55:44','766',12314141.35,12314141.35,'766','2022-06-13 21:04:57','766','2022-06-13 21:05:19',10,0),('21','224',96,'DAILY SHIFT ON 13/06/2022','2022-06-17','2022-06-17 14:25:59','2022-06-18 14:25:59','766',10235711.10,10235711.10,'766','2022-06-17 14:35:10','766','2022-06-17 14:35:30',10,0),('21','224',97,'DAILY SHIFT ON 14/06/2022','2022-06-17','2022-06-17 14:50:25','2022-06-18 14:50:25','766',14150546.45,14150546.45,'766','2022-06-17 15:01:19','766','2022-06-17 15:01:48',10,0),('21','224',98,'DAILY SHIFT ON 15/06/2022','2022-06-17','2022-06-17 15:15:39','2022-06-18 15:15:39','766',13466968.45,13466968.45,'766','2022-06-17 15:27:20','766','2022-06-17 15:27:46',10,0),('21','224',99,'DAILY SHIFT 16/06/2022','2022-06-17','2022-06-17 15:53:22','2022-06-18 15:53:22','766',13966635.90,13966635.90,'766','2022-06-17 16:02:54','766','2022-06-17 16:03:16',10,0),('21','224',100,'Daily shift on 17/06/2022','2022-06-19','2022-06-19 15:16:57','2022-06-20 15:16:57','766',15263414.65,15263414.65,'766','2022-06-19 15:24:18','766','2022-06-19 15:24:42',10,0),('21','224',101,'Daily shift on 18/06/2022','2022-06-19','2022-06-19 15:32:19','2022-06-20 15:32:19','766',20848659.65,20848659.65,'766','2022-06-19 15:40:52','766','2022-06-19 15:41:22',10,0),('21','224',102,'Daily shift on 19/06/2022','2022-06-21','2022-06-21 15:18:43','2022-06-22 15:18:43','766',10913288.55,10913288.55,'766','2022-06-21 15:28:10','766','2022-06-21 15:28:32',10,0),('21','224',103,'Daily shift on 20/06/2022','2022-06-21','2022-06-21 15:50:29','2022-06-22 15:50:29','766',15131662.00,15131662.00,'766','2022-06-21 17:53:09','766','2022-06-21 17:56:15',10,0),('21','224',104,'Daily shift on 21/06/2022','2022-06-23','2022-06-23 16:45:27','2022-06-24 16:45:27','766',12113738.55,12113738.55,'766','2022-06-23 17:08:08','766','2022-06-23 17:08:52',10,0),('21','224',105,'Daily shift on 22/06/2022','2022-06-23','2022-06-23 17:33:03','2022-06-24 17:33:03','766',11066149.75,11066149.75,'766','2022-06-23 17:51:57','766','2022-06-23 17:52:40',10,0),('21','224',106,'Daily shift on 23/06/2022','2022-06-25','2022-06-25 06:39:29','2022-06-26 06:39:29','766',11364571.15,11364571.15,'766','2022-06-25 06:49:00','766','2022-06-25 06:49:52',10,0),('21','224',107,'Daily shift on 24/06/2022','2022-07-01','2022-07-01 16:35:28','2022-07-02 16:35:28','766',25087416.40,25087416.40,'766','2022-07-01 16:44:33','766','2022-07-01 16:44:57',10,0),('21','224',108,'Daily shift on 25/06/2022','2022-07-01','2022-07-01 16:45:34','2022-07-02 16:45:34','766',11208539.60,11208539.60,'766','2022-07-01 18:24:06','766','2022-07-01 18:24:26',10,0),('21','224',109,'Daily shift on 26/06/2022','2022-07-01','2022-07-01 18:28:24','2022-07-02 18:28:24','766',13597967.10,13597967.10,'766','2022-07-01 18:34:50','766','2022-07-01 18:35:12',10,0),('21','224',110,'Daily shift on 27/06/2022','2022-07-01','2022-07-01 18:41:47','2022-07-02 18:41:47','766',14037607.60,14037607.60,'766','2022-07-01 21:25:49','766','2022-07-01 21:26:15',10,0),('21','224',111,'Daily shift on 28/06/2022','2022-07-01','2022-07-01 21:26:52','2022-07-02 21:26:52','766',12171654.90,12171654.90,'766','2022-07-01 21:33:37','766','2022-07-01 21:34:06',10,0),('21','224',112,'Daily shift on 29/06/2022','2022-07-01','2022-07-01 21:42:38','2022-07-02 21:42:38','766',12288522.45,12288522.45,'766','2022-07-01 21:57:44','766','2022-07-01 21:58:56',10,0),('21','224',113,'Daily shift on 30/07/2022','2022-07-03','2022-07-03 23:32:47','2022-07-04 23:32:47','766',17598093.30,17598093.30,'766','2022-07-03 23:47:10','766','2022-07-04 00:00:05',10,0),('21','224',114,'DAily  on 01/07/2022','2022-07-01','2022-07-04 14:59:05','2022-07-05 14:59:05','766',15823119.70,15823119.70,'766','2022-07-04 15:27:55','766','2022-07-04 15:46:25',10,0),('21','224',115,'Daily  on 02/07/2022','2022-07-02','2022-07-04 22:59:18','2022-07-05 22:59:18','766',16139850.35,16139850.35,'766','2022-07-04 23:35:24','766','2022-07-04 23:45:56',10,0),('21','224',116,'Daily Shift on 03/07/2022','2022-07-03','2022-07-18 16:59:41','2022-07-19 16:59:41','766',7871626.30,7871626.30,'766','2022-07-18 17:15:21','766','2022-07-18 17:29:56',10,0),('21','224',117,'Daily shift on 04/07/2022','2022-07-04','2022-07-18 17:49:13','2022-07-19 17:49:13','766',12530170.10,12530170.10,'766','2022-07-18 18:41:33','766','2022-07-18 19:30:09',10,0),('21','224',118,'Daily shift on 5/7/2022','2022-07-18','2022-07-18 20:06:25','2022-07-19 20:06:25','766',10098451.75,10098451.75,'766','2022-07-18 20:49:23','766','2022-07-19 09:25:47',10,0),('21','224',119,'Daily shift on 6/7/2022','2022-07-19','2022-07-19 09:31:33','2022-07-20 09:31:33','766',10421287.45,10421287.45,'766','2022-07-19 09:47:35','766','2022-07-19 12:36:54',10,0),('21','224',120,'Daily shift on 7/7/2022','2022-07-19','2022-07-19 13:24:08','2022-07-20 13:24:08','766',8930210.10,8024400.90,'766','2022-07-19 17:03:54','766','2022-07-19 17:10:49',10,0),('21','224',121,'Daily shift on 8/7/2022','2022-07-19','2022-07-19 17:12:51','2022-07-20 17:12:51','766',14742096.80,13840043.60,'766','2022-07-19 17:27:40','766','2022-07-19 17:53:46',10,0),('21','224',122,'Daily shift on 9/7/2022','2022-07-19','2022-07-19 18:09:34','2022-07-20 18:09:34','766',13158465.05,12154630.05,'766','2022-07-19 19:57:36','766','2022-07-19 20:01:15',10,0),('21','224',123,'Daily shift on 10/7/2022','2022-07-19','2022-07-19 20:03:56','2022-07-20 20:03:56','766',1275591.60,1275591.60,'766','2022-07-19 20:29:27','766','2022-07-20 09:41:17',10,0),('21','224',124,'Daily shift on 11/7/2022','2022-07-20','2022-07-20 10:17:40','2022-07-21 10:17:40','766',0.00,0.00,'766','2022-07-20 11:08:18','766','2022-07-20 11:08:41',10,0),('21','224',125,'Daily Shift on 11/07/2022','2022-07-11','2022-07-20 11:10:45','2022-07-21 11:10:45','766',0.00,0.00,'766','2022-07-20 11:49:54','766','2022-07-20 12:09:18',10,0),('21','224',126,'Daily shift on 12/7/2022','2022-07-20','2022-07-20 12:10:49','2022-07-21 12:10:49','766',0.00,0.00,'766','2022-07-20 12:20:19','766','2022-07-20 12:20:44',10,0),('21','224',127,'Daily shift on 12/7/2022','2022-07-20','2022-07-20 12:25:53','2022-07-21 12:25:53','766',0.00,0.00,'766','2022-07-21 09:19:33','766','2022-07-21 09:19:57',10,0),('21','224',128,'Daily shift on 11/7/2022','2022-07-21','2022-07-21 09:28:19','2022-07-22 09:28:19','766',17754338.60,17754338.60,'766','2022-07-21 09:45:46','766','2022-07-21 09:58:53',10,0),('21','224',129,'Daily shift on 12/7/2022','2022-07-21','2022-07-21 10:06:52','2022-07-22 10:06:52','766',16655296.30,16655296.30,'766','2022-07-21 11:34:09','766','2022-07-21 11:50:19',10,0),('21','224',130,'Daily shift on 13/7/2022','2022-07-21','2022-07-21 11:52:53','2022-07-22 11:52:53','766',15134608.25,15134608.25,'766','2022-07-21 12:43:33','766','2022-07-21 13:54:43',10,0),('21','224',131,'Daily shift on 14/7/2022','2022-07-21','2022-07-21 13:58:08','2022-07-22 13:58:08','766',16314079.85,16314079.85,'766','2022-07-21 14:24:22','766','2022-07-21 14:52:07',10,0),('21','224',132,'Daily shift on 15/20/2022','2022-07-21','2022-07-21 15:06:32','2022-07-22 15:06:32','766',15820978.60,15820978.60,'766','2022-07-21 16:52:02','766','2022-07-21 22:22:22',10,0),('21','224',133,'Daily shift on 16/7/2022','2022-07-22','2022-07-22 10:04:33','2022-07-23 10:04:33','766',12288054.75,12288054.75,'764','2022-07-22 14:14:03','766','2022-07-22 15:25:19',10,0),('21','224',134,'Daily shift on 17/7/2022','2022-07-22','2022-07-22 15:27:12','2022-07-23 15:27:12','766',8635852.35,8256788.65,'766','2022-07-22 15:51:42','766','2022-07-22 17:38:50',10,0),('21','224',135,'Daily shift on 18/7/2022','2022-07-22','2022-07-22 17:40:12','2022-07-23 17:40:12','766',13867070.60,13506044.40,'766','2022-07-22 18:27:14','766','2022-07-22 18:38:55',10,0),('21','224',136,'Daily shift on 19/7/2022','2022-07-22','2022-07-22 19:39:58','2022-07-23 19:39:58','766',27837338.60,27479697.40,'766','2022-07-23 00:53:51','766','2022-07-23 11:16:49',10,0),('21','224',137,'Daily shift on 20/7/2022','2022-07-23','2022-07-23 11:17:52','2022-07-24 11:17:52','766',12989740.55,13492430.05,'766','2022-07-23 11:58:15','766','2022-07-23 12:13:51',10,0),('21','224',138,'Daily shift on 21/7/2022','2022-07-23','2022-07-23 13:46:41','2022-07-24 13:46:41','766',6656174.95,6347122.25,'766','2022-07-23 14:05:32','766','2022-07-23 14:19:03',10,0),('21','224',139,'Daily shift on 22/7/2022','2022-07-23','2022-07-23 14:23:43','2022-07-24 14:23:43','766',12738771.95,12253816.05,'766','2022-07-23 15:17:58','766','2022-07-23 15:54:14',10,0),('21','224',140,'Daily shift on 23/7/2022','2022-07-24','2022-07-24 16:59:59','2022-07-25 16:59:59','766',13647422.70,14261691.90,'766','2022-07-25 18:41:38','766','2022-07-25 18:42:29',10,0),('21','224',141,'Daily shift on 24/7/2022','2022-07-25','2022-07-25 18:47:18','2022-07-26 18:47:18','766',8176953.45,7807993.95,'766','2022-07-25 19:20:52','766','2022-07-25 19:32:07',10,0),('21','224',142,'Daily shift on 25/72022','2022-07-26','2022-07-26 12:03:07','2022-07-27 12:03:07','766',11282072.65,10811241.25,'766','2022-07-26 12:21:03','766','2022-07-26 13:35:15',10,0),('21','224',143,'Daily shift on 26/7/2022','2022-07-27','2022-07-27 13:19:08','2022-07-28 13:19:08','766',0.00,0.00,'766','2022-07-27 13:22:45','766','2022-07-27 13:23:05',10,0),('21','224',144,'Daily shift on 26/7/2022','2022-07-27','2022-07-27 13:25:23','2022-07-28 13:25:23','766',14782476.55,14142940.25,'766','2022-07-27 14:36:28','766','2022-07-28 14:45:56',10,0),('21','224',145,'Daily shift on 27/7/2022','2022-07-28','2022-07-28 14:46:57','2022-07-29 14:46:57','766',10342483.10,10342483.10,'766','2022-07-28 15:15:43','766','2022-07-28 17:44:55',10,0),('21','224',146,'Daily shift on 28/7/2022','2022-07-29','2022-07-29 15:27:54','2022-07-30 15:27:54','766',10785763.40,10778277.85,'766','2022-07-29 16:07:21','766','2022-07-29 16:33:12',10,0),('21','224',147,'Daily shift on 29/7/2022','2022-07-30','2022-07-30 13:37:56','2022-07-31 13:37:56','766',8963872.80,8948740.70,'766','2022-07-30 13:57:14','766','2022-07-30 14:15:43',10,0),('21','224',148,'Daily shift on 30/7/2022','2022-07-31','2022-07-31 16:13:26','2022-08-01 16:13:26','766',10038436.10,10018989.15,'766','2022-07-31 16:31:52','766','2022-07-31 17:06:08',10,0),('21','224',149,'Daily shift on 31/07/2022','2022-08-03','2022-08-03 19:32:07','2022-08-04 19:32:07','766',9571428.95,9565640.60,'766','2022-08-03 19:50:16','766','2022-08-03 19:50:46',10,0),('21','224',150,'Daily shift on 01/08/2022','2022-08-03','2022-08-03 19:58:19','2022-08-04 19:58:19','766',11339111.60,11323137.90,'766','2022-08-03 20:08:33','766','2022-08-03 20:08:54',10,0),('21','224',151,'Daily shift on 02/08/2022','2022-08-04','2022-08-04 18:26:10','2022-08-05 18:26:10','766',10534224.80,10521593.55,'766','2022-08-04 18:40:58','766','2022-08-04 18:41:42',10,0),('21','224',152,'Daily shift on 03/08/2022','2022-08-04','2022-08-04 19:19:52','2022-08-05 19:19:52','766',10127716.30,10120303.60,'766','2022-08-04 19:32:10','766','2022-08-04 19:32:50',10,0),('21','224',153,'Daily shift on 04/08/2022','2022-08-05','2022-08-05 17:54:49','2022-08-06 17:54:49','766',9864592.30,9855102.00,'766','2022-08-05 18:02:39','766','2022-08-05 18:03:06',10,0),('21','224',154,'Daily shift on 05/08/2022','2022-08-06','2022-08-06 16:28:31','2022-08-07 16:28:31','766',11700287.40,11680769.20,'766','2022-08-06 16:39:28','766','2022-08-06 16:39:52',10,0),('21','224',155,'Daily shift on 6/8/2022','2022-08-07','2022-08-07 13:38:50','2022-08-08 13:38:50','766',13553534.45,13525806.70,'766','2022-08-07 13:57:32','766','2022-08-07 14:21:07',10,0),('21','224',156,'Daily shift on 7/8/2022','2022-08-08','2022-08-08 13:29:23','2022-08-09 13:29:23','766',8718315.55,8717523.40,'766','2022-08-08 14:00:43','766','2022-08-08 14:14:05',10,0),('21','224',157,'Daily shift on 8 /8/2022','2022-08-09','2022-08-09 17:47:54','2022-08-10 17:47:54','766',203422.70,203372.60,'766','2022-08-09 18:00:47','766','2022-08-09 18:06:01',10,0),('21','224',158,'Daily shift on 9/8/2022','2022-08-10','2022-08-10 12:03:17','2022-08-11 12:03:17','766',9232877.25,9232877.25,'766','2022-08-10 12:35:44','766','2022-08-10 13:08:32',10,0),('21','224',159,'Daily shift on 10/8/2022','2022-08-11','2022-08-11 14:27:00','2022-08-12 14:27:00','766',8424553.45,8424553.45,'766','2022-08-11 14:56:32','766','2022-08-11 15:09:22',10,0),('21','224',160,'Daily shift on 11/8/2022','2022-08-12','2022-08-12 14:15:17','2022-08-13 14:15:17','766',12273306.35,12250486.40,'766','2022-08-12 14:35:40','766','2022-08-12 14:58:50',10,0),('21','224',161,'Daily shift on12/8/2022','2022-08-13','2022-08-13 13:35:34','2022-08-14 13:35:34','766',10202618.45,10192345.20,'766','2022-08-13 14:03:29','766','2022-08-13 14:23:26',10,0),('21','224',162,'Daily shift on 13/7/2022','2022-08-14','2022-08-14 19:35:59','2022-08-15 19:35:59','766',10318128.35,10299841.85,'766','2022-08-14 20:26:09','766','2022-08-14 20:48:38',10,0),('21','224',163,'Daily shift on 18/8/2022','2022-08-15','2022-08-15 12:47:23','2022-08-16 12:47:23','766',11125896.50,11120379.35,'766','2022-08-15 13:03:16','766','2022-08-15 13:28:10',10,0),('21','224',164,'Daily shift on 15/8/2022','2022-08-16','2022-08-16 15:35:03','2022-08-17 15:35:03','766',8782319.60,8775391.20,'766','2022-08-16 15:48:20','766','2022-08-16 16:47:43',10,0),('21','224',165,'Daily shift on 16/8/2022','2022-08-17','2022-08-17 11:30:17','2022-08-18 11:30:17','766',10754406.05,10740515.20,'766','2022-08-17 11:45:42','766','2022-08-17 12:07:21',10,0),('21','224',166,'Daily shift on 17/8/2022','2022-08-18','2022-08-18 11:53:02','2022-08-19 11:53:02','766',14879736.30,14839756.95,'766','2022-08-18 12:12:28','766','2022-08-18 15:11:30',10,0),('21','224',167,'Daily shift on 18/8/2022','2022-08-19','2022-08-19 14:31:41','2022-08-20 14:31:41','766',0.00,0.00,'766','2022-08-19 14:34:35','766','2022-08-19 14:34:58',10,0),('21','224',168,'Daily shift on18/8/2022','2022-08-19','2022-08-19 14:40:45','2022-08-20 14:40:45','766',19214782.75,19214782.75,'766','2022-08-19 15:12:19','766','2022-08-19 15:29:02',10,0),('21','224',169,'Daily shift on 19/8/2022','2022-08-20','2022-08-20 13:32:57','2022-08-21 13:32:57','766',23605520.10,23605520.10,'766','2022-08-20 20:13:30','766','2022-08-20 20:35:32',10,0),('21','224',170,'Daily shift on 20/8/2022','2022-08-21','2022-08-21 10:14:57','2022-08-22 10:14:57','766',16594273.15,16594273.15,'766','2022-08-21 10:36:45','766','2022-08-21 10:49:58',10,0),('21','224',171,'Daily shift on 21/8/2022','2022-08-22','2022-08-22 10:59:21','2022-08-23 10:59:21','766',10355998.70,10355998.70,'766','2022-08-22 11:10:07','766','2022-08-22 11:26:53',10,0),('21','224',172,'Daily shift on 22/8/2022','2022-08-23','2022-08-23 11:37:56','2022-08-24 11:37:56','766',11164270.65,11164270.65,'766','2022-08-23 13:53:54','766','2022-08-23 14:05:58',10,0),('21','224',173,'Daily shift on 23/8/2022','2022-08-24','2022-08-24 15:01:24','2022-08-25 15:01:24','766',10948167.35,10948167.35,'766','2022-08-24 15:26:10','766','2022-08-24 15:44:58',10,0),('21','224',174,'Daily shift on 24/8/2022','2022-08-25','2022-08-25 15:40:08','2022-08-26 15:40:08','766',11287650.60,11287650.60,'766','2022-08-25 16:07:44','766','2022-08-25 16:27:56',10,0),('21','224',175,'Daily shift on 25/8/2022','2022-08-26','2022-08-26 14:58:30','2022-08-27 14:58:30','766',10485449.65,10485449.65,'766','2022-08-26 15:14:59','766','2022-08-26 15:27:04',10,0),('21','224',176,'Daily shift on 26/8/2022','2022-08-27','2022-08-27 14:13:25','2022-08-28 14:13:25','766',17743806.55,17743806.55,'766','2022-08-27 14:30:28','766','2022-08-27 14:41:13',10,0),('21','224',177,'Daily shift on 27/8/2022','2022-08-28','2022-08-28 17:22:53','2022-08-29 17:22:53','766',10811029.10,10811029.10,'766','2022-08-28 17:49:06','766','2022-08-28 17:59:50',10,0),('21','224',178,'Daily shift on 28/8/2022','2022-08-29','2022-08-29 16:56:11','2022-08-30 16:56:11','766',9739230.90,9739230.90,'766','2022-08-29 17:15:09','766','2022-08-29 17:21:18',10,0),('21','224',179,'Daily shift on 29/8/2022','2022-08-30','2022-08-30 11:22:20','2022-08-31 11:22:20','766',11335167.55,11335167.55,'766','2022-08-30 11:33:31','766','2022-08-30 11:40:16',10,0),('21','224',180,'Daily shift on 30/8/2022','2022-08-31','2022-08-31 11:45:01','2022-09-01 11:45:01','766',9548723.85,9548723.85,'766','2022-08-31 11:57:55','766','2022-08-31 12:06:54',10,0),('21','224',181,'Daily shift on 31/08/2022','2022-09-02','2022-09-02 20:18:04','2022-09-03 20:18:04','766',10596956.70,10596956.70,'766','2022-09-02 20:27:58','766','2022-09-02 20:28:22',10,0),('21','224',182,'Daily shift on 01/09/2022','2022-09-03','2022-09-03 19:49:41','2022-09-04 19:49:41','766',9925516.60,9925516.60,'766','2022-09-03 19:57:16','766','2022-09-03 19:57:59',10,0),('21','224',183,'Daily shift on 2/9/2022','2022-09-04','2022-09-04 06:48:27','2022-09-05 06:48:27','766',11318549.35,11318549.35,'766','2022-09-04 14:57:02','766','2022-09-04 14:57:29',10,0),('21','224',184,'Daily shift on 3/9/2022','2022-09-04','2022-09-04 17:04:08','2022-09-05 17:04:08','766',11359547.95,11359547.95,'766','2022-09-04 17:22:45','766','2022-09-04 17:33:11',10,0),('21','224',185,'DAILY SHIFT ON 04/9/2022','2022-09-05','2022-09-05 16:30:15','2022-09-06 16:30:15','766',9344339.80,9344339.80,'766','2022-09-05 17:15:38','766','2022-09-05 17:43:04',10,0),('21','224',186,'Daily shift on 5/9/2022','2022-09-06','2022-09-06 15:09:15','2022-09-07 15:09:15','766',10316199.50,10316199.50,'766','2022-09-06 16:35:57','766','2022-09-06 16:46:49',10,0),('21','224',187,'DAIY SHIFT ON 6/9/2022','2022-09-07','2022-09-07 14:10:17','2022-09-08 14:10:17','766',2558859.00,2558859.00,'766','2022-09-07 14:20:43','766','2022-09-07 16:30:52',10,0),('21','224',188,'Daily shift on 7/9/2022','2022-09-08','2022-09-08 10:46:12','2022-09-09 10:46:12','766',11079111.75,11079111.75,'766','2022-09-08 11:14:19','766','2022-09-08 11:31:36',10,0),('21','224',189,'Daily shift on 8/9/2022','2022-09-09','2022-09-09 12:23:25','2022-09-10 12:23:25','766',13130912.20,13130912.20,'766','2022-09-09 12:40:49','766','2022-09-09 12:52:19',10,0),('21','224',190,'Daily shift on 9/9/2022','2022-09-10','2022-09-10 14:16:59','2022-09-11 14:16:59','766',14704096.20,14704096.20,'766','2022-09-10 14:45:26','766','2022-09-10 15:09:27',10,0),('21','224',191,'Daily shift On 10/9/2022','2022-09-11','2022-09-11 13:51:16','2022-09-12 13:51:16','766',13342362.35,13342362.35,'766','2022-09-11 14:14:01','766','2022-09-11 14:26:08',10,0),('21','224',192,'Daily shift on 11/9/2022','2022-09-12','2022-09-12 11:54:08','2022-09-13 11:54:08','766',9767441.25,9767441.25,'766','2022-09-12 12:12:43','766','2022-09-12 12:18:39',10,0),('21','224',193,'Daily shift on 12/9/2022','2022-09-13','2022-09-13 13:21:13','2022-09-14 13:21:13','766',3247719.80,3247719.80,'766','2022-09-13 13:34:43','766','2022-09-13 13:42:04',10,0),('21','224',194,'Daily shift on 13/9/2022','2022-09-14','2022-09-14 11:38:11','2022-09-15 11:38:11','766',11916346.40,11916346.40,'766','2022-09-14 13:58:40','766','2022-09-14 14:07:44',10,0),('21','224',195,'Daily shift on 14/9/2022','2022-09-15','2022-09-15 16:22:28','2022-09-16 16:22:28','766',13654092.00,13654092.00,'766','2022-09-15 17:01:43','766','2022-09-15 17:15:04',10,0),('21','224',196,'Daily shift on 15/9/2022','2022-09-16','2022-09-16 11:02:44','2022-09-17 11:02:44','766',13277381.10,13277381.10,'766','2022-09-16 14:57:30','766','2022-09-16 15:09:51',10,0),('21','224',197,'Daily shift on 16/9/2022','2022-09-17','2022-09-17 11:32:46','2022-09-18 11:32:46','766',12590353.45,12590353.45,'766','2022-09-17 11:52:20','766','2022-09-17 12:00:47',10,0),('21','224',198,'Daily shift on17/09/2022','2022-09-18','2022-09-18 15:33:35','2022-09-19 15:33:35','766',9731668.80,9731668.80,'766','2022-09-18 15:45:55','766','2022-09-18 15:53:29',10,0),('21','224',199,'Daily shift on 18/9/2022','2022-09-19','2022-09-19 16:52:39','2022-09-20 16:52:39','766',9878825.55,9878825.55,'766','2022-09-19 17:11:15','766','2022-09-19 17:21:26',10,0),('21','224',200,'Daily shift on 19/9/2022','2022-09-20','2022-09-20 17:29:25','2022-09-21 17:29:25','766',6465932.65,6465932.65,'766','2022-09-20 17:46:54','766','2022-09-20 17:58:51',10,0),('21','224',201,'Daily shift on 20/9/2022','2022-09-21','2022-09-21 17:16:20','2022-09-22 17:16:20','766',12679477.75,12679477.75,'766','2022-09-21 17:35:21','766','2022-09-21 17:49:43',10,0),('21','224',202,'Daily shift on 21/9/2022','2022-09-22','2022-09-22 14:47:38','2022-09-23 14:47:38','766',12003667.60,12003667.60,'766','2022-09-22 15:12:45','766','2022-09-22 15:21:11',10,0),('21','224',203,'Daily shift on 22/9/2022','2022-09-23','2022-09-23 11:29:40','2022-09-24 11:29:40','766',14032398.55,14032398.55,'766','2022-09-23 11:52:51','766','2022-09-23 12:06:21',10,0),('21','224',204,'Daily shift on 23/09/2022','2022-09-24','2022-09-24 15:59:12','2022-09-25 15:59:12','766',11861104.85,11861104.85,'766','2022-09-24 16:55:39','766','2022-09-24 17:05:17',10,0),('21','224',205,'Daily shift on 24/9/2022','2022-09-25','2022-09-25 14:24:36','2022-09-26 14:24:36','766',8412663.15,8412663.15,'766','2022-09-25 14:44:04','766','2022-09-25 14:54:40',10,0),('21','224',206,'Daily shift on 25/9/2022','2022-09-26','2022-09-26 11:47:29','2022-09-27 11:47:29','766',9606717.10,9606717.10,'766','2022-09-26 11:59:25','766','2022-09-26 12:06:57',10,0),('21','224',207,'Daily shift on 26/9/2022','2022-09-27','2022-09-27 11:08:43','2022-09-28 11:08:43','766',9220916.45,9220916.45,'766','2022-09-27 11:29:16','766','2022-09-27 11:39:59',10,0),('21','224',208,'Daily shift on 27/09/2022','2022-09-28','2022-09-28 12:53:33','2022-09-29 12:53:33','766',16564418.10,16564418.10,'766','2022-09-28 13:49:40','766','2022-09-28 13:59:40',10,0),('21','224',209,'Daily shift on 28/09/2022','2022-09-29','2022-09-29 15:07:13','2022-09-30 15:07:13','766',23345120.00,23345120.00,'766','2022-09-29 15:37:01','766','2022-09-29 15:45:41',10,0),('21','224',210,'Daily shift on 29/09/2022','2022-10-09','2022-10-09 14:30:30','2022-10-10 14:30:30','766',20791503.05,20791503.05,'766','2022-10-09 14:50:04','766','2022-10-09 14:50:44',10,0),('21','224',211,'Daily shift on 30/09/2022','2022-10-09','2022-10-09 15:12:17','2022-10-10 15:12:17','766',7720185.95,7720185.95,'766','2022-10-09 15:21:06','766','2022-10-09 15:21:29',10,0),('21','224',212,'Daily shift on 01/10/2022','2022-10-09','2022-10-09 15:33:53','2022-10-10 15:33:53','766',5887068.50,5887068.50,'766','2022-10-09 15:42:01','766','2022-10-09 15:42:40',10,0),('21','224',213,'Daily shift on 02/10/2022','2022-10-11','2022-10-11 16:49:58','2022-10-12 16:49:58','766',14504407.75,14504407.75,'766','2022-10-11 17:01:08','766','2022-10-11 17:02:03',10,0),('21','224',214,'Daily shift on 03/10/2022','2022-10-11','2022-10-11 17:31:18','2022-10-12 17:31:18','766',14883215.75,14883215.75,'766','2022-10-11 18:14:23','766','2022-10-11 18:17:03',10,0),('21','224',215,'Daily shift on 04/10/2022','2022-10-11','2022-10-11 19:34:51','2022-10-12 19:34:51','766',5875318.75,5875318.75,'766','2022-10-11 19:47:25','766','2022-10-11 19:51:09',10,0),('21','224',216,'Daily shift on 05/10/2022','2022-10-12','2022-10-12 14:10:26','2022-10-13 14:10:26','766',9239108.55,9239108.55,'766','2022-10-12 14:19:15','766','2022-10-12 14:19:45',10,0),('21','224',217,'Daily shift on 06/10/2022','2022-10-12','2022-10-12 14:29:17','2022-10-13 14:29:17','766',10590556.30,10590556.30,'766','2022-10-12 15:08:48','766','2022-10-12 15:09:19',10,0),('21','224',218,'Daily shift on 07/10/2022','2022-10-12','2022-10-12 15:20:25','2022-10-13 15:20:25','766',4808191.00,4808191.00,'766','2022-10-12 15:22:47','766','2022-10-12 15:23:08',10,0),('21','224',219,'Daily shift of 8/10/2022','2022-10-08','2022-10-12 16:41:52','2022-10-13 16:41:52','766',0.00,0.00,'766','2022-10-14 17:07:00','766','2022-10-14 17:08:02',10,0),('21','224',220,'Daily shift on 08/10/2022','2022-10-14','2022-10-14 17:09:02','2022-10-15 17:09:02','766',12073417.80,12073417.80,'766','2022-10-14 17:38:01','766','2022-10-14 18:56:00',10,0),('21','224',221,'Daily shift on 09/10/2022','2022-10-09','2022-10-14 19:40:03','2022-10-15 19:40:03','766',9908437.30,9908437.30,'766','2022-10-14 20:14:53','766','2022-10-14 20:16:38',10,0),('21','224',222,'Daily shift on 9/10/2022','2022-10-09','2022-10-15 17:38:53','2022-10-16 17:38:53','766',0.00,0.00,'766','2022-10-15 17:54:46','766','2022-10-15 17:55:47',10,0),('21','224',223,'Daily shift on 10/10/2022','2022-10-10','2022-10-15 17:57:08','2022-10-16 17:57:08','766',0.00,0.00,'766','2022-10-15 18:05:55','766','2022-10-15 18:07:50',10,0),('21','224',224,'Daily shift on 11/10/2022','2022-10-11','2022-10-15 19:11:54','2022-10-16 19:11:54','766',3093485.50,3093485.50,'766','2022-10-15 19:27:25','766','2022-10-17 12:09:10',10,0),('21','224',225,'Daily shift on 9/10/2022','2022-10-09','2022-10-17 12:10:37','2022-10-18 12:10:37','766',0.00,0.00,'766','2022-10-17 12:16:17','766','2022-10-17 12:17:37',10,0),('21','224',226,'Daily shift on 10/10/2022','2022-10-10','2022-10-17 12:19:18','2022-10-18 12:19:18','766',0.00,0.00,'766','2022-10-17 13:48:54','766','2022-10-17 16:31:17',10,0),('21','224',227,'Daily shift on 12/10/2022','2022-10-12','2022-10-17 16:32:46','2022-10-18 16:32:46','766',0.00,0.00,'766','2022-10-17 17:46:28','766','2022-10-17 21:38:15',10,0),('21','224',228,'Daily shift on 12/10/2022','2022-10-12','2022-10-17 21:43:23','2022-10-18 21:43:23','766',0.00,0.00,'766','2022-10-18 20:36:02','766','2022-10-18 20:36:22',10,0),('21','224',229,'Daily shift on 10/10/2022','2022-10-18','2022-10-18 20:37:03','2022-10-19 20:37:03','766',6383463.70,6383463.70,'766','2022-10-18 20:48:53','766','2022-10-18 21:19:16',10,0),('21','224',230,'Daily shift on 11/10/2022','2022-10-19','2022-10-19 14:37:48','2022-10-20 14:37:48','766',9416311.90,9416311.90,'766','2022-10-19 14:59:40','766','2022-10-19 15:00:08',10,0),('21','224',231,'Daily shift on 12/10/2022','2022-10-12','2022-10-19 16:02:26','2022-10-20 16:02:26','766',13640392.10,13640392.10,'766','2022-10-19 16:33:44','766','2022-10-19 17:00:24',10,0),('21','224',232,'Daily shift on 13/10/2022','2022-10-13','2022-10-19 17:46:48','2022-10-20 17:46:48','766',13704258.50,13704258.50,'766','2022-10-19 17:59:44','766','2022-10-19 18:15:56',10,0),('21','224',233,'Daily shift on 15/10/2022','2022-10-15','2022-10-21 17:16:14','2022-10-22 17:16:14','766',11383364.75,11383364.75,'766','2022-10-21 17:33:35','766','2022-10-21 17:51:38',10,0),('21','224',234,'Daily shift on 15/10/2022','2022-10-15','2022-10-21 18:00:57','2022-10-22 18:00:57','766',12568753.95,12568753.95,'766','2022-10-21 22:07:23','766','2022-10-21 22:25:59',10,0),('21','224',235,'Daily shift on 16/10/2022','2022-10-16','2022-10-21 22:53:18','2022-10-22 22:53:18','766',11698812.00,11698812.00,'766','2022-10-22 17:40:45','766','2022-10-22 17:41:08',10,0),('21','224',236,'Daily shift on 17/10/2022','2022-10-17','2022-10-22 17:49:32','2022-10-23 17:49:32','766',11169743.95,11169743.95,'766','2022-10-22 18:09:02','766','2022-10-22 18:26:28',10,0),('21','224',237,'Daily shift on 18/10/2022','2022-10-18','2022-10-22 18:39:38','2022-10-23 18:39:38','766',7905574.25,7905574.25,'766','2022-10-22 18:51:02','766','2022-10-22 19:04:55',10,0),('21','224',238,'Daily shift on 19/10/2022','2022-10-19','2022-10-24 12:14:11','2022-10-25 12:14:11','766',11670139.50,11670139.50,'766','2022-10-24 14:09:07','766','2022-10-24 14:26:29',10,0),('21','224',239,'Daily shift on 20/10/2022','2022-10-20','2022-10-24 14:47:05','2022-10-25 14:47:05','766',13354049.40,13354049.40,'766','2022-10-24 15:01:47','766','2022-10-24 15:50:13',10,0),('21','224',240,'Daily shift on 21/10/2022','2022-10-21','2022-10-24 16:55:37','2022-10-25 16:55:37','766',10220983.50,10220983.50,'766','2022-10-24 17:20:39','766','2022-10-24 17:45:21',10,0),('21','224',241,'Daily shift on 22/10/2022','2022-10-22','2022-10-24 17:48:04','2022-10-25 17:48:04','766',0.00,0.00,'766','2022-10-24 18:15:10','766','2022-10-25 21:38:37',10,0),('21','224',242,'Daily shift on 22/10/2022','2022-10-22','2022-10-25 21:39:55','2022-10-26 21:39:55','766',13152703.60,13152703.60,'766','2022-10-25 21:51:09','766','2022-10-25 22:08:26',10,0),('21','224',243,'Daily shift on 23/10/2022','2022-10-23','2022-10-26 16:29:12','2022-10-27 16:29:12','766',9241212.20,9241212.20,'766','2022-10-27 11:13:50','766','2022-10-27 11:21:43',10,0),('21','224',244,'Daily shift on 24/10/2022','2022-10-24','2022-10-27 18:55:41','2022-10-28 18:55:41','766',0.00,0.00,'766','2022-10-28 19:52:25','766','2022-10-28 19:53:41',10,0),('21','224',245,'Daily shift on 24/10/2022','2022-10-24','2022-10-28 20:30:46','2022-10-29 20:30:46','766',0.00,0.00,'766','2022-10-30 19:41:35','766','2022-10-30 19:42:05',10,0),('21','224',246,'Daily shift on 24/10/2022','2022-10-24','2022-10-31 16:45:55','2022-11-01 16:45:55','766',5833805.10,5833805.10,'766','2022-10-31 16:56:35','766','2022-10-31 17:24:18',10,0),('21','224',247,'25/10/2022','2022-10-25','2022-10-31 17:27:45','2022-11-01 17:27:45','766',0.00,0.00,'766','2022-11-03 21:30:45','766','2022-11-03 21:31:37',10,0),('21','224',248,'Daily shift on 25/10/2022','2022-10-25','2022-11-04 20:43:07','2022-11-05 20:43:07','766',0.00,0.00,'766','2022-11-05 22:08:42','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=6945 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','224','1','4',85,'1','1',1270546.90,1272853.50,2306.60,380589.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','4',86,'2','1',1432405.56,1434584.54,2178.98,359531.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','4',87,'3','1',952284.28,955648.69,3364.41,555127.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','4',88,'4','1',863483.08,863483.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','4',89,'5','1',1033191.00,1035777.00,2586.00,426690.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','4',90,'6','1',1435862.74,1438112.91,2250.17,371278.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','4',91,'7','1',1343668.59,1345877.03,2208.44,364392.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','4',92,'8','1',1079739.75,1081377.59,1637.84,270243.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','4',93,'9','1',1454130.38,1458199.68,4069.30,671434.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','4',94,'10','1',1649731.76,1653597.08,3865.32,637777.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','4',95,'13','1',1269500.51,1273141.60,3641.09,600779.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','4',96,'14','1',1465994.46,1470115.34,4120.88,679945.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','4',97,'15','1',1400397.91,1403878.45,3480.54,574289.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','4',98,'16','1',1326971.70,1330817.15,3845.45,634499.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','4',99,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','4',100,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','4',101,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','4',102,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','4',103,'25','1',1114587.70,1114587.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','4',104,'26','1',1263030.54,1263030.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','4',105,'29','2',671643.53,671643.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','4',106,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','4',107,'31','2',581124.72,587516.61,6391.89,4474323.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','4',108,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','4',109,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','4',110,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','4',111,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','4',112,'36','1',1540789.93,1546225.78,5435.85,896915.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','5',113,'1','1',1272853.50,1275771.88,2918.38,481532.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','5',114,'2','1',1434584.54,1436621.08,2036.54,336029.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','5',115,'3','1',955648.69,958860.89,3212.20,530013.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','5',116,'4','1',863483.08,863483.34,0.26,42.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','5',117,'5','1',1035777.00,1037659.00,1882.00,310530.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','5',118,'6','1',1438112.91,1440666.58,2553.67,421355.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','5',119,'7','1',1345877.03,1347761.82,1884.79,310990.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','5',120,'8','1',1081377.59,1083260.14,1882.55,310620.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','5',121,'9','1',1458199.68,1462258.56,4058.88,669715.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','5',122,'10','1',1653597.08,1656573.46,2976.38,491102.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','5',123,'13','1',1273141.60,1276802.86,3661.26,604107.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','5',124,'14','1',1470115.34,1473564.39,3449.05,569093.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','5',125,'15','1',1403878.45,1406994.72,3116.27,514184.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','5',126,'16','1',1330817.15,1332975.62,2158.47,356147.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','5',127,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','5',128,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','5',129,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','5',130,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','5',131,'25','1',1114587.70,1114587.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','5',132,'26','1',1263030.54,1263030.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','5',133,'29','2',671643.53,671643.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','5',134,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','5',135,'31','2',587516.61,594081.56,6564.95,4595465.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','5',136,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','5',137,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','5',138,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','5',139,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','5',140,'36','1',1546225.78,1550595.99,4370.21,721084.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','6',141,'1','1',1275771.88,1277405.22,1633.34,269501.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','6',142,'2','1',1436621.08,1439585.50,2964.42,489129.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','6',143,'3','1',958860.89,962153.48,3292.59,543277.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','6',144,'4','1',863483.34,863483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','6',145,'5','1',1037659.00,1039541.00,1882.00,310530.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','6',146,'6','1',1440666.58,1442565.04,1898.46,313245.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','6',147,'7','1',1347761.82,1349905.50,2143.68,353707.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','6',148,'8','1',1083260.14,1085581.34,2321.20,382998.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','6',149,'9','1',1462258.56,1466408.37,4149.81,684718.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','6',150,'10','1',1656573.46,1662804.87,6231.41,1028182.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','6',151,'13','1',1276802.86,1281340.38,4537.52,748690.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','6',152,'14','1',1473564.39,1477304.32,3739.93,617088.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','6',153,'15','1',1406994.72,1410639.98,3645.26,601467.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','6',154,'16','1',1332975.62,1336751.83,3776.21,623074.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','6',155,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','6',156,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','6',157,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','6',158,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','6',159,'25','1',1114587.70,1114587.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','6',160,'26','1',1263030.54,1263030.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','6',161,'29','2',671643.53,671643.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','6',162,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','6',163,'31','2',594081.56,599621.80,5540.24,3878168.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','6',164,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','6',165,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','6',166,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','6',167,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','6',168,'36','1',1550595.99,1556946.81,6350.82,1047885.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','7',169,'1','1',1277405.22,1277405.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','7',170,'2','1',1439585.50,1439585.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','7',171,'3','1',962153.48,962153.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','7',172,'4','1',863483.34,863483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','7',173,'5','1',1039541.00,1039541.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','7',174,'6','1',1442565.04,1442565.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','7',175,'7','1',1349905.50,1349905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','7',176,'8','1',1085581.34,1085581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','7',177,'9','1',1466408.37,1466408.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','7',178,'10','1',1662804.87,1662804.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','7',179,'13','1',1281340.38,1281340.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','7',180,'14','1',1477304.32,1477304.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','7',181,'15','1',1410639.98,1410639.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','7',182,'16','1',1336751.83,1336751.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','7',183,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','7',184,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','7',185,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','7',186,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','7',187,'25','1',1114587.70,1114587.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','7',188,'26','1',1263030.54,1263030.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','7',189,'29','2',671643.53,671643.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','7',190,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','7',191,'31','2',599621.80,599621.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','7',192,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','7',193,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','7',194,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','7',195,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','7',196,'36','1',1556946.81,1556946.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','8',197,'1','1',1277405.22,1277405.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','8',198,'2','1',1439585.50,1439585.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','8',199,'3','1',962153.48,962153.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','8',200,'4','1',863483.34,863483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','8',201,'5','1',1039541.00,1039541.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','8',202,'6','1',1442565.04,1442565.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','8',203,'7','1',1349905.50,1349905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','8',204,'8','1',1085581.34,1085581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','8',205,'9','1',1466408.37,1466408.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','8',206,'10','1',1662804.87,1662804.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','8',207,'13','1',1281340.38,1281340.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','8',208,'14','1',1477304.32,1477304.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','8',209,'15','1',1410639.98,1410639.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','8',210,'16','1',1336751.83,1336751.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','8',211,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','8',212,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','8',213,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','8',214,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','8',215,'25','1',1114587.70,1114587.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','8',216,'26','1',1263030.54,1263030.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','8',217,'29','2',671643.53,671643.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','8',218,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','8',219,'31','2',599621.80,599621.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','8',220,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','8',221,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','8',222,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','8',223,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','8',224,'36','1',1556946.81,1556946.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','9',225,'1','1',1277405.22,1277405.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','9',226,'2','1',1439585.50,1439585.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','9',227,'3','1',962153.48,962153.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','9',228,'4','1',863483.34,863483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','9',229,'5','1',1039541.00,1039541.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','9',230,'6','1',1442565.04,1442565.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','9',231,'7','1',1349905.50,1349905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','9',232,'8','1',1085581.34,1085581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','9',233,'9','1',1466408.37,1466408.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','9',234,'10','1',1662804.87,1662804.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','9',235,'13','1',1281340.38,1281340.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','9',236,'14','1',1477304.32,1477304.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','9',237,'15','1',1410639.98,1410639.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','9',238,'16','1',1336751.83,1336751.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','9',239,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','9',240,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','9',241,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','9',242,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','9',243,'25','1',1114587.70,1114587.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','9',244,'26','1',1263030.54,1263030.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','9',245,'29','2',671643.53,671643.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','9',246,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','9',247,'31','2',599621.80,599621.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','9',248,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','9',249,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','9',250,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','9',251,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','9',252,'36','1',1556946.81,1556946.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','10',253,'1','1',1277405.22,1277405.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','10',254,'2','1',1439585.50,1439585.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','10',255,'3','1',962153.48,962153.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','10',256,'4','1',863483.34,863483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','10',257,'5','1',1039541.00,1039541.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','10',258,'6','1',1442565.04,1442565.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','10',259,'7','1',1349905.50,1349905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','10',260,'8','1',1085581.34,1085581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','10',261,'9','1',1466408.37,1466408.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','10',262,'10','1',1662804.87,1662804.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','10',263,'13','1',1281340.38,1281340.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','10',264,'14','1',1477304.32,1477304.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','10',265,'15','1',1410639.98,1410639.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','10',266,'16','1',1336751.83,1336751.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','10',267,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','10',268,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','10',269,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','10',270,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','10',271,'25','1',1114587.70,1114587.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','10',272,'26','1',1263030.54,1263030.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','10',273,'29','2',671643.53,671643.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','10',274,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','10',275,'31','2',599621.80,599621.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','10',276,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','10',277,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','10',278,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','10',279,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','10',280,'36','1',1556946.81,1556946.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','11',281,'1','1',1277405.22,1277405.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','11',282,'2','1',1439585.50,1439585.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','11',283,'3','1',962153.48,962153.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','11',284,'4','1',863483.34,863483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','11',285,'5','1',1039541.00,1039541.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','11',286,'6','1',1442565.04,1442565.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','11',287,'7','1',1349905.50,1349905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','11',288,'8','1',1085581.34,1085581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','11',289,'9','1',1466408.37,1466408.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','11',290,'10','1',1662804.87,1662804.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','11',291,'13','1',1281340.38,1281340.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','11',292,'14','1',1477304.32,1477304.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','11',293,'15','1',1410639.98,1410639.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','11',294,'16','1',1336751.83,1336751.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','11',295,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','11',296,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','11',297,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','11',298,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','11',299,'25','1',1114587.70,1114587.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','11',300,'26','1',1263030.54,1263030.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','11',301,'29','2',671643.53,671643.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','11',302,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','11',303,'31','2',599621.80,599621.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','11',304,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','11',305,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','11',306,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','11',307,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','11',308,'36','1',1556946.81,1556946.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','12',309,'1','1',1287196.00,1290954.00,3758.00,620070.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','12',310,'2','1',1440819.00,1443008.00,2189.00,361185.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','12',311,'3','1',966000.00,969590.00,3590.00,592350.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','12',312,'4','1',864669.00,864669.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','12',313,'5','1',1039541.00,1042019.00,2478.00,408870.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','12',314,'6','1',1452351.00,1454805.00,2454.00,404910.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','12',315,'7','1',1350063.00,1353378.00,3315.00,546975.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','12',316,'8','1',1085714.00,1087871.00,2157.00,355905.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','12',317,'9','1',1466536.00,1472322.00,5786.00,954690.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','12',318,'10','1',1662924.00,1668863.00,5939.00,979935.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','12',319,'13','1',1281793.00,1287525.00,5732.00,945780.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','12',320,'14','1',1477594.00,1481853.00,4259.00,702735.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','12',321,'15','1',1410708.00,1415701.00,4993.00,823845.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','12',322,'16','1',1336816.00,1342018.00,5202.00,858330.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','12',323,'17','1',1362669.00,1362669.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','12',324,'18','1',1352152.00,1352152.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','12',325,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','12',326,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','12',327,'25','1',1115025.00,1115025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','12',328,'26','1',1270406.00,1270406.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','12',329,'29','2',671643.53,686879.39,15235.86,10665102.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','12',330,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','12',331,'31','2',599621.80,608635.68,9013.88,6309716.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','12',332,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','12',333,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','12',334,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','12',335,'35','1',1073651.00,1073651.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','12',336,'36','1',1557066.00,1562940.00,5874.00,969210.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','13',337,'1','1',1290954.00,1293556.00,2602.00,429330.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','13',338,'2','1',1443008.00,1445155.00,2147.00,354255.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','13',339,'3','1',969590.00,972116.00,2526.00,416790.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','13',340,'4','1',864669.00,864669.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','13',341,'5','1',1042019.00,1043453.00,1434.00,236610.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','13',342,'6','1',1454805.00,1456306.00,1501.00,247665.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','13',343,'7','1',1353378.00,1355004.00,1626.00,268290.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','13',344,'8','1',1087871.00,1089477.00,1606.00,264990.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','13',345,'9','1',1472322.00,1476423.00,4101.00,676665.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','13',346,'10','1',1668863.00,1672885.00,4022.00,663630.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','13',347,'13','1',1287525.00,1292056.00,4531.00,747615.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','13',348,'14','1',1481853.00,1485765.00,3912.00,645480.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','13',349,'15','1',1415701.00,1420123.00,4422.00,729630.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','13',350,'16','1',1342018.00,1346155.00,4137.00,682605.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','13',351,'17','1',1362669.00,1362669.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','13',352,'18','1',1352152.00,1352152.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','13',353,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','13',354,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','13',355,'25','1',1115025.00,1115025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','13',356,'26','1',1270406.00,1270406.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','13',357,'29','2',686879.39,694487.57,7608.18,5325726.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','13',358,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','13',359,'31','2',608635.68,615651.99,7016.31,4911417.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','13',360,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','13',361,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','13',362,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','13',363,'35','1',1073651.00,1073651.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','13',364,'36','1',1562940.00,1567959.00,5019.00,828135.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','14',365,'1','1',1293556.00,1293556.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','14',366,'2','1',1445155.00,1445155.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','14',367,'3','1',972116.00,972116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','14',368,'4','1',864669.00,864669.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','14',369,'5','1',1043453.00,1043453.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','14',370,'6','1',1456306.00,1456306.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','14',371,'7','1',1355004.00,1355004.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','14',372,'8','1',1089477.00,1089477.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','14',373,'9','1',1476423.00,1476423.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','14',374,'10','1',1672885.00,1672885.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','14',375,'13','1',1292056.00,1292056.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','14',376,'14','1',1485765.00,1485765.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','14',377,'15','1',1420123.00,1420123.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','14',378,'16','1',1346155.00,1346155.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','14',379,'17','1',1362669.00,1362669.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','14',380,'18','1',1352152.00,1352152.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','14',381,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','14',382,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','14',383,'25','1',1115025.00,1115025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','14',384,'26','1',1270406.00,1270406.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','14',385,'29','2',694487.57,694487.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','14',386,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','14',387,'31','2',615651.99,615651.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','14',388,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','14',389,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','14',390,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','14',391,'35','1',1073651.00,1073651.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','14',392,'36','1',1567959.00,1567959.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','15',393,'1','1',1283629.56,1283629.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','15',394,'2','1',1443920.78,1443920.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','15',395,'3','1',968269.43,968269.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','15',396,'4','1',863483.34,863483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','15',397,'5','1',1043453.00,1043453.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','15',398,'6','1',1446458.20,1446458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','15',399,'7','1',135485.28,135485.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','15',400,'8','1',1089343.76,1089343.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','15',401,'9','1',1476294.93,1476294.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','15',402,'10','1',1672765.95,1672765.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','15',403,'13','1',1291603.02,1291603.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','15',404,'14','1',1485475.43,1485475.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','15',405,'15','1',1420054.47,1420054.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','15',406,'16','1',1346090.98,1346090.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','15',407,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','15',408,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','15',409,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','15',410,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','15',411,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','15',412,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','15',413,'29','2',694487.57,694487.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','15',414,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','15',415,'31','2',615651.99,615651.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','15',416,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','15',417,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','15',418,'34','3',534006.36,534006.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','15',419,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','15',420,'36','1',1567839.19,1567839.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','16',421,'1','1',1283629.56,1287987.66,4358.10,719086.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','16',422,'2','1',1443920.78,1443929.72,8.94,1475.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','16',423,'3','1',968269.43,971581.00,3311.57,546409.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','16',424,'4','1',863483.34,863483.67,0.33,54.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','16',425,'5','1',1043453.00,1046200.00,2747.00,453255.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','16',426,'6','1',1446458.20,1448510.76,2052.56,338672.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','16',427,'7','1',1354845.28,1356801.48,1956.20,322773.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','16',428,'8','1',1089343.76,1091800.18,2456.42,405309.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','16',429,'9','1',1476294.93,1481870.55,5575.62,919977.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','16',430,'10','1',1672765.95,1678607.04,5841.09,963779.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','16',431,'13','1',1291603.02,1296629.98,5026.96,829448.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','16',432,'14','1',1485475.43,1490723.30,5247.87,865898.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','16',433,'15','1',1420054.47,1425115.01,5060.54,834989.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','16',434,'16','1',1346090.98,1350844.80,4753.82,784380.30,0.00,0.00,0.00,0.00,0.00),('21','224','3','16',435,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','16',436,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','16',437,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','16',438,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','16',439,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','16',440,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','16',441,'29','2',694487.57,700781.75,6294.18,4405926.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','16',442,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','16',443,'31','2',615651.99,615651.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','16',444,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','16',445,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','16',446,'34','3',534006.36,535152.15,1145.79,630184.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','16',447,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','16',448,'36','1',1567839.19,1574620.95,6781.76,1118990.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','17',449,'1','1',1287987.66,1288508.69,521.03,85969.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','17',450,'2','1',1443929.72,1446277.01,2347.29,387302.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','17',451,'3','1',971581.00,974923.33,3342.33,551484.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','17',452,'4','1',863483.67,863483.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','17',453,'5','1',1046200.00,1048565.00,2365.00,390225.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','17',454,'6','1',1448510.76,1450268.01,1757.25,289946.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','17',455,'7','1',1356801.48,1359294.41,2492.93,411333.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','17',456,'8','1',1091800.18,1092674.40,874.22,144246.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','17',457,'9','1',1481870.55,1485201.88,3331.33,549669.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','17',458,'10','1',1678607.04,1681763.34,3156.30,520789.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','17',459,'13','1',1296629.98,1300753.63,4123.65,680402.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','17',460,'14','1',1490723.30,1493023.01,2299.71,379452.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','17',461,'15','1',1425115.01,1428560.60,3445.59,568522.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','17',462,'16','1',1350844.80,1352932.63,2087.83,344491.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','17',463,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','17',464,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','17',465,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','17',466,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','17',467,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','17',468,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','17',469,'29','2',700781.75,703381.75,2600.00,1820000.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','17',470,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','17',471,'31','2',615651.99,617757.90,2105.91,1474137.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','17',472,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','17',473,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','17',474,'34','3',535152.15,536545.96,1393.81,766595.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','17',475,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','17',476,'36','1',1574620.95,1578183.79,3562.84,587868.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','18',477,'1','1',1288508.69,1293143.10,4634.41,764677.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','18',478,'2','1',1446277.01,1450344.57,4067.56,671147.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','18',479,'3','1',974923.33,979933.55,5010.22,826686.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','18',480,'4','1',863483.67,863483.90,0.23,37.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','18',481,'5','1',1048565.00,1052115.00,3550.00,585750.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','18',482,'6','1',1450268.01,1454239.87,3971.86,655356.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','18',483,'7','1',1359294.41,1362265.66,2971.25,490256.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','18',484,'8','1',1092674.40,1096916.36,4241.96,699923.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','18',485,'9','1',1485201.88,1487147.30,1945.42,320994.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','18',486,'10','1',1681763.34,1683594.71,1831.37,302176.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','18',487,'13','1',1300753.63,1302551.80,1798.17,296698.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','18',488,'14','1',1493023.01,1494928.86,1905.85,314465.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','18',489,'15','1',1428560.60,1430767.78,2207.18,364184.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','18',490,'16','1',1352932.63,1355252.41,2319.78,382763.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','18',491,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','18',492,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','18',493,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','18',494,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','18',495,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','18',496,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','18',497,'29','2',703381.75,703876.51,494.76,346332.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','18',498,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','18',499,'31','2',617757.90,622919.80,5161.90,3613330.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','18',500,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','18',501,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','18',502,'34','3',536545.96,538340.32,1794.36,986898.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','18',503,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','18',504,'36','1',1578183.79,1580471.73,2287.94,377510.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','19',505,'1','1',1293143.10,1297542.71,4399.61,725935.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','19',506,'2','1',1450344.57,1455392.03,5047.46,832830.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','19',507,'3','1',979933.55,986326.16,6392.61,1054780.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','19',508,'4','1',863483.90,863483.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','19',509,'5','1',1052115.00,1054762.00,2647.00,436755.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','19',510,'6','1',1454239.87,1458716.77,4476.90,738688.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','19',511,'7','1',1362265.66,1367093.78,4828.12,796639.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','19',512,'8','1',1096916.36,1101463.81,4547.45,750329.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','19',513,'9','1',1487147.30,1493171.56,6024.26,994002.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','19',514,'10','1',1683594.71,1689661.96,6067.25,1001096.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','19',515,'13','1',1302551.80,1308829.60,6277.80,1035837.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','19',516,'14','1',1494928.86,1499534.87,4606.01,759991.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','19',517,'15','1',1430767.78,1435736.70,4968.92,819871.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','19',518,'16','1',1355252.41,1359822.48,4570.07,754061.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','19',519,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','19',520,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','19',521,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','19',522,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','19',523,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','19',524,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','19',525,'29','2',703876.51,703876.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','19',526,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','19',527,'31','2',622919.80,629148.25,6228.45,4359915.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','19',528,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','19',529,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','19',530,'34','3',538340.32,539928.13,1587.81,873295.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','19',531,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','19',532,'36','1',1580471.73,1592386.94,11915.21,1966009.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','20',533,'1','1',1297542.71,1300569.14,3026.43,499360.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','20',534,'2','1',1455392.03,1460069.12,4677.09,771719.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','20',535,'3','1',986326.16,991860.83,5534.67,913220.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','20',536,'4','1',863483.90,863483.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','20',537,'5','1',1054762.00,1059268.00,4506.00,743490.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','20',538,'6','1',1458716.77,1458716.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','20',539,'7','1',1367093.78,1370852.79,3759.01,620236.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','20',540,'8','1',1101463.81,1104350.90,2887.09,476369.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','20',541,'9','1',1493171.56,1496328.21,3156.65,520847.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','20',542,'10','1',1689661.96,1693491.62,3829.66,631893.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','20',543,'13','1',1308829.60,1314900.23,6070.63,1001653.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','20',544,'14','1',1499534.87,1499535.56,0.69,113.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','20',545,'15','1',1435736.70,1441027.71,5291.01,873016.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','20',546,'16','1',1359822.48,1363686.06,3863.58,637490.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','20',547,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','20',548,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','20',549,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','20',550,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','20',551,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','20',552,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','20',553,'29','2',703876.51,703876.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','20',554,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','20',555,'31','2',629148.25,636267.51,7119.26,4983482.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','20',556,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','20',557,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','20',558,'34','3',539928.13,541057.27,1129.14,621027.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','20',559,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','20',560,'36','1',1592386.94,1597361.81,4974.87,820853.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','21',561,'1','1',1300569.14,1304573.55,4004.41,660727.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','21',562,'2','1',1460069.12,1463722.90,3653.78,602873.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','21',563,'3','1',991860.83,996906.34,5045.51,832509.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','21',564,'4','1',863483.90,863483.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','21',565,'5','1',1059268.00,1063247.00,3979.00,656535.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','21',566,'6','1',1458716.77,1468541.09,9824.32,1621012.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','21',567,'7','1',1370852.79,1374531.96,3679.17,607063.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','21',568,'8','1',1104350.90,1108211.06,3860.16,636926.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','21',569,'9','1',1496328.21,1498795.34,2467.13,407076.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','21',570,'10','1',1693491.62,1696175.54,2683.92,442846.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','21',571,'13','1',1314900.23,1318345.08,3444.85,568400.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','21',572,'14','1',1499535.56,1499535.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','21',573,'15','1',1441027.71,1443721.60,2693.89,444491.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','21',574,'16','1',1363686.06,1366291.19,2605.13,429846.45,0.00,0.00,0.00,0.00,0.00),('21','224','3','21',575,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','21',576,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','21',577,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','21',578,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','21',579,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','21',580,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','21',581,'29','2',703876.51,703876.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','21',582,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','21',583,'31','2',636267.51,642873.84,6606.33,4624431.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','21',584,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','21',585,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','21',586,'34','3',541057.27,542193.86,1136.59,625124.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','21',587,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','21',588,'36','1',1597361.81,1600930.74,3568.93,588873.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','22',589,'1','1',1304573.55,1308822.50,4248.95,701076.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','22',590,'2','1',1463722.90,1468546.37,4823.47,795872.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','22',591,'3','1',996906.34,1003909.06,7002.72,1155448.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','22',592,'4','1',863483.90,863484.26,0.36,59.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','22',593,'5','1',1063247.00,1069706.00,6459.00,1065735.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','22',594,'6','1',1468541.09,1473510.43,4969.34,819941.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','22',595,'7','1',1374531.96,1380100.30,5568.34,918776.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','22',596,'8','1',1108211.06,1113309.19,5098.13,841191.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','22',597,'9','1',1498795.34,1501804.43,3009.09,496499.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','22',598,'10','1',1696175.54,1699197.44,3021.90,498613.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','22',599,'13','1',1318345.08,1322929.18,4584.10,756376.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','22',600,'14','1',1499535.56,1499535.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','22',601,'15','1',1443721.60,1446526.06,2804.46,462735.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','22',602,'16','1',1366291.19,1369316.67,3025.48,499204.20,0.00,0.00,0.00,0.00,0.00),('21','224','3','22',603,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','22',604,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','22',605,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','22',606,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','22',607,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','22',608,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','22',609,'29','2',703876.51,703920.17,43.66,30562.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','22',610,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','22',611,'31','2',642873.84,648521.54,5647.70,3953390.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','22',612,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','22',613,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','22',614,'34','3',542193.86,542933.22,739.36,406648.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','22',615,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','22',616,'36','1',1600930.74,1604995.60,4064.86,670701.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','23',617,'1','1',1308822.50,1312452.60,3630.10,598966.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','23',618,'2','1',1468546.37,1472343.99,3797.62,626607.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','23',619,'3','1',1003909.06,1008231.93,4322.87,713273.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','23',620,'4','1',863484.26,863484.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','23',621,'5','1',1069706.00,1074442.00,4736.00,781440.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','23',622,'6','1',1473510.43,1478293.75,4783.32,789247.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','23',623,'7','1',1380100.30,1380100.39,0.09,14.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','23',624,'8','1',1113309.19,1117615.44,4306.25,710531.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','23',625,'9','1',1501804.43,1505186.88,3382.45,558104.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','23',626,'10','1',1699197.44,1702429.16,3231.72,533233.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','23',627,'13','1',1322929.18,1326370.62,3441.44,567837.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','23',628,'14','1',1499535.56,1499535.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','23',629,'15','1',1446526.06,1449045.59,2519.53,415722.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','23',630,'16','1',1369316.67,1372260.85,2944.18,485789.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','23',631,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','23',632,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','23',633,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','23',634,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','23',635,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','23',636,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','23',637,'29','2',703920.17,704288.04,367.87,257509.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','23',638,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','23',639,'31','2',648521.54,651907.27,3385.73,2370011.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','23',640,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','23',641,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','23',642,'34','3',542933.22,543841.63,908.41,499625.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','23',643,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','23',644,'36','1',1604995.60,1609048.34,4052.74,668702.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','24',645,'1','1',1312452.60,1313748.99,1296.39,213904.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','24',646,'2','1',1472343.99,1476914.04,4570.05,754058.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','24',647,'3','1',1008231.93,1013664.88,5432.95,896436.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','24',648,'4','1',863484.26,863484.68,0.42,69.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','24',649,'5','1',1074442.00,1078020.00,3578.00,590370.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','24',650,'6','1',1478293.75,1483398.24,5104.49,842240.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','24',651,'7','1',1380100.39,1381853.03,1752.64,289185.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','24',652,'8','1',1117615.44,1122691.85,5076.41,837607.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','24',653,'9','1',1505186.88,1507852.16,2665.28,439771.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','24',654,'10','1',1702429.16,1704749.06,2319.90,382783.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','24',655,'13','1',1326370.62,1329649.49,3278.87,541013.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','24',656,'14','1',1499535.56,1499535.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','24',657,'15','1',1449045.59,1452244.90,3199.31,527886.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','24',658,'16','1',1372260.85,1374471.83,2210.98,364811.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','24',659,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','24',660,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','24',661,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','24',662,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','24',663,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','24',664,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','24',665,'29','2',704288.04,704288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','24',666,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','24',667,'31','2',651907.27,657459.59,5552.32,3886624.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','24',668,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','24',669,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','24',670,'34','3',543841.63,544742.21,900.58,495319.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','24',671,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','24',672,'36','1',1609048.34,1611953.31,2904.97,479320.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','25',673,'1','1',1313748.99,1313832.00,83.01,13696.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','25',674,'2','1',1476914.04,1483520.74,6606.70,1090105.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','25',675,'3','1',1013664.88,1020148.92,6484.04,1069866.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','25',676,'4','1',863484.68,863484.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','25',677,'5','1',1078020.00,1083471.00,5451.00,899415.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','25',678,'6','1',1483398.24,1488303.13,4904.89,809306.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','25',679,'7','1',1381853.03,1387377.14,5524.11,911478.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','25',680,'8','1',1122691.85,1126512.60,3820.75,630423.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','25',681,'9','1',1507852.16,1510558.30,2706.14,446513.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','25',682,'10','1',1704749.06,1707177.69,2428.63,400723.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','25',683,'13','1',1329649.49,1333025.82,3376.33,557094.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','25',684,'14','1',1499535.56,1499535.60,0.04,6.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','25',685,'15','1',1452244.90,1454647.41,2402.51,396414.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','25',686,'16','1',1374471.83,1376932.73,2460.90,406048.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','25',687,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','25',688,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','25',689,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','25',690,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','25',691,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','25',692,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','25',693,'29','2',704288.04,707699.67,3411.63,2388141.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','25',694,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','25',695,'31','2',657459.59,658904.98,1445.39,1011773.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','25',696,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','25',697,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','25',698,'34','3',544742.21,545809.58,1067.37,587053.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','25',699,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','25',700,'36','1',1611953.31,1615512.99,3559.68,587347.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','26',701,'1','1',1313832.00,1317182.82,3350.82,552885.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','26',702,'2','1',1483520.74,1488544.88,5024.14,828983.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','26',703,'3','1',1020148.92,1027433.41,7284.49,1201940.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','26',704,'4','1',863484.68,863485.58,0.90,148.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','26',705,'5','1',1083471.00,1088681.00,5210.00,859650.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','26',706,'6','1',1488303.13,1493342.18,5039.05,831443.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','26',707,'7','1',1387377.14,1391186.51,3809.37,628546.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','26',708,'8','1',1126512.60,1131314.12,4801.52,792250.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','26',709,'9','1',1510558.30,1514276.08,3717.78,613433.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','26',710,'10','1',1707177.69,1711080.85,3903.16,644021.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','26',711,'13','1',1333025.82,1338099.97,5074.15,837234.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','26',712,'14','1',1499535.60,1499535.71,0.11,18.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','26',713,'15','1',1454647.41,1454648.61,1.20,198.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','26',714,'16','1',1376932.73,1377428.49,495.76,81800.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','26',715,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','26',716,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','26',717,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','26',718,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','26',719,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','26',720,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','26',721,'29','2',707699.67,712226.95,4527.28,3169096.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','26',722,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','26',723,'31','2',658904.98,658905.64,0.66,462.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','26',724,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','26',725,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','26',726,'34','3',545809.58,546781.15,971.57,534363.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','26',727,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','26',728,'36','1',1615512.99,1620735.52,5222.53,861717.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','27',729,'1','1',1317182.82,1322479.21,5296.39,873904.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','27',730,'2','1',1488544.88,1491830.71,3285.83,542161.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','27',731,'3','1',1027433.41,1034461.95,7028.54,1159709.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','27',732,'4','1',863485.58,863485.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','27',733,'5','1',1088681.00,1093774.00,5093.00,840345.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','27',734,'6','1',1493342.18,1498405.57,5063.39,835459.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','27',735,'7','1',1391186.51,1395428.99,4242.48,700009.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','27',736,'8','1',1131314.12,1136558.83,5244.71,865377.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','27',737,'9','1',1514276.08,1518189.97,3913.89,645791.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','27',738,'10','1',1711080.85,1715258.04,4177.19,689236.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','27',739,'13','1',1338099.97,1343221.65,5121.68,845077.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','27',740,'14','1',1499535.71,1499535.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','27',741,'15','1',1454648.61,1454648.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','27',742,'16','1',1377428.49,1377428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','27',743,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','27',744,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','27',745,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','27',746,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','27',747,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','27',748,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','27',749,'29','2',712226.95,717536.96,5310.01,3717007.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','27',750,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','27',751,'31','2',658905.64,658905.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','27',752,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','27',753,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','27',754,'34','3',546781.15,547737.46,956.31,525970.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','27',755,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','27',756,'36','1',1620735.52,1625819.67,5084.15,838884.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','28',757,'1','1',1322479.21,1326163.37,3684.16,607886.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','28',758,'2','1',1491830.71,1496770.48,4939.77,815062.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','28',759,'3','1',1034461.95,1039877.39,5415.44,893547.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','28',760,'4','1',863485.58,863485.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','28',761,'5','1',1093774.00,1097736.00,3962.00,653730.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','28',762,'6','1',1498405.57,1502719.98,4314.41,711877.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','28',763,'7','1',1395428.99,1398315.11,2886.12,476209.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','28',764,'8','1',1136558.83,1141308.60,4749.77,783711.39,0.00,0.00,0.00,0.00,0.00),('21','224','2','28',765,'9','1',1518189.97,1522146.49,3956.52,652825.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','28',766,'10','1',1715258.04,1719052.94,3794.90,626158.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','28',767,'13','1',1343221.65,1348093.76,4872.11,803898.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','28',768,'14','1',1499535.71,1499535.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','28',769,'15','1',1454648.61,1454648.98,0.37,61.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','28',770,'16','1',1377428.49,1381325.54,3897.05,643013.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','28',771,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','28',772,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','28',773,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','28',774,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','28',775,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','28',776,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','28',777,'29','2',717536.96,722505.88,4968.92,3478244.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','28',778,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','28',779,'31','2',658905.64,658905.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','28',780,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','28',781,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','28',782,'34','3',547737.46,548639.65,902.19,496204.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','28',783,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','28',784,'36','1',1625819.67,1630925.27,5105.60,842424.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','29',785,'1','1',1326163.37,1331555.44,5392.07,889691.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','29',786,'2','1',1496770.48,1499701.28,2930.80,483582.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','29',787,'3','1',1039877.39,1046590.16,6712.77,1107607.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','29',788,'4','1',863485.58,863486.97,1.39,229.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','29',789,'5','1',1097736.00,1100639.00,2903.00,478995.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','29',790,'6','1',1502719.98,1509062.26,6342.28,1046476.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','29',791,'7','1',1398315.11,1402907.68,4592.57,757774.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','29',792,'8','1',1141308.60,1144860.17,3551.57,586009.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','29',793,'9','1',1522146.49,1523632.98,1486.49,245270.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','29',794,'10','1',1719052.94,1720599.42,1546.48,255169.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','29',795,'13','1',1348093.76,1350197.27,2103.51,347079.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','29',796,'14','1',1499535.71,1499535.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','29',797,'15','1',1454648.98,1455575.20,926.22,152826.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','29',798,'16','1',1381325.54,1382088.83,763.29,125942.85,0.00,0.00,0.00,0.00,0.00),('21','224','3','29',799,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','29',800,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','29',801,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','29',802,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','29',803,'25','1',1114587.71,1114587.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','29',804,'26','1',1263030.00,1263030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','29',805,'29','2',722505.88,728761.37,6255.49,4378843.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','29',806,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','29',807,'31','2',658905.64,658905.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','29',808,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','29',809,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','29',810,'34','3',548639.65,549531.48,891.83,490506.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','29',811,'35','1',1073531.97,1073531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','29',812,'36','1',1630925.27,1632424.92,1499.65,247442.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','30',813,'1','1',1331555.44,1336222.18,4666.74,770012.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','30',814,'2','1',1499701.28,1502501.81,2800.53,462087.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','30',815,'3','1',1046590.16,1052366.84,5776.68,953152.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','30',816,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','30',817,'5','1',1100639.00,1105072.00,4433.00,731445.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','30',818,'6','1',1509062.26,1513814.58,4752.32,784132.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','30',819,'7','1',1402907.68,1407284.75,4377.07,722216.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','30',820,'8','1',1144860.17,1150136.47,5276.30,870589.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','30',821,'9','1',1523632.98,1526094.49,2461.51,406149.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','30',822,'10','1',1720599.42,1723478.56,2879.14,475058.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','30',823,'13','1',1350197.27,1353639.72,3442.45,568004.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','30',824,'14','1',1499535.71,1499535.74,0.03,4.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','30',825,'15','1',1455575.20,1458379.26,2804.06,462669.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','30',826,'16','1',1382088.83,1385009.04,2920.21,481834.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','30',827,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','30',828,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','30',829,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','30',830,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','30',831,'25','1',1114587.71,1115831.07,1243.36,205154.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','30',832,'26','1',1263030.00,1264483.89,1453.89,239891.85,0.00,0.00,0.00,0.00,0.00),('21','224','4','30',833,'29','2',728761.37,736586.32,7824.95,5477465.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','30',834,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','30',835,'31','2',658905.64,659887.96,982.32,687624.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','30',836,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','30',837,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','30',838,'34','3',549531.48,550341.87,810.39,445714.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','30',839,'35','1',1073531.97,1073532.72,0.75,123.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','30',840,'36','1',1632424.92,1636212.52,3787.60,624954.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','31',841,'1','1',1336222.18,1343419.11,7196.93,1187493.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','31',842,'2','1',1502501.81,1502502.17,0.36,59.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','31',843,'3','1',1052366.84,1058633.83,6266.99,1034053.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','31',844,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','31',845,'5','1',1105072.00,1109040.00,3968.00,654720.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','31',846,'6','1',1513814.58,1518711.10,4896.52,807925.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','31',847,'7','1',1407284.75,1412798.38,5513.63,909748.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','31',848,'8','1',1150136.47,1154875.94,4739.47,782012.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','31',849,'9','1',1526094.49,1526094.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','31',850,'10','1',1723478.56,1723478.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','31',851,'13','1',1353639.72,1353639.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','31',852,'14','1',1499535.74,1499535.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','31',853,'15','1',1458379.26,1458379.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','31',854,'16','1',1385009.04,1385009.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','31',855,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','31',856,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','31',857,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','31',858,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','31',859,'25','1',1115831.07,1122314.65,6483.58,1069790.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','31',860,'26','1',1264483.89,1272365.48,7881.59,1300462.35,0.00,0.00,0.00,0.00,0.00),('21','224','4','31',861,'29','2',736586.32,736587.92,1.60,1120.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','31',862,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','31',863,'31','2',659887.96,666209.81,6321.85,4425295.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','31',864,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','31',865,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','31',866,'34','3',550341.87,551378.75,1036.88,570284.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','31',867,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','31',868,'36','1',1636212.52,1636212.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','32',869,'1','1',1343419.11,1352087.61,8668.50,1430302.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','32',870,'2','1',1502502.17,1502502.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','32',871,'3','1',1058633.83,1067567.12,8933.29,1473992.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','32',872,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','32',873,'5','1',1109040.00,1115303.00,6263.00,1033395.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','32',874,'6','1',1518711.10,1523884.79,5173.69,853658.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','32',875,'7','1',1412798.38,1418893.68,6095.30,1005724.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','32',876,'8','1',1154875.94,1161108.28,6232.34,1028336.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','32',877,'9','1',1526094.49,1526094.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','32',878,'10','1',1723478.56,1723478.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','32',879,'13','1',1353639.72,1353639.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','32',880,'14','1',1499535.74,1499535.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','32',881,'15','1',1458379.26,1458379.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','32',882,'16','1',1385009.04,1385009.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','32',883,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','32',884,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','32',885,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','32',886,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','32',887,'25','1',1122314.65,1125404.26,3089.61,509785.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','32',888,'26','1',1272365.48,1276333.50,3968.02,654723.30,0.00,0.00,0.00,0.00,0.00),('21','224','4','32',889,'29','2',736587.92,737452.85,864.93,605451.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','32',890,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','32',891,'31','2',666209.81,677696.01,11486.20,8040340.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','32',892,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','32',893,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','32',894,'34','3',551378.75,552211.62,832.87,458078.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','32',895,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','32',896,'36','1',1636212.52,1636212.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','33',897,'1','1',1352087.61,1357783.01,5695.40,939741.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','33',898,'2','1',1502502.17,1508471.30,5969.13,984906.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','33',899,'3','1',1067567.12,1075012.14,7445.02,1228428.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','33',900,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','33',901,'5','1',1115303.00,1120428.00,5125.00,845625.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','33',902,'6','1',1523884.79,1530319.34,6434.55,1061700.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','33',903,'7','1',1418893.68,1424461.02,5567.34,918611.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','33',904,'8','1',1161108.28,1167332.34,6224.06,1026969.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','33',905,'9','1',1526094.49,1527851.91,1757.42,289974.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','33',906,'10','1',1723478.56,1725619.99,2132.59,351877.35,0.00,0.00,8.84,0.00,0.00),('21','224','2','33',907,'13','1',1353639.72,1356438.69,2798.97,461830.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','33',908,'14','1',1499535.74,1499536.21,0.47,77.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','33',909,'15','1',1458379.26,1460687.85,2308.59,380917.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','33',910,'16','1',1385009.04,1387330.67,2321.63,383068.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','33',911,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','33',912,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','33',913,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','33',914,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','33',915,'25','1',1125404.26,1130705.99,5301.73,874785.45,0.00,0.00,0.00,0.00,0.00),('21','224','3','33',916,'26','1',1276333.50,1281604.24,5270.74,869672.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','33',917,'29','2',737452.85,743720.60,6267.75,4387425.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','33',918,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','33',919,'31','2',677696.01,680220.02,2524.01,1766807.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','33',920,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','33',921,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','33',922,'34','3',552211.62,553382.91,1171.29,644209.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','33',923,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','33',924,'36','1',1636212.52,1638982.43,2769.91,457035.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','34',925,'1','1',1357783.01,1362276.99,4493.98,741506.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','34',926,'2','1',1508471.30,1513623.74,5152.44,850152.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','34',927,'3','1',1075012.14,1081539.07,6526.93,1076943.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','34',928,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','34',929,'5','1',1120428.00,1125249.00,4821.00,795465.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','34',930,'6','1',1530319.34,1535318.50,4999.16,824861.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','34',931,'7','1',1424461.02,1428808.77,4347.75,717378.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','34',932,'8','1',1167332.34,1171994.46,4662.12,769249.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','34',933,'9','1',1527851.91,1529253.86,1401.95,231321.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','34',934,'10','1',1725619.99,1727472.07,1852.08,305593.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','34',935,'13','1',1356438.69,1359499.49,3060.80,505032.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','34',936,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','34',937,'15','1',1460687.85,1462855.59,2167.74,357677.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','34',938,'16','1',1387330.67,1389115.68,1785.01,294526.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','34',939,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','34',940,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','34',941,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','34',942,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','34',943,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','34',944,'26','1',1281604.24,1281604.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','34',945,'29','2',743720.60,749243.25,5522.65,3865855.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','34',946,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','34',947,'31','2',680220.02,680220.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','34',948,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','34',949,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','34',950,'34','3',553382.91,554275.87,892.96,491128.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','34',951,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','34',952,'36','1',1638982.43,1641300.73,2318.30,382519.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','35',953,'1','1',1362276.99,1367793.54,5516.55,910230.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','35',954,'2','1',1513623.74,1519684.60,6060.86,1000041.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','35',955,'3','1',1081539.07,1088413.50,6874.43,1134280.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','35',956,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','35',957,'5','1',1125249.00,1130059.00,4810.00,793650.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','35',958,'6','1',1535318.50,1540825.51,5507.01,908656.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','35',959,'7','1',1428808.77,1434523.19,5714.42,942879.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','35',960,'8','1',1171994.46,1176278.97,4284.51,706944.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','35',961,'9','1',1529253.86,1532177.02,2923.16,482321.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','35',962,'10','1',1727472.07,1731907.38,4435.31,731826.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','35',963,'13','1',1359499.49,1364956.15,5456.66,900348.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','35',964,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','35',965,'15','1',1462855.59,1467207.32,4351.73,718035.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','35',966,'16','1',1389115.68,1392539.74,3424.06,564969.90,0.00,0.00,0.00,0.00,0.00),('21','224','3','35',967,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','35',968,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','35',969,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','35',970,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','35',971,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','35',972,'26','1',1281604.24,1281604.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','35',973,'29','2',749243.25,756640.88,7397.63,5178341.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','35',974,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','35',975,'31','2',680220.02,680220.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','35',976,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','35',977,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','35',978,'34','3',554275.87,555270.49,994.62,547041.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','35',979,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','35',980,'36','1',1641300.73,1645264.73,3964.00,654060.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','36',981,'1','1',1367793.54,1372347.39,4553.85,751385.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','36',982,'2','1',1519684.60,1523972.57,4287.97,707515.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','36',983,'3','1',1088413.50,1093212.48,4798.98,791831.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','36',984,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','36',985,'5','1',1130059.00,1133380.00,3321.00,547965.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','36',986,'6','1',1540825.51,1545730.68,4905.17,809353.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','36',987,'7','1',1434523.19,1438210.34,3687.15,608379.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','36',988,'8','1',1176278.97,1180779.91,4500.94,742655.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','36',989,'9','1',1532177.02,1534746.68,2569.66,423993.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','36',990,'10','1',1731907.38,1734580.10,2672.72,440998.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','36',991,'13','1',1364956.15,1367926.01,2969.86,490026.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','36',992,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','36',993,'15','1',1467207.32,1469882.58,2675.26,441417.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','36',994,'16','1',1392539.74,1395223.38,2683.64,442800.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','36',995,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','36',996,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','36',997,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','36',998,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','36',999,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','36',1000,'26','1',1281604.24,1281604.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','36',1001,'29','2',756640.88,757236.19,595.31,416717.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','36',1002,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','36',1003,'31','2',680220.02,686820.85,6600.83,4620581.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','36',1004,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','36',1005,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','36',1006,'34','3',555270.49,556280.70,1010.21,555615.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','36',1007,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','36',1008,'36','1',1645264.73,1648755.47,3490.74,575972.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','37',1009,'1','1',1372347.39,1375845.94,3498.55,577260.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','37',1010,'2','1',1523972.57,1528328.77,4356.20,718773.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','37',1011,'3','1',1093212.48,1097927.71,4715.23,778012.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','37',1012,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','37',1013,'5','1',1133380.00,1136514.00,3134.00,517110.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','37',1014,'6','1',1545730.68,1549283.29,3552.61,586180.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','37',1015,'7','1',1438210.34,1442320.06,4109.72,678103.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','37',1016,'8','1',1180779.91,1184406.55,3626.64,598395.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','37',1017,'9','1',1534746.68,1536928.60,2181.92,360016.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','37',1018,'10','1',1734580.10,1736529.36,1949.26,321627.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','37',1019,'13','1',1367926.01,1370289.72,2363.71,390012.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','37',1020,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','37',1021,'15','1',1469882.58,1472404.15,2521.57,416059.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','37',1022,'16','1',1395223.38,1397609.20,2385.82,393660.30,0.00,0.00,0.00,0.00,0.00),('21','224','3','37',1023,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','37',1024,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','37',1025,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','37',1026,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','37',1027,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','37',1028,'26','1',1281604.24,1281604.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','37',1029,'29','2',757236.19,757236.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','37',1030,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','37',1031,'31','2',686820.85,692341.55,5520.70,3864490.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','37',1032,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','37',1033,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','37',1034,'34','3',556280.70,557342.82,1062.12,584166.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','37',1035,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','37',1036,'36','1',1648755.47,1651019.17,2263.70,373510.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','38',1037,'1','1',1375845.94,1378890.16,3044.22,502296.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','38',1038,'2','1',1528328.77,1531628.51,3299.74,544457.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','38',1039,'3','1',1097927.71,1102615.50,4687.79,773485.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','38',1040,'4','1',863486.97,863486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','38',1041,'5','1',1136514.00,1140054.00,3540.00,584100.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','38',1042,'6','1',1549283.29,1552777.51,3494.22,576546.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','38',1043,'7','1',1442320.06,1445213.04,2892.98,477341.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','38',1044,'8','1',1184406.55,1187949.86,3543.31,584646.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','38',1045,'9','1',1536928.60,1539068.46,2139.86,353076.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','38',1046,'10','1',1736529.36,1739195.84,2666.48,439969.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','38',1047,'13','1',1370289.72,1372851.38,2561.66,422673.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','38',1048,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','38',1049,'15','1',1472404.15,1474007.63,1603.48,264574.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','38',1050,'16','1',1397609.20,1400325.35,2716.15,448164.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','38',1051,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','38',1052,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','38',1053,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','38',1054,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','38',1055,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','38',1056,'26','1',1281604.24,1281604.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','38',1057,'29','2',757236.19,757236.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','38',1058,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','38',1059,'31','2',692341.55,697166.03,4824.48,3377136.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','38',1060,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','38',1061,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','38',1062,'34','3',557342.82,558016.64,673.82,370601.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','38',1063,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','38',1064,'36','1',1651019.17,1653390.60,2371.43,391285.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','39',1065,'1','1',1378890.16,1385174.99,6284.83,1036996.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','39',1066,'2','1',1531628.51,1531997.05,368.54,60809.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','39',1067,'3','1',1102615.50,1108546.95,5931.45,978689.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','39',1068,'4','1',863486.97,863487.80,0.83,136.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','39',1069,'5','1',1140054.00,1144511.00,4457.00,735405.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','39',1070,'6','1',1552777.51,1558400.02,5622.51,927714.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','39',1071,'7','1',1445213.04,1449761.95,4548.91,750570.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','39',1072,'8','1',1187949.86,1191780.70,3830.84,632088.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','39',1073,'9','1',1539068.46,1541647.42,2578.96,425528.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','39',1074,'10','1',1739195.84,1742001.75,2805.91,462975.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','39',1075,'13','1',1372851.38,1376778.91,3927.53,648042.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','39',1076,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','39',1077,'15','1',1474007.63,1476510.78,2503.15,413019.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','39',1078,'16','1',1400325.35,1403561.09,3235.74,533897.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','39',1079,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','39',1080,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','39',1081,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','39',1082,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','39',1083,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','39',1084,'26','1',1281604.24,1281604.63,0.39,64.35,0.00,0.00,0.00,0.00,0.00),('21','224','4','39',1085,'29','2',757236.19,757236.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','39',1086,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','39',1087,'31','2',697166.03,702143.55,4977.52,3484264.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','39',1088,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','39',1089,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','39',1090,'34','3',558016.64,558920.37,903.73,497051.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','39',1091,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','39',1092,'36','1',1653390.60,1656313.79,2923.19,482326.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','40',1093,'1','1',1385174.99,1390016.82,4841.83,798901.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','40',1094,'2','1',1531997.05,1537349.87,5352.82,883215.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','40',1095,'3','1',1108546.95,1113247.37,4700.42,775569.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','40',1096,'4','1',863487.80,863488.17,0.37,61.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','40',1097,'5','1',1144511.00,1149262.00,4751.00,783915.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','40',1098,'6','1',1558400.02,1564549.12,6149.10,1014601.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','40',1099,'7','1',1449761.95,1454560.13,4798.18,791699.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','40',1100,'8','1',1191780.70,1196383.32,4602.62,759432.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','40',1101,'9','1',1541647.42,1549135.94,7488.52,1235605.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','40',1102,'10','1',1742001.75,1742006.06,4.31,711.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','40',1103,'13','1',1376778.91,1383862.41,7083.50,1168777.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','40',1104,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','40',1105,'15','1',1476510.78,1476511.13,0.35,57.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','40',1106,'16','1',1403561.09,1410178.72,6617.63,1091908.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','40',1107,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','40',1108,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','40',1109,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','40',1110,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','40',1111,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','40',1112,'26','1',1281604.63,1281604.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','40',1113,'29','2',757236.19,764964.23,7728.04,5409628.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','40',1114,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','40',1115,'31','2',702143.55,702409.26,265.71,185997.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','40',1116,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','40',1117,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','40',1118,'34','3',558920.37,560078.62,1158.25,637037.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','40',1119,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','40',1120,'36','1',1656313.79,1662559.73,6245.94,1030580.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','41',1121,'1','1',1390016.82,1394849.21,4781.32,788918.62,0.00,0.00,51.07,0.00,0.00),('21','224','1','41',1122,'2','1',1537349.87,1543004.79,5654.92,933061.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','41',1123,'3','1',1113247.37,1119853.91,6606.54,1090079.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','41',1124,'4','1',863488.17,863488.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','41',1125,'5','1',1149262.00,1153838.00,4576.00,755040.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','41',1126,'6','1',1564549.12,1570213.72,5664.60,934659.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','41',1127,'7','1',1454560.13,1459338.82,4778.69,788483.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','41',1128,'8','1',1196383.32,1200725.56,4342.24,716469.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','41',1129,'9','1',1549135.94,1556602.86,7466.92,1232041.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','41',1130,'10','1',1742006.06,1742006.67,0.61,100.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','41',1131,'13','1',1383862.41,1390556.00,6693.59,1104442.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','41',1132,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','41',1133,'15','1',1476511.13,1476511.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','41',1134,'16','1',1410178.72,1416169.89,5991.17,988543.05,0.00,0.00,0.00,0.00,0.00),('21','224','3','41',1135,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','41',1136,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','41',1137,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','41',1138,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','41',1139,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','41',1140,'26','1',1281604.63,1281604.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','41',1141,'29','2',764964.23,770217.40,5253.17,3677219.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','41',1142,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','41',1143,'31','2',702409.26,706284.68,3875.42,2712794.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','41',1144,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','41',1145,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','41',1146,'34','3',560078.62,561261.16,1182.54,650397.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','41',1147,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','41',1148,'36','1',1662559.73,1667451.14,4891.41,807082.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','42',1149,'1','1',1394849.21,1398485.67,3636.46,600015.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','42',1150,'2','1',1543004.79,1547815.59,4810.80,793782.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','42',1151,'3','1',1119853.91,1125009.13,5155.22,850611.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','42',1152,'4','1',863488.17,863488.91,0.74,122.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','42',1153,'5','1',1153838.00,1157554.00,3716.00,613140.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','42',1154,'6','1',1570213.72,1574025.10,3811.38,628877.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','42',1155,'7','1',1459338.82,1463686.29,4347.47,717332.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','42',1156,'8','1',1200725.56,1204051.06,3325.50,548707.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','42',1157,'9','1',1556602.86,1564272.85,7669.99,1265548.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','42',1158,'10','1',1742006.67,1742006.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','42',1159,'13','1',1390556.00,1397539.67,6983.67,1152305.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','42',1160,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','42',1161,'15','1',1476511.13,1476511.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','42',1162,'16','1',1416169.89,1423469.16,7299.27,1204379.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','42',1163,'17','1',1362496.04,1362496.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','42',1164,'18','1',1352020.18,1352020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','42',1165,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','42',1166,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','42',1167,'25','1',1130705.99,1130705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','42',1168,'26','1',1281604.63,1281604.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','42',1169,'29','2',770217.40,770217.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','42',1170,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','42',1171,'31','2',706284.68,714150.38,7865.70,5505990.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','42',1172,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','42',1173,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','42',1174,'34','3',561261.16,562473.97,1212.81,667045.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','42',1175,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','42',1176,'36','1',1667451.14,1674401.00,6949.86,1146726.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','43',1177,'1','1',1398485.67,1403905.08,5419.41,894202.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','43',1178,'2','1',1547815.59,1554639.07,6823.48,1125874.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','43',1179,'3','1',1125009.13,1134826.28,9817.15,1619829.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','43',1180,'4','1',863488.91,863490.70,1.79,295.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','43',1181,'5','1',1157554.00,1162264.00,4710.00,777150.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','43',1182,'6','1',1574025.10,1580366.18,6341.08,1046278.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','43',1183,'7','1',1463686.29,1469695.31,6009.02,991488.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','43',1184,'8','1',1204051.06,1208431.98,4380.92,722851.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','43',1185,'9','1',1564272.85,1568452.14,4179.29,689582.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','43',1186,'10','1',1742006.67,1742006.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','43',1187,'13','1',1397539.67,1401468.82,3848.54,635009.10,0.00,0.00,80.61,0.00,0.00),('21','224','2','43',1188,'14','1',1499536.21,1499536.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','43',1189,'15','1',1476511.13,1476511.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','43',1190,'16','1',1423469.16,1427400.69,3931.53,648702.45,0.00,0.00,0.00,0.00,0.00),('21','224','3','43',1191,'17','1',1362496.04,1366065.96,3569.92,589036.80,0.00,0.00,0.00,0.00,0.00),('21','224','3','43',1192,'18','1',1352020.18,1355338.29,3318.11,547488.15,0.00,0.00,0.00,0.00,0.00),('21','224','6','43',1193,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','43',1194,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','43',1195,'25','1',1130705.99,1133136.54,2430.55,401040.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','43',1196,'26','1',1281604.63,1284750.14,3145.51,519009.15,0.00,0.00,0.00,0.00,0.00),('21','224','4','43',1197,'29','2',770217.40,770217.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','43',1198,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','43',1199,'31','2',714150.38,718874.70,4724.32,3307024.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','43',1200,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','43',1201,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','43',1202,'34','3',562473.97,563449.71,975.74,536657.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','43',1203,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','43',1204,'36','1',1674401.00,1678645.67,4244.67,700370.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','44',1205,'1','1',1403905.08,1408575.39,4670.31,770601.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','44',1206,'2','1',1554639.07,1560367.60,5728.53,945207.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','44',1207,'3','1',1134826.28,1141913.88,7087.60,1169454.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','44',1208,'4','1',863490.70,863490.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','44',1209,'5','1',1162264.00,1167075.00,4811.00,793815.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','44',1210,'6','1',1580366.18,1585658.43,5292.25,873221.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','44',1211,'7','1',1469695.31,1474506.75,4811.44,793887.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','44',1212,'8','1',1208431.98,1212644.33,4212.35,695037.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','44',1213,'9','1',1568452.14,1574635.60,6183.46,1020270.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','44',1214,'10','1',1742006.67,1742006.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','44',1215,'13','1',1401468.82,1407107.42,5638.60,930369.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','44',1216,'14','1',1499536.21,1499536.26,0.05,8.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','44',1217,'15','1',1476511.13,1476511.29,0.16,26.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','44',1218,'16','1',1427400.69,1432911.25,5510.56,909242.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','44',1219,'17','1',1366065.96,1368373.97,2308.01,380821.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','44',1220,'18','1',1355338.29,1356946.71,1608.42,265389.30,0.00,0.00,0.00,0.00,0.00),('21','224','6','44',1221,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','44',1222,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','44',1223,'25','1',1133136.54,1135051.08,1914.54,315899.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','44',1224,'26','1',1284750.14,1286316.16,1566.02,258393.30,0.00,0.00,0.00,0.00,0.00),('21','224','4','44',1225,'29','2',770217.40,773326.99,3109.59,2176713.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','44',1226,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','44',1227,'31','2',718874.70,721174.67,2299.97,1609979.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','44',1228,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','44',1229,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','44',1230,'34','3',563449.71,564451.76,1002.05,551127.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','44',1231,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','44',1232,'36','1',1678645.67,1683373.23,4727.56,780047.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','45',1233,'1','1',1408575.39,1412969.53,4394.14,725033.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','45',1234,'2','1',1560367.60,1564241.79,3874.19,639241.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','45',1235,'3','1',1141913.88,1147501.82,5587.94,922010.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','45',1236,'4','1',863490.70,863490.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','45',1237,'5','1',1167075.00,1170916.00,3841.00,633765.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','45',1238,'6','1',1585658.43,1589241.19,3582.76,591155.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','45',1239,'7','1',1474506.75,1477353.69,2846.94,469745.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','45',1240,'8','1',1212644.33,1216759.41,4115.08,678988.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','45',1241,'9','1',1574635.60,1580528.62,5893.02,972348.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','45',1242,'10','1',1742006.67,1742007.45,0.78,128.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','45',1243,'13','1',1407107.42,1413298.95,6191.53,1021602.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','45',1244,'14','1',1499536.26,1499536.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','45',1245,'15','1',1476511.29,1476511.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','45',1246,'16','1',1432911.25,1438927.70,6016.45,992714.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','45',1247,'17','1',1368373.97,1368373.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','45',1248,'18','1',1356946.71,1356946.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','45',1249,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','45',1250,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','45',1251,'25','1',1135051.08,1135051.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','45',1252,'26','1',1286316.16,1286316.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','45',1253,'29','2',773326.99,777094.48,3767.49,2637243.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','45',1254,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','45',1255,'31','2',721174.67,721174.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','45',1256,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','45',1257,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','45',1258,'34','3',564451.76,565340.77,889.01,488955.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','45',1259,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','45',1260,'36','1',1683373.23,1689210.46,5837.23,963142.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','46',1261,'1','1',1412969.53,1417180.58,4027.26,664497.90,0.00,0.00,183.79,0.00,0.00),('21','224','1','46',1262,'2','1',1564241.79,1570078.27,5836.48,963019.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','46',1263,'3','1',1147501.82,1154069.76,6567.94,1083710.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','46',1264,'4','1',863490.70,863490.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','46',1265,'5','1',1170916.00,1176617.00,5701.00,940665.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','46',1266,'6','1',1589241.19,1594680.16,5438.97,897430.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','46',1267,'7','1',1477353.69,1482482.70,5129.01,846286.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','46',1268,'8','1',1216759.41,1221459.06,4699.65,775442.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','46',1269,'9','1',1580528.62,1588694.19,8165.57,1347319.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','46',1270,'10','1',1742007.45,1742007.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','46',1271,'13','1',1413298.95,1420436.84,7137.89,1177751.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','46',1272,'14','1',1499536.26,1499536.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','46',1273,'15','1',1476511.29,1476511.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','46',1274,'16','1',1438927.70,1446088.94,7161.24,1181604.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','46',1275,'17','1',1368373.97,1368373.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','46',1276,'18','1',1356946.71,1356946.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','46',1277,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','46',1278,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','46',1279,'25','1',1135051.08,1135051.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','46',1280,'26','1',1286316.16,1286316.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','46',1281,'29','2',777094.48,780245.22,3150.74,2205518.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','46',1282,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','46',1283,'31','2',721174.67,725921.03,4736.36,3315452.00,0.00,0.00,10.00,0.00,0.00),('21','224','5','46',1284,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','46',1285,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','46',1286,'34','3',565340.77,566353.10,1012.33,556781.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','46',1287,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','46',1288,'36','1',1689210.46,1695500.92,6290.46,1037925.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','47',1289,'1','1',1417180.58,1417180.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','47',1290,'2','1',1570078.27,1570078.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','47',1291,'3','1',1154069.76,1154069.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','47',1292,'4','1',863490.70,863490.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','47',1293,'5','1',1176617.00,1176617.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','47',1294,'6','1',1594680.16,1601030.92,6350.76,1047875.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','47',1295,'7','1',1482482.70,1482482.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','47',1296,'8','1',1221459.06,1221459.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','47',1297,'9','1',1588694.19,1588694.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','47',1298,'10','1',1742007.45,1742007.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','47',1299,'13','1',1420436.84,1420436.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','47',1300,'14','1',1499536.26,1499536.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','47',1301,'15','1',1476511.29,1476511.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','47',1302,'16','1',1446088.94,1446088.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','47',1303,'17','1',1368373.97,1368373.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','47',1304,'18','1',1356946.71,1356946.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','47',1305,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','47',1306,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','47',1307,'25','1',1135051.08,1135051.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','47',1308,'26','1',1286316.16,1286316.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','47',1309,'29','2',780245.22,780245.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','47',1310,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','47',1311,'31','2',725921.03,735983.48,10062.45,7043715.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','47',1312,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','47',1313,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','47',1314,'34','3',566353.10,567110.21,757.11,416410.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','47',1315,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','47',1316,'36','1',1695500.92,1702155.20,6588.29,1087067.85,0.00,0.00,65.99,0.00,0.00),('21','224','1','48',1317,'1','1',1417180.58,1429026.53,11831.44,1952187.60,0.00,0.00,14.51,0.00,0.00),('21','224','1','48',1318,'2','1',1570078.27,1581845.49,11767.22,1941591.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','48',1319,'3','1',1154069.76,1171719.22,17649.46,2912160.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','48',1320,'4','1',863490.70,863490.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','48',1321,'5','1',1176617.00,1186882.00,10265.00,1693725.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','48',1322,'6','1',1601030.92,1607254.87,6223.95,1026951.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','48',1323,'7','1',1482482.70,1494772.07,12289.37,2027746.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','48',1324,'8','1',1221459.06,1231615.31,10156.25,1675781.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','48',1325,'9','1',1588694.19,1596136.46,7442.27,1227974.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','48',1326,'10','1',1742007.45,1746464.27,4456.82,735375.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','48',1327,'13','1',1420436.84,1430638.00,10201.16,1683191.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','48',1328,'14','1',1499536.26,1506920.80,7384.54,1218449.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','48',1329,'15','1',1476511.29,1484994.79,8483.50,1399777.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','48',1330,'16','1',1446088.94,1455170.31,9081.37,1498426.05,0.00,0.00,0.00,0.00,0.00),('21','224','3','48',1331,'17','1',1368373.97,1368373.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','48',1332,'18','1',1356946.71,1356946.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','48',1333,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','48',1334,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','48',1335,'25','1',1135051.08,1135051.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','48',1336,'26','1',1286316.16,1286316.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','48',1337,'29','2',780245.22,784745.22,4500.00,3150000.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','48',1338,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','48',1339,'31','2',735983.48,751621.67,15638.19,10946733.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','48',1340,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','48',1341,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','48',1342,'34','3',567110.21,568233.77,1123.56,617958.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','48',1343,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','48',1344,'36','1',1702155.20,1708139.37,5984.17,987388.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','49',1345,'1','1',1429026.53,1433143.66,4117.13,679326.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','49',1346,'2','1',1581845.49,1585953.23,4107.74,677777.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','49',1347,'3','1',1171719.22,1177741.55,6022.33,993684.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','49',1348,'4','1',863490.70,863490.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','49',1349,'5','1',1186882.00,1191342.00,4460.00,735900.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','49',1350,'6','1',1607254.87,1610432.91,3178.04,524376.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','49',1351,'7','1',1494772.07,1498464.60,3692.53,609267.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','49',1352,'8','1',1231615.31,1235656.56,4041.25,666806.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','49',1353,'9','1',1596136.46,1597835.16,1698.70,280285.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','49',1354,'10','1',1746464.27,1748089.53,1625.26,268167.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','49',1355,'13','1',1430638.00,1432053.61,1415.61,233575.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','49',1356,'14','1',1506920.80,1508547.99,1627.19,268486.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','49',1357,'15','1',1484994.79,1486567.33,1572.54,259469.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','49',1358,'16','1',1455170.31,1456792.50,1622.19,267661.35,0.00,0.00,0.00,0.00,0.00),('21','224','3','49',1359,'17','1',1368373.97,1368373.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','49',1360,'18','1',1356946.71,1356946.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','49',1361,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','49',1362,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','49',1363,'25','1',1135051.08,1135051.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','49',1364,'26','1',1286316.16,1286316.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','49',1365,'29','2',784745.22,785002.23,257.01,179907.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','49',1366,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','49',1367,'31','2',751621.67,751621.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','49',1368,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','49',1369,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','49',1370,'34','3',568233.77,570459.00,2225.23,1223876.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','49',1371,'35','1',1073532.72,1073532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','49',1372,'36','1',1708139.37,1709570.60,1431.23,236152.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','50',1373,'1','1',1433143.66,1436760.34,3616.68,596752.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','50',1374,'2','1',1585953.23,1591402.24,5449.01,899086.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','50',1375,'3','1',1177741.55,1182270.40,4528.85,747260.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','50',1376,'4','1',863490.70,863490.74,0.04,6.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','50',1377,'5','1',1191342.00,1195287.00,3945.00,650925.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','50',1378,'6','1',1610432.91,1614087.19,3654.28,602956.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','50',1379,'7','1',1498464.60,1499707.99,1243.39,205159.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','50',1380,'8','1',1235656.56,1239890.81,4234.25,698651.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','50',1381,'9','1',1597835.16,1601457.91,3622.75,597753.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','50',1382,'10','1',1748089.53,1751979.53,3890.00,641850.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','50',1383,'13','1',1432053.61,1436069.50,4015.89,662621.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','50',1384,'14','1',1508547.99,1512162.02,3614.03,596314.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','50',1385,'15','1',1486567.33,1489511.42,2944.09,485774.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','50',1386,'16','1',1456792.50,1489511.42,32718.92,5398621.80,0.00,0.00,0.00,0.00,0.00),('21','224','3','50',1387,'17','1',1368373.97,1369968.20,1594.23,263047.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','50',1388,'18','1',1356946.71,1358358.42,1411.71,232932.15,0.00,0.00,0.00,0.00,0.00),('21','224','6','50',1389,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','50',1390,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','50',1391,'25','1',1135051.08,1136955.45,1904.37,314221.05,0.00,0.00,0.00,0.00,0.00),('21','224','3','50',1392,'26','1',1286316.16,1288864.25,2548.09,420434.85,0.00,0.00,0.00,0.00,0.00),('21','224','4','50',1393,'29','2',785002.23,785002.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','50',1394,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','50',1395,'31','2',751621.67,757533.49,5911.82,4138274.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','50',1396,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','50',1397,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','50',1398,'34','3',570459.00,571633.88,1174.88,646184.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','50',1399,'35','1',1073532.72,1073533.68,0.96,158.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','50',1400,'36','1',1709570.60,1713367.00,3796.40,626406.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','51',1401,'1','1',1436760.34,1438497.40,1737.06,286614.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','51',1402,'2','1',1591402.24,1593076.00,1673.76,276170.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','51',1403,'3','1',1182270.40,1183722.21,1451.81,239548.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','51',1404,'4','1',863490.74,863490.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','51',1405,'5','1',1195287.00,1195742.00,455.00,75075.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','51',1406,'6','1',1614087.19,1616127.03,2039.84,336573.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','51',1407,'7','1',1499707.99,1501342.96,1634.97,269770.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','51',1408,'8','1',1239890.81,1240933.86,1043.05,172103.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','51',1409,'9','1',1601457.91,1604354.89,2896.98,478001.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','51',1410,'10','1',1751979.53,1754733.20,2753.67,454355.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','51',1411,'13','1',1436069.50,1438953.92,2884.42,475929.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','51',1412,'14','1',1512162.02,1515113.41,2951.39,486979.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','51',1413,'15','1',1489511.42,1491146.06,1634.64,269715.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','51',1414,'16','1',1489511.42,1489511.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','51',1415,'17','1',1369968.20,1372280.06,2311.86,381456.90,0.00,0.00,0.00,0.00,0.00),('21','224','3','51',1416,'18','1',1358358.42,1360384.12,2025.70,334240.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','51',1417,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','51',1418,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','51',1419,'25','1',1136955.45,1138349.83,1394.38,230072.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','51',1420,'26','1',1288864.25,1290698.42,1834.17,302638.05,0.00,0.00,0.00,0.00,0.00),('21','224','4','51',1421,'29','2',785002.23,785002.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','51',1422,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','51',1423,'31','2',757533.49,762798.30,5264.81,3685367.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','51',1424,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','51',1425,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','51',1426,'34','3',571633.88,573309.23,1675.35,921442.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','51',1427,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','51',1428,'36','1',1713367.00,1715312.21,1945.21,320959.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','52',1429,'1','1',1438497.40,1442996.03,4458.63,735673.95,0.00,0.00,40.00,0.00,0.00),('21','224','1','52',1430,'2','1',1593076.00,1597590.98,4514.98,744971.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','52',1431,'3','1',1183722.21,1189199.73,5477.52,903790.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','52',1432,'4','1',863490.74,863490.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','52',1433,'5','1',1195742.00,1198418.00,2676.00,441540.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','52',1434,'6','1',1616127.03,1621149.24,5022.21,828664.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','52',1435,'7','1',1501342.96,1506504.21,5161.25,851606.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','52',1436,'8','1',1240933.86,1245015.87,4082.01,673531.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','52',1437,'9','1',1604354.89,1609023.38,4668.49,770300.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','52',1438,'10','1',1754733.20,1759424.52,4691.32,774067.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','52',1439,'13','1',1438953.92,1443008.07,4054.15,668934.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','52',1440,'14','1',1515113.41,1519809.03,4695.62,774777.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','52',1441,'15','1',1491146.06,1495339.77,4193.71,691962.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','52',1442,'16','1',1489511.42,1489511.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','52',1443,'17','1',1372280.06,1373327.34,1047.28,172801.20,0.00,0.00,0.00,0.00,0.00),('21','224','3','52',1444,'18','1',1360384.12,1361469.97,1085.85,179165.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','52',1445,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','52',1446,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','52',1447,'25','1',1138349.83,1139781.63,1431.80,236247.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','52',1448,'26','1',1290698.42,1291882.01,1183.59,195292.35,0.00,0.00,0.00,0.00,0.00),('21','224','4','52',1449,'29','2',785002.23,785002.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','52',1450,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','52',1451,'31','2',762798.30,765212.05,2413.75,1689625.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','52',1452,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','52',1453,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','52',1454,'34','3',573309.23,574681.38,1372.15,754682.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','52',1455,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','52',1456,'36','1',1715312.21,1718576.60,3264.39,538624.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','53',1457,'1','1',1442996.03,1446243.47,3247.44,535827.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','53',1458,'2','1',1597590.98,1601802.27,4211.29,694862.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','53',1459,'3','1',1189199.73,1195198.82,5999.09,989849.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','53',1460,'4','1',863490.74,863491.40,0.66,108.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','53',1461,'5','1',1198418.00,1202394.00,3976.00,656040.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','53',1462,'6','1',1621149.24,1625260.61,4111.37,678376.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','53',1463,'7','1',1506504.21,1511035.40,4531.19,747646.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','53',1464,'8','1',1245015.87,1248855.36,3839.49,633515.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','53',1465,'9','1',1609023.38,1610614.96,1591.58,262610.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','53',1466,'10','1',1759424.52,1762546.40,3121.88,515110.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','53',1467,'13','1',1443008.07,1445430.66,2422.59,399727.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','53',1468,'14','1',1519809.03,1522009.42,2200.39,363064.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','53',1469,'15','1',1495339.77,1497048.59,1708.82,281955.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','53',1470,'16','1',1489511.42,1489511.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','53',1471,'17','1',1373327.34,1374688.00,1360.66,224508.90,0.00,0.00,0.00,0.00,0.00),('21','224','3','53',1472,'18','1',1361469.97,1364476.64,3006.67,496100.55,0.00,0.00,0.00,0.00,0.00),('21','224','6','53',1473,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','53',1474,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','53',1475,'25','1',1139781.63,1142147.57,2365.94,390380.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','53',1476,'26','1',1291882.01,1295090.50,3208.49,529400.85,0.00,0.00,0.00,0.00,0.00),('21','224','4','53',1477,'29','2',785002.23,785002.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','53',1478,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','53',1479,'31','2',765212.05,768132.64,2920.59,2044413.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','53',1480,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','53',1481,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','53',1482,'34','3',574681.38,575948.58,1267.20,696960.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','53',1483,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','53',1484,'36','1',1718576.60,1720834.64,2258.04,372576.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','54',1485,'1','1',1446243.47,1448356.01,2112.54,348569.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','54',1486,'2','1',1601802.27,1603919.60,2117.33,349359.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','54',1487,'3','1',1195198.82,1197224.78,2025.96,334283.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','54',1488,'4','1',863491.40,863491.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','54',1489,'5','1',1202394.00,1204493.00,2099.00,346335.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','54',1490,'6','1',1625260.61,1627645.51,2384.90,393508.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','54',1491,'7','1',1511035.40,1513321.97,2286.57,377284.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','54',1492,'8','1',1248855.36,1250919.14,2063.78,340523.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','54',1493,'9','1',1610614.96,1612524.08,1909.12,315004.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','54',1494,'10','1',1762546.40,1764549.74,2003.34,330551.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','54',1495,'13','1',1445430.66,1446812.92,1382.26,228072.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','54',1496,'14','1',1522009.42,1522918.14,908.72,149938.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','54',1497,'15','1',1497048.59,1498003.22,954.63,157513.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','54',1498,'16','1',1489511.42,1489511.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','54',1499,'17','1',1374688.00,1377361.33,2673.33,441099.45,0.00,0.00,0.00,0.00,0.00),('21','224','3','54',1500,'18','1',1364476.64,1367757.74,3281.10,541381.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','54',1501,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','54',1502,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','54',1503,'25','1',1142147.57,1145312.32,3164.75,522183.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','54',1504,'26','1',1295090.50,1298445.35,3354.85,553550.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','54',1505,'29','2',785002.23,785002.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','54',1506,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','54',1507,'31','2',768132.64,772649.52,4516.88,3161816.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','54',1508,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','54',1509,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','54',1510,'34','3',575948.58,578052.27,2103.69,1157029.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','54',1511,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','54',1512,'36','1',1720834.64,1721954.75,1120.11,184818.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','55',1513,'1','1',1448356.01,1452164.55,3808.54,628409.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','55',1514,'2','1',1603919.60,1609278.85,5359.25,884276.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','55',1515,'3','1',1197224.78,1203355.32,6130.54,1011539.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','55',1516,'4','1',863491.40,863491.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','55',1517,'5','1',1204493.00,1208250.00,3757.00,619905.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','55',1518,'6','1',1627645.51,1631401.19,3755.68,619687.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','55',1519,'7','1',1513321.97,1517882.95,4560.98,752561.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','55',1520,'8','1',1250919.14,1253551.28,2632.14,434303.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','55',1521,'9','1',1612524.08,1615757.15,3233.07,533456.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','55',1522,'10','1',1764549.74,1768114.08,3564.34,588116.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','55',1523,'13','1',1446812.92,1451645.38,4832.46,797355.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','55',1524,'14','1',1522918.14,1526220.27,3302.13,544851.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','55',1525,'15','1',1498003.22,1501459.13,3455.91,570225.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','55',1526,'16','1',1489511.42,1489511.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','55',1527,'17','1',1377361.33,1379375.65,2014.32,332362.80,0.00,0.00,0.00,0.00,0.00),('21','224','3','55',1528,'18','1',1367757.74,1370697.06,2939.32,484987.80,0.00,0.00,0.00,0.00,0.00),('21','224','6','55',1529,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','55',1530,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','55',1531,'25','1',1145312.32,1147595.02,2282.70,376645.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','55',1532,'26','1',1298445.35,1300925.29,2479.94,409190.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','55',1533,'29','2',785002.23,785002.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','55',1534,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','55',1535,'31','2',772649.52,775901.03,3251.51,2276057.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','55',1536,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','55',1537,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','55',1538,'34','3',578052.27,580291.99,2239.72,1231846.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','55',1539,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','55',1540,'36','1',1721954.75,1726808.20,4853.45,800819.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','56',1541,'1','1',1452164.55,1459021.00,6489.76,1070810.40,0.00,0.00,366.69,0.00,0.00),('21','224','1','56',1542,'2','1',1609278.85,1609279.36,0.51,84.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','56',1543,'3','1',1203355.32,1208779.84,5424.52,895045.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','56',1544,'4','1',863491.40,863492.03,0.63,103.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','56',1545,'5','1',1208250.00,1212626.00,4376.00,722040.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','56',1546,'6','1',1631401.19,1636663.74,5262.55,868320.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','56',1547,'7','1',1517882.95,1523922.95,6040.00,996600.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','56',1548,'8','1',1253551.28,1253552.00,0.72,118.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','56',1549,'9','1',1615757.15,1619998.39,4241.24,699804.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','56',1550,'10','1',1768114.08,1774362.65,6248.57,1031014.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','56',1551,'13','1',1451645.38,1459780.58,8135.20,1342308.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','56',1552,'14','1',1526220.27,1526220.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','56',1553,'15','1',1501459.13,1501459.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','56',1554,'16','1',1489511.42,1489511.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','56',1555,'17','1',1379375.65,1384390.05,5014.40,827376.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','56',1556,'18','1',1370697.06,1377752.20,7055.14,1164098.10,0.00,0.00,0.00,0.00,0.00),('21','224','6','56',1557,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','56',1558,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','56',1559,'25','1',1147595.02,1152026.52,4431.50,731197.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','56',1560,'26','1',1300925.29,1306989.33,6064.04,1000566.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','56',1561,'29','2',785002.23,785002.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','56',1562,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','56',1563,'31','2',775901.03,780388.64,4397.19,3078033.00,0.00,0.00,90.42,0.00,0.00),('21','224','5','56',1564,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','56',1565,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','56',1566,'34','3',580291.99,582285.15,1972.78,1085029.00,0.00,0.00,20.38,0.00,0.00),('21','224','2','56',1567,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','56',1568,'36','1',1726808.20,1732692.46,5884.26,970902.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','57',1569,'1','1',1459021.00,1466468.57,7447.57,1228849.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','57',1570,'2','1',1609279.36,1609279.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','57',1571,'3','1',1208779.84,1213737.27,4957.43,817975.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','57',1572,'4','1',863492.03,863492.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','57',1573,'5','1',1212626.00,1219676.00,7050.00,1163250.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','57',1574,'6','1',1636663.74,1638950.16,2286.42,377259.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','57',1575,'7','1',1523922.95,1530519.61,6596.66,1088448.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','57',1576,'8','1',1253552.00,1253552.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','57',1577,'9','1',1619998.39,1620108.91,110.52,18235.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','57',1578,'10','1',1774362.65,1782570.00,8207.35,1354212.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','57',1579,'13','1',1459780.58,1467499.98,7719.40,1273701.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','57',1580,'14','1',1526220.27,1526220.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','57',1581,'15','1',1501459.13,1501459.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','57',1582,'16','1',1489511.42,1489511.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','57',1583,'17','1',1384390.05,1388338.03,3947.98,651416.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','57',1584,'18','1',1377752.20,1382694.43,4942.23,815467.95,0.00,0.00,0.00,0.00,0.00),('21','224','6','57',1585,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','57',1586,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','57',1587,'25','1',1152026.52,1154657.28,2630.76,434075.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','57',1588,'26','1',1306989.33,1311230.66,4241.33,699819.45,0.00,0.00,0.00,0.00,0.00),('21','224','4','57',1589,'29','2',785002.23,790445.58,5443.35,3810345.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','57',1590,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','57',1591,'31','2',780388.64,781964.55,1575.91,1103137.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','57',1592,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','57',1593,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','57',1594,'34','3',582285.15,584746.58,2461.43,1353786.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','57',1595,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','57',1596,'36','1',1732692.46,1738987.33,6294.87,1038653.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','58',1597,'1','1',1466468.57,1473057.14,6425.04,1060131.60,0.00,0.00,163.53,0.00,0.00),('21','224','1','58',1598,'2','1',1609279.36,1609279.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','58',1599,'3','1',1213737.27,1218550.39,4813.12,794164.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','58',1600,'4','1',863492.03,863492.49,0.46,75.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','58',1601,'5','1',1219676.00,1225320.00,5644.00,931260.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','58',1602,'6','1',1638950.16,1641117.39,2167.23,357592.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','58',1603,'7','1',1530519.61,1535321.86,4802.25,792371.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','58',1604,'8','1',1253552.00,1253552.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','58',1605,'9','1',1620108.91,1622703.34,2594.43,428080.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','58',1606,'10','1',1782570.00,1785923.67,3353.67,553355.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','58',1607,'13','1',1467499.98,1472322.66,4822.68,795742.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','58',1608,'14','1',1526220.27,1526220.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','58',1609,'15','1',1501459.13,1501460.40,1.27,209.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','58',1610,'16','1',1489511.42,1494058.11,4546.69,750203.85,0.00,0.00,0.00,0.00,0.00),('21','224','3','58',1611,'17','1',1388338.03,1395772.37,7434.34,1226666.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','58',1612,'18','1',1382694.43,1390484.18,7789.75,1285308.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','58',1613,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','58',1614,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','58',1615,'25','1',1154657.28,1160923.25,6265.97,1033885.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','58',1616,'26','1',1311230.66,1319142.81,7912.15,1305504.75,0.00,0.00,0.00,0.00,0.00),('21','224','4','58',1617,'29','2',790445.58,796266.74,5821.16,4074812.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','58',1618,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','58',1619,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','58',1620,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','58',1621,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','58',1622,'34','3',584746.58,586455.71,1709.13,1110934.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','58',1623,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','58',1624,'36','1',1738987.33,1743048.76,4061.43,670135.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','59',1625,'1','1',1473057.14,1473057.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','59',1626,'2','1',1609279.36,1609279.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','59',1627,'3','1',1218550.39,1229788.80,11238.41,1854337.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','59',1628,'4','1',863492.49,863492.89,0.40,66.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','59',1629,'5','1',1225320.00,1232718.00,7398.00,1220670.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','59',1630,'6','1',1641117.39,1645336.36,4218.97,696130.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','59',1631,'7','1',1535321.86,1541978.22,6656.36,1098299.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','59',1632,'8','1',1253552.00,1256445.74,2893.74,477467.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','59',1633,'9','1',1622703.34,1625196.16,2492.82,411315.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','59',1634,'10','1',1785923.67,1794846.58,8922.91,1472280.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','59',1635,'13','1',1472322.66,1480842.13,8519.47,1405712.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','59',1636,'14','1',1526220.27,1526220.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','59',1637,'15','1',1501460.40,1504851.44,3391.04,559521.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','59',1638,'16','1',1494058.11,1503588.56,9530.45,1572524.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','59',1639,'17','1',1395772.37,1400564.82,4792.45,790754.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','59',1640,'18','1',1390484.18,1395816.73,5332.55,879870.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','59',1641,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','59',1642,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','59',1643,'25','1',1160923.25,1160923.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','59',1644,'26','1',1319142.81,1324460.26,5317.45,877379.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','59',1645,'29','2',796266.74,800285.88,4019.14,2813398.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','59',1646,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','59',1647,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','59',1648,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','59',1649,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','59',1650,'34','3',586455.71,588126.16,1670.45,1085792.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','59',1651,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','59',1652,'36','1',1743048.76,1752359.77,9311.01,1536316.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','60',1653,'1','1',1473057.14,1473057.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','60',1654,'2','1',1609279.36,1609279.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','60',1655,'3','1',1229788.80,1231868.02,2079.22,343071.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','60',1656,'4','1',863492.89,863492.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','60',1657,'5','1',1232718.00,1233903.00,1185.00,195525.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','60',1658,'6','1',1645336.36,1646245.83,909.47,150062.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','60',1659,'7','1',1541978.22,1543140.10,1161.88,191710.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','60',1660,'8','1',1256445.74,1257807.57,1361.83,224701.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','60',1661,'9','1',1625196.16,1625196.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','60',1662,'10','1',1794846.58,1794846.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','60',1663,'13','1',1480842.13,1480842.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','60',1664,'14','1',1526220.27,1526220.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','60',1665,'15','1',1504851.44,1504851.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','60',1666,'16','1',1503588.56,1503588.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','60',1667,'17','1',1400564.82,1400564.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','60',1668,'18','1',1395816.73,1395816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','60',1669,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','60',1670,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','60',1671,'25','1',1160923.25,1160923.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','60',1672,'26','1',1324460.26,1324460.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','60',1673,'29','2',800285.88,805433.69,5147.81,3603467.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','60',1674,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','60',1675,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','60',1676,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','60',1677,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','60',1678,'34','3',588126.16,588998.23,872.07,566845.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','60',1679,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','60',1680,'36','1',1752359.77,1752359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','61',1681,'1','1',1473057.14,1483191.70,10134.56,1672202.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','61',1682,'2','1',1609279.36,1609279.78,0.42,69.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','61',1683,'3','1',1231868.02,1243650.31,11782.29,1944077.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','61',1684,'4','1',863492.89,863492.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','61',1685,'5','1',1233903.00,1242389.00,8486.00,1400190.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','61',1686,'6','1',1646245.83,1654727.78,8481.95,1399521.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','61',1687,'7','1',1543140.10,1550254.86,7114.76,1173935.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','61',1688,'8','1',1257807.57,1267138.61,9331.04,1539621.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','61',1689,'9','1',1625196.16,1625204.09,7.93,1308.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','61',1690,'10','1',1794846.58,1797636.28,2789.70,460300.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','61',1691,'13','1',1480842.13,1483348.21,2506.08,413503.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','61',1692,'14','1',1526220.27,1526220.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','61',1693,'15','1',1504851.44,1504851.50,0.06,9.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','61',1694,'16','1',1503588.56,1505619.53,2030.97,335110.05,0.00,0.00,0.00,0.00,0.00),('21','224','3','61',1695,'17','1',1400564.82,1400564.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','61',1696,'18','1',1395816.73,1395816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','61',1697,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','61',1698,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','61',1699,'25','1',1160923.25,1160923.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','61',1700,'26','1',1324460.26,1324460.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','61',1701,'29','2',805433.69,810442.68,5008.99,3506293.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','61',1702,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','61',1703,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','61',1704,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','61',1705,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','61',1706,'34','3',588998.23,590670.35,1672.12,1086878.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','61',1707,'35','1',1073533.68,1073533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','61',1708,'36','1',1752359.77,1754957.14,2597.37,428566.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','62',1709,'1','1',1483191.70,1486377.84,3186.14,525713.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','62',1710,'2','1',1609279.78,1609279.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','62',1711,'3','1',1243650.31,1247235.78,3585.47,591602.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','62',1712,'4','1',863492.89,863492.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','62',1713,'5','1',1242389.00,1244570.00,2181.00,359865.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','62',1714,'6','1',1654727.78,1657539.29,2811.51,463899.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','62',1715,'7','1',1550254.86,1552851.21,2596.35,428397.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','62',1716,'8','1',1267138.61,1269472.36,2333.75,385068.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','62',1717,'9','1',1625204.09,1625204.15,0.06,9.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','62',1718,'10','1',1797636.28,1804676.36,7040.08,1161613.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','62',1719,'13','1',1483348.21,1489280.09,5931.88,978760.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','62',1720,'14','1',1526220.27,1531158.80,4938.53,814857.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','62',1721,'15','1',1504851.50,1506867.27,2015.77,332602.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','62',1722,'16','1',1505619.53,1512034.91,6415.38,1058537.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','62',1723,'17','1',1400564.82,1400564.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','62',1724,'18','1',1395816.73,1395816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','62',1725,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','62',1726,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','62',1727,'25','1',1160923.25,1160923.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','62',1728,'26','1',1324460.26,1324460.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','62',1729,'29','2',810442.68,819124.67,8681.99,6077393.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','62',1730,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','62',1731,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','62',1732,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','62',1733,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','62',1734,'34','3',590670.35,591596.66,926.31,602101.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','62',1735,'35','1',1073533.68,1073534.40,0.72,118.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','62',1736,'36','1',1754957.14,1761421.08,6463.94,1066550.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','63',1737,'1','1',1486377.84,1494137.48,7729.64,1275390.60,0.00,0.00,30.00,0.00,0.00),('21','224','1','63',1738,'2','1',1609279.78,1616024.70,6744.92,1112911.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','63',1739,'3','1',1247235.78,1256831.79,9596.01,1583341.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','63',1740,'4','1',863492.89,863492.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','63',1741,'5','1',1244570.00,1250969.00,6399.00,1055835.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','63',1742,'6','1',1657539.29,1666131.60,8592.31,1417731.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','63',1743,'7','1',1552851.21,1558886.20,6034.99,995773.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','63',1744,'8','1',1269472.36,1276086.44,6614.08,1091323.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','63',1745,'9','1',1625204.15,1625204.28,0.13,21.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','63',1746,'10','1',1804676.36,1811323.56,6647.20,1096788.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','63',1747,'13','1',1489280.09,1493814.41,4534.32,748162.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','63',1748,'14','1',1531158.80,1536396.01,5237.21,864139.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','63',1749,'15','1',1506867.27,1512208.72,5341.45,881339.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','63',1750,'16','1',1512034.91,1516231.44,4196.53,692427.45,0.00,0.00,0.00,0.00,0.00),('21','224','3','63',1751,'17','1',1400564.82,1400564.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','63',1752,'18','1',1395816.73,1395816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','63',1753,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','63',1754,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','63',1755,'25','1',1160923.25,1160923.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','63',1756,'26','1',1324460.26,1324460.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','63',1757,'29','2',819124.67,825635.87,6511.20,4557840.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','63',1758,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','63',1759,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','63',1760,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','63',1761,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','63',1762,'34','3',591596.66,592571.37,974.71,633561.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','63',1763,'35','1',1073534.40,1073534.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','63',1764,'36','1',1761421.08,1767963.91,6542.83,1079566.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','64',1765,'1','1',1494137.48,1499076.93,4939.45,815009.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','64',1766,'2','1',1616024.70,1620485.86,4461.16,736091.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','64',1767,'3','1',1256831.79,1265337.49,8505.70,1403440.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','64',1768,'4','1',863492.89,863492.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','64',1769,'5','1',1250969.00,1256189.00,5220.00,861300.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','64',1770,'6','1',1666131.60,1673110.39,6978.79,1151500.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','64',1771,'7','1',1558886.20,1564789.85,5903.65,974102.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','64',1772,'8','1',1276086.44,1282062.15,5975.71,985992.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','64',1773,'9','1',1625204.28,1625204.42,0.14,23.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','64',1774,'10','1',1811323.56,1811360.90,37.34,6161.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','64',1775,'13','1',1493814.41,1503672.02,9857.61,1626505.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','64',1776,'14','1',1536396.01,1536428.57,32.56,5372.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','64',1777,'15','1',1512208.72,1512228.70,19.98,3296.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','64',1778,'16','1',1516231.44,1524631.89,8400.45,1386074.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','64',1779,'17','1',1400564.82,1400564.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','64',1780,'18','1',1395816.73,1395816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','64',1781,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','64',1782,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','64',1783,'25','1',1160923.25,1160923.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','64',1784,'26','1',1324460.26,1324460.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','64',1785,'29','2',825635.87,834535.25,8899.38,6229566.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','64',1786,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','64',1787,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','64',1788,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','64',1789,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','64',1790,'34','3',592571.37,592571.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','64',1791,'35','1',1073534.40,1073534.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','64',1792,'36','1',1767963.91,1778606.11,10642.20,1755963.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','65',1793,'1','1',1499076.93,1505956.91,6594.38,1088072.70,0.00,0.00,285.60,0.00,0.00),('21','224','1','65',1794,'2','1',1620485.86,1628174.23,7688.37,1268581.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','65',1795,'3','1',1265337.49,1274151.07,8813.58,1454240.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','65',1796,'4','1',863492.89,863493.49,0.60,99.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','65',1797,'5','1',1256189.00,1260663.00,4474.00,738210.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','65',1798,'6','1',1673110.39,1679740.57,6630.18,1093979.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','65',1799,'7','1',1564789.85,1567830.47,3040.62,501702.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','65',1800,'8','1',1282062.15,1288712.81,6650.66,1097358.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','65',1801,'9','1',1625204.42,1625204.89,0.47,77.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','65',1802,'10','1',1811360.90,1811361.18,0.28,46.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','65',1803,'13','1',1503672.02,1511570.55,7898.53,1303257.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','65',1804,'14','1',1536428.57,1536428.91,0.34,56.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','65',1805,'15','1',1512228.70,1512228.79,0.09,14.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','65',1806,'16','1',1524631.89,1531642.77,7010.88,1156795.20,0.00,0.00,0.00,0.00,0.00),('21','224','3','65',1807,'17','1',1400564.82,1401609.67,1044.85,172400.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','65',1808,'18','1',1395816.73,1405527.69,9710.96,1602308.40,0.00,0.00,0.00,0.00,0.00),('21','224','6','65',1809,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','65',1810,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','65',1811,'25','1',1160923.25,1168889.81,7966.56,1314482.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','65',1812,'26','1',1324460.26,1334129.91,9669.65,1595492.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','65',1813,'29','2',834535.25,842915.22,8359.53,6018861.60,0.00,0.00,20.44,0.00,0.00),('21','224','4','65',1814,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','65',1815,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','65',1816,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','65',1817,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','65',1818,'34','3',592571.37,592779.55,187.76,122044.00,0.00,0.00,20.42,0.00,0.00),('21','224','2','65',1819,'35','1',1073534.40,1073534.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','65',1820,'36','1',1778606.11,1786468.00,7861.89,1297211.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','66',1821,'1','1',1505956.91,1510642.55,-3059.36,-504794.40,0.00,0.00,7745.00,0.00,0.00),('21','224','1','66',1822,'2','1',1628174.23,1634571.77,6397.54,1055594.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','66',1823,'3','1',1274151.07,1281909.62,7758.55,1280160.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','66',1824,'4','1',863493.49,863493.87,0.38,62.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','66',1825,'5','1',1260663.00,1260663.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','66',1826,'6','1',1679740.57,1686975.79,7235.22,1193811.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','66',1827,'7','1',1567830.47,1567837.66,7.19,1186.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','66',1828,'8','1',1288712.81,1297052.47,8339.66,1376043.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','66',1829,'9','1',1625204.89,1625204.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','66',1830,'10','1',1811361.18,1811361.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','66',1831,'13','1',1511570.55,1518653.61,7083.06,1168704.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','66',1832,'14','1',1536428.91,1536428.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','66',1833,'15','1',1512228.79,1512228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','66',1834,'16','1',1531642.77,1537619.28,5976.51,986124.15,0.00,0.00,0.00,0.00,0.00),('21','224','3','66',1835,'17','1',1401609.67,1407152.91,5543.24,914634.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','66',1836,'18','1',1405527.69,1412042.62,6514.93,1074963.45,0.00,0.00,0.00,0.00,0.00),('21','224','6','66',1837,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','66',1838,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','66',1839,'25','1',1168889.81,1174740.45,5850.64,965355.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','66',1840,'26','1',1334129.91,1340158.30,6028.39,994684.35,0.00,0.00,0.00,0.00,0.00),('21','224','4','66',1841,'29','2',842915.22,847872.56,4957.34,3569284.80,0.00,0.00,0.00,0.00,0.00),('21','224','4','66',1842,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','66',1843,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','66',1844,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','66',1845,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','66',1846,'34','3',592779.55,593812.36,1032.81,671326.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','66',1847,'35','1',1073534.40,1073534.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','66',1848,'36','1',1786468.00,1792219.78,5751.78,949043.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','67',1849,'1','1',1510642.55,1516073.44,5430.89,896096.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','67',1850,'2','1',1634571.77,1639700.12,5128.35,846177.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','67',1851,'3','1',1281909.62,1285973.51,4063.89,670541.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','67',1852,'4','1',863493.87,863493.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','67',1853,'5','1',1260663.00,1260663.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','67',1854,'6','1',1686975.79,1693384.70,6408.91,1057470.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','67',1855,'7','1',1567837.66,1567838.05,0.39,64.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','67',1856,'8','1',1297052.47,1302993.47,5941.00,980265.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','67',1857,'9','1',1625204.89,1625204.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','67',1858,'10','1',1811361.18,1811361.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','67',1859,'13','1',1518653.61,1528097.94,9444.33,1558314.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','67',1860,'14','1',1536428.91,1536428.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','67',1861,'15','1',1512228.79,1512228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','67',1862,'16','1',1537619.28,1545804.48,8185.20,1350558.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','67',1863,'17','1',1407152.91,1412242.11,5089.20,839718.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','67',1864,'18','1',1412042.62,1421801.19,9758.57,1610164.05,0.00,0.00,0.00,0.00,0.00),('21','224','6','67',1865,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','67',1866,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','67',1867,'25','1',1174740.45,1181682.88,6942.43,1145500.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','67',1868,'26','1',1340158.30,1346230.35,6072.05,1001888.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','67',1869,'29','2',847872.56,860643.79,12771.23,9195285.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','67',1870,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','67',1871,'31','2',781964.55,781964.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','67',1872,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','67',1873,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','67',1874,'34','3',593812.36,595220.54,1408.18,915317.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','67',1875,'35','1',1073534.40,1073534.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','67',1876,'36','1',1792219.78,1799172.98,6953.20,1147278.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','68',1877,'1','1',1516073.44,1521748.84,5675.40,936441.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','68',1878,'2','1',1639700.12,1646058.91,6358.79,1049200.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','68',1879,'3','1',1285973.51,1292980.52,7007.01,1156156.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','68',1880,'4','1',863493.87,863494.31,0.44,72.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','68',1881,'5','1',1260663.00,1260664.00,1.00,165.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','68',1882,'6','1',1693384.70,1700367.32,6982.62,1152132.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','68',1883,'7','1',1567838.05,1567838.40,0.35,57.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','68',1884,'8','1',1302993.47,1310454.02,7460.55,1230990.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','68',1885,'9','1',1625204.89,1625204.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','68',1886,'10','1',1811361.18,1811361.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','68',1887,'13','1',1528097.94,1536026.67,7928.73,1308240.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','68',1888,'14','1',1536428.91,1536428.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','68',1889,'15','1',1512228.79,1512229.59,0.80,132.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','68',1890,'16','1',1545804.48,1551526.11,5721.63,944068.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','68',1891,'17','1',1412242.11,1416041.50,3799.39,626899.35,0.00,0.00,0.00,0.00,0.00),('21','224','3','68',1892,'18','1',1421801.19,1430778.01,8976.82,1481175.30,0.00,0.00,0.00,0.00,0.00),('21','224','6','68',1893,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','68',1894,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','68',1895,'25','1',1181682.88,1189401.64,7718.76,1273595.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','68',1896,'26','1',1346230.35,1351874.25,5643.90,931243.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','68',1897,'29','2',860643.79,864578.14,3934.35,2832732.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','68',1898,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','68',1899,'31','2',781964.55,786686.14,4721.59,3399544.80,0.00,0.00,0.00,0.00,0.00),('21','224','5','68',1900,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','68',1901,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','68',1902,'34','3',595220.54,596452.22,1231.68,800592.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','68',1903,'35','1',1073534.40,1073534.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','68',1904,'36','1',1799172.98,1804422.18,5249.20,866118.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','69',1905,'1','1',1521748.84,1527245.33,5496.49,906920.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','69',1906,'2','1',1646058.91,1652569.37,6510.46,1074225.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','69',1907,'3','1',1292980.52,1298760.02,5779.50,953617.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','69',1908,'4','1',863494.31,863494.93,0.62,102.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','69',1909,'5','1',1260664.00,1260664.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','69',1910,'6','1',1700367.32,1707960.43,7593.11,1252863.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','69',1911,'7','1',1567838.40,1567838.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','69',1912,'8','1',1310454.02,1310454.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','69',1913,'9','1',1625204.89,1625204.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','69',1914,'10','1',1811361.18,1811361.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','69',1915,'13','1',1536026.67,1543864.99,7838.32,1293322.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','69',1916,'14','1',1536428.91,1536428.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','69',1917,'15','1',1512229.59,1512229.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','69',1918,'16','1',1551526.11,1559294.72,7768.61,1281820.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','69',1919,'17','1',1416041.50,1416041.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','69',1920,'18','1',1430778.01,1438742.72,7964.71,1314177.15,0.00,0.00,0.00,0.00,0.00),('21','224','6','69',1921,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','69',1922,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','69',1923,'25','1',1189401.64,1194620.66,5219.02,861138.30,0.00,0.00,0.00,0.00,0.00),('21','224','3','69',1924,'26','1',1351874.25,1357764.46,5890.21,971884.65,0.00,0.00,0.00,0.00,0.00),('21','224','4','69',1925,'29','2',864578.14,864578.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','69',1926,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','69',1927,'31','2',786686.14,799301.02,12614.88,9082713.60,0.00,0.00,0.00,0.00,0.00),('21','224','5','69',1928,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','69',1929,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','69',1930,'34','3',596452.22,597544.19,1091.97,709780.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','69',1931,'35','1',1073534.40,1073534.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','69',1932,'36','1',1804422.18,1811179.42,6757.24,1114944.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','70',1933,'1','1',1527245.33,1531911.82,4421.29,729512.85,0.00,0.00,245.20,0.00,0.00),('21','224','1','70',1934,'2','1',1652569.37,1652569.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','70',1935,'3','1',1298760.02,1305835.09,7075.07,1167386.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','70',1936,'4','1',863494.93,863494.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','70',1937,'5','1',1260664.00,1260665.00,1.00,165.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','70',1938,'6','1',1707960.43,1714298.06,6337.63,1045708.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','70',1939,'7','1',1567838.40,1567838.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','70',1940,'8','1',1310454.02,1325685.28,15231.26,2513157.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','70',1941,'9','1',1625204.89,1625204.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','70',1942,'10','1',1811361.18,1811361.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','70',1943,'13','1',1543864.99,1551731.46,7866.47,1297967.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','70',1944,'14','1',1536428.91,1536428.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','70',1945,'15','1',1512229.59,1512229.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','70',1946,'16','1',1559294.72,1566209.95,6915.23,1141012.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','70',1947,'17','1',1416041.50,1421824.97,5783.47,954272.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','70',1948,'18','1',1438742.72,1445668.02,6925.30,1142674.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','70',1949,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','70',1950,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','70',1951,'25','1',1194620.66,1199928.60,5307.94,875809.44,0.00,0.00,0.00,0.00,0.00),('21','224','3','70',1952,'26','1',1357764.46,1364404.92,6640.46,1095675.90,0.00,0.00,0.00,0.00,0.00),('21','224','4','70',1953,'29','2',864578.14,864578.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','70',1954,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','70',1955,'31','2',799301.02,805999.38,6677.92,4808102.40,0.00,0.00,20.44,0.00,0.00),('21','224','5','70',1956,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','70',1957,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','70',1958,'34','3',597544.19,598423.92,859.27,558525.50,0.00,0.00,20.46,0.00,0.00),('21','224','2','70',1959,'35','1',1073534.40,1073534.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','70',1960,'36','1',1811179.42,1816639.11,5459.69,900848.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','71',1961,'1','1',1531911.82,1536939.33,4986.25,822731.25,0.00,0.00,41.26,0.00,0.00),('21','224','1','71',1962,'2','1',1652569.37,1662696.37,10127.00,1670955.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','71',1963,'3','1',1305835.09,1310677.52,4842.43,799000.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','71',1964,'4','1',863494.93,863495.38,0.45,74.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','71',1965,'5','1',1260665.00,1261805.00,1140.00,188100.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','71',1966,'6','1',1714298.06,1719301.36,5003.30,825544.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','71',1967,'7','1',1567838.40,1567838.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','71',1968,'8','1',1325685.28,1331884.06,6198.78,1022798.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','71',1969,'9','1',1625204.89,1627006.08,1801.19,297196.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','71',1970,'10','1',1811361.18,1814604.39,3243.21,535129.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','71',1971,'13','1',1551731.46,1558865.67,7134.21,1177144.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','71',1972,'14','1',1536428.91,1536453.46,24.55,4050.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','71',1973,'15','1',1512229.59,1512229.64,0.05,8.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','71',1974,'16','1',1566209.95,1572874.00,6664.05,1099568.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','71',1975,'17','1',1421824.97,1428837.93,7012.96,1157138.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','71',1976,'18','1',1445668.02,1450104.80,4436.78,732068.70,0.00,0.00,0.00,0.00,0.00),('21','224','6','71',1977,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','71',1978,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','71',1979,'25','1',1199928.60,1206225.95,6297.35,1039062.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','71',1980,'26','1',1364404.92,1370517.77,6112.85,1008620.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','71',1981,'29','2',864578.14,864578.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','71',1982,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','71',1983,'31','2',805999.38,814960.61,8961.23,6452085.60,0.00,0.00,0.00,0.00,0.00),('21','224','5','71',1984,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','71',1985,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','71',1986,'34','3',598423.92,599390.27,966.35,628127.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','71',1987,'35','1',1073534.40,1073534.65,0.25,41.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','71',1988,'36','1',1816639.11,1823177.15,6538.04,1078776.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','72',1989,'1','1',1536939.33,1538869.06,1929.73,318405.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','72',1990,'2','1',1662696.37,1666430.12,3733.75,616068.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','72',1991,'3','1',1310677.52,1314327.95,3650.43,602320.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','72',1992,'4','1',863495.38,863495.61,0.23,37.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','72',1993,'5','1',1261805.00,1261841.00,36.00,5940.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','72',1994,'6','1',1719301.36,1723055.85,3754.49,619490.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','72',1995,'7','1',1567838.40,1567838.60,0.20,32.34,0.00,0.00,0.00,0.00,0.00),('21','224','1','72',1996,'8','1',1331884.06,1335038.72,3154.66,520518.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','72',1997,'9','1',1627006.08,1631041.05,4034.97,665770.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','72',1998,'10','1',1814604.39,1819449.13,4844.74,799382.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','72',1999,'13','1',1558865.67,1565195.03,6329.36,1044344.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','72',2000,'14','1',1536453.46,1536453.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','72',2001,'15','1',1512229.64,1512229.84,0.20,33.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','72',2002,'16','1',1572874.00,1577822.16,4948.16,816446.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','72',2003,'17','1',1428837.93,1432070.48,3232.55,533370.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','72',2004,'18','1',1450104.80,1453156.97,3052.17,503608.05,0.00,0.00,0.00,0.00,0.00),('21','224','6','72',2005,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','72',2006,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','72',2007,'25','1',1206225.95,1209530.91,3304.96,545318.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','72',2008,'26','1',1370517.77,1373569.53,3051.76,503540.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','72',2009,'29','2',864578.14,865080.56,502.42,361742.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','72',2010,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','72',2011,'31','2',814960.61,821967.05,7006.44,5044636.80,0.00,0.00,0.00,0.00,0.00),('21','224','5','72',2012,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','72',2013,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','72',2014,'34','3',599390.27,600625.89,1235.62,803153.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','72',2015,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','72',2016,'36','1',1823177.15,1827169.82,3992.67,658790.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','73',2017,'1','1',1538869.06,1542687.13,3618.07,596981.55,0.00,0.00,200.00,0.00,0.00),('21','224','1','73',2018,'2','1',1666430.12,1670247.30,3817.18,629834.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','73',2019,'3','1',1314327.95,1319368.32,5040.37,831661.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','73',2020,'4','1',863495.61,863495.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','73',2021,'5','1',1261841.00,1264968.00,3127.00,515955.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','73',2022,'6','1',1723055.85,1727851.92,4796.07,791351.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','73',2023,'7','1',1567838.60,1567838.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','73',2024,'8','1',1335038.72,1340944.01,5905.29,974372.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','73',2025,'9','1',1631041.05,1633343.28,2302.23,379867.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','73',2026,'10','1',1819449.13,1821474.44,2025.31,334176.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','73',2027,'13','1',1565195.03,1567749.61,2554.58,421505.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','73',2028,'14','1',1536453.46,1536453.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','73',2029,'15','1',1512229.84,1512229.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','73',2030,'16','1',1577822.16,1580700.35,2878.19,474901.35,0.00,0.00,0.00,0.00,0.00),('21','224','3','73',2031,'17','1',1432070.48,1432070.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','73',2032,'18','1',1453156.97,1453156.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','73',2033,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','73',2034,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','73',2035,'25','1',1209530.91,1209530.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','73',2036,'26','1',1373569.53,1373569.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','73',2037,'29','2',865080.56,865080.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','73',2038,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','73',2039,'31','2',821967.05,826610.86,4563.03,3285381.60,0.00,0.00,80.78,0.00,0.00),('21','224','5','73',2040,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','73',2041,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','73',2042,'34','3',600625.89,601437.25,790.92,514098.00,0.00,0.00,20.44,0.00,0.00),('21','224','2','73',2043,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','73',2044,'36','1',1827169.82,1827169.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','74',2045,'1','1',1542687.13,1542687.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','74',2046,'2','1',1670247.30,1670247.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','74',2047,'3','1',1319368.32,1319368.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','74',2048,'4','1',863495.61,863495.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','74',2049,'5','1',1264968.00,1264968.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','74',2050,'6','1',1727851.92,1727851.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','74',2051,'7','1',1567838.60,1567838.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','74',2052,'8','1',1340944.01,1340944.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','74',2053,'9','1',1633343.28,1633343.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','74',2054,'10','1',1821474.44,1821474.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','74',2055,'13','1',1567749.61,1567749.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','74',2056,'14','1',1536453.46,1536453.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','74',2057,'15','1',1512229.84,1512229.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','74',2058,'16','1',1580700.35,1580700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','74',2059,'17','1',1432070.48,1432070.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','74',2060,'18','1',1453156.97,1453156.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','74',2061,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','74',2062,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','74',2063,'25','1',1209530.91,1209530.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','74',2064,'26','1',1373569.53,1373569.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','74',2065,'29','2',865080.56,865080.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','74',2066,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','74',2067,'31','2',826610.86,826610.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','74',2068,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','74',2069,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','74',2070,'34','3',601437.25,601437.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','74',2071,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','74',2072,'36','1',1827169.82,1827169.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','75',2073,'1','1',1542687.13,1548407.23,5650.21,932284.65,0.00,0.00,69.89,0.00,0.00),('21','224','1','75',2074,'2','1',1670247.30,1673084.33,2837.03,468109.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','75',2075,'3','1',1319368.32,1325108.27,5739.95,947091.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','75',2076,'4','1',863495.61,867636.45,4140.84,683238.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','75',2077,'5','1',1264968.00,1270418.00,5450.00,899250.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','75',2078,'6','1',1727851.92,1734664.92,6813.00,1124145.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','75',2079,'7','1',1567838.60,1570687.09,2848.49,470000.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','75',2080,'8','1',1340944.01,1346531.89,5587.88,922000.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','75',2081,'9','1',1633343.28,1638615.61,5272.33,869934.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','75',2082,'10','1',1821474.44,1824946.13,3471.69,572828.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','75',2083,'13','1',1567749.61,1574512.87,6763.26,1115937.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','75',2084,'14','1',1536453.46,1536453.64,0.18,29.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','75',2085,'15','1',1512229.84,1514961.56,2731.72,450733.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','75',2086,'16','1',1580700.35,1585231.18,4530.83,747586.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','75',2087,'17','1',1432070.48,1432070.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','75',2088,'18','1',1453156.97,1457262.51,4105.54,677414.10,0.00,0.00,0.00,0.00,0.00),('21','224','6','75',2089,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','75',2090,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','75',2091,'25','1',1209530.91,1209530.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','75',2092,'26','1',1373569.53,1377049.89,3480.36,574259.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','75',2093,'29','2',865080.56,875946.61,10866.05,8258198.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','75',2094,'30','2',18.32,18.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','75',2095,'31','2',826610.86,831745.12,5134.26,3902037.60,0.00,0.00,0.00,0.00,0.00),('21','224','5','75',2096,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','75',2097,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','75',2098,'34','3',601437.25,602496.78,1059.53,688694.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','75',2099,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','75',2100,'36','1',1827169.82,1833353.67,6183.85,1020335.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','76',2101,'1','1',1548407.23,1550551.63,2112.41,348547.65,0.00,0.00,31.99,0.00,0.00),('21','224','1','76',2102,'2','1',1673084.33,1674625.58,1511.25,249356.25,0.00,0.00,30.00,0.00,0.00),('21','224','1','76',2103,'3','1',1325108.27,1326826.29,1718.02,283473.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','76',2104,'4','1',867636.45,869840.10,2203.65,363602.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','76',2105,'5','1',1270418.00,1272484.00,2066.00,340890.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','76',2106,'6','1',1734664.92,1737285.85,2620.93,432453.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','76',2107,'7','1',1570687.09,1572584.29,1897.20,313038.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','76',2108,'8','1',1346531.89,1348653.45,2121.56,350057.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','76',2109,'9','1',1638615.61,1641513.73,2898.12,478189.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','76',2110,'10','1',1824946.13,1827569.90,2603.77,429622.05,0.00,0.00,20.00,0.00,0.00),('21','224','2','76',2111,'13','1',1574512.87,1578190.71,3667.84,605193.60,0.00,0.00,10.00,0.00,0.00),('21','224','2','76',2112,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','76',2113,'15','1',1514961.56,1517977.64,2996.08,494353.20,0.00,0.00,20.00,0.00,0.00),('21','224','2','76',2114,'16','1',1585231.18,1587894.17,2642.99,436093.35,0.00,0.00,20.00,0.00,0.00),('21','224','3','76',2115,'17','1',1432070.48,1433953.16,1882.68,310642.20,0.00,0.00,0.00,0.00,0.00),('21','224','3','76',2116,'18','1',1457262.51,1459727.56,2465.05,406733.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','76',2117,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','76',2118,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','76',2119,'25','1',1209530.91,1209969.66,438.75,72393.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','76',2120,'26','1',1377049.89,1379710.03,2660.14,438923.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','76',2121,'29','2',875946.61,883278.60,7331.99,5572312.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','76',2122,'30','2',18.32,18.35,0.03,22.80,0.00,0.00,0.00,0.00,0.00),('21','224','5','76',2123,'31','2',831745.12,838273.04,6527.92,4961219.20,0.00,0.00,0.00,0.00,0.00),('21','224','5','76',2124,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','76',2125,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','76',2126,'34','3',602496.78,603400.56,903.78,587457.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','76',2127,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','76',2128,'36','1',1833353.67,1836701.42,3337.46,550680.90,0.00,0.00,10.29,0.00,0.00),('21','224','1','77',2129,'1','1',1550551.63,1555868.56,5316.93,877293.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','77',2130,'2','1',1674625.58,1675688.99,1063.41,175462.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','77',2131,'3','1',1326826.29,1332687.79,5861.50,967147.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','77',2132,'4','1',869840.10,874908.26,5068.16,836246.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','77',2133,'5','1',1272484.00,1276658.00,4174.00,688710.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','77',2134,'6','1',1737285.85,1742552.63,5266.78,869018.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','77',2135,'7','1',1572584.29,1577922.39,5338.10,880786.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','77',2136,'8','1',1348653.45,1350003.52,1350.07,222761.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','77',2137,'9','1',1641513.73,1641518.80,5.07,836.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','77',2138,'10','1',1827569.90,1832834.81,5264.91,868710.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','77',2139,'13','1',1578190.71,1583245.80,5055.09,834089.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','77',2140,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','77',2141,'15','1',1517977.64,1521806.43,3828.79,631750.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','77',2142,'16','1',1587894.17,1591424.32,3530.15,582474.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','77',2143,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','77',2144,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','77',2145,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','77',2146,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','77',2147,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','77',2148,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','77',2149,'29','2',883278.60,884939.86,1661.26,1262557.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','77',2150,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','77',2151,'31','2',838273.04,841316.72,3043.68,2313196.80,0.00,0.00,0.00,0.00,0.00),('21','224','5','77',2152,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','77',2153,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','77',2154,'34','3',603400.56,603944.60,544.04,353626.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','77',2155,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','77',2156,'36','1',1836701.42,1840865.63,4164.21,687094.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','78',2157,'1','1',1555868.56,1560466.43,4597.87,758648.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','78',2158,'2','1',1675688.99,1680128.53,4439.54,732524.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','78',2159,'3','1',1332687.79,1337773.66,5085.87,839168.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','78',2160,'4','1',874908.26,880944.11,6035.85,995915.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','78',2161,'5','1',1276658.00,1278728.00,2070.00,341550.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','78',2162,'6','1',1742552.63,1748367.88,5815.25,959516.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','78',2163,'7','1',1577922.39,1582788.25,4865.86,802866.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','78',2164,'8','1',1350003.52,1353456.87,3453.35,569802.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','78',2165,'9','1',1641518.80,1642827.69,1308.89,215966.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','78',2166,'10','1',1832834.81,1838802.18,5967.37,984616.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','78',2167,'13','1',1583245.80,1589227.06,5981.26,986907.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','78',2168,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','78',2169,'15','1',1521806.43,1527035.83,5229.40,862851.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','78',2170,'16','1',1591424.32,1596451.08,5026.76,829415.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','78',2171,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','78',2172,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','78',2173,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','78',2174,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','78',2175,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','78',2176,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','78',2177,'29','2',884939.86,892801.55,7861.69,5974884.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','78',2178,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','78',2179,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','78',2180,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','78',2181,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','78',2182,'34','3',603944.60,604865.72,921.12,598728.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','78',2183,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','78',2184,'36','1',1840865.63,1845647.17,4781.54,788954.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','79',2185,'1','1',1560466.43,1564683.47,4217.04,695811.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','79',2186,'2','1',1680128.53,1684290.57,4113.56,678737.40,0.00,0.00,48.48,0.00,0.00),('21','224','1','79',2187,'3','1',1337773.66,1342355.09,4581.43,755935.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','79',2188,'4','1',880944.11,886349.00,5404.89,891806.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','79',2189,'5','1',1278728.00,1281894.00,3166.00,522390.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','79',2190,'6','1',1748367.88,1752007.78,3639.90,600583.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','79',2191,'7','1',1582788.25,1586494.00,3705.75,611448.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','79',2192,'8','1',1353456.87,1356840.99,3384.12,558379.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','79',2193,'9','1',1642827.69,1645512.80,2685.11,443043.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','79',2194,'10','1',1838802.18,1841371.40,2569.22,423921.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','79',2195,'13','1',1589227.06,1592188.20,2961.14,488588.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','79',2196,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','79',2197,'15','1',1527035.83,1530122.50,3086.67,509300.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','79',2198,'16','1',1596451.08,1599002.80,2551.72,421033.80,0.00,0.00,0.00,0.00,0.00),('21','224','3','79',2199,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','79',2200,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','79',2201,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','79',2202,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','79',2203,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','79',2204,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','79',2205,'29','2',892801.55,900046.51,7215.87,5484061.20,0.00,0.00,29.09,0.00,0.00),('21','224','4','79',2206,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','79',2207,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','79',2208,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','79',2209,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','79',2210,'34','3',604865.72,605757.23,891.51,579481.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','79',2211,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','79',2212,'36','1',1845647.17,1848159.46,2512.29,414527.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','80',2213,'1','1',1564683.47,1568774.05,4090.58,674945.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','80',2214,'2','1',1684290.57,1690228.65,5938.08,979783.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','80',2215,'3','1',1342355.09,1348283.42,5928.33,978174.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','80',2216,'4','1',886349.00,892242.97,5893.97,972505.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','80',2217,'5','1',1281894.00,1287707.00,5813.00,959145.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','80',2218,'6','1',1752007.78,1757354.48,5346.70,882205.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','80',2219,'7','1',1586494.00,1590533.41,4039.41,666502.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','80',2220,'8','1',1356840.99,1360641.43,3800.44,627072.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','80',2221,'9','1',1645512.80,1647407.64,1894.84,312648.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','80',2222,'10','1',1841371.40,1844940.88,3569.48,588964.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','80',2223,'13','1',1592188.20,1596145.60,3957.40,652971.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','80',2224,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','80',2225,'15','1',1530122.50,1532638.69,2516.19,415171.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','80',2226,'16','1',1599002.80,1601991.64,2988.84,493158.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','80',2227,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','80',2228,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','80',2229,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','80',2230,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','80',2231,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','80',2232,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','80',2233,'29','2',900046.51,907644.58,7598.07,5774533.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','80',2234,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','80',2235,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','80',2236,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','80',2237,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','80',2238,'34','3',605757.23,606896.15,1138.92,740298.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','80',2239,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','80',2240,'36','1',1848159.46,1851938.85,3779.39,623599.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','81',2241,'1','1',1568774.05,1571609.27,2835.22,467811.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','81',2242,'2','1',1690228.65,1694508.85,4280.20,706233.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','81',2243,'3','1',1348283.42,1352025.04,3741.62,617367.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','81',2244,'4','1',892242.97,898691.11,6448.14,1063943.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','81',2245,'5','1',1287707.00,1291488.00,3781.00,623865.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','81',2246,'6','1',1757354.48,1761892.81,4538.33,748824.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','81',2247,'7','1',1590533.41,1594479.91,3946.50,651172.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','81',2248,'8','1',1360641.43,1364160.88,3519.45,580709.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','81',2249,'9','1',1647407.64,1649869.72,2462.08,406243.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','81',2250,'10','1',1844940.88,1847615.02,2674.14,441233.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','81',2251,'13','1',1596145.60,1600183.60,4038.00,666270.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','81',2252,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','81',2253,'15','1',1532638.69,1535954.79,3316.10,547156.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','81',2254,'16','1',1601991.64,1605153.63,3161.99,521728.35,0.00,0.00,0.00,0.00,0.00),('21','224','3','81',2255,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','81',2256,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','81',2257,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','81',2258,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','81',2259,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','81',2260,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','81',2261,'29','2',907644.58,913398.13,5753.55,4372698.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','81',2262,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','81',2263,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','81',2264,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','81',2265,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','81',2266,'34','3',606896.15,608029.87,1133.72,736918.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','81',2267,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','81',2268,'36','1',1851938.85,1855633.16,3694.31,609561.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','82',2269,'1','1',1571609.27,1574431.09,2672.26,440922.90,0.00,0.00,149.56,0.00,0.00),('21','224','1','82',2270,'2','1',1694508.85,1697667.71,3158.86,521211.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','82',2271,'3','1',1352025.04,1355437.83,3412.79,563110.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','82',2272,'4','1',898691.11,902027.43,3336.32,550492.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','82',2273,'5','1',1291488.00,1294248.00,2760.00,455400.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','82',2274,'6','1',1761892.81,1765046.26,3153.45,520319.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','82',2275,'7','1',1594479.91,1597541.78,3061.87,505208.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','82',2276,'8','1',1364160.88,1367159.93,2999.05,494843.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','82',2277,'9','1',1649869.72,1654118.13,4248.41,700987.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','82',2278,'10','1',1847615.02,1852748.80,5133.78,847073.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','82',2279,'13','1',1600183.60,1606443.90,6260.30,1032949.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','82',2280,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','82',2281,'15','1',1535954.79,1539785.38,3830.59,632047.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','82',2282,'16','1',1605153.63,1608748.17,3594.54,593099.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','82',2283,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','82',2284,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','82',2285,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','82',2286,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','82',2287,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','82',2288,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','82',2289,'29','2',913398.13,921953.19,8545.10,6494276.00,0.00,0.00,9.96,0.00,0.00),('21','224','4','82',2290,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','82',2291,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','82',2292,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','82',2293,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','82',2294,'34','3',608029.87,608964.26,934.39,607353.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','82',2295,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','82',2296,'36','1',1855633.16,1860906.43,5273.27,870089.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','83',2297,'1','1',1574431.09,1578362.02,3930.93,648603.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','83',2298,'2','1',1697667.71,1701987.21,4319.50,712717.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','83',2299,'3','1',1355437.83,1360112.45,4674.62,771312.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','83',2300,'4','1',902027.43,907188.68,5161.25,851606.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','83',2301,'5','1',1294248.00,1298413.00,4165.00,687225.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','83',2302,'6','1',1765046.26,1769567.59,4521.33,746019.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','83',2303,'7','1',1597541.78,1602074.78,4533.00,747945.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','83',2304,'8','1',1367159.93,1371255.15,4095.22,675711.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','83',2305,'9','1',1654118.13,1656456.66,2338.53,385857.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','83',2306,'10','1',1852748.80,1855158.81,2410.01,397651.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','83',2307,'13','1',1606443.90,1609371.15,2927.25,482996.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','83',2308,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','83',2309,'15','1',1539785.38,1542212.49,2427.11,400473.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','83',2310,'16','1',1608748.17,1611261.89,2513.72,414763.80,0.00,0.00,0.00,0.00,0.00),('21','224','3','83',2311,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','83',2312,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','83',2313,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','83',2314,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','83',2315,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','83',2316,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','83',2317,'29','2',921953.19,931489.45,9536.26,7247557.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','83',2318,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','83',2319,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','83',2320,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','83',2321,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','83',2322,'34','3',608964.26,610142.04,1177.78,765557.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','83',2323,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','83',2324,'36','1',1860906.43,1863584.83,2678.40,441936.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','84',2325,'1','1',1578362.02,1581118.69,2756.67,454850.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','84',2326,'2','1',1701987.21,1705594.56,3607.35,595212.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','84',2327,'3','1',1360112.45,1363396.51,3284.06,541869.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','84',2328,'4','1',907188.68,910782.32,3593.64,592950.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','84',2329,'5','1',1298413.00,1301627.00,3214.00,530310.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','84',2330,'6','1',1769567.59,1772635.06,3067.47,506132.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','84',2331,'7','1',1602074.78,1604870.05,2795.27,461219.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','84',2332,'8','1',1371255.15,1373894.34,2639.19,435466.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','84',2333,'9','1',1656456.66,1658696.68,2240.02,369603.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','84',2334,'10','1',1855158.81,1856643.66,1484.85,245000.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','84',2335,'13','1',1609371.15,1611550.31,2179.16,359561.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','84',2336,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','84',2337,'15','1',1542212.49,1543921.31,1708.82,281955.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','84',2338,'16','1',1611261.89,1613244.98,1983.09,327209.85,0.00,0.00,0.00,0.00,0.00),('21','224','3','84',2339,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','84',2340,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','84',2341,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','84',2342,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','84',2343,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','84',2344,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','84',2345,'29','2',931489.45,937101.72,5612.27,4265325.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','84',2346,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','84',2347,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','84',2348,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','84',2349,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','84',2350,'34','3',610142.04,611532.20,1390.16,903604.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','84',2351,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','84',2352,'36','1',1863584.83,1865971.28,2386.45,393764.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','85',2353,'1','1',1581118.69,1584371.07,3160.12,521419.80,0.00,0.00,92.26,0.00,0.00),('21','224','1','85',2354,'2','1',1705594.56,1709082.80,3488.24,575559.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','85',2355,'3','1',1363396.51,1368894.16,5497.65,907112.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','85',2356,'4','1',910782.32,911861.71,1079.39,178099.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','85',2357,'5','1',1301627.00,1305038.00,3411.00,562815.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','85',2358,'6','1',1772635.06,1775324.93,2689.87,443828.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','85',2359,'7','1',1604870.05,1608579.54,3709.49,612065.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','85',2360,'8','1',1373894.34,1376529.29,2634.95,434766.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','85',2361,'9','1',1658696.68,1661024.43,2327.75,384078.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','85',2362,'10','1',1856643.66,1859138.03,2494.37,411571.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','85',2363,'13','1',1611550.31,1615014.66,3314.79,546940.35,0.00,0.00,149.56,0.00,0.00),('21','224','2','85',2364,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','85',2365,'15','1',1543921.31,1546563.58,2642.27,435974.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','85',2366,'16','1',1613244.98,1615570.49,2325.51,383709.15,0.00,0.00,0.00,0.00,0.00),('21','224','3','85',2367,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','85',2368,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','85',2369,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','85',2370,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','85',2371,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','85',2372,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','85',2373,'29','2',937101.72,942822.31,5710.63,4340078.80,0.00,0.00,9.96,0.00,0.00),('21','224','4','85',2374,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','85',2375,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','85',2376,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','85',2377,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','85',2378,'34','3',611532.20,623461.19,11928.99,7753843.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','85',2379,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','85',2380,'36','1',1865971.28,1868921.82,2950.54,486839.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','86',2381,'1','1',1584371.07,1590162.46,5637.95,930261.75,0.00,0.00,153.44,0.00,0.00),('21','224','1','86',2382,'2','1',1709082.80,1714934.04,5851.24,965454.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','86',2383,'3','1',1368894.16,1377395.47,8501.31,1402716.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','86',2384,'4','1',911861.71,911872.25,10.54,1739.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','86',2385,'5','1',1305038.00,1310383.00,5345.00,881925.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','86',2386,'6','1',1775324.93,1780768.78,5443.85,898235.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','86',2387,'7','1',1608579.54,1613751.36,5171.82,853350.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','86',2388,'8','1',1376529.29,1381060.94,4531.65,747722.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','86',2389,'9','1',1661024.43,1664689.44,3665.01,604726.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','86',2390,'10','1',1859138.03,1862383.43,3245.40,535491.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','86',2391,'13','1',1615014.66,1619488.44,4473.78,738173.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','86',2392,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','86',2393,'15','1',1546563.58,1550101.17,3537.59,583702.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','86',2394,'16','1',1615570.49,1618570.59,3000.10,495016.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','86',2395,'17','1',1433953.16,1433953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','86',2396,'18','1',1459727.56,1459727.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','86',2397,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','86',2398,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','86',2399,'25','1',1209969.66,1209969.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','86',2400,'26','1',1379710.03,1379710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','86',2401,'29','2',942822.31,953253.64,10431.33,7927810.80,0.00,0.00,0.00,0.00,0.00),('21','224','4','86',2402,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','86',2403,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','86',2404,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','86',2405,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','86',2406,'34','3',623461.19,625382.55,1921.36,1248884.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','86',2407,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','86',2408,'36','1',1868921.82,1872895.52,3973.70,655660.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','87',2409,'1','1',1590162.46,1594243.70,4081.24,673404.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','87',2410,'2','1',1714934.04,1719304.95,4370.91,721200.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','87',2411,'3','1',1377395.47,1382772.46,5376.99,887203.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','87',2412,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','87',2413,'5','1',1310383.00,1313857.00,3474.00,573210.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','87',2414,'6','1',1780768.78,1784864.24,4095.46,675750.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','87',2415,'7','1',1613751.36,1617227.33,3475.97,573535.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','87',2416,'8','1',1381060.94,1384419.19,3358.25,554111.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','87',2417,'9','1',1664689.44,1667074.03,2384.59,393457.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','87',2418,'10','1',1862383.43,1864703.10,2319.67,382745.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','87',2419,'13','1',1619488.44,1622339.71,2851.27,470459.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','87',2420,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','87',2421,'15','1',1550101.17,1552201.12,2099.95,346491.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','87',2422,'16','1',1618570.59,1620259.98,1689.39,278749.35,0.00,0.00,0.00,0.00,0.00),('21','224','3','87',2423,'17','1',1433953.16,1436413.64,2460.48,405979.20,0.00,0.00,0.00,0.00,0.00),('21','224','3','87',2424,'18','1',1459727.56,1464621.25,4893.69,807458.85,0.00,0.00,0.00,0.00,0.00),('21','224','6','87',2425,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','87',2426,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','87',2427,'25','1',1209969.66,1213491.69,3522.03,581134.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','87',2428,'26','1',1379710.03,1383701.83,3991.80,658647.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','87',2429,'29','2',953253.64,960595.74,7342.10,5579996.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','87',2430,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','87',2431,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','87',2432,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','87',2433,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','87',2434,'34','3',625382.55,627622.01,2239.46,1455649.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','87',2435,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','87',2436,'36','1',1872895.52,1875712.37,2816.85,464780.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','88',2437,'1','1',1594243.70,1599882.40,5638.70,930385.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','88',2438,'2','1',1719304.95,1724259.49,4954.54,817499.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','88',2439,'3','1',1382772.46,1391540.42,8767.96,1446713.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','88',2440,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','88',2441,'5','1',1313857.00,1318951.00,5094.00,840510.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','88',2442,'6','1',1784864.24,1791017.64,6153.40,1015311.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','88',2443,'7','1',1617227.33,1622511.13,5283.80,871827.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','88',2444,'8','1',1384419.19,1389500.58,5081.39,838429.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','88',2445,'9','1',1667074.03,1670775.82,3701.79,610795.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','88',2446,'10','1',1864703.10,1868081.48,3378.38,557432.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','88',2447,'13','1',1622339.71,1626932.71,4593.00,757845.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','88',2448,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','88',2449,'15','1',1552201.12,1555173.58,2972.46,490455.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','88',2450,'16','1',1620259.98,1623913.76,3653.78,602873.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','88',2451,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','88',2452,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','88',2453,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','88',2454,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','88',2455,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','88',2456,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','88',2457,'29','2',960595.74,967780.07,7184.33,5603777.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','88',2458,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','88',2459,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','88',2460,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','88',2461,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','88',2462,'34','3',627622.01,629665.18,2043.17,1328060.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','88',2463,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','88',2464,'36','1',1875712.37,1880081.03,4368.66,720828.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','89',2465,'1','1',1599882.40,1602892.84,3010.44,496722.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','89',2466,'2','1',1724259.49,1727345.12,3085.63,509128.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','89',2467,'3','1',1391540.42,1396581.72,5041.30,831814.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','89',2468,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','89',2469,'5','1',1318951.00,1321802.00,2851.00,470415.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','89',2470,'6','1',1791017.64,1794308.51,3290.87,542993.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','89',2471,'7','1',1622511.13,1625892.29,3381.16,557891.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','89',2472,'8','1',1389500.58,1392792.76,3292.18,543209.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','89',2473,'9','1',1670775.82,1672363.26,1587.44,261927.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','89',2474,'10','1',1868081.48,1872224.17,4142.69,683543.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','89',2475,'13','1',1626932.71,1628399.83,1467.12,242074.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','89',2476,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','89',2477,'15','1',1555173.58,1556466.41,1292.83,213316.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','89',2478,'16','1',1623913.76,1625103.71,1189.95,196341.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','89',2479,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','89',2480,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','89',2481,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','89',2482,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','89',2483,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','89',2484,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','89',2485,'29','2',967780.07,978711.65,10931.58,8526632.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','89',2486,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','89',2487,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','89',2488,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','89',2489,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','89',2490,'34','3',629665.18,632490.29,2825.11,1836321.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','89',2491,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','89',2492,'36','1',1880081.03,1881611.43,1530.40,252516.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','90',2493,'1','1',1602892.84,1607866.23,4973.39,820609.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','90',2494,'2','1',1727345.12,1734133.70,6788.58,1120115.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','90',2495,'3','1',1396581.72,1407451.23,10869.51,1793469.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','90',2496,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','90',2497,'5','1',1321802.00,1326932.00,5130.00,846450.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','90',2498,'6','1',1794308.51,1801450.95,7142.44,1178502.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','90',2499,'7','1',1625892.29,1631280.10,5387.81,888988.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','90',2500,'8','1',1392792.76,1398785.04,5992.28,988726.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','90',2501,'9','1',1672363.26,1679551.85,7188.59,1186117.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','90',2502,'10','1',1872224.17,1875012.48,2788.31,460071.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','90',2503,'13','1',1628399.83,1636872.18,8472.35,1397937.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','90',2504,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','90',2505,'15','1',1556466.41,1562890.62,6424.21,1059994.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','90',2506,'16','1',1625103.71,1631548.25,6444.54,1063349.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','90',2507,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','90',2508,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','90',2509,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','90',2510,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','90',2511,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','90',2512,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','90',2513,'29','2',978711.65,989099.42,10387.77,8102460.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','90',2514,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','90',2515,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','90',2516,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','90',2517,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','90',2518,'34','3',632490.29,634077.77,1587.48,1031862.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','90',2519,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','90',2520,'36','1',1881611.43,1889539.85,7928.42,1308189.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','91',2521,'1','1',1607866.23,1612547.17,4680.94,772355.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','91',2522,'2','1',1734133.70,1738991.78,4858.08,801583.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','91',2523,'3','1',1407451.23,1414057.30,6606.07,1090001.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','91',2524,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','91',2525,'5','1',1326932.00,1331478.00,4546.00,750090.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','91',2526,'6','1',1801450.95,1806175.43,4724.48,779539.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','91',2527,'7','1',1631280.10,1635342.23,4062.13,670251.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','91',2528,'8','1',1398785.04,1402781.28,3996.24,659379.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','91',2529,'9','1',1679551.85,1684168.26,4616.41,761707.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','91',2530,'10','1',1875012.48,1879068.52,4056.04,669246.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','91',2531,'13','1',1636872.18,1641861.56,4989.38,823247.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','91',2532,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','91',2533,'15','1',1562890.62,1566737.69,3847.07,634766.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','91',2534,'16','1',1631548.25,1635337.88,3789.63,625288.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','91',2535,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','91',2536,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','91',2537,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','91',2538,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','91',2539,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','91',2540,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','91',2541,'29','2',989099.42,1002064.65,12965.23,10372184.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','91',2542,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','91',2543,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','91',2544,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','91',2545,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','91',2546,'34','3',634077.77,635530.05,1452.28,943982.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','91',2547,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','91',2548,'36','1',1889539.85,1893985.24,4445.39,733489.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','92',2549,'1','1',1612547.17,1615226.56,2500.00,412500.00,0.00,0.00,179.39,0.00,0.00),('21','224','1','92',2550,'2','1',1738991.78,1741917.64,2925.86,482766.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','92',2551,'3','1',1414057.30,1418552.20,4494.90,741658.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','92',2552,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','92',2553,'5','1',1331478.00,1334220.00,2742.00,452430.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','92',2554,'6','1',1806175.43,1809186.57,3011.14,496838.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','92',2555,'7','1',1635342.23,1638330.48,2988.25,493061.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','92',2556,'8','1',1402781.28,1405756.88,2975.60,490974.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','92',2557,'9','1',1684168.26,1686879.99,2711.73,447435.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','92',2558,'10','1',1879068.52,1882078.95,3010.43,496720.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','92',2559,'13','1',1641861.56,1645049.54,3187.98,526016.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','92',2560,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','92',2561,'15','1',1566737.69,1569508.78,2771.09,457229.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','92',2562,'16','1',1635337.88,1637843.24,2505.36,413384.40,0.00,0.00,0.00,0.00,0.00),('21','224','3','92',2563,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','92',2564,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','92',2565,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','92',2566,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','92',2567,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','92',2568,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','92',2569,'29','2',1002064.65,1018634.64,16569.99,13255992.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','92',2570,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','92',2571,'31','2',841316.72,841316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','92',2572,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','92',2573,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','92',2574,'34','3',635530.05,636148.00,617.95,401667.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','92',2575,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','92',2576,'36','1',1893985.24,1897252.00,3266.76,539015.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','93',2577,'1','1',1615226.56,1619863.23,4636.67,765050.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','93',2578,'2','1',1741917.64,1745870.46,3952.82,652215.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','93',2579,'3','1',1418552.20,1427155.35,8603.15,1419519.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','93',2580,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','93',2581,'5','1',1334220.00,1339616.00,5396.00,890340.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','93',2582,'6','1',1809186.57,1815516.16,6329.59,1044382.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','93',2583,'7','1',1638330.48,1644115.75,5785.27,954569.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','93',2584,'8','1',1405756.88,1410502.07,4745.19,782956.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','93',2585,'9','1',1686879.99,1689278.64,2398.65,395777.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','93',2586,'10','1',1882078.95,1884471.98,2393.03,394849.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','93',2587,'13','1',1645049.54,1648016.67,2913.86,480786.90,0.00,0.00,53.27,0.00,0.00),('21','224','2','93',2588,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','93',2589,'15','1',1569508.78,1571732.20,2223.42,366864.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','93',2590,'16','1',1637843.24,1640159.65,2316.41,382207.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','93',2591,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','93',2592,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','93',2593,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','93',2594,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','93',2595,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','93',2596,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','93',2597,'29','2',1018634.64,1032793.07,14158.43,11326744.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','93',2598,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','93',2599,'31','2',841316.72,842316.72,1000.00,800000.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','93',2600,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','93',2601,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','93',2602,'34','3',636148.00,637344.28,1196.28,837396.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','93',2603,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','93',2604,'36','1',1897252.00,1899708.67,2456.67,405350.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','94',2605,'1','1',1619863.23,1623673.99,3786.52,624775.80,0.00,0.00,24.24,0.00,0.00),('21','224','1','94',2606,'2','1',1745870.46,1750333.18,4462.72,736348.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','94',2607,'3','1',1427155.35,1433407.22,6251.87,1031558.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','94',2608,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','94',2609,'5','1',1339616.00,1344594.00,4978.00,821370.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','94',2610,'6','1',1815516.16,1820147.50,4631.34,764171.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','94',2611,'7','1',1644115.75,1648504.64,4388.89,724166.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','94',2612,'8','1',1410502.07,1414708.86,4206.79,694120.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','94',2613,'9','1',1689278.64,1692145.49,2866.85,473030.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','94',2614,'10','1',1884471.98,1887346.67,2874.69,474323.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','94',2615,'13','1',1648016.67,1651394.49,3377.82,557340.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','94',2616,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','94',2617,'15','1',1571732.20,1574423.53,2691.33,444069.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','94',2618,'16','1',1640159.65,1642837.12,2677.47,441782.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','94',2619,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','94',2620,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','94',2621,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','94',2622,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','94',2623,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','94',2624,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','94',2625,'29','2',1032793.07,1033726.62,933.55,765511.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','94',2626,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','94',2627,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','94',2628,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','94',2629,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','94',2630,'34','3',637344.28,638961.32,1617.04,1131928.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','94',2631,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','94',2632,'36','1',1899708.67,1903248.49,3539.82,584070.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','95',2633,'1','1',1623673.99,1626974.98,3035.91,500925.15,0.00,0.00,265.08,0.00,0.00),('21','224','1','95',2634,'2','1',1750333.18,1754974.72,4641.54,765854.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','95',2635,'3','1',1433407.22,1439832.62,6425.40,1060191.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','95',2636,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','95',2637,'5','1',1344594.00,1348071.00,3477.00,573705.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','95',2638,'6','1',1820147.50,1823968.33,3820.83,630436.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','95',2639,'7','1',1648504.64,1652239.61,3734.97,616270.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','95',2640,'8','1',1414708.86,1418456.24,3747.38,618317.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','95',2641,'9','1',1692145.49,1694972.92,2827.43,466525.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','95',2642,'10','1',1887346.67,1890060.82,2714.15,447834.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','95',2643,'13','1',1651394.49,1654747.01,3352.52,553165.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','95',2644,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','95',2645,'15','1',1574423.53,1577230.19,2806.66,463098.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','95',2646,'16','1',1642837.12,1645933.32,3096.20,510873.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','95',2647,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','95',2648,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','95',2649,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','95',2650,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','95',2651,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','95',2652,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','95',2653,'29','2',1033726.62,1038819.89,5072.85,4159737.00,0.00,0.00,20.42,0.00,0.00),('21','224','4','95',2654,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','95',2655,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','95',2656,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','95',2657,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','95',2658,'34','3',638961.32,639549.00,567.28,397096.00,0.00,0.00,20.40,0.00,0.00),('21','224','2','95',2659,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','95',2660,'36','1',1903248.49,1906582.49,3334.00,550110.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','96',2661,'1','1',1626974.98,1629992.91,2866.41,472957.65,0.00,0.00,151.52,0.00,0.00),('21','224','1','96',2662,'2','1',1754974.72,1758559.95,3585.23,591562.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','96',2663,'3','1',1439832.62,1444594.59,4761.97,785725.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','96',2664,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','96',2665,'5','1',1348071.00,1351345.00,3274.00,540210.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','96',2666,'6','1',1823968.33,1827455.29,3486.96,575348.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','96',2667,'7','1',1652239.61,1655733.64,3494.03,576514.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','96',2668,'8','1',1418456.24,1421141.38,2685.14,443048.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','96',2669,'9','1',1694972.92,1696339.25,1366.33,225444.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','96',2670,'10','1',1890060.82,1891677.55,1616.73,266760.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','96',2671,'13','1',1654747.01,1656530.68,1783.67,294305.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','96',2672,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','96',2673,'15','1',1577230.19,1579115.88,1885.69,311138.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','96',2674,'16','1',1645933.32,1647542.26,1608.94,265475.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','96',2675,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','96',2676,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','96',2677,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','96',2678,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','96',2679,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','96',2680,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','96',2681,'29','2',1038819.89,1043527.59,4707.70,3860314.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','96',2682,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','96',2683,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','96',2684,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','96',2685,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','96',2686,'34','3',639549.00,640641.59,1092.59,764813.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','96',2687,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','96',2688,'36','1',1906582.49,1908170.93,1588.44,262092.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','97',2689,'1','1',1629992.91,1633811.27,3818.36,630029.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','97',2690,'2','1',1758559.95,1763169.38,4609.43,760555.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','97',2691,'3','1',1444594.59,1452788.20,8193.61,1351945.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','97',2692,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','97',2693,'5','1',1351345.00,1355223.00,3878.00,639870.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','97',2694,'6','1',1827455.29,1831568.93,4113.64,678750.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','97',2695,'7','1',1655733.64,1660713.96,4980.32,821752.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','97',2696,'8','1',1421141.38,1424492.01,3350.63,552853.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','97',2697,'9','1',1696339.25,1698753.93,2414.68,398422.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','97',2698,'10','1',1891677.55,1895218.39,3540.84,584238.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','97',2699,'13','1',1656530.68,1660245.55,3714.87,612953.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','97',2700,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','97',2701,'15','1',1579115.88,1582078.98,2963.10,488911.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','97',2702,'16','1',1647542.26,1650916.32,3374.06,556719.90,0.00,0.00,0.00,0.00,0.00),('21','224','3','97',2703,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','97',2704,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','97',2705,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','97',2706,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','97',2707,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','97',2708,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','97',2709,'29','2',1043527.59,1049448.03,5920.44,4854760.80,0.00,0.00,0.00,0.00,0.00),('21','224','4','97',2710,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','97',2711,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','97',2712,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','97',2713,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','97',2714,'34','3',640641.59,641619.73,978.14,684698.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','97',2715,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','97',2716,'36','1',1908170.93,1911407.80,3236.87,534083.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','98',2717,'1','1',1633811.27,1637527.27,3716.00,613140.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','98',2718,'2','1',1763169.38,1766631.27,3461.89,571211.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','98',2719,'3','1',1452788.20,1457778.62,4990.42,823419.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','98',2720,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','98',2721,'5','1',1355223.00,1358623.00,3400.00,561000.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','98',2722,'6','1',1831568.93,1835143.50,3574.57,589804.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','98',2723,'7','1',1660713.96,1664711.57,3997.61,659605.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','98',2724,'8','1',1424492.01,1427480.64,2988.63,493123.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','98',2725,'9','1',1698753.93,1701147.08,2393.15,394869.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','98',2726,'10','1',1895218.39,1897395.49,2177.10,359221.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','98',2727,'13','1',1660245.55,1662441.14,2195.59,362272.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','98',2728,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','98',2729,'15','1',1582078.98,1583915.45,1836.47,303017.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','98',2730,'16','1',1650916.32,1652752.82,1786.50,294772.50,0.00,0.00,50.00,0.00,0.00),('21','224','3','98',2731,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','98',2732,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','98',2733,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','98',2734,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','98',2735,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','98',2736,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','98',2737,'29','2',1049448.03,1057144.26,7696.23,6310908.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','98',2738,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','98',2739,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','98',2740,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','98',2741,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','98',2742,'34','3',641619.73,642619.67,999.94,699958.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','98',2743,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','98',2744,'36','1',1911407.80,1914017.76,2609.96,430643.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','99',2745,'1','1',1637527.27,1640192.77,2665.50,439807.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','99',2746,'2','1',1766631.27,1770106.97,3475.70,573490.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','99',2747,'3','1',1457778.62,1462265.40,4486.78,740318.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','99',2748,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','99',2749,'5','1',1358623.00,1362104.00,3481.00,574365.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','99',2750,'6','1',1835143.50,1838530.18,3386.68,558802.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','99',2751,'7','1',1664711.57,1668604.01,3892.44,642252.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','99',2752,'8','1',1427480.64,1429663.76,2183.12,360214.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','99',2753,'9','1',1701147.08,1702403.65,1256.57,207334.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','99',2754,'10','1',1897395.49,1898668.45,1272.96,210038.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','99',2755,'13','1',1662441.14,1664253.50,1812.36,299039.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','99',2756,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','99',2757,'15','1',1583915.45,1585131.67,1216.22,200676.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','99',2758,'16','1',1652752.82,1653808.00,1055.18,174104.70,0.00,0.00,0.00,0.00,0.00),('21','224','3','99',2759,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','99',2760,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','99',2761,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','99',2762,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','99',2763,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','99',2764,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','99',2765,'29','2',1057144.26,1066961.82,9817.56,8050399.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','99',2766,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','99',2767,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','99',2768,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','99',2769,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','99',2770,'34','3',642619.67,643550.16,930.49,697867.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','99',2771,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','99',2772,'36','1',1914017.76,1915459.73,1441.97,237925.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','100',2773,'1','1',1640192.77,1643904.18,3711.41,612382.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','100',2774,'2','1',1770106.97,1774786.65,4679.68,772147.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','100',2775,'3','1',1462265.40,1469916.45,7651.05,1262423.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','100',2776,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','100',2777,'5','1',1362104.00,1366673.00,4569.00,753885.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','100',2778,'6','1',1838530.18,1844124.38,5594.20,923043.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','100',2779,'7','1',1668604.01,1674564.41,5960.40,983466.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','100',2780,'8','1',1429663.76,1434412.13,4748.37,783481.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','100',2781,'9','1',1702403.65,1706003.64,3599.99,593998.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','100',2782,'10','1',1898668.45,1901673.70,3005.25,495866.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','100',2783,'13','1',1664253.50,1668402.99,4149.49,684665.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','100',2784,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','100',2785,'15','1',1585131.67,1588668.51,3536.84,583578.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','100',2786,'16','1',1653808.00,1656966.47,3158.47,521147.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','100',2787,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','100',2788,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','100',2789,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','100',2790,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','100',2791,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','100',2792,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','100',2793,'29','2',1066961.82,1073000.21,6038.39,5011863.70,0.00,0.00,0.00,0.00,0.00),('21','224','4','100',2794,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','100',2795,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','100',2796,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','100',2797,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','100',2798,'34','3',643550.16,644484.76,934.60,700950.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','100',2799,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','100',2800,'36','1',1915459.73,1918978.01,3518.28,580516.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','101',2801,'1','1',1643904.18,1648627.49,4723.31,779346.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','101',2802,'2','1',1774786.65,1779894.65,5108.00,842820.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','101',2803,'3','1',1469916.45,1477111.41,7194.96,1187168.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','101',2804,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','101',2805,'5','1',1366673.00,1371351.00,4678.00,771870.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','101',2806,'6','1',1844124.38,1849324.87,5200.49,858080.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','101',2807,'7','1',1674564.41,1680032.83,5468.42,902289.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','101',2808,'8','1',1434412.13,1439093.94,4681.81,772498.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','101',2809,'9','1',1706003.64,1709296.71,3293.07,543356.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','101',2810,'10','1',1901673.70,1904637.44,2963.74,489017.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','101',2811,'13','1',1668402.99,1672878.88,4475.89,738521.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','101',2812,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','101',2813,'15','1',1588668.51,1592282.46,3613.95,596301.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','101',2814,'16','1',1656966.47,1659746.96,2780.49,458780.85,0.00,0.00,0.00,0.00,0.00),('21','224','3','101',2815,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','101',2816,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','101',2817,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','101',2818,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','101',2819,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','101',2820,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','101',2821,'29','2',1073000.21,1078671.18,5670.97,4706905.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','101',2822,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','101',2823,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','101',2824,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','101',2825,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','101',2826,'34','3',644484.76,653187.64,8702.88,6527160.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','101',2827,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','101',2828,'36','1',1918978.01,1923066.15,4088.14,674543.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','102',2829,'1','1',1648627.49,1651738.11,3110.62,513252.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','102',2830,'2','1',1779894.65,1784215.91,4321.26,713007.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','102',2831,'3','1',1477111.41,1483102.66,5991.25,988556.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','102',2832,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','102',2833,'5','1',1371351.00,1374347.00,2996.00,494340.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','102',2834,'6','1',1849324.87,1852810.35,3485.48,575104.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','102',2835,'7','1',1680032.83,1683820.99,3788.16,625046.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','102',2836,'8','1',1439093.94,1443249.47,4155.53,685662.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','102',2837,'9','1',1709296.71,1711470.62,2173.91,358695.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','102',2838,'10','1',1904637.44,1906798.14,2160.70,356515.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','102',2839,'13','1',1672878.88,1675168.69,2289.81,377818.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','102',2840,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','102',2841,'15','1',1592282.46,1594085.22,1802.76,297455.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','102',2842,'16','1',1659746.96,1661809.68,2062.72,340348.80,0.00,0.00,0.00,0.00,0.00),('21','224','3','102',2843,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','102',2844,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','102',2845,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','102',2846,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','102',2847,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','102',2848,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','102',2849,'29','2',1078671.18,1082944.11,4272.93,3546531.90,0.00,0.00,0.00,0.00,0.00),('21','224','4','102',2850,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','102',2851,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','102',2852,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','102',2853,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','102',2854,'34','3',653187.64,653979.20,791.56,593670.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','102',2855,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','102',2856,'36','1',1923066.15,1925776.96,2710.81,447283.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','103',2857,'1','1',1651738.11,1654138.85,2400.74,396122.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','103',2858,'2','1',1784215.91,1788004.98,3789.07,625196.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','103',2859,'3','1',1483102.66,1489690.59,6587.93,1087008.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','103',2860,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','103',2861,'5','1',1374347.00,1377398.00,3051.00,503415.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','103',2862,'6','1',1852810.35,1856459.68,3649.33,602139.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','103',2863,'7','1',1683820.99,1688363.34,4542.35,749487.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','103',2864,'8','1',1443249.47,1446557.16,3307.69,545768.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','103',2865,'9','1',1711470.62,1715000.12,3529.50,582367.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','103',2866,'10','1',1906798.14,1909870.58,3072.44,506952.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','103',2867,'13','1',1675168.69,1678854.29,3685.60,608124.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','103',2868,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','103',2869,'15','1',1594085.22,1597424.55,3339.33,550989.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','103',2870,'16','1',1661809.68,1664104.29,2294.61,378610.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','103',2871,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','103',2872,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','103',2873,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','103',2874,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','103',2875,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','103',2876,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','103',2877,'29','2',1082944.11,1090945.67,8001.56,6641294.80,0.00,0.00,0.00,0.00,0.00),('21','224','4','103',2878,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','103',2879,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','103',2880,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','103',2881,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','103',2882,'34','3',653979.20,655025.65,1046.45,784837.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','103',2883,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','103',2884,'36','1',1925776.96,1929227.55,3450.59,569347.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','104',2885,'1','1',1654138.85,1659029.44,4625.35,763182.75,0.00,0.00,265.24,0.00,0.00),('21','224','1','104',2886,'2','1',1788004.98,1793138.15,5133.17,846973.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','104',2887,'3','1',1489690.59,1497853.18,8162.59,1346827.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','104',2888,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','104',2889,'5','1',1377398.00,1381392.00,3994.00,659010.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','104',2890,'6','1',1856459.68,1861193.72,4734.04,781116.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','104',2891,'7','1',1688363.34,1694416.54,6053.20,998778.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','104',2892,'8','1',1446557.16,1450831.62,4274.46,705285.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','104',2893,'9','1',1715000.12,1715487.41,487.29,80402.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','104',2894,'10','1',1909870.58,1910233.82,363.24,59934.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','104',2895,'13','1',1678854.29,1679485.68,631.39,104179.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','104',2896,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','104',2897,'15','1',1597424.55,1598039.32,614.77,101437.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','104',2898,'16','1',1664104.29,1664865.93,761.64,125670.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','104',2899,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','104',2900,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','104',2901,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','104',2902,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','104',2903,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','104',2904,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','104',2905,'29','2',1090945.67,1096671.25,5705.16,4735282.80,0.00,0.00,20.42,0.00,0.00),('21','224','4','104',2906,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','104',2907,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','104',2908,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','104',2909,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','104',2910,'34','3',655025.65,656015.38,969.29,726967.50,0.00,0.00,20.44,0.00,0.00),('21','224','2','104',2911,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','104',2912,'36','1',1929227.55,1929704.46,476.91,78690.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','105',2913,'1','1',1659029.44,1663973.78,4944.34,815816.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','105',2914,'2','1',1793138.15,1798216.69,5078.54,837959.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','105',2915,'3','1',1497853.18,1504959.77,7106.59,1172587.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','105',2916,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','105',2917,'5','1',1381392.00,1385416.00,4024.00,663960.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','105',2918,'6','1',1861193.72,1865676.46,4482.74,739652.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','105',2919,'7','1',1694416.54,1699502.23,5085.69,839138.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','105',2920,'8','1',1450831.62,1455957.97,5126.35,845847.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','105',2921,'9','1',1715487.41,1716836.91,1349.50,222667.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','105',2922,'10','1',1910233.82,1911027.60,793.78,130973.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','105',2923,'13','1',1679485.68,1680798.84,1313.16,216671.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','105',2924,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','105',2925,'15','1',1598039.32,1599381.85,1342.53,221517.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','105',2926,'16','1',1664865.93,1666088.93,1223.00,201795.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','105',2927,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','105',2928,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','105',2929,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','105',2930,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','105',2931,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','105',2932,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','105',2933,'29','2',1096671.25,1100327.91,3656.66,3035027.80,0.00,0.00,0.00,0.00,0.00),('21','224','4','105',2934,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','105',2935,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','105',2936,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','105',2937,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','105',2938,'34','3',656015.38,657186.47,1171.09,878317.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','105',2939,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','105',2940,'36','1',1929704.46,1931184.57,1480.11,244218.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','106',2941,'1','1',1663973.78,1667833.65,3859.87,636878.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','106',2942,'2','1',1798216.69,1802215.88,3999.19,659866.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','106',2943,'3','1',1504959.77,1510568.48,5608.71,925437.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','106',2944,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','106',2945,'5','1',1385416.00,1388279.00,2863.00,472395.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','106',2946,'6','1',1865676.46,1869349.51,3673.05,606053.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','106',2947,'7','1',1699502.23,1703705.38,4203.15,693519.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','106',2948,'8','1',1455957.97,1458891.53,2933.56,484037.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','106',2949,'9','1',1716836.91,1719269.92,2433.01,401446.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','106',2950,'10','1',1911027.60,1913120.49,2092.89,345326.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','106',2951,'13','1',1680798.84,1683715.41,2916.57,481234.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','106',2952,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','106',2953,'15','1',1599381.85,1601507.24,2125.39,350689.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','106',2954,'16','1',1666088.93,1668417.64,2328.71,384237.15,0.00,0.00,0.00,0.00,0.00),('21','224','3','106',2955,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','106',2956,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','106',2957,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','106',2958,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','106',2959,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','106',2960,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','106',2961,'29','2',1100327.91,1104908.93,4581.02,3802246.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','106',2962,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','106',2963,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','106',2964,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','106',2965,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','106',2966,'34','3',657186.47,658083.52,897.05,672787.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','106',2967,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','106',2968,'36','1',1931184.57,1933902.24,2717.67,448415.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','107',2969,'1','1',1667833.65,1670549.83,2716.18,448169.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','107',2970,'2','1',1802215.88,1804635.25,2419.37,399196.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','107',2971,'3','1',1510568.48,1516377.44,5808.96,958478.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','107',2972,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','107',2973,'5','1',1388279.00,1390911.00,2632.00,434280.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','107',2974,'6','1',1869349.51,1871814.45,2464.94,406715.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','107',2975,'7','1',1703705.38,1706827.07,3121.69,515078.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','107',2976,'8','1',1458891.53,1461000.58,2109.05,347993.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','107',2977,'9','1',1719269.92,1720763.06,1493.14,246368.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','107',2978,'10','1',1913120.49,1913631.02,510.53,84237.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','107',2979,'13','1',1683715.41,1685216.04,1500.63,247603.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','107',2980,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','107',2981,'15','1',1601507.24,1602419.57,912.33,150534.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','107',2982,'16','1',1668417.64,1669784.78,1367.14,225578.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','107',2983,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','107',2984,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','107',2985,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','107',2986,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','107',2987,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','107',2988,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','107',2989,'29','2',1104908.93,1128693.31,23784.38,19741035.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','107',2990,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','107',2991,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','107',2992,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','107',2993,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','107',2994,'34','3',658083.52,658840.63,757.11,567832.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','107',2995,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','107',2996,'36','1',1933902.24,1935807.18,1904.94,314315.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','108',2997,'1','1',1670549.83,1671212.83,479.38,79097.70,0.00,0.00,183.62,0.00,0.00),('21','224','1','108',2998,'2','1',1804635.25,1804635.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','108',2999,'3','1',1516377.44,1517060.67,683.23,112732.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','108',3000,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','108',3001,'5','1',1390911.00,1390911.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','108',3002,'6','1',1871814.45,1872378.06,563.61,92995.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','108',3003,'7','1',1706827.07,1707387.99,560.92,92551.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','108',3004,'8','1',1461000.58,1461000.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','108',3005,'9','1',1720763.06,1721718.23,955.17,157603.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','108',3006,'10','1',1913631.02,1913636.22,5.20,858.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','108',3007,'13','1',1685216.04,1686387.70,1171.66,193323.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','108',3008,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','108',3009,'15','1',1602419.57,1603149.61,730.04,120456.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','108',3010,'16','1',1669784.78,1670509.05,724.27,119504.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','108',3011,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','108',3012,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','108',3013,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','108',3014,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','108',3015,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','108',3016,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','108',3017,'29','2',1128693.31,1139925.39,11211.64,9305661.20,0.00,0.00,20.44,0.00,0.00),('21','224','4','108',3018,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','108',3019,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','108',3020,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','108',3021,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','108',3022,'34','3',658840.63,659904.74,1043.71,782782.50,0.00,0.00,20.40,0.00,0.00),('21','224','2','108',3023,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','108',3024,'36','1',1935807.18,1936722.16,914.98,150971.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','109',3025,'1','1',1671212.83,1676311.68,5054.00,833910.00,0.00,0.00,44.85,0.00,0.00),('21','224','1','109',3026,'2','1',1804635.25,1810557.96,5922.71,977247.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','109',3027,'3','1',1517060.67,1526843.24,9782.57,1614124.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','109',3028,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','109',3029,'5','1',1390911.00,1394629.00,3718.00,613470.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','109',3030,'6','1',1872378.06,1877387.71,5009.65,826592.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','109',3031,'7','1',1707387.99,1713427.84,6039.85,996575.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','109',3032,'8','1',1461000.58,1466252.18,5251.60,866514.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','109',3033,'9','1',1721718.23,1726370.12,4651.89,767561.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','109',3034,'10','1',1913636.22,1914752.25,1116.03,184144.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','109',3035,'13','1',1686387.70,1690981.89,4594.19,758041.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','109',3036,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','109',3037,'15','1',1603149.61,1605915.06,2765.45,456299.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','109',3038,'16','1',1670509.05,1673733.89,3224.84,532098.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','109',3039,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','109',3040,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','109',3041,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','109',3042,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','109',3043,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','109',3044,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','109',3045,'29','2',1139925.39,1143391.62,3466.23,2876970.90,0.00,0.00,0.00,0.00,0.00),('21','224','4','109',3046,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','109',3047,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','109',3048,'32','2',13067.45,13067.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','109',3049,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','109',3050,'34','3',659904.74,660712.24,807.50,605625.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','109',3051,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','109',3052,'36','1',1936722.16,1940896.66,4174.50,688792.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','110',3053,'1','1',1676311.68,1681285.01,4973.33,820599.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','110',3054,'2','1',1810557.96,1815769.98,5212.02,859983.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','110',3055,'3','1',1526843.24,1534751.98,7908.74,1304942.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','110',3056,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','110',3057,'5','1',1394629.00,1398527.00,3898.00,643170.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','110',3058,'6','1',1877387.71,1882791.71,5404.00,891660.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','110',3059,'7','1',1713427.84,1719203.88,5776.04,953046.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','110',3060,'8','1',1466252.18,1471022.91,4770.73,787170.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','110',3061,'9','1',1726370.12,1729979.40,3609.28,595531.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','110',3062,'10','1',1914752.25,1918479.05,3726.80,614922.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','110',3063,'13','1',1690981.89,1695909.47,4927.58,813050.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','110',3064,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','110',3065,'15','1',1605915.06,1609410.06,3495.00,576675.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','110',3066,'16','1',1673733.89,1677282.43,3548.54,585509.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','110',3067,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','110',3068,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','110',3069,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','110',3070,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','110',3071,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','110',3072,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','110',3073,'29','2',1143391.62,1143391.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','110',3074,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','110',3075,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','110',3076,'32','2',13067.45,16725.73,3658.28,3036372.40,0.00,0.00,0.00,0.00,0.00),('21','224','6','110',3077,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','110',3078,'34','3',660712.24,661777.98,1065.74,799305.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','110',3079,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','110',3080,'36','1',1940896.66,1945476.48,4579.82,755670.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','111',3081,'1','1',1681285.01,1684810.27,3525.26,581667.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','111',3082,'2','1',1815769.98,1819909.23,4139.25,682976.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','111',3083,'3','1',1534751.98,1541649.80,6897.82,1138140.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','111',3084,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','111',3085,'5','1',1398527.00,1401331.00,2804.00,462660.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','111',3086,'6','1',1882791.71,1886443.89,3652.18,602609.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','111',3087,'7','1',1719203.88,1723936.56,4732.68,780892.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','111',3088,'8','1',1471022.91,1475028.15,4005.24,660864.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','111',3089,'9','1',1729979.40,1732354.47,2375.07,391886.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','111',3090,'10','1',1918479.05,1920585.48,2106.43,347560.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','111',3091,'13','1',1695909.47,1698921.67,3012.20,497013.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','111',3092,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','111',3093,'15','1',1609410.06,1612125.51,2715.45,448049.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','111',3094,'16','1',1677282.43,1679275.10,1992.67,328790.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','111',3095,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','111',3096,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','111',3097,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','111',3098,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','111',3099,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','111',3100,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','111',3101,'29','2',1143391.62,1143391.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','111',3102,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','111',3103,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','111',3104,'32','2',16725.73,21678.16,4952.43,4110516.90,0.00,0.00,0.00,0.00,0.00),('21','224','6','111',3105,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','111',3106,'34','3',661777.98,662647.46,869.48,652110.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','111',3107,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','111',3108,'36','1',1945476.48,1948421.43,2944.95,485916.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','112',3109,'1','1',1684810.27,1689025.07,4214.80,695442.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','112',3110,'2','1',1819909.23,1822869.91,2960.68,488512.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','112',3111,'3','1',1541649.80,1541649.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','112',3112,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','112',3113,'5','1',1401331.00,1403663.00,2332.00,384780.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','112',3114,'6','1',1886443.89,1889656.72,3212.83,530116.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','112',3115,'7','1',1723936.56,1727719.97,3783.41,624262.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','112',3116,'8','1',1475028.15,1477544.50,2516.35,415197.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','112',3117,'9','1',1732354.47,1734061.75,1707.28,281701.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','112',3118,'10','1',1920585.48,1922461.34,1875.86,309516.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','112',3119,'13','1',1698921.67,1701425.82,2504.15,413184.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','112',3120,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','112',3121,'15','1',1612125.51,1613670.72,1545.21,254959.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','112',3122,'16','1',1679275.10,1681435.51,2160.41,356467.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','112',3123,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','112',3124,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','112',3125,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','112',3126,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','112',3127,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','112',3128,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','112',3129,'29','2',1143391.62,1147532.87,4141.25,3437237.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','112',3130,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','112',3131,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','112',3132,'32','2',21678.16,25459.37,3781.21,3138404.30,0.00,0.00,0.00,0.00,0.00),('21','224','6','112',3133,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','112',3134,'34','3',662647.46,663382.46,735.00,551250.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','112',3135,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','112',3136,'36','1',1948421.43,1950891.06,2469.63,407488.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','113',3137,'1','1',1689025.07,1695248.95,6223.88,1026940.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','113',3138,'2','1',1822869.91,1828320.69,5450.78,899378.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','113',3139,'3','1',1541649.80,1557568.72,15918.92,2626621.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','113',3140,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','113',3141,'5','1',1403663.00,1406406.00,2743.00,452595.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','113',3142,'6','1',1889656.72,1893974.65,4317.93,712458.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','113',3143,'7','1',1727719.97,1733488.81,5768.84,951858.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','113',3144,'8','1',1477544.50,1482175.06,4630.56,764042.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','113',3145,'9','1',1734061.75,1737597.90,3536.15,583464.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','113',3146,'10','1',1922461.34,1925530.47,3069.13,506406.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','113',3147,'13','1',1701425.82,1705820.56,4394.74,725132.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','113',3148,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','113',3149,'15','1',1613670.72,1616813.19,3142.47,518507.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','113',3150,'16','1',1681435.51,1684072.14,2636.63,435043.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','113',3151,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','113',3152,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','113',3153,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','113',3154,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','113',3155,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','113',3156,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','113',3157,'29','2',1147532.87,1148955.39,1422.52,1180691.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','113',3158,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','113',3159,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','113',3160,'32','2',25459.37,31199.77,5740.40,4764532.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','113',3161,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','113',3162,'34','3',663382.46,664551.82,1169.36,877020.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','113',3163,'35','1',1073534.65,1073534.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','113',3164,'36','1',1950891.06,1954366.21,3475.15,573399.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','114',3165,'1','1',1695248.95,1698885.68,3583.68,591307.20,0.00,0.00,53.05,0.00,0.00),('21','224','1','114',3166,'2','1',1828320.69,1831151.41,2830.72,467068.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','114',3167,'3','1',1557568.72,1564079.69,6510.97,1074310.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','114',3168,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','114',3169,'5','1',1406406.00,1408683.00,2277.00,375705.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','114',3170,'6','1',1893974.65,1896787.78,2813.13,464166.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','114',3171,'7','1',1733488.81,1737034.00,3545.19,584956.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','114',3172,'8','1',1482175.06,1484718.95,2543.89,419741.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','114',3173,'9','1',1737597.90,1741387.63,3789.73,625305.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','114',3174,'10','1',1925530.47,1928911.00,3380.53,557787.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','114',3175,'13','1',1705820.56,1710707.24,4886.68,806302.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','114',3176,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','114',3177,'15','1',1616813.19,1620604.17,3790.98,625511.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','114',3178,'16','1',1684072.14,1687593.69,3521.55,581055.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','114',3179,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','114',3180,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','114',3181,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','114',3182,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','114',3183,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','114',3184,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','114',3185,'29','2',1148955.39,1153254.39,4299.00,3568170.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','114',3186,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','114',3187,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','114',3188,'32','2',31199.77,32952.54,1752.77,1454799.10,0.00,0.00,0.00,0.00,0.00),('21','224','6','114',3189,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','114',3190,'34','3',664551.82,668402.88,3851.06,2888295.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','114',3191,'35','1',1073534.65,1073534.77,0.12,19.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','114',3192,'36','1',1954366.21,1958842.68,4476.47,738617.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','115',3193,'1','1',1698885.68,1705032.88,6147.20,1014288.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','115',3194,'2','1',1831151.41,1835030.61,3879.20,640068.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','115',3195,'3','1',1564079.69,1572099.94,8020.25,1323341.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','115',3196,'4','1',911872.25,911872.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','115',3197,'5','1',1408683.00,1412058.00,3375.00,556875.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','115',3198,'6','1',1896787.78,1900794.24,4006.46,661065.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','115',3199,'7','1',1737034.00,1741837.65,4803.65,792602.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','115',3200,'8','1',1484718.95,1488736.01,4017.06,662814.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','115',3201,'9','1',1741387.63,1744422.84,3035.21,500809.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','115',3202,'10','1',1928911.00,1931196.49,2285.49,377105.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','115',3203,'13','1',1710707.24,1714564.74,3857.50,636487.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','115',3204,'14','1',1536453.64,1536453.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','115',3205,'15','1',1620604.17,1621992.48,1388.31,229071.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','115',3206,'16','1',1687593.69,1690884.52,3290.83,542986.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','115',3207,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','115',3208,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','115',3209,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','115',3210,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','115',3211,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','115',3212,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','115',3213,'29','2',1153254.39,1162428.11,9173.72,7614187.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','115',3214,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','115',3215,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','115',3216,'32','2',32952.54,32961.89,9.35,7760.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','115',3217,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','115',3218,'34','3',668402.88,668402.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','115',3219,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','115',3220,'36','1',1958842.68,1962360.17,3517.49,580385.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','116',3221,'1','1',1705032.88,1708557.59,3524.71,581577.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','116',3222,'2','1',1835030.61,1837357.85,2327.24,383994.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','116',3223,'3','1',1572099.94,1577436.50,5336.56,880532.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','116',3224,'4','1',911872.25,911878.50,6.25,1031.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','116',3225,'5','1',1412058.00,1414719.00,2661.00,439065.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','116',3226,'6','1',1900794.24,1903008.20,2213.96,365303.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','116',3227,'7','1',1741837.65,1743962.21,2124.56,350552.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','116',3228,'8','1',1488736.01,1491433.26,2697.25,445046.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','116',3229,'9','1',1744422.84,1745105.13,682.29,112577.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','116',3230,'10','1',1931196.49,1932428.09,1231.60,203214.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','116',3231,'13','1',1714564.74,1716143.18,1578.44,260442.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','116',3232,'14','1',1536453.64,1536453.93,0.29,47.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','116',3233,'15','1',1621992.48,1623376.95,1384.47,228437.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','116',3234,'16','1',1690884.52,1692217.56,1333.04,219951.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','116',3235,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','116',3236,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','116',3237,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','116',3238,'22','3',943315.50,943315.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','116',3239,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','116',3240,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','116',3241,'29','2',1162428.11,1166253.01,3824.90,3174667.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','116',3242,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','116',3243,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','116',3244,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','116',3245,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','116',3246,'34','3',668402.88,668402.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','116',3247,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','116',3248,'36','1',1962360.17,1963724.93,1364.76,225185.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','117',3249,'1','1',1708557.59,1713453.66,4896.07,807851.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','117',3250,'2','1',1837357.85,1842402.60,5044.75,832383.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','117',3251,'3','1',1577436.50,1586109.76,8673.26,1431087.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','117',3252,'4','1',911878.50,911878.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','117',3253,'5','1',1414719.00,1417723.00,3004.00,495660.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','117',3254,'6','1',1903008.20,1906479.06,3470.86,572691.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','117',3255,'7','1',1743962.21,1748678.11,4715.90,778123.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','117',3256,'8','1',1491433.26,1491489.96,56.70,9355.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','117',3257,'9','1',1745105.13,1746730.26,1625.13,268146.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','117',3258,'10','1',1932428.09,1934847.56,2419.47,399212.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','117',3259,'13','1',1716143.18,1718996.28,2853.10,470761.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','117',3260,'14','1',1536453.93,1536453.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','117',3261,'15','1',1623376.95,1626010.05,2633.10,434461.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','117',3262,'16','1',1692217.56,1694858.57,2641.01,435766.65,0.00,0.00,0.00,0.00,0.00),('21','224','3','117',3263,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','117',3264,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','117',3265,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','117',3266,'22','3',943315.50,943315.95,0.45,337.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','117',3267,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','117',3268,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','117',3269,'29','2',1166253.01,1172381.00,6127.99,5086231.70,0.00,0.00,0.00,0.00,0.00),('21','224','4','117',3270,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','117',3271,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','117',3272,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','117',3273,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','117',3274,'34','3',668402.88,668441.22,38.34,28755.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','117',3275,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','117',3276,'36','1',1963724.93,1966630.04,2905.11,479343.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','118',3277,'1','1',1713453.66,1718085.47,4631.81,764248.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','118',3278,'2','1',1842402.60,1846812.17,4409.57,727579.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','118',3279,'3','1',1586109.76,1593476.67,7366.91,1215540.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','118',3280,'4','1',911878.50,911878.55,0.05,8.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','118',3281,'5','1',1417723.00,1420268.00,2545.00,419925.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','118',3282,'6','1',1906479.06,1909242.13,2763.07,455906.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','118',3283,'7','1',1748678.11,1753097.13,4419.02,729138.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','118',3284,'8','1',1491489.96,1491552.08,62.12,10249.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','118',3285,'9','1',1746730.26,1748916.06,2185.80,360657.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','118',3286,'10','1',1934847.56,1936481.39,1633.83,269581.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','118',3287,'13','1',1718996.28,1722037.31,3041.03,501769.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','118',3288,'14','1',1536453.93,1536453.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','118',3289,'15','1',1626010.05,1627821.53,1811.48,298894.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','118',3290,'16','1',1694858.57,1696821.12,1962.55,323820.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','118',3291,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','118',3292,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','118',3293,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','118',3294,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','118',3295,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','118',3296,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','118',3297,'29','2',1172381.00,1176033.94,3652.94,3031940.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','118',3298,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','118',3299,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','118',3300,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','118',3301,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','118',3302,'34','3',668441.22,669116.35,675.13,506347.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','118',3303,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','118',3304,'36','1',1966630.04,1969556.37,2926.33,482844.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','119',3305,'1','1',1718085.47,1722235.56,4150.09,684764.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','119',3306,'2','1',1846812.17,1851969.67,5157.50,850987.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','119',3307,'3','1',1593476.67,1601738.53,8261.86,1363206.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','119',3308,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','119',3309,'5','1',1420268.00,1423529.00,3261.00,538065.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','119',3310,'6','1',1909242.13,1912428.86,3186.73,525810.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','119',3311,'7','1',1753097.13,1759165.32,6068.19,1001251.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','119',3312,'8','1',1491552.08,1491552.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','119',3313,'9','1',1748916.06,1751488.12,2572.06,424389.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','119',3314,'10','1',1936481.39,1938535.24,2053.85,338885.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','119',3315,'13','1',1722037.31,1725189.13,3151.82,520050.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','119',3316,'14','1',1536453.93,1536453.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','119',3317,'15','1',1627821.53,1630016.46,2194.93,362163.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','119',3318,'16','1',1696821.12,1698774.25,1953.13,322266.45,0.00,0.00,0.00,0.00,0.00),('21','224','3','119',3319,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','119',3320,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','119',3321,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','119',3322,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','119',3323,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','119',3324,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','119',3325,'29','2',1176033.94,1178720.43,2686.49,2229786.70,0.00,0.00,0.00,0.00,0.00),('21','224','4','119',3326,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','119',3327,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','119',3328,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','119',3329,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','119',3330,'34','3',669116.35,670080.04,963.69,722767.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','119',3331,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','119',3332,'36','1',1969556.37,1972810.26,3253.89,536891.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','120',3333,'1','1',1722235.56,1727310.60,5075.04,837381.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','120',3334,'2','1',1851969.67,1856193.11,4223.44,696867.60,0.00,0.00,0.00,0.00,0.00),('21','224','1','120',3335,'3','1',1601738.53,1608964.05,7225.52,1192210.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','120',3336,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','120',3337,'5','1',1423529.00,1426888.00,3359.00,554235.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','120',3338,'6','1',1912428.86,1916041.33,3612.47,596057.55,0.00,0.00,0.00,0.00,0.00),('21','224','1','120',3339,'7','1',1759165.32,1761448.41,2283.09,376709.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','120',3340,'8','1',1491552.08,1496015.09,4463.01,736396.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','120',3341,'9','1',1751488.12,1753871.22,2383.10,393211.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','120',3342,'10','1',1938535.24,1940561.45,2026.21,334324.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','120',3343,'13','1',1725189.13,1728702.24,3513.11,579663.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','120',3344,'14','1',1536453.93,1536453.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','120',3345,'15','1',1630016.46,1632094.93,2078.47,342947.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','120',3346,'16','1',1698774.25,1700857.94,2083.69,343808.85,0.00,0.00,0.00,0.00,0.00),('21','224','3','120',3347,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','120',3348,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','120',3349,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','120',3350,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','120',3351,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','120',3352,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','120',3353,'29','2',1178720.43,1178720.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','120',3354,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','120',3355,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','120',3356,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','120',3357,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','120',3358,'34','3',670080.04,670815.34,735.30,551475.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','120',3359,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','120',3360,'36','1',1972810.26,1975774.57,2964.31,489111.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','121',3361,'1','1',1727310.60,1728059.53,748.93,123573.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','121',3362,'2','1',1856193.11,1856446.10,252.99,41743.35,0.00,0.00,0.00,0.00,0.00),('21','224','1','121',3363,'3','1',1608964.05,1619269.57,10305.52,1700410.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','121',3364,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','121',3365,'5','1',1426888.00,1431742.00,4854.00,800910.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','121',3366,'6','1',1916041.33,1921249.23,5207.90,859303.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','121',3367,'7','1',1761448.41,1769659.53,8211.12,1354834.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','121',3368,'8','1',1496015.09,1496492.85,477.76,78830.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','121',3369,'9','1',1753871.22,1756157.32,2286.10,377206.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','121',3370,'10','1',1940561.45,1942707.24,2145.79,354055.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','121',3371,'13','1',1728702.24,1731899.79,3197.55,527595.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','121',3372,'14','1',1536453.93,1536453.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','121',3373,'15','1',1632094.93,1634454.11,2359.18,389264.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','121',3374,'16','1',1700857.94,1703386.68,2528.74,417242.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','121',3375,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','121',3376,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','121',3377,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','121',3378,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','121',3379,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','121',3380,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','121',3381,'29','2',1178720.43,1185586.27,6865.84,5698647.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','121',3382,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','121',3383,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','121',3384,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','121',3385,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','121',3386,'34','3',670815.34,671747.95,932.61,699457.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','121',3387,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','121',3388,'36','1',1975774.57,1978301.65,2527.08,416968.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','122',3389,'1','1',1728059.53,1728059.81,0.28,46.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','122',3390,'2','1',1856446.10,1856446.40,0.30,49.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','122',3391,'3','1',1619269.57,1631267.72,11998.15,1979694.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','122',3392,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','122',3393,'5','1',1431742.00,1436942.00,5200.00,858000.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','122',3394,'6','1',1921249.23,1927155.86,5906.63,974593.95,0.00,0.00,0.00,0.00,0.00),('21','224','1','122',3395,'7','1',1769659.53,1779408.24,9748.71,1608537.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','122',3396,'8','1',1496492.85,1496493.05,0.20,33.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','122',3397,'9','1',1756157.32,1760126.41,3969.09,654899.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','122',3398,'10','1',1942707.24,1942708.98,1.74,287.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','122',3399,'13','1',1731899.79,1736121.20,4221.41,696532.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','122',3400,'14','1',1536453.93,1536454.40,0.47,77.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','122',3401,'15','1',1634454.11,1637105.73,2651.62,437517.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','122',3402,'16','1',1703386.68,1706448.57,3061.89,505211.85,0.00,0.00,0.00,0.00,0.00),('21','224','3','122',3403,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','122',3404,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','122',3405,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','122',3406,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','122',3407,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','122',3408,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','122',3409,'29','2',1185586.27,1187643.13,2056.86,1707193.80,0.00,0.00,0.00,0.00,0.00),('21','224','4','122',3410,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','122',3411,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','122',3412,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','122',3413,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','122',3414,'34','3',671747.95,674635.68,2887.73,2165797.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','122',3415,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','122',3416,'36','1',1978301.65,1981732.91,3431.26,566157.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','123',3417,'1','1',1728059.81,1728059.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','123',3418,'2','1',1856446.40,1856446.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','123',3419,'3','1',1631267.72,1631267.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','123',3420,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','123',3421,'5','1',1436942.00,1436942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','123',3422,'6','1',1927155.86,1927155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','123',3423,'7','1',1779408.24,1779408.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','123',3424,'8','1',1496493.05,1496493.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','123',3425,'9','1',1760126.41,1760126.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','123',3426,'10','1',1942708.98,1942708.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','123',3427,'13','1',1736121.20,1736121.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','123',3428,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','123',3429,'15','1',1637105.73,1637105.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','123',3430,'16','1',1706448.57,1706448.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','123',3431,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','123',3432,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','123',3433,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','123',3434,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','123',3435,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','123',3436,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','123',3437,'29','2',1187643.13,1188531.40,888.27,737264.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','123',3438,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','123',3439,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','123',3440,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','123',3441,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','123',3442,'34','3',674635.68,675353.45,717.77,538327.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','123',3443,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','123',3444,'36','1',1981732.91,1981732.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','124',3445,'1','1',1728059.81,1728059.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','124',3446,'2','1',1856446.40,1856446.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','124',3447,'3','1',1631267.72,1631267.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','124',3448,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','124',3449,'5','1',1436942.00,1436942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','124',3450,'6','1',1927155.86,1927155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','124',3451,'7','1',1779408.24,1779408.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','124',3452,'8','1',1496493.05,1496493.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','124',3453,'9','1',1760126.41,1760126.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','124',3454,'10','1',1942708.98,1942708.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','124',3455,'13','1',1736121.20,1736121.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','124',3456,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','124',3457,'15','1',1637105.73,1637105.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','124',3458,'16','1',1706448.57,1706448.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','124',3459,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','124',3460,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','124',3461,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','124',3462,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','124',3463,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','124',3464,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','124',3465,'29','2',1188531.40,1188531.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','124',3466,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','124',3467,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','124',3468,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','124',3469,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','124',3470,'34','3',675353.45,675353.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','124',3471,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','124',3472,'36','1',1981732.91,1981732.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','125',3473,'1','1',1728059.81,1728059.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','125',3474,'2','1',1856446.40,1856446.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','125',3475,'3','1',1631267.72,1631267.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','125',3476,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','125',3477,'5','1',1436942.00,1436942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','125',3478,'6','1',1927155.86,1927155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','125',3479,'7','1',1779408.24,1779408.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','125',3480,'8','1',1496493.05,1496493.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','125',3481,'9','1',1760126.41,1760126.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','125',3482,'10','1',1942708.98,1942708.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','125',3483,'13','1',1736121.20,1736121.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','125',3484,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','125',3485,'15','1',1637105.73,1637105.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','125',3486,'16','1',1706448.57,1706448.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','125',3487,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','125',3488,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','125',3489,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','125',3490,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','125',3491,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','125',3492,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','125',3493,'29','2',1188531.40,1188531.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','125',3494,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','125',3495,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','125',3496,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','125',3497,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','125',3498,'34','3',675353.45,675353.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','125',3499,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','125',3500,'36','1',1981732.91,1981732.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','126',3501,'1','1',1728059.81,1728059.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','126',3502,'2','1',1856446.40,1856446.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','126',3503,'3','1',1631267.72,1631267.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','126',3504,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','126',3505,'5','1',1436942.00,1436942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','126',3506,'6','1',1927155.86,1927155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','126',3507,'7','1',1779408.24,1779408.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','126',3508,'8','1',1496493.05,1496493.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','126',3509,'9','1',1760126.41,1760126.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','126',3510,'10','1',1942708.98,1942708.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','126',3511,'13','1',1736121.20,1736121.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','126',3512,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','126',3513,'15','1',1637105.73,1637105.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','126',3514,'16','1',1706448.57,1706448.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','126',3515,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','126',3516,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','126',3517,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','126',3518,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','126',3519,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','126',3520,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','126',3521,'29','2',1188531.40,1188531.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','126',3522,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','126',3523,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','126',3524,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','126',3525,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','126',3526,'34','3',675353.45,675353.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','126',3527,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','126',3528,'36','1',1981732.91,1981732.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','127',3529,'1','1',1728059.81,1728059.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','127',3530,'2','1',1856446.40,1856446.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','127',3531,'3','1',1631267.72,1631267.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','127',3532,'4','1',911878.55,911878.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','127',3533,'5','1',1436942.00,1436942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','127',3534,'6','1',1927155.86,1927155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','127',3535,'7','1',1779408.24,1779408.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','127',3536,'8','1',1496493.05,1496493.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','127',3537,'9','1',1760126.41,1760126.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','127',3538,'10','1',1942708.98,1942708.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','127',3539,'13','1',1736121.20,1736121.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','127',3540,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','127',3541,'15','1',1637105.73,1637105.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','127',3542,'16','1',1706448.57,1706448.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','127',3543,'17','1',1436413.64,1436413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','127',3544,'18','1',1464621.25,1464621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','127',3545,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','127',3546,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','127',3547,'25','1',1213491.69,1213491.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','127',3548,'26','1',1383701.83,1383701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','127',3549,'29','2',1188531.40,1188531.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','127',3550,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','127',3551,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','127',3552,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','127',3553,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','127',3554,'34','3',675353.45,675353.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','127',3555,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','127',3556,'36','1',1981732.91,1981732.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','128',3557,'1','1',1728059.81,1728060.00,0.19,35.15,0.00,0.00,0.00,0.00,0.00),('21','224','1','128',3558,'2','1',1856446.40,1856446.53,0.13,24.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','128',3559,'3','1',1631267.72,1640193.69,8925.97,1651304.45,0.00,0.00,0.00,0.00,0.00),('21','224','1','128',3560,'4','1',911878.55,911878.73,0.18,33.30,0.00,0.00,0.00,0.00,0.00),('21','224','1','128',3561,'5','1',1436942.00,1441648.00,4706.00,870610.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','128',3562,'6','1',1927155.86,1933559.28,6403.42,1184632.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','128',3563,'7','1',1779408.24,1787280.06,7871.82,1456286.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','128',3564,'8','1',1496493.05,1496493.98,0.93,172.05,0.00,0.00,0.00,0.00,0.00),('21','224','2','128',3565,'9','1',1760126.41,1764978.98,4852.57,897725.45,0.00,0.00,0.00,0.00,0.00),('21','224','2','128',3566,'10','1',1942708.98,1945819.49,3110.51,575444.35,0.00,0.00,0.00,0.00,0.00),('21','224','2','128',3567,'13','1',1736121.20,1742918.99,6797.79,1257591.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','128',3568,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','128',3569,'15','1',1637105.73,1641153.87,4048.14,748905.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','128',3570,'16','1',1706448.57,1711655.23,5206.66,963232.10,0.00,0.00,0.00,0.00,0.00),('21','224','3','128',3571,'17','1',1436413.64,1442929.82,6516.18,1205493.30,0.00,0.00,0.00,0.00,0.00),('21','224','3','128',3572,'18','1',1464621.25,1472259.14,7637.89,1413009.65,0.00,0.00,0.00,0.00,0.00),('21','224','6','128',3573,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','128',3574,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','128',3575,'25','1',1213491.69,1223370.46,9878.77,1827572.45,0.00,0.00,0.00,0.00,0.00),('21','224','3','128',3576,'26','1',1383701.83,1383930.82,228.99,42363.15,0.00,0.00,0.00,0.00,0.00),('21','224','4','128',3577,'29','2',1188531.40,1191161.65,2630.25,2183107.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','128',3578,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','128',3579,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','128',3580,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','128',3581,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','128',3582,'34','3',675353.45,675948.72,595.27,446452.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','128',3583,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','128',3584,'36','1',1981732.91,1987302.33,5569.42,1030342.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','129',3585,'1','1',1728060.00,1728060.14,0.14,23.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','129',3586,'2','1',1856446.53,1856446.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','129',3587,'3','1',1640193.69,1647199.59,7005.90,1155973.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','129',3588,'4','1',911878.73,911878.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','129',3589,'5','1',1441648.00,1445767.00,4119.00,679635.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','129',3590,'6','1',1933559.28,1938893.77,5334.49,880190.85,0.00,0.00,0.00,0.00,0.00),('21','224','1','129',3591,'7','1',1787280.06,1793568.24,6288.18,1037549.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','129',3592,'8','1',1496493.98,1496494.16,0.18,29.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','129',3593,'9','1',1764978.98,1770986.04,6007.06,991164.90,0.00,0.00,0.00,0.00,0.00),('21','224','2','129',3594,'10','1',1945819.49,1952007.05,6187.56,1020947.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','129',3595,'13','1',1742918.99,1751581.21,8662.22,1429266.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','129',3596,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','129',3597,'15','1',1641153.87,1646612.11,5458.24,900609.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','129',3598,'16','1',1711655.23,1717206.05,5550.82,915885.30,0.00,0.00,0.00,0.00,0.00),('21','224','3','129',3599,'17','1',1442929.82,1449315.01,6385.19,1053556.35,0.00,0.00,0.00,0.00,0.00),('21','224','3','129',3600,'18','1',1472259.14,1479019.40,6760.26,1115442.90,0.00,0.00,0.00,0.00,0.00),('21','224','6','129',3601,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','129',3602,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','129',3603,'25','1',1223370.46,1227513.37,4142.91,683580.15,0.00,0.00,0.00,0.00,0.00),('21','224','3','129',3604,'26','1',1383930.82,1391075.38,7144.56,1178852.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','129',3605,'29','2',1191161.65,1192995.87,1834.22,1522402.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','129',3606,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','129',3607,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','129',3608,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','129',3609,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','129',3610,'34','3',675948.72,677146.89,1198.17,898627.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','129',3611,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','129',3612,'36','1',1987302.33,1994523.90,7221.57,1191559.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','130',3613,'1','1',1728060.14,1728060.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','130',3614,'2','1',1856446.53,1856446.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','130',3615,'3','1',1647199.59,1654110.14,6910.55,1140240.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','130',3616,'4','1',911878.73,911878.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','130',3617,'5','1',1445767.00,1448911.00,3144.00,518760.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','130',3618,'6','1',1938893.77,1944434.34,5540.57,914194.05,0.00,0.00,0.00,0.00,0.00),('21','224','1','130',3619,'7','1',1793568.24,1800402.32,6834.08,1127623.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','130',3620,'8','1',1496494.16,1496494.63,0.47,77.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','130',3621,'9','1',1770986.04,1775525.18,4539.14,748958.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','130',3622,'10','1',1952007.05,1956593.40,4586.35,756747.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','130',3623,'13','1',1751581.21,1759225.48,7644.27,1261304.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','130',3624,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','130',3625,'15','1',1646612.11,1651933.01,5320.90,877948.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','130',3626,'16','1',1717206.05,1722397.60,5191.55,856605.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','130',3627,'17','1',1449315.01,1455049.67,5734.66,946218.90,0.00,0.00,0.00,0.00,0.00),('21','224','3','130',3628,'18','1',1479019.40,1484855.48,5836.08,962953.20,0.00,0.00,0.00,0.00,0.00),('21','224','6','130',3629,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','130',3630,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','130',3631,'25','1',1227513.37,1233015.69,5502.32,907882.80,0.00,0.00,0.00,0.00,0.00),('21','224','3','130',3632,'26','1',1391075.38,1396518.64,5443.26,898137.90,0.00,0.00,0.00,0.00,0.00),('21','224','4','130',3633,'29','2',1192995.87,1195282.39,2286.52,1897811.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','130',3634,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','130',3635,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','130',3636,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','130',3637,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','130',3638,'34','3',677146.89,677661.03,514.14,385605.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','130',3639,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','130',3640,'36','1',1994523.90,2000181.71,5657.81,933538.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','131',3641,'1','1',1728060.14,1728060.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','131',3642,'2','1',1856446.53,1856446.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','131',3643,'3','1',1654110.14,1663879.28,9769.14,1807290.90,0.00,0.00,0.00,0.00,0.00),('21','224','1','131',3644,'4','1',911878.73,911878.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','131',3645,'5','1',1448911.00,1453351.00,4440.00,821400.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','131',3646,'6','1',1944434.34,1951203.98,6769.64,1252383.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','131',3647,'7','1',1800402.32,1809116.94,8714.62,1612204.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','131',3648,'8','1',1496494.63,1496495.01,0.38,70.30,0.00,0.00,0.00,0.00,0.00),('21','224','2','131',3649,'9','1',1775525.18,1778018.40,2493.22,461245.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','131',3650,'10','1',1956593.40,1959137.79,2544.39,470712.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','131',3651,'13','1',1759225.48,1762241.88,3016.40,558034.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','131',3652,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','131',3653,'15','1',1651933.01,1654220.93,2287.92,423265.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','131',3654,'16','1',1722397.60,1724612.07,2214.47,409676.95,0.00,0.00,0.00,0.00,0.00),('21','224','3','131',3655,'17','1',1455049.67,1461298.85,6249.18,1156098.30,0.00,0.00,0.00,0.00,0.00),('21','224','3','131',3656,'18','1',1484855.48,1491078.18,6222.70,1151199.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','131',3657,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','131',3658,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','131',3659,'25','1',1233015.69,1237894.80,4879.11,902635.35,0.00,0.00,0.00,0.00,0.00),('21','224','3','131',3660,'26','1',1396518.64,1403752.70,7234.06,1338301.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','131',3661,'29','2',1195282.39,1198626.67,3344.28,2775752.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','131',3662,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','131',3663,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','131',3664,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','131',3665,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','131',3666,'34','3',677661.03,678449.84,788.81,591607.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','131',3667,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','131',3668,'36','1',2000181.71,2003328.75,3147.04,582202.40,0.00,0.00,0.00,0.00,0.00),('21','224','1','132',3669,'1','1',1728060.14,1728060.82,0.68,125.80,0.00,0.00,0.00,0.00,0.00),('21','224','1','132',3670,'2','1',1856446.53,1856446.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','132',3671,'3','1',1663879.28,1667567.17,3687.89,682259.65,0.00,0.00,0.00,0.00,0.00),('21','224','1','132',3672,'4','1',911878.73,911878.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','132',3673,'5','1',1453351.00,1455297.00,1946.00,360010.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','132',3674,'6','1',1951203.98,1953944.50,2740.52,506996.20,0.00,0.00,0.00,0.00,0.00),('21','224','1','132',3675,'7','1',1809116.94,1812660.36,3543.42,655532.70,0.00,0.00,0.00,0.00,0.00),('21','224','1','132',3676,'8','1',1496495.01,1496495.47,0.46,85.10,0.00,0.00,0.00,0.00,0.00),('21','224','2','132',3677,'9','1',1778018.40,1783891.95,5873.55,1086606.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','132',3678,'10','1',1959137.79,1963795.22,4657.43,861624.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','132',3679,'13','1',1762241.88,1767472.87,5230.99,967733.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','132',3680,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','132',3681,'15','1',1654220.93,1659400.23,5179.30,958170.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','132',3682,'16','1',1724612.07,1728402.50,3790.43,701229.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','132',3683,'17','1',1461298.85,1467449.65,6150.80,1137898.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','132',3684,'18','1',1491078.18,1496517.86,5439.68,1006340.80,0.00,0.00,0.00,0.00,0.00),('21','224','6','132',3685,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','132',3686,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','132',3687,'25','1',1237894.80,1242854.03,4959.23,917457.55,0.00,0.00,0.00,0.00,0.00),('21','224','3','132',3688,'26','1',1403752.70,1410091.40,6338.70,1172659.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','132',3689,'29','2',1198626.67,1202575.46,3948.79,3277495.70,0.00,0.00,0.00,0.00,0.00),('21','224','4','132',3690,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','132',3691,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','132',3692,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','132',3693,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','132',3694,'34','3',678449.84,679128.24,678.40,508800.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','132',3695,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','132',3696,'36','1',2003328.75,2008842.01,5513.26,1019953.10,0.00,0.00,0.00,0.00,0.00),('21','224','1','133',3697,'1','1',1728060.82,1728061.00,0.18,31.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','133',3698,'2','1',1856446.53,1856446.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','133',3699,'3','1',1667567.17,1673545.82,5978.65,1046263.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','133',3700,'4','1',911878.73,911878.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','133',3701,'5','1',1455297.00,1458461.00,3164.00,553700.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','133',3702,'6','1',1953944.50,1958309.72,4365.22,763913.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','133',3703,'7','1',1812660.36,1817415.57,4755.21,832161.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','133',3704,'8','1',1496495.47,1496495.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','133',3705,'9','1',1783891.95,1787671.70,3779.75,661456.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','133',3706,'10','1',1963795.22,1967603.65,3808.43,666475.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','133',3707,'13','1',1767472.87,1773699.53,6226.66,1089665.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','133',3708,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','133',3709,'15','1',1659400.23,1664376.32,4976.09,870815.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','133',3710,'16','1',1728402.50,1728432.49,29.99,5248.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','133',3711,'17','1',1467449.65,1469748.25,2298.60,402255.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','133',3712,'18','1',1496517.86,1498348.17,1830.31,320304.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','133',3713,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','133',3714,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','133',3715,'25','1',1242854.03,1244830.54,1976.51,345889.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','133',3716,'26','1',1410091.40,1411766.48,1675.08,293139.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','133',3717,'29','2',1202575.46,1205911.76,3336.30,2769129.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','133',3718,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','133',3719,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','133',3720,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','133',3721,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','133',3722,'34','3',679128.24,680242.33,1114.09,835567.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','133',3723,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','133',3724,'36','1',2008842.01,2013596.52,4754.51,832039.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','134',3725,'1','1',1728061.00,1731529.16,3468.16,606928.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','134',3726,'2','1',1856446.53,1860143.16,3696.63,646910.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','134',3727,'3','1',1673545.82,1673545.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','134',3728,'4','1',911878.73,911878.93,0.20,35.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','134',3729,'5','1',1458461.00,1463505.00,5044.00,882700.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','134',3730,'6','1',1958309.72,1963987.00,5677.28,993524.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','134',3731,'7','1',1817415.57,1823377.49,5961.92,1043336.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','134',3732,'8','1',1496495.47,1496520.94,25.47,4457.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','134',3733,'9','1',1787671.70,1789821.63,2149.93,376237.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','134',3734,'10','1',1967603.65,1970207.01,2603.36,455588.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','134',3735,'13','1',1773699.53,1777455.79,3756.26,657345.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','134',3736,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','134',3737,'15','1',1664376.32,1667453.27,3076.95,538466.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','134',3738,'16','1',1728432.49,1728433.92,1.43,250.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','134',3739,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','134',3740,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','134',3741,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','134',3742,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','134',3743,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','134',3744,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','134',3745,'29','2',1205911.76,1207108.59,1196.83,993368.90,0.00,0.00,0.00,0.00,0.00),('21','224','4','134',3746,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','134',3747,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','134',3748,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','134',3749,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','134',3750,'34','3',680242.33,681082.07,839.74,629805.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','134',3751,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','134',3752,'36','1',2013596.52,2016041.30,2444.78,427836.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','135',3753,'1','1',1731529.16,1735385.22,3856.06,674810.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','135',3754,'2','1',1860143.16,1863683.74,3540.58,619601.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','135',3755,'3','1',1673545.82,1685979.73,12433.91,2175934.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','135',3756,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','135',3757,'5','1',1463505.00,1466078.00,2573.00,450275.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','135',3758,'6','1',1963987.00,1966891.62,2904.62,508308.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','135',3759,'7','1',1823377.49,1827770.97,4393.48,768859.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','135',3760,'8','1',1496520.94,1496730.68,209.74,36704.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','135',3761,'9','1',1789821.63,1790634.40,812.77,142234.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','135',3762,'10','1',1970207.01,1971047.69,840.68,147119.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','135',3763,'13','1',1777455.79,1778855.55,1399.76,244958.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','135',3764,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','135',3765,'15','1',1667453.27,1668462.12,1008.85,176548.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','135',3766,'16','1',1728433.92,1729295.77,861.85,150823.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','135',3767,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','135',3768,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','135',3769,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','135',3770,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','135',3771,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','135',3772,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','135',3773,'29','2',1207108.59,1215134.57,8025.98,6661563.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','135',3774,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','135',3775,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','135',3776,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','135',3777,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','135',3778,'34','3',681082.07,681784.10,702.03,526522.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','135',3779,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','135',3780,'36','1',2016041.30,2017308.62,1267.32,221781.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','136',3781,'1','1',1735385.22,1740807.07,5421.85,948823.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','136',3782,'2','1',1863683.74,1864979.11,1295.37,226689.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','136',3783,'3','1',1685979.73,1689888.59,3908.86,684050.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','136',3784,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','136',3785,'5','1',1466078.00,1468265.00,2187.00,382725.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','136',3786,'6','1',1966891.62,1970122.76,3231.14,565449.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','136',3787,'7','1',1827770.97,1831847.17,4076.20,713335.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','136',3788,'8','1',1496730.68,1496730.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','136',3789,'9','1',1790634.40,1792325.93,1691.53,296017.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','136',3790,'10','1',1971047.69,1973880.39,2832.70,495722.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','136',3791,'13','1',1778855.55,1782241.28,3385.73,592502.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','136',3792,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','136',3793,'15','1',1668462.12,1670482.37,2020.25,353543.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','136',3794,'16','1',1729295.77,1731822.56,2526.79,442188.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','136',3795,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','136',3796,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','136',3797,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','136',3798,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','136',3799,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','136',3800,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','136',3801,'29','2',1215134.57,1240163.90,25029.33,20774343.90,0.00,0.00,0.00,0.00,0.00),('21','224','4','136',3802,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','136',3803,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','136',3804,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','136',3805,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','136',3806,'34','3',681784.10,682379.61,595.51,446632.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','136',3807,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','136',3808,'36','1',2017308.62,2020495.32,3186.70,557672.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','137',3809,'1','1',1740807.07,1747704.80,6897.73,1207102.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','137',3810,'2','1',1864979.11,1865069.36,90.25,15793.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','137',3811,'3','1',1689888.59,1696744.94,6856.35,1199861.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','137',3812,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','137',3813,'5','1',1468265.00,1471629.00,3364.00,588700.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','137',3814,'6','1',1970122.76,1974348.27,4225.51,739464.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','137',3815,'7','1',1831847.17,1836909.20,5062.03,885855.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','137',3816,'8','1',1496730.68,1499522.46,2791.78,488561.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','137',3817,'9','1',1792325.93,1795314.78,2988.85,523048.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','137',3818,'10','1',1973880.39,1977713.60,3833.21,670811.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','137',3819,'13','1',1782241.28,1786566.53,4325.25,756918.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','137',3820,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','137',3821,'15','1',1670482.37,1673466.97,2984.60,522305.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','137',3822,'16','1',1731822.56,1734923.49,3100.93,542662.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','137',3823,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','137',3824,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','137',3825,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','137',3826,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','137',3827,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','137',3828,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','137',3829,'29','2',1240163.90,1245104.01,4940.11,4100291.30,0.00,0.00,0.00,0.00,0.00),('21','224','4','137',3830,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','137',3831,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','137',3832,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','137',3833,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','137',3834,'34','3',682379.61,683173.04,793.43,595072.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','137',3835,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','137',3836,'36','1',2020495.32,2024243.78,3748.46,655980.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','138',3837,'1','1',1747704.80,1753872.69,6167.89,1079380.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','138',3838,'2','1',1865069.36,1865968.51,899.15,157351.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','138',3839,'3','1',1696744.94,1699780.56,3035.62,531233.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','138',3840,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','138',3841,'5','1',1471629.00,1473023.00,1394.00,243950.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','138',3842,'6','1',1974348.27,1976090.97,1742.70,304972.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','138',3843,'7','1',1836909.20,1841381.22,4472.02,782603.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','138',3844,'8','1',1499522.46,1503786.91,4264.45,746278.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','138',3845,'9','1',1795314.78,1797012.75,1697.97,297144.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','138',3846,'10','1',1977713.60,1979919.49,2205.89,386030.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','138',3847,'13','1',1786566.53,1789117.41,2550.88,446404.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','138',3848,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','138',3849,'15','1',1673466.97,1673487.39,20.42,3573.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','138',3850,'16','1',1734923.49,1734933.69,10.20,1785.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','138',3851,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','138',3852,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','138',3853,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','138',3854,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','138',3855,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','138',3856,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','138',3857,'29','2',1245104.01,1245104.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','138',3858,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','138',3859,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','138',3860,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','138',3861,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','138',3862,'34','3',683173.04,684424.64,1251.60,938700.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','138',3863,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','138',3864,'36','1',2024243.78,2026687.86,2444.08,427714.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','139',3865,'1','1',1753872.69,1760384.89,6512.20,1139635.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','139',3866,'2','1',1865968.51,1867717.91,1749.40,306145.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','139',3867,'3','1',1699780.56,1705893.08,6112.52,1069691.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','139',3868,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','139',3869,'5','1',1473023.00,1476028.00,3005.00,525875.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','139',3870,'6','1',1976090.97,1979888.30,3797.33,664532.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','139',3871,'7','1',1841381.22,1846999.52,5618.30,983202.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','139',3872,'8','1',1503786.91,1508575.68,4788.77,838034.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','139',3873,'9','1',1797012.75,1799518.90,2506.15,438576.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','139',3874,'10','1',1979919.49,1982471.83,2552.34,446659.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','139',3875,'13','1',1789117.41,1792374.25,3256.84,569947.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','139',3876,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','139',3877,'15','1',1673487.39,1676286.55,2799.16,489853.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','139',3878,'16','1',1734933.69,1737180.70,2247.01,393226.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','139',3879,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','139',3880,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','139',3881,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','139',3882,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','139',3883,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','139',3884,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','139',3885,'29','2',1245104.01,1249642.67,4538.66,3767087.80,0.00,0.00,0.00,0.00,0.00),('21','224','4','139',3886,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','139',3887,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','139',3888,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','139',3889,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','139',3890,'34','3',684424.64,684424.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','139',3891,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','139',3892,'36','1',2026687.86,2030238.43,3550.57,621349.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','140',3893,'1','1',1760384.89,1766251.50,5866.61,1026656.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','140',3894,'2','1',1867717.91,1873448.35,5730.44,1002827.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','140',3895,'3','1',1705893.08,1714206.28,8313.20,1454810.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','140',3896,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','140',3897,'5','1',1476028.00,1480387.00,4359.00,762825.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','140',3898,'6','1',1979888.30,1985491.81,5603.51,980614.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','140',3899,'7','1',1846999.52,1853134.10,6134.58,1073551.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','140',3900,'8','1',1508575.68,1513802.44,5226.76,914683.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','140',3901,'9','1',1799518.90,1803020.40,3501.50,612762.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','140',3902,'10','1',1982471.83,1985678.45,3206.62,561158.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','140',3903,'13','1',1792374.25,1795847.31,3473.06,607785.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','140',3904,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','140',3905,'15','1',1676286.55,1679168.61,2882.06,504360.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','140',3906,'16','1',1737180.70,1740669.60,3488.90,610557.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','140',3907,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','140',3908,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','140',3909,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','140',3910,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','140',3911,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','140',3912,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','140',3913,'29','2',1249642.67,1252709.03,3066.36,2499083.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','140',3914,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','140',3915,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','140',3916,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','140',3917,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','140',3918,'34','3',684424.64,685775.17,1350.53,1012897.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','140',3919,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','140',3920,'36','1',2030238.43,2033879.11,3640.68,637119.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','141',3921,'1','1',1766251.50,1769081.00,2829.50,495162.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','141',3922,'2','1',1873448.35,1875460.38,2012.03,352105.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','141',3923,'3','1',1714206.28,1716799.83,2593.55,453871.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','141',3924,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','141',3925,'5','1',1480387.00,1481948.00,1561.00,273175.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','141',3926,'6','1',1985491.81,1987635.77,2143.96,375193.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','141',3927,'7','1',1853134.10,1854984.42,1850.32,323806.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','141',3928,'8','1',1513802.44,1516327.67,2525.23,441915.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','141',3929,'9','1',1803020.40,1805917.67,2897.27,507022.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','141',3930,'10','1',1985678.45,1988957.57,3279.12,573846.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','141',3931,'13','1',1795847.31,1799120.53,3273.22,572813.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','141',3932,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','141',3933,'15','1',1679168.61,1681972.09,2803.48,490609.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','141',3934,'16','1',1740669.60,1743890.30,3220.70,563622.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','141',3935,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','141',3936,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','141',3937,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','141',3938,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','141',3939,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','141',3940,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','141',3941,'29','2',1252709.03,1254296.51,1587.48,1293796.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','141',3942,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','141',3943,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','141',3944,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','141',3945,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','141',3946,'34','3',685775.17,686407.33,632.16,474120.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','141',3947,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','141',3948,'36','1',2033879.11,2037404.46,3525.35,616936.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','142',3949,'1','1',1769081.00,1771567.33,2486.33,435107.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','142',3950,'2','1',1875460.38,1878331.55,2871.17,502454.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','142',3951,'3','1',1716799.83,1719320.82,2520.99,441173.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','142',3952,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','142',3953,'5','1',1481948.00,1483835.00,1887.00,330225.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','142',3954,'6','1',1987635.77,1989897.53,2261.76,395808.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','142',3955,'7','1',1854984.42,1857489.10,2504.68,438319.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','142',3956,'8','1',1516327.67,1518574.66,2246.99,393223.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','142',3957,'9','1',1805917.67,1809705.40,3787.73,662852.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','142',3958,'10','1',1988957.57,1992622.88,3665.31,641429.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','142',3959,'13','1',1799120.53,1804285.49,5164.96,903868.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','142',3960,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','142',3961,'15','1',1681972.09,1685504.53,3532.44,618177.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','142',3962,'16','1',1743890.30,1748076.21,4185.91,732534.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','142',3963,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','142',3964,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','142',3965,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','142',3966,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','142',3967,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','142',3968,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','142',3969,'29','2',1254296.51,1257487.21,3190.70,2600420.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','142',3970,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','142',3971,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','142',3972,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','142',3973,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','142',3974,'34','3',686407.33,687485.77,1078.44,808830.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','142',3975,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','142',3976,'36','1',2037404.46,2042586.28,5181.82,906818.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','143',3977,'1','1',1771567.33,1771567.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','143',3978,'2','1',1878331.55,1878331.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','143',3979,'3','1',1719320.82,1719320.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','143',3980,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','143',3981,'5','1',1483835.00,1483835.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','143',3982,'6','1',1989897.53,1989897.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','143',3983,'7','1',1857489.10,1857489.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','143',3984,'8','1',1518574.66,1518574.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','143',3985,'9','1',1809705.40,1809705.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','143',3986,'10','1',1992622.88,1992622.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','143',3987,'13','1',1804285.49,1804285.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','143',3988,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','143',3989,'15','1',1685504.53,1685504.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','143',3990,'16','1',1748076.21,1748076.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','143',3991,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','143',3992,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','143',3993,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','143',3994,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','143',3995,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','143',3996,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','143',3997,'29','2',1257487.21,1257487.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','143',3998,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','143',3999,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','143',4000,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','143',4001,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','143',4002,'34','3',687485.77,687485.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','143',4003,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','143',4004,'36','1',2042586.28,2042586.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','144',4005,'1','1',1771567.33,1775194.44,3627.11,634744.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','144',4006,'2','1',1878331.55,1882511.97,4180.42,731573.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','144',4007,'3','1',1719320.82,1725026.32,5705.50,998462.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','144',4008,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','144',4009,'5','1',1483835.00,1487074.00,3239.00,566825.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','144',4010,'6','1',1989897.53,1993148.54,3251.01,568926.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','144',4011,'7','1',1857489.10,1861620.90,4131.80,723065.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','144',4012,'8','1',1518574.66,1522078.63,3503.97,613194.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','144',4013,'9','1',1809705.40,1815733.42,6028.02,1054903.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','144',4014,'10','1',1992622.88,1998438.86,5815.98,1017796.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','144',4015,'13','1',1804285.49,1811164.87,6879.38,1203891.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','144',4016,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','144',4017,'15','1',1685504.53,1691244.30,5739.77,1004459.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','144',4018,'16','1',1748076.21,1753390.87,5314.66,930065.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','144',4019,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','144',4020,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','144',4021,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','144',4022,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','144',4023,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','144',4024,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','144',4025,'29','2',1257487.21,1260435.46,2948.25,2388082.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','144',4026,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','144',4027,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','144',4028,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','144',4029,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','144',4030,'34','3',687485.77,688236.40,750.63,562972.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','144',4031,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','144',4032,'36','1',2042586.28,2049123.29,6537.01,1143976.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','145',4033,'1','1',1775194.44,1779275.15,4080.71,714124.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','145',4034,'2','1',1882511.97,1886632.73,4120.76,721133.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','145',4035,'3','1',1725026.32,1730361.65,5335.33,933682.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','145',4036,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','145',4037,'5','1',1487074.00,1490240.00,3166.00,554050.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','145',4038,'6','1',1993148.54,1996993.25,3844.71,672824.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','145',4039,'7','1',1861620.90,1865837.65,4216.75,737931.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','145',4040,'8','1',1522078.63,1525512.37,3433.74,600904.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','145',4041,'9','1',1815733.42,1818136.18,2402.76,420483.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','145',4042,'10','1',1998438.86,2000497.09,2058.23,360190.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','145',4043,'13','1',1811164.87,1814002.38,2837.51,496564.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','145',4044,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','145',4045,'15','1',1691244.30,1693164.77,1920.47,336082.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','145',4046,'16','1',1753390.87,1755638.31,2247.44,393302.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','145',4047,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','145',4048,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','145',4049,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','145',4050,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','145',4051,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','145',4052,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','145',4053,'29','2',1260435.46,1263462.62,3027.16,2451999.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','145',4054,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','145',4055,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','145',4056,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','145',4057,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','145',4058,'34','3',688236.40,688878.85,642.45,481837.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','145',4059,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','145',4060,'36','1',2049123.29,2051794.00,2670.71,467374.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','146',4061,'1','1',1779275.15,1784438.13,5162.98,903521.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','146',4062,'2','1',1886632.73,1891310.79,4678.06,818660.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','146',4063,'3','1',1730361.65,1737441.17,7079.52,1238916.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','146',4064,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','146',4065,'5','1',1490240.00,1494152.00,3912.00,684600.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','146',4066,'6','1',1996993.25,2001801.99,4808.74,841529.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','146',4067,'7','1',1865837.65,1870411.32,4573.67,800392.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','146',4068,'8','1',1525512.37,1530345.59,4833.22,845813.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','146',4069,'9','1',1818136.18,1820649.97,2513.79,439913.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','146',4070,'10','1',2000497.09,2003079.86,2582.77,451984.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','146',4071,'13','1',1814002.38,1817360.15,3357.77,587609.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','146',4072,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','146',4073,'15','1',1693164.77,1695609.98,2445.21,427911.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','146',4074,'16','1',1755638.31,1758661.87,3023.56,529123.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','146',4075,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','146',4076,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','146',4077,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','146',4078,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','146',4079,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','146',4080,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','146',4081,'29','2',1263462.62,1264959.73,1497.11,1212659.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','146',4082,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','146',4083,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','146',4084,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','146',4085,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','146',4086,'34','3',688878.85,689349.63,470.78,353085.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','146',4087,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','146',4088,'36','1',2051794.00,2055465.76,3671.76,642558.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','147',4089,'1','1',1784438.13,1788556.80,4118.67,720767.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','147',4090,'2','1',1891310.79,1894498.09,3187.30,557777.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','147',4091,'3','1',1737441.17,1742292.77,4851.60,849030.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','147',4092,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','147',4093,'5','1',1494152.00,1497334.00,3182.00,556850.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','147',4094,'6','1',2001801.99,2005071.31,3269.32,572131.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','147',4095,'7','1',1870411.32,1873965.87,3554.55,622046.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','147',4096,'8','1',1530345.59,1533300.60,2955.01,517126.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','147',4097,'9','1',1820649.97,1822106.56,1456.59,254903.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','147',4098,'10','1',2003079.86,2004273.19,1193.33,208832.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','147',4099,'13','1',1817360.15,1818454.88,1094.73,191577.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','147',4100,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','147',4101,'15','1',1695609.98,1696535.18,925.20,161910.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','147',4102,'16','1',1758661.87,1759435.05,773.18,135306.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','147',4103,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','147',4104,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','147',4105,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','147',4106,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','147',4107,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','147',4108,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','147',4109,'29','2',1264959.73,1267986.15,3026.42,2451400.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','147',4110,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','147',4111,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','147',4112,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','147',4113,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','147',4114,'34','3',689349.63,690559.86,1210.23,907672.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','147',4115,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','147',4116,'36','1',2055465.76,2056845.24,1379.48,241409.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','148',4117,'1','1',1788556.80,1792825.28,4213.28,737324.00,0.00,0.00,55.20,0.00,0.00),('21','224','1','148',4118,'2','1',1894498.09,1897379.98,2881.89,504330.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','148',4119,'3','1',1742292.77,1747713.88,5421.11,948694.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','148',4120,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','148',4121,'5','1',1497334.00,1499812.00,2478.00,433650.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','148',4122,'6','1',2005071.31,2008468.55,3397.24,594517.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','148',4123,'7','1',1873965.87,1877047.94,3082.07,539362.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','148',4124,'8','1',1533300.60,1537281.27,3980.67,696617.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','148',4125,'9','1',1822106.56,1823721.68,1615.12,282646.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','148',4126,'10','1',2004273.19,2005874.99,1601.80,280315.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','148',4127,'13','1',1818454.88,1820662.77,2207.89,386380.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','148',4128,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','148',4129,'15','1',1696535.18,1698337.12,1801.94,315339.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','148',4130,'16','1',1759435.05,1760852.69,1417.64,248087.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','148',4131,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','148',4132,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','148',4133,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','148',4134,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','148',4135,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','148',4136,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','148',4137,'29','2',1267986.15,1271875.54,3889.39,3150405.90,0.00,0.00,0.00,0.00,0.00),('21','224','4','148',4138,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','148',4139,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','148',4140,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','148',4141,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','148',4142,'34','3',690559.86,691242.00,682.14,511605.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','148',4143,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','148',4144,'36','1',2056845.24,2059072.18,2226.94,389714.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','149',4145,'1','1',1792825.28,1797551.13,4725.85,827023.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','149',4146,'2','1',1897379.98,1900802.78,3422.80,598990.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','149',4147,'3','1',1747713.88,1753970.05,6256.17,1094829.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','149',4148,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','149',4149,'5','1',1499812.00,1502572.00,2760.00,483000.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','149',4150,'6','1',2008468.55,2012602.71,4134.16,723478.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','149',4151,'7','1',1877047.94,1881127.50,4079.56,713923.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','149',4152,'8','1',1537281.27,1541818.27,4537.00,793975.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','149',4153,'9','1',1823721.68,1826014.54,2292.86,401250.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','149',4154,'10','1',2005874.99,2007963.24,2088.25,365443.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','149',4155,'13','1',1820662.77,1823292.53,2629.76,460208.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','149',4156,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','149',4157,'15','1',1698337.12,1701260.45,2923.33,511582.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','149',4158,'16','1',1760852.69,1763439.18,2586.49,452635.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','149',4159,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','149',4160,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','149',4161,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','149',4162,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','149',4163,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','149',4164,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','149',4165,'29','2',1271875.54,1273033.21,1157.67,937712.70,0.00,0.00,0.00,0.00,0.00),('21','224','4','149',4166,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','149',4167,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','149',4168,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','149',4169,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','149',4170,'34','3',691242.00,692150.49,908.49,758589.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','149',4171,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','149',4172,'36','1',2059072.18,2061603.60,2531.42,442998.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','150',4173,'1','1',1797551.13,1802084.96,4533.83,793420.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','150',4174,'2','1',1900802.78,1904998.63,4195.85,734273.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','150',4175,'3','1',1753970.05,1759285.44,5315.39,930193.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','150',4176,'4','1',911878.93,911878.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','150',4177,'5','1',1502572.00,1506174.00,3602.00,630350.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','150',4178,'6','1',2012602.71,2016861.42,4258.71,745274.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','150',4179,'7','1',1881127.50,1885010.79,3883.29,679575.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','150',4180,'8','1',1541818.27,1545921.34,4103.07,718037.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','150',4181,'9','1',1826014.54,1828477.66,2463.12,431046.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','150',4182,'10','1',2007963.24,2009846.22,1882.98,329521.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','150',4183,'13','1',1823292.53,1826307.21,3014.68,527569.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','150',4184,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','150',4185,'15','1',1701260.45,1703642.16,2381.71,416799.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','150',4186,'16','1',1763439.18,1765454.29,2015.11,352644.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','150',4187,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','150',4188,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','150',4189,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','150',4190,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','150',4191,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','150',4192,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','150',4193,'29','2',1273033.21,1276227.95,3194.74,2587739.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','150',4194,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','150',4195,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','150',4196,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','150',4197,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','150',4198,'34','3',692150.49,693243.44,1092.95,912613.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','150',4199,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','150',4200,'36','1',2061603.60,2064655.49,3051.89,534080.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','151',4201,'1','1',1802084.96,1806699.82,4614.86,807600.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','151',4202,'2','1',1904998.63,1908665.61,3666.98,641721.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','151',4203,'3','1',1759285.44,1765601.14,6315.70,1105247.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','151',4204,'4','1',911878.93,911879.18,0.25,43.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','151',4205,'5','1',1506174.00,1508841.00,2667.00,466725.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','151',4206,'6','1',2016861.42,2021035.47,4174.05,730458.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','151',4207,'7','1',1885010.79,1889501.71,4490.92,785911.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','151',4208,'8','1',1545921.34,1549348.10,3426.76,599683.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','151',4209,'9','1',1828477.66,1830884.67,2407.01,421226.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','151',4210,'10','1',2009846.22,2011816.70,1970.48,344834.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','151',4211,'13','1',1826307.21,1829873.44,3566.23,624090.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','151',4212,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','151',4213,'15','1',1703642.16,1705516.32,1874.16,327978.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','151',4214,'16','1',1765454.29,1768226.38,2772.09,485115.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','151',4215,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','151',4216,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','151',4217,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','151',4218,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','151',4219,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','151',4220,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','151',4221,'29','2',1276227.95,1278754.20,2526.25,2046262.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','151',4222,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','151',4223,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','151',4224,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','151',4225,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','151',4226,'34','3',693243.44,693972.52,729.08,608781.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','151',4227,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','151',4228,'36','1',2064655.49,2067660.71,3005.22,525913.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','152',4229,'1','1',1806699.82,1811373.70,4673.88,817929.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','152',4230,'2','1',1908665.61,1912300.70,3635.09,636140.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','152',4231,'3','1',1765601.14,1771849.29,6248.15,1093426.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','152',4232,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','152',4233,'5','1',1508841.00,1512093.00,3252.00,569100.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','152',4234,'6','1',2021035.47,2024959.57,3924.10,686717.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','152',4235,'7','1',1889501.71,1893359.64,3857.93,675137.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','152',4236,'8','1',1549348.10,1553907.38,4559.28,797874.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','152',4237,'9','1',1830884.67,1833766.92,2882.25,504393.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','152',4238,'10','1',2011816.70,2011869.72,53.02,9278.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','152',4239,'13','1',1829873.44,1833734.93,3861.49,675760.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','152',4240,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','152',4241,'15','1',1705516.32,1707758.68,2242.36,392413.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','152',4242,'16','1',1768226.38,1770650.08,2423.70,424147.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','152',4243,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','152',4244,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','152',4245,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','152',4246,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','152',4247,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','152',4248,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','152',4249,'29','2',1278754.20,1280236.74,1482.54,1200857.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','152',4250,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','152',4251,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','152',4252,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','152',4253,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','152',4254,'34','3',693972.52,695154.54,1182.02,986986.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','152',4255,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','152',4256,'36','1',2067660.71,2071375.80,3715.09,650140.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','153',4257,'1','1',1811373.70,1815680.44,4306.74,753679.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','153',4258,'2','1',1912300.70,1916444.74,4144.04,725207.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','153',4259,'3','1',1771849.29,1778043.03,6193.74,1083904.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','153',4260,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','153',4261,'5','1',1512093.00,1515248.00,3155.00,552125.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','153',4262,'6','1',2024959.57,2028721.25,3761.68,658294.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','153',4263,'7','1',1893359.64,1897410.73,4051.09,708940.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','153',4264,'8','1',1553907.38,1558044.76,4137.38,724041.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','153',4265,'9','1',1833766.92,1836397.43,2630.51,460339.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','153',4266,'10','1',2011869.72,2013995.34,2125.62,371983.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','153',4267,'13','1',1833734.93,1836970.72,3235.79,566263.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','153',4268,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','153',4269,'15','1',1707758.68,1709851.96,2093.28,366324.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','153',4270,'16','1',1770650.08,1773084.00,2433.92,425936.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','153',4271,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','153',4272,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','153',4273,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','153',4274,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','153',4275,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','153',4276,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','153',4277,'29','2',1280236.74,1282134.80,1898.06,1537428.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','153',4278,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','153',4279,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','153',4280,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','153',4281,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','153',4282,'34','3',695154.54,695725.73,571.19,476943.65,0.00,0.00,0.00,0.00,0.00),('21','224','2','153',4283,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','153',4284,'36','1',2071375.80,2073911.18,2535.38,443691.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','154',4285,'1','1',1815680.44,1821876.69,6196.25,1084343.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','154',4286,'2','1',1916444.74,1918635.39,2190.65,383363.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','154',4287,'3','1',1778043.03,1784522.88,6479.85,1133973.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','154',4288,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','154',4289,'5','1',1515248.00,1517903.00,2655.00,464625.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','154',4290,'6','1',2028721.25,2032507.90,3786.65,662663.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','154',4291,'7','1',1897410.73,1902241.73,4831.00,845425.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','154',4292,'8','1',1558044.76,1562012.37,3967.61,694331.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','154',4293,'9','1',1836397.43,1838592.18,2065.43,361450.25,0.00,0.00,129.32,0.00,0.00),('21','224','2','154',4294,'10','1',2013995.34,2016157.63,2162.29,378400.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','154',4295,'13','1',1836970.72,1839578.53,2607.81,456366.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','154',4296,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','154',4297,'15','1',1709851.96,1712791.76,2939.80,514465.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','154',4298,'16','1',1773084.00,1775839.41,2755.41,482196.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','154',4299,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','154',4300,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','154',4301,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','154',4302,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','154',4303,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','154',4304,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','154',4305,'29','2',1282134.80,1286038.44,3903.64,3161948.40,0.00,0.00,0.00,0.00,0.00),('21','224','4','154',4306,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','154',4307,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','154',4308,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','154',4309,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','154',4310,'34','3',695725.73,696497.06,771.33,644060.55,0.00,0.00,0.00,0.00,0.00),('21','224','2','154',4311,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','154',4312,'36','1',2073911.18,2076272.06,2360.88,413154.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','155',4313,'1','1',1821876.69,1826671.61,4794.92,839111.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','155',4314,'2','1',1918635.39,1921301.73,2666.34,466609.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','155',4315,'3','1',1784522.88,1791745.71,7222.83,1263995.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','155',4316,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','155',4317,'5','1',1517903.00,1521099.00,3196.00,559300.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','155',4318,'6','1',2032507.90,2036659.47,4151.57,726524.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','155',4319,'7','1',1902241.73,1905612.96,3371.23,589965.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','155',4320,'8','1',1562012.37,1566721.26,4708.89,824055.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','155',4321,'9','1',1838592.18,1841383.70,2791.52,488516.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','155',4322,'10','1',2016157.63,2017592.18,1434.55,251046.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','155',4323,'13','1',1839578.53,1842663.26,3084.73,539827.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','155',4324,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','155',4325,'15','1',1712791.76,1715474.50,2682.74,469479.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','155',4326,'16','1',1775839.41,1778032.65,2193.24,383817.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','155',4327,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','155',4328,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','155',4329,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','155',4330,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','155',4331,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','155',4332,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','155',4333,'29','2',1286038.44,1291583.99,5545.55,4491895.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','155',4334,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','155',4335,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','155',4336,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','155',4337,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','155',4338,'34','3',696497.06,697848.63,1351.57,1128560.95,0.00,0.00,0.00,0.00,0.00),('21','224','2','155',4339,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','155',4340,'36','1',2076272.06,2079146.93,2874.87,503102.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','156',4341,'1','1',1826671.61,1830974.50,4302.89,753005.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','156',4342,'2','1',1921301.73,1924733.95,3432.22,600638.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','156',4343,'3','1',1791745.71,1798407.18,6661.47,1165757.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','156',4344,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','156',4345,'5','1',1521099.00,1524479.00,3380.00,591500.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','156',4346,'6','1',2036659.47,2040709.38,4049.91,708734.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','156',4347,'7','1',1905612.96,1909456.73,3843.77,672659.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','156',4348,'8','1',1566721.26,1571015.04,4293.78,751411.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','156',4349,'9','1',1841383.70,1843898.73,2515.03,440130.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','156',4350,'10','1',2017592.18,2019876.80,2284.62,399808.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','156',4351,'13','1',1842663.26,1845096.33,2433.07,425787.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','156',4352,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','156',4353,'15','1',1715474.50,1717493.58,2019.08,353339.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','156',4354,'16','1',1778032.65,1780569.17,2536.52,443891.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','156',4355,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','156',4356,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','156',4357,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','156',4358,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','156',4359,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','156',4360,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','156',4361,'29','2',1291583.99,1291742.42,158.43,128328.30,0.00,0.00,0.00,0.00,0.00),('21','224','4','156',4362,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','156',4363,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','156',4364,'32','2',32961.89,32961.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','156',4365,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','156',4366,'34','3',697848.63,698699.94,851.31,710843.85,0.00,0.00,0.00,0.00,0.00),('21','224','2','156',4367,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','156',4368,'36','1',2079146.93,2082413.72,3266.79,571688.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','157',4369,'1','1',1830974.50,1830974.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','157',4370,'2','1',1924733.95,1924733.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','157',4371,'3','1',1798407.18,1798407.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','157',4372,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','157',4373,'5','1',1524479.00,1524479.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','157',4374,'6','1',2040709.38,2040709.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','157',4375,'7','1',1909456.73,1909456.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','157',4376,'8','1',1571015.04,1571015.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','157',4377,'9','1',1843898.73,1843898.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','157',4378,'10','1',2019876.80,2019876.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','157',4379,'13','1',1845096.33,1845096.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','157',4380,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','157',4381,'15','1',1717493.58,1717493.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','157',4382,'16','1',1780569.17,1780569.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','157',4383,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','157',4384,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','157',4385,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','157',4386,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','157',4387,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','157',4388,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','157',4389,'29','2',1291742.42,1291742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','157',4390,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','157',4391,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','157',4392,'32','2',32961.89,32971.91,10.02,8116.20,0.00,0.00,0.00,0.00,0.00),('21','224','6','157',4393,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','157',4394,'34','3',698699.94,698933.78,233.84,195256.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','157',4395,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','157',4396,'36','1',2082413.72,2082413.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','158',4397,'1','1',1830974.50,1834357.30,3382.80,591990.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','158',4398,'2','1',1924733.95,1928622.34,3888.39,680468.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','158',4399,'3','1',1798407.18,1804397.48,5990.30,1048302.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','158',4400,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','158',4401,'5','1',1524479.00,1527153.00,2674.00,467950.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','158',4402,'6','1',2040709.38,2045098.60,4389.22,768113.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','158',4403,'7','1',1909456.73,1914100.87,4644.14,812724.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','158',4404,'8','1',1571015.04,1574614.96,3599.92,629986.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','158',4405,'9','1',1843898.73,1847631.39,3732.66,653215.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','158',4406,'10','1',2019876.80,2023034.39,3157.59,552578.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','158',4407,'13','1',1845096.33,1848713.25,3616.92,632961.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','158',4408,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','158',4409,'15','1',1717493.58,1721174.51,3680.93,644162.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','158',4410,'16','1',1780569.17,1783788.46,3219.29,563375.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','158',4411,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','158',4412,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','158',4413,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','158',4414,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','158',4415,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','158',4416,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','158',4417,'29','2',1291742.42,1291742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','158',4418,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','158',4419,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','158',4420,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','158',4421,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','158',4422,'34','3',698933.78,699561.73,627.95,524338.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','158',4423,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','158',4424,'36','1',2082413.72,2086200.64,3786.92,662711.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','159',4425,'1','1',1834357.30,1838384.65,4027.35,704786.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','159',4426,'2','1',1928622.34,1933047.18,4424.84,774347.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','159',4427,'3','1',1804397.48,1810904.92,6507.44,1138802.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','159',4428,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','159',4429,'5','1',1527153.00,1530761.00,3608.00,631400.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','159',4430,'6','1',2045098.60,2048588.13,3489.53,610667.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','159',4431,'7','1',1914100.87,1918060.77,3959.90,692982.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','159',4432,'8','1',1574614.96,1578821.03,4206.07,736062.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','159',4433,'9','1',1847631.39,1850019.75,2388.36,417963.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','159',4434,'10','1',2023034.39,2025144.60,1844.51,322789.25,0.00,0.00,265.70,0.00,0.00),('21','224','2','159',4435,'13','1',1848713.25,1851613.89,2900.64,507612.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','159',4436,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','159',4437,'15','1',1721174.51,1723409.54,2235.03,391130.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','159',4438,'16','1',1783788.46,1786100.72,2312.26,404645.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','159',4439,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','159',4440,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','159',4441,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','159',4442,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','159',4443,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','159',4444,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','159',4445,'29','2',1291742.42,1291742.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','159',4446,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','159',4447,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','159',4448,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','159',4449,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','159',4450,'34','3',699561.73,700280.31,677.62,565812.70,0.00,0.00,40.96,0.00,0.00),('21','224','2','159',4451,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','159',4452,'36','1',2086200.64,2089203.80,3003.16,525553.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','160',4453,'1','1',1838384.65,1843154.67,4770.02,834753.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','160',4454,'2','1',1933047.18,1937576.95,4529.77,792709.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','160',4455,'3','1',1810904.92,1816073.11,5168.19,904433.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','160',4456,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','160',4457,'5','1',1530761.00,1533990.00,3229.00,565075.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','160',4458,'6','1',2048588.13,2052036.37,3448.24,603442.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','160',4459,'7','1',1918060.77,1922256.45,4195.68,734244.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','160',4460,'8','1',1578821.03,1583487.57,4666.54,816644.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','160',4461,'9','1',1850019.75,1852030.96,2011.21,351961.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','160',4462,'10','1',2025144.60,2026959.63,1815.03,317630.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','160',4463,'13','1',1851613.89,1854611.40,2997.51,524564.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','160',4464,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','160',4465,'15','1',1723409.54,1725623.78,2214.24,387492.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','160',4466,'16','1',1786100.72,1789257.76,3157.04,552482.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','160',4467,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','160',4468,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','160',4469,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','160',4470,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','160',4471,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','160',4472,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','160',4473,'29','2',1291742.42,1296306.41,4563.99,3696831.90,0.00,0.00,0.00,0.00,0.00),('21','224','4','160',4474,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','160',4475,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','160',4476,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','160',4477,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','160',4478,'34','3',700280.31,701116.96,836.65,698602.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','160',4479,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','160',4480,'36','1',2089203.80,2091887.34,2683.54,469619.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','161',4481,'1','1',1843154.67,1846769.51,3614.84,632597.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','161',4482,'2','1',1937576.95,1941849.89,4272.94,747764.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','161',4483,'3','1',1816073.11,1822182.54,6109.43,1069150.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','161',4484,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','161',4485,'5','1',1533990.00,1537322.00,3332.00,583100.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','161',4486,'6','1',2052036.37,2056144.63,4108.26,718945.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','161',4487,'7','1',1922256.45,1926314.41,4057.96,710143.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','161',4488,'8','1',1583487.57,1588102.48,4614.91,807609.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','161',4489,'9','1',1852030.96,1855061.05,3030.09,530265.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','161',4490,'10','1',2026959.63,2026978.10,18.47,3232.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','161',4491,'13','1',1854611.40,1857856.62,3245.22,567913.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','161',4492,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','161',4493,'15','1',1725623.78,1728470.89,2847.11,498244.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','161',4494,'16','1',1789257.76,1791915.34,2657.58,465076.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','161',4495,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','161',4496,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','161',4497,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','161',4498,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','161',4499,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','161',4500,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','161',4501,'29','2',1296306.41,1298361.06,2054.65,1664266.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','161',4502,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','161',4503,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','161',4504,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','161',4505,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','161',4506,'34','3',701116.96,701860.98,744.02,621256.70,0.00,0.00,0.00,0.00,0.00),('21','224','2','161',4507,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','161',4508,'36','1',2091887.34,2095160.37,3273.03,572780.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','162',4509,'1','1',1846769.51,1850414.83,3645.32,637931.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','162',4510,'2','1',1941849.89,1945977.37,4127.48,722309.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','162',4511,'3','1',1822182.54,1827189.91,5007.37,876289.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','162',4512,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','162',4513,'5','1',1537322.00,1540370.00,3048.00,533400.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','162',4514,'6','1',2056144.63,2059750.44,3605.81,631016.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','162',4515,'7','1',1926314.41,1930045.74,3731.33,652982.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','162',4516,'8','1',1588102.48,1591476.56,3374.08,590464.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','162',4517,'9','1',1855061.05,1857842.85,2781.80,486815.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','162',4518,'10','1',2026978.10,2028918.54,1940.44,339577.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','162',4519,'13','1',1857856.62,1860052.30,2195.68,384244.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','162',4520,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','162',4521,'15','1',1728470.89,1731023.34,2552.45,446678.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','162',4522,'16','1',1791915.34,1793714.34,1799.00,314825.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','162',4523,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','162',4524,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','162',4525,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','162',4526,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','162',4527,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','162',4528,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','162',4529,'29','2',1298361.06,1302018.36,3657.30,2962413.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','162',4530,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','162',4531,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','162',4532,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','162',4533,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','162',4534,'34','3',701860.98,702235.94,374.96,313091.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','162',4535,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','162',4536,'36','1',2095160.37,2097490.68,2330.31,407804.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','163',4537,'1','1',1850414.83,1856391.09,5966.03,1044055.25,0.00,0.00,10.23,0.00,0.00),('21','224','1','163',4538,'2','1',1945977.37,1950647.95,4670.58,817351.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','163',4539,'3','1',1827189.91,1833263.98,6074.07,1062962.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','163',4540,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','163',4541,'5','1',1540370.00,1544166.00,3796.00,664300.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','163',4542,'6','1',2059750.44,2064791.95,5041.51,882264.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','163',4543,'7','1',1930045.74,1935391.01,5345.27,935422.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','163',4544,'8','1',1591476.56,1596608.03,5131.47,898007.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','163',4545,'9','1',1857842.85,1860814.57,2971.72,520051.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','163',4546,'10','1',2028918.54,2032638.74,3720.20,651035.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','163',4547,'13','1',1860052.30,1864083.73,4031.43,705500.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','163',4548,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','163',4549,'15','1',1731023.34,1734327.84,3304.50,578287.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','163',4550,'16','1',1793714.34,1796320.46,2606.12,456071.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','163',4551,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','163',4552,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','163',4553,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','163',4554,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','163',4555,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','163',4556,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','163',4557,'29','2',1302018.36,1303121.79,1103.43,893778.30,0.00,0.00,0.00,0.00,0.00),('21','224','4','163',4558,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','163',4559,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','163',4560,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','163',4561,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','163',4562,'34','3',702235.94,702719.92,442.88,369804.80,0.00,0.00,41.10,0.00,0.00),('21','224','2','163',4563,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','163',4564,'36','1',2097490.68,2101156.33,3665.65,641488.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','164',4565,'1','1',1856391.09,1859307.23,2916.14,510324.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','164',4566,'2','1',1950647.95,1954736.84,4088.89,715555.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','164',4567,'3','1',1833263.98,1837700.80,4436.82,776443.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','164',4568,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','164',4569,'5','1',1544166.00,1546210.00,2044.00,357700.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','164',4570,'6','1',2064791.95,2067834.67,3042.72,532476.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','164',4571,'7','1',1935391.01,1938453.43,3062.42,535923.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','164',4572,'8','1',1596608.03,1599495.14,2887.11,505244.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','164',4573,'9','1',1860814.57,1863415.41,2600.84,455147.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','164',4574,'10','1',2032638.74,2035537.76,2899.02,507328.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','164',4575,'13','1',1864083.73,1867231.89,3148.16,550928.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','164',4576,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','164',4577,'15','1',1734327.84,1737488.94,3161.10,553192.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','164',4578,'16','1',1796320.46,1798665.52,2345.06,410385.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','164',4579,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','164',4580,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','164',4581,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','164',4582,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','164',4583,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','164',4584,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','164',4585,'29','2',1303121.79,1304507.47,1385.68,1122400.80,0.00,0.00,0.00,0.00,0.00),('21','224','4','164',4586,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','164',4587,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','164',4588,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','164',4589,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','164',4590,'34','3',702719.92,703536.41,816.49,681769.15,0.00,0.00,0.00,0.00,0.00),('21','224','2','164',4591,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','164',4592,'36','1',2101156.33,2104359.60,3203.27,560572.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','165',4593,'1','1',1859307.23,1864127.57,4820.34,843559.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','165',4594,'2','1',1954736.84,1958742.93,4006.09,701065.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','165',4595,'3','1',1837700.80,1843246.11,5545.31,970429.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','165',4596,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','165',4597,'5','1',1546210.00,1549581.00,3371.00,589925.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','165',4598,'6','1',2067834.67,2071639.04,3804.37,665764.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','165',4599,'7','1',1938453.43,1943026.94,4573.51,800364.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','165',4600,'8','1',1599495.14,1603358.26,3863.12,676046.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','165',4601,'9','1',1863415.41,1865963.17,2547.76,445858.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','165',4602,'10','1',2035537.76,2037793.87,2256.11,394819.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','165',4603,'13','1',1867231.89,1870351.52,3119.63,545935.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','165',4604,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','165',4605,'15','1',1737488.94,1739697.51,2208.57,386499.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','165',4606,'16','1',1798665.52,1801000.96,2335.44,408702.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','165',4607,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','165',4608,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','165',4609,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','165',4610,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','165',4611,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','165',4612,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','165',4613,'29','2',1304507.47,1307285.64,2778.17,2250317.70,0.00,0.00,0.00,0.00,0.00),('21','224','4','165',4614,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','165',4615,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','165',4616,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','165',4617,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','165',4618,'34','3',703536.41,704308.71,772.30,644870.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','165',4619,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','165',4620,'36','1',2104359.60,2106738.79,2379.19,416358.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','166',4621,'1','1',1864127.57,1869049.46,4921.89,861330.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','166',4622,'2','1',1958742.93,1962977.57,4234.64,741062.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','166',4623,'3','1',1843246.11,1849052.66,5806.55,1016146.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','166',4624,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','166',4625,'5','1',1549581.00,1552958.00,3377.00,590975.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','166',4626,'6','1',2071639.04,2075830.87,4191.83,733570.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','166',4627,'7','1',1943026.94,1947544.70,4517.76,790608.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','166',4628,'8','1',1603358.26,1606327.69,2969.43,519650.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','166',4629,'9','1',1865963.17,1868195.51,2232.34,390659.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','166',4630,'10','1',2037793.87,2040463.13,2669.26,467120.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','166',4631,'13','1',1870351.52,1873113.08,2761.56,483273.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','166',4632,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','166',4633,'15','1',1739697.51,1742198.34,2500.83,437645.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','166',4634,'16','1',1801000.96,1803265.55,2264.59,396303.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','166',4635,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','166',4636,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','166',4637,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','166',4638,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','166',4639,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','166',4640,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','166',4641,'29','2',1307285.64,1315281.51,7995.87,6476654.70,0.00,0.00,0.00,0.00,0.00),('21','224','4','166',4642,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','166',4643,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','166',4644,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','166',4645,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','166',4646,'34','3',704308.71,704874.81,566.10,472693.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','166',4647,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','166',4648,'36','1',2106738.79,2109379.16,2640.37,462064.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','167',4649,'1','1',1869049.46,1869049.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','167',4650,'2','1',1962977.57,1962977.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','167',4651,'3','1',1849052.66,1849052.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','167',4652,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','167',4653,'5','1',1552958.00,1552958.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','167',4654,'6','1',2075830.87,2075830.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','167',4655,'7','1',1947544.70,1947544.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','167',4656,'8','1',1606327.69,1606327.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','167',4657,'9','1',1868195.51,1868195.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','167',4658,'10','1',2040463.13,2040463.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','167',4659,'13','1',1873113.08,1873113.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','167',4660,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','167',4661,'15','1',1742198.34,1742198.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','167',4662,'16','1',1803265.55,1803265.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','167',4663,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','167',4664,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','167',4665,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','167',4666,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','167',4667,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','167',4668,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','167',4669,'29','2',1315281.51,1315281.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','167',4670,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','167',4671,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','167',4672,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','167',4673,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','167',4674,'34','3',704874.81,704874.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','167',4675,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','167',4676,'36','1',2109379.16,2109379.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','168',4677,'1','1',1869049.46,1873270.99,4221.53,738767.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','168',4678,'2','1',1962977.57,1967073.08,4095.51,716714.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','168',4679,'3','1',1849052.66,1854145.18,5092.52,891191.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','168',4680,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','168',4681,'5','1',1552958.00,1555705.00,2747.00,480725.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','168',4682,'6','1',2075830.87,2078914.89,3084.02,539703.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','168',4683,'7','1',1947544.70,1951499.49,3954.79,692088.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','168',4684,'8','1',1606327.69,1609658.18,3330.49,582835.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','168',4685,'9','1',1868195.51,1870313.73,2118.22,370688.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','168',4686,'10','1',2040463.13,2042810.84,2347.71,410849.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','168',4687,'13','1',1873113.08,1875919.86,2806.78,491186.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','168',4688,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','168',4689,'15','1',1742198.34,1744369.61,2171.27,379972.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','168',4690,'16','1',1803265.55,1804983.64,1718.09,300665.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','168',4691,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','168',4692,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','168',4693,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','168',4694,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','168',4695,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','168',4696,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','168',4697,'29','2',1315281.51,1329799.74,14518.23,11614584.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','168',4698,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','168',4699,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','168',4700,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','168',4701,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','168',4702,'34','3',704874.81,705571.11,696.30,598818.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','168',4703,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','168',4704,'36','1',2109379.16,2111699.12,2319.96,405993.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','169',4705,'1','1',1873270.99,1877475.70,4204.71,735824.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','169',4706,'2','1',1967073.08,1972013.74,4940.66,864615.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','169',4707,'3','1',1854145.18,1859802.64,5657.46,990055.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','169',4708,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','169',4709,'5','1',1555705.00,1558808.00,3103.00,543025.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','169',4710,'6','1',2078914.89,2083315.61,4400.72,770126.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','169',4711,'7','1',1951499.49,1955490.69,3991.20,698460.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','169',4712,'8','1',1609658.18,1613306.43,3648.25,638443.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','169',4713,'9','1',1870313.73,1872803.15,2489.42,435648.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','169',4714,'10','1',2042810.84,2045317.48,2506.64,438662.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','169',4715,'13','1',1875919.86,1878800.58,2880.72,504126.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','169',4716,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','169',4717,'15','1',1744369.61,1746775.51,2405.90,421032.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','169',4718,'16','1',1804983.64,1807316.98,2333.34,408334.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','169',4719,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','169',4720,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','169',4721,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','169',4722,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','169',4723,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','169',4724,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','169',4725,'29','2',1329799.74,1348798.60,18998.86,15199088.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','169',4726,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','169',4727,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','169',4728,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','169',4729,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','169',4730,'34','3',705571.11,706183.67,612.56,526801.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','169',4731,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','169',4732,'36','1',2111699.12,2114163.56,2464.44,431277.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','170',4733,'1','1',1877475.70,1880282.23,2806.53,491142.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','170',4734,'2','1',1972013.74,1973547.90,1534.16,268478.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','170',4735,'3','1',1859802.64,1866723.71,6921.07,1211187.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','170',4736,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','170',4737,'5','1',1558808.00,1562822.00,4014.00,702450.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','170',4738,'6','1',2083315.61,2088245.22,4929.61,862681.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','170',4739,'7','1',1955490.69,1960281.31,4790.62,838358.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','170',4740,'8','1',1613306.43,1618265.96,4959.53,867917.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','170',4741,'9','1',1872803.15,1875410.77,2607.62,456333.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','170',4742,'10','1',2045317.48,2047886.86,2569.38,449641.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','170',4743,'13','1',1878800.58,1881662.68,2862.10,500867.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','170',4744,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','170',4745,'15','1',1746775.51,1749097.76,2322.25,406393.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','170',4746,'16','1',1807316.98,1809584.36,2267.38,396791.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','170',4747,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','170',4748,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','170',4749,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','170',4750,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','170',4751,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','170',4752,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','170',4753,'29','2',1348798.60,1359139.17,10340.57,8272456.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','170',4754,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','170',4755,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','170',4756,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','170',4757,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','170',4758,'34','3',706183.67,706712.16,528.49,454501.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','170',4759,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','170',4760,'36','1',2114163.56,2116535.40,2371.84,415072.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','171',4761,'1','1',1880282.23,1884220.96,3938.73,689277.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','171',4762,'2','1',1973547.90,1978175.91,4628.01,809901.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','171',4763,'3','1',1866723.71,1873341.87,6618.16,1158178.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','171',4764,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','171',4765,'5','1',1562822.00,1566167.00,3345.00,585375.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','171',4766,'6','1',2088245.22,2092268.63,4023.41,704096.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','171',4767,'7','1',1960281.31,1964605.19,4323.88,756679.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','171',4768,'8','1',1618265.96,1621662.10,3396.14,594324.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','171',4769,'9','1',1875410.77,1878014.32,2603.55,455621.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','171',4770,'10','1',2047886.86,2050127.82,2240.96,392168.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','171',4771,'13','1',1881662.68,1884798.92,3136.24,548842.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','171',4772,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','171',4773,'15','1',1749097.76,1751252.60,2154.84,377097.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','171',4774,'16','1',1809584.36,1811427.94,1843.58,322626.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','171',4775,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','171',4776,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','171',4777,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','171',4778,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','171',4779,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','171',4780,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','171',4781,'29','2',1359139.17,1361749.52,2610.35,2088280.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','171',4782,'30','2',18.35,18.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','171',4783,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','171',4784,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','171',4785,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','171',4786,'34','3',706712.16,707173.73,461.57,396950.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','171',4787,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','171',4788,'36','1',2116535.40,2119258.72,2723.32,476581.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','172',4789,'1','1',1884220.96,1889082.46,4861.50,850762.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','172',4790,'2','1',1978175.91,1982705.54,4529.63,792685.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','172',4791,'3','1',1873341.87,1879429.14,6087.27,1065272.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','172',4792,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','172',4793,'5','1',1566167.00,1569577.00,3410.00,596750.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','172',4794,'6','1',2092268.63,2097437.22,5168.59,904503.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','172',4795,'7','1',1964605.19,1969598.93,4993.74,873904.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','172',4796,'8','1',1621662.10,1626693.76,5031.66,880540.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','172',4797,'9','1',1878014.32,1878014.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','172',4798,'10','1',2050127.82,2050127.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','172',4799,'13','1',1884798.92,1884798.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','172',4800,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','172',4801,'15','1',1751252.60,1751252.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','172',4802,'16','1',1811427.94,1811427.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','172',4803,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','172',4804,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','172',4805,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','172',4806,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','172',4807,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','172',4808,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','172',4809,'29','2',1361749.52,1367192.03,5442.51,4354008.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','172',4810,'30','2',18.35,272.48,254.13,203304.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','172',4811,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','172',4812,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','172',4813,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','172',4814,'34','3',707173.73,707920.87,747.14,642540.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','172',4815,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','172',4816,'36','1',2119258.72,2119258.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','173',4817,'1','1',1889082.46,1894141.13,4740.19,829533.25,0.00,0.00,318.48,0.00,0.00),('21','224','1','173',4818,'2','1',1982705.54,1986309.76,3604.22,630738.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','173',4819,'3','1',1879429.14,1886871.38,7442.24,1302392.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','173',4820,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','173',4821,'5','1',1569577.00,1573263.00,3686.00,645050.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','173',4822,'6','1',2097437.22,2101965.84,4528.62,792508.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','173',4823,'7','1',1969598.93,1974724.17,5125.24,896917.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','173',4824,'8','1',1626693.76,1631080.73,4386.97,767719.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','173',4825,'9','1',1878014.32,1879946.65,1932.33,338157.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','173',4826,'10','1',2050127.82,2052821.83,2694.01,471451.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','173',4827,'13','1',1884798.92,1888062.67,3263.75,571156.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','173',4828,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','173',4829,'15','1',1751252.60,1753736.93,2484.33,434757.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','173',4830,'16','1',1811427.94,1814897.53,3469.59,607178.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','173',4831,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','173',4832,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','173',4833,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','173',4834,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','173',4835,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','173',4836,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','173',4837,'29','2',1367192.03,1369099.48,1825.56,1460448.00,0.00,0.00,81.89,0.00,0.00),('21','224','4','173',4838,'30','2',272.48,723.14,450.66,360528.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','173',4839,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','173',4840,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','173',4841,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','173',4842,'34','3',707920.87,708318.15,356.31,306426.60,0.00,0.00,40.97,0.00,0.00),('21','224','2','173',4843,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','173',4844,'36','1',2119258.72,2122305.60,3046.88,533204.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','174',4845,'1','1',1894141.13,1898687.98,4546.85,795698.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','174',4846,'2','1',1986309.76,1988432.55,2122.79,371488.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','174',4847,'3','1',1886871.38,1892968.38,6097.00,1066975.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','174',4848,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','174',4849,'5','1',1573263.00,1577248.00,3985.00,697375.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','174',4850,'6','1',2101965.84,2106153.15,4187.31,732779.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','174',4851,'7','1',1974724.17,1979418.05,4693.88,821429.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','174',4852,'8','1',1631080.73,1635121.79,4041.06,707185.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','174',4853,'9','1',1879946.65,1882319.92,2373.27,415322.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','174',4854,'10','1',2052821.83,2055715.57,2893.74,506404.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','174',4855,'13','1',1888062.67,1890346.85,2284.18,399731.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','174',4856,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','174',4857,'15','1',1753736.93,1756804.87,3067.94,536889.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','174',4858,'16','1',1814897.53,1817004.30,2106.77,368684.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','174',4859,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','174',4860,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','174',4861,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','174',4862,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','174',4863,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','174',4864,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','174',4865,'29','2',1369099.48,1371458.43,2358.95,1887160.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','174',4866,'30','2',723.14,1745.04,1021.90,817520.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','174',4867,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','174',4868,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','174',4869,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','174',4870,'34','3',708318.15,709067.66,749.51,644578.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','174',4871,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','174',4872,'36','1',2122305.60,2125268.05,2962.45,518428.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','175',4873,'1','1',1898687.98,1901487.57,2799.59,489928.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','175',4874,'2','1',1988432.55,1992531.31,4098.76,717283.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','175',4875,'3','1',1892968.38,1897092.45,4124.07,721712.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','175',4876,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','175',4877,'5','1',1577248.00,1578920.00,1672.00,292600.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','175',4878,'6','1',2106153.15,2109817.75,3664.60,641305.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','175',4879,'7','1',1979418.05,1982846.34,3428.29,599950.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','175',4880,'8','1',1635121.79,1637892.44,2770.65,484863.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','175',4881,'9','1',1882319.92,1885763.87,3443.95,602691.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','175',4882,'10','1',2055715.57,2058871.61,3156.04,552307.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','175',4883,'13','1',1890346.85,1894650.32,4303.47,753107.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','175',4884,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','175',4885,'15','1',1756804.87,1760571.10,3766.23,659090.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','175',4886,'16','1',1817004.30,1820718.19,3713.89,649930.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','175',4887,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','175',4888,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','175',4889,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','175',4890,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','175',4891,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','175',4892,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','175',4893,'29','2',1371458.43,1373638.60,2180.17,1744136.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','175',4894,'30','2',1745.04,2184.02,438.98,351184.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','175',4895,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','175',4896,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','175',4897,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','175',4898,'34','3',709067.66,709657.55,589.89,507305.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','175',4899,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','175',4900,'36','1',2125268.05,2129371.22,4103.17,718054.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','176',4901,'1','1',1901487.57,1905446.65,3959.08,692839.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','176',4902,'2','1',1992531.31,1995785.08,3253.77,569409.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','176',4903,'3','1',1897092.45,1902950.24,5857.79,1025113.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','176',4904,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','176',4905,'5','1',1578920.00,1582884.00,3964.00,693700.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','176',4906,'6','1',2109817.75,2114130.65,4312.90,754757.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','176',4907,'7','1',1982846.34,1987552.76,4706.42,823623.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','176',4908,'8','1',1637892.44,1641839.09,3946.65,690663.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','176',4909,'9','1',1885763.87,1888215.69,2451.82,429068.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','176',4910,'10','1',2058871.61,2061410.55,2538.94,444314.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','176',4911,'13','1',1894650.32,1897497.57,2847.25,498268.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','176',4912,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','176',4913,'15','1',1760571.10,1762666.01,2094.91,366609.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','176',4914,'16','1',1820718.19,1822824.88,2106.69,368670.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','176',4915,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','176',4916,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','176',4917,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','176',4918,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','176',4919,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','176',4920,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','176',4921,'29','2',1373638.60,1378745.96,5107.36,4085888.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','176',4922,'30','2',2184.02,8922.69,6738.67,5390936.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','176',4923,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','176',4924,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','176',4925,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','176',4926,'34','3',709657.55,710089.33,431.78,371330.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','176',4927,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','176',4928,'36','1',2129371.22,2132449.01,3077.79,538613.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','177',4929,'1','1',1905446.65,1910752.22,5305.57,928474.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','177',4930,'2','1',1995785.08,1997056.84,1271.76,222558.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','177',4931,'3','1',1902950.24,1909042.66,6092.42,1066173.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','177',4932,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','177',4933,'5','1',1582884.00,1587061.00,4177.00,730975.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','177',4934,'6','1',2114130.65,2118098.84,3968.19,694433.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','177',4935,'7','1',1987552.76,1992220.35,4667.59,816828.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','177',4936,'8','1',1641839.09,1646113.10,4274.01,747951.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','177',4937,'9','1',1888215.69,1890757.60,2541.91,444834.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','177',4938,'10','1',2061410.55,2064013.26,2602.71,455474.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','177',4939,'13','1',1897497.57,1900194.24,2696.67,471917.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','177',4940,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','177',4941,'15','1',1762666.01,1764429.35,1763.34,308584.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','177',4942,'16','1',1822824.88,1825447.67,2622.79,458988.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','177',4943,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','177',4944,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','177',4945,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','177',4946,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','177',4947,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','177',4948,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','177',4949,'29','2',1378745.96,1378854.47,108.51,86808.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','177',4950,'30','2',8922.69,11628.43,2705.74,2164592.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','177',4951,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','177',4952,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','177',4953,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','177',4954,'34','3',710089.33,710901.84,812.51,698758.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','177',4955,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','177',4956,'36','1',2132449.01,2135384.31,2935.30,513677.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','178',4957,'1','1',1910752.22,1916156.79,5404.57,945799.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','178',4958,'2','1',1997056.84,1997987.26,930.42,162823.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','178',4959,'3','1',1909042.66,1915736.37,6693.71,1171399.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','178',4960,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','178',4961,'5','1',1587061.00,1590599.00,3538.00,619150.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','178',4962,'6','1',2118098.84,2122034.53,3935.69,688745.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','178',4963,'7','1',1992220.35,1995760.72,3540.37,619564.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','178',4964,'8','1',1646113.10,1651754.71,5641.61,987281.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','178',4965,'9','1',1890757.60,1893337.84,2580.24,451542.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','178',4966,'10','1',2064013.26,2065989.82,1976.56,345898.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','178',4967,'13','1',1900194.24,1903261.41,2801.67,490292.25,0.00,0.00,265.50,0.00,0.00),('21','224','2','178',4968,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','178',4969,'15','1',1764429.35,1766881.66,2452.31,429154.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','178',4970,'16','1',1825447.67,1827648.68,2201.01,385176.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','178',4971,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','178',4972,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','178',4973,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','178',4974,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','178',4975,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','178',4976,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','178',4977,'29','2',1378854.47,1378854.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','178',4978,'30','2',11628.43,13448.53,1779.40,1423520.00,0.00,0.00,40.70,0.00,0.00),('21','224','5','178',4979,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','178',4980,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','178',4981,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','178',4982,'34','3',710901.84,711538.46,616.14,529880.40,0.00,0.00,20.48,0.00,0.00),('21','224','2','178',4983,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','178',4984,'36','1',2135384.31,2138178.61,2794.30,489002.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','179',4985,'1','1',1916156.79,1919843.72,3686.93,645212.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','179',4986,'2','1',1997987.26,2001996.10,4008.84,701547.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','179',4987,'3','1',1915736.37,1921117.30,5380.93,941662.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','179',4988,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','179',4989,'5','1',1590599.00,1593818.00,3219.00,563325.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','179',4990,'6','1',2122034.53,2126686.35,4651.82,814068.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','179',4991,'7','1',1995760.72,2000871.43,5110.71,894374.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','179',4992,'8','1',1651754.71,1655222.24,3467.53,606817.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','179',4993,'9','1',1893337.84,1896071.90,2734.06,478460.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','179',4994,'10','1',2065989.82,2068739.68,2749.86,481225.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','179',4995,'13','1',1903261.41,1907004.64,3743.23,655065.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','179',4996,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','179',4997,'15','1',1766881.66,1769525.87,2644.21,462736.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','179',4998,'16','1',1827648.68,1830626.93,2978.25,521193.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','179',4999,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','179',5000,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','179',5001,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','179',5002,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','179',5003,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','179',5004,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','179',5005,'29','2',1378854.47,1378854.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','179',5006,'30','2',13448.53,16414.67,2966.14,2372912.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','179',5007,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','179',5008,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','179',5009,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','179',5010,'34','3',711538.46,712206.04,667.58,574118.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','179',5011,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','179',5012,'36','1',2138178.61,2141735.45,3556.84,622447.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','180',5013,'1','1',1919843.72,1924249.85,4406.13,771072.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','180',5014,'2','1',2001996.10,2006363.00,4366.90,764207.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','180',5015,'3','1',1921117.30,1927414.06,6296.76,1101933.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','180',5016,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','180',5017,'5','1',1593818.00,1596924.00,3106.00,543550.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','180',5018,'6','1',2126686.35,2130689.21,4002.86,700500.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','180',5019,'7','1',2000871.43,2004893.51,4022.08,703864.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','180',5020,'8','1',1655222.24,1659012.54,3790.30,663302.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','180',5021,'9','1',1896071.90,1898231.09,2159.19,377858.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','180',5022,'10','1',2068739.68,2071254.16,2514.48,440034.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','180',5023,'13','1',1907004.64,1909990.38,2985.74,522504.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','180',5024,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','180',5025,'15','1',1769525.87,1771991.59,2465.72,431501.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','180',5026,'16','1',1830626.93,1832588.08,1961.15,343201.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','180',5027,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','180',5028,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','180',5029,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','180',5030,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','180',5031,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','180',5032,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','180',5033,'29','2',1378854.47,1379028.83,174.36,139488.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','180',5034,'30','2',16414.67,17704.91,1290.24,1032192.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','180',5035,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','180',5036,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','180',5037,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','180',5038,'34','3',712206.04,712804.05,598.01,514288.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','180',5039,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','180',5040,'36','1',2141735.45,2144588.17,2852.72,499226.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','181',5041,'1','1',1924249.85,1928767.40,4517.55,790571.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','181',5042,'2','1',2006363.00,2009778.87,3415.87,597777.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','181',5043,'3','1',1927414.06,1933323.00,5908.94,1034064.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','181',5044,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','181',5045,'5','1',1596924.00,1600095.00,3171.00,554925.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','181',5046,'6','1',2130689.21,2135251.52,4562.31,798404.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','181',5047,'7','1',2004893.51,2009169.31,4275.80,748265.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','181',5048,'8','1',1659012.54,1663011.57,3999.03,699830.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','181',5049,'9','1',1898231.09,1900297.48,2066.39,361618.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','181',5050,'10','1',2071254.16,2073903.11,2648.95,463566.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','181',5051,'13','1',1909990.38,1912600.51,2610.13,456772.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','181',5052,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','181',5053,'15','1',1771991.59,1774382.90,2391.31,418479.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','181',5054,'16','1',1832588.08,1835001.68,2413.60,422380.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','181',5055,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','181',5056,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','181',5057,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','181',5058,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','181',5059,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','181',5060,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','181',5061,'29','2',1379028.83,1379389.71,360.88,288704.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','181',5062,'30','2',17704.91,20160.50,2455.59,1964472.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','181',5063,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','181',5064,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','181',5065,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','181',5066,'34','3',712804.05,713370.27,566.22,486949.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','181',5067,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','181',5068,'36','1',2144588.17,2147503.47,2915.30,510177.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','182',5069,'1','1',1928767.40,1933224.40,4457.00,779975.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','182',5070,'2','1',2009778.87,2013879.06,4100.19,717533.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','182',5071,'3','1',1933323.00,1940301.78,6978.78,1221286.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','182',5072,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','182',5073,'5','1',1600095.00,1604260.00,4165.00,728875.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','182',5074,'6','1',2135251.52,2140016.40,4764.88,833854.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','182',5075,'7','1',2009169.31,2013987.33,4818.02,843153.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','182',5076,'8','1',1663011.57,1667422.92,4411.35,771986.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','182',5077,'9','1',1900297.48,1902635.16,2337.68,409094.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','182',5078,'10','1',2073903.11,2076215.86,2312.75,404731.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','182',5079,'13','1',1912600.51,1915693.25,3092.74,541229.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','182',5080,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','182',5081,'15','1',1774382.90,1776955.55,2572.65,450213.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','182',5082,'16','1',1835001.68,1837560.93,2559.25,447868.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','182',5083,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','182',5084,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','182',5085,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','182',5086,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','182',5087,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','182',5088,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','182',5089,'29','2',1379389.71,1379503.31,113.60,90880.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','182',5090,'30','2',20160.50,21001.49,840.99,672792.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','182',5091,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','182',5092,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','182',5093,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','182',5094,'34','3',713370.27,713908.83,538.56,463161.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','182',5095,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','182',5096,'36','1',2147503.47,2150639.94,3136.47,548882.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','183',5097,'1','1',1933224.40,1936512.08,3287.68,575344.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','183',5098,'2','1',2013879.06,2018628.93,4749.87,831227.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','183',5099,'3','1',1940301.78,1946153.46,5851.68,1024044.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','183',5100,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','183',5101,'5','1',1604260.00,1607294.00,3034.00,530950.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','183',5102,'6','1',2140016.40,2144517.32,4500.92,787661.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','183',5103,'7','1',2013987.33,2018572.84,4585.51,802464.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','183',5104,'8','1',1667422.92,1671116.00,3693.08,646289.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','183',5105,'9','1',1902635.16,1905332.86,2697.70,472097.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','183',5106,'10','1',2076215.86,2079907.17,3691.31,645979.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','183',5107,'13','1',1915693.25,1919829.87,4136.62,723908.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','183',5108,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','183',5109,'15','1',1776955.55,1779527.76,2572.21,450136.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','183',5110,'16','1',1837560.93,1840361.44,2800.51,490089.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','183',5111,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','183',5112,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','183',5113,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','183',5114,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','183',5115,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','183',5116,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','183',5117,'29','2',1379503.31,1379702.70,199.39,159512.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','183',5118,'30','2',21001.49,23476.43,2474.94,1979952.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','183',5119,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','183',5120,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','183',5121,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','183',5122,'34','3',713908.83,714479.49,570.66,490767.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','183',5123,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','183',5124,'36','1',2150639.94,2154686.38,4046.44,708127.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','184',5125,'1','1',1936512.08,1940447.77,3935.69,688745.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','184',5126,'2','1',2018628.93,2022971.39,4342.46,759930.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','184',5127,'3','1',1946153.46,1952869.60,6716.14,1175324.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','184',5128,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','184',5129,'5','1',1607294.00,1611833.00,4539.00,794325.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','184',5130,'6','1',2144517.32,2148825.15,4307.83,753870.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','184',5131,'7','1',2018572.84,2023309.48,4736.64,828912.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','184',5132,'8','1',1671116.00,1675423.29,4307.29,753775.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','184',5133,'9','1',1905332.86,1908050.76,2717.90,475632.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','184',5134,'10','1',2079907.17,2082204.12,2296.95,401966.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','184',5135,'13','1',1919829.87,1923050.85,3220.98,563671.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','184',5136,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','184',5137,'15','1',1779527.76,1781919.68,2391.92,418586.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','184',5138,'16','1',1840361.44,1843140.53,2779.09,486340.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','184',5139,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','184',5140,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','184',5141,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','184',5142,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','184',5143,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','184',5144,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','184',5145,'29','2',1379702.70,1379827.72,125.02,100016.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','184',5146,'30','2',23476.43,25681.06,2204.63,1763704.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','184',5147,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','184',5148,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','184',5149,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','184',5150,'34','3',714479.49,715374.51,895.02,769717.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','184',5151,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','184',5152,'36','1',2154686.38,2158257.98,3571.60,625030.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','185',5153,'1','1',1940447.77,1944335.28,3887.51,680314.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','185',5154,'2','1',2022971.39,2026936.52,3965.13,693897.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','185',5155,'3','1',1952869.60,1958521.18,5651.58,989026.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','185',5156,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','185',5157,'5','1',1611833.00,1615593.00,3760.00,658000.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','185',5158,'6','1',2148825.15,2152713.49,3888.34,680459.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','185',5159,'7','1',2023309.48,2027863.74,4554.26,796995.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','185',5160,'8','1',1675423.29,1678979.65,3556.36,622363.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','185',5161,'9','1',1908050.76,1910352.21,2301.45,402753.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','185',5162,'10','1',2082204.12,2084734.85,2530.73,442877.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','185',5163,'13','1',1923050.85,1925429.92,2379.07,416337.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','185',5164,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','185',5165,'15','1',1781919.68,1784544.96,2625.28,459424.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','185',5166,'16','1',1843140.53,1845365.31,2224.78,389336.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','185',5167,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','185',5168,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','185',5169,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','185',5170,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','185',5171,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','185',5172,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','185',5173,'29','2',1379827.72,1379827.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','185',5174,'30','2',25681.06,27137.60,1456.54,1165232.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','185',5175,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','185',5176,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','185',5177,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','185',5178,'34','3',715374.51,715777.49,402.98,346562.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','185',5179,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','185',5180,'36','1',2158257.98,2161690.89,3432.91,600759.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','186',5181,'1','1',1944335.28,1949313.21,4977.93,871137.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','186',5182,'2','1',2026936.52,2030078.24,3141.72,549801.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','186',5183,'3','1',1958521.18,1965017.50,6466.03,1131555.25,0.00,0.00,30.29,0.00,0.00),('21','224','1','186',5184,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','186',5185,'5','1',1615593.00,1618740.00,3147.00,550725.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','186',5186,'6','1',2152713.49,2157449.32,4735.83,828770.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','186',5187,'7','1',2027863.74,2031878.37,4014.63,702560.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','186',5188,'8','1',1678979.65,1682508.35,3528.70,617522.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','186',5189,'9','1',1910352.21,1912575.33,2223.12,389046.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','186',5190,'10','1',2084734.85,2087429.46,2694.61,471556.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','186',5191,'13','1',1925429.92,1928457.91,3027.99,529898.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','186',5192,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','186',5193,'15','1',1784544.96,1786919.72,2374.76,415583.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','186',5194,'16','1',1845365.31,1847305.90,1940.59,339603.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','186',5195,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','186',5196,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','186',5197,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','186',5198,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','186',5199,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','186',5200,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','186',5201,'29','2',1379827.72,1379827.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','186',5202,'30','2',27137.60,29727.25,2589.65,2071720.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','186',5203,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','186',5204,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','186',5205,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','186',5206,'34','3',715777.49,716224.54,447.05,384463.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','186',5207,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','186',5208,'36','1',2161690.89,2164332.36,2641.47,462257.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','187',5209,'1','1',1949313.21,1949313.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','187',5210,'2','1',2030078.24,2030078.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','187',5211,'3','1',1965017.50,1965017.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','187',5212,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','187',5213,'5','1',1618740.00,1618740.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','187',5214,'6','1',2157449.32,2157449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','187',5215,'7','1',2031878.37,2031878.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','187',5216,'8','1',1682508.35,1682508.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','187',5217,'9','1',1912575.33,1912575.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','187',5218,'10','1',2087429.46,2087429.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','187',5219,'13','1',1928457.91,1928457.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','187',5220,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','187',5221,'15','1',1786919.72,1786919.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','187',5222,'16','1',1847305.90,1847305.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','187',5223,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','187',5224,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','187',5225,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','187',5226,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','187',5227,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','187',5228,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','187',5229,'29','2',1379827.72,1379827.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','187',5230,'30','2',29727.25,32332.80,2605.55,2084440.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','187',5231,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','187',5232,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','187',5233,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','187',5234,'34','3',716224.54,716776.19,551.65,474419.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','187',5235,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','187',5236,'36','1',2164332.36,2164332.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','188',5237,'1','1',1949313.21,1954106.40,4793.19,838808.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','188',5238,'2','1',2030078.24,2034224.71,4146.47,725632.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','188',5239,'3','1',1965017.50,1971673.15,6655.65,1164738.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','188',5240,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','188',5241,'5','1',1618740.00,1622575.00,3835.00,671125.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','188',5242,'6','1',2157449.32,2162174.32,4725.00,826875.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','188',5243,'7','1',2031878.37,2036048.14,4169.77,729709.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','188',5244,'8','1',1682508.35,1686977.36,4469.01,782076.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','188',5245,'9','1',1912575.33,1915718.94,3143.61,550131.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','188',5246,'10','1',2087429.46,2090207.54,2778.08,486164.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','188',5247,'13','1',1928457.91,1931839.87,3137.18,549006.50,0.00,0.00,244.78,0.00,0.00),('21','224','2','188',5248,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','188',5249,'15','1',1786919.72,1789405.89,2486.17,435079.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','188',5250,'16','1',1847305.90,1849931.65,2625.75,459506.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','188',5251,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','188',5252,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','188',5253,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','188',5254,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','188',5255,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','188',5256,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','188',5257,'29','2',1379827.72,1379953.74,85.15,68120.00,0.00,0.00,40.87,0.00,0.00),('21','224','4','188',5258,'30','2',32332.80,34657.43,2324.63,1859704.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','188',5259,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','188',5260,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','188',5261,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','188',5262,'34','3',716776.19,717367.68,571.05,491103.00,0.00,0.00,20.44,0.00,0.00),('21','224','2','188',5263,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','188',5264,'36','1',2164332.36,2166854.25,2521.89,441330.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','189',5265,'1','1',1954106.40,1958636.78,4530.38,792816.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','189',5266,'2','1',2034224.71,2038812.49,4587.78,802861.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','189',5267,'3','1',1971673.15,1977454.12,5780.97,1011669.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','189',5268,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','189',5269,'5','1',1622575.00,1626630.00,4055.00,709625.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','189',5270,'6','1',2162174.32,2167114.33,4940.01,864501.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','189',5271,'7','1',2036048.14,2040171.25,4123.11,721544.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','189',5272,'8','1',1686977.36,1690623.64,3646.28,638099.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','189',5273,'9','1',1915718.94,1919177.42,3458.48,605234.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','189',5274,'10','1',2090207.54,2095489.31,5281.77,924309.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','189',5275,'13','1',1931839.87,1937268.73,5428.86,950050.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','189',5276,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','189',5277,'15','1',1789405.89,1793812.13,4406.24,771092.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','189',5278,'16','1',1849931.65,1854156.68,4225.03,739380.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','189',5279,'17','1',1469748.25,1469748.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','189',5280,'18','1',1498348.17,1498348.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','189',5281,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','189',5282,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','189',5283,'25','1',1244830.54,1244830.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','189',5284,'26','1',1411766.48,1411766.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','189',5285,'29','2',1379953.74,1380159.74,206.00,164800.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','189',5286,'30','2',34657.43,37223.70,2566.27,2053016.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','189',5287,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','189',5288,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','189',5289,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','189',5290,'34','3',717367.68,718109.10,741.42,637621.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','189',5291,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','189',5292,'36','1',2166854.25,2171107.34,4253.09,744290.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','190',5293,'1','1',1958636.78,1965655.24,7018.46,1228230.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','190',5294,'2','1',2038812.49,2038846.98,34.49,6035.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','190',5295,'3','1',1977454.12,1982769.45,5315.33,930182.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','190',5296,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','190',5297,'5','1',1626630.00,1630517.00,3887.00,680225.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','190',5298,'6','1',2167114.33,2170762.89,3648.56,638498.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','190',5299,'7','1',2040171.25,2045880.57,5709.32,999131.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','190',5300,'8','1',1690623.64,1693746.24,3122.60,546455.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','190',5301,'9','1',1919177.42,1924048.93,4871.51,852514.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','190',5302,'10','1',2095489.31,2100044.96,4555.65,797238.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','190',5303,'13','1',1937268.73,1942288.56,5019.83,878470.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','190',5304,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','190',5305,'15','1',1793812.13,1797874.36,4062.23,710890.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','190',5306,'16','1',1854156.68,1857618.36,3431.68,600544.00,0.00,0.00,30.00,0.00,0.00),('21','224','3','190',5307,'17','1',1469748.25,1473849.13,4100.88,717654.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','190',5308,'18','1',1498348.17,1502198.74,3850.57,673849.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','190',5309,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','190',5310,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','190',5311,'25','1',1244830.54,1244833.87,3.33,582.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','190',5312,'26','1',1411766.48,1416622.40,4855.92,849786.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','190',5313,'29','2',1380159.74,1380184.74,25.00,20000.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','190',5314,'30','2',37223.70,40048.45,2824.75,2259800.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','190',5315,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','190',5316,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','190',5317,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','190',5318,'34','3',718109.10,718642.52,533.42,458741.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','190',5319,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','190',5320,'36','1',2171107.34,2175994.58,4887.24,855267.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','191',5321,'1','1',1965655.24,1969731.57,4076.33,713357.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','191',5322,'2','1',2038846.98,2038847.06,0.08,14.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','191',5323,'3','1',1982769.45,1986097.37,3327.92,582386.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','191',5324,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','191',5325,'5','1',1630517.00,1632541.00,1986.00,347550.00,0.00,0.00,38.00,0.00,0.00),('21','224','1','191',5326,'6','1',2170762.89,2173409.65,2646.76,463183.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','191',5327,'7','1',2045880.57,2048479.84,2599.27,454872.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','191',5328,'8','1',1693746.24,1696552.75,2806.51,491139.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','191',5329,'9','1',1924048.93,1927742.27,3693.34,646334.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','191',5330,'10','1',2100044.96,2104489.64,4444.68,777819.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','191',5331,'13','1',1942288.56,1947763.03,5474.47,958032.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','191',5332,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','191',5333,'15','1',1797874.36,1801462.88,3588.52,627991.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','191',5334,'16','1',1857618.36,1860529.80,2911.44,509502.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','191',5335,'17','1',1473849.13,1478775.63,4926.50,862137.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','191',5336,'18','1',1502198.74,1506318.59,4119.85,720973.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','191',5337,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','191',5338,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','191',5339,'25','1',1244833.87,1244833.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','191',5340,'26','1',1416622.40,1422039.60,5417.20,948010.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','191',5341,'29','2',1380184.74,1381506.13,1321.39,1057112.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','191',5342,'30','2',40048.45,42785.05,2736.60,2189280.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','191',5343,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','191',5344,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','191',5345,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','191',5346,'34','3',718642.52,719017.03,374.51,322078.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','191',5347,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','191',5348,'36','1',2175994.58,2179826.52,3831.94,670589.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','192',5349,'1','1',1969731.57,1974446.89,4715.32,825181.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','192',5350,'2','1',2038847.06,2043030.66,4183.60,732130.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','192',5351,'3','1',1986097.37,1991830.49,5733.12,1003296.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','192',5352,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','192',5353,'5','1',1632541.00,1636248.00,3707.00,648725.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','192',5354,'6','1',2173409.65,2178109.91,4700.26,822545.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','192',5355,'7','1',2048479.84,2052576.76,4096.92,716961.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','192',5356,'8','1',1696552.75,1699723.75,3171.00,554925.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','192',5357,'9','1',1927742.27,1929990.73,2248.46,393480.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','192',5358,'10','1',2104489.64,2107359.55,2869.91,502234.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','192',5359,'13','1',1947763.03,1950230.23,2467.20,431760.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','192',5360,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','192',5361,'15','1',1801462.88,1803680.83,2217.95,388141.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','192',5362,'16','1',1860529.80,1862528.57,1998.77,349784.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','192',5363,'17','1',1478775.63,1479308.86,533.23,93315.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','192',5364,'18','1',1506318.59,1506761.77,443.18,77556.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','192',5365,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','192',5366,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','192',5367,'25','1',1244833.87,1244833.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','192',5368,'26','1',1422039.60,1422622.52,582.92,102011.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','192',5369,'29','2',1381506.13,1381698.64,192.51,154008.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','192',5370,'30','2',42785.05,44129.24,1344.19,1075352.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','192',5371,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','192',5372,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','192',5373,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','192',5374,'34','3',719017.03,719490.63,473.60,407296.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','192',5375,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','192',5376,'36','1',2179826.52,2182619.31,2792.79,488738.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','193',5377,'1','1',1974446.89,1975224.90,778.01,136151.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','193',5378,'2','1',2043030.66,2044190.66,1160.00,203000.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','193',5379,'3','1',1991830.49,1992821.77,991.28,173474.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','193',5380,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','193',5381,'5','1',1636248.00,1636914.00,666.00,116550.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','193',5382,'6','1',2178109.91,2179009.08,899.17,157354.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','193',5383,'7','1',2052576.76,2053564.38,987.62,172833.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','193',5384,'8','1',1699723.75,1700374.88,651.13,113947.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','193',5385,'9','1',1929990.73,1930784.16,793.43,138850.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','193',5386,'10','1',2107359.55,2108311.79,952.24,166642.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','193',5387,'13','1',1950230.23,1951424.01,1193.78,208911.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','193',5388,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','193',5389,'15','1',1803680.83,1804684.24,1003.41,175596.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','193',5390,'16','1',1862528.57,1862591.58,63.01,11026.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','193',5391,'17','1',1479308.86,1479308.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','193',5392,'18','1',1506761.77,1506761.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','193',5393,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','193',5394,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','193',5395,'25','1',1244833.87,1244833.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','193',5396,'26','1',1422622.52,1422622.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','193',5397,'29','2',1381698.64,1381926.09,227.45,181960.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','193',5398,'30','2',44129.24,44783.91,654.67,523736.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','193',5399,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','193',5400,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','193',5401,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','193',5402,'34','3',719490.63,720197.86,707.23,608217.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','193',5403,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','193',5404,'36','1',2182619.31,2183530.55,911.24,159467.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','194',5405,'1','1',1975224.90,1978473.81,3248.91,568559.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','194',5406,'2','1',2044190.66,2048119.59,3928.93,687562.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','194',5407,'3','1',1992821.77,1997812.76,4990.99,873423.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','194',5408,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','194',5409,'5','1',1636914.00,1639804.00,2890.00,505750.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','194',5410,'6','1',2179009.08,2182511.42,3502.34,612909.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','194',5411,'7','1',2053564.38,2056386.03,2821.65,493788.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','194',5412,'8','1',1700374.88,1702981.82,2606.94,456214.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','194',5413,'9','1',1930784.16,1933733.50,2949.34,516134.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','194',5414,'10','1',2108311.79,2111490.60,3178.81,556291.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','194',5415,'13','1',1951424.01,1955962.93,4538.92,794311.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','194',5416,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','194',5417,'15','1',1804684.24,1808033.22,3348.98,586071.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','194',5418,'16','1',1862591.58,1863327.06,735.48,128709.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','194',5419,'17','1',1479308.86,1479308.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','194',5420,'18','1',1506761.77,1506761.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','194',5421,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','194',5422,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','194',5423,'25','1',1244833.87,1244833.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','194',5424,'26','1',1422622.52,1422622.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','194',5425,'29','2',1381926.09,1382307.72,381.63,305304.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','194',5426,'30','2',44783.91,49463.60,4679.69,3743752.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','194',5427,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','194',5428,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','194',5429,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','194',5430,'34','3',720197.86,720735.05,537.19,461983.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','194',5431,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','194',5432,'36','1',2183530.55,2187105.30,3574.75,625581.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','195',5433,'1','1',1978473.81,1983040.16,4566.35,799111.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','195',5434,'2','1',2048119.59,2051188.07,3068.48,536984.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','195',5435,'3','1',1997812.76,2004137.28,6324.52,1106791.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','195',5436,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','195',5437,'5','1',1639804.00,1643726.00,3922.00,686350.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','195',5438,'6','1',2182511.42,2186572.33,4060.91,710659.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','195',5439,'7','1',2056386.03,2059179.92,2793.89,488930.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','195',5440,'8','1',1702981.82,1707358.83,4377.01,765976.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','195',5441,'9','1',1933733.50,1937575.19,3841.69,672295.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','195',5442,'10','1',2111490.60,2115445.26,3954.66,692065.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','195',5443,'13','1',1955962.93,1960322.91,4359.98,762996.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','195',5444,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','195',5445,'15','1',1808033.22,1812547.20,4513.98,789946.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','195',5446,'16','1',1863327.06,1866025.59,2698.53,472242.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','195',5447,'17','1',1479308.86,1481446.41,2137.55,374071.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','195',5448,'18','1',1506761.77,1509188.30,2426.53,424642.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','195',5449,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','195',5450,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','195',5451,'25','1',1244833.87,1244833.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','195',5452,'26','1',1422622.52,1425837.81,3215.29,562675.75,0.00,0.00,0.00,0.00,0.00),('21','224','4','195',5453,'29','2',1382307.72,1382517.72,210.00,168000.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','195',5454,'30','2',49463.60,52043.55,2579.95,2063960.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','195',5455,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','195',5456,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','195',5457,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','195',5458,'34','3',720735.05,721372.80,637.75,548465.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','195',5459,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','195',5460,'36','1',2187105.30,2192979.17,5873.87,1027927.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','196',5461,'1','1',1983040.16,1988272.91,5232.75,915731.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','196',5462,'2','1',2051188.07,2053193.15,2005.08,350889.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','196',5463,'3','1',2004137.28,2010125.46,5988.18,1047931.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','196',5464,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','196',5465,'5','1',1643726.00,1647295.00,3569.00,624575.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','196',5466,'6','1',2186572.33,2190922.27,4349.94,761239.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','196',5467,'7','1',2059179.92,2063267.71,4087.79,715363.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','196',5468,'8','1',1707358.83,1711601.39,4242.56,742448.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','196',5469,'9','1',1937575.19,1941242.70,3667.51,641814.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','196',5470,'10','1',2115445.26,2119040.42,3557.14,622499.50,0.00,0.00,38.02,0.00,0.00),('21','224','2','196',5471,'13','1',1960322.91,1963854.40,3531.49,618010.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','196',5472,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','196',5473,'15','1',1812547.20,1815538.72,2991.52,523516.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','196',5474,'16','1',1866025.59,1869639.33,3613.74,632404.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','196',5475,'17','1',1481446.41,1486148.64,4702.23,822890.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','196',5476,'18','1',1509188.30,1510399.44,1211.14,211949.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','196',5477,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','196',5478,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','196',5479,'25','1',1244833.87,1244833.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','196',5480,'26','1',1425837.81,1429985.84,4148.03,725905.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','196',5481,'29','2',1382517.72,1382750.26,232.54,186032.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','196',5482,'30','2',52043.55,54495.15,2451.60,1961280.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','196',5483,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','196',5484,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','196',5485,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','196',5486,'34','3',721372.80,721985.71,612.91,527102.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','196',5487,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','196',5488,'36','1',2192979.17,2196669.45,3690.28,645799.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','197',5489,'1','1',1988272.91,1991954.77,3681.86,644325.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','197',5490,'2','1',2053193.15,2054113.25,920.10,161017.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','197',5491,'3','1',2010125.46,2013471.40,3345.94,585539.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','197',5492,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','197',5493,'5','1',1647295.00,1649209.00,1914.00,334950.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','197',5494,'6','1',2190922.27,2193750.03,2827.76,494858.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','197',5495,'7','1',2063267.71,2066361.14,3093.43,541350.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','197',5496,'8','1',1711601.39,1712280.25,678.86,118800.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','197',5497,'9','1',1941242.70,1945497.20,4254.50,744537.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','197',5498,'10','1',2119040.42,2123810.34,4769.92,834736.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','197',5499,'13','1',1963854.40,1969222.68,5368.28,939449.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','197',5500,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','197',5501,'15','1',1815538.72,1819839.04,4300.32,752556.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','197',5502,'16','1',1869639.33,1873898.30,4258.97,745319.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','197',5503,'17','1',1486148.64,1488532.37,2383.73,417152.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','197',5504,'18','1',1510399.44,1515085.93,4686.49,820135.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','197',5505,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','197',5506,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','197',5507,'25','1',1244833.87,1247210.21,2376.34,415859.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','197',5508,'26','1',1429985.84,1434565.49,4579.65,801438.75,0.00,0.00,0.00,0.00,0.00),('21','224','4','197',5509,'29','2',1382750.26,1383094.27,344.01,275208.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','197',5510,'30','2',54495.15,56674.15,2179.00,1743200.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','197',5511,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','197',5512,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','197',5513,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','197',5514,'34','3',721985.71,722399.33,413.62,355713.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','197',5515,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','197',5516,'36','1',2196669.45,2201607.77,4938.32,864206.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','198',5517,'1','1',1991954.77,1995344.51,3389.74,593204.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','198',5518,'2','1',2054113.25,2057326.35,3213.10,562292.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','198',5519,'3','1',2013471.40,2018753.05,5281.65,924288.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','198',5520,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','198',5521,'5','1',1649209.00,1653149.00,3940.00,689500.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','198',5522,'6','1',2193750.03,2197621.81,3871.78,677561.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','198',5523,'7','1',2066361.14,2069323.09,2961.95,518341.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','198',5524,'8','1',1712280.25,1715364.00,3083.75,539656.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','198',5525,'9','1',1945497.20,1947903.44,2406.24,421092.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','198',5526,'10','1',2123810.34,2126263.16,2452.82,429243.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','198',5527,'13','1',1969222.68,1972369.97,3147.29,550775.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','198',5528,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','198',5529,'15','1',1819839.04,1822115.23,2276.19,398333.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','198',5530,'16','1',1873898.30,1875444.98,1546.68,270669.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','198',5531,'17','1',1488532.37,1488532.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','198',5532,'18','1',1515085.93,1515085.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','198',5533,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','198',5534,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','198',5535,'25','1',1247210.21,1247210.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','198',5536,'26','1',1434565.49,1434565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','198',5537,'29','2',1383094.27,1383324.69,230.42,184336.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','198',5538,'30','2',56674.15,58968.30,2294.15,1835320.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','198',5539,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','198',5540,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','198',5541,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','198',5542,'34','3',722399.33,723209.06,809.73,696367.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','198',5543,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','198',5544,'36','1',2201607.77,2204125.98,2518.21,440686.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','199',5545,'1','1',1995344.51,1999718.32,4373.81,765416.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','199',5546,'2','1',2057326.35,2062303.06,4976.71,870924.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','199',5547,'3','1',2018753.05,2024457.47,5704.42,998273.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','199',5548,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','199',5549,'5','1',1653149.00,1656886.00,3737.00,653975.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','199',5550,'6','1',2197621.81,2201343.07,3721.26,651220.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','199',5551,'7','1',2069323.09,2072727.32,3404.23,595740.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','199',5552,'8','1',1715364.00,1718664.99,3300.99,577673.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','199',5553,'9','1',1947903.44,1950634.16,2730.72,477876.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','199',5554,'10','1',2126263.16,2128857.51,2594.35,454011.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','199',5555,'13','1',1972369.97,1975583.48,3213.51,562364.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','199',5556,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','199',5557,'15','1',1822115.23,1824688.41,2573.18,450306.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','199',5558,'16','1',1875444.98,1877163.35,1718.37,300714.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','199',5559,'17','1',1488532.37,1488532.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','199',5560,'18','1',1515085.93,1515085.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','199',5561,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','199',5562,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','199',5563,'25','1',1247210.21,1247210.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','199',5564,'26','1',1434565.49,1434565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','199',5565,'29','2',1383324.69,1383783.35,458.66,366928.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','199',5566,'30','2',58968.30,60506.87,1538.57,1230856.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','199',5567,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','199',5568,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','199',5569,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','199',5570,'34','3',723209.06,723629.09,420.03,361225.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','199',5571,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','199',5572,'36','1',2204125.98,2207333.52,3207.54,561319.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','200',5573,'1','1',1999718.32,2001103.36,1385.04,242382.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','200',5574,'2','1',2062303.06,2063667.08,1364.02,238703.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','200',5575,'3','1',2024457.47,2026456.09,1998.62,349758.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','200',5576,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','200',5577,'5','1',1656886.00,1658301.00,1415.00,247625.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','200',5578,'6','1',2201343.07,2202550.58,1207.51,211314.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','200',5579,'7','1',2072727.32,2074057.33,1330.01,232751.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','200',5580,'8','1',1718664.99,1719716.50,1051.51,184014.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','200',5581,'9','1',1950634.16,1951994.41,1360.25,238043.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','200',5582,'10','1',2128857.51,2130187.90,1330.39,232818.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','200',5583,'13','1',1975583.48,1977302.27,1718.79,300788.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','200',5584,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','200',5585,'15','1',1824688.41,1826071.07,1382.66,241965.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','200',5586,'16','1',1877163.35,1878196.44,1033.09,180790.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','200',5587,'17','1',1488532.37,1488532.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','200',5588,'18','1',1515085.93,1515085.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','200',5589,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','200',5590,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','200',5591,'25','1',1247210.21,1247210.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','200',5592,'26','1',1434565.49,1434565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','200',5593,'29','2',1383783.35,1384238.32,454.97,363976.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','200',5594,'30','2',60506.87,63615.28,3108.41,2486728.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','200',5595,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','200',5596,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','200',5597,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','200',5598,'34','3',723629.09,724097.63,468.54,402944.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','200',5599,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','200',5600,'36','1',2207333.52,2209112.54,1779.02,311328.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','201',5601,'1','1',2001103.36,2004646.43,3543.07,620037.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','201',5602,'2','1',2063667.08,2066104.74,2437.66,426590.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','201',5603,'3','1',2026456.09,2030651.31,4195.22,734163.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','201',5604,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','201',5605,'5','1',1658301.00,1660419.00,2118.00,370650.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','201',5606,'6','1',2202550.58,2205584.10,3033.52,530866.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','201',5607,'7','1',2074057.33,2075997.88,1940.55,339596.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','201',5608,'8','1',1719716.50,1722583.88,2867.38,501791.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','201',5609,'9','1',1951994.41,1956064.15,4069.74,712204.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','201',5610,'10','1',2130187.90,2135075.76,4887.86,855375.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','201',5611,'13','1',1977302.27,1982478.13,5175.86,905775.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','201',5612,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','201',5613,'15','1',1826071.07,1829636.03,3564.96,623868.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','201',5614,'16','1',1878196.44,1882163.36,3966.92,694211.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','201',5615,'17','1',1488532.37,1494795.21,6262.84,1095997.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','201',5616,'18','1',1515085.93,1517234.48,2148.55,375996.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','201',5617,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','201',5618,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','201',5619,'25','1',1247210.21,1249468.73,2258.52,395241.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','201',5620,'26','1',1434565.49,1439978.07,5412.58,947201.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','201',5621,'29','2',1384238.32,1384238.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','201',5622,'30','2',63615.28,65258.80,1643.52,1314816.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','201',5623,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','201',5624,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','201',5625,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','201',5626,'34','3',724097.63,724604.73,507.10,436106.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','201',5627,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','201',5628,'36','1',2209112.54,2213678.20,4565.66,798990.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','202',5629,'1','1',2004646.43,2008218.68,3572.25,625143.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','202',5630,'2','1',2066104.74,2068123.17,2018.43,353225.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','202',5631,'3','1',2030651.31,2035543.73,4892.42,856173.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','202',5632,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','202',5633,'5','1',1660419.00,1663328.00,2909.00,509075.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','202',5634,'6','1',2205584.10,2208891.86,3307.76,578858.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','202',5635,'7','1',2075997.88,2076129.86,131.98,23096.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','202',5636,'8','1',1722583.88,1726592.48,4008.60,701505.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','202',5637,'9','1',1956064.15,1958730.68,2666.53,466642.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','202',5638,'10','1',2135075.76,2138434.17,3358.41,587721.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','202',5639,'13','1',1982478.13,1985707.95,3229.82,565218.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','202',5640,'14','1',1536454.40,1536454.40,-48.57,-8499.75,0.00,0.00,48.57,0.00,0.00),('21','224','2','202',5641,'15','1',1829636.03,1831940.45,2304.42,403273.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','202',5642,'16','1',1882163.36,1884924.19,2618.88,458304.00,0.00,0.00,141.95,0.00,0.00),('21','224','3','202',5643,'17','1',1494795.21,1497333.47,2538.26,444195.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','202',5644,'18','1',1517234.48,1521035.66,3801.18,665206.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','202',5645,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','202',5646,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','202',5647,'25','1',1249468.73,1252838.23,3369.50,589662.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','202',5648,'26','1',1439978.07,1443958.48,3980.41,696571.75,0.00,0.00,0.00,0.00,0.00),('21','224','4','202',5649,'29','2',1384238.32,1384473.32,235.00,188000.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','202',5650,'30','2',65258.80,67923.20,2664.40,2131520.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','202',5651,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','202',5652,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','202',5653,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','202',5654,'34','3',724604.73,725235.59,630.86,542539.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','202',5655,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','202',5656,'36','1',2213678.20,2217256.68,3578.48,626234.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','203',5657,'1','1',2008218.68,2012995.00,4776.32,835856.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','203',5658,'2','1',2068123.17,2073392.82,5269.65,922188.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','203',5659,'3','1',2035543.73,2041792.09,6248.36,1093463.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','203',5660,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','203',5661,'5','1',1663328.00,1666930.00,3602.00,630350.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','203',5662,'6','1',2208891.86,2213561.90,4670.04,817257.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','203',5663,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','203',5664,'8','1',1726592.48,1732992.92,6400.44,1120077.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','203',5665,'9','1',1958730.68,1961780.09,3049.41,533646.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','203',5666,'10','1',2138434.17,2141954.59,3520.42,616073.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','203',5667,'13','1',1985707.95,1990044.88,4336.93,758962.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','203',5668,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','203',5669,'15','1',1831940.45,1835522.87,3582.42,626923.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','203',5670,'16','1',1884924.19,1886972.22,2048.03,358405.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','203',5671,'17','1',1497333.47,1497337.70,4.23,740.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','203',5672,'18','1',1521035.66,1528014.84,6979.18,1221356.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','203',5673,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','203',5674,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','203',5675,'25','1',1252838.23,1257094.86,4256.63,744910.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','203',5676,'26','1',1443958.48,1447650.07,3691.59,646028.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','203',5677,'29','2',1384473.32,1384473.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','203',5678,'30','2',67923.20,70219.16,2295.96,1836768.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','203',5679,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','203',5680,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','203',5681,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','203',5682,'34','3',725235.59,725860.02,624.43,537009.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','203',5683,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','203',5684,'36','1',2217256.68,2221441.72,4185.04,732382.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','204',5685,'1','1',2012995.00,2016141.83,3146.83,550695.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','204',5686,'2','1',2073392.82,2077521.33,4128.51,722489.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','204',5687,'3','1',2041792.09,2047127.84,5335.75,933756.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','204',5688,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','204',5689,'5','1',1666930.00,1671166.00,4236.00,741300.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','204',5690,'6','1',2213561.90,2216869.75,3307.85,578873.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','204',5691,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','204',5692,'8','1',1732992.92,1737768.26,4775.34,835684.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','204',5693,'9','1',1961780.09,1965607.46,3827.37,669789.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','204',5694,'10','1',2141954.59,2145811.87,3857.28,675024.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','204',5695,'13','1',1990044.88,1994743.16,4698.28,822199.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','204',5696,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','204',5697,'15','1',1835522.87,1839536.42,4013.55,702371.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','204',5698,'16','1',1886972.22,1890805.75,3833.53,670867.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','204',5699,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','204',5700,'18','1',1528014.84,1528715.99,701.15,122701.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','204',5701,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','204',5702,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','204',5703,'25','1',1257094.86,1257666.81,571.95,100091.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','204',5704,'26','1',1447650.07,1448019.35,369.28,64624.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','204',5705,'29','2',1384473.32,1384642.08,168.76,135008.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','204',5706,'30','2',70219.16,73011.87,2792.71,2234168.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','204',5707,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','204',5708,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','204',5709,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','204',5710,'34','3',725860.02,726391.28,531.26,456883.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','204',5711,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','204',5712,'36','1',2221441.72,2226267.88,4826.16,844578.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','205',5713,'1','1',2016141.83,2019832.31,3690.48,645834.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','205',5714,'2','1',2077521.33,2081496.75,3975.42,695698.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','205',5715,'3','1',2047127.84,2052326.59,5198.75,909781.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','205',5716,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','205',5717,'5','1',1671166.00,1673956.00,2790.00,488250.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','205',5718,'6','1',2216869.75,2220266.99,3397.24,594517.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','205',5719,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','205',5720,'8','1',1737768.26,1741837.57,4069.31,712129.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','205',5721,'9','1',1965607.46,1967119.81,1512.35,264661.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','205',5722,'10','1',2145811.87,2147146.46,1334.59,233553.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','205',5723,'13','1',1994743.16,1996440.98,1697.82,297118.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','205',5724,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','205',5725,'15','1',1839536.42,1840978.84,1442.42,252423.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','205',5726,'16','1',1890805.75,1891991.42,1185.67,207492.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','205',5727,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','205',5728,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','205',5729,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','205',5730,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','205',5731,'25','1',1257666.81,1257666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','205',5732,'26','1',1448019.35,1448019.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','205',5733,'29','2',1384642.08,1386114.28,1472.20,1177760.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','205',5734,'30','2',73011.87,74428.28,1416.41,1133128.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','205',5735,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','205',5736,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','205',5737,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','205',5738,'34','3',726391.28,726983.17,591.89,509025.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','205',5739,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','205',5740,'36','1',2226267.88,2227932.40,1664.52,291291.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','206',5741,'1','1',2019832.31,2024456.31,4624.00,809200.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','206',5742,'2','1',2081496.75,2086359.87,4863.12,851046.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','206',5743,'3','1',2052326.59,2058396.76,6070.17,1062279.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','206',5744,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','206',5745,'5','1',1673956.00,1678925.00,4969.00,869575.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','206',5746,'6','1',2220266.99,2224425.39,4158.40,727720.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','206',5747,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','206',5748,'8','1',1741837.57,1747297.98,5460.41,955571.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','206',5749,'9','1',1967119.81,1969165.75,2045.94,358039.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','206',5750,'10','1',2147146.46,2149688.08,2541.62,444783.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','206',5751,'13','1',1996440.98,1999690.05,3249.07,568587.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','206',5752,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','206',5753,'15','1',1840978.84,1842760.74,1781.90,311832.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','206',5754,'16','1',1891991.42,1894386.02,2394.60,419055.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','206',5755,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','206',5756,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','206',5757,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','206',5758,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','206',5759,'25','1',1257666.81,1257666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','206',5760,'26','1',1448019.35,1448019.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','206',5761,'29','2',1386114.28,1386114.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','206',5762,'30','2',74428.28,76048.78,1620.50,1296400.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','206',5763,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','206',5764,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','206',5765,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','206',5766,'34','3',726983.17,727456.18,473.01,406788.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','206',5767,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','206',5768,'36','1',2227932.40,2230937.19,3004.79,525838.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','207',5769,'1','1',2024456.31,2028149.81,3693.50,646362.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','207',5770,'2','1',2086359.87,2091099.40,4739.53,829417.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','207',5771,'3','1',2058396.76,2063933.56,5536.80,968940.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','207',5772,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','207',5773,'5','1',1678925.00,1682198.00,3273.00,572775.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','207',5774,'6','1',2224425.39,2228952.49,4527.10,792242.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','207',5775,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','207',5776,'8','1',1747297.98,1751852.67,4554.69,797070.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','207',5777,'9','1',1969165.75,1971402.41,2236.66,391415.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','207',5778,'10','1',2149688.08,2152062.79,2374.71,415574.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','207',5779,'13','1',1999690.05,2002226.27,2536.22,443838.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','207',5780,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','207',5781,'15','1',1842760.74,1844709.20,1948.46,340980.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','207',5782,'16','1',1894386.02,1896264.26,1878.24,328692.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','207',5783,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','207',5784,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','207',5785,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','207',5786,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','207',5787,'25','1',1257666.81,1257666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','207',5788,'26','1',1448019.35,1448019.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','207',5789,'29','2',1386114.28,1386114.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','207',5790,'30','2',76048.78,78517.69,2468.91,1975128.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','207',5791,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','207',5792,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','207',5793,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','207',5794,'34','3',727456.18,727800.75,344.57,296330.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','207',5795,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','207',5796,'36','1',2230937.19,2233349.47,2412.28,422149.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','208',5797,'1','1',2028149.81,2033346.68,5196.87,909452.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','208',5798,'2','1',2091099.40,2097135.13,6035.73,1056252.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','208',5799,'3','1',2063933.56,2071722.17,7788.61,1363006.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','208',5800,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','208',5801,'5','1',1682198.00,1686095.00,3897.00,681975.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','208',5802,'6','1',2228952.49,2234713.22,5760.73,1008127.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','208',5803,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','208',5804,'8','1',1751852.67,1758474.56,6621.89,1158830.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','208',5805,'9','1',1971402.41,1973759.16,2356.75,412431.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','208',5806,'10','1',2152062.79,2154951.31,2888.52,505491.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','208',5807,'13','1',2002226.27,2006246.35,4020.08,703514.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','208',5808,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','208',5809,'15','1',1844709.20,1847433.05,2723.85,476673.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','208',5810,'16','1',1896264.26,1899138.52,2874.26,502995.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','208',5811,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','208',5812,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','208',5813,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','208',5814,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','208',5815,'25','1',1257666.81,1257666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','208',5816,'26','1',1448019.35,1448019.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','208',5817,'29','2',1386114.28,1386875.03,760.75,608600.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','208',5818,'30','2',78517.69,86438.77,7921.08,6336864.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','208',5819,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','208',5820,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','208',5821,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','208',5822,'34','3',727800.75,727910.86,110.11,94694.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','208',5823,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','208',5824,'36','1',2233349.47,2237609.52,4260.05,745508.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','209',5825,'1','1',2033346.68,2039801.49,6454.81,1129591.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','209',5826,'2','1',2097135.13,2101521.57,4386.44,767627.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','209',5827,'3','1',2071722.17,2078787.70,7065.53,1236467.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','209',5828,'4','1',911879.18,911879.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','209',5829,'5','1',1686095.00,1690693.00,4598.00,804650.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','209',5830,'6','1',2234713.22,2240189.63,5476.41,958371.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','209',5831,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','209',5832,'8','1',1758474.56,1763770.31,5295.75,926756.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','209',5833,'9','1',1973759.16,1976543.48,2784.32,487256.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','209',5834,'10','1',2154951.31,2157919.20,2967.89,519380.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','209',5835,'13','1',2006246.35,2010274.90,4028.55,704996.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','209',5836,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','209',5837,'15','1',1847433.05,1849918.64,2485.59,434978.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','209',5838,'16','1',1899138.52,1902104.88,2966.36,519113.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','209',5839,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','209',5840,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','209',5841,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','209',5842,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','209',5843,'25','1',1257666.81,1257666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','209',5844,'26','1',1448019.35,1448019.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','209',5845,'29','2',1386875.03,1386875.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','209',5846,'30','2',86438.77,103738.28,17299.51,13839608.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','209',5847,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','209',5848,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','209',5849,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','209',5850,'34','3',727910.86,728439.11,528.25,454295.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','209',5851,'35','1',1073534.77,1073534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','209',5852,'36','1',2237609.52,2240821.11,3211.59,562028.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','210',5853,'1','1',2039801.49,2044046.14,4244.65,742813.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','210',5854,'2','1',2101521.57,2106702.30,5180.73,906627.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','210',5855,'3','1',2078787.70,2086514.02,7726.32,1352106.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','210',5856,'4','1',911879.18,911883.70,4.52,791.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','210',5857,'5','1',1690693.00,1695580.00,4887.00,855225.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','210',5858,'6','1',2240189.63,2245456.50,5266.87,921702.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','210',5859,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','210',5860,'8','1',1763770.31,1769898.01,6127.70,1072347.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','210',5861,'9','1',1976543.48,1979202.08,2658.60,465255.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','210',5862,'10','1',2157919.20,2161033.27,3114.07,544962.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','210',5863,'13','1',2010274.90,2013699.35,3424.45,599278.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','210',5864,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','210',5865,'15','1',1849918.64,1852683.68,2765.04,483882.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','210',5866,'16','1',1902104.88,1904836.48,2731.60,478030.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','210',5867,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','210',5868,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','210',5869,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','210',5870,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','210',5871,'25','1',1257666.81,1257666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','210',5872,'26','1',1448019.35,1448019.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','210',5873,'29','2',1386875.03,1390950.96,4075.93,3260744.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','210',5874,'30','2',103738.28,113884.99,10146.71,8117368.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','210',5875,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','210',5876,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','210',5877,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','210',5878,'34','3',728439.11,728936.04,496.93,427359.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','210',5879,'35','1',1073534.77,1073539.46,4.69,820.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','210',5880,'36','1',2240821.11,2244033.62,3212.51,562189.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','211',5881,'1','1',2044046.14,2047160.06,3113.92,544936.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','211',5882,'2','1',2106702.30,2109639.63,2937.33,514032.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','211',5883,'3','1',2086514.02,2090551.35,4037.33,706532.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','211',5884,'4','1',911883.70,911883.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','211',5885,'5','1',1695580.00,1698924.00,3344.00,585200.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','211',5886,'6','1',2245456.50,2248600.84,3144.34,550259.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','211',5887,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','211',5888,'8','1',1769898.01,1773780.26,3882.25,679393.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','211',5889,'9','1',1979202.08,1980299.79,1097.71,192099.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','211',5890,'10','1',2161033.27,2162550.57,1517.30,265527.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','211',5891,'13','1',2013699.35,2015092.64,1393.29,243825.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','211',5892,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','211',5893,'15','1',1852683.68,1853858.26,1174.58,205551.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','211',5894,'16','1',1904836.48,1905732.38,895.90,156782.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','211',5895,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','211',5896,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','211',5897,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','211',5898,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','211',5899,'25','1',1257666.81,1257666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','211',5900,'26','1',1448019.35,1448019.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','211',5901,'29','2',1390950.96,1391309.59,358.63,286904.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','211',5902,'30','2',113884.99,116882.52,2997.53,2398024.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','211',5903,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','211',5904,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','211',5905,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','211',5906,'34','3',728936.04,729192.21,256.17,220306.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','211',5907,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','211',5908,'36','1',2244033.62,2245009.68,976.06,170810.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','212',5909,'1','1',2047160.06,2049321.43,1964.23,343740.25,0.00,0.00,197.14,0.00,0.00),('21','224','1','212',5910,'2','1',2109639.63,2111014.87,1375.24,240667.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','212',5911,'3','1',2090551.35,2093159.98,2608.63,456510.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','212',5912,'4','1',911883.70,911883.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','212',5913,'5','1',1698924.00,1700697.00,1773.00,310275.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','212',5914,'6','1',2248600.84,2250063.31,1462.47,255932.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','212',5915,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','212',5916,'8','1',1773780.26,1775903.37,2123.11,371544.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','212',5917,'9','1',1980299.79,1981286.22,986.43,172625.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','212',5918,'10','1',2162550.57,2163885.11,1334.54,233544.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','212',5919,'13','1',2015092.64,2016439.88,1347.24,235767.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','212',5920,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','212',5921,'15','1',1853858.26,1854882.07,1023.81,179166.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','212',5922,'16','1',1905732.38,1906768.37,1035.99,181298.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','212',5923,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','212',5924,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','212',5925,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','212',5926,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','212',5927,'25','1',1257666.81,1257666.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','212',5928,'26','1',1448019.35,1448019.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','212',5929,'29','2',1391309.59,1392923.48,1613.89,1291112.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','212',5930,'30','2',116882.52,118622.77,1740.25,1392200.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','212',5931,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','212',5932,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','212',5933,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','212',5934,'34','3',729192.21,729192.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','212',5935,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','212',5936,'36','1',2245009.68,2246282.17,1272.49,222685.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','213',5937,'1','1',2049321.43,2054168.55,4847.12,848246.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','213',5938,'2','1',2111014.87,2114808.00,3793.13,663797.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','213',5939,'3','1',2093159.98,2100325.30,7165.32,1253931.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','213',5940,'4','1',911883.70,911883.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','213',5941,'5','1',1700697.00,1704888.00,4191.00,733425.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','213',5942,'6','1',2250063.31,2254024.79,3961.48,693259.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','213',5943,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','213',5944,'8','1',1775903.37,1781949.27,6045.90,1058032.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','213',5945,'9','1',1981286.22,1985456.26,4170.04,729757.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','213',5946,'10','1',2163885.11,2168359.77,4474.66,783065.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','213',5947,'13','1',2016439.88,2021128.33,4688.45,820478.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','213',5948,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','213',5949,'15','1',1854882.07,1858358.87,3476.80,608440.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','213',5950,'16','1',1906768.37,1911281.86,4513.49,789860.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','213',5951,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','213',5952,'18','1',1528715.99,1528715.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','213',5953,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','213',5954,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','213',5955,'25','1',1257666.81,1262264.49,4597.68,804594.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','213',5956,'26','1',1448019.35,1452601.28,4581.93,801837.75,0.00,0.00,0.00,0.00,0.00),('21','224','4','213',5957,'29','2',1392923.48,1396492.35,3568.87,2855096.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','213',5958,'30','2',118622.77,118894.66,271.89,217512.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','213',5959,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','213',5960,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','213',5961,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','213',5962,'34','3',729192.21,729192.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','213',5963,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','213',5964,'36','1',2246282.17,2251099.74,4817.57,843074.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','214',5965,'1','1',2054168.55,2058390.54,4221.99,738848.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','214',5966,'2','1',2114808.00,2118713.93,3905.93,683537.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','214',5967,'3','1',2100325.30,2106852.36,6527.06,1142235.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','214',5968,'4','1',911883.70,911883.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','214',5969,'5','1',1704888.00,1709553.00,4665.00,816375.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','214',5970,'6','1',2254024.79,2258177.68,4152.89,726755.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','214',5971,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','214',5972,'8','1',1781949.27,1787026.54,5077.27,888522.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','214',5973,'9','1',1985456.26,1988392.18,2935.92,513786.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','214',5974,'10','1',2168359.77,2171223.80,2864.03,501205.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','214',5975,'13','1',2021128.33,2025046.85,3918.52,685741.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','214',5976,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','214',5977,'15','1',1858358.87,1861580.58,3221.71,563799.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','214',5978,'16','1',1911281.86,1914273.91,2992.05,523608.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','214',5979,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','214',5980,'18','1',1528715.99,1542873.94,14157.95,2477641.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','214',5981,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','214',5982,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','214',5983,'25','1',1262264.49,1267089.98,4825.49,844460.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','214',5984,'26','1',1452601.28,1457198.00,4596.72,804426.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','214',5985,'29','2',1396492.35,1399263.19,2770.84,2216672.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','214',5986,'30','2',118894.66,118894.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','214',5987,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','214',5988,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','214',5989,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','214',5990,'34','3',729192.21,729192.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','214',5991,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','214',5992,'36','1',2251099.74,2255417.46,4317.72,755601.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','215',5993,'1','1',2058390.54,2061918.36,3527.82,617368.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','215',5994,'2','1',2118713.93,2122505.99,3792.06,663610.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','215',5995,'3','1',2106852.36,2113115.53,6263.17,1096054.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','215',5996,'4','1',911883.70,911883.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','215',5997,'5','1',1709553.00,1713586.00,4033.00,705775.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','215',5998,'6','1',2258177.68,2262477.88,4300.20,752535.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','215',5999,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','215',6000,'8','1',1787026.54,1791087.94,4061.40,710745.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','215',6001,'9','1',1988392.18,1989693.77,1301.59,227778.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','215',6002,'10','1',2171223.80,2172438.12,1214.32,212506.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','215',6003,'13','1',2025046.85,2026410.43,1363.58,238626.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','215',6004,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','215',6005,'15','1',1861580.58,1862775.98,1195.40,209195.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','215',6006,'16','1',1914273.91,1915327.51,1053.60,184380.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','215',6007,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','215',6008,'18','1',1542873.94,1542873.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','215',6009,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','215',6010,'22','3',943315.95,943315.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','215',6011,'25','1',1267089.98,1267089.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','215',6012,'26','1',1457198.00,1457198.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','215',6013,'29','2',1399263.19,1399263.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','215',6014,'30','2',118894.66,118894.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','215',6015,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','215',6016,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','215',6017,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','215',6018,'34','3',729192.21,729192.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','215',6019,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','215',6020,'36','1',2255417.46,2256884.57,1467.11,256744.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','216',6021,'1','1',2061918.36,2066208.88,4290.52,750841.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','216',6022,'2','1',2122505.99,2127205.81,4699.82,822468.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','216',6023,'3','1',2113115.53,2120145.83,7030.30,1230302.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','216',6024,'4','1',911883.70,911883.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','216',6025,'5','1',1713586.00,1718044.00,4458.00,780150.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','216',6026,'6','1',2262477.88,2266980.96,4503.08,788039.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','216',6027,'7','1',2076129.86,2076129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','216',6028,'8','1',1791087.94,1796956.82,5868.88,1027054.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','216',6029,'9','1',1989693.77,1992498.17,2804.40,490770.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','216',6030,'10','1',2172438.12,2175476.69,3038.57,531749.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','216',6031,'13','1',2026410.43,2031043.64,4633.21,810811.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','216',6032,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','216',6033,'15','1',1862775.98,1863034.15,258.17,45179.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','216',6034,'16','1',1915327.51,1915493.14,165.63,28985.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','216',6035,'17','1',1497337.70,1497337.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','216',6036,'18','1',1542873.94,1542873.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','216',6037,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','216',6038,'22','3',943315.95,943316.96,1.01,868.60,0.00,0.00,0.00,0.00,0.00),('21','224','3','216',6039,'25','1',1267089.98,1267089.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','216',6040,'26','1',1457198.00,1457198.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','216',6041,'29','2',1399263.19,1401242.76,1979.57,1583656.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','216',6042,'30','2',118894.66,118919.66,25.00,20000.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','216',6043,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','216',6044,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','216',6045,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','216',6046,'34','3',729192.21,729426.08,233.87,201128.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','216',6047,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','216',6048,'36','1',2256884.57,2257610.88,726.31,127104.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','217',6049,'1','1',2066208.88,2070590.39,3963.15,693551.25,0.00,0.00,418.36,0.00,0.00),('21','224','1','217',6050,'2','1',2127205.81,2131292.48,4086.67,715167.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','217',6051,'3','1',2120145.83,2125093.07,4947.24,865767.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','217',6052,'4','1',911883.70,914090.30,2206.60,386155.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','217',6053,'5','1',1718044.00,1721762.00,3718.00,650650.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','217',6054,'6','1',2266980.96,2271629.98,4649.02,813578.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','217',6055,'7','1',2076129.86,2078000.31,1870.45,327328.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','217',6056,'8','1',1796956.82,1800844.23,3887.41,680296.75,0.00,0.00,0.00,0.00,0.00),('21','224','2','217',6057,'9','1',1992498.17,1992533.68,35.51,6214.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','217',6058,'10','1',2175476.69,2175484.45,7.76,1358.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','217',6059,'13','1',2031043.64,2032160.46,1116.82,195443.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','217',6060,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','217',6061,'15','1',1863034.15,1863040.01,5.86,1025.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','217',6062,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','217',6063,'17','1',1497337.70,1497341.61,3.91,684.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','217',6064,'18','1',1542873.94,1548726.77,5852.83,1024245.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','217',6065,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','217',6066,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','217',6067,'25','1',1267089.98,1271056.92,3966.94,694214.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','217',6068,'26','1',1457198.00,1461818.80,4620.80,808640.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','217',6069,'29','2',1401242.76,1403989.07,2746.31,2238242.65,0.00,0.00,0.00,0.00,0.00),('21','224','4','217',6070,'30','2',118919.66,118919.76,0.10,81.50,0.00,0.00,0.00,0.00,0.00),('21','224','5','217',6071,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','217',6072,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','217',6073,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','217',6074,'34','3',729426.08,729993.42,567.34,487912.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','217',6075,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','217',6076,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','218',6077,'1','1',2070590.39,2070590.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','218',6078,'2','1',2131292.48,2131292.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','218',6079,'3','1',2125093.07,2125093.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','218',6080,'4','1',914090.30,914090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','218',6081,'5','1',1721762.00,1721762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','218',6082,'6','1',2271629.98,2271629.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','218',6083,'7','1',2078000.31,2078000.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','218',6084,'8','1',1800844.23,1800844.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','218',6085,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','218',6086,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','218',6087,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','218',6088,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','218',6089,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','218',6090,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','218',6091,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','218',6092,'18','1',1548726.77,1548726.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','218',6093,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','218',6094,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','218',6095,'25','1',1271056.92,1271056.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','218',6096,'26','1',1461818.80,1461818.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','218',6097,'29','2',1403989.07,1409229.15,5240.08,4270665.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','218',6098,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','218',6099,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','218',6100,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','218',6101,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','218',6102,'34','3',729993.42,730618.45,625.03,537525.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','218',6103,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','218',6104,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','219',6105,'1','1',2070590.39,2070590.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','219',6106,'2','1',2131292.48,2131292.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','219',6107,'3','1',2125093.07,2125093.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','219',6108,'4','1',914090.30,914090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','219',6109,'5','1',1721762.00,1721762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','219',6110,'6','1',2271629.98,2271629.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','219',6111,'7','1',2078000.31,2078000.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','219',6112,'8','1',1800844.23,1800844.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','219',6113,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','219',6114,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','219',6115,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','219',6116,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','219',6117,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','219',6118,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','219',6119,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','219',6120,'18','1',1548726.77,1548726.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','219',6121,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','219',6122,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','219',6123,'25','1',1271056.92,1271056.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','219',6124,'26','1',1461818.80,1461818.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','219',6125,'29','2',1409229.15,1409229.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','219',6126,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','219',6127,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','219',6128,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','219',6129,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','219',6130,'34','3',730618.45,730618.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','219',6131,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','219',6132,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','220',6133,'1','1',2070590.39,2073770.17,3179.78,556461.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','220',6134,'2','1',2131292.48,2133318.55,2026.07,354562.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','220',6135,'3','1',2125093.07,2128061.35,2968.28,519449.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','220',6136,'4','1',914090.30,916669.16,2578.86,451300.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','220',6137,'5','1',1721762.00,1723968.00,2206.00,386050.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','220',6138,'6','1',2271629.98,2274304.76,2674.78,468086.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','220',6139,'7','1',2078000.31,2080642.43,2642.12,462371.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','220',6140,'8','1',1800844.23,1802736.90,1892.67,331217.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','220',6141,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','220',6142,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','220',6143,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','220',6144,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','220',6145,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','220',6146,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','220',6147,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','220',6148,'18','1',1548726.77,1555795.17,7068.40,1236970.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','220',6149,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','220',6150,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','220',6151,'25','1',1271056.92,1277453.42,6396.50,1119387.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','220',6152,'26','1',1461818.80,1469091.66,7272.86,1272750.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','220',6153,'29','2',1409229.15,1414669.75,5440.60,4434089.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','220',6154,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','220',6155,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','220',6156,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','220',6157,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','220',6158,'34','3',730618.45,731177.43,558.98,480722.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','220',6159,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','220',6160,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','221',6161,'1','1',2073770.17,2078072.90,4302.73,752977.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','221',6162,'2','1',2133318.55,2137071.94,3753.39,656843.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','221',6163,'3','1',2128061.35,2132661.23,4599.88,804979.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','221',6164,'4','1',916669.16,919772.92,3103.76,543158.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','221',6165,'5','1',1723968.00,1727789.00,3821.00,668675.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','221',6166,'6','1',2274304.76,2277655.08,3350.32,586306.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','221',6167,'7','1',2080642.43,2083759.92,3117.49,545560.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','221',6168,'8','1',1802736.90,1805603.16,2866.26,501595.50,0.00,0.00,0.00,0.00,0.00),('21','224','2','221',6169,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','221',6170,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','221',6171,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','221',6172,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','221',6173,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','221',6174,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','221',6175,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','221',6176,'18','1',1555795.17,1560978.63,5183.46,907105.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','221',6177,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','221',6178,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','221',6179,'25','1',1277453.42,1281246.79,3793.37,663839.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','221',6180,'26','1',1469091.66,1472908.19,3816.53,667892.75,0.00,0.00,0.00,0.00,0.00),('21','224','4','221',6181,'29','2',1414669.75,1417379.38,2709.63,2208348.45,0.00,0.00,0.00,0.00,0.00),('21','224','4','221',6182,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','221',6183,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','221',6184,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','221',6185,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','221',6186,'34','3',731177.43,731643.89,466.46,401155.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','221',6187,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','221',6188,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','222',6189,'1','1',2078072.90,2078072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','222',6190,'2','1',2137071.94,2137071.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','222',6191,'3','1',2132661.23,2132661.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','222',6192,'4','1',919772.92,919772.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','222',6193,'5','1',1727789.00,1727789.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','222',6194,'6','1',2277655.08,2277655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','222',6195,'7','1',2083759.92,2083759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','222',6196,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','222',6197,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','222',6198,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','222',6199,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','222',6200,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','222',6201,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','222',6202,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','222',6203,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','222',6204,'18','1',1560978.63,1560978.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','222',6205,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','222',6206,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','222',6207,'25','1',1281246.79,1281246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','222',6208,'26','1',1472908.19,1472908.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','222',6209,'29','2',1417379.38,1417379.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','222',6210,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','222',6211,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','222',6212,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','222',6213,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','222',6214,'34','3',731643.89,731643.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','222',6215,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','222',6216,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','223',6217,'1','1',2078072.90,2078072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','223',6218,'2','1',2137071.94,2137071.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','223',6219,'3','1',2132661.23,2132661.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','223',6220,'4','1',919772.92,919772.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','223',6221,'5','1',1727789.00,1727789.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','223',6222,'6','1',2277655.08,2277655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','223',6223,'7','1',2083759.92,2083759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','223',6224,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','223',6225,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','223',6226,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','223',6227,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','223',6228,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','223',6229,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','223',6230,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','223',6231,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','223',6232,'18','1',1560978.63,1560978.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','223',6233,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','223',6234,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','223',6235,'25','1',1281246.79,1281246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','223',6236,'26','1',1472908.19,1472908.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','223',6237,'29','2',1417379.38,1417379.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','223',6238,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','223',6239,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','223',6240,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','223',6241,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','223',6242,'34','3',731643.89,731643.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','223',6243,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','223',6244,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','224',6245,'1','1',2078072.90,2087649.49,9576.59,1675903.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','224',6246,'2','1',2137071.94,2137071.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','224',6247,'3','1',2132661.23,2132661.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','224',6248,'4','1',919772.92,919772.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','224',6249,'5','1',1727789.00,1727789.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','224',6250,'6','1',2277655.08,2277655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','224',6251,'7','1',2083759.92,2083759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','224',6252,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','224',6253,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','224',6254,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','224',6255,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','224',6256,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','224',6257,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','224',6258,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','224',6259,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','224',6260,'18','1',1560978.63,1569079.10,8100.47,1417582.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','224',6261,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','224',6262,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','224',6263,'25','1',1281246.79,1281246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','224',6264,'26','1',1472908.19,1472908.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','224',6265,'29','2',1417379.38,1417379.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','224',6266,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','224',6267,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','224',6268,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','224',6269,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','224',6270,'34','3',731643.89,731643.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','224',6271,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','224',6272,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','225',6273,'1','1',2087649.49,2087649.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','225',6274,'2','1',2137071.94,2137071.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','225',6275,'3','1',2132661.23,2132661.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','225',6276,'4','1',919772.92,919772.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','225',6277,'5','1',1727789.00,1727789.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','225',6278,'6','1',2277655.08,2277655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','225',6279,'7','1',2083759.92,2083759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','225',6280,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','225',6281,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','225',6282,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','225',6283,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','225',6284,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','225',6285,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','225',6286,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','225',6287,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','225',6288,'18','1',1569079.10,1569079.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','225',6289,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','225',6290,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','225',6291,'25','1',1281246.79,1281246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','225',6292,'26','1',1472908.19,1472908.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','225',6293,'29','2',1417379.38,1417379.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','225',6294,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','225',6295,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','225',6296,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','225',6297,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','225',6298,'34','3',731643.89,731643.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','225',6299,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','225',6300,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','226',6301,'1','1',2087649.49,2087649.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','226',6302,'2','1',2137071.94,2137071.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','226',6303,'3','1',2132661.23,2132661.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','226',6304,'4','1',919772.92,919772.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','226',6305,'5','1',1727789.00,1727789.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','226',6306,'6','1',2277655.08,2277655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','226',6307,'7','1',2083759.92,2083759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','226',6308,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','226',6309,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','226',6310,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','226',6311,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','226',6312,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','226',6313,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','226',6314,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','226',6315,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','226',6316,'18','1',1569079.10,1569079.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','226',6317,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','226',6318,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','226',6319,'25','1',1281246.79,1281246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','226',6320,'26','1',1472908.19,1472908.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','226',6321,'29','2',1417379.38,1417379.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','226',6322,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','226',6323,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','226',6324,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','226',6325,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','226',6326,'34','3',731643.89,731643.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','226',6327,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','226',6328,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','227',6329,'1','1',2087649.49,2087649.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','227',6330,'2','1',2137071.94,2137071.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','227',6331,'3','1',2132661.23,2132661.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','227',6332,'4','1',919772.92,919772.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','227',6333,'5','1',1727789.00,1727789.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','227',6334,'6','1',2277655.08,2277655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','227',6335,'7','1',2083759.92,2083759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','227',6336,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','227',6337,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','227',6338,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','227',6339,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','227',6340,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','227',6341,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','227',6342,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','227',6343,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','227',6344,'18','1',1569079.10,1569079.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','227',6345,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','227',6346,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','227',6347,'25','1',1281246.79,1281246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','227',6348,'26','1',1472908.19,1472908.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','227',6349,'29','2',1417379.38,1417379.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','227',6350,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','227',6351,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','227',6352,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','227',6353,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','227',6354,'34','3',731643.89,731643.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','227',6355,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','227',6356,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','228',6357,'1','1',2087649.49,2087649.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','228',6358,'2','1',2137071.94,2137071.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','228',6359,'3','1',2132661.23,2132661.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','228',6360,'4','1',919772.92,919772.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','228',6361,'5','1',1727789.00,1727789.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','228',6362,'6','1',2277655.08,2277655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','228',6363,'7','1',2083759.92,2083759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','228',6364,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','228',6365,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','228',6366,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','228',6367,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','228',6368,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','228',6369,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','228',6370,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','228',6371,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','228',6372,'18','1',1569079.10,1569079.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','228',6373,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','228',6374,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','228',6375,'25','1',1281246.79,1281246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','228',6376,'26','1',1472908.19,1472908.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','228',6377,'29','2',1417379.38,1417379.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','228',6378,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','228',6379,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','228',6380,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','228',6381,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','228',6382,'34','3',731643.89,731643.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','228',6383,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','228',6384,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','229',6385,'1','1',2087649.49,2087649.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','229',6386,'2','1',2137071.94,2141154.21,4082.27,714397.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','229',6387,'3','1',2132661.23,2136597.56,3936.33,688857.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','229',6388,'4','1',919772.92,924026.10,4253.18,744306.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','229',6389,'5','1',1727789.00,1731274.00,3485.00,609875.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','229',6390,'6','1',2277655.08,2281394.31,3739.23,654365.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','229',6391,'7','1',2083759.92,2083759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','229',6392,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','229',6393,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','229',6394,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','229',6395,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','229',6396,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','229',6397,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','229',6398,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','229',6399,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','229',6400,'18','1',1569079.10,1569079.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','229',6401,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','229',6402,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','229',6403,'25','1',1281246.79,1281718.42,471.63,82535.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','229',6404,'26','1',1472908.19,1473733.15,824.96,144368.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','229',6405,'29','2',1417379.38,1420132.72,2753.34,2243972.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','229',6406,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','229',6407,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','229',6408,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','229',6409,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','229',6410,'34','3',731643.89,732226.20,582.31,500786.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','229',6411,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','229',6412,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','230',6413,'1','1',2087649.49,2087649.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','230',6414,'2','1',2141154.21,2146594.48,5440.27,952047.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','230',6415,'3','1',2136597.56,2142587.25,5989.69,1048195.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','230',6416,'4','1',924026.10,929294.54,5268.44,921977.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','230',6417,'5','1',1731274.00,1736919.00,5645.00,987875.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','230',6418,'6','1',2281394.31,2287125.32,5731.01,1002926.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','230',6419,'7','1',2083759.92,2092865.72,9105.80,1593515.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','230',6420,'8','1',1805603.16,1805603.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','230',6421,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','230',6422,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','230',6423,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','230',6424,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','230',6425,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','230',6426,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','230',6427,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','230',6428,'18','1',1569079.10,1569079.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','230',6429,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','230',6430,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','230',6431,'25','1',1281718.42,1281718.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','230',6432,'26','1',1473733.15,1473733.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','230',6433,'29','2',1420132.72,1423263.13,3130.41,2551284.15,0.00,0.00,0.00,0.00,0.00),('21','224','4','230',6434,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','230',6435,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','230',6436,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','230',6437,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','230',6438,'34','3',732226.20,732643.05,416.85,358491.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','230',6439,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','230',6440,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','231',6441,'1','1',2087649.49,2092253.90,4604.41,805771.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','231',6442,'2','1',2146594.48,2150934.49,4340.01,759501.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','231',6443,'3','1',2142587.25,2146374.47,3787.22,662763.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','231',6444,'4','1',929294.54,934019.25,4724.71,826824.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','231',6445,'5','1',1736919.00,1740954.00,4035.00,706125.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','231',6446,'6','1',2287125.32,2291097.00,3971.68,695044.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','231',6447,'7','1',2092865.72,2097309.19,4443.47,777607.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','231',6448,'8','1',1805603.16,1809493.12,3889.96,680743.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','231',6449,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','231',6450,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','231',6451,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','231',6452,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','231',6453,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','231',6454,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','231',6455,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','231',6456,'18','1',1569079.10,1574589.87,5510.77,964384.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','231',6457,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','231',6458,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','231',6459,'25','1',1281718.42,1291299.27,9580.85,1676648.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','231',6460,'26','1',1473733.15,1486179.07,12445.92,2178036.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','231',6461,'29','2',1423263.13,1426331.51,3068.38,2500729.70,0.00,0.00,0.00,0.00,0.00),('21','224','4','231',6462,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','231',6463,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','231',6464,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','231',6465,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','231',6466,'34','3',732643.05,733115.39,472.34,406212.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','231',6467,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','231',6468,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','232',6469,'1','1',2092253.90,2096526.75,4272.85,747748.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','232',6470,'2','1',2150934.49,2154960.61,4026.12,704571.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','232',6471,'3','1',2146374.47,2149705.16,3330.69,582870.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','232',6472,'4','1',934019.25,938479.47,4460.22,780538.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','232',6473,'5','1',1740954.00,1745353.00,4399.00,769825.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','232',6474,'6','1',2291097.00,2295094.50,3997.50,699562.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','232',6475,'7','1',2097309.19,2101769.99,4460.80,780640.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','232',6476,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','232',6477,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','232',6478,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','232',6479,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','232',6480,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','232',6481,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','232',6482,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','232',6483,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','232',6484,'18','1',1574589.87,1580528.00,5938.13,1039172.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','232',6485,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','232',6486,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','232',6487,'25','1',1291299.27,1295735.83,4436.56,776398.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','232',6488,'26','1',1486179.07,1491695.26,5516.19,965333.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','232',6489,'29','2',1426331.51,1432865.59,6534.08,5325275.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','232',6490,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','232',6491,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','232',6492,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','232',6493,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','232',6494,'34','3',733115.39,733734.37,618.98,532322.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','232',6495,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','232',6496,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','233',6497,'1','1',2096526.75,2100426.46,3899.71,682449.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','233',6498,'2','1',2154960.61,2159849.82,4889.21,855611.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','233',6499,'3','1',2149705.16,2154600.11,4894.95,856616.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','233',6500,'4','1',938479.47,943210.01,4730.54,827844.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','233',6501,'5','1',1745353.00,1750212.00,4859.00,850325.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','233',6502,'6','1',2295094.50,2299571.31,4476.81,783441.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','233',6503,'7','1',2101769.99,2107216.22,5446.23,953090.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','233',6504,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','233',6505,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','233',6506,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','233',6507,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','233',6508,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','233',6509,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','233',6510,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','233',6511,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','233',6512,'18','1',1580528.00,1587671.50,7143.50,1250112.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','233',6513,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','233',6514,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','233',6515,'25','1',1295735.83,1300026.00,4290.17,750779.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','233',6516,'26','1',1491695.26,1497351.05,5655.79,989763.25,0.00,0.00,0.00,0.00,0.00),('21','224','4','233',6517,'29','2',1432865.59,1435592.86,2727.27,2263634.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','233',6518,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','233',6519,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','233',6520,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','233',6521,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','233',6522,'34','3',733734.37,734106.11,371.74,319696.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','233',6523,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','233',6524,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','234',6525,'1','1',2100426.46,2100783.41,356.95,62466.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','234',6526,'2','1',2159849.82,2167379.99,7530.17,1317779.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','234',6527,'3','1',2154600.11,2159441.36,4841.25,847218.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','234',6528,'4','1',943210.01,948161.46,4951.45,866503.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','234',6529,'5','1',1750212.00,1754785.00,4573.00,800275.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','234',6530,'6','1',2299571.31,2304768.02,5196.71,909424.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','234',6531,'7','1',2107216.22,2112479.66,5263.44,921102.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','234',6532,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','234',6533,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','234',6534,'10','1',2175484.45,2175484.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','234',6535,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','234',6536,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','234',6537,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','234',6538,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','234',6539,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','234',6540,'18','1',1587671.50,1594326.06,6654.56,1164548.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','234',6541,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','234',6542,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','234',6543,'25','1',1300026.00,1305398.44,5372.44,940177.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','234',6544,'26','1',1497351.05,1503190.81,5839.76,1021958.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','234',6545,'29','2',1435592.86,1439038.50,3445.64,2859881.20,0.00,0.00,0.00,0.00,0.00),('21','224','4','234',6546,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','234',6547,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','234',6548,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','234',6549,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','234',6550,'34','3',734106.11,735103.11,997.00,857420.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','234',6551,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','234',6552,'36','1',2257610.88,2257610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','235',6553,'1','1',2100783.41,2104822.87,4039.46,706905.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','235',6554,'2','1',2167379.99,2171107.60,3727.61,652331.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','235',6555,'3','1',2159441.36,2163517.38,4076.02,713303.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','235',6556,'4','1',948161.46,952880.47,4719.01,825826.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','235',6557,'5','1',1754785.00,1757346.00,2561.00,448175.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','235',6558,'6','1',2304768.02,2309904.86,5136.84,898947.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','235',6559,'7','1',2112479.66,2117552.91,5073.25,887818.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','235',6560,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','235',6561,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','235',6562,'10','1',2175484.45,2175484.48,0.03,5.25,0.00,0.00,0.00,0.00,0.00),('21','224','2','235',6563,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','235',6564,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','235',6565,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','235',6566,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','235',6567,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','235',6568,'18','1',1594326.06,1601090.88,6764.82,1183843.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','235',6569,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','235',6570,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','235',6571,'25','1',1305398.44,1311136.05,5737.61,1004081.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','235',6572,'26','1',1503190.81,1508950.51,5759.70,1007947.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','235',6573,'29','2',1439038.50,1442431.57,3393.07,2816248.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','235',6574,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','235',6575,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','235',6576,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','235',6577,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','235',6578,'34','3',735103.11,735746.55,643.44,553358.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','235',6579,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','235',6580,'36','1',2257610.88,2257610.99,0.11,19.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','236',6581,'1','1',2104822.87,2109530.77,4707.90,823882.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','236',6582,'2','1',2171107.60,2175656.22,4548.62,796008.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','236',6583,'3','1',2163517.38,2167325.10,3807.72,666351.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','236',6584,'4','1',952880.47,956896.80,4016.33,702857.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','236',6585,'5','1',1757346.00,1761043.00,3697.00,646975.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','236',6586,'6','1',2309904.86,2314544.46,4639.60,811930.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','236',6587,'7','1',2117552.91,2121601.48,4048.57,708499.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','236',6588,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','236',6589,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','236',6590,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','236',6591,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','236',6592,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','236',6593,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','236',6594,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','236',6595,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','236',6596,'18','1',1601090.88,1606786.33,5695.45,996703.75,0.00,0.00,0.00,0.00,0.00),('21','224','6','236',6597,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','236',6598,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','236',6599,'25','1',1311136.05,1315511.57,4375.52,765716.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','236',6600,'26','1',1508950.51,1514443.95,5493.44,961352.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','236',6601,'29','2',1442431.57,1445896.44,3464.87,2875842.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','236',6602,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','236',6603,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','236',6604,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','236',6605,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','236',6606,'34','3',735746.55,736227.51,480.96,413625.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','236',6607,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','236',6608,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','237',6609,'1','1',2109530.77,2115122.41,5591.64,978537.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','237',6610,'2','1',2175656.22,2178629.36,2973.14,520299.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','237',6611,'3','1',2167325.10,2171853.86,4528.76,792533.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','237',6612,'4','1',956896.80,961143.79,4246.99,743223.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','237',6613,'5','1',1761043.00,1765331.00,4288.00,750400.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','237',6614,'6','1',2314544.46,2318701.54,4157.08,727489.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','237',6615,'7','1',2121601.48,2125986.15,4384.67,767317.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','237',6616,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','237',6617,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','237',6618,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','237',6619,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','237',6620,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','237',6621,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','237',6622,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','237',6623,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','237',6624,'18','1',1606786.33,1612142.31,5355.98,937296.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','237',6625,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','237',6626,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','237',6627,'25','1',1315511.57,1320106.40,4594.83,804095.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','237',6628,'26','1',1514443.95,1519497.57,5053.62,884383.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','237',6629,'29','2',1445896.44,1445896.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','237',6630,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','237',6631,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','237',6632,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','237',6633,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','237',6634,'34','3',736227.51,736227.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','237',6635,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','237',6636,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','238',6637,'1','1',2115122.41,2119948.92,4826.51,844639.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','238',6638,'2','1',2178629.36,2182802.62,4173.26,730320.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','238',6639,'3','1',2171853.86,2175379.30,3525.44,616952.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','238',6640,'4','1',961143.79,964919.45,3775.66,660740.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','238',6641,'5','1',1765331.00,1769300.00,3969.00,694575.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','238',6642,'6','1',2318701.54,2323220.74,4519.20,790860.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','238',6643,'7','1',2125986.15,2130193.37,4207.22,736263.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','238',6644,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','238',6645,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','238',6646,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','238',6647,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','238',6648,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','238',6649,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','238',6650,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','238',6651,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','238',6652,'18','1',1612142.31,1617401.50,5259.19,920358.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','238',6653,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','238',6654,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','238',6655,'25','1',1320106.40,1325589.24,5482.84,959497.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','238',6656,'26','1',1519497.57,1524616.67,5119.10,895842.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','238',6657,'29','2',1445896.44,1449959.76,4063.32,3372555.60,0.00,0.00,0.00,0.00,0.00),('21','224','4','238',6658,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','238',6659,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','238',6660,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','238',6661,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','238',6662,'34','3',736227.51,736747.90,520.39,447535.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','238',6663,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','238',6664,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','239',6665,'1','1',2119948.92,2124491.19,4542.27,794897.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','239',6666,'2','1',2182802.62,2187526.64,4724.02,826703.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','239',6667,'3','1',2175379.30,2178937.30,3558.00,622650.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','239',6668,'4','1',964919.45,968305.84,3386.39,592618.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','239',6669,'5','1',1769300.00,1773525.00,4225.00,739375.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','239',6670,'6','1',2323220.74,2328334.46,5113.72,894901.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','239',6671,'7','1',2130193.37,2134932.51,4739.14,829349.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','239',6672,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','239',6673,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','239',6674,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','239',6675,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','239',6676,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','239',6677,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','239',6678,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','239',6679,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','239',6680,'18','1',1617401.50,1622947.29,5545.79,970513.25,0.00,0.00,0.00,0.00,0.00),('21','224','6','239',6681,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','239',6682,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','239',6683,'25','1',1325589.24,1330509.48,4920.24,861042.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','239',6684,'26','1',1524616.67,1529307.32,4690.65,820863.75,0.00,0.00,0.00,0.00,0.00),('21','224','4','239',6685,'29','2',1449959.76,1455988.63,6028.87,5003962.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','239',6686,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','239',6687,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','239',6688,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','239',6689,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','239',6690,'34','3',736747.90,737209.73,461.83,397173.80,0.00,0.00,0.00,0.00,0.00),('21','224','2','239',6691,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','239',6692,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','240',6693,'1','1',2124491.19,2129461.53,4970.34,869809.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','240',6694,'2','1',2187526.64,2192505.00,4978.36,871213.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','240',6695,'3','1',2178937.30,2182101.73,3164.43,553775.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','240',6696,'4','1',968305.84,971405.30,3099.46,542405.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','240',6697,'5','1',1773525.00,1777826.00,4301.00,752675.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','240',6698,'6','1',2328334.46,2333087.73,4753.27,831822.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','240',6699,'7','1',2134932.51,2139616.16,4683.65,819638.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','240',6700,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','240',6701,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','240',6702,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','240',6703,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','240',6704,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','240',6705,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','240',6706,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','240',6707,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','240',6708,'18','1',1622947.29,1628538.55,5591.26,978470.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','240',6709,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','240',6710,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','240',6711,'25','1',1330509.48,1335505.61,4996.13,874322.75,0.00,0.00,0.00,0.00,0.00),('21','224','3','240',6712,'26','1',1529307.32,1533736.18,4428.86,775050.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','240',6713,'29','2',1455988.63,1458480.00,2491.37,2067837.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','240',6714,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','240',6715,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','240',6716,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','240',6717,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','240',6718,'34','3',737209.73,737539.92,330.19,283963.40,0.00,0.00,0.00,0.00,0.00),('21','224','2','240',6719,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','240',6720,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','241',6721,'1','1',2129461.53,2129461.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','241',6722,'2','1',2192505.00,2192505.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','241',6723,'3','1',2182101.73,2182101.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','241',6724,'4','1',971405.30,971405.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','241',6725,'5','1',1777826.00,1777826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','241',6726,'6','1',2333087.73,2333087.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','241',6727,'7','1',2139616.16,2139616.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','241',6728,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','241',6729,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','241',6730,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','241',6731,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','241',6732,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','241',6733,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','241',6734,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','241',6735,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','241',6736,'18','1',1628538.55,1628538.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','241',6737,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','241',6738,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','241',6739,'25','1',1335505.61,1335505.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','241',6740,'26','1',1533736.18,1533736.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','241',6741,'29','2',1458480.00,1458480.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','241',6742,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','241',6743,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','241',6744,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','241',6745,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','241',6746,'34','3',737539.92,737539.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','241',6747,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','241',6748,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','242',6749,'1','1',2129461.53,2133540.13,4078.60,713755.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','242',6750,'2','1',2192505.00,2197456.92,4951.92,866586.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','242',6751,'3','1',2182101.73,2185716.54,3614.81,632591.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','242',6752,'4','1',971405.30,974718.37,3313.07,579787.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','242',6753,'5','1',1777826.00,1782703.00,4877.00,853475.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','242',6754,'6','1',2333087.73,2337423.03,4335.30,758677.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','242',6755,'7','1',2139616.16,2144133.61,4517.45,790553.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','242',6756,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','242',6757,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','242',6758,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','242',6759,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','242',6760,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','242',6761,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','242',6762,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','242',6763,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','242',6764,'18','1',1628538.55,1633919.09,5380.54,941594.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','242',6765,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','242',6766,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','242',6767,'25','1',1335505.61,1340448.76,4943.15,865051.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','242',6768,'26','1',1533736.18,1538508.92,4772.74,835229.50,0.00,0.00,0.00,0.00,0.00),('21','224','4','242',6769,'29','2',1458480.00,1464599.47,6119.47,5079160.10,0.00,0.00,0.00,0.00,0.00),('21','224','4','242',6770,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','242',6771,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','242',6772,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','242',6773,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','242',6774,'34','3',737539.92,737814.62,274.70,236242.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','242',6775,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','242',6776,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','243',6777,'1','1',2133540.13,2138885.48,5345.35,935436.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','243',6778,'2','1',2197456.92,2202294.78,4837.86,846625.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','243',6779,'3','1',2185716.54,2189223.72,3507.18,613756.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','243',6780,'4','1',974718.37,977713.59,2995.22,524163.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','243',6781,'5','1',1782703.00,1786834.00,4131.00,722925.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','243',6782,'6','1',2337423.03,2342369.19,4946.16,865578.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','243',6783,'7','1',2144133.61,2148248.48,4114.87,720102.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','243',6784,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','243',6785,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','243',6786,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','243',6787,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','243',6788,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','243',6789,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','243',6790,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','243',6791,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','243',6792,'18','1',1633919.09,1639612.13,5693.04,996282.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','243',6793,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','243',6794,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','243',6795,'25','1',1340448.76,1345101.07,4652.31,814154.25,0.00,0.00,0.00,0.00,0.00),('21','224','3','243',6796,'26','1',1538508.92,1543195.13,4686.21,820086.75,0.00,0.00,0.00,0.00,0.00),('21','224','4','243',6797,'29','2',1464599.47,1465877.27,1277.80,1060574.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','243',6798,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','243',6799,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','243',6800,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','243',6801,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','243',6802,'34','3',737814.62,738188.49,373.87,321528.20,0.00,0.00,0.00,0.00,0.00),('21','224','2','243',6803,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','243',6804,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','244',6805,'1','1',2138885.48,2138885.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','244',6806,'2','1',2202294.78,2202294.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','244',6807,'3','1',2189223.72,2189223.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','244',6808,'4','1',977713.59,977713.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','244',6809,'5','1',1786834.00,1786834.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','244',6810,'6','1',2342369.19,2342369.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','244',6811,'7','1',2148248.48,2148248.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','244',6812,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','244',6813,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','244',6814,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','244',6815,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','244',6816,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','244',6817,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','244',6818,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','244',6819,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','244',6820,'18','1',1639612.13,1639612.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','244',6821,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','244',6822,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','244',6823,'25','1',1345101.07,1345101.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','244',6824,'26','1',1543195.13,1543195.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','244',6825,'29','2',1465877.27,1465877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','244',6826,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','244',6827,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','244',6828,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','244',6829,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','244',6830,'34','3',738188.49,738188.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','244',6831,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','244',6832,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','245',6833,'1','1',2138885.48,2138885.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','245',6834,'2','1',2202294.78,2202294.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','245',6835,'3','1',2189223.72,2189223.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','245',6836,'4','1',977713.59,977713.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','245',6837,'5','1',1786834.00,1786834.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','245',6838,'6','1',2342369.19,2342369.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','245',6839,'7','1',2148248.48,2148248.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','245',6840,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','245',6841,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','245',6842,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','245',6843,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','245',6844,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','245',6845,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','245',6846,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','245',6847,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','245',6848,'18','1',1639612.13,1639612.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','245',6849,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','245',6850,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','245',6851,'25','1',1345101.07,1345101.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','245',6852,'26','1',1543195.13,1543195.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','245',6853,'29','2',1465877.27,1465877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','245',6854,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','245',6855,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','245',6856,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','245',6857,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','245',6858,'34','3',738188.49,738188.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','245',6859,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','245',6860,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','246',6861,'1','1',2138885.48,2141266.35,2380.87,416652.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','246',6862,'2','1',2202294.78,2204421.88,2127.10,372242.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','246',6863,'3','1',2189223.72,2190910.90,1687.18,295256.50,0.00,0.00,0.00,0.00,0.00),('21','224','1','246',6864,'4','1',977713.59,979396.10,1682.51,294439.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','246',6865,'5','1',1786834.00,1789233.00,2399.00,419825.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','246',6866,'6','1',2342369.19,2344929.30,2560.11,448019.25,0.00,0.00,0.00,0.00,0.00),('21','224','1','246',6867,'7','1',2148248.48,2150384.25,2135.77,373759.75,0.00,0.00,0.00,0.00,0.00),('21','224','1','246',6868,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','246',6869,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','246',6870,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','246',6871,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','246',6872,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','246',6873,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','246',6874,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','246',6875,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','246',6876,'18','1',1639612.13,1644954.63,5342.50,934937.50,0.00,0.00,0.00,0.00,0.00),('21','224','6','246',6877,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','246',6878,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','246',6879,'25','1',1345101.07,1350169.01,5067.94,886889.50,0.00,0.00,0.00,0.00,0.00),('21','224','3','246',6880,'26','1',1543195.13,1548158.77,4963.64,868637.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','246',6881,'29','2',1465877.27,1465877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','246',6882,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','246',6883,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','246',6884,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','246',6885,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','246',6886,'34','3',738188.49,738796.80,608.31,523146.60,0.00,0.00,0.00,0.00,0.00),('21','224','2','246',6887,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','246',6888,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','247',6889,'1','1',2141266.35,2141266.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','247',6890,'2','1',2204421.88,2204421.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','247',6891,'3','1',2190910.90,2190910.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','247',6892,'4','1',979396.10,979396.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','247',6893,'5','1',1789233.00,1789233.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','247',6894,'6','1',2344929.30,2344929.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','247',6895,'7','1',2150384.25,2150384.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','247',6896,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','247',6897,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','247',6898,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','247',6899,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','247',6900,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','247',6901,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','247',6902,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','247',6903,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','247',6904,'18','1',1644954.63,1644954.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','247',6905,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','247',6906,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','247',6907,'25','1',1350169.01,1350169.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','247',6908,'26','1',1548158.77,1548158.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','247',6909,'29','2',1465877.27,1465877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','247',6910,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','247',6911,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','247',6912,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','247',6913,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','247',6914,'34','3',738796.80,738796.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','247',6915,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','247',6916,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','248',6917,'1','1',2141266.35,2141266.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','248',6918,'2','1',2204421.88,2204421.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','248',6919,'3','1',2190910.90,2190910.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','248',6920,'4','1',979396.10,979396.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','248',6921,'5','1',1789233.00,1789233.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','248',6922,'6','1',2344929.30,2344929.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','248',6923,'7','1',2150384.25,2150384.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','1','248',6924,'8','1',1809493.12,1809493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','248',6925,'9','1',1992533.68,1992533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','248',6926,'10','1',2175484.48,2175484.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','248',6927,'13','1',2032160.46,2032160.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','248',6928,'14','1',1536454.40,1536454.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','248',6929,'15','1',1863040.01,1863040.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','248',6930,'16','1',1915493.14,1915493.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','248',6931,'17','1',1497341.61,1497341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','248',6932,'18','1',1644954.63,1644954.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','248',6933,'21','3',333292.12,333292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','248',6934,'22','3',943316.96,943316.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','248',6935,'25','1',1350169.01,1350169.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','3','248',6936,'26','1',1548158.77,1548158.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','248',6937,'29','2',1465877.27,1465877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','4','248',6938,'30','2',118919.76,118919.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','248',6939,'31','2',842316.72,842316.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','5','248',6940,'32','2',32971.91,32971.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','248',6941,'33','3',613.95,613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','6','248',6942,'34','3',738796.80,738796.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','248',6943,'35','1',1073539.46,1073539.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','224','2','248',6944,'36','1',2257610.99,2257610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=745 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','224','4','1',165.00,165.00,44990.87,0.00,0.00,0.00,0.00,10),('21','224','4','2',700.00,700.00,6391.89,0.00,0.00,0.00,0.00,11),('21','224','4','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,12),('21','224','5','1',165.00,165.00,40160.91,0.00,0.00,0.00,0.00,13),('21','224','5','2',700.00,700.00,6564.95,0.00,0.00,0.00,0.00,14),('21','224','5','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,15),('21','224','6','2',700.00,700.00,5540.24,0.00,0.00,0.00,0.00,16),('21','224','6','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,17),('21','224','6','1',165.00,165.00,48566.65,0.00,0.00,0.00,0.00,18),('21','224','7','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,19),('21','224','7','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,20),('21','224','7','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,21),('21','224','8','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,22),('21','224','8','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,23),('21','224','8','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,24),('21','224','9','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,25),('21','224','9','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,26),('21','224','9','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,27),('21','224','10','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,28),('21','224','10','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,29),('21','224','10','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,30),('21','224','11','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,31),('21','224','11','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,32),('21','224','11','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,33),('21','224','12','2',700.00,700.00,24249.74,0.00,0.00,0.00,0.00,34),('21','224','12','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,35),('21','224','12','1',165.00,165.00,57726.00,0.00,0.00,0.00,0.00,36),('21','224','13','2',700.00,700.00,14624.49,0.00,0.00,0.00,0.00,37),('21','224','13','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,38),('21','224','13','1',165.00,165.00,43586.00,0.00,0.00,0.00,0.00,39),('21','224','14','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,40),('21','224','14','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,41),('21','224','14','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,42),('21','224','15','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,43),('21','224','15','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,44),('21','224','15','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,45),('21','224','16','2',700.00,700.00,6294.18,0.00,0.00,0.00,0.00,46),('21','224','16','3',550.00,550.00,1145.79,0.00,0.00,0.00,0.00,47),('21','224','16','1',165.00,165.00,55178.78,0.00,0.00,0.00,0.00,48),('21','224','17','2',700.00,700.00,4705.91,0.00,0.00,0.00,0.00,49),('21','224','17','3',550.00,550.00,1393.81,0.00,0.00,0.00,0.00,50),('21','224','17','1',165.00,165.00,35707.30,0.00,0.00,0.00,0.00,51),('21','224','18','2',700.00,700.00,5656.66,0.00,0.00,0.00,0.00,52),('21','224','18','3',550.00,550.00,1794.36,0.00,0.00,0.00,0.00,53),('21','224','18','1',165.00,165.00,42743.20,0.00,0.00,0.00,0.00,54),('21','224','19','2',700.00,700.00,6228.45,0.00,0.00,0.00,0.00,55),('21','224','19','3',550.00,550.00,1587.81,0.00,0.00,0.00,0.00,56),('21','224','19','1',165.00,165.00,76768.67,0.00,0.00,0.00,0.00,57),('21','224','20','2',700.00,700.00,7119.26,0.00,0.00,0.00,0.00,58),('21','224','20','3',550.00,550.00,1129.14,0.00,0.00,0.00,0.00,59),('21','224','20','1',165.00,165.00,51577.38,0.00,0.00,0.00,0.00,60),('21','224','21','2',700.00,700.00,6606.33,0.00,0.00,0.00,0.00,61),('21','224','21','3',550.00,550.00,1136.59,0.00,0.00,0.00,0.00,62),('21','224','21','1',165.00,165.00,51510.20,0.00,0.00,0.00,0.00,63),('21','224','22','1',165.00,165.00,58680.20,0.00,0.00,0.00,0.00,64),('21','224','22','2',700.00,700.00,5691.36,0.00,0.00,0.00,0.00,65),('21','224','22','3',550.00,550.00,739.36,0.00,0.00,0.00,0.00,66),('21','224','23','2',700.00,700.00,3753.60,0.00,0.00,0.00,0.00,67),('21','224','23','3',550.00,550.00,908.41,0.00,0.00,0.00,0.00,68),('21','224','23','1',165.00,165.00,45148.31,0.00,0.00,0.00,0.00,69),('21','224','24','1',165.00,165.00,43390.66,0.00,0.00,0.00,0.00,70),('21','224','24','2',700.00,700.00,5552.32,0.00,0.00,0.00,0.00,71),('21','224','24','3',550.00,550.00,900.58,0.00,0.00,0.00,0.00,72),('21','224','25','2',700.00,700.00,4857.02,0.00,0.00,0.00,0.00,73),('21','224','25','3',550.00,550.00,1067.37,0.00,0.00,0.00,0.00,74),('21','224','25','1',165.00,165.00,49808.73,0.00,0.00,0.00,0.00,75),('21','224','26','2',700.00,700.00,4527.94,0.00,0.00,0.00,0.00,76),('21','224','26','3',550.00,550.00,971.57,0.00,0.00,0.00,0.00,77),('21','224','26','1',165.00,165.00,52934.98,0.00,0.00,0.00,0.00,78),('21','224','27','2',700.00,700.00,5310.01,0.00,0.00,0.00,0.00,79),('21','224','27','3',550.00,550.00,956.31,0.00,0.00,0.00,0.00,80),('21','224','27','1',165.00,165.00,53551.25,0.00,0.00,0.00,0.00,81),('21','224','28','2',700.00,700.00,4968.92,0.00,0.00,0.00,0.00,82),('21','224','28','3',550.00,550.00,902.19,0.00,0.00,0.00,0.00,83),('21','224','28','1',165.00,165.00,51578.22,0.00,0.00,0.00,0.00,84),('21','224','29','2',700.00,700.00,6255.49,0.00,0.00,0.00,0.00,85),('21','224','29','3',550.00,550.00,891.83,0.00,0.00,0.00,0.00,86),('21','224','29','1',165.00,165.00,40752.09,0.00,0.00,0.00,0.00,87),('21','224','30','1',165.00,165.00,53075.64,0.00,0.00,0.00,0.00,88),('21','224','30','2',700.00,700.00,8807.27,0.00,0.00,0.00,0.00,89),('21','224','30','3',550.00,550.00,810.39,0.00,0.00,0.00,0.00,90),('21','224','31','1',165.00,165.00,46947.07,0.00,0.00,0.00,0.00,91),('21','224','31','2',700.00,700.00,6323.45,0.00,0.00,0.00,0.00,92),('21','224','31','3',550.00,550.00,1036.88,0.00,0.00,0.00,0.00,93),('21','224','32','1',165.00,165.00,48423.75,0.00,0.00,0.00,0.00,94),('21','224','32','2',700.00,700.00,12351.13,0.00,0.00,0.00,0.00,95),('21','224','32','3',550.00,550.00,832.87,0.00,0.00,0.00,0.00,96),('21','224','33','1',165.00,165.00,67122.55,0.00,0.00,0.00,0.00,97),('21','224','33','2',700.00,700.00,8791.76,0.00,0.00,0.00,0.00,98),('21','224','33','3',550.00,550.00,1171.29,0.00,0.00,0.00,0.00,99),('21','224','34','2',700.00,700.00,5522.65,0.00,0.00,0.00,0.00,100),('21','224','34','3',550.00,550.00,892.96,0.00,0.00,0.00,0.00,101),('21','224','34','1',165.00,165.00,47589.26,0.00,0.00,0.00,0.00,102),('21','224','35','1',165.00,165.00,63322.70,0.00,0.00,0.00,0.00,103),('21','224','35','2',700.00,700.00,7397.63,0.00,0.00,0.00,0.00,104),('21','224','35','3',550.00,550.00,994.62,0.00,0.00,0.00,0.00,105),('21','224','36','2',700.00,700.00,7196.14,0.00,0.00,0.00,0.00,106),('21','224','36','3',550.00,550.00,1010.21,0.00,0.00,0.00,0.00,107),('21','224','36','1',165.00,165.00,47116.94,0.00,0.00,0.00,0.00,108),('21','224','37','2',700.00,700.00,5520.70,0.00,0.00,0.00,0.00,109),('21','224','37','3',550.00,550.00,1062.12,0.00,0.00,0.00,0.00,110),('21','224','37','1',165.00,165.00,40658.93,0.00,0.00,0.00,0.00,111),('21','224','38','1',165.00,165.00,38561.32,0.00,0.00,0.00,0.00,112),('21','224','38','2',700.00,700.00,4824.48,0.00,0.00,0.00,0.00,113),('21','224','38','3',550.00,550.00,673.82,0.00,0.00,0.00,0.00,114),('21','224','39','2',700.00,700.00,4977.52,0.00,0.00,0.00,0.00,115),('21','224','39','3',550.00,550.00,903.73,0.00,0.00,0.00,0.00,116),('21','224','39','1',165.00,165.00,49019.78,0.00,0.00,0.00,0.00,117),('21','224','40','2',700.00,700.00,7993.75,0.00,0.00,0.00,0.00,118),('21','224','40','3',550.00,550.00,1158.25,0.00,0.00,0.00,0.00,119),('21','224','40','1',165.00,165.00,62636.59,0.00,0.00,0.00,0.00,120),('21','224','41','1',165.00,165.00,61448.02,0.00,0.00,0.00,0.00,121),('21','224','41','2',700.00,700.00,9128.59,0.00,0.00,0.00,0.00,122),('21','224','41','3',550.00,550.00,1182.54,0.00,0.00,0.00,0.00,123),('21','224','42','2',700.00,700.00,7865.70,0.00,0.00,0.00,0.00,124),('21','224','42','3',550.00,550.00,1212.81,0.00,0.00,0.00,0.00,125),('21','224','42','1',165.00,165.00,57706.36,0.00,0.00,0.00,0.00,126),('21','224','43','1',165.00,165.00,72170.97,0.00,0.00,0.00,0.00,127),('21','224','43','2',700.00,700.00,4724.32,0.00,0.00,0.00,0.00,128),('21','224','43','3',550.00,550.00,975.74,0.00,0.00,0.00,0.00,129),('21','224','44','1',165.00,165.00,66070.86,0.00,0.00,0.00,0.00,130),('21','224','44','2',700.00,700.00,5409.56,0.00,0.00,0.00,0.00,131),('21','224','44','3',550.00,550.00,1002.05,0.00,0.00,0.00,0.00,132),('21','224','45','1',165.00,165.00,52181.06,0.00,0.00,0.00,0.00,133),('21','224','45','2',700.00,700.00,3767.49,0.00,0.00,0.00,0.00,134),('21','224','45','3',550.00,550.00,889.01,0.00,0.00,0.00,0.00,135),('21','224','46','2',700.00,700.00,7887.10,0.00,0.00,0.00,0.00,136),('21','224','46','3',550.00,550.00,1012.33,0.00,0.00,0.00,0.00,137),('21','224','46','1',165.00,165.00,66155.47,0.00,0.00,0.00,0.00,138),('21','224','47','2',700.00,700.00,10062.45,0.00,0.00,0.00,0.00,139),('21','224','47','3',550.00,550.00,757.11,0.00,0.00,0.00,0.00,140),('21','224','47','1',165.00,165.00,12939.05,0.00,0.00,0.00,0.00,141),('21','224','48','2',700.00,700.00,20138.19,0.00,0.00,0.00,0.00,142),('21','224','48','3',550.00,550.00,1123.56,0.00,0.00,0.00,0.00,143),('21','224','48','1',165.00,165.00,133216.52,0.00,0.00,0.00,0.00,144),('21','224','49','2',700.00,700.00,257.01,0.00,0.00,0.00,0.00,145),('21','224','49','3',550.00,550.00,2225.23,0.00,0.00,0.00,0.00,146),('21','224','49','1',165.00,165.00,40611.74,0.00,0.00,0.00,0.00,147),('21','224','50','2',700.00,700.00,5911.82,0.00,0.00,0.00,0.00,148),('21','224','50','3',550.00,550.00,1174.88,0.00,0.00,0.00,0.00,149),('21','224','50','1',165.00,165.00,88732.94,0.00,0.00,0.00,0.00,150),('21','224','51','1',165.00,165.00,32667.91,0.00,0.00,0.00,0.00,151),('21','224','51','2',700.00,700.00,5264.81,0.00,0.00,0.00,0.00,152),('21','224','51','3',550.00,550.00,1675.35,0.00,0.00,0.00,0.00,153),('21','224','52','1',165.00,165.00,61708.80,0.00,0.00,0.00,0.00,154),('21','224','52','2',700.00,700.00,2413.75,0.00,0.00,0.00,0.00,155),('21','224','52','3',550.00,550.00,1372.15,0.00,0.00,0.00,0.00,156),('21','224','53','1',165.00,165.00,53161.59,0.00,0.00,0.00,0.00,157),('21','224','53','2',700.00,700.00,2920.59,0.00,0.00,0.00,0.00,158),('21','224','53','3',550.00,550.00,1267.20,0.00,0.00,0.00,0.00,159),('21','224','54','1',165.00,165.00,35842.29,0.00,0.00,0.00,0.00,160),('21','224','54','2',700.00,700.00,4516.88,0.00,0.00,0.00,0.00,161),('21','224','54','3',550.00,550.00,2103.69,0.00,0.00,0.00,0.00,162),('21','224','55','1',165.00,165.00,62961.77,0.00,0.00,0.00,0.00,163),('21','224','55','2',700.00,700.00,3251.51,0.00,0.00,0.00,0.00,164),('21','224','55','3',550.00,550.00,2239.72,0.00,0.00,0.00,0.00,165),('21','224','56','2',700.00,700.00,4397.19,0.00,0.00,0.00,0.00,166),('21','224','56','3',550.00,550.00,1972.78,0.00,0.00,0.00,0.00,167),('21','224','56','1',165.00,165.00,74669.04,0.00,0.00,0.00,0.00,168),('21','224','57','1',165.00,165.00,66432.52,0.00,0.00,0.00,0.00,169),('21','224','57','2',700.00,700.00,7019.26,0.00,0.00,0.00,0.00,170),('21','224','57','3',550.00,550.00,2461.43,0.00,0.00,0.00,0.00,171),('21','224','58','1',165.00,165.00,72634.48,0.00,0.00,0.00,0.00,172),('21','224','58','2',700.00,700.00,5821.16,0.00,0.00,0.00,0.00,173),('21','224','58','3',650.00,650.00,1709.13,0.00,0.00,0.00,0.00,174),('21','224','59','2',700.00,700.00,4019.14,0.00,0.00,0.00,0.00,175),('21','224','59','3',650.00,650.00,1670.45,0.00,0.00,0.00,0.00,176),('21','224','59','1',165.00,165.00,90016.03,0.00,0.00,0.00,0.00,177),('21','224','60','2',700.00,700.00,5147.81,0.00,0.00,0.00,0.00,178),('21','224','60','3',650.00,650.00,872.07,0.00,0.00,0.00,0.00,179),('21','224','60','1',165.00,165.00,6697.40,0.00,0.00,0.00,0.00,180),('21','224','61','2',700.00,700.00,5008.99,0.00,0.00,0.00,0.00,181),('21','224','61','3',650.00,650.00,1672.12,0.00,0.00,0.00,0.00,182),('21','224','61','1',165.00,165.00,65263.13,0.00,0.00,0.00,0.00,183),('21','224','62','2',700.00,700.00,8681.99,0.00,0.00,0.00,0.00,184),('21','224','62','3',650.00,650.00,926.31,0.00,0.00,0.00,0.00,185),('21','224','62','1',165.00,165.00,49500.58,0.00,0.00,0.00,0.00,186),('21','224','63','2',700.00,700.00,6511.20,0.00,0.00,0.00,0.00,187),('21','224','63','3',650.00,650.00,974.71,0.00,0.00,0.00,0.00,188),('21','224','63','1',165.00,165.00,84210.62,0.00,0.00,0.00,0.00,189),('21','224','64','2',700.00,700.00,8899.38,0.00,0.00,0.00,0.00,190),('21','224','64','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,191),('21','224','64','1',165.00,165.00,70974.74,0.00,0.00,0.00,0.00,192),('21','224','65','1',165.00,165.00,95056.89,0.00,0.00,0.00,0.00,193),('21','224','65','2',720.00,720.00,8359.53,0.00,0.00,0.00,0.00,194),('21','224','65','3',650.00,650.00,187.76,0.00,0.00,0.00,0.00,195),('21','224','66','1',165.00,165.00,69427.73,0.00,0.00,0.00,0.00,196),('21','224','66','2',720.00,720.00,4957.34,0.00,0.00,0.00,0.00,197),('21','224','66','3',650.00,650.00,1032.81,0.00,0.00,0.00,0.00,198),('21','224','67','1',165.00,165.00,79418.41,0.00,0.00,0.00,0.00,199),('21','224','67','2',720.00,720.00,12771.23,0.00,0.00,0.00,0.00,200),('21','224','67','3',650.00,650.00,1408.18,0.00,0.00,0.00,0.00,201),('21','224','68','2',720.00,720.00,8655.94,0.00,0.00,0.00,0.00,202),('21','224','68','3',650.00,650.00,1231.68,0.00,0.00,0.00,0.00,203),('21','224','68','1',165.00,165.00,78525.39,0.00,0.00,0.00,0.00,204),('21','224','69','1',165.00,165.00,66818.29,0.00,0.00,0.00,0.00,205),('21','224','69','2',720.00,720.00,12614.88,0.00,0.00,0.00,0.00,206),('21','224','69','3',650.00,650.00,1091.97,0.00,0.00,0.00,0.00,207),('21','224','70','1',165.00,165.00,77964.81,0.00,0.00,0.00,0.00,208),('21','224','70','2',720.00,720.00,6677.92,0.00,0.00,0.00,0.00,209),('21','224','70','3',650.00,650.00,859.27,0.00,0.00,0.00,0.00,210),('21','224','71','2',720.00,720.00,8961.23,0.00,0.00,0.00,0.00,211),('21','224','71','3',650.00,650.00,966.35,0.00,0.00,0.00,0.00,212),('21','224','71','1',165.00,165.00,81563.70,0.00,0.00,0.00,0.00,213),('21','224','72','1',165.00,165.00,53051.03,0.00,0.00,0.00,0.00,214),('21','224','72','2',720.00,720.00,7508.86,0.00,0.00,0.00,0.00,215),('21','224','72','3',650.00,650.00,1235.62,0.00,0.00,0.00,0.00,216),('21','224','73','2',720.00,720.00,4563.03,0.00,0.00,0.00,0.00,217),('21','224','73','3',650.00,650.00,790.92,0.00,0.00,0.00,0.00,218),('21','224','73','1',165.00,165.00,36064.29,0.00,0.00,0.00,0.00,219),('21','224','74','2',720.00,720.00,0.00,0.00,0.00,0.00,0.00,220),('21','224','74','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,221),('21','224','74','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,222),('21','224','75','2',760.00,760.00,16000.31,0.00,0.00,0.00,0.00,223),('21','224','75','3',650.00,650.00,1059.53,0.00,0.00,0.00,0.00,224),('21','224','75','1',165.00,165.00,75607.16,0.00,0.00,0.00,0.00,225),('21','224','76','1',165.00,165.00,41843.90,0.00,0.00,0.00,0.00,226),('21','224','76','2',760.00,760.00,13859.94,0.00,0.00,0.00,0.00,227),('21','224','76','3',650.00,650.00,903.78,0.00,0.00,0.00,0.00,228),('21','224','77','1',165.00,165.00,55287.17,0.00,0.00,0.00,0.00,229),('21','224','77','2',760.00,760.00,4704.94,0.00,0.00,0.00,0.00,230),('21','224','77','3',650.00,650.00,544.04,0.00,0.00,0.00,0.00,231),('21','224','78','1',165.00,165.00,64658.81,0.00,0.00,0.00,0.00,232),('21','224','78','2',760.00,760.00,7861.69,0.00,0.00,0.00,0.00,233),('21','224','78','3',650.00,650.00,921.12,0.00,0.00,0.00,0.00,234),('21','224','79','1',165.00,165.00,48578.84,0.00,0.00,0.00,0.00,235),('21','224','79','2',760.00,760.00,7215.87,0.00,0.00,0.00,0.00,236),('21','224','79','3',650.00,650.00,891.51,0.00,0.00,0.00,0.00,237),('21','224','80','2',760.00,760.00,7598.07,0.00,0.00,0.00,0.00,238),('21','224','80','3',650.00,650.00,1138.92,0.00,0.00,0.00,0.00,239),('21','224','80','1',165.00,165.00,59556.65,0.00,0.00,0.00,0.00,240),('21','224','81','1',165.00,165.00,52437.08,0.00,0.00,0.00,0.00,241),('21','224','81','2',760.00,760.00,5753.55,0.00,0.00,0.00,0.00,242),('21','224','81','3',650.00,650.00,1133.72,0.00,0.00,0.00,0.00,243),('21','224','82','2',760.00,760.00,8545.10,0.00,0.00,0.00,0.00,244),('21','224','82','3',650.00,650.00,934.39,0.00,0.00,0.00,0.00,245),('21','224','82','1',165.00,165.00,52895.49,0.00,0.00,0.00,0.00,246),('21','224','83','1',165.00,165.00,50695.87,0.00,0.00,0.00,0.00,247),('21','224','83','2',760.00,760.00,9536.26,0.00,0.00,0.00,0.00,248),('21','224','83','3',650.00,650.00,1177.78,0.00,0.00,0.00,0.00,249),('21','224','84','1',165.00,165.00,36940.04,0.00,0.00,0.00,0.00,250),('21','224','84','2',760.00,760.00,5612.27,0.00,0.00,0.00,0.00,251),('21','224','84','3',650.00,650.00,1390.16,0.00,0.00,0.00,0.00,252),('21','224','85','1',165.00,165.00,41725.94,0.00,0.00,0.00,0.00,253),('21','224','85','2',760.00,760.00,5710.63,0.00,0.00,0.00,0.00,254),('21','224','85','3',650.00,650.00,11928.99,0.00,0.00,0.00,0.00,255),('21','224','86','1',165.00,165.00,62388.94,0.00,0.00,0.00,0.00,256),('21','224','86','2',760.00,760.00,10431.33,0.00,0.00,0.00,0.00,257),('21','224','86','3',650.00,650.00,1921.36,0.00,0.00,0.00,0.00,258),('21','224','87','1',165.00,165.00,57262.54,0.00,0.00,0.00,0.00,259),('21','224','87','2',760.00,760.00,7342.10,0.00,0.00,0.00,0.00,260),('21','224','87','3',650.00,650.00,2239.46,0.00,0.00,0.00,0.00,261),('21','224','88','1',165.00,165.00,63641.86,0.00,0.00,0.00,0.00,262),('21','224','88','2',780.00,780.00,7184.33,0.00,0.00,0.00,0.00,263),('21','224','88','3',650.00,650.00,2043.17,0.00,0.00,0.00,0.00,264),('21','224','89','1',165.00,165.00,35163.01,0.00,0.00,0.00,0.00,265),('21','224','89','2',780.00,780.00,10931.58,0.00,0.00,0.00,0.00,266),('21','224','89','3',650.00,650.00,2825.11,0.00,0.00,0.00,0.00,267),('21','224','90','1',165.00,165.00,85530.43,0.00,0.00,0.00,0.00,268),('21','224','90','2',780.00,780.00,10387.77,0.00,0.00,0.00,0.00,269),('21','224','90','3',650.00,650.00,1587.48,0.00,0.00,0.00,0.00,270),('21','224','91','1',165.00,165.00,59217.86,0.00,0.00,0.00,0.00,271),('21','224','91','2',800.00,800.00,12965.23,0.00,0.00,0.00,0.00,272),('21','224','91','3',650.00,650.00,1452.28,0.00,0.00,0.00,0.00,273),('21','224','92','1',165.00,165.00,39091.10,0.00,0.00,0.00,0.00,274),('21','224','92','2',800.00,800.00,16569.99,0.00,0.00,0.00,0.00,275),('21','224','92','3',650.00,650.00,617.95,0.00,0.00,0.00,0.00,276),('21','224','93','1',165.00,165.00,54150.73,0.00,0.00,0.00,0.00,277),('21','224','93','2',800.00,800.00,15158.43,0.00,0.00,0.00,0.00,278),('21','224','93','3',700.00,700.00,1196.28,0.00,0.00,0.00,0.00,279),('21','224','94','1',165.00,165.00,50734.11,0.00,0.00,0.00,0.00,280),('21','224','94','2',820.00,820.00,933.55,0.00,0.00,0.00,0.00,281),('21','224','94','3',700.00,700.00,1617.04,0.00,0.00,0.00,0.00,282),('21','224','95','2',820.00,820.00,5072.85,0.00,0.00,0.00,0.00,283),('21','224','95','3',700.00,700.00,567.28,0.00,0.00,0.00,0.00,284),('21','224','95','1',165.00,165.00,47013.99,0.00,0.00,0.00,0.00,285),('21','224','96','1',165.00,165.00,34003.54,0.00,0.00,0.00,0.00,286),('21','224','96','2',820.00,820.00,4707.70,0.00,0.00,0.00,0.00,287),('21','224','96','3',700.00,700.00,1092.59,0.00,0.00,0.00,0.00,288),('21','224','97','1',165.00,165.00,52188.41,0.00,0.00,0.00,0.00,289),('21','224','97','2',820.00,820.00,5920.44,0.00,0.00,0.00,0.00,290),('21','224','97','3',700.00,700.00,978.14,0.00,0.00,0.00,0.00,291),('21','224','98','2',820.00,820.00,7696.23,0.00,0.00,0.00,0.00,292),('21','224','98','3',700.00,700.00,999.94,0.00,0.00,0.00,0.00,293),('21','224','98','1',165.00,165.00,39127.89,0.00,0.00,0.00,0.00,294),('21','224','99','1',165.00,165.00,31626.48,0.00,0.00,0.00,0.00,295),('21','224','99','2',820.00,820.00,9817.56,0.00,0.00,0.00,0.00,296),('21','224','99','3',750.00,750.00,930.49,0.00,0.00,0.00,0.00,297),('21','224','100','1',165.00,165.00,57882.43,0.00,0.00,0.00,0.00,298),('21','224','100','2',830.00,830.00,6038.39,0.00,0.00,0.00,0.00,299),('21','224','100','3',750.00,750.00,934.60,0.00,0.00,0.00,0.00,300),('21','224','101','1',165.00,165.00,58270.27,0.00,0.00,0.00,0.00,301),('21','224','101','2',830.00,830.00,5670.97,0.00,0.00,0.00,0.00,302),('21','224','101','3',750.00,750.00,8702.88,0.00,0.00,0.00,0.00,303),('21','224','102','1',165.00,165.00,41049.01,0.00,0.00,0.00,0.00,304),('21','224','102','2',830.00,830.00,4272.93,0.00,0.00,0.00,0.00,305),('21','224','102','3',750.00,750.00,791.56,0.00,0.00,0.00,0.00,306),('21','224','103','1',165.00,165.00,46700.18,0.00,0.00,0.00,0.00,307),('21','224','103','2',830.00,830.00,8001.56,0.00,0.00,0.00,0.00,308),('21','224','103','3',750.00,750.00,1046.45,0.00,0.00,0.00,0.00,309),('21','224','104','1',165.00,165.00,40312.05,0.00,0.00,0.00,0.00,310),('21','224','104','2',830.00,830.00,5705.16,0.00,0.00,0.00,0.00,311),('21','224','104','3',750.00,750.00,969.29,0.00,0.00,0.00,0.00,312),('21','224','105','1',165.00,165.00,43350.33,0.00,0.00,0.00,0.00,313),('21','224','105','2',830.00,830.00,3656.66,0.00,0.00,0.00,0.00,314),('21','224','105','3',750.00,750.00,1171.09,0.00,0.00,0.00,0.00,315),('21','224','106','2',830.00,830.00,4581.02,0.00,0.00,0.00,0.00,316),('21','224','106','3',750.00,750.00,897.05,0.00,0.00,0.00,0.00,317),('21','224','106','1',165.00,165.00,41754.77,0.00,0.00,0.00,0.00,318),('21','224','107','1',165.00,165.00,28960.90,0.00,0.00,0.00,0.00,319),('21','224','107','2',830.00,830.00,23784.38,0.00,0.00,0.00,0.00,320),('21','224','107','3',750.00,750.00,757.11,0.00,0.00,0.00,0.00,321),('21','224','108','1',165.00,165.00,6788.46,0.00,0.00,0.00,0.00,322),('21','224','108','2',830.00,830.00,11211.64,0.00,0.00,0.00,0.00,323),('21','224','108','3',750.00,750.00,1043.71,0.00,0.00,0.00,0.00,324),('21','224','109','1',165.00,165.00,61305.28,0.00,0.00,0.00,0.00,325),('21','224','109','2',830.00,830.00,3466.23,0.00,0.00,0.00,0.00,326),('21','224','109','3',750.00,750.00,807.50,0.00,0.00,0.00,0.00,327),('21','224','110','1',165.00,165.00,61829.88,0.00,0.00,0.00,0.00,328),('21','224','110','2',830.00,830.00,3658.28,0.00,0.00,0.00,0.00,329),('21','224','110','3',750.00,750.00,1065.74,0.00,0.00,0.00,0.00,330),('21','224','111','2',830.00,830.00,4952.43,0.00,0.00,0.00,0.00,331),('21','224','111','3',750.00,750.00,869.48,0.00,0.00,0.00,0.00,332),('21','224','111','1',165.00,165.00,44903.20,0.00,0.00,0.00,0.00,333),('21','224','112','2',830.00,830.00,7922.46,0.00,0.00,0.00,0.00,334),('21','224','112','3',750.00,750.00,735.00,0.00,0.00,0.00,0.00,335),('21','224','112','1',165.00,165.00,31282.61,0.00,0.00,0.00,0.00,336),('21','224','113','2',830.00,830.00,7162.92,0.00,0.00,0.00,0.00,337),('21','224','113','3',750.00,750.00,1169.36,0.00,0.00,0.00,0.00,338),('21','224','113','1',165.00,165.00,65308.18,0.00,0.00,0.00,0.00,339),('21','224','114','1',165.00,165.00,47950.64,0.00,0.00,0.00,0.00,340),('21','224','114','2',830.00,830.00,6051.77,0.00,0.00,0.00,0.00,341),('21','224','114','3',750.00,750.00,3851.06,0.00,0.00,0.00,0.00,342),('21','224','115','2',830.00,830.00,9183.07,0.00,0.00,0.00,0.00,343),('21','224','115','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,344),('21','224','115','1',165.00,165.00,51623.65,0.00,0.00,0.00,0.00,345),('21','224','116','1',165.00,165.00,28466.42,0.00,0.00,0.00,0.00,346),('21','224','116','2',830.00,830.00,3824.90,0.00,0.00,0.00,0.00,347),('21','224','116','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,348),('21','224','117','1',165.00,165.00,44938.46,0.00,0.00,0.00,0.00,349),('21','224','117','2',830.00,830.00,6127.99,0.00,0.00,0.00,0.00,350),('21','224','117','3',750.00,750.00,38.79,0.00,0.00,0.00,0.00,351),('21','224','118','2',830.00,830.00,3652.94,0.00,0.00,0.00,0.00,352),('21','224','118','3',750.00,750.00,675.13,0.00,0.00,0.00,0.00,353),('21','224','118','1',165.00,165.00,39758.57,0.00,0.00,0.00,0.00,354),('21','224','119','2',830.00,830.00,2686.49,0.00,0.00,0.00,0.00,355),('21','224','119','3',750.00,750.00,963.69,0.00,0.00,0.00,0.00,356),('21','224','119','1',165.00,165.00,45265.05,0.00,0.00,0.00,0.00,357),('21','224','120','1',185.00,165.00,45290.46,0.00,0.00,0.00,0.00,358),('21','224','120','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,359),('21','224','120','3',750.00,750.00,735.30,0.00,0.00,0.00,0.00,360),('21','224','121','1',185.00,165.00,45102.66,0.00,0.00,0.00,0.00,361),('21','224','121','2',830.00,830.00,6865.84,0.00,0.00,0.00,0.00,362),('21','224','121','3',750.00,750.00,932.61,0.00,0.00,0.00,0.00,363),('21','224','122','1',185.00,165.00,50191.75,0.00,0.00,0.00,0.00,364),('21','224','122','2',830.00,830.00,2056.86,0.00,0.00,0.00,0.00,365),('21','224','122','3',750.00,750.00,2887.73,0.00,0.00,0.00,0.00,366),('21','224','123','2',830.00,830.00,888.27,0.00,0.00,0.00,0.00,367),('21','224','123','3',750.00,750.00,717.77,0.00,0.00,0.00,0.00,368),('21','224','123','1',185.00,165.00,0.00,0.00,0.00,0.00,0.00,369),('21','224','124','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,370),('21','224','124','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,371),('21','224','124','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,372),('21','224','125','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,373),('21','224','125','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,374),('21','224','125','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,375),('21','224','126','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,376),('21','224','126','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,377),('21','224','126','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,378),('21','224','127','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,379),('21','224','127','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,380),('21','224','127','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,381),('21','224','128','1',185.00,185.00,81755.56,0.00,0.00,0.00,0.00,382),('21','224','128','2',830.00,830.00,2630.25,0.00,0.00,0.00,0.00,383),('21','224','128','3',750.00,750.00,595.27,0.00,0.00,0.00,0.00,384),('21','224','129','2',830.00,830.00,1834.22,0.00,0.00,0.00,0.00,385),('21','224','129','3',750.00,750.00,1198.17,0.00,0.00,0.00,0.00,386),('21','224','129','1',165.00,165.00,86268.28,0.00,0.00,0.00,0.00,387),('21','224','130','1',165.00,165.00,77886.01,0.00,0.00,0.00,0.00,388),('21','224','130','2',830.00,830.00,2286.52,0.00,0.00,0.00,0.00,389),('21','224','130','3',750.00,750.00,514.14,0.00,0.00,0.00,0.00,390),('21','224','131','2',830.00,830.00,3344.28,0.00,0.00,0.00,0.00,391),('21','224','131','3',750.00,750.00,788.81,0.00,0.00,0.00,0.00,392),('21','224','131','1',185.00,185.00,69982.27,0.00,0.00,0.00,0.00,393),('21','224','132','2',830.00,830.00,3948.79,0.00,0.00,0.00,0.00,394),('21','224','132','3',750.00,750.00,678.40,0.00,0.00,0.00,0.00,395),('21','224','132','1',185.00,185.00,65052.34,0.00,0.00,0.00,0.00,396),('21','224','133','2',830.00,830.00,3336.30,0.00,0.00,0.00,0.00,397),('21','224','133','3',750.00,750.00,1114.09,0.00,0.00,0.00,0.00,398),('21','224','133','1',175.00,175.00,49619.19,0.00,0.00,0.00,0.00,399),('21','224','134','2',830.00,830.00,1196.83,0.00,0.00,0.00,0.00,400),('21','224','134','3',750.00,750.00,839.74,0.00,0.00,0.00,0.00,401),('21','224','134','1',185.00,175.00,37906.37,0.00,0.00,0.00,0.00,402),('21','224','135','1',185.00,175.00,36102.62,0.00,0.00,0.00,0.00,403),('21','224','135','2',830.00,830.00,8025.98,0.00,0.00,0.00,0.00,404),('21','224','135','3',750.00,750.00,702.03,0.00,0.00,0.00,0.00,405),('21','224','136','1',185.00,175.00,35764.12,0.00,0.00,0.00,0.00,406),('21','224','136','2',830.00,830.00,25029.33,0.00,0.00,0.00,0.00,407),('21','224','136','3',750.00,750.00,595.51,0.00,0.00,0.00,0.00,408),('21','224','137','1',165.00,175.00,50268.95,0.00,0.00,0.00,0.00,409),('21','224','137','2',830.00,830.00,4940.11,0.00,0.00,0.00,0.00,410),('21','224','137','3',750.00,750.00,793.43,0.00,0.00,0.00,0.00,411),('21','224','138','1',185.00,175.00,30905.27,0.00,0.00,0.00,0.00,412),('21','224','138','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,413),('21','224','138','3',750.00,750.00,1251.60,0.00,0.00,0.00,0.00,414),('21','224','139','1',185.00,175.00,48495.59,0.00,0.00,0.00,0.00,415),('21','224','139','2',830.00,830.00,4538.66,0.00,0.00,0.00,0.00,416),('21','224','139','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,417),('21','224','140','1',165.00,175.00,61426.92,0.00,0.00,0.00,0.00,418),('21','224','140','2',815.00,815.00,3066.36,0.00,0.00,0.00,0.00,419),('21','224','140','3',750.00,750.00,1350.53,0.00,0.00,0.00,0.00,420),('21','224','141','2',830.00,815.00,1587.48,0.00,0.00,0.00,0.00,421),('21','224','141','3',750.00,750.00,632.16,0.00,0.00,0.00,0.00,422),('21','224','141','1',185.00,175.00,34514.73,0.00,0.00,0.00,0.00,423),('21','224','142','2',830.00,815.00,3190.70,0.00,0.00,0.00,0.00,424),('21','224','142','3',750.00,750.00,1078.44,0.00,0.00,0.00,0.00,425),('21','224','142','1',185.00,175.00,42297.09,0.00,0.00,0.00,0.00,426),('21','224','143','2',830.00,815.00,0.00,0.00,0.00,0.00,0.00,427),('21','224','143','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,428),('21','224','143','1',185.00,175.00,0.00,0.00,0.00,0.00,0.00,429),('21','224','144','2',810.00,810.00,2948.25,0.00,0.00,0.00,0.00,430),('21','224','144','3',750.00,750.00,750.63,0.00,0.00,0.00,0.00,431),('21','224','144','1',185.00,175.00,63953.63,0.00,0.00,0.00,0.00,432),('21','224','145','1',175.00,175.00,42335.12,0.00,0.00,0.00,0.00,433),('21','224','145','2',810.00,810.00,3027.16,0.00,0.00,0.00,0.00,434),('21','224','145','3',750.00,750.00,642.45,0.00,0.00,0.00,0.00,435),('21','224','146','1',175.00,175.00,52643.05,0.00,0.00,0.00,0.00,436),('21','224','146','2',815.00,810.00,1497.11,0.00,0.00,0.00,0.00,437),('21','224','146','3',750.00,750.00,470.78,0.00,0.00,0.00,0.00,438),('21','224','147','1',175.00,175.00,31940.96,0.00,0.00,0.00,0.00,439),('21','224','147','2',815.00,810.00,3026.42,0.00,0.00,0.00,0.00,440),('21','224','147','3',750.00,750.00,1210.23,0.00,0.00,0.00,0.00,441),('21','224','148','1',175.00,175.00,36325.59,0.00,0.00,0.00,0.00,442),('21','224','148','2',815.00,810.00,3889.39,0.00,0.00,0.00,0.00,443),('21','224','148','3',750.00,750.00,682.14,0.00,0.00,0.00,0.00,444),('21','224','149','2',815.00,810.00,1157.67,0.00,0.00,0.00,0.00,445),('21','224','149','3',835.00,835.00,908.49,0.00,0.00,0.00,0.00,446),('21','224','149','1',175.00,175.00,44967.65,0.00,0.00,0.00,0.00,447),('21','224','150','1',175.00,175.00,44701.63,0.00,0.00,0.00,0.00,448),('21','224','150','2',815.00,810.00,3194.74,0.00,0.00,0.00,0.00,449),('21','224','150','3',835.00,835.00,1092.95,0.00,0.00,0.00,0.00,450),('21','224','151','1',175.00,175.00,44951.71,0.00,0.00,0.00,0.00,451),('21','224','151','2',815.00,810.00,2526.25,0.00,0.00,0.00,0.00,452),('21','224','151','3',835.00,835.00,729.08,0.00,0.00,0.00,0.00,453),('21','224','152','1',175.00,175.00,45328.34,0.00,0.00,0.00,0.00,454),('21','224','152','2',815.00,810.00,1482.54,0.00,0.00,0.00,0.00,455),('21','224','152','3',835.00,835.00,1182.02,0.00,0.00,0.00,0.00,456),('21','224','153','2',815.00,810.00,1898.06,0.00,0.00,0.00,0.00,457),('21','224','153','3',835.00,835.00,571.19,0.00,0.00,0.00,0.00,458),('21','224','153','1',175.00,175.00,44804.17,0.00,0.00,0.00,0.00,459),('21','224','154','1',175.00,175.00,44998.63,0.00,0.00,0.00,0.00,460),('21','224','154','2',815.00,810.00,3903.64,0.00,0.00,0.00,0.00,461),('21','224','154','3',835.00,835.00,771.33,0.00,0.00,0.00,0.00,462),('21','224','155','1',175.00,175.00,45173.43,0.00,0.00,0.00,0.00,463),('21','224','155','2',815.00,810.00,5545.55,0.00,0.00,0.00,0.00,464),('21','224','155','3',835.00,835.00,1351.57,0.00,0.00,0.00,0.00,465),('21','224','156','1',175.00,175.00,45019.15,0.00,0.00,0.00,0.00,466),('21','224','156','2',815.00,810.00,158.43,0.00,0.00,0.00,0.00,467),('21','224','156','3',835.00,835.00,851.31,0.00,0.00,0.00,0.00,468),('21','224','157','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,469),('21','224','157','2',815.00,810.00,10.02,0.00,0.00,0.00,0.00,470),('21','224','157','3',835.00,835.00,233.84,0.00,0.00,0.00,0.00,471),('21','224','158','1',175.00,175.00,49763.08,0.00,0.00,0.00,0.00,472),('21','224','158','2',815.00,810.00,0.00,0.00,0.00,0.00,0.00,473),('21','224','158','3',835.00,835.00,627.95,0.00,0.00,0.00,0.00,474),('21','224','159','1',175.00,175.00,44907.09,0.00,0.00,0.00,0.00,475),('21','224','159','2',815.00,810.00,0.00,0.00,0.00,0.00,0.00,476),('21','224','159','3',835.00,835.00,677.62,0.00,0.00,0.00,0.00,477),('21','224','160','1',175.00,175.00,44886.01,0.00,0.00,0.00,0.00,478),('21','224','160','2',815.00,810.00,4563.99,0.00,0.00,0.00,0.00,479),('21','224','160','3',835.00,835.00,836.65,0.00,0.00,0.00,0.00,480),('21','224','161','1',175.00,175.00,45181.84,0.00,0.00,0.00,0.00,481),('21','224','161','2',815.00,810.00,2054.65,0.00,0.00,0.00,0.00,482),('21','224','161','3',835.00,835.00,744.02,0.00,0.00,0.00,0.00,483),('21','224','162','1',175.00,175.00,40139.07,0.00,0.00,0.00,0.00,484),('21','224','162','2',815.00,810.00,3657.30,0.00,0.00,0.00,0.00,485),('21','224','162','3',835.00,835.00,374.96,0.00,0.00,0.00,0.00,486),('21','224','163','1',175.00,175.00,56324.55,0.00,0.00,0.00,0.00,487),('21','224','163','2',815.00,810.00,1103.43,0.00,0.00,0.00,0.00,488),('21','224','163','3',835.00,835.00,442.88,0.00,0.00,0.00,0.00,489),('21','224','164','1',175.00,175.00,39835.55,0.00,0.00,0.00,0.00,490),('21','224','164','2',815.00,810.00,1385.68,0.00,0.00,0.00,0.00,491),('21','224','164','3',835.00,835.00,816.49,0.00,0.00,0.00,0.00,492),('21','224','165','1',175.00,175.00,44830.44,0.00,0.00,0.00,0.00,493),('21','224','165','2',815.00,810.00,2778.17,0.00,0.00,0.00,0.00,494),('21','224','165','3',835.00,835.00,772.30,0.00,0.00,0.00,0.00,495),('21','224','166','1',175.00,175.00,45088.05,0.00,0.00,0.00,0.00,496),('21','224','166','2',815.00,810.00,7995.87,0.00,0.00,0.00,0.00,497),('21','224','166','3',835.00,835.00,566.10,0.00,0.00,0.00,0.00,498),('21','224','167','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,499),('21','224','167','2',815.00,810.00,0.00,0.00,0.00,0.00,0.00,500),('21','224','167','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,501),('21','224','168','1',175.00,175.00,40007.89,0.00,0.00,0.00,0.00,502),('21','224','168','2',800.00,800.00,14518.23,0.00,0.00,0.00,0.00,503),('21','224','168','3',860.00,860.00,696.30,0.00,0.00,0.00,0.00,504),('21','224','169','1',175.00,175.00,45026.46,0.00,0.00,0.00,0.00,505),('21','224','169','2',800.00,800.00,18998.86,0.00,0.00,0.00,0.00,506),('21','224','169','3',860.00,860.00,612.56,0.00,0.00,0.00,0.00,507),('21','224','170','1',175.00,175.00,44956.09,0.00,0.00,0.00,0.00,508),('21','224','170','2',800.00,800.00,10340.57,0.00,0.00,0.00,0.00,509),('21','224','170','3',860.00,860.00,528.49,0.00,0.00,0.00,0.00,510),('21','224','171','1',175.00,175.00,44975.82,0.00,0.00,0.00,0.00,511),('21','224','171','2',800.00,800.00,2610.35,0.00,0.00,0.00,0.00,512),('21','224','171','3',860.00,860.00,461.57,0.00,0.00,0.00,0.00,513),('21','224','172','1',175.00,175.00,34082.39,0.00,0.00,0.00,0.00,514),('21','224','172','2',800.00,800.00,5696.64,0.00,0.00,0.00,0.00,515),('21','224','172','3',860.00,860.00,747.14,0.00,0.00,0.00,0.00,516),('21','224','173','1',175.00,175.00,50404.37,0.00,0.00,0.00,0.00,517),('21','224','173','2',800.00,800.00,2276.22,0.00,0.00,0.00,0.00,518),('21','224','173','3',860.00,860.00,356.31,0.00,0.00,0.00,0.00,519),('21','224','174','1',175.00,175.00,45362.24,0.00,0.00,0.00,0.00,520),('21','224','174','2',800.00,800.00,3380.85,0.00,0.00,0.00,0.00,521),('21','224','174','3',860.00,860.00,749.51,0.00,0.00,0.00,0.00,522),('21','224','175','1',175.00,175.00,45044.71,0.00,0.00,0.00,0.00,523),('21','224','175','2',800.00,800.00,2619.15,0.00,0.00,0.00,0.00,524),('21','224','175','3',860.00,860.00,589.89,0.00,0.00,0.00,0.00,525),('21','224','176','1',175.00,175.00,45118.01,0.00,0.00,0.00,0.00,526),('21','224','176','2',800.00,800.00,11846.03,0.00,0.00,0.00,0.00,527),('21','224','176','3',860.00,860.00,431.78,0.00,0.00,0.00,0.00,528),('21','224','177','1',175.00,175.00,44919.26,0.00,0.00,0.00,0.00,529),('21','224','177','2',800.00,800.00,2814.25,0.00,0.00,0.00,0.00,530),('21','224','177','3',860.00,860.00,812.51,0.00,0.00,0.00,0.00,531),('21','224','178','1',175.00,175.00,44490.46,0.00,0.00,0.00,0.00,532),('21','224','178','2',800.00,800.00,1779.40,0.00,0.00,0.00,0.00,533),('21','224','178','3',860.00,860.00,616.14,0.00,0.00,0.00,0.00,534),('21','224','179','1',175.00,175.00,47932.21,0.00,0.00,0.00,0.00,535),('21','224','179','2',800.00,800.00,2966.14,0.00,0.00,0.00,0.00,536),('21','224','179','3',860.00,860.00,667.58,0.00,0.00,0.00,0.00,537),('21','224','180','1',175.00,175.00,44930.03,0.00,0.00,0.00,0.00,538),('21','224','180','2',800.00,800.00,1464.60,0.00,0.00,0.00,0.00,539),('21','224','180','3',860.00,860.00,598.01,0.00,0.00,0.00,0.00,540),('21','224','181','2',800.00,800.00,2816.47,0.00,0.00,0.00,0.00,541),('21','224','181','3',860.00,860.00,566.22,0.00,0.00,0.00,0.00,542),('21','224','181','1',175.00,175.00,44896.18,0.00,0.00,0.00,0.00,543),('21','224','182','1',175.00,175.00,49706.76,0.00,0.00,0.00,0.00,544),('21','224','182','2',800.00,800.00,954.59,0.00,0.00,0.00,0.00,545),('21','224','182','3',860.00,860.00,538.56,0.00,0.00,0.00,0.00,546),('21','224','183','1',175.00,175.00,49647.53,0.00,0.00,0.00,0.00,547),('21','224','183','2',800.00,800.00,2674.33,0.00,0.00,0.00,0.00,548),('21','224','183','3',860.00,860.00,570.66,0.00,0.00,0.00,0.00,549),('21','224','184','1',175.00,175.00,49863.49,0.00,0.00,0.00,0.00,550),('21','224','184','2',800.00,800.00,2329.65,0.00,0.00,0.00,0.00,551),('21','224','184','3',860.00,860.00,895.02,0.00,0.00,0.00,0.00,552),('21','224','185','1',175.00,175.00,44757.40,0.00,0.00,0.00,0.00,553),('21','224','185','2',800.00,800.00,1456.54,0.00,0.00,0.00,0.00,554),('21','224','185','3',860.00,860.00,402.98,0.00,0.00,0.00,0.00,555),('21','224','186','1',175.00,175.00,44914.38,0.00,0.00,0.00,0.00,556),('21','224','186','2',800.00,800.00,2589.65,0.00,0.00,0.00,0.00,557),('21','224','186','3',860.00,860.00,447.05,0.00,0.00,0.00,0.00,558),('21','224','187','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,559),('21','224','187','2',800.00,800.00,2605.55,0.00,0.00,0.00,0.00,560),('21','224','187','3',860.00,860.00,551.65,0.00,0.00,0.00,0.00,561),('21','224','188','1',175.00,175.00,49486.77,0.00,0.00,0.00,0.00,562),('21','224','188','2',800.00,800.00,2409.78,0.00,0.00,0.00,0.00,563),('21','224','188','3',860.00,860.00,571.05,0.00,0.00,0.00,0.00,564),('21','224','189','1',175.00,175.00,58717.00,0.00,0.00,0.00,0.00,565),('21','224','189','2',800.00,800.00,2772.27,0.00,0.00,0.00,0.00,566),('21','224','189','3',860.00,860.00,741.42,0.00,0.00,0.00,0.00,567),('21','224','190','1',175.00,175.00,68374.60,0.00,0.00,0.00,0.00,568),('21','224','190','2',800.00,800.00,2849.75,0.00,0.00,0.00,0.00,569),('21','224','190','3',860.00,860.00,533.42,0.00,0.00,0.00,0.00,570),('21','224','191','1',175.00,175.00,55850.81,0.00,0.00,0.00,0.00,571),('21','224','191','2',800.00,800.00,4057.99,0.00,0.00,0.00,0.00,572),('21','224','191','3',860.00,860.00,374.51,0.00,0.00,0.00,0.00,573),('21','224','192','1',175.00,175.00,46461.63,0.00,0.00,0.00,0.00,574),('21','224','192','2',800.00,800.00,1536.70,0.00,0.00,0.00,0.00,575),('21','224','192','3',860.00,860.00,473.60,0.00,0.00,0.00,0.00,576),('21','224','193','1',175.00,175.00,11050.32,0.00,0.00,0.00,0.00,577),('21','224','193','2',800.00,800.00,882.12,0.00,0.00,0.00,0.00,578),('21','224','193','3',860.00,860.00,707.23,0.00,0.00,0.00,0.00,579),('21','224','194','1',175.00,175.00,42316.04,0.00,0.00,0.00,0.00,580),('21','224','194','2',800.00,800.00,5061.32,0.00,0.00,0.00,0.00,581),('21','224','194','3',860.00,860.00,537.19,0.00,0.00,0.00,0.00,582),('21','224','195','1',175.00,175.00,62135.24,0.00,0.00,0.00,0.00,583),('21','224','195','2',800.00,800.00,2789.95,0.00,0.00,0.00,0.00,584),('21','224','195','3',860.00,860.00,637.75,0.00,0.00,0.00,0.00,585),('21','224','196','1',175.00,175.00,60588.38,0.00,0.00,0.00,0.00,586),('21','224','196','2',800.00,800.00,2684.14,0.00,0.00,0.00,0.00,587),('21','224','196','3',860.00,860.00,612.91,0.00,0.00,0.00,0.00,588),('21','224','197','1',175.00,175.00,58378.47,0.00,0.00,0.00,0.00,589),('21','224','197','2',800.00,800.00,2523.01,0.00,0.00,0.00,0.00,590),('21','224','197','3',860.00,860.00,413.62,0.00,0.00,0.00,0.00,591),('21','224','198','1',175.00,175.00,40089.40,0.00,0.00,0.00,0.00,592),('21','224','198','2',800.00,800.00,2524.57,0.00,0.00,0.00,0.00,593),('21','224','198','3',860.00,860.00,809.73,0.00,0.00,0.00,0.00,594),('21','224','199','1',175.00,175.00,45256.09,0.00,0.00,0.00,0.00,595),('21','224','199','2',800.00,800.00,1997.23,0.00,0.00,0.00,0.00,596),('21','224','199','3',860.00,860.00,420.03,0.00,0.00,0.00,0.00,597),('21','224','200','1',175.00,175.00,18355.91,0.00,0.00,0.00,0.00,598),('21','224','200','2',800.00,800.00,3563.38,0.00,0.00,0.00,0.00,599),('21','224','200','3',860.00,860.00,468.54,0.00,0.00,0.00,0.00,600),('21','224','201','1',175.00,175.00,62448.89,0.00,0.00,0.00,0.00,601),('21','224','201','2',800.00,800.00,1643.52,0.00,0.00,0.00,0.00,602),('21','224','201','3',860.00,860.00,507.10,0.00,0.00,0.00,0.00,603),('21','224','202','1',175.00,175.00,52237.76,0.00,0.00,0.00,0.00,604),('21','224','202','2',800.00,800.00,2899.40,0.00,0.00,0.00,0.00,605),('21','224','202','3',860.00,860.00,630.86,0.00,0.00,0.00,0.00,606),('21','224','203','1',175.00,175.00,66620.69,0.00,0.00,0.00,0.00,607),('21','224','203','2',800.00,800.00,2295.96,0.00,0.00,0.00,0.00,608),('21','224','203','3',860.00,860.00,624.43,0.00,0.00,0.00,0.00,609),('21','224','204','1',175.00,175.00,51628.83,0.00,0.00,0.00,0.00,610),('21','224','204','2',800.00,800.00,2961.47,0.00,0.00,0.00,0.00,611),('21','224','204','3',860.00,860.00,531.26,0.00,0.00,0.00,0.00,612),('21','224','205','1',175.00,175.00,31958.57,0.00,0.00,0.00,0.00,613),('21','224','205','2',800.00,800.00,2888.61,0.00,0.00,0.00,0.00,614),('21','224','205','3',860.00,860.00,591.89,0.00,0.00,0.00,0.00,615),('21','224','206','1',175.00,175.00,45163.02,0.00,0.00,0.00,0.00,616),('21','224','206','2',800.00,800.00,1620.50,0.00,0.00,0.00,0.00,617),('21','224','206','3',860.00,860.00,473.01,0.00,0.00,0.00,0.00,618),('21','224','207','1',175.00,175.00,39711.19,0.00,0.00,0.00,0.00,619),('21','224','207','2',800.00,800.00,2468.91,0.00,0.00,0.00,0.00,620),('21','224','207','3',860.00,860.00,344.57,0.00,0.00,0.00,0.00,621),('21','224','208','1',175.00,175.00,54424.34,0.00,0.00,0.00,0.00,622),('21','224','208','2',800.00,800.00,8681.83,0.00,0.00,0.00,0.00,623),('21','224','208','3',860.00,860.00,110.11,0.00,0.00,0.00,0.00,624),('21','224','209','1',175.00,175.00,51721.24,0.00,0.00,0.00,0.00,625),('21','224','209','2',800.00,800.00,17299.51,0.00,0.00,0.00,0.00,626),('21','224','209','3',860.00,860.00,528.25,0.00,0.00,0.00,0.00,627),('21','224','210','1',175.00,175.00,51348.75,0.00,0.00,0.00,0.00,628),('21','224','210','2',800.00,800.00,14222.64,0.00,0.00,0.00,0.00,629),('21','224','210','3',860.00,860.00,496.93,0.00,0.00,0.00,0.00,630),('21','224','211','2',800.00,800.00,3356.16,0.00,0.00,0.00,0.00,631),('21','224','211','3',860.00,860.00,256.17,0.00,0.00,0.00,0.00,632),('21','224','211','1',175.00,175.00,27514.01,0.00,0.00,0.00,0.00,633),('21','224','212','1',175.00,175.00,18307.18,0.00,0.00,0.00,0.00,634),('21','224','212','2',800.00,800.00,3354.14,0.00,0.00,0.00,0.00,635),('21','224','212','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,636),('21','224','213','1',175.00,175.00,65324.57,0.00,0.00,0.00,0.00,637),('21','224','213','2',800.00,800.00,3840.76,0.00,0.00,0.00,0.00,638),('21','224','213','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,639),('21','224','214','1',175.00,175.00,72380.25,0.00,0.00,0.00,0.00,640),('21','224','214','2',800.00,800.00,2770.84,0.00,0.00,0.00,0.00,641),('21','224','214','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,642),('21','224','215','1',175.00,175.00,33573.25,0.00,0.00,0.00,0.00,643),('21','224','215','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,644),('21','224','215','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,645),('21','224','216','1',175.00,175.00,42476.89,0.00,0.00,0.00,0.00,646),('21','224','216','2',800.00,800.00,2004.57,0.00,0.00,0.00,0.00,647),('21','224','216','3',860.00,860.00,234.88,0.00,0.00,0.00,0.00,648),('21','224','217','1',175.00,175.00,44938.97,0.00,0.00,0.00,0.00,649),('21','224','217','2',815.00,815.00,2746.41,0.00,0.00,0.00,0.00,650),('21','224','217','3',860.00,860.00,567.34,0.00,0.00,0.00,0.00,651),('21','224','218','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,652),('21','224','218','2',815.00,815.00,5240.08,0.00,0.00,0.00,0.00,653),('21','224','218','3',860.00,860.00,625.03,0.00,0.00,0.00,0.00,654),('21','224','219','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,655),('21','224','219','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,656),('21','224','219','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,657),('21','224','220','1',175.00,175.00,40906.32,0.00,0.00,0.00,0.00,658),('21','224','220','2',815.00,815.00,5440.60,0.00,0.00,0.00,0.00,659),('21','224','220','3',860.00,860.00,558.98,0.00,0.00,0.00,0.00,660),('21','224','221','1',175.00,175.00,41708.19,0.00,0.00,0.00,0.00,661),('21','224','221','2',815.00,815.00,2709.63,0.00,0.00,0.00,0.00,662),('21','224','221','3',860.00,860.00,466.46,0.00,0.00,0.00,0.00,663),('21','224','222','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,664),('21','224','222','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,665),('21','224','222','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,666),('21','224','223','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,667),('21','224','223','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,668),('21','224','223','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,669),('21','224','224','1',175.00,175.00,17677.06,0.00,0.00,0.00,0.00,670),('21','224','224','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,671),('21','224','224','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,672),('21','224','225','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,673),('21','224','225','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,674),('21','224','225','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,675),('21','224','226','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,676),('21','224','226','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,677),('21','224','226','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,678),('21','224','227','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,679),('21','224','227','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,680),('21','224','227','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,681),('21','224','228','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,682),('21','224','228','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,683),('21','224','228','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,684),('21','224','229','2',815.00,815.00,2753.34,0.00,0.00,0.00,0.00,685),('21','224','229','3',860.00,860.00,582.31,0.00,0.00,0.00,0.00,686),('21','224','229','1',175.00,175.00,20792.60,0.00,0.00,0.00,0.00,687),('21','224','230','1',175.00,175.00,37180.21,0.00,0.00,0.00,0.00,688),('21','224','230','2',815.00,815.00,3130.41,0.00,0.00,0.00,0.00,689),('21','224','230','3',860.00,860.00,416.85,0.00,0.00,0.00,0.00,690),('21','224','231','1',175.00,175.00,61334.00,0.00,0.00,0.00,0.00,691),('21','224','231','2',815.00,815.00,3068.38,0.00,0.00,0.00,0.00,692),('21','224','231','3',860.00,860.00,472.34,0.00,0.00,0.00,0.00,693),('21','224','232','1',175.00,175.00,44838.06,0.00,0.00,0.00,0.00,694),('21','224','232','2',815.00,815.00,6534.08,0.00,0.00,0.00,0.00,695),('21','224','232','3',860.00,860.00,618.98,0.00,0.00,0.00,0.00,696),('21','224','233','1',175.00,175.00,50285.91,0.00,0.00,0.00,0.00,697),('21','224','233','2',830.00,830.00,2727.27,0.00,0.00,0.00,0.00,698),('21','224','233','3',860.00,860.00,371.74,0.00,0.00,0.00,0.00,699),('21','224','234','1',175.00,175.00,50579.73,0.00,0.00,0.00,0.00,700),('21','224','234','2',830.00,830.00,3445.64,0.00,0.00,0.00,0.00,701),('21','224','234','3',860.00,860.00,997.00,0.00,0.00,0.00,0.00,702),('21','224','235','2',830.00,830.00,3393.07,0.00,0.00,0.00,0.00,703),('21','224','235','3',860.00,860.00,643.44,0.00,0.00,0.00,0.00,704),('21','224','235','1',175.00,175.00,47595.46,0.00,0.00,0.00,0.00,705),('21','224','236','1',175.00,175.00,45030.15,0.00,0.00,0.00,0.00,706),('21','224','236','2',830.00,830.00,3464.87,0.00,0.00,0.00,0.00,707),('21','224','236','3',860.00,860.00,480.96,0.00,0.00,0.00,0.00,708),('21','224','237','1',175.00,175.00,45174.71,0.00,0.00,0.00,0.00,709),('21','224','237','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,710),('21','224','237','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,711),('21','224','238','1',175.00,175.00,44857.42,0.00,0.00,0.00,0.00,712),('21','224','238','2',830.00,830.00,4063.32,0.00,0.00,0.00,0.00,713),('21','224','238','3',860.00,860.00,520.39,0.00,0.00,0.00,0.00,714),('21','224','239','1',175.00,175.00,45445.22,0.00,0.00,0.00,0.00,715),('21','224','239','2',830.00,830.00,6028.87,0.00,0.00,0.00,0.00,716),('21','224','239','3',860.00,860.00,461.83,0.00,0.00,0.00,0.00,717),('21','224','240','1',175.00,175.00,44966.76,0.00,0.00,0.00,0.00,718),('21','224','240','2',830.00,830.00,2491.37,0.00,0.00,0.00,0.00,719),('21','224','240','3',860.00,860.00,330.19,0.00,0.00,0.00,0.00,720),('21','224','241','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,721),('21','224','241','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,722),('21','224','241','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,723),('21','224','242','2',830.00,830.00,6119.47,0.00,0.00,0.00,0.00,724),('21','224','242','3',860.00,860.00,274.70,0.00,0.00,0.00,0.00,725),('21','224','242','1',175.00,175.00,44784.58,0.00,0.00,0.00,0.00,726),('21','224','243','1',175.00,175.00,44909.20,0.00,0.00,0.00,0.00,727),('21','224','243','2',830.00,830.00,1277.80,0.00,0.00,0.00,0.00,728),('21','224','243','3',860.00,860.00,373.87,0.00,0.00,0.00,0.00,729),('21','224','244','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,730),('21','224','244','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,731),('21','224','244','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,732),('21','224','245','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,733),('21','224','245','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,734),('21','224','245','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,735),('21','224','246','1',175.00,175.00,30346.62,0.00,0.00,0.00,0.00,736),('21','224','246','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,737),('21','224','246','3',860.00,860.00,608.31,0.00,0.00,0.00,0.00,738),('21','224','247','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,739),('21','224','247','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,740),('21','224','247','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,741),('21','224','248','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,742),('21','224','248','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,743),('21','224','248','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,744);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'224','PRODUCT TANK','TANKS CONTAINING PETROLEUM PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','224','1',1,0,'1','PMS TANK 1 & 2',90000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','766','2022-03-03 08:05:23','2022-03-03 08:05:23','766',5,0),('21','224','1',2,0,'1','PMS TANK 3 & 4',90000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','766','2022-03-03 08:09:55','2022-03-03 08:09:55','766',5,0),('21','224','1',3,0,'1','PMS TANK 5',45000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','766','2022-03-03 08:13:57','2022-03-03 08:13:57','766',5,0),('21','224','1',4,0,'2','AGO TANK 1',45000.00,0.00,NULL,'TANK CONTAINING DIESEL.','766','2022-03-03 08:15:39','2022-03-03 08:15:39','766',5,0),('21','224','1',5,0,'2','AGO TANK 2',45000.00,0.00,NULL,'TANK CONTAINING DIESEL.','766','2022-03-03 08:16:32','2022-03-03 08:16:32','766',5,0),('21','224','1',6,0,'3','DPK TANK 1 & 2',90000.00,0.00,NULL,'TANK CONTAINING KEROSINE.','766','2022-03-03 08:17:27','2022-03-03 12:07:24','764',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=5490 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (26,'21','224','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 12:42:56','',''),(27,'21','224','4',0,'Inventory adjustment from tank dipping to 500',0.00,0.00,500.00,0.00,0.00,'2022-03-23 12:42:56','',''),(28,'21','224','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 12:43:25','',''),(29,'21','224','5',0,'Inventory adjustment from tank dipping to 1900',0.00,0.00,1900.00,0.00,0.00,'2022-03-23 12:43:25','',''),(30,'21','224','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 12:43:52','',''),(31,'21','224','6',0,'Inventory adjustment from tank dipping to 1300',0.00,0.00,1300.00,0.00,0.00,'2022-03-23 12:43:52','',''),(32,'21','224','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-24 09:14:12','',''),(33,'21','224','1',0,'Inventory adjustment from tank dipping to 2300',0.00,0.00,2300.00,0.00,0.00,'2022-03-24 09:14:12','',''),(34,'21','224','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-24 09:17:48','',''),(35,'21','224','2',0,'Inventory adjustment from tank dipping to 2500',0.00,0.00,2500.00,0.00,0.00,'2022-03-24 09:17:48','',''),(36,'21','224','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,500.00,0.00,'2022-03-24 09:19:53','',''),(37,'21','224','4',0,'Inventory adjustment from tank dipping to 15300',0.00,0.00,15300.00,0.00,0.00,'2022-03-24 09:19:53','',''),(38,'21','224','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,1900.00,0.00,'2022-03-24 09:20:33','',''),(39,'21','224','5',0,'Inventory adjustment from tank dipping to 27350',0.00,0.00,27350.00,0.00,0.00,'2022-03-24 09:20:33','',''),(40,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-24 10:04:36','',''),(41,'21','224',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,30000.00,0.00,'2022-03-24 10:10:49','',''),(42,'21','224','2',1,'Received from bridging 11',0.00,0.00,30000.00,0.00,0.00,'2022-03-24 10:10:49','',''),(43,'21','224',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,15000.00,0.00,'2022-03-24 10:10:49','',''),(44,'21','224','1',1,'Received from bridging 10',0.00,0.00,15000.00,0.00,0.00,'2022-03-24 10:10:49','',''),(45,'21','224','1',1,'Sale Id shift 4',0.00,0.00,0.00,2306.60,0.00,'2022-03-24 10:36:52','',''),(46,'21','224','1',1,'Sale Id shift 4',0.00,0.00,0.00,2178.98,0.00,'2022-03-24 10:36:52','',''),(47,'21','224','1',1,'Sale Id shift 4',0.00,0.00,0.00,3364.41,0.00,'2022-03-24 10:36:52','',''),(48,'21','224','1',1,'Sale Id shift 4',0.00,0.00,0.00,2586.00,0.00,'2022-03-24 10:36:52','',''),(49,'21','224','1',1,'Sale Id shift 4',0.00,0.00,0.00,2250.17,0.00,'2022-03-24 10:36:52','',''),(50,'21','224','1',1,'Sale Id shift 4',0.00,0.00,0.00,2208.44,0.00,'2022-03-24 10:36:52','',''),(51,'21','224','1',1,'Sale Id shift 4',0.00,0.00,0.00,1637.84,0.00,'2022-03-24 10:36:52','',''),(52,'21','224','2',1,'Sale Id shift 4',0.00,0.00,0.00,4069.30,0.00,'2022-03-24 10:36:52','',''),(53,'21','224','2',1,'Sale Id shift 4',0.00,0.00,0.00,3865.32,0.00,'2022-03-24 10:36:52','',''),(54,'21','224','2',1,'Sale Id shift 4',0.00,0.00,0.00,3641.09,0.00,'2022-03-24 10:36:52','',''),(55,'21','224','2',1,'Sale Id shift 4',0.00,0.00,0.00,4120.88,0.00,'2022-03-24 10:36:52','',''),(56,'21','224','2',1,'Sale Id shift 4',0.00,0.00,0.00,3480.54,0.00,'2022-03-24 10:36:52','',''),(57,'21','224','2',1,'Sale Id shift 4',0.00,0.00,0.00,3845.45,0.00,'2022-03-24 10:36:52','',''),(58,'21','224','5',2,'Sale Id shift 4',0.00,0.00,0.00,6391.89,0.00,'2022-03-24 10:36:52','',''),(59,'21','224','2',1,'Sale Id shift 4',0.00,0.00,0.00,5435.85,0.00,'2022-03-24 10:36:52','',''),(60,'21','224',NULL,1,'Sale Id shift 4',7423493.55,0.00,0.00,0.00,0.00,'2022-03-24 10:36:52','',''),(61,'21','224',NULL,2,'Sale Id shift 4',4474323.00,0.00,0.00,0.00,0.00,'2022-03-24 10:36:52','',''),(62,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-03-24 10:45:28','',''),(63,'21','224',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,33500.00,0.00,'2022-03-24 10:48:55','',''),(64,'21','224','2',1,'Received from bridging 13',0.00,0.00,33500.00,0.00,0.00,'2022-03-24 10:48:55','',''),(65,'21','224',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,16500.00,0.00,'2022-03-24 10:48:55','',''),(66,'21','224','1',1,'Received from bridging 12',0.00,0.00,16500.00,0.00,0.00,'2022-03-24 10:48:55','',''),(67,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,11550000.00,16500.00,0.00,0.00,'2022-03-24 10:49:19','',''),(68,'21','224',NULL,2,'Reception corrector for bridging 14',0.00,0.00,0.00,16500.00,0.00,'2022-03-24 10:50:47','',''),(69,'21','224','4',2,'Received from bridging 14',0.00,0.00,16500.00,0.00,0.00,'2022-03-24 10:50:47','',''),(70,'21','224','1',1,'Sale Id shift 5',0.00,0.00,0.00,2918.38,0.00,'2022-03-24 11:26:11','',''),(71,'21','224','2',1,'Sale Id shift 5',0.00,0.00,0.00,2976.38,0.00,'2022-03-24 11:26:11','',''),(72,'21','224','2',1,'Sale Id shift 5',0.00,0.00,0.00,3661.26,0.00,'2022-03-24 11:26:11','',''),(73,'21','224','2',1,'Sale Id shift 5',0.00,0.00,0.00,3449.05,0.00,'2022-03-24 11:26:11','',''),(74,'21','224','2',1,'Sale Id shift 5',0.00,0.00,0.00,3116.27,0.00,'2022-03-24 11:26:11','',''),(75,'21','224','2',1,'Sale Id shift 5',0.00,0.00,0.00,2158.47,0.00,'2022-03-24 11:26:11','',''),(76,'21','224','1',1,'Sale Id shift 5',0.00,0.00,0.00,2036.54,0.00,'2022-03-24 11:26:11','',''),(77,'21','224','1',1,'Sale Id shift 5',0.00,0.00,0.00,3212.20,0.00,'2022-03-24 11:26:11','',''),(78,'21','224','5',2,'Sale Id shift 5',0.00,0.00,0.00,6564.95,0.00,'2022-03-24 11:26:11','',''),(79,'21','224','2',1,'Sale Id shift 5',0.00,0.00,0.00,4370.21,0.00,'2022-03-24 11:26:11','',''),(80,'21','224','1',1,'Sale Id shift 5',0.00,0.00,0.00,0.26,0.00,'2022-03-24 11:26:11','',''),(81,'21','224','1',1,'Sale Id shift 5',0.00,0.00,0.00,1882.00,0.00,'2022-03-24 11:26:11','',''),(82,'21','224','1',1,'Sale Id shift 5',0.00,0.00,0.00,2553.67,0.00,'2022-03-24 11:26:11','',''),(83,'21','224','1',1,'Sale Id shift 5',0.00,0.00,0.00,1884.79,0.00,'2022-03-24 11:26:11','',''),(84,'21','224','1',1,'Sale Id shift 5',0.00,0.00,0.00,1882.55,0.00,'2022-03-24 11:26:11','',''),(85,'21','224','2',1,'Sale Id shift 5',0.00,0.00,0.00,4058.88,0.00,'2022-03-24 11:26:11','',''),(86,'21','224',NULL,1,'Sale Id shift 5',6626550.15,0.00,0.00,0.00,0.00,'2022-03-24 11:26:11','',''),(87,'21','224',NULL,2,'Sale Id shift 5',4595465.00,0.00,0.00,0.00,0.00,'2022-03-24 11:26:11','',''),(88,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-03-25 15:59:13','',''),(89,'21','224',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,33500.00,0.00,'2022-03-25 16:01:43','',''),(90,'21','224','2',1,'Received from bridging 16',0.00,0.00,33500.00,0.00,0.00,'2022-03-25 16:01:43','',''),(91,'21','224',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,16500.00,0.00,'2022-03-25 16:01:43','',''),(92,'21','224','1',1,'Received from bridging 15',0.00,0.00,16500.00,0.00,0.00,'2022-03-25 16:01:43','',''),(93,'21','224','1',1,'Sale Id shift 6',0.00,0.00,0.00,1633.34,0.00,'2022-03-25 16:52:31','',''),(94,'21','224','2',1,'Sale Id shift 6',0.00,0.00,0.00,6231.41,0.00,'2022-03-25 16:52:31','',''),(95,'21','224','2',1,'Sale Id shift 6',0.00,0.00,0.00,4537.52,0.00,'2022-03-25 16:52:31','',''),(96,'21','224','2',1,'Sale Id shift 6',0.00,0.00,0.00,3739.93,0.00,'2022-03-25 16:52:31','',''),(97,'21','224','2',1,'Sale Id shift 6',0.00,0.00,0.00,3645.26,0.00,'2022-03-25 16:52:31','',''),(98,'21','224','2',1,'Sale Id shift 6',0.00,0.00,0.00,3776.21,0.00,'2022-03-25 16:52:31','',''),(99,'21','224','1',1,'Sale Id shift 6',0.00,0.00,0.00,2964.42,0.00,'2022-03-25 16:52:31','',''),(100,'21','224','1',1,'Sale Id shift 6',0.00,0.00,0.00,3292.59,0.00,'2022-03-25 16:52:31','',''),(101,'21','224','5',2,'Sale Id shift 6',0.00,0.00,0.00,5540.24,0.00,'2022-03-25 16:52:31','',''),(102,'21','224','2',1,'Sale Id shift 6',0.00,0.00,0.00,6350.82,0.00,'2022-03-25 16:52:31','',''),(103,'21','224','1',1,'Sale Id shift 6',0.00,0.00,0.00,1882.00,0.00,'2022-03-25 16:52:31','',''),(104,'21','224','1',1,'Sale Id shift 6',0.00,0.00,0.00,1898.46,0.00,'2022-03-25 16:52:31','',''),(105,'21','224','1',1,'Sale Id shift 6',0.00,0.00,0.00,2143.68,0.00,'2022-03-25 16:52:31','',''),(106,'21','224','1',1,'Sale Id shift 6',0.00,0.00,0.00,2321.20,0.00,'2022-03-25 16:52:31','',''),(107,'21','224','2',1,'Sale Id shift 6',0.00,0.00,0.00,4149.81,0.00,'2022-03-25 16:52:31','',''),(108,'21','224',NULL,2,'Sale Id shift 6',3878168.00,0.00,0.00,0.00,0.00,'2022-03-25 16:52:31','',''),(109,'21','224',NULL,1,'Sale Id shift 6',8013497.25,0.00,0.00,0.00,0.00,'2022-03-25 16:52:31','',''),(110,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-03-25 17:06:10','',''),(111,'21','224',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,40000.00,0.00,'2022-03-25 17:08:46','',''),(112,'21','224','2',1,'Received from bridging 18',0.00,0.00,40000.00,0.00,0.00,'2022-03-25 17:08:46','',''),(113,'21','224',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,20000.00,0.00,'2022-03-25 17:08:46','',''),(114,'21','224','1',1,'Received from bridging 17',0.00,0.00,20000.00,0.00,0.00,'2022-03-25 17:08:46','',''),(115,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-03-26 13:24:18','',''),(116,'21','224',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,20000.00,0.00,'2022-03-29 15:26:08','',''),(117,'21','224','1',1,'Received from bridging 19',0.00,0.00,20000.00,0.00,0.00,'2022-03-29 15:26:08','',''),(118,'21','224','1',1,'Returned bridging 19',0.00,0.00,0.00,20000.00,0.00,'2022-03-30 23:27:49','',''),(119,'21','224',NULL,1,'Reception Return corrector for bridging 19',0.00,0.00,20000.00,0.00,0.00,'2022-03-30 23:27:49','',''),(120,'21','224',NULL,1,'Returned purchase #14 to AYM SHAFA NIGERIA LIMITED',9900000.00,0.00,0.00,60000.00,0.00,'2022-03-30 23:28:30','',''),(121,'21','224','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,8852.92,0.00,'2022-04-05 17:06:04','',''),(122,'21','224','5',0,'Inventory adjustment from tank dipping to 11000',0.00,0.00,11000.00,0.00,0.00,'2022-04-05 17:06:04','',''),(123,'21','224','1',1,'Sale Id shift 12',0.00,0.00,0.00,3758.00,0.00,'2022-04-06 18:14:16','',''),(124,'21','224','2',1,'Sale Id shift 12',0.00,0.00,0.00,5939.00,0.00,'2022-04-06 18:14:16','',''),(125,'21','224','2',1,'Sale Id shift 12',0.00,0.00,0.00,5732.00,0.00,'2022-04-06 18:14:16','',''),(126,'21','224','2',1,'Sale Id shift 12',0.00,0.00,0.00,4259.00,0.00,'2022-04-06 18:14:16','',''),(127,'21','224','2',1,'Sale Id shift 12',0.00,0.00,0.00,4993.00,0.00,'2022-04-06 18:14:16','',''),(128,'21','224','2',1,'Sale Id shift 12',0.00,0.00,0.00,5202.00,0.00,'2022-04-06 18:14:16','',''),(129,'21','224','1',1,'Sale Id shift 12',0.00,0.00,0.00,2189.00,0.00,'2022-04-06 18:14:16','',''),(130,'21','224','4',2,'Sale Id shift 12',0.00,0.00,0.00,15235.86,0.00,'2022-04-06 18:14:16','',''),(131,'21','224','1',1,'Sale Id shift 12',0.00,0.00,0.00,3590.00,0.00,'2022-04-06 18:14:16','',''),(132,'21','224','5',2,'Sale Id shift 12',0.00,0.00,0.00,9013.88,0.00,'2022-04-06 18:14:16','',''),(133,'21','224','2',1,'Sale Id shift 12',0.00,0.00,0.00,5874.00,0.00,'2022-04-06 18:14:16','',''),(134,'21','224','1',1,'Sale Id shift 12',0.00,0.00,0.00,2478.00,0.00,'2022-04-06 18:14:16','',''),(135,'21','224','1',1,'Sale Id shift 12',0.00,0.00,0.00,2454.00,0.00,'2022-04-06 18:14:16','',''),(136,'21','224','1',1,'Sale Id shift 12',0.00,0.00,0.00,3315.00,0.00,'2022-04-06 18:14:16','',''),(137,'21','224','1',1,'Sale Id shift 12',0.00,0.00,0.00,2157.00,0.00,'2022-04-06 18:14:16','',''),(138,'21','224','2',1,'Sale Id shift 12',0.00,0.00,0.00,5786.00,0.00,'2022-04-06 18:14:16','',''),(139,'21','224',NULL,2,'Sale Id shift 12',16974818.00,0.00,0.00,0.00,0.00,'2022-04-06 18:14:16','',''),(140,'21','224',NULL,1,'Sale Id shift 12',9524790.00,0.00,0.00,0.00,0.00,'2022-04-06 18:14:16','',''),(141,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-06 18:20:36','',''),(142,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,28000000.00,40000.00,0.00,0.00,'2022-04-08 14:53:22','',''),(143,'21','224',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,30000.00,0.00,'2022-04-08 15:03:15','',''),(144,'21','224','2',1,'Received from bridging 22',0.00,0.00,30000.00,0.00,0.00,'2022-04-08 15:03:15','',''),(145,'21','224',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,15000.00,0.00,'2022-04-08 15:03:15','',''),(146,'21','224','1',1,'Received from bridging 21',0.00,0.00,15000.00,0.00,0.00,'2022-04-08 15:03:15','',''),(147,'21','224',NULL,2,'Reception corrector for bridging 23',0.00,0.00,0.00,40000.00,0.00,'2022-04-08 15:09:24','',''),(148,'21','224','5',2,'Received from bridging 23',0.00,0.00,40000.00,0.00,0.00,'2022-04-08 15:09:24','',''),(149,'21','224','1',1,'Sale Id shift 13',0.00,0.00,0.00,2602.00,0.00,'2022-04-08 16:29:02','',''),(150,'21','224','2',1,'Sale Id shift 13',0.00,0.00,0.00,4022.00,0.00,'2022-04-08 16:29:02','',''),(151,'21','224','2',1,'Sale Id shift 13',0.00,0.00,0.00,4531.00,0.00,'2022-04-08 16:29:02','',''),(152,'21','224','2',1,'Sale Id shift 13',0.00,0.00,0.00,3912.00,0.00,'2022-04-08 16:29:02','',''),(153,'21','224','2',1,'Sale Id shift 13',0.00,0.00,0.00,4422.00,0.00,'2022-04-08 16:29:02','',''),(154,'21','224','2',1,'Sale Id shift 13',0.00,0.00,0.00,4137.00,0.00,'2022-04-08 16:29:02','',''),(155,'21','224','1',1,'Sale Id shift 13',0.00,0.00,0.00,2147.00,0.00,'2022-04-08 16:29:02','',''),(156,'21','224','4',2,'Sale Id shift 13',0.00,0.00,0.00,7608.18,0.00,'2022-04-08 16:29:02','',''),(157,'21','224','1',1,'Sale Id shift 13',0.00,0.00,0.00,2526.00,0.00,'2022-04-08 16:29:02','',''),(158,'21','224','5',2,'Sale Id shift 13',0.00,0.00,0.00,7016.31,0.00,'2022-04-08 16:29:02','',''),(159,'21','224','2',1,'Sale Id shift 13',0.00,0.00,0.00,5019.00,0.00,'2022-04-08 16:29:02','',''),(160,'21','224','1',1,'Sale Id shift 13',0.00,0.00,0.00,1434.00,0.00,'2022-04-08 16:29:02','',''),(161,'21','224','1',1,'Sale Id shift 13',0.00,0.00,0.00,1501.00,0.00,'2022-04-08 16:29:02','',''),(162,'21','224','1',1,'Sale Id shift 13',0.00,0.00,0.00,1626.00,0.00,'2022-04-08 16:29:02','',''),(163,'21','224','1',1,'Sale Id shift 13',0.00,0.00,0.00,1606.00,0.00,'2022-04-08 16:29:03','',''),(164,'21','224','2',1,'Sale Id shift 13',0.00,0.00,0.00,4101.00,0.00,'2022-04-08 16:29:03','',''),(165,'21','224',NULL,2,'Sale Id shift 13',10237143.00,0.00,0.00,0.00,0.00,'2022-04-08 16:29:03','',''),(166,'21','224',NULL,1,'Sale Id shift 13',7191690.00,0.00,0.00,0.00,0.00,'2022-04-08 16:29:03','',''),(167,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-10 16:50:50','',''),(168,'21','224',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,11000000.00,20000.00,0.00,0.00,'2022-04-10 16:55:55','',''),(169,'21','224',NULL,3,'Reception corrector for bridging 28',0.00,0.00,0.00,20000.00,0.00,'2022-04-10 18:37:47','',''),(170,'21','224','6',3,'Received from bridging 28',0.00,0.00,20000.00,0.00,0.00,'2022-04-10 18:37:47','',''),(171,'21','224',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,30000.00,0.00,'2022-04-10 18:38:25','',''),(172,'21','224','2',1,'Received from bridging 27',0.00,0.00,30000.00,0.00,0.00,'2022-04-10 18:38:25','',''),(173,'21','224',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,15000.00,0.00,'2022-04-10 18:38:46','',''),(174,'21','224','1',1,'Received from bridging 26',0.00,0.00,15000.00,0.00,0.00,'2022-04-10 18:38:46','',''),(175,'21','224','1',1,'Sale Id shift 16',0.00,0.00,0.00,4358.10,0.00,'2022-04-10 22:46:24','',''),(176,'21','224','2',1,'Sale Id shift 16',0.00,0.00,0.00,5841.09,0.00,'2022-04-10 22:46:24','',''),(177,'21','224','2',1,'Sale Id shift 16',0.00,0.00,0.00,5026.96,0.00,'2022-04-10 22:46:24','',''),(178,'21','224','2',1,'Sale Id shift 16',0.00,0.00,0.00,5247.87,0.00,'2022-04-10 22:46:24','',''),(179,'21','224','2',1,'Sale Id shift 16',0.00,0.00,0.00,5060.54,0.00,'2022-04-10 22:46:24','',''),(180,'21','224','2',1,'Sale Id shift 16',0.00,0.00,0.00,4753.82,0.00,'2022-04-10 22:46:24','',''),(181,'21','224','1',1,'Sale Id shift 16',0.00,0.00,0.00,8.94,0.00,'2022-04-10 22:46:24','',''),(182,'21','224','4',2,'Sale Id shift 16',0.00,0.00,0.00,6294.18,0.00,'2022-04-10 22:46:24','',''),(183,'21','224','1',1,'Sale Id shift 16',0.00,0.00,0.00,3311.57,0.00,'2022-04-10 22:46:24','',''),(184,'21','224','6',3,'Sale Id shift 16',0.00,0.00,0.00,1145.79,0.00,'2022-04-10 22:46:24','',''),(185,'21','224','2',1,'Sale Id shift 16',0.00,0.00,0.00,6781.76,0.00,'2022-04-10 22:46:24','',''),(186,'21','224','1',1,'Sale Id shift 16',0.00,0.00,0.00,0.33,0.00,'2022-04-10 22:46:24','',''),(187,'21','224','1',1,'Sale Id shift 16',0.00,0.00,0.00,2747.00,0.00,'2022-04-10 22:46:24','',''),(188,'21','224','1',1,'Sale Id shift 16',0.00,0.00,0.00,2052.56,0.00,'2022-04-10 22:46:24','',''),(189,'21','224','1',1,'Sale Id shift 16',0.00,0.00,0.00,1956.20,0.00,'2022-04-10 22:46:24','',''),(190,'21','224','1',1,'Sale Id shift 16',0.00,0.00,0.00,2456.42,0.00,'2022-04-10 22:46:24','',''),(191,'21','224','2',1,'Sale Id shift 16',0.00,0.00,0.00,5575.62,0.00,'2022-04-10 22:46:24','',''),(192,'21','224',NULL,2,'Sale Id shift 16',4405926.00,0.00,0.00,0.00,0.00,'2022-04-10 22:46:24','',''),(193,'21','224',NULL,3,'Sale Id shift 16',630184.50,0.00,0.00,0.00,0.00,'2022-04-10 22:46:24','',''),(194,'21','224',NULL,1,'Sale Id shift 16',9104498.70,0.00,0.00,0.00,0.00,'2022-04-10 22:46:24','',''),(195,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-11 06:04:42','',''),(196,'21','224',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,15000.00,0.00,'2022-04-11 06:07:47','',''),(197,'21','224','2',1,'Received from bridging 30',0.00,0.00,15000.00,0.00,0.00,'2022-04-11 06:07:47','',''),(198,'21','224',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,30000.00,0.00,'2022-04-11 06:08:32','',''),(199,'21','224','1',1,'Received from bridging 29',0.00,0.00,30000.00,0.00,0.00,'2022-04-11 06:08:32','',''),(200,'21','224','1',1,'Sale Id shift 17',0.00,0.00,0.00,521.03,0.00,'2022-04-11 07:39:47','',''),(201,'21','224','2',1,'Sale Id shift 17',0.00,0.00,0.00,3156.30,0.00,'2022-04-11 07:39:47','',''),(202,'21','224','2',1,'Sale Id shift 17',0.00,0.00,0.00,4123.65,0.00,'2022-04-11 07:39:47','',''),(203,'21','224','2',1,'Sale Id shift 17',0.00,0.00,0.00,2299.71,0.00,'2022-04-11 07:39:47','',''),(204,'21','224','2',1,'Sale Id shift 17',0.00,0.00,0.00,3445.59,0.00,'2022-04-11 07:39:47','',''),(205,'21','224','2',1,'Sale Id shift 17',0.00,0.00,0.00,2087.83,0.00,'2022-04-11 07:39:47','',''),(206,'21','224','1',1,'Sale Id shift 17',0.00,0.00,0.00,2347.29,0.00,'2022-04-11 07:39:47','',''),(207,'21','224','4',2,'Sale Id shift 17',0.00,0.00,0.00,2600.00,0.00,'2022-04-11 07:39:47','',''),(208,'21','224','1',1,'Sale Id shift 17',0.00,0.00,0.00,3342.33,0.00,'2022-04-11 07:39:47','',''),(209,'21','224','5',2,'Sale Id shift 17',0.00,0.00,0.00,2105.91,0.00,'2022-04-11 07:39:47','',''),(210,'21','224','6',3,'Sale Id shift 17',0.00,0.00,0.00,1393.81,0.00,'2022-04-11 07:39:47','',''),(211,'21','224','2',1,'Sale Id shift 17',0.00,0.00,0.00,3562.84,0.00,'2022-04-11 07:39:47','',''),(212,'21','224','1',1,'Sale Id shift 17',0.00,0.00,0.00,2365.00,0.00,'2022-04-11 07:39:47','',''),(213,'21','224','1',1,'Sale Id shift 17',0.00,0.00,0.00,1757.25,0.00,'2022-04-11 07:39:47','',''),(214,'21','224','1',1,'Sale Id shift 17',0.00,0.00,0.00,2492.93,0.00,'2022-04-11 07:39:47','',''),(215,'21','224','1',1,'Sale Id shift 17',0.00,0.00,0.00,874.22,0.00,'2022-04-11 07:39:47','',''),(216,'21','224','2',1,'Sale Id shift 17',0.00,0.00,0.00,3331.33,0.00,'2022-04-11 07:39:47','',''),(217,'21','224',NULL,2,'Sale Id shift 17',3294137.00,0.00,0.00,0.00,0.00,'2022-04-11 07:39:47','',''),(218,'21','224',NULL,3,'Sale Id shift 17',766595.50,0.00,0.00,0.00,0.00,'2022-04-11 07:39:47','',''),(219,'21','224',NULL,1,'Sale Id shift 17',5891704.50,0.00,0.00,0.00,0.00,'2022-04-11 07:39:47','',''),(220,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,16100000.00,23000.00,0.00,0.00,'2022-04-15 23:06:49','',''),(221,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-15 23:09:14','',''),(222,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-15 23:10:31','',''),(223,'21','224',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,45000.00,0.00,'2022-04-15 23:12:18','',''),(224,'21','224','2',1,'Received from bridging 33',0.00,0.00,45000.00,0.00,0.00,'2022-04-15 23:12:18','',''),(225,'21','224',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,45000.00,0.00,'2022-04-15 23:12:41','',''),(226,'21','224','1',1,'Received from bridging 32',0.00,0.00,45000.00,0.00,0.00,'2022-04-15 23:12:41','',''),(227,'21','224',NULL,2,'Reception corrector for bridging 31',0.00,0.00,0.00,23000.00,0.00,'2022-04-15 23:13:00','',''),(228,'21','224','4',2,'Received from bridging 31',0.00,0.00,23000.00,0.00,0.00,'2022-04-15 23:13:00','',''),(229,'21','224','1',1,'Sale Id shift 18',0.00,0.00,0.00,4634.41,0.00,'2022-04-15 23:26:45','',''),(230,'21','224','2',1,'Sale Id shift 18',0.00,0.00,0.00,1831.37,0.00,'2022-04-15 23:26:45','',''),(231,'21','224','2',1,'Sale Id shift 18',0.00,0.00,0.00,1798.17,0.00,'2022-04-15 23:26:45','',''),(232,'21','224','2',1,'Sale Id shift 18',0.00,0.00,0.00,1905.85,0.00,'2022-04-15 23:26:45','',''),(233,'21','224','2',1,'Sale Id shift 18',0.00,0.00,0.00,2207.18,0.00,'2022-04-15 23:26:45','',''),(234,'21','224','2',1,'Sale Id shift 18',0.00,0.00,0.00,2319.78,0.00,'2022-04-15 23:26:45','',''),(235,'21','224','1',1,'Sale Id shift 18',0.00,0.00,0.00,4067.56,0.00,'2022-04-15 23:26:45','',''),(236,'21','224','4',2,'Sale Id shift 18',0.00,0.00,0.00,494.76,0.00,'2022-04-15 23:26:45','',''),(237,'21','224','1',1,'Sale Id shift 18',0.00,0.00,0.00,5010.22,0.00,'2022-04-15 23:26:45','',''),(238,'21','224','5',2,'Sale Id shift 18',0.00,0.00,0.00,5161.90,0.00,'2022-04-15 23:26:45','',''),(239,'21','224','6',3,'Sale Id shift 18',0.00,0.00,0.00,1794.36,0.00,'2022-04-15 23:26:45','',''),(240,'21','224','2',1,'Sale Id shift 18',0.00,0.00,0.00,2287.94,0.00,'2022-04-15 23:26:45','',''),(241,'21','224','1',1,'Sale Id shift 18',0.00,0.00,0.00,0.23,0.00,'2022-04-15 23:26:45','',''),(242,'21','224','1',1,'Sale Id shift 18',0.00,0.00,0.00,3550.00,0.00,'2022-04-15 23:26:45','',''),(243,'21','224','1',1,'Sale Id shift 18',0.00,0.00,0.00,3971.86,0.00,'2022-04-15 23:26:45','',''),(244,'21','224','1',1,'Sale Id shift 18',0.00,0.00,0.00,2971.25,0.00,'2022-04-15 23:26:45','',''),(245,'21','224','1',1,'Sale Id shift 18',0.00,0.00,0.00,4241.96,0.00,'2022-04-15 23:26:45','',''),(246,'21','224','2',1,'Sale Id shift 18',0.00,0.00,0.00,1945.42,0.00,'2022-04-15 23:26:45','',''),(247,'21','224',NULL,2,'Sale Id shift 18',3959662.00,0.00,0.00,0.00,0.00,'2022-04-15 23:26:45','',''),(248,'21','224',NULL,3,'Sale Id shift 18',986898.00,0.00,0.00,0.00,0.00,'2022-04-15 23:26:46','',''),(249,'21','224',NULL,1,'Sale Id shift 18',7052628.00,0.00,0.00,0.00,0.00,'2022-04-15 23:26:46','',''),(250,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-16 22:22:36','',''),(251,'21','224',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,30000.00,0.00,'2022-04-16 22:24:23','',''),(252,'21','224','2',1,'Received from bridging 35',0.00,0.00,30000.00,0.00,0.00,'2022-04-16 22:24:23','',''),(253,'21','224',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,20000.00,0.00,'2022-04-16 22:25:05','',''),(254,'21','224','1',1,'Received from bridging 34',0.00,0.00,20000.00,0.00,0.00,'2022-04-16 22:25:05','',''),(255,'21','224','1',1,'Sale Id shift 19',0.00,0.00,0.00,4399.61,0.00,'2022-04-16 22:48:29','',''),(256,'21','224','2',1,'Sale Id shift 19',0.00,0.00,0.00,6067.25,0.00,'2022-04-16 22:48:29','',''),(257,'21','224','2',1,'Sale Id shift 19',0.00,0.00,0.00,6277.80,0.00,'2022-04-16 22:48:29','',''),(258,'21','224','2',1,'Sale Id shift 19',0.00,0.00,0.00,4606.01,0.00,'2022-04-16 22:48:29','',''),(259,'21','224','2',1,'Sale Id shift 19',0.00,0.00,0.00,4968.92,0.00,'2022-04-16 22:48:29','',''),(260,'21','224','2',1,'Sale Id shift 19',0.00,0.00,0.00,4570.07,0.00,'2022-04-16 22:48:29','',''),(261,'21','224','1',1,'Sale Id shift 19',0.00,0.00,0.00,5047.46,0.00,'2022-04-16 22:48:29','',''),(262,'21','224','1',1,'Sale Id shift 19',0.00,0.00,0.00,6392.61,0.00,'2022-04-16 22:48:29','',''),(263,'21','224','5',2,'Sale Id shift 19',0.00,0.00,0.00,6228.45,0.00,'2022-04-16 22:48:29','',''),(264,'21','224','6',3,'Sale Id shift 19',0.00,0.00,0.00,1587.81,0.00,'2022-04-16 22:48:29','',''),(265,'21','224','2',1,'Sale Id shift 19',0.00,0.00,0.00,11915.21,0.00,'2022-04-16 22:48:29','',''),(266,'21','224','1',1,'Sale Id shift 19',0.00,0.00,0.00,2647.00,0.00,'2022-04-16 22:48:29','',''),(267,'21','224','1',1,'Sale Id shift 19',0.00,0.00,0.00,4476.90,0.00,'2022-04-16 22:48:29','',''),(268,'21','224','1',1,'Sale Id shift 19',0.00,0.00,0.00,4828.12,0.00,'2022-04-16 22:48:29','',''),(269,'21','224','1',1,'Sale Id shift 19',0.00,0.00,0.00,4547.45,0.00,'2022-04-16 22:48:29','',''),(270,'21','224','2',1,'Sale Id shift 19',0.00,0.00,0.00,6024.26,0.00,'2022-04-16 22:48:29','',''),(271,'21','224',NULL,2,'Sale Id shift 19',4359915.00,0.00,0.00,0.00,0.00,'2022-04-16 22:48:29','',''),(272,'21','224',NULL,3,'Sale Id shift 19',873295.50,0.00,0.00,0.00,0.00,'2022-04-16 22:48:29','',''),(273,'21','224',NULL,1,'Sale Id shift 19',12666830.55,0.00,0.00,0.00,0.00,'2022-04-16 22:48:29','',''),(274,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-16 22:51:34','',''),(275,'21','224',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,20000.00,0.00,'2022-04-16 22:54:02','',''),(276,'21','224','2',1,'Received from bridging 37',0.00,0.00,20000.00,0.00,0.00,'2022-04-16 22:54:02','',''),(277,'21','224',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,30000.00,0.00,'2022-04-16 22:54:29','',''),(278,'21','224','1',1,'Received from bridging 36',0.00,0.00,30000.00,0.00,0.00,'2022-04-16 22:54:29','',''),(279,'21','224','1',1,'Sale Id shift 20',0.00,0.00,0.00,3026.43,0.00,'2022-04-16 23:04:55','',''),(280,'21','224','2',1,'Sale Id shift 20',0.00,0.00,0.00,3829.66,0.00,'2022-04-16 23:04:55','',''),(281,'21','224','2',1,'Sale Id shift 20',0.00,0.00,0.00,6070.63,0.00,'2022-04-16 23:04:55','',''),(282,'21','224','2',1,'Sale Id shift 20',0.00,0.00,0.00,0.69,0.00,'2022-04-16 23:04:55','',''),(283,'21','224','2',1,'Sale Id shift 20',0.00,0.00,0.00,5291.01,0.00,'2022-04-16 23:04:55','',''),(284,'21','224','2',1,'Sale Id shift 20',0.00,0.00,0.00,3863.58,0.00,'2022-04-16 23:04:55','',''),(285,'21','224','1',1,'Sale Id shift 20',0.00,0.00,0.00,4677.09,0.00,'2022-04-16 23:04:55','',''),(286,'21','224','1',1,'Sale Id shift 20',0.00,0.00,0.00,5534.67,0.00,'2022-04-16 23:04:55','',''),(287,'21','224','5',2,'Sale Id shift 20',0.00,0.00,0.00,7119.26,0.00,'2022-04-16 23:04:55','',''),(288,'21','224','6',3,'Sale Id shift 20',0.00,0.00,0.00,1129.14,0.00,'2022-04-16 23:04:55','',''),(289,'21','224','2',1,'Sale Id shift 20',0.00,0.00,0.00,4974.87,0.00,'2022-04-16 23:04:55','',''),(290,'21','224','1',1,'Sale Id shift 20',0.00,0.00,0.00,4506.00,0.00,'2022-04-16 23:04:55','',''),(291,'21','224','1',1,'Sale Id shift 20',0.00,0.00,0.00,3759.01,0.00,'2022-04-16 23:04:55','',''),(292,'21','224','1',1,'Sale Id shift 20',0.00,0.00,0.00,2887.09,0.00,'2022-04-16 23:04:55','',''),(293,'21','224','2',1,'Sale Id shift 20',0.00,0.00,0.00,3156.65,0.00,'2022-04-16 23:04:55','',''),(294,'21','224',NULL,2,'Sale Id shift 20',4983482.00,0.00,0.00,0.00,0.00,'2022-04-16 23:04:55','',''),(295,'21','224',NULL,3,'Sale Id shift 20',621027.00,0.00,0.00,0.00,0.00,'2022-04-16 23:04:55','',''),(296,'21','224',NULL,1,'Sale Id shift 20',8510267.70,0.00,0.00,0.00,0.00,'2022-04-16 23:04:55','',''),(297,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 06:01:05','',''),(298,'21','224',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,16500000.00,30000.00,0.00,0.00,'2022-04-19 06:03:00','',''),(299,'21','224',NULL,3,'Reception corrector for bridging 40',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 06:04:03','',''),(300,'21','224','6',3,'Received from bridging 40',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 06:04:03','',''),(301,'21','224',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,16500.00,0.00,'2022-04-19 06:04:29','',''),(302,'21','224','2',1,'Received from bridging 39',0.00,0.00,16500.00,0.00,0.00,'2022-04-19 06:04:29','',''),(303,'21','224',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,33500.00,0.00,'2022-04-19 06:04:56','',''),(304,'21','224','1',1,'Received from bridging 38',0.00,0.00,33500.00,0.00,0.00,'2022-04-19 06:04:56','',''),(305,'21','224','1',1,'Sale Id shift 21',0.00,0.00,0.00,4004.41,0.00,'2022-04-19 06:19:33','',''),(306,'21','224','2',1,'Sale Id shift 21',0.00,0.00,0.00,2683.92,0.00,'2022-04-19 06:19:33','',''),(307,'21','224','2',1,'Sale Id shift 21',0.00,0.00,0.00,3444.85,0.00,'2022-04-19 06:19:33','',''),(308,'21','224','2',1,'Sale Id shift 21',0.00,0.00,0.00,2693.89,0.00,'2022-04-19 06:19:33','',''),(309,'21','224','2',1,'Sale Id shift 21',0.00,0.00,0.00,2605.13,0.00,'2022-04-19 06:19:33','',''),(310,'21','224','1',1,'Sale Id shift 21',0.00,0.00,0.00,3653.78,0.00,'2022-04-19 06:19:33','',''),(311,'21','224','1',1,'Sale Id shift 21',0.00,0.00,0.00,5045.51,0.00,'2022-04-19 06:19:33','',''),(312,'21','224','5',2,'Sale Id shift 21',0.00,0.00,0.00,6606.33,0.00,'2022-04-19 06:19:33','',''),(313,'21','224','6',3,'Sale Id shift 21',0.00,0.00,0.00,1136.59,0.00,'2022-04-19 06:19:33','',''),(314,'21','224','2',1,'Sale Id shift 21',0.00,0.00,0.00,3568.93,0.00,'2022-04-19 06:19:33','',''),(315,'21','224','1',1,'Sale Id shift 21',0.00,0.00,0.00,3979.00,0.00,'2022-04-19 06:19:33','',''),(316,'21','224','1',1,'Sale Id shift 21',0.00,0.00,0.00,9824.32,0.00,'2022-04-19 06:19:33','',''),(317,'21','224','1',1,'Sale Id shift 21',0.00,0.00,0.00,3679.17,0.00,'2022-04-19 06:19:33','',''),(318,'21','224','1',1,'Sale Id shift 21',0.00,0.00,0.00,3860.16,0.00,'2022-04-19 06:19:33','',''),(319,'21','224','2',1,'Sale Id shift 21',0.00,0.00,0.00,2467.13,0.00,'2022-04-19 06:19:33','',''),(320,'21','224',NULL,2,'Sale Id shift 21',4624431.00,0.00,0.00,0.00,0.00,'2022-04-19 06:19:33','',''),(321,'21','224',NULL,3,'Sale Id shift 21',625124.50,0.00,0.00,0.00,0.00,'2022-04-19 06:19:33','',''),(322,'21','224',NULL,1,'Sale Id shift 21',8499183.00,0.00,0.00,0.00,0.00,'2022-04-19 06:19:33','',''),(323,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,28000000.00,40000.00,0.00,0.00,'2022-04-19 06:38:06','',''),(324,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 06:40:07','',''),(325,'21','224',NULL,2,'Reception corrector for bridging 41',0.00,0.00,0.00,13500.00,0.00,'2022-04-19 06:41:53','',''),(326,'21','224','4',2,'Received from bridging 41',0.00,0.00,13500.00,0.00,0.00,'2022-04-19 06:41:53','',''),(327,'21','224',NULL,2,'Reception corrector for bridging 42',0.00,0.00,0.00,26500.00,0.00,'2022-04-19 06:42:19','',''),(328,'21','224','5',2,'Received from bridging 42',0.00,0.00,26500.00,0.00,0.00,'2022-04-19 06:42:19','',''),(329,'21','224',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,21000.00,0.00,'2022-04-19 06:42:32','',''),(330,'21','224','2',1,'Received from bridging 44',0.00,0.00,21000.00,0.00,0.00,'2022-04-19 06:42:32','',''),(331,'21','224',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,29000.00,0.00,'2022-04-19 06:43:08','',''),(332,'21','224','1',1,'Received from bridging 43',0.00,0.00,29000.00,0.00,0.00,'2022-04-19 06:43:08','',''),(333,'21','224','1',1,'Sale Id shift 22',0.00,0.00,0.00,4248.95,0.00,'2022-04-19 07:44:20','',''),(334,'21','224','2',1,'Sale Id shift 22',0.00,0.00,0.00,3021.90,0.00,'2022-04-19 07:44:20','',''),(335,'21','224','2',1,'Sale Id shift 22',0.00,0.00,0.00,4584.10,0.00,'2022-04-19 07:44:20','',''),(336,'21','224','2',1,'Sale Id shift 22',0.00,0.00,0.00,2804.46,0.00,'2022-04-19 07:44:20','',''),(337,'21','224','2',1,'Sale Id shift 22',0.00,0.00,0.00,3025.48,0.00,'2022-04-19 07:44:20','',''),(338,'21','224','1',1,'Sale Id shift 22',0.00,0.00,0.00,4823.47,0.00,'2022-04-19 07:44:20','',''),(339,'21','224','4',2,'Sale Id shift 22',0.00,0.00,0.00,43.66,0.00,'2022-04-19 07:44:20','',''),(340,'21','224','1',1,'Sale Id shift 22',0.00,0.00,0.00,7002.72,0.00,'2022-04-19 07:44:20','',''),(341,'21','224','5',2,'Sale Id shift 22',0.00,0.00,0.00,5647.70,0.00,'2022-04-19 07:44:20','',''),(342,'21','224','6',3,'Sale Id shift 22',0.00,0.00,0.00,739.36,0.00,'2022-04-19 07:44:20','',''),(343,'21','224','2',1,'Sale Id shift 22',0.00,0.00,0.00,4064.86,0.00,'2022-04-19 07:44:20','',''),(344,'21','224','1',1,'Sale Id shift 22',0.00,0.00,0.00,0.36,0.00,'2022-04-19 07:44:20','',''),(345,'21','224','1',1,'Sale Id shift 22',0.00,0.00,0.00,6459.00,0.00,'2022-04-19 07:44:20','',''),(346,'21','224','1',1,'Sale Id shift 22',0.00,0.00,0.00,4969.34,0.00,'2022-04-19 07:44:20','',''),(347,'21','224','1',1,'Sale Id shift 22',0.00,0.00,0.00,5568.34,0.00,'2022-04-19 07:44:20','',''),(348,'21','224','1',1,'Sale Id shift 22',0.00,0.00,0.00,5098.13,0.00,'2022-04-19 07:44:20','',''),(349,'21','224','2',1,'Sale Id shift 22',0.00,0.00,0.00,3009.09,0.00,'2022-04-19 07:44:20','',''),(350,'21','224',NULL,1,'Sale Id shift 22',9682233.00,0.00,0.00,0.00,0.00,'2022-04-19 07:44:20','',''),(351,'21','224',NULL,2,'Sale Id shift 22',3983952.00,0.00,0.00,0.00,0.00,'2022-04-19 07:44:20','',''),(352,'21','224',NULL,3,'Sale Id shift 22',406648.00,0.00,0.00,0.00,0.00,'2022-04-19 07:44:20','',''),(353,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-19 14:25:30','',''),(354,'21','224',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,16500.00,0.00,'2022-04-19 14:28:29','',''),(355,'21','224','2',1,'Received from bridging 46',0.00,0.00,16500.00,0.00,0.00,'2022-04-19 14:28:29','',''),(356,'21','224',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,28500.00,0.00,'2022-04-19 14:28:53','',''),(357,'21','224','1',1,'Received from bridging 45',0.00,0.00,28500.00,0.00,0.00,'2022-04-19 14:28:53','',''),(358,'21','224','1',1,'Sale Id shift 23',0.00,0.00,0.00,3630.10,0.00,'2022-04-19 14:50:07','',''),(359,'21','224','2',1,'Sale Id shift 23',0.00,0.00,0.00,3231.72,0.00,'2022-04-19 14:50:07','',''),(360,'21','224','2',1,'Sale Id shift 23',0.00,0.00,0.00,3441.44,0.00,'2022-04-19 14:50:07','',''),(361,'21','224','2',1,'Sale Id shift 23',0.00,0.00,0.00,2519.53,0.00,'2022-04-19 14:50:07','',''),(362,'21','224','2',1,'Sale Id shift 23',0.00,0.00,0.00,2944.18,0.00,'2022-04-19 14:50:07','',''),(363,'21','224','1',1,'Sale Id shift 23',0.00,0.00,0.00,3797.62,0.00,'2022-04-19 14:50:07','',''),(364,'21','224','4',2,'Sale Id shift 23',0.00,0.00,0.00,367.87,0.00,'2022-04-19 14:50:07','',''),(365,'21','224','1',1,'Sale Id shift 23',0.00,0.00,0.00,4322.87,0.00,'2022-04-19 14:50:07','',''),(366,'21','224','5',2,'Sale Id shift 23',0.00,0.00,0.00,3385.73,0.00,'2022-04-19 14:50:07','',''),(367,'21','224','6',3,'Sale Id shift 23',0.00,0.00,0.00,908.41,0.00,'2022-04-19 14:50:07','',''),(368,'21','224','2',1,'Sale Id shift 23',0.00,0.00,0.00,4052.74,0.00,'2022-04-19 14:50:07','',''),(369,'21','224','1',1,'Sale Id shift 23',0.00,0.00,0.00,4736.00,0.00,'2022-04-19 14:50:07','',''),(370,'21','224','1',1,'Sale Id shift 23',0.00,0.00,0.00,4783.32,0.00,'2022-04-19 14:50:07','',''),(371,'21','224','1',1,'Sale Id shift 23',0.00,0.00,0.00,0.09,0.00,'2022-04-19 14:50:07','',''),(372,'21','224','1',1,'Sale Id shift 23',0.00,0.00,0.00,4306.25,0.00,'2022-04-19 14:50:07','',''),(373,'21','224','2',1,'Sale Id shift 23',0.00,0.00,0.00,3382.45,0.00,'2022-04-19 14:50:07','',''),(374,'21','224',NULL,2,'Sale Id shift 23',2627520.00,0.00,0.00,0.00,0.00,'2022-04-19 14:50:07','',''),(375,'21','224',NULL,3,'Sale Id shift 23',499625.50,0.00,0.00,0.00,0.00,'2022-04-19 14:50:07','',''),(376,'21','224',NULL,1,'Sale Id shift 23',7449471.15,0.00,0.00,0.00,0.00,'2022-04-19 14:50:07','',''),(377,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-13 14:56:19','',''),(378,'21','224',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,32000.00,0.00,'2022-05-13 15:03:38','',''),(379,'21','224','3',1,'Received from bridging 48',0.00,0.00,32000.00,0.00,0.00,'2022-05-13 15:03:38','',''),(380,'21','224',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,18000.00,0.00,'2022-05-13 15:03:38','',''),(381,'21','224','2',1,'Received from bridging 47',0.00,0.00,18000.00,0.00,0.00,'2022-05-13 15:03:38','',''),(382,'21','224','3',1,'Returned bridging 48',0.00,0.00,0.00,32000.00,0.00,'2022-05-13 15:40:56','',''),(383,'21','224',NULL,1,'Reception Return corrector for bridging 48',0.00,0.00,32000.00,0.00,0.00,'2022-05-13 15:40:56','',''),(384,'21','224',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,32000.00,0.00,'2022-05-13 15:43:11','',''),(385,'21','224','1',1,'Received from bridging 49',0.00,0.00,32000.00,0.00,0.00,'2022-05-13 15:43:11','',''),(386,'21','224','1',1,'Sale Id shift 24',0.00,0.00,0.00,1296.39,0.00,'2022-05-13 15:58:50','',''),(387,'21','224','2',1,'Sale Id shift 24',0.00,0.00,0.00,2319.90,0.00,'2022-05-13 15:58:50','',''),(388,'21','224','2',1,'Sale Id shift 24',0.00,0.00,0.00,3278.87,0.00,'2022-05-13 15:58:50','',''),(389,'21','224','2',1,'Sale Id shift 24',0.00,0.00,0.00,3199.31,0.00,'2022-05-13 15:58:50','',''),(390,'21','224','2',1,'Sale Id shift 24',0.00,0.00,0.00,2210.98,0.00,'2022-05-13 15:58:50','',''),(391,'21','224','1',1,'Sale Id shift 24',0.00,0.00,0.00,4570.05,0.00,'2022-05-13 15:58:50','',''),(392,'21','224','1',1,'Sale Id shift 24',0.00,0.00,0.00,5432.95,0.00,'2022-05-13 15:58:50','',''),(393,'21','224','5',2,'Sale Id shift 24',0.00,0.00,0.00,5552.32,0.00,'2022-05-13 15:58:50','',''),(394,'21','224','6',3,'Sale Id shift 24',0.00,0.00,0.00,900.58,0.00,'2022-05-13 15:58:50','',''),(395,'21','224','2',1,'Sale Id shift 24',0.00,0.00,0.00,2904.97,0.00,'2022-05-13 15:58:50','',''),(396,'21','224','1',1,'Sale Id shift 24',0.00,0.00,0.00,0.42,0.00,'2022-05-13 15:58:50','',''),(397,'21','224','1',1,'Sale Id shift 24',0.00,0.00,0.00,3578.00,0.00,'2022-05-13 15:58:50','',''),(398,'21','224','1',1,'Sale Id shift 24',0.00,0.00,0.00,5104.49,0.00,'2022-05-13 15:58:50','',''),(399,'21','224','1',1,'Sale Id shift 24',0.00,0.00,0.00,1752.64,0.00,'2022-05-13 15:58:50','',''),(400,'21','224','1',1,'Sale Id shift 24',0.00,0.00,0.00,5076.41,0.00,'2022-05-13 15:58:50','',''),(401,'21','224','2',1,'Sale Id shift 24',0.00,0.00,0.00,2665.28,0.00,'2022-05-13 15:58:50','',''),(402,'21','224',NULL,1,'Sale Id shift 24',7159458.90,0.00,0.00,0.00,0.00,'2022-05-13 15:58:50','',''),(403,'21','224',NULL,2,'Sale Id shift 24',3886624.00,0.00,0.00,0.00,0.00,'2022-05-13 15:58:50','',''),(404,'21','224',NULL,3,'Sale Id shift 24',495319.00,0.00,0.00,0.00,0.00,'2022-05-13 15:58:50','',''),(405,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-13 20:50:24','',''),(406,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-13 20:59:42','',''),(407,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-13 21:03:26','',''),(408,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-13 21:11:42','',''),(409,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-13 21:29:24','',''),(410,'21','224',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,23000.00,0.00,'2022-05-13 21:32:15','',''),(411,'21','224','2',1,'Received from bridging 51',0.00,0.00,23000.00,0.00,0.00,'2022-05-13 21:32:15','',''),(412,'21','224',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,37000.00,0.00,'2022-05-13 21:32:15','',''),(413,'21','224','1',1,'Received from bridging 50',0.00,0.00,37000.00,0.00,0.00,'2022-05-13 21:32:15','',''),(414,'21','224','1',1,'Sale Id shift 25',0.00,0.00,0.00,83.01,0.00,'2022-05-14 00:12:01','',''),(415,'21','224','2',1,'Sale Id shift 25',0.00,0.00,0.00,2428.63,0.00,'2022-05-14 00:12:01','',''),(416,'21','224','2',1,'Sale Id shift 25',0.00,0.00,0.00,3376.33,0.00,'2022-05-14 00:12:01','',''),(417,'21','224','2',1,'Sale Id shift 25',0.00,0.00,0.00,0.04,0.00,'2022-05-14 00:12:01','',''),(418,'21','224','2',1,'Sale Id shift 25',0.00,0.00,0.00,2402.51,0.00,'2022-05-14 00:12:01','',''),(419,'21','224','2',1,'Sale Id shift 25',0.00,0.00,0.00,2460.90,0.00,'2022-05-14 00:12:01','',''),(420,'21','224','1',1,'Sale Id shift 25',0.00,0.00,0.00,6606.70,0.00,'2022-05-14 00:12:01','',''),(421,'21','224','4',2,'Sale Id shift 25',0.00,0.00,0.00,3411.63,0.00,'2022-05-14 00:12:01','',''),(422,'21','224','1',1,'Sale Id shift 25',0.00,0.00,0.00,6484.04,0.00,'2022-05-14 00:12:01','',''),(423,'21','224','5',2,'Sale Id shift 25',0.00,0.00,0.00,1445.39,0.00,'2022-05-14 00:12:01','',''),(424,'21','224','6',3,'Sale Id shift 25',0.00,0.00,0.00,1067.37,0.00,'2022-05-14 00:12:01','',''),(425,'21','224','2',1,'Sale Id shift 25',0.00,0.00,0.00,3559.68,0.00,'2022-05-14 00:12:01','',''),(426,'21','224','1',1,'Sale Id shift 25',0.00,0.00,0.00,5451.00,0.00,'2022-05-14 00:12:01','',''),(427,'21','224','1',1,'Sale Id shift 25',0.00,0.00,0.00,4904.89,0.00,'2022-05-14 00:12:01','',''),(428,'21','224','1',1,'Sale Id shift 25',0.00,0.00,0.00,5524.11,0.00,'2022-05-14 00:12:01','',''),(429,'21','224','1',1,'Sale Id shift 25',0.00,0.00,0.00,3820.75,0.00,'2022-05-14 00:12:01','',''),(430,'21','224','2',1,'Sale Id shift 25',0.00,0.00,0.00,2706.14,0.00,'2022-05-14 00:12:01','',''),(431,'21','224',NULL,2,'Sale Id shift 25',3399914.00,0.00,0.00,0.00,0.00,'2022-05-14 00:12:02','',''),(432,'21','224',NULL,3,'Sale Id shift 25',587053.50,0.00,0.00,0.00,0.00,'2022-05-14 00:12:02','',''),(433,'21','224',NULL,1,'Sale Id shift 25',8218440.45,0.00,0.00,0.00,0.00,'2022-05-14 00:12:02','',''),(434,'21','224',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,16500.00,0.00,'2022-05-14 00:12:35','',''),(435,'21','224','2',1,'Received from bridging 53',0.00,0.00,16500.00,0.00,0.00,'2022-05-14 00:12:35','',''),(436,'21','224',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,33500.00,0.00,'2022-05-14 00:12:35','',''),(437,'21','224','1',1,'Received from bridging 52',0.00,0.00,33500.00,0.00,0.00,'2022-05-14 00:12:35','',''),(438,'21','224','1',1,'Sale Id shift 26',0.00,0.00,0.00,3350.82,0.00,'2022-05-14 00:46:17','',''),(439,'21','224','2',1,'Sale Id shift 26',0.00,0.00,0.00,3903.16,0.00,'2022-05-14 00:46:17','',''),(440,'21','224','2',1,'Sale Id shift 26',0.00,0.00,0.00,5074.15,0.00,'2022-05-14 00:46:17','',''),(441,'21','224','2',1,'Sale Id shift 26',0.00,0.00,0.00,0.11,0.00,'2022-05-14 00:46:17','',''),(442,'21','224','2',1,'Sale Id shift 26',0.00,0.00,0.00,1.20,0.00,'2022-05-14 00:46:17','',''),(443,'21','224','2',1,'Sale Id shift 26',0.00,0.00,0.00,495.76,0.00,'2022-05-14 00:46:17','',''),(444,'21','224','1',1,'Sale Id shift 26',0.00,0.00,0.00,5024.14,0.00,'2022-05-14 00:46:17','',''),(445,'21','224','4',2,'Sale Id shift 26',0.00,0.00,0.00,4527.28,0.00,'2022-05-14 00:46:17','',''),(446,'21','224','1',1,'Sale Id shift 26',0.00,0.00,0.00,7284.49,0.00,'2022-05-14 00:46:17','',''),(447,'21','224','5',2,'Sale Id shift 26',0.00,0.00,0.00,0.66,0.00,'2022-05-14 00:46:17','',''),(448,'21','224','6',3,'Sale Id shift 26',0.00,0.00,0.00,971.57,0.00,'2022-05-14 00:46:17','',''),(449,'21','224','2',1,'Sale Id shift 26',0.00,0.00,0.00,5222.53,0.00,'2022-05-14 00:46:17','',''),(450,'21','224','1',1,'Sale Id shift 26',0.00,0.00,0.00,0.90,0.00,'2022-05-14 00:46:17','',''),(451,'21','224','1',1,'Sale Id shift 26',0.00,0.00,0.00,5210.00,0.00,'2022-05-14 00:46:17','',''),(452,'21','224','1',1,'Sale Id shift 26',0.00,0.00,0.00,5039.05,0.00,'2022-05-14 00:46:17','',''),(453,'21','224','1',1,'Sale Id shift 26',0.00,0.00,0.00,3809.37,0.00,'2022-05-14 00:46:17','',''),(454,'21','224','1',1,'Sale Id shift 26',0.00,0.00,0.00,4801.52,0.00,'2022-05-14 00:46:17','',''),(455,'21','224','2',1,'Sale Id shift 26',0.00,0.00,0.00,3717.78,0.00,'2022-05-14 00:46:17','',''),(456,'21','224',NULL,2,'Sale Id shift 26',3169558.00,0.00,0.00,0.00,0.00,'2022-05-14 00:46:17','',''),(457,'21','224',NULL,3,'Sale Id shift 26',534363.50,0.00,0.00,0.00,0.00,'2022-05-14 00:46:17','',''),(458,'21','224',NULL,1,'Sale Id shift 26',8734271.70,0.00,0.00,0.00,0.00,'2022-05-14 00:46:17','',''),(459,'21','224',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,20000.00,0.00,'2022-05-14 00:46:57','',''),(460,'21','224','2',1,'Received from bridging 55',0.00,0.00,20000.00,0.00,0.00,'2022-05-14 00:46:57','',''),(461,'21','224',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,30000.00,0.00,'2022-05-14 00:46:57','',''),(462,'21','224','1',1,'Received from bridging 54',0.00,0.00,30000.00,0.00,0.00,'2022-05-14 00:46:57','',''),(463,'21','224','1',1,'Sale Id shift 27',0.00,0.00,0.00,5296.39,0.00,'2022-05-14 01:06:51','',''),(464,'21','224','2',1,'Sale Id shift 27',0.00,0.00,0.00,4177.19,0.00,'2022-05-14 01:06:51','',''),(465,'21','224','2',1,'Sale Id shift 27',0.00,0.00,0.00,5121.68,0.00,'2022-05-14 01:06:51','',''),(466,'21','224','1',1,'Sale Id shift 27',0.00,0.00,0.00,3285.83,0.00,'2022-05-14 01:06:51','',''),(467,'21','224','4',2,'Sale Id shift 27',0.00,0.00,0.00,5310.01,0.00,'2022-05-14 01:06:51','',''),(468,'21','224','1',1,'Sale Id shift 27',0.00,0.00,0.00,7028.54,0.00,'2022-05-14 01:06:51','',''),(469,'21','224','6',3,'Sale Id shift 27',0.00,0.00,0.00,956.31,0.00,'2022-05-14 01:06:51','',''),(470,'21','224','2',1,'Sale Id shift 27',0.00,0.00,0.00,5084.15,0.00,'2022-05-14 01:06:51','',''),(471,'21','224','1',1,'Sale Id shift 27',0.00,0.00,0.00,5093.00,0.00,'2022-05-14 01:06:51','',''),(472,'21','224','1',1,'Sale Id shift 27',0.00,0.00,0.00,5063.39,0.00,'2022-05-14 01:06:51','',''),(473,'21','224','1',1,'Sale Id shift 27',0.00,0.00,0.00,4242.48,0.00,'2022-05-14 01:06:51','',''),(474,'21','224','1',1,'Sale Id shift 27',0.00,0.00,0.00,5244.71,0.00,'2022-05-14 01:06:51','',''),(475,'21','224','2',1,'Sale Id shift 27',0.00,0.00,0.00,3913.89,0.00,'2022-05-14 01:06:51','',''),(476,'21','224',NULL,2,'Sale Id shift 27',3717007.00,0.00,0.00,0.00,0.00,'2022-05-14 01:06:51','',''),(477,'21','224',NULL,3,'Sale Id shift 27',525970.50,0.00,0.00,0.00,0.00,'2022-05-14 01:06:51','',''),(478,'21','224',NULL,1,'Sale Id shift 27',8835956.25,0.00,0.00,0.00,0.00,'2022-05-14 01:06:51','',''),(479,'21','224',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,20000.00,0.00,'2022-05-14 05:41:48','',''),(480,'21','224','2',1,'Received from bridging 57',0.00,0.00,20000.00,0.00,0.00,'2022-05-14 05:41:48','',''),(481,'21','224',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,30000.00,0.00,'2022-05-14 05:41:48','',''),(482,'21','224','1',1,'Received from bridging 56',0.00,0.00,30000.00,0.00,0.00,'2022-05-14 05:41:48','',''),(483,'21','224','1',1,'Sale Id shift 28',0.00,0.00,0.00,3684.16,0.00,'2022-05-14 06:03:14','',''),(484,'21','224','2',1,'Sale Id shift 28',0.00,0.00,0.00,3794.90,0.00,'2022-05-14 06:03:14','',''),(485,'21','224','2',1,'Sale Id shift 28',0.00,0.00,0.00,4872.11,0.00,'2022-05-14 06:03:14','',''),(486,'21','224','2',1,'Sale Id shift 28',0.00,0.00,0.00,0.37,0.00,'2022-05-14 06:03:14','',''),(487,'21','224','2',1,'Sale Id shift 28',0.00,0.00,0.00,3897.05,0.00,'2022-05-14 06:03:14','',''),(488,'21','224','1',1,'Sale Id shift 28',0.00,0.00,0.00,4939.77,0.00,'2022-05-14 06:03:14','',''),(489,'21','224','4',2,'Sale Id shift 28',0.00,0.00,0.00,4968.92,0.00,'2022-05-14 06:03:14','',''),(490,'21','224','1',1,'Sale Id shift 28',0.00,0.00,0.00,5415.44,0.00,'2022-05-14 06:03:14','',''),(491,'21','224','6',3,'Sale Id shift 28',0.00,0.00,0.00,902.19,0.00,'2022-05-14 06:03:14','',''),(492,'21','224','2',1,'Sale Id shift 28',0.00,0.00,0.00,5105.60,0.00,'2022-05-14 06:03:14','',''),(493,'21','224','1',1,'Sale Id shift 28',0.00,0.00,0.00,3962.00,0.00,'2022-05-14 06:03:14','',''),(494,'21','224','1',1,'Sale Id shift 28',0.00,0.00,0.00,4314.41,0.00,'2022-05-14 06:03:14','',''),(495,'21','224','1',1,'Sale Id shift 28',0.00,0.00,0.00,2886.12,0.00,'2022-05-14 06:03:14','',''),(496,'21','224','1',1,'Sale Id shift 28',0.00,0.00,0.00,4749.77,0.00,'2022-05-14 06:03:14','',''),(497,'21','224','2',1,'Sale Id shift 28',0.00,0.00,0.00,3956.52,0.00,'2022-05-14 06:03:14','',''),(498,'21','224',NULL,2,'Sale Id shift 28',3478244.00,0.00,0.00,0.00,0.00,'2022-05-14 06:03:14','',''),(499,'21','224',NULL,3,'Sale Id shift 28',496204.50,0.00,0.00,0.00,0.00,'2022-05-14 06:03:14','',''),(500,'21','224',NULL,1,'Sale Id shift 28',8510406.30,0.00,0.00,0.00,0.00,'2022-05-14 06:03:14','',''),(501,'21','224',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,15000.00,0.00,'2022-05-14 06:03:37','',''),(502,'21','224','2',1,'Received from bridging 59',0.00,0.00,15000.00,0.00,0.00,'2022-05-14 06:03:37','',''),(503,'21','224',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,30000.00,0.00,'2022-05-14 06:03:37','',''),(504,'21','224','1',1,'Received from bridging 58',0.00,0.00,30000.00,0.00,0.00,'2022-05-14 06:03:37','',''),(505,'21','224','1',1,'Sale Id shift 29',0.00,0.00,0.00,5392.07,0.00,'2022-05-14 06:24:24','',''),(506,'21','224','2',1,'Sale Id shift 29',0.00,0.00,0.00,1546.48,0.00,'2022-05-14 06:24:24','',''),(507,'21','224','2',1,'Sale Id shift 29',0.00,0.00,0.00,2103.51,0.00,'2022-05-14 06:24:24','',''),(508,'21','224','2',1,'Sale Id shift 29',0.00,0.00,0.00,926.22,0.00,'2022-05-14 06:24:24','',''),(509,'21','224','2',1,'Sale Id shift 29',0.00,0.00,0.00,763.29,0.00,'2022-05-14 06:24:24','',''),(510,'21','224','1',1,'Sale Id shift 29',0.00,0.00,0.00,2930.80,0.00,'2022-05-14 06:24:24','',''),(511,'21','224','4',2,'Sale Id shift 29',0.00,0.00,0.00,6255.49,0.00,'2022-05-14 06:24:24','',''),(512,'21','224','1',1,'Sale Id shift 29',0.00,0.00,0.00,6712.77,0.00,'2022-05-14 06:24:24','',''),(513,'21','224','6',3,'Sale Id shift 29',0.00,0.00,0.00,891.83,0.00,'2022-05-14 06:24:24','',''),(514,'21','224','2',1,'Sale Id shift 29',0.00,0.00,0.00,1499.65,0.00,'2022-05-14 06:24:24','',''),(515,'21','224','1',1,'Sale Id shift 29',0.00,0.00,0.00,1.39,0.00,'2022-05-14 06:24:24','',''),(516,'21','224','1',1,'Sale Id shift 29',0.00,0.00,0.00,2903.00,0.00,'2022-05-14 06:24:24','',''),(517,'21','224','1',1,'Sale Id shift 29',0.00,0.00,0.00,6342.28,0.00,'2022-05-14 06:24:24','',''),(518,'21','224','1',1,'Sale Id shift 29',0.00,0.00,0.00,4592.57,0.00,'2022-05-14 06:24:24','',''),(519,'21','224','1',1,'Sale Id shift 29',0.00,0.00,0.00,3551.57,0.00,'2022-05-14 06:24:24','',''),(520,'21','224','2',1,'Sale Id shift 29',0.00,0.00,0.00,1486.49,0.00,'2022-05-14 06:24:24','',''),(521,'21','224',NULL,2,'Sale Id shift 29',4378843.00,0.00,0.00,0.00,0.00,'2022-05-14 06:24:24','',''),(522,'21','224',NULL,3,'Sale Id shift 29',490506.50,0.00,0.00,0.00,0.00,'2022-05-14 06:24:24','',''),(523,'21','224',NULL,1,'Sale Id shift 29',6724094.85,0.00,0.00,0.00,0.00,'2022-05-14 06:24:24','',''),(524,'21','224','1',1,'Distributed to Wazobia for sales id:43',825000.00,0.00,0.00,5000.00,0.00,'2022-05-14 12:26:56','',''),(525,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-14 19:35:00','',''),(526,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-14 19:39:21','',''),(527,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,21000000.00,30000.00,0.00,0.00,'2022-05-14 19:43:28','',''),(528,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-14 21:00:04','',''),(529,'21','224',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,20000.00,0.00,'2022-05-15 15:15:08','',''),(530,'21','224','2',1,'Received from bridging 61',0.00,0.00,20000.00,0.00,0.00,'2022-05-15 15:15:08','',''),(531,'21','224',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,40000.00,0.00,'2022-05-15 15:15:08','',''),(532,'21','224','1',1,'Received from bridging 60',0.00,0.00,40000.00,0.00,0.00,'2022-05-15 15:15:08','',''),(533,'21','224','1',1,'Sale Id shift 30',0.00,0.00,0.00,4666.74,0.00,'2022-05-15 15:55:44','',''),(534,'21','224','2',1,'Sale Id shift 30',0.00,0.00,0.00,2879.14,0.00,'2022-05-15 15:55:44','',''),(535,'21','224','2',1,'Sale Id shift 30',0.00,0.00,0.00,3442.45,0.00,'2022-05-15 15:55:44','',''),(536,'21','224','2',1,'Sale Id shift 30',0.00,0.00,0.00,0.03,0.00,'2022-05-15 15:55:44','',''),(537,'21','224','2',1,'Sale Id shift 30',0.00,0.00,0.00,2804.06,0.00,'2022-05-15 15:55:44','',''),(538,'21','224','2',1,'Sale Id shift 30',0.00,0.00,0.00,2920.21,0.00,'2022-05-15 15:55:44','',''),(539,'21','224','1',1,'Sale Id shift 30',0.00,0.00,0.00,2800.53,0.00,'2022-05-15 15:55:44','',''),(540,'21','224','3',1,'Sale Id shift 30',0.00,0.00,0.00,1243.36,0.00,'2022-05-15 15:55:44','',''),(541,'21','224','3',1,'Sale Id shift 30',0.00,0.00,0.00,1453.89,0.00,'2022-05-15 15:55:44','',''),(542,'21','224','4',2,'Sale Id shift 30',0.00,0.00,0.00,7824.95,0.00,'2022-05-15 15:55:44','',''),(543,'21','224','1',1,'Sale Id shift 30',0.00,0.00,0.00,5776.68,0.00,'2022-05-15 15:55:44','',''),(544,'21','224','5',2,'Sale Id shift 30',0.00,0.00,0.00,982.32,0.00,'2022-05-15 15:55:44','',''),(545,'21','224','6',3,'Sale Id shift 30',0.00,0.00,0.00,810.39,0.00,'2022-05-15 15:55:44','',''),(546,'21','224','2',1,'Sale Id shift 30',0.00,0.00,0.00,0.75,0.00,'2022-05-15 15:55:44','',''),(547,'21','224','2',1,'Sale Id shift 30',0.00,0.00,0.00,3787.60,0.00,'2022-05-15 15:55:44','',''),(548,'21','224','1',1,'Sale Id shift 30',0.00,0.00,0.00,4433.00,0.00,'2022-05-15 15:55:44','',''),(549,'21','224','1',1,'Sale Id shift 30',0.00,0.00,0.00,4752.32,0.00,'2022-05-15 15:55:44','',''),(550,'21','224','1',1,'Sale Id shift 30',0.00,0.00,0.00,4377.07,0.00,'2022-05-15 15:55:44','',''),(551,'21','224','1',1,'Sale Id shift 30',0.00,0.00,0.00,5276.30,0.00,'2022-05-15 15:55:44','',''),(552,'21','224','2',1,'Sale Id shift 30',0.00,0.00,0.00,2461.51,0.00,'2022-05-15 15:55:44','',''),(553,'21','224',NULL,1,'Sale Id shift 30',8757480.60,0.00,0.00,0.00,0.00,'2022-05-15 15:55:44','',''),(554,'21','224',NULL,2,'Sale Id shift 30',6165089.00,0.00,0.00,0.00,0.00,'2022-05-15 15:55:44','',''),(555,'21','224',NULL,3,'Sale Id shift 30',445714.50,0.00,0.00,0.00,0.00,'2022-05-15 15:55:44','',''),(556,'21','224',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,45000.00,0.00,'2022-05-15 15:56:42','',''),(557,'21','224','1',1,'Received from bridging 62',0.00,0.00,45000.00,0.00,0.00,'2022-05-15 15:56:42','',''),(558,'21','224','1',1,'Sale Id shift 31',0.00,0.00,0.00,7196.93,0.00,'2022-05-15 16:47:54','',''),(559,'21','224','1',1,'Sale Id shift 31',0.00,0.00,0.00,0.36,0.00,'2022-05-15 16:47:54','',''),(560,'21','224','3',1,'Sale Id shift 31',0.00,0.00,0.00,6483.58,0.00,'2022-05-15 16:47:54','',''),(561,'21','224','3',1,'Sale Id shift 31',0.00,0.00,0.00,7881.59,0.00,'2022-05-15 16:47:54','',''),(562,'21','224','4',2,'Sale Id shift 31',0.00,0.00,0.00,1.60,0.00,'2022-05-15 16:47:54','',''),(563,'21','224','1',1,'Sale Id shift 31',0.00,0.00,0.00,6266.99,0.00,'2022-05-15 16:47:54','',''),(564,'21','224','5',2,'Sale Id shift 31',0.00,0.00,0.00,6321.85,0.00,'2022-05-15 16:47:54','',''),(565,'21','224','6',3,'Sale Id shift 31',0.00,0.00,0.00,1036.88,0.00,'2022-05-15 16:47:54','',''),(566,'21','224','1',1,'Sale Id shift 31',0.00,0.00,0.00,3968.00,0.00,'2022-05-15 16:47:54','',''),(567,'21','224','1',1,'Sale Id shift 31',0.00,0.00,0.00,4896.52,0.00,'2022-05-15 16:47:54','',''),(568,'21','224','1',1,'Sale Id shift 31',0.00,0.00,0.00,5513.63,0.00,'2022-05-15 16:47:54','',''),(569,'21','224','1',1,'Sale Id shift 31',0.00,0.00,0.00,4739.47,0.00,'2022-05-15 16:47:54','',''),(570,'21','224',NULL,1,'Sale Id shift 31',7746266.55,0.00,0.00,0.00,0.00,'2022-05-15 16:47:54','',''),(571,'21','224',NULL,2,'Sale Id shift 31',4426415.00,0.00,0.00,0.00,0.00,'2022-05-15 16:47:54','',''),(572,'21','224',NULL,3,'Sale Id shift 31',570284.00,0.00,0.00,0.00,0.00,'2022-05-15 16:47:54','',''),(573,'21','224',NULL,2,'Reception corrector for bridging 63',0.00,0.00,0.00,30000.00,0.00,'2022-05-15 16:50:38','',''),(574,'21','224','4',2,'Received from bridging 63',0.00,0.00,30000.00,0.00,0.00,'2022-05-15 16:50:38','',''),(575,'21','224',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,35000.00,0.00,'2022-05-15 16:52:28','',''),(576,'21','224','1',1,'Received from bridging 64',0.00,0.00,35000.00,0.00,0.00,'2022-05-15 16:52:28','',''),(577,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,10500000.00,15000.00,0.00,0.00,'2022-05-15 17:21:50','',''),(578,'21','224',NULL,2,'Reception corrector for bridging 65',0.00,0.00,0.00,15000.00,0.00,'2022-05-15 17:22:39','',''),(579,'21','224','5',2,'Received from bridging 65',0.00,0.00,15000.00,0.00,0.00,'2022-05-15 17:22:39','',''),(580,'21','224',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,15000.00,0.00,'2022-05-15 17:29:15','',''),(581,'21','224','3',1,'Received from bridging 66',0.00,0.00,15000.00,0.00,0.00,'2022-05-15 17:29:15','',''),(582,'21','224','1',1,'Sale Id shift 32',0.00,0.00,0.00,8668.50,0.00,'2022-05-15 17:37:43','',''),(583,'21','224','3',1,'Sale Id shift 32',0.00,0.00,0.00,3089.61,0.00,'2022-05-15 17:37:43','',''),(584,'21','224','3',1,'Sale Id shift 32',0.00,0.00,0.00,3968.02,0.00,'2022-05-15 17:37:43','',''),(585,'21','224','4',2,'Sale Id shift 32',0.00,0.00,0.00,864.93,0.00,'2022-05-15 17:37:43','',''),(586,'21','224','1',1,'Sale Id shift 32',0.00,0.00,0.00,8933.29,0.00,'2022-05-15 17:37:43','',''),(587,'21','224','5',2,'Sale Id shift 32',0.00,0.00,0.00,11486.20,0.00,'2022-05-15 17:37:43','',''),(588,'21','224','6',3,'Sale Id shift 32',0.00,0.00,0.00,832.87,0.00,'2022-05-15 17:37:43','',''),(589,'21','224','1',1,'Sale Id shift 32',0.00,0.00,0.00,6263.00,0.00,'2022-05-15 17:37:43','',''),(590,'21','224','1',1,'Sale Id shift 32',0.00,0.00,0.00,5173.69,0.00,'2022-05-15 17:37:43','',''),(591,'21','224','1',1,'Sale Id shift 32',0.00,0.00,0.00,6095.30,0.00,'2022-05-15 17:37:43','',''),(592,'21','224','1',1,'Sale Id shift 32',0.00,0.00,0.00,6232.34,0.00,'2022-05-15 17:37:43','',''),(593,'21','224',NULL,1,'Sale Id shift 32',7989918.75,0.00,0.00,0.00,0.00,'2022-05-15 17:37:43','',''),(594,'21','224',NULL,2,'Sale Id shift 32',8645791.00,0.00,0.00,0.00,0.00,'2022-05-15 17:37:43','',''),(595,'21','224',NULL,3,'Sale Id shift 32',458078.50,0.00,0.00,0.00,0.00,'2022-05-15 17:37:43','',''),(596,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-15 17:40:31','',''),(597,'21','224',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,16000.00,0.00,'2022-05-15 17:44:07','',''),(598,'21','224','2',1,'Received from bridging 68',0.00,0.00,16000.00,0.00,0.00,'2022-05-15 17:44:07','',''),(599,'21','224',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,34000.00,0.00,'2022-05-15 17:44:07','',''),(600,'21','224','1',1,'Received from bridging 67',0.00,0.00,34000.00,0.00,0.00,'2022-05-15 17:44:07','',''),(601,'21','224','1',1,'Sale Id shift 33',0.00,0.00,0.00,5695.40,0.00,'2022-05-16 12:14:57','',''),(602,'21','224','2',1,'Sale Id shift 33',0.00,0.00,0.00,2132.59,0.00,'2022-05-16 12:14:57','',''),(603,'21','224','2',1,'Sale Id shift 33',0.00,0.00,0.00,2798.97,0.00,'2022-05-16 12:14:57','',''),(604,'21','224','2',1,'Sale Id shift 33',0.00,0.00,0.00,0.47,0.00,'2022-05-16 12:14:57','',''),(605,'21','224','2',1,'Sale Id shift 33',0.00,0.00,0.00,2308.59,0.00,'2022-05-16 12:14:57','',''),(606,'21','224','2',1,'Sale Id shift 33',0.00,0.00,0.00,2321.63,0.00,'2022-05-16 12:14:57','',''),(607,'21','224','1',1,'Sale Id shift 33',0.00,0.00,0.00,5969.13,0.00,'2022-05-16 12:14:57','',''),(608,'21','224','3',1,'Sale Id shift 33',0.00,0.00,0.00,5301.73,0.00,'2022-05-16 12:14:57','',''),(609,'21','224','3',1,'Sale Id shift 33',0.00,0.00,0.00,5270.74,0.00,'2022-05-16 12:14:57','',''),(610,'21','224','4',2,'Sale Id shift 33',0.00,0.00,0.00,6267.75,0.00,'2022-05-16 12:14:57','',''),(611,'21','224','1',1,'Sale Id shift 33',0.00,0.00,0.00,7445.02,0.00,'2022-05-16 12:14:57','',''),(612,'21','224','5',2,'Sale Id shift 33',0.00,0.00,0.00,2524.01,0.00,'2022-05-16 12:14:57','',''),(613,'21','224','6',3,'Sale Id shift 33',0.00,0.00,0.00,1171.29,0.00,'2022-05-16 12:14:57','',''),(614,'21','224','2',1,'Sale Id shift 33',0.00,0.00,0.00,2769.91,0.00,'2022-05-16 12:14:57','',''),(615,'21','224','1',1,'Sale Id shift 33',0.00,0.00,0.00,5125.00,0.00,'2022-05-16 12:14:57','',''),(616,'21','224','1',1,'Sale Id shift 33',0.00,0.00,0.00,6434.55,0.00,'2022-05-16 12:14:57','',''),(617,'21','224','1',1,'Sale Id shift 33',0.00,0.00,0.00,5567.34,0.00,'2022-05-16 12:14:57','',''),(618,'21','224','1',1,'Sale Id shift 33',0.00,0.00,0.00,6224.06,0.00,'2022-05-16 12:14:57','',''),(619,'21','224','2',1,'Sale Id shift 33',0.00,0.00,0.00,1757.42,0.00,'2022-05-16 12:14:57','',''),(620,'21','224',NULL,1,'Sale Id shift 33',11075220.75,0.00,0.00,0.00,0.00,'2022-05-16 12:14:57','',''),(621,'21','224',NULL,2,'Sale Id shift 33',6154232.00,0.00,0.00,0.00,0.00,'2022-05-16 12:14:57','',''),(622,'21','224',NULL,3,'Sale Id shift 33',644209.50,0.00,0.00,0.00,0.00,'2022-05-16 12:14:57','',''),(623,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-16 12:20:41','',''),(624,'21','224',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,18000.00,0.00,'2022-05-16 12:22:18','',''),(625,'21','224','2',1,'Received from bridging 70',0.00,0.00,18000.00,0.00,0.00,'2022-05-16 12:22:18','',''),(626,'21','224',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,32000.00,0.00,'2022-05-16 12:22:18','',''),(627,'21','224','1',1,'Received from bridging 69',0.00,0.00,32000.00,0.00,0.00,'2022-05-16 12:22:18','',''),(628,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,21000000.00,30000.00,0.00,0.00,'2022-05-16 12:22:28','',''),(629,'21','224',NULL,2,'Reception corrector for bridging 71',0.00,0.00,0.00,30000.00,0.00,'2022-05-16 12:24:52','',''),(630,'21','224','5',2,'Received from bridging 71',0.00,0.00,30000.00,0.00,0.00,'2022-05-16 12:24:52','',''),(631,'21','224',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,15000.00,0.00,0.00,'2022-05-16 12:25:08','',''),(632,'21','224',NULL,3,'Reception corrector for bridging 72',0.00,0.00,0.00,15000.00,0.00,'2022-05-16 12:26:13','',''),(633,'21','224','6',3,'Received from bridging 72',0.00,0.00,15000.00,0.00,0.00,'2022-05-16 12:26:13','',''),(634,'21','224','1',1,'Sale Id shift 34',0.00,0.00,0.00,4493.98,0.00,'2022-05-16 12:40:33','',''),(635,'21','224','2',1,'Sale Id shift 34',0.00,0.00,0.00,1852.08,0.00,'2022-05-16 12:40:33','',''),(636,'21','224','2',1,'Sale Id shift 34',0.00,0.00,0.00,3060.80,0.00,'2022-05-16 12:40:33','',''),(637,'21','224','2',1,'Sale Id shift 34',0.00,0.00,0.00,2167.74,0.00,'2022-05-16 12:40:33','',''),(638,'21','224','2',1,'Sale Id shift 34',0.00,0.00,0.00,1785.01,0.00,'2022-05-16 12:40:33','',''),(639,'21','224','1',1,'Sale Id shift 34',0.00,0.00,0.00,5152.44,0.00,'2022-05-16 12:40:33','',''),(640,'21','224','4',2,'Sale Id shift 34',0.00,0.00,0.00,5522.65,0.00,'2022-05-16 12:40:33','',''),(641,'21','224','1',1,'Sale Id shift 34',0.00,0.00,0.00,6526.93,0.00,'2022-05-16 12:40:33','',''),(642,'21','224','6',3,'Sale Id shift 34',0.00,0.00,0.00,892.96,0.00,'2022-05-16 12:40:33','',''),(643,'21','224','2',1,'Sale Id shift 34',0.00,0.00,0.00,2318.30,0.00,'2022-05-16 12:40:33','',''),(644,'21','224','1',1,'Sale Id shift 34',0.00,0.00,0.00,4821.00,0.00,'2022-05-16 12:40:33','',''),(645,'21','224','1',1,'Sale Id shift 34',0.00,0.00,0.00,4999.16,0.00,'2022-05-16 12:40:33','',''),(646,'21','224','1',1,'Sale Id shift 34',0.00,0.00,0.00,4347.75,0.00,'2022-05-16 12:40:33','',''),(647,'21','224','1',1,'Sale Id shift 34',0.00,0.00,0.00,4662.12,0.00,'2022-05-16 12:40:33','',''),(648,'21','224','2',1,'Sale Id shift 34',0.00,0.00,0.00,1401.95,0.00,'2022-05-16 12:40:33','',''),(649,'21','224',NULL,2,'Sale Id shift 34',3865855.00,0.00,0.00,0.00,0.00,'2022-05-16 12:40:33','',''),(650,'21','224',NULL,3,'Sale Id shift 34',491128.00,0.00,0.00,0.00,0.00,'2022-05-16 12:40:33','',''),(651,'21','224',NULL,1,'Sale Id shift 34',7852227.90,0.00,0.00,0.00,0.00,'2022-05-16 12:40:33','',''),(652,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-16 12:49:26','',''),(653,'21','224',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,20000.00,0.00,'2022-05-16 12:50:41','',''),(654,'21','224','2',1,'Received from bridging 74',0.00,0.00,20000.00,0.00,0.00,'2022-05-16 12:50:41','',''),(655,'21','224',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,30000.00,0.00,'2022-05-16 12:50:41','',''),(656,'21','224','1',1,'Received from bridging 73',0.00,0.00,30000.00,0.00,0.00,'2022-05-16 12:50:41','',''),(657,'21','224','1',1,'Sale Id shift 35',0.00,0.00,0.00,5516.55,0.00,'2022-05-16 13:08:53','',''),(658,'21','224','2',1,'Sale Id shift 35',0.00,0.00,0.00,4435.31,0.00,'2022-05-16 13:08:53','',''),(659,'21','224','2',1,'Sale Id shift 35',0.00,0.00,0.00,5456.66,0.00,'2022-05-16 13:08:53','',''),(660,'21','224','2',1,'Sale Id shift 35',0.00,0.00,0.00,4351.73,0.00,'2022-05-16 13:08:53','',''),(661,'21','224','2',1,'Sale Id shift 35',0.00,0.00,0.00,3424.06,0.00,'2022-05-16 13:08:53','',''),(662,'21','224','1',1,'Sale Id shift 35',0.00,0.00,0.00,6060.86,0.00,'2022-05-16 13:08:53','',''),(663,'21','224','4',2,'Sale Id shift 35',0.00,0.00,0.00,7397.63,0.00,'2022-05-16 13:08:53','',''),(664,'21','224','1',1,'Sale Id shift 35',0.00,0.00,0.00,6874.43,0.00,'2022-05-16 13:08:53','',''),(665,'21','224','6',3,'Sale Id shift 35',0.00,0.00,0.00,994.62,0.00,'2022-05-16 13:08:53','',''),(666,'21','224','2',1,'Sale Id shift 35',0.00,0.00,0.00,3964.00,0.00,'2022-05-16 13:08:53','',''),(667,'21','224','1',1,'Sale Id shift 35',0.00,0.00,0.00,4810.00,0.00,'2022-05-16 13:08:53','',''),(668,'21','224','1',1,'Sale Id shift 35',0.00,0.00,0.00,5507.01,0.00,'2022-05-16 13:08:53','',''),(669,'21','224','1',1,'Sale Id shift 35',0.00,0.00,0.00,5714.42,0.00,'2022-05-16 13:08:53','',''),(670,'21','224','1',1,'Sale Id shift 35',0.00,0.00,0.00,4284.51,0.00,'2022-05-16 13:08:53','',''),(671,'21','224','2',1,'Sale Id shift 35',0.00,0.00,0.00,2923.16,0.00,'2022-05-16 13:08:53','',''),(672,'21','224',NULL,1,'Sale Id shift 35',10448245.50,0.00,0.00,0.00,0.00,'2022-05-16 13:08:53','',''),(673,'21','224',NULL,2,'Sale Id shift 35',5178341.00,0.00,0.00,0.00,0.00,'2022-05-16 13:08:53','',''),(674,'21','224',NULL,3,'Sale Id shift 35',547041.00,0.00,0.00,0.00,0.00,'2022-05-16 13:08:53','',''),(675,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-16 13:50:26','',''),(676,'21','224',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,17000.00,0.00,'2022-05-16 13:52:18','',''),(677,'21','224','2',1,'Received from bridging 76',0.00,0.00,17000.00,0.00,0.00,'2022-05-16 13:52:18','',''),(678,'21','224',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,33000.00,0.00,'2022-05-16 13:52:18','',''),(679,'21','224','1',1,'Received from bridging 75',0.00,0.00,33000.00,0.00,0.00,'2022-05-16 13:52:18','',''),(680,'21','224','1',1,'Sale Id shift 36',0.00,0.00,0.00,4553.85,0.00,'2022-05-16 14:12:37','',''),(681,'21','224','2',1,'Sale Id shift 36',0.00,0.00,0.00,2672.72,0.00,'2022-05-16 14:12:37','',''),(682,'21','224','2',1,'Sale Id shift 36',0.00,0.00,0.00,2969.86,0.00,'2022-05-16 14:12:37','',''),(683,'21','224','2',1,'Sale Id shift 36',0.00,0.00,0.00,2675.26,0.00,'2022-05-16 14:12:37','',''),(684,'21','224','2',1,'Sale Id shift 36',0.00,0.00,0.00,2683.64,0.00,'2022-05-16 14:12:37','',''),(685,'21','224','1',1,'Sale Id shift 36',0.00,0.00,0.00,4287.97,0.00,'2022-05-16 14:12:37','',''),(686,'21','224','4',2,'Sale Id shift 36',0.00,0.00,0.00,595.31,0.00,'2022-05-16 14:12:37','',''),(687,'21','224','1',1,'Sale Id shift 36',0.00,0.00,0.00,4798.98,0.00,'2022-05-16 14:12:37','',''),(688,'21','224','5',2,'Sale Id shift 36',0.00,0.00,0.00,6600.83,0.00,'2022-05-16 14:12:37','',''),(689,'21','224','6',3,'Sale Id shift 36',0.00,0.00,0.00,1010.21,0.00,'2022-05-16 14:12:37','',''),(690,'21','224','2',1,'Sale Id shift 36',0.00,0.00,0.00,3490.74,0.00,'2022-05-16 14:12:37','',''),(691,'21','224','1',1,'Sale Id shift 36',0.00,0.00,0.00,3321.00,0.00,'2022-05-16 14:12:37','',''),(692,'21','224','1',1,'Sale Id shift 36',0.00,0.00,0.00,4905.17,0.00,'2022-05-16 14:12:37','',''),(693,'21','224','1',1,'Sale Id shift 36',0.00,0.00,0.00,3687.15,0.00,'2022-05-16 14:12:37','',''),(694,'21','224','1',1,'Sale Id shift 36',0.00,0.00,0.00,4500.94,0.00,'2022-05-16 14:12:37','',''),(695,'21','224','2',1,'Sale Id shift 36',0.00,0.00,0.00,2569.66,0.00,'2022-05-16 14:12:37','',''),(696,'21','224',NULL,2,'Sale Id shift 36',5037298.00,0.00,0.00,0.00,0.00,'2022-05-16 14:12:37','',''),(697,'21','224',NULL,3,'Sale Id shift 36',555615.50,0.00,0.00,0.00,0.00,'2022-05-16 14:12:37','',''),(698,'21','224',NULL,1,'Sale Id shift 36',7774295.10,0.00,0.00,0.00,0.00,'2022-05-16 14:12:37','',''),(699,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8200500.00,49700.00,0.00,0.00,'2022-05-16 14:13:17','',''),(700,'21','224',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,20000.00,0.00,'2022-05-16 14:14:55','',''),(701,'21','224','2',1,'Received from bridging 78',0.00,0.00,20000.00,0.00,0.00,'2022-05-16 14:14:55','',''),(702,'21','224',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,29700.00,0.00,'2022-05-16 14:18:15','',''),(703,'21','224','1',1,'Received from bridging 79',0.00,0.00,29700.00,0.00,0.00,'2022-05-16 14:18:15','',''),(704,'21','224','1',1,'Sale Id shift 37',0.00,0.00,0.00,3498.55,0.00,'2022-05-16 14:42:11','',''),(705,'21','224','2',1,'Sale Id shift 37',0.00,0.00,0.00,1949.26,0.00,'2022-05-16 14:42:11','',''),(706,'21','224','2',1,'Sale Id shift 37',0.00,0.00,0.00,2363.71,0.00,'2022-05-16 14:42:11','',''),(707,'21','224','2',1,'Sale Id shift 37',0.00,0.00,0.00,2521.57,0.00,'2022-05-16 14:42:11','',''),(708,'21','224','2',1,'Sale Id shift 37',0.00,0.00,0.00,2385.82,0.00,'2022-05-16 14:42:11','',''),(709,'21','224','1',1,'Sale Id shift 37',0.00,0.00,0.00,4356.20,0.00,'2022-05-16 14:42:11','',''),(710,'21','224','1',1,'Sale Id shift 37',0.00,0.00,0.00,4715.23,0.00,'2022-05-16 14:42:11','',''),(711,'21','224','5',2,'Sale Id shift 37',0.00,0.00,0.00,5520.70,0.00,'2022-05-16 14:42:11','',''),(712,'21','224','6',3,'Sale Id shift 37',0.00,0.00,0.00,1062.12,0.00,'2022-05-16 14:42:11','',''),(713,'21','224','2',1,'Sale Id shift 37',0.00,0.00,0.00,2263.70,0.00,'2022-05-16 14:42:11','',''),(714,'21','224','1',1,'Sale Id shift 37',0.00,0.00,0.00,3134.00,0.00,'2022-05-16 14:42:11','',''),(715,'21','224','1',1,'Sale Id shift 37',0.00,0.00,0.00,3552.61,0.00,'2022-05-16 14:42:11','',''),(716,'21','224','1',1,'Sale Id shift 37',0.00,0.00,0.00,4109.72,0.00,'2022-05-16 14:42:11','',''),(717,'21','224','1',1,'Sale Id shift 37',0.00,0.00,0.00,3626.64,0.00,'2022-05-16 14:42:11','',''),(718,'21','224','2',1,'Sale Id shift 37',0.00,0.00,0.00,2181.92,0.00,'2022-05-16 14:42:11','',''),(719,'21','224',NULL,2,'Sale Id shift 37',3864490.00,0.00,0.00,0.00,0.00,'2022-05-16 14:42:11','',''),(720,'21','224',NULL,3,'Sale Id shift 37',584166.00,0.00,0.00,0.00,0.00,'2022-05-16 14:42:11','',''),(721,'21','224',NULL,1,'Sale Id shift 37',6708723.45,0.00,0.00,0.00,0.00,'2022-05-16 14:42:11','',''),(722,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-16 14:42:28','',''),(723,'21','224',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,21000.00,0.00,'2022-05-16 14:44:04','',''),(724,'21','224','2',1,'Received from bridging 81',0.00,0.00,21000.00,0.00,0.00,'2022-05-16 14:44:04','',''),(725,'21','224',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,29000.00,0.00,'2022-05-16 14:44:04','',''),(726,'21','224','1',1,'Received from bridging 80',0.00,0.00,29000.00,0.00,0.00,'2022-05-16 14:44:04','',''),(727,'21','224','1',1,'Sale Id shift 38',0.00,0.00,0.00,3044.22,0.00,'2022-05-16 15:06:43','',''),(728,'21','224','2',1,'Sale Id shift 38',0.00,0.00,0.00,2666.48,0.00,'2022-05-16 15:06:43','',''),(729,'21','224','2',1,'Sale Id shift 38',0.00,0.00,0.00,2561.66,0.00,'2022-05-16 15:06:43','',''),(730,'21','224','2',1,'Sale Id shift 38',0.00,0.00,0.00,1603.48,0.00,'2022-05-16 15:06:43','',''),(731,'21','224','2',1,'Sale Id shift 38',0.00,0.00,0.00,2716.15,0.00,'2022-05-16 15:06:43','',''),(732,'21','224','1',1,'Sale Id shift 38',0.00,0.00,0.00,3299.74,0.00,'2022-05-16 15:06:43','',''),(733,'21','224','1',1,'Sale Id shift 38',0.00,0.00,0.00,4687.79,0.00,'2022-05-16 15:06:43','',''),(734,'21','224','5',2,'Sale Id shift 38',0.00,0.00,0.00,4824.48,0.00,'2022-05-16 15:06:43','',''),(735,'21','224','6',3,'Sale Id shift 38',0.00,0.00,0.00,673.82,0.00,'2022-05-16 15:06:43','',''),(736,'21','224','2',1,'Sale Id shift 38',0.00,0.00,0.00,2371.43,0.00,'2022-05-16 15:06:43','',''),(737,'21','224','1',1,'Sale Id shift 38',0.00,0.00,0.00,3540.00,0.00,'2022-05-16 15:06:43','',''),(738,'21','224','1',1,'Sale Id shift 38',0.00,0.00,0.00,3494.22,0.00,'2022-05-16 15:06:43','',''),(739,'21','224','1',1,'Sale Id shift 38',0.00,0.00,0.00,2892.98,0.00,'2022-05-16 15:06:43','',''),(740,'21','224','1',1,'Sale Id shift 38',0.00,0.00,0.00,3543.31,0.00,'2022-05-16 15:06:43','',''),(741,'21','224','2',1,'Sale Id shift 38',0.00,0.00,0.00,2139.86,0.00,'2022-05-16 15:06:43','',''),(742,'21','224',NULL,1,'Sale Id shift 38',6362617.80,0.00,0.00,0.00,0.00,'2022-05-16 15:06:43','',''),(743,'21','224',NULL,2,'Sale Id shift 38',3377136.00,0.00,0.00,0.00,0.00,'2022-05-16 15:06:43','',''),(744,'21','224',NULL,3,'Sale Id shift 38',370601.00,0.00,0.00,0.00,0.00,'2022-05-16 15:06:43','',''),(745,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-16 15:08:01','',''),(746,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-16 15:20:16','',''),(747,'21','224',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,40000.00,0.00,'2022-05-16 15:21:06','',''),(748,'21','224','2',1,'Received from bridging 82',0.00,0.00,40000.00,0.00,0.00,'2022-05-16 15:21:06','',''),(749,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-16 15:21:48','',''),(750,'21','224',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,40000.00,0.00,'2022-05-16 15:24:29','',''),(751,'21','224','1',1,'Received from bridging 84',0.00,0.00,40000.00,0.00,0.00,'2022-05-16 15:24:29','',''),(752,'21','224','1',1,'Sale Id shift 39',0.00,0.00,0.00,6284.83,0.00,'2022-05-16 15:52:00','',''),(753,'21','224','2',1,'Sale Id shift 39',0.00,0.00,0.00,2805.91,0.00,'2022-05-16 15:52:00','',''),(754,'21','224','2',1,'Sale Id shift 39',0.00,0.00,0.00,3927.53,0.00,'2022-05-16 15:52:00','',''),(755,'21','224','2',1,'Sale Id shift 39',0.00,0.00,0.00,2503.15,0.00,'2022-05-16 15:52:00','',''),(756,'21','224','2',1,'Sale Id shift 39',0.00,0.00,0.00,3235.74,0.00,'2022-05-16 15:52:00','',''),(757,'21','224','1',1,'Sale Id shift 39',0.00,0.00,0.00,368.54,0.00,'2022-05-16 15:52:00','',''),(758,'21','224','3',1,'Sale Id shift 39',0.00,0.00,0.00,0.39,0.00,'2022-05-16 15:52:00','',''),(759,'21','224','1',1,'Sale Id shift 39',0.00,0.00,0.00,5931.45,0.00,'2022-05-16 15:52:00','',''),(760,'21','224','5',2,'Sale Id shift 39',0.00,0.00,0.00,4977.52,0.00,'2022-05-16 15:52:00','',''),(761,'21','224','6',3,'Sale Id shift 39',0.00,0.00,0.00,903.73,0.00,'2022-05-16 15:52:00','',''),(762,'21','224','2',1,'Sale Id shift 39',0.00,0.00,0.00,2923.19,0.00,'2022-05-16 15:52:00','',''),(763,'21','224','1',1,'Sale Id shift 39',0.00,0.00,0.00,0.83,0.00,'2022-05-16 15:52:00','',''),(764,'21','224','1',1,'Sale Id shift 39',0.00,0.00,0.00,4457.00,0.00,'2022-05-16 15:52:00','',''),(765,'21','224','1',1,'Sale Id shift 39',0.00,0.00,0.00,5622.51,0.00,'2022-05-16 15:52:00','',''),(766,'21','224','1',1,'Sale Id shift 39',0.00,0.00,0.00,4548.91,0.00,'2022-05-16 15:52:00','',''),(767,'21','224','1',1,'Sale Id shift 39',0.00,0.00,0.00,3830.84,0.00,'2022-05-16 15:52:00','',''),(768,'21','224','2',1,'Sale Id shift 39',0.00,0.00,0.00,2578.96,0.00,'2022-05-16 15:52:00','',''),(769,'21','224',NULL,2,'Sale Id shift 39',3484264.00,0.00,0.00,0.00,0.00,'2022-05-16 15:52:00','',''),(770,'21','224',NULL,3,'Sale Id shift 39',497051.50,0.00,0.00,0.00,0.00,'2022-05-16 15:52:00','',''),(771,'21','224',NULL,1,'Sale Id shift 39',8088263.70,0.00,0.00,0.00,0.00,'2022-05-16 15:52:00','',''),(772,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-16 16:20:39','',''),(773,'21','224',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,40000.00,0.00,'2022-05-16 16:54:21','',''),(774,'21','224','1',1,'Received from bridging 87',0.00,0.00,40000.00,0.00,0.00,'2022-05-16 16:54:21','',''),(775,'21','224','1',1,'Sale Id shift 40',0.00,0.00,0.00,4841.83,0.00,'2022-05-16 17:08:10','',''),(776,'21','224','2',1,'Sale Id shift 40',0.00,0.00,0.00,4.31,0.00,'2022-05-16 17:08:10','',''),(777,'21','224','2',1,'Sale Id shift 40',0.00,0.00,0.00,7083.50,0.00,'2022-05-16 17:08:10','',''),(778,'21','224','2',1,'Sale Id shift 40',0.00,0.00,0.00,0.35,0.00,'2022-05-16 17:08:10','',''),(779,'21','224','2',1,'Sale Id shift 40',0.00,0.00,0.00,6617.63,0.00,'2022-05-16 17:08:10','',''),(780,'21','224','1',1,'Sale Id shift 40',0.00,0.00,0.00,5352.82,0.00,'2022-05-16 17:08:10','',''),(781,'21','224','4',2,'Sale Id shift 40',0.00,0.00,0.00,7728.04,0.00,'2022-05-16 17:08:10','',''),(782,'21','224','1',1,'Sale Id shift 40',0.00,0.00,0.00,4700.42,0.00,'2022-05-16 17:08:10','',''),(783,'21','224','5',2,'Sale Id shift 40',0.00,0.00,0.00,265.71,0.00,'2022-05-16 17:08:10','',''),(784,'21','224','6',3,'Sale Id shift 40',0.00,0.00,0.00,1158.25,0.00,'2022-05-16 17:08:10','',''),(785,'21','224','2',1,'Sale Id shift 40',0.00,0.00,0.00,6245.94,0.00,'2022-05-16 17:08:10','',''),(786,'21','224','1',1,'Sale Id shift 40',0.00,0.00,0.00,0.37,0.00,'2022-05-16 17:08:10','',''),(787,'21','224','1',1,'Sale Id shift 40',0.00,0.00,0.00,4751.00,0.00,'2022-05-16 17:08:10','',''),(788,'21','224','1',1,'Sale Id shift 40',0.00,0.00,0.00,6149.10,0.00,'2022-05-16 17:08:10','',''),(789,'21','224','1',1,'Sale Id shift 40',0.00,0.00,0.00,4798.18,0.00,'2022-05-16 17:08:10','',''),(790,'21','224','1',1,'Sale Id shift 40',0.00,0.00,0.00,4602.62,0.00,'2022-05-16 17:08:10','',''),(791,'21','224','2',1,'Sale Id shift 40',0.00,0.00,0.00,7488.52,0.00,'2022-05-16 17:08:10','',''),(792,'21','224',NULL,2,'Sale Id shift 40',5595625.00,0.00,0.00,0.00,0.00,'2022-05-16 17:08:10','',''),(793,'21','224',NULL,3,'Sale Id shift 40',637037.50,0.00,0.00,0.00,0.00,'2022-05-16 17:08:10','',''),(794,'21','224',NULL,1,'Sale Id shift 40',10335037.35,0.00,0.00,0.00,0.00,'2022-05-16 17:08:10','',''),(795,'21','224',NULL,1,'Reception corrector for bridging 85',0.00,0.00,0.00,32000.00,0.00,'2022-05-16 17:09:38','',''),(796,'21','224','1',1,'Received from bridging 85',0.00,0.00,32000.00,0.00,0.00,'2022-05-16 17:09:38','',''),(797,'21','224',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,20000.00,0.00,'2022-05-16 17:10:11','',''),(798,'21','224','2',1,'Received from bridging 86',0.00,0.00,20000.00,0.00,0.00,'2022-05-16 17:10:11','',''),(799,'21','224',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,18000.00,0.00,'2022-05-16 17:10:54','',''),(800,'21','224','2',1,'Received from bridging 83',0.00,0.00,18000.00,0.00,0.00,'2022-05-16 17:10:54','',''),(801,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,21000000.00,30000.00,0.00,0.00,'2022-05-17 10:59:49','',''),(802,'21','224',NULL,2,'Reception corrector for bridging 89',0.00,0.00,0.00,5000.00,0.00,'2022-05-17 11:00:45','',''),(803,'21','224','4',2,'Received from bridging 89',0.00,0.00,5000.00,0.00,0.00,'2022-05-17 11:00:45','',''),(804,'21','224','1',1,'Sale Id shift 41',0.00,0.00,0.00,4781.32,0.00,'2022-05-17 11:16:37','',''),(805,'21','224','2',1,'Sale Id shift 41',0.00,0.00,0.00,0.61,0.00,'2022-05-17 11:16:37','',''),(806,'21','224','2',1,'Sale Id shift 41',0.00,0.00,0.00,6693.59,0.00,'2022-05-17 11:16:37','',''),(807,'21','224','2',1,'Sale Id shift 41',0.00,0.00,0.00,5991.17,0.00,'2022-05-17 11:16:37','',''),(808,'21','224','1',1,'Sale Id shift 41',0.00,0.00,0.00,5654.92,0.00,'2022-05-17 11:16:37','',''),(809,'21','224','4',2,'Sale Id shift 41',0.00,0.00,0.00,5253.17,0.00,'2022-05-17 11:16:37','',''),(810,'21','224','1',1,'Sale Id shift 41',0.00,0.00,0.00,6606.54,0.00,'2022-05-17 11:16:37','',''),(811,'21','224','5',2,'Sale Id shift 41',0.00,0.00,0.00,3875.42,0.00,'2022-05-17 11:16:37','',''),(812,'21','224','6',3,'Sale Id shift 41',0.00,0.00,0.00,1182.54,0.00,'2022-05-17 11:16:37','',''),(813,'21','224','2',1,'Sale Id shift 41',0.00,0.00,0.00,4891.41,0.00,'2022-05-17 11:16:37','',''),(814,'21','224','1',1,'Sale Id shift 41',0.00,0.00,0.00,4576.00,0.00,'2022-05-17 11:16:37','',''),(815,'21','224','1',1,'Sale Id shift 41',0.00,0.00,0.00,5664.60,0.00,'2022-05-17 11:16:37','',''),(816,'21','224','1',1,'Sale Id shift 41',0.00,0.00,0.00,4778.69,0.00,'2022-05-17 11:16:37','',''),(817,'21','224','1',1,'Sale Id shift 41',0.00,0.00,0.00,4342.24,0.00,'2022-05-17 11:16:37','',''),(818,'21','224','2',1,'Sale Id shift 41',0.00,0.00,0.00,7466.92,0.00,'2022-05-17 11:16:37','',''),(819,'21','224',NULL,1,'Sale Id shift 41',10138921.65,0.00,0.00,0.00,0.00,'2022-05-17 11:16:37','',''),(820,'21','224',NULL,2,'Sale Id shift 41',6390013.00,0.00,0.00,0.00,0.00,'2022-05-17 11:16:37','',''),(821,'21','224',NULL,3,'Sale Id shift 41',650397.00,0.00,0.00,0.00,0.00,'2022-05-17 11:16:37','',''),(822,'21','224','1',1,'Sale Id shift 42',0.00,0.00,0.00,3636.46,0.00,'2022-05-17 12:34:09','',''),(823,'21','224','2',1,'Sale Id shift 42',0.00,0.00,0.00,6983.67,0.00,'2022-05-17 12:34:09','',''),(824,'21','224','2',1,'Sale Id shift 42',0.00,0.00,0.00,7299.27,0.00,'2022-05-17 12:34:09','',''),(825,'21','224','1',1,'Sale Id shift 42',0.00,0.00,0.00,4810.80,0.00,'2022-05-17 12:34:09','',''),(826,'21','224','1',1,'Sale Id shift 42',0.00,0.00,0.00,5155.22,0.00,'2022-05-17 12:34:09','',''),(827,'21','224','5',2,'Sale Id shift 42',0.00,0.00,0.00,7865.70,0.00,'2022-05-17 12:34:09','',''),(828,'21','224','6',3,'Sale Id shift 42',0.00,0.00,0.00,1212.81,0.00,'2022-05-17 12:34:09','',''),(829,'21','224','2',1,'Sale Id shift 42',0.00,0.00,0.00,6949.86,0.00,'2022-05-17 12:34:09','',''),(830,'21','224','1',1,'Sale Id shift 42',0.00,0.00,0.00,0.74,0.00,'2022-05-17 12:34:09','',''),(831,'21','224','1',1,'Sale Id shift 42',0.00,0.00,0.00,3716.00,0.00,'2022-05-17 12:34:09','',''),(832,'21','224','1',1,'Sale Id shift 42',0.00,0.00,0.00,3811.38,0.00,'2022-05-17 12:34:09','',''),(833,'21','224','1',1,'Sale Id shift 42',0.00,0.00,0.00,4347.47,0.00,'2022-05-17 12:34:09','',''),(834,'21','224','1',1,'Sale Id shift 42',0.00,0.00,0.00,3325.50,0.00,'2022-05-17 12:34:09','',''),(835,'21','224','2',1,'Sale Id shift 42',0.00,0.00,0.00,7669.99,0.00,'2022-05-17 12:34:09','',''),(836,'21','224',NULL,2,'Sale Id shift 42',5505990.00,0.00,0.00,0.00,0.00,'2022-05-17 12:34:09','',''),(837,'21','224',NULL,3,'Sale Id shift 42',667045.50,0.00,0.00,0.00,0.00,'2022-05-17 12:34:09','',''),(838,'21','224',NULL,1,'Sale Id shift 42',9521549.40,0.00,0.00,0.00,0.00,'2022-05-17 12:34:09','',''),(839,'21','224',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,20000.00,0.00,'2022-05-17 12:36:33','',''),(840,'21','224','2',1,'Received from bridging 90',0.00,0.00,20000.00,0.00,0.00,'2022-05-17 12:36:33','',''),(841,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-17 12:51:24','',''),(842,'21','224',NULL,1,'Reception corrector for bridging 92',0.00,0.00,0.00,20000.00,0.00,'2022-05-17 12:52:48','',''),(843,'21','224','2',1,'Received from bridging 92',0.00,0.00,20000.00,0.00,0.00,'2022-05-17 12:52:48','',''),(844,'21','224',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,40000.00,0.00,'2022-05-17 12:52:48','',''),(845,'21','224','1',1,'Received from bridging 91',0.00,0.00,40000.00,0.00,0.00,'2022-05-17 12:52:48','',''),(846,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,10500000.00,15000.00,0.00,0.00,'2022-05-17 15:41:28','',''),(847,'21','224',NULL,2,'Reception corrector for bridging 93',0.00,0.00,0.00,25000.00,0.00,'2022-05-17 15:42:15','',''),(848,'21','224','4',2,'Received from bridging 93',0.00,0.00,25000.00,0.00,0.00,'2022-05-17 15:42:15','',''),(849,'21','224',NULL,2,'Reception corrector for bridging 94',0.00,0.00,0.00,15000.00,0.00,'2022-05-17 15:42:25','',''),(850,'21','224','5',2,'Received from bridging 94',0.00,0.00,15000.00,0.00,0.00,'2022-05-17 15:42:25','',''),(851,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-17 15:42:59','',''),(852,'21','224',NULL,1,'Reception corrector for bridging 95',0.00,0.00,0.00,20000.00,0.00,'2022-05-17 15:43:47','',''),(853,'21','224','3',1,'Received from bridging 95',0.00,0.00,20000.00,0.00,0.00,'2022-05-17 15:43:47','',''),(854,'21','224',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,19256.73,0.00,'2022-05-17 17:05:07','',''),(855,'21','224','3',1,'Received from bridging 96',0.00,0.00,19256.73,0.00,0.00,'2022-05-17 17:05:07','',''),(856,'21','224',NULL,1,'Reception corrector for bridging 97',0.00,0.00,0.00,20743.27,0.00,'2022-05-17 17:37:22','',''),(857,'21','224','2',1,'Received from bridging 97',0.00,0.00,20743.27,0.00,0.00,'2022-05-17 17:37:22','',''),(858,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-17 17:40:25','',''),(859,'21','224',NULL,1,'Reception corrector for bridging 98',0.00,0.00,0.00,32000.00,0.00,'2022-05-17 17:42:13','',''),(860,'21','224','1',1,'Received from bridging 98',0.00,0.00,32000.00,0.00,0.00,'2022-05-17 17:42:13','',''),(861,'21','224','1',1,'Sale Id shift 43',0.00,0.00,0.00,5419.41,0.00,'2022-05-17 17:57:09','',''),(862,'21','224','2',1,'Sale Id shift 43',0.00,0.00,0.00,3848.54,0.00,'2022-05-17 17:57:09','',''),(863,'21','224','2',1,'Sale Id shift 43',0.00,0.00,0.00,3931.53,0.00,'2022-05-17 17:57:09','',''),(864,'21','224','3',1,'Sale Id shift 43',0.00,0.00,0.00,3569.92,0.00,'2022-05-17 17:57:09','',''),(865,'21','224','3',1,'Sale Id shift 43',0.00,0.00,0.00,3318.11,0.00,'2022-05-17 17:57:09','',''),(866,'21','224','1',1,'Sale Id shift 43',0.00,0.00,0.00,6823.48,0.00,'2022-05-17 17:57:09','',''),(867,'21','224','3',1,'Sale Id shift 43',0.00,0.00,0.00,2430.55,0.00,'2022-05-17 17:57:09','',''),(868,'21','224','3',1,'Sale Id shift 43',0.00,0.00,0.00,3145.51,0.00,'2022-05-17 17:57:09','',''),(869,'21','224','1',1,'Sale Id shift 43',0.00,0.00,0.00,9817.15,0.00,'2022-05-17 17:57:09','',''),(870,'21','224','5',2,'Sale Id shift 43',0.00,0.00,0.00,4724.32,0.00,'2022-05-17 17:57:09','',''),(871,'21','224','6',3,'Sale Id shift 43',0.00,0.00,0.00,975.74,0.00,'2022-05-17 17:57:09','',''),(872,'21','224','2',1,'Sale Id shift 43',0.00,0.00,0.00,4244.67,0.00,'2022-05-17 17:57:09','',''),(873,'21','224','1',1,'Sale Id shift 43',0.00,0.00,0.00,1.79,0.00,'2022-05-17 17:57:09','',''),(874,'21','224','1',1,'Sale Id shift 43',0.00,0.00,0.00,4710.00,0.00,'2022-05-17 17:57:09','',''),(875,'21','224','1',1,'Sale Id shift 43',0.00,0.00,0.00,6341.08,0.00,'2022-05-17 17:57:09','',''),(876,'21','224','1',1,'Sale Id shift 43',0.00,0.00,0.00,6009.02,0.00,'2022-05-17 17:57:09','',''),(877,'21','224','1',1,'Sale Id shift 43',0.00,0.00,0.00,4380.92,0.00,'2022-05-17 17:57:09','',''),(878,'21','224','2',1,'Sale Id shift 43',0.00,0.00,0.00,4179.29,0.00,'2022-05-17 17:57:09','',''),(879,'21','224',NULL,1,'Sale Id shift 43',11908210.05,0.00,0.00,0.00,0.00,'2022-05-17 17:57:09','',''),(880,'21','224',NULL,2,'Sale Id shift 43',3307024.00,0.00,0.00,0.00,0.00,'2022-05-17 17:57:09','',''),(881,'21','224',NULL,3,'Sale Id shift 43',536657.00,0.00,0.00,0.00,0.00,'2022-05-17 17:57:09','',''),(882,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-17 18:17:24','',''),(883,'21','224',NULL,1,'Reception corrector for bridging 100',0.00,0.00,0.00,20000.00,0.00,'2022-05-17 18:18:52','',''),(884,'21','224','1',1,'Received from bridging 100',0.00,0.00,20000.00,0.00,0.00,'2022-05-17 18:18:52','',''),(885,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-17 18:23:03','',''),(886,'21','224',NULL,1,'Reception corrector for bridging 101',0.00,0.00,0.00,40000.00,0.00,'2022-05-17 18:24:49','',''),(887,'21','224','1',1,'Received from bridging 101',0.00,0.00,40000.00,0.00,0.00,'2022-05-17 18:24:49','',''),(888,'21','224',NULL,1,'Reception corrector for bridging 99',0.00,0.00,0.00,18000.00,0.00,'2022-05-17 18:27:13','',''),(889,'21','224','2',1,'Received from bridging 99',0.00,0.00,18000.00,0.00,0.00,'2022-05-17 18:27:13','',''),(890,'21','224',NULL,1,'Reception corrector for bridging 102',0.00,0.00,0.00,296.94,0.00,'2022-05-17 18:32:45','',''),(891,'21','224','3',1,'Received from bridging 102',0.00,0.00,296.94,0.00,0.00,'2022-05-17 18:32:45','',''),(892,'21','224',NULL,1,'Reception corrector for bridging 103',0.00,0.00,0.00,50.00,0.00,'2022-05-17 18:35:31','',''),(893,'21','224','3',1,'Received from bridging 103',0.00,0.00,50.00,0.00,0.00,'2022-05-17 18:35:31','',''),(894,'21','224','1',1,'Sale Id shift 44',0.00,0.00,0.00,4670.31,0.00,'2022-05-17 19:19:47','',''),(895,'21','224','2',1,'Sale Id shift 44',0.00,0.00,0.00,5638.60,0.00,'2022-05-17 19:19:47','',''),(896,'21','224','2',1,'Sale Id shift 44',0.00,0.00,0.00,0.05,0.00,'2022-05-17 19:19:47','',''),(897,'21','224','2',1,'Sale Id shift 44',0.00,0.00,0.00,0.16,0.00,'2022-05-17 19:19:47','',''),(898,'21','224','2',1,'Sale Id shift 44',0.00,0.00,0.00,5510.56,0.00,'2022-05-17 19:19:47','',''),(899,'21','224','3',1,'Sale Id shift 44',0.00,0.00,0.00,2308.01,0.00,'2022-05-17 19:19:47','',''),(900,'21','224','3',1,'Sale Id shift 44',0.00,0.00,0.00,1608.42,0.00,'2022-05-17 19:19:47','',''),(901,'21','224','1',1,'Sale Id shift 44',0.00,0.00,0.00,5728.53,0.00,'2022-05-17 19:19:47','',''),(902,'21','224','3',1,'Sale Id shift 44',0.00,0.00,0.00,1914.54,0.00,'2022-05-17 19:19:47','',''),(903,'21','224','3',1,'Sale Id shift 44',0.00,0.00,0.00,1566.02,0.00,'2022-05-17 19:19:47','',''),(904,'21','224','4',2,'Sale Id shift 44',0.00,0.00,0.00,3109.59,0.00,'2022-05-17 19:19:47','',''),(905,'21','224','1',1,'Sale Id shift 44',0.00,0.00,0.00,7087.60,0.00,'2022-05-17 19:19:47','',''),(906,'21','224','5',2,'Sale Id shift 44',0.00,0.00,0.00,2299.97,0.00,'2022-05-17 19:19:47','',''),(907,'21','224','6',3,'Sale Id shift 44',0.00,0.00,0.00,1002.05,0.00,'2022-05-17 19:19:47','',''),(908,'21','224','2',1,'Sale Id shift 44',0.00,0.00,0.00,4727.56,0.00,'2022-05-17 19:19:47','',''),(909,'21','224','1',1,'Sale Id shift 44',0.00,0.00,0.00,4811.00,0.00,'2022-05-17 19:19:47','',''),(910,'21','224','1',1,'Sale Id shift 44',0.00,0.00,0.00,5292.25,0.00,'2022-05-17 19:19:47','',''),(911,'21','224','1',1,'Sale Id shift 44',0.00,0.00,0.00,4811.44,0.00,'2022-05-17 19:19:47','',''),(912,'21','224','1',1,'Sale Id shift 44',0.00,0.00,0.00,4212.35,0.00,'2022-05-17 19:19:47','',''),(913,'21','224','2',1,'Sale Id shift 44',0.00,0.00,0.00,6183.46,0.00,'2022-05-17 19:19:47','',''),(914,'21','224',NULL,1,'Sale Id shift 44',10901691.90,0.00,0.00,0.00,0.00,'2022-05-17 19:19:47','',''),(915,'21','224',NULL,2,'Sale Id shift 44',3786692.00,0.00,0.00,0.00,0.00,'2022-05-17 19:19:47','',''),(916,'21','224',NULL,3,'Sale Id shift 44',551127.50,0.00,0.00,0.00,0.00,'2022-05-17 19:19:47','',''),(917,'21','224','1',1,'Sale Id shift 45',0.00,0.00,0.00,4394.14,0.00,'2022-05-17 23:45:18','',''),(918,'21','224','2',1,'Sale Id shift 45',0.00,0.00,0.00,0.78,0.00,'2022-05-17 23:45:18','',''),(919,'21','224','2',1,'Sale Id shift 45',0.00,0.00,0.00,6191.53,0.00,'2022-05-17 23:45:18','',''),(920,'21','224','2',1,'Sale Id shift 45',0.00,0.00,0.00,6016.45,0.00,'2022-05-17 23:45:18','',''),(921,'21','224','1',1,'Sale Id shift 45',0.00,0.00,0.00,3874.19,0.00,'2022-05-17 23:45:18','',''),(922,'21','224','4',2,'Sale Id shift 45',0.00,0.00,0.00,3767.49,0.00,'2022-05-17 23:45:18','',''),(923,'21','224','1',1,'Sale Id shift 45',0.00,0.00,0.00,5587.94,0.00,'2022-05-17 23:45:18','',''),(924,'21','224','6',3,'Sale Id shift 45',0.00,0.00,0.00,889.01,0.00,'2022-05-17 23:45:18','',''),(925,'21','224','2',1,'Sale Id shift 45',0.00,0.00,0.00,5837.23,0.00,'2022-05-17 23:45:18','',''),(926,'21','224','1',1,'Sale Id shift 45',0.00,0.00,0.00,3841.00,0.00,'2022-05-17 23:45:18','',''),(927,'21','224','1',1,'Sale Id shift 45',0.00,0.00,0.00,3582.76,0.00,'2022-05-17 23:45:18','',''),(928,'21','224','1',1,'Sale Id shift 45',0.00,0.00,0.00,2846.94,0.00,'2022-05-17 23:45:18','',''),(929,'21','224','1',1,'Sale Id shift 45',0.00,0.00,0.00,4115.08,0.00,'2022-05-17 23:45:18','',''),(930,'21','224','2',1,'Sale Id shift 45',0.00,0.00,0.00,5893.02,0.00,'2022-05-17 23:45:18','',''),(931,'21','224',NULL,1,'Sale Id shift 45',8609874.90,0.00,0.00,0.00,0.00,'2022-05-17 23:45:18','',''),(932,'21','224',NULL,2,'Sale Id shift 45',2637243.00,0.00,0.00,0.00,0.00,'2022-05-17 23:45:18','',''),(933,'21','224',NULL,3,'Sale Id shift 45',488955.50,0.00,0.00,0.00,0.00,'2022-05-17 23:45:18','',''),(934,'21','224',NULL,1,'Reception corrector for bridging 104',0.00,0.00,0.00,39653.06,0.00,'2022-05-18 23:18:35','',''),(935,'21','224','2',1,'Received from bridging 104',0.00,0.00,39653.06,0.00,0.00,'2022-05-18 23:18:35','',''),(936,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-18 23:19:09','',''),(937,'21','224',NULL,1,'Reception corrector for bridging 106',0.00,0.00,0.00,40000.00,0.00,'2022-05-18 23:21:44','',''),(938,'21','224','1',1,'Received from bridging 106',0.00,0.00,40000.00,0.00,0.00,'2022-05-18 23:21:44','',''),(939,'21','224','1',1,'Sale Id shift 46',0.00,0.00,0.00,4027.26,0.00,'2022-05-18 23:44:12','',''),(940,'21','224','2',1,'Sale Id shift 46',0.00,0.00,0.00,7137.89,0.00,'2022-05-18 23:44:12','',''),(941,'21','224','2',1,'Sale Id shift 46',0.00,0.00,0.00,7161.24,0.00,'2022-05-18 23:44:12','',''),(942,'21','224','1',1,'Sale Id shift 46',0.00,0.00,0.00,5836.48,0.00,'2022-05-18 23:44:12','',''),(943,'21','224','4',2,'Sale Id shift 46',0.00,0.00,0.00,3150.74,0.00,'2022-05-18 23:44:12','',''),(944,'21','224','1',1,'Sale Id shift 46',0.00,0.00,0.00,6567.94,0.00,'2022-05-18 23:44:12','',''),(945,'21','224','5',2,'Sale Id shift 46',0.00,0.00,0.00,4736.36,0.00,'2022-05-18 23:44:12','',''),(946,'21','224','6',3,'Sale Id shift 46',0.00,0.00,0.00,1012.33,0.00,'2022-05-18 23:44:12','',''),(947,'21','224','2',1,'Sale Id shift 46',0.00,0.00,0.00,6290.46,0.00,'2022-05-18 23:44:12','',''),(948,'21','224','1',1,'Sale Id shift 46',0.00,0.00,0.00,5701.00,0.00,'2022-05-18 23:44:12','',''),(949,'21','224','1',1,'Sale Id shift 46',0.00,0.00,0.00,5438.97,0.00,'2022-05-18 23:44:12','',''),(950,'21','224','1',1,'Sale Id shift 46',0.00,0.00,0.00,5129.01,0.00,'2022-05-18 23:44:12','',''),(951,'21','224','1',1,'Sale Id shift 46',0.00,0.00,0.00,4699.65,0.00,'2022-05-18 23:44:12','',''),(952,'21','224','2',1,'Sale Id shift 46',0.00,0.00,0.00,8165.57,0.00,'2022-05-18 23:44:12','',''),(953,'21','224',NULL,2,'Sale Id shift 46',5520970.00,0.00,0.00,0.00,0.00,'2022-05-18 23:44:12','',''),(954,'21','224',NULL,3,'Sale Id shift 46',556781.50,0.00,0.00,0.00,0.00,'2022-05-18 23:44:12','',''),(955,'21','224',NULL,1,'Sale Id shift 46',10915652.55,0.00,0.00,0.00,0.00,'2022-05-18 23:44:12','',''),(956,'21','224','5',2,'Sale Id shift 47',0.00,0.00,0.00,10062.45,0.00,'2022-05-19 00:11:16','',''),(957,'21','224','6',3,'Sale Id shift 47',0.00,0.00,0.00,757.11,0.00,'2022-05-19 00:11:16','',''),(958,'21','224','2',1,'Sale Id shift 47',0.00,0.00,0.00,6588.29,0.00,'2022-05-19 00:11:16','',''),(959,'21','224','1',1,'Sale Id shift 47',0.00,0.00,0.00,6350.76,0.00,'2022-05-19 00:11:16','',''),(960,'21','224',NULL,2,'Sale Id shift 47',7043715.00,0.00,0.00,0.00,0.00,'2022-05-19 00:11:16','',''),(961,'21','224',NULL,3,'Sale Id shift 47',416410.50,0.00,0.00,0.00,0.00,'2022-05-19 00:11:16','',''),(962,'21','224',NULL,1,'Sale Id shift 47',2134943.25,0.00,0.00,0.00,0.00,'2022-05-19 00:11:16','',''),(963,'21','224',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,20000.00,0.00,'2022-05-19 00:33:02','',''),(964,'21','224','2',1,'Received from bridging 105',0.00,0.00,20000.00,0.00,0.00,'2022-05-19 00:33:02','',''),(965,'21','224',NULL,1,'Reception corrector for bridging 107',0.00,0.00,0.00,20000.00,0.00,'2022-05-19 00:33:38','',''),(966,'21','224','2',1,'Received from bridging 107',0.00,0.00,20000.00,0.00,0.00,'2022-05-19 00:33:38','',''),(967,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-19 00:34:51','',''),(968,'21','224',NULL,1,'Reception corrector for bridging 108',0.00,0.00,0.00,33000.00,0.00,'2022-05-19 00:36:10','',''),(969,'21','224','1',1,'Received from bridging 108',0.00,0.00,33000.00,0.00,0.00,'2022-05-19 00:36:10','',''),(970,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-19 00:37:56','',''),(971,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,21000000.00,30000.00,0.00,0.00,'2022-05-19 00:41:25','',''),(972,'21','224',NULL,2,'Reception corrector for bridging 112',0.00,0.00,0.00,16000.00,0.00,'2022-05-19 00:43:30','',''),(973,'21','224','5',2,'Received from bridging 112',0.00,0.00,16000.00,0.00,0.00,'2022-05-19 00:43:30','',''),(974,'21','224','1',1,'Returned bridging 108',0.00,0.00,0.00,33000.00,0.00,'2022-05-19 00:44:56','',''),(975,'21','224',NULL,1,'Reception Return corrector for bridging 108',0.00,0.00,33000.00,0.00,0.00,'2022-05-19 00:44:56','',''),(976,'21','224',NULL,1,'Reception corrector for bridging 110',0.00,0.00,0.00,40000.00,0.00,'2022-05-19 00:45:18','',''),(977,'21','224','1',1,'Received from bridging 110',0.00,0.00,40000.00,0.00,0.00,'2022-05-19 00:45:18','',''),(978,'21','224',NULL,2,'Reception corrector for bridging 113',0.00,0.00,0.00,500.00,0.00,'2022-05-19 00:48:27','',''),(979,'21','224','5',2,'Received from bridging 113',0.00,0.00,500.00,0.00,0.00,'2022-05-19 00:48:27','',''),(980,'21','224',NULL,1,'Reception corrector for bridging 114',0.00,0.00,0.00,25000.00,0.00,'2022-05-19 00:50:02','',''),(981,'21','224','1',1,'Received from bridging 114',0.00,0.00,25000.00,0.00,0.00,'2022-05-19 00:50:02','',''),(982,'21','224','1',1,'Sale Id shift 48',0.00,0.00,0.00,11831.44,0.00,'2022-05-19 00:51:00','',''),(983,'21','224','2',1,'Sale Id shift 48',0.00,0.00,0.00,4456.82,0.00,'2022-05-19 00:51:00','',''),(984,'21','224','2',1,'Sale Id shift 48',0.00,0.00,0.00,10201.16,0.00,'2022-05-19 00:51:00','',''),(985,'21','224','2',1,'Sale Id shift 48',0.00,0.00,0.00,7384.54,0.00,'2022-05-19 00:51:00','',''),(986,'21','224','2',1,'Sale Id shift 48',0.00,0.00,0.00,8483.50,0.00,'2022-05-19 00:51:00','',''),(987,'21','224','2',1,'Sale Id shift 48',0.00,0.00,0.00,9081.37,0.00,'2022-05-19 00:51:00','',''),(988,'21','224','1',1,'Sale Id shift 48',0.00,0.00,0.00,11767.22,0.00,'2022-05-19 00:51:00','',''),(989,'21','224','4',2,'Sale Id shift 48',0.00,0.00,0.00,4500.00,0.00,'2022-05-19 00:51:00','',''),(990,'21','224','1',1,'Sale Id shift 48',0.00,0.00,0.00,17649.46,0.00,'2022-05-19 00:51:00','',''),(991,'21','224','5',2,'Sale Id shift 48',0.00,0.00,0.00,15638.19,0.00,'2022-05-19 00:51:00','',''),(992,'21','224','6',3,'Sale Id shift 48',0.00,0.00,0.00,1123.56,0.00,'2022-05-19 00:51:00','',''),(993,'21','224','2',1,'Sale Id shift 48',0.00,0.00,0.00,5984.17,0.00,'2022-05-19 00:51:00','',''),(994,'21','224','1',1,'Sale Id shift 48',0.00,0.00,0.00,10265.00,0.00,'2022-05-19 00:51:00','',''),(995,'21','224','1',1,'Sale Id shift 48',0.00,0.00,0.00,6223.95,0.00,'2022-05-19 00:51:00','',''),(996,'21','224','1',1,'Sale Id shift 48',0.00,0.00,0.00,12289.37,0.00,'2022-05-19 00:51:00','',''),(997,'21','224','1',1,'Sale Id shift 48',0.00,0.00,0.00,10156.25,0.00,'2022-05-19 00:51:00','',''),(998,'21','224','2',1,'Sale Id shift 48',0.00,0.00,0.00,7442.27,0.00,'2022-05-19 00:51:00','',''),(999,'21','224',NULL,2,'Sale Id shift 48',14096733.00,0.00,0.00,0.00,0.00,'2022-05-19 00:51:00','',''),(1000,'21','224',NULL,3,'Sale Id shift 48',617958.00,0.00,0.00,0.00,0.00,'2022-05-19 00:51:00','',''),(1001,'21','224',NULL,1,'Sale Id shift 48',21980725.80,0.00,0.00,0.00,0.00,'2022-05-19 00:51:00','',''),(1002,'21','224',NULL,1,'Reception corrector for bridging 115',0.00,0.00,0.00,8000.00,0.00,'2022-05-19 00:52:57','',''),(1003,'21','224','1',1,'Received from bridging 115',0.00,0.00,8000.00,0.00,0.00,'2022-05-19 00:52:57','',''),(1004,'21','224',NULL,1,'Reception corrector for bridging 109',0.00,0.00,0.00,17000.00,0.00,'2022-05-19 00:52:57','',''),(1005,'21','224','2',1,'Received from bridging 109',0.00,0.00,17000.00,0.00,0.00,'2022-05-19 00:52:57','',''),(1006,'21','224',NULL,1,'Reception corrector for bridging 111',0.00,0.00,0.00,20000.00,0.00,'2022-05-19 00:53:12','',''),(1007,'21','224','2',1,'Received from bridging 111',0.00,0.00,20000.00,0.00,0.00,'2022-05-19 00:53:12','',''),(1008,'21','224',NULL,2,'Reception corrector for bridging 117',0.00,0.00,0.00,13500.00,0.00,'2022-05-19 01:25:29','',''),(1009,'21','224','5',2,'Received from bridging 117',0.00,0.00,13500.00,0.00,0.00,'2022-05-19 01:25:29','',''),(1010,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 01:27:27','',''),(1011,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-19 01:29:36','',''),(1012,'21','224',NULL,1,'Reception corrector for bridging 121',0.00,0.00,0.00,20000.00,0.00,'2022-05-19 01:31:05','',''),(1013,'21','224','2',1,'Received from bridging 121',0.00,0.00,20000.00,0.00,0.00,'2022-05-19 01:31:05','',''),(1014,'21','224',NULL,1,'Reception corrector for bridging 120',0.00,0.00,0.00,40000.00,0.00,'2022-05-19 01:31:05','',''),(1015,'21','224','1',1,'Received from bridging 120',0.00,0.00,40000.00,0.00,0.00,'2022-05-19 01:31:05','',''),(1016,'21','224',NULL,1,'Reception corrector for bridging 118',0.00,0.00,0.00,15000.00,0.00,'2022-05-19 01:31:17','',''),(1017,'21','224','1',1,'Received from bridging 118',0.00,0.00,15000.00,0.00,0.00,'2022-05-19 01:31:17','',''),(1018,'21','224','1',1,'Sale Id shift 49',0.00,0.00,0.00,4117.13,0.00,'2022-05-19 02:00:15','',''),(1019,'21','224','2',1,'Sale Id shift 49',0.00,0.00,0.00,1625.26,0.00,'2022-05-19 02:00:15','',''),(1020,'21','224','2',1,'Sale Id shift 49',0.00,0.00,0.00,1415.61,0.00,'2022-05-19 02:00:15','',''),(1021,'21','224','2',1,'Sale Id shift 49',0.00,0.00,0.00,1627.19,0.00,'2022-05-19 02:00:15','',''),(1022,'21','224','2',1,'Sale Id shift 49',0.00,0.00,0.00,1572.54,0.00,'2022-05-19 02:00:15','',''),(1023,'21','224','2',1,'Sale Id shift 49',0.00,0.00,0.00,1622.19,0.00,'2022-05-19 02:00:15','',''),(1024,'21','224','1',1,'Sale Id shift 49',0.00,0.00,0.00,4107.74,0.00,'2022-05-19 02:00:15','',''),(1025,'21','224','4',2,'Sale Id shift 49',0.00,0.00,0.00,257.01,0.00,'2022-05-19 02:00:15','',''),(1026,'21','224','1',1,'Sale Id shift 49',0.00,0.00,0.00,6022.33,0.00,'2022-05-19 02:00:15','',''),(1027,'21','224','6',3,'Sale Id shift 49',0.00,0.00,0.00,2225.23,0.00,'2022-05-19 02:00:15','',''),(1028,'21','224','2',1,'Sale Id shift 49',0.00,0.00,0.00,1431.23,0.00,'2022-05-19 02:00:15','',''),(1029,'21','224','1',1,'Sale Id shift 49',0.00,0.00,0.00,4460.00,0.00,'2022-05-19 02:00:15','',''),(1030,'21','224','1',1,'Sale Id shift 49',0.00,0.00,0.00,3178.04,0.00,'2022-05-19 02:00:15','',''),(1031,'21','224','1',1,'Sale Id shift 49',0.00,0.00,0.00,3692.53,0.00,'2022-05-19 02:00:15','',''),(1032,'21','224','1',1,'Sale Id shift 49',0.00,0.00,0.00,4041.25,0.00,'2022-05-19 02:00:15','',''),(1033,'21','224','2',1,'Sale Id shift 49',0.00,0.00,0.00,1698.70,0.00,'2022-05-19 02:00:15','',''),(1034,'21','224',NULL,2,'Sale Id shift 49',179907.00,0.00,0.00,0.00,0.00,'2022-05-19 02:00:15','',''),(1035,'21','224',NULL,3,'Sale Id shift 49',1223876.50,0.00,0.00,0.00,0.00,'2022-05-19 02:00:15','',''),(1036,'21','224',NULL,1,'Sale Id shift 49',6700937.10,0.00,0.00,0.00,0.00,'2022-05-19 02:00:15','',''),(1037,'21','224',NULL,1,'Reception corrector for bridging 122',0.00,0.00,0.00,15000.00,0.00,'2022-05-19 02:22:08','',''),(1038,'21','224','3',1,'Received from bridging 122',0.00,0.00,15000.00,0.00,0.00,'2022-05-19 02:22:08','',''),(1039,'21','224','1',1,'Sale Id shift 50',0.00,0.00,0.00,3616.68,0.00,'2022-05-19 02:35:01','',''),(1040,'21','224','2',1,'Sale Id shift 50',0.00,0.00,0.00,3890.00,0.00,'2022-05-19 02:35:01','',''),(1041,'21','224','2',1,'Sale Id shift 50',0.00,0.00,0.00,4015.89,0.00,'2022-05-19 02:35:01','',''),(1042,'21','224','2',1,'Sale Id shift 50',0.00,0.00,0.00,3614.03,0.00,'2022-05-19 02:35:01','',''),(1043,'21','224','2',1,'Sale Id shift 50',0.00,0.00,0.00,2944.09,0.00,'2022-05-19 02:35:01','',''),(1044,'21','224','2',1,'Sale Id shift 50',0.00,0.00,0.00,32718.92,0.00,'2022-05-19 02:35:01','',''),(1045,'21','224','3',1,'Sale Id shift 50',0.00,0.00,0.00,1594.23,0.00,'2022-05-19 02:35:01','',''),(1046,'21','224','3',1,'Sale Id shift 50',0.00,0.00,0.00,1411.71,0.00,'2022-05-19 02:35:01','',''),(1047,'21','224','1',1,'Sale Id shift 50',0.00,0.00,0.00,5449.01,0.00,'2022-05-19 02:35:01','',''),(1048,'21','224','3',1,'Sale Id shift 50',0.00,0.00,0.00,1904.37,0.00,'2022-05-19 02:35:01','',''),(1049,'21','224','3',1,'Sale Id shift 50',0.00,0.00,0.00,2548.09,0.00,'2022-05-19 02:35:01','',''),(1050,'21','224','1',1,'Sale Id shift 50',0.00,0.00,0.00,4528.85,0.00,'2022-05-19 02:35:01','',''),(1051,'21','224','5',2,'Sale Id shift 50',0.00,0.00,0.00,5911.82,0.00,'2022-05-19 02:35:01','',''),(1052,'21','224','6',3,'Sale Id shift 50',0.00,0.00,0.00,1174.88,0.00,'2022-05-19 02:35:01','',''),(1053,'21','224','2',1,'Sale Id shift 50',0.00,0.00,0.00,0.96,0.00,'2022-05-19 02:35:01','',''),(1054,'21','224','2',1,'Sale Id shift 50',0.00,0.00,0.00,3796.40,0.00,'2022-05-19 02:35:01','',''),(1055,'21','224','1',1,'Sale Id shift 50',0.00,0.00,0.00,0.04,0.00,'2022-05-19 02:35:01','',''),(1056,'21','224','1',1,'Sale Id shift 50',0.00,0.00,0.00,3945.00,0.00,'2022-05-19 02:35:01','',''),(1057,'21','224','1',1,'Sale Id shift 50',0.00,0.00,0.00,3654.28,0.00,'2022-05-19 02:35:01','',''),(1058,'21','224','1',1,'Sale Id shift 50',0.00,0.00,0.00,1243.39,0.00,'2022-05-19 02:35:01','',''),(1059,'21','224','1',1,'Sale Id shift 50',0.00,0.00,0.00,4234.25,0.00,'2022-05-19 02:35:01','',''),(1060,'21','224','2',1,'Sale Id shift 50',0.00,0.00,0.00,3622.75,0.00,'2022-05-19 02:35:01','',''),(1061,'21','224',NULL,2,'Sale Id shift 50',4138274.00,0.00,0.00,0.00,0.00,'2022-05-19 02:35:01','',''),(1062,'21','224',NULL,3,'Sale Id shift 50',646184.00,0.00,0.00,0.00,0.00,'2022-05-19 02:35:01','',''),(1063,'21','224',NULL,1,'Sale Id shift 50',14640935.10,0.00,0.00,0.00,0.00,'2022-05-19 02:35:01','',''),(1064,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-21 01:04:59','',''),(1065,'21','224',NULL,1,'Reception corrector for bridging 125',0.00,0.00,0.00,15000.00,0.00,'2022-05-21 15:17:48','',''),(1066,'21','224','2',1,'Received from bridging 125',0.00,0.00,15000.00,0.00,0.00,'2022-05-21 15:17:48','',''),(1067,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-21 15:18:21','',''),(1068,'21','224',NULL,1,'Reception corrector for bridging 124',0.00,0.00,0.00,13000.00,0.00,'2022-05-21 15:21:58','',''),(1069,'21','224','2',1,'Received from bridging 124',0.00,0.00,13000.00,0.00,0.00,'2022-05-21 15:21:58','',''),(1070,'21','224',NULL,1,'Reception corrector for bridging 123',0.00,0.00,0.00,27000.00,0.00,'2022-05-21 15:21:58','',''),(1071,'21','224','3',1,'Received from bridging 123',0.00,0.00,27000.00,0.00,0.00,'2022-05-21 15:21:58','',''),(1072,'21','224',NULL,1,'Reception corrector for bridging 127',0.00,0.00,0.00,15000.00,0.00,'2022-05-21 15:22:30','',''),(1073,'21','224','2',1,'Received from bridging 127',0.00,0.00,15000.00,0.00,0.00,'2022-05-21 15:22:30','',''),(1074,'21','224',NULL,1,'Reception corrector for bridging 126',0.00,0.00,0.00,30000.00,0.00,'2022-05-21 15:22:30','',''),(1075,'21','224','1',1,'Received from bridging 126',0.00,0.00,30000.00,0.00,0.00,'2022-05-21 15:22:30','',''),(1076,'21','224','1',1,'Sale Id shift 51',0.00,0.00,0.00,1737.06,0.00,'2022-05-21 16:39:36','',''),(1077,'21','224','2',1,'Sale Id shift 51',0.00,0.00,0.00,2753.67,0.00,'2022-05-21 16:39:36','',''),(1078,'21','224','2',1,'Sale Id shift 51',0.00,0.00,0.00,2884.42,0.00,'2022-05-21 16:39:36','',''),(1079,'21','224','2',1,'Sale Id shift 51',0.00,0.00,0.00,2951.39,0.00,'2022-05-21 16:39:36','',''),(1080,'21','224','2',1,'Sale Id shift 51',0.00,0.00,0.00,1634.64,0.00,'2022-05-21 16:39:36','',''),(1081,'21','224','3',1,'Sale Id shift 51',0.00,0.00,0.00,2311.86,0.00,'2022-05-21 16:39:36','',''),(1082,'21','224','3',1,'Sale Id shift 51',0.00,0.00,0.00,2025.70,0.00,'2022-05-21 16:39:36','',''),(1083,'21','224','1',1,'Sale Id shift 51',0.00,0.00,0.00,1673.76,0.00,'2022-05-21 16:39:36','',''),(1084,'21','224','3',1,'Sale Id shift 51',0.00,0.00,0.00,1394.38,0.00,'2022-05-21 16:39:36','',''),(1085,'21','224','3',1,'Sale Id shift 51',0.00,0.00,0.00,1834.17,0.00,'2022-05-21 16:39:36','',''),(1086,'21','224','1',1,'Sale Id shift 51',0.00,0.00,0.00,1451.81,0.00,'2022-05-21 16:39:36','',''),(1087,'21','224','5',2,'Sale Id shift 51',0.00,0.00,0.00,5264.81,0.00,'2022-05-21 16:39:36','',''),(1088,'21','224','6',3,'Sale Id shift 51',0.00,0.00,0.00,1675.35,0.00,'2022-05-21 16:39:36','',''),(1089,'21','224','2',1,'Sale Id shift 51',0.00,0.00,0.00,1945.21,0.00,'2022-05-21 16:39:36','',''),(1090,'21','224','1',1,'Sale Id shift 51',0.00,0.00,0.00,455.00,0.00,'2022-05-21 16:39:36','',''),(1091,'21','224','1',1,'Sale Id shift 51',0.00,0.00,0.00,2039.84,0.00,'2022-05-21 16:39:36','',''),(1092,'21','224','1',1,'Sale Id shift 51',0.00,0.00,0.00,1634.97,0.00,'2022-05-21 16:39:36','',''),(1093,'21','224','1',1,'Sale Id shift 51',0.00,0.00,0.00,1043.05,0.00,'2022-05-21 16:39:36','',''),(1094,'21','224','2',1,'Sale Id shift 51',0.00,0.00,0.00,2896.98,0.00,'2022-05-21 16:39:36','',''),(1095,'21','224',NULL,1,'Sale Id shift 51',5390205.15,0.00,0.00,0.00,0.00,'2022-05-21 16:39:36','',''),(1096,'21','224',NULL,2,'Sale Id shift 51',3685367.00,0.00,0.00,0.00,0.00,'2022-05-21 16:39:36','',''),(1097,'21','224',NULL,3,'Sale Id shift 51',921442.50,0.00,0.00,0.00,0.00,'2022-05-21 16:39:36','',''),(1098,'21','224','1',1,'Sale Id shift 52',0.00,0.00,0.00,4458.63,0.00,'2022-05-21 17:11:11','',''),(1099,'21','224','2',1,'Sale Id shift 52',0.00,0.00,0.00,4691.32,0.00,'2022-05-21 17:11:11','',''),(1100,'21','224','2',1,'Sale Id shift 52',0.00,0.00,0.00,4054.15,0.00,'2022-05-21 17:11:11','',''),(1101,'21','224','2',1,'Sale Id shift 52',0.00,0.00,0.00,4695.62,0.00,'2022-05-21 17:11:11','',''),(1102,'21','224','2',1,'Sale Id shift 52',0.00,0.00,0.00,4193.71,0.00,'2022-05-21 17:11:11','',''),(1103,'21','224','3',1,'Sale Id shift 52',0.00,0.00,0.00,1047.28,0.00,'2022-05-21 17:11:11','',''),(1104,'21','224','3',1,'Sale Id shift 52',0.00,0.00,0.00,1085.85,0.00,'2022-05-21 17:11:11','',''),(1105,'21','224','1',1,'Sale Id shift 52',0.00,0.00,0.00,4514.98,0.00,'2022-05-21 17:11:11','',''),(1106,'21','224','3',1,'Sale Id shift 52',0.00,0.00,0.00,1431.80,0.00,'2022-05-21 17:11:11','',''),(1107,'21','224','3',1,'Sale Id shift 52',0.00,0.00,0.00,1183.59,0.00,'2022-05-21 17:11:11','',''),(1108,'21','224','1',1,'Sale Id shift 52',0.00,0.00,0.00,5477.52,0.00,'2022-05-21 17:11:11','',''),(1109,'21','224','5',2,'Sale Id shift 52',0.00,0.00,0.00,2413.75,0.00,'2022-05-21 17:11:11','',''),(1110,'21','224','6',3,'Sale Id shift 52',0.00,0.00,0.00,1372.15,0.00,'2022-05-21 17:11:11','',''),(1111,'21','224','2',1,'Sale Id shift 52',0.00,0.00,0.00,3264.39,0.00,'2022-05-21 17:11:11','',''),(1112,'21','224','1',1,'Sale Id shift 52',0.00,0.00,0.00,2676.00,0.00,'2022-05-21 17:11:11','',''),(1113,'21','224','1',1,'Sale Id shift 52',0.00,0.00,0.00,5022.21,0.00,'2022-05-21 17:11:11','',''),(1114,'21','224','1',1,'Sale Id shift 52',0.00,0.00,0.00,5161.25,0.00,'2022-05-21 17:11:11','',''),(1115,'21','224','1',1,'Sale Id shift 52',0.00,0.00,0.00,4082.01,0.00,'2022-05-21 17:11:11','',''),(1116,'21','224','2',1,'Sale Id shift 52',0.00,0.00,0.00,4668.49,0.00,'2022-05-21 17:11:11','',''),(1117,'21','224',NULL,1,'Sale Id shift 52',10181952.00,0.00,0.00,0.00,0.00,'2022-05-21 17:11:11','',''),(1118,'21','224',NULL,2,'Sale Id shift 52',1689625.00,0.00,0.00,0.00,0.00,'2022-05-21 17:11:11','',''),(1119,'21','224',NULL,3,'Sale Id shift 52',754682.50,0.00,0.00,0.00,0.00,'2022-05-21 17:11:11','',''),(1120,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,10500000.00,15000.00,0.00,0.00,'2022-05-21 17:14:01','',''),(1121,'21','224',NULL,2,'Reception corrector for bridging 128',0.00,0.00,0.00,15000.00,0.00,'2022-05-21 17:14:59','',''),(1122,'21','224','5',2,'Received from bridging 128',0.00,0.00,15000.00,0.00,0.00,'2022-05-21 17:14:59','',''),(1123,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-21 17:16:44','',''),(1124,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-21 17:17:52','',''),(1125,'21','224',NULL,1,'Reception corrector for bridging 129',0.00,0.00,0.00,45000.00,0.00,'2022-05-21 17:18:39','',''),(1126,'21','224','1',1,'Received from bridging 129',0.00,0.00,45000.00,0.00,0.00,'2022-05-21 17:18:39','',''),(1127,'21','224',NULL,1,'Reception corrector for bridging 130',0.00,0.00,0.00,45000.00,0.00,'2022-05-21 17:18:48','',''),(1128,'21','224','2',1,'Received from bridging 130',0.00,0.00,45000.00,0.00,0.00,'2022-05-21 17:18:48','',''),(1129,'21','224','1',1,'Sale Id shift 53',0.00,0.00,0.00,3247.44,0.00,'2022-05-21 17:43:13','',''),(1130,'21','224','2',1,'Sale Id shift 53',0.00,0.00,0.00,3121.88,0.00,'2022-05-21 17:43:13','',''),(1131,'21','224','2',1,'Sale Id shift 53',0.00,0.00,0.00,2422.59,0.00,'2022-05-21 17:43:13','',''),(1132,'21','224','2',1,'Sale Id shift 53',0.00,0.00,0.00,2200.39,0.00,'2022-05-21 17:43:13','',''),(1133,'21','224','2',1,'Sale Id shift 53',0.00,0.00,0.00,1708.82,0.00,'2022-05-21 17:43:13','',''),(1134,'21','224','3',1,'Sale Id shift 53',0.00,0.00,0.00,1360.66,0.00,'2022-05-21 17:43:13','',''),(1135,'21','224','3',1,'Sale Id shift 53',0.00,0.00,0.00,3006.67,0.00,'2022-05-21 17:43:13','',''),(1136,'21','224','1',1,'Sale Id shift 53',0.00,0.00,0.00,4211.29,0.00,'2022-05-21 17:43:13','',''),(1137,'21','224','3',1,'Sale Id shift 53',0.00,0.00,0.00,2365.94,0.00,'2022-05-21 17:43:13','',''),(1138,'21','224','3',1,'Sale Id shift 53',0.00,0.00,0.00,3208.49,0.00,'2022-05-21 17:43:13','',''),(1139,'21','224','1',1,'Sale Id shift 53',0.00,0.00,0.00,5999.09,0.00,'2022-05-21 17:43:13','',''),(1140,'21','224','5',2,'Sale Id shift 53',0.00,0.00,0.00,2920.59,0.00,'2022-05-21 17:43:13','',''),(1141,'21','224','6',3,'Sale Id shift 53',0.00,0.00,0.00,1267.20,0.00,'2022-05-21 17:43:13','',''),(1142,'21','224','2',1,'Sale Id shift 53',0.00,0.00,0.00,2258.04,0.00,'2022-05-21 17:43:13','',''),(1143,'21','224','1',1,'Sale Id shift 53',0.00,0.00,0.00,0.66,0.00,'2022-05-21 17:43:13','',''),(1144,'21','224','1',1,'Sale Id shift 53',0.00,0.00,0.00,3976.00,0.00,'2022-05-21 17:43:13','',''),(1145,'21','224','1',1,'Sale Id shift 53',0.00,0.00,0.00,4111.37,0.00,'2022-05-21 17:43:13','',''),(1146,'21','224','1',1,'Sale Id shift 53',0.00,0.00,0.00,4531.19,0.00,'2022-05-21 17:43:13','',''),(1147,'21','224','1',1,'Sale Id shift 53',0.00,0.00,0.00,3839.49,0.00,'2022-05-21 17:43:13','',''),(1148,'21','224','2',1,'Sale Id shift 53',0.00,0.00,0.00,1591.58,0.00,'2022-05-21 17:43:13','',''),(1149,'21','224',NULL,1,'Sale Id shift 53',8771662.35,0.00,0.00,0.00,0.00,'2022-05-21 17:43:13','',''),(1150,'21','224',NULL,2,'Sale Id shift 53',2044413.00,0.00,0.00,0.00,0.00,'2022-05-21 17:43:13','',''),(1151,'21','224',NULL,3,'Sale Id shift 53',696960.00,0.00,0.00,0.00,0.00,'2022-05-21 17:43:13','',''),(1152,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-21 18:08:15','',''),(1153,'21','224',NULL,1,'Reception corrector for bridging 132',0.00,0.00,0.00,33500.00,0.00,'2022-05-21 18:10:57','',''),(1154,'21','224','2',1,'Received from bridging 132',0.00,0.00,33500.00,0.00,0.00,'2022-05-21 18:10:57','',''),(1155,'21','224',NULL,1,'Reception corrector for bridging 131',0.00,0.00,0.00,16500.00,0.00,'2022-05-21 18:10:57','',''),(1156,'21','224','1',1,'Received from bridging 131',0.00,0.00,16500.00,0.00,0.00,'2022-05-21 18:10:57','',''),(1157,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-21 18:11:56','',''),(1158,'21','224',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,139.03,0.00,'2022-05-21 18:15:46','',''),(1159,'21','224','3',1,'Received from bridging 133',0.00,0.00,139.03,0.00,0.00,'2022-05-21 18:15:46','',''),(1160,'21','224',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,0.70,0.00,'2022-05-21 18:17:25','',''),(1161,'21','224','3',1,'Received from bridging 134',0.00,0.00,0.70,0.00,0.00,'2022-05-21 18:17:25','',''),(1162,'21','224','1',1,'Sale Id shift 54',0.00,0.00,0.00,2112.54,0.00,'2022-05-21 18:29:59','',''),(1163,'21','224','2',1,'Sale Id shift 54',0.00,0.00,0.00,2003.34,0.00,'2022-05-21 18:29:59','',''),(1164,'21','224','2',1,'Sale Id shift 54',0.00,0.00,0.00,1382.26,0.00,'2022-05-21 18:29:59','',''),(1165,'21','224','2',1,'Sale Id shift 54',0.00,0.00,0.00,908.72,0.00,'2022-05-21 18:29:59','',''),(1166,'21','224','2',1,'Sale Id shift 54',0.00,0.00,0.00,954.63,0.00,'2022-05-21 18:29:59','',''),(1167,'21','224','3',1,'Sale Id shift 54',0.00,0.00,0.00,2673.33,0.00,'2022-05-21 18:29:59','',''),(1168,'21','224','3',1,'Sale Id shift 54',0.00,0.00,0.00,3281.10,0.00,'2022-05-21 18:29:59','',''),(1169,'21','224','1',1,'Sale Id shift 54',0.00,0.00,0.00,2117.33,0.00,'2022-05-21 18:29:59','',''),(1170,'21','224','3',1,'Sale Id shift 54',0.00,0.00,0.00,3164.75,0.00,'2022-05-21 18:29:59','',''),(1171,'21','224','3',1,'Sale Id shift 54',0.00,0.00,0.00,3354.85,0.00,'2022-05-21 18:29:59','',''),(1172,'21','224','1',1,'Sale Id shift 54',0.00,0.00,0.00,2025.96,0.00,'2022-05-21 18:29:59','',''),(1173,'21','224','5',2,'Sale Id shift 54',0.00,0.00,0.00,4516.88,0.00,'2022-05-21 18:29:59','',''),(1174,'21','224','6',3,'Sale Id shift 54',0.00,0.00,0.00,2103.69,0.00,'2022-05-21 18:29:59','',''),(1175,'21','224','2',1,'Sale Id shift 54',0.00,0.00,0.00,1120.11,0.00,'2022-05-21 18:29:59','',''),(1176,'21','224','1',1,'Sale Id shift 54',0.00,0.00,0.00,2099.00,0.00,'2022-05-21 18:29:59','',''),(1177,'21','224','1',1,'Sale Id shift 54',0.00,0.00,0.00,2384.90,0.00,'2022-05-21 18:29:59','',''),(1178,'21','224','1',1,'Sale Id shift 54',0.00,0.00,0.00,2286.57,0.00,'2022-05-21 18:29:59','',''),(1179,'21','224','1',1,'Sale Id shift 54',0.00,0.00,0.00,2063.78,0.00,'2022-05-21 18:29:59','',''),(1180,'21','224','2',1,'Sale Id shift 54',0.00,0.00,0.00,1909.12,0.00,'2022-05-21 18:29:59','',''),(1181,'21','224',NULL,1,'Sale Id shift 54',5913977.85,0.00,0.00,0.00,0.00,'2022-05-21 18:29:59','',''),(1182,'21','224',NULL,2,'Sale Id shift 54',3161816.00,0.00,0.00,0.00,0.00,'2022-05-21 18:29:59','',''),(1183,'21','224',NULL,3,'Sale Id shift 54',1157029.50,0.00,0.00,0.00,0.00,'2022-05-21 18:29:59','',''),(1184,'21','224',NULL,1,'Reception corrector for bridging 135',0.00,0.00,0.00,20000.00,0.00,'2022-05-21 18:35:19','',''),(1185,'21','224','1',1,'Received from bridging 135',0.00,0.00,20000.00,0.00,0.00,'2022-05-21 18:35:19','',''),(1186,'21','224',NULL,1,'Reception corrector for bridging 136',0.00,0.00,0.00,29860.27,0.00,'2022-05-21 21:00:35','',''),(1187,'21','224','3',1,'Received from bridging 136',0.00,0.00,29860.27,0.00,0.00,'2022-05-21 21:00:35','',''),(1188,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-21 21:00:59','',''),(1189,'21','224','1',1,'Sale Id shift 55',0.00,0.00,0.00,3808.54,0.00,'2022-05-21 21:16:43','',''),(1190,'21','224','2',1,'Sale Id shift 55',0.00,0.00,0.00,3564.34,0.00,'2022-05-21 21:16:43','',''),(1191,'21','224','2',1,'Sale Id shift 55',0.00,0.00,0.00,4832.46,0.00,'2022-05-21 21:16:43','',''),(1192,'21','224','2',1,'Sale Id shift 55',0.00,0.00,0.00,3302.13,0.00,'2022-05-21 21:16:43','',''),(1193,'21','224','2',1,'Sale Id shift 55',0.00,0.00,0.00,3455.91,0.00,'2022-05-21 21:16:43','',''),(1194,'21','224','3',1,'Sale Id shift 55',0.00,0.00,0.00,2014.32,0.00,'2022-05-21 21:16:43','',''),(1195,'21','224','3',1,'Sale Id shift 55',0.00,0.00,0.00,2939.32,0.00,'2022-05-21 21:16:43','',''),(1196,'21','224','1',1,'Sale Id shift 55',0.00,0.00,0.00,5359.25,0.00,'2022-05-21 21:16:43','',''),(1197,'21','224','3',1,'Sale Id shift 55',0.00,0.00,0.00,2282.70,0.00,'2022-05-21 21:16:43','',''),(1198,'21','224','3',1,'Sale Id shift 55',0.00,0.00,0.00,2479.94,0.00,'2022-05-21 21:16:43','',''),(1199,'21','224','1',1,'Sale Id shift 55',0.00,0.00,0.00,6130.54,0.00,'2022-05-21 21:16:43','',''),(1200,'21','224','5',2,'Sale Id shift 55',0.00,0.00,0.00,3251.51,0.00,'2022-05-21 21:16:43','',''),(1201,'21','224','6',3,'Sale Id shift 55',0.00,0.00,0.00,2239.72,0.00,'2022-05-21 21:16:43','',''),(1202,'21','224','2',1,'Sale Id shift 55',0.00,0.00,0.00,4853.45,0.00,'2022-05-21 21:16:43','',''),(1203,'21','224','1',1,'Sale Id shift 55',0.00,0.00,0.00,3757.00,0.00,'2022-05-21 21:16:43','',''),(1204,'21','224','1',1,'Sale Id shift 55',0.00,0.00,0.00,3755.68,0.00,'2022-05-21 21:16:43','',''),(1205,'21','224','1',1,'Sale Id shift 55',0.00,0.00,0.00,4560.98,0.00,'2022-05-21 21:16:43','',''),(1206,'21','224','1',1,'Sale Id shift 55',0.00,0.00,0.00,2632.14,0.00,'2022-05-21 21:16:43','',''),(1207,'21','224','2',1,'Sale Id shift 55',0.00,0.00,0.00,3233.07,0.00,'2022-05-21 21:16:43','',''),(1208,'21','224',NULL,1,'Sale Id shift 55',10388692.05,0.00,0.00,0.00,0.00,'2022-05-21 21:16:44','',''),(1209,'21','224',NULL,2,'Sale Id shift 55',2276057.00,0.00,0.00,0.00,0.00,'2022-05-21 21:16:44','',''),(1210,'21','224',NULL,3,'Sale Id shift 55',1231846.00,0.00,0.00,0.00,0.00,'2022-05-21 21:16:44','',''),(1211,'21','224',NULL,1,'Reception corrector for bridging 138',0.00,0.00,0.00,30500.00,0.00,'2022-05-21 21:28:17','',''),(1212,'21','224','1',1,'Received from bridging 138',0.00,0.00,30500.00,0.00,0.00,'2022-05-21 21:28:17','',''),(1213,'21','224',NULL,1,'Reception corrector for bridging 137',0.00,0.00,0.00,3406.01,0.00,'2022-05-21 21:28:28','',''),(1214,'21','224','3',1,'Received from bridging 137',0.00,0.00,3406.01,0.00,0.00,'2022-05-21 21:28:28','',''),(1215,'21','224','1',1,'Sale Id shift 56',0.00,0.00,0.00,6489.76,0.00,'2022-05-21 21:51:47','',''),(1216,'21','224','2',1,'Sale Id shift 56',0.00,0.00,0.00,6248.57,0.00,'2022-05-21 21:51:47','',''),(1217,'21','224','2',1,'Sale Id shift 56',0.00,0.00,0.00,8135.20,0.00,'2022-05-21 21:51:47','',''),(1218,'21','224','3',1,'Sale Id shift 56',0.00,0.00,0.00,5014.40,0.00,'2022-05-21 21:51:47','',''),(1219,'21','224','3',1,'Sale Id shift 56',0.00,0.00,0.00,7055.14,0.00,'2022-05-21 21:51:47','',''),(1220,'21','224','1',1,'Sale Id shift 56',0.00,0.00,0.00,0.51,0.00,'2022-05-21 21:51:47','',''),(1221,'21','224','3',1,'Sale Id shift 56',0.00,0.00,0.00,4431.50,0.00,'2022-05-21 21:51:47','',''),(1222,'21','224','3',1,'Sale Id shift 56',0.00,0.00,0.00,6064.04,0.00,'2022-05-21 21:51:47','',''),(1223,'21','224','1',1,'Sale Id shift 56',0.00,0.00,0.00,5424.52,0.00,'2022-05-21 21:51:47','',''),(1224,'21','224','5',2,'Sale Id shift 56',0.00,0.00,0.00,4397.19,0.00,'2022-05-21 21:51:47','',''),(1225,'21','224','6',3,'Sale Id shift 56',0.00,0.00,0.00,1972.78,0.00,'2022-05-21 21:51:47','',''),(1226,'21','224','2',1,'Sale Id shift 56',0.00,0.00,0.00,5884.26,0.00,'2022-05-21 21:51:47','',''),(1227,'21','224','1',1,'Sale Id shift 56',0.00,0.00,0.00,0.63,0.00,'2022-05-21 21:51:47','',''),(1228,'21','224','1',1,'Sale Id shift 56',0.00,0.00,0.00,4376.00,0.00,'2022-05-21 21:51:47','',''),(1229,'21','224','1',1,'Sale Id shift 56',0.00,0.00,0.00,5262.55,0.00,'2022-05-21 21:51:47','',''),(1230,'21','224','1',1,'Sale Id shift 56',0.00,0.00,0.00,6040.00,0.00,'2022-05-21 21:51:47','',''),(1231,'21','224','1',1,'Sale Id shift 56',0.00,0.00,0.00,0.72,0.00,'2022-05-21 21:51:47','',''),(1232,'21','224','2',1,'Sale Id shift 56',0.00,0.00,0.00,4241.24,0.00,'2022-05-21 21:51:47','',''),(1233,'21','224',NULL,2,'Sale Id shift 56',3078033.00,0.00,0.00,0.00,0.00,'2022-05-21 21:51:47','',''),(1234,'21','224',NULL,3,'Sale Id shift 56',1085029.00,0.00,0.00,0.00,0.00,'2022-05-21 21:51:47','',''),(1235,'21','224',NULL,1,'Sale Id shift 56',12320391.60,0.00,0.00,0.00,0.00,'2022-05-21 21:51:47','',''),(1236,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-22 14:52:59','',''),(1237,'21','224',NULL,1,'Reception corrector for bridging 139',0.00,0.00,0.00,44014.00,0.00,'2022-05-22 14:56:01','',''),(1238,'21','224','3',1,'Received from bridging 139',0.00,0.00,44014.00,0.00,0.00,'2022-05-22 14:56:01','',''),(1239,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-22 14:59:03','',''),(1240,'21','224',NULL,1,'Reception corrector for bridging 140',0.00,0.00,0.00,22810.00,0.00,'2022-05-22 14:59:56','',''),(1241,'21','224','2',1,'Received from bridging 140',0.00,0.00,22810.00,0.00,0.00,'2022-05-22 14:59:56','',''),(1242,'21','224',NULL,1,'Reception corrector for bridging 142',0.00,0.00,0.00,17190.00,0.00,'2022-05-22 15:03:22','',''),(1243,'21','224','1',1,'Received from bridging 142',0.00,0.00,17190.00,0.00,0.00,'2022-05-22 15:03:22','',''),(1244,'21','224',NULL,1,'Reception corrector for bridging 143',0.00,0.00,0.00,11093.99,0.00,'2022-05-22 15:05:18','',''),(1245,'21','224','1',1,'Received from bridging 143',0.00,0.00,11093.99,0.00,0.00,'2022-05-22 15:05:18','',''),(1246,'21','224',NULL,1,'Reception corrector for bridging 144',0.00,0.00,0.00,986.00,0.00,'2022-05-22 15:06:13','',''),(1247,'21','224','1',1,'Received from bridging 144',0.00,0.00,986.00,0.00,0.00,'2022-05-22 15:06:13','',''),(1248,'21','224','1',1,'Sale Id shift 57',0.00,0.00,0.00,7447.57,0.00,'2022-05-22 15:42:20','',''),(1249,'21','224','2',1,'Sale Id shift 57',0.00,0.00,0.00,8207.35,0.00,'2022-05-22 15:42:20','',''),(1250,'21','224','2',1,'Sale Id shift 57',0.00,0.00,0.00,7719.40,0.00,'2022-05-22 15:42:20','',''),(1251,'21','224','3',1,'Sale Id shift 57',0.00,0.00,0.00,3947.98,0.00,'2022-05-22 15:42:20','',''),(1252,'21','224','3',1,'Sale Id shift 57',0.00,0.00,0.00,4942.23,0.00,'2022-05-22 15:42:20','',''),(1253,'21','224','3',1,'Sale Id shift 57',0.00,0.00,0.00,2630.76,0.00,'2022-05-22 15:42:20','',''),(1254,'21','224','3',1,'Sale Id shift 57',0.00,0.00,0.00,4241.33,0.00,'2022-05-22 15:42:20','',''),(1255,'21','224','4',2,'Sale Id shift 57',0.00,0.00,0.00,5443.35,0.00,'2022-05-22 15:42:20','',''),(1256,'21','224','1',1,'Sale Id shift 57',0.00,0.00,0.00,4957.43,0.00,'2022-05-22 15:42:20','',''),(1257,'21','224','5',2,'Sale Id shift 57',0.00,0.00,0.00,1575.91,0.00,'2022-05-22 15:42:20','',''),(1258,'21','224','6',3,'Sale Id shift 57',0.00,0.00,0.00,2461.43,0.00,'2022-05-22 15:42:20','',''),(1259,'21','224','2',1,'Sale Id shift 57',0.00,0.00,0.00,6294.87,0.00,'2022-05-22 15:42:20','',''),(1260,'21','224','1',1,'Sale Id shift 57',0.00,0.00,0.00,7050.00,0.00,'2022-05-22 15:42:20','',''),(1261,'21','224','1',1,'Sale Id shift 57',0.00,0.00,0.00,2286.42,0.00,'2022-05-22 15:42:20','',''),(1262,'21','224','1',1,'Sale Id shift 57',0.00,0.00,0.00,6596.66,0.00,'2022-05-22 15:42:20','',''),(1263,'21','224','2',1,'Sale Id shift 57',0.00,0.00,0.00,110.52,0.00,'2022-05-22 15:42:20','',''),(1264,'21','224',NULL,1,'Sale Id shift 57',10961365.80,0.00,0.00,0.00,0.00,'2022-05-22 15:42:20','',''),(1265,'21','224',NULL,2,'Sale Id shift 57',4913482.00,0.00,0.00,0.00,0.00,'2022-05-22 15:42:20','',''),(1266,'21','224',NULL,3,'Sale Id shift 57',1353786.50,0.00,0.00,0.00,0.00,'2022-05-22 15:42:20','',''),(1267,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-23 14:36:40','',''),(1268,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,11725000.00,16750.00,0.00,0.00,'2022-05-23 14:40:37','',''),(1269,'21','224',NULL,2,'Reception corrector for bridging 147',0.00,0.00,0.00,16750.00,0.00,'2022-05-23 14:42:31','',''),(1270,'21','224','5',2,'Received from bridging 147',0.00,0.00,16750.00,0.00,0.00,'2022-05-23 14:42:31','',''),(1271,'21','224',NULL,1,'Reception corrector for bridging 146',0.00,0.00,0.00,15613.00,0.00,'2022-05-23 14:44:38','',''),(1272,'21','224','3',1,'Received from bridging 146',0.00,0.00,15613.00,0.00,0.00,'2022-05-23 14:44:38','',''),(1273,'21','224',NULL,1,'Reception corrector for bridging 145',0.00,0.00,0.00,1167.00,0.00,'2022-05-23 14:44:38','',''),(1274,'21','224','1',1,'Received from bridging 145',0.00,0.00,1167.00,0.00,0.00,'2022-05-23 14:44:38','',''),(1275,'21','224',NULL,1,'Reception corrector for bridging 148',0.00,0.00,0.00,16780.00,0.00,'2022-05-23 15:11:45','',''),(1276,'21','224','1',1,'Received from bridging 148',0.00,0.00,16780.00,0.00,0.00,'2022-05-23 15:11:45','',''),(1277,'21','224','1',1,'Sale Id shift 58',0.00,0.00,0.00,6425.04,0.00,'2022-05-23 15:37:25','',''),(1278,'21','224','2',1,'Sale Id shift 58',0.00,0.00,0.00,3353.67,0.00,'2022-05-23 15:37:25','',''),(1279,'21','224','2',1,'Sale Id shift 58',0.00,0.00,0.00,4822.68,0.00,'2022-05-23 15:37:25','',''),(1280,'21','224','2',1,'Sale Id shift 58',0.00,0.00,0.00,1.27,0.00,'2022-05-23 15:37:25','',''),(1281,'21','224','2',1,'Sale Id shift 58',0.00,0.00,0.00,4546.69,0.00,'2022-05-23 15:37:25','',''),(1282,'21','224','3',1,'Sale Id shift 58',0.00,0.00,0.00,7434.34,0.00,'2022-05-23 15:37:25','',''),(1283,'21','224','3',1,'Sale Id shift 58',0.00,0.00,0.00,7789.75,0.00,'2022-05-23 15:37:25','',''),(1284,'21','224','3',1,'Sale Id shift 58',0.00,0.00,0.00,6265.97,0.00,'2022-05-23 15:37:25','',''),(1285,'21','224','3',1,'Sale Id shift 58',0.00,0.00,0.00,7912.15,0.00,'2022-05-23 15:37:25','',''),(1286,'21','224','4',2,'Sale Id shift 58',0.00,0.00,0.00,5821.16,0.00,'2022-05-23 15:37:25','',''),(1287,'21','224','1',1,'Sale Id shift 58',0.00,0.00,0.00,4813.12,0.00,'2022-05-23 15:37:25','',''),(1288,'21','224','6',3,'Sale Id shift 58',0.00,0.00,0.00,1709.13,0.00,'2022-05-23 15:37:25','',''),(1289,'21','224','2',1,'Sale Id shift 58',0.00,0.00,0.00,4061.43,0.00,'2022-05-23 15:37:25','',''),(1290,'21','224','1',1,'Sale Id shift 58',0.00,0.00,0.00,0.46,0.00,'2022-05-23 15:37:25','',''),(1291,'21','224','1',1,'Sale Id shift 58',0.00,0.00,0.00,5644.00,0.00,'2022-05-23 15:37:25','',''),(1292,'21','224','1',1,'Sale Id shift 58',0.00,0.00,0.00,2167.23,0.00,'2022-05-23 15:37:25','',''),(1293,'21','224','1',1,'Sale Id shift 58',0.00,0.00,0.00,4802.25,0.00,'2022-05-23 15:37:25','',''),(1294,'21','224','2',1,'Sale Id shift 58',0.00,0.00,0.00,2594.43,0.00,'2022-05-23 15:37:25','',''),(1295,'21','224',NULL,1,'Sale Id shift 58',11984689.20,0.00,0.00,0.00,0.00,'2022-05-23 15:37:25','',''),(1296,'21','224',NULL,2,'Sale Id shift 58',4074812.00,0.00,0.00,0.00,0.00,'2022-05-23 15:37:25','',''),(1297,'21','224',NULL,3,'Sale Id shift 58',1110934.50,0.00,0.00,0.00,0.00,'2022-05-23 15:37:25','',''),(1298,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-23 15:39:49','',''),(1299,'21','224',NULL,1,'Reception corrector for bridging 149',0.00,0.00,0.00,38212.00,0.00,'2022-05-23 15:40:37','',''),(1300,'21','224','2',1,'Received from bridging 149',0.00,0.00,38212.00,0.00,0.00,'2022-05-23 15:40:37','',''),(1301,'21','224',NULL,1,'Reception corrector for bridging 150',0.00,0.00,0.00,11440.00,0.00,'2022-05-23 15:42:29','',''),(1302,'21','224','1',1,'Received from bridging 150',0.00,0.00,11440.00,0.00,0.00,'2022-05-23 15:42:29','',''),(1303,'21','224',NULL,1,'Reception corrector for bridging 151',0.00,0.00,0.00,6788.00,0.00,'2022-05-23 15:42:39','',''),(1304,'21','224','1',1,'Received from bridging 151',0.00,0.00,6788.00,0.00,0.00,'2022-05-23 15:42:39','',''),(1305,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,35000000.00,50000.00,0.00,0.00,'2022-05-23 15:46:35','',''),(1306,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-23 15:47:10','',''),(1307,'21','224',NULL,1,'Reception corrector for bridging 152',0.00,0.00,0.00,20000.00,0.00,'2022-05-23 15:47:46','',''),(1308,'21','224','1',1,'Received from bridging 152',0.00,0.00,20000.00,0.00,0.00,'2022-05-23 15:47:46','',''),(1309,'21','224',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,15000.00,0.00,'2022-05-23 16:19:24','',''),(1310,'21','224','3',1,'Received from bridging 153',0.00,0.00,15000.00,0.00,0.00,'2022-05-23 16:19:24','',''),(1311,'21','224',NULL,1,'Reception corrector for bridging 154',0.00,0.00,0.00,3000.00,0.00,'2022-05-23 16:20:37','',''),(1312,'21','224','3',1,'Received from bridging 154',0.00,0.00,3000.00,0.00,0.00,'2022-05-23 16:20:37','',''),(1313,'21','224',NULL,2,'Reception corrector for bridging 156',0.00,0.00,0.00,20000.00,0.00,'2022-05-23 16:23:34','',''),(1314,'21','224','5',2,'Received from bridging 156',0.00,0.00,20000.00,0.00,0.00,'2022-05-23 16:23:34','',''),(1315,'21','224',NULL,2,'Reception corrector for bridging 155',0.00,0.00,0.00,30000.00,0.00,'2022-05-23 16:23:34','',''),(1316,'21','224','4',2,'Received from bridging 155',0.00,0.00,30000.00,0.00,0.00,'2022-05-23 16:23:34','',''),(1317,'21','224','2',1,'Sale Id shift 59',0.00,0.00,0.00,8922.91,0.00,'2022-05-23 16:32:30','',''),(1318,'21','224','2',1,'Sale Id shift 59',0.00,0.00,0.00,8519.47,0.00,'2022-05-23 16:32:30','',''),(1319,'21','224','2',1,'Sale Id shift 59',0.00,0.00,0.00,3391.04,0.00,'2022-05-23 16:32:30','',''),(1320,'21','224','2',1,'Sale Id shift 59',0.00,0.00,0.00,9530.45,0.00,'2022-05-23 16:32:30','',''),(1321,'21','224','3',1,'Sale Id shift 59',0.00,0.00,0.00,4792.45,0.00,'2022-05-23 16:32:30','',''),(1322,'21','224','3',1,'Sale Id shift 59',0.00,0.00,0.00,5332.55,0.00,'2022-05-23 16:32:30','',''),(1323,'21','224','3',1,'Sale Id shift 59',0.00,0.00,0.00,5317.45,0.00,'2022-05-23 16:32:30','',''),(1324,'21','224','4',2,'Sale Id shift 59',0.00,0.00,0.00,4019.14,0.00,'2022-05-23 16:32:30','',''),(1325,'21','224','1',1,'Sale Id shift 59',0.00,0.00,0.00,11238.41,0.00,'2022-05-23 16:32:30','',''),(1326,'21','224','6',3,'Sale Id shift 59',0.00,0.00,0.00,1670.45,0.00,'2022-05-23 16:32:30','',''),(1327,'21','224','2',1,'Sale Id shift 59',0.00,0.00,0.00,9311.01,0.00,'2022-05-23 16:32:30','',''),(1328,'21','224','1',1,'Sale Id shift 59',0.00,0.00,0.00,0.40,0.00,'2022-05-23 16:32:30','',''),(1329,'21','224','1',1,'Sale Id shift 59',0.00,0.00,0.00,7398.00,0.00,'2022-05-23 16:32:30','',''),(1330,'21','224','1',1,'Sale Id shift 59',0.00,0.00,0.00,4218.97,0.00,'2022-05-23 16:32:30','',''),(1331,'21','224','1',1,'Sale Id shift 59',0.00,0.00,0.00,6656.36,0.00,'2022-05-23 16:32:30','',''),(1332,'21','224','1',1,'Sale Id shift 59',0.00,0.00,0.00,2893.74,0.00,'2022-05-23 16:32:30','',''),(1333,'21','224','2',1,'Sale Id shift 59',0.00,0.00,0.00,2492.82,0.00,'2022-05-23 16:32:30','',''),(1334,'21','224',NULL,2,'Sale Id shift 59',2813398.00,0.00,0.00,0.00,0.00,'2022-05-23 16:32:30','',''),(1335,'21','224',NULL,3,'Sale Id shift 59',1085792.50,0.00,0.00,0.00,0.00,'2022-05-23 16:32:30','',''),(1336,'21','224',NULL,1,'Sale Id shift 59',14852644.95,0.00,0.00,0.00,0.00,'2022-05-23 16:32:30','',''),(1337,'21','224','4',2,'Sale Id shift 60',0.00,0.00,0.00,5147.81,0.00,'2022-05-23 16:47:56','',''),(1338,'21','224','1',1,'Sale Id shift 60',0.00,0.00,0.00,2079.22,0.00,'2022-05-23 16:47:56','',''),(1339,'21','224','6',3,'Sale Id shift 60',0.00,0.00,0.00,872.07,0.00,'2022-05-23 16:47:56','',''),(1340,'21','224','1',1,'Sale Id shift 60',0.00,0.00,0.00,1185.00,0.00,'2022-05-23 16:47:56','',''),(1341,'21','224','1',1,'Sale Id shift 60',0.00,0.00,0.00,909.47,0.00,'2022-05-23 16:47:56','',''),(1342,'21','224','1',1,'Sale Id shift 60',0.00,0.00,0.00,1161.88,0.00,'2022-05-23 16:47:56','',''),(1343,'21','224','1',1,'Sale Id shift 60',0.00,0.00,0.00,1361.83,0.00,'2022-05-23 16:47:56','',''),(1344,'21','224',NULL,2,'Sale Id shift 60',3603467.00,0.00,0.00,0.00,0.00,'2022-05-23 16:47:56','',''),(1345,'21','224',NULL,3,'Sale Id shift 60',566845.50,0.00,0.00,0.00,0.00,'2022-05-23 16:47:56','',''),(1346,'21','224',NULL,1,'Sale Id shift 60',1105071.00,0.00,0.00,0.00,0.00,'2022-05-23 16:47:56','',''),(1347,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-23 18:48:33','',''),(1348,'21','224',NULL,1,'Reception corrector for bridging 157',0.00,0.00,0.00,40000.00,0.00,'2022-05-23 18:49:50','',''),(1349,'21','224','1',1,'Received from bridging 157',0.00,0.00,40000.00,0.00,0.00,'2022-05-23 18:49:50','',''),(1350,'21','224',NULL,1,'Reception corrector for bridging 158',0.00,0.00,0.00,7000.00,0.00,'2022-05-25 06:04:14','',''),(1351,'21','224','2',1,'Received from bridging 158',0.00,0.00,7000.00,0.00,0.00,'2022-05-25 06:04:14','',''),(1352,'21','224',NULL,1,'Reception corrector for bridging 159',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 06:04:25','',''),(1353,'21','224','2',1,'Received from bridging 159',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 06:04:25','',''),(1354,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 06:15:17','',''),(1355,'21','224',NULL,1,'Reception corrector for bridging 160',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 06:16:11','',''),(1356,'21','224','1',1,'Received from bridging 160',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 06:16:11','',''),(1357,'21','224','1',1,'Sale Id shift 61',0.00,0.00,0.00,10134.56,0.00,'2022-05-25 06:27:11','',''),(1358,'21','224','2',1,'Sale Id shift 61',0.00,0.00,0.00,2789.70,0.00,'2022-05-25 06:27:11','',''),(1359,'21','224','2',1,'Sale Id shift 61',0.00,0.00,0.00,2506.08,0.00,'2022-05-25 06:27:11','',''),(1360,'21','224','2',1,'Sale Id shift 61',0.00,0.00,0.00,0.06,0.00,'2022-05-25 06:27:11','',''),(1361,'21','224','2',1,'Sale Id shift 61',0.00,0.00,0.00,2030.97,0.00,'2022-05-25 06:27:11','',''),(1362,'21','224','1',1,'Sale Id shift 61',0.00,0.00,0.00,0.42,0.00,'2022-05-25 06:27:11','',''),(1363,'21','224','4',2,'Sale Id shift 61',0.00,0.00,0.00,5008.99,0.00,'2022-05-25 06:27:11','',''),(1364,'21','224','1',1,'Sale Id shift 61',0.00,0.00,0.00,11782.29,0.00,'2022-05-25 06:27:11','',''),(1365,'21','224','6',3,'Sale Id shift 61',0.00,0.00,0.00,1672.12,0.00,'2022-05-25 06:27:11','',''),(1366,'21','224','2',1,'Sale Id shift 61',0.00,0.00,0.00,2597.37,0.00,'2022-05-25 06:27:11','',''),(1367,'21','224','1',1,'Sale Id shift 61',0.00,0.00,0.00,8486.00,0.00,'2022-05-25 06:27:11','',''),(1368,'21','224','1',1,'Sale Id shift 61',0.00,0.00,0.00,8481.95,0.00,'2022-05-25 06:27:11','',''),(1369,'21','224','1',1,'Sale Id shift 61',0.00,0.00,0.00,7114.76,0.00,'2022-05-25 06:27:11','',''),(1370,'21','224','1',1,'Sale Id shift 61',0.00,0.00,0.00,9331.04,0.00,'2022-05-25 06:27:11','',''),(1371,'21','224','2',1,'Sale Id shift 61',0.00,0.00,0.00,7.93,0.00,'2022-05-25 06:27:11','',''),(1372,'21','224',NULL,2,'Sale Id shift 61',3506293.00,0.00,0.00,0.00,0.00,'2022-05-25 06:27:11','',''),(1373,'21','224',NULL,3,'Sale Id shift 61',1086878.00,0.00,0.00,0.00,0.00,'2022-05-25 06:27:11','',''),(1374,'21','224',NULL,1,'Sale Id shift 61',10768416.45,0.00,0.00,0.00,0.00,'2022-05-25 06:27:11','',''),(1375,'21','224',NULL,1,'Reception corrector for bridging 161',0.00,0.00,0.00,5200.00,0.00,'2022-05-25 06:48:22','',''),(1376,'21','224','1',1,'Received from bridging 161',0.00,0.00,5200.00,0.00,0.00,'2022-05-25 06:48:22','',''),(1377,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 06:49:36','',''),(1378,'21','224',NULL,1,'Reception corrector for bridging 162',0.00,0.00,0.00,19800.00,0.00,'2022-05-25 06:50:17','',''),(1379,'21','224','1',1,'Received from bridging 162',0.00,0.00,19800.00,0.00,0.00,'2022-05-25 06:50:17','',''),(1380,'21','224',NULL,1,'Reception corrector for bridging 163',0.00,0.00,0.00,45000.00,0.00,'2022-05-25 06:50:28','',''),(1381,'21','224','2',1,'Received from bridging 163',0.00,0.00,45000.00,0.00,0.00,'2022-05-25 06:50:28','',''),(1382,'21','224','1',1,'Sale Id shift 62',0.00,0.00,0.00,3186.14,0.00,'2022-05-25 07:00:47','',''),(1383,'21','224','2',1,'Sale Id shift 62',0.00,0.00,0.00,7040.08,0.00,'2022-05-25 07:00:47','',''),(1384,'21','224','2',1,'Sale Id shift 62',0.00,0.00,0.00,5931.88,0.00,'2022-05-25 07:00:47','',''),(1385,'21','224','2',1,'Sale Id shift 62',0.00,0.00,0.00,4938.53,0.00,'2022-05-25 07:00:47','',''),(1386,'21','224','2',1,'Sale Id shift 62',0.00,0.00,0.00,2015.77,0.00,'2022-05-25 07:00:47','',''),(1387,'21','224','2',1,'Sale Id shift 62',0.00,0.00,0.00,6415.38,0.00,'2022-05-25 07:00:47','',''),(1388,'21','224','4',2,'Sale Id shift 62',0.00,0.00,0.00,8681.99,0.00,'2022-05-25 07:00:47','',''),(1389,'21','224','1',1,'Sale Id shift 62',0.00,0.00,0.00,3585.47,0.00,'2022-05-25 07:00:47','',''),(1390,'21','224','6',3,'Sale Id shift 62',0.00,0.00,0.00,926.31,0.00,'2022-05-25 07:00:47','',''),(1391,'21','224','2',1,'Sale Id shift 62',0.00,0.00,0.00,0.72,0.00,'2022-05-25 07:00:47','',''),(1392,'21','224','2',1,'Sale Id shift 62',0.00,0.00,0.00,6463.94,0.00,'2022-05-25 07:00:47','',''),(1393,'21','224','1',1,'Sale Id shift 62',0.00,0.00,0.00,2181.00,0.00,'2022-05-25 07:00:47','',''),(1394,'21','224','1',1,'Sale Id shift 62',0.00,0.00,0.00,2811.51,0.00,'2022-05-25 07:00:47','',''),(1395,'21','224','1',1,'Sale Id shift 62',0.00,0.00,0.00,2596.35,0.00,'2022-05-25 07:00:47','',''),(1396,'21','224','1',1,'Sale Id shift 62',0.00,0.00,0.00,2333.75,0.00,'2022-05-25 07:00:47','',''),(1397,'21','224','2',1,'Sale Id shift 62',0.00,0.00,0.00,0.06,0.00,'2022-05-25 07:00:47','',''),(1398,'21','224',NULL,2,'Sale Id shift 62',6077393.00,0.00,0.00,0.00,0.00,'2022-05-25 07:00:47','',''),(1399,'21','224',NULL,3,'Sale Id shift 62',602101.50,0.00,0.00,0.00,0.00,'2022-05-25 07:00:47','',''),(1400,'21','224',NULL,1,'Sale Id shift 62',8167595.70,0.00,0.00,0.00,0.00,'2022-05-25 07:00:47','',''),(1401,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 07:04:01','',''),(1402,'21','224',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,45000.00,0.00,'2022-05-25 07:05:06','',''),(1403,'21','224','1',1,'Received from bridging 164',0.00,0.00,45000.00,0.00,0.00,'2022-05-25 07:05:06','',''),(1404,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 07:05:19','',''),(1405,'21','224',NULL,1,'Reception corrector for bridging 165',0.00,0.00,0.00,45000.00,0.00,'2022-05-25 07:07:01','',''),(1406,'21','224','2',1,'Received from bridging 165',0.00,0.00,45000.00,0.00,0.00,'2022-05-25 07:07:01','',''),(1407,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,23450000.00,33500.00,0.00,0.00,'2022-05-25 07:07:12','',''),(1408,'21','224',NULL,2,'Reception corrector for bridging 166',0.00,0.00,0.00,33500.00,0.00,'2022-05-25 07:07:53','',''),(1409,'21','224','4',2,'Received from bridging 166',0.00,0.00,33500.00,0.00,0.00,'2022-05-25 07:07:53','',''),(1410,'21','224','1',1,'Sale Id shift 63',0.00,0.00,0.00,7729.64,0.00,'2022-05-25 07:31:55','',''),(1411,'21','224','2',1,'Sale Id shift 63',0.00,0.00,0.00,6647.20,0.00,'2022-05-25 07:31:55','',''),(1412,'21','224','2',1,'Sale Id shift 63',0.00,0.00,0.00,4534.32,0.00,'2022-05-25 07:31:55','',''),(1413,'21','224','2',1,'Sale Id shift 63',0.00,0.00,0.00,5237.21,0.00,'2022-05-25 07:31:55','',''),(1414,'21','224','2',1,'Sale Id shift 63',0.00,0.00,0.00,5341.45,0.00,'2022-05-25 07:31:55','',''),(1415,'21','224','2',1,'Sale Id shift 63',0.00,0.00,0.00,4196.53,0.00,'2022-05-25 07:31:55','',''),(1416,'21','224','1',1,'Sale Id shift 63',0.00,0.00,0.00,6744.92,0.00,'2022-05-25 07:31:55','',''),(1417,'21','224','4',2,'Sale Id shift 63',0.00,0.00,0.00,6511.20,0.00,'2022-05-25 07:31:55','',''),(1418,'21','224','1',1,'Sale Id shift 63',0.00,0.00,0.00,9596.01,0.00,'2022-05-25 07:31:55','',''),(1419,'21','224','6',3,'Sale Id shift 63',0.00,0.00,0.00,974.71,0.00,'2022-05-25 07:31:55','',''),(1420,'21','224','2',1,'Sale Id shift 63',0.00,0.00,0.00,6542.83,0.00,'2022-05-25 07:31:55','',''),(1421,'21','224','1',1,'Sale Id shift 63',0.00,0.00,0.00,6399.00,0.00,'2022-05-25 07:31:55','',''),(1422,'21','224','1',1,'Sale Id shift 63',0.00,0.00,0.00,8592.31,0.00,'2022-05-25 07:31:55','',''),(1423,'21','224','1',1,'Sale Id shift 63',0.00,0.00,0.00,6034.99,0.00,'2022-05-25 07:31:55','',''),(1424,'21','224','1',1,'Sale Id shift 63',0.00,0.00,0.00,6614.08,0.00,'2022-05-25 07:31:55','',''),(1425,'21','224','2',1,'Sale Id shift 63',0.00,0.00,0.00,0.13,0.00,'2022-05-25 07:31:55','',''),(1426,'21','224',NULL,2,'Sale Id shift 63',4557840.00,0.00,0.00,0.00,0.00,'2022-05-25 07:31:55','',''),(1427,'21','224',NULL,3,'Sale Id shift 63',633561.50,0.00,0.00,0.00,0.00,'2022-05-25 07:31:55','',''),(1428,'21','224',NULL,1,'Sale Id shift 63',13894752.30,0.00,0.00,0.00,0.00,'2022-05-25 07:31:55','',''),(1429,'21','224',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,19500000.00,30000.00,0.00,0.00,'2022-05-25 07:34:43','',''),(1430,'21','224',NULL,3,'Reception corrector for bridging 167',0.00,0.00,0.00,30000.00,0.00,'2022-05-25 07:35:28','',''),(1431,'21','224','6',3,'Received from bridging 167',0.00,0.00,30000.00,0.00,0.00,'2022-05-25 07:35:28','',''),(1432,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 07:35:46','',''),(1433,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 07:36:24','',''),(1434,'21','224',NULL,1,'Reception corrector for bridging 168',0.00,0.00,0.00,45000.00,0.00,'2022-05-25 07:36:54','',''),(1435,'21','224','1',1,'Received from bridging 168',0.00,0.00,45000.00,0.00,0.00,'2022-05-25 07:36:54','',''),(1436,'21','224',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,44000.00,0.00,'2022-05-25 07:38:26','',''),(1437,'21','224','2',1,'Received from bridging 170',0.00,0.00,44000.00,0.00,0.00,'2022-05-25 07:38:26','',''),(1438,'21','224','1',1,'Sale Id shift 64',0.00,0.00,0.00,4939.45,0.00,'2022-05-25 08:18:58','',''),(1439,'21','224','2',1,'Sale Id shift 64',0.00,0.00,0.00,37.34,0.00,'2022-05-25 08:18:58','',''),(1440,'21','224','2',1,'Sale Id shift 64',0.00,0.00,0.00,9857.61,0.00,'2022-05-25 08:18:58','',''),(1441,'21','224','2',1,'Sale Id shift 64',0.00,0.00,0.00,32.56,0.00,'2022-05-25 08:18:58','',''),(1442,'21','224','2',1,'Sale Id shift 64',0.00,0.00,0.00,19.98,0.00,'2022-05-25 08:18:58','',''),(1443,'21','224','2',1,'Sale Id shift 64',0.00,0.00,0.00,8400.45,0.00,'2022-05-25 08:18:58','',''),(1444,'21','224','1',1,'Sale Id shift 64',0.00,0.00,0.00,4461.16,0.00,'2022-05-25 08:18:58','',''),(1445,'21','224','4',2,'Sale Id shift 64',0.00,0.00,0.00,8899.38,0.00,'2022-05-25 08:18:58','',''),(1446,'21','224','1',1,'Sale Id shift 64',0.00,0.00,0.00,8505.70,0.00,'2022-05-25 08:18:58','',''),(1447,'21','224','2',1,'Sale Id shift 64',0.00,0.00,0.00,10642.20,0.00,'2022-05-25 08:18:58','',''),(1448,'21','224','1',1,'Sale Id shift 64',0.00,0.00,0.00,5220.00,0.00,'2022-05-25 08:18:58','',''),(1449,'21','224','1',1,'Sale Id shift 64',0.00,0.00,0.00,6978.79,0.00,'2022-05-25 08:18:58','',''),(1450,'21','224','1',1,'Sale Id shift 64',0.00,0.00,0.00,5903.65,0.00,'2022-05-25 08:18:58','',''),(1451,'21','224','1',1,'Sale Id shift 64',0.00,0.00,0.00,5975.71,0.00,'2022-05-25 08:18:58','',''),(1452,'21','224','2',1,'Sale Id shift 64',0.00,0.00,0.00,0.14,0.00,'2022-05-25 08:18:58','',''),(1453,'21','224',NULL,2,'Sale Id shift 64',6229566.00,0.00,0.00,0.00,0.00,'2022-05-25 08:18:58','',''),(1454,'21','224',NULL,1,'Sale Id shift 64',11710832.10,0.00,0.00,0.00,0.00,'2022-05-25 08:18:58','',''),(1455,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 08:28:48','',''),(1456,'21','224',NULL,1,'Reception corrector for bridging 173',0.00,0.00,0.00,12050.00,0.00,'2022-05-25 08:30:21','',''),(1457,'21','224','3',1,'Received from bridging 173',0.00,0.00,12050.00,0.00,0.00,'2022-05-25 08:30:21','',''),(1458,'21','224',NULL,1,'Reception corrector for bridging 172',0.00,0.00,0.00,32950.00,0.00,'2022-05-25 08:30:21','',''),(1459,'21','224','1',1,'Received from bridging 172',0.00,0.00,32950.00,0.00,0.00,'2022-05-25 08:30:21','',''),(1460,'21','224','1',1,'Sale Id shift 65',0.00,0.00,0.00,6594.38,0.00,'2022-05-25 08:51:42','',''),(1461,'21','224','2',1,'Sale Id shift 65',0.00,0.00,0.00,0.28,0.00,'2022-05-25 08:51:42','',''),(1462,'21','224','2',1,'Sale Id shift 65',0.00,0.00,0.00,7898.53,0.00,'2022-05-25 08:51:42','',''),(1463,'21','224','2',1,'Sale Id shift 65',0.00,0.00,0.00,0.34,0.00,'2022-05-25 08:51:42','',''),(1464,'21','224','2',1,'Sale Id shift 65',0.00,0.00,0.00,0.09,0.00,'2022-05-25 08:51:42','',''),(1465,'21','224','2',1,'Sale Id shift 65',0.00,0.00,0.00,7010.88,0.00,'2022-05-25 08:51:42','',''),(1466,'21','224','3',1,'Sale Id shift 65',0.00,0.00,0.00,1044.85,0.00,'2022-05-25 08:51:42','',''),(1467,'21','224','3',1,'Sale Id shift 65',0.00,0.00,0.00,9710.96,0.00,'2022-05-25 08:51:42','',''),(1468,'21','224','1',1,'Sale Id shift 65',0.00,0.00,0.00,7688.37,0.00,'2022-05-25 08:51:42','',''),(1469,'21','224','3',1,'Sale Id shift 65',0.00,0.00,0.00,7966.56,0.00,'2022-05-25 08:51:42','',''),(1470,'21','224','3',1,'Sale Id shift 65',0.00,0.00,0.00,9669.65,0.00,'2022-05-25 08:51:42','',''),(1471,'21','224','4',2,'Sale Id shift 65',0.00,0.00,0.00,8359.53,0.00,'2022-05-25 08:51:42','',''),(1472,'21','224','1',1,'Sale Id shift 65',0.00,0.00,0.00,8813.58,0.00,'2022-05-25 08:51:42','',''),(1473,'21','224','6',3,'Sale Id shift 65',0.00,0.00,0.00,187.76,0.00,'2022-05-25 08:51:42','',''),(1474,'21','224','2',1,'Sale Id shift 65',0.00,0.00,0.00,7861.89,0.00,'2022-05-25 08:51:42','',''),(1475,'21','224','1',1,'Sale Id shift 65',0.00,0.00,0.00,0.60,0.00,'2022-05-25 08:51:42','',''),(1476,'21','224','1',1,'Sale Id shift 65',0.00,0.00,0.00,4474.00,0.00,'2022-05-25 08:51:42','',''),(1477,'21','224','1',1,'Sale Id shift 65',0.00,0.00,0.00,6630.18,0.00,'2022-05-25 08:51:42','',''),(1478,'21','224','1',1,'Sale Id shift 65',0.00,0.00,0.00,3040.62,0.00,'2022-05-25 08:51:42','',''),(1479,'21','224','1',1,'Sale Id shift 65',0.00,0.00,0.00,6650.66,0.00,'2022-05-25 08:51:42','',''),(1480,'21','224','2',1,'Sale Id shift 65',0.00,0.00,0.00,0.47,0.00,'2022-05-25 08:51:42','',''),(1481,'21','224',NULL,1,'Sale Id shift 65',15684386.85,0.00,0.00,0.00,0.00,'2022-05-25 08:51:42','',''),(1482,'21','224',NULL,2,'Sale Id shift 65',6018861.60,0.00,0.00,0.00,0.00,'2022-05-25 08:51:42','',''),(1483,'21','224',NULL,3,'Sale Id shift 65',122044.00,0.00,0.00,0.00,0.00,'2022-05-25 08:51:42','',''),(1484,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 11:20:36','',''),(1485,'21','224',NULL,1,'Reception corrector for bridging 176',0.00,0.00,0.00,1000.00,0.00,'2022-05-25 11:22:36','',''),(1486,'21','224','1',1,'Received from bridging 176',0.00,0.00,1000.00,0.00,0.00,'2022-05-25 11:22:36','',''),(1487,'21','224',NULL,1,'Reception corrector for bridging 175',0.00,0.00,0.00,26000.00,0.00,'2022-05-25 11:22:45','',''),(1488,'21','224','3',1,'Received from bridging 175',0.00,0.00,26000.00,0.00,0.00,'2022-05-25 11:22:45','',''),(1489,'21','224',NULL,1,'Reception corrector for bridging 174',0.00,0.00,0.00,19000.00,0.00,'2022-05-25 11:22:45','',''),(1490,'21','224','1',1,'Received from bridging 174',0.00,0.00,19000.00,0.00,0.00,'2022-05-25 11:22:45','',''),(1491,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-25 11:34:43','',''),(1492,'21','224',NULL,1,'Reception corrector for bridging 177',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 11:35:39','',''),(1493,'21','224','1',1,'Received from bridging 177',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 11:35:39','',''),(1494,'21','224',NULL,1,'Reception corrector for bridging 179',0.00,0.00,0.00,30000.00,0.00,'2022-05-25 11:36:45','',''),(1495,'21','224','2',1,'Received from bridging 179',0.00,0.00,30000.00,0.00,0.00,'2022-05-25 11:36:45','',''),(1496,'21','224',NULL,1,'Reception corrector for bridging 178',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 11:36:45','',''),(1497,'21','224','1',1,'Received from bridging 178',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 11:36:45','',''),(1498,'21','224','1',1,'Sale Id shift 66',0.00,0.00,0.00,-3059.36,0.00,'2022-05-25 11:47:49','',''),(1499,'21','224','2',1,'Sale Id shift 66',0.00,0.00,0.00,7083.06,0.00,'2022-05-25 11:47:49','',''),(1500,'21','224','2',1,'Sale Id shift 66',0.00,0.00,0.00,5976.51,0.00,'2022-05-25 11:47:49','',''),(1501,'21','224','3',1,'Sale Id shift 66',0.00,0.00,0.00,5543.24,0.00,'2022-05-25 11:47:49','',''),(1502,'21','224','3',1,'Sale Id shift 66',0.00,0.00,0.00,6514.93,0.00,'2022-05-25 11:47:49','',''),(1503,'21','224','1',1,'Sale Id shift 66',0.00,0.00,0.00,6397.54,0.00,'2022-05-25 11:47:49','',''),(1504,'21','224','3',1,'Sale Id shift 66',0.00,0.00,0.00,5850.64,0.00,'2022-05-25 11:47:49','',''),(1505,'21','224','3',1,'Sale Id shift 66',0.00,0.00,0.00,6028.39,0.00,'2022-05-25 11:47:49','',''),(1506,'21','224','4',2,'Sale Id shift 66',0.00,0.00,0.00,4957.34,0.00,'2022-05-25 11:47:49','',''),(1507,'21','224','1',1,'Sale Id shift 66',0.00,0.00,0.00,7758.55,0.00,'2022-05-25 11:47:49','',''),(1508,'21','224','6',3,'Sale Id shift 66',0.00,0.00,0.00,1032.81,0.00,'2022-05-25 11:47:49','',''),(1509,'21','224','2',1,'Sale Id shift 66',0.00,0.00,0.00,5751.78,0.00,'2022-05-25 11:47:49','',''),(1510,'21','224','1',1,'Sale Id shift 66',0.00,0.00,0.00,0.38,0.00,'2022-05-25 11:47:49','',''),(1511,'21','224','1',1,'Sale Id shift 66',0.00,0.00,0.00,7235.22,0.00,'2022-05-25 11:47:49','',''),(1512,'21','224','1',1,'Sale Id shift 66',0.00,0.00,0.00,7.19,0.00,'2022-05-25 11:47:49','',''),(1513,'21','224','1',1,'Sale Id shift 66',0.00,0.00,0.00,8339.66,0.00,'2022-05-25 11:47:49','',''),(1514,'21','224',NULL,1,'Sale Id shift 66',11455575.45,0.00,0.00,0.00,0.00,'2022-05-25 11:47:49','',''),(1515,'21','224',NULL,2,'Sale Id shift 66',3569284.80,0.00,0.00,0.00,0.00,'2022-05-25 11:47:49','',''),(1516,'21','224',NULL,3,'Sale Id shift 66',671326.50,0.00,0.00,0.00,0.00,'2022-05-25 11:47:49','',''),(1517,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-25 11:54:21','',''),(1518,'21','224',NULL,1,'Reception corrector for bridging 180',0.00,0.00,0.00,25000.00,0.00,'2022-05-25 11:55:03','',''),(1519,'21','224','3',1,'Received from bridging 180',0.00,0.00,25000.00,0.00,0.00,'2022-05-25 11:55:03','',''),(1520,'21','224',NULL,1,'Reception corrector for bridging 182',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 12:10:26','',''),(1521,'21','224','2',1,'Received from bridging 182',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 12:10:26','',''),(1522,'21','224',NULL,1,'Reception corrector for bridging 181',0.00,0.00,0.00,15000.00,0.00,'2022-05-25 12:10:26','',''),(1523,'21','224','1',1,'Received from bridging 181',0.00,0.00,15000.00,0.00,0.00,'2022-05-25 12:10:26','',''),(1524,'21','224','1',1,'Sale Id shift 67',0.00,0.00,0.00,5430.89,0.00,'2022-05-25 12:24:29','',''),(1525,'21','224','2',1,'Sale Id shift 67',0.00,0.00,0.00,9444.33,0.00,'2022-05-25 12:24:29','',''),(1526,'21','224','2',1,'Sale Id shift 67',0.00,0.00,0.00,8185.20,0.00,'2022-05-25 12:24:29','',''),(1527,'21','224','3',1,'Sale Id shift 67',0.00,0.00,0.00,5089.20,0.00,'2022-05-25 12:24:29','',''),(1528,'21','224','3',1,'Sale Id shift 67',0.00,0.00,0.00,9758.57,0.00,'2022-05-25 12:24:29','',''),(1529,'21','224','1',1,'Sale Id shift 67',0.00,0.00,0.00,5128.35,0.00,'2022-05-25 12:24:29','',''),(1530,'21','224','3',1,'Sale Id shift 67',0.00,0.00,0.00,6942.43,0.00,'2022-05-25 12:24:29','',''),(1531,'21','224','3',1,'Sale Id shift 67',0.00,0.00,0.00,6072.05,0.00,'2022-05-25 12:24:29','',''),(1532,'21','224','4',2,'Sale Id shift 67',0.00,0.00,0.00,12771.23,0.00,'2022-05-25 12:24:29','',''),(1533,'21','224','1',1,'Sale Id shift 67',0.00,0.00,0.00,4063.89,0.00,'2022-05-25 12:24:29','',''),(1534,'21','224','6',3,'Sale Id shift 67',0.00,0.00,0.00,1408.18,0.00,'2022-05-25 12:24:29','',''),(1535,'21','224','2',1,'Sale Id shift 67',0.00,0.00,0.00,6953.20,0.00,'2022-05-25 12:24:29','',''),(1536,'21','224','1',1,'Sale Id shift 67',0.00,0.00,0.00,6408.91,0.00,'2022-05-25 12:24:29','',''),(1537,'21','224','1',1,'Sale Id shift 67',0.00,0.00,0.00,0.39,0.00,'2022-05-25 12:24:29','',''),(1538,'21','224','1',1,'Sale Id shift 67',0.00,0.00,0.00,5941.00,0.00,'2022-05-25 12:24:29','',''),(1539,'21','224',NULL,1,'Sale Id shift 67',13104037.65,0.00,0.00,0.00,0.00,'2022-05-25 12:24:29','',''),(1540,'21','224',NULL,2,'Sale Id shift 67',9195285.60,0.00,0.00,0.00,0.00,'2022-05-25 12:24:29','',''),(1541,'21','224',NULL,3,'Sale Id shift 67',915317.00,0.00,0.00,0.00,0.00,'2022-05-25 12:24:29','',''),(1542,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-25 12:26:33','',''),(1543,'21','224',NULL,1,'Reception corrector for bridging 185',0.00,0.00,0.00,40000.00,0.00,'2022-05-25 12:28:55','',''),(1544,'21','224','3',1,'Received from bridging 185',0.00,0.00,40000.00,0.00,0.00,'2022-05-25 12:28:55','',''),(1545,'21','224',NULL,1,'Reception corrector for bridging 184',0.00,0.00,0.00,1000.00,0.00,'2022-05-25 12:28:55','',''),(1546,'21','224','2',1,'Received from bridging 184',0.00,0.00,1000.00,0.00,0.00,'2022-05-25 12:28:55','',''),(1547,'21','224',NULL,1,'Reception corrector for bridging 186',0.00,0.00,0.00,19000.00,0.00,'2022-05-25 12:30:01','',''),(1548,'21','224','1',1,'Received from bridging 186',0.00,0.00,19000.00,0.00,0.00,'2022-05-25 12:30:01','',''),(1549,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-25 12:46:07','',''),(1550,'21','224',NULL,1,'Reception corrector for bridging 187',0.00,0.00,0.00,5000.00,0.00,'2022-05-25 12:49:15','',''),(1551,'21','224','1',1,'Received from bridging 187',0.00,0.00,5000.00,0.00,0.00,'2022-05-25 12:49:15','',''),(1552,'21','224',NULL,1,'Reception corrector for bridging 190',0.00,0.00,0.00,2000.00,0.00,'2022-05-25 12:54:35','',''),(1553,'21','224','3',1,'Received from bridging 190',0.00,0.00,2000.00,0.00,0.00,'2022-05-25 12:54:35','',''),(1554,'21','224',NULL,1,'Reception corrector for bridging 189',0.00,0.00,0.00,38000.00,0.00,'2022-05-25 12:54:35','',''),(1555,'21','224','2',1,'Received from bridging 189',0.00,0.00,38000.00,0.00,0.00,'2022-05-25 12:54:35','',''),(1556,'21','224',NULL,1,'Reception corrector for bridging 188',0.00,0.00,0.00,15000.00,0.00,'2022-05-25 12:54:35','',''),(1557,'21','224','1',1,'Received from bridging 188',0.00,0.00,15000.00,0.00,0.00,'2022-05-25 12:54:35','',''),(1558,'21','224',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,32400000.00,45000.00,0.00,0.00,'2022-05-25 12:59:16','',''),(1559,'21','224',NULL,2,'Reception corrector for bridging 191',0.00,0.00,0.00,1580.00,0.00,'2022-05-25 13:00:54','',''),(1560,'21','224','4',2,'Received from bridging 191',0.00,0.00,1580.00,0.00,0.00,'2022-05-25 13:00:54','',''),(1561,'21','224','1',1,'Sale Id shift 68',0.00,0.00,0.00,5675.40,0.00,'2022-05-25 13:42:47','',''),(1562,'21','224','2',1,'Sale Id shift 68',0.00,0.00,0.00,7928.73,0.00,'2022-05-25 13:42:47','',''),(1563,'21','224','2',1,'Sale Id shift 68',0.00,0.00,0.00,0.80,0.00,'2022-05-25 13:42:47','',''),(1564,'21','224','2',1,'Sale Id shift 68',0.00,0.00,0.00,5721.63,0.00,'2022-05-25 13:42:47','',''),(1565,'21','224','3',1,'Sale Id shift 68',0.00,0.00,0.00,3799.39,0.00,'2022-05-25 13:42:47','',''),(1566,'21','224','3',1,'Sale Id shift 68',0.00,0.00,0.00,8976.82,0.00,'2022-05-25 13:42:47','',''),(1567,'21','224','1',1,'Sale Id shift 68',0.00,0.00,0.00,6358.79,0.00,'2022-05-25 13:42:47','',''),(1568,'21','224','3',1,'Sale Id shift 68',0.00,0.00,0.00,7718.76,0.00,'2022-05-25 13:42:47','',''),(1569,'21','224','3',1,'Sale Id shift 68',0.00,0.00,0.00,5643.90,0.00,'2022-05-25 13:42:47','',''),(1570,'21','224','4',2,'Sale Id shift 68',0.00,0.00,0.00,3934.35,0.00,'2022-05-25 13:42:47','',''),(1571,'21','224','1',1,'Sale Id shift 68',0.00,0.00,0.00,7007.01,0.00,'2022-05-25 13:42:47','',''),(1572,'21','224','5',2,'Sale Id shift 68',0.00,0.00,0.00,4721.59,0.00,'2022-05-25 13:42:47','',''),(1573,'21','224','6',3,'Sale Id shift 68',0.00,0.00,0.00,1231.68,0.00,'2022-05-25 13:42:47','',''),(1574,'21','224','2',1,'Sale Id shift 68',0.00,0.00,0.00,5249.20,0.00,'2022-05-25 13:42:47','',''),(1575,'21','224','1',1,'Sale Id shift 68',0.00,0.00,0.00,0.44,0.00,'2022-05-25 13:42:47','',''),(1576,'21','224','1',1,'Sale Id shift 68',0.00,0.00,0.00,1.00,0.00,'2022-05-25 13:42:47','',''),(1577,'21','224','1',1,'Sale Id shift 68',0.00,0.00,0.00,6982.62,0.00,'2022-05-25 13:42:47','',''),(1578,'21','224','1',1,'Sale Id shift 68',0.00,0.00,0.00,0.35,0.00,'2022-05-25 13:42:47','',''),(1579,'21','224','1',1,'Sale Id shift 68',0.00,0.00,0.00,7460.55,0.00,'2022-05-25 13:42:47','',''),(1580,'21','224',NULL,2,'Sale Id shift 68',6232276.80,0.00,0.00,0.00,0.00,'2022-05-25 13:42:47','',''),(1581,'21','224',NULL,3,'Sale Id shift 68',800592.00,0.00,0.00,0.00,0.00,'2022-05-25 13:42:47','',''),(1582,'21','224',NULL,1,'Sale Id shift 68',12956689.35,0.00,0.00,0.00,0.00,'2022-05-25 13:42:47','',''),(1583,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-25 13:44:17','',''),(1584,'21','224',NULL,1,'Reception corrector for bridging 193',0.00,0.00,0.00,14125.00,0.00,'2022-05-25 13:45:21','',''),(1585,'21','224','3',1,'Received from bridging 193',0.00,0.00,14125.00,0.00,0.00,'2022-05-25 13:45:21','',''),(1586,'21','224',NULL,1,'Reception corrector for bridging 192',0.00,0.00,0.00,6800.00,0.00,'2022-05-25 13:45:21','',''),(1587,'21','224','1',1,'Received from bridging 192',0.00,0.00,6800.00,0.00,0.00,'2022-05-25 13:45:21','',''),(1588,'21','224','1',1,'Sale Id shift 69',0.00,0.00,0.00,5496.49,0.00,'2022-05-25 14:45:40','',''),(1589,'21','224','2',1,'Sale Id shift 69',0.00,0.00,0.00,7838.32,0.00,'2022-05-25 14:45:40','',''),(1590,'21','224','2',1,'Sale Id shift 69',0.00,0.00,0.00,7768.61,0.00,'2022-05-25 14:45:40','',''),(1591,'21','224','3',1,'Sale Id shift 69',0.00,0.00,0.00,7964.71,0.00,'2022-05-25 14:45:40','',''),(1592,'21','224','1',1,'Sale Id shift 69',0.00,0.00,0.00,6510.46,0.00,'2022-05-25 14:45:40','',''),(1593,'21','224','3',1,'Sale Id shift 69',0.00,0.00,0.00,5219.02,0.00,'2022-05-25 14:45:40','',''),(1594,'21','224','3',1,'Sale Id shift 69',0.00,0.00,0.00,5890.21,0.00,'2022-05-25 14:45:40','',''),(1595,'21','224','1',1,'Sale Id shift 69',0.00,0.00,0.00,5779.50,0.00,'2022-05-25 14:45:40','',''),(1596,'21','224','5',2,'Sale Id shift 69',0.00,0.00,0.00,12614.88,0.00,'2022-05-25 14:45:40','',''),(1597,'21','224','6',3,'Sale Id shift 69',0.00,0.00,0.00,1091.97,0.00,'2022-05-25 14:45:40','',''),(1598,'21','224','2',1,'Sale Id shift 69',0.00,0.00,0.00,6757.24,0.00,'2022-05-25 14:45:40','',''),(1599,'21','224','1',1,'Sale Id shift 69',0.00,0.00,0.00,0.62,0.00,'2022-05-25 14:45:40','',''),(1600,'21','224','1',1,'Sale Id shift 69',0.00,0.00,0.00,7593.11,0.00,'2022-05-25 14:45:40','',''),(1601,'21','224',NULL,1,'Sale Id shift 69',11025017.85,0.00,0.00,0.00,0.00,'2022-05-25 14:45:40','',''),(1602,'21','224',NULL,2,'Sale Id shift 69',9082713.60,0.00,0.00,0.00,0.00,'2022-05-25 14:45:40','',''),(1603,'21','224',NULL,3,'Sale Id shift 69',709780.50,0.00,0.00,0.00,0.00,'2022-05-25 14:45:40','',''),(1604,'21','224',NULL,1,'Reception corrector for bridging 195',0.00,0.00,0.00,19100.00,0.00,'2022-05-25 14:51:10','',''),(1605,'21','224','3',1,'Received from bridging 195',0.00,0.00,19100.00,0.00,0.00,'2022-05-25 14:51:10','',''),(1606,'21','224',NULL,1,'Reception corrector for bridging 194',0.00,0.00,0.00,9975.00,0.00,'2022-05-25 14:51:10','',''),(1607,'21','224','1',1,'Received from bridging 194',0.00,0.00,9975.00,0.00,0.00,'2022-05-25 14:51:10','',''),(1608,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-25 14:59:03','',''),(1609,'21','224',NULL,1,'Reception corrector for bridging 196',0.00,0.00,0.00,15200.00,0.00,'2022-05-25 14:59:39','',''),(1610,'21','224','1',1,'Received from bridging 196',0.00,0.00,15200.00,0.00,0.00,'2022-05-25 14:59:39','',''),(1611,'21','224',NULL,1,'Reception corrector for bridging 197',0.00,0.00,0.00,15000.00,0.00,'2022-05-25 15:17:44','',''),(1612,'21','224','1',1,'Received from bridging 197',0.00,0.00,15000.00,0.00,0.00,'2022-05-25 15:17:44','',''),(1613,'21','224','1',1,'Sale Id shift 70',0.00,0.00,0.00,4421.29,0.00,'2022-05-25 15:29:58','',''),(1614,'21','224','2',1,'Sale Id shift 70',0.00,0.00,0.00,7866.47,0.00,'2022-05-25 15:29:58','',''),(1615,'21','224','2',1,'Sale Id shift 70',0.00,0.00,0.00,6915.23,0.00,'2022-05-25 15:29:58','',''),(1616,'21','224','3',1,'Sale Id shift 70',0.00,0.00,0.00,5783.47,0.00,'2022-05-25 15:29:58','',''),(1617,'21','224','3',1,'Sale Id shift 70',0.00,0.00,0.00,6925.30,0.00,'2022-05-25 15:29:58','',''),(1618,'21','224','3',1,'Sale Id shift 70',0.00,0.00,0.00,5307.94,0.00,'2022-05-25 15:29:58','',''),(1619,'21','224','3',1,'Sale Id shift 70',0.00,0.00,0.00,6640.46,0.00,'2022-05-25 15:29:58','',''),(1620,'21','224','1',1,'Sale Id shift 70',0.00,0.00,0.00,7075.07,0.00,'2022-05-25 15:29:58','',''),(1621,'21','224','5',2,'Sale Id shift 70',0.00,0.00,0.00,6677.92,0.00,'2022-05-25 15:29:58','',''),(1622,'21','224','6',3,'Sale Id shift 70',0.00,0.00,0.00,859.27,0.00,'2022-05-25 15:29:58','',''),(1623,'21','224','2',1,'Sale Id shift 70',0.00,0.00,0.00,5459.69,0.00,'2022-05-25 15:29:58','',''),(1624,'21','224','1',1,'Sale Id shift 70',0.00,0.00,0.00,1.00,0.00,'2022-05-25 15:29:58','',''),(1625,'21','224','1',1,'Sale Id shift 70',0.00,0.00,0.00,6337.63,0.00,'2022-05-25 15:29:58','',''),(1626,'21','224','1',1,'Sale Id shift 70',0.00,0.00,0.00,15231.26,0.00,'2022-05-25 15:29:58','',''),(1627,'21','224',NULL,1,'Sale Id shift 70',12864193.65,0.00,0.00,0.00,0.00,'2022-05-25 15:29:58','',''),(1628,'21','224',NULL,2,'Sale Id shift 70',4808102.40,0.00,0.00,0.00,0.00,'2022-05-25 15:29:58','',''),(1629,'21','224',NULL,3,'Sale Id shift 70',558525.50,0.00,0.00,0.00,0.00,'2022-05-25 15:29:58','',''),(1630,'21','224',NULL,1,'Reception corrector for bridging 199',0.00,0.00,0.00,17719.00,0.00,'2022-05-25 15:35:11','',''),(1631,'21','224','2',1,'Received from bridging 199',0.00,0.00,17719.00,0.00,0.00,'2022-05-25 15:35:11','',''),(1632,'21','224',NULL,1,'Reception corrector for bridging 198',0.00,0.00,0.00,2081.00,0.00,'2022-05-25 15:35:11','',''),(1633,'21','224','1',1,'Received from bridging 198',0.00,0.00,2081.00,0.00,0.00,'2022-05-25 15:35:11','',''),(1634,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-25 15:36:48','',''),(1635,'21','224',NULL,1,'Reception corrector for bridging 201',0.00,0.00,0.00,29181.00,0.00,'2022-05-25 15:38:49','',''),(1636,'21','224','3',1,'Received from bridging 201',0.00,0.00,29181.00,0.00,0.00,'2022-05-25 15:38:49','',''),(1637,'21','224',NULL,1,'Reception corrector for bridging 200',0.00,0.00,0.00,17740.00,0.00,'2022-05-25 15:38:49','',''),(1638,'21','224','1',1,'Received from bridging 200',0.00,0.00,17740.00,0.00,0.00,'2022-05-25 15:38:49','',''),(1639,'21','224',NULL,1,'Reception corrector for bridging 202',0.00,0.00,0.00,3079.00,0.00,'2022-05-25 16:28:00','',''),(1640,'21','224','1',1,'Received from bridging 202',0.00,0.00,3079.00,0.00,0.00,'2022-05-25 16:28:00','',''),(1641,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-25 16:28:51','',''),(1642,'21','224',NULL,1,'Reception corrector for bridging 205',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 16:29:47','',''),(1643,'21','224','2',1,'Received from bridging 205',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 16:29:47','',''),(1644,'21','224',NULL,1,'Reception corrector for bridging 204',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 16:29:47','',''),(1645,'21','224','1',1,'Received from bridging 204',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 16:29:47','',''),(1646,'21','224','1',1,'Sale Id shift 71',0.00,0.00,0.00,4986.25,0.00,'2022-05-25 16:51:53','',''),(1647,'21','224','2',1,'Sale Id shift 71',0.00,0.00,0.00,3243.21,0.00,'2022-05-25 16:51:53','',''),(1648,'21','224','2',1,'Sale Id shift 71',0.00,0.00,0.00,7134.21,0.00,'2022-05-25 16:51:53','',''),(1649,'21','224','2',1,'Sale Id shift 71',0.00,0.00,0.00,24.55,0.00,'2022-05-25 16:51:53','',''),(1650,'21','224','2',1,'Sale Id shift 71',0.00,0.00,0.00,0.05,0.00,'2022-05-25 16:51:53','',''),(1651,'21','224','2',1,'Sale Id shift 71',0.00,0.00,0.00,6664.05,0.00,'2022-05-25 16:51:53','',''),(1652,'21','224','3',1,'Sale Id shift 71',0.00,0.00,0.00,7012.96,0.00,'2022-05-25 16:51:53','',''),(1653,'21','224','3',1,'Sale Id shift 71',0.00,0.00,0.00,4436.78,0.00,'2022-05-25 16:51:53','',''),(1654,'21','224','1',1,'Sale Id shift 71',0.00,0.00,0.00,10127.00,0.00,'2022-05-25 16:51:53','',''),(1655,'21','224','3',1,'Sale Id shift 71',0.00,0.00,0.00,6297.35,0.00,'2022-05-25 16:51:53','',''),(1656,'21','224','3',1,'Sale Id shift 71',0.00,0.00,0.00,6112.85,0.00,'2022-05-25 16:51:53','',''),(1657,'21','224','1',1,'Sale Id shift 71',0.00,0.00,0.00,4842.43,0.00,'2022-05-25 16:51:53','',''),(1658,'21','224','5',2,'Sale Id shift 71',0.00,0.00,0.00,8961.23,0.00,'2022-05-25 16:51:53','',''),(1659,'21','224','6',3,'Sale Id shift 71',0.00,0.00,0.00,966.35,0.00,'2022-05-25 16:51:53','',''),(1660,'21','224','2',1,'Sale Id shift 71',0.00,0.00,0.00,0.25,0.00,'2022-05-25 16:51:53','',''),(1661,'21','224','2',1,'Sale Id shift 71',0.00,0.00,0.00,6538.04,0.00,'2022-05-25 16:51:53','',''),(1662,'21','224','1',1,'Sale Id shift 71',0.00,0.00,0.00,0.45,0.00,'2022-05-25 16:51:53','',''),(1663,'21','224','1',1,'Sale Id shift 71',0.00,0.00,0.00,1140.00,0.00,'2022-05-25 16:51:53','',''),(1664,'21','224','1',1,'Sale Id shift 71',0.00,0.00,0.00,5003.30,0.00,'2022-05-25 16:51:53','',''),(1665,'21','224','1',1,'Sale Id shift 71',0.00,0.00,0.00,6198.78,0.00,'2022-05-25 16:51:53','',''),(1666,'21','224','2',1,'Sale Id shift 71',0.00,0.00,0.00,1801.19,0.00,'2022-05-25 16:51:53','',''),(1667,'21','224',NULL,2,'Sale Id shift 71',6452085.60,0.00,0.00,0.00,0.00,'2022-05-25 16:51:53','',''),(1668,'21','224',NULL,3,'Sale Id shift 71',628127.50,0.00,0.00,0.00,0.00,'2022-05-25 16:51:53','',''),(1669,'21','224',NULL,1,'Sale Id shift 71',13458010.50,0.00,0.00,0.00,0.00,'2022-05-25 16:51:53','',''),(1670,'21','224',NULL,1,'Reception corrector for bridging 206',0.00,0.00,0.00,1104.00,0.00,'2022-05-25 18:18:13','',''),(1671,'21','224','3',1,'Received from bridging 206',0.00,0.00,1104.00,0.00,0.00,'2022-05-25 18:18:13','',''),(1672,'21','224',NULL,1,'Reception corrector for bridging 207',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 18:19:51','',''),(1673,'21','224','1',1,'Received from bridging 207',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 18:19:51','',''),(1674,'21','224',NULL,1,'Reception corrector for bridging 209',0.00,0.00,0.00,96.00,0.00,'2022-05-25 18:21:24','',''),(1675,'21','224','3',1,'Received from bridging 209',0.00,0.00,96.00,0.00,0.00,'2022-05-25 18:21:24','',''),(1676,'21','224',NULL,1,'Reception corrector for bridging 208',0.00,0.00,0.00,3800.00,0.00,'2022-05-25 18:21:24','',''),(1677,'21','224','2',1,'Received from bridging 208',0.00,0.00,3800.00,0.00,0.00,'2022-05-25 18:21:24','',''),(1678,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-25 18:21:45','',''),(1679,'21','224',NULL,1,'Reception corrector for bridging 211',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 18:23:10','',''),(1680,'21','224','2',1,'Received from bridging 211',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 18:23:10','',''),(1681,'21','224',NULL,1,'Reception corrector for bridging 210',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 18:23:10','',''),(1682,'21','224','1',1,'Received from bridging 210',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 18:23:10','',''),(1683,'21','224',NULL,1,'Reception corrector for bridging 214',0.00,0.00,0.00,3000.00,0.00,'2022-05-25 18:25:29','',''),(1684,'21','224','3',1,'Received from bridging 214',0.00,0.00,3000.00,0.00,0.00,'2022-05-25 18:25:29','',''),(1685,'21','224',NULL,1,'Reception corrector for bridging 213',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 18:25:29','',''),(1686,'21','224','2',1,'Received from bridging 213',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 18:25:29','',''),(1687,'21','224',NULL,1,'Reception corrector for bridging 212',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 18:25:29','',''),(1688,'21','224','1',1,'Received from bridging 212',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 18:25:29','',''),(1689,'21','224','2',1,'Returned bridging 213',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 18:27:51','',''),(1690,'21','224',NULL,1,'Reception Return corrector for bridging 213',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 18:27:51','',''),(1691,'21','224','1',1,'Returned bridging 212',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 18:28:30','',''),(1692,'21','224',NULL,1,'Reception Return corrector for bridging 212',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 18:28:30','',''),(1693,'21','224',NULL,2,'Reception corrector for bridging 215',0.00,0.00,0.00,500.00,0.00,'2022-05-25 18:30:29','',''),(1694,'21','224','4',2,'Received from bridging 215',0.00,0.00,500.00,0.00,0.00,'2022-05-25 18:30:29','',''),(1695,'21','224',NULL,1,'Reception corrector for bridging 217',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 18:33:22','',''),(1696,'21','224','2',1,'Received from bridging 217',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 18:33:22','',''),(1697,'21','224',NULL,1,'Reception corrector for bridging 216',0.00,0.00,0.00,10000.00,0.00,'2022-05-25 18:33:22','',''),(1698,'21','224','1',1,'Received from bridging 216',0.00,0.00,10000.00,0.00,0.00,'2022-05-25 18:33:22','',''),(1699,'21','224',NULL,1,'Reception corrector for bridging 220',0.00,0.00,0.00,3000.00,0.00,'2022-05-25 18:35:02','',''),(1700,'21','224','3',1,'Received from bridging 220',0.00,0.00,3000.00,0.00,0.00,'2022-05-25 18:35:02','',''),(1701,'21','224',NULL,1,'Reception corrector for bridging 219',0.00,0.00,0.00,7000.00,0.00,'2022-05-25 18:35:02','',''),(1702,'21','224','2',1,'Received from bridging 219',0.00,0.00,7000.00,0.00,0.00,'2022-05-25 18:35:02','',''),(1703,'21','224',NULL,1,'Reception corrector for bridging 218',0.00,0.00,0.00,7000.00,0.00,'2022-05-25 18:35:02','',''),(1704,'21','224','1',1,'Received from bridging 218',0.00,0.00,7000.00,0.00,0.00,'2022-05-25 18:35:02','',''),(1705,'21','224',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-25 18:36:04','',''),(1706,'21','224',NULL,1,'Reception corrector for bridging 224',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 18:38:13','',''),(1707,'21','224','2',1,'Received from bridging 224',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 18:38:13','',''),(1708,'21','224',NULL,1,'Reception corrector for bridging 223',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 18:38:13','',''),(1709,'21','224','1',1,'Received from bridging 223',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 18:38:13','',''),(1710,'21','224','2',1,'Returned bridging 224',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 18:39:52','',''),(1711,'21','224',NULL,1,'Reception Return corrector for bridging 224',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 18:39:52','',''),(1712,'21','224','1',1,'Returned bridging 223',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 18:40:17','',''),(1713,'21','224',NULL,1,'Reception Return corrector for bridging 223',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 18:40:17','',''),(1714,'21','224',NULL,2,'Reception corrector for bridging 226',0.00,0.00,0.00,22920.00,0.00,'2022-05-25 18:42:29','',''),(1715,'21','224','5',2,'Received from bridging 226',0.00,0.00,22920.00,0.00,0.00,'2022-05-25 18:42:29','',''),(1716,'21','224',NULL,2,'Reception corrector for bridging 225',0.00,0.00,0.00,20000.00,0.00,'2022-05-25 18:42:29','',''),(1717,'21','224','4',2,'Received from bridging 225',0.00,0.00,20000.00,0.00,0.00,'2022-05-25 18:42:29','',''),(1718,'21','224','1',1,'Sale Id shift 72',0.00,0.00,0.00,1929.73,0.00,'2022-05-25 20:26:30','',''),(1719,'21','224','2',1,'Sale Id shift 72',0.00,0.00,0.00,4844.74,0.00,'2022-05-25 20:26:30','',''),(1720,'21','224','2',1,'Sale Id shift 72',0.00,0.00,0.00,6329.36,0.00,'2022-05-25 20:26:30','',''),(1721,'21','224','2',1,'Sale Id shift 72',0.00,0.00,0.00,0.20,0.00,'2022-05-25 20:26:30','',''),(1722,'21','224','2',1,'Sale Id shift 72',0.00,0.00,0.00,4948.16,0.00,'2022-05-25 20:26:30','',''),(1723,'21','224','3',1,'Sale Id shift 72',0.00,0.00,0.00,3232.55,0.00,'2022-05-25 20:26:30','',''),(1724,'21','224','3',1,'Sale Id shift 72',0.00,0.00,0.00,3052.17,0.00,'2022-05-25 20:26:30','',''),(1725,'21','224','1',1,'Sale Id shift 72',0.00,0.00,0.00,3733.75,0.00,'2022-05-25 20:26:30','',''),(1726,'21','224','3',1,'Sale Id shift 72',0.00,0.00,0.00,3304.96,0.00,'2022-05-25 20:26:30','',''),(1727,'21','224','3',1,'Sale Id shift 72',0.00,0.00,0.00,3051.76,0.00,'2022-05-25 20:26:30','',''),(1728,'21','224','4',2,'Sale Id shift 72',0.00,0.00,0.00,502.42,0.00,'2022-05-25 20:26:30','',''),(1729,'21','224','1',1,'Sale Id shift 72',0.00,0.00,0.00,3650.43,0.00,'2022-05-25 20:26:30','',''),(1730,'21','224','5',2,'Sale Id shift 72',0.00,0.00,0.00,7006.44,0.00,'2022-05-25 20:26:30','',''),(1731,'21','224','6',3,'Sale Id shift 72',0.00,0.00,0.00,1235.62,0.00,'2022-05-25 20:26:30','',''),(1732,'21','224','2',1,'Sale Id shift 72',0.00,0.00,0.00,3992.67,0.00,'2022-05-25 20:26:30','',''),(1733,'21','224','1',1,'Sale Id shift 72',0.00,0.00,0.00,0.23,0.00,'2022-05-25 20:26:30','',''),(1734,'21','224','1',1,'Sale Id shift 72',0.00,0.00,0.00,36.00,0.00,'2022-05-25 20:26:30','',''),(1735,'21','224','1',1,'Sale Id shift 72',0.00,0.00,0.00,3754.49,0.00,'2022-05-25 20:26:30','',''),(1736,'21','224','1',1,'Sale Id shift 72',0.00,0.00,0.00,0.20,0.00,'2022-05-25 20:26:30','',''),(1737,'21','224','1',1,'Sale Id shift 72',0.00,0.00,0.00,3154.66,0.00,'2022-05-25 20:26:30','',''),(1738,'21','224','2',1,'Sale Id shift 72',0.00,0.00,0.00,4034.97,0.00,'2022-05-25 20:26:30','',''),(1739,'21','224',NULL,1,'Sale Id shift 72',8753419.95,0.00,0.00,0.00,0.00,'2022-05-25 20:26:30','',''),(1740,'21','224',NULL,2,'Sale Id shift 72',5406379.20,0.00,0.00,0.00,0.00,'2022-05-25 20:26:30','',''),(1741,'21','224',NULL,3,'Sale Id shift 72',803153.00,0.00,0.00,0.00,0.00,'2022-05-25 20:26:30','',''),(1742,'21','224','3',1,'Returned bridging 214',0.00,0.00,0.00,3000.00,0.00,'2022-05-25 20:34:54','',''),(1743,'21','224',NULL,1,'Reception Return corrector for bridging 214',0.00,0.00,3000.00,0.00,0.00,'2022-05-25 20:34:54','',''),(1744,'21','224','3',1,'Returned bridging 220',0.00,0.00,0.00,3000.00,0.00,'2022-05-25 20:35:26','',''),(1745,'21','224',NULL,1,'Reception Return corrector for bridging 220',0.00,0.00,3000.00,0.00,0.00,'2022-05-25 20:35:26','',''),(1746,'21','224','1',1,'Sale Id shift 73',0.00,0.00,0.00,3618.07,0.00,'2022-05-25 20:49:31','',''),(1747,'21','224','2',1,'Sale Id shift 73',0.00,0.00,0.00,2025.31,0.00,'2022-05-25 20:49:31','',''),(1748,'21','224','2',1,'Sale Id shift 73',0.00,0.00,0.00,2554.58,0.00,'2022-05-25 20:49:31','',''),(1749,'21','224','2',1,'Sale Id shift 73',0.00,0.00,0.00,2878.19,0.00,'2022-05-25 20:49:31','',''),(1750,'21','224','1',1,'Sale Id shift 73',