-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_222
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_222`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_222` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_222`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','21','222','PURCHASES','','2022-03-04 00:17:12',5,0.00,0.00,'','764','2022-03-04 00:17:12','764',0,0),(2,500,'',0,'6.1','21','222','CASH','','2022-03-04 00:17:23',5,0.00,0.00,'','764','2022-03-04 00:17:23','764',0,0),(3,7000,'',0,'20','21','222','SALES','','2022-03-04 00:17:48',5,0.00,0.00,'','764','2022-03-04 00:17:48','764',0,0),(4,8000,'',0,'24','21','222','SALARIES & WAGES','','2022-03-04 00:18:18',5,0.00,0.00,'','764','2022-03-04 00:18:18','764',0,0),(5,8001,'',0,'24','21','222','PURCHASES','','2022-03-04 00:18:40',5,0.00,0.00,'','764','2022-03-04 00:18:40','764',0,0),(6,2500,'',0,'2','21','222','KEYSTONE -1011891670','','2022-03-04 15:07:33',5,0.00,0.00,'','764','2022-03-04 15:07:33','764',0,0),(7,2501,'',0,'2','21','222','ZENITH BANK','','2022-03-23 14:23:57',5,0.00,0.00,'','764','2022-03-23 14:23:57','764',0,0),(8,2502,'',0,'2','21','222','zenith Bank pos','','2022-03-23 14:24:08',5,0.00,0.00,'','764','2022-03-23 14:24:08','764',0,0),(9,2503,'',0,'2','21','222','ZENITH BANK TRANSFER ACC','','2022-03-23 14:24:18',5,0.00,0.00,'','764','2022-03-23 14:24:18','764',0,0),(10,2504,'',0,'2','21','222','FIRST BANK','','2022-03-23 14:27:18',5,0.00,0.00,'','764','2022-03-23 14:27:18','764',0,0),(11,2505,'',0,'2','21','222','FIRST BANK POS','','2022-03-23 14:27:25',5,0.00,0.00,'','764','2022-03-23 14:27:25','764',0,0),(12,2506,'',0,'2','21','222','FIRST BANK TRANSFER ACCOUNT','','2022-03-23 14:27:55',5,0.00,0.00,'','764','2022-03-23 14:27:55','764',0,0),(13,2507,'',0,'2','21','222','UBA BANK','','2022-03-23 14:28:04',5,0.00,0.00,'','764','2022-03-23 14:28:04','764',0,0),(14,2508,'',0,'2','21','222','UBA TRANSFER ACC','','2022-03-23 14:28:13',5,0.00,0.00,'','764','2022-03-23 14:28:13','764',0,0),(15,2509,'',0,'2','21','222','UBA POS','','2022-03-23 14:28:29',5,0.00,0.00,'','764','2022-03-23 14:28:29','764',0,0),(16,2510,'',0,'2','21','222','IBTC TRANSFER ACCOUNT','','2022-03-23 14:28:40',5,0.00,0.00,'','764','2022-03-23 14:28:40','764',0,0),(17,2511,'',0,'2','21','222','IBTC POS','','2022-03-23 14:28:51',5,0.00,0.00,'','764','2022-03-23 14:28:51','764',0,0),(18,2512,'',0,'2','21','222','IBTC BANK','','2022-03-23 14:28:59',5,0.00,0.00,'','764','2022-03-23 14:28:59','764',0,0),(19,2513,'',0,'2','21','222','GT BANK POS','','2022-03-23 14:29:07',5,0.00,0.00,'','764','2022-03-23 14:29:07','764',0,0),(20,2514,'',0,'2','21','222','GT BANK TRANSFER ACCOUNT','','2022-03-23 14:29:15',5,0.00,0.00,'','764','2022-03-23 14:29:15','764',0,0),(21,2515,'',0,'2','21','222','GT BANK','','2022-03-23 14:29:22',5,0.00,0.00,'','764','2022-03-23 14:29:22','764',0,0),(22,2516,'',0,'2','21','222','JAIZ BANK','','2022-03-23 14:29:32',5,0.00,0.00,'','764','2022-03-23 14:29:32','764',0,0),(23,2517,'',0,'2','21','222','JAIZ POS','','2022-03-23 14:29:40',5,0.00,0.00,'','764','2022-03-23 14:29:40','764',0,0),(24,2518,'',0,'2','21','222','JAIZ TRANSFER ACCOUNT','','2022-03-23 14:29:48',5,0.00,0.00,'','764','2022-03-23 14:29:48','764',0,0),(25,2519,'',0,'2','21','222','Unity Bank','','2022-03-26 17:51:01',5,0.00,0.00,'','764','2022-03-26 17:51:01','764',0,0),(26,2520,'',0,'2','21','222','Unity Bank POS','','2022-03-26 17:51:14',5,0.00,0.00,'','764','2022-03-26 17:51:14','764',0,0),(27,2521,'',0,'2','21','222','UNITY Bank Transfer account ','','2022-03-26 17:51:23',5,0.00,0.00,'','764','2022-03-26 17:51:23','764',0,0),(28,2522,'',0,'2','21','222','Ecobank POS','','2022-03-26 17:51:30',5,0.00,0.00,'','764','2022-03-26 17:51:30','764',0,0),(29,2523,'',0,'2','21','222','Ecobank ','','2022-03-26 17:51:37',5,0.00,0.00,'','764','2022-03-26 17:51:37','764',0,0),(30,2524,'',0,'2','21','222','Ecobank Transfer account ','','2022-03-26 17:51:46',5,0.00,0.00,'','764','2022-03-26 17:51:46','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','222',3,'1',702.09,1.00,'2022-06-05','','2022-06-05 18:15:21','764','764',2022,'764','2022-06-05 18:15:21',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','222','1',1,'5','LPG NOZZLE 1',126113.95,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('21','222','1',2,'5','LPG NOZZLE 2',35259.11,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','222',10,'daily','2022-06-02','2022-06-02 09:36:54','2022-06-03 09:36:54','775',0.00,0.00,'775','2022-06-02 10:50:52','775','2022-06-02 21:52:10',10,0),('21','222',11,'daily','2022-06-02','2022-06-02 21:54:02','2022-06-03 21:54:02','775',0.00,0.00,'775','2022-06-02 23:06:41','775','2022-06-03 07:37:36',10,0),('21','222',12,'daily','2022-06-03','2022-06-03 07:38:18','2022-06-04 07:38:18','775',0.00,0.00,'775','2022-06-03 21:29:34','775','2022-06-04 08:23:24',10,0),('21','222',13,'daily','2022-06-04','2022-06-04 08:24:14','2022-06-05 08:24:14','775',0.00,0.00,'775','2022-06-04 21:36:26','775','2022-06-05 08:12:32',10,0),('21','222',14,'daily','2022-06-05','2022-06-05 08:13:32','2022-06-06 08:13:32','775',0.00,0.00,'775','2022-06-05 17:16:07','775','2022-06-05 17:17:59',10,0),('21','222',15,'daily','2022-06-07','2022-06-07 16:06:06','2022-06-08 16:06:06','775',0.00,0.00,'775','2022-06-07 21:41:25','775','2022-06-08 08:20:24',10,0),('21','222',16,'daily','2022-06-08','2022-06-08 08:21:17','2022-06-09 08:21:17','775',0.00,0.00,'775','2022-06-08 21:03:40','775','2022-06-09 15:56:47',10,0),('21','222',17,'daily','2022-06-09','2022-06-09 15:57:17','2022-06-10 15:57:17','775',0.00,0.00,'775','2022-06-09 22:09:44','775','2022-06-10 07:25:45',10,0),('21','222',18,'daily','2022-06-10','2022-06-10 07:26:38','2022-06-11 07:26:38','775',0.00,0.00,'775','2022-06-10 20:33:52','775','2022-06-11 08:06:47',10,0),('21','222',19,'daily','2022-06-11','2022-06-11 08:07:23','2022-06-12 08:07:23','775',0.00,0.00,'775','2022-06-11 13:35:30','775','2022-06-11 13:36:52',10,0),('21','222',20,'daily','2022-06-11','2022-06-11 14:28:13','2022-06-12 14:28:13','775',0.00,0.00,'775','2022-06-11 21:03:44','775','2022-06-12 08:05:58',10,0),('21','222',21,'daily','2022-06-12','2022-06-12 08:06:32','2022-06-13 08:06:32','775',0.00,0.00,'775','2022-06-12 15:22:43','775','2022-06-14 12:39:28',10,0),('21','222',22,'daily','2022-06-14','2022-06-14 12:40:40','2022-06-15 12:40:40','775',0.00,0.00,'775','2022-06-14 20:41:57','775','2022-06-15 08:35:40',10,0),('21','222',23,'daily','2022-06-15','2022-06-15 08:36:01','2022-06-16 08:36:01','775',0.00,0.00,'775','2022-06-15 21:48:22','775','2022-06-16 10:01:14',10,0),('21','222',24,'daily','2022-06-16','2022-06-16 10:01:47','2022-06-17 10:01:47','775',0.00,0.00,'775','2022-06-16 21:07:21','775','2022-06-17 08:34:11',10,0),('21','222',25,'daily','2022-06-17','2022-06-17 08:34:54','2022-06-18 08:34:54','775',0.00,0.00,'775','2022-06-17 11:50:23','775','2022-06-18 18:45:45',10,0),('21','222',26,'daily','2022-06-18','2022-06-18 18:46:13','2022-06-19 18:46:13','775',0.00,0.00,'775','2022-06-18 21:43:00','775','2022-06-19 07:37:21',10,0),('21','222',27,'daily','2022-06-19','2022-06-19 07:38:51','2022-06-20 07:38:51','775',0.00,0.00,'775','2022-06-19 21:29:38','775','2022-06-20 07:34:09',10,0),('21','222',28,'daily','2022-06-20','2022-06-20 07:36:48','2022-06-21 07:36:48','775',0.00,0.00,'775','2022-06-20 20:50:03','775','2022-06-21 07:00:34',10,0),('21','222',29,'daily','2022-06-21','2022-06-21 07:02:08','2022-06-22 07:02:08','775',0.00,0.00,'775','2022-06-21 19:05:44','775','2022-06-21 19:06:23',10,0),('21','222',30,'daily','2022-06-21','2022-06-21 19:21:04','2022-06-22 19:21:04','775',0.00,0.00,'775','2022-06-21 21:16:09','775','2022-06-22 07:33:35',10,0),('21','222',31,'daily','2022-06-22','2022-06-22 07:34:37','2022-06-23 07:34:37','775',0.00,0.00,'775','2022-06-22 21:10:45','775','2022-06-23 08:22:00',10,0),('21','222',32,'daily','2022-06-23','2022-06-23 08:22:39','2022-06-24 08:22:39','775',0.00,0.00,'775','2022-06-23 20:50:14','775','2022-06-24 12:40:47',10,0),('21','222',33,'daily','2022-06-24','2022-06-24 12:41:33','2022-06-25 12:41:33','775',0.00,0.00,'775','2022-06-24 20:33:00','775','2022-06-25 07:41:31',10,0),('21','222',34,'daily','2022-06-25','2022-06-25 07:42:27','2022-06-26 07:42:27','775',0.00,0.00,'775','2022-06-25 16:19:46','775','2022-06-25 16:20:48',10,0),('21','222',35,'daily','2022-06-25','2022-06-25 16:21:20','2022-06-26 16:21:20','775',0.00,0.00,'775','2022-06-25 21:07:08','775','2022-06-26 08:17:23',10,0),('21','222',36,'daily','2022-06-26','2022-06-26 08:17:52','2022-06-27 08:17:52','775',0.00,0.00,'775','2022-06-26 21:29:39','775','2022-06-27 07:19:55',10,0),('21','222',37,'daily','2022-06-27','2022-06-27 07:20:30','2022-06-28 07:20:30','775',0.00,0.00,'775','2022-06-27 20:51:33','775','2022-06-28 08:19:12',10,0),('21','222',38,'daily','2022-06-28','2022-06-28 08:20:27','2022-06-29 08:20:27','775',0.00,0.00,'775','2022-06-28 18:14:31','775','2022-06-28 18:14:56',10,0),('21','222',39,'daily','2022-06-28','2022-06-28 18:15:27','2022-06-29 18:15:27','775',0.00,0.00,'775','2022-06-28 20:56:31','775','2022-06-29 07:37:08',10,0),('21','222',40,'daily','2022-06-29','2022-06-29 07:37:50','2022-06-30 07:37:50','775',0.00,0.00,'775','2022-06-29 21:39:26','775','2022-06-30 12:25:49',10,0),('21','222',41,'daily','2022-06-30','2022-06-30 12:26:47','2022-07-01 12:26:47','775',0.00,0.00,'775','2022-06-30 21:51:23','775','2022-07-01 07:55:21',10,0),('21','222',42,'daily','2022-07-01','2022-07-01 07:56:04','2022-07-02 07:56:04','775',0.00,0.00,'775','2022-07-01 20:49:59','775','2022-07-02 12:33:38',10,0),('21','222',43,'daily','2022-07-02','2022-07-02 12:34:02','2022-07-03 12:34:02','775',0.00,0.00,'775','2022-07-02 21:51:32','775','2022-07-02 21:51:49',10,0),('21','222',44,'daily','2022-07-02','2022-07-02 21:52:34','2022-07-03 21:52:34','775',0.00,0.00,'775','2022-07-02 22:25:18','775','2022-07-03 09:02:15',10,0),('21','222',45,'daily','2022-07-03','2022-07-03 09:02:42','2022-07-04 09:02:42','775',0.00,0.00,'775','2022-07-03 21:10:17','775','2022-07-04 15:08:39',10,0),('21','222',46,'daily','2022-07-04','2022-07-04 15:09:16','2022-07-05 15:09:16','775',0.00,0.00,'775','2022-07-04 20:06:41','775','2022-07-08 18:31:00',10,0),('21','222',47,'Daily Shift','2022-07-05','2022-07-09 06:05:49','2022-07-10 06:05:49','775',0.00,0.00,'775','2022-07-09 07:01:55','775','2022-07-09 07:02:10',10,0),('21','222',48,'Daily shift','2022-07-05','2022-07-10 10:23:31','2022-07-11 10:23:31','775',0.00,0.00,'775','2022-07-10 10:55:25','775','2022-07-10 10:55:38',10,0),('21','222',49,'Daily shift','2022-07-06','2022-07-10 10:56:12','2022-07-11 10:56:12','775',0.00,0.00,'775','2022-07-10 11:11:33','775','2022-07-10 11:11:47',10,0),('21','222',50,'Daily shift','2022-07-07','2022-07-10 11:12:48','2022-07-11 11:12:48','775',0.00,0.00,'775','2022-07-10 11:37:59','775','2022-07-10 11:38:15',10,0),('21','222',51,'Daily shift','2022-07-08','2022-07-10 11:41:41','2022-07-11 11:41:41','775',0.00,0.00,'775','2022-07-10 11:54:09','775','2022-07-10 11:55:24',10,0),('21','222',52,'Daily shift','2022-07-08','2022-07-10 14:02:39','2022-07-11 14:02:39','775',0.00,0.00,'775','2022-07-10 14:16:14','775','2022-07-10 14:16:28',10,0),('21','222',53,'Daily shift','2022-07-10','2022-07-10 14:17:19','2022-07-11 14:17:19','775',0.00,0.00,'775','2022-07-10 18:57:44','775','2022-07-10 18:58:15',10,0),('21','222',54,'Daily Shift ','2022-07-10','2022-07-10 19:13:18','2022-07-11 19:13:18','775',0.00,0.00,'775','2022-07-13 14:19:32','775','2022-07-13 14:20:17',10,0),('21','222',55,'Daily shift','2022-07-10','2022-07-13 14:21:36','2022-07-14 14:21:36','775',0.00,0.00,'775','2022-07-13 18:39:11','775','2022-07-13 18:39:30',10,0),('21','222',56,'Daily shift','2022-07-13','2022-07-13 19:29:01','2022-07-14 19:29:01','775',0.00,0.00,'775','2022-07-13 19:52:52','775','2022-07-13 19:53:09',10,0),('21','222',57,'Daily shift','2022-07-12','2022-07-13 19:53:50','2022-07-14 19:53:50','775',0.00,0.00,'775','2022-07-13 20:39:33','775','2022-07-13 20:39:47',10,0),('21','222',58,'Daily shift','2022-07-12','2022-07-13 20:40:23','2022-07-14 20:40:23','775',0.00,0.00,'775','2022-07-14 15:31:29','775','2022-07-14 15:31:53',10,0),('21','222',59,'Daily shift','2022-07-13','2022-07-14 15:32:29','2022-07-15 15:32:29','775',0.00,0.00,'775','2022-07-15 00:25:37','775','2022-07-15 00:25:56',10,0),('21','222',60,'Daily shift','2022-07-14','2022-07-15 18:02:33','2022-07-16 18:02:33','775',0.00,0.00,'775','2022-07-15 18:28:18','775','2022-07-16 14:22:32',10,0),('21','222',61,'Daily shift','2022-07-15','2022-07-16 14:22:57','2022-07-17 14:22:57','775',0.00,0.00,'775','2022-07-16 15:25:56','775','2022-07-18 06:22:03',10,0),('21','222',62,'Daily shift','2022-07-16','2022-07-18 06:22:55','2022-07-19 06:22:55','775',0.00,0.00,'775','2022-07-18 06:40:27','775','2022-07-18 06:40:40',10,0),('21','222',63,'daily','2022-07-19','2022-07-19 14:41:58','2022-07-20 14:41:58','775',0.00,0.00,'775','2022-07-20 10:36:28','775','2022-07-20 10:36:41',10,0),('21','222',64,'daily','2022-07-20','2022-07-20 10:40:09','2022-07-21 10:40:09','775',0.00,0.00,'775','2022-07-20 21:06:59','775','2022-07-21 08:29:18',10,0),('21','222',65,'daily','2022-07-21','2022-07-21 08:29:55','2022-07-22 08:29:55','775',0.00,0.00,'775','2022-07-21 21:03:24','775','2022-07-22 10:40:21',10,0),('21','222',66,'daily','2022-07-22','2022-07-22 10:43:13','2022-07-23 10:43:13','775',0.00,0.00,'775','2022-07-22 20:07:01','775','2022-07-23 08:27:18',10,0),('21','222',67,'daily','2022-07-23','2022-07-23 08:28:18','2022-07-24 08:28:18','775',0.00,0.00,'775','2022-07-24 07:40:51','775','2022-07-24 07:41:25',10,0),('21','222',68,'daily','2022-07-24','2022-07-24 07:51:10','2022-07-25 07:51:10','775',0.00,0.00,'775','2022-07-24 21:20:08','775','2022-07-25 08:26:34',10,0),('21','222',69,'daily','2022-07-25','2022-07-25 08:27:36','2022-07-26 08:27:36','775',0.00,0.00,'775','2022-07-25 20:28:08','775','2022-07-26 07:52:08',10,0),('21','222',70,'daily','2022-07-26','2022-07-26 07:52:31','2022-07-27 07:52:31','775',0.00,0.00,'775','2022-07-26 19:47:57','775','2022-07-27 07:33:03',10,0),('21','222',71,'daily','2022-07-27','2022-07-27 07:33:31','2022-07-28 07:33:31','775',0.00,0.00,'775','2022-07-28 01:13:27','775','2022-07-28 09:47:11',10,0),('21','222',72,'daily','2022-07-28','2022-07-28 10:13:25','2022-07-29 10:13:25','775',0.00,0.00,'775','2022-07-28 20:26:38','775','2022-07-29 08:20:00',10,0),('21','222',73,'daily','2022-07-29','2022-07-29 08:20:21','2022-07-30 08:20:21','775',0.00,0.00,'775','2022-07-29 21:44:41','775','2022-07-30 07:39:07',10,0),('21','222',74,'daily','2022-07-30','2022-07-30 07:40:02','2022-07-31 07:40:02','775',0.00,0.00,'775','2022-07-30 20:23:08','775','2022-07-31 08:05:40',10,0),('21','222',75,'daily','2022-07-31','2022-07-31 08:06:46','2022-08-01 08:06:46','775',0.00,0.00,'775','2022-07-31 20:31:30','775','2022-07-31 20:32:13',10,0),('21','222',76,'daily','2022-07-31','2022-07-31 21:09:43','2022-08-01 21:09:43','775',0.00,0.00,'775','2022-07-31 21:30:04','775','2022-08-01 09:03:20',10,0),('21','222',77,'daily','2022-08-01','2022-08-01 09:34:01','2022-08-02 09:34:01','775',0.00,0.00,'775','2022-08-01 21:05:51','775','2022-08-02 12:26:41',10,0),('21','222',78,'daily','2022-08-02','2022-08-02 12:27:38','2022-08-03 12:27:38','775',0.00,0.00,'775','2022-08-02 20:14:07','775','2022-08-03 08:17:37',10,0),('21','222',79,'daily','2022-08-03','2022-08-03 08:22:31','2022-08-04 08:22:31','775',0.00,0.00,'775','2022-08-03 19:43:31','775','2022-08-04 08:25:25',10,0),('21','222',80,'daily','2022-08-04','2022-08-04 08:26:15','2022-08-05 08:26:15','775',0.00,0.00,'775','2022-08-04 13:41:09','775','2022-08-04 13:41:41',10,0),('21','222',81,'daily','2022-08-04','2022-08-04 13:42:17','2022-08-05 13:42:17','775',0.00,0.00,'775','2022-08-04 20:42:26','775','2022-08-05 11:11:40',10,0),('21','222',82,'daily','2022-08-05','2022-08-05 11:12:56','2022-08-06 11:12:56','775',0.00,0.00,'775','2022-08-05 20:11:55','775','2022-08-06 09:51:29',10,0),('21','222',83,'daily','2022-08-06','2022-08-06 09:52:03','2022-08-07 09:52:03','775',0.00,0.00,'775','2022-08-06 20:22:37','775','2022-08-07 08:02:59',10,0),('21','222',84,'daily','2022-08-07','2022-08-07 08:05:24','2022-08-08 08:05:24','775',0.00,0.00,'775','2022-08-07 16:53:01','775','2022-08-07 16:53:33',10,0),('21','222',85,'daily','2022-08-07','2022-08-07 16:53:51','2022-08-08 16:53:51','775',0.00,0.00,'775','2022-08-07 20:10:59','775','2022-08-08 08:34:23',10,0),('21','222',86,'daily','2022-08-08','2022-08-08 08:38:29','2022-08-09 08:38:29','775',0.00,0.00,'775','2022-08-08 19:49:13','775','2022-08-09 08:09:43',10,0),('21','222',87,'daily','2022-08-09','2022-08-09 08:10:13','2022-08-10 08:10:13','775',0.00,0.00,'775','2022-08-09 19:57:02','775','2022-08-10 09:14:12',10,0),('21','222',88,'daily','2022-08-10','2022-08-10 09:14:37','2022-08-11 09:14:37','775',0.00,0.00,'775','2022-08-10 20:00:35','775','2022-08-11 08:27:31',10,0),('21','222',89,'daily','2022-08-11','2022-08-11 08:27:55','2022-08-12 08:27:55','775',0.00,0.00,'775','2022-08-11 19:46:49','775','2022-08-11 19:47:20',10,0),('21','222',90,'daily','2022-08-11','2022-08-11 19:47:43','2022-08-12 19:47:43','775',0.00,0.00,'775','2022-08-11 20:01:49','775','2022-08-12 09:09:10',10,0),('21','222',91,'daily','2022-08-12','2022-08-12 09:09:34','2022-08-13 09:09:34','775',0.00,0.00,'775','2022-08-12 19:54:50','775','2022-08-13 11:52:09',10,0),('21','222',92,'daily','2022-08-13','2022-08-13 11:52:34','2022-08-14 11:52:34','775',0.00,0.00,'775','2022-08-13 19:24:53','775','2022-08-14 17:18:09',10,0),('21','222',93,'daily','2022-08-14','2022-08-14 17:18:25','2022-08-15 17:18:25','775',0.00,0.00,'775','2022-08-14 18:39:29','775','2022-08-15 16:39:21',10,0),('21','222',94,'daily','2022-08-15','2022-08-15 17:50:23','2022-08-16 17:50:23','775',0.00,0.00,'775','2022-08-15 20:04:33','775','2022-08-16 11:22:13',10,0),('21','222',95,'daily','2022-08-16','2022-08-16 11:24:05','2022-08-17 11:24:05','775',0.00,0.00,'775','2022-08-16 19:56:26','775','2022-08-17 08:44:21',10,0),('21','222',96,'daily','2022-08-17','2022-08-17 08:44:48','2022-08-18 08:44:48','775',0.00,0.00,'775','2022-08-17 20:13:20','775','2022-08-18 07:40:32',10,0),('21','222',97,'daily','2022-08-18','2022-08-18 07:41:03','2022-08-19 07:41:03','775',0.00,0.00,'775','2022-08-18 20:13:13','775','2022-08-18 20:14:00',10,0),('21','222',98,'daily','2022-08-18','2022-08-18 20:24:15','2022-08-19 20:24:15','775',0.00,0.00,'775','2022-08-18 20:31:10','775','2022-08-19 09:19:41',10,0),('21','222',99,'daily','2022-08-19','2022-08-19 09:20:04','2022-08-20 09:20:04','775',0.00,0.00,'775','2022-08-19 19:54:49','775','2022-08-20 07:42:03',10,0),('21','222',100,'daily','2022-08-20','2022-08-20 07:42:40','2022-08-21 07:42:40','775',0.00,0.00,'775','2022-08-20 20:08:46','775','2022-08-21 07:35:46',10,0),('21','222',101,'daily','2022-08-21','2022-08-21 07:36:13','2022-08-22 07:36:13','775',0.00,0.00,'775','2022-08-22 07:47:59','775','2022-08-22 07:48:17',10,0),('21','222',102,'daily','2022-08-22','2022-08-22 07:48:35','2022-08-23 07:48:35','775',0.00,0.00,'775','2022-08-22 07:54:26','775','2022-08-22 07:54:50',10,0),('21','222',103,'daily','2022-08-22','2022-08-22 07:55:50','2022-08-23 07:55:50','775',0.00,0.00,'775','2022-08-22 19:57:53','775','2022-08-23 10:59:57',10,0),('21','222',104,'daily','2022-08-23','2022-08-23 11:00:46','2022-08-24 11:00:46','775',0.00,0.00,'775','2022-08-23 20:37:10','775','2022-08-24 07:58:53',10,0),('21','222',105,'daily','2022-08-24','2022-08-24 07:59:21','2022-08-25 07:59:21','775',0.00,0.00,'775','2022-08-24 20:08:43','775','2022-08-25 09:15:17',10,0),('21','222',106,'daily','2022-08-25','2022-08-25 09:15:36','2022-08-26 09:15:36','775',0.00,0.00,'775','2022-08-25 19:20:59','775','2022-08-26 18:27:28',10,0),('21','222',107,'daily','2022-08-26','2022-08-26 20:11:14','2022-08-27 20:11:14','775',0.00,0.00,'775','2022-08-26 20:50:15','775','2022-08-27 09:04:10',10,0),('21','222',108,'daily','2022-08-27','2022-08-27 09:04:25','2022-08-28 09:04:25','775',0.00,0.00,'775','2022-08-27 19:35:18','775','2022-08-28 09:54:16',10,0),('21','222',109,'daily','2022-08-28','2022-08-28 09:54:44','2022-08-29 09:54:44','775',0.00,0.00,'775','2022-08-28 17:01:51','775','2022-08-29 07:16:42',10,0),('21','222',110,'daily','2022-08-29','2022-08-29 07:33:58','2022-08-30 07:33:58','775',0.00,0.00,'775','2022-08-29 20:06:40','775','2022-08-30 07:39:13',10,0),('21','222',111,'daily','2022-08-30','2022-08-30 07:39:29','2022-08-31 07:39:29','775',0.00,0.00,'775','2022-08-31 07:20:56','775','2022-08-31 07:21:16',10,0),('21','222',112,'daily','2022-08-31','2022-08-31 07:21:36','2022-09-01 07:21:36','775',0.00,0.00,'775','2022-08-31 20:13:28','775','2022-09-01 07:40:02',10,0),('21','222',113,'daily','2022-09-01','2022-09-01 07:40:19','2022-09-02 07:40:19','775',0.00,0.00,'775','2022-09-02 08:53:00','775','2022-09-02 08:53:42',10,0),('21','222',114,'daily','2022-09-01','2022-09-02 08:54:52','2022-09-03 08:54:52','775',0.00,0.00,'775','2022-09-02 11:54:18','775','2022-09-05 12:51:59',10,0),('21','222',115,'Daily ','2022-09-05','2022-09-05 12:54:54','2022-09-06 12:54:54','775',0.00,0.00,'775','2022-09-07 15:36:13','775','2022-09-07 15:36:46',10,0),('21','222',116,'2nd Daily Shift on 03/09/2022','2022-09-03','2022-09-07 15:37:47','2022-09-08 15:37:47','775',0.00,0.00,'775','2022-09-08 11:48:04','775','2022-09-08 11:48:26',10,0),('21','222',117,'Daily shift','2022-09-04','2022-09-08 11:49:19','2022-09-09 11:49:19','775',0.00,0.00,'775','2022-09-08 12:44:27','775','2022-09-08 17:27:46',10,0),('21','222',118,'Daily ','2022-09-05','2022-09-08 17:28:39','2022-09-09 17:28:39','775',0.00,0.00,'775','2022-09-08 18:01:21','775','2022-09-08 18:01:47',10,0),('21','222',119,'Daily ','2022-09-06','2022-09-08 18:27:35','2022-09-09 18:27:35','775',0.00,0.00,'775','2022-09-09 15:30:31','775','2022-09-11 17:25:31',10,0),('21','222',120,'DAILY SHIFT','2022-09-07','2022-09-11 17:29:51','2022-09-12 17:29:51','775',0.00,0.00,'775','2022-09-11 17:59:25','775','2022-09-11 18:02:24',10,0),('21','222',121,'2nd Shift from 05/09/2022','2022-09-05','2022-09-18 17:48:53','2022-09-19 17:48:53','775',0.00,0.00,'775','2022-09-18 18:11:12','775','2022-09-18 18:11:29',10,0),('21','222',122,'Daily shift','2022-09-09','2022-09-19 17:40:55','2022-09-20 17:40:55','775',0.00,0.00,'775','2022-09-19 18:11:11','775','2022-09-19 18:11:25',10,0),('21','222',123,'Daily shift','2022-09-10','2022-09-21 22:52:55','2022-09-22 22:52:55','775',0.00,0.00,'775','2022-09-21 23:10:33','775','2022-09-21 23:10:58',10,0),('21','222',124,'Daily shift','2022-09-11','2022-09-21 23:11:39','2022-09-22 23:11:39','775',0.00,0.00,'775','2022-09-21 23:54:12','775','2022-09-21 23:54:56',10,0),('21','222',125,'daily','2022-09-28','2022-09-28 07:30:33','2022-09-29 07:30:33','775',0.00,0.00,'775','2022-09-28 21:18:22','775','2022-09-29 08:50:19',10,0),('21','222',126,'daily','2022-09-29','2022-09-29 09:01:33','2022-09-30 09:01:33','775',0.00,0.00,'775','2022-09-29 20:51:36','775','2022-10-10 09:52:46',10,0),('21','222',127,'TRAINING','2022-10-10','2022-10-10 09:53:44','2022-10-11 09:53:44','775',0.00,0.00,'775','2022-10-10 11:14:21','775','2022-10-10 11:18:23',10,0),('21','222',128,'TRAINING','2022-10-10','2022-10-10 11:58:38','2022-10-11 11:58:38','775',0.00,0.00,'775','2022-10-12 09:23:45','775','2022-10-12 09:24:39',10,0),('21','222',129,'daily','2022-10-12','2022-10-12 09:25:12','2022-10-13 09:25:12','775',0.00,0.00,'775','2022-10-13 07:09:57','775','2022-10-13 07:12:01',10,0),('21','222',130,'daily','2022-10-13','2022-10-13 07:12:46','2022-10-14 07:12:46','775',0.00,0.00,'775','2022-10-14 07:37:49','775','2022-10-14 08:27:57',10,0),('21','222',131,'daily','2022-10-14','2022-10-14 08:28:53','2022-10-15 08:28:53','775',0.00,0.00,'775','2022-10-14 22:07:32','775','2022-10-15 08:55:20',10,0),('21','222',132,'daily','2022-10-15','2022-10-15 08:59:59','2022-10-16 08:59:59','775',0.00,0.00,'775','2022-10-15 19:56:15','775','2022-10-15 19:56:36',10,0),('21','222',133,'daily','2022-10-20','2022-10-20 19:09:38','2022-10-21 19:09:38','775',0.00,0.00,'775','2022-10-20 20:44:31','775','2022-10-20 20:45:11',10,0),('21','222',134,'daily','2022-10-21','2022-10-21 10:15:58','2022-10-22 10:15:58','775',0.00,0.00,'775','2022-10-21 20:44:53','775','2022-10-22 07:23:30',10,0),('21','222',135,'daily','2022-10-22','2022-10-22 07:24:09','2022-10-23 07:24:09','775',0.00,0.00,'775','2022-10-23 07:58:16','775','2022-10-23 07:58:49',10,0),('21','222',136,'daily','2022-10-23','2022-10-23 07:59:34','2022-10-24 07:59:34','775',0.00,0.00,'775','2022-10-23 17:53:38','775','2022-10-23 18:03:33',10,0),('21','222',137,'daily','2022-10-23','2022-10-23 18:03:52','2022-10-24 18:03:52','775',0.00,0.00,'775','2022-10-23 20:49:20','775','2022-10-24 06:59:18',10,0),('21','222',138,'daily','2022-10-24','2022-10-24 06:59:43','2022-10-25 06:59:43','775',0.00,0.00,'775','2022-10-24 20:40:54','775','2022-10-25 07:10:01',10,0),('21','222',139,'daily','2022-10-25','2022-10-25 07:10:42','2022-10-26 07:10:42','775',0.00,0.00,'775','2022-10-25 20:35:03','775','2022-10-26 09:48:24',10,0),('21','222',140,'daily','2022-10-26','2022-10-26 09:48:50','2022-10-27 09:48:50','775',0.00,0.00,'775','2022-10-26 20:49:58','775','2022-10-27 06:58:40',10,0),('21','222',141,'daily','2022-10-27','2022-10-27 06:59:09','2022-10-28 06:59:09','775',0.00,0.00,'775','2022-10-27 16:27:46','775','2022-10-27 17:57:02',10,0),('21','222',142,'daily','2022-10-27','2022-10-27 18:06:16','2022-10-28 18:06:16','775',0.00,0.00,'775','2022-10-27 21:07:17','775','2022-10-28 10:39:13',10,0),('21','222',143,'daily','2022-10-28','2022-10-28 10:46:49','2022-10-29 10:46:49','775',0.00,0.00,'775','2022-10-28 20:52:59','775','2022-10-29 07:46:35',10,0),('21','222',144,'daily','2022-10-29','2022-10-29 07:46:53','2022-10-30 07:46:53','775',0.00,0.00,'775','2022-10-29 20:42:28','775','2022-10-30 11:05:26',10,0),('21','222',145,'daily','2022-10-30','2022-10-30 11:05:55','2022-10-31 11:05:55','775',0.00,0.00,'775','2022-10-30 20:41:53','775','2022-10-31 09:24:04',10,0),('21','222',146,'daily','2022-10-31','2022-10-31 09:43:15','2022-11-01 09:43:15','775',0.00,0.00,'775','2022-11-01 18:15:12','775','2022-11-01 18:15:39',10,0),('21','222',147,'daily','2022-11-01','2022-11-01 18:16:34','2022-11-02 18:16:34','775',0.00,0.00,'775','2022-11-01 20:48:05','775','2022-11-02 10:01:37',10,0),('21','222',148,'daily','2022-11-02','2022-11-02 10:48:18','2022-11-03 10:48:18','775',0.00,0.00,'775','2022-11-02 20:34:59','775','2022-11-03 11:15:36',10,0),('21','222',149,'daily','2022-11-03','2022-11-03 11:18:26','2022-11-04 11:18:26','775',0.00,0.00,'775','2022-11-03 21:09:42','775','2022-11-04 10:23:14',10,0),('21','222',150,'daily','2022-11-04','2022-11-04 10:23:52','2022-11-05 10:23:52','775',0.00,0.00,'775','2022-11-04 19:09:02','775','2022-11-04 19:09:19',10,0),('21','222',151,'daily','2022-11-04','2022-11-04 19:21:26','2022-11-05 19:21:26','775',0.00,0.00,'775','2022-11-04 20:58:35','775','2022-11-05 10:27:17',10,0),('21','222',152,'daily','2022-11-05','2022-11-05 10:54:28','2022-11-06 10:54:28','775',0.00,0.00,'775','2022-11-05 20:29:24','775','2022-11-06 08:47:24',10,0),('21','222',153,'daily','2022-11-06','2022-11-06 08:47:52','2022-11-07 08:47:52','775',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=307 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','222','1','10',19,'1','1',974.78,1199.66,0.00,0.00,224.88,170908.80,0.00,0.00,0.00),('21','222','1','10',20,'2','1',10.00,135.66,0.00,0.00,125.66,95501.60,0.00,0.00,0.00),('21','222','1','11',21,'1','1',1199.66,1524.04,0.00,0.00,324.38,246528.80,0.00,0.00,0.00),('21','222','1','11',22,'2','1',135.66,298.37,0.00,0.00,162.71,123659.60,0.00,0.00,0.00),('21','222','1','12',23,'1','1',1524.04,2933.47,0.00,0.00,1409.43,1071166.80,0.00,0.00,0.00),('21','222','1','12',24,'2','1',298.37,557.29,0.00,0.00,258.92,196779.20,0.00,0.00,0.00),('21','222','1','13',25,'1','1',2933.47,4155.85,0.00,0.00,1222.38,929008.80,0.00,0.00,0.00),('21','222','1','13',26,'2','1',557.29,1171.20,0.00,0.00,613.91,466571.60,0.00,0.00,0.00),('21','222','1','14',27,'1','1',4155.85,5303.98,0.00,0.00,1148.13,872578.80,0.00,0.00,0.00),('21','222','1','14',28,'2','1',1171.20,1221.94,0.00,0.00,50.74,38562.40,0.00,0.00,0.00),('21','222','1','15',29,'1','1',5303.98,6108.85,0.00,0.00,804.87,611701.20,0.00,0.00,0.00),('21','222','1','15',30,'2','1',1221.94,1346.18,0.00,0.00,124.24,94422.40,0.00,0.00,0.00),('21','222','1','16',31,'1','1',6108.85,7256.37,0.00,0.00,1147.52,872115.20,0.00,0.00,0.00),('21','222','1','16',32,'2','1',1346.18,1656.13,0.00,0.00,309.95,235562.00,0.00,0.00,0.00),('21','222','1','17',33,'1','1',7256.37,8040.75,0.00,0.00,784.38,596128.80,0.00,0.00,0.00),('21','222','1','17',34,'2','1',1656.13,1920.13,0.00,0.00,264.00,200640.00,0.00,0.00,0.00),('21','222','1','18',35,'1','1',8040.75,9155.67,0.00,0.00,1114.92,847339.20,0.00,0.00,0.00),('21','222','1','18',36,'2','1',1920.13,2169.45,0.00,0.00,249.32,189483.20,0.00,0.00,0.00),('21','222','1','19',37,'1','1',9155.67,9440.86,0.00,0.00,285.19,216744.40,0.00,0.00,0.00),('21','222','1','19',38,'2','1',2169.45,2184.95,0.00,0.00,15.50,11780.00,0.00,0.00,0.00),('21','222','1','20',39,'1','1',9440.86,10508.05,0.00,0.00,1067.19,811064.40,0.00,0.00,0.00),('21','222','1','20',40,'2','1',2184.95,2270.93,0.00,0.00,85.98,65344.80,0.00,0.00,0.00),('21','222','1','21',41,'1','1',10508.05,11836.09,0.00,0.00,1328.04,1009310.40,0.00,0.00,0.00),('21','222','1','21',42,'2','1',2270.93,2289.72,0.00,0.00,18.79,14280.40,0.00,0.00,0.00),('21','222','1','22',43,'1','1',11836.09,12964.39,0.00,0.00,1128.30,857508.00,0.00,0.00,0.00),('21','222','1','22',44,'2','1',2289.72,2532.11,0.00,0.00,242.39,184216.40,0.00,0.00,0.00),('21','222','1','23',45,'1','1',12964.39,13910.54,0.00,0.00,946.15,719074.00,0.00,0.00,0.00),('21','222','1','23',46,'2','1',2532.11,3084.16,0.00,0.00,552.05,419558.00,0.00,0.00,0.00),('21','222','1','24',47,'1','1',13910.54,14521.75,0.00,0.00,611.21,464519.60,0.00,0.00,0.00),('21','222','1','24',48,'2','1',3084.16,4127.48,0.00,0.00,1043.32,792923.20,0.00,0.00,0.00),('21','222','1','25',49,'1','1',14521.75,14763.33,0.00,0.00,241.58,183600.80,0.00,0.00,0.00),('21','222','1','25',50,'2','1',4127.48,4362.48,0.00,0.00,235.00,178600.00,0.00,0.00,0.00),('21','222','1','26',51,'1','1',14763.33,15186.89,0.00,0.00,423.56,321905.60,0.00,0.00,0.00),('21','222','1','26',52,'2','1',4362.48,4659.92,0.00,0.00,297.44,226054.40,0.00,0.00,0.00),('21','222','1','27',53,'1','1',15186.89,16644.43,0.00,0.00,1457.54,1107730.40,0.00,0.00,0.00),('21','222','1','27',54,'2','1',4659.92,5634.33,0.00,0.00,974.41,740551.60,0.00,0.00,0.00),('21','222','1','28',55,'1','1',16644.43,17680.43,0.00,0.00,1036.00,787360.00,0.00,0.00,0.00),('21','222','1','28',56,'2','1',5634.33,5912.25,0.00,0.00,277.92,211219.20,0.00,0.00,0.00),('21','222','1','29',57,'1','1',17680.43,18174.67,0.00,0.00,494.24,375622.40,0.00,0.00,0.00),('21','222','1','29',58,'2','1',5912.25,6020.25,0.00,0.00,108.00,82080.00,0.00,0.00,0.00),('21','222','1','30',59,'1','1',18174.67,18386.38,0.00,0.00,211.71,160899.60,0.00,0.00,0.00),('21','222','1','30',60,'2','1',6020.25,6177.36,0.00,0.00,157.11,119403.60,0.00,0.00,0.00),('21','222','1','31',61,'1','1',18386.38,19196.11,0.00,0.00,809.73,615394.80,0.00,0.00,0.00),('21','222','1','31',62,'2','1',6177.36,6625.60,0.00,0.00,448.24,340662.40,0.00,0.00,0.00),('21','222','1','32',63,'1','1',19196.11,20190.46,0.00,0.00,994.35,755706.00,0.00,0.00,0.00),('21','222','1','32',64,'2','1',6625.60,7047.73,0.00,0.00,422.13,320818.80,0.00,0.00,0.00),('21','222','1','33',65,'1','1',20190.46,21039.34,0.00,0.00,848.88,645148.80,0.00,0.00,0.00),('21','222','1','33',66,'2','1',7047.73,7361.06,0.00,0.00,313.33,238130.80,0.00,0.00,0.00),('21','222','1','34',67,'1','1',21039.34,21561.26,0.00,0.00,521.92,396659.20,0.00,0.00,0.00),('21','222','1','34',68,'2','1',7361.06,7632.68,0.00,0.00,271.62,206431.20,0.00,0.00,0.00),('21','222','1','35',69,'1','1',21561.26,21886.66,0.00,0.00,325.40,247304.00,0.00,0.00,0.00),('21','222','1','35',70,'2','1',7632.68,7859.31,0.00,0.00,226.63,172238.80,0.00,0.00,0.00),('21','222','1','36',71,'1','1',21886.66,23517.73,0.00,0.00,1631.07,1239613.20,0.00,0.00,0.00),('21','222','1','36',72,'2','1',7859.31,8471.60,0.00,0.00,612.29,465340.40,0.00,0.00,0.00),('21','222','1','37',73,'1','1',23517.73,24669.61,0.00,0.00,1151.88,875428.80,0.00,0.00,0.00),('21','222','1','37',74,'2','1',8471.60,8567.73,0.00,0.00,96.13,73058.80,0.00,0.00,0.00),('21','222','1','38',75,'1','1',24669.61,25502.66,0.00,0.00,833.05,633118.00,0.00,0.00,0.00),('21','222','1','38',76,'2','1',8567.73,8690.23,0.00,0.00,122.50,93100.00,0.00,0.00,0.00),('21','222','1','39',77,'1','1',25502.66,25615.16,0.00,0.00,112.50,85500.00,0.00,0.00,0.00),('21','222','1','39',78,'2','1',8690.23,8996.62,0.00,0.00,306.39,232856.40,0.00,0.00,0.00),('21','222','1','40',79,'1','1',25615.16,26652.22,0.00,0.00,1037.06,788165.60,0.00,0.00,0.00),('21','222','1','40',80,'2','1',8996.62,9421.46,0.00,0.00,424.84,322878.40,0.00,0.00,0.00),('21','222','1','41',81,'1','1',26652.22,27504.25,0.00,0.00,852.03,647542.80,0.00,0.00,0.00),('21','222','1','41',82,'2','1',9421.46,10175.95,0.00,0.00,754.49,573412.40,0.00,0.00,0.00),('21','222','1','42',83,'1','1',27504.25,28456.41,0.00,0.00,952.16,723641.60,0.00,0.00,0.00),('21','222','1','42',84,'2','1',10175.95,10624.15,0.00,0.00,448.20,340632.00,0.00,0.00,0.00),('21','222','1','43',85,'1','1',28456.41,28506.41,0.00,0.00,50.00,38000.00,0.00,0.00,0.00),('21','222','1','43',86,'2','1',10624.15,10685.65,0.00,0.00,61.50,46740.00,0.00,0.00,0.00),('21','222','1','44',87,'1','1',28506.41,28919.14,0.00,0.00,412.73,313674.80,0.00,0.00,0.00),('21','222','1','44',88,'2','1',10685.65,10989.09,0.00,0.00,303.44,230614.40,0.00,0.00,0.00),('21','222','1','45',89,'1','1',28919.14,30834.50,0.00,0.00,1915.36,1455673.60,0.00,0.00,0.00),('21','222','1','45',90,'2','1',10989.09,11780.95,0.00,0.00,791.86,601813.60,0.00,0.00,0.00),('21','222','1','46',91,'1','1',30834.50,31805.04,0.00,0.00,970.54,737610.40,0.00,0.00,0.00),('21','222','1','46',92,'2','1',11780.95,11960.95,0.00,0.00,180.00,136800.00,0.00,0.00,0.00),('21','222','1','47',93,'1','1',31805.04,32611.22,0.00,0.00,806.18,612696.80,0.00,0.00,0.00),('21','222','1','47',94,'2','1',11960.95,11960.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','48',95,'1','1',32611.22,33080.16,0.00,0.00,468.94,356394.40,0.00,0.00,0.00),('21','222','1','48',96,'2','1',11960.95,12010.95,0.00,0.00,50.00,38000.00,0.00,0.00,0.00),('21','222','1','49',97,'1','1',33080.16,34445.56,0.00,0.00,1365.40,1037704.00,0.00,0.00,0.00),('21','222','1','49',98,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','50',99,'1','1',34445.56,35520.76,0.00,0.00,1075.20,817152.00,0.00,0.00,0.00),('21','222','1','50',100,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','51',101,'1','1',35520.76,35764.18,0.00,0.00,243.42,184999.20,0.00,0.00,0.00),('21','222','1','51',102,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','52',103,'1','1',35764.18,36093.52,0.00,0.00,329.34,250298.40,0.00,0.00,0.00),('21','222','1','52',104,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','53',105,'1','1',36093.52,38014.25,0.00,0.00,1920.73,1459754.80,0.00,0.00,0.00),('21','222','1','53',106,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','54',107,'1','1',38014.25,38014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','54',108,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','55',109,'1','1',38014.25,39705.88,0.00,0.00,1691.63,1285638.80,0.00,0.00,0.00),('21','222','1','55',110,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','56',111,'1','1',39705.88,40621.74,0.00,0.00,915.86,696053.60,0.00,0.00,0.00),('21','222','1','56',112,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','57',113,'1','1',40621.74,40764.50,0.00,0.00,142.76,108497.60,0.00,0.00,0.00),('21','222','1','57',114,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','58',115,'1','1',40764.50,41766.92,0.00,0.00,1002.42,761839.20,0.00,0.00,0.00),('21','222','1','58',116,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','59',117,'1','1',41766.92,42823.69,0.00,0.00,1056.77,803145.20,0.00,0.00,0.00),('21','222','1','59',118,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','60',119,'1','1',42823.69,44082.04,0.00,0.00,1258.35,956346.00,0.00,0.00,0.00),('21','222','1','60',120,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','61',121,'1','1',44082.04,45212.54,0.00,0.00,1130.50,859180.00,0.00,0.00,0.00),('21','222','1','61',122,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','62',123,'1','1',45212.54,45744.26,0.00,0.00,531.72,404107.20,0.00,0.00,0.00),('21','222','1','62',124,'2','1',12010.95,12010.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','63',125,'1','1',45744.26,47030.78,0.00,0.00,1286.52,977755.20,0.00,0.00,0.00),('21','222','1','63',126,'2','1',12010.95,12161.16,0.00,0.00,150.21,114159.60,0.00,0.00,0.00),('21','222','1','64',127,'1','1',47030.78,48007.09,0.00,0.00,976.31,741995.60,0.00,0.00,0.00),('21','222','1','64',128,'2','1',12161.16,12381.80,0.00,0.00,220.64,167686.40,0.00,0.00,0.00),('21','222','1','65',129,'1','1',48007.09,48920.89,0.00,0.00,913.80,694488.00,0.00,0.00,0.00),('21','222','1','65',130,'2','1',12381.80,12381.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','66',131,'1','1',48920.89,49952.14,0.00,0.00,1031.25,783750.00,0.00,0.00,0.00),('21','222','1','66',132,'2','1',12381.80,12426.25,0.00,0.00,44.45,33782.00,0.00,0.00,0.00),('21','222','1','67',133,'1','1',49952.14,50322.95,0.00,0.00,370.81,281815.60,0.00,0.00,0.00),('21','222','1','67',134,'2','1',12426.25,12431.51,0.00,0.00,5.26,3997.60,0.00,0.00,0.00),('21','222','1','68',135,'1','1',50322.95,52159.97,0.00,0.00,1837.02,1396135.20,0.00,0.00,0.00),('21','222','1','68',136,'2','1',12431.51,12792.80,0.00,0.00,361.29,274580.40,0.00,0.00,0.00),('21','222','1','69',137,'1','1',52159.97,53232.18,0.00,0.00,1072.21,814879.60,0.00,0.00,0.00),('21','222','1','69',138,'2','1',12792.80,12792.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','70',139,'1','1',53232.18,54230.94,0.00,0.00,998.76,759057.60,0.00,0.00,0.00),('21','222','1','70',140,'2','1',12792.80,12901.77,0.00,0.00,108.97,82817.20,0.00,0.00,0.00),('21','222','1','71',141,'1','1',54230.94,54790.17,0.00,0.00,559.23,425014.80,0.00,0.00,0.00),('21','222','1','71',142,'2','1',12901.77,12963.43,0.00,0.00,61.66,46861.60,0.00,0.00,0.00),('21','222','1','72',143,'1','1',54790.17,55541.72,0.00,0.00,751.55,571178.00,0.00,0.00,0.00),('21','222','1','72',144,'2','1',12963.43,13117.35,0.00,0.00,153.92,116979.20,0.00,0.00,0.00),('21','222','1','73',145,'1','1',55541.72,56224.93,0.00,0.00,683.21,519239.60,0.00,0.00,0.00),('21','222','1','73',146,'2','1',13117.35,13562.03,0.00,0.00,444.68,337956.80,0.00,0.00,0.00),('21','222','1','74',147,'1','1',56224.93,57711.65,0.00,0.00,1486.72,1129907.20,0.00,0.00,0.00),('21','222','1','74',148,'2','1',13562.03,13649.03,0.00,0.00,87.00,66120.00,0.00,0.00,0.00),('21','222','1','75',149,'1','1',57711.65,58647.30,0.00,0.00,935.65,711094.00,0.00,0.00,0.00),('21','222','1','75',150,'2','1',13649.03,14106.15,0.00,0.00,457.12,347411.20,0.00,0.00,0.00),('21','222','1','76',151,'1','1',58647.30,59475.12,0.00,0.00,827.82,629143.20,0.00,0.00,0.00),('21','222','1','76',152,'2','1',14106.15,14218.65,0.00,0.00,112.50,85500.00,0.00,0.00,0.00),('21','222','1','77',153,'1','1',59475.12,60669.76,0.00,0.00,1194.64,907926.40,0.00,0.00,0.00),('21','222','1','77',154,'2','1',14218.65,14414.65,0.00,0.00,196.00,148960.00,0.00,0.00,0.00),('21','222','1','78',155,'1','1',60669.76,61496.94,0.00,0.00,827.18,628656.80,0.00,0.00,0.00),('21','222','1','78',156,'2','1',14414.65,14969.40,0.00,0.00,554.75,421610.00,0.00,0.00,0.00),('21','222','1','79',157,'1','1',61496.94,62446.77,0.00,0.00,949.83,721870.80,0.00,0.00,0.00),('21','222','1','79',158,'2','1',14969.40,15164.41,0.00,0.00,195.01,148207.60,0.00,0.00,0.00),('21','222','1','80',159,'1','1',62446.77,62754.02,0.00,0.00,307.25,233510.00,0.00,0.00,0.00),('21','222','1','80',160,'2','1',15164.41,15189.41,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('21','222','1','81',161,'1','1',62754.02,63559.41,0.00,0.00,805.39,612096.40,0.00,0.00,0.00),('21','222','1','81',162,'2','1',15189.41,15226.41,0.00,0.00,37.00,28120.00,0.00,0.00,0.00),('21','222','1','82',163,'1','1',63559.41,64666.07,0.00,0.00,1106.66,841061.60,0.00,0.00,0.00),('21','222','1','82',164,'2','1',15226.41,15541.91,0.00,0.00,315.50,239780.00,0.00,0.00,0.00),('21','222','1','83',165,'1','1',64666.07,66189.71,0.00,0.00,1523.64,1157966.40,0.00,0.00,0.00),('21','222','1','83',166,'2','1',15541.91,15713.73,0.00,0.00,171.82,130583.20,0.00,0.00,0.00),('21','222','1','84',167,'1','1',66189.71,67054.40,0.00,0.00,864.69,657164.40,0.00,0.00,0.00),('21','222','1','84',168,'2','1',15713.73,15888.13,0.00,0.00,174.40,132544.00,0.00,0.00,0.00),('21','222','1','85',169,'1','1',67054.40,67682.37,0.00,0.00,627.97,477257.20,0.00,0.00,0.00),('21','222','1','85',170,'2','1',15888.13,15963.13,0.00,0.00,75.00,57000.00,0.00,0.00,0.00),('21','222','1','86',171,'1','1',67682.37,68365.32,0.00,0.00,682.95,519042.00,0.00,0.00,0.00),('21','222','1','86',172,'2','1',15963.13,16236.94,0.00,0.00,273.81,208095.60,0.00,0.00,0.00),('21','222','1','87',173,'1','1',68365.32,69565.82,0.00,0.00,1200.50,912380.00,0.00,0.00,0.00),('21','222','1','87',174,'2','1',16236.94,16454.21,0.00,0.00,217.27,165125.20,0.00,0.00,0.00),('21','222','1','88',175,'1','1',69565.82,70785.92,0.00,0.00,1220.10,927276.00,0.00,0.00,0.00),('21','222','1','88',176,'2','1',16454.21,16472.71,0.00,0.00,18.50,14060.00,0.00,0.00,0.00),('21','222','1','89',177,'1','1',70785.92,70979.16,0.00,0.00,193.24,146862.40,0.00,0.00,0.00),('21','222','1','89',178,'2','1',16472.71,16564.16,0.00,0.00,91.45,69502.00,0.00,0.00,0.00),('21','222','1','90',179,'1','1',70979.16,71742.84,0.00,0.00,763.68,580396.80,0.00,0.00,0.00),('21','222','1','90',180,'2','1',16564.16,16564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','91',181,'1','1',71742.84,72562.44,0.00,0.00,819.60,622896.00,0.00,0.00,0.00),('21','222','1','91',182,'2','1',16564.16,16682.66,0.00,0.00,118.50,90060.00,0.00,0.00,0.00),('21','222','1','92',183,'1','1',72562.44,73896.49,0.00,0.00,1334.05,1013878.00,0.00,0.00,0.00),('21','222','1','92',184,'2','1',16682.66,17078.82,0.00,0.00,396.16,301081.60,0.00,0.00,0.00),('21','222','1','93',185,'1','1',73896.49,75495.36,0.00,0.00,1598.87,1215141.20,0.00,0.00,0.00),('21','222','1','93',186,'2','1',17078.82,17217.82,0.00,0.00,139.00,105640.00,0.00,0.00,0.00),('21','222','1','94',187,'1','1',75495.36,76494.31,0.00,0.00,998.95,759202.00,0.00,0.00,0.00),('21','222','1','94',188,'2','1',17217.82,17505.18,0.00,0.00,287.36,218393.60,0.00,0.00,0.00),('21','222','1','95',189,'1','1',76494.31,77601.41,0.00,0.00,1107.10,841396.00,0.00,0.00,0.00),('21','222','1','95',190,'2','1',17505.18,18034.50,0.00,0.00,529.32,402283.20,0.00,0.00,0.00),('21','222','1','96',191,'1','1',77601.41,78919.18,0.00,0.00,1317.77,1001505.20,0.00,0.00,0.00),('21','222','1','96',192,'2','1',18034.50,18243.10,0.00,0.00,208.60,158536.00,0.00,0.00,0.00),('21','222','1','97',193,'1','1',78919.18,79688.54,0.00,0.00,769.36,584713.60,0.00,0.00,0.00),('21','222','1','97',194,'2','1',18243.10,18353.60,0.00,0.00,110.50,83980.00,0.00,0.00,0.00),('21','222','1','98',195,'1','1',79688.54,79943.57,0.00,0.00,255.03,193822.80,0.00,0.00,0.00),('21','222','1','98',196,'2','1',18353.60,18521.10,0.00,0.00,167.50,127300.00,0.00,0.00,0.00),('21','222','1','99',197,'1','1',79943.57,80754.64,0.00,0.00,811.07,616413.20,0.00,0.00,0.00),('21','222','1','99',198,'2','1',18521.10,18997.38,0.00,0.00,476.28,361972.80,0.00,0.00,0.00),('21','222','1','100',199,'1','1',80754.64,82007.11,0.00,0.00,1252.47,951877.20,0.00,0.00,0.00),('21','222','1','100',200,'2','1',18997.38,19197.38,0.00,0.00,200.00,152000.00,0.00,0.00,0.00),('21','222','1','101',201,'1','1',82007.11,83667.34,0.00,0.00,1660.23,1261774.80,0.00,0.00,0.00),('21','222','1','101',202,'2','1',19197.38,19374.46,0.00,0.00,177.08,134580.80,0.00,0.00,0.00),('21','222','1','102',203,'1','1',83667.34,83779.18,0.00,0.00,111.84,84998.40,0.00,0.00,0.00),('21','222','1','102',204,'2','1',19374.46,19374.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','103',205,'1','1',83779.18,84594.24,0.00,0.00,815.06,619445.60,0.00,0.00,0.00),('21','222','1','103',206,'2','1',19374.46,19579.06,0.00,0.00,204.60,155496.00,0.00,0.00,0.00),('21','222','1','104',207,'1','1',84594.24,85571.05,0.00,0.00,976.81,742375.60,0.00,0.00,0.00),('21','222','1','104',208,'2','1',19579.06,19803.60,0.00,0.00,224.54,170650.40,0.00,0.00,0.00),('21','222','1','105',209,'1','1',85571.05,86784.27,0.00,0.00,1213.22,922047.20,0.00,0.00,0.00),('21','222','1','105',210,'2','1',19803.60,19920.86,0.00,0.00,117.26,89117.60,0.00,0.00,0.00),('21','222','1','106',211,'1','1',86784.27,88102.43,0.00,0.00,1318.16,1001801.60,0.00,0.00,0.00),('21','222','1','106',212,'2','1',19920.86,19938.62,0.00,0.00,17.76,13497.60,0.00,0.00,0.00),('21','222','1','107',213,'1','1',88102.43,88968.65,0.00,0.00,866.22,658327.20,0.00,0.00,0.00),('21','222','1','107',214,'2','1',19938.62,20166.62,0.00,0.00,228.00,173280.00,0.00,0.00,0.00),('21','222','1','108',215,'1','1',88968.65,90487.07,0.00,0.00,1518.42,1153999.20,0.00,0.00,0.00),('21','222','1','108',216,'2','1',20166.62,20755.81,0.00,0.00,589.19,447784.40,0.00,0.00,0.00),('21','222','1','109',217,'1','1',90487.07,91922.90,0.00,0.00,1435.83,1091230.80,0.00,0.00,0.00),('21','222','1','109',218,'2','1',20755.81,21117.10,0.00,0.00,361.29,274580.40,0.00,0.00,0.00),('21','222','1','110',219,'1','1',91922.90,92692.57,0.00,0.00,769.67,572634.48,0.00,0.00,0.00),('21','222','1','110',220,'2','1',21117.10,21566.84,0.00,0.00,449.74,334606.56,0.00,0.00,0.00),('21','222','1','111',221,'1','1',92692.57,93463.62,0.00,0.00,771.05,573661.20,0.00,0.00,0.00),('21','222','1','111',222,'2','1',21566.84,21903.99,0.00,0.00,337.15,250839.60,0.00,0.00,0.00),('21','222','1','112',223,'1','1',93463.62,94438.60,0.00,0.00,974.98,725385.12,0.00,0.00,0.00),('21','222','1','112',224,'2','1',21903.99,22224.95,0.00,0.00,320.96,238794.24,0.00,0.00,0.00),('21','222','1','113',225,'1','1',94438.60,94438.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','113',226,'2','1',22224.95,22234.95,0.00,0.00,10.00,7440.00,0.00,0.00,0.00),('21','222','1','114',227,'1','1',94438.60,95719.35,0.00,0.00,1280.75,952878.00,0.00,0.00,0.00),('21','222','1','114',228,'2','1',22234.95,22320.25,0.00,0.00,85.30,63463.20,0.00,0.00,0.00),('21','222','1','115',229,'1','1',95719.35,97427.94,0.00,0.00,1708.59,1271190.96,0.00,0.00,0.00),('21','222','1','115',230,'2','1',22320.25,22506.75,0.00,0.00,186.50,138756.00,0.00,0.00,0.00),('21','222','1','116',231,'1','1',97427.94,97538.70,0.00,0.00,110.76,82405.44,0.00,0.00,0.00),('21','222','1','116',232,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','117',233,'1','1',97538.70,99821.54,0.00,0.00,2282.84,1698432.96,0.00,0.00,0.00),('21','222','1','117',234,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','118',235,'1','1',99821.54,100533.90,0.00,0.00,712.36,529995.84,0.00,0.00,0.00),('21','222','1','118',236,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','119',237,'1','1',100533.90,101893.91,0.00,0.00,1360.01,1011847.44,0.00,0.00,0.00),('21','222','1','119',238,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','120',239,'1','1',101893.91,103045.51,0.00,0.00,1151.60,856790.40,0.00,0.00,0.00),('21','222','1','120',240,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','121',241,'1','1',103045.51,103552.89,0.00,0.00,507.38,377490.72,0.00,0.00,0.00),('21','222','1','121',242,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','122',243,'1','1',103552.89,105395.38,0.00,0.00,1842.49,1370812.56,0.00,0.00,0.00),('21','222','1','122',244,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','123',245,'1','1',105395.38,106373.06,0.00,0.00,977.68,727393.92,0.00,0.00,0.00),('21','222','1','123',246,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','124',247,'1','1',106373.06,108567.76,0.00,0.00,2194.70,1632856.80,0.00,0.00,0.00),('21','222','1','124',248,'2','1',22506.75,22506.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','125',249,'1','1',108567.76,109900.20,0.00,0.00,1332.44,991335.36,0.00,0.00,0.00),('21','222','1','125',250,'2','1',22506.75,22785.07,0.00,0.00,278.32,207070.08,0.00,0.00,0.00),('21','222','1','126',251,'1','1',109900.20,110792.62,0.00,0.00,892.42,663960.48,0.00,0.00,0.00),('21','222','1','126',252,'2','1',22785.07,22994.45,0.00,0.00,209.38,155778.72,0.00,0.00,0.00),('21','222','1','127',253,'1','1',110792.62,110884.32,0.00,0.00,91.70,68224.80,0.00,0.00,0.00),('21','222','1','127',254,'2','1',22994.45,23059.20,0.00,0.00,64.75,48174.00,0.00,0.00,0.00),('21','222','1','128',255,'1','1',110884.32,110884.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','128',256,'2','1',23059.20,23059.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','222','1','129',257,'1','1',110884.32,111496.31,0.00,0.00,611.99,455320.56,0.00,0.00,0.00),('21','222','1','129',258,'2','1',23059.20,23978.97,0.00,0.00,919.77,684308.88,0.00,0.00,0.00),('21','222','1','130',259,'1','1',111496.31,111943.78,0.00,0.00,447.47,332917.68,0.00,0.00,0.00),('21','222','1','130',260,'2','1',23978.97,24637.87,0.00,0.00,658.90,490221.60,0.00,0.00,0.00),('21','222','1','131',261,'1','1',111943.78,112533.44,0.00,0.00,589.66,438707.04,0.00,0.00,0.00),('21','222','1','131',262,'2','1',24637.87,25065.37,0.00,0.00,427.50,318060.00,0.00,0.00,0.00),('21','222','1','132',263,'1','1',112533.44,113089.60,0.00,0.00,556.16,413783.04,0.00,0.00,0.00),('21','222','1','132',264,'2','1',25065.37,26047.08,0.00,0.00,981.71,730392.24,0.00,0.00,0.00),('21','222','1','133',265,'1','1',113089.60,113453.25,0.00,0.00,363.65,270555.60,0.00,0.00,0.00),('21','222','1','133',266,'2','1',26047.08,26722.51,0.00,0.00,675.43,502519.92,0.00,0.00,0.00),('21','222','1','134',267,'1','1',113453.25,114472.93,0.00,0.00,1019.68,758641.92,0.00,0.00,0.00),('21','222','1','134',268,'2','1',26722.51,27127.70,0.00,0.00,405.19,301461.36,0.00,0.00,0.00),('21','222','1','135',269,'1','1',114472.93,115202.66,0.00,0.00,729.73,554594.80,0.00,0.00,0.00),('21','222','1','135',270,'2','1',27127.70,28275.22,0.00,0.00,1147.52,872115.20,0.00,0.00,0.00),('21','222','1','136',271,'1','1',115202.66,115471.77,0.00,0.00,269.11,204523.60,0.00,0.00,0.00),('21','222','1','136',272,'2','1',28275.22,28774.72,0.00,0.00,499.50,379620.00,0.00,0.00,0.00),('21','222','1','137',273,'1','1',115471.77,115953.95,0.00,0.00,482.18,366456.80,0.00,0.00,0.00),('21','222','1','137',274,'2','1',28774.72,29151.36,0.00,0.00,376.64,286246.40,0.00,0.00,0.00),('21','222','1','138',275,'1','1',115953.95,117283.55,0.00,0.00,1329.60,1010496.00,0.00,0.00,0.00),('21','222','1','138',276,'2','1',29151.36,29627.36,0.00,0.00,476.00,361760.00,0.00,0.00,0.00),('21','222','1','139',277,'1','1',117283.55,117907.59,0.00,0.00,624.04,474270.40,0.00,0.00,0.00),('21','222','1','139',278,'2','1',29627.36,30025.53,0.00,0.00,398.17,302609.20,0.00,0.00,0.00),('21','222','1','140',279,'1','1',117907.59,118669.36,0.00,0.00,761.77,578945.20,0.00,0.00,0.00),('21','222','1','140',280,'2','1',30025.53,30358.38,0.00,0.00,332.85,252966.00,0.00,0.00,0.00),('21','222','1','141',281,'1','1',118669.36,118949.68,0.00,0.00,280.32,213043.20,0.00,0.00,0.00),('21','222','1','141',282,'2','1',30358.38,30466.33,0.00,0.00,107.95,82042.00,0.00,0.00,0.00),('21','222','1','142',283,'1','1',118949.68,119164.81,0.00,0.00,215.13,163498.80,0.00,0.00,0.00),('21','222','1','142',284,'2','1',30466.33,30611.80,0.00,0.00,145.47,110557.20,0.00,0.00,0.00),('21','222','1','143',285,'1','1',119164.81,119907.07,0.00,0.00,742.26,564117.60,0.00,0.00,0.00),('21','222','1','143',286,'2','1',30611.80,30716.59,0.00,0.00,104.79,79640.40,0.00,0.00,0.00),('21','222','1','144',287,'1','1',119907.07,120745.29,0.00,0.00,838.22,637047.20,0.00,0.00,0.00),('21','222','1','144',288,'2','1',30716.59,31168.04,0.00,0.00,451.45,343102.00,0.00,0.00,0.00),('21','222','1','145',289,'1','1',120745.29,121897.39,0.00,0.00,1152.10,875596.00,0.00,0.00,0.00),('21','222','1','145',290,'2','1',31168.04,32408.34,0.00,0.00,1240.30,942628.00,0.00,0.00,0.00),('21','222','1','146',291,'1','1',121897.39,122083.39,0.00,0.00,186.00,141360.00,0.00,0.00,0.00),('21','222','1','146',292,'2','1',32408.34,32468.34,0.00,0.00,60.00,45600.00,0.00,0.00,0.00),('21','222','1','147',293,'1','1',122083.39,122803.33,0.00,0.00,719.94,547154.40,0.00,0.00,0.00),('21','222','1','147',294,'2','1',32468.34,33545.81,0.00,0.00,1077.47,818877.20,0.00,0.00,0.00),('21','222','1','148',295,'1','1',122803.33,123505.74,0.00,0.00,702.41,533831.60,0.00,0.00,0.00),('21','222','1','148',296,'2','1',33545.81,34105.19,0.00,0.00,559.38,425128.80,0.00,0.00,0.00),('21','222','1','149',297,'1','1',123505.74,124306.25,0.00,0.00,800.51,608387.60,0.00,0.00,0.00),('21','222','1','149',298,'2','1',34105.19,34648.36,0.00,0.00,543.17,412809.20,0.00,0.00,0.00),('21','222','1','150',299,'1','1',124306.25,124755.25,0.00,0.00,449.00,341240.00,0.00,0.00,0.00),('21','222','1','150',300,'2','1',34648.36,34931.36,0.00,0.00,283.00,215080.00,0.00,0.00,0.00),('21','222','1','151',301,'1','1',124755.25,125185.07,0.00,0.00,429.82,326663.20,0.00,0.00,0.00),('21','222','1','151',302,'2','1',34931.36,35022.11,0.00,0.00,90.75,68970.00,0.00,0.00,0.00),('21','222','1','152',303,'1','1',125185.07,126113.95,0.00,0.00,928.88,705948.80,0.00,0.00,0.00),('21','222','1','152',304,'2','1',35022.11,35259.11,0.00,0.00,237.00,180120.00,0.00,0.00,0.00),('21','222','1','153',305,'1','1',126113.95,0.00,0.00,0.00,144.00,109440.00,0.00,0.00,0.00),('21','222','1','153',306,'2','1',35259.11,0.00,0.00,0.00,73.92,56179.20,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','222','10','1',760.00,760.00,0.00,350.54,266410.40,266410.40,0.00,10),('21','222','11','1',760.00,760.00,0.00,487.09,370188.40,370188.40,0.00,11),('21','222','12','1',760.00,760.00,0.00,1668.35,1267946.00,1267946.00,0.00,12),('21','222','13','1',760.00,760.00,0.00,1836.29,1395580.40,1395580.40,0.00,13),('21','222','14','1',760.00,760.00,0.00,1198.87,911141.20,911141.20,0.00,14),('21','222','15','1',5110.00,760.00,0.00,929.11,4747752.10,706123.60,-4041628.50,15),('21','222','16','1',5110.00,760.00,0.00,1457.47,2536391.20,1107677.20,-1428714.00,16),('21','222','17','1',760.00,760.00,0.00,1048.38,796768.80,796768.80,0.00,17),('21','222','18','1',760.00,760.00,0.00,1364.24,1036822.40,1036822.40,0.00,18),('21','222','19','1',760.00,760.00,0.00,300.69,228524.40,228524.40,0.00,19),('21','222','20','1',760.00,760.00,0.00,1153.17,876409.20,876409.20,0.00,20),('21','222','21','1',760.00,760.00,0.00,1346.83,1023590.80,1023590.80,0.00,21),('21','222','22','1',760.00,760.00,0.00,1370.69,1041724.40,1041724.40,0.00,22),('21','222','23','1',760.00,760.00,0.00,1498.20,1138632.00,1138632.00,0.00,23),('21','222','24','1',760.00,760.00,0.00,1654.53,1257442.80,1257442.80,0.00,24),('21','222','25','1',760.00,760.00,0.00,476.58,362200.80,362200.80,0.00,25),('21','222','26','1',760.00,760.00,0.00,721.00,547960.00,547960.00,0.00,26),('21','222','27','1',760.00,760.00,0.00,2431.95,1848282.00,1848282.00,0.00,27),('21','222','28','1',760.00,760.00,0.00,1313.92,998579.20,998579.20,0.00,28),('21','222','29','1',760.00,760.00,0.00,602.24,457702.40,457702.40,0.00,29),('21','222','30','1',760.00,760.00,0.00,368.82,280303.20,280303.20,0.00,30),('21','222','31','1',760.00,760.00,0.00,1257.97,956057.20,956057.20,0.00,31),('21','222','32','1',760.00,760.00,0.00,1416.48,1076524.80,1076524.80,0.00,32),('21','222','33','1',760.00,760.00,0.00,1162.21,883279.60,883279.60,0.00,33),('21','222','34','1',760.00,760.00,0.00,793.54,603090.40,603090.40,0.00,34),('21','222','35','1',760.00,760.00,0.00,552.03,419542.80,419542.80,0.00,35),('21','222','36','1',760.00,760.00,0.00,2243.36,1704953.60,1704953.60,0.00,36),('21','222','37','1',760.00,760.00,0.00,1248.01,948487.60,948487.60,0.00,37),('21','222','38','1',760.00,760.00,0.00,955.55,726218.00,726218.00,0.00,38),('21','222','39','1',760.00,760.00,0.00,418.89,318356.40,318356.40,0.00,39),('21','222','40','1',760.00,760.00,0.00,1461.90,1111044.00,1111044.00,0.00,40),('21','222','41','1',760.00,760.00,0.00,1606.52,1220955.20,1220955.20,0.00,41),('21','222','42','1',760.00,760.00,0.00,1400.36,1064273.60,1064273.60,0.00,42),('21','222','43','1',760.00,760.00,0.00,111.50,84740.00,84740.00,0.00,43),('21','222','44','1',760.00,760.00,0.00,716.17,544289.20,544289.20,0.00,44),('21','222','45','1',760.00,760.00,0.00,2707.22,2057487.20,2057487.20,0.00,45),('21','222','46','1',760.00,760.00,0.00,1150.54,874410.40,874410.40,0.00,46),('21','222','47','1',760.00,760.00,0.00,806.18,612696.80,612696.80,0.00,47),('21','222','48','1',760.00,760.00,0.00,518.94,394394.40,394394.40,0.00,48),('21','222','49','1',760.00,760.00,0.00,1365.40,1037704.00,1037704.00,0.00,49),('21','222','50','1',760.00,760.00,0.00,1075.20,817152.00,817152.00,0.00,50),('21','222','51','1',760.00,760.00,0.00,243.42,184999.20,184999.20,0.00,51),('21','222','52','1',760.00,760.00,0.00,329.34,250298.40,250298.40,0.00,52),('21','222','53','1',760.00,760.00,0.00,1920.73,1459754.80,1459754.80,0.00,53),('21','222','54','1',760.00,760.00,0.00,0.00,0.00,0.00,0.00,54),('21','222','55','1',760.00,760.00,0.00,1691.63,1285638.80,1285638.80,0.00,55),('21','222','56','1',760.00,760.00,0.00,915.86,696053.60,696053.60,0.00,56),('21','222','57','1',760.00,760.00,0.00,142.76,108497.60,108497.60,0.00,57),('21','222','58','1',760.00,760.00,0.00,1002.42,761839.20,761839.20,0.00,58),('21','222','59','1',760.00,760.00,0.00,1056.77,803145.20,803145.20,0.00,59),('21','222','60','1',760.00,760.00,0.00,1258.35,956346.00,956346.00,0.00,60),('21','222','61','1',760.00,760.00,0.00,1130.50,859180.00,859180.00,0.00,61),('21','222','62','1',760.00,760.00,0.00,531.72,404107.20,404107.20,0.00,62),('21','222','63','1',760.00,760.00,0.00,1436.73,1091914.80,1091914.80,0.00,63),('21','222','64','1',760.00,760.00,0.00,1196.95,909682.00,909682.00,0.00,64),('21','222','65','1',760.00,760.00,0.00,913.80,694488.00,694488.00,0.00,65),('21','222','66','1',760.00,760.00,0.00,1075.70,817532.00,817532.00,0.00,66),('21','222','67','1',760.00,760.00,0.00,376.07,285813.20,285813.20,0.00,67),('21','222','68','1',760.00,760.00,0.00,2198.31,1670715.60,1670715.60,0.00,68),('21','222','69','1',760.00,760.00,0.00,1072.21,814879.60,814879.60,0.00,69),('21','222','70','1',760.00,760.00,0.00,1107.73,841874.80,841874.80,0.00,70),('21','222','71','1',760.00,760.00,0.00,620.89,471876.40,471876.40,0.00,71),('21','222','72','1',760.00,760.00,0.00,905.47,688157.20,688157.20,0.00,72),('21','222','73','1',760.00,760.00,0.00,1127.89,857196.40,857196.40,0.00,73),('21','222','74','1',760.00,760.00,0.00,1573.72,1196027.20,1196027.20,0.00,74),('21','222','75','1',760.00,760.00,0.00,1392.77,1058505.20,1058505.20,0.00,75),('21','222','76','1',760.00,760.00,0.00,940.32,714643.20,714643.20,0.00,76),('21','222','77','1',760.00,760.00,0.00,1390.64,1056886.40,1056886.40,0.00,77),('21','222','78','1',760.00,760.00,0.00,1381.93,1050266.80,1050266.80,0.00,78),('21','222','79','1',760.00,760.00,0.00,1144.84,870078.40,870078.40,0.00,79),('21','222','80','1',760.00,760.00,0.00,332.25,252510.00,252510.00,0.00,80),('21','222','81','1',760.00,760.00,0.00,842.39,640216.40,640216.40,0.00,81),('21','222','82','1',760.00,760.00,0.00,1422.16,1080841.60,1080841.60,0.00,82),('21','222','83','1',760.00,760.00,0.00,1695.46,1288549.60,1288549.60,0.00,83),('21','222','84','1',760.00,760.00,0.00,1039.09,789708.40,789708.40,0.00,84),('21','222','85','1',760.00,760.00,0.00,702.97,534257.20,534257.20,0.00,85),('21','222','86','1',760.00,760.00,0.00,956.76,727137.60,727137.60,0.00,86),('21','222','87','1',760.00,760.00,0.00,1417.77,1077505.20,1077505.20,0.00,87),('21','222','88','1',760.00,760.00,0.00,1238.60,941336.00,941336.00,0.00,88),('21','222','89','1',760.00,760.00,0.00,284.69,216364.40,216364.40,0.00,89),('21','222','90','1',760.00,760.00,0.00,763.68,580396.80,580396.80,0.00,90),('21','222','91','1',760.00,760.00,0.00,938.10,712956.00,712956.00,0.00,91),('21','222','92','1',760.00,760.00,0.00,1730.21,1314959.60,1314959.60,0.00,92),('21','222','93','1',760.00,760.00,0.00,1737.87,1320781.20,1320781.20,0.00,93),('21','222','94','1',760.00,760.00,0.00,1286.31,977595.60,977595.60,0.00,94),('21','222','95','1',760.00,760.00,0.00,1636.42,1243679.20,1243679.20,0.00,95),('21','222','96','1',760.00,760.00,0.00,1526.37,1160041.20,1160041.20,0.00,96),('21','222','97','1',760.00,760.00,0.00,879.86,668693.60,668693.60,0.00,97),('21','222','98','1',760.00,760.00,0.00,422.53,321122.80,321122.80,0.00,98),('21','222','99','1',760.00,760.00,0.00,1287.35,978386.00,978386.00,0.00,99),('21','222','100','1',760.00,760.00,0.00,1452.47,1103877.20,1103877.20,0.00,100),('21','222','101','1',760.00,760.00,0.00,1837.31,1396355.60,1396355.60,0.00,101),('21','222','102','1',760.00,760.00,0.00,111.84,84998.40,84998.40,0.00,102),('21','222','103','1',760.00,760.00,0.00,1019.66,774941.60,774941.60,0.00,103),('21','222','104','1',760.00,760.00,0.00,1201.35,913026.00,913026.00,0.00,104),('21','222','105','1',760.00,760.00,0.00,1330.48,1011164.80,1011164.80,0.00,105),('21','222','106','1',760.00,760.00,0.00,1335.92,1015299.20,1015299.20,0.00,106),('21','222','107','1',760.00,760.00,0.00,1094.22,831607.20,831607.20,0.00,107),('21','222','108','1',760.00,760.00,0.00,2107.61,1601783.60,1601783.60,0.00,108),('21','222','109','1',760.00,760.00,0.00,1797.12,1365811.20,1365811.20,0.00,109),('21','222','110','1',760.00,760.00,0.00,1219.41,907241.04,907241.04,0.00,110),('21','222','111','1',744.00,744.00,0.00,1108.20,824500.80,824500.80,0.00,111),('21','222','112','1',744.00,744.00,0.00,1295.94,964179.36,964179.36,0.00,112),('21','222','113','1',744.00,744.00,0.00,10.00,7440.00,7440.00,0.00,113),('21','222','114','1',744.00,744.00,0.00,1366.05,1016341.20,1016341.20,0.00,114),('21','222','115','1',744.00,744.00,0.00,1895.09,1409946.96,1409946.96,0.00,115),('21','222','116','1',744.00,744.00,0.00,110.76,82405.44,82405.44,0.00,116),('21','222','117','1',744.00,744.00,0.00,2282.84,1698432.96,1698432.96,0.00,117),('21','222','118','1',744.00,744.00,0.00,712.36,529995.84,529995.84,0.00,118),('21','222','119','1',744.00,744.00,0.00,1360.01,1011847.44,1011847.44,0.00,119),('21','222','120','1',744.00,744.00,0.00,1151.60,856790.40,856790.40,0.00,120),('21','222','121','1',744.00,744.00,0.00,507.38,377490.72,377490.72,0.00,121),('21','222','122','1',744.00,744.00,0.00,1842.49,1370812.56,1370812.56,0.00,122),('21','222','123','1',744.00,744.00,0.00,977.68,727393.92,727393.92,0.00,123),('21','222','124','1',744.00,744.00,0.00,2194.70,1632856.80,1632856.80,0.00,124),('21','222','125','1',744.00,744.00,0.00,1610.76,1198405.44,1198405.44,0.00,125),('21','222','126','1',744.00,744.00,0.00,1101.80,819739.20,819739.20,0.00,126),('21','222','127','1',744.00,744.00,0.00,156.45,116398.80,116398.80,0.00,127),('21','222','128','1',744.00,744.00,0.00,0.00,0.00,0.00,0.00,128),('21','222','129','1',744.00,744.00,0.00,1531.76,1139629.44,1139629.44,0.00,129),('21','222','130','1',744.00,744.00,0.00,1106.37,823139.28,823139.28,0.00,130),('21','222','131','1',744.00,744.00,0.00,1017.16,756767.04,756767.04,0.00,131),('21','222','132','1',744.00,744.00,0.00,1537.87,1144175.28,1144175.28,0.00,132),('21','222','133','1',744.00,744.00,0.00,1039.08,773075.52,773075.52,0.00,133),('21','222','134','1',744.00,744.00,0.00,1424.87,1060103.28,1060103.28,0.00,134),('21','222','135','1',744.00,744.00,0.00,1877.25,1426710.00,1426710.00,0.00,135),('21','222','136','1',760.00,760.00,0.00,768.61,584143.60,584143.60,0.00,136),('21','222','137','1',760.00,760.00,0.00,858.82,652703.20,652703.20,0.00,137),('21','222','138','1',760.00,760.00,0.00,1805.60,1372256.00,1372256.00,0.00,138),('21','222','139','1',760.00,760.00,0.00,1022.21,776879.60,776879.60,0.00,139),('21','222','140','1',760.00,760.00,0.00,1094.62,831911.20,831911.20,0.00,140),('21','222','141','1',760.00,760.00,0.00,388.27,295085.20,295085.20,0.00,141),('21','222','142','1',760.00,760.00,0.00,360.60,274056.00,274056.00,0.00,142),('21','222','143','1',760.00,760.00,0.00,847.05,643758.00,643758.00,0.00,143),('21','222','144','1',760.00,760.00,0.00,1289.67,980149.20,980149.20,0.00,144),('21','222','145','1',760.00,760.00,0.00,2392.40,1818224.00,1818224.00,0.00,145),('21','222','146','1',760.00,760.00,0.00,246.00,186960.00,186960.00,0.00,146),('21','222','147','1',760.00,760.00,0.00,1797.41,1366031.60,1366031.60,0.00,147),('21','222','148','1',760.00,760.00,0.00,1261.79,958960.40,958960.40,0.00,148),('21','222','149','1',760.00,760.00,0.00,1343.68,1021196.80,1021196.80,0.00,149),('21','222','150','1',760.00,760.00,0.00,732.00,556320.00,556320.00,0.00,150),('21','222','151','1',760.00,760.00,0.00,520.57,395633.20,395633.20,0.00,151),('21','222','152','1',760.00,760.00,0.00,1165.88,886068.80,886068.80,0.00,152),('21','222','153','1',760.00,760.00,0.00,217.92,165619.20,165619.20,0.00,153);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'222','LPG PRODUCT TANKS','TANKS CONTAINING LPG PRODUCTS');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','222','1',1,1,'1','LPG TANK',5000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT.','764','2022-03-04 00:15:40','2022-03-04 00:15:40','764',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=11383 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (68,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,922419.60,1213.71,0.00,0.00,'2022-06-02 09:31:28','',''),(69,'21','222',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,1213.71,0.00,'2022-06-02 09:35:53','',''),(70,'21','222','1',1,'Received from bridging 7',0.00,0.00,1213.71,0.00,0.00,'2022-06-02 09:35:53','',''),(71,'21','222','1',1,'Retail Sale Id 36',2280.00,0.00,0.00,3.00,0.00,'2022-06-02 09:41:17','',''),(72,'21','222','1',1,'Retail Sale Id 36',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 09:41:17','',''),(73,'21','222','1',1,'Retail Sale Id 36',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 09:41:17','',''),(74,'21','222','1',1,'Retail Sale Id 37',1003.20,0.00,0.00,1.32,0.00,'2022-06-02 10:04:24','',''),(75,'21','222','1',1,'Retail Sale Id 37',1520.00,0.00,0.00,2.00,0.00,'2022-06-02 10:04:24','',''),(76,'21','222','1',1,'Retail Sale Id 37',3002.00,0.00,0.00,3.95,0.00,'2022-06-02 10:04:24','',''),(77,'21','222','1',1,'Retail Sale Id 37',3002.00,0.00,0.00,3.95,0.00,'2022-06-02 10:04:24','',''),(78,'21','222','1',1,'Retail Sale Id 37',3800.00,0.00,0.00,5.00,0.00,'2022-06-02 10:04:24','',''),(79,'21','222','1',1,'Retail Sale Id 37',3800.00,0.00,0.00,5.00,0.00,'2022-06-02 10:04:24','',''),(80,'21','222','1',1,'Retail Sale Id 37',4560.00,0.00,0.00,6.00,0.00,'2022-06-02 10:04:24','',''),(81,'21','222','1',1,'Retail Sale Id 37',5996.40,0.00,0.00,7.89,0.00,'2022-06-02 10:04:24','',''),(82,'21','222','1',1,'Retail Sale Id 37',6999.60,0.00,0.00,9.21,0.00,'2022-06-02 10:04:24','',''),(83,'21','222','1',1,'Retail Sale Id 37',6999.60,0.00,0.00,9.21,0.00,'2022-06-02 10:04:24','',''),(84,'21','222','1',1,'Retail Sale Id 37',6999.60,0.00,0.00,9.21,0.00,'2022-06-02 10:04:24','',''),(85,'21','222','1',1,'Retail Sale Id 37',8998.40,0.00,0.00,11.84,0.00,'2022-06-02 10:04:24','',''),(86,'21','222','1',1,'Retail Sale Id 37',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 10:04:24','',''),(87,'21','222','1',1,'Retail Sale Id 37',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 10:04:24','',''),(88,'21','222','1',1,'Retail Sale Id 37',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 10:04:24','',''),(89,'21','222','1',1,'Retail Sale Id 37',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 10:04:24','',''),(90,'21','222','1',1,'Retail Sale Id 37',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 10:04:24','',''),(91,'21','222','1',1,'Retail Sale Id 38',4149.60,0.00,0.00,5.46,0.00,'2022-06-02 10:48:24','',''),(92,'21','222','1',1,'Retail Sale Id 38',7600.00,0.00,0.00,10.00,0.00,'2022-06-02 10:48:24','',''),(93,'21','222','1',1,'Retail Sale Id 38',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 10:48:24','',''),(94,'21','222','1',1,'Retail Sale Id 38',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 10:48:24','',''),(95,'21','222','1',1,'Retail Sale Id 38',15200.00,0.00,0.00,20.00,0.00,'2022-06-02 10:48:24','',''),(96,'21','222','1',1,'Retail Sale Id 38',19000.00,0.00,0.00,25.00,0.00,'2022-06-02 10:48:24','',''),(97,'21','222','1',1,'Retail Sale Id 38',38000.00,0.00,0.00,50.00,0.00,'2022-06-02 10:48:24','',''),(98,'21','222','1',1,'Retail Sale Id 38',38000.00,0.00,0.00,50.00,0.00,'2022-06-02 10:48:24','',''),(99,'21','222','1',1,'Retail Sale Id 39',798.00,0.00,0.00,1.05,0.00,'2022-06-02 22:27:21','',''),(100,'21','222','1',1,'Retail Sale Id 39',896.80,0.00,0.00,1.18,0.00,'2022-06-02 22:27:21','',''),(101,'21','222','1',1,'Retail Sale Id 39',1497.20,0.00,0.00,1.97,0.00,'2022-06-02 22:27:21','',''),(102,'21','222','1',1,'Retail Sale Id 39',1497.20,0.00,0.00,1.97,0.00,'2022-06-02 22:27:21','',''),(103,'21','222','1',1,'Retail Sale Id 39',1497.20,0.00,0.00,1.97,0.00,'2022-06-02 22:27:21','',''),(104,'21','222','1',1,'Retail Sale Id 39',1998.80,0.00,0.00,2.63,0.00,'2022-06-02 22:27:21','',''),(105,'21','222','1',1,'Retail Sale Id 39',1998.80,0.00,0.00,2.63,0.00,'2022-06-02 22:27:21','',''),(106,'21','222','1',1,'Retail Sale Id 39',2280.00,0.00,0.00,3.00,0.00,'2022-06-02 22:27:21','',''),(107,'21','222','1',1,'Retail Sale Id 39',2280.00,0.00,0.00,3.00,0.00,'2022-06-02 22:27:21','',''),(108,'21','222','1',1,'Retail Sale Id 39',2280.00,0.00,0.00,3.00,0.00,'2022-06-02 22:27:21','',''),(109,'21','222','1',1,'Retail Sale Id 39',2302.80,0.00,0.00,3.03,0.00,'2022-06-02 22:27:21','',''),(110,'21','222','1',1,'Retail Sale Id 39',3002.00,0.00,0.00,3.95,0.00,'2022-06-02 22:27:21','',''),(111,'21','222','1',1,'Retail Sale Id 39',3503.60,0.00,0.00,4.61,0.00,'2022-06-02 22:27:21','',''),(112,'21','222','1',1,'Retail Sale Id 39',3800.00,0.00,0.00,5.00,0.00,'2022-06-02 22:27:21','',''),(113,'21','222','1',1,'Retail Sale Id 39',3800.00,0.00,0.00,5.00,0.00,'2022-06-02 22:27:21','',''),(114,'21','222','1',1,'Retail Sale Id 39',3800.00,0.00,0.00,5.00,0.00,'2022-06-02 22:27:21','',''),(115,'21','222','1',1,'Retail Sale Id 39',3800.00,0.00,0.00,5.00,0.00,'2022-06-02 22:27:21','',''),(116,'21','222','1',1,'Retail Sale Id 39',3997.60,0.00,0.00,5.26,0.00,'2022-06-02 22:27:21','',''),(117,'21','222','1',1,'Retail Sale Id 39',3997.60,0.00,0.00,5.26,0.00,'2022-06-02 22:27:21','',''),(118,'21','222','1',1,'Retail Sale Id 39',3997.60,0.00,0.00,5.26,0.00,'2022-06-02 22:27:21','',''),(119,'21','222','1',1,'Retail Sale Id 39',3997.60,0.00,0.00,5.26,0.00,'2022-06-02 22:27:21','',''),(120,'21','222','1',1,'Retail Sale Id 39',3997.60,0.00,0.00,5.26,0.00,'2022-06-02 22:27:21','',''),(121,'21','222','1',1,'Retail Sale Id 39',4096.40,0.00,0.00,5.39,0.00,'2022-06-02 22:27:21','',''),(122,'21','222','1',1,'Retail Sale Id 39',4560.00,0.00,0.00,6.00,0.00,'2022-06-02 22:27:21','',''),(123,'21','222','1',1,'Retail Sale Id 39',4560.00,0.00,0.00,6.00,0.00,'2022-06-02 22:27:21','',''),(124,'21','222','1',1,'Retail Sale Id 39',4560.00,0.00,0.00,6.00,0.00,'2022-06-02 22:27:21','',''),(125,'21','222','1',1,'Retail Sale Id 39',4750.00,0.00,0.00,6.25,0.00,'2022-06-02 22:27:21','',''),(126,'21','222','1',1,'Retail Sale Id 39',5502.40,0.00,0.00,7.24,0.00,'2022-06-02 22:27:21','',''),(127,'21','222','1',1,'Retail Sale Id 39',5996.40,0.00,0.00,7.89,0.00,'2022-06-02 22:27:21','',''),(128,'21','222','1',1,'Retail Sale Id 39',6080.00,0.00,0.00,8.00,0.00,'2022-06-02 22:27:21','',''),(129,'21','222','1',1,'Retail Sale Id 39',6999.60,0.00,0.00,9.21,0.00,'2022-06-02 22:27:21','',''),(130,'21','222','1',1,'Retail Sale Id 39',7501.20,0.00,0.00,9.87,0.00,'2022-06-02 22:27:21','',''),(131,'21','222','1',1,'Retail Sale Id 39',7600.00,0.00,0.00,10.00,0.00,'2022-06-02 22:27:21','',''),(132,'21','222','1',1,'Retail Sale Id 39',7600.00,0.00,0.00,10.00,0.00,'2022-06-02 22:27:21','',''),(133,'21','222','1',1,'Retail Sale Id 39',7600.00,0.00,0.00,10.00,0.00,'2022-06-02 22:27:21','',''),(134,'21','222','1',1,'Retail Sale Id 39',8360.00,0.00,0.00,11.00,0.00,'2022-06-02 22:27:21','',''),(135,'21','222','1',1,'Retail Sale Id 39',8360.00,0.00,0.00,11.00,0.00,'2022-06-02 22:27:21','',''),(136,'21','222','1',1,'Retail Sale Id 39',8398.00,0.00,0.00,11.05,0.00,'2022-06-02 22:27:21','',''),(137,'21','222','1',1,'Retail Sale Id 39',8496.80,0.00,0.00,11.18,0.00,'2022-06-02 22:27:21','',''),(138,'21','222','1',1,'Retail Sale Id 39',8998.40,0.00,0.00,11.84,0.00,'2022-06-02 22:27:21','',''),(139,'21','222','1',1,'Retail Sale Id 39',8998.40,0.00,0.00,11.84,0.00,'2022-06-02 22:27:21','',''),(140,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(141,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(142,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(143,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(144,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(145,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(146,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(147,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(148,'21','222','1',1,'Retail Sale Id 39',9500.00,0.00,0.00,12.50,0.00,'2022-06-02 22:27:21','',''),(149,'21','222','1',1,'Retail Sale Id 39',36001.20,0.00,0.00,47.37,0.00,'2022-06-02 22:27:21','',''),(150,'21','222','1',1,'Retail Sale Id 39',38000.00,0.00,0.00,50.00,0.00,'2022-06-02 22:27:21','',''),(151,'21','222','1',1,'Retail Sale Id 40',20649.20,0.00,0.00,27.17,0.00,'2022-06-02 22:59:42','',''),(152,'21','222','1',1,'Retail Sale Id 41',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 07:43:23','',''),(153,'21','222','1',1,'Retail Sale Id 42',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 07:52:17','',''),(154,'21','222','1',1,'Retail Sale Id 43',8998.40,0.00,0.00,11.84,0.00,'2022-06-03 07:56:06','',''),(155,'21','222','1',1,'Retail Sale Id 44',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 07:59:29','',''),(156,'21','222','1',1,'Retail Sale Id 46',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:08:03','',''),(157,'21','222','1',1,'Retail Sale Id 47',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:12:26','',''),(158,'21','222','1',1,'Retail Sale Id 48',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:16:03','',''),(159,'21','222','1',1,'Retail Sale Id 49',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 08:19:47','',''),(160,'21','222','1',1,'Retail Sale Id 50',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 08:23:40','',''),(161,'21','222','1',1,'Retail Sale Id 51',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:27:02','',''),(162,'21','222','1',1,'Retail Sale Id 52',3002.00,0.00,0.00,3.95,0.00,'2022-06-03 08:28:57','',''),(163,'21','222','1',1,'Retail Sale Id 53',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:31:31','',''),(164,'21','222','1',1,'Retail Sale Id 54',3002.00,0.00,0.00,3.95,0.00,'2022-06-03 08:33:49','',''),(165,'21','222','1',1,'Retail Sale Id 55',1998.80,0.00,0.00,2.63,0.00,'2022-06-03 08:45:26','',''),(166,'21','222','1',1,'Retail Sale Id 56',1497.20,0.00,0.00,1.97,0.00,'2022-06-03 08:46:35','',''),(167,'21','222','1',1,'Retail Sale Id 57',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:47:37','',''),(168,'21','222','1',1,'Retail Sale Id 58',13300.00,0.00,0.00,17.50,0.00,'2022-06-03 08:50:40','',''),(169,'21','222','1',1,'Retail Sale Id 59',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:52:11','',''),(170,'21','222','1',1,'Retail Sale Id 60',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:53:43','',''),(171,'21','222','1',1,'Retail Sale Id 61',4940.00,0.00,0.00,6.50,0.00,'2022-06-03 08:55:10','',''),(172,'21','222','1',1,'Retail Sale Id 62',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 08:59:14','',''),(173,'21','222','1',1,'Retail Sale Id 63',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 09:02:12','',''),(174,'21','222','1',1,'Retail Sale Id 64',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 09:06:02','',''),(175,'21','222','1',1,'Retail Sale Id 65',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 09:09:35','',''),(176,'21','222','1',1,'Retail Sale Id 67',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 09:12:43','',''),(177,'21','222','1',1,'Retail Sale Id 68',760.00,0.00,0.00,1.00,0.00,'2022-06-03 09:15:42','',''),(178,'21','222','1',1,'Retail Sale Id 69',6999.60,0.00,0.00,9.21,0.00,'2022-06-03 09:19:18','',''),(179,'21','222','1',1,'Retail Sale Id 70',19000.00,0.00,0.00,25.00,0.00,'2022-06-03 09:26:54','',''),(180,'21','222','1',1,'Retail Sale Id 71',760.00,0.00,0.00,1.00,0.00,'2022-06-03 09:29:02','',''),(181,'21','222','1',1,'Retail Sale Id 72',760.00,0.00,0.00,1.00,0.00,'2022-06-03 09:31:13','',''),(182,'21','222','1',1,'Retail Sale Id 73',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 09:33:29','',''),(183,'21','222','1',1,'Retail Sale Id 74',7600.00,0.00,0.00,10.00,0.00,'2022-06-03 09:35:59','',''),(184,'21','222','1',1,'Retail Sale Id 75',19000.00,0.00,0.00,25.00,0.00,'2022-06-03 09:38:54','',''),(185,'21','222','1',1,'Retail Sale Id 76',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 09:42:46','',''),(186,'21','222','1',1,'Retail Sale Id 77',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 09:48:32','',''),(187,'21','222','1',1,'Retail Sale Id 79',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 09:49:57','',''),(188,'21','222','1',1,'Retail Sale Id 80',3997.60,0.00,0.00,5.26,0.00,'2022-06-03 09:52:34','',''),(189,'21','222','1',1,'Retail Sale Id 81',600.40,0.00,0.00,0.79,0.00,'2022-06-03 09:53:56','',''),(190,'21','222','1',1,'Retail Sale Id 82',1900.00,0.00,0.00,2.50,0.00,'2022-06-03 09:56:12','',''),(191,'21','222','1',1,'Retail Sale Id 83',798.00,0.00,0.00,1.05,0.00,'2022-06-03 10:00:13','',''),(192,'21','222','1',1,'Retail Sale Id 84',3002.00,0.00,0.00,3.95,0.00,'2022-06-03 10:01:47','',''),(193,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3822800.00,5030.00,0.00,0.00,'2022-06-03 12:04:05','',''),(194,'21','222',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,4997.52,0.00,'2022-06-03 12:10:15','',''),(195,'21','222','1',1,'Received from bridging 8',0.00,0.00,4997.52,0.00,0.00,'2022-06-03 12:10:15','',''),(196,'21','222','1',1,'Retail Sale Id 85',3002.00,0.00,0.00,3.95,0.00,'2022-06-03 12:13:56','',''),(197,'21','222','1',1,'Retail Sale Id 86',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 12:18:21','',''),(198,'21','222','1',1,'Retail Sale Id 88',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 12:22:01','',''),(199,'21','222','1',1,'Retail Sale Id 89',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 12:24:44','',''),(200,'21','222','1',1,'Retail Sale Id 90',1998.80,0.00,0.00,2.63,0.00,'2022-06-03 12:26:33','',''),(201,'21','222','1',1,'Retail Sale Id 91',3503.60,0.00,0.00,4.61,0.00,'2022-06-03 12:28:44','',''),(202,'21','222','1',1,'Retail Sale Id 92',19000.00,0.00,0.00,25.00,0.00,'2022-06-03 12:32:47','',''),(203,'21','222','1',1,'Retail Sale Id 93',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 12:38:23','',''),(204,'21','222','1',1,'Retail Sale Id 94',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 12:41:17','',''),(205,'21','222','1',1,'Retail Sale Id 95',6999.60,0.00,0.00,9.21,0.00,'2022-06-03 12:44:34','',''),(206,'21','222','1',1,'Retail Sale Id 96',3040.00,0.00,0.00,4.00,0.00,'2022-06-03 12:49:09','',''),(207,'21','222','1',1,'Retail Sale Id 96',3040.00,0.00,0.00,4.00,0.00,'2022-06-03 12:49:09','',''),(208,'21','222','1',1,'Retail Sale Id 98',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 12:53:15','',''),(209,'21','222','1',1,'Retail Sale Id 99',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 12:54:56','',''),(210,'21','222','1',1,'Retail Sale Id 100',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 13:05:08','',''),(211,'21','222','1',1,'Retail Sale Id 101',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 13:07:57','',''),(212,'21','222','1',1,'Retail Sale Id 102',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 13:10:10','',''),(213,'21','222','1',1,'Retail Sale Id 103',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 13:12:23','',''),(214,'21','222','1',1,'Retail Sale Id 103',8496.80,0.00,0.00,11.18,0.00,'2022-06-03 13:12:23','',''),(215,'21','222','1',1,'Retail Sale Id 104',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 13:14:34','',''),(216,'21','222','1',1,'Retail Sale Id 105',4750.00,0.00,0.00,6.25,0.00,'2022-06-03 13:16:19','',''),(217,'21','222','1',1,'Retail Sale Id 106',1003.20,0.00,0.00,1.32,0.00,'2022-06-03 13:20:38','',''),(218,'21','222','1',1,'Retail Sale Id 107',1497.20,0.00,0.00,1.97,0.00,'2022-06-03 13:22:41','',''),(219,'21','222','1',1,'Retail Sale Id 108',34998.00,0.00,0.00,46.05,0.00,'2022-06-03 13:25:07','',''),(220,'21','222','1',1,'Retail Sale Id 109',3997.60,0.00,0.00,5.26,0.00,'2022-06-03 13:27:06','',''),(221,'21','222','1',1,'Retail Sale Id 110',1998.80,0.00,0.00,2.63,0.00,'2022-06-03 13:41:41','',''),(222,'21','222','1',1,'Retail Sale Id 111',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 13:43:35','',''),(223,'21','222','1',1,'Retail Sale Id 112',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 13:45:07','',''),(224,'21','222','1',1,'Retail Sale Id 113',8702.00,0.00,0.00,11.45,0.00,'2022-06-03 13:57:47','',''),(225,'21','222','1',1,'Retail Sale Id 114',798.00,0.00,0.00,1.05,0.00,'2022-06-03 14:15:05','',''),(226,'21','222','1',1,'Retail Sale Id 115',15200.00,0.00,0.00,20.00,0.00,'2022-06-03 14:16:38','',''),(227,'21','222','1',1,'Retail Sale Id 117',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 14:21:06','',''),(228,'21','222','1',1,'Retail Sale Id 118',5000.80,0.00,0.00,6.58,0.00,'2022-06-03 14:25:59','',''),(229,'21','222','1',1,'Retail Sale Id 119',1998.80,0.00,0.00,2.63,0.00,'2022-06-03 14:27:26','',''),(230,'21','222','1',1,'Retail Sale Id 120',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 14:32:08','',''),(231,'21','222','1',1,'Retail Sale Id 121',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 14:33:37','',''),(232,'21','222','1',1,'Retail Sale Id 122',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 14:35:23','',''),(233,'21','222','1',1,'Retail Sale Id 123',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 14:37:35','',''),(234,'21','222','1',1,'Retail Sale Id 124',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 14:39:45','',''),(235,'21','222','1',1,'Retail Sale Id 125',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 14:45:22','',''),(236,'21','222','1',1,'Retail Sale Id 126',8002.80,0.00,0.00,10.53,0.00,'2022-06-03 14:50:26','',''),(237,'21','222','1',1,'Retail Sale Id 127',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 14:51:58','',''),(238,'21','222','1',1,'Retail Sale Id 128',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 14:53:23','',''),(239,'21','222','1',1,'Retail Sale Id 129',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 14:54:52','',''),(240,'21','222','1',1,'Retail Sale Id 130',798.00,0.00,0.00,1.05,0.00,'2022-06-03 14:56:27','',''),(241,'21','222','1',1,'Retail Sale Id 131',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 14:58:17','',''),(242,'21','222','1',1,'Retail Sale Id 132',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 15:00:06','',''),(243,'21','222','1',1,'Retail Sale Id 133',5000.80,0.00,0.00,6.58,0.00,'2022-06-03 15:02:06','',''),(244,'21','222','1',1,'Retail Sale Id 134',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 15:10:55','',''),(245,'21','222','1',1,'Retail Sale Id 135',3002.00,0.00,0.00,3.95,0.00,'2022-06-03 15:12:58','',''),(246,'21','222','1',1,'Retail Sale Id 136',5000.80,0.00,0.00,6.58,0.00,'2022-06-03 15:19:22','',''),(247,'21','222','1',1,'Retail Sale Id 137',3997.60,0.00,0.00,5.26,0.00,'2022-06-03 15:21:34','',''),(248,'21','222','1',1,'Retail Sale Id 138',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 15:23:31','',''),(249,'21','222','1',1,'Retail Sale Id 139',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 15:26:05','',''),(250,'21','222','1',1,'Retail Sale Id 140',3040.00,0.00,0.00,4.00,0.00,'2022-06-03 15:27:30','',''),(251,'21','222','1',1,'Retail Sale Id 141',6999.60,0.00,0.00,9.21,0.00,'2022-06-03 15:33:48','',''),(252,'21','222','1',1,'Retail Sale Id 142',501.60,0.00,0.00,0.66,0.00,'2022-06-03 15:35:32','',''),(253,'21','222','1',1,'Retail Sale Id 143',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 15:37:35','',''),(254,'21','222','1',1,'Retail Sale Id 144',1520.00,0.00,0.00,2.00,0.00,'2022-06-03 15:40:13','',''),(255,'21','222','1',1,'Retail Sale Id 146',8496.80,0.00,0.00,11.18,0.00,'2022-06-03 15:44:28','',''),(256,'21','222','1',1,'Retail Sale Id 147',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 15:47:07','',''),(257,'21','222','1',1,'Retail Sale Id 148',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 15:49:40','',''),(258,'21','222','1',1,'Retail Sale Id 150',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 15:53:45','',''),(259,'21','222','1',1,'Retail Sale Id 151',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 15:56:44','',''),(260,'21','222','1',1,'Retail Sale Id 152',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 15:59:47','',''),(261,'21','222','1',1,'Retail Sale Id 153',6840.00,0.00,0.00,9.00,0.00,'2022-06-03 16:01:57','',''),(262,'21','222','1',1,'Retail Sale Id 154',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 16:04:36','',''),(263,'21','222','1',1,'Retail Sale Id 155',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 16:09:39','',''),(264,'21','222','1',1,'Retail Sale Id 156',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:11:44','',''),(265,'21','222','1',1,'Retail Sale Id 157',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 16:14:21','',''),(266,'21','222','1',1,'Retail Sale Id 158',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 16:17:00','',''),(267,'21','222','1',1,'Retail Sale Id 160',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:20:40','',''),(268,'21','222','1',1,'Retail Sale Id 161',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:22:58','',''),(269,'21','222','1',1,'Retail Sale Id 162',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:29:11','',''),(270,'21','222','1',1,'Retail Sale Id 163',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:31:04','',''),(271,'21','222','1',1,'Retail Sale Id 164',4499.20,0.00,0.00,5.92,0.00,'2022-06-03 16:33:54','',''),(272,'21','222','1',1,'Retail Sale Id 165',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:36:03','',''),(273,'21','222','1',1,'Retail Sale Id 166',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:37:39','',''),(274,'21','222','1',1,'Retail Sale Id 167',7600.00,0.00,0.00,10.00,0.00,'2022-06-03 16:40:20','',''),(275,'21','222','1',1,'Retail Sale Id 168',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:45:24','',''),(276,'21','222','1',1,'Retail Sale Id 169',8496.80,0.00,0.00,11.18,0.00,'2022-06-03 16:48:48','',''),(277,'21','222','1',1,'Retail Sale Id 170',4750.00,0.00,0.00,6.25,0.00,'2022-06-03 16:52:01','',''),(278,'21','222','1',1,'Retail Sale Id 171',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 16:53:41','',''),(279,'21','222','1',1,'Retail Sale Id 172',7600.00,0.00,0.00,10.00,0.00,'2022-06-03 16:56:25','',''),(280,'21','222','1',1,'Retail Sale Id 173',3997.60,0.00,0.00,5.26,0.00,'2022-06-03 16:58:33','',''),(281,'21','222','1',1,'Retail Sale Id 174',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 17:11:43','',''),(282,'21','222','1',1,'Retail Sale Id 175',1998.80,0.00,0.00,2.63,0.00,'2022-06-03 17:13:36','',''),(283,'21','222','1',1,'Retail Sale Id 176',1497.20,0.00,0.00,1.97,0.00,'2022-06-03 17:16:26','',''),(284,'21','222','1',1,'Retail Sale Id 177',1998.80,0.00,0.00,2.63,0.00,'2022-06-03 17:18:34','',''),(285,'21','222','1',1,'Retail Sale Id 178',798.00,0.00,0.00,1.05,0.00,'2022-06-03 17:20:48','',''),(286,'21','222','1',1,'Retail Sale Id 179',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 17:43:51','',''),(287,'21','222','1',1,'Retail Sale Id 180',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 17:47:58','',''),(288,'21','222','1',1,'Retail Sale Id 180',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 17:47:58','',''),(289,'21','222','1',1,'Retail Sale Id 181',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 17:50:49','',''),(290,'21','222','1',1,'Retail Sale Id 182',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 17:53:22','',''),(291,'21','222','1',1,'Retail Sale Id 183',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 17:55:10','',''),(292,'21','222','1',1,'Retail Sale Id 184',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 17:57:32','',''),(293,'21','222','1',1,'Retail Sale Id 185',1998.80,0.00,0.00,2.63,0.00,'2022-06-03 18:03:22','',''),(294,'21','222','1',1,'Retail Sale Id 186',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 18:08:41','',''),(295,'21','222','1',1,'Retail Sale Id 187',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 18:11:02','',''),(296,'21','222','1',1,'Retail Sale Id 188',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 18:13:54','',''),(297,'21','222','1',1,'Retail Sale Id 189',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 18:16:58','',''),(298,'21','222','1',1,'Retail Sale Id 190',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 18:18:40','',''),(299,'21','222','1',1,'Retail Sale Id 191',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 18:22:23','',''),(300,'21','222','1',1,'Retail Sale Id 192',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 18:25:33','',''),(301,'21','222','1',1,'Retail Sale Id 193',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 18:28:10','',''),(302,'21','222','1',1,'Retail Sale Id 194',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 18:30:14','',''),(303,'21','222','1',1,'Retail Sale Id 195',6999.60,0.00,0.00,9.21,0.00,'2022-06-03 18:32:22','',''),(304,'21','222','1',1,'Retail Sale Id 196',1998.80,0.00,0.00,2.63,0.00,'2022-06-03 18:33:43','',''),(305,'21','222','1',1,'Retail Sale Id 197',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 18:35:24','',''),(306,'21','222','1',1,'Retail Sale Id 198',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 18:37:09','',''),(307,'21','222','1',1,'Retail Sale Id 199',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 18:43:27','',''),(308,'21','222','1',1,'Retail Sale Id 199',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 18:43:27','',''),(309,'21','222','1',1,'Retail Sale Id 201',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 18:46:15','',''),(310,'21','222','1',1,'Retail Sale Id 202',4202.80,0.00,0.00,5.53,0.00,'2022-06-03 18:50:19','',''),(311,'21','222','1',1,'Retail Sale Id 203',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 19:12:02','',''),(312,'21','222','1',1,'Retail Sale Id 204',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 19:14:19','',''),(313,'21','222','1',1,'Retail Sale Id 205',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 19:16:47','',''),(314,'21','222','1',1,'Retail Sale Id 206',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 19:23:18','',''),(315,'21','222','1',1,'Retail Sale Id 207',8496.80,0.00,0.00,11.18,0.00,'2022-06-03 19:26:30','',''),(316,'21','222','1',1,'Retail Sale Id 208',798.00,0.00,0.00,1.05,0.00,'2022-06-03 19:28:35','',''),(317,'21','222','1',1,'Retail Sale Id 209',8496.80,0.00,0.00,11.18,0.00,'2022-06-03 19:34:37','',''),(318,'21','222','1',1,'Retail Sale Id 210',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 19:36:19','',''),(319,'21','222','1',1,'Retail Sale Id 211',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 19:39:11','',''),(320,'21','222','1',1,'Retail Sale Id 212',1520.00,0.00,0.00,2.00,0.00,'2022-06-03 19:46:21','',''),(321,'21','222','1',1,'Retail Sale Id 213',1003.20,0.00,0.00,1.32,0.00,'2022-06-03 19:48:44','',''),(322,'21','222','1',1,'Retail Sale Id 214',4560.00,0.00,0.00,6.00,0.00,'2022-06-03 19:54:51','',''),(323,'21','222','1',1,'Retail Sale Id 215',1200.80,0.00,0.00,1.58,0.00,'2022-06-03 19:56:58','',''),(324,'21','222','1',1,'Retail Sale Id 216',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 20:00:34','',''),(325,'21','222','1',1,'Retail Sale Id 217',2280.00,0.00,0.00,3.00,0.00,'2022-06-03 20:02:47','',''),(326,'21','222','1',1,'Retail Sale Id 218',3800.00,0.00,0.00,5.00,0.00,'2022-06-03 20:04:39','',''),(327,'21','222','1',1,'Retail Sale Id 219',1497.20,0.00,0.00,1.97,0.00,'2022-06-03 20:06:13','',''),(328,'21','222','1',1,'Retail Sale Id 220',1003.20,0.00,0.00,1.32,0.00,'2022-06-03 20:07:39','',''),(329,'21','222','1',1,'Retail Sale Id 221',9500.00,0.00,0.00,12.50,0.00,'2022-06-03 20:10:40','',''),(330,'21','222','1',1,'Retail Sale Id 222',3002.00,0.00,0.00,3.95,0.00,'2022-06-03 20:15:35','',''),(331,'21','222','1',1,'Retail Sale Id 223',38000.00,0.00,0.00,50.00,0.00,'2022-06-03 21:20:28','',''),(332,'21','222','1',1,'Retail Sale Id 223',38000.00,0.00,0.00,50.00,0.00,'2022-06-03 21:20:28','',''),(333,'21','222','1',1,'Retail Sale Id 224',15200.00,0.00,0.00,20.00,0.00,'2022-06-03 21:23:19','',''),(334,'21','222','1',1,'Retail Sale Id 224',19000.00,0.00,0.00,25.00,0.00,'2022-06-03 21:23:19','',''),(335,'21','222','1',1,'Retail Sale Id 225',53200.00,0.00,0.00,70.00,0.00,'2022-06-03 21:24:57','',''),(336,'21','222','1',1,'Retail Sale Id 226',18650.40,0.00,0.00,24.54,0.00,'2022-06-03 21:27:40','',''),(337,'21','222','1',1,'Retail Sale Id 226',30400.00,0.00,0.00,40.00,0.00,'2022-06-03 21:27:40','',''),(338,'21','222','1',1,'Retail Sale Id 227',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 08:26:49','',''),(339,'21','222','1',1,'Retail Sale Id 228',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 08:28:53','',''),(340,'21','222','1',1,'Retail Sale Id 229',7600.00,0.00,0.00,10.00,0.00,'2022-06-04 08:31:28','',''),(341,'21','222','1',1,'Retail Sale Id 230',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 08:33:17','',''),(342,'21','222','1',1,'Retail Sale Id 231',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 08:35:44','',''),(343,'21','222','1',1,'Retail Sale Id 231',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 08:35:44','',''),(344,'21','222','1',1,'Retail Sale Id 232',38000.00,0.00,0.00,50.00,0.00,'2022-06-04 08:37:54','',''),(345,'21','222','1',1,'Retail Sale Id 233',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 08:41:17','',''),(346,'21','222','1',1,'Retail Sale Id 235',3997.60,0.00,0.00,5.26,0.00,'2022-06-04 08:52:02','',''),(347,'21','222','1',1,'Retail Sale Id 236',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 08:54:08','',''),(348,'21','222','1',1,'Retail Sale Id 237',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 08:56:51','',''),(349,'21','222','1',1,'Retail Sale Id 238',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:00:31','',''),(350,'21','222','1',1,'Retail Sale Id 238',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:00:31','',''),(351,'21','222','1',1,'Retail Sale Id 239',6999.60,0.00,0.00,9.21,0.00,'2022-06-04 09:02:31','',''),(352,'21','222','1',1,'Retail Sale Id 240',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:05:06','',''),(353,'21','222','1',1,'Retail Sale Id 242',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:09:40','',''),(354,'21','222','1',1,'Retail Sale Id 244',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:12:39','',''),(355,'21','222','1',1,'Retail Sale Id 245',7980.00,0.00,0.00,10.50,0.00,'2022-06-04 09:14:28','',''),(356,'21','222','1',1,'Retail Sale Id 246',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 09:16:26','',''),(357,'21','222','1',1,'Retail Sale Id 247',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:18:11','',''),(358,'21','222','1',1,'Retail Sale Id 248',8002.80,0.00,0.00,10.53,0.00,'2022-06-04 09:19:52','',''),(359,'21','222','1',1,'Retail Sale Id 249',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:21:26','',''),(360,'21','222','1',1,'Retail Sale Id 250',8496.80,0.00,0.00,11.18,0.00,'2022-06-04 09:23:34','',''),(361,'21','222','1',1,'Retail Sale Id 251',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:26:42','',''),(362,'21','222','1',1,'Retail Sale Id 252',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 09:28:26','',''),(363,'21','222','1',1,'Retail Sale Id 253',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:30:28','',''),(364,'21','222','1',1,'Retail Sale Id 254',3997.60,0.00,0.00,5.26,0.00,'2022-06-04 09:32:48','',''),(365,'21','222','1',1,'Retail Sale Id 255',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 09:34:53','',''),(366,'21','222','1',1,'Retail Sale Id 256',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 09:36:42','',''),(367,'21','222','1',1,'Retail Sale Id 257',4750.00,0.00,0.00,6.25,0.00,'2022-06-04 09:44:18','',''),(368,'21','222','1',1,'Retail Sale Id 258',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 09:46:27','',''),(369,'21','222','1',1,'Retail Sale Id 259',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:48:30','',''),(370,'21','222','1',1,'Retail Sale Id 260',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 09:49:51','',''),(371,'21','222','1',1,'Retail Sale Id 261',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 09:51:25','',''),(372,'21','222','1',1,'Retail Sale Id 262',4499.20,0.00,0.00,5.92,0.00,'2022-06-04 10:31:36','',''),(373,'21','222','1',1,'Retail Sale Id 263',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 10:36:32','',''),(374,'21','222','1',1,'Retail Sale Id 264',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 11:20:54','',''),(375,'21','222','1',1,'Retail Sale Id 265',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 11:24:18','',''),(376,'21','222','1',1,'Retail Sale Id 266',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 11:26:05','',''),(377,'21','222','1',1,'Retail Sale Id 268',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 11:34:45','',''),(378,'21','222','1',1,'Retail Sale Id 269',2903.20,0.00,0.00,3.82,0.00,'2022-06-04 11:39:10','',''),(379,'21','222','1',1,'Retail Sale Id 270',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 11:42:27','',''),(380,'21','222','1',1,'Retail Sale Id 271',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 11:48:00','',''),(381,'21','222','1',1,'Retail Sale Id 272',5282.00,0.00,0.00,6.95,0.00,'2022-06-04 12:01:12','',''),(382,'21','222','1',1,'Retail Sale Id 273',1497.20,0.00,0.00,1.97,0.00,'2022-06-04 12:03:34','',''),(383,'21','222','1',1,'Retail Sale Id 274',2196.40,0.00,0.00,2.89,0.00,'2022-06-04 12:05:49','',''),(384,'21','222','1',1,'Retail Sale Id 275',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 12:07:29','',''),(385,'21','222','1',1,'Retail Sale Id 276',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:09:06','',''),(386,'21','222','1',1,'Retail Sale Id 278',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:10:30','',''),(387,'21','222','1',1,'Retail Sale Id 279',1520.00,0.00,0.00,2.00,0.00,'2022-06-04 12:12:14','',''),(388,'21','222','1',1,'Retail Sale Id 280',11400.00,0.00,0.00,15.00,0.00,'2022-06-04 12:16:40','',''),(389,'21','222','1',1,'Retail Sale Id 281',9507.60,0.00,0.00,12.51,0.00,'2022-06-04 12:18:42','',''),(390,'21','222','1',1,'Retail Sale Id 282',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:20:54','',''),(391,'21','222','1',1,'Retail Sale Id 283',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:22:41','',''),(392,'21','222','1',1,'Retail Sale Id 284',6999.60,0.00,0.00,9.21,0.00,'2022-06-04 12:33:03','',''),(393,'21','222','1',1,'Retail Sale Id 285',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 12:36:32','',''),(394,'21','222','1',1,'Retail Sale Id 286',8998.40,0.00,0.00,11.84,0.00,'2022-06-04 12:38:48','',''),(395,'21','222','1',1,'Retail Sale Id 287',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:40:06','',''),(396,'21','222','1',1,'Retail Sale Id 288',1497.20,0.00,0.00,1.97,0.00,'2022-06-04 12:41:18','',''),(397,'21','222','1',1,'Retail Sale Id 289',8002.80,0.00,0.00,10.53,0.00,'2022-06-04 12:43:40','',''),(398,'21','222','1',1,'Retail Sale Id 290',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 12:44:53','',''),(399,'21','222','1',1,'Retail Sale Id 291',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:47:11','',''),(400,'21','222','1',1,'Retail Sale Id 292',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:50:47','',''),(401,'21','222','1',1,'Retail Sale Id 293',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:52:19','',''),(402,'21','222','1',1,'Retail Sale Id 294',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:53:59','',''),(403,'21','222','1',1,'Retail Sale Id 295',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 12:57:34','',''),(404,'21','222','1',1,'Retail Sale Id 296',5996.40,0.00,0.00,7.89,0.00,'2022-06-04 12:59:46','',''),(405,'21','222','1',1,'Retail Sale Id 297',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 13:01:43','',''),(406,'21','222','1',1,'Retail Sale Id 298',4598.00,0.00,0.00,6.05,0.00,'2022-06-04 13:03:54','',''),(407,'21','222','1',1,'Retail Sale Id 299',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 13:05:52','',''),(408,'21','222','1',1,'Retail Sale Id 300',3040.00,0.00,0.00,4.00,0.00,'2022-06-04 13:08:50','',''),(409,'21','222','1',1,'Retail Sale Id 301',8002.80,0.00,0.00,10.53,0.00,'2022-06-04 13:11:28','',''),(410,'21','222','1',1,'Retail Sale Id 302',19000.00,0.00,0.00,25.00,0.00,'2022-06-04 13:14:44','',''),(411,'21','222','1',1,'Retail Sale Id 303',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 13:17:02','',''),(412,'21','222','1',1,'Retail Sale Id 304',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 13:19:02','',''),(413,'21','222','1',1,'Retail Sale Id 305',3997.60,0.00,0.00,5.26,0.00,'2022-06-04 13:21:46','',''),(414,'21','222','1',1,'Retail Sale Id 306',6840.00,0.00,0.00,9.00,0.00,'2022-06-04 13:23:45','',''),(415,'21','222','1',1,'Retail Sale Id 307',3997.60,0.00,0.00,5.26,0.00,'2022-06-04 13:25:11','',''),(416,'21','222','1',1,'Retail Sale Id 308',3997.60,0.00,0.00,5.26,0.00,'2022-06-04 13:26:58','',''),(417,'21','222','1',1,'Retail Sale Id 309',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 13:31:12','',''),(418,'21','222','1',1,'Retail Sale Id 310',2196.40,0.00,0.00,2.89,0.00,'2022-06-04 13:35:55','',''),(419,'21','222','1',1,'Retail Sale Id 311',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 13:37:11','',''),(420,'21','222','1',1,'Retail Sale Id 312',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 13:38:48','',''),(421,'21','222','1',1,'Retail Sale Id 313',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 13:40:39','',''),(422,'21','222','1',1,'Retail Sale Id 314',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 13:44:22','',''),(423,'21','222','1',1,'Retail Sale Id 315',1102.00,0.00,0.00,1.45,0.00,'2022-06-04 13:45:54','',''),(424,'21','222','1',1,'Retail Sale Id 316',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 13:47:01','',''),(425,'21','222','1',1,'Retail Sale Id 317',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 13:48:12','',''),(426,'21','222','1',1,'Retail Sale Id 318',14060.00,0.00,0.00,18.50,0.00,'2022-06-04 13:53:57','',''),(427,'21','222','1',1,'Retail Sale Id 319',5000.80,0.00,0.00,6.58,0.00,'2022-06-04 13:57:08','',''),(428,'21','222','1',1,'Retail Sale Id 320',14060.00,0.00,0.00,18.50,0.00,'2022-06-04 14:00:04','',''),(429,'21','222','1',1,'Retail Sale Id 321',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 14:03:12','',''),(430,'21','222','1',1,'Retail Sale Id 322',3040.00,0.00,0.00,4.00,0.00,'2022-06-04 14:04:20','',''),(431,'21','222','1',1,'Retail Sale Id 323',7600.00,0.00,0.00,10.00,0.00,'2022-06-04 14:05:23','',''),(432,'21','222','1',1,'Retail Sale Id 324',8360.00,0.00,0.00,11.00,0.00,'2022-06-04 14:07:22','',''),(433,'21','222','1',1,'Retail Sale Id 325',4499.20,0.00,0.00,5.92,0.00,'2022-06-04 14:08:40','',''),(434,'21','222','1',1,'Retail Sale Id 326',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 14:11:18','',''),(435,'21','222','1',1,'Retail Sale Id 327',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 14:14:30','',''),(436,'21','222','1',1,'Retail Sale Id 328',5000.80,0.00,0.00,6.58,0.00,'2022-06-04 14:16:08','',''),(437,'21','222','1',1,'Retail Sale Id 329',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 14:17:53','',''),(438,'21','222','1',1,'Retail Sale Id 330',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 14:19:45','',''),(439,'21','222','1',1,'Retail Sale Id 331',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 14:20:56','',''),(440,'21','222','1',1,'Retail Sale Id 332',7600.00,0.00,0.00,10.00,0.00,'2022-06-04 14:21:55','',''),(441,'21','222','1',1,'Retail Sale Id 333',798.00,0.00,0.00,1.05,0.00,'2022-06-04 14:23:16','',''),(442,'21','222','1',1,'Retail Sale Id 334',1520.00,0.00,0.00,2.00,0.00,'2022-06-04 14:24:35','',''),(443,'21','222','1',1,'Retail Sale Id 335',1497.20,0.00,0.00,1.97,0.00,'2022-06-04 14:29:31','',''),(444,'21','222','1',1,'Retail Sale Id 336',4499.20,0.00,0.00,5.92,0.00,'2022-06-04 14:31:03','',''),(445,'21','222','1',1,'Retail Sale Id 337',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 14:33:45','',''),(446,'21','222','1',1,'Retail Sale Id 338',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 14:35:41','',''),(447,'21','222','1',1,'Retail Sale Id 339',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 14:37:28','',''),(448,'21','222','1',1,'Retail Sale Id 340',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 14:39:10','',''),(449,'21','222','1',1,'Retail Sale Id 341',6999.60,0.00,0.00,9.21,0.00,'2022-06-04 14:40:54','',''),(450,'21','222','1',1,'Retail Sale Id 343',8998.40,0.00,0.00,11.84,0.00,'2022-06-04 14:51:29','',''),(451,'21','222','1',1,'Retail Sale Id 344',3002.00,0.00,0.00,3.95,0.00,'2022-06-04 14:54:38','',''),(452,'21','222','1',1,'Retail Sale Id 345',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 15:04:23','',''),(453,'21','222','1',1,'Retail Sale Id 346',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 15:08:01','',''),(454,'21','222','1',1,'Retail Sale Id 347',8496.80,0.00,0.00,11.18,0.00,'2022-06-04 15:10:00','',''),(455,'21','222','1',1,'Retail Sale Id 348',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 15:13:52','',''),(456,'21','222','1',1,'Retail Sale Id 349',8998.40,0.00,0.00,11.84,0.00,'2022-06-04 15:20:28','',''),(457,'21','222','1',1,'Retail Sale Id 350',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 15:22:57','',''),(458,'21','222','1',1,'Retail Sale Id 351',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 15:24:47','',''),(459,'21','222','1',1,'Retail Sale Id 352',1436.40,0.00,0.00,1.89,0.00,'2022-06-04 15:29:43','',''),(460,'21','222','1',1,'Retail Sale Id 353',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 15:31:47','',''),(461,'21','222','1',1,'Retail Sale Id 354',8496.80,0.00,0.00,11.18,0.00,'2022-06-04 15:33:47','',''),(462,'21','222','1',1,'Retail Sale Id 355',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 15:37:23','',''),(463,'21','222','1',1,'Retail Sale Id 356',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 15:39:01','',''),(464,'21','222','1',1,'Retail Sale Id 357',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 15:40:30','',''),(465,'21','222','1',1,'Retail Sale Id 358',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 15:41:58','',''),(466,'21','222','1',1,'Retail Sale Id 359',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 15:43:14','',''),(467,'21','222','1',1,'Retail Sale Id 360',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 15:44:52','',''),(468,'21','222','1',1,'Retail Sale Id 361',1497.20,0.00,0.00,1.97,0.00,'2022-06-04 15:46:30','',''),(469,'21','222','1',1,'Retail Sale Id 362',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 15:47:48','',''),(470,'21','222','1',1,'Retail Sale Id 363',3002.00,0.00,0.00,3.95,0.00,'2022-06-04 15:50:08','',''),(471,'21','222','1',1,'Retail Sale Id 364',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 15:51:45','',''),(472,'21','222','1',1,'Retail Sale Id 365',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 15:54:35','',''),(473,'21','222','1',1,'Retail Sale Id 366',1801.20,0.00,0.00,2.37,0.00,'2022-06-04 16:07:08','',''),(474,'21','222','1',1,'Retail Sale Id 367',17480.00,0.00,0.00,23.00,0.00,'2022-06-04 16:10:11','',''),(475,'21','222','1',1,'Retail Sale Id 368',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 16:18:38','',''),(476,'21','222','1',1,'Retail Sale Id 369',1497.20,0.00,0.00,1.97,0.00,'2022-06-04 16:29:26','',''),(477,'21','222','1',1,'Retail Sale Id 370',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 16:31:04','',''),(478,'21','222','1',1,'Retail Sale Id 371',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 16:34:48','',''),(479,'21','222','1',1,'Retail Sale Id 372',3503.60,0.00,0.00,4.61,0.00,'2022-06-04 16:37:20','',''),(480,'21','222','1',1,'Retail Sale Id 373',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 16:40:02','',''),(481,'21','222','1',1,'Retail Sale Id 374',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 16:42:06','',''),(482,'21','222','1',1,'Retail Sale Id 375',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 16:43:21','',''),(483,'21','222','1',1,'Retail Sale Id 376',5502.40,0.00,0.00,7.24,0.00,'2022-06-04 16:47:04','',''),(484,'21','222','1',1,'Retail Sale Id 377',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 16:48:48','',''),(485,'21','222','1',1,'Retail Sale Id 378',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 16:50:47','',''),(486,'21','222','1',1,'Retail Sale Id 379',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 16:55:41','',''),(487,'21','222','1',1,'Retail Sale Id 380',5000.80,0.00,0.00,6.58,0.00,'2022-06-04 16:56:46','',''),(488,'21','222','1',1,'Retail Sale Id 381',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 16:59:31','',''),(489,'21','222','1',1,'Retail Sale Id 382',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 17:01:48','',''),(490,'21','222','1',1,'Retail Sale Id 383',4696.80,0.00,0.00,6.18,0.00,'2022-06-04 17:04:03','',''),(491,'21','222','1',1,'Retail Sale Id 384',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 17:07:46','',''),(492,'21','222','1',1,'Retail Sale Id 385',1497.20,0.00,0.00,1.97,0.00,'2022-06-04 17:10:43','',''),(493,'21','222','1',1,'Retail Sale Id 386',19000.00,0.00,0.00,25.00,0.00,'2022-06-04 17:12:52','',''),(494,'21','222','1',1,'Retail Sale Id 387',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 17:14:56','',''),(495,'21','222','1',1,'Retail Sale Id 388',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 17:27:04','',''),(496,'21','222','1',1,'Retail Sale Id 389',8002.80,0.00,0.00,10.53,0.00,'2022-06-04 17:29:40','',''),(497,'21','222','1',1,'Retail Sale Id 390',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 17:32:05','',''),(498,'21','222','1',1,'Retail Sale Id 391',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 17:35:43','',''),(499,'21','222','1',1,'Retail Sale Id 392',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 17:38:40','',''),(500,'21','222','1',1,'Retail Sale Id 393',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 17:40:18','',''),(501,'21','222','1',1,'Retail Sale Id 394',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 17:43:28','',''),(502,'21','222','1',1,'Retail Sale Id 395',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 17:44:28','',''),(503,'21','222','1',1,'Retail Sale Id 396',4096.40,0.00,0.00,5.39,0.00,'2022-06-04 17:46:55','',''),(504,'21','222','1',1,'Retail Sale Id 397',10001.60,0.00,0.00,13.16,0.00,'2022-06-04 17:49:42','',''),(505,'21','222','1',1,'Retail Sale Id 398',3040.00,0.00,0.00,4.00,0.00,'2022-06-04 17:52:05','',''),(506,'21','222','1',1,'Retail Sale Id 399',5996.40,0.00,0.00,7.89,0.00,'2022-06-04 17:55:09','',''),(507,'21','222','1',1,'Retail Sale Id 400',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 17:57:06','',''),(508,'21','222','1',1,'Retail Sale Id 401',5000.80,0.00,0.00,6.58,0.00,'2022-06-04 18:02:10','',''),(509,'21','222','1',1,'Retail Sale Id 402',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 18:05:29','',''),(510,'21','222','1',1,'Retail Sale Id 403',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 18:11:59','',''),(511,'21','222','1',1,'Retail Sale Id 404',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 18:13:47','',''),(512,'21','222','1',1,'Retail Sale Id 405',3199.60,0.00,0.00,4.21,0.00,'2022-06-04 18:17:56','',''),(513,'21','222','1',1,'Retail Sale Id 406',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 18:20:04','',''),(514,'21','222','1',1,'Retail Sale Id 407',10001.60,0.00,0.00,13.16,0.00,'2022-06-04 18:25:32','',''),(515,'21','222','1',1,'Retail Sale Id 408',4750.00,0.00,0.00,6.25,0.00,'2022-06-04 18:30:41','',''),(516,'21','222','1',1,'Retail Sale Id 409',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 18:32:27','',''),(517,'21','222','1',1,'Retail Sale Id 410',5502.40,0.00,0.00,7.24,0.00,'2022-06-04 18:34:27','',''),(518,'21','222','1',1,'Retail Sale Id 411',760.00,0.00,0.00,1.00,0.00,'2022-06-04 18:38:32','',''),(519,'21','222','1',1,'Retail Sale Id 412',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 18:40:21','',''),(520,'21','222','1',1,'Retail Sale Id 413',4560.00,0.00,0.00,6.00,0.00,'2022-06-04 18:45:02','',''),(521,'21','222','1',1,'Retail Sale Id 414',3040.00,0.00,0.00,4.00,0.00,'2022-06-04 18:47:57','',''),(522,'21','222','1',1,'Retail Sale Id 415',6840.00,0.00,0.00,9.00,0.00,'2022-06-04 18:49:45','',''),(523,'21','222','1',1,'Retail Sale Id 416',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 18:52:09','',''),(524,'21','222','1',1,'Retail Sale Id 417',699.20,0.00,0.00,0.92,0.00,'2022-06-04 18:53:26','',''),(525,'21','222','1',1,'Retail Sale Id 418',3997.60,0.00,0.00,5.26,0.00,'2022-06-04 18:55:00','',''),(526,'21','222','1',1,'Retail Sale Id 419',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 18:57:37','',''),(527,'21','222','1',1,'Retail Sale Id 420',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 19:00:14','',''),(528,'21','222','1',1,'Retail Sale Id 421',19000.00,0.00,0.00,25.00,0.00,'2022-06-04 19:02:40','',''),(529,'21','222','1',1,'Retail Sale Id 422',8496.80,0.00,0.00,11.18,0.00,'2022-06-04 19:04:11','',''),(530,'21','222','1',1,'Retail Sale Id 423',3002.00,0.00,0.00,3.95,0.00,'2022-06-04 19:05:21','',''),(531,'21','222','1',1,'Retail Sale Id 424',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 19:10:20','',''),(532,'21','222','1',1,'Retail Sale Id 425',8998.40,0.00,0.00,11.84,0.00,'2022-06-04 19:13:08','',''),(533,'21','222','1',1,'Retail Sale Id 426',3002.00,0.00,0.00,3.95,0.00,'2022-06-04 19:14:03','',''),(534,'21','222','1',1,'Retail Sale Id 427',2280.00,0.00,0.00,3.00,0.00,'2022-06-04 19:15:38','',''),(535,'21','222','1',1,'Retail Sale Id 428',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 19:18:15','',''),(536,'21','222','1',1,'Retail Sale Id 429',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 19:19:15','',''),(537,'21','222','1',1,'Retail Sale Id 430',1801.20,0.00,0.00,2.37,0.00,'2022-06-04 19:20:35','',''),(538,'21','222','1',1,'Retail Sale Id 431',3800.00,0.00,0.00,5.00,0.00,'2022-06-04 19:22:08','',''),(539,'21','222','1',1,'Retail Sale Id 432',4750.00,0.00,0.00,6.25,0.00,'2022-06-04 19:23:20','',''),(540,'21','222','1',1,'Retail Sale Id 433',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 19:29:04','',''),(541,'21','222','1',1,'Retail Sale Id 434',95000.00,0.00,0.00,125.00,0.00,'2022-06-04 19:30:41','',''),(542,'21','222','1',1,'Retail Sale Id 435',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 19:37:11','',''),(543,'21','222','1',1,'Retail Sale Id 436',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 19:40:04','',''),(544,'21','222','1',1,'Retail Sale Id 437',1998.80,0.00,0.00,2.63,0.00,'2022-06-04 19:45:01','',''),(545,'21','222','1',1,'Retail Sale Id 438',1003.20,0.00,0.00,1.32,0.00,'2022-06-04 19:47:42','',''),(546,'21','222','1',1,'Retail Sale Id 439',4202.80,0.00,0.00,5.53,0.00,'2022-06-04 19:49:55','',''),(547,'21','222','1',1,'Retail Sale Id 440',8002.80,0.00,0.00,10.53,0.00,'2022-06-04 19:56:04','',''),(548,'21','222','1',1,'Retail Sale Id 441',3002.00,0.00,0.00,3.95,0.00,'2022-06-04 20:00:26','',''),(549,'21','222','1',1,'Retail Sale Id 442',9500.00,0.00,0.00,12.50,0.00,'2022-06-04 20:07:28','',''),(550,'21','222','1',1,'Retail Sale Id 443',3648.00,0.00,0.00,4.80,0.00,'2022-06-04 20:17:53','',''),(551,'21','222','1',1,'Retail Sale Id 444',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 08:16:25','',''),(552,'21','222','1',1,'Retail Sale Id 445',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 08:19:55','',''),(553,'21','222','1',1,'Retail Sale Id 446',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 08:21:34','',''),(554,'21','222','1',1,'Retail Sale Id 447',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 08:23:39','',''),(555,'21','222','1',1,'Retail Sale Id 447',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 08:23:39','',''),(556,'21','222','1',1,'Retail Sale Id 448',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 08:26:50','',''),(557,'21','222','1',1,'Retail Sale Id 449',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 08:28:36','',''),(558,'21','222','1',1,'Retail Sale Id 450',3997.60,0.00,0.00,5.26,0.00,'2022-06-05 08:30:21','',''),(559,'21','222','1',1,'Retail Sale Id 451',3997.60,0.00,0.00,5.26,0.00,'2022-06-05 08:31:58','',''),(560,'21','222','1',1,'Retail Sale Id 452',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 08:34:11','',''),(561,'21','222','1',1,'Retail Sale Id 453',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 08:36:02','',''),(562,'21','222','1',1,'Retail Sale Id 454',3997.60,0.00,0.00,5.26,0.00,'2022-06-05 08:37:47','',''),(563,'21','222','1',1,'Retail Sale Id 455',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 08:40:19','',''),(564,'21','222','1',1,'Retail Sale Id 456',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 08:43:17','',''),(565,'21','222','1',1,'Retail Sale Id 457',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 08:46:53','',''),(566,'21','222','1',1,'Retail Sale Id 458',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 08:48:59','',''),(567,'21','222','1',1,'Retail Sale Id 459',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 08:53:27','',''),(568,'21','222','1',1,'Retail Sale Id 460',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 08:56:49','',''),(569,'21','222','1',1,'Retail Sale Id 461',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 08:58:54','',''),(570,'21','222','1',1,'Retail Sale Id 462',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 09:01:03','',''),(571,'21','222','1',1,'Retail Sale Id 463',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 09:03:41','',''),(572,'21','222','1',1,'Retail Sale Id 464',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 09:04:46','',''),(573,'21','222','1',1,'Retail Sale Id 465',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:06:51','',''),(574,'21','222','1',1,'Retail Sale Id 466',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 09:12:09','',''),(575,'21','222','1',1,'Retail Sale Id 466',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:12:09','',''),(576,'21','222','1',1,'Retail Sale Id 466',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:12:09','',''),(577,'21','222','1',1,'Retail Sale Id 467',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:14:50','',''),(578,'21','222','1',1,'Retail Sale Id 467',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:14:50','',''),(579,'21','222','1',1,'Retail Sale Id 468',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:17:01','',''),(580,'21','222','1',1,'Retail Sale Id 469',8496.80,0.00,0.00,11.18,0.00,'2022-06-05 09:19:28','',''),(581,'21','222','1',1,'Retail Sale Id 470',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:22:14','',''),(582,'21','222','1',1,'Retail Sale Id 471',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:24:38','',''),(583,'21','222','1',1,'Retail Sale Id 472',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 09:28:09','',''),(584,'21','222','1',1,'Retail Sale Id 473',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 09:30:02','',''),(585,'21','222','1',1,'Retail Sale Id 474',3002.00,0.00,0.00,3.95,0.00,'2022-06-05 09:31:43','',''),(586,'21','222','1',1,'Retail Sale Id 475',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 09:37:56','',''),(587,'21','222','1',1,'Retail Sale Id 476',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:42:00','',''),(588,'21','222','1',1,'Retail Sale Id 477',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 09:44:33','',''),(589,'21','222','1',1,'Retail Sale Id 478',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 09:47:10','',''),(590,'21','222','1',1,'Retail Sale Id 479',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:08:44','',''),(591,'21','222','1',1,'Retail Sale Id 480',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 10:09:58','',''),(592,'21','222','1',1,'Retail Sale Id 481',3002.00,0.00,0.00,3.95,0.00,'2022-06-05 10:11:45','',''),(593,'21','222','1',1,'Retail Sale Id 482',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:12:51','',''),(594,'21','222','1',1,'Retail Sale Id 483',4803.20,0.00,0.00,6.32,0.00,'2022-06-05 10:15:00','',''),(595,'21','222','1',1,'Retail Sale Id 484',14060.00,0.00,0.00,18.50,0.00,'2022-06-05 10:17:21','',''),(596,'21','222','1',1,'Retail Sale Id 485',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 10:18:48','',''),(597,'21','222','1',1,'Retail Sale Id 486',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:20:39','',''),(598,'21','222','1',1,'Retail Sale Id 487',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:22:02','',''),(599,'21','222','1',1,'Retail Sale Id 488',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:23:15','',''),(600,'21','222','1',1,'Retail Sale Id 489',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:25:15','',''),(601,'21','222','1',1,'Retail Sale Id 490',5000.80,0.00,0.00,6.58,0.00,'2022-06-05 10:27:03','',''),(602,'21','222','1',1,'Retail Sale Id 491',3503.60,0.00,0.00,4.61,0.00,'2022-06-05 10:28:14','',''),(603,'21','222','1',1,'Retail Sale Id 492',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 10:29:59','',''),(604,'21','222','1',1,'Retail Sale Id 493',1603.60,0.00,0.00,2.11,0.00,'2022-06-05 10:31:31','',''),(605,'21','222','1',1,'Retail Sale Id 494',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 10:32:48','',''),(606,'21','222','1',1,'Retail Sale Id 495',3002.00,0.00,0.00,3.95,0.00,'2022-06-05 10:33:44','',''),(607,'21','222','1',1,'Retail Sale Id 496',8496.80,0.00,0.00,11.18,0.00,'2022-06-05 10:35:06','',''),(608,'21','222','1',1,'Retail Sale Id 497',5996.40,0.00,0.00,7.89,0.00,'2022-06-05 10:36:49','',''),(609,'21','222','1',1,'Retail Sale Id 498',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:39:12','',''),(610,'21','222','1',1,'Retail Sale Id 499',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:40:56','',''),(611,'21','222','1',1,'Retail Sale Id 500',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 10:42:36','',''),(612,'21','222','1',1,'Retail Sale Id 501',1702.40,0.00,0.00,2.24,0.00,'2022-06-05 10:44:25','',''),(613,'21','222','1',1,'Retail Sale Id 502',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:46:08','',''),(614,'21','222','1',1,'Retail Sale Id 503',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 10:48:55','',''),(615,'21','222','1',1,'Retail Sale Id 504',1497.20,0.00,0.00,1.97,0.00,'2022-06-05 10:50:43','',''),(616,'21','222','1',1,'Retail Sale Id 505',19000.00,0.00,0.00,25.00,0.00,'2022-06-05 10:51:49','',''),(617,'21','222','1',1,'Retail Sale Id 506',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:53:47','',''),(618,'21','222','1',1,'Retail Sale Id 507',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 10:57:00','',''),(619,'21','222','1',1,'Retail Sale Id 508',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 10:58:10','',''),(620,'21','222','1',1,'Retail Sale Id 509',1520.00,0.00,0.00,2.00,0.00,'2022-06-05 10:59:36','',''),(621,'21','222','1',1,'Retail Sale Id 510',8998.40,0.00,0.00,11.84,0.00,'2022-06-05 11:00:39','',''),(622,'21','222','1',1,'Retail Sale Id 511',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 11:02:45','',''),(623,'21','222','1',1,'Retail Sale Id 512',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 11:05:09','',''),(624,'21','222','1',1,'Retail Sale Id 513',2196.40,0.00,0.00,2.89,0.00,'2022-06-05 11:06:36','',''),(625,'21','222','1',1,'Retail Sale Id 514',3997.60,0.00,0.00,5.26,0.00,'2022-06-05 11:08:17','',''),(626,'21','222','1',1,'Retail Sale Id 515',8360.00,0.00,0.00,11.00,0.00,'2022-06-05 11:11:55','',''),(627,'21','222','1',1,'Retail Sale Id 516',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 11:13:30','',''),(628,'21','222','1',1,'Retail Sale Id 517',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 11:14:57','',''),(629,'21','222','1',1,'Retail Sale Id 518',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 11:16:29','',''),(630,'21','222','1',1,'Retail Sale Id 519',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 11:18:35','',''),(631,'21','222','1',1,'Retail Sale Id 520',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 11:19:58','',''),(632,'21','222','1',1,'Retail Sale Id 521',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 11:21:23','',''),(633,'21','222','1',1,'Retail Sale Id 522',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 11:23:00','',''),(634,'21','222','1',1,'Retail Sale Id 523',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 11:25:31','',''),(635,'21','222','1',1,'Retail Sale Id 524',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 11:27:06','',''),(636,'21','222','1',1,'Retail Sale Id 525',2500.40,0.00,0.00,3.29,0.00,'2022-06-05 11:30:53','',''),(637,'21','222','1',1,'Retail Sale Id 526',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 11:31:46','',''),(638,'21','222','1',1,'Retail Sale Id 527',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 11:34:06','',''),(639,'21','222','1',1,'Retail Sale Id 528',2196.40,0.00,0.00,2.89,0.00,'2022-06-05 11:35:26','',''),(640,'21','222','1',1,'Retail Sale Id 529',2196.40,0.00,0.00,2.89,0.00,'2022-06-05 11:37:18','',''),(641,'21','222','1',1,'Retail Sale Id 530',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 11:38:28','',''),(642,'21','222','1',1,'Retail Sale Id 531',3503.60,0.00,0.00,4.61,0.00,'2022-06-05 11:41:03','',''),(643,'21','222','1',1,'Retail Sale Id 532',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 11:42:55','',''),(644,'21','222','1',1,'Retail Sale Id 533',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 11:45:54','',''),(645,'21','222','1',1,'Retail Sale Id 534',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 15:50:32','',''),(646,'21','222','1',1,'Retail Sale Id 535',3040.00,0.00,0.00,4.00,0.00,'2022-06-05 15:52:07','',''),(647,'21','222','1',1,'Retail Sale Id 536',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 15:53:36','',''),(648,'21','222','1',1,'Retail Sale Id 537',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 15:54:33','',''),(649,'21','222','1',1,'Retail Sale Id 538',8496.80,0.00,0.00,11.18,0.00,'2022-06-05 15:55:40','',''),(650,'21','222','1',1,'Retail Sale Id 539',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 15:56:38','',''),(651,'21','222','1',1,'Retail Sale Id 540',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 15:57:29','',''),(652,'21','222','1',1,'Retail Sale Id 541',1497.20,0.00,0.00,1.97,0.00,'2022-06-05 15:58:24','',''),(653,'21','222','1',1,'Retail Sale Id 542',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 15:59:32','',''),(654,'21','222','1',1,'Retail Sale Id 543',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 16:01:04','',''),(655,'21','222','1',1,'Retail Sale Id 544',1003.20,0.00,0.00,1.32,0.00,'2022-06-05 16:02:37','',''),(656,'21','222','1',1,'Retail Sale Id 545',1520.00,0.00,0.00,2.00,0.00,'2022-06-05 16:03:48','',''),(657,'21','222','1',1,'Retail Sale Id 546',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:04:37','',''),(658,'21','222','1',1,'Retail Sale Id 547',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:05:40','',''),(659,'21','222','1',1,'Retail Sale Id 548',1497.20,0.00,0.00,1.97,0.00,'2022-06-05 16:06:44','',''),(660,'21','222','1',1,'Retail Sale Id 549',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:08:29','',''),(661,'21','222','1',1,'Retail Sale Id 550',8002.80,0.00,0.00,10.53,0.00,'2022-06-05 16:09:59','',''),(662,'21','222','1',1,'Retail Sale Id 551',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:10:58','',''),(663,'21','222','1',1,'Retail Sale Id 552',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 16:12:04','',''),(664,'21','222','1',1,'Retail Sale Id 553',5996.40,0.00,0.00,7.89,0.00,'2022-06-05 16:13:17','',''),(665,'21','222','1',1,'Retail Sale Id 554',15200.00,0.00,0.00,20.00,0.00,'2022-06-05 16:14:14','',''),(666,'21','222','1',1,'Retail Sale Id 555',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 16:15:14','',''),(667,'21','222','1',1,'Retail Sale Id 556',1998.80,0.00,0.00,2.63,0.00,'2022-06-05 16:16:28','',''),(668,'21','222','1',1,'Retail Sale Id 557',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:17:23','',''),(669,'21','222','1',1,'Retail Sale Id 558',4757.60,0.00,0.00,6.26,0.00,'2022-06-05 16:18:45','',''),(670,'21','222','1',1,'Retail Sale Id 559',1056.40,0.00,0.00,1.39,0.00,'2022-06-05 16:19:43','',''),(671,'21','222','1',1,'Retail Sale Id 560',9120.00,0.00,0.00,12.00,0.00,'2022-06-05 16:20:57','',''),(672,'21','222','1',1,'Retail Sale Id 561',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:22:08','',''),(673,'21','222','1',1,'Retail Sale Id 562',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:23:39','',''),(674,'21','222','1',1,'Retail Sale Id 563',8360.00,0.00,0.00,11.00,0.00,'2022-06-05 16:24:51','',''),(675,'21','222','1',1,'Retail Sale Id 564',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:25:46','',''),(676,'21','222','1',1,'Retail Sale Id 565',3800.00,0.00,0.00,5.00,0.00,'2022-06-05 16:26:47','',''),(677,'21','222','1',1,'Retail Sale Id 566',2196.40,0.00,0.00,2.89,0.00,'2022-06-05 16:27:51','',''),(678,'21','222','1',1,'Retail Sale Id 567',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 16:29:23','',''),(679,'21','222','1',1,'Retail Sale Id 568',8002.80,0.00,0.00,10.53,0.00,'2022-06-05 16:30:39','',''),(680,'21','222','1',1,'Retail Sale Id 569',7600.00,0.00,0.00,10.00,0.00,'2022-06-05 16:31:29','',''),(681,'21','222','1',1,'Retail Sale Id 570',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:32:24','',''),(682,'21','222','1',1,'Retail Sale Id 571',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 16:33:25','',''),(683,'21','222','1',1,'Retail Sale Id 572',2280.00,0.00,0.00,3.00,0.00,'2022-06-05 16:34:22','',''),(684,'21','222','1',1,'Retail Sale Id 573',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 16:43:16','',''),(685,'21','222','1',1,'Retail Sale Id 574',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 16:44:55','',''),(686,'21','222','1',1,'Retail Sale Id 575',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 16:46:03','',''),(687,'21','222','1',1,'Retail Sale Id 576',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:46:41','',''),(688,'21','222','1',1,'Retail Sale Id 577',4560.00,0.00,0.00,6.00,0.00,'2022-06-05 16:47:22','',''),(689,'21','222','1',1,'Retail Sale Id 578',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:48:03','',''),(690,'21','222','1',1,'Retail Sale Id 579',9500.00,0.00,0.00,12.50,0.00,'2022-06-05 16:48:43','',''),(691,'21','222','1',1,'Retail Sale Id 580',38000.00,0.00,0.00,50.00,0.00,'2022-06-05 16:50:19','',''),(692,'21','222','1',1,'Retail Sale Id 581',10556.40,0.00,0.00,13.89,0.00,'2022-06-05 16:51:11','',''),(693,'21','222',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,32.00,0.00,'2022-06-05 17:29:20','',''),(694,'21','222','1',1,'Received from bridging 9',0.00,0.00,32.00,0.00,0.00,'2022-06-05 17:29:20','',''),(695,'21','222','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,702.09,0.00,'2022-06-05 18:15:21','',''),(696,'21','222','1',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-06-05 18:15:21','',''),(697,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,26112100.00,5110.00,0.00,0.00,'2022-06-07 16:02:33','',''),(698,'21','222',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,4999.00,0.00,'2022-06-07 16:05:15','',''),(699,'21','222','1',1,'Received from bridging 10',0.00,0.00,4999.00,0.00,0.00,'2022-06-07 16:05:15','',''),(700,'21','222','1',1,'Retail Sale Id 582',5000.80,0.00,0.00,6.58,-28623.00,'2022-06-07 16:15:55','',''),(701,'21','222','1',1,'Retail Sale Id 583',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-07 16:17:04','',''),(702,'21','222','1',1,'Retail Sale Id 584',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 16:18:31','',''),(703,'21','222','1',1,'Retail Sale Id 585',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 16:19:39','',''),(704,'21','222','1',1,'Retail Sale Id 586',8002.80,0.00,0.00,10.53,-45805.50,'2022-06-07 16:21:16','',''),(705,'21','222','1',1,'Retail Sale Id 587',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-07 16:22:45','',''),(706,'21','222','1',1,'Retail Sale Id 588',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 16:28:07','',''),(707,'21','222','1',1,'Retail Sale Id 589',8496.80,0.00,0.00,11.18,-48633.00,'2022-06-07 16:28:58','',''),(708,'21','222','1',1,'Retail Sale Id 590',1998.80,0.00,0.00,2.63,-11440.50,'2022-06-07 16:31:00','',''),(709,'21','222','1',1,'Retail Sale Id 591',8002.80,0.00,0.00,10.53,-45805.50,'2022-06-07 16:34:38','',''),(710,'21','222','1',1,'Retail Sale Id 592',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 16:36:49','',''),(711,'21','222','1',1,'Retail Sale Id 593',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-07 16:38:09','',''),(712,'21','222','1',1,'Retail Sale Id 594',1998.80,0.00,0.00,2.63,-11440.50,'2022-06-07 16:39:41','',''),(713,'21','222','1',1,'Retail Sale Id 595',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 16:41:10','',''),(714,'21','222','1',1,'Retail Sale Id 596',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-07 16:42:15','',''),(715,'21','222','1',1,'Retail Sale Id 597',11498.80,0.00,0.00,15.13,-65815.50,'2022-06-07 16:45:06','',''),(716,'21','222','1',1,'Retail Sale Id 598',19000.00,0.00,0.00,25.00,-108750.00,'2022-06-07 16:46:01','',''),(717,'21','222','1',1,'Retail Sale Id 599',6247.20,0.00,0.00,8.22,-35757.00,'2022-06-07 16:47:21','',''),(718,'21','222','1',1,'Retail Sale Id 600',5282.00,0.00,0.00,6.95,-30232.50,'2022-06-07 16:49:47','',''),(719,'21','222','1',1,'Retail Sale Id 601',38000.00,0.00,0.00,50.00,-217500.00,'2022-06-07 16:52:58','',''),(720,'21','222','1',1,'Retail Sale Id 602',13999.20,0.00,0.00,18.42,-80127.00,'2022-06-07 16:54:13','',''),(721,'21','222','1',1,'Retail Sale Id 603',95000.00,0.00,0.00,125.00,-543750.00,'2022-06-07 16:56:26','',''),(722,'21','222','1',1,'Retail Sale Id 604',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-07 16:58:24','',''),(723,'21','222','1',1,'Retail Sale Id 605',16340.00,0.00,0.00,21.50,-93525.00,'2022-06-07 17:01:57','',''),(724,'21','222','1',1,'Retail Sale Id 606',3997.60,0.00,0.00,5.26,-22881.00,'2022-06-07 17:03:06','',''),(725,'21','222','1',1,'Retail Sale Id 607',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 17:04:27','',''),(726,'21','222','1',1,'Retail Sale Id 608',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 17:05:31','',''),(727,'21','222','1',1,'Retail Sale Id 609',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-07 17:07:03','',''),(728,'21','222','1',1,'Retail Sale Id 610',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 17:08:38','',''),(729,'21','222','1',1,'Retail Sale Id 611',15200.00,0.00,0.00,20.00,-87000.00,'2022-06-07 17:11:04','',''),(730,'21','222','1',1,'Retail Sale Id 612',8998.40,0.00,0.00,11.84,-51504.00,'2022-06-07 17:12:02','',''),(731,'21','222','1',1,'Retail Sale Id 613',4499.20,0.00,0.00,5.92,-25752.00,'2022-06-07 17:13:04','',''),(732,'21','222','1',1,'Retail Sale Id 614',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-07 17:13:39','',''),(733,'21','222','1',1,'Retail Sale Id 615',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-07 17:14:12','',''),(734,'21','222','1',1,'Retail Sale Id 616',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 17:14:46','',''),(735,'21','222','1',1,'Retail Sale Id 617',5000.80,0.00,0.00,6.58,-28623.00,'2022-06-07 17:15:29','',''),(736,'21','222','1',1,'Retail Sale Id 618',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-07 17:16:16','',''),(737,'21','222','1',1,'Retail Sale Id 619',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 17:17:15','',''),(738,'21','222','1',1,'Retail Sale Id 620',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 17:17:56','',''),(739,'21','222','1',1,'Retail Sale Id 621',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-07 17:18:49','',''),(740,'21','222','1',1,'Retail Sale Id 623',5996.40,0.00,0.00,7.89,-34321.50,'2022-06-07 17:24:30','',''),(741,'21','222','1',1,'Retail Sale Id 624',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-07 17:36:57','',''),(742,'21','222','1',1,'Retail Sale Id 625',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 17:47:05','',''),(743,'21','222','1',1,'Retail Sale Id 626',7600.00,0.00,0.00,10.00,-43500.00,'2022-06-07 17:48:41','',''),(744,'21','222','1',1,'Retail Sale Id 627',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-07 17:50:33','',''),(745,'21','222','1',1,'Retail Sale Id 628',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-07 17:53:29','',''),(746,'21','222','1',1,'Retail Sale Id 629',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-07 17:54:53','',''),(747,'21','222','1',1,'Retail Sale Id 630',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 17:58:24','',''),(748,'21','222','1',1,'Retail Sale Id 631',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-07 18:02:07','',''),(749,'21','222','1',1,'Retail Sale Id 632',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-07 18:03:13','',''),(750,'21','222','1',1,'Retail Sale Id 633',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-07 18:04:45','',''),(751,'21','222','1',1,'Retail Sale Id 634',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-07 18:07:38','',''),(752,'21','222','1',1,'Retail Sale Id 635',8496.80,0.00,0.00,11.18,-48633.00,'2022-06-07 18:09:59','',''),(753,'21','222','1',1,'Retail Sale Id 636',8002.80,0.00,0.00,10.53,-45805.50,'2022-06-07 18:13:05','',''),(754,'21','222','1',1,'Retail Sale Id 637',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-07 18:16:00','',''),(755,'21','222','1',1,'Retail Sale Id 638',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-07 18:17:21','',''),(756,'21','222','1',1,'Retail Sale Id 639',8998.40,0.00,0.00,11.84,-51504.00,'2022-06-07 18:22:01','',''),(757,'21','222','1',1,'Retail Sale Id 640',1998.80,0.00,0.00,2.63,-11440.50,'2022-06-07 18:23:19','',''),(758,'21','222','1',1,'Retail Sale Id 641',7600.00,0.00,0.00,10.00,-43500.00,'2022-06-07 18:26:42','',''),(759,'21','222','1',1,'Retail Sale Id 642',4301.60,0.00,0.00,5.66,-24621.00,'2022-06-07 18:28:28','',''),(760,'21','222','1',1,'Retail Sale Id 643',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 18:29:50','',''),(761,'21','222','1',1,'Retail Sale Id 644',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 18:31:45','',''),(762,'21','222','1',1,'Retail Sale Id 645',1200.80,0.00,0.00,1.58,-6873.00,'2022-06-07 18:34:05','',''),(763,'21','222','1',1,'Retail Sale Id 646',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-07 18:35:46','',''),(764,'21','222','1',1,'Retail Sale Id 647',1200.80,0.00,0.00,1.58,-6873.00,'2022-06-07 18:39:47','',''),(765,'21','222','1',1,'Retail Sale Id 648',1003.20,0.00,0.00,1.32,-5742.00,'2022-06-07 18:41:03','',''),(766,'21','222','1',1,'Retail Sale Id 649',1998.80,0.00,0.00,2.63,-11440.50,'2022-06-07 18:42:14','',''),(767,'21','222','1',1,'Retail Sale Id 650',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-07 18:43:19','',''),(768,'21','222','1',1,'Retail Sale Id 651',3002.00,0.00,0.00,3.95,-17182.50,'2022-06-07 18:44:16','',''),(769,'21','222','1',1,'Retail Sale Id 652',1998.80,0.00,0.00,2.63,-11440.50,'2022-06-07 18:45:40','',''),(770,'21','222','1',1,'Retail Sale Id 653',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-07 18:46:51','',''),(771,'21','222','1',1,'Retail Sale Id 654',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 18:50:13','',''),(772,'21','222','1',1,'Retail Sale Id 655',38000.00,0.00,0.00,50.00,-217500.00,'2022-06-07 21:31:52','',''),(773,'21','222','1',1,'Retail Sale Id 656',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 21:33:01','',''),(774,'21','222','1',1,'Retail Sale Id 657',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-07 21:34:04','',''),(775,'21','222','1',1,'Retail Sale Id 658',8002.80,0.00,0.00,10.53,-45805.50,'2022-06-07 21:35:07','',''),(776,'21','222','1',1,'Retail Sale Id 659',7600.00,0.00,0.00,10.00,-43500.00,'2022-06-07 21:36:00','',''),(777,'21','222','1',1,'Retail Sale Id 660',15200.00,0.00,0.00,20.00,-87000.00,'2022-06-07 21:36:51','',''),(778,'21','222','1',1,'Retail Sale Id 661',38000.00,0.00,0.00,50.00,-217500.00,'2022-06-07 21:37:45','',''),(779,'21','222','1',1,'Retail Sale Id 663',7037.60,0.00,0.00,9.26,-40281.00,'2022-06-07 21:39:29','',''),(780,'21','222','1',1,'Retail Sale Id 664',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 10:30:03','',''),(781,'21','222','1',1,'Retail Sale Id 665',1520.00,0.00,0.00,2.00,-8700.00,'2022-06-08 10:31:48','',''),(782,'21','222','1',1,'Retail Sale Id 667',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-08 10:37:43','',''),(783,'21','222','1',1,'Retail Sale Id 668',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-08 10:42:46','',''),(784,'21','222','1',1,'Retail Sale Id 669',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-08 10:46:15','',''),(785,'21','222','1',1,'Retail Sale Id 670',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 10:46:57','',''),(786,'21','222','1',1,'Retail Sale Id 671',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 10:48:41','',''),(787,'21','222','1',1,'Retail Sale Id 672',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 10:54:43','',''),(788,'21','222','1',1,'Retail Sale Id 673',6999.60,0.00,0.00,9.21,-40063.50,'2022-06-08 11:00:05','',''),(789,'21','222','1',1,'Retail Sale Id 674',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 11:13:34','',''),(790,'21','222','1',1,'Retail Sale Id 675',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 11:28:31','',''),(791,'21','222','1',1,'Retail Sale Id 676',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 11:40:23','',''),(792,'21','222','1',1,'Retail Sale Id 677',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-08 11:41:45','',''),(793,'21','222','1',1,'Retail Sale Id 678',3997.60,0.00,0.00,5.26,-22881.00,'2022-06-08 11:43:09','',''),(794,'21','222','1',1,'Retail Sale Id 679',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 11:46:59','',''),(795,'21','222','1',1,'Retail Sale Id 680',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-08 12:02:33','',''),(796,'21','222','1',1,'Retail Sale Id 681',1998.80,0.00,0.00,2.63,-11440.50,'2022-06-08 12:03:36','',''),(797,'21','222','1',1,'Retail Sale Id 682',38000.00,0.00,0.00,50.00,-217500.00,'2022-06-08 13:14:21','',''),(798,'21','222','1',1,'Retail Sale Id 683',1520.00,0.00,0.00,2.00,-8700.00,'2022-06-08 13:18:02','',''),(799,'21','222','1',1,'Retail Sale Id 684',8998.40,0.00,0.00,11.84,-51504.00,'2022-06-08 13:32:19','',''),(800,'21','222','1',1,'Retail Sale Id 685',760.00,0.00,0.00,1.00,-4350.00,'2022-06-08 13:34:47','',''),(801,'21','222','1',1,'Retail Sale Id 686',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-08 13:36:29','',''),(802,'21','222','1',1,'Retail Sale Id 687',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-08 13:38:10','',''),(803,'21','222','1',1,'Retail Sale Id 689',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-08 13:40:38','',''),(804,'21','222','1',1,'Retail Sale Id 690',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 13:45:13','',''),(805,'21','222','1',1,'Retail Sale Id 691',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 13:47:59','',''),(806,'21','222','1',1,'Retail Sale Id 692',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 13:50:29','',''),(807,'21','222','1',1,'Retail Sale Id 693',3800.00,0.00,0.00,5.00,-21750.00,'2022-06-08 13:55:21','',''),(808,'21','222','1',1,'Retail Sale Id 694',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 14:30:51','',''),(809,'21','222','1',1,'Retail Sale Id 695',6080.00,0.00,0.00,8.00,-34800.00,'2022-06-08 14:33:34','',''),(810,'21','222','1',1,'Retail Sale Id 696',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 14:35:34','',''),(811,'21','222','1',1,'Retail Sale Id 697',2280.00,0.00,0.00,3.00,-13050.00,'2022-06-08 14:37:34','',''),(812,'21','222','1',1,'Retail Sale Id 698',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 14:42:06','',''),(813,'21','222','1',1,'Retail Sale Id 699',760.00,0.00,0.00,1.00,-4350.00,'2022-06-08 14:47:18','',''),(814,'21','222','1',1,'Retail Sale Id 700',4560.00,0.00,0.00,6.00,-26100.00,'2022-06-08 14:51:02','',''),(815,'21','222','1',1,'Retail Sale Id 701',9500.00,0.00,0.00,12.50,-54375.00,'2022-06-08 14:52:56','',''),(816,'21','222','1',1,'Retail Sale Id 703',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 15:04:50','',''),(817,'21','222','1',1,'Retail Sale Id 704',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 15:07:32','',''),(818,'21','222','1',1,'Retail Sale Id 706',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 15:10:42','',''),(819,'21','222','1',1,'Retail Sale Id 707',3002.00,0.00,0.00,3.95,0.00,'2022-06-08 15:13:47','',''),(820,'21','222','1',1,'Retail Sale Id 708',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 15:22:43','',''),(821,'21','222','1',1,'Retail Sale Id 709',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 15:23:46','',''),(822,'21','222','1',1,'Retail Sale Id 710',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 15:30:12','',''),(823,'21','222','1',1,'Retail Sale Id 711',8002.80,0.00,0.00,10.53,0.00,'2022-06-08 15:33:01','',''),(824,'21','222','1',1,'Retail Sale Id 712',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 15:37:55','',''),(825,'21','222','1',1,'Retail Sale Id 713',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 15:39:00','',''),(826,'21','222','1',1,'Retail Sale Id 714',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 15:40:13','',''),(827,'21','222','1',1,'Retail Sale Id 715',8998.40,0.00,0.00,11.84,0.00,'2022-06-08 15:44:32','',''),(828,'21','222','1',1,'Retail Sale Id 716',8998.40,0.00,0.00,11.84,0.00,'2022-06-08 15:47:29','',''),(829,'21','222','1',1,'Retail Sale Id 717',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 15:48:48','',''),(830,'21','222','1',1,'Retail Sale Id 718',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 15:50:02','',''),(831,'21','222','1',1,'Retail Sale Id 719',3002.00,0.00,0.00,3.95,0.00,'2022-06-08 15:52:30','',''),(832,'21','222','1',1,'Retail Sale Id 720',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 15:54:25','',''),(833,'21','222','1',1,'Retail Sale Id 721',760.00,0.00,0.00,1.00,0.00,'2022-06-08 16:29:52','',''),(834,'21','222','1',1,'Retail Sale Id 722',8496.80,0.00,0.00,11.18,0.00,'2022-06-08 16:32:08','',''),(835,'21','222','1',1,'Retail Sale Id 723',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 16:37:18','',''),(836,'21','222','1',1,'Retail Sale Id 724',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 16:42:42','',''),(837,'21','222','1',1,'Retail Sale Id 725',3997.60,0.00,0.00,5.26,0.00,'2022-06-08 16:47:48','',''),(838,'21','222','1',1,'Retail Sale Id 726',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 16:50:28','',''),(839,'21','222','1',1,'Retail Sale Id 727',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 16:52:27','',''),(840,'21','222','1',1,'Retail Sale Id 728',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 16:53:19','',''),(841,'21','222','1',1,'Retail Sale Id 729',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 16:54:38','',''),(842,'21','222','1',1,'Retail Sale Id 730',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 16:59:16','',''),(843,'21','222','1',1,'Retail Sale Id 731',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 17:00:25','',''),(844,'21','222','1',1,'Retail Sale Id 732',1520.00,0.00,0.00,2.00,0.00,'2022-06-08 17:01:46','',''),(845,'21','222','1',1,'Retail Sale Id 733',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 17:14:20','',''),(846,'21','222','1',1,'Retail Sale Id 734',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 17:15:47','',''),(847,'21','222','1',1,'Retail Sale Id 735',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 17:18:55','',''),(848,'21','222','1',1,'Retail Sale Id 736',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 17:20:10','',''),(849,'21','222','1',1,'Retail Sale Id 738',4750.00,0.00,0.00,6.25,0.00,'2022-06-08 17:22:59','',''),(850,'21','222','1',1,'Retail Sale Id 739',5000.80,0.00,0.00,6.58,0.00,'2022-06-08 17:23:50','',''),(851,'21','222','1',1,'Retail Sale Id 740',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 17:24:48','',''),(852,'21','222','1',1,'Retail Sale Id 741',1520.00,0.00,0.00,2.00,0.00,'2022-06-08 17:28:28','',''),(853,'21','222','1',1,'Retail Sale Id 742',3040.00,0.00,0.00,4.00,0.00,'2022-06-08 17:29:34','',''),(854,'21','222','1',1,'Retail Sale Id 743',8002.80,0.00,0.00,10.53,0.00,'2022-06-08 17:31:17','',''),(855,'21','222','1',1,'Retail Sale Id 744',15200.00,0.00,0.00,20.00,0.00,'2022-06-08 17:34:23','',''),(856,'21','222','1',1,'Retail Sale Id 746',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 17:36:34','',''),(857,'21','222','1',1,'Retail Sale Id 747',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 17:37:48','',''),(858,'21','222','1',1,'Retail Sale Id 748',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 17:43:23','',''),(859,'21','222','1',1,'Retail Sale Id 749',19000.00,0.00,0.00,25.00,0.00,'2022-06-08 17:45:00','',''),(860,'21','222','1',1,'Retail Sale Id 750',1003.20,0.00,0.00,1.32,0.00,'2022-06-08 17:52:10','',''),(861,'21','222','1',1,'Retail Sale Id 751',3503.60,0.00,0.00,4.61,0.00,'2022-06-08 17:53:22','',''),(862,'21','222','1',1,'Retail Sale Id 752',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 17:57:15','',''),(863,'21','222','1',1,'Retail Sale Id 753',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 18:02:01','',''),(864,'21','222','1',1,'Return of Retail Sale Id 753',0.00,3800.00,5.00,0.00,0.00,'2022-06-08 18:02:33','',''),(865,'21','222','1',1,'Retail Sale Id 754',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 18:03:34','',''),(866,'21','222','1',1,'Retail Sale Id 755',3002.00,0.00,0.00,3.95,0.00,'2022-06-08 18:05:17','',''),(867,'21','222','1',1,'Retail Sale Id 756',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 18:07:14','',''),(868,'21','222','1',1,'Retail Sale Id 757',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 18:22:42','',''),(869,'21','222','1',1,'Retail Sale Id 758',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 18:24:18','',''),(870,'21','222','1',1,'Retail Sale Id 759',1702.40,0.00,0.00,2.24,0.00,'2022-06-08 18:25:45','',''),(871,'21','222','1',1,'Retail Sale Id 760',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 18:27:04','',''),(872,'21','222','1',1,'Retail Sale Id 761',760.00,0.00,0.00,1.00,0.00,'2022-06-08 18:28:52','',''),(873,'21','222','1',1,'Retail Sale Id 762',32999.20,0.00,0.00,43.42,0.00,'2022-06-08 18:29:58','',''),(874,'21','222','1',1,'Retail Sale Id 763',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 18:31:56','',''),(875,'21','222','1',1,'Retail Sale Id 764',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 18:35:26','',''),(876,'21','222','1',1,'Retail Sale Id 765',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 18:36:45','',''),(877,'21','222','1',1,'Retail Sale Id 766',8360.00,0.00,0.00,11.00,0.00,'2022-06-08 18:39:34','',''),(878,'21','222','1',1,'Retail Sale Id 767',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 18:41:52','',''),(879,'21','222','1',1,'Retail Sale Id 768',8496.80,0.00,0.00,11.18,0.00,'2022-06-08 18:45:34','',''),(880,'21','222','1',1,'Retail Sale Id 769',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 18:46:58','',''),(881,'21','222','1',1,'Retail Sale Id 770',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 18:49:57','',''),(882,'21','222','1',1,'Retail Sale Id 771',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 18:55:06','',''),(883,'21','222','1',1,'Retail Sale Id 772',3002.00,0.00,0.00,3.95,0.00,'2022-06-08 18:56:14','',''),(884,'21','222','1',1,'Retail Sale Id 773',2280.00,0.00,0.00,3.00,0.00,'2022-06-08 19:00:51','',''),(885,'21','222','1',1,'Retail Sale Id 774',7600.00,0.00,0.00,10.00,0.00,'2022-06-08 19:02:53','',''),(886,'21','222','1',1,'Retail Sale Id 775',1497.20,0.00,0.00,1.97,0.00,'2022-06-08 19:06:06','',''),(887,'21','222','1',1,'Retail Sale Id 776',1003.20,0.00,0.00,1.32,0.00,'2022-06-08 19:07:40','',''),(888,'21','222','1',1,'Retail Sale Id 777',1998.80,0.00,0.00,2.63,0.00,'2022-06-08 19:08:36','',''),(889,'21','222','1',1,'Retail Sale Id 778',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 19:09:33','',''),(890,'21','222','1',1,'Retail Sale Id 779',3002.00,0.00,0.00,3.95,0.00,'2022-06-08 19:10:33','',''),(891,'21','222','1',1,'Retail Sale Id 780',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 19:13:00','',''),(892,'21','222','1',1,'Retail Sale Id 781',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 19:15:53','',''),(893,'21','222','1',1,'Retail Sale Id 782',8002.80,0.00,0.00,10.53,0.00,'2022-06-08 19:49:21','',''),(894,'21','222','1',1,'Retail Sale Id 783',38000.00,0.00,0.00,50.00,0.00,'2022-06-08 20:38:20','',''),(895,'21','222','1',1,'Retail Sale Id 784',19000.00,0.00,0.00,25.00,0.00,'2022-06-08 20:39:10','',''),(896,'21','222','1',1,'Retail Sale Id 785',7600.00,0.00,0.00,10.00,0.00,'2022-06-08 20:40:07','',''),(897,'21','222','1',1,'Retail Sale Id 786',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 20:40:40','',''),(898,'21','222','1',1,'Retail Sale Id 787',3800.00,0.00,0.00,5.00,0.00,'2022-06-08 20:41:27','',''),(899,'21','222','1',1,'Retail Sale Id 788',38000.00,0.00,0.00,50.00,0.00,'2022-06-08 20:42:20','',''),(900,'21','222','1',1,'Retail Sale Id 789',15200.00,0.00,0.00,20.00,0.00,'2022-06-08 20:43:18','',''),(901,'21','222','1',1,'Retail Sale Id 790',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 20:44:11','',''),(902,'21','222','1',1,'Retail Sale Id 791',8998.40,0.00,0.00,11.84,0.00,'2022-06-08 20:44:52','',''),(903,'21','222','1',1,'Retail Sale Id 792',8002.80,0.00,0.00,10.53,0.00,'2022-06-08 20:45:30','',''),(904,'21','222','1',1,'Retail Sale Id 793',38000.00,0.00,0.00,50.00,0.00,'2022-06-08 20:46:10','',''),(905,'21','222','1',1,'Retail Sale Id 794',38000.00,0.00,0.00,50.00,0.00,'2022-06-08 20:46:55','',''),(906,'21','222','1',1,'Retail Sale Id 795',3997.60,0.00,0.00,5.26,0.00,'2022-06-08 20:48:08','',''),(907,'21','222','1',1,'Retail Sale Id 797',3002.00,0.00,0.00,3.95,0.00,'2022-06-08 20:49:48','',''),(908,'21','222','1',1,'Retail Sale Id 798',5000.80,0.00,0.00,6.58,0.00,'2022-06-08 20:50:22','',''),(909,'21','222','1',1,'Retail Sale Id 799',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 20:51:05','',''),(910,'21','222','1',1,'Retail Sale Id 800',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 20:51:43','',''),(911,'21','222','1',1,'Retail Sale Id 801',9500.00,0.00,0.00,12.50,0.00,'2022-06-08 20:53:26','',''),(912,'21','222','1',1,'Retail Sale Id 802',15200.00,0.00,0.00,20.00,0.00,'2022-06-08 20:54:06','',''),(913,'21','222','1',1,'Retail Sale Id 803',4560.00,0.00,0.00,6.00,0.00,'2022-06-08 20:54:44','',''),(914,'21','222','1',1,'Retail Sale Id 804',38000.00,0.00,0.00,50.00,0.00,'2022-06-08 20:55:29','',''),(915,'21','222','1',1,'Retail Sale Id 805',15200.00,0.00,0.00,20.00,0.00,'2022-06-08 20:56:07','',''),(916,'21','222','1',1,'Retail Sale Id 806',7600.00,0.00,0.00,10.00,0.00,'2022-06-08 20:56:58','',''),(917,'21','222','1',1,'Retail Sale Id 807',15998.00,0.00,0.00,21.05,0.00,'2022-06-08 20:57:40','',''),(918,'21','222','1',1,'Retail Sale Id 808',38000.00,0.00,0.00,50.00,0.00,'2022-06-08 20:58:31','',''),(919,'21','222','1',1,'Retail Sale Id 809',15200.00,0.00,0.00,20.00,0.00,'2022-06-08 20:59:08','',''),(920,'21','222','1',1,'Retail Sale Id 810',10001.60,0.00,0.00,13.16,0.00,'2022-06-08 21:00:05','',''),(921,'21','222','1',1,'Retail Sale Id 811',7873.60,0.00,0.00,10.36,0.00,'2022-06-08 21:01:59','',''),(922,'21','222','1',1,'Retail Sale Id 812',760.00,0.00,0.00,1.00,0.00,'2022-06-09 16:00:52','',''),(923,'21','222','1',1,'Retail Sale Id 813',1003.20,0.00,0.00,1.32,0.00,'2022-06-09 16:02:38','',''),(924,'21','222','1',1,'Retail Sale Id 814',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 16:04:43','',''),(925,'21','222','1',1,'Retail Sale Id 815',3002.00,0.00,0.00,3.95,0.00,'2022-06-09 16:06:21','',''),(926,'21','222','1',1,'Retail Sale Id 816',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 16:07:46','',''),(927,'21','222','1',1,'Retail Sale Id 817',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 17:00:32','',''),(928,'21','222','1',1,'Retail Sale Id 818',3002.00,0.00,0.00,3.95,0.00,'2022-06-09 17:01:44','',''),(929,'21','222','1',1,'Retail Sale Id 819',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 17:03:08','',''),(930,'21','222','1',1,'Retail Sale Id 820',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 17:55:27','',''),(931,'21','222','1',1,'Retail Sale Id 823',1520.00,0.00,0.00,2.00,0.00,'2022-06-09 18:01:29','',''),(932,'21','222','1',1,'Retail Sale Id 824',8998.40,0.00,0.00,11.84,0.00,'2022-06-09 18:11:11','',''),(933,'21','222','1',1,'Retail Sale Id 825',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 18:17:29','',''),(934,'21','222','1',1,'Retail Sale Id 826',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 18:27:48','',''),(935,'21','222','1',1,'Retail Sale Id 827',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 18:32:48','',''),(936,'21','222','1',1,'Retail Sale Id 828',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 18:34:55','',''),(937,'21','222','1',1,'Retail Sale Id 829',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 18:39:11','',''),(938,'21','222','1',1,'Retail Sale Id 830',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 18:54:53','',''),(939,'21','222','1',1,'Retail Sale Id 832',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 18:58:06','',''),(940,'21','222','1',1,'Retail Sale Id 833',1801.20,0.00,0.00,2.37,0.00,'2022-06-09 18:59:19','',''),(941,'21','222','1',1,'Retail Sale Id 834',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 19:01:19','',''),(942,'21','222','1',1,'Retail Sale Id 835',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 19:07:16','',''),(943,'21','222','1',1,'Retail Sale Id 835',38000.00,0.00,0.00,50.00,0.00,'2022-06-09 19:07:16','',''),(944,'21','222','1',1,'Retail Sale Id 836',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 19:13:43','',''),(945,'21','222','1',1,'Retail Sale Id 837',1702.40,0.00,0.00,2.24,0.00,'2022-06-09 19:15:04','',''),(946,'21','222','1',1,'Retail Sale Id 838',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 19:16:34','',''),(947,'21','222','1',1,'Retail Sale Id 839',4750.00,0.00,0.00,6.25,0.00,'2022-06-09 19:18:06','',''),(948,'21','222','1',1,'Retail Sale Id 840',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 19:20:51','',''),(949,'21','222','1',1,'Retail Sale Id 841',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 19:22:23','',''),(950,'21','222','1',1,'Retail Sale Id 842',1520.00,0.00,0.00,2.00,0.00,'2022-06-09 19:23:49','',''),(951,'21','222','1',1,'Retail Sale Id 843',7600.00,0.00,0.00,10.00,0.00,'2022-06-09 19:25:16','',''),(952,'21','222','1',1,'Retail Sale Id 844',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 19:26:41','',''),(953,'21','222','1',1,'Retail Sale Id 845',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 19:28:33','',''),(954,'21','222','1',1,'Retail Sale Id 846',3002.00,0.00,0.00,3.95,0.00,'2022-06-09 19:36:33','',''),(955,'21','222','1',1,'Retail Sale Id 847',3800.00,0.00,0.00,5.00,0.00,'2022-06-09 19:37:38','',''),(956,'21','222','1',1,'Retail Sale Id 848',14060.00,0.00,0.00,18.50,0.00,'2022-06-09 19:38:31','',''),(957,'21','222','1',1,'Retail Sale Id 849',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 19:39:50','',''),(958,'21','222','1',1,'Retail Sale Id 850',2401.60,0.00,0.00,3.16,0.00,'2022-06-09 19:41:59','',''),(959,'21','222','1',1,'Retail Sale Id 851',4750.00,0.00,0.00,6.25,0.00,'2022-06-09 19:43:39','',''),(960,'21','222','1',1,'Retail Sale Id 852',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 19:44:49','',''),(961,'21','222','1',1,'Retail Sale Id 853',1003.20,0.00,0.00,1.32,0.00,'2022-06-09 19:45:58','',''),(962,'21','222','1',1,'Retail Sale Id 854',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 19:46:51','',''),(963,'21','222','1',1,'Retail Sale Id 855',3002.00,0.00,0.00,3.95,0.00,'2022-06-09 19:48:25','',''),(964,'21','222','1',1,'Retail Sale Id 856',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 19:49:18','',''),(965,'21','222','1',1,'Retail Sale Id 857',1003.20,0.00,0.00,1.32,0.00,'2022-06-09 19:51:22','',''),(966,'21','222','1',1,'Retail Sale Id 858',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 19:57:25','',''),(967,'21','222','1',1,'Retail Sale Id 859',3997.60,0.00,0.00,5.26,0.00,'2022-06-09 19:58:37','',''),(968,'21','222','1',1,'Retail Sale Id 860',17996.80,0.00,0.00,23.68,0.00,'2022-06-09 20:01:53','',''),(969,'21','222','1',1,'Retail Sale Id 861',19000.00,0.00,0.00,25.00,0.00,'2022-06-09 20:03:53','',''),(970,'21','222','1',1,'Retail Sale Id 862',1998.80,0.00,0.00,2.63,0.00,'2022-06-09 20:05:59','',''),(971,'21','222','1',1,'Retail Sale Id 863',3503.60,0.00,0.00,4.61,0.00,'2022-06-09 20:09:58','',''),(972,'21','222','1',1,'Retail Sale Id 864',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 20:14:25','',''),(973,'21','222','1',1,'Retail Sale Id 865',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 20:31:14','',''),(974,'21','222','1',1,'Retail Sale Id 866',38000.00,0.00,0.00,50.00,0.00,'2022-06-09 21:35:09','',''),(975,'21','222','1',1,'Retail Sale Id 867',38000.00,0.00,0.00,50.00,0.00,'2022-06-09 21:35:56','',''),(976,'21','222','1',1,'Retail Sale Id 868',15200.00,0.00,0.00,20.00,0.00,'2022-06-09 21:36:42','',''),(977,'21','222','1',1,'Retail Sale Id 869',38000.00,0.00,0.00,50.00,0.00,'2022-06-09 21:37:23','',''),(978,'21','222','1',1,'Retail Sale Id 870',7600.00,0.00,0.00,10.00,0.00,'2022-06-09 21:37:57','',''),(979,'21','222','1',1,'Retail Sale Id 871',38000.00,0.00,0.00,50.00,0.00,'2022-06-09 21:38:47','',''),(980,'21','222','1',1,'Retail Sale Id 872',38000.00,0.00,0.00,50.00,0.00,'2022-06-09 21:39:40','',''),(981,'21','222','1',1,'Retail Sale Id 873',7600.00,0.00,0.00,10.00,0.00,'2022-06-09 21:40:13','',''),(982,'21','222','1',1,'Retail Sale Id 874',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 21:40:51','',''),(983,'21','222','1',1,'Retail Sale Id 875',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 21:41:31','',''),(984,'21','222','1',1,'Retail Sale Id 876',2280.00,0.00,0.00,3.00,0.00,'2022-06-09 21:42:09','',''),(985,'21','222','1',1,'Retail Sale Id 877',38000.00,0.00,0.00,50.00,0.00,'2022-06-09 21:42:47','',''),(986,'21','222','1',1,'Retail Sale Id 878',19000.00,0.00,0.00,25.00,0.00,'2022-06-09 21:43:37','',''),(987,'21','222','1',1,'Retail Sale Id 879',38000.00,0.00,0.00,50.00,0.00,'2022-06-09 21:44:32','',''),(988,'21','222','1',1,'Retail Sale Id 880',5297.20,0.00,0.00,6.97,0.00,'2022-06-09 21:45:21','',''),(989,'21','222','1',1,'Retail Sale Id 881',4560.00,0.00,0.00,6.00,0.00,'2022-06-09 21:46:04','',''),(990,'21','222','1',1,'Retail Sale Id 882',17996.80,0.00,0.00,23.68,0.00,'2022-06-09 21:46:55','',''),(991,'21','222','1',1,'Retail Sale Id 883',19000.00,0.00,0.00,25.00,0.00,'2022-06-09 21:47:42','',''),(992,'21','222','1',1,'Retail Sale Id 884',5996.40,0.00,0.00,7.89,0.00,'2022-06-09 21:48:24','',''),(993,'21','222','1',1,'Retail Sale Id 885',5000.80,0.00,0.00,6.58,0.00,'2022-06-09 21:49:01','',''),(994,'21','222','1',1,'Retail Sale Id 886',15200.00,0.00,0.00,20.00,0.00,'2022-06-09 21:50:08','',''),(995,'21','222','1',1,'Retail Sale Id 887',3997.60,0.00,0.00,5.26,0.00,'2022-06-09 21:50:51','',''),(996,'21','222','1',1,'Retail Sale Id 888',1003.20,0.00,0.00,1.32,0.00,'2022-06-09 21:51:30','',''),(997,'21','222','1',1,'Retail Sale Id 889',17001.20,0.00,0.00,22.37,0.00,'2022-06-09 21:52:12','',''),(998,'21','222','1',1,'Retail Sale Id 890',9500.00,0.00,0.00,12.50,0.00,'2022-06-09 21:52:55','',''),(999,'21','222','1',1,'Retail Sale Id 891',15200.00,0.00,0.00,20.00,0.00,'2022-06-09 21:53:35','',''),(1000,'21','222','1',1,'Retail Sale Id 892',19000.00,0.00,0.00,25.00,0.00,'2022-06-09 21:54:46','',''),(1001,'21','222','1',1,'Retail Sale Id 893',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 07:31:02','',''),(1002,'21','222','1',1,'Retail Sale Id 894',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 07:41:46','',''),(1003,'21','222','1',1,'Retail Sale Id 895',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 07:44:41','',''),(1004,'21','222','1',1,'Retail Sale Id 896',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 07:50:40','',''),(1005,'21','222','1',1,'Retail Sale Id 897',3002.00,0.00,0.00,3.95,0.00,'2022-06-10 07:52:05','',''),(1006,'21','222','1',1,'Retail Sale Id 898',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 07:57:48','',''),(1007,'21','222','1',1,'Retail Sale Id 899',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 08:02:34','',''),(1008,'21','222','1',1,'Retail Sale Id 900',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 08:04:40','',''),(1009,'21','222','1',1,'Retail Sale Id 901',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 08:09:55','',''),(1010,'21','222','1',1,'Retail Sale Id 902',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 08:15:01','',''),(1011,'21','222','1',1,'Retail Sale Id 903',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 08:19:03','',''),(1012,'21','222','1',1,'Retail Sale Id 904',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 08:21:35','',''),(1013,'21','222','1',1,'Retail Sale Id 905',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 08:35:05','',''),(1014,'21','222','1',1,'Retail Sale Id 906',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 08:39:54','',''),(1015,'21','222','1',1,'Retail Sale Id 907',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 08:44:44','',''),(1016,'21','222','1',1,'Retail Sale Id 908',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 08:47:51','',''),(1017,'21','222','1',1,'Retail Sale Id 909',8998.40,0.00,0.00,11.84,0.00,'2022-06-10 08:52:02','',''),(1018,'21','222','1',1,'Retail Sale Id 910',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 08:53:46','',''),(1019,'21','222','1',1,'Retail Sale Id 911',5000.80,0.00,0.00,6.58,0.00,'2022-06-10 09:00:41','',''),(1020,'21','222','1',1,'Retail Sale Id 912',760.00,0.00,0.00,1.00,0.00,'2022-06-10 09:03:12','',''),(1021,'21','222','1',1,'Retail Sale Id 915',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 09:05:23','',''),(1022,'21','222','1',1,'Retail Sale Id 916',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 09:24:10','',''),(1023,'21','222','1',1,'Retail Sale Id 917',11780.00,0.00,0.00,15.50,0.00,'2022-06-10 09:31:09','',''),(1024,'21','222','1',1,'Retail Sale Id 918',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 09:49:47','',''),(1025,'21','222','1',1,'Retail Sale Id 919',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 09:51:44','',''),(1026,'21','222','1',1,'Retail Sale Id 920',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 09:56:30','',''),(1027,'21','222','1',1,'Retail Sale Id 922',7600.00,0.00,0.00,10.00,0.00,'2022-06-10 10:05:08','',''),(1028,'21','222','1',1,'Retail Sale Id 923',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 10:08:16','',''),(1029,'21','222','1',1,'Retail Sale Id 924',3047.60,0.00,0.00,4.01,0.00,'2022-06-10 10:15:12','',''),(1030,'21','222','1',1,'Retail Sale Id 925',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 10:19:05','',''),(1031,'21','222','1',1,'Retail Sale Id 926',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 10:27:11','',''),(1032,'21','222','1',1,'Retail Sale Id 927',3997.60,0.00,0.00,5.26,0.00,'2022-06-10 10:46:09','',''),(1033,'21','222','1',1,'Retail Sale Id 928',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 10:48:54','',''),(1034,'21','222','1',1,'Retail Sale Id 929',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 10:50:17','',''),(1035,'21','222','1',1,'Retail Sale Id 930',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 11:00:38','',''),(1036,'21','222','1',1,'Retail Sale Id 931',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 11:01:56','',''),(1037,'21','222','1',1,'Retail Sale Id 932',38000.00,0.00,0.00,50.00,0.00,'2022-06-10 11:03:42','',''),(1038,'21','222','1',1,'Retail Sale Id 933',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 11:05:32','',''),(1039,'21','222','1',1,'Retail Sale Id 934',7600.00,0.00,0.00,10.00,0.00,'2022-06-10 11:08:47','',''),(1040,'21','222','1',1,'Retail Sale Id 935',1702.40,0.00,0.00,2.24,0.00,'2022-06-10 11:21:28','',''),(1041,'21','222','1',1,'Retail Sale Id 936',1003.20,0.00,0.00,1.32,0.00,'2022-06-10 11:23:28','',''),(1042,'21','222','1',1,'Retail Sale Id 937',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 11:25:03','',''),(1043,'21','222','1',1,'Retail Sale Id 938',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 11:32:30','',''),(1044,'21','222','1',1,'Retail Sale Id 939',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 11:37:07','',''),(1045,'21','222','1',1,'Retail Sale Id 940',5996.40,0.00,0.00,7.89,0.00,'2022-06-10 11:38:29','',''),(1046,'21','222','1',1,'Retail Sale Id 942',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 11:41:05','',''),(1047,'21','222','1',1,'Retail Sale Id 943',7600.00,0.00,0.00,10.00,0.00,'2022-06-10 11:44:24','',''),(1048,'21','222','1',1,'Retail Sale Id 944',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 11:46:57','',''),(1049,'21','222','1',1,'Retail Sale Id 945',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 11:51:50','',''),(1050,'21','222','1',1,'Retail Sale Id 946',7600.00,0.00,0.00,10.00,0.00,'2022-06-10 12:01:21','',''),(1051,'21','222','1',1,'Retail Sale Id 947',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 12:11:07','',''),(1052,'21','222','1',1,'Retail Sale Id 948',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 12:18:44','',''),(1053,'21','222','1',1,'Retail Sale Id 949',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 12:34:58','',''),(1054,'21','222','1',1,'Retail Sale Id 950',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 12:43:14','',''),(1055,'21','222','1',1,'Retail Sale Id 951',5000.80,0.00,0.00,6.58,0.00,'2022-06-10 12:44:35','',''),(1056,'21','222','1',1,'Retail Sale Id 952',5000.80,0.00,0.00,6.58,0.00,'2022-06-10 12:46:44','',''),(1057,'21','222','1',1,'Retail Sale Id 953',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 12:48:59','',''),(1058,'21','222','1',1,'Retail Sale Id 954',5996.40,0.00,0.00,7.89,0.00,'2022-06-10 12:51:41','',''),(1059,'21','222','1',1,'Retail Sale Id 955',3997.60,0.00,0.00,5.26,0.00,'2022-06-10 12:56:59','',''),(1060,'21','222','1',1,'Retail Sale Id 956',3002.00,0.00,0.00,3.95,0.00,'2022-06-10 12:58:48','',''),(1061,'21','222','1',1,'Retail Sale Id 957',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 13:07:58','',''),(1062,'21','222','1',1,'Retail Sale Id 958',11780.00,0.00,0.00,15.50,0.00,'2022-06-10 13:14:28','',''),(1063,'21','222','1',1,'Retail Sale Id 959',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 13:52:44','',''),(1064,'21','222','1',1,'Retail Sale Id 960',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 13:57:38','',''),(1065,'21','222','1',1,'Retail Sale Id 961',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 14:03:45','',''),(1066,'21','222','1',1,'Retail Sale Id 963',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 14:27:26','',''),(1067,'21','222','1',1,'Retail Sale Id 964',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 14:30:14','',''),(1068,'21','222','1',1,'Retail Sale Id 965',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 14:37:46','',''),(1069,'21','222','1',1,'Retail Sale Id 966',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 14:55:42','',''),(1070,'21','222','1',1,'Retail Sale Id 967',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 14:56:23','',''),(1071,'21','222','1',1,'Retail Sale Id 968',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 14:58:47','',''),(1072,'21','222','1',1,'Retail Sale Id 969',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 15:07:23','',''),(1073,'21','222','1',1,'Retail Sale Id 970',4499.20,0.00,0.00,5.92,0.00,'2022-06-10 15:13:13','',''),(1074,'21','222','1',1,'Retail Sale Id 971',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 15:29:25','',''),(1075,'21','222','1',1,'Retail Sale Id 972',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 15:30:18','',''),(1076,'21','222','1',1,'Retail Sale Id 973',1998.80,0.00,0.00,2.63,0.00,'2022-06-10 15:35:30','',''),(1077,'21','222','1',1,'Retail Sale Id 974',5000.80,0.00,0.00,6.58,0.00,'2022-06-10 15:37:54','',''),(1078,'21','222','1',1,'Retail Sale Id 975',2280.00,0.00,0.00,3.00,0.00,'2022-06-10 15:41:44','',''),(1079,'21','222','1',1,'Retail Sale Id 976',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 15:44:06','',''),(1080,'21','222','1',1,'Retail Sale Id 977',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 15:46:18','',''),(1081,'21','222','1',1,'Retail Sale Id 978',5000.80,0.00,0.00,6.58,0.00,'2022-06-10 15:47:50','',''),(1082,'21','222','1',1,'Retail Sale Id 979',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 15:50:21','',''),(1083,'21','222','1',1,'Retail Sale Id 980',7600.00,0.00,0.00,10.00,0.00,'2022-06-10 15:53:21','',''),(1084,'21','222','1',1,'Retail Sale Id 981',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 15:57:23','',''),(1085,'21','222','1',1,'Retail Sale Id 982',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 16:01:53','',''),(1086,'21','222','1',1,'Retail Sale Id 983',8360.00,0.00,0.00,11.00,0.00,'2022-06-10 16:08:33','',''),(1087,'21','222','1',1,'Retail Sale Id 984',3997.60,0.00,0.00,5.26,0.00,'2022-06-10 16:10:38','',''),(1088,'21','222','1',1,'Retail Sale Id 985',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 16:54:36','',''),(1089,'21','222','1',1,'Retail Sale Id 986',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 16:56:31','',''),(1090,'21','222','1',1,'Retail Sale Id 987',8496.80,0.00,0.00,11.18,0.00,'2022-06-10 16:58:00','',''),(1091,'21','222','1',1,'Retail Sale Id 988',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 17:05:57','',''),(1092,'21','222','1',1,'Retail Sale Id 989',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 18:00:51','',''),(1093,'21','222','1',1,'Retail Sale Id 990',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 18:03:59','',''),(1094,'21','222','1',1,'Retail Sale Id 991',3800.00,0.00,0.00,5.00,0.00,'2022-06-10 18:05:53','',''),(1095,'21','222','1',1,'Retail Sale Id 992',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 18:07:13','',''),(1096,'21','222','1',1,'Retail Sale Id 993',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 18:19:51','',''),(1097,'21','222','1',1,'Retail Sale Id 994',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 18:26:32','',''),(1098,'21','222','1',1,'Retail Sale Id 995',1497.20,0.00,0.00,1.97,0.00,'2022-06-10 18:30:11','',''),(1099,'21','222','1',1,'Retail Sale Id 996',1003.20,0.00,0.00,1.32,0.00,'2022-06-10 18:36:38','',''),(1100,'21','222','1',1,'Retail Sale Id 997',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 18:47:57','',''),(1101,'21','222','1',1,'Retail Sale Id 998',3002.00,0.00,0.00,3.95,0.00,'2022-06-10 18:50:01','',''),(1102,'21','222','1',1,'Retail Sale Id 999',4560.00,0.00,0.00,6.00,0.00,'2022-06-10 18:52:30','',''),(1103,'21','222','1',1,'Retail Sale Id 1000',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 20:00:42','',''),(1104,'21','222','1',1,'Retail Sale Id 1001',38000.00,0.00,0.00,50.00,0.00,'2022-06-10 20:17:38','',''),(1105,'21','222','1',1,'Retail Sale Id 1002',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 20:18:38','',''),(1106,'21','222','1',1,'Retail Sale Id 1004',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 20:20:17','',''),(1107,'21','222','1',1,'Retail Sale Id 1005',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 20:22:51','',''),(1108,'21','222','1',1,'Retail Sale Id 1006',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 20:23:30','',''),(1109,'21','222','1',1,'Retail Sale Id 1007',38000.00,0.00,0.00,50.00,0.00,'2022-06-10 20:24:15','',''),(1110,'21','222','1',1,'Retail Sale Id 1008',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 20:25:03','',''),(1111,'21','222','1',1,'Retail Sale Id 1009',38000.00,0.00,0.00,50.00,0.00,'2022-06-10 20:25:55','',''),(1112,'21','222','1',1,'Retail Sale Id 1010',9500.00,0.00,0.00,12.50,0.00,'2022-06-10 20:26:31','',''),(1113,'21','222','1',1,'Retail Sale Id 1011',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 20:27:19','',''),(1114,'21','222','1',1,'Retail Sale Id 1012',38000.00,0.00,0.00,50.00,0.00,'2022-06-10 20:28:23','',''),(1115,'21','222','1',1,'Retail Sale Id 1013',16826.40,0.00,0.00,22.14,0.00,'2022-06-10 20:29:18','',''),(1116,'21','222','1',1,'Retail Sale Id 1014',38000.00,0.00,0.00,50.00,0.00,'2022-06-10 20:32:17','',''),(1117,'21','222','1',1,'Retail Sale Id 1015',19000.00,0.00,0.00,25.00,0.00,'2022-06-10 20:32:44','',''),(1118,'21','222','1',1,'Retail Sale Id 1016',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 08:11:05','',''),(1119,'21','222','1',1,'Retail Sale Id 1017',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 08:21:06','',''),(1120,'21','222','1',1,'Retail Sale Id 1018',3503.60,0.00,0.00,4.61,0.00,'2022-06-11 08:25:25','',''),(1121,'21','222','1',1,'Retail Sale Id 1019',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 08:27:00','',''),(1122,'21','222','1',1,'Retail Sale Id 1020',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 08:29:05','',''),(1123,'21','222','1',1,'Retail Sale Id 1021',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 08:31:04','',''),(1124,'21','222','1',1,'Retail Sale Id 1022',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 08:34:24','',''),(1125,'21','222','1',1,'Retail Sale Id 1023',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 08:38:37','',''),(1126,'21','222','1',1,'Retail Sale Id 1024',1702.40,0.00,0.00,2.24,0.00,'2022-06-11 08:40:13','',''),(1127,'21','222','1',1,'Retail Sale Id 1025',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 08:42:22','',''),(1128,'21','222','1',1,'Retail Sale Id 1026',3997.60,0.00,0.00,5.26,0.00,'2022-06-11 08:43:47','',''),(1129,'21','222','1',1,'Retail Sale Id 1027',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 08:44:51','',''),(1130,'21','222','1',1,'Retail Sale Id 1028',5000.80,0.00,0.00,6.58,0.00,'2022-06-11 08:46:11','',''),(1131,'21','222','1',1,'Retail Sale Id 1029',38000.00,0.00,0.00,50.00,0.00,'2022-06-11 10:28:01','',''),(1132,'21','222','1',1,'Retail Sale Id 1030',7600.00,0.00,0.00,10.00,0.00,'2022-06-11 10:29:02','',''),(1133,'21','222','1',1,'Retail Sale Id 1031',15200.00,0.00,0.00,20.00,0.00,'2022-06-11 10:29:58','',''),(1134,'21','222','1',1,'Retail Sale Id 1032',19000.00,0.00,0.00,25.00,0.00,'2022-06-11 10:31:23','',''),(1135,'21','222',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,100.15,0.00,'2022-06-11 11:35:50','',''),(1136,'21','222','1',1,'Received from bridging 11',0.00,0.00,100.15,0.00,0.00,'2022-06-11 11:35:50','',''),(1137,'21','222','1',1,'Retail Sale Id 1034',38000.00,0.00,0.00,50.00,0.00,'2022-06-11 12:59:01','',''),(1138,'21','222','1',1,'Retail Sale Id 1036',38000.00,0.00,0.00,50.00,0.00,'2022-06-11 13:27:50','',''),(1139,'21','222','1',1,'Retail Sale Id 1038',3040.00,0.00,0.00,4.00,0.00,'2022-06-11 13:32:05','',''),(1140,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,1900000.00,2500.00,0.00,0.00,'2022-06-11 14:15:17','',''),(1141,'21','222',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,2500.00,0.00,'2022-06-11 14:26:38','',''),(1142,'21','222','1',1,'Received from bridging 12',0.00,0.00,2500.00,0.00,0.00,'2022-06-11 14:26:38','',''),(1143,'21','222','1',1,'Retail Sale Id 1039',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 14:35:30','',''),(1144,'21','222','1',1,'Retail Sale Id 1040',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 14:36:37','',''),(1145,'21','222','1',1,'Retail Sale Id 1041',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 14:37:49','',''),(1146,'21','222','1',1,'Retail Sale Id 1042',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 14:39:02','',''),(1147,'21','222','1',1,'Retail Sale Id 1043',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 14:40:02','',''),(1148,'21','222','1',1,'Retail Sale Id 1044',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 14:43:53','',''),(1149,'21','222','1',1,'Retail Sale Id 1045',3002.00,0.00,0.00,3.95,0.00,'2022-06-11 14:45:49','',''),(1150,'21','222','1',1,'Retail Sale Id 1046',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 14:49:26','',''),(1151,'21','222','1',1,'Retail Sale Id 1047',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 14:52:58','',''),(1152,'21','222','1',1,'Retail Sale Id 1048',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 14:55:17','',''),(1153,'21','222','1',1,'Retail Sale Id 1049',22800.00,0.00,0.00,30.00,0.00,'2022-06-11 15:30:32','',''),(1154,'21','222','1',1,'Retail Sale Id 1050',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 15:34:07','',''),(1155,'21','222','1',1,'Retail Sale Id 1050',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 15:34:07','',''),(1156,'21','222','1',1,'Retail Sale Id 1051',7600.00,0.00,0.00,10.00,0.00,'2022-06-11 15:40:10','',''),(1157,'21','222','1',1,'Retail Sale Id 1052',5000.80,0.00,0.00,6.58,0.00,'2022-06-11 15:41:49','',''),(1158,'21','222','1',1,'Retail Sale Id 1053',1603.60,0.00,0.00,2.11,0.00,'2022-06-11 15:46:35','',''),(1159,'21','222','1',1,'Retail Sale Id 1054',5000.80,0.00,0.00,6.58,0.00,'2022-06-11 15:48:07','',''),(1160,'21','222','1',1,'Retail Sale Id 1055',19000.00,0.00,0.00,25.00,0.00,'2022-06-11 15:52:17','',''),(1161,'21','222','1',1,'Retail Sale Id 1056',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 15:54:31','',''),(1162,'21','222','1',1,'Retail Sale Id 1057',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 15:57:52','',''),(1163,'21','222','1',1,'Retail Sale Id 1058',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 16:00:52','',''),(1164,'21','222','1',1,'Retail Sale Id 1059',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 16:02:48','',''),(1165,'21','222','1',1,'Retail Sale Id 1060',7600.00,0.00,0.00,10.00,0.00,'2022-06-11 16:07:49','',''),(1166,'21','222','1',1,'Retail Sale Id 1061',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:09:39','',''),(1167,'21','222','1',1,'Retail Sale Id 1062',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 16:18:03','',''),(1168,'21','222','1',1,'Retail Sale Id 1063',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 16:19:11','',''),(1169,'21','222','1',1,'Retail Sale Id 1064',9120.00,0.00,0.00,12.00,0.00,'2022-06-11 16:20:55','',''),(1170,'21','222','1',1,'Retail Sale Id 1065',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 16:23:22','',''),(1171,'21','222','1',1,'Retail Sale Id 1066',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:26:10','',''),(1172,'21','222','1',1,'Retail Sale Id 1067',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:27:58','',''),(1173,'21','222','1',1,'Retail Sale Id 1068',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 16:31:39','',''),(1174,'21','222','1',1,'Retail Sale Id 1069',8360.00,0.00,0.00,11.00,0.00,'2022-06-11 16:34:11','',''),(1175,'21','222','1',1,'Retail Sale Id 1070',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 16:37:01','',''),(1176,'21','222','1',1,'Retail Sale Id 1071',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 16:39:14','',''),(1177,'21','222','1',1,'Retail Sale Id 1072',6460.00,0.00,0.00,8.50,0.00,'2022-06-11 16:42:24','',''),(1178,'21','222','1',1,'Retail Sale Id 1073',1003.20,0.00,0.00,1.32,0.00,'2022-06-11 16:43:24','',''),(1179,'21','222','1',1,'Retail Sale Id 1074',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:44:37','',''),(1180,'21','222','1',1,'Retail Sale Id 1074',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:44:37','',''),(1181,'21','222','1',1,'Retail Sale Id 1075',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:46:24','',''),(1182,'21','222','1',1,'Retail Sale Id 1076',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 16:47:55','',''),(1183,'21','222','1',1,'Retail Sale Id 1077',3997.60,0.00,0.00,5.26,0.00,'2022-06-11 16:51:53','',''),(1184,'21','222','1',1,'Retail Sale Id 1078',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 16:57:15','',''),(1185,'21','222','1',1,'Retail Sale Id 1079',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 16:58:49','',''),(1186,'21','222','1',1,'Retail Sale Id 1080',3002.00,0.00,0.00,3.95,0.00,'2022-06-11 16:59:52','',''),(1187,'21','222','1',1,'Retail Sale Id 1081',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 17:01:55','',''),(1188,'21','222','1',1,'Retail Sale Id 1082',5000.80,0.00,0.00,6.58,0.00,'2022-06-11 17:03:43','',''),(1189,'21','222','1',1,'Retail Sale Id 1083',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 17:09:08','',''),(1190,'21','222','1',1,'Retail Sale Id 1084',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 17:11:16','',''),(1191,'21','222','1',1,'Retail Sale Id 1085',3997.60,0.00,0.00,5.26,0.00,'2022-06-11 17:12:33','',''),(1192,'21','222','1',1,'Retail Sale Id 1086',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 17:14:01','',''),(1193,'21','222','1',1,'Retail Sale Id 1087',7600.00,0.00,0.00,10.00,0.00,'2022-06-11 17:15:38','',''),(1194,'21','222','1',1,'Retail Sale Id 1088',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 17:19:56','',''),(1195,'21','222','1',1,'Retail Sale Id 1088',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 17:19:56','',''),(1196,'21','222','1',1,'Retail Sale Id 1088',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 17:19:56','',''),(1197,'21','222','1',1,'Retail Sale Id 1088',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 17:19:56','',''),(1198,'21','222','1',1,'Retail Sale Id 1090',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 17:24:28','',''),(1199,'21','222','1',1,'Retail Sale Id 1091',1003.20,0.00,0.00,1.32,0.00,'2022-06-11 17:26:02','',''),(1200,'21','222','1',1,'Retail Sale Id 1091',1003.20,0.00,0.00,1.32,0.00,'2022-06-11 17:26:02','',''),(1201,'21','222','1',1,'Retail Sale Id 1092',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 17:27:48','',''),(1202,'21','222','1',1,'Retail Sale Id 1093',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 17:30:09','',''),(1203,'21','222','1',1,'Retail Sale Id 1094',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 17:31:39','',''),(1204,'21','222','1',1,'Retail Sale Id 1095',2196.40,0.00,0.00,2.89,0.00,'2022-06-11 17:33:29','',''),(1205,'21','222','1',1,'Retail Sale Id 1096',3002.00,0.00,0.00,3.95,0.00,'2022-06-11 17:35:21','',''),(1206,'21','222','1',1,'Retail Sale Id 1096',3002.00,0.00,0.00,3.95,0.00,'2022-06-11 17:35:22','',''),(1207,'21','222','1',1,'Retail Sale Id 1097',22800.00,0.00,0.00,30.00,0.00,'2022-06-11 17:37:15','',''),(1208,'21','222','1',1,'Retail Sale Id 1098',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 17:39:09','',''),(1209,'21','222','1',1,'Retail Sale Id 1099',1702.40,0.00,0.00,2.24,0.00,'2022-06-11 17:41:05','',''),(1210,'21','222','1',1,'Retail Sale Id 1100',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 17:42:10','',''),(1211,'21','222','1',1,'Retail Sale Id 1101',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 17:44:04','',''),(1212,'21','222','1',1,'Retail Sale Id 1102',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 17:46:51','',''),(1213,'21','222','1',1,'Retail Sale Id 1102',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 17:46:51','',''),(1214,'21','222','1',1,'Retail Sale Id 1103',3997.60,0.00,0.00,5.26,0.00,'2022-06-11 17:48:30','',''),(1215,'21','222','1',1,'Retail Sale Id 1104',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 17:49:23','',''),(1216,'21','222','1',1,'Retail Sale Id 1105',8002.80,0.00,0.00,10.53,0.00,'2022-06-11 17:50:11','',''),(1217,'21','222','1',1,'Retail Sale Id 1106',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 17:53:10','',''),(1218,'21','222','1',1,'Retail Sale Id 1107',1998.80,0.00,0.00,2.63,0.00,'2022-06-11 17:54:00','',''),(1219,'21','222','1',1,'Retail Sale Id 1108',1520.00,0.00,0.00,2.00,0.00,'2022-06-11 17:55:21','',''),(1220,'21','222','1',1,'Retail Sale Id 1109',798.00,0.00,0.00,1.05,0.00,'2022-06-11 17:56:22','',''),(1221,'21','222','1',1,'Retail Sale Id 1110',5000.80,0.00,0.00,6.58,0.00,'2022-06-11 17:57:59','',''),(1222,'21','222','1',1,'Retail Sale Id 1111',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 18:00:50','',''),(1223,'21','222','1',1,'Retail Sale Id 1112',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 18:03:10','',''),(1224,'21','222','1',1,'Retail Sale Id 1113',1003.20,0.00,0.00,1.32,0.00,'2022-06-11 18:08:14','',''),(1225,'21','222','1',1,'Retail Sale Id 1114',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 18:19:12','',''),(1226,'21','222','1',1,'Retail Sale Id 1115',19000.00,0.00,0.00,25.00,0.00,'2022-06-11 18:22:16','',''),(1227,'21','222','1',1,'Retail Sale Id 1116',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 18:25:38','',''),(1228,'21','222','1',1,'Retail Sale Id 1117',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 18:27:59','',''),(1229,'21','222','1',1,'Retail Sale Id 1118',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 18:29:13','',''),(1230,'21','222','1',1,'Retail Sale Id 1119',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 18:36:40','',''),(1231,'21','222','1',1,'Retail Sale Id 1120',8998.40,0.00,0.00,11.84,0.00,'2022-06-11 18:38:21','',''),(1232,'21','222','1',1,'Retail Sale Id 1121',1603.60,0.00,0.00,2.11,0.00,'2022-06-11 18:39:26','',''),(1233,'21','222','1',1,'Retail Sale Id 1123',4499.20,0.00,0.00,5.92,0.00,'2022-06-11 18:44:38','',''),(1234,'21','222','1',1,'Retail Sale Id 1124',7600.00,0.00,0.00,10.00,0.00,'2022-06-11 18:49:30','',''),(1235,'21','222','1',1,'Retail Sale Id 1125',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 18:50:58','',''),(1236,'21','222','1',1,'Retail Sale Id 1126',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 18:52:07','',''),(1237,'21','222','1',1,'Retail Sale Id 1127',501.60,0.00,0.00,0.66,0.00,'2022-06-11 18:53:16','',''),(1238,'21','222','1',1,'Retail Sale Id 1128',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 18:56:42','',''),(1239,'21','222','1',1,'Retail Sale Id 1128',1497.20,0.00,0.00,1.97,0.00,'2022-06-11 18:56:42','',''),(1240,'21','222','1',1,'Retail Sale Id 1129',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 18:57:49','',''),(1241,'21','222','1',1,'Retail Sale Id 1130',7600.00,0.00,0.00,10.00,0.00,'2022-06-11 18:59:19','',''),(1242,'21','222','1',1,'Retail Sale Id 1131',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:00:27','',''),(1243,'21','222','1',1,'Retail Sale Id 1132',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:01:08','',''),(1244,'21','222','1',1,'Retail Sale Id 1133',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:02:16','',''),(1245,'21','222','1',1,'Retail Sale Id 1134',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:03:46','',''),(1246,'21','222','1',1,'Retail Sale Id 1135',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:04:44','',''),(1247,'21','222','1',1,'Retail Sale Id 1136',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 19:05:56','',''),(1248,'21','222','1',1,'Retail Sale Id 1137',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:06:41','',''),(1249,'21','222','1',1,'Retail Sale Id 1138',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:07:27','',''),(1250,'21','222','1',1,'Retail Sale Id 1139',1330.00,0.00,0.00,1.75,0.00,'2022-06-11 19:10:40','',''),(1251,'21','222','1',1,'Retail Sale Id 1139',1330.00,0.00,0.00,1.75,0.00,'2022-06-11 19:10:40','',''),(1252,'21','222','1',1,'Retail Sale Id 1140',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 19:15:04','',''),(1253,'21','222','1',1,'Retail Sale Id 1141',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:19:14','',''),(1254,'21','222','1',1,'Retail Sale Id 1142',8998.40,0.00,0.00,11.84,0.00,'2022-06-11 19:20:41','',''),(1255,'21','222','1',1,'Retail Sale Id 1143',1603.60,0.00,0.00,2.11,0.00,'2022-06-11 19:21:34','',''),(1256,'21','222','1',1,'Retail Sale Id 1144',8998.40,0.00,0.00,11.84,0.00,'2022-06-11 19:22:32','',''),(1257,'21','222','1',1,'Retail Sale Id 1145',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:23:35','',''),(1258,'21','222','1',1,'Retail Sale Id 1146',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 19:25:03','',''),(1259,'21','222','1',1,'Retail Sale Id 1147',3047.60,0.00,0.00,4.01,0.00,'2022-06-11 19:29:46','',''),(1260,'21','222','1',1,'Retail Sale Id 1148',5502.40,0.00,0.00,7.24,0.00,'2022-06-11 19:30:55','',''),(1261,'21','222','1',1,'Retail Sale Id 1149',3997.60,0.00,0.00,5.26,0.00,'2022-06-11 19:36:47','',''),(1262,'21','222','1',1,'Retail Sale Id 1150',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 19:38:50','',''),(1263,'21','222','1',1,'Retail Sale Id 1151',4560.00,0.00,0.00,6.00,0.00,'2022-06-11 19:40:17','',''),(1264,'21','222','1',1,'Retail Sale Id 1152',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 19:42:32','',''),(1265,'21','222','1',1,'Retail Sale Id 1153',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:44:07','',''),(1266,'21','222','1',1,'Retail Sale Id 1154',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:47:12','',''),(1267,'21','222','1',1,'Retail Sale Id 1155',1003.20,0.00,0.00,1.32,0.00,'2022-06-11 19:50:20','',''),(1268,'21','222','1',1,'Retail Sale Id 1156',3800.00,0.00,0.00,5.00,0.00,'2022-06-11 19:57:14','',''),(1269,'21','222','1',1,'Retail Sale Id 1157',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 19:58:04','',''),(1270,'21','222','1',1,'Retail Sale Id 1158',2280.00,0.00,0.00,3.00,0.00,'2022-06-11 20:01:46','',''),(1271,'21','222','1',1,'Retail Sale Id 1159',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 20:18:07','',''),(1272,'21','222','1',1,'Retail Sale Id 1160',38000.00,0.00,0.00,50.00,0.00,'2022-06-11 20:58:39','',''),(1273,'21','222','1',1,'Retail Sale Id 1161',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 20:59:50','',''),(1274,'21','222','1',1,'Retail Sale Id 1162',9500.00,0.00,0.00,12.50,0.00,'2022-06-11 21:00:34','',''),(1275,'21','222','1',1,'Retail Sale Id 1163',15200.00,0.00,0.00,20.00,0.00,'2022-06-11 21:01:25','',''),(1276,'21','222','1',1,'Retail Sale Id 1164',38000.00,0.00,0.00,50.00,0.00,'2022-06-11 21:02:05','',''),(1277,'21','222','1',1,'Retail Sale Id 1165',2052.00,0.00,0.00,2.70,0.00,'2022-06-11 21:02:46','',''),(1278,'21','222','1',1,'Retail Sale Id 1166',4750.00,0.00,0.00,6.25,0.00,'2022-06-12 08:07:52','',''),(1279,'21','222','1',1,'Retail Sale Id 1167',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 08:16:56','',''),(1280,'21','222','1',1,'Retail Sale Id 1168',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 08:19:00','',''),(1281,'21','222','1',1,'Retail Sale Id 1169',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 08:21:14','',''),(1282,'21','222','1',1,'Retail Sale Id 1170',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 08:27:19','',''),(1283,'21','222','1',1,'Retail Sale Id 1171',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 09:38:34','',''),(1284,'21','222','1',1,'Retail Sale Id 1172',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 09:39:43','',''),(1285,'21','222','1',1,'Retail Sale Id 1173',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 09:41:07','',''),(1286,'21','222','1',1,'Retail Sale Id 1174',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 09:44:03','',''),(1287,'21','222','1',1,'Retail Sale Id 1175',3997.60,0.00,0.00,5.26,0.00,'2022-06-12 09:45:30','',''),(1288,'21','222','1',1,'Retail Sale Id 1176',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 09:47:01','',''),(1289,'21','222','1',1,'Retail Sale Id 1177',3002.00,0.00,0.00,3.95,0.00,'2022-06-12 09:48:29','',''),(1290,'21','222','1',1,'Retail Sale Id 1178',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 09:49:59','',''),(1291,'21','222','1',1,'Retail Sale Id 1179',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 09:51:26','',''),(1292,'21','222','1',1,'Retail Sale Id 1180',3997.60,0.00,0.00,5.26,0.00,'2022-06-12 09:52:31','',''),(1293,'21','222','1',1,'Retail Sale Id 1181',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 09:53:52','',''),(1294,'21','222','1',1,'Retail Sale Id 1182',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 09:55:23','',''),(1295,'21','222','1',1,'Retail Sale Id 1182',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 09:55:23','',''),(1296,'21','222','1',1,'Retail Sale Id 1184',1998.80,0.00,0.00,2.63,0.00,'2022-06-12 10:04:34','',''),(1297,'21','222','1',1,'Retail Sale Id 1184',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 10:04:34','',''),(1298,'21','222','1',1,'Retail Sale Id 1185',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 10:06:26','',''),(1299,'21','222','1',1,'Retail Sale Id 1186',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 10:12:36','',''),(1300,'21','222','1',1,'Retail Sale Id 1187',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 10:21:13','',''),(1301,'21','222','1',1,'Retail Sale Id 1188',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 10:25:10','',''),(1302,'21','222','1',1,'Retail Sale Id 1189',3002.00,0.00,0.00,3.95,0.00,'2022-06-12 10:32:08','',''),(1303,'21','222','1',1,'Retail Sale Id 1190',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 10:36:27','',''),(1304,'21','222','1',1,'Retail Sale Id 1191',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 10:38:33','',''),(1305,'21','222','1',1,'Retail Sale Id 1192',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 10:40:46','',''),(1306,'21','222','1',1,'Retail Sale Id 1193',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 10:42:33','',''),(1307,'21','222','1',1,'Retail Sale Id 1194',3040.00,0.00,0.00,4.00,0.00,'2022-06-12 10:47:23','',''),(1308,'21','222','1',1,'Retail Sale Id 1195',1520.00,0.00,0.00,2.00,0.00,'2022-06-12 11:12:38','',''),(1309,'21','222','1',1,'Retail Sale Id 1196',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 11:27:33','',''),(1310,'21','222','1',1,'Retail Sale Id 1197',3002.00,0.00,0.00,3.95,0.00,'2022-06-12 11:29:10','',''),(1311,'21','222','1',1,'Retail Sale Id 1198',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 11:31:57','',''),(1312,'21','222','1',1,'Retail Sale Id 1199',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 11:33:05','',''),(1313,'21','222','1',1,'Retail Sale Id 1200',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 11:36:34','',''),(1314,'21','222','1',1,'Retail Sale Id 1201',3040.00,0.00,0.00,4.00,0.00,'2022-06-12 11:37:52','',''),(1315,'21','222','1',1,'Retail Sale Id 1202',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 11:39:13','',''),(1316,'21','222','1',1,'Retail Sale Id 1203',3997.60,0.00,0.00,5.26,0.00,'2022-06-12 11:41:17','',''),(1317,'21','222','1',1,'Retail Sale Id 1204',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 11:44:22','',''),(1318,'21','222','1',1,'Retail Sale Id 1205',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 11:45:47','',''),(1319,'21','222','1',1,'Retail Sale Id 1206',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 11:48:53','',''),(1320,'21','222','1',1,'Retail Sale Id 1207',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 11:50:45','',''),(1321,'21','222','1',1,'Retail Sale Id 1208',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 11:52:09','',''),(1322,'21','222','1',1,'Retail Sale Id 1209',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 11:55:53','',''),(1323,'21','222','1',1,'Retail Sale Id 1209',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 11:55:53','',''),(1324,'21','222','1',1,'Retail Sale Id 1210',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:02:49','',''),(1325,'21','222','1',1,'Retail Sale Id 1211',1003.20,0.00,0.00,1.32,0.00,'2022-06-12 12:04:04','',''),(1326,'21','222','1',1,'Retail Sale Id 1212',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 12:04:53','',''),(1327,'21','222','1',1,'Retail Sale Id 1213',3002.00,0.00,0.00,3.95,0.00,'2022-06-12 12:06:26','',''),(1328,'21','222','1',1,'Retail Sale Id 1214',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 12:07:16','',''),(1329,'21','222','1',1,'Retail Sale Id 1215',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 12:08:00','',''),(1330,'21','222','1',1,'Retail Sale Id 1216',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 12:09:41','',''),(1331,'21','222','1',1,'Retail Sale Id 1216',1497.20,0.00,0.00,1.97,0.00,'2022-06-12 12:09:41','',''),(1332,'21','222','1',1,'Retail Sale Id 1217',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:10:58','',''),(1333,'21','222','1',1,'Retail Sale Id 1218',5000.80,0.00,0.00,6.58,0.00,'2022-06-12 12:12:10','',''),(1334,'21','222','1',1,'Retail Sale Id 1219',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 12:13:20','',''),(1335,'21','222','1',1,'Retail Sale Id 1220',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:14:54','',''),(1336,'21','222','1',1,'Retail Sale Id 1221',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 12:15:53','',''),(1337,'21','222','1',1,'Retail Sale Id 1222',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 12:17:03','',''),(1338,'21','222','1',1,'Retail Sale Id 1223',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 12:23:15','',''),(1339,'21','222','1',1,'Retail Sale Id 1224',3040.00,0.00,0.00,4.00,0.00,'2022-06-12 12:25:07','',''),(1340,'21','222','1',1,'Retail Sale Id 1225',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:27:11','',''),(1341,'21','222','1',1,'Retail Sale Id 1226',3800.00,0.00,0.00,5.00,0.00,'2022-06-12 12:28:40','',''),(1342,'21','222','1',1,'Retail Sale Id 1227',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:32:35','',''),(1343,'21','222','1',1,'Retail Sale Id 1228',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 12:34:16','',''),(1344,'21','222','1',1,'Retail Sale Id 1229',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:36:28','',''),(1345,'21','222','1',1,'Retail Sale Id 1230',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:38:06','',''),(1346,'21','222','1',1,'Retail Sale Id 1231',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:40:10','',''),(1347,'21','222','1',1,'Retail Sale Id 1232',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:42:05','',''),(1348,'21','222','1',1,'Retail Sale Id 1233',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:43:35','',''),(1349,'21','222','1',1,'Retail Sale Id 1234',9120.00,0.00,0.00,12.00,0.00,'2022-06-12 12:45:26','',''),(1350,'21','222','1',1,'Retail Sale Id 1235',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:47:03','',''),(1351,'21','222','1',1,'Retail Sale Id 1236',3040.00,0.00,0.00,4.00,0.00,'2022-06-12 12:48:24','',''),(1352,'21','222','1',1,'Retail Sale Id 1237',6080.00,0.00,0.00,8.00,0.00,'2022-06-12 12:52:07','',''),(1353,'21','222','1',1,'Retail Sale Id 1238',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:54:24','',''),(1354,'21','222','1',1,'Retail Sale Id 1239',2280.00,0.00,0.00,3.00,0.00,'2022-06-12 12:56:36','',''),(1355,'21','222','1',1,'Retail Sale Id 1240',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 12:58:40','',''),(1356,'21','222','1',1,'Retail Sale Id 1241',4560.00,0.00,0.00,6.00,0.00,'2022-06-12 13:04:14','',''),(1357,'21','222','1',1,'Retail Sale Id 1242',6080.00,0.00,0.00,8.00,0.00,'2022-06-12 13:05:39','',''),(1358,'21','222','1',1,'Retail Sale Id 1243',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 13:16:13','',''),(1359,'21','222','1',1,'Retail Sale Id 1244',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 13:22:06','',''),(1360,'21','222','1',1,'Retail Sale Id 1245',7600.00,0.00,0.00,10.00,0.00,'2022-06-12 13:26:54','',''),(1361,'21','222','1',1,'Retail Sale Id 1246',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:00:33','',''),(1362,'21','222','1',1,'Retail Sale Id 1247',15200.00,0.00,0.00,20.00,0.00,'2022-06-12 15:01:44','',''),(1363,'21','222','1',1,'Retail Sale Id 1248',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 15:02:30','',''),(1364,'21','222','1',1,'Retail Sale Id 1249',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 15:03:22','',''),(1365,'21','222','1',1,'Retail Sale Id 1250',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 15:04:16','',''),(1366,'21','222','1',1,'Retail Sale Id 1251',9500.00,0.00,0.00,12.50,0.00,'2022-06-12 15:04:52','',''),(1367,'21','222','1',1,'Retail Sale Id 1252',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:05:37','',''),(1368,'21','222','1',1,'Retail Sale Id 1253',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:06:30','',''),(1369,'21','222','1',1,'Retail Sale Id 1254',15200.00,0.00,0.00,20.00,0.00,'2022-06-12 15:07:11','',''),(1370,'21','222','1',1,'Retail Sale Id 1255',8998.40,0.00,0.00,11.84,0.00,'2022-06-12 15:08:02','',''),(1371,'21','222','1',1,'Retail Sale Id 1256',8998.40,0.00,0.00,11.84,0.00,'2022-06-12 15:08:40','',''),(1372,'21','222','1',1,'Retail Sale Id 1257',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:09:29','',''),(1373,'21','222','1',1,'Retail Sale Id 1258',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:10:19','',''),(1374,'21','222','1',1,'Retail Sale Id 1259',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:11:00','',''),(1375,'21','222','1',1,'Retail Sale Id 1260',10997.20,0.00,0.00,14.47,0.00,'2022-06-12 15:11:50','',''),(1376,'21','222','1',1,'Retail Sale Id 1261',9120.00,0.00,0.00,12.00,0.00,'2022-06-12 15:12:55','',''),(1377,'21','222','1',1,'Retail Sale Id 1262',7600.00,0.00,0.00,10.00,0.00,'2022-06-12 15:13:57','',''),(1378,'21','222','1',1,'Retail Sale Id 1263',15200.00,0.00,0.00,20.00,0.00,'2022-06-12 15:14:43','',''),(1379,'21','222','1',1,'Retail Sale Id 1264',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:15:34','',''),(1380,'21','222','1',1,'Retail Sale Id 1265',19000.00,0.00,0.00,25.00,0.00,'2022-06-12 15:16:26','',''),(1381,'21','222','1',1,'Retail Sale Id 1266',19000.00,0.00,0.00,25.00,0.00,'2022-06-12 15:17:09','',''),(1382,'21','222','1',1,'Retail Sale Id 1267',17001.20,0.00,0.00,22.37,0.00,'2022-06-12 15:18:16','',''),(1383,'21','222','1',1,'Retail Sale Id 1268',6999.60,0.00,0.00,9.21,0.00,'2022-06-12 15:18:52','',''),(1384,'21','222','1',1,'Retail Sale Id 1269',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:19:59','',''),(1385,'21','222','1',1,'Retail Sale Id 1270',38000.00,0.00,0.00,50.00,0.00,'2022-06-12 15:20:55','',''),(1386,'21','222','1',1,'Retail Sale Id 1271',8588.00,0.00,0.00,11.30,0.00,'2022-06-12 15:21:58','',''),(1387,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-06-14 12:20:57','',''),(1388,'21','222',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,4999.74,0.00,'2022-06-14 12:31:54','',''),(1389,'21','222','1',1,'Received from bridging 14',0.00,0.00,4999.74,0.00,0.00,'2022-06-14 12:31:54','',''),(1390,'21','222','1',1,'Retail Sale Id 1272',38000.00,0.00,0.00,50.00,0.00,'2022-06-14 13:00:25','',''),(1391,'21','222','1',1,'Retail Sale Id 1273',15200.00,0.00,0.00,20.00,0.00,'2022-06-14 13:00:58','',''),(1392,'21','222','1',1,'Retail Sale Id 1274',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 13:01:44','',''),(1393,'21','222','1',1,'Retail Sale Id 1275',7600.00,0.00,0.00,10.00,0.00,'2022-06-14 13:02:16','',''),(1394,'21','222','1',1,'Retail Sale Id 1276',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 13:03:13','',''),(1395,'21','222','1',1,'Retail Sale Id 1277',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 13:06:09','',''),(1396,'21','222','1',1,'Retail Sale Id 1278',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 13:11:28','',''),(1397,'21','222','1',1,'Retail Sale Id 1279',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 13:37:41','',''),(1398,'21','222','1',1,'Retail Sale Id 1280',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 14:05:01','',''),(1399,'21','222','1',1,'Retail Sale Id 1280',3420.00,0.00,0.00,4.50,0.00,'2022-06-14 14:05:01','',''),(1400,'21','222','1',1,'Retail Sale Id 1281',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 14:09:20','',''),(1401,'21','222','1',1,'Retail Sale Id 1282',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 14:14:10','',''),(1402,'21','222','1',1,'Retail Sale Id 1282',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 14:14:10','',''),(1403,'21','222','1',1,'Retail Sale Id 1283',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 14:15:11','',''),(1404,'21','222','1',1,'Retail Sale Id 1284',8998.40,0.00,0.00,11.84,0.00,'2022-06-14 14:19:20','',''),(1405,'21','222','1',1,'Retail Sale Id 1285',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 14:29:24','',''),(1406,'21','222','1',1,'Retail Sale Id 1286',1003.20,0.00,0.00,1.32,0.00,'2022-06-14 14:34:30','',''),(1407,'21','222','1',1,'Retail Sale Id 1286',1003.20,0.00,0.00,1.32,0.00,'2022-06-14 14:34:30','',''),(1408,'21','222','1',1,'Retail Sale Id 1287',3040.00,0.00,0.00,4.00,0.00,'2022-06-14 14:39:06','',''),(1409,'21','222','1',1,'Retail Sale Id 1288',15200.00,0.00,0.00,20.00,0.00,'2022-06-14 14:47:46','',''),(1410,'21','222','1',1,'Retail Sale Id 1290',4499.20,0.00,0.00,5.92,0.00,'2022-06-14 14:49:50','',''),(1411,'21','222','1',1,'Retail Sale Id 1291',3002.00,0.00,0.00,3.95,0.00,'2022-06-14 14:51:11','',''),(1412,'21','222','1',1,'Retail Sale Id 1292',8002.80,0.00,0.00,10.53,0.00,'2022-06-14 14:53:00','',''),(1413,'21','222','1',1,'Retail Sale Id 1292',8998.40,0.00,0.00,11.84,0.00,'2022-06-14 14:53:00','',''),(1414,'21','222','1',1,'Retail Sale Id 1293',3997.60,0.00,0.00,5.26,0.00,'2022-06-14 14:53:58','',''),(1415,'21','222','1',1,'Retail Sale Id 1294',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 14:55:59','',''),(1416,'21','222','1',1,'Retail Sale Id 1295',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 14:56:46','',''),(1417,'21','222','1',1,'Retail Sale Id 1296',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 14:58:47','',''),(1418,'21','222','1',1,'Retail Sale Id 1297',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 15:00:05','',''),(1419,'21','222','1',1,'Retail Sale Id 1298',8002.80,0.00,0.00,10.53,0.00,'2022-06-14 15:01:14','',''),(1420,'21','222','1',1,'Retail Sale Id 1299',1520.00,0.00,0.00,2.00,0.00,'2022-06-14 15:02:19','',''),(1421,'21','222','1',1,'Retail Sale Id 1300',1003.20,0.00,0.00,1.32,0.00,'2022-06-14 15:04:25','',''),(1422,'21','222','1',1,'Retail Sale Id 1300',1003.20,0.00,0.00,1.32,0.00,'2022-06-14 15:04:25','',''),(1423,'21','222','1',1,'Retail Sale Id 1301',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 15:08:07','',''),(1424,'21','222','1',1,'Retail Sale Id 1302',8496.80,0.00,0.00,11.18,0.00,'2022-06-14 15:09:24','',''),(1425,'21','222','1',1,'Retail Sale Id 1303',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 15:16:26','',''),(1426,'21','222','1',1,'Retail Sale Id 1305',7600.00,0.00,0.00,10.00,0.00,'2022-06-14 15:18:55','',''),(1427,'21','222','1',1,'Retail Sale Id 1306',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 15:28:44','',''),(1428,'21','222','1',1,'Retail Sale Id 1307',19000.00,0.00,0.00,25.00,0.00,'2022-06-14 15:41:06','',''),(1429,'21','222','1',1,'Retail Sale Id 1308',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 15:44:15','',''),(1430,'21','222','1',1,'Retail Sale Id 1309',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 15:45:51','',''),(1431,'21','222','1',1,'Retail Sale Id 1310',3503.60,0.00,0.00,4.61,0.00,'2022-06-14 15:46:53','',''),(1432,'21','222','1',1,'Retail Sale Id 1311',5996.40,0.00,0.00,7.89,0.00,'2022-06-14 15:49:35','',''),(1433,'21','222','1',1,'Retail Sale Id 1312',152000.00,0.00,0.00,200.00,0.00,'2022-06-14 15:50:55','',''),(1434,'21','222','1',1,'Retail Sale Id 1313',1520.00,0.00,0.00,2.00,0.00,'2022-06-14 15:55:50','',''),(1435,'21','222','1',1,'Retail Sale Id 1314',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 15:57:37','',''),(1436,'21','222','1',1,'Retail Sale Id 1315',7600.00,0.00,0.00,10.00,0.00,'2022-06-14 16:02:21','',''),(1437,'21','222','1',1,'Retail Sale Id 1316',5000.80,0.00,0.00,6.58,0.00,'2022-06-14 16:10:11','',''),(1438,'21','222','1',1,'Retail Sale Id 1317',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 16:12:05','',''),(1439,'21','222','1',1,'Retail Sale Id 1318',3040.00,0.00,0.00,4.00,0.00,'2022-06-14 16:22:33','',''),(1440,'21','222','1',1,'Retail Sale Id 1319',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 16:25:20','',''),(1441,'21','222','1',1,'Retail Sale Id 1319',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 16:25:20','',''),(1442,'21','222','1',1,'Retail Sale Id 1320',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 16:29:22','',''),(1443,'21','222','1',1,'Retail Sale Id 1321',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 16:32:54','',''),(1444,'21','222','1',1,'Retail Sale Id 1322',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 16:37:51','',''),(1445,'21','222','1',1,'Retail Sale Id 1323',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 16:40:05','',''),(1446,'21','222','1',1,'Retail Sale Id 1324',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 16:41:42','',''),(1447,'21','222','1',1,'Retail Sale Id 1325',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 16:42:56','',''),(1448,'21','222','1',1,'Retail Sale Id 1326',7600.00,0.00,0.00,10.00,0.00,'2022-06-14 16:45:51','',''),(1449,'21','222','1',1,'Retail Sale Id 1327',5000.80,0.00,0.00,6.58,0.00,'2022-06-14 16:48:06','',''),(1450,'21','222','1',1,'Retail Sale Id 1328',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 16:50:26','',''),(1451,'21','222','1',1,'Retail Sale Id 1329',5000.80,0.00,0.00,6.58,0.00,'2022-06-14 16:51:42','',''),(1452,'21','222','1',1,'Retail Sale Id 1330',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 16:53:26','',''),(1453,'21','222','1',1,'Retail Sale Id 1331',3002.00,0.00,0.00,3.95,0.00,'2022-06-14 16:55:07','',''),(1454,'21','222','1',1,'Retail Sale Id 1332',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 16:57:57','',''),(1455,'21','222','1',1,'Retail Sale Id 1333',1801.20,0.00,0.00,2.37,0.00,'2022-06-14 17:01:01','',''),(1456,'21','222','1',1,'Retail Sale Id 1334',5000.80,0.00,0.00,6.58,0.00,'2022-06-14 17:01:51','',''),(1457,'21','222','1',1,'Retail Sale Id 1335',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 17:03:54','',''),(1458,'21','222','1',1,'Retail Sale Id 1335',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 17:03:54','',''),(1459,'21','222','1',1,'Retail Sale Id 1336',38000.00,0.00,0.00,50.00,0.00,'2022-06-14 17:08:12','',''),(1460,'21','222','1',1,'Retail Sale Id 1337',5996.40,0.00,0.00,7.89,0.00,'2022-06-14 17:09:46','',''),(1461,'21','222','1',1,'Retail Sale Id 1338',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 17:11:06','',''),(1462,'21','222','1',1,'Retail Sale Id 1339',8002.80,0.00,0.00,10.53,0.00,'2022-06-14 17:15:02','',''),(1463,'21','222','1',1,'Retail Sale Id 1340',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 17:20:29','',''),(1464,'21','222','1',1,'Retail Sale Id 1341',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 17:22:53','',''),(1465,'21','222','1',1,'Retail Sale Id 1342',7600.00,0.00,0.00,10.00,0.00,'2022-06-14 17:23:49','',''),(1466,'21','222','1',1,'Retail Sale Id 1343',6840.00,0.00,0.00,9.00,0.00,'2022-06-14 17:25:05','',''),(1467,'21','222','1',1,'Retail Sale Id 1344',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 17:26:46','',''),(1468,'21','222','1',1,'Retail Sale Id 1345',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 17:28:22','',''),(1469,'21','222','1',1,'Retail Sale Id 1346',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 17:29:58','',''),(1470,'21','222','1',1,'Retail Sale Id 1347',15200.00,0.00,0.00,20.00,0.00,'2022-06-14 17:32:32','',''),(1471,'21','222','1',1,'Retail Sale Id 1348',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 17:33:52','',''),(1472,'21','222','1',1,'Retail Sale Id 1349',3002.00,0.00,0.00,3.95,0.00,'2022-06-14 17:34:35','',''),(1473,'21','222','1',1,'Retail Sale Id 1350',1998.80,0.00,0.00,2.63,0.00,'2022-06-14 17:36:47','',''),(1474,'21','222','1',1,'Retail Sale Id 1351',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 17:37:57','',''),(1475,'21','222','1',1,'Retail Sale Id 1352',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 17:38:44','',''),(1476,'21','222','1',1,'Retail Sale Id 1353',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 17:41:12','',''),(1477,'21','222','1',1,'Retail Sale Id 1354',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 17:44:07','',''),(1478,'21','222','1',1,'Retail Sale Id 1355',8002.80,0.00,0.00,10.53,0.00,'2022-06-14 18:40:01','',''),(1479,'21','222','1',1,'Retail Sale Id 1356',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 18:41:45','',''),(1480,'21','222','1',1,'Retail Sale Id 1357',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 18:43:11','',''),(1481,'21','222','1',1,'Retail Sale Id 1358',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 18:45:09','',''),(1482,'21','222','1',1,'Retail Sale Id 1359',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 18:46:31','',''),(1483,'21','222','1',1,'Retail Sale Id 1360',1003.20,0.00,0.00,1.32,0.00,'2022-06-14 18:48:13','',''),(1484,'21','222','1',1,'Retail Sale Id 1362',1003.20,0.00,0.00,1.32,0.00,'2022-06-14 18:50:10','',''),(1485,'21','222','1',1,'Retail Sale Id 1363',3800.00,0.00,0.00,5.00,0.00,'2022-06-14 18:51:56','',''),(1486,'21','222','1',1,'Retail Sale Id 1364',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 18:54:39','',''),(1487,'21','222','1',1,'Retail Sale Id 1365',6999.60,0.00,0.00,9.21,0.00,'2022-06-14 18:58:06','',''),(1488,'21','222','1',1,'Retail Sale Id 1366',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 19:00:51','',''),(1489,'21','222','1',1,'Retail Sale Id 1367',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 19:02:30','',''),(1490,'21','222','1',1,'Retail Sale Id 1368',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 19:06:12','',''),(1491,'21','222','1',1,'Retail Sale Id 1369',1900.00,0.00,0.00,2.50,0.00,'2022-06-14 19:07:57','',''),(1492,'21','222','1',1,'Retail Sale Id 1370',1497.20,0.00,0.00,1.97,0.00,'2022-06-14 19:10:25','',''),(1493,'21','222','1',1,'Retail Sale Id 1371',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 19:14:23','',''),(1494,'21','222','1',1,'Retail Sale Id 1372',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 19:17:00','',''),(1495,'21','222','1',1,'Retail Sale Id 1373',7600.00,0.00,0.00,10.00,0.00,'2022-06-14 19:19:04','',''),(1496,'21','222','1',1,'Retail Sale Id 1374',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 19:20:25','',''),(1497,'21','222','1',1,'Retail Sale Id 1375',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 19:26:23','',''),(1498,'21','222','1',1,'Retail Sale Id 1376',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 19:28:13','',''),(1499,'21','222','1',1,'Retail Sale Id 1377',3503.60,0.00,0.00,4.61,0.00,'2022-06-14 19:30:26','',''),(1500,'21','222','1',1,'Retail Sale Id 1378',2280.00,0.00,0.00,3.00,0.00,'2022-06-14 19:32:14','',''),(1501,'21','222','1',1,'Retail Sale Id 1380',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 19:46:50','',''),(1502,'21','222','1',1,'Retail Sale Id 1381',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 19:50:24','',''),(1503,'21','222','1',1,'Retail Sale Id 1382',4598.00,0.00,0.00,6.05,0.00,'2022-06-14 19:53:13','',''),(1504,'21','222','1',1,'Retail Sale Id 1383',4560.00,0.00,0.00,6.00,0.00,'2022-06-14 19:54:52','',''),(1505,'21','222','1',1,'Retail Sale Id 1384',5000.80,0.00,0.00,6.58,0.00,'2022-06-14 20:06:17','',''),(1506,'21','222','1',1,'Retail Sale Id 1386',3997.60,0.00,0.00,5.26,0.00,'2022-06-14 20:09:56','',''),(1507,'21','222','1',1,'Retail Sale Id 1387',38000.00,0.00,0.00,50.00,0.00,'2022-06-14 20:28:40','',''),(1508,'21','222','1',1,'Retail Sale Id 1388',19000.00,0.00,0.00,25.00,0.00,'2022-06-14 20:29:25','',''),(1509,'21','222','1',1,'Retail Sale Id 1389',19000.00,0.00,0.00,25.00,0.00,'2022-06-14 20:30:04','',''),(1510,'21','222','1',1,'Retail Sale Id 1390',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 20:30:57','',''),(1511,'21','222','1',1,'Retail Sale Id 1390',9500.00,0.00,0.00,12.50,0.00,'2022-06-14 20:30:57','',''),(1512,'21','222','1',1,'Retail Sale Id 1391',19000.00,0.00,0.00,25.00,0.00,'2022-06-14 20:31:32','',''),(1513,'21','222','1',1,'Retail Sale Id 1392',38000.00,0.00,0.00,50.00,0.00,'2022-06-14 20:32:18','',''),(1514,'21','222','1',1,'Retail Sale Id 1393',3473.20,0.00,0.00,4.57,0.00,'2022-06-14 20:33:08','',''),(1515,'21','222','1',1,'Retail Sale Id 1394',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 08:37:06','',''),(1516,'21','222','1',1,'Retail Sale Id 1395',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 08:46:52','',''),(1517,'21','222','1',1,'Retail Sale Id 1396',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 08:49:14','',''),(1518,'21','222','1',1,'Retail Sale Id 1397',1520.00,0.00,0.00,2.00,0.00,'2022-06-15 08:54:01','',''),(1519,'21','222','1',1,'Retail Sale Id 1398',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 08:59:55','',''),(1520,'21','222','1',1,'Retail Sale Id 1399',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 09:01:20','',''),(1521,'21','222','1',1,'Retail Sale Id 1400',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 09:02:57','',''),(1522,'21','222','1',1,'Retail Sale Id 1401',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 09:04:20','',''),(1523,'21','222','1',1,'Retail Sale Id 1401',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 09:04:20','',''),(1524,'21','222','1',1,'Retail Sale Id 1402',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 09:07:03','',''),(1525,'21','222','1',1,'Retail Sale Id 1403',2796.80,0.00,0.00,3.68,0.00,'2022-06-15 09:09:19','',''),(1526,'21','222','1',1,'Retail Sale Id 1404',8002.80,0.00,0.00,10.53,0.00,'2022-06-15 09:15:38','',''),(1527,'21','222','1',1,'Retail Sale Id 1405',1003.20,0.00,0.00,1.32,0.00,'2022-06-15 09:17:45','',''),(1528,'21','222','1',1,'Retail Sale Id 1406',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 09:21:03','',''),(1529,'21','222','1',1,'Retail Sale Id 1407',3800.00,0.00,0.00,5.00,0.00,'2022-06-15 09:33:51','',''),(1530,'21','222','1',1,'Retail Sale Id 1408',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 09:37:26','',''),(1531,'21','222','1',1,'Retail Sale Id 1409',1497.20,0.00,0.00,1.97,0.00,'2022-06-15 09:39:18','',''),(1532,'21','222','1',1,'Retail Sale Id 1410',2698.00,0.00,0.00,3.55,0.00,'2022-06-15 09:41:31','',''),(1533,'21','222','1',1,'Retail Sale Id 1411',3040.00,0.00,0.00,4.00,0.00,'2022-06-15 09:47:01','',''),(1534,'21','222','1',1,'Retail Sale Id 1412',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 09:56:37','',''),(1535,'21','222','1',1,'Retail Sale Id 1413',8002.80,0.00,0.00,10.53,0.00,'2022-06-15 09:57:37','',''),(1536,'21','222','1',1,'Retail Sale Id 1414',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 09:59:44','',''),(1537,'21','222','1',1,'Retail Sale Id 1415',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 10:03:12','',''),(1538,'21','222','1',1,'Retail Sale Id 1416',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 10:05:13','',''),(1539,'21','222','1',1,'Retail Sale Id 1417',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 10:07:19','',''),(1540,'21','222','1',1,'Retail Sale Id 1418',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 10:49:28','',''),(1541,'21','222','1',1,'Retail Sale Id 1419',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 10:52:16','',''),(1542,'21','222','1',1,'Retail Sale Id 1420',19000.00,0.00,0.00,25.00,0.00,'2022-06-15 10:55:05','',''),(1543,'21','222','1',1,'Retail Sale Id 1421',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 11:01:13','',''),(1544,'21','222','1',1,'Retail Sale Id 1422',8496.80,0.00,0.00,11.18,0.00,'2022-06-15 11:02:40','',''),(1545,'21','222','1',1,'Retail Sale Id 1423',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 11:05:41','',''),(1546,'21','222','1',1,'Retail Sale Id 1424',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 13:18:41','',''),(1547,'21','222','1',1,'Retail Sale Id 1425',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 13:24:58','',''),(1548,'21','222','1',1,'Retail Sale Id 1426',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 13:28:17','',''),(1549,'21','222','1',1,'Retail Sale Id 1426',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 13:28:17','',''),(1550,'21','222','1',1,'Retail Sale Id 1427',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 13:33:14','',''),(1551,'21','222','1',1,'Retail Sale Id 1428',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 13:38:27','',''),(1552,'21','222','1',1,'Retail Sale Id 1429',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 14:17:50','',''),(1553,'21','222','1',1,'Retail Sale Id 1429',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 14:17:50','',''),(1554,'21','222','1',1,'Retail Sale Id 1429',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 14:17:50','',''),(1555,'21','222','1',1,'Retail Sale Id 1429',38000.00,0.00,0.00,50.00,0.00,'2022-06-15 14:17:50','',''),(1556,'21','222','1',1,'Retail Sale Id 1430',11400.00,0.00,0.00,15.00,0.00,'2022-06-15 14:24:48','',''),(1557,'21','222','1',1,'Retail Sale Id 1432',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 14:29:11','',''),(1558,'21','222','1',1,'Retail Sale Id 1433',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 14:51:39','',''),(1559,'21','222','1',1,'Retail Sale Id 1434',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 14:53:02','',''),(1560,'21','222','1',1,'Retail Sale Id 1435',19000.00,0.00,0.00,25.00,0.00,'2022-06-15 14:56:28','',''),(1561,'21','222','1',1,'Retail Sale Id 1436',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 14:57:57','',''),(1562,'21','222','1',1,'Retail Sale Id 1437',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 14:59:10','',''),(1563,'21','222','1',1,'Retail Sale Id 1438',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 15:00:24','',''),(1564,'21','222','1',1,'Retail Sale Id 1439',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 15:04:09','',''),(1565,'21','222','1',1,'Retail Sale Id 1440',3040.00,0.00,0.00,4.00,0.00,'2022-06-15 15:05:30','',''),(1566,'21','222','1',1,'Retail Sale Id 1441',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 15:27:13','',''),(1567,'21','222','1',1,'Retail Sale Id 1442',15298.80,0.00,0.00,20.13,0.00,'2022-06-15 15:42:08','',''),(1568,'21','222','1',1,'Retail Sale Id 1443',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 15:46:14','',''),(1569,'21','222','1',1,'Retail Sale Id 1444',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 15:47:57','',''),(1570,'21','222','1',1,'Retail Sale Id 1445',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 15:49:18','',''),(1571,'21','222','1',1,'Retail Sale Id 1446',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 15:52:01','',''),(1572,'21','222','1',1,'Retail Sale Id 1447',798.00,0.00,0.00,1.05,0.00,'2022-06-15 15:52:59','',''),(1573,'21','222','1',1,'Retail Sale Id 1448',15200.00,0.00,0.00,20.00,0.00,'2022-06-15 15:55:54','',''),(1574,'21','222','1',1,'Retail Sale Id 1449',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 15:57:38','',''),(1575,'21','222','1',1,'Retail Sale Id 1450',6999.60,0.00,0.00,9.21,0.00,'2022-06-15 15:59:26','',''),(1576,'21','222','1',1,'Retail Sale Id 1451',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 16:00:46','',''),(1577,'21','222','1',1,'Retail Sale Id 1452',6999.60,0.00,0.00,9.21,0.00,'2022-06-15 16:01:35','',''),(1578,'21','222','1',1,'Retail Sale Id 1453',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 16:06:05','',''),(1579,'21','222','1',1,'Retail Sale Id 1454',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 16:08:08','',''),(1580,'21','222','1',1,'Retail Sale Id 1455',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 16:14:47','',''),(1581,'21','222','1',1,'Retail Sale Id 1456',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 16:20:34','',''),(1582,'21','222','1',1,'Retail Sale Id 1457',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 16:25:09','',''),(1583,'21','222','1',1,'Retail Sale Id 1458',4750.00,0.00,0.00,6.25,0.00,'2022-06-15 16:30:29','',''),(1584,'21','222','1',1,'Retail Sale Id 1459',798.00,0.00,0.00,1.05,0.00,'2022-06-15 16:32:15','',''),(1585,'21','222','1',1,'Retail Sale Id 1460',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 16:33:18','',''),(1586,'21','222','1',1,'Retail Sale Id 1461',3800.00,0.00,0.00,5.00,0.00,'2022-06-15 16:34:46','',''),(1587,'21','222','1',1,'Retail Sale Id 1462',5000.80,0.00,0.00,6.58,0.00,'2022-06-15 16:38:07','',''),(1588,'21','222','1',1,'Retail Sale Id 1463',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 16:42:20','',''),(1589,'21','222','1',1,'Retail Sale Id 1464',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 16:44:26','',''),(1590,'21','222','1',1,'Retail Sale Id 1465',3800.00,0.00,0.00,5.00,0.00,'2022-06-15 17:01:05','',''),(1591,'21','222','1',1,'Retail Sale Id 1466',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 17:27:38','',''),(1592,'21','222','1',1,'Retail Sale Id 1467',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 17:30:41','',''),(1593,'21','222','1',1,'Retail Sale Id 1467',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 17:30:41','',''),(1594,'21','222','1',1,'Retail Sale Id 1468',1497.20,0.00,0.00,1.97,0.00,'2022-06-15 17:32:10','',''),(1595,'21','222','1',1,'Retail Sale Id 1469',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 17:32:56','',''),(1596,'21','222','1',1,'Retail Sale Id 1470',7600.00,0.00,0.00,10.00,0.00,'2022-06-15 17:34:26','',''),(1597,'21','222','1',1,'Retail Sale Id 1471',7600.00,0.00,0.00,10.00,0.00,'2022-06-15 17:35:44','',''),(1598,'21','222','1',1,'Retail Sale Id 1472',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 17:37:05','',''),(1599,'21','222','1',1,'Retail Sale Id 1473',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 17:38:11','',''),(1600,'21','222','1',1,'Retail Sale Id 1474',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 17:38:55','',''),(1601,'21','222','1',1,'Retail Sale Id 1475',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 17:39:55','',''),(1602,'21','222','1',1,'Retail Sale Id 1476',5000.80,0.00,0.00,6.58,0.00,'2022-06-15 17:41:13','',''),(1603,'21','222','1',1,'Retail Sale Id 1477',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 17:42:16','',''),(1604,'21','222','1',1,'Retail Sale Id 1478',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 17:45:51','',''),(1605,'21','222','1',1,'Retail Sale Id 1479',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 17:48:17','',''),(1606,'21','222','1',1,'Retail Sale Id 1480',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 17:49:48','',''),(1607,'21','222','1',1,'Retail Sale Id 1480',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 17:49:48','',''),(1608,'21','222','1',1,'Retail Sale Id 1482',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:00:54','',''),(1609,'21','222','1',1,'Retail Sale Id 1483',5000.80,0.00,0.00,6.58,0.00,'2022-06-15 18:03:21','',''),(1610,'21','222','1',1,'Retail Sale Id 1484',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 18:03:59','',''),(1611,'21','222','1',1,'Retail Sale Id 1485',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 18:04:59','',''),(1612,'21','222','1',1,'Retail Sale Id 1486',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:06:20','',''),(1613,'21','222','1',1,'Retail Sale Id 1487',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:07:40','',''),(1614,'21','222','1',1,'Retail Sale Id 1488',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 18:09:37','',''),(1615,'21','222','1',1,'Retail Sale Id 1489',1003.20,0.00,0.00,1.32,0.00,'2022-06-15 18:10:45','',''),(1616,'21','222','1',1,'Retail Sale Id 1490',1003.20,0.00,0.00,1.32,0.00,'2022-06-15 18:11:41','',''),(1617,'21','222','1',1,'Retail Sale Id 1491',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 18:12:38','',''),(1618,'21','222','1',1,'Retail Sale Id 1492',1003.20,0.00,0.00,1.32,0.00,'2022-06-15 18:13:51','',''),(1619,'21','222','1',1,'Retail Sale Id 1492',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 18:13:51','',''),(1620,'21','222','1',1,'Retail Sale Id 1493',1520.00,0.00,0.00,2.00,0.00,'2022-06-15 18:17:02','',''),(1621,'21','222','1',1,'Retail Sale Id 1494',1520.00,0.00,0.00,2.00,0.00,'2022-06-15 18:21:28','',''),(1622,'21','222','1',1,'Retail Sale Id 1495',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 18:23:29','',''),(1623,'21','222','1',1,'Retail Sale Id 1496',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:26:07','',''),(1624,'21','222','1',1,'Retail Sale Id 1497',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 18:27:20','',''),(1625,'21','222','1',1,'Retail Sale Id 1498',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:28:11','',''),(1626,'21','222','1',1,'Retail Sale Id 1499',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 18:29:02','',''),(1627,'21','222','1',1,'Retail Sale Id 1500',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:30:24','',''),(1628,'21','222','1',1,'Retail Sale Id 1501',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 18:32:04','',''),(1629,'21','222','1',1,'Retail Sale Id 1502',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:36:39','',''),(1630,'21','222','1',1,'Retail Sale Id 1502',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:36:39','',''),(1631,'21','222','1',1,'Retail Sale Id 1503',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:37:33','',''),(1632,'21','222','1',1,'Retail Sale Id 1504',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:40:01','',''),(1633,'21','222','1',1,'Retail Sale Id 1505',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:41:15','',''),(1634,'21','222','1',1,'Retail Sale Id 1506',1140.00,0.00,0.00,1.50,0.00,'2022-06-15 18:42:47','',''),(1635,'21','222','1',1,'Retail Sale Id 1507',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 18:44:32','',''),(1636,'21','222','1',1,'Retail Sale Id 1509',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 18:47:30','',''),(1637,'21','222','1',1,'Retail Sale Id 1510',760.00,0.00,0.00,1.00,0.00,'2022-06-15 18:48:29','',''),(1638,'21','222','1',1,'Retail Sale Id 1511',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 18:49:41','',''),(1639,'21','222','1',1,'Retail Sale Id 1512',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 18:50:39','',''),(1640,'21','222','1',1,'Retail Sale Id 1513',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 18:52:28','',''),(1641,'21','222','1',1,'Retail Sale Id 1514',1003.20,0.00,0.00,1.32,0.00,'2022-06-15 18:56:43','',''),(1642,'21','222','1',1,'Retail Sale Id 1514',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 18:56:43','',''),(1643,'21','222','1',1,'Retail Sale Id 1515',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 19:00:09','',''),(1644,'21','222','1',1,'Retail Sale Id 1516',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 19:11:50','',''),(1645,'21','222','1',1,'Retail Sale Id 1517',699.20,0.00,0.00,0.92,0.00,'2022-06-15 19:37:38','',''),(1646,'21','222','1',1,'Retail Sale Id 1518',2280.00,0.00,0.00,3.00,0.00,'2022-06-15 19:42:01','',''),(1647,'21','222','1',1,'Retail Sale Id 1519',3002.00,0.00,0.00,3.95,0.00,'2022-06-15 19:44:28','',''),(1648,'21','222','1',1,'Retail Sale Id 1520',8360.00,0.00,0.00,11.00,0.00,'2022-06-15 19:58:45','',''),(1649,'21','222','1',1,'Retail Sale Id 1521',4560.00,0.00,0.00,6.00,0.00,'2022-06-15 20:06:08','',''),(1650,'21','222','1',1,'Retail Sale Id 1522',1998.80,0.00,0.00,2.63,0.00,'2022-06-15 20:07:40','',''),(1651,'21','222','1',1,'Retail Sale Id 1523',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 20:08:56','',''),(1652,'21','222','1',1,'Retail Sale Id 1523',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 20:08:56','',''),(1653,'21','222','1',1,'Retail Sale Id 1524',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 20:11:33','',''),(1654,'21','222','1',1,'Retail Sale Id 1525',5996.40,0.00,0.00,7.89,0.00,'2022-06-15 20:28:26','',''),(1655,'21','222','1',1,'Retail Sale Id 1526',38000.00,0.00,0.00,50.00,0.00,'2022-06-15 21:35:33','',''),(1656,'21','222','1',1,'Retail Sale Id 1527',38000.00,0.00,0.00,50.00,0.00,'2022-06-15 21:36:21','',''),(1657,'21','222','1',1,'Retail Sale Id 1528',15200.00,0.00,0.00,20.00,0.00,'2022-06-15 21:37:11','',''),(1658,'21','222','1',1,'Retail Sale Id 1529',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 21:38:07','',''),(1659,'21','222','1',1,'Retail Sale Id 1529',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 21:38:07','',''),(1660,'21','222','1',1,'Retail Sale Id 1530',7600.00,0.00,0.00,10.00,0.00,'2022-06-15 21:39:22','',''),(1661,'21','222','1',1,'Retail Sale Id 1530',7600.00,0.00,0.00,10.00,0.00,'2022-06-15 21:39:22','',''),(1662,'21','222','1',1,'Retail Sale Id 1531',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 21:41:12','',''),(1663,'21','222','1',1,'Retail Sale Id 1531',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 21:41:12','',''),(1664,'21','222','1',1,'Retail Sale Id 1531',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 21:41:12','',''),(1665,'21','222','1',1,'Retail Sale Id 1531',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 21:41:12','',''),(1666,'21','222','1',1,'Retail Sale Id 1532',15200.00,0.00,0.00,20.00,0.00,'2022-06-15 21:41:59','',''),(1667,'21','222','1',1,'Retail Sale Id 1533',8496.80,0.00,0.00,11.18,0.00,'2022-06-15 21:43:26','',''),(1668,'21','222','1',1,'Retail Sale Id 1533',8496.80,0.00,0.00,11.18,0.00,'2022-06-15 21:43:26','',''),(1669,'21','222','1',1,'Retail Sale Id 1534',11400.00,0.00,0.00,15.00,0.00,'2022-06-15 21:44:36','',''),(1670,'21','222','1',1,'Retail Sale Id 1534',11400.00,0.00,0.00,15.00,0.00,'2022-06-15 21:44:36','',''),(1671,'21','222','1',1,'Retail Sale Id 1535',38000.00,0.00,0.00,50.00,0.00,'2022-06-15 21:45:43','',''),(1672,'21','222','1',1,'Retail Sale Id 1536',9500.00,0.00,0.00,12.50,0.00,'2022-06-15 21:46:32','',''),(1673,'21','222','1',1,'Retail Sale Id 1537',7379.60,0.00,0.00,9.71,0.00,'2022-06-15 21:47:12','',''),(1674,'21','222','1',1,'Retail Sale Id 1538',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 10:20:58','',''),(1675,'21','222','1',1,'Retail Sale Id 1538',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 10:20:58','',''),(1676,'21','222','1',1,'Retail Sale Id 1539',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 10:30:07','',''),(1677,'21','222','1',1,'Retail Sale Id 1540',7600.00,0.00,0.00,10.00,0.00,'2022-06-16 11:47:32','',''),(1678,'21','222','1',1,'Retail Sale Id 1541',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 11:51:19','',''),(1679,'21','222','1',1,'Retail Sale Id 1542',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 11:54:08','',''),(1680,'21','222','1',1,'Retail Sale Id 1543',15200.00,0.00,0.00,20.00,0.00,'2022-06-16 11:55:21','',''),(1681,'21','222','1',1,'Retail Sale Id 1544',38000.00,0.00,0.00,50.00,0.00,'2022-06-16 12:01:14','',''),(1682,'21','222','1',1,'Retail Sale Id 1545',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 12:02:12','',''),(1683,'21','222','1',1,'Retail Sale Id 1545',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 12:02:12','',''),(1684,'21','222','1',1,'Retail Sale Id 1546',15200.00,0.00,0.00,20.00,0.00,'2022-06-16 12:02:50','',''),(1685,'21','222','1',1,'Retail Sale Id 1547',11400.00,0.00,0.00,15.00,0.00,'2022-06-16 12:03:45','',''),(1686,'21','222','1',1,'Retail Sale Id 1547',19000.00,0.00,0.00,25.00,0.00,'2022-06-16 12:03:45','',''),(1687,'21','222','1',1,'Retail Sale Id 1548',1497.20,0.00,0.00,1.97,0.00,'2022-06-16 12:05:12','',''),(1688,'21','222','1',1,'Retail Sale Id 1549',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 12:07:20','',''),(1689,'21','222','1',1,'Retail Sale Id 1550',5000.80,0.00,0.00,6.58,0.00,'2022-06-16 12:09:13','',''),(1690,'21','222','1',1,'Retail Sale Id 1551',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 12:15:17','',''),(1691,'21','222','1',1,'Retail Sale Id 1551',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 12:15:17','',''),(1692,'21','222','1',1,'Retail Sale Id 1552',7600.00,0.00,0.00,10.00,0.00,'2022-06-16 12:17:09','',''),(1693,'21','222','1',1,'Retail Sale Id 1552',8998.40,0.00,0.00,11.84,0.00,'2022-06-16 12:17:09','',''),(1694,'21','222','1',1,'Retail Sale Id 1553',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 12:18:35','',''),(1695,'21','222','1',1,'Retail Sale Id 1553',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 12:18:35','',''),(1696,'21','222','1',1,'Retail Sale Id 1554',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 12:20:52','',''),(1697,'21','222','1',1,'Retail Sale Id 1555',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 12:24:07','',''),(1698,'21','222','1',1,'Retail Sale Id 1556',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 12:43:30','',''),(1699,'21','222','1',1,'Retail Sale Id 1557',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 12:47:52','',''),(1700,'21','222','1',1,'Retail Sale Id 1558',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 12:59:01','',''),(1701,'21','222','1',1,'Retail Sale Id 1559',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 13:00:50','',''),(1702,'21','222','1',1,'Retail Sale Id 1560',1998.80,0.00,0.00,2.63,0.00,'2022-06-16 13:02:29','',''),(1703,'21','222','1',1,'Retail Sale Id 1561',6840.00,0.00,0.00,9.00,0.00,'2022-06-16 13:03:31','',''),(1704,'21','222','1',1,'Retail Sale Id 1562',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 13:05:01','',''),(1705,'21','222','1',1,'Retail Sale Id 1563',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 13:08:13','',''),(1706,'21','222','1',1,'Retail Sale Id 1564',1998.80,0.00,0.00,2.63,0.00,'2022-06-16 13:08:59','',''),(1707,'21','222','1',1,'Retail Sale Id 1565',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 13:12:07','',''),(1708,'21','222','1',1,'Retail Sale Id 1566',3040.00,0.00,0.00,4.00,0.00,'2022-06-16 13:35:34','',''),(1709,'21','222','1',1,'Retail Sale Id 1567',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 13:46:45','',''),(1710,'21','222','1',1,'Retail Sale Id 1568',3040.00,0.00,0.00,4.00,0.00,'2022-06-16 13:50:15','',''),(1711,'21','222','1',1,'Retail Sale Id 1569',19000.00,0.00,0.00,25.00,0.00,'2022-06-16 13:52:05','',''),(1712,'21','222','1',1,'Retail Sale Id 1570',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 13:57:57','',''),(1713,'21','222','1',1,'Retail Sale Id 1571',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:02:19','',''),(1714,'21','222','1',1,'Retail Sale Id 1572',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 14:05:19','',''),(1715,'21','222','1',1,'Retail Sale Id 1573',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:09:31','',''),(1716,'21','222','1',1,'Retail Sale Id 1574',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:10:51','',''),(1717,'21','222','1',1,'Retail Sale Id 1575',3002.00,0.00,0.00,3.95,0.00,'2022-06-16 14:11:47','',''),(1718,'21','222','1',1,'Retail Sale Id 1576',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 14:15:06','',''),(1719,'21','222','1',1,'Retail Sale Id 1577',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 14:25:24','',''),(1720,'21','222','1',1,'Retail Sale Id 1578',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:29:09','',''),(1721,'21','222','1',1,'Retail Sale Id 1579',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 14:37:08','',''),(1722,'21','222','1',1,'Retail Sale Id 1580',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:40:22','',''),(1723,'21','222','1',1,'Retail Sale Id 1581',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:41:23','',''),(1724,'21','222','1',1,'Retail Sale Id 1582',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 14:47:19','',''),(1725,'21','222','1',1,'Retail Sale Id 1583',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:49:08','',''),(1726,'21','222','1',1,'Retail Sale Id 1584',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 14:54:01','',''),(1727,'21','222','1',1,'Retail Sale Id 1585',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:55:38','',''),(1728,'21','222','1',1,'Retail Sale Id 1586',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 14:57:25','',''),(1729,'21','222','1',1,'Retail Sale Id 1587',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 15:01:35','',''),(1730,'21','222','1',1,'Retail Sale Id 1588',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 15:09:57','',''),(1731,'21','222','1',1,'Retail Sale Id 1589',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 15:10:50','',''),(1732,'21','222','1',1,'Retail Sale Id 1590',1520.00,0.00,0.00,2.00,0.00,'2022-06-16 15:14:04','',''),(1733,'21','222','1',1,'Retail Sale Id 1591',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 15:16:37','',''),(1734,'21','222','1',1,'Retail Sale Id 1592',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 15:18:02','',''),(1735,'21','222','1',1,'Retail Sale Id 1593',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 15:22:43','',''),(1736,'21','222','1',1,'Retail Sale Id 1594',4750.00,0.00,0.00,6.25,0.00,'2022-06-16 15:25:11','',''),(1737,'21','222','1',1,'Retail Sale Id 1595',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 15:35:20','',''),(1738,'21','222','1',1,'Retail Sale Id 1596',4499.20,0.00,0.00,5.92,0.00,'2022-06-16 15:39:43','',''),(1739,'21','222','1',1,'Retail Sale Id 1597',7600.00,0.00,0.00,10.00,0.00,'2022-06-16 15:41:30','',''),(1740,'21','222','1',1,'Retail Sale Id 1598',38000.00,0.00,0.00,50.00,0.00,'2022-06-16 15:52:53','',''),(1741,'21','222','1',1,'Retail Sale Id 1599',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 16:22:28','',''),(1742,'21','222','1',1,'Retail Sale Id 1600',1497.20,0.00,0.00,1.97,0.00,'2022-06-16 16:25:11','',''),(1743,'21','222','1',1,'Retail Sale Id 1600',1497.20,0.00,0.00,1.97,0.00,'2022-06-16 16:25:11','',''),(1744,'21','222','1',1,'Retail Sale Id 1601',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 16:27:05','',''),(1745,'21','222','1',1,'Retail Sale Id 1602',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 16:32:18','',''),(1746,'21','222','1',1,'Retail Sale Id 1604',1998.80,0.00,0.00,2.63,0.00,'2022-06-16 16:39:40','',''),(1747,'21','222','1',1,'Retail Sale Id 1605',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 16:43:35','',''),(1748,'21','222','1',1,'Retail Sale Id 1606',5996.40,0.00,0.00,7.89,0.00,'2022-06-16 16:44:58','',''),(1749,'21','222','1',1,'Retail Sale Id 1607',3997.60,0.00,0.00,5.26,0.00,'2022-06-16 16:48:27','',''),(1750,'21','222','1',1,'Retail Sale Id 1608',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 16:51:55','',''),(1751,'21','222','1',1,'Retail Sale Id 1609',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 16:53:31','',''),(1752,'21','222','1',1,'Retail Sale Id 1611',1497.20,0.00,0.00,1.97,0.00,'2022-06-16 16:58:59','',''),(1753,'21','222','1',1,'Retail Sale Id 1612',1200.80,0.00,0.00,1.58,0.00,'2022-06-16 17:11:39','',''),(1754,'21','222','1',1,'Retail Sale Id 1613',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 17:13:24','',''),(1755,'21','222','1',1,'Retail Sale Id 1614',1497.20,0.00,0.00,1.97,0.00,'2022-06-16 17:27:50','',''),(1756,'21','222','1',1,'Retail Sale Id 1615',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 17:39:57','',''),(1757,'21','222','1',1,'Retail Sale Id 1616',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 17:41:06','',''),(1758,'21','222','1',1,'Retail Sale Id 1617',1003.20,0.00,0.00,1.32,0.00,'2022-06-16 17:42:30','',''),(1759,'21','222','1',1,'Retail Sale Id 1618',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 17:43:27','',''),(1760,'21','222','1',1,'Retail Sale Id 1619',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 17:44:32','',''),(1761,'21','222','1',1,'Retail Sale Id 1620',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 17:46:11','',''),(1762,'21','222','1',1,'Retail Sale Id 1621',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 17:47:43','',''),(1763,'21','222','1',1,'Retail Sale Id 1622',1520.00,0.00,0.00,2.00,0.00,'2022-06-16 17:49:32','',''),(1764,'21','222','1',1,'Retail Sale Id 1623',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 17:50:44','',''),(1765,'21','222','1',1,'Retail Sale Id 1624',2500.40,0.00,0.00,3.29,0.00,'2022-06-16 17:53:32','',''),(1766,'21','222','1',1,'Retail Sale Id 1625',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 17:55:31','',''),(1767,'21','222','1',1,'Retail Sale Id 1626',2500.40,0.00,0.00,3.29,0.00,'2022-06-16 17:57:33','',''),(1768,'21','222','1',1,'Retail Sale Id 1626',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 17:57:33','',''),(1769,'21','222','1',1,'Retail Sale Id 1627',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 17:58:14','',''),(1770,'21','222','1',1,'Retail Sale Id 1628',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 18:00:18','',''),(1771,'21','222','1',1,'Retail Sale Id 1628',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:00:18','',''),(1772,'21','222','1',1,'Retail Sale Id 1628',38000.00,0.00,0.00,50.00,0.00,'2022-06-16 18:00:18','',''),(1773,'21','222','1',1,'Retail Sale Id 1629',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 18:02:19','',''),(1774,'21','222','1',1,'Retail Sale Id 1630',3997.60,0.00,0.00,5.26,0.00,'2022-06-16 18:08:01','',''),(1775,'21','222','1',1,'Retail Sale Id 1631',1003.20,0.00,0.00,1.32,0.00,'2022-06-16 18:09:43','',''),(1776,'21','222','1',1,'Retail Sale Id 1632',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:13:42','',''),(1777,'21','222','1',1,'Retail Sale Id 1633',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:16:29','',''),(1778,'21','222','1',1,'Retail Sale Id 1634',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:18:09','',''),(1779,'21','222','1',1,'Retail Sale Id 1635',3800.00,0.00,0.00,5.00,0.00,'2022-06-16 18:20:24','',''),(1780,'21','222','1',1,'Retail Sale Id 1636',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:22:18','',''),(1781,'21','222','1',1,'Retail Sale Id 1637',798.00,0.00,0.00,1.05,0.00,'2022-06-16 18:23:20','',''),(1782,'21','222','1',1,'Retail Sale Id 1638',5000.80,0.00,0.00,6.58,0.00,'2022-06-16 18:24:43','',''),(1783,'21','222','1',1,'Retail Sale Id 1639',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:26:10','',''),(1784,'21','222','1',1,'Retail Sale Id 1640',3997.60,0.00,0.00,5.26,0.00,'2022-06-16 18:29:15','',''),(1785,'21','222','1',1,'Retail Sale Id 1641',1998.80,0.00,0.00,2.63,0.00,'2022-06-16 18:35:52','',''),(1786,'21','222','1',1,'Retail Sale Id 1642',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:36:44','',''),(1787,'21','222','1',1,'Retail Sale Id 1643',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 18:37:34','',''),(1788,'21','222','1',1,'Retail Sale Id 1644',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 18:44:32','',''),(1789,'21','222','1',1,'Retail Sale Id 1645',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 18:47:45','',''),(1790,'21','222','1',1,'Retail Sale Id 1646',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:49:23','',''),(1791,'21','222','1',1,'Retail Sale Id 1647',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 18:50:54','',''),(1792,'21','222','1',1,'Retail Sale Id 1648',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 19:00:44','',''),(1793,'21','222','1',1,'Retail Sale Id 1649',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 19:02:04','',''),(1794,'21','222','1',1,'Retail Sale Id 1650',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 19:03:48','',''),(1795,'21','222','1',1,'Retail Sale Id 1651',4803.20,0.00,0.00,6.32,0.00,'2022-06-16 19:05:20','',''),(1796,'21','222','1',1,'Retail Sale Id 1652',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 19:07:22','',''),(1797,'21','222','1',1,'Retail Sale Id 1653',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 19:09:19','',''),(1798,'21','222','1',1,'Retail Sale Id 1654',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 19:10:45','',''),(1799,'21','222','1',1,'Retail Sale Id 1655',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 19:13:51','',''),(1800,'21','222','1',1,'Retail Sale Id 1656',2500.40,0.00,0.00,3.29,0.00,'2022-06-16 19:18:14','',''),(1801,'21','222','1',1,'Retail Sale Id 1657',8998.40,0.00,0.00,11.84,0.00,'2022-06-16 19:19:14','',''),(1802,'21','222','1',1,'Retail Sale Id 1658',3040.00,0.00,0.00,4.00,0.00,'2022-06-16 19:20:53','',''),(1803,'21','222','1',1,'Retail Sale Id 1659',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 19:21:48','',''),(1804,'21','222','1',1,'Retail Sale Id 1660',5000.80,0.00,0.00,6.58,0.00,'2022-06-16 19:23:28','',''),(1805,'21','222','1',1,'Retail Sale Id 1661',8998.40,0.00,0.00,11.84,0.00,'2022-06-16 19:25:25','',''),(1806,'21','222','1',1,'Retail Sale Id 1662',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 19:26:51','',''),(1807,'21','222','1',1,'Retail Sale Id 1663',1140.00,0.00,0.00,1.50,0.00,'2022-06-16 19:28:56','',''),(1808,'21','222','1',1,'Retail Sale Id 1663',1140.00,0.00,0.00,1.50,0.00,'2022-06-16 19:28:56','',''),(1809,'21','222','1',1,'Retail Sale Id 1664',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 19:31:58','',''),(1810,'21','222','1',1,'Retail Sale Id 1665',4499.20,0.00,0.00,5.92,0.00,'2022-06-16 19:37:44','',''),(1811,'21','222','1',1,'Retail Sale Id 1666',1998.80,0.00,0.00,2.63,0.00,'2022-06-16 19:41:57','',''),(1812,'21','222','1',1,'Retail Sale Id 1667',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 19:43:09','',''),(1813,'21','222','1',1,'Retail Sale Id 1668',501.60,0.00,0.00,0.66,0.00,'2022-06-16 19:43:55','',''),(1814,'21','222','1',1,'Retail Sale Id 1669',1520.00,0.00,0.00,2.00,0.00,'2022-06-16 19:45:18','',''),(1815,'21','222','1',1,'Retail Sale Id 1670',4560.00,0.00,0.00,6.00,0.00,'2022-06-16 19:46:34','',''),(1816,'21','222','1',1,'Retail Sale Id 1671',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 19:47:59','',''),(1817,'21','222','1',1,'Retail Sale Id 1672',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 19:49:13','',''),(1818,'21','222','1',1,'Retail Sale Id 1673',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 20:01:02','',''),(1819,'21','222','1',1,'Retail Sale Id 1674',1520.00,0.00,0.00,2.00,0.00,'2022-06-16 20:02:57','',''),(1820,'21','222','1',1,'Retail Sale Id 1675',1003.20,0.00,0.00,1.32,0.00,'2022-06-16 20:05:12','',''),(1821,'21','222','1',1,'Retail Sale Id 1676',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 20:08:51','',''),(1822,'21','222','1',1,'Retail Sale Id 1677',2280.00,0.00,0.00,3.00,0.00,'2022-06-16 20:09:58','',''),(1823,'21','222','1',1,'Retail Sale Id 1678',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 20:11:21','',''),(1824,'21','222','1',1,'Retail Sale Id 1679',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 20:14:22','',''),(1825,'21','222','1',1,'Retail Sale Id 1680',38000.00,0.00,0.00,50.00,0.00,'2022-06-16 20:53:43','',''),(1826,'21','222','1',1,'Retail Sale Id 1681',38000.00,0.00,0.00,50.00,0.00,'2022-06-16 20:54:20','',''),(1827,'21','222','1',1,'Retail Sale Id 1682',15200.00,0.00,0.00,20.00,0.00,'2022-06-16 20:55:14','',''),(1828,'21','222','1',1,'Retail Sale Id 1683',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 20:56:30','',''),(1829,'21','222','1',1,'Retail Sale Id 1683',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 20:56:30','',''),(1830,'21','222','1',1,'Retail Sale Id 1684',7600.00,0.00,0.00,10.00,0.00,'2022-06-16 20:57:26','',''),(1831,'21','222','1',1,'Retail Sale Id 1684',7600.00,0.00,0.00,10.00,0.00,'2022-06-16 20:57:26','',''),(1832,'21','222','1',1,'Retail Sale Id 1685',38000.00,0.00,0.00,50.00,0.00,'2022-06-16 20:59:14','',''),(1833,'21','222','1',1,'Retail Sale Id 1686',8998.40,0.00,0.00,11.84,0.00,'2022-06-16 20:59:54','',''),(1834,'21','222','1',1,'Retail Sale Id 1687',8496.80,0.00,0.00,11.18,0.00,'2022-06-16 21:01:35','',''),(1835,'21','222','1',1,'Retail Sale Id 1687',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 21:01:35','',''),(1836,'21','222','1',1,'Retail Sale Id 1687',9500.00,0.00,0.00,12.50,0.00,'2022-06-16 21:01:35','',''),(1837,'21','222','1',1,'Retail Sale Id 1688',15200.00,0.00,0.00,20.00,0.00,'2022-06-16 21:03:43','',''),(1838,'21','222','1',1,'Retail Sale Id 1689',1976.00,0.00,0.00,2.60,0.00,'2022-06-16 21:06:20','',''),(1839,'21','222','1',1,'Retail Sale Id 1689',19000.00,0.00,0.00,25.00,0.00,'2022-06-16 21:06:20','',''),(1840,'21','222','1',1,'Retail Sale Id 1690',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 08:36:10','',''),(1841,'21','222','1',1,'Retail Sale Id 1691',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 08:41:55','',''),(1842,'21','222','1',1,'Retail Sale Id 1692',3002.00,0.00,0.00,3.95,0.00,'2022-06-17 08:43:55','',''),(1843,'21','222','1',1,'Retail Sale Id 1693',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 08:47:49','',''),(1844,'21','222','1',1,'Retail Sale Id 1694',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 08:51:35','',''),(1845,'21','222','1',1,'Retail Sale Id 1695',1998.80,0.00,0.00,2.63,0.00,'2022-06-17 08:52:52','',''),(1846,'21','222','1',1,'Retail Sale Id 1696',7600.00,0.00,0.00,10.00,0.00,'2022-06-17 08:54:55','',''),(1847,'21','222','1',1,'Retail Sale Id 1697',2280.00,0.00,0.00,3.00,0.00,'2022-06-17 09:17:21','',''),(1848,'21','222','1',1,'Retail Sale Id 1698',4560.00,0.00,0.00,6.00,0.00,'2022-06-17 09:19:07','',''),(1849,'21','222','1',1,'Retail Sale Id 1699',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 09:21:12','',''),(1850,'21','222','1',1,'Retail Sale Id 1700',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 09:23:27','',''),(1851,'21','222','1',1,'Retail Sale Id 1701',38000.00,0.00,0.00,50.00,0.00,'2022-06-17 11:05:34','',''),(1852,'21','222','1',1,'Retail Sale Id 1701',38000.00,0.00,0.00,50.00,0.00,'2022-06-17 11:05:34','',''),(1853,'21','222','1',1,'Retail Sale Id 1702',7600.00,0.00,0.00,10.00,0.00,'2022-06-17 11:06:56','',''),(1854,'21','222','1',1,'Retail Sale Id 1702',15200.00,0.00,0.00,20.00,0.00,'2022-06-17 11:06:56','',''),(1855,'21','222','1',1,'Retail Sale Id 1703',8998.40,0.00,0.00,11.84,0.00,'2022-06-17 11:08:51','',''),(1856,'21','222','1',1,'Retail Sale Id 1703',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 11:08:51','',''),(1857,'21','222','1',1,'Retail Sale Id 1704',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 11:10:47','',''),(1858,'21','222','1',1,'Retail Sale Id 1704',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 11:10:47','',''),(1859,'21','222','1',1,'Retail Sale Id 1705',19000.00,0.00,0.00,25.00,0.00,'2022-06-17 11:11:43','',''),(1860,'21','222','1',1,'Retail Sale Id 1706',38000.00,0.00,0.00,50.00,0.00,'2022-06-17 11:12:47','',''),(1861,'21','222','1',1,'Retail Sale Id 1707',38000.00,0.00,0.00,50.00,0.00,'2022-06-17 11:13:38','',''),(1862,'21','222','1',1,'Retail Sale Id 1708',11400.00,0.00,0.00,15.00,0.00,'2022-06-17 11:15:04','',''),(1863,'21','222','1',1,'Retail Sale Id 1708',38000.00,0.00,0.00,50.00,0.00,'2022-06-17 11:15:04','',''),(1864,'21','222','1',1,'Retail Sale Id 1709',9500.00,0.00,0.00,12.50,0.00,'2022-06-17 11:16:26','',''),(1865,'21','222','1',1,'Retail Sale Id 1710',7721.60,0.00,0.00,10.16,0.00,'2022-06-17 11:17:47','',''),(1866,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3853200.00,5070.00,0.00,0.00,'2022-06-18 18:39:43','',''),(1867,'21','222',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,5000.00,0.00,'2022-06-18 18:43:12','',''),(1868,'21','222','1',1,'Received from bridging 15',0.00,0.00,5000.00,0.00,0.00,'2022-06-18 18:43:12','',''),(1869,'21','222','1',1,'Retail Sale Id 1711',1003.20,0.00,0.00,1.32,0.00,'2022-06-18 18:48:45','',''),(1870,'21','222','1',1,'Retail Sale Id 1711',1497.20,0.00,0.00,1.97,0.00,'2022-06-18 18:48:45','',''),(1871,'21','222','1',1,'Retail Sale Id 1712',5000.80,0.00,0.00,6.58,0.00,'2022-06-18 18:50:09','',''),(1872,'21','222','1',1,'Retail Sale Id 1713',2280.00,0.00,0.00,3.00,0.00,'2022-06-18 18:51:20','',''),(1873,'21','222','1',1,'Retail Sale Id 1714',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 18:52:23','',''),(1874,'21','222','1',1,'Retail Sale Id 1715',1003.20,0.00,0.00,1.32,0.00,'2022-06-18 18:55:19','',''),(1875,'21','222','1',1,'Retail Sale Id 1716',1003.20,0.00,0.00,1.32,0.00,'2022-06-18 19:01:48','',''),(1876,'21','222','1',1,'Retail Sale Id 1717',4750.00,0.00,0.00,6.25,0.00,'2022-06-18 19:17:46','',''),(1877,'21','222','1',1,'Retail Sale Id 1718',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 19:54:29','',''),(1878,'21','222','1',1,'Retail Sale Id 1719',1003.20,0.00,0.00,1.32,0.00,'2022-06-18 19:58:19','',''),(1879,'21','222','1',1,'Retail Sale Id 1719',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 19:58:19','',''),(1880,'21','222','1',1,'Retail Sale Id 1720',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 20:01:16','',''),(1881,'21','222','1',1,'Retail Sale Id 1721',38000.00,0.00,0.00,50.00,0.00,'2022-06-18 21:10:55','',''),(1882,'21','222','1',1,'Retail Sale Id 1721',38000.00,0.00,0.00,50.00,0.00,'2022-06-18 21:10:55','',''),(1883,'21','222','1',1,'Retail Sale Id 1722',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:12:20','',''),(1884,'21','222','1',1,'Retail Sale Id 1722',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:12:20','',''),(1885,'21','222','1',1,'Retail Sale Id 1723',15200.00,0.00,0.00,20.00,0.00,'2022-06-18 21:13:47','',''),(1886,'21','222','1',1,'Retail Sale Id 1724',3997.60,0.00,0.00,5.26,0.00,'2022-06-18 21:15:25','',''),(1887,'21','222','1',1,'Retail Sale Id 1724',8998.40,0.00,0.00,11.84,0.00,'2022-06-18 21:15:25','',''),(1888,'21','222','1',1,'Retail Sale Id 1725',7600.00,0.00,0.00,10.00,0.00,'2022-06-18 21:18:00','',''),(1889,'21','222','1',1,'Retail Sale Id 1725',8496.80,0.00,0.00,11.18,0.00,'2022-06-18 21:18:00','',''),(1890,'21','222','1',1,'Retail Sale Id 1725',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:18:00','',''),(1891,'21','222','1',1,'Retail Sale Id 1726',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:20:23','',''),(1892,'21','222','1',1,'Retail Sale Id 1726',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:20:23','',''),(1893,'21','222','1',1,'Retail Sale Id 1726',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:20:23','',''),(1894,'21','222','1',1,'Retail Sale Id 1727',11400.00,0.00,0.00,15.00,0.00,'2022-06-18 21:22:55','',''),(1895,'21','222','1',1,'Retail Sale Id 1727',11400.00,0.00,0.00,15.00,0.00,'2022-06-18 21:22:55','',''),(1896,'21','222','1',1,'Retail Sale Id 1728',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:24:15','',''),(1897,'21','222','1',1,'Retail Sale Id 1728',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:24:15','',''),(1898,'21','222','1',1,'Retail Sale Id 1729',7501.20,0.00,0.00,9.87,0.00,'2022-06-18 21:26:15','',''),(1899,'21','222','1',1,'Retail Sale Id 1729',8496.80,0.00,0.00,11.18,0.00,'2022-06-18 21:26:15','',''),(1900,'21','222','1',1,'Retail Sale Id 1729',38000.00,0.00,0.00,50.00,0.00,'2022-06-18 21:26:15','',''),(1901,'21','222','1',1,'Retail Sale Id 1730',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:27:53','',''),(1902,'21','222','1',1,'Retail Sale Id 1730',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:27:53','',''),(1903,'21','222','1',1,'Retail Sale Id 1730',38000.00,0.00,0.00,50.00,0.00,'2022-06-18 21:27:53','',''),(1904,'21','222','1',1,'Retail Sale Id 1732',5000.80,0.00,0.00,6.58,0.00,'2022-06-18 21:30:03','',''),(1905,'21','222','1',1,'Retail Sale Id 1733',3997.60,0.00,0.00,5.26,0.00,'2022-06-18 21:30:53','',''),(1906,'21','222','1',1,'Retail Sale Id 1734',15200.00,0.00,0.00,20.00,0.00,'2022-06-18 21:31:57','',''),(1907,'21','222','1',1,'Retail Sale Id 1734',38000.00,0.00,0.00,50.00,0.00,'2022-06-18 21:31:57','',''),(1908,'21','222','1',1,'Retail Sale Id 1735',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:32:53','',''),(1909,'21','222','1',1,'Retail Sale Id 1736',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:33:44','',''),(1910,'21','222','1',1,'Retail Sale Id 1737',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:34:55','',''),(1911,'21','222','1',1,'Retail Sale Id 1738',9500.00,0.00,0.00,12.50,0.00,'2022-06-18 21:35:54','',''),(1912,'21','222','1',1,'Retail Sale Id 1739',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 21:36:59','',''),(1913,'21','222','1',1,'Retail Sale Id 1739',4560.00,0.00,0.00,6.00,0.00,'2022-06-18 21:36:59','',''),(1914,'21','222','1',1,'Retail Sale Id 1740',6292.80,0.00,0.00,8.28,0.00,'2022-06-18 21:38:13','',''),(1915,'21','222','1',1,'Retail Sale Id 1740',7600.00,0.00,0.00,10.00,0.00,'2022-06-18 21:38:13','',''),(1916,'21','222','1',1,'Retail Sale Id 1741',38000.00,0.00,0.00,50.00,0.00,'2022-06-18 21:39:05','',''),(1917,'21','222','1',1,'Retail Sale Id 1742',10997.20,0.00,0.00,14.47,0.00,'2022-06-18 21:42:09','',''),(1918,'21','222','1',1,'Retail Sale Id 1743',5000.80,0.00,0.00,6.58,0.00,'2022-06-19 07:55:35','',''),(1919,'21','222','1',1,'Retail Sale Id 1744',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 07:58:59','',''),(1920,'21','222','1',1,'Retail Sale Id 1745',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:01:10','',''),(1921,'21','222','1',1,'Retail Sale Id 1746',2796.80,0.00,0.00,3.68,0.00,'2022-06-19 08:03:34','',''),(1922,'21','222','1',1,'Retail Sale Id 1747',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 08:04:30','',''),(1923,'21','222','1',1,'Retail Sale Id 1748',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 08:07:13','',''),(1924,'21','222','1',1,'Retail Sale Id 1749',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 08:14:25','',''),(1925,'21','222','1',1,'Retail Sale Id 1750',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 08:29:15','',''),(1926,'21','222','1',1,'Retail Sale Id 1751',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:30:38','',''),(1927,'21','222','1',1,'Retail Sale Id 1752',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 08:37:41','',''),(1928,'21','222','1',1,'Retail Sale Id 1753',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 08:39:01','',''),(1929,'21','222','1',1,'Retail Sale Id 1754',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 08:39:40','',''),(1930,'21','222','1',1,'Retail Sale Id 1755',3040.00,0.00,0.00,4.00,0.00,'2022-06-19 08:41:39','',''),(1931,'21','222','1',1,'Retail Sale Id 1755',8360.00,0.00,0.00,11.00,0.00,'2022-06-19 08:41:39','',''),(1932,'21','222','1',1,'Retail Sale Id 1756',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 08:45:50','',''),(1933,'21','222','1',1,'Retail Sale Id 1756',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:45:50','',''),(1934,'21','222','1',1,'Retail Sale Id 1757',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:48:03','',''),(1935,'21','222','1',1,'Retail Sale Id 1758',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:49:52','',''),(1936,'21','222','1',1,'Retail Sale Id 1758',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:49:52','',''),(1937,'21','222','1',1,'Retail Sale Id 1758',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:49:52','',''),(1938,'21','222','1',1,'Retail Sale Id 1758',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:49:52','',''),(1939,'21','222','1',1,'Retail Sale Id 1759',3040.00,0.00,0.00,4.00,0.00,'2022-06-19 08:50:47','',''),(1940,'21','222','1',1,'Retail Sale Id 1760',760.00,0.00,0.00,1.00,0.00,'2022-06-19 08:52:40','',''),(1941,'21','222','1',1,'Retail Sale Id 1761',1003.20,0.00,0.00,1.32,0.00,'2022-06-19 08:54:47','',''),(1942,'21','222','1',1,'Retail Sale Id 1762',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 08:56:05','',''),(1943,'21','222','1',1,'Retail Sale Id 1763',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 08:57:09','',''),(1944,'21','222','1',1,'Retail Sale Id 1764',8002.80,0.00,0.00,10.53,0.00,'2022-06-19 08:58:33','',''),(1945,'21','222','1',1,'Retail Sale Id 1765',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 08:59:33','',''),(1946,'21','222','1',1,'Retail Sale Id 1766',8360.00,0.00,0.00,11.00,0.00,'2022-06-19 09:01:08','',''),(1947,'21','222','1',1,'Retail Sale Id 1767',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 09:02:16','',''),(1948,'21','222','1',1,'Retail Sale Id 1768',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 09:03:49','',''),(1949,'21','222','1',1,'Retail Sale Id 1769',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 09:06:40','',''),(1950,'21','222','1',1,'Retail Sale Id 1769',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 09:06:40','',''),(1951,'21','222','1',1,'Retail Sale Id 1770',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 09:07:33','',''),(1952,'21','222','1',1,'Retail Sale Id 1771',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 09:09:28','',''),(1953,'21','222','1',1,'Retail Sale Id 1772',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 09:10:36','',''),(1954,'21','222','1',1,'Retail Sale Id 1773',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 09:11:26','',''),(1955,'21','222','1',1,'Retail Sale Id 1774',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 09:13:12','',''),(1956,'21','222','1',1,'Retail Sale Id 1775',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 09:15:54','',''),(1957,'21','222','1',1,'Retail Sale Id 1776',3503.60,0.00,0.00,4.61,0.00,'2022-06-19 09:18:08','',''),(1958,'21','222','1',1,'Retail Sale Id 1777',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 09:20:27','',''),(1959,'21','222','1',1,'Retail Sale Id 1778',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 09:21:44','',''),(1960,'21','222','1',1,'Retail Sale Id 1779',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 09:23:31','',''),(1961,'21','222','1',1,'Retail Sale Id 1780',4750.00,0.00,0.00,6.25,0.00,'2022-06-19 09:24:48','',''),(1962,'21','222','1',1,'Retail Sale Id 1781',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 09:28:04','',''),(1963,'21','222','1',1,'Retail Sale Id 1782',3040.00,0.00,0.00,4.00,0.00,'2022-06-19 09:30:24','',''),(1964,'21','222','1',1,'Retail Sale Id 1783',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 09:37:28','',''),(1965,'21','222','1',1,'Retail Sale Id 1784',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 09:39:13','',''),(1966,'21','222','1',1,'Retail Sale Id 1785',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 09:39:56','',''),(1967,'21','222','1',1,'Retail Sale Id 1786',8002.80,0.00,0.00,10.53,0.00,'2022-06-19 09:43:51','',''),(1968,'21','222','1',1,'Retail Sale Id 1787',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 09:46:51','',''),(1969,'21','222','1',1,'Retail Sale Id 1788',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 09:47:59','',''),(1970,'21','222','1',1,'Retail Sale Id 1789',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 09:48:58','',''),(1971,'21','222','1',1,'Retail Sale Id 1790',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 10:57:29','',''),(1972,'21','222','1',1,'Retail Sale Id 1791',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 11:00:00','',''),(1973,'21','222','1',1,'Retail Sale Id 1792',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 11:02:06','',''),(1974,'21','222','1',1,'Retail Sale Id 1793',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:03:30','',''),(1975,'21','222','1',1,'Retail Sale Id 1794',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 11:04:34','',''),(1976,'21','222','1',1,'Retail Sale Id 1795',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 11:06:04','',''),(1977,'21','222','1',1,'Retail Sale Id 1796',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 11:07:48','',''),(1978,'21','222','1',1,'Retail Sale Id 1796',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 11:07:48','',''),(1979,'21','222','1',1,'Retail Sale Id 1797',3701.20,0.00,0.00,4.87,0.00,'2022-06-19 11:09:06','',''),(1980,'21','222','1',1,'Retail Sale Id 1798',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 11:10:20','',''),(1981,'21','222','1',1,'Retail Sale Id 1799',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:14:49','',''),(1982,'21','222','1',1,'Retail Sale Id 1800',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 11:15:38','',''),(1983,'21','222','1',1,'Retail Sale Id 1801',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:16:41','',''),(1984,'21','222','1',1,'Retail Sale Id 1802',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:19:25','',''),(1985,'21','222','1',1,'Retail Sale Id 1803',20003.20,0.00,0.00,26.32,0.00,'2022-06-19 11:20:52','',''),(1986,'21','222','1',1,'Retail Sale Id 1804',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 11:23:38','',''),(1987,'21','222','1',1,'Retail Sale Id 1805',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 11:24:40','',''),(1988,'21','222','1',1,'Retail Sale Id 1806',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:25:31','',''),(1989,'21','222','1',1,'Retail Sale Id 1807',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:27:12','',''),(1990,'21','222','1',1,'Retail Sale Id 1808',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:28:07','',''),(1991,'21','222','1',1,'Retail Sale Id 1809',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 11:31:04','',''),(1992,'21','222','1',1,'Retail Sale Id 1810',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:32:48','',''),(1993,'21','222','1',1,'Retail Sale Id 1811',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 11:35:02','',''),(1994,'21','222','1',1,'Retail Sale Id 1812',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 11:41:56','',''),(1995,'21','222','1',1,'Retail Sale Id 1813',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:43:22','',''),(1996,'21','222','1',1,'Retail Sale Id 1814',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:44:37','',''),(1997,'21','222','1',1,'Retail Sale Id 1815',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:46:16','',''),(1998,'21','222','1',1,'Retail Sale Id 1816',1147.60,0.00,0.00,1.51,0.00,'2022-06-19 11:48:37','',''),(1999,'21','222','1',1,'Retail Sale Id 1816',1147.60,0.00,0.00,1.51,0.00,'2022-06-19 11:48:37','',''),(2000,'21','222','1',1,'Retail Sale Id 1816',1155.20,0.00,0.00,1.52,0.00,'2022-06-19 11:48:37','',''),(2001,'21','222','1',1,'Retail Sale Id 1817',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 11:50:31','',''),(2002,'21','222','1',1,'Retail Sale Id 1818',501.60,0.00,0.00,0.66,0.00,'2022-06-19 11:51:19','',''),(2003,'21','222','1',1,'Retail Sale Id 1818',501.60,0.00,0.00,0.66,0.00,'2022-06-19 11:51:19','',''),(2004,'21','222','1',1,'Retail Sale Id 1819',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:52:39','',''),(2005,'21','222','1',1,'Retail Sale Id 1820',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:54:47','',''),(2006,'21','222','1',1,'Retail Sale Id 1821',4750.00,0.00,0.00,6.25,0.00,'2022-06-19 11:56:50','',''),(2007,'21','222','1',1,'Retail Sale Id 1822',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 11:58:00','',''),(2008,'21','222','1',1,'Retail Sale Id 1823',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 11:59:10','',''),(2009,'21','222','1',1,'Retail Sale Id 1824',8998.40,0.00,0.00,11.84,0.00,'2022-06-19 12:00:17','',''),(2010,'21','222','1',1,'Retail Sale Id 1826',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 12:02:00','',''),(2011,'21','222','1',1,'Retail Sale Id 1827',5000.80,0.00,0.00,6.58,0.00,'2022-06-19 12:03:01','',''),(2012,'21','222','1',1,'Retail Sale Id 1828',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 12:04:04','',''),(2013,'21','222','1',1,'Retail Sale Id 1829',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 12:05:04','',''),(2014,'21','222','1',1,'Retail Sale Id 1830',6999.60,0.00,0.00,9.21,0.00,'2022-06-19 12:06:37','',''),(2015,'21','222','1',1,'Retail Sale Id 1831',1003.20,0.00,0.00,1.32,0.00,'2022-06-19 12:07:32','',''),(2016,'21','222','1',1,'Retail Sale Id 1832',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 12:09:05','',''),(2017,'21','222','1',1,'Retail Sale Id 1833',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 12:10:31','',''),(2018,'21','222','1',1,'Retail Sale Id 1834',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 12:11:13','',''),(2019,'21','222','1',1,'Retail Sale Id 1835',8002.80,0.00,0.00,10.53,0.00,'2022-06-19 12:12:59','',''),(2020,'21','222','1',1,'Retail Sale Id 1836',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 12:15:53','',''),(2021,'21','222','1',1,'Retail Sale Id 1837',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 12:17:40','',''),(2022,'21','222','1',1,'Retail Sale Id 1838',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 12:23:20','',''),(2023,'21','222','1',1,'Retail Sale Id 1839',5000.80,0.00,0.00,6.58,0.00,'2022-06-19 12:24:35','',''),(2024,'21','222','1',1,'Retail Sale Id 1840',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 12:27:14','',''),(2025,'21','222','1',1,'Retail Sale Id 1841',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 12:28:36','',''),(2026,'21','222','1',1,'Retail Sale Id 1842',8998.40,0.00,0.00,11.84,0.00,'2022-06-19 12:30:20','',''),(2027,'21','222','1',1,'Retail Sale Id 1843',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 12:31:20','',''),(2028,'21','222','1',1,'Retail Sale Id 1844',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 12:34:25','',''),(2029,'21','222','1',1,'Retail Sale Id 1845',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 12:36:16','',''),(2030,'21','222','1',1,'Retail Sale Id 1846',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 12:38:56','',''),(2031,'21','222','1',1,'Retail Sale Id 1847',1900.00,0.00,0.00,2.50,0.00,'2022-06-19 12:40:42','',''),(2032,'21','222','1',1,'Retail Sale Id 1848',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 12:41:54','',''),(2033,'21','222','1',1,'Retail Sale Id 1849',5000.80,0.00,0.00,6.58,0.00,'2022-06-19 12:42:50','',''),(2034,'21','222','1',1,'Retail Sale Id 1850',19000.00,0.00,0.00,25.00,0.00,'2022-06-19 12:47:00','',''),(2035,'21','222','1',1,'Retail Sale Id 1851',5000.80,0.00,0.00,6.58,0.00,'2022-06-19 12:47:39','',''),(2036,'21','222','1',1,'Retail Sale Id 1852',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 12:49:34','',''),(2037,'21','222','1',1,'Retail Sale Id 1853',3040.00,0.00,0.00,4.00,0.00,'2022-06-19 12:51:30','',''),(2038,'21','222','1',1,'Retail Sale Id 1854',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 12:52:43','',''),(2039,'21','222','1',1,'Retail Sale Id 1855',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 12:54:17','',''),(2040,'21','222','1',1,'Retail Sale Id 1856',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 12:55:47','',''),(2041,'21','222','1',1,'Retail Sale Id 1857',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 12:57:15','',''),(2042,'21','222','1',1,'Retail Sale Id 1858',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 12:58:26','',''),(2043,'21','222','1',1,'Retail Sale Id 1859',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 12:59:50','',''),(2044,'21','222','1',1,'Retail Sale Id 1860',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:01:11','',''),(2045,'21','222','1',1,'Retail Sale Id 1861',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:02:43','',''),(2046,'21','222','1',1,'Retail Sale Id 1862',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:04:38','',''),(2047,'21','222','1',1,'Retail Sale Id 1863',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:05:29','',''),(2048,'21','222','1',1,'Retail Sale Id 1864',2500.40,0.00,0.00,3.29,0.00,'2022-06-19 13:07:19','',''),(2049,'21','222','1',1,'Retail Sale Id 1865',3420.00,0.00,0.00,4.50,0.00,'2022-06-19 13:08:36','',''),(2050,'21','222','1',1,'Retail Sale Id 1866',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:10:48','',''),(2051,'21','222','1',1,'Retail Sale Id 1867',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:11:50','',''),(2052,'21','222','1',1,'Retail Sale Id 1868',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:12:53','',''),(2053,'21','222','1',1,'Retail Sale Id 1869',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:13:40','',''),(2054,'21','222','1',1,'Retail Sale Id 1870',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 13:15:01','',''),(2055,'21','222','1',1,'Retail Sale Id 1871',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:16:49','',''),(2056,'21','222','1',1,'Retail Sale Id 1872',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:18:31','',''),(2057,'21','222','1',1,'Retail Sale Id 1873',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 13:19:29','',''),(2058,'21','222','1',1,'Retail Sale Id 1874',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 13:21:09','',''),(2059,'21','222','1',1,'Retail Sale Id 1875',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:22:32','',''),(2060,'21','222','1',1,'Retail Sale Id 1876',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:24:01','',''),(2061,'21','222','1',1,'Retail Sale Id 1877',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:26:46','',''),(2062,'21','222','1',1,'Retail Sale Id 1878',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:30:26','',''),(2063,'21','222','1',1,'Retail Sale Id 1879',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:33:55','',''),(2064,'21','222','1',1,'Retail Sale Id 1880',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 13:34:37','',''),(2065,'21','222','1',1,'Retail Sale Id 1881',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 13:35:27','',''),(2066,'21','222','1',1,'Retail Sale Id 1882',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 13:36:05','',''),(2067,'21','222','1',1,'Retail Sale Id 1883',4750.00,0.00,0.00,6.25,0.00,'2022-06-19 13:37:26','',''),(2068,'21','222','1',1,'Retail Sale Id 1884',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:38:06','',''),(2069,'21','222','1',1,'Retail Sale Id 1885',1003.20,0.00,0.00,1.32,0.00,'2022-06-19 13:38:53','',''),(2070,'21','222','1',1,'Retail Sale Id 1886',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:40:43','',''),(2071,'21','222','1',1,'Retail Sale Id 1886',15200.00,0.00,0.00,20.00,0.00,'2022-06-19 13:40:43','',''),(2072,'21','222','1',1,'Retail Sale Id 1887',4750.00,0.00,0.00,6.25,0.00,'2022-06-19 13:42:12','',''),(2073,'21','222','1',1,'Retail Sale Id 1888',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:44:42','',''),(2074,'21','222','1',1,'Retail Sale Id 1889',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:46:10','',''),(2075,'21','222','1',1,'Retail Sale Id 1890',8998.40,0.00,0.00,11.84,0.00,'2022-06-19 13:48:29','',''),(2076,'21','222','1',1,'Retail Sale Id 1891',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 13:50:48','',''),(2077,'21','222','1',1,'Retail Sale Id 1891',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:50:48','',''),(2078,'21','222','1',1,'Retail Sale Id 1892',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 13:53:30','',''),(2079,'21','222','1',1,'Retail Sale Id 1893',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 13:55:04','',''),(2080,'21','222','1',1,'Retail Sale Id 1894',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 13:57:38','',''),(2081,'21','222','1',1,'Retail Sale Id 1895',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 13:59:40','',''),(2082,'21','222','1',1,'Retail Sale Id 1896',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 14:07:36','',''),(2083,'21','222','1',1,'Retail Sale Id 1896',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 14:07:36','',''),(2084,'21','222','1',1,'Retail Sale Id 1897',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 14:08:31','',''),(2085,'21','222','1',1,'Retail Sale Id 1898',4940.00,0.00,0.00,6.50,0.00,'2022-06-19 14:09:41','',''),(2086,'21','222','1',1,'Retail Sale Id 1899',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 14:13:13','',''),(2087,'21','222','1',1,'Retail Sale Id 1900',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 14:15:17','',''),(2088,'21','222','1',1,'Retail Sale Id 1901',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 14:16:37','',''),(2089,'21','222','1',1,'Retail Sale Id 1902',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 14:19:49','',''),(2090,'21','222','1',1,'Retail Sale Id 1902',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 14:19:49','',''),(2091,'21','222','1',1,'Retail Sale Id 1903',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 14:21:34','',''),(2092,'21','222','1',1,'Retail Sale Id 1904',4499.20,0.00,0.00,5.92,0.00,'2022-06-19 14:25:26','',''),(2093,'21','222','1',1,'Retail Sale Id 1905',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 14:30:38','',''),(2094,'21','222','1',1,'Retail Sale Id 1906',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 14:32:11','',''),(2095,'21','222','1',1,'Retail Sale Id 1907',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 14:36:01','',''),(2096,'21','222','1',1,'Retail Sale Id 1908',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 14:38:50','',''),(2097,'21','222','1',1,'Retail Sale Id 1909',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 14:42:33','',''),(2098,'21','222','1',1,'Retail Sale Id 1910',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 14:45:40','',''),(2099,'21','222','1',1,'Retail Sale Id 1910',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 14:45:40','',''),(2100,'21','222','1',1,'Retail Sale Id 1911',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 14:47:51','',''),(2101,'21','222','1',1,'Retail Sale Id 1912',1102.00,0.00,0.00,1.45,0.00,'2022-06-19 14:49:32','',''),(2102,'21','222','1',1,'Retail Sale Id 1913',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 14:52:56','',''),(2103,'21','222','1',1,'Retail Sale Id 1914',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 14:53:37','',''),(2104,'21','222','1',1,'Retail Sale Id 1915',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 14:55:05','',''),(2105,'21','222','1',1,'Retail Sale Id 1916',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 14:56:38','',''),(2106,'21','222','1',1,'Retail Sale Id 1917',5996.40,0.00,0.00,7.89,0.00,'2022-06-19 14:58:06','',''),(2107,'21','222','1',1,'Retail Sale Id 1918',699.20,0.00,0.00,0.92,0.00,'2022-06-19 15:03:12','',''),(2108,'21','222','1',1,'Retail Sale Id 1919',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 15:05:43','',''),(2109,'21','222','1',1,'Retail Sale Id 1920',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:07:42','',''),(2110,'21','222','1',1,'Retail Sale Id 1921',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:10:59','',''),(2111,'21','222','1',1,'Retail Sale Id 1922',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:13:15','',''),(2112,'21','222','1',1,'Retail Sale Id 1923',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:14:40','',''),(2113,'21','222','1',1,'Retail Sale Id 1924',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:16:03','',''),(2114,'21','222','1',1,'Retail Sale Id 1925',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 15:20:55','',''),(2115,'21','222','1',1,'Retail Sale Id 1926',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:22:58','',''),(2116,'21','222','1',1,'Retail Sale Id 1927',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 15:25:48','',''),(2117,'21','222','1',1,'Retail Sale Id 1929',1900.00,0.00,0.00,2.50,0.00,'2022-06-19 15:28:24','',''),(2118,'21','222','1',1,'Retail Sale Id 1930',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:30:57','',''),(2119,'21','222','1',1,'Retail Sale Id 1931',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 15:31:39','',''),(2120,'21','222','1',1,'Retail Sale Id 1932',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:34:18','',''),(2121,'21','222','1',1,'Retail Sale Id 1933',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 15:36:01','',''),(2122,'21','222','1',1,'Retail Sale Id 1934',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:41:09','',''),(2123,'21','222','1',1,'Retail Sale Id 1935',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 15:42:36','',''),(2124,'21','222','1',1,'Retail Sale Id 1936',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:49:56','',''),(2125,'21','222','1',1,'Retail Sale Id 1937',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 15:52:46','',''),(2126,'21','222','1',1,'Retail Sale Id 1938',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 15:53:51','',''),(2127,'21','222','1',1,'Retail Sale Id 1939',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 15:58:38','',''),(2128,'21','222','1',1,'Retail Sale Id 1940',9302.40,0.00,0.00,12.24,0.00,'2022-06-19 16:24:23','',''),(2129,'21','222','1',1,'Retail Sale Id 1941',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 16:25:37','',''),(2130,'21','222','1',1,'Retail Sale Id 1942',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 16:26:53','',''),(2131,'21','222','1',1,'Retail Sale Id 1942',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 16:26:53','',''),(2132,'21','222','1',1,'Retail Sale Id 1943',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 16:27:31','',''),(2133,'21','222','1',1,'Retail Sale Id 1944',4499.20,0.00,0.00,5.92,0.00,'2022-06-19 16:28:11','',''),(2134,'21','222','1',1,'Retail Sale Id 1945',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 16:29:15','',''),(2135,'21','222','1',1,'Retail Sale Id 1946',5996.40,0.00,0.00,7.89,0.00,'2022-06-19 16:31:16','',''),(2136,'21','222','1',1,'Retail Sale Id 1947',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 16:35:40','',''),(2137,'21','222','1',1,'Retail Sale Id 1948',4750.00,0.00,0.00,6.25,0.00,'2022-06-19 16:41:26','',''),(2138,'21','222','1',1,'Retail Sale Id 1949',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 16:43:21','',''),(2139,'21','222','1',1,'Retail Sale Id 1950',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 16:44:20','',''),(2140,'21','222','1',1,'Retail Sale Id 1951',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 16:45:26','',''),(2141,'21','222','1',1,'Retail Sale Id 1952',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 16:46:30','',''),(2142,'21','222','1',1,'Retail Sale Id 1953',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 16:48:45','',''),(2143,'21','222','1',1,'Retail Sale Id 1954',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 16:50:37','',''),(2144,'21','222','1',1,'Retail Sale Id 1955',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 16:54:07','',''),(2145,'21','222','1',1,'Retail Sale Id 1956',4750.00,0.00,0.00,6.25,0.00,'2022-06-19 17:02:16','',''),(2146,'21','222','1',1,'Retail Sale Id 1957',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 17:05:43','',''),(2147,'21','222','1',1,'Retail Sale Id 1958',1398.40,0.00,0.00,1.84,0.00,'2022-06-19 17:07:10','',''),(2148,'21','222','1',1,'Retail Sale Id 1959',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 17:08:29','',''),(2149,'21','222','1',1,'Retail Sale Id 1960',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 17:10:18','',''),(2150,'21','222','1',1,'Retail Sale Id 1961',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 17:12:48','',''),(2151,'21','222','1',1,'Retail Sale Id 1962',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 17:18:32','',''),(2152,'21','222','1',1,'Retail Sale Id 1962',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 17:18:32','',''),(2153,'21','222','1',1,'Retail Sale Id 1963',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 17:21:08','',''),(2154,'21','222','1',1,'Retail Sale Id 1964',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 17:23:23','',''),(2155,'21','222','1',1,'Retail Sale Id 1965',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 17:25:47','',''),(2156,'21','222','1',1,'Retail Sale Id 1966',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 17:32:52','',''),(2157,'21','222','1',1,'Retail Sale Id 1967',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 17:36:38','',''),(2158,'21','222','1',1,'Retail Sale Id 1968',8998.40,0.00,0.00,11.84,0.00,'2022-06-19 17:37:39','',''),(2159,'21','222','1',1,'Retail Sale Id 1969',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 17:38:46','',''),(2160,'21','222','1',1,'Retail Sale Id 1970',0.00,0.00,0.00,0.00,0.00,'2022-06-19 17:47:02','',''),(2161,'21','222','1',1,'Retail Sale Id 1971',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 17:48:08','',''),(2162,'21','222','1',1,'Retail Sale Id 1972',8998.40,0.00,0.00,11.84,0.00,'2022-06-19 17:49:05','',''),(2163,'21','222','1',1,'Retail Sale Id 1973',1998.80,0.00,0.00,2.63,0.00,'2022-06-19 17:50:17','',''),(2164,'21','222','1',1,'Retail Sale Id 1974',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 17:53:21','',''),(2165,'21','222','1',1,'Retail Sale Id 1975',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:00:57','',''),(2166,'21','222','1',1,'Retail Sale Id 1976',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 18:02:20','',''),(2167,'21','222','1',1,'Retail Sale Id 1977',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:03:32','',''),(2168,'21','222','1',1,'Retail Sale Id 1978',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:06:26','',''),(2169,'21','222','1',1,'Retail Sale Id 1979',798.00,0.00,0.00,1.05,0.00,'2022-06-19 18:07:40','',''),(2170,'21','222','1',1,'Retail Sale Id 1980',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 18:09:06','',''),(2171,'21','222','1',1,'Retail Sale Id 1981',1003.20,0.00,0.00,1.32,0.00,'2022-06-19 18:10:28','',''),(2172,'21','222','1',1,'Retail Sale Id 1982',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 18:11:45','',''),(2173,'21','222','1',1,'Retail Sale Id 1983',2280.00,0.00,0.00,3.00,0.00,'2022-06-19 18:17:06','',''),(2174,'21','222','1',1,'Retail Sale Id 1984',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:20:06','',''),(2175,'21','222','1',1,'Retail Sale Id 1985',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 18:21:25','',''),(2176,'21','222','1',1,'Retail Sale Id 1986',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:23:16','',''),(2177,'21','222','1',1,'Retail Sale Id 1987',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:24:26','',''),(2178,'21','222','1',1,'Retail Sale Id 1989',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 18:26:44','',''),(2179,'21','222','1',1,'Retail Sale Id 1990',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 18:28:06','',''),(2180,'21','222','1',1,'Retail Sale Id 1991',8740.00,0.00,0.00,11.50,0.00,'2022-06-19 18:32:27','',''),(2181,'21','222','1',1,'Retail Sale Id 1992',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:33:32','',''),(2182,'21','222','1',1,'Retail Sale Id 1993',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 18:34:46','',''),(2183,'21','222','1',1,'Retail Sale Id 1993',1497.20,0.00,0.00,1.97,0.00,'2022-06-19 18:34:46','',''),(2184,'21','222','1',1,'Retail Sale Id 1994',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 18:36:29','',''),(2185,'21','222','1',1,'Retail Sale Id 1995',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:39:24','',''),(2186,'21','222','1',1,'Retail Sale Id 1996',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 18:40:43','',''),(2187,'21','222','1',1,'Retail Sale Id 1997',4560.00,0.00,0.00,6.00,0.00,'2022-06-19 18:42:21','',''),(2188,'21','222','1',1,'Retail Sale Id 1998',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 18:43:48','',''),(2189,'21','222','1',1,'Retail Sale Id 1998',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:43:48','',''),(2190,'21','222','1',1,'Retail Sale Id 1999',1900.00,0.00,0.00,2.50,0.00,'2022-06-19 18:45:05','',''),(2191,'21','222','1',1,'Retail Sale Id 2000',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:52:28','',''),(2192,'21','222','1',1,'Retail Sale Id 2001',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:53:28','',''),(2193,'21','222','1',1,'Retail Sale Id 2002',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 18:56:29','',''),(2194,'21','222','1',1,'Retail Sale Id 2003',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 18:57:39','',''),(2195,'21','222','1',1,'Retail Sale Id 2004',1520.00,0.00,0.00,2.00,0.00,'2022-06-19 19:00:35','',''),(2196,'21','222','1',1,'Retail Sale Id 2005',3800.00,0.00,0.00,5.00,0.00,'2022-06-19 19:01:43','',''),(2197,'21','222','1',1,'Retail Sale Id 2006',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 19:05:14','',''),(2198,'21','222','1',1,'Retail Sale Id 2007',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 19:06:20','',''),(2199,'21','222','1',1,'Retail Sale Id 2008',3997.60,0.00,0.00,5.26,0.00,'2022-06-19 19:07:45','',''),(2200,'21','222','1',1,'Retail Sale Id 2009',4499.20,0.00,0.00,5.92,0.00,'2022-06-19 19:08:47','',''),(2201,'21','222','1',1,'Retail Sale Id 2010',3002.00,0.00,0.00,3.95,0.00,'2022-06-19 19:09:56','',''),(2202,'21','222','1',1,'Retail Sale Id 2011',0.00,0.00,0.00,0.00,0.00,'2022-06-19 19:16:26','',''),(2203,'21','222','1',1,'Retail Sale Id 2013',4750.00,0.00,0.00,6.25,0.00,'2022-06-19 19:19:59','',''),(2204,'21','222','1',1,'Retail Sale Id 2014',600.40,0.00,0.00,0.79,0.00,'2022-06-19 19:24:27','',''),(2205,'21','222','1',1,'Retail Sale Id 2015',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 19:26:54','',''),(2206,'21','222','1',1,'Retail Sale Id 2016',38000.00,0.00,0.00,50.00,0.00,'2022-06-19 21:11:31','',''),(2207,'21','222','1',1,'Retail Sale Id 2017',38000.00,0.00,0.00,50.00,0.00,'2022-06-19 21:12:12','',''),(2208,'21','222','1',1,'Retail Sale Id 2018',7600.00,0.00,0.00,10.00,0.00,'2022-06-19 21:13:04','',''),(2209,'21','222','1',1,'Retail Sale Id 2018',15200.00,0.00,0.00,20.00,0.00,'2022-06-19 21:13:04','',''),(2210,'21','222','1',1,'Retail Sale Id 2019',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 21:13:51','',''),(2211,'21','222','1',1,'Retail Sale Id 2020',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 21:14:20','',''),(2212,'21','222','1',1,'Retail Sale Id 2021',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 21:14:55','',''),(2213,'21','222','1',1,'Retail Sale Id 2022',8998.40,0.00,0.00,11.84,0.00,'2022-06-19 21:15:56','',''),(2214,'21','222','1',1,'Retail Sale Id 2022',38000.00,0.00,0.00,50.00,0.00,'2022-06-19 21:15:56','',''),(2215,'21','222','1',1,'Retail Sale Id 2023',8002.80,0.00,0.00,10.53,0.00,'2022-06-19 21:17:30','',''),(2216,'21','222','1',1,'Retail Sale Id 2023',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 21:17:30','',''),(2217,'21','222','1',1,'Retail Sale Id 2024',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 21:18:12','',''),(2218,'21','222','1',1,'Retail Sale Id 2025',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 21:18:58','',''),(2219,'21','222','1',1,'Retail Sale Id 2025',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 21:18:58','',''),(2220,'21','222','1',1,'Retail Sale Id 2026',15200.00,0.00,0.00,20.00,0.00,'2022-06-19 21:19:34','',''),(2221,'21','222','1',1,'Retail Sale Id 2027',9500.00,0.00,0.00,12.50,0.00,'2022-06-19 21:20:25','',''),(2222,'21','222','1',1,'Retail Sale Id 2028',6566.40,0.00,0.00,8.64,0.00,'2022-06-19 21:21:41','',''),(2223,'21','222','1',1,'Return of Retail Sale Id 2027',0.00,9500.00,12.50,0.00,0.00,'2022-06-19 21:25:14','',''),(2224,'21','222','1',1,'Retail Sale Id 2029',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 07:39:03','',''),(2225,'21','222','1',1,'Retail Sale Id 2030',9507.60,0.00,0.00,12.51,0.00,'2022-06-20 08:37:51','',''),(2226,'21','222','1',1,'Retail Sale Id 2031',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 08:52:05','',''),(2227,'21','222','1',1,'Retail Sale Id 2032',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 09:01:02','',''),(2228,'21','222','1',1,'Retail Sale Id 2033',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 09:26:41','',''),(2229,'21','222','1',1,'Retail Sale Id 2034',3002.00,0.00,0.00,3.95,0.00,'2022-06-20 09:28:44','',''),(2230,'21','222','1',1,'Retail Sale Id 2035',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 09:31:35','',''),(2231,'21','222','1',1,'Retail Sale Id 2036',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 09:34:22','',''),(2232,'21','222','1',1,'Retail Sale Id 2037',760.00,0.00,0.00,1.00,0.00,'2022-06-20 09:35:46','',''),(2233,'21','222','1',1,'Retail Sale Id 2038',11400.00,0.00,0.00,15.00,0.00,'2022-06-20 09:45:14','',''),(2234,'21','222','1',1,'Retail Sale Id 2039',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 09:48:12','',''),(2235,'21','222','1',1,'Retail Sale Id 2040',19000.00,0.00,0.00,25.00,0.00,'2022-06-20 09:51:45','',''),(2236,'21','222','1',1,'Retail Sale Id 2041',3298.40,0.00,0.00,4.34,0.00,'2022-06-20 09:55:32','',''),(2237,'21','222','1',1,'Retail Sale Id 2042',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 10:09:47','',''),(2238,'21','222','1',1,'Retail Sale Id 2043',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 10:14:07','',''),(2239,'21','222','1',1,'Retail Sale Id 2044',3040.00,0.00,0.00,4.00,0.00,'2022-06-20 10:19:13','',''),(2240,'21','222','1',1,'Retail Sale Id 2045',24700.00,0.00,0.00,32.50,0.00,'2022-06-20 10:40:06','',''),(2241,'21','222','1',1,'Retail Sale Id 2046',8002.80,0.00,0.00,10.53,0.00,'2022-06-20 10:42:55','',''),(2242,'21','222','1',1,'Retail Sale Id 2047',3997.60,0.00,0.00,5.26,0.00,'2022-06-20 10:45:54','',''),(2243,'21','222','1',1,'Retail Sale Id 2048',760.00,0.00,0.00,1.00,0.00,'2022-06-20 10:47:46','',''),(2244,'21','222','1',1,'Retail Sale Id 2049',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 10:49:36','',''),(2245,'21','222','1',1,'Retail Sale Id 2050',11400.00,0.00,0.00,15.00,0.00,'2022-06-20 10:52:46','',''),(2246,'21','222','1',1,'Retail Sale Id 2051',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 10:54:39','',''),(2247,'21','222','1',1,'Retail Sale Id 2052',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 11:00:19','',''),(2248,'21','222','1',1,'Retail Sale Id 2053',7600.00,0.00,0.00,10.00,0.00,'2022-06-20 11:16:09','',''),(2249,'21','222','1',1,'Retail Sale Id 2054',3002.00,0.00,0.00,3.95,0.00,'2022-06-20 12:24:26','',''),(2250,'21','222','1',1,'Retail Sale Id 2055',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 12:27:22','',''),(2251,'21','222','1',1,'Retail Sale Id 2056',95000.00,0.00,0.00,125.00,0.00,'2022-06-20 13:18:55','',''),(2252,'21','222','1',1,'Retail Sale Id 2057',2500.40,0.00,0.00,3.29,0.00,'2022-06-20 13:20:02','',''),(2253,'21','222','1',1,'Retail Sale Id 2058',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 13:21:55','',''),(2254,'21','222','1',1,'Retail Sale Id 2059',3002.00,0.00,0.00,3.95,0.00,'2022-06-20 13:27:28','',''),(2255,'21','222','1',1,'Retail Sale Id 2060',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 13:29:41','',''),(2256,'21','222','1',1,'Retail Sale Id 2061',12000.40,0.00,0.00,15.79,0.00,'2022-06-20 13:32:55','',''),(2257,'21','222','1',1,'Retail Sale Id 2062',5000.80,0.00,0.00,6.58,0.00,'2022-06-20 13:49:13','',''),(2258,'21','222','1',1,'Retail Sale Id 2063',760.00,0.00,0.00,1.00,0.00,'2022-06-20 13:50:44','',''),(2259,'21','222','1',1,'Retail Sale Id 2064',2796.80,0.00,0.00,3.68,0.00,'2022-06-20 13:56:47','',''),(2260,'21','222','1',1,'Retail Sale Id 2065',7600.00,0.00,0.00,10.00,0.00,'2022-06-20 14:26:56','',''),(2261,'21','222','1',1,'Retail Sale Id 2066',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 14:30:31','',''),(2262,'21','222','1',1,'Retail Sale Id 2067',2500.40,0.00,0.00,3.29,0.00,'2022-06-20 15:00:25','',''),(2263,'21','222','1',1,'Retail Sale Id 2068',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 15:10:00','',''),(2264,'21','222','1',1,'Retail Sale Id 2069',8002.80,0.00,0.00,10.53,0.00,'2022-06-20 15:16:39','',''),(2265,'21','222','1',1,'Retail Sale Id 2071',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 15:24:28','',''),(2266,'21','222','1',1,'Retail Sale Id 2072',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 15:38:16','',''),(2267,'21','222','1',1,'Retail Sale Id 2073',1003.20,0.00,0.00,1.32,0.00,'2022-06-20 15:40:01','',''),(2268,'21','222','1',1,'Retail Sale Id 2074',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 15:49:09','',''),(2269,'21','222','1',1,'Retail Sale Id 2075',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 16:17:03','',''),(2270,'21','222','1',1,'Retail Sale Id 2076',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 16:31:08','',''),(2271,'21','222','1',1,'Retail Sale Id 2077',11400.00,0.00,0.00,15.00,0.00,'2022-06-20 16:45:28','',''),(2272,'21','222','1',1,'Retail Sale Id 2078',4750.00,0.00,0.00,6.25,0.00,'2022-06-20 16:49:01','',''),(2273,'21','222','1',1,'Retail Sale Id 2079',19000.00,0.00,0.00,25.00,0.00,'2022-06-20 16:53:32','',''),(2274,'21','222','1',1,'Retail Sale Id 2080',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 16:56:53','',''),(2275,'21','222','1',1,'Retail Sale Id 2081',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 17:32:06','',''),(2276,'21','222','1',1,'Retail Sale Id 2082',15200.00,0.00,0.00,20.00,0.00,'2022-06-20 17:36:09','',''),(2277,'21','222','1',1,'Retail Sale Id 2083',1520.00,0.00,0.00,2.00,0.00,'2022-06-20 17:48:31','',''),(2278,'21','222','1',1,'Retail Sale Id 2084',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 18:30:27','',''),(2279,'21','222','1',1,'Retail Sale Id 2085',760.00,0.00,0.00,1.00,0.00,'2022-06-20 18:31:54','',''),(2280,'21','222','1',1,'Retail Sale Id 2087',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 18:33:46','',''),(2281,'21','222','1',1,'Retail Sale Id 2088',15200.00,0.00,0.00,20.00,0.00,'2022-06-20 18:37:35','',''),(2282,'21','222','1',1,'Retail Sale Id 2090',1200.80,0.00,0.00,1.58,0.00,'2022-06-20 18:56:35','',''),(2283,'21','222','1',1,'Retail Sale Id 2091',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 18:58:55','',''),(2284,'21','222','1',1,'Retail Sale Id 2092',14060.00,0.00,0.00,18.50,0.00,'2022-06-20 19:03:44','',''),(2285,'21','222','1',1,'Retail Sale Id 2093',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 19:05:43','',''),(2286,'21','222','1',1,'Retail Sale Id 2094',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 19:08:48','',''),(2287,'21','222','1',1,'Retail Sale Id 2095',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 19:11:59','',''),(2288,'21','222','1',1,'Retail Sale Id 2096',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 19:15:03','',''),(2289,'21','222','1',1,'Retail Sale Id 2097',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 19:16:52','',''),(2290,'21','222','1',1,'Retail Sale Id 2098',1998.80,0.00,0.00,2.63,0.00,'2022-06-20 19:20:05','',''),(2291,'21','222','1',1,'Retail Sale Id 2099',2500.40,0.00,0.00,3.29,0.00,'2022-06-20 19:20:56','',''),(2292,'21','222','1',1,'Retail Sale Id 2100',3002.00,0.00,0.00,3.95,0.00,'2022-06-20 19:25:27','',''),(2293,'21','222','1',1,'Retail Sale Id 2101',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 19:27:05','',''),(2294,'21','222','1',1,'Retail Sale Id 2102',8998.40,0.00,0.00,11.84,0.00,'2022-06-20 19:29:01','',''),(2295,'21','222','1',1,'Retail Sale Id 2103',1003.20,0.00,0.00,1.32,0.00,'2022-06-20 19:30:41','',''),(2296,'21','222','1',1,'Retail Sale Id 2104',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 19:32:13','',''),(2297,'21','222','1',1,'Retail Sale Id 2105',3800.00,0.00,0.00,5.00,0.00,'2022-06-20 19:33:30','',''),(2298,'21','222','1',1,'Retail Sale Id 2106',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 19:37:26','',''),(2299,'21','222','1',1,'Retail Sale Id 2107',1497.20,0.00,0.00,1.97,0.00,'2022-06-20 19:48:50','',''),(2300,'21','222','1',1,'Retail Sale Id 2108',1702.40,0.00,0.00,2.24,0.00,'2022-06-20 19:51:11','',''),(2301,'21','222','1',1,'Retail Sale Id 2109',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 19:54:35','',''),(2302,'21','222','1',1,'Retail Sale Id 2110',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 19:59:33','',''),(2303,'21','222','1',1,'Retail Sale Id 2111',2280.00,0.00,0.00,3.00,0.00,'2022-06-20 20:02:26','',''),(2304,'21','222','1',1,'Retail Sale Id 2112',4560.00,0.00,0.00,6.00,0.00,'2022-06-20 20:04:11','',''),(2305,'21','222','1',1,'Retail Sale Id 2113',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 20:27:05','',''),(2306,'21','222','1',1,'Retail Sale Id 2114',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 20:28:32','',''),(2307,'21','222','1',1,'Retail Sale Id 2115',19000.00,0.00,0.00,25.00,0.00,'2022-06-20 20:29:47','',''),(2308,'21','222','1',1,'Retail Sale Id 2116',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 20:31:42','',''),(2309,'21','222','1',1,'Retail Sale Id 2117',9500.00,0.00,0.00,12.50,0.00,'2022-06-20 20:32:57','',''),(2310,'21','222','1',1,'Retail Sale Id 2118',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 20:35:04','',''),(2311,'21','222','1',1,'Retail Sale Id 2119',35720.00,0.00,0.00,47.00,0.00,'2022-06-20 20:36:18','',''),(2312,'21','222','1',1,'Retail Sale Id 2120',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 20:38:14','',''),(2313,'21','222','1',1,'Retail Sale Id 2121',38000.00,0.00,0.00,50.00,0.00,'2022-06-20 20:40:05','',''),(2314,'21','222','1',1,'Retail Sale Id 2122',19000.00,0.00,0.00,25.00,0.00,'2022-06-20 20:41:51','',''),(2315,'21','222','1',1,'Retail Sale Id 2123',25695.60,0.00,0.00,33.81,0.00,'2022-06-20 20:46:20','',''),(2316,'21','222','1',1,'Retail Sale Id 2124',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 07:04:53','',''),(2317,'21','222','1',1,'Retail Sale Id 2125',3800.00,0.00,0.00,5.00,0.00,'2022-06-21 07:45:01','',''),(2318,'21','222','1',1,'Retail Sale Id 2126',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 07:46:57','',''),(2319,'21','222','1',1,'Retail Sale Id 2127',4560.00,0.00,0.00,6.00,0.00,'2022-06-21 07:51:47','',''),(2320,'21','222','1',1,'Retail Sale Id 2128',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 07:59:38','',''),(2321,'21','222','1',1,'Retail Sale Id 2129',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 08:49:59','',''),(2322,'21','222','1',1,'Retail Sale Id 2130',2280.00,0.00,0.00,3.00,0.00,'2022-06-21 09:28:11','',''),(2323,'21','222','1',1,'Retail Sale Id 2131',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 09:29:45','',''),(2324,'21','222','1',1,'Retail Sale Id 2132',38000.00,0.00,0.00,50.00,0.00,'2022-06-21 15:08:49','',''),(2325,'21','222','1',1,'Retail Sale Id 2134',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 15:15:07','',''),(2326,'21','222','1',1,'Retail Sale Id 2135',38000.00,0.00,0.00,50.00,0.00,'2022-06-21 15:16:16','',''),(2327,'21','222','1',1,'Retail Sale Id 2136',75802.40,0.00,0.00,99.74,0.00,'2022-06-21 15:17:53','',''),(2328,'21','222','1',1,'Retail Sale Id 2137',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 15:19:15','',''),(2329,'21','222','1',1,'Retail Sale Id 2138',19000.00,0.00,0.00,25.00,0.00,'2022-06-21 15:20:48','',''),(2330,'21','222','1',1,'Retail Sale Id 2139',11400.00,0.00,0.00,15.00,0.00,'2022-06-21 15:22:05','',''),(2331,'21','222','1',1,'Retail Sale Id 2140',9500.00,0.00,0.00,12.50,0.00,'2022-06-21 15:23:41','',''),(2332,'21','222','1',1,'Retail Sale Id 2141',19000.00,0.00,0.00,25.00,0.00,'2022-06-21 15:26:43','',''),(2333,'21','222','1',1,'Retail Sale Id 2142',38000.00,0.00,0.00,50.00,0.00,'2022-06-21 15:28:10','',''),(2334,'21','222','1',1,'Retail Sale Id 2143',11400.00,0.00,0.00,15.00,0.00,'2022-06-21 15:30:54','',''),(2335,'21','222','1',1,'Retail Sale Id 2145',38000.00,0.00,0.00,50.00,0.00,'2022-06-21 15:34:38','',''),(2336,'21','222','1',1,'Retail Sale Id 2148',36480.00,0.00,0.00,48.00,0.00,'2022-06-21 15:45:42','',''),(2337,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,53200.00,70.00,0.00,0.00,'2022-06-21 16:06:17','',''),(2338,'21','222',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,70.00,0.00,'2022-06-21 16:09:32','',''),(2339,'21','222','1',1,'Received from bridging 16',0.00,0.00,70.00,0.00,0.00,'2022-06-21 16:09:32','',''),(2340,'21','222','1',1,'Retail Sale Id 2150',38000.00,0.00,0.00,50.00,0.00,'2022-06-21 16:13:09','',''),(2341,'21','222','1',1,'Retail Sale Id 2152',15200.00,0.00,0.00,20.00,0.00,'2022-06-21 19:02:30','',''),(2342,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-06-21 19:13:42','',''),(2343,'21','222',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,4999.00,0.00,'2022-06-21 19:19:49','',''),(2344,'21','222','1',1,'Received from bridging 17',0.00,0.00,4999.00,0.00,0.00,'2022-06-21 19:19:49','',''),(2345,'21','222','1',1,'Retail Sale Id 2154',6999.60,0.00,0.00,9.21,0.00,'2022-06-21 19:25:19','',''),(2346,'21','222','1',1,'Retail Sale Id 2155',7600.00,0.00,0.00,10.00,0.00,'2022-06-21 19:28:24','',''),(2347,'21','222','1',1,'Retail Sale Id 2156',38000.00,0.00,0.00,50.00,0.00,'2022-06-21 20:55:06','',''),(2348,'21','222','1',1,'Retail Sale Id 2157',19000.00,0.00,0.00,25.00,0.00,'2022-06-21 20:59:56','',''),(2349,'21','222','1',1,'Retail Sale Id 2158',11400.00,0.00,0.00,15.00,0.00,'2022-06-21 21:01:01','',''),(2350,'21','222','1',1,'Retail Sale Id 2159',15200.00,0.00,0.00,20.00,0.00,'2022-06-21 21:02:36','',''),(2351,'21','222','1',1,'Retail Sale Id 2160',38000.00,0.00,0.00,50.00,0.00,'2022-06-21 21:05:35','',''),(2352,'21','222','1',1,'Retail Sale Id 2161',38000.00,0.00,0.00,50.00,0.00,'2022-06-21 21:07:20','',''),(2353,'21','222','1',1,'Retail Sale Id 2162',70003.60,0.00,0.00,92.11,0.00,'2022-06-21 21:09:59','',''),(2354,'21','222','1',1,'Retail Sale Id 2163',36100.00,0.00,0.00,47.50,0.00,'2022-06-21 21:14:31','',''),(2355,'21','222','1',1,'Retail Sale Id 2164',3040.00,0.00,0.00,4.00,0.00,'2022-06-22 08:17:42','',''),(2356,'21','222','1',1,'Retail Sale Id 2165',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 08:20:52','',''),(2357,'21','222','1',1,'Retail Sale Id 2165',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 08:20:52','',''),(2358,'21','222','1',1,'Retail Sale Id 2166',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 08:27:24','',''),(2359,'21','222','1',1,'Retail Sale Id 2167',3997.60,0.00,0.00,5.26,0.00,'2022-06-22 08:43:52','',''),(2360,'21','222','1',1,'Retail Sale Id 2168',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 08:45:24','',''),(2361,'21','222','1',1,'Retail Sale Id 2169',3002.00,0.00,0.00,3.95,0.00,'2022-06-22 08:47:39','',''),(2362,'21','222','1',1,'Retail Sale Id 2169',3002.00,0.00,0.00,3.95,0.00,'2022-06-22 08:47:39','',''),(2363,'21','222','1',1,'Retail Sale Id 2170',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 10:11:50','',''),(2364,'21','222','1',1,'Retail Sale Id 2171',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:13:05','',''),(2365,'21','222','1',1,'Retail Sale Id 2172',3503.60,0.00,0.00,4.61,0.00,'2022-06-22 10:18:29','',''),(2366,'21','222','1',1,'Retail Sale Id 2173',2500.40,0.00,0.00,3.29,0.00,'2022-06-22 10:19:43','',''),(2367,'21','222','1',1,'Retail Sale Id 2174',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 10:20:56','',''),(2368,'21','222','1',1,'Retail Sale Id 2175',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:30:34','',''),(2369,'21','222','1',1,'Retail Sale Id 2175',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:30:34','',''),(2370,'21','222','1',1,'Retail Sale Id 2175',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:30:34','',''),(2371,'21','222','1',1,'Retail Sale Id 2176',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 10:32:44','',''),(2372,'21','222','1',1,'Retail Sale Id 2177',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 10:34:21','',''),(2373,'21','222','1',1,'Retail Sale Id 2178',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 10:36:25','',''),(2374,'21','222','1',1,'Retail Sale Id 2179',5996.40,0.00,0.00,7.89,0.00,'2022-06-22 10:39:32','',''),(2375,'21','222','1',1,'Retail Sale Id 2180',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 10:43:27','',''),(2376,'21','222','1',1,'Retail Sale Id 2181',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 11:23:41','',''),(2377,'21','222','1',1,'Retail Sale Id 2182',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 11:55:48','',''),(2378,'21','222','1',1,'Retail Sale Id 2183',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 11:57:21','',''),(2379,'21','222','1',1,'Retail Sale Id 2183',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 11:57:21','',''),(2380,'21','222','1',1,'Retail Sale Id 2184',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 12:01:10','',''),(2381,'21','222','1',1,'Retail Sale Id 2185',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 12:06:17','',''),(2382,'21','222','1',1,'Retail Sale Id 2186',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 12:09:46','',''),(2383,'21','222','1',1,'Retail Sale Id 2186',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 12:09:46','',''),(2384,'21','222','1',1,'Retail Sale Id 2187',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 12:36:38','',''),(2385,'21','222','1',1,'Retail Sale Id 2188',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 12:40:56','',''),(2386,'21','222','1',1,'Retail Sale Id 2189',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 12:49:48','',''),(2387,'21','222','1',1,'Retail Sale Id 2190',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 12:58:05','',''),(2388,'21','222','1',1,'Retail Sale Id 2191',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 13:05:47','',''),(2389,'21','222','1',1,'Retail Sale Id 2191',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 13:05:47','',''),(2390,'21','222','1',1,'Retail Sale Id 2192',6999.60,0.00,0.00,9.21,0.00,'2022-06-22 13:11:49','',''),(2391,'21','222','1',1,'Retail Sale Id 2193',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 13:21:41','',''),(2392,'21','222','1',1,'Retail Sale Id 2194',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 13:27:54','',''),(2393,'21','222','1',1,'Retail Sale Id 2194',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 13:27:54','',''),(2394,'21','222','1',1,'Retail Sale Id 2195',798.00,0.00,0.00,1.05,0.00,'2022-06-22 13:29:41','',''),(2395,'21','222','1',1,'Retail Sale Id 2196',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 13:38:06','',''),(2396,'21','222','1',1,'Retail Sale Id 2197',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 13:42:28','',''),(2397,'21','222','1',1,'Retail Sale Id 2198',1520.00,0.00,0.00,2.00,0.00,'2022-06-22 13:44:16','',''),(2398,'21','222','1',1,'Retail Sale Id 2199',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 13:59:21','',''),(2399,'21','222','1',1,'Retail Sale Id 2199',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 13:59:21','',''),(2400,'21','222','1',1,'Retail Sale Id 2200',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 14:00:44','',''),(2401,'21','222','1',1,'Retail Sale Id 2201',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 14:01:47','',''),(2402,'21','222','1',1,'Retail Sale Id 2202',3997.60,0.00,0.00,5.26,0.00,'2022-06-22 14:13:52','',''),(2403,'21','222','1',1,'Retail Sale Id 2203',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 14:33:23','',''),(2404,'21','222','1',1,'Retail Sale Id 2203',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 14:33:23','',''),(2405,'21','222','1',1,'Retail Sale Id 2204',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 14:40:51','',''),(2406,'21','222','1',1,'Retail Sale Id 2204',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 14:40:51','',''),(2407,'21','222','1',1,'Retail Sale Id 2205',1200.80,0.00,0.00,1.58,0.00,'2022-06-22 14:44:45','',''),(2408,'21','222','1',1,'Retail Sale Id 2205',3002.00,0.00,0.00,3.95,0.00,'2022-06-22 14:44:45','',''),(2409,'21','222','1',1,'Retail Sale Id 2206',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 14:45:56','',''),(2410,'21','222','1',1,'Retail Sale Id 2207',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 14:47:24','',''),(2411,'21','222','1',1,'Retail Sale Id 2208',1497.20,0.00,0.00,1.97,0.00,'2022-06-22 14:58:45','',''),(2412,'21','222','1',1,'Retail Sale Id 2209',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 15:06:19','',''),(2413,'21','222','1',1,'Retail Sale Id 2210',760.00,0.00,0.00,1.00,0.00,'2022-06-22 15:07:21','',''),(2414,'21','222','1',1,'Retail Sale Id 2211',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 15:14:53','',''),(2415,'21','222','1',1,'Retail Sale Id 2212',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 15:16:05','',''),(2416,'21','222','1',1,'Retail Sale Id 2213',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 15:20:25','',''),(2417,'21','222','1',1,'Retail Sale Id 2213',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 15:20:25','',''),(2418,'21','222','1',1,'Retail Sale Id 2214',6999.60,0.00,0.00,9.21,0.00,'2022-06-22 15:36:46','',''),(2419,'21','222','1',1,'Retail Sale Id 2215',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 16:00:39','',''),(2420,'21','222','1',1,'Retail Sale Id 2216',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 16:27:59','',''),(2421,'21','222','1',1,'Retail Sale Id 2217',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 16:32:28','',''),(2422,'21','222','1',1,'Retail Sale Id 2218',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 16:33:26','',''),(2423,'21','222','1',1,'Retail Sale Id 2219',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 16:41:47','',''),(2424,'21','222','1',1,'Retail Sale Id 2219',8002.80,0.00,0.00,10.53,0.00,'2022-06-22 16:41:47','',''),(2425,'21','222','1',1,'Retail Sale Id 2220',1200.80,0.00,0.00,1.58,0.00,'2022-06-22 16:43:23','',''),(2426,'21','222','1',1,'Retail Sale Id 2220',1200.80,0.00,0.00,1.58,0.00,'2022-06-22 16:43:23','',''),(2427,'21','222','1',1,'Retail Sale Id 2221',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 16:44:42','',''),(2428,'21','222','1',1,'Retail Sale Id 2222',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 16:49:48','',''),(2429,'21','222','1',1,'Retail Sale Id 2223',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 16:51:46','',''),(2430,'21','222','1',1,'Retail Sale Id 2224',4301.60,0.00,0.00,5.66,0.00,'2022-06-22 16:52:50','',''),(2431,'21','222','1',1,'Retail Sale Id 2225',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 16:53:50','',''),(2432,'21','222','1',1,'Retail Sale Id 2226',6999.60,0.00,0.00,9.21,0.00,'2022-06-22 16:55:20','',''),(2433,'21','222','1',1,'Retail Sale Id 2227',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 16:56:08','',''),(2434,'21','222','1',1,'Retail Sale Id 2228',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 16:57:30','',''),(2435,'21','222','1',1,'Retail Sale Id 2229',4499.20,0.00,0.00,5.92,0.00,'2022-06-22 17:00:05','',''),(2436,'21','222','1',1,'Retail Sale Id 2230',38000.00,0.00,0.00,50.00,0.00,'2022-06-22 17:06:36','',''),(2437,'21','222','1',1,'Retail Sale Id 2231',1520.00,0.00,0.00,2.00,0.00,'2022-06-22 17:07:24','',''),(2438,'21','222','1',1,'Retail Sale Id 2232',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 17:15:28','',''),(2439,'21','222','1',1,'Retail Sale Id 2233',8360.00,0.00,0.00,11.00,0.00,'2022-06-22 17:26:32','',''),(2440,'21','222','1',1,'Retail Sale Id 2234',1003.20,0.00,0.00,1.32,0.00,'2022-06-22 17:30:39','',''),(2441,'21','222','1',1,'Retail Sale Id 2234',1003.20,0.00,0.00,1.32,0.00,'2022-06-22 17:30:39','',''),(2442,'21','222','1',1,'Retail Sale Id 2235',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 17:31:45','',''),(2443,'21','222','1',1,'Retail Sale Id 2236',1003.20,0.00,0.00,1.32,0.00,'2022-06-22 17:33:33','',''),(2444,'21','222','1',1,'Retail Sale Id 2237',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 17:35:33','',''),(2445,'21','222','1',1,'Retail Sale Id 2238',1900.00,0.00,0.00,2.50,0.00,'2022-06-22 17:37:10','',''),(2446,'21','222','1',1,'Retail Sale Id 2239',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 17:45:21','',''),(2447,'21','222','1',1,'Retail Sale Id 2240',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 17:48:03','',''),(2448,'21','222','1',1,'Retail Sale Id 2241',760.00,0.00,0.00,1.00,0.00,'2022-06-22 17:53:08','',''),(2449,'21','222','1',1,'Retail Sale Id 2241',760.00,0.00,0.00,1.00,0.00,'2022-06-22 17:53:08','',''),(2450,'21','222','1',1,'Retail Sale Id 2242',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 17:58:48','',''),(2451,'21','222','1',1,'Retail Sale Id 2243',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 18:05:41','',''),(2452,'21','222','1',1,'Retail Sale Id 2244',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 18:08:08','',''),(2453,'21','222','1',1,'Retail Sale Id 2245',5000.80,0.00,0.00,6.58,0.00,'2022-06-22 18:10:07','',''),(2454,'21','222','1',1,'Retail Sale Id 2246',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 18:11:10','',''),(2455,'21','222','1',1,'Retail Sale Id 2247',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 18:12:29','',''),(2456,'21','222','1',1,'Retail Sale Id 2248',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 18:14:34','',''),(2457,'21','222','1',1,'Retail Sale Id 2249',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 18:16:56','',''),(2458,'21','222','1',1,'Retail Sale Id 2250',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 18:18:54','',''),(2459,'21','222','1',1,'Retail Sale Id 2251',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 18:27:06','',''),(2460,'21','222','1',1,'Retail Sale Id 2252',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 18:29:43','',''),(2461,'21','222','1',1,'Retail Sale Id 2253',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 18:33:00','',''),(2462,'21','222','1',1,'Retail Sale Id 2254',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 18:35:31','',''),(2463,'21','222','1',1,'Retail Sale Id 2255',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 18:39:21','',''),(2464,'21','222','1',1,'Retail Sale Id 2256',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 18:42:01','',''),(2465,'21','222','1',1,'Retail Sale Id 2257',4750.00,0.00,0.00,6.25,0.00,'2022-06-22 18:43:49','',''),(2466,'21','222','1',1,'Retail Sale Id 2258',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 18:46:32','',''),(2467,'21','222','1',1,'Retail Sale Id 2259',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 18:50:44','',''),(2468,'21','222','1',1,'Retail Sale Id 2259',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 18:50:44','',''),(2469,'21','222','1',1,'Retail Sale Id 2260',1998.80,0.00,0.00,2.63,0.00,'2022-06-22 18:55:06','',''),(2470,'21','222','1',1,'Retail Sale Id 2260',2500.40,0.00,0.00,3.29,0.00,'2022-06-22 18:55:06','',''),(2471,'21','222','1',1,'Retail Sale Id 2261',1003.20,0.00,0.00,1.32,0.00,'2022-06-22 18:56:39','',''),(2472,'21','222','1',1,'Retail Sale Id 2262',6999.60,0.00,0.00,9.21,0.00,'2022-06-22 18:57:36','',''),(2473,'21','222','1',1,'Retail Sale Id 2263',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 18:59:22','',''),(2474,'21','222','1',1,'Retail Sale Id 2264',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 19:01:58','',''),(2475,'21','222','1',1,'Retail Sale Id 2265',4560.00,0.00,0.00,6.00,0.00,'2022-06-22 19:04:46','',''),(2476,'21','222','1',1,'Retail Sale Id 2266',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 19:07:04','',''),(2477,'21','222','1',1,'Retail Sale Id 2267',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 19:08:57','',''),(2478,'21','222','1',1,'Retail Sale Id 2268',3800.00,0.00,0.00,5.00,0.00,'2022-06-22 19:21:17','',''),(2479,'21','222','1',1,'Retail Sale Id 2269',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 19:24:05','',''),(2480,'21','222','1',1,'Retail Sale Id 2270',699.20,0.00,0.00,0.92,0.00,'2022-06-22 19:28:24','',''),(2481,'21','222','1',1,'Retail Sale Id 2271',2280.00,0.00,0.00,3.00,0.00,'2022-06-22 19:41:25','',''),(2482,'21','222','1',1,'Retail Sale Id 2272',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 19:42:26','',''),(2483,'21','222','1',1,'Retail Sale Id 2273',38000.00,0.00,0.00,50.00,0.00,'2022-06-22 20:40:42','',''),(2484,'21','222','1',1,'Retail Sale Id 2274',38000.00,0.00,0.00,50.00,0.00,'2022-06-22 20:41:13','',''),(2485,'21','222','1',1,'Retail Sale Id 2275',15200.00,0.00,0.00,20.00,0.00,'2022-06-22 20:42:00','',''),(2486,'21','222','1',1,'Retail Sale Id 2276',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 20:43:57','',''),(2487,'21','222','1',1,'Retail Sale Id 2276',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 20:43:57','',''),(2488,'21','222','1',1,'Retail Sale Id 2276',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 20:43:57','',''),(2489,'21','222','1',1,'Retail Sale Id 2277',19000.00,0.00,0.00,25.00,0.00,'2022-06-22 20:44:22','',''),(2490,'21','222','1',1,'Retail Sale Id 2278',38000.00,0.00,0.00,50.00,0.00,'2022-06-22 20:45:40','',''),(2491,'21','222','1',1,'Retail Sale Id 2278',38000.00,0.00,0.00,50.00,0.00,'2022-06-22 20:45:40','',''),(2492,'21','222','1',1,'Retail Sale Id 2279',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 20:46:55','',''),(2493,'21','222','1',1,'Retail Sale Id 2279',7600.00,0.00,0.00,10.00,0.00,'2022-06-22 20:46:55','',''),(2494,'21','222','1',1,'Retail Sale Id 2280',11400.00,0.00,0.00,15.00,0.00,'2022-06-22 20:50:14','',''),(2495,'21','222','1',1,'Retail Sale Id 2281',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 20:51:20','',''),(2496,'21','222','1',1,'Retail Sale Id 2282',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 20:52:15','',''),(2497,'21','222','1',1,'Retail Sale Id 2282',9500.00,0.00,0.00,12.50,0.00,'2022-06-22 20:52:15','',''),(2498,'21','222','1',1,'Retail Sale Id 2283',4940.00,0.00,0.00,6.50,0.00,'2022-06-22 20:55:46','',''),(2499,'21','222','1',1,'Retail Sale Id 2284',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 08:27:28','',''),(2500,'21','222','1',1,'Retail Sale Id 2285',5996.40,0.00,0.00,7.89,0.00,'2022-06-23 08:34:24','',''),(2501,'21','222','1',1,'Retail Sale Id 2286',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 08:36:42','',''),(2502,'21','222','1',1,'Retail Sale Id 2286',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 08:36:42','',''),(2503,'21','222','1',1,'Retail Sale Id 2287',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 08:41:59','',''),(2504,'21','222','1',1,'Retail Sale Id 2288',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 08:44:13','',''),(2505,'21','222','1',1,'Retail Sale Id 2289',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 08:46:20','',''),(2506,'21','222','1',1,'Retail Sale Id 2290',4750.00,0.00,0.00,6.25,0.00,'2022-06-23 08:48:57','',''),(2507,'21','222','1',1,'Retail Sale Id 2291',1003.20,0.00,0.00,1.32,0.00,'2022-06-23 09:04:59','',''),(2508,'21','222','1',1,'Retail Sale Id 2292',4750.00,0.00,0.00,6.25,0.00,'2022-06-23 09:06:48','',''),(2509,'21','222','1',1,'Retail Sale Id 2293',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 09:09:43','',''),(2510,'21','222','1',1,'Retail Sale Id 2294',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 09:11:49','',''),(2511,'21','222','1',1,'Retail Sale Id 2295',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 09:12:57','',''),(2512,'21','222','1',1,'Retail Sale Id 2296',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 09:19:21','',''),(2513,'21','222','1',1,'Retail Sale Id 2297',3002.00,0.00,0.00,3.95,0.00,'2022-06-23 09:24:16','',''),(2514,'21','222','1',1,'Retail Sale Id 2298',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 09:27:05','',''),(2515,'21','222','1',1,'Retail Sale Id 2299',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 09:29:10','',''),(2516,'21','222','1',1,'Retail Sale Id 2300',3002.00,0.00,0.00,3.95,0.00,'2022-06-23 09:31:59','',''),(2517,'21','222','1',1,'Retail Sale Id 2301',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 09:34:22','',''),(2518,'21','222','1',1,'Retail Sale Id 2302',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 09:37:39','',''),(2519,'21','222','1',1,'Retail Sale Id 2303',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 09:43:39','',''),(2520,'21','222','1',1,'Retail Sale Id 2304',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 09:45:02','',''),(2521,'21','222','1',1,'Retail Sale Id 2305',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 09:51:36','',''),(2522,'21','222','1',1,'Retail Sale Id 2306',8998.40,0.00,0.00,11.84,0.00,'2022-06-23 09:59:58','',''),(2523,'21','222','1',1,'Retail Sale Id 2307',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 10:01:10','',''),(2524,'21','222','1',1,'Retail Sale Id 2308',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 10:03:04','',''),(2525,'21','222','1',1,'Retail Sale Id 2309',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 10:06:38','',''),(2526,'21','222','1',1,'Retail Sale Id 2310',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 10:08:37','',''),(2527,'21','222','1',1,'Retail Sale Id 2311',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 10:10:29','',''),(2528,'21','222','1',1,'Retail Sale Id 2312',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 10:12:19','',''),(2529,'21','222','1',1,'Retail Sale Id 2313',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 10:17:27','',''),(2530,'21','222','1',1,'Retail Sale Id 2314',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 10:22:23','',''),(2531,'21','222','1',1,'Retail Sale Id 2314',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 10:22:23','',''),(2532,'21','222','1',1,'Retail Sale Id 2315',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 10:23:57','',''),(2533,'21','222','1',1,'Retail Sale Id 2316',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 10:56:02','',''),(2534,'21','222','1',1,'Retail Sale Id 2317',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 11:09:44','',''),(2535,'21','222','1',1,'Retail Sale Id 2318',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 11:19:27','',''),(2536,'21','222','1',1,'Retail Sale Id 2319',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 11:38:03','',''),(2537,'21','222','1',1,'Retail Sale Id 2321',5000.80,0.00,0.00,6.58,0.00,'2022-06-23 11:40:45','',''),(2538,'21','222','1',1,'Retail Sale Id 2322',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 11:44:46','',''),(2539,'21','222','1',1,'Retail Sale Id 2323',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 12:00:13','',''),(2540,'21','222','1',1,'Retail Sale Id 2324',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:08:08','',''),(2541,'21','222','1',1,'Retail Sale Id 2325',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 12:09:16','',''),(2542,'21','222','1',1,'Retail Sale Id 2326',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:11:51','',''),(2543,'21','222','1',1,'Retail Sale Id 2327',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:15:08','',''),(2544,'21','222','1',1,'Retail Sale Id 2328',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 12:19:06','',''),(2545,'21','222','1',1,'Retail Sale Id 2329',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 12:20:22','',''),(2546,'21','222','1',1,'Retail Sale Id 2330',3997.60,0.00,0.00,5.26,0.00,'2022-06-23 12:22:55','',''),(2547,'21','222','1',1,'Retail Sale Id 2331',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 12:36:11','',''),(2548,'21','222','1',1,'Retail Sale Id 2331',5320.00,0.00,0.00,7.00,0.00,'2022-06-23 12:36:11','',''),(2549,'21','222','1',1,'Retail Sale Id 2332',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 12:38:37','',''),(2550,'21','222','1',1,'Retail Sale Id 2333',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:45:14','',''),(2551,'21','222','1',1,'Retail Sale Id 2334',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 12:47:27','',''),(2552,'21','222','1',1,'Retail Sale Id 2335',1520.00,0.00,0.00,2.00,0.00,'2022-06-23 12:49:55','',''),(2553,'21','222','1',1,'Retail Sale Id 2336',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 12:51:51','',''),(2554,'21','222','1',1,'Retail Sale Id 2337',8002.80,0.00,0.00,10.53,0.00,'2022-06-23 13:16:40','',''),(2555,'21','222','1',1,'Retail Sale Id 2338',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 13:22:24','',''),(2556,'21','222','1',1,'Retail Sale Id 2339',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 13:31:19','',''),(2557,'21','222','1',1,'Retail Sale Id 2340',3503.60,0.00,0.00,4.61,0.00,'2022-06-23 13:35:39','',''),(2558,'21','222','1',1,'Retail Sale Id 2341',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 13:37:28','',''),(2559,'21','222','1',1,'Retail Sale Id 2342',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 14:06:49','',''),(2560,'21','222','1',1,'Retail Sale Id 2343',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 14:08:31','',''),(2561,'21','222','1',1,'Retail Sale Id 2344',798.00,0.00,0.00,1.05,0.00,'2022-06-23 14:10:16','',''),(2562,'21','222','1',1,'Retail Sale Id 2345',5000.80,0.00,0.00,6.58,0.00,'2022-06-23 14:18:38','',''),(2563,'21','222','1',1,'Retail Sale Id 2346',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 14:20:03','',''),(2564,'21','222','1',1,'Retail Sale Id 2347',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 14:25:49','',''),(2565,'21','222','1',1,'Retail Sale Id 2348',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 14:55:22','',''),(2566,'21','222','1',1,'Retail Sale Id 2349',3503.60,0.00,0.00,4.61,0.00,'2022-06-23 14:56:47','',''),(2567,'21','222','1',1,'Retail Sale Id 2350',2500.40,0.00,0.00,3.29,0.00,'2022-06-23 15:04:01','',''),(2568,'21','222','1',1,'Retail Sale Id 2351',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 15:09:30','',''),(2569,'21','222','1',1,'Retail Sale Id 2352',1520.00,0.00,0.00,2.00,0.00,'2022-06-23 15:26:49','',''),(2570,'21','222','1',1,'Retail Sale Id 2352',1520.00,0.00,0.00,2.00,0.00,'2022-06-23 15:26:49','',''),(2571,'21','222','1',1,'Retail Sale Id 2353',1520.00,0.00,0.00,2.00,0.00,'2022-06-23 15:28:16','',''),(2572,'21','222','1',1,'Retail Sale Id 2354',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 15:30:08','',''),(2573,'21','222','1',1,'Retail Sale Id 2355',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 15:32:36','',''),(2574,'21','222','1',1,'Retail Sale Id 2356',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 15:34:14','',''),(2575,'21','222','1',1,'Retail Sale Id 2357',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 15:35:54','',''),(2576,'21','222','1',1,'Retail Sale Id 2358',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 15:37:26','',''),(2577,'21','222','1',1,'Retail Sale Id 2359',2500.40,0.00,0.00,3.29,0.00,'2022-06-23 15:38:26','',''),(2578,'21','222','1',1,'Retail Sale Id 2360',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 15:55:50','',''),(2579,'21','222','1',1,'Retail Sale Id 2361',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 16:02:02','',''),(2580,'21','222','1',1,'Retail Sale Id 2363',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 16:06:54','',''),(2581,'21','222','1',1,'Retail Sale Id 2364',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 16:11:20','',''),(2582,'21','222','1',1,'Retail Sale Id 2365',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 16:15:24','',''),(2583,'21','222','1',1,'Retail Sale Id 2366',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 16:17:21','',''),(2584,'21','222','1',1,'Retail Sale Id 2367',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 16:19:43','',''),(2585,'21','222','1',1,'Retail Sale Id 2368',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 16:21:15','',''),(2586,'21','222','1',1,'Retail Sale Id 2369',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 16:28:11','',''),(2587,'21','222','1',1,'Retail Sale Id 2370',3997.60,0.00,0.00,5.26,0.00,'2022-06-23 16:29:56','',''),(2588,'21','222','1',1,'Retail Sale Id 2371',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 16:31:28','',''),(2589,'21','222','1',1,'Retail Sale Id 2371',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 16:31:28','',''),(2590,'21','222','1',1,'Retail Sale Id 2372',5700.00,0.00,0.00,7.50,0.00,'2022-06-23 16:37:13','',''),(2591,'21','222','1',1,'Retail Sale Id 2373',8002.80,0.00,0.00,10.53,0.00,'2022-06-23 16:38:24','',''),(2592,'21','222','1',1,'Retail Sale Id 2374',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 16:43:34','',''),(2593,'21','222','1',1,'Retail Sale Id 2375',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 16:48:16','',''),(2594,'21','222','1',1,'Retail Sale Id 2376',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 16:57:11','',''),(2595,'21','222','1',1,'Retail Sale Id 2377',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 16:58:35','',''),(2596,'21','222','1',1,'Retail Sale Id 2378',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 17:00:53','',''),(2597,'21','222','1',1,'Retail Sale Id 2379',2500.40,0.00,0.00,3.29,0.00,'2022-06-23 17:02:13','',''),(2598,'21','222','1',1,'Retail Sale Id 2380',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 17:03:48','',''),(2599,'21','222','1',1,'Retail Sale Id 2381',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 17:10:27','',''),(2600,'21','222','1',1,'Retail Sale Id 2382',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 17:15:47','',''),(2601,'21','222','1',1,'Retail Sale Id 2383',8002.80,0.00,0.00,10.53,0.00,'2022-06-23 17:16:44','',''),(2602,'21','222','1',1,'Retail Sale Id 2384',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 17:19:16','',''),(2603,'21','222','1',1,'Retail Sale Id 2385',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 17:23:03','',''),(2604,'21','222','1',1,'Retail Sale Id 2386',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 17:32:24','',''),(2605,'21','222','1',1,'Retail Sale Id 2387',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 17:37:48','',''),(2606,'21','222','1',1,'Retail Sale Id 2388',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 17:38:33','',''),(2607,'21','222','1',1,'Retail Sale Id 2389',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 17:40:53','',''),(2608,'21','222','1',1,'Retail Sale Id 2390',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 17:42:00','',''),(2609,'21','222','1',1,'Retail Sale Id 2391',3997.60,0.00,0.00,5.26,0.00,'2022-06-23 17:45:06','',''),(2610,'21','222','1',1,'Retail Sale Id 2392',3503.60,0.00,0.00,4.61,0.00,'2022-06-23 17:46:24','',''),(2611,'21','222','1',1,'Retail Sale Id 2393',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 17:47:20','',''),(2612,'21','222','1',1,'Retail Sale Id 2394',1003.20,0.00,0.00,1.32,0.00,'2022-06-23 17:48:22','',''),(2613,'21','222','1',1,'Retail Sale Id 2395',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 17:49:37','',''),(2614,'21','222','1',1,'Retail Sale Id 2396',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 17:51:36','',''),(2615,'21','222','1',1,'Retail Sale Id 2397',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 17:52:32','',''),(2616,'21','222','1',1,'Retail Sale Id 2398',3002.00,0.00,0.00,3.95,0.00,'2022-06-23 17:54:15','',''),(2617,'21','222','1',1,'Retail Sale Id 2399',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 17:55:03','',''),(2618,'21','222','1',1,'Retail Sale Id 2400',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 17:59:15','',''),(2619,'21','222','1',1,'Retail Sale Id 2401',5996.40,0.00,0.00,7.89,0.00,'2022-06-23 18:09:46','',''),(2620,'21','222','1',1,'Retail Sale Id 2402',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 18:17:36','',''),(2621,'21','222','1',1,'Retail Sale Id 2403',3503.60,0.00,0.00,4.61,0.00,'2022-06-23 18:19:49','',''),(2622,'21','222','1',1,'Retail Sale Id 2403',5996.40,0.00,0.00,7.89,0.00,'2022-06-23 18:19:49','',''),(2623,'21','222','1',1,'Retail Sale Id 2403',5996.40,0.00,0.00,7.89,0.00,'2022-06-23 18:19:49','',''),(2624,'21','222','1',1,'Retail Sale Id 2404',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 18:22:51','',''),(2625,'21','222','1',1,'Retail Sale Id 2405',4499.20,0.00,0.00,5.92,0.00,'2022-06-23 18:24:04','',''),(2626,'21','222','1',1,'Retail Sale Id 2406',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 18:25:23','',''),(2627,'21','222','1',1,'Retail Sale Id 2407',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 18:26:27','',''),(2628,'21','222','1',1,'Retail Sale Id 2407',1497.20,0.00,0.00,1.97,0.00,'2022-06-23 18:26:27','',''),(2629,'21','222','1',1,'Retail Sale Id 2408',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 18:27:15','',''),(2630,'21','222','1',1,'Retail Sale Id 2409',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 18:28:43','',''),(2631,'21','222','1',1,'Retail Sale Id 2410',1003.20,0.00,0.00,1.32,0.00,'2022-06-23 18:29:10','',''),(2632,'21','222','1',1,'Retail Sale Id 2411',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 18:30:52','',''),(2633,'21','222','1',1,'Retail Sale Id 2412',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 18:32:20','',''),(2634,'21','222','1',1,'Retail Sale Id 2413',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 18:33:46','',''),(2635,'21','222','1',1,'Retail Sale Id 2414',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 18:36:26','',''),(2636,'21','222','1',1,'Retail Sale Id 2415',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:37:12','',''),(2637,'21','222','1',1,'Retail Sale Id 2416',38000.00,0.00,0.00,50.00,0.00,'2022-06-23 18:37:45','',''),(2638,'21','222','1',1,'Retail Sale Id 2417',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:39:02','',''),(2639,'21','222','1',1,'Retail Sale Id 2418',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:40:08','',''),(2640,'21','222','1',1,'Retail Sale Id 2419',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 18:44:33','',''),(2641,'21','222','1',1,'Retail Sale Id 2420',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 18:50:10','',''),(2642,'21','222','1',1,'Retail Sale Id 2421',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 19:01:12','',''),(2643,'21','222','1',1,'Retail Sale Id 2422',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 19:02:26','',''),(2644,'21','222','1',1,'Retail Sale Id 2423',3997.60,0.00,0.00,5.26,0.00,'2022-06-23 19:03:28','',''),(2645,'21','222','1',1,'Retail Sale Id 2424',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 19:04:15','',''),(2646,'21','222','1',1,'Retail Sale Id 2425',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 19:06:31','',''),(2647,'21','222','1',1,'Retail Sale Id 2426',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 19:09:01','',''),(2648,'21','222','1',1,'Retail Sale Id 2427',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 19:09:56','',''),(2649,'21','222','1',1,'Retail Sale Id 2428',1998.80,0.00,0.00,2.63,0.00,'2022-06-23 19:10:50','',''),(2650,'21','222','1',1,'Retail Sale Id 2429',3503.60,0.00,0.00,4.61,0.00,'2022-06-23 19:11:46','',''),(2651,'21','222','1',1,'Retail Sale Id 2430',15200.00,0.00,0.00,20.00,0.00,'2022-06-23 19:12:40','',''),(2652,'21','222','1',1,'Retail Sale Id 2431',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 19:16:13','',''),(2653,'21','222','1',1,'Retail Sale Id 2432',3002.00,0.00,0.00,3.95,0.00,'2022-06-23 19:20:16','',''),(2654,'21','222','1',1,'Retail Sale Id 2433',2280.00,0.00,0.00,3.00,0.00,'2022-06-23 19:26:00','',''),(2655,'21','222','1',1,'Retail Sale Id 2434',3800.00,0.00,0.00,5.00,0.00,'2022-06-23 19:27:57','',''),(2656,'21','222','1',1,'Retail Sale Id 2435',1520.00,0.00,0.00,2.00,0.00,'2022-06-23 19:38:11','',''),(2657,'21','222','1',1,'Retail Sale Id 2436',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 19:40:09','',''),(2658,'21','222','1',1,'Retail Sale Id 2437',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 19:45:58','',''),(2659,'21','222','1',1,'Retail Sale Id 2438',1003.20,0.00,0.00,1.32,0.00,'2022-06-23 19:48:45','',''),(2660,'21','222','1',1,'Retail Sale Id 2439',2500.40,0.00,0.00,3.29,0.00,'2022-06-23 19:51:24','',''),(2661,'21','222','1',1,'Retail Sale Id 2440',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 19:54:18','',''),(2662,'21','222','1',1,'Retail Sale Id 2441',4560.00,0.00,0.00,6.00,0.00,'2022-06-23 19:56:10','',''),(2663,'21','222','1',1,'Retail Sale Id 2442',38000.00,0.00,0.00,50.00,0.00,'2022-06-23 20:42:04','',''),(2664,'21','222','1',1,'Retail Sale Id 2443',38000.00,0.00,0.00,50.00,0.00,'2022-06-23 20:42:42','',''),(2665,'21','222','1',1,'Retail Sale Id 2444',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 20:43:24','',''),(2666,'21','222','1',1,'Retail Sale Id 2445',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 20:44:28','',''),(2667,'21','222','1',1,'Retail Sale Id 2445',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 20:44:28','',''),(2668,'21','222','1',1,'Retail Sale Id 2445',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 20:44:28','',''),(2669,'21','222','1',1,'Retail Sale Id 2446',15200.00,0.00,0.00,20.00,0.00,'2022-06-23 20:45:03','',''),(2670,'21','222','1',1,'Retail Sale Id 2447',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 20:45:41','',''),(2671,'21','222','1',1,'Retail Sale Id 2448',7600.00,0.00,0.00,10.00,0.00,'2022-06-23 20:46:19','',''),(2672,'21','222','1',1,'Retail Sale Id 2449',9500.00,0.00,0.00,12.50,0.00,'2022-06-23 20:46:55','',''),(2673,'21','222','1',1,'Retail Sale Id 2450',3617.60,0.00,0.00,4.76,0.00,'2022-06-23 20:47:55','',''),(2674,'21','222','1',1,'Retail Sale Id 2451',38000.00,0.00,0.00,50.00,0.00,'2022-06-24 12:43:25','',''),(2675,'21','222','1',1,'Retail Sale Id 2452',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 12:45:01','',''),(2676,'21','222','1',1,'Retail Sale Id 2453',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 12:54:35','',''),(2677,'21','222','1',1,'Retail Sale Id 2454',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 12:56:12','',''),(2678,'21','222','1',1,'Retail Sale Id 2455',38000.00,0.00,0.00,50.00,0.00,'2022-06-24 12:57:58','',''),(2679,'21','222','1',1,'Retail Sale Id 2456',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 13:00:29','',''),(2680,'21','222','1',1,'Retail Sale Id 2457',74001.20,0.00,0.00,97.37,0.00,'2022-06-24 13:04:26','',''),(2681,'21','222','1',1,'Retail Sale Id 2458',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 13:05:53','',''),(2682,'21','222','1',1,'Retail Sale Id 2459',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 13:22:18','',''),(2683,'21','222','1',1,'Retail Sale Id 2460',4560.00,0.00,0.00,6.00,0.00,'2022-06-24 13:24:00','',''),(2684,'21','222','1',1,'Retail Sale Id 2462',4560.00,0.00,0.00,6.00,0.00,'2022-06-24 13:30:45','',''),(2685,'21','222','1',1,'Retail Sale Id 2463',1003.20,0.00,0.00,1.32,0.00,'2022-06-24 13:33:41','',''),(2686,'21','222','1',1,'Retail Sale Id 2464',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 13:39:25','',''),(2687,'21','222','1',1,'Retail Sale Id 2466',3040.00,0.00,0.00,4.00,0.00,'2022-06-24 13:47:08','',''),(2688,'21','222','1',1,'Retail Sale Id 2468',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 13:48:52','',''),(2689,'21','222','1',1,'Retail Sale Id 2469',1520.00,0.00,0.00,2.00,0.00,'2022-06-24 13:50:26','',''),(2690,'21','222','1',1,'Retail Sale Id 2470',5852.00,0.00,0.00,7.70,0.00,'2022-06-24 13:59:04','',''),(2691,'21','222','1',1,'Retail Sale Id 2471',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 14:02:45','',''),(2692,'21','222','1',1,'Retail Sale Id 2473',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 14:05:34','',''),(2693,'21','222','1',1,'Retail Sale Id 2474',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 14:13:53','',''),(2694,'21','222','1',1,'Retail Sale Id 2475',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 14:16:30','',''),(2695,'21','222','1',1,'Retail Sale Id 2476',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 14:18:33','',''),(2696,'21','222','1',1,'Retail Sale Id 2477',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 14:20:25','',''),(2697,'21','222','1',1,'Retail Sale Id 2478',8998.40,0.00,0.00,11.84,0.00,'2022-06-24 14:22:39','',''),(2698,'21','222','1',1,'Retail Sale Id 2479',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 14:24:45','',''),(2699,'21','222','1',1,'Retail Sale Id 2480',8002.80,0.00,0.00,10.53,0.00,'2022-06-24 14:27:46','',''),(2700,'21','222','1',1,'Retail Sale Id 2481',4560.00,0.00,0.00,6.00,0.00,'2022-06-24 14:29:45','',''),(2701,'21','222','1',1,'Retail Sale Id 2482',4560.00,0.00,0.00,6.00,0.00,'2022-06-24 14:31:51','',''),(2702,'21','222','1',1,'Retail Sale Id 2483',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 14:35:21','',''),(2703,'21','222','1',1,'Retail Sale Id 2484',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 14:37:04','',''),(2704,'21','222','1',1,'Retail Sale Id 2485',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 14:38:44','',''),(2705,'21','222','1',1,'Retail Sale Id 2486',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 14:42:19','',''),(2706,'21','222','1',1,'Retail Sale Id 2487',4560.00,0.00,0.00,6.00,0.00,'2022-06-24 14:44:39','',''),(2707,'21','222','1',1,'Retail Sale Id 2488',9120.00,0.00,0.00,12.00,0.00,'2022-06-24 15:04:57','',''),(2708,'21','222','1',1,'Retail Sale Id 2489',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 15:08:39','',''),(2709,'21','222','1',1,'Retail Sale Id 2491',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 15:17:21','',''),(2710,'21','222','1',1,'Retail Sale Id 2493',20520.00,0.00,0.00,27.00,0.00,'2022-06-24 15:25:36','',''),(2711,'21','222','1',1,'Retail Sale Id 2494',3040.00,0.00,0.00,4.00,0.00,'2022-06-24 15:29:22','',''),(2712,'21','222','1',1,'Retail Sale Id 2495',2500.40,0.00,0.00,3.29,0.00,'2022-06-24 15:34:02','',''),(2713,'21','222','1',1,'Retail Sale Id 2497',2500.40,0.00,0.00,3.29,0.00,'2022-06-24 15:38:36','',''),(2714,'21','222','1',1,'Retail Sale Id 2498',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 16:08:46','',''),(2715,'21','222','1',1,'Retail Sale Id 2499',5996.40,0.00,0.00,7.89,0.00,'2022-06-24 16:10:43','',''),(2716,'21','222','1',1,'Retail Sale Id 2500',22002.00,0.00,0.00,28.95,0.00,'2022-06-24 16:16:57','',''),(2717,'21','222','1',1,'Retail Sale Id 2501',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 16:24:18','',''),(2718,'21','222','1',1,'Retail Sale Id 2502',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 16:33:54','',''),(2719,'21','222','1',1,'Retail Sale Id 2503',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 16:35:51','',''),(2720,'21','222','1',1,'Retail Sale Id 2505',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 16:46:09','',''),(2721,'21','222','1',1,'Retail Sale Id 2506',38000.00,0.00,0.00,50.00,0.00,'2022-06-24 17:14:43','',''),(2722,'21','222','1',1,'Retail Sale Id 2507',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 17:44:23','',''),(2723,'21','222','1',1,'Retail Sale Id 2508',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 17:45:57','',''),(2724,'21','222','1',1,'Retail Sale Id 2509',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 17:49:29','',''),(2725,'21','222','1',1,'Retail Sale Id 2510',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 18:01:54','',''),(2726,'21','222','1',1,'Retail Sale Id 2511',5000.80,0.00,0.00,6.58,0.00,'2022-06-24 18:04:10','',''),(2727,'21','222','1',1,'Retail Sale Id 2513',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 18:06:06','',''),(2728,'21','222','1',1,'Retail Sale Id 2515',1299.60,0.00,0.00,1.71,0.00,'2022-06-24 18:08:47','',''),(2729,'21','222','1',1,'Retail Sale Id 2516',3997.60,0.00,0.00,5.26,0.00,'2022-06-24 18:10:06','',''),(2730,'21','222','1',1,'Retail Sale Id 2517',798.00,0.00,0.00,1.05,0.00,'2022-06-24 18:11:51','',''),(2731,'21','222','1',1,'Retail Sale Id 2519',5000.80,0.00,0.00,6.58,0.00,'2022-06-24 18:14:42','',''),(2732,'21','222','1',1,'Retail Sale Id 2520',5320.00,0.00,0.00,7.00,0.00,'2022-06-24 18:19:05','',''),(2733,'21','222','1',1,'Retail Sale Id 2521',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 18:23:28','',''),(2734,'21','222','1',1,'Retail Sale Id 2522',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 18:24:55','',''),(2735,'21','222','1',1,'Retail Sale Id 2523',2280.00,0.00,0.00,3.00,0.00,'2022-06-24 18:27:01','',''),(2736,'21','222','1',1,'Retail Sale Id 2524',15200.00,0.00,0.00,20.00,0.00,'2022-06-24 18:29:19','',''),(2737,'21','222','1',1,'Retail Sale Id 2525',4560.00,0.00,0.00,6.00,0.00,'2022-06-24 18:31:57','',''),(2738,'21','222','1',1,'Retail Sale Id 2526',2280.00,0.00,0.00,3.00,0.00,'2022-06-24 18:34:06','',''),(2739,'21','222','1',1,'Retail Sale Id 2527',3997.60,0.00,0.00,5.26,0.00,'2022-06-24 18:36:07','',''),(2740,'21','222','1',1,'Retail Sale Id 2528',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 18:38:05','',''),(2741,'21','222','1',1,'Retail Sale Id 2529',3800.00,0.00,0.00,5.00,0.00,'2022-06-24 18:39:29','',''),(2742,'21','222','1',1,'Retail Sale Id 2530',1998.80,0.00,0.00,2.63,0.00,'2022-06-24 18:42:05','',''),(2743,'21','222','1',1,'Retail Sale Id 2531',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 18:44:22','',''),(2744,'21','222','1',1,'Retail Sale Id 2532',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 18:46:54','',''),(2745,'21','222','1',1,'Retail Sale Id 2533',9500.00,0.00,0.00,12.50,0.00,'2022-06-24 18:56:11','',''),(2746,'21','222','1',1,'Retail Sale Id 2534',11400.00,0.00,0.00,15.00,0.00,'2022-06-24 18:58:52','',''),(2747,'21','222','1',1,'Retail Sale Id 2535',4750.00,0.00,0.00,6.25,0.00,'2022-06-24 19:02:17','',''),(2748,'21','222','1',1,'Retail Sale Id 2536',4096.40,0.00,0.00,5.39,0.00,'2022-06-24 19:08:38','',''),(2749,'21','222','1',1,'Retail Sale Id 2537',6999.60,0.00,0.00,9.21,0.00,'2022-06-24 19:12:46','',''),(2750,'21','222','1',1,'Retail Sale Id 2538',4560.00,0.00,0.00,6.00,0.00,'2022-06-24 19:14:50','',''),(2751,'21','222','1',1,'Retail Sale Id 2539',38000.00,0.00,0.00,50.00,0.00,'2022-06-24 20:22:38','',''),(2752,'21','222','1',1,'Retail Sale Id 2540',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 20:23:59','',''),(2753,'21','222','1',1,'Retail Sale Id 2541',38000.00,0.00,0.00,50.00,0.00,'2022-06-24 20:25:41','',''),(2754,'21','222','1',1,'Retail Sale Id 2542',26600.00,0.00,0.00,35.00,0.00,'2022-06-24 20:27:35','',''),(2755,'21','222','1',1,'Retail Sale Id 2543',19000.00,0.00,0.00,25.00,0.00,'2022-06-24 20:29:00','',''),(2756,'21','222','1',1,'Retail Sale Id 2544',11947.20,0.00,0.00,15.72,0.00,'2022-06-24 20:31:12','',''),(2757,'21','222','1',1,'Retail Sale Id 2545',1702.40,0.00,0.00,2.24,0.00,'2022-06-25 07:43:42','',''),(2758,'21','222','1',1,'Retail Sale Id 2546',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 07:47:49','',''),(2759,'21','222','1',1,'Retail Sale Id 2548',6498.00,0.00,0.00,8.55,0.00,'2022-06-25 07:49:44','',''),(2760,'21','222','1',1,'Retail Sale Id 2549',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 07:59:02','',''),(2761,'21','222','1',1,'Retail Sale Id 2549',8998.40,0.00,0.00,11.84,0.00,'2022-06-25 07:59:02','',''),(2762,'21','222','1',1,'Retail Sale Id 2550',6840.00,0.00,0.00,9.00,0.00,'2022-06-25 08:06:55','',''),(2763,'21','222','1',1,'Retail Sale Id 2551',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 08:17:47','',''),(2764,'21','222','1',1,'Retail Sale Id 2552',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 08:35:02','',''),(2765,'21','222','1',1,'Retail Sale Id 2553',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 08:36:19','',''),(2766,'21','222','1',1,'Retail Sale Id 2554',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 08:48:32','',''),(2767,'21','222','1',1,'Retail Sale Id 2555',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 08:51:01','',''),(2768,'21','222','1',1,'Retail Sale Id 2556',2500.40,0.00,0.00,3.29,0.00,'2022-06-25 08:51:57','',''),(2769,'21','222','1',1,'Retail Sale Id 2557',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 08:53:54','',''),(2770,'21','222','1',1,'Retail Sale Id 2558',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 08:55:07','',''),(2771,'21','222','1',1,'Retail Sale Id 2559',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 08:57:26','',''),(2772,'21','222','1',1,'Retail Sale Id 2560',3002.00,0.00,0.00,3.95,0.00,'2022-06-25 09:03:43','',''),(2773,'21','222','1',1,'Retail Sale Id 2560',6999.60,0.00,0.00,9.21,0.00,'2022-06-25 09:03:43','',''),(2774,'21','222','1',1,'Retail Sale Id 2561',1497.20,0.00,0.00,1.97,0.00,'2022-06-25 09:10:13','',''),(2775,'21','222','1',1,'Retail Sale Id 2561',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 09:10:13','',''),(2776,'21','222','1',1,'Retail Sale Id 2562',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 09:13:00','',''),(2777,'21','222','1',1,'Retail Sale Id 2563',8998.40,0.00,0.00,11.84,0.00,'2022-06-25 09:14:05','',''),(2778,'21','222','1',1,'Retail Sale Id 2564',699.20,0.00,0.00,0.92,0.00,'2022-06-25 09:15:18','',''),(2779,'21','222','1',1,'Retail Sale Id 2565',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 09:17:02','',''),(2780,'21','222','1',1,'Retail Sale Id 2565',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:17:02','',''),(2781,'21','222','1',1,'Retail Sale Id 2566',3002.00,0.00,0.00,3.95,0.00,'2022-06-25 09:25:44','',''),(2782,'21','222','1',1,'Retail Sale Id 2566',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:25:44','',''),(2783,'21','222','1',1,'Retail Sale Id 2567',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:27:12','',''),(2784,'21','222','1',1,'Retail Sale Id 2568',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:35:44','',''),(2785,'21','222','1',1,'Retail Sale Id 2569',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:38:52','',''),(2786,'21','222','1',1,'Retail Sale Id 2569',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:38:52','',''),(2787,'21','222','1',1,'Retail Sale Id 2570',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 09:40:02','',''),(2788,'21','222','1',1,'Retail Sale Id 2571',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 09:44:27','',''),(2789,'21','222','1',1,'Retail Sale Id 2572',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:46:22','',''),(2790,'21','222','1',1,'Retail Sale Id 2573',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:47:31','',''),(2791,'21','222','1',1,'Retail Sale Id 2574',3002.00,0.00,0.00,3.95,0.00,'2022-06-25 09:48:57','',''),(2792,'21','222','1',1,'Retail Sale Id 2575',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 09:53:16','',''),(2793,'21','222','1',1,'Retail Sale Id 2576',1497.20,0.00,0.00,1.97,0.00,'2022-06-25 09:54:15','',''),(2794,'21','222','1',1,'Retail Sale Id 2577',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:55:27','',''),(2795,'21','222','1',1,'Retail Sale Id 2578',8998.40,0.00,0.00,11.84,0.00,'2022-06-25 09:56:44','',''),(2796,'21','222','1',1,'Retail Sale Id 2579',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 09:58:31','',''),(2797,'21','222','1',1,'Retail Sale Id 2580',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 10:00:27','',''),(2798,'21','222','1',1,'Retail Sale Id 2581',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:03:55','',''),(2799,'21','222','1',1,'Retail Sale Id 2582',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:14:06','',''),(2800,'21','222','1',1,'Retail Sale Id 2582',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:14:06','',''),(2801,'21','222','1',1,'Retail Sale Id 2583',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:15:43','',''),(2802,'21','222','1',1,'Retail Sale Id 2584',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:18:38','',''),(2803,'21','222','1',1,'Retail Sale Id 2585',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 10:21:35','',''),(2804,'21','222','1',1,'Retail Sale Id 2586',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:23:17','',''),(2805,'21','222','1',1,'Retail Sale Id 2587',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 10:26:14','',''),(2806,'21','222','1',1,'Retail Sale Id 2588',1497.20,0.00,0.00,1.97,0.00,'2022-06-25 10:27:17','',''),(2807,'21','222','1',1,'Retail Sale Id 2589',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 10:27:53','',''),(2808,'21','222','1',1,'Retail Sale Id 2590',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 10:35:50','',''),(2809,'21','222','1',1,'Retail Sale Id 2590',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:35:50','',''),(2810,'21','222','1',1,'Retail Sale Id 2591',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:41:28','',''),(2811,'21','222','1',1,'Retail Sale Id 2592',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:42:32','',''),(2812,'21','222','1',1,'Retail Sale Id 2592',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 10:42:32','',''),(2813,'21','222','1',1,'Retail Sale Id 2593',8360.00,0.00,0.00,11.00,0.00,'2022-06-25 10:48:15','',''),(2814,'21','222','1',1,'Retail Sale Id 2594',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 10:51:04','',''),(2815,'21','222','1',1,'Retail Sale Id 2595',1003.20,0.00,0.00,1.32,0.00,'2022-06-25 10:52:19','',''),(2816,'21','222','1',1,'Retail Sale Id 2596',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 10:55:50','',''),(2817,'21','222','1',1,'Return of Retail Sale Id 2596',0.00,1998.80,2.63,0.00,0.00,'2022-06-25 10:56:21','',''),(2818,'21','222','1',1,'Retail Sale Id 2597',7600.00,0.00,0.00,10.00,0.00,'2022-06-25 11:09:23','',''),(2819,'21','222','1',1,'Retail Sale Id 2598',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 11:11:50','',''),(2820,'21','222','1',1,'Retail Sale Id 2599',5000.80,0.00,0.00,6.58,0.00,'2022-06-25 11:13:00','',''),(2821,'21','222','1',1,'Retail Sale Id 2600',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 11:16:16','',''),(2822,'21','222','1',1,'Retail Sale Id 2601',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 11:21:58','',''),(2823,'21','222','1',1,'Retail Sale Id 2602',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 11:23:22','',''),(2824,'21','222','1',1,'Retail Sale Id 2602',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 11:23:22','',''),(2825,'21','222','1',1,'Retail Sale Id 2602',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 11:23:22','',''),(2826,'21','222','1',1,'Retail Sale Id 2603',4750.00,0.00,0.00,6.25,0.00,'2022-06-25 11:25:01','',''),(2827,'21','222','1',1,'Retail Sale Id 2604',1200.80,0.00,0.00,1.58,0.00,'2022-06-25 11:28:27','',''),(2828,'21','222','1',1,'Retail Sale Id 2605',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 11:34:42','',''),(2829,'21','222','1',1,'Retail Sale Id 2605',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 11:34:42','',''),(2830,'21','222','1',1,'Retail Sale Id 2606',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 11:38:27','',''),(2831,'21','222','1',1,'Return of Retail Sale Id 2601',0.00,9500.00,12.50,0.00,0.00,'2022-06-25 11:53:45','',''),(2832,'21','222','1',1,'Return of Retail Sale Id 2604',0.00,1200.80,1.58,0.00,0.00,'2022-06-25 11:55:33','',''),(2833,'21','222','1',1,'Return of Retail Sale Id 2606',0.00,9500.00,12.50,0.00,0.00,'2022-06-25 11:56:20','',''),(2834,'21','222','1',1,'Return of Retail Sale Id 2605',0.00,2280.00,3.00,0.00,0.00,'2022-06-25 11:58:03','',''),(2835,'21','222','1',1,'Return of Retail Sale Id 2605',0.00,4560.00,6.00,0.00,0.00,'2022-06-25 11:58:03','',''),(2836,'21','222','1',1,'Retail Sale Id 2607',3002.00,0.00,0.00,3.95,0.00,'2022-06-25 15:22:22','',''),(2837,'21','222','1',1,'Retail Sale Id 2608',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 15:23:35','',''),(2838,'21','222','1',1,'Retail Sale Id 2609',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 15:24:32','',''),(2839,'21','222','1',1,'Retail Sale Id 2610',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 15:25:23','',''),(2840,'21','222','1',1,'Retail Sale Id 2611',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 15:27:04','',''),(2841,'21','222','1',1,'Retail Sale Id 2612',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 15:27:55','',''),(2842,'21','222','1',1,'Retail Sale Id 2613',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 15:28:59','',''),(2843,'21','222','1',1,'Retail Sale Id 2614',4202.80,0.00,0.00,5.53,0.00,'2022-06-25 15:30:01','',''),(2844,'21','222','1',1,'Retail Sale Id 2615',3997.60,0.00,0.00,5.26,0.00,'2022-06-25 15:30:41','',''),(2845,'21','222','1',1,'Retail Sale Id 2616',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 15:32:21','',''),(2846,'21','222','1',1,'Retail Sale Id 2616',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 15:32:21','',''),(2847,'21','222','1',1,'Retail Sale Id 2617',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 15:34:00','',''),(2848,'21','222','1',1,'Retail Sale Id 2618',3002.00,0.00,0.00,3.95,0.00,'2022-06-25 15:35:07','',''),(2849,'21','222','1',1,'Retail Sale Id 2619',1003.20,0.00,0.00,1.32,0.00,'2022-06-25 15:36:30','',''),(2850,'21','222','1',1,'Retail Sale Id 2620',6999.60,0.00,0.00,9.21,0.00,'2022-06-25 15:37:37','',''),(2851,'21','222','1',1,'Retail Sale Id 2621',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 15:38:26','',''),(2852,'21','222','1',1,'Retail Sale Id 2622',8002.80,0.00,0.00,10.53,0.00,'2022-06-25 15:39:34','',''),(2853,'21','222','1',1,'Retail Sale Id 2623',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 15:40:13','',''),(2854,'21','222','1',1,'Retail Sale Id 2624',6300.40,0.00,0.00,8.29,0.00,'2022-06-25 15:41:23','',''),(2855,'21','222','1',1,'Retail Sale Id 2625',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 15:42:31','',''),(2856,'21','222','1',1,'Retail Sale Id 2626',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 15:43:23','',''),(2857,'21','222','1',1,'Retail Sale Id 2627',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 15:44:38','',''),(2858,'21','222','1',1,'Retail Sale Id 2628',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 15:46:40','',''),(2859,'21','222','1',1,'Retail Sale Id 2629',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 15:47:42','',''),(2860,'21','222','1',1,'Retail Sale Id 2630',7600.00,0.00,0.00,10.00,0.00,'2022-06-25 15:48:26','',''),(2861,'21','222','1',1,'Retail Sale Id 2631',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 15:49:46','',''),(2862,'21','222','1',1,'Retail Sale Id 2632',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 15:51:08','',''),(2863,'21','222','1',1,'Retail Sale Id 2632',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 15:51:08','',''),(2864,'21','222','1',1,'Retail Sale Id 2633',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 15:53:39','',''),(2865,'21','222','1',1,'Retail Sale Id 2634',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 15:54:39','',''),(2866,'21','222','1',1,'Retail Sale Id 2635',1520.00,0.00,0.00,2.00,0.00,'2022-06-25 15:56:01','',''),(2867,'21','222','1',1,'Retail Sale Id 2635',1520.00,0.00,0.00,2.00,0.00,'2022-06-25 15:56:01','',''),(2868,'21','222','1',1,'Retail Sale Id 2636',1003.20,0.00,0.00,1.32,0.00,'2022-06-25 15:57:16','',''),(2869,'21','222','1',1,'Retail Sale Id 2637',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 15:58:00','',''),(2870,'21','222','1',1,'Retail Sale Id 2638',5996.40,0.00,0.00,7.89,0.00,'2022-06-25 15:59:33','',''),(2871,'21','222','1',1,'Retail Sale Id 2639',1520.00,0.00,0.00,2.00,0.00,'2022-06-25 16:02:35','',''),(2872,'21','222','1',1,'Retail Sale Id 2640',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 16:03:55','',''),(2873,'21','222','1',1,'Retail Sale Id 2642',1520.00,0.00,0.00,2.00,0.00,'2022-06-25 16:06:00','',''),(2874,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-06-25 16:14:14','',''),(2875,'21','222',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,4999.00,0.00,'2022-06-25 16:17:29','',''),(2876,'21','222','1',1,'Received from bridging 18',0.00,0.00,4999.00,0.00,0.00,'2022-06-25 16:17:29','',''),(2877,'21','222','1',1,'Retail Sale Id 2643',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 16:35:09','',''),(2878,'21','222','1',1,'Retail Sale Id 2644',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 16:36:08','',''),(2879,'21','222','1',1,'Retail Sale Id 2645',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 16:37:42','',''),(2880,'21','222','1',1,'Retail Sale Id 2646',5996.40,0.00,0.00,7.89,0.00,'2022-06-25 16:39:33','',''),(2881,'21','222','1',1,'Retail Sale Id 2647',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 16:48:02','',''),(2882,'21','222','1',1,'Retail Sale Id 2648',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 16:53:37','',''),(2883,'21','222','1',1,'Retail Sale Id 2649',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 16:56:18','',''),(2884,'21','222','1',1,'Retail Sale Id 2650',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 16:57:55','',''),(2885,'21','222','1',1,'Retail Sale Id 2650',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 16:57:55','',''),(2886,'21','222','1',1,'Retail Sale Id 2651',3002.00,0.00,0.00,3.95,0.00,'2022-06-25 16:59:51','',''),(2887,'21','222','1',1,'Retail Sale Id 2652',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 17:00:43','',''),(2888,'21','222','1',1,'Retail Sale Id 2653',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 17:03:06','',''),(2889,'21','222','1',1,'Retail Sale Id 2654',3040.00,0.00,0.00,4.00,0.00,'2022-06-25 17:05:37','',''),(2890,'21','222','1',1,'Retail Sale Id 2655',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 17:07:34','',''),(2891,'21','222','1',1,'Retail Sale Id 2655',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 17:07:34','',''),(2892,'21','222','1',1,'Retail Sale Id 2656',1003.20,0.00,0.00,1.32,0.00,'2022-06-25 17:09:40','',''),(2893,'21','222','1',1,'Retail Sale Id 2657',3002.00,0.00,0.00,3.95,0.00,'2022-06-25 17:15:49','',''),(2894,'21','222','1',1,'Retail Sale Id 2658',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 17:18:39','',''),(2895,'21','222','1',1,'Retail Sale Id 2659',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 17:20:50','',''),(2896,'21','222','1',1,'Retail Sale Id 2660',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 17:27:45','',''),(2897,'21','222','1',1,'Retail Sale Id 2661',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 17:30:11','',''),(2898,'21','222','1',1,'Retail Sale Id 2662',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 17:31:32','',''),(2899,'21','222','1',1,'Retail Sale Id 2663',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 17:33:30','',''),(2900,'21','222','1',1,'Retail Sale Id 2664',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 17:35:07','',''),(2901,'21','222','1',1,'Retail Sale Id 2665',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 17:38:02','',''),(2902,'21','222','1',1,'Retail Sale Id 2665',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 17:38:02','',''),(2903,'21','222','1',1,'Retail Sale Id 2666',7600.00,0.00,0.00,10.00,0.00,'2022-06-25 17:40:32','',''),(2904,'21','222','1',1,'Retail Sale Id 2667',3800.00,0.00,0.00,5.00,0.00,'2022-06-25 17:45:53','',''),(2905,'21','222','1',1,'Retail Sale Id 2668',1520.00,0.00,0.00,2.00,0.00,'2022-06-25 17:51:50','',''),(2906,'21','222','1',1,'Retail Sale Id 2668',1520.00,0.00,0.00,2.00,0.00,'2022-06-25 17:51:50','',''),(2907,'21','222','1',1,'Retail Sale Id 2669',1998.80,0.00,0.00,2.63,0.00,'2022-06-25 17:59:54','',''),(2908,'21','222','1',1,'Retail Sale Id 2670',38000.00,0.00,0.00,50.00,0.00,'2022-06-25 18:01:50','',''),(2909,'21','222','1',1,'Retail Sale Id 2671',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 19:09:13','',''),(2910,'21','222','1',1,'Retail Sale Id 2672',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 19:10:20','',''),(2911,'21','222','1',1,'Retail Sale Id 2673',1520.00,0.00,0.00,2.00,0.00,'2022-06-25 19:13:18','',''),(2912,'21','222','1',1,'Retail Sale Id 2674',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 19:15:04','',''),(2913,'21','222','1',1,'Retail Sale Id 2675',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 19:20:12','',''),(2914,'21','222','1',1,'Retail Sale Id 2676',5000.80,0.00,0.00,6.58,0.00,'2022-06-25 19:26:43','',''),(2915,'21','222','1',1,'Retail Sale Id 2677',10001.60,0.00,0.00,13.16,0.00,'2022-06-25 19:28:57','',''),(2916,'21','222','1',1,'Retail Sale Id 2678',4560.00,0.00,0.00,6.00,0.00,'2022-06-25 19:30:04','',''),(2917,'21','222','1',1,'Retail Sale Id 2679',2280.00,0.00,0.00,3.00,0.00,'2022-06-25 19:31:03','',''),(2918,'21','222','1',1,'Retail Sale Id 2680',19000.00,0.00,0.00,25.00,0.00,'2022-06-25 20:18:03','',''),(2919,'21','222','1',1,'Retail Sale Id 2681',38000.00,0.00,0.00,50.00,0.00,'2022-06-25 20:58:44','',''),(2920,'21','222','1',1,'Retail Sale Id 2682',38000.00,0.00,0.00,50.00,0.00,'2022-06-25 20:59:20','',''),(2921,'21','222','1',1,'Retail Sale Id 2683',15200.00,0.00,0.00,20.00,0.00,'2022-06-25 20:59:44','',''),(2922,'21','222','1',1,'Retail Sale Id 2684',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 21:00:28','',''),(2923,'21','222','1',1,'Retail Sale Id 2684',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 21:00:28','',''),(2924,'21','222','1',1,'Retail Sale Id 2685',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 21:01:07','',''),(2925,'21','222','1',1,'Retail Sale Id 2685',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 21:01:07','',''),(2926,'21','222','1',1,'Retail Sale Id 2686',7600.00,0.00,0.00,10.00,0.00,'2022-06-25 21:01:51','',''),(2927,'21','222','1',1,'Retail Sale Id 2687',7600.00,0.00,0.00,10.00,0.00,'2022-06-25 21:02:26','',''),(2928,'21','222','1',1,'Retail Sale Id 2688',9500.00,0.00,0.00,12.50,0.00,'2022-06-25 21:03:20','',''),(2929,'21','222','1',1,'Retail Sale Id 2689',2021.60,0.00,0.00,2.66,0.00,'2022-06-25 21:04:06','',''),(2930,'21','222','1',1,'Retail Sale Id 2690',1200.80,0.00,0.00,1.58,0.00,'2022-06-26 08:18:38','',''),(2931,'21','222','1',1,'Retail Sale Id 2690',1200.80,0.00,0.00,1.58,0.00,'2022-06-26 08:18:38','',''),(2932,'21','222','1',1,'Retail Sale Id 2691',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 08:19:10','',''),(2933,'21','222','1',1,'Retail Sale Id 2692',3997.60,0.00,0.00,5.26,0.00,'2022-06-26 08:22:34','',''),(2934,'21','222','1',1,'Retail Sale Id 2693',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 08:23:35','',''),(2935,'21','222','1',1,'Retail Sale Id 2694',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 08:25:38','',''),(2936,'21','222','1',1,'Retail Sale Id 2695',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 08:27:42','',''),(2937,'21','222','1',1,'Retail Sale Id 2696',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 08:28:51','',''),(2938,'21','222','1',1,'Retail Sale Id 2697',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 08:29:50','',''),(2939,'21','222','1',1,'Retail Sale Id 2698',4750.00,0.00,0.00,6.25,0.00,'2022-06-26 08:33:42','',''),(2940,'21','222','1',1,'Retail Sale Id 2699',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 08:38:38','',''),(2941,'21','222','1',1,'Retail Sale Id 2700',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 08:44:21','',''),(2942,'21','222','1',1,'Retail Sale Id 2701',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 08:46:06','',''),(2943,'21','222','1',1,'Retail Sale Id 2702',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 08:57:05','',''),(2944,'21','222','1',1,'Retail Sale Id 2703',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 09:10:40','',''),(2945,'21','222','1',1,'Retail Sale Id 2704',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 09:15:15','',''),(2946,'21','222','1',1,'Retail Sale Id 2705',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 09:17:38','',''),(2947,'21','222','1',1,'Retail Sale Id 2706',6999.60,0.00,0.00,9.21,0.00,'2022-06-26 09:20:45','',''),(2948,'21','222','1',1,'Retail Sale Id 2707',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 09:22:43','',''),(2949,'21','222','1',1,'Retail Sale Id 2708',3503.60,0.00,0.00,4.61,0.00,'2022-06-26 09:23:59','',''),(2950,'21','222','1',1,'Retail Sale Id 2709',19000.00,0.00,0.00,25.00,0.00,'2022-06-26 09:25:43','',''),(2951,'21','222','1',1,'Retail Sale Id 2710',6999.60,0.00,0.00,9.21,0.00,'2022-06-26 09:26:30','',''),(2952,'21','222','1',1,'Retail Sale Id 2711',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 09:28:08','',''),(2953,'21','222','1',1,'Retail Sale Id 2712',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 09:29:22','',''),(2954,'21','222','1',1,'Retail Sale Id 2713',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 09:30:20','',''),(2955,'21','222','1',1,'Retail Sale Id 2714',8496.80,0.00,0.00,11.18,0.00,'2022-06-26 09:32:54','',''),(2956,'21','222','1',1,'Retail Sale Id 2715',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 09:34:59','',''),(2957,'21','222','1',1,'Retail Sale Id 2716',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 09:36:54','',''),(2958,'21','222','1',1,'Retail Sale Id 2717',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 09:43:28','',''),(2959,'21','222','1',1,'Retail Sale Id 2718',5000.80,0.00,0.00,6.58,0.00,'2022-06-26 09:47:51','',''),(2960,'21','222','1',1,'Retail Sale Id 2719',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 09:49:34','',''),(2961,'21','222','1',1,'Retail Sale Id 2720',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 09:52:04','',''),(2962,'21','222','1',1,'Retail Sale Id 2721',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 09:57:42','',''),(2963,'21','222','1',1,'Retail Sale Id 2722',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 09:58:32','',''),(2964,'21','222','1',1,'Retail Sale Id 2723',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 10:00:11','',''),(2965,'21','222','1',1,'Retail Sale Id 2724',3997.60,0.00,0.00,5.26,0.00,'2022-06-26 10:01:01','',''),(2966,'21','222','1',1,'Retail Sale Id 2725',3199.60,0.00,0.00,4.21,0.00,'2022-06-26 10:02:27','',''),(2967,'21','222','1',1,'Retail Sale Id 2726',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:07:04','',''),(2968,'21','222','1',1,'Retail Sale Id 2727',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:11:16','',''),(2969,'21','222','1',1,'Retail Sale Id 2728',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:14:27','',''),(2970,'21','222','1',1,'Retail Sale Id 2729',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 10:16:50','',''),(2971,'21','222','1',1,'Retail Sale Id 2730',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:17:56','',''),(2972,'21','222','1',1,'Retail Sale Id 2731',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 10:18:55','',''),(2973,'21','222','1',1,'Retail Sale Id 2732',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 10:20:19','',''),(2974,'21','222','1',1,'Retail Sale Id 2733',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 10:22:28','',''),(2975,'21','222','1',1,'Retail Sale Id 2734',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 10:25:03','',''),(2976,'21','222','1',1,'Retail Sale Id 2735',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 10:26:06','',''),(2977,'21','222','1',1,'Retail Sale Id 2736',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 10:28:22','',''),(2978,'21','222','1',1,'Retail Sale Id 2737',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:29:40','',''),(2979,'21','222','1',1,'Retail Sale Id 2738',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 10:35:01','',''),(2980,'21','222','1',1,'Retail Sale Id 2739',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:37:32','',''),(2981,'21','222','1',1,'Retail Sale Id 2740',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 10:38:29','',''),(2982,'21','222','1',1,'Retail Sale Id 2741',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 10:39:38','',''),(2983,'21','222','1',1,'Retail Sale Id 2742',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 10:42:59','',''),(2984,'21','222','1',1,'Retail Sale Id 2743',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 10:43:40','',''),(2985,'21','222','1',1,'Retail Sale Id 2744',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:45:33','',''),(2986,'21','222','1',1,'Retail Sale Id 2745',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 10:50:00','',''),(2987,'21','222','1',1,'Retail Sale Id 2746',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 10:51:15','',''),(2988,'21','222','1',1,'Retail Sale Id 2747',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:54:01','',''),(2989,'21','222','1',1,'Retail Sale Id 2748',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:56:05','',''),(2990,'21','222','1',1,'Retail Sale Id 2749',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 10:59:15','',''),(2991,'21','222','1',1,'Retail Sale Id 2750',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 11:00:33','',''),(2992,'21','222','1',1,'Retail Sale Id 2751',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 11:05:15','',''),(2993,'21','222','1',1,'Retail Sale Id 2752',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 11:07:35','',''),(2994,'21','222','1',1,'Retail Sale Id 2752',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 11:07:35','',''),(2995,'21','222','1',1,'Retail Sale Id 2753',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 11:09:23','',''),(2996,'21','222','1',1,'Retail Sale Id 2753',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 11:09:23','',''),(2997,'21','222','1',1,'Retail Sale Id 2754',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 11:14:39','',''),(2998,'21','222','1',1,'Retail Sale Id 2755',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 11:15:49','',''),(2999,'21','222','1',1,'Retail Sale Id 2756',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 11:17:05','',''),(3000,'21','222','1',1,'Retail Sale Id 2758',798.00,0.00,0.00,1.05,0.00,'2022-06-26 11:18:20','',''),(3001,'21','222','1',1,'Retail Sale Id 2759',3997.60,0.00,0.00,5.26,0.00,'2022-06-26 11:19:20','',''),(3002,'21','222','1',1,'Retail Sale Id 2760',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 11:20:47','',''),(3003,'21','222','1',1,'Retail Sale Id 2761',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 11:22:49','',''),(3004,'21','222','1',1,'Retail Sale Id 2762',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 11:23:57','',''),(3005,'21','222','1',1,'Retail Sale Id 2763',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 11:25:54','',''),(3006,'21','222','1',1,'Retail Sale Id 2764',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 11:28:02','',''),(3007,'21','222','1',1,'Retail Sale Id 2764',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 11:28:02','',''),(3008,'21','222','1',1,'Retail Sale Id 2765',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 11:29:13','',''),(3009,'21','222','1',1,'Retail Sale Id 2766',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 11:30:31','',''),(3010,'21','222','1',1,'Retail Sale Id 2767',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 11:31:42','',''),(3011,'21','222','1',1,'Retail Sale Id 2768',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 11:37:56','',''),(3012,'21','222','1',1,'Retail Sale Id 2769',8002.80,0.00,0.00,10.53,0.00,'2022-06-26 11:38:30','',''),(3013,'21','222','1',1,'Retail Sale Id 2770',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 11:42:33','',''),(3014,'21','222','1',1,'Retail Sale Id 2771',1003.20,0.00,0.00,1.32,0.00,'2022-06-26 11:43:26','',''),(3015,'21','222','1',1,'Retail Sale Id 2772',4750.00,0.00,0.00,6.25,0.00,'2022-06-26 11:44:54','',''),(3016,'21','222','1',1,'Retail Sale Id 2773',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 11:45:44','',''),(3017,'21','222','1',1,'Retail Sale Id 2774',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 11:48:45','',''),(3018,'21','222','1',1,'Retail Sale Id 2775',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 12:06:02','',''),(3019,'21','222','1',1,'Retail Sale Id 2776',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 12:09:33','',''),(3020,'21','222','1',1,'Retail Sale Id 2777',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 12:11:11','',''),(3021,'21','222','1',1,'Retail Sale Id 2778',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 12:13:42','',''),(3022,'21','222','1',1,'Retail Sale Id 2779',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 12:16:12','',''),(3023,'21','222','1',1,'Retail Sale Id 2780',38000.00,0.00,0.00,50.00,0.00,'2022-06-26 12:18:02','',''),(3024,'21','222','1',1,'Retail Sale Id 2781',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 12:20:39','',''),(3025,'21','222','1',1,'Retail Sale Id 2782',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 12:23:01','',''),(3026,'21','222','1',1,'Retail Sale Id 2783',8360.00,0.00,0.00,11.00,0.00,'2022-06-26 12:26:02','',''),(3027,'21','222','1',1,'Retail Sale Id 2784',4750.00,0.00,0.00,6.25,0.00,'2022-06-26 12:30:35','',''),(3028,'21','222','1',1,'Retail Sale Id 2785',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 12:35:06','',''),(3029,'21','222','1',1,'Retail Sale Id 2785',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 12:35:06','',''),(3030,'21','222','1',1,'Retail Sale Id 2786',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 12:37:19','',''),(3031,'21','222','1',1,'Retail Sale Id 2787',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 12:39:00','',''),(3032,'21','222','1',1,'Retail Sale Id 2788',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 12:40:20','',''),(3033,'21','222','1',1,'Retail Sale Id 2789',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 12:41:37','',''),(3034,'21','222','1',1,'Retail Sale Id 2790',8998.40,0.00,0.00,11.84,0.00,'2022-06-26 12:43:26','',''),(3035,'21','222','1',1,'Retail Sale Id 2791',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 12:44:51','',''),(3036,'21','222','1',1,'Retail Sale Id 2792',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 12:46:03','',''),(3037,'21','222','1',1,'Retail Sale Id 2793',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 12:48:12','',''),(3038,'21','222','1',1,'Retail Sale Id 2794',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 12:50:19','',''),(3039,'21','222','1',1,'Retail Sale Id 2794',9120.00,0.00,0.00,12.00,0.00,'2022-06-26 12:50:19','',''),(3040,'21','222','1',1,'Retail Sale Id 2795',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 12:51:56','',''),(3041,'21','222','1',1,'Retail Sale Id 2796',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 12:53:48','',''),(3042,'21','222','1',1,'Retail Sale Id 2797',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 12:55:15','',''),(3043,'21','222','1',1,'Retail Sale Id 2798',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 12:57:14','',''),(3044,'21','222','1',1,'Retail Sale Id 2799',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 12:59:18','',''),(3045,'21','222','1',1,'Retail Sale Id 2800',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 13:01:29','',''),(3046,'21','222','1',1,'Retail Sale Id 2801',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 13:02:54','',''),(3047,'21','222','1',1,'Retail Sale Id 2802',2500.40,0.00,0.00,3.29,0.00,'2022-06-26 13:04:21','',''),(3048,'21','222','1',1,'Retail Sale Id 2803',1497.20,0.00,0.00,1.97,0.00,'2022-06-26 13:06:09','',''),(3049,'21','222','1',1,'Retail Sale Id 2804',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 13:07:29','',''),(3050,'21','222','1',1,'Retail Sale Id 2805',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 13:11:08','',''),(3051,'21','222','1',1,'Retail Sale Id 2806',1147.60,0.00,0.00,1.51,0.00,'2022-06-26 13:13:29','',''),(3052,'21','222','1',1,'Retail Sale Id 2807',3040.00,0.00,0.00,4.00,0.00,'2022-06-26 13:15:02','',''),(3053,'21','222','1',1,'Retail Sale Id 2808',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 13:16:31','',''),(3054,'21','222','1',1,'Retail Sale Id 2809',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 14:50:57','',''),(3055,'21','222','1',1,'Retail Sale Id 2810',1003.20,0.00,0.00,1.32,0.00,'2022-06-26 15:10:29','',''),(3056,'21','222','1',1,'Retail Sale Id 2811',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 15:12:37','',''),(3057,'21','222','1',1,'Retail Sale Id 2812',15200.00,0.00,0.00,20.00,0.00,'2022-06-26 15:13:34','',''),(3058,'21','222','1',1,'Retail Sale Id 2813',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 15:14:30','',''),(3059,'21','222','1',1,'Retail Sale Id 2813',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 15:14:30','',''),(3060,'21','222','1',1,'Retail Sale Id 2814',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 15:16:03','',''),(3061,'21','222','1',1,'Retail Sale Id 2815',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 15:17:10','',''),(3062,'21','222','1',1,'Retail Sale Id 2816',8002.80,0.00,0.00,10.53,0.00,'2022-06-26 15:18:39','',''),(3063,'21','222','1',1,'Retail Sale Id 2817',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 15:21:50','',''),(3064,'21','222','1',1,'Retail Sale Id 2818',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 15:23:48','',''),(3065,'21','222','1',1,'Retail Sale Id 2819',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 15:25:27','',''),(3066,'21','222','1',1,'Retail Sale Id 2820',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 15:26:14','',''),(3067,'21','222','1',1,'Retail Sale Id 2821',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 15:27:33','',''),(3068,'21','222','1',1,'Retail Sale Id 2822',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 15:28:32','',''),(3069,'21','222','1',1,'Retail Sale Id 2823',1900.00,0.00,0.00,2.50,0.00,'2022-06-26 15:30:32','',''),(3070,'21','222','1',1,'Retail Sale Id 2824',3040.00,0.00,0.00,4.00,0.00,'2022-06-26 15:31:03','',''),(3071,'21','222','1',1,'Retail Sale Id 2825',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 15:32:57','',''),(3072,'21','222','1',1,'Retail Sale Id 2826',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 15:35:27','',''),(3073,'21','222','1',1,'Retail Sale Id 2827',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 15:38:04','',''),(3074,'21','222','1',1,'Retail Sale Id 2829',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 15:43:35','',''),(3075,'21','222','1',1,'Retail Sale Id 2830',4750.00,0.00,0.00,6.25,0.00,'2022-06-26 15:44:44','',''),(3076,'21','222','1',1,'Retail Sale Id 2831',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 15:45:46','',''),(3077,'21','222','1',1,'Retail Sale Id 2832',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 15:53:53','',''),(3078,'21','222','1',1,'Retail Sale Id 2833',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 15:57:00','',''),(3079,'21','222','1',1,'Retail Sale Id 2834',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 15:59:56','',''),(3080,'21','222','1',1,'Retail Sale Id 2835',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 16:06:40','',''),(3081,'21','222','1',1,'Retail Sale Id 2836',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 16:10:02','',''),(3082,'21','222','1',1,'Retail Sale Id 2837',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 16:12:37','',''),(3083,'21','222','1',1,'Retail Sale Id 2838',1003.20,0.00,0.00,1.32,0.00,'2022-06-26 16:15:17','',''),(3084,'21','222','1',1,'Retail Sale Id 2839',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 16:18:54','',''),(3085,'21','222','1',1,'Retail Sale Id 2840',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 16:19:37','',''),(3086,'21','222','1',1,'Retail Sale Id 2841',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 16:25:49','',''),(3087,'21','222','1',1,'Retail Sale Id 2842',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 16:26:38','',''),(3088,'21','222','1',1,'Retail Sale Id 2843',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 16:27:34','',''),(3089,'21','222','1',1,'Retail Sale Id 2844',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 16:29:14','',''),(3090,'21','222','1',1,'Retail Sale Id 2845',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 16:29:45','',''),(3091,'21','222','1',1,'Retail Sale Id 2846',2302.80,0.00,0.00,3.03,0.00,'2022-06-26 16:33:42','',''),(3092,'21','222','1',1,'Retail Sale Id 2847',1299.60,0.00,0.00,1.71,0.00,'2022-06-26 16:35:39','',''),(3093,'21','222','1',1,'Retail Sale Id 2848',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 16:36:35','',''),(3094,'21','222','1',1,'Retail Sale Id 2849',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 16:38:03','',''),(3095,'21','222','1',1,'Retail Sale Id 2850',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 16:38:47','',''),(3096,'21','222','1',1,'Retail Sale Id 2851',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 16:39:14','',''),(3097,'21','222','1',1,'Retail Sale Id 2853',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 16:41:24','',''),(3098,'21','222','1',1,'Retail Sale Id 2854',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 16:43:16','',''),(3099,'21','222','1',1,'Retail Sale Id 2855',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 16:44:04','',''),(3100,'21','222','1',1,'Retail Sale Id 2856',2302.80,0.00,0.00,3.03,0.00,'2022-06-26 16:45:21','',''),(3101,'21','222','1',1,'Retail Sale Id 2857',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 16:47:47','',''),(3102,'21','222','1',1,'Retail Sale Id 2858',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 16:52:17','',''),(3103,'21','222','1',1,'Retail Sale Id 2859',2500.40,0.00,0.00,3.29,0.00,'2022-06-26 16:55:18','',''),(3104,'21','222','1',1,'Retail Sale Id 2860',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 17:01:07','',''),(3105,'21','222','1',1,'Retail Sale Id 2861',4750.00,0.00,0.00,6.25,0.00,'2022-06-26 17:02:21','',''),(3106,'21','222','1',1,'Retail Sale Id 2862',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:06:41','',''),(3107,'21','222','1',1,'Retail Sale Id 2863',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:08:24','',''),(3108,'21','222','1',1,'Retail Sale Id 2864',10001.60,0.00,0.00,13.16,0.00,'2022-06-26 17:09:58','',''),(3109,'21','222','1',1,'Retail Sale Id 2865',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:13:02','',''),(3110,'21','222','1',1,'Retail Sale Id 2866',1003.20,0.00,0.00,1.32,0.00,'2022-06-26 17:15:43','',''),(3111,'21','222','1',1,'Retail Sale Id 2866',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 17:15:43','',''),(3112,'21','222','1',1,'Retail Sale Id 2867',4750.00,0.00,0.00,6.25,0.00,'2022-06-26 17:17:33','',''),(3113,'21','222','1',1,'Retail Sale Id 2868',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:19:33','',''),(3114,'21','222','1',1,'Retail Sale Id 2869',5000.80,0.00,0.00,6.58,0.00,'2022-06-26 17:20:29','',''),(3115,'21','222','1',1,'Retail Sale Id 2870',1520.00,0.00,0.00,2.00,0.00,'2022-06-26 17:21:37','',''),(3116,'21','222','1',1,'Retail Sale Id 2870',1520.00,0.00,0.00,2.00,0.00,'2022-06-26 17:21:37','',''),(3117,'21','222','1',1,'Retail Sale Id 2871',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:23:31','',''),(3118,'21','222','1',1,'Retail Sale Id 2872',1520.00,0.00,0.00,2.00,0.00,'2022-06-26 17:24:36','',''),(3119,'21','222','1',1,'Retail Sale Id 2873',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 17:27:32','',''),(3120,'21','222','1',1,'Retail Sale Id 2874',15200.00,0.00,0.00,20.00,0.00,'2022-06-26 17:28:49','',''),(3121,'21','222','1',1,'Retail Sale Id 2875',4499.20,0.00,0.00,5.92,0.00,'2022-06-26 17:31:22','',''),(3122,'21','222','1',1,'Retail Sale Id 2876',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:33:35','',''),(3123,'21','222','1',1,'Retail Sale Id 2877',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:34:28','',''),(3124,'21','222','1',1,'Retail Sale Id 2878',6999.60,0.00,0.00,9.21,0.00,'2022-06-26 17:35:24','',''),(3125,'21','222','1',1,'Retail Sale Id 2879',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 17:39:14','',''),(3126,'21','222','1',1,'Retail Sale Id 2880',3002.00,0.00,0.00,3.95,0.00,'2022-06-26 17:40:39','',''),(3127,'21','222','1',1,'Retail Sale Id 2882',38000.00,0.00,0.00,50.00,0.00,'2022-06-26 17:42:24','',''),(3128,'21','222','1',1,'Retail Sale Id 2883',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:43:52','',''),(3129,'21','222','1',1,'Retail Sale Id 2884',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 17:51:39','',''),(3130,'21','222','1',1,'Retail Sale Id 2885',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 17:52:48','',''),(3131,'21','222','1',1,'Retail Sale Id 2886',1900.00,0.00,0.00,2.50,0.00,'2022-06-26 17:54:23','',''),(3132,'21','222','1',1,'Retail Sale Id 2887',4750.00,0.00,0.00,6.25,0.00,'2022-06-26 17:58:20','',''),(3133,'21','222','1',1,'Retail Sale Id 2888',4499.20,0.00,0.00,5.92,0.00,'2022-06-26 17:59:37','',''),(3134,'21','222','1',1,'Retail Sale Id 2889',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 18:00:45','',''),(3135,'21','222','1',1,'Retail Sale Id 2890',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 18:02:45','',''),(3136,'21','222','1',1,'Retail Sale Id 2891',1520.00,0.00,0.00,2.00,0.00,'2022-06-26 18:04:16','',''),(3137,'21','222','1',1,'Retail Sale Id 2892',1520.00,0.00,0.00,2.00,0.00,'2022-06-26 18:04:58','',''),(3138,'21','222','1',1,'Retail Sale Id 2893',3040.00,0.00,0.00,4.00,0.00,'2022-06-26 18:06:25','',''),(3139,'21','222','1',1,'Retail Sale Id 2894',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 18:14:14','',''),(3140,'21','222','1',1,'Retail Sale Id 2895',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 18:17:37','',''),(3141,'21','222','1',1,'Retail Sale Id 2896',3997.60,0.00,0.00,5.26,0.00,'2022-06-26 18:19:39','',''),(3142,'21','222','1',1,'Retail Sale Id 2897',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 18:25:13','',''),(3143,'21','222','1',1,'Retail Sale Id 2898',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 18:27:11','',''),(3144,'21','222','1',1,'Retail Sale Id 2899',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 18:28:32','',''),(3145,'21','222','1',1,'Retail Sale Id 2900',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 18:29:25','',''),(3146,'21','222','1',1,'Retail Sale Id 2901',1497.20,0.00,0.00,1.97,0.00,'2022-06-26 18:30:16','',''),(3147,'21','222','1',1,'Retail Sale Id 2903',7501.20,0.00,0.00,9.87,0.00,'2022-06-26 18:32:09','',''),(3148,'21','222','1',1,'Retail Sale Id 2904',3997.60,0.00,0.00,5.26,0.00,'2022-06-26 18:39:59','',''),(3149,'21','222','1',1,'Retail Sale Id 2905',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 18:42:08','',''),(3150,'21','222','1',1,'Retail Sale Id 2905',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 18:42:08','',''),(3151,'21','222','1',1,'Retail Sale Id 2906',5700.00,0.00,0.00,7.50,0.00,'2022-06-26 18:44:24','',''),(3152,'21','222','1',1,'Retail Sale Id 2907',3800.00,0.00,0.00,5.00,0.00,'2022-06-26 18:51:43','',''),(3153,'21','222','1',1,'Retail Sale Id 2908',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 18:57:32','',''),(3154,'21','222','1',1,'Retail Sale Id 2909',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 18:58:36','',''),(3155,'21','222','1',1,'Retail Sale Id 2910',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 19:00:10','',''),(3156,'21','222','1',1,'Retail Sale Id 2911',2280.00,0.00,0.00,3.00,0.00,'2022-06-26 19:01:43','',''),(3157,'21','222','1',1,'Retail Sale Id 2912',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 19:04:07','',''),(3158,'21','222','1',1,'Retail Sale Id 2912',5502.40,0.00,0.00,7.24,0.00,'2022-06-26 19:04:07','',''),(3159,'21','222','1',1,'Retail Sale Id 2913',5000.80,0.00,0.00,6.58,0.00,'2022-06-26 19:07:36','',''),(3160,'21','222','1',1,'Retail Sale Id 2914',4560.00,0.00,0.00,6.00,0.00,'2022-06-26 19:14:50','',''),(3161,'21','222','1',1,'Retail Sale Id 2915',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 19:18:05','',''),(3162,'21','222','1',1,'Retail Sale Id 2916',1998.80,0.00,0.00,2.63,0.00,'2022-06-26 19:19:29','',''),(3163,'21','222','1',1,'Retail Sale Id 2917',4750.00,0.00,0.00,6.25,0.00,'2022-06-26 19:22:30','',''),(3164,'21','222','1',1,'Retail Sale Id 2918',2796.80,0.00,0.00,3.68,0.00,'2022-06-26 19:31:05','',''),(3165,'21','222','1',1,'Retail Sale Id 2919',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 19:44:42','',''),(3166,'21','222','1',1,'Retail Sale Id 2920',1003.20,0.00,0.00,1.32,0.00,'2022-06-26 19:55:43','',''),(3167,'21','222','1',1,'Retail Sale Id 2921',1003.20,0.00,0.00,1.32,0.00,'2022-06-26 19:56:41','',''),(3168,'21','222','1',1,'Retail Sale Id 2922',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 20:02:30','',''),(3169,'21','222','1',1,'Retail Sale Id 2923',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 20:04:35','',''),(3170,'21','222','1',1,'Retail Sale Id 2924',38000.00,0.00,0.00,50.00,0.00,'2022-06-26 21:15:56','',''),(3171,'21','222','1',1,'Retail Sale Id 2925',38000.00,0.00,0.00,50.00,0.00,'2022-06-26 21:16:33','',''),(3172,'21','222','1',1,'Retail Sale Id 2926',15200.00,0.00,0.00,20.00,0.00,'2022-06-26 21:17:22','',''),(3173,'21','222','1',1,'Retail Sale Id 2927',11400.00,0.00,0.00,15.00,0.00,'2022-06-26 21:18:04','',''),(3174,'21','222','1',1,'Retail Sale Id 2928',11400.00,0.00,0.00,15.00,0.00,'2022-06-26 21:18:52','',''),(3175,'21','222','1',1,'Retail Sale Id 2929',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 21:19:46','',''),(3176,'21','222','1',1,'Retail Sale Id 2929',9500.00,0.00,0.00,12.50,0.00,'2022-06-26 21:19:46','',''),(3177,'21','222','1',1,'Retail Sale Id 2930',19000.00,0.00,0.00,25.00,0.00,'2022-06-26 21:20:28','',''),(3178,'21','222','1',1,'Retail Sale Id 2931',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 21:21:28','',''),(3179,'21','222','1',1,'Retail Sale Id 2931',7600.00,0.00,0.00,10.00,0.00,'2022-06-26 21:21:28','',''),(3180,'21','222','1',1,'Retail Sale Id 2932',8002.80,0.00,0.00,10.53,0.00,'2022-06-26 21:22:44','',''),(3181,'21','222','1',1,'Retail Sale Id 2932',8998.40,0.00,0.00,11.84,0.00,'2022-06-26 21:22:44','',''),(3182,'21','222','1',1,'Retail Sale Id 2933',5000.80,0.00,0.00,6.58,0.00,'2022-06-26 21:23:12','',''),(3183,'21','222','1',1,'Retail Sale Id 2934',38000.00,0.00,0.00,50.00,0.00,'2022-06-26 21:23:52','',''),(3184,'21','222','1',1,'Retail Sale Id 2935',15200.00,0.00,0.00,20.00,0.00,'2022-06-26 21:25:16','',''),(3185,'21','222','1',1,'Retail Sale Id 2936',6999.60,0.00,0.00,9.21,0.00,'2022-06-26 21:25:55','',''),(3186,'21','222','1',1,'Retail Sale Id 2937',38000.00,0.00,0.00,50.00,0.00,'2022-06-26 21:27:51','',''),(3187,'21','222','1',1,'Retail Sale Id 2938',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 07:21:44','',''),(3188,'21','222','1',1,'Retail Sale Id 2940',95000.00,0.00,0.00,125.00,0.00,'2022-06-27 07:24:19','',''),(3189,'21','222','1',1,'Retail Sale Id 2941',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 10:26:09','',''),(3190,'21','222','1',1,'Retail Sale Id 2942',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 10:28:23','',''),(3191,'21','222','1',1,'Retail Sale Id 2943',15200.00,0.00,0.00,20.00,0.00,'2022-06-27 10:50:02','',''),(3192,'21','222','1',1,'Retail Sale Id 2944',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 10:54:21','',''),(3193,'21','222','1',1,'Retail Sale Id 2945',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 10:56:35','',''),(3194,'21','222','1',1,'Retail Sale Id 2946',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 10:58:55','',''),(3195,'21','222','1',1,'Retail Sale Id 2947',5996.40,0.00,0.00,7.89,0.00,'2022-06-27 11:04:11','',''),(3196,'21','222','1',1,'Retail Sale Id 2948',5000.80,0.00,0.00,6.58,0.00,'2022-06-27 11:15:59','',''),(3197,'21','222','1',1,'Retail Sale Id 2949',6840.00,0.00,0.00,9.00,0.00,'2022-06-27 11:19:49','',''),(3198,'21','222','1',1,'Retail Sale Id 2950',3002.00,0.00,0.00,3.95,0.00,'2022-06-27 11:40:56','',''),(3199,'21','222','1',1,'Retail Sale Id 2951',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 11:47:25','',''),(3200,'21','222','1',1,'Retail Sale Id 2952',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 11:49:32','',''),(3201,'21','222','1',1,'Retail Sale Id 2953',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 12:19:30','',''),(3202,'21','222','1',1,'Retail Sale Id 2954',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:25:07','',''),(3203,'21','222','1',1,'Retail Sale Id 2955',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 12:37:01','',''),(3204,'21','222','1',1,'Retail Sale Id 2956',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 12:45:18','',''),(3205,'21','222','1',1,'Retail Sale Id 2957',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:10:54','',''),(3206,'21','222','1',1,'Retail Sale Id 2958',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:17:03','',''),(3207,'21','222','1',1,'Retail Sale Id 2959',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 13:39:28','',''),(3208,'21','222','1',1,'Retail Sale Id 2960',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 13:44:25','',''),(3209,'21','222','1',1,'Retail Sale Id 2961',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 13:46:57','',''),(3210,'21','222','1',1,'Retail Sale Id 2962',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 15:23:51','',''),(3211,'21','222','1',1,'Retail Sale Id 2963',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:26:52','',''),(3212,'21','222','1',1,'Retail Sale Id 2964',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 15:31:29','',''),(3213,'21','222','1',1,'Retail Sale Id 2965',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:33:06','',''),(3214,'21','222','1',1,'Retail Sale Id 2966',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:35:25','',''),(3215,'21','222','1',1,'Retail Sale Id 2967',3503.60,0.00,0.00,4.61,0.00,'2022-06-27 15:37:04','',''),(3216,'21','222','1',1,'Retail Sale Id 2968',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 15:41:00','',''),(3217,'21','222','1',1,'Retail Sale Id 2969',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 15:44:53','',''),(3218,'21','222','1',1,'Retail Sale Id 2970',8998.40,0.00,0.00,11.84,0.00,'2022-06-27 15:46:18','',''),(3219,'21','222','1',1,'Retail Sale Id 2971',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:56:06','',''),(3220,'21','222','1',1,'Retail Sale Id 2972',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 15:57:33','',''),(3221,'21','222','1',1,'Retail Sale Id 2973',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 15:59:13','',''),(3222,'21','222','1',1,'Retail Sale Id 2974',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 16:01:15','',''),(3223,'21','222','1',1,'Retail Sale Id 2975',3800.00,0.00,0.00,5.00,0.00,'2022-06-27 16:04:12','',''),(3224,'21','222','1',1,'Retail Sale Id 2976',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 16:06:02','',''),(3225,'21','222','1',1,'Retail Sale Id 2977',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 16:13:34','',''),(3226,'21','222','1',1,'Retail Sale Id 2978',3997.60,0.00,0.00,5.26,0.00,'2022-06-27 16:21:11','',''),(3227,'21','222','1',1,'Retail Sale Id 2979',5000.80,0.00,0.00,6.58,0.00,'2022-06-27 16:27:55','',''),(3228,'21','222','1',1,'Retail Sale Id 2980',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 16:34:09','',''),(3229,'21','222','1',1,'Retail Sale Id 2981',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 16:35:54','',''),(3230,'21','222','1',1,'Retail Sale Id 2983',3002.00,0.00,0.00,3.95,0.00,'2022-06-27 16:38:34','',''),(3231,'21','222','1',1,'Retail Sale Id 2984',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 16:40:06','',''),(3232,'21','222','1',1,'Retail Sale Id 2985',1998.80,0.00,0.00,2.63,0.00,'2022-06-27 16:42:40','',''),(3233,'21','222','1',1,'Retail Sale Id 2986',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 16:45:48','',''),(3234,'21','222','1',1,'Retail Sale Id 2987',4902.00,0.00,0.00,6.45,0.00,'2022-06-27 16:47:31','',''),(3235,'21','222','1',1,'Retail Sale Id 2988',798.00,0.00,0.00,1.05,0.00,'2022-06-27 16:48:53','',''),(3236,'21','222','1',1,'Retail Sale Id 2989',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 17:01:54','',''),(3237,'21','222','1',1,'Retail Sale Id 2990',3002.00,0.00,0.00,3.95,0.00,'2022-06-27 17:04:35','',''),(3238,'21','222','1',1,'Retail Sale Id 2991',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 17:08:48','',''),(3239,'21','222','1',1,'Retail Sale Id 2992',1398.40,0.00,0.00,1.84,0.00,'2022-06-27 17:11:09','',''),(3240,'21','222','1',1,'Retail Sale Id 2993',4560.00,0.00,0.00,6.00,0.00,'2022-06-27 17:13:20','',''),(3241,'21','222','1',1,'Retail Sale Id 2994',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 17:15:14','',''),(3242,'21','222','1',1,'Retail Sale Id 2995',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 17:19:38','',''),(3243,'21','222','1',1,'Retail Sale Id 2996',24700.00,0.00,0.00,32.50,0.00,'2022-06-27 17:50:56','',''),(3244,'21','222','1',1,'Retail Sale Id 2997',2280.00,0.00,0.00,3.00,0.00,'2022-06-27 18:08:11','',''),(3245,'21','222','1',1,'Retail Sale Id 3003',38000.00,0.00,0.00,50.00,0.00,'2022-06-27 20:31:39','',''),(3246,'21','222','1',1,'Retail Sale Id 3004',38000.00,0.00,0.00,50.00,0.00,'2022-06-27 20:32:51','',''),(3247,'21','222','1',1,'Retail Sale Id 3005',87901.60,0.00,0.00,115.66,0.00,'2022-06-27 20:34:38','',''),(3248,'21','222','1',1,'Retail Sale Id 3006',19000.00,0.00,0.00,25.00,0.00,'2022-06-27 20:35:48','',''),(3249,'21','222','1',1,'Retail Sale Id 3007',95000.00,0.00,0.00,125.00,0.00,'2022-06-27 20:37:21','',''),(3250,'21','222','1',1,'Retail Sale Id 3008',9500.00,0.00,0.00,12.50,0.00,'2022-06-27 20:38:58','',''),(3251,'21','222','1',1,'Retail Sale Id 3009',38000.00,0.00,0.00,50.00,0.00,'2022-06-27 20:40:28','',''),(3252,'21','222','1',1,'Retail Sale Id 3010',19000.00,0.00,0.00,25.00,0.00,'2022-06-27 20:41:40','',''),(3253,'21','222','1',1,'Retail Sale Id 3011',19000.00,0.00,0.00,25.00,0.00,'2022-06-27 20:44:20','',''),(3254,'21','222','1',1,'Retail Sale Id 3012',106802.80,0.00,0.00,140.53,0.00,'2022-06-27 20:47:06','',''),(3255,'21','222','1',1,'Retail Sale Id 3013',53367.20,0.00,0.00,70.22,0.00,'2022-06-27 20:50:23','',''),(3256,'21','222','1',1,'Retail Sale Id 3014',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 08:24:01','',''),(3257,'21','222','1',1,'Retail Sale Id 3015',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 08:25:11','',''),(3258,'21','222','1',1,'Retail Sale Id 3016',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 08:26:25','',''),(3259,'21','222','1',1,'Retail Sale Id 3017',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 08:27:40','',''),(3260,'21','222','1',1,'Retail Sale Id 3018',7600.00,0.00,0.00,10.00,0.00,'2022-06-28 08:29:40','',''),(3261,'21','222','1',1,'Retail Sale Id 3019',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 08:30:48','',''),(3262,'21','222','1',1,'Retail Sale Id 3020',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 08:32:44','',''),(3263,'21','222','1',1,'Retail Sale Id 3021',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 08:53:12','',''),(3264,'21','222','1',1,'Retail Sale Id 3022',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 09:29:55','',''),(3265,'21','222','1',1,'Retail Sale Id 3023',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 11:45:00','',''),(3266,'21','222','1',1,'Retail Sale Id 3024',176000.80,0.00,0.00,231.58,0.00,'2022-06-28 11:48:59','',''),(3267,'21','222','1',1,'Retail Sale Id 3025',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 11:51:23','',''),(3268,'21','222','1',1,'Retail Sale Id 3026',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 11:53:04','',''),(3269,'21','222','1',1,'Retail Sale Id 3027',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 11:56:34','',''),(3270,'21','222','1',1,'Retail Sale Id 3028',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 11:58:26','',''),(3271,'21','222','1',1,'Retail Sale Id 3029',94597.20,0.00,0.00,124.47,0.00,'2022-06-28 12:01:05','',''),(3272,'21','222','1',1,'Retail Sale Id 3030',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 12:09:25','',''),(3273,'21','222','1',1,'Retail Sale Id 3032',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 12:14:30','',''),(3274,'21','222','1',1,'Retail Sale Id 3033',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 12:15:57','',''),(3275,'21','222','1',1,'Retail Sale Id 3034',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 12:17:53','',''),(3276,'21','222','1',1,'Retail Sale Id 3035',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 12:44:09','',''),(3277,'21','222','1',1,'Retail Sale Id 3036',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 12:45:28','',''),(3278,'21','222','1',1,'Retail Sale Id 3037',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 12:46:51','',''),(3279,'21','222','1',1,'Retail Sale Id 3040',39520.00,0.00,0.00,52.00,0.00,'2022-06-28 13:00:11','',''),(3280,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-06-28 18:08:28','',''),(3281,'21','222',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,4999.00,0.00,'2022-06-28 18:25:49','',''),(3282,'21','222','1',1,'Received from bridging 20',0.00,0.00,4999.00,0.00,0.00,'2022-06-28 18:25:49','',''),(3283,'21','222','1',1,'Retail Sale Id 3043',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 20:30:40','',''),(3284,'21','222','1',1,'Retail Sale Id 3044',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 20:31:09','',''),(3285,'21','222','1',1,'Retail Sale Id 3045',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 20:31:45','',''),(3286,'21','222','1',1,'Retail Sale Id 3045',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 20:31:45','',''),(3287,'21','222','1',1,'Retail Sale Id 3046',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 20:32:13','',''),(3288,'21','222','1',1,'Retail Sale Id 3047',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 20:32:49','',''),(3289,'21','222','1',1,'Retail Sale Id 3048',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 20:33:48','',''),(3290,'21','222','1',1,'Retail Sale Id 3048',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 20:33:48','',''),(3291,'21','222','1',1,'Retail Sale Id 3048',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 20:33:48','',''),(3292,'21','222','1',1,'Retail Sale Id 3048',9500.00,0.00,0.00,12.50,0.00,'2022-06-28 20:33:48','',''),(3293,'21','222','1',1,'Retail Sale Id 3049',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 20:34:46','',''),(3294,'21','222','1',1,'Retail Sale Id 3050',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 20:35:43','',''),(3295,'21','222','1',1,'Retail Sale Id 3050',38000.00,0.00,0.00,50.00,0.00,'2022-06-28 20:35:43','',''),(3296,'21','222','1',1,'Retail Sale Id 3051',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 20:36:40','',''),(3297,'21','222','1',1,'Retail Sale Id 3051',19000.00,0.00,0.00,25.00,0.00,'2022-06-28 20:36:40','',''),(3298,'21','222','1',1,'Retail Sale Id 3052',14356.40,0.00,0.00,18.89,0.00,'2022-06-28 20:37:08','',''),(3299,'21','222','1',1,'Retail Sale Id 3053',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 09:17:14','',''),(3300,'21','222','1',1,'Retail Sale Id 3054',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 09:38:03','',''),(3301,'21','222','1',1,'Retail Sale Id 3055',19000.00,0.00,0.00,25.00,0.00,'2022-06-29 09:44:09','',''),(3302,'21','222','1',1,'Retail Sale Id 3056',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 09:46:11','',''),(3303,'21','222','1',1,'Retail Sale Id 3057',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 09:58:11','',''),(3304,'21','222','1',1,'Retail Sale Id 3058',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 10:01:22','',''),(3305,'21','222','1',1,'Retail Sale Id 3059',8360.00,0.00,0.00,11.00,0.00,'2022-06-29 10:03:24','',''),(3306,'21','222','1',1,'Retail Sale Id 3060',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 10:11:10','',''),(3307,'21','222','1',1,'Retail Sale Id 3061',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 10:24:27','',''),(3308,'21','222','1',1,'Retail Sale Id 3062',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 10:26:53','',''),(3309,'21','222','1',1,'Retail Sale Id 3063',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 10:32:37','',''),(3310,'21','222','1',1,'Retail Sale Id 3064',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 10:36:05','',''),(3311,'21','222','1',1,'Retail Sale Id 3065',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 10:38:00','',''),(3312,'21','222','1',1,'Retail Sale Id 3066',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 10:39:22','',''),(3313,'21','222','1',1,'Retail Sale Id 3067',7600.00,0.00,0.00,10.00,0.00,'2022-06-29 11:01:02','',''),(3314,'21','222','1',1,'Retail Sale Id 3068',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 11:07:05','',''),(3315,'21','222','1',1,'Retail Sale Id 3068',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 11:07:05','',''),(3316,'21','222','1',1,'Retail Sale Id 3068',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 11:07:05','',''),(3317,'21','222','1',1,'Retail Sale Id 3068',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 11:07:05','',''),(3318,'21','222','1',1,'Retail Sale Id 3069',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 11:19:50','',''),(3319,'21','222','1',1,'Retail Sale Id 3070',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 11:20:46','',''),(3320,'21','222','1',1,'Retail Sale Id 3071',3040.00,0.00,0.00,4.00,0.00,'2022-06-29 11:23:11','',''),(3321,'21','222','1',1,'Retail Sale Id 3072',2500.40,0.00,0.00,3.29,0.00,'2022-06-29 11:27:50','',''),(3322,'21','222','1',1,'Retail Sale Id 3073',2500.40,0.00,0.00,3.29,0.00,'2022-06-29 11:31:47','',''),(3323,'21','222','1',1,'Retail Sale Id 3074',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 11:39:54','',''),(3324,'21','222','1',1,'Retail Sale Id 3075',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 11:42:39','',''),(3325,'21','222','1',1,'Retail Sale Id 3076',5996.40,0.00,0.00,7.89,0.00,'2022-06-29 11:44:44','',''),(3326,'21','222','1',1,'Retail Sale Id 3077',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 11:49:35','',''),(3327,'21','222','1',1,'Retail Sale Id 3078',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 12:08:11','',''),(3328,'21','222','1',1,'Retail Sale Id 3079',3997.60,0.00,0.00,5.26,0.00,'2022-06-29 12:09:27','',''),(3329,'21','222','1',1,'Retail Sale Id 3080',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 12:50:35','',''),(3330,'21','222','1',1,'Retail Sale Id 3081',7600.00,0.00,0.00,10.00,0.00,'2022-06-29 12:52:00','',''),(3331,'21','222','1',1,'Retail Sale Id 3082',8998.40,0.00,0.00,11.84,0.00,'2022-06-29 12:53:05','',''),(3332,'21','222','1',1,'Retail Sale Id 3083',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 13:00:45','',''),(3333,'21','222','1',1,'Retail Sale Id 3084',8998.40,0.00,0.00,11.84,0.00,'2022-06-29 13:01:41','',''),(3334,'21','222','1',1,'Retail Sale Id 3085',5000.80,0.00,0.00,6.58,0.00,'2022-06-29 13:10:08','',''),(3335,'21','222','1',1,'Retail Sale Id 3086',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 13:16:08','',''),(3336,'21','222','1',1,'Retail Sale Id 3087',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 13:39:34','',''),(3337,'21','222','1',1,'Retail Sale Id 3087',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 13:39:34','',''),(3338,'21','222','1',1,'Retail Sale Id 3087',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 13:39:34','',''),(3339,'21','222','1',1,'Retail Sale Id 3088',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 13:40:55','',''),(3340,'21','222','1',1,'Retail Sale Id 3089',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 13:43:05','',''),(3341,'21','222','1',1,'Retail Sale Id 3090',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 13:53:07','',''),(3342,'21','222','1',1,'Retail Sale Id 3091',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 13:54:28','',''),(3343,'21','222','1',1,'Retail Sale Id 3092',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 14:03:40','',''),(3344,'21','222','1',1,'Retail Sale Id 3093',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 14:11:55','',''),(3345,'21','222','1',1,'Retail Sale Id 3094',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 14:14:33','',''),(3346,'21','222','1',1,'Retail Sale Id 3095',11400.00,0.00,0.00,15.00,0.00,'2022-06-29 14:16:58','',''),(3347,'21','222','1',1,'Retail Sale Id 3096',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 14:23:14','',''),(3348,'21','222','1',1,'Retail Sale Id 3096',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 14:23:14','',''),(3349,'21','222','1',1,'Retail Sale Id 3097',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 14:28:19','',''),(3350,'21','222','1',1,'Retail Sale Id 3098',38000.00,0.00,0.00,50.00,0.00,'2022-06-29 14:31:46','',''),(3351,'21','222','1',1,'Retail Sale Id 3099',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 14:33:38','',''),(3352,'21','222','1',1,'Retail Sale Id 3100',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 14:40:35','',''),(3353,'21','222','1',1,'Retail Sale Id 3101',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 14:46:16','',''),(3354,'21','222','1',1,'Retail Sale Id 3102',2500.40,0.00,0.00,3.29,0.00,'2022-06-29 15:06:26','',''),(3355,'21','222','1',1,'Retail Sale Id 3102',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 15:06:26','',''),(3356,'21','222','1',1,'Retail Sale Id 3103',7600.00,0.00,0.00,10.00,0.00,'2022-06-29 15:07:58','',''),(3357,'21','222','1',1,'Retail Sale Id 3104',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 15:09:21','',''),(3358,'21','222','1',1,'Retail Sale Id 3105',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 15:10:46','',''),(3359,'21','222','1',1,'Retail Sale Id 3106',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 15:12:06','',''),(3360,'21','222','1',1,'Retail Sale Id 3107',798.00,0.00,0.00,1.05,0.00,'2022-06-29 15:13:21','',''),(3361,'21','222','1',1,'Retail Sale Id 3108',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 15:28:25','',''),(3362,'21','222','1',1,'Retail Sale Id 3109',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 15:29:27','',''),(3363,'21','222','1',1,'Retail Sale Id 3110',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 15:40:41','',''),(3364,'21','222','1',1,'Retail Sale Id 3111',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 16:13:41','',''),(3365,'21','222','1',1,'Retail Sale Id 3112',3002.00,0.00,0.00,3.95,0.00,'2022-06-29 16:28:39','',''),(3366,'21','222','1',1,'Retail Sale Id 3113',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 16:33:18','',''),(3367,'21','222','1',1,'Retail Sale Id 3114',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 16:34:20','',''),(3368,'21','222','1',1,'Retail Sale Id 3115',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 16:36:10','',''),(3369,'21','222','1',1,'Retail Sale Id 3116',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 16:37:24','',''),(3370,'21','222','1',1,'Retail Sale Id 3116',11400.00,0.00,0.00,15.00,0.00,'2022-06-29 16:37:24','',''),(3371,'21','222','1',1,'Retail Sale Id 3117',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 16:38:52','',''),(3372,'21','222','1',1,'Retail Sale Id 3118',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 16:41:05','',''),(3373,'21','222','1',1,'Retail Sale Id 3119',1801.20,0.00,0.00,2.37,0.00,'2022-06-29 16:46:08','',''),(3374,'21','222','1',1,'Retail Sale Id 3120',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 16:47:02','',''),(3375,'21','222','1',1,'Retail Sale Id 3121',8360.00,0.00,0.00,11.00,0.00,'2022-06-29 16:49:23','',''),(3376,'21','222','1',1,'Retail Sale Id 3122',1003.20,0.00,0.00,1.32,0.00,'2022-06-29 16:55:49','',''),(3377,'21','222','1',1,'Retail Sale Id 3122',1998.80,0.00,0.00,2.63,0.00,'2022-06-29 16:55:49','',''),(3378,'21','222','1',1,'Retail Sale Id 3123',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 16:58:48','',''),(3379,'21','222','1',1,'Retail Sale Id 3124',2196.40,0.00,0.00,2.89,0.00,'2022-06-29 16:59:32','',''),(3380,'21','222','1',1,'Retail Sale Id 3125',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 17:01:02','',''),(3381,'21','222','1',1,'Retail Sale Id 3126',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 17:02:43','',''),(3382,'21','222','1',1,'Retail Sale Id 3127',8998.40,0.00,0.00,11.84,0.00,'2022-06-29 17:05:12','',''),(3383,'21','222','1',1,'Retail Sale Id 3128',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 17:09:29','',''),(3384,'21','222','1',1,'Retail Sale Id 3129',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 17:10:21','',''),(3385,'21','222','1',1,'Retail Sale Id 3130',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 17:52:03','',''),(3386,'21','222','1',1,'Retail Sale Id 3130',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 17:52:03','',''),(3387,'21','222','1',1,'Retail Sale Id 3130',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 17:52:03','',''),(3388,'21','222','1',1,'Retail Sale Id 3131',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 18:08:18','',''),(3389,'21','222','1',1,'Retail Sale Id 3131',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 18:08:18','',''),(3390,'21','222','1',1,'Retail Sale Id 3132',760.00,0.00,0.00,1.00,0.00,'2022-06-29 18:10:05','',''),(3391,'21','222','1',1,'Retail Sale Id 3133',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 18:11:31','',''),(3392,'21','222','1',1,'Retail Sale Id 3134',3002.00,0.00,0.00,3.95,0.00,'2022-06-29 18:12:43','',''),(3393,'21','222','1',1,'Retail Sale Id 3135',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 18:17:55','',''),(3394,'21','222','1',1,'Retail Sale Id 3136',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 18:19:16','',''),(3395,'21','222','1',1,'Retail Sale Id 3136',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 18:19:16','',''),(3396,'21','222','1',1,'Retail Sale Id 3137',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 18:24:28','',''),(3397,'21','222','1',1,'Retail Sale Id 3138',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 18:37:08','',''),(3398,'21','222','1',1,'Retail Sale Id 3139',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 18:40:38','',''),(3399,'21','222','1',1,'Retail Sale Id 3140',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 18:45:38','',''),(3400,'21','222','1',1,'Retail Sale Id 3141',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 18:46:24','',''),(3401,'21','222','1',1,'Retail Sale Id 3142',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 18:50:55','',''),(3402,'21','222','1',1,'Retail Sale Id 3143',4560.00,0.00,0.00,6.00,0.00,'2022-06-29 18:55:37','',''),(3403,'21','222','1',1,'Retail Sale Id 3144',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 18:56:57','',''),(3404,'21','222','1',1,'Retail Sale Id 3145',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 18:59:08','',''),(3405,'21','222','1',1,'Retail Sale Id 3146',1497.20,0.00,0.00,1.97,0.00,'2022-06-29 18:59:57','',''),(3406,'21','222','1',1,'Retail Sale Id 3147',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 19:01:38','',''),(3407,'21','222','1',1,'Retail Sale Id 3148',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 19:06:29','',''),(3408,'21','222','1',1,'Retail Sale Id 3149',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 19:20:17','',''),(3409,'21','222','1',1,'Retail Sale Id 3150',3997.60,0.00,0.00,5.26,0.00,'2022-06-29 19:34:17','',''),(3410,'21','222','1',1,'Retail Sale Id 3151',3800.00,0.00,0.00,5.00,0.00,'2022-06-29 19:36:08','',''),(3411,'21','222','1',1,'Retail Sale Id 3152',7600.00,0.00,0.00,10.00,0.00,'2022-06-29 19:37:22','',''),(3412,'21','222','1',1,'Retail Sale Id 3153',5000.80,0.00,0.00,6.58,0.00,'2022-06-29 19:43:54','',''),(3413,'21','222','1',1,'Retail Sale Id 3154',2698.00,0.00,0.00,3.55,0.00,'2022-06-29 19:45:27','',''),(3414,'21','222','1',1,'Retail Sale Id 3155',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 19:49:28','',''),(3415,'21','222','1',1,'Retail Sale Id 3156',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 19:50:18','',''),(3416,'21','222','1',1,'Retail Sale Id 3157',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 19:58:23','',''),(3417,'21','222','1',1,'Retail Sale Id 3158',8002.80,0.00,0.00,10.53,0.00,'2022-06-29 20:00:32','',''),(3418,'21','222','1',1,'Retail Sale Id 3159',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 20:05:51','',''),(3419,'21','222','1',1,'Retail Sale Id 3160',2280.00,0.00,0.00,3.00,0.00,'2022-06-29 20:08:26','',''),(3420,'21','222','1',1,'Retail Sale Id 3161',8496.80,0.00,0.00,11.18,0.00,'2022-06-29 20:20:49','',''),(3421,'21','222','1',1,'Retail Sale Id 3162',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 20:25:13','',''),(3422,'21','222','1',1,'Retail Sale Id 3163',38000.00,0.00,0.00,50.00,0.00,'2022-06-29 21:23:28','',''),(3423,'21','222','1',1,'Retail Sale Id 3164',38000.00,0.00,0.00,50.00,0.00,'2022-06-29 21:24:18','',''),(3424,'21','222','1',1,'Retail Sale Id 3165',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 21:24:59','',''),(3425,'21','222','1',1,'Retail Sale Id 3165',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 21:24:59','',''),(3426,'21','222','1',1,'Retail Sale Id 3166',19000.00,0.00,0.00,25.00,0.00,'2022-06-29 21:25:33','',''),(3427,'21','222','1',1,'Retail Sale Id 3167',15200.00,0.00,0.00,20.00,0.00,'2022-06-29 21:26:11','',''),(3428,'21','222','1',1,'Retail Sale Id 3168',11400.00,0.00,0.00,15.00,0.00,'2022-06-29 21:27:10','',''),(3429,'21','222','1',1,'Retail Sale Id 3168',11400.00,0.00,0.00,15.00,0.00,'2022-06-29 21:27:10','',''),(3430,'21','222','1',1,'Retail Sale Id 3169',38000.00,0.00,0.00,50.00,0.00,'2022-06-29 21:27:44','',''),(3431,'21','222','1',1,'Retail Sale Id 3170',38000.00,0.00,0.00,50.00,0.00,'2022-06-29 21:28:10','',''),(3432,'21','222','1',1,'Retail Sale Id 3172',15200.00,0.00,0.00,20.00,0.00,'2022-06-29 21:29:31','',''),(3433,'21','222','1',1,'Retail Sale Id 3173',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 21:30:10','',''),(3434,'21','222','1',1,'Retail Sale Id 3173',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 21:30:10','',''),(3435,'21','222','1',1,'Retail Sale Id 3174',8002.80,0.00,0.00,10.53,0.00,'2022-06-29 21:31:48','',''),(3436,'21','222','1',1,'Retail Sale Id 3175',9500.00,0.00,0.00,12.50,0.00,'2022-06-29 21:32:37','',''),(3437,'21','222','1',1,'Retail Sale Id 3176',11400.00,0.00,0.00,15.00,0.00,'2022-06-29 21:33:28','',''),(3438,'21','222','1',1,'Retail Sale Id 3176',19000.00,0.00,0.00,25.00,0.00,'2022-06-29 21:33:28','',''),(3439,'21','222','1',1,'Retail Sale Id 3177',5662.00,0.00,0.00,7.45,0.00,'2022-06-29 21:34:10','',''),(3440,'21','222','1',1,'Retail Sale Id 3178',5000.80,0.00,0.00,6.58,0.00,'2022-06-30 12:39:49','',''),(3441,'21','222','1',1,'Retail Sale Id 3179',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 12:41:08','',''),(3442,'21','222','1',1,'Retail Sale Id 3180',2500.40,0.00,0.00,3.29,0.00,'2022-06-30 12:43:01','',''),(3443,'21','222','1',1,'Retail Sale Id 3181',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 12:46:52','',''),(3444,'21','222','1',1,'Retail Sale Id 3182',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 12:48:28','',''),(3445,'21','222','1',1,'Retail Sale Id 3183',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 12:50:46','',''),(3446,'21','222','1',1,'Retail Sale Id 3183',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 12:50:46','',''),(3447,'21','222','1',1,'Retail Sale Id 3184',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 12:51:45','',''),(3448,'21','222','1',1,'Retail Sale Id 3185',1003.20,0.00,0.00,1.32,0.00,'2022-06-30 12:55:30','',''),(3449,'21','222','1',1,'Retail Sale Id 3186',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 12:59:01','',''),(3450,'21','222','1',1,'Retail Sale Id 3187',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 13:03:02','',''),(3451,'21','222','1',1,'Retail Sale Id 3188',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 13:05:07','',''),(3452,'21','222','1',1,'Retail Sale Id 3189',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 13:12:50','',''),(3453,'21','222','1',1,'Retail Sale Id 3190',5000.80,0.00,0.00,6.58,0.00,'2022-06-30 13:18:27','',''),(3454,'21','222','1',1,'Retail Sale Id 3191',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 13:19:35','',''),(3455,'21','222','1',1,'Retail Sale Id 3192',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 13:21:20','',''),(3456,'21','222','1',1,'Retail Sale Id 3193',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 13:31:45','',''),(3457,'21','222','1',1,'Retail Sale Id 3194',4750.00,0.00,0.00,6.25,0.00,'2022-06-30 13:34:12','',''),(3458,'21','222','1',1,'Retail Sale Id 3195',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 13:56:48','',''),(3459,'21','222','1',1,'Retail Sale Id 3196',4750.00,0.00,0.00,6.25,0.00,'2022-06-30 14:05:38','',''),(3460,'21','222','1',1,'Retail Sale Id 3197',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 14:28:25','',''),(3461,'21','222','1',1,'Retail Sale Id 3199',3997.60,0.00,0.00,5.26,0.00,'2022-06-30 14:30:23','',''),(3462,'21','222','1',1,'Retail Sale Id 3200',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 14:31:12','',''),(3463,'21','222','1',1,'Retail Sale Id 3201',1497.20,0.00,0.00,1.97,0.00,'2022-06-30 14:31:59','',''),(3464,'21','222','1',1,'Retail Sale Id 3203',7501.20,0.00,0.00,9.87,0.00,'2022-06-30 14:39:41','',''),(3465,'21','222','1',1,'Retail Sale Id 3204',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 14:40:22','',''),(3466,'21','222','1',1,'Retail Sale Id 3205',1003.20,0.00,0.00,1.32,0.00,'2022-06-30 14:43:36','',''),(3467,'21','222','1',1,'Retail Sale Id 3205',1003.20,0.00,0.00,1.32,0.00,'2022-06-30 14:43:36','',''),(3468,'21','222','1',1,'Retail Sale Id 3206',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 14:44:36','',''),(3469,'21','222','1',1,'Retail Sale Id 3207',14060.00,0.00,0.00,18.50,0.00,'2022-06-30 14:49:07','',''),(3470,'21','222','1',1,'Retail Sale Id 3208',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 14:50:45','',''),(3471,'21','222','1',1,'Retail Sale Id 3209',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 14:51:25','',''),(3472,'21','222','1',1,'Retail Sale Id 3209',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 14:51:25','',''),(3473,'21','222','1',1,'Retail Sale Id 3209',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 14:51:25','',''),(3474,'21','222','1',1,'Retail Sale Id 3210',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 15:01:59','',''),(3475,'21','222','1',1,'Retail Sale Id 3211',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 15:08:17','',''),(3476,'21','222','1',1,'Retail Sale Id 3212',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 15:12:32','',''),(3477,'21','222','1',1,'Retail Sale Id 3213',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 15:27:04','',''),(3478,'21','222','1',1,'Retail Sale Id 3214',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 15:28:44','',''),(3479,'21','222','1',1,'Retail Sale Id 3215',501.60,0.00,0.00,0.66,0.00,'2022-06-30 15:31:43','',''),(3480,'21','222','1',1,'Retail Sale Id 3215',1140.00,0.00,0.00,1.50,0.00,'2022-06-30 15:31:43','',''),(3481,'21','222','1',1,'Retail Sale Id 3215',1140.00,0.00,0.00,1.50,0.00,'2022-06-30 15:31:43','',''),(3482,'21','222','1',1,'Retail Sale Id 3215',1140.00,0.00,0.00,1.50,0.00,'2022-06-30 15:31:43','',''),(3483,'21','222','1',1,'Retail Sale Id 3216',1003.20,0.00,0.00,1.32,0.00,'2022-06-30 15:39:10','',''),(3484,'21','222','1',1,'Retail Sale Id 3217',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 15:44:15','',''),(3485,'21','222','1',1,'Retail Sale Id 3218',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 15:45:48','',''),(3486,'21','222','1',1,'Retail Sale Id 3219',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 15:47:40','',''),(3487,'21','222','1',1,'Retail Sale Id 3220',2500.40,0.00,0.00,3.29,0.00,'2022-06-30 15:52:20','',''),(3488,'21','222','1',1,'Retail Sale Id 3221',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 15:54:30','',''),(3489,'21','222','1',1,'Retail Sale Id 3222',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 15:56:24','',''),(3490,'21','222','1',1,'Retail Sale Id 3223',3002.00,0.00,0.00,3.95,0.00,'2022-06-30 16:11:41','',''),(3491,'21','222','1',1,'Retail Sale Id 3224',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 16:38:26','',''),(3492,'21','222','1',1,'Retail Sale Id 3225',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 16:46:15','',''),(3493,'21','222','1',1,'Retail Sale Id 3226',5996.40,0.00,0.00,7.89,0.00,'2022-06-30 16:48:00','',''),(3494,'21','222','1',1,'Retail Sale Id 3227',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 16:49:06','',''),(3495,'21','222','1',1,'Retail Sale Id 3228',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:51:23','',''),(3496,'21','222','1',1,'Retail Sale Id 3229',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 16:52:05','',''),(3497,'21','222','1',1,'Retail Sale Id 3230',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 16:53:13','',''),(3498,'21','222','1',1,'Retail Sale Id 3231',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 16:54:42','',''),(3499,'21','222','1',1,'Retail Sale Id 3232',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 16:55:40','',''),(3500,'21','222','1',1,'Retail Sale Id 3233',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 16:56:24','',''),(3501,'21','222','1',1,'Retail Sale Id 3234',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 16:57:25','',''),(3502,'21','222','1',1,'Retail Sale Id 3235',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 17:04:38','',''),(3503,'21','222','1',1,'Retail Sale Id 3236',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 17:07:30','',''),(3504,'21','222','1',1,'Retail Sale Id 3237',2500.40,0.00,0.00,3.29,0.00,'2022-06-30 17:09:23','',''),(3505,'21','222','1',1,'Retail Sale Id 3238',4750.00,0.00,0.00,6.25,0.00,'2022-06-30 17:11:13','',''),(3506,'21','222','1',1,'Retail Sale Id 3239',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 17:12:27','',''),(3507,'21','222','1',1,'Retail Sale Id 3240',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 17:14:25','',''),(3508,'21','222','1',1,'Retail Sale Id 3241',1003.20,0.00,0.00,1.32,0.00,'2022-06-30 17:15:54','',''),(3509,'21','222','1',1,'Retail Sale Id 3242',699.20,0.00,0.00,0.92,0.00,'2022-06-30 17:18:41','',''),(3510,'21','222','1',1,'Retail Sale Id 3243',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 17:21:01','',''),(3511,'21','222','1',1,'Retail Sale Id 3244',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 17:23:03','',''),(3512,'21','222','1',1,'Retail Sale Id 3244',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:23:03','',''),(3513,'21','222','1',1,'Retail Sale Id 3245',1200.80,0.00,0.00,1.58,0.00,'2022-06-30 17:33:06','',''),(3514,'21','222','1',1,'Retail Sale Id 3246',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 17:36:49','',''),(3515,'21','222','1',1,'Retail Sale Id 3247',1003.20,0.00,0.00,1.32,0.00,'2022-06-30 17:39:18','',''),(3516,'21','222','1',1,'Retail Sale Id 3248',8998.40,0.00,0.00,11.84,0.00,'2022-06-30 17:40:22','',''),(3517,'21','222','1',1,'Retail Sale Id 3249',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 17:42:56','',''),(3518,'21','222','1',1,'Retail Sale Id 3250',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 17:43:54','',''),(3519,'21','222','1',1,'Retail Sale Id 3251',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:48:14','',''),(3520,'21','222','1',1,'Retail Sale Id 3252',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 17:50:02','',''),(3521,'21','222','1',1,'Retail Sale Id 3252',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 17:50:02','',''),(3522,'21','222','1',1,'Retail Sale Id 3252',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 17:50:02','',''),(3523,'21','222','1',1,'Retail Sale Id 3253',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 17:52:09','',''),(3524,'21','222','1',1,'Retail Sale Id 3254',6080.00,0.00,0.00,8.00,0.00,'2022-06-30 17:54:26','',''),(3525,'21','222','1',1,'Retail Sale Id 3255',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:56:24','',''),(3526,'21','222','1',1,'Retail Sale Id 3256',798.00,0.00,0.00,1.05,0.00,'2022-06-30 17:58:15','',''),(3527,'21','222','1',1,'Retail Sale Id 3257',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 17:59:20','',''),(3528,'21','222','1',1,'Retail Sale Id 3258',1003.20,0.00,0.00,1.32,0.00,'2022-06-30 18:01:20','',''),(3529,'21','222','1',1,'Retail Sale Id 3259',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 18:08:36','',''),(3530,'21','222','1',1,'Retail Sale Id 3259',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 18:08:36','',''),(3531,'21','222','1',1,'Retail Sale Id 3260',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 18:10:44','',''),(3532,'21','222','1',1,'Retail Sale Id 3261',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 18:11:49','',''),(3533,'21','222','1',1,'Retail Sale Id 3262',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 18:13:10','',''),(3534,'21','222','1',1,'Retail Sale Id 3263',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 18:19:06','',''),(3535,'21','222','1',1,'Retail Sale Id 3264',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 18:22:39','',''),(3536,'21','222','1',1,'Retail Sale Id 3265',7600.00,0.00,0.00,10.00,0.00,'2022-06-30 18:30:45','',''),(3537,'21','222','1',1,'Retail Sale Id 3266',3002.00,0.00,0.00,3.95,0.00,'2022-06-30 18:32:30','',''),(3538,'21','222','1',1,'Retail Sale Id 3267',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 18:36:23','',''),(3539,'21','222','1',1,'Retail Sale Id 3268',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 18:37:33','',''),(3540,'21','222','1',1,'Retail Sale Id 3269',2280.00,0.00,0.00,3.00,0.00,'2022-06-30 18:39:31','',''),(3541,'21','222','1',1,'Retail Sale Id 3270',3997.60,0.00,0.00,5.26,0.00,'2022-06-30 18:42:25','',''),(3542,'21','222','1',1,'Retail Sale Id 3271',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 18:44:02','',''),(3543,'21','222','1',1,'Retail Sale Id 3272',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 18:45:47','',''),(3544,'21','222','1',1,'Retail Sale Id 3273',5996.40,0.00,0.00,7.89,0.00,'2022-06-30 18:53:44','',''),(3545,'21','222','1',1,'Retail Sale Id 3274',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 18:56:28','',''),(3546,'21','222','1',1,'Retail Sale Id 3275',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 18:59:01','',''),(3547,'21','222','1',1,'Retail Sale Id 3276',5000.80,0.00,0.00,6.58,0.00,'2022-06-30 19:00:44','',''),(3548,'21','222','1',1,'Retail Sale Id 3277',1900.00,0.00,0.00,2.50,0.00,'2022-06-30 19:03:01','',''),(3549,'21','222','1',1,'Retail Sale Id 3278',3997.60,0.00,0.00,5.26,0.00,'2022-06-30 19:06:02','',''),(3550,'21','222','1',1,'Retail Sale Id 3279',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 19:15:26','',''),(3551,'21','222','1',1,'Retail Sale Id 3280',2500.40,0.00,0.00,3.29,0.00,'2022-06-30 19:24:01','',''),(3552,'21','222','1',1,'Retail Sale Id 3281',1003.20,0.00,0.00,1.32,0.00,'2022-06-30 19:29:11','',''),(3553,'21','222','1',1,'Retail Sale Id 3282',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 19:30:20','',''),(3554,'21','222','1',1,'Retail Sale Id 3283',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 19:33:18','',''),(3555,'21','222','1',1,'Retail Sale Id 3284',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 19:34:45','',''),(3556,'21','222','1',1,'Retail Sale Id 3285',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 19:37:06','',''),(3557,'21','222','1',1,'Retail Sale Id 3286',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 19:45:27','',''),(3558,'21','222','1',1,'Retail Sale Id 3287',1998.80,0.00,0.00,2.63,0.00,'2022-06-30 19:56:52','',''),(3559,'21','222','1',1,'Retail Sale Id 3288',3800.00,0.00,0.00,5.00,0.00,'2022-06-30 20:05:52','',''),(3560,'21','222','1',1,'Retail Sale Id 3289',3997.60,0.00,0.00,5.26,0.00,'2022-06-30 20:13:03','',''),(3561,'21','222','1',1,'Retail Sale Id 3290',8496.80,0.00,0.00,11.18,0.00,'2022-06-30 20:23:27','',''),(3562,'21','222','1',1,'Retail Sale Id 3291',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 20:24:44','',''),(3563,'21','222','1',1,'Retail Sale Id 3292',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 20:26:06','',''),(3564,'21','222','1',1,'Retail Sale Id 3293',1520.00,0.00,0.00,2.00,0.00,'2022-06-30 20:28:19','',''),(3565,'21','222','1',1,'Retail Sale Id 3294',4560.00,0.00,0.00,6.00,0.00,'2022-06-30 20:29:28','',''),(3566,'21','222','1',1,'Retail Sale Id 3295',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 21:26:04','',''),(3567,'21','222','1',1,'Retail Sale Id 3295',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 21:26:04','',''),(3568,'21','222','1',1,'Retail Sale Id 3296',19000.00,0.00,0.00,25.00,0.00,'2022-06-30 21:28:08','',''),(3569,'21','222','1',1,'Retail Sale Id 3297',15200.00,0.00,0.00,20.00,0.00,'2022-06-30 21:29:18','',''),(3570,'21','222','1',1,'Retail Sale Id 3297',15200.00,0.00,0.00,20.00,0.00,'2022-06-30 21:29:18','',''),(3571,'21','222','1',1,'Retail Sale Id 3298',11400.00,0.00,0.00,15.00,0.00,'2022-06-30 21:30:27','',''),(3572,'21','222','1',1,'Retail Sale Id 3298',11400.00,0.00,0.00,15.00,0.00,'2022-06-30 21:30:27','',''),(3573,'21','222','1',1,'Retail Sale Id 3298',11400.00,0.00,0.00,15.00,0.00,'2022-06-30 21:30:27','',''),(3574,'21','222','1',1,'Retail Sale Id 3299',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 21:31:50','',''),(3575,'21','222','1',1,'Retail Sale Id 3300',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 21:33:07','',''),(3576,'21','222','1',1,'Retail Sale Id 3301',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 21:34:45','',''),(3577,'21','222','1',1,'Retail Sale Id 3301',19000.00,0.00,0.00,25.00,0.00,'2022-06-30 21:34:45','',''),(3578,'21','222','1',1,'Retail Sale Id 3302',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 21:35:56','',''),(3579,'21','222','1',1,'Retail Sale Id 3302',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 21:35:56','',''),(3580,'21','222','1',1,'Retail Sale Id 3302',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 21:35:56','',''),(3581,'21','222','1',1,'Retail Sale Id 3303',8002.80,0.00,0.00,10.53,0.00,'2022-06-30 21:37:34','',''),(3582,'21','222','1',1,'Retail Sale Id 3304',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 21:38:45','',''),(3583,'21','222','1',1,'Retail Sale Id 3305',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 21:39:32','',''),(3584,'21','222','1',1,'Retail Sale Id 3306',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 21:41:44','',''),(3585,'21','222','1',1,'Return of Retail Sale Id 3306',0.00,38000.00,50.00,0.00,0.00,'2022-06-30 21:42:29','',''),(3586,'21','222','1',1,'Retail Sale Id 3307',8496.80,0.00,0.00,11.18,0.00,'2022-06-30 21:44:16','',''),(3587,'21','222','1',1,'Retail Sale Id 3307',8998.40,0.00,0.00,11.84,0.00,'2022-06-30 21:44:16','',''),(3588,'21','222','1',1,'Retail Sale Id 3308',4499.20,0.00,0.00,5.92,0.00,'2022-06-30 21:45:32','',''),(3589,'21','222','1',1,'Retail Sale Id 3308',5996.40,0.00,0.00,7.89,0.00,'2022-06-30 21:45:32','',''),(3590,'21','222','1',1,'Retail Sale Id 3309',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 21:46:31','',''),(3591,'21','222','1',1,'Retail Sale Id 3309',9500.00,0.00,0.00,12.50,0.00,'2022-06-30 21:46:31','',''),(3592,'21','222','1',1,'Retail Sale Id 3310',15200.00,0.00,0.00,20.00,0.00,'2022-06-30 21:47:37','',''),(3593,'21','222','1',1,'Retail Sale Id 3310',19000.00,0.00,0.00,25.00,0.00,'2022-06-30 21:47:37','',''),(3594,'21','222','1',1,'Retail Sale Id 3311',11400.00,0.00,0.00,15.00,0.00,'2022-06-30 21:48:27','',''),(3595,'21','222','1',1,'Retail Sale Id 3312',38000.00,0.00,0.00,50.00,0.00,'2022-06-30 21:49:18','',''),(3596,'21','222','1',1,'Retail Sale Id 3313',8466.40,0.00,0.00,11.14,0.00,'2022-06-30 21:50:14','',''),(3597,'21','222','1',1,'Retail Sale Id 3314',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 07:58:26','',''),(3598,'21','222','1',1,'Retail Sale Id 3315',4560.00,0.00,0.00,6.00,0.00,'2022-07-01 08:19:46','',''),(3599,'21','222','1',1,'Retail Sale Id 3316',19000.00,0.00,0.00,25.00,0.00,'2022-07-01 08:23:37','',''),(3600,'21','222','1',1,'Retail Sale Id 3317',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 08:24:41','',''),(3601,'21','222','1',1,'Retail Sale Id 3319',6102.80,0.00,0.00,8.03,0.00,'2022-07-01 08:54:10','',''),(3602,'21','222','1',1,'Retail Sale Id 3320',2196.40,0.00,0.00,2.89,0.00,'2022-07-01 09:00:31','',''),(3603,'21','222','1',1,'Retail Sale Id 3321',1497.20,0.00,0.00,1.97,0.00,'2022-07-01 09:01:31','',''),(3604,'21','222','1',1,'Retail Sale Id 3322',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 09:06:40','',''),(3605,'21','222','1',1,'Retail Sale Id 3323',19000.00,0.00,0.00,25.00,0.00,'2022-07-01 09:07:33','',''),(3606,'21','222','1',1,'Retail Sale Id 3324',28500.00,0.00,0.00,37.50,0.00,'2022-07-01 09:52:41','',''),(3607,'21','222','1',1,'Retail Sale Id 3325',8998.40,0.00,0.00,11.84,0.00,'2022-07-01 11:16:39','',''),(3608,'21','222','1',1,'Retail Sale Id 3326',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 11:47:59','',''),(3609,'21','222','1',1,'Retail Sale Id 3327',19000.00,0.00,0.00,25.00,0.00,'2022-07-01 11:49:07','',''),(3610,'21','222','1',1,'Retail Sale Id 3328',11400.00,0.00,0.00,15.00,0.00,'2022-07-01 11:50:12','',''),(3611,'21','222','1',1,'Retail Sale Id 3329',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 11:52:00','',''),(3612,'21','222','1',1,'Retail Sale Id 3331',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 11:57:47','',''),(3613,'21','222','1',1,'Retail Sale Id 3332',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 13:30:07','',''),(3614,'21','222','1',1,'Retail Sale Id 3333',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 15:38:06','',''),(3615,'21','222','1',1,'Retail Sale Id 3334',19000.00,0.00,0.00,25.00,0.00,'2022-07-01 15:39:03','',''),(3616,'21','222','1',1,'Retail Sale Id 3335',11400.00,0.00,0.00,15.00,0.00,'2022-07-01 15:39:55','',''),(3617,'21','222','1',1,'Retail Sale Id 3336',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 15:41:23','',''),(3618,'21','222','1',1,'Retail Sale Id 3337',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 15:42:28','',''),(3619,'21','222','1',1,'Retail Sale Id 3338',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 15:43:50','',''),(3620,'21','222','1',1,'Retail Sale Id 3339',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 15:44:53','',''),(3621,'21','222','1',1,'Retail Sale Id 3340',11400.00,0.00,0.00,15.00,0.00,'2022-07-01 15:46:31','',''),(3622,'21','222','1',1,'Retail Sale Id 3341',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 15:47:46','',''),(3623,'21','222','1',1,'Retail Sale Id 3342',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 15:52:37','',''),(3624,'21','222','1',1,'Retail Sale Id 3343',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 15:54:27','',''),(3625,'21','222','1',1,'Retail Sale Id 3344',34200.00,0.00,0.00,45.00,0.00,'2022-07-01 15:56:21','',''),(3626,'21','222','1',1,'Retail Sale Id 3345',8998.40,0.00,0.00,11.84,0.00,'2022-07-01 19:07:34','',''),(3627,'21','222','1',1,'Retail Sale Id 3346',9500.00,0.00,0.00,12.50,0.00,'2022-07-01 20:08:46','',''),(3628,'21','222','1',1,'Retail Sale Id 3347',204789.60,0.00,0.00,269.46,0.00,'2022-07-01 20:18:37','',''),(3629,'21','222','1',1,'Retail Sale Id 3348',38000.00,0.00,0.00,50.00,0.00,'2022-07-01 20:19:35','',''),(3630,'21','222','1',1,'Retail Sale Id 3349',19000.00,0.00,0.00,25.00,0.00,'2022-07-01 20:21:09','',''),(3631,'21','222','1',1,'Retail Sale Id 3350',128668.00,0.00,0.00,169.30,0.00,'2022-07-01 20:22:33','',''),(3632,'21','222','1',1,'Retail Sale Id 3351',19000.00,0.00,0.00,25.00,0.00,'2022-07-01 20:24:04','',''),(3633,'21','222','1',1,'Retail Sale Id 3352',69562.80,0.00,0.00,91.53,0.00,'2022-07-01 20:26:49','',''),(3634,'21','222','1',1,'Retail Sale Id 3353',9500.00,0.00,0.00,12.50,0.00,'2022-07-02 12:34:57','',''),(3635,'21','222','1',1,'Retail Sale Id 3354',38000.00,0.00,0.00,50.00,0.00,'2022-07-02 18:57:38','',''),(3636,'21','222','1',1,'Retail Sale Id 3356',37240.00,0.00,0.00,49.00,0.00,'2022-07-02 19:00:57','',''),(3637,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4126800.00,5430.00,0.00,0.00,'2022-07-02 20:36:50','',''),(3638,'21','222',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,4999.00,0.00,'2022-07-02 20:53:19','',''),(3639,'21','222','1',1,'Received from bridging 21',0.00,0.00,4999.00,0.00,0.00,'2022-07-02 20:53:19','',''),(3640,'21','222','1',1,'Retail Sale Id 3357',38000.00,0.00,0.00,50.00,0.00,'2022-07-02 22:06:56','',''),(3641,'21','222','1',1,'Retail Sale Id 3358',24996.40,0.00,0.00,32.89,0.00,'2022-07-02 22:07:32','',''),(3642,'21','222','1',1,'Retail Sale Id 3359',19000.00,0.00,0.00,25.00,0.00,'2022-07-02 22:08:04','',''),(3643,'21','222','1',1,'Retail Sale Id 3360',8496.80,0.00,0.00,11.18,0.00,'2022-07-02 22:08:55','',''),(3644,'21','222','1',1,'Retail Sale Id 3360',9500.00,0.00,0.00,12.50,0.00,'2022-07-02 22:08:55','',''),(3645,'21','222','1',1,'Retail Sale Id 3361',15200.00,0.00,0.00,20.00,0.00,'2022-07-02 22:09:52','',''),(3646,'21','222','1',1,'Retail Sale Id 3361',38000.00,0.00,0.00,50.00,0.00,'2022-07-02 22:09:52','',''),(3647,'21','222','1',1,'Retail Sale Id 3362',7600.00,0.00,0.00,10.00,0.00,'2022-07-02 22:10:47','',''),(3648,'21','222','1',1,'Retail Sale Id 3362',11400.00,0.00,0.00,15.00,0.00,'2022-07-02 22:10:47','',''),(3649,'21','222','1',1,'Retail Sale Id 3362',13300.00,0.00,0.00,17.50,0.00,'2022-07-02 22:10:47','',''),(3650,'21','222','1',1,'Retail Sale Id 3363',19000.00,0.00,0.00,25.00,0.00,'2022-07-02 22:11:21','',''),(3651,'21','222','1',1,'Retail Sale Id 3363',38000.00,0.00,0.00,50.00,0.00,'2022-07-02 22:11:21','',''),(3652,'21','222','1',1,'Retail Sale Id 3364',15200.00,0.00,0.00,20.00,0.00,'2022-07-02 22:11:56','',''),(3653,'21','222','1',1,'Retail Sale Id 3364',38000.00,0.00,0.00,50.00,0.00,'2022-07-02 22:11:56','',''),(3654,'21','222','1',1,'Retail Sale Id 3365',19000.00,0.00,0.00,25.00,0.00,'2022-07-02 22:12:41','',''),(3655,'21','222','1',1,'Retail Sale Id 3365',27998.40,0.00,0.00,36.84,0.00,'2022-07-02 22:12:41','',''),(3656,'21','222','1',1,'Retail Sale Id 3366',3800.00,0.00,0.00,5.00,0.00,'2022-07-02 22:13:47','',''),(3657,'21','222','1',1,'Retail Sale Id 3366',4560.00,0.00,0.00,6.00,0.00,'2022-07-02 22:13:47','',''),(3658,'21','222','1',1,'Retail Sale Id 3366',15002.40,0.00,0.00,19.74,0.00,'2022-07-02 22:13:47','',''),(3659,'21','222','1',1,'Retail Sale Id 3367',7600.00,0.00,0.00,10.00,0.00,'2022-07-02 22:14:31','',''),(3660,'21','222','1',1,'Retail Sale Id 3367',9500.00,0.00,0.00,12.50,0.00,'2022-07-02 22:14:31','',''),(3661,'21','222','1',1,'Retail Sale Id 3368',19000.00,0.00,0.00,25.00,0.00,'2022-07-02 22:15:14','',''),(3662,'21','222','1',1,'Retail Sale Id 3368',38000.00,0.00,0.00,50.00,0.00,'2022-07-02 22:15:14','',''),(3663,'21','222','1',1,'Retail Sale Id 3369',2280.00,0.00,0.00,3.00,0.00,'2022-07-02 22:16:10','',''),(3664,'21','222','1',1,'Retail Sale Id 3369',4560.00,0.00,0.00,6.00,0.00,'2022-07-02 22:16:10','',''),(3665,'21','222','1',1,'Retail Sale Id 3369',19000.00,0.00,0.00,25.00,0.00,'2022-07-02 22:16:10','',''),(3666,'21','222','1',1,'Retail Sale Id 3370',9500.00,0.00,0.00,12.50,0.00,'2022-07-02 22:17:20','',''),(3667,'21','222','1',1,'Retail Sale Id 3370',15200.00,0.00,0.00,20.00,0.00,'2022-07-02 22:17:20','',''),(3668,'21','222','1',1,'Retail Sale Id 3371',8002.80,0.00,0.00,10.53,0.00,'2022-07-02 22:18:14','',''),(3669,'21','222','1',1,'Retail Sale Id 3371',38000.00,0.00,0.00,50.00,0.00,'2022-07-02 22:18:14','',''),(3670,'21','222','1',1,'Retail Sale Id 3372',4560.00,0.00,0.00,6.00,0.00,'2022-07-02 22:19:09','',''),(3671,'21','222','1',1,'Retail Sale Id 3373',3032.40,0.00,0.00,3.99,0.00,'2022-07-02 22:24:49','',''),(3672,'21','222','1',1,'Retail Sale Id 3374',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:04:05','',''),(3673,'21','222','1',1,'Retail Sale Id 3375',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:04:27','',''),(3674,'21','222','1',1,'Retail Sale Id 3376',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:05:44','',''),(3675,'21','222','1',1,'Retail Sale Id 3377',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 09:06:32','',''),(3676,'21','222','1',1,'Retail Sale Id 3378',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 09:07:33','',''),(3677,'21','222','1',1,'Retail Sale Id 3379',2500.40,0.00,0.00,3.29,0.00,'2022-07-03 09:08:56','',''),(3678,'21','222','1',1,'Retail Sale Id 3380',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:09:54','',''),(3679,'21','222','1',1,'Retail Sale Id 3381',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:11:16','',''),(3680,'21','222','1',1,'Retail Sale Id 3381',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:11:16','',''),(3681,'21','222','1',1,'Retail Sale Id 3382',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 09:12:01','',''),(3682,'21','222','1',1,'Retail Sale Id 3383',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:13:30','',''),(3683,'21','222','1',1,'Retail Sale Id 3384',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:14:38','',''),(3684,'21','222','1',1,'Retail Sale Id 3385',4940.00,0.00,0.00,6.50,0.00,'2022-07-03 09:15:53','',''),(3685,'21','222','1',1,'Retail Sale Id 3386',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 09:19:47','',''),(3686,'21','222','1',1,'Retail Sale Id 3387',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 09:24:21','',''),(3687,'21','222','1',1,'Retail Sale Id 3387',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:24:21','',''),(3688,'21','222','1',1,'Retail Sale Id 3388',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:25:25','',''),(3689,'21','222','1',1,'Retail Sale Id 3389',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 09:27:01','',''),(3690,'21','222','1',1,'Retail Sale Id 3390',3997.60,0.00,0.00,5.26,0.00,'2022-07-03 09:28:42','',''),(3691,'21','222','1',1,'Retail Sale Id 3391',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:29:52','',''),(3692,'21','222','1',1,'Retail Sale Id 3392',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:30:50','',''),(3693,'21','222','1',1,'Retail Sale Id 3393',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 09:31:45','',''),(3694,'21','222','1',1,'Retail Sale Id 3394',5000.80,0.00,0.00,6.58,0.00,'2022-07-03 09:33:10','',''),(3695,'21','222','1',1,'Retail Sale Id 3395',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 09:34:05','',''),(3696,'21','222','1',1,'Retail Sale Id 3396',3503.60,0.00,0.00,4.61,0.00,'2022-07-03 09:35:49','',''),(3697,'21','222','1',1,'Retail Sale Id 3397',4750.00,0.00,0.00,6.25,0.00,'2022-07-03 09:36:28','',''),(3698,'21','222','1',1,'Retail Sale Id 3398',8002.80,0.00,0.00,10.53,0.00,'2022-07-03 09:37:44','',''),(3699,'21','222','1',1,'Retail Sale Id 3399',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:39:07','',''),(3700,'21','222','1',1,'Retail Sale Id 3400',7600.00,0.00,0.00,10.00,0.00,'2022-07-03 09:40:19','',''),(3701,'21','222','1',1,'Retail Sale Id 3401',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 09:41:08','',''),(3702,'21','222','1',1,'Retail Sale Id 3402',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 09:42:13','',''),(3703,'21','222','1',1,'Retail Sale Id 3403',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 09:43:11','',''),(3704,'21','222','1',1,'Retail Sale Id 3404',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:44:37','',''),(3705,'21','222','1',1,'Retail Sale Id 3405',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 09:45:40','',''),(3706,'21','222','1',1,'Retail Sale Id 3406',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 09:46:23','',''),(3707,'21','222','1',1,'Retail Sale Id 3407',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 09:47:24','',''),(3708,'21','222','1',1,'Retail Sale Id 3408',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 09:48:37','',''),(3709,'21','222','1',1,'Retail Sale Id 3409',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 09:49:32','',''),(3710,'21','222','1',1,'Retail Sale Id 3410',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 09:51:08','',''),(3711,'21','222','1',1,'Retail Sale Id 3410',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:51:08','',''),(3712,'21','222','1',1,'Retail Sale Id 3410',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 09:51:08','',''),(3713,'21','222','1',1,'Retail Sale Id 3411',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 09:53:54','',''),(3714,'21','222','1',1,'Retail Sale Id 3412',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 09:56:39','',''),(3715,'21','222','1',1,'Retail Sale Id 3413',6080.00,0.00,0.00,8.00,0.00,'2022-07-03 09:57:58','',''),(3716,'21','222','1',1,'Retail Sale Id 3414',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 09:59:24','',''),(3717,'21','222','1',1,'Retail Sale Id 3415',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 10:00:10','',''),(3718,'21','222','1',1,'Retail Sale Id 3416',8002.80,0.00,0.00,10.53,0.00,'2022-07-03 10:01:53','',''),(3719,'21','222','1',1,'Retail Sale Id 3417',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 10:02:48','',''),(3720,'21','222','1',1,'Retail Sale Id 3418',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:04:13','',''),(3721,'21','222','1',1,'Retail Sale Id 3418',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:04:13','',''),(3722,'21','222','1',1,'Retail Sale Id 3419',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:05:31','',''),(3723,'21','222','1',1,'Retail Sale Id 3420',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:07:51','',''),(3724,'21','222','1',1,'Retail Sale Id 3422',1520.00,0.00,0.00,2.00,0.00,'2022-07-03 10:09:18','',''),(3725,'21','222','1',1,'Retail Sale Id 3423',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:10:00','',''),(3726,'21','222','1',1,'Retail Sale Id 3424',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:10:59','',''),(3727,'21','222','1',1,'Retail Sale Id 3425',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:12:12','',''),(3728,'21','222','1',1,'Retail Sale Id 3426',8360.00,0.00,0.00,11.00,0.00,'2022-07-03 10:14:34','',''),(3729,'21','222','1',1,'Return of Retail Sale Id 3420',0.00,9500.00,12.50,0.00,0.00,'2022-07-03 10:15:08','',''),(3730,'21','222','1',1,'Retail Sale Id 3427',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:16:33','',''),(3731,'21','222','1',1,'Retail Sale Id 3428',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 10:21:24','',''),(3732,'21','222','1',1,'Retail Sale Id 3429',1520.00,0.00,0.00,2.00,0.00,'2022-07-03 10:23:00','',''),(3733,'21','222','1',1,'Retail Sale Id 3430',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 10:23:54','',''),(3734,'21','222','1',1,'Retail Sale Id 3431',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 10:29:30','',''),(3735,'21','222','1',1,'Retail Sale Id 3431',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 10:29:30','',''),(3736,'21','222','1',1,'Retail Sale Id 3432',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 10:31:12','',''),(3737,'21','222','1',1,'Retail Sale Id 3433',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 10:32:16','',''),(3738,'21','222','1',1,'Retail Sale Id 3434',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:33:37','',''),(3739,'21','222','1',1,'Retail Sale Id 3435',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:36:17','',''),(3740,'21','222','1',1,'Retail Sale Id 3436',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 10:39:13','',''),(3741,'21','222','1',1,'Retail Sale Id 3437',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 10:41:03','',''),(3742,'21','222','1',1,'Retail Sale Id 3438',3997.60,0.00,0.00,5.26,0.00,'2022-07-03 10:41:58','',''),(3743,'21','222','1',1,'Retail Sale Id 3439',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:42:41','',''),(3744,'21','222','1',1,'Retail Sale Id 3440',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:44:29','',''),(3745,'21','222','1',1,'Retail Sale Id 3441',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 10:45:34','',''),(3746,'21','222','1',1,'Retail Sale Id 3442',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 10:48:18','',''),(3747,'21','222','1',1,'Retail Sale Id 3443',1702.40,0.00,0.00,2.24,0.00,'2022-07-03 10:49:45','',''),(3748,'21','222','1',1,'Retail Sale Id 3444',2302.80,0.00,0.00,3.03,0.00,'2022-07-03 10:50:49','',''),(3749,'21','222','1',1,'Retail Sale Id 3445',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 10:51:57','',''),(3750,'21','222','1',1,'Retail Sale Id 3446',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 10:52:48','',''),(3751,'21','222','1',1,'Retail Sale Id 3447',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 10:53:43','',''),(3752,'21','222','1',1,'Retail Sale Id 3448',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 10:56:56','',''),(3753,'21','222','1',1,'Retail Sale Id 3449',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 10:57:29','',''),(3754,'21','222','1',1,'Retail Sale Id 3450',760.00,0.00,0.00,1.00,0.00,'2022-07-03 10:58:57','',''),(3755,'21','222','1',1,'Retail Sale Id 3451',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 11:00:22','',''),(3756,'21','222','1',1,'Retail Sale Id 3452',5000.80,0.00,0.00,6.58,0.00,'2022-07-03 11:04:49','',''),(3757,'21','222','1',1,'Retail Sale Id 3453',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 11:05:57','',''),(3758,'21','222','1',1,'Retail Sale Id 3454',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 11:07:05','',''),(3759,'21','222','1',1,'Retail Sale Id 3455',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 11:08:00','',''),(3760,'21','222','1',1,'Retail Sale Id 3456',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:08:44','',''),(3761,'21','222','1',1,'Retail Sale Id 3457',1520.00,0.00,0.00,2.00,0.00,'2022-07-03 11:09:30','',''),(3762,'21','222','1',1,'Retail Sale Id 3458',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 11:10:16','',''),(3763,'21','222','1',1,'Retail Sale Id 3459',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 11:11:00','',''),(3764,'21','222','1',1,'Retail Sale Id 3460',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:12:34','',''),(3765,'21','222','1',1,'Retail Sale Id 3461',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 11:13:44','',''),(3766,'21','222','1',1,'Retail Sale Id 3462',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:14:50','',''),(3767,'21','222','1',1,'Retail Sale Id 3463',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 11:15:56','',''),(3768,'21','222','1',1,'Retail Sale Id 3464',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 11:17:17','',''),(3769,'21','222','1',1,'Retail Sale Id 3465',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 11:19:08','',''),(3770,'21','222','1',1,'Retail Sale Id 3466',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 11:20:15','',''),(3771,'21','222','1',1,'Retail Sale Id 3467',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:22:48','',''),(3772,'21','222','1',1,'Retail Sale Id 3468',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:24:00','',''),(3773,'21','222','1',1,'Retail Sale Id 3469',5000.80,0.00,0.00,6.58,0.00,'2022-07-03 11:25:24','',''),(3774,'21','222','1',1,'Retail Sale Id 3470',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 11:26:24','',''),(3775,'21','222','1',1,'Retail Sale Id 3471',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:27:07','',''),(3776,'21','222','1',1,'Retail Sale Id 3472',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:30:18','',''),(3777,'21','222','1',1,'Retail Sale Id 3473',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 11:31:14','',''),(3778,'21','222','1',1,'Retail Sale Id 3474',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 11:32:45','',''),(3779,'21','222','1',1,'Retail Sale Id 3475',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:33:22','',''),(3780,'21','222','1',1,'Retail Sale Id 3476',4750.00,0.00,0.00,6.25,0.00,'2022-07-03 11:34:15','',''),(3781,'21','222','1',1,'Retail Sale Id 3477',1900.00,0.00,0.00,2.50,0.00,'2022-07-03 11:35:25','',''),(3782,'21','222','1',1,'Retail Sale Id 3478',7600.00,0.00,0.00,10.00,0.00,'2022-07-03 11:36:33','',''),(3783,'21','222','1',1,'Retail Sale Id 3479',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 11:39:29','',''),(3784,'21','222','1',1,'Retail Sale Id 3480',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 11:41:38','',''),(3785,'21','222','1',1,'Retail Sale Id 3481',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 11:42:49','',''),(3786,'21','222','1',1,'Retail Sale Id 3482',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 11:43:43','',''),(3787,'21','222','1',1,'Retail Sale Id 3483',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:44:39','',''),(3788,'21','222','1',1,'Retail Sale Id 3484',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 11:45:34','',''),(3789,'21','222','1',1,'Retail Sale Id 3485',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 11:46:33','',''),(3790,'21','222','1',1,'Retail Sale Id 3486',5000.80,0.00,0.00,6.58,0.00,'2022-07-03 11:48:53','',''),(3791,'21','222','1',1,'Retail Sale Id 3487',8496.80,0.00,0.00,11.18,0.00,'2022-07-03 11:49:52','',''),(3792,'21','222','1',1,'Retail Sale Id 3488',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:52:56','',''),(3793,'21','222','1',1,'Retail Sale Id 3488',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 11:52:56','',''),(3794,'21','222','1',1,'Retail Sale Id 3489',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 11:55:58','',''),(3795,'21','222','1',1,'Retail Sale Id 3490',4940.00,0.00,0.00,6.50,0.00,'2022-07-03 11:57:27','',''),(3796,'21','222','1',1,'Retail Sale Id 3491',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 11:59:57','',''),(3797,'21','222','1',1,'Retail Sale Id 3492',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 12:02:21','',''),(3798,'21','222','1',1,'Retail Sale Id 3493',6999.60,0.00,0.00,9.21,0.00,'2022-07-03 12:03:19','',''),(3799,'21','222','1',1,'Retail Sale Id 3494',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 12:04:29','',''),(3800,'21','222','1',1,'Retail Sale Id 3495',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 12:06:21','',''),(3801,'21','222','1',1,'Retail Sale Id 3496',3503.60,0.00,0.00,4.61,0.00,'2022-07-03 12:08:33','',''),(3802,'21','222','1',1,'Retail Sale Id 3497',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 12:09:24','',''),(3803,'21','222','1',1,'Retail Sale Id 3498',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 12:11:44','',''),(3804,'21','222','1',1,'Retail Sale Id 3498',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 12:11:44','',''),(3805,'21','222','1',1,'Retail Sale Id 3500',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 12:14:39','',''),(3806,'21','222','1',1,'Retail Sale Id 3499',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 12:16:29','',''),(3807,'21','222','1',1,'Retail Sale Id 3501',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 12:17:39','',''),(3808,'21','222','1',1,'Retail Sale Id 3502',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 12:18:22','',''),(3809,'21','222','1',1,'Retail Sale Id 3503',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 12:19:58','',''),(3810,'21','222','1',1,'Retail Sale Id 3504',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 12:21:57','',''),(3811,'21','222','1',1,'Retail Sale Id 3505',4750.00,0.00,0.00,6.25,0.00,'2022-07-03 12:23:25','',''),(3812,'21','222','1',1,'Retail Sale Id 3506',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 12:24:27','',''),(3813,'21','222','1',1,'Retail Sale Id 3507',3397.20,0.00,0.00,4.47,0.00,'2022-07-03 12:26:14','',''),(3814,'21','222','1',1,'Retail Sale Id 3508',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 12:27:13','',''),(3815,'21','222','1',1,'Retail Sale Id 3509',5000.80,0.00,0.00,6.58,0.00,'2022-07-03 12:30:16','',''),(3816,'21','222','1',1,'Retail Sale Id 3510',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 12:32:39','',''),(3817,'21','222','1',1,'Retail Sale Id 3511',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 12:36:31','',''),(3818,'21','222','1',1,'Retail Sale Id 3512',5000.80,0.00,0.00,6.58,0.00,'2022-07-03 12:39:56','',''),(3819,'21','222','1',1,'Retail Sale Id 3513',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 12:41:35','',''),(3820,'21','222','1',1,'Retail Sale Id 3514',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 12:42:49','',''),(3821,'21','222','1',1,'Retail Sale Id 3514',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 12:42:49','',''),(3822,'21','222','1',1,'Retail Sale Id 3515',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 12:45:16','',''),(3823,'21','222','1',1,'Retail Sale Id 3516',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 12:46:20','',''),(3824,'21','222','1',1,'Retail Sale Id 3517',20003.20,0.00,0.00,26.32,0.00,'2022-07-03 12:48:23','',''),(3825,'21','222','1',1,'Retail Sale Id 3518',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 12:50:15','',''),(3826,'21','222','1',1,'Retail Sale Id 3519',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 12:51:15','',''),(3827,'21','222','1',1,'Retail Sale Id 3520',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 12:53:42','',''),(3828,'21','222','1',1,'Retail Sale Id 3521',4803.20,0.00,0.00,6.32,0.00,'2022-07-03 12:55:06','',''),(3829,'21','222','1',1,'Retail Sale Id 3522',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 12:56:15','',''),(3830,'21','222','1',1,'Retail Sale Id 3523',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 12:57:40','',''),(3831,'21','222','1',1,'Retail Sale Id 3524',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 12:58:47','',''),(3832,'21','222','1',1,'Retail Sale Id 3525',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 12:59:56','',''),(3833,'21','222','1',1,'Retail Sale Id 3526',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:02:11','',''),(3834,'21','222','1',1,'Retail Sale Id 3527',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 13:05:30','',''),(3835,'21','222','1',1,'Retail Sale Id 3528',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:08:17','',''),(3836,'21','222','1',1,'Retail Sale Id 3529',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 13:10:44','',''),(3837,'21','222','1',1,'Retail Sale Id 3530',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:12:39','',''),(3838,'21','222','1',1,'Retail Sale Id 3531',3997.60,0.00,0.00,5.26,0.00,'2022-07-03 13:13:39','',''),(3839,'21','222','1',1,'Retail Sale Id 3532',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:15:01','',''),(3840,'21','222','1',1,'Retail Sale Id 3533',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:15:44','',''),(3841,'21','222','1',1,'Retail Sale Id 3534',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:16:59','',''),(3842,'21','222','1',1,'Retail Sale Id 3535',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 13:18:06','',''),(3843,'21','222','1',1,'Retail Sale Id 3535',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:18:06','',''),(3844,'21','222','1',1,'Retail Sale Id 3536',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 13:20:04','',''),(3845,'21','222','1',1,'Retail Sale Id 3537',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 13:24:14','',''),(3846,'21','222','1',1,'Retail Sale Id 3538',2500.40,0.00,0.00,3.29,0.00,'2022-07-03 13:25:31','',''),(3847,'21','222','1',1,'Retail Sale Id 3539',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:27:28','',''),(3848,'21','222','1',1,'Retail Sale Id 3540',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 13:30:54','',''),(3849,'21','222','1',1,'Retail Sale Id 3541',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:32:13','',''),(3850,'21','222','1',1,'Retail Sale Id 3542',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 13:33:24','',''),(3851,'21','222','1',1,'Retail Sale Id 3543',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 13:34:09','',''),(3852,'21','222','1',1,'Retail Sale Id 3544',15200.00,0.00,0.00,20.00,0.00,'2022-07-03 13:35:13','',''),(3853,'21','222','1',1,'Retail Sale Id 3545',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 13:37:32','',''),(3854,'21','222','1',1,'Retail Sale Id 3546',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 13:39:08','',''),(3855,'21','222','1',1,'Retail Sale Id 3546',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 13:39:08','',''),(3856,'21','222','1',1,'Retail Sale Id 3547',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 13:40:52','',''),(3857,'21','222','1',1,'Retail Sale Id 3548',798.00,0.00,0.00,1.05,0.00,'2022-07-03 13:44:36','',''),(3858,'21','222','1',1,'Retail Sale Id 3549',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 13:46:36','',''),(3859,'21','222','1',1,'Retail Sale Id 3550',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:47:55','',''),(3860,'21','222','1',1,'Retail Sale Id 3551',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 13:50:02','',''),(3861,'21','222','1',1,'Retail Sale Id 3552',3997.60,0.00,0.00,5.26,0.00,'2022-07-03 13:51:48','',''),(3862,'21','222','1',1,'Retail Sale Id 3553',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:53:35','',''),(3863,'21','222','1',1,'Retail Sale Id 3554',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:54:40','',''),(3864,'21','222','1',1,'Retail Sale Id 3555',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:56:37','',''),(3865,'21','222','1',1,'Retail Sale Id 3556',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 13:59:12','',''),(3866,'21','222','1',1,'Retail Sale Id 3557',3997.60,0.00,0.00,5.26,0.00,'2022-07-03 14:00:47','',''),(3867,'21','222','1',1,'Retail Sale Id 3558',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:01:59','',''),(3868,'21','222','1',1,'Retail Sale Id 3559',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:03:09','',''),(3869,'21','222','1',1,'Retail Sale Id 3560',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 14:05:06','',''),(3870,'21','222','1',1,'Retail Sale Id 3561',6498.00,0.00,0.00,8.55,0.00,'2022-07-03 14:07:16','',''),(3871,'21','222','1',1,'Retail Sale Id 3562',501.60,0.00,0.00,0.66,0.00,'2022-07-03 14:08:18','',''),(3872,'21','222','1',1,'Retail Sale Id 3563',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 14:10:08','',''),(3873,'21','222','1',1,'Retail Sale Id 3564',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:12:51','',''),(3874,'21','222','1',1,'Retail Sale Id 3565',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 14:14:20','',''),(3875,'21','222','1',1,'Retail Sale Id 3565',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 14:14:20','',''),(3876,'21','222','1',1,'Retail Sale Id 3566',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:17:23','',''),(3877,'21','222','1',1,'Retail Sale Id 3567',5996.40,0.00,0.00,7.89,0.00,'2022-07-03 14:19:11','',''),(3878,'21','222','1',1,'Retail Sale Id 3568',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:20:45','',''),(3879,'21','222','1',1,'Retail Sale Id 3569',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 14:31:04','',''),(3880,'21','222','1',1,'Retail Sale Id 3570',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 14:32:39','',''),(3881,'21','222','1',1,'Retail Sale Id 3571',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 14:37:51','',''),(3882,'21','222','1',1,'Retail Sale Id 3571',6999.60,0.00,0.00,9.21,0.00,'2022-07-03 14:37:51','',''),(3883,'21','222','1',1,'Retail Sale Id 3572',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 14:39:53','',''),(3884,'21','222','1',1,'Retail Sale Id 3573',1900.00,0.00,0.00,2.50,0.00,'2022-07-03 14:40:54','',''),(3885,'21','222','1',1,'Retail Sale Id 3574',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:44:30','',''),(3886,'21','222','1',1,'Retail Sale Id 3575',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:45:40','',''),(3887,'21','222','1',1,'Retail Sale Id 3576',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:46:55','',''),(3888,'21','222','1',1,'Retail Sale Id 3577',8496.80,0.00,0.00,11.18,0.00,'2022-07-03 14:48:25','',''),(3889,'21','222','1',1,'Retail Sale Id 3578',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:52:11','',''),(3890,'21','222','1',1,'Retail Sale Id 3578',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 14:52:11','',''),(3891,'21','222','1',1,'Retail Sale Id 3579',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 15:01:32','',''),(3892,'21','222','1',1,'Retail Sale Id 3580',1520.00,0.00,0.00,2.00,0.00,'2022-07-03 15:03:21','',''),(3893,'21','222','1',1,'Retail Sale Id 3581',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 15:29:01','',''),(3894,'21','222','1',1,'Retail Sale Id 3582',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 15:29:46','',''),(3895,'21','222','1',1,'Retail Sale Id 3583',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 15:30:07','',''),(3896,'21','222','1',1,'Retail Sale Id 3584',3997.60,0.00,0.00,5.26,0.00,'2022-07-03 15:31:33','',''),(3897,'21','222','1',1,'Retail Sale Id 3585',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 15:32:28','',''),(3898,'21','222','1',1,'Retail Sale Id 3586',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 15:35:54','',''),(3899,'21','222','1',1,'Retail Sale Id 3587',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 15:36:58','',''),(3900,'21','222','1',1,'Retail Sale Id 3588',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 15:38:42','',''),(3901,'21','222','1',1,'Retail Sale Id 3589',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 15:47:55','',''),(3902,'21','222','1',1,'Retail Sale Id 3590',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 15:49:26','',''),(3903,'21','222','1',1,'Retail Sale Id 3591',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 15:50:28','',''),(3904,'21','222','1',1,'Retail Sale Id 3591',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 15:50:28','',''),(3905,'21','222','1',1,'Retail Sale Id 3592',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 15:51:40','',''),(3906,'21','222','1',1,'Retail Sale Id 3593',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 15:53:23','',''),(3907,'21','222','1',1,'Retail Sale Id 3594',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 15:54:31','',''),(3908,'21','222','1',1,'Retail Sale Id 3595',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 15:55:57','',''),(3909,'21','222','1',1,'Retail Sale Id 3596',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 15:58:10','',''),(3910,'21','222','1',1,'Retail Sale Id 3597',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 16:00:12','',''),(3911,'21','222','1',1,'Retail Sale Id 3598',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 16:02:06','',''),(3912,'21','222','1',1,'Retail Sale Id 3599',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 16:04:44','',''),(3913,'21','222','1',1,'Retail Sale Id 3600',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 16:06:56','',''),(3914,'21','222','1',1,'Retail Sale Id 3601',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 16:09:07','',''),(3915,'21','222','1',1,'Retail Sale Id 3601',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 16:09:07','',''),(3916,'21','222','1',1,'Retail Sale Id 3602',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 16:11:29','',''),(3917,'21','222','1',1,'Retail Sale Id 3602',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 16:11:29','',''),(3918,'21','222','1',1,'Return of Retail Sale Id 3601',0.00,2280.00,3.00,0.00,0.00,'2022-07-03 16:12:36','',''),(3919,'21','222','1',1,'Return of Retail Sale Id 3601',0.00,4560.00,6.00,0.00,0.00,'2022-07-03 16:12:36','',''),(3920,'21','222','1',1,'Retail Sale Id 3603',2302.80,0.00,0.00,3.03,0.00,'2022-07-03 16:13:24','',''),(3921,'21','222','1',1,'Retail Sale Id 3604',6999.60,0.00,0.00,9.21,0.00,'2022-07-03 16:22:02','',''),(3922,'21','222','1',1,'Retail Sale Id 3605',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 16:33:54','',''),(3923,'21','222','1',1,'Retail Sale Id 3606',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 16:40:59','',''),(3924,'21','222','1',1,'Retail Sale Id 3607',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 16:42:41','',''),(3925,'21','222','1',1,'Retail Sale Id 3608',15200.00,0.00,0.00,20.00,0.00,'2022-07-03 16:58:45','',''),(3926,'21','222','1',1,'Retail Sale Id 3609',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:00:50','',''),(3927,'21','222','1',1,'Retail Sale Id 3610',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:02:19','',''),(3928,'21','222','1',1,'Retail Sale Id 3611',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 17:02:50','',''),(3929,'21','222','1',1,'Retail Sale Id 3612',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:03:52','',''),(3930,'21','222','1',1,'Retail Sale Id 3613',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:04:42','',''),(3931,'21','222','1',1,'Retail Sale Id 3614',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:06:09','',''),(3932,'21','222','1',1,'Retail Sale Id 3615',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 17:08:01','',''),(3933,'21','222','1',1,'Retail Sale Id 3616',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:12:09','',''),(3934,'21','222','1',1,'Retail Sale Id 3617',4750.00,0.00,0.00,6.25,0.00,'2022-07-03 17:14:08','',''),(3935,'21','222','1',1,'Retail Sale Id 3618',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:17:25','',''),(3936,'21','222','1',1,'Retail Sale Id 3619',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 17:18:37','',''),(3937,'21','222','1',1,'Retail Sale Id 3620',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:19:43','',''),(3938,'21','222','1',1,'Retail Sale Id 3621',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 17:22:12','',''),(3939,'21','222','1',1,'Retail Sale Id 3622',6999.60,0.00,0.00,9.21,0.00,'2022-07-03 17:23:44','',''),(3940,'21','222','1',1,'Retail Sale Id 3623',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:27:07','',''),(3941,'21','222','1',1,'Retail Sale Id 3624',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 17:32:00','',''),(3942,'21','222','1',1,'Retail Sale Id 3624',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 17:32:00','',''),(3943,'21','222','1',1,'Retail Sale Id 3625',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:34:02','',''),(3944,'21','222','1',1,'Retail Sale Id 3626',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:35:03','',''),(3945,'21','222','1',1,'Retail Sale Id 3627',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:36:16','',''),(3946,'21','222','1',1,'Retail Sale Id 3628',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:38:26','',''),(3947,'21','222','1',1,'Retail Sale Id 3630',501.60,0.00,0.00,0.66,0.00,'2022-07-03 17:41:27','',''),(3948,'21','222','1',1,'Retail Sale Id 3630',501.60,0.00,0.00,0.66,0.00,'2022-07-03 17:41:27','',''),(3949,'21','222','1',1,'Retail Sale Id 3631',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:42:21','',''),(3950,'21','222','1',1,'Retail Sale Id 3632',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 17:43:00','',''),(3951,'21','222','1',1,'Retail Sale Id 3633',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:44:56','',''),(3952,'21','222','1',1,'Retail Sale Id 3634',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 17:45:58','',''),(3953,'21','222','1',1,'Retail Sale Id 3635',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:48:25','',''),(3954,'21','222','1',1,'Retail Sale Id 3636',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 17:50:27','',''),(3955,'21','222','1',1,'Retail Sale Id 3637',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 17:52:24','',''),(3956,'21','222','1',1,'Retail Sale Id 3638',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:53:51','',''),(3957,'21','222','1',1,'Retail Sale Id 3639',3002.00,0.00,0.00,3.95,0.00,'2022-07-03 17:55:38','',''),(3958,'21','222','1',1,'Retail Sale Id 3640',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 17:56:39','',''),(3959,'21','222','1',1,'Retail Sale Id 3641',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 17:57:33','',''),(3960,'21','222','1',1,'Retail Sale Id 3642',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 17:58:09','',''),(3961,'21','222','1',1,'Retail Sale Id 3643',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 17:59:18','',''),(3962,'21','222','1',1,'Retail Sale Id 3644',4803.20,0.00,0.00,6.32,0.00,'2022-07-03 18:01:15','',''),(3963,'21','222','1',1,'Retail Sale Id 3645',3040.00,0.00,0.00,4.00,0.00,'2022-07-03 18:05:02','',''),(3964,'21','222','1',1,'Retail Sale Id 3646',2500.40,0.00,0.00,3.29,0.00,'2022-07-03 18:05:56','',''),(3965,'21','222','1',1,'Retail Sale Id 3647',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 18:11:24','',''),(3966,'21','222','1',1,'Retail Sale Id 3648',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 18:12:09','',''),(3967,'21','222','1',1,'Retail Sale Id 3649',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 18:13:11','',''),(3968,'21','222','1',1,'Retail Sale Id 3650',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 18:17:02','',''),(3969,'21','222','1',1,'Retail Sale Id 3651',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 18:21:45','',''),(3970,'21','222','1',1,'Retail Sale Id 3652',4750.00,0.00,0.00,6.25,0.00,'2022-07-03 18:31:58','',''),(3971,'21','222','1',1,'Retail Sale Id 3653',4750.00,0.00,0.00,6.25,0.00,'2022-07-03 18:34:34','',''),(3972,'21','222','1',1,'Retail Sale Id 3654',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 18:36:50','',''),(3973,'21','222','1',1,'Retail Sale Id 3655',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 18:38:09','',''),(3974,'21','222','1',1,'Retail Sale Id 3656',3800.00,0.00,0.00,5.00,0.00,'2022-07-03 18:40:36','',''),(3975,'21','222','1',1,'Retail Sale Id 3657',8998.40,0.00,0.00,11.84,0.00,'2022-07-03 18:44:25','',''),(3976,'21','222','1',1,'Retail Sale Id 3658',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 18:48:49','',''),(3977,'21','222','1',1,'Retail Sale Id 3659',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 18:52:30','',''),(3978,'21','222','1',1,'Retail Sale Id 3659',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 18:52:30','',''),(3979,'21','222','1',1,'Retail Sale Id 3660',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 18:53:42','',''),(3980,'21','222','1',1,'Retail Sale Id 3661',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 18:54:55','',''),(3981,'21','222','1',1,'Retail Sale Id 3662',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 18:56:52','',''),(3982,'21','222','1',1,'Retail Sale Id 3663',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 19:00:23','',''),(3983,'21','222','1',1,'Retail Sale Id 3664',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 19:02:06','',''),(3984,'21','222','1',1,'Retail Sale Id 3665',2280.00,0.00,0.00,3.00,0.00,'2022-07-03 19:06:48','',''),(3985,'21','222','1',1,'Retail Sale Id 3666',6999.60,0.00,0.00,9.21,0.00,'2022-07-03 19:15:22','',''),(3986,'21','222','1',1,'Retail Sale Id 3667',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 19:27:15','',''),(3987,'21','222','1',1,'Retail Sale Id 3668',1003.20,0.00,0.00,1.32,0.00,'2022-07-03 19:29:46','',''),(3988,'21','222','1',1,'Retail Sale Id 3669',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 19:30:42','',''),(3989,'21','222','1',1,'Retail Sale Id 3670',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 19:32:32','',''),(3990,'21','222','1',1,'Retail Sale Id 3671',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 19:34:17','',''),(3991,'21','222','1',1,'Retail Sale Id 3672',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 19:36:41','',''),(3992,'21','222','1',1,'Retail Sale Id 3673',1998.80,0.00,0.00,2.63,0.00,'2022-07-03 19:40:25','',''),(3993,'21','222','1',1,'Retail Sale Id 3674',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 19:42:14','',''),(3994,'21','222','1',1,'Retail Sale Id 3675',1497.20,0.00,0.00,1.97,0.00,'2022-07-03 19:47:14','',''),(3995,'21','222','1',1,'Retail Sale Id 3676',7600.00,0.00,0.00,10.00,0.00,'2022-07-03 20:53:01','',''),(3996,'21','222','1',1,'Retail Sale Id 3676',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 20:53:01','',''),(3997,'21','222','1',1,'Retail Sale Id 3677',4560.00,0.00,0.00,6.00,0.00,'2022-07-03 20:53:35','',''),(3998,'21','222','1',1,'Retail Sale Id 3677',19000.00,0.00,0.00,25.00,0.00,'2022-07-03 20:53:35','',''),(3999,'21','222','1',1,'Retail Sale Id 3678',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 20:54:07','',''),(4000,'21','222','1',1,'Retail Sale Id 3678',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 20:54:07','',''),(4001,'21','222','1',1,'Retail Sale Id 3679',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 20:54:27','',''),(4002,'21','222','1',1,'Retail Sale Id 3680',24996.40,0.00,0.00,32.89,0.00,'2022-07-03 20:55:09','',''),(4003,'21','222','1',1,'Retail Sale Id 3681',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 20:56:10','',''),(4004,'21','222','1',1,'Retail Sale Id 3681',9500.00,0.00,0.00,12.50,0.00,'2022-07-03 20:56:10','',''),(4005,'21','222','1',1,'Retail Sale Id 3682',19000.00,0.00,0.00,25.00,0.00,'2022-07-03 20:59:00','',''),(4006,'21','222','1',1,'Retail Sale Id 3683',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 20:59:46','',''),(4007,'21','222','1',1,'Retail Sale Id 3683',38000.00,0.00,0.00,50.00,0.00,'2022-07-03 20:59:46','',''),(4008,'21','222','1',1,'Retail Sale Id 3684',11400.00,0.00,0.00,15.00,0.00,'2022-07-03 21:00:38','',''),(4009,'21','222','1',1,'Retail Sale Id 3685',6999.60,0.00,0.00,9.21,0.00,'2022-07-03 21:01:21','',''),(4010,'21','222','1',1,'Retail Sale Id 3686',95000.00,0.00,0.00,125.00,0.00,'2022-07-04 15:12:02','',''),(4011,'21','222','1',1,'Retail Sale Id 3687',38000.00,0.00,0.00,50.00,0.00,'2022-07-04 16:20:10','',''),(4012,'21','222','1',1,'Retail Sale Id 3689',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 16:24:22','',''),(4013,'21','222','1',1,'Retail Sale Id 3691',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 17:17:30','',''),(4014,'21','222','1',1,'Retail Sale Id 3692',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 17:24:57','',''),(4015,'21','222','1',1,'Retail Sale Id 3693',38000.00,0.00,0.00,50.00,0.00,'2022-07-04 18:42:54','',''),(4016,'21','222','1',1,'Retail Sale Id 3694',152000.00,0.00,0.00,200.00,0.00,'2022-07-04 18:44:03','',''),(4017,'21','222','1',1,'Retail Sale Id 3695',38000.00,0.00,0.00,50.00,0.00,'2022-07-04 18:44:59','',''),(4018,'21','222','1',1,'Retail Sale Id 3696',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 18:46:07','',''),(4019,'21','222','1',1,'Retail Sale Id 3697',64600.00,0.00,0.00,85.00,0.00,'2022-07-04 18:47:52','',''),(4020,'21','222','1',1,'Retail Sale Id 3699',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 18:49:44','',''),(4021,'21','222','1',1,'Retail Sale Id 3700',140600.00,0.00,0.00,185.00,0.00,'2022-07-04 18:50:55','',''),(4022,'21','222','1',1,'Retail Sale Id 3701',19000.00,0.00,0.00,25.00,0.00,'2022-07-04 18:53:39','',''),(4023,'21','222','1',1,'Retail Sale Id 3702',9500.00,0.00,0.00,12.50,0.00,'2022-07-04 18:54:42','',''),(4024,'21','222','1',1,'Retail Sale Id 3703',38000.00,0.00,0.00,50.00,0.00,'2022-07-04 18:56:02','',''),(4025,'21','222','1',1,'Retail Sale Id 3704',38000.00,0.00,0.00,50.00,0.00,'2022-07-04 19:33:19','',''),(4026,'21','222','1',1,'Retail Sale Id 3705',136800.00,0.00,0.00,180.00,0.00,'2022-07-04 19:34:35','',''),(4027,'21','222','1',1,'Retail Sale Id 3706',19410.40,0.00,0.00,25.54,0.00,'2022-07-04 19:36:30','',''),(4028,'21','222','1',1,'Retail Sale Id 3707',3040.00,0.00,0.00,4.00,0.00,'2022-07-09 06:09:39','',''),(4029,'21','222','1',1,'Retail Sale Id 3707',3040.00,0.00,0.00,4.00,0.00,'2022-07-09 06:09:39','',''),(4030,'21','222','1',1,'Retail Sale Id 3708',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:11:36','',''),(4031,'21','222','1',1,'Retail Sale Id 3708',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:11:36','',''),(4032,'21','222','1',1,'Retail Sale Id 3709',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:12:50','',''),(4033,'21','222','1',1,'Retail Sale Id 3709',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:12:50','',''),(4034,'21','222','1',1,'Retail Sale Id 3710',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:16:43','',''),(4035,'21','222','1',1,'Retail Sale Id 3710',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:16:43','',''),(4036,'21','222','1',1,'Retail Sale Id 3711',3800.00,0.00,0.00,5.00,0.00,'2022-07-09 06:17:58','',''),(4037,'21','222','1',1,'Retail Sale Id 3711',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:17:58','',''),(4038,'21','222','1',1,'Retail Sale Id 3712',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:19:14','',''),(4039,'21','222','1',1,'Retail Sale Id 3712',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:19:14','',''),(4040,'21','222','1',1,'Retail Sale Id 3713',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:20:59','',''),(4041,'21','222','1',1,'Retail Sale Id 3713',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:20:59','',''),(4042,'21','222','1',1,'Retail Sale Id 3713',9120.00,0.00,0.00,12.00,0.00,'2022-07-09 06:20:59','',''),(4043,'21','222','1',1,'Retail Sale Id 3714',4560.00,0.00,0.00,6.00,0.00,'2022-07-09 06:22:51','',''),(4044,'21','222','1',1,'Retail Sale Id 3714',4560.00,0.00,0.00,6.00,0.00,'2022-07-09 06:22:51','',''),(4045,'21','222','1',1,'Retail Sale Id 3715',4560.00,0.00,0.00,6.00,0.00,'2022-07-09 06:24:48','',''),(4046,'21','222','1',1,'Retail Sale Id 3715',9500.00,0.00,0.00,12.50,0.00,'2022-07-09 06:24:48','',''),(4047,'21','222','1',1,'Retail Sale Id 3715',9500.00,0.00,0.00,12.50,0.00,'2022-07-09 06:24:48','',''),(4048,'21','222','1',1,'Retail Sale Id 3716',19000.00,0.00,0.00,25.00,0.00,'2022-07-09 06:26:28','',''),(4049,'21','222','1',1,'Retail Sale Id 3716',19000.00,0.00,0.00,25.00,0.00,'2022-07-09 06:26:28','',''),(4050,'21','222','1',1,'Retail Sale Id 3716',19000.00,0.00,0.00,25.00,0.00,'2022-07-09 06:26:28','',''),(4051,'21','222','1',1,'Retail Sale Id 3717',38000.00,0.00,0.00,50.00,0.00,'2022-07-09 06:28:43','',''),(4052,'21','222','1',1,'Retail Sale Id 3717',38000.00,0.00,0.00,50.00,0.00,'2022-07-09 06:28:43','',''),(4053,'21','222','1',1,'Retail Sale Id 3720',38000.00,0.00,0.00,50.00,0.00,'2022-07-09 06:31:23','',''),(4054,'21','222',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,1.00,0.00,'2022-07-09 06:35:52','',''),(4055,'21','222','1',1,'Received from bridging 23',0.00,0.00,1.00,0.00,0.00,'2022-07-09 06:35:52','',''),(4056,'21','222','1',1,'Retail Sale Id 3721',896.80,0.00,0.00,1.18,0.00,'2022-07-09 06:37:27','',''),(4057,'21','222',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,329.00,0.00,'2022-07-09 06:53:54','',''),(4058,'21','222','1',1,'Received from bridging 24',0.00,0.00,329.00,0.00,0.00,'2022-07-09 06:53:54','',''),(4059,'21','222','1',1,'Retail Sale Id 3724',38000.00,0.00,0.00,50.00,0.00,'2022-07-09 06:54:01','',''),(4060,'21','222','1',1,'Retail Sale Id 3725',152000.00,0.00,0.00,200.00,0.00,'2022-07-09 06:55:05','',''),(4061,'21','222',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,1.00,0.00,'2022-07-09 06:57:43','',''),(4062,'21','222','1',1,'Received from bridging 25',0.00,0.00,1.00,0.00,0.00,'2022-07-09 06:57:43','',''),(4063,'21','222','1',1,'Retail Sale Id 3726',60800.00,0.00,0.00,80.00,0.00,'2022-07-09 06:57:49','',''),(4064,'21','222',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,50.00,0.00,'2022-07-09 06:59:32','',''),(4065,'21','222','1',1,'Received from bridging 26',0.00,0.00,50.00,0.00,0.00,'2022-07-09 06:59:32','',''),(4066,'21','222','1',1,'Retail Sale Id 3727',38000.00,0.00,0.00,50.00,0.00,'2022-07-09 07:01:00','',''),(4067,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2432000.00,3200.00,0.00,0.00,'2022-07-10 10:21:17','',''),(4068,'21','222',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,3200.00,0.00,'2022-07-10 10:22:29','',''),(4069,'21','222','1',1,'Received from bridging 27',0.00,0.00,3200.00,0.00,0.00,'2022-07-10 10:22:29','',''),(4070,'21','222','1',1,'Retail Sale Id 3729',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:42:43','',''),(4071,'21','222','1',1,'Retail Sale Id 3730',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:43:45','',''),(4072,'21','222','1',1,'Retail Sale Id 3731',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:44:36','',''),(4073,'21','222','1',1,'Retail Sale Id 3732',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:45:59','',''),(4074,'21','222','1',1,'Retail Sale Id 3733',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:47:01','',''),(4075,'21','222','1',1,'Retail Sale Id 3734',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:48:31','',''),(4076,'21','222','1',1,'Retail Sale Id 3735',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:49:37','',''),(4077,'21','222','1',1,'Retail Sale Id 3736',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:50:40','',''),(4078,'21','222','1',1,'Retail Sale Id 3737',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:52:02','',''),(4079,'21','222','1',1,'Retail Sale Id 3738',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 10:53:01','',''),(4080,'21','222','1',1,'Retail Sale Id 3739',14394.40,0.00,0.00,18.94,0.00,'2022-07-10 10:54:40','',''),(4081,'21','222','1',1,'Retail Sale Id 3740',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 10:58:01','',''),(4082,'21','222','1',1,'Retail Sale Id 3741',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 10:58:45','',''),(4083,'21','222','1',1,'Retail Sale Id 3742',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 10:59:31','',''),(4084,'21','222','1',1,'Retail Sale Id 3743',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 11:00:21','',''),(4085,'21','222','1',1,'Retail Sale Id 3744',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:01:17','',''),(4086,'21','222','1',1,'Retail Sale Id 3745',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:02:04','',''),(4087,'21','222','1',1,'Retail Sale Id 3746',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:02:46','',''),(4088,'21','222','1',1,'Retail Sale Id 3747',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:03:27','',''),(4089,'21','222','1',1,'Retail Sale Id 3748',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 11:05:06','',''),(4090,'21','222','1',1,'Retail Sale Id 3749',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:05:56','',''),(4091,'21','222','1',1,'Retail Sale Id 3750',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:06:51','',''),(4092,'21','222','1',1,'Retail Sale Id 3751',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 11:08:55','',''),(4093,'21','222','1',1,'Return of Retail Sale Id 3751',0.00,38000.00,50.00,0.00,0.00,'2022-07-10 11:09:43','',''),(4094,'21','222','1',1,'Retail Sale Id 3752',26904.00,0.00,0.00,35.40,0.00,'2022-07-10 11:11:04','',''),(4095,'21','222','1',1,'Retail Sale Id 3753',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 11:13:42','',''),(4096,'21','222','1',1,'Retail Sale Id 3754',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 11:14:27','',''),(4097,'21','222','1',1,'Retail Sale Id 3755',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 11:15:13','',''),(4098,'21','222','1',1,'Retail Sale Id 3756',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:16:06','',''),(4099,'21','222','1',1,'Retail Sale Id 3757',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:18:30','',''),(4100,'21','222','1',1,'Retail Sale Id 3757',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 11:18:30','',''),(4101,'21','222','1',1,'Retail Sale Id 3757',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 11:18:30','',''),(4102,'21','222','1',1,'Retail Sale Id 3757',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:18:30','',''),(4103,'21','222','1',1,'Retail Sale Id 3758',9120.00,0.00,0.00,12.00,0.00,'2022-07-10 11:20:22','',''),(4104,'21','222','1',1,'Retail Sale Id 3758',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 11:20:22','',''),(4105,'21','222','1',1,'Retail Sale Id 3758',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:20:22','',''),(4106,'21','222','1',1,'Retail Sale Id 3759',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 11:21:25','',''),(4107,'21','222','1',1,'Retail Sale Id 3759',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:21:25','',''),(4108,'21','222','1',1,'Return of Retail Sale Id 3759',0.00,38000.00,50.00,0.00,0.00,'2022-07-10 11:22:53','',''),(4109,'21','222','1',1,'Return of Retail Sale Id 3759',0.00,60800.00,80.00,0.00,0.00,'2022-07-10 11:22:53','',''),(4110,'21','222','1',1,'Return of Retail Sale Id 3756',0.00,60800.00,80.00,0.00,0.00,'2022-07-10 11:31:52','',''),(4111,'21','222','1',1,'Retail Sale Id 3760',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 11:33:07','',''),(4112,'21','222','1',1,'Retail Sale Id 3760',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 11:33:07','',''),(4113,'21','222','1',1,'Retail Sale Id 3761',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 11:35:01','',''),(4114,'21','222','1',1,'Retail Sale Id 3762',15732.00,0.00,0.00,20.70,0.00,'2022-07-10 11:36:24','',''),(4115,'21','222','1',1,'Retail Sale Id 3763',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 11:43:18','',''),(4116,'21','222','1',1,'Retail Sale Id 3763',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 11:43:18','',''),(4117,'21','222','1',1,'Retail Sale Id 3764',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:44:49','',''),(4118,'21','222','1',1,'Retail Sale Id 3764',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:44:49','',''),(4119,'21','222','1',1,'Retail Sale Id 3764',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:44:49','',''),(4120,'21','222','1',1,'Retail Sale Id 3765',2280.00,0.00,0.00,3.00,0.00,'2022-07-10 11:47:03','',''),(4121,'21','222','1',1,'Retail Sale Id 3765',2280.00,0.00,0.00,3.00,0.00,'2022-07-10 11:47:03','',''),(4122,'21','222','1',1,'Retail Sale Id 3765',4560.00,0.00,0.00,6.00,0.00,'2022-07-10 11:47:03','',''),(4123,'21','222','1',1,'Retail Sale Id 3765',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:47:03','',''),(4124,'21','222','1',1,'Retail Sale Id 3766',1140.00,0.00,0.00,1.50,0.00,'2022-07-10 11:48:24','',''),(4125,'21','222','1',1,'Retail Sale Id 3766',2280.00,0.00,0.00,3.00,0.00,'2022-07-10 11:48:24','',''),(4126,'21','222','1',1,'Retail Sale Id 3766',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:48:24','',''),(4127,'21','222','1',1,'Retail Sale Id 3766',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 11:48:24','',''),(4128,'21','222',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,2.42,0.00,'2022-07-10 11:50:17','',''),(4129,'21','222','1',1,'Received from bridging 28',0.00,0.00,2.42,0.00,0.00,'2022-07-10 11:50:17','',''),(4130,'21','222','1',1,'Retail Sale Id 3767',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:51:37','',''),(4131,'21','222','1',1,'Retail Sale Id 3767',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:51:37','',''),(4132,'21','222','1',1,'Retail Sale Id 3767',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:51:37','',''),(4133,'21','222','1',1,'Retail Sale Id 3768',3359.20,0.00,0.00,4.42,0.00,'2022-07-10 11:53:30','',''),(4134,'21','222','1',1,'Retail Sale Id 3768',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 11:53:30','',''),(4135,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-07-10 13:59:22','',''),(4136,'21','222',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,4999.00,0.00,'2022-07-10 14:01:39','',''),(4137,'21','222','1',1,'Received from bridging 30',0.00,0.00,4999.00,0.00,0.00,'2022-07-10 14:01:39','',''),(4138,'21','222','1',1,'Retail Sale Id 3769',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:05:55','',''),(4139,'21','222','1',1,'Retail Sale Id 3769',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 14:05:55','',''),(4140,'21','222','1',1,'Retail Sale Id 3769',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:05:55','',''),(4141,'21','222','1',1,'Retail Sale Id 3770',3040.00,0.00,0.00,4.00,0.00,'2022-07-10 14:07:22','',''),(4142,'21','222','1',1,'Retail Sale Id 3770',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:07:22','',''),(4143,'21','222','1',1,'Retail Sale Id 3770',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:07:22','',''),(4144,'21','222','1',1,'Retail Sale Id 3771',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:10:11','',''),(4145,'21','222','1',1,'Retail Sale Id 3771',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:10:11','',''),(4146,'21','222','1',1,'Retail Sale Id 3771',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:10:11','',''),(4147,'21','222','1',1,'Retail Sale Id 3772',2280.00,0.00,0.00,3.00,0.00,'2022-07-10 14:12:03','',''),(4148,'21','222','1',1,'Retail Sale Id 3772',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:12:03','',''),(4149,'21','222','1',1,'Retail Sale Id 3772',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:12:03','',''),(4150,'21','222','1',1,'Retail Sale Id 3773',3040.00,0.00,0.00,4.00,0.00,'2022-07-10 14:12:57','',''),(4151,'21','222','1',1,'Retail Sale Id 3773',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:12:57','',''),(4152,'21','222','1',1,'Retail Sale Id 3773',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 14:12:57','',''),(4153,'21','222','1',1,'Retail Sale Id 3774',3040.00,0.00,0.00,4.00,0.00,'2022-07-10 14:14:07','',''),(4154,'21','222','1',1,'Retail Sale Id 3774',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:14:07','',''),(4155,'21','222','1',1,'Retail Sale Id 3774',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:14:07','',''),(4156,'21','222','1',1,'Retail Sale Id 3774',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:14:07','',''),(4157,'21','222','1',1,'Retail Sale Id 3775',3298.40,0.00,0.00,4.34,0.00,'2022-07-10 14:15:23','',''),(4158,'21','222','1',1,'Retail Sale Id 3776',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:19:07','',''),(4159,'21','222','1',1,'Retail Sale Id 3776',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:19:07','',''),(4160,'21','222','1',1,'Retail Sale Id 3776',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 14:19:07','',''),(4161,'21','222','1',1,'Retail Sale Id 3777',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:21:11','',''),(4162,'21','222','1',1,'Retail Sale Id 3777',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:21:11','',''),(4163,'21','222','1',1,'Retail Sale Id 3777',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:21:11','',''),(4164,'21','222','1',1,'Retail Sale Id 3778',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:23:37','',''),(4165,'21','222','1',1,'Retail Sale Id 3778',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:23:37','',''),(4166,'21','222','1',1,'Retail Sale Id 3778',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:23:37','',''),(4167,'21','222','1',1,'Retail Sale Id 3778',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 14:23:37','',''),(4168,'21','222','1',1,'Retail Sale Id 3779',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:24:56','',''),(4169,'21','222','1',1,'Retail Sale Id 3779',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:24:56','',''),(4170,'21','222','1',1,'Retail Sale Id 3779',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:24:56','',''),(4171,'21','222','1',1,'Retail Sale Id 3780',3040.00,0.00,0.00,4.00,0.00,'2022-07-10 14:26:33','',''),(4172,'21','222','1',1,'Retail Sale Id 3780',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:26:33','',''),(4173,'21','222','1',1,'Retail Sale Id 3780',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 14:26:33','',''),(4174,'21','222','1',1,'Retail Sale Id 3780',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 14:26:33','',''),(4175,'21','222','1',1,'Retail Sale Id 3781',3040.00,0.00,0.00,4.00,0.00,'2022-07-10 14:28:37','',''),(4176,'21','222','1',1,'Retail Sale Id 3781',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:28:37','',''),(4177,'21','222','1',1,'Retail Sale Id 3781',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 14:28:37','',''),(4178,'21','222','1',1,'Retail Sale Id 3781',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:28:37','',''),(4179,'21','222','1',1,'Retail Sale Id 3782',3040.00,0.00,0.00,4.00,0.00,'2022-07-10 14:29:43','',''),(4180,'21','222','1',1,'Retail Sale Id 3782',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:29:43','',''),(4181,'21','222','1',1,'Retail Sale Id 3782',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 14:29:43','',''),(4182,'21','222','1',1,'Retail Sale Id 3782',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 14:29:43','',''),(4183,'21','222','1',1,'Retail Sale Id 3783',3040.00,0.00,0.00,4.00,0.00,'2022-07-10 14:31:23','',''),(4184,'21','222','1',1,'Retail Sale Id 3783',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:31:23','',''),(4185,'21','222','1',1,'Retail Sale Id 3783',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 14:31:23','',''),(4186,'21','222','1',1,'Retail Sale Id 3783',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:31:23','',''),(4187,'21','222','1',1,'Retail Sale Id 3784',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:32:41','',''),(4188,'21','222','1',1,'Retail Sale Id 3784',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 14:32:41','',''),(4189,'21','222','1',1,'Retail Sale Id 3784',38000.00,0.00,0.00,50.00,0.00,'2022-07-10 14:32:41','',''),(4190,'21','222','1',1,'Retail Sale Id 3784',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:32:41','',''),(4191,'21','222','1',1,'Retail Sale Id 3785',9500.00,0.00,0.00,12.50,0.00,'2022-07-10 14:34:17','',''),(4192,'21','222','1',1,'Retail Sale Id 3785',22800.00,0.00,0.00,30.00,0.00,'2022-07-10 14:34:17','',''),(4193,'21','222','1',1,'Retail Sale Id 3785',60800.00,0.00,0.00,80.00,0.00,'2022-07-10 14:34:17','',''),(4194,'21','222','1',1,'Retail Sale Id 3785',152000.00,0.00,0.00,200.00,0.00,'2022-07-10 14:34:17','',''),(4195,'21','222','1',1,'Retail Sale Id 3786',13094.80,0.00,0.00,17.23,0.00,'2022-07-10 14:35:49','',''),(4196,'21','222','1',1,'Retail Sale Id 3787',2280.00,0.00,0.00,3.00,0.00,'2022-07-13 14:27:51','',''),(4197,'21','222','1',1,'Retail Sale Id 3787',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 14:27:51','',''),(4198,'21','222','1',1,'Retail Sale Id 3787',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 14:27:51','',''),(4199,'21','222','1',1,'Retail Sale Id 3788',3040.00,0.00,0.00,4.00,0.00,'2022-07-13 14:31:08','',''),(4200,'21','222','1',1,'Retail Sale Id 3788',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:31:08','',''),(4201,'21','222','1',1,'Retail Sale Id 3788',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:31:08','',''),(4202,'21','222','1',1,'Retail Sale Id 3789',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 14:33:19','',''),(4203,'21','222','1',1,'Retail Sale Id 3789',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 14:33:19','',''),(4204,'21','222','1',1,'Retail Sale Id 3790',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:34:16','',''),(4205,'21','222','1',1,'Retail Sale Id 3790',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 14:34:16','',''),(4206,'21','222','1',1,'Retail Sale Id 3791',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:35:39','',''),(4207,'21','222','1',1,'Retail Sale Id 3791',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 14:35:39','',''),(4208,'21','222','1',1,'Retail Sale Id 3792',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:37:37','',''),(4209,'21','222','1',1,'Retail Sale Id 3792',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 14:37:37','',''),(4210,'21','222','1',1,'Retail Sale Id 3793',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:38:53','',''),(4211,'21','222','1',1,'Retail Sale Id 3793',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 14:38:53','',''),(4212,'21','222','1',1,'Retail Sale Id 3794',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:40:03','',''),(4213,'21','222','1',1,'Retail Sale Id 3794',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:40:03','',''),(4214,'21','222','1',1,'Retail Sale Id 3795',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:41:46','',''),(4215,'21','222','1',1,'Retail Sale Id 3795',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 14:41:46','',''),(4216,'21','222','1',1,'Retail Sale Id 3796',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 14:43:21','',''),(4217,'21','222','1',1,'Retail Sale Id 3796',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 14:43:21','',''),(4218,'21','222','1',1,'Retail Sale Id 3796',152000.00,0.00,0.00,200.00,0.00,'2022-07-13 14:43:21','',''),(4219,'21','222','1',1,'Retail Sale Id 3797',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:44:25','',''),(4220,'21','222','1',1,'Retail Sale Id 3797',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 14:44:25','',''),(4221,'21','222','1',1,'Retail Sale Id 3797',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 14:44:25','',''),(4222,'21','222','1',1,'Retail Sale Id 3798',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 14:52:09','',''),(4223,'21','222','1',1,'Retail Sale Id 3799',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 14:54:45','',''),(4224,'21','222','1',1,'Retail Sale Id 3799',60800.00,0.00,0.00,80.00,0.00,'2022-07-13 14:54:45','',''),(4225,'21','222','1',1,'Retail Sale Id 3800',60800.00,0.00,0.00,80.00,0.00,'2022-07-13 14:57:17','',''),(4226,'21','222','1',1,'Retail Sale Id 3800',60800.00,0.00,0.00,80.00,0.00,'2022-07-13 14:57:17','',''),(4227,'21','222','1',1,'Retail Sale Id 3801',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 18:28:50','',''),(4228,'21','222','1',1,'Retail Sale Id 3801',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 18:28:50','',''),(4229,'21','222','1',1,'Retail Sale Id 3802',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 18:30:20','',''),(4230,'21','222','1',1,'Retail Sale Id 3802',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 18:30:20','',''),(4231,'21','222','1',1,'Retail Sale Id 3802',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 18:30:20','',''),(4232,'21','222','1',1,'Retail Sale Id 3803',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 18:31:39','',''),(4233,'21','222','1',1,'Retail Sale Id 3803',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 18:31:39','',''),(4234,'21','222','1',1,'Retail Sale Id 3803',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 18:31:39','',''),(4235,'21','222','1',1,'Retail Sale Id 3804',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 18:32:36','',''),(4236,'21','222','1',1,'Retail Sale Id 3804',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 18:32:36','',''),(4237,'21','222','1',1,'Retail Sale Id 3804',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 18:32:36','',''),(4238,'21','222','1',1,'Retail Sale Id 3805',2280.00,0.00,0.00,3.00,0.00,'2022-07-13 18:34:55','',''),(4239,'21','222','1',1,'Retail Sale Id 3805',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 18:34:55','',''),(4240,'21','222','1',1,'Retail Sale Id 3805',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 18:34:55','',''),(4241,'21','222','1',1,'Retail Sale Id 3805',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 18:34:55','',''),(4242,'21','222','1',1,'Retail Sale Id 3806',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 18:36:58','',''),(4243,'21','222','1',1,'Retail Sale Id 3806',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 18:36:58','',''),(4244,'21','222','1',1,'Retail Sale Id 3806',60800.00,0.00,0.00,80.00,0.00,'2022-07-13 18:36:58','',''),(4245,'21','222','1',1,'Retail Sale Id 3807',6938.80,0.00,0.00,9.13,0.00,'2022-07-13 18:38:33','',''),(4246,'21','222','1',1,'Retail Sale Id 3808',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:32:23','',''),(4247,'21','222','1',1,'Retail Sale Id 3808',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 19:32:23','',''),(4248,'21','222','1',1,'Retail Sale Id 3808',60800.00,0.00,0.00,80.00,0.00,'2022-07-13 19:32:23','',''),(4249,'21','222','1',1,'Retail Sale Id 3809',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:33:29','',''),(4250,'21','222','1',1,'Retail Sale Id 3809',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:33:29','',''),(4251,'21','222','1',1,'Retail Sale Id 3809',60800.00,0.00,0.00,80.00,0.00,'2022-07-13 19:33:29','',''),(4252,'21','222','1',1,'Retail Sale Id 3810',2280.00,0.00,0.00,3.00,0.00,'2022-07-13 19:34:54','',''),(4253,'21','222','1',1,'Retail Sale Id 3810',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:34:54','',''),(4254,'21','222','1',1,'Retail Sale Id 3810',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:34:54','',''),(4255,'21','222','1',1,'Retail Sale Id 3811',3040.00,0.00,0.00,4.00,0.00,'2022-07-13 19:35:54','',''),(4256,'21','222','1',1,'Retail Sale Id 3811',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:35:54','',''),(4257,'21','222','1',1,'Retail Sale Id 3811',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:35:54','',''),(4258,'21','222','1',1,'Retail Sale Id 3812',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:36:36','',''),(4259,'21','222','1',1,'Retail Sale Id 3812',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:36:36','',''),(4260,'21','222','1',1,'Retail Sale Id 3813',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:37:51','',''),(4261,'21','222','1',1,'Retail Sale Id 3813',60800.00,0.00,0.00,80.00,0.00,'2022-07-13 19:37:51','',''),(4262,'21','222','1',1,'Retail Sale Id 3814',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 19:38:31','',''),(4263,'21','222','1',1,'Retail Sale Id 3814',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 19:38:31','',''),(4264,'21','222','1',1,'Retail Sale Id 3815',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:39:40','',''),(4265,'21','222','1',1,'Retail Sale Id 3815',60800.00,0.00,0.00,80.00,0.00,'2022-07-13 19:39:40','',''),(4266,'21','222','1',1,'Retail Sale Id 3816',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:41:02','',''),(4267,'21','222','1',1,'Retail Sale Id 3816',38000.00,0.00,0.00,50.00,0.00,'2022-07-13 19:41:02','',''),(4268,'21','222','1',1,'Retail Sale Id 3818',3040.00,0.00,0.00,4.00,0.00,'2022-07-13 19:44:08','',''),(4269,'21','222','1',1,'Retail Sale Id 3818',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:44:08','',''),(4270,'21','222','1',1,'Retail Sale Id 3818',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:44:08','',''),(4271,'21','222','1',1,'Retail Sale Id 3819',2280.00,0.00,0.00,3.00,0.00,'2022-07-13 19:46:19','',''),(4272,'21','222','1',1,'Retail Sale Id 3819',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:46:19','',''),(4273,'21','222','1',1,'Retail Sale Id 3819',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:46:19','',''),(4274,'21','222','1',1,'Retail Sale Id 3820',9013.60,0.00,0.00,11.86,0.00,'2022-07-13 19:50:42','',''),(4275,'21','222','1',1,'Retail Sale Id 3820',22800.00,0.00,0.00,30.00,0.00,'2022-07-13 19:50:42','',''),(4276,'21','222','1',1,'Retail Sale Id 3821',2280.00,0.00,0.00,3.00,0.00,'2022-07-13 19:57:38','',''),(4277,'21','222','1',1,'Retail Sale Id 3821',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:57:38','',''),(4278,'21','222','1',1,'Retail Sale Id 3821',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 19:57:38','',''),(4279,'21','222','1',1,'Retail Sale Id 3822',2280.00,0.00,0.00,3.00,0.00,'2022-07-13 20:03:17','',''),(4280,'21','222','1',1,'Retail Sale Id 3822',3040.00,0.00,0.00,4.00,0.00,'2022-07-13 20:03:17','',''),(4281,'21','222','1',1,'Retail Sale Id 3822',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 20:03:17','',''),(4282,'21','222','1',1,'Retail Sale Id 3823',3040.00,0.00,0.00,4.00,0.00,'2022-07-13 20:05:06','',''),(4283,'21','222','1',1,'Retail Sale Id 3823',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 20:05:06','',''),(4284,'21','222','1',1,'Retail Sale Id 3824',3040.00,0.00,0.00,4.00,0.00,'2022-07-13 20:06:40','',''),(4285,'21','222','1',1,'Retail Sale Id 3824',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 20:06:40','',''),(4286,'21','222','1',1,'Retail Sale Id 3825',2280.00,0.00,0.00,3.00,0.00,'2022-07-13 20:07:59','',''),(4287,'21','222','1',1,'Retail Sale Id 3825',3040.00,0.00,0.00,4.00,0.00,'2022-07-13 20:07:59','',''),(4288,'21','222','1',1,'Retail Sale Id 3825',4560.00,0.00,0.00,6.00,0.00,'2022-07-13 20:07:59','',''),(4289,'21','222','1',1,'Retail Sale Id 3826',2280.00,0.00,0.00,3.00,0.00,'2022-07-13 20:09:17','',''),(4290,'21','222','1',1,'Retail Sale Id 3826',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 20:09:17','',''),(4291,'21','222','1',1,'Retail Sale Id 3826',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 20:09:17','',''),(4294,'21','222',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,1.00,0.00,'2022-07-13 20:12:56','',''),(4295,'21','222','1',1,'Received from bridging 31',0.00,0.00,1.00,0.00,0.00,'2022-07-13 20:12:56','',''),(4299,'21','222',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,1.00,0.00,'2022-07-13 20:38:38','',''),(4300,'21','222','1',1,'Received from bridging 32',0.00,0.00,1.00,0.00,0.00,'2022-07-13 20:38:38','',''),(4301,'21','222','1',1,'Retail Sale Id 3829',6657.60,0.00,0.00,8.76,0.00,'2022-07-13 20:38:59','',''),(4302,'21','222','1',1,'Retail Sale Id 3829',9500.00,0.00,0.00,12.50,0.00,'2022-07-13 20:38:59','',''),(4303,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3838000.00,5050.00,0.00,0.00,'2022-07-14 15:07:31','',''),(4304,'21','222',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,4999.22,0.00,'2022-07-14 15:10:03','',''),(4305,'21','222','1',1,'Received from bridging 33',0.00,0.00,4999.22,0.00,0.00,'2022-07-14 15:10:03','',''),(4306,'21','222','1',1,'Retail Sale Id 3830',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:12:57','',''),(4307,'21','222','1',1,'Retail Sale Id 3830',60800.00,0.00,0.00,80.00,0.00,'2022-07-14 15:12:57','',''),(4308,'21','222','1',1,'Retail Sale Id 3830',152000.00,0.00,0.00,200.00,0.00,'2022-07-14 15:12:57','',''),(4309,'21','222','1',1,'Retail Sale Id 3831',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:15:00','',''),(4310,'21','222','1',1,'Retail Sale Id 3831',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:15:00','',''),(4311,'21','222','1',1,'Retail Sale Id 3831',38000.00,0.00,0.00,50.00,0.00,'2022-07-14 15:15:00','',''),(4312,'21','222','1',1,'Retail Sale Id 3831',60800.00,0.00,0.00,80.00,0.00,'2022-07-14 15:15:00','',''),(4313,'21','222','1',1,'Retail Sale Id 3832',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:15:51','',''),(4314,'21','222','1',1,'Retail Sale Id 3832',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:15:51','',''),(4315,'21','222','1',1,'Retail Sale Id 3832',60800.00,0.00,0.00,80.00,0.00,'2022-07-14 15:15:51','',''),(4316,'21','222','1',1,'Retail Sale Id 3833',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:18:03','',''),(4317,'21','222','1',1,'Retail Sale Id 3833',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:18:03','',''),(4318,'21','222','1',1,'Retail Sale Id 3833',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:18:03','',''),(4319,'21','222','1',1,'Retail Sale Id 3834',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:19:33','',''),(4320,'21','222','1',1,'Retail Sale Id 3834',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:19:33','',''),(4321,'21','222','1',1,'Retail Sale Id 3834',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:19:33','',''),(4322,'21','222','1',1,'Retail Sale Id 3835',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:20:38','',''),(4323,'21','222','1',1,'Retail Sale Id 3835',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:20:38','',''),(4324,'21','222','1',1,'Retail Sale Id 3835',38000.00,0.00,0.00,50.00,0.00,'2022-07-14 15:20:38','',''),(4325,'21','222','1',1,'Retail Sale Id 3836',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:28:21','',''),(4326,'21','222','1',1,'Retail Sale Id 3836',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:28:21','',''),(4327,'21','222','1',1,'Retail Sale Id 3836',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:28:21','',''),(4328,'21','222','1',1,'Retail Sale Id 3837',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:29:25','',''),(4329,'21','222','1',1,'Retail Sale Id 3837',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:29:25','',''),(4330,'21','222','1',1,'Retail Sale Id 3837',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:29:25','',''),(4331,'21','222','1',1,'Retail Sale Id 3837',38000.00,0.00,0.00,50.00,0.00,'2022-07-14 15:29:25','',''),(4332,'21','222','1',1,'Retail Sale Id 3838',3739.20,0.00,0.00,4.92,0.00,'2022-07-14 15:31:14','',''),(4333,'21','222','1',1,'Retail Sale Id 3838',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:31:14','',''),(4334,'21','222','1',1,'Retail Sale Id 3839',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:33:42','',''),(4335,'21','222','1',1,'Retail Sale Id 3839',38000.00,0.00,0.00,50.00,0.00,'2022-07-14 15:33:42','',''),(4336,'21','222','1',1,'Retail Sale Id 3840',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:36:12','',''),(4337,'21','222','1',1,'Retail Sale Id 3840',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:36:12','',''),(4338,'21','222','1',1,'Retail Sale Id 3840',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:36:12','',''),(4339,'21','222','1',1,'Retail Sale Id 3841',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:38:17','',''),(4340,'21','222','1',1,'Retail Sale Id 3841',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:38:17','',''),(4341,'21','222','1',1,'Retail Sale Id 3841',38000.00,0.00,0.00,50.00,0.00,'2022-07-14 15:38:17','',''),(4342,'21','222','1',1,'Retail Sale Id 3842',3040.00,0.00,0.00,4.00,0.00,'2022-07-14 15:40:11','',''),(4343,'21','222','1',1,'Retail Sale Id 3842',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:40:11','',''),(4344,'21','222','1',1,'Retail Sale Id 3842',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:40:11','',''),(4345,'21','222','1',1,'Retail Sale Id 3843',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:41:29','',''),(4346,'21','222','1',1,'Retail Sale Id 3843',38000.00,0.00,0.00,50.00,0.00,'2022-07-14 15:41:29','',''),(4347,'21','222','1',1,'Retail Sale Id 3843',60800.00,0.00,0.00,80.00,0.00,'2022-07-14 15:41:29','',''),(4348,'21','222','1',1,'Retail Sale Id 3844',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:42:15','',''),(4349,'21','222','1',1,'Retail Sale Id 3844',38000.00,0.00,0.00,50.00,0.00,'2022-07-14 15:42:15','',''),(4350,'21','222','1',1,'Retail Sale Id 3844',60800.00,0.00,0.00,80.00,0.00,'2022-07-14 15:42:15','',''),(4351,'21','222','1',1,'Retail Sale Id 3845',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:42:58','',''),(4352,'21','222','1',1,'Retail Sale Id 3845',38000.00,0.00,0.00,50.00,0.00,'2022-07-14 15:42:58','',''),(4353,'21','222','1',1,'Retail Sale Id 3845',60800.00,0.00,0.00,80.00,0.00,'2022-07-14 15:42:58','',''),(4354,'21','222','1',1,'Retail Sale Id 3846',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:44:07','',''),(4355,'21','222','1',1,'Retail Sale Id 3846',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:44:07','',''),(4356,'21','222','1',1,'Retail Sale Id 3846',60800.00,0.00,0.00,80.00,0.00,'2022-07-14 15:44:07','',''),(4357,'21','222','1',1,'Retail Sale Id 3847',3040.00,0.00,0.00,4.00,0.00,'2022-07-14 15:45:22','',''),(4358,'21','222','1',1,'Retail Sale Id 3847',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:45:22','',''),(4359,'21','222','1',1,'Retail Sale Id 3847',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:45:23','',''),(4360,'21','222','1',1,'Retail Sale Id 3847',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:45:23','',''),(4361,'21','222','1',1,'Retail Sale Id 3848',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:46:28','',''),(4362,'21','222','1',1,'Retail Sale Id 3848',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:46:28','',''),(4363,'21','222','1',1,'Retail Sale Id 3848',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:46:28','',''),(4364,'21','222','1',1,'Retail Sale Id 3849',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:48:13','',''),(4365,'21','222','1',1,'Retail Sale Id 3849',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:48:13','',''),(4366,'21','222','1',1,'Retail Sale Id 3849',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:48:13','',''),(4367,'21','222','1',1,'Retail Sale Id 3850',2865.20,0.00,0.00,3.77,0.00,'2022-07-14 15:49:48','',''),(4368,'21','222','1',1,'Retail Sale Id 3850',9500.00,0.00,0.00,12.50,0.00,'2022-07-14 15:49:48','',''),(4369,'21','222','1',1,'Retail Sale Id 3850',22800.00,0.00,0.00,30.00,0.00,'2022-07-14 15:49:48','',''),(4370,'21','222','1',1,'Retail Sale Id 3851',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:03:51','',''),(4371,'21','222','1',1,'Retail Sale Id 3851',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 18:03:51','',''),(4372,'21','222','1',1,'Retail Sale Id 3851',60800.00,0.00,0.00,80.00,0.00,'2022-07-15 18:03:51','',''),(4373,'21','222','1',1,'Retail Sale Id 3852',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:04:43','',''),(4374,'21','222','1',1,'Retail Sale Id 3852',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:04:43','',''),(4375,'21','222','1',1,'Retail Sale Id 3852',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:04:43','',''),(4376,'21','222','1',1,'Retail Sale Id 3853',3040.00,0.00,0.00,4.00,0.00,'2022-07-15 18:05:57','',''),(4377,'21','222','1',1,'Retail Sale Id 3853',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:05:57','',''),(4378,'21','222','1',1,'Retail Sale Id 3853',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:05:57','',''),(4379,'21','222','1',1,'Retail Sale Id 3854',4560.00,0.00,0.00,6.00,0.00,'2022-07-15 18:06:52','',''),(4380,'21','222','1',1,'Retail Sale Id 3854',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:06:52','',''),(4381,'21','222','1',1,'Retail Sale Id 3854',19000.00,0.00,0.00,25.00,0.00,'2022-07-15 18:06:52','',''),(4382,'21','222','1',1,'Retail Sale Id 3855',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:07:47','',''),(4383,'21','222','1',1,'Retail Sale Id 3855',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:07:47','',''),(4384,'21','222','1',1,'Retail Sale Id 3855',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:07:47','',''),(4385,'21','222','1',1,'Retail Sale Id 3856',3040.00,0.00,0.00,4.00,0.00,'2022-07-15 18:09:17','',''),(4386,'21','222','1',1,'Retail Sale Id 3856',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:09:17','',''),(4387,'21','222','1',1,'Retail Sale Id 3856',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:09:17','',''),(4388,'21','222','1',1,'Retail Sale Id 3857',3040.00,0.00,0.00,4.00,0.00,'2022-07-15 18:10:18','',''),(4389,'21','222','1',1,'Retail Sale Id 3857',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:10:18','',''),(4390,'21','222','1',1,'Retail Sale Id 3857',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:10:18','',''),(4391,'21','222','1',1,'Retail Sale Id 3858',3040.00,0.00,0.00,4.00,0.00,'2022-07-15 18:11:21','',''),(4392,'21','222','1',1,'Retail Sale Id 3858',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:11:21','',''),(4393,'21','222','1',1,'Retail Sale Id 3858',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:11:21','',''),(4394,'21','222','1',1,'Retail Sale Id 3860',3040.00,0.00,0.00,4.00,0.00,'2022-07-15 18:13:29','',''),(4395,'21','222','1',1,'Retail Sale Id 3860',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:13:29','',''),(4396,'21','222','1',1,'Retail Sale Id 3860',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:13:29','',''),(4397,'21','222','1',1,'Retail Sale Id 3861',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:14:20','',''),(4398,'21','222','1',1,'Retail Sale Id 3861',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:14:20','',''),(4399,'21','222','1',1,'Retail Sale Id 3861',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:14:20','',''),(4400,'21','222','1',1,'Retail Sale Id 3862',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:15:17','',''),(4401,'21','222','1',1,'Retail Sale Id 3862',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:15:17','',''),(4402,'21','222','1',1,'Retail Sale Id 3862',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:15:17','',''),(4403,'21','222','1',1,'Retail Sale Id 3863',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:16:03','',''),(4404,'21','222','1',1,'Retail Sale Id 3863',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:16:03','',''),(4405,'21','222','1',1,'Retail Sale Id 3863',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 18:16:03','',''),(4406,'21','222','1',1,'Retail Sale Id 3864',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:16:56','',''),(4407,'21','222','1',1,'Retail Sale Id 3864',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:16:56','',''),(4408,'21','222','1',1,'Retail Sale Id 3864',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:16:56','',''),(4409,'21','222','1',1,'Retail Sale Id 3865',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:17:47','',''),(4410,'21','222','1',1,'Retail Sale Id 3865',38000.00,0.00,0.00,50.00,0.00,'2022-07-15 18:17:47','',''),(4411,'21','222','1',1,'Retail Sale Id 3866',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:19:36','',''),(4412,'21','222','1',1,'Retail Sale Id 3866',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:19:36','',''),(4413,'21','222','1',1,'Retail Sale Id 3866',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:19:36','',''),(4414,'21','222','1',1,'Retail Sale Id 3867',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:21:18','',''),(4415,'21','222','1',1,'Retail Sale Id 3867',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:21:18','',''),(4416,'21','222','1',1,'Retail Sale Id 3867',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:21:18','',''),(4417,'21','222','1',1,'Retail Sale Id 3868',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:22:13','',''),(4418,'21','222','1',1,'Retail Sale Id 3868',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:22:13','',''),(4419,'21','222','1',1,'Retail Sale Id 3868',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:22:13','',''),(4420,'21','222','1',1,'Retail Sale Id 3869',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:23:37','',''),(4421,'21','222','1',1,'Retail Sale Id 3869',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:23:37','',''),(4422,'21','222','1',1,'Retail Sale Id 3869',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:23:37','',''),(4423,'21','222','1',1,'Retail Sale Id 3870',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:24:31','',''),(4424,'21','222','1',1,'Retail Sale Id 3870',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:24:31','',''),(4425,'21','222','1',1,'Retail Sale Id 3870',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:24:31','',''),(4426,'21','222','1',1,'Retail Sale Id 3871',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:25:32','',''),(4427,'21','222','1',1,'Retail Sale Id 3871',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:25:32','',''),(4428,'21','222','1',1,'Retail Sale Id 3871',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:25:32','',''),(4429,'21','222','1',1,'Retail Sale Id 3872',1786.00,0.00,0.00,2.35,0.00,'2022-07-15 18:27:37','',''),(4430,'21','222','1',1,'Retail Sale Id 3872',9500.00,0.00,0.00,12.50,0.00,'2022-07-15 18:27:37','',''),(4431,'21','222','1',1,'Retail Sale Id 3872',22800.00,0.00,0.00,30.00,0.00,'2022-07-15 18:27:37','',''),(4432,'21','222','1',1,'Retail Sale Id 3873',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:24:51','',''),(4433,'21','222','1',1,'Retail Sale Id 3873',38000.00,0.00,0.00,50.00,0.00,'2022-07-16 14:24:51','',''),(4434,'21','222','1',1,'Retail Sale Id 3873',60800.00,0.00,0.00,80.00,0.00,'2022-07-16 14:24:51','',''),(4435,'21','222','1',1,'Retail Sale Id 3874',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:25:56','',''),(4436,'21','222','1',1,'Retail Sale Id 3874',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:25:56','',''),(4437,'21','222','1',1,'Retail Sale Id 3874',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 14:25:56','',''),(4438,'21','222','1',1,'Retail Sale Id 3875',3040.00,0.00,0.00,4.00,0.00,'2022-07-16 14:27:16','',''),(4439,'21','222','1',1,'Retail Sale Id 3875',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:27:16','',''),(4440,'21','222','1',1,'Retail Sale Id 3875',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:27:16','',''),(4441,'21','222','1',1,'Retail Sale Id 3875',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 14:27:16','',''),(4442,'21','222','1',1,'Retail Sale Id 3876',3040.00,0.00,0.00,4.00,0.00,'2022-07-16 14:28:34','',''),(4443,'21','222','1',1,'Retail Sale Id 3876',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:28:34','',''),(4444,'21','222','1',1,'Retail Sale Id 3876',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:28:34','',''),(4445,'21','222','1',1,'Retail Sale Id 3876',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 14:28:34','',''),(4446,'21','222','1',1,'Retail Sale Id 3877',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:29:38','',''),(4447,'21','222','1',1,'Retail Sale Id 3877',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:29:38','',''),(4448,'21','222','1',1,'Retail Sale Id 3877',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 14:29:38','',''),(4449,'21','222','1',1,'Retail Sale Id 3878',3040.00,0.00,0.00,4.00,0.00,'2022-07-16 14:30:40','',''),(4450,'21','222','1',1,'Retail Sale Id 3878',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:30:40','',''),(4451,'21','222','1',1,'Retail Sale Id 3878',38000.00,0.00,0.00,50.00,0.00,'2022-07-16 14:30:40','',''),(4452,'21','222','1',1,'Retail Sale Id 3879',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:31:41','',''),(4453,'21','222','1',1,'Retail Sale Id 3879',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:31:41','',''),(4454,'21','222','1',1,'Retail Sale Id 3879',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 14:31:41','',''),(4455,'21','222','1',1,'Retail Sale Id 3880',3040.00,0.00,0.00,4.00,0.00,'2022-07-16 14:33:25','',''),(4456,'21','222','1',1,'Retail Sale Id 3880',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:33:25','',''),(4457,'21','222','1',1,'Retail Sale Id 3880',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 14:33:25','',''),(4458,'21','222','1',1,'Retail Sale Id 3881',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:34:48','',''),(4459,'21','222','1',1,'Retail Sale Id 3881',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 14:34:48','',''),(4460,'21','222','1',1,'Retail Sale Id 3882',3040.00,0.00,0.00,4.00,0.00,'2022-07-16 14:36:08','',''),(4461,'21','222','1',1,'Retail Sale Id 3882',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:36:08','',''),(4462,'21','222','1',1,'Retail Sale Id 3882',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 14:36:08','',''),(4463,'21','222','1',1,'Retail Sale Id 3882',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 14:36:08','',''),(4464,'21','222','1',1,'Retail Sale Id 3883',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:18:17','',''),(4465,'21','222','1',1,'Retail Sale Id 3883',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:18:17','',''),(4466,'21','222','1',1,'Retail Sale Id 3883',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 15:18:17','',''),(4467,'21','222','1',1,'Retail Sale Id 3884',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:19:22','',''),(4468,'21','222','1',1,'Retail Sale Id 3884',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 15:19:22','',''),(4469,'21','222','1',1,'Retail Sale Id 3884',38000.00,0.00,0.00,50.00,0.00,'2022-07-16 15:19:22','',''),(4470,'21','222','1',1,'Retail Sale Id 3885',3040.00,0.00,0.00,4.00,0.00,'2022-07-16 15:20:37','',''),(4471,'21','222','1',1,'Retail Sale Id 3885',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:20:37','',''),(4472,'21','222','1',1,'Retail Sale Id 3885',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:20:37','',''),(4473,'21','222','1',1,'Retail Sale Id 3885',38000.00,0.00,0.00,50.00,0.00,'2022-07-16 15:20:37','',''),(4474,'21','222','1',1,'Retail Sale Id 3886',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:21:36','',''),(4475,'21','222','1',1,'Retail Sale Id 3886',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 15:21:36','',''),(4476,'21','222','1',1,'Retail Sale Id 3886',38000.00,0.00,0.00,50.00,0.00,'2022-07-16 15:21:36','',''),(4477,'21','222','1',1,'Retail Sale Id 3887',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 15:22:51','',''),(4478,'21','222','1',1,'Retail Sale Id 3887',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 15:22:51','',''),(4479,'21','222','1',1,'Retail Sale Id 3887',38000.00,0.00,0.00,50.00,0.00,'2022-07-16 15:22:51','',''),(4480,'21','222','1',1,'Retail Sale Id 3888',4940.00,0.00,0.00,6.50,0.00,'2022-07-16 15:25:00','',''),(4481,'21','222','1',1,'Retail Sale Id 3888',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:25:00','',''),(4482,'21','222','1',1,'Retail Sale Id 3888',9500.00,0.00,0.00,12.50,0.00,'2022-07-16 15:25:00','',''),(4483,'21','222','1',1,'Retail Sale Id 3888',22800.00,0.00,0.00,30.00,0.00,'2022-07-16 15:25:00','',''),(4484,'21','222','1',1,'Retail Sale Id 3889',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:24:57','',''),(4485,'21','222','1',1,'Retail Sale Id 3889',22800.00,0.00,0.00,30.00,0.00,'2022-07-18 06:24:57','',''),(4486,'21','222','1',1,'Retail Sale Id 3890',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:25:45','',''),(4487,'21','222','1',1,'Retail Sale Id 3890',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:25:45','',''),(4488,'21','222','1',1,'Retail Sale Id 3891',3040.00,0.00,0.00,4.00,0.00,'2022-07-18 06:27:04','',''),(4489,'21','222','1',1,'Retail Sale Id 3891',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:27:04','',''),(4490,'21','222','1',1,'Retail Sale Id 3891',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:27:04','',''),(4491,'21','222','1',1,'Retail Sale Id 3892',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:28:36','',''),(4492,'21','222','1',1,'Retail Sale Id 3892',38000.00,0.00,0.00,50.00,0.00,'2022-07-18 06:28:36','',''),(4493,'21','222','1',1,'Retail Sale Id 3894',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:31:03','',''),(4494,'21','222','1',1,'Retail Sale Id 3894',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:31:03','',''),(4495,'21','222','1',1,'Retail Sale Id 3894',22800.00,0.00,0.00,30.00,0.00,'2022-07-18 06:31:03','',''),(4496,'21','222','1',1,'Retail Sale Id 3895',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:32:18','',''),(4497,'21','222','1',1,'Retail Sale Id 3895',22800.00,0.00,0.00,30.00,0.00,'2022-07-18 06:32:18','',''),(4498,'21','222','1',1,'Retail Sale Id 3895',38000.00,0.00,0.00,50.00,0.00,'2022-07-18 06:32:18','',''),(4499,'21','222','1',1,'Retail Sale Id 3896',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:34:08','',''),(4500,'21','222','1',1,'Retail Sale Id 3896',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:34:08','',''),(4501,'21','222','1',1,'Retail Sale Id 3896',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:34:08','',''),(4502,'21','222','1',1,'Retail Sale Id 3896',38000.00,0.00,0.00,50.00,0.00,'2022-07-18 06:34:08','',''),(4503,'21','222','1',1,'Retail Sale Id 3897',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:35:42','',''),(4504,'21','222','1',1,'Retail Sale Id 3897',22800.00,0.00,0.00,30.00,0.00,'2022-07-18 06:35:42','',''),(4505,'21','222','1',1,'Retail Sale Id 3898',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:36:51','',''),(4506,'21','222','1',1,'Retail Sale Id 3898',38000.00,0.00,0.00,50.00,0.00,'2022-07-18 06:36:51','',''),(4507,'21','222','1',1,'Retail Sale Id 3899',5867.20,0.00,0.00,7.72,0.00,'2022-07-18 06:38:47','',''),(4508,'21','222','1',1,'Retail Sale Id 3899',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:38:47','',''),(4509,'21','222','1',1,'Retail Sale Id 3899',9500.00,0.00,0.00,12.50,0.00,'2022-07-18 06:38:47','',''),(4510,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-07-19 14:37:08','',''),(4511,'21','222',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,4979.76,0.00,'2022-07-19 14:41:03','',''),(4512,'21','222','1',1,'Received from bridging 34',0.00,0.00,4979.76,0.00,0.00,'2022-07-19 14:41:03','',''),(4513,'21','222','1',1,'Retail Sale Id 3900',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 14:44:16','',''),(4514,'21','222','1',1,'Retail Sale Id 3901',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 14:46:29','',''),(4515,'21','222','1',1,'Retail Sale Id 3902',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 14:49:15','',''),(4516,'21','222','1',1,'Retail Sale Id 3903',1520.00,0.00,0.00,2.00,0.00,'2022-07-19 14:51:23','',''),(4517,'21','222','1',1,'Retail Sale Id 3904',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 14:53:12','',''),(4518,'21','222','1',1,'Retail Sale Id 3905',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 14:55:21','',''),(4519,'21','222','1',1,'Retail Sale Id 3906',3002.00,0.00,0.00,3.95,0.00,'2022-07-19 14:56:54','',''),(4520,'21','222','1',1,'Retail Sale Id 3907',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 14:58:48','',''),(4521,'21','222','1',1,'Retail Sale Id 3908',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 14:59:59','',''),(4522,'21','222','1',1,'Retail Sale Id 3909',38000.00,0.00,0.00,50.00,0.00,'2022-07-19 15:02:04','',''),(4523,'21','222','1',1,'Retail Sale Id 3910',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 15:04:10','',''),(4524,'21','222','1',1,'Retail Sale Id 3911',7501.20,0.00,0.00,9.87,0.00,'2022-07-19 15:07:29','',''),(4525,'21','222','1',1,'Retail Sale Id 3912',1140.00,0.00,0.00,1.50,0.00,'2022-07-19 15:08:14','',''),(4526,'21','222','1',1,'Retail Sale Id 3913',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 15:11:22','',''),(4527,'21','222','1',1,'Retail Sale Id 3914',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 15:17:32','',''),(4528,'21','222','1',1,'Retail Sale Id 3915',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 15:20:25','',''),(4529,'21','222','1',1,'Retail Sale Id 3916',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 15:23:27','',''),(4530,'21','222','1',1,'Retail Sale Id 3917',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 15:24:51','',''),(4531,'21','222','1',1,'Retail Sale Id 3918',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 15:26:06','',''),(4532,'21','222','1',1,'Retail Sale Id 3919',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 15:28:02','',''),(4533,'21','222','1',1,'Retail Sale Id 3920',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 15:29:47','',''),(4534,'21','222','1',1,'Retail Sale Id 3921',3040.00,0.00,0.00,4.00,0.00,'2022-07-19 15:34:16','',''),(4535,'21','222','1',1,'Retail Sale Id 3922',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 15:37:19','',''),(4536,'21','222','1',1,'Retail Sale Id 3923',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 15:38:39','',''),(4537,'21','222','1',1,'Retail Sale Id 3924',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 15:43:31','',''),(4538,'21','222','1',1,'Retail Sale Id 3924',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 15:43:31','',''),(4539,'21','222','1',1,'Retail Sale Id 3925',3997.60,0.00,0.00,5.26,0.00,'2022-07-19 15:46:44','',''),(4540,'21','222','1',1,'Retail Sale Id 3925',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 15:46:44','',''),(4541,'21','222','1',1,'Retail Sale Id 3926',12752.80,0.00,0.00,16.78,0.00,'2022-07-19 15:50:08','',''),(4542,'21','222','1',1,'Retail Sale Id 3927',12122.00,0.00,0.00,15.95,0.00,'2022-07-19 15:52:25','',''),(4543,'21','222','1',1,'Retail Sale Id 3928',760.00,0.00,0.00,1.00,0.00,'2022-07-19 15:53:22','',''),(4544,'21','222','1',1,'Retail Sale Id 3929',4750.00,0.00,0.00,6.25,0.00,'2022-07-19 15:56:20','',''),(4545,'21','222','1',1,'Retail Sale Id 3929',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 15:56:20','',''),(4546,'21','222','1',1,'Retail Sale Id 3930',4750.00,0.00,0.00,6.25,0.00,'2022-07-19 15:58:00','',''),(4547,'21','222','1',1,'Retail Sale Id 3931',3002.00,0.00,0.00,3.95,0.00,'2022-07-19 15:59:32','',''),(4548,'21','222','1',1,'Retail Sale Id 3932',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 16:01:16','',''),(4549,'21','222','1',1,'Retail Sale Id 3933',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 16:02:57','',''),(4550,'21','222','1',1,'Retail Sale Id 3934',3002.00,0.00,0.00,3.95,0.00,'2022-07-19 16:04:26','',''),(4551,'21','222','1',1,'Retail Sale Id 3935',20276.80,0.00,0.00,26.68,0.00,'2022-07-19 16:08:30','',''),(4552,'21','222','1',1,'Retail Sale Id 3936',1603.60,0.00,0.00,2.11,0.00,'2022-07-19 16:10:59','',''),(4553,'21','222','1',1,'Retail Sale Id 3937',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 16:14:40','',''),(4554,'21','222','1',1,'Retail Sale Id 3938',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 16:17:58','',''),(4555,'21','222','1',1,'Retail Sale Id 3939',3997.60,0.00,0.00,5.26,0.00,'2022-07-19 16:19:53','',''),(4556,'21','222','1',1,'Retail Sale Id 3940',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 16:21:39','',''),(4557,'21','222','1',1,'Retail Sale Id 3941',1497.20,0.00,0.00,1.97,0.00,'2022-07-19 16:22:55','',''),(4558,'21','222','1',1,'Retail Sale Id 3942',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 16:24:14','',''),(4559,'21','222','1',1,'Retail Sale Id 3943',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 16:27:24','',''),(4560,'21','222','1',1,'Retail Sale Id 3944',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 16:30:58','',''),(4561,'21','222','1',1,'Retail Sale Id 3944',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 16:30:58','',''),(4562,'21','222','1',1,'Retail Sale Id 3945',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 16:33:14','',''),(4563,'21','222','1',1,'Retail Sale Id 3946',14500.80,0.00,0.00,19.08,0.00,'2022-07-19 16:35:44','',''),(4564,'21','222','1',1,'Retail Sale Id 3947',2280000.00,0.00,0.00,3000.00,0.00,'2022-07-19 16:37:04','',''),(4565,'21','222','1',1,'Retail Sale Id 3948',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 16:41:11','',''),(4566,'21','222','1',1,'Retail Sale Id 3949',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 16:49:19','',''),(4567,'21','222','1',1,'Retail Sale Id 3950',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 16:51:32','',''),(4568,'21','222','1',1,'Retail Sale Id 3951',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 16:54:46','',''),(4569,'21','222','1',1,'Retail Sale Id 3951',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 16:54:46','',''),(4570,'21','222','1',1,'Retail Sale Id 3952',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 16:57:56','',''),(4571,'21','222','1',1,'Retail Sale Id 3954',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:10:08','',''),(4572,'21','222','1',1,'Retail Sale Id 3955',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 17:11:48','',''),(4573,'21','222','1',1,'Retail Sale Id 3956',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:14:48','',''),(4574,'21','222','1',1,'Retail Sale Id 3957',4750.00,0.00,0.00,6.25,0.00,'2022-07-19 17:17:16','',''),(4575,'21','222','1',1,'Retail Sale Id 3958',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 17:26:05','',''),(4576,'21','222','1',1,'Retail Sale Id 3959',3002.00,0.00,0.00,3.95,0.00,'2022-07-19 17:29:35','',''),(4577,'21','222','1',1,'Retail Sale Id 3960',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 17:36:31','',''),(4578,'21','222','1',1,'Retail Sale Id 3961',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 17:37:32','',''),(4579,'21','222','1',1,'Retail Sale Id 3962',1520.00,0.00,0.00,2.00,0.00,'2022-07-19 17:48:15','',''),(4580,'21','222','1',1,'Retail Sale Id 3963',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:49:41','',''),(4581,'21','222','1',1,'Retail Sale Id 3964',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:51:53','',''),(4582,'21','222','1',1,'Retail Sale Id 3965',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:53:02','',''),(4583,'21','222','1',1,'Retail Sale Id 3966',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 17:54:31','',''),(4584,'21','222','1',1,'Retail Sale Id 3967',3997.60,0.00,0.00,5.26,0.00,'2022-07-19 17:55:33','',''),(4585,'21','222','1',1,'Retail Sale Id 3968',3002.00,0.00,0.00,3.95,0.00,'2022-07-19 18:07:40','',''),(4586,'21','222','1',1,'Retail Sale Id 3969',896.80,0.00,0.00,1.18,0.00,'2022-07-19 18:08:53','',''),(4587,'21','222','1',1,'Retail Sale Id 3970',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 18:10:52','',''),(4588,'21','222','1',1,'Retail Sale Id 3971',3040.00,0.00,0.00,4.00,0.00,'2022-07-19 18:12:28','',''),(4589,'21','222','1',1,'Retail Sale Id 3972',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 18:14:27','',''),(4590,'21','222','1',1,'Retail Sale Id 3973',3997.60,0.00,0.00,5.26,0.00,'2022-07-19 18:18:31','',''),(4591,'21','222','1',1,'Retail Sale Id 3974',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 18:20:07','',''),(4592,'21','222','1',1,'Retail Sale Id 3975',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 18:23:18','',''),(4593,'21','222','1',1,'Retail Sale Id 3976',3800.00,0.00,0.00,5.00,0.00,'2022-07-19 18:25:05','',''),(4594,'21','222','1',1,'Retail Sale Id 3977',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 18:26:22','',''),(4595,'21','222','1',1,'Retail Sale Id 3978',8998.40,0.00,0.00,11.84,0.00,'2022-07-19 18:35:52','',''),(4596,'21','222','1',1,'Retail Sale Id 3979',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 18:38:27','',''),(4597,'21','222','1',1,'Retail Sale Id 3980',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 18:43:13','',''),(4598,'21','222','1',1,'Retail Sale Id 3981',3503.60,0.00,0.00,4.61,0.00,'2022-07-19 18:45:44','',''),(4599,'21','222','1',1,'Retail Sale Id 3982',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 18:47:24','',''),(4600,'21','222','1',1,'Retail Sale Id 3983',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 18:48:50','',''),(4601,'21','222','1',1,'Retail Sale Id 3984',1299.60,0.00,0.00,1.71,0.00,'2022-07-19 18:51:31','',''),(4602,'21','222','1',1,'Retail Sale Id 3985',3040.00,0.00,0.00,4.00,0.00,'2022-07-19 18:57:15','',''),(4603,'21','222','1',1,'Retail Sale Id 3986',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 19:01:10','',''),(4604,'21','222','1',1,'Retail Sale Id 3987',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 19:04:20','',''),(4605,'21','222','1',1,'Retail Sale Id 3988',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 19:06:01','',''),(4606,'21','222','1',1,'Retail Sale Id 3989',3002.00,0.00,0.00,3.95,0.00,'2022-07-19 19:07:44','',''),(4607,'21','222','1',1,'Retail Sale Id 3990',3997.60,0.00,0.00,5.26,0.00,'2022-07-19 19:09:18','',''),(4608,'21','222','1',1,'Retail Sale Id 3991',1003.20,0.00,0.00,1.32,0.00,'2022-07-19 19:10:53','',''),(4609,'21','222','1',1,'Retail Sale Id 3992',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 19:12:31','',''),(4610,'21','222','1',1,'Retail Sale Id 3993',7600.00,0.00,0.00,10.00,0.00,'2022-07-19 19:15:02','',''),(4611,'21','222','1',1,'Retail Sale Id 3994',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 19:16:24','',''),(4612,'21','222','1',1,'Retail Sale Id 3995',2500.40,0.00,0.00,3.29,0.00,'2022-07-19 19:18:25','',''),(4613,'21','222','1',1,'Retail Sale Id 3996',5000.80,0.00,0.00,6.58,0.00,'2022-07-19 19:20:15','',''),(4614,'21','222','1',1,'Retail Sale Id 3997',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 19:24:56','',''),(4615,'21','222','1',1,'Retail Sale Id 3998',1998.80,0.00,0.00,2.63,0.00,'2022-07-19 19:26:44','',''),(4616,'21','222','1',1,'Retail Sale Id 3999',15200.00,0.00,0.00,20.00,0.00,'2022-07-19 19:30:49','',''),(4617,'21','222','1',1,'Retail Sale Id 4000',2280.00,0.00,0.00,3.00,0.00,'2022-07-19 19:32:06','',''),(4618,'21','222','1',1,'Return of Retail Sale Id 3935',0.00,20276.80,26.68,0.00,0.00,'2022-07-19 19:34:30','',''),(4619,'21','222','1',1,'Retail Sale Id 4001',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 19:35:11','',''),(4620,'21','222','1',1,'Retail Sale Id 4002',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 19:38:12','',''),(4621,'21','222','1',1,'Retail Sale Id 4003',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 19:39:07','',''),(4622,'21','222','1',1,'Retail Sale Id 4004',5320.00,0.00,0.00,7.00,0.00,'2022-07-19 19:40:14','',''),(4623,'21','222','1',1,'Retail Sale Id 4005',4560.00,0.00,0.00,6.00,0.00,'2022-07-19 19:41:06','',''),(4624,'21','222','1',1,'Retail Sale Id 4006',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 19:42:13','',''),(4625,'21','222','1',1,'Retail Sale Id 4007',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 19:45:17','',''),(4626,'21','222','1',1,'Retail Sale Id 4008',9500.00,0.00,0.00,12.50,0.00,'2022-07-19 19:46:14','',''),(4627,'21','222','1',1,'Return of Retail Sale Id 3900',0.00,7600.00,10.00,0.00,0.00,'2022-07-20 10:21:25','',''),(4628,'21','222','1',1,'Return of Retail Sale Id 3947',0.00,2280000.00,3000.00,0.00,0.00,'2022-07-20 10:22:45','',''),(4629,'21','222','1',1,'Retail Sale Id 4009',5054.00,0.00,0.00,6.65,0.00,'2022-07-20 10:26:57','',''),(4630,'21','222','1',1,'Retail Sale Id 4009',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 10:26:57','',''),(4631,'21','222','1',1,'Retail Sale Id 4009',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 10:26:57','',''),(4632,'21','222','1',1,'Retail Sale Id 4009',152000.00,0.00,0.00,200.00,0.00,'2022-07-20 10:26:57','',''),(4633,'21','222','1',1,'Retail Sale Id 4009',152000.00,0.00,0.00,200.00,0.00,'2022-07-20 10:26:57','',''),(4634,'21','222','1',1,'Retail Sale Id 4009',152000.00,0.00,0.00,200.00,0.00,'2022-07-20 10:26:57','',''),(4635,'21','222','1',1,'Return of Retail Sale Id 4009',0.00,5054.00,6.65,0.00,0.00,'2022-07-20 10:33:14','',''),(4636,'21','222','1',1,'Return of Retail Sale Id 4009',0.00,38000.00,50.00,0.00,0.00,'2022-07-20 10:33:14','',''),(4637,'21','222','1',1,'Return of Retail Sale Id 4009',0.00,38000.00,50.00,0.00,0.00,'2022-07-20 10:33:14','',''),(4638,'21','222','1',1,'Return of Retail Sale Id 4009',0.00,152000.00,200.00,0.00,0.00,'2022-07-20 10:33:14','',''),(4639,'21','222','1',1,'Return of Retail Sale Id 4009',0.00,152000.00,200.00,0.00,0.00,'2022-07-20 10:33:14','',''),(4640,'21','222','1',1,'Return of Retail Sale Id 4009',0.00,152000.00,200.00,0.00,0.00,'2022-07-20 10:33:14','',''),(4641,'21','222','1',1,'Retail Sale Id 4010',4894.40,0.00,0.00,6.44,0.00,'2022-07-20 10:35:19','',''),(4642,'21','222','1',1,'Retail Sale Id 4010',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 10:35:19','',''),(4643,'21','222','1',1,'Retail Sale Id 4010',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 10:35:19','',''),(4644,'21','222','1',1,'Retail Sale Id 4010',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 10:35:19','',''),(4645,'21','222','1',1,'Retail Sale Id 4010',152000.00,0.00,0.00,200.00,0.00,'2022-07-20 10:35:19','',''),(4646,'21','222','1',1,'Retail Sale Id 4010',152000.00,0.00,0.00,200.00,0.00,'2022-07-20 10:35:19','',''),(4647,'21','222','1',1,'Retail Sale Id 4011',3997.60,0.00,0.00,5.26,0.00,'2022-07-20 10:41:34','',''),(4648,'21','222','1',1,'Retail Sale Id 4012',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 10:46:43','',''),(4649,'21','222','1',1,'Retail Sale Id 4013',1003.20,0.00,0.00,1.32,0.00,'2022-07-20 10:48:23','',''),(4650,'21','222','1',1,'Retail Sale Id 4014',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 10:51:47','',''),(4651,'21','222','1',1,'Retail Sale Id 4015',3997.60,0.00,0.00,5.26,0.00,'2022-07-20 10:53:25','',''),(4652,'21','222','1',1,'Retail Sale Id 4016',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 10:54:35','',''),(4653,'21','222','1',1,'Retail Sale Id 4017',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 10:55:47','',''),(4654,'21','222','1',1,'Retail Sale Id 4018',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 10:56:37','',''),(4655,'21','222','1',1,'Retail Sale Id 4019',4499.20,0.00,0.00,5.92,0.00,'2022-07-20 10:57:31','',''),(4656,'21','222','1',1,'Retail Sale Id 4020',5000.80,0.00,0.00,6.58,0.00,'2022-07-20 10:58:18','',''),(4657,'21','222','1',1,'Retail Sale Id 4021',10001.60,0.00,0.00,13.16,0.00,'2022-07-20 10:59:43','',''),(4658,'21','222','1',1,'Retail Sale Id 4022',3503.60,0.00,0.00,4.61,0.00,'2022-07-20 11:03:54','',''),(4659,'21','222','1',1,'Retail Sale Id 4023',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 11:11:51','',''),(4660,'21','222','1',1,'Retail Sale Id 4024',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 11:14:39','',''),(4661,'21','222','1',1,'Retail Sale Id 4025',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 11:16:44','',''),(4662,'21','222','1',1,'Retail Sale Id 4026',1003.20,0.00,0.00,1.32,0.00,'2022-07-20 11:18:18','',''),(4663,'21','222','1',1,'Retail Sale Id 4027',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 11:21:49','',''),(4664,'21','222','1',1,'Retail Sale Id 4028',8740.00,0.00,0.00,11.50,0.00,'2022-07-20 11:24:19','',''),(4665,'21','222','1',1,'Retail Sale Id 4029',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 11:29:30','',''),(4666,'21','222','1',1,'Retail Sale Id 4030',4750.00,0.00,0.00,6.25,0.00,'2022-07-20 11:34:30','',''),(4667,'21','222','1',1,'Retail Sale Id 4031',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 11:38:01','',''),(4668,'21','222','1',1,'Retail Sale Id 4032',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 12:02:15','',''),(4669,'21','222','1',1,'Retail Sale Id 4033',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 12:05:12','',''),(4670,'21','222','1',1,'Retail Sale Id 4033',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 12:05:12','',''),(4671,'21','222','1',1,'Retail Sale Id 4034',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 12:26:08','',''),(4672,'21','222','1',1,'Retail Sale Id 4035',3002.00,0.00,0.00,3.95,0.00,'2022-07-20 12:26:49','',''),(4673,'21','222','1',1,'Retail Sale Id 4036',3503.60,0.00,0.00,4.61,0.00,'2022-07-20 12:35:26','',''),(4674,'21','222','1',1,'Retail Sale Id 4037',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 12:38:26','',''),(4675,'21','222','1',1,'Retail Sale Id 4038',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 12:41:31','',''),(4676,'21','222','1',1,'Retail Sale Id 4039',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 12:43:44','',''),(4677,'21','222','1',1,'Retail Sale Id 4040',4750.00,0.00,0.00,6.25,0.00,'2022-07-20 12:50:44','',''),(4678,'21','222','1',1,'Retail Sale Id 4041',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 12:52:12','',''),(4679,'21','222','1',1,'Retail Sale Id 4042',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 13:01:42','',''),(4680,'21','222','1',1,'Retail Sale Id 4043',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 13:03:29','',''),(4681,'21','222','1',1,'Retail Sale Id 4044',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 13:05:22','',''),(4682,'21','222','1',1,'Retail Sale Id 4045',4499.20,0.00,0.00,5.92,0.00,'2022-07-20 13:13:17','',''),(4683,'21','222','1',1,'Retail Sale Id 4046',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 13:15:03','',''),(4684,'21','222','1',1,'Retail Sale Id 4047',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 13:43:10','',''),(4685,'21','222','1',1,'Retail Sale Id 4048',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 13:54:55','',''),(4686,'21','222','1',1,'Retail Sale Id 4049',5000.80,0.00,0.00,6.58,0.00,'2022-07-20 13:57:02','',''),(4687,'21','222','1',1,'Retail Sale Id 4050',2500.40,0.00,0.00,3.29,0.00,'2022-07-20 13:59:40','',''),(4688,'21','222','1',1,'Retail Sale Id 4051',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 14:10:40','',''),(4689,'21','222','1',1,'Retail Sale Id 4052',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 14:33:10','',''),(4690,'21','222','1',1,'Retail Sale Id 4054',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 14:38:45','',''),(4691,'21','222','1',1,'Retail Sale Id 4055',6080.00,0.00,0.00,8.00,0.00,'2022-07-20 14:39:59','',''),(4692,'21','222','1',1,'Retail Sale Id 4056',1900.00,0.00,0.00,2.50,0.00,'2022-07-20 14:41:28','',''),(4693,'21','222','1',1,'Retail Sale Id 4057',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 14:42:50','',''),(4694,'21','222','1',1,'Retail Sale Id 4058',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 14:54:34','',''),(4695,'21','222','1',1,'Retail Sale Id 4059',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 14:56:21','',''),(4696,'21','222','1',1,'Retail Sale Id 4060',1003.20,0.00,0.00,1.32,0.00,'2022-07-20 15:02:27','',''),(4697,'21','222','1',1,'Retail Sale Id 4061',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 15:08:52','',''),(4698,'21','222','1',1,'Retail Sale Id 4062',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 15:09:31','',''),(4699,'21','222','1',1,'Retail Sale Id 4063',3002.00,0.00,0.00,3.95,0.00,'2022-07-20 15:10:20','',''),(4700,'21','222','1',1,'Retail Sale Id 4064',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 15:19:22','',''),(4701,'21','222','1',1,'Retail Sale Id 4065',3997.60,0.00,0.00,5.26,0.00,'2022-07-20 15:26:14','',''),(4702,'21','222','1',1,'Retail Sale Id 4066',11020.00,0.00,0.00,14.50,0.00,'2022-07-20 15:30:57','',''),(4703,'21','222','1',1,'Retail Sale Id 4067',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 15:32:29','',''),(4704,'21','222','1',1,'Retail Sale Id 4068',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 15:34:10','',''),(4705,'21','222','1',1,'Retail Sale Id 4069',7600.00,0.00,0.00,10.00,0.00,'2022-07-20 15:48:58','',''),(4706,'21','222','1',1,'Retail Sale Id 4070',7600.00,0.00,0.00,10.00,0.00,'2022-07-20 15:52:42','',''),(4707,'21','222','1',1,'Retail Sale Id 4071',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 15:54:47','',''),(4708,'21','222','1',1,'Retail Sale Id 4072',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 15:56:45','',''),(4709,'21','222','1',1,'Retail Sale Id 4073',4301.60,0.00,0.00,5.66,0.00,'2022-07-20 16:18:25','',''),(4710,'21','222','1',1,'Retail Sale Id 4074',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 16:21:24','',''),(4711,'21','222','1',1,'Retail Sale Id 4075',3002.00,0.00,0.00,3.95,0.00,'2022-07-20 16:22:32','',''),(4712,'21','222','1',1,'Retail Sale Id 4076',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 16:28:40','',''),(4713,'21','222','1',1,'Retail Sale Id 4077',4750.00,0.00,0.00,6.25,0.00,'2022-07-20 16:46:08','',''),(4714,'21','222','1',1,'Retail Sale Id 4078',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 16:47:45','',''),(4715,'21','222','1',1,'Retail Sale Id 4079',8002.80,0.00,0.00,10.53,0.00,'2022-07-20 16:51:09','',''),(4716,'21','222','1',1,'Retail Sale Id 4080',5000.80,0.00,0.00,6.58,0.00,'2022-07-20 16:53:13','',''),(4717,'21','222','1',1,'Retail Sale Id 4081',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 16:54:35','',''),(4718,'21','222','1',1,'Retail Sale Id 4082',3503.60,0.00,0.00,4.61,0.00,'2022-07-20 16:55:45','',''),(4719,'21','222','1',1,'Retail Sale Id 4083',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 16:59:30','',''),(4720,'21','222','1',1,'Retail Sale Id 4084',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 17:04:22','',''),(4721,'21','222','1',1,'Retail Sale Id 4084',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 17:04:22','',''),(4722,'21','222','1',1,'Retail Sale Id 4084',1497.20,0.00,0.00,1.97,0.00,'2022-07-20 17:04:22','',''),(4723,'21','222','1',1,'Retail Sale Id 4085',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 17:05:02','',''),(4724,'21','222','1',1,'Retail Sale Id 4086',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 17:07:25','',''),(4725,'21','222','1',1,'Retail Sale Id 4087',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 17:09:54','',''),(4726,'21','222','1',1,'Retail Sale Id 4088',2280.00,0.00,0.00,3.00,0.00,'2022-07-20 17:15:06','',''),(4727,'21','222','1',1,'Retail Sale Id 4089',8998.40,0.00,0.00,11.84,0.00,'2022-07-20 17:31:41','',''),(4728,'21','222','1',1,'Retail Sale Id 4090',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 17:39:41','',''),(4729,'21','222','1',1,'Retail Sale Id 4091',3002.00,0.00,0.00,3.95,0.00,'2022-07-20 17:42:56','',''),(4730,'21','222','1',1,'Retail Sale Id 4092',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 17:45:57','',''),(4731,'21','222','1',1,'Retail Sale Id 4093',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 17:47:19','',''),(4732,'21','222','1',1,'Retail Sale Id 4094',3997.60,0.00,0.00,5.26,0.00,'2022-07-20 17:48:37','',''),(4733,'21','222','1',1,'Retail Sale Id 4095',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 17:54:39','',''),(4734,'21','222','1',1,'Retail Sale Id 4096',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 18:06:02','',''),(4735,'21','222','1',1,'Retail Sale Id 4096',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 18:06:02','',''),(4736,'21','222','1',1,'Retail Sale Id 4097',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 18:21:49','',''),(4737,'21','222','1',1,'Retail Sale Id 4098',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 18:42:16','',''),(4738,'21','222','1',1,'Retail Sale Id 4098',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 18:42:16','',''),(4739,'21','222','1',1,'Retail Sale Id 4098',15200.00,0.00,0.00,20.00,0.00,'2022-07-20 18:42:16','',''),(4740,'21','222','1',1,'Retail Sale Id 4098',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 18:42:16','',''),(4741,'21','222','1',1,'Retail Sale Id 4098',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 18:42:16','',''),(4742,'21','222','1',1,'Retail Sale Id 4099',3800.00,0.00,0.00,5.00,0.00,'2022-07-20 18:49:52','',''),(4743,'21','222','1',1,'Retail Sale Id 4099',4560.00,0.00,0.00,6.00,0.00,'2022-07-20 18:49:52','',''),(4744,'21','222','1',1,'Retail Sale Id 4099',7600.00,0.00,0.00,10.00,0.00,'2022-07-20 18:49:52','',''),(4745,'21','222','1',1,'Retail Sale Id 4099',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 18:49:52','',''),(4746,'21','222','1',1,'Retail Sale Id 4100',1998.80,0.00,0.00,2.63,0.00,'2022-07-20 19:21:47','',''),(4747,'21','222','1',1,'Retail Sale Id 4100',7600.00,0.00,0.00,10.00,0.00,'2022-07-20 19:21:47','',''),(4748,'21','222','1',1,'Retail Sale Id 4102',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 19:49:50','',''),(4749,'21','222','1',1,'Retail Sale Id 4103',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 20:58:46','',''),(4750,'21','222','1',1,'Retail Sale Id 4104',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 20:59:18','',''),(4751,'21','222','1',1,'Retail Sale Id 4105',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 20:59:48','',''),(4752,'21','222','1',1,'Retail Sale Id 4106',9500.00,0.00,0.00,12.50,0.00,'2022-07-20 21:00:18','',''),(4753,'21','222','1',1,'Retail Sale Id 4106',15200.00,0.00,0.00,20.00,0.00,'2022-07-20 21:00:18','',''),(4754,'21','222','1',1,'Retail Sale Id 4107',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 21:00:42','',''),(4755,'21','222','1',1,'Retail Sale Id 4108',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 21:01:13','',''),(4756,'21','222','1',1,'Retail Sale Id 4109',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 21:01:30','',''),(4757,'21','222','1',1,'Retail Sale Id 4110',19000.00,0.00,0.00,25.00,0.00,'2022-07-20 21:01:58','',''),(4758,'21','222','1',1,'Retail Sale Id 4111',13178.40,0.00,0.00,17.34,0.00,'2022-07-20 21:02:31','',''),(4759,'21','222','1',1,'Retail Sale Id 4112',38000.00,0.00,0.00,50.00,0.00,'2022-07-20 21:03:04','',''),(4760,'21','222','1',1,'Return of Retail Sale Id 4106',0.00,9500.00,12.50,0.00,0.00,'2022-07-20 21:05:26','',''),(4761,'21','222','1',1,'Return of Retail Sale Id 4106',0.00,15200.00,20.00,0.00,0.00,'2022-07-20 21:05:26','',''),(4762,'21','222','1',1,'Retail Sale Id 4113',24403.60,0.00,0.00,32.11,0.00,'2022-07-20 21:06:07','',''),(4763,'21','222','1',1,'Retail Sale Id 4114',3997.60,0.00,0.00,5.26,0.00,'2022-07-21 09:36:28','',''),(4764,'21','222','1',1,'Retail Sale Id 4115',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 12:48:46','',''),(4765,'21','222','1',1,'Retail Sale Id 4116',6999.60,0.00,0.00,9.21,0.00,'2022-07-21 12:49:48','',''),(4766,'21','222','1',1,'Retail Sale Id 4117',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 12:51:46','',''),(4767,'21','222','1',1,'Retail Sale Id 4118',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 12:52:32','',''),(4768,'21','222','1',1,'Retail Sale Id 4119',1003.20,0.00,0.00,1.32,0.00,'2022-07-21 12:54:00','',''),(4769,'21','222','1',1,'Retail Sale Id 4120',6999.60,0.00,0.00,9.21,0.00,'2022-07-21 12:54:51','',''),(4770,'21','222','1',1,'Retail Sale Id 4121',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 12:56:03','',''),(4771,'21','222','1',1,'Retail Sale Id 4122',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 12:59:55','',''),(4772,'21','222','1',1,'Retail Sale Id 4123',1998.80,0.00,0.00,2.63,0.00,'2022-07-21 13:00:52','',''),(4773,'21','222','1',1,'Retail Sale Id 4124',4560.00,0.00,0.00,6.00,0.00,'2022-07-21 13:02:01','',''),(4774,'21','222','1',1,'Retail Sale Id 4125',42096.40,0.00,0.00,55.39,0.00,'2022-07-21 13:03:10','',''),(4775,'21','222','1',1,'Retail Sale Id 4126',3800.00,0.00,0.00,5.00,0.00,'2022-07-21 13:04:30','',''),(4776,'21','222','1',1,'Retail Sale Id 4127',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:20:37','',''),(4777,'21','222','1',1,'Retail Sale Id 4129',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:23:05','',''),(4778,'21','222','1',1,'Retail Sale Id 4130',6840.00,0.00,0.00,9.00,0.00,'2022-07-21 13:24:21','',''),(4779,'21','222','1',1,'Retail Sale Id 4131',3997.60,0.00,0.00,5.26,0.00,'2022-07-21 13:28:20','',''),(4780,'21','222','1',1,'Retail Sale Id 4132',3800.00,0.00,0.00,5.00,0.00,'2022-07-21 13:29:11','',''),(4781,'21','222','1',1,'Retail Sale Id 4133',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:29:48','',''),(4782,'21','222','1',1,'Retail Sale Id 4134',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:31:36','',''),(4783,'21','222','1',1,'Retail Sale Id 4135',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:32:23','',''),(4784,'21','222','1',1,'Retail Sale Id 4136',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:33:43','',''),(4785,'21','222','1',1,'Retail Sale Id 4137',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:35:51','',''),(4786,'21','222','1',1,'Retail Sale Id 4138',38000.00,0.00,0.00,50.00,0.00,'2022-07-21 13:38:12','',''),(4787,'21','222','1',1,'Retail Sale Id 4139',10001.60,0.00,0.00,13.16,0.00,'2022-07-21 13:47:30','',''),(4788,'21','222','1',1,'Retail Sale Id 4140',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:49:32','',''),(4789,'21','222','1',1,'Retail Sale Id 4141',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:50:15','',''),(4790,'21','222','1',1,'Retail Sale Id 4142',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:58:04','',''),(4791,'21','222','1',1,'Retail Sale Id 4143',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 13:59:11','',''),(4792,'21','222','1',1,'Retail Sale Id 4144',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:00:09','',''),(4793,'21','222','1',1,'Retail Sale Id 4145',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:00:40','',''),(4794,'21','222','1',1,'Retail Sale Id 4146',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:01:37','',''),(4795,'21','222','1',1,'Retail Sale Id 4147',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:13:12','',''),(4796,'21','222','1',1,'Retail Sale Id 4148',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:14:34','',''),(4797,'21','222','1',1,'Retail Sale Id 4149',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:16:14','',''),(4798,'21','222','1',1,'Retail Sale Id 4149',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:16:14','',''),(4799,'21','222','1',1,'Retail Sale Id 4150',3800.00,0.00,0.00,5.00,0.00,'2022-07-21 14:20:01','',''),(4800,'21','222','1',1,'Retail Sale Id 4151',3800.00,0.00,0.00,5.00,0.00,'2022-07-21 14:24:37','',''),(4801,'21','222','1',1,'Retail Sale Id 4152',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:30:55','',''),(4802,'21','222','1',1,'Retail Sale Id 4153',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:33:06','',''),(4803,'21','222','1',1,'Retail Sale Id 4154',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 14:33:46','',''),(4804,'21','222','1',1,'Retail Sale Id 4155',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 15:07:24','',''),(4805,'21','222','1',1,'Retail Sale Id 4156',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 15:08:14','',''),(4806,'21','222','1',1,'Retail Sale Id 4157',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 15:09:35','',''),(4807,'21','222','1',1,'Retail Sale Id 4158',19000.00,0.00,0.00,25.00,0.00,'2022-07-21 15:10:27','',''),(4808,'21','222','1',1,'Retail Sale Id 4159',4560.00,0.00,0.00,6.00,0.00,'2022-07-21 15:16:48','',''),(4809,'21','222','1',1,'Retail Sale Id 4160',10997.20,0.00,0.00,14.47,0.00,'2022-07-21 15:34:55','',''),(4810,'21','222','1',1,'Retail Sale Id 4161',19000.00,0.00,0.00,25.00,0.00,'2022-07-21 16:33:14','',''),(4811,'21','222','1',1,'Retail Sale Id 4162',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 16:35:34','',''),(4812,'21','222','1',1,'Retail Sale Id 4164',4560.00,0.00,0.00,6.00,0.00,'2022-07-21 16:45:15','',''),(4813,'21','222','1',1,'Retail Sale Id 4165',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 16:46:31','',''),(4814,'21','222','1',1,'Retail Sale Id 4167',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 17:42:30','',''),(4815,'21','222','1',1,'Retail Sale Id 4168',2280.00,0.00,0.00,3.00,0.00,'2022-07-21 17:49:19','',''),(4816,'21','222','1',1,'Retail Sale Id 4169',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 18:55:25','',''),(4817,'21','222','1',1,'Retail Sale Id 4170',7600.00,0.00,0.00,10.00,0.00,'2022-07-21 18:56:37','',''),(4818,'21','222','1',1,'Retail Sale Id 4171',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 18:57:31','',''),(4819,'21','222','1',1,'Retail Sale Id 4172',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 18:58:16','',''),(4820,'21','222','1',1,'Retail Sale Id 4173',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 18:59:01','',''),(4821,'21','222','1',1,'Retail Sale Id 4174',8002.80,0.00,0.00,10.53,0.00,'2022-07-21 18:59:45','',''),(4822,'21','222','1',1,'Retail Sale Id 4175',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 19:00:32','',''),(4823,'21','222','1',1,'Retail Sale Id 4176',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 19:01:17','',''),(4824,'21','222','1',1,'Retail Sale Id 4177',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 19:02:11','',''),(4825,'21','222','1',1,'Retail Sale Id 4178',38000.00,0.00,0.00,50.00,0.00,'2022-07-21 19:03:23','',''),(4826,'21','222','1',1,'Retail Sale Id 4179',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 19:04:21','',''),(4827,'21','222','1',1,'Retail Sale Id 4180',4560.00,0.00,0.00,6.00,0.00,'2022-07-21 19:06:19','',''),(4828,'21','222','1',1,'Retail Sale Id 4181',1998.80,0.00,0.00,2.63,0.00,'2022-07-21 19:19:10','',''),(4829,'21','222','1',1,'Retail Sale Id 4182',3997.60,0.00,0.00,5.26,0.00,'2022-07-21 19:29:07','',''),(4830,'21','222','1',1,'Retail Sale Id 4183',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 19:37:35','',''),(4831,'21','222','1',1,'Retail Sale Id 4184',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 19:38:35','',''),(4832,'21','222','1',1,'Retail Sale Id 4185',2280.00,0.00,0.00,3.00,0.00,'2022-07-21 19:41:07','',''),(4833,'21','222','1',1,'Retail Sale Id 4186',1998.80,0.00,0.00,2.63,0.00,'2022-07-21 19:44:53','',''),(4834,'21','222','1',1,'Retail Sale Id 4187',9500.00,0.00,0.00,12.50,0.00,'2022-07-21 19:48:30','',''),(4835,'21','222','1',1,'Retail Sale Id 4188',4560.00,0.00,0.00,6.00,0.00,'2022-07-21 19:54:31','',''),(4836,'21','222','1',1,'Retail Sale Id 4189',1497.20,0.00,0.00,1.97,0.00,'2022-07-21 19:56:30','',''),(4837,'21','222','1',1,'Retail Sale Id 4190',501.60,0.00,0.00,0.66,0.00,'2022-07-21 20:00:13','',''),(4838,'21','222','1',1,'Retail Sale Id 4191',4560.00,0.00,0.00,6.00,0.00,'2022-07-21 20:05:01','',''),(4839,'21','222','1',1,'Retail Sale Id 4192',3800.00,0.00,0.00,5.00,0.00,'2022-07-21 20:07:45','',''),(4840,'21','222','1',1,'Retail Sale Id 4193',4339.60,0.00,0.00,5.71,0.00,'2022-07-21 20:35:06','',''),(4841,'21','222','1',1,'Retail Sale Id 4194',2280.00,0.00,0.00,3.00,0.00,'2022-07-22 10:54:21','',''),(4842,'21','222','1',1,'Retail Sale Id 4195',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 11:10:33','',''),(4843,'21','222','1',1,'Retail Sale Id 4195',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 11:10:33','',''),(4844,'21','222','1',1,'Retail Sale Id 4196',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 11:12:21','',''),(4845,'21','222','1',1,'Retail Sale Id 4197',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 11:13:06','',''),(4846,'21','222','1',1,'Retail Sale Id 4198',3002.00,0.00,0.00,3.95,0.00,'2022-07-22 11:59:37','',''),(4847,'21','222','1',1,'Retail Sale Id 4199',2280.00,0.00,0.00,3.00,0.00,'2022-07-22 12:09:45','',''),(4848,'21','222','1',1,'Retail Sale Id 4200',1200.80,0.00,0.00,1.58,0.00,'2022-07-22 12:11:05','',''),(4849,'21','222','1',1,'Retail Sale Id 4201',1200.80,0.00,0.00,1.58,0.00,'2022-07-22 12:13:43','',''),(4850,'21','222','1',1,'Retail Sale Id 4202',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 12:26:00','',''),(4851,'21','222','1',1,'Retail Sale Id 4203',1497.20,0.00,0.00,1.97,0.00,'2022-07-22 12:29:18','',''),(4852,'21','222','1',1,'Retail Sale Id 4204',5000.80,0.00,0.00,6.58,0.00,'2022-07-22 12:33:44','',''),(4853,'21','222','1',1,'Retail Sale Id 4205',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 12:39:07','',''),(4854,'21','222','1',1,'Retail Sale Id 4206',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 12:41:45','',''),(4855,'21','222','1',1,'Retail Sale Id 4207',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 12:44:52','',''),(4856,'21','222','1',1,'Retail Sale Id 4208',3002.00,0.00,0.00,3.95,0.00,'2022-07-22 12:45:52','',''),(4857,'21','222','1',1,'Retail Sale Id 4209',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 12:47:25','',''),(4858,'21','222','1',1,'Retail Sale Id 4210',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 12:48:10','',''),(4859,'21','222','1',1,'Retail Sale Id 4211',4499.20,0.00,0.00,5.92,0.00,'2022-07-22 12:52:41','',''),(4860,'21','222','1',1,'Retail Sale Id 4212',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 12:59:12','',''),(4861,'21','222','1',1,'Retail Sale Id 4213',3800.00,0.00,0.00,5.00,0.00,'2022-07-22 14:25:43','',''),(4862,'21','222','1',1,'Retail Sale Id 4214',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 14:31:47','',''),(4863,'21','222','1',1,'Retail Sale Id 4215',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 14:36:34','',''),(4864,'21','222','1',1,'Retail Sale Id 4216',2280.00,0.00,0.00,3.00,0.00,'2022-07-22 14:39:12','',''),(4865,'21','222','1',1,'Retail Sale Id 4217',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 14:44:10','',''),(4866,'21','222','1',1,'Retail Sale Id 4218',2280.00,0.00,0.00,3.00,0.00,'2022-07-22 14:45:12','',''),(4867,'21','222','1',1,'Retail Sale Id 4219',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 14:53:14','',''),(4868,'21','222','1',1,'Retail Sale Id 4220',760.00,0.00,0.00,1.00,0.00,'2022-07-22 14:57:49','',''),(4869,'21','222','1',1,'Retail Sale Id 4221',3800.00,0.00,0.00,5.00,0.00,'2022-07-22 14:58:35','',''),(4870,'21','222','1',1,'Retail Sale Id 4222',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 14:59:46','',''),(4871,'21','222','1',1,'Retail Sale Id 4223',3002.00,0.00,0.00,3.95,0.00,'2022-07-22 15:04:38','',''),(4872,'21','222','1',1,'Retail Sale Id 4224',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 15:06:30','',''),(4873,'21','222','1',1,'Retail Sale Id 4225',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 15:17:07','',''),(4874,'21','222','1',1,'Retail Sale Id 4226',8998.40,0.00,0.00,11.84,0.00,'2022-07-22 15:20:09','',''),(4875,'21','222','1',1,'Retail Sale Id 4227',8002.80,0.00,0.00,10.53,0.00,'2022-07-22 15:21:30','',''),(4876,'21','222','1',1,'Retail Sale Id 4228',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 15:23:39','',''),(4877,'21','222','1',1,'Retail Sale Id 4229',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 15:32:58','',''),(4878,'21','222','1',1,'Retail Sale Id 4230',3002.00,0.00,0.00,3.95,0.00,'2022-07-22 15:34:07','',''),(4879,'21','222','1',1,'Retail Sale Id 4231',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 15:35:47','',''),(4880,'21','222','1',1,'Retail Sale Id 4232',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 15:47:55','',''),(4881,'21','222','1',1,'Retail Sale Id 4233',3002.00,0.00,0.00,3.95,0.00,'2022-07-22 15:49:34','',''),(4882,'21','222','1',1,'Retail Sale Id 4234',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 15:50:42','',''),(4883,'21','222','1',1,'Retail Sale Id 4235',4750.00,0.00,0.00,6.25,0.00,'2022-07-22 15:53:32','',''),(4884,'21','222','1',1,'Retail Sale Id 4236',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 15:57:01','',''),(4885,'21','222','1',1,'Retail Sale Id 4237',1702.40,0.00,0.00,2.24,0.00,'2022-07-22 15:59:00','',''),(4886,'21','222','1',1,'Retail Sale Id 4238',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 16:00:54','',''),(4887,'21','222','1',1,'Retail Sale Id 4239',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 16:01:59','',''),(4888,'21','222','1',1,'Retail Sale Id 4240',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:08:44','',''),(4889,'21','222','1',1,'Retail Sale Id 4241',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:19:33','',''),(4890,'21','222','1',1,'Retail Sale Id 4242',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:26:57','',''),(4891,'21','222','1',1,'Retail Sale Id 4243',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:35:18','',''),(4892,'21','222','1',1,'Retail Sale Id 4244',38000.00,0.00,0.00,50.00,0.00,'2022-07-22 16:39:32','',''),(4893,'21','222','1',1,'Retail Sale Id 4245',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:44:37','',''),(4894,'21','222','1',1,'Retail Sale Id 4245',38000.00,0.00,0.00,50.00,0.00,'2022-07-22 16:44:37','',''),(4895,'21','222','1',1,'Retail Sale Id 4246',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 16:47:17','',''),(4896,'21','222','1',1,'Retail Sale Id 4247',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 16:49:13','',''),(4897,'21','222','1',1,'Retail Sale Id 4247',11400.00,0.00,0.00,15.00,0.00,'2022-07-22 16:49:13','',''),(4898,'21','222','1',1,'Retail Sale Id 4248',3800.00,0.00,0.00,5.00,0.00,'2022-07-22 16:52:45','',''),(4899,'21','222','1',1,'Retail Sale Id 4249',1003.20,0.00,0.00,1.32,0.00,'2022-07-22 16:57:30','',''),(4900,'21','222','1',1,'Retail Sale Id 4250',3040.00,0.00,0.00,4.00,0.00,'2022-07-22 16:59:30','',''),(4901,'21','222','1',1,'Retail Sale Id 4251',3800.00,0.00,0.00,5.00,0.00,'2022-07-22 17:01:46','',''),(4902,'21','222','1',1,'Retail Sale Id 4251',4560.00,0.00,0.00,6.00,0.00,'2022-07-22 17:01:46','',''),(4903,'21','222','1',1,'Retail Sale Id 4251',5320.00,0.00,0.00,7.00,0.00,'2022-07-22 17:01:47','',''),(4904,'21','222','1',1,'Retail Sale Id 4252',3002.00,0.00,0.00,3.95,0.00,'2022-07-22 17:19:39','',''),(4905,'21','222','1',1,'Retail Sale Id 4253',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:21:22','',''),(4906,'21','222','1',1,'Retail Sale Id 4254',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 17:29:42','',''),(4907,'21','222','1',1,'Retail Sale Id 4255',1998.80,0.00,0.00,2.63,0.00,'2022-07-22 17:31:22','',''),(4908,'21','222','1',1,'Retail Sale Id 4256',3800.00,0.00,0.00,5.00,0.00,'2022-07-22 17:34:55','',''),(4909,'21','222','1',1,'Retail Sale Id 4256',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:34:55','',''),(4910,'21','222','1',1,'Retail Sale Id 4257',3002.00,0.00,0.00,3.95,0.00,'2022-07-22 17:41:39','',''),(4911,'21','222','1',1,'Retail Sale Id 4258',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:43:45','',''),(4912,'21','222','1',1,'Retail Sale Id 4259',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 17:46:42','',''),(4913,'21','222','1',1,'Retail Sale Id 4260',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 18:31:02','',''),(4914,'21','222','1',1,'Retail Sale Id 4261',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 18:31:48','',''),(4915,'21','222','1',1,'Retail Sale Id 4262',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 18:33:02','',''),(4916,'21','222','1',1,'Retail Sale Id 4263',8998.40,0.00,0.00,11.84,0.00,'2022-07-22 18:33:47','',''),(4917,'21','222','1',1,'Retail Sale Id 4264',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 18:34:46','',''),(4918,'21','222','1',1,'Retail Sale Id 4265',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 18:41:07','',''),(4919,'21','222','1',1,'Retail Sale Id 4266',3997.60,0.00,0.00,5.26,0.00,'2022-07-22 18:45:57','',''),(4920,'21','222','1',1,'Retail Sale Id 4267',3800.00,0.00,0.00,5.00,0.00,'2022-07-22 18:47:07','',''),(4921,'21','222','1',1,'Retail Sale Id 4268',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 18:49:25','',''),(4922,'21','222','1',1,'Retail Sale Id 4269',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 18:51:47','',''),(4923,'21','222','1',1,'Retail Sale Id 4270',7600.00,0.00,0.00,10.00,0.00,'2022-07-22 19:06:23','',''),(4924,'21','222','1',1,'Retail Sale Id 4270',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 19:06:23','',''),(4925,'21','222','1',1,'Retail Sale Id 4271',9500.00,0.00,0.00,12.50,0.00,'2022-07-22 19:09:32','',''),(4926,'21','222','1',1,'Retail Sale Id 4272',38000.00,0.00,0.00,50.00,0.00,'2022-07-22 19:57:46','',''),(4927,'21','222','1',1,'Retail Sale Id 4273',105602.00,0.00,0.00,138.95,0.00,'2022-07-22 19:59:08','',''),(4928,'21','222','1',1,'Retail Sale Id 4274',38000.00,0.00,0.00,50.00,0.00,'2022-07-22 20:01:10','',''),(4929,'21','222','1',1,'Retail Sale Id 4275',38000.00,0.00,0.00,50.00,0.00,'2022-07-22 20:02:18','',''),(4930,'21','222','1',1,'Retail Sale Id 4276',12190.40,0.00,0.00,16.04,0.00,'2022-07-22 20:04:19','',''),(4931,'21','222','1',1,'Retail Sale Id 4277',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 08:30:09','',''),(4932,'21','222','1',1,'Retail Sale Id 4278',3997.60,0.00,0.00,5.26,0.00,'2022-07-23 08:31:32','',''),(4933,'21','222','1',1,'Retail Sale Id 4279',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 08:33:11','',''),(4934,'21','222','1',1,'Retail Sale Id 4280',1520.00,0.00,0.00,2.00,0.00,'2022-07-23 08:35:35','',''),(4935,'21','222','1',1,'Retail Sale Id 4281',760.00,0.00,0.00,1.00,0.00,'2022-07-23 08:38:45','',''),(4936,'21','222','1',1,'Retail Sale Id 4283',3002.00,0.00,0.00,3.95,0.00,'2022-07-23 08:41:16','',''),(4937,'21','222','1',1,'Retail Sale Id 4284',3040.00,0.00,0.00,4.00,0.00,'2022-07-23 08:43:35','',''),(4938,'21','222','1',1,'Retail Sale Id 4285',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 08:46:27','',''),(4939,'21','222','1',1,'Retail Sale Id 4286',1520.00,0.00,0.00,2.00,0.00,'2022-07-23 08:50:56','',''),(4940,'21','222','1',1,'Retail Sale Id 4287',4560.00,0.00,0.00,6.00,0.00,'2022-07-23 08:52:37','',''),(4941,'21','222','1',1,'Retail Sale Id 4287',4560.00,0.00,0.00,6.00,0.00,'2022-07-23 08:52:37','',''),(4942,'21','222','1',1,'Retail Sale Id 4288',2500.40,0.00,0.00,3.29,0.00,'2022-07-23 08:54:46','',''),(4943,'21','222','1',1,'Retail Sale Id 4289',2280.00,0.00,0.00,3.00,0.00,'2022-07-23 08:58:15','',''),(4944,'21','222','1',1,'Retail Sale Id 4290',4560.00,0.00,0.00,6.00,0.00,'2022-07-23 08:59:49','',''),(4945,'21','222','1',1,'Retail Sale Id 4290',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 08:59:49','',''),(4946,'21','222','1',1,'Retail Sale Id 4291',4560.00,0.00,0.00,6.00,0.00,'2022-07-23 09:23:47','',''),(4947,'21','222','1',1,'Retail Sale Id 4291',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 09:23:47','',''),(4948,'21','222','1',1,'Retail Sale Id 4292',8998.40,0.00,0.00,11.84,0.00,'2022-07-23 09:24:56','',''),(4949,'21','222','1',1,'Retail Sale Id 4293',19000.00,0.00,0.00,25.00,0.00,'2022-07-23 09:27:56','',''),(4950,'21','222','1',1,'Retail Sale Id 4294',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 09:44:31','',''),(4951,'21','222','1',1,'Retail Sale Id 4295',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 09:45:23','',''),(4952,'21','222','1',1,'Retail Sale Id 4296',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 09:50:16','',''),(4953,'21','222','1',1,'Retail Sale Id 4297',3002.00,0.00,0.00,3.95,0.00,'2022-07-23 09:51:48','',''),(4954,'21','222','1',1,'Retail Sale Id 4298',4750.00,0.00,0.00,6.25,0.00,'2022-07-23 09:59:55','',''),(4955,'21','222','1',1,'Retail Sale Id 4299',19000.00,0.00,0.00,25.00,0.00,'2022-07-23 10:52:42','',''),(4956,'21','222','1',1,'Retail Sale Id 4300',38000.00,0.00,0.00,50.00,0.00,'2022-07-23 10:53:36','',''),(4957,'21','222','1',1,'Retail Sale Id 4301',11400.00,0.00,0.00,15.00,0.00,'2022-07-23 10:54:39','',''),(4958,'21','222','1',1,'Retail Sale Id 4302',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 10:55:48','',''),(4959,'21','222','1',1,'Retail Sale Id 4303',8474.00,0.00,0.00,11.15,0.00,'2022-07-23 10:57:33','',''),(4960,'21','222','1',1,'Retail Sale Id 4304',1831.60,0.00,0.00,2.41,0.00,'2022-07-23 11:04:13','',''),(4961,'21','222','1',1,'Retail Sale Id 4305',19000.00,0.00,0.00,25.00,0.00,'2022-07-23 13:16:35','',''),(4962,'21','222','1',1,'Retail Sale Id 4306',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 13:18:14','',''),(4963,'21','222','1',1,'Retail Sale Id 4307',9500.00,0.00,0.00,12.50,0.00,'2022-07-23 13:19:41','',''),(4964,'21','222','1',1,'Retail Sale Id 4308',10997.20,0.00,0.00,14.47,0.00,'2022-07-23 13:21:51','',''),(4965,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-07-24 07:44:17','',''),(4966,'21','222',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,4999.25,0.00,'2022-07-24 07:50:19','',''),(4967,'21','222','1',1,'Received from bridging 35',0.00,0.00,4999.25,0.00,0.00,'2022-07-24 07:50:19','',''),(4968,'21','222','1',1,'Retail Sale Id 4311',8002.80,0.00,0.00,10.53,0.00,'2022-07-24 07:52:54','',''),(4969,'21','222','1',1,'Retail Sale Id 4311',8002.80,0.00,0.00,10.53,0.00,'2022-07-24 07:52:54','',''),(4970,'21','222','1',1,'Retail Sale Id 4312',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 07:55:00','',''),(4971,'21','222','1',1,'Retail Sale Id 4313',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 08:03:04','',''),(4972,'21','222','1',1,'Retail Sale Id 4313',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 08:03:04','',''),(4973,'21','222','1',1,'Retail Sale Id 4314',38000.00,0.00,0.00,50.00,0.00,'2022-07-24 08:26:57','',''),(4974,'21','222','1',1,'Retail Sale Id 4315',11400.00,0.00,0.00,15.00,0.00,'2022-07-24 08:29:00','',''),(4975,'21','222','1',1,'Retail Sale Id 4316',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 08:32:08','',''),(4976,'21','222','1',1,'Retail Sale Id 4317',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 08:33:13','',''),(4977,'21','222','1',1,'Retail Sale Id 4318',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 08:34:19','',''),(4978,'21','222','1',1,'Retail Sale Id 4319',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 08:37:02','',''),(4979,'21','222','1',1,'Retail Sale Id 4320',760.00,0.00,0.00,1.00,0.00,'2022-07-24 08:41:01','',''),(4980,'21','222','1',1,'Retail Sale Id 4321',38000.00,0.00,0.00,50.00,0.00,'2022-07-24 08:43:11','',''),(4981,'21','222','1',1,'Retail Sale Id 4322',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 08:46:26','',''),(4982,'21','222','1',1,'Retail Sale Id 4322',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 08:46:26','',''),(4983,'21','222','1',1,'Retail Sale Id 4323',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 08:48:18','',''),(4984,'21','222','1',1,'Retail Sale Id 4324',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 08:48:57','',''),(4985,'21','222','1',1,'Retail Sale Id 4325',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 08:50:10','',''),(4986,'21','222','1',1,'Retail Sale Id 4326',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 08:50:53','',''),(4987,'21','222','1',1,'Retail Sale Id 4327',2401.60,0.00,0.00,3.16,0.00,'2022-07-24 09:03:47','',''),(4988,'21','222','1',1,'Retail Sale Id 4328',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 09:09:03','',''),(4989,'21','222','1',1,'Retail Sale Id 4329',798.00,0.00,0.00,1.05,0.00,'2022-07-24 09:10:18','',''),(4990,'21','222','1',1,'Retail Sale Id 4330',760.00,0.00,0.00,1.00,0.00,'2022-07-24 09:14:27','',''),(4991,'21','222','1',1,'Retail Sale Id 4331',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 09:16:08','',''),(4992,'21','222','1',1,'Retail Sale Id 4332',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 09:17:43','',''),(4993,'21','222','1',1,'Retail Sale Id 4333',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 09:19:43','',''),(4994,'21','222','1',1,'Retail Sale Id 4334',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 09:20:49','',''),(4995,'21','222','1',1,'Retail Sale Id 4335',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 09:25:16','',''),(4996,'21','222','1',1,'Retail Sale Id 4336',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 09:32:15','',''),(4997,'21','222','1',1,'Retail Sale Id 4337',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 09:34:59','',''),(4998,'21','222','1',1,'Retail Sale Id 4338',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 09:37:20','',''),(4999,'21','222','1',1,'Retail Sale Id 4339',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 09:38:37','',''),(5000,'21','222','1',1,'Retail Sale Id 4340',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 09:40:50','',''),(5001,'21','222','1',1,'Retail Sale Id 4341',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 09:44:32','',''),(5002,'21','222','1',1,'Retail Sale Id 4342',3503.60,0.00,0.00,4.61,0.00,'2022-07-24 09:46:04','',''),(5003,'21','222','1',1,'Retail Sale Id 4343',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 09:51:17','',''),(5004,'21','222','1',1,'Retail Sale Id 4343',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 09:51:17','',''),(5005,'21','222','1',1,'Retail Sale Id 4344',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 09:55:25','',''),(5006,'21','222','1',1,'Retail Sale Id 4345',3040.00,0.00,0.00,4.00,0.00,'2022-07-24 09:58:15','',''),(5007,'21','222','1',1,'Retail Sale Id 4346',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 09:59:30','',''),(5008,'21','222','1',1,'Retail Sale Id 4347',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 10:01:30','',''),(5009,'21','222','1',1,'Retail Sale Id 4348',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 10:02:40','',''),(5010,'21','222','1',1,'Retail Sale Id 4349',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 10:03:42','',''),(5011,'21','222','1',1,'Retail Sale Id 4350',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 10:06:34','',''),(5012,'21','222','1',1,'Retail Sale Id 4350',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 10:06:34','',''),(5013,'21','222','1',1,'Retail Sale Id 4351',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 10:09:11','',''),(5014,'21','222','1',1,'Retail Sale Id 4352',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 10:15:53','',''),(5015,'21','222','1',1,'Retail Sale Id 4353',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 10:19:50','',''),(5016,'21','222','1',1,'Retail Sale Id 4354',4499.20,0.00,0.00,5.92,0.00,'2022-07-24 10:24:15','',''),(5017,'21','222','1',1,'Retail Sale Id 4355',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 10:30:00','',''),(5018,'21','222','1',1,'Retail Sale Id 4358',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 10:46:54','',''),(5019,'21','222','1',1,'Retail Sale Id 4359',3002.00,0.00,0.00,3.95,0.00,'2022-07-24 10:48:39','',''),(5020,'21','222','1',1,'Retail Sale Id 4360',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 10:50:07','',''),(5021,'21','222','1',1,'Retail Sale Id 4361',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 10:51:53','',''),(5022,'21','222','1',1,'Retail Sale Id 4362',8740.00,0.00,0.00,11.50,0.00,'2022-07-24 10:54:13','',''),(5023,'21','222','1',1,'Retail Sale Id 4363',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 10:56:28','',''),(5024,'21','222','1',1,'Retail Sale Id 4364',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 10:59:41','',''),(5025,'21','222','1',1,'Retail Sale Id 4365',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 11:00:44','',''),(5026,'21','222','1',1,'Retail Sale Id 4366',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 11:07:10','',''),(5027,'21','222','1',1,'Retail Sale Id 4367',760.00,0.00,0.00,1.00,0.00,'2022-07-24 11:08:16','',''),(5028,'21','222','1',1,'Retail Sale Id 4368',4750.00,0.00,0.00,6.25,0.00,'2022-07-24 11:09:26','',''),(5029,'21','222','1',1,'Retail Sale Id 4369',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 11:12:00','',''),(5030,'21','222','1',1,'Retail Sale Id 4370',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:13:45','',''),(5031,'21','222','1',1,'Retail Sale Id 4370',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:13:45','',''),(5032,'21','222','1',1,'Retail Sale Id 4371',2500.40,0.00,0.00,3.29,0.00,'2022-07-24 11:15:09','',''),(5033,'21','222','1',1,'Retail Sale Id 4372',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:16:35','',''),(5034,'21','222','1',1,'Retail Sale Id 4373',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:18:47','',''),(5035,'21','222','1',1,'Retail Sale Id 4374',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 11:20:13','',''),(5036,'21','222','1',1,'Retail Sale Id 4375',38000.00,0.00,0.00,50.00,0.00,'2022-07-24 11:25:29','',''),(5037,'21','222','1',1,'Retail Sale Id 4376',11400.00,0.00,0.00,15.00,0.00,'2022-07-24 11:26:02','',''),(5038,'21','222','1',1,'Retail Sale Id 4377',19000.00,0.00,0.00,25.00,0.00,'2022-07-24 11:26:40','',''),(5039,'21','222','1',1,'Retail Sale Id 4378',1900.00,0.00,0.00,2.50,0.00,'2022-07-24 11:28:08','',''),(5040,'21','222','1',1,'Retail Sale Id 4379',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:32:08','',''),(5041,'21','222','1',1,'Retail Sale Id 4380',3997.60,0.00,0.00,5.26,0.00,'2022-07-24 11:33:58','',''),(5042,'21','222','1',1,'Retail Sale Id 4381',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:35:26','',''),(5043,'21','222','1',1,'Retail Sale Id 4382',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:36:26','',''),(5044,'21','222','1',1,'Retail Sale Id 4383',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 11:41:39','',''),(5045,'21','222','1',1,'Retail Sale Id 4384',3040.00,0.00,0.00,4.00,0.00,'2022-07-24 11:43:42','',''),(5046,'21','222','1',1,'Retail Sale Id 4386',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:45:53','',''),(5047,'21','222','1',1,'Retail Sale Id 4387',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 11:47:34','',''),(5048,'21','222','1',1,'Retail Sale Id 4388',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 11:48:55','',''),(5049,'21','222','1',1,'Retail Sale Id 4389',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:50:18','',''),(5050,'21','222','1',1,'Retail Sale Id 4390',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:52:33','',''),(5051,'21','222','1',1,'Retail Sale Id 4391',3002.00,0.00,0.00,3.95,0.00,'2022-07-24 11:53:54','',''),(5052,'21','222','1',1,'Retail Sale Id 4392',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:56:34','',''),(5053,'21','222','1',1,'Retail Sale Id 4393',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 11:57:36','',''),(5054,'21','222','1',1,'Retail Sale Id 4394',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 11:59:18','',''),(5055,'21','222','1',1,'Retail Sale Id 4395',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 12:00:52','',''),(5056,'21','222','1',1,'Retail Sale Id 4396',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 12:03:04','',''),(5057,'21','222','1',1,'Retail Sale Id 4397',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:06:51','',''),(5058,'21','222','1',1,'Retail Sale Id 4398',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 12:09:31','',''),(5059,'21','222','1',1,'Retail Sale Id 4399',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 12:14:54','',''),(5060,'21','222','1',1,'Retail Sale Id 4400',6999.60,0.00,0.00,9.21,0.00,'2022-07-24 12:15:48','',''),(5061,'21','222','1',1,'Retail Sale Id 4401',3002.00,0.00,0.00,3.95,0.00,'2022-07-24 12:21:01','',''),(5062,'21','222','1',1,'Retail Sale Id 4402',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:22:41','',''),(5063,'21','222','1',1,'Retail Sale Id 4403',6999.60,0.00,0.00,9.21,0.00,'2022-07-24 12:24:23','',''),(5064,'21','222','1',1,'Retail Sale Id 4404',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:25:53','',''),(5065,'21','222','1',1,'Retail Sale Id 4405',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:27:52','',''),(5066,'21','222','1',1,'Retail Sale Id 4405',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:27:52','',''),(5067,'21','222','1',1,'Retail Sale Id 4406',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 12:29:46','',''),(5068,'21','222','1',1,'Retail Sale Id 4407',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 12:31:12','',''),(5069,'21','222','1',1,'Retail Sale Id 4408',3997.60,0.00,0.00,5.26,0.00,'2022-07-24 12:32:23','',''),(5070,'21','222','1',1,'Retail Sale Id 4409',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 12:35:10','',''),(5071,'21','222','1',1,'Retail Sale Id 4410',1520.00,0.00,0.00,2.00,0.00,'2022-07-24 12:38:19','',''),(5072,'21','222','1',1,'Retail Sale Id 4411',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 12:40:02','',''),(5073,'21','222','1',1,'Retail Sale Id 4412',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:44:57','',''),(5074,'21','222','1',1,'Retail Sale Id 4413',1003.20,0.00,0.00,1.32,0.00,'2022-07-24 12:47:16','',''),(5075,'21','222','1',1,'Retail Sale Id 4414',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:49:46','',''),(5076,'21','222','1',1,'Retail Sale Id 4415',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:51:37','',''),(5077,'21','222','1',1,'Retail Sale Id 4416',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:53:18','',''),(5078,'21','222','1',1,'Retail Sale Id 4417',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:54:36','',''),(5079,'21','222','1',1,'Retail Sale Id 4418',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 12:55:46','',''),(5080,'21','222','1',1,'Retail Sale Id 4419',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 12:57:02','',''),(5081,'21','222','1',1,'Retail Sale Id 4420',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 12:58:07','',''),(5082,'21','222','1',1,'Retail Sale Id 4421',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 13:03:51','',''),(5083,'21','222','1',1,'Retail Sale Id 4422',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 13:07:54','',''),(5084,'21','222','1',1,'Retail Sale Id 4423',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 13:16:00','',''),(5085,'21','222','1',1,'Retail Sale Id 4424',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 13:17:42','',''),(5086,'21','222','1',1,'Retail Sale Id 4425',3002.00,0.00,0.00,3.95,0.00,'2022-07-24 13:19:04','',''),(5087,'21','222','1',1,'Retail Sale Id 4426',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 13:20:30','',''),(5088,'21','222','1',1,'Retail Sale Id 4427',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 13:22:16','',''),(5089,'21','222','1',1,'Retail Sale Id 4428',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 13:25:13','',''),(5090,'21','222','1',1,'Retail Sale Id 4429',1003.20,0.00,0.00,1.32,0.00,'2022-07-24 13:27:19','',''),(5091,'21','222','1',1,'Retail Sale Id 4430',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 13:28:30','',''),(5092,'21','222','1',1,'Retail Sale Id 4431',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 13:30:15','',''),(5093,'21','222','1',1,'Retail Sale Id 4432',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 13:34:16','',''),(5094,'21','222','1',1,'Retail Sale Id 4433',3040.00,0.00,0.00,4.00,0.00,'2022-07-24 13:35:57','',''),(5095,'21','222','1',1,'Retail Sale Id 4434',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 13:37:36','',''),(5096,'21','222','1',1,'Retail Sale Id 4434',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 13:37:36','',''),(5097,'21','222','1',1,'Retail Sale Id 4435',3997.60,0.00,0.00,5.26,0.00,'2022-07-24 13:38:54','',''),(5098,'21','222','1',1,'Retail Sale Id 4436',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 13:41:14','',''),(5099,'21','222','1',1,'Retail Sale Id 4436',15200.00,0.00,0.00,20.00,0.00,'2022-07-24 13:41:14','',''),(5100,'21','222','1',1,'Retail Sale Id 4437',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 13:42:57','',''),(5101,'21','222','1',1,'Retail Sale Id 4438',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 13:45:09','',''),(5102,'21','222','1',1,'Retail Sale Id 4439',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 13:46:41','',''),(5103,'21','222','1',1,'Retail Sale Id 4440',1520.00,0.00,0.00,2.00,0.00,'2022-07-24 13:48:05','',''),(5104,'21','222','1',1,'Retail Sale Id 4441',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 13:50:19','',''),(5105,'21','222','1',1,'Retail Sale Id 4442',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 13:51:57','',''),(5106,'21','222','1',1,'Retail Sale Id 4443',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 13:53:38','',''),(5107,'21','222','1',1,'Retail Sale Id 4444',1003.20,0.00,0.00,1.32,0.00,'2022-07-24 13:56:24','',''),(5108,'21','222','1',1,'Retail Sale Id 4445',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 13:57:53','',''),(5109,'21','222','1',1,'Retail Sale Id 4446',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 13:58:46','',''),(5110,'21','222','1',1,'Retail Sale Id 4447',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:00:37','',''),(5111,'21','222','1',1,'Retail Sale Id 4448',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 14:03:50','',''),(5112,'21','222','1',1,'Retail Sale Id 4449',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 14:06:45','',''),(5113,'21','222','1',1,'Retail Sale Id 4451',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 14:09:27','',''),(5114,'21','222','1',1,'Retail Sale Id 4451',15200.00,0.00,0.00,20.00,0.00,'2022-07-24 14:09:27','',''),(5115,'21','222','1',1,'Retail Sale Id 4452',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 14:13:06','',''),(5116,'21','222','1',1,'Retail Sale Id 4453',1003.20,0.00,0.00,1.32,0.00,'2022-07-24 14:18:34','',''),(5117,'21','222','1',1,'Retail Sale Id 4453',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 14:18:34','',''),(5118,'21','222','1',1,'Retail Sale Id 4454',38000.00,0.00,0.00,50.00,0.00,'2022-07-24 14:21:09','',''),(5119,'21','222','1',1,'Retail Sale Id 4455',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 14:23:32','',''),(5120,'21','222','1',1,'Retail Sale Id 4456',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:24:34','',''),(5121,'21','222','1',1,'Retail Sale Id 4457',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:28:21','',''),(5122,'21','222','1',1,'Retail Sale Id 4458',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 14:30:17','',''),(5123,'21','222','1',1,'Retail Sale Id 4459',3503.60,0.00,0.00,4.61,0.00,'2022-07-24 14:32:12','',''),(5124,'21','222','1',1,'Retail Sale Id 4460',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:33:04','',''),(5125,'21','222','1',1,'Retail Sale Id 4461',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:34:28','',''),(5126,'21','222','1',1,'Retail Sale Id 4462',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:40:51','',''),(5127,'21','222','1',1,'Retail Sale Id 4463',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:41:40','',''),(5128,'21','222','1',1,'Retail Sale Id 4464',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:46:21','',''),(5129,'21','222','1',1,'Retail Sale Id 4465',4803.20,0.00,0.00,6.32,0.00,'2022-07-24 14:47:38','',''),(5130,'21','222','1',1,'Retail Sale Id 4466',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 14:50:09','',''),(5131,'21','222','1',1,'Retail Sale Id 4467',8496.80,0.00,0.00,11.18,0.00,'2022-07-24 14:51:43','',''),(5132,'21','222','1',1,'Retail Sale Id 4468',19000.00,0.00,0.00,25.00,0.00,'2022-07-24 14:56:23','',''),(5133,'21','222','1',1,'Retail Sale Id 4469',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 15:00:14','',''),(5134,'21','222','1',1,'Retail Sale Id 4470',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 15:06:08','',''),(5135,'21','222','1',1,'Retail Sale Id 4471',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 15:08:18','',''),(5136,'21','222','1',1,'Retail Sale Id 4472',8002.80,0.00,0.00,10.53,0.00,'2022-07-24 15:11:00','',''),(5137,'21','222','1',1,'Retail Sale Id 4473',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 15:21:17','',''),(5138,'21','222','1',1,'Retail Sale Id 4474',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 15:25:41','',''),(5139,'21','222','1',1,'Retail Sale Id 4475',7600.00,0.00,0.00,10.00,0.00,'2022-07-24 15:28:44','',''),(5140,'21','222','1',1,'Retail Sale Id 4476',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 15:38:40','',''),(5141,'21','222','1',1,'Retail Sale Id 4477',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 15:42:06','',''),(5142,'21','222','1',1,'Retail Sale Id 4478',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 15:43:53','',''),(5143,'21','222','1',1,'Retail Sale Id 4479',3503.60,0.00,0.00,4.61,0.00,'2022-07-24 15:47:55','',''),(5144,'21','222','1',1,'Retail Sale Id 4480',3800.00,0.00,0.00,5.00,0.00,'2022-07-24 15:49:55','',''),(5145,'21','222','1',1,'Retail Sale Id 4481',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 15:51:46','',''),(5146,'21','222','1',1,'Retail Sale Id 4482',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 15:56:06','',''),(5147,'21','222','1',1,'Retail Sale Id 4483',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 16:01:08','',''),(5148,'21','222','1',1,'Retail Sale Id 4484',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:14:23','',''),(5149,'21','222','1',1,'Retail Sale Id 4485',1497.20,0.00,0.00,1.97,0.00,'2022-07-24 16:15:24','',''),(5150,'21','222','1',1,'Retail Sale Id 4486',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:19:47','',''),(5151,'21','222','1',1,'Retail Sale Id 4487',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:22:28','',''),(5152,'21','222','1',1,'Retail Sale Id 4488',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 16:29:21','',''),(5153,'21','222','1',1,'Retail Sale Id 4489',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:30:41','',''),(5154,'21','222','1',1,'Retail Sale Id 4490',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 16:32:11','',''),(5155,'21','222','1',1,'Retail Sale Id 4491',8002.80,0.00,0.00,10.53,0.00,'2022-07-24 16:35:25','',''),(5156,'21','222','1',1,'Retail Sale Id 4492',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:41:45','',''),(5157,'21','222','1',1,'Retail Sale Id 4492',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:41:45','',''),(5158,'21','222','1',1,'Retail Sale Id 4493',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:51:00','',''),(5159,'21','222','1',1,'Retail Sale Id 4494',2500.40,0.00,0.00,3.29,0.00,'2022-07-24 16:53:19','',''),(5160,'21','222','1',1,'Retail Sale Id 4495',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:54:29','',''),(5161,'21','222','1',1,'Retail Sale Id 4496',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 16:56:00','',''),(5162,'21','222','1',1,'Retail Sale Id 4497',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 17:04:22','',''),(5163,'21','222','1',1,'Retail Sale Id 4498',3002.00,0.00,0.00,3.95,0.00,'2022-07-24 17:06:59','',''),(5164,'21','222','1',1,'Retail Sale Id 4499',38000.00,0.00,0.00,50.00,0.00,'2022-07-24 17:09:12','',''),(5165,'21','222','1',1,'Retail Sale Id 4500',760.00,0.00,0.00,1.00,0.00,'2022-07-24 17:10:05','',''),(5166,'21','222','1',1,'Retail Sale Id 4501',38000.00,0.00,0.00,50.00,0.00,'2022-07-24 17:11:07','',''),(5167,'21','222','1',1,'Retail Sale Id 4502',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 17:16:18','',''),(5168,'21','222','1',1,'Retail Sale Id 4503',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:19:30','',''),(5169,'21','222','1',1,'Retail Sale Id 4503',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:19:30','',''),(5170,'21','222','1',1,'Retail Sale Id 4504',3002.00,0.00,0.00,3.95,0.00,'2022-07-24 17:21:15','',''),(5171,'21','222','1',1,'Retail Sale Id 4505',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:22:38','',''),(5172,'21','222','1',1,'Retail Sale Id 4506',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 17:23:53','',''),(5173,'21','222','1',1,'Retail Sale Id 4507',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:25:28','',''),(5174,'21','222','1',1,'Retail Sale Id 4508',760.00,0.00,0.00,1.00,0.00,'2022-07-24 17:28:01','',''),(5175,'21','222','1',1,'Retail Sale Id 4509',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:30:06','',''),(5176,'21','222','1',1,'Retail Sale Id 4510',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 17:32:05','',''),(5177,'21','222','1',1,'Retail Sale Id 4511',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:33:08','',''),(5178,'21','222','1',1,'Retail Sale Id 4512',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 17:34:10','',''),(5179,'21','222','1',1,'Retail Sale Id 4513',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 17:37:05','',''),(5180,'21','222','1',1,'Retail Sale Id 4514',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:38:45','',''),(5181,'21','222','1',1,'Retail Sale Id 4515',8998.40,0.00,0.00,11.84,0.00,'2022-07-24 17:39:56','',''),(5182,'21','222','1',1,'Retail Sale Id 4516',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:43:25','',''),(5183,'21','222','1',1,'Retail Sale Id 4517',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 17:46:47','',''),(5184,'21','222','1',1,'Retail Sale Id 4518',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 17:48:44','',''),(5185,'21','222','1',1,'Retail Sale Id 4519',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 17:50:30','',''),(5186,'21','222','1',1,'Retail Sale Id 4520',3002.00,0.00,0.00,3.95,0.00,'2022-07-24 17:55:42','',''),(5187,'21','222','1',1,'Retail Sale Id 4520',3997.60,0.00,0.00,5.26,0.00,'2022-07-24 17:55:42','',''),(5188,'21','222','1',1,'Retail Sale Id 4521',2280.00,0.00,0.00,3.00,0.00,'2022-07-24 18:04:49','',''),(5189,'21','222','1',1,'Retail Sale Id 4522',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 18:12:20','',''),(5190,'21','222','1',1,'Retail Sale Id 4523',760.00,0.00,0.00,1.00,0.00,'2022-07-24 18:15:08','',''),(5191,'21','222','1',1,'Retail Sale Id 4524',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 18:16:17','',''),(5192,'21','222','1',1,'Retail Sale Id 4525',1140.00,0.00,0.00,1.50,0.00,'2022-07-24 18:17:32','',''),(5193,'21','222','1',1,'Retail Sale Id 4526',1801.20,0.00,0.00,2.37,0.00,'2022-07-24 18:19:35','',''),(5194,'21','222','1',1,'Retail Sale Id 4527',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 18:21:02','',''),(5195,'21','222','1',1,'Retail Sale Id 4528',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 18:25:43','',''),(5196,'21','222','1',1,'Retail Sale Id 4529',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 18:33:28','',''),(5197,'21','222','1',1,'Retail Sale Id 4530',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 18:37:18','',''),(5198,'21','222','1',1,'Retail Sale Id 4531',5000.80,0.00,0.00,6.58,0.00,'2022-07-24 18:38:29','',''),(5199,'21','222','1',1,'Retail Sale Id 4532',1998.80,0.00,0.00,2.63,0.00,'2022-07-24 18:41:18','',''),(5200,'21','222','1',1,'Retail Sale Id 4533',4750.00,0.00,0.00,6.25,0.00,'2022-07-24 18:55:38','',''),(5201,'21','222','1',1,'Retail Sale Id 4534',1003.20,0.00,0.00,1.32,0.00,'2022-07-24 19:00:45','',''),(5202,'21','222','1',1,'Retail Sale Id 4534',1003.20,0.00,0.00,1.32,0.00,'2022-07-24 19:00:45','',''),(5203,'21','222','1',1,'Retail Sale Id 4535',3002.00,0.00,0.00,3.95,0.00,'2022-07-24 19:02:32','',''),(5204,'21','222','1',1,'Retail Sale Id 4536',4560.00,0.00,0.00,6.00,0.00,'2022-07-24 19:07:42','',''),(5205,'21','222','1',1,'Retail Sale Id 4537',5996.40,0.00,0.00,7.89,0.00,'2022-07-24 19:16:16','',''),(5206,'21','222','1',1,'Retail Sale Id 4538',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 19:18:55','',''),(5207,'21','222','1',1,'Retail Sale Id 4539',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 19:22:36','',''),(5208,'21','222','1',1,'Retail Sale Id 4540',9500.00,0.00,0.00,12.50,0.00,'2022-07-24 19:25:37','',''),(5209,'21','222','1',1,'Retail Sale Id 4541',2500.40,0.00,0.00,3.29,0.00,'2022-07-24 19:28:15','',''),(5210,'21','222','1',1,'Retail Sale Id 4542',12646.40,0.00,0.00,16.64,0.00,'2022-07-24 20:34:17','',''),(5211,'21','222','1',1,'Retail Sale Id 4543',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 08:29:02','',''),(5212,'21','222','1',1,'Retail Sale Id 4544',6999.60,0.00,0.00,9.21,0.00,'2022-07-25 08:30:23','',''),(5213,'21','222','1',1,'Retail Sale Id 4545',2280.00,0.00,0.00,3.00,0.00,'2022-07-25 08:34:34','',''),(5214,'21','222','1',1,'Retail Sale Id 4546',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 08:39:08','',''),(5215,'21','222','1',1,'Retail Sale Id 4547',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 08:39:54','',''),(5216,'21','222','1',1,'Retail Sale Id 4548',7600.00,0.00,0.00,10.00,0.00,'2022-07-25 08:40:31','',''),(5217,'21','222','1',1,'Retail Sale Id 4549',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 08:46:47','',''),(5218,'21','222','1',1,'Retail Sale Id 4550',3002.00,0.00,0.00,3.95,0.00,'2022-07-25 08:51:22','',''),(5219,'21','222','1',1,'Retail Sale Id 4551',7600.00,0.00,0.00,10.00,0.00,'2022-07-25 08:56:04','',''),(5220,'21','222','1',1,'Retail Sale Id 4552',3800.00,0.00,0.00,5.00,0.00,'2022-07-25 08:57:50','',''),(5221,'21','222','1',1,'Retail Sale Id 4553',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:00:06','',''),(5222,'21','222','1',1,'Retail Sale Id 4554',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:04:32','',''),(5223,'21','222','1',1,'Retail Sale Id 4555',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:11:10','',''),(5224,'21','222','1',1,'Retail Sale Id 4556',11400.00,0.00,0.00,15.00,0.00,'2022-07-25 09:13:38','',''),(5225,'21','222','1',1,'Retail Sale Id 4557',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:15:32','',''),(5226,'21','222','1',1,'Retail Sale Id 4558',4750.00,0.00,0.00,6.25,0.00,'2022-07-25 09:17:54','',''),(5227,'21','222','1',1,'Retail Sale Id 4559',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:19:33','',''),(5228,'21','222','1',1,'Retail Sale Id 4560',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:21:39','',''),(5229,'21','222','1',1,'Retail Sale Id 4561',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 09:23:27','',''),(5230,'21','222','1',1,'Retail Sale Id 4562',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:25:00','',''),(5231,'21','222','1',1,'Retail Sale Id 4563',8496.80,0.00,0.00,11.18,0.00,'2022-07-25 09:33:58','',''),(5232,'21','222','1',1,'Retail Sale Id 4564',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:40:52','',''),(5233,'21','222','1',1,'Retail Sale Id 4565',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 09:45:02','',''),(5234,'21','222','1',1,'Retail Sale Id 4566',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 09:51:16','',''),(5235,'21','222','1',1,'Retail Sale Id 4567',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 09:56:40','',''),(5236,'21','222','1',1,'Retail Sale Id 4568',3997.60,0.00,0.00,5.26,0.00,'2022-07-25 10:02:28','',''),(5237,'21','222','1',1,'Retail Sale Id 4569',1520.00,0.00,0.00,2.00,0.00,'2022-07-25 10:07:21','',''),(5238,'21','222','1',1,'Retail Sale Id 4570',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 10:21:54','',''),(5239,'21','222','1',1,'Retail Sale Id 4571',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 10:23:04','',''),(5240,'21','222','1',1,'Retail Sale Id 4572',6840.00,0.00,0.00,9.00,0.00,'2022-07-25 10:29:28','',''),(5241,'21','222','1',1,'Retail Sale Id 4573',2280.00,0.00,0.00,3.00,0.00,'2022-07-25 10:30:57','',''),(5242,'21','222','1',1,'Retail Sale Id 4574',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 11:06:52','',''),(5243,'21','222','1',1,'Retail Sale Id 4575',3800.00,0.00,0.00,5.00,0.00,'2022-07-25 11:08:17','',''),(5244,'21','222','1',1,'Retail Sale Id 4576',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 11:10:30','',''),(5245,'21','222','1',1,'Retail Sale Id 4577',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 11:13:28','',''),(5246,'21','222','1',1,'Retail Sale Id 4578',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 11:16:19','',''),(5247,'21','222','1',1,'Retail Sale Id 4579',1998.80,0.00,0.00,2.63,0.00,'2022-07-25 11:22:42','',''),(5248,'21','222','1',1,'Retail Sale Id 4580',1497.20,0.00,0.00,1.97,0.00,'2022-07-25 11:24:24','',''),(5249,'21','222','1',1,'Retail Sale Id 4581',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 11:26:21','',''),(5250,'21','222','1',1,'Retail Sale Id 4582',3800.00,0.00,0.00,5.00,0.00,'2022-07-25 11:35:06','',''),(5251,'21','222','1',1,'Retail Sale Id 4583',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 11:41:21','',''),(5252,'21','222','1',1,'Retail Sale Id 4584',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 12:46:32','',''),(5253,'21','222','1',1,'Retail Sale Id 4585',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 13:17:00','',''),(5254,'21','222','1',1,'Retail Sale Id 4586',2280.00,0.00,0.00,3.00,0.00,'2022-07-25 13:20:55','',''),(5255,'21','222','1',1,'Retail Sale Id 4587',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 13:23:03','',''),(5256,'21','222','1',1,'Retail Sale Id 4588',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 13:43:54','',''),(5257,'21','222','1',1,'Retail Sale Id 4589',5000.80,0.00,0.00,6.58,0.00,'2022-07-25 13:58:03','',''),(5258,'21','222','1',1,'Retail Sale Id 4589',6999.60,0.00,0.00,9.21,0.00,'2022-07-25 13:58:03','',''),(5259,'21','222','1',1,'Retail Sale Id 4590',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 14:02:51','',''),(5260,'21','222','1',1,'Retail Sale Id 4591',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 14:04:54','',''),(5261,'21','222','1',1,'Retail Sale Id 4592',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 14:15:52','',''),(5262,'21','222','1',1,'Retail Sale Id 4593',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 14:28:29','',''),(5263,'21','222','1',1,'Retail Sale Id 4593',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 14:28:29','',''),(5264,'21','222','1',1,'Retail Sale Id 4594',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 14:32:36','',''),(5265,'21','222','1',1,'Retail Sale Id 4595',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 14:48:05','',''),(5266,'21','222','1',1,'Retail Sale Id 4597',3800.00,0.00,0.00,5.00,0.00,'2022-07-25 14:50:16','',''),(5267,'21','222','1',1,'Retail Sale Id 4598',760.00,0.00,0.00,1.00,0.00,'2022-07-25 14:51:48','',''),(5268,'21','222','1',1,'Retail Sale Id 4599',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 15:08:08','',''),(5269,'21','222','1',1,'Retail Sale Id 4600',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 15:33:07','',''),(5270,'21','222','1',1,'Retail Sale Id 4601',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 15:35:53','',''),(5271,'21','222','1',1,'Retail Sale Id 4602',3040.00,0.00,0.00,4.00,0.00,'2022-07-25 15:40:02','',''),(5272,'21','222','1',1,'Retail Sale Id 4603',5000.80,0.00,0.00,6.58,0.00,'2022-07-25 15:44:44','',''),(5273,'21','222','1',1,'Retail Sale Id 4604',5000.80,0.00,0.00,6.58,0.00,'2022-07-25 16:11:38','',''),(5274,'21','222','1',1,'Retail Sale Id 4605',3002.00,0.00,0.00,3.95,0.00,'2022-07-25 16:13:18','',''),(5275,'21','222','1',1,'Retail Sale Id 4606',3800.00,0.00,0.00,5.00,0.00,'2022-07-25 16:14:27','',''),(5276,'21','222','1',1,'Retail Sale Id 4607',1003.20,0.00,0.00,1.32,0.00,'2022-07-25 16:15:35','',''),(5277,'21','222','1',1,'Retail Sale Id 4608',3997.60,0.00,0.00,5.26,0.00,'2022-07-25 16:18:16','',''),(5278,'21','222','1',1,'Retail Sale Id 4609',2280.00,0.00,0.00,3.00,0.00,'2022-07-25 16:22:38','',''),(5279,'21','222','1',1,'Retail Sale Id 4610',3002.00,0.00,0.00,3.95,0.00,'2022-07-25 16:26:22','',''),(5280,'21','222','1',1,'Retail Sale Id 4611',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 16:35:30','',''),(5281,'21','222','1',1,'Retail Sale Id 4611',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 16:35:30','',''),(5282,'21','222','1',1,'Retail Sale Id 4612',3997.60,0.00,0.00,5.26,0.00,'2022-07-25 16:36:18','',''),(5283,'21','222','1',1,'Retail Sale Id 4613',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 16:37:32','',''),(5284,'21','222','1',1,'Retail Sale Id 4614',3040.00,0.00,0.00,4.00,0.00,'2022-07-25 16:39:31','',''),(5285,'21','222','1',1,'Retail Sale Id 4615',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 16:41:06','',''),(5286,'21','222','1',1,'Retail Sale Id 4615',9500.00,0.00,0.00,12.50,0.00,'2022-07-25 16:41:06','',''),(5287,'21','222','1',1,'Retail Sale Id 4616',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 16:43:18','',''),(5288,'21','222','1',1,'Retail Sale Id 4617',1520.00,0.00,0.00,2.00,0.00,'2022-07-25 17:24:17','',''),(5289,'21','222','1',1,'Retail Sale Id 4618',2280.00,0.00,0.00,3.00,0.00,'2022-07-25 17:34:55','',''),(5290,'21','222','1',1,'Retail Sale Id 4619',4560.00,0.00,0.00,6.00,0.00,'2022-07-25 17:57:20','',''),(5291,'21','222','1',1,'Retail Sale Id 4619',7600.00,0.00,0.00,10.00,0.00,'2022-07-25 17:57:20','',''),(5292,'21','222','1',1,'Retail Sale Id 4620',109561.60,0.00,0.00,144.16,0.00,'2022-07-25 20:21:50','',''),(5293,'21','222','1',1,'Retail Sale Id 4621',56300.80,0.00,0.00,74.08,0.00,'2022-07-25 20:23:02','',''),(5294,'21','222','1',1,'Retail Sale Id 4622',38000.00,0.00,0.00,50.00,0.00,'2022-07-25 20:24:18','',''),(5295,'21','222','1',1,'Retail Sale Id 4623',76000.00,0.00,0.00,100.00,0.00,'2022-07-25 20:25:43','',''),(5296,'21','222','1',1,'Retail Sale Id 4624',17730.80,0.00,0.00,23.33,0.00,'2022-07-25 20:27:23','',''),(5297,'21','222','1',1,'Retail Sale Id 4625',3997.60,0.00,0.00,5.26,0.00,'2022-07-26 07:53:50','',''),(5298,'21','222','1',1,'Retail Sale Id 4626',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:07:46','',''),(5299,'21','222','1',1,'Retail Sale Id 4627',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:08:29','',''),(5300,'21','222','1',1,'Retail Sale Id 4628',3040.00,0.00,0.00,4.00,0.00,'2022-07-26 08:09:17','',''),(5301,'21','222','1',1,'Retail Sale Id 4629',11400.00,0.00,0.00,15.00,0.00,'2022-07-26 08:10:49','',''),(5302,'21','222','1',1,'Retail Sale Id 4630',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:11:28','',''),(5303,'21','222','1',1,'Retail Sale Id 4631',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 08:12:15','',''),(5304,'21','222','1',1,'Retail Sale Id 4632',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:13:00','',''),(5305,'21','222','1',1,'Retail Sale Id 4633',8998.40,0.00,0.00,11.84,0.00,'2022-07-26 08:16:57','',''),(5306,'21','222','1',1,'Retail Sale Id 4634',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 08:20:17','',''),(5307,'21','222','1',1,'Retail Sale Id 4635',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 08:22:07','',''),(5308,'21','222','1',1,'Retail Sale Id 4636',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:23:50','',''),(5309,'21','222','1',1,'Retail Sale Id 4637',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 08:25:46','',''),(5310,'21','222','1',1,'Retail Sale Id 4638',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 08:30:12','',''),(5311,'21','222','1',1,'Retail Sale Id 4639',7600.00,0.00,0.00,10.00,0.00,'2022-07-26 08:33:22','',''),(5312,'21','222','1',1,'Retail Sale Id 4640',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 09:05:34','',''),(5313,'21','222','1',1,'Retail Sale Id 4642',3997.60,0.00,0.00,5.26,0.00,'2022-07-26 09:21:21','',''),(5314,'21','222','1',1,'Retail Sale Id 4643',2500.40,0.00,0.00,3.29,0.00,'2022-07-26 09:30:03','',''),(5315,'21','222','1',1,'Retail Sale Id 4644',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 09:31:49','',''),(5316,'21','222','1',1,'Retail Sale Id 4645',8002.80,0.00,0.00,10.53,0.00,'2022-07-26 09:35:28','',''),(5317,'21','222','1',1,'Retail Sale Id 4646',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 09:36:45','',''),(5318,'21','222','1',1,'Retail Sale Id 4647',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 09:41:07','',''),(5319,'21','222','1',1,'Retail Sale Id 4648',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 09:42:43','',''),(5320,'21','222','1',1,'Retail Sale Id 4649',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 09:44:24','',''),(5321,'21','222','1',1,'Retail Sale Id 4650',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 10:03:00','',''),(5322,'21','222','1',1,'Retail Sale Id 4651',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 10:05:25','',''),(5323,'21','222','1',1,'Retail Sale Id 4652',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 10:10:12','',''),(5324,'21','222','1',1,'Retail Sale Id 4653',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 10:16:40','',''),(5325,'21','222','1',1,'Retail Sale Id 4655',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 10:26:09','',''),(5326,'21','222','1',1,'Retail Sale Id 4656',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 11:03:35','',''),(5327,'21','222','1',1,'Retail Sale Id 4657',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 11:08:16','',''),(5328,'21','222','1',1,'Retail Sale Id 4658',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 11:13:03','',''),(5329,'21','222','1',1,'Retail Sale Id 4659',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 11:27:28','',''),(5330,'21','222','1',1,'Retail Sale Id 4660',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 11:32:04','',''),(5331,'21','222','1',1,'Retail Sale Id 4661',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 11:36:22','',''),(5332,'21','222','1',1,'Retail Sale Id 4662',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 12:14:31','',''),(5333,'21','222','1',1,'Retail Sale Id 4663',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 12:15:47','',''),(5334,'21','222','1',1,'Retail Sale Id 4664',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 12:23:02','',''),(5335,'21','222','1',1,'Retail Sale Id 4665',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 12:24:22','',''),(5336,'21','222','1',1,'Retail Sale Id 4666',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 12:25:11','',''),(5337,'21','222','1',1,'Retail Sale Id 4667',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 12:27:14','',''),(5338,'21','222','1',1,'Retail Sale Id 4667',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 12:27:14','',''),(5339,'21','222','1',1,'Retail Sale Id 4668',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 12:33:03','',''),(5340,'21','222','1',1,'Retail Sale Id 4669',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 12:34:45','',''),(5341,'21','222','1',1,'Retail Sale Id 4670',8998.40,0.00,0.00,11.84,0.00,'2022-07-26 12:51:23','',''),(5342,'21','222','1',1,'Retail Sale Id 4671',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 12:54:58','',''),(5343,'21','222','1',1,'Retail Sale Id 4672',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 13:16:38','',''),(5344,'21','222','1',1,'Retail Sale Id 4673',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 13:18:42','',''),(5345,'21','222','1',1,'Retail Sale Id 4674',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 13:27:44','',''),(5346,'21','222','1',1,'Retail Sale Id 4675',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 13:34:00','',''),(5347,'21','222','1',1,'Retail Sale Id 4676',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 13:47:45','',''),(5348,'21','222','1',1,'Retail Sale Id 4677',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 14:01:59','',''),(5349,'21','222','1',1,'Retail Sale Id 4677',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 14:01:59','',''),(5350,'21','222','1',1,'Retail Sale Id 4678',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 14:19:25','',''),(5351,'21','222','1',1,'Retail Sale Id 4678',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 14:19:25','',''),(5352,'21','222','1',1,'Retail Sale Id 4679',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 14:41:57','',''),(5353,'21','222','1',1,'Retail Sale Id 4680',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 14:42:29','',''),(5354,'21','222','1',1,'Retail Sale Id 4681',11400.00,0.00,0.00,15.00,0.00,'2022-07-26 14:43:07','',''),(5355,'21','222','1',1,'Retail Sale Id 4682',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 15:10:56','',''),(5356,'21','222','1',1,'Retail Sale Id 4682',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 15:10:56','',''),(5357,'21','222','1',1,'Retail Sale Id 4682',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 15:10:56','',''),(5358,'21','222','1',1,'Retail Sale Id 4683',8002.80,0.00,0.00,10.53,0.00,'2022-07-26 15:14:32','',''),(5359,'21','222','1',1,'Retail Sale Id 4684',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 15:24:27','',''),(5360,'21','222','1',1,'Retail Sale Id 4685',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 15:29:21','',''),(5361,'21','222','1',1,'Retail Sale Id 4686',5000.80,0.00,0.00,6.58,0.00,'2022-07-26 15:42:25','',''),(5362,'21','222','1',1,'Retail Sale Id 4687',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 15:55:36','',''),(5363,'21','222','1',1,'Retail Sale Id 4688',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 16:15:03','',''),(5364,'21','222','1',1,'Retail Sale Id 4688',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 16:15:03','',''),(5365,'21','222','1',1,'Retail Sale Id 4689',8998.40,0.00,0.00,11.84,0.00,'2022-07-26 16:28:09','',''),(5366,'21','222','1',1,'Retail Sale Id 4690',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 16:29:55','',''),(5367,'21','222','1',1,'Retail Sale Id 4690',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 16:29:55','',''),(5368,'21','222','1',1,'Retail Sale Id 4691',7980.00,0.00,0.00,10.50,0.00,'2022-07-26 16:31:28','',''),(5369,'21','222','1',1,'Retail Sale Id 4692',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 16:34:26','',''),(5370,'21','222','1',1,'Retail Sale Id 4693',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 16:35:52','',''),(5371,'21','222','1',1,'Retail Sale Id 4694',3997.60,0.00,0.00,5.26,0.00,'2022-07-26 16:37:10','',''),(5372,'21','222','1',1,'Retail Sale Id 4695',1003.20,0.00,0.00,1.32,0.00,'2022-07-26 17:53:36','',''),(5373,'21','222','1',1,'Retail Sale Id 4695',1003.20,0.00,0.00,1.32,0.00,'2022-07-26 17:53:36','',''),(5374,'21','222','1',1,'Retail Sale Id 4696',1003.20,0.00,0.00,1.32,0.00,'2022-07-26 17:55:11','',''),(5375,'21','222','1',1,'Retail Sale Id 4696',1497.20,0.00,0.00,1.97,0.00,'2022-07-26 17:55:11','',''),(5376,'21','222','1',1,'Retail Sale Id 4697',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 17:58:27','',''),(5377,'21','222','1',1,'Retail Sale Id 4698',760.00,0.00,0.00,1.00,0.00,'2022-07-26 18:02:07','',''),(5378,'21','222','1',1,'Retail Sale Id 4699',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 18:06:44','',''),(5379,'21','222','1',1,'Retail Sale Id 4700',11400.00,0.00,0.00,15.00,0.00,'2022-07-26 18:07:36','',''),(5380,'21','222','1',1,'Retail Sale Id 4701',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 18:09:26','',''),(5381,'21','222','1',1,'Retail Sale Id 4702',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 18:10:40','',''),(5382,'21','222','1',1,'Retail Sale Id 4703',7600.00,0.00,0.00,10.00,0.00,'2022-07-26 18:12:54','',''),(5383,'21','222','1',1,'Retail Sale Id 4704',4560.00,0.00,0.00,6.00,0.00,'2022-07-26 18:21:40','',''),(5384,'21','222','1',1,'Retail Sale Id 4705',38000.00,0.00,0.00,50.00,0.00,'2022-07-26 18:23:01','',''),(5385,'21','222','1',1,'Retail Sale Id 4706',3997.60,0.00,0.00,5.26,0.00,'2022-07-26 18:27:23','',''),(5386,'21','222','1',1,'Retail Sale Id 4707',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 18:30:29','',''),(5387,'21','222','1',1,'Retail Sale Id 4708',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 18:32:07','',''),(5388,'21','222','1',1,'Retail Sale Id 4710',1003.20,0.00,0.00,1.32,0.00,'2022-07-26 18:36:24','',''),(5389,'21','222','1',1,'Retail Sale Id 4711',9500.00,0.00,0.00,12.50,0.00,'2022-07-26 18:39:48','',''),(5390,'21','222','1',1,'Retail Sale Id 4712',3800.00,0.00,0.00,5.00,0.00,'2022-07-26 18:54:50','',''),(5391,'21','222','1',1,'Retail Sale Id 4713',2280.00,0.00,0.00,3.00,0.00,'2022-07-26 18:56:08','',''),(5392,'21','222','1',1,'Retail Sale Id 4714',3040.00,0.00,0.00,4.00,0.00,'2022-07-26 18:59:07','',''),(5393,'21','222','1',1,'Retail Sale Id 4715',7600.00,0.00,0.00,10.00,0.00,'2022-07-26 19:04:30','',''),(5394,'21','222','1',1,'Retail Sale Id 4716',72998.00,0.00,0.00,96.05,0.00,'2022-07-26 19:35:38','',''),(5395,'21','222','1',1,'Retail Sale Id 4717',38000.00,0.00,0.00,50.00,0.00,'2022-07-26 19:36:59','',''),(5396,'21','222','1',1,'Retail Sale Id 4719',38000.00,0.00,0.00,50.00,0.00,'2022-07-26 19:38:12','',''),(5397,'21','222','1',1,'Retail Sale Id 4720',38000.00,0.00,0.00,50.00,0.00,'2022-07-26 19:39:17','',''),(5398,'21','222','1',1,'Retail Sale Id 4721',1945.60,0.00,0.00,2.56,0.00,'2022-07-26 19:47:17','',''),(5399,'21','222','1',1,'Retail Sale Id 4722',6999.60,0.00,0.00,9.21,0.00,'2022-07-27 09:07:03','',''),(5400,'21','222','1',1,'Retail Sale Id 4723',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 09:49:31','',''),(5401,'21','222','1',1,'Retail Sale Id 4724',1520.00,0.00,0.00,2.00,0.00,'2022-07-27 09:58:02','',''),(5402,'21','222','1',1,'Retail Sale Id 4725',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 09:58:48','',''),(5403,'21','222','1',1,'Retail Sale Id 4726',6999.60,0.00,0.00,9.21,0.00,'2022-07-27 10:00:08','',''),(5404,'21','222','1',1,'Retail Sale Id 4727',4560.00,0.00,0.00,6.00,0.00,'2022-07-27 10:02:18','',''),(5405,'21','222','1',1,'Retail Sale Id 4728',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 10:02:55','',''),(5406,'21','222','1',1,'Retail Sale Id 4729',4560.00,0.00,0.00,6.00,0.00,'2022-07-27 10:03:50','',''),(5407,'21','222','1',1,'Retail Sale Id 4730',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 10:04:44','',''),(5408,'21','222','1',1,'Retail Sale Id 4731',3002.00,0.00,0.00,3.95,0.00,'2022-07-27 10:50:41','',''),(5409,'21','222','1',1,'Retail Sale Id 4732',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:02:35','',''),(5410,'21','222','1',1,'Retail Sale Id 4733',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:27:19','',''),(5411,'21','222','1',1,'Retail Sale Id 4733',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:27:19','',''),(5412,'21','222','1',1,'Retail Sale Id 4734',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:29:50','',''),(5413,'21','222','1',1,'Retail Sale Id 4735',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:30:46','',''),(5414,'21','222','1',1,'Retail Sale Id 4736',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:31:33','',''),(5415,'21','222','1',1,'Retail Sale Id 4737',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:32:19','',''),(5416,'21','222','1',1,'Retail Sale Id 4738',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:33:21','',''),(5417,'21','222','1',1,'Retail Sale Id 4739',4560.00,0.00,0.00,6.00,0.00,'2022-07-27 11:34:30','',''),(5418,'21','222','1',1,'Retail Sale Id 4740',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:35:32','',''),(5419,'21','222','1',1,'Retail Sale Id 4741',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:37:33','',''),(5420,'21','222','1',1,'Retail Sale Id 4742',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 11:38:17','',''),(5421,'21','222','1',1,'Retail Sale Id 4743',1998.80,0.00,0.00,2.63,0.00,'2022-07-27 11:39:17','',''),(5422,'21','222','1',1,'Retail Sale Id 4744',14500.80,0.00,0.00,19.08,0.00,'2022-07-27 11:40:14','',''),(5423,'21','222','1',1,'Retail Sale Id 4745',6999.60,0.00,0.00,9.21,0.00,'2022-07-27 11:41:45','',''),(5424,'21','222','1',1,'Retail Sale Id 4746',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:43:18','',''),(5425,'21','222','1',1,'Retail Sale Id 4747',5320.00,0.00,0.00,7.00,0.00,'2022-07-27 11:45:01','',''),(5426,'21','222','1',1,'Retail Sale Id 4748',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 11:46:34','',''),(5427,'21','222','1',1,'Retail Sale Id 4749',38000.00,0.00,0.00,50.00,0.00,'2022-07-27 11:48:28','',''),(5428,'21','222','1',1,'Retail Sale Id 4750',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 12:56:14','',''),(5429,'21','222','1',1,'Retail Sale Id 4751',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 12:58:07','',''),(5430,'21','222','1',1,'Retail Sale Id 4752',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 13:39:57','',''),(5431,'21','222','1',1,'Retail Sale Id 4753',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 13:40:41','',''),(5432,'21','222','1',1,'Retail Sale Id 4753',19000.00,0.00,0.00,25.00,0.00,'2022-07-27 13:40:41','',''),(5433,'21','222','1',1,'Retail Sale Id 4754',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 13:42:14','',''),(5434,'21','222','1',1,'Retail Sale Id 4755',7600.00,0.00,0.00,10.00,0.00,'2022-07-27 13:43:14','',''),(5435,'21','222','1',1,'Retail Sale Id 4755',19000.00,0.00,0.00,25.00,0.00,'2022-07-27 13:43:14','',''),(5436,'21','222','1',1,'Retail Sale Id 4756',38000.00,0.00,0.00,50.00,0.00,'2022-07-27 13:43:48','',''),(5437,'21','222','1',1,'Retail Sale Id 4757',4560.00,0.00,0.00,6.00,0.00,'2022-07-27 13:44:28','',''),(5438,'21','222','1',1,'Retail Sale Id 4757',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 13:44:28','',''),(5439,'21','222','1',1,'Retail Sale Id 4758',9500.00,0.00,0.00,12.50,0.00,'2022-07-27 13:44:49','',''),(5440,'21','222','1',1,'Retail Sale Id 4759',15200.00,0.00,0.00,20.00,0.00,'2022-07-27 13:45:11','',''),(5441,'21','222','1',1,'Return of Retail Sale Id 4756',0.00,38000.00,50.00,0.00,0.00,'2022-07-27 13:56:27','',''),(5442,'21','222','1',1,'Return of Retail Sale Id 4753',0.00,9500.00,12.50,0.00,0.00,'2022-07-27 13:57:02','',''),(5443,'21','222','1',1,'Return of Retail Sale Id 4753',0.00,19000.00,25.00,0.00,0.00,'2022-07-27 13:57:02','',''),(5444,'21','222','1',1,'Retail Sale Id 4760',1497.20,0.00,0.00,1.97,0.00,'2022-07-27 14:05:55','',''),(5445,'21','222','1',1,'Retail Sale Id 4761',15200.00,0.00,0.00,20.00,0.00,'2022-07-27 14:18:18','',''),(5446,'21','222','1',1,'Retail Sale Id 4762',7600.00,0.00,0.00,10.00,0.00,'2022-07-27 14:19:19','',''),(5447,'21','222','1',1,'Retail Sale Id 4763',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 15:20:33','',''),(5448,'21','222','1',1,'Retail Sale Id 4763',7600.00,0.00,0.00,10.00,0.00,'2022-07-27 15:20:33','',''),(5449,'21','222','1',1,'Retail Sale Id 4764',38000.00,0.00,0.00,50.00,0.00,'2022-07-27 15:40:29','',''),(5450,'21','222','1',1,'Retail Sale Id 4765',38000.00,0.00,0.00,50.00,0.00,'2022-07-27 15:41:40','',''),(5451,'21','222','1',1,'Retail Sale Id 4766',3800.00,0.00,0.00,5.00,0.00,'2022-07-27 15:42:23','',''),(5452,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-07-28 10:09:35','',''),(5453,'21','222',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,4999.14,0.00,'2022-07-28 10:12:31','',''),(5454,'21','222','1',1,'Received from bridging 36',0.00,0.00,4999.14,0.00,0.00,'2022-07-28 10:12:31','',''),(5455,'21','222','1',1,'Retail Sale Id 4767',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 10:58:38','',''),(5456,'21','222','1',1,'Retail Sale Id 4768',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 11:29:35','',''),(5457,'21','222','1',1,'Retail Sale Id 4769',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 11:51:40','',''),(5458,'21','222','1',1,'Retail Sale Id 4770',38000.00,0.00,0.00,50.00,0.00,'2022-07-28 12:55:19','',''),(5459,'21','222','1',1,'Retail Sale Id 4771',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 12:56:11','',''),(5460,'21','222','1',1,'Retail Sale Id 4771',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 12:56:11','',''),(5461,'21','222','1',1,'Retail Sale Id 4772',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 12:56:55','',''),(5462,'21','222','1',1,'Retail Sale Id 4773',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 12:57:54','',''),(5463,'21','222','1',1,'Retail Sale Id 4774',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 12:58:45','',''),(5464,'21','222','1',1,'Retail Sale Id 4775',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 12:59:40','',''),(5465,'21','222','1',1,'Retail Sale Id 4776',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 13:01:23','',''),(5466,'21','222','1',1,'Retail Sale Id 4777',6999.60,0.00,0.00,9.21,0.00,'2022-07-28 13:02:40','',''),(5467,'21','222','1',1,'Retail Sale Id 4778',14500.80,0.00,0.00,19.08,0.00,'2022-07-28 13:03:59','',''),(5468,'21','222','1',1,'Retail Sale Id 4779',13497.60,0.00,0.00,17.76,0.00,'2022-07-28 13:05:45','',''),(5469,'21','222','1',1,'Retail Sale Id 4780',4499.20,0.00,0.00,5.92,0.00,'2022-07-28 13:08:17','',''),(5470,'21','222','1',1,'Retail Sale Id 4781',10001.60,0.00,0.00,13.16,0.00,'2022-07-28 13:09:02','',''),(5471,'21','222','1',1,'Retail Sale Id 4782',3997.60,0.00,0.00,5.26,0.00,'2022-07-28 13:09:34','',''),(5472,'21','222','1',1,'Retail Sale Id 4783',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 13:10:42','',''),(5473,'21','222','1',1,'Retail Sale Id 4784',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 13:11:45','',''),(5474,'21','222','1',1,'Retail Sale Id 4785',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 13:12:31','',''),(5475,'21','222','1',1,'Retail Sale Id 4786',24000.80,0.00,0.00,31.58,0.00,'2022-07-28 13:13:47','',''),(5476,'21','222','1',1,'Retail Sale Id 4787',7600.00,0.00,0.00,10.00,0.00,'2022-07-28 13:57:09','',''),(5477,'21','222','1',1,'Retail Sale Id 4788',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 13:59:24','',''),(5478,'21','222','1',1,'Retail Sale Id 4788',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 13:59:24','',''),(5479,'21','222','1',1,'Retail Sale Id 4789',3997.60,0.00,0.00,5.26,0.00,'2022-07-28 14:01:53','',''),(5480,'21','222','1',1,'Retail Sale Id 4790',38000.00,0.00,0.00,50.00,0.00,'2022-07-28 14:08:58','',''),(5481,'21','222','1',1,'Retail Sale Id 4791',38000.00,0.00,0.00,50.00,0.00,'2022-07-28 14:09:56','',''),(5482,'21','222','1',1,'Retail Sale Id 4792',12000.40,0.00,0.00,15.79,0.00,'2022-07-28 14:12:53','',''),(5483,'21','222','1',1,'Retail Sale Id 4793',1003.20,0.00,0.00,1.32,0.00,'2022-07-28 15:38:31','',''),(5484,'21','222','1',1,'Retail Sale Id 4794',8998.40,0.00,0.00,11.84,0.00,'2022-07-28 17:01:54','',''),(5485,'21','222','1',1,'Retail Sale Id 4795',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 17:03:08','',''),(5486,'21','222','1',1,'Retail Sale Id 4796',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 17:20:04','',''),(5487,'21','222','1',1,'Retail Sale Id 4797',1998.80,0.00,0.00,2.63,0.00,'2022-07-28 17:21:28','',''),(5488,'21','222','1',1,'Retail Sale Id 4798',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 17:48:48','',''),(5489,'21','222','1',1,'Retail Sale Id 4798',11400.00,0.00,0.00,15.00,0.00,'2022-07-28 17:48:48','',''),(5490,'21','222','1',1,'Retail Sale Id 4799',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 17:50:25','',''),(5491,'21','222','1',1,'Retail Sale Id 4800',1497.20,0.00,0.00,1.97,0.00,'2022-07-28 17:51:09','',''),(5492,'21','222','1',1,'Retail Sale Id 4801',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 17:55:20','',''),(5493,'21','222','1',1,'Retail Sale Id 4802',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 17:57:17','',''),(5494,'21','222','1',1,'Retail Sale Id 4803',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 17:59:31','',''),(5495,'21','222','1',1,'Retail Sale Id 4803',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 17:59:31','',''),(5496,'21','222','1',1,'Retail Sale Id 4804',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 18:05:19','',''),(5497,'21','222','1',1,'Retail Sale Id 4805',2280.00,0.00,0.00,3.00,0.00,'2022-07-28 18:06:50','',''),(5498,'21','222','1',1,'Retail Sale Id 4806',5000.80,0.00,0.00,6.58,0.00,'2022-07-28 18:07:56','',''),(5499,'21','222','1',1,'Retail Sale Id 4807',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 18:10:15','',''),(5500,'21','222','1',1,'Retail Sale Id 4808',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 18:15:27','',''),(5501,'21','222','1',1,'Retail Sale Id 4809',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 18:17:53','',''),(5502,'21','222','1',1,'Retail Sale Id 4810',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 18:18:59','',''),(5503,'21','222','1',1,'Retail Sale Id 4811',3800.00,0.00,0.00,5.00,0.00,'2022-07-28 18:19:54','',''),(5504,'21','222','1',1,'Retail Sale Id 4812',1003.20,0.00,0.00,1.32,0.00,'2022-07-28 18:21:52','',''),(5505,'21','222','1',1,'Retail Sale Id 4812',2500.40,0.00,0.00,3.29,0.00,'2022-07-28 18:21:52','',''),(5506,'21','222','1',1,'Retail Sale Id 4813',4560.00,0.00,0.00,6.00,0.00,'2022-07-28 18:23:21','',''),(5507,'21','222','1',1,'Retail Sale Id 4813',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 18:23:21','',''),(5508,'21','222','1',1,'Retail Sale Id 4814',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 19:18:00','',''),(5509,'21','222','1',1,'Retail Sale Id 4815',38000.00,0.00,0.00,50.00,0.00,'2022-07-28 19:39:50','',''),(5510,'21','222','1',1,'Retail Sale Id 4816',38000.00,0.00,0.00,50.00,0.00,'2022-07-28 19:40:43','',''),(5511,'21','222','1',1,'Retail Sale Id 4817',19000.00,0.00,0.00,25.00,0.00,'2022-07-28 19:41:24','',''),(5512,'21','222','1',1,'Retail Sale Id 4818',38000.00,0.00,0.00,50.00,0.00,'2022-07-28 19:42:22','',''),(5513,'21','222','1',1,'Retail Sale Id 4819',11400.00,0.00,0.00,15.00,0.00,'2022-07-28 19:43:56','',''),(5514,'21','222','1',1,'Retail Sale Id 4820',19000.00,0.00,0.00,25.00,0.00,'2022-07-28 19:46:02','',''),(5515,'21','222','1',1,'Retail Sale Id 4821',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 19:47:11','',''),(5516,'21','222','1',1,'Retail Sale Id 4822',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 19:48:53','',''),(5517,'21','222','1',1,'Retail Sale Id 4823',9500.00,0.00,0.00,12.50,0.00,'2022-07-28 19:49:50','',''),(5518,'21','222','1',1,'Retail Sale Id 4824',8740.00,0.00,0.00,11.50,0.00,'2022-07-29 08:21:27','',''),(5519,'21','222','1',1,'Retail Sale Id 4825',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:25:32','',''),(5520,'21','222','1',1,'Retail Sale Id 4826',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:33:59','',''),(5521,'21','222','1',1,'Retail Sale Id 4827',1998.80,0.00,0.00,2.63,0.00,'2022-07-29 08:34:59','',''),(5522,'21','222','1',1,'Retail Sale Id 4828',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:39:01','',''),(5523,'21','222','1',1,'Retail Sale Id 4828',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:39:01','',''),(5524,'21','222','1',1,'Retail Sale Id 4828',19000.00,0.00,0.00,25.00,0.00,'2022-07-29 08:39:01','',''),(5525,'21','222','1',1,'Retail Sale Id 4829',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:40:42','',''),(5526,'21','222','1',1,'Retail Sale Id 4830',5000.80,0.00,0.00,6.58,0.00,'2022-07-29 08:41:43','',''),(5527,'21','222','1',1,'Retail Sale Id 4831',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:45:04','',''),(5528,'21','222','1',1,'Retail Sale Id 4831',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:45:04','',''),(5529,'21','222','1',1,'Retail Sale Id 4832',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:47:07','',''),(5530,'21','222','1',1,'Retail Sale Id 4833',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:48:47','',''),(5531,'21','222','1',1,'Retail Sale Id 4833',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:48:47','',''),(5532,'21','222','1',1,'Retail Sale Id 4834',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:57:54','',''),(5533,'21','222','1',1,'Retail Sale Id 4834',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 08:57:54','',''),(5534,'21','222','1',1,'Retail Sale Id 4835',4750.00,0.00,0.00,6.25,0.00,'2022-07-29 08:59:43','',''),(5535,'21','222','1',1,'Retail Sale Id 4836',5000.80,0.00,0.00,6.58,0.00,'2022-07-29 09:27:07','',''),(5536,'21','222','1',1,'Retail Sale Id 4838',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 09:30:26','',''),(5537,'21','222','1',1,'Retail Sale Id 4839',3002.00,0.00,0.00,3.95,0.00,'2022-07-29 11:16:17','',''),(5538,'21','222','1',1,'Retail Sale Id 4840',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 12:14:55','',''),(5539,'21','222','1',1,'Retail Sale Id 4842',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 15:17:22','',''),(5540,'21','222','1',1,'Retail Sale Id 4844',3800.00,0.00,0.00,5.00,0.00,'2022-07-29 15:18:32','',''),(5541,'21','222','1',1,'Retail Sale Id 4844',3800.00,0.00,0.00,5.00,0.00,'2022-07-29 15:18:32','',''),(5542,'21','222','1',1,'Retail Sale Id 4845',1003.20,0.00,0.00,1.32,0.00,'2022-07-29 15:20:30','',''),(5543,'21','222','1',1,'Retail Sale Id 4845',1003.20,0.00,0.00,1.32,0.00,'2022-07-29 15:20:31','',''),(5544,'21','222','1',1,'Retail Sale Id 4846',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 15:22:21','',''),(5545,'21','222','1',1,'Retail Sale Id 4847',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 15:24:15','',''),(5546,'21','222','1',1,'Retail Sale Id 4848',3997.60,0.00,0.00,5.26,0.00,'2022-07-29 15:26:51','',''),(5547,'21','222','1',1,'Retail Sale Id 4849',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 15:30:44','',''),(5548,'21','222','1',1,'Retail Sale Id 4850',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 15:31:35','',''),(5549,'21','222','1',1,'Retail Sale Id 4851',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 15:32:31','',''),(5550,'21','222','1',1,'Retail Sale Id 4852',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:07:11','',''),(5551,'21','222','1',1,'Retail Sale Id 4853',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 20:13:47','',''),(5552,'21','222','1',1,'Retail Sale Id 4853',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 20:13:47','',''),(5553,'21','222','1',1,'Retail Sale Id 4854',19000.00,0.00,0.00,25.00,0.00,'2022-07-29 20:14:33','',''),(5554,'21','222','1',1,'Retail Sale Id 4854',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:14:33','',''),(5555,'21','222','1',1,'Retail Sale Id 4855',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 20:15:00','',''),(5556,'21','222','1',1,'Retail Sale Id 4855',15200.00,0.00,0.00,20.00,0.00,'2022-07-29 20:15:00','',''),(5557,'21','222','1',1,'Retail Sale Id 4856',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 20:15:56','',''),(5558,'21','222','1',1,'Retail Sale Id 4857',2280.00,0.00,0.00,3.00,0.00,'2022-07-29 20:16:28','',''),(5559,'21','222','1',1,'Retail Sale Id 4857',11400.00,0.00,0.00,15.00,0.00,'2022-07-29 20:16:28','',''),(5560,'21','222','1',1,'Retail Sale Id 4858',19000.00,0.00,0.00,25.00,0.00,'2022-07-29 20:16:57','',''),(5561,'21','222','1',1,'Retail Sale Id 4859',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:17:26','',''),(5562,'21','222','1',1,'Retail Sale Id 4860',3800.00,0.00,0.00,5.00,0.00,'2022-07-29 20:17:54','',''),(5563,'21','222','1',1,'Retail Sale Id 4860',4560.00,0.00,0.00,6.00,0.00,'2022-07-29 20:17:54','',''),(5564,'21','222','1',1,'Retail Sale Id 4861',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 20:18:19','',''),(5565,'21','222','1',1,'Retail Sale Id 4862',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:19:33','',''),(5566,'21','222','1',1,'Retail Sale Id 4862',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:19:33','',''),(5567,'21','222','1',1,'Retail Sale Id 4862',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:19:33','',''),(5568,'21','222','1',1,'Retail Sale Id 4863',9500.00,0.00,0.00,12.50,0.00,'2022-07-29 20:20:19','',''),(5569,'21','222','1',1,'Retail Sale Id 4863',19000.00,0.00,0.00,25.00,0.00,'2022-07-29 20:20:19','',''),(5570,'21','222','1',1,'Retail Sale Id 4864',8496.80,0.00,0.00,11.18,0.00,'2022-07-29 20:25:50','',''),(5571,'21','222','1',1,'Retail Sale Id 4864',8998.40,0.00,0.00,11.84,0.00,'2022-07-29 20:25:50','',''),(5572,'21','222','1',1,'Retail Sale Id 4865',34063.20,0.00,0.00,44.82,0.00,'2022-07-29 20:28:06','',''),(5573,'21','222','1',1,'Retail Sale Id 4866',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:35:08','',''),(5574,'21','222','1',1,'Retail Sale Id 4866',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:35:08','',''),(5575,'21','222','1',1,'Retail Sale Id 4866',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:35:08','',''),(5576,'21','222','1',1,'Retail Sale Id 4866',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:35:08','',''),(5577,'21','222','1',1,'Retail Sale Id 4868',10001.60,0.00,0.00,13.16,0.00,'2022-07-29 20:37:21','',''),(5578,'21','222','1',1,'Retail Sale Id 4868',38000.00,0.00,0.00,50.00,0.00,'2022-07-29 20:37:21','',''),(5579,'21','222','1',1,'Retail Sale Id 4869',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 09:24:53','',''),(5580,'21','222','1',1,'Retail Sale Id 4870',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 10:35:22','',''),(5581,'21','222','1',1,'Retail Sale Id 4871',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 10:36:45','',''),(5582,'21','222','1',1,'Retail Sale Id 4872',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 10:37:55','',''),(5583,'21','222','1',1,'Retail Sale Id 4873',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 10:40:29','',''),(5584,'21','222','1',1,'Retail Sale Id 4874',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 10:42:29','',''),(5585,'21','222','1',1,'Retail Sale Id 4875',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 10:43:28','',''),(5586,'21','222','1',1,'Retail Sale Id 4875',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 10:43:28','',''),(5587,'21','222','1',1,'Retail Sale Id 4876',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 10:48:44','',''),(5588,'21','222','1',1,'Retail Sale Id 4876',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 10:48:44','',''),(5589,'21','222','1',1,'Retail Sale Id 4877',5996.40,0.00,0.00,7.89,0.00,'2022-07-30 10:57:10','',''),(5590,'21','222','1',1,'Retail Sale Id 4878',3997.60,0.00,0.00,5.26,0.00,'2022-07-30 11:06:48','',''),(5591,'21','222','1',1,'Retail Sale Id 4879',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 11:08:49','',''),(5592,'21','222','1',1,'Retail Sale Id 4880',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 11:10:16','',''),(5593,'21','222','1',1,'Retail Sale Id 4880',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 11:10:16','',''),(5594,'21','222','1',1,'Retail Sale Id 4881',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 11:11:15','',''),(5595,'21','222','1',1,'Retail Sale Id 4882',7600.00,0.00,0.00,10.00,0.00,'2022-07-30 11:23:50','',''),(5596,'21','222','1',1,'Retail Sale Id 4882',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 11:23:50','',''),(5597,'21','222','1',1,'Retail Sale Id 4883',11400.00,0.00,0.00,15.00,0.00,'2022-07-30 14:00:43','',''),(5598,'21','222','1',1,'Retail Sale Id 4883',19000.00,0.00,0.00,25.00,0.00,'2022-07-30 14:00:43','',''),(5599,'21','222','1',1,'Retail Sale Id 4884',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 14:05:09','',''),(5600,'21','222','1',1,'Retail Sale Id 4884',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:05:09','',''),(5601,'21','222','1',1,'Retail Sale Id 4885',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:06:09','',''),(5602,'21','222','1',1,'Retail Sale Id 4886',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:07:10','',''),(5603,'21','222','1',1,'Retail Sale Id 4887',19000.00,0.00,0.00,25.00,0.00,'2022-07-30 14:08:13','',''),(5604,'21','222','1',1,'Retail Sale Id 4888',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:08:45','',''),(5605,'21','222','1',1,'Retail Sale Id 4889',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:14:18','',''),(5606,'21','222','1',1,'Retail Sale Id 4890',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:18:46','',''),(5607,'21','222','1',1,'Retail Sale Id 4891',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:25:02','',''),(5608,'21','222','1',1,'Retail Sale Id 4892',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:29:39','',''),(5609,'21','222','1',1,'Retail Sale Id 4892',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 14:29:39','',''),(5610,'21','222','1',1,'Retail Sale Id 4893',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 14:35:45','',''),(5611,'21','222','1',1,'Retail Sale Id 4894',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 14:38:15','',''),(5612,'21','222','1',1,'Retail Sale Id 4895',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 15:01:25','',''),(5613,'21','222','1',1,'Retail Sale Id 4896',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 15:54:05','',''),(5614,'21','222','1',1,'Retail Sale Id 4896',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 15:54:05','',''),(5615,'21','222','1',1,'Retail Sale Id 4896',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 15:54:05','',''),(5616,'21','222','1',1,'Retail Sale Id 4897',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 15:54:48','',''),(5617,'21','222','1',1,'Retail Sale Id 4897',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 15:54:48','',''),(5618,'21','222','1',1,'Retail Sale Id 4898',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 15:55:21','',''),(5619,'21','222','1',1,'Retail Sale Id 4899',4560.00,0.00,0.00,6.00,0.00,'2022-07-30 15:56:13','',''),(5620,'21','222','1',1,'Retail Sale Id 4899',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 15:56:13','',''),(5621,'21','222','1',1,'Retail Sale Id 4900',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 15:56:59','',''),(5622,'21','222','1',1,'Retail Sale Id 4901',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 15:57:29','',''),(5623,'21','222','1',1,'Retail Sale Id 4902',11400.00,0.00,0.00,15.00,0.00,'2022-07-30 15:58:35','',''),(5624,'21','222','1',1,'Retail Sale Id 4903',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 16:00:32','',''),(5625,'21','222','1',1,'Retail Sale Id 4904',9500.00,0.00,0.00,12.50,0.00,'2022-07-30 16:06:08','',''),(5626,'21','222','1',1,'Retail Sale Id 4905',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:08:08','',''),(5627,'21','222','1',1,'Retail Sale Id 4905',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:08:08','',''),(5628,'21','222','1',1,'Retail Sale Id 4906',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:08:47','',''),(5629,'21','222','1',1,'Retail Sale Id 4907',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:09:51','',''),(5630,'21','222','1',1,'Retail Sale Id 4907',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:09:51','',''),(5631,'21','222','1',1,'Retail Sale Id 4908',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:10:50','',''),(5632,'21','222','1',1,'Retail Sale Id 4909',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:11:56','',''),(5633,'21','222','1',1,'Retail Sale Id 4909',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:11:56','',''),(5634,'21','222','1',1,'Retail Sale Id 4910',76000.00,0.00,0.00,100.00,0.00,'2022-07-30 20:12:54','',''),(5635,'21','222','1',1,'Retail Sale Id 4911',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:13:35','',''),(5636,'21','222','1',1,'Retail Sale Id 4912',76000.00,0.00,0.00,100.00,0.00,'2022-07-30 20:14:23','',''),(5637,'21','222','1',1,'Retail Sale Id 4913',38000.00,0.00,0.00,50.00,0.00,'2022-07-30 20:15:30','',''),(5638,'21','222','1',1,'Retail Sale Id 4914',76000.00,0.00,0.00,100.00,0.00,'2022-07-30 20:16:57','',''),(5639,'21','222','1',1,'Retail Sale Id 4915',19000.00,0.00,0.00,25.00,0.00,'2022-07-30 20:17:38','',''),(5640,'21','222','1',1,'Return of Retail Sale Id 4915',0.00,19000.00,25.00,0.00,0.00,'2022-07-30 20:21:32','',''),(5641,'21','222','1',1,'Retail Sale Id 4916',16773.20,0.00,0.00,22.07,0.00,'2022-07-30 20:22:22','',''),(5642,'21','222','1',1,'Retail Sale Id 4917',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 08:13:07','',''),(5643,'21','222','1',1,'Retail Sale Id 4918',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 08:15:04','',''),(5644,'21','222','1',1,'Retail Sale Id 4919',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 08:16:31','',''),(5645,'21','222','1',1,'Retail Sale Id 4920',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 08:17:48','',''),(5646,'21','222','1',1,'Retail Sale Id 4921',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 08:19:58','',''),(5647,'21','222','1',1,'Retail Sale Id 4922',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 08:22:08','',''),(5648,'21','222','1',1,'Retail Sale Id 4923',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 08:24:03','',''),(5649,'21','222','1',1,'Retail Sale Id 4924',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 08:25:39','',''),(5650,'21','222','1',1,'Retail Sale Id 4924',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 08:25:39','',''),(5651,'21','222','1',1,'Retail Sale Id 4925',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 08:32:12','',''),(5652,'21','222','1',1,'Retail Sale Id 4926',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 08:33:20','',''),(5653,'21','222','1',1,'Retail Sale Id 4927',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 09:21:26','',''),(5654,'21','222','1',1,'Retail Sale Id 4928',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 09:22:49','',''),(5655,'21','222','1',1,'Retail Sale Id 4929',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 09:26:18','',''),(5656,'21','222','1',1,'Retail Sale Id 4930',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 09:27:58','',''),(5657,'21','222','1',1,'Retail Sale Id 4931',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 09:30:12','',''),(5658,'21','222','1',1,'Retail Sale Id 4932',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 09:31:09','',''),(5659,'21','222','1',1,'Retail Sale Id 4934',3100.80,0.00,0.00,4.08,0.00,'2022-07-31 09:33:11','',''),(5660,'21','222','1',1,'Retail Sale Id 4935',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 09:33:52','',''),(5661,'21','222','1',1,'Retail Sale Id 4936',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 09:39:33','',''),(5662,'21','222','1',1,'Retail Sale Id 4937',3002.00,0.00,0.00,3.95,0.00,'2022-07-31 09:44:42','',''),(5663,'21','222','1',1,'Retail Sale Id 4938',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 09:47:13','',''),(5664,'21','222','1',1,'Retail Sale Id 4939',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 09:48:53','',''),(5665,'21','222','1',1,'Retail Sale Id 4940',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 09:51:08','',''),(5666,'21','222','1',1,'Retail Sale Id 4941',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 09:52:41','',''),(5667,'21','222','1',1,'Retail Sale Id 4942',3040.00,0.00,0.00,4.00,0.00,'2022-07-31 09:53:37','',''),(5668,'21','222','1',1,'Retail Sale Id 4943',3002.00,0.00,0.00,3.95,0.00,'2022-07-31 09:56:34','',''),(5669,'21','222','1',1,'Retail Sale Id 4944',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 09:59:58','',''),(5670,'21','222','1',1,'Retail Sale Id 4945',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 10:05:35','',''),(5671,'21','222','1',1,'Retail Sale Id 4946',5000.80,0.00,0.00,6.58,0.00,'2022-07-31 10:06:49','',''),(5672,'21','222','1',1,'Retail Sale Id 4947',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 10:08:18','',''),(5673,'21','222','1',1,'Retail Sale Id 4947',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 10:08:18','',''),(5674,'21','222','1',1,'Retail Sale Id 4948',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 10:09:25','',''),(5675,'21','222','1',1,'Retail Sale Id 4949',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 10:11:48','',''),(5676,'21','222','1',1,'Retail Sale Id 4950',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 10:14:06','',''),(5677,'21','222','1',1,'Retail Sale Id 4951',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 10:18:00','',''),(5678,'21','222','1',1,'Retail Sale Id 4952',1299.60,0.00,0.00,1.71,0.00,'2022-07-31 10:19:27','',''),(5679,'21','222','1',1,'Retail Sale Id 4953',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 10:20:33','',''),(5680,'21','222','1',1,'Retail Sale Id 4954',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 10:21:45','',''),(5681,'21','222','1',1,'Retail Sale Id 4955',3002.00,0.00,0.00,3.95,0.00,'2022-07-31 10:22:35','',''),(5682,'21','222','1',1,'Retail Sale Id 4956',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 10:23:52','',''),(5683,'21','222','1',1,'Retail Sale Id 4957',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 10:24:38','',''),(5684,'21','222','1',1,'Retail Sale Id 4958',2500.40,0.00,0.00,3.29,0.00,'2022-07-31 10:25:53','',''),(5685,'21','222','1',1,'Retail Sale Id 4959',3997.60,0.00,0.00,5.26,0.00,'2022-07-31 10:26:52','',''),(5686,'21','222','1',1,'Retail Sale Id 4960',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 10:27:57','',''),(5687,'21','222','1',1,'Retail Sale Id 4961',3040.00,0.00,0.00,4.00,0.00,'2022-07-31 10:29:11','',''),(5688,'21','222','1',1,'Retail Sale Id 4962',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 10:30:14','',''),(5689,'21','222','1',1,'Retail Sale Id 4963',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 10:34:54','',''),(5690,'21','222','1',1,'Retail Sale Id 4964',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 10:36:36','',''),(5691,'21','222','1',1,'Retail Sale Id 4965',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 10:38:20','',''),(5692,'21','222','1',1,'Retail Sale Id 4966',3997.60,0.00,0.00,5.26,0.00,'2022-07-31 10:39:46','',''),(5693,'21','222','1',1,'Retail Sale Id 4967',5000.80,0.00,0.00,6.58,0.00,'2022-07-31 10:44:42','',''),(5694,'21','222','1',1,'Retail Sale Id 4968',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 10:45:37','',''),(5695,'21','222','1',1,'Retail Sale Id 4969',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 10:47:12','',''),(5696,'21','222','1',1,'Retail Sale Id 4970',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 10:48:59','',''),(5697,'21','222','1',1,'Retail Sale Id 4971',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 10:49:44','',''),(5698,'21','222','1',1,'Retail Sale Id 4972',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 10:50:37','',''),(5699,'21','222','1',1,'Retail Sale Id 4973',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 10:52:09','',''),(5700,'21','222','1',1,'Retail Sale Id 4974',3040.00,0.00,0.00,4.00,0.00,'2022-07-31 10:53:39','',''),(5701,'21','222','1',1,'Retail Sale Id 4975',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 10:55:18','',''),(5702,'21','222','1',1,'Retail Sale Id 4976',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 10:57:02','',''),(5703,'21','222','1',1,'Retail Sale Id 4977',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 10:58:46','',''),(5704,'21','222','1',1,'Retail Sale Id 4978',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 11:00:23','',''),(5705,'21','222','1',1,'Retail Sale Id 4979',1497.20,0.00,0.00,1.97,0.00,'2022-07-31 11:02:31','',''),(5706,'21','222','1',1,'Retail Sale Id 4981',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:03:59','',''),(5707,'21','222','1',1,'Retail Sale Id 4982',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 11:05:39','',''),(5708,'21','222','1',1,'Retail Sale Id 4983',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:07:04','',''),(5709,'21','222','1',1,'Retail Sale Id 4984',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 11:08:09','',''),(5710,'21','222','1',1,'Retail Sale Id 4985',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 11:10:40','',''),(5711,'21','222','1',1,'Retail Sale Id 4986',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:15:07','',''),(5712,'21','222','1',1,'Retail Sale Id 4987',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:20:42','',''),(5713,'21','222','1',1,'Retail Sale Id 4988',15998.00,0.00,0.00,21.05,0.00,'2022-07-31 11:24:08','',''),(5714,'21','222','1',1,'Retail Sale Id 4988',19000.00,0.00,0.00,25.00,0.00,'2022-07-31 11:24:08','',''),(5715,'21','222','1',1,'Retail Sale Id 4990',3997.60,0.00,0.00,5.26,0.00,'2022-07-31 11:29:17','',''),(5716,'21','222','1',1,'Retail Sale Id 4991',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:37:36','',''),(5717,'21','222','1',1,'Retail Sale Id 4992',5000.80,0.00,0.00,6.58,0.00,'2022-07-31 11:39:40','',''),(5718,'21','222','1',1,'Retail Sale Id 4993',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:41:23','',''),(5719,'21','222','1',1,'Retail Sale Id 4994',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:42:04','',''),(5720,'21','222','1',1,'Retail Sale Id 4995',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:43:51','',''),(5721,'21','222','1',1,'Retail Sale Id 4996',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:45:28','',''),(5722,'21','222','1',1,'Retail Sale Id 4997',3002.00,0.00,0.00,3.95,0.00,'2022-07-31 11:46:12','',''),(5723,'21','222','1',1,'Retail Sale Id 4998',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:47:34','',''),(5724,'21','222','1',1,'Retail Sale Id 4999',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 11:48:25','',''),(5725,'21','222','1',1,'Retail Sale Id 5000',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 11:49:37','',''),(5726,'21','222','1',1,'Retail Sale Id 5001',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 11:50:49','',''),(5727,'21','222','1',1,'Retail Sale Id 5002',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:52:00','',''),(5728,'21','222','1',1,'Retail Sale Id 5003',3002.00,0.00,0.00,3.95,0.00,'2022-07-31 11:55:56','',''),(5729,'21','222','1',1,'Retail Sale Id 5004',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 11:57:04','',''),(5730,'21','222','1',1,'Retail Sale Id 5005',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 11:59:40','',''),(5731,'21','222','1',1,'Retail Sale Id 5006',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 12:00:16','',''),(5732,'21','222','1',1,'Retail Sale Id 5007',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:01:27','',''),(5733,'21','222','1',1,'Retail Sale Id 5008',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:02:43','',''),(5734,'21','222','1',1,'Retail Sale Id 5009',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 12:03:34','',''),(5735,'21','222','1',1,'Retail Sale Id 5010',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 12:04:36','',''),(5736,'21','222','1',1,'Retail Sale Id 5011',1003.20,0.00,0.00,1.32,0.00,'2022-07-31 12:06:04','',''),(5737,'21','222','1',1,'Retail Sale Id 5011',3997.60,0.00,0.00,5.26,0.00,'2022-07-31 12:06:04','',''),(5738,'21','222','1',1,'Retail Sale Id 5012',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 12:07:49','',''),(5739,'21','222','1',1,'Retail Sale Id 5013',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:08:55','',''),(5740,'21','222','1',1,'Retail Sale Id 5014',5000.80,0.00,0.00,6.58,0.00,'2022-07-31 12:10:24','',''),(5741,'21','222','1',1,'Retail Sale Id 5015',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:14:10','',''),(5742,'21','222','1',1,'Retail Sale Id 5016',3040.00,0.00,0.00,4.00,0.00,'2022-07-31 12:15:23','',''),(5743,'21','222','1',1,'Retail Sale Id 5017',3002.00,0.00,0.00,3.95,0.00,'2022-07-31 12:16:20','',''),(5744,'21','222','1',1,'Retail Sale Id 5018',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 12:17:46','',''),(5745,'21','222','1',1,'Retail Sale Id 5018',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:17:46','',''),(5746,'21','222','1',1,'Retail Sale Id 5019',4180.00,0.00,0.00,5.50,0.00,'2022-07-31 12:19:43','',''),(5747,'21','222','1',1,'Retail Sale Id 5020',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:21:28','',''),(5748,'21','222','1',1,'Retail Sale Id 5021',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 12:22:35','',''),(5749,'21','222','1',1,'Retail Sale Id 5022',8360.00,0.00,0.00,11.00,0.00,'2022-07-31 12:23:22','',''),(5750,'21','222','1',1,'Retail Sale Id 5023',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 12:24:17','',''),(5751,'21','222','1',1,'Retail Sale Id 5024',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 12:25:15','',''),(5752,'21','222','1',1,'Retail Sale Id 5025',3002.00,0.00,0.00,3.95,0.00,'2022-07-31 12:25:58','',''),(5753,'21','222','1',1,'Retail Sale Id 5026',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:26:37','',''),(5754,'21','222','1',1,'Retail Sale Id 5027',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 12:28:05','',''),(5755,'21','222','1',1,'Retail Sale Id 5028',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:29:20','',''),(5756,'21','222','1',1,'Retail Sale Id 5028',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 12:29:20','',''),(5757,'21','222','1',1,'Retail Sale Id 5029',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:35:47','',''),(5758,'21','222','1',1,'Retail Sale Id 5030',1003.20,0.00,0.00,1.32,0.00,'2022-07-31 12:43:58','',''),(5759,'21','222','1',1,'Retail Sale Id 5031',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:48:18','',''),(5760,'21','222','1',1,'Retail Sale Id 5032',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:50:59','',''),(5761,'21','222','1',1,'Retail Sale Id 5033',5000.80,0.00,0.00,6.58,0.00,'2022-07-31 12:52:00','',''),(5762,'21','222','1',1,'Retail Sale Id 5034',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 12:53:10','',''),(5763,'21','222','1',1,'Retail Sale Id 5035',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 12:55:24','',''),(5764,'21','222','1',1,'Retail Sale Id 5036',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 12:57:27','',''),(5765,'21','222','1',1,'Retail Sale Id 5037',1702.40,0.00,0.00,2.24,0.00,'2022-07-31 12:59:04','',''),(5766,'21','222','1',1,'Retail Sale Id 5038',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:00:36','',''),(5767,'21','222','1',1,'Retail Sale Id 5039',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 13:02:48','',''),(5768,'21','222','1',1,'Retail Sale Id 5040',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:03:41','',''),(5769,'21','222','1',1,'Retail Sale Id 5041',3997.60,0.00,0.00,5.26,0.00,'2022-07-31 13:05:47','',''),(5770,'21','222','1',1,'Retail Sale Id 5042',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:07:46','',''),(5771,'21','222','1',1,'Retail Sale Id 5043',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 13:09:42','',''),(5772,'21','222','1',1,'Retail Sale Id 5043',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:09:42','',''),(5773,'21','222','1',1,'Retail Sale Id 5044',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 13:10:38','',''),(5774,'21','222','1',1,'Retail Sale Id 5044',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:10:38','',''),(5775,'21','222','1',1,'Retail Sale Id 5045',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 13:12:05','',''),(5776,'21','222','1',1,'Retail Sale Id 5046',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:13:48','',''),(5777,'21','222','1',1,'Retail Sale Id 5047',3002.00,0.00,0.00,3.95,0.00,'2022-07-31 13:16:48','',''),(5778,'21','222','1',1,'Retail Sale Id 5048',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 13:17:49','',''),(5779,'21','222','1',1,'Retail Sale Id 5050',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 13:18:46','',''),(5780,'21','222','1',1,'Retail Sale Id 5051',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 13:19:53','',''),(5781,'21','222','1',1,'Retail Sale Id 5052',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 13:20:52','',''),(5782,'21','222','1',1,'Retail Sale Id 5053',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:21:35','',''),(5783,'21','222','1',1,'Retail Sale Id 5054',3503.60,0.00,0.00,4.61,0.00,'2022-07-31 13:22:31','',''),(5784,'21','222','1',1,'Retail Sale Id 5055',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:23:36','',''),(5785,'21','222','1',1,'Retail Sale Id 5056',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 13:24:30','',''),(5786,'21','222','1',1,'Retail Sale Id 5057',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:25:27','',''),(5787,'21','222','1',1,'Retail Sale Id 5058',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:26:46','',''),(5788,'21','222','1',1,'Retail Sale Id 5059',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 13:27:39','',''),(5789,'21','222','1',1,'Retail Sale Id 5060',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 13:28:31','',''),(5790,'21','222','1',1,'Retail Sale Id 5061',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:29:18','',''),(5791,'21','222','1',1,'Retail Sale Id 5062',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 13:30:05','',''),(5792,'21','222','1',1,'Retail Sale Id 5063',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:30:57','',''),(5793,'21','222','1',1,'Retail Sale Id 5064',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 13:31:47','',''),(5794,'21','222','1',1,'Retail Sale Id 5065',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 13:33:04','',''),(5795,'21','222','1',1,'Retail Sale Id 5066',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:33:47','',''),(5796,'21','222','1',1,'Retail Sale Id 5067',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 13:35:18','',''),(5797,'21','222','1',1,'Retail Sale Id 5068',3997.60,0.00,0.00,5.26,0.00,'2022-07-31 13:37:17','',''),(5798,'21','222','1',1,'Retail Sale Id 5069',2500.40,0.00,0.00,3.29,0.00,'2022-07-31 13:38:35','',''),(5799,'21','222','1',1,'Retail Sale Id 5070',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 13:40:01','',''),(5800,'21','222','1',1,'Retail Sale Id 5071',1200.80,0.00,0.00,1.58,0.00,'2022-07-31 13:40:58','',''),(5801,'21','222','1',1,'Retail Sale Id 5072',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:42:39','',''),(5802,'21','222','1',1,'Retail Sale Id 5073',4750.00,0.00,0.00,6.25,0.00,'2022-07-31 13:46:54','',''),(5803,'21','222','1',1,'Retail Sale Id 5074',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:51:36','',''),(5804,'21','222','1',1,'Retail Sale Id 5074',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:51:36','',''),(5805,'21','222','1',1,'Retail Sale Id 5075',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 13:53:13','',''),(5806,'21','222','1',1,'Retail Sale Id 5076',3800.00,0.00,0.00,5.00,0.00,'2022-07-31 13:56:58','',''),(5807,'21','222','1',1,'Retail Sale Id 5076',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 13:56:58','',''),(5808,'21','222','1',1,'Retail Sale Id 5077',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 13:58:03','',''),(5809,'21','222','1',1,'Retail Sale Id 5078',1520.00,0.00,0.00,2.00,0.00,'2022-07-31 13:59:57','',''),(5810,'21','222','1',1,'Retail Sale Id 5079',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 14:01:38','',''),(5811,'21','222','1',1,'Retail Sale Id 5080',2280.00,0.00,0.00,3.00,0.00,'2022-07-31 14:36:35','',''),(5812,'21','222','1',1,'Retail Sale Id 5080',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 14:36:35','',''),(5813,'21','222','1',1,'Retail Sale Id 5082',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 14:48:04','',''),(5814,'21','222','1',1,'Retail Sale Id 5083',1998.80,0.00,0.00,2.63,0.00,'2022-07-31 14:50:14','',''),(5815,'21','222','1',1,'Retail Sale Id 5084',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 14:51:22','',''),(5816,'21','222','1',1,'Retail Sale Id 5085',29640.00,0.00,0.00,39.00,0.00,'2022-07-31 14:54:38','',''),(5817,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3944400.00,5190.00,0.00,0.00,'2022-07-31 20:35:01','',''),(5818,'21','222',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,4999.85,0.00,'2022-07-31 20:40:16','',''),(5819,'21','222','1',1,'Received from bridging 37',0.00,0.00,4999.85,0.00,0.00,'2022-07-31 20:40:16','',''),(5820,'21','222','1',1,'Retail Sale Id 5086',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:10:29','',''),(5821,'21','222','1',1,'Retail Sale Id 5087',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:11:46','',''),(5822,'21','222','1',1,'Retail Sale Id 5088',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:13:00','',''),(5823,'21','222','1',1,'Retail Sale Id 5088',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:13:00','',''),(5824,'21','222','1',1,'Retail Sale Id 5089',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 21:13:55','',''),(5825,'21','222','1',1,'Retail Sale Id 5089',34200.00,0.00,0.00,45.00,0.00,'2022-07-31 21:13:55','',''),(5826,'21','222','1',1,'Retail Sale Id 5090',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:15:04','',''),(5827,'21','222','1',1,'Retail Sale Id 5090',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:15:04','',''),(5828,'21','222','1',1,'Retail Sale Id 5091',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:15:34','',''),(5829,'21','222','1',1,'Retail Sale Id 5092',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:16:16','',''),(5830,'21','222','1',1,'Retail Sale Id 5092',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:16:16','',''),(5831,'21','222','1',1,'Retail Sale Id 5093',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:16:53','',''),(5832,'21','222','1',1,'Retail Sale Id 5094',76000.00,0.00,0.00,100.00,0.00,'2022-07-31 21:17:36','',''),(5833,'21','222','1',1,'Retail Sale Id 5095',76000.00,0.00,0.00,100.00,0.00,'2022-07-31 21:18:17','',''),(5834,'21','222','1',1,'Retail Sale Id 5096',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:20:07','',''),(5835,'21','222','1',1,'Retail Sale Id 5097',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 21:20:56','',''),(5836,'21','222','1',1,'Retail Sale Id 5098',7600.00,0.00,0.00,10.00,0.00,'2022-07-31 21:22:01','',''),(5837,'21','222','1',1,'Retail Sale Id 5098',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 21:22:01','',''),(5838,'21','222','1',1,'Retail Sale Id 5099',38000.00,0.00,0.00,50.00,0.00,'2022-07-31 21:22:55','',''),(5839,'21','222','1',1,'Retail Sale Id 5100',9500.00,0.00,0.00,12.50,0.00,'2022-07-31 21:23:38','',''),(5840,'21','222','1',1,'Retail Sale Id 5101',8998.40,0.00,0.00,11.84,0.00,'2022-07-31 21:24:33','',''),(5841,'21','222','1',1,'Retail Sale Id 5102',7721.60,0.00,0.00,10.16,0.00,'2022-07-31 21:26:10','',''),(5842,'21','222','1',1,'Retail Sale Id 5103',4560.00,0.00,0.00,6.00,0.00,'2022-07-31 21:27:08','',''),(5843,'21','222','1',1,'Retail Sale Id 5105',5563.20,0.00,0.00,7.32,0.00,'2022-07-31 21:29:28','',''),(5844,'21','222','1',1,'Retail Sale Id 5106',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 09:36:08','',''),(5845,'21','222','1',1,'Retail Sale Id 5107',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 09:37:25','',''),(5846,'21','222','1',1,'Retail Sale Id 5108',1003.20,0.00,0.00,1.32,0.00,'2022-08-01 09:38:28','',''),(5847,'21','222','1',1,'Retail Sale Id 5109',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 09:39:22','',''),(5848,'21','222','1',1,'Retail Sale Id 5110',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 09:39:51','',''),(5849,'21','222','1',1,'Retail Sale Id 5111',7600.00,0.00,0.00,10.00,0.00,'2022-08-01 09:40:35','',''),(5850,'21','222','1',1,'Retail Sale Id 5112',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 09:48:09','',''),(5851,'21','222','1',1,'Retail Sale Id 5113',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 09:48:50','',''),(5852,'21','222','1',1,'Retail Sale Id 5114',5320.00,0.00,0.00,7.00,0.00,'2022-08-01 09:49:32','',''),(5853,'21','222','1',1,'Retail Sale Id 5115',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 09:50:38','',''),(5854,'21','222','1',1,'Retail Sale Id 5116',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 09:51:10','',''),(5855,'21','222','1',1,'Retail Sale Id 5117',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 09:52:23','',''),(5856,'21','222','1',1,'Retail Sale Id 5118',11400.00,0.00,0.00,15.00,0.00,'2022-08-01 09:55:22','',''),(5857,'21','222','1',1,'Retail Sale Id 5119',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 09:56:26','',''),(5858,'21','222','1',1,'Retail Sale Id 5120',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 09:57:15','',''),(5859,'21','222','1',1,'Retail Sale Id 5121',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 14:36:44','',''),(5860,'21','222','1',1,'Retail Sale Id 5122',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 14:46:10','',''),(5861,'21','222','1',1,'Retail Sale Id 5123',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 14:47:28','',''),(5862,'21','222','1',1,'Retail Sale Id 5124',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 15:27:13','',''),(5863,'21','222','1',1,'Retail Sale Id 5125',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 15:28:23','',''),(5864,'21','222','1',1,'Retail Sale Id 5126',7600.00,0.00,0.00,10.00,0.00,'2022-08-01 15:34:32','',''),(5865,'21','222','1',1,'Retail Sale Id 5127',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 15:35:41','',''),(5866,'21','222','1',1,'Retail Sale Id 5128',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 15:51:29','',''),(5867,'21','222','1',1,'Retail Sale Id 5129',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 15:57:13','',''),(5868,'21','222','1',1,'Retail Sale Id 5130',15200.00,0.00,0.00,20.00,0.00,'2022-08-01 17:07:26','',''),(5869,'21','222','1',1,'Retail Sale Id 5131',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 17:21:22','',''),(5870,'21','222','1',1,'Retail Sale Id 5131',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 17:21:22','',''),(5871,'21','222','1',1,'Retail Sale Id 5132',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 18:54:48','',''),(5872,'21','222','1',1,'Retail Sale Id 5133',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 18:56:41','',''),(5873,'21','222','1',1,'Retail Sale Id 5134',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 18:58:15','',''),(5874,'21','222','1',1,'Retail Sale Id 5135',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 19:04:17','',''),(5875,'21','222','1',1,'Retail Sale Id 5136',8998.40,0.00,0.00,11.84,0.00,'2022-08-01 19:04:55','',''),(5876,'21','222','1',1,'Retail Sale Id 5137',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 19:05:49','',''),(5877,'21','222','1',1,'Retail Sale Id 5138',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 19:06:39','',''),(5878,'21','222','1',1,'Retail Sale Id 5139',8002.80,0.00,0.00,10.53,0.00,'2022-08-01 19:08:38','',''),(5879,'21','222','1',1,'Retail Sale Id 5140',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 19:09:14','',''),(5880,'21','222','1',1,'Retail Sale Id 5141',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:18:26','',''),(5881,'21','222','1',1,'Retail Sale Id 5141',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:18:26','',''),(5882,'21','222','1',1,'Retail Sale Id 5142',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:19:12','',''),(5883,'21','222','1',1,'Retail Sale Id 5142',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:19:12','',''),(5884,'21','222','1',1,'Retail Sale Id 5143',8360.00,0.00,0.00,11.00,0.00,'2022-08-01 20:19:59','',''),(5885,'21','222','1',1,'Retail Sale Id 5143',11400.00,0.00,0.00,15.00,0.00,'2022-08-01 20:19:59','',''),(5886,'21','222','1',1,'Retail Sale Id 5144',7600.00,0.00,0.00,10.00,0.00,'2022-08-01 20:21:06','',''),(5887,'21','222','1',1,'Retail Sale Id 5144',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:21:06','',''),(5888,'21','222','1',1,'Retail Sale Id 5144',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:21:06','',''),(5889,'21','222','1',1,'Retail Sale Id 5145',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:21:41','',''),(5890,'21','222','1',1,'Retail Sale Id 5145',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:21:41','',''),(5891,'21','222','1',1,'Retail Sale Id 5147',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:22:42','',''),(5892,'21','222','1',1,'Retail Sale Id 5147',76000.00,0.00,0.00,100.00,0.00,'2022-08-01 20:22:42','',''),(5893,'21','222','1',1,'Retail Sale Id 5148',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:23:20','',''),(5894,'21','222','1',1,'Retail Sale Id 5149',8002.80,0.00,0.00,10.53,0.00,'2022-08-01 20:24:06','',''),(5895,'21','222','1',1,'Retail Sale Id 5149',11400.00,0.00,0.00,15.00,0.00,'2022-08-01 20:24:06','',''),(5896,'21','222','1',1,'Retail Sale Id 5150',11400.00,0.00,0.00,15.00,0.00,'2022-08-01 20:25:12','',''),(5897,'21','222','1',1,'Retail Sale Id 5150',19000.00,0.00,0.00,25.00,0.00,'2022-08-01 20:25:12','',''),(5898,'21','222','1',1,'Retail Sale Id 5151',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:26:22','',''),(5899,'21','222','1',1,'Retail Sale Id 5152',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 20:27:09','',''),(5900,'21','222','1',1,'Retail Sale Id 5152',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:27:09','',''),(5901,'21','222','1',1,'Retail Sale Id 5153',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 20:27:41','',''),(5902,'21','222','1',1,'Retail Sale Id 5154',3040.00,0.00,0.00,4.00,0.00,'2022-08-01 20:28:32','',''),(5903,'21','222','1',1,'Retail Sale Id 5154',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 20:28:32','',''),(5904,'21','222','1',1,'Retail Sale Id 5155',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:29:19','',''),(5905,'21','222','1',1,'Retail Sale Id 5155',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:29:19','',''),(5906,'21','222','1',1,'Retail Sale Id 5156',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:30:40','',''),(5907,'21','222','1',1,'Retail Sale Id 5156',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:30:40','',''),(5908,'21','222','1',1,'Retail Sale Id 5157',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:31:15','',''),(5909,'21','222','1',1,'Retail Sale Id 5158',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:32:05','',''),(5910,'21','222','1',1,'Retail Sale Id 5158',11400.00,0.00,0.00,15.00,0.00,'2022-08-01 20:32:05','',''),(5911,'21','222','1',1,'Retail Sale Id 5159',22040.00,0.00,0.00,29.00,0.00,'2022-08-01 20:32:43','',''),(5912,'21','222','1',1,'Retail Sale Id 5160',152000.00,0.00,0.00,200.00,0.00,'2022-08-01 20:34:05','',''),(5913,'21','222','1',1,'Retail Sale Id 5161',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:34:53','',''),(5914,'21','222','1',1,'Retail Sale Id 5162',38000.00,0.00,0.00,50.00,0.00,'2022-08-01 20:36:17','',''),(5915,'21','222','1',1,'Return of Retail Sale Id 5162',0.00,38000.00,50.00,0.00,0.00,'2022-08-01 20:37:08','',''),(5916,'21','222','1',1,'Return of Retail Sale Id 5160',0.00,152000.00,200.00,0.00,0.00,'2022-08-01 20:37:49','',''),(5917,'21','222','1',1,'Retail Sale Id 5163',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:39:16','',''),(5918,'21','222','1',1,'Retail Sale Id 5164',4560.00,0.00,0.00,6.00,0.00,'2022-08-01 20:39:39','',''),(5919,'21','222','1',1,'Retail Sale Id 5165',8002.80,0.00,0.00,10.53,0.00,'2022-08-01 20:40:04','',''),(5920,'21','222','1',1,'Retail Sale Id 5166',2280.00,0.00,0.00,3.00,0.00,'2022-08-01 20:41:00','',''),(5921,'21','222','1',1,'Retail Sale Id 5166',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:41:00','',''),(5922,'21','222','1',1,'Retail Sale Id 5167',9500.00,0.00,0.00,12.50,0.00,'2022-08-01 20:41:22','',''),(5923,'21','222','1',1,'Retail Sale Id 5168',19000.00,0.00,0.00,25.00,0.00,'2022-08-01 20:42:24','',''),(5924,'21','222','1',1,'Retail Sale Id 5169',11400.00,0.00,0.00,15.00,0.00,'2022-08-01 20:43:43','',''),(5925,'21','222','1',1,'Retail Sale Id 5170',4096.40,0.00,0.00,5.39,0.00,'2022-08-01 20:44:42','',''),(5926,'21','222','1',1,'Retail Sale Id 5171',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 12:31:35','',''),(5927,'21','222','1',1,'Retail Sale Id 5172',15200.00,0.00,0.00,20.00,0.00,'2022-08-02 12:32:21','',''),(5928,'21','222','1',1,'Retail Sale Id 5173',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 12:34:56','',''),(5929,'21','222','1',1,'Retail Sale Id 5174',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 12:36:43','',''),(5930,'21','222','1',1,'Retail Sale Id 5175',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 12:38:25','',''),(5931,'21','222','1',1,'Retail Sale Id 5176',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 13:16:44','',''),(5932,'21','222','1',1,'Retail Sale Id 5177',1003.20,0.00,0.00,1.32,0.00,'2022-08-02 13:18:42','',''),(5933,'21','222','1',1,'Retail Sale Id 5178',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 13:20:01','',''),(5934,'21','222','1',1,'Retail Sale Id 5179',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 13:36:17','',''),(5935,'21','222','1',1,'Retail Sale Id 5181',57000.00,0.00,0.00,75.00,0.00,'2022-08-02 14:28:35','',''),(5936,'21','222','1',1,'Retail Sale Id 5182',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 14:37:31','',''),(5937,'21','222','1',1,'Retail Sale Id 5183',19000.00,0.00,0.00,25.00,0.00,'2022-08-02 14:38:33','',''),(5938,'21','222','1',1,'Retail Sale Id 5184',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 14:39:31','',''),(5939,'21','222','1',1,'Retail Sale Id 5185',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 14:41:02','',''),(5940,'21','222','1',1,'Retail Sale Id 5186',1520.00,0.00,0.00,2.00,0.00,'2022-08-02 14:42:34','',''),(5941,'21','222','1',1,'Retail Sale Id 5187',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 15:19:24','',''),(5942,'21','222','1',1,'Retail Sale Id 5188',5320.00,0.00,0.00,7.00,0.00,'2022-08-02 15:34:31','',''),(5943,'21','222','1',1,'Retail Sale Id 5180',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 17:03:38','',''),(5944,'21','222','1',1,'Retail Sale Id 5189',8002.80,0.00,0.00,10.53,0.00,'2022-08-02 17:06:43','',''),(5945,'21','222','1',1,'Retail Sale Id 5189',8002.80,0.00,0.00,10.53,0.00,'2022-08-02 17:06:43','',''),(5946,'21','222','1',1,'Retail Sale Id 5190',7600.00,0.00,0.00,10.00,0.00,'2022-08-02 17:11:26','',''),(5947,'21','222','1',1,'Retail Sale Id 5191',3800.00,0.00,0.00,5.00,0.00,'2022-08-02 17:12:49','',''),(5948,'21','222','1',1,'Retail Sale Id 5192',3997.60,0.00,0.00,5.26,0.00,'2022-08-02 17:18:20','',''),(5949,'21','222','1',1,'Retail Sale Id 5193',7600.00,0.00,0.00,10.00,0.00,'2022-08-02 17:24:48','',''),(5950,'21','222','1',1,'Retail Sale Id 5193',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 17:24:48','',''),(5951,'21','222','1',1,'Retail Sale Id 5194',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 17:25:42','',''),(5952,'21','222','1',1,'Retail Sale Id 5195',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 17:26:28','',''),(5953,'21','222','1',1,'Retail Sale Id 5196',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 17:28:55','',''),(5954,'21','222','1',1,'Retail Sale Id 5196',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 17:28:55','',''),(5955,'21','222','1',1,'Retail Sale Id 5197',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 17:30:50','',''),(5956,'21','222','1',1,'Retail Sale Id 5198',8496.80,0.00,0.00,11.18,0.00,'2022-08-02 17:36:11','',''),(5957,'21','222','1',1,'Retail Sale Id 5199',2500.40,0.00,0.00,3.29,0.00,'2022-08-02 17:46:06','',''),(5958,'21','222','1',1,'Retail Sale Id 5200',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 17:48:19','',''),(5959,'21','222','1',1,'Retail Sale Id 5201',1998.80,0.00,0.00,2.63,0.00,'2022-08-02 17:53:07','',''),(5960,'21','222','1',1,'Retail Sale Id 5202',7600.00,0.00,0.00,10.00,0.00,'2022-08-02 18:11:20','',''),(5961,'21','222','1',1,'Retail Sale Id 5203',1998.80,0.00,0.00,2.63,0.00,'2022-08-02 18:13:27','',''),(5962,'21','222','1',1,'Retail Sale Id 5204',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 18:15:18','',''),(5963,'21','222','1',1,'Retail Sale Id 5205',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 18:16:50','',''),(5964,'21','222','1',1,'Retail Sale Id 5206',2280.00,0.00,0.00,3.00,0.00,'2022-08-02 18:20:13','',''),(5965,'21','222','1',1,'Retail Sale Id 5207',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 18:22:19','',''),(5966,'21','222','1',1,'Retail Sale Id 5208',1998.80,0.00,0.00,2.63,0.00,'2022-08-02 18:23:35','',''),(5967,'21','222','1',1,'Retail Sale Id 5209',1998.80,0.00,0.00,2.63,0.00,'2022-08-02 18:26:42','',''),(5968,'21','222','1',1,'Retail Sale Id 5210',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 18:33:29','',''),(5969,'21','222','1',1,'Retail Sale Id 5211',7600.00,0.00,0.00,10.00,0.00,'2022-08-02 18:35:27','',''),(5970,'21','222','1',1,'Retail Sale Id 5212',8200.40,0.00,0.00,10.79,0.00,'2022-08-02 18:47:23','',''),(5971,'21','222','1',1,'Retail Sale Id 5213',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 18:54:17','',''),(5972,'21','222','1',1,'Retail Sale Id 5214',1998.80,0.00,0.00,2.63,0.00,'2022-08-02 18:59:43','',''),(5973,'21','222','1',1,'Retail Sale Id 5215',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 19:01:36','',''),(5974,'21','222','1',1,'Retail Sale Id 5216',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 19:08:55','',''),(5975,'21','222','1',1,'Retail Sale Id 5217',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 19:13:37','',''),(5976,'21','222','1',1,'Retail Sale Id 5218',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 19:57:53','',''),(5977,'21','222','1',1,'Retail Sale Id 5219',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 19:58:24','',''),(5978,'21','222','1',1,'Retail Sale Id 5219',15200.00,0.00,0.00,20.00,0.00,'2022-08-02 19:58:24','',''),(5979,'21','222','1',1,'Retail Sale Id 5220',3800.00,0.00,0.00,5.00,0.00,'2022-08-02 19:59:07','',''),(5980,'21','222','1',1,'Retail Sale Id 5220',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 19:59:07','',''),(5981,'21','222','1',1,'Retail Sale Id 5220',15200.00,0.00,0.00,20.00,0.00,'2022-08-02 19:59:07','',''),(5982,'21','222','1',1,'Retail Sale Id 5221',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 19:59:41','',''),(5983,'21','222','1',1,'Retail Sale Id 5221',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 19:59:41','',''),(5984,'21','222','1',1,'Retail Sale Id 5222',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 20:00:15','',''),(5985,'21','222','1',1,'Retail Sale Id 5222',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 20:00:15','',''),(5986,'21','222','1',1,'Retail Sale Id 5223',19000.00,0.00,0.00,25.00,0.00,'2022-08-02 20:01:01','',''),(5987,'21','222','1',1,'Retail Sale Id 5223',19000.00,0.00,0.00,25.00,0.00,'2022-08-02 20:01:01','',''),(5988,'21','222','1',1,'Retail Sale Id 5224',2280.00,0.00,0.00,3.00,0.00,'2022-08-02 20:01:37','',''),(5989,'21','222','1',1,'Retail Sale Id 5224',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 20:01:37','',''),(5990,'21','222','1',1,'Retail Sale Id 5224',19000.00,0.00,0.00,25.00,0.00,'2022-08-02 20:01:37','',''),(5991,'21','222','1',1,'Retail Sale Id 5225',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 20:02:17','',''),(5992,'21','222','1',1,'Retail Sale Id 5226',3800.00,0.00,0.00,5.00,0.00,'2022-08-02 20:02:50','',''),(5993,'21','222','1',1,'Retail Sale Id 5226',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 20:02:50','',''),(5994,'21','222','1',1,'Retail Sale Id 5227',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 20:03:17','',''),(5995,'21','222','1',1,'Retail Sale Id 5227',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 20:03:17','',''),(5996,'21','222','1',1,'Retail Sale Id 5228',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 20:04:15','',''),(5997,'21','222','1',1,'Retail Sale Id 5228',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 20:04:15','',''),(5998,'21','222','1',1,'Retail Sale Id 5228',38000.00,0.00,0.00,50.00,0.00,'2022-08-02 20:04:15','',''),(5999,'21','222','1',1,'Retail Sale Id 5229',4560.00,0.00,0.00,6.00,0.00,'2022-08-02 20:04:52','',''),(6000,'21','222','1',1,'Retail Sale Id 5229',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 20:04:52','',''),(6001,'21','222','1',1,'Retail Sale Id 5230',9500.00,0.00,0.00,12.50,0.00,'2022-08-02 20:05:52','',''),(6002,'21','222','1',1,'Retail Sale Id 5230',15200.00,0.00,0.00,20.00,0.00,'2022-08-02 20:05:52','',''),(6003,'21','222','1',1,'Retail Sale Id 5230',19000.00,0.00,0.00,25.00,0.00,'2022-08-02 20:05:52','',''),(6004,'21','222','1',1,'Retail Sale Id 5231',32588.80,0.00,0.00,42.88,0.00,'2022-08-02 20:07:23','',''),(6005,'21','222','1',1,'Retail Sale Id 5232',1998.80,0.00,0.00,2.63,0.00,'2022-08-03 08:26:47','',''),(6006,'21','222','1',1,'Retail Sale Id 5233',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 08:44:20','',''),(6007,'21','222','1',1,'Retail Sale Id 5234',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 08:47:25','',''),(6008,'21','222','1',1,'Retail Sale Id 5235',1998.80,0.00,0.00,2.63,0.00,'2022-08-03 08:50:35','',''),(6009,'21','222','1',1,'Retail Sale Id 5236',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 09:41:16','',''),(6010,'21','222','1',1,'Retail Sale Id 5237',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 09:42:41','',''),(6011,'21','222','1',1,'Retail Sale Id 5238',38000.00,0.00,0.00,50.00,0.00,'2022-08-03 09:43:34','',''),(6012,'21','222','1',1,'Retail Sale Id 5239',7600.00,0.00,0.00,10.00,0.00,'2022-08-03 09:44:20','',''),(6013,'21','222','1',1,'Retail Sale Id 5240',1520.00,0.00,0.00,2.00,0.00,'2022-08-03 09:45:12','',''),(6014,'21','222','1',1,'Retail Sale Id 5241',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 09:46:07','',''),(6015,'21','222','1',1,'Retail Sale Id 5242',11400.00,0.00,0.00,15.00,0.00,'2022-08-03 09:47:16','',''),(6016,'21','222','1',1,'Retail Sale Id 5243',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 09:47:55','',''),(6017,'21','222','1',1,'Retail Sale Id 5244',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 09:48:24','',''),(6018,'21','222','1',1,'Retail Sale Id 5245',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 09:49:09','',''),(6019,'21','222','1',1,'Retail Sale Id 5246',15200.00,0.00,0.00,20.00,0.00,'2022-08-03 10:01:41','',''),(6020,'21','222','1',1,'Retail Sale Id 5247',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 10:46:20','',''),(6021,'21','222','1',1,'Retail Sale Id 5248',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 11:53:30','',''),(6022,'21','222','1',1,'Retail Sale Id 5248',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 11:53:30','',''),(6023,'21','222','1',1,'Retail Sale Id 5249',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 11:54:37','',''),(6024,'21','222','1',1,'Retail Sale Id 5250',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 12:54:51','',''),(6025,'21','222','1',1,'Retail Sale Id 5251',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:11:26','',''),(6026,'21','222','1',1,'Retail Sale Id 5252',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:12:22','',''),(6027,'21','222','1',1,'Retail Sale Id 5253',8496.80,0.00,0.00,11.18,0.00,'2022-08-03 13:13:03','',''),(6028,'21','222','1',1,'Retail Sale Id 5254',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:13:37','',''),(6029,'21','222','1',1,'Retail Sale Id 5255',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 13:14:23','',''),(6030,'21','222','1',1,'Retail Sale Id 5257',1520.00,0.00,0.00,2.00,0.00,'2022-08-03 13:15:01','',''),(6031,'21','222','1',1,'Retail Sale Id 5258',8998.40,0.00,0.00,11.84,0.00,'2022-08-03 13:15:42','',''),(6032,'21','222','1',1,'Retail Sale Id 5259',13680.00,0.00,0.00,18.00,0.00,'2022-08-03 13:16:10','',''),(6033,'21','222','1',1,'Retail Sale Id 5260',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:38:54','',''),(6034,'21','222','1',1,'Retail Sale Id 5261',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 13:39:24','',''),(6035,'21','222','1',1,'Retail Sale Id 5262',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:39:50','',''),(6036,'21','222','1',1,'Retail Sale Id 5263',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:40:43','',''),(6037,'21','222','1',1,'Retail Sale Id 5264',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 13:42:10','',''),(6038,'21','222','1',1,'Retail Sale Id 5265',3040.00,0.00,0.00,4.00,0.00,'2022-08-03 13:43:03','',''),(6039,'21','222','1',1,'Retail Sale Id 5266',2280.00,0.00,0.00,3.00,0.00,'2022-08-03 13:45:17','',''),(6040,'21','222','1',1,'Retail Sale Id 5267',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:48:23','',''),(6041,'21','222','1',1,'Retail Sale Id 5268',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:50:44','',''),(6042,'21','222','1',1,'Retail Sale Id 5268',38000.00,0.00,0.00,50.00,0.00,'2022-08-03 13:50:44','',''),(6043,'21','222','1',1,'Retail Sale Id 5269',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 13:59:38','',''),(6044,'21','222','1',1,'Retail Sale Id 5270',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 14:02:56','',''),(6045,'21','222','1',1,'Retail Sale Id 5270',11400.00,0.00,0.00,15.00,0.00,'2022-08-03 14:02:56','',''),(6046,'21','222','1',1,'Retail Sale Id 5271',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 14:03:21','',''),(6047,'21','222','1',1,'Retail Sale Id 5272',6080.00,0.00,0.00,8.00,0.00,'2022-08-03 14:03:52','',''),(6048,'21','222','1',1,'Retail Sale Id 5273',3800.00,0.00,0.00,5.00,0.00,'2022-08-03 14:05:56','',''),(6049,'21','222','1',1,'Retail Sale Id 5274',35720.00,0.00,0.00,47.00,0.00,'2022-08-03 14:09:31','',''),(6050,'21','222','1',1,'Retail Sale Id 5275',1003.20,0.00,0.00,1.32,0.00,'2022-08-03 14:30:50','',''),(6051,'21','222','1',1,'Retail Sale Id 5276',1998.80,0.00,0.00,2.63,0.00,'2022-08-03 14:31:48','',''),(6052,'21','222','1',1,'Retail Sale Id 5277',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 14:33:46','',''),(6053,'21','222','1',1,'Retail Sale Id 5278',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 14:35:39','',''),(6054,'21','222','1',1,'Retail Sale Id 5279',38000.00,0.00,0.00,50.00,0.00,'2022-08-03 14:36:56','',''),(6055,'21','222','1',1,'Retail Sale Id 5280',8998.40,0.00,0.00,11.84,0.00,'2022-08-03 14:38:23','',''),(6056,'21','222','1',1,'Retail Sale Id 5280',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 14:38:23','',''),(6057,'21','222','1',1,'Retail Sale Id 5281',5320.00,0.00,0.00,7.00,0.00,'2022-08-03 14:39:26','',''),(6058,'21','222','1',1,'Retail Sale Id 5282',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 14:40:02','',''),(6059,'21','222','1',1,'Retail Sale Id 5283',2280.00,0.00,0.00,3.00,0.00,'2022-08-03 15:26:11','',''),(6060,'21','222','1',1,'Retail Sale Id 5283',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 15:26:11','',''),(6061,'21','222','1',1,'Retail Sale Id 5284',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 15:27:04','',''),(6062,'21','222','1',1,'Retail Sale Id 5285',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 15:28:45','',''),(6063,'21','222','1',1,'Retail Sale Id 5286',3800.00,0.00,0.00,5.00,0.00,'2022-08-03 15:29:46','',''),(6064,'21','222','1',1,'Retail Sale Id 5287',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 15:35:55','',''),(6065,'21','222','1',1,'Retail Sale Id 5288',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 15:36:40','',''),(6066,'21','222','1',1,'Retail Sale Id 5289',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 15:37:22','',''),(6067,'21','222','1',1,'Retail Sale Id 5290',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 15:38:03','',''),(6068,'21','222','1',1,'Retail Sale Id 5291',2280.00,0.00,0.00,3.00,0.00,'2022-08-03 15:39:05','',''),(6069,'21','222','1',1,'Retail Sale Id 5292',2280.00,0.00,0.00,3.00,0.00,'2022-08-03 16:14:46','',''),(6070,'21','222','1',1,'Retail Sale Id 5293',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:01:02','',''),(6071,'21','222','1',1,'Retail Sale Id 5294',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:01:58','',''),(6072,'21','222','1',1,'Retail Sale Id 5295',7600.00,0.00,0.00,10.00,0.00,'2022-08-03 17:02:52','',''),(6073,'21','222','1',1,'Retail Sale Id 5295',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:02:52','',''),(6074,'21','222','1',1,'Retail Sale Id 5296',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 17:04:06','',''),(6075,'21','222','1',1,'Retail Sale Id 5297',2280.00,0.00,0.00,3.00,0.00,'2022-08-03 17:05:35','',''),(6076,'21','222','1',1,'Retail Sale Id 5298',2280.00,0.00,0.00,3.00,0.00,'2022-08-03 17:09:31','',''),(6077,'21','222','1',1,'Retail Sale Id 5299',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 17:14:32','',''),(6078,'21','222','1',1,'Retail Sale Id 5300',3997.60,0.00,0.00,5.26,0.00,'2022-08-03 17:36:20','',''),(6079,'21','222','1',1,'Retail Sale Id 5301',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 17:37:33','',''),(6080,'21','222','1',1,'Retail Sale Id 5302',15580.00,0.00,0.00,20.50,0.00,'2022-08-03 17:40:07','',''),(6081,'21','222','1',1,'Retail Sale Id 5303',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:42:53','',''),(6082,'21','222','1',1,'Retail Sale Id 5303',15200.00,0.00,0.00,20.00,0.00,'2022-08-03 17:42:53','',''),(6083,'21','222','1',1,'Retail Sale Id 5304',38000.00,0.00,0.00,50.00,0.00,'2022-08-03 17:43:30','',''),(6084,'21','222','1',1,'Retail Sale Id 5305',7600.00,0.00,0.00,10.00,0.00,'2022-08-03 17:44:40','',''),(6085,'21','222','1',1,'Retail Sale Id 5305',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:44:40','',''),(6086,'21','222','1',1,'Retail Sale Id 5306',1520.00,0.00,0.00,2.00,0.00,'2022-08-03 17:45:27','',''),(6087,'21','222','1',1,'Retail Sale Id 5307',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:48:18','',''),(6088,'21','222','1',1,'Retail Sale Id 5308',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:53:53','',''),(6089,'21','222','1',1,'Retail Sale Id 5309',1497.20,0.00,0.00,1.97,0.00,'2022-08-03 17:55:21','',''),(6090,'21','222','1',1,'Retail Sale Id 5310',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:56:51','',''),(6091,'21','222','1',1,'Retail Sale Id 5311',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 17:57:41','',''),(6092,'21','222','1',1,'Retail Sale Id 5312',4750.00,0.00,0.00,6.25,0.00,'2022-08-03 18:00:28','',''),(6093,'21','222','1',1,'Retail Sale Id 5313',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 18:01:48','',''),(6094,'21','222','1',1,'Retail Sale Id 5314',1998.80,0.00,0.00,2.63,0.00,'2022-08-03 18:03:13','',''),(6095,'21','222','1',1,'Retail Sale Id 5315',5996.40,0.00,0.00,7.89,0.00,'2022-08-03 18:03:47','',''),(6096,'21','222','1',1,'Retail Sale Id 5316',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 18:09:45','',''),(6097,'21','222','1',1,'Retail Sale Id 5317',6999.60,0.00,0.00,9.21,0.00,'2022-08-03 18:11:53','',''),(6098,'21','222','1',1,'Retail Sale Id 5318',3997.60,0.00,0.00,5.26,0.00,'2022-08-03 18:14:24','',''),(6099,'21','222','1',1,'Return of Retail Sale Id 5318',0.00,3997.60,5.26,0.00,0.00,'2022-08-03 18:14:46','',''),(6100,'21','222','1',1,'Retail Sale Id 5319',3800.00,0.00,0.00,5.00,0.00,'2022-08-03 18:15:19','',''),(6101,'21','222','1',1,'Retail Sale Id 5320',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 18:16:36','',''),(6102,'21','222','1',1,'Retail Sale Id 5321',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 18:21:20','',''),(6103,'21','222','1',1,'Retail Sale Id 5322',2280.00,0.00,0.00,3.00,0.00,'2022-08-03 18:22:22','',''),(6104,'21','222','1',1,'Retail Sale Id 5323',4560.00,0.00,0.00,6.00,0.00,'2022-08-03 18:29:55','',''),(6105,'21','222','1',1,'Retail Sale Id 5324',9500.00,0.00,0.00,12.50,0.00,'2022-08-03 18:34:51','',''),(6106,'21','222','1',1,'Retail Sale Id 5325',1497.20,0.00,0.00,1.97,0.00,'2022-08-03 18:38:12','',''),(6107,'21','222','1',1,'Retail Sale Id 5326',3997.60,0.00,0.00,5.26,0.00,'2022-08-03 18:41:56','',''),(6108,'21','222','1',1,'Retail Sale Id 5327',2500.40,0.00,0.00,3.29,0.00,'2022-08-03 18:42:51','',''),(6109,'21','222','1',1,'Retail Sale Id 5328',1170.40,0.00,0.00,1.54,0.00,'2022-08-03 19:32:37','',''),(6110,'21','222','1',1,'Retail Sale Id 5329',2280.00,0.00,0.00,3.00,0.00,'2022-08-04 08:27:58','',''),(6111,'21','222','1',1,'Retail Sale Id 5330',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 08:29:57','',''),(6112,'21','222','1',1,'Retail Sale Id 5331',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 08:31:42','',''),(6113,'21','222','1',1,'Retail Sale Id 5332',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 08:32:23','',''),(6114,'21','222','1',1,'Retail Sale Id 5333',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 08:33:27','',''),(6115,'21','222','1',1,'Retail Sale Id 5334',2280.00,0.00,0.00,3.00,0.00,'2022-08-04 08:34:05','',''),(6116,'21','222','1',1,'Retail Sale Id 5335',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 08:38:52','',''),(6117,'21','222','1',1,'Retail Sale Id 5336',7600.00,0.00,0.00,10.00,0.00,'2022-08-04 08:40:17','',''),(6118,'21','222','1',1,'Retail Sale Id 5337',8002.80,0.00,0.00,10.53,0.00,'2022-08-04 08:44:51','',''),(6119,'21','222','1',1,'Retail Sale Id 5338',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 08:46:57','',''),(6120,'21','222','1',1,'Retail Sale Id 5339',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 08:47:36','',''),(6121,'21','222','1',1,'Retail Sale Id 5340',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 08:48:28','',''),(6122,'21','222','1',1,'Retail Sale Id 5341',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 08:49:44','',''),(6123,'21','222','1',1,'Retail Sale Id 5341',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 08:49:44','',''),(6124,'21','222','1',1,'Retail Sale Id 5342',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 08:59:33','',''),(6125,'21','222','1',1,'Retail Sale Id 5343',2280.00,0.00,0.00,3.00,0.00,'2022-08-04 09:00:31','',''),(6126,'21','222',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,190.00,0.00,'2022-08-04 10:01:22','',''),(6127,'21','222','1',1,'Received from bridging 39',0.00,0.00,190.00,0.00,0.00,'2022-08-04 10:01:22','',''),(6128,'21','222','1',1,'Retail Sale Id 5344',2280.00,0.00,0.00,3.00,0.00,'2022-08-04 11:03:30','',''),(6129,'21','222','1',1,'Retail Sale Id 5345',4499.20,0.00,0.00,5.92,0.00,'2022-08-04 11:09:55','',''),(6130,'21','222','1',1,'Retail Sale Id 5346',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 11:20:49','',''),(6131,'21','222','1',1,'Retail Sale Id 5347',8360.00,0.00,0.00,11.00,0.00,'2022-08-04 11:28:28','',''),(6132,'21','222','1',1,'Retail Sale Id 5348',3002.00,0.00,0.00,3.95,0.00,'2022-08-04 11:31:59','',''),(6133,'21','222','1',1,'Retail Sale Id 5349',2500.40,0.00,0.00,3.29,0.00,'2022-08-04 11:35:22','',''),(6134,'21','222','1',1,'Retail Sale Id 5350',5000.80,0.00,0.00,6.58,0.00,'2022-08-04 11:38:40','',''),(6135,'21','222','1',1,'Retail Sale Id 5351',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 11:40:50','',''),(6136,'21','222','1',1,'Retail Sale Id 5352',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 11:49:11','',''),(6137,'21','222','1',1,'Retail Sale Id 5353',3701.20,0.00,0.00,4.87,0.00,'2022-08-04 11:53:29','',''),(6138,'21','222','1',1,'Retail Sale Id 5354',2280.00,0.00,0.00,3.00,0.00,'2022-08-04 12:06:17','',''),(6139,'21','222','1',1,'Retail Sale Id 5355',8002.80,0.00,0.00,10.53,0.00,'2022-08-04 12:10:06','',''),(6140,'21','222','1',1,'Retail Sale Id 5356',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 12:15:53','',''),(6141,'21','222','1',1,'Retail Sale Id 5357',1998.80,0.00,0.00,2.63,0.00,'2022-08-04 12:16:59','',''),(6142,'21','222','1',1,'Retail Sale Id 5358',3800.00,0.00,0.00,5.00,0.00,'2022-08-04 12:23:16','',''),(6143,'21','222','1',1,'Retail Sale Id 5359',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 12:31:41','',''),(6144,'21','222','1',1,'Retail Sale Id 5360',2280.00,0.00,0.00,3.00,0.00,'2022-08-04 12:33:09','',''),(6145,'21','222','1',1,'Retail Sale Id 5361',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 12:37:37','',''),(6146,'21','222','1',1,'Retail Sale Id 5362',3002.00,0.00,0.00,3.95,0.00,'2022-08-04 12:39:04','',''),(6147,'21','222','1',1,'Retail Sale Id 5364',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 12:40:06','',''),(6148,'21','222','1',1,'Retail Sale Id 5364',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 12:40:06','',''),(6149,'21','222','1',1,'Retail Sale Id 5365',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 13:10:04','',''),(6150,'21','222','1',1,'Retail Sale Id 5365',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 13:10:04','',''),(6151,'21','222','1',1,'Retail Sale Id 5366',3040.00,0.00,0.00,4.00,0.00,'2022-08-04 13:11:18','',''),(6152,'21','222','1',1,'Retail Sale Id 5367',1520.00,0.00,0.00,2.00,0.00,'2022-08-04 13:12:15','',''),(6153,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-08-04 13:36:22','',''),(6154,'21','222',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,4999.98,0.00,'2022-08-04 13:39:37','',''),(6155,'21','222','1',1,'Received from bridging 40',0.00,0.00,4999.98,0.00,0.00,'2022-08-04 13:39:37','',''),(6156,'21','222','1',1,'Retail Sale Id 5368',7600.00,0.00,0.00,10.00,0.00,'2022-08-04 13:44:28','',''),(6157,'21','222','1',1,'Retail Sale Id 5369',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 13:46:46','',''),(6158,'21','222','1',1,'Retail Sale Id 5370',38000.00,0.00,0.00,50.00,0.00,'2022-08-04 13:49:45','',''),(6159,'21','222','1',1,'Retail Sale Id 5371',5502.40,0.00,0.00,7.24,0.00,'2022-08-04 13:53:43','',''),(6160,'21','222','1',1,'Retail Sale Id 5372',3997.60,0.00,0.00,5.26,0.00,'2022-08-04 13:58:54','',''),(6161,'21','222','1',1,'Retail Sale Id 5373',3002.00,0.00,0.00,3.95,0.00,'2022-08-04 14:05:29','',''),(6162,'21','222','1',1,'Retail Sale Id 5374',7600.00,0.00,0.00,10.00,0.00,'2022-08-04 14:10:09','',''),(6163,'21','222','1',1,'Retail Sale Id 5375',38000.00,0.00,0.00,50.00,0.00,'2022-08-04 14:13:07','',''),(6164,'21','222','1',1,'Retail Sale Id 5376',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 14:15:32','',''),(6165,'21','222','1',1,'Retail Sale Id 5377',3997.60,0.00,0.00,5.26,0.00,'2022-08-04 14:18:01','',''),(6166,'21','222','1',1,'Retail Sale Id 5378',3800.00,0.00,0.00,5.00,0.00,'2022-08-04 14:20:55','',''),(6167,'21','222','1',1,'Retail Sale Id 5378',3800.00,0.00,0.00,5.00,0.00,'2022-08-04 14:20:55','',''),(6168,'21','222','1',1,'Retail Sale Id 5378',3800.00,0.00,0.00,5.00,0.00,'2022-08-04 14:20:55','',''),(6169,'21','222','1',1,'Retail Sale Id 5379',11400.00,0.00,0.00,15.00,0.00,'2022-08-04 16:21:48','',''),(6170,'21','222','1',1,'Retail Sale Id 5380',3002.00,0.00,0.00,3.95,0.00,'2022-08-04 16:22:29','',''),(6171,'21','222','1',1,'Retail Sale Id 5381',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 16:23:38','',''),(6172,'21','222','1',1,'Retail Sale Id 5382',2280.00,0.00,0.00,3.00,0.00,'2022-08-04 16:39:00','',''),(6173,'21','222','1',1,'Retail Sale Id 5383',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 16:40:33','',''),(6174,'21','222','1',1,'Retail Sale Id 5384',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 16:50:50','',''),(6175,'21','222','1',1,'Retail Sale Id 5385',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 17:56:16','',''),(6176,'21','222','1',1,'Retail Sale Id 5386',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 17:57:12','',''),(6177,'21','222','1',1,'Retail Sale Id 5386',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 17:57:12','',''),(6178,'21','222','1',1,'Retail Sale Id 5387',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 17:59:10','',''),(6179,'21','222','1',1,'Retail Sale Id 5388',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 18:02:10','',''),(6180,'21','222','1',1,'Retail Sale Id 5388',19000.00,0.00,0.00,25.00,0.00,'2022-08-04 18:02:10','',''),(6181,'21','222','1',1,'Retail Sale Id 5389',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 18:02:49','',''),(6182,'21','222','1',1,'Retail Sale Id 5390',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 18:03:20','',''),(6183,'21','222','1',1,'Retail Sale Id 5391',8002.80,0.00,0.00,10.53,0.00,'2022-08-04 18:04:09','',''),(6184,'21','222','1',1,'Retail Sale Id 5392',7600.00,0.00,0.00,10.00,0.00,'2022-08-04 18:04:39','',''),(6185,'21','222','1',1,'Retail Sale Id 5393',2280.00,0.00,0.00,3.00,0.00,'2022-08-04 18:06:44','',''),(6186,'21','222','1',1,'Retail Sale Id 5394',3002.00,0.00,0.00,3.95,0.00,'2022-08-04 18:07:22','',''),(6187,'21','222','1',1,'Retail Sale Id 5395',1497.20,0.00,0.00,1.97,0.00,'2022-08-04 18:09:16','',''),(6188,'21','222','1',1,'Retail Sale Id 5396',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 18:11:59','',''),(6189,'21','222','1',1,'Retail Sale Id 5397',1497.20,0.00,0.00,1.97,0.00,'2022-08-04 18:16:11','',''),(6190,'21','222','1',1,'Retail Sale Id 5398',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 18:25:57','',''),(6191,'21','222','1',1,'Retail Sale Id 5399',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 18:27:25','',''),(6192,'21','222','1',1,'Retail Sale Id 5400',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 18:27:58','',''),(6193,'21','222','1',1,'Retail Sale Id 5401',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 18:28:37','',''),(6194,'21','222','1',1,'Retail Sale Id 5402',38000.00,0.00,0.00,50.00,0.00,'2022-08-04 18:29:35','',''),(6195,'21','222','1',1,'Retail Sale Id 5403',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 18:35:03','',''),(6196,'21','222','1',1,'Retail Sale Id 5404',760.00,0.00,0.00,1.00,0.00,'2022-08-04 18:36:49','',''),(6197,'21','222','1',1,'Retail Sale Id 5405',760.00,0.00,0.00,1.00,0.00,'2022-08-04 18:38:52','',''),(6198,'21','222','1',1,'Retail Sale Id 5406',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 18:42:58','',''),(6199,'21','222','1',1,'Retail Sale Id 5407',1003.20,0.00,0.00,1.32,0.00,'2022-08-04 18:45:19','',''),(6200,'21','222','1',1,'Retail Sale Id 5408',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 20:29:55','',''),(6201,'21','222','1',1,'Retail Sale Id 5409',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 20:30:27','',''),(6202,'21','222','1',1,'Retail Sale Id 5410',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 20:30:48','',''),(6203,'21','222','1',1,'Retail Sale Id 5411',38000.00,0.00,0.00,50.00,0.00,'2022-08-04 20:31:13','',''),(6204,'21','222','1',1,'Retail Sale Id 5412',4560.00,0.00,0.00,6.00,0.00,'2022-08-04 20:31:37','',''),(6205,'21','222','1',1,'Retail Sale Id 5413',15200.00,0.00,0.00,20.00,0.00,'2022-08-04 20:32:09','',''),(6206,'21','222','1',1,'Retail Sale Id 5414',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 20:34:00','',''),(6207,'21','222','1',1,'Retail Sale Id 5415',7600.00,0.00,0.00,10.00,0.00,'2022-08-04 20:34:34','',''),(6208,'21','222','1',1,'Retail Sale Id 5416',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 20:35:37','',''),(6209,'21','222','1',1,'Retail Sale Id 5416',38000.00,0.00,0.00,50.00,0.00,'2022-08-04 20:35:37','',''),(6210,'21','222','1',1,'Retail Sale Id 5417',38000.00,0.00,0.00,50.00,0.00,'2022-08-04 20:36:15','',''),(6211,'21','222','1',1,'Retail Sale Id 5418',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 20:37:03','',''),(6212,'21','222','1',1,'Retail Sale Id 5419',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 20:37:37','',''),(6213,'21','222','1',1,'Retail Sale Id 5420',38000.00,0.00,0.00,50.00,0.00,'2022-08-04 20:38:07','',''),(6214,'21','222','1',1,'Retail Sale Id 5421',19000.00,0.00,0.00,25.00,0.00,'2022-08-04 20:39:34','',''),(6215,'21','222','1',1,'Retail Sale Id 5422',9500.00,0.00,0.00,12.50,0.00,'2022-08-04 20:40:05','',''),(6216,'21','222','1',1,'Retail Sale Id 5423',752.40,0.00,0.00,0.99,0.00,'2022-08-04 20:41:48','',''),(6217,'21','222','1',1,'Retail Sale Id 5424',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 11:15:11','',''),(6218,'21','222','1',1,'Retail Sale Id 5425',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 11:15:43','',''),(6219,'21','222','1',1,'Retail Sale Id 5426',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 11:16:13','',''),(6220,'21','222','1',1,'Retail Sale Id 5427',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 11:17:12','',''),(6221,'21','222','1',1,'Retail Sale Id 5428',8002.80,0.00,0.00,10.53,0.00,'2022-08-05 11:18:07','',''),(6222,'21','222','1',1,'Retail Sale Id 5429',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 11:18:42','',''),(6223,'21','222','1',1,'Retail Sale Id 5430',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 11:19:59','',''),(6224,'21','222','1',1,'Retail Sale Id 5431',2280.00,0.00,0.00,3.00,0.00,'2022-08-05 11:21:00','',''),(6225,'21','222','1',1,'Retail Sale Id 5431',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 11:21:00','',''),(6226,'21','222','1',1,'Retail Sale Id 5431',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 11:21:00','',''),(6227,'21','222','1',1,'Retail Sale Id 5432',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 11:26:15','',''),(6228,'21','222','1',1,'Retail Sale Id 5433',4560.00,0.00,0.00,6.00,0.00,'2022-08-05 11:28:47','',''),(6229,'21','222','1',1,'Retail Sale Id 5434',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 11:46:17','',''),(6230,'21','222','1',1,'Retail Sale Id 5435',19000.00,0.00,0.00,25.00,0.00,'2022-08-05 11:47:25','',''),(6231,'21','222','1',1,'Retail Sale Id 5436',11400.00,0.00,0.00,15.00,0.00,'2022-08-05 11:48:17','',''),(6232,'21','222','1',1,'Retail Sale Id 5437',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 11:49:47','',''),(6233,'21','222','1',1,'Retail Sale Id 5438',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 11:53:13','',''),(6234,'21','222','1',1,'Retail Sale Id 5439',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 17:32:15','',''),(6235,'21','222','1',1,'Retail Sale Id 5440',98002.00,0.00,0.00,128.95,0.00,'2022-08-05 17:33:33','',''),(6236,'21','222','1',1,'Retail Sale Id 5441',6080.00,0.00,0.00,8.00,0.00,'2022-08-05 19:40:57','',''),(6237,'21','222','1',1,'Retail Sale Id 5442',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 19:48:12','',''),(6238,'21','222','1',1,'Retail Sale Id 5443',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 19:51:29','',''),(6239,'21','222','1',1,'Retail Sale Id 5443',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 19:51:29','',''),(6240,'21','222','1',1,'Retail Sale Id 5444',76000.00,0.00,0.00,100.00,0.00,'2022-08-05 19:52:15','',''),(6241,'21','222','1',1,'Retail Sale Id 5445',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 19:52:43','',''),(6242,'21','222','1',1,'Retail Sale Id 5446',19000.00,0.00,0.00,25.00,0.00,'2022-08-05 19:53:18','',''),(6243,'21','222','1',1,'Retail Sale Id 5447',4560.00,0.00,0.00,6.00,0.00,'2022-08-05 19:54:18','',''),(6244,'21','222','1',1,'Retail Sale Id 5447',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 19:54:18','',''),(6245,'21','222','1',1,'Retail Sale Id 5447',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 19:54:18','',''),(6246,'21','222','1',1,'Retail Sale Id 5448',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 19:54:45','',''),(6247,'21','222','1',1,'Retail Sale Id 5449',4560.00,0.00,0.00,6.00,0.00,'2022-08-05 19:55:30','',''),(6248,'21','222','1',1,'Retail Sale Id 5450',7600.00,0.00,0.00,10.00,0.00,'2022-08-05 19:56:00','',''),(6249,'21','222','1',1,'Retail Sale Id 5451',5320.00,0.00,0.00,7.00,0.00,'2022-08-05 19:56:34','',''),(6250,'21','222','1',1,'Retail Sale Id 5452',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 19:57:22','',''),(6251,'21','222','1',1,'Retail Sale Id 5452',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 19:57:22','',''),(6252,'21','222','1',1,'Retail Sale Id 5453',76000.00,0.00,0.00,100.00,0.00,'2022-08-05 19:58:31','',''),(6253,'21','222','1',1,'Retail Sale Id 5454',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 20:00:01','',''),(6254,'21','222','1',1,'Retail Sale Id 5454',11400.00,0.00,0.00,15.00,0.00,'2022-08-05 20:00:01','',''),(6255,'21','222','1',1,'Retail Sale Id 5455',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 20:03:14','',''),(6256,'21','222','1',1,'Retail Sale Id 5455',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 20:03:14','',''),(6257,'21','222','1',1,'Retail Sale Id 5456',4560.00,0.00,0.00,6.00,0.00,'2022-08-05 20:04:05','',''),(6258,'21','222','1',1,'Retail Sale Id 5456',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 20:04:05','',''),(6259,'21','222','1',1,'Retail Sale Id 5457',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 20:04:25','',''),(6260,'21','222','1',1,'Retail Sale Id 5458',7600.00,0.00,0.00,10.00,0.00,'2022-08-05 20:05:34','',''),(6261,'21','222','1',1,'Retail Sale Id 5458',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 20:05:34','',''),(6262,'21','222','1',1,'Retail Sale Id 5459',9500.00,0.00,0.00,12.50,0.00,'2022-08-05 20:06:12','',''),(6263,'21','222','1',1,'Retail Sale Id 5460',76000.00,0.00,0.00,100.00,0.00,'2022-08-05 20:07:17','',''),(6264,'21','222','1',1,'Retail Sale Id 5461',38000.00,0.00,0.00,50.00,0.00,'2022-08-05 20:08:21','',''),(6265,'21','222','1',1,'Retail Sale Id 5462',76000.00,0.00,0.00,100.00,0.00,'2022-08-05 20:09:11','',''),(6266,'21','222','1',1,'Retail Sale Id 5463',21416.80,0.00,0.00,28.18,0.00,'2022-08-05 20:11:18','',''),(6267,'21','222','1',1,'Retail Sale Id 5464',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 10:18:53','',''),(6268,'21','222','1',1,'Retail Sale Id 5464',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 10:18:53','',''),(6269,'21','222','1',1,'Retail Sale Id 5464',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 10:18:53','',''),(6270,'21','222','1',1,'Retail Sale Id 5465',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 10:34:34','',''),(6271,'21','222','1',1,'Retail Sale Id 5466',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 10:44:10','',''),(6272,'21','222','1',1,'Retail Sale Id 5466',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 10:44:10','',''),(6273,'21','222','1',1,'Retail Sale Id 5467',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 10:56:03','',''),(6274,'21','222','1',1,'Retail Sale Id 5468',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 10:57:00','',''),(6275,'21','222','1',1,'Retail Sale Id 5469',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 10:57:57','',''),(6276,'21','222','1',1,'Retail Sale Id 5470',760.00,0.00,0.00,1.00,0.00,'2022-08-06 11:00:29','',''),(6277,'21','222','1',1,'Retail Sale Id 5471',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 11:02:24','',''),(6278,'21','222','1',1,'Retail Sale Id 5472',3002.00,0.00,0.00,3.95,0.00,'2022-08-06 11:09:11','',''),(6279,'21','222','1',1,'Retail Sale Id 5473',4750.00,0.00,0.00,6.25,0.00,'2022-08-06 11:10:14','',''),(6280,'21','222','1',1,'Retail Sale Id 5474',3002.00,0.00,0.00,3.95,0.00,'2022-08-06 11:11:19','',''),(6281,'21','222','1',1,'Retail Sale Id 5475',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 11:14:33','',''),(6282,'21','222','1',1,'Retail Sale Id 5476',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 12:01:00','',''),(6283,'21','222','1',1,'Retail Sale Id 5477',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 12:02:00','',''),(6284,'21','222','1',1,'Retail Sale Id 5478',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 12:02:43','',''),(6285,'21','222','1',1,'Retail Sale Id 5479',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 12:04:27','',''),(6286,'21','222','1',1,'Retail Sale Id 5480',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 12:05:16','',''),(6287,'21','222','1',1,'Retail Sale Id 5481',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 12:08:40','',''),(6288,'21','222','1',1,'Retail Sale Id 5482',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 12:09:36','',''),(6289,'21','222','1',1,'Retail Sale Id 5483',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 12:13:18','',''),(6290,'21','222','1',1,'Retail Sale Id 5484',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 12:39:28','',''),(6291,'21','222','1',1,'Retail Sale Id 5485',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 13:19:14','',''),(6292,'21','222','1',1,'Retail Sale Id 5486',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 13:20:11','',''),(6293,'21','222','1',1,'Retail Sale Id 5487',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 13:20:43','',''),(6294,'21','222','1',1,'Retail Sale Id 5488',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 13:21:46','',''),(6295,'21','222','1',1,'Retail Sale Id 5488',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 13:21:46','',''),(6296,'21','222','1',1,'Retail Sale Id 5489',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 13:22:32','',''),(6297,'21','222','1',1,'Retail Sale Id 5490',7501.20,0.00,0.00,9.87,0.00,'2022-08-06 13:27:32','',''),(6298,'21','222','1',1,'Retail Sale Id 5490',7501.20,0.00,0.00,9.87,0.00,'2022-08-06 13:27:32','',''),(6299,'21','222','1',1,'Retail Sale Id 5491',1497.20,0.00,0.00,1.97,0.00,'2022-08-06 13:32:54','',''),(6300,'21','222','1',1,'Retail Sale Id 5492',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 14:12:37','',''),(6301,'21','222','1',1,'Retail Sale Id 5493',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 14:27:47','',''),(6302,'21','222','1',1,'Retail Sale Id 5494',5000.80,0.00,0.00,6.58,0.00,'2022-08-06 14:29:04','',''),(6303,'21','222','1',1,'Retail Sale Id 5495',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 14:55:56','',''),(6304,'21','222','1',1,'Retail Sale Id 5496',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 15:50:37','',''),(6305,'21','222','1',1,'Retail Sale Id 5497',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 15:54:07','',''),(6306,'21','222','1',1,'Retail Sale Id 5498',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 15:56:44','',''),(6307,'21','222','1',1,'Retail Sale Id 5498',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 15:56:44','',''),(6308,'21','222','1',1,'Retail Sale Id 5499',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 15:57:29','',''),(6309,'21','222','1',1,'Retail Sale Id 5500',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 16:00:09','',''),(6310,'21','222','1',1,'Retail Sale Id 5500',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 16:00:09','',''),(6311,'21','222','1',1,'Retail Sale Id 5501',5000.80,0.00,0.00,6.58,0.00,'2022-08-06 16:03:19','',''),(6312,'21','222','1',1,'Retail Sale Id 5502',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 16:04:24','',''),(6313,'21','222','1',1,'Retail Sale Id 5503',1520.00,0.00,0.00,2.00,0.00,'2022-08-06 16:28:21','',''),(6314,'21','222','1',1,'Retail Sale Id 5504',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 16:31:11','',''),(6315,'21','222','1',1,'Retail Sale Id 5505',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 16:58:05','',''),(6316,'21','222','1',1,'Retail Sale Id 5506',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 17:03:28','',''),(6317,'21','222','1',1,'Retail Sale Id 5507',3002.00,0.00,0.00,3.95,0.00,'2022-08-06 17:06:16','',''),(6318,'21','222','1',1,'Retail Sale Id 5508',1003.20,0.00,0.00,1.32,0.00,'2022-08-06 17:08:10','',''),(6319,'21','222','1',1,'Retail Sale Id 5509',2196.40,0.00,0.00,2.89,0.00,'2022-08-06 17:10:19','',''),(6320,'21','222','1',1,'Retail Sale Id 5510',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 17:11:39','',''),(6321,'21','222','1',1,'Retail Sale Id 5511',2280.00,0.00,0.00,3.00,0.00,'2022-08-06 17:12:36','',''),(6322,'21','222','1',1,'Retail Sale Id 5512',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 18:03:07','',''),(6323,'21','222','1',1,'Retail Sale Id 5513',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 18:04:08','',''),(6324,'21','222','1',1,'Retail Sale Id 5514',3800.00,0.00,0.00,5.00,0.00,'2022-08-06 18:07:37','',''),(6325,'21','222','1',1,'Retail Sale Id 5515',1003.20,0.00,0.00,1.32,0.00,'2022-08-06 18:09:01','',''),(6326,'21','222','1',1,'Retail Sale Id 5515',1003.20,0.00,0.00,1.32,0.00,'2022-08-06 18:09:01','',''),(6327,'21','222','1',1,'Retail Sale Id 5516',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 18:10:28','',''),(6328,'21','222','1',1,'Retail Sale Id 5517',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 18:11:54','',''),(6329,'21','222','1',1,'Retail Sale Id 5518',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 18:13:39','',''),(6330,'21','222','1',1,'Retail Sale Id 5518',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 18:13:39','',''),(6331,'21','222','1',1,'Retail Sale Id 5518',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 18:13:39','',''),(6332,'21','222','1',1,'Retail Sale Id 5519',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 18:15:14','',''),(6333,'21','222','1',1,'Retail Sale Id 5520',76000.00,0.00,0.00,100.00,0.00,'2022-08-06 19:54:50','',''),(6334,'21','222','1',1,'Retail Sale Id 5521',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 19:55:40','',''),(6335,'21','222','1',1,'Retail Sale Id 5522',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 19:56:17','',''),(6336,'21','222','1',1,'Retail Sale Id 5523',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 19:57:05','',''),(6337,'21','222','1',1,'Retail Sale Id 5523',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 19:57:05','',''),(6338,'21','222','1',1,'Retail Sale Id 5524',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:03:02','',''),(6339,'21','222','1',1,'Retail Sale Id 5525',7600.00,0.00,0.00,10.00,0.00,'2022-08-06 20:03:54','',''),(6340,'21','222','1',1,'Retail Sale Id 5525',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:03:54','',''),(6341,'21','222','1',1,'Retail Sale Id 5526',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 20:04:26','',''),(6342,'21','222','1',1,'Retail Sale Id 5527',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:05:32','',''),(6343,'21','222','1',1,'Retail Sale Id 5527',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 20:05:32','',''),(6344,'21','222','1',1,'Retail Sale Id 5528',76000.00,0.00,0.00,100.00,0.00,'2022-08-06 20:05:58','',''),(6345,'21','222','1',1,'Retail Sale Id 5529',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:06:42','',''),(6346,'21','222','1',1,'Retail Sale Id 5529',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 20:06:42','',''),(6347,'21','222','1',1,'Retail Sale Id 5530',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:07:22','',''),(6348,'21','222','1',1,'Retail Sale Id 5531',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:08:38','',''),(6349,'21','222','1',1,'Retail Sale Id 5532',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:09:20','',''),(6350,'21','222','1',1,'Retail Sale Id 5532',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 20:09:20','',''),(6351,'21','222','1',1,'Retail Sale Id 5533',76000.00,0.00,0.00,100.00,0.00,'2022-08-06 20:09:48','',''),(6352,'21','222','1',1,'Retail Sale Id 5534',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:10:47','',''),(6353,'21','222','1',1,'Retail Sale Id 5534',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:10:47','',''),(6354,'21','222','1',1,'Retail Sale Id 5535',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 20:11:32','',''),(6355,'21','222','1',1,'Retail Sale Id 5535',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:11:32','',''),(6356,'21','222','1',1,'Retail Sale Id 5536',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:12:20','',''),(6357,'21','222','1',1,'Retail Sale Id 5537',8998.40,0.00,0.00,11.84,0.00,'2022-08-06 20:13:39','',''),(6358,'21','222','1',1,'Retail Sale Id 5538',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 20:16:24','',''),(6359,'21','222','1',1,'Retail Sale Id 5539',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 20:17:11','',''),(6360,'21','222','1',1,'Retail Sale Id 5540',38000.00,0.00,0.00,50.00,0.00,'2022-08-06 20:17:37','',''),(6361,'21','222','1',1,'Retail Sale Id 5541',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:18:05','',''),(6362,'21','222','1',1,'Retail Sale Id 5542',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:18:38','',''),(6363,'21','222','1',1,'Retail Sale Id 5543',4560.00,0.00,0.00,6.00,0.00,'2022-08-06 20:19:25','',''),(6364,'21','222','1',1,'Retail Sale Id 5543',9500.00,0.00,0.00,12.50,0.00,'2022-08-06 20:19:25','',''),(6365,'21','222','1',1,'Retail Sale Id 5545',11248.00,0.00,0.00,14.80,0.00,'2022-08-06 20:21:43','',''),(6366,'21','222','1',1,'Retail Sale Id 5546',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 08:33:22','',''),(6367,'21','222','1',1,'Retail Sale Id 5547',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 09:57:02','',''),(6368,'21','222','1',1,'Retail Sale Id 5548',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 10:03:14','',''),(6369,'21','222','1',1,'Retail Sale Id 5549',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 10:06:02','',''),(6370,'21','222','1',1,'Retail Sale Id 5550',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 10:06:40','',''),(6371,'21','222','1',1,'Retail Sale Id 5551',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 10:07:10','',''),(6372,'21','222','1',1,'Retail Sale Id 5552',38000.00,0.00,0.00,50.00,0.00,'2022-08-07 10:07:52','',''),(6373,'21','222','1',1,'Retail Sale Id 5553',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 10:08:29','',''),(6374,'21','222','1',1,'Retail Sale Id 5554',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 10:09:41','',''),(6375,'21','222','1',1,'Retail Sale Id 5555',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 10:12:05','',''),(6376,'21','222','1',1,'Retail Sale Id 5556',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 10:38:25','',''),(6377,'21','222','1',1,'Retail Sale Id 5557',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 10:41:30','',''),(6378,'21','222','1',1,'Retail Sale Id 5558',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 10:44:00','',''),(6379,'21','222','1',1,'Retail Sale Id 5559',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 10:46:08','',''),(6380,'21','222','1',1,'Retail Sale Id 5560',2660.00,0.00,0.00,3.50,0.00,'2022-08-07 10:48:36','',''),(6381,'21','222','1',1,'Retail Sale Id 5561',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 10:50:00','',''),(6382,'21','222','1',1,'Retail Sale Id 5562',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 10:51:34','',''),(6383,'21','222','1',1,'Retail Sale Id 5563',2660.00,0.00,0.00,3.50,0.00,'2022-08-07 10:53:54','',''),(6384,'21','222','1',1,'Retail Sale Id 5564',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 10:55:17','',''),(6385,'21','222','1',1,'Retail Sale Id 5565',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 10:56:42','',''),(6386,'21','222','1',1,'Retail Sale Id 5566',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 10:59:32','',''),(6387,'21','222','1',1,'Retail Sale Id 5567',38000.00,0.00,0.00,50.00,0.00,'2022-08-07 11:05:29','',''),(6388,'21','222','1',1,'Retail Sale Id 5569',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:08:20','',''),(6389,'21','222','1',1,'Retail Sale Id 5570',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 11:11:11','',''),(6390,'21','222','1',1,'Retail Sale Id 5571',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 11:11:59','',''),(6391,'21','222','1',1,'Retail Sale Id 5572',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:12:48','',''),(6392,'21','222','1',1,'Retail Sale Id 5573',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 11:14:01','',''),(6393,'21','222','1',1,'Retail Sale Id 5574',5000.80,0.00,0.00,6.58,0.00,'2022-08-07 11:15:20','',''),(6394,'21','222','1',1,'Retail Sale Id 5575',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:16:26','',''),(6395,'21','222','1',1,'Retail Sale Id 5576',3503.60,0.00,0.00,4.61,0.00,'2022-08-07 11:18:31','',''),(6396,'21','222','1',1,'Retail Sale Id 5577',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 11:19:53','',''),(6397,'21','222','1',1,'Retail Sale Id 5578',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 11:21:45','',''),(6398,'21','222','1',1,'Retail Sale Id 5579',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:23:35','',''),(6399,'21','222','1',1,'Retail Sale Id 5580',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 11:24:33','',''),(6400,'21','222','1',1,'Retail Sale Id 5580',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 11:24:33','',''),(6401,'21','222','1',1,'Retail Sale Id 5581',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 11:26:45','',''),(6402,'21','222','1',1,'Retail Sale Id 5582',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 11:28:28','',''),(6403,'21','222','1',1,'Retail Sale Id 5583',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:32:01','',''),(6404,'21','222','1',1,'Retail Sale Id 5584',2698.00,0.00,0.00,3.55,0.00,'2022-08-07 11:33:47','',''),(6405,'21','222','1',1,'Retail Sale Id 5585',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 11:37:06','',''),(6406,'21','222','1',1,'Retail Sale Id 5587',38000.00,0.00,0.00,50.00,0.00,'2022-08-07 11:38:21','',''),(6407,'21','222','1',1,'Retail Sale Id 5588',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 11:39:43','',''),(6408,'21','222','1',1,'Retail Sale Id 5589',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 11:41:34','',''),(6409,'21','222','1',1,'Retail Sale Id 5590',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 11:42:59','',''),(6410,'21','222','1',1,'Retail Sale Id 5591',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 11:44:02','',''),(6411,'21','222','1',1,'Retail Sale Id 5593',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:45:47','',''),(6412,'21','222','1',1,'Retail Sale Id 5594',1003.20,0.00,0.00,1.32,0.00,'2022-08-07 11:49:57','',''),(6413,'21','222','1',1,'Retail Sale Id 5595',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 11:53:16','',''),(6414,'21','222','1',1,'Retail Sale Id 5596',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 11:55:23','',''),(6415,'21','222','1',1,'Retail Sale Id 5597',5000.80,0.00,0.00,6.58,0.00,'2022-08-07 11:58:49','',''),(6416,'21','222','1',1,'Retail Sale Id 5598',1900.00,0.00,0.00,2.50,0.00,'2022-08-07 11:59:32','',''),(6417,'21','222','1',1,'Retail Sale Id 5599',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:01:03','',''),(6418,'21','222','1',1,'Retail Sale Id 5600',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 12:02:12','',''),(6419,'21','222','1',1,'Retail Sale Id 5601',1003.20,0.00,0.00,1.32,0.00,'2022-08-07 12:03:08','',''),(6420,'21','222','1',1,'Retail Sale Id 5602',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:06:25','',''),(6421,'21','222','1',1,'Retail Sale Id 5603',10001.60,0.00,0.00,13.16,0.00,'2022-08-07 12:10:00','',''),(6422,'21','222','1',1,'Retail Sale Id 5604',5000.80,0.00,0.00,6.58,0.00,'2022-08-07 12:13:35','',''),(6423,'21','222','1',1,'Retail Sale Id 5605',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:17:34','',''),(6424,'21','222','1',1,'Retail Sale Id 5607',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:18:00','',''),(6425,'21','222','1',1,'Retail Sale Id 5608',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:19:06','',''),(6426,'21','222','1',1,'Retail Sale Id 5608',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:19:06','',''),(6427,'21','222','1',1,'Retail Sale Id 5609',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:20:46','',''),(6428,'21','222','1',1,'Retail Sale Id 5610',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:21:22','',''),(6429,'21','222','1',1,'Retail Sale Id 5611',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:22:45','',''),(6430,'21','222','1',1,'Retail Sale Id 5612',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 12:25:25','',''),(6431,'21','222','1',1,'Retail Sale Id 5613',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:28:07','',''),(6432,'21','222','1',1,'Retail Sale Id 5614',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 12:29:50','',''),(6433,'21','222','1',1,'Retail Sale Id 5615',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 12:39:05','',''),(6434,'21','222','1',1,'Retail Sale Id 5616',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 13:16:58','',''),(6435,'21','222','1',1,'Retail Sale Id 5617',4750.00,0.00,0.00,6.25,0.00,'2022-08-07 15:42:51','',''),(6436,'21','222','1',1,'Retail Sale Id 5618',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 15:43:55','',''),(6437,'21','222','1',1,'Retail Sale Id 5619',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 15:44:41','',''),(6438,'21','222','1',1,'Retail Sale Id 5620',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 15:45:31','',''),(6439,'21','222','1',1,'Retail Sale Id 5620',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 15:45:31','',''),(6440,'21','222','1',1,'Retail Sale Id 5621',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 15:47:01','',''),(6441,'21','222','1',1,'Retail Sale Id 5622',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 15:48:07','',''),(6442,'21','222','1',1,'Retail Sale Id 5623',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 15:49:00','',''),(6443,'21','222','1',1,'Retail Sale Id 5624',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 15:50:02','',''),(6444,'21','222','1',1,'Retail Sale Id 5625',5099.60,0.00,0.00,6.71,0.00,'2022-08-07 15:51:09','',''),(6445,'21','222','1',1,'Retail Sale Id 5626',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 15:51:54','',''),(6446,'21','222','1',1,'Retail Sale Id 5627',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 15:52:33','',''),(6447,'21','222','1',1,'Retail Sale Id 5628',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 15:53:26','',''),(6448,'21','222','1',1,'Retail Sale Id 5629',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 15:54:38','',''),(6449,'21','222','1',1,'Retail Sale Id 5629',5320.00,0.00,0.00,7.00,0.00,'2022-08-07 15:54:38','',''),(6450,'21','222','1',1,'Retail Sale Id 5630',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 15:55:21','',''),(6451,'21','222','1',1,'Retail Sale Id 5631',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 15:56:59','',''),(6452,'21','222','1',1,'Retail Sale Id 5632',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 15:57:56','',''),(6453,'21','222','1',1,'Retail Sale Id 5633',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 15:58:27','',''),(6454,'21','222','1',1,'Retail Sale Id 5634',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 15:59:00','',''),(6455,'21','222','1',1,'Retail Sale Id 5635',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 15:59:34','',''),(6456,'21','222','1',1,'Retail Sale Id 5636',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 16:00:26','',''),(6457,'21','222','1',1,'Retail Sale Id 5637',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 16:01:15','',''),(6458,'21','222','1',1,'Retail Sale Id 5638',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 16:02:23','',''),(6459,'21','222','1',1,'Retail Sale Id 5639',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 16:03:06','',''),(6460,'21','222','1',1,'Retail Sale Id 5640',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 16:03:44','',''),(6461,'21','222','1',1,'Retail Sale Id 5641',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 16:04:52','',''),(6462,'21','222','1',1,'Retail Sale Id 5642',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 16:06:05','',''),(6463,'21','222','1',1,'Retail Sale Id 5643',1497.20,0.00,0.00,1.97,0.00,'2022-08-07 16:06:54','',''),(6464,'21','222','1',1,'Retail Sale Id 5644',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 16:08:21','',''),(6465,'21','222','1',1,'Retail Sale Id 5644',4750.00,0.00,0.00,6.25,0.00,'2022-08-07 16:08:21','',''),(6466,'21','222','1',1,'Retail Sale Id 5645',4940.00,0.00,0.00,6.50,0.00,'2022-08-07 16:09:01','',''),(6467,'21','222','1',1,'Retail Sale Id 5646',5502.40,0.00,0.00,7.24,0.00,'2022-08-07 16:11:08','',''),(6468,'21','222','1',1,'Retail Sale Id 5647',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 16:13:23','',''),(6469,'21','222','1',1,'Retail Sale Id 5648',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 16:15:03','',''),(6470,'21','222','1',1,'Retail Sale Id 5649',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 16:15:42','',''),(6471,'21','222','1',1,'Retail Sale Id 5650',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 16:16:25','',''),(6472,'21','222','1',1,'Retail Sale Id 5651',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 16:17:57','',''),(6473,'21','222','1',1,'Retail Sale Id 5652',3800.00,0.00,0.00,5.00,0.00,'2022-08-07 16:19:07','',''),(6474,'21','222','1',1,'Retail Sale Id 5653',3997.60,0.00,0.00,5.26,0.00,'2022-08-07 16:19:57','',''),(6475,'21','222','1',1,'Retail Sale Id 5654',5000.80,0.00,0.00,6.58,0.00,'2022-08-07 16:20:39','',''),(6476,'21','222','1',1,'Retail Sale Id 5655',2500.40,0.00,0.00,3.29,0.00,'2022-08-07 16:21:48','',''),(6477,'21','222','1',1,'Retail Sale Id 5656',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 16:24:39','',''),(6478,'21','222','1',1,'Retail Sale Id 5657',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 16:25:21','',''),(6479,'21','222','1',1,'Retail Sale Id 5658',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 16:25:52','',''),(6480,'21','222','1',1,'Retail Sale Id 5659',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 16:27:20','',''),(6481,'21','222','1',1,'Retail Sale Id 5660',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 16:27:51','',''),(6482,'21','222','1',1,'Retail Sale Id 5661',9120.00,0.00,0.00,12.00,0.00,'2022-08-07 16:28:34','',''),(6483,'21','222','1',1,'Retail Sale Id 5663',27360.00,0.00,0.00,36.00,0.00,'2022-08-07 16:35:34','',''),(6484,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3496000.00,4600.00,0.00,0.00,'2022-08-07 16:50:23','',''),(6485,'21','222',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,4600.00,0.00,'2022-08-07 16:52:15','',''),(6486,'21','222','1',1,'Received from bridging 41',0.00,0.00,4600.00,0.00,0.00,'2022-08-07 16:52:15','',''),(6487,'21','222','1',1,'Retail Sale Id 5664',1998.80,0.00,0.00,2.63,0.00,'2022-08-07 16:54:35','',''),(6488,'21','222','1',1,'Retail Sale Id 5665',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 17:06:01','',''),(6489,'21','222','1',1,'Retail Sale Id 5666',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 17:30:17','',''),(6490,'21','222','1',1,'Retail Sale Id 5667',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 17:43:13','',''),(6491,'21','222','1',1,'Retail Sale Id 5668',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 17:45:09','',''),(6492,'21','222','1',1,'Retail Sale Id 5668',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 17:45:09','',''),(6493,'21','222','1',1,'Retail Sale Id 5669',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 17:47:26','',''),(6494,'21','222','1',1,'Retail Sale Id 5670',3002.00,0.00,0.00,3.95,0.00,'2022-08-07 17:49:18','',''),(6495,'21','222','1',1,'Retail Sale Id 5671',2280.00,0.00,0.00,3.00,0.00,'2022-08-07 17:51:00','',''),(6496,'21','222','1',1,'Retail Sale Id 5672',1003.20,0.00,0.00,1.32,0.00,'2022-08-07 17:52:39','',''),(6497,'21','222','1',1,'Retail Sale Id 5672',1003.20,0.00,0.00,1.32,0.00,'2022-08-07 17:52:39','',''),(6498,'21','222','1',1,'Retail Sale Id 5673',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 17:57:22','',''),(6499,'21','222','1',1,'Retail Sale Id 5673',1520.00,0.00,0.00,2.00,0.00,'2022-08-07 17:57:22','',''),(6500,'21','222','1',1,'Retail Sale Id 5674',6080.00,0.00,0.00,8.00,0.00,'2022-08-07 18:43:04','',''),(6501,'21','222','1',1,'Retail Sale Id 5675',34998.00,0.00,0.00,46.05,0.00,'2022-08-07 18:49:27','',''),(6502,'21','222','1',1,'Retail Sale Id 5676',7600.00,0.00,0.00,10.00,0.00,'2022-08-07 18:58:02','',''),(6503,'21','222','1',1,'Retail Sale Id 5677',76000.00,0.00,0.00,100.00,0.00,'2022-08-07 20:01:49','',''),(6504,'21','222','1',1,'Retail Sale Id 5678',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 20:02:19','',''),(6505,'21','222','1',1,'Retail Sale Id 5679',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 20:02:49','',''),(6506,'21','222','1',1,'Retail Sale Id 5680',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 20:03:10','',''),(6507,'21','222','1',1,'Retail Sale Id 5681',38000.00,0.00,0.00,50.00,0.00,'2022-08-07 20:03:46','',''),(6508,'21','222','1',1,'Retail Sale Id 5682',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 20:04:29','',''),(6509,'21','222','1',1,'Retail Sale Id 5682',38000.00,0.00,0.00,50.00,0.00,'2022-08-07 20:04:29','',''),(6510,'21','222','1',1,'Retail Sale Id 5683',4560.00,0.00,0.00,6.00,0.00,'2022-08-07 20:04:56','',''),(6511,'21','222','1',1,'Retail Sale Id 5684',9500.00,0.00,0.00,12.50,0.00,'2022-08-07 20:06:21','',''),(6512,'21','222','1',1,'Retail Sale Id 5684',19000.00,0.00,0.00,25.00,0.00,'2022-08-07 20:06:21','',''),(6513,'21','222','1',1,'Retail Sale Id 5684',38000.00,0.00,0.00,50.00,0.00,'2022-08-07 20:06:21','',''),(6514,'21','222','1',1,'Retail Sale Id 5685',76000.00,0.00,0.00,100.00,0.00,'2022-08-07 20:06:55','',''),(6515,'21','222','1',1,'Retail Sale Id 5686',38000.00,0.00,0.00,50.00,0.00,'2022-08-07 20:07:23','',''),(6516,'21','222','1',1,'Retail Sale Id 5687',38000.00,0.00,0.00,50.00,0.00,'2022-08-07 20:08:21','',''),(6517,'21','222','1',1,'Retail Sale Id 5688',16112.00,0.00,0.00,21.20,0.00,'2022-08-07 20:10:06','',''),(6518,'21','222','1',1,'Retail Sale Id 5689',9500.00,0.00,0.00,12.50,0.00,'2022-08-08 08:43:27','',''),(6519,'21','222','1',1,'Retail Sale Id 5690',8496.80,0.00,0.00,11.18,0.00,'2022-08-08 10:26:20','',''),(6520,'21','222','1',1,'Retail Sale Id 5691',19000.00,0.00,0.00,25.00,0.00,'2022-08-08 10:27:48','',''),(6521,'21','222','1',1,'Retail Sale Id 5692',38000.00,0.00,0.00,50.00,0.00,'2022-08-08 15:05:02','',''),(6522,'21','222','1',1,'Retail Sale Id 5693',75597.20,0.00,0.00,99.47,0.00,'2022-08-08 15:08:22','',''),(6523,'21','222','1',1,'Retail Sale Id 5695',38000.00,0.00,0.00,50.00,0.00,'2022-08-08 15:11:40','',''),(6524,'21','222','1',1,'Retail Sale Id 5696',38000.00,0.00,0.00,50.00,0.00,'2022-08-08 15:20:53','',''),(6525,'21','222','1',1,'Retail Sale Id 5697',19000.00,0.00,0.00,25.00,0.00,'2022-08-08 17:22:25','',''),(6526,'21','222','1',1,'Retail Sale Id 5698',3997.60,0.00,0.00,5.26,0.00,'2022-08-08 18:33:54','',''),(6527,'21','222','1',1,'Retail Sale Id 5699',38000.00,0.00,0.00,50.00,0.00,'2022-08-08 18:35:42','',''),(6528,'21','222','1',1,'Retail Sale Id 5700',38000.00,0.00,0.00,50.00,0.00,'2022-08-08 18:37:49','',''),(6529,'21','222','1',1,'Retail Sale Id 5701',108398.80,0.00,0.00,142.63,0.00,'2022-08-08 19:32:56','',''),(6530,'21','222','1',1,'Retail Sale Id 5702',38000.00,0.00,0.00,50.00,0.00,'2022-08-08 19:34:57','',''),(6531,'21','222','1',1,'Retail Sale Id 5703',86001.60,0.00,0.00,113.16,0.00,'2022-08-08 19:36:21','',''),(6532,'21','222','1',1,'Retail Sale Id 5704',38000.00,0.00,0.00,50.00,0.00,'2022-08-08 19:37:39','',''),(6533,'21','222','1',1,'Retail Sale Id 5705',19000.00,0.00,0.00,25.00,0.00,'2022-08-08 19:38:50','',''),(6534,'21','222','1',1,'Retail Sale Id 5708',76296.40,0.00,0.00,100.39,0.00,'2022-08-08 19:43:22','',''),(6535,'21','222','1',1,'Retail Sale Id 5709',19000.00,0.00,0.00,25.00,0.00,'2022-08-08 19:44:47','',''),(6536,'21','222','1',1,'Retail Sale Id 5710',16849.20,0.00,0.00,22.17,0.00,'2022-08-08 19:48:19','',''),(6537,'21','222','1',1,'Retail Sale Id 5711',760.00,0.00,0.00,1.00,0.00,'2022-08-09 09:59:31','',''),(6538,'21','222','1',1,'Retail Sale Id 5712',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 10:04:06','',''),(6539,'21','222','1',1,'Retail Sale Id 5713',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 10:45:32','',''),(6540,'21','222','1',1,'Retail Sale Id 5714',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 10:46:04','',''),(6541,'21','222','1',1,'Retail Sale Id 5715',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 10:46:33','',''),(6542,'21','222','1',1,'Retail Sale Id 5716',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 10:47:07','',''),(6543,'21','222','1',1,'Retail Sale Id 5717',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 10:47:53','',''),(6544,'21','222','1',1,'Retail Sale Id 5718',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 10:56:27','',''),(6545,'21','222','1',1,'Retail Sale Id 5719',3002.00,0.00,0.00,3.95,0.00,'2022-08-09 10:59:35','',''),(6546,'21','222','1',1,'Retail Sale Id 5720',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 11:05:36','',''),(6547,'21','222','1',1,'Retail Sale Id 5721',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 11:06:19','',''),(6548,'21','222','1',1,'Retail Sale Id 5722',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 11:10:55','',''),(6549,'21','222','1',1,'Retail Sale Id 5723',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 11:16:38','',''),(6550,'21','222','1',1,'Retail Sale Id 5723',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 11:16:38','',''),(6551,'21','222','1',1,'Retail Sale Id 5724',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 11:25:23','',''),(6552,'21','222','1',1,'Retail Sale Id 5725',15200.00,0.00,0.00,20.00,0.00,'2022-08-09 11:29:24','',''),(6553,'21','222','1',1,'Retail Sale Id 5726',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 11:33:21','',''),(6554,'21','222','1',1,'Retail Sale Id 5727',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 11:39:37','',''),(6555,'21','222','1',1,'Retail Sale Id 5728',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 11:40:15','',''),(6556,'21','222','1',1,'Retail Sale Id 5729',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 11:54:26','',''),(6557,'21','222','1',1,'Retail Sale Id 5730',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 12:52:26','',''),(6558,'21','222','1',1,'Retail Sale Id 5731',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 12:52:47','',''),(6559,'21','222','1',1,'Retail Sale Id 5732',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 12:54:13','',''),(6560,'21','222','1',1,'Retail Sale Id 5733',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 12:54:58','',''),(6561,'21','222','1',1,'Retail Sale Id 5734',8360.00,0.00,0.00,11.00,0.00,'2022-08-09 12:56:23','',''),(6562,'21','222','1',1,'Retail Sale Id 5735',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 12:57:30','',''),(6563,'21','222','1',1,'Retail Sale Id 5736',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 12:58:35','',''),(6564,'21','222','1',1,'Retail Sale Id 5736',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 12:58:35','',''),(6565,'21','222','1',1,'Retail Sale Id 5737',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 12:59:23','',''),(6566,'21','222','1',1,'Retail Sale Id 5738',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 13:00:46','',''),(6567,'21','222','1',1,'Retail Sale Id 5738',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 13:00:46','',''),(6568,'21','222','1',1,'Retail Sale Id 5739',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 14:10:56','',''),(6569,'21','222','1',1,'Retail Sale Id 5740',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 14:41:10','',''),(6570,'21','222','1',1,'Retail Sale Id 5740',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 14:41:10','',''),(6571,'21','222','1',1,'Retail Sale Id 5741',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 14:48:22','',''),(6572,'21','222','1',1,'Retail Sale Id 5742',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 16:41:43','',''),(6573,'21','222','1',1,'Retail Sale Id 5743',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 17:53:05','',''),(6574,'21','222','1',1,'Retail Sale Id 5744',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 17:53:36','',''),(6575,'21','222','1',1,'Retail Sale Id 5745',7600.00,0.00,0.00,10.00,0.00,'2022-08-09 17:54:14','',''),(6576,'21','222','1',1,'Retail Sale Id 5745',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 17:54:14','',''),(6577,'21','222','1',1,'Retail Sale Id 5746',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 17:55:08','',''),(6578,'21','222','1',1,'Retail Sale Id 5747',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 17:55:40','',''),(6579,'21','222','1',1,'Retail Sale Id 5747',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 17:55:40','',''),(6580,'21','222','1',1,'Retail Sale Id 5749',501.60,0.00,0.00,0.66,0.00,'2022-08-09 18:05:21','',''),(6581,'21','222','1',1,'Retail Sale Id 5750',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 18:33:40','',''),(6582,'21','222','1',1,'Retail Sale Id 5751',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 18:34:28','',''),(6583,'21','222','1',1,'Retail Sale Id 5752',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 18:35:47','',''),(6584,'21','222','1',1,'Retail Sale Id 5752',1520.00,0.00,0.00,2.00,0.00,'2022-08-09 18:35:47','',''),(6585,'21','222','1',1,'Retail Sale Id 5753',8360.00,0.00,0.00,11.00,0.00,'2022-08-09 18:36:45','',''),(6586,'21','222','1',1,'Retail Sale Id 5754',2280.00,0.00,0.00,3.00,0.00,'2022-08-09 18:38:03','',''),(6587,'21','222','1',1,'Retail Sale Id 5755',1299.60,0.00,0.00,1.71,0.00,'2022-08-09 18:41:16','',''),(6588,'21','222','1',1,'Retail Sale Id 5756',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 18:41:47','',''),(6589,'21','222','1',1,'Retail Sale Id 5757',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 18:42:49','',''),(6590,'21','222','1',1,'Retail Sale Id 5758',2249.60,0.00,0.00,2.96,0.00,'2022-08-09 18:45:28','',''),(6591,'21','222','1',1,'Retail Sale Id 5758',2249.60,0.00,0.00,2.96,0.00,'2022-08-09 18:45:28','',''),(6592,'21','222','1',1,'Retail Sale Id 5759',1998.80,0.00,0.00,2.63,0.00,'2022-08-09 18:46:19','',''),(6593,'21','222','1',1,'Retail Sale Id 5760',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 18:46:50','',''),(6594,'21','222','1',1,'Retail Sale Id 5761',9500.00,0.00,0.00,12.50,0.00,'2022-08-09 18:48:08','',''),(6595,'21','222','1',1,'Retail Sale Id 5762',1003.20,0.00,0.00,1.32,0.00,'2022-08-09 18:49:35','',''),(6596,'21','222','1',1,'Retail Sale Id 5762',1003.20,0.00,0.00,1.32,0.00,'2022-08-09 18:49:35','',''),(6597,'21','222','1',1,'Retail Sale Id 5763',4560.00,0.00,0.00,6.00,0.00,'2022-08-09 18:56:11','',''),(6598,'21','222','1',1,'Retail Sale Id 5764',5000.80,0.00,0.00,6.58,0.00,'2022-08-09 18:58:28','',''),(6599,'21','222','1',1,'Retail Sale Id 5765',3800.00,0.00,0.00,5.00,0.00,'2022-08-09 18:59:58','',''),(6600,'21','222','1',1,'Retail Sale Id 5766',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:44:10','',''),(6601,'21','222','1',1,'Retail Sale Id 5767',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:45:25','',''),(6602,'21','222','1',1,'Retail Sale Id 5767',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:45:25','',''),(6603,'21','222','1',1,'Retail Sale Id 5768',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:46:02','',''),(6604,'21','222','1',1,'Retail Sale Id 5769',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:46:28','',''),(6605,'21','222','1',1,'Retail Sale Id 5770',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:46:54','',''),(6606,'21','222','1',1,'Retail Sale Id 5772',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:47:44','',''),(6607,'21','222','1',1,'Retail Sale Id 5773',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:49:04','',''),(6608,'21','222','1',1,'Retail Sale Id 5773',76000.00,0.00,0.00,100.00,0.00,'2022-08-09 19:49:04','',''),(6609,'21','222','1',1,'Retail Sale Id 5774',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:49:28','',''),(6610,'21','222','1',1,'Retail Sale Id 5775',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:49:58','',''),(6611,'21','222','1',1,'Retail Sale Id 5776',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:50:41','',''),(6612,'21','222','1',1,'Retail Sale Id 5777',38000.00,0.00,0.00,50.00,0.00,'2022-08-09 19:51:40','',''),(6613,'21','222','1',1,'Retail Sale Id 5778',11058.00,0.00,0.00,14.55,0.00,'2022-08-09 19:54:10','',''),(6614,'21','222','1',1,'Retail Sale Id 5779',9120.00,0.00,0.00,12.00,0.00,'2022-08-10 09:15:40','',''),(6615,'21','222','1',1,'Retail Sale Id 5780',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 09:23:04','',''),(6616,'21','222','1',1,'Retail Sale Id 5780',11400.00,0.00,0.00,15.00,0.00,'2022-08-10 09:23:04','',''),(6617,'21','222','1',1,'Retail Sale Id 5781',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 09:23:34','',''),(6618,'21','222','1',1,'Retail Sale Id 5782',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 09:24:08','',''),(6619,'21','222','1',1,'Retail Sale Id 5783',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 09:25:02','',''),(6620,'21','222','1',1,'Retail Sale Id 5784',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 09:25:33','',''),(6621,'21','222','1',1,'Retail Sale Id 5785',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 10:24:34','',''),(6622,'21','222','1',1,'Retail Sale Id 5786',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 10:30:03','',''),(6623,'21','222','1',1,'Retail Sale Id 5787',3800.00,0.00,0.00,5.00,0.00,'2022-08-10 10:48:45','',''),(6624,'21','222','1',1,'Retail Sale Id 5789',1520.00,0.00,0.00,2.00,0.00,'2022-08-10 10:59:16','',''),(6625,'21','222','1',1,'Retail Sale Id 5790',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 11:16:07','',''),(6626,'21','222','1',1,'Retail Sale Id 5791',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 11:16:44','',''),(6627,'21','222','1',1,'Retail Sale Id 5792',760.00,0.00,0.00,1.00,0.00,'2022-08-10 11:29:18','',''),(6628,'21','222','1',1,'Retail Sale Id 5793',9120.00,0.00,0.00,12.00,0.00,'2022-08-10 12:11:26','',''),(6629,'21','222','1',1,'Retail Sale Id 5794',8998.40,0.00,0.00,11.84,0.00,'2022-08-10 12:13:14','',''),(6630,'21','222','1',1,'Retail Sale Id 5795',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 13:14:19','',''),(6631,'21','222','1',1,'Retail Sale Id 5796',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 13:15:33','',''),(6632,'21','222','1',1,'Retail Sale Id 5797',3298.40,0.00,0.00,4.34,0.00,'2022-08-10 13:39:33','',''),(6633,'21','222','1',1,'Retail Sale Id 5797',8998.40,0.00,0.00,11.84,0.00,'2022-08-10 13:39:33','',''),(6634,'21','222','1',1,'Retail Sale Id 5797',8998.40,0.00,0.00,11.84,0.00,'2022-08-10 13:39:33','',''),(6635,'21','222','1',1,'Retail Sale Id 5798',8998.40,0.00,0.00,11.84,0.00,'2022-08-10 14:08:31','',''),(6636,'21','222','1',1,'Retail Sale Id 5799',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 15:13:06','',''),(6637,'21','222','1',1,'Retail Sale Id 5800',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 15:44:03','',''),(6638,'21','222','1',1,'Retail Sale Id 5801',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 15:44:56','',''),(6639,'21','222','1',1,'Retail Sale Id 5801',11400.00,0.00,0.00,15.00,0.00,'2022-08-10 15:44:56','',''),(6640,'21','222','1',1,'Retail Sale Id 5802',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 15:45:34','',''),(6641,'21','222','1',1,'Retail Sale Id 5803',1003.20,0.00,0.00,1.32,0.00,'2022-08-10 15:50:59','',''),(6642,'21','222','1',1,'Retail Sale Id 5804',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 16:19:15','',''),(6643,'21','222','1',1,'Retail Sale Id 5805',8998.40,0.00,0.00,11.84,0.00,'2022-08-10 16:21:03','',''),(6644,'21','222','1',1,'Retail Sale Id 5806',4560.00,0.00,0.00,6.00,0.00,'2022-08-10 18:17:18','',''),(6645,'21','222','1',1,'Retail Sale Id 5806',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 18:17:18','',''),(6646,'21','222','1',1,'Retail Sale Id 5806',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 18:17:18','',''),(6647,'21','222','1',1,'Retail Sale Id 5807',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 18:38:00','',''),(6648,'21','222','1',1,'Retail Sale Id 5808',15200.00,0.00,0.00,20.00,0.00,'2022-08-10 18:39:13','',''),(6649,'21','222','1',1,'Retail Sale Id 5808',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 18:39:13','',''),(6650,'21','222','1',1,'Retail Sale Id 5809',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 18:40:38','',''),(6651,'21','222','1',1,'Retail Sale Id 5810',9120.00,0.00,0.00,12.00,0.00,'2022-08-10 18:42:17','',''),(6652,'21','222','1',1,'Retail Sale Id 5810',19000.00,0.00,0.00,25.00,0.00,'2022-08-10 18:42:17','',''),(6653,'21','222','1',1,'Retail Sale Id 5810',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 18:42:17','',''),(6654,'21','222','1',1,'Retail Sale Id 5811',7600.00,0.00,0.00,10.00,0.00,'2022-08-10 18:42:59','',''),(6655,'21','222','1',1,'Retail Sale Id 5811',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 18:42:59','',''),(6656,'21','222','1',1,'Retail Sale Id 5812',11400.00,0.00,0.00,15.00,0.00,'2022-08-10 18:43:32','',''),(6657,'21','222','1',1,'Retail Sale Id 5813',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 18:48:46','',''),(6658,'21','222','1',1,'Retail Sale Id 5814',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 18:52:27','',''),(6659,'21','222','1',1,'Retail Sale Id 5815',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 19:41:29','',''),(6660,'21','222','1',1,'Retail Sale Id 5816',76000.00,0.00,0.00,100.00,0.00,'2022-08-10 19:42:05','',''),(6661,'21','222','1',1,'Retail Sale Id 5817',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 19:42:58','',''),(6662,'21','222','1',1,'Retail Sale Id 5817',11400.00,0.00,0.00,15.00,0.00,'2022-08-10 19:42:58','',''),(6663,'21','222','1',1,'Retail Sale Id 5818',7600.00,0.00,0.00,10.00,0.00,'2022-08-10 19:43:23','',''),(6664,'21','222','1',1,'Retail Sale Id 5819',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 19:43:55','',''),(6665,'21','222','1',1,'Retail Sale Id 5820',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 19:44:47','',''),(6666,'21','222','1',1,'Retail Sale Id 5821',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 19:45:23','',''),(6667,'21','222','1',1,'Retail Sale Id 5822',9500.00,0.00,0.00,12.50,0.00,'2022-08-10 19:45:58','',''),(6668,'21','222','1',1,'Retail Sale Id 5823',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 19:46:47','',''),(6669,'21','222','1',1,'Retail Sale Id 5824',38000.00,0.00,0.00,50.00,0.00,'2022-08-10 19:47:20','',''),(6670,'21','222','1',1,'Retail Sale Id 5825',3982.40,0.00,0.00,5.24,0.00,'2022-08-10 19:48:30','',''),(6671,'21','222','1',1,'Retail Sale Id 5826',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 08:28:43','',''),(6672,'21','222','1',1,'Retail Sale Id 5827',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 08:29:41','',''),(6673,'21','222','1',1,'Retail Sale Id 5828',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 08:30:37','',''),(6674,'21','222','1',1,'Retail Sale Id 5829',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 12:02:58','',''),(6675,'21','222','1',1,'Retail Sale Id 5830',8002.80,0.00,0.00,10.53,0.00,'2022-08-11 12:04:00','',''),(6676,'21','222','1',1,'Retail Sale Id 5831',3002.00,0.00,0.00,3.95,0.00,'2022-08-11 12:08:06','',''),(6677,'21','222','1',1,'Retail Sale Id 5832',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 12:08:59','',''),(6678,'21','222','1',1,'Retail Sale Id 5833',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 12:45:49','',''),(6679,'21','222','1',1,'Retail Sale Id 5834',1998.80,0.00,0.00,2.63,0.00,'2022-08-11 13:49:45','',''),(6680,'21','222','1',1,'Retail Sale Id 5835',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 15:08:13','',''),(6681,'21','222','1',1,'Retail Sale Id 5836',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 16:52:56','',''),(6682,'21','222','1',1,'Retail Sale Id 5837',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 16:54:11','',''),(6683,'21','222','1',1,'Retail Sale Id 5838',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 16:54:41','',''),(6684,'21','222','1',1,'Retail Sale Id 5839',5000.80,0.00,0.00,6.58,0.00,'2022-08-11 17:01:37','',''),(6685,'21','222','1',1,'Retail Sale Id 5839',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 17:01:37','',''),(6686,'21','222','1',1,'Retail Sale Id 5840',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 17:02:08','',''),(6687,'21','222','1',1,'Retail Sale Id 5841',3800.00,0.00,0.00,5.00,0.00,'2022-08-11 17:02:38','',''),(6688,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3929200.00,5170.00,0.00,0.00,'2022-08-11 19:42:19','',''),(6689,'21','222',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,4999.89,0.00,'2022-08-11 19:45:44','',''),(6690,'21','222','1',1,'Received from bridging 42',0.00,0.00,4999.89,0.00,0.00,'2022-08-11 19:45:44','',''),(6691,'21','222','1',1,'Retail Sale Id 5842',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:50:06','',''),(6692,'21','222','1',1,'Retail Sale Id 5843',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 19:50:52','',''),(6693,'21','222','1',1,'Retail Sale Id 5844',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:51:19','',''),(6694,'21','222','1',1,'Retail Sale Id 5845',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:52:30','',''),(6695,'21','222','1',1,'Retail Sale Id 5846',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:53:41','',''),(6696,'21','222','1',1,'Retail Sale Id 5847',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:54:06','',''),(6697,'21','222','1',1,'Retail Sale Id 5848',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 19:54:52','',''),(6698,'21','222','1',1,'Retail Sale Id 5848',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:54:52','',''),(6699,'21','222','1',1,'Retail Sale Id 5849',76000.00,0.00,0.00,100.00,0.00,'2022-08-11 19:55:40','',''),(6700,'21','222','1',1,'Retail Sale Id 5850',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:56:08','',''),(6701,'21','222','1',1,'Retail Sale Id 5851',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:56:33','',''),(6702,'21','222','1',1,'Retail Sale Id 5852',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:57:00','',''),(6703,'21','222','1',1,'Retail Sale Id 5853',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 19:57:19','',''),(6704,'21','222','1',1,'Retail Sale Id 5854',4560.00,0.00,0.00,6.00,0.00,'2022-08-11 19:57:51','',''),(6705,'21','222','1',1,'Retail Sale Id 5854',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 19:57:51','',''),(6706,'21','222','1',1,'Retail Sale Id 5855',15200.00,0.00,0.00,20.00,0.00,'2022-08-11 19:58:52','',''),(6707,'21','222','1',1,'Retail Sale Id 5855',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:58:52','',''),(6708,'21','222','1',1,'Retail Sale Id 5856',9500.00,0.00,0.00,12.50,0.00,'2022-08-11 19:59:22','',''),(6709,'21','222','1',1,'Retail Sale Id 5857',38000.00,0.00,0.00,50.00,0.00,'2022-08-11 19:59:54','',''),(6710,'21','222','1',1,'Retail Sale Id 5858',19136.80,0.00,0.00,25.18,0.00,'2022-08-11 20:01:11','',''),(6711,'21','222','1',1,'Retail Sale Id 5859',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 09:14:31','',''),(6712,'21','222','1',1,'Retail Sale Id 5859',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 09:14:31','',''),(6713,'21','222','1',1,'Retail Sale Id 5860',7600.00,0.00,0.00,10.00,0.00,'2022-08-12 09:15:23','',''),(6714,'21','222','1',1,'Retail Sale Id 5860',7600.00,0.00,0.00,10.00,0.00,'2022-08-12 09:15:23','',''),(6715,'21','222','1',1,'Retail Sale Id 5861',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 09:16:05','',''),(6716,'21','222','1',1,'Retail Sale Id 5862',4560.00,0.00,0.00,6.00,0.00,'2022-08-12 09:17:42','',''),(6717,'21','222','1',1,'Retail Sale Id 5863',4560.00,0.00,0.00,6.00,0.00,'2022-08-12 16:48:58','',''),(6718,'21','222','1',1,'Retail Sale Id 5864',2280.00,0.00,0.00,3.00,0.00,'2022-08-12 17:46:02','',''),(6719,'21','222','1',1,'Retail Sale Id 5865',5996.40,0.00,0.00,7.89,0.00,'2022-08-12 18:24:29','',''),(6720,'21','222','1',1,'Retail Sale Id 5866',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 18:31:35','',''),(6721,'21','222','1',1,'Retail Sale Id 5867',9500.00,0.00,0.00,12.50,0.00,'2022-08-12 18:32:21','',''),(6722,'21','222','1',1,'Retail Sale Id 5867',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:32:21','',''),(6723,'21','222','1',1,'Retail Sale Id 5868',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:33:08','',''),(6724,'21','222','1',1,'Retail Sale Id 5869',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:33:57','',''),(6725,'21','222','1',1,'Retail Sale Id 5870',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:34:26','',''),(6726,'21','222','1',1,'Retail Sale Id 5871',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:36:21','',''),(6727,'21','222','1',1,'Retail Sale Id 5872',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:38:31','',''),(6728,'21','222','1',1,'Retail Sale Id 5873',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:38:54','',''),(6729,'21','222','1',1,'Retail Sale Id 5874',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:41:30','',''),(6730,'21','222','1',1,'Retail Sale Id 5875',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:41:51','',''),(6731,'21','222','1',1,'Retail Sale Id 5876',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:42:15','',''),(6732,'21','222','1',1,'Retail Sale Id 5877',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:42:39','',''),(6733,'21','222','1',1,'Retail Sale Id 5878',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:43:05','',''),(6734,'21','222','1',1,'Retail Sale Id 5879',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:43:46','',''),(6735,'21','222','1',1,'Retail Sale Id 5880',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:44:08','',''),(6736,'21','222','1',1,'Retail Sale Id 5881',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:44:39','',''),(6737,'21','222','1',1,'Retail Sale Id 5882',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:45:11','',''),(6738,'21','222','1',1,'Retail Sale Id 5883',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:49:58','',''),(6739,'21','222','1',1,'Retail Sale Id 5884',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:50:19','',''),(6740,'21','222','1',1,'Retail Sale Id 5885',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:50:40','',''),(6741,'21','222','1',1,'Retail Sale Id 5886',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:51:04','',''),(6742,'21','222','1',1,'Retail Sale Id 5887',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:51:23','',''),(6743,'21','222','1',1,'Retail Sale Id 5888',38000.00,0.00,0.00,50.00,0.00,'2022-08-12 18:52:19','',''),(6744,'21','222','1',1,'Return of Retail Sale Id 5888',0.00,38000.00,50.00,0.00,0.00,'2022-08-12 19:34:46','',''),(6745,'21','222','1',1,'Return of Retail Sale Id 5887',0.00,38000.00,50.00,0.00,0.00,'2022-08-12 19:42:46','',''),(6746,'21','222','1',1,'Return of Retail Sale Id 5886',0.00,38000.00,50.00,0.00,0.00,'2022-08-12 19:43:18','',''),(6747,'21','222','1',1,'Return of Retail Sale Id 5885',0.00,38000.00,50.00,0.00,0.00,'2022-08-12 19:43:47','',''),(6748,'21','222','1',1,'Return of Retail Sale Id 5884',0.00,38000.00,50.00,0.00,0.00,'2022-08-12 19:44:10','',''),(6749,'21','222','1',1,'Return of Retail Sale Id 5883',0.00,38000.00,50.00,0.00,0.00,'2022-08-12 19:44:52','',''),(6750,'21','222','1',1,'Retail Sale Id 5889',24859.60,0.00,0.00,32.71,0.00,'2022-08-12 19:47:35','',''),(6751,'21','222','1',1,'Retail Sale Id 5890',3002.00,0.00,0.00,3.95,0.00,'2022-08-13 11:59:22','',''),(6752,'21','222','1',1,'Retail Sale Id 5891',3040.00,0.00,0.00,4.00,0.00,'2022-08-13 12:16:01','',''),(6753,'21','222','1',1,'Retail Sale Id 5892',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:40:12','',''),(6754,'21','222','1',1,'Retail Sale Id 5893',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:41:02','',''),(6755,'21','222','1',1,'Retail Sale Id 5893',15200.00,0.00,0.00,20.00,0.00,'2022-08-13 12:41:02','',''),(6756,'21','222','1',1,'Retail Sale Id 5894',8360.00,0.00,0.00,11.00,0.00,'2022-08-13 12:47:32','',''),(6757,'21','222','1',1,'Retail Sale Id 5895',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 12:48:13','',''),(6758,'21','222','1',1,'Retail Sale Id 5896',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:48:51','',''),(6759,'21','222','1',1,'Retail Sale Id 5896',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:48:51','',''),(6760,'21','222','1',1,'Retail Sale Id 5897',7600.00,0.00,0.00,10.00,0.00,'2022-08-13 12:49:15','',''),(6761,'21','222','1',1,'Retail Sale Id 5898',4560.00,0.00,0.00,6.00,0.00,'2022-08-13 12:49:43','',''),(6762,'21','222','1',1,'Retail Sale Id 5898',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 12:49:43','',''),(6763,'21','222','1',1,'Retail Sale Id 5899',1998.80,0.00,0.00,2.63,0.00,'2022-08-13 12:51:52','',''),(6764,'21','222','1',1,'Retail Sale Id 5899',15200.00,0.00,0.00,20.00,0.00,'2022-08-13 12:51:52','',''),(6765,'21','222','1',1,'Retail Sale Id 5901',3002.00,0.00,0.00,3.95,0.00,'2022-08-13 13:18:49','',''),(6766,'21','222','1',1,'Retail Sale Id 5902',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 14:02:46','',''),(6767,'21','222','1',1,'Retail Sale Id 5903',22716.40,0.00,0.00,29.89,0.00,'2022-08-13 15:09:27','',''),(6768,'21','222','1',1,'Retail Sale Id 5903',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 15:09:27','',''),(6769,'21','222','1',1,'Retail Sale Id 5903',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 15:09:27','',''),(6770,'21','222','1',1,'Retail Sale Id 5904',4499.20,0.00,0.00,5.92,0.00,'2022-08-13 15:10:45','',''),(6771,'21','222','1',1,'Retail Sale Id 5905',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 15:38:59','',''),(6772,'21','222','1',1,'Retail Sale Id 5905',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 15:38:59','',''),(6773,'21','222','1',1,'Retail Sale Id 5906',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:50:47','',''),(6774,'21','222','1',1,'Retail Sale Id 5907',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:51:10','',''),(6775,'21','222','1',1,'Retail Sale Id 5908',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:51:35','',''),(6776,'21','222','1',1,'Retail Sale Id 5909',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:51:57','',''),(6777,'21','222','1',1,'Retail Sale Id 5910',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:52:25','',''),(6778,'21','222','1',1,'Retail Sale Id 5911',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:52:56','',''),(6779,'21','222','1',1,'Retail Sale Id 5912',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:53:26','',''),(6780,'21','222','1',1,'Retail Sale Id 5913',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:53:54','',''),(6781,'21','222','1',1,'Retail Sale Id 5914',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 16:54:30','',''),(6782,'21','222','1',1,'Retail Sale Id 5915',11400.00,0.00,0.00,15.00,0.00,'2022-08-13 16:57:40','',''),(6783,'21','222','1',1,'Retail Sale Id 5916',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:03:11','',''),(6784,'21','222','1',1,'Retail Sale Id 5917',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:03:31','',''),(6785,'21','222','1',1,'Retail Sale Id 5918',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:04:34','',''),(6786,'21','222','1',1,'Retail Sale Id 5919',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:05:00','',''),(6787,'21','222','1',1,'Retail Sale Id 5920',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:05:25','',''),(6788,'21','222','1',1,'Retail Sale Id 5921',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:05:49','',''),(6789,'21','222','1',1,'Retail Sale Id 5922',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:06:34','',''),(6790,'21','222','1',1,'Retail Sale Id 5923',760.00,0.00,0.00,1.00,0.00,'2022-08-13 17:07:24','',''),(6791,'21','222','1',1,'Retail Sale Id 5924',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:07:51','',''),(6792,'21','222','1',1,'Retail Sale Id 5925',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:09:42','',''),(6793,'21','222','1',1,'Retail Sale Id 5926',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 17:16:04','',''),(6794,'21','222','1',1,'Retail Sale Id 5927',1003.20,0.00,0.00,1.32,0.00,'2022-08-13 17:44:22','',''),(6795,'21','222','1',1,'Retail Sale Id 5927',1003.20,0.00,0.00,1.32,0.00,'2022-08-13 17:44:22','',''),(6796,'21','222','1',1,'Retail Sale Id 5928',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 17:51:03','',''),(6797,'21','222','1',1,'Retail Sale Id 5929',3800.00,0.00,0.00,5.00,0.00,'2022-08-13 17:56:40','',''),(6798,'21','222','1',1,'Retail Sale Id 5929',3800.00,0.00,0.00,5.00,0.00,'2022-08-13 17:56:40','',''),(6799,'21','222','1',1,'Retail Sale Id 5930',3800.00,0.00,0.00,5.00,0.00,'2022-08-13 17:58:24','',''),(6800,'21','222','1',1,'Retail Sale Id 5931',8998.40,0.00,0.00,11.84,0.00,'2022-08-13 18:15:15','',''),(6801,'21','222','1',1,'Retail Sale Id 5932',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 19:12:33','',''),(6802,'21','222','1',1,'Retail Sale Id 5933',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 19:12:53','',''),(6803,'21','222','1',1,'Retail Sale Id 5934',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 19:13:20','',''),(6804,'21','222','1',1,'Retail Sale Id 5935',9500.00,0.00,0.00,12.50,0.00,'2022-08-13 19:14:13','',''),(6805,'21','222','1',1,'Retail Sale Id 5935',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 19:14:13','',''),(6806,'21','222','1',1,'Retail Sale Id 5936',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 19:14:34','',''),(6807,'21','222','1',1,'Retail Sale Id 5937',38000.00,0.00,0.00,50.00,0.00,'2022-08-13 19:14:56','',''),(6808,'21','222','1',1,'Retail Sale Id 5938',32216.40,0.00,0.00,42.39,0.00,'2022-08-13 19:15:55','',''),(6809,'21','222','1',1,'Retail Sale Id 5939',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:19:01','',''),(6810,'21','222','1',1,'Retail Sale Id 5940',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:19:59','',''),(6811,'21','222','1',1,'Retail Sale Id 5941',76000.00,0.00,0.00,100.00,0.00,'2022-08-14 17:20:23','',''),(6812,'21','222','1',1,'Retail Sale Id 5942',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:20:42','',''),(6813,'21','222','1',1,'Retail Sale Id 5943',76000.00,0.00,0.00,100.00,0.00,'2022-08-14 17:21:00','',''),(6814,'21','222','1',1,'Retail Sale Id 5944',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:21:18','',''),(6815,'21','222','1',1,'Retail Sale Id 5945',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:21:54','',''),(6816,'21','222','1',1,'Retail Sale Id 5946',76000.00,0.00,0.00,100.00,0.00,'2022-08-14 17:22:13','',''),(6817,'21','222','1',1,'Retail Sale Id 5947',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:22:47','',''),(6818,'21','222','1',1,'Retail Sale Id 5947',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:22:47','',''),(6819,'21','222','1',1,'Retail Sale Id 5948',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:23:13','',''),(6820,'21','222','1',1,'Retail Sale Id 5949',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:23:32','',''),(6821,'21','222','1',1,'Retail Sale Id 5950',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:23:58','',''),(6822,'21','222','1',1,'Retail Sale Id 5951',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:24:20','',''),(6823,'21','222','1',1,'Retail Sale Id 5953',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:24:41','',''),(6824,'21','222','1',1,'Retail Sale Id 5954',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:25:10','',''),(6825,'21','222','1',1,'Retail Sale Id 5955',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:25:38','',''),(6826,'21','222','1',1,'Retail Sale Id 5956',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:26:25','',''),(6827,'21','222','1',1,'Retail Sale Id 5957',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:26:57','',''),(6828,'21','222','1',1,'Retail Sale Id 5957',76000.00,0.00,0.00,100.00,0.00,'2022-08-14 17:26:57','',''),(6829,'21','222','1',1,'Retail Sale Id 5958',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:27:32','',''),(6830,'21','222','1',1,'Retail Sale Id 5959',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:28:05','',''),(6831,'21','222','1',1,'Retail Sale Id 5960',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:28:45','',''),(6832,'21','222','1',1,'Retail Sale Id 5961',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:29:10','',''),(6833,'21','222','1',1,'Retail Sale Id 5962',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:29:56','',''),(6834,'21','222','1',1,'Retail Sale Id 5962',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:29:56','',''),(6835,'21','222','1',1,'Retail Sale Id 5962',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:29:56','',''),(6836,'21','222','1',1,'Retail Sale Id 5963',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:30:17','',''),(6837,'21','222','1',1,'Retail Sale Id 5964',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:30:49','',''),(6838,'21','222','1',1,'Retail Sale Id 5965',6080.00,0.00,0.00,8.00,0.00,'2022-08-14 17:31:20','',''),(6839,'21','222','1',1,'Retail Sale Id 5966',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:31:50','',''),(6840,'21','222','1',1,'Retail Sale Id 5967',4560.00,0.00,0.00,6.00,0.00,'2022-08-14 17:32:16','',''),(6841,'21','222','1',1,'Retail Sale Id 5968',8998.40,0.00,0.00,11.84,0.00,'2022-08-14 17:32:45','',''),(6842,'21','222','1',1,'Retail Sale Id 5969',2280.00,0.00,0.00,3.00,0.00,'2022-08-14 17:33:20','',''),(6843,'21','222','1',1,'Retail Sale Id 5970',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:33:50','',''),(6844,'21','222','1',1,'Retail Sale Id 5971',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:34:23','',''),(6845,'21','222','1',1,'Retail Sale Id 5972',5320.00,0.00,0.00,7.00,0.00,'2022-08-14 17:35:00','',''),(6846,'21','222','1',1,'Retail Sale Id 5973',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:35:27','',''),(6847,'21','222','1',1,'Retail Sale Id 5974',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:36:03','',''),(6848,'21','222','1',1,'Retail Sale Id 5975',8002.80,0.00,0.00,10.53,0.00,'2022-08-14 17:36:32','',''),(6849,'21','222','1',1,'Retail Sale Id 5976',19000.00,0.00,0.00,25.00,0.00,'2022-08-14 17:36:51','',''),(6850,'21','222','1',1,'Retail Sale Id 5978',6840.00,0.00,0.00,9.00,0.00,'2022-08-14 17:37:58','',''),(6851,'21','222',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,170.00,0.00,'2022-08-14 17:43:13','',''),(6852,'21','222','1',1,'Received from bridging 43',0.00,0.00,170.00,0.00,0.00,'2022-08-14 17:43:13','',''),(6853,'21','222','1',1,'Retail Sale Id 5979',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:43:49','',''),(6854,'21','222','1',1,'Retail Sale Id 5980',4560.00,0.00,0.00,6.00,0.00,'2022-08-14 17:44:30','',''),(6855,'21','222','1',1,'Retail Sale Id 5980',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:44:30','',''),(6856,'21','222','1',1,'Retail Sale Id 5981',9500.00,0.00,0.00,12.50,0.00,'2022-08-14 17:45:03','',''),(6857,'21','222','1',1,'Retail Sale Id 5982',15200.00,0.00,0.00,20.00,0.00,'2022-08-14 17:45:26','',''),(6858,'21','222','1',1,'Retail Sale Id 5983',4560.00,0.00,0.00,6.00,0.00,'2022-08-14 17:46:07','',''),(6859,'21','222','1',1,'Retail Sale Id 5984',38000.00,0.00,0.00,50.00,0.00,'2022-08-14 17:46:31','',''),(6860,'21','222','1',1,'Retail Sale Id 5985',7600.00,0.00,0.00,10.00,0.00,'2022-08-14 17:47:05','',''),(6861,'21','222','1',1,'Retail Sale Id 5986',2280.00,0.00,0.00,3.00,0.00,'2022-08-14 17:47:21','',''),(6862,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4050800.00,5330.00,0.00,0.00,'2022-08-15 17:26:19','',''),(6863,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-08-15 17:34:58','',''),(6864,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3799240.00,4999.00,0.00,0.00,'2022-08-15 17:43:56','',''),(6865,'21','222',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,4999.00,0.00,'2022-08-15 17:46:46','',''),(6866,'21','222','1',1,'Received from bridging 47',0.00,0.00,4999.00,0.00,0.00,'2022-08-15 17:46:46','',''),(6867,'21','222','1',1,'Retail Sale Id 5987',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 17:51:52','',''),(6868,'21','222','1',1,'Retail Sale Id 5988',19000.00,0.00,0.00,25.00,0.00,'2022-08-15 17:53:01','',''),(6869,'21','222','1',1,'Retail Sale Id 5989',62996.40,0.00,0.00,82.89,0.00,'2022-08-15 17:55:14','',''),(6870,'21','222','1',1,'Retail Sale Id 5990',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 17:57:06','',''),(6871,'21','222','1',1,'Retail Sale Id 5991',58398.40,0.00,0.00,76.84,0.00,'2022-08-15 17:57:52','',''),(6872,'21','222','1',1,'Retail Sale Id 5992',11400.00,0.00,0.00,15.00,0.00,'2022-08-15 17:58:54','',''),(6873,'21','222','1',1,'Retail Sale Id 5993',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 18:00:12','',''),(6874,'21','222','1',1,'Retail Sale Id 5994',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 18:01:59','',''),(6875,'21','222','1',1,'Retail Sale Id 5995',82999.60,0.00,0.00,109.21,0.00,'2022-08-15 18:02:42','',''),(6876,'21','222','1',1,'Retail Sale Id 5996',76000.00,0.00,0.00,100.00,0.00,'2022-08-15 19:50:33','',''),(6877,'21','222','1',1,'Retail Sale Id 5997',108003.60,0.00,0.00,142.11,0.00,'2022-08-15 19:51:35','',''),(6878,'21','222','1',1,'Retail Sale Id 5998',84998.40,0.00,0.00,111.84,0.00,'2022-08-15 19:52:37','',''),(6879,'21','222','1',1,'Retail Sale Id 5999',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 19:54:18','',''),(6880,'21','222','1',1,'Retail Sale Id 6000',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 19:55:26','',''),(6881,'21','222','1',1,'Retail Sale Id 6001',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 19:56:20','',''),(6882,'21','222','1',1,'Retail Sale Id 6002',105997.20,0.00,0.00,139.47,0.00,'2022-08-15 19:58:01','',''),(6883,'21','222','1',1,'Retail Sale Id 6003',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 19:59:38','',''),(6884,'21','222','1',1,'Retail Sale Id 6004',38000.00,0.00,0.00,50.00,0.00,'2022-08-15 20:00:32','',''),(6885,'21','222','1',1,'Retail Sale Id 6005',25802.00,0.00,0.00,33.95,0.00,'2022-08-15 20:03:00','',''),(6886,'21','222','1',1,'Retail Sale Id 6006',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:25:33','',''),(6887,'21','222','1',1,'Retail Sale Id 6007',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:26:25','',''),(6888,'21','222','1',1,'Retail Sale Id 6008',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:28:58','',''),(6889,'21','222','1',1,'Retail Sale Id 6009',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:33:27','',''),(6890,'21','222','1',1,'Retail Sale Id 6010',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 11:33:55','',''),(6891,'21','222','1',1,'Retail Sale Id 6011',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:35:10','',''),(6892,'21','222','1',1,'Retail Sale Id 6012',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:40:23','',''),(6893,'21','222','1',1,'Retail Sale Id 6014',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:41:33','',''),(6894,'21','222','1',1,'Retail Sale Id 6015',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 11:44:15','',''),(6895,'21','222','1',1,'Retail Sale Id 6015',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:44:15','',''),(6896,'21','222','1',1,'Retail Sale Id 6015',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 11:44:15','',''),(6897,'21','222','1',1,'Retail Sale Id 6016',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 11:50:15','',''),(6898,'21','222','1',1,'Retail Sale Id 6017',3040.00,0.00,0.00,4.00,0.00,'2022-08-16 11:56:09','',''),(6899,'21','222','1',1,'Retail Sale Id 6018',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 11:57:41','',''),(6900,'21','222','1',1,'Retail Sale Id 6019',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 12:00:06','',''),(6901,'21','222','1',1,'Retail Sale Id 6020',760.00,0.00,0.00,1.00,0.00,'2022-08-16 12:02:13','',''),(6902,'21','222','1',1,'Retail Sale Id 6021',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 12:03:15','',''),(6903,'21','222','1',1,'Retail Sale Id 6022',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 12:07:36','',''),(6904,'21','222','1',1,'Retail Sale Id 6022',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 12:07:36','',''),(6905,'21','222','1',1,'Retail Sale Id 6023',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 12:08:58','',''),(6906,'21','222','1',1,'Retail Sale Id 6023',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 12:08:58','',''),(6907,'21','222','1',1,'Retail Sale Id 6024',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 12:47:17','',''),(6908,'21','222','1',1,'Retail Sale Id 6025',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 13:22:23','',''),(6909,'21','222','1',1,'Retail Sale Id 6026',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 13:23:03','',''),(6910,'21','222','1',1,'Retail Sale Id 6027',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 13:37:34','',''),(6911,'21','222','1',1,'Retail Sale Id 6028',5000.80,0.00,0.00,6.58,0.00,'2022-08-16 13:41:13','',''),(6912,'21','222','1',1,'Retail Sale Id 6029',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 14:02:31','',''),(6913,'21','222','1',1,'Retail Sale Id 6030',19000.00,0.00,0.00,25.00,0.00,'2022-08-16 15:06:38','',''),(6914,'21','222','1',1,'Retail Sale Id 6031',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 15:10:01','',''),(6915,'21','222','1',1,'Retail Sale Id 6032',3002.00,0.00,0.00,3.95,0.00,'2022-08-16 15:19:28','',''),(6916,'21','222','1',1,'Retail Sale Id 6033',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 18:01:04','',''),(6917,'21','222','1',1,'Retail Sale Id 6034',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:02:48','',''),(6918,'21','222','1',1,'Retail Sale Id 6035',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:11:50','',''),(6919,'21','222','1',1,'Retail Sale Id 6035',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 18:11:50','',''),(6920,'21','222','1',1,'Retail Sale Id 6036',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 18:13:19','',''),(6921,'21','222','1',1,'Retail Sale Id 6036',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:13:19','',''),(6922,'21','222','1',1,'Retail Sale Id 6036',15200.00,0.00,0.00,20.00,0.00,'2022-08-16 18:13:19','',''),(6923,'21','222','1',1,'Retail Sale Id 6037',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:13:48','',''),(6924,'21','222','1',1,'Retail Sale Id 6038',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 18:14:13','',''),(6925,'21','222','1',1,'Retail Sale Id 6039',1003.20,0.00,0.00,1.32,0.00,'2022-08-16 18:15:03','',''),(6926,'21','222','1',1,'Retail Sale Id 6039',1003.20,0.00,0.00,1.32,0.00,'2022-08-16 18:15:03','',''),(6927,'21','222','1',1,'Retail Sale Id 6040',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:15:41','',''),(6928,'21','222','1',1,'Retail Sale Id 6041',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:16:12','',''),(6929,'21','222','1',1,'Retail Sale Id 6041',15200.00,0.00,0.00,20.00,0.00,'2022-08-16 18:16:12','',''),(6930,'21','222','1',1,'Retail Sale Id 6042',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:20:13','',''),(6931,'21','222','1',1,'Retail Sale Id 6043',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:21:52','',''),(6932,'21','222','1',1,'Retail Sale Id 6043',11400.00,0.00,0.00,15.00,0.00,'2022-08-16 18:21:52','',''),(6933,'21','222','1',1,'Retail Sale Id 6044',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 18:24:23','',''),(6934,'21','222','1',1,'Retail Sale Id 6045',13999.20,0.00,0.00,18.42,0.00,'2022-08-16 18:27:12','',''),(6935,'21','222','1',1,'Retail Sale Id 6046',2280.00,0.00,0.00,3.00,0.00,'2022-08-16 18:27:37','',''),(6936,'21','222','1',1,'Retail Sale Id 6047',7600.00,0.00,0.00,10.00,0.00,'2022-08-16 18:28:36','',''),(6937,'21','222','1',1,'Retail Sale Id 6048',5996.40,0.00,0.00,7.89,0.00,'2022-08-16 18:29:41','',''),(6938,'21','222','1',1,'Retail Sale Id 6048',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:29:41','',''),(6939,'21','222','1',1,'Retail Sale Id 6049',760.00,0.00,0.00,1.00,0.00,'2022-08-16 18:30:56','',''),(6940,'21','222','1',1,'Retail Sale Id 6049',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 18:30:56','',''),(6941,'21','222','1',1,'Retail Sale Id 6050',7600.00,0.00,0.00,10.00,0.00,'2022-08-16 18:31:31','',''),(6942,'21','222','1',1,'Retail Sale Id 6050',19000.00,0.00,0.00,25.00,0.00,'2022-08-16 18:31:31','',''),(6943,'21','222','1',1,'Retail Sale Id 6051',3997.60,0.00,0.00,5.26,0.00,'2022-08-16 18:33:02','',''),(6944,'21','222','1',1,'Retail Sale Id 6052',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 18:33:56','',''),(6945,'21','222','1',1,'Retail Sale Id 6052',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:33:56','',''),(6946,'21','222','1',1,'Retail Sale Id 6053',4560.00,0.00,0.00,6.00,0.00,'2022-08-16 18:36:08','',''),(6947,'21','222','1',1,'Retail Sale Id 6053',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 18:36:08','',''),(6948,'21','222','1',1,'Retail Sale Id 6054',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:36:34','',''),(6949,'21','222','1',1,'Retail Sale Id 6055',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:40:54','',''),(6950,'21','222','1',1,'Retail Sale Id 6056',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 18:49:36','',''),(6951,'21','222','1',1,'Retail Sale Id 6056',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 18:49:36','',''),(6952,'21','222','1',1,'Retail Sale Id 6056',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 18:49:36','',''),(6953,'21','222','1',1,'Retail Sale Id 6057',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:50:07','',''),(6954,'21','222','1',1,'Retail Sale Id 6058',7600.00,0.00,0.00,10.00,0.00,'2022-08-16 18:52:10','',''),(6955,'21','222','1',1,'Retail Sale Id 6058',19000.00,0.00,0.00,25.00,0.00,'2022-08-16 18:52:10','',''),(6956,'21','222','1',1,'Retail Sale Id 6059',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:52:57','',''),(6957,'21','222','1',1,'Retail Sale Id 6059',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:52:57','',''),(6958,'21','222','1',1,'Retail Sale Id 6060',9500.00,0.00,0.00,12.50,0.00,'2022-08-16 18:57:37','',''),(6959,'21','222','1',1,'Retail Sale Id 6060',11400.00,0.00,0.00,15.00,0.00,'2022-08-16 18:57:37','',''),(6960,'21','222','1',1,'Retail Sale Id 6061',7600.00,0.00,0.00,10.00,0.00,'2022-08-16 18:58:51','',''),(6961,'21','222','1',1,'Retail Sale Id 6061',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 18:58:51','',''),(6962,'21','222','1',1,'Retail Sale Id 6062',3800.00,0.00,0.00,5.00,0.00,'2022-08-16 18:59:25','',''),(6963,'21','222','1',1,'Retail Sale Id 6063',19000.00,0.00,0.00,25.00,0.00,'2022-08-16 19:00:36','',''),(6964,'21','222','1',1,'Retail Sale Id 6063',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 19:00:36','',''),(6965,'21','222','1',1,'Retail Sale Id 6063',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 19:00:36','',''),(6966,'21','222','1',1,'Retail Sale Id 6064',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 19:33:27','',''),(6967,'21','222','1',1,'Retail Sale Id 6065',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 19:34:06','',''),(6968,'21','222','1',1,'Retail Sale Id 6066',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 19:34:38','',''),(6969,'21','222','1',1,'Retail Sale Id 6067',38000.00,0.00,0.00,50.00,0.00,'2022-08-16 19:35:01','',''),(6970,'21','222','1',1,'Retail Sale Id 6068',21416.80,0.00,0.00,28.18,0.00,'2022-08-16 19:36:01','',''),(6971,'21','222','1',1,'Retail Sale Id 6069',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 08:46:00','',''),(6972,'21','222','1',1,'Retail Sale Id 6070',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 08:47:23','',''),(6973,'21','222','1',1,'Retail Sale Id 6071',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 08:48:44','',''),(6974,'21','222','1',1,'Retail Sale Id 6072',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 08:50:19','',''),(6975,'21','222','1',1,'Retail Sale Id 6073',2500.40,0.00,0.00,3.29,0.00,'2022-08-17 08:51:32','',''),(6976,'21','222','1',1,'Retail Sale Id 6074',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 08:54:07','',''),(6977,'21','222','1',1,'Retail Sale Id 6075',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 08:57:13','',''),(6978,'21','222','1',1,'Retail Sale Id 6076',798.00,0.00,0.00,1.05,0.00,'2022-08-17 08:57:59','',''),(6979,'21','222','1',1,'Retail Sale Id 6077',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 08:59:44','',''),(6980,'21','222','1',1,'Retail Sale Id 6078',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 09:01:55','',''),(6981,'21','222','1',1,'Retail Sale Id 6079',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 09:04:35','',''),(6982,'21','222','1',1,'Retail Sale Id 6080',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 09:07:32','',''),(6983,'21','222','1',1,'Retail Sale Id 6081',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 09:18:19','',''),(6984,'21','222','1',1,'Retail Sale Id 6082',8998.40,0.00,0.00,11.84,0.00,'2022-08-17 09:19:15','',''),(6985,'21','222','1',1,'Retail Sale Id 6083',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 09:28:09','',''),(6986,'21','222','1',1,'Retail Sale Id 6084',3002.00,0.00,0.00,3.95,0.00,'2022-08-17 09:29:10','',''),(6987,'21','222','1',1,'Retail Sale Id 6085',760.00,0.00,0.00,1.00,0.00,'2022-08-17 09:31:12','',''),(6988,'21','222','1',1,'Retail Sale Id 6086',6080.00,0.00,0.00,8.00,0.00,'2022-08-17 09:32:50','',''),(6989,'21','222','1',1,'Retail Sale Id 6087',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 09:35:39','',''),(6990,'21','222','1',1,'Retail Sale Id 6088',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 09:37:45','',''),(6991,'21','222','1',1,'Retail Sale Id 6089',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 10:22:11','',''),(6992,'21','222','1',1,'Retail Sale Id 6090',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 10:35:31','',''),(6993,'21','222','1',1,'Retail Sale Id 6090',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 10:35:31','',''),(6994,'21','222','1',1,'Retail Sale Id 6091',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 10:37:19','',''),(6995,'21','222','1',1,'Retail Sale Id 6092',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 10:42:33','',''),(6996,'21','222','1',1,'Retail Sale Id 6092',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 10:42:33','',''),(6997,'21','222','1',1,'Retail Sale Id 6093',3503.60,0.00,0.00,4.61,0.00,'2022-08-17 10:44:58','',''),(6998,'21','222','1',1,'Retail Sale Id 6094',8496.80,0.00,0.00,11.18,0.00,'2022-08-17 10:49:48','',''),(6999,'21','222','1',1,'Retail Sale Id 6095',8002.80,0.00,0.00,10.53,0.00,'2022-08-17 10:52:36','',''),(7000,'21','222','1',1,'Retail Sale Id 6096',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 10:54:39','',''),(7001,'21','222','1',1,'Retail Sale Id 6097',8002.80,0.00,0.00,10.53,0.00,'2022-08-17 10:56:55','',''),(7002,'21','222','1',1,'Retail Sale Id 6098',1003.20,0.00,0.00,1.32,0.00,'2022-08-17 11:00:34','',''),(7003,'21','222','1',1,'Retail Sale Id 6098',3503.60,0.00,0.00,4.61,0.00,'2022-08-17 11:00:34','',''),(7004,'21','222','1',1,'Retail Sale Id 6099',2401.60,0.00,0.00,3.16,0.00,'2022-08-17 11:01:37','',''),(7005,'21','222','1',1,'Retail Sale Id 6100',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 11:03:51','',''),(7006,'21','222','1',1,'Retail Sale Id 6101',1003.20,0.00,0.00,1.32,0.00,'2022-08-17 11:06:54','',''),(7007,'21','222','1',1,'Retail Sale Id 6102',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 11:10:26','',''),(7008,'21','222','1',1,'Retail Sale Id 6103',2302.80,0.00,0.00,3.03,0.00,'2022-08-17 11:12:51','',''),(7009,'21','222','1',1,'Retail Sale Id 6104',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 12:09:46','',''),(7010,'21','222','1',1,'Retail Sale Id 6105',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 12:11:16','',''),(7011,'21','222','1',1,'Retail Sale Id 6106',1998.80,0.00,0.00,2.63,0.00,'2022-08-17 12:12:40','',''),(7012,'21','222','1',1,'Retail Sale Id 6107',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 12:14:22','',''),(7013,'21','222','1',1,'Retail Sale Id 6107',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 12:14:22','',''),(7014,'21','222','1',1,'Retail Sale Id 6108',3997.60,0.00,0.00,5.26,0.00,'2022-08-17 12:30:16','',''),(7015,'21','222','1',1,'Retail Sale Id 6108',3997.60,0.00,0.00,5.26,0.00,'2022-08-17 12:30:16','',''),(7016,'21','222','1',1,'Retail Sale Id 6109',2280.00,0.00,0.00,3.00,0.00,'2022-08-17 12:31:11','',''),(7017,'21','222','1',1,'Retail Sale Id 6110',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 12:33:22','',''),(7018,'21','222','1',1,'Retail Sale Id 6111',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 12:39:16','',''),(7019,'21','222','1',1,'Retail Sale Id 6112',3997.60,0.00,0.00,5.26,0.00,'2022-08-17 12:40:44','',''),(7020,'21','222','1',1,'Retail Sale Id 6113',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 12:41:39','',''),(7021,'21','222','1',1,'Retail Sale Id 6114',1520.00,0.00,0.00,2.00,0.00,'2022-08-17 12:43:51','',''),(7022,'21','222','1',1,'Retail Sale Id 6115',3503.60,0.00,0.00,4.61,0.00,'2022-08-17 13:07:15','',''),(7023,'21','222','1',1,'Retail Sale Id 6115',3997.60,0.00,0.00,5.26,0.00,'2022-08-17 13:07:15','',''),(7024,'21','222','1',1,'Retail Sale Id 6116',1003.20,0.00,0.00,1.32,0.00,'2022-08-17 13:08:41','',''),(7025,'21','222','1',1,'Retail Sale Id 6117',15200.00,0.00,0.00,20.00,0.00,'2022-08-17 13:18:24','',''),(7026,'21','222','1',1,'Retail Sale Id 6118',8998.40,0.00,0.00,11.84,0.00,'2022-08-17 16:35:14','',''),(7027,'21','222','1',1,'Retail Sale Id 6119',1497.20,0.00,0.00,1.97,0.00,'2022-08-17 16:37:50','',''),(7028,'21','222','1',1,'Retail Sale Id 6120',1003.20,0.00,0.00,1.32,0.00,'2022-08-17 16:40:27','',''),(7029,'21','222','1',1,'Retail Sale Id 6121',9500.00,0.00,0.00,12.50,0.00,'2022-08-17 17:33:52','',''),(7030,'21','222','1',1,'Retail Sale Id 6122',760.00,0.00,0.00,1.00,0.00,'2022-08-17 17:46:17','',''),(7031,'21','222','1',1,'Retail Sale Id 6122',760.00,0.00,0.00,1.00,0.00,'2022-08-17 17:46:17','',''),(7032,'21','222','1',1,'Retail Sale Id 6122',760.00,0.00,0.00,1.00,0.00,'2022-08-17 17:46:17','',''),(7033,'21','222','1',1,'Retail Sale Id 6122',760.00,0.00,0.00,1.00,0.00,'2022-08-17 17:46:17','',''),(7034,'21','222','1',1,'Retail Sale Id 6123',760.00,0.00,0.00,1.00,0.00,'2022-08-17 17:47:22','',''),(7035,'21','222','1',1,'Retail Sale Id 6123',760.00,0.00,0.00,1.00,0.00,'2022-08-17 17:47:22','',''),(7036,'21','222','1',1,'Retail Sale Id 6123',760.00,0.00,0.00,1.00,0.00,'2022-08-17 17:47:22','',''),(7037,'21','222','1',1,'Retail Sale Id 6124',3800.00,0.00,0.00,5.00,0.00,'2022-08-17 17:49:02','',''),(7038,'21','222','1',1,'Retail Sale Id 6125',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:07:12','',''),(7039,'21','222','1',1,'Retail Sale Id 6126',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:07:54','',''),(7040,'21','222','1',1,'Retail Sale Id 6127',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:09:19','',''),(7041,'21','222','1',1,'Retail Sale Id 6128',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:11:20','',''),(7042,'21','222','1',1,'Retail Sale Id 6129',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:12:52','',''),(7043,'21','222','1',1,'Retail Sale Id 6130',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:17:00','',''),(7044,'21','222','1',1,'Retail Sale Id 6131',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:17:26','',''),(7045,'21','222','1',1,'Retail Sale Id 6132',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:17:54','',''),(7046,'21','222','1',1,'Retail Sale Id 6133',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 18:18:54','',''),(7047,'21','222','1',1,'Retail Sale Id 6134',4560.00,0.00,0.00,6.00,0.00,'2022-08-17 18:30:21','',''),(7048,'21','222','1',1,'Retail Sale Id 6135',5996.40,0.00,0.00,7.89,0.00,'2022-08-17 18:32:16','',''),(7049,'21','222','1',1,'Retail Sale Id 6136',1140.00,0.00,0.00,1.50,0.00,'2022-08-17 19:03:28','',''),(7050,'21','222','1',1,'Retail Sale Id 6137',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 19:49:10','',''),(7051,'21','222','1',1,'Retail Sale Id 6138',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 19:49:42','',''),(7052,'21','222','1',1,'Retail Sale Id 6139',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 19:50:10','',''),(7053,'21','222','1',1,'Retail Sale Id 6140',76000.00,0.00,0.00,100.00,0.00,'2022-08-17 19:50:37','',''),(7054,'21','222','1',1,'Retail Sale Id 6141',76000.00,0.00,0.00,100.00,0.00,'2022-08-17 19:53:24','',''),(7055,'21','222','1',1,'Retail Sale Id 6142',11400.00,0.00,0.00,15.00,0.00,'2022-08-17 19:53:58','',''),(7056,'21','222','1',1,'Retail Sale Id 6142',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 19:53:58','',''),(7057,'21','222','1',1,'Retail Sale Id 6143',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 19:54:19','',''),(7058,'21','222','1',1,'Retail Sale Id 6144',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 19:54:46','',''),(7059,'21','222','1',1,'Retail Sale Id 6145',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 19:55:09','',''),(7060,'21','222','1',1,'Retail Sale Id 6146',38000.00,0.00,0.00,50.00,0.00,'2022-08-17 19:55:37','',''),(7061,'21','222','1',1,'Retail Sale Id 6147',8892.00,0.00,0.00,11.70,0.00,'2022-08-17 19:57:25','',''),(7062,'21','222','1',1,'Retail Sale Id 6148',4560.00,0.00,0.00,6.00,0.00,'2022-08-18 07:53:20','',''),(7063,'21','222','1',1,'Retail Sale Id 6149',3997.60,0.00,0.00,5.26,0.00,'2022-08-18 08:03:48','',''),(7064,'21','222','1',1,'Retail Sale Id 6150',3199.60,0.00,0.00,4.21,0.00,'2022-08-18 08:08:40','',''),(7065,'21','222','1',1,'Retail Sale Id 6151',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 08:11:54','',''),(7066,'21','222','1',1,'Retail Sale Id 6152',3040.00,0.00,0.00,4.00,0.00,'2022-08-18 08:12:29','',''),(7067,'21','222','1',1,'Retail Sale Id 6153',5996.40,0.00,0.00,7.89,0.00,'2022-08-18 08:15:23','',''),(7068,'21','222','1',1,'Retail Sale Id 6154',4560.00,0.00,0.00,6.00,0.00,'2022-08-18 08:25:44','',''),(7069,'21','222','1',1,'Retail Sale Id 6155',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 08:33:58','',''),(7070,'21','222','1',1,'Retail Sale Id 6156',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 08:34:41','',''),(7071,'21','222','1',1,'Retail Sale Id 6157',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 08:35:45','',''),(7072,'21','222','1',1,'Retail Sale Id 6157',15200.00,0.00,0.00,20.00,0.00,'2022-08-18 08:35:45','',''),(7073,'21','222','1',1,'Retail Sale Id 6158',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 08:39:01','',''),(7074,'21','222','1',1,'Retail Sale Id 6159',16720.00,0.00,0.00,22.00,0.00,'2022-08-18 08:40:49','',''),(7075,'21','222','1',1,'Retail Sale Id 6160',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 11:01:03','',''),(7076,'21','222','1',1,'Retail Sale Id 6161',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 11:01:26','',''),(7077,'21','222','1',1,'Retail Sale Id 6162',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 11:02:13','',''),(7078,'21','222','1',1,'Retail Sale Id 6163',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 11:02:35','',''),(7079,'21','222','1',1,'Retail Sale Id 6164',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 11:02:54','',''),(7080,'21','222','1',1,'Retail Sale Id 6167',30400.00,0.00,0.00,40.00,0.00,'2022-08-18 11:08:33','',''),(7081,'21','222','1',1,'Retail Sale Id 6169',6840.00,0.00,0.00,9.00,0.00,'2022-08-18 11:09:24','',''),(7082,'21','222',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,330.00,0.00,'2022-08-18 12:09:34','',''),(7083,'21','222','1',1,'Received from bridging 48',0.00,0.00,330.00,0.00,0.00,'2022-08-18 12:09:34','',''),(7084,'21','222','1',1,'Retail Sale Id 6170',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 12:12:36','',''),(7085,'21','222','1',1,'Retail Sale Id 6171',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 13:34:00','',''),(7086,'21','222','1',1,'Retail Sale Id 6172',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 15:04:29','',''),(7090,'21','222','1',1,'Retail Sale Id 6174',19000.00,0.00,0.00,25.00,0.00,'2022-08-18 15:08:32','',''),(7091,'21','222','1',1,'Retail Sale Id 6174',19000.00,0.00,0.00,25.00,0.00,'2022-08-18 15:08:32','',''),(7092,'21','222','1',1,'Retail Sale Id 6176',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 15:09:48','',''),(7093,'21','222','1',1,'Retail Sale Id 6177',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 15:11:35','',''),(7094,'21','222','1',1,'Retail Sale Id 6178',76000.00,0.00,0.00,100.00,0.00,'2022-08-18 15:12:28','',''),(7095,'21','222','1',1,'Retail Sale Id 6179',15200.00,0.00,0.00,20.00,0.00,'2022-08-18 15:13:40','',''),(7096,'21','222','1',1,'Retail Sale Id 6179',15200.00,0.00,0.00,20.00,0.00,'2022-08-18 15:13:40','',''),(7097,'21','222','1',1,'Retail Sale Id 6180',2280.00,0.00,0.00,3.00,0.00,'2022-08-18 15:14:39','',''),(7098,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-08-18 20:16:41','',''),(7099,'21','222',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,4999.82,0.00,'2022-08-18 20:19:38','',''),(7100,'21','222','1',1,'Received from bridging 49',0.00,0.00,4999.82,0.00,0.00,'2022-08-18 20:19:38','',''),(7101,'21','222','1',1,'Retail Sale Id 6181',4560.00,0.00,0.00,6.00,0.00,'2022-08-18 20:24:56','',''),(7102,'21','222','1',1,'Retail Sale Id 6181',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 20:24:56','',''),(7103,'21','222','1',1,'Retail Sale Id 6182',7600.00,0.00,0.00,10.00,0.00,'2022-08-18 20:25:15','',''),(7104,'21','222','1',1,'Retail Sale Id 6183',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 20:25:41','',''),(7105,'21','222','1',1,'Retail Sale Id 6183',15200.00,0.00,0.00,20.00,0.00,'2022-08-18 20:25:41','',''),(7106,'21','222','1',1,'Retail Sale Id 6184',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 20:26:13','',''),(7107,'21','222','1',1,'Retail Sale Id 6184',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 20:26:13','',''),(7108,'21','222','1',1,'Retail Sale Id 6185',19000.00,0.00,0.00,25.00,0.00,'2022-08-18 20:26:40','',''),(7109,'21','222','1',1,'Retail Sale Id 6186',4560.00,0.00,0.00,6.00,0.00,'2022-08-18 20:26:56','',''),(7110,'21','222','1',1,'Retail Sale Id 6187',19000.00,0.00,0.00,25.00,0.00,'2022-08-18 20:27:43','',''),(7111,'21','222','1',1,'Retail Sale Id 6187',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 20:27:43','',''),(7112,'21','222','1',1,'Retail Sale Id 6187',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 20:27:43','',''),(7113,'21','222','1',1,'Retail Sale Id 6188',7600.00,0.00,0.00,10.00,0.00,'2022-08-18 20:28:21','',''),(7114,'21','222','1',1,'Retail Sale Id 6188',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 20:28:21','',''),(7115,'21','222','1',1,'Retail Sale Id 6189',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 20:29:32','',''),(7116,'21','222','1',1,'Retail Sale Id 6189',9500.00,0.00,0.00,12.50,0.00,'2022-08-18 20:29:32','',''),(7117,'21','222','1',1,'Retail Sale Id 6189',38000.00,0.00,0.00,50.00,0.00,'2022-08-18 20:29:32','',''),(7118,'21','222','1',1,'Retail Sale Id 6190',6102.80,0.00,0.00,8.03,0.00,'2022-08-18 20:30:42','',''),(7119,'21','222','1',1,'Retail Sale Id 6191',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 09:35:23','',''),(7120,'21','222','1',1,'Retail Sale Id 6192',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 09:40:42','',''),(7121,'21','222','1',1,'Retail Sale Id 6193',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 11:33:08','',''),(7122,'21','222','1',1,'Retail Sale Id 6193',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 11:33:08','',''),(7123,'21','222','1',1,'Retail Sale Id 6194',15200.00,0.00,0.00,20.00,0.00,'2022-08-19 11:34:38','',''),(7124,'21','222','1',1,'Retail Sale Id 6194',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 11:34:38','',''),(7125,'21','222','1',1,'Retail Sale Id 6195',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 11:35:35','',''),(7126,'21','222','1',1,'Retail Sale Id 6195',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 11:35:35','',''),(7127,'21','222','1',1,'Retail Sale Id 6196',7600.00,0.00,0.00,10.00,0.00,'2022-08-19 11:38:40','',''),(7128,'21','222','1',1,'Retail Sale Id 6196',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 11:38:40','',''),(7129,'21','222','1',1,'Retail Sale Id 6197',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 11:39:00','',''),(7130,'21','222','1',1,'Retail Sale Id 6198',2280.00,0.00,0.00,3.00,0.00,'2022-08-19 11:39:47','',''),(7131,'21','222','1',1,'Retail Sale Id 6199',5320.00,0.00,0.00,7.00,0.00,'2022-08-19 11:47:22','',''),(7132,'21','222','1',1,'Retail Sale Id 6200',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 12:15:20','',''),(7133,'21','222','1',1,'Retail Sale Id 6201',3002.00,0.00,0.00,3.95,0.00,'2022-08-19 13:19:29','',''),(7134,'21','222','1',1,'Retail Sale Id 6202',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 13:23:28','',''),(7135,'21','222','1',1,'Retail Sale Id 6203',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 13:24:56','',''),(7136,'21','222','1',1,'Retail Sale Id 6204',4750.00,0.00,0.00,6.25,0.00,'2022-08-19 13:32:20','',''),(7137,'21','222','1',1,'Retail Sale Id 6206',3800.00,0.00,0.00,5.00,0.00,'2022-08-19 13:36:14','',''),(7138,'21','222','1',1,'Retail Sale Id 6207',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 13:41:18','',''),(7139,'21','222','1',1,'Retail Sale Id 6208',1003.20,0.00,0.00,1.32,0.00,'2022-08-19 13:43:37','',''),(7140,'21','222','1',1,'Retail Sale Id 6208',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 13:43:37','',''),(7141,'21','222','1',1,'Retail Sale Id 6209',5000.80,0.00,0.00,6.58,0.00,'2022-08-19 14:58:24','',''),(7142,'21','222','1',1,'Retail Sale Id 6209',5000.80,0.00,0.00,6.58,0.00,'2022-08-19 14:58:24','',''),(7143,'21','222','1',1,'Retail Sale Id 6210',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 15:42:40','',''),(7144,'21','222','1',1,'Retail Sale Id 6211',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 16:11:17','',''),(7145,'21','222','1',1,'Retail Sale Id 6212',3800.00,0.00,0.00,5.00,0.00,'2022-08-19 16:12:15','',''),(7146,'21','222','1',1,'Retail Sale Id 6213',6080.00,0.00,0.00,8.00,0.00,'2022-08-19 16:14:29','',''),(7147,'21','222','1',1,'Retail Sale Id 6213',7600.00,0.00,0.00,10.00,0.00,'2022-08-19 16:14:29','',''),(7148,'21','222','1',1,'Retail Sale Id 6214',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 16:16:11','',''),(7149,'21','222','1',1,'Retail Sale Id 6214',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 16:16:11','',''),(7150,'21','222','1',1,'Retail Sale Id 6215',3800.00,0.00,0.00,5.00,0.00,'2022-08-19 17:08:06','',''),(7151,'21','222','1',1,'Retail Sale Id 6216',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 17:15:48','',''),(7152,'21','222','1',1,'Retail Sale Id 6217',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 17:18:17','',''),(7153,'21','222','1',1,'Retail Sale Id 6217',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 17:18:17','',''),(7154,'21','222','1',1,'Retail Sale Id 6218',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 17:30:14','',''),(7155,'21','222','1',1,'Retail Sale Id 6218',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 17:30:14','',''),(7156,'21','222','1',1,'Retail Sale Id 6219',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 17:36:42','',''),(7157,'21','222','1',1,'Retail Sale Id 6220',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 18:14:38','',''),(7158,'21','222','1',1,'Retail Sale Id 6220',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 18:14:38','',''),(7159,'21','222','1',1,'Retail Sale Id 6220',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 18:14:38','',''),(7160,'21','222','1',1,'Retail Sale Id 6221',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 18:15:25','',''),(7161,'21','222','1',1,'Retail Sale Id 6221',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 18:15:25','',''),(7162,'21','222','1',1,'Retail Sale Id 6222',4560.00,0.00,0.00,6.00,0.00,'2022-08-19 18:18:59','',''),(7163,'21','222','1',1,'Retail Sale Id 6222',9500.00,0.00,0.00,12.50,0.00,'2022-08-19 18:18:59','',''),(7164,'21','222','1',1,'Retail Sale Id 6223',11400.00,0.00,0.00,15.00,0.00,'2022-08-19 18:20:02','',''),(7165,'21','222','1',1,'Retail Sale Id 6223',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 18:20:02','',''),(7166,'21','222','1',1,'Retail Sale Id 6223',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 18:20:02','',''),(7167,'21','222','1',1,'Retail Sale Id 6224',19000.00,0.00,0.00,25.00,0.00,'2022-08-19 18:20:57','',''),(7168,'21','222','1',1,'Retail Sale Id 6224',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 18:20:57','',''),(7169,'21','222','1',1,'Retail Sale Id 6224',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 18:20:57','',''),(7170,'21','222','1',1,'Retail Sale Id 6224',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 18:20:57','',''),(7171,'21','222','1',1,'Retail Sale Id 6225',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 19:50:15','',''),(7172,'21','222','1',1,'Retail Sale Id 6226',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 19:50:37','',''),(7173,'21','222','1',1,'Retail Sale Id 6227',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 19:50:59','',''),(7174,'21','222','1',1,'Retail Sale Id 6228',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 19:51:37','',''),(7175,'21','222','1',1,'Retail Sale Id 6229',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 19:52:15','',''),(7176,'21','222','1',1,'Retail Sale Id 6230',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 19:52:59','',''),(7177,'21','222','1',1,'Retail Sale Id 6231',38000.00,0.00,0.00,50.00,0.00,'2022-08-19 19:53:31','',''),(7178,'21','222','1',1,'Retail Sale Id 6232',25209.20,0.00,0.00,33.17,0.00,'2022-08-19 19:54:27','',''),(7179,'21','222','1',1,'Retail Sale Id 6233',4560.00,0.00,0.00,6.00,0.00,'2022-08-20 09:07:54','',''),(7180,'21','222','1',1,'Retail Sale Id 6234',9500.00,0.00,0.00,12.50,0.00,'2022-08-20 09:20:36','',''),(7181,'21','222','1',1,'Retail Sale Id 6235',9500.00,0.00,0.00,12.50,0.00,'2022-08-20 09:21:08','',''),(7182,'21','222','1',1,'Retail Sale Id 6236',4560.00,0.00,0.00,6.00,0.00,'2022-08-20 09:22:34','',''),(7183,'21','222','1',1,'Retail Sale Id 6237',6080.00,0.00,0.00,8.00,0.00,'2022-08-20 09:23:16','',''),(7184,'21','222','1',1,'Retail Sale Id 6238',9500.00,0.00,0.00,12.50,0.00,'2022-08-20 09:23:48','',''),(7185,'21','222','1',1,'Retail Sale Id 6239',8998.40,0.00,0.00,11.84,0.00,'2022-08-20 09:24:48','',''),(7186,'21','222','1',1,'Retail Sale Id 6240',4560.00,0.00,0.00,6.00,0.00,'2022-08-20 09:53:30','',''),(7187,'21','222','1',1,'Retail Sale Id 6240',9500.00,0.00,0.00,12.50,0.00,'2022-08-20 09:53:30','',''),(7188,'21','222','1',1,'Retail Sale Id 6241',9500.00,0.00,0.00,12.50,0.00,'2022-08-20 13:50:20','',''),(7189,'21','222','1',1,'Retail Sale Id 6242',4560.00,0.00,0.00,6.00,0.00,'2022-08-20 18:12:15','',''),(7190,'21','222','1',1,'Retail Sale Id 6243',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:15:37','',''),(7191,'21','222','1',1,'Retail Sale Id 6244',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:16:00','',''),(7192,'21','222','1',1,'Retail Sale Id 6246',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:32:24','',''),(7193,'21','222','1',1,'Retail Sale Id 6247',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:32:45','',''),(7194,'21','222','1',1,'Retail Sale Id 6248',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:33:07','',''),(7195,'21','222','1',1,'Retail Sale Id 6249',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:33:27','',''),(7196,'21','222','1',1,'Retail Sale Id 6250',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:33:49','',''),(7197,'21','222','1',1,'Retail Sale Id 6252',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:34:13','',''),(7198,'21','222','1',1,'Retail Sale Id 6253',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:34:34','',''),(7199,'21','222','1',1,'Retail Sale Id 6254',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:35:04','',''),(7200,'21','222','1',1,'Retail Sale Id 6255',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:35:34','',''),(7201,'21','222','1',1,'Retail Sale Id 6256',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:35:57','',''),(7202,'21','222','1',1,'Retail Sale Id 6257',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:36:19','',''),(7203,'21','222','1',1,'Retail Sale Id 6258',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:36:38','',''),(7204,'21','222','1',1,'Retail Sale Id 6259',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:37:17','',''),(7205,'21','222','1',1,'Retail Sale Id 6260',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:37:50','',''),(7206,'21','222','1',1,'Retail Sale Id 6261',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:38:14','',''),(7207,'21','222','1',1,'Retail Sale Id 6262',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:38:49','',''),(7208,'21','222','1',1,'Retail Sale Id 6263',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:39:25','',''),(7209,'21','222','1',1,'Retail Sale Id 6264',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:39:48','',''),(7210,'21','222','1',1,'Retail Sale Id 6265',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:40:17','',''),(7211,'21','222','1',1,'Retail Sale Id 6266',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:41:29','',''),(7212,'21','222','1',1,'Return of Retail Sale Id 6266',0.00,38000.00,50.00,0.00,0.00,'2022-08-20 18:43:40','',''),(7213,'21','222','1',1,'Retail Sale Id 6267',2280.00,0.00,0.00,3.00,0.00,'2022-08-20 18:50:49','',''),(7214,'21','222','1',1,'Retail Sale Id 6268',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 18:59:02','',''),(7215,'21','222','1',1,'Retail Sale Id 6269',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 19:44:13','',''),(7216,'21','222','1',1,'Retail Sale Id 6270',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 19:44:43','',''),(7217,'21','222','1',1,'Retail Sale Id 6271',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 19:45:31','',''),(7218,'21','222','1',1,'Retail Sale Id 6272',38000.00,0.00,0.00,50.00,0.00,'2022-08-20 19:45:58','',''),(7219,'21','222','1',1,'Retail Sale Id 6273',29997.20,0.00,0.00,39.47,0.00,'2022-08-20 19:46:37','',''),(7220,'21','222','1',1,'Retail Sale Id 6274',2781.60,0.00,0.00,3.66,0.00,'2022-08-20 19:47:33','',''),(7221,'21','222','1',1,'Retail Sale Id 6275',1520.00,0.00,0.00,2.00,0.00,'2022-08-21 07:44:08','',''),(7222,'21','222','1',1,'Retail Sale Id 6276',4560.00,0.00,0.00,6.00,0.00,'2022-08-21 09:20:04','',''),(7223,'21','222','1',1,'Retail Sale Id 6277',4750.00,0.00,0.00,6.25,0.00,'2022-08-21 09:20:47','',''),(7224,'21','222','1',1,'Retail Sale Id 6278',5000.80,0.00,0.00,6.58,0.00,'2022-08-21 09:21:37','',''),(7225,'21','222','1',1,'Retail Sale Id 6279',5996.40,0.00,0.00,7.89,0.00,'2022-08-21 09:22:59','',''),(7226,'21','222','1',1,'Retail Sale Id 6280',3997.60,0.00,0.00,5.26,0.00,'2022-08-21 09:23:54','',''),(7227,'21','222','1',1,'Retail Sale Id 6281',4560.00,0.00,0.00,6.00,0.00,'2022-08-21 09:24:46','',''),(7228,'21','222','1',1,'Retail Sale Id 6282',1998.80,0.00,0.00,2.63,0.00,'2022-08-21 09:25:42','',''),(7229,'21','222','1',1,'Retail Sale Id 6283',1497.20,0.00,0.00,1.97,0.00,'2022-08-21 09:29:13','',''),(7230,'21','222','1',1,'Retail Sale Id 6284',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 09:29:56','',''),(7231,'21','222','1',1,'Retail Sale Id 6284',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 09:29:56','',''),(7232,'21','222','1',1,'Retail Sale Id 6285',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 09:32:29','',''),(7233,'21','222','1',1,'Retail Sale Id 6286',3002.00,0.00,0.00,3.95,0.00,'2022-08-21 09:33:59','',''),(7234,'21','222','1',1,'Retail Sale Id 6287',3800.00,0.00,0.00,5.00,0.00,'2022-08-21 09:34:49','',''),(7235,'21','222','1',1,'Retail Sale Id 6288',3800.00,0.00,0.00,5.00,0.00,'2022-08-21 09:35:56','',''),(7236,'21','222','1',1,'Retail Sale Id 6289',2280.00,0.00,0.00,3.00,0.00,'2022-08-21 09:36:41','',''),(7237,'21','222','1',1,'Retail Sale Id 6290',2280.00,0.00,0.00,3.00,0.00,'2022-08-21 09:37:47','',''),(7238,'21','222','1',1,'Retail Sale Id 6291',4560.00,0.00,0.00,6.00,0.00,'2022-08-21 09:38:53','',''),(7239,'21','222','1',1,'Retail Sale Id 6292',4560.00,0.00,0.00,6.00,0.00,'2022-08-21 09:40:24','',''),(7240,'21','222','1',1,'Retail Sale Id 6293',3040.00,0.00,0.00,4.00,0.00,'2022-08-21 09:42:09','',''),(7241,'21','222','1',1,'Retail Sale Id 6294',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 09:44:19','',''),(7242,'21','222','1',1,'Retail Sale Id 6295',2280.00,0.00,0.00,3.00,0.00,'2022-08-21 10:47:06','',''),(7243,'21','222','1',1,'Retail Sale Id 6296',3997.60,0.00,0.00,5.26,0.00,'2022-08-21 10:48:51','',''),(7244,'21','222','1',1,'Retail Sale Id 6297',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 11:24:13','',''),(7245,'21','222','1',1,'Retail Sale Id 6298',5000.80,0.00,0.00,6.58,0.00,'2022-08-21 11:25:01','',''),(7246,'21','222','1',1,'Retail Sale Id 6299',1497.20,0.00,0.00,1.97,0.00,'2022-08-21 12:44:23','',''),(7247,'21','222','1',1,'Retail Sale Id 6300',4560.00,0.00,0.00,6.00,0.00,'2022-08-21 12:46:32','',''),(7248,'21','222','1',1,'Retail Sale Id 6301',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 12:53:31','',''),(7249,'21','222','1',1,'Retail Sale Id 6302',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 13:05:54','',''),(7250,'21','222','1',1,'Retail Sale Id 6303',4499.20,0.00,0.00,5.92,0.00,'2022-08-21 13:41:23','',''),(7251,'21','222','1',1,'Retail Sale Id 6304',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 13:49:49','',''),(7252,'21','222','1',1,'Retail Sale Id 6305',1497.20,0.00,0.00,1.97,0.00,'2022-08-21 13:51:09','',''),(7253,'21','222','1',1,'Retail Sale Id 6306',1520.00,0.00,0.00,2.00,0.00,'2022-08-21 13:52:54','',''),(7254,'21','222','1',1,'Retail Sale Id 6307',3800.00,0.00,0.00,5.00,0.00,'2022-08-21 13:53:44','',''),(7255,'21','222','1',1,'Retail Sale Id 6308',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:36:17','',''),(7256,'21','222','1',1,'Retail Sale Id 6309',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:41:29','',''),(7257,'21','222','1',1,'Retail Sale Id 6310',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 14:42:14','',''),(7258,'21','222','1',1,'Retail Sale Id 6311',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:45:22','',''),(7259,'21','222','1',1,'Retail Sale Id 6312',9500.00,0.00,0.00,12.50,0.00,'2022-08-21 14:46:05','',''),(7260,'21','222','1',1,'Retail Sale Id 6312',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:46:05','',''),(7261,'21','222','1',1,'Retail Sale Id 6313',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:48:46','',''),(7262,'21','222','1',1,'Retail Sale Id 6314',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:52:31','',''),(7263,'21','222','1',1,'Retail Sale Id 6315',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:52:54','',''),(7264,'21','222','1',1,'Retail Sale Id 6316',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:53:18','',''),(7265,'21','222','1',1,'Retail Sale Id 6317',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:54:18','',''),(7266,'21','222','1',1,'Retail Sale Id 6318',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:55:11','',''),(7267,'21','222','1',1,'Retail Sale Id 6319',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:55:33','',''),(7268,'21','222','1',1,'Retail Sale Id 6320',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 14:56:01','',''),(7269,'21','222','1',1,'Retail Sale Id 6321',5000.80,0.00,0.00,6.58,0.00,'2022-08-21 15:01:10','',''),(7270,'21','222','1',1,'Retail Sale Id 6322',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:21:34','',''),(7271,'21','222','1',1,'Retail Sale Id 6323',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:33:59','',''),(7272,'21','222','1',1,'Retail Sale Id 6324',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:34:30','',''),(7273,'21','222','1',1,'Retail Sale Id 6325',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:35:06','',''),(7274,'21','222','1',1,'Retail Sale Id 6326',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:36:07','',''),(7275,'21','222','1',1,'Retail Sale Id 6327',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:39:06','',''),(7276,'21','222','1',1,'Retail Sale Id 6328',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:39:30','',''),(7277,'21','222','1',1,'Retail Sale Id 6329',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:40:31','',''),(7278,'21','222','1',1,'Retail Sale Id 6330',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:41:04','',''),(7279,'21','222','1',1,'Retail Sale Id 6331',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:41:29','',''),(7280,'21','222','1',1,'Retail Sale Id 6332',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:42:51','',''),(7281,'21','222','1',1,'Retail Sale Id 6333',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:44:35','',''),(7282,'21','222','1',1,'Retail Sale Id 6334',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:45:02','',''),(7283,'21','222','1',1,'Retail Sale Id 6335',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:45:36','',''),(7284,'21','222','1',1,'Retail Sale Id 6336',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:46:01','',''),(7285,'21','222','1',1,'Retail Sale Id 6338',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:46:28','',''),(7286,'21','222','1',1,'Retail Sale Id 6339',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:46:50','',''),(7287,'21','222','1',1,'Retail Sale Id 6340',38000.00,0.00,0.00,50.00,0.00,'2022-08-21 15:47:12','',''),(7288,'21','222','1',1,'Retail Sale Id 6341',22800.00,0.00,0.00,30.00,0.00,'2022-08-21 15:47:44','',''),(7289,'21','222','1',1,'Retail Sale Id 6343',7600.00,0.00,0.00,10.00,0.00,'2022-08-21 15:49:22','',''),(7290,'21','222','1',1,'Retail Sale Id 6344',4560.00,0.00,0.00,6.00,0.00,'2022-08-21 15:49:51','',''),(7291,'21','222','1',1,'Retail Sale Id 6345',3040.00,0.00,0.00,4.00,0.00,'2022-08-21 15:50:15','',''),(7292,'21','222',NULL,1,'Returned purchase #32 to AYM SHAFA NIGERIA. LTD',3800000.00,0.00,0.00,5000.00,0.00,'2022-08-22 07:42:39','',''),(7293,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-08-22 07:44:52','',''),(7294,'21','222',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,4999.66,0.00,'2022-08-22 07:47:16','',''),(7295,'21','222','1',1,'Received from bridging 50',0.00,0.00,4999.66,0.00,0.00,'2022-08-22 07:47:16','',''),(7296,'21','222','1',1,'Retail Sale Id 6346',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 07:49:14','',''),(7297,'21','222','1',1,'Retail Sale Id 6347',8002.80,0.00,0.00,10.53,0.00,'2022-08-22 07:49:42','',''),(7298,'21','222','1',1,'Retail Sale Id 6348',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 07:50:04','',''),(7299,'21','222','1',1,'Retail Sale Id 6349',29997.20,0.00,0.00,39.47,0.00,'2022-08-22 07:50:38','',''),(7300,'21','222','1',1,'Return of Retail Sale Id 6347',0.00,8002.80,10.53,0.00,0.00,'2022-08-22 07:51:16','',''),(7301,'21','222','1',1,'Retail Sale Id 6350',7501.20,0.00,0.00,9.87,0.00,'2022-08-22 07:52:14','',''),(7302,'21','222','1',1,'Retail Sale Id 6351',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 08:12:58','',''),(7303,'21','222','1',1,'Retail Sale Id 6352',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 08:25:46','',''),(7304,'21','222','1',1,'Retail Sale Id 6353',4560.00,0.00,0.00,6.00,0.00,'2022-08-22 08:27:28','',''),(7305,'21','222','1',1,'Retail Sale Id 6353',4560.00,0.00,0.00,6.00,0.00,'2022-08-22 08:27:28','',''),(7306,'21','222','1',1,'Retail Sale Id 6354',1497.20,0.00,0.00,1.97,0.00,'2022-08-22 09:02:55','',''),(7307,'21','222','1',1,'Retail Sale Id 6355',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 11:58:19','',''),(7308,'21','222','1',1,'Retail Sale Id 6356',2280.00,0.00,0.00,3.00,0.00,'2022-08-22 12:06:13','',''),(7309,'21','222','1',1,'Retail Sale Id 6357',4560.00,0.00,0.00,6.00,0.00,'2022-08-22 14:23:54','',''),(7310,'21','222','1',1,'Retail Sale Id 6357',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 14:23:54','',''),(7311,'21','222','1',1,'Retail Sale Id 6358',1998.80,0.00,0.00,2.63,0.00,'2022-08-22 14:34:06','',''),(7312,'21','222','1',1,'Retail Sale Id 6359',6080.00,0.00,0.00,8.00,0.00,'2022-08-22 15:12:51','',''),(7313,'21','222','1',1,'Retail Sale Id 6360',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 15:16:16','',''),(7314,'21','222','1',1,'Retail Sale Id 6361',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 16:41:24','',''),(7315,'21','222','1',1,'Retail Sale Id 6362',1497.20,0.00,0.00,1.97,0.00,'2022-08-22 17:09:23','',''),(7316,'21','222','1',1,'Retail Sale Id 6363',1998.80,0.00,0.00,2.63,0.00,'2022-08-22 17:10:24','',''),(7317,'21','222','1',1,'Retail Sale Id 6364',7600.00,0.00,0.00,10.00,0.00,'2022-08-22 17:12:00','',''),(7318,'21','222','1',1,'Retail Sale Id 6365',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 17:15:23','',''),(7319,'21','222','1',1,'Retail Sale Id 6365',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 17:15:23','',''),(7320,'21','222','1',1,'Retail Sale Id 6366',3800.00,0.00,0.00,5.00,0.00,'2022-08-22 17:22:16','',''),(7321,'21','222','1',1,'Retail Sale Id 6367',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:40:26','',''),(7322,'21','222','1',1,'Retail Sale Id 6368',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:41:04','',''),(7323,'21','222','1',1,'Retail Sale Id 6369',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:41:30','',''),(7324,'21','222','1',1,'Retail Sale Id 6370',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:41:55','',''),(7325,'21','222','1',1,'Retail Sale Id 6371',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:42:21','',''),(7326,'21','222','1',1,'Retail Sale Id 6372',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:42:41','',''),(7327,'21','222','1',1,'Retail Sale Id 6373',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:43:07','',''),(7328,'21','222','1',1,'Retail Sale Id 6374',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:43:45','',''),(7329,'21','222','1',1,'Retail Sale Id 6375',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:44:12','',''),(7330,'21','222','1',1,'Retail Sale Id 6376',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:44:41','',''),(7331,'21','222','1',1,'Retail Sale Id 6377',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:45:14','',''),(7332,'21','222','1',1,'Retail Sale Id 6378',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:45:40','',''),(7333,'21','222','1',1,'Retail Sale Id 6379',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:46:05','',''),(7334,'21','222','1',1,'Retail Sale Id 6380',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:46:30','',''),(7335,'21','222','1',1,'Retail Sale Id 6381',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:46:56','',''),(7336,'21','222','1',1,'Retail Sale Id 6382',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:47:18','',''),(7337,'21','222','1',1,'Retail Sale Id 6383',9500.00,0.00,0.00,12.50,0.00,'2022-08-22 18:49:13','',''),(7338,'21','222','1',1,'Retail Sale Id 6383',38000.00,0.00,0.00,50.00,0.00,'2022-08-22 18:49:13','',''),(7339,'21','222','1',1,'Retail Sale Id 6384',3009.60,0.00,0.00,3.96,0.00,'2022-08-22 19:43:36','',''),(7340,'21','222','1',1,'Retail Sale Id 6385',9500.00,0.00,0.00,12.50,0.00,'2022-08-23 11:11:21','',''),(7341,'21','222','1',1,'Retail Sale Id 6386',9500.00,0.00,0.00,12.50,0.00,'2022-08-23 11:19:27','',''),(7342,'21','222','1',1,'Retail Sale Id 6387',9500.00,0.00,0.00,12.50,0.00,'2022-08-23 11:19:55','',''),(7343,'21','222','1',1,'Retail Sale Id 6388',4180.00,0.00,0.00,5.50,0.00,'2022-08-23 11:29:38','',''),(7344,'21','222','1',1,'Retail Sale Id 6388',9500.00,0.00,0.00,12.50,0.00,'2022-08-23 11:29:38','',''),(7345,'21','222','1',1,'Retail Sale Id 6388',9500.00,0.00,0.00,12.50,0.00,'2022-08-23 11:29:38','',''),(7346,'21','222','1',1,'Retail Sale Id 6389',3997.60,0.00,0.00,5.26,0.00,'2022-08-23 12:18:14','',''),(7347,'21','222','1',1,'Retail Sale Id 6390',1497.20,0.00,0.00,1.97,0.00,'2022-08-23 15:40:51','',''),(7348,'21','222','1',1,'Retail Sale Id 6391',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:18:30','',''),(7349,'21','222','1',1,'Retail Sale Id 6392',9500.00,0.00,0.00,12.50,0.00,'2022-08-23 16:22:22','',''),(7350,'21','222','1',1,'Retail Sale Id 6393',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:22:53','',''),(7351,'21','222','1',1,'Retail Sale Id 6394',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:25:00','',''),(7352,'21','222','1',1,'Retail Sale Id 6395',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:26:02','',''),(7353,'21','222','1',1,'Retail Sale Id 6396',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:44:54','',''),(7354,'21','222','1',1,'Retail Sale Id 6397',9500.00,0.00,0.00,12.50,0.00,'2022-08-23 16:45:24','',''),(7355,'21','222','1',1,'Retail Sale Id 6398',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:46:11','',''),(7356,'21','222','1',1,'Retail Sale Id 6399',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:49:04','',''),(7357,'21','222','1',1,'Retail Sale Id 6400',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:49:30','',''),(7358,'21','222','1',1,'Retail Sale Id 6401',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:50:11','',''),(7359,'21','222','1',1,'Retail Sale Id 6402',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:50:42','',''),(7360,'21','222','1',1,'Retail Sale Id 6403',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:51:17','',''),(7361,'21','222','1',1,'Retail Sale Id 6404',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:52:02','',''),(7362,'21','222','1',1,'Retail Sale Id 6405',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:52:47','',''),(7363,'21','222','1',1,'Retail Sale Id 6406',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:53:27','',''),(7364,'21','222','1',1,'Retail Sale Id 6407',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:53:47','',''),(7365,'21','222','1',1,'Retail Sale Id 6408',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:54:10','',''),(7366,'21','222','1',1,'Retail Sale Id 6409',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 16:55:34','',''),(7367,'21','222','1',1,'Retail Sale Id 6410',9500.00,0.00,0.00,12.50,0.00,'2022-08-23 17:23:19','',''),(7368,'21','222','1',1,'Return of Retail Sale Id 6409',0.00,38000.00,50.00,0.00,0.00,'2022-08-23 17:24:33','',''),(7369,'21','222','1',1,'Retail Sale Id 6411',5996.40,0.00,0.00,7.89,0.00,'2022-08-23 17:48:28','',''),(7370,'21','222','1',1,'Retail Sale Id 6412',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 20:31:06','',''),(7371,'21','222','1',1,'Retail Sale Id 6413',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 20:31:24','',''),(7372,'21','222','1',1,'Retail Sale Id 6414',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 20:31:46','',''),(7373,'21','222','1',1,'Retail Sale Id 6415',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 20:32:17','',''),(7374,'21','222','1',1,'Retail Sale Id 6416',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 20:33:12','',''),(7375,'21','222','1',1,'Retail Sale Id 6416',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 20:33:12','',''),(7376,'21','222','1',1,'Retail Sale Id 6417',38000.00,0.00,0.00,50.00,0.00,'2022-08-23 20:33:48','',''),(7377,'21','222','1',1,'Return of Retail Sale Id 6417',0.00,38000.00,50.00,0.00,0.00,'2022-08-23 20:34:15','',''),(7378,'21','222','1',1,'Retail Sale Id 6418',14652.80,0.00,0.00,19.28,0.00,'2022-08-23 20:35:17','',''),(7379,'21','222','1',1,'Return of Retail Sale Id 6415',0.00,38000.00,50.00,0.00,0.00,'2022-08-23 20:35:47','',''),(7380,'21','222','1',1,'Retail Sale Id 6419',8702.00,0.00,0.00,11.45,0.00,'2022-08-23 20:36:45','',''),(7381,'21','222','1',1,'Retail Sale Id 6420',9120.00,0.00,0.00,12.00,0.00,'2022-08-24 08:00:14','',''),(7382,'21','222','1',1,'Retail Sale Id 6421',7600.00,0.00,0.00,10.00,0.00,'2022-08-24 08:01:03','',''),(7383,'21','222','1',1,'Retail Sale Id 6422',15200.00,0.00,0.00,20.00,0.00,'2022-08-24 08:59:57','',''),(7384,'21','222','1',1,'Retail Sale Id 6423',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 09:02:41','',''),(7385,'21','222','1',1,'Retail Sale Id 6423',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 09:02:41','',''),(7386,'21','222','1',1,'Retail Sale Id 6424',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 11:15:26','',''),(7387,'21','222','1',1,'Retail Sale Id 6425',1998.80,0.00,0.00,2.63,0.00,'2022-08-24 11:50:58','',''),(7388,'21','222','1',1,'Retail Sale Id 6426',4560.00,0.00,0.00,6.00,0.00,'2022-08-24 12:12:21','',''),(7389,'21','222','1',1,'Retail Sale Id 6426',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 12:12:21','',''),(7390,'21','222','1',1,'Retail Sale Id 6427',1998.80,0.00,0.00,2.63,0.00,'2022-08-24 12:16:23','',''),(7391,'21','222','1',1,'Retail Sale Id 6428',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 13:03:24','',''),(7392,'21','222','1',1,'Retail Sale Id 6429',4560.00,0.00,0.00,6.00,0.00,'2022-08-24 15:44:53','',''),(7393,'21','222','1',1,'Retail Sale Id 6430',4560.00,0.00,0.00,6.00,0.00,'2022-08-24 16:04:57','',''),(7394,'21','222','1',1,'Retail Sale Id 6430',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 16:04:57','',''),(7395,'21','222','1',1,'Retail Sale Id 6431',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 16:05:58','',''),(7396,'21','222','1',1,'Retail Sale Id 6432',3997.60,0.00,0.00,5.26,0.00,'2022-08-24 16:35:31','',''),(7397,'21','222','1',1,'Retail Sale Id 6433',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 16:36:28','',''),(7398,'21','222','1',1,'Retail Sale Id 6434',4750.00,0.00,0.00,6.25,0.00,'2022-08-24 16:44:34','',''),(7399,'21','222','1',1,'Retail Sale Id 6435',3800.00,0.00,0.00,5.00,0.00,'2022-08-24 16:47:47','',''),(7400,'21','222','1',1,'Retail Sale Id 6436',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 17:02:48','',''),(7401,'21','222','1',1,'Retail Sale Id 6437',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:30:41','',''),(7402,'21','222','1',1,'Retail Sale Id 6438',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:31:00','',''),(7403,'21','222','1',1,'Retail Sale Id 6439',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:31:30','',''),(7404,'21','222','1',1,'Retail Sale Id 6440',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:37:08','',''),(7405,'21','222','1',1,'Retail Sale Id 6441',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:37:28','',''),(7406,'21','222','1',1,'Retail Sale Id 6442',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:37:59','',''),(7407,'21','222','1',1,'Retail Sale Id 6443',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:38:38','',''),(7408,'21','222','1',1,'Retail Sale Id 6444',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:47:11','',''),(7409,'21','222','1',1,'Retail Sale Id 6445',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:47:33','',''),(7410,'21','222','1',1,'Retail Sale Id 6446',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:48:03','',''),(7411,'21','222','1',1,'Retail Sale Id 6447',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:49:12','',''),(7412,'21','222','1',1,'Retail Sale Id 6448',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 17:50:49','',''),(7413,'21','222','1',1,'Retail Sale Id 6449',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 17:59:05','',''),(7414,'21','222','1',1,'Retail Sale Id 6450',5996.40,0.00,0.00,7.89,0.00,'2022-08-24 18:09:34','',''),(7415,'21','222','1',1,'Retail Sale Id 6451',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 18:47:04','',''),(7416,'21','222','1',1,'Retail Sale Id 6452',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 18:47:30','',''),(7417,'21','222','1',1,'Retail Sale Id 6454',9500.00,0.00,0.00,12.50,0.00,'2022-08-24 18:55:13','',''),(7418,'21','222','1',1,'Retail Sale Id 6455',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 19:48:34','',''),(7419,'21','222','1',1,'Retail Sale Id 6456',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 19:48:52','',''),(7420,'21','222','1',1,'Retail Sale Id 6457',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 19:49:09','',''),(7421,'21','222','1',1,'Retail Sale Id 6458',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 19:49:35','',''),(7422,'21','222','1',1,'Retail Sale Id 6459',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 19:50:37','',''),(7423,'21','222','1',1,'Retail Sale Id 6460',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 19:51:29','',''),(7424,'21','222','1',1,'Retail Sale Id 6461',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 19:51:52','',''),(7425,'21','222','1',1,'Retail Sale Id 6462',38000.00,0.00,0.00,50.00,0.00,'2022-08-24 19:52:17','',''),(7426,'21','222','1',1,'Retail Sale Id 6463',2523.20,0.00,0.00,3.32,0.00,'2022-08-24 19:53:15','',''),(7427,'21','222','1',1,'Retail Sale Id 6464',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 09:23:03','',''),(7428,'21','222','1',1,'Retail Sale Id 6465',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 09:29:18','',''),(7429,'21','222','1',1,'Retail Sale Id 6466',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 10:17:14','',''),(7430,'21','222','1',1,'Retail Sale Id 6467',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 10:18:00','',''),(7431,'21','222','1',1,'Retail Sale Id 6467',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 10:18:00','',''),(7432,'21','222','1',1,'Retail Sale Id 6468',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 10:18:43','',''),(7433,'21','222','1',1,'Retail Sale Id 6469',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 12:22:18','',''),(7434,'21','222','1',1,'Retail Sale Id 6470',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 13:44:26','',''),(7435,'21','222','1',1,'Retail Sale Id 6471',3997.60,0.00,0.00,5.26,0.00,'2022-08-25 15:14:59','',''),(7436,'21','222','1',1,'Retail Sale Id 6472',1998.80,0.00,0.00,2.63,0.00,'2022-08-25 15:20:55','',''),(7437,'21','222','1',1,'Retail Sale Id 6473',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 15:36:16','',''),(7438,'21','222','1',1,'Retail Sale Id 6474',8002.80,0.00,0.00,10.53,0.00,'2022-08-25 15:37:00','',''),(7439,'21','222','1',1,'Retail Sale Id 6475',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 15:37:38','',''),(7440,'21','222','1',1,'Retail Sale Id 6476',2280.00,0.00,0.00,3.00,0.00,'2022-08-25 15:38:27','',''),(7441,'21','222','1',1,'Retail Sale Id 6477',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 15:39:33','',''),(7442,'21','222','1',1,'Retail Sale Id 6478',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 15:46:39','',''),(7443,'21','222','1',1,'Retail Sale Id 6479',3040.00,0.00,0.00,4.00,0.00,'2022-08-25 15:58:02','',''),(7444,'21','222','1',1,'Retail Sale Id 6480',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 16:10:52','',''),(7445,'21','222','1',1,'Retail Sale Id 6481',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 16:19:56','',''),(7446,'21','222','1',1,'Retail Sale Id 6482',2280.00,0.00,0.00,3.00,0.00,'2022-08-25 16:22:00','',''),(7447,'21','222','1',1,'Retail Sale Id 6482',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 16:22:00','',''),(7448,'21','222','1',1,'Retail Sale Id 6483',3002.00,0.00,0.00,3.95,0.00,'2022-08-25 16:22:53','',''),(7449,'21','222','1',1,'Retail Sale Id 6484',1998.80,0.00,0.00,2.63,0.00,'2022-08-25 16:23:38','',''),(7450,'21','222','1',1,'Retail Sale Id 6485',4499.20,0.00,0.00,5.92,0.00,'2022-08-25 16:24:34','',''),(7451,'21','222','1',1,'Retail Sale Id 6486',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 17:21:22','',''),(7452,'21','222','1',1,'Retail Sale Id 6486',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:21:22','',''),(7453,'21','222','1',1,'Retail Sale Id 6487',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:21:58','',''),(7454,'21','222','1',1,'Retail Sale Id 6488',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 17:22:57','',''),(7455,'21','222','1',1,'Retail Sale Id 6489',7600.00,0.00,0.00,10.00,0.00,'2022-08-25 17:24:00','',''),(7456,'21','222','1',1,'Retail Sale Id 6490',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:24:26','',''),(7457,'21','222','1',1,'Retail Sale Id 6491',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 17:25:13','',''),(7458,'21','222','1',1,'Retail Sale Id 6492',2280.00,0.00,0.00,3.00,0.00,'2022-08-25 17:25:53','',''),(7459,'21','222','1',1,'Retail Sale Id 6492',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:25:53','',''),(7460,'21','222','1',1,'Retail Sale Id 6493',6080.00,0.00,0.00,8.00,0.00,'2022-08-25 17:26:41','',''),(7461,'21','222','1',1,'Retail Sale Id 6494',19000.00,0.00,0.00,25.00,0.00,'2022-08-25 17:27:23','',''),(7462,'21','222','1',1,'Retail Sale Id 6495',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:27:48','',''),(7463,'21','222','1',1,'Retail Sale Id 6496',6840.00,0.00,0.00,9.00,0.00,'2022-08-25 17:28:15','',''),(7464,'21','222','1',1,'Retail Sale Id 6497',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:28:41','',''),(7465,'21','222','1',1,'Retail Sale Id 6498',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:29:04','',''),(7466,'21','222','1',1,'Retail Sale Id 6499',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:29:27','',''),(7467,'21','222','1',1,'Retail Sale Id 6500',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:30:06','',''),(7468,'21','222','1',1,'Retail Sale Id 6500',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:30:06','',''),(7469,'21','222','1',1,'Retail Sale Id 6501',2280.00,0.00,0.00,3.00,0.00,'2022-08-25 17:30:36','',''),(7470,'21','222','1',1,'Retail Sale Id 6502',2280.00,0.00,0.00,3.00,0.00,'2022-08-25 17:31:05','',''),(7471,'21','222','1',1,'Retail Sale Id 6503',3800.00,0.00,0.00,5.00,0.00,'2022-08-25 17:31:50','',''),(7472,'21','222','1',1,'Retail Sale Id 6503',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 17:31:50','',''),(7473,'21','222','1',1,'Retail Sale Id 6504',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 17:35:47','',''),(7474,'21','222','1',1,'Retail Sale Id 6504',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:35:47','',''),(7475,'21','222','1',1,'Retail Sale Id 6505',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:51:29','',''),(7476,'21','222','1',1,'Retail Sale Id 6506',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:51:50','',''),(7477,'21','222','1',1,'Retail Sale Id 6507',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 17:52:40','',''),(7478,'21','222','1',1,'Retail Sale Id 6507',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:52:40','',''),(7479,'21','222','1',1,'Retail Sale Id 6507',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:52:40','',''),(7480,'21','222','1',1,'Retail Sale Id 6508',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:53:19','',''),(7481,'21','222','1',1,'Retail Sale Id 6509',11400.00,0.00,0.00,15.00,0.00,'2022-08-25 17:53:50','',''),(7482,'21','222','1',1,'Retail Sale Id 6510',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 17:54:41','',''),(7483,'21','222','1',1,'Retail Sale Id 6510',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:54:41','',''),(7484,'21','222','1',1,'Retail Sale Id 6511',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:57:11','',''),(7485,'21','222','1',1,'Retail Sale Id 6512',7600.00,0.00,0.00,10.00,0.00,'2022-08-25 17:58:36','',''),(7486,'21','222','1',1,'Retail Sale Id 6513',8360.00,0.00,0.00,11.00,0.00,'2022-08-25 17:59:18','',''),(7487,'21','222','1',1,'Retail Sale Id 6513',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 17:59:18','',''),(7488,'21','222','1',1,'Retail Sale Id 6514',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 18:16:53','',''),(7489,'21','222','1',1,'Retail Sale Id 6515',3040.00,0.00,0.00,4.00,0.00,'2022-08-25 18:32:38','',''),(7490,'21','222','1',1,'Retail Sale Id 6515',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 18:32:38','',''),(7491,'21','222','1',1,'Retail Sale Id 6516',760.00,0.00,0.00,1.00,0.00,'2022-08-25 18:33:58','',''),(7492,'21','222','1',1,'Retail Sale Id 6517',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 18:35:49','',''),(7493,'21','222','1',1,'Retail Sale Id 6518',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 18:36:25','',''),(7494,'21','222','1',1,'Retail Sale Id 6519',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 18:37:11','',''),(7495,'21','222','1',1,'Retail Sale Id 6519',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 18:37:11','',''),(7496,'21','222','1',1,'Retail Sale Id 6520',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 18:38:08','',''),(7497,'21','222','1',1,'Retail Sale Id 6521',30400.00,0.00,0.00,40.00,0.00,'2022-08-25 18:38:43','',''),(7498,'21','222','1',1,'Retail Sale Id 6522',4560.00,0.00,0.00,6.00,0.00,'2022-08-25 18:39:31','',''),(7499,'21','222','1',1,'Retail Sale Id 6522',7600.00,0.00,0.00,10.00,0.00,'2022-08-25 18:39:31','',''),(7500,'21','222','1',1,'Retail Sale Id 6522',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 18:39:31','',''),(7501,'21','222','1',1,'Retail Sale Id 6523',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 18:40:09','',''),(7502,'21','222','1',1,'Retail Sale Id 6523',19000.00,0.00,0.00,25.00,0.00,'2022-08-25 18:40:09','',''),(7503,'21','222','1',1,'Retail Sale Id 6524',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 18:40:37','',''),(7504,'21','222','1',1,'Retail Sale Id 6525',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 18:41:14','',''),(7505,'21','222','1',1,'Retail Sale Id 6526',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 18:41:41','',''),(7506,'21','222','1',1,'Retail Sale Id 6527',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 19:14:18','',''),(7507,'21','222','1',1,'Retail Sale Id 6527',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 19:14:18','',''),(7508,'21','222','1',1,'Retail Sale Id 6528',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 19:14:49','',''),(7509,'21','222','1',1,'Retail Sale Id 6529',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 19:15:21','',''),(7510,'21','222','1',1,'Retail Sale Id 6529',38000.00,0.00,0.00,50.00,0.00,'2022-08-25 19:15:21','',''),(7511,'21','222','1',1,'Retail Sale Id 6532',9500.00,0.00,0.00,12.50,0.00,'2022-08-25 19:16:48','',''),(7512,'21','222','1',1,'Retail Sale Id 6532',19000.00,0.00,0.00,25.00,0.00,'2022-08-25 19:16:48','',''),(7513,'21','222','1',1,'Retail Sale Id 6533',7600.00,0.00,0.00,10.00,0.00,'2022-08-25 19:17:51','',''),(7514,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-08-26 19:57:26','',''),(7515,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3800000.00,5000.00,0.00,0.00,'2022-08-26 20:04:53','',''),(7516,'21','222',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,4999.00,0.00,'2022-08-26 20:06:21','',''),(7517,'21','222','1',1,'Received from bridging 52',0.00,0.00,4999.00,0.00,0.00,'2022-08-26 20:06:21','',''),(7518,'21','222','1',1,'Retail Sale Id 6535',19000.00,0.00,0.00,25.00,0.00,'2022-08-26 20:12:13','',''),(7519,'21','222','1',1,'Retail Sale Id 6536',9500.00,0.00,0.00,12.50,0.00,'2022-08-26 20:12:49','',''),(7520,'21','222','1',1,'Retail Sale Id 6537',105997.20,0.00,0.00,139.47,0.00,'2022-08-26 20:13:30','',''),(7521,'21','222','1',1,'Retail Sale Id 6541',9500.00,0.00,0.00,12.50,0.00,'2022-08-26 20:15:21','',''),(7522,'21','222','1',1,'Retail Sale Id 6542',9500.00,0.00,0.00,12.50,0.00,'2022-08-26 20:16:42','',''),(7523,'21','222','1',1,'Retail Sale Id 6543',7600.00,0.00,0.00,10.00,0.00,'2022-08-26 20:17:36','',''),(7524,'21','222','1',1,'Retail Sale Id 6544',11400.00,0.00,0.00,15.00,0.00,'2022-08-26 20:19:17','',''),(7525,'21','222','1',1,'Retail Sale Id 6545',38000.00,0.00,0.00,50.00,0.00,'2022-08-26 20:20:56','',''),(7526,'21','222','1',1,'Retail Sale Id 6546',19000.00,0.00,0.00,25.00,0.00,'2022-08-26 20:21:47','',''),(7527,'21','222','1',1,'Retail Sale Id 6547',34960.00,0.00,0.00,46.00,0.00,'2022-08-26 20:25:50','',''),(7528,'21','222','1',1,'Retail Sale Id 6548',60898.80,0.00,0.00,80.13,0.00,'2022-08-26 20:26:51','',''),(7529,'21','222','1',1,'Retail Sale Id 6549',38000.00,0.00,0.00,50.00,0.00,'2022-08-26 20:27:31','',''),(7530,'21','222','1',1,'Retail Sale Id 6550',38000.00,0.00,0.00,50.00,0.00,'2022-08-26 20:28:45','',''),(7531,'21','222','1',1,'Retail Sale Id 6551',9500.00,0.00,0.00,12.50,0.00,'2022-08-26 20:30:03','',''),(7532,'21','222','1',1,'Retail Sale Id 6552',38000.00,0.00,0.00,50.00,0.00,'2022-08-26 20:31:19','',''),(7533,'21','222','1',1,'Retail Sale Id 6553',84702.00,0.00,0.00,111.45,0.00,'2022-08-26 20:32:31','',''),(7534,'21','222','1',1,'Retail Sale Id 6554',38000.00,0.00,0.00,50.00,0.00,'2022-08-26 20:34:09','',''),(7535,'21','222','1',1,'Retail Sale Id 6555',9500.00,0.00,0.00,12.50,0.00,'2022-08-26 20:35:10','',''),(7536,'21','222','1',1,'Retail Sale Id 6556',40280.00,0.00,0.00,53.00,0.00,'2022-08-26 20:37:57','',''),(7537,'21','222','1',1,'Retail Sale Id 6557',38000.00,0.00,0.00,50.00,0.00,'2022-08-26 20:39:21','',''),(7538,'21','222','1',1,'Retail Sale Id 6558',83896.40,0.00,0.00,110.39,0.00,'2022-08-26 20:40:46','',''),(7539,'21','222','1',1,'Retail Sale Id 6559',38000.00,0.00,0.00,50.00,0.00,'2022-08-26 20:42:34','',''),(7540,'21','222','1',1,'Retail Sale Id 6560',19000.00,0.00,0.00,25.00,0.00,'2022-08-26 20:44:44','',''),(7541,'21','222','1',1,'Retail Sale Id 6561',19000.00,0.00,0.00,25.00,0.00,'2022-08-26 20:46:19','',''),(7542,'21','222','1',1,'Retail Sale Id 6562',12372.80,0.00,0.00,16.28,0.00,'2022-08-26 20:48:57','',''),(7543,'21','222','1',1,'Retail Sale Id 6563',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 09:05:02','',''),(7544,'21','222','1',1,'Retail Sale Id 6564',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 09:05:43','',''),(7545,'21','222','1',1,'Retail Sale Id 6565',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 09:06:22','',''),(7546,'21','222','1',1,'Retail Sale Id 6566',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:06:50','',''),(7547,'21','222','1',1,'Retail Sale Id 6567',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:08:11','',''),(7548,'21','222','1',1,'Retail Sale Id 6567',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:08:11','',''),(7549,'21','222','1',1,'Retail Sale Id 6567',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:08:11','',''),(7550,'21','222','1',1,'Retail Sale Id 6568',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 09:09:47','',''),(7551,'21','222','1',1,'Retail Sale Id 6569',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 09:10:30','',''),(7552,'21','222','1',1,'Retail Sale Id 6569',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:10:30','',''),(7553,'21','222','1',1,'Retail Sale Id 6570',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 09:18:35','',''),(7554,'21','222','1',1,'Retail Sale Id 6571',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 09:23:46','',''),(7555,'21','222','1',1,'Retail Sale Id 6572',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:24:28','',''),(7556,'21','222','1',1,'Retail Sale Id 6573',3002.00,0.00,0.00,3.95,0.00,'2022-08-27 09:26:09','',''),(7557,'21','222','1',1,'Retail Sale Id 6574',1520.00,0.00,0.00,2.00,0.00,'2022-08-27 09:26:57','',''),(7558,'21','222','1',1,'Retail Sale Id 6575',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:28:38','',''),(7559,'21','222','1',1,'Retail Sale Id 6576',8496.80,0.00,0.00,11.18,0.00,'2022-08-27 09:35:57','',''),(7560,'21','222','1',1,'Retail Sale Id 6577',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 09:37:33','',''),(7561,'21','222','1',1,'Retail Sale Id 6577',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:37:33','',''),(7562,'21','222','1',1,'Retail Sale Id 6578',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 09:40:55','',''),(7563,'21','222','1',1,'Retail Sale Id 6579',760.00,0.00,0.00,1.00,0.00,'2022-08-27 09:46:49','',''),(7564,'21','222','1',1,'Retail Sale Id 6579',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:46:49','',''),(7565,'21','222','1',1,'Retail Sale Id 6580',2500.40,0.00,0.00,3.29,0.00,'2022-08-27 09:51:13','',''),(7566,'21','222','1',1,'Retail Sale Id 6581',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 09:53:04','',''),(7567,'21','222','1',1,'Retail Sale Id 6582',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 09:54:09','',''),(7568,'21','222','1',1,'Retail Sale Id 6583',3800.00,0.00,0.00,5.00,0.00,'2022-08-27 09:55:58','',''),(7569,'21','222','1',1,'Retail Sale Id 6584',3002.00,0.00,0.00,3.95,0.00,'2022-08-27 09:58:17','',''),(7570,'21','222','1',1,'Retail Sale Id 6585',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:00:52','',''),(7571,'21','222','1',1,'Retail Sale Id 6586',3800.00,0.00,0.00,5.00,0.00,'2022-08-27 10:03:10','',''),(7572,'21','222','1',1,'Retail Sale Id 6587',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 10:08:13','',''),(7573,'21','222','1',1,'Retail Sale Id 6588',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:09:24','',''),(7574,'21','222','1',1,'Retail Sale Id 6589',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:09:48','',''),(7575,'21','222','1',1,'Retail Sale Id 6590',8998.40,0.00,0.00,11.84,0.00,'2022-08-27 10:10:27','',''),(7576,'21','222','1',1,'Retail Sale Id 6591',8002.80,0.00,0.00,10.53,0.00,'2022-08-27 10:10:52','',''),(7577,'21','222','1',1,'Retail Sale Id 6592',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:11:41','',''),(7578,'21','222','1',1,'Retail Sale Id 6593',3040.00,0.00,0.00,4.00,0.00,'2022-08-27 10:12:28','',''),(7579,'21','222','1',1,'Retail Sale Id 6594',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:12:54','',''),(7580,'21','222','1',1,'Retail Sale Id 6595',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 10:13:54','',''),(7581,'21','222','1',1,'Retail Sale Id 6596',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:15:22','',''),(7582,'21','222','1',1,'Retail Sale Id 6597',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:17:59','',''),(7583,'21','222','1',1,'Retail Sale Id 6597',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:17:59','',''),(7584,'21','222','1',1,'Retail Sale Id 6598',3040.00,0.00,0.00,4.00,0.00,'2022-08-27 10:22:03','',''),(7585,'21','222','1',1,'Retail Sale Id 6599',8998.40,0.00,0.00,11.84,0.00,'2022-08-27 10:23:44','',''),(7586,'21','222','1',1,'Retail Sale Id 6600',5000.80,0.00,0.00,6.58,0.00,'2022-08-27 10:27:26','',''),(7587,'21','222','1',1,'Retail Sale Id 6601',1497.20,0.00,0.00,1.97,0.00,'2022-08-27 10:29:38','',''),(7588,'21','222','1',1,'Retail Sale Id 6602',1998.80,0.00,0.00,2.63,0.00,'2022-08-27 10:31:13','',''),(7589,'21','222','1',1,'Retail Sale Id 6603',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:37:52','',''),(7590,'21','222','1',1,'Retail Sale Id 6604',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 10:38:58','',''),(7591,'21','222','1',1,'Retail Sale Id 6604',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:38:58','',''),(7592,'21','222','1',1,'Retail Sale Id 6605',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 10:39:29','',''),(7593,'21','222','1',1,'Retail Sale Id 6606',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:41:27','',''),(7594,'21','222','1',1,'Retail Sale Id 6607',1998.80,0.00,0.00,2.63,0.00,'2022-08-27 10:43:07','',''),(7595,'21','222','1',1,'Retail Sale Id 6608',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:44:08','',''),(7596,'21','222','1',1,'Retail Sale Id 6609',3997.60,0.00,0.00,5.26,0.00,'2022-08-27 10:45:30','',''),(7597,'21','222','1',1,'Retail Sale Id 6610',5000.80,0.00,0.00,6.58,0.00,'2022-08-27 10:46:17','',''),(7598,'21','222','1',1,'Retail Sale Id 6611',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 10:47:27','',''),(7599,'21','222','1',1,'Retail Sale Id 6612',1998.80,0.00,0.00,2.63,0.00,'2022-08-27 12:04:10','',''),(7600,'21','222','1',1,'Retail Sale Id 6613',28500.00,0.00,0.00,37.50,0.00,'2022-08-27 12:09:44','',''),(7601,'21','222','1',1,'Retail Sale Id 6614',3800.00,0.00,0.00,5.00,0.00,'2022-08-27 12:11:16','',''),(7602,'21','222','1',1,'Retail Sale Id 6615',3800.00,0.00,0.00,5.00,0.00,'2022-08-27 12:14:19','',''),(7603,'21','222','1',1,'Retail Sale Id 6616',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 12:15:33','',''),(7604,'21','222','1',1,'Retail Sale Id 6617',5502.40,0.00,0.00,7.24,0.00,'2022-08-27 12:17:57','',''),(7605,'21','222','1',1,'Retail Sale Id 6618',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 12:19:21','',''),(7606,'21','222','1',1,'Retail Sale Id 6619',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 12:20:29','',''),(7607,'21','222','1',1,'Retail Sale Id 6620',3040.00,0.00,0.00,4.00,0.00,'2022-08-27 12:23:05','',''),(7608,'21','222','1',1,'Retail Sale Id 6621',760.00,0.00,0.00,1.00,0.00,'2022-08-27 12:24:57','',''),(7609,'21','222','1',1,'Retail Sale Id 6622',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 12:27:28','',''),(7610,'21','222','1',1,'Retail Sale Id 6623',3800.00,0.00,0.00,5.00,0.00,'2022-08-27 12:29:05','',''),(7611,'21','222','1',1,'Retail Sale Id 6625',1520.00,0.00,0.00,2.00,0.00,'2022-08-27 12:30:24','',''),(7612,'21','222','1',1,'Retail Sale Id 6626',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 13:22:04','',''),(7613,'21','222','1',1,'Retail Sale Id 6627',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 13:22:53','',''),(7614,'21','222','1',1,'Retail Sale Id 6628',5000.80,0.00,0.00,6.58,0.00,'2022-08-27 13:33:42','',''),(7615,'21','222','1',1,'Retail Sale Id 6629',19000.00,0.00,0.00,25.00,0.00,'2022-08-27 13:45:49','',''),(7616,'21','222','1',1,'Retail Sale Id 6630',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 13:54:27','',''),(7617,'21','222','1',1,'Retail Sale Id 6631',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 13:55:35','',''),(7618,'21','222','1',1,'Retail Sale Id 6632',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 13:57:35','',''),(7619,'21','222','1',1,'Retail Sale Id 6633',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 13:58:48','',''),(7620,'21','222','1',1,'Retail Sale Id 6634',5996.40,0.00,0.00,7.89,0.00,'2022-08-27 14:01:19','',''),(7621,'21','222','1',1,'Retail Sale Id 6635',3997.60,0.00,0.00,5.26,0.00,'2022-08-27 14:02:37','',''),(7622,'21','222','1',1,'Retail Sale Id 6636',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 14:04:58','',''),(7623,'21','222','1',1,'Retail Sale Id 6637',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 14:21:01','',''),(7624,'21','222','1',1,'Retail Sale Id 6638',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 15:53:23','',''),(7625,'21','222','1',1,'Retail Sale Id 6639',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 15:54:32','',''),(7626,'21','222','1',1,'Retail Sale Id 6640',19000.00,0.00,0.00,25.00,0.00,'2022-08-27 16:04:12','',''),(7627,'21','222','1',1,'Retail Sale Id 6641',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 16:43:38','',''),(7628,'21','222','1',1,'Retail Sale Id 6642',19000.00,0.00,0.00,25.00,0.00,'2022-08-27 16:52:38','',''),(7629,'21','222','1',1,'Retail Sale Id 6643',11400.00,0.00,0.00,15.00,0.00,'2022-08-27 16:53:38','',''),(7630,'21','222','1',1,'Retail Sale Id 6644',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 17:05:39','',''),(7631,'21','222','1',1,'Retail Sale Id 6645',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:11:11','',''),(7632,'21','222','1',1,'Retail Sale Id 6646',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 17:11:50','',''),(7633,'21','222','1',1,'Retail Sale Id 6647',3040.00,0.00,0.00,4.00,0.00,'2022-08-27 17:13:06','',''),(7634,'21','222','1',1,'Retail Sale Id 6648',19000.00,0.00,0.00,25.00,0.00,'2022-08-27 17:13:50','',''),(7635,'21','222','1',1,'Retail Sale Id 6649',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:14:40','',''),(7636,'21','222','1',1,'Retail Sale Id 6650',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 17:17:23','',''),(7637,'21','222','1',1,'Retail Sale Id 6651',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:18:16','',''),(7638,'21','222','1',1,'Retail Sale Id 6652',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 17:20:19','',''),(7639,'21','222','1',1,'Retail Sale Id 6653',6840.00,0.00,0.00,9.00,0.00,'2022-08-27 17:21:55','',''),(7640,'21','222','1',1,'Retail Sale Id 6654',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:23:05','',''),(7641,'21','222','1',1,'Retail Sale Id 6655',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 17:24:15','',''),(7642,'21','222','1',1,'Retail Sale Id 6656',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:28:04','',''),(7643,'21','222','1',1,'Retail Sale Id 6657',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:33:32','',''),(7644,'21','222','1',1,'Retail Sale Id 6658',760.00,0.00,0.00,1.00,0.00,'2022-08-27 17:35:01','',''),(7645,'21','222','1',1,'Retail Sale Id 6659',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:36:33','',''),(7646,'21','222','1',1,'Retail Sale Id 6660',1998.80,0.00,0.00,2.63,0.00,'2022-08-27 17:40:06','',''),(7647,'21','222','1',1,'Retail Sale Id 6661',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 17:40:48','',''),(7648,'21','222','1',1,'Retail Sale Id 6662',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:41:26','',''),(7649,'21','222','1',1,'Retail Sale Id 6662',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:41:26','',''),(7650,'21','222','1',1,'Retail Sale Id 6663',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 17:47:52','',''),(7651,'21','222','1',1,'Retail Sale Id 6664',19000.00,0.00,0.00,25.00,0.00,'2022-08-27 17:51:25','',''),(7652,'21','222','1',1,'Retail Sale Id 6665',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 17:52:17','',''),(7653,'21','222','1',1,'Retail Sale Id 6666',12000.40,0.00,0.00,15.79,0.00,'2022-08-27 18:00:46','',''),(7654,'21','222','1',1,'Retail Sale Id 6668',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:03:30','',''),(7655,'21','222','1',1,'Retail Sale Id 6669',5099.60,0.00,0.00,6.71,0.00,'2022-08-27 18:04:38','',''),(7656,'21','222','1',1,'Retail Sale Id 6670',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:06:43','',''),(7657,'21','222','1',1,'Retail Sale Id 6671',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 18:08:29','',''),(7658,'21','222','1',1,'Retail Sale Id 6671',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 18:08:29','',''),(7659,'21','222','1',1,'Retail Sale Id 6672',1497.20,0.00,0.00,1.97,0.00,'2022-08-27 18:09:08','',''),(7660,'21','222','1',1,'Retail Sale Id 6673',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:10:12','',''),(7661,'21','222','1',1,'Retail Sale Id 6674',5000.80,0.00,0.00,6.58,0.00,'2022-08-27 18:12:21','',''),(7662,'21','222','1',1,'Retail Sale Id 6675',2500.40,0.00,0.00,3.29,0.00,'2022-08-27 18:15:41','',''),(7663,'21','222','1',1,'Retail Sale Id 6676',19000.00,0.00,0.00,25.00,0.00,'2022-08-27 18:17:28','',''),(7664,'21','222','1',1,'Retail Sale Id 6676',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 18:17:28','',''),(7665,'21','222','1',1,'Retail Sale Id 6677',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 18:18:02','',''),(7666,'21','222','1',1,'Retail Sale Id 6677',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:18:02','',''),(7667,'21','222','1',1,'Retail Sale Id 6678',1520.00,0.00,0.00,2.00,0.00,'2022-08-27 18:20:07','',''),(7668,'21','222','1',1,'Retail Sale Id 6679',8998.40,0.00,0.00,11.84,0.00,'2022-08-27 18:22:14','',''),(7669,'21','222','1',1,'Retail Sale Id 6680',8360.00,0.00,0.00,11.00,0.00,'2022-08-27 18:24:28','',''),(7670,'21','222','1',1,'Retail Sale Id 6681',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 18:25:38','',''),(7671,'21','222','1',1,'Retail Sale Id 6681',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:25:38','',''),(7672,'21','222','1',1,'Retail Sale Id 6682',4750.00,0.00,0.00,6.25,0.00,'2022-08-27 18:28:48','',''),(7673,'21','222','1',1,'Retail Sale Id 6683',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:29:55','',''),(7674,'21','222','1',1,'Retail Sale Id 6684',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:31:54','',''),(7675,'21','222','1',1,'Retail Sale Id 6685',3800.00,0.00,0.00,5.00,0.00,'2022-08-27 18:33:48','',''),(7676,'21','222','1',1,'Retail Sale Id 6686',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:40:18','',''),(7677,'21','222','1',1,'Retail Sale Id 6687',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:41:56','',''),(7678,'21','222','1',1,'Retail Sale Id 6688',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 18:42:31','',''),(7679,'21','222','1',1,'Retail Sale Id 6688',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 18:42:31','',''),(7680,'21','222','1',1,'Retail Sale Id 6690',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:43:33','',''),(7681,'21','222','1',1,'Retail Sale Id 6690',11400.00,0.00,0.00,15.00,0.00,'2022-08-27 18:43:33','',''),(7682,'21','222','1',1,'Retail Sale Id 6691',3002.00,0.00,0.00,3.95,0.00,'2022-08-27 18:44:27','',''),(7683,'21','222','1',1,'Retail Sale Id 6692',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:45:37','',''),(7684,'21','222','1',1,'Retail Sale Id 6693',3997.60,0.00,0.00,5.26,0.00,'2022-08-27 18:47:06','',''),(7685,'21','222','1',1,'Retail Sale Id 6694',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:48:23','',''),(7686,'21','222','1',1,'Retail Sale Id 6695',3800.00,0.00,0.00,5.00,0.00,'2022-08-27 18:50:51','',''),(7687,'21','222','1',1,'Retail Sale Id 6695',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:50:51','',''),(7688,'21','222','1',1,'Retail Sale Id 6696',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 18:57:06','',''),(7689,'21','222','1',1,'Retail Sale Id 6697',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 18:57:32','',''),(7690,'21','222','1',1,'Retail Sale Id 6698',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 18:58:07','',''),(7691,'21','222','1',1,'Retail Sale Id 6699',4750.00,0.00,0.00,6.25,0.00,'2022-08-27 18:59:13','',''),(7692,'21','222','1',1,'Retail Sale Id 6701',8998.40,0.00,0.00,11.84,0.00,'2022-08-27 19:00:09','',''),(7693,'21','222','1',1,'Retail Sale Id 6702',5320.00,0.00,0.00,7.00,0.00,'2022-08-27 19:00:38','',''),(7694,'21','222','1',1,'Retail Sale Id 6703',4750.00,0.00,0.00,6.25,0.00,'2022-08-27 19:02:54','',''),(7695,'21','222','1',1,'Retail Sale Id 6704',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:03:36','',''),(7696,'21','222','1',1,'Retail Sale Id 6705',5000.80,0.00,0.00,6.58,0.00,'2022-08-27 19:05:12','',''),(7697,'21','222','1',1,'Retail Sale Id 6706',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:06:31','',''),(7698,'21','222','1',1,'Retail Sale Id 6707',8360.00,0.00,0.00,11.00,0.00,'2022-08-27 19:07:04','',''),(7699,'21','222','1',1,'Retail Sale Id 6708',3040.00,0.00,0.00,4.00,0.00,'2022-08-27 19:07:40','',''),(7700,'21','222','1',1,'Retail Sale Id 6709',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 19:08:44','',''),(7701,'21','222','1',1,'Retail Sale Id 6709',6080.00,0.00,0.00,8.00,0.00,'2022-08-27 19:08:44','',''),(7702,'21','222','1',1,'Retail Sale Id 6710',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 19:09:30','',''),(7703,'21','222','1',1,'Retail Sale Id 6711',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:10:53','',''),(7704,'21','222','1',1,'Retail Sale Id 6712',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:11:23','',''),(7705,'21','222','1',1,'Retail Sale Id 6713',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:11:52','',''),(7706,'21','222','1',1,'Retail Sale Id 6714',8998.40,0.00,0.00,11.84,0.00,'2022-08-27 19:12:49','',''),(7707,'21','222','1',1,'Retail Sale Id 6715',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 19:13:36','',''),(7708,'21','222','1',1,'Retail Sale Id 6716',38000.00,0.00,0.00,50.00,0.00,'2022-08-27 19:14:19','',''),(7709,'21','222','1',1,'Retail Sale Id 6717',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:16:04','',''),(7710,'21','222','1',1,'Retail Sale Id 6717',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:16:04','',''),(7711,'21','222','1',1,'Retail Sale Id 6718',8002.80,0.00,0.00,10.53,0.00,'2022-08-27 19:16:38','',''),(7712,'21','222','1',1,'Retail Sale Id 6719',11400.00,0.00,0.00,15.00,0.00,'2022-08-27 19:17:16','',''),(7713,'21','222','1',1,'Retail Sale Id 6720',2280.00,0.00,0.00,3.00,0.00,'2022-08-27 19:17:51','',''),(7714,'21','222','1',1,'Retail Sale Id 6721',4560.00,0.00,0.00,6.00,0.00,'2022-08-27 19:18:14','',''),(7715,'21','222','1',1,'Retail Sale Id 6722',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:18:37','',''),(7716,'21','222','1',1,'Retail Sale Id 6723',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:19:14','',''),(7717,'21','222','1',1,'Retail Sale Id 6724',5996.40,0.00,0.00,7.89,0.00,'2022-08-27 19:19:52','',''),(7718,'21','222','1',1,'Retail Sale Id 6725',7600.00,0.00,0.00,10.00,0.00,'2022-08-27 19:20:44','',''),(7719,'21','222','1',1,'Retail Sale Id 6725',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:20:44','',''),(7720,'21','222','1',1,'Retail Sale Id 6726',9500.00,0.00,0.00,12.50,0.00,'2022-08-27 19:24:16','',''),(7721,'21','222','1',1,'Retail Sale Id 6727',1390.80,0.00,0.00,1.83,0.00,'2022-08-27 19:25:28','',''),(7722,'21','222','1',1,'Retail Sale Id 6728',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 09:55:14','',''),(7723,'21','222','1',1,'Retail Sale Id 6729',1003.20,0.00,0.00,1.32,0.00,'2022-08-28 09:55:37','',''),(7724,'21','222','1',1,'Retail Sale Id 6730',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 09:56:46','',''),(7725,'21','222','1',1,'Retail Sale Id 6731',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 09:57:43','',''),(7726,'21','222','1',1,'Retail Sale Id 6732',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 09:59:21','',''),(7727,'21','222','1',1,'Retail Sale Id 6733',3002.00,0.00,0.00,3.95,0.00,'2022-08-28 10:00:16','',''),(7728,'21','222','1',1,'Retail Sale Id 6734',1998.80,0.00,0.00,2.63,0.00,'2022-08-28 10:02:17','',''),(7729,'21','222','1',1,'Retail Sale Id 6735',8360.00,0.00,0.00,11.00,0.00,'2022-08-28 10:03:03','',''),(7730,'21','222','1',1,'Retail Sale Id 6736',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 10:05:23','',''),(7731,'21','222','1',1,'Retail Sale Id 6737',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 10:06:21','',''),(7732,'21','222','1',1,'Retail Sale Id 6738',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 10:08:50','',''),(7733,'21','222','1',1,'Retail Sale Id 6739',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 10:10:45','',''),(7734,'21','222','1',1,'Retail Sale Id 6740',7600.00,0.00,0.00,10.00,0.00,'2022-08-28 10:12:12','',''),(7735,'21','222','1',1,'Retail Sale Id 6741',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 10:16:37','',''),(7736,'21','222','1',1,'Retail Sale Id 6743',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 10:18:56','',''),(7737,'21','222','1',1,'Retail Sale Id 6744',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 10:20:21','',''),(7738,'21','222','1',1,'Retail Sale Id 6745',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 10:22:02','',''),(7739,'21','222','1',1,'Retail Sale Id 6746',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 10:24:43','',''),(7740,'21','222','1',1,'Retail Sale Id 6747',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 10:27:27','',''),(7741,'21','222','1',1,'Retail Sale Id 6748',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 10:38:26','',''),(7742,'21','222','1',1,'Retail Sale Id 6749',3997.60,0.00,0.00,5.26,0.00,'2022-08-28 10:39:38','',''),(7743,'21','222','1',1,'Retail Sale Id 6750',7600.00,0.00,0.00,10.00,0.00,'2022-08-28 10:41:30','',''),(7744,'21','222','1',1,'Retail Sale Id 6751',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 10:42:43','',''),(7745,'21','222','1',1,'Retail Sale Id 6751',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 10:42:43','',''),(7746,'21','222','1',1,'Retail Sale Id 6752',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 10:45:04','',''),(7747,'21','222','1',1,'Retail Sale Id 6753',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 10:45:23','',''),(7748,'21','222','1',1,'Retail Sale Id 6754',19000.00,0.00,0.00,25.00,0.00,'2022-08-28 10:45:45','',''),(7749,'21','222','1',1,'Retail Sale Id 6755',11400.00,0.00,0.00,15.00,0.00,'2022-08-28 10:46:09','',''),(7750,'21','222','1',1,'Retail Sale Id 6756',6080.00,0.00,0.00,8.00,0.00,'2022-08-28 10:48:00','',''),(7751,'21','222','1',1,'Retail Sale Id 6757',2500.40,0.00,0.00,3.29,0.00,'2022-08-28 10:53:22','',''),(7752,'21','222','1',1,'Retail Sale Id 6758',2500.40,0.00,0.00,3.29,0.00,'2022-08-28 10:54:41','',''),(7753,'21','222','1',1,'Retail Sale Id 6759',2302.80,0.00,0.00,3.03,0.00,'2022-08-28 10:55:48','',''),(7754,'21','222','1',1,'Retail Sale Id 6760',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 11:06:11','',''),(7755,'21','222','1',1,'Retail Sale Id 6761',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 11:10:12','',''),(7756,'21','222','1',1,'Retail Sale Id 6762',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 11:40:16','',''),(7757,'21','222','1',1,'Retail Sale Id 6763',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 11:42:33','',''),(7758,'21','222','1',1,'Retail Sale Id 6763',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 11:42:33','',''),(7759,'21','222','1',1,'Retail Sale Id 6763',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 11:42:33','',''),(7760,'21','222','1',1,'Retail Sale Id 6764',5320.00,0.00,0.00,7.00,0.00,'2022-08-28 11:43:53','',''),(7761,'21','222','1',1,'Retail Sale Id 6764',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 11:43:53','',''),(7762,'21','222','1',1,'Retail Sale Id 6765',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 11:47:23','',''),(7763,'21','222','1',1,'Retail Sale Id 6766',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 11:48:49','',''),(7764,'21','222','1',1,'Retail Sale Id 6767',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 11:50:05','',''),(7765,'21','222','1',1,'Retail Sale Id 6768',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 11:53:59','',''),(7766,'21','222','1',1,'Retail Sale Id 6769',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 11:54:55','',''),(7767,'21','222','1',1,'Retail Sale Id 6770',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 11:55:44','',''),(7768,'21','222','1',1,'Retail Sale Id 6771',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 11:57:46','',''),(7769,'21','222','1',1,'Retail Sale Id 6772',1003.20,0.00,0.00,1.32,0.00,'2022-08-28 11:58:31','',''),(7770,'21','222','1',1,'Retail Sale Id 6773',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 11:59:39','',''),(7771,'21','222','1',1,'Retail Sale Id 6774',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:01:30','',''),(7772,'21','222','1',1,'Retail Sale Id 6775',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:02:37','',''),(7773,'21','222','1',1,'Retail Sale Id 6776',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:03:31','',''),(7774,'21','222','1',1,'Retail Sale Id 6777',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:04:51','',''),(7775,'21','222','1',1,'Retail Sale Id 6777',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:04:51','',''),(7776,'21','222','1',1,'Retail Sale Id 6778',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:05:34','',''),(7777,'21','222','1',1,'Retail Sale Id 6778',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:05:34','',''),(7778,'21','222','1',1,'Retail Sale Id 6779',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:07:17','',''),(7779,'21','222','1',1,'Retail Sale Id 6780',3997.60,0.00,0.00,5.26,0.00,'2022-08-28 12:08:39','',''),(7780,'21','222','1',1,'Retail Sale Id 6782',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:09:49','',''),(7781,'21','222','1',1,'Retail Sale Id 6783',2500.40,0.00,0.00,3.29,0.00,'2022-08-28 12:10:35','',''),(7782,'21','222','1',1,'Retail Sale Id 6784',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:13:16','',''),(7783,'21','222','1',1,'Retail Sale Id 6785',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:16:48','',''),(7784,'21','222','1',1,'Retail Sale Id 6785',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:16:48','',''),(7785,'21','222','1',1,'Retail Sale Id 6786',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:18:15','',''),(7786,'21','222','1',1,'Retail Sale Id 6787',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:19:45','',''),(7787,'21','222','1',1,'Retail Sale Id 6788',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 12:21:22','',''),(7788,'21','222','1',1,'Retail Sale Id 6789',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:29:08','',''),(7789,'21','222','1',1,'Retail Sale Id 6790',3002.00,0.00,0.00,3.95,0.00,'2022-08-28 12:30:25','',''),(7790,'21','222','1',1,'Retail Sale Id 6791',1003.20,0.00,0.00,1.32,0.00,'2022-08-28 12:33:46','',''),(7791,'21','222','1',1,'Retail Sale Id 6792',5000.80,0.00,0.00,6.58,0.00,'2022-08-28 12:34:43','',''),(7792,'21','222','1',1,'Retail Sale Id 6793',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:35:27','',''),(7793,'21','222','1',1,'Retail Sale Id 6794',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:36:48','',''),(7794,'21','222','1',1,'Retail Sale Id 6794',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:36:48','',''),(7795,'21','222','1',1,'Retail Sale Id 6795',1520.00,0.00,0.00,2.00,0.00,'2022-08-28 12:37:56','',''),(7796,'21','222','1',1,'Retail Sale Id 6796',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:40:11','',''),(7797,'21','222','1',1,'Retail Sale Id 6796',4218.00,0.00,0.00,5.55,0.00,'2022-08-28 12:40:11','',''),(7798,'21','222','1',1,'Retail Sale Id 6797',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:41:26','',''),(7799,'21','222','1',1,'Retail Sale Id 6798',8360.00,0.00,0.00,11.00,0.00,'2022-08-28 12:42:15','',''),(7800,'21','222','1',1,'Retail Sale Id 6799',2401.60,0.00,0.00,3.16,0.00,'2022-08-28 12:42:56','',''),(7801,'21','222','1',1,'Retail Sale Id 6800',7600.00,0.00,0.00,10.00,0.00,'2022-08-28 12:44:04','',''),(7802,'21','222','1',1,'Retail Sale Id 6801',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:44:58','',''),(7803,'21','222','1',1,'Retail Sale Id 6802',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 12:45:54','',''),(7804,'21','222','1',1,'Retail Sale Id 6803',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:46:33','',''),(7805,'21','222','1',1,'Retail Sale Id 6804',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:47:19','',''),(7806,'21','222','1',1,'Retail Sale Id 6805',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:48:12','',''),(7807,'21','222','1',1,'Retail Sale Id 6807',8002.80,0.00,0.00,10.53,0.00,'2022-08-28 12:50:06','',''),(7808,'21','222','1',1,'Retail Sale Id 6808',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 12:50:59','',''),(7809,'21','222','1',1,'Retail Sale Id 6809',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:52:38','',''),(7810,'21','222','1',1,'Retail Sale Id 6810',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 12:55:13','',''),(7811,'21','222','1',1,'Retail Sale Id 6811',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:56:30','',''),(7812,'21','222','1',1,'Retail Sale Id 6812',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 12:57:25','',''),(7813,'21','222','1',1,'Retail Sale Id 6813',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 12:58:03','',''),(7814,'21','222','1',1,'Retail Sale Id 6814',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:03:17','',''),(7815,'21','222','1',1,'Retail Sale Id 6815',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:04:32','',''),(7816,'21','222','1',1,'Retail Sale Id 6816',4750.00,0.00,0.00,6.25,0.00,'2022-08-28 13:08:33','',''),(7817,'21','222','1',1,'Retail Sale Id 6817',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 13:10:51','',''),(7818,'21','222','1',1,'Retail Sale Id 6818',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 13:12:19','',''),(7819,'21','222','1',1,'Retail Sale Id 6819',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:13:25','',''),(7820,'21','222','1',1,'Retail Sale Id 6820',6080.00,0.00,0.00,8.00,0.00,'2022-08-28 13:14:23','',''),(7821,'21','222','1',1,'Retail Sale Id 6821',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:15:33','',''),(7822,'21','222','1',1,'Retail Sale Id 6822',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:16:45','',''),(7823,'21','222','1',1,'Retail Sale Id 6823',1003.20,0.00,0.00,1.32,0.00,'2022-08-28 13:19:28','',''),(7824,'21','222','1',1,'Retail Sale Id 6824',1998.80,0.00,0.00,2.63,0.00,'2022-08-28 13:20:44','',''),(7825,'21','222','1',1,'Retail Sale Id 6825',2500.40,0.00,0.00,3.29,0.00,'2022-08-28 13:22:06','',''),(7826,'21','222','1',1,'Retail Sale Id 6826',1998.80,0.00,0.00,2.63,0.00,'2022-08-28 13:22:40','',''),(7827,'21','222','1',1,'Retail Sale Id 6827',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 13:25:17','',''),(7828,'21','222','1',1,'Retail Sale Id 6828',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 13:28:38','',''),(7829,'21','222','1',1,'Retail Sale Id 6829',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:29:46','',''),(7830,'21','222','1',1,'Retail Sale Id 6830',3040.00,0.00,0.00,4.00,0.00,'2022-08-28 13:32:22','',''),(7831,'21','222','1',1,'Retail Sale Id 6831',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:33:38','',''),(7832,'21','222','1',1,'Retail Sale Id 6832',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:36:11','',''),(7833,'21','222','1',1,'Retail Sale Id 6833',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 13:37:34','',''),(7834,'21','222','1',1,'Retail Sale Id 6834',7600.00,0.00,0.00,10.00,0.00,'2022-08-28 13:38:36','',''),(7835,'21','222','1',1,'Retail Sale Id 6835',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:39:36','',''),(7836,'21','222','1',1,'Retail Sale Id 6836',7600.00,0.00,0.00,10.00,0.00,'2022-08-28 13:41:04','',''),(7837,'21','222','1',1,'Retail Sale Id 6837',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 13:42:19','',''),(7838,'21','222','1',1,'Retail Sale Id 6838',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:46:57','',''),(7839,'21','222','1',1,'Retail Sale Id 6839',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 13:51:41','',''),(7840,'21','222','1',1,'Retail Sale Id 6840',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 13:55:18','',''),(7841,'21','222','1',1,'Retail Sale Id 6841',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 13:56:32','',''),(7842,'21','222','1',1,'Retail Sale Id 6842',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 13:58:25','',''),(7843,'21','222','1',1,'Retail Sale Id 6843',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 14:00:02','',''),(7844,'21','222','1',1,'Retail Sale Id 6844',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 14:03:55','',''),(7845,'21','222','1',1,'Retail Sale Id 6845',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 14:04:47','',''),(7846,'21','222','1',1,'Retail Sale Id 6846',4750.00,0.00,0.00,6.25,0.00,'2022-08-28 14:06:00','',''),(7847,'21','222','1',1,'Retail Sale Id 6847',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 14:10:18','',''),(7848,'21','222','1',1,'Retail Sale Id 6848',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 14:11:25','',''),(7849,'21','222','1',1,'Retail Sale Id 6849',8002.80,0.00,0.00,10.53,0.00,'2022-08-28 14:12:28','',''),(7850,'21','222','1',1,'Retail Sale Id 6850',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 14:16:51','',''),(7851,'21','222','1',1,'Retail Sale Id 6851',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 14:17:44','',''),(7852,'21','222','1',1,'Retail Sale Id 6852',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 14:20:29','',''),(7853,'21','222','1',1,'Retail Sale Id 6853',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 14:24:02','',''),(7854,'21','222','1',1,'Retail Sale Id 6854',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 14:27:03','',''),(7855,'21','222','1',1,'Retail Sale Id 6855',5000.80,0.00,0.00,6.58,0.00,'2022-08-28 14:29:05','',''),(7856,'21','222','1',1,'Retail Sale Id 6856',1003.20,0.00,0.00,1.32,0.00,'2022-08-28 14:41:28','',''),(7857,'21','222','1',1,'Retail Sale Id 6856',1003.20,0.00,0.00,1.32,0.00,'2022-08-28 14:41:28','',''),(7858,'21','222','1',1,'Retail Sale Id 6857',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 15:36:52','',''),(7859,'21','222','1',1,'Retail Sale Id 6858',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 15:38:10','',''),(7860,'21','222','1',1,'Retail Sale Id 6859',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:38:46','',''),(7861,'21','222','1',1,'Retail Sale Id 6860',7600.00,0.00,0.00,10.00,0.00,'2022-08-28 15:39:22','',''),(7862,'21','222','1',1,'Retail Sale Id 6861',6080.00,0.00,0.00,8.00,0.00,'2022-08-28 15:40:02','',''),(7863,'21','222','1',1,'Retail Sale Id 6862',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:41:07','',''),(7864,'21','222','1',1,'Retail Sale Id 6862',15200.00,0.00,0.00,20.00,0.00,'2022-08-28 15:41:07','',''),(7865,'21','222','1',1,'Retail Sale Id 6863',8360.00,0.00,0.00,11.00,0.00,'2022-08-28 15:41:35','',''),(7866,'21','222','1',1,'Retail Sale Id 6864',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 15:42:06','',''),(7867,'21','222','1',1,'Retail Sale Id 6864',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:42:06','',''),(7868,'21','222','1',1,'Retail Sale Id 6865',1520.00,0.00,0.00,2.00,0.00,'2022-08-28 15:42:43','',''),(7869,'21','222','1',1,'Retail Sale Id 6866',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 15:43:02','',''),(7870,'21','222','1',1,'Retail Sale Id 6867',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:43:39','',''),(7871,'21','222','1',1,'Retail Sale Id 6868',1003.20,0.00,0.00,1.32,0.00,'2022-08-28 15:44:39','',''),(7872,'21','222','1',1,'Retail Sale Id 6869',6840.00,0.00,0.00,9.00,0.00,'2022-08-28 15:45:26','',''),(7873,'21','222','1',1,'Retail Sale Id 6870',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:46:00','',''),(7874,'21','222','1',1,'Retail Sale Id 6871',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 15:46:46','',''),(7875,'21','222','1',1,'Retail Sale Id 6871',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:46:46','',''),(7876,'21','222','1',1,'Retail Sale Id 6871',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:46:46','',''),(7877,'21','222','1',1,'Retail Sale Id 6872',19000.00,0.00,0.00,25.00,0.00,'2022-08-28 15:47:12','',''),(7878,'21','222','1',1,'Retail Sale Id 6873',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 15:47:38','',''),(7879,'21','222','1',1,'Retail Sale Id 6874',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 15:48:01','',''),(7880,'21','222','1',1,'Retail Sale Id 6875',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 15:48:24','',''),(7881,'21','222','1',1,'Retail Sale Id 6876',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:48:44','',''),(7882,'21','222','1',1,'Retail Sale Id 6877',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:49:43','',''),(7883,'21','222','1',1,'Retail Sale Id 6877',38000.00,0.00,0.00,50.00,0.00,'2022-08-28 15:49:43','',''),(7884,'21','222','1',1,'Retail Sale Id 6878',8998.40,0.00,0.00,11.84,0.00,'2022-08-28 15:50:15','',''),(7885,'21','222','1',1,'Retail Sale Id 6879',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 15:51:04','',''),(7886,'21','222','1',1,'Retail Sale Id 6880',8002.80,0.00,0.00,10.53,0.00,'2022-08-28 15:51:31','',''),(7887,'21','222','1',1,'Retail Sale Id 6881',5000.80,0.00,0.00,6.58,0.00,'2022-08-28 15:51:53','',''),(7888,'21','222','1',1,'Retail Sale Id 6882',1497.20,0.00,0.00,1.97,0.00,'2022-08-28 15:52:19','',''),(7889,'21','222','1',1,'Retail Sale Id 6883',38000.00,0.00,0.00,50.00,0.00,'2022-08-28 15:52:59','',''),(7890,'21','222','1',1,'Retail Sale Id 6884',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:53:47','',''),(7891,'21','222','1',1,'Retail Sale Id 6885',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 15:54:24','',''),(7892,'21','222','1',1,'Retail Sale Id 6885',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:54:24','',''),(7893,'21','222','1',1,'Retail Sale Id 6886',8360.00,0.00,0.00,11.00,0.00,'2022-08-28 15:54:56','',''),(7894,'21','222','1',1,'Retail Sale Id 6887',11400.00,0.00,0.00,15.00,0.00,'2022-08-28 15:55:40','',''),(7895,'21','222','1',1,'Retail Sale Id 6888',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:56:15','',''),(7896,'21','222','1',1,'Retail Sale Id 6889',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 15:57:57','',''),(7897,'21','222','1',1,'Retail Sale Id 6889',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 15:57:57','',''),(7898,'21','222','1',1,'Retail Sale Id 6890',760.00,0.00,0.00,1.00,0.00,'2022-08-28 15:58:28','',''),(7899,'21','222','1',1,'Retail Sale Id 6891',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 15:58:50','',''),(7900,'21','222','1',1,'Retail Sale Id 6892',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 15:59:42','',''),(7901,'21','222','1',1,'Retail Sale Id 6893',7600.00,0.00,0.00,10.00,0.00,'2022-08-28 16:42:24','',''),(7902,'21','222','1',1,'Retail Sale Id 6894',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 16:42:55','',''),(7903,'21','222','1',1,'Retail Sale Id 6895',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 16:43:17','',''),(7904,'21','222','1',1,'Retail Sale Id 6896',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 16:43:43','',''),(7905,'21','222','1',1,'Retail Sale Id 6897',38000.00,0.00,0.00,50.00,0.00,'2022-08-28 16:44:16','',''),(7906,'21','222','1',1,'Retail Sale Id 6898',8002.80,0.00,0.00,10.53,0.00,'2022-08-28 16:45:15','',''),(7907,'21','222','1',1,'Retail Sale Id 6899',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 16:45:40','',''),(7908,'21','222','1',1,'Retail Sale Id 6900',1497.20,0.00,0.00,1.97,0.00,'2022-08-28 16:46:01','',''),(7909,'21','222','1',1,'Retail Sale Id 6901',6080.00,0.00,0.00,8.00,0.00,'2022-08-28 16:46:26','',''),(7910,'21','222','1',1,'Retail Sale Id 6902',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 16:48:02','',''),(7911,'21','222','1',1,'Retail Sale Id 6903',6840.00,0.00,0.00,9.00,0.00,'2022-08-28 16:48:28','',''),(7912,'21','222','1',1,'Retail Sale Id 6904',4560.00,0.00,0.00,6.00,0.00,'2022-08-28 16:49:15','',''),(7913,'21','222','1',1,'Retail Sale Id 6904',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 16:49:15','',''),(7914,'21','222','1',1,'Retail Sale Id 6905',8360.00,0.00,0.00,11.00,0.00,'2022-08-28 16:50:11','',''),(7915,'21','222','1',1,'Retail Sale Id 6906',3800.00,0.00,0.00,5.00,0.00,'2022-08-28 16:50:42','',''),(7916,'21','222','1',1,'Retail Sale Id 6907',3040.00,0.00,0.00,4.00,0.00,'2022-08-28 16:51:05','',''),(7917,'21','222','1',1,'Retail Sale Id 6908',9500.00,0.00,0.00,12.50,0.00,'2022-08-28 16:51:50','',''),(7918,'21','222','1',1,'Retail Sale Id 6909',6840.00,0.00,0.00,9.00,0.00,'2022-08-28 16:52:32','',''),(7919,'21','222','1',1,'Retail Sale Id 6910',11400.00,0.00,0.00,15.00,0.00,'2022-08-28 16:53:11','',''),(7920,'21','222','1',1,'Retail Sale Id 6911',15200.00,0.00,0.00,20.00,0.00,'2022-08-28 16:54:18','',''),(7921,'21','222','1',1,'Retail Sale Id 6912',8002.80,0.00,0.00,10.53,0.00,'2022-08-28 16:55:13','',''),(7922,'21','222','1',1,'Retail Sale Id 6913',6840.00,0.00,0.00,9.00,0.00,'2022-08-28 16:57:39','',''),(7923,'21','222','1',1,'Retail Sale Id 6915',19000.00,0.00,0.00,25.00,0.00,'2022-08-28 16:58:29','',''),(7924,'21','222','1',1,'Retail Sale Id 6916',6080.00,0.00,0.00,8.00,0.00,'2022-08-28 16:58:59','',''),(7925,'21','222','1',1,'Retail Sale Id 6917',1520.00,0.00,0.00,2.00,0.00,'2022-08-28 16:59:20','',''),(7926,'21','222','1',1,'Retail Sale Id 6918',2280.00,0.00,0.00,3.00,0.00,'2022-08-28 16:59:45','',''),(7927,'21','222','1',1,'Retail Sale Id 6920',5320.00,0.00,0.00,7.00,0.00,'2022-08-28 17:00:46','',''),(7928,'21','222',NULL,1,'Returned purchase #36 to AYM SHAFA NIGERIA. LTD',3800000.00,0.00,0.00,5000.00,0.00,'2022-08-28 23:03:40','',''),(7929,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3720000.00,5000.00,0.00,0.00,'2022-08-29 07:50:58','',''),(7930,'21','222',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,4999.00,0.00,'2022-08-29 07:54:13','',''),(7931,'21','222','1',1,'Received from bridging 53',0.00,0.00,4999.00,0.00,0.00,'2022-08-29 07:54:13','',''),(7932,'21','222','1',1,'Retail Sale Id 6921',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 07:58:14','',''),(7933,'21','222','1',1,'Retail Sale Id 6922',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 08:28:22','',''),(7934,'21','222','1',1,'Retail Sale Id 6923',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 08:49:14','',''),(7935,'21','222','1',1,'Retail Sale Id 6924',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 12:39:43','',''),(7936,'21','222','1',1,'Retail Sale Id 6925',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 12:40:26','',''),(7937,'21','222','1',1,'Retail Sale Id 6926',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 12:44:35','',''),(7938,'21','222','1',1,'Retail Sale Id 6927',2232.00,0.00,0.00,3.00,0.00,'2022-08-29 12:46:38','',''),(7939,'21','222','1',1,'Retail Sale Id 6928',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 12:47:17','',''),(7940,'21','222','1',1,'Retail Sale Id 6929',8808.96,0.00,0.00,11.84,0.00,'2022-08-29 12:47:51','',''),(7941,'21','222','1',1,'Retail Sale Id 6930',11160.00,0.00,0.00,15.00,0.00,'2022-08-29 12:48:15','',''),(7942,'21','222','1',1,'Retail Sale Id 6931',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 12:49:32','',''),(7943,'21','222','1',1,'Retail Sale Id 6932',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 12:50:15','',''),(7944,'21','222','1',1,'Retail Sale Id 6933',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 13:02:44','',''),(7945,'21','222','1',1,'Retail Sale Id 6934',5498.16,0.00,0.00,7.39,0.00,'2022-08-29 13:04:23','',''),(7946,'21','222','1',1,'Retail Sale Id 6935',2998.32,0.00,0.00,4.03,0.00,'2022-08-29 13:07:45','',''),(7947,'21','222','1',1,'Retail Sale Id 6936',5952.00,0.00,0.00,8.00,0.00,'2022-08-29 13:25:25','',''),(7948,'21','222','1',1,'Retail Sale Id 6936',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 13:25:25','',''),(7949,'21','222','1',1,'Retail Sale Id 6937',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 13:44:42','',''),(7950,'21','222','1',1,'Retail Sale Id 6938',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 13:45:08','',''),(7951,'21','222','1',1,'Retail Sale Id 6939',2976.00,0.00,0.00,4.00,0.00,'2022-08-29 13:45:32','',''),(7952,'21','222','1',1,'Retail Sale Id 6940',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 13:46:29','',''),(7953,'21','222','1',1,'Retail Sale Id 6941',18600.00,0.00,0.00,25.00,0.00,'2022-08-29 14:04:26','',''),(7954,'21','222','1',1,'Retail Sale Id 6942',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 14:12:00','',''),(7955,'21','222','1',1,'Retail Sale Id 6943',37200.00,0.00,0.00,50.00,0.00,'2022-08-29 14:12:54','',''),(7956,'21','222','1',1,'Retail Sale Id 6944',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 14:26:52','',''),(7957,'21','222','1',1,'Retail Sale Id 6945',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 14:28:03','',''),(7958,'21','222','1',1,'Retail Sale Id 6946',11160.00,0.00,0.00,15.00,0.00,'2022-08-29 14:29:01','',''),(7959,'21','222','1',1,'Retail Sale Id 6947',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 14:32:18','',''),(7960,'21','222','1',1,'Retail Sale Id 6948',37200.00,0.00,0.00,50.00,0.00,'2022-08-29 14:34:48','',''),(7961,'21','222','1',1,'Retail Sale Id 6949',7440.00,0.00,0.00,10.00,0.00,'2022-08-29 14:36:27','',''),(7962,'21','222','1',1,'Retail Sale Id 6950',14880.00,0.00,0.00,20.00,0.00,'2022-08-29 14:38:27','',''),(7963,'21','222','1',1,'Retail Sale Id 6951',3720.00,0.00,0.00,5.00,0.00,'2022-08-29 14:40:05','',''),(7964,'21','222','1',1,'Retail Sale Id 6952',11160.00,0.00,0.00,15.00,0.00,'2022-08-29 14:44:18','',''),(7965,'21','222','1',1,'Retail Sale Id 6953',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 14:51:10','',''),(7966,'21','222','1',1,'Retail Sale Id 6954',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 14:52:10','',''),(7967,'21','222','1',1,'Retail Sale Id 6955',18600.00,0.00,0.00,25.00,0.00,'2022-08-29 14:53:20','',''),(7968,'21','222','1',1,'Retail Sale Id 6957',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 14:59:12','',''),(7969,'21','222','1',1,'Retail Sale Id 6958',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 15:04:40','',''),(7970,'21','222','1',1,'Retail Sale Id 6960',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 15:08:43','',''),(7971,'21','222','1',1,'Retail Sale Id 6961',37200.00,0.00,0.00,50.00,0.00,'2022-08-29 15:09:44','',''),(7972,'21','222','1',1,'Retail Sale Id 6962',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 15:11:14','',''),(7973,'21','222','1',1,'Retail Sale Id 6963',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 15:13:40','',''),(7974,'21','222','1',1,'Retail Sale Id 6964',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 15:31:01','',''),(7975,'21','222','1',1,'Retail Sale Id 6965',2001.36,0.00,0.00,2.69,0.00,'2022-08-29 15:34:10','',''),(7976,'21','222','1',1,'Retail Sale Id 6966',18600.00,0.00,0.00,25.00,0.00,'2022-08-29 15:36:43','',''),(7977,'21','222','1',1,'Retail Sale Id 6967',6696.00,0.00,0.00,9.00,0.00,'2022-08-29 15:38:15','',''),(7978,'21','222','1',1,'Retail Sale Id 6971',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 15:41:32','',''),(7979,'21','222','1',1,'Retail Sale Id 6972',11160.00,0.00,0.00,15.00,0.00,'2022-08-29 15:43:34','',''),(7980,'21','222','1',1,'Retail Sale Id 6973',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 15:45:38','',''),(7981,'21','222','1',1,'Retail Sale Id 6974',37200.00,0.00,0.00,50.00,0.00,'2022-08-29 15:51:49','',''),(7982,'21','222','1',1,'Retail Sale Id 6975',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 16:10:47','',''),(7983,'21','222','1',1,'Retail Sale Id 6976',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 16:21:22','',''),(7984,'21','222','1',1,'Retail Sale Id 6977',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 16:25:02','',''),(7985,'21','222','1',1,'Retail Sale Id 6978',11160.00,0.00,0.00,15.00,0.00,'2022-08-29 16:26:31','',''),(7986,'21','222','1',1,'Retail Sale Id 6979',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 16:44:52','',''),(7987,'21','222','1',1,'Retail Sale Id 6980',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 16:46:39','',''),(7988,'21','222','1',1,'Retail Sale Id 6981',34968.00,0.00,0.00,47.00,0.00,'2022-08-29 16:47:53','',''),(7989,'21','222','1',1,'Retail Sale Id 6982',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 16:49:07','',''),(7990,'21','222','1',1,'Retail Sale Id 6983',7998.00,0.00,0.00,10.75,0.00,'2022-08-29 16:50:40','',''),(7991,'21','222','1',1,'Retail Sale Id 6984',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 16:55:03','',''),(7992,'21','222','1',1,'Retail Sale Id 6986',2001.36,0.00,0.00,2.69,0.00,'2022-08-29 16:56:35','',''),(7993,'21','222','1',1,'Retail Sale Id 6987',10802.88,0.00,0.00,14.52,0.00,'2022-08-29 17:01:03','',''),(7994,'21','222','1',1,'Retail Sale Id 6989',1488.00,0.00,0.00,2.00,0.00,'2022-08-29 17:15:51','',''),(7995,'21','222','1',1,'Retail Sale Id 6989',1488.00,0.00,0.00,2.00,0.00,'2022-08-29 17:15:51','',''),(7996,'21','222','1',1,'Retail Sale Id 6990',1488.00,0.00,0.00,2.00,0.00,'2022-08-29 17:35:11','',''),(7997,'21','222','1',1,'Retail Sale Id 6991',2232.00,0.00,0.00,3.00,0.00,'2022-08-29 17:36:04','',''),(7998,'21','222','1',1,'Retail Sale Id 6992',996.96,0.00,0.00,1.34,0.00,'2022-08-29 17:36:49','',''),(7999,'21','222','1',1,'Retail Sale Id 6993',4999.68,0.00,0.00,6.72,0.00,'2022-08-29 17:38:14','',''),(8000,'21','222','1',1,'Retail Sale Id 6994',4002.72,0.00,0.00,5.38,0.00,'2022-08-29 17:39:27','',''),(8001,'21','222','1',1,'Retail Sale Id 6995',2998.32,0.00,0.00,4.03,0.00,'2022-08-29 17:40:25','',''),(8002,'21','222','1',1,'Retail Sale Id 6996',3720.00,0.00,0.00,5.00,0.00,'2022-08-29 17:44:18','',''),(8003,'21','222','1',1,'Retail Sale Id 6997',3720.00,0.00,0.00,5.00,0.00,'2022-08-29 17:59:44','',''),(8004,'21','222','1',1,'Retail Sale Id 6997',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 17:59:44','',''),(8005,'21','222','1',1,'Retail Sale Id 6999',1800.48,0.00,0.00,2.42,0.00,'2022-08-29 18:14:53','',''),(8006,'21','222','1',1,'Retail Sale Id 7000',2232.00,0.00,0.00,3.00,0.00,'2022-08-29 18:36:20','',''),(8007,'21','222','1',1,'Retail Sale Id 7001',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 18:45:47','',''),(8008,'21','222','1',1,'Retail Sale Id 7002',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 18:46:57','',''),(8009,'21','222','1',1,'Retail Sale Id 7003',2998.32,0.00,0.00,4.03,0.00,'2022-08-29 18:48:45','',''),(8010,'21','222','1',1,'Retail Sale Id 7004',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 19:49:38','',''),(8011,'21','222','1',1,'Retail Sale Id 7005',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 19:50:21','',''),(8012,'21','222','1',1,'Retail Sale Id 7006',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 19:50:59','',''),(8013,'21','222','1',1,'Retail Sale Id 7006',7440.00,0.00,0.00,10.00,0.00,'2022-08-29 19:50:59','',''),(8014,'21','222','1',1,'Retail Sale Id 7007',37200.00,0.00,0.00,50.00,0.00,'2022-08-29 19:51:21','',''),(8015,'21','222','1',1,'Retail Sale Id 7008',5952.00,0.00,0.00,8.00,0.00,'2022-08-29 19:51:48','',''),(8016,'21','222','1',1,'Retail Sale Id 7009',9300.00,0.00,0.00,12.50,0.00,'2022-08-29 19:52:14','',''),(8017,'21','222','1',1,'Retail Sale Id 7010',3720.00,0.00,0.00,5.00,0.00,'2022-08-29 19:52:50','',''),(8018,'21','222','1',1,'Retail Sale Id 7011',5208.00,0.00,0.00,7.00,0.00,'2022-08-29 19:53:23','',''),(8019,'21','222','1',1,'Retail Sale Id 7012',18600.00,0.00,0.00,25.00,0.00,'2022-08-29 19:53:46','',''),(8020,'21','222','1',1,'Retail Sale Id 7013',8808.96,0.00,0.00,11.84,0.00,'2022-08-29 19:54:17','',''),(8021,'21','222','1',1,'Retail Sale Id 7014',14880.00,0.00,0.00,20.00,0.00,'2022-08-29 19:55:14','',''),(8022,'21','222','1',1,'Retail Sale Id 7015',4464.00,0.00,0.00,6.00,0.00,'2022-08-29 19:55:46','',''),(8023,'21','222','1',1,'Retail Sale Id 7015',7440.00,0.00,0.00,10.00,0.00,'2022-08-29 19:55:46','',''),(8024,'21','222','1',1,'Retail Sale Id 7016',37200.00,0.00,0.00,50.00,0.00,'2022-08-29 19:56:09','',''),(8025,'21','222','1',1,'Retail Sale Id 7017',2232.00,0.00,0.00,3.00,0.00,'2022-08-29 19:56:30','',''),(8026,'21','222','1',1,'Retail Sale Id 7018',996.96,0.00,0.00,1.34,0.00,'2022-08-29 19:56:57','',''),(8027,'21','222','1',1,'Retail Sale Id 7018',996.96,0.00,0.00,1.34,0.00,'2022-08-29 19:56:57','',''),(8028,'21','222','1',1,'Retail Sale Id 7019',7001.04,0.00,0.00,9.41,0.00,'2022-08-29 19:57:26','',''),(8029,'21','222','1',1,'Return of Retail Sale Id 7013',0.00,8808.96,11.84,0.00,0.00,'2022-08-29 19:59:31','',''),(8030,'21','222','1',1,'Return of Retail Sale Id 7015',0.00,4464.00,6.00,0.00,0.00,'2022-08-29 20:00:11','',''),(8031,'21','222','1',1,'Return of Retail Sale Id 7015',0.00,7440.00,10.00,0.00,0.00,'2022-08-29 20:00:11','',''),(8032,'21','222','1',1,'Retail Sale Id 7020',10036.56,0.00,0.00,13.49,0.00,'2022-08-29 20:01:35','',''),(8033,'21','222','1',1,'Retail Sale Id 7021',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 07:40:18','',''),(8034,'21','222','1',1,'Retail Sale Id 7022',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 07:42:23','',''),(8035,'21','222','1',1,'Retail Sale Id 7023',2001.36,0.00,0.00,2.69,0.00,'2022-08-30 07:43:32','',''),(8036,'21','222','1',1,'Retail Sale Id 7024',2001.36,0.00,0.00,2.69,0.00,'2022-08-30 07:44:22','',''),(8037,'21','222','1',1,'Retail Sale Id 7025',14880.00,0.00,0.00,20.00,0.00,'2022-08-30 07:49:01','',''),(8038,'21','222','1',1,'Retail Sale Id 7026',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 07:49:58','',''),(8039,'21','222','1',1,'Retail Sale Id 7027',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 07:59:43','',''),(8040,'21','222','1',1,'Retail Sale Id 7028',11160.00,0.00,0.00,15.00,0.00,'2022-08-30 08:02:18','',''),(8041,'21','222','1',1,'Retail Sale Id 7029',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 08:10:33','',''),(8042,'21','222','1',1,'Retail Sale Id 7030',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 08:13:22','',''),(8043,'21','222','1',1,'Retail Sale Id 7031',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 08:18:34','',''),(8044,'21','222','1',1,'Retail Sale Id 7032',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 08:19:54','',''),(8045,'21','222','1',1,'Retail Sale Id 7033',1502.88,0.00,0.00,2.02,0.00,'2022-08-30 08:21:27','',''),(8046,'21','222','1',1,'Retail Sale Id 7034',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 08:23:26','',''),(8047,'21','222','1',1,'Retail Sale Id 7035',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 08:24:42','',''),(8048,'21','222','1',1,'Retail Sale Id 7036',2998.32,0.00,0.00,4.03,0.00,'2022-08-30 08:28:07','',''),(8049,'21','222','1',1,'Retail Sale Id 7037',996.96,0.00,0.00,1.34,0.00,'2022-08-30 08:30:21','',''),(8050,'21','222','1',1,'Retail Sale Id 7038',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 08:31:59','',''),(8051,'21','222','1',1,'Retail Sale Id 7039',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 08:39:20','',''),(8052,'21','222','1',1,'Retail Sale Id 7040',4002.72,0.00,0.00,5.38,0.00,'2022-08-30 08:47:33','',''),(8053,'21','222','1',1,'Retail Sale Id 7041',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 08:51:29','',''),(8054,'21','222','1',1,'Retail Sale Id 7042',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 08:55:03','',''),(8055,'21','222','1',1,'Retail Sale Id 7043',3720.00,0.00,0.00,5.00,0.00,'2022-08-30 09:00:43','',''),(8056,'21','222','1',1,'Retail Sale Id 7043',4650.00,0.00,0.00,6.25,0.00,'2022-08-30 09:00:43','',''),(8057,'21','222','1',1,'Retail Sale Id 7044',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 09:07:10','',''),(8058,'21','222','1',1,'Retail Sale Id 7045',996.96,0.00,0.00,1.34,0.00,'2022-08-30 09:08:35','',''),(8059,'21','222','1',1,'Retail Sale Id 7046',7812.00,0.00,0.00,10.50,0.00,'2022-08-30 09:17:30','',''),(8060,'21','222','1',1,'Retail Sale Id 7047',996.96,0.00,0.00,1.34,0.00,'2022-08-30 09:32:02','',''),(8061,'21','222','1',1,'Retail Sale Id 7048',2998.32,0.00,0.00,4.03,0.00,'2022-08-30 09:37:39','',''),(8062,'21','222','1',1,'Retail Sale Id 7049',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 09:51:59','',''),(8063,'21','222','1',1,'Retail Sale Id 7050',7998.00,0.00,0.00,10.75,0.00,'2022-08-30 09:58:16','',''),(8064,'21','222','1',1,'Retail Sale Id 7051',2499.84,0.00,0.00,3.36,0.00,'2022-08-30 10:03:25','',''),(8065,'21','222','1',1,'Retail Sale Id 7052',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 10:04:43','',''),(8066,'21','222','1',1,'Retail Sale Id 7053',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 10:10:48','',''),(8067,'21','222','1',1,'Retail Sale Id 7054',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 10:14:11','',''),(8068,'21','222','1',1,'Retail Sale Id 7055',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 10:21:08','',''),(8069,'21','222','1',1,'Retail Sale Id 7056',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 10:22:55','',''),(8070,'21','222','1',1,'Retail Sale Id 7057',4300.32,0.00,0.00,5.78,0.00,'2022-08-30 10:25:22','',''),(8071,'21','222','1',1,'Retail Sale Id 7058',1197.84,0.00,0.00,1.61,0.00,'2022-08-30 10:28:13','',''),(8072,'21','222','1',1,'Retail Sale Id 7059',3720.00,0.00,0.00,5.00,0.00,'2022-08-30 10:31:49','',''),(8073,'21','222','1',1,'Retail Sale Id 7060',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 10:42:30','',''),(8074,'21','222','1',1,'Retail Sale Id 7060',4650.00,0.00,0.00,6.25,0.00,'2022-08-30 10:42:30','',''),(8075,'21','222','1',1,'Retail Sale Id 7061',4999.68,0.00,0.00,6.72,0.00,'2022-08-30 10:53:19','',''),(8076,'21','222','1',1,'Retail Sale Id 7062',4300.32,0.00,0.00,5.78,0.00,'2022-08-30 11:24:02','',''),(8077,'21','222','1',1,'Retail Sale Id 7063',7998.00,0.00,0.00,10.75,0.00,'2022-08-30 11:27:18','',''),(8078,'21','222','1',1,'Retail Sale Id 7064',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 11:53:14','',''),(8079,'21','222','1',1,'Retail Sale Id 7065',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 11:57:22','',''),(8080,'21','222','1',1,'Retail Sale Id 7066',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 11:58:06','',''),(8081,'21','222','1',1,'Retail Sale Id 7068',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 11:58:30','',''),(8082,'21','222','1',1,'Retail Sale Id 7069',982.08,0.00,0.00,1.32,0.00,'2022-08-30 12:00:28','',''),(8083,'21','222','1',1,'Retail Sale Id 7070',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 12:00:57','',''),(8084,'21','222','1',1,'Retail Sale Id 7071',3720.00,0.00,0.00,5.00,0.00,'2022-08-30 12:12:40','',''),(8085,'21','222','1',1,'Retail Sale Id 7072',3720.00,0.00,0.00,5.00,0.00,'2022-08-30 12:13:02','',''),(8086,'21','222','1',1,'Retail Sale Id 7073',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 12:13:28','',''),(8087,'21','222','1',1,'Retail Sale Id 7074',7440.00,0.00,0.00,10.00,0.00,'2022-08-30 12:13:53','',''),(8088,'21','222','1',1,'Retail Sale Id 7075',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 12:17:59','',''),(8089,'21','222','1',1,'Retail Sale Id 7076',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 12:20:55','',''),(8090,'21','222','1',1,'Retail Sale Id 7077',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 12:27:17','',''),(8091,'21','222','1',1,'Retail Sale Id 7078',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 12:29:00','',''),(8092,'21','222','1',1,'Retail Sale Id 7079',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 12:32:55','',''),(8093,'21','222','1',1,'Retail Sale Id 7079',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 12:32:55','',''),(8094,'21','222','1',1,'Retail Sale Id 7080',3496.80,0.00,0.00,4.70,0.00,'2022-08-30 12:37:59','',''),(8095,'21','222','1',1,'Retail Sale Id 7081',5952.00,0.00,0.00,8.00,0.00,'2022-08-30 12:40:31','',''),(8096,'21','222','1',1,'Retail Sale Id 7082',1488.00,0.00,0.00,2.00,0.00,'2022-08-30 12:40:56','',''),(8097,'21','222','1',1,'Retail Sale Id 7083',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 12:47:13','',''),(8098,'21','222','1',1,'Retail Sale Id 7084',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 12:50:18','',''),(8099,'21','222','1',1,'Retail Sale Id 7085',2001.36,0.00,0.00,2.69,0.00,'2022-08-30 13:00:23','',''),(8100,'21','222','1',1,'Retail Sale Id 7086',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 13:09:24','',''),(8101,'21','222','1',1,'Retail Sale Id 7087',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 13:10:58','',''),(8102,'21','222','1',1,'Retail Sale Id 7088',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 13:13:31','',''),(8103,'21','222','1',1,'Retail Sale Id 7089',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 13:36:15','',''),(8104,'21','222','1',1,'Retail Sale Id 7090',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 14:13:07','',''),(8105,'21','222','1',1,'Retail Sale Id 7090',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 14:13:07','',''),(8106,'21','222','1',1,'Retail Sale Id 7091',4002.72,0.00,0.00,5.38,0.00,'2022-08-30 15:19:25','',''),(8107,'21','222','1',1,'Retail Sale Id 7092',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 16:02:52','',''),(8108,'21','222','1',1,'Retail Sale Id 7093',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 16:03:16','',''),(8109,'21','222','1',1,'Retail Sale Id 7094',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 16:03:59','',''),(8110,'21','222','1',1,'Retail Sale Id 7095',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 16:07:22','',''),(8111,'21','222','1',1,'Retail Sale Id 7096',3720.00,0.00,0.00,5.00,0.00,'2022-08-30 16:07:44','',''),(8112,'21','222','1',1,'Retail Sale Id 7097',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 16:08:09','',''),(8113,'21','222','1',1,'Retail Sale Id 7098',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 16:08:38','',''),(8114,'21','222','1',1,'Retail Sale Id 7099',7440.00,0.00,0.00,10.00,0.00,'2022-08-30 16:09:21','',''),(8115,'21','222','1',1,'Retail Sale Id 7100',5952.00,0.00,0.00,8.00,0.00,'2022-08-30 16:09:54','',''),(8116,'21','222','1',1,'Retail Sale Id 7101',9999.36,0.00,0.00,13.44,0.00,'2022-08-30 16:10:32','',''),(8117,'21','222','1',1,'Retail Sale Id 7102',2976.00,0.00,0.00,4.00,0.00,'2022-08-30 16:11:02','',''),(8118,'21','222','1',1,'Retail Sale Id 7103',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 16:12:17','',''),(8119,'21','222','1',1,'Retail Sale Id 7104',996.96,0.00,0.00,1.34,0.00,'2022-08-30 16:14:54','',''),(8120,'21','222','1',1,'Retail Sale Id 7105',1488.00,0.00,0.00,2.00,0.00,'2022-08-30 16:15:26','',''),(8121,'21','222','1',1,'Retail Sale Id 7106',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 16:17:27','',''),(8122,'21','222','1',1,'Retail Sale Id 7107',1502.88,0.00,0.00,2.02,0.00,'2022-08-30 16:18:20','',''),(8123,'21','222','1',1,'Retail Sale Id 7108',3720.00,0.00,0.00,5.00,0.00,'2022-08-30 16:23:48','',''),(8124,'21','222','1',1,'Retail Sale Id 7109',996.96,0.00,0.00,1.34,0.00,'2022-08-30 16:27:39','',''),(8125,'21','222','1',1,'Retail Sale Id 7110',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 16:30:49','',''),(8126,'21','222','1',1,'Retail Sale Id 7111',1488.00,0.00,0.00,2.00,0.00,'2022-08-30 16:57:54','',''),(8127,'21','222','1',1,'Retail Sale Id 7112',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 17:00:16','',''),(8128,'21','222','1',1,'Retail Sale Id 7113',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 17:08:13','',''),(8129,'21','222','1',1,'Retail Sale Id 7114',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 17:42:24','',''),(8130,'21','222','1',1,'Retail Sale Id 7115',2001.36,0.00,0.00,2.69,0.00,'2022-08-30 18:14:31','',''),(8131,'21','222','1',1,'Retail Sale Id 7116',996.96,0.00,0.00,1.34,0.00,'2022-08-30 18:27:31','',''),(8132,'21','222','1',1,'Retail Sale Id 7117',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 18:30:08','',''),(8133,'21','222','1',1,'Retail Sale Id 7118',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 18:32:31','',''),(8134,'21','222','1',1,'Retail Sale Id 7119',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 18:44:29','',''),(8135,'21','222','1',1,'Retail Sale Id 7120',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 18:47:13','',''),(8136,'21','222','1',1,'Retail Sale Id 7121',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 18:48:28','',''),(8137,'21','222','1',1,'Retail Sale Id 7122',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 18:51:48','',''),(8138,'21','222','1',1,'Retail Sale Id 7123',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 19:06:06','',''),(8139,'21','222','1',1,'Retail Sale Id 7124',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 20:18:24','',''),(8140,'21','222','1',1,'Retail Sale Id 7125',7440.00,0.00,0.00,10.00,0.00,'2022-08-30 20:18:44','',''),(8141,'21','222','1',1,'Retail Sale Id 7126',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 20:19:03','',''),(8142,'21','222','1',1,'Retail Sale Id 7127',3720.00,0.00,0.00,5.00,0.00,'2022-08-30 20:19:45','',''),(8143,'21','222','1',1,'Retail Sale Id 7128',7440.00,0.00,0.00,10.00,0.00,'2022-08-30 20:20:14','',''),(8144,'21','222','1',1,'Retail Sale Id 7129',18600.00,0.00,0.00,25.00,0.00,'2022-08-30 20:21:05','',''),(8145,'21','222','1',1,'Retail Sale Id 7130',37200.00,0.00,0.00,50.00,0.00,'2022-08-30 20:21:24','',''),(8146,'21','222','1',1,'Retail Sale Id 7131',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 20:22:27','',''),(8147,'21','222','1',1,'Retail Sale Id 7131',37200.00,0.00,0.00,50.00,0.00,'2022-08-30 20:22:27','',''),(8148,'21','222','1',1,'Retail Sale Id 7132',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 20:23:31','',''),(8149,'21','222','1',1,'Retail Sale Id 7133',996.96,0.00,0.00,1.34,0.00,'2022-08-30 20:24:10','',''),(8150,'21','222','1',1,'Retail Sale Id 7134',2232.00,0.00,0.00,3.00,0.00,'2022-08-30 20:24:28','',''),(8151,'21','222','1',1,'Retail Sale Id 7135',11160.00,0.00,0.00,15.00,0.00,'2022-08-30 20:24:55','',''),(8152,'21','222','1',1,'Retail Sale Id 7136',14880.00,0.00,0.00,20.00,0.00,'2022-08-30 20:25:30','',''),(8153,'21','222','1',1,'Retail Sale Id 7137',1488.00,0.00,0.00,2.00,0.00,'2022-08-30 20:25:51','',''),(8154,'21','222','1',1,'Retail Sale Id 7138',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 20:26:12','',''),(8155,'21','222','1',1,'Retail Sale Id 7139',5208.00,0.00,0.00,7.00,0.00,'2022-08-30 20:26:39','',''),(8156,'21','222','1',1,'Retail Sale Id 7140',4464.00,0.00,0.00,6.00,0.00,'2022-08-30 20:27:24','',''),(8157,'21','222','1',1,'Retail Sale Id 7140',7440.00,0.00,0.00,10.00,0.00,'2022-08-30 20:27:24','',''),(8158,'21','222','1',1,'Retail Sale Id 7141',8808.96,0.00,0.00,11.84,0.00,'2022-08-30 20:28:15','',''),(8159,'21','222','1',1,'Retail Sale Id 7142',3720.00,0.00,0.00,5.00,0.00,'2022-08-30 20:28:54','',''),(8160,'21','222','1',1,'Retail Sale Id 7142',9300.00,0.00,0.00,12.50,0.00,'2022-08-30 20:28:54','',''),(8161,'21','222','1',1,'Retail Sale Id 7143',11160.00,0.00,0.00,15.00,0.00,'2022-08-30 20:29:18','',''),(8162,'21','222','1',1,'Retail Sale Id 7144',9411.60,0.00,0.00,12.65,0.00,'2022-08-30 20:30:46','',''),(8163,'21','222','1',1,'Retail Sale Id 7145',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 07:25:18','',''),(8164,'21','222','1',1,'Retail Sale Id 7146',2232.00,0.00,0.00,3.00,0.00,'2022-08-31 07:27:55','',''),(8165,'21','222','1',1,'Retail Sale Id 7147',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 07:54:44','',''),(8166,'21','222','1',1,'Retail Sale Id 7148',4650.00,0.00,0.00,6.25,0.00,'2022-08-31 07:55:27','',''),(8167,'21','222','1',1,'Retail Sale Id 7149',7298.64,0.00,0.00,9.81,0.00,'2022-08-31 08:01:43','',''),(8168,'21','222','1',1,'Retail Sale Id 7150',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 08:27:05','',''),(8169,'21','222','1',1,'Retail Sale Id 7151',7440.00,0.00,0.00,10.00,0.00,'2022-08-31 08:41:27','',''),(8170,'21','222','1',1,'Retail Sale Id 7152',2232.00,0.00,0.00,3.00,0.00,'2022-08-31 08:45:13','',''),(8171,'21','222','1',1,'Retail Sale Id 7153',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 08:57:08','',''),(8172,'21','222','1',1,'Retail Sale Id 7154',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 09:00:22','',''),(8173,'21','222','1',1,'Retail Sale Id 7155',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 09:01:06','',''),(8174,'21','222','1',1,'Retail Sale Id 7156',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 09:32:00','',''),(8175,'21','222','1',1,'Retail Sale Id 7157',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 09:32:35','',''),(8176,'21','222','1',1,'Retail Sale Id 7158',2232.00,0.00,0.00,3.00,0.00,'2022-08-31 09:33:13','',''),(8177,'21','222','1',1,'Retail Sale Id 7159',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 09:34:10','',''),(8178,'21','222','1',1,'Retail Sale Id 7160',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 09:36:08','',''),(8179,'21','222','1',1,'Retail Sale Id 7161',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 09:37:41','',''),(8180,'21','222','1',1,'Retail Sale Id 7162',2976.00,0.00,0.00,4.00,0.00,'2022-08-31 09:48:49','',''),(8181,'21','222','1',1,'Retail Sale Id 7163',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 09:53:51','',''),(8182,'21','222','1',1,'Retail Sale Id 7164',4999.68,0.00,0.00,6.72,0.00,'2022-08-31 10:19:57','',''),(8183,'21','222','1',1,'Retail Sale Id 7165',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 10:33:35','',''),(8184,'21','222','1',1,'Retail Sale Id 7166',5208.00,0.00,0.00,7.00,0.00,'2022-08-31 10:37:55','',''),(8185,'21','222','1',1,'Retail Sale Id 7167',3496.80,0.00,0.00,4.70,0.00,'2022-08-31 10:46:42','',''),(8186,'21','222','1',1,'Retail Sale Id 7168',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 10:49:54','',''),(8187,'21','222','1',1,'Retail Sale Id 7169',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 10:52:05','',''),(8188,'21','222','1',1,'Retail Sale Id 7170',4002.72,0.00,0.00,5.38,0.00,'2022-08-31 11:21:33','',''),(8189,'21','222','1',1,'Retail Sale Id 7171',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 11:31:42','',''),(8190,'21','222','1',1,'Retail Sale Id 7172',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 11:35:06','',''),(8191,'21','222','1',1,'Retail Sale Id 7173',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 11:48:44','',''),(8192,'21','222','1',1,'Retail Sale Id 7173',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 11:48:44','',''),(8193,'21','222','1',1,'Retail Sale Id 7174',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 11:49:40','',''),(8194,'21','222','1',1,'Retail Sale Id 7175',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 11:53:58','',''),(8195,'21','222','1',1,'Retail Sale Id 7175',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 11:53:58','',''),(8196,'21','222','1',1,'Retail Sale Id 7176',7998.00,0.00,0.00,10.75,0.00,'2022-08-31 11:59:06','',''),(8197,'21','222','1',1,'Retail Sale Id 7177',996.96,0.00,0.00,1.34,0.00,'2022-08-31 12:05:36','',''),(8198,'21','222','1',1,'Retail Sale Id 7178',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 12:10:39','',''),(8199,'21','222','1',1,'Retail Sale Id 7179',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 12:28:08','',''),(8200,'21','222','1',1,'Retail Sale Id 7180',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 12:32:57','',''),(8201,'21','222','1',1,'Retail Sale Id 7181',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 13:05:14','',''),(8202,'21','222','1',1,'Retail Sale Id 7182',2232.00,0.00,0.00,3.00,0.00,'2022-08-31 13:05:57','',''),(8203,'21','222','1',1,'Retail Sale Id 7183',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 13:06:54','',''),(8204,'21','222','1',1,'Retail Sale Id 7184',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 13:18:39','',''),(8205,'21','222','1',1,'Retail Sale Id 7185',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 13:19:05','',''),(8206,'21','222','1',1,'Retail Sale Id 7186',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 13:19:36','',''),(8207,'21','222','1',1,'Retail Sale Id 7187',1488.00,0.00,0.00,2.00,0.00,'2022-08-31 13:57:20','',''),(8208,'21','222','1',1,'Retail Sale Id 7188',3720.00,0.00,0.00,5.00,0.00,'2022-08-31 13:57:43','',''),(8209,'21','222','1',1,'Retail Sale Id 7189',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 13:58:07','',''),(8210,'21','222','1',1,'Retail Sale Id 7190',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 13:58:34','',''),(8211,'21','222','1',1,'Retail Sale Id 7191',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 13:58:59','',''),(8212,'21','222','1',1,'Retail Sale Id 7192',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 14:02:23','',''),(8213,'21','222','1',1,'Retail Sale Id 7193',2998.32,0.00,0.00,4.03,0.00,'2022-08-31 14:02:48','',''),(8214,'21','222','1',1,'Retail Sale Id 7194',996.96,0.00,0.00,1.34,0.00,'2022-08-31 14:03:23','',''),(8215,'21','222','1',1,'Retail Sale Id 7195',7440.00,0.00,0.00,10.00,0.00,'2022-08-31 14:15:30','',''),(8216,'21','222','1',1,'Retail Sale Id 7196',7440.00,0.00,0.00,10.00,0.00,'2022-08-31 14:16:03','',''),(8217,'21','222','1',1,'Retail Sale Id 7197',2976.00,0.00,0.00,4.00,0.00,'2022-08-31 14:16:31','',''),(8218,'21','222','1',1,'Retail Sale Id 7198',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 14:16:59','',''),(8219,'21','222','1',1,'Retail Sale Id 7199',2998.32,0.00,0.00,4.03,0.00,'2022-08-31 14:19:12','',''),(8220,'21','222','1',1,'Retail Sale Id 7200',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 14:45:18','',''),(8221,'21','222','1',1,'Retail Sale Id 7201',7440.00,0.00,0.00,10.00,0.00,'2022-08-31 14:45:43','',''),(8222,'21','222','1',1,'Retail Sale Id 7202',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 15:31:04','',''),(8223,'21','222','1',1,'Retail Sale Id 7203',744.00,0.00,0.00,1.00,0.00,'2022-08-31 15:32:26','',''),(8224,'21','222','1',1,'Retail Sale Id 7204',996.96,0.00,0.00,1.34,0.00,'2022-08-31 15:35:04','',''),(8225,'21','222','1',1,'Retail Sale Id 7205',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 15:40:06','',''),(8226,'21','222','1',1,'Retail Sale Id 7206',5952.00,0.00,0.00,8.00,0.00,'2022-08-31 15:40:45','',''),(8227,'21','222','1',1,'Retail Sale Id 7207',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 15:41:33','',''),(8228,'21','222','1',1,'Retail Sale Id 7208',2001.36,0.00,0.00,2.69,0.00,'2022-08-31 15:42:28','',''),(8229,'21','222','1',1,'Retail Sale Id 7209',37200.00,0.00,0.00,50.00,0.00,'2022-08-31 16:06:24','',''),(8230,'21','222','1',1,'Retail Sale Id 7210',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 16:09:04','',''),(8231,'21','222','1',1,'Retail Sale Id 7211',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 16:13:28','',''),(8232,'21','222','1',1,'Retail Sale Id 7212',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 16:19:06','',''),(8233,'21','222','1',1,'Retail Sale Id 7213',3720.00,0.00,0.00,5.00,0.00,'2022-08-31 16:20:45','',''),(8234,'21','222','1',1,'Retail Sale Id 7214',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 16:29:57','',''),(8235,'21','222','1',1,'Retail Sale Id 7215',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 16:30:29','',''),(8236,'21','222','1',1,'Retail Sale Id 7216',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 16:33:46','',''),(8237,'21','222','1',1,'Retail Sale Id 7217',1599.60,0.00,0.00,2.15,0.00,'2022-08-31 16:34:49','',''),(8238,'21','222','1',1,'Retail Sale Id 7218',1599.60,0.00,0.00,2.15,0.00,'2022-08-31 16:35:47','',''),(8239,'21','222','1',1,'Retail Sale Id 7219',37200.00,0.00,0.00,50.00,0.00,'2022-08-31 16:37:55','',''),(8240,'21','222','1',1,'Retail Sale Id 7220',6696.00,0.00,0.00,9.00,0.00,'2022-08-31 16:39:22','',''),(8241,'21','222','1',1,'Retail Sale Id 7221',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 17:02:38','',''),(8242,'21','222','1',1,'Retail Sale Id 7222',4999.68,0.00,0.00,6.72,0.00,'2022-08-31 17:09:16','',''),(8243,'21','222','1',1,'Retail Sale Id 7223',8928.00,0.00,0.00,12.00,0.00,'2022-08-31 17:10:27','',''),(8244,'21','222','1',1,'Retail Sale Id 7224',2232.00,0.00,0.00,3.00,0.00,'2022-08-31 17:17:05','',''),(8245,'21','222','1',1,'Retail Sale Id 7226',3496.80,0.00,0.00,4.70,0.00,'2022-08-31 17:40:45','',''),(8246,'21','222','1',1,'Retail Sale Id 7227',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 17:46:42','',''),(8247,'21','222','1',1,'Retail Sale Id 7228',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 17:47:19','',''),(8248,'21','222','1',1,'Retail Sale Id 7229',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 17:47:44','',''),(8249,'21','222','1',1,'Retail Sale Id 7230',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 18:51:41','',''),(8250,'21','222','1',1,'Retail Sale Id 7231',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 19:30:58','',''),(8251,'21','222','1',1,'Retail Sale Id 7232',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:31:28','',''),(8252,'21','222','1',1,'Retail Sale Id 7233',7440.00,0.00,0.00,10.00,0.00,'2022-08-31 19:32:03','',''),(8253,'21','222','1',1,'Retail Sale Id 7234',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:32:30','',''),(8254,'21','222','1',1,'Retail Sale Id 7235',1488.00,0.00,0.00,2.00,0.00,'2022-08-31 19:33:00','',''),(8255,'21','222','1',1,'Retail Sale Id 7236',7440.00,0.00,0.00,10.00,0.00,'2022-08-31 19:33:40','',''),(8256,'21','222','1',1,'Retail Sale Id 7236',18600.00,0.00,0.00,25.00,0.00,'2022-08-31 19:33:40','',''),(8257,'21','222','1',1,'Retail Sale Id 7237',3720.00,0.00,0.00,5.00,0.00,'2022-08-31 19:34:02','',''),(8258,'21','222','1',1,'Retail Sale Id 7238',7001.04,0.00,0.00,9.41,0.00,'2022-08-31 19:34:31','',''),(8259,'21','222','1',1,'Retail Sale Id 7239',4464.00,0.00,0.00,6.00,0.00,'2022-08-31 19:34:54','',''),(8260,'21','222','1',1,'Retail Sale Id 7240',2232.00,0.00,0.00,3.00,0.00,'2022-08-31 19:35:17','',''),(8261,'21','222','1',1,'Retail Sale Id 7241',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:35:45','',''),(8262,'21','222','1',1,'Retail Sale Id 7241',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:35:45','',''),(8263,'21','222','1',1,'Retail Sale Id 7242',9002.40,0.00,0.00,12.10,0.00,'2022-08-31 19:36:09','',''),(8264,'21','222','1',1,'Retail Sale Id 7243',2998.32,0.00,0.00,4.03,0.00,'2022-08-31 19:36:43','',''),(8265,'21','222','1',1,'Retail Sale Id 7244',4999.68,0.00,0.00,6.72,0.00,'2022-08-31 19:37:36','',''),(8266,'21','222','1',1,'Retail Sale Id 7245',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:38:02','',''),(8267,'21','222','1',1,'Retail Sale Id 7246',37200.00,0.00,0.00,50.00,0.00,'2022-08-31 19:38:25','',''),(8268,'21','222','1',1,'Retail Sale Id 7247',2499.84,0.00,0.00,3.36,0.00,'2022-08-31 19:38:51','',''),(8269,'21','222','1',1,'Retail Sale Id 7248',7834.32,0.00,0.00,10.53,0.00,'2022-08-31 19:39:24','',''),(8270,'21','222','1',1,'Retail Sale Id 7249',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:39:47','',''),(8271,'21','222','1',1,'Retail Sale Id 7250',996.96,0.00,0.00,1.34,0.00,'2022-08-31 19:40:05','',''),(8272,'21','222','1',1,'Return of Retail Sale Id 7246',0.00,37200.00,50.00,0.00,0.00,'2022-08-31 19:44:17','',''),(8273,'21','222','1',1,'Return of Retail Sale Id 7250',0.00,996.96,1.34,0.00,0.00,'2022-08-31 19:45:36','',''),(8274,'21','222','1',1,'Retail Sale Id 7251',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:46:54','',''),(8275,'21','222','1',1,'Retail Sale Id 7253',1197.84,0.00,0.00,1.61,0.00,'2022-08-31 19:47:38','',''),(8276,'21','222','1',1,'Retail Sale Id 7254',3720.00,0.00,0.00,5.00,0.00,'2022-08-31 19:47:54','',''),(8277,'21','222','1',1,'Retail Sale Id 7255',8496.48,0.00,0.00,11.42,0.00,'2022-08-31 19:48:19','',''),(8278,'21','222','1',1,'Retail Sale Id 7256',1488.00,0.00,0.00,2.00,0.00,'2022-08-31 19:48:42','',''),(8279,'21','222','1',1,'Retail Sale Id 7257',5208.00,0.00,0.00,7.00,0.00,'2022-08-31 19:49:07','',''),(8280,'21','222','1',1,'Retail Sale Id 7258',11160.00,0.00,0.00,15.00,0.00,'2022-08-31 19:49:41','',''),(8281,'21','222','1',1,'Retail Sale Id 7259',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:50:07','',''),(8282,'21','222','1',1,'Retail Sale Id 7260',5401.44,0.00,0.00,7.26,0.00,'2022-08-31 19:50:34','',''),(8283,'21','222','1',1,'Retail Sale Id 7261',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:51:15','',''),(8284,'21','222','1',1,'Retail Sale Id 7261',37200.00,0.00,0.00,50.00,0.00,'2022-08-31 19:51:15','',''),(8285,'21','222','1',1,'Retail Sale Id 7262',2232.00,0.00,0.00,3.00,0.00,'2022-08-31 19:51:57','',''),(8286,'21','222','1',1,'Retail Sale Id 7263',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:52:31','',''),(8287,'21','222','1',1,'Retail Sale Id 7264',7440.00,0.00,0.00,10.00,0.00,'2022-08-31 19:53:31','',''),(8288,'21','222','1',1,'Retail Sale Id 7264',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:53:31','',''),(8289,'21','222','1',1,'Retail Sale Id 7265',9300.00,0.00,0.00,12.50,0.00,'2022-08-31 19:53:52','',''),(8290,'21','222','1',1,'Retail Sale Id 7266',744.00,0.00,0.00,1.00,0.00,'2022-08-31 19:54:09','',''),(8291,'21','222','1',1,'Retail Sale Id 7267',3720.00,0.00,0.00,5.00,0.00,'2022-08-31 19:54:32','',''),(8292,'21','222','1',1,'Retail Sale Id 7268',18600.00,0.00,0.00,25.00,0.00,'2022-08-31 19:55:09','',''),(8293,'21','222','1',1,'Retail Sale Id 7268',37200.00,0.00,0.00,50.00,0.00,'2022-08-31 19:55:09','',''),(8294,'21','222','1',1,'Retail Sale Id 7269',996.96,0.00,0.00,1.34,0.00,'2022-08-31 19:55:51','',''),(8295,'21','222','1',1,'Retail Sale Id 7269',996.96,0.00,0.00,1.34,0.00,'2022-08-31 19:55:51','',''),(8296,'21','222','1',1,'Retail Sale Id 7269',996.96,0.00,0.00,1.34,0.00,'2022-08-31 19:55:51','',''),(8297,'21','222','1',1,'Retail Sale Id 7270',14999.04,0.00,0.00,20.16,0.00,'2022-08-31 19:57:32','',''),(8298,'21','222','1',1,'Retail Sale Id 7272',6115.68,0.00,0.00,8.22,0.00,'2022-08-31 19:58:47','',''),(8299,'21','222','1',1,'Retail Sale Id 7273',7440.00,0.00,0.00,10.00,0.00,'2022-09-01 07:51:33','',''),(8300,'21','222','1',1,'Retail Sale Id 7275',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 08:58:39','',''),(8301,'21','222','1',1,'Retail Sale Id 7276',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 09:03:38','',''),(8302,'21','222','1',1,'Retail Sale Id 7277',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 09:04:31','',''),(8303,'21','222','1',1,'Retail Sale Id 7278',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 09:05:29','',''),(8304,'21','222','1',1,'Retail Sale Id 7279',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 09:06:22','',''),(8305,'21','222','1',1,'Retail Sale Id 7280',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 09:07:16','',''),(8306,'21','222','1',1,'Retail Sale Id 7281',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:16:21','',''),(8307,'21','222','1',1,'Retail Sale Id 7282',7440.00,0.00,0.00,10.00,0.00,'2022-09-02 10:17:27','',''),(8308,'21','222','1',1,'Retail Sale Id 7283',13392.00,0.00,0.00,18.00,0.00,'2022-09-02 10:18:32','',''),(8309,'21','222','1',1,'Retail Sale Id 7284',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 10:19:31','',''),(8310,'21','222','1',1,'Retail Sale Id 7285',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 10:20:33','',''),(8311,'21','222','1',1,'Retail Sale Id 7286',1488.00,0.00,0.00,2.00,0.00,'2022-09-02 10:21:25','',''),(8312,'21','222','1',1,'Retail Sale Id 7287',967.20,0.00,0.00,1.30,0.00,'2022-09-02 10:22:16','',''),(8313,'21','222','1',1,'Retail Sale Id 7288',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 10:22:56','',''),(8314,'21','222','1',1,'Retail Sale Id 7289',3720.00,0.00,0.00,5.00,0.00,'2022-09-02 10:23:46','',''),(8315,'21','222','1',1,'Retail Sale Id 7290',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:24:29','',''),(8316,'21','222','1',1,'Retail Sale Id 7291',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:25:21','',''),(8317,'21','222','1',1,'Retail Sale Id 7292',2976.00,0.00,0.00,4.00,0.00,'2022-09-02 10:26:15','',''),(8318,'21','222','1',1,'Retail Sale Id 7293',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:26:52','',''),(8319,'21','222','1',1,'Retail Sale Id 7294',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:27:34','',''),(8320,'21','222','1',1,'Retail Sale Id 7295',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:28:24','',''),(8321,'21','222','1',1,'Retail Sale Id 7296',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:28:58','',''),(8322,'21','222','1',1,'Retail Sale Id 7297',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:29:36','',''),(8323,'21','222','1',1,'Retail Sale Id 7298',7440.00,0.00,0.00,10.00,0.00,'2022-09-02 10:30:35','',''),(8324,'21','222','1',1,'Retail Sale Id 7299',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 10:31:35','',''),(8325,'21','222','1',1,'Retail Sale Id 7300',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 10:32:19','',''),(8326,'21','222','1',1,'Retail Sale Id 7301',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:33:28','',''),(8327,'21','222','1',1,'Retail Sale Id 7302',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:34:06','',''),(8328,'21','222','1',1,'Retail Sale Id 7303',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:34:51','',''),(8329,'21','222','1',1,'Retail Sale Id 7304',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:35:33','',''),(8330,'21','222','1',1,'Retail Sale Id 7305',11160.00,0.00,0.00,15.00,0.00,'2022-09-02 10:36:29','',''),(8331,'21','222','1',1,'Retail Sale Id 7306',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:37:38','',''),(8332,'21','222','1',1,'Retail Sale Id 7307',37200.00,0.00,0.00,50.00,0.00,'2022-09-02 10:38:47','',''),(8333,'21','222','1',1,'Retail Sale Id 7308',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 10:39:19','',''),(8334,'21','222','1',1,'Retail Sale Id 7309',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:40:05','',''),(8335,'21','222','1',1,'Retail Sale Id 7309',18600.00,0.00,0.00,25.00,0.00,'2022-09-02 10:40:05','',''),(8336,'21','222','1',1,'Retail Sale Id 7310',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:41:50','',''),(8337,'21','222','1',1,'Retail Sale Id 7311',1488.00,0.00,0.00,2.00,0.00,'2022-09-02 10:42:36','',''),(8338,'21','222','1',1,'Retail Sale Id 7312',1026.72,0.00,0.00,1.38,0.00,'2022-09-02 10:43:26','',''),(8339,'21','222','1',1,'Retail Sale Id 7313',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:44:23','',''),(8340,'21','222','1',1,'Retail Sale Id 7314',12893.52,0.00,0.00,17.33,0.00,'2022-09-02 10:45:33','',''),(8341,'21','222','1',1,'Retail Sale Id 7315',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:46:30','',''),(8342,'21','222','1',1,'Retail Sale Id 7315',37200.00,0.00,0.00,50.00,0.00,'2022-09-02 10:46:30','',''),(8343,'21','222','1',1,'Retail Sale Id 7316',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:47:30','',''),(8344,'21','222','1',1,'Retail Sale Id 7317',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:49:04','',''),(8345,'21','222','1',1,'Retail Sale Id 7318',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 10:49:56','',''),(8346,'21','222','1',1,'Retail Sale Id 7319',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:50:42','',''),(8347,'21','222','1',1,'Retail Sale Id 7320',8184.00,0.00,0.00,11.00,0.00,'2022-09-02 10:58:45','',''),(8348,'21','222','1',1,'Retail Sale Id 7321',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 10:59:51','',''),(8349,'21','222','1',1,'Retail Sale Id 7322',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 11:00:29','',''),(8350,'21','222','1',1,'Retail Sale Id 7323',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 11:02:00','',''),(8351,'21','222','1',1,'Retail Sale Id 7324',996.96,0.00,0.00,1.34,0.00,'2022-09-02 11:02:46','',''),(8352,'21','222','1',1,'Retail Sale Id 7325',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:03:40','',''),(8353,'21','222','1',1,'Retail Sale Id 7326',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:04:19','',''),(8354,'21','222','1',1,'Retail Sale Id 7327',11160.00,0.00,0.00,15.00,0.00,'2022-09-02 11:05:01','',''),(8355,'21','222','1',1,'Retail Sale Id 7328',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:06:49','',''),(8356,'21','222','1',1,'Retail Sale Id 7329',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 11:08:45','',''),(8357,'21','222','1',1,'Retail Sale Id 7330',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:09:49','',''),(8358,'21','222','1',1,'Retail Sale Id 7331',3720.00,0.00,0.00,5.00,0.00,'2022-09-02 11:10:41','',''),(8359,'21','222','1',1,'Retail Sale Id 7332',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 11:11:24','',''),(8360,'21','222','1',1,'Retail Sale Id 7333',2976.00,0.00,0.00,4.00,0.00,'2022-09-02 11:12:20','',''),(8361,'21','222','1',1,'Retail Sale Id 7334',1488.00,0.00,0.00,2.00,0.00,'2022-09-02 11:13:09','',''),(8362,'21','222','1',1,'Retail Sale Id 7335',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:14:49','',''),(8363,'21','222','1',1,'Retail Sale Id 7336',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:16:01','',''),(8364,'21','222','1',1,'Retail Sale Id 7337',8184.00,0.00,0.00,11.00,0.00,'2022-09-02 11:16:32','',''),(8365,'21','222','1',1,'Retail Sale Id 7338',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:19:20','',''),(8366,'21','222','1',1,'Retail Sale Id 7339',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:19:57','',''),(8367,'21','222','1',1,'Retail Sale Id 7340',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:21:51','',''),(8368,'21','222','1',1,'Retail Sale Id 7341',3720.00,0.00,0.00,5.00,0.00,'2022-09-02 11:22:35','',''),(8369,'21','222','1',1,'Retail Sale Id 7342',37200.00,0.00,0.00,50.00,0.00,'2022-09-02 11:23:23','',''),(8370,'21','222','1',1,'Retail Sale Id 7343',6696.00,0.00,0.00,9.00,0.00,'2022-09-02 11:24:44','',''),(8371,'21','222','1',1,'Retail Sale Id 7344',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 11:25:52','',''),(8372,'21','222','1',1,'Retail Sale Id 7344',11160.00,0.00,0.00,15.00,0.00,'2022-09-02 11:25:52','',''),(8373,'21','222','1',1,'Retail Sale Id 7345',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:26:25','',''),(8374,'21','222','1',1,'Retail Sale Id 7346',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 11:27:01','',''),(8375,'21','222','1',1,'Retail Sale Id 7347',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 11:27:41','',''),(8376,'21','222','1',1,'Retail Sale Id 7348',2976.00,0.00,0.00,4.00,0.00,'2022-09-02 11:28:25','',''),(8377,'21','222','1',1,'Retail Sale Id 7349',7998.00,0.00,0.00,10.75,0.00,'2022-09-02 11:29:02','',''),(8378,'21','222','1',1,'Retail Sale Id 7350',2998.32,0.00,0.00,4.03,0.00,'2022-09-02 11:29:37','',''),(8379,'21','222','1',1,'Retail Sale Id 7351',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:30:00','',''),(8380,'21','222','1',1,'Retail Sale Id 7352',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:30:29','',''),(8381,'21','222','1',1,'Retail Sale Id 7353',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:31:03','',''),(8382,'21','222','1',1,'Retail Sale Id 7354',8928.00,0.00,0.00,12.00,0.00,'2022-09-02 11:31:36','',''),(8383,'21','222','1',1,'Retail Sale Id 7355',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 11:32:28','',''),(8384,'21','222','1',1,'Retail Sale Id 7355',14880.00,0.00,0.00,20.00,0.00,'2022-09-02 11:32:28','',''),(8385,'21','222','1',1,'Retail Sale Id 7356',3496.80,0.00,0.00,4.70,0.00,'2022-09-02 11:32:59','',''),(8386,'21','222','1',1,'Retail Sale Id 7357',37200.00,0.00,0.00,50.00,0.00,'2022-09-02 11:33:22','',''),(8387,'21','222','1',1,'Retail Sale Id 7358',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:34:10','',''),(8388,'21','222','1',1,'Retail Sale Id 7359',3720.00,0.00,0.00,5.00,0.00,'2022-09-02 11:35:00','',''),(8389,'21','222','1',1,'Retail Sale Id 7360',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:35:46','',''),(8390,'21','222','1',1,'Retail Sale Id 7360',37200.00,0.00,0.00,50.00,0.00,'2022-09-02 11:35:46','',''),(8391,'21','222','1',1,'Retail Sale Id 7361',6696.00,0.00,0.00,9.00,0.00,'2022-09-02 11:36:49','',''),(8392,'21','222','1',1,'Retail Sale Id 7362',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:37:32','',''),(8393,'21','222','1',1,'Retail Sale Id 7363',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:38:15','',''),(8394,'21','222','1',1,'Retail Sale Id 7364',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 11:39:31','',''),(8395,'21','222','1',1,'Retail Sale Id 7365',4464.00,0.00,0.00,6.00,0.00,'2022-09-02 11:40:34','',''),(8396,'21','222','1',1,'Retail Sale Id 7366',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:41:41','',''),(8397,'21','222','1',1,'Retail Sale Id 7367',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:42:25','',''),(8398,'21','222','1',1,'Retail Sale Id 7368',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:43:31','',''),(8399,'21','222','1',1,'Retail Sale Id 7368',18600.00,0.00,0.00,25.00,0.00,'2022-09-02 11:43:31','',''),(8400,'21','222','1',1,'Retail Sale Id 7368',37200.00,0.00,0.00,50.00,0.00,'2022-09-02 11:43:31','',''),(8401,'21','222','1',1,'Retail Sale Id 7369',3720.00,0.00,0.00,5.00,0.00,'2022-09-02 11:44:15','',''),(8402,'21','222','1',1,'Retail Sale Id 7370',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:44:53','',''),(8403,'21','222','1',1,'Retail Sale Id 7371',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:45:33','',''),(8404,'21','222','1',1,'Retail Sale Id 7372',1488.00,0.00,0.00,2.00,0.00,'2022-09-02 11:46:09','',''),(8405,'21','222','1',1,'Retail Sale Id 7373',7440.00,0.00,0.00,10.00,0.00,'2022-09-02 11:46:46','',''),(8406,'21','222','1',1,'Retail Sale Id 7374',8928.00,0.00,0.00,12.00,0.00,'2022-09-02 11:47:29','',''),(8408,'21','222','1',1,'Retail Sale Id 7376',11160.00,0.00,0.00,15.00,0.00,'2022-09-02 11:49:54','',''),(8409,'21','222','1',1,'Retail Sale Id 7377',2232.00,0.00,0.00,3.00,0.00,'2022-09-02 11:50:23','',''),(8410,'21','222','1',1,'Retail Sale Id 7378',3720.00,0.00,0.00,5.00,0.00,'2022-09-02 11:50:50','',''),(8411,'21','222','1',1,'Retail Sale Id 7379',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:51:21','',''),(8412,'21','222','1',1,'Retail Sale Id 7380',4999.68,0.00,0.00,6.72,0.00,'2022-09-02 11:52:04','',''),(8413,'21','222','1',1,'Retail Sale Id 7381',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:52:30','',''),(8414,'21','222','1',1,'Retail Sale Id 7382',9300.00,0.00,0.00,12.50,0.00,'2022-09-02 11:52:59','',''),(8415,'21','222','1',1,'Retail Sale Id 7383',1488.00,0.00,0.00,2.00,0.00,'2022-09-02 11:53:39','',''),(8416,'21','222',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3720000.00,5000.00,0.00,0.00,'2022-09-03 15:21:33','',''),(8417,'21','222',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,4999.00,0.00,'2022-09-03 15:26:11','',''),(8418,'21','222','1',1,'Received from bridging 54',0.00,0.00,4999.00,0.00,0.00,'2022-09-03 15:26:11','',''),(8419,'21','222','1',1,'Retail Sale Id 7384',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 12:56:57','',''),(8420,'21','222','1',1,'Retail Sale Id 7385',18600.00,0.00,0.00,25.00,0.00,'2022-09-05 12:59:01','',''),(8421,'21','222','1',1,'Retail Sale Id 7386',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 13:00:17','',''),(8422,'21','222','1',1,'Retail Sale Id 7387',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 13:02:08','',''),(8423,'21','222','1',1,'Retail Sale Id 7389',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 13:52:15','',''),(8424,'21','222','1',1,'Retail Sale Id 7390',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 13:55:43','',''),(8425,'21','222','1',1,'Retail Sale Id 7391',11160.00,0.00,0.00,15.00,0.00,'2022-09-05 14:20:40','',''),(8426,'21','222','1',1,'Retail Sale Id 7392',7440.00,0.00,0.00,10.00,0.00,'2022-09-05 14:22:32','',''),(8427,'21','222','1',1,'Retail Sale Id 7393',14880.00,0.00,0.00,20.00,0.00,'2022-09-05 14:23:57','',''),(8428,'21','222','1',1,'Retail Sale Id 7394',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 14:25:38','',''),(8429,'21','222','1',1,'Retail Sale Id 7395',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 14:30:32','',''),(8430,'21','222','1',1,'Retail Sale Id 7396',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 14:33:15','',''),(8431,'21','222','1',1,'Retail Sale Id 7398',33480.00,0.00,0.00,45.00,0.00,'2022-09-05 14:35:41','',''),(8432,'21','222','1',1,'Retail Sale Id 7399',4464.00,0.00,0.00,6.00,0.00,'2022-09-05 14:36:55','',''),(8433,'21','222','1',1,'Retail Sale Id 7400',22320.00,0.00,0.00,30.00,0.00,'2022-09-05 14:38:17','',''),(8434,'21','222','1',1,'Retail Sale Id 7401',11160.00,0.00,0.00,15.00,0.00,'2022-09-05 14:40:51','',''),(8435,'21','222','1',1,'Retail Sale Id 7402',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 14:44:10','',''),(8436,'21','222','1',1,'Retail Sale Id 7403',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 14:46:45','',''),(8437,'21','222','1',1,'Retail Sale Id 7405',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 21:06:57','',''),(8438,'21','222','1',1,'Retail Sale Id 7407',14880.00,0.00,0.00,20.00,0.00,'2022-09-05 21:09:42','',''),(8439,'21','222','1',1,'Retail Sale Id 7408',11160.00,0.00,0.00,15.00,0.00,'2022-09-05 21:11:59','',''),(8440,'21','222','1',1,'Retail Sale Id 7409',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 21:13:41','',''),(8441,'21','222','1',1,'Retail Sale Id 7410',83603.28,0.00,0.00,112.37,0.00,'2022-09-05 21:15:26','',''),(8442,'21','222','1',1,'Retail Sale Id 7411',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 21:19:19','',''),(8443,'21','222','1',1,'Retail Sale Id 7412',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 21:20:59','',''),(8444,'21','222','1',1,'Retail Sale Id 7413',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 21:28:05','',''),(8445,'21','222','1',1,'Retail Sale Id 7414',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 21:34:31','',''),(8446,'21','222','1',1,'Retail Sale Id 7415',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 21:36:02','',''),(8447,'21','222','1',1,'Retail Sale Id 7416',14880.00,0.00,0.00,20.00,0.00,'2022-09-05 21:37:26','',''),(8448,'21','222','1',1,'Retail Sale Id 7417',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 21:47:49','',''),(8449,'21','222','1',1,'Retail Sale Id 7418',18600.00,0.00,0.00,25.00,0.00,'2022-09-05 21:49:01','',''),(8450,'21','222','1',1,'Retail Sale Id 7419',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 21:51:56','',''),(8451,'21','222','1',1,'Retail Sale Id 7420',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 22:11:47','',''),(8452,'21','222','1',1,'Retail Sale Id 7421',14880.00,0.00,0.00,20.00,0.00,'2022-09-05 22:14:30','',''),(8453,'21','222','1',1,'Retail Sale Id 7423',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 22:16:26','',''),(8454,'21','222','1',1,'Retail Sale Id 7424',18600.00,0.00,0.00,25.00,0.00,'2022-09-05 22:18:24','',''),(8455,'21','222','1',1,'Retail Sale Id 7425',22320.00,0.00,0.00,30.00,0.00,'2022-09-05 22:19:59','',''),(8456,'21','222','1',1,'Retail Sale Id 7427',8928.00,0.00,0.00,12.00,0.00,'2022-09-05 22:22:03','',''),(8457,'21','222','1',1,'Retail Sale Id 7428',14880.00,0.00,0.00,20.00,0.00,'2022-09-05 22:23:41','',''),(8458,'21','222','1',1,'Retail Sale Id 7429',7440.00,0.00,0.00,10.00,0.00,'2022-09-05 22:25:11','',''),(8459,'21','222','1',1,'Retail Sale Id 7430',11160.00,0.00,0.00,15.00,0.00,'2022-09-05 22:27:03','',''),(8460,'21','222','1',1,'Retail Sale Id 7431',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 22:28:52','',''),(8461,'21','222','1',1,'Retail Sale Id 7432',8928.00,0.00,0.00,12.00,0.00,'2022-09-05 22:33:19','',''),(8462,'21','222','1',1,'Retail Sale Id 7433',14880.00,0.00,0.00,20.00,0.00,'2022-09-05 22:34:49','',''),(8463,'21','222','1',1,'Retail Sale Id 7434',11160.00,0.00,0.00,15.00,0.00,'2022-09-05 22:38:54','',''),(8464,'21','222','1',1,'Retail Sale Id 7435',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 22:45:32','',''),(8465,'21','222','1',1,'Retail Sale Id 7436',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 22:59:15','',''),(8466,'21','222','1',1,'Retail Sale Id 7437',37200.00,0.00,0.00,50.00,0.00,'2022-09-05 23:43:19','',''),(8467,'21','222','1',1,'Retail Sale Id 7438',9300.00,0.00,0.00,12.50,0.00,'2022-09-05 23:47:27','',''),(8468,'21','222','1',1,'Retail Sale Id 7439',22320.00,0.00,0.00,30.00,0.00,'2022-09-05 23:52:55','',''),(8469,'21','222','1',1,'Retail Sale Id 7440',2232.00,0.00,0.00,3.00,0.00,'2022-09-05 23:55:28','',''),(8470,'21','222','1',1,'Retail Sale Id 7441',5208.00,0.00,0.00,7.00,0.00,'2022-09-05 23:57:45','',''),(8471,'21','222','1',1,'Retail Sale Id 7443',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 00:01:29','',''),(8472,'21','222','1',1,'Retail Sale Id 7444',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 00:03:36','',''),(8473,'21','222','1',1,'Retail Sale Id 7445',18600.00,0.00,0.00,25.00,0.00,'2022-09-06 00:04:59','',''),(8474,'21','222','1',1,'Retail Sale Id 7446',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 00:06:48','',''),(8475,'21','222','1',1,'Retail Sale Id 7447',11160.00,0.00,0.00,15.00,0.00,'2022-09-06 00:09:38','',''),(8476,'21','222','1',1,'Retail Sale Id 7448',744.00,0.00,0.00,1.00,0.00,'2022-09-06 00:13:08','',''),(8477,'21','222','1',1,'Retail Sale Id 7449',105439.68,0.00,0.00,141.72,0.00,'2022-09-06 00:24:01','',''),(8478,'21','222','1',1,'Retail Sale Id 7450',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 00:26:28','',''),(8479,'21','222','1',1,'Retail Sale Id 7451',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 00:27:53','',''),(8480,'21','222','1',1,'Retail Sale Id 7453',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 00:30:41','',''),(8481,'21','222','1',1,'Retail Sale Id 7454',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 00:33:55','',''),(8482,'21','222','1',1,'Retail Sale Id 7455',37200.00,0.00,0.00,50.00,0.00,'2022-09-06 00:35:20','',''),(8483,'21','222','1',1,'Retail Sale Id 7459',33480.00,0.00,0.00,45.00,0.00,'2022-09-06 08:26:45','',''),(8484,'21','222','1',1,'Retail Sale Id 7460',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 08:28:00','',''),(8485,'21','222','1',1,'Retail Sale Id 7461',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 08:29:40','',''),(8486,'21','222','1',1,'Retail Sale Id 7462',11160.00,0.00,0.00,15.00,0.00,'2022-09-06 08:30:44','',''),(8487,'21','222','1',1,'Retail Sale Id 7466',9300.00,0.00,0.00,12.50,0.00,'2022-09-06 09:55:52','',''),(8488,'21','222','1',1,'Retail Sale Id 7467',37200.00,0.00,0.00,50.00,0.00,'2022-09-06 10:02:39','',''),(8489,'21','222','1',1,'Retail Sale Id 7468',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:38:57','',''),(8490,'21','222','1',1,'Retail Sale Id 7468',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:38:57','',''),(8491,'21','222','1',1,'Retail Sale Id 7469',2976.00,0.00,0.00,4.00,0.00,'2022-09-07 15:42:56','',''),(8492,'21','222','1',1,'Retail Sale Id 7469',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:42:56','',''),(8493,'21','222','1',1,'Retail Sale Id 7469',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:42:56','',''),(8494,'21','222','1',1,'Retail Sale Id 7470',2976.00,0.00,0.00,4.00,0.00,'2022-09-07 15:46:10','',''),(8495,'21','222','1',1,'Retail Sale Id 7470',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:46:10','',''),(8496,'21','222','1',1,'Retail Sale Id 7470',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:46:10','',''),(8497,'21','222','1',1,'Retail Sale Id 7471',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:48:19','',''),(8498,'21','222','1',1,'Retail Sale Id 7471',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:48:19','',''),(8499,'21','222','1',1,'Retail Sale Id 7471',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 15:48:19','',''),(8500,'21','222','1',1,'Return of Retail Sale Id 7471',0.00,9300.00,12.50,0.00,0.00,'2022-09-07 23:53:42','',''),(8501,'21','222','1',1,'Return of Retail Sale Id 7471',0.00,9300.00,12.50,0.00,0.00,'2022-09-07 23:53:42','',''),(8502,'21','222','1',1,'Return of Retail Sale Id 7471',0.00,9300.00,12.50,0.00,0.00,'2022-09-07 23:53:42','',''),(8503,'21','222','1',1,'Retail Sale Id 7472',2053.44,0.00,0.00,2.76,0.00,'2022-09-07 23:56:35','',''),(8504,'21','222','1',1,'Retail Sale Id 7473',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 23:58:34','',''),(8505,'21','222','1',1,'Retail Sale Id 7473',9300.00,0.00,0.00,12.50,0.00,'2022-09-07 23:58:34','',''),(8506,'21','222','1',1,'Retail Sale Id 7474',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:50:50','',''),(8507,'21','222','1',1,'Retail Sale Id 7474',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:50:50','',''),(8508,'21','222','1',1,'Retail Sale Id 7474',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 11:50:50','',''),(8509,'21','222','1',1,'Retail Sale Id 7475',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:52:16','',''),(8510,'21','222','1',1,'Retail Sale Id 7475',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:52:16','',''),(8511,'21','222','1',1,'Retail Sale Id 7475',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 11:52:16','',''),(8512,'21','222','1',1,'Retail Sale Id 7476',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:54:08','',''),(8513,'21','222','1',1,'Retail Sale Id 7476',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:54:08','',''),(8514,'21','222','1',1,'Retail Sale Id 7476',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 11:54:08','',''),(8515,'21','222','1',1,'Retail Sale Id 7477',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:55:19','',''),(8516,'21','222','1',1,'Retail Sale Id 7477',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:55:19','',''),(8517,'21','222','1',1,'Retail Sale Id 7477',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 11:55:19','',''),(8518,'21','222','1',1,'Retail Sale Id 7478',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:56:51','',''),(8519,'21','222','1',1,'Retail Sale Id 7478',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:56:51','',''),(8520,'21','222','1',1,'Retail Sale Id 7478',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 11:56:51','',''),(8521,'21','222','1',1,'Retail Sale Id 7479',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:57:57','',''),(8522,'21','222','1',1,'Retail Sale Id 7479',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:57:57','',''),(8523,'21','222','1',1,'Retail Sale Id 7479',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 11:57:57','',''),(8524,'21','222','1',1,'Retail Sale Id 7480',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:58:55','',''),(8525,'21','222','1',1,'Retail Sale Id 7480',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 11:58:55','',''),(8526,'21','222','1',1,'Retail Sale Id 7480',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 11:58:55','',''),(8527,'21','222','1',1,'Retail Sale Id 7481',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:00:04','',''),(8528,'21','222','1',1,'Retail Sale Id 7481',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:00:04','',''),(8529,'21','222','1',1,'Retail Sale Id 7481',37200.00,0.00,0.00,50.00,0.00,'2022-09-08 12:00:04','',''),(8530,'21','222','1',1,'Retail Sale Id 7482',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:01:15','',''),(8531,'21','222','1',1,'Retail Sale Id 7482',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:01:15','',''),(8532,'21','222','1',1,'Retail Sale Id 7482',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:01:15','',''),(8533,'21','222','1',1,'Retail Sale Id 7483',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:02:26','',''),(8534,'21','222','1',1,'Retail Sale Id 7483',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:02:26','',''),(8535,'21','222','1',1,'Retail Sale Id 7483',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:02:26','',''),(8536,'21','222','1',1,'Retail Sale Id 7484',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:03:19','',''),(8537,'21','222','1',1,'Retail Sale Id 7484',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:03:19','',''),(8538,'21','222','1',1,'Retail Sale Id 7484',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:03:19','',''),(8539,'21','222','1',1,'Retail Sale Id 7485',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:04:24','',''),(8540,'21','222','1',1,'Retail Sale Id 7485',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:04:24','',''),(8541,'21','222','1',1,'Retail Sale Id 7485',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:04:24','',''),(8542,'21','222','1',1,'Retail Sale Id 7486',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:06:12','',''),(8543,'21','222','1',1,'Retail Sale Id 7486',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:06:12','',''),(8544,'21','222','1',1,'Retail Sale Id 7486',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:06:12','',''),(8545,'21','222','1',1,'Retail Sale Id 7487',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:07:27','',''),(8546,'21','222','1',1,'Retail Sale Id 7487',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:07:27','',''),(8547,'21','222','1',1,'Retail Sale Id 7487',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:07:27','',''),(8548,'21','222','1',1,'Retail Sale Id 7488',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:08:20','',''),(8549,'21','222','1',1,'Retail Sale Id 7488',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:08:20','',''),(8550,'21','222','1',1,'Retail Sale Id 7488',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:08:20','',''),(8551,'21','222','1',1,'Retail Sale Id 7489',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:09:28','',''),(8552,'21','222','1',1,'Retail Sale Id 7489',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:09:28','',''),(8553,'21','222','1',1,'Retail Sale Id 7489',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:09:28','',''),(8554,'21','222','1',1,'Retail Sale Id 7490',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:13:26','',''),(8555,'21','222','1',1,'Retail Sale Id 7490',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:13:26','',''),(8556,'21','222','1',1,'Retail Sale Id 7490',37200.00,0.00,0.00,50.00,0.00,'2022-09-08 12:13:26','',''),(8557,'21','222','1',1,'Retail Sale Id 7491',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:15:34','',''),(8558,'21','222','1',1,'Retail Sale Id 7491',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:15:34','',''),(8559,'21','222','1',1,'Retail Sale Id 7491',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:15:34','',''),(8560,'21','222','1',1,'Retail Sale Id 7492',37200.00,0.00,0.00,50.00,0.00,'2022-09-08 12:17:14','',''),(8561,'21','222','1',1,'Retail Sale Id 7492',37200.00,0.00,0.00,50.00,0.00,'2022-09-08 12:17:15','',''),(8562,'21','222','1',1,'Retail Sale Id 7493',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:18:15','',''),(8563,'21','222','1',1,'Retail Sale Id 7493',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:18:15','',''),(8564,'21','222','1',1,'Retail Sale Id 7493',37200.00,0.00,0.00,50.00,0.00,'2022-09-08 12:18:15','',''),(8565,'21','222','1',1,'Retail Sale Id 7494',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:19:04','',''),(8566,'21','222','1',1,'Retail Sale Id 7494',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:19:04','',''),(8567,'21','222','1',1,'Retail Sale Id 7494',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:19:04','',''),(8568,'21','222','1',1,'Retail Sale Id 7495',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:19:59','',''),(8569,'21','222','1',1,'Retail Sale Id 7495',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:19:59','',''),(8570,'21','222','1',1,'Retail Sale Id 7495',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:19:59','',''),(8571,'21','222','1',1,'Retail Sale Id 7496',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:21:01','',''),(8572,'21','222','1',1,'Retail Sale Id 7496',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:21:01','',''),(8573,'21','222','1',1,'Retail Sale Id 7496',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:21:01','',''),(8574,'21','222','1',1,'Retail Sale Id 7497',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:21:52','',''),(8575,'21','222','1',1,'Retail Sale Id 7497',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:21:52','',''),(8576,'21','222','1',1,'Retail Sale Id 7497',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:21:52','',''),(8577,'21','222','1',1,'Retail Sale Id 7498',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:22:47','',''),(8578,'21','222','1',1,'Retail Sale Id 7498',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:22:47','',''),(8579,'21','222','1',1,'Retail Sale Id 7498',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:22:47','',''),(8580,'21','222','1',1,'Retail Sale Id 7499',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:24:07','',''),(8581,'21','222','1',1,'Retail Sale Id 7499',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:24:07','',''),(8582,'21','222','1',1,'Retail Sale Id 7499',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:24:07','',''),(8583,'21','222','1',1,'Retail Sale Id 7499',37200.00,0.00,0.00,50.00,0.00,'2022-09-08 12:24:07','',''),(8584,'21','222','1',1,'Retail Sale Id 7500',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:25:18','',''),(8585,'21','222','1',1,'Retail Sale Id 7500',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:25:18','',''),(8586,'21','222','1',1,'Retail Sale Id 7500',37200.00,0.00,0.00,50.00,0.00,'2022-09-08 12:25:18','',''),(8587,'21','222','1',1,'Retail Sale Id 7501',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:26:31','',''),(8588,'21','222','1',1,'Retail Sale Id 7501',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:26:31','',''),(8589,'21','222','1',1,'Retail Sale Id 7501',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:26:31','',''),(8590,'21','222','1',1,'Retail Sale Id 7502',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:27:42','',''),(8591,'21','222','1',1,'Retail Sale Id 7502',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:27:42','',''),(8592,'21','222','1',1,'Retail Sale Id 7502',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:27:42','',''),(8593,'21','222','1',1,'Retail Sale Id 7503',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:28:31','',''),(8594,'21','222','1',1,'Retail Sale Id 7503',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:28:31','',''),(8595,'21','222','1',1,'Retail Sale Id 7503',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:28:31','',''),(8596,'21','222','1',1,'Retail Sale Id 7504',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:30:06','',''),(8597,'21','222','1',1,'Retail Sale Id 7504',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:30:06','',''),(8598,'21','222','1',1,'Retail Sale Id 7504',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:30:06','',''),(8599,'21','222','1',1,'Retail Sale Id 7505',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:31:25','',''),(8600,'21','222','1',1,'Retail Sale Id 7505',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:31:25','',''),(8601,'21','222','1',1,'Retail Sale Id 7505',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:31:25','',''),(8602,'21','222','1',1,'Retail Sale Id 7506',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:32:37','',''),(8603,'21','222','1',1,'Retail Sale Id 7506',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:32:37','',''),(8604,'21','222','1',1,'Retail Sale Id 7506',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:32:37','',''),(8605,'21','222','1',1,'Retail Sale Id 7507',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:33:43','',''),(8606,'21','222','1',1,'Retail Sale Id 7507',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:33:43','',''),(8607,'21','222','1',1,'Retail Sale Id 7507',59520.00,0.00,0.00,80.00,0.00,'2022-09-08 12:33:43','',''),(8608,'21','222','1',1,'Retail Sale Id 7508',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:35:06','',''),(8609,'21','222','1',1,'Retail Sale Id 7508',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:35:07','',''),(8610,'21','222','1',1,'Retail Sale Id 7508',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:35:07','',''),(8611,'21','222','1',1,'Retail Sale Id 7509',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:36:12','',''),(8612,'21','222','1',1,'Retail Sale Id 7509',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:36:12','',''),(8613,'21','222','1',1,'Retail Sale Id 7509',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:36:12','',''),(8614,'21','222','1',1,'Retail Sale Id 7510',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:37:16','',''),(8615,'21','222','1',1,'Retail Sale Id 7510',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:37:16','',''),(8616,'21','222','1',1,'Retail Sale Id 7510',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:37:16','',''),(8617,'21','222','1',1,'Retail Sale Id 7511',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:38:23','',''),(8618,'21','222','1',1,'Retail Sale Id 7511',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:38:23','',''),(8619,'21','222','1',1,'Retail Sale Id 7511',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:38:23','',''),(8620,'21','222','1',1,'Retail Sale Id 7512',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:39:44','',''),(8621,'21','222','1',1,'Retail Sale Id 7512',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:39:44','',''),(8622,'21','222','1',1,'Retail Sale Id 7512',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:39:44','',''),(8623,'21','222','1',1,'Retail Sale Id 7513',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:41:05','',''),(8624,'21','222','1',1,'Retail Sale Id 7513',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:41:05','',''),(8625,'21','222','1',1,'Retail Sale Id 7513',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 12:41:05','',''),(8626,'21','222','1',1,'Retail Sale Id 7514',2112.96,0.00,0.00,2.84,0.00,'2022-09-08 12:43:44','',''),(8627,'21','222','1',1,'Retail Sale Id 7514',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:43:44','',''),(8628,'21','222','1',1,'Retail Sale Id 7514',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 12:43:44','',''),(8629,'21','222','1',1,'Retail Sale Id 7515',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:32:43','',''),(8630,'21','222','1',1,'Retail Sale Id 7515',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:32:43','',''),(8631,'21','222','1',1,'Retail Sale Id 7515',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 17:32:43','',''),(8632,'21','222','1',1,'Retail Sale Id 7516',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:33:33','',''),(8633,'21','222','1',1,'Retail Sale Id 7516',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:33:33','',''),(8634,'21','222','1',1,'Retail Sale Id 7516',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 17:33:33','',''),(8635,'21','222','1',1,'Retail Sale Id 7517',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:35:03','',''),(8636,'21','222','1',1,'Retail Sale Id 7517',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:35:03','',''),(8637,'21','222','1',1,'Retail Sale Id 7517',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 17:35:03','',''),(8638,'21','222','1',1,'Retail Sale Id 7518',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:36:33','',''),(8639,'21','222','1',1,'Retail Sale Id 7518',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:36:33','',''),(8640,'21','222','1',1,'Retail Sale Id 7518',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 17:36:33','',''),(8641,'21','222','1',1,'Retail Sale Id 7519',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:41:44','',''),(8642,'21','222','1',1,'Retail Sale Id 7519',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:41:44','',''),(8643,'21','222','1',1,'Retail Sale Id 7519',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 17:41:44','',''),(8644,'21','222','1',1,'Retail Sale Id 7520',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:43:56','',''),(8645,'21','222','1',1,'Retail Sale Id 7520',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:43:56','',''),(8646,'21','222','1',1,'Retail Sale Id 7520',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 17:43:56','',''),(8647,'21','222','1',1,'Retail Sale Id 7521',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:47:33','',''),(8648,'21','222','1',1,'Retail Sale Id 7521',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:47:33','',''),(8649,'21','222','1',1,'Retail Sale Id 7521',18600.00,0.00,0.00,25.00,0.00,'2022-09-08 17:47:33','',''),(8650,'21','222','1',1,'Retail Sale Id 7522',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:50:05','',''),(8651,'21','222','1',1,'Retail Sale Id 7522',9300.00,0.00,0.00,12.50,0.00,'2022-09-08 17:50:05','',''),(8652,'21','222','1',1,'Reta