-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_221
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_221`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_221` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_221`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,7000,'',0,'20','21','221','SALES','','2022-03-03 18:09:50',5,0.00,0.00,'','764','2022-03-03 18:09:50','764',0,0),(2,500,'',0,'6.1','21','221','CASH','','2022-03-03 18:10:07',5,0.00,0.00,'','764','2022-03-03 18:10:07','764',0,0),(3,8000,'',0,'24','21','221','SALARY & WAGES','','2022-03-03 18:10:26',5,0.00,0.00,'','764','2022-03-03 18:10:26','764',0,0),(4,8001,'',0,'24','21','221','PURCHASES','','2022-03-03 18:10:43',5,0.00,0.00,'','764','2022-03-03 18:10:43','764',0,0),(5,4000,'',0,'22','21','221','PURCHASES','','2022-03-03 23:41:33',5,0.00,0.00,'','764','2022-03-03 23:41:33','764',0,0),(6,8002,'',0,'24','21','221','SALARIES & WAGES','','2022-03-04 00:21:02',5,0.00,0.00,'','764','2022-03-04 00:21:02','764',0,0),(7,7001,'1',1,'20','21','221','POS fist Bank','','2022-03-22 20:13:29',5,0.00,0.00,'','771','2022-03-22 20:13:29','771',0,0),(8,7001,'7',2,'20','21','221','POS fist Bank','','2022-03-22 20:16:33',5,0.00,0.00,'','771','2022-03-22 20:16:33','771',0,0),(9,7001,'1',1,'20','21','221','POS fist Bank','first bank pos','2022-03-22 20:18:01',5,0.00,0.00,'','771','2022-03-22 20:18:01','771',0,0),(10,2500,'',0,'2','21','221','POS fist Bank ','','2022-03-22 20:25:08',5,0.00,0.00,'','771','2022-03-22 20:25:08','771',0,0),(11,2501,'',0,'2','21','221','POS stanbic IBTC','','2022-03-22 20:26:52',5,0.00,0.00,'','771','2022-03-22 20:26:52','771',0,0),(12,2502,'',0,'2','21','221','POS Sterling','','2022-03-22 20:27:16',5,0.00,0.00,'','771','2022-03-22 20:27:16','771',0,0),(13,2503,'',0,'2','21','221','POS GT','','2022-03-22 20:27:40',5,0.00,0.00,'','771','2022-03-22 20:27:40','771',0,0),(14,2504,'',0,'2','21','221','Transfer UBA','','2022-03-22 20:28:12',5,0.00,0.00,'','771','2022-03-22 20:28:12','771',0,0),(15,2505,'',0,'2','21','221','UBA Cheque','','2022-03-22 20:30:32',5,0.00,0.00,'','771','2022-03-22 20:30:32','771',0,0),(16,2506,'',0,'2','21','221','ZENITH BANK','','2022-03-22 20:41:45',5,0.00,0.00,'','764','2022-03-22 20:41:45','764',0,0),(17,2507,'',0,'2','21','221','Unity Bank','','2022-03-26 17:44:22',5,0.00,0.00,'','764','2022-03-26 17:44:22','764',0,0),(18,2508,'',0,'2','21','221','Unity Bank POS','','2022-03-26 17:44:31',5,0.00,0.00,'','764','2022-03-26 17:44:31','764',0,0),(19,2509,'',0,'2','21','221','UNITY Bank Transfer account ','','2022-03-26 17:44:40',5,0.00,0.00,'','764','2022-03-26 17:44:40','764',0,0),(20,2510,'',0,'2','21','221','Ecobank ','','2022-03-26 17:44:48',5,0.00,0.00,'','764','2022-03-26 17:44:48','764',0,0),(21,2511,'',0,'2','21','221','Ecobank POS','','2022-03-26 17:44:56',5,0.00,0.00,'','764','2022-03-26 17:44:56','764',0,0),(22,2512,'',0,'2','21','221','Ecobank Transfer account ','','2022-03-26 17:45:07',5,0.00,0.00,'','764','2022-03-26 17:45:07','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','21','221','ESTEEM BOYS COLLEGE LOKOGOMA','ESTEEM BOYS COLLEGE ','07037136254','info@esteemschools.com','ABJUA','ABUJA','PLOT 70. CADESTRAL ZONE LOKOGOMA ABUJA','Nigeria',800000.00,0.00,0.00,'0000-00-00','2022-04-09 12:44:50',5,'771','2022-04-09 12:44:50','771'),(2,'','21','221','NATIONAL JUDICIARY COMMITTEE (','ATTAHIRU ','08073819237','nationaljudiarycommittee@gmail','ABJUA','ABUJA','NATIONAL JUDICIARY COMMITTEE (NJC)','Nigeria',700000.00,0.00,0.00,'0000-00-00','2022-04-09 13:27:38',5,'771','2022-04-09 13:27:38','771'),(3,'','21','221','ALH. SANUSI NATIONAL ASSEMBLY','NATIONAL ASSEMBLY','08023213680','sanusi@gmail.com','ABJUA','ABUJA','NATIONAL ASSEMBLY','Nigeria',1800000.00,0.00,0.00,'0000-00-00','2022-04-09 13:30:04',5,'771','2022-04-09 13:30:04','771'),(4,'','21','221','WASTEPOINT','FEMI','08035953300','wastepoint@gmail.com','ABJUA','ABUJA','Gudu Market','Nigeria',1700000.00,0.00,0.00,'0000-00-00','2022-04-09 13:36:50',5,'771','2022-04-09 13:36:50','771'),(5,'','21','221','SUPREME COURT','ISMAIL','08034310774','ismail@gmail.com','ABJUA','ABUJA','SUPREME COURT','Nigeria',500000.00,0.00,0.00,'0000-00-00','2022-04-09 13:45:01',5,'771','2022-04-09 13:45:01','771');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','221',1,'2',28900.00,32000.00,'2022-03-21','','2022-03-22 19:31:36','771','771',2022,'771','2022-03-22 19:31:36',5),('21','221',2,'1',5853.07,7353.00,'2022-03-21','','2022-03-23 13:29:42','764','764',2022,'764','2022-03-23 13:29:42',5),('21','221',3,'2',666.80,3467.00,'2022-03-23','','2022-03-23 13:30:21','764','764',2022,'764','2022-03-23 13:30:21',5),('21','221',4,'3',1003.94,4604.00,'2022-03-21','','2022-03-23 13:30:57','764','764',2022,'764','2022-03-23 13:30:57',5),('21','221',5,'4',9538.92,9739.00,'2022-03-21','','2022-03-23 13:31:41','764','764',2022,'764','2022-03-23 13:31:41',5),('21','221',6,'5',0.00,600.00,'2022-03-21','','2022-03-23 13:32:00','764','764',2022,'764','2022-03-23 13:32:00',5),('21','221',7,'1',7353.00,16400.00,'2022-03-22','','2022-04-05 09:35:28','764','764',2022,'764','2022-04-05 09:35:28',5),('21','221',8,'2',3467.00,9100.00,'2022-04-22','','2022-04-05 09:36:20','764','764',2022,'764','2022-04-05 09:36:20',5),('21','221',9,'3',4604.00,12000.00,'2022-03-22','','2022-04-05 09:36:47','764','764',2022,'764','2022-04-05 09:36:47',5),('21','221',10,'4',9739.00,32100.00,'2022-03-22','','2022-04-05 09:37:29','764','764',2022,'764','2022-04-05 09:37:29',5),('21','221',11,'5',600.00,600.00,'2022-03-22','','2022-04-05 09:38:02','764','764',2022,'764','2022-04-05 09:38:02',5),('21','221',12,'2',45775.63,41014.00,'2022-03-26','','2022-04-06 08:33:31','764','764',2022,'764','2022-04-06 08:33:31',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','221','1',1,'5','PMS NOZZLE 1',4851057.69,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-06 14:52:00','764'),('21','221','1',2,'5','PMS NOZZLE 2',5404186.19,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:38:27','764'),('21','221','1',3,'5','PMS NOZZLE 3',4586403.80,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:48:04','764'),('21','221','1',4,'5','PMS NOZZLE 4',5874089.67,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:04:01','764'),('21','221','2',5,'5','PMS NOZZLE 7',4259410.48,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:04:30','764'),('21','221','2',6,'5','PMS NOZZLE 8',4839654.80,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:04:56','764'),('21','221','2',7,'5','PMS NOZZLE 11',2564942.79,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:05:22','764'),('21','221','2',8,'5','PMS NOZZLE 15',3554104.90,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-06 09:00:46','764'),('21','221','2',9,'5','PMS NOZZLE 12',5542439.29,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:06:08','764'),('21','221','2',10,'5','PMSNOZZLE  20',3888419.33,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:08:11','764'),('21','221','2',11,'5','PMS NOZZLE 16',4768368.88,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:07:01','764'),('21','221','2',12,'5','PMS NOZZLE 19',3478399.07,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-06 14:54:32','764'),('21','221','3',13,'5','PMS NOZZLE 6',4653677.21,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:09:20','764'),('21','221','3',14,'5','PMS NOZZLE 9',3598879.13,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:10:04','764'),('21','221','3',15,'5','PMS NOZZLE 10',4269852.13,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:11:05','764'),('21','221','3',16,'5','PMS NOZZLE 13',3555290.48,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:11:58','764'),('21','221','3',17,'5','PMS NOZZLE 14',3966996.71,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:12:31','764'),('21','221','3',18,'5','PMS NOZZLE 17',3682829.83,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:13:12','764'),('21','221','3',19,'5','PMS NOZZLE 5',4386127.10,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:08:46','764'),('21','221','4',20,'5','AGO NOZZLE 1A',2299015.40,'AGO DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:14:29','764'),('21','221','4',21,'5','AGO NOZZLE 1B',184810.83,'AGO DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:14:52','764'),('21','221','4',22,'5','AGO NOZZLE 2A',258.84,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-30 17:16:17','764'),('21','221','4',23,'5','AGO NOZZLE 2B',438069.50,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-29 13:58:21','764'),('21','221','5',24,'5','DPK NOZZLE 1A',414825.13,'DPK DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:16:20','764'),('21','221','5',25,'5','DPK NOZZLE 1B',78161.87,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-22 13:22:44','771'),('21','221','5',26,'5','DPK NOZZLE 2A',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('21','221','5',27,'5','DPK NOZZLE 2B',3376.17,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-22 13:23:26','771'),('21','221','3',28,'5','PMS NOZZLE 18',4151739.40,'PMS DISPENSER','',NULL,NULL,'',5,'2022-04-05 10:13:43','764');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','221',1,'DAILY','2022-03-22','2022-03-22 16:57:19','2022-03-23 16:57:19','771',21434578.05,21434578.05,'771','2022-03-22 19:37:49','771','2022-03-22 20:47:36',10,0),('21','221',2,'DAILY','2022-03-22','2022-03-22 20:48:21','2022-03-23 20:48:21','771',0.00,0.00,'764','2022-04-05 09:28:05','764','2022-04-05 10:00:31',10,0),('21','221',3,'DAILY','2022-03-23','2022-04-05 10:18:21','2022-04-06 10:18:21','771',0.00,0.00,'764','2022-04-05 10:37:20','764','2022-04-05 10:37:34',10,0),('21','221',4,'DAILY','2022-03-23','2022-04-05 10:39:10','2022-04-06 10:39:10','764',0.00,0.00,'764','2022-04-05 10:47:15','764','2022-04-05 10:47:30',10,0),('21','221',5,'DAILY','2022-03-23','2022-04-05 10:48:29','2022-04-06 10:48:29','764',16110151.30,16110151.30,'771','2022-04-05 11:13:27','771','2022-04-05 11:59:32',10,0),('21','221',6,'DAILY','2022-03-24','2022-04-05 12:24:08','2022-04-06 12:24:08','771',20752729.90,20752729.90,'771','2022-04-05 12:37:59','771','2022-04-05 13:01:26',10,0),('21','221',7,'DAILY','2022-03-25','2022-04-05 13:28:15','2022-04-06 13:28:15','771',12661998.75,12661998.75,'771','2022-04-05 13:47:16','771','2022-04-05 14:56:26',10,0),('21','221',8,'DAILY','2022-03-26','2022-04-05 15:19:46','2022-04-06 15:19:46','771',12013046.15,12013046.15,'771','2022-04-05 16:11:42','771','2022-04-05 16:14:01',10,0),('21','221',9,'DAILY','2022-03-27','2022-04-05 18:24:34','2022-04-06 18:24:34','771',0.00,0.00,'764','2022-04-06 08:58:56','764','2022-04-06 08:59:33',10,0),('21','221',10,'DAILY','2022-03-27','2022-04-06 15:09:55','2022-04-07 15:09:55','771',8697634.00,8697634.00,'771','2022-04-06 15:35:50','764','2022-04-06 16:44:45',10,0),('21','221',11,'DAILY','2022-03-28','2022-04-07 10:57:58','2022-04-08 10:57:58','771',26170042.65,26170042.65,'771','2022-04-07 11:35:21','764','2022-04-07 17:42:41',10,0),('21','221',12,'DAILY','2022-03-29','2022-04-09 13:55:16','2022-04-10 13:55:16','771',16867916.50,16867916.50,'771','2022-04-09 14:15:56','771','2022-04-09 14:25:09',10,0),('21','221',13,'DAILY','2022-03-30','2022-04-13 10:48:51','2022-04-14 10:48:51','771',17697227.10,17697227.10,'771','2022-04-13 11:22:09','764','2022-04-13 20:10:11',10,0),('21','221',14,'DAILY','2022-03-31','2022-04-14 09:55:06','2022-04-15 09:55:06','771',22214837.30,22214837.30,'771','2022-04-14 10:30:20','764','2022-04-14 15:09:51',10,0),('21','221',15,'DAILY','2022-04-01','2022-04-15 09:32:43','2022-04-16 09:32:43','771',0.00,0.00,'764','2022-04-16 10:55:20','764','2022-04-16 10:56:00',10,0),('21','221',16,'DAILY','2022-04-01','2022-04-16 11:08:05','2022-04-17 11:08:05','771',17198089.20,17198089.20,'771','2022-04-16 13:10:36','764','2022-04-16 16:18:27',10,0),('21','221',17,'DAILY','2022-04-02','2022-04-18 10:09:23','2022-04-19 10:09:23','771',16956890.05,16956890.05,'771','2022-04-18 10:49:58','764','2022-04-18 15:32:49',10,0),('21','221',18,'DAILY','2022-04-03','2022-04-18 15:38:19','2022-04-19 15:38:19','771',26381380.40,26381380.40,'771','2022-04-19 08:55:52','764','2022-04-19 09:44:05',10,0),('21','221',19,'DAILY','2022-04-04','2022-04-19 13:57:43','2022-04-20 13:57:43','771',16387183.80,16387183.80,'771','2022-04-19 14:31:35','764','2022-04-20 15:16:48',10,0),('21','221',20,'DAILY','2022-04-05','2022-04-20 17:12:36','2022-04-21 17:12:36','771',21712296.58,21712296.58,'771','2022-04-20 18:03:23','764','2022-04-21 08:26:48',10,0),('21','221',21,'DAILY','2022-04-06','2022-04-21 10:09:54','2022-04-22 10:09:54','771',19825081.79,19825081.79,'771','2022-04-21 10:39:42','764','2022-04-21 18:50:17',10,0),('21','221',22,'DAILY','2022-04-07','2022-04-22 09:54:33','2022-04-23 09:54:33','771',21435510.25,21435510.25,'771','2022-04-22 10:31:34','764','2022-04-22 11:43:06',10,0),('21','221',23,'DAILY','2022-04-08','2022-04-22 12:07:34','2022-04-23 12:07:34','771',17284401.75,17284401.75,'771','2022-04-22 12:33:58','764','2022-04-22 13:41:36',10,0),('21','221',24,'DAILY','2022-04-09','2022-04-22 15:01:03','2022-04-23 15:01:03','771',22972316.60,22972316.60,'771','2022-04-22 15:22:30','764','2022-04-22 16:40:11',10,0),('21','221',25,'DAILY','2022-04-10','2022-04-22 16:42:36','2022-04-23 16:42:36','771',16341269.50,16341269.50,'771','2022-04-22 17:59:22','764','2022-04-22 18:45:05',10,0),('21','221',26,'DAILY','2022-04-11','2022-04-22 19:57:55','2022-04-23 19:57:55','771',20520247.35,20520247.35,'771','2022-04-22 21:06:32','764','2022-04-23 08:38:38',10,0),('21','221',27,'DAILY','2022-04-12','2022-04-23 09:30:10','2022-04-24 09:30:10','771',20413793.80,20413793.80,'771','2022-04-23 10:01:37','764','2022-04-23 11:22:22',10,0),('21','221',28,'DAILY','2022-04-13','2022-04-23 11:57:43','2022-04-24 11:57:43','771',19517399.65,19517399.65,'771','2022-04-23 12:22:58','764','2022-04-23 14:05:41',10,0),('21','221',29,'DAILY','2022-04-14','2022-04-23 14:52:21','2022-04-24 14:52:21','771',19208114.00,19208114.00,'771','2022-04-23 16:08:14','764','2022-04-23 17:16:36',10,0),('21','221',30,'DAILY','2022-04-15','2022-04-24 09:50:20','2022-04-25 09:50:20','771',18244496.60,18244496.60,'771','2022-04-24 10:10:08','764','2022-04-24 10:50:39',10,0),('21','221',31,'DAILY','2022-04-16','2022-04-24 10:56:44','2022-04-25 10:56:44','771',15545733.05,15545733.05,'771','2022-04-24 11:27:47','764','2022-04-24 12:02:09',10,0),('21','221',32,'DAILY','2022-04-17','2022-04-24 13:49:14','2022-04-25 13:49:14','771',14154125.45,14154125.45,'771','2022-04-24 14:19:28','764','2022-04-24 14:51:01',10,0),('21','221',33,'DAILY','2022-04-18','2022-04-24 14:54:32','2022-04-25 14:54:32','771',13285650.20,13285650.20,'771','2022-04-24 15:17:53','764','2022-04-24 17:17:51',10,0),('21','221',34,'DAILY','2022-04-19','2022-04-24 17:39:52','2022-04-25 17:39:52','771',0.00,0.00,'764','2022-04-25 20:53:13','764','2022-04-25 20:54:06',10,0),('21','221',35,'DAILY','2022-04-19','2022-04-26 07:03:19','2022-04-27 07:03:19','771',13035270.25,13035270.25,'771','2022-04-26 08:00:15','764','2022-04-26 09:54:26',10,0),('21','221',36,'DAILY','2022-04-20','2022-04-26 09:59:13','2022-04-27 09:59:13','771',18644744.65,18644744.65,'771','2022-04-26 10:52:34','764','2022-04-26 11:45:39',10,0),('21','221',37,'DAILY','2022-04-21','2022-04-26 11:51:36','2022-04-27 11:51:36','771',18154562.15,18154562.15,'771','2022-04-26 12:38:43','764','2022-04-26 15:43:11',10,0),('21','221',38,'DAILY','2022-04-22','2022-04-26 16:21:42','2022-04-27 16:21:42','771',16554389.10,16554389.10,'771','2022-04-26 17:25:03','764','2022-04-26 20:36:33',10,0),('21','221',39,'DAILY','2022-04-23','2022-04-27 08:51:04','2022-04-28 08:51:04','771',15110521.50,15110521.50,'771','2022-04-27 09:27:22','764','2022-04-27 11:06:49',10,0),('21','221',40,'DAILY','2022-04-24','2022-04-27 11:09:18','2022-04-28 11:09:18','771',17747322.15,17747322.15,'771','2022-04-27 12:10:35','764','2022-04-27 12:54:38',10,0),('21','221',41,'DAILY','2022-04-25','2022-04-27 13:21:11','2022-04-28 13:21:11','771',17773645.00,17773645.00,'771','2022-04-27 14:01:27','764','2022-04-27 14:54:21',10,0),('21','221',42,'DAILY','2022-04-26','2022-04-27 16:57:56','2022-04-28 16:57:56','771',15341095.95,15341095.95,'764','2022-04-28 11:45:30','764','2022-04-28 14:05:36',10,0),('21','221',43,'DAILY','2022-04-27','2022-04-29 12:13:52','2022-04-30 12:13:52','771',21298491.75,21298491.75,'771','2022-04-29 12:34:08','764','2022-04-29 19:28:27',10,0),('21','221',44,'DAILY','2022-04-28','2022-05-01 10:10:52','2022-05-02 10:10:52','771',15065160.55,15065160.55,'771','2022-05-01 11:15:40','764','2022-05-01 13:31:03',10,0),('21','221',45,'DAILY','2022-04-29','2022-05-01 14:45:19','2022-05-02 14:45:19','771',17624345.25,17624345.25,'771','2022-05-01 15:11:06','764','2022-05-01 17:27:52',10,0),('21','221',46,'DAILY','2022-04-30','2022-05-01 20:41:03','2022-05-02 20:41:03','771',18016152.25,18016152.25,'771','2022-05-02 16:38:50','764','2022-05-02 18:08:00',10,0),('21','221',47,'DAILY','2022-05-01','2022-05-02 18:57:29','2022-05-03 18:57:29','771',12750892.40,12750892.40,'771','2022-05-02 19:23:44','764','2022-05-03 22:07:56',10,0),('21','221',48,'DAILY','2022-05-02','2022-05-04 15:04:38','2022-05-05 15:04:38','771',13979100.25,13979100.25,'771','2022-05-04 15:38:59','764','2022-05-04 16:26:15',10,0),('21','221',49,'DAILY','2022-05-03','2022-05-04 18:32:49','2022-05-05 18:32:49','771',0.00,0.00,'764','2022-05-08 18:25:04','764','2022-05-08 18:42:31',10,0),('21','221',50,'DAILY','2022-05-03','2022-05-08 19:12:20','2022-05-09 19:12:20','771',19642392.85,19642392.85,'771','2022-05-08 19:58:44','764','2022-05-08 20:42:05',10,0),('21','221',51,'DAILY','2022-05-04','2022-05-09 11:27:59','2022-05-10 11:27:59','771',13467366.40,13467366.40,'771','2022-05-09 12:03:57','764','2022-05-09 15:33:18',10,0),('21','221',52,'DAILY','2022-05-05','2022-05-09 16:33:10','2022-05-10 16:33:10','771',20437840.10,20437840.10,'771','2022-05-09 18:12:08','764','2022-05-09 19:07:54',10,0),('21','221',53,'DAILY','2022-05-06','2022-05-10 11:14:07','2022-05-11 11:14:07','771',17466686.90,17466686.90,'771','2022-05-10 11:36:05','764','2022-05-10 12:46:33',10,0),('21','221',54,'DAILY','2022-05-07','2022-05-10 16:16:12','2022-05-11 16:16:12','771',16118053.40,16118053.40,'771','2022-05-10 17:14:55','764','2022-05-10 17:48:12',10,0),('21','221',55,'DAILY','2022-05-08','2022-05-11 18:25:46','2022-05-12 18:25:46','771',13058773.40,13058773.40,'771','2022-05-11 18:46:58','764','2022-05-12 18:46:07',10,0),('21','221',56,'DAILY','2022-05-09','2022-05-14 11:06:33','2022-05-15 11:06:33','771',0.00,0.00,'764','2022-05-15 12:03:38','764','2022-05-15 12:04:05',10,0),('21','221',57,'DAILY','2022-05-09','2022-05-16 09:00:22','2022-05-17 09:00:22','771',20162265.50,20162265.50,'771','2022-05-16 10:44:12','764','2022-05-16 15:13:38',10,0),('21','221',58,'DAILY','2022-05-10','2022-05-16 15:40:13','2022-05-17 15:40:13','771',24660800.20,24660800.20,'771','2022-05-16 16:41:24','764','2022-05-16 18:32:54',10,0),('21','221',59,'DAILY','2022-05-11','2022-05-17 10:05:22','2022-05-18 10:05:22','771',14661838.60,14661838.60,'771','2022-05-17 10:33:34','764','2022-05-17 20:13:03',10,0),('21','221',60,'DAILY','2022-05-12','2022-05-19 11:54:18','2022-05-20 11:54:18','771',0.00,0.00,'771','2022-05-19 12:43:01','764','2022-05-19 12:45:29',10,0),('21','221',61,'DAILY','2022-05-12','2022-05-19 12:53:37','2022-05-20 12:53:37','771',18174029.70,18174029.70,'771','2022-05-19 17:03:06','764','2022-05-19 17:57:30',10,0),('21','221',62,'DAILY','2022-05-13','2022-05-19 18:10:45','2022-05-20 18:10:45','771',25720573.85,25720573.85,'771','2022-05-19 18:25:25','764','2022-05-19 19:21:48',10,0),('21','221',63,'DAILY','2022-05-14','2022-05-19 19:58:38','2022-05-20 19:58:38','771',27211182.35,27211182.35,'771','2022-05-19 20:12:55','764','2022-05-20 11:38:51',10,0),('21','221',64,'DAILY','2022-05-15','2022-05-20 12:11:29','2022-05-21 12:11:29','771',29350777.45,29350777.45,'771','2022-05-20 12:50:44','764','2022-05-20 13:54:22',10,0),('21','221',65,'DAILY','2022-05-16','2022-05-20 14:24:45','2022-05-21 14:24:45','771',28594661.25,28594661.25,'771','2022-05-20 17:45:29','771','2022-05-20 17:47:32',10,0),('21','221',66,'DAILY','2022-05-17','2022-05-21 10:47:46','2022-05-22 10:47:46','771',26640546.85,26640546.85,'771','2022-05-21 11:24:06','764','2022-05-21 12:28:18',10,0),('21','221',67,'DAILY','2022-05-18','2022-05-21 15:02:23','2022-05-22 15:02:23','771',15454721.65,15454721.65,'771','2022-05-21 15:30:29','764','2022-05-21 16:06:18',10,0),('21','221',68,'DAILY','2022-05-19','2022-05-22 11:42:23','2022-05-23 11:42:23','771',21243917.20,21243917.20,'771','2022-05-22 13:33:35','764','2022-05-22 16:04:52',10,0),('21','221',69,'DAILY','2022-05-20','2022-05-22 19:08:57','2022-05-23 19:08:57','771',17068654.40,17068654.40,'771','2022-05-22 19:38:02','764','2022-05-22 20:56:25',10,0),('21','221',70,'DAILY','2022-05-21','2022-05-24 11:02:46','2022-05-25 11:02:46','771',18327314.40,18327314.40,'771','2022-05-24 11:41:28','764','2022-05-24 13:15:19',10,0),('21','221',71,'DAILY','2022-05-22','2022-05-24 13:33:13','2022-05-25 13:33:13','771',16333840.05,16333840.05,'771','2022-05-24 14:15:33','764','2022-05-24 16:02:26',10,0),('21','221',72,'DAILY','2022-05-23','2022-05-29 12:27:12','2022-05-30 12:27:12','771',28195226.30,28195226.30,'771','2022-05-29 13:49:11','764','2022-05-29 13:56:02',10,0),('21','221',73,'DAILY','2022-05-23','2022-05-29 14:13:16','2022-05-30 14:13:16','771',0.00,0.00,'764','2022-05-30 16:55:45','764','2022-05-30 16:56:23',10,0),('21','221',74,'DAILY','2022-05-23','2022-05-30 17:19:20','2022-05-31 17:19:20','771',4874032.00,4874032.00,'771','2022-05-30 17:22:51','764','2022-05-31 17:47:34',10,0),('21','221',75,'DAILY','2022-05-24','2022-06-01 16:29:07','2022-06-02 16:29:07','771',27050965.22,27050965.22,'771','2022-06-01 17:57:34','764','2022-06-01 18:55:20',10,0),('21','221',76,'DAILY','2022-05-25','2022-06-02 14:57:15','2022-06-03 14:57:15','771',24885348.25,24885348.25,'771','2022-06-02 15:15:12','764','2022-06-02 17:27:05',10,0),('21','221',77,'DAILY','2022-05-26','2022-06-02 17:40:53','2022-06-03 17:40:53','771',23697218.15,23697218.15,'771','2022-06-02 19:19:16','764','2022-06-02 19:27:40',10,0),('21','221',78,'DAILY','2022-05-27','2022-06-02 19:58:21','2022-06-03 19:58:21','771',17527631.45,17527631.45,'771','2022-06-02 20:44:18','764','2022-06-02 21:31:02',10,0),('21','221',79,'DAILY','2022-05-28','2022-06-03 15:11:04','2022-06-04 15:11:04','771',17356925.75,17356925.75,'771','2022-06-03 16:20:43','764','2022-06-03 16:55:24',10,0),('21','221',80,'DAILY','2022-05-29','2022-06-03 16:58:57','2022-06-04 16:58:57','771',18812689.85,18812689.85,'771','2022-06-03 17:19:39','764','2022-06-03 17:58:22',10,0),('21','221',81,'DAILY','2022-05-30','2022-06-03 20:18:46','2022-06-04 20:18:46','771',18807338.00,18807338.00,'771','2022-06-03 21:31:13','764','2022-06-04 13:42:13',10,0),('21','221',82,'DAILY','2022-05-31','2022-06-04 13:51:17','2022-06-05 13:51:17','771',18072390.35,18072390.35,'771','2022-06-04 16:00:37','764','2022-06-04 16:30:47',10,0),('21','221',83,'DAILY','2022-06-01','2022-06-06 13:30:57','2022-06-07 13:30:57','771',22692484.90,22692484.90,'771','2022-06-06 14:13:39','764','2022-06-06 16:45:46',10,0),('21','221',84,'DAILY','2022-06-02','2022-06-08 14:42:32','2022-06-09 14:42:32','771',20510433.85,20510433.85,'771','2022-06-08 15:58:43','764','2022-06-08 16:59:04',10,0),('21','221',85,'DAILY','2022-06-03','2022-06-08 17:18:41','2022-06-09 17:18:41','771',28452082.45,28452082.45,'771','2022-06-08 17:42:17','764','2022-06-08 18:37:26',10,0),('21','221',86,'DAILY','2022-06-04','2022-06-09 15:37:14','2022-06-10 15:37:14','771',17451664.25,17262650.05,'771','2022-06-09 17:11:10','764','2022-06-10 19:39:03',10,0),('21','221',87,'DAILY','2022-06-04','2022-06-11 13:33:12','2022-06-12 13:33:12','771',6575595.00,6575595.00,'771','2022-06-11 13:47:55','764','2022-06-11 13:51:19',10,0),('21','221',88,'DAILY','2022-06-05','2022-06-11 13:56:10','2022-06-12 13:56:10','771',19500620.75,19500620.75,'771','2022-06-11 14:33:35','764','2022-06-11 15:12:17',10,0),('21','221',89,'DAILY','2022-06-06','2022-06-11 15:27:01','2022-06-12 15:27:01','771',23848759.55,23848759.55,'771','2022-06-11 16:37:58','764','2022-06-13 10:51:20',10,0),('21','221',90,'DAILY','2022-06-07','2022-06-13 18:04:36','2022-06-14 18:04:36','771',28375145.97,28375145.97,'771','2022-06-13 18:33:00','764','2022-06-13 20:05:45',10,0),('21','221',91,'DAILY','2022-06-08','2022-06-14 17:14:39','2022-06-15 17:14:39','771',24653254.35,24653254.35,'771','2022-06-14 17:31:14','764','2022-06-14 17:49:56',10,0),('21','221',92,'DAILY','2022-06-09','2022-06-14 18:09:50','2022-06-15 18:09:50','771',28575862.45,28575862.45,'771','2022-06-14 18:41:53','764','2022-06-15 05:56:37',10,0),('21','221',93,'DAILY','2022-06-10','2022-06-15 12:40:41','2022-06-16 12:40:41','771',7180706.30,7180706.30,'771','2022-06-15 13:03:12','764','2022-06-15 13:55:40',10,0),('21','221',94,'DAILY','2022-06-11','2022-06-15 14:06:28','2022-06-16 14:06:28','771',24656989.25,24656989.25,'771','2022-06-15 14:53:50','764','2022-06-15 15:27:27',10,0),('21','221',95,'DAILY','2022-06-12','2022-06-16 13:21:12','2022-06-17 13:21:12','771',13835946.30,13835946.30,'771','2022-06-16 13:51:38','764','2022-06-16 14:16:54',10,0),('21','221',96,'DAILY','2022-06-13','2022-06-16 17:11:14','2022-06-17 17:11:14','771',17894582.50,17894582.50,'771','2022-06-16 18:52:43','764','2022-06-18 12:50:22',10,0),('21','221',97,'DAILY','2022-06-14','2022-06-18 14:08:59','2022-06-19 14:08:59','771',21677940.15,21677940.15,'771','2022-06-18 14:34:15','764','2022-06-20 17:06:27',10,0),('21','221',98,'DAILY','2022-06-15','2022-06-21 13:43:00','2022-06-22 13:43:00','771',13079125.75,13079125.75,'771','2022-06-23 18:59:37','764','2022-06-24 20:04:22',10,0),('21','221',99,'DAILY','2022-06-16','2022-06-25 17:23:26','2022-06-26 17:23:26','771',29417967.35,29417967.35,'771','2022-06-25 18:07:28','764','2022-06-27 14:17:42',10,0),('21','221',100,'DAILY','2022-06-17','2022-06-27 15:44:36','2022-06-28 15:44:36','771',17013107.10,17013107.10,'771','2022-06-27 16:21:30','764','2022-06-27 17:16:16',10,0),('21','221',101,'DAILY','2022-06-18','2022-06-27 19:14:36','2022-06-28 19:14:36','771',15870372.10,15870372.10,'771','2022-06-28 14:20:45','764','2022-06-28 16:28:12',10,0),('21','221',102,'DAILY','2022-06-19','2022-06-28 18:28:24','2022-06-29 18:28:24','771',10703602.30,10703602.30,'771','2022-06-28 18:54:12','764','2022-06-29 14:45:52',10,0),('21','221',103,'DAILY','2022-06-20','2022-06-29 15:24:35','2022-06-30 15:24:35','771',18427195.10,18427195.10,'771','2022-06-29 17:09:11','764','2022-07-19 14:02:18',10,0),('21','221',104,'DAILY','2022-06-20','2022-07-19 14:05:04','2022-07-20 14:05:04','771',14638363.70,14638363.70,'771','2022-07-19 14:47:16','764','2022-07-19 16:09:52',10,0),('21','221',105,'DAILY','2022-06-22','2022-07-19 17:01:08','2022-07-20 17:01:08','771',14170728.90,14170728.90,'771','2022-07-19 17:24:34','764','2022-07-19 17:59:56',10,0),('21','221',106,'DAILY','2022-06-23','2022-07-19 18:03:18','2022-07-20 18:03:18','771',16246447.15,16246447.15,'771','2022-07-19 18:44:20','764','2022-07-19 19:19:03',10,0),('21','221',107,'DAILY','2022-06-24','2022-07-20 19:19:42','2022-07-21 19:19:42','771',14946576.80,14946576.80,'771','2022-07-20 20:00:24','764','2022-07-20 20:42:44',10,0),('21','221',108,'DAILY','2022-06-25','2022-07-21 13:56:04','2022-07-22 13:56:04','771',13838791.75,13838791.75,'771','2022-07-21 14:25:29','764','2022-07-21 15:42:19',10,0),('21','221',109,'DAILY','2022-06-26','2022-07-21 15:43:35','2022-07-22 15:43:35','771',14540380.80,14540380.80,'771','2022-07-21 16:31:02','764','2022-07-21 17:11:21',10,0),('21','221',110,'DAILY','2022-06-27','2022-07-21 17:43:54','2022-07-22 17:43:54','771',15784822.00,15784822.00,'771','2022-07-21 18:12:16','764','2022-07-21 19:45:32',10,0),('21','221',111,'DAILY','2022-06-28','2022-07-22 15:13:42','2022-07-23 15:13:42','771',16874060.80,16874060.80,'771','2022-07-22 15:32:58','764','2022-07-22 17:45:50',10,0),('21','221',112,'DAILY','2022-06-29','2022-07-22 18:08:50','2022-07-23 18:08:50','771',16207399.40,16207399.40,'771','2022-07-22 18:27:41','764','2022-07-22 19:24:40',10,0),('21','221',113,'DAILY','2022-06-30','2022-07-22 19:58:50','2022-07-23 19:58:50','771',19709431.05,19709431.05,'771','2022-07-22 20:22:21','764','2022-07-25 12:45:43',10,0),('21','221',114,'DAILY','2022-07-01','2022-07-25 13:32:44','2022-07-26 13:32:44','771',15333048.95,15333048.95,'771','2022-07-25 14:10:23','764','2022-07-25 14:56:15',10,0),('21','221',115,'DAILY','2022-07-02','2022-07-25 14:59:51','2022-07-26 14:59:51','771',16998562.85,16998562.85,'771','2022-07-25 15:52:59','764','2022-07-25 16:40:35',10,0),('21','221',116,'DAILY','2022-07-03','2022-07-26 11:36:18','2022-07-27 11:36:18','771',20612855.50,20612855.50,'771','2022-07-26 11:56:07','764','2022-07-26 12:32:31',10,0),('21','221',117,'DAILY','2022-07-04','2022-07-26 12:43:24','2022-07-27 12:43:24','771',20550704.60,20550704.60,'771','2022-07-26 15:38:28','764','2022-07-26 16:58:19',10,0),('21','221',118,'DAILY','2022-07-05','2022-07-27 16:22:43','2022-07-28 16:22:43','771',19160828.75,19160828.75,'771','2022-07-27 16:41:26','764','2022-07-27 17:21:51',10,0),('21','221',119,'DAILY','2022-07-06','2022-07-27 17:35:25','2022-07-28 17:35:25','771',16022722.15,16022722.15,'771','2022-07-27 18:26:10','764','2022-07-27 18:47:39',10,0),('21','221',120,'DAILY','2022-07-07','2022-07-28 14:02:26','2022-07-29 14:02:26','771',10573799.85,10573799.85,'771','2022-07-28 15:04:10','764','2022-07-28 15:38:39',10,0),('21','221',121,'DAILY','2022-07-08','2022-07-28 15:40:20','2022-07-29 15:40:20','771',20201017.35,20201017.35,'771','2022-07-28 16:57:28','764','2022-07-28 17:59:49',10,0),('21','221',122,'DAILY','2022-07-09','2022-07-29 15:11:30','2022-07-30 15:11:30','771',7563606.40,7563606.40,'771','2022-07-29 16:10:28','764','2022-07-29 16:32:42',10,0),('21','221',123,'DAILY','2022-07-10','2022-07-29 17:09:04','2022-07-30 17:09:04','771',10907954.25,10907954.25,'771','2022-07-29 17:46:37','764','2022-07-29 18:02:14',10,0),('21','221',124,'DAILY','2022-07-11','2022-07-31 13:45:53','2022-08-01 13:45:53','771',13053839.80,13053839.80,'771','2022-07-31 14:22:43','764','2022-07-31 15:01:16',10,0),('21','221',125,'DAILY','2022-07-12','2022-07-31 15:13:46','2022-08-01 15:13:46','771',18968440.85,18968440.85,'771','2022-07-31 15:37:39','764','2022-08-01 15:16:09',10,0),('21','221',126,'DAILY','2022-07-13','2022-08-01 15:41:44','2022-08-02 15:41:44','771',21235910.15,21235910.15,'771','2022-08-01 16:50:18','764','2022-08-01 17:52:52',10,0),('21','221',127,'DAILY','2022-07-14','2022-08-02 15:55:16','2022-08-03 15:55:16','771',19770898.73,19770898.73,'771','2022-08-02 16:55:11','764','2022-08-02 17:51:46',10,0),('21','221',128,'DAILY','2022-07-15','2022-08-05 09:50:33','2022-08-06 09:50:33','771',31059475.65,31059475.65,'771','2022-08-05 10:09:42','764','2022-08-05 11:41:20',10,0),('21','221',129,'DAILY','2022-07-16','2022-08-05 11:59:30','2022-08-06 11:59:30','771',21703023.35,21703023.35,'771','2022-08-05 12:29:03','764','2022-08-06 12:25:37',10,0),('21','221',130,'DAILY','2022-07-17','2022-08-06 12:56:21','2022-08-07 12:56:21','771',0.00,0.00,'764','2022-08-06 13:56:06','764','2022-08-06 13:56:30',10,0),('21','221',131,'DAILY','2022-07-17','2022-08-06 14:00:49','2022-08-07 14:00:49','771',11693677.00,11693677.00,'771','2022-08-06 14:09:51','764','2022-08-06 16:27:42',10,0),('21','221',132,'DAILY','2022-07-18','2022-08-07 12:16:34','2022-08-08 12:16:34','771',18237648.55,17452077.95,'771','2022-08-07 14:03:14','764','2022-08-07 14:32:28',10,0),('21','221',133,'DAILY','2022-07-19','2022-08-08 13:17:59','2022-08-09 13:17:59','771',22314105.05,21491348.35,'771','2022-08-08 18:02:24','764','2022-08-08 18:47:48',10,0),('21','221',134,'DAILY','2022-07-20','2022-08-09 12:14:30','2022-08-10 12:14:30','771',14913724.90,14913724.90,'771','2022-08-09 13:10:24','764','2022-08-09 14:44:43',10,0),('21','221',135,'DAILY','2022-07-21','2022-08-09 14:58:07','2022-08-10 14:58:07','771',14765525.85,14765525.85,'771','2022-08-09 16:16:25','764','2022-08-09 17:04:42',10,0),('21','221',136,'DAILY','2022-07-22','2022-08-10 12:22:24','2022-08-11 12:22:24','771',9970110.05,9936983.90,'771','2022-08-10 12:51:24','764','2022-08-10 13:59:43',10,0),('21','221',137,'DAILY','2022-07-23','2022-08-11 15:29:10','2022-08-12 15:29:10','771',19039754.50,18993876.25,'771','2022-08-11 16:56:01','764','2022-08-11 19:57:02',10,0),('21','221',138,'DAILY','2022-07-24','2022-08-12 11:52:08','2022-08-13 11:52:08','771',12572293.30,12549856.15,'771','2022-08-12 13:11:23','764','2022-08-12 19:37:56',10,0),('21','221',139,'DAILY','2022-07-25','2022-08-13 15:00:24','2022-08-14 15:00:24','771',14875386.10,14803197.55,'771','2022-08-13 17:51:35','764','2022-08-15 00:29:21',10,0),('21','221',140,'DAILY','2022-07-26','2022-08-15 16:25:06','2022-08-16 16:25:06','771',4251328.60,4251328.60,'771','2022-08-15 17:12:29','764','2022-08-16 16:46:47',10,0),('21','221',141,'DAILY','2022-07-27','2022-08-16 18:35:44','2022-08-17 18:35:44','771',13859005.96,13859005.96,'771','2022-08-16 19:24:45','764','2022-08-16 19:58:34',10,0),('21','221',142,'DAILY','2022-07-28','2022-08-17 13:28:42','2022-08-18 13:28:42','771',13413796.88,13413796.88,'771','2022-08-17 13:52:22','764','2022-08-17 14:59:04',10,0),('21','221',143,'DAILY','2022-07-29','2022-08-17 15:24:36','2022-08-18 15:24:36','771',0.00,0.00,'764','2022-08-18 12:54:14','764','2022-08-18 12:54:43',10,0),('21','221',144,'DAILY','2022-07-29','2022-08-18 14:11:40','2022-08-19 14:11:40','771',15990908.81,15990908.81,'764','2022-08-18 18:15:50','764','2022-08-19 05:49:54',10,0),('21','221',145,'DAILY','2022-07-30','2022-08-20 17:08:44','2022-08-21 17:08:44','771',11375699.36,11375699.36,'771','2022-08-20 17:29:04','764','2022-08-21 15:33:49',10,0),('21','221',146,'DAILY','2022-07-31','2022-08-27 11:21:14','2022-08-28 11:21:14','771',11124740.91,11124740.91,'771','2022-08-27 11:33:58','764','2022-08-27 11:47:04',10,0),('21','221',147,'DAILY','2022-08-01','2022-08-27 12:06:24','2022-08-28 12:06:24','771',13611071.70,13611071.70,'771','2022-08-27 12:48:56','764','2022-08-27 13:26:54',10,0),('21','221',148,'DAILY','2022-08-02','2022-08-27 17:25:02','2022-08-28 17:25:02','771',11204911.01,11204911.01,'771','2022-08-27 17:47:00','764','2022-08-27 18:33:12',10,0),('21','221',149,'DAILY','2022-08-03','2022-08-27 19:40:36','2022-08-28 19:40:36','771',11456800.91,11456800.91,'771','2022-08-27 19:57:09','764','2022-08-27 20:17:06',10,0),('21','221',150,'DAILY','2022-08-04','2022-08-29 12:31:36','2022-08-30 12:31:36','771',12199788.23,12199788.23,'771','2022-08-29 13:13:33','764','2022-08-29 13:55:04',10,0),('21','221',151,'DAILY','2022-08-05','2022-08-29 16:50:34','2022-08-30 16:50:34','771',10484898.48,10484898.48,'771','2022-08-29 17:21:51','764','2022-08-30 17:34:08',10,0),('21','221',152,'DAILY','2022-08-06','2022-08-31 13:58:37','2022-09-01 13:58:37','771',11799508.22,11799508.22,'771','2022-08-31 14:41:40','764','2022-08-31 15:07:08',10,0),('21','221',153,'DAILY','2022-08-07','2022-08-31 15:09:04','2022-09-01 15:09:04','771',8920614.46,8920614.46,'771','2022-08-31 15:45:42','764','2022-09-01 10:01:54',10,0),('21','221',154,'DAILY','2022-08-08','2022-09-02 10:10:35','2022-09-03 10:10:35','771',13013712.81,13013712.81,'771','2022-09-02 11:01:55','764','2022-09-02 18:57:40',10,0),('21','221',155,'DAILY','2022-08-09','2022-09-03 09:46:27','2022-09-04 09:46:27','771',17060239.38,17060239.38,'771','2022-09-03 11:14:27','764','2022-09-03 11:53:20',10,0),('21','221',156,'DAILY','2022-08-10','2022-09-03 12:08:41','2022-09-04 12:08:41','771',14342488.09,14342488.09,'771','2022-09-03 17:51:12','764','2022-09-03 20:10:07',10,0),('21','221',157,'DAILY','2022-08-11','2022-09-04 14:29:33','2022-09-05 14:29:33','771',14083175.67,14083175.67,'771','2022-09-04 15:34:28','764','2022-09-04 16:05:33',10,0),('21','221',158,'DAILY','2022-08-12','2022-09-04 16:41:03','2022-09-05 16:41:03','771',12292421.41,12292421.41,'771','2022-09-04 16:58:47','764','2022-09-04 17:20:09',10,0),('21','221',159,'DAILY','2022-08-13','2022-09-04 17:31:56','2022-09-05 17:31:56','771',12193269.45,12193269.45,'771','2022-09-04 17:57:30','764','2022-09-04 18:29:38',10,0),('21','221',160,'DAILY','2022-08-14','2022-09-04 21:05:52','2022-09-05 21:05:52','771',8804257.73,8804257.73,'771','2022-09-04 21:27:54','764','2022-09-04 21:41:28',10,0),('21','221',161,'DAILY','2022-08-15','2022-09-05 09:58:46','2022-09-06 09:58:46','771',11334006.29,11334006.29,'771','2022-09-05 10:23:08','764','2022-09-05 10:46:53',10,0),('21','221',162,'DAILY','2022-08-16','2022-09-05 10:50:01','2022-09-06 10:50:01','771',11339521.77,11339521.77,'771','2022-09-05 11:26:00','764','2022-09-05 12:13:19',10,0),('21','221',163,'DAILY','2022-08-17','2022-09-05 12:35:21','2022-09-06 12:35:21','771',22883815.91,22883815.91,'771','2022-09-05 12:50:14','764','2022-09-05 13:34:18',10,0),('21','221',164,'DAILY','2022-08-18','2022-09-05 16:17:38','2022-09-06 16:17:38','771',12779679.75,12779679.75,'771','2022-09-05 16:38:42','764','2022-09-05 17:02:19',10,0),('21','221',165,'DAILY','2022-08-19','2022-09-05 17:17:18','2022-09-06 17:17:18','771',10670945.69,10670945.69,'771','2022-09-05 17:39:00','764','2022-09-05 18:28:09',10,0),('21','221',166,'DAILY','2022-08-20','2022-09-06 14:58:26','2022-09-07 14:58:26','771',11198452.12,11198452.12,'771','2022-09-06 15:27:11','764','2022-09-07 11:50:35',10,0),('21','221',167,'DAILY','2022-08-21','2022-09-07 11:58:35','2022-09-08 11:58:35','771',9954926.49,9954926.49,'771','2022-09-07 12:22:41','764','2022-09-07 13:29:14',10,0),('21','221',168,'DAILY','2022-08-22','2022-09-07 13:56:41','2022-09-08 13:56:41','771',11417017.93,11417017.93,'771','2022-09-07 14:13:15','764','2022-09-07 14:41:17',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4705 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','221','1','1',1,'1','1',4432029.47,4434595.66,2566.19,423421.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','1',2,'2','1',4991298.45,4994265.35,2966.90,489538.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','1',3,'3','1',4144272.88,4146900.20,2627.32,433507.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','1',4,'4','1',5425036.13,5427672.65,2636.52,435025.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','1',5,'5','1',3486088.87,3486118.29,29.42,4854.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','1',6,'6','1',4816363.43,4822393.49,6030.06,994959.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','1',7,'7','1',2144689.52,2148458.93,3769.41,621952.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','1',8,'8','1',3079348.56,3083908.11,4559.55,752325.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','1',9,'9','1',5023635.76,5026436.35,2800.59,462097.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','1',10,'10','1',3050590.59,3058816.73,8226.14,1357313.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','1',11,'11','1',4258571.86,4264489.89,5918.03,976474.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','1',12,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','1',13,'13','1',4143349.31,4146761.58,3412.27,563024.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','1',14,'14','1',3190842.46,3193858.11,3015.65,497582.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','1',15,'15','1',3807903.15,3808009.38,106.23,17527.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','1',16,'16','1',3140691.84,3145096.19,4404.35,726717.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','1',17,'17','1',3505527.97,3508463.81,2935.84,484413.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','1',18,'18','1',3163613.37,3166830.73,3217.36,530864.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','1',19,'19','1',3953390.98,3956079.20,2688.22,443556.30,0.00,0.00,0.00,0.00,0.00),('21','221','4','1',20,'20','2',1767610.40,1775443.76,7833.36,5483352.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','1',21,'21','2',49426.75,49426.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','1',22,'22','2',1571.07,1571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','1',23,'23','2',589630.09,597207.81,7577.72,5304404.70,0.00,0.00,0.00,0.00,0.00),('21','221','5','1',24,'24','3',331409.26,331409.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','1',25,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','1',26,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','1',27,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','1',28,'28','1',3609587.61,3612203.75,2616.14,431663.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','2',29,'1','1',4434595.66,4434595.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','2',30,'2','1',4994265.35,4994265.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','2',31,'3','1',4146900.20,4146900.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','2',32,'4','1',5427672.65,5427672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','2',33,'5','1',3486118.29,3486118.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','2',34,'6','1',4822393.49,4822393.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','2',35,'7','1',2148458.93,2148458.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','2',36,'8','1',3083908.11,3083908.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','2',37,'9','1',5026436.35,5026436.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','2',38,'10','1',3058816.73,3058816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','2',39,'11','1',4264489.89,4264489.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','2',40,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','2',41,'13','1',4146761.58,4146761.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','2',42,'14','1',3193858.11,3193858.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','2',43,'15','1',3808009.38,3808009.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','2',44,'16','1',3145096.19,3145096.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','2',45,'17','1',3508463.81,3508463.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','2',46,'18','1',3166830.73,3166830.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','2',47,'19','1',3956079.20,3956079.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','2',48,'20','2',1775443.76,1775443.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','2',49,'21','2',49426.75,49426.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','2',50,'22','2',1571.07,1571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','2',51,'23','2',597207.81,597207.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','2',52,'24','3',331409.26,331409.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','2',53,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','2',54,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','2',55,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','2',56,'28','1',3612203.75,3612203.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','3',57,'1','1',4437582.48,4437582.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','3',58,'2','1',4995417.70,4995417.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','3',59,'3','1',41510648.32,41510648.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','3',60,'4','1',5432422.58,5432422.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','3',61,'5','1',3487644.51,3487644.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','3',62,'6','1',4827992.84,4827992.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','3',63,'7','1',2150480.74,2150480.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','3',64,'8','1',3087547.77,3087547.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','3',65,'9','1',5030916.77,5030916.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','3',66,'10','1',3063881.80,3063881.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','3',67,'11','1',4267532.35,4267532.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','3',68,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','3',69,'13','1',4150444.97,4150444.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','3',70,'14','1',3196236.54,3196236.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','3',71,'15','1',3810251.88,3810251.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','3',72,'16','1',3148617.04,3148617.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','3',73,'17','1',3512194.44,3512194.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','3',74,'18','1',3170280.20,3170280.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','3',75,'19','1',3957542.32,3957542.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','3',76,'20','2',1781249.41,1781249.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','3',77,'21','2',49426.75,49426.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','3',78,'22','2',1571.07,1571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','3',79,'23','2',601951.42,601951.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','3',80,'24','3',331409.26,331409.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','3',81,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','3',82,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','3',83,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','3',84,'28','1',3615685.13,3615685.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','4',85,'1','1',4437582.48,4437582.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','4',86,'2','1',4997517.70,4997517.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','4',87,'3','1',41510648.32,41510648.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','4',88,'4','1',5432422.58,5432422.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','4',89,'5','1',3487644.51,3487644.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','4',90,'6','1',4827992.84,4827992.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','4',91,'7','1',2150480.74,2150480.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','4',92,'8','1',3087547.77,3087547.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','4',93,'9','1',5030916.77,5030916.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','4',94,'10','1',3063881.80,3063881.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','4',95,'11','1',4267532.35,4267532.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','4',96,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','4',97,'13','1',4150444.97,4150444.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','4',98,'14','1',3196236.54,3196236.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','4',99,'15','1',3810251.88,3810251.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','4',100,'16','1',3148617.04,3148617.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','4',101,'17','1',3512194.44,3512194.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','4',102,'18','1',3170280.20,3170280.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','4',103,'19','1',3957542.32,3957542.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','4',104,'20','2',1781249.41,1781249.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','4',105,'21','2',49426.75,49426.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','4',106,'22','2',1571.07,1571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','4',107,'23','2',601951.42,601951.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','4',108,'24','3',331409.26,331409.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','4',109,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','4',110,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','4',111,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','4',112,'28','1',3615685.13,3615685.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','5',113,'1','1',4437582.48,4440943.58,3361.10,554581.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','5',114,'2','1',4997517.70,5000922.84,3405.14,561848.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','5',115,'3','1',4151648.32,4155411.04,3762.72,620848.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','5',116,'4','1',5432422.58,5436280.72,3858.14,636593.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','5',117,'5','1',3487644.51,3487644.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','5',118,'6','1',4827992.84,4831491.33,3498.49,577250.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','5',119,'7','1',2150480.74,2152272.34,1791.60,295614.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','5',120,'8','1',3087547.77,3090274.47,2726.70,449905.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','5',121,'9','1',5030916.77,5032392.85,1476.08,243553.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','5',122,'10','1',3063881.80,3067172.46,3290.66,542958.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','5',123,'11','1',4267532.35,4270360.97,2828.62,466722.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','5',124,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','5',125,'13','1',4150444.97,4154367.48,3922.51,647214.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','5',126,'14','1',3196236.54,3198890.52,2653.98,437906.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','5',127,'15','1',3810251.88,3812695.31,2443.43,403165.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','5',128,'16','1',3148617.04,3151346.73,2729.69,450398.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','5',129,'17','1',3512194.44,3515803.82,3609.38,595547.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','5',130,'18','1',3170280.20,3175035.95,4755.75,784698.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','5',131,'19','1',3957542.32,3958240.57,698.25,115211.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','5',132,'20','2',1781249.41,1781249.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','5',133,'21','2',49426.75,49426.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','5',134,'22','2',1571.07,1571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','5',135,'23','2',601951.42,612292.88,10341.46,7239022.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','5',136,'24','3',331409.26,331409.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','5',137,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','5',138,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','5',139,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','5',140,'28','1',3615685.13,3618637.31,2952.18,487109.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','6',141,'1','1',4440943.58,4444477.25,3533.67,583055.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','6',142,'2','1',5000922.84,5004047.72,3124.88,515605.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','6',143,'3','1',4155411.04,4157455.30,2044.26,337302.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','6',144,'4','1',5436280.72,5439300.28,3019.56,498227.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','6',145,'5','1',3487644.51,3487775.16,130.65,21557.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','6',146,'6','1',4831491.33,4839654.80,8163.47,1346972.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','6',147,'7','1',2152272.34,2155314.91,3042.57,502024.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','6',148,'8','1',3090274.47,3096969.28,6694.81,1104643.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','6',149,'9','1',5032392.85,5037612.57,5219.72,861253.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','6',150,'10','1',3067172.46,3074410.37,7197.91,1187655.15,0.00,0.00,40.00,0.00,0.00),('21','221','2','6',151,'11','1',4270360.97,4275672.53,5311.56,876407.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','6',152,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','6',153,'13','1',4154367.48,4160114.56,5747.08,948268.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','6',154,'14','1',3198890.52,3201578.53,2688.01,443521.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','6',155,'15','1',3812695.31,3815264.45,2569.14,423908.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','6',156,'16','1',3151346.73,3152936.77,1590.04,262356.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','6',157,'17','1',3515803.82,3519036.48,3232.66,533388.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','6',158,'18','1',3175035.95,3178445.01,3409.06,562494.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','6',159,'19','1',3958240.57,3958636.70,396.13,65361.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','6',160,'20','2',1781249.41,1786925.82,5676.41,3973487.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','6',161,'21','2',49426.75,49447.29,0.00,0.00,0.00,0.00,20.54,0.00,0.00),('21','221','4','6',162,'22','2',1571.07,1598.47,27.40,19180.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','6',163,'23','2',612292.88,619906.47,7613.59,5329513.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','6',164,'24','3',331409.26,331409.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','6',165,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','6',166,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','6',167,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','6',168,'28','1',3618637.31,3620798.19,2160.88,356545.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','7',169,'1','1',4444477.25,4448883.78,4406.53,727077.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','7',170,'2','1',5004047.72,5005742.98,1695.26,279717.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','7',171,'3','1',4157455.30,4160728.70,3273.40,540111.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','7',172,'4','1',5439300.28,5441598.73,2298.45,379244.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','7',173,'5','1',3487775.16,3490852.48,3077.32,507757.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','7',174,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','7',175,'7','1',2155314.91,2155567.99,253.08,41758.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','7',176,'8','1',3096969.28,3098782.52,1813.24,299184.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','7',177,'9','1',5037612.57,5041436.46,3823.89,630941.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','7',178,'10','1',3074410.37,3078374.07,3923.70,647410.50,0.00,0.00,40.00,0.00,0.00),('21','221','2','7',179,'11','1',4275672.53,4279982.59,4310.06,711159.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','7',180,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','7',181,'13','1',4160114.56,4163947.33,3832.77,632407.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','7',182,'14','1',3201578.53,3205066.99,3488.46,575595.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','7',183,'15','1',3815264.45,3819131.97,3867.52,638140.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','7',184,'16','1',3152936.77,3154458.64,1521.87,251108.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','7',185,'17','1',3519036.48,3522449.51,3413.03,563149.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','7',186,'18','1',3178445.01,3181819.94,3374.93,556863.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','7',187,'19','1',3958636.70,3958636.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','7',188,'20','2',1786925.82,1790320.35,3394.53,2376171.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','7',189,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','7',190,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','7',191,'23','2',619906.47,622401.27,2494.80,1746360.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','7',192,'24','3',331409.26,331409.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','7',193,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','7',194,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','7',195,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','7',196,'28','1',3620798.19,3624179.03,3380.84,557838.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','8',197,'1','1',4448883.78,4449125.13,201.35,33222.75,0.00,0.00,40.00,0.00,0.00),('21','221','1','8',198,'2','1',5005742.98,5006166.99,424.01,69961.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','8',199,'3','1',4160728.70,4161044.99,316.29,52187.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','8',200,'4','1',5441598.73,5441985.88,387.15,63879.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','8',201,'5','1',3490852.48,3499272.67,8420.19,1389331.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','8',202,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','8',203,'7','1',2155567.99,2155567.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','8',204,'8','1',3098782.52,3098782.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','8',205,'9','1',5041436.46,5047700.33,6263.87,1033538.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','8',206,'10','1',3078374.07,3086462.26,8088.19,1334551.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','8',207,'11','1',4279982.59,4286160.58,6177.99,1019368.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','8',208,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','8',209,'13','1',4163947.33,4171919.25,7971.92,1315366.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','8',210,'14','1',3205066.99,3209641.34,4574.35,754767.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','8',211,'15','1',3819131.97,3825476.14,6344.17,1046788.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','8',212,'16','1',3154458.64,3158989.62,4530.98,747611.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','8',213,'17','1',3522449.51,3526281.04,3831.53,632202.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','8',214,'18','1',3181819.94,3186883.81,5063.87,835538.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','8',215,'19','1',3958636.70,3958636.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','8',216,'20','2',1790320.35,1790862.94,542.59,379813.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','8',217,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','8',218,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','8',219,'23','2',622401.27,622401.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','8',220,'24','3',331409.26,332200.87,791.61,435386.05,0.00,0.00,0.00,0.00,0.00),('21','221','5','8',221,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','8',222,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','8',223,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','8',224,'28','1',3624179.03,3629448.91,5269.88,869530.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','9',225,'1','1',4449125.13,4449125.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','9',226,'2','1',5006166.99,5006166.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','9',227,'3','1',4161044.99,4161044.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','9',228,'4','1',5441985.88,5441985.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','9',229,'5','1',3499272.67,3499272.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','9',230,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','9',231,'7','1',2155567.99,2155567.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','9',232,'8','1',3098782.52,3098782.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','9',233,'9','1',5047700.33,5047700.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','9',234,'10','1',3086462.26,3086462.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','9',235,'11','1',4286160.58,4286160.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','9',236,'12','1',3498399.07,3498399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','9',237,'13','1',4171919.25,4171919.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','9',238,'14','1',3209641.34,3209641.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','9',239,'15','1',3825476.14,3825476.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','9',240,'16','1',3158989.62,3158989.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','9',241,'17','1',3526281.04,3526281.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','9',242,'18','1',3186883.81,3186883.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','9',243,'19','1',3958636.70,3958636.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','9',244,'20','2',1790862.94,1790862.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','9',245,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','9',246,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','9',247,'23','2',622401.27,622401.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','9',248,'24','3',332200.87,332200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','9',249,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','9',250,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','9',251,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','9',252,'28','1',3629448.91,3629448.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','10',253,'1','1',4449175.13,4449175.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','10',254,'2','1',5006166.99,5006166.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','10',255,'3','1',4161044.99,4161044.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','10',256,'4','1',5441985.88,5441985.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','10',257,'5','1',3499272.67,3502859.24,3586.57,591784.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','10',258,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','10',259,'7','1',2155567.99,2157197.47,1629.48,268864.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','10',260,'8','1',3103546.51,3107338.12,3791.61,625615.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','10',261,'9','1',5047700.33,5052126.68,4426.35,730347.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','10',262,'10','1',3086462.26,3091646.33,5184.07,855371.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','10',263,'11','1',4286160.58,4289362.00,3161.42,521634.30,0.00,0.00,40.00,0.00,0.00),('21','221','2','10',264,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','10',265,'13','1',4171919.25,4175944.62,4025.37,664186.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','10',266,'14','1',3209641.34,3212635.38,2994.04,494016.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','10',267,'15','1',3825476.14,3827643.40,2167.26,357597.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','10',268,'16','1',3158989.62,3160786.49,1796.87,296483.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','10',269,'17','1',3526281.04,3529048.59,2767.55,456645.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','10',270,'18','1',3186883.81,3189463.28,2579.47,425612.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','10',271,'19','1',3958636.70,3958636.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','10',272,'20','2',1790862.94,1791285.12,422.18,295526.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','10',273,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','10',274,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','10',275,'23','2',622401.27,622401.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','10',276,'24','3',332200.87,335189.56,2988.69,1643777.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','10',277,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','10',278,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','10',279,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','10',280,'28','1',3629448.91,3632298.43,2849.52,470170.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','11',281,'1','1',4449175.13,4450977.02,1801.89,297311.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','11',282,'2','1',5006166.99,5007621.86,1454.87,240053.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','11',283,'3','1',4161044.99,4163205.79,2160.80,356532.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','11',284,'4','1',5441985.88,5442987.98,1002.10,165346.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','11',285,'5','1',3502859.24,3506464.06,3604.82,594795.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','11',286,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','11',287,'7','1',2157197.47,2160635.14,3437.67,567215.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','11',288,'8','1',3107338.12,3110703.97,3365.85,555365.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','11',289,'9','1',5052126.68,5055138.41,3011.73,496935.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','11',290,'10','1',3091646.33,3096485.76,4839.43,798505.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','11',291,'11','1',4289362.00,4291072.95,1670.95,275706.75,0.00,0.00,40.00,0.00,0.00),('21','221','2','11',292,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','11',293,'13','1',4175944.62,4180122.84,4178.22,689406.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','11',294,'14','1',3212635.38,3215646.47,3011.09,496829.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','11',295,'15','1',3827643.40,3831552.15,3908.75,644943.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','11',296,'16','1',3160786.49,3162415.00,1628.51,268704.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','11',297,'17','1',3529048.59,3530971.21,1922.62,317232.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','11',298,'18','1',3189463.28,3191543.85,2080.57,343294.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','11',299,'19','1',3958636.70,3958636.73,0.03,4.95,0.00,0.00,0.00,0.00,0.00),('21','221','4','11',300,'20','2',1791285.12,1809862.53,18577.41,13004187.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','11',301,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','11',302,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','11',303,'23','2',622401.27,629721.83,7320.56,5124392.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','11',304,'24','3',335189.56,335944.35,754.79,415135.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','11',305,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','11',306,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','11',307,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','11',308,'28','1',3632298.43,3635438.70,3140.27,518144.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','12',309,'1','1',4450977.02,4455998.87,5021.85,828605.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','12',310,'2','1',5007621.86,5012273.52,4651.66,767523.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','12',311,'3','1',4163205.79,4166097.19,2891.40,477081.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','12',312,'4','1',5442987.98,5446884.49,3896.51,642924.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','12',313,'5','1',3506464.06,3513938.00,7473.94,1233200.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','12',314,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','12',315,'7','1',2160635.14,2165409.61,4774.47,787787.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','12',316,'8','1',3110703.97,3115464.64,4760.67,785510.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','12',317,'9','1',5055138.41,5059411.83,4273.42,705114.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','12',318,'10','1',3096485.76,3104413.50,7927.74,1308077.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','12',319,'11','1',4291072.95,4295315.46,4242.51,700014.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','12',320,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','12',321,'13','1',4180122.84,4187329.31,7166.47,1182467.55,0.00,0.00,40.00,0.00,0.00),('21','221','3','12',322,'14','1',3215646.47,3219991.91,4345.44,716997.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','12',323,'15','1',3831552.15,3836180.32,4628.17,763648.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','12',324,'16','1',3162415.00,3164708.05,2293.05,378353.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','12',325,'17','1',3530971.21,3535868.15,4896.94,807995.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','12',326,'18','1',3191543.85,3195057.95,3514.10,579826.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','12',327,'19','1',3958636.73,3958636.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','12',328,'20','2',1809862.53,1809882.54,20.01,14007.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','12',329,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','12',330,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','12',331,'23','2',629721.83,633671.57,3949.74,2764818.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','12',332,'24','3',335944.35,337178.10,1233.75,678559.75,0.00,0.00,0.00,0.00,0.00),('21','221','5','12',333,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','12',334,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','12',335,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','12',336,'28','1',3635438.70,3639956.31,4517.61,745405.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','13',337,'1','1',4455998.87,4456173.23,174.36,28769.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','13',338,'2','1',5012273.52,5015093.97,2820.45,465374.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','13',339,'3','1',4166097.19,4169319.01,3221.82,531600.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','13',340,'4','1',5446884.49,5447190.35,305.86,50466.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','13',341,'5','1',3513938.00,3520277.72,6339.72,1046053.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','13',342,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','13',343,'7','1',2165409.61,2169955.96,4546.35,750147.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','13',344,'8','1',3115464.64,3119658.30,4193.66,691953.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','13',345,'9','1',5059411.83,5063902.22,4490.39,740914.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','13',346,'10','1',3104413.50,3110676.00,6262.50,1033312.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','13',347,'11','1',4295315.46,4297769.07,2453.61,404845.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','13',348,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','13',349,'13','1',4187329.31,4195242.81,7913.50,1305727.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','13',350,'14','1',3219991.91,3223261.34,3269.43,539455.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','13',351,'15','1',3836180.32,3842725.44,6545.12,1079944.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','13',352,'16','1',3164708.05,3168277.70,3569.65,588992.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','13',353,'17','1',3535868.15,3540660.09,4791.94,790670.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','13',354,'18','1',3195057.95,3200181.73,5123.78,845423.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','13',355,'19','1',3958636.73,3958647.05,10.32,1702.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','13',356,'20','2',1809882.54,1812820.73,2938.19,2056733.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','13',357,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','13',358,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','13',359,'23','2',633671.57,638617.17,4945.60,3461920.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','13',360,'24','3',337178.10,338273.39,1095.29,602406.75,0.00,0.00,0.00,0.00,0.00),('21','221','5','13',361,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','13',362,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','13',363,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','13',364,'28','1',3639956.31,3644082.44,4126.13,680811.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','14',365,'1','1',4456173.23,4456754.88,581.65,95972.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','14',366,'2','1',5015093.97,5015387.76,293.79,48475.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','14',367,'3','1',4169319.01,4174642.33,5323.32,878347.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','14',368,'4','1',5447190.35,5451626.70,4436.35,731997.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','14',369,'5','1',3520277.72,3525663.01,5385.29,888572.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','14',370,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','14',371,'7','1',2169955.96,2172392.10,2436.14,401963.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','14',372,'8','1',3119658.30,3123052.34,3394.04,560016.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','14',373,'9','1',5063902.22,5066706.72,2804.50,462742.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','14',374,'10','1',3110676.00,3116154.38,5478.38,903932.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','14',375,'11','1',4297769.07,4301812.35,4043.28,667141.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','14',376,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','14',377,'13','1',4195242.81,4199632.13,4389.32,724237.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','14',378,'14','1',3223261.34,3224164.74,903.40,149061.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','14',379,'15','1',3842725.44,3846500.52,3775.08,622888.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','14',380,'16','1',3168277.70,3170056.31,1778.61,293470.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','14',381,'17','1',3540660.09,3543849.99,3189.90,526333.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','14',382,'18','1',3200181.73,3204017.53,3835.80,632907.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','14',383,'19','1',3958647.05,3960287.77,1640.72,270718.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','14',384,'20','2',1812820.73,1819840.95,7020.22,4914154.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','14',385,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','14',386,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','14',387,'23','2',638617.17,649388.56,10771.39,7539973.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','14',388,'24','3',338273.39,339283.43,1010.04,555523.65,0.00,0.00,0.00,0.00,0.00),('21','221','5','14',389,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','14',390,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','14',391,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','14',392,'28','1',3644082.44,3646181.88,2099.44,346407.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','15',393,'1','1',4456754.88,4456754.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','15',394,'2','1',5015387.76,5015387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','15',395,'3','1',4174642.33,4174642.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','15',396,'4','1',5451626.70,5451626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','15',397,'5','1',3525663.01,3525663.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','15',398,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','15',399,'7','1',2172392.10,2172392.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','15',400,'8','1',3123052.34,3123052.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','15',401,'9','1',5066706.72,5066706.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','15',402,'10','1',3116154.38,3116154.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','15',403,'11','1',4301812.35,4301812.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','15',404,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','15',405,'13','1',4199632.13,4199632.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','15',406,'14','1',3224164.74,3224164.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','15',407,'15','1',3846500.52,3846500.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','15',408,'16','1',3170056.31,3170056.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','15',409,'17','1',3543849.99,3543849.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','15',410,'18','1',3204017.53,3204017.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','15',411,'19','1',3960287.77,3960287.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','15',412,'20','2',1819840.95,1819840.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','15',413,'21','2',49447.29,49447.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','15',414,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','15',415,'23','2',649388.56,649388.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','15',416,'24','3',339283.43,339283.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','15',417,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','15',418,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','15',419,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','15',420,'28','1',3646181.88,3646181.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','16',421,'1','1',4456754.88,4458981.61,2226.73,367410.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','16',422,'2','1',5015387.76,5015881.88,494.12,81529.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','16',423,'3','1',4174642.33,4176398.97,1756.64,289845.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','16',424,'4','1',5451626.70,5454765.21,3138.51,517854.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','16',425,'5','1',3525663.01,3528879.23,3216.22,530676.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','16',426,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','16',427,'7','1',2172392.10,2174477.27,2085.17,344053.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','16',428,'8','1',3123052.34,3124244.22,1191.88,196660.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','16',429,'9','1',5066706.72,5069001.85,2295.13,378696.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','16',430,'10','1',3116154.38,3118832.20,2637.82,435240.30,0.00,0.00,40.00,0.00,0.00),('21','221','2','16',431,'11','1',4301812.35,4304881.39,3069.04,506391.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','16',432,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','16',433,'13','1',4199632.13,4203428.47,3796.34,626396.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','16',434,'14','1',3224164.74,3227398.09,3233.35,533502.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','16',435,'15','1',3846500.52,3848955.86,2455.34,405131.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','16',436,'16','1',3170056.31,3172550.58,2494.27,411554.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','16',437,'17','1',3543849.99,3545860.10,2010.11,331668.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','16',438,'18','1',3204017.53,3206088.56,2071.03,341719.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','16',439,'19','1',3960287.77,3962306.57,2018.80,333102.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','16',440,'20','2',1819840.95,1826498.27,6657.32,4660124.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','16',441,'21','2',49447.29,49465.14,17.85,12495.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','16',442,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','16',443,'23','2',649388.56,656360.50,6971.94,4880358.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','16',444,'24','3',339283.43,340318.04,1034.61,569037.70,0.00,0.00,0.00,0.00,0.00),('21','221','5','16',445,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','16',446,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','16',447,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','16',448,'28','1',3646181.88,3648876.68,2694.80,444642.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','17',449,'1','1',4458981.61,4462707.31,3685.70,608140.50,0.00,0.00,40.00,0.00,0.00),('21','221','1','17',450,'2','1',5015881.88,5019142.26,3260.38,537962.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','17',451,'3','1',4176398.97,4180298.97,3900.00,643500.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','17',452,'4','1',5454765.21,5458886.78,4121.57,680059.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','17',453,'5','1',3528879.23,3533135.01,4255.78,702203.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','17',454,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','17',455,'7','1',2174477.27,2176975.13,2497.86,412146.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','17',456,'8','1',3124244.22,3128313.00,4068.78,671348.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','17',457,'9','1',5069001.85,5072712.85,3711.00,612315.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','17',458,'10','1',3118832.20,3123926.92,5094.72,840628.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','17',459,'11','1',4304881.39,4305703.50,822.11,135648.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','17',460,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','17',461,'13','1',4203428.47,4207878.05,4449.58,734180.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','17',462,'14','1',3227398.09,3229761.61,2363.52,389980.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','17',463,'15','1',3848955.86,3852932.90,3977.04,656211.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','17',464,'16','1',3172550.58,3173497.05,946.47,156167.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','17',465,'17','1',3545860.10,3548129.31,2269.21,374419.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','17',466,'18','1',3206088.56,3208721.27,2632.71,434397.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','17',467,'19','1',3962306.57,3962306.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','17',468,'20','2',1826498.27,1833272.68,6774.41,4742087.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','17',469,'21','2',49465.14,49465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','17',470,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','17',471,'23','2',656360.50,659931.95,3571.45,2500015.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','17',472,'24','3',340318.04,341374.16,1056.12,580863.25,0.00,0.00,0.00,0.00,0.00),('21','221','5','17',473,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','17',474,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','17',475,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','17',476,'28','1',3648876.68,3652177.37,3300.69,544613.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','18',477,'1','1',4462707.31,4465315.83,2568.52,423805.80,0.00,0.00,40.00,0.00,0.00),('21','221','1','18',478,'2','1',5019142.26,5021910.66,2768.40,456786.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','18',479,'3','1',4180298.97,4180966.47,667.50,110137.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','18',480,'4','1',5458886.78,5461784.55,2897.77,478132.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','18',481,'5','1',3533135.01,3539250.56,6115.55,1009065.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','18',482,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','18',483,'7','1',2176975.13,2178990.76,2015.63,332578.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','18',484,'8','1',3128313.00,3131136.12,2823.12,465814.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','18',485,'9','1',5072712.85,5075491.06,2778.21,458404.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','18',486,'10','1',3123926.92,3128991.33,5064.41,835627.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','18',487,'11','1',4305703.50,4309714.46,4010.96,661808.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','18',488,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','18',489,'13','1',4207878.05,4207878.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','18',490,'14','1',3229761.61,3233872.03,4110.42,678219.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','18',491,'15','1',3852932.90,3857722.16,4789.26,790227.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','18',492,'16','1',3173497.05,3175726.96,2229.91,367935.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','18',493,'17','1',3548129.31,3552418.54,4289.23,707722.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','18',494,'18','1',3208721.27,3213604.06,4882.79,805660.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','18',495,'19','1',3962306.57,3965068.62,2762.05,455738.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','18',496,'20','2',1833272.68,1841852.07,8579.39,6005573.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','18',497,'21','2',49465.14,49465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','18',498,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','18',499,'23','2',659931.95,675484.61,15552.66,10886862.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','18',500,'24','3',341374.16,342194.67,820.51,451279.95,0.00,0.00,0.00,0.00,0.00),('21','221','5','18',501,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','18',502,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','18',503,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','18',504,'28','1',3652177.37,3652177.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','19',505,'1','1',4465315.83,4467823.22,2507.39,413719.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','19',506,'2','1',5021910.66,5024745.06,2834.40,467676.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','19',507,'3','1',4180966.47,4183566.77,2600.30,429049.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','19',508,'4','1',5461784.55,5463091.17,1306.62,215592.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','19',509,'5','1',3539250.56,3544081.04,4830.48,797029.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','19',510,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','19',511,'7','1',2178990.76,2182488.04,3497.28,577051.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','19',512,'8','1',3131136.12,3133150.65,2014.53,332397.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','19',513,'9','1',5075491.06,5077472.93,1981.87,327008.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','19',514,'10','1',3128991.33,3132458.51,3467.18,572084.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','19',515,'11','1',4309714.46,4312478.98,2764.52,456145.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','19',516,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','19',517,'13','1',4207878.05,4211215.18,3337.13,550626.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','19',518,'14','1',3233872.03,3235151.16,1239.13,204456.45,0.00,0.00,40.00,0.00,0.00),('21','221','3','19',519,'15','1',3857722.16,3860322.74,2600.58,429095.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','19',520,'16','1',3175726.96,3178650.82,2923.86,482436.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','19',521,'17','1',3552418.54,3554378.57,1960.03,323404.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','19',522,'18','1',3213604.06,3214807.31,1203.25,198536.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','19',523,'19','1',3965068.62,3967387.54,2318.92,382621.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','19',524,'20','2',1841852.07,1847984.22,6132.15,4292505.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','19',525,'21','2',49465.14,49465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','19',526,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','19',527,'23','2',675484.61,680986.55,5501.94,3851358.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','19',528,'24','3',342194.67,343754.11,1559.44,857691.45,0.00,0.00,0.00,0.00,0.00),('21','221','5','19',529,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','19',530,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','19',531,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','19',532,'28','1',3652177.37,3653551.29,1373.92,226696.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','20',533,'1','1',4467823.22,4473436.38,5613.16,926171.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','20',534,'2','1',5024745.06,5029075.95,4330.89,714596.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','20',535,'3','1',4183566.77,4187300.66,3733.89,616091.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','20',536,'4','1',5463091.17,5468242.40,5151.23,849952.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','20',537,'5','1',3544081.04,3550579.20,6498.16,1072196.73,0.00,0.00,0.00,0.00,0.00),('21','221','2','20',538,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','20',539,'7','1',2182488.04,2185436.51,2948.47,486497.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','20',540,'8','1',3133150.65,3137166.86,4016.21,662674.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','20',541,'9','1',5077472.93,5082133.91,4660.98,769061.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','20',542,'10','1',3132458.51,3136600.61,4142.10,683446.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','20',543,'11','1',4312478.98,4315589.15,3110.17,513178.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','20',544,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','20',545,'13','1',4211215.18,4214954.27,3739.09,616949.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','20',546,'14','1',3235151.16,3240084.57,4893.41,807412.65,0.00,0.00,40.00,0.00,0.00),('21','221','3','20',547,'15','1',3860322.74,3862562.19,2239.45,369509.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','20',548,'16','1',3178650.82,3183252.34,4601.52,759250.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','20',549,'17','1',3554378.57,3558500.79,4122.22,680166.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','20',550,'18','1',3214807.31,3217156.00,2348.69,387533.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','20',551,'19','1',3967387.54,3972031.43,4643.89,766241.85,0.00,0.00,0.00,0.00,0.00),('21','221','4','20',552,'20','2',1847984.22,1855703.13,7718.91,5403237.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','20',553,'21','2',49465.14,49465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','20',554,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','20',555,'23','2',680986.55,685497.43,4510.88,3157616.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','20',556,'24','3',343754.11,345402.41,1648.30,906562.25,0.00,0.00,0.00,0.00,0.00),('21','221','5','20',557,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','20',558,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','20',559,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','20',560,'28','1',3653551.29,3656969.16,3417.87,563948.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','21',561,'1','1',4473436.38,4477588.56,4112.18,678509.70,0.00,0.00,40.00,0.00,0.00),('21','221','1','21',562,'2','1',5029075.95,5032206.41,3130.46,516525.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','21',563,'3','1',4187300.66,4190627.01,3326.35,548847.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','21',564,'4','1',5468242.40,5472180.74,3938.34,649826.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','21',565,'5','1',3550579.20,3558951.81,8372.61,1381480.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','21',566,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','21',567,'7','1',2185436.51,2188656.74,3220.23,531337.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','21',568,'8','1',3137166.86,3140293.80,3126.94,515945.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','21',569,'9','1',5082133.91,5086604.43,4470.52,737635.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','21',570,'10','1',3136600.61,3144306.51,7705.90,1271473.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','21',571,'11','1',4315589.15,4319954.34,4365.19,720256.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','21',572,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','21',573,'13','1',4214954.27,4220089.88,5135.61,847375.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','21',574,'14','1',3240084.57,3244168.89,4084.32,673912.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','21',575,'15','1',3862562.19,3864315.50,1753.31,289296.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','21',576,'16','1',3183252.34,3185686.31,2433.97,401605.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','21',577,'17','1',3558500.79,3560290.26,1789.47,295262.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','21',578,'18','1',3217156.00,3220422.31,3266.31,538941.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','21',579,'19','1',3972031.43,3974604.64,2573.21,424578.99,0.00,0.00,0.00,0.00,0.00),('21','221','4','21',580,'20','2',1855703.13,1860262.10,4558.97,3191279.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','21',581,'21','2',49465.14,50542.60,1077.46,754222.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','21',582,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','21',583,'23','2',685497.43,691123.26,5625.83,3938081.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','21',584,'24','3',345402.41,346308.13,905.72,498143.25,0.00,0.00,0.00,0.00,0.00),('21','221','5','21',585,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','21',586,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','21',587,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','21',588,'28','1',3656969.16,3659517.92,2548.76,420545.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','22',589,'1','1',4477588.56,4482132.02,4543.46,749670.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','22',590,'2','1',5032206.41,5033945.65,1739.24,286974.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','22',591,'3','1',4190627.01,4192607.80,1980.79,326830.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','22',592,'4','1',5472180.74,5474784.81,2604.07,429671.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','22',593,'5','1',3558951.81,3564824.79,5872.98,969041.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','22',594,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','22',595,'7','1',2188656.74,2192412.25,3755.51,619659.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','22',596,'8','1',3140293.80,3143541.93,3248.13,535941.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','22',597,'9','1',5086604.43,5089819.83,3215.40,530541.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','22',598,'10','1',3144306.51,3149068.05,4761.54,785654.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','22',599,'11','1',4319954.34,4323595.64,3601.30,594214.50,0.00,0.00,40.00,0.00,0.00),('21','221','2','22',600,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','22',601,'13','1',4220089.88,4223458.64,3368.76,555845.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','22',602,'14','1',3244168.89,3247995.52,3826.63,631393.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','22',603,'15','1',3864315.50,3865808.13,1492.63,246283.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','22',604,'16','1',3185686.31,3188877.56,3191.25,526556.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','22',605,'17','1',3560290.26,3563712.15,3421.89,564611.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','22',606,'18','1',3220422.31,3221696.55,1274.24,210249.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','22',607,'19','1',3974604.64,3978280.41,3675.77,606502.05,0.00,0.00,0.00,0.00,0.00),('21','221','4','22',608,'20','2',1860262.10,1868193.80,7931.70,5552190.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','22',609,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','22',610,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','22',611,'23','2',691123.26,699504.23,8380.97,5866679.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','22',612,'24','3',346308.13,346811.32,503.19,276753.95,0.00,0.00,0.00,0.00,0.00),('21','221','5','22',613,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','22',614,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','22',615,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','22',616,'28','1',3659517.92,3662973.95,3456.03,570244.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','23',617,'1','1',4482132.02,4485596.65,3464.63,571663.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','23',618,'2','1',5033945.65,5037078.61,3132.96,516938.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','23',619,'3','1',4192607.80,4194779.50,2171.70,358330.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','23',620,'4','1',5474784.81,5478105.41,3320.60,547899.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','23',621,'5','1',3564824.79,3570059.78,5234.99,863773.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','23',622,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','23',623,'7','1',2192412.25,2194577.73,2165.48,357304.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','23',624,'8','1',3143541.93,3146401.17,2859.24,471774.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','23',625,'9','1',5089819.83,5092510.71,2690.88,443995.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','23',626,'10','1',3149068.05,3152307.50,3239.45,534509.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','23',627,'11','1',4323595.64,4326644.73,3049.09,503099.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','23',628,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','23',629,'13','1',4223458.64,4226841.40,3382.76,558155.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','23',630,'14','1',3247995.52,3250707.27,2711.75,447438.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','23',631,'15','1',3865808.13,3868304.07,2455.94,405230.10,0.00,0.00,40.00,0.00,0.00),('21','221','3','23',632,'16','1',3188877.56,3192478.07,3600.51,594084.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','23',633,'17','1',3563712.15,3566407.19,2695.04,444681.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','23',634,'18','1',3221696.55,3223918.59,2222.04,366636.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','23',635,'19','1',3978280.41,3980694.27,2413.86,398286.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','23',636,'20','2',1868193.80,1874218.04,6024.24,4216968.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','23',637,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','23',638,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','23',639,'23','2',699504.23,705561.84,6057.61,4240327.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','23',640,'24','3',346811.32,347295.34,484.02,266212.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','23',641,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','23',642,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','23',643,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','23',644,'28','1',3662973.95,3664047.24,1073.29,177092.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','24',645,'1','1',4485596.65,4488784.37,3187.72,525973.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','24',646,'2','1',5037078.61,5039879.92,2801.31,462216.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','24',647,'3','1',4194779.50,4197596.63,2817.13,464826.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','24',648,'4','1',5478105.41,5481076.35,2970.94,490205.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','24',649,'5','1',3570059.78,3576226.23,6166.45,1017464.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','24',650,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','24',651,'7','1',2194577.73,2197308.80,2731.07,450626.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','24',652,'8','1',3146401.17,3149405.69,3004.52,495745.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','24',653,'9','1',5092510.71,5096344.45,3833.74,632567.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','24',654,'10','1',3152307.50,3157407.66,5100.16,841526.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','24',655,'11','1',4326644.73,4330307.66,3662.93,604383.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','24',656,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','24',657,'13','1',4226841.40,4230201.01,3359.61,554335.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','24',658,'14','1',3250707.27,3253346.75,2639.48,435514.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','24',659,'15','1',3868304.07,3870865.14,2561.07,422576.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','24',660,'16','1',3192478.07,3196117.53,3599.46,593910.90,0.00,0.00,40.00,0.00,0.00),('21','221','3','24',661,'17','1',3566407.19,3569424.12,3016.93,497793.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','24',662,'18','1',3223918.59,3226382.07,2463.48,406474.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','24',663,'19','1',3980694.27,3983401.80,2707.53,446742.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','24',664,'20','2',1874218.04,1883803.66,9585.62,6709934.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','24',665,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','24',666,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','24',667,'23','2',705561.84,713977.45,8415.61,5890927.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','24',668,'24','3',347295.34,348217.33,921.99,507092.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','24',669,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','24',670,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','24',671,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','24',672,'28','1',3664047.24,3667207.73,3160.49,521480.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','25',673,'1','1',4488784.37,4489527.86,703.49,116075.85,0.00,0.00,40.00,0.00,0.00),('21','221','1','25',674,'2','1',5039879.92,5043264.77,3384.85,558500.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','25',675,'3','1',4197596.63,4201895.27,4298.64,709275.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','25',676,'4','1',5481076.35,5487177.44,6101.09,1006679.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','25',677,'5','1',3576226.23,3580534.49,4308.26,710862.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','25',678,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','25',679,'7','1',2197308.80,2201265.38,3956.58,652835.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','25',680,'8','1',3149405.69,3151643.83,2238.14,369293.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','25',681,'9','1',5096344.45,5099189.54,2845.09,469439.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','25',682,'10','1',3157407.66,3162712.31,5304.65,875267.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','25',683,'11','1',4330307.66,4333329.20,3021.54,498554.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','25',684,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','25',685,'13','1',4230201.01,4233556.93,3355.92,553726.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','25',686,'14','1',3253346.75,3256133.79,2787.04,459861.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','25',687,'15','1',3870865.14,3874629.18,3764.04,621066.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','25',688,'16','1',3196117.53,3199903.08,3785.55,624615.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','25',689,'17','1',3569424.12,3570585.64,1161.52,191650.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','25',690,'18','1',3226382.07,3229448.72,3066.65,505997.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','25',691,'19','1',3983401.80,3987589.85,4188.05,691028.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','25',692,'20','2',1883803.66,1890287.66,6484.00,4538800.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','25',693,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','25',694,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','25',695,'23','2',713977.45,716072.75,2095.30,1466710.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','25',696,'24','3',348217.33,348966.10,748.77,411824.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','25',697,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','25',698,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','25',699,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','25',700,'28','1',3667207.73,3669081.69,1873.96,309203.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','26',701,'1','1',4489527.86,4491018.91,1451.05,239423.25,0.00,0.00,40.00,0.00,0.00),('21','221','1','26',702,'2','1',5043264.77,5046560.56,3295.79,543805.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','26',703,'3','1',4201895.27,4206754.26,4858.99,801733.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','26',704,'4','1',5487177.44,5490762.42,3584.98,591521.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','26',705,'5','1',3580534.49,3584668.18,4133.69,682058.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','26',706,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','26',707,'7','1',2201265.38,2203544.15,2278.77,375997.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','26',708,'8','1',3151643.83,3154622.11,2978.28,491416.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','26',709,'9','1',5099189.54,5102630.80,3441.26,567807.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','26',710,'10','1',3162712.31,3167755.69,5043.38,832157.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','26',711,'11','1',4333329.20,4335366.72,2037.52,336190.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','26',712,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','26',713,'13','1',4233556.93,4237668.99,4112.06,678489.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','26',714,'14','1',3256133.79,3259740.18,3606.39,595054.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','26',715,'15','1',3874629.18,3877274.81,2645.63,436528.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','26',716,'16','1',3199903.08,3202879.52,2976.44,491112.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','26',717,'17','1',3570585.64,3573549.45,2963.81,489028.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','26',718,'18','1',3229448.72,3232578.54,3129.82,516420.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','26',719,'19','1',3987589.85,3991543.04,3953.19,652276.35,0.00,0.00,0.00,0.00,0.00),('21','221','4','26',720,'20','2',1890287.66,1897404.82,7117.16,4982012.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','26',721,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','26',722,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','26',723,'23','2',716072.75,723260.59,7187.84,5031488.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','26',724,'24','3',348966.10,350128.67,1162.57,639414.05,0.00,0.00,0.00,0.00,0.00),('21','221','5','26',725,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','26',726,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','26',727,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','26',728,'28','1',3669081.69,3672392.66,3310.97,546310.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','27',729,'1','1',4491018.91,4495834.60,4815.69,794588.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','27',730,'2','1',5046560.56,5050562.18,3961.62,653667.30,0.00,0.00,40.00,0.00,0.00),('21','221','1','27',731,'3','1',4206754.26,4211545.54,4791.28,790561.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','27',732,'4','1',5490762.42,5497425.32,6662.90,1099378.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','27',733,'5','1',3584668.18,3589426.12,4757.94,785060.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','27',734,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','27',735,'7','1',2203544.15,2206128.19,2584.04,426366.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','27',736,'8','1',3154622.11,3158062.52,3440.41,567667.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','27',737,'9','1',5102630.80,5106053.45,3422.65,564737.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','27',738,'10','1',3167755.69,3171642.49,3886.80,641322.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','27',739,'11','1',4335366.72,4337532.45,2165.73,357345.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','27',740,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','27',741,'13','1',4237668.99,4241180.86,3511.87,579458.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','27',742,'14','1',3259740.18,3261875.13,2134.95,352266.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','27',743,'15','1',3877274.81,3880053.66,2778.85,458510.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','27',744,'16','1',3202879.52,3205104.48,2224.96,367118.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','27',745,'17','1',3573549.45,3575314.50,1765.05,291233.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','27',746,'18','1',3232578.54,3234604.79,2026.25,334331.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','27',747,'19','1',3991543.04,3994544.91,3001.87,495308.55,0.00,0.00,0.00,0.00,0.00),('21','221','4','27',748,'20','2',1897404.82,1904368.99,6964.17,4874919.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','27',749,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','27',750,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','27',751,'23','2',723260.59,730041.15,6780.56,4746392.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','27',752,'24','3',350128.67,351594.60,1465.93,806258.75,0.00,0.00,0.00,0.00,0.00),('21','221','5','27',753,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','27',754,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','27',755,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','27',756,'28','1',3672392.66,3674982.37,2589.71,427302.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','28',757,'1','1',4495834.60,4498171.92,2337.32,385657.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','28',758,'2','1',5050562.18,5052366.17,1803.99,297658.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','28',759,'3','1',4211545.54,4214221.16,2675.62,441477.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','28',760,'4','1',5497425.32,5499861.82,2436.50,402022.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','28',761,'5','1',3589426.12,3594053.14,4627.02,763458.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','28',762,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','28',763,'7','1',2206128.19,2208721.56,2593.37,427906.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','28',764,'8','1',3158062.52,3159515.91,1453.39,239809.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','28',765,'9','1',5106053.45,5109744.58,3651.13,602436.45,0.00,0.00,40.00,0.00,0.00),('21','221','2','28',766,'10','1',3171642.49,3176868.51,5226.02,862293.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','28',767,'11','1',4337532.45,4340868.29,3335.84,550413.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','28',768,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','28',769,'13','1',4241180.86,4245468.26,4287.40,707421.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','28',770,'14','1',3261875.13,3264686.54,2811.41,463882.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','28',771,'15','1',3880053.66,3883745.56,3691.90,609163.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','28',772,'16','1',3205104.48,3208534.17,3429.69,565898.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','28',773,'17','1',3575314.50,3578380.61,3066.11,505908.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','28',774,'18','1',3234604.79,3239799.40,5194.61,857110.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','28',775,'19','1',3994544.91,3999246.55,4701.64,775770.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','28',776,'20','2',1904368.99,1911171.68,6802.69,4761883.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','28',777,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','28',778,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','28',779,'23','2',730041.15,736316.83,6275.68,4392976.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','28',780,'24','3',351594.60,352401.15,806.55,443601.95,0.00,0.00,0.00,0.00,0.00),('21','221','5','28',781,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','28',782,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','28',783,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','28',784,'28','1',3674982.37,3677774.19,2791.82,460650.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','29',785,'1','1',4498171.92,4501437.23,3265.31,538776.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','29',786,'2','1',5052366.17,5054537.73,2171.56,358307.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','29',787,'3','1',4214221.16,4217728.44,3507.28,578701.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','29',788,'4','1',5499861.82,5504366.97,4505.15,743349.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','29',789,'5','1',3594053.14,3598632.76,4579.62,755637.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','29',790,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','29',791,'7','1',2208721.56,2210831.05,2109.49,348065.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','29',792,'8','1',3159515.91,3161922.23,2406.32,397042.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','29',793,'9','1',5109744.58,5113674.50,3929.92,648436.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','29',794,'10','1',3176868.51,3180304.36,3435.85,566915.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','29',795,'11','1',4340868.29,4343343.49,2475.20,408408.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','29',796,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','29',797,'13','1',4245468.26,4249576.39,4068.13,671241.45,0.00,0.00,40.00,0.00,0.00),('21','221','3','29',798,'14','1',3264686.54,3267512.37,2825.83,466261.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','29',799,'15','1',3883745.56,3887063.09,3317.53,547392.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','29',800,'16','1',3208534.17,3211850.03,3315.86,547116.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','29',801,'17','1',3578380.61,3581650.96,3270.35,539607.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','29',802,'18','1',3239799.40,3243248.02,3448.62,569022.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','29',803,'19','1',3999246.55,4002696.14,3449.59,569182.35,0.00,0.00,0.00,0.00,0.00),('21','221','4','29',804,'20','2',1911171.68,1918480.23,7308.55,5115985.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','29',805,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','29',806,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','29',807,'23','2',736316.83,741592.44,5275.61,3692927.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','29',808,'24','3',352401.15,353439.99,1038.84,571361.45,0.00,0.00,0.00,0.00,0.00),('21','221','5','29',809,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','29',810,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','29',811,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','29',812,'28','1',3677774.19,3681255.25,3481.06,574374.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','30',813,'1','1',4501437.23,4504359.94,2922.71,482247.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','30',814,'2','1',5054537.73,5057343.89,2806.16,463016.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','30',815,'3','1',4217728.44,4220806.47,3078.03,507874.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','30',816,'4','1',5504366.97,5507475.46,3108.49,512900.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','30',817,'5','1',3598632.76,3604026.20,5393.44,889917.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','30',818,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','30',819,'7','1',2210831.05,2213807.10,2976.05,491048.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','30',820,'8','1',3161922.23,3165135.15,3212.92,530131.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','30',821,'9','1',5113674.50,5116830.95,3156.45,520814.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','30',822,'10','1',3180304.36,3185684.84,5380.48,887779.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','30',823,'11','1',4343343.49,4346232.98,2889.49,476765.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','30',824,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','30',825,'13','1',4249576.39,4253154.28,3577.89,590351.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','30',826,'14','1',3267512.37,3269193.28,1680.91,277350.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','30',827,'15','1',3887063.09,3891654.75,4591.66,757623.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','30',828,'16','1',3211850.03,3214301.00,2450.97,404410.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','30',829,'17','1',3581650.96,3585390.58,3739.62,617037.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','30',830,'18','1',3243248.02,3246075.86,2827.84,466593.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','30',831,'19','1',4002696.14,4006251.80,3515.66,580083.90,0.00,0.00,40.00,0.00,0.00),('21','221','4','30',832,'20','2',1918480.23,1924628.66,6148.43,4303901.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','30',833,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','30',834,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','30',835,'23','2',741592.44,746629.25,5036.81,3525767.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','30',836,'24','3',353439.99,354331.19,891.20,490161.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','30',837,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','30',838,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','30',839,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','30',840,'28','1',3681255.25,3684095.98,2840.73,468720.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','31',841,'1','1',4504359.94,4506854.50,2494.56,411602.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','31',842,'2','1',5057343.89,5059719.47,2375.58,391970.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','31',843,'3','1',4220806.47,4223525.00,2718.53,448557.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','31',844,'4','1',5507475.46,5509852.40,2376.94,392195.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','31',845,'5','1',3604026.20,3608567.17,4540.97,749260.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','31',846,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','31',847,'7','1',2213807.10,2216575.78,2768.68,456832.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','31',848,'8','1',3165135.15,3167257.08,2121.93,350118.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','31',849,'9','1',5116830.95,5120079.69,3248.74,536042.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','31',850,'10','1',3185684.84,3190329.51,4644.67,766370.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','31',851,'11','1',4346232.98,4349135.83,2902.85,478970.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','31',852,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','31',853,'13','1',4253154.28,4255803.00,2648.72,437038.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','31',854,'14','1',3269193.28,3271609.60,2416.32,398692.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','31',855,'15','1',3891654.75,3894816.07,3161.32,521617.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','31',856,'16','1',3214301.00,3214819.39,478.39,78934.35,0.00,0.00,40.00,0.00,0.00),('21','221','3','31',857,'17','1',3585390.58,3588873.95,3483.37,574756.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','31',858,'18','1',3246075.86,3248238.90,2163.04,356901.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','31',859,'19','1',4006251.80,4009033.62,2781.82,459000.30,0.00,0.00,0.00,0.00,0.00),('21','221','4','31',860,'20','2',1924628.66,1930515.90,5887.24,4121068.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','31',861,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','31',862,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','31',863,'23','2',746629.25,750368.91,3739.66,2617762.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','31',864,'24','3',354331.19,355403.31,1072.12,589665.45,0.00,0.00,0.00,0.00,0.00),('21','221','5','31',865,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','31',866,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','31',867,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','31',868,'28','1',3684095.98,3686570.99,2475.01,408376.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','32',869,'1','1',4506854.50,4510045.68,3151.18,519944.70,0.00,0.00,40.00,0.00,0.00),('21','221','1','32',870,'2','1',5059719.47,5062392.70,2673.23,441082.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','32',871,'3','1',4223525.00,4225398.11,1873.11,309063.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','32',872,'4','1',5509852.40,5513730.84,3878.44,639942.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','32',873,'5','1',3608567.17,3615364.45,6797.28,1121551.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','32',874,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','32',875,'7','1',2216575.78,2219641.17,3065.39,505789.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','32',876,'8','1',3167257.08,3170111.83,2854.75,471033.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','32',877,'9','1',5120079.69,5124409.67,4329.98,714446.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','32',878,'10','1',3190329.51,3195878.72,5549.21,915619.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','32',879,'11','1',4349135.83,4353083.61,3947.78,651383.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','32',880,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','32',881,'13','1',4255803.00,4258944.48,3141.48,518344.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','32',882,'14','1',3271609.60,3273075.96,1466.36,241949.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','32',883,'15','1',3894816.07,3897937.67,3121.60,515064.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','32',884,'16','1',3214819.39,3218288.72,3469.33,572439.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','32',885,'17','1',3588873.95,3591064.16,2190.21,361384.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','32',886,'18','1',3248238.90,3250641.66,2402.76,396455.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','32',887,'19','1',4009033.62,4012098.08,3064.46,505635.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','32',888,'20','2',1930515.90,1935921.52,5405.62,3783934.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','32',889,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','32',890,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','32',891,'23','2',750368.91,750477.68,108.77,76139.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','32',892,'24','3',355403.31,356056.58,653.27,359296.85,0.00,0.00,0.00,0.00,0.00),('21','221','5','32',893,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','32',894,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','32',895,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','32',896,'28','1',3686570.99,3689805.08,3234.09,533624.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','33',897,'1','1',4510045.68,4513720.21,3674.53,606297.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','33',898,'2','1',5062392.70,5065327.14,2934.44,484182.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','33',899,'3','1',4225398.11,4228588.20,3190.09,526364.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','33',900,'4','1',5513730.84,5517296.63,3565.79,588355.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','33',901,'5','1',3615364.45,3620371.03,5006.58,826085.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','33',902,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','33',903,'7','1',2219641.17,2221226.58,1585.41,261592.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','33',904,'8','1',3170111.83,3173696.64,3584.81,591493.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','33',905,'9','1',5124409.67,5128974.18,4564.51,753144.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','33',906,'10','1',3195878.72,3200044.69,4165.97,687385.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','33',907,'11','1',4353083.61,4353734.77,651.16,107441.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','33',908,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','33',909,'13','1',4258944.48,4262994.54,4050.06,668259.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','33',910,'14','1',3273075.96,3274873.00,1757.04,289911.60,0.00,0.00,40.00,0.00,0.00),('21','221','3','33',911,'15','1',3897937.67,3900366.37,2428.70,400735.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','33',912,'16','1',3218288.72,3220879.65,2590.93,427503.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','33',913,'17','1',3591064.16,3593358.88,2294.72,378628.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','33',914,'18','1',3250641.66,3252991.40,2349.74,387707.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','33',915,'19','1',4012098.08,4014614.19,2516.11,415158.15,0.00,0.00,0.00,0.00,0.00),('21','221','4','33',916,'20','2',1935921.52,1940217.13,4295.61,3006927.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','33',917,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','33',918,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','33',919,'23','2',750477.68,752148.63,1670.95,1169665.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','33',920,'24','3',356056.58,356632.73,576.15,316883.05,0.00,0.00,0.00,0.00,0.00),('21','221','5','33',921,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','33',922,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','33',923,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','33',924,'28','1',3689805.08,3692180.40,2375.32,391927.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','34',925,'1','1',4513720.21,4513720.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','34',926,'2','1',5065327.14,5065327.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','34',927,'3','1',4228588.20,4228588.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','34',928,'4','1',5517296.63,5517296.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','34',929,'5','1',3620371.03,3620371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','34',930,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','34',931,'7','1',2221226.58,2221226.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','34',932,'8','1',3173696.64,3173696.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','34',933,'9','1',5128974.18,5128974.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','34',934,'10','1',3200044.69,3200044.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','34',935,'11','1',4353734.77,4353734.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','34',936,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','34',937,'13','1',4262994.54,4262994.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','34',938,'14','1',3274873.00,3274873.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','34',939,'15','1',3900366.37,3900366.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','34',940,'16','1',3220879.65,3220879.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','34',941,'17','1',3593358.88,3593358.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','34',942,'18','1',3252991.40,3252991.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','34',943,'19','1',4014614.19,4014614.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','34',944,'20','2',1940217.13,1940217.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','34',945,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','34',946,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','34',947,'23','2',752148.63,752148.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','34',948,'24','3',356632.73,356632.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','34',949,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','34',950,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','34',951,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','34',952,'28','1',3692180.40,3692180.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','35',953,'1','1',4513720.21,4518050.40,4290.19,707881.35,0.00,0.00,40.00,0.00,0.00),('21','221','1','35',954,'2','1',5065327.14,5069971.62,4644.48,766339.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','35',955,'3','1',4228588.20,4232470.37,3882.17,640558.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','35',956,'4','1',5517296.63,5521146.52,3849.89,635231.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','35',957,'5','1',3620371.03,3625902.04,5531.01,912616.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','35',958,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','35',959,'7','1',2221226.58,2223811.26,2584.68,426472.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','35',960,'8','1',3173696.64,3176406.56,2709.92,447136.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','35',961,'9','1',5128974.18,5133235.49,4261.31,703116.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','35',962,'10','1',3200044.69,3205742.08,5697.39,940069.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','35',963,'11','1',4353734.77,4356510.91,2776.14,458063.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','35',964,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','35',965,'13','1',4262994.54,4267050.24,4055.70,669190.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','35',966,'14','1',3274873.00,3278575.31,3702.31,610881.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','35',967,'15','1',3900366.37,3903826.21,3459.84,570873.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','35',968,'16','1',3220879.65,3224837.29,3957.64,653010.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','35',969,'17','1',3593358.88,3595895.66,2536.78,418568.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','35',970,'18','1',3252991.40,3256624.39,3632.99,599443.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','35',971,'19','1',4014614.19,4017772.27,3158.08,521083.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','35',972,'20','2',1940217.13,1942145.82,1928.69,1350083.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','35',973,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','35',974,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','35',975,'23','2',752148.63,752148.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','35',976,'24','3',356632.73,357705.66,1072.93,590113.70,0.00,0.00,0.00,0.00,0.00),('21','221','5','35',977,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','35',978,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','35',979,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','35',980,'28','1',3692180.40,3694692.75,2512.35,414537.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','36',981,'1','1',4518050.40,4522868.84,4818.44,795042.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','36',982,'2','1',5069971.62,5073546.64,3575.02,589878.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','36',983,'3','1',4232470.37,4235493.07,3022.70,498745.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','36',984,'4','1',5521146.52,5524935.35,3788.83,625156.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','36',985,'5','1',3625902.04,3632844.40,6942.36,1145489.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','36',986,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','36',987,'7','1',2223811.26,2227503.27,3692.01,609181.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','36',988,'8','1',3176406.56,3179631.95,3225.39,532189.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','36',989,'9','1',5133235.49,5136842.85,3607.36,595214.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','36',990,'10','1',3205742.08,3211048.45,5306.37,875551.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','36',991,'11','1',4356510.91,4360582.79,4071.88,671860.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','36',992,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','36',993,'13','1',4267050.24,4270818.96,3768.72,621838.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','36',994,'14','1',3278575.31,3282115.99,3540.68,584212.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','36',995,'15','1',3903826.21,3907241.22,3375.01,556876.65,0.00,0.00,40.00,0.00,0.00),('21','221','3','36',996,'16','1',3224837.29,3228156.85,3319.56,547727.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','36',997,'17','1',3595895.66,3598925.23,3029.57,499879.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','36',998,'18','1',3256624.39,3259412.73,2788.34,460076.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','36',999,'19','1',4017772.27,4021729.47,3957.20,652938.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','36',1000,'20','2',1942145.82,1946837.40,4691.58,3284106.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','36',1001,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','36',1002,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','36',1003,'23','2',752148.63,757318.45,5169.82,3618874.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','36',1004,'24','3',357705.66,358546.52,840.86,462475.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','36',1005,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','36',1006,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','36',1007,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','36',1008,'28','1',3694692.75,3697222.64,2529.89,417431.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','37',1009,'1','1',4522868.84,4526556.28,3687.44,608427.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','37',1010,'2','1',5073546.64,5077885.47,4338.83,715906.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','37',1011,'3','1',4235493.07,4238874.42,3341.35,551322.75,0.00,0.00,40.00,0.00,0.00),('21','221','1','37',1012,'4','1',5524935.35,5529484.14,4548.79,750550.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','37',1013,'5','1',3632844.40,3638951.92,6107.52,1007740.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','37',1014,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','37',1015,'7','1',2227503.27,2231085.93,3582.66,591138.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','37',1016,'8','1',3179631.95,3181799.71,2167.76,357680.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','37',1017,'9','1',5136842.85,5140612.76,3769.91,622035.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','37',1018,'10','1',3211048.45,3216425.41,5376.96,887198.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','37',1019,'11','1',4360582.79,4363957.89,3375.10,556891.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','37',1020,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','37',1021,'13','1',4270818.96,4275854.57,5035.61,830875.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','37',1022,'14','1',3282115.99,3285367.42,3251.43,536485.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','37',1023,'15','1',3907241.22,3910989.07,3747.85,618395.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','37',1024,'16','1',3228156.85,3230764.10,2607.25,430196.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','37',1025,'17','1',3598925.23,3603265.59,4340.36,716159.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','37',1026,'18','1',3259412.73,3262271.40,2858.67,471680.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','37',1027,'19','1',4021729.47,4023705.28,1975.81,326008.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','37',1028,'20','2',1946837.40,1952375.66,5538.26,3876782.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','37',1029,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','37',1030,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','37',1031,'23','2',757318.45,761337.51,4019.06,2813342.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','37',1032,'24','3',358546.52,359468.29,921.77,506971.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','37',1033,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','37',1034,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','37',1035,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','37',1036,'28','1',3697222.64,3699518.23,2295.59,378772.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','38',1037,'1','1',4526556.28,4529834.55,3278.27,540914.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','38',1038,'2','1',5077885.47,5082573.83,4688.36,773579.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','38',1039,'3','1',4238874.42,4243061.70,4187.28,690901.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','38',1040,'4','1',5529484.14,5532447.26,2963.12,488914.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','38',1041,'5','1',3638951.92,3644330.86,5378.94,887525.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','38',1042,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','38',1043,'7','1',2231085.93,2234626.96,3541.03,584269.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','38',1044,'8','1',3181799.71,3185383.52,3583.81,591328.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','38',1045,'9','1',5140612.76,5145530.54,4917.78,811433.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','38',1046,'10','1',3216425.41,3222119.41,5694.00,939510.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','38',1047,'11','1',4363957.89,4366626.95,2669.06,440394.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','38',1048,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','38',1049,'13','1',4275854.57,4281926.51,6071.94,1001870.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','38',1050,'14','1',3285367.42,3289283.72,3916.30,646189.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','38',1051,'15','1',3910989.07,3915304.28,4315.21,712009.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','38',1052,'16','1',3230764.10,3233609.79,2805.69,462938.85,0.00,0.00,40.00,0.00,0.00),('21','221','3','38',1053,'17','1',3603265.59,3607922.41,4656.82,768375.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','38',1054,'18','1',3262271.40,3265461.31,3189.91,526335.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','38',1055,'19','1',4023705.28,4023705.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','38',1056,'20','2',1952375.66,1955964.73,3589.07,2512349.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','38',1057,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','38',1058,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','38',1059,'23','2',761337.51,764247.45,2909.94,2036958.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','38',1060,'24','3',359468.29,360170.86,702.57,386415.70,0.00,0.00,0.00,0.00,0.00),('21','221','5','38',1061,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','38',1062,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','38',1063,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','38',1064,'28','1',3699518.23,3704076.87,4558.64,752175.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','39',1065,'1','1',4529834.55,4531166.47,1331.92,219766.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','39',1066,'2','1',5082573.83,5084314.14,1740.31,287151.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','39',1067,'3','1',4243061.70,4245050.42,1988.72,328138.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','39',1068,'4','1',5532447.26,5536345.34,3898.08,643183.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','39',1069,'5','1',3644330.86,3649708.51,5377.65,887312.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','39',1070,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','39',1071,'7','1',2234626.96,2237706.17,3079.21,508069.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','39',1072,'8','1',3185383.52,3187984.11,2600.59,429097.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','39',1073,'9','1',5145530.54,5150170.20,4639.66,765543.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','39',1074,'10','1',3222119.41,3227562.77,5443.36,898154.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','39',1075,'11','1',4366626.95,4370465.34,3838.39,633334.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','39',1076,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','39',1077,'13','1',4281926.51,4286006.22,4079.71,673152.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','39',1078,'14','1',3289283.72,3291034.96,1751.24,288954.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','39',1079,'15','1',3915304.28,3919800.16,4495.88,741820.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','39',1080,'16','1',3233609.79,3236743.13,3133.34,517001.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','39',1081,'17','1',3607922.41,3610593.54,2671.13,440736.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','39',1082,'18','1',3265461.31,3269568.65,4067.34,671111.10,0.00,0.00,40.00,0.00,0.00),('21','221','3','39',1083,'19','1',4023705.28,4026612.11,2906.83,479626.95,0.00,0.00,0.00,0.00,0.00),('21','221','4','39',1084,'20','2',1955964.73,1959927.96,3963.23,2774261.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','39',1085,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','39',1086,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','39',1087,'23','2',764247.45,767141.20,2893.75,2025625.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','39',1088,'24','3',360170.86,361110.36,939.50,516722.25,0.00,0.00,0.00,0.00,0.00),('21','221','5','39',1089,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','39',1090,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','39',1091,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','39',1092,'28','1',3704076.87,3706390.56,2313.69,381758.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','40',1093,'1','1',4531166.47,4533631.02,2464.55,406650.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','40',1094,'2','1',5084314.14,5086856.39,2542.25,419471.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','40',1095,'3','1',4245050.42,4248162.07,3111.65,513422.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','40',1096,'4','1',5536345.34,5539017.64,2672.30,440929.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','40',1097,'5','1',3649708.51,3654475.36,4766.85,786530.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','40',1098,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','40',1099,'7','1',2237706.17,2241356.95,3650.78,602378.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','40',1100,'8','1',3187984.11,3190278.19,2294.08,378523.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','40',1101,'9','1',5150170.20,5153525.92,3355.72,553693.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','40',1102,'10','1',3227562.77,3232935.78,5373.01,886546.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','40',1103,'11','1',4370465.34,4373645.49,3180.15,524724.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','40',1104,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','40',1105,'13','1',4286006.22,4289868.96,3862.74,637352.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','40',1106,'14','1',3291034.96,3293742.10,2707.14,446678.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','40',1107,'15','1',3919800.16,3922256.02,2455.86,405216.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','40',1108,'16','1',3236743.13,3239397.02,2653.89,437891.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','40',1109,'17','1',3610593.54,3612972.87,2379.33,392589.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','40',1110,'18','1',3269568.65,3271469.98,1901.33,313719.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','40',1111,'19','1',4026612.11,4029930.27,3278.16,540896.40,0.00,0.00,40.00,0.00,0.00),('21','221','4','40',1112,'20','2',1959927.96,1962130.35,2202.39,1541673.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','40',1113,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','40',1114,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','40',1115,'23','2',767141.20,776614.34,9473.14,6631198.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','40',1116,'24','3',361110.36,361762.64,652.28,358754.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','40',1117,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','40',1118,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','40',1119,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','40',1120,'28','1',3706390.56,3709593.48,3202.92,528481.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','41',1121,'1','1',4533631.02,4537997.73,4366.71,720507.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','41',1122,'2','1',5086856.39,5089786.23,2929.84,483423.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','41',1123,'3','1',4248162.07,4251841.22,3679.15,607059.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','41',1124,'4','1',5539017.64,5543114.25,4096.61,675940.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','41',1125,'5','1',3654475.36,3659514.46,5039.10,831451.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','41',1126,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','41',1127,'7','1',2241356.95,2244194.19,2837.24,468144.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','41',1128,'8','1',3190278.19,3193276.53,2998.34,494726.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','41',1129,'9','1',5153525.92,5156447.88,2881.96,475523.40,0.00,0.00,40.00,0.00,0.00),('21','221','2','41',1130,'10','1',3232935.78,3237663.25,4727.47,780032.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','41',1131,'11','1',4373645.49,4376911.98,3266.49,538970.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','41',1132,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','41',1133,'13','1',4289868.96,4293292.65,3423.69,564908.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','41',1134,'14','1',3293742.10,3296108.81,2366.71,390507.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','41',1135,'15','1',3922256.02,3926043.30,3787.28,624901.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','41',1136,'16','1',3239397.02,3242125.92,2728.90,450268.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','41',1137,'17','1',3612972.87,3616113.53,3140.66,518208.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','41',1138,'18','1',3271469.98,3273073.89,1603.91,264645.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','41',1139,'19','1',4029930.27,4032135.88,2205.61,363925.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','41',1140,'20','2',1962130.35,1968735.42,6605.07,4623549.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','41',1141,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','41',1142,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','41',1143,'23','2',776614.34,780785.67,4171.33,2919931.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','41',1144,'24','3',361762.64,362586.06,823.42,452882.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','41',1145,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','41',1146,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','41',1147,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','41',1148,'28','1',3709593.48,3712770.07,3176.59,524137.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','42',1149,'1','1',4537997.73,4542553.73,4556.00,751740.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','42',1150,'2','1',5089786.23,5093432.09,3645.86,601566.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','42',1151,'3','1',4251841.22,4254631.79,2790.57,460444.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','42',1152,'4','1',5543114.25,5546229.66,3115.41,514042.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','42',1153,'5','1',3659514.46,3664711.65,5197.19,857536.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','42',1154,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','42',1155,'7','1',2244194.19,2247115.90,2921.71,482082.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','42',1156,'8','1',3193276.53,3196027.87,2751.34,453971.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','42',1157,'9','1',5156447.88,5159081.79,2633.91,434595.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','42',1158,'10','1',3237663.25,3242899.98,5236.73,864060.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','42',1159,'11','1',4376911.98,4380743.50,3831.52,632200.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','42',1160,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','42',1161,'13','1',4293292.65,4296021.70,2729.05,450293.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','42',1162,'14','1',3296108.81,3299465.56,3356.75,553863.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','42',1163,'15','1',3926043.30,3928945.89,2902.59,478927.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','42',1164,'16','1',3242125.92,3244479.47,2353.55,388335.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','42',1165,'17','1',3616113.53,3619300.11,3186.58,525785.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','42',1166,'18','1',3273073.89,3276447.98,3374.09,556724.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','42',1167,'19','1',4032135.88,4035717.74,3581.86,591006.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','42',1168,'20','2',1968735.42,1972337.17,3601.75,2521225.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','42',1169,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','42',1170,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','42',1171,'23','2',780785.67,784015.59,3229.92,2260944.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','42',1172,'24','3',362586.06,363532.76,946.70,520685.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','42',1173,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','42',1174,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','42',1175,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','42',1176,'28','1',3712770.07,3715443.19,2673.12,441064.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','43',1177,'1','1',4542553.73,4548449.34,5855.61,966175.65,0.00,0.00,40.00,0.00,0.00),('21','221','1','43',1178,'2','1',5093432.09,5098874.26,5442.17,897958.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','43',1179,'3','1',4254631.79,4259715.07,5083.28,838741.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','43',1180,'4','1',5546229.66,5551910.59,5680.93,937353.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','43',1181,'5','1',3664711.65,3671378.77,6667.12,1100074.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','43',1182,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','43',1183,'7','1',2247115.90,2250124.40,3008.50,496402.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','43',1184,'8','1',3196027.87,3200132.07,4104.20,677193.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','43',1185,'9','1',5159081.79,5164277.14,5195.35,857232.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','43',1186,'10','1',3242899.98,3249969.92,7069.94,1166540.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','43',1187,'11','1',4380743.50,4384838.81,4095.31,675726.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','43',1188,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','43',1189,'13','1',4296021.70,4299545.03,3523.33,581349.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','43',1190,'14','1',3299465.56,3303133.99,3668.43,605290.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','43',1191,'15','1',3928945.89,3932577.95,3632.06,599289.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','43',1192,'16','1',3244479.47,3247840.25,3360.78,554528.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','43',1193,'17','1',3619300.11,3622955.40,3655.29,603122.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','43',1194,'18','1',3276447.98,3281161.55,4713.57,777739.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','43',1195,'19','1',4035717.74,4039969.95,4252.21,701614.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','43',1196,'20','2',1972337.17,1976907.84,4570.67,3199469.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','43',1197,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','43',1198,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','43',1199,'23','2',784015.59,789691.88,5676.29,3973403.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','43',1200,'24','3',363532.76,364692.92,1160.16,638085.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','43',1201,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','43',1202,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','43',1203,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','43',1204,'28','1',3715443.19,3718177.74,2734.55,451200.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','44',1205,'1','1',4548449.34,4551484.38,2995.04,494181.60,0.00,0.00,40.00,0.00,0.00),('21','221','1','44',1206,'2','1',5098874.26,5100590.00,1715.74,283097.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','44',1207,'3','1',4259715.07,4264970.07,5255.00,867075.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','44',1208,'4','1',5551910.59,5555567.64,3657.05,603413.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','44',1209,'5','1',3671378.77,3676416.16,5037.39,831169.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','44',1210,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','44',1211,'7','1',2250124.40,2252882.37,2757.97,455065.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','44',1212,'8','1',3200132.07,3203894.97,3762.90,620878.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','44',1213,'9','1',5164277.14,5167876.03,3598.89,593816.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','44',1214,'10','1',3249969.92,3255796.49,5826.57,961384.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','44',1215,'11','1',4384838.81,4387152.26,2313.45,381719.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','44',1216,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','44',1217,'13','1',4299545.03,4302122.90,2577.87,425348.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','44',1218,'14','1',3303133.99,3306413.68,3279.69,541148.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','44',1219,'15','1',3932577.95,3934849.68,2271.73,374835.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','44',1220,'16','1',3247840.25,3250613.66,2773.41,457612.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','44',1221,'17','1',3622955.40,3625624.19,2668.79,440350.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','44',1222,'18','1',3281161.55,3283982.93,2821.38,465527.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','44',1223,'19','1',4039969.95,4042883.98,2914.03,480814.95,0.00,0.00,0.00,0.00,0.00),('21','221','4','44',1224,'20','2',1976907.84,1978071.85,1164.01,814807.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','44',1225,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','44',1226,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','44',1227,'23','2',789691.88,795126.22,5434.34,3804038.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','44',1228,'24','3',364692.92,365808.00,1115.08,613294.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','44',1229,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','44',1230,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','44',1231,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','44',1232,'28','1',3718177.74,3721544.91,3367.17,555583.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','45',1233,'1','1',4551484.38,4555369.02,3884.64,640965.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','45',1234,'2','1',5100590.00,5104075.69,3485.69,575138.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','45',1235,'3','1',4264970.07,4268611.39,3641.32,600817.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','45',1236,'4','1',5555567.64,5559686.49,4118.85,679610.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','45',1237,'5','1',3676416.16,3682442.84,6026.68,994402.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','45',1238,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','45',1239,'7','1',2252882.37,2255522.39,2640.02,435603.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','45',1240,'8','1',3203894.97,3205864.87,1969.90,325033.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','45',1241,'9','1',5167876.03,5171725.51,3849.48,635164.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','45',1242,'10','1',3255796.49,3260615.49,4819.00,795135.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','45',1243,'11','1',4387152.26,4391024.70,3872.44,638952.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','45',1244,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','45',1245,'13','1',4302122.90,4305072.50,2949.60,486684.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','45',1246,'14','1',3306413.68,3308429.86,2016.18,332669.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','45',1247,'15','1',3934849.68,3937721.97,2872.29,473927.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','45',1248,'16','1',3250613.66,3252985.79,2372.13,391401.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','45',1249,'17','1',3625624.19,3628622.06,2957.87,488048.55,0.00,0.00,40.00,0.00,0.00),('21','221','3','45',1250,'18','1',3283982.93,3286495.15,2512.22,414516.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','45',1251,'19','1',4042883.98,4046187.70,3303.72,545113.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','45',1252,'20','2',1978071.85,1982205.41,4133.56,2893492.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','45',1253,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','45',1254,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','45',1255,'23','2',795126.22,798170.78,3044.56,2131192.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','45',1256,'24','3',365808.00,370758.11,4950.11,2722561.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','45',1257,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','45',1258,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','45',1259,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','45',1260,'28','1',3721544.91,3724114.09,2569.18,423914.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','46',1261,'1','1',4555369.02,4556786.08,1377.06,227214.90,0.00,0.00,40.00,0.00,0.00),('21','221','1','46',1262,'2','1',5104075.69,5105523.18,1447.49,238835.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','46',1263,'3','1',4268611.39,4272409.29,3797.90,626653.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','46',1264,'4','1',5559686.49,5565085.29,5398.80,890802.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','46',1265,'5','1',3682442.84,3687303.75,4860.91,802050.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','46',1266,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','46',1267,'7','1',2255522.39,2257431.66,1909.27,315029.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','46',1268,'8','1',3205864.87,3209980.86,4115.99,679138.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','46',1269,'9','1',5171725.51,5175904.14,4178.63,689473.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','46',1270,'10','1',3260615.49,3266207.96,5592.47,922757.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','46',1271,'11','1',4391024.70,4393901.32,2876.62,474642.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','46',1272,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','46',1273,'13','1',4305072.50,4307225.69,2153.19,355276.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','46',1274,'14','1',3308429.86,3309511.92,1082.06,178539.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','46',1275,'15','1',3937721.97,3940607.61,2885.64,476130.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','46',1276,'16','1',3252985.79,3254856.08,1870.29,308597.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','46',1277,'17','1',3628622.06,3631581.16,2959.10,488251.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','46',1278,'18','1',3286495.15,3289766.01,3270.86,539691.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','46',1279,'19','1',4046187.70,4050109.81,3922.11,647148.15,0.00,0.00,0.00,0.00,0.00),('21','221','4','46',1280,'20','2',1982205.41,1987774.23,5568.82,3898174.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','46',1281,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','46',1282,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','46',1283,'23','2',798170.78,800936.57,2765.79,1936053.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','46',1284,'24','3',370758.11,376148.82,5390.71,2964889.95,0.00,0.00,0.00,0.00,0.00),('21','221','5','46',1285,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','46',1286,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','46',1287,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','46',1288,'28','1',3724114.09,3726276.52,2162.43,356800.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','47',1289,'1','1',4556786.08,4561185.30,4399.22,725871.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','47',1290,'2','1',5105523.18,5110258.90,4735.72,781393.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','47',1291,'3','1',4272409.29,4275143.91,2734.62,451212.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','47',1292,'4','1',5565085.29,5570893.75,5808.46,958395.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','47',1293,'5','1',3687303.75,3693027.28,5672.53,935967.45,0.00,0.00,51.00,0.00,0.00),('21','221','2','47',1294,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','47',1295,'7','1',2257431.66,2261218.83,3787.17,624883.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','47',1296,'8','1',3209980.86,3213984.05,4003.19,660526.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','47',1297,'9','1',5175904.14,5180034.22,4130.08,681463.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','47',1298,'10','1',3266207.96,3271822.46,5614.50,926392.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','47',1299,'11','1',4393901.32,4398290.52,4389.20,724218.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','47',1300,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','47',1301,'13','1',4307225.69,4307697.20,471.51,77799.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','47',1302,'14','1',3309511.92,3309511.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','47',1303,'15','1',3940607.61,3941504.02,896.41,147907.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','47',1304,'16','1',3254856.08,3255457.87,601.79,99295.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','47',1305,'17','1',3631581.16,3631581.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','47',1306,'18','1',3289766.01,3290267.04,501.03,82669.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','47',1307,'19','1',4050109.81,4050315.48,205.67,33935.55,0.00,0.00,0.00,0.00,0.00),('21','221','4','47',1308,'20','2',1987774.23,1991937.77,4163.54,2914478.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','47',1309,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','47',1310,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','47',1311,'23','2',800936.57,802824.25,1887.68,1321376.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','47',1312,'24','3',376148.82,377059.81,910.99,501046.15,0.00,0.00,0.00,0.00,0.00),('21','221','5','47',1313,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','47',1314,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','47',1315,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','47',1316,'28','1',3726276.52,3726895.07,618.55,102060.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','48',1317,'1','1',4561185.30,4564008.34,2823.04,465801.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','48',1318,'2','1',5110258.90,5112971.12,2712.22,447516.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','48',1319,'3','1',4275143.91,4278930.50,3786.59,624787.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','48',1320,'4','1',5570893.75,5572109.41,1215.66,200583.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','48',1321,'5','1',3693027.28,3696266.41,3239.13,534456.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','48',1322,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','48',1323,'7','1',2261218.83,2262988.26,1769.43,291955.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','48',1324,'8','1',3213984.05,3215512.18,1528.13,252141.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','48',1325,'9','1',5180034.22,5182842.42,2808.20,463353.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','48',1326,'10','1',3271822.46,3275230.92,3408.46,562395.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','48',1327,'11','1',4398290.52,4400596.37,2305.85,380465.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','48',1328,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','48',1329,'13','1',4307697.20,4309926.50,2229.30,367834.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','48',1330,'14','1',3309511.92,3309511.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','48',1331,'15','1',3941504.02,3944741.89,3197.87,527648.55,0.00,0.00,40.00,0.00,0.00),('21','221','3','48',1332,'16','1',3255457.87,3257463.88,2006.01,330991.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','48',1333,'17','1',3631581.16,3633526.28,1945.12,320944.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','48',1334,'18','1',3290267.04,3292496.58,2229.54,367874.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','48',1335,'19','1',4050315.48,4052190.55,1875.07,309386.55,0.00,0.00,0.00,0.00,0.00),('21','221','4','48',1336,'20','2',1991937.77,1997586.72,5648.95,3954265.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','48',1337,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','48',1338,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','48',1339,'23','2',802824.25,806033.64,3209.39,2246573.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','48',1340,'24','3',377059.81,379210.42,2150.61,1182834.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','48',1341,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','48',1342,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','48',1343,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','48',1344,'28','1',3726895.07,3727787.74,892.67,147290.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','49',1345,'1','1',4564008.34,4564008.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','49',1346,'2','1',5112971.12,5112971.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','49',1347,'3','1',4278930.50,4278930.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','49',1348,'4','1',5572109.41,5572109.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','49',1349,'5','1',3696266.41,3696266.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','49',1350,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','49',1351,'7','1',2262988.26,2262988.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','49',1352,'8','1',3215512.18,3215512.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','49',1353,'9','1',5182842.42,5182842.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','49',1354,'10','1',3275230.92,3275230.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','49',1355,'11','1',4400596.37,4400596.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','49',1356,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','49',1357,'13','1',4309926.50,4309926.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','49',1358,'14','1',3309511.92,3309511.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','49',1359,'15','1',3944741.89,3944741.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','49',1360,'16','1',3257463.88,3257463.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','49',1361,'17','1',3633526.28,3633526.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','49',1362,'18','1',3292496.58,3292496.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','49',1363,'19','1',4052190.55,4052190.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','49',1364,'20','2',1997586.72,1997586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','49',1365,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','49',1366,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','49',1367,'23','2',806033.64,806033.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','49',1368,'24','3',379210.42,379210.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','49',1369,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','49',1370,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','49',1371,'27','3',421.23,421.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','49',1372,'28','1',3727787.74,3727787.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','50',1373,'1','1',4564008.34,4564008.34,-40.00,-6600.00,0.00,0.00,40.00,0.00,0.00),('21','221','1','50',1374,'2','1',5112971.12,5112971.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','50',1375,'3','1',4278930.50,4278930.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','50',1376,'4','1',5572109.41,5572109.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','50',1377,'5','1',3696266.41,3699544.31,3277.90,540853.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','50',1378,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','50',1379,'7','1',2262988.26,2264736.58,1748.32,288472.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','50',1380,'8','1',3215512.18,3216958.01,1445.83,238561.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','50',1381,'9','1',5182842.42,5184831.52,1989.10,328201.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','50',1382,'10','1',3275230.92,3278480.77,3249.85,536225.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','50',1383,'11','1',4400596.37,4403159.64,2563.27,422939.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','50',1384,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','50',1385,'13','1',4309926.50,4312502.95,2576.45,425114.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','50',1386,'14','1',3309511.92,3310850.69,1338.77,220897.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','50',1387,'15','1',3944741.89,3946800.84,2058.95,339726.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','50',1388,'16','1',3257463.88,3259354.79,1890.91,312000.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','50',1389,'17','1',3633526.28,3635635.26,2108.98,347981.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','50',1390,'18','1',3292496.58,3294513.53,2016.95,332796.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','50',1391,'19','1',4052190.55,4053784.79,1594.24,263049.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','50',1392,'20','2',1997586.72,1998223.13,636.41,445487.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','50',1393,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','50',1394,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','50',1395,'23','2',806033.64,812302.02,6268.38,4387866.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','50',1396,'24','3',379210.42,395732.22,16521.80,9086991.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','50',1397,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','50',1398,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','50',1399,'27','3',421.23,1876.09,1454.86,800173.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','50',1400,'28','1',3727787.74,3729797.77,2010.03,331654.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','51',1401,'1','1',4564008.34,4568036.06,3987.72,657973.80,0.00,0.00,40.00,0.00,0.00),('21','221','1','51',1402,'2','1',5112971.12,5116093.45,3122.33,515184.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','51',1403,'3','1',4278930.50,4282874.45,3943.95,650751.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','51',1404,'4','1',5572109.41,5576201.89,4092.48,675259.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','51',1405,'5','1',3699544.31,3705273.95,5729.64,945390.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','51',1406,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','51',1407,'7','1',2264736.58,2266394.67,1658.09,273584.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','51',1408,'8','1',3216958.01,3221295.08,4337.07,715616.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','51',1409,'9','1',5184831.52,5189875.95,5044.43,832330.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','51',1410,'10','1',3278480.77,3284692.95,6212.18,1025009.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','51',1411,'11','1',4403159.64,4405542.22,2382.58,393125.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','51',1412,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','51',1413,'13','1',4312502.95,4316138.94,3635.99,599938.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','51',1414,'14','1',3310850.69,3312325.48,1474.79,243340.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','51',1415,'15','1',3946800.84,3949172.10,2371.26,391257.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','51',1416,'16','1',3259354.79,3261962.12,2607.33,430209.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','51',1417,'17','1',3635635.26,3638188.64,2553.38,421307.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','51',1418,'18','1',3294513.53,3295155.77,642.24,105969.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','51',1419,'19','1',4053784.79,4055126.14,1341.35,221322.75,0.00,0.00,0.00,0.00,0.00),('21','221','4','51',1420,'20','2',1998223.13,1999143.57,920.44,644308.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','51',1421,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','51',1422,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','51',1423,'23','2',812302.02,816122.26,3820.24,2674168.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','51',1424,'24','3',395732.22,396868.99,1136.77,625224.05,0.00,0.00,0.00,0.00,0.00),('21','221','5','51',1425,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','51',1426,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','51',1427,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','51',1428,'28','1',3729797.77,3732380.15,2582.38,426092.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','52',1429,'1','1',4568036.06,4570341.25,2265.19,373756.35,0.00,0.00,40.00,0.00,0.00),('21','221','1','52',1430,'2','1',5116093.45,5122134.25,6040.80,996732.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','52',1431,'3','1',4282874.45,4287232.95,4358.50,719152.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','52',1432,'4','1',5576201.89,5580811.60,4609.71,760602.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','52',1433,'5','1',3705273.95,3711723.42,6449.47,1064162.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','52',1434,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','52',1435,'7','1',2266394.67,2270045.94,3651.27,602459.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','52',1436,'8','1',3221295.08,3227418.24,6123.16,1010321.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','52',1437,'9','1',5189875.95,5194164.47,4288.52,707605.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','52',1438,'10','1',3284692.95,3291763.91,7070.96,1166708.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','52',1439,'11','1',4405542.22,4407911.92,2369.70,391000.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','52',1440,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','52',1441,'13','1',4316138.94,4318758.21,2619.27,432179.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','52',1442,'14','1',3312325.48,3315853.15,3527.67,582065.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','52',1443,'15','1',3949172.10,3952989.81,3777.71,623322.15,0.00,0.00,40.00,0.00,0.00),('21','221','3','52',1444,'16','1',3261962.12,3266280.10,4317.98,712466.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','52',1445,'17','1',3638188.64,3641255.14,3066.50,505972.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','52',1446,'18','1',3295155.77,3298226.54,3070.77,506677.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','52',1447,'19','1',4055126.14,4060762.87,5636.73,930060.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','52',1448,'20','2',1999143.57,2004333.49,5189.92,3632944.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','52',1449,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','52',1450,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','52',1451,'23','2',816122.26,821542.82,5420.56,3794392.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','52',1452,'24','3',396868.99,397741.96,872.97,480135.15,0.00,0.00,0.00,0.00,0.00),('21','221','5','52',1453,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','52',1454,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','52',1455,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','52',1456,'28','1',3732380.15,3735077.87,2697.72,445123.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','53',1457,'1','1',4570341.25,4578470.35,8129.10,1341301.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','53',1458,'2','1',5122134.25,5122521.07,386.82,63825.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','53',1459,'3','1',4287232.95,4291488.00,4255.05,702083.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','53',1460,'4','1',5580811.60,5585422.22,4610.62,760752.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','53',1461,'5','1',3711723.42,3718679.41,6955.99,1147738.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','53',1462,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','53',1463,'7','1',2270045.94,2272827.26,2781.32,458917.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','53',1464,'8','1',3227418.24,3230428.83,3010.59,496747.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','53',1465,'9','1',5194164.47,5196738.93,2574.46,424785.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','53',1466,'10','1',3291763.91,3297955.65,6191.74,1021637.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','53',1467,'11','1',4407911.92,4412911.97,5000.05,825008.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','53',1468,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','53',1469,'13','1',4318758.21,4323297.40,4539.19,748966.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','53',1470,'14','1',3315853.15,3319595.64,3742.49,617510.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','53',1471,'15','1',3952989.81,3955856.21,2826.40,466356.00,0.00,0.00,40.00,0.00,0.00),('21','221','3','53',1472,'16','1',3266280.10,3268475.96,2195.86,362316.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','53',1473,'17','1',3641255.14,3645800.74,4545.60,750024.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','53',1474,'18','1',3298226.54,3300920.92,2694.38,444572.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','53',1475,'19','1',4060762.87,4064925.16,4162.29,686777.85,0.00,0.00,0.00,0.00,0.00),('21','221','4','53',1476,'20','2',2004333.49,2009043.80,4710.31,3297217.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','53',1477,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','53',1478,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','53',1479,'23','2',821542.82,824900.22,3357.40,2350180.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','53',1480,'24','3',397741.96,397741.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','53',1481,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','53',1482,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','53',1483,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','53',1484,'28','1',3735077.87,3738107.98,3030.11,499968.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','54',1485,'1','1',4578470.35,4584249.99,5779.64,953640.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','54',1486,'2','1',5122521.07,5125210.34,2689.27,443729.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','54',1487,'3','1',4291488.00,4295713.84,4225.84,697263.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','54',1488,'4','1',5585422.22,5589857.97,4435.75,731898.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','54',1489,'5','1',3718679.41,3724726.25,6046.84,997728.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','54',1490,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','54',1491,'7','1',2272827.26,2275663.16,2835.90,467923.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','54',1492,'8','1',3230428.83,3233734.83,3306.00,545490.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','54',1493,'9','1',5196738.93,5199262.59,2523.66,416403.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','54',1494,'10','1',3297955.65,3304021.37,6065.72,1000843.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','54',1495,'11','1',4412911.97,4415799.40,2887.43,476425.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','54',1496,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','54',1497,'13','1',4323297.40,4326284.98,2947.58,486350.70,0.00,0.00,40.00,0.00,0.00),('21','221','3','54',1498,'14','1',3319595.64,3321540.86,1945.22,320961.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','54',1499,'15','1',3955856.21,3958683.55,2827.34,466511.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','54',1500,'16','1',3268475.96,3272286.29,3810.33,628704.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','54',1501,'17','1',3645800.74,3648627.17,2826.43,466360.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','54',1502,'18','1',3300920.92,3304421.35,3500.43,577570.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','54',1503,'19','1',4064925.16,4068285.64,3360.48,554479.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','54',1504,'20','2',2009043.80,2012406.03,3362.23,2353561.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','54',1505,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','54',1506,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','54',1507,'23','2',824900.22,828563.32,3663.10,2564170.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','54',1508,'24','3',397741.96,398416.35,674.39,438354.15,0.00,0.00,0.00,0.00,0.00),('21','221','5','54',1509,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','54',1510,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','54',1511,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','54',1512,'28','1',3738107.98,3741318.17,3210.19,529681.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','55',1513,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','55',1514,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','55',1515,'3','1',4295713.84,4295738.15,24.31,4011.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','55',1516,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','55',1517,'5','1',3724726.25,3730871.71,6145.46,1014000.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','55',1518,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','55',1519,'7','1',2275663.16,2278274.76,2611.60,430914.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','55',1520,'8','1',3233734.83,3235972.96,2238.13,369291.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','55',1521,'9','1',5199262.59,5202353.74,3091.15,510039.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','55',1522,'10','1',3304021.37,3310846.07,6824.70,1126075.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','55',1523,'11','1',4415799.40,4420021.44,4222.04,696636.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','55',1524,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','55',1525,'13','1',4326284.98,4329987.62,3702.64,610935.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','55',1526,'14','1',3321540.86,3324383.60,2842.74,469052.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','55',1527,'15','1',3958683.55,3961457.65,2774.10,457726.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','55',1528,'16','1',3272286.29,3275143.54,2857.25,471446.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','55',1529,'17','1',3648627.17,3651396.20,2769.03,456889.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','55',1530,'18','1',3304421.35,3308333.54,3912.19,645511.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','55',1531,'19','1',4068285.64,4070677.76,2392.12,394699.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','55',1532,'20','2',2012406.03,2016972.29,4566.26,3196382.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','55',1533,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','55',1534,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','55',1535,'23','2',828563.32,830210.95,1647.63,1153341.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','55',1536,'24','3',398416.35,399072.20,655.85,426301.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','55',1537,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','55',1538,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','55',1539,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','55',1540,'28','1',3741318.17,3745149.19,3791.02,625518.30,0.00,0.00,40.00,0.00,0.00),('21','221','1','56',1541,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','56',1542,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','56',1543,'3','1',4295738.15,4295738.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','56',1544,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','56',1545,'5','1',3730871.71,3730871.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','56',1546,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','56',1547,'7','1',2278274.76,2278274.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','56',1548,'8','1',3235972.96,3235972.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','56',1549,'9','1',5202353.74,5202353.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','56',1550,'10','1',3310846.07,3310846.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','56',1551,'11','1',4420021.44,4420021.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','56',1552,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','56',1553,'13','1',4329987.62,4329987.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','56',1554,'14','1',3324383.60,3324383.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','56',1555,'15','1',3961457.65,3961457.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','56',1556,'16','1',3275143.54,3275143.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','56',1557,'17','1',3651396.20,3651396.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','56',1558,'18','1',3308333.54,3308333.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','56',1559,'19','1',4070677.76,4070677.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','56',1560,'20','2',2016972.29,2016972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','56',1561,'21','2',50542.60,50542.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','56',1562,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','56',1563,'23','2',830210.95,830210.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','56',1564,'24','3',399072.20,399072.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','56',1565,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','56',1566,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','56',1567,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','56',1568,'28','1',3745149.19,3745149.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','57',1569,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','57',1570,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','57',1571,'3','1',4295738.15,4295738.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','57',1572,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','57',1573,'5','1',3730871.71,3735830.68,4958.97,818230.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','57',1574,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','57',1575,'7','1',2278274.76,2280652.90,2378.14,392393.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','57',1576,'8','1',3235972.96,3237639.85,1666.89,275036.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','57',1577,'9','1',5202353.74,5205798.95,3445.21,568459.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','57',1578,'10','1',3310846.07,3316547.28,5701.21,940699.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','57',1579,'11','1',4420021.44,4423280.68,3259.24,537774.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','57',1580,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','57',1581,'13','1',4329987.62,4335303.87,5316.25,877181.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','57',1582,'14','1',3324383.60,3330322.76,5939.16,979961.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','57',1583,'15','1',3961457.65,3964068.44,2610.79,430780.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','57',1584,'16','1',3275143.54,3280389.54,5206.00,858990.00,0.00,0.00,40.00,0.00,0.00),('21','221','3','57',1585,'17','1',3651396.20,3657713.87,6317.67,1042415.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','57',1586,'18','1',3308333.54,3315877.24,7543.70,1244710.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','57',1587,'19','1',4070677.76,4077193.17,6515.41,1075042.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','57',1588,'20','2',2016972.29,2023066.20,6093.91,4265737.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','57',1589,'21','2',50542.60,50593.31,50.71,35497.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','57',1590,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','57',1591,'23','2',830210.95,835962.17,5751.22,4025854.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','57',1592,'24','3',399072.20,400047.41,975.21,633885.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','57',1593,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','57',1594,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','57',1595,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','57',1596,'28','1',3745149.19,3752177.17,7027.98,1159616.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','58',1597,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','58',1598,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','58',1599,'3','1',4295738.15,4295744.53,6.38,1052.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','58',1600,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','58',1601,'5','1',3735830.68,3745535.66,9704.98,1601321.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','58',1602,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','58',1603,'7','1',2280652.90,2284913.59,4260.69,703013.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','58',1604,'8','1',3237639.85,3243264.75,5624.90,928108.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','58',1605,'9','1',5205798.95,5212729.62,6930.67,1143560.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','58',1606,'10','1',3316547.28,3326981.57,10434.29,1721657.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','58',1607,'11','1',4423280.68,4429757.72,6477.04,1068711.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','58',1608,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','58',1609,'13','1',4335303.87,4340600.08,5296.21,873874.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','58',1610,'14','1',3330322.76,3334398.33,4075.57,672469.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','58',1611,'15','1',3964068.44,3970039.82,5971.38,985277.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','58',1612,'16','1',3280389.54,3284785.65,4396.11,725358.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','58',1613,'17','1',3657713.87,3662994.39,5280.52,871285.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','58',1614,'18','1',3315877.24,3322506.91,6629.67,1093895.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','58',1615,'19','1',4077193.17,4084493.21,7300.04,1204506.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','58',1616,'20','2',2023066.20,2028342.83,5276.63,3693641.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','58',1617,'21','2',50593.31,50593.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','58',1618,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','58',1619,'23','2',835962.17,843925.69,7963.52,5574464.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','58',1620,'24','3',400047.41,401221.65,1174.24,763257.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','58',1621,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','58',1622,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','58',1623,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','58',1624,'28','1',3752177.17,3758491.98,6274.81,1035343.65,0.00,0.00,40.00,0.00,0.00),('21','221','1','59',1625,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','59',1626,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','59',1627,'3','1',4295744.53,4295744.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','59',1628,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','59',1629,'5','1',3745535.66,3751165.16,5629.50,928867.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','59',1630,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','59',1631,'7','1',2284913.59,2288925.12,4011.53,661902.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','59',1632,'8','1',3243264.75,3247696.14,4431.39,731179.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','59',1633,'9','1',5212729.62,5216718.32,3988.70,658135.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','59',1634,'10','1',3326981.57,3334863.36,7881.79,1300495.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','59',1635,'11','1',4429757.72,4434833.70,5075.98,837536.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','59',1636,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','59',1637,'13','1',4340600.08,4345248.57,4648.49,767000.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','59',1638,'14','1',3334398.33,3336220.40,1782.07,294041.55,0.00,0.00,40.00,0.00,0.00),('21','221','3','59',1639,'15','1',3970039.82,3975052.76,5012.94,827135.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','59',1640,'16','1',3284785.65,3287726.95,2941.30,485314.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','59',1641,'17','1',3662994.39,3666642.19,3647.80,601887.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','59',1642,'18','1',3322506.91,3329785.10,7278.19,1200901.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','59',1643,'19','1',4084493.21,4088886.40,4393.19,724876.35,0.00,0.00,0.00,0.00,0.00),('21','221','4','59',1644,'20','2',2028342.83,2030298.33,1955.50,1368850.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','59',1645,'21','2',50593.31,50593.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','59',1646,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','59',1647,'23','2',843925.69,846330.45,2404.76,1683332.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','59',1648,'24','3',401221.65,402445.96,1224.31,795804.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','59',1649,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','59',1650,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','59',1651,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','59',1652,'28','1',3758491.98,3763307.61,4815.63,794578.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','60',1653,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','60',1654,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','60',1655,'3','1',4295744.53,4295744.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','60',1656,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','60',1657,'5','1',3751165.16,3751165.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','60',1658,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','60',1659,'7','1',2288925.12,2288925.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','60',1660,'8','1',3247696.14,3247696.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','60',1661,'9','1',5216718.32,5216718.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','60',1662,'10','1',3334863.36,3334863.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','60',1663,'11','1',4434833.70,4434833.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','60',1664,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','60',1665,'13','1',4345248.57,4345248.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','60',1666,'14','1',3336220.40,3336220.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','60',1667,'15','1',3975052.76,3975052.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','60',1668,'16','1',3287726.95,3287726.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','60',1669,'17','1',3666642.19,3666642.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','60',1670,'18','1',3329785.10,3329785.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','60',1671,'19','1',4088886.40,4088886.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','60',1672,'20','2',2030298.33,2030298.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','60',1673,'21','2',50593.31,50593.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','60',1674,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','60',1675,'23','2',846330.45,846330.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','60',1676,'24','3',402445.96,402445.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','60',1677,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','60',1678,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','60',1679,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','60',1680,'28','1',3763307.61,3763307.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','61',1681,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','61',1682,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','61',1683,'3','1',4295744.53,4295744.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','61',1684,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','61',1685,'5','1',3751165.16,3755486.64,4321.48,713044.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','61',1686,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','61',1687,'7','1',2288925.12,2290533.51,1608.39,265384.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','61',1688,'8','1',3247696.14,3250854.88,3158.74,521192.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','61',1689,'9','1',5216718.32,5219996.97,3278.65,540977.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','61',1690,'10','1',3334863.36,3344060.27,9196.91,1517490.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','61',1691,'11','1',4434833.70,4438574.05,3740.35,617157.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','61',1692,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','61',1693,'13','1',4345248.57,4348374.24,3125.67,515735.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','61',1694,'14','1',3336220.40,3338091.20,1830.80,302082.00,0.00,0.00,40.00,0.00,0.00),('21','221','3','61',1695,'15','1',3975052.76,3977520.92,2468.16,407246.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','61',1696,'16','1',3287726.95,3289805.45,2078.50,342952.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','61',1697,'17','1',3666642.19,3669464.87,2822.68,465742.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','61',1698,'18','1',3329785.10,3332924.45,3139.35,517992.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','61',1699,'19','1',4088886.40,4090970.22,2083.82,343830.30,0.00,0.00,0.00,0.00,0.00),('21','221','4','61',1700,'20','2',2030298.33,2039939.51,9641.18,6748826.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','61',1701,'21','2',50593.31,50608.53,15.22,10654.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','61',1702,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','61',1703,'23','2',846330.45,850610.75,4280.30,2996210.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','61',1704,'24','3',402445.96,403757.63,1311.67,852588.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','61',1705,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','61',1706,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','61',1707,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','61',1708,'28','1',3763307.61,3766307.15,2999.54,494924.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','62',1709,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','62',1710,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','62',1711,'3','1',4295744.53,4295744.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','62',1712,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','62',1713,'5','1',3755486.64,3762600.74,7074.10,1167226.50,0.00,0.00,40.00,0.00,0.00),('21','221','2','62',1714,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','62',1715,'7','1',2290533.51,2294808.68,4275.17,705403.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','62',1716,'8','1',3250854.88,3257439.05,6584.17,1086388.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','62',1717,'9','1',5219996.97,5225538.38,5541.41,914332.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','62',1718,'10','1',3344060.27,3355361.48,11301.21,1864699.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','62',1719,'11','1',4438574.05,4443284.16,4710.11,777168.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','62',1720,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','62',1721,'13','1',4348374.24,4353356.91,4982.67,822140.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','62',1722,'14','1',3338091.20,3343208.04,5116.84,844278.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','62',1723,'15','1',3977520.92,3982891.77,5370.85,886190.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','62',1724,'16','1',3289805.45,3295620.56,5815.11,959493.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','62',1725,'17','1',3669464.87,3673544.32,4079.45,673109.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','62',1726,'18','1',3332924.45,3340090.61,7166.16,1182416.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','62',1727,'19','1',4090970.22,4097057.63,6087.41,1004422.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','62',1728,'20','2',2039939.51,2046997.46,7057.95,4940565.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','62',1729,'21','2',50608.53,50608.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','62',1730,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','62',1731,'23','2',850610.75,859313.30,8702.55,6091785.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','62',1732,'24','3',403757.63,404628.76,871.13,566231.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','62',1733,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','62',1734,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','62',1735,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','62',1736,'28','1',3766307.15,3773790.32,7483.17,1234723.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','63',1737,'1','1',4584249.99,4584249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','63',1738,'2','1',5125210.34,5125210.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','63',1739,'3','1',4295744.53,4295744.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','63',1740,'4','1',5589857.97,5589857.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','63',1741,'5','1',3762600.74,3769503.67,6902.93,1138983.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','63',1742,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','63',1743,'7','1',2294808.68,2298466.36,3657.68,603517.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','63',1744,'8','1',3257439.05,3262663.38,5224.33,862014.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','63',1745,'9','1',5225538.38,5229287.11,3708.73,611940.45,0.00,0.00,40.00,0.00,0.00),('21','221','2','63',1746,'10','1',3355361.48,3367050.07,11688.59,1928617.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','63',1747,'11','1',4443284.16,4445005.53,1721.37,284026.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','63',1748,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','63',1749,'13','1',4353356.91,4358310.82,4953.91,817395.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','63',1750,'14','1',3343208.04,3346569.24,3361.20,554598.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','63',1751,'15','1',3982891.77,3987548.10,4656.33,768294.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','63',1752,'16','1',3295620.56,3298945.56,3325.00,548625.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','63',1753,'17','1',3673544.32,3677795.61,4251.29,701462.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','63',1754,'18','1',3340090.61,3345367.69,5277.08,870718.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','63',1755,'19','1',4097057.63,4101320.27,4262.64,703335.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','63',1756,'20','2',2046997.46,2053763.95,6766.49,4871872.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','63',1757,'21','2',50608.53,50608.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','63',1758,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','63',1759,'23','2',859313.30,871234.05,11920.75,8582940.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','63',1760,'24','3',404628.76,408255.71,3626.95,2357519.45,0.00,0.00,0.00,0.00,0.00),('21','221','5','63',1761,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','63',1762,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','63',1763,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','63',1764,'28','1',3773790.32,3779883.18,6092.86,1005321.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','64',1765,'1','1',4584249.99,4590443.38,6153.39,1015309.35,0.00,0.00,40.00,0.00,0.00),('21','221','1','64',1766,'2','1',5125210.34,5130292.54,5082.20,838563.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','64',1767,'3','1',4295744.53,4299616.06,3871.53,638802.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','64',1768,'4','1',5589857.97,5595690.49,5832.52,962365.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','64',1769,'5','1',3769503.67,3777030.37,7526.70,1241905.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','64',1770,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','64',1771,'7','1',2298466.36,2303564.94,5098.58,841265.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','64',1772,'8','1',3262663.38,3267192.30,4528.92,747271.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','64',1773,'9','1',5229287.11,5235842.13,6555.02,1081578.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','64',1774,'10','1',3367050.07,3377878.29,10828.22,1786656.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','64',1775,'11','1',4445005.53,4451136.50,6130.97,1011610.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','64',1776,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','64',1777,'13','1',4358310.82,4362804.86,4494.04,741516.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','64',1778,'14','1',3346569.24,3351263.49,4694.25,774551.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','64',1779,'15','1',3987548.10,3993951.47,6403.37,1056556.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','64',1780,'16','1',3298945.56,3302774.82,3829.26,631827.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','64',1781,'17','1',3677795.61,3684155.88,6360.27,1049444.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','64',1782,'18','1',3345367.69,3350315.36,4947.67,816365.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','64',1783,'19','1',4101320.27,4107276.14,5955.87,982718.55,0.00,0.00,0.00,0.00,0.00),('21','221','4','64',1784,'20','2',2053763.95,2066499.06,12735.11,9169279.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','64',1785,'21','2',50608.53,50608.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','64',1786,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','64',1787,'23','2',871234.05,874500.88,3266.83,2352117.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','64',1788,'24','3',408255.71,408409.15,153.44,99737.95,0.00,0.00,0.00,0.00,0.00),('21','221','5','64',1789,'25','3',249.99,249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','64',1790,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','64',1791,'27','3',1876.09,1876.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','64',1792,'28','1',3779883.18,3789042.78,9159.60,1511334.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','65',1793,'1','1',4590443.38,4594876.48,4393.10,724861.50,0.00,0.00,40.00,0.00,0.00),('21','221','1','65',1794,'2','1',5130292.54,5133541.82,3249.28,536131.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','65',1795,'3','1',4299616.06,4302691.63,3075.57,507469.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','65',1796,'4','1',5595690.49,5600032.81,4342.32,716482.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','65',1797,'5','1',3777030.37,3784187.42,7157.05,1180913.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','65',1798,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','65',1799,'7','1',2303564.94,2307123.13,3558.19,587101.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','65',1800,'8','1',3267192.30,3273390.37,6198.07,1022681.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','65',1801,'9','1',5235842.13,5241843.66,6001.53,990252.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','65',1802,'10','1',3377878.29,3387348.95,9470.66,1562658.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','65',1803,'11','1',4451136.50,4454469.16,3332.66,549888.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','65',1804,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','65',1805,'13','1',4362804.86,4368560.41,5755.55,949665.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','65',1806,'14','1',3351263.49,3355784.30,4520.81,745933.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','65',1807,'15','1',3993951.47,3997866.17,3914.70,645925.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','65',1808,'16','1',3302774.82,3308403.86,5629.04,928791.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','65',1809,'17','1',3684155.88,3689319.77,5163.89,852041.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','65',1810,'18','1',3350315.36,3354146.01,3830.65,632057.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','65',1811,'19','1',4107276.14,4113068.44,5792.30,955729.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','65',1812,'20','2',2066499.06,2076115.39,9616.33,6923757.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','65',1813,'21','2',50608.53,51343.24,734.71,528991.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','65',1814,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','65',1815,'23','2',874500.88,882741.72,8240.84,5933404.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','65',1816,'24','3',408409.15,408689.52,280.37,182243.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','65',1817,'25','3',249.99,269.46,19.47,12658.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','65',1818,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','65',1819,'27','3',1876.09,2125.50,249.41,162116.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','65',1820,'28','1',3789042.78,3793666.44,4623.66,762903.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','66',1821,'1','1',4594876.48,4600128.52,5212.04,859986.60,0.00,0.00,40.00,0.00,0.00),('21','221','1','66',1822,'2','1',5133541.82,5138452.61,4910.79,810280.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','66',1823,'3','1',4302691.63,4307607.69,4916.06,811149.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','66',1824,'4','1',5600032.81,5604986.71,4953.90,817393.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','66',1825,'5','1',3784187.42,3792705.89,8518.47,1405547.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','66',1826,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','66',1827,'7','1',2307123.13,2311339.27,4216.14,695663.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','66',1828,'8','1',3273390.37,3277384.44,3994.07,659021.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','66',1829,'9','1',5241843.66,5246447.89,4604.23,759697.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','66',1830,'10','1',3387348.95,3395764.56,8415.61,1388575.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','66',1831,'11','1',4454469.16,4460456.92,5987.76,987980.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','66',1832,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','66',1833,'13','1',4368560.41,4372103.67,3543.26,584637.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','66',1834,'14','1',3355784.30,3359855.73,4071.43,671785.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','66',1835,'15','1',3997866.17,4001866.82,4000.65,660107.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','66',1836,'16','1',3308403.86,3312525.36,4121.50,680047.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','66',1837,'17','1',3689319.77,3692962.32,3642.55,601020.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','66',1838,'18','1',3354146.01,3357824.01,3678.00,606870.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','66',1839,'19','1',4113068.44,4116459.94,3391.50,559597.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','66',1840,'20','2',2076115.39,2084784.82,8669.43,6241989.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','66',1841,'21','2',51343.24,53737.24,2394.00,1723680.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','66',1842,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','66',1843,'23','2',882741.72,887925.77,5184.05,3732516.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','66',1844,'24','3',408689.52,408689.52,0.00,2.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','66',1845,'25','3',269.46,1419.42,1129.96,734475.95,0.00,0.00,20.00,0.00,0.00),('21','221','5','66',1846,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','66',1847,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','66',1848,'28','1',3793666.44,3797596.86,3930.42,648519.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','67',1849,'1','1',4600128.52,4603977.73,3849.21,635119.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','67',1850,'2','1',5138452.61,5143142.70,4690.09,773864.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','67',1851,'3','1',4307607.69,4310403.18,2795.49,461255.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','67',1852,'4','1',5604986.71,5610024.68,5037.97,831265.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','67',1853,'5','1',3792705.89,3798748.47,6042.58,997025.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','67',1854,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','67',1855,'7','1',2311339.27,2314602.68,3263.41,538462.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','67',1856,'8','1',3277384.44,3280909.40,3524.96,581618.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','67',1857,'9','1',5246447.89,5249570.14,3082.25,508571.25,0.00,0.00,40.00,0.00,0.00),('21','221','2','67',1858,'10','1',3395764.56,3401049.99,5285.43,872095.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','67',1859,'11','1',4460456.92,4463876.95,3420.03,564304.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','67',1860,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','67',1861,'13','1',4372103.67,4375834.34,3730.67,615560.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','67',1862,'14','1',3359855.73,3363305.19,3449.46,569160.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','67',1863,'15','1',4001866.82,4005398.30,3531.48,582694.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','67',1864,'16','1',3312525.36,3315213.52,2688.16,443546.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','67',1865,'17','1',3692962.32,3696906.73,3944.41,650827.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','67',1866,'18','1',3357824.01,3361554.08,3730.07,615461.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','67',1867,'19','1',4116459.94,4119748.28,3288.34,542576.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','67',1868,'20','2',2084784.82,2087072.45,2287.63,1647093.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','67',1869,'21','2',53737.24,53737.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','67',1870,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','67',1871,'23','2',887925.77,890215.48,2289.71,1648591.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','67',1872,'24','3',408689.52,408690.14,0.62,403.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','67',1873,'25','3',1419.42,2451.33,1031.91,670741.50,0.00,0.00,0.00,0.00,0.00),('21','221','5','67',1874,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','67',1875,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','67',1876,'28','1',3797596.86,3801866.44,4269.58,704480.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','68',1877,'1','1',4603977.73,4606328.22,2350.49,387830.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','68',1878,'2','1',5143142.70,5147346.72,4204.02,693663.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','68',1879,'3','1',4310403.18,4313480.13,3076.95,507696.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','68',1880,'4','1',5610024.68,5613009.07,2984.39,492424.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','68',1881,'5','1',3798748.47,3805084.02,6335.55,1045365.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','68',1882,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','68',1883,'7','1',2314602.68,2318264.85,3662.17,604258.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','68',1884,'8','1',3280909.40,3284187.12,3277.72,540823.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','68',1885,'9','1',5249570.14,5253107.59,3497.45,577079.25,0.00,0.00,40.00,0.00,0.00),('21','221','2','68',1886,'10','1',3401049.99,3406080.57,5030.58,830045.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','68',1887,'11','1',4463876.95,4468058.85,4181.90,690013.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','68',1888,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','68',1889,'13','1',4375834.34,4378986.03,3151.69,520028.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','68',1890,'14','1',3363305.19,3365680.15,2374.96,391868.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','68',1891,'15','1',4005398.30,4008403.61,3005.31,495876.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','68',1892,'16','1',3315213.52,3317724.33,2510.81,414283.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','68',1893,'17','1',3696906.73,3700067.59,3160.86,521541.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','68',1894,'18','1',3361554.08,3364191.96,2637.88,435250.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','68',1895,'19','1',4119748.28,4123763.79,4015.51,662559.15,0.00,0.00,0.00,0.00,0.00),('21','221','4','68',1896,'20','2',2087072.45,2094674.40,7601.95,5473404.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','68',1897,'21','2',53737.24,54301.90,564.66,406555.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','68',1898,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','68',1899,'23','2',890215.48,896129.27,5913.79,4257928.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','68',1900,'24','3',408690.14,408690.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','68',1901,'25','3',2451.33,3238.38,787.05,511583.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','68',1902,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','68',1903,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','68',1904,'28','1',3801866.44,3806616.96,4750.52,783835.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','69',1905,'1','1',4606328.22,4608336.43,1968.21,324754.65,0.00,0.00,40.00,0.00,0.00),('21','221','1','69',1906,'2','1',5147346.72,5150352.87,3006.15,496014.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','69',1907,'3','1',4313480.13,4315099.49,1619.36,267194.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','69',1908,'4','1',5613009.07,5614692.41,1683.34,277751.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','69',1909,'5','1',3805084.02,3808175.65,3091.63,510118.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','69',1910,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','69',1911,'7','1',2318264.85,2320011.94,1747.09,288269.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','69',1912,'8','1',3284187.12,3285510.76,1323.64,218400.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','69',1913,'9','1',5253107.59,5255442.47,2334.88,385255.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','69',1914,'10','1',3406080.57,3409551.59,3471.02,572718.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','69',1915,'11','1',4468058.85,4470711.93,2653.08,437758.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','69',1916,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','69',1917,'13','1',4378986.03,4380509.00,1522.97,251290.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','69',1918,'14','1',3365680.15,3367355.48,1675.33,276429.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','69',1919,'15','1',4008403.61,4009865.19,1461.58,241160.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','69',1920,'16','1',3317724.33,3319626.20,1901.87,313808.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','69',1921,'17','1',3700067.59,3701592.36,1524.77,251587.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','69',1922,'18','1',3364191.96,3365158.39,966.43,159460.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','69',1923,'19','1',4123763.79,4125115.69,1351.90,223063.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','69',1924,'20','2',2094674.40,2102786.94,8112.54,5841028.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','69',1925,'21','2',54301.90,54301.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','69',1926,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','69',1927,'23','2',896129.27,902950.09,6820.82,4910990.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','69',1928,'24','3',408690.14,408690.27,0.13,86.45,0.00,0.00,0.00,0.00,0.00),('21','221','5','69',1929,'25','3',3238.38,4091.37,852.99,554443.50,0.00,0.00,0.00,0.00,0.00),('21','221','5','69',1930,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','69',1931,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','69',1932,'28','1',3806616.96,3808235.56,1618.60,267069.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','70',1933,'1','1',4608336.43,4610498.71,2122.28,350176.20,0.00,0.00,40.00,0.00,0.00),('21','221','1','70',1934,'2','1',5150352.87,5152773.45,2420.58,399395.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','70',1935,'3','1',4315099.49,4316990.52,1891.03,312019.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','70',1936,'4','1',5614692.41,5617445.77,2753.36,454304.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','70',1937,'5','1',3808175.65,3812320.25,4144.60,683859.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','70',1938,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','70',1939,'7','1',2320011.94,2321826.13,1814.19,299341.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','70',1940,'8','1',3285510.76,3286799.70,1288.94,212675.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','70',1941,'9','1',5255442.47,5258763.80,3321.33,548019.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','70',1942,'10','1',3409551.59,3414123.90,4572.31,754431.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','70',1943,'11','1',4470711.93,4473617.51,2905.58,479420.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','70',1944,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','70',1945,'13','1',4380509.00,4383328.41,2819.41,465202.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','70',1946,'14','1',3367355.48,3370200.16,2844.68,469372.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','70',1947,'15','1',4009865.19,4013015.62,3150.43,519820.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','70',1948,'16','1',3319626.20,3322486.04,2859.84,471873.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','70',1949,'17','1',3701592.36,3704698.18,3105.82,512460.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','70',1950,'18','1',3365158.39,3368400.85,3242.46,535005.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','70',1951,'19','1',4125115.69,4128159.59,3043.90,502243.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','70',1952,'20','2',2102786.94,2111149.88,8362.94,6021316.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','70',1953,'21','2',54301.90,54955.12,653.22,470318.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','70',1954,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','70',1955,'23','2',902950.09,906696.82,3746.73,2697645.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','70',1956,'24','3',408690.27,408690.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','70',1957,'25','3',4091.37,4910.99,819.62,532755.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','70',1958,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','70',1959,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','70',1960,'28','1',3808235.56,3812088.02,3852.46,635655.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','71',1961,'1','1',4610498.71,4612741.36,2202.65,363437.25,0.00,0.00,40.00,0.00,0.00),('21','221','1','71',1962,'2','1',5152773.45,5155926.33,3152.88,520225.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','71',1963,'3','1',4316990.52,4320311.02,3320.50,547882.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','71',1964,'4','1',5617445.77,5619610.91,2165.14,357248.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','71',1965,'5','1',3812320.25,3816977.14,4656.89,768386.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','71',1966,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','71',1967,'7','1',2321826.13,2325172.99,3346.86,552231.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','71',1968,'8','1',3286799.70,3286799.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','71',1969,'9','1',5258763.80,5261600.17,2836.37,468001.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','71',1970,'10','1',3414123.90,3417936.47,3812.57,629074.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','71',1971,'11','1',4473617.51,4478157.29,4539.78,749063.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','71',1972,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','71',1973,'13','1',4383328.41,4386240.17,2911.76,480440.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','71',1974,'14','1',3370200.16,3372209.11,2008.95,331476.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','71',1975,'15','1',4013015.62,4014892.56,1876.94,309695.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','71',1976,'16','1',3322486.04,3324755.39,2269.35,374442.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','71',1977,'17','1',3704698.18,3706647.01,1948.83,321556.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','71',1978,'18','1',3368400.85,3370305.83,1904.98,314321.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','71',1979,'19','1',4128159.59,4130571.60,2412.01,397981.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','71',1980,'20','2',2111149.88,2118517.80,7367.92,5304902.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','71',1981,'21','2',54955.12,54955.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','71',1982,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','71',1983,'23','2',906696.82,910384.87,3688.05,2655396.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','71',1984,'24','3',408690.27,408690.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','71',1985,'25','3',4910.99,5608.49,697.50,453375.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','71',1986,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','71',1987,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','71',1988,'28','1',3812088.02,3814722.57,2634.55,434700.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','72',1989,'1','1',4612741.36,4616277.96,3536.60,583539.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','72',1990,'2','1',5155926.33,5158783.54,2857.21,471439.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','72',1991,'3','1',4320311.02,4322724.77,2413.75,398268.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','72',1992,'4','1',5619610.91,5623035.80,3424.89,565106.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','72',1993,'5','1',3816977.14,3821851.40,4874.26,804252.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','72',1994,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','72',1995,'7','1',2325172.99,2328180.71,3007.72,496273.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','72',1996,'8','1',3286799.70,3290134.88,3335.18,550304.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','72',1997,'9','1',5261600.17,5265340.42,3740.25,617141.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','72',1998,'10','1',3417936.47,3423783.24,5846.77,964717.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','72',1999,'11','1',4478157.29,4481769.00,3611.71,595932.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','72',2000,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','72',2001,'13','1',4386240.17,4388478.42,2198.25,362711.25,0.00,0.00,40.00,0.00,0.00),('21','221','3','72',2002,'14','1',3372209.11,3375282.87,3073.76,507170.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','72',2003,'15','1',4014892.56,4017877.99,2985.43,492595.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','72',2004,'16','1',3324755.39,3327654.09,2898.70,478285.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','72',2005,'17','1',3706647.01,3708991.39,2344.38,386822.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','72',2006,'18','1',3370305.83,3373003.38,2697.55,445095.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','72',2007,'19','1',4130571.60,4134810.84,4239.24,699474.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','72',2008,'20','2',2118517.80,2136757.19,18219.39,13846736.40,0.00,0.00,20.00,0.00,0.00),('21','221','4','72',2009,'21','2',54955.12,59305.77,4350.65,3306494.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','72',2010,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','72',2011,'23','2',910384.87,911074.59,689.72,524187.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','72',2012,'24','3',408690.27,408690.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','72',2013,'25','3',5608.49,6560.16,951.67,618584.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','72',2014,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','72',2015,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','72',2016,'28','1',3814722.57,3817632.22,2909.65,480092.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','73',2017,'1','1',4616277.96,4616277.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','73',2018,'2','1',5158783.54,5158783.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','73',2019,'3','1',4322724.77,4322724.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','73',2020,'4','1',5623035.80,5623035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','73',2021,'5','1',3821851.40,3821851.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','73',2022,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','73',2023,'7','1',2328180.71,2328180.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','73',2024,'8','1',3290134.88,3290134.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','73',2025,'9','1',5265340.42,5265340.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','73',2026,'10','1',3423783.24,3423783.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','73',2027,'11','1',4481769.00,4481769.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','73',2028,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','73',2029,'13','1',4388478.42,4388478.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','73',2030,'14','1',3375282.87,3375282.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','73',2031,'15','1',4017877.99,4017877.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','73',2032,'16','1',3327654.09,3327654.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','73',2033,'17','1',3708991.39,3708991.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','73',2034,'18','1',3373003.38,3373003.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','73',2035,'19','1',4134810.84,4134810.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','73',2036,'20','2',2136757.19,2136757.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','73',2037,'21','2',59305.77,59305.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','73',2038,'22','2',1598.47,1598.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','73',2039,'23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','73',2040,'24','3',408690.27,408690.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','73',2041,'25','3',6560.16,6560.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','73',2042,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','73',2043,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','73',2044,'28','1',3817632.22,3817632.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','74',2045,'1','1',4616277.96,4616277.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','74',2046,'2','1',5158783.54,5158783.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','74',2047,'3','1',4322724.77,4322724.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','74',2048,'4','1',5623035.80,5623035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','74',2049,'5','1',3821851.40,3821851.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','74',2050,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','74',2051,'7','1',2328180.71,2328180.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','74',2052,'8','1',3290134.88,3290134.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','74',2053,'9','1',5265340.42,5265340.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','74',2054,'10','1',3423783.24,3423783.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','74',2055,'11','1',4481769.00,4481769.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','74',2056,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','74',2057,'13','1',4388478.42,4388478.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','74',2058,'14','1',3375282.87,3375282.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','74',2059,'15','1',4017877.99,4017877.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','74',2060,'16','1',3327654.09,3327654.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','74',2061,'17','1',3708991.39,3708991.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','74',2062,'18','1',3373003.38,3373003.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','74',2063,'19','1',4134810.84,4134810.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','74',2064,'20','2',2136757.19,2136757.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','74',2065,'21','2',59305.77,59305.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','74',2066,'22','2',0.00,79.38,59.38,45128.80,0.00,0.00,20.00,0.00,0.00),('21','221','4','74',2067,'23','2',0.00,6353.82,6353.82,4828903.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','74',2068,'24','3',408690.27,408690.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','74',2069,'25','3',6560.16,6560.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','74',2070,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','74',2071,'27','3',2125.50,2125.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','74',2072,'28','1',3817632.22,3817632.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','75',2073,'1','1',4616277.96,4620696.31,4378.35,722427.75,0.00,0.00,40.00,0.00,0.00),('21','221','1','75',2074,'2','1',5158783.54,5162130.28,3346.74,552212.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','75',2075,'3','1',4322724.77,4325832.01,3107.24,512694.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','75',2076,'4','1',5623035.80,5627183.39,4147.59,684352.37,0.00,0.00,0.00,0.00,0.00),('21','221','2','75',2077,'5','1',3821851.40,3826405.55,4554.15,751434.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','75',2078,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','75',2079,'7','1',2328180.71,2331699.33,3518.62,580572.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','75',2080,'8','1',3290134.88,3293069.15,2934.27,484154.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','75',2081,'9','1',5265340.42,5267558.83,2218.41,366037.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','75',2082,'10','1',3423783.24,3429692.66,5909.42,975054.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','75',2083,'11','1',4481769.00,4485663.21,3894.21,642544.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','75',2084,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','75',2085,'13','1',4388478.42,4390913.85,2435.43,401845.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','75',2086,'14','1',3375282.87,3378288.54,3005.67,495935.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','75',2087,'15','1',4017877.99,4020338.14,2460.15,405924.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','75',2088,'16','1',3327654.09,3330138.61,2484.52,409945.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','75',2089,'17','1',3708991.39,3711821.83,2830.44,467022.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','75',2090,'18','1',3373003.38,3375761.34,2757.96,455063.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','75',2091,'19','1',4134810.84,4137654.23,2843.39,469159.35,0.00,0.00,0.00,0.00,0.00),('21','221','4','75',2092,'20','2',2136757.19,2141145.56,4388.37,3335161.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','75',2093,'21','2',59305.77,59305.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','75',2094,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','75',2095,'23','2',6353.82,11373.90,5020.08,3815260.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','75',2096,'24','3',408690.27,408701.24,10.97,7127.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','75',2097,'25','3',6560.16,21405.30,14835.14,9642838.40,0.00,0.00,10.00,0.00,0.00),('21','221','5','75',2098,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','75',2099,'27','3',2125.50,2638.18,512.68,333242.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','75',2100,'28','1',3817632.22,3820910.72,3278.50,540952.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','76',2101,'1','1',4620696.31,4620696.31,-40.00,-6600.00,0.00,0.00,40.00,0.00,0.00),('21','221','1','76',2102,'2','1',5162130.28,5162130.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','76',2103,'3','1',4325832.01,4325832.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','76',2104,'4','1',5627183.39,5627183.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','76',2105,'5','1',3826405.55,3833431.59,7026.04,1159296.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','76',2106,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','76',2107,'7','1',2331699.33,2334758.45,3059.12,504754.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','76',2108,'8','1',3293069.15,3296071.35,3002.20,495363.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','76',2109,'9','1',5267558.83,5272373.88,4815.05,794483.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','76',2110,'10','1',3429692.66,3438214.53,8521.87,1406108.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','76',2111,'11','1',4485663.21,4489992.89,4329.68,714397.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','76',2112,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','76',2113,'13','1',4390913.85,4395183.03,4269.18,704414.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','76',2114,'14','1',3378288.54,3380836.47,2547.93,420408.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','76',2115,'15','1',4020338.14,4024977.28,4639.14,765458.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','76',2116,'16','1',3330138.61,3333502.37,3363.76,555020.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','76',2117,'17','1',3711821.83,3714572.40,2750.57,453844.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','76',2118,'18','1',3375761.34,3379998.34,4237.00,699105.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','76',2119,'19','1',4137654.23,4141533.94,3879.71,640152.15,0.00,0.00,0.00,0.00,0.00),('21','221','4','76',2120,'20','2',2141145.56,2147916.11,6770.55,5145618.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','76',2121,'21','2',59305.77,61357.32,2051.55,1559178.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','76',2122,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','76',2123,'23','2',11373.90,21693.49,10319.59,7842888.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','76',2124,'24','3',408701.24,408701.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','76',2125,'25','3',21405.30,22131.47,726.17,472012.45,0.00,0.00,0.00,0.00,0.00),('21','221','5','76',2126,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','76',2127,'27','3',2638.18,2655.89,17.71,11511.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','76',2128,'28','1',3820910.72,3824231.53,3320.81,547933.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','77',2129,'1','1',4620696.31,4620696.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','77',2130,'2','1',5162130.28,5162130.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','77',2131,'3','1',4325832.01,4325832.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','77',2132,'4','1',5627183.39,5627183.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','77',2133,'5','1',3833431.59,3842357.16,8925.57,1472719.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','77',2134,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','77',2135,'7','1',2334758.45,2339277.37,4518.92,745621.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','77',2136,'8','1',3296071.35,3301833.02,5761.67,950675.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','77',2137,'9','1',5272373.88,5277732.74,5318.86,877611.90,0.00,0.00,40.00,0.00,0.00),('21','221','2','77',2138,'10','1',3438214.53,3448519.38,10304.85,1700300.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','77',2139,'11','1',4489992.89,4495071.82,5078.93,838023.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','77',2140,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','77',2141,'13','1',4395183.03,4401412.58,6229.55,1027875.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','77',2142,'14','1',3380836.47,3386001.89,5165.42,852294.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','77',2143,'15','1',4024977.28,4030329.63,5352.35,883137.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','77',2144,'16','1',3333502.37,3337966.44,4464.07,736571.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','77',2145,'17','1',3714572.40,3719645.56,5073.16,837071.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','77',2146,'18','1',3379998.34,3384753.71,4755.37,784636.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','77',2147,'19','1',4141533.94,4145646.99,4113.05,678653.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','77',2148,'20','2',2147916.11,2154062.52,6146.41,4671271.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','77',2149,'21','2',61357.32,61357.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','77',2150,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','77',2151,'23','2',21693.49,28196.45,6502.96,4942249.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','77',2152,'24','3',408701.24,408701.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','77',2153,'25','3',22131.47,22997.64,866.17,563007.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','77',2154,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','77',2155,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','77',2156,'28','1',3824231.53,3831113.33,6881.80,1135497.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','78',2157,'1','1',4620696.31,4620696.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','78',2158,'2','1',5162130.28,5162130.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','78',2159,'3','1',4325832.01,4325832.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','78',2160,'4','1',5627183.39,5627183.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','78',2161,'5','1',3842357.16,3847980.07,5622.91,927780.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','78',2162,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','78',2163,'7','1',2339277.37,2341535.92,2258.55,372660.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','78',2164,'8','1',3301833.02,3305524.09,3691.07,609026.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','78',2165,'9','1',5277732.74,5283217.84,5445.10,898441.50,0.00,0.00,40.00,0.00,0.00),('21','221','2','78',2166,'10','1',3448519.38,3454839.82,6320.44,1042872.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','78',2167,'11','1',4495071.82,4499053.38,3981.56,656957.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','78',2168,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','78',2169,'13','1',4401412.58,4404597.30,3184.72,525478.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','78',2170,'14','1',3386001.89,3389922.97,3921.08,646978.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','78',2171,'15','1',4030329.63,4033639.91,3310.28,546196.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','78',2172,'16','1',3337966.44,3340935.90,2969.46,489960.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','78',2173,'17','1',3719645.56,3722765.19,3119.63,514738.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','78',2174,'18','1',3384753.71,3390202.77,5449.06,899094.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','78',2175,'19','1',4145646.99,4149480.08,3833.09,632459.85,0.00,0.00,0.00,0.00,0.00),('21','221','4','78',2176,'20','2',2154062.52,2160436.14,6373.62,4843951.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','78',2177,'21','2',61357.32,61601.92,244.60,185896.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','78',2178,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','78',2179,'23','2',28196.45,32090.78,3894.33,2959690.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','78',2180,'24','3',408701.24,408701.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','78',2181,'25','3',22997.64,23712.44,714.80,464618.05,0.00,0.00,0.00,0.00,0.00),('21','221','5','78',2182,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','78',2183,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','78',2184,'28','1',3831113.33,3832997.14,1883.81,310828.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','79',2185,'1','1',4620696.31,4620696.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','79',2186,'2','1',5162130.28,5162130.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','79',2187,'3','1',4325832.01,4325832.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','79',2188,'4','1',5627183.39,5627183.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','79',2189,'5','1',3847980.07,3852391.88,4411.81,727948.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','79',2190,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','79',2191,'7','1',2341535.92,2344066.75,2530.83,417586.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','79',2192,'8','1',3305524.09,3306911.81,1387.72,228973.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','79',2193,'9','1',5283217.84,5285724.33,2506.49,413570.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','79',2194,'10','1',3454839.82,3459518.35,4638.53,765357.45,0.00,0.00,40.00,0.00,0.00),('21','221','2','79',2195,'11','1',4499053.38,4502704.78,3651.40,602481.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','79',2196,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','79',2197,'13','1',4404597.30,4406808.40,2211.10,364831.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','79',2198,'14','1',3389922.97,3392594.42,2671.45,440789.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','79',2199,'15','1',4033639.91,4036568.40,2928.49,483200.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','79',2200,'16','1',3340935.90,3343289.14,2353.24,388284.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','79',2201,'17','1',3722765.19,3725212.45,2447.26,403797.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','79',2202,'18','1',3390202.77,3394088.29,3885.52,641110.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','79',2203,'19','1',4149480.08,4152519.49,3039.41,501502.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','79',2204,'20','2',2160436.14,2167765.00,7328.86,5569933.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','79',2205,'21','2',61601.92,61612.58,10.66,8101.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','79',2206,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','79',2207,'23','2',32090.78,38890.92,6800.14,5168106.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','79',2208,'24','3',408701.24,408701.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','79',2209,'25','3',23712.44,23929.51,207.07,134593.55,0.00,0.00,10.00,0.00,0.00),('21','221','5','79',2210,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','79',2211,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','79',2212,'28','1',3832997.14,3833583.53,586.39,96754.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','80',2213,'1','1',4620696.31,4620696.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','80',2214,'2','1',5162130.28,5162130.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','80',2215,'3','1',4325832.01,4325832.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','80',2216,'4','1',5627183.39,5627183.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','80',2217,'5','1',3852391.88,3858299.98,5908.10,974836.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','80',2218,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','80',2219,'7','1',2344066.75,2347572.02,3505.27,578369.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','80',2220,'8','1',3306911.81,3310434.23,3522.42,581199.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','80',2221,'9','1',5285724.33,5289000.48,3236.15,533964.75,0.00,0.00,40.00,0.00,0.00),('21','221','2','80',2222,'10','1',3459518.35,3465486.46,5968.11,984738.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','80',2223,'11','1',4502704.78,4506230.14,3525.36,581684.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','80',2224,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','80',2225,'13','1',4406808.40,4409923.36,3114.96,513968.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','80',2226,'14','1',3392594.42,3395520.70,2926.28,482836.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','80',2227,'15','1',4036568.40,4039881.74,3313.34,546701.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','80',2228,'16','1',3343289.14,3345694.53,2405.39,396889.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','80',2229,'17','1',3725212.45,3728472.85,3260.40,537966.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','80',2230,'18','1',3394088.29,3399355.12,5266.83,869026.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','80',2231,'19','1',4152519.49,4155994.02,3474.53,573297.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','80',2232,'20','2',2167765.00,2179199.34,11434.34,8690098.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','80',2233,'21','2',61612.58,62431.25,818.67,622189.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','80',2234,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','80',2235,'23','2',38890.92,40537.79,1646.87,1251621.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','80',2236,'24','3',408701.24,408701.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','80',2237,'25','3',23929.51,24082.76,143.25,93109.90,0.00,0.00,10.00,0.00,0.00),('21','221','5','80',2238,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','80',2239,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','80',2240,'28','1',3833583.53,3833584.70,1.17,193.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','81',2241,'1','1',4620696.31,4620696.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','81',2242,'2','1',5162130.28,5162130.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','81',2243,'3','1',4325832.01,4325832.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','81',2244,'4','1',5627183.39,5627183.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','81',2245,'5','1',3858299.98,3865515.33,7175.35,1183932.75,0.00,0.00,40.00,0.00,0.00),('21','221','2','81',2246,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','81',2247,'7','1',2347572.02,2351769.40,4197.38,692567.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','81',2248,'8','1',3310434.23,3313189.67,2755.44,454647.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','81',2249,'9','1',5289000.48,5293444.68,4444.20,733293.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','81',2250,'10','1',3465486.46,3473070.59,7584.13,1251381.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','81',2251,'11','1',4506230.14,4511029.87,4799.73,791955.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','81',2252,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','81',2253,'13','1',4409923.36,4413765.37,3842.01,633931.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','81',2254,'14','1',3395520.70,3398922.85,3402.15,561354.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','81',2255,'15','1',4039881.74,4043746.49,3864.75,637683.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','81',2256,'16','1',3345694.53,3349561.70,3867.17,638083.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','81',2257,'17','1',3728472.85,3732913.97,4441.12,732784.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','81',2258,'18','1',3399355.12,3404236.05,4880.93,805353.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','81',2259,'19','1',4155994.02,4160156.90,4162.88,686875.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','81',2260,'20','2',2179199.34,2184816.18,5616.84,4268798.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','81',2261,'21','2',62431.25,62441.98,10.73,8154.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','81',2262,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','81',2263,'23','2',40537.79,45721.11,5183.32,3939323.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','81',2264,'24','3',408701.24,408714.98,13.73,8927.75,0.00,0.00,0.00,0.00,0.00),('21','221','5','81',2265,'25','3',24082.76,24462.18,356.42,231675.60,0.00,0.00,23.00,0.00,0.00),('21','221','5','81',2266,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','81',2267,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','81',2268,'28','1',3833584.70,3836897.51,3312.81,546613.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','82',2269,'1','1',4620696.31,4625114.70,4368.39,720784.35,0.00,0.00,50.00,0.00,0.00),('21','221','1','82',2270,'2','1',5162130.28,5165036.23,2905.95,479481.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','82',2271,'3','1',4325832.01,4330073.35,4241.34,699821.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','82',2272,'4','1',5627183.39,5629771.35,2587.96,427013.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','82',2273,'5','1',3865515.33,3870191.00,4675.67,771485.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','82',2274,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','82',2275,'7','1',2351769.40,2354530.32,2760.92,455551.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','82',2276,'8','1',3313189.67,3315327.93,2138.26,352812.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','82',2277,'9','1',5293444.68,5295933.33,2488.65,410627.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','82',2278,'10','1',3473070.59,3478961.64,5891.05,972023.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','82',2279,'11','1',4511029.87,4514391.05,3361.18,554594.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','82',2280,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','82',2281,'13','1',4413765.37,4416289.98,2524.61,416560.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','82',2282,'14','1',3398922.85,3402153.58,3230.73,533070.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','82',2283,'15','1',4043746.49,4046910.56,3164.07,522071.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','82',2284,'16','1',3349561.70,3353550.65,3988.95,658176.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','82',2285,'17','1',3732913.97,3736393.70,3479.73,574155.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','82',2286,'18','1',3404236.05,3407906.67,3670.62,605652.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','82',2287,'19','1',4160156.90,4163305.84,3148.94,519575.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','82',2288,'20','2',2184816.18,2189921.34,5105.16,3879921.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','82',2289,'21','2',62441.98,62720.75,278.77,211865.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','82',2290,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','82',2291,'23','2',45721.11,49409.83,3688.72,2803427.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','82',2292,'24','3',408714.98,408714.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','82',2293,'25','3',24462.18,25571.53,1099.35,714577.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','82',2294,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','82',2295,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','82',2296,'28','1',3836897.51,3841680.18,4782.67,789140.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','83',2297,'1','1',4625114.70,4629431.02,4316.32,712192.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','83',2298,'2','1',5165036.23,5167175.69,2139.46,353010.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','83',2299,'3','1',4330073.35,4332557.41,2484.06,409869.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','83',2300,'4','1',5629771.35,5633714.11,3942.76,650555.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','83',2301,'5','1',3870191.00,3875585.23,5394.23,890047.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','83',2302,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','83',2303,'7','1',2354530.32,2357509.66,2979.34,491591.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','83',2304,'8','1',3315327.93,3319563.55,4195.62,692277.30,0.00,0.00,40.00,0.00,0.00),('21','221','2','83',2305,'9','1',5295933.33,5299510.69,3577.36,590264.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','83',2306,'10','1',3478961.64,3486165.87,7204.23,1188697.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','83',2307,'11','1',4514391.05,4517400.92,3009.87,496628.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','83',2308,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','83',2309,'13','1',4416289.98,4418438.77,2148.79,354550.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','83',2310,'14','1',3402153.58,3404944.52,2790.94,460505.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','83',2311,'15','1',4046910.56,4049547.67,2637.11,435123.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','83',2312,'16','1',3353550.65,3356162.37,2611.72,430933.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','83',2313,'17','1',3736393.70,3738835.29,2441.59,402862.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','83',2314,'18','1',3407906.67,3411304.01,3397.34,560561.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','83',2315,'19','1',4163305.84,4165583.32,2277.48,375784.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','83',2316,'20','2',2189921.34,2196270.48,6349.14,4825346.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','83',2317,'21','2',62720.75,63425.43,704.68,535556.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','83',2318,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','83',2319,'23','2',49409.83,58135.16,8725.33,6631250.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','83',2320,'24','3',408714.98,408714.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','83',2321,'25','3',25571.53,26666.00,1084.47,704908.10,0.00,0.00,10.00,0.00,0.00),('21','221','5','83',2322,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','83',2323,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','83',2324,'28','1',3841680.18,3844710.28,3030.10,499966.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','84',2325,'1','1',4629431.02,4633192.86,3761.84,620703.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','84',2326,'2','1',5167175.69,5170723.20,3547.51,585339.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','84',2327,'3','1',4332557.41,4335799.94,3242.53,535017.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','84',2328,'4','1',5633714.11,5637357.05,3642.94,601085.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','84',2329,'5','1',3875585.23,3879532.56,3947.33,651309.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','84',2330,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','84',2331,'7','1',2357509.66,2360120.64,2610.98,430811.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','84',2332,'8','1',3319563.55,3322815.03,3251.48,536494.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','84',2333,'9','1',5299510.69,5302818.59,3307.90,545803.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','84',2334,'10','1',3486165.87,3492184.02,6018.15,992994.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','84',2335,'11','1',4517400.92,4520505.94,3105.02,512328.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','84',2336,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','84',2337,'13','1',4418438.77,4421560.55,3121.78,515093.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','84',2338,'14','1',3404944.52,3407454.39,2509.87,414128.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','84',2339,'15','1',4049547.67,4051730.76,2183.09,360209.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','84',2340,'16','1',3356162.37,3358064.28,1901.91,313815.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','84',2341,'17','1',3738835.29,3741509.30,2674.01,441211.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','84',2342,'18','1',3411304.01,3414388.32,3084.31,508911.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','84',2343,'19','1',4165583.32,4168445.53,2862.21,472264.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','84',2344,'20','2',2196270.48,2201849.81,5579.33,4240290.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','84',2345,'21','2',63425.43,64577.18,1151.75,875330.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','84',2346,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','84',2347,'23','2',58135.16,64293.47,6158.31,4680315.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','84',2348,'24','3',408714.98,408714.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','84',2349,'25','3',26666.00,27902.94,1236.94,804008.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','84',2350,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','84',2351,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','84',2352,'28','1',3844710.28,3850000.99,5290.71,872967.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','85',2353,'1','1',4633192.86,4638488.09,5295.23,873712.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','85',2354,'2','1',5170723.20,5176850.49,6127.29,1011002.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','85',2355,'3','1',4335799.94,4340236.32,4436.38,732002.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','85',2356,'4','1',5637357.05,5643683.16,6326.11,1043808.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','85',2357,'5','1',3879532.56,3885867.79,6335.23,1045312.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','85',2358,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','85',2359,'7','1',2360120.64,2364781.52,4660.88,769045.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','85',2360,'8','1',3322815.03,3327971.57,5156.54,850829.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','85',2361,'9','1',5302818.59,5306638.37,3779.78,623663.70,0.00,0.00,40.00,0.00,0.00),('21','221','2','85',2362,'10','1',3492184.02,3498889.51,6705.49,1106405.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','85',2363,'11','1',4520505.94,4526745.36,6239.42,1029504.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','85',2364,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','85',2365,'13','1',4421560.55,4424315.30,2754.75,454533.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','85',2366,'14','1',3407454.39,3410700.25,3245.86,535566.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','85',2367,'15','1',4051730.76,4054242.21,2511.45,414389.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','85',2368,'16','1',3358064.28,3361618.33,3554.05,586418.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','85',2369,'17','1',3741509.30,3745595.67,4086.37,674251.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','85',2370,'18','1',3414388.32,3419465.62,5077.30,837754.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','85',2371,'19','1',4168445.53,4171685.14,3239.61,534535.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','85',2372,'20','2',2201849.81,2210690.82,8841.01,6719167.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','85',2373,'21','2',64577.18,64577.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','85',2374,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','85',2375,'23','2',64293.47,72719.31,8425.84,6403638.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','85',2376,'24','3',408714.98,408714.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','85',2377,'25','3',27902.94,29727.48,1814.54,1179452.30,0.00,0.00,10.00,0.00,0.00),('21','221','5','85',2378,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','85',2379,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','85',2380,'28','1',3850000.99,3856225.76,6224.77,1027087.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','86',2381,'1','1',4638488.09,4639817.99,1329.90,219433.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','86',2382,'2','1',5176850.49,5178412.60,1562.11,257748.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','86',2383,'3','1',4340236.32,4341944.39,1708.07,281831.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','86',2384,'4','1',5643683.16,5645602.20,1919.04,316641.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','86',2385,'5','1',3885867.79,3891056.72,5188.93,856173.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','86',2386,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','86',2387,'7','1',2364781.52,2367673.92,2892.40,477246.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','86',2388,'8','1',3327971.57,3331297.22,3325.65,548732.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','86',2389,'9','1',5306638.37,5309725.14,3086.77,509317.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','86',2390,'10','1',3498889.51,3505086.53,6197.02,1022508.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','86',2391,'11','1',4526745.36,4530012.59,3267.23,539092.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','86',2392,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','86',2393,'13','1',4424315.30,4426920.28,2604.98,429821.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','86',2394,'14','1',3410700.25,3412794.01,2093.76,345470.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','86',2395,'15','1',4054242.21,4057018.38,2776.17,458068.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','86',2396,'16','1',3361618.33,3364541.98,2923.65,482402.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','86',2397,'17','1',3745595.67,3748373.25,2777.58,458300.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','86',2398,'18','1',3419465.62,3423685.37,4219.75,696258.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','86',2399,'19','1',4171685.14,4174234.33,2549.19,420616.35,0.00,0.00,0.00,0.00,0.00),('21','221','4','86',2400,'20','2',2210690.82,2215478.41,4787.59,3638568.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','86',2401,'21','2',64577.18,64854.31,277.13,210618.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','86',2402,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','86',2403,'23','2',72719.31,77105.30,4385.99,3333352.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','86',2404,'24','3',408714.98,408745.52,30.54,19848.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','86',2405,'25','3',29727.48,31351.53,1604.05,1042629.25,0.00,0.00,20.00,0.00,0.00),('21','221','5','86',2406,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','86',2407,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','86',2408,'28','1',3856225.76,3860495.88,4230.12,697969.80,0.00,0.00,40.00,0.00,0.00),('21','221','1','87',2409,'1','1',4639817.99,4639817.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','87',2410,'2','1',5178412.60,5178412.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','87',2411,'3','1',4341944.39,4341944.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','87',2412,'4','1',5645602.20,5645602.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','87',2413,'5','1',3891056.72,3891056.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','87',2414,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','87',2415,'7','1',2367673.92,2367673.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','87',2416,'8','1',3331297.22,3331297.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','87',2417,'9','1',5309725.14,5309725.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','87',2418,'10','1',3505086.53,3505086.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','87',2419,'11','1',4530012.59,4530012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','87',2420,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','87',2421,'13','1',4426920.28,4426920.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','87',2422,'14','1',3412794.01,3412794.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','87',2423,'15','1',4057018.38,4057018.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','87',2424,'16','1',3364541.98,3364541.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','87',2425,'17','1',3748373.25,3748373.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','87',2426,'18','1',3423685.37,3423685.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','87',2427,'19','1',4174234.33,4174234.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','87',2428,'20','2',2215478.41,2219702.49,4224.08,3294782.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','87',2429,'21','2',64854.31,65019.09,164.78,128528.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','87',2430,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','87',2431,'23','2',77105.30,81146.69,4041.39,3152284.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','87',2432,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','87',2433,'25','3',31351.53,31351.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','87',2434,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','87',2435,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','87',2436,'28','1',3860495.88,3860495.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','88',2437,'1','1',4639817.99,4639817.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','88',2438,'2','1',5178412.60,5180197.78,1715.18,283004.70,0.00,0.00,70.00,0.00,0.00),('21','221','1','88',2439,'3','1',4341944.39,4343398.14,1453.75,239868.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','88',2440,'4','1',5645602.20,5648815.40,3213.20,530178.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','88',2441,'5','1',3891056.72,3893724.75,2668.03,440224.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','88',2442,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','88',2443,'7','1',2367673.92,2368601.46,927.54,153044.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','88',2444,'8','1',3331297.22,3332374.18,1076.96,177698.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','88',2445,'9','1',5309725.14,5311460.00,1734.86,286251.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','88',2446,'10','1',3505086.53,3507717.03,2630.50,434032.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','88',2447,'11','1',4530012.59,4531721.13,1708.54,281909.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','88',2448,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','88',2449,'13','1',4426920.28,4427781.20,860.92,142051.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','88',2450,'14','1',3412794.01,3413879.07,1085.06,179034.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','88',2451,'15','1',4057018.38,4058261.85,1243.47,205172.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','88',2452,'16','1',3364541.98,3366194.29,1652.31,272631.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','88',2453,'17','1',3748373.25,3749427.82,1054.57,174004.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','88',2454,'18','1',3423685.37,3425829.58,2144.21,353794.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','88',2455,'19','1',4174234.33,4175128.50,894.17,147538.05,0.00,0.00,0.00,0.00,0.00),('21','221','4','88',2456,'20','2',2219702.49,2226529.34,6826.85,5324943.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','88',2457,'21','2',65019.09,65019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','88',2458,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','88',2459,'23','2',81146.69,92333.73,11187.04,8725891.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','88',2460,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','88',2461,'25','3',31351.53,32214.36,852.83,554338.85,0.00,0.00,10.00,0.00,0.00),('21','221','5','88',2462,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','88',2463,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','88',2464,'28','1',3860495.88,3864101.99,3606.11,595008.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','89',2465,'1','1',4639817.99,4642211.69,2393.70,394960.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','89',2466,'2','1',5180197.78,5182127.61,1929.83,318421.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','89',2467,'3','1',4343398.14,4345853.51,2455.37,405136.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','89',2468,'4','1',5648815.40,5651434.38,2618.98,432131.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','89',2469,'5','1',3893724.75,3898154.28,4429.53,730872.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','89',2470,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','89',2471,'7','1',2368601.46,2370952.56,2351.10,387931.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','89',2472,'8','1',3332374.18,3335167.36,2793.18,460874.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','89',2473,'9','1',5311460.00,5315075.59,3615.59,596572.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','89',2474,'10','1',3507717.03,3513060.65,5343.62,881697.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','89',2475,'11','1',4531721.13,4535215.63,3494.50,576592.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','89',2476,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','89',2477,'13','1',4427781.20,4431424.13,3642.93,601083.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','89',2478,'14','1',3413879.07,3417069.79,3190.72,526468.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','89',2479,'15','1',4058261.85,4061611.58,3349.73,552705.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','89',2480,'16','1',3366194.29,3369347.91,3153.62,520347.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','89',2481,'17','1',3749427.82,3752698.42,3270.60,539649.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','89',2482,'18','1',3425829.58,3429518.74,3689.16,608711.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','89',2483,'19','1',4175128.50,4178513.02,3384.52,558445.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','89',2484,'20','2',2226529.34,2235477.54,8948.20,6979596.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','89',2485,'21','2',65019.09,67087.25,2068.16,1613164.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','89',2486,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','89',2487,'23','2',92333.73,96964.96,4631.23,3612359.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','89',2488,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','89',2489,'25','3',32214.36,34565.13,2350.77,1527999.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','89',2490,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','89',2491,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','89',2492,'28','1',3864101.99,3870302.22,6200.23,1023037.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','90',2493,'1','1',4642211.69,4647223.43,5011.74,826937.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','90',2494,'2','1',5182127.61,5186969.19,4841.58,798860.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','90',2495,'3','1',4345853.51,4350123.54,4270.03,704554.97,0.00,0.00,0.00,0.00,0.00),('21','221','1','90',2496,'4','1',5651434.38,5656372.52,4938.14,814793.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','90',2497,'5','1',3898154.28,3904865.18,6710.90,1107298.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','90',2498,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','90',2499,'7','1',2370952.56,2373505.47,2552.91,421230.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','90',2500,'8','1',3335167.36,3341185.93,6018.57,993064.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','90',2501,'9','1',5315075.59,5320673.87,5548.28,915466.20,0.00,0.00,50.00,0.00,0.00),('21','221','2','90',2502,'10','1',3513060.65,3520900.52,7839.87,1293578.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','90',2503,'11','1',4535215.63,4541014.60,5798.97,956830.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','90',2504,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','90',2505,'13','1',4431424.13,4436397.76,4973.63,820648.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','90',2506,'14','1',3417069.79,3421220.65,4150.86,684891.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','90',2507,'15','1',4061611.58,4065314.43,3702.85,610970.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','90',2508,'16','1',3369347.91,3373294.49,3946.58,651185.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','90',2509,'17','1',3752698.42,3756949.91,4251.49,701495.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','90',2510,'18','1',3429518.74,3433597.85,4079.11,673053.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','90',2511,'19','1',4178513.02,4182663.28,4150.26,684792.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','90',2512,'20','2',2235477.54,2243088.79,7611.25,5936775.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','90',2513,'21','2',67087.25,69481.47,2394.22,1867491.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','90',2514,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','90',2515,'23','2',96964.96,103337.85,6372.89,4970854.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','90',2516,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','90',2517,'25','3',34565.13,35978.80,1403.67,912386.80,0.00,0.00,10.00,0.00,0.00),('21','221','5','90',2518,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','90',2519,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','90',2520,'28','1',3870302.22,3876532.44,6230.22,1027986.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','91',2521,'1','1',4647223.43,4652065.42,4791.99,790678.35,0.00,0.00,50.00,0.00,0.00),('21','221','1','91',2522,'2','1',5186969.19,5190665.02,3695.83,609811.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','91',2523,'3','1',4350123.54,4354767.87,4644.33,766314.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','91',2524,'4','1',5656372.52,5660408.96,4036.44,666012.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','91',2525,'5','1',3904865.18,3911743.63,6878.45,1134944.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','91',2526,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','91',2527,'7','1',2373505.47,2377968.32,4462.85,736370.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','91',2528,'8','1',3341185.93,3345079.38,3893.45,642419.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','91',2529,'9','1',5320673.87,5324674.21,4000.34,660056.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','91',2530,'10','1',3520900.52,3529565.47,8664.95,1429716.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','91',2531,'11','1',4541014.60,4546748.80,5734.20,946143.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','91',2532,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','91',2533,'13','1',4436397.76,4440744.51,4346.75,717213.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','91',2534,'14','1',3421220.65,3425039.93,3819.28,630181.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','91',2535,'15','1',4065314.43,4069462.29,4147.86,684396.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','91',2536,'16','1',3373294.49,3377387.91,4093.42,675414.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','91',2537,'17','1',3756949.91,3761564.49,4614.58,761405.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','91',2538,'18','1',3433597.85,3440440.26,6842.41,1128997.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','91',2539,'19','1',4182663.28,4185631.94,2968.66,489828.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','91',2540,'20','2',2243088.79,2249794.07,6705.28,5364224.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','91',2541,'21','2',69481.47,69481.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','91',2542,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','91',2543,'23','2',103337.85,108465.82,5127.97,4102376.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','91',2544,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','91',2545,'25','3',35978.80,36916.28,927.48,649235.30,0.00,0.00,10.00,0.00,0.00),('21','221','5','91',2546,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','91',2547,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','91',2548,'28','1',3876532.44,3883002.22,6469.78,1067513.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','92',2549,'1','1',4652065.42,4657336.28,5270.86,869691.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','92',2550,'2','1',5190665.02,5192441.32,1776.30,293089.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','92',2551,'3','1',4354767.87,4358779.55,4011.68,661927.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','92',2552,'4','1',5660408.96,5664330.51,3921.55,647055.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','92',2553,'5','1',3911743.63,3915822.23,4078.60,672969.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','92',2554,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','92',2555,'7','1',2377968.32,2380425.54,2457.22,405441.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','92',2556,'8','1',3345079.38,3349574.79,4495.41,741742.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','92',2557,'9','1',5324674.21,5328419.03,3694.82,609645.30,0.00,0.00,50.00,0.00,0.00),('21','221','2','92',2558,'10','1',3529565.47,3534923.19,5357.72,884023.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','92',2559,'11','1',4546748.80,4549346.40,2597.60,428604.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','92',2560,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','92',2561,'13','1',4440744.51,4443498.49,2753.98,454406.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','92',2562,'14','1',3425039.93,3427538.15,2498.22,412206.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','92',2563,'15','1',4069462.29,4072502.47,3040.18,501629.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','92',2564,'16','1',3377387.91,3379799.84,2411.93,397968.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','92',2565,'17','1',3761564.49,3764498.35,2933.86,484086.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','92',2566,'18','1',3440440.26,3444203.47,3763.21,620929.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','92',2567,'19','1',4185631.94,4188652.51,3020.57,498394.05,0.00,0.00,0.00,0.00,0.00),('21','221','4','92',2568,'20','2',2249794.07,2258250.96,8456.89,6765512.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','92',2569,'21','2',69481.47,71438.76,1957.29,1565832.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','92',2570,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','92',2571,'23','2',108465.82,119174.22,10708.40,8566720.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','92',2572,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','92',2573,'25','3',36916.28,38639.04,1712.76,1198930.60,0.00,0.00,10.00,0.00,0.00),('21','221','5','92',2574,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','92',2575,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','92',2576,'28','1',3883002.22,3888426.80,5424.58,895055.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','93',2577,'1','1',4657336.28,4658242.58,906.30,149539.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','93',2578,'2','1',5192441.32,5192992.68,551.36,90974.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','93',2579,'3','1',4358779.55,4359882.73,1103.18,182024.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','93',2580,'4','1',5664330.51,5665412.02,1081.51,178449.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','93',2581,'5','1',3915822.23,3916950.80,1128.57,186214.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','93',2582,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','93',2583,'7','1',2380425.54,2381471.77,1046.23,172627.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','93',2584,'8','1',3349574.79,3351100.64,1525.85,251765.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','93',2585,'9','1',5328419.03,5328665.55,196.52,32425.80,0.00,0.00,50.00,0.00,0.00),('21','221','2','93',2586,'10','1',3534923.19,3537224.74,2301.55,379755.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','93',2587,'11','1',4549346.40,4550538.23,1191.83,196651.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','93',2588,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','93',2589,'13','1',4443498.49,4444464.95,966.46,159465.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','93',2590,'14','1',3427538.15,3428579.29,1041.14,171788.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','93',2591,'15','1',4072502.47,4073465.53,963.06,158904.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','93',2592,'16','1',3379799.84,3380961.97,1162.13,191751.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','93',2593,'17','1',3764498.35,3765214.60,716.25,118181.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','93',2594,'18','1',3444203.47,3445420.25,1216.78,200768.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','93',2595,'19','1',4188652.51,4189400.19,747.68,123367.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','93',2596,'20','2',2258250.96,2259971.48,1720.52,1376416.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','93',2597,'21','2',71438.76,71438.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','93',2598,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','93',2599,'23','2',119174.22,121521.14,2346.92,1877536.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','93',2600,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','93',2601,'25','3',38639.04,39523.19,874.15,611904.30,0.00,0.00,10.00,0.00,0.00),('21','221','5','93',2602,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','93',2603,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','93',2604,'28','1',3888426.80,3890670.40,2243.60,370194.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','94',2605,'1','1',4658242.58,4661342.02,3099.44,511407.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','94',2606,'2','1',5192992.68,5195478.35,2485.67,410135.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','94',2607,'3','1',4359882.73,4363387.81,3505.08,578338.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','94',2608,'4','1',5665412.02,5668638.66,3226.64,532395.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','94',2609,'5','1',3916950.80,3921237.65,4286.85,707330.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','94',2610,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','94',2611,'7','1',2381471.77,2384355.98,2884.21,475894.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','94',2612,'8','1',3351100.64,3355885.77,4785.13,789546.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','94',2613,'9','1',5328665.55,5331154.91,2449.36,404144.40,0.00,0.00,40.00,0.00,0.00),('21','221','2','94',2614,'10','1',3537224.74,3542939.00,5714.26,942852.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','94',2615,'11','1',4550538.23,4554756.05,4217.82,695940.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','94',2616,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','94',2617,'13','1',4444464.95,4447753.87,3288.92,542671.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','94',2618,'14','1',3428579.29,3430831.52,2252.23,371617.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','94',2619,'15','1',4073465.53,4076997.21,3531.68,582727.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','94',2620,'16','1',3380961.97,3384288.54,3326.57,548884.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','94',2621,'17','1',3765214.60,3767162.80,1948.20,321453.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','94',2622,'18','1',3445420.25,3450172.60,4752.35,784137.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','94',2623,'19','1',4189400.19,4191782.44,2382.25,393071.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','94',2624,'20','2',2259971.48,2264168.45,4196.97,3357576.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','94',2625,'21','2',71438.76,71438.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','94',2626,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','94',2627,'23','2',121521.14,134363.27,12842.13,10273704.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','94',2628,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','94',2629,'25','3',39523.19,40412.01,878.82,615171.20,0.00,0.00,10.00,0.00,0.00),('21','221','5','94',2630,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','94',2631,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','94',2632,'28','1',3890670.40,3895627.91,4957.51,817989.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','95',2633,'1','1',4661342.02,4663120.42,1728.40,285186.00,0.00,0.00,50.00,0.00,0.00),('21','221','1','95',2634,'2','1',5195478.35,5197383.26,1904.91,314310.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','95',2635,'3','1',4363387.81,4365157.25,1769.44,291957.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','95',2636,'4','1',5668638.66,5670975.99,2337.33,385659.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','95',2637,'5','1',3921237.65,3924856.07,3618.42,597039.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','95',2638,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','95',2639,'7','1',2384355.98,2386429.60,2073.62,342147.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','95',2640,'8','1',3355885.77,3359245.85,3360.08,554413.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','95',2641,'9','1',5331154.91,5334255.71,3100.80,511632.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','95',2642,'10','1',3542939.00,3547423.24,4484.24,739899.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','95',2643,'11','1',4554756.05,4557448.37,2692.32,444232.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','95',2644,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','95',2645,'13','1',4447753.87,4450068.46,2314.59,381907.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','95',2646,'14','1',3430831.52,3432733.34,1901.82,313800.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','95',2647,'15','1',4076997.21,4079833.32,2836.11,467958.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','95',2648,'16','1',3384288.54,3386506.32,2217.78,365933.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','95',2649,'17','1',3767162.80,3769448.59,2285.79,377155.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','95',2650,'18','1',3450172.60,3452326.52,2153.92,355396.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','95',2651,'19','1',4191782.44,4194003.78,2221.34,366521.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','95',2652,'20','2',2264168.45,2266484.43,2305.98,1844784.00,0.00,0.00,10.00,0.00,0.00),('21','221','4','95',2653,'21','2',71438.76,71438.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','95',2654,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','95',2655,'23','2',134363.27,139356.59,4993.32,3994656.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','95',2656,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','95',2657,'25','3',40412.01,40640.23,218.22,152756.10,0.00,0.00,10.00,0.00,0.00),('21','221','5','95',2658,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','95',2659,'27','3',2655.89,2655.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','95',2660,'28','1',3895627.91,3900164.88,4536.97,748600.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','96',2661,'1','1',4663120.42,4666265.21,3094.79,510640.35,0.00,0.00,50.00,0.00,0.00),('21','221','1','96',2662,'2','1',5197383.26,5200026.51,2643.25,436136.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','96',2663,'3','1',4365157.25,4368004.50,2847.25,469796.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','96',2664,'4','1',5670975.99,5673285.88,2309.89,381131.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','96',2665,'5','1',3924856.07,3928691.27,3835.20,632808.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','96',2666,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','96',2667,'7','1',2386429.60,2388174.47,1744.87,287903.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','96',2668,'8','1',3359245.85,3361338.00,2092.15,345204.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','96',2669,'9','1',5334255.71,5337176.62,2920.91,481950.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','96',2670,'10','1',3547423.24,3551960.67,4537.43,748675.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','96',2671,'11','1',4557448.37,4560750.32,3301.95,544821.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','96',2672,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','96',2673,'13','1',4450068.46,4452618.94,2550.48,420829.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','96',2674,'14','1',3432733.34,3434646.08,1912.74,315602.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','96',2675,'15','1',4079833.32,4082597.04,2763.72,456013.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','96',2676,'16','1',3386506.32,3389262.68,2756.36,454799.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','96',2677,'17','1',3769448.59,3772087.64,2639.05,435443.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','96',2678,'18','1',3452326.52,3454977.56,2651.04,437421.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','96',2679,'19','1',4194003.78,4197073.17,3069.39,506449.35,0.00,0.00,0.00,0.00,0.00),('21','221','4','96',2680,'20','2',2266484.43,2272849.18,6364.75,5219095.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','96',2681,'21','2',71438.76,71438.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','96',2682,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','96',2683,'23','2',139356.59,144337.01,4980.42,4083944.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','96',2684,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','96',2685,'25','3',40640.23,40776.49,136.26,102196.50,0.00,0.00,0.00,0.00,0.00),('21','221','5','96',2686,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','96',2687,'27','3',2655.89,2861.58,185.69,139267.50,0.00,0.00,20.00,0.00,0.00),('21','221','3','96',2688,'28','1',3900164.88,3903100.95,2936.07,484451.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','97',2689,'1','1',4666265.21,4668319.80,2054.59,339007.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','97',2690,'2','1',5200026.51,5202838.78,2812.27,464024.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','97',2691,'3','1',4368004.50,4370490.06,2485.56,410117.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','97',2692,'4','1',5673285.88,5675756.83,2470.95,407706.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','97',2693,'5','1',3928691.27,3932773.83,4082.56,673622.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','97',2694,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','97',2695,'7','1',2388174.47,2390096.99,1922.52,317215.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','97',2696,'8','1',3361338.00,3365071.35,3733.35,616002.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','97',2697,'9','1',5337176.62,5340628.57,3401.95,561321.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','97',2698,'10','1',3551960.67,3556339.48,4378.81,722503.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','97',2699,'11','1',4560750.32,4563820.23,3069.91,506535.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','97',2700,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','97',2701,'13','1',4452618.94,4454843.56,2224.62,367062.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','97',2702,'14','1',3434646.08,3436512.38,1866.30,307939.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','97',2703,'15','1',4082597.04,4084046.85,1449.81,239218.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','97',2704,'16','1',3389262.68,3391216.20,1953.52,322330.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','97',2705,'17','1',3772087.64,3775489.15,3401.51,561249.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','97',2706,'18','1',3454977.56,3458987.00,4009.44,661557.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','97',2707,'19','1',4197073.17,4199068.51,1995.34,329231.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','97',2708,'20','2',2272849.18,2280646.50,7797.32,6393802.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','97',2709,'21','2',71438.76,71438.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','97',2710,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','97',2711,'23','2',144337.01,151962.87,7625.86,6253205.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','97',2712,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','97',2713,'25','3',40776.49,41702.92,916.43,687324.75,0.00,0.00,10.00,0.00,0.00),('21','221','5','97',2714,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','97',2715,'27','3',2861.58,2861.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','97',2716,'28','1',3903100.95,3906355.26,3254.31,536961.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','98',2717,'1','1',4668319.80,4669944.84,1625.04,268131.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','98',2718,'2','1',5202838.78,5203735.64,896.86,147981.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','98',2719,'3','1',4370490.06,4372127.88,1637.82,270240.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','98',2720,'4','1',5675756.83,5676474.92,718.09,118484.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','98',2721,'5','1',3932773.83,3934693.32,1919.49,316715.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','98',2722,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','98',2723,'7','1',2390096.99,2391196.13,1099.14,181358.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','98',2724,'8','1',3365071.35,3366010.85,939.50,155017.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','98',2725,'9','1',5340628.57,5341475.65,797.08,131518.20,0.00,0.00,50.00,0.00,0.00),('21','221','2','98',2726,'10','1',3556339.48,3558068.36,1728.88,285265.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','98',2727,'11','1',4563820.23,4565208.15,1387.92,229006.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','98',2728,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','98',2729,'13','1',4454843.56,4455663.37,819.81,135268.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','98',2730,'14','1',3436512.38,3437346.30,833.92,137596.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','98',2731,'15','1',4084046.85,4085095.12,1048.27,172964.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','98',2732,'16','1',3391216.20,3392164.21,948.01,156421.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','98',2733,'17','1',3775489.15,3776526.34,1037.19,171136.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','98',2734,'18','1',3458987.00,3460458.21,1471.21,242749.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','98',2735,'19','1',4199068.51,4200376.92,1308.41,215887.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','98',2736,'20','2',2280646.50,2284095.70,3449.20,2828344.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','98',2737,'21','2',71438.76,71845.45,406.69,333485.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','98',2738,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','98',2739,'23','2',151962.87,159046.07,7083.20,5808224.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','98',2740,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','98',2741,'25','3',41702.92,42578.95,856.03,642021.00,0.00,0.00,20.00,0.00,0.00),('21','221','5','98',2742,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','98',2743,'27','3',2861.58,2861.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','98',2744,'28','1',3906355.26,3907151.05,795.79,131305.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','99',2745,'1','1',4669944.84,4675728.64,5783.80,954327.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','99',2746,'2','1',5203735.64,5208440.25,4704.61,776260.65,0.00,0.00,0.00,0.00,0.00),('21','221','1','99',2747,'3','1',4372127.88,4376668.40,4540.52,749185.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','99',2748,'4','1',5676474.92,5681624.74,5149.82,849720.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','99',2749,'5','1',3934693.32,3941320.31,6626.99,1093453.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','99',2750,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','99',2751,'7','1',2391196.13,2394850.72,3654.59,603007.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','99',2752,'8','1',3366010.85,3370536.32,4525.47,746702.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','99',2753,'9','1',5341475.65,5345393.50,3867.85,638195.25,0.00,0.00,50.00,0.00,0.00),('21','221','2','99',2754,'10','1',3558068.36,3564452.48,6384.12,1053379.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','99',2755,'11','1',4565208.15,4570009.00,4800.85,792140.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','99',2756,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','99',2757,'13','1',4455663.37,4459926.50,4263.13,703416.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','99',2758,'14','1',3437346.30,3440245.85,2899.55,478425.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','99',2759,'15','1',4085095.12,4088640.38,3545.26,584967.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','99',2760,'16','1',3392164.21,3395930.51,3766.30,621439.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','99',2761,'17','1',3776526.34,3780206.44,3680.10,607216.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','99',2762,'18','1',3460458.21,3464463.03,4004.82,660795.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','99',2763,'19','1',4200376.92,4204982.05,4605.13,759846.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','99',2764,'20','2',2284095.70,2288416.31,4320.61,3542900.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','99',2765,'21','2',71845.45,71845.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','99',2766,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','99',2767,'23','2',159046.07,173495.94,14449.87,11848893.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','99',2768,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','99',2769,'25','3',42578.95,43397.60,798.65,598985.25,0.00,0.00,20.00,0.00,0.00),('21','221','5','99',2770,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','99',2771,'27','3',2861.58,2861.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','99',2772,'28','1',3907151.05,3911725.04,4573.99,754708.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','100',2773,'1','1',4675728.64,4679058.02,3329.38,549347.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','100',2774,'2','1',5208440.25,5211417.98,2977.73,491325.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','100',2775,'3','1',4376668.40,4379574.69,2906.29,479537.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','100',2776,'4','1',5681624.74,5683597.61,1972.87,325523.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','100',2777,'5','1',3941320.31,3947585.31,6265.00,1033725.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','100',2778,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','100',2779,'7','1',2394850.72,2397663.90,2813.18,464174.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','100',2780,'8','1',3370536.32,3373995.07,3458.75,570693.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','100',2781,'9','1',5345393.50,5349203.15,3759.65,620342.25,0.00,0.00,50.00,0.00,0.00),('21','221','2','100',2782,'10','1',3564452.48,3571445.00,6992.52,1153765.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','100',2783,'11','1',4570009.00,4573773.62,3764.62,621162.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','100',2784,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','100',2785,'13','1',4459926.50,4462824.07,2897.57,478099.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','100',2786,'14','1',3440245.85,3444174.61,3928.76,648245.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','100',2787,'15','1',4088640.38,4092204.03,3563.65,588002.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','100',2788,'16','1',3395930.51,3399115.01,3184.50,525442.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','100',2789,'17','1',3780206.44,3782205.24,1998.80,329802.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','100',2790,'18','1',3464463.03,3468413.33,3950.30,651799.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','100',2791,'19','1',4204982.05,4208659.65,3677.60,606804.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','100',2792,'20','2',2288416.31,2291715.39,3299.08,2738236.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','100',2793,'21','2',71845.45,71845.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','100',2794,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','100',2795,'23','2',173495.94,176827.46,3331.52,2765161.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','100',2796,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','100',2797,'25','3',43397.60,44249.22,841.62,631211.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','100',2798,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','100',2799,'27','3',2861.58,2861.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','100',2800,'28','1',3911725.04,3916214.16,4489.12,740704.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','101',2801,'1','1',4679058.02,4681542.36,2484.34,409916.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','101',2802,'2','1',5211417.98,5214569.76,3151.78,520043.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','101',2803,'3','1',4379574.69,4382691.33,3116.64,514245.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','101',2804,'4','1',5683597.61,5686462.98,2865.37,472786.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','101',2805,'5','1',3947585.31,3951220.55,3635.24,599814.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','101',2806,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','101',2807,'7','1',2397663.90,2399295.20,1631.30,269164.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','101',2808,'8','1',3373995.07,3377128.59,3083.52,508780.80,0.00,0.00,50.00,0.00,0.00),('21','221','2','101',2809,'9','1',5349203.15,5351888.56,2685.41,443092.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','101',2810,'10','1',3571445.00,3575597.36,4152.36,685139.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','101',2811,'11','1',4573773.62,4575817.69,2044.07,337271.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','101',2812,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','101',2813,'13','1',4462824.07,4465210.90,2386.83,393826.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','101',2814,'14','1',3444174.61,3445767.40,1592.79,262810.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','101',2815,'15','1',4092204.03,4094086.48,1882.45,310604.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','101',2816,'16','1',3399115.01,3400918.63,1803.62,297597.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','101',2817,'17','1',3782205.24,3783949.87,1744.63,287863.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','101',2818,'18','1',3468413.33,3470889.22,2475.89,408521.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','101',2819,'19','1',4208659.65,4210059.68,1400.03,231004.95,0.00,0.00,0.00,0.00,0.00),('21','221','4','101',2820,'20','2',2291715.39,2297516.27,5800.88,4814730.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','101',2821,'21','2',71845.45,71845.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','101',2822,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','101',2823,'23','2',176827.46,180578.03,3750.57,3112973.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','101',2824,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','101',2825,'25','3',44249.22,45037.60,778.38,583785.75,0.00,0.00,10.00,0.00,0.00),('21','221','5','101',2826,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','101',2827,'27','3',2861.58,2861.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','101',2828,'28','1',3916214.16,3918677.18,2463.02,406398.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','102',2829,'1','1',4681542.36,4684637.30,3094.94,510665.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','102',2830,'2','1',5214569.76,5215293.14,723.38,119357.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','102',2831,'3','1',4382691.33,4386568.81,3877.48,639784.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','102',2832,'4','1',5686462.98,5689213.24,2750.26,453792.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','102',2833,'5','1',3951220.55,3954845.19,3624.64,598065.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','102',2834,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','102',2835,'7','1',2399295.20,2401438.56,2143.36,353654.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','102',2836,'8','1',3377128.59,3379555.29,2426.70,400405.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','102',2837,'9','1',5351888.56,5353554.98,1616.42,266709.30,0.00,0.00,50.00,0.00,0.00),('21','221','2','102',2838,'10','1',3575597.36,3579572.13,3974.77,655837.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','102',2839,'11','1',4575817.69,4577440.08,1622.39,267694.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','102',2840,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','102',2841,'13','1',4465210.90,4468442.56,3231.66,533223.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','102',2842,'14','1',3445767.40,3447860.14,2092.74,345302.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','102',2843,'15','1',4094086.48,4096685.00,2598.52,428755.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','102',2844,'16','1',3400918.63,3403016.81,2098.18,346199.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','102',2845,'17','1',3783949.87,3786213.82,2263.95,373551.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','102',2846,'18','1',3470889.22,3473691.09,2801.87,462308.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','102',2847,'19','1',4210059.68,4211979.01,1919.33,316689.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','102',2848,'20','2',2297516.27,2297553.51,37.24,30909.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','102',2849,'21','2',71845.45,73765.80,1920.35,1593890.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','102',2850,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','102',2851,'23','2',180578.03,181950.37,1372.34,1139042.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','102',2852,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','102',2853,'25','3',45037.60,45594.51,546.91,410181.75,0.00,0.00,10.00,0.00,0.00),('21','221','5','102',2854,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','102',2855,'27','3',2861.58,2861.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','102',2856,'28','1',3918677.18,3921450.40,2773.22,457581.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','103',2857,'1','1',4684637.30,4686644.07,2006.77,331117.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','103',2858,'2','1',5215293.14,5217286.16,1993.02,328848.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','103',2859,'3','1',4386568.81,4389377.96,2809.15,463509.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','103',2860,'4','1',5689213.24,5692585.69,3372.45,556454.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','103',2861,'5','1',3954845.19,3958763.84,3918.65,646577.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','103',2862,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','103',2863,'7','1',2401438.56,2403477.18,2038.62,336372.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','103',2864,'8','1',3379555.29,3382823.13,3267.84,539193.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','103',2865,'9','1',5353554.98,5356676.09,3071.11,506733.15,0.00,0.00,50.00,0.00,0.00),('21','221','2','103',2866,'10','1',3579572.13,3585339.73,5767.60,951654.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','103',2867,'11','1',4577440.08,4579424.15,1984.07,327371.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','103',2868,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','103',2869,'13','1',4468442.56,4471345.21,2902.65,478937.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','103',2870,'14','1',3447860.14,3449944.03,2083.89,343841.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','103',2871,'15','1',4096685.00,4099210.59,2525.59,416722.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','103',2872,'16','1',3403016.81,3404606.56,1589.75,262308.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','103',2873,'17','1',3786213.82,3788622.07,2408.25,397361.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','103',2874,'18','1',3473691.09,3476928.35,3237.26,534147.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','103',2875,'19','1',4211979.01,4213506.69,1527.68,252067.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','103',2876,'20','2',2297553.51,2299015.40,1461.89,1213368.70,0.00,0.00,0.00,0.00,0.00),('21','221','4','103',2877,'21','2',73765.80,76120.83,2355.03,1954674.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','103',2878,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','103',2879,'23','2',181950.37,189665.70,7715.33,6403723.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','103',2880,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','103',2881,'25','3',45594.51,46317.85,713.34,535007.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','103',2882,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','103',2883,'27','3',2861.58,2861.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','103',2884,'28','1',3921450.40,3925372.84,3922.44,647202.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','104',2885,'1','1',4686644.07,4690005.91,3311.84,546453.60,0.00,0.00,50.00,0.00,0.00),('21','221','1','104',2886,'2','1',5217286.16,5219935.46,2649.30,437134.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','104',2887,'3','1',4389377.96,4392145.80,2767.84,456693.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','104',2888,'4','1',5692585.69,5695898.11,3312.42,546549.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','104',2889,'5','1',3958763.84,3962603.90,3840.06,633609.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','104',2890,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','104',2891,'7','1',2403477.18,2406018.94,2541.76,419390.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','104',2892,'8','1',3382823.13,3385105.10,2281.97,376525.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','104',2893,'9','1',5356676.09,5359324.61,2648.52,437005.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','104',2894,'10','1',3585339.73,3591229.10,5889.37,971746.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','104',2895,'11','1',4579424.15,4582549.79,3125.64,515730.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','104',2896,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','104',2897,'13','1',4471345.21,4473666.38,2321.17,382993.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','104',2898,'14','1',3449944.03,3451891.90,1947.87,321398.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','104',2899,'15','1',4099210.59,4100806.26,1595.67,263285.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','104',2900,'16','1',3404606.56,3407360.92,2754.36,454469.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','104',2901,'17','1',3788622.07,3790920.33,2298.26,379212.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','104',2902,'18','1',3476928.35,3479466.08,2537.73,418725.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','104',2903,'19','1',4213506.69,4215848.15,2341.46,386340.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','104',2904,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','104',2905,'21','2',76120.83,77149.80,1028.97,854045.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','104',2906,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','104',2907,'23','2',189665.70,195419.32,5753.62,4775504.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','104',2908,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','104',2909,'25','3',46317.85,46743.52,415.67,311755.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','104',2910,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','104',2911,'27','3',2861.58,3376.17,514.59,385942.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','104',2912,'28','1',3925372.84,3927578.00,2205.16,363851.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','105',2913,'1','1',4690005.91,4692771.45,2765.54,456314.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','105',2914,'2','1',5219935.46,5222195.64,2260.18,372929.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','105',2915,'3','1',4392145.80,4394620.98,2475.18,408404.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','105',2916,'4','1',5695898.11,5699001.46,3103.35,512052.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','105',2917,'5','1',3962603.90,3966557.20,3953.30,652294.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','105',2918,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','105',2919,'7','1',2406018.94,2407963.89,1944.95,320916.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','105',2920,'8','1',3385105.10,3387300.82,2195.72,362293.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','105',2921,'9','1',5359324.61,5361988.55,2623.94,432950.10,0.00,0.00,40.00,0.00,0.00),('21','221','2','105',2922,'10','1',3591229.10,3595937.10,4708.00,776820.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','105',2923,'11','1',4582549.79,4585109.89,2560.10,422416.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','105',2924,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','105',2925,'13','1',4473666.38,4476049.47,2383.09,393209.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','105',2926,'14','1',3451891.90,3454011.99,2120.09,349814.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','105',2927,'15','1',4100806.26,4103312.04,2505.78,413453.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','105',2928,'16','1',3407360.92,3409593.03,2232.11,368298.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','105',2929,'17','1',3790920.33,3793833.27,2912.94,480635.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','105',2930,'18','1',3479466.08,3482748.96,3282.88,541675.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','105',2931,'19','1',4215848.15,4217507.25,1659.10,273751.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','105',2932,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','105',2933,'21','2',77149.80,79199.13,2049.33,1700943.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','105',2934,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','105',2935,'23','2',195419.32,199929.55,4510.23,3743490.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','105',2936,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','105',2937,'25','3',46743.52,47465.83,712.31,534235.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','105',2938,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','105',2939,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','105',2940,'28','1',3927578.00,3931540.59,3962.59,653827.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','106',2941,'1','1',4692771.45,4695114.55,2343.10,386611.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','106',2942,'2','1',5222195.64,5224389.16,2193.52,361930.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','106',2943,'3','1',4394620.98,4396959.42,2338.44,385842.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','106',2944,'4','1',5699001.46,5702117.17,3115.71,514092.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','106',2945,'5','1',3966557.20,3970224.96,3667.76,605180.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','106',2946,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','106',2947,'7','1',2407963.89,2410466.88,2502.99,412993.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','106',2948,'8','1',3387300.82,3389818.07,2517.25,415346.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','106',2949,'9','1',5361988.55,5363740.10,1711.55,282405.75,0.00,0.00,40.00,0.00,0.00),('21','221','2','106',2950,'10','1',3595937.10,3600504.74,4567.64,753660.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','106',2951,'11','1',4585109.89,4588041.83,2931.94,483770.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','106',2952,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','106',2953,'13','1',4476049.47,4478499.59,2450.12,404269.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','106',2954,'14','1',3454011.99,3455698.71,1686.72,278308.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','106',2955,'15','1',4103312.04,4105315.74,2003.70,330610.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','106',2956,'16','1',3409593.03,3411560.36,1967.33,324609.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','106',2957,'17','1',3793833.27,3796540.12,2706.85,446630.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','106',2958,'18','1',3482748.96,3485245.07,2496.11,411858.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','106',2959,'19','1',4217507.25,4218791.91,1284.66,211968.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','106',2960,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','106',2961,'21','2',79199.13,83239.19,4040.06,3353249.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','106',2962,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','106',2963,'23','2',199929.55,205791.19,5861.64,4865161.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','106',2964,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','106',2965,'25','3',47465.83,48085.97,610.14,457603.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','106',2966,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','106',2967,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','106',2968,'28','1',3931540.59,3934936.61,3396.02,560343.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','107',2969,'1','1',4695114.55,4699034.64,3920.09,646814.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','107',2970,'2','1',5224389.16,5226451.80,2062.64,340335.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','107',2971,'3','1',4396959.42,4399248.55,2289.13,377706.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','107',2972,'4','1',5702117.17,5706328.33,4211.16,694841.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','107',2973,'5','1',3970224.96,3974813.14,4588.18,757049.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','107',2974,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','107',2975,'7','1',2410466.88,2412698.97,2232.09,368294.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','107',2976,'8','1',3389818.07,3394340.66,4522.59,746227.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','107',2977,'9','1',5363740.10,5366265.22,2475.12,408394.80,0.00,0.00,50.00,0.00,0.00),('21','221','2','107',2978,'10','1',3600504.74,3607170.48,6665.74,1099847.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','107',2979,'11','1',4588041.83,4591365.78,3323.95,548451.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','107',2980,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','107',2981,'13','1',4478499.59,4481338.75,2839.16,468461.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','107',2982,'14','1',3455698.71,3457689.38,1990.67,328460.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','107',2983,'15','1',4105315.74,4108399.85,3084.11,508878.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','107',2984,'16','1',3411560.36,3413408.98,1848.62,305022.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','107',2985,'17','1',3796540.12,3799283.27,2743.15,452619.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','107',2986,'18','1',3485245.07,3488543.94,3298.87,544313.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','107',2987,'19','1',4218791.91,4221277.36,2485.45,410099.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','107',2988,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','107',2989,'21','2',83239.19,86571.26,3332.07,2765618.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','107',2990,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','107',2991,'23','2',205791.19,208247.63,2456.44,2038845.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','107',2992,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','107',2993,'25','3',48085.97,48683.45,587.48,440608.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','107',2994,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','107',2995,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','107',2996,'28','1',3934936.61,3939152.89,4216.28,695686.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','108',2997,'1','1',4699034.64,4700700.17,1665.53,274812.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','108',2998,'2','1',5226451.80,5228248.43,1796.63,296443.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','108',2999,'3','1',4399248.55,4400638.41,1389.86,229326.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','108',3000,'4','1',5706328.33,5708055.41,1727.08,284968.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','108',3001,'5','1',3974813.14,3976742.45,1929.31,318336.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','108',3002,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','108',3003,'7','1',2412698.97,2414262.77,1563.80,258027.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','108',3004,'8','1',3394340.66,3395865.30,1524.64,251565.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','108',3005,'9','1',5366265.22,5368284.36,1969.14,324908.10,0.00,0.00,50.00,0.00,0.00),('21','221','2','108',3006,'10','1',3607170.48,3609601.02,2430.54,401039.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','108',3007,'11','1',4591365.78,4592886.56,1520.78,250928.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','108',3008,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','108',3009,'13','1',4481338.75,4482828.76,1490.01,245851.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','108',3010,'14','1',3457689.38,3458988.63,1299.25,214376.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','108',3011,'15','1',4108399.85,4110256.48,1856.63,306343.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','108',3012,'16','1',3413408.98,3414764.06,1355.08,223588.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','108',3013,'17','1',3799283.27,3801058.01,1774.74,292832.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','108',3014,'18','1',3488543.94,3491094.25,2550.31,420801.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','108',3015,'19','1',4221277.36,4222404.03,1126.67,185900.55,0.00,0.00,0.00,0.00,0.00),('21','221','4','108',3016,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','108',3017,'21','2',86571.26,92252.97,5681.71,4715819.30,0.00,0.00,0.00,0.00,0.00),('21','221','4','108',3018,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','108',3019,'23','2',208247.63,212510.64,4263.01,3538298.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','108',3020,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','108',3021,'25','3',48683.45,49439.14,735.69,551768.25,0.00,0.00,20.00,0.00,0.00),('21','221','5','108',3022,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','108',3023,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','108',3024,'28','1',3939152.89,3940685.35,1532.46,252855.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','109',3025,'1','1',4700700.17,4704526.91,3826.74,631412.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','109',3026,'2','1',5228248.43,5231323.52,3075.09,507389.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','109',3027,'3','1',4400638.41,4403402.56,2764.15,456084.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','109',3028,'4','1',5708055.41,5711410.50,3355.09,553589.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','109',3029,'5','1',3976742.45,3982272.52,5530.07,912461.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','109',3030,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','109',3031,'7','1',2414262.77,2417866.59,3603.82,594630.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','109',3032,'8','1',3395865.30,3400568.11,4652.81,767713.65,0.00,0.00,50.00,0.00,0.00),('21','221','2','109',3033,'9','1',5368284.36,5371360.49,3076.13,507561.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','109',3034,'10','1',3609601.02,3615405.88,5804.86,957801.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','109',3035,'11','1',4592886.56,4596475.61,3589.05,592193.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','109',3036,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','109',3037,'13','1',4482828.76,4485469.48,2640.72,435718.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','109',3038,'14','1',3458988.63,3461378.87,2390.24,394389.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','109',3039,'15','1',4110256.48,4112932.86,2676.38,441602.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','109',3040,'16','1',3414764.06,3417487.31,2723.25,449336.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','109',3041,'17','1',3801058.01,3804613.18,3555.17,586603.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','109',3042,'18','1',3491094.25,3494878.32,3784.07,624371.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','109',3043,'19','1',4222404.03,4225426.63,3022.60,498729.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','109',3044,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','109',3045,'21','2',92252.97,95222.97,2970.00,2465100.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','109',3046,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','109',3047,'23','2',212510.64,213773.01,1262.37,1047767.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','109',3048,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','109',3049,'25','3',49439.14,50023.20,584.06,438048.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','109',3050,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','109',3051,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','109',3052,'28','1',3940685.35,3944793.69,4108.34,677876.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','110',3053,'1','1',4704526.91,4706780.42,2253.51,371829.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','110',3054,'2','1',5231323.52,5234318.28,2994.76,494135.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','110',3055,'3','1',4403402.56,4405693.00,2290.44,377922.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','110',3056,'4','1',5711410.50,5713831.42,2420.92,399451.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','110',3057,'5','1',3982272.52,3985790.34,3517.82,580440.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','110',3058,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','110',3059,'7','1',2417866.59,2420549.83,2683.24,442734.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','110',3060,'8','1',3400568.11,3403997.71,3429.60,565884.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','110',3061,'9','1',5371360.49,5374094.85,2684.36,442919.40,0.00,0.00,50.00,0.00,0.00),('21','221','2','110',3062,'10','1',3615405.88,3619576.22,4170.34,688106.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','110',3063,'11','1',4596475.61,4598413.13,1937.52,319690.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','110',3064,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','110',3065,'13','1',4485469.48,4487313.34,1843.86,304236.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','110',3066,'14','1',3461378.87,3463506.94,2128.07,351131.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','110',3067,'15','1',4112932.86,4116058.51,3125.65,515732.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','110',3068,'16','1',3417487.31,3419688.99,2201.68,363277.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','110',3069,'17','1',3804613.18,3806518.67,1905.49,314405.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','110',3070,'18','1',3494878.32,3497813.10,2934.78,484238.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','110',3071,'19','1',4225426.63,4227585.14,2158.51,356154.15,0.00,0.00,0.00,0.00,0.00),('21','221','4','110',3072,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','110',3073,'21','2',95222.97,98620.67,3397.70,2820091.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','110',3074,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','110',3075,'23','2',213773.01,218804.73,5031.72,4176327.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','110',3076,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','110',3077,'25','3',50023.20,50819.44,776.24,582176.25,0.00,0.00,20.00,0.00,0.00),('21','221','5','110',3078,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','110',3079,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','110',3080,'28','1',3944793.69,3949847.85,5054.16,833936.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','111',3081,'1','1',4706780.42,4709587.81,2807.39,463219.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','111',3082,'2','1',5234318.28,5237065.85,2747.57,453349.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','111',3083,'3','1',4405693.00,4408406.19,2713.19,447676.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','111',3084,'4','1',5713831.42,5716423.93,2592.51,427764.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','111',3085,'5','1',3985790.34,3989085.66,3295.32,543727.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','111',3086,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','111',3087,'7','1',2420549.83,2422477.37,1927.54,318044.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','111',3088,'8','1',3403997.71,3407920.94,3923.23,647332.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','111',3089,'9','1',5374094.85,5376956.85,2812.00,463980.00,0.00,0.00,50.00,0.00,0.00),('21','221','2','111',3090,'10','1',3619576.22,3623963.31,4387.09,723869.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','111',3091,'11','1',4598413.13,4601217.15,2804.02,462663.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','111',3092,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','111',3093,'13','1',4487313.34,4489075.18,1761.84,290703.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','111',3094,'14','1',3463506.94,3464653.52,1146.58,189185.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','111',3095,'15','1',4116058.51,4117938.55,1880.04,310206.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','111',3096,'16','1',3419688.99,3421185.15,1496.16,246866.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','111',3097,'17','1',3806518.67,3808393.55,1874.88,309355.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','111',3098,'18','1',3497813.10,3500944.42,3131.32,516667.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','111',3099,'19','1',4227585.14,4229110.93,1525.79,251755.35,0.00,0.00,0.00,0.00,0.00),('21','221','4','111',3100,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','111',3101,'21','2',98620.67,104173.42,5552.75,4608782.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','111',3102,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','111',3103,'23','2',218804.73,223745.58,4940.85,4100905.50,0.00,0.00,0.00,0.00,0.00),('21','221','5','111',3104,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','111',3105,'25','3',50819.44,51551.45,712.01,534010.50,0.00,0.00,20.00,0.00,0.00),('21','221','5','111',3106,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','111',3107,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','111',3108,'28','1',3949847.85,3953266.00,3418.15,563994.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','112',3109,'1','1',4709587.81,4711935.35,2347.54,387344.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','112',3110,'2','1',5237065.85,5239928.16,2862.31,472281.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','112',3111,'3','1',4408406.19,4410857.91,2451.72,404533.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','112',3112,'4','1',5716423.93,5719194.31,2770.38,457112.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','112',3113,'5','1',3989085.66,3992805.47,3719.81,613768.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','112',3114,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','112',3115,'7','1',2422477.37,2424094.46,1567.09,258569.85,0.00,0.00,50.00,0.00,0.00),('21','221','2','112',3116,'8','1',3407920.94,3412553.50,4632.56,764372.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','112',3117,'9','1',5376956.85,5379906.01,2949.16,486611.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','112',3118,'10','1',3623963.31,3628657.44,4694.13,774531.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','112',3119,'11','1',4601217.15,4603447.13,2229.98,367946.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','112',3120,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','112',3121,'13','1',4489075.18,4490928.95,1853.77,305872.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','112',3122,'14','1',3464653.52,3465928.78,1275.26,210417.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','112',3123,'15','1',4117938.55,4119480.51,1541.96,254423.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','112',3124,'16','1',3421185.15,3423108.65,1923.50,317377.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','112',3125,'17','1',3808393.55,3810843.14,2449.59,404182.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','112',3126,'18','1',3500944.42,3504574.31,3629.89,598931.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','112',3127,'19','1',4229110.93,4230288.36,1177.43,194275.95,0.00,0.00,0.00,0.00,0.00),('21','221','4','112',3128,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','112',3129,'21','2',104173.42,108310.39,4136.97,3433685.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','112',3130,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','112',3131,'23','2',223745.58,228672.19,4926.61,4089086.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','112',3132,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','112',3133,'25','3',51551.45,52098.34,536.89,402667.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','112',3134,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','112',3135,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','112',3136,'28','1',3953266.00,3959383.62,6117.62,1009407.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','113',3137,'1','1',4711935.35,4717157.55,5222.20,861663.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','113',3138,'2','1',5239928.16,5242455.51,2527.35,417012.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','113',3139,'3','1',4410857.91,4415058.46,4200.55,693090.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','113',3140,'4','1',5719194.31,5723812.42,4618.11,761988.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','113',3141,'5','1',3992805.47,3996139.78,3334.31,550161.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','113',3142,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','113',3143,'7','1',2424094.46,2426007.42,1912.96,315638.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','113',3144,'8','1',3412553.50,3417477.51,4924.01,812461.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','113',3145,'9','1',5379906.01,5382540.99,2584.98,426521.70,0.00,0.00,50.00,0.00,0.00),('21','221','2','113',3146,'10','1',3628657.44,3632984.65,4327.21,713989.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','113',3147,'11','1',4603447.13,4606484.60,3037.47,501182.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','113',3148,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','113',3149,'13','1',4490928.95,4494435.94,3506.99,578653.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','113',3150,'14','1',3465928.78,3468391.26,2462.48,406309.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','113',3151,'15','1',4119480.51,4122710.72,3230.21,532984.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','113',3152,'16','1',3423108.65,3425741.73,2633.08,434458.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','113',3153,'17','1',3810843.14,3815611.76,4768.62,786822.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','113',3154,'18','1',3504574.31,3512291.85,7717.54,1273394.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','113',3155,'19','1',4230288.36,4231950.37,1662.01,274231.65,0.00,0.00,0.00,0.00,0.00),('21','221','4','113',3156,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','113',3157,'21','2',108310.39,112941.53,4631.14,3843846.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','113',3158,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','113',3159,'23','2',228672.19,233744.22,5072.03,4209784.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','113',3160,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','113',3161,'25','3',52098.34,52853.88,745.54,559157.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','113',3162,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','113',3163,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','113',3164,'28','1',3959383.62,3963965.92,4582.30,756079.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','114',3165,'1','1',4717157.55,4719538.80,2381.25,392906.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','114',3166,'2','1',5242455.51,5245328.14,2872.63,473983.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','114',3167,'3','1',4415058.46,4417749.61,2691.15,444039.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','114',3168,'4','1',5723812.42,5726692.34,2879.92,475186.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','114',3169,'5','1',3996139.78,3997802.82,1663.04,274401.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','114',3170,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','114',3171,'7','1',2426007.42,2427081.47,1074.05,177218.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','114',3172,'8','1',3417477.51,3419891.26,2413.75,398268.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','114',3173,'9','1',5382540.99,5383810.59,1219.60,201234.00,0.00,0.00,50.00,0.00,0.00),('21','221','2','114',3174,'10','1',3632984.65,3636110.46,3125.81,515758.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','114',3175,'11','1',4606484.60,4608449.76,1965.16,324251.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','114',3176,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','114',3177,'13','1',4494435.94,4496237.57,1801.63,297268.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','114',3178,'14','1',3468391.26,3469968.00,1576.74,260162.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','114',3179,'15','1',4122710.72,4124433.73,1723.01,284296.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','114',3180,'16','1',3425741.73,3428199.73,2458.00,405570.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','114',3181,'17','1',3815611.76,3817212.69,1600.93,264153.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','114',3182,'18','1',3512291.85,3515974.37,3682.52,607615.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','114',3183,'19','1',4231950.37,4233617.43,1667.06,275064.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','114',3184,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','114',3185,'21','2',112941.53,114944.35,2002.82,1662340.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','114',3186,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','114',3187,'23','2',233744.22,241336.25,7592.03,6301384.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','114',3188,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','114',3189,'25','3',52853.88,53522.71,658.83,494123.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','114',3190,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','114',3191,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','114',3192,'28','1',3963965.92,3968837.55,4871.63,803818.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','115',3193,'1','1',4719538.80,4722288.18,2749.38,453647.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','115',3194,'2','1',5245328.14,5248068.31,2740.17,452128.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','115',3195,'3','1',4417749.61,4420518.13,2768.52,456805.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','115',3196,'4','1',5726692.34,5729495.42,2803.08,462508.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','115',3197,'5','1',3997802.82,4001075.19,3272.37,539941.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','115',3198,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','115',3199,'7','1',2427081.47,2428377.30,1295.83,213811.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','115',3200,'8','1',3419891.26,3423955.14,4063.88,670540.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','115',3201,'9','1',5383810.59,5386219.98,2359.39,389299.35,0.00,0.00,50.00,0.00,0.00),('21','221','2','115',3202,'10','1',3636110.46,3639793.85,3683.39,607759.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','115',3203,'11','1',4608449.76,4610599.86,2150.10,354766.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','115',3204,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','115',3205,'13','1',4496237.57,4497588.19,1350.62,222852.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','115',3206,'14','1',3469968.00,3471936.77,1968.77,324847.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','115',3207,'15','1',4124433.73,4126052.76,1619.03,267139.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','115',3208,'16','1',3428199.73,3430187.96,1988.23,328057.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','115',3209,'17','1',3817212.69,3819274.74,2062.05,340238.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','115',3210,'18','1',3515974.37,3520751.37,4777.00,788205.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','115',3211,'19','1',4233617.43,4236068.55,2451.12,404434.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','115',3212,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','115',3213,'21','2',114944.35,119074.40,4130.05,3427941.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','115',3214,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','115',3215,'23','2',241336.25,246955.07,5618.82,4663620.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','115',3216,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','115',3217,'25','3',53522.71,54441.11,908.40,681297.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','115',3218,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','115',3219,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','115',3220,'28','1',3968837.55,3974587.37,5749.82,948720.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','116',3221,'1','1',4722288.18,4723764.26,1476.08,243553.20,0.00,0.00,0.00,0.00,0.00),('21','221','1','116',3222,'2','1',5248068.31,5249832.74,1764.43,291130.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','116',3223,'3','1',4420518.13,4422108.93,1590.80,262482.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','116',3224,'4','1',5729495.42,5731153.85,1658.43,273640.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','116',3225,'5','1',4001075.19,4003883.43,2808.24,463359.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','116',3226,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','116',3227,'7','1',2428377.30,2429933.26,1555.96,256733.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','116',3228,'8','1',3423955.14,3428144.97,4189.83,691321.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','116',3229,'9','1',5386219.98,5388895.08,2625.10,433141.50,0.00,0.00,50.00,0.00,0.00),('21','221','2','116',3230,'10','1',3639793.85,3643453.73,3659.88,603880.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','116',3231,'11','1',4610599.86,4613038.28,2438.42,402339.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','116',3232,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','116',3233,'13','1',4497588.19,4499564.03,1975.84,326013.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','116',3234,'14','1',3471936.77,3473575.49,1638.72,270388.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','116',3235,'15','1',4126052.76,4128277.89,2225.13,367146.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','116',3236,'16','1',3430187.96,3432678.91,2490.95,411006.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','116',3237,'17','1',3819274.74,3822903.11,3628.37,598681.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','116',3238,'18','1',3520751.37,3524512.98,3761.61,620665.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','116',3239,'19','1',4236068.55,4239414.42,3345.87,552068.55,0.00,0.00,0.00,0.00,0.00),('21','221','4','116',3240,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','116',3241,'21','2',119074.40,122819.57,3745.17,3108491.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','116',3242,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','116',3243,'23','2',246955.07,257979.04,11023.97,9149895.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','116',3244,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','116',3245,'25','3',54441.11,55156.99,705.88,529407.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','116',3246,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','116',3247,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','116',3248,'28','1',3974587.37,3979178.33,4590.96,757508.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','117',3249,'1','1',4723764.26,4725861.69,2047.43,337825.95,0.00,0.00,50.00,0.00,0.00),('21','221','1','117',3250,'2','1',5249832.74,5252899.40,3066.66,505998.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','117',3251,'3','1',4422108.93,4424901.95,2793.02,460848.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','117',3252,'4','1',5731153.85,5733575.82,2421.97,399625.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','117',3253,'5','1',4003883.43,4010406.11,6522.68,1076242.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','117',3254,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','117',3255,'7','1',2429933.26,2433346.47,3413.21,563179.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','117',3256,'8','1',3428144.97,3431746.56,3601.59,594262.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','117',3257,'9','1',5388895.08,5393220.42,4325.34,713681.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','117',3258,'10','1',3643453.73,3651475.06,8021.33,1323519.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','117',3259,'11','1',4613038.28,4616273.29,3235.01,533776.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','117',3260,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','117',3261,'13','1',4499564.03,4504034.34,4470.31,737601.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','117',3262,'14','1',3473575.49,3477374.43,3798.94,626825.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','117',3263,'15','1',4128277.89,4131400.55,3122.66,515238.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','117',3264,'16','1',3432678.91,3436647.67,3968.76,654845.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','117',3265,'17','1',3822903.11,3828453.70,5550.59,915847.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','117',3266,'18','1',3524512.98,3528763.20,4250.22,701286.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','117',3267,'19','1',4239414.42,4244845.55,5431.13,896136.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','117',3268,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','117',3269,'21','2',122819.57,127263.94,4444.37,3688827.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','117',3270,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','117',3271,'23','2',257979.04,262267.20,4288.16,3559172.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','117',3272,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','117',3273,'25','3',55156.99,56032.99,866.00,649501.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','117',3274,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','117',3275,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','117',3276,'28','1',3979178.33,3985823.56,6645.23,1096462.95,0.00,0.00,0.00,0.00,0.00),('21','221','1','118',3277,'1','1',4725861.69,4725861.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','118',3278,'2','1',5252899.40,5270570.78,17671.38,2915777.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','118',3279,'3','1',4424901.95,4424901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','118',3280,'4','1',5733575.82,5743476.69,9900.87,1633643.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','118',3281,'5','1',4010406.11,4016155.67,5749.56,948677.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','118',3282,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','118',3283,'7','1',2433346.47,2435139.18,1792.71,295797.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','118',3284,'8','1',3431746.56,3433370.52,1623.96,267953.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','118',3285,'9','1',5393220.42,5395472.46,2202.04,363336.60,0.00,0.00,50.00,0.00,0.00),('21','221','2','118',3286,'10','1',3651475.06,3655073.84,3598.78,593798.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','118',3287,'11','1',4616273.29,4618674.27,2400.98,396161.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','118',3288,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','118',3289,'13','1',4504034.34,4507611.98,3577.64,590310.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','118',3290,'14','1',3477374.43,3479240.55,1866.12,307909.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','118',3291,'15','1',4131400.55,4134314.46,2913.91,480795.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','118',3292,'16','1',3436647.67,3438997.48,2349.81,387718.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','118',3293,'17','1',3828453.70,3831079.34,2625.64,433230.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','118',3294,'18','1',3528763.20,3532203.95,3440.75,567723.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','118',3295,'19','1',4244845.55,4247198.48,2352.93,388233.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','118',3296,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','118',3297,'21','2',127263.94,130520.38,3256.44,2702845.20,0.00,0.00,0.00,0.00,0.00),('21','221','4','118',3298,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','118',3299,'23','2',262267.20,268083.82,5816.62,4827794.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','118',3300,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','118',3301,'25','3',56032.99,56602.02,559.03,419275.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','118',3302,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','118',3303,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','118',3304,'28','1',3985823.56,3989701.41,3877.85,639845.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','119',3305,'1','1',4725861.69,4725861.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','119',3306,'2','1',5270570.78,5270570.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','119',3307,'3','1',4424901.95,4424901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','119',3308,'4','1',5743476.69,5743476.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','119',3309,'5','1',4016155.67,4023881.48,7725.81,1274758.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','119',3310,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','119',3311,'7','1',2435139.18,2438638.00,3498.82,577305.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','119',3312,'8','1',3433370.52,3436896.51,3525.99,581788.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','119',3313,'9','1',5395472.46,5400200.97,4678.51,771954.15,0.00,0.00,50.00,0.00,0.00),('21','221','2','119',3314,'10','1',3655073.84,3662989.00,7915.16,1306001.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','119',3315,'11','1',4618674.27,4623309.96,4635.69,764888.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','119',3316,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','119',3317,'13','1',4507611.98,4510746.00,3134.02,517113.30,0.00,0.00,0.00,0.00,0.00),('21','221','3','119',3318,'14','1',3479240.55,3482364.23,3123.68,515407.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','119',3319,'15','1',4134314.46,4137595.70,3281.24,541404.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','119',3320,'16','1',3438997.48,3442830.00,3832.52,632365.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','119',3321,'17','1',3831079.34,3833702.20,2622.86,432771.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','119',3322,'18','1',3532203.95,3535399.00,3195.05,527183.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','119',3323,'19','1',4247198.48,4250921.10,3722.62,614232.30,0.00,0.00,0.00,0.00,0.00),('21','221','4','119',3324,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','119',3325,'21','2',130520.38,133135.21,2614.83,2170308.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','119',3326,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','119',3327,'23','2',268083.82,271995.39,3911.57,3246603.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','119',3328,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','119',3329,'25','3',56602.02,57335.87,723.85,542887.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','119',3330,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','119',3331,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','119',3332,'28','1',3989701.41,3995796.85,6095.44,1005747.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','120',3333,'1','1',4725861.69,4725861.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','120',3334,'2','1',5270570.78,5270570.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','120',3335,'3','1',4424901.95,4424901.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','120',3336,'4','1',5743476.69,5743476.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','120',3337,'5','1',4023881.48,4028011.46,4129.98,681446.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','120',3338,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','120',3339,'7','1',2438638.00,2441312.00,2674.00,441210.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','120',3340,'8','1',3436896.51,3440098.01,3201.50,528247.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','120',3341,'9','1',5400200.97,5403236.60,2985.63,492628.95,0.00,0.00,50.00,0.00,0.00),('21','221','2','120',3342,'10','1',3662989.00,3668815.22,5826.22,961326.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','120',3343,'11','1',4623309.96,4627158.57,3848.61,635020.65,0.00,0.00,0.00,0.00,0.00),('21','221','2','120',3344,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','120',3345,'13','1',4510746.00,4513939.54,3193.54,526934.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','120',3346,'14','1',3482364.23,3484770.92,2406.69,397103.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','120',3347,'15','1',4137595.70,4140501.05,2905.35,479382.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','120',3348,'16','1',3442830.00,3444955.83,2125.83,350761.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','120',3349,'17','1',3833702.20,3836697.84,2995.64,494280.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','120',3350,'18','1',3535399.00,3537581.64,2182.64,360135.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','120',3351,'19','1',4250921.10,4254200.94,3279.84,541173.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','120',3352,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','120',3353,'21','2',133135.21,133135.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','120',3354,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','120',3355,'23','2',271995.39,275102.22,3106.83,2578668.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','120',3356,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','120',3357,'25','3',57335.87,58041.77,695.90,521921.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','120',3358,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','120',3359,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','120',3360,'28','1',3995796.85,3999333.56,3536.71,583557.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','121',3361,'1','1',4725861.69,4728188.08,2326.39,383854.35,0.00,0.00,0.00,0.00,0.00),('21','221','1','121',3362,'2','1',5270570.78,5270570.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','121',3363,'3','1',4424901.95,4441566.12,16664.17,2749588.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','121',3364,'4','1',5743476.69,5743476.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','121',3365,'5','1',4028011.46,4039199.18,11187.72,1845973.80,0.00,0.00,0.00,0.00,0.00),('21','221','2','121',3366,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','121',3367,'7','1',2441312.00,2444356.11,3044.11,502278.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','121',3368,'8','1',3440098.01,3444577.98,4479.97,739195.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','121',3369,'9','1',5403236.60,5407538.23,4251.63,701518.95,0.00,0.00,50.00,0.00,0.00),('21','221','2','121',3370,'10','1',3668815.22,3675804.12,6988.90,1153168.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','121',3371,'11','1',4627158.57,4631410.54,4251.97,701575.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','121',3372,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','121',3373,'13','1',4513939.54,4518437.64,4498.10,742186.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','121',3374,'14','1',3484770.92,3488738.31,3967.39,654619.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','121',3375,'15','1',4140501.05,4144621.77,4120.72,679918.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','121',3376,'16','1',3444955.83,3448720.26,3764.43,621130.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','121',3377,'17','1',3836697.84,3842125.42,5427.58,895550.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','121',3378,'18','1',3537581.64,3541633.32,4051.68,668527.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','121',3379,'19','1',4254200.94,4258207.20,4006.26,661032.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','121',3380,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','121',3381,'21','2',133135.21,133135.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','121',3382,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','121',3383,'23','2',275102.22,281087.34,5985.12,4967649.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','121',3384,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','121',3385,'25','3',58041.77,58991.27,939.50,704622.75,0.00,0.00,10.00,0.00,0.00),('21','221','5','121',3386,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','121',3387,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','121',3388,'28','1',3999333.56,4004355.54,5021.98,828626.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','122',3389,'1','1',4728188.08,4730611.74,2423.66,399903.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','122',3390,'2','1',5270570.78,5270570.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','122',3391,'3','1',4441566.12,4443954.01,2387.89,394001.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','122',3392,'4','1',5743476.69,5743476.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','122',3393,'5','1',4039199.18,4040430.40,1231.22,203151.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','122',3394,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','122',3395,'7','1',2444356.11,2445450.18,1094.07,180521.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','122',3396,'8','1',3444577.98,3444577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','122',3397,'9','1',5407538.23,5407538.23,-50.00,-8250.00,0.00,0.00,50.00,0.00,0.00),('21','221','2','122',3398,'10','1',3675804.12,3676936.78,1132.66,186888.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','122',3399,'11','1',4631410.54,4632604.37,1193.83,196981.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','122',3400,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','122',3401,'13','1',4518437.64,4520079.98,1642.34,270986.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','122',3402,'14','1',3488738.31,3490005.77,1267.46,209130.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','122',3403,'15','1',4144621.77,4146490.93,1869.16,308411.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','122',3404,'16','1',3448720.26,3449611.10,890.84,146988.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','122',3405,'17','1',3842125.42,3844081.55,1956.13,322761.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','122',3406,'18','1',3541633.32,3543242.70,1609.38,265547.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','122',3407,'19','1',4258207.20,4259431.55,1224.35,202017.75,0.00,0.00,0.00,0.00,0.00),('21','221','4','122',3408,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','122',3409,'21','2',133135.21,133135.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','122',3410,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','122',3411,'23','2',281087.34,285266.45,4179.11,3468661.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','122',3412,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','122',3413,'25','3',58991.27,59654.22,652.95,489713.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','122',3414,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','122',3415,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','122',3416,'28','1',4004355.54,4006332.44,1976.90,326188.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','123',3417,'1','1',4730611.74,4733611.47,2949.73,486705.45,0.00,0.00,50.00,0.00,0.00),('21','221','1','123',3418,'2','1',5270570.78,5270570.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','123',3419,'3','1',4443954.01,4448231.92,4277.91,705855.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','123',3420,'4','1',5743476.69,5743476.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','123',3421,'5','1',4040430.40,4044599.31,4168.91,687870.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','123',3422,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','123',3423,'7','1',2445450.18,2448245.38,2795.20,461208.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','123',3424,'8','1',3444577.98,3446901.43,2323.45,383369.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','123',3425,'9','1',5407538.23,5410685.10,3146.87,519233.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','123',3426,'10','1',3676936.78,3681664.32,4727.54,780044.10,0.00,0.00,0.00,0.00,0.00),('21','221','2','123',3427,'11','1',4632604.37,4635998.63,3394.26,560052.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','123',3428,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','123',3429,'13','1',4520079.98,4523325.04,3245.06,535434.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','123',3430,'14','1',3490005.77,3492445.07,2439.30,402484.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','123',3431,'15','1',4146490.93,4149964.14,3473.21,573079.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','123',3432,'16','1',3449611.10,3453346.19,3735.09,616289.85,0.00,0.00,0.00,0.00,0.00),('21','221','3','123',3433,'17','1',3844081.55,3847324.60,3243.05,535103.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','123',3434,'18','1',3543242.70,3546814.33,3571.63,589318.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','123',3435,'19','1',4259431.55,4262920.14,3488.59,575617.35,0.00,0.00,0.00,0.00,0.00),('21','221','4','123',3436,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','123',3437,'21','2',133135.21,134657.83,1522.62,1263774.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','123',3438,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','123',3439,'23','2',285266.45,285266.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','123',3440,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','123',3441,'25','3',59654.22,60064.89,400.67,300500.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','123',3442,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','123',3443,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','123',3444,'28','1',4006332.44,4011981.00,5648.56,932012.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','124',3445,'1','1',4733611.47,4733611.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','124',3446,'2','1',5270570.78,5270570.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','124',3447,'3','1',4448231.92,4448244.03,12.11,1998.15,0.00,0.00,0.00,0.00,0.00),('21','221','1','124',3448,'4','1',5743476.69,5743476.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','124',3449,'5','1',4044599.31,4053454.58,8855.27,1461119.55,0.00,0.00,0.00,0.00,0.00),('21','221','2','124',3450,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','124',3451,'7','1',2448245.38,2451176.62,2931.24,483654.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','124',3452,'8','1',3446901.43,3449365.42,2463.99,406558.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','124',3453,'9','1',5410685.10,5414350.56,3615.46,596550.90,0.00,0.00,50.00,0.00,0.00),('21','221','2','124',3454,'10','1',3681664.32,3688370.83,6706.51,1106574.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','124',3455,'11','1',4635998.63,4641724.65,5726.02,944793.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','124',3456,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','124',3457,'13','1',4523325.04,4528135.81,4810.77,793777.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','124',3458,'14','1',3492445.07,3494839.90,2394.83,395146.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','124',3459,'15','1',4149964.14,4154729.82,4765.68,786337.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','124',3460,'16','1',3453346.19,3456637.49,3291.30,543064.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','124',3461,'17','1',3847324.60,3850979.27,3654.67,603020.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','124',3462,'18','1',3546814.33,3551054.07,4239.74,699557.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','124',3463,'19','1',4262920.14,4266167.19,3247.05,535763.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','124',3464,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','124',3465,'21','2',134657.83,134657.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','124',3466,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','124',3467,'23','2',285266.45,288238.78,2972.33,2467033.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','124',3468,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','124',3469,'25','3',60064.89,60788.03,713.14,534855.75,0.00,0.00,10.00,0.00,0.00),('21','221','5','124',3470,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','124',3471,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','124',3472,'28','1',4011981.00,4016187.27,4206.27,694034.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','125',3473,'1','1',4733611.47,4741260.02,7648.55,1414981.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','125',3474,'2','1',5270570.78,5270570.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','125',3475,'3','1',4448244.03,4454727.60,6483.57,1199460.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','125',3476,'4','1',5743476.69,5743476.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','125',3477,'5','1',4053454.58,4060977.50,7522.92,1391740.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','125',3478,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','125',3479,'7','1',2451176.62,2454967.00,3790.38,701220.30,0.00,0.00,0.00,0.00,0.00),('21','221','2','125',3480,'8','1',3449365.42,3453317.42,3952.00,731120.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','125',3481,'9','1',5414350.56,5419712.11,5311.55,982636.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','125',3482,'10','1',3688370.83,3696368.75,7997.92,1479615.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','125',3483,'11','1',4641724.65,4646463.36,4738.71,876661.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','125',3484,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','125',3485,'13','1',4528135.81,4531279.46,3143.65,581575.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','125',3486,'14','1',3494839.90,3499611.44,4771.54,882734.90,0.00,0.00,0.00,0.00,0.00),('21','221','3','125',3487,'15','1',4154729.82,4158607.74,3877.92,717415.20,0.00,0.00,0.00,0.00,0.00),('21','221','3','125',3488,'16','1',3456637.49,3460715.57,4078.08,754444.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','125',3489,'17','1',3850979.27,3854898.78,3919.51,725109.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','125',3490,'18','1',3551054.07,3555139.14,4085.07,755737.95,0.00,0.00,0.00,0.00,0.00),('21','221','3','125',3491,'19','1',4266167.19,4270681.53,4514.34,835152.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','125',3492,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','125',3493,'21','2',134657.83,134657.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','125',3494,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','125',3495,'23','2',288238.78,292321.60,4082.82,3388740.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','125',3496,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','125',3497,'25','3',60788.03,61357.06,559.03,419274.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','125',3498,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','125',3499,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','125',3500,'28','1',4016187.27,4022299.81,6112.54,1130819.90,0.00,0.00,0.00,0.00,0.00),('21','221','1','126',3501,'1','1',4741260.02,4752928.56,11668.54,1925309.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','126',3502,'2','1',5270570.78,5281295.23,10724.45,1769534.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','126',3503,'3','1',4454727.60,4465569.38,10841.78,1788893.70,0.00,0.00,0.00,0.00,0.00),('21','221','1','126',3504,'4','1',5743476.69,5753500.67,9973.98,1645706.70,0.00,0.00,50.00,0.00,0.00),('21','221','2','126',3505,'5','1',4060977.50,4068930.33,7952.83,1312216.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','126',3506,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','126',3507,'7','1',2454967.00,2459168.03,4201.03,693169.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','126',3508,'8','1',3453317.42,3456909.91,3592.49,592760.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','126',3509,'9','1',5419712.11,5424206.04,4493.93,741498.45,0.00,0.00,0.00,0.00,0.00),('21','221','2','126',3510,'10','1',3696368.75,3703594.75,7226.00,1192290.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','126',3511,'11','1',4646463.36,4650792.33,4328.97,714280.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','126',3512,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','126',3513,'13','1',4531279.46,4535054.57,3775.11,622893.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','126',3514,'14','1',3499611.44,3502842.81,3231.37,533176.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','126',3515,'15','1',4158607.74,4162841.48,4233.74,698567.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','126',3516,'16','1',3460715.57,3463582.82,2867.25,473096.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','126',3517,'17','1',3854898.78,3858064.76,3165.98,522386.70,0.00,0.00,0.00,0.00,0.00),('21','221','3','126',3518,'18','1',3555139.14,3559449.90,4310.76,711275.40,0.00,0.00,0.00,0.00,0.00),('21','221','3','126',3519,'19','1',4270681.53,4275216.59,4535.06,748284.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','126',3520,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','126',3521,'21','2',134657.83,134657.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','126',3522,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','126',3523,'23','2',292321.60,296553.11,4231.51,3512153.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','126',3524,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','126',3525,'25','3',61357.06,62039.58,672.52,504391.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','126',3526,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','126',3527,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','126',3528,'28','1',4022299.81,4025536.33,3236.52,534025.80,0.00,0.00,0.00,0.00,0.00),('21','221','1','127',3529,'1','1',4752928.56,4760037.53,7108.97,1172980.05,0.00,0.00,0.00,0.00,0.00),('21','221','1','127',3530,'2','1',5281295.23,5304674.23,23379.00,3857535.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','127',3531,'3','1',4465569.38,4470297.65,4728.27,780164.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','127',3532,'4','1',5753500.67,5759500.67,6000.00,990000.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','127',3533,'5','1',4068930.33,4074687.29,5756.96,949898.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','127',3534,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','127',3535,'7','1',2459168.03,2462995.71,3827.68,631567.20,0.00,0.00,0.00,0.00,0.00),('21','221','2','127',3536,'8','1',3456909.91,3459280.56,2370.65,391157.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','127',3537,'9','1',5424206.04,5426794.18,2538.14,418793.18,0.00,0.00,50.00,0.00,0.00),('21','221','2','127',3538,'10','1',3703594.75,3708763.70,5168.95,852876.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','127',3539,'11','1',4650792.33,4654037.99,3245.66,535533.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','127',3540,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','127',3541,'13','1',4535054.57,4537964.72,2910.15,480174.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','127',3542,'14','1',3502842.81,3504648.88,1806.07,298001.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','127',3543,'15','1',4162841.48,4166121.47,3279.99,541198.35,0.00,0.00,0.00,0.00,0.00),('21','221','3','127',3544,'16','1',3463582.82,3466219.63,2636.81,435073.65,0.00,0.00,0.00,0.00,0.00),('21','221','3','127',3545,'17','1',3858064.76,3860884.13,2819.37,465196.05,0.00,0.00,0.00,0.00,0.00),('21','221','3','127',3546,'18','1',3559449.90,3563258.62,3808.72,628438.80,0.00,0.00,0.00,0.00,0.00),('21','221','3','127',3547,'19','1',4275216.59,4278651.12,3434.53,566697.45,0.00,0.00,0.00,0.00,0.00),('21','221','4','127',3548,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','127',3549,'21','2',134657.83,137317.69,2659.86,2207683.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','127',3550,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','127',3551,'23','2',296553.11,300018.35,3465.24,2876149.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','127',3552,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','127',3553,'25','3',62039.58,62431.83,382.25,286689.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','127',3554,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','127',3555,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','127',3556,'28','1',4025536.33,4027991.42,2455.09,405089.85,0.00,0.00,0.00,0.00,0.00),('21','221','1','128',3557,'1','1',4760037.53,4764376.10,4338.57,802635.45,0.00,0.00,0.00,0.00,0.00),('21','221','1','128',3558,'2','1',5304674.23,5307655.26,2981.03,551490.55,0.00,0.00,0.00,0.00,0.00),('21','221','1','128',3559,'3','1',4470297.65,4478392.41,8094.76,1497530.60,0.00,0.00,0.00,0.00,0.00),('21','221','1','128',3560,'4','1',5759500.67,5760849.21,1348.54,249479.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','128',3561,'5','1',4074687.29,4081752.71,7065.42,1307102.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','128',3562,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','128',3563,'7','1',2462995.71,2466943.87,3948.16,730409.60,0.00,0.00,0.00,0.00,0.00),('21','221','2','128',3564,'8','1',3459280.56,3462806.30,3525.74,652261.90,0.00,0.00,0.00,0.00,0.00),('21','221','2','128',3565,'9','1',5426794.18,5431641.07,4796.89,887424.65,0.00,0.00,50.00,0.00,0.00),('21','221','2','128',3566,'10','1',3708763.70,3712997.63,4233.93,783277.05,0.00,0.00,0.00,0.00,0.00),('21','221','2','128',3567,'11','1',4654037.99,4657325.03,3287.04,608102.40,0.00,0.00,0.00,0.00,0.00),('21','221','2','128',3568,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','128',3569,'13','1',4537964.72,4541795.31,3830.59,708659.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','128',3570,'14','1',3504648.88,3507671.85,3022.97,559249.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','128',3571,'15','1',4166121.47,4168755.90,2634.43,487369.55,0.00,0.00,0.00,0.00,0.00),('21','221','3','128',3572,'16','1',3466219.63,3468754.29,2534.66,468912.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','128',3573,'17','1',3860884.13,3863680.73,2796.60,517371.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','128',3574,'18','1',3563258.62,3566515.07,3256.45,602443.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','128',3575,'19','1',4278651.12,4281756.46,3105.34,574487.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','128',3576,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','128',3577,'21','2',137317.69,138062.21,744.52,617951.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','128',3578,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','128',3579,'23','2',300018.35,320945.46,20927.11,17369501.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','128',3580,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','128',3581,'25','3',62431.83,62950.03,508.20,381152.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','128',3582,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','128',3583,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','128',3584,'28','1',4027991.42,4031789.60,3798.18,702663.30,0.00,0.00,0.00,0.00,0.00),('21','221','1','129',3585,'1','1',4764376.10,4768454.20,4078.10,754448.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','129',3586,'2','1',5307655.26,5312764.12,5108.86,945139.10,0.00,0.00,0.00,0.00,0.00),('21','221','1','129',3587,'3','1',4478392.41,4479852.11,1459.70,270044.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','129',3588,'4','1',5760849.21,5767035.82,6186.61,1144522.85,0.00,0.00,0.00,0.00,0.00),('21','221','2','129',3589,'5','1',4081752.71,4087048.38,5295.67,979698.95,0.00,0.00,0.00,0.00,0.00),('21','221','2','129',3590,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','129',3591,'7','1',2466943.87,2473169.52,6225.65,1151745.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','129',3592,'8','1',3462806.30,3465469.92,2663.62,492769.70,0.00,0.00,0.00,0.00,0.00),('21','221','2','129',3593,'9','1',5431641.07,5432463.59,822.52,152166.20,0.00,0.00,0.00,0.00,50.00),('21','221','2','129',3594,'10','1',3712997.63,3718729.74,5732.11,1060440.35,0.00,0.00,0.00,0.00,0.00),('21','221','2','129',3595,'11','1',4657325.03,4663189.02,5863.99,1084838.15,0.00,0.00,0.00,0.00,0.00),('21','221','2','129',3596,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','129',3597,'13','1',4541795.31,4545032.36,3237.05,598854.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','129',3598,'14','1',3507671.85,3511155.82,3483.97,644534.45,0.00,0.00,0.00,0.00,0.00),('21','221','3','129',3599,'15','1',4168755.90,4171686.06,2930.16,542079.60,0.00,0.00,0.00,0.00,0.00),('21','221','3','129',3600,'16','1',3468754.29,3473042.94,4288.65,793400.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','129',3601,'17','1',3863680.73,3865647.12,1966.39,363782.15,0.00,0.00,0.00,0.00,0.00),('21','221','3','129',3602,'18','1',3566515.07,3568964.33,2449.26,453113.10,0.00,0.00,0.00,0.00,0.00),('21','221','3','129',3603,'19','1',4281756.46,4285463.96,3707.50,685887.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','129',3604,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','129',3605,'21','2',138062.21,139217.29,1155.08,958716.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','129',3606,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','129',3607,'23','2',320945.46,330136.75,9191.29,7628770.70,0.00,0.00,0.00,0.00,0.00),('21','221','5','129',3608,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','129',3609,'25','3',62950.03,63416.99,456.96,342720.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','129',3610,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','129',3611,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','129',3612,'28','1',4031789.60,4035332.04,3542.44,655351.40,0.00,0.00,0.00,0.00,0.00),('21','221','1','130',3613,'1','1',4768454.20,4768454.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','130',3614,'2','1',5312764.12,5312764.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','130',3615,'3','1',4479852.11,4479852.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','130',3616,'4','1',5767035.82,5767035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','130',3617,'5','1',4087048.38,4087048.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','130',3618,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','130',3619,'7','1',2473169.52,2473169.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','130',3620,'8','1',3465469.92,3465469.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','130',3621,'9','1',5432463.59,5432463.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','130',3622,'10','1',3718729.74,3718729.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','130',3623,'11','1',4663189.02,4663189.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','130',3624,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','130',3625,'13','1',4545032.36,4545032.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','130',3626,'14','1',3511155.82,3511155.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','130',3627,'15','1',4171686.06,4171686.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','130',3628,'16','1',3473042.94,3473042.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','130',3629,'17','1',3865647.12,3865647.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','130',3630,'18','1',3568964.33,3568964.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','130',3631,'19','1',4285463.96,4285463.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','130',3632,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','130',3633,'21','2',139217.29,139217.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','130',3634,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','130',3635,'23','2',330136.75,330136.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','130',3636,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','130',3637,'25','3',63416.99,63416.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','130',3638,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','130',3639,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','130',3640,'28','1',4035332.04,4035332.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','131',3641,'1','1',4768454.20,4770560.32,2106.12,368571.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','131',3642,'2','1',5312764.12,5316646.74,3882.62,679458.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','131',3643,'3','1',4479852.11,4483595.25,3743.14,655049.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','131',3644,'4','1',5767035.82,5769756.59,2720.77,476134.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','131',3645,'5','1',4087048.38,4091891.58,4843.20,847560.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','131',3646,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','131',3647,'7','1',2473169.52,2476708.86,3539.34,619384.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','131',3648,'8','1',3465469.92,3468344.45,2874.53,503042.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','131',3649,'9','1',5432463.59,5435678.01,3164.42,553773.50,0.00,0.00,50.00,0.00,0.00),('21','221','2','131',3650,'10','1',3718729.74,3722198.58,3468.84,607047.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','131',3651,'11','1',4663189.02,4665964.38,2775.36,485688.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','131',3652,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','131',3653,'13','1',4545032.36,4548309.50,3277.14,573499.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','131',3654,'14','1',3511155.82,3513788.77,2632.95,460766.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','131',3655,'15','1',4171686.06,4173212.44,1526.38,267116.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','131',3656,'16','1',3473042.94,3475198.85,2155.91,377284.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','131',3657,'17','1',3865647.12,3867482.74,1835.62,321233.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','131',3658,'18','1',3568964.33,3572456.36,3492.03,611105.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','131',3659,'19','1',4285463.96,4288664.04,3200.08,560014.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','131',3660,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','131',3661,'21','2',139217.29,141465.74,2248.45,1866213.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','131',3662,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','131',3663,'23','2',330136.75,330136.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','131',3664,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','131',3665,'25','3',63416.99,63720.89,293.90,220427.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','131',3666,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','131',3667,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','131',3668,'28','1',4035332.04,4038990.94,3658.90,640307.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','132',3669,'1','1',4770560.32,4774078.89,3518.57,615749.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','132',3670,'2','1',5316646.74,5319517.92,2871.18,502456.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','132',3671,'3','1',4483595.25,4486722.00,3126.75,547181.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','132',3672,'4','1',5769756.59,5773603.79,3847.20,673260.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','132',3673,'5','1',4091891.58,4099493.06,7601.48,1330259.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','132',3674,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','132',3675,'7','1',2476708.86,2479022.57,2313.71,404899.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','132',3676,'8','1',3468344.45,3474336.06,5991.61,1048531.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','132',3677,'9','1',5435678.01,5441914.83,6186.82,1082693.50,0.00,0.00,50.00,0.00,0.00),('21','221','2','132',3678,'10','1',3722198.58,3729359.03,7160.45,1253078.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','132',3679,'11','1',4665964.38,4668922.55,2958.17,517679.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','132',3680,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','132',3681,'13','1',4548309.50,4552884.95,4575.45,800703.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','132',3682,'14','1',3513788.77,3517696.17,3907.40,683795.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','132',3683,'15','1',4173212.44,4177939.39,4726.95,827216.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','132',3684,'16','1',3475198.85,3478280.08,3081.23,539215.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','132',3685,'17','1',3867482.74,3872073.32,4590.58,803351.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','132',3686,'18','1',3572456.36,3575767.30,3310.94,579414.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','132',3687,'19','1',4288664.04,4293065.78,4401.74,770304.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','132',3688,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','132',3689,'21','2',141465.74,142114.90,649.16,538802.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','132',3690,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','132',3691,'23','2',330136.75,333429.83,3293.08,2733256.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','132',3692,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','132',3693,'25','3',63720.89,64307.60,576.71,432533.25,0.00,0.00,10.00,0.00,0.00),('21','221','5','132',3694,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','132',3695,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','132',3696,'28','1',4038990.94,4043377.77,4386.83,767695.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','133',3697,'1','1',4774078.89,4776555.11,2476.22,433338.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','133',3698,'2','1',5319517.92,5329466.01,9948.09,1740915.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','133',3699,'3','1',4486722.00,4508131.35,21409.35,3746636.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','133',3700,'4','1',5773603.79,5783971.33,10367.54,1814319.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','133',3701,'5','1',4099493.06,4104191.56,4698.50,822237.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','133',3702,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','133',3703,'7','1',2479022.57,2481674.42,2651.85,464073.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','133',3704,'8','1',3474336.06,3477075.09,2739.03,479330.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','133',3705,'9','1',5441914.83,5443414.77,1449.94,253739.50,0.00,0.00,50.00,0.00,0.00),('21','221','2','133',3706,'10','1',3729359.03,3733544.23,4185.20,732410.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','133',3707,'11','1',4668922.55,4671912.16,2989.61,523181.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','133',3708,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','133',3709,'13','1',4552884.95,4555248.89,2363.94,413689.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','133',3710,'14','1',3517696.17,3519884.40,2188.23,382940.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','133',3711,'15','1',4177939.39,4180620.69,2681.30,469227.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','133',3712,'16','1',3478280.08,3480333.95,2053.87,359427.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','133',3713,'17','1',3872073.32,3874552.93,2479.61,433931.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','133',3714,'18','1',3575767.30,3578024.07,2256.77,394934.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','133',3715,'19','1',4293065.78,4295577.60,2511.82,439568.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','133',3716,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','133',3717,'21','2',142114.90,144042.85,1927.95,1600198.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','133',3718,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','133',3719,'23','2',333429.83,339558.80,6128.97,5087045.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','133',3720,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','133',3721,'25','3',64307.60,64858.75,541.15,405862.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','133',3722,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','133',3723,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','133',3724,'28','1',4043377.77,4046202.57,2824.80,494340.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','134',3725,'1','1',4776555.11,4777976.82,1421.71,248799.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','134',3726,'2','1',5329466.01,5331082.95,1616.94,282964.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','134',3727,'3','1',4508131.35,4509652.04,1520.69,266120.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','134',3728,'4','1',5783971.33,5790361.16,6389.83,1118220.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','134',3729,'5','1',4104191.56,4109242.02,5050.46,883830.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','134',3730,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','134',3731,'7','1',2481674.42,2484139.03,2464.61,431306.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','134',3732,'8','1',3477075.09,3481039.62,3964.53,693792.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','134',3733,'9','1',5443414.77,5446862.44,3397.67,594592.25,0.00,0.00,50.00,0.00,0.00),('21','221','2','134',3734,'10','1',3733544.23,3739461.28,5917.05,1035483.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','134',3735,'11','1',4671912.16,4674446.79,2534.63,443560.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','134',3736,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','134',3737,'13','1',4555248.89,4557835.88,2586.99,452723.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','134',3738,'14','1',3519884.40,3521250.71,1366.31,239104.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','134',3739,'15','1',4180620.69,4183481.84,2861.15,500701.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','134',3740,'16','1',3480333.95,3482380.76,2046.81,358191.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','134',3741,'17','1',3874552.93,3877354.31,2801.38,490241.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','134',3742,'18','1',3578024.07,3580845.59,2821.52,493766.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','134',3743,'19','1',4295577.60,4298340.44,2762.84,483497.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','134',3744,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','134',3745,'21','2',144042.85,146629.76,2586.91,2147135.30,0.00,0.00,0.00,0.00,0.00),('21','221','4','134',3746,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','134',3747,'23','2',339558.80,342813.67,3254.87,2701542.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','134',3748,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','134',3749,'25','3',64858.75,65458.57,589.82,442368.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','134',3750,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','134',3751,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','134',3752,'28','1',4046202.57,4049664.19,3461.62,605783.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','135',3753,'1','1',4777976.82,4780365.75,2388.93,418062.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','135',3754,'2','1',5331082.95,5332747.49,1664.54,291294.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','135',3755,'3','1',4509652.04,4512543.00,2890.96,505918.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','135',3756,'4','1',5790361.16,5792714.43,2353.27,411822.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','135',3757,'5','1',4109242.02,4114450.00,5207.98,911396.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','135',3758,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','135',3759,'7','1',2484139.03,2487850.24,3711.21,649461.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','135',3760,'8','1',3481039.62,3484313.24,3223.62,564133.50,0.00,0.00,50.00,0.00,0.00),('21','221','2','135',3761,'9','1',5446862.44,5449494.54,2632.10,460617.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','135',3762,'10','1',3739461.28,3746080.94,6619.66,1158440.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','135',3763,'11','1',4674446.79,4677668.04,3221.25,563718.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','135',3764,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','135',3765,'13','1',4557835.88,4560987.53,3151.65,551538.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','135',3766,'14','1',3521250.71,3524357.92,3107.21,543761.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','135',3767,'15','1',4183481.84,4186039.25,2557.41,447546.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','135',3768,'16','1',3482380.76,3484782.85,2402.09,420365.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','135',3769,'17','1',3877354.31,3880424.02,3069.71,537199.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','135',3770,'18','1',3580845.59,3585231.70,4386.11,767569.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','135',3771,'19','1',4298340.44,4301383.41,3042.97,532519.75,0.00,0.00,0.00,0.00,0.00),('21','221','4','135',3772,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','135',3773,'21','2',146629.76,146835.76,206.00,170980.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','135',3774,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','135',3775,'23','2',342813.67,346954.14,4140.47,3436590.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','135',3776,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','135',3777,'25','3',65458.57,66157.00,688.43,516324.75,0.00,0.00,10.00,0.00,0.00),('21','221','5','135',3778,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','135',3779,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','135',3780,'28','1',4049664.19,4054842.84,5178.65,906263.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','136',3781,'1','1',4780365.75,4782082.53,1716.78,300436.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','136',3782,'2','1',5332747.49,5333968.62,1221.13,213697.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','136',3783,'3','1',4512543.00,4514766.47,2223.47,389107.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','136',3784,'4','1',5792714.43,5793976.43,1262.00,220850.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','136',3785,'5','1',4114450.00,4118808.12,4358.12,762671.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','136',3786,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','136',3787,'7','1',2487850.24,2489889.90,2039.66,356940.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','136',3788,'8','1',3484313.24,3486985.77,2672.53,467692.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','136',3789,'9','1',5449494.54,5452265.03,2720.49,476085.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','136',3790,'10','1',3746080.94,3750870.96,4790.02,838253.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','136',3791,'11','1',4677668.04,4680377.08,2709.04,474082.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','136',3792,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','136',3793,'13','1',4560987.53,4563050.01,2062.48,360934.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','136',3794,'14','1',3524357.92,3526162.00,1804.08,315714.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','136',3795,'15','1',4186039.25,4188835.88,2796.63,489410.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','136',3796,'16','1',3484782.85,3486685.22,1902.37,332914.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','136',3797,'17','1',3880424.02,3882925.49,2501.47,437757.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','136',3798,'18','1',3585231.70,3587868.71,2637.01,461476.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','136',3799,'19','1',4301383.41,4303670.29,2286.88,400204.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','136',3800,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','136',3801,'21','2',146835.76,146835.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','136',3802,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','136',3803,'23','2',346954.14,349162.55,2208.41,1799854.15,0.00,0.00,0.00,0.00,0.00),('21','221','5','136',3804,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','136',3805,'25','3',66157.00,66641.02,474.02,355515.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','136',3806,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','136',3807,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','136',3808,'28','1',4054842.84,4057605.05,2762.21,483386.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','137',3809,'1','1',4782082.53,4787234.54,5152.01,901601.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','137',3810,'2','1',5333968.62,5339415.14,5446.52,953141.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','137',3811,'3','1',4514766.47,4519335.94,4569.47,799657.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','137',3812,'4','1',5793976.43,5798964.08,4987.65,872838.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','137',3813,'5','1',4118808.12,4127962.35,9154.23,1601990.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','137',3814,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','137',3815,'7','1',2489889.90,2494962.96,5073.06,887785.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','137',3816,'8','1',3486985.77,3490969.50,3983.73,697152.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','137',3817,'9','1',5452265.03,5455813.07,3548.04,620907.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','137',3818,'10','1',3750870.96,3757298.34,6427.38,1124791.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','137',3819,'11','1',4680377.08,4685490.96,5113.88,894929.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','137',3820,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','137',3821,'13','1',4563050.01,4567334.99,4284.98,749871.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','137',3822,'14','1',3526162.00,3529240.32,3078.32,538706.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','137',3823,'15','1',4188835.88,4193231.70,4395.82,769268.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','137',3824,'16','1',3486685.22,3489702.87,2967.65,519338.75,0.00,0.00,50.00,0.00,0.00),('21','221','3','137',3825,'17','1',3882925.49,3888358.50,5433.01,950776.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','137',3826,'18','1',3587868.71,3593576.52,5707.81,998866.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','137',3827,'19','1',4303670.29,4308966.55,5296.26,926845.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','137',3828,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','137',3829,'21','2',146835.76,146845.52,9.76,7954.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','137',3830,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','137',3831,'23','2',349162.55,352211.34,3048.79,2484763.85,0.00,0.00,0.00,0.00,0.00),('21','221','5','137',3832,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','137',3833,'25','3',66641.02,67675.02,1024.00,768000.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','137',3834,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','137',3835,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','137',3836,'28','1',4057605.05,4062888.99,5283.94,924689.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','138',3837,'1','1',4787234.54,4789683.39,2448.85,428548.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','138',3838,'2','1',5339415.14,5342481.53,3066.39,536618.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','138',3839,'3','1',4519335.94,4522371.21,3035.27,531172.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','138',3840,'4','1',5798964.08,5802230.60,3266.52,571641.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','138',3841,'5','1',4127962.35,4133162.54,5200.19,910033.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','138',3842,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','138',3843,'7','1',2494962.96,2498222.55,3259.59,570428.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','138',3844,'8','1',3490969.50,3493454.05,2484.55,434796.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','138',3845,'9','1',5455813.07,5459754.44,3891.37,680989.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','138',3846,'10','1',3757298.34,3762687.93,5389.59,943178.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','138',3847,'11','1',4685490.96,4688999.38,3508.42,613973.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','138',3848,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','138',3849,'13','1',4567334.99,4571062.64,3727.65,652338.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','138',3850,'14','1',3529240.32,3532587.69,3347.37,585789.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','138',3851,'15','1',4193231.70,4196881.58,3649.88,638729.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','138',3852,'16','1',3489702.87,3493348.02,3645.15,637901.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','138',3853,'17','1',3888358.50,3890888.31,2529.81,442716.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','138',3854,'18','1',3593576.52,3596743.74,3167.22,554263.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','138',3855,'19','1',4308966.55,4312635.74,3669.19,642108.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','138',3856,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','138',3857,'21','2',146845.52,146845.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','138',3858,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','138',3859,'23','2',352211.34,353707.15,1495.81,1219085.15,0.00,0.00,0.00,0.00,0.00),('21','221','5','138',3860,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','138',3861,'25','3',67675.02,68162.41,477.39,358041.75,0.00,0.00,10.00,0.00,0.00),('21','221','5','138',3862,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','138',3863,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','138',3864,'28','1',4062888.99,4066303.29,3414.30,597502.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','139',3865,'1','1',4789683.39,4791768.42,2035.03,356130.25,0.00,0.00,50.00,0.00,0.00),('21','221','1','139',3866,'2','1',5342481.53,5345012.17,2530.64,442862.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','139',3867,'3','1',4522371.21,4523826.93,1455.72,254751.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','139',3868,'4','1',5802230.60,5805626.81,3396.21,594336.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','139',3869,'5','1',4133162.54,4138283.68,5121.14,896199.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','139',3870,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','139',3871,'7','1',2498222.55,2501156.04,2933.49,513360.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','139',3872,'8','1',3493454.05,3496418.12,2964.07,518712.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','139',3873,'9','1',5459754.44,5462973.27,3218.83,563295.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','139',3874,'10','1',3762687.93,3768296.97,5609.04,981582.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','139',3875,'11','1',4688999.38,4692170.91,3171.53,555017.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','139',3876,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','139',3877,'13','1',4571062.64,4575133.90,4071.26,712470.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','139',3878,'14','1',3532587.69,3534709.34,2121.65,371288.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','139',3879,'15','1',4196881.58,4200980.86,4099.28,717374.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','139',3880,'16','1',3493348.02,3497218.27,3870.25,677293.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','139',3881,'17','1',3890888.31,3894008.44,3120.13,546022.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','139',3882,'18','1',3596743.74,3601004.08,4260.34,745559.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','139',3883,'19','1',4312635.74,4314711.29,2075.55,363221.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','139',3884,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','139',3885,'21','2',146845.52,146845.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','139',3886,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','139',3887,'23','2',353707.15,358519.72,4812.57,3922244.55,0.00,0.00,0.00,0.00,0.00),('21','221','5','139',3888,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','139',3889,'25','3',68162.41,68739.94,567.53,425644.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','139',3890,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','139',3891,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','139',3892,'28','1',4066303.29,4069993.75,3690.46,645830.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','140',3893,'1','1',4791768.42,4791768.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','140',3894,'2','1',5345012.17,5345012.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','140',3895,'3','1',4523826.93,4523826.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','140',3896,'4','1',5805626.81,5805626.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','140',3897,'5','1',4138283.68,4139819.16,1535.48,268709.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','140',3898,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','140',3899,'7','1',2501156.04,2501815.29,659.25,115368.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','140',3900,'8','1',3496418.12,3497428.06,1009.94,176739.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','140',3901,'9','1',5462973.27,5464396.28,1373.01,240276.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','140',3902,'10','1',3768296.97,3770027.90,1730.93,302912.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','140',3903,'11','1',4692170.91,4692988.69,817.78,143111.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','140',3904,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','140',3905,'13','1',4575133.90,4576003.91,870.01,152251.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','140',3906,'14','1',3534709.34,3535468.12,758.78,132786.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','140',3907,'15','1',4200980.86,4201942.36,961.50,168262.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','140',3908,'16','1',3497218.27,3498091.84,873.57,152874.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','140',3909,'17','1',3894008.44,3895270.39,1261.95,220841.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','140',3910,'18','1',3601004.08,3601566.32,562.24,98392.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','140',3911,'19','1',4314711.29,4315910.84,1199.55,209921.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','140',3912,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','140',3913,'21','2',146845.52,146866.11,20.59,16677.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','140',3914,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','140',3915,'23','2',358519.72,360152.89,1613.17,1306667.70,0.00,0.00,20.00,0.00,0.00),('21','221','5','140',3916,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','140',3917,'25','3',68739.94,69268.20,518.26,388698.00,0.00,0.00,10.00,0.00,0.00),('21','221','5','140',3918,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','140',3919,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','140',3920,'28','1',4069993.75,4070889.96,896.21,156836.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','141',3921,'1','1',4791768.42,4795181.88,3363.46,588605.50,0.00,0.00,50.00,0.00,0.00),('21','221','1','141',3922,'2','1',5345012.17,5347225.73,2213.56,387373.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','141',3923,'3','1',4523826.93,4526693.90,2866.97,501719.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','141',3924,'4','1',5805626.81,5807725.87,2099.06,367335.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','141',3925,'5','1',4139819.16,4143948.32,4129.16,722603.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','141',3926,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','141',3927,'7','1',2501815.29,2504097.58,2282.29,399400.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','141',3928,'8','1',3497428.06,3500107.94,2679.88,468979.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','141',3929,'9','1',5464396.28,5467526.99,3130.71,547874.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','141',3930,'10','1',3770027.90,3773832.32,3804.42,665773.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','141',3931,'11','1',4692988.69,4695569.35,2580.66,451615.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','141',3932,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','141',3933,'13','1',4576003.91,4579334.13,3330.22,582788.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','141',3934,'14','1',3535468.12,3538783.96,3315.84,580272.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','141',3935,'15','1',4201942.36,4204120.67,2178.31,381204.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','141',3936,'16','1',3498091.84,3500824.78,2732.94,478264.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','141',3937,'17','1',3895270.39,3897893.28,2622.89,459005.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','141',3938,'18','1',3601566.32,3604330.38,2764.06,483710.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','141',3939,'19','1',4315910.84,4317343.80,1432.96,250768.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','141',3940,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','141',3941,'21','2',146866.11,147427.04,560.93,454353.30,0.00,0.00,0.00,0.00,0.00),('21','221','4','141',3942,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','141',3943,'23','2',360152.89,365418.30,5265.41,4264982.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','141',3944,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','141',3945,'25','3',69268.20,69778.49,500.29,417738.81,0.00,0.00,10.00,0.00,0.00),('21','221','5','141',3946,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','141',3947,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','141',3948,'28','1',4070889.96,4073202.18,2312.22,404638.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','142',3949,'1','1',4795181.88,4797633.17,2451.29,428975.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','142',3950,'2','1',5347225.73,5349593.47,2367.74,414354.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','142',3951,'3','1',4526693.90,4529001.37,2307.47,403807.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','142',3952,'4','1',5807725.87,5810634.12,2908.25,508943.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','142',3953,'5','1',4143948.32,4148214.93,4266.61,746656.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','142',3954,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','142',3955,'7','1',2504097.58,2504285.21,187.63,32835.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','142',3956,'8','1',3500107.94,3502266.39,2158.45,377728.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','142',3957,'9','1',5467526.99,5471035.56,3508.57,613999.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','142',3958,'10','1',3773832.32,3778780.05,4947.73,865852.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','142',3959,'11','1',4695569.35,4699183.50,3614.15,632476.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','142',3960,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','142',3961,'13','1',4579334.13,4581800.75,2466.62,431658.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','142',3962,'14','1',3538783.96,3541162.96,2329.00,407575.00,0.00,0.00,50.00,0.00,0.00),('21','221','3','142',3963,'15','1',4204120.67,4206488.13,2367.46,414305.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','142',3964,'16','1',3500824.78,3502825.96,2001.18,350206.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','142',3965,'17','1',3897893.28,3900410.03,2516.75,440431.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','142',3966,'18','1',3604330.38,3607716.20,3385.82,592518.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','142',3967,'19','1',4317343.80,4319898.76,2554.96,447118.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','142',3968,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','142',3969,'21','2',147427.04,149531.97,2104.93,1704993.30,0.00,0.00,0.00,0.00,0.00),('21','221','4','142',3970,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','142',3971,'23','2',365418.30,368496.12,3077.82,2493034.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','142',3972,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','142',3973,'25','3',69778.49,70384.22,595.72,497430.37,0.00,0.00,10.00,0.00,0.00),('21','221','5','142',3974,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','142',3975,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','142',3976,'28','1',4073202.18,4076681.58,3479.40,608895.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','143',3977,'1','1',4797633.17,4797633.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','143',3978,'2','1',5349593.47,5349593.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','143',3979,'3','1',4529001.37,4529001.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','143',3980,'4','1',5810634.12,5810634.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','143',3981,'5','1',4148214.93,4148214.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','143',3982,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','143',3983,'7','1',2504285.21,2504285.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','143',3984,'8','1',3502266.39,3502266.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','143',3985,'9','1',5471035.56,5471035.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','143',3986,'10','1',3778780.05,3778780.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','143',3987,'11','1',4699183.50,4699183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','143',3988,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','143',3989,'13','1',4581800.75,4581800.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','143',3990,'14','1',3541162.96,3541162.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','143',3991,'15','1',4206488.13,4206488.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','143',3992,'16','1',3502825.96,3502825.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','143',3993,'17','1',3900410.03,3900410.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','143',3994,'18','1',3607716.20,3607716.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','143',3995,'19','1',4319898.76,4319898.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','143',3996,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','143',3997,'21','2',149531.97,149531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','143',3998,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','143',3999,'23','2',368496.12,368496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','143',4000,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','143',4001,'25','3',70384.22,70384.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','143',4002,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','143',4003,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','143',4004,'28','1',4076681.58,4076681.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','144',4005,'1','1',4797633.17,4800605.05,2971.88,520079.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','144',4006,'2','1',5349593.47,5351986.21,2392.74,418729.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','144',4007,'3','1',4529001.37,4533025.33,4023.96,704193.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','144',4008,'4','1',5810634.12,5814815.64,4181.52,731766.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','144',4009,'5','1',4148214.93,4153959.55,5744.62,1005308.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','144',4010,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','144',4011,'7','1',2504285.21,2507501.87,3216.66,562915.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','144',4012,'8','1',3502266.39,3503695.65,1429.26,250120.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','144',4013,'9','1',5471035.56,5475143.61,4108.05,718908.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','144',4014,'10','1',3778780.05,3786182.88,7402.83,1295495.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','144',4015,'11','1',4699183.50,4704477.85,5294.35,926511.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','144',4016,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','144',4017,'13','1',4581800.75,4584045.41,2244.66,392815.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','144',4018,'14','1',3541162.96,3543541.25,2378.29,416200.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','144',4019,'15','1',4206488.13,4210206.55,3718.42,650723.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','144',4020,'16','1',3502825.96,3505785.06,2959.10,517842.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','144',4021,'17','1',3900410.03,3903374.63,2964.60,518805.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','144',4022,'18','1',3607716.20,3612664.63,4948.43,865975.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','144',4023,'19','1',4319898.76,4323019.46,3120.70,546122.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','144',4024,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','144',4025,'21','2',149531.97,149531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','144',4026,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','144',4027,'23','2',368496.12,372900.65,4404.53,3567669.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','144',4028,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','144',4029,'25','3',70384.22,70856.17,471.95,394080.76,0.00,0.00,0.00,0.00,0.00),('21','221','5','144',4030,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','144',4031,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','144',4032,'28','1',4076681.58,4082319.56,5637.98,986646.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','145',4033,'1','1',4800605.05,4802500.42,1895.37,331689.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','145',4034,'2','1',5351986.21,5353239.89,1253.68,219394.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','145',4035,'3','1',4533025.33,4534940.01,1914.68,335069.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','145',4036,'4','1',5814815.64,5817309.16,2493.52,436366.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','145',4037,'5','1',4153959.55,4157658.66,3699.11,647344.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','145',4038,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','145',4039,'7','1',2507501.87,2509438.88,1887.01,330226.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','145',4040,'8','1',3503695.65,3506628.90,2933.25,513318.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','145',4041,'9','1',5475143.61,5477897.00,2753.39,481843.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','145',4042,'10','1',3786182.88,3791018.84,4835.96,846293.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','145',4043,'11','1',4704477.85,4706697.73,2219.88,388479.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','145',4044,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','145',4045,'13','1',4584045.41,4587786.53,3741.12,654696.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','145',4046,'14','1',3543541.25,3545783.64,2242.39,392418.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','145',4047,'15','1',4210206.55,4212774.28,2567.73,449352.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','145',4048,'16','1',3505785.06,3508806.54,3021.48,528759.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','145',4049,'17','1',3903374.63,3906151.45,2776.82,485943.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','145',4050,'18','1',3612664.63,3617256.21,4591.58,803526.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','145',4051,'19','1',4323019.46,4325618.74,2599.28,454874.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','145',4052,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','145',4053,'21','2',149531.97,149531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','145',4054,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','145',4055,'23','2',372900.65,374915.84,2015.19,1632303.90,0.00,0.00,0.00,0.00,0.00),('21','221','5','145',4056,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','145',4057,'25','3',70856.17,71652.95,786.78,656957.96,0.00,0.00,10.00,0.00,0.00),('21','221','5','145',4058,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','145',4059,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','145',4060,'28','1',4082319.56,4086815.81,4496.25,786843.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','146',4061,'1','1',4802500.42,4805268.40,2767.98,484396.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','146',4062,'2','1',5353239.89,5356123.09,2883.20,504560.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','146',4063,'3','1',4534940.01,4536982.17,2042.16,357378.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','146',4064,'4','1',5817309.16,5819687.03,2377.87,416127.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','146',4065,'5','1',4157658.66,4162047.83,4389.17,768104.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','146',4066,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','146',4067,'7','1',2509438.88,2511705.30,2266.42,396623.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','146',4068,'8','1',3506628.90,3508781.09,2152.19,376633.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','146',4069,'9','1',5477897.00,5480648.06,2701.06,472685.50,0.00,0.00,50.00,0.00,0.00),('21','221','2','146',4070,'10','1',3791018.84,3795701.99,4683.15,819551.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','146',4071,'11','1',4706697.73,4709588.62,2890.89,505905.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','146',4072,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','146',4073,'13','1',4587786.53,4589646.90,1860.37,325564.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','146',4074,'14','1',3545783.64,3547737.31,1953.67,341892.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','146',4075,'15','1',4212774.28,4215034.62,2260.34,395559.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','146',4076,'16','1',3508806.54,3511500.89,2694.35,471511.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','146',4077,'17','1',3906151.45,3908746.99,2595.54,454219.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','146',4078,'18','1',3617256.21,3621243.08,3986.87,697702.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','146',4079,'19','1',4325618.74,4328202.02,2583.28,452074.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','146',4080,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','146',4081,'21','2',149531.97,149531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','146',4082,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','146',4083,'23','2',374915.84,377446.46,2530.62,2049802.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','146',4084,'24','3',408745.52,408745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','146',4085,'25','3',71652.95,72029.32,366.37,305921.46,0.00,0.00,10.00,0.00,0.00),('21','221','5','146',4086,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','146',4087,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','146',4088,'28','1',4086815.81,4089835.97,3020.16,528528.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','147',4089,'1','1',4805268.40,4807185.09,1916.69,335420.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','147',4090,'2','1',5356123.09,5359237.36,3114.27,544997.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','147',4091,'3','1',4536982.17,4539229.08,2246.91,393209.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','147',4092,'4','1',5819687.03,5822920.17,3233.14,565799.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','147',4093,'5','1',4162047.83,4167922.19,5874.36,1028013.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','147',4094,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','147',4095,'7','1',2511705.30,2514198.38,2493.08,436289.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','147',4096,'8','1',3508781.09,3510847.45,2066.36,361613.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','147',4097,'9','1',5480648.06,5485234.71,4536.65,793913.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','147',4098,'10','1',3795701.99,3801360.87,5658.88,990304.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','147',4099,'11','1',4709588.62,4713031.39,3442.77,602484.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','147',4100,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','147',4101,'13','1',4589646.90,4593472.95,3826.05,669558.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','147',4102,'14','1',3547737.31,3550886.37,3149.06,551085.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','147',4103,'15','1',4215034.62,4217560.26,2525.64,441987.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','147',4104,'16','1',3511500.89,3513851.84,2350.95,411416.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','147',4105,'17','1',3908746.99,3912817.89,4070.90,712407.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','147',4106,'18','1',3621243.08,3627950.11,6707.03,1173730.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','147',4107,'19','1',4328202.02,4331366.32,3164.30,553752.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','147',4108,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','147',4109,'21','2',149531.97,149531.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','147',4110,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','147',4111,'23','2',377446.46,380444.56,2998.10,2428461.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','147',4112,'24','3',408745.52,409278.80,497.27,415224.62,0.00,0.00,36.00,0.00,0.00),('21','221','5','147',4113,'25','3',72029.32,72280.16,240.84,201103.07,0.00,0.00,10.00,0.00,0.00),('21','221','5','147',4114,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','147',4115,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','147',4116,'28','1',4089835.97,4089837.69,1.72,301.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','148',4117,'1','1',4807185.09,4809687.39,2502.30,437902.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','148',4118,'2','1',5359237.36,5362070.57,2833.21,495811.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','148',4119,'3','1',4539229.08,4541392.97,2113.89,369930.75,0.00,0.00,50.00,0.00,0.00),('21','221','1','148',4120,'4','1',5822920.17,5825718.08,2797.91,489634.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','148',4121,'5','1',4167922.19,4171401.30,3479.11,608844.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','148',4122,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','148',4123,'7','1',2514198.38,2515767.80,1569.42,274648.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','148',4124,'8','1',3510847.45,3512888.74,2041.29,357225.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','148',4125,'9','1',5485234.71,5489276.45,4041.74,707304.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','148',4126,'10','1',3801360.87,3805815.02,4454.15,779476.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','148',4127,'11','1',4713031.39,4715640.49,2609.10,456592.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','148',4128,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','148',4129,'13','1',4593472.95,4596459.90,2986.95,522716.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','148',4130,'14','1',3550886.37,3553683.16,2796.79,489438.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','148',4131,'15','1',4217560.26,4219940.27,2380.01,416501.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','148',4132,'16','1',3513851.84,3516313.91,2462.07,430862.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','148',4133,'17','1',3912817.89,3915141.90,2324.01,406701.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','148',4134,'18','1',3627950.11,3631654.49,3704.38,648266.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','148',4135,'19','1',4331366.32,4333237.63,1871.31,327479.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','148',4136,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','148',4137,'21','2',149531.97,149645.13,113.16,91659.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','148',4138,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','148',4139,'23','2',380444.56,382717.34,2272.78,1840951.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','148',4140,'24','3',409278.80,409313.86,35.06,29272.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','148',4141,'25','3',72280.16,72887.47,597.31,498753.01,0.00,0.00,10.00,0.00,0.00),('21','221','5','148',4142,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','148',4143,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','148',4144,'28','1',4089837.69,4092837.33,2999.64,524937.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','149',4145,'1','1',4809687.39,4811774.42,2087.03,365230.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','149',4146,'2','1',5362070.57,5364564.09,2493.52,436366.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','149',4147,'3','1',4541392.97,4543554.14,2161.17,378204.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','149',4148,'4','1',5825718.08,5827780.18,2062.10,360867.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','149',4149,'5','1',4171401.30,4176121.89,4720.59,826103.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','149',4150,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','149',4151,'7','1',2515767.80,2518269.98,2502.18,437881.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','149',4152,'8','1',3512888.74,3514694.20,1805.46,315955.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','149',4153,'9','1',5489276.45,5491768.48,2442.03,427355.25,0.00,0.00,50.00,0.00,0.00),('21','221','2','149',4154,'10','1',3805815.02,3811188.68,5373.66,940390.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','149',4155,'11','1',4715640.49,4719015.25,3374.76,590583.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','149',4156,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','149',4157,'13','1',4596459.90,4599134.78,2674.88,468104.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','149',4158,'14','1',3553683.16,3556093.47,2410.31,421804.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','149',4159,'15','1',4219940.27,4222270.32,2330.05,407758.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','149',4160,'16','1',3516313.91,3517600.62,1286.71,225174.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','149',4161,'17','1',3915141.90,3917385.09,2243.19,392558.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','149',4162,'18','1',3631654.49,3633895.01,2240.52,392091.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','149',4163,'19','1',4333237.63,4335327.63,2090.00,365750.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','149',4164,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','149',4165,'21','2',149645.13,149645.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','149',4166,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','149',4167,'23','2',382717.34,385674.28,2956.94,2395121.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','149',4168,'24','3',409313.86,409313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','149',4169,'25','3',72887.47,73625.42,727.95,607840.75,0.00,0.00,10.00,0.00,0.00),('21','221','5','149',4170,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','149',4171,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','149',4172,'28','1',4092837.33,4096846.82,4009.49,701660.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','150',4173,'1','1',4811774.42,4813537.52,1763.10,308542.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','150',4174,'2','1',5364564.09,5366295.38,1731.29,302975.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','150',4175,'3','1',4543554.14,4545604.47,2050.33,358807.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','150',4176,'4','1',5827780.18,5829911.80,2131.62,373033.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','150',4177,'5','1',4176121.89,4180598.84,4476.95,783466.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','150',4178,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','150',4179,'7','1',2518269.98,2520995.78,2725.80,477015.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','150',4180,'8','1',3514694.20,3517015.85,2321.65,406288.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','150',4181,'9','1',5491768.48,5493901.60,2133.12,373296.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','150',4182,'10','1',3811188.68,3815274.33,4085.65,714988.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','150',4183,'11','1',4719015.25,4720413.07,1397.82,244618.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','150',4184,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','150',4185,'13','1',4599134.78,4602218.17,3083.39,539593.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','150',4186,'14','1',3556093.47,3556894.55,801.08,140189.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','150',4187,'15','1',4222270.32,4225593.10,3322.78,581486.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','150',4188,'16','1',3517600.62,3519457.35,1856.73,324927.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','150',4189,'17','1',3917385.09,3919702.54,2317.45,405553.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','150',4190,'18','1',3633895.01,3636469.68,2574.67,450567.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','150',4191,'19','1',4335327.63,4338147.41,2819.78,493461.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','150',4192,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','150',4193,'21','2',149645.13,149957.12,311.99,252711.90,0.00,0.00,0.00,0.00,0.00),('21','221','4','150',4194,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','150',4195,'23','2',385674.28,390025.26,4350.98,3524293.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','150',4196,'24','3',409313.86,409313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','150',4197,'25','3',73625.42,74244.79,619.37,517169.78,0.00,0.00,0.00,0.00,0.00),('21','221','5','150',4198,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','150',4199,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','150',4200,'28','1',4096846.82,4100428.54,3581.72,626801.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','151',4201,'1','1',4813537.52,4816162.69,2625.17,459404.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','151',4202,'2','1',5366295.38,5367567.82,1272.44,222677.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','151',4203,'3','1',4545604.47,4547888.09,2283.62,399633.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','151',4204,'4','1',5829911.80,5832415.71,2503.91,438184.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','151',4205,'5','1',4180598.84,4184617.66,4018.82,703293.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','151',4206,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','151',4207,'7','1',2520995.78,2523458.07,2462.29,430900.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','151',4208,'8','1',3517015.85,3518802.94,1787.09,312740.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','151',4209,'9','1',5493901.60,5496389.06,2437.46,426555.50,0.00,0.00,50.00,0.00,0.00),('21','221','2','151',4210,'10','1',3815274.33,3819812.63,4538.30,794202.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','151',4211,'11','1',4720413.07,4722758.09,2345.02,410378.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','151',4212,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','151',4213,'13','1',4602218.17,4603885.19,1667.02,291728.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','151',4214,'14','1',3556894.55,3558499.03,1604.48,280784.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','151',4215,'15','1',4225593.10,4227505.76,1912.66,334715.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','151',4216,'16','1',3519457.35,3521837.61,2380.26,416545.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','151',4217,'17','1',3919702.54,3922391.27,2688.73,470527.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','151',4218,'18','1',3636469.68,3639654.96,3185.28,557424.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','151',4219,'19','1',4338147.41,4341457.92,3310.51,579339.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','151',4220,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','151',4221,'21','2',149957.12,149957.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','151',4222,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','151',4223,'23','2',390025.26,392653.74,2628.48,2129068.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','151',4224,'24','3',409313.86,409313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','151',4225,'25','3',74244.79,74749.35,494.56,412955.93,0.00,0.00,10.00,0.00,0.00),('21','221','5','151',4226,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','151',4227,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','151',4228,'28','1',4100428.54,4102793.33,2364.79,413838.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','152',4229,'1','1',4816162.69,4817922.36,1759.67,307942.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','152',4230,'2','1',5367567.82,5371859.82,4292.00,751100.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','152',4231,'3','1',4547888.09,4550795.76,2907.67,508842.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','152',4232,'4','1',5832415.71,5835815.30,3399.59,594928.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','152',4233,'5','1',4184617.66,4189349.29,4731.63,828035.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','152',4234,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','152',4235,'7','1',2523458.07,2526399.20,2941.13,514697.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','152',4236,'8','1',3518802.94,3520844.89,2041.95,357341.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','152',4237,'9','1',5496389.06,5499301.97,2862.91,501009.25,0.00,0.00,50.00,0.00,0.00),('21','221','2','152',4238,'10','1',3819812.63,3825212.45,5399.82,944968.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','152',4239,'11','1',4722758.09,4726415.43,3657.34,640034.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','152',4240,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','152',4241,'13','1',4603885.19,4606851.53,2966.34,519109.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','152',4242,'14','1',3558499.03,3561540.05,3041.02,532178.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','152',4243,'15','1',4227505.76,4229987.55,2481.79,434313.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','152',4244,'16','1',3521837.61,3524733.62,2896.01,506801.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','152',4245,'17','1',3922391.27,3925052.05,2660.78,465636.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','152',4246,'18','1',3639654.96,3643777.69,4122.73,721477.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','152',4247,'19','1',4341457.92,4343634.19,2176.27,380847.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','152',4248,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','152',4249,'21','2',149957.12,149967.16,10.04,8132.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','152',4250,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','152',4251,'23','2',392653.74,394648.19,1984.45,1607404.50,0.00,0.00,10.00,0.00,0.00),('21','221','5','152',4252,'24','3',409313.86,409313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','152',4253,'25','3',74749.35,75007.14,247.79,206906.32,0.00,0.00,10.00,0.00,0.00),('21','221','5','152',4254,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','152',4255,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','152',4256,'28','1',4102793.33,4105466.48,2673.15,467801.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','153',4257,'1','1',4817922.36,4819651.59,1729.23,302615.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','153',4258,'2','1',5371859.82,5373069.29,1209.47,211657.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','153',4259,'3','1',4550795.76,4551614.63,818.87,143302.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','153',4260,'4','1',5835815.30,5837444.05,1628.75,285031.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','153',4261,'5','1',4189349.29,4193125.37,3776.08,660814.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','153',4262,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','153',4263,'7','1',2526399.20,2527976.62,1577.42,276048.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','153',4264,'8','1',3520844.89,3522806.72,1961.83,343320.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','153',4265,'9','1',5499301.97,5502431.17,3079.20,538860.00,0.00,0.00,50.00,0.00,0.00),('21','221','2','153',4266,'10','1',3825212.45,3828745.27,3532.82,618243.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','153',4267,'11','1',4726415.43,4728381.66,1966.23,344090.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','153',4268,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','153',4269,'13','1',4606851.53,4609530.81,2679.28,468874.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','153',4270,'14','1',3561540.05,3563608.46,2068.41,361971.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','153',4271,'15','1',4229987.55,4232176.67,2189.12,383096.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','153',4272,'16','1',3524733.62,3526288.99,1555.37,272189.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','153',4273,'17','1',3925052.05,3926992.29,1940.24,339542.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','153',4274,'18','1',3643777.69,3645288.98,1511.29,264475.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','153',4275,'19','1',4343634.19,4346300.56,2666.37,466614.75,0.00,0.00,0.00,0.00,0.00),('21','221','4','153',4276,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','153',4277,'21','2',149967.16,149967.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','153',4278,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','153',4279,'23','2',394648.19,396958.47,2310.28,1871326.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','153',4280,'24','3',409313.86,409313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','153',4281,'25','3',75007.14,75393.29,376.15,314081.91,0.00,0.00,10.00,0.00,0.00),('21','221','5','153',4282,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','153',4283,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','153',4284,'28','1',4105466.48,4108063.39,2596.91,454459.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','154',4285,'1','1',4819651.59,4822024.38,2372.79,415238.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','154',4286,'2','1',5373069.29,5375351.32,2282.03,399355.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','154',4287,'3','1',4551614.63,4553538.87,1924.24,336742.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','154',4288,'4','1',5837444.05,5839957.77,2513.72,439901.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','154',4289,'5','1',4193125.37,4196447.14,3321.77,581309.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','154',4290,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','154',4291,'7','1',2527976.62,2530494.66,2518.04,440657.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','154',4292,'8','1',3522806.72,3525429.25,2622.53,458942.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','154',4293,'9','1',5502431.17,5505041.71,2560.54,448094.50,0.00,0.00,50.00,0.00,0.00),('21','221','2','154',4294,'10','1',3828745.27,3833140.46,4395.19,769158.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','154',4295,'11','1',4728381.66,4730925.98,2544.32,445256.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','154',4296,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','154',4297,'13','1',4609530.81,4611831.89,2301.08,402689.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','154',4298,'14','1',3563608.46,3565786.53,2178.07,381162.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','154',4299,'15','1',4232176.67,4234751.40,2574.73,450577.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','154',4300,'16','1',3526288.99,3527821.02,1532.03,268105.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','154',4301,'17','1',3926992.29,3929551.71,2559.42,447898.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','154',4302,'18','1',3645288.98,3648197.34,2908.36,508963.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','154',4303,'19','1',4346300.56,4348216.56,1916.00,335300.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','154',4304,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','154',4305,'21','2',149967.16,151163.57,1196.41,969092.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','154',4306,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','154',4307,'23','2',396958.47,401208.64,4250.17,3442637.70,0.00,0.00,0.00,0.00,0.00),('21','221','5','154',4308,'24','3',409313.86,409718.35,404.49,337745.81,0.00,0.00,0.00,0.00,0.00),('21','221','5','154',4309,'25','3',75393.29,75940.51,537.22,448576.20,0.00,0.00,10.00,0.00,0.00),('21','221','5','154',4310,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','154',4311,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','154',4312,'28','1',4108063.39,4109699.45,1636.06,286310.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','155',4313,'1','1',4822024.38,4825302.75,3278.37,573714.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','155',4314,'2','1',5375351.32,5378449.10,3097.78,542111.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','155',4315,'3','1',4553538.87,4556453.72,2914.85,510098.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','155',4316,'4','1',5839957.77,5842094.44,2136.67,373917.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','155',4317,'5','1',4196447.14,4201263.95,4816.81,842941.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','155',4318,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','155',4319,'7','1',2530494.66,2533191.54,2696.88,471954.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','155',4320,'8','1',3525429.25,3527743.86,2314.61,405056.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','155',4321,'9','1',5505041.71,5508475.84,3384.13,592222.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','155',4322,'10','1',3833140.46,3838531.30,5390.84,943397.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','155',4323,'11','1',4730925.98,4734031.74,3105.76,543508.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','155',4324,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','155',4325,'13','1',4611831.89,4614338.82,2506.93,438712.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','155',4326,'14','1',3565786.53,3568227.51,2440.98,427171.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','155',4327,'15','1',4234751.40,4238599.22,3847.82,673368.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','155',4328,'16','1',3527821.02,3529718.67,1897.65,332088.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','155',4329,'17','1',3929551.71,3933078.64,3526.93,617212.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','155',4330,'18','1',3648197.34,3651019.07,2821.73,493802.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','155',4331,'19','1',4348216.56,4350702.53,2485.97,435044.75,0.00,0.00,0.00,0.00,0.00),('21','221','4','155',4332,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','155',4333,'21','2',151163.57,154828.87,3665.30,2968893.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','155',4334,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','155',4335,'23','2',401208.64,405537.29,4328.65,3506206.50,0.00,0.00,0.00,0.00,0.00),('21','221','5','155',4336,'24','3',409718.35,409718.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','155',4337,'25','3',75940.51,76555.74,595.23,497012.88,0.00,0.00,20.00,0.00,0.00),('21','221','5','155',4338,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','155',4339,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','155',4340,'28','1',4109699.45,4114681.18,4981.73,871802.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','156',4341,'1','1',4825302.75,4826907.94,1605.19,280908.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','156',4342,'2','1',5378449.10,5380153.74,1704.64,298312.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','156',4343,'3','1',4556453.72,4559044.99,2591.27,453472.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','156',4344,'4','1',5842094.44,5843634.39,1539.95,269491.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','156',4345,'5','1',4201263.95,4206420.75,5156.80,902440.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','156',4346,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','156',4347,'7','1',2533191.54,2536303.12,3111.58,544526.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','156',4348,'8','1',3527743.86,3529512.13,1768.27,309447.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','156',4349,'9','1',5508475.84,5511269.40,2743.56,480123.00,0.00,0.00,50.00,0.00,0.00),('21','221','2','156',4350,'10','1',3838531.30,3842608.37,4077.07,713487.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','156',4351,'11','1',4734031.74,4737353.06,3321.32,581231.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','156',4352,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','156',4353,'13','1',4614338.82,4616797.53,2458.71,430274.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','156',4354,'14','1',3568227.51,3570610.64,2383.13,417047.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','156',4355,'15','1',4238599.22,4240216.77,1617.55,283071.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','156',4356,'16','1',3529718.67,3531933.48,2214.81,387591.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','156',4357,'17','1',3933078.64,3935138.31,2059.67,360442.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','156',4358,'18','1',3651019.07,3653898.76,2879.69,503945.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','156',4359,'19','1',4350702.53,4354288.97,3586.44,627627.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','156',4360,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','156',4361,'21','2',154828.87,157143.53,2314.66,1874874.60,0.00,0.00,0.00,0.00,0.00),('21','221','4','156',4362,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','156',4363,'23','2',405537.29,410100.77,4563.48,3696418.80,0.00,0.00,0.00,0.00,0.00),('21','221','5','156',4364,'24','3',409718.35,409718.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','156',4365,'25','3',76555.74,77111.05,535.31,446987.19,0.00,0.00,20.00,0.00,0.00),('21','221','5','156',4366,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','156',4367,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','156',4368,'28','1',4114681.18,4117428.43,2747.25,480768.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','157',4369,'1','1',4826907.94,4829892.90,2984.96,522368.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','157',4370,'2','1',5380153.74,5382784.79,2631.05,460433.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','157',4371,'3','1',4559044.99,4560797.44,1702.45,297928.75,0.00,0.00,50.00,0.00,0.00),('21','221','1','157',4372,'4','1',5843634.39,5846755.63,3121.24,546217.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','157',4373,'5','1',4206420.75,4211085.34,4664.59,816303.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','157',4374,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','157',4375,'7','1',2536303.12,2537806.64,1503.52,263116.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','157',4376,'8','1',3529512.13,3531523.98,2011.85,352073.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','157',4377,'9','1',5511269.40,5515281.29,4011.89,702080.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','157',4378,'10','1',3842608.37,3846262.73,3654.36,639513.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','157',4379,'11','1',4737353.06,4740415.12,3062.06,535860.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','157',4380,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','157',4381,'13','1',4616797.53,4619869.03,3071.50,537512.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','157',4382,'14','1',3570610.64,3572185.75,1575.11,275644.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','157',4383,'15','1',4240216.77,4243337.84,3121.07,546187.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','157',4384,'16','1',3531933.48,3533706.45,1772.97,310269.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','157',4385,'17','1',3935138.31,3938201.73,3063.42,536098.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','157',4386,'18','1',3653898.76,3656409.85,2511.09,439440.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','157',4387,'19','1',4354288.97,4356999.24,2710.27,474297.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','157',4388,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','157',4389,'21','2',157143.53,160432.78,3289.25,2664292.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','157',4390,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','157',4391,'23','2',410100.77,412612.59,2511.82,2034574.20,0.00,0.00,0.00,0.00,0.00),('21','221','5','157',4392,'24','3',409718.35,409718.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','157',4393,'25','3',77111.05,77838.43,717.38,599011.47,0.00,0.00,10.00,0.00,0.00),('21','221','5','157',4394,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','157',4395,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','157',4396,'28','1',4117428.43,4120456.73,3028.30,529952.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','158',4397,'1','1',4829892.90,4833536.48,3643.58,637626.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','158',4398,'2','1',5382784.79,5384239.01,1454.22,254488.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','158',4399,'3','1',4560797.44,4562665.72,1868.28,326949.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','158',4400,'4','1',5846755.63,5850112.97,3357.34,587534.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','158',4401,'5','1',4211085.34,4215708.39,4623.05,809033.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','158',4402,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','158',4403,'7','1',2537806.64,2539958.64,2152.00,376600.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','158',4404,'8','1',3531523.98,3533937.50,2413.52,422366.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','158',4405,'9','1',5515281.29,5517624.95,2343.66,410140.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','158',4406,'10','1',3846262.73,3849035.43,2772.70,485222.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','158',4407,'11','1',4740415.12,4743081.06,2665.94,466539.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','158',4408,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','158',4409,'13','1',4619869.03,4623965.29,4096.26,716845.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','158',4410,'14','1',3572185.75,3573917.10,1731.35,302986.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','158',4411,'15','1',4243337.84,4246232.67,2894.83,506595.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','158',4412,'16','1',3533706.45,3535743.24,1986.79,347688.25,0.00,0.00,50.00,0.00,0.00),('21','221','3','158',4413,'17','1',3938201.73,3941208.90,3007.17,526254.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','158',4414,'18','1',3656409.85,3658652.65,2242.80,392490.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','158',4415,'19','1',4356999.24,4360508.68,3509.44,614152.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','158',4416,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','158',4417,'21','2',160432.78,162364.99,1932.21,1565090.10,0.00,0.00,0.00,0.00,0.00),('21','221','4','158',4418,'22','2',79.38,79.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','158',4419,'23','2',412612.59,414658.33,2045.74,1657049.40,0.00,0.00,0.00,0.00,0.00),('21','221','5','158',4420,'24','3',409718.35,409932.96,204.61,170851.02,0.00,0.00,10.00,0.00,0.00),('21','221','5','158',4421,'25','3',77838.43,78073.21,234.78,196042.14,0.00,0.00,0.00,0.00,0.00),('21','221','5','158',4422,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','158',4423,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','158',4424,'28','1',4120456.73,4123427.45,2970.72,519876.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','159',4425,'1','1',4833536.48,4835439.71,1903.23,333065.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','159',4426,'2','1',5384239.01,5386896.61,2657.60,465080.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','159',4427,'3','1',4562665.72,4564850.61,2134.89,373605.75,0.00,0.00,50.00,0.00,0.00),('21','221','1','159',4428,'4','1',5850112.97,5851966.93,1853.96,324443.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','159',4429,'5','1',4215708.39,4220041.44,4333.05,758283.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','159',4430,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','159',4431,'7','1',2539958.64,2542115.42,2156.78,377436.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','159',4432,'8','1',3533937.50,3535589.55,1652.05,289108.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','159',4433,'9','1',5517624.95,5519816.79,2191.84,383572.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','159',4434,'10','1',3849035.43,3853093.57,4058.14,710174.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','159',4435,'11','1',4743081.06,4746058.50,2977.44,521052.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','159',4436,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','159',4437,'13','1',4623965.29,4626367.76,2402.47,420432.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','159',4438,'14','1',3573917.10,3576519.63,2602.53,455442.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','159',4439,'15','1',4246232.67,4247774.82,1542.15,269876.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','159',4440,'16','1',3535743.24,3536767.10,1023.86,179175.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','159',4441,'17','1',3941208.90,3943999.88,2790.98,488421.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','159',4442,'18','1',3658652.65,3660933.10,2280.45,399078.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','159',4443,'19','1',4360508.68,4363329.53,2820.85,493648.75,0.00,0.00,0.00,0.00,0.00),('21','221','4','159',4444,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','159',4445,'21','2',162364.99,165359.03,2994.04,2425172.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','159',4446,'22','2',79.38,80.75,1.37,1109.70,0.00,0.00,0.00,0.00,0.00),('21','221','4','159',4447,'23','2',414658.33,416261.46,1603.13,1298535.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','159',4448,'24','3',409932.96,410640.69,697.73,582602.04,0.00,0.00,10.00,0.00,0.00),('21','221','5','159',4449,'25','3',78073.21,78073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','159',4450,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','159',4451,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','159',4452,'28','1',4123427.45,4127107.18,3679.73,643952.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','160',4453,'1','1',4835439.71,4835439.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','160',4454,'2','1',5386896.61,5386896.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','160',4455,'3','1',4564850.61,4568515.44,3664.83,641345.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','160',4456,'4','1',5851966.93,5854432.46,2465.53,431467.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','160',4457,'5','1',4220041.44,4224955.83,4914.39,860018.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','160',4458,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','160',4459,'7','1',2542115.42,2544900.21,2784.79,487338.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','160',4460,'8','1',3535589.55,3537181.42,1591.87,278577.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','160',4461,'9','1',5519816.79,5522584.22,2767.43,484300.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','160',4462,'10','1',3853093.57,3856611.59,3518.02,615653.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','160',4463,'11','1',4746058.50,4748743.40,2684.90,469857.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','160',4464,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','160',4465,'13','1',4626367.76,4629444.21,3076.45,538378.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','160',4466,'14','1',3576519.63,3579448.06,2928.43,512475.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','160',4467,'15','1',4247774.82,4250046.11,2271.29,397475.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','160',4468,'16','1',3536767.10,3539367.32,2600.22,455038.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','160',4469,'17','1',3943999.88,3946021.21,2021.33,353732.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','160',4470,'18','1',3660933.10,3663810.98,2877.88,503629.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','160',4471,'19','1',4363329.53,4365648.09,2318.56,405748.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','160',4472,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','160',4473,'21','2',165359.03,165376.48,17.45,14134.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','160',4474,'22','2',80.75,80.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','160',4475,'23','2',416261.46,416861.52,600.06,486048.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','160',4476,'24','3',410640.69,411084.52,433.83,362243.88,0.00,0.00,10.00,0.00,0.00),('21','221','5','160',4477,'25','3',78073.21,78073.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','160',4478,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','160',4479,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','160',4480,'28','1',4127107.18,4130053.15,2895.97,506794.75,0.00,0.00,50.00,0.00,0.00),('21','221','1','161',4481,'1','1',4835439.71,4835571.72,132.01,23101.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','161',4482,'2','1',5386896.61,5386896.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','161',4483,'3','1',4568515.44,4570544.52,2029.08,355089.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','161',4484,'4','1',5854432.46,5857043.67,2611.21,456961.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','161',4485,'5','1',4224955.83,4229503.55,4547.72,795851.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','161',4486,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','161',4487,'7','1',2544900.21,2546818.89,1918.68,335769.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','161',4488,'8','1',3537181.42,3540314.84,3133.42,548348.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','161',4489,'9','1',5522584.22,5526139.07,3504.85,613348.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','161',4490,'10','1',3856611.59,3860805.47,4193.88,733929.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','161',4491,'11','1',4748743.40,4750453.09,1709.69,299195.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','161',4492,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','161',4493,'13','1',4629444.21,4633030.62,3586.41,627621.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','161',4494,'14','1',3579448.06,3580647.88,1199.82,209968.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','161',4495,'15','1',4250046.11,4253057.25,3011.14,526949.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','161',4496,'16','1',3539367.32,3541613.16,2245.84,393022.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','161',4497,'17','1',3946021.21,3948471.38,2450.17,428779.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','161',4498,'18','1',3663810.98,3666128.33,2317.35,405536.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','161',4499,'19','1',4365648.09,4368755.55,3107.46,543805.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','161',4500,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','161',4501,'21','2',165376.48,167719.83,2343.35,1898113.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','161',4502,'22','2',80.75,80.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','161',4503,'23','2',416861.52,418275.23,1413.71,1145105.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','161',4504,'24','3',411084.52,411610.09,515.57,430503.45,0.00,0.00,10.00,0.00,0.00),('21','221','5','161',4505,'25','3',78073.21,78105.65,32.44,27088.23,0.00,0.00,0.00,0.00,0.00),('21','221','5','161',4506,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','161',4507,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','161',4508,'28','1',4130053.15,4133115.54,3062.39,535918.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','162',4509,'1','1',4835571.72,4837471.74,1900.02,332503.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','162',4510,'2','1',5386896.61,5389133.74,2237.13,391497.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','162',4511,'3','1',4570544.52,4573638.97,3094.45,541528.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','162',4512,'4','1',5857043.67,5861174.71,4131.04,722932.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','162',4513,'5','1',4229503.55,4233163.21,3659.66,640440.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','162',4514,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','162',4515,'7','1',2546818.89,2549245.79,2426.90,424707.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','162',4516,'8','1',3540314.84,3542153.96,1839.12,321846.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','162',4517,'9','1',5526139.07,5528822.99,2633.92,460936.00,0.00,0.00,50.00,0.00,0.00),('21','221','2','162',4518,'10','1',3860805.47,3865334.21,4528.74,792529.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','162',4519,'11','1',4750453.09,4753262.64,2809.55,491671.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','162',4520,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','162',4521,'13','1',4633030.62,4636159.63,3129.01,547576.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','162',4522,'14','1',3580647.88,3583141.41,2493.53,436367.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','162',4523,'15','1',4253057.25,4255521.60,2464.35,431261.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','162',4524,'16','1',3541613.16,3543759.37,2146.21,375586.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','162',4525,'17','1',3948471.38,3950899.82,2428.44,424977.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','162',4526,'18','1',3666128.33,3668839.42,2711.09,474440.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','162',4527,'19','1',4368755.55,4371350.21,2594.66,454065.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','162',4528,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','162',4529,'21','2',167719.83,169648.11,1928.28,1561906.80,0.00,0.00,0.00,0.00,0.00),('21','221','4','162',4530,'22','2',80.75,80.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','162',4531,'23','2',418275.23,419164.16,888.93,720033.30,0.00,0.00,0.00,0.00,0.00),('21','221','5','162',4532,'24','3',411610.09,412046.01,425.92,355639.86,0.00,0.00,10.00,0.00,0.00),('21','221','5','162',4533,'25','3',78105.65,78115.84,10.19,8505.31,0.00,0.00,0.00,0.00,0.00),('21','221','5','162',4534,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','162',4535,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','162',4536,'28','1',4133115.54,4135564.50,2448.96,428568.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','163',4537,'1','1',4837471.74,4840288.04,2816.30,492852.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','163',4538,'2','1',5389133.74,5391866.76,2733.02,478278.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','163',4539,'3','1',4573638.97,4575613.13,1974.16,345478.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','163',4540,'4','1',5861174.71,5863820.93,2646.22,463088.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','163',4541,'5','1',4233163.21,4237819.14,4655.93,814787.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','163',4542,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','163',4543,'7','1',2549245.79,2551832.25,2586.46,452630.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','163',4544,'8','1',3542153.96,3543937.33,1783.37,312089.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','163',4545,'9','1',5528822.99,5531897.86,3024.87,529352.25,0.00,0.00,50.00,0.00,0.00),('21','221','2','163',4546,'10','1',3865334.21,3869723.72,4389.51,768164.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','163',4547,'11','1',4753262.64,4755968.46,2705.82,473518.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','163',4548,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','163',4549,'13','1',4636159.63,4638600.91,2441.28,427224.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','163',4550,'14','1',3583141.41,3585966.15,2824.74,494329.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','163',4551,'15','1',4255521.60,4258186.79,2665.19,466408.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','163',4552,'16','1',3543759.37,3544730.18,970.81,169891.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','163',4553,'17','1',3950899.82,3954233.00,3333.18,583306.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','163',4554,'18','1',3668839.42,3671735.13,2895.71,506749.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','163',4555,'19','1',4371350.21,4374683.63,3333.42,583348.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','163',4556,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','163',4557,'21','2',169648.11,175732.61,6084.50,4928445.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','163',4558,'22','2',80.75,226.79,146.04,118292.40,0.00,0.00,0.00,0.00,0.00),('21','221','4','163',4559,'23','2',419164.16,429666.67,10502.51,8507033.10,0.00,0.00,0.00,0.00,0.00),('21','221','5','163',4560,'24','3',412046.01,412693.40,637.39,532223.15,0.00,0.00,10.00,0.00,0.00),('21','221','5','163',4561,'25','3',78115.84,78115.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','163',4562,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','163',4563,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','163',4564,'28','1',4135564.50,4138057.78,2493.28,436324.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','164',4565,'1','1',4840288.04,4842422.39,2134.35,373511.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','164',4566,'2','1',5391866.76,5394148.08,2281.32,399231.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','164',4567,'3','1',4575613.13,4577579.15,1966.02,344053.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','164',4568,'4','1',5863820.93,5866054.23,2233.30,390827.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','164',4569,'5','1',4237819.14,4241562.34,3743.20,655060.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','164',4570,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','164',4571,'7','1',2551832.25,2554367.66,2535.41,443696.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','164',4572,'8','1',3543937.33,3545431.01,1493.68,261394.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','164',4573,'9','1',5531897.86,5533916.17,2018.31,353204.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','164',4574,'10','1',3869723.72,3873265.85,3542.13,619872.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','164',4575,'11','1',4755968.46,4758385.00,2416.54,422894.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','164',4576,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','164',4577,'13','1',4638600.91,4641475.48,2874.57,503049.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','164',4578,'14','1',3585966.15,3588525.08,2508.93,439062.75,0.00,0.00,50.00,0.00,0.00),('21','221','3','164',4579,'15','1',4258186.79,4260671.84,2485.05,434883.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','164',4580,'16','1',3544730.18,3547161.12,2430.94,425414.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','164',4581,'17','1',3954233.00,3956196.99,1963.99,343698.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','164',4582,'18','1',3671735.13,3674039.75,2304.62,403308.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','164',4583,'19','1',4374683.63,4377579.41,2895.78,506761.50,0.00,0.00,0.00,0.00,0.00),('21','221','4','164',4584,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','164',4585,'21','2',175732.61,178026.30,2293.69,1834952.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','164',4586,'22','2',226.79,226.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','164',4587,'23','2',429666.67,433016.66,3349.99,2679993.60,0.00,0.00,0.00,0.00,0.00),('21','221','5','164',4588,'24','3',412693.40,413161.39,457.99,393871.40,0.00,0.00,10.00,0.00,0.00),('21','221','5','164',4589,'25','3',78115.84,78126.07,10.23,8793.50,0.00,0.00,0.00,0.00,0.00),('21','221','5','164',4590,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','164',4591,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','164',4592,'28','1',4138057.78,4141155.75,3097.97,542144.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','165',4593,'1','1',4842422.39,4843624.45,1202.06,210360.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','165',4594,'2','1',5394148.08,5396783.35,2635.27,461172.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','165',4595,'3','1',4577579.15,4579941.45,2362.30,413402.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','165',4596,'4','1',5866054.23,5867784.47,1680.24,294042.00,0.00,0.00,50.00,0.00,0.00),('21','221','2','165',4597,'5','1',4241562.34,4246830.36,5268.02,921903.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','165',4598,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','165',4599,'7','1',2554367.66,2558732.51,4364.85,763848.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','165',4600,'8','1',3545431.01,3548069.35,2638.34,461709.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','165',4601,'9','1',5533916.17,5534868.59,952.42,166673.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','165',4602,'10','1',3873265.85,3876675.72,3409.87,596727.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','165',4603,'11','1',4758385.00,4760383.95,1998.95,349816.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','165',4604,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','165',4605,'13','1',4641475.48,4644175.63,2700.15,472526.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','165',4606,'14','1',3588525.08,3591246.31,2721.23,476215.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','165',4607,'15','1',4260671.84,4263037.11,2365.27,413922.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','165',4608,'16','1',3547161.12,3548451.46,1290.34,225809.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','165',4609,'17','1',3956196.99,3958341.50,2144.51,375289.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','165',4610,'18','1',3674039.75,3676230.03,2190.28,383299.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','165',4611,'19','1',4377579.41,4380232.78,2653.37,464339.75,0.00,0.00,0.00,0.00,0.00),('21','221','4','165',4612,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','165',4613,'21','2',178026.30,179520.60,1494.30,1195440.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','165',4614,'22','2',226.79,238.44,11.65,9320.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','165',4615,'23','2',433016.66,434572.37,1555.71,1244568.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','165',4616,'24','3',413161.39,413544.50,373.11,320876.32,0.00,0.00,10.00,0.00,0.00),('21','221','5','165',4617,'25','3',78126.07,78149.36,23.29,20031.12,0.00,0.00,0.00,0.00,0.00),('21','221','5','165',4618,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','165',4619,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','165',4620,'28','1',4141155.75,4143610.91,2455.16,429653.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','166',4621,'1','1',4843624.45,4846493.79,2869.34,502134.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','166',4622,'2','1',5396783.35,5399217.39,2434.04,425957.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','166',4623,'3','1',4579941.45,4582195.57,2254.12,394471.00,0.00,0.00,0.00,0.00,0.00),('21','221','1','166',4624,'4','1',5867784.47,5871130.11,3345.64,585487.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','166',4625,'5','1',4246830.36,4251130.57,4300.21,752536.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','166',4626,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','166',4627,'7','1',2558732.51,2560857.05,2124.54,371794.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','166',4628,'8','1',3548069.35,3550204.25,2134.90,373607.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','166',4629,'9','1',5534868.59,5536127.67,1209.08,211589.00,0.00,0.00,50.00,0.00,0.00),('21','221','2','166',4630,'10','1',3876675.72,3880834.63,4158.91,727809.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','166',4631,'11','1',4760383.95,4763496.53,3112.58,544701.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','166',4632,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','166',4633,'13','1',4644175.63,4647831.13,3655.50,639712.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','166',4634,'14','1',3591246.31,3593193.21,1946.90,340707.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','166',4635,'15','1',4263037.11,4265914.79,2877.68,503594.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','166',4636,'16','1',3548451.46,3551348.54,2897.08,506989.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','166',4637,'17','1',3958341.50,3960585.31,2243.81,392666.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','166',4638,'18','1',3676230.03,3678781.52,2551.49,446510.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','166',4639,'19','1',4380232.78,4382851.43,2618.65,458263.75,0.00,0.00,0.00,0.00,0.00),('21','221','4','166',4640,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','166',4641,'21','2',179520.60,180869.14,1348.54,1078832.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','166',4642,'22','2',238.44,238.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','166',4643,'23','2',434572.37,435944.03,1371.66,1097328.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','166',4644,'24','3',413544.50,413923.87,369.37,317655.62,0.00,0.00,10.00,0.00,0.00),('21','221','5','166',4645,'25','3',78149.36,78149.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','166',4646,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','166',4647,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','166',4648,'28','1',4143610.91,4146617.22,3006.31,526104.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','167',4649,'1','1',4846493.79,4849005.00,2511.21,439461.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','167',4650,'2','1',5399217.39,5401710.82,2493.43,436350.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','167',4651,'3','1',4582195.57,4584589.62,2394.05,418958.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','167',4652,'4','1',5871130.11,5872250.98,1120.87,196152.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','167',4653,'5','1',4251130.57,4255334.20,4203.63,735635.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','167',4654,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','167',4655,'7','1',2560857.05,2563213.00,2355.95,412291.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','167',4656,'8','1',3550204.25,3551806.68,1602.43,280425.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','167',4657,'9','1',5536127.67,5538905.76,2728.09,477415.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','167',4658,'10','1',3880834.63,3884173.90,3339.27,584372.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','167',4659,'11','1',4763496.53,4765800.85,2304.32,403256.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','167',4660,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','167',4661,'13','1',4647831.13,4650703.06,2871.93,502587.75,0.00,0.00,0.00,0.00,0.00),('21','221','3','167',4662,'14','1',3593193.21,3596475.35,3282.14,574374.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','167',4663,'15','1',4265914.79,4267372.89,1458.10,255167.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','167',4664,'16','1',3551348.54,3553038.58,1690.04,295757.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','167',4665,'17','1',3960585.31,3964403.67,3818.36,668213.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','167',4666,'18','1',3678781.52,3680350.03,1568.51,274489.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','167',4667,'19','1',4382851.43,4384824.30,1972.87,345252.25,0.00,0.00,0.00,0.00,0.00),('21','221','4','167',4668,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','167',4669,'21','2',180869.14,182578.10,1708.96,1367168.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','167',4670,'22','2',238.44,238.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','167',4671,'23','2',435944.03,436568.79,624.76,499808.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','167',4672,'24','3',413923.87,414235.45,301.58,259362.24,0.00,0.00,10.00,0.00,0.00),('21','221','5','167',4673,'25','3',78149.36,78149.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','167',4674,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','167',4675,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','167',4676,'28','1',4146617.22,4149636.81,3019.59,528428.25,0.00,0.00,0.00,0.00,0.00),('21','221','1','168',4677,'1','1',4849005.00,4851057.69,2052.69,359220.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','168',4678,'2','1',5401710.82,5404186.19,2475.37,433189.75,0.00,0.00,0.00,0.00,0.00),('21','221','1','168',4679,'3','1',4584589.62,4586403.80,1814.18,317481.50,0.00,0.00,0.00,0.00,0.00),('21','221','1','168',4680,'4','1',5872250.98,5874089.67,1838.69,321770.75,0.00,0.00,0.00,0.00,0.00),('21','221','2','168',4681,'5','1',4255334.20,4259410.48,4076.28,713349.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','168',4682,'6','1',4839654.80,4839654.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','2','168',4683,'7','1',2563213.00,2564942.79,1729.79,302713.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','168',4684,'8','1',3551806.68,3554104.90,2298.22,402188.50,0.00,0.00,0.00,0.00,0.00),('21','221','2','168',4685,'9','1',5538905.76,5542439.29,3483.53,609617.75,0.00,0.00,50.00,0.00,0.00),('21','221','2','168',4686,'10','1',3884173.90,3888419.33,4245.43,742950.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','168',4687,'11','1',4765800.85,4768368.88,2568.03,449405.25,0.00,0.00,0.00,0.00,0.00),('21','221','2','168',4688,'12','1',3478399.07,3478399.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','168',4689,'13','1',4650703.06,4653677.21,2974.15,520476.25,0.00,0.00,0.00,0.00,0.00),('21','221','3','168',4690,'14','1',3596475.35,3598879.13,2403.78,420661.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','168',4691,'15','1',4267372.89,4269852.13,2479.24,433867.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','168',4692,'16','1',3553038.58,3555290.48,2251.90,394082.50,0.00,0.00,0.00,0.00,0.00),('21','221','3','168',4693,'17','1',3964403.67,3966996.71,2593.04,453782.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','168',4694,'18','1',3680350.03,3682829.83,2479.80,433965.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','168',4695,'19','1',4384824.30,4386127.10,1302.80,227990.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','168',4696,'20','2',2299015.40,2299015.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','168',4697,'21','2',182578.10,184810.83,2232.73,1786184.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','168',4698,'22','2',238.44,258.84,20.40,16320.00,0.00,0.00,0.00,0.00,0.00),('21','221','4','168',4699,'23','2',436568.79,438069.50,1500.71,1200568.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','168',4700,'24','3',414235.45,414825.13,579.68,498525.66,0.00,0.00,10.00,0.00,0.00),('21','221','5','168',4701,'25','3',78149.36,78161.87,12.51,10756.02,0.00,0.00,0.00,0.00,0.00),('21','221','5','168',4702,'26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','5','168',4703,'27','3',3376.17,3376.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','221','3','168',4704,'28','1',4149636.81,4151739.40,2102.59,367953.25,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=505 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','221','1','1',165.00,165.00,64526.19,0.00,0.00,0.00,0.00,1),('21','221','1','2',700.00,700.00,15411.08,0.00,0.00,0.00,0.00,2),('21','221','1','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,3),('21','221','2','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,4),('21','221','2','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,5),('21','221','2','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,6),('21','221','3','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,7),('21','221','3','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,8),('21','221','3','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,9),('21','221','4','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,10),('21','221','4','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,11),('21','221','4','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,12),('21','221','5','2',700.00,700.00,10341.46,0.00,0.00,0.00,0.00,13),('21','221','5','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,14),('21','221','5','1',165.00,165.00,53764.42,0.00,0.00,0.00,0.00,15),('21','221','6','1',165.00,165.00,69276.06,0.00,0.00,0.00,0.00,16),('21','221','6','2',700.00,700.00,13317.40,0.00,0.00,0.00,0.00,17),('21','221','6','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,18),('21','221','7','1',165.00,165.00,51754.35,0.00,0.00,0.00,0.00,19),('21','221','7','2',700.00,700.00,5889.33,0.00,0.00,0.00,0.00,20),('21','221','7','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,21),('21','221','8','1',165.00,165.00,67865.74,0.00,0.00,0.00,0.00,22),('21','221','8','2',700.00,700.00,542.59,0.00,0.00,0.00,0.00,23),('21','221','8','3',550.00,550.00,791.61,0.00,0.00,0.00,0.00,24),('21','221','9','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,25),('21','221','9','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,26),('21','221','9','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,27),('21','221','10','1',165.00,165.00,40959.58,0.00,0.00,0.00,0.00,28),('21','221','10','2',700.00,700.00,422.18,0.00,0.00,0.00,0.00,29),('21','221','10','3',550.00,550.00,2988.69,0.00,0.00,0.00,0.00,30),('21','221','11','1',165.00,165.00,46220.17,0.00,0.00,0.00,0.00,31),('21','221','11','2',700.00,700.00,25897.97,0.00,0.00,0.00,0.00,32),('21','221','11','3',550.00,550.00,754.79,0.00,0.00,0.00,0.00,33),('21','221','12','1',165.00,165.00,81275.95,0.00,0.00,0.00,0.00,34),('21','221','12','2',700.00,700.00,3969.75,0.00,0.00,0.00,0.00,35),('21','221','12','3',550.00,550.00,1233.75,0.00,0.00,0.00,0.00,36),('21','221','13','1',165.00,165.00,70158.59,0.00,0.00,0.00,0.00,37),('21','221','13','2',700.00,700.00,7883.79,0.00,0.00,0.00,0.00,38),('21','221','13','3',550.00,550.00,1095.29,0.00,0.00,0.00,0.00,39),('21','221','14','1',165.00,165.00,55789.01,0.00,0.00,0.00,0.00,40),('21','221','14','2',700.00,700.00,17791.61,0.00,0.00,0.00,0.00,41),('21','221','14','3',550.00,550.00,1010.04,0.00,0.00,0.00,0.00,42),('21','221','15','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,43),('21','221','15','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,44),('21','221','15','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,45),('21','221','16','1',165.00,165.00,42885.30,0.00,0.00,0.00,0.00,46),('21','221','16','2',700.00,700.00,13647.11,0.00,0.00,0.00,0.00,47),('21','221','16','3',550.00,550.00,1034.61,0.00,0.00,0.00,0.00,48),('21','221','17','1',165.00,165.00,55357.12,0.00,0.00,0.00,0.00,49),('21','221','17','2',700.00,700.00,10345.86,0.00,0.00,0.00,0.00,50),('21','221','17','3',550.00,550.00,1056.12,0.00,0.00,0.00,0.00,51),('21','221','18','1',165.00,165.00,54773.73,0.00,0.00,0.00,0.00,52),('21','221','18','2',700.00,700.00,24132.05,0.00,0.00,0.00,0.00,53),('21','221','18','3',550.00,550.00,820.51,0.00,0.00,0.00,0.00,54),('21','221','19','1',165.00,165.00,44761.39,0.00,0.00,0.00,0.00,55),('21','221','19','2',700.00,700.00,11634.09,0.00,0.00,0.00,0.00,56),('21','221','19','3',550.00,550.00,1559.44,0.00,0.00,0.00,0.00,57),('21','221','20','1',165.00,165.00,74211.40,0.00,0.00,0.00,0.00,58),('21','221','20','2',700.00,700.00,12229.79,0.00,0.00,0.00,0.00,59),('21','221','20','3',550.00,550.00,1648.30,0.00,0.00,0.00,0.00,60),('21','221','21','1',165.00,165.00,69353.68,0.00,0.00,0.00,0.00,61),('21','221','21','2',700.00,700.00,11262.26,0.00,0.00,0.00,0.00,62),('21','221','21','3',550.00,550.00,905.72,0.00,0.00,0.00,0.00,63),('21','221','22','1',165.00,165.00,59029.62,0.00,0.00,0.00,0.00,64),('21','221','22','2',700.00,700.00,16312.67,0.00,0.00,0.00,0.00,65),('21','221','22','3',550.00,550.00,503.19,0.00,0.00,0.00,0.00,66),('21','221','23','2',700.00,700.00,12081.85,0.00,0.00,0.00,0.00,67),('21','221','23','3',550.00,550.00,484.02,0.00,0.00,0.00,0.00,68),('21','221','23','1',165.00,165.00,51884.21,0.00,0.00,0.00,0.00,69),('21','221','24','1',165.00,165.00,59784.02,0.00,0.00,0.00,0.00,70),('21','221','24','2',700.00,700.00,18001.23,0.00,0.00,0.00,0.00,71),('21','221','24','3',550.00,550.00,921.99,0.00,0.00,0.00,0.00,72),('21','221','25','1',165.00,165.00,60145.06,0.00,0.00,0.00,0.00,73),('21','221','25','2',700.00,700.00,8579.30,0.00,0.00,0.00,0.00,74),('21','221','25','3',550.00,550.00,748.77,0.00,0.00,0.00,0.00,75),('21','221','26','1',165.00,165.00,59802.02,0.00,0.00,0.00,0.00,76),('21','221','26','2',700.00,700.00,14305.00,0.00,0.00,0.00,0.00,77),('21','221','26','3',550.00,550.00,1162.57,0.00,0.00,0.00,0.00,78),('21','221','27','1',165.00,165.00,60522.57,0.00,0.00,0.00,0.00,79),('21','221','27','2',700.00,700.00,13744.73,0.00,0.00,0.00,0.00,80),('21','221','27','3',550.00,550.00,1465.93,0.00,0.00,0.00,0.00,81),('21','221','28','1',165.00,165.00,60114.78,0.00,0.00,0.00,0.00,82),('21','221','28','2',700.00,700.00,13078.37,0.00,0.00,0.00,0.00,83),('21','221','28','3',550.00,550.00,806.55,0.00,0.00,0.00,0.00,84),('21','221','29','1',165.00,165.00,59562.67,0.00,0.00,0.00,0.00,85),('21','221','29','2',700.00,700.00,12584.16,0.00,0.00,0.00,0.00,86),('21','221','29','3',550.00,550.00,1038.84,0.00,0.00,0.00,0.00,87),('21','221','30','2',700.00,700.00,11185.24,0.00,0.00,0.00,0.00,88),('21','221','30','3',550.00,550.00,891.20,0.00,0.00,0.00,0.00,89),('21','221','30','1',165.00,165.00,60149.50,0.00,0.00,0.00,0.00,90),('21','221','31','1',165.00,165.00,49801.44,0.00,0.00,0.00,0.00,91),('21','221','31','2',700.00,700.00,9626.90,0.00,0.00,0.00,0.00,92),('21','221','31','3',550.00,550.00,1072.12,0.00,0.00,0.00,0.00,93),('21','221','32','1',165.00,165.00,60210.64,0.00,0.00,0.00,0.00,94),('21','221','32','2',700.00,700.00,5514.39,0.00,0.00,0.00,0.00,95),('21','221','32','3',550.00,550.00,653.27,0.00,0.00,0.00,0.00,96),('21','221','33','1',165.00,165.00,53285.91,0.00,0.00,0.00,0.00,97),('21','221','33','2',700.00,700.00,5966.56,0.00,0.00,0.00,0.00,98),('21','221','33','3',550.00,550.00,576.15,0.00,0.00,0.00,0.00,99),('21','221','34','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,100),('21','221','34','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,101),('21','221','34','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,102),('21','221','35','2',700.00,700.00,1928.69,0.00,0.00,0.00,0.00,103),('21','221','35','3',550.00,550.00,1072.93,0.00,0.00,0.00,0.00,104),('21','221','35','1',165.00,165.00,67242.87,0.00,0.00,0.00,0.00,105),('21','221','36','1',165.00,165.00,68359.33,0.00,0.00,0.00,0.00,106),('21','221','36','2',700.00,700.00,9861.40,0.00,0.00,0.00,0.00,107),('21','221','36','3',550.00,550.00,840.86,0.00,0.00,0.00,0.00,108),('21','221','37','1',165.00,165.00,66408.89,0.00,0.00,0.00,0.00,109),('21','221','37','2',700.00,700.00,9557.32,0.00,0.00,0.00,0.00,110),('21','221','37','3',550.00,550.00,921.77,0.00,0.00,0.00,0.00,111),('21','221','38','1',165.00,165.00,70416.16,0.00,0.00,0.00,0.00,112),('21','221','38','2',700.00,700.00,6499.01,0.00,0.00,0.00,0.00,113),('21','221','38','3',550.00,550.00,702.57,0.00,0.00,0.00,0.00,114),('21','221','39','1',165.00,165.00,59357.05,0.00,0.00,0.00,0.00,115),('21','221','39','2',700.00,700.00,6856.98,0.00,0.00,0.00,0.00,116),('21','221','39','3',550.00,550.00,939.50,0.00,0.00,0.00,0.00,117),('21','221','40','1',165.00,165.00,55852.71,0.00,0.00,0.00,0.00,118),('21','221','40','2',700.00,700.00,11675.53,0.00,0.00,0.00,0.00,119),('21','221','40','3',550.00,550.00,652.28,0.00,0.00,0.00,0.00,120),('21','221','41','1',165.00,165.00,59256.26,0.00,0.00,0.00,0.00,121),('21','221','41','2',700.00,700.00,10776.40,0.00,0.00,0.00,0.00,122),('21','221','41','3',550.00,550.00,823.42,0.00,0.00,0.00,0.00,123),('21','221','42','1',165.00,165.00,60837.83,0.00,0.00,0.00,0.00,124),('21','221','42','2',700.00,700.00,6831.67,0.00,0.00,0.00,0.00,125),('21','221','42','3',550.00,550.00,946.70,0.00,0.00,0.00,0.00,126),('21','221','43','2',700.00,700.00,10246.96,0.00,0.00,0.00,0.00,127),('21','221','43','3',550.00,550.00,1160.16,0.00,0.00,0.00,0.00,128),('21','221','43','1',165.00,165.00,81742.63,0.00,0.00,0.00,0.00,129),('21','221','44','1',165.00,165.00,59594.07,0.00,0.00,0.00,0.00,130),('21','221','44','2',700.00,700.00,6598.35,0.00,0.00,0.00,0.00,131),('21','221','44','3',550.00,550.00,1115.08,0.00,0.00,0.00,0.00,132),('21','221','45','1',165.00,165.00,59861.21,0.00,0.00,0.00,0.00,133),('21','221','45','2',700.00,700.00,7178.12,0.00,0.00,0.00,0.00,134),('21','221','45','3',550.00,550.00,4950.11,0.00,0.00,0.00,0.00,135),('21','221','46','2',700.00,700.00,8334.61,0.00,0.00,0.00,0.00,136),('21','221','46','3',550.00,550.00,5390.71,0.00,0.00,0.00,0.00,137),('21','221','46','1',165.00,165.00,55860.82,0.00,0.00,0.00,0.00,138),('21','221','47','1',165.00,165.00,48569.65,0.00,0.00,0.00,0.00,139),('21','221','47','2',700.00,700.00,6051.22,0.00,0.00,0.00,0.00,140),('21','221','47','3',550.00,550.00,910.99,0.00,0.00,0.00,0.00,141),('21','221','48','1',165.00,165.00,39972.29,0.00,0.00,0.00,0.00,142),('21','221','48','2',700.00,700.00,8858.34,0.00,0.00,0.00,0.00,143),('21','221','48','3',550.00,550.00,2150.61,0.00,0.00,0.00,0.00,144),('21','221','49','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,145),('21','221','49','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,146),('21','221','49','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,147),('21','221','50','1',165.00,165.00,29829.55,0.00,0.00,0.00,0.00,148),('21','221','50','2',700.00,700.00,6904.79,0.00,0.00,0.00,0.00,149),('21','221','50','3',550.00,550.00,17976.66,0.00,0.00,0.00,0.00,150),('21','221','51','1',165.00,165.00,57719.19,0.00,0.00,0.00,0.00,151),('21','221','51','2',700.00,700.00,4740.68,0.00,0.00,0.00,0.00,152),('21','221','51','3',550.00,550.00,1136.77,0.00,0.00,0.00,0.00,153),('21','221','52','1',165.00,165.00,75941.63,0.00,0.00,0.00,0.00,154),('21','221','52','2',700.00,700.00,10610.48,0.00,0.00,0.00,0.00,155),('21','221','52','3',550.00,550.00,872.97,0.00,0.00,0.00,0.00,156),('21','221','53','1',165.00,165.00,71632.06,0.00,0.00,0.00,0.00,157),('21','221','53','2',700.00,700.00,8067.71,0.00,0.00,0.00,0.00,158),('21','221','53','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,159),('21','221','54','1',165.00,165.00,65224.05,0.00,0.00,0.00,0.00,160),('21','221','54','2',700.00,700.00,7025.33,0.00,0.00,0.00,0.00,161),('21','221','54','3',650.00,650.00,674.39,0.00,0.00,0.00,0.00,162),('21','221','55','1',165.00,165.00,50198.48,0.00,0.00,0.00,0.00,163),('21','221','55','2',700.00,700.00,6213.89,0.00,0.00,0.00,0.00,164),('21','221','55','3',650.00,650.00,655.85,0.00,0.00,0.00,0.00,165),('21','221','56','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,166),('21','221','56','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,167),('21','221','56','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,168),('21','221','57','2',700.00,700.00,11895.84,0.00,0.00,0.00,0.00,169),('21','221','57','3',650.00,650.00,975.21,0.00,0.00,0.00,0.00,170),('21','221','57','1',165.00,165.00,67886.62,0.00,0.00,0.00,0.00,171),('21','221','58','2',700.00,700.00,13240.15,0.00,0.00,0.00,0.00,172),('21','221','58','3',650.00,650.00,1174.24,0.00,0.00,0.00,0.00,173),('21','221','58','1',165.00,165.00,88663.26,0.00,0.00,0.00,0.00,174),('21','221','59','1',165.00,165.00,65538.50,0.00,0.00,0.00,0.00,175),('21','221','59','2',700.00,700.00,4360.26,0.00,0.00,0.00,0.00,176),('21','221','59','3',650.00,650.00,1224.31,0.00,0.00,0.00,0.00,177),('21','221','60','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,178),('21','221','60','2',720.00,720.00,0.00,0.00,0.00,0.00,0.00,179),('21','221','60','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,180),('21','221','61','1',165.00,165.00,45853.04,0.00,0.00,0.00,0.00,181),('21','221','61','2',700.00,700.00,13936.70,0.00,0.00,0.00,0.00,182),('21','221','61','3',650.00,650.00,1311.67,0.00,0.00,0.00,0.00,183),('21','221','62','1',165.00,165.00,85587.83,0.00,0.00,0.00,0.00,184),('21','221','62','2',700.00,700.00,15760.50,0.00,0.00,0.00,0.00,185),('21','221','62','3',650.00,650.00,871.13,0.00,0.00,0.00,0.00,186),('21','221','63','2',720.00,720.00,18687.24,0.00,0.00,0.00,0.00,187),('21','221','63','3',650.00,650.00,3626.95,0.00,0.00,0.00,0.00,188),('21','221','63','1',165.00,165.00,69083.94,0.00,0.00,0.00,0.00,189),('21','221','64','1',165.00,165.00,107452.38,0.00,0.00,0.00,0.00,190),('21','221','64','2',720.00,720.00,16001.94,0.00,0.00,0.00,0.00,191),('21','221','64','3',650.00,650.00,153.44,0.00,0.00,0.00,0.00,192),('21','221','65','1',165.00,165.00,90009.03,0.00,0.00,0.00,0.00,193),('21','221','65','2',720.00,720.00,18591.88,0.00,0.00,0.00,0.00,194),('21','221','65','3',650.00,650.00,549.26,0.00,0.00,0.00,0.00,195),('21','221','66','2',720.00,720.00,16247.48,0.00,0.00,0.00,0.00,196),('21','221','66','3',650.00,650.00,1129.97,0.00,0.00,0.00,0.00,197),('21','221','66','1',165.00,165.00,86108.38,0.00,0.00,0.00,0.00,198),('21','221','67','1',165.00,165.00,69623.59,0.00,0.00,0.00,0.00,199),('21','221','67','2',720.00,720.00,4577.34,0.00,0.00,0.00,0.00,200),('21','221','67','3',650.00,650.00,1032.53,0.00,0.00,0.00,0.00,201),('21','221','68','1',165.00,165.00,64208.76,0.00,0.00,0.00,0.00,202),('21','221','68','2',720.00,720.00,14080.40,0.00,0.00,0.00,0.00,203),('21','221','68','3',650.00,650.00,787.05,0.00,0.00,0.00,0.00,204),('21','221','69','1',165.00,165.00,34921.85,0.00,0.00,0.00,0.00,205),('21','221','69','2',720.00,720.00,14933.36,0.00,0.00,0.00,0.00,206),('21','221','69','3',650.00,650.00,853.12,0.00,0.00,0.00,0.00,207),('21','221','70','1',165.00,165.00,52153.20,0.00,0.00,0.00,0.00,208),('21','221','70','2',720.00,720.00,12762.89,0.00,0.00,0.00,0.00,209),('21','221','70','3',650.00,650.00,819.62,0.00,0.00,0.00,0.00,210),('21','221','71','1',165.00,165.00,48001.01,0.00,0.00,0.00,0.00,211),('21','221','71','2',720.00,720.00,11055.97,0.00,0.00,0.00,0.00,212),('21','221','71','3',650.00,650.00,697.50,0.00,0.00,0.00,0.00,213),('21','221','72','1',165.00,165.00,59995.30,0.00,0.00,0.00,0.00,214),('21','221','72','2',760.00,760.00,23259.76,0.00,0.00,0.00,0.00,215),('21','221','72','3',650.00,650.00,951.67,0.00,0.00,0.00,0.00,216),('21','221','73','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,217),('21','221','73','2',760.00,760.00,0.00,0.00,0.00,0.00,0.00,218),('21','221','73','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,219),('21','221','74','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,220),('21','221','74','2',760.00,760.00,6413.20,0.00,0.00,0.00,0.00,221),('21','221','74','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,222),('21','221','75','1',165.00,165.00,60105.06,0.00,0.00,0.00,0.00,223),('21','221','75','2',760.00,760.00,9408.45,0.00,0.00,0.00,0.00,224),('21','221','75','3',650.00,650.00,15358.78,0.00,0.00,0.00,0.00,225),('21','221','76','2',760.00,760.00,19141.69,0.00,0.00,0.00,0.00,226),('21','221','76','3',650.00,650.00,743.88,0.00,0.00,0.00,0.00,227),('21','221','76','1',165.00,165.00,59722.06,0.00,0.00,0.00,0.00,228),('21','221','77','1',165.00,165.00,81943.57,0.00,0.00,0.00,0.00,229),('21','221','77','2',760.00,760.00,12649.37,0.00,0.00,0.00,0.00,230),('21','221','77','3',650.00,650.00,866.17,0.00,0.00,0.00,0.00,231),('21','221','78','2',760.00,760.00,10512.55,0.00,0.00,0.00,0.00,232),('21','221','78','3',650.00,650.00,714.80,0.00,0.00,0.00,0.00,233),('21','221','78','1',165.00,165.00,54990.76,0.00,0.00,0.00,0.00,234),('21','221','79','1',165.00,165.00,39249.64,0.00,0.00,0.00,0.00,235),('21','221','79','2',760.00,760.00,14139.66,0.00,0.00,0.00,0.00,236),('21','221','79','3',650.00,650.00,207.07,0.00,0.00,0.00,0.00,237),('21','221','80','1',165.00,165.00,49428.31,0.00,0.00,0.00,0.00,238),('21','221','80','2',760.00,760.00,13899.88,0.00,0.00,0.00,0.00,239),('21','221','80','3',650.00,650.00,143.25,0.00,0.00,0.00,0.00,240),('21','221','81','2',760.00,760.00,10810.89,0.00,0.00,0.00,0.00,241),('21','221','81','3',650.00,650.00,370.16,0.00,0.00,0.00,0.00,242),('21','221','81','1',165.00,165.00,62730.05,0.00,0.00,0.00,0.00,243),('21','221','82','1',165.00,165.00,63409.69,0.00,0.00,0.00,0.00,244),('21','221','82','2',760.00,760.00,9072.65,0.00,0.00,0.00,0.00,245),('21','221','82','3',650.00,650.00,1099.35,0.00,0.00,0.00,0.00,246),('21','221','83','1',165.00,165.00,60578.32,0.00,0.00,0.00,0.00,247),('21','221','83','2',760.00,760.00,15779.15,0.00,0.00,0.00,0.00,248),('21','221','83','3',650.00,650.00,1084.47,0.00,0.00,0.00,0.00,249),('21','221','84','1',165.00,165.00,60063.57,0.00,0.00,0.00,0.00,250),('21','221','84','2',760.00,760.00,12889.39,0.00,0.00,0.00,0.00,251),('21','221','84','3',650.00,650.00,1236.94,0.00,0.00,0.00,0.00,252),('21','221','85','1',165.00,165.00,85756.51,0.00,0.00,0.00,0.00,253),('21','221','85','2',760.00,760.00,17266.85,0.00,0.00,0.00,0.00,254),('21','221','85','3',650.00,650.00,1814.54,0.00,0.00,0.00,0.00,255),('21','221','86','1',165.00,165.00,54652.32,0.00,0.00,0.00,0.00,256),('21','221','86','2',780.00,760.00,9450.71,0.00,0.00,0.00,0.00,257),('21','221','86','3',650.00,650.00,1634.58,0.00,0.00,0.00,0.00,258),('21','221','87','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,259),('21','221','87','2',780.00,780.00,8430.25,0.00,0.00,0.00,0.00,260),('21','221','87','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,261),('21','221','88','1',165.00,165.00,29669.38,0.00,0.00,0.00,0.00,262),('21','221','88','2',780.00,780.00,18013.89,0.00,0.00,0.00,0.00,263),('21','221','88','3',650.00,650.00,852.83,0.00,0.00,0.00,0.00,264),('21','221','89','1',165.00,165.00,61306.91,0.00,0.00,0.00,0.00,265),('21','221','89','2',780.00,780.00,15647.59,0.00,0.00,0.00,0.00,266),('21','221','89','3',650.00,650.00,2350.77,0.00,0.00,0.00,0.00,267),('21','221','90','1',165.00,165.00,89015.99,0.00,0.00,0.00,0.00,268),('21','221','90','2',780.00,780.00,16378.36,0.00,0.00,0.00,0.00,269),('21','221','90','3',650.00,650.00,1403.67,0.00,0.00,0.00,0.00,270),('21','221','91','2',800.00,800.00,11833.25,0.00,0.00,0.00,0.00,271),('21','221','91','3',700.00,700.00,927.48,0.00,0.00,0.00,0.00,272),('21','221','91','1',165.00,165.00,88105.57,0.00,0.00,0.00,0.00,273),('21','221','92','1',165.00,165.00,63508.29,0.00,0.00,0.00,0.00,274),('21','221','92','2',800.00,800.00,21122.58,0.00,0.00,0.00,0.00,275),('21','221','92','3',700.00,700.00,1712.76,0.00,0.00,0.00,0.00,276),('21','221','93','2',800.00,800.00,4067.44,0.00,0.00,0.00,0.00,277),('21','221','93','3',700.00,700.00,874.15,0.00,0.00,0.00,0.00,278),('21','221','93','1',165.00,165.00,20090.00,0.00,0.00,0.00,0.00,279),('21','221','94','2',800.00,800.00,17039.10,0.00,0.00,0.00,0.00,280),('21','221','94','3',700.00,700.00,878.82,0.00,0.00,0.00,0.00,281),('21','221','94','1',165.00,165.00,63094.17,0.00,0.00,0.00,0.00,282),('21','221','95','1',165.00,165.00,47537.88,0.00,0.00,0.00,0.00,283),('21','221','95','2',800.00,800.00,7299.30,0.00,0.00,0.00,0.00,284),('21','221','95','3',700.00,700.00,218.22,0.00,0.00,0.00,0.00,285),('21','221','96','1',165.00,165.00,50606.54,0.00,0.00,0.00,0.00,286),('21','221','96','2',820.00,820.00,11345.17,0.00,0.00,0.00,0.00,287),('21','221','96','3',750.00,750.00,321.95,0.00,0.00,0.00,0.00,288),('21','221','97','1',165.00,165.00,50567.32,0.00,0.00,0.00,0.00,289),('21','221','97','2',820.00,820.00,15423.18,0.00,0.00,0.00,0.00,290),('21','221','97','3',750.00,750.00,916.43,0.00,0.00,0.00,0.00,291),('21','221','98','1',165.00,165.00,21012.43,0.00,0.00,0.00,0.00,292),('21','221','98','2',820.00,820.00,10939.09,0.00,0.00,0.00,0.00,293),('21','221','98','3',750.00,750.00,856.03,0.00,0.00,0.00,0.00,294),('21','221','99','1',165.00,165.00,81376.90,0.00,0.00,0.00,0.00,295),('21','221','99','2',820.00,820.00,18770.48,0.00,0.00,0.00,0.00,296),('21','221','99','3',750.00,750.00,798.65,0.00,0.00,0.00,0.00,297),('21','221','100','1',165.00,165.00,65930.29,0.00,0.00,0.00,0.00,298),('21','221','100','2',830.00,830.00,6630.60,0.00,0.00,0.00,0.00,299),('21','221','100','3',750.00,750.00,841.62,0.00,0.00,0.00,0.00,300),('21','221','101','1',165.00,165.00,44599.29,0.00,0.00,0.00,0.00,301),('21','221','101','2',830.00,830.00,9551.45,0.00,0.00,0.00,0.00,302),('21','221','101','3',750.00,750.00,778.38,0.00,0.00,0.00,0.00,303),('21','221','102','1',165.00,165.00,45633.81,0.00,0.00,0.00,0.00,304),('21','221','102','2',830.00,830.00,3329.93,0.00,0.00,0.00,0.00,305),('21','221','102','3',750.00,750.00,546.91,0.00,0.00,0.00,0.00,306),('21','221','103','1',165.00,165.00,50426.79,0.00,0.00,0.00,0.00,307),('21','221','103','2',830.00,830.00,11532.25,0.00,0.00,0.00,0.00,308),('21','221','103','3',750.00,750.00,713.34,0.00,0.00,0.00,0.00,309),('21','221','104','1',165.00,165.00,50370.40,0.00,0.00,0.00,0.00,310),('21','221','104','2',830.00,830.00,6782.59,0.00,0.00,0.00,0.00,311),('21','221','104','3',750.00,750.00,930.26,0.00,0.00,0.00,0.00,312),('21','221','105','1',165.00,165.00,49648.84,0.00,0.00,0.00,0.00,313),('21','221','105','2',830.00,830.00,6559.56,0.00,0.00,0.00,0.00,314),('21','221','105','3',750.00,750.00,712.31,0.00,0.00,0.00,0.00,315),('21','221','106','1',165.00,165.00,45881.41,0.00,0.00,0.00,0.00,316),('21','221','106','2',830.00,830.00,9901.70,0.00,0.00,0.00,0.00,317),('21','221','106','3',750.00,750.00,610.14,0.00,0.00,0.00,0.00,318),('21','221','107','1',165.00,165.00,58797.00,0.00,0.00,0.00,0.00,319),('21','221','107','2',830.00,830.00,5788.51,0.00,0.00,0.00,0.00,320),('21','221','107','3',750.00,750.00,587.48,0.00,0.00,0.00,0.00,321),('21','221','108','1',165.00,165.00,30502.46,0.00,0.00,0.00,0.00,322),('21','221','108','2',830.00,830.00,9944.72,0.00,0.00,0.00,0.00,323),('21','221','108','3',750.00,750.00,735.69,0.00,0.00,0.00,0.00,324),('21','221','109','1',165.00,165.00,64178.58,0.00,0.00,0.00,0.00,325),('21','221','109','2',830.00,830.00,4232.37,0.00,0.00,0.00,0.00,326),('21','221','109','3',750.00,750.00,584.06,0.00,0.00,0.00,0.00,327),('21','221','110','1',165.00,165.00,49734.71,0.00,0.00,0.00,0.00,328),('21','221','110','2',830.00,830.00,8429.42,0.00,0.00,0.00,0.00,329),('21','221','110','3',750.00,750.00,776.24,0.00,0.00,0.00,0.00,330),('21','221','111','1',165.00,165.00,46244.62,0.00,0.00,0.00,0.00,331),('21','221','111','2',830.00,830.00,10493.60,0.00,0.00,0.00,0.00,332),('21','221','111','3',750.00,750.00,712.01,0.00,0.00,0.00,0.00,333),('21','221','112','1',165.00,165.00,50193.70,0.00,0.00,0.00,0.00,334),('21','221','112','2',830.00,830.00,9063.58,0.00,0.00,0.00,0.00,335),('21','221','112','3',750.00,750.00,536.89,0.00,0.00,0.00,0.00,336),('21','221','113','1',165.00,165.00,67252.38,0.00,0.00,0.00,0.00,337),('21','221','113','2',830.00,830.00,9703.17,0.00,0.00,0.00,0.00,338),('21','221','113','3',750.00,750.00,745.54,0.00,0.00,0.00,0.00,339),('21','221','114','1',165.00,165.00,41667.88,0.00,0.00,0.00,0.00,340),('21','221','114','2',830.00,830.00,9594.85,0.00,0.00,0.00,0.00,341),('21','221','114','3',750.00,750.00,658.83,0.00,0.00,0.00,0.00,342),('21','221','115','1',165.00,165.00,49852.75,0.00,0.00,0.00,0.00,343),('21','221','115','2',830.00,830.00,9748.87,0.00,0.00,0.00,0.00,344),('21','221','115','3',750.00,750.00,908.40,0.00,0.00,0.00,0.00,345),('21','221','116','1',165.00,165.00,47424.62,0.00,0.00,0.00,0.00,346),('21','221','116','2',830.00,830.00,14769.14,0.00,0.00,0.00,0.00,347),('21','221','116','3',750.00,750.00,705.88,0.00,0.00,0.00,0.00,348),('21','221','117','1',165.00,165.00,76686.08,0.00,0.00,0.00,0.00,349),('21','221','117','2',830.00,830.00,8732.53,0.00,0.00,0.00,0.00,350),('21','221','117','3',750.00,750.00,866.00,0.00,0.00,0.00,0.00,351),('21','221','118','1',165.00,165.00,67944.93,0.00,0.00,0.00,0.00,352),('21','221','118','2',830.00,830.00,9073.06,0.00,0.00,0.00,0.00,353),('21','221','118','3',750.00,750.00,559.03,0.00,0.00,0.00,0.00,354),('21','221','119','1',165.00,165.00,60987.41,0.00,0.00,0.00,0.00,355),('21','221','119','2',830.00,830.00,6526.40,0.00,0.00,0.00,0.00,356),('21','221','119','3',750.00,750.00,723.85,0.00,0.00,0.00,0.00,357),('21','221','120','1',165.00,165.00,45292.18,0.00,0.00,0.00,0.00,358),('21','221','120','2',830.00,830.00,3106.83,0.00,0.00,0.00,0.00,359),('21','221','120','3',750.00,750.00,695.90,0.00,0.00,0.00,0.00,360),('21','221','121','1',165.00,165.00,88053.00,0.00,0.00,0.00,0.00,361),('21','221','121','2',830.00,830.00,5985.12,0.00,0.00,0.00,0.00,362),('21','221','121','3',750.00,750.00,939.50,0.00,0.00,0.00,0.00,363),('21','221','122','1',165.00,165.00,21849.89,0.00,0.00,0.00,0.00,364),('21','221','122','2',830.00,830.00,4179.11,0.00,0.00,0.00,0.00,365),('21','221','122','3',750.00,750.00,652.95,0.00,0.00,0.00,0.00,366),('21','221','123','1',165.00,165.00,56628.36,0.00,0.00,0.00,0.00,367),('21','221','123','2',830.00,830.00,1522.62,0.00,0.00,0.00,0.00,368),('21','221','123','3',750.00,750.00,400.67,0.00,0.00,0.00,0.00,369),('21','221','124','1',165.00,165.00,60920.91,0.00,0.00,0.00,0.00,370),('21','221','124','2',830.00,830.00,2972.33,0.00,0.00,0.00,0.00,371),('21','221','124','3',750.00,750.00,713.14,0.00,0.00,0.00,0.00,372),('21','221','125','1',185.00,185.00,81948.25,0.00,0.00,0.00,0.00,373),('21','221','125','2',830.00,830.00,4082.82,0.00,0.00,0.00,0.00,374),('21','221','125','3',750.00,750.00,559.03,0.00,0.00,0.00,0.00,375),('21','221','126','1',165.00,165.00,104359.79,0.00,0.00,0.00,0.00,376),('21','221','126','2',830.00,830.00,4231.51,0.00,0.00,0.00,0.00,377),('21','221','126','3',750.00,750.00,672.52,0.00,0.00,0.00,0.00,378),('21','221','127','1',165.00,165.00,87275.01,0.00,0.00,0.00,0.00,379),('21','221','127','2',830.00,830.00,6125.10,0.00,0.00,0.00,0.00,380),('21','221','127','3',750.00,750.00,382.25,0.00,0.00,0.00,0.00,381),('21','221','128','1',185.00,185.00,68599.30,0.00,0.00,0.00,0.00,382),('21','221','128','2',830.00,830.00,21671.63,0.00,0.00,0.00,0.00,383),('21','221','128','3',750.00,750.00,508.20,0.00,0.00,0.00,0.00,384),('21','221','129','1',185.00,185.00,69042.25,0.00,0.00,0.00,0.00,385),('21','221','129','2',830.00,830.00,10346.37,0.00,0.00,0.00,0.00,386),('21','221','129','3',750.00,750.00,456.96,0.00,0.00,0.00,0.00,387),('21','221','130','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,388),('21','221','130','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,389),('21','221','130','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,390),('21','221','131','1',175.00,175.00,54897.35,0.00,0.00,0.00,0.00,391),('21','221','131','2',830.00,830.00,2248.45,0.00,0.00,0.00,0.00,392),('21','221','131','3',750.00,750.00,293.90,0.00,0.00,0.00,0.00,393),('21','221','132','1',185.00,175.00,78557.06,0.00,0.00,0.00,0.00,394),('21','221','132','2',830.00,830.00,3942.24,0.00,0.00,0.00,0.00,395),('21','221','132','3',750.00,750.00,576.71,0.00,0.00,0.00,0.00,396),('21','221','133','1',185.00,175.00,82275.67,0.00,0.00,0.00,0.00,397),('21','221','133','2',830.00,830.00,8056.92,0.00,0.00,0.00,0.00,398),('21','221','133','3',750.00,750.00,541.15,0.00,0.00,0.00,0.00,399),('21','221','134','1',175.00,175.00,54986.74,0.00,0.00,0.00,0.00,400),('21','221','134','2',830.00,830.00,5841.78,0.00,0.00,0.00,0.00,401),('21','221','134','3',750.00,750.00,589.82,0.00,0.00,0.00,0.00,402),('21','221','135','1',175.00,175.00,60809.32,0.00,0.00,0.00,0.00,403),('21','221','135','2',830.00,830.00,4346.47,0.00,0.00,0.00,0.00,404),('21','221','135','3',750.00,750.00,688.43,0.00,0.00,0.00,0.00,405),('21','221','136','1',175.00,175.00,44466.37,0.00,0.00,0.00,0.00,406),('21','221','136','2',830.00,815.00,2208.41,0.00,0.00,0.00,0.00,407),('21','221','136','3',750.00,750.00,474.02,0.00,0.00,0.00,0.00,408),('21','221','137','1',175.00,175.00,89903.76,0.00,0.00,0.00,0.00,409),('21','221','137','2',830.00,815.00,3058.55,0.00,0.00,0.00,0.00,410),('21','221','137','3',750.00,750.00,1024.00,0.00,0.00,0.00,0.00,411),('21','221','138','1',175.00,175.00,62701.31,0.00,0.00,0.00,0.00,412),('21','221','138','2',830.00,815.00,1495.81,0.00,0.00,0.00,0.00,413),('21','221','138','3',750.00,750.00,477.39,0.00,0.00,0.00,0.00,414),('21','221','139','1',175.00,175.00,59744.62,0.00,0.00,0.00,0.00,415),('21','221','139','2',830.00,815.00,4812.57,0.00,0.00,0.00,0.00,416),('21','221','139','3',750.00,750.00,567.53,0.00,0.00,0.00,0.00,417),('21','221','140','1',175.00,175.00,14510.20,0.00,0.00,0.00,0.00,418),('21','221','140','2',810.00,810.00,1633.76,0.00,0.00,0.00,0.00,419),('21','221','140','3',750.00,750.00,518.26,0.00,0.00,0.00,0.00,420),('21','221','141','1',175.00,175.00,49839.61,0.00,0.00,0.00,0.00,421),('21','221','141','2',810.00,810.00,5826.34,0.00,0.00,0.00,0.00,422),('21','221','141','3',835.00,835.00,500.29,0.00,0.00,0.00,0.00,423),('21','221','142','1',175.00,175.00,49819.08,0.00,0.00,0.00,0.00,424),('21','221','142','2',810.00,810.00,5182.75,0.00,0.00,0.00,0.00,425),('21','221','142','3',835.00,835.00,595.72,0.00,0.00,0.00,0.00,426),('21','221','143','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,427),('21','221','143','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,428),('21','221','143','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,429),('21','221','144','1',175.00,175.00,68738.05,0.00,0.00,0.00,0.00,430),('21','221','144','2',810.00,810.00,4404.53,0.00,0.00,0.00,0.00,431),('21','221','144','3',835.00,835.00,471.95,0.00,0.00,0.00,0.00,432),('21','221','145','1',175.00,175.00,51922.50,0.00,0.00,0.00,0.00,433),('21','221','145','2',810.00,810.00,2015.19,0.00,0.00,0.00,0.00,434),('21','221','145','3',835.00,835.00,786.78,0.00,0.00,0.00,0.00,435),('21','221','146','1',175.00,175.00,50108.67,0.00,0.00,0.00,0.00,436),('21','221','146','2',810.00,810.00,2530.62,0.00,0.00,0.00,0.00,437),('21','221','146','3',835.00,835.00,366.37,0.00,0.00,0.00,0.00,438),('21','221','147','1',175.00,175.00,60378.76,0.00,0.00,0.00,0.00,439),('21','221','147','2',810.00,810.00,2998.10,0.00,0.00,0.00,0.00,440),('21','221','147','3',835.00,835.00,738.12,0.00,0.00,0.00,0.00,441),('21','221','148','1',175.00,175.00,49967.28,0.00,0.00,0.00,0.00,442),('21','221','148','2',810.00,810.00,2385.94,0.00,0.00,0.00,0.00,443),('21','221','148','3',835.00,835.00,632.37,0.00,0.00,0.00,0.00,444),('21','221','149','1',175.00,175.00,48307.65,0.00,0.00,0.00,0.00,445),('21','221','149','2',810.00,810.00,2956.94,0.00,0.00,0.00,0.00,446),('21','221','149','3',835.00,835.00,727.95,0.00,0.00,0.00,0.00,447),('21','221','150','1',175.00,175.00,45174.93,0.00,0.00,0.00,0.00,448),('21','221','150','2',810.00,810.00,4662.97,0.00,0.00,0.00,0.00,449),('21','221','150','3',835.00,835.00,619.37,0.00,0.00,0.00,0.00,450),('21','221','151','2',810.00,810.00,2628.48,0.00,0.00,0.00,0.00,451),('21','221','151','3',835.00,835.00,494.56,0.00,0.00,0.00,0.00,452),('21','221','151','1',175.00,175.00,45387.85,0.00,0.00,0.00,0.00,453),('21','221','152','1',175.00,175.00,57011.80,0.00,0.00,0.00,0.00,454),('21','221','152','2',810.00,810.00,1994.49,0.00,0.00,0.00,0.00,455),('21','221','152','3',835.00,835.00,247.79,0.00,0.00,0.00,0.00,456),('21','221','153','1',175.00,175.00,38486.89,0.00,0.00,0.00,0.00,457),('21','221','153','2',810.00,810.00,2310.28,0.00,0.00,0.00,0.00,458),('21','221','153','3',835.00,835.00,376.15,0.00,0.00,0.00,0.00,459),('21','221','154','1',175.00,175.00,44660.92,0.00,0.00,0.00,0.00,460),('21','221','154','2',810.00,810.00,5446.58,0.00,0.00,0.00,0.00,461),('21','221','154','3',835.00,835.00,941.70,0.00,0.00,0.00,0.00,462),('21','221','155','1',175.00,175.00,57646.44,0.00,0.00,0.00,0.00,463),('21','221','155','2',810.00,810.00,7993.95,0.00,0.00,0.00,0.00,464),('21','221','155','3',835.00,835.00,595.23,0.00,0.00,0.00,0.00,465),('21','221','156','1',175.00,175.00,47566.90,0.00,0.00,0.00,0.00,466),('21','221','156','2',810.00,810.00,6878.14,0.00,0.00,0.00,0.00,467),('21','221','156','3',835.00,835.00,535.31,0.00,0.00,0.00,0.00,468),('21','221','157','1',175.00,175.00,50201.70,0.00,0.00,0.00,0.00,469),('21','221','157','2',810.00,810.00,5801.07,0.00,0.00,0.00,0.00,470),('21','221','157','3',835.00,835.00,717.38,0.00,0.00,0.00,0.00,471),('21','221','158','1',175.00,175.00,49733.65,0.00,0.00,0.00,0.00,472),('21','221','158','2',810.00,810.00,3977.95,0.00,0.00,0.00,0.00,473),('21','221','158','3',835.00,835.00,439.39,0.00,0.00,0.00,0.00,474),('21','221','159','1',175.00,175.00,45062.00,0.00,0.00,0.00,0.00,475),('21','221','159','2',810.00,810.00,4598.54,0.00,0.00,0.00,0.00,476),('21','221','159','3',835.00,835.00,697.73,0.00,0.00,0.00,0.00,477),('21','221','160','2',810.00,810.00,617.51,0.00,0.00,0.00,0.00,478),('21','221','160','3',835.00,835.00,433.83,0.00,0.00,0.00,0.00,479),('21','221','160','1',175.00,175.00,45381.89,0.00,0.00,0.00,0.00,480),('21','221','161','1',175.00,175.00,44761.12,0.00,0.00,0.00,0.00,481),('21','221','161','2',810.00,810.00,3757.06,0.00,0.00,0.00,0.00,482),('21','221','161','3',835.00,835.00,548.01,0.00,0.00,0.00,0.00,483),('21','221','162','1',175.00,175.00,49676.78,0.00,0.00,0.00,0.00,484),('21','221','162','2',810.00,810.00,2817.21,0.00,0.00,0.00,0.00,485),('21','221','162','3',835.00,835.00,436.10,0.00,0.00,0.00,0.00,486),('21','221','163','1',175.00,175.00,50273.27,0.00,0.00,0.00,0.00,487),('21','221','163','2',810.00,810.00,16733.05,0.00,0.00,0.00,0.00,488),('21','221','163','3',835.00,835.00,637.39,0.00,0.00,0.00,0.00,489),('21','221','164','1',175.00,175.00,44926.11,0.00,0.00,0.00,0.00,490),('21','221','164','2',800.00,800.00,5643.68,0.00,0.00,0.00,0.00,491),('21','221','164','3',860.00,860.00,468.22,0.00,0.00,0.00,0.00,492),('21','221','165','1',175.00,175.00,45032.63,0.00,0.00,0.00,0.00,493),('21','221','165','2',800.00,800.00,3061.66,0.00,0.00,0.00,0.00,494),('21','221','165','3',860.00,860.00,396.40,0.00,0.00,0.00,0.00,495),('21','221','166','1',175.00,175.00,49740.78,0.00,0.00,0.00,0.00,496),('21','221','166','2',800.00,800.00,2720.20,0.00,0.00,0.00,0.00,497),('21','221','166','3',860.00,860.00,369.37,0.00,0.00,0.00,0.00,498),('21','221','167','1',175.00,175.00,44734.79,0.00,0.00,0.00,0.00,499),('21','221','167','2',800.00,800.00,2333.72,0.00,0.00,0.00,0.00,500),('21','221','167','3',860.00,860.00,301.58,0.00,0.00,0.00,0.00,501),('21','221','168','1',175.00,175.00,45169.51,0.00,0.00,0.00,0.00,502),('21','221','168','2',800.00,800.00,3753.84,0.00,0.00,0.00,0.00,503),('21','221','168','3',860.00,860.00,592.19,0.00,0.00,0.00,0.00,504);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'221','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCTS');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','221','1',1,0,'1','PMS TANK 1',45000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 16:50:31','2022-03-03 16:50:31','764',5,0),('21','221','1',2,0,'1','PMS TANK 2 & 3',90000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 16:53:22','2022-03-03 17:01:46','764',5,0),('21','221','1',3,0,'1','PMS TANK 4 & 5',90000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 16:59:42','2022-04-05 09:46:23','764',5,0),('21','221','1',4,0,'2','AGO TANK',45000.00,0.00,NULL,'TANK CONTAINING DEISEL PRODUCTS','764','2022-03-03 17:17:51','2022-03-03 17:17:51','764',5,0),('21','221','1',5,0,'3','DPK TANK ',45000.00,0.00,NULL,'TANK CONTAINING KEROSINE PRODUCTS','764','2022-03-03 17:27:28','2022-03-03 17:27:28','764',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4771 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,17465000.00,24950.00,0.00,0.00,'2022-03-22 12:44:21','',''),(2,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,924000.00,5600.00,0.00,0.00,'2022-03-22 12:46:08','',''),(3,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,552750.00,3350.00,0.00,0.00,'2022-03-22 12:46:34','',''),(4,'21','221',NULL,2,'Reception corrector for bridging 1',0.00,0.00,0.00,24950.00,0.00,'2022-03-22 12:52:21','',''),(5,'21','221','4',2,'Received from bridging 1',0.00,0.00,24950.00,0.00,0.00,'2022-03-22 12:52:21','',''),(6,'21','221',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,5600.00,0.00,'2022-03-22 12:55:14','',''),(7,'21','221','2',1,'Received from bridging 2',0.00,0.00,5600.00,0.00,0.00,'2022-03-22 12:55:14','',''),(8,'21','221',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,3350.00,0.00,'2022-03-22 12:57:42','',''),(9,'21','221','1',1,'Received from bridging 3',0.00,0.00,3350.00,0.00,0.00,'2022-03-22 12:57:42','',''),(10,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-03-22 18:22:00','',''),(11,'21','221',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,23400.00,0.00,'2022-03-22 18:29:50','',''),(12,'21','221','3',1,'Received from bridging 6',0.00,0.00,23400.00,0.00,0.00,'2022-03-22 18:29:50','',''),(13,'21','221',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,23300.00,0.00,'2022-03-22 18:29:50','',''),(14,'21','221','2',1,'Received from bridging 5',0.00,0.00,23300.00,0.00,0.00,'2022-03-22 18:29:50','',''),(15,'21','221',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,13300.00,0.00,'2022-03-22 18:29:50','',''),(16,'21','221','1',1,'Received from bridging 4',0.00,0.00,13300.00,0.00,0.00,'2022-03-22 18:29:50','',''),(17,'21','221','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,28900.00,0.00,'2022-03-22 19:31:36','',''),(18,'21','221','2',0,'Inventory adjustment from tank dipping to 32000',0.00,0.00,32000.00,0.00,0.00,'2022-03-22 19:31:36','',''),(19,'21','221','1',1,'Sale Id shift 1',0.00,0.00,0.00,2566.19,0.00,'2022-03-22 20:47:36','',''),(20,'21','221','1',1,'Sale Id shift 1',0.00,0.00,0.00,2966.90,0.00,'2022-03-22 20:47:36','',''),(21,'21','221','1',1,'Sale Id shift 1',0.00,0.00,0.00,2627.32,0.00,'2022-03-22 20:47:36','',''),(22,'21','221','1',1,'Sale Id shift 1',0.00,0.00,0.00,2636.52,0.00,'2022-03-22 20:47:36','',''),(23,'21','221','2',1,'Sale Id shift 1',0.00,0.00,0.00,29.42,0.00,'2022-03-22 20:47:36','',''),(24,'21','221','2',1,'Sale Id shift 1',0.00,0.00,0.00,6030.06,0.00,'2022-03-22 20:47:36','',''),(25,'21','221','2',1,'Sale Id shift 1',0.00,0.00,0.00,3769.41,0.00,'2022-03-22 20:47:36','',''),(26,'21','221','2',1,'Sale Id shift 1',0.00,0.00,0.00,4559.55,0.00,'2022-03-22 20:47:36','',''),(27,'21','221','2',1,'Sale Id shift 1',0.00,0.00,0.00,2800.59,0.00,'2022-03-22 20:47:36','',''),(28,'21','221','2',1,'Sale Id shift 1',0.00,0.00,0.00,8226.14,0.00,'2022-03-22 20:47:36','',''),(29,'21','221','2',1,'Sale Id shift 1',0.00,0.00,0.00,5918.03,0.00,'2022-03-22 20:47:36','',''),(30,'21','221','3',1,'Sale Id shift 1',0.00,0.00,0.00,3412.27,0.00,'2022-03-22 20:47:36','',''),(31,'21','221','3',1,'Sale Id shift 1',0.00,0.00,0.00,3015.65,0.00,'2022-03-22 20:47:36','',''),(32,'21','221','3',1,'Sale Id shift 1',0.00,0.00,0.00,106.23,0.00,'2022-03-22 20:47:36','',''),(33,'21','221','3',1,'Sale Id shift 1',0.00,0.00,0.00,4404.35,0.00,'2022-03-22 20:47:36','',''),(34,'21','221','3',1,'Sale Id shift 1',0.00,0.00,0.00,2935.84,0.00,'2022-03-22 20:47:36','',''),(35,'21','221','3',1,'Sale Id shift 1',0.00,0.00,0.00,3217.36,0.00,'2022-03-22 20:47:36','',''),(36,'21','221','3',1,'Sale Id shift 1',0.00,0.00,0.00,2688.22,0.00,'2022-03-22 20:47:36','',''),(37,'21','221','4',2,'Sale Id shift 1',0.00,0.00,0.00,7833.36,0.00,'2022-03-22 20:47:36','',''),(38,'21','221','4',2,'Sale Id shift 1',0.00,0.00,0.00,7577.72,0.00,'2022-03-22 20:47:36','',''),(39,'21','221','3',1,'Sale Id shift 1',0.00,0.00,0.00,2616.14,0.00,'2022-03-22 20:47:36','',''),(40,'21','221',NULL,1,'Sale Id shift 1',10646821.35,0.00,0.00,0.00,0.00,'2022-03-22 20:47:36','',''),(41,'21','221',NULL,2,'Sale Id shift 1',10787756.00,0.00,0.00,0.00,0.00,'2022-03-22 20:47:36','',''),(42,'21','221','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,5853.07,0.00,'2022-03-23 13:29:42','',''),(43,'21','221','1',0,'Inventory adjustment from tank dipping to 7353',0.00,0.00,7353.00,0.00,0.00,'2022-03-23 13:29:42','',''),(44,'21','221','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,666.80,0.00,'2022-03-23 13:30:21','',''),(45,'21','221','2',0,'Inventory adjustment from tank dipping to 3467',0.00,0.00,3467.00,0.00,0.00,'2022-03-23 13:30:21','',''),(46,'21','221','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,1003.94,0.00,'2022-03-23 13:30:57','',''),(47,'21','221','3',0,'Inventory adjustment from tank dipping to 4604',0.00,0.00,4604.00,0.00,0.00,'2022-03-23 13:30:57','',''),(48,'21','221','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,9538.92,0.00,'2022-03-23 13:31:41','',''),(49,'21','221','4',0,'Inventory adjustment from tank dipping to 9739',0.00,0.00,9739.00,0.00,0.00,'2022-03-23 13:31:41','',''),(50,'21','221','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 13:32:00','',''),(51,'21','221','5',0,'Inventory adjustment from tank dipping to 600',0.00,0.00,600.00,0.00,0.00,'2022-03-23 13:32:00','',''),(52,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-24 14:32:28','',''),(53,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-24 14:45:06','',''),(54,'21','221',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,15000.00,0.00,'2022-03-24 14:47:16','',''),(55,'21','221','3',1,'Received from bridging 10',0.00,0.00,15000.00,0.00,0.00,'2022-03-24 14:47:16','',''),(56,'21','221',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,30000.00,0.00,'2022-03-24 14:47:16','',''),(57,'21','221','1',1,'Received from bridging 9',0.00,0.00,30000.00,0.00,0.00,'2022-03-24 14:47:16','',''),(58,'21','221',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,15000.00,0.00,'2022-03-24 14:47:43','',''),(59,'21','221','3',1,'Received from bridging 8',0.00,0.00,15000.00,0.00,0.00,'2022-03-24 14:47:43','',''),(60,'21','221',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,30000.00,0.00,'2022-03-24 14:47:43','',''),(61,'21','221','2',1,'Received from bridging 7',0.00,0.00,30000.00,0.00,0.00,'2022-03-24 14:47:43','',''),(62,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,22960000.00,32800.00,0.00,0.00,'2022-03-24 14:49:32','',''),(63,'21','221',NULL,2,'Reception corrector for bridging 11',0.00,0.00,0.00,32800.00,0.00,'2022-03-24 14:52:31','',''),(64,'21','221','4',2,'Received from bridging 11',0.00,0.00,32800.00,0.00,0.00,'2022-03-24 14:52:31','',''),(65,'21','221','3',1,'Returned bridging 8',0.00,0.00,0.00,15000.00,0.00,'2022-03-24 15:09:21','',''),(66,'21','221',NULL,1,'Reception Return corrector for bridging 8',0.00,0.00,15000.00,0.00,0.00,'2022-03-24 15:09:21','',''),(67,'21','221','2',1,'Returned bridging 7',0.00,0.00,0.00,30000.00,0.00,'2022-03-24 15:10:08','',''),(68,'21','221',NULL,1,'Reception Return corrector for bridging 7',0.00,0.00,30000.00,0.00,0.00,'2022-03-24 15:10:08','',''),(69,'21','221',NULL,1,'Returned purchase #6 to AYM SHAFA NIGERIA. LTD',7425000.00,0.00,0.00,45000.00,0.00,'2022-03-24 15:10:50','',''),(70,'21','221','3',1,'Returned bridging 10',0.00,0.00,0.00,15000.00,0.00,'2022-03-24 15:33:34','',''),(71,'21','221',NULL,1,'Reception Return corrector for bridging 10',0.00,0.00,15000.00,0.00,0.00,'2022-03-24 15:33:34','',''),(72,'21','221','1',1,'Returned bridging 9',0.00,0.00,0.00,30000.00,0.00,'2022-03-24 15:34:05','',''),(73,'21','221',NULL,1,'Reception Return corrector for bridging 9',0.00,0.00,30000.00,0.00,0.00,'2022-03-24 15:34:05','',''),(74,'21','221','4',2,'Returned bridging 11',0.00,0.00,0.00,32800.00,0.00,'2022-03-24 15:35:09','',''),(75,'21','221',NULL,2,'Reception Return corrector for bridging 11',0.00,0.00,32800.00,0.00,0.00,'2022-03-24 15:35:09','',''),(76,'21','221',NULL,1,'Returned purchase #7 to AYM SHAFA NIGERIA. LTD',7425000.00,0.00,0.00,45000.00,0.00,'2022-03-24 15:35:44','',''),(77,'21','221',NULL,2,'Returned purchase #8 to AYM SHAFA NIGERIA. LTD',22960000.00,0.00,0.00,32800.00,0.00,'2022-03-24 15:36:09','',''),(78,'21','221','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,7353.00,0.00,'2022-04-05 09:35:28','',''),(79,'21','221','1',0,'Inventory adjustment from tank dipping to 16400',0.00,0.00,16400.00,0.00,0.00,'2022-04-05 09:35:28','',''),(80,'21','221','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,3467.00,0.00,'2022-04-05 09:36:20','',''),(81,'21','221','2',0,'Inventory adjustment from tank dipping to 9100',0.00,0.00,9100.00,0.00,0.00,'2022-04-05 09:36:20','',''),(82,'21','221','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,4604.00,0.00,'2022-04-05 09:36:47','',''),(83,'21','221','3',0,'Inventory adjustment from tank dipping to 12000',0.00,0.00,12000.00,0.00,0.00,'2022-04-05 09:36:47','',''),(84,'21','221','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,9739.00,0.00,'2022-04-05 09:37:29','',''),(85,'21','221','4',0,'Inventory adjustment from tank dipping to 32100',0.00,0.00,32100.00,0.00,0.00,'2022-04-05 09:37:29','',''),(86,'21','221','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,600.00,0.00,'2022-04-05 09:38:02','',''),(87,'21','221','5',0,'Inventory adjustment from tank dipping to 600',0.00,0.00,600.00,0.00,0.00,'2022-04-05 09:38:02','',''),(88,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-05 09:55:28','',''),(89,'21','221',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,15000.00,0.00,'2022-04-05 09:58:10','',''),(90,'21','221','3',1,'Received from bridging 12',0.00,0.00,15000.00,0.00,0.00,'2022-04-05 09:58:10','',''),(91,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-05 11:04:29','',''),(92,'21','221',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,15000.00,0.00,'2022-04-05 11:06:21','',''),(93,'21','221','3',1,'Received from bridging 15',0.00,0.00,15000.00,0.00,0.00,'2022-04-05 11:06:21','',''),(94,'21','221',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,30000.00,0.00,'2022-04-05 11:06:21','',''),(95,'21','221','2',1,'Received from bridging 14',0.00,0.00,30000.00,0.00,0.00,'2022-04-05 11:06:21','',''),(96,'21','221','1',1,'Sale Id shift 5',0.00,0.00,0.00,3361.10,0.00,'2022-04-05 11:59:32','',''),(97,'21','221','2',1,'Sale Id shift 5',0.00,0.00,0.00,3290.66,0.00,'2022-04-05 11:59:32','',''),(98,'21','221','2',1,'Sale Id shift 5',0.00,0.00,0.00,2828.62,0.00,'2022-04-05 11:59:32','',''),(99,'21','221','3',1,'Sale Id shift 5',0.00,0.00,0.00,3922.51,0.00,'2022-04-05 11:59:32','',''),(100,'21','221','3',1,'Sale Id shift 5',0.00,0.00,0.00,2653.98,0.00,'2022-04-05 11:59:32','',''),(101,'21','221','3',1,'Sale Id shift 5',0.00,0.00,0.00,2443.43,0.00,'2022-04-05 11:59:32','',''),(102,'21','221','3',1,'Sale Id shift 5',0.00,0.00,0.00,2729.69,0.00,'2022-04-05 11:59:32','',''),(103,'21','221','3',1,'Sale Id shift 5',0.00,0.00,0.00,3609.38,0.00,'2022-04-05 11:59:32','',''),(104,'21','221','3',1,'Sale Id shift 5',0.00,0.00,0.00,4755.75,0.00,'2022-04-05 11:59:32','',''),(105,'21','221','3',1,'Sale Id shift 5',0.00,0.00,0.00,698.25,0.00,'2022-04-05 11:59:32','',''),(106,'21','221','1',1,'Sale Id shift 5',0.00,0.00,0.00,3405.14,0.00,'2022-04-05 11:59:32','',''),(107,'21','221','4',2,'Sale Id shift 5',0.00,0.00,0.00,10341.46,0.00,'2022-04-05 11:59:32','',''),(108,'21','221','3',1,'Sale Id shift 5',0.00,0.00,0.00,2952.18,0.00,'2022-04-05 11:59:32','',''),(109,'21','221','1',1,'Sale Id shift 5',0.00,0.00,0.00,3762.72,0.00,'2022-04-05 11:59:32','',''),(110,'21','221','1',1,'Sale Id shift 5',0.00,0.00,0.00,3858.14,0.00,'2022-04-05 11:59:32','',''),(111,'21','221','2',1,'Sale Id shift 5',0.00,0.00,0.00,3498.49,0.00,'2022-04-05 11:59:32','',''),(112,'21','221','2',1,'Sale Id shift 5',0.00,0.00,0.00,1791.60,0.00,'2022-04-05 11:59:32','',''),(113,'21','221','2',1,'Sale Id shift 5',0.00,0.00,0.00,2726.70,0.00,'2022-04-05 11:59:32','',''),(114,'21','221','2',1,'Sale Id shift 5',0.00,0.00,0.00,1476.08,0.00,'2022-04-05 11:59:32','',''),(115,'21','221',NULL,2,'Sale Id shift 5',7239022.00,0.00,0.00,0.00,0.00,'2022-04-05 11:59:32','',''),(116,'21','221',NULL,1,'Sale Id shift 5',8871129.30,0.00,0.00,0.00,0.00,'2022-04-05 11:59:32','',''),(117,'21','221',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,30000.00,0.00,'2022-04-05 12:00:32','',''),(118,'21','221','1',1,'Received from bridging 13',0.00,0.00,30000.00,0.00,0.00,'2022-04-05 12:00:32','',''),(119,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-05 12:14:00','',''),(120,'21','221',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,24100.00,0.00,'2022-04-05 12:23:03','',''),(121,'21','221','3',1,'Received from bridging 17',0.00,0.00,24100.00,0.00,0.00,'2022-04-05 12:23:03','',''),(122,'21','221',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,20900.00,0.00,'2022-04-05 12:23:03','',''),(123,'21','221','2',1,'Received from bridging 16',0.00,0.00,20900.00,0.00,0.00,'2022-04-05 12:23:03','',''),(124,'21','221','1',1,'Sale Id shift 6',0.00,0.00,0.00,3533.67,0.00,'2022-04-05 13:01:26','',''),(125,'21','221','2',1,'Sale Id shift 6',0.00,0.00,0.00,7197.91,0.00,'2022-04-05 13:01:26','',''),(126,'21','221','2',1,'Sale Id shift 6',0.00,0.00,0.00,5311.56,0.00,'2022-04-05 13:01:26','',''),(127,'21','221','3',1,'Sale Id shift 6',0.00,0.00,0.00,5747.08,0.00,'2022-04-05 13:01:26','',''),(128,'21','221','3',1,'Sale Id shift 6',0.00,0.00,0.00,2688.01,0.00,'2022-04-05 13:01:26','',''),(129,'21','221','3',1,'Sale Id shift 6',0.00,0.00,0.00,2569.14,0.00,'2022-04-05 13:01:26','',''),(130,'21','221','3',1,'Sale Id shift 6',0.00,0.00,0.00,1590.04,0.00,'2022-04-05 13:01:26','',''),(131,'21','221','3',1,'Sale Id shift 6',0.00,0.00,0.00,3232.66,0.00,'2022-04-05 13:01:26','',''),(132,'21','221','3',1,'Sale Id shift 6',0.00,0.00,0.00,3409.06,0.00,'2022-04-05 13:01:26','',''),(133,'21','221','3',1,'Sale Id shift 6',0.00,0.00,0.00,396.13,0.00,'2022-04-05 13:01:26','',''),(134,'21','221','1',1,'Sale Id shift 6',0.00,0.00,0.00,3124.88,0.00,'2022-04-05 13:01:26','',''),(135,'21','221','4',2,'Sale Id shift 6',0.00,0.00,0.00,5676.41,0.00,'2022-04-05 13:01:26','',''),(136,'21','221','4',2,'Sale Id shift 6',0.00,0.00,0.00,27.40,0.00,'2022-04-05 13:01:26','',''),(137,'21','221','4',2,'Sale Id shift 6',0.00,0.00,0.00,7613.59,0.00,'2022-04-05 13:01:26','',''),(138,'21','221','3',1,'Sale Id shift 6',0.00,0.00,0.00,2160.88,0.00,'2022-04-05 13:01:26','',''),(139,'21','221','1',1,'Sale Id shift 6',0.00,0.00,0.00,2044.26,0.00,'2022-04-05 13:01:26','',''),(140,'21','221','1',1,'Sale Id shift 6',0.00,0.00,0.00,3019.56,0.00,'2022-04-05 13:01:26','',''),(141,'21','221','2',1,'Sale Id shift 6',0.00,0.00,0.00,130.65,0.00,'2022-04-05 13:01:26','',''),(142,'21','221','2',1,'Sale Id shift 6',0.00,0.00,0.00,8163.47,0.00,'2022-04-05 13:01:26','',''),(143,'21','221','2',1,'Sale Id shift 6',0.00,0.00,0.00,3042.57,0.00,'2022-04-05 13:01:26','',''),(144,'21','221','2',1,'Sale Id shift 6',0.00,0.00,0.00,6694.81,0.00,'2022-04-05 13:01:26','',''),(145,'21','221','2',1,'Sale Id shift 6',0.00,0.00,0.00,5219.72,0.00,'2022-04-05 13:01:26','',''),(146,'21','221',NULL,1,'Sale Id shift 6',11430549.90,0.00,0.00,0.00,0.00,'2022-04-05 13:01:26','',''),(147,'21','221',NULL,2,'Sale Id shift 6',9322180.00,0.00,0.00,0.00,0.00,'2022-04-05 13:01:26','',''),(148,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-05 13:24:27','',''),(149,'21','221',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,25000.00,0.00,'2022-04-05 13:27:09','',''),(150,'21','221','3',1,'Received from bridging 20',0.00,0.00,25000.00,0.00,0.00,'2022-04-05 13:27:09','',''),(151,'21','221',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,25000.00,0.00,'2022-04-05 13:27:09','',''),(152,'21','221','2',1,'Received from bridging 19',0.00,0.00,25000.00,0.00,0.00,'2022-04-05 13:27:09','',''),(153,'21','221',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,10000.00,0.00,'2022-04-05 13:27:09','',''),(154,'21','221','1',1,'Received from bridging 18',0.00,0.00,10000.00,0.00,0.00,'2022-04-05 13:27:09','',''),(155,'21','221','1',1,'Sale Id shift 7',0.00,0.00,0.00,4406.53,0.00,'2022-04-05 14:56:26','',''),(156,'21','221','2',1,'Sale Id shift 7',0.00,0.00,0.00,3923.70,0.00,'2022-04-05 14:56:26','',''),(157,'21','221','2',1,'Sale Id shift 7',0.00,0.00,0.00,4310.06,0.00,'2022-04-05 14:56:26','',''),(158,'21','221','3',1,'Sale Id shift 7',0.00,0.00,0.00,3832.77,0.00,'2022-04-05 14:56:26','',''),(159,'21','221','3',1,'Sale Id shift 7',0.00,0.00,0.00,3488.46,0.00,'2022-04-05 14:56:26','',''),(160,'21','221','3',1,'Sale Id shift 7',0.00,0.00,0.00,3867.52,0.00,'2022-04-05 14:56:26','',''),(161,'21','221','3',1,'Sale Id shift 7',0.00,0.00,0.00,1521.87,0.00,'2022-04-05 14:56:26','',''),(162,'21','221','3',1,'Sale Id shift 7',0.00,0.00,0.00,3413.03,0.00,'2022-04-05 14:56:26','',''),(163,'21','221','3',1,'Sale Id shift 7',0.00,0.00,0.00,3374.93,0.00,'2022-04-05 14:56:26','',''),(164,'21','221','1',1,'Sale Id shift 7',0.00,0.00,0.00,1695.26,0.00,'2022-04-05 14:56:26','',''),(165,'21','221','4',2,'Sale Id shift 7',0.00,0.00,0.00,3394.53,0.00,'2022-04-05 14:56:26','',''),(166,'21','221','4',2,'Sale Id shift 7',0.00,0.00,0.00,2494.80,0.00,'2022-04-05 14:56:26','',''),(167,'21','221','3',1,'Sale Id shift 7',0.00,0.00,0.00,3380.84,0.00,'2022-04-05 14:56:26','',''),(168,'21','221','1',1,'Sale Id shift 7',0.00,0.00,0.00,3273.40,0.00,'2022-04-05 14:56:26','',''),(169,'21','221','1',1,'Sale Id shift 7',0.00,0.00,0.00,2298.45,0.00,'2022-04-05 14:56:26','',''),(170,'21','221','2',1,'Sale Id shift 7',0.00,0.00,0.00,3077.32,0.00,'2022-04-05 14:56:26','',''),(171,'21','221','2',1,'Sale Id shift 7',0.00,0.00,0.00,253.08,0.00,'2022-04-05 14:56:26','',''),(172,'21','221','2',1,'Sale Id shift 7',0.00,0.00,0.00,1813.24,0.00,'2022-04-05 14:56:26','',''),(173,'21','221','2',1,'Sale Id shift 7',0.00,0.00,0.00,3823.89,0.00,'2022-04-05 14:56:26','',''),(174,'21','221',NULL,1,'Sale Id shift 7',8539467.75,0.00,0.00,0.00,0.00,'2022-04-05 14:56:26','',''),(175,'21','221',NULL,2,'Sale Id shift 7',4122531.00,0.00,0.00,0.00,0.00,'2022-04-05 14:56:26','',''),(176,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-05 15:07:49','',''),(177,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-05 15:12:07','',''),(178,'21','221',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,27000.00,0.00,'2022-04-05 15:15:31','',''),(179,'21','221','3',1,'Received from bridging 22',0.00,0.00,27000.00,0.00,0.00,'2022-04-05 15:15:31','',''),(180,'21','221',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,13000.00,0.00,'2022-04-05 15:15:31','',''),(181,'21','221','1',1,'Received from bridging 21',0.00,0.00,13000.00,0.00,0.00,'2022-04-05 15:15:31','',''),(182,'21','221',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,7000.00,0.00,'2022-04-05 15:16:01','',''),(183,'21','221','3',1,'Received from bridging 24',0.00,0.00,7000.00,0.00,0.00,'2022-04-05 15:16:01','',''),(184,'21','221',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,33000.00,0.00,'2022-04-05 15:16:01','',''),(185,'21','221','2',1,'Received from bridging 23',0.00,0.00,33000.00,0.00,0.00,'2022-04-05 15:16:01','',''),(186,'21','221',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12485000.00,22700.00,0.00,0.00,'2022-04-05 15:51:16','',''),(187,'21','221',NULL,3,'Reception corrector for bridging 25',0.00,0.00,0.00,22700.00,0.00,'2022-04-05 15:56:36','',''),(188,'21','221','5',3,'Received from bridging 25',0.00,0.00,22700.00,0.00,0.00,'2022-04-05 15:56:36','',''),(189,'21','221','1',1,'Sale Id shift 8',0.00,0.00,0.00,201.35,0.00,'2022-04-05 16:14:01','',''),(190,'21','221','2',1,'Sale Id shift 8',0.00,0.00,0.00,8088.19,0.00,'2022-04-05 16:14:01','',''),(191,'21','221','2',1,'Sale Id shift 8',0.00,0.00,0.00,6177.99,0.00,'2022-04-05 16:14:01','',''),(192,'21','221','3',1,'Sale Id shift 8',0.00,0.00,0.00,7971.92,0.00,'2022-04-05 16:14:01','',''),(193,'21','221','3',1,'Sale Id shift 8',0.00,0.00,0.00,4574.35,0.00,'2022-04-05 16:14:01','',''),(194,'21','221','3',1,'Sale Id shift 8',0.00,0.00,0.00,6344.17,0.00,'2022-04-05 16:14:01','',''),(195,'21','221','3',1,'Sale Id shift 8',0.00,0.00,0.00,4530.98,0.00,'2022-04-05 16:14:01','',''),(196,'21','221','3',1,'Sale Id shift 8',0.00,0.00,0.00,3831.53,0.00,'2022-04-05 16:14:01','',''),(197,'21','221','3',1,'Sale Id shift 8',0.00,0.00,0.00,5063.87,0.00,'2022-04-05 16:14:01','',''),(198,'21','221','1',1,'Sale Id shift 8',0.00,0.00,0.00,424.01,0.00,'2022-04-05 16:14:01','',''),(199,'21','221','4',2,'Sale Id shift 8',0.00,0.00,0.00,542.59,0.00,'2022-04-05 16:14:01','',''),(200,'21','221','5',3,'Sale Id shift 8',0.00,0.00,0.00,791.61,0.00,'2022-04-05 16:14:01','',''),(201,'21','221','3',1,'Sale Id shift 8',0.00,0.00,0.00,5269.88,0.00,'2022-04-05 16:14:01','',''),(202,'21','221','1',1,'Sale Id shift 8',0.00,0.00,0.00,316.29,0.00,'2022-04-05 16:14:01','',''),(203,'21','221','1',1,'Sale Id shift 8',0.00,0.00,0.00,387.15,0.00,'2022-04-05 16:14:01','',''),(204,'21','221','2',1,'Sale Id shift 8',0.00,0.00,0.00,8420.19,0.00,'2022-04-05 16:14:01','',''),(205,'21','221','2',1,'Sale Id shift 8',0.00,0.00,0.00,6263.87,0.00,'2022-04-05 16:14:01','',''),(206,'21','221',NULL,1,'Sale Id shift 8',11197847.10,0.00,0.00,0.00,0.00,'2022-04-05 16:14:01','',''),(207,'21','221',NULL,2,'Sale Id shift 8',379813.00,0.00,0.00,0.00,0.00,'2022-04-05 16:14:01','',''),(208,'21','221',NULL,3,'Sale Id shift 8',435385.50,0.00,0.00,0.00,0.00,'2022-04-05 16:14:01','',''),(209,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,15000.00,0.00,0.00,'2022-04-05 18:13:38','',''),(210,'21','221',NULL,2,'Reception corrector for bridging 26',0.00,0.00,0.00,15000.00,0.00,'2022-04-05 18:17:46','',''),(211,'21','221','4',2,'Received from bridging 26',0.00,0.00,15000.00,0.00,0.00,'2022-04-05 18:17:46','',''),(212,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-05 18:18:23','',''),(213,'21','221',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,24700.00,0.00,'2022-04-05 18:22:46','',''),(214,'21','221','3',1,'Received from bridging 28',0.00,0.00,24700.00,0.00,0.00,'2022-04-05 18:22:46','',''),(215,'21','221',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,25300.00,0.00,'2022-04-05 18:22:46','',''),(216,'21','221','2',1,'Received from bridging 27',0.00,0.00,25300.00,0.00,0.00,'2022-04-05 18:22:46','',''),(217,'21','221','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,45775.63,0.00,'2022-04-06 08:33:31','',''),(218,'21','221','2',0,'Inventory adjustment from tank dipping to 41014',0.00,0.00,41014.00,0.00,0.00,'2022-04-06 08:33:31','',''),(219,'21','221','2',1,'Sale Id shift 10',0.00,0.00,0.00,5184.07,0.00,'2022-04-06 16:44:45','',''),(220,'21','221','2',1,'Sale Id shift 10',0.00,0.00,0.00,3161.42,0.00,'2022-04-06 16:44:45','',''),(221,'21','221','3',1,'Sale Id shift 10',0.00,0.00,0.00,4025.37,0.00,'2022-04-06 16:44:45','',''),(222,'21','221','3',1,'Sale Id shift 10',0.00,0.00,0.00,2994.04,0.00,'2022-04-06 16:44:45','',''),(223,'21','221','3',1,'Sale Id shift 10',0.00,0.00,0.00,2167.26,0.00,'2022-04-06 16:44:45','',''),(224,'21','221','3',1,'Sale Id shift 10',0.00,0.00,0.00,1796.87,0.00,'2022-04-06 16:44:45','',''),(225,'21','221','3',1,'Sale Id shift 10',0.00,0.00,0.00,2767.55,0.00,'2022-04-06 16:44:45','',''),(226,'21','221','3',1,'Sale Id shift 10',0.00,0.00,0.00,2579.47,0.00,'2022-04-06 16:44:45','',''),(227,'21','221','4',2,'Sale Id shift 10',0.00,0.00,0.00,422.18,0.00,'2022-04-06 16:44:45','',''),(228,'21','221','5',3,'Sale Id shift 10',0.00,0.00,0.00,2988.69,0.00,'2022-04-06 16:44:45','',''),(229,'21','221','3',1,'Sale Id shift 10',0.00,0.00,0.00,2849.52,0.00,'2022-04-06 16:44:45','',''),(230,'21','221','2',1,'Sale Id shift 10',0.00,0.00,0.00,3586.57,0.00,'2022-04-06 16:44:45','',''),(231,'21','221','2',1,'Sale Id shift 10',0.00,0.00,0.00,1629.48,0.00,'2022-04-06 16:44:45','',''),(232,'21','221','2',1,'Sale Id shift 10',0.00,0.00,0.00,3791.61,0.00,'2022-04-06 16:44:45','',''),(233,'21','221','2',1,'Sale Id shift 10',0.00,0.00,0.00,4426.35,0.00,'2022-04-06 16:44:45','',''),(234,'21','221',NULL,1,'Sale Id shift 10',6758330.70,0.00,0.00,0.00,0.00,'2022-04-06 16:44:45','',''),(235,'21','221',NULL,2,'Sale Id shift 10',295526.00,0.00,0.00,0.00,0.00,'2022-04-06 16:44:45','',''),(236,'21','221',NULL,3,'Sale Id shift 10',1643779.50,0.00,0.00,0.00,0.00,'2022-04-06 16:44:45','',''),(237,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-07 10:34:33','',''),(238,'21','221',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,26700.00,0.00,'2022-04-07 10:41:29','',''),(239,'21','221','3',1,'Received from bridging 30',0.00,0.00,26700.00,0.00,0.00,'2022-04-07 10:41:29','',''),(240,'21','221',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,23300.00,0.00,'2022-04-07 10:41:29','',''),(241,'21','221','2',1,'Received from bridging 29',0.00,0.00,23300.00,0.00,0.00,'2022-04-07 10:41:29','',''),(242,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,15000.00,0.00,0.00,'2022-04-07 10:50:48','',''),(243,'21','221',NULL,2,'Reception corrector for bridging 31',0.00,0.00,0.00,15000.00,0.00,'2022-04-07 10:55:36','',''),(244,'21','221','4',2,'Received from bridging 31',0.00,0.00,15000.00,0.00,0.00,'2022-04-07 10:55:36','',''),(245,'21','221','1',1,'Sale Id shift 11',0.00,0.00,0.00,1801.89,0.00,'2022-04-07 17:42:41','',''),(246,'21','221','2',1,'Sale Id shift 11',0.00,0.00,0.00,4839.43,0.00,'2022-04-07 17:42:41','',''),(247,'21','221','2',1,'Sale Id shift 11',0.00,0.00,0.00,1670.95,0.00,'2022-04-07 17:42:41','',''),(248,'21','221','3',1,'Sale Id shift 11',0.00,0.00,0.00,4178.22,0.00,'2022-04-07 17:42:41','',''),(249,'21','221','3',1,'Sale Id shift 11',0.00,0.00,0.00,3011.09,0.00,'2022-04-07 17:42:41','',''),(250,'21','221','3',1,'Sale Id shift 11',0.00,0.00,0.00,3908.75,0.00,'2022-04-07 17:42:41','',''),(251,'21','221','3',1,'Sale Id shift 11',0.00,0.00,0.00,1628.51,0.00,'2022-04-07 17:42:41','',''),(252,'21','221','3',1,'Sale Id shift 11',0.00,0.00,0.00,1922.62,0.00,'2022-04-07 17:42:41','',''),(253,'21','221','3',1,'Sale Id shift 11',0.00,0.00,0.00,2080.57,0.00,'2022-04-07 17:42:41','',''),(254,'21','221','3',1,'Sale Id shift 11',0.00,0.00,0.00,0.03,0.00,'2022-04-07 17:42:41','',''),(255,'21','221','1',1,'Sale Id shift 11',0.00,0.00,0.00,1454.87,0.00,'2022-04-07 17:42:41','',''),(256,'21','221','4',2,'Sale Id shift 11',0.00,0.00,0.00,18577.41,0.00,'2022-04-07 17:42:41','',''),(257,'21','221','4',2,'Sale Id shift 11',0.00,0.00,0.00,7320.56,0.00,'2022-04-07 17:42:41','',''),(258,'21','221','5',3,'Sale Id shift 11',0.00,0.00,0.00,754.79,0.00,'2022-04-07 17:42:41','',''),(259,'21','221','3',1,'Sale Id shift 11',0.00,0.00,0.00,3140.27,0.00,'2022-04-07 17:42:41','',''),(260,'21','221','1',1,'Sale Id shift 11',0.00,0.00,0.00,2160.80,0.00,'2022-04-07 17:42:41','',''),(261,'21','221','1',1,'Sale Id shift 11',0.00,0.00,0.00,1002.10,0.00,'2022-04-07 17:42:41','',''),(262,'21','221','2',1,'Sale Id shift 11',0.00,0.00,0.00,3604.82,0.00,'2022-04-07 17:42:41','',''),(263,'21','221','2',1,'Sale Id shift 11',0.00,0.00,0.00,3437.67,0.00,'2022-04-07 17:42:41','',''),(264,'21','221','2',1,'Sale Id shift 11',0.00,0.00,0.00,3365.85,0.00,'2022-04-07 17:42:41','',''),(265,'21','221','2',1,'Sale Id shift 11',0.00,0.00,0.00,3011.73,0.00,'2022-04-07 17:42:41','',''),(266,'21','221',NULL,1,'Sale Id shift 11',7626328.05,0.00,0.00,0.00,0.00,'2022-04-07 17:42:41','',''),(267,'21','221',NULL,2,'Sale Id shift 11',18128579.00,0.00,0.00,0.00,0.00,'2022-04-07 17:42:41','',''),(268,'21','221',NULL,3,'Sale Id shift 11',415134.50,0.00,0.00,0.00,0.00,'2022-04-07 17:42:41','',''),(269,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-09 12:22:40','',''),(270,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-09 12:26:45','',''),(271,'21','221',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,33000.00,0.00,'2022-04-09 12:34:09','',''),(272,'21','221','3',1,'Received from bridging 33',0.00,0.00,33000.00,0.00,0.00,'2022-04-09 12:34:09','',''),(273,'21','221',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,12000.00,0.00,'2022-04-09 12:34:09','',''),(274,'21','221','2',1,'Received from bridging 32',0.00,0.00,12000.00,0.00,0.00,'2022-04-09 12:34:09','',''),(275,'21','221',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,26500.00,0.00,'2022-04-09 12:34:46','',''),(276,'21','221','2',1,'Received from bridging 35',0.00,0.00,26500.00,0.00,0.00,'2022-04-09 12:34:46','',''),(277,'21','221',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,18300.00,0.00,'2022-04-09 12:34:46','',''),(278,'21','221','1',1,'Received from bridging 34',0.00,0.00,18300.00,0.00,0.00,'2022-04-09 12:34:46','',''),(279,'21','221','1',1,'Sale Id shift 12',0.00,0.00,0.00,5021.85,0.00,'2022-04-09 14:25:09','',''),(280,'21','221','2',1,'Sale Id shift 12',0.00,0.00,0.00,7927.74,0.00,'2022-04-09 14:25:09','',''),(281,'21','221','2',1,'Sale Id shift 12',0.00,0.00,0.00,4242.51,0.00,'2022-04-09 14:25:09','',''),(282,'21','221','3',1,'Sale Id shift 12',0.00,0.00,0.00,7166.47,0.00,'2022-04-09 14:25:09','',''),(283,'21','221','3',1,'Sale Id shift 12',0.00,0.00,0.00,4345.44,0.00,'2022-04-09 14:25:09','',''),(284,'21','221','3',1,'Sale Id shift 12',0.00,0.00,0.00,4628.17,0.00,'2022-04-09 14:25:09','',''),(285,'21','221','3',1,'Sale Id shift 12',0.00,0.00,0.00,2293.05,0.00,'2022-04-09 14:25:09','',''),(286,'21','221','3',1,'Sale Id shift 12',0.00,0.00,0.00,4896.94,0.00,'2022-04-09 14:25:09','',''),(287,'21','221','3',1,'Sale Id shift 12',0.00,0.00,0.00,3514.10,0.00,'2022-04-09 14:25:09','',''),(288,'21','221','1',1,'Sale Id shift 12',0.00,0.00,0.00,4651.66,0.00,'2022-04-09 14:25:09','',''),(289,'21','221','4',2,'Sale Id shift 12',0.00,0.00,0.00,20.01,0.00,'2022-04-09 14:25:09','',''),(290,'21','221','4',2,'Sale Id shift 12',0.00,0.00,0.00,3949.74,0.00,'2022-04-09 14:25:09','',''),(291,'21','221','5',3,'Sale Id shift 12',0.00,0.00,0.00,1233.75,0.00,'2022-04-09 14:25:09','',''),(292,'21','221','3',1,'Sale Id shift 12',0.00,0.00,0.00,4517.61,0.00,'2022-04-09 14:25:09','',''),(293,'21','221','1',1,'Sale Id shift 12',0.00,0.00,0.00,2891.40,0.00,'2022-04-09 14:25:09','',''),(294,'21','221','1',1,'Sale Id shift 12',0.00,0.00,0.00,3896.51,0.00,'2022-04-09 14:25:09','',''),(295,'21','221','2',1,'Sale Id shift 12',0.00,0.00,0.00,7473.94,0.00,'2022-04-09 14:25:09','',''),(296,'21','221','2',1,'Sale Id shift 12',0.00,0.00,0.00,4774.47,0.00,'2022-04-09 14:25:09','',''),(297,'21','221','2',1,'Sale Id shift 12',0.00,0.00,0.00,4760.67,0.00,'2022-04-09 14:25:09','',''),(298,'21','221','2',1,'Sale Id shift 12',0.00,0.00,0.00,4273.42,0.00,'2022-04-09 14:25:09','',''),(299,'21','221',NULL,1,'Sale Id shift 12',13410531.75,0.00,0.00,0.00,0.00,'2022-04-09 14:25:09','',''),(300,'21','221',NULL,2,'Sale Id shift 12',2778825.00,0.00,0.00,0.00,0.00,'2022-04-09 14:25:09','',''),(301,'21','221',NULL,3,'Sale Id shift 12',678562.50,0.00,0.00,0.00,0.00,'2022-04-09 14:25:09','',''),(302,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-13 10:34:53','',''),(303,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21000000.00,30000.00,0.00,0.00,'2022-04-13 10:41:06','',''),(304,'21','221',NULL,2,'Reception corrector for bridging 39',0.00,0.00,0.00,30000.00,0.00,'2022-04-13 10:45:41','',''),(305,'21','221','4',2,'Received from bridging 39',0.00,0.00,30000.00,0.00,0.00,'2022-04-13 10:45:41','',''),(306,'21','221',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,30750.00,0.00,'2022-04-13 10:46:27','',''),(307,'21','221','3',1,'Received from bridging 38',0.00,0.00,30750.00,0.00,0.00,'2022-04-13 10:46:27','',''),(308,'21','221',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,23600.00,0.00,'2022-04-13 10:46:27','',''),(309,'21','221','2',1,'Received from bridging 37',0.00,0.00,23600.00,0.00,0.00,'2022-04-13 10:46:27','',''),(310,'21','221',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,5650.00,0.00,'2022-04-13 10:46:27','',''),(311,'21','221','1',1,'Received from bridging 36',0.00,0.00,5650.00,0.00,0.00,'2022-04-13 10:46:27','',''),(312,'21','221','1',1,'Sale Id shift 13',0.00,0.00,0.00,174.36,0.00,'2022-04-13 20:10:11','',''),(313,'21','221','2',1,'Sale Id shift 13',0.00,0.00,0.00,6262.50,0.00,'2022-04-13 20:10:11','',''),(314,'21','221','2',1,'Sale Id shift 13',0.00,0.00,0.00,2453.61,0.00,'2022-04-13 20:10:11','',''),(315,'21','221','3',1,'Sale Id shift 13',0.00,0.00,0.00,7913.50,0.00,'2022-04-13 20:10:11','',''),(316,'21','221','3',1,'Sale Id shift 13',0.00,0.00,0.00,3269.43,0.00,'2022-04-13 20:10:11','',''),(317,'21','221','3',1,'Sale Id shift 13',0.00,0.00,0.00,6545.12,0.00,'2022-04-13 20:10:11','',''),(318,'21','221','3',1,'Sale Id shift 13',0.00,0.00,0.00,3569.65,0.00,'2022-04-13 20:10:11','',''),(319,'21','221','3',1,'Sale Id shift 13',0.00,0.00,0.00,4791.94,0.00,'2022-04-13 20:10:11','',''),(320,'21','221','3',1,'Sale Id shift 13',0.00,0.00,0.00,5123.78,0.00,'2022-04-13 20:10:11','',''),(321,'21','221','3',1,'Sale Id shift 13',0.00,0.00,0.00,10.32,0.00,'2022-04-13 20:10:11','',''),(322,'21','221','1',1,'Sale Id shift 13',0.00,0.00,0.00,2820.45,0.00,'2022-04-13 20:10:11','',''),(323,'21','221','4',2,'Sale Id shift 13',0.00,0.00,0.00,2938.19,0.00,'2022-04-13 20:10:11','',''),(324,'21','221','4',2,'Sale Id shift 13',0.00,0.00,0.00,4945.60,0.00,'2022-04-13 20:10:11','',''),(325,'21','221','5',3,'Sale Id shift 13',0.00,0.00,0.00,1095.29,0.00,'2022-04-13 20:10:11','',''),(326,'21','221','3',1,'Sale Id shift 13',0.00,0.00,0.00,4126.13,0.00,'2022-04-13 20:10:11','',''),(327,'21','221','1',1,'Sale Id shift 13',0.00,0.00,0.00,3221.82,0.00,'2022-04-13 20:10:11','',''),(328,'21','221','1',1,'Sale Id shift 13',0.00,0.00,0.00,305.86,0.00,'2022-04-13 20:10:11','',''),(329,'21','221','2',1,'Sale Id shift 13',0.00,0.00,0.00,6339.72,0.00,'2022-04-13 20:10:11','',''),(330,'21','221','2',1,'Sale Id shift 13',0.00,0.00,0.00,4546.35,0.00,'2022-04-13 20:10:11','',''),(331,'21','221','2',1,'Sale Id shift 13',0.00,0.00,0.00,4193.66,0.00,'2022-04-13 20:10:11','',''),(332,'21','221','2',1,'Sale Id shift 13',0.00,0.00,0.00,4490.39,0.00,'2022-04-13 20:10:11','',''),(333,'21','221',NULL,1,'Sale Id shift 13',11576167.35,0.00,0.00,0.00,0.00,'2022-04-13 20:10:11','',''),(334,'21','221',NULL,2,'Sale Id shift 13',5518653.00,0.00,0.00,0.00,0.00,'2022-04-13 20:10:11','',''),(335,'21','221',NULL,3,'Sale Id shift 13',602409.50,0.00,0.00,0.00,0.00,'2022-04-13 20:10:11','',''),(336,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-14 09:43:47','',''),(337,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,15000.00,0.00,0.00,'2022-04-14 09:51:23','',''),(338,'21','221',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,20250.00,0.00,'2022-04-14 09:53:08','',''),(339,'21','221','3',1,'Received from bridging 42',0.00,0.00,20250.00,0.00,0.00,'2022-04-14 09:53:08','',''),(340,'21','221',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,19500.00,0.00,'2022-04-14 09:53:08','',''),(341,'21','221','2',1,'Received from bridging 41',0.00,0.00,19500.00,0.00,0.00,'2022-04-14 09:53:08','',''),(342,'21','221',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,10250.00,0.00,'2022-04-14 09:53:08','',''),(343,'21','221','1',1,'Received from bridging 40',0.00,0.00,10250.00,0.00,0.00,'2022-04-14 09:53:08','',''),(344,'21','221',NULL,2,'Reception corrector for bridging 43',0.00,0.00,0.00,15000.00,0.00,'2022-04-14 09:53:26','',''),(345,'21','221','4',2,'Received from bridging 43',0.00,0.00,15000.00,0.00,0.00,'2022-04-14 09:53:26','',''),(346,'21','221','1',1,'Sale Id shift 14',0.00,0.00,0.00,581.65,0.00,'2022-04-14 15:09:51','',''),(347,'21','221','2',1,'Sale Id shift 14',0.00,0.00,0.00,5478.38,0.00,'2022-04-14 15:09:51','',''),(348,'21','221','2',1,'Sale Id shift 14',0.00,0.00,0.00,4043.28,0.00,'2022-04-14 15:09:51','',''),(349,'21','221','3',1,'Sale Id shift 14',0.00,0.00,0.00,4389.32,0.00,'2022-04-14 15:09:51','',''),(350,'21','221','3',1,'Sale Id shift 14',0.00,0.00,0.00,903.40,0.00,'2022-04-14 15:09:51','',''),(351,'21','221','3',1,'Sale Id shift 14',0.00,0.00,0.00,3775.08,0.00,'2022-04-14 15:09:51','',''),(352,'21','221','3',1,'Sale Id shift 14',0.00,0.00,0.00,1778.61,0.00,'2022-04-14 15:09:51','',''),(353,'21','221','3',1,'Sale Id shift 14',0.00,0.00,0.00,3189.90,0.00,'2022-04-14 15:09:51','',''),(354,'21','221','3',1,'Sale Id shift 14',0.00,0.00,0.00,3835.80,0.00,'2022-04-14 15:09:51','',''),(355,'21','221','3',1,'Sale Id shift 14',0.00,0.00,0.00,1640.72,0.00,'2022-04-14 15:09:51','',''),(356,'21','221','1',1,'Sale Id shift 14',0.00,0.00,0.00,293.79,0.00,'2022-04-14 15:09:51','',''),(357,'21','221','4',2,'Sale Id shift 14',0.00,0.00,0.00,7020.22,0.00,'2022-04-14 15:09:51','',''),(358,'21','221','4',2,'Sale Id shift 14',0.00,0.00,0.00,10771.39,0.00,'2022-04-14 15:09:51','',''),(359,'21','221','5',3,'Sale Id shift 14',0.00,0.00,0.00,1010.04,0.00,'2022-04-14 15:09:51','',''),(360,'21','221','3',1,'Sale Id shift 14',0.00,0.00,0.00,2099.44,0.00,'2022-04-14 15:09:51','',''),(361,'21','221','1',1,'Sale Id shift 14',0.00,0.00,0.00,5323.32,0.00,'2022-04-14 15:09:51','',''),(362,'21','221','1',1,'Sale Id shift 14',0.00,0.00,0.00,4436.35,0.00,'2022-04-14 15:09:51','',''),(363,'21','221','2',1,'Sale Id shift 14',0.00,0.00,0.00,5385.29,0.00,'2022-04-14 15:09:51','',''),(364,'21','221','2',1,'Sale Id shift 14',0.00,0.00,0.00,2436.14,0.00,'2022-04-14 15:09:51','',''),(365,'21','221','2',1,'Sale Id shift 14',0.00,0.00,0.00,3394.04,0.00,'2022-04-14 15:09:51','',''),(366,'21','221','2',1,'Sale Id shift 14',0.00,0.00,0.00,2804.50,0.00,'2022-04-14 15:09:51','',''),(367,'21','221',NULL,1,'Sale Id shift 14',9205186.65,0.00,0.00,0.00,0.00,'2022-04-14 15:09:51','',''),(368,'21','221',NULL,2,'Sale Id shift 14',12454127.00,0.00,0.00,0.00,0.00,'2022-04-14 15:09:51','',''),(369,'21','221',NULL,3,'Sale Id shift 14',555522.00,0.00,0.00,0.00,0.00,'2022-04-14 15:09:51','',''),(370,'21','221','1',1,'Sale Id shift 16',0.00,0.00,0.00,2226.73,0.00,'2022-04-16 16:18:27','',''),(371,'21','221','2',1,'Sale Id shift 16',0.00,0.00,0.00,2637.82,0.00,'2022-04-16 16:18:27','',''),(372,'21','221','2',1,'Sale Id shift 16',0.00,0.00,0.00,3069.04,0.00,'2022-04-16 16:18:27','',''),(373,'21','221','3',1,'Sale Id shift 16',0.00,0.00,0.00,3796.34,0.00,'2022-04-16 16:18:27','',''),(374,'21','221','3',1,'Sale Id shift 16',0.00,0.00,0.00,3233.35,0.00,'2022-04-16 16:18:27','',''),(375,'21','221','3',1,'Sale Id shift 16',0.00,0.00,0.00,2455.34,0.00,'2022-04-16 16:18:27','',''),(376,'21','221','3',1,'Sale Id shift 16',0.00,0.00,0.00,2494.27,0.00,'2022-04-16 16:18:27','',''),(377,'21','221','3',1,'Sale Id shift 16',0.00,0.00,0.00,2010.11,0.00,'2022-04-16 16:18:27','',''),(378,'21','221','3',1,'Sale Id shift 16',0.00,0.00,0.00,2071.03,0.00,'2022-04-16 16:18:27','',''),(379,'21','221','3',1,'Sale Id shift 16',0.00,0.00,0.00,2018.80,0.00,'2022-04-16 16:18:27','',''),(380,'21','221','1',1,'Sale Id shift 16',0.00,0.00,0.00,494.12,0.00,'2022-04-16 16:18:27','',''),(381,'21','221','4',2,'Sale Id shift 16',0.00,0.00,0.00,6657.32,0.00,'2022-04-16 16:18:27','',''),(382,'21','221','4',2,'Sale Id shift 16',0.00,0.00,0.00,17.85,0.00,'2022-04-16 16:18:27','',''),(383,'21','221','4',2,'Sale Id shift 16',0.00,0.00,0.00,6971.94,0.00,'2022-04-16 16:18:27','',''),(384,'21','221','5',3,'Sale Id shift 16',0.00,0.00,0.00,1034.61,0.00,'2022-04-16 16:18:27','',''),(385,'21','221','3',1,'Sale Id shift 16',0.00,0.00,0.00,2694.80,0.00,'2022-04-16 16:18:27','',''),(386,'21','221','1',1,'Sale Id shift 16',0.00,0.00,0.00,1756.64,0.00,'2022-04-16 16:18:27','',''),(387,'21','221','1',1,'Sale Id shift 16',0.00,0.00,0.00,3138.51,0.00,'2022-04-16 16:18:27','',''),(388,'21','221','2',1,'Sale Id shift 16',0.00,0.00,0.00,3216.22,0.00,'2022-04-16 16:18:27','',''),(389,'21','221','2',1,'Sale Id shift 16',0.00,0.00,0.00,2085.17,0.00,'2022-04-16 16:18:27','',''),(390,'21','221','2',1,'Sale Id shift 16',0.00,0.00,0.00,1191.88,0.00,'2022-04-16 16:18:27','',''),(391,'21','221','2',1,'Sale Id shift 16',0.00,0.00,0.00,2295.13,0.00,'2022-04-16 16:18:27','',''),(392,'21','221',NULL,1,'Sale Id shift 16',7076074.50,0.00,0.00,0.00,0.00,'2022-04-16 16:18:27','',''),(393,'21','221',NULL,2,'Sale Id shift 16',9552977.00,0.00,0.00,0.00,0.00,'2022-04-16 16:18:27','',''),(394,'21','221',NULL,3,'Sale Id shift 16',569035.50,0.00,0.00,0.00,0.00,'2022-04-16 16:18:27','',''),(395,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-18 09:49:13','',''),(396,'21','221',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,6900.00,0.00,'2022-04-18 09:54:22','',''),(397,'21','221','3',1,'Received from bridging 46',0.00,0.00,6900.00,0.00,0.00,'2022-04-18 09:54:22','',''),(398,'21','221',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,21200.00,0.00,'2022-04-18 09:54:22','',''),(399,'21','221','2',1,'Received from bridging 45',0.00,0.00,21200.00,0.00,0.00,'2022-04-18 09:54:22','',''),(400,'21','221',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,21900.00,0.00,'2022-04-18 09:54:22','',''),(401,'21','221','1',1,'Received from bridging 44',0.00,0.00,21900.00,0.00,0.00,'2022-04-18 09:54:22','',''),(402,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-18 09:56:32','',''),(403,'21','221',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,32700.00,0.00,'2022-04-18 10:01:13','',''),(404,'21','221','3',1,'Received from bridging 49',0.00,0.00,32700.00,0.00,0.00,'2022-04-18 10:01:13','',''),(405,'21','221',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,22300.00,0.00,'2022-04-18 10:01:13','',''),(406,'21','221','2',1,'Received from bridging 48',0.00,0.00,22300.00,0.00,0.00,'2022-04-18 10:01:13','',''),(407,'21','221',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,5000.00,0.00,'2022-04-18 10:01:13','',''),(408,'21','221','1',1,'Received from bridging 47',0.00,0.00,5000.00,0.00,0.00,'2022-04-18 10:01:13','',''),(409,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,23800000.00,34000.00,0.00,0.00,'2022-04-18 10:04:11','',''),(410,'21','221',NULL,2,'Reception corrector for bridging 50',0.00,0.00,0.00,34000.00,0.00,'2022-04-18 10:08:16','',''),(411,'21','221','4',2,'Received from bridging 50',0.00,0.00,34000.00,0.00,0.00,'2022-04-18 10:08:16','',''),(412,'21','221','1',1,'Sale Id shift 17',0.00,0.00,0.00,3685.70,0.00,'2022-04-18 15:32:49','',''),(413,'21','221','2',1,'Sale Id shift 17',0.00,0.00,0.00,5094.72,0.00,'2022-04-18 15:32:49','',''),(414,'21','221','2',1,'Sale Id shift 17',0.00,0.00,0.00,822.11,0.00,'2022-04-18 15:32:49','',''),(415,'21','221','3',1,'Sale Id shift 17',0.00,0.00,0.00,4449.58,0.00,'2022-04-18 15:32:49','',''),(416,'21','221','3',1,'Sale Id shift 17',0.00,0.00,0.00,2363.52,0.00,'2022-04-18 15:32:49','',''),(417,'21','221','3',1,'Sale Id shift 17',0.00,0.00,0.00,3977.04,0.00,'2022-04-18 15:32:49','',''),(418,'21','221','3',1,'Sale Id shift 17',0.00,0.00,0.00,946.47,0.00,'2022-04-18 15:32:49','',''),(419,'21','221','3',1,'Sale Id shift 17',0.00,0.00,0.00,2269.21,0.00,'2022-04-18 15:32:49','',''),(420,'21','221','3',1,'Sale Id shift 17',0.00,0.00,0.00,2632.71,0.00,'2022-04-18 15:32:49','',''),(421,'21','221','1',1,'Sale Id shift 17',0.00,0.00,0.00,3260.38,0.00,'2022-04-18 15:32:49','',''),(422,'21','221','4',2,'Sale Id shift 17',0.00,0.00,0.00,6774.41,0.00,'2022-04-18 15:32:49','',''),(423,'21','221','4',2,'Sale Id shift 17',0.00,0.00,0.00,3571.45,0.00,'2022-04-18 15:32:49','',''),(424,'21','221','5',3,'Sale Id shift 17',0.00,0.00,0.00,1056.12,0.00,'2022-04-18 15:32:49','',''),(425,'21','221','3',1,'Sale Id shift 17',0.00,0.00,0.00,3300.69,0.00,'2022-04-18 15:32:49','',''),(426,'21','221','1',1,'Sale Id shift 17',0.00,0.00,0.00,3900.00,0.00,'2022-04-18 15:32:49','',''),(427,'21','221','1',1,'Sale Id shift 17',0.00,0.00,0.00,4121.57,0.00,'2022-04-18 15:32:49','',''),(428,'21','221','2',1,'Sale Id shift 17',0.00,0.00,0.00,4255.78,0.00,'2022-04-18 15:32:49','',''),(429,'21','221','2',1,'Sale Id shift 17',0.00,0.00,0.00,2497.86,0.00,'2022-04-18 15:32:49','',''),(430,'21','221','2',1,'Sale Id shift 17',0.00,0.00,0.00,4068.78,0.00,'2022-04-18 15:32:49','',''),(431,'21','221','2',1,'Sale Id shift 17',0.00,0.00,0.00,3711.00,0.00,'2022-04-18 15:32:49','',''),(432,'21','221',NULL,1,'Sale Id shift 17',9133924.80,0.00,0.00,0.00,0.00,'2022-04-18 15:32:49','',''),(433,'21','221',NULL,2,'Sale Id shift 17',7242102.00,0.00,0.00,0.00,0.00,'2022-04-18 15:32:49','',''),(434,'21','221',NULL,3,'Sale Id shift 17',580866.00,0.00,0.00,0.00,0.00,'2022-04-18 15:32:49','',''),(435,'21','221','1',1,'Sale Id shift 18',0.00,0.00,0.00,2568.52,0.00,'2022-04-19 09:44:05','',''),(436,'21','221','2',1,'Sale Id shift 18',0.00,0.00,0.00,5064.41,0.00,'2022-04-19 09:44:05','',''),(437,'21','221','2',1,'Sale Id shift 18',0.00,0.00,0.00,4010.96,0.00,'2022-04-19 09:44:05','',''),(438,'21','221','3',1,'Sale Id shift 18',0.00,0.00,0.00,4110.42,0.00,'2022-04-19 09:44:05','',''),(439,'21','221','3',1,'Sale Id shift 18',0.00,0.00,0.00,4789.26,0.00,'2022-04-19 09:44:05','',''),(440,'21','221','3',1,'Sale Id shift 18',0.00,0.00,0.00,2229.91,0.00,'2022-04-19 09:44:05','',''),(441,'21','221','3',1,'Sale Id shift 18',0.00,0.00,0.00,4289.23,0.00,'2022-04-19 09:44:05','',''),(442,'21','221','3',1,'Sale Id shift 18',0.00,0.00,0.00,4882.79,0.00,'2022-04-19 09:44:05','',''),(443,'21','221','3',1,'Sale Id shift 18',0.00,0.00,0.00,2762.05,0.00,'2022-04-19 09:44:05','',''),(444,'21','221','1',1,'Sale Id shift 18',0.00,0.00,0.00,2768.40,0.00,'2022-04-19 09:44:05','',''),(445,'21','221','4',2,'Sale Id shift 18',0.00,0.00,0.00,8579.39,0.00,'2022-04-19 09:44:05','',''),(446,'21','221','4',2,'Sale Id shift 18',0.00,0.00,0.00,15552.66,0.00,'2022-04-19 09:44:05','',''),(447,'21','221','5',3,'Sale Id shift 18',0.00,0.00,0.00,820.51,0.00,'2022-04-19 09:44:05','',''),(448,'21','221','1',1,'Sale Id shift 18',0.00,0.00,0.00,667.50,0.00,'2022-04-19 09:44:05','',''),(449,'21','221','1',1,'Sale Id shift 18',0.00,0.00,0.00,2897.77,0.00,'2022-04-19 09:44:05','',''),(450,'21','221','2',1,'Sale Id shift 18',0.00,0.00,0.00,6115.55,0.00,'2022-04-19 09:44:05','',''),(451,'21','221','2',1,'Sale Id shift 18',0.00,0.00,0.00,2015.63,0.00,'2022-04-19 09:44:05','',''),(452,'21','221','2',1,'Sale Id shift 18',0.00,0.00,0.00,2823.12,0.00,'2022-04-19 09:44:05','',''),(453,'21','221','2',1,'Sale Id shift 18',0.00,0.00,0.00,2778.21,0.00,'2022-04-19 09:44:05','',''),(454,'21','221',NULL,1,'Sale Id shift 18',9037665.45,0.00,0.00,0.00,0.00,'2022-04-19 09:44:05','',''),(455,'21','221',NULL,2,'Sale Id shift 18',16892435.00,0.00,0.00,0.00,0.00,'2022-04-19 09:44:05','',''),(456,'21','221',NULL,3,'Sale Id shift 18',451280.50,0.00,0.00,0.00,0.00,'2022-04-19 09:44:05','',''),(457,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-19 13:39:43','',''),(458,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21000000.00,30000.00,0.00,0.00,'2022-04-19 13:53:36','',''),(459,'21','221',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 13:55:39','',''),(460,'21','221','3',1,'Received from bridging 52',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 13:55:39','',''),(461,'21','221',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 13:55:39','',''),(462,'21','221','2',1,'Received from bridging 51',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 13:55:39','',''),(463,'21','221',NULL,2,'Reception corrector for bridging 53',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 13:55:56','',''),(464,'21','221','4',2,'Received from bridging 53',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 13:55:56','',''),(465,'21','221','1',1,'Sale Id shift 19',0.00,0.00,0.00,2507.39,0.00,'2022-04-20 15:16:48','',''),(466,'21','221','2',1,'Sale Id shift 19',0.00,0.00,0.00,3467.18,0.00,'2022-04-20 15:16:48','',''),(467,'21','221','2',1,'Sale Id shift 19',0.00,0.00,0.00,2764.52,0.00,'2022-04-20 15:16:48','',''),(468,'21','221','3',1,'Sale Id shift 19',0.00,0.00,0.00,3337.13,0.00,'2022-04-20 15:16:48','',''),(469,'21','221','3',1,'Sale Id shift 19',0.00,0.00,0.00,1239.13,0.00,'2022-04-20 15:16:48','',''),(470,'21','221','3',1,'Sale Id shift 19',0.00,0.00,0.00,2600.58,0.00,'2022-04-20 15:16:48','',''),(471,'21','221','3',1,'Sale Id shift 19',0.00,0.00,0.00,2923.86,0.00,'2022-04-20 15:16:48','',''),(472,'21','221','3',1,'Sale Id shift 19',0.00,0.00,0.00,1960.03,0.00,'2022-04-20 15:16:48','',''),(473,'21','221','3',1,'Sale Id shift 19',0.00,0.00,0.00,1203.25,0.00,'2022-04-20 15:16:48','',''),(474,'21','221','3',1,'Sale Id shift 19',0.00,0.00,0.00,2318.92,0.00,'2022-04-20 15:16:48','',''),(475,'21','221','1',1,'Sale Id shift 19',0.00,0.00,0.00,2834.40,0.00,'2022-04-20 15:16:48','',''),(476,'21','221','4',2,'Sale Id shift 19',0.00,0.00,0.00,6132.15,0.00,'2022-04-20 15:16:48','',''),(477,'21','221','4',2,'Sale Id shift 19',0.00,0.00,0.00,5501.94,0.00,'2022-04-20 15:16:48','',''),(478,'21','221','5',3,'Sale Id shift 19',0.00,0.00,0.00,1559.44,0.00,'2022-04-20 15:16:48','',''),(479,'21','221','3',1,'Sale Id shift 19',0.00,0.00,0.00,1373.92,0.00,'2022-04-20 15:16:48','',''),(480,'21','221','1',1,'Sale Id shift 19',0.00,0.00,0.00,2600.30,0.00,'2022-04-20 15:16:48','',''),(481,'21','221','1',1,'Sale Id shift 19',0.00,0.00,0.00,1306.62,0.00,'2022-04-20 15:16:48','',''),(482,'21','221','2',1,'Sale Id shift 19',0.00,0.00,0.00,4830.48,0.00,'2022-04-20 15:16:48','',''),(483,'21','221','2',1,'Sale Id shift 19',0.00,0.00,0.00,3497.28,0.00,'2022-04-20 15:16:48','',''),(484,'21','221','2',1,'Sale Id shift 19',0.00,0.00,0.00,2014.53,0.00,'2022-04-20 15:16:48','',''),(485,'21','221','2',1,'Sale Id shift 19',0.00,0.00,0.00,1981.87,0.00,'2022-04-20 15:16:48','',''),(486,'21','221',NULL,1,'Sale Id shift 19',7385629.35,0.00,0.00,0.00,0.00,'2022-04-20 15:16:48','',''),(487,'21','221',NULL,2,'Sale Id shift 19',8143863.00,0.00,0.00,0.00,0.00,'2022-04-20 15:16:48','',''),(488,'21','221',NULL,3,'Sale Id shift 19',857692.00,0.00,0.00,0.00,0.00,'2022-04-20 15:16:48','',''),(489,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-20 16:43:06','',''),(490,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-20 17:04:15','',''),(491,'21','221',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,15000.00,0.00,'2022-04-20 17:07:31','',''),(492,'21','221','3',1,'Received from bridging 55',0.00,0.00,15000.00,0.00,0.00,'2022-04-20 17:07:31','',''),(493,'21','221',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,30000.00,0.00,'2022-04-20 17:07:31','',''),(494,'21','221','1',1,'Received from bridging 54',0.00,0.00,30000.00,0.00,0.00,'2022-04-20 17:07:31','',''),(495,'21','221',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,15000.00,0.00,'2022-04-20 17:08:23','',''),(496,'21','221','3',1,'Received from bridging 57',0.00,0.00,15000.00,0.00,0.00,'2022-04-20 17:08:23','',''),(497,'21','221',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,30000.00,0.00,'2022-04-20 17:08:23','',''),(498,'21','221','2',1,'Received from bridging 56',0.00,0.00,30000.00,0.00,0.00,'2022-04-20 17:08:23','',''),(499,'21','221','1',1,'Sale Id shift 20',0.00,0.00,0.00,5613.16,0.00,'2022-04-21 08:26:48','',''),(500,'21','221','2',1,'Sale Id shift 20',0.00,0.00,0.00,4142.10,0.00,'2022-04-21 08:26:48','',''),(501,'21','221','2',1,'Sale Id shift 20',0.00,0.00,0.00,3110.17,0.00,'2022-04-21 08:26:48','',''),(502,'21','221','3',1,'Sale Id shift 20',0.00,0.00,0.00,3739.09,0.00,'2022-04-21 08:26:48','',''),(503,'21','221','3',1,'Sale Id shift 20',0.00,0.00,0.00,4893.41,0.00,'2022-04-21 08:26:48','',''),(504,'21','221','3',1,'Sale Id shift 20',0.00,0.00,0.00,2239.45,0.00,'2022-04-21 08:26:48','',''),(505,'21','221','3',1,'Sale Id shift 20',0.00,0.00,0.00,4601.52,0.00,'2022-04-21 08:26:48','',''),(506,'21','221','3',1,'Sale Id shift 20',0.00,0.00,0.00,4122.22,0.00,'2022-04-21 08:26:48','',''),(507,'21','221','3',1,'Sale Id shift 20',0.00,0.00,0.00,2348.69,0.00,'2022-04-21 08:26:48','',''),(508,'21','221','3',1,'Sale Id shift 20',0.00,0.00,0.00,4643.89,0.00,'2022-04-21 08:26:48','',''),(509,'21','221','1',1,'Sale Id shift 20',0.00,0.00,0.00,4330.89,0.00,'2022-04-21 08:26:48','',''),(510,'21','221','4',2,'Sale Id shift 20',0.00,0.00,0.00,7718.91,0.00,'2022-04-21 08:26:48','',''),(511,'21','221','4',2,'Sale Id shift 20',0.00,0.00,0.00,4510.88,0.00,'2022-04-21 08:26:48','',''),(512,'21','221','5',3,'Sale Id shift 20',0.00,0.00,0.00,1648.30,0.00,'2022-04-21 08:26:48','',''),(513,'21','221','3',1,'Sale Id shift 20',0.00,0.00,0.00,3417.87,0.00,'2022-04-21 08:26:48','',''),(514,'21','221','1',1,'Sale Id shift 20',0.00,0.00,0.00,3733.89,0.00,'2022-04-21 08:26:48','',''),(515,'21','221','1',1,'Sale Id shift 20',0.00,0.00,0.00,5151.23,0.00,'2022-04-21 08:26:48','',''),(516,'21','221','2',1,'Sale Id shift 20',0.00,0.00,0.00,6498.16,0.00,'2022-04-21 08:26:48','',''),(517,'21','221','2',1,'Sale Id shift 20',0.00,0.00,0.00,2948.47,0.00,'2022-04-21 08:26:48','',''),(518,'21','221','2',1,'Sale Id shift 20',0.00,0.00,0.00,4016.21,0.00,'2022-04-21 08:26:48','',''),(519,'21','221','2',1,'Sale Id shift 20',0.00,0.00,0.00,4660.98,0.00,'2022-04-21 08:26:48','',''),(520,'21','221',NULL,1,'Sale Id shift 20',12244881.00,0.00,0.00,0.00,0.00,'2022-04-21 08:26:48','',''),(521,'21','221',NULL,2,'Sale Id shift 20',8560853.00,0.00,0.00,0.00,0.00,'2022-04-21 08:26:48','',''),(522,'21','221',NULL,3,'Sale Id shift 20',906565.00,0.00,0.00,0.00,0.00,'2022-04-21 08:26:48','',''),(523,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-21 09:34:52','',''),(524,'21','221',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,30000.00,0.00,'2022-04-21 09:42:30','',''),(525,'21','221','3',1,'Received from bridging 60',0.00,0.00,30000.00,0.00,0.00,'2022-04-21 09:42:30','',''),(526,'21','221',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,20000.00,0.00,'2022-04-21 09:42:30','',''),(527,'21','221','2',1,'Received from bridging 59',0.00,0.00,20000.00,0.00,0.00,'2022-04-21 09:42:30','',''),(528,'21','221',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,10000.00,0.00,'2022-04-21 09:42:30','',''),(529,'21','221','1',1,'Received from bridging 58',0.00,0.00,10000.00,0.00,0.00,'2022-04-21 09:42:30','',''),(530,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21000000.00,30000.00,0.00,0.00,'2022-04-21 09:46:22','',''),(531,'21','221',NULL,2,'Reception corrector for bridging 61',0.00,0.00,0.00,30000.00,0.00,'2022-04-21 09:51:09','',''),(532,'21','221','4',2,'Received from bridging 61',0.00,0.00,30000.00,0.00,0.00,'2022-04-21 09:51:09','',''),(533,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-21 10:05:33','',''),(534,'21','221',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,23400.00,0.00,'2022-04-21 10:08:24','',''),(535,'21','221','3',1,'Received from bridging 63',0.00,0.00,23400.00,0.00,0.00,'2022-04-21 10:08:24','',''),(536,'21','221',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,26600.00,0.00,'2022-04-21 10:08:24','',''),(537,'21','221','2',1,'Received from bridging 62',0.00,0.00,26600.00,0.00,0.00,'2022-04-21 10:08:24','',''),(538,'21','221','1',1,'Sale Id shift 21',0.00,0.00,0.00,4112.18,0.00,'2022-04-21 18:50:17','',''),(539,'21','221','2',1,'Sale Id shift 21',0.00,0.00,0.00,7705.90,0.00,'2022-04-21 18:50:17','',''),(540,'21','221','2',1,'Sale Id shift 21',0.00,0.00,0.00,4365.19,0.00,'2022-04-21 18:50:17','',''),(541,'21','221','3',1,'Sale Id shift 21',0.00,0.00,0.00,5135.61,0.00,'2022-04-21 18:50:17','',''),(542,'21','221','3',1,'Sale Id shift 21',0.00,0.00,0.00,4084.32,0.00,'2022-04-21 18:50:17','',''),(543,'21','221','3',1,'Sale Id shift 21',0.00,0.00,0.00,1753.31,0.00,'2022-04-21 18:50:17','',''),(544,'21','221','3',1,'Sale Id shift 21',0.00,0.00,0.00,2433.97,0.00,'2022-04-21 18:50:17','',''),(545,'21','221','3',1,'Sale Id shift 21',0.00,0.00,0.00,1789.47,0.00,'2022-04-21 18:50:17','',''),(546,'21','221','3',1,'Sale Id shift 21',0.00,0.00,0.00,3266.31,0.00,'2022-04-21 18:50:17','',''),(547,'21','221','3',1,'Sale Id shift 21',0.00,0.00,0.00,2573.21,0.00,'2022-04-21 18:50:17','',''),(548,'21','221','1',1,'Sale Id shift 21',0.00,0.00,0.00,3130.46,0.00,'2022-04-21 18:50:17','',''),(549,'21','221','4',2,'Sale Id shift 21',0.00,0.00,0.00,4558.97,0.00,'2022-04-21 18:50:17','',''),(550,'21','221','4',2,'Sale Id shift 21',0.00,0.00,0.00,1077.46,0.00,'2022-04-21 18:50:17','',''),(551,'21','221','4',2,'Sale Id shift 21',0.00,0.00,0.00,5625.83,0.00,'2022-04-21 18:50:17','',''),(552,'21','221','5',3,'Sale Id shift 21',0.00,0.00,0.00,905.72,0.00,'2022-04-21 18:50:17','',''),(553,'21','221','3',1,'Sale Id shift 21',0.00,0.00,0.00,2548.76,0.00,'2022-04-21 18:50:17','',''),(554,'21','221','1',1,'Sale Id shift 21',0.00,0.00,0.00,3326.35,0.00,'2022-04-21 18:50:17','',''),(555,'21','221','1',1,'Sale Id shift 21',0.00,0.00,0.00,3938.34,0.00,'2022-04-21 18:50:17','',''),(556,'21','221','2',1,'Sale Id shift 21',0.00,0.00,0.00,8372.61,0.00,'2022-04-21 18:50:17','',''),(557,'21','221','2',1,'Sale Id shift 21',0.00,0.00,0.00,3220.23,0.00,'2022-04-21 18:50:17','',''),(558,'21','221','2',1,'Sale Id shift 21',0.00,0.00,0.00,3126.94,0.00,'2022-04-21 18:50:17','',''),(559,'21','221','2',1,'Sale Id shift 21',0.00,0.00,0.00,4470.52,0.00,'2022-04-21 18:50:17','',''),(560,'21','221',NULL,1,'Sale Id shift 21',11443357.20,0.00,0.00,0.00,0.00,'2022-04-21 18:50:17','',''),(561,'21','221',NULL,2,'Sale Id shift 21',7883582.00,0.00,0.00,0.00,0.00,'2022-04-21 18:50:17','',''),(562,'21','221',NULL,3,'Sale Id shift 21',498146.00,0.00,0.00,0.00,0.00,'2022-04-21 18:50:17','',''),(563,'21','221','1',1,'Sale Id shift 22',0.00,0.00,0.00,4543.46,0.00,'2022-04-22 11:43:06','',''),(564,'21','221','2',1,'Sale Id shift 22',0.00,0.00,0.00,4761.54,0.00,'2022-04-22 11:43:06','',''),(565,'21','221','2',1,'Sale Id shift 22',0.00,0.00,0.00,3601.30,0.00,'2022-04-22 11:43:06','',''),(566,'21','221','3',1,'Sale Id shift 22',0.00,0.00,0.00,3368.76,0.00,'2022-04-22 11:43:06','',''),(567,'21','221','3',1,'Sale Id shift 22',0.00,0.00,0.00,3826.63,0.00,'2022-04-22 11:43:06','',''),(568,'21','221','3',1,'Sale Id shift 22',0.00,0.00,0.00,1492.63,0.00,'2022-04-22 11:43:06','',''),(569,'21','221','3',1,'Sale Id shift 22',0.00,0.00,0.00,3191.25,0.00,'2022-04-22 11:43:06','',''),(570,'21','221','3',1,'Sale Id shift 22',0.00,0.00,0.00,3421.89,0.00,'2022-04-22 11:43:06','',''),(571,'21','221','3',1,'Sale Id shift 22',0.00,0.00,0.00,1274.24,0.00,'2022-04-22 11:43:06','',''),(572,'21','221','3',1,'Sale Id shift 22',0.00,0.00,0.00,3675.77,0.00,'2022-04-22 11:43:06','',''),(573,'21','221','1',1,'Sale Id shift 22',0.00,0.00,0.00,1739.24,0.00,'2022-04-22 11:43:06','',''),(574,'21','221','4',2,'Sale Id shift 22',0.00,0.00,0.00,7931.70,0.00,'2022-04-22 11:43:06','',''),(575,'21','221','4',2,'Sale Id shift 22',0.00,0.00,0.00,8380.97,0.00,'2022-04-22 11:43:06','',''),(576,'21','221','5',3,'Sale Id shift 22',0.00,0.00,0.00,503.19,0.00,'2022-04-22 11:43:06','',''),(577,'21','221','3',1,'Sale Id shift 22',0.00,0.00,0.00,3456.03,0.00,'2022-04-22 11:43:06','',''),(578,'21','221','1',1,'Sale Id shift 22',0.00,0.00,0.00,1980.79,0.00,'2022-04-22 11:43:06','',''),(579,'21','221','1',1,'Sale Id shift 22',0.00,0.00,0.00,2604.07,0.00,'2022-04-22 11:43:06','',''),(580,'21','221','2',1,'Sale Id shift 22',0.00,0.00,0.00,5872.98,0.00,'2022-04-22 11:43:06','',''),(581,'21','221','2',1,'Sale Id shift 22',0.00,0.00,0.00,3755.51,0.00,'2022-04-22 11:43:06','',''),(582,'21','221','2',1,'Sale Id shift 22',0.00,0.00,0.00,3248.13,0.00,'2022-04-22 11:43:06','',''),(583,'21','221','2',1,'Sale Id shift 22',0.00,0.00,0.00,3215.40,0.00,'2022-04-22 11:43:06','',''),(584,'21','221',NULL,1,'Sale Id shift 22',9739887.30,0.00,0.00,0.00,0.00,'2022-04-22 11:43:06','',''),(585,'21','221',NULL,2,'Sale Id shift 22',11418869.00,0.00,0.00,0.00,0.00,'2022-04-22 11:43:06','',''),(586,'21','221',NULL,3,'Sale Id shift 22',276754.50,0.00,0.00,0.00,0.00,'2022-04-22 11:43:06','',''),(587,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-22 11:59:50','',''),(588,'21','221',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,18000.00,0.00,'2022-04-22 12:05:50','',''),(589,'21','221','3',1,'Received from bridging 66',0.00,0.00,18000.00,0.00,0.00,'2022-04-22 12:05:50','',''),(590,'21','221',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,18000.00,0.00,'2022-04-22 12:05:50','',''),(591,'21','221','2',1,'Received from bridging 65',0.00,0.00,18000.00,0.00,0.00,'2022-04-22 12:05:50','',''),(592,'21','221',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,14000.00,0.00,'2022-04-22 12:05:50','',''),(593,'21','221','1',1,'Received from bridging 64',0.00,0.00,14000.00,0.00,0.00,'2022-04-22 12:05:50','',''),(594,'21','221','1',1,'Sale Id shift 23',0.00,0.00,0.00,3464.63,0.00,'2022-04-22 13:41:36','',''),(595,'21','221','2',1,'Sale Id shift 23',0.00,0.00,0.00,3239.45,0.00,'2022-04-22 13:41:36','',''),(596,'21','221','2',1,'Sale Id shift 23',0.00,0.00,0.00,3049.09,0.00,'2022-04-22 13:41:36','',''),(597,'21','221','3',1,'Sale Id shift 23',0.00,0.00,0.00,3382.76,0.00,'2022-04-22 13:41:36','',''),(598,'21','221','3',1,'Sale Id shift 23',0.00,0.00,0.00,2711.75,0.00,'2022-04-22 13:41:36','',''),(599,'21','221','3',1,'Sale Id shift 23',0.00,0.00,0.00,2455.94,0.00,'2022-04-22 13:41:36','',''),(600,'21','221','3',1,'Sale Id shift 23',0.00,0.00,0.00,3600.51,0.00,'2022-04-22 13:41:36','',''),(601,'21','221','3',1,'Sale Id shift 23',0.00,0.00,0.00,2695.04,0.00,'2022-04-22 13:41:36','',''),(602,'21','221','3',1,'Sale Id shift 23',0.00,0.00,0.00,2222.04,0.00,'2022-04-22 13:41:36','',''),(603,'21','221','3',1,'Sale Id shift 23',0.00,0.00,0.00,2413.86,0.00,'2022-04-22 13:41:36','',''),(604,'21','221','1',1,'Sale Id shift 23',0.00,0.00,0.00,3132.96,0.00,'2022-04-22 13:41:36','',''),(605,'21','221','4',2,'Sale Id shift 23',0.00,0.00,0.00,6024.24,0.00,'2022-04-22 13:41:36','',''),(606,'21','221','4',2,'Sale Id shift 23',0.00,0.00,0.00,6057.61,0.00,'2022-04-22 13:41:36','',''),(607,'21','221','5',3,'Sale Id shift 23',0.00,0.00,0.00,484.02,0.00,'2022-04-22 13:41:36','',''),(608,'21','221','3',1,'Sale Id shift 23',0.00,0.00,0.00,1073.29,0.00,'2022-04-22 13:41:36','',''),(609,'21','221','1',1,'Sale Id shift 23',0.00,0.00,0.00,2171.70,0.00,'2022-04-22 13:41:36','',''),(610,'21','221','1',1,'Sale Id shift 23',0.00,0.00,0.00,3320.60,0.00,'2022-04-22 13:41:36','',''),(611,'21','221','2',1,'Sale Id shift 23',0.00,0.00,0.00,5234.99,0.00,'2022-04-22 13:41:36','',''),(612,'21','221','2',1,'Sale Id shift 23',0.00,0.00,0.00,2165.48,0.00,'2022-04-22 13:41:36','',''),(613,'21','221','2',1,'Sale Id shift 23',0.00,0.00,0.00,2859.24,0.00,'2022-04-22 13:41:36','',''),(614,'21','221','2',1,'Sale Id shift 23',0.00,0.00,0.00,2690.88,0.00,'2022-04-22 13:41:36','',''),(615,'21','221',NULL,2,'Sale Id shift 23',8457295.00,0.00,0.00,0.00,0.00,'2022-04-22 13:41:36','',''),(616,'21','221',NULL,3,'Sale Id shift 23',266211.00,0.00,0.00,0.00,0.00,'2022-04-22 13:41:36','',''),(617,'21','221',NULL,1,'Sale Id shift 23',8560894.65,0.00,0.00,0.00,0.00,'2022-04-22 13:41:36','',''),(618,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-22 14:39:11','',''),(619,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,14000000.00,20000.00,0.00,0.00,'2022-04-22 14:43:56','',''),(620,'21','221',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,20000.00,0.00,'2022-04-22 14:47:54','',''),(621,'21','221','3',1,'Received from bridging 69',0.00,0.00,20000.00,0.00,0.00,'2022-04-22 14:47:54','',''),(622,'21','221',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,20000.00,0.00,'2022-04-22 14:47:54','',''),(623,'21','221','2',1,'Received from bridging 68',0.00,0.00,20000.00,0.00,0.00,'2022-04-22 14:47:54','',''),(624,'21','221',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,20000.00,0.00,'2022-04-22 14:47:54','',''),(625,'21','221','1',1,'Received from bridging 67',0.00,0.00,20000.00,0.00,0.00,'2022-04-22 14:47:54','',''),(626,'21','221',NULL,2,'Reception corrector for bridging 70',0.00,0.00,0.00,20000.00,0.00,'2022-04-22 14:48:12','',''),(627,'21','221','4',2,'Received from bridging 70',0.00,0.00,20000.00,0.00,0.00,'2022-04-22 14:48:12','',''),(628,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-22 14:54:02','',''),(629,'21','221',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,15000.00,0.00,'2022-04-22 14:58:00','',''),(630,'21','221','3',1,'Received from bridging 73',0.00,0.00,15000.00,0.00,0.00,'2022-04-22 14:58:00','',''),(631,'21','221',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,30000.00,0.00,'2022-04-22 14:58:00','',''),(632,'21','221','2',1,'Received from bridging 72',0.00,0.00,30000.00,0.00,0.00,'2022-04-22 14:58:00','',''),(633,'21','221',NULL,1,'Reception corrector for bridging 71',0.00,0.00,0.00,15000.00,0.00,'2022-04-22 14:58:00','',''),(634,'21','221','1',1,'Received from bridging 71',0.00,0.00,15000.00,0.00,0.00,'2022-04-22 14:58:00','',''),(635,'21','221','1',1,'Sale Id shift 24',0.00,0.00,0.00,3187.72,0.00,'2022-04-22 16:40:11','',''),(636,'21','221','2',1,'Sale Id shift 24',0.00,0.00,0.00,5100.16,0.00,'2022-04-22 16:40:11','',''),(637,'21','221','2',1,'Sale Id shift 24',0.00,0.00,0.00,3662.93,0.00,'2022-04-22 16:40:11','',''),(638,'21','221','3',1,'Sale Id shift 24',0.00,0.00,0.00,3359.61,0.00,'2022-04-22 16:40:11','',''),(639,'21','221','3',1,'Sale Id shift 24',0.00,0.00,0.00,2639.48,0.00,'2022-04-22 16:40:11','',''),(640,'21','221','3',1,'Sale Id shift 24',0.00,0.00,0.00,2561.07,0.00,'2022-04-22 16:40:11','',''),(641,'21','221','3',1,'Sale Id shift 24',0.00,0.00,0.00,3599.46,0.00,'2022-04-22 16:40:11','',''),(642,'21','221','3',1,'Sale Id shift 24',0.00,0.00,0.00,3016.93,0.00,'2022-04-22 16:40:11','',''),(643,'21','221','3',1,'Sale Id shift 24',0.00,0.00,0.00,2463.48,0.00,'2022-04-22 16:40:11','',''),(644,'21','221','3',1,'Sale Id shift 24',0.00,0.00,0.00,2707.53,0.00,'2022-04-22 16:40:11','',''),(645,'21','221','1',1,'Sale Id shift 24',0.00,0.00,0.00,2801.31,0.00,'2022-04-22 16:40:11','',''),(646,'21','221','4',2,'Sale Id shift 24',0.00,0.00,0.00,9585.62,0.00,'2022-04-22 16:40:11','',''),(647,'21','221','4',2,'Sale Id shift 24',0.00,0.00,0.00,8415.61,0.00,'2022-04-22 16:40:11','',''),(648,'21','221','5',3,'Sale Id shift 24',0.00,0.00,0.00,921.99,0.00,'2022-04-22 16:40:11','',''),(649,'21','221','3',1,'Sale Id shift 24',0.00,0.00,0.00,3160.49,0.00,'2022-04-22 16:40:11','',''),(650,'21','221','1',1,'Sale Id shift 24',0.00,0.00,0.00,2817.13,0.00,'2022-04-22 16:40:11','',''),(651,'21','221','1',1,'Sale Id shift 24',0.00,0.00,0.00,2970.94,0.00,'2022-04-22 16:40:11','',''),(652,'21','221','2',1,'Sale Id shift 24',0.00,0.00,0.00,6166.45,0.00,'2022-04-22 16:40:11','',''),(653,'21','221','2',1,'Sale Id shift 24',0.00,0.00,0.00,2731.07,0.00,'2022-04-22 16:40:11','',''),(654,'21','221','2',1,'Sale Id shift 24',0.00,0.00,0.00,3004.52,0.00,'2022-04-22 16:40:11','',''),(655,'21','221','2',1,'Sale Id shift 24',0.00,0.00,0.00,3833.74,0.00,'2022-04-22 16:40:11','',''),(656,'21','221',NULL,1,'Sale Id shift 24',9864363.30,0.00,0.00,0.00,0.00,'2022-04-22 16:40:11','',''),(657,'21','221',NULL,2,'Sale Id shift 24',12600861.00,0.00,0.00,0.00,0.00,'2022-04-22 16:40:11','',''),(658,'21','221',NULL,3,'Sale Id shift 24',507094.50,0.00,0.00,0.00,0.00,'2022-04-22 16:40:11','',''),(659,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,15000.00,0.00,0.00,'2022-04-22 17:41:05','',''),(660,'21','221',NULL,2,'Reception corrector for bridging 74',0.00,0.00,0.00,15000.00,0.00,'2022-04-22 17:42:35','',''),(661,'21','221','4',2,'Received from bridging 74',0.00,0.00,15000.00,0.00,0.00,'2022-04-22 17:42:35','',''),(662,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-22 17:45:38','',''),(663,'21','221',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,27300.00,0.00,'2022-04-22 17:49:43','',''),(664,'21','221','3',1,'Received from bridging 77',0.00,0.00,27300.00,0.00,0.00,'2022-04-22 17:49:43','',''),(665,'21','221',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,20450.00,0.00,'2022-04-22 17:49:43','',''),(666,'21','221','2',1,'Received from bridging 76',0.00,0.00,20450.00,0.00,0.00,'2022-04-22 17:49:43','',''),(667,'21','221',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,12250.00,0.00,'2022-04-22 17:49:43','',''),(668,'21','221','1',1,'Received from bridging 75',0.00,0.00,12250.00,0.00,0.00,'2022-04-22 17:49:43','',''),(669,'21','221','1',1,'Sale Id shift 25',0.00,0.00,0.00,703.49,0.00,'2022-04-22 18:45:05','',''),(670,'21','221','2',1,'Sale Id shift 25',0.00,0.00,0.00,5304.65,0.00,'2022-04-22 18:45:05','',''),(671,'21','221','2',1,'Sale Id shift 25',0.00,0.00,0.00,3021.54,0.00,'2022-04-22 18:45:05','',''),(672,'21','221','3',1,'Sale Id shift 25',0.00,0.00,0.00,3355.92,0.00,'2022-04-22 18:45:05','',''),(673,'21','221','3',1,'Sale Id shift 25',0.00,0.00,0.00,2787.04,0.00,'2022-04-22 18:45:05','',''),(674,'21','221','3',1,'Sale Id shift 25',0.00,0.00,0.00,3764.04,0.00,'2022-04-22 18:45:05','',''),(675,'21','221','3',1,'Sale Id shift 25',0.00,0.00,0.00,3785.55,0.00,'2022-04-22 18:45:05','',''),(676,'21','221','3',1,'Sale Id shift 25',0.00,0.00,0.00,1161.52,0.00,'2022-04-22 18:45:05','',''),(677,'21','221','3',1,'Sale Id shift 25',0.00,0.00,0.00,3066.65,0.00,'2022-04-22 18:45:05','',''),(678,'21','221','3',1,'Sale Id shift 25',0.00,0.00,0.00,4188.05,0.00,'2022-04-22 18:45:05','',''),(679,'21','221','1',1,'Sale Id shift 25',0.00,0.00,0.00,3384.85,0.00,'2022-04-22 18:45:05','',''),(680,'21','221','4',2,'Sale Id shift 25',0.00,0.00,0.00,6484.00,0.00,'2022-04-22 18:45:05','',''),(681,'21','221','4',2,'Sale Id shift 25',0.00,0.00,0.00,2095.30,0.00,'2022-04-22 18:45:05','',''),(682,'21','221','5',3,'Sale Id shift 25',0.00,0.00,0.00,748.77,0.00,'2022-04-22 18:45:05','',''),(683,'21','221','3',1,'Sale Id shift 25',0.00,0.00,0.00,1873.96,0.00,'2022-04-22 18:45:05','',''),(684,'21','221','1',1,'Sale Id shift 25',0.00,0.00,0.00,4298.64,0.00,'2022-04-22 18:45:05','',''),(685,'21','221','1',1,'Sale Id shift 25',0.00,0.00,0.00,6101.09,0.00,'2022-04-22 18:45:05','',''),(686,'21','221','2',1,'Sale Id shift 25',0.00,0.00,0.00,4308.26,0.00,'2022-04-22 18:45:05','',''),(687,'21','221','2',1,'Sale Id shift 25',0.00,0.00,0.00,3956.58,0.00,'2022-04-22 18:45:05','',''),(688,'21','221','2',1,'Sale Id shift 25',0.00,0.00,0.00,2238.14,0.00,'2022-04-22 18:45:05','',''),(689,'21','221','2',1,'Sale Id shift 25',0.00,0.00,0.00,2845.09,0.00,'2022-04-22 18:45:05','',''),(690,'21','221',NULL,1,'Sale Id shift 25',9923934.90,0.00,0.00,0.00,0.00,'2022-04-22 18:45:05','',''),(691,'21','221',NULL,2,'Sale Id shift 25',6005510.00,0.00,0.00,0.00,0.00,'2022-04-22 18:45:05','',''),(692,'21','221',NULL,3,'Sale Id shift 25',411823.50,0.00,0.00,0.00,0.00,'2022-04-22 18:45:05','',''),(693,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21000000.00,30000.00,0.00,0.00,'2022-04-22 20:53:50','',''),(694,'21','221',NULL,2,'Reception corrector for bridging 78',0.00,0.00,0.00,30000.00,0.00,'2022-04-22 20:55:10','',''),(695,'21','221','4',2,'Received from bridging 78',0.00,0.00,30000.00,0.00,0.00,'2022-04-22 20:55:10','',''),(696,'21','221','1',1,'Sale Id shift 26',0.00,0.00,0.00,1451.05,0.00,'2022-04-23 08:38:38','',''),(697,'21','221','2',1,'Sale Id shift 26',0.00,0.00,0.00,5043.38,0.00,'2022-04-23 08:38:38','',''),(698,'21','221','2',1,'Sale Id shift 26',0.00,0.00,0.00,2037.52,0.00,'2022-04-23 08:38:38','',''),(699,'21','221','3',1,'Sale Id shift 26',0.00,0.00,0.00,4112.06,0.00,'2022-04-23 08:38:38','',''),(700,'21','221','3',1,'Sale Id shift 26',0.00,0.00,0.00,3606.39,0.00,'2022-04-23 08:38:38','',''),(701,'21','221','3',1,'Sale Id shift 26',0.00,0.00,0.00,2645.63,0.00,'2022-04-23 08:38:38','',''),(702,'21','221','3',1,'Sale Id shift 26',0.00,0.00,0.00,2976.44,0.00,'2022-04-23 08:38:38','',''),(703,'21','221','3',1,'Sale Id shift 26',0.00,0.00,0.00,2963.81,0.00,'2022-04-23 08:38:38','',''),(704,'21','221','3',1,'Sale Id shift 26',0.00,0.00,0.00,3129.82,0.00,'2022-04-23 08:38:38','',''),(705,'21','221','3',1,'Sale Id shift 26',0.00,0.00,0.00,3953.19,0.00,'2022-04-23 08:38:38','',''),(706,'21','221','1',1,'Sale Id shift 26',0.00,0.00,0.00,3295.79,0.00,'2022-04-23 08:38:38','',''),(707,'21','221','4',2,'Sale Id shift 26',0.00,0.00,0.00,7117.16,0.00,'2022-04-23 08:38:38','',''),(708,'21','221','4',2,'Sale Id shift 26',0.00,0.00,0.00,7187.84,0.00,'2022-04-23 08:38:38','',''),(709,'21','221','5',3,'Sale Id shift 26',0.00,0.00,0.00,1162.57,0.00,'2022-04-23 08:38:38','',''),(710,'21','221','3',1,'Sale Id shift 26',0.00,0.00,0.00,3310.97,0.00,'2022-04-23 08:38:38','',''),(711,'21','221','1',1,'Sale Id shift 26',0.00,0.00,0.00,4858.99,0.00,'2022-04-23 08:38:38','',''),(712,'21','221','1',1,'Sale Id shift 26',0.00,0.00,0.00,3584.98,0.00,'2022-04-23 08:38:38','',''),(713,'21','221','2',1,'Sale Id shift 26',0.00,0.00,0.00,4133.69,0.00,'2022-04-23 08:38:38','',''),(714,'21','221','2',1,'Sale Id shift 26',0.00,0.00,0.00,2278.77,0.00,'2022-04-23 08:38:38','',''),(715,'21','221','2',1,'Sale Id shift 26',0.00,0.00,0.00,2978.28,0.00,'2022-04-23 08:38:38','',''),(716,'21','221','2',1,'Sale Id shift 26',0.00,0.00,0.00,3441.26,0.00,'2022-04-23 08:38:38','',''),(717,'21','221',NULL,1,'Sale Id shift 26',9867333.30,0.00,0.00,0.00,0.00,'2022-04-23 08:38:38','',''),(718,'21','221',NULL,2,'Sale Id shift 26',10013500.00,0.00,0.00,0.00,0.00,'2022-04-23 08:38:38','',''),(719,'21','221',NULL,3,'Sale Id shift 26',639413.50,0.00,0.00,0.00,0.00,'2022-04-23 08:38:38','',''),(720,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-23 09:08:36','',''),(721,'21','221',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,20000.00,0.00,'2022-04-23 09:14:30','',''),(722,'21','221','3',1,'Received from bridging 81',0.00,0.00,20000.00,0.00,0.00,'2022-04-23 09:14:30','',''),(723,'21','221',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,20000.00,0.00,'2022-04-23 09:14:30','',''),(724,'21','221','2',1,'Received from bridging 80',0.00,0.00,20000.00,0.00,0.00,'2022-04-23 09:14:30','',''),(725,'21','221',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,20000.00,0.00,'2022-04-23 09:14:30','',''),(726,'21','221','1',1,'Received from bridging 79',0.00,0.00,20000.00,0.00,0.00,'2022-04-23 09:14:30','',''),(727,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-23 09:22:46','',''),(728,'21','221',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,30000.00,0.00,'2022-04-23 09:25:40','',''),(729,'21','221','3',1,'Received from bridging 83',0.00,0.00,30000.00,0.00,0.00,'2022-04-23 09:25:40','',''),(730,'21','221',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,30000.00,0.00,'2022-04-23 09:25:40','',''),(731,'21','221','2',1,'Received from bridging 82',0.00,0.00,30000.00,0.00,0.00,'2022-04-23 09:25:40','',''),(732,'21','221','1',1,'Sale Id shift 27',0.00,0.00,0.00,4815.69,0.00,'2022-04-23 11:22:22','',''),(733,'21','221','2',1,'Sale Id shift 27',0.00,0.00,0.00,3886.80,0.00,'2022-04-23 11:22:22','',''),(734,'21','221','2',1,'Sale Id shift 27',0.00,0.00,0.00,2165.73,0.00,'2022-04-23 11:22:22','',''),(735,'21','221','3',1,'Sale Id shift 27',0.00,0.00,0.00,3511.87,0.00,'2022-04-23 11:22:22','',''),(736,'21','221','3',1,'Sale Id shift 27',0.00,0.00,0.00,2134.95,0.00,'2022-04-23 11:22:22','',''),(737,'21','221','3',1,'Sale Id shift 27',0.00,0.00,0.00,2778.85,0.00,'2022-04-23 11:22:22','',''),(738,'21','221','3',1,'Sale Id shift 27',0.00,0.00,0.00,2224.96,0.00,'2022-04-23 11:22:22','',''),(739,'21','221','3',1,'Sale Id shift 27',0.00,0.00,0.00,1765.05,0.00,'2022-04-23 11:22:22','',''),(740,'21','221','3',1,'Sale Id shift 27',0.00,0.00,0.00,2026.25,0.00,'2022-04-23 11:22:22','',''),(741,'21','221','3',1,'Sale Id shift 27',0.00,0.00,0.00,3001.87,0.00,'2022-04-23 11:22:22','',''),(742,'21','221','1',1,'Sale Id shift 27',0.00,0.00,0.00,3961.62,0.00,'2022-04-23 11:22:22','',''),(743,'21','221','4',2,'Sale Id shift 27',0.00,0.00,0.00,6964.17,0.00,'2022-04-23 11:22:22','',''),(744,'21','221','4',2,'Sale Id shift 27',0.00,0.00,0.00,6780.56,0.00,'2022-04-23 11:22:22','',''),(745,'21','221','5',3,'Sale Id shift 27',0.00,0.00,0.00,1465.93,0.00,'2022-04-23 11:22:22','',''),(746,'21','221','3',1,'Sale Id shift 27',0.00,0.00,0.00,2589.71,0.00,'2022-04-23 11:22:22','',''),(747,'21','221','1',1,'Sale Id shift 27',0.00,0.00,0.00,4791.28,0.00,'2022-04-23 11:22:22','',''),(748,'21','221','1',1,'Sale Id shift 27',0.00,0.00,0.00,6662.90,0.00,'2022-04-23 11:22:22','',''),(749,'21','221','2',1,'Sale Id shift 27',0.00,0.00,0.00,4757.94,0.00,'2022-04-23 11:22:22','',''),(750,'21','221','2',1,'Sale Id shift 27',0.00,0.00,0.00,2584.04,0.00,'2022-04-23 11:22:22','',''),(751,'21','221','2',1,'Sale Id shift 27',0.00,0.00,0.00,3440.41,0.00,'2022-04-23 11:22:22','',''),(752,'21','221','2',1,'Sale Id shift 27',0.00,0.00,0.00,3422.65,0.00,'2022-04-23 11:22:22','',''),(753,'21','221',NULL,1,'Sale Id shift 27',9986224.05,0.00,0.00,0.00,0.00,'2022-04-23 11:22:22','',''),(754,'21','221',NULL,2,'Sale Id shift 27',9621311.00,0.00,0.00,0.00,0.00,'2022-04-23 11:22:22','',''),(755,'21','221',NULL,3,'Sale Id shift 27',806261.50,0.00,0.00,0.00,0.00,'2022-04-23 11:22:22','',''),(756,'21','221',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,16500000.00,30000.00,0.00,0.00,'2022-04-23 11:39:19','',''),(757,'21','221',NULL,3,'Reception corrector for bridging 84',0.00,0.00,0.00,30000.00,0.00,'2022-04-23 11:41:33','',''),(758,'21','221','5',3,'Received from bridging 84',0.00,0.00,30000.00,0.00,0.00,'2022-04-23 11:41:33','',''),(759,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11550000.00,16500.00,0.00,0.00,'2022-04-23 11:42:39','',''),(760,'21','221',NULL,2,'Reception corrector for bridging 85',0.00,0.00,0.00,16500.00,0.00,'2022-04-23 11:46:07','',''),(761,'21','221','4',2,'Received from bridging 85',0.00,0.00,16500.00,0.00,0.00,'2022-04-23 11:46:07','',''),(762,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-23 11:51:21','',''),(763,'21','221',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,45000.00,0.00,'2022-04-23 11:54:54','',''),(764,'21','221','2',1,'Received from bridging 87',0.00,0.00,45000.00,0.00,0.00,'2022-04-23 11:54:54','',''),(765,'21','221',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,15000.00,0.00,'2022-04-23 11:54:54','',''),(766,'21','221','1',1,'Received from bridging 86',0.00,0.00,15000.00,0.00,0.00,'2022-04-23 11:54:54','',''),(767,'21','221','1',1,'Sale Id shift 28',0.00,0.00,0.00,2337.32,0.00,'2022-04-23 14:05:41','',''),(768,'21','221','2',1,'Sale Id shift 28',0.00,0.00,0.00,5226.02,0.00,'2022-04-23 14:05:41','',''),(769,'21','221','2',1,'Sale Id shift 28',0.00,0.00,0.00,3335.84,0.00,'2022-04-23 14:05:41','',''),(770,'21','221','3',1,'Sale Id shift 28',0.00,0.00,0.00,4287.40,0.00,'2022-04-23 14:05:41','',''),(771,'21','221','3',1,'Sale Id shift 28',0.00,0.00,0.00,2811.41,0.00,'2022-04-23 14:05:41','',''),(772,'21','221','3',1,'Sale Id shift 28',0.00,0.00,0.00,3691.90,0.00,'2022-04-23 14:05:41','',''),(773,'21','221','3',1,'Sale Id shift 28',0.00,0.00,0.00,3429.69,0.00,'2022-04-23 14:05:41','',''),(774,'21','221','3',1,'Sale Id shift 28',0.00,0.00,0.00,3066.11,0.00,'2022-04-23 14:05:41','',''),(775,'21','221','3',1,'Sale Id shift 28',0.00,0.00,0.00,5194.61,0.00,'2022-04-23 14:05:41','',''),(776,'21','221','3',1,'Sale Id shift 28',0.00,0.00,0.00,4701.64,0.00,'2022-04-23 14:05:41','',''),(777,'21','221','1',1,'Sale Id shift 28',0.00,0.00,0.00,1803.99,0.00,'2022-04-23 14:05:41','',''),(778,'21','221','4',2,'Sale Id shift 28',0.00,0.00,0.00,6802.69,0.00,'2022-04-23 14:05:41','',''),(779,'21','221','4',2,'Sale Id shift 28',0.00,0.00,0.00,6275.68,0.00,'2022-04-23 14:05:41','',''),(780,'21','221','5',3,'Sale Id shift 28',0.00,0.00,0.00,806.55,0.00,'2022-04-23 14:05:41','',''),(781,'21','221','3',1,'Sale Id shift 28',0.00,0.00,0.00,2791.82,0.00,'2022-04-23 14:05:41','',''),(782,'21','221','1',1,'Sale Id shift 28',0.00,0.00,0.00,2675.62,0.00,'2022-04-23 14:05:41','',''),(783,'21','221','1',1,'Sale Id shift 28',0.00,0.00,0.00,2436.50,0.00,'2022-04-23 14:05:41','',''),(784,'21','221','2',1,'Sale Id shift 28',0.00,0.00,0.00,4627.02,0.00,'2022-04-23 14:05:41','',''),(785,'21','221','2',1,'Sale Id shift 28',0.00,0.00,0.00,2593.37,0.00,'2022-04-23 14:05:41','',''),(786,'21','221','2',1,'Sale Id shift 28',0.00,0.00,0.00,1453.39,0.00,'2022-04-23 14:05:41','',''),(787,'21','221','2',1,'Sale Id shift 28',0.00,0.00,0.00,3651.13,0.00,'2022-04-23 14:05:41','',''),(788,'21','221',NULL,1,'Sale Id shift 28',9918938.70,0.00,0.00,0.00,0.00,'2022-04-23 14:05:41','',''),(789,'21','221',NULL,2,'Sale Id shift 28',9154859.00,0.00,0.00,0.00,0.00,'2022-04-23 14:05:41','',''),(790,'21','221',NULL,3,'Sale Id shift 28',443602.50,0.00,0.00,0.00,0.00,'2022-04-23 14:05:41','',''),(791,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-23 14:37:47','',''),(792,'21','221',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,60000.00,0.00,'2022-04-23 14:40:15','',''),(793,'21','221','3',1,'Received from bridging 88',0.00,0.00,60000.00,0.00,0.00,'2022-04-23 14:40:15','',''),(794,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,14000000.00,20000.00,0.00,0.00,'2022-04-23 14:45:31','',''),(795,'21','221',NULL,2,'Reception corrector for bridging 89',0.00,0.00,0.00,20000.00,0.00,'2022-04-23 14:48:47','',''),(796,'21','221','4',2,'Received from bridging 89',0.00,0.00,20000.00,0.00,0.00,'2022-04-23 14:48:47','',''),(797,'21','221','1',1,'Sale Id shift 29',0.00,0.00,0.00,3265.31,0.00,'2022-04-23 17:16:36','',''),(798,'21','221','2',1,'Sale Id shift 29',0.00,0.00,0.00,3435.85,0.00,'2022-04-23 17:16:36','',''),(799,'21','221','2',1,'Sale Id shift 29',0.00,0.00,0.00,2475.20,0.00,'2022-04-23 17:16:36','',''),(800,'21','221','3',1,'Sale Id shift 29',0.00,0.00,0.00,4068.13,0.00,'2022-04-23 17:16:36','',''),(801,'21','221','3',1,'Sale Id shift 29',0.00,0.00,0.00,2825.83,0.00,'2022-04-23 17:16:36','',''),(802,'21','221','3',1,'Sale Id shift 29',0.00,0.00,0.00,3317.53,0.00,'2022-04-23 17:16:36','',''),(803,'21','221','3',1,'Sale Id shift 29',0.00,0.00,0.00,3315.86,0.00,'2022-04-23 17:16:36','',''),(804,'21','221','3',1,'Sale Id shift 29',0.00,0.00,0.00,3270.35,0.00,'2022-04-23 17:16:36','',''),(805,'21','221','3',1,'Sale Id shift 29',0.00,0.00,0.00,3448.62,0.00,'2022-04-23 17:16:36','',''),(806,'21','221','3',1,'Sale Id shift 29',0.00,0.00,0.00,3449.59,0.00,'2022-04-23 17:16:36','',''),(807,'21','221','1',1,'Sale Id shift 29',0.00,0.00,0.00,2171.56,0.00,'2022-04-23 17:16:36','',''),(808,'21','221','4',2,'Sale Id shift 29',0.00,0.00,0.00,7308.55,0.00,'2022-04-23 17:16:36','',''),(809,'21','221','4',2,'Sale Id shift 29',0.00,0.00,0.00,5275.61,0.00,'2022-04-23 17:16:36','',''),(810,'21','221','5',3,'Sale Id shift 29',0.00,0.00,0.00,1038.84,0.00,'2022-04-23 17:16:36','',''),(811,'21','221','3',1,'Sale Id shift 29',0.00,0.00,0.00,3481.06,0.00,'2022-04-23 17:16:36','',''),(812,'21','221','1',1,'Sale Id shift 29',0.00,0.00,0.00,3507.28,0.00,'2022-04-23 17:16:36','',''),(813,'21','221','1',1,'Sale Id shift 29',0.00,0.00,0.00,4505.15,0.00,'2022-04-23 17:16:36','',''),(814,'21','221','2',1,'Sale Id shift 29',0.00,0.00,0.00,4579.62,0.00,'2022-04-23 17:16:36','',''),(815,'21','221','2',1,'Sale Id shift 29',0.00,0.00,0.00,2109.49,0.00,'2022-04-23 17:16:36','',''),(816,'21','221','2',1,'Sale Id shift 29',0.00,0.00,0.00,2406.32,0.00,'2022-04-23 17:16:36','',''),(817,'21','221','2',1,'Sale Id shift 29',0.00,0.00,0.00,3929.92,0.00,'2022-04-23 17:16:36','',''),(818,'21','221',NULL,1,'Sale Id shift 29',9827840.55,0.00,0.00,0.00,0.00,'2022-04-23 17:16:36','',''),(819,'21','221',NULL,2,'Sale Id shift 29',8808912.00,0.00,0.00,0.00,0.00,'2022-04-23 17:16:36','',''),(820,'21','221',NULL,3,'Sale Id shift 29',571362.00,0.00,0.00,0.00,0.00,'2022-04-23 17:16:36','',''),(821,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-24 09:37:43','',''),(822,'21','221',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,20000.00,0.00,'2022-04-24 09:41:13','',''),(823,'21','221','3',1,'Received from bridging 91',0.00,0.00,20000.00,0.00,0.00,'2022-04-24 09:41:13','',''),(824,'21','221',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,30000.00,0.00,'2022-04-24 09:41:13','',''),(825,'21','221','1',1,'Received from bridging 90',0.00,0.00,30000.00,0.00,0.00,'2022-04-24 09:41:13','',''),(826,'21','221','1',1,'Sale Id shift 30',0.00,0.00,0.00,2922.71,0.00,'2022-04-24 10:50:39','',''),(827,'21','221','2',1,'Sale Id shift 30',0.00,0.00,0.00,5380.48,0.00,'2022-04-24 10:50:39','',''),(828,'21','221','2',1,'Sale Id shift 30',0.00,0.00,0.00,2889.49,0.00,'2022-04-24 10:50:39','',''),(829,'21','221','3',1,'Sale Id shift 30',0.00,0.00,0.00,3577.89,0.00,'2022-04-24 10:50:39','',''),(830,'21','221','3',1,'Sale Id shift 30',0.00,0.00,0.00,1680.91,0.00,'2022-04-24 10:50:39','',''),(831,'21','221','3',1,'Sale Id shift 30',0.00,0.00,0.00,4591.66,0.00,'2022-04-24 10:50:39','',''),(832,'21','221','3',1,'Sale Id shift 30',0.00,0.00,0.00,2450.97,0.00,'2022-04-24 10:50:39','',''),(833,'21','221','3',1,'Sale Id shift 30',0.00,0.00,0.00,3739.62,0.00,'2022-04-24 10:50:39','',''),(834,'21','221','3',1,'Sale Id shift 30',0.00,0.00,0.00,2827.84,0.00,'2022-04-24 10:50:39','',''),(835,'21','221','3',1,'Sale Id shift 30',0.00,0.00,0.00,3515.66,0.00,'2022-04-24 10:50:39','',''),(836,'21','221','1',1,'Sale Id shift 30',0.00,0.00,0.00,2806.16,0.00,'2022-04-24 10:50:39','',''),(837,'21','221','4',2,'Sale Id shift 30',0.00,0.00,0.00,6148.43,0.00,'2022-04-24 10:50:39','',''),(838,'21','221','4',2,'Sale Id shift 30',0.00,0.00,0.00,5036.81,0.00,'2022-04-24 10:50:39','',''),(839,'21','221','5',3,'Sale Id shift 30',0.00,0.00,0.00,891.20,0.00,'2022-04-24 10:50:39','',''),(840,'21','221','3',1,'Sale Id shift 30',0.00,0.00,0.00,2840.73,0.00,'2022-04-24 10:50:39','',''),(841,'21','221','1',1,'Sale Id shift 30',0.00,0.00,0.00,3078.03,0.00,'2022-04-24 10:50:39','',''),(842,'21','221','1',1,'Sale Id shift 30',0.00,0.00,0.00,3108.49,0.00,'2022-04-24 10:50:39','',''),(843,'21','221','2',1,'Sale Id shift 30',0.00,0.00,0.00,5393.44,0.00,'2022-04-24 10:50:39','',''),(844,'21','221','2',1,'Sale Id shift 30',0.00,0.00,0.00,2976.05,0.00,'2022-04-24 10:50:39','',''),(845,'21','221','2',1,'Sale Id shift 30',0.00,0.00,0.00,3212.92,0.00,'2022-04-24 10:50:39','',''),(846,'21','221','2',1,'Sale Id shift 30',0.00,0.00,0.00,3156.45,0.00,'2022-04-24 10:50:39','',''),(847,'21','221',NULL,2,'Sale Id shift 30',7829668.00,0.00,0.00,0.00,0.00,'2022-04-24 10:50:39','',''),(848,'21','221',NULL,3,'Sale Id shift 30',490160.00,0.00,0.00,0.00,0.00,'2022-04-24 10:50:39','',''),(849,'21','221',NULL,1,'Sale Id shift 30',9924667.50,0.00,0.00,0.00,0.00,'2022-04-24 10:50:39','',''),(850,'21','221','1',1,'Sale Id shift 31',0.00,0.00,0.00,2494.56,0.00,'2022-04-24 12:02:09','',''),(851,'21','221','2',1,'Sale Id shift 31',0.00,0.00,0.00,4644.67,0.00,'2022-04-24 12:02:09','',''),(852,'21','221','2',1,'Sale Id shift 31',0.00,0.00,0.00,2902.85,0.00,'2022-04-24 12:02:09','',''),(853,'21','221','3',1,'Sale Id shift 31',0.00,0.00,0.00,2648.72,0.00,'2022-04-24 12:02:09','',''),(854,'21','221','3',1,'Sale Id shift 31',0.00,0.00,0.00,2416.32,0.00,'2022-04-24 12:02:09','',''),(855,'21','221','3',1,'Sale Id shift 31',0.00,0.00,0.00,3161.32,0.00,'2022-04-24 12:02:09','',''),(856,'21','221','3',1,'Sale Id shift 31',0.00,0.00,0.00,478.39,0.00,'2022-04-24 12:02:09','',''),(857,'21','221','3',1,'Sale Id shift 31',0.00,0.00,0.00,3483.37,0.00,'2022-04-24 12:02:09','',''),(858,'21','221','3',1,'Sale Id shift 31',0.00,0.00,0.00,2163.04,0.00,'2022-04-24 12:02:09','',''),(859,'21','221','3',1,'Sale Id shift 31',0.00,0.00,0.00,2781.82,0.00,'2022-04-24 12:02:09','',''),(860,'21','221','1',1,'Sale Id shift 31',0.00,0.00,0.00,2375.58,0.00,'2022-04-24 12:02:09','',''),(861,'21','221','4',2,'Sale Id shift 31',0.00,0.00,0.00,5887.24,0.00,'2022-04-24 12:02:09','',''),(862,'21','221','4',2,'Sale Id shift 31',0.00,0.00,0.00,3739.66,0.00,'2022-04-24 12:02:09','',''),(863,'21','221','5',3,'Sale Id shift 31',0.00,0.00,0.00,1072.12,0.00,'2022-04-24 12:02:09','',''),(864,'21','221','3',1,'Sale Id shift 31',0.00,0.00,0.00,2475.01,0.00,'2022-04-24 12:02:09','',''),(865,'21','221','1',1,'Sale Id shift 31',0.00,0.00,0.00,2718.53,0.00,'2022-04-24 12:02:09','',''),(866,'21','221','1',1,'Sale Id shift 31',0.00,0.00,0.00,2376.94,0.00,'2022-04-24 12:02:09','',''),(867,'21','221','2',1,'Sale Id shift 31',0.00,0.00,0.00,4540.97,0.00,'2022-04-24 12:02:09','',''),(868,'21','221','2',1,'Sale Id shift 31',0.00,0.00,0.00,2768.68,0.00,'2022-04-24 12:02:09','',''),(869,'21','221','2',1,'Sale Id shift 31',0.00,0.00,0.00,2121.93,0.00,'2022-04-24 12:02:09','',''),(870,'21','221','2',1,'Sale Id shift 31',0.00,0.00,0.00,3248.74,0.00,'2022-04-24 12:02:09','',''),(871,'21','221',NULL,1,'Sale Id shift 31',8217237.60,0.00,0.00,0.00,0.00,'2022-04-24 12:02:09','',''),(872,'21','221',NULL,2,'Sale Id shift 31',6738830.00,0.00,0.00,0.00,0.00,'2022-04-24 12:02:09','',''),(873,'21','221',NULL,3,'Sale Id shift 31',589666.00,0.00,0.00,0.00,0.00,'2022-04-24 12:02:09','',''),(874,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28000000.00,40000.00,0.00,0.00,'2022-04-24 12:28:54','',''),(875,'21','221',NULL,2,'Reception corrector for bridging 92',0.00,0.00,0.00,40000.00,0.00,'2022-04-24 12:33:13','',''),(876,'21','221','4',2,'Received from bridging 92',0.00,0.00,40000.00,0.00,0.00,'2022-04-24 12:33:13','',''),(877,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-24 12:34:25','',''),(878,'21','221',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,60000.00,0.00,'2022-04-24 12:37:03','',''),(879,'21','221','2',1,'Received from bridging 93',0.00,0.00,60000.00,0.00,0.00,'2022-04-24 12:37:03','',''),(880,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-24 13:29:17','',''),(881,'21','221',NULL,1,'Reception corrector for bridging 94',0.00,0.00,0.00,60000.00,0.00,'2022-04-24 13:33:40','',''),(882,'21','221','3',1,'Received from bridging 94',0.00,0.00,60000.00,0.00,0.00,'2022-04-24 13:33:40','',''),(883,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-24 13:36:28','',''),(884,'21','221',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,20000.00,0.00,'2022-04-24 13:39:23','',''),(885,'21','221','2',1,'Received from bridging 96',0.00,0.00,20000.00,0.00,0.00,'2022-04-24 13:39:23','',''),(886,'21','221',NULL,1,'Reception corrector for bridging 95',0.00,0.00,0.00,20000.00,0.00,'2022-04-24 13:39:23','',''),(887,'21','221','1',1,'Received from bridging 95',0.00,0.00,20000.00,0.00,0.00,'2022-04-24 13:39:23','',''),(888,'21','221','1',1,'Sale Id shift 32',0.00,0.00,0.00,3151.18,0.00,'2022-04-24 14:51:01','',''),(889,'21','221','2',1,'Sale Id shift 32',0.00,0.00,0.00,5549.21,0.00,'2022-04-24 14:51:01','',''),(890,'21','221','2',1,'Sale Id shift 32',0.00,0.00,0.00,3947.78,0.00,'2022-04-24 14:51:01','',''),(891,'21','221','3',1,'Sale Id shift 32',0.00,0.00,0.00,3141.48,0.00,'2022-04-24 14:51:01','',''),(892,'21','221','3',1,'Sale Id shift 32',0.00,0.00,0.00,1466.36,0.00,'2022-04-24 14:51:01','',''),(893,'21','221','3',1,'Sale Id shift 32',0.00,0.00,0.00,3121.60,0.00,'2022-04-24 14:51:01','',''),(894,'21','221','3',1,'Sale Id shift 32',0.00,0.00,0.00,3469.33,0.00,'2022-04-24 14:51:01','',''),(895,'21','221','3',1,'Sale Id shift 32',0.00,0.00,0.00,2190.21,0.00,'2022-04-24 14:51:01','',''),(896,'21','221','3',1,'Sale Id shift 32',0.00,0.00,0.00,2402.76,0.00,'2022-04-24 14:51:01','',''),(897,'21','221','3',1,'Sale Id shift 32',0.00,0.00,0.00,3064.46,0.00,'2022-04-24 14:51:01','',''),(898,'21','221','1',1,'Sale Id shift 32',0.00,0.00,0.00,2673.23,0.00,'2022-04-24 14:51:01','',''),(899,'21','221','4',2,'Sale Id shift 32',0.00,0.00,0.00,5405.62,0.00,'2022-04-24 14:51:01','',''),(900,'21','221','4',2,'Sale Id shift 32',0.00,0.00,0.00,108.77,0.00,'2022-04-24 14:51:01','',''),(901,'21','221','5',3,'Sale Id shift 32',0.00,0.00,0.00,653.27,0.00,'2022-04-24 14:51:01','',''),(902,'21','221','3',1,'Sale Id shift 32',0.00,0.00,0.00,3234.09,0.00,'2022-04-24 14:51:01','',''),(903,'21','221','1',1,'Sale Id shift 32',0.00,0.00,0.00,1873.11,0.00,'2022-04-24 14:51:01','',''),(904,'21','221','1',1,'Sale Id shift 32',0.00,0.00,0.00,3878.44,0.00,'2022-04-24 14:51:01','',''),(905,'21','221','2',1,'Sale Id shift 32',0.00,0.00,0.00,6797.28,0.00,'2022-04-24 14:51:01','',''),(906,'21','221','2',1,'Sale Id shift 32',0.00,0.00,0.00,3065.39,0.00,'2022-04-24 14:51:01','',''),(907,'21','221','2',1,'Sale Id shift 32',0.00,0.00,0.00,2854.75,0.00,'2022-04-24 14:51:01','',''),(908,'21','221','2',1,'Sale Id shift 32',0.00,0.00,0.00,4329.98,0.00,'2022-04-24 14:51:01','',''),(909,'21','221',NULL,1,'Sale Id shift 32',9934755.60,0.00,0.00,0.00,0.00,'2022-04-24 14:51:01','',''),(910,'21','221',NULL,2,'Sale Id shift 32',3860073.00,0.00,0.00,0.00,0.00,'2022-04-24 14:51:01','',''),(911,'21','221',NULL,3,'Sale Id shift 32',359298.50,0.00,0.00,0.00,0.00,'2022-04-24 14:51:01','',''),(912,'21','221','1',1,'Sale Id shift 33',0.00,0.00,0.00,3674.53,0.00,'2022-04-24 17:17:51','',''),(913,'21','221','2',1,'Sale Id shift 33',0.00,0.00,0.00,4165.97,0.00,'2022-04-24 17:17:51','',''),(914,'21','221','2',1,'Sale Id shift 33',0.00,0.00,0.00,651.16,0.00,'2022-04-24 17:17:51','',''),(915,'21','221','3',1,'Sale Id shift 33',0.00,0.00,0.00,4050.06,0.00,'2022-04-24 17:17:51','',''),(916,'21','221','3',1,'Sale Id shift 33',0.00,0.00,0.00,1757.04,0.00,'2022-04-24 17:17:51','',''),(917,'21','221','3',1,'Sale Id shift 33',0.00,0.00,0.00,2428.70,0.00,'2022-04-24 17:17:51','',''),(918,'21','221','3',1,'Sale Id shift 33',0.00,0.00,0.00,2590.93,0.00,'2022-04-24 17:17:51','',''),(919,'21','221','3',1,'Sale Id shift 33',0.00,0.00,0.00,2294.72,0.00,'2022-04-24 17:17:51','',''),(920,'21','221','3',1,'Sale Id shift 33',0.00,0.00,0.00,2349.74,0.00,'2022-04-24 17:17:51','',''),(921,'21','221','3',1,'Sale Id shift 33',0.00,0.00,0.00,2516.11,0.00,'2022-04-24 17:17:51','',''),(922,'21','221','1',1,'Sale Id shift 33',0.00,0.00,0.00,2934.44,0.00,'2022-04-24 17:17:51','',''),(923,'21','221','4',2,'Sale Id shift 33',0.00,0.00,0.00,4295.61,0.00,'2022-04-24 17:17:51','',''),(924,'21','221','4',2,'Sale Id shift 33',0.00,0.00,0.00,1670.95,0.00,'2022-04-24 17:17:51','',''),(925,'21','221','5',3,'Sale Id shift 33',0.00,0.00,0.00,576.15,0.00,'2022-04-24 17:17:51','',''),(926,'21','221','3',1,'Sale Id shift 33',0.00,0.00,0.00,2375.32,0.00,'2022-04-24 17:17:51','',''),(927,'21','221','1',1,'Sale Id shift 33',0.00,0.00,0.00,3190.09,0.00,'2022-04-24 17:17:51','',''),(928,'21','221','1',1,'Sale Id shift 33',0.00,0.00,0.00,3565.79,0.00,'2022-04-24 17:17:51','',''),(929,'21','221','2',1,'Sale Id shift 33',0.00,0.00,0.00,5006.58,0.00,'2022-04-24 17:17:51','',''),(930,'21','221','2',1,'Sale Id shift 33',0.00,0.00,0.00,1585.41,0.00,'2022-04-24 17:17:51','',''),(931,'21','221','2',1,'Sale Id shift 33',0.00,0.00,0.00,3584.81,0.00,'2022-04-24 17:17:51','',''),(932,'21','221','2',1,'Sale Id shift 33',0.00,0.00,0.00,4564.51,0.00,'2022-04-24 17:17:51','',''),(933,'21','221',NULL,1,'Sale Id shift 33',8792175.15,0.00,0.00,0.00,0.00,'2022-04-24 17:17:51','',''),(934,'21','221',NULL,2,'Sale Id shift 33',4176592.00,0.00,0.00,0.00,0.00,'2022-04-24 17:17:51','',''),(935,'21','221',NULL,3,'Sale Id shift 33',316882.50,0.00,0.00,0.00,0.00,'2022-04-24 17:17:51','',''),(936,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-24 17:33:33','',''),(937,'21','221',NULL,1,'Reception corrector for bridging 99',0.00,0.00,0.00,20000.00,0.00,'2022-04-24 17:36:04','',''),(938,'21','221','3',1,'Received from bridging 99',0.00,0.00,20000.00,0.00,0.00,'2022-04-24 17:36:04','',''),(939,'21','221',NULL,1,'Reception corrector for bridging 98',0.00,0.00,0.00,20000.00,0.00,'2022-04-24 17:36:04','',''),(940,'21','221','2',1,'Received from bridging 98',0.00,0.00,20000.00,0.00,0.00,'2022-04-24 17:36:04','',''),(941,'21','221',NULL,1,'Reception corrector for bridging 97',0.00,0.00,0.00,20000.00,0.00,'2022-04-24 17:36:04','',''),(942,'21','221','1',1,'Received from bridging 97',0.00,0.00,20000.00,0.00,0.00,'2022-04-24 17:36:04','',''),(943,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3500000.00,5000.00,0.00,0.00,'2022-04-24 17:36:21','',''),(944,'21','221',NULL,2,'Reception corrector for bridging 100',0.00,0.00,0.00,5000.00,0.00,'2022-04-24 17:38:13','',''),(945,'21','221','4',2,'Received from bridging 100',0.00,0.00,5000.00,0.00,0.00,'2022-04-24 17:38:13','',''),(946,'21','221','1',1,'Sale Id shift 35',0.00,0.00,0.00,4290.19,0.00,'2022-04-26 09:54:26','',''),(947,'21','221','2',1,'Sale Id shift 35',0.00,0.00,0.00,5697.39,0.00,'2022-04-26 09:54:26','',''),(948,'21','221','2',1,'Sale Id shift 35',0.00,0.00,0.00,2776.14,0.00,'2022-04-26 09:54:26','',''),(949,'21','221','3',1,'Sale Id shift 35',0.00,0.00,0.00,4055.70,0.00,'2022-04-26 09:54:26','',''),(950,'21','221','3',1,'Sale Id shift 35',0.00,0.00,0.00,3702.31,0.00,'2022-04-26 09:54:26','',''),(951,'21','221','3',1,'Sale Id shift 35',0.00,0.00,0.00,3459.84,0.00,'2022-04-26 09:54:26','',''),(952,'21','221','3',1,'Sale Id shift 35',0.00,0.00,0.00,3957.64,0.00,'2022-04-26 09:54:26','',''),(953,'21','221','3',1,'Sale Id shift 35',0.00,0.00,0.00,2536.78,0.00,'2022-04-26 09:54:26','',''),(954,'21','221','3',1,'Sale Id shift 35',0.00,0.00,0.00,3632.99,0.00,'2022-04-26 09:54:26','',''),(955,'21','221','3',1,'Sale Id shift 35',0.00,0.00,0.00,3158.08,0.00,'2022-04-26 09:54:26','',''),(956,'21','221','1',1,'Sale Id shift 35',0.00,0.00,0.00,4644.48,0.00,'2022-04-26 09:54:26','',''),(957,'21','221','4',2,'Sale Id shift 35',0.00,0.00,0.00,1928.69,0.00,'2022-04-26 09:54:26','',''),(958,'21','221','5',3,'Sale Id shift 35',0.00,0.00,0.00,1072.93,0.00,'2022-04-26 09:54:26','',''),(959,'21','221','3',1,'Sale Id shift 35',0.00,0.00,0.00,2512.35,0.00,'2022-04-26 09:54:26','',''),(960,'21','221','1',1,'Sale Id shift 35',0.00,0.00,0.00,3882.17,0.00,'2022-04-26 09:54:26','',''),(961,'21','221','1',1,'Sale Id shift 35',0.00,0.00,0.00,3849.89,0.00,'2022-04-26 09:54:26','',''),(962,'21','221','2',1,'Sale Id shift 35',0.00,0.00,0.00,5531.01,0.00,'2022-04-26 09:54:26','',''),(963,'21','221','2',1,'Sale Id shift 35',0.00,0.00,0.00,2584.68,0.00,'2022-04-26 09:54:26','',''),(964,'21','221','2',1,'Sale Id shift 35',0.00,0.00,0.00,2709.92,0.00,'2022-04-26 09:54:26','',''),(965,'21','221','2',1,'Sale Id shift 35',0.00,0.00,0.00,4261.31,0.00,'2022-04-26 09:54:26','',''),(966,'21','221',NULL,2,'Sale Id shift 35',1350083.00,0.00,0.00,0.00,0.00,'2022-04-26 09:54:26','',''),(967,'21','221',NULL,3,'Sale Id shift 35',590111.50,0.00,0.00,0.00,0.00,'2022-04-26 09:54:26','',''),(968,'21','221',NULL,1,'Sale Id shift 35',11095073.55,0.00,0.00,0.00,0.00,'2022-04-26 09:54:26','',''),(969,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-26 10:12:39','',''),(970,'21','221',NULL,1,'Reception corrector for bridging 103',0.00,0.00,0.00,30000.00,0.00,'2022-04-26 10:16:17','',''),(971,'21','221','3',1,'Received from bridging 103',0.00,0.00,30000.00,0.00,0.00,'2022-04-26 10:16:17','',''),(972,'21','221',NULL,1,'Reception corrector for bridging 102',0.00,0.00,0.00,20000.00,0.00,'2022-04-26 10:16:17','',''),(973,'21','221','2',1,'Received from bridging 102',0.00,0.00,20000.00,0.00,0.00,'2022-04-26 10:16:17','',''),(974,'21','221',NULL,1,'Reception corrector for bridging 101',0.00,0.00,0.00,10000.00,0.00,'2022-04-26 10:16:17','',''),(975,'21','221','1',1,'Received from bridging 101',0.00,0.00,10000.00,0.00,0.00,'2022-04-26 10:16:17','',''),(976,'21','221','1',1,'Sale Id shift 36',0.00,0.00,0.00,4818.44,0.00,'2022-04-26 11:45:39','',''),(977,'21','221','2',1,'Sale Id shift 36',0.00,0.00,0.00,5306.37,0.00,'2022-04-26 11:45:39','',''),(978,'21','221','2',1,'Sale Id shift 36',0.00,0.00,0.00,4071.88,0.00,'2022-04-26 11:45:39','',''),(979,'21','221','3',1,'Sale Id shift 36',0.00,0.00,0.00,3768.72,0.00,'2022-04-26 11:45:39','',''),(980,'21','221','3',1,'Sale Id shift 36',0.00,0.00,0.00,3540.68,0.00,'2022-04-26 11:45:39','',''),(981,'21','221','3',1,'Sale Id shift 36',0.00,0.00,0.00,3375.01,0.00,'2022-04-26 11:45:39','',''),(982,'21','221','3',1,'Sale Id shift 36',0.00,0.00,0.00,3319.56,0.00,'2022-04-26 11:45:39','',''),(983,'21','221','3',1,'Sale Id shift 36',0.00,0.00,0.00,3029.57,0.00,'2022-04-26 11:45:39','',''),(984,'21','221','3',1,'Sale Id shift 36',0.00,0.00,0.00,2788.34,0.00,'2022-04-26 11:45:39','',''),(985,'21','221','3',1,'Sale Id shift 36',0.00,0.00,0.00,3957.20,0.00,'2022-04-26 11:45:39','',''),(986,'21','221','1',1,'Sale Id shift 36',0.00,0.00,0.00,3575.02,0.00,'2022-04-26 11:45:39','',''),(987,'21','221','4',2,'Sale Id shift 36',0.00,0.00,0.00,4691.58,0.00,'2022-04-26 11:45:39','',''),(988,'21','221','4',2,'Sale Id shift 36',0.00,0.00,0.00,5169.82,0.00,'2022-04-26 11:45:39','',''),(989,'21','221','5',3,'Sale Id shift 36',0.00,0.00,0.00,840.86,0.00,'2022-04-26 11:45:39','',''),(990,'21','221','3',1,'Sale Id shift 36',0.00,0.00,0.00,2529.89,0.00,'2022-04-26 11:45:39','',''),(991,'21','221','1',1,'Sale Id shift 36',0.00,0.00,0.00,3022.70,0.00,'2022-04-26 11:45:39','',''),(992,'21','221','1',1,'Sale Id shift 36',0.00,0.00,0.00,3788.83,0.00,'2022-04-26 11:45:39','',''),(993,'21','221','2',1,'Sale Id shift 36',0.00,0.00,0.00,6942.36,0.00,'2022-04-26 11:45:39','',''),(994,'21','221','2',1,'Sale Id shift 36',0.00,0.00,0.00,3692.01,0.00,'2022-04-26 11:45:39','',''),(995,'21','221','2',1,'Sale Id shift 36',0.00,0.00,0.00,3225.39,0.00,'2022-04-26 11:45:39','',''),(996,'21','221','2',1,'Sale Id shift 36',0.00,0.00,0.00,3607.36,0.00,'2022-04-26 11:45:39','',''),(997,'21','221',NULL,1,'Sale Id shift 36',11279289.45,0.00,0.00,0.00,0.00,'2022-04-26 11:45:39','',''),(998,'21','221',NULL,2,'Sale Id shift 36',6902980.00,0.00,0.00,0.00,0.00,'2022-04-26 11:45:39','',''),(999,'21','221',NULL,3,'Sale Id shift 36',462473.00,0.00,0.00,0.00,0.00,'2022-04-26 11:45:39','',''),(1000,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-26 12:16:50','',''),(1001,'21','221',NULL,1,'Reception corrector for bridging 106',0.00,0.00,0.00,15000.00,0.00,'2022-04-26 12:19:18','',''),(1002,'21','221','3',1,'Received from bridging 106',0.00,0.00,15000.00,0.00,0.00,'2022-04-26 12:19:18','',''),(1003,'21','221',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,15000.00,0.00,'2022-04-26 12:19:18','',''),(1004,'21','221','2',1,'Received from bridging 105',0.00,0.00,15000.00,0.00,0.00,'2022-04-26 12:19:18','',''),(1005,'21','221',NULL,1,'Reception corrector for bridging 104',0.00,0.00,0.00,20000.00,0.00,'2022-04-26 12:19:18','',''),(1006,'21','221','1',1,'Received from bridging 104',0.00,0.00,20000.00,0.00,0.00,'2022-04-26 12:19:18','',''),(1007,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-26 12:21:25','',''),(1008,'21','221',NULL,1,'Reception corrector for bridging 109',0.00,0.00,0.00,25000.00,0.00,'2022-04-26 12:25:39','',''),(1009,'21','221','3',1,'Received from bridging 109',0.00,0.00,25000.00,0.00,0.00,'2022-04-26 12:25:39','',''),(1010,'21','221',NULL,1,'Reception corrector for bridging 108',0.00,0.00,0.00,20000.00,0.00,'2022-04-26 12:25:39','',''),(1011,'21','221','2',1,'Received from bridging 108',0.00,0.00,20000.00,0.00,0.00,'2022-04-26 12:25:39','',''),(1012,'21','221',NULL,1,'Reception corrector for bridging 107',0.00,0.00,0.00,15000.00,0.00,'2022-04-26 12:25:39','',''),(1013,'21','221','1',1,'Received from bridging 107',0.00,0.00,15000.00,0.00,0.00,'2022-04-26 12:25:39','',''),(1014,'21','221','1',1,'Sale Id shift 37',0.00,0.00,0.00,3687.44,0.00,'2022-04-26 15:43:11','',''),(1015,'21','221','2',1,'Sale Id shift 37',0.00,0.00,0.00,5376.96,0.00,'2022-04-26 15:43:11','',''),(1016,'21','221','2',1,'Sale Id shift 37',0.00,0.00,0.00,3375.10,0.00,'2022-04-26 15:43:11','',''),(1017,'21','221','3',1,'Sale Id shift 37',0.00,0.00,0.00,5035.61,0.00,'2022-04-26 15:43:11','',''),(1018,'21','221','3',1,'Sale Id shift 37',0.00,0.00,0.00,3251.43,0.00,'2022-04-26 15:43:11','',''),(1019,'21','221','3',1,'Sale Id shift 37',0.00,0.00,0.00,3747.85,0.00,'2022-04-26 15:43:11','',''),(1020,'21','221','3',1,'Sale Id shift 37',0.00,0.00,0.00,2607.25,0.00,'2022-04-26 15:43:11','',''),(1021,'21','221','3',1,'Sale Id shift 37',0.00,0.00,0.00,4340.36,0.00,'2022-04-26 15:43:11','',''),(1022,'21','221','3',1,'Sale Id shift 37',0.00,0.00,0.00,2858.67,0.00,'2022-04-26 15:43:11','',''),(1023,'21','221','3',1,'Sale Id shift 37',0.00,0.00,0.00,1975.81,0.00,'2022-04-26 15:43:11','',''),(1024,'21','221','1',1,'Sale Id shift 37',0.00,0.00,0.00,4338.83,0.00,'2022-04-26 15:43:11','',''),(1025,'21','221','4',2,'Sale Id shift 37',0.00,0.00,0.00,5538.26,0.00,'2022-04-26 15:43:11','',''),(1026,'21','221','4',2,'Sale Id shift 37',0.00,0.00,0.00,4019.06,0.00,'2022-04-26 15:43:11','',''),(1027,'21','221','5',3,'Sale Id shift 37',0.00,0.00,0.00,921.77,0.00,'2022-04-26 15:43:11','',''),(1028,'21','221','3',1,'Sale Id shift 37',0.00,0.00,0.00,2295.59,0.00,'2022-04-26 15:43:11','',''),(1029,'21','221','1',1,'Sale Id shift 37',0.00,0.00,0.00,3341.35,0.00,'2022-04-26 15:43:11','',''),(1030,'21','221','1',1,'Sale Id shift 37',0.00,0.00,0.00,4548.79,0.00,'2022-04-26 15:43:11','',''),(1031,'21','221','2',1,'Sale Id shift 37',0.00,0.00,0.00,6107.52,0.00,'2022-04-26 15:43:11','',''),(1032,'21','221','2',1,'Sale Id shift 37',0.00,0.00,0.00,3582.66,0.00,'2022-04-26 15:43:11','',''),(1033,'21','221','2',1,'Sale Id shift 37',0.00,0.00,0.00,2167.76,0.00,'2022-04-26 15:43:11','',''),(1034,'21','221','2',1,'Sale Id shift 37',0.00,0.00,0.00,3769.91,0.00,'2022-04-26 15:43:11','',''),(1035,'21','221',NULL,1,'Sale Id shift 37',10957466.85,0.00,0.00,0.00,0.00,'2022-04-26 15:43:11','',''),(1036,'21','221',NULL,2,'Sale Id shift 37',6690124.00,0.00,0.00,0.00,0.00,'2022-04-26 15:43:11','',''),(1037,'21','221',NULL,3,'Sale Id shift 37',506973.50,0.00,0.00,0.00,0.00,'2022-04-26 15:43:11','',''),(1038,'21','221','1',1,'Sale Id shift 38',0.00,0.00,0.00,3278.27,0.00,'2022-04-26 20:36:33','',''),(1039,'21','221','2',1,'Sale Id shift 38',0.00,0.00,0.00,5694.00,0.00,'2022-04-26 20:36:33','',''),(1040,'21','221','2',1,'Sale Id shift 38',0.00,0.00,0.00,2669.06,0.00,'2022-04-26 20:36:33','',''),(1041,'21','221','3',1,'Sale Id shift 38',0.00,0.00,0.00,6071.94,0.00,'2022-04-26 20:36:33','',''),(1042,'21','221','3',1,'Sale Id shift 38',0.00,0.00,0.00,3916.30,0.00,'2022-04-26 20:36:33','',''),(1043,'21','221','3',1,'Sale Id shift 38',0.00,0.00,0.00,4315.21,0.00,'2022-04-26 20:36:33','',''),(1044,'21','221','3',1,'Sale Id shift 38',0.00,0.00,0.00,2805.69,0.00,'2022-04-26 20:36:33','',''),(1045,'21','221','3',1,'Sale Id shift 38',0.00,0.00,0.00,4656.82,0.00,'2022-04-26 20:36:33','',''),(1046,'21','221','3',1,'Sale Id shift 38',0.00,0.00,0.00,3189.91,0.00,'2022-04-26 20:36:33','',''),(1047,'21','221','1',1,'Sale Id shift 38',0.00,0.00,0.00,4688.36,0.00,'2022-04-26 20:36:33','',''),(1048,'21','221','4',2,'Sale Id shift 38',0.00,0.00,0.00,3589.07,0.00,'2022-04-26 20:36:33','',''),(1049,'21','221','4',2,'Sale Id shift 38',0.00,0.00,0.00,2909.94,0.00,'2022-04-26 20:36:33','',''),(1050,'21','221','5',3,'Sale Id shift 38',0.00,0.00,0.00,702.57,0.00,'2022-04-26 20:36:33','',''),(1051,'21','221','3',1,'Sale Id shift 38',0.00,0.00,0.00,4558.64,0.00,'2022-04-26 20:36:33','',''),(1052,'21','221','1',1,'Sale Id shift 38',0.00,0.00,0.00,4187.28,0.00,'2022-04-26 20:36:33','',''),(1053,'21','221','1',1,'Sale Id shift 38',0.00,0.00,0.00,2963.12,0.00,'2022-04-26 20:36:33','',''),(1054,'21','221','2',1,'Sale Id shift 38',0.00,0.00,0.00,5378.94,0.00,'2022-04-26 20:36:33','',''),(1055,'21','221','2',1,'Sale Id shift 38',0.00,0.00,0.00,3541.03,0.00,'2022-04-26 20:36:33','',''),(1056,'21','221','2',1,'Sale Id shift 38',0.00,0.00,0.00,3583.81,0.00,'2022-04-26 20:36:33','',''),(1057,'21','221','2',1,'Sale Id shift 38',0.00,0.00,0.00,4917.78,0.00,'2022-04-26 20:36:33','',''),(1058,'21','221',NULL,1,'Sale Id shift 38',11618666.40,0.00,0.00,0.00,0.00,'2022-04-26 20:36:33','',''),(1059,'21','221',NULL,2,'Sale Id shift 38',4549307.00,0.00,0.00,0.00,0.00,'2022-04-26 20:36:33','',''),(1060,'21','221',NULL,3,'Sale Id shift 38',386413.50,0.00,0.00,0.00,0.00,'2022-04-26 20:36:33','',''),(1061,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21140000.00,30200.00,0.00,0.00,'2022-04-27 07:56:40','',''),(1062,'21','221',NULL,2,'Reception corrector for bridging 110',0.00,0.00,0.00,30200.00,0.00,'2022-04-27 07:58:23','',''),(1063,'21','221','4',2,'Received from bridging 110',0.00,0.00,30200.00,0.00,0.00,'2022-04-27 07:58:23','',''),(1064,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-27 07:59:34','',''),(1065,'21','221',NULL,1,'Reception corrector for bridging 111',0.00,0.00,0.00,60000.00,0.00,'2022-04-27 08:01:50','',''),(1066,'21','221','2',1,'Received from bridging 111',0.00,0.00,60000.00,0.00,0.00,'2022-04-27 08:01:50','',''),(1067,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-27 08:05:36','',''),(1068,'21','221',NULL,1,'Reception corrector for bridging 113',0.00,0.00,0.00,15000.00,0.00,'2022-04-27 08:08:04','',''),(1069,'21','221','2',1,'Received from bridging 113',0.00,0.00,15000.00,0.00,0.00,'2022-04-27 08:08:04','',''),(1070,'21','221',NULL,1,'Reception corrector for bridging 114',0.00,0.00,0.00,35000.00,0.00,'2022-04-27 08:41:45','',''),(1071,'21','221','3',1,'Received from bridging 114',0.00,0.00,35000.00,0.00,0.00,'2022-04-27 08:41:45','',''),(1072,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-27 08:45:51','',''),(1073,'21','221',NULL,1,'Reception corrector for bridging 116',0.00,0.00,0.00,30000.00,0.00,'2022-04-27 08:48:29','',''),(1074,'21','221','3',1,'Received from bridging 116',0.00,0.00,30000.00,0.00,0.00,'2022-04-27 08:48:29','',''),(1075,'21','221',NULL,1,'Reception corrector for bridging 115',0.00,0.00,0.00,30000.00,0.00,'2022-04-27 08:48:29','',''),(1076,'21','221','1',1,'Received from bridging 115',0.00,0.00,30000.00,0.00,0.00,'2022-04-27 08:48:29','',''),(1077,'21','221','1',1,'Sale Id shift 39',0.00,0.00,0.00,1331.92,0.00,'2022-04-27 11:06:49','',''),(1078,'21','221','2',1,'Sale Id shift 39',0.00,0.00,0.00,5443.36,0.00,'2022-04-27 11:06:49','',''),(1079,'21','221','2',1,'Sale Id shift 39',0.00,0.00,0.00,3838.39,0.00,'2022-04-27 11:06:49','',''),(1080,'21','221','3',1,'Sale Id shift 39',0.00,0.00,0.00,4079.71,0.00,'2022-04-27 11:06:49','',''),(1081,'21','221','3',1,'Sale Id shift 39',0.00,0.00,0.00,1751.24,0.00,'2022-04-27 11:06:49','',''),(1082,'21','221','3',1,'Sale Id shift 39',0.00,0.00,0.00,4495.88,0.00,'2022-04-27 11:06:49','',''),(1083,'21','221','3',1,'Sale Id shift 39',0.00,0.00,0.00,3133.34,0.00,'2022-04-27 11:06:49','',''),(1084,'21','221','3',1,'Sale Id shift 39',0.00,0.00,0.00,2671.13,0.00,'2022-04-27 11:06:49','',''),(1085,'21','221','3',1,'Sale Id shift 39',0.00,0.00,0.00,4067.34,0.00,'2022-04-27 11:06:49','',''),(1086,'21','221','3',1,'Sale Id shift 39',0.00,0.00,0.00,2906.83,0.00,'2022-04-27 11:06:49','',''),(1087,'21','221','1',1,'Sale Id shift 39',0.00,0.00,0.00,1740.31,0.00,'2022-04-27 11:06:49','',''),(1088,'21','221','4',2,'Sale Id shift 39',0.00,0.00,0.00,3963.23,0.00,'2022-04-27 11:06:49','',''),(1089,'21','221','4',2,'Sale Id shift 39',0.00,0.00,0.00,2893.75,0.00,'2022-04-27 11:06:49','',''),(1090,'21','221','5',3,'Sale Id shift 39',0.00,0.00,0.00,939.50,0.00,'2022-04-27 11:06:49','',''),(1091,'21','221','3',1,'Sale Id shift 39',0.00,0.00,0.00,2313.69,0.00,'2022-04-27 11:06:49','',''),(1092,'21','221','1',1,'Sale Id shift 39',0.00,0.00,0.00,1988.72,0.00,'2022-04-27 11:06:49','',''),(1093,'21','221','1',1,'Sale Id shift 39',0.00,0.00,0.00,3898.08,0.00,'2022-04-27 11:06:49','',''),(1094,'21','221','2',1,'Sale Id shift 39',0.00,0.00,0.00,5377.65,0.00,'2022-04-27 11:06:49','',''),(1095,'21','221','2',1,'Sale Id shift 39',0.00,0.00,0.00,3079.21,0.00,'2022-04-27 11:06:49','',''),(1096,'21','221','2',1,'Sale Id shift 39',0.00,0.00,0.00,2600.59,0.00,'2022-04-27 11:06:49','',''),(1097,'21','221','2',1,'Sale Id shift 39',0.00,0.00,0.00,4639.66,0.00,'2022-04-27 11:06:49','',''),(1098,'21','221',NULL,1,'Sale Id shift 39',9793913.25,0.00,0.00,0.00,0.00,'2022-04-27 11:06:49','',''),(1099,'21','221',NULL,2,'Sale Id shift 39',4799886.00,0.00,0.00,0.00,0.00,'2022-04-27 11:06:49','',''),(1100,'21','221',NULL,3,'Sale Id shift 39',516725.00,0.00,0.00,0.00,0.00,'2022-04-27 11:06:49','',''),(1101,'21','221','1',1,'Sale Id shift 40',0.00,0.00,0.00,2464.55,0.00,'2022-04-27 12:54:38','',''),(1102,'21','221','2',1,'Sale Id shift 40',0.00,0.00,0.00,5373.01,0.00,'2022-04-27 12:54:38','',''),(1103,'21','221','2',1,'Sale Id shift 40',0.00,0.00,0.00,3180.15,0.00,'2022-04-27 12:54:38','',''),(1104,'21','221','3',1,'Sale Id shift 40',0.00,0.00,0.00,3862.74,0.00,'2022-04-27 12:54:38','',''),(1105,'21','221','3',1,'Sale Id shift 40',0.00,0.00,0.00,2707.14,0.00,'2022-04-27 12:54:38','',''),(1106,'21','221','3',1,'Sale Id shift 40',0.00,0.00,0.00,2455.86,0.00,'2022-04-27 12:54:38','',''),(1107,'21','221','3',1,'Sale Id shift 40',0.00,0.00,0.00,2653.89,0.00,'2022-04-27 12:54:38','',''),(1108,'21','221','3',1,'Sale Id shift 40',0.00,0.00,0.00,2379.33,0.00,'2022-04-27 12:54:38','',''),(1109,'21','221','3',1,'Sale Id shift 40',0.00,0.00,0.00,1901.33,0.00,'2022-04-27 12:54:38','',''),(1110,'21','221','3',1,'Sale Id shift 40',0.00,0.00,0.00,3278.16,0.00,'2022-04-27 12:54:38','',''),(1111,'21','221','1',1,'Sale Id shift 40',0.00,0.00,0.00,2542.25,0.00,'2022-04-27 12:54:38','',''),(1112,'21','221','4',2,'Sale Id shift 40',0.00,0.00,0.00,2202.39,0.00,'2022-04-27 12:54:38','',''),(1113,'21','221','4',2,'Sale Id shift 40',0.00,0.00,0.00,9473.14,0.00,'2022-04-27 12:54:38','',''),(1114,'21','221','5',3,'Sale Id shift 40',0.00,0.00,0.00,652.28,0.00,'2022-04-27 12:54:38','',''),(1115,'21','221','3',1,'Sale Id shift 40',0.00,0.00,0.00,3202.92,0.00,'2022-04-27 12:54:38','',''),(1116,'21','221','1',1,'Sale Id shift 40',0.00,0.00,0.00,3111.65,0.00,'2022-04-27 12:54:38','',''),(1117,'21','221','1',1,'Sale Id shift 40',0.00,0.00,0.00,2672.30,0.00,'2022-04-27 12:54:38','',''),(1118,'21','221','2',1,'Sale Id shift 40',0.00,0.00,0.00,4766.85,0.00,'2022-04-27 12:54:38','',''),(1119,'21','221','2',1,'Sale Id shift 40',0.00,0.00,0.00,3650.78,0.00,'2022-04-27 12:54:38','',''),(1120,'21','221','2',1,'Sale Id shift 40',0.00,0.00,0.00,2294.08,0.00,'2022-04-27 12:54:38','',''),(1121,'21','221','2',1,'Sale Id shift 40',0.00,0.00,0.00,3355.72,0.00,'2022-04-27 12:54:38','',''),(1122,'21','221',NULL,1,'Sale Id shift 40',9215697.15,0.00,0.00,0.00,0.00,'2022-04-27 12:54:38','',''),(1123,'21','221',NULL,2,'Sale Id shift 40',8172871.00,0.00,0.00,0.00,0.00,'2022-04-27 12:54:38','',''),(1124,'21','221',NULL,3,'Sale Id shift 40',358754.00,0.00,0.00,0.00,0.00,'2022-04-27 12:54:38','',''),(1125,'21','221','1',1,'Sale Id shift 41',0.00,0.00,0.00,4366.71,0.00,'2022-04-27 14:54:21','',''),(1126,'21','221','2',1,'Sale Id shift 41',0.00,0.00,0.00,4727.47,0.00,'2022-04-27 14:54:21','',''),(1127,'21','221','2',1,'Sale Id shift 41',0.00,0.00,0.00,3266.49,0.00,'2022-04-27 14:54:21','',''),(1128,'21','221','3',1,'Sale Id shift 41',0.00,0.00,0.00,3423.69,0.00,'2022-04-27 14:54:21','',''),(1129,'21','221','3',1,'Sale Id shift 41',0.00,0.00,0.00,2366.71,0.00,'2022-04-27 14:54:21','',''),(1130,'21','221','3',1,'Sale Id shift 41',0.00,0.00,0.00,3787.28,0.00,'2022-04-27 14:54:21','',''),(1131,'21','221','3',1,'Sale Id shift 41',0.00,0.00,0.00,2728.90,0.00,'2022-04-27 14:54:21','',''),(1132,'21','221','3',1,'Sale Id shift 41',0.00,0.00,0.00,3140.66,0.00,'2022-04-27 14:54:21','',''),(1133,'21','221','3',1,'Sale Id shift 41',0.00,0.00,0.00,1603.91,0.00,'2022-04-27 14:54:21','',''),(1134,'21','221','3',1,'Sale Id shift 41',0.00,0.00,0.00,2205.61,0.00,'2022-04-27 14:54:21','',''),(1135,'21','221','1',1,'Sale Id shift 41',0.00,0.00,0.00,2929.84,0.00,'2022-04-27 14:54:21','',''),(1136,'21','221','4',2,'Sale Id shift 41',0.00,0.00,0.00,6605.07,0.00,'2022-04-27 14:54:21','',''),(1137,'21','221','4',2,'Sale Id shift 41',0.00,0.00,0.00,4171.33,0.00,'2022-04-27 14:54:21','',''),(1138,'21','221','5',3,'Sale Id shift 41',0.00,0.00,0.00,823.42,0.00,'2022-04-27 14:54:21','',''),(1139,'21','221','3',1,'Sale Id shift 41',0.00,0.00,0.00,3176.59,0.00,'2022-04-27 14:54:21','',''),(1140,'21','221','1',1,'Sale Id shift 41',0.00,0.00,0.00,3679.15,0.00,'2022-04-27 14:54:21','',''),(1141,'21','221','1',1,'Sale Id shift 41',0.00,0.00,0.00,4096.61,0.00,'2022-04-27 14:54:21','',''),(1142,'21','221','2',1,'Sale Id shift 41',0.00,0.00,0.00,5039.10,0.00,'2022-04-27 14:54:21','',''),(1143,'21','221','2',1,'Sale Id shift 41',0.00,0.00,0.00,2837.24,0.00,'2022-04-27 14:54:21','',''),(1144,'21','221','2',1,'Sale Id shift 41',0.00,0.00,0.00,2998.34,0.00,'2022-04-27 14:54:21','',''),(1145,'21','221','2',1,'Sale Id shift 41',0.00,0.00,0.00,2881.96,0.00,'2022-04-27 14:54:21','',''),(1146,'21','221',NULL,1,'Sale Id shift 41',9777282.90,0.00,0.00,0.00,0.00,'2022-04-27 14:54:21','',''),(1147,'21','221',NULL,2,'Sale Id shift 41',7543480.00,0.00,0.00,0.00,0.00,'2022-04-27 14:54:21','',''),(1148,'21','221',NULL,3,'Sale Id shift 41',452881.00,0.00,0.00,0.00,0.00,'2022-04-27 14:54:21','',''),(1149,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-27 16:24:01','',''),(1150,'21','221',NULL,1,'Reception corrector for bridging 118',0.00,0.00,0.00,25000.00,0.00,'2022-04-27 16:32:29','',''),(1151,'21','221','2',1,'Received from bridging 118',0.00,0.00,25000.00,0.00,0.00,'2022-04-27 16:32:29','',''),(1152,'21','221',NULL,1,'Reception corrector for bridging 117',0.00,0.00,0.00,35000.00,0.00,'2022-04-27 16:32:29','',''),(1153,'21','221','1',1,'Received from bridging 117',0.00,0.00,35000.00,0.00,0.00,'2022-04-27 16:32:29','',''),(1154,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-27 16:33:39','',''),(1155,'21','221',NULL,1,'Reception corrector for bridging 119',0.00,0.00,0.00,45000.00,0.00,'2022-04-27 16:36:22','',''),(1156,'21','221','3',1,'Received from bridging 119',0.00,0.00,45000.00,0.00,0.00,'2022-04-27 16:36:22','',''),(1157,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-27 16:40:48','',''),(1158,'21','221',NULL,1,'Reception corrector for bridging 121',0.00,0.00,0.00,15000.00,0.00,'2022-04-27 16:45:26','',''),(1159,'21','221','3',1,'Received from bridging 121',0.00,0.00,15000.00,0.00,0.00,'2022-04-27 16:45:26','',''),(1160,'21','221',NULL,1,'Reception corrector for bridging 120',0.00,0.00,0.00,30000.00,0.00,'2022-04-27 16:45:26','',''),(1161,'21','221','2',1,'Received from bridging 120',0.00,0.00,30000.00,0.00,0.00,'2022-04-27 16:45:26','',''),(1162,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21000000.00,30000.00,0.00,0.00,'2022-04-27 16:48:56','',''),(1163,'21','221',NULL,2,'Reception corrector for bridging 122',0.00,0.00,0.00,30000.00,0.00,'2022-04-27 16:53:08','',''),(1164,'21','221','4',2,'Received from bridging 122',0.00,0.00,30000.00,0.00,0.00,'2022-04-27 16:53:08','',''),(1165,'21','221','1',1,'Sale Id shift 42',0.00,0.00,0.00,4556.00,0.00,'2022-04-28 14:05:36','',''),(1166,'21','221','2',1,'Sale Id shift 42',0.00,0.00,0.00,5236.73,0.00,'2022-04-28 14:05:36','',''),(1167,'21','221','2',1,'Sale Id shift 42',0.00,0.00,0.00,3831.52,0.00,'2022-04-28 14:05:36','',''),(1168,'21','221','3',1,'Sale Id shift 42',0.00,0.00,0.00,2729.05,0.00,'2022-04-28 14:05:36','',''),(1169,'21','221','3',1,'Sale Id shift 42',0.00,0.00,0.00,3356.75,0.00,'2022-04-28 14:05:36','',''),(1170,'21','221','3',1,'Sale Id shift 42',0.00,0.00,0.00,2902.59,0.00,'2022-04-28 14:05:36','',''),(1171,'21','221','3',1,'Sale Id shift 42',0.00,0.00,0.00,2353.55,0.00,'2022-04-28 14:05:36','',''),(1172,'21','221','3',1,'Sale Id shift 42',0.00,0.00,0.00,3186.58,0.00,'2022-04-28 14:05:36','',''),(1173,'21','221','3',1,'Sale Id shift 42',0.00,0.00,0.00,3374.09,0.00,'2022-04-28 14:05:36','',''),(1174,'21','221','3',1,'Sale Id shift 42',0.00,0.00,0.00,3581.86,0.00,'2022-04-28 14:05:36','',''),(1175,'21','221','1',1,'Sale Id shift 42',0.00,0.00,0.00,3645.86,0.00,'2022-04-28 14:05:36','',''),(1176,'21','221','4',2,'Sale Id shift 42',0.00,0.00,0.00,3601.75,0.00,'2022-04-28 14:05:36','',''),(1177,'21','221','4',2,'Sale Id shift 42',0.00,0.00,0.00,3229.92,0.00,'2022-04-28 14:05:36','',''),(1178,'21','221','5',3,'Sale Id shift 42',0.00,0.00,0.00,946.70,0.00,'2022-04-28 14:05:36','',''),(1179,'21','221','3',1,'Sale Id shift 42',0.00,0.00,0.00,2673.12,0.00,'2022-04-28 14:05:36','',''),(1180,'21','221','1',1,'Sale Id shift 42',0.00,0.00,0.00,2790.57,0.00,'2022-04-28 14:05:36','',''),(1181,'21','221','1',1,'Sale Id shift 42',0.00,0.00,0.00,3115.41,0.00,'2022-04-28 14:05:36','',''),(1182,'21','221','2',1,'Sale Id shift 42',0.00,0.00,0.00,5197.19,0.00,'2022-04-28 14:05:36','',''),(1183,'21','221','2',1,'Sale Id shift 42',0.00,0.00,0.00,2921.71,0.00,'2022-04-28 14:05:36','',''),(1184,'21','221','2',1,'Sale Id shift 42',0.00,0.00,0.00,2751.34,0.00,'2022-04-28 14:05:36','',''),(1185,'21','221','2',1,'Sale Id shift 42',0.00,0.00,0.00,2633.91,0.00,'2022-04-28 14:05:36','',''),(1186,'21','221',NULL,1,'Sale Id shift 42',10038241.95,0.00,0.00,0.00,0.00,'2022-04-28 14:05:36','',''),(1187,'21','221',NULL,2,'Sale Id shift 42',4782169.00,0.00,0.00,0.00,0.00,'2022-04-28 14:05:36','',''),(1188,'21','221',NULL,3,'Sale Id shift 42',520685.00,0.00,0.00,0.00,0.00,'2022-04-28 14:05:36','',''),(1189,'21','221','1',1,'Sale Id shift 43',0.00,0.00,0.00,5855.61,0.00,'2022-04-29 19:28:27','',''),(1190,'21','221','2',1,'Sale Id shift 43',0.00,0.00,0.00,7069.94,0.00,'2022-04-29 19:28:27','',''),(1191,'21','221','2',1,'Sale Id shift 43',0.00,0.00,0.00,4095.31,0.00,'2022-04-29 19:28:27','',''),(1192,'21','221','3',1,'Sale Id shift 43',0.00,0.00,0.00,3523.33,0.00,'2022-04-29 19:28:27','',''),(1193,'21','221','3',1,'Sale Id shift 43',0.00,0.00,0.00,3668.43,0.00,'2022-04-29 19:28:27','',''),(1194,'21','221','3',1,'Sale Id shift 43',0.00,0.00,0.00,3632.06,0.00,'2022-04-29 19:28:27','',''),(1195,'21','221','3',1,'Sale Id shift 43',0.00,0.00,0.00,3360.78,0.00,'2022-04-29 19:28:27','',''),(1196,'21','221','3',1,'Sale Id shift 43',0.00,0.00,0.00,3655.29,0.00,'2022-04-29 19:28:27','',''),(1197,'21','221','3',1,'Sale Id shift 43',0.00,0.00,0.00,4713.57,0.00,'2022-04-29 19:28:27','',''),(1198,'21','221','3',1,'Sale Id shift 43',0.00,0.00,0.00,4252.21,0.00,'2022-04-29 19:28:27','',''),(1199,'21','221','1',1,'Sale Id shift 43',0.00,0.00,0.00,5442.17,0.00,'2022-04-29 19:28:27','',''),(1200,'21','221','4',2,'Sale Id shift 43',0.00,0.00,0.00,4570.67,0.00,'2022-04-29 19:28:27','',''),(1201,'21','221','4',2,'Sale Id shift 43',0.00,0.00,0.00,5676.29,0.00,'2022-04-29 19:28:27','',''),(1202,'21','221','5',3,'Sale Id shift 43',0.00,0.00,0.00,1160.16,0.00,'2022-04-29 19:28:27','',''),(1203,'21','221','3',1,'Sale Id shift 43',0.00,0.00,0.00,2734.55,0.00,'2022-04-29 19:28:27','',''),(1204,'21','221','1',1,'Sale Id shift 43',0.00,0.00,0.00,5083.28,0.00,'2022-04-29 19:28:27','',''),(1205,'21','221','1',1,'Sale Id shift 43',0.00,0.00,0.00,5680.93,0.00,'2022-04-29 19:28:27','',''),(1206,'21','221','2',1,'Sale Id shift 43',0.00,0.00,0.00,6667.12,0.00,'2022-04-29 19:28:27','',''),(1207,'21','221','2',1,'Sale Id shift 43',0.00,0.00,0.00,3008.50,0.00,'2022-04-29 19:28:27','',''),(1208,'21','221','2',1,'Sale Id shift 43',0.00,0.00,0.00,4104.20,0.00,'2022-04-29 19:28:27','',''),(1209,'21','221','2',1,'Sale Id shift 43',0.00,0.00,0.00,5195.35,0.00,'2022-04-29 19:28:27','',''),(1210,'21','221',NULL,2,'Sale Id shift 43',7172872.00,0.00,0.00,0.00,0.00,'2022-04-29 19:28:27','',''),(1211,'21','221',NULL,3,'Sale Id shift 43',638088.00,0.00,0.00,0.00,0.00,'2022-04-29 19:28:27','',''),(1212,'21','221',NULL,1,'Sale Id shift 43',13487533.95,0.00,0.00,0.00,0.00,'2022-04-29 19:28:27','',''),(1213,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-01 08:05:49','',''),(1214,'21','221',NULL,1,'Reception corrector for bridging 124',0.00,0.00,0.00,15000.00,0.00,'2022-05-01 08:14:03','',''),(1215,'21','221','3',1,'Received from bridging 124',0.00,0.00,15000.00,0.00,0.00,'2022-05-01 08:14:03','',''),(1216,'21','221',NULL,1,'Reception corrector for bridging 123',0.00,0.00,0.00,35000.00,0.00,'2022-05-01 08:14:03','',''),(1217,'21','221','1',1,'Received from bridging 123',0.00,0.00,35000.00,0.00,0.00,'2022-05-01 08:14:03','',''),(1218,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-01 08:14:21','',''),(1219,'21','221',NULL,1,'Reception corrector for bridging 126',0.00,0.00,0.00,60000.00,0.00,'2022-05-01 10:02:23','',''),(1220,'21','221','2',1,'Received from bridging 126',0.00,0.00,60000.00,0.00,0.00,'2022-05-01 10:02:23','',''),(1221,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,15000.00,0.00,0.00,'2022-05-01 10:06:51','',''),(1222,'21','221',NULL,2,'Reception corrector for bridging 127',0.00,0.00,0.00,15000.00,0.00,'2022-05-01 10:08:15','',''),(1223,'21','221','4',2,'Received from bridging 127',0.00,0.00,15000.00,0.00,0.00,'2022-05-01 10:08:15','',''),(1224,'21','221','1',1,'Sale Id shift 44',0.00,0.00,0.00,2995.04,0.00,'2022-05-01 13:31:03','',''),(1225,'21','221','2',1,'Sale Id shift 44',0.00,0.00,0.00,5826.57,0.00,'2022-05-01 13:31:03','',''),(1226,'21','221','2',1,'Sale Id shift 44',0.00,0.00,0.00,2313.45,0.00,'2022-05-01 13:31:03','',''),(1227,'21','221','3',1,'Sale Id shift 44',0.00,0.00,0.00,2577.87,0.00,'2022-05-01 13:31:03','',''),(1228,'21','221','3',1,'Sale Id shift 44',0.00,0.00,0.00,3279.69,0.00,'2022-05-01 13:31:03','',''),(1229,'21','221','3',1,'Sale Id shift 44',0.00,0.00,0.00,2271.73,0.00,'2022-05-01 13:31:03','',''),(1230,'21','221','3',1,'Sale Id shift 44',0.00,0.00,0.00,2773.41,0.00,'2022-05-01 13:31:03','',''),(1231,'21','221','3',1,'Sale Id shift 44',0.00,0.00,0.00,2668.79,0.00,'2022-05-01 13:31:03','',''),(1232,'21','221','3',1,'Sale Id shift 44',0.00,0.00,0.00,2821.38,0.00,'2022-05-01 13:31:03','',''),(1233,'21','221','3',1,'Sale Id shift 44',0.00,0.00,0.00,2914.03,0.00,'2022-05-01 13:31:03','',''),(1234,'21','221','1',1,'Sale Id shift 44',0.00,0.00,0.00,1715.74,0.00,'2022-05-01 13:31:03','',''),(1235,'21','221','4',2,'Sale Id shift 44',0.00,0.00,0.00,1164.01,0.00,'2022-05-01 13:31:03','',''),(1236,'21','221','4',2,'Sale Id shift 44',0.00,0.00,0.00,5434.34,0.00,'2022-05-01 13:31:03','',''),(1237,'21','221','5',3,'Sale Id shift 44',0.00,0.00,0.00,1115.08,0.00,'2022-05-01 13:31:03','',''),(1238,'21','221','3',1,'Sale Id shift 44',0.00,0.00,0.00,3367.17,0.00,'2022-05-01 13:31:03','',''),(1239,'21','221','1',1,'Sale Id shift 44',0.00,0.00,0.00,5255.00,0.00,'2022-05-01 13:31:03','',''),(1240,'21','221','1',1,'Sale Id shift 44',0.00,0.00,0.00,3657.05,0.00,'2022-05-01 13:31:03','',''),(1241,'21','221','2',1,'Sale Id shift 44',0.00,0.00,0.00,5037.39,0.00,'2022-05-01 13:31:03','',''),(1242,'21','221','2',1,'Sale Id shift 44',0.00,0.00,0.00,2757.97,0.00,'2022-05-01 13:31:03','',''),(1243,'21','221','2',1,'Sale Id shift 44',0.00,0.00,0.00,3762.90,0.00,'2022-05-01 13:31:03','',''),(1244,'21','221','2',1,'Sale Id shift 44',0.00,0.00,0.00,3598.89,0.00,'2022-05-01 13:31:03','',''),(1245,'21','221',NULL,1,'Sale Id shift 44',9833021.55,0.00,0.00,0.00,0.00,'2022-05-01 13:31:03','',''),(1246,'21','221',NULL,2,'Sale Id shift 44',4618845.00,0.00,0.00,0.00,0.00,'2022-05-01 13:31:03','',''),(1247,'21','221',NULL,3,'Sale Id shift 44',613294.00,0.00,0.00,0.00,0.00,'2022-05-01 13:31:03','',''),(1248,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-01 14:20:27','',''),(1249,'21','221',NULL,1,'Reception corrector for bridging 128',0.00,0.00,0.00,60000.00,0.00,'2022-05-01 14:25:25','',''),(1250,'21','221','3',1,'Received from bridging 128',0.00,0.00,60000.00,0.00,0.00,'2022-05-01 14:25:25','',''),(1251,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-01 14:40:15','',''),(1252,'21','221',NULL,1,'Reception corrector for bridging 131',0.00,0.00,0.00,20000.00,0.00,'2022-05-01 14:43:04','',''),(1253,'21','221','3',1,'Received from bridging 131',0.00,0.00,20000.00,0.00,0.00,'2022-05-01 14:43:04','',''),(1254,'21','221',NULL,1,'Reception corrector for bridging 130',0.00,0.00,0.00,25000.00,0.00,'2022-05-01 14:43:04','',''),(1255,'21','221','2',1,'Received from bridging 130',0.00,0.00,25000.00,0.00,0.00,'2022-05-01 14:43:04','',''),(1256,'21','221',NULL,1,'Reception corrector for bridging 129',0.00,0.00,0.00,15000.00,0.00,'2022-05-01 14:43:04','',''),(1257,'21','221','1',1,'Received from bridging 129',0.00,0.00,15000.00,0.00,0.00,'2022-05-01 14:43:04','',''),(1258,'21','221','1',1,'Sale Id shift 45',0.00,0.00,0.00,3884.64,0.00,'2022-05-01 17:27:52','',''),(1259,'21','221','2',1,'Sale Id shift 45',0.00,0.00,0.00,4819.00,0.00,'2022-05-01 17:27:52','',''),(1260,'21','221','2',1,'Sale Id shift 45',0.00,0.00,0.00,3872.44,0.00,'2022-05-01 17:27:52','',''),(1261,'21','221','3',1,'Sale Id shift 45',0.00,0.00,0.00,2949.60,0.00,'2022-05-01 17:27:52','',''),(1262,'21','221','3',1,'Sale Id shift 45',0.00,0.00,0.00,2016.18,0.00,'2022-05-01 17:27:52','',''),(1263,'21','221','3',1,'Sale Id shift 45',0.00,0.00,0.00,2872.29,0.00,'2022-05-01 17:27:52','',''),(1264,'21','221','3',1,'Sale Id shift 45',0.00,0.00,0.00,2372.13,0.00,'2022-05-01 17:27:52','',''),(1265,'21','221','3',1,'Sale Id shift 45',0.00,0.00,0.00,2957.87,0.00,'2022-05-01 17:27:52','',''),(1266,'21','221','3',1,'Sale Id shift 45',0.00,0.00,0.00,2512.22,0.00,'2022-05-01 17:27:52','',''),(1267,'21','221','3',1,'Sale Id shift 45',0.00,0.00,0.00,3303.72,0.00,'2022-05-01 17:27:52','',''),(1268,'21','221','1',1,'Sale Id shift 45',0.00,0.00,0.00,3485.69,0.00,'2022-05-01 17:27:52','',''),(1269,'21','221','4',2,'Sale Id shift 45',0.00,0.00,0.00,4133.56,0.00,'2022-05-01 17:27:52','',''),(1270,'21','221','4',2,'Sale Id shift 45',0.00,0.00,0.00,3044.56,0.00,'2022-05-01 17:27:52','',''),(1271,'21','221','5',3,'Sale Id shift 45',0.00,0.00,0.00,4950.11,0.00,'2022-05-01 17:27:52','',''),(1272,'21','221','3',1,'Sale Id shift 45',0.00,0.00,0.00,2569.18,0.00,'2022-05-01 17:27:52','',''),(1273,'21','221','1',1,'Sale Id shift 45',0.00,0.00,0.00,3641.32,0.00,'2022-05-01 17:27:52','',''),(1274,'21','221','1',1,'Sale Id shift 45',0.00,0.00,0.00,4118.85,0.00,'2022-05-01 17:27:52','',''),(1275,'21','221','2',1,'Sale Id shift 45',0.00,0.00,0.00,6026.68,0.00,'2022-05-01 17:27:52','',''),(1276,'21','221','2',1,'Sale Id shift 45',0.00,0.00,0.00,2640.02,0.00,'2022-05-01 17:27:52','',''),(1277,'21','221','2',1,'Sale Id shift 45',0.00,0.00,0.00,1969.90,0.00,'2022-05-01 17:27:52','',''),(1278,'21','221','2',1,'Sale Id shift 45',0.00,0.00,0.00,3849.48,0.00,'2022-05-01 17:27:52','',''),(1279,'21','221',NULL,1,'Sale Id shift 45',9877099.65,0.00,0.00,0.00,0.00,'2022-05-01 17:27:52','',''),(1280,'21','221',NULL,2,'Sale Id shift 45',5024684.00,0.00,0.00,0.00,0.00,'2022-05-01 17:27:52','',''),(1281,'21','221',NULL,3,'Sale Id shift 45',2722560.50,0.00,0.00,0.00,0.00,'2022-05-01 17:27:52','',''),(1282,'21','221','1',1,'Sale Id shift 46',0.00,0.00,0.00,1377.06,0.00,'2022-05-02 18:08:00','',''),(1283,'21','221','2',1,'Sale Id shift 46',0.00,0.00,0.00,5592.47,0.00,'2022-05-02 18:08:00','',''),(1284,'21','221','2',1,'Sale Id shift 46',0.00,0.00,0.00,2876.62,0.00,'2022-05-02 18:08:00','',''),(1285,'21','221','3',1,'Sale Id shift 46',0.00,0.00,0.00,2153.19,0.00,'2022-05-02 18:08:00','',''),(1286,'21','221','3',1,'Sale Id shift 46',0.00,0.00,0.00,1082.06,0.00,'2022-05-02 18:08:00','',''),(1287,'21','221','3',1,'Sale Id shift 46',0.00,0.00,0.00,2885.64,0.00,'2022-05-02 18:08:00','',''),(1288,'21','221','3',1,'Sale Id shift 46',0.00,0.00,0.00,1870.29,0.00,'2022-05-02 18:08:00','',''),(1289,'21','221','3',1,'Sale Id shift 46',0.00,0.00,0.00,2959.10,0.00,'2022-05-02 18:08:00','',''),(1290,'21','221','3',1,'Sale Id shift 46',0.00,0.00,0.00,3270.86,0.00,'2022-05-02 18:08:00','',''),(1291,'21','221','3',1,'Sale Id shift 46',0.00,0.00,0.00,3922.11,0.00,'2022-05-02 18:08:00','',''),(1292,'21','221','1',1,'Sale Id shift 46',0.00,0.00,0.00,1447.49,0.00,'2022-05-02 18:08:00','',''),(1293,'21','221','4',2,'Sale Id shift 46',0.00,0.00,0.00,5568.82,0.00,'2022-05-02 18:08:00','',''),(1294,'21','221','4',2,'Sale Id shift 46',0.00,0.00,0.00,2765.79,0.00,'2022-05-02 18:08:00','',''),(1295,'21','221','5',3,'Sale Id shift 46',0.00,0.00,0.00,5390.71,0.00,'2022-05-02 18:08:00','',''),(1296,'21','221','3',1,'Sale Id shift 46',0.00,0.00,0.00,2162.43,0.00,'2022-05-02 18:08:00','',''),(1297,'21','221','1',1,'Sale Id shift 46',0.00,0.00,0.00,3797.90,0.00,'2022-05-02 18:08:00','',''),(1298,'21','221','1',1,'Sale Id shift 46',0.00,0.00,0.00,5398.80,0.00,'2022-05-02 18:08:00','',''),(1299,'21','221','2',1,'Sale Id shift 46',0.00,0.00,0.00,4860.91,0.00,'2022-05-02 18:08:00','',''),(1300,'21','221','2',1,'Sale Id shift 46',0.00,0.00,0.00,1909.27,0.00,'2022-05-02 18:08:00','',''),(1301,'21','221','2',1,'Sale Id shift 46',0.00,0.00,0.00,4115.99,0.00,'2022-05-02 18:08:00','',''),(1302,'21','221','2',1,'Sale Id shift 46',0.00,0.00,0.00,4178.63,0.00,'2022-05-02 18:08:00','',''),(1303,'21','221',NULL,2,'Sale Id shift 46',5834227.00,0.00,0.00,0.00,0.00,'2022-05-02 18:08:00','',''),(1304,'21','221',NULL,3,'Sale Id shift 46',2964890.50,0.00,0.00,0.00,0.00,'2022-05-02 18:08:00','',''),(1305,'21','221',NULL,1,'Sale Id shift 46',9217035.30,0.00,0.00,0.00,0.00,'2022-05-02 18:08:00','',''),(1306,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-02 18:39:31','',''),(1307,'21','221',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,15000.00,0.00,'2022-05-02 18:42:51','',''),(1308,'21','221','3',1,'Received from bridging 134',0.00,0.00,15000.00,0.00,0.00,'2022-05-02 18:42:51','',''),(1309,'21','221',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,15000.00,0.00,'2022-05-02 18:42:51','',''),(1310,'21','221','2',1,'Received from bridging 133',0.00,0.00,15000.00,0.00,0.00,'2022-05-02 18:42:51','',''),(1311,'21','221',NULL,1,'Reception corrector for bridging 132',0.00,0.00,0.00,20000.00,0.00,'2022-05-02 18:42:51','',''),(1312,'21','221','1',1,'Received from bridging 132',0.00,0.00,20000.00,0.00,0.00,'2022-05-02 18:42:51','',''),(1313,'21','221','1',1,'Sale Id shift 47',0.00,0.00,0.00,4399.22,0.00,'2022-05-03 22:07:56','',''),(1314,'21','221','2',1,'Sale Id shift 47',0.00,0.00,0.00,5614.50,0.00,'2022-05-03 22:07:56','',''),(1315,'21','221','2',1,'Sale Id shift 47',0.00,0.00,0.00,4389.20,0.00,'2022-05-03 22:07:56','',''),(1316,'21','221','3',1,'Sale Id shift 47',0.00,0.00,0.00,471.51,0.00,'2022-05-03 22:07:56','',''),(1317,'21','221','3',1,'Sale Id shift 47',0.00,0.00,0.00,896.41,0.00,'2022-05-03 22:07:56','',''),(1318,'21','221','3',1,'Sale Id shift 47',0.00,0.00,0.00,601.79,0.00,'2022-05-03 22:07:56','',''),(1319,'21','221','3',1,'Sale Id shift 47',0.00,0.00,0.00,501.03,0.00,'2022-05-03 22:07:56','',''),(1320,'21','221','3',1,'Sale Id shift 47',0.00,0.00,0.00,205.67,0.00,'2022-05-03 22:07:56','',''),(1321,'21','221','1',1,'Sale Id shift 47',0.00,0.00,0.00,4735.72,0.00,'2022-05-03 22:07:56','',''),(1322,'21','221','4',2,'Sale Id shift 47',0.00,0.00,0.00,4163.54,0.00,'2022-05-03 22:07:56','',''),(1323,'21','221','4',2,'Sale Id shift 47',0.00,0.00,0.00,1887.68,0.00,'2022-05-03 22:07:56','',''),(1324,'21','221','5',3,'Sale Id shift 47',0.00,0.00,0.00,910.99,0.00,'2022-05-03 22:07:56','',''),(1325,'21','221','3',1,'Sale Id shift 47',0.00,0.00,0.00,618.55,0.00,'2022-05-03 22:07:56','',''),(1326,'21','221','1',1,'Sale Id shift 47',0.00,0.00,0.00,2734.62,0.00,'2022-05-03 22:07:56','',''),(1327,'21','221','1',1,'Sale Id shift 47',0.00,0.00,0.00,5808.46,0.00,'2022-05-03 22:07:56','',''),(1328,'21','221','2',1,'Sale Id shift 47',0.00,0.00,0.00,5672.53,0.00,'2022-05-03 22:07:56','',''),(1329,'21','221','2',1,'Sale Id shift 47',0.00,0.00,0.00,3787.17,0.00,'2022-05-03 22:07:56','',''),(1330,'21','221','2',1,'Sale Id shift 47',0.00,0.00,0.00,4003.19,0.00,'2022-05-03 22:07:56','',''),(1331,'21','221','2',1,'Sale Id shift 47',0.00,0.00,0.00,4130.08,0.00,'2022-05-03 22:07:56','',''),(1332,'21','221',NULL,1,'Sale Id shift 47',8013992.25,0.00,0.00,0.00,0.00,'2022-05-03 22:07:56','',''),(1333,'21','221',NULL,2,'Sale Id shift 47',4235854.00,0.00,0.00,0.00,0.00,'2022-05-03 22:07:56','',''),(1334,'21','221',NULL,3,'Sale Id shift 47',501044.50,0.00,0.00,0.00,0.00,'2022-05-03 22:07:56','',''),(1335,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-04 14:54:11','',''),(1336,'21','221',NULL,1,'Reception corrector for bridging 135',0.00,0.00,0.00,45000.00,0.00,'2022-05-04 14:57:24','',''),(1337,'21','221','2',1,'Received from bridging 135',0.00,0.00,45000.00,0.00,0.00,'2022-05-04 14:57:24','',''),(1338,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-04 14:57:42','',''),(1339,'21','221',NULL,1,'Reception corrector for bridging 137',0.00,0.00,0.00,25000.00,0.00,'2022-05-04 15:00:39','',''),(1340,'21','221','3',1,'Received from bridging 137',0.00,0.00,25000.00,0.00,0.00,'2022-05-04 15:00:39','',''),(1341,'21','221',NULL,1,'Reception corrector for bridging 136',0.00,0.00,0.00,20000.00,0.00,'2022-05-04 15:00:40','',''),(1342,'21','221','1',1,'Received from bridging 136',0.00,0.00,20000.00,0.00,0.00,'2022-05-04 15:00:40','',''),(1343,'21','221','1',1,'Sale Id shift 48',0.00,0.00,0.00,2823.04,0.00,'2022-05-04 16:26:15','',''),(1344,'21','221','2',1,'Sale Id shift 48',0.00,0.00,0.00,3408.46,0.00,'2022-05-04 16:26:15','',''),(1345,'21','221','2',1,'Sale Id shift 48',0.00,0.00,0.00,2305.85,0.00,'2022-05-04 16:26:15','',''),(1346,'21','221','3',1,'Sale Id shift 48',0.00,0.00,0.00,2229.30,0.00,'2022-05-04 16:26:15','',''),(1347,'21','221','3',1,'Sale Id shift 48',0.00,0.00,0.00,3197.87,0.00,'2022-05-04 16:26:15','',''),(1348,'21','221','3',1,'Sale Id shift 48',0.00,0.00,0.00,2006.01,0.00,'2022-05-04 16:26:15','',''),(1349,'21','221','3',1,'Sale Id shift 48',0.00,0.00,0.00,1945.12,0.00,'2022-05-04 16:26:15','',''),(1350,'21','221','3',1,'Sale Id shift 48',0.00,0.00,0.00,2229.54,0.00,'2022-05-04 16:26:15','',''),(1351,'21','221','3',1,'Sale Id shift 48',0.00,0.00,0.00,1875.07,0.00,'2022-05-04 16:26:15','',''),(1352,'21','221','1',1,'Sale Id shift 48',0.00,0.00,0.00,2712.22,0.00,'2022-05-04 16:26:15','',''),(1353,'21','221','4',2,'Sale Id shift 48',0.00,0.00,0.00,5648.95,0.00,'2022-05-04 16:26:15','',''),(1354,'21','221','4',2,'Sale Id shift 48',0.00,0.00,0.00,3209.39,0.00,'2022-05-04 16:26:15','',''),(1355,'21','221','5',3,'Sale Id shift 48',0.00,0.00,0.00,2150.61,0.00,'2022-05-04 16:26:15','',''),(1356,'21','221','3',1,'Sale Id shift 48',0.00,0.00,0.00,892.67,0.00,'2022-05-04 16:26:15','',''),(1357,'21','221','1',1,'Sale Id shift 48',0.00,0.00,0.00,3786.59,0.00,'2022-05-04 16:26:15','',''),(1358,'21','221','1',1,'Sale Id shift 48',0.00,0.00,0.00,1215.66,0.00,'2022-05-04 16:26:15','',''),(1359,'21','221','2',1,'Sale Id shift 48',0.00,0.00,0.00,3239.13,0.00,'2022-05-04 16:26:15','',''),(1360,'21','221','2',1,'Sale Id shift 48',0.00,0.00,0.00,1769.43,0.00,'2022-05-04 16:26:15','',''),(1361,'21','221','2',1,'Sale Id shift 48',0.00,0.00,0.00,1528.13,0.00,'2022-05-04 16:26:15','',''),(1362,'21','221','2',1,'Sale Id shift 48',0.00,0.00,0.00,2808.20,0.00,'2022-05-04 16:26:15','',''),(1363,'21','221',NULL,1,'Sale Id shift 48',6595427.85,0.00,0.00,0.00,0.00,'2022-05-04 16:26:15','',''),(1364,'21','221',NULL,2,'Sale Id shift 48',6200838.00,0.00,0.00,0.00,0.00,'2022-05-04 16:26:15','',''),(1365,'21','221',NULL,3,'Sale Id shift 48',1182835.50,0.00,0.00,0.00,0.00,'2022-05-04 16:26:15','',''),(1366,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,17500000.00,25000.00,0.00,0.00,'2022-05-04 18:17:08','',''),(1367,'21','221',NULL,2,'Reception corrector for bridging 138',0.00,0.00,0.00,25000.00,0.00,'2022-05-04 18:30:40','',''),(1368,'21','221','4',2,'Received from bridging 138',0.00,0.00,25000.00,0.00,0.00,'2022-05-04 18:30:40','',''),(1369,'21','221',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8497500.00,15450.00,0.00,0.00,'2022-05-08 18:02:49','',''),(1370,'21','221',NULL,3,'Reception corrector for bridging 139',0.00,0.00,0.00,15450.00,0.00,'2022-05-08 18:04:31','',''),(1371,'21','221','5',3,'Received from bridging 139',0.00,0.00,15450.00,0.00,0.00,'2022-05-08 18:04:31','',''),(1372,'21','221','1',1,'Sale Id shift 50',0.00,0.00,0.00,-40.00,0.00,'2022-05-08 20:42:05','',''),(1373,'21','221','2',1,'Sale Id shift 50',0.00,0.00,0.00,3249.85,0.00,'2022-05-08 20:42:05','',''),(1374,'21','221','2',1,'Sale Id shift 50',0.00,0.00,0.00,2563.27,0.00,'2022-05-08 20:42:05','',''),(1375,'21','221','3',1,'Sale Id shift 50',0.00,0.00,0.00,2576.45,0.00,'2022-05-08 20:42:05','',''),(1376,'21','221','3',1,'Sale Id shift 50',0.00,0.00,0.00,1338.77,0.00,'2022-05-08 20:42:05','',''),(1377,'21','221','3',1,'Sale Id shift 50',0.00,0.00,0.00,2058.95,0.00,'2022-05-08 20:42:05','',''),(1378,'21','221','3',1,'Sale Id shift 50',0.00,0.00,0.00,1890.91,0.00,'2022-05-08 20:42:05','',''),(1379,'21','221','3',1,'Sale Id shift 50',0.00,0.00,0.00,2108.98,0.00,'2022-05-08 20:42:05','',''),(1380,'21','221','3',1,'Sale Id shift 50',0.00,0.00,0.00,2016.95,0.00,'2022-05-08 20:42:05','',''),(1381,'21','221','3',1,'Sale Id shift 50',0.00,0.00,0.00,1594.24,0.00,'2022-05-08 20:42:05','',''),(1382,'21','221','4',2,'Sale Id shift 50',0.00,0.00,0.00,636.41,0.00,'2022-05-08 20:42:05','',''),(1383,'21','221','4',2,'Sale Id shift 50',0.00,0.00,0.00,6268.38,0.00,'2022-05-08 20:42:05','',''),(1384,'21','221','5',3,'Sale Id shift 50',0.00,0.00,0.00,16521.80,0.00,'2022-05-08 20:42:05','',''),(1385,'21','221','5',3,'Sale Id shift 50',0.00,0.00,0.00,1454.86,0.00,'2022-05-08 20:42:05','',''),(1386,'21','221','3',1,'Sale Id shift 50',0.00,0.00,0.00,2010.03,0.00,'2022-05-08 20:42:05','',''),(1387,'21','221','2',1,'Sale Id shift 50',0.00,0.00,0.00,3277.90,0.00,'2022-05-08 20:42:05','',''),(1388,'21','221','2',1,'Sale Id shift 50',0.00,0.00,0.00,1748.32,0.00,'2022-05-08 20:42:05','',''),(1389,'21','221','2',1,'Sale Id shift 50',0.00,0.00,0.00,1445.83,0.00,'2022-05-08 20:42:05','',''),(1390,'21','221','2',1,'Sale Id shift 50',0.00,0.00,0.00,1989.10,0.00,'2022-05-08 20:42:05','',''),(1391,'21','221',NULL,1,'Sale Id shift 50',4921875.75,0.00,0.00,0.00,0.00,'2022-05-08 20:42:05','',''),(1392,'21','221',NULL,2,'Sale Id shift 50',4833353.00,0.00,0.00,0.00,0.00,'2022-05-08 20:42:05','',''),(1393,'21','221',NULL,3,'Sale Id shift 50',9887163.00,0.00,0.00,0.00,0.00,'2022-05-08 20:42:05','',''),(1394,'21','221',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,18975000.00,34500.00,0.00,0.00,'2022-05-09 11:22:38','',''),(1395,'21','221',NULL,3,'Reception corrector for bridging 140',0.00,0.00,0.00,34500.00,0.00,'2022-05-09 11:26:17','',''),(1396,'21','221','5',3,'Received from bridging 140',0.00,0.00,34500.00,0.00,0.00,'2022-05-09 11:26:17','',''),(1397,'21','221','1',1,'Sale Id shift 51',0.00,0.00,0.00,3987.72,0.00,'2022-05-09 15:33:18','',''),(1398,'21','221','2',1,'Sale Id shift 51',0.00,0.00,0.00,6212.18,0.00,'2022-05-09 15:33:18','',''),(1399,'21','221','2',1,'Sale Id shift 51',0.00,0.00,0.00,2382.58,0.00,'2022-05-09 15:33:18','',''),(1400,'21','221','3',1,'Sale Id shift 51',0.00,0.00,0.00,3635.99,0.00,'2022-05-09 15:33:18','',''),(1401,'21','221','3',1,'Sale Id shift 51',0.00,0.00,0.00,1474.79,0.00,'2022-05-09 15:33:18','',''),(1402,'21','221','3',1,'Sale Id shift 51',0.00,0.00,0.00,2371.26,0.00,'2022-05-09 15:33:18','',''),(1403,'21','221','3',1,'Sale Id shift 51',0.00,0.00,0.00,2607.33,0.00,'2022-05-09 15:33:18','',''),(1404,'21','221','3',1,'Sale Id shift 51',0.00,0.00,0.00,2553.38,0.00,'2022-05-09 15:33:18','',''),(1405,'21','221','3',1,'Sale Id shift 51',0.00,0.00,0.00,642.24,0.00,'2022-05-09 15:33:18','',''),(1406,'21','221','3',1,'Sale Id shift 51',0.00,0.00,0.00,1341.35,0.00,'2022-05-09 15:33:18','',''),(1407,'21','221','1',1,'Sale Id shift 51',0.00,0.00,0.00,3122.33,0.00,'2022-05-09 15:33:18','',''),(1408,'21','221','4',2,'Sale Id shift 51',0.00,0.00,0.00,920.44,0.00,'2022-05-09 15:33:18','',''),(1409,'21','221','4',2,'Sale Id shift 51',0.00,0.00,0.00,3820.24,0.00,'2022-05-09 15:33:18','',''),(1410,'21','221','5',3,'Sale Id shift 51',0.00,0.00,0.00,1136.77,0.00,'2022-05-09 15:33:18','',''),(1411,'21','221','3',1,'Sale Id shift 51',0.00,0.00,0.00,2582.38,0.00,'2022-05-09 15:33:18','',''),(1412,'21','221','1',1,'Sale Id shift 51',0.00,0.00,0.00,3943.95,0.00,'2022-05-09 15:33:18','',''),(1413,'21','221','1',1,'Sale Id shift 51',0.00,0.00,0.00,4092.48,0.00,'2022-05-09 15:33:18','',''),(1414,'21','221','2',1,'Sale Id shift 51',0.00,0.00,0.00,5729.64,0.00,'2022-05-09 15:33:18','',''),(1415,'21','221','2',1,'Sale Id shift 51',0.00,0.00,0.00,1658.09,0.00,'2022-05-09 15:33:18','',''),(1416,'21','221','2',1,'Sale Id shift 51',0.00,0.00,0.00,4337.07,0.00,'2022-05-09 15:33:18','',''),(1417,'21','221','2',1,'Sale Id shift 51',0.00,0.00,0.00,5044.43,0.00,'2022-05-09 15:33:18','',''),(1418,'21','221',NULL,1,'Sale Id shift 51',9523666.35,0.00,0.00,0.00,0.00,'2022-05-09 15:33:18','',''),(1419,'21','221',NULL,2,'Sale Id shift 51',3318476.00,0.00,0.00,0.00,0.00,'2022-05-09 15:33:18','',''),(1420,'21','221',NULL,3,'Sale Id shift 51',625223.50,0.00,0.00,0.00,0.00,'2022-05-09 15:33:18','',''),(1421,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-09 16:21:00','',''),(1422,'21','221',NULL,1,'Reception corrector for bridging 141',0.00,0.00,0.00,50000.00,0.00,'2022-05-09 16:23:30','',''),(1423,'21','221','2',1,'Received from bridging 141',0.00,0.00,50000.00,0.00,0.00,'2022-05-09 16:23:30','',''),(1424,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-09 16:24:02','',''),(1425,'21','221',NULL,1,'Reception corrector for bridging 142',0.00,0.00,0.00,50000.00,0.00,'2022-05-09 16:26:00','',''),(1426,'21','221','3',1,'Received from bridging 142',0.00,0.00,50000.00,0.00,0.00,'2022-05-09 16:26:00','',''),(1427,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-09 16:26:44','',''),(1428,'21','221',NULL,1,'Reception corrector for bridging 144',0.00,0.00,0.00,15000.00,0.00,'2022-05-09 16:30:38','',''),(1429,'21','221','2',1,'Received from bridging 144',0.00,0.00,15000.00,0.00,0.00,'2022-05-09 16:30:38','',''),(1430,'21','221',NULL,1,'Reception corrector for bridging 143',0.00,0.00,0.00,30000.00,0.00,'2022-05-09 16:30:38','',''),(1431,'21','221','1',1,'Received from bridging 143',0.00,0.00,30000.00,0.00,0.00,'2022-05-09 16:30:38','',''),(1432,'21','221','1',1,'Sale Id shift 52',0.00,0.00,0.00,2265.19,0.00,'2022-05-09 19:07:54','',''),(1433,'21','221','2',1,'Sale Id shift 52',0.00,0.00,0.00,7070.96,0.00,'2022-05-09 19:07:54','',''),(1434,'21','221','2',1,'Sale Id shift 52',0.00,0.00,0.00,2369.70,0.00,'2022-05-09 19:07:54','',''),(1435,'21','221','3',1,'Sale Id shift 52',0.00,0.00,0.00,2619.27,0.00,'2022-05-09 19:07:54','',''),(1436,'21','221','3',1,'Sale Id shift 52',0.00,0.00,0.00,3527.67,0.00,'2022-05-09 19:07:54','',''),(1437,'21','221','3',1,'Sale Id shift 52',0.00,0.00,0.00,3777.71,0.00,'2022-05-09 19:07:54','',''),(1438,'21','221','3',1,'Sale Id shift 52',0.00,0.00,0.00,4317.98,0.00,'2022-05-09 19:07:54','',''),(1439,'21','221','3',1,'Sale Id shift 52',0.00,0.00,0.00,3066.50,0.00,'2022-05-09 19:07:54','',''),(1440,'21','221','3',1,'Sale Id shift 52',0.00,0.00,0.00,3070.77,0.00,'2022-05-09 19:07:54','',''),(1441,'21','221','3',1,'Sale Id shift 52',0.00,0.00,0.00,5636.73,0.00,'2022-05-09 19:07:54','',''),(1442,'21','221','1',1,'Sale Id shift 52',0.00,0.00,0.00,6040.80,0.00,'2022-05-09 19:07:54','',''),(1443,'21','221','4',2,'Sale Id shift 52',0.00,0.00,0.00,5189.92,0.00,'2022-05-09 19:07:54','',''),(1444,'21','221','4',2,'Sale Id shift 52',0.00,0.00,0.00,5420.56,0.00,'2022-05-09 19:07:54','',''),(1445,'21','221','5',3,'Sale Id shift 52',0.00,0.00,0.00,872.97,0.00,'2022-05-09 19:07:54','',''),(1446,'21','221','3',1,'Sale Id shift 52',0.00,0.00,0.00,2697.72,0.00,'2022-05-09 19:07:54','',''),(1447,'21','221','1',1,'Sale Id shift 52',0.00,0.00,0.00,4358.50,0.00,'2022-05-09 19:07:54','',''),(1448,'21','221','1',1,'Sale Id shift 52',0.00,0.00,0.00,4609.71,0.00,'2022-05-09 19:07:54','',''),(1449,'21','221','2',1,'Sale Id shift 52',0.00,0.00,0.00,6449.47,0.00,'2022-05-09 19:07:54','',''),(1450,'21','221','2',1,'Sale Id shift 52',0.00,0.00,0.00,3651.27,0.00,'2022-05-09 19:07:54','',''),(1451,'21','221','2',1,'Sale Id shift 52',0.00,0.00,0.00,6123.16,0.00,'2022-05-09 19:07:54','',''),(1452,'21','221','2',1,'Sale Id shift 52',0.00,0.00,0.00,4288.52,0.00,'2022-05-09 19:07:54','',''),(1453,'21','221',NULL,1,'Sale Id shift 52',12530368.95,0.00,0.00,0.00,0.00,'2022-05-09 19:07:54','',''),(1454,'21','221',NULL,2,'Sale Id shift 52',7427336.00,0.00,0.00,0.00,0.00,'2022-05-09 19:07:54','',''),(1455,'21','221',NULL,3,'Sale Id shift 52',480133.50,0.00,0.00,0.00,0.00,'2022-05-09 19:07:54','',''),(1456,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,23275000.00,33250.00,0.00,0.00,'2022-05-10 11:08:22','',''),(1457,'21','221',NULL,2,'Reception corrector for bridging 145',0.00,0.00,0.00,33250.00,0.00,'2022-05-10 11:12:17','',''),(1458,'21','221','4',2,'Received from bridging 145',0.00,0.00,33250.00,0.00,0.00,'2022-05-10 11:12:17','',''),(1459,'21','221','1',1,'Sale Id shift 53',0.00,0.00,0.00,8129.10,0.00,'2022-05-10 12:46:33','',''),(1460,'21','221','2',1,'Sale Id shift 53',0.00,0.00,0.00,6191.74,0.00,'2022-05-10 12:46:33','',''),(1461,'21','221','2',1,'Sale Id shift 53',0.00,0.00,0.00,5000.05,0.00,'2022-05-10 12:46:33','',''),(1462,'21','221','3',1,'Sale Id shift 53',0.00,0.00,0.00,4539.19,0.00,'2022-05-10 12:46:33','',''),(1463,'21','221','3',1,'Sale Id shift 53',0.00,0.00,0.00,3742.49,0.00,'2022-05-10 12:46:33','',''),(1464,'21','221','3',1,'Sale Id shift 53',0.00,0.00,0.00,2826.40,0.00,'2022-05-10 12:46:33','',''),(1465,'21','221','3',1,'Sale Id shift 53',0.00,0.00,0.00,2195.86,0.00,'2022-05-10 12:46:33','',''),(1466,'21','221','3',1,'Sale Id shift 53',0.00,0.00,0.00,4545.60,0.00,'2022-05-10 12:46:33','',''),(1467,'21','221','3',1,'Sale Id shift 53',0.00,0.00,0.00,2694.38,0.00,'2022-05-10 12:46:33','',''),(1468,'21','221','3',1,'Sale Id shift 53',0.00,0.00,0.00,4162.29,0.00,'2022-05-10 12:46:33','',''),(1469,'21','221','1',1,'Sale Id shift 53',0.00,0.00,0.00,386.82,0.00,'2022-05-10 12:46:33','',''),(1470,'21','221','4',2,'Sale Id shift 53',0.00,0.00,0.00,4710.31,0.00,'2022-05-10 12:46:33','',''),(1471,'21','221','4',2,'Sale Id shift 53',0.00,0.00,0.00,3357.40,0.00,'2022-05-10 12:46:33','',''),(1472,'21','221','3',1,'Sale Id shift 53',0.00,0.00,0.00,3030.11,0.00,'2022-05-10 12:46:33','',''),(1473,'21','221','1',1,'Sale Id shift 53',0.00,0.00,0.00,4255.05,0.00,'2022-05-10 12:46:33','',''),(1474,'21','221','1',1,'Sale Id shift 53',0.00,0.00,0.00,4610.62,0.00,'2022-05-10 12:46:33','',''),(1475,'21','221','2',1,'Sale Id shift 53',0.00,0.00,0.00,6955.99,0.00,'2022-05-10 12:46:33','',''),(1476,'21','221','2',1,'Sale Id shift 53',0.00,0.00,0.00,2781.32,0.00,'2022-05-10 12:46:33','',''),(1477,'21','221','2',1,'Sale Id shift 53',0.00,0.00,0.00,3010.59,0.00,'2022-05-10 12:46:33','',''),(1478,'21','221','2',1,'Sale Id shift 53',0.00,0.00,0.00,2574.46,0.00,'2022-05-10 12:46:33','',''),(1479,'21','221',NULL,1,'Sale Id shift 53',11819289.90,0.00,0.00,0.00,0.00,'2022-05-10 12:46:33','',''),(1480,'21','221',NULL,2,'Sale Id shift 53',5647397.00,0.00,0.00,0.00,0.00,'2022-05-10 12:46:33','',''),(1481,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-10 15:14:12','',''),(1482,'21','221',NULL,1,'Reception corrector for bridging 147',0.00,0.00,0.00,15000.00,0.00,'2022-05-10 15:18:45','',''),(1483,'21','221','2',1,'Received from bridging 147',0.00,0.00,15000.00,0.00,0.00,'2022-05-10 15:18:45','',''),(1484,'21','221',NULL,1,'Reception corrector for bridging 146',0.00,0.00,0.00,35000.00,0.00,'2022-05-10 15:18:45','',''),(1485,'21','221','1',1,'Received from bridging 146',0.00,0.00,35000.00,0.00,0.00,'2022-05-10 15:18:45','',''),(1486,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-10 15:20:33','',''),(1487,'21','221',NULL,1,'Reception corrector for bridging 148',0.00,0.00,0.00,60000.00,0.00,'2022-05-10 15:23:08','',''),(1488,'21','221','3',1,'Received from bridging 148',0.00,0.00,60000.00,0.00,0.00,'2022-05-10 15:23:08','',''),(1489,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-10 15:25:19','',''),(1490,'21','221',NULL,1,'Reception corrector for bridging 149',0.00,0.00,0.00,50000.00,0.00,'2022-05-10 15:28:28','',''),(1491,'21','221','2',1,'Received from bridging 149',0.00,0.00,50000.00,0.00,0.00,'2022-05-10 15:28:28','',''),(1492,'21','221','1',1,'Sale Id shift 54',0.00,0.00,0.00,5779.64,0.00,'2022-05-10 17:48:12','',''),(1493,'21','221','2',1,'Sale Id shift 54',0.00,0.00,0.00,6065.72,0.00,'2022-05-10 17:48:12','',''),(1494,'21','221','2',1,'Sale Id shift 54',0.00,0.00,0.00,2887.43,0.00,'2022-05-10 17:48:12','',''),(1495,'21','221','3',1,'Sale Id shift 54',0.00,0.00,0.00,2947.58,0.00,'2022-05-10 17:48:12','',''),(1496,'21','221','3',1,'Sale Id shift 54',0.00,0.00,0.00,1945.22,0.00,'2022-05-10 17:48:12','',''),(1497,'21','221','3',1,'Sale Id shift 54',0.00,0.00,0.00,2827.34,0.00,'2022-05-10 17:48:12','',''),(1498,'21','221','3',1,'Sale Id shift 54',0.00,0.00,0.00,3810.33,0.00,'2022-05-10 17:48:12','',''),(1499,'21','221','3',1,'Sale Id shift 54',0.00,0.00,0.00,2826.43,0.00,'2022-05-10 17:48:12','',''),(1500,'21','221','3',1,'Sale Id shift 54',0.00,0.00,0.00,3500.43,0.00,'2022-05-10 17:48:12','',''),(1501,'21','221','3',1,'Sale Id shift 54',0.00,0.00,0.00,3360.48,0.00,'2022-05-10 17:48:12','',''),(1502,'21','221','1',1,'Sale Id shift 54',0.00,0.00,0.00,2689.27,0.00,'2022-05-10 17:48:12','',''),(1503,'21','221','4',2,'Sale Id shift 54',0.00,0.00,0.00,3362.23,0.00,'2022-05-10 17:48:12','',''),(1504,'21','221','4',2,'Sale Id shift 54',0.00,0.00,0.00,3663.10,0.00,'2022-05-10 17:48:12','',''),(1505,'21','221','5',3,'Sale Id shift 54',0.00,0.00,0.00,674.39,0.00,'2022-05-10 17:48:12','',''),(1506,'21','221','3',1,'Sale Id shift 54',0.00,0.00,0.00,3210.19,0.00,'2022-05-10 17:48:12','',''),(1507,'21','221','1',1,'Sale Id shift 54',0.00,0.00,0.00,4225.84,0.00,'2022-05-10 17:48:12','',''),(1508,'21','221','1',1,'Sale Id shift 54',0.00,0.00,0.00,4435.75,0.00,'2022-05-10 17:48:12','',''),(1509,'21','221','2',1,'Sale Id shift 54',0.00,0.00,0.00,6046.84,0.00,'2022-05-10 17:48:12','',''),(1510,'21','221','2',1,'Sale Id shift 54',0.00,0.00,0.00,2835.90,0.00,'2022-05-10 17:48:12','',''),(1511,'21','221','2',1,'Sale Id shift 54',0.00,0.00,0.00,3306.00,0.00,'2022-05-10 17:48:12','',''),(1512,'21','221','2',1,'Sale Id shift 54',0.00,0.00,0.00,2523.66,0.00,'2022-05-10 17:48:12','',''),(1513,'21','221',NULL,1,'Sale Id shift 54',10761968.25,0.00,0.00,0.00,0.00,'2022-05-10 17:48:12','',''),(1514,'21','221',NULL,2,'Sale Id shift 54',4917731.00,0.00,0.00,0.00,0.00,'2022-05-10 17:48:12','',''),(1515,'21','221',NULL,3,'Sale Id shift 54',438353.50,0.00,0.00,0.00,0.00,'2022-05-10 17:48:12','',''),(1516,'21','221','2',1,'Sale Id shift 55',0.00,0.00,0.00,6824.70,0.00,'2022-05-12 18:46:07','',''),(1517,'21','221','2',1,'Sale Id shift 55',0.00,0.00,0.00,4222.04,0.00,'2022-05-12 18:46:07','',''),(1518,'21','221','3',1,'Sale Id shift 55',0.00,0.00,0.00,3702.64,0.00,'2022-05-12 18:46:07','',''),(1519,'21','221','3',1,'Sale Id shift 55',0.00,0.00,0.00,2842.74,0.00,'2022-05-12 18:46:07','',''),(1520,'21','221','3',1,'Sale Id shift 55',0.00,0.00,0.00,2774.10,0.00,'2022-05-12 18:46:07','',''),(1521,'21','221','3',1,'Sale Id shift 55',0.00,0.00,0.00,2857.25,0.00,'2022-05-12 18:46:07','',''),(1522,'21','221','3',1,'Sale Id shift 55',0.00,0.00,0.00,2769.03,0.00,'2022-05-12 18:46:07','',''),(1523,'21','221','3',1,'Sale Id shift 55',0.00,0.00,0.00,3912.19,0.00,'2022-05-12 18:46:07','',''),(1524,'21','221','3',1,'Sale Id shift 55',0.00,0.00,0.00,2392.12,0.00,'2022-05-12 18:46:07','',''),(1525,'21','221','4',2,'Sale Id shift 55',0.00,0.00,0.00,4566.26,0.00,'2022-05-12 18:46:07','',''),(1526,'21','221','4',2,'Sale Id shift 55',0.00,0.00,0.00,1647.63,0.00,'2022-05-12 18:46:07','',''),(1527,'21','221','5',3,'Sale Id shift 55',0.00,0.00,0.00,655.85,0.00,'2022-05-12 18:46:07','',''),(1528,'21','221','3',1,'Sale Id shift 55',0.00,0.00,0.00,3791.02,0.00,'2022-05-12 18:46:07','',''),(1529,'21','221','1',1,'Sale Id shift 55',0.00,0.00,0.00,24.31,0.00,'2022-05-12 18:46:07','',''),(1530,'21','221','2',1,'Sale Id shift 55',0.00,0.00,0.00,6145.46,0.00,'2022-05-12 18:46:07','',''),(1531,'21','221','2',1,'Sale Id shift 55',0.00,0.00,0.00,2611.60,0.00,'2022-05-12 18:46:07','',''),(1532,'21','221','2',1,'Sale Id shift 55',0.00,0.00,0.00,2238.13,0.00,'2022-05-12 18:46:07','',''),(1533,'21','221','2',1,'Sale Id shift 55',0.00,0.00,0.00,3091.15,0.00,'2022-05-12 18:46:07','',''),(1534,'21','221',NULL,1,'Sale Id shift 55',8282749.20,0.00,0.00,0.00,0.00,'2022-05-12 18:46:07','',''),(1535,'21','221',NULL,2,'Sale Id shift 55',4349723.00,0.00,0.00,0.00,0.00,'2022-05-12 18:46:07','',''),(1536,'21','221',NULL,3,'Sale Id shift 55',426302.50,0.00,0.00,0.00,0.00,'2022-05-12 18:46:07','',''),(1537,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-16 10:27:52','',''),(1538,'21','221',NULL,1,'Reception corrector for bridging 150',0.00,0.00,0.00,50000.00,0.00,'2022-05-16 10:29:49','',''),(1539,'21','221','3',1,'Received from bridging 150',0.00,0.00,50000.00,0.00,0.00,'2022-05-16 10:29:49','',''),(1540,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 10:30:14','',''),(1541,'21','221',NULL,1,'Reception corrector for bridging 151',0.00,0.00,0.00,45000.00,0.00,'2022-05-16 10:37:58','',''),(1542,'21','221','2',1,'Received from bridging 151',0.00,0.00,45000.00,0.00,0.00,'2022-05-16 10:37:58','',''),(1543,'21','221','2',1,'Sale Id shift 57',0.00,0.00,0.00,5701.21,0.00,'2022-05-16 15:13:38','',''),(1544,'21','221','2',1,'Sale Id shift 57',0.00,0.00,0.00,3259.24,0.00,'2022-05-16 15:13:38','',''),(1545,'21','221','3',1,'Sale Id shift 57',0.00,0.00,0.00,5316.25,0.00,'2022-05-16 15:13:38','',''),(1546,'21','221','3',1,'Sale Id shift 57',0.00,0.00,0.00,5939.16,0.00,'2022-05-16 15:13:38','',''),(1547,'21','221','3',1,'Sale Id shift 57',0.00,0.00,0.00,2610.79,0.00,'2022-05-16 15:13:38','',''),(1548,'21','221','3',1,'Sale Id shift 57',0.00,0.00,0.00,5206.00,0.00,'2022-05-16 15:13:38','',''),(1549,'21','221','3',1,'Sale Id shift 57',0.00,0.00,0.00,6317.67,0.00,'2022-05-16 15:13:38','',''),(1550,'21','221','3',1,'Sale Id shift 57',0.00,0.00,0.00,7543.70,0.00,'2022-05-16 15:13:38','',''),(1551,'21','221','3',1,'Sale Id shift 57',0.00,0.00,0.00,6515.41,0.00,'2022-05-16 15:13:38','',''),(1552,'21','221','4',2,'Sale Id shift 57',0.00,0.00,0.00,6093.91,0.00,'2022-05-16 15:13:38','',''),(1553,'21','221','4',2,'Sale Id shift 57',0.00,0.00,0.00,50.71,0.00,'2022-05-16 15:13:38','',''),(1554,'21','221','4',2,'Sale Id shift 57',0.00,0.00,0.00,5751.22,0.00,'2022-05-16 15:13:38','',''),(1555,'21','221','5',3,'Sale Id shift 57',0.00,0.00,0.00,975.21,0.00,'2022-05-16 15:13:38','',''),(1556,'21','221','3',1,'Sale Id shift 57',0.00,0.00,0.00,7027.98,0.00,'2022-05-16 15:13:38','',''),(1557,'21','221','2',1,'Sale Id shift 57',0.00,0.00,0.00,4958.97,0.00,'2022-05-16 15:13:38','',''),(1558,'21','221','2',1,'Sale Id shift 57',0.00,0.00,0.00,2378.14,0.00,'2022-05-16 15:13:38','',''),(1559,'21','221','2',1,'Sale Id shift 57',0.00,0.00,0.00,1666.89,0.00,'2022-05-16 15:13:38','',''),(1560,'21','221','2',1,'Sale Id shift 57',0.00,0.00,0.00,3445.21,0.00,'2022-05-16 15:13:38','',''),(1561,'21','221',NULL,2,'Sale Id shift 57',8327088.00,0.00,0.00,0.00,0.00,'2022-05-16 15:13:38','',''),(1562,'21','221',NULL,3,'Sale Id shift 57',633886.50,0.00,0.00,0.00,0.00,'2022-05-16 15:13:38','',''),(1563,'21','221',NULL,1,'Sale Id shift 57',11201292.30,0.00,0.00,0.00,0.00,'2022-05-16 15:13:38','',''),(1564,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21000000.00,30000.00,0.00,0.00,'2022-05-16 15:36:51','',''),(1565,'21','221',NULL,2,'Reception corrector for bridging 152',0.00,0.00,0.00,30000.00,0.00,'2022-05-16 15:39:06','',''),(1566,'21','221','4',2,'Received from bridging 152',0.00,0.00,30000.00,0.00,0.00,'2022-05-16 15:39:06','',''),(1567,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-16 16:27:41','',''),(1568,'21','221',NULL,1,'Reception corrector for bridging 154',0.00,0.00,0.00,45000.00,0.00,'2022-05-16 16:31:05','',''),(1569,'21','221','3',1,'Received from bridging 154',0.00,0.00,45000.00,0.00,0.00,'2022-05-16 16:31:05','',''),(1570,'21','221',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,15000.00,0.00,'2022-05-16 16:31:05','',''),(1571,'21','221','1',1,'Received from bridging 153',0.00,0.00,15000.00,0.00,0.00,'2022-05-16 16:31:05','',''),(1572,'21','221','2',1,'Sale Id shift 58',0.00,0.00,0.00,10434.29,0.00,'2022-05-16 18:32:54','',''),(1573,'21','221','2',1,'Sale Id shift 58',0.00,0.00,0.00,6477.04,0.00,'2022-05-16 18:32:54','',''),(1574,'21','221','3',1,'Sale Id shift 58',0.00,0.00,0.00,5296.21,0.00,'2022-05-16 18:32:54','',''),(1575,'21','221','3',1,'Sale Id shift 58',0.00,0.00,0.00,4075.57,0.00,'2022-05-16 18:32:54','',''),(1576,'21','221','3',1,'Sale Id shift 58',0.00,0.00,0.00,5971.38,0.00,'2022-05-16 18:32:54','',''),(1577,'21','221','3',1,'Sale Id shift 58',0.00,0.00,0.00,4396.11,0.00,'2022-05-16 18:32:54','',''),(1578,'21','221','3',1,'Sale Id shift 58',0.00,0.00,0.00,5280.52,0.00,'2022-05-16 18:32:54','',''),(1579,'21','221','3',1,'Sale Id shift 58',0.00,0.00,0.00,6629.67,0.00,'2022-05-16 18:32:54','',''),(1580,'21','221','3',1,'Sale Id shift 58',0.00,0.00,0.00,7300.04,0.00,'2022-05-16 18:32:54','',''),(1581,'21','221','4',2,'Sale Id shift 58',0.00,0.00,0.00,5276.63,0.00,'2022-05-16 18:32:54','',''),(1582,'21','221','4',2,'Sale Id shift 58',0.00,0.00,0.00,7963.52,0.00,'2022-05-16 18:32:54','',''),(1583,'21','221','5',3,'Sale Id shift 58',0.00,0.00,0.00,1174.24,0.00,'2022-05-16 18:32:54','',''),(1584,'21','221','3',1,'Sale Id shift 58',0.00,0.00,0.00,6274.81,0.00,'2022-05-16 18:32:54','',''),(1585,'21','221','1',1,'Sale Id shift 58',0.00,0.00,0.00,6.38,0.00,'2022-05-16 18:32:54','',''),(1586,'21','221','2',1,'Sale Id shift 58',0.00,0.00,0.00,9704.98,0.00,'2022-05-16 18:32:54','',''),(1587,'21','221','2',1,'Sale Id shift 58',0.00,0.00,0.00,4260.69,0.00,'2022-05-16 18:32:54','',''),(1588,'21','221','2',1,'Sale Id shift 58',0.00,0.00,0.00,5624.90,0.00,'2022-05-16 18:32:54','',''),(1589,'21','221','2',1,'Sale Id shift 58',0.00,0.00,0.00,6930.67,0.00,'2022-05-16 18:32:54','',''),(1590,'21','221',NULL,2,'Sale Id shift 58',9268105.00,0.00,0.00,0.00,0.00,'2022-05-16 18:32:54','',''),(1591,'21','221',NULL,3,'Sale Id shift 58',763256.00,0.00,0.00,0.00,0.00,'2022-05-16 18:32:54','',''),(1592,'21','221',NULL,1,'Sale Id shift 58',14629437.90,0.00,0.00,0.00,0.00,'2022-05-16 18:32:54','',''),(1593,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 19:09:38','',''),(1594,'21','221',NULL,1,'Reception corrector for bridging 155',0.00,0.00,0.00,45000.00,0.00,'2022-05-16 19:12:52','',''),(1595,'21','221','2',1,'Received from bridging 155',0.00,0.00,45000.00,0.00,0.00,'2022-05-16 19:12:52','',''),(1596,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 19:14:57','',''),(1597,'21','221','2',1,'Sale Id shift 59',0.00,0.00,0.00,7881.79,0.00,'2022-05-17 20:13:03','',''),(1598,'21','221','2',1,'Sale Id shift 59',0.00,0.00,0.00,5075.98,0.00,'2022-05-17 20:13:03','',''),(1599,'21','221','3',1,'Sale Id shift 59',0.00,0.00,0.00,4648.49,0.00,'2022-05-17 20:13:03','',''),(1600,'21','221','3',1,'Sale Id shift 59',0.00,0.00,0.00,1782.07,0.00,'2022-05-17 20:13:03','',''),(1601,'21','221','3',1,'Sale Id shift 59',0.00,0.00,0.00,5012.94,0.00,'2022-05-17 20:13:03','',''),(1602,'21','221','3',1,'Sale Id shift 59',0.00,0.00,0.00,2941.30,0.00,'2022-05-17 20:13:03','',''),(1603,'21','221','3',1,'Sale Id shift 59',0.00,0.00,0.00,3647.80,0.00,'2022-05-17 20:13:03','',''),(1604,'21','221','3',1,'Sale Id shift 59',0.00,0.00,0.00,7278.19,0.00,'2022-05-17 20:13:03','',''),(1605,'21','221','3',1,'Sale Id shift 59',0.00,0.00,0.00,4393.19,0.00,'2022-05-17 20:13:03','',''),(1606,'21','221','4',2,'Sale Id shift 59',0.00,0.00,0.00,1955.50,0.00,'2022-05-17 20:13:03','',''),(1607,'21','221','4',2,'Sale Id shift 59',0.00,0.00,0.00,2404.76,0.00,'2022-05-17 20:13:03','',''),(1608,'21','221','5',3,'Sale Id shift 59',0.00,0.00,0.00,1224.31,0.00,'2022-05-17 20:13:03','',''),(1609,'21','221','3',1,'Sale Id shift 59',0.00,0.00,0.00,4815.63,0.00,'2022-05-17 20:13:03','',''),(1610,'21','221','2',1,'Sale Id shift 59',0.00,0.00,0.00,5629.50,0.00,'2022-05-17 20:13:03','',''),(1611,'21','221','2',1,'Sale Id shift 59',0.00,0.00,0.00,4011.53,0.00,'2022-05-17 20:13:03','',''),(1612,'21','221','2',1,'Sale Id shift 59',0.00,0.00,0.00,4431.39,0.00,'2022-05-17 20:13:03','',''),(1613,'21','221','2',1,'Sale Id shift 59',0.00,0.00,0.00,3988.70,0.00,'2022-05-17 20:13:03','',''),(1614,'21','221',NULL,1,'Sale Id shift 59',10813852.50,0.00,0.00,0.00,0.00,'2022-05-17 20:13:03','',''),(1615,'21','221',NULL,2,'Sale Id shift 59',3052182.00,0.00,0.00,0.00,0.00,'2022-05-17 20:13:03','',''),(1616,'21','221',NULL,3,'Sale Id shift 59',795801.50,0.00,0.00,0.00,0.00,'2022-05-17 20:13:03','',''),(1617,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 11:18:33','',''),(1618,'21','221',NULL,1,'Reception corrector for bridging 156',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 11:21:47','',''),(1619,'21','221','3',1,'Received from bridging 156',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 11:21:47','',''),(1620,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-19 11:25:00','',''),(1621,'21','221',NULL,1,'Reception corrector for bridging 157',0.00,0.00,0.00,40000.00,0.00,'2022-05-19 11:27:38','',''),(1622,'21','221','2',1,'Received from bridging 157',0.00,0.00,40000.00,0.00,0.00,'2022-05-19 11:27:38','',''),(1623,'21','221',NULL,1,'Reception corrector for bridging 159',0.00,0.00,0.00,30000.00,0.00,'2022-05-19 11:35:43','',''),(1624,'21','221','3',1,'Received from bridging 159',0.00,0.00,30000.00,0.00,0.00,'2022-05-19 11:35:43','',''),(1625,'21','221',NULL,1,'Reception corrector for bridging 158',0.00,0.00,0.00,15000.00,0.00,'2022-05-19 11:35:43','',''),(1626,'21','221','2',1,'Received from bridging 158',0.00,0.00,15000.00,0.00,0.00,'2022-05-19 11:35:43','',''),(1627,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10800000.00,15000.00,0.00,0.00,'2022-05-19 11:41:28','',''),(1628,'21','221',NULL,2,'Reception corrector for bridging 160',0.00,0.00,0.00,15000.00,0.00,'2022-05-19 11:47:43','',''),(1629,'21','221','4',2,'Received from bridging 160',0.00,0.00,15000.00,0.00,0.00,'2022-05-19 11:47:43','',''),(1630,'21','221','2',1,'Sale Id shift 61',0.00,0.00,0.00,9196.91,0.00,'2022-05-19 17:57:30','',''),(1631,'21','221','2',1,'Sale Id shift 61',0.00,0.00,0.00,3740.35,0.00,'2022-05-19 17:57:30','',''),(1632,'21','221','3',1,'Sale Id shift 61',0.00,0.00,0.00,3125.67,0.00,'2022-05-19 17:57:30','',''),(1633,'21','221','3',1,'Sale Id shift 61',0.00,0.00,0.00,1830.80,0.00,'2022-05-19 17:57:30','',''),(1634,'21','221','3',1,'Sale Id shift 61',0.00,0.00,0.00,2468.16,0.00,'2022-05-19 17:57:30','',''),(1635,'21','221','3',1,'Sale Id shift 61',0.00,0.00,0.00,2078.50,0.00,'2022-05-19 17:57:30','',''),(1636,'21','221','3',1,'Sale Id shift 61',0.00,0.00,0.00,2822.68,0.00,'2022-05-19 17:57:30','',''),(1637,'21','221','3',1,'Sale Id shift 61',0.00,0.00,0.00,3139.35,0.00,'2022-05-19 17:57:30','',''),(1638,'21','221','3',1,'Sale Id shift 61',0.00,0.00,0.00,2083.82,0.00,'2022-05-19 17:57:30','',''),(1639,'21','221','4',2,'Sale Id shift 61',0.00,0.00,0.00,9641.18,0.00,'2022-05-19 17:57:30','',''),(1640,'21','221','4',2,'Sale Id shift 61',0.00,0.00,0.00,15.22,0.00,'2022-05-19 17:57:30','',''),(1641,'21','221','4',2,'Sale Id shift 61',0.00,0.00,0.00,4280.30,0.00,'2022-05-19 17:57:30','',''),(1642,'21','221','5',3,'Sale Id shift 61',0.00,0.00,0.00,1311.67,0.00,'2022-05-19 17:57:30','',''),(1643,'21','221','3',1,'Sale Id shift 61',0.00,0.00,0.00,2999.54,0.00,'2022-05-19 17:57:30','',''),(1644,'21','221','2',1,'Sale Id shift 61',0.00,0.00,0.00,4321.48,0.00,'2022-05-19 17:57:30','',''),(1645,'21','221','2',1,'Sale Id shift 61',0.00,0.00,0.00,1608.39,0.00,'2022-05-19 17:57:30','',''),(1646,'21','221','2',1,'Sale Id shift 61',0.00,0.00,0.00,3158.74,0.00,'2022-05-19 17:57:30','',''),(1647,'21','221','2',1,'Sale Id shift 61',0.00,0.00,0.00,3278.65,0.00,'2022-05-19 17:57:30','',''),(1648,'21','221',NULL,1,'Sale Id shift 61',7565751.60,0.00,0.00,0.00,0.00,'2022-05-19 17:57:30','',''),(1649,'21','221',NULL,2,'Sale Id shift 61',9755690.00,0.00,0.00,0.00,0.00,'2022-05-19 17:57:30','',''),(1650,'21','221',NULL,3,'Sale Id shift 61',852585.50,0.00,0.00,0.00,0.00,'2022-05-19 17:57:30','',''),(1651,'21','221','2',1,'Sale Id shift 62',0.00,0.00,0.00,11301.21,0.00,'2022-05-19 19:21:48','',''),(1652,'21','221','2',1,'Sale Id shift 62',0.00,0.00,0.00,4710.11,0.00,'2022-05-19 19:21:48','',''),(1653,'21','221','3',1,'Sale Id shift 62',0.00,0.00,0.00,4982.67,0.00,'2022-05-19 19:21:48','',''),(1654,'21','221','3',1,'Sale Id shift 62',0.00,0.00,0.00,5116.84,0.00,'2022-05-19 19:21:48','',''),(1655,'21','221','3',1,'Sale Id shift 62',0.00,0.00,0.00,5370.85,0.00,'2022-05-19 19:21:48','',''),(1656,'21','221','3',1,'Sale Id shift 62',0.00,0.00,0.00,5815.11,0.00,'2022-05-19 19:21:48','',''),(1657,'21','221','3',1,'Sale Id shift 62',0.00,0.00,0.00,4079.45,0.00,'2022-05-19 19:21:48','',''),(1658,'21','221','3',1,'Sale Id shift 62',0.00,0.00,0.00,7166.16,0.00,'2022-05-19 19:21:48','',''),(1659,'21','221','3',1,'Sale Id shift 62',0.00,0.00,0.00,6087.41,0.00,'2022-05-19 19:21:48','',''),(1660,'21','221','4',2,'Sale Id shift 62',0.00,0.00,0.00,7057.95,0.00,'2022-05-19 19:21:48','',''),(1661,'21','221','4',2,'Sale Id shift 62',0.00,0.00,0.00,8702.55,0.00,'2022-05-19 19:21:48','',''),(1662,'21','221','5',3,'Sale Id shift 62',0.00,0.00,0.00,871.13,0.00,'2022-05-19 19:21:48','',''),(1663,'21','221','3',1,'Sale Id shift 62',0.00,0.00,0.00,7483.17,0.00,'2022-05-19 19:21:48','',''),(1664,'21','221','2',1,'Sale Id shift 62',0.00,0.00,0.00,7074.10,0.00,'2022-05-19 19:21:48','',''),(1665,'21','221','2',1,'Sale Id shift 62',0.00,0.00,0.00,4275.17,0.00,'2022-05-19 19:21:48','',''),(1666,'21','221','2',1,'Sale Id shift 62',0.00,0.00,0.00,6584.17,0.00,'2022-05-19 19:21:48','',''),(1667,'21','221','2',1,'Sale Id shift 62',0.00,0.00,0.00,5541.41,0.00,'2022-05-19 19:21:48','',''),(1668,'21','221',NULL,1,'Sale Id shift 62',14121991.95,0.00,0.00,0.00,0.00,'2022-05-19 19:21:48','',''),(1669,'21','221',NULL,2,'Sale Id shift 62',11032350.00,0.00,0.00,0.00,0.00,'2022-05-19 19:21:48','',''),(1670,'21','221',NULL,3,'Sale Id shift 62',566234.50,0.00,0.00,0.00,0.00,'2022-05-19 19:21:48','',''),(1671,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-19 19:49:40','',''),(1672,'21','221',NULL,1,'Reception corrector for bridging 161',0.00,0.00,0.00,60000.00,0.00,'2022-05-19 19:53:13','',''),(1673,'21','221','2',1,'Received from bridging 161',0.00,0.00,60000.00,0.00,0.00,'2022-05-19 19:53:13','',''),(1674,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21600000.00,30000.00,0.00,0.00,'2022-05-19 19:53:51','',''),(1675,'21','221',NULL,2,'Reception corrector for bridging 162',0.00,0.00,0.00,30000.00,0.00,'2022-05-19 19:55:36','',''),(1676,'21','221','4',2,'Received from bridging 162',0.00,0.00,30000.00,0.00,0.00,'2022-05-19 19:55:36','',''),(1677,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 19:56:00','',''),(1678,'21','221',NULL,1,'Reception corrector for bridging 163',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 19:57:27','',''),(1679,'21','221','3',1,'Received from bridging 163',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 19:57:27','',''),(1680,'21','221','2',1,'Sale Id shift 63',0.00,0.00,0.00,11688.59,0.00,'2022-05-20 11:38:51','',''),(1681,'21','221','2',1,'Sale Id shift 63',0.00,0.00,0.00,1721.37,0.00,'2022-05-20 11:38:52','',''),(1682,'21','221','3',1,'Sale Id shift 63',0.00,0.00,0.00,4953.91,0.00,'2022-05-20 11:38:52','',''),(1683,'21','221','3',1,'Sale Id shift 63',0.00,0.00,0.00,3361.20,0.00,'2022-05-20 11:38:52','',''),(1684,'21','221','3',1,'Sale Id shift 63',0.00,0.00,0.00,4656.33,0.00,'2022-05-20 11:38:52','',''),(1685,'21','221','3',1,'Sale Id shift 63',0.00,0.00,0.00,3325.00,0.00,'2022-05-20 11:38:52','',''),(1686,'21','221','3',1,'Sale Id shift 63',0.00,0.00,0.00,4251.29,0.00,'2022-05-20 11:38:52','',''),(1687,'21','221','3',1,'Sale Id shift 63',0.00,0.00,0.00,5277.08,0.00,'2022-05-20 11:38:52','',''),(1688,'21','221','3',1,'Sale Id shift 63',0.00,0.00,0.00,4262.64,0.00,'2022-05-20 11:38:52','',''),(1689,'21','221','4',2,'Sale Id shift 63',0.00,0.00,0.00,6766.49,0.00,'2022-05-20 11:38:52','',''),(1690,'21','221','4',2,'Sale Id shift 63',0.00,0.00,0.00,11920.75,0.00,'2022-05-20 11:38:52','',''),(1691,'21','221','5',3,'Sale Id shift 63',0.00,0.00,0.00,3626.95,0.00,'2022-05-20 11:38:52','',''),(1692,'21','221','3',1,'Sale Id shift 63',0.00,0.00,0.00,6092.86,0.00,'2022-05-20 11:38:52','',''),(1693,'21','221','2',1,'Sale Id shift 63',0.00,0.00,0.00,6902.93,0.00,'2022-05-20 11:38:52','',''),(1694,'21','221','2',1,'Sale Id shift 63',0.00,0.00,0.00,3657.68,0.00,'2022-05-20 11:38:52','',''),(1695,'21','221','2',1,'Sale Id shift 63',0.00,0.00,0.00,5224.33,0.00,'2022-05-20 11:38:52','',''),(1696,'21','221','2',1,'Sale Id shift 63',0.00,0.00,0.00,3708.73,0.00,'2022-05-20 11:38:52','',''),(1697,'21','221',NULL,2,'Sale Id shift 63',13454812.80,0.00,0.00,0.00,0.00,'2022-05-20 11:38:52','',''),(1698,'21','221',NULL,3,'Sale Id shift 63',2357517.50,0.00,0.00,0.00,0.00,'2022-05-20 11:38:52','',''),(1699,'21','221',NULL,1,'Sale Id shift 63',11398850.10,0.00,0.00,0.00,0.00,'2022-05-20 11:38:52','',''),(1700,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-20 11:49:10','',''),(1701,'21','221',NULL,1,'Reception corrector for bridging 165',0.00,0.00,0.00,25000.00,0.00,'2022-05-20 12:07:03','',''),(1702,'21','221','3',1,'Received from bridging 165',0.00,0.00,25000.00,0.00,0.00,'2022-05-20 12:07:03','',''),(1703,'21','221',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,20000.00,0.00,'2022-05-20 12:07:03','',''),(1704,'21','221','2',1,'Received from bridging 164',0.00,0.00,20000.00,0.00,0.00,'2022-05-20 12:07:03','',''),(1705,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21600000.00,30000.00,0.00,0.00,'2022-05-20 12:08:02','',''),(1706,'21','221',NULL,2,'Reception corrector for bridging 166',0.00,0.00,0.00,30000.00,0.00,'2022-05-20 12:10:37','',''),(1707,'21','221','4',2,'Received from bridging 166',0.00,0.00,30000.00,0.00,0.00,'2022-05-20 12:10:37','',''),(1708,'21','221','1',1,'Sale Id shift 64',0.00,0.00,0.00,6153.39,0.00,'2022-05-20 13:54:22','',''),(1709,'21','221','2',1,'Sale Id shift 64',0.00,0.00,0.00,10828.22,0.00,'2022-05-20 13:54:22','',''),(1710,'21','221','2',1,'Sale Id shift 64',0.00,0.00,0.00,6130.97,0.00,'2022-05-20 13:54:22','',''),(1711,'21','221','3',1,'Sale Id shift 64',0.00,0.00,0.00,4494.04,0.00,'2022-05-20 13:54:22','',''),(1712,'21','221','3',1,'Sale Id shift 64',0.00,0.00,0.00,4694.25,0.00,'2022-05-20 13:54:22','',''),(1713,'21','221','3',1,'Sale Id shift 64',0.00,0.00,0.00,6403.37,0.00,'2022-05-20 13:54:22','',''),(1714,'21','221','3',1,'Sale Id shift 64',0.00,0.00,0.00,3829.26,0.00,'2022-05-20 13:54:22','',''),(1715,'21','221','3',1,'Sale Id shift 64',0.00,0.00,0.00,6360.27,0.00,'2022-05-20 13:54:22','',''),(1716,'21','221','3',1,'Sale Id shift 64',0.00,0.00,0.00,4947.67,0.00,'2022-05-20 13:54:22','',''),(1717,'21','221','3',1,'Sale Id shift 64',0.00,0.00,0.00,5955.87,0.00,'2022-05-20 13:54:22','',''),(1718,'21','221','1',1,'Sale Id shift 64',0.00,0.00,0.00,5082.20,0.00,'2022-05-20 13:54:22','',''),(1719,'21','221','4',2,'Sale Id shift 64',0.00,0.00,0.00,12735.11,0.00,'2022-05-20 13:54:22','',''),(1720,'21','221','4',2,'Sale Id shift 64',0.00,0.00,0.00,3266.83,0.00,'2022-05-20 13:54:22','',''),(1721,'21','221','5',3,'Sale Id shift 64',0.00,0.00,0.00,153.44,0.00,'2022-05-20 13:54:22','',''),(1722,'21','221','3',1,'Sale Id shift 64',0.00,0.00,0.00,9159.60,0.00,'2022-05-20 13:54:22','',''),(1723,'21','221','1',1,'Sale Id shift 64',0.00,0.00,0.00,3871.53,0.00,'2022-05-20 13:54:22','',''),(1724,'21','221','1',1,'Sale Id shift 64',0.00,0.00,0.00,5832.52,0.00,'2022-05-20 13:54:22','',''),(1725,'21','221','2',1,'Sale Id shift 64',0.00,0.00,0.00,7526.70,0.00,'2022-05-20 13:54:22','',''),(1726,'21','221','2',1,'Sale Id shift 64',0.00,0.00,0.00,5098.58,0.00,'2022-05-20 13:54:22','',''),(1727,'21','221','2',1,'Sale Id shift 64',0.00,0.00,0.00,4528.92,0.00,'2022-05-20 13:54:22','',''),(1728,'21','221','2',1,'Sale Id shift 64',0.00,0.00,0.00,6555.02,0.00,'2022-05-20 13:54:22','',''),(1729,'21','221',NULL,1,'Sale Id shift 64',17729642.70,0.00,0.00,0.00,0.00,'2022-05-20 13:54:22','',''),(1730,'21','221',NULL,2,'Sale Id shift 64',11521396.80,0.00,0.00,0.00,0.00,'2022-05-20 13:54:22','',''),(1731,'21','221',NULL,3,'Sale Id shift 64',99736.00,0.00,0.00,0.00,0.00,'2022-05-20 13:54:22','',''),(1732,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-20 14:29:26','',''),(1733,'21','221',NULL,1,'Reception corrector for bridging 169',0.00,0.00,0.00,30000.00,0.00,'2022-05-20 14:32:17','',''),(1734,'21','221','3',1,'Received from bridging 169',0.00,0.00,30000.00,0.00,0.00,'2022-05-20 14:32:17','',''),(1735,'21','221',NULL,1,'Reception corrector for bridging 168',0.00,0.00,0.00,20000.00,0.00,'2022-05-20 14:32:17','',''),(1736,'21','221','2',1,'Received from bridging 168',0.00,0.00,20000.00,0.00,0.00,'2022-05-20 14:32:17','',''),(1737,'21','221',NULL,1,'Reception corrector for bridging 167',0.00,0.00,0.00,10000.00,0.00,'2022-05-20 14:32:17','',''),(1738,'21','221','1',1,'Received from bridging 167',0.00,0.00,10000.00,0.00,0.00,'2022-05-20 14:32:17','',''),(1739,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-20 17:29:59','',''),(1740,'21','221',NULL,1,'Reception corrector for bridging 172',0.00,0.00,0.00,25000.00,0.00,'2022-05-20 17:33:50','',''),(1741,'21','221','3',1,'Received from bridging 172',0.00,0.00,25000.00,0.00,0.00,'2022-05-20 17:33:50','',''),(1742,'21','221',NULL,1,'Reception corrector for bridging 171',0.00,0.00,0.00,25000.00,0.00,'2022-05-20 17:33:50','',''),(1743,'21','221','2',1,'Received from bridging 171',0.00,0.00,25000.00,0.00,0.00,'2022-05-20 17:33:50','',''),(1744,'21','221',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,10000.00,0.00,'2022-05-20 17:33:50','',''),(1745,'21','221','1',1,'Received from bridging 170',0.00,0.00,10000.00,0.00,0.00,'2022-05-20 17:33:50','',''),(1746,'21','221','1',1,'Sale Id shift 65',0.00,0.00,0.00,4393.10,0.00,'2022-05-20 17:47:32','',''),(1747,'21','221','2',1,'Sale Id shift 65',0.00,0.00,0.00,9470.66,0.00,'2022-05-20 17:47:32','',''),(1748,'21','221','2',1,'Sale Id shift 65',0.00,0.00,0.00,3332.66,0.00,'2022-05-20 17:47:32','',''),(1749,'21','221','3',1,'Sale Id shift 65',0.00,0.00,0.00,5755.55,0.00,'2022-05-20 17:47:32','',''),(1750,'21','221','3',1,'Sale Id shift 65',0.00,0.00,0.00,4520.81,0.00,'2022-05-20 17:47:32','',''),(1751,'21','221','3',1,'Sale Id shift 65',0.00,0.00,0.00,3914.70,0.00,'2022-05-20 17:47:32','',''),(1752,'21','221','3',1,'Sale Id shift 65',0.00,0.00,0.00,5629.04,0.00,'2022-05-20 17:47:32','',''),(1753,'21','221','3',1,'Sale Id shift 65',0.00,0.00,0.00,5163.89,0.00,'2022-05-20 17:47:32','',''),(1754,'21','221','3',1,'Sale Id shift 65',0.00,0.00,0.00,3830.65,0.00,'2022-05-20 17:47:32','',''),(1755,'21','221','3',1,'Sale Id shift 65',0.00,0.00,0.00,5792.30,0.00,'2022-05-20 17:47:32','',''),(1756,'21','221','1',1,'Sale Id shift 65',0.00,0.00,0.00,3249.28,0.00,'2022-05-20 17:47:32','',''),(1757,'21','221','4',2,'Sale Id shift 65',0.00,0.00,0.00,9616.33,0.00,'2022-05-20 17:47:32','',''),(1758,'21','221','4',2,'Sale Id shift 65',0.00,0.00,0.00,734.71,0.00,'2022-05-20 17:47:32','',''),(1759,'21','221','4',2,'Sale Id shift 65',0.00,0.00,0.00,8240.84,0.00,'2022-05-20 17:47:32','',''),(1760,'21','221','5',3,'Sale Id shift 65',0.00,0.00,0.00,280.37,0.00,'2022-05-20 17:47:32','',''),(1761,'21','221','5',3,'Sale Id shift 65',0.00,0.00,0.00,19.47,0.00,'2022-05-20 17:47:32','',''),(1762,'21','221','5',3,'Sale Id shift 65',0.00,0.00,0.00,249.41,0.00,'2022-05-20 17:47:32','',''),(1763,'21','221','3',1,'Sale Id shift 65',0.00,0.00,0.00,4623.66,0.00,'2022-05-20 17:47:32','',''),(1764,'21','221','1',1,'Sale Id shift 65',0.00,0.00,0.00,3075.57,0.00,'2022-05-20 17:47:32','',''),(1765,'21','221','1',1,'Sale Id shift 65',0.00,0.00,0.00,4342.32,0.00,'2022-05-20 17:47:32','',''),(1766,'21','221','2',1,'Sale Id shift 65',0.00,0.00,0.00,7157.05,0.00,'2022-05-20 17:47:32','',''),(1767,'21','221','2',1,'Sale Id shift 65',0.00,0.00,0.00,3558.19,0.00,'2022-05-20 17:47:32','',''),(1768,'21','221','2',1,'Sale Id shift 65',0.00,0.00,0.00,6198.07,0.00,'2022-05-20 17:47:32','',''),(1769,'21','221','2',1,'Sale Id shift 65',0.00,0.00,0.00,6001.53,0.00,'2022-05-20 17:47:32','',''),(1770,'21','221',NULL,1,'Sale Id shift 65',14851489.95,0.00,0.00,0.00,0.00,'2022-05-20 17:47:32','',''),(1771,'21','221',NULL,2,'Sale Id shift 65',13386153.60,0.00,0.00,0.00,0.00,'2022-05-20 17:47:32','',''),(1772,'21','221',NULL,3,'Sale Id shift 65',357012.50,0.00,0.00,0.00,0.00,'2022-05-20 17:47:32','',''),(1773,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-21 10:33:39','',''),(1774,'21','221',NULL,1,'Reception corrector for bridging 175',0.00,0.00,0.00,30000.00,0.00,'2022-05-21 10:38:06','',''),(1775,'21','221','3',1,'Received from bridging 175',0.00,0.00,30000.00,0.00,0.00,'2022-05-21 10:38:06','',''),(1776,'21','221',NULL,1,'Reception corrector for bridging 174',0.00,0.00,0.00,20000.00,0.00,'2022-05-21 10:38:06','',''),(1777,'21','221','2',1,'Received from bridging 174',0.00,0.00,20000.00,0.00,0.00,'2022-05-21 10:38:06','',''),(1778,'21','221',NULL,1,'Reception corrector for bridging 173',0.00,0.00,0.00,10000.00,0.00,'2022-05-21 10:38:06','',''),(1779,'21','221','1',1,'Received from bridging 173',0.00,0.00,10000.00,0.00,0.00,'2022-05-21 10:38:06','',''),(1780,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21600000.00,30000.00,0.00,0.00,'2022-05-21 10:40:03','',''),(1781,'21','221',NULL,2,'Reception corrector for bridging 176',0.00,0.00,0.00,30000.00,0.00,'2022-05-21 10:41:39','',''),(1782,'21','221','4',2,'Received from bridging 176',0.00,0.00,30000.00,0.00,0.00,'2022-05-21 10:41:39','',''),(1783,'21','221','1',1,'Sale Id shift 66',0.00,0.00,0.00,5212.04,0.00,'2022-05-21 12:28:18','',''),(1784,'21','221','2',1,'Sale Id shift 66',0.00,0.00,0.00,8415.61,0.00,'2022-05-21 12:28:18','',''),(1785,'21','221','2',1,'Sale Id shift 66',0.00,0.00,0.00,5987.76,0.00,'2022-05-21 12:28:18','',''),(1786,'21','221','3',1,'Sale Id shift 66',0.00,0.00,0.00,3543.26,0.00,'2022-05-21 12:28:18','',''),(1787,'21','221','3',1,'Sale Id shift 66',0.00,0.00,0.00,4071.43,0.00,'2022-05-21 12:28:18','',''),(1788,'21','221','3',1,'Sale Id shift 66',0.00,0.00,0.00,4000.65,0.00,'2022-05-21 12:28:18','',''),(1789,'21','221','3',1,'Sale Id shift 66',0.00,0.00,0.00,4121.50,0.00,'2022-05-21 12:28:18','',''),(1790,'21','221','3',1,'Sale Id shift 66',0.00,0.00,0.00,3642.55,0.00,'2022-05-21 12:28:18','',''),(1791,'21','221','3',1,'Sale Id shift 66',0.00,0.00,0.00,3678.00,0.00,'2022-05-21 12:28:18','',''),(1792,'21','221','3',1,'Sale Id shift 66',0.00,0.00,0.00,3391.50,0.00,'2022-05-21 12:28:18','',''),(1793,'21','221','1',1,'Sale Id shift 66',0.00,0.00,0.00,4910.79,0.00,'2022-05-21 12:28:18','',''),(1794,'21','221','4',2,'Sale Id shift 66',0.00,0.00,0.00,8669.43,0.00,'2022-05-21 12:28:18','',''),(1795,'21','221','4',2,'Sale Id shift 66',0.00,0.00,0.00,2394.00,0.00,'2022-05-21 12:28:18','',''),(1796,'21','221','4',2,'Sale Id shift 66',0.00,0.00,0.00,5184.05,0.00,'2022-05-21 12:28:18','',''),(1797,'21','221','5',3,'Sale Id shift 66',0.00,0.00,0.00,1129.96,0.00,'2022-05-21 12:28:18','',''),(1798,'21','221','3',1,'Sale Id shift 66',0.00,0.00,0.00,3930.42,0.00,'2022-05-21 12:28:18','',''),(1799,'21','221','1',1,'Sale Id shift 66',0.00,0.00,0.00,4916.06,0.00,'2022-05-21 12:28:18','',''),(1800,'21','221','1',1,'Sale Id shift 66',0.00,0.00,0.00,4953.90,0.00,'2022-05-21 12:28:18','',''),(1801,'21','221','2',1,'Sale Id shift 66',0.00,0.00,0.00,8518.47,0.00,'2022-05-21 12:28:18','',''),(1802,'21','221','2',1,'Sale Id shift 66',0.00,0.00,0.00,4216.14,0.00,'2022-05-21 12:28:18','',''),(1803,'21','221','2',1,'Sale Id shift 66',0.00,0.00,0.00,3994.07,0.00,'2022-05-21 12:28:18','',''),(1804,'21','221','2',1,'Sale Id shift 66',0.00,0.00,0.00,4604.23,0.00,'2022-05-21 12:28:18','',''),(1805,'21','221',NULL,2,'Sale Id shift 66',11698185.60,0.00,0.00,0.00,0.00,'2022-05-21 12:28:18','',''),(1806,'21','221',NULL,3,'Sale Id shift 66',734474.00,0.00,0.00,0.00,0.00,'2022-05-21 12:28:18','',''),(1807,'21','221',NULL,1,'Sale Id shift 66',14207882.70,0.00,0.00,0.00,0.00,'2022-05-21 12:28:18','',''),(1808,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-21 14:42:34','',''),(1809,'21','221',NULL,1,'Reception corrector for bridging 177',0.00,0.00,0.00,60000.00,0.00,'2022-05-21 14:44:47','',''),(1810,'21','221','3',1,'Received from bridging 177',0.00,0.00,60000.00,0.00,0.00,'2022-05-21 14:44:47','',''),(1811,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-21 14:45:01','',''),(1812,'21','221',NULL,1,'Reception corrector for bridging 178',0.00,0.00,0.00,50000.00,0.00,'2022-05-21 14:47:46','',''),(1813,'21','221','2',1,'Received from bridging 178',0.00,0.00,50000.00,0.00,0.00,'2022-05-21 14:47:46','',''),(1814,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-21 14:56:24','',''),(1815,'21','221',NULL,1,'Reception corrector for bridging 181',0.00,0.00,0.00,8000.00,0.00,'2022-05-21 14:59:16','',''),(1816,'21','221','3',1,'Received from bridging 181',0.00,0.00,8000.00,0.00,0.00,'2022-05-21 14:59:16','',''),(1817,'21','221',NULL,1,'Reception corrector for bridging 180',0.00,0.00,0.00,8000.00,0.00,'2022-05-21 14:59:16','',''),(1818,'21','221','2',1,'Received from bridging 180',0.00,0.00,8000.00,0.00,0.00,'2022-05-21 14:59:16','',''),(1819,'21','221',NULL,1,'Reception corrector for bridging 179',0.00,0.00,0.00,29000.00,0.00,'2022-05-21 14:59:16','',''),(1820,'21','221','1',1,'Received from bridging 179',0.00,0.00,29000.00,0.00,0.00,'2022-05-21 14:59:16','',''),(1821,'21','221','1',1,'Sale Id shift 67',0.00,0.00,0.00,3849.21,0.00,'2022-05-21 16:06:18','',''),(1822,'21','221','2',1,'Sale Id shift 67',0.00,0.00,0.00,5285.43,0.00,'2022-05-21 16:06:18','',''),(1823,'21','221','2',1,'Sale Id shift 67',0.00,0.00,0.00,3420.03,0.00,'2022-05-21 16:06:18','',''),(1824,'21','221','3',1,'Sale Id shift 67',0.00,0.00,0.00,3730.67,0.00,'2022-05-21 16:06:18','',''),(1825,'21','221','3',1,'Sale Id shift 67',0.00,0.00,0.00,3449.46,0.00,'2022-05-21 16:06:18','',''),(1826,'21','221','3',1,'Sale Id shift 67',0.00,0.00,0.00,3531.48,0.00,'2022-05-21 16:06:18','',''),(1827,'21','221','3',1,'Sale Id shift 67',0.00,0.00,0.00,2688.16,0.00,'2022-05-21 16:06:18','',''),(1828,'21','221','3',1,'Sale Id shift 67',0.00,0.00,0.00,3944.41,0.00,'2022-05-21 16:06:18','',''),(1829,'21','221','3',1,'Sale Id shift 67',0.00,0.00,0.00,3730.07,0.00,'2022-05-21 16:06:18','',''),(1830,'21','221','3',1,'Sale Id shift 67',0.00,0.00,0.00,3288.34,0.00,'2022-05-21 16:06:18','',''),(1831,'21','221','1',1,'Sale Id shift 67',0.00,0.00,0.00,4690.09,0.00,'2022-05-21 16:06:18','',''),(1832,'21','221','4',2,'Sale Id shift 67',0.00,0.00,0.00,2287.63,0.00,'2022-05-21 16:06:18','',''),(1833,'21','221','4',2,'Sale Id shift 67',0.00,0.00,0.00,2289.71,0.00,'2022-05-21 16:06:18','',''),(1834,'21','221','5',3,'Sale Id shift 67',0.00,0.00,0.00,0.62,0.00,'2022-05-21 16:06:18','',''),(1835,'21','221','5',3,'Sale Id shift 67',0.00,0.00,0.00,1031.91,0.00,'2022-05-21 16:06:18','',''),(1836,'21','221','3',1,'Sale Id shift 67',0.00,0.00,0.00,4269.58,0.00,'2022-05-21 16:06:18','',''),(1837,'21','221','1',1,'Sale Id shift 67',0.00,0.00,0.00,2795.49,0.00,'2022-05-21 16:06:18','',''),(1838,'21','221','1',1,'Sale Id shift 67',0.00,0.00,0.00,5037.97,0.00,'2022-05-21 16:06:18','',''),(1839,'21','221','2',1,'Sale Id shift 67',0.00,0.00,0.00,6042.58,0.00,'2022-05-21 16:06:18','',''),(1840,'21','221','2',1,'Sale Id shift 67',0.00,0.00,0.00,3263.41,0.00,'2022-05-21 16:06:18','',''),(1841,'21','221','2',1,'Sale Id shift 67',0.00,0.00,0.00,3524.96,0.00,'2022-05-21 16:06:18','',''),(1842,'21','221','2',1,'Sale Id shift 67',0.00,0.00,0.00,3082.25,0.00,'2022-05-21 16:06:18','',''),(1843,'21','221',NULL,1,'Sale Id shift 67',11487892.35,0.00,0.00,0.00,0.00,'2022-05-21 16:06:18','',''),(1844,'21','221',NULL,2,'Sale Id shift 67',3295684.80,0.00,0.00,0.00,0.00,'2022-05-21 16:06:18','',''),(1845,'21','221',NULL,3,'Sale Id shift 67',671144.50,0.00,0.00,0.00,0.00,'2022-05-21 16:06:18','',''),(1846,'21','221','1',1,'Sale Id shift 68',0.00,0.00,0.00,2350.49,0.00,'2022-05-22 16:04:52','',''),(1847,'21','221','2',1,'Sale Id shift 68',0.00,0.00,0.00,5030.58,0.00,'2022-05-22 16:04:52','',''),(1848,'21','221','2',1,'Sale Id shift 68',0.00,0.00,0.00,4181.90,0.00,'2022-05-22 16:04:52','',''),(1849,'21','221','3',1,'Sale Id shift 68',0.00,0.00,0.00,3151.69,0.00,'2022-05-22 16:04:52','',''),(1850,'21','221','3',1,'Sale Id shift 68',0.00,0.00,0.00,2374.96,0.00,'2022-05-22 16:04:52','',''),(1851,'21','221','3',1,'Sale Id shift 68',0.00,0.00,0.00,3005.31,0.00,'2022-05-22 16:04:52','',''),(1852,'21','221','3',1,'Sale Id shift 68',0.00,0.00,0.00,2510.81,0.00,'2022-05-22 16:04:52','',''),(1853,'21','221','3',1,'Sale Id shift 68',0.00,0.00,0.00,3160.86,0.00,'2022-05-22 16:04:52','',''),(1854,'21','221','3',1,'Sale Id shift 68',0.00,0.00,0.00,2637.88,0.00,'2022-05-22 16:04:52','',''),(1855,'21','221','3',1,'Sale Id shift 68',0.00,0.00,0.00,4015.51,0.00,'2022-05-22 16:04:52','',''),(1856,'21','221','1',1,'Sale Id shift 68',0.00,0.00,0.00,4204.02,0.00,'2022-05-22 16:04:52','',''),(1857,'21','221','4',2,'Sale Id shift 68',0.00,0.00,0.00,7601.95,0.00,'2022-05-22 16:04:52','',''),(1858,'21','221','4',2,'Sale Id shift 68',0.00,0.00,0.00,564.66,0.00,'2022-05-22 16:04:52','',''),(1859,'21','221','4',2,'Sale Id shift 68',0.00,0.00,0.00,5913.79,0.00,'2022-05-22 16:04:52','',''),(1860,'21','221','5',3,'Sale Id shift 68',0.00,0.00,0.00,787.05,0.00,'2022-05-22 16:04:52','',''),(1861,'21','221','3',1,'Sale Id shift 68',0.00,0.00,0.00,4750.52,0.00,'2022-05-22 16:04:52','',''),(1862,'21','221','1',1,'Sale Id shift 68',0.00,0.00,0.00,3076.95,0.00,'2022-05-22 16:04:52','',''),(1863,'21','221','1',1,'Sale Id shift 68',0.00,0.00,0.00,2984.39,0.00,'2022-05-22 16:04:52','',''),(1864,'21','221','2',1,'Sale Id shift 68',0.00,0.00,0.00,6335.55,0.00,'2022-05-22 16:04:52','',''),(1865,'21','221','2',1,'Sale Id shift 68',0.00,0.00,0.00,3662.17,0.00,'2022-05-22 16:04:52','',''),(1866,'21','221','2',1,'Sale Id shift 68',0.00,0.00,0.00,3277.72,0.00,'2022-05-22 16:04:52','',''),(1867,'21','221','2',1,'Sale Id shift 68',0.00,0.00,0.00,3497.45,0.00,'2022-05-22 16:04:52','',''),(1868,'21','221',NULL,1,'Sale Id shift 68',10594445.40,0.00,0.00,0.00,0.00,'2022-05-22 16:04:52','',''),(1869,'21','221',NULL,2,'Sale Id shift 68',10137888.00,0.00,0.00,0.00,0.00,'2022-05-22 16:04:52','',''),(1870,'21','221',NULL,3,'Sale Id shift 68',511582.50,0.00,0.00,0.00,0.00,'2022-05-22 16:04:52','',''),(1871,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,40000.00,0.00,0.00,'2022-05-22 18:28:22','',''),(1872,'21','221',NULL,2,'Reception corrector for bridging 182',0.00,0.00,0.00,40000.00,0.00,'2022-05-22 18:31:24','',''),(1873,'21','221','4',2,'Received from bridging 182',0.00,0.00,40000.00,0.00,0.00,'2022-05-22 18:31:24','',''),(1874,'21','221','1',1,'Sale Id shift 69',0.00,0.00,0.00,1968.21,0.00,'2022-05-22 20:56:25','',''),(1875,'21','221','2',1,'Sale Id shift 69',0.00,0.00,0.00,3471.02,0.00,'2022-05-22 20:56:25','',''),(1876,'21','221','2',1,'Sale Id shift 69',0.00,0.00,0.00,2653.08,0.00,'2022-05-22 20:56:25','',''),(1877,'21','221','3',1,'Sale Id shift 69',0.00,0.00,0.00,1522.97,0.00,'2022-05-22 20:56:25','',''),(1878,'21','221','3',1,'Sale Id shift 69',0.00,0.00,0.00,1675.33,0.00,'2022-05-22 20:56:25','',''),(1879,'21','221','3',1,'Sale Id shift 69',0.00,0.00,0.00,1461.58,0.00,'2022-05-22 20:56:25','',''),(1880,'21','221','3',1,'Sale Id shift 69',0.00,0.00,0.00,1901.87,0.00,'2022-05-22 20:56:25','',''),(1881,'21','221','3',1,'Sale Id shift 69',0.00,0.00,0.00,1524.77,0.00,'2022-05-22 20:56:25','',''),(1882,'21','221','3',1,'Sale Id shift 69',0.00,0.00,0.00,966.43,0.00,'2022-05-22 20:56:25','',''),(1883,'21','221','3',1,'Sale Id shift 69',0.00,0.00,0.00,1351.90,0.00,'2022-05-22 20:56:25','',''),(1884,'21','221','1',1,'Sale Id shift 69',0.00,0.00,0.00,3006.15,0.00,'2022-05-22 20:56:25','',''),(1885,'21','221','4',2,'Sale Id shift 69',0.00,0.00,0.00,8112.54,0.00,'2022-05-22 20:56:25','',''),(1886,'21','221','4',2,'Sale Id shift 69',0.00,0.00,0.00,6820.82,0.00,'2022-05-22 20:56:25','',''),(1887,'21','221','5',3,'Sale Id shift 69',0.00,0.00,0.00,0.13,0.00,'2022-05-22 20:56:25','',''),(1888,'21','221','5',3,'Sale Id shift 69',0.00,0.00,0.00,852.99,0.00,'2022-05-22 20:56:25','',''),(1889,'21','221','3',1,'Sale Id shift 69',0.00,0.00,0.00,1618.60,0.00,'2022-05-22 20:56:25','',''),(1890,'21','221','1',1,'Sale Id shift 69',0.00,0.00,0.00,1619.36,0.00,'2022-05-22 20:56:25','',''),(1891,'21','221','1',1,'Sale Id shift 69',0.00,0.00,0.00,1683.34,0.00,'2022-05-22 20:56:25','',''),(1892,'21','221','2',1,'Sale Id shift 69',0.00,0.00,0.00,3091.63,0.00,'2022-05-22 20:56:25','',''),(1893,'21','221','2',1,'Sale Id shift 69',0.00,0.00,0.00,1747.09,0.00,'2022-05-22 20:56:25','',''),(1894,'21','221','2',1,'Sale Id shift 69',0.00,0.00,0.00,1323.64,0.00,'2022-05-22 20:56:25','',''),(1895,'21','221','2',1,'Sale Id shift 69',0.00,0.00,0.00,2334.88,0.00,'2022-05-22 20:56:25','',''),(1896,'21','221',NULL,1,'Sale Id shift 69',5762105.25,0.00,0.00,0.00,0.00,'2022-05-22 20:56:25','',''),(1897,'21','221',NULL,2,'Sale Id shift 69',10752019.20,0.00,0.00,0.00,0.00,'2022-05-22 20:56:25','',''),(1898,'21','221',NULL,3,'Sale Id shift 69',554528.00,0.00,0.00,0.00,0.00,'2022-05-22 20:56:25','',''),(1899,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-24 10:43:04','',''),(1900,'21','221',NULL,1,'Reception corrector for bridging 185',0.00,0.00,0.00,15000.00,0.00,'2022-05-24 10:47:31','',''),(1901,'21','221','3',1,'Received from bridging 185',0.00,0.00,15000.00,0.00,0.00,'2022-05-24 10:47:31','',''),(1902,'21','221',NULL,1,'Reception corrector for bridging 184',0.00,0.00,0.00,15000.00,0.00,'2022-05-24 10:47:31','',''),(1903,'21','221','2',1,'Received from bridging 184',0.00,0.00,15000.00,0.00,0.00,'2022-05-24 10:47:31','',''),(1904,'21','221',NULL,1,'Reception corrector for bridging 183',0.00,0.00,0.00,15000.00,0.00,'2022-05-24 10:47:31','',''),(1905,'21','221','1',1,'Received from bridging 183',0.00,0.00,15000.00,0.00,0.00,'2022-05-24 10:47:31','',''),(1906,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-24 10:50:52','',''),(1907,'21','221',NULL,1,'Reception corrector for bridging 188',0.00,0.00,0.00,25000.00,0.00,'2022-05-24 10:55:21','',''),(1908,'21','221','3',1,'Received from bridging 188',0.00,0.00,25000.00,0.00,0.00,'2022-05-24 10:55:21','',''),(1909,'21','221',NULL,1,'Reception corrector for bridging 187',0.00,0.00,0.00,25000.00,0.00,'2022-05-24 10:55:21','',''),(1910,'21','221','2',1,'Received from bridging 187',0.00,0.00,25000.00,0.00,0.00,'2022-05-24 10:55:21','',''),(1911,'21','221',NULL,1,'Reception corrector for bridging 186',0.00,0.00,0.00,10000.00,0.00,'2022-05-24 10:55:21','',''),(1912,'21','221','1',1,'Received from bridging 186',0.00,0.00,10000.00,0.00,0.00,'2022-05-24 10:55:21','',''),(1913,'21','221','1',1,'Sale Id shift 70',0.00,0.00,0.00,2122.28,0.00,'2022-05-24 13:15:19','',''),(1914,'21','221','2',1,'Sale Id shift 70',0.00,0.00,0.00,4572.31,0.00,'2022-05-24 13:15:19','',''),(1915,'21','221','2',1,'Sale Id shift 70',0.00,0.00,0.00,2905.58,0.00,'2022-05-24 13:15:19','',''),(1916,'21','221','3',1,'Sale Id shift 70',0.00,0.00,0.00,2819.41,0.00,'2022-05-24 13:15:19','',''),(1917,'21','221','3',1,'Sale Id shift 70',0.00,0.00,0.00,2844.68,0.00,'2022-05-24 13:15:19','',''),(1918,'21','221','3',1,'Sale Id shift 70',0.00,0.00,0.00,3150.43,0.00,'2022-05-24 13:15:19','',''),(1919,'21','221','3',1,'Sale Id shift 70',0.00,0.00,0.00,2859.84,0.00,'2022-05-24 13:15:19','',''),(1920,'21','221','3',1,'Sale Id shift 70',0.00,0.00,0.00,3105.82,0.00,'2022-05-24 13:15:19','',''),(1921,'21','221','3',1,'Sale Id shift 70',0.00,0.00,0.00,3242.46,0.00,'2022-05-24 13:15:19','',''),(1922,'21','221','3',1,'Sale Id shift 70',0.00,0.00,0.00,3043.90,0.00,'2022-05-24 13:15:19','',''),(1923,'21','221','1',1,'Sale Id shift 70',0.00,0.00,0.00,2420.58,0.00,'2022-05-24 13:15:19','',''),(1924,'21','221','4',2,'Sale Id shift 70',0.00,0.00,0.00,8362.94,0.00,'2022-05-24 13:15:19','',''),(1925,'21','221','4',2,'Sale Id shift 70',0.00,0.00,0.00,653.22,0.00,'2022-05-24 13:15:19','',''),(1926,'21','221','4',2,'Sale Id shift 70',0.00,0.00,0.00,3746.73,0.00,'2022-05-24 13:15:19','',''),(1927,'21','221','5',3,'Sale Id shift 70',0.00,0.00,0.00,819.62,0.00,'2022-05-24 13:15:19','',''),(1928,'21','221','3',1,'Sale Id shift 70',0.00,0.00,0.00,3852.46,0.00,'2022-05-24 13:15:19','',''),(1929,'21','221','1',1,'Sale Id shift 70',0.00,0.00,0.00,1891.03,0.00,'2022-05-24 13:15:19','',''),(1930,'21','221','1',1,'Sale Id shift 70',0.00,0.00,0.00,2753.36,0.00,'2022-05-24 13:15:19','',''),(1931,'21','221','2',1,'Sale Id shift 70',0.00,0.00,0.00,4144.60,0.00,'2022-05-24 13:15:19','',''),(1932,'21','221','2',1,'Sale Id shift 70',0.00,0.00,0.00,1814.19,0.00,'2022-05-24 13:15:19','',''),(1933,'21','221','2',1,'Sale Id shift 70',0.00,0.00,0.00,1288.94,0.00,'2022-05-24 13:15:19','',''),(1934,'21','221','2',1,'Sale Id shift 70',0.00,0.00,0.00,3321.33,0.00,'2022-05-24 13:15:19','',''),(1935,'21','221',NULL,1,'Sale Id shift 70',8605278.00,0.00,0.00,0.00,0.00,'2022-05-24 13:15:19','',''),(1936,'21','221',NULL,2,'Sale Id shift 70',9189280.80,0.00,0.00,0.00,0.00,'2022-05-24 13:15:19','',''),(1937,'21','221',NULL,3,'Sale Id shift 70',532753.00,0.00,0.00,0.00,0.00,'2022-05-24 13:15:19','',''),(1938,'21','221','1',1,'Sale Id shift 71',0.00,0.00,0.00,2202.65,0.00,'2022-05-24 16:02:26','',''),(1939,'21','221','2',1,'Sale Id shift 71',0.00,0.00,0.00,3812.57,0.00,'2022-05-24 16:02:26','',''),(1940,'21','221','2',1,'Sale Id shift 71',0.00,0.00,0.00,4539.78,0.00,'2022-05-24 16:02:26','',''),(1941,'21','221','3',1,'Sale Id shift 71',0.00,0.00,0.00,2911.76,0.00,'2022-05-24 16:02:26','',''),(1942,'21','221','3',1,'Sale Id shift 71',0.00,0.00,0.00,2008.95,0.00,'2022-05-24 16:02:26','',''),(1943,'21','221','3',1,'Sale Id shift 71',0.00,0.00,0.00,1876.94,0.00,'2022-05-24 16:02:26','',''),(1944,'21','221','3',1,'Sale Id shift 71',0.00,0.00,0.00,2269.35,0.00,'2022-05-24 16:02:26','',''),(1945,'21','221','3',1,'Sale Id shift 71',0.00,0.00,0.00,1948.83,0.00,'2022-05-24 16:02:26','',''),(1946,'21','221','3',1,'Sale Id shift 71',0.00,0.00,0.00,1904.98,0.00,'2022-05-24 16:02:26','',''),(1947,'21','221','3',1,'Sale Id shift 71',0.00,0.00,0.00,2412.01,0.00,'2022-05-24 16:02:26','',''),(1948,'21','221','1',1,'Sale Id shift 71',0.00,0.00,0.00,3152.88,0.00,'2022-05-24 16:02:26','',''),(1949,'21','221','4',2,'Sale Id shift 71',0.00,0.00,0.00,7367.92,0.00,'2022-05-24 16:02:26','',''),(1950,'21','221','4',2,'Sale Id shift 71',0.00,0.00,0.00,3688.05,0.00,'2022-05-24 16:02:26','',''),(1951,'21','221','5',3,'Sale Id shift 71',0.00,0.00,0.00,697.50,0.00,'2022-05-24 16:02:26','',''),(1952,'21','221','3',1,'Sale Id shift 71',0.00,0.00,0.00,2634.55,0.00,'2022-05-24 16:02:26','',''),(1953,'21','221','1',1,'Sale Id shift 71',0.00,0.00,0.00,3320.50,0.00,'2022-05-24 16:02:26','',''),(1954,'21','221','1',1,'Sale Id shift 71',0.00,0.00,0.00,2165.14,0.00,'2022-05-24 16:02:26','',''),(1955,'21','221','2',1,'Sale Id shift 71',0.00,0.00,0.00,4656.89,0.00,'2022-05-24 16:02:26','',''),(1956,'21','221','2',1,'Sale Id shift 71',0.00,0.00,0.00,3346.86,0.00,'2022-05-24 16:02:26','',''),(1957,'21','221','2',1,'Sale Id shift 71',0.00,0.00,0.00,2836.37,0.00,'2022-05-24 16:02:26','',''),(1958,'21','221',NULL,1,'Sale Id shift 71',7920166.65,0.00,0.00,0.00,0.00,'2022-05-24 16:02:26','',''),(1959,'21','221',NULL,2,'Sale Id shift 71',7960298.40,0.00,0.00,0.00,0.00,'2022-05-24 16:02:27','',''),(1960,'21','221',NULL,3,'Sale Id shift 71',453375.00,0.00,0.00,0.00,0.00,'2022-05-24 16:02:27','',''),(1961,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-29 11:42:57','',''),(1962,'21','221',NULL,1,'Reception corrector for bridging 189',0.00,0.00,0.00,60000.00,0.00,'2022-05-29 11:45:19','',''),(1963,'21','221','2',1,'Received from bridging 189',0.00,0.00,60000.00,0.00,0.00,'2022-05-29 11:45:19','',''),(1964,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-29 11:48:55','',''),(1965,'21','221',NULL,1,'Reception corrector for bridging 191',0.00,0.00,0.00,40000.00,0.00,'2022-05-29 11:50:56','',''),(1966,'21','221','3',1,'Received from bridging 191',0.00,0.00,40000.00,0.00,0.00,'2022-05-29 11:50:56','',''),(1967,'21','221',NULL,1,'Reception corrector for bridging 190',0.00,0.00,0.00,20000.00,0.00,'2022-05-29 11:50:56','',''),(1968,'21','221','1',1,'Received from bridging 190',0.00,0.00,20000.00,0.00,0.00,'2022-05-29 11:50:56','',''),(1969,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11400000.00,15000.00,0.00,0.00,'2022-05-29 12:11:56','',''),(1970,'21','221',NULL,2,'Reception corrector for bridging 192',0.00,0.00,0.00,15000.00,0.00,'2022-05-29 12:14:21','',''),(1971,'21','221','4',2,'Received from bridging 192',0.00,0.00,15000.00,0.00,0.00,'2022-05-29 12:14:21','',''),(1972,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,15200000.00,20000.00,0.00,0.00,'2022-05-29 12:22:30','',''),(1973,'21','221',NULL,2,'Reception corrector for bridging 193',0.00,0.00,0.00,20000.00,0.00,'2022-05-29 12:24:08','',''),(1974,'21','221','4',2,'Received from bridging 193',0.00,0.00,20000.00,0.00,0.00,'2022-05-29 12:24:08','',''),(1975,'21','221','1',1,'Sale Id shift 72',0.00,0.00,0.00,3536.60,0.00,'2022-05-29 13:56:02','',''),(1976,'21','221','2',1,'Sale Id shift 72',0.00,0.00,0.00,5846.77,0.00,'2022-05-29 13:56:02','',''),(1977,'21','221','2',1,'Sale Id shift 72',0.00,0.00,0.00,3611.71,0.00,'2022-05-29 13:56:02','',''),(1978,'21','221','3',1,'Sale Id shift 72',0.00,0.00,0.00,2198.25,0.00,'2022-05-29 13:56:02','',''),(1979,'21','221','3',1,'Sale Id shift 72',0.00,0.00,0.00,3073.76,0.00,'2022-05-29 13:56:02','',''),(1980,'21','221','3',1,'Sale Id shift 72',0.00,0.00,0.00,2985.43,0.00,'2022-05-29 13:56:02','',''),(1981,'21','221','3',1,'Sale Id shift 72',0.00,0.00,0.00,2898.70,0.00,'2022-05-29 13:56:02','',''),(1982,'21','221','3',1,'Sale Id shift 72',0.00,0.00,0.00,2344.38,0.00,'2022-05-29 13:56:02','',''),(1983,'21','221','3',1,'Sale Id shift 72',0.00,0.00,0.00,2697.55,0.00,'2022-05-29 13:56:02','',''),(1984,'21','221','3',1,'Sale Id shift 72',0.00,0.00,0.00,4239.24,0.00,'2022-05-29 13:56:02','',''),(1985,'21','221','1',1,'Sale Id shift 72',0.00,0.00,0.00,2857.21,0.00,'2022-05-29 13:56:02','',''),(1986,'21','221','4',2,'Sale Id shift 72',0.00,0.00,0.00,18219.39,0.00,'2022-05-29 13:56:02','',''),(1987,'21','221','4',2,'Sale Id shift 72',0.00,0.00,0.00,4350.65,0.00,'2022-05-29 13:56:02','',''),(1988,'21','221','4',2,'Sale Id shift 72',0.00,0.00,0.00,689.72,0.00,'2022-05-29 13:56:02','',''),(1989,'21','221','5',3,'Sale Id shift 72',0.00,0.00,0.00,951.67,0.00,'2022-05-29 13:56:02','',''),(1990,'21','221','3',1,'Sale Id shift 72',0.00,0.00,0.00,2909.65,0.00,'2022-05-29 13:56:02','',''),(1991,'21','221','1',1,'Sale Id shift 72',0.00,0.00,0.00,2413.75,0.00,'2022-05-29 13:56:02','',''),(1992,'21','221','1',1,'Sale Id shift 72',0.00,0.00,0.00,3424.89,0.00,'2022-05-29 13:56:02','',''),(1993,'21','221','2',1,'Sale Id shift 72',0.00,0.00,0.00,4874.26,0.00,'2022-05-29 13:56:02','',''),(1994,'21','221','2',1,'Sale Id shift 72',0.00,0.00,0.00,3007.72,0.00,'2022-05-29 13:56:02','',''),(1995,'21','221','2',1,'Sale Id shift 72',0.00,0.00,0.00,3335.18,0.00,'2022-05-29 13:56:02','',''),(1996,'21','221','2',1,'Sale Id shift 72',0.00,0.00,0.00,3740.25,0.00,'2022-05-29 13:56:02','',''),(1997,'21','221',NULL,1,'Sale Id shift 72',9899224.50,0.00,0.00,0.00,0.00,'2022-05-29 13:56:02','',''),(1998,'21','221',NULL,2,'Sale Id shift 72',17677417.60,0.00,0.00,0.00,0.00,'2022-05-29 13:56:02','',''),(1999,'21','221',NULL,3,'Sale Id shift 72',618585.50,0.00,0.00,0.00,0.00,'2022-05-29 13:56:02','',''),(2000,'21','221','4',2,'Sale Id shift 74',0.00,0.00,0.00,59.38,0.00,'2022-05-31 17:47:34','',''),(2001,'21','221','4',2,'Sale Id shift 74',0.00,0.00,0.00,6353.82,0.00,'2022-05-31 17:47:34','',''),(2002,'21','221',NULL,2,'Sale Id shift 74',4874032.00,0.00,0.00,0.00,0.00,'2022-05-31 17:47:34','',''),(2003,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7600000.00,10000.00,0.00,0.00,'2022-06-01 16:21:31','',''),(2004,'21','221',NULL,2,'Reception corrector for bridging 194',0.00,0.00,0.00,10000.00,0.00,'2022-06-01 16:23:18','',''),(2005,'21','221','4',2,'Received from bridging 194',0.00,0.00,10000.00,0.00,0.00,'2022-06-01 16:23:18','',''),(2006,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-01 16:24:00','',''),(2007,'21','221',NULL,1,'Reception corrector for bridging 197',0.00,0.00,0.00,30000.00,0.00,'2022-06-01 16:26:23','',''),(2008,'21','221','3',1,'Received from bridging 197',0.00,0.00,30000.00,0.00,0.00,'2022-06-01 16:26:23','',''),(2009,'21','221',NULL,1,'Reception corrector for bridging 196',0.00,0.00,0.00,20000.00,0.00,'2022-06-01 16:26:23','',''),(2010,'21','221','2',1,'Received from bridging 196',0.00,0.00,20000.00,0.00,0.00,'2022-06-01 16:26:23','',''),(2011,'21','221',NULL,1,'Reception corrector for bridging 195',0.00,0.00,0.00,10000.00,0.00,'2022-06-01 16:26:23','',''),(2012,'21','221','1',1,'Received from bridging 195',0.00,0.00,10000.00,0.00,0.00,'2022-06-01 16:26:23','',''),(2013,'21','221','1',1,'Sale Id shift 75',0.00,0.00,0.00,4378.35,0.00,'2022-06-01 18:55:20','',''),(2014,'21','221','2',1,'Sale Id shift 75',0.00,0.00,0.00,5909.42,0.00,'2022-06-01 18:55:20','',''),(2015,'21','221','2',1,'Sale Id shift 75',0.00,0.00,0.00,3894.21,0.00,'2022-06-01 18:55:20','',''),(2016,'21','221','3',1,'Sale Id shift 75',0.00,0.00,0.00,2435.43,0.00,'2022-06-01 18:55:20','',''),(2017,'21','221','3',1,'Sale Id shift 75',0.00,0.00,0.00,3005.67,0.00,'2022-06-01 18:55:20','',''),(2018,'21','221','3',1,'Sale Id shift 75',0.00,0.00,0.00,2460.15,0.00,'2022-06-01 18:55:20','',''),(2019,'21','221','3',1,'Sale Id shift 75',0.00,0.00,0.00,2484.52,0.00,'2022-06-01 18:55:20','',''),(2020,'21','221','3',1,'Sale Id shift 75',0.00,0.00,0.00,2830.44,0.00,'2022-06-01 18:55:20','',''),(2021,'21','221','3',1,'Sale Id shift 75',0.00,0.00,0.00,2757.96,0.00,'2022-06-01 18:55:20','',''),(2022,'21','221','3',1,'Sale Id shift 75',0.00,0.00,0.00,2843.39,0.00,'2022-06-01 18:55:20','',''),(2023,'21','221','1',1,'Sale Id shift 75',0.00,0.00,0.00,3346.74,0.00,'2022-06-01 18:55:20','',''),(2024,'21','221','4',2,'Sale Id shift 75',0.00,0.00,0.00,4388.37,0.00,'2022-06-01 18:55:20','',''),(2025,'21','221','4',2,'Sale Id shift 75',0.00,0.00,0.00,5020.08,0.00,'2022-06-01 18:55:20','',''),(2026,'21','221','5',3,'Sale Id shift 75',0.00,0.00,0.00,10.97,0.00,'2022-06-01 18:55:20','',''),(2027,'21','221','5',3,'Sale Id shift 75',0.00,0.00,0.00,14835.14,0.00,'2022-06-01 18:55:20','',''),(2028,'21','221','5',3,'Sale Id shift 75',0.00,0.00,0.00,512.68,0.00,'2022-06-01 18:55:20','',''),(2029,'21','221','3',1,'Sale Id shift 75',0.00,0.00,0.00,3278.50,0.00,'2022-06-01 18:55:20','',''),(2030,'21','221','1',1,'Sale Id shift 75',0.00,0.00,0.00,3107.24,0.00,'2022-06-01 18:55:20','',''),(2031,'21','221','1',1,'Sale Id shift 75',0.00,0.00,0.00,4147.59,0.00,'2022-06-01 18:55:20','',''),(2032,'21','221','2',1,'Sale Id shift 75',0.00,0.00,0.00,4554.15,0.00,'2022-06-01 18:55:20','',''),(2033,'21','221','2',1,'Sale Id shift 75',0.00,0.00,0.00,3518.62,0.00,'2022-06-01 18:55:20','',''),(2034,'21','221','2',1,'Sale Id shift 75',0.00,0.00,0.00,2934.27,0.00,'2022-06-01 18:55:20','',''),(2035,'21','221','2',1,'Sale Id shift 75',0.00,0.00,0.00,2218.41,0.00,'2022-06-01 18:55:20','',''),(2036,'21','221',NULL,1,'Sale Id shift 75',9917334.90,0.00,0.00,0.00,0.00,'2022-06-01 18:55:20','',''),(2037,'21','221',NULL,2,'Sale Id shift 75',7150422.00,0.00,0.00,0.00,0.00,'2022-06-01 18:55:20','',''),(2038,'21','221',NULL,3,'Sale Id shift 75',9983213.50,0.00,0.00,0.00,0.00,'2022-06-01 18:55:20','',''),(2039,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-02 14:34:32','',''),(2040,'21','221',NULL,1,'Reception corrector for bridging 200',0.00,0.00,0.00,30000.00,0.00,'2022-06-02 14:41:05','',''),(2041,'21','221','3',1,'Received from bridging 200',0.00,0.00,30000.00,0.00,0.00,'2022-06-02 14:41:05','',''),(2042,'21','221',NULL,1,'Reception corrector for bridging 199',0.00,0.00,0.00,20000.00,0.00,'2022-06-02 14:41:05','',''),(2043,'21','221','2',1,'Received from bridging 199',0.00,0.00,20000.00,0.00,0.00,'2022-06-02 14:41:05','',''),(2044,'21','221',NULL,1,'Reception corrector for bridging 198',0.00,0.00,0.00,10000.00,0.00,'2022-06-02 14:41:05','',''),(2045,'21','221','1',1,'Received from bridging 198',0.00,0.00,10000.00,0.00,0.00,'2022-06-02 14:41:05','',''),(2046,'21','221',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21352500.00,32850.00,0.00,0.00,'2022-06-02 14:42:38','',''),(2047,'21','221',NULL,3,'Reception corrector for bridging 201',0.00,0.00,0.00,32850.00,0.00,'2022-06-02 14:46:55','',''),(2048,'21','221','5',3,'Received from bridging 201',0.00,0.00,32850.00,0.00,0.00,'2022-06-02 14:46:55','',''),(2049,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11400000.00,15000.00,0.00,0.00,'2022-06-02 14:47:12','',''),(2050,'21','221',NULL,2,'Reception corrector for bridging 202',0.00,0.00,0.00,15000.00,0.00,'2022-06-02 14:53:04','',''),(2051,'21','221','4',2,'Received from bridging 202',0.00,0.00,15000.00,0.00,0.00,'2022-06-02 14:53:04','',''),(2052,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11400000.00,15000.00,0.00,0.00,'2022-06-02 14:54:34','',''),(2053,'21','221',NULL,2,'Reception corrector for bridging 203',0.00,0.00,0.00,15000.00,0.00,'2022-06-02 14:56:22','',''),(2054,'21','221','4',2,'Received from bridging 203',0.00,0.00,15000.00,0.00,0.00,'2022-06-02 14:56:22','',''),(2055,'21','221','1',1,'Sale Id shift 76',0.00,0.00,0.00,-40.00,0.00,'2022-06-02 17:27:05','',''),(2056,'21','221','2',1,'Sale Id shift 76',0.00,0.00,0.00,8521.87,0.00,'2022-06-02 17:27:05','',''),(2057,'21','221','2',1,'Sale Id shift 76',0.00,0.00,0.00,4329.68,0.00,'2022-06-02 17:27:05','',''),(2058,'21','221','3',1,'Sale Id shift 76',0.00,0.00,0.00,4269.18,0.00,'2022-06-02 17:27:05','',''),(2059,'21','221','3',1,'Sale Id shift 76',0.00,0.00,0.00,2547.93,0.00,'2022-06-02 17:27:05','',''),(2060,'21','221','3',1,'Sale Id shift 76',0.00,0.00,0.00,4639.14,0.00,'2022-06-02 17:27:05','',''),(2061,'21','221','3',1,'Sale Id shift 76',0.00,0.00,0.00,3363.76,0.00,'2022-06-02 17:27:05','',''),(2062,'21','221','3',1,'Sale Id shift 76',0.00,0.00,0.00,2750.57,0.00,'2022-06-02 17:27:05','',''),(2063,'21','221','3',1,'Sale Id shift 76',0.00,0.00,0.00,4237.00,0.00,'2022-06-02 17:27:05','',''),(2064,'21','221','3',1,'Sale Id shift 76',0.00,0.00,0.00,3879.71,0.00,'2022-06-02 17:27:05','',''),(2065,'21','221','4',2,'Sale Id shift 76',0.00,0.00,0.00,6770.55,0.00,'2022-06-02 17:27:05','',''),(2066,'21','221','4',2,'Sale Id shift 76',0.00,0.00,0.00,2051.55,0.00,'2022-06-02 17:27:05','',''),(2067,'21','221','4',2,'Sale Id shift 76',0.00,0.00,0.00,10319.59,0.00,'2022-06-02 17:27:05','',''),(2068,'21','221','5',3,'Sale Id shift 76',0.00,0.00,0.00,726.17,0.00,'2022-06-02 17:27:05','',''),(2069,'21','221','5',3,'Sale Id shift 76',0.00,0.00,0.00,17.71,0.00,'2022-06-02 17:27:05','',''),(2070,'21','221','3',1,'Sale Id shift 76',0.00,0.00,0.00,3320.81,0.00,'2022-06-02 17:27:05','',''),(2071,'21','221','2',1,'Sale Id shift 76',0.00,0.00,0.00,7026.04,0.00,'2022-06-02 17:27:05','',''),(2072,'21','221','2',1,'Sale Id shift 76',0.00,0.00,0.00,3059.12,0.00,'2022-06-02 17:27:05','',''),(2073,'21','221','2',1,'Sale Id shift 76',0.00,0.00,0.00,3002.20,0.00,'2022-06-02 17:27:05','',''),(2074,'21','221','2',1,'Sale Id shift 76',0.00,0.00,0.00,4815.05,0.00,'2022-06-02 17:27:05','',''),(2075,'21','221',NULL,2,'Sale Id shift 76',14547684.40,0.00,0.00,0.00,0.00,'2022-06-02 17:27:05','',''),(2076,'21','221',NULL,3,'Sale Id shift 76',483522.00,0.00,0.00,0.00,0.00,'2022-06-02 17:27:05','',''),(2077,'21','221',NULL,1,'Sale Id shift 76',9854139.90,0.00,0.00,0.00,0.00,'2022-06-02 17:27:05','',''),(2078,'21','221','2',1,'Sale Id shift 77',0.00,0.00,0.00,10304.85,0.00,'2022-06-02 19:27:40','',''),(2079,'21','221','2',1,'Sale Id shift 77',0.00,0.00,0.00,5078.93,0.00,'2022-06-02 19:27:40','',''),(2080,'21','221','3',1,'Sale Id shift 77',0.00,0.00,0.00,6229.55,0.00,'2022-06-02 19:27:40','',''),(2081,'21','221','3',1,'Sale Id shift 77',0.00,0.00,0.00,5165.42,0.00,'2022-06-02 19:27:40','',''),(2082,'21','221','3',1,'Sale Id shift 77',0.00,0.00,0.00,5352.35,0.00,'2022-06-02 19:27:40','',''),(2083,'21','221','3',1,'Sale Id shift 77',0.00,0.00,0.00,4464.07,0.00,'2022-06-02 19:27:40','',''),(2084,'21','221','3',1,'Sale Id shift 77',0.00,0.00,0.00,5073.16,0.00,'2022-06-02 19:27:40','',''),(2085,'21','221','3',1,'Sale Id shift 77',0.00,0.00,0.00,4755.37,0.00,'2022-06-02 19:27:40','',''),(2086,'21','221','3',1,'Sale Id shift 77',0.00,0.00,0.00,4113.05,0.00,'2022-06-02 19:27:40','',''),(2087,'21','221','4',2,'Sale Id shift 77',0.00,0.00,0.00,6146.41,0.00,'2022-06-02 19:27:40','',''),(2088,'21','221','4',2,'Sale Id shift 77',0.00,0.00,0.00,6502.96,0.00,'2022-06-02 19:27:40','',''),(2089,'21','221','5',3,'Sale Id shift 77',0.00,0.00,0.00,866.17,0.00,'2022-06-02 19:27:40','',''),(2090,'21','221','3',1,'Sale Id shift 77',0.00,0.00,0.00,6881.80,0.00,'2022-06-02 19:27:40','',''),(2091,'21','221','2',1,'Sale Id shift 77',0.00,0.00,0.00,8925.57,0.00,'2022-06-02 19:27:40','',''),(2092,'21','221','2',1,'Sale Id shift 77',0.00,0.00,0.00,4518.92,0.00,'2022-06-02 19:27:40','',''),(2093,'21','221','2',1,'Sale Id shift 77',0.00,0.00,0.00,5761.67,0.00,'2022-06-02 19:27:40','',''),(2094,'21','221','2',1,'Sale Id shift 77',0.00,0.00,0.00,5318.86,0.00,'2022-06-02 19:27:40','',''),(2095,'21','221',NULL,1,'Sale Id shift 77',13520689.05,0.00,0.00,0.00,0.00,'2022-06-02 19:27:40','',''),(2096,'21','221',NULL,2,'Sale Id shift 77',9613521.20,0.00,0.00,0.00,0.00,'2022-06-02 19:27:40','',''),(2097,'21','221',NULL,3,'Sale Id shift 77',563010.50,0.00,0.00,0.00,0.00,'2022-06-02 19:27:40','',''),(2098,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-02 19:51:18','',''),(2099,'21','221',NULL,1,'Reception corrector for bridging 204',0.00,0.00,0.00,60000.00,0.00,'2022-06-02 19:53:17','',''),(2100,'21','221','2',1,'Received from bridging 204',0.00,0.00,60000.00,0.00,0.00,'2022-06-02 19:53:17','',''),(2101,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-02 19:53:36','',''),(2102,'21','221',NULL,1,'Reception corrector for bridging 205',0.00,0.00,0.00,60000.00,0.00,'2022-06-02 19:55:33','',''),(2103,'21','221','3',1,'Received from bridging 205',0.00,0.00,60000.00,0.00,0.00,'2022-06-02 19:55:33','',''),(2104,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11400000.00,15000.00,0.00,0.00,'2022-06-02 19:55:50','',''),(2105,'21','221',NULL,2,'Reception corrector for bridging 206',0.00,0.00,0.00,15000.00,0.00,'2022-06-02 19:57:29','',''),(2106,'21','221','4',2,'Received from bridging 206',0.00,0.00,15000.00,0.00,0.00,'2022-06-02 19:57:29','',''),(2107,'21','221','2',1,'Sale Id shift 78',0.00,0.00,0.00,6320.44,0.00,'2022-06-02 21:31:02','',''),(2108,'21','221','2',1,'Sale Id shift 78',0.00,0.00,0.00,3981.56,0.00,'2022-06-02 21:31:02','',''),(2109,'21','221','3',1,'Sale Id shift 78',0.00,0.00,0.00,3184.72,0.00,'2022-06-02 21:31:02','',''),(2110,'21','221','3',1,'Sale Id shift 78',0.00,0.00,0.00,3921.08,0.00,'2022-06-02 21:31:02','',''),(2111,'21','221','3',1,'Sale Id shift 78',0.00,0.00,0.00,3310.28,0.00,'2022-06-02 21:31:02','',''),(2112,'21','221','3',1,'Sale Id shift 78',0.00,0.00,0.00,2969.46,0.00,'2022-06-02 21:31:02','',''),(2113,'21','221','3',1,'Sale Id shift 78',0.00,0.00,0.00,3119.63,0.00,'2022-06-02 21:31:02','',''),(2114,'21','221','3',1,'Sale Id shift 78',0.00,0.00,0.00,5449.06,0.00,'2022-06-02 21:31:02','',''),(2115,'21','221','3',1,'Sale Id shift 78',0.00,0.00,0.00,3833.09,0.00,'2022-06-02 21:31:02','',''),(2116,'21','221','4',2,'Sale Id shift 78',0.00,0.00,0.00,6373.62,0.00,'2022-06-02 21:31:02','',''),(2117,'21','221','4',2,'Sale Id shift 78',0.00,0.00,0.00,244.60,0.00,'2022-06-02 21:31:02','',''),(2118,'21','221','4',2,'Sale Id shift 78',0.00,0.00,0.00,3894.33,0.00,'2022-06-02 21:31:02','',''),(2119,'21','221','5',3,'Sale Id shift 78',0.00,0.00,0.00,714.80,0.00,'2022-06-02 21:31:02','',''),(2120,'21','221','3',1,'Sale Id shift 78',0.00,0.00,0.00,1883.81,0.00,'2022-06-02 21:31:02','',''),(2121,'21','221','2',1,'Sale Id shift 78',0.00,0.00,0.00,5622.91,0.00,'2022-06-02 21:31:02','',''),(2122,'21','221','2',1,'Sale Id shift 78',0.00,0.00,0.00,2258.55,0.00,'2022-06-02 21:31:02','',''),(2123,'21','221','2',1,'Sale Id shift 78',0.00,0.00,0.00,3691.07,0.00,'2022-06-02 21:31:02','',''),(2124,'21','221','2',1,'Sale Id shift 78',0.00,0.00,0.00,5445.10,0.00,'2022-06-02 21:31:02','',''),(2125,'21','221',NULL,2,'Sale Id shift 78',7989538.00,0.00,0.00,0.00,0.00,'2022-06-02 21:31:02','',''),(2126,'21','221',NULL,3,'Sale Id shift 78',464620.00,0.00,0.00,0.00,0.00,'2022-06-02 21:31:02','',''),(2127,'21','221',NULL,1,'Sale Id shift 78',9073475.40,0.00,0.00,0.00,0.00,'2022-06-02 21:31:02','',''),(2128,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-03 15:18:39','',''),(2129,'21','221',NULL,1,'Reception corrector for bridging 208',0.00,0.00,0.00,50000.00,0.00,'2022-06-03 15:32:33','',''),(2130,'21','221','2',1,'Received from bridging 208',0.00,0.00,50000.00,0.00,0.00,'2022-06-03 15:32:33','',''),(2131,'21','221',NULL,1,'Reception corrector for bridging 207',0.00,0.00,0.00,10000.00,0.00,'2022-06-03 15:32:33','',''),(2132,'21','221','1',1,'Received from bridging 207',0.00,0.00,10000.00,0.00,0.00,'2022-06-03 15:32:33','',''),(2133,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-03 15:33:57','',''),(2134,'21','221',NULL,1,'Reception corrector for bridging 210',0.00,0.00,0.00,55000.00,0.00,'2022-06-03 15:36:17','',''),(2135,'21','221','3',1,'Received from bridging 210',0.00,0.00,55000.00,0.00,0.00,'2022-06-03 15:36:17','',''),(2136,'21','221',NULL,1,'Reception corrector for bridging 209',0.00,0.00,0.00,5000.00,0.00,'2022-06-03 15:36:17','',''),(2137,'21','221','1',1,'Received from bridging 209',0.00,0.00,5000.00,0.00,0.00,'2022-06-03 15:36:17','',''),(2138,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,22800000.00,30000.00,0.00,0.00,'2022-06-03 15:40:37','',''),(2139,'21','221',NULL,2,'Reception corrector for bridging 211',0.00,0.00,0.00,30000.00,0.00,'2022-06-03 15:42:48','',''),(2140,'21','221','4',2,'Received from bridging 211',0.00,0.00,30000.00,0.00,0.00,'2022-06-03 15:42:48','',''),(2141,'21','221','2',1,'Sale Id shift 79',0.00,0.00,0.00,4638.53,0.00,'2022-06-03 16:55:24','',''),(2142,'21','221','2',1,'Sale Id shift 79',0.00,0.00,0.00,3651.40,0.00,'2022-06-03 16:55:24','',''),(2143,'21','221','3',1,'Sale Id shift 79',0.00,0.00,0.00,2211.10,0.00,'2022-06-03 16:55:24','',''),(2144,'21','221','3',1,'Sale Id shift 79',0.00,0.00,0.00,2671.45,0.00,'2022-06-03 16:55:24','',''),(2145,'21','221','3',1,'Sale Id shift 79',0.00,0.00,0.00,2928.49,0.00,'2022-06-03 16:55:24','',''),(2146,'21','221','3',1,'Sale Id shift 79',0.00,0.00,0.00,2353.24,0.00,'2022-06-03 16:55:24','',''),(2147,'21','221','3',1,'Sale Id shift 79',0.00,0.00,0.00,2447.26,0.00,'2022-06-03 16:55:24','',''),(2148,'21','221','3',1,'Sale Id shift 79',0.00,0.00,0.00,3885.52,0.00,'2022-06-03 16:55:24','',''),(2149,'21','221','3',1,'Sale Id shift 79',0.00,0.00,0.00,3039.41,0.00,'2022-06-03 16:55:24','',''),(2150,'21','221','4',2,'Sale Id shift 79',0.00,0.00,0.00,7328.86,0.00,'2022-06-03 16:55:24','',''),(2151,'21','221','4',2,'Sale Id shift 79',0.00,0.00,0.00,10.66,0.00,'2022-06-03 16:55:24','',''),(2152,'21','221','4',2,'Sale Id shift 79',0.00,0.00,0.00,6800.14,0.00,'2022-06-03 16:55:24','',''),(2153,'21','221','5',3,'Sale Id shift 79',0.00,0.00,0.00,207.07,0.00,'2022-06-03 16:55:24','',''),(2154,'21','221','3',1,'Sale Id shift 79',0.00,0.00,0.00,586.39,0.00,'2022-06-03 16:55:24','',''),(2155,'21','221','2',1,'Sale Id shift 79',0.00,0.00,0.00,4411.81,0.00,'2022-06-03 16:55:24','',''),(2156,'21','221','2',1,'Sale Id shift 79',0.00,0.00,0.00,2530.83,0.00,'2022-06-03 16:55:24','',''),(2157,'21','221','2',1,'Sale Id shift 79',0.00,0.00,0.00,1387.72,0.00,'2022-06-03 16:55:24','',''),(2158,'21','221','2',1,'Sale Id shift 79',0.00,0.00,0.00,2506.49,0.00,'2022-06-03 16:55:24','',''),(2159,'21','221',NULL,1,'Sale Id shift 79',6476190.60,0.00,0.00,0.00,0.00,'2022-06-03 16:55:24','',''),(2160,'21','221',NULL,2,'Sale Id shift 79',10746141.60,0.00,0.00,0.00,0.00,'2022-06-03 16:55:24','',''),(2161,'21','221',NULL,3,'Sale Id shift 79',134595.50,0.00,0.00,0.00,0.00,'2022-06-03 16:55:24','',''),(2162,'21','221','2',1,'Sale Id shift 80',0.00,0.00,0.00,5968.11,0.00,'2022-06-03 17:58:22','',''),(2163,'21','221','2',1,'Sale Id shift 80',0.00,0.00,0.00,3525.36,0.00,'2022-06-03 17:58:22','',''),(2164,'21','221','3',1,'Sale Id shift 80',0.00,0.00,0.00,3114.96,0.00,'2022-06-03 17:58:22','',''),(2165,'21','221','3',1,'Sale Id shift 80',0.00,0.00,0.00,2926.28,0.00,'2022-06-03 17:58:22','',''),(2166,'21','221','3',1,'Sale Id shift 80',0.00,0.00,0.00,3313.34,0.00,'2022-06-03 17:58:22','',''),(2167,'21','221','3',1,'Sale Id shift 80',0.00,0.00,0.00,2405.39,0.00,'2022-06-03 17:58:22','',''),(2168,'21','221','3',1,'Sale Id shift 80',0.00,0.00,0.00,3260.40,0.00,'2022-06-03 17:58:22','',''),(2169,'21','221','3',1,'Sale Id shift 80',0.00,0.00,0.00,5266.83,0.00,'2022-06-03 17:58:22','',''),(2170,'21','221','3',1,'Sale Id shift 80',0.00,0.00,0.00,3474.53,0.00,'2022-06-03 17:58:22','',''),(2171,'21','221','4',2,'Sale Id shift 80',0.00,0.00,0.00,11434.34,0.00,'2022-06-03 17:58:22','',''),(2172,'21','221','4',2,'Sale Id shift 80',0.00,0.00,0.00,818.67,0.00,'2022-06-03 17:58:22','',''),(2173,'21','221','4',2,'Sale Id shift 80',0.00,0.00,0.00,1646.87,0.00,'2022-06-03 17:58:22','',''),(2174,'21','221','5',3,'Sale Id shift 80',0.00,0.00,0.00,143.25,0.00,'2022-06-03 17:58:22','',''),(2175,'21','221','3',1,'Sale Id shift 80',0.00,0.00,0.00,1.17,0.00,'2022-06-03 17:58:22','',''),(2176,'21','221','2',1,'Sale Id shift 80',0.00,0.00,0.00,5908.10,0.00,'2022-06-03 17:58:22','',''),(2177,'21','221','2',1,'Sale Id shift 80',0.00,0.00,0.00,3505.27,0.00,'2022-06-03 17:58:22','',''),(2178,'21','221','2',1,'Sale Id shift 80',0.00,0.00,0.00,3522.42,0.00,'2022-06-03 17:58:22','',''),(2179,'21','221','2',1,'Sale Id shift 80',0.00,0.00,0.00,3236.15,0.00,'2022-06-03 17:58:22','',''),(2180,'21','221',NULL,1,'Sale Id shift 80',8155671.15,0.00,0.00,0.00,0.00,'2022-06-03 17:58:22','',''),(2181,'21','221',NULL,2,'Sale Id shift 80',10563908.80,0.00,0.00,0.00,0.00,'2022-06-03 17:58:22','',''),(2182,'21','221',NULL,3,'Sale Id shift 80',93112.50,0.00,0.00,0.00,0.00,'2022-06-03 17:58:22','',''),(2183,'21','221','2',1,'Sale Id shift 81',0.00,0.00,0.00,7584.13,0.00,'2022-06-04 13:42:13','',''),(2184,'21','221','2',1,'Sale Id shift 81',0.00,0.00,0.00,4799.73,0.00,'2022-06-04 13:42:13','',''),(2185,'21','221','3',1,'Sale Id shift 81',0.00,0.00,0.00,3842.01,0.00,'2022-06-04 13:42:13','',''),(2186,'21','221','3',1,'Sale Id shift 81',0.00,0.00,0.00,3402.15,0.00,'2022-06-04 13:42:13','',''),(2187,'21','221','3',1,'Sale Id shift 81',0.00,0.00,0.00,3864.75,0.00,'2022-06-04 13:42:13','',''),(2188,'21','221','3',1,'Sale Id shift 81',0.00,0.00,0.00,3867.17,0.00,'2022-06-04 13:42:13','',''),(2189,'21','221','3',1,'Sale Id shift 81',0.00,0.00,0.00,4441.12,0.00,'2022-06-04 13:42:13','',''),(2190,'21','221','3',1,'Sale Id shift 81',0.00,0.00,0.00,4880.93,0.00,'2022-06-04 13:42:13','',''),(2191,'21','221','3',1,'Sale Id shift 81',0.00,0.00,0.00,4162.88,0.00,'2022-06-04 13:42:13','',''),(2192,'21','221','4',2,'Sale Id shift 81',0.00,0.00,0.00,5616.84,0.00,'2022-06-04 13:42:13','',''),(2193,'21','221','4',2,'Sale Id shift 81',0.00,0.00,0.00,10.73,0.00,'2022-06-04 13:42:13','',''),(2194,'21','221','4',2,'Sale Id shift 81',0.00,0.00,0.00,5183.32,0.00,'2022-06-04 13:42:13','',''),(2195,'21','221','5',3,'Sale Id shift 81',0.00,0.00,0.00,13.73,0.00,'2022-06-04 13:42:13','',''),(2196,'21','221','5',3,'Sale Id shift 81',0.00,0.00,0.00,356.42,0.00,'2022-06-04 13:42:13','',''),(2197,'21','221','3',1,'Sale Id shift 81',0.00,0.00,0.00,3312.81,0.00,'2022-06-04 13:42:13','',''),(2198,'21','221','2',1,'Sale Id shift 81',0.00,0.00,0.00,7175.35,0.00,'2022-06-04 13:42:13','',''),(2199,'21','221','2',1,'Sale Id shift 81',0.00,0.00,0.00,4197.38,0.00,'2022-06-04 13:42:13','',''),(2200,'21','221','2',1,'Sale Id shift 81',0.00,0.00,0.00,2755.44,0.00,'2022-06-04 13:42:13','',''),(2201,'21','221','2',1,'Sale Id shift 81',0.00,0.00,0.00,4444.20,0.00,'2022-06-04 13:42:13','',''),(2202,'21','221',NULL,2,'Sale Id shift 81',8216276.40,0.00,0.00,0.00,0.00,'2022-06-04 13:42:13','',''),(2203,'21','221',NULL,3,'Sale Id shift 81',240597.50,0.00,0.00,0.00,0.00,'2022-06-04 13:42:13','',''),(2204,'21','221',NULL,1,'Sale Id shift 81',10350458.25,0.00,0.00,0.00,0.00,'2022-06-04 13:42:13','',''),(2205,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9240000.00,56000.00,0.00,0.00,'2022-06-04 14:56:30','',''),(2206,'21','221',NULL,1,'Reception corrector for bridging 212',0.00,0.00,0.00,56000.00,0.00,'2022-06-04 14:58:35','',''),(2207,'21','221','2',1,'Received from bridging 212',0.00,0.00,56000.00,0.00,0.00,'2022-06-04 14:58:35','',''),(2208,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,22800000.00,30000.00,0.00,0.00,'2022-06-04 14:58:50','',''),(2209,'21','221',NULL,2,'Reception corrector for bridging 213',0.00,0.00,0.00,30000.00,0.00,'2022-06-04 15:00:17','',''),(2210,'21','221','4',2,'Received from bridging 213',0.00,0.00,30000.00,0.00,0.00,'2022-06-04 15:00:17','',''),(2211,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-04 15:01:33','',''),(2212,'21','221',NULL,1,'Reception corrector for bridging 216',0.00,0.00,0.00,60000.00,0.00,'2022-06-04 15:52:27','',''),(2213,'21','221','3',1,'Received from bridging 216',0.00,0.00,60000.00,0.00,0.00,'2022-06-04 15:52:27','',''),(2214,'21','221','1',1,'Sale Id shift 82',0.00,0.00,0.00,4368.39,0.00,'2022-06-04 16:30:47','',''),(2215,'21','221','2',1,'Sale Id shift 82',0.00,0.00,0.00,5891.05,0.00,'2022-06-04 16:30:47','',''),(2216,'21','221','2',1,'Sale Id shift 82',0.00,0.00,0.00,3361.18,0.00,'2022-06-04 16:30:47','',''),(2217,'21','221','3',1,'Sale Id shift 82',0.00,0.00,0.00,2524.61,0.00,'2022-06-04 16:30:47','',''),(2218,'21','221','3',1,'Sale Id shift 82',0.00,0.00,0.00,3230.73,0.00,'2022-06-04 16:30:47','',''),(2219,'21','221','3',1,'Sale Id shift 82',0.00,0.00,0.00,3164.07,0.00,'2022-06-04 16:30:47','',''),(2220,'21','221','3',1,'Sale Id shift 82',0.00,0.00,0.00,3988.95,0.00,'2022-06-04 16:30:47','',''),(2221,'21','221','3',1,'Sale Id shift 82',0.00,0.00,0.00,3479.73,0.00,'2022-06-04 16:30:47','',''),(2222,'21','221','3',1,'Sale Id shift 82',0.00,0.00,0.00,3670.62,0.00,'2022-06-04 16:30:47','',''),(2223,'21','221','3',1,'Sale Id shift 82',0.00,0.00,0.00,3148.94,0.00,'2022-06-04 16:30:47','',''),(2224,'21','221','1',1,'Sale Id shift 82',0.00,0.00,0.00,2905.95,0.00,'2022-06-04 16:30:47','',''),(2225,'21','221','4',2,'Sale Id shift 82',0.00,0.00,0.00,5105.16,0.00,'2022-06-04 16:30:47','',''),(2226,'21','221','4',2,'Sale Id shift 82',0.00,0.00,0.00,278.77,0.00,'2022-06-04 16:30:47','',''),(2227,'21','221','4',2,'Sale Id shift 82',0.00,0.00,0.00,3688.72,0.00,'2022-06-04 16:30:47','',''),(2228,'21','221','5',3,'Sale Id shift 82',0.00,0.00,0.00,1099.35,0.00,'2022-06-04 16:30:47','',''),(2229,'21','221','3',1,'Sale Id shift 82',0.00,0.00,0.00,4782.67,0.00,'2022-06-04 16:30:47','',''),(2230,'21','221','1',1,'Sale Id shift 82',0.00,0.00,0.00,4241.34,0.00,'2022-06-04 16:30:47','',''),(2231,'21','221','1',1,'Sale Id shift 82',0.00,0.00,0.00,2587.96,0.00,'2022-06-04 16:30:47','',''),(2232,'21','221','2',1,'Sale Id shift 82',0.00,0.00,0.00,4675.67,0.00,'2022-06-04 16:30:47','',''),(2233,'21','221','2',1,'Sale Id shift 82',0.00,0.00,0.00,2760.92,0.00,'2022-06-04 16:30:47','',''),(2234,'21','221','2',1,'Sale Id shift 82',0.00,0.00,0.00,2138.26,0.00,'2022-06-04 16:30:47','',''),(2235,'21','221','2',1,'Sale Id shift 82',0.00,0.00,0.00,2488.65,0.00,'2022-06-04 16:30:47','',''),(2236,'21','221',NULL,1,'Sale Id shift 82',10462598.85,0.00,0.00,0.00,0.00,'2022-06-04 16:30:47','',''),(2237,'21','221',NULL,2,'Sale Id shift 82',6895214.00,0.00,0.00,0.00,0.00,'2022-06-04 16:30:47','',''),(2238,'21','221',NULL,3,'Sale Id shift 82',714577.50,0.00,0.00,0.00,0.00,'2022-06-04 16:30:47','',''),(2239,'21','221','1',1,'Sale Id shift 83',0.00,0.00,0.00,4316.32,0.00,'2022-06-06 16:45:46','',''),(2240,'21','221','2',1,'Sale Id shift 83',0.00,0.00,0.00,7204.23,0.00,'2022-06-06 16:45:46','',''),(2241,'21','221','2',1,'Sale Id shift 83',0.00,0.00,0.00,3009.87,0.00,'2022-06-06 16:45:46','',''),(2242,'21','221','3',1,'Sale Id shift 83',0.00,0.00,0.00,2148.79,0.00,'2022-06-06 16:45:46','',''),(2243,'21','221','3',1,'Sale Id shift 83',0.00,0.00,0.00,2790.94,0.00,'2022-06-06 16:45:46','',''),(2244,'21','221','3',1,'Sale Id shift 83',0.00,0.00,0.00,2637.11,0.00,'2022-06-06 16:45:46','',''),(2245,'21','221','3',1,'Sale Id shift 83',0.00,0.00,0.00,2611.72,0.00,'2022-06-06 16:45:46','',''),(2246,'21','221','3',1,'Sale Id shift 83',0.00,0.00,0.00,2441.59,0.00,'2022-06-06 16:45:46','',''),(2247,'21','221','3',1,'Sale Id shift 83',0.00,0.00,0.00,3397.34,0.00,'2022-06-06 16:45:46','',''),(2248,'21','221','3',1,'Sale Id shift 83',0.00,0.00,0.00,2277.48,0.00,'2022-06-06 16:45:46','',''),(2249,'21','221','1',1,'Sale Id shift 83',0.00,0.00,0.00,2139.46,0.00,'2022-06-06 16:45:46','',''),(2250,'21','221','4',2,'Sale Id shift 83',0.00,0.00,0.00,6349.14,0.00,'2022-06-06 16:45:46','',''),(2251,'21','221','4',2,'Sale Id shift 83',0.00,0.00,0.00,704.68,0.00,'2022-06-06 16:45:46','',''),(2252,'21','221','4',2,'Sale Id shift 83',0.00,0.00,0.00,8725.33,0.00,'2022-06-06 16:45:46','',''),(2253,'21','221','5',3,'Sale Id shift 83',0.00,0.00,0.00,1084.47,0.00,'2022-06-06 16:45:46','',''),(2254,'21','221','3',1,'Sale Id shift 83',0.00,0.00,0.00,3030.10,0.00,'2022-06-06 16:45:46','',''),(2255,'21','221','1',1,'Sale Id shift 83',0.00,0.00,0.00,2484.06,0.00,'2022-06-06 16:45:46','',''),(2256,'21','221','1',1,'Sale Id shift 83',0.00,0.00,0.00,3942.76,0.00,'2022-06-06 16:45:46','',''),(2257,'21','221','2',1,'Sale Id shift 83',0.00,0.00,0.00,5394.23,0.00,'2022-06-06 16:45:46','',''),(2258,'21','221','2',1,'Sale Id shift 83',0.00,0.00,0.00,2979.34,0.00,'2022-06-06 16:45:46','',''),(2259,'21','221','2',1,'Sale Id shift 83',0.00,0.00,0.00,4195.62,0.00,'2022-06-06 16:45:46','',''),(2260,'21','221','2',1,'Sale Id shift 83',0.00,0.00,0.00,3577.36,0.00,'2022-06-06 16:45:46','',''),(2261,'21','221',NULL,1,'Sale Id shift 83',9995422.80,0.00,0.00,0.00,0.00,'2022-06-06 16:45:46','',''),(2262,'21','221',NULL,2,'Sale Id shift 83',11992154.00,0.00,0.00,0.00,0.00,'2022-06-06 16:45:46','',''),(2263,'21','221',NULL,3,'Sale Id shift 83',704905.50,0.00,0.00,0.00,0.00,'2022-06-06 16:45:46','',''),(2264,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-08 14:12:10','',''),(2265,'21','221',NULL,1,'Reception corrector for bridging 217',0.00,0.00,0.00,60000.00,0.00,'2022-06-08 14:16:43','',''),(2266,'21','221','3',1,'Received from bridging 217',0.00,0.00,60000.00,0.00,0.00,'2022-06-08 14:16:43','',''),(2267,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-08 14:17:01','',''),(2268,'21','221',NULL,1,'Reception corrector for bridging 218',0.00,0.00,0.00,60000.00,0.00,'2022-06-08 14:19:14','',''),(2269,'21','221','2',1,'Received from bridging 218',0.00,0.00,60000.00,0.00,0.00,'2022-06-08 14:19:14','',''),(2270,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11400000.00,15000.00,0.00,0.00,'2022-06-08 14:19:28','',''),(2271,'21','221',NULL,2,'Reception corrector for bridging 219',0.00,0.00,0.00,15000.00,0.00,'2022-06-08 14:21:27','',''),(2272,'21','221','4',2,'Received from bridging 219',0.00,0.00,15000.00,0.00,0.00,'2022-06-08 14:21:27','',''),(2273,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-08 15:42:19','',''),(2274,'21','221',NULL,1,'Reception corrector for bridging 222',0.00,0.00,0.00,5000.00,0.00,'2022-06-08 15:46:28','',''),(2275,'21','221','3',1,'Received from bridging 222',0.00,0.00,5000.00,0.00,0.00,'2022-06-08 15:46:28','',''),(2276,'21','221',NULL,1,'Reception corrector for bridging 221',0.00,0.00,0.00,12000.00,0.00,'2022-06-08 15:46:28','',''),(2277,'21','221','2',1,'Received from bridging 221',0.00,0.00,12000.00,0.00,0.00,'2022-06-08 15:46:28','',''),(2278,'21','221',NULL,1,'Reception corrector for bridging 220',0.00,0.00,0.00,30000.00,0.00,'2022-06-08 15:46:28','',''),(2279,'21','221','1',1,'Received from bridging 220',0.00,0.00,30000.00,0.00,0.00,'2022-06-08 15:46:28','',''),(2280,'21','221','1',1,'Sale Id shift 84',0.00,0.00,0.00,3761.84,0.00,'2022-06-08 16:59:04','',''),(2281,'21','221','2',1,'Sale Id shift 84',0.00,0.00,0.00,6018.15,0.00,'2022-06-08 16:59:04','',''),(2282,'21','221','2',1,'Sale Id shift 84',0.00,0.00,0.00,3105.02,0.00,'2022-06-08 16:59:04','',''),(2283,'21','221','3',1,'Sale Id shift 84',0.00,0.00,0.00,3121.78,0.00,'2022-06-08 16:59:04','',''),(2284,'21','221','3',1,'Sale Id shift 84',0.00,0.00,0.00,2509.87,0.00,'2022-06-08 16:59:04','',''),(2285,'21','221','3',1,'Sale Id shift 84',0.00,0.00,0.00,2183.09,0.00,'2022-06-08 16:59:04','',''),(2286,'21','221','3',1,'Sale Id shift 84',0.00,0.00,0.00,1901.91,0.00,'2022-06-08 16:59:04','',''),(2287,'21','221','3',1,'Sale Id shift 84',0.00,0.00,0.00,2674.01,0.00,'2022-06-08 16:59:04','',''),(2288,'21','221','3',1,'Sale Id shift 84',0.00,0.00,0.00,3084.31,0.00,'2022-06-08 16:59:04','',''),(2289,'21','221','3',1,'Sale Id shift 84',0.00,0.00,0.00,2862.21,0.00,'2022-06-08 16:59:04','',''),(2290,'21','221','1',1,'Sale Id shift 84',0.00,0.00,0.00,3547.51,0.00,'2022-06-08 16:59:04','',''),(2291,'21','221','4',2,'Sale Id shift 84',0.00,0.00,0.00,5579.33,0.00,'2022-06-08 16:59:04','',''),(2292,'21','221','4',2,'Sale Id shift 84',0.00,0.00,0.00,1151.75,0.00,'2022-06-08 16:59:04','',''),(2293,'21','221','4',2,'Sale Id shift 84',0.00,0.00,0.00,6158.31,0.00,'2022-06-08 16:59:04','',''),(2294,'21','221','5',3,'Sale Id shift 84',0.00,0.00,0.00,1236.94,0.00,'2022-06-08 16:59:04','',''),(2295,'21','221','3',1,'Sale Id shift 84',0.00,0.00,0.00,5290.71,0.00,'2022-06-08 16:59:04','',''),(2296,'21','221','1',1,'Sale Id shift 84',0.00,0.00,0.00,3242.53,0.00,'2022-06-08 16:59:04','',''),(2297,'21','221','1',1,'Sale Id shift 84',0.00,0.00,0.00,3642.94,0.00,'2022-06-08 16:59:04','',''),(2298,'21','221','2',1,'Sale Id shift 84',0.00,0.00,0.00,3947.33,0.00,'2022-06-08 16:59:04','',''),(2299,'21','221','2',1,'Sale Id shift 84',0.00,0.00,0.00,2610.98,0.00,'2022-06-08 16:59:04','',''),(2300,'21','221','2',1,'Sale Id shift 84',0.00,0.00,0.00,3251.48,0.00,'2022-06-08 16:59:04','',''),(2301,'21','221','2',1,'Sale Id shift 84',0.00,0.00,0.00,3307.90,0.00,'2022-06-08 16:59:04','',''),(2302,'21','221',NULL,1,'Sale Id shift 84',9910489.05,0.00,0.00,0.00,0.00,'2022-06-08 16:59:04','',''),(2303,'21','221',NULL,2,'Sale Id shift 84',9795936.40,0.00,0.00,0.00,0.00,'2022-06-08 16:59:04','',''),(2304,'21','221',NULL,3,'Sale Id shift 84',804011.00,0.00,0.00,0.00,0.00,'2022-06-08 16:59:04','',''),(2305,'21','221',NULL,1,'Reception corrector for bridging 223',0.00,0.00,0.00,13000.00,0.00,'2022-06-08 17:09:23','',''),(2306,'21','221','1',1,'Received from bridging 223',0.00,0.00,13000.00,0.00,0.00,'2022-06-08 17:09:23','',''),(2307,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,22800000.00,30000.00,0.00,0.00,'2022-06-08 17:13:57','',''),(2308,'21','221',NULL,2,'Reception corrector for bridging 224',0.00,0.00,0.00,30000.00,0.00,'2022-06-08 17:17:02','',''),(2309,'21','221','4',2,'Received from bridging 224',0.00,0.00,30000.00,0.00,0.00,'2022-06-08 17:17:02','',''),(2310,'21','221','1',1,'Sale Id shift 85',0.00,0.00,0.00,5295.23,0.00,'2022-06-08 18:37:26','',''),(2311,'21','221','2',1,'Sale Id shift 85',0.00,0.00,0.00,6705.49,0.00,'2022-06-08 18:37:26','',''),(2312,'21','221','2',1,'Sale Id shift 85',0.00,0.00,0.00,6239.42,0.00,'2022-06-08 18:37:26','',''),(2313,'21','221','3',1,'Sale Id shift 85',0.00,0.00,0.00,2754.75,0.00,'2022-06-08 18:37:26','',''),(2314,'21','221','3',1,'Sale Id shift 85',0.00,0.00,0.00,3245.86,0.00,'2022-06-08 18:37:26','',''),(2315,'21','221','3',1,'Sale Id shift 85',0.00,0.00,0.00,2511.45,0.00,'2022-06-08 18:37:26','',''),(2316,'21','221','3',1,'Sale Id shift 85',0.00,0.00,0.00,3554.05,0.00,'2022-06-08 18:37:26','',''),(2317,'21','221','3',1,'Sale Id shift 85',0.00,0.00,0.00,4086.37,0.00,'2022-06-08 18:37:26','',''),(2318,'21','221','3',1,'Sale Id shift 85',0.00,0.00,0.00,5077.30,0.00,'2022-06-08 18:37:26','',''),(2319,'21','221','3',1,'Sale Id shift 85',0.00,0.00,0.00,3239.61,0.00,'2022-06-08 18:37:26','',''),(2320,'21','221','1',1,'Sale Id shift 85',0.00,0.00,0.00,6127.29,0.00,'2022-06-08 18:37:26','',''),(2321,'21','221','4',2,'Sale Id shift 85',0.00,0.00,0.00,8841.01,0.00,'2022-06-08 18:37:26','',''),(2322,'21','221','4',2,'Sale Id shift 85',0.00,0.00,0.00,8425.84,0.00,'2022-06-08 18:37:26','',''),(2323,'21','221','5',3,'Sale Id shift 85',0.00,0.00,0.00,1814.54,0.00,'2022-06-08 18:37:26','',''),(2324,'21','221','3',1,'Sale Id shift 85',0.00,0.00,0.00,6224.77,0.00,'2022-06-08 18:37:26','',''),(2325,'21','221','1',1,'Sale Id shift 85',0.00,0.00,0.00,4436.38,0.00,'2022-06-08 18:37:26','',''),(2326,'21','221','1',1,'Sale Id shift 85',0.00,0.00,0.00,6326.11,0.00,'2022-06-08 18:37:26','',''),(2327,'21','221','2',1,'Sale Id shift 85',0.00,0.00,0.00,6335.23,0.00,'2022-06-08 18:37:26','',''),(2328,'21','221','2',1,'Sale Id shift 85',0.00,0.00,0.00,4660.88,0.00,'2022-06-08 18:37:26','',''),(2329,'21','221','2',1,'Sale Id shift 85',0.00,0.00,0.00,5156.54,0.00,'2022-06-08 18:37:26','',''),(2330,'21','221','2',1,'Sale Id shift 85',0.00,0.00,0.00,3779.78,0.00,'2022-06-08 18:37:26','',''),(2331,'21','221',NULL,1,'Sale Id shift 85',14149824.15,0.00,0.00,0.00,0.00,'2022-06-08 18:37:26','',''),(2332,'21','221',NULL,2,'Sale Id shift 85',13122806.00,0.00,0.00,0.00,0.00,'2022-06-08 18:37:26','',''),(2333,'21','221',NULL,3,'Sale Id shift 85',1179451.00,0.00,0.00,0.00,0.00,'2022-06-08 18:37:26','',''),(2334,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-09 15:22:44','',''),(2335,'21','221',NULL,1,'Reception corrector for bridging 226',0.00,0.00,0.00,40000.00,0.00,'2022-06-09 15:25:27','',''),(2336,'21','221','3',1,'Received from bridging 226',0.00,0.00,40000.00,0.00,0.00,'2022-06-09 15:25:27','',''),(2337,'21','221',NULL,1,'Reception corrector for bridging 225',0.00,0.00,0.00,10000.00,0.00,'2022-06-09 15:25:27','',''),(2338,'21','221','1',1,'Received from bridging 225',0.00,0.00,10000.00,0.00,0.00,'2022-06-09 15:25:27','',''),(2339,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-09 15:25:48','',''),(2340,'21','221',NULL,1,'Reception corrector for bridging 228',0.00,0.00,0.00,10000.00,0.00,'2022-06-09 15:28:46','',''),(2341,'21','221','3',1,'Received from bridging 228',0.00,0.00,10000.00,0.00,0.00,'2022-06-09 15:28:46','',''),(2342,'21','221',NULL,1,'Reception corrector for bridging 227',0.00,0.00,0.00,50000.00,0.00,'2022-06-09 15:28:46','',''),(2343,'21','221','2',1,'Received from bridging 227',0.00,0.00,50000.00,0.00,0.00,'2022-06-09 15:28:46','',''),(2344,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,35100000.00,45000.00,0.00,0.00,'2022-06-09 15:29:10','',''),(2345,'21','221',NULL,2,'Reception corrector for bridging 229',0.00,0.00,0.00,20000.00,0.00,'2022-06-09 15:33:59','',''),(2346,'21','221','4',2,'Received from bridging 229',0.00,0.00,20000.00,0.00,0.00,'2022-06-09 15:33:59','',''),(2347,'21','221','1',1,'Sale Id shift 86',0.00,0.00,0.00,1329.90,0.00,'2022-06-10 19:39:03','',''),(2348,'21','221','2',1,'Sale Id shift 86',0.00,0.00,0.00,6197.02,0.00,'2022-06-10 19:39:03','',''),(2349,'21','221','2',1,'Sale Id shift 86',0.00,0.00,0.00,3267.23,0.00,'2022-06-10 19:39:03','',''),(2350,'21','221','3',1,'Sale Id shift 86',0.00,0.00,0.00,2604.98,0.00,'2022-06-10 19:39:03','',''),(2351,'21','221','3',1,'Sale Id shift 86',0.00,0.00,0.00,2093.76,0.00,'2022-06-10 19:39:03','',''),(2352,'21','221','3',1,'Sale Id shift 86',0.00,0.00,0.00,2776.17,0.00,'2022-06-10 19:39:03','',''),(2353,'21','221','3',1,'Sale Id shift 86',0.00,0.00,0.00,2923.65,0.00,'2022-06-10 19:39:03','',''),(2354,'21','221','3',1,'Sale Id shift 86',0.00,0.00,0.00,2777.58,0.00,'2022-06-10 19:39:03','',''),(2355,'21','221','3',1,'Sale Id shift 86',0.00,0.00,0.00,4219.75,0.00,'2022-06-10 19:39:03','',''),(2356,'21','221','3',1,'Sale Id shift 86',0.00,0.00,0.00,2549.19,0.00,'2022-06-10 19:39:03','',''),(2357,'21','221','1',1,'Sale Id shift 86',0.00,0.00,0.00,1562.11,0.00,'2022-06-10 19:39:03','',''),(2358,'21','221','4',2,'Sale Id shift 86',0.00,0.00,0.00,4787.59,0.00,'2022-06-10 19:39:03','',''),(2359,'21','221','4',2,'Sale Id shift 86',0.00,0.00,0.00,277.13,0.00,'2022-06-10 19:39:03','',''),(2360,'21','221','4',2,'Sale Id shift 86',0.00,0.00,0.00,4385.99,0.00,'2022-06-10 19:39:03','',''),(2361,'21','221','5',3,'Sale Id shift 86',0.00,0.00,0.00,30.54,0.00,'2022-06-10 19:39:03','',''),(2362,'21','221','5',3,'Sale Id shift 86',0.00,0.00,0.00,1604.05,0.00,'2022-06-10 19:39:03','',''),(2363,'21','221','3',1,'Sale Id shift 86',0.00,0.00,0.00,4230.12,0.00,'2022-06-10 19:39:03','',''),(2364,'21','221','1',1,'Sale Id shift 86',0.00,0.00,0.00,1708.07,0.00,'2022-06-10 19:39:03','',''),(2365,'21','221','1',1,'Sale Id shift 86',0.00,0.00,0.00,1919.04,0.00,'2022-06-10 19:39:03','',''),(2366,'21','221','2',1,'Sale Id shift 86',0.00,0.00,0.00,5188.93,0.00,'2022-06-10 19:39:03','',''),(2367,'21','221','2',1,'Sale Id shift 86',0.00,0.00,0.00,2892.40,0.00,'2022-06-10 19:39:03','',''),(2368,'21','221','2',1,'Sale Id shift 86',0.00,0.00,0.00,3325.65,0.00,'2022-06-10 19:39:03','',''),(2369,'21','221','2',1,'Sale Id shift 86',0.00,0.00,0.00,3086.77,0.00,'2022-06-10 19:39:03','',''),(2370,'21','221',NULL,1,'Sale Id shift 86',9017632.80,0.00,0.00,0.00,0.00,'2022-06-10 19:39:03','',''),(2371,'21','221',NULL,2,'Sale Id shift 86',7371553.80,0.00,0.00,0.00,0.00,'2022-06-10 19:39:03','',''),(2372,'21','221',NULL,3,'Sale Id shift 86',1062483.50,0.00,0.00,0.00,0.00,'2022-06-10 19:39:03','',''),(2373,'21','221','4',2,'Sale Id shift 87',0.00,0.00,0.00,4224.08,0.00,'2022-06-11 13:51:19','',''),(2374,'21','221','4',2,'Sale Id shift 87',0.00,0.00,0.00,164.78,0.00,'2022-06-11 13:51:19','',''),(2375,'21','221','4',2,'Sale Id shift 87',0.00,0.00,0.00,4041.39,0.00,'2022-06-11 13:51:19','',''),(2376,'21','221',NULL,2,'Sale Id shift 87',6575595.00,0.00,0.00,0.00,0.00,'2022-06-11 13:51:19','',''),(2377,'21','221','2',1,'Sale Id shift 88',0.00,0.00,0.00,2630.50,0.00,'2022-06-11 15:12:17','',''),(2378,'21','221','2',1,'Sale Id shift 88',0.00,0.00,0.00,1708.54,0.00,'2022-06-11 15:12:17','',''),(2379,'21','221','3',1,'Sale Id shift 88',0.00,0.00,0.00,860.92,0.00,'2022-06-11 15:12:17','',''),(2380,'21','221','3',1,'Sale Id shift 88',0.00,0.00,0.00,1085.06,0.00,'2022-06-11 15:12:17','',''),(2381,'21','221','3',1,'Sale Id shift 88',0.00,0.00,0.00,1243.47,0.00,'2022-06-11 15:12:17','',''),(2382,'21','221','3',1,'Sale Id shift 88',0.00,0.00,0.00,1652.31,0.00,'2022-06-11 15:12:17','',''),(2383,'21','221','3',1,'Sale Id shift 88',0.00,0.00,0.00,1054.57,0.00,'2022-06-11 15:12:17','',''),(2384,'21','221','3',1,'Sale Id shift 88',0.00,0.00,0.00,2144.21,0.00,'2022-06-11 15:12:17','',''),(2385,'21','221','3',1,'Sale Id shift 88',0.00,0.00,0.00,894.17,0.00,'2022-06-11 15:12:17','',''),(2386,'21','221','1',1,'Sale Id shift 88',0.00,0.00,0.00,1715.18,0.00,'2022-06-11 15:12:17','',''),(2387,'21','221','4',2,'Sale Id shift 88',0.00,0.00,0.00,6826.85,0.00,'2022-06-11 15:12:17','',''),(2388,'21','221','4',2,'Sale Id shift 88',0.00,0.00,0.00,11187.04,0.00,'2022-06-11 15:12:17','',''),(2389,'21','221','5',3,'Sale Id shift 88',0.00,0.00,0.00,852.83,0.00,'2022-06-11 15:12:17','',''),(2390,'21','221','3',1,'Sale Id shift 88',0.00,0.00,0.00,3606.11,0.00,'2022-06-11 15:12:17','',''),(2391,'21','221','1',1,'Sale Id shift 88',0.00,0.00,0.00,1453.75,0.00,'2022-06-11 15:12:17','',''),(2392,'21','221','1',1,'Sale Id shift 88',0.00,0.00,0.00,3213.20,0.00,'2022-06-11 15:12:17','',''),(2393,'21','221','2',1,'Sale Id shift 88',0.00,0.00,0.00,2668.03,0.00,'2022-06-11 15:12:17','',''),(2394,'21','221','2',1,'Sale Id shift 88',0.00,0.00,0.00,927.54,0.00,'2022-06-11 15:12:17','',''),(2395,'21','221','2',1,'Sale Id shift 88',0.00,0.00,0.00,1076.96,0.00,'2022-06-11 15:12:17','',''),(2396,'21','221','2',1,'Sale Id shift 88',0.00,0.00,0.00,1734.86,0.00,'2022-06-11 15:12:17','',''),(2397,'21','221',NULL,1,'Sale Id shift 88',4895447.70,0.00,0.00,0.00,0.00,'2022-06-11 15:12:17','',''),(2398,'21','221',NULL,2,'Sale Id shift 88',14050834.20,0.00,0.00,0.00,0.00,'2022-06-11 15:12:17','',''),(2399,'21','221',NULL,3,'Sale Id shift 88',554339.50,0.00,0.00,0.00,0.00,'2022-06-11 15:12:17','',''),(2400,'21','221',NULL,2,'Reception corrector for bridging 230',0.00,0.00,0.00,25000.00,0.00,'2022-06-11 15:32:53','',''),(2401,'21','221','4',2,'Received from bridging 230',0.00,0.00,25000.00,0.00,0.00,'2022-06-11 15:32:53','',''),(2402,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-11 15:37:47','',''),(2403,'21','221',NULL,1,'Reception corrector for bridging 232',0.00,0.00,0.00,35000.00,0.00,'2022-06-11 15:40:53','',''),(2404,'21','221','2',1,'Received from bridging 232',0.00,0.00,35000.00,0.00,0.00,'2022-06-11 15:40:53','',''),(2405,'21','221',NULL,1,'Reception corrector for bridging 231',0.00,0.00,0.00,10000.00,0.00,'2022-06-11 15:40:53','',''),(2406,'21','221','1',1,'Received from bridging 231',0.00,0.00,10000.00,0.00,0.00,'2022-06-11 15:40:53','',''),(2407,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-11 15:41:12','',''),(2408,'21','221',NULL,1,'Reception corrector for bridging 234',0.00,0.00,0.00,35000.00,0.00,'2022-06-11 15:43:47','',''),(2409,'21','221','3',1,'Received from bridging 234',0.00,0.00,35000.00,0.00,0.00,'2022-06-11 15:43:47','',''),(2410,'21','221',NULL,1,'Reception corrector for bridging 233',0.00,0.00,0.00,10000.00,0.00,'2022-06-11 15:43:47','',''),(2411,'21','221','1',1,'Received from bridging 233',0.00,0.00,10000.00,0.00,0.00,'2022-06-11 15:43:47','',''),(2412,'21','221','1',1,'Sale Id shift 89',0.00,0.00,0.00,2393.70,0.00,'2022-06-13 10:51:20','',''),(2413,'21','221','2',1,'Sale Id shift 89',0.00,0.00,0.00,5343.62,0.00,'2022-06-13 10:51:20','',''),(2414,'21','221','2',1,'Sale Id shift 89',0.00,0.00,0.00,3494.50,0.00,'2022-06-13 10:51:20','',''),(2415,'21','221','3',1,'Sale Id shift 89',0.00,0.00,0.00,3642.93,0.00,'2022-06-13 10:51:20','',''),(2416,'21','221','3',1,'Sale Id shift 89',0.00,0.00,0.00,3190.72,0.00,'2022-06-13 10:51:20','',''),(2417,'21','221','3',1,'Sale Id shift 89',0.00,0.00,0.00,3349.73,0.00,'2022-06-13 10:51:20','',''),(2418,'21','221','3',1,'Sale Id shift 89',0.00,0.00,0.00,3153.62,0.00,'2022-06-13 10:51:20','',''),(2419,'21','221','3',1,'Sale Id shift 89',0.00,0.00,0.00,3270.60,0.00,'2022-06-13 10:51:20','',''),(2420,'21','221','3',1,'Sale Id shift 89',0.00,0.00,0.00,3689.16,0.00,'2022-06-13 10:51:20','',''),(2421,'21','221','3',1,'Sale Id shift 89',0.00,0.00,0.00,3384.52,0.00,'2022-06-13 10:51:20','',''),(2422,'21','221','1',1,'Sale Id shift 89',0.00,0.00,0.00,1929.83,0.00,'2022-06-13 10:51:20','',''),(2423,'21','221','4',2,'Sale Id shift 89',0.00,0.00,0.00,8948.20,0.00,'2022-06-13 10:51:20','',''),(2424,'21','221','4',2,'Sale Id shift 89',0.00,0.00,0.00,2068.16,0.00,'2022-06-13 10:51:20','',''),(2425,'21','221','4',2,'Sale Id shift 89',0.00,0.00,0.00,4631.23,0.00,'2022-06-13 10:51:20','',''),(2426,'21','221','5',3,'Sale Id shift 89',0.00,0.00,0.00,2350.77,0.00,'2022-06-13 10:51:20','',''),(2427,'21','221','3',1,'Sale Id shift 89',0.00,0.00,0.00,6200.23,0.00,'2022-06-13 10:51:20','',''),(2428,'21','221','1',1,'Sale Id shift 89',0.00,0.00,0.00,2455.37,0.00,'2022-06-13 10:51:20','',''),(2429,'21','221','1',1,'Sale Id shift 89',0.00,0.00,0.00,2618.98,0.00,'2022-06-13 10:51:20','',''),(2430,'21','221','2',1,'Sale Id shift 89',0.00,0.00,0.00,4429.53,0.00,'2022-06-13 10:51:20','',''),(2431,'21','221','2',1,'Sale Id shift 89',0.00,0.00,0.00,2351.10,0.00,'2022-06-13 10:51:20','',''),(2432,'21','221','2',1,'Sale Id shift 89',0.00,0.00,0.00,2793.18,0.00,'2022-06-13 10:51:20','',''),(2433,'21','221','2',1,'Sale Id shift 89',0.00,0.00,0.00,3615.59,0.00,'2022-06-13 10:51:20','',''),(2434,'21','221',NULL,1,'Sale Id shift 89',10115640.15,0.00,0.00,0.00,0.00,'2022-06-13 10:51:20','',''),(2435,'21','221',NULL,2,'Sale Id shift 89',12205120.20,0.00,0.00,0.00,0.00,'2022-06-13 10:51:20','',''),(2436,'21','221',NULL,3,'Sale Id shift 89',1528000.50,0.00,0.00,0.00,0.00,'2022-06-13 10:51:20','',''),(2437,'21','221','1',1,'Sale Id shift 90',0.00,0.00,0.00,5011.74,0.00,'2022-06-13 20:05:45','',''),(2438,'21','221','2',1,'Sale Id shift 90',0.00,0.00,0.00,7839.87,0.00,'2022-06-13 20:05:45','',''),(2439,'21','221','2',1,'Sale Id shift 90',0.00,0.00,0.00,5798.97,0.00,'2022-06-13 20:05:45','',''),(2440,'21','221','3',1,'Sale Id shift 90',0.00,0.00,0.00,4973.63,0.00,'2022-06-13 20:05:45','',''),(2441,'21','221','3',1,'Sale Id shift 90',0.00,0.00,0.00,4150.86,0.00,'2022-06-13 20:05:45','',''),(2442,'21','221','3',1,'Sale Id shift 90',0.00,0.00,0.00,3702.85,0.00,'2022-06-13 20:05:45','',''),(2443,'21','221','3',1,'Sale Id shift 90',0.00,0.00,0.00,3946.58,0.00,'2022-06-13 20:05:45','',''),(2444,'21','221','3',1,'Sale Id shift 90',0.00,0.00,0.00,4251.49,0.00,'2022-06-13 20:05:45','',''),(2445,'21','221','3',1,'Sale Id shift 90',0.00,0.00,0.00,4079.11,0.00,'2022-06-13 20:05:45','',''),(2446,'21','221','3',1,'Sale Id shift 90',0.00,0.00,0.00,4150.26,0.00,'2022-06-13 20:05:45','',''),(2447,'21','221','1',1,'Sale Id shift 90',0.00,0.00,0.00,4841.58,0.00,'2022-06-13 20:05:45','',''),(2448,'21','221','4',2,'Sale Id shift 90',0.00,0.00,0.00,7611.25,0.00,'2022-06-13 20:05:45','',''),(2449,'21','221','4',2,'Sale Id shift 90',0.00,0.00,0.00,2394.22,0.00,'2022-06-13 20:05:45','',''),(2450,'21','221','4',2,'Sale Id shift 90',0.00,0.00,0.00,6372.89,0.00,'2022-06-13 20:05:45','',''),(2451,'21','221','5',3,'Sale Id shift 90',0.00,0.00,0.00,1403.67,0.00,'2022-06-13 20:05:45','',''),(2452,'21','221','3',1,'Sale Id shift 90',0.00,0.00,0.00,6230.22,0.00,'2022-06-13 20:05:45','',''),(2453,'21','221','1',1,'Sale Id shift 90',0.00,0.00,0.00,4270.03,0.00,'2022-06-13 20:05:45','',''),(2454,'21','221','1',1,'Sale Id shift 90',0.00,0.00,0.00,4938.14,0.00,'2022-06-13 20:05:45','',''),(2455,'21','221','2',1,'Sale Id shift 90',0.00,0.00,0.00,6710.90,0.00,'2022-06-13 20:05:45','',''),(2456,'21','221','2',1,'Sale Id shift 90',0.00,0.00,0.00,2552.91,0.00,'2022-06-13 20:05:45','',''),(2457,'21','221','2',1,'Sale Id shift 90',0.00,0.00,0.00,6018.57,0.00,'2022-06-13 20:05:45','',''),(2458,'21','221','2',1,'Sale Id shift 90',0.00,0.00,0.00,5548.28,0.00,'2022-06-13 20:05:45','',''),(2459,'21','221',NULL,1,'Sale Id shift 90',14687638.35,0.00,0.00,0.00,0.00,'2022-06-13 20:05:45','',''),(2460,'21','221',NULL,2,'Sale Id shift 90',12775120.80,0.00,0.00,0.00,0.00,'2022-06-13 20:05:45','',''),(2461,'21','221',NULL,3,'Sale Id shift 90',912385.50,0.00,0.00,0.00,0.00,'2022-06-13 20:05:45','',''),(2462,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-14 14:41:13','',''),(2463,'21','221',NULL,1,'Reception corrector for bridging 236',0.00,0.00,0.00,50000.00,0.00,'2022-06-14 14:43:26','',''),(2464,'21','221','2',1,'Received from bridging 236',0.00,0.00,50000.00,0.00,0.00,'2022-06-14 14:43:26','',''),(2465,'21','221',NULL,1,'Reception corrector for bridging 235',0.00,0.00,0.00,10000.00,0.00,'2022-06-14 14:43:26','',''),(2466,'21','221','1',1,'Received from bridging 235',0.00,0.00,10000.00,0.00,0.00,'2022-06-14 14:43:26','',''),(2467,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-14 14:43:51','',''),(2468,'21','221',NULL,1,'Reception corrector for bridging 238',0.00,0.00,0.00,50000.00,0.00,'2022-06-14 14:46:12','',''),(2469,'21','221','3',1,'Received from bridging 238',0.00,0.00,50000.00,0.00,0.00,'2022-06-14 14:46:12','',''),(2470,'21','221',NULL,1,'Reception corrector for bridging 237',0.00,0.00,0.00,10000.00,0.00,'2022-06-14 14:46:12','',''),(2471,'21','221','1',1,'Received from bridging 237',0.00,0.00,10000.00,0.00,0.00,'2022-06-14 14:46:12','',''),(2472,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,18400000.00,23000.00,0.00,0.00,'2022-06-14 17:02:41','',''),(2473,'21','221',NULL,2,'Reception corrector for bridging 239',0.00,0.00,0.00,23000.00,0.00,'2022-06-14 17:05:25','',''),(2474,'21','221','4',2,'Received from bridging 239',0.00,0.00,23000.00,0.00,0.00,'2022-06-14 17:05:25','',''),(2475,'21','221','1',1,'Sale Id shift 91',0.00,0.00,0.00,4791.99,0.00,'2022-06-14 17:49:56','',''),(2476,'21','221','2',1,'Sale Id shift 91',0.00,0.00,0.00,8664.95,0.00,'2022-06-14 17:49:56','',''),(2477,'21','221','2',1,'Sale Id shift 91',0.00,0.00,0.00,5734.20,0.00,'2022-06-14 17:49:56','',''),(2478,'21','221','3',1,'Sale Id shift 91',0.00,0.00,0.00,4346.75,0.00,'2022-06-14 17:49:56','',''),(2479,'21','221','3',1,'Sale Id shift 91',0.00,0.00,0.00,3819.28,0.00,'2022-06-14 17:49:56','',''),(2480,'21','221','3',1,'Sale Id shift 91',0.00,0.00,0.00,4147.86,0.00,'2022-06-14 17:49:56','',''),(2481,'21','221','3',1,'Sale Id shift 91',0.00,0.00,0.00,4093.42,0.00,'2022-06-14 17:49:56','',''),(2482,'21','221','3',1,'Sale Id shift 91',0.00,0.00,0.00,4614.58,0.00,'2022-06-14 17:49:56','',''),(2483,'21','221','3',1,'Sale Id shift 91',0.00,0.00,0.00,6842.41,0.00,'2022-06-14 17:49:56','',''),(2484,'21','221','3',1,'Sale Id shift 91',0.00,0.00,0.00,2968.66,0.00,'2022-06-14 17:49:56','',''),(2485,'21','221','1',1,'Sale Id shift 91',0.00,0.00,0.00,3695.83,0.00,'2022-06-14 17:49:56','',''),(2486,'21','221','4',2,'Sale Id shift 91',0.00,0.00,0.00,6705.28,0.00,'2022-06-14 17:49:56','',''),(2487,'21','221','4',2,'Sale Id shift 91',0.00,0.00,0.00,5127.97,0.00,'2022-06-14 17:49:56','',''),(2488,'21','221','5',3,'Sale Id shift 91',0.00,0.00,0.00,927.48,0.00,'2022-06-14 17:49:56','',''),(2489,'21','221','3',1,'Sale Id shift 91',0.00,0.00,0.00,6469.78,0.00,'2022-06-14 17:49:56','',''),(2490,'21','221','1',1,'Sale Id shift 91',0.00,0.00,0.00,4644.33,0.00,'2022-06-14 17:49:56','',''),(2491,'21','221','1',1,'Sale Id shift 91',0.00,0.00,0.00,4036.44,0.00,'2022-06-14 17:49:56','',''),(2492,'21','221','2',1,'Sale Id shift 91',0.00,0.00,0.00,6878.45,0.00,'2022-06-14 17:49:56','',''),(2493,'21','221','2',1,'Sale Id shift 91',0.00,0.00,0.00,4462.85,0.00,'2022-06-14 17:49:56','',''),(2494,'21','221','2',1,'Sale Id shift 91',0.00,0.00,0.00,3893.45,0.00,'2022-06-14 17:49:56','',''),(2495,'21','221','2',1,'Sale Id shift 91',0.00,0.00,0.00,4000.34,0.00,'2022-06-14 17:49:56','',''),(2496,'21','221',NULL,2,'Sale Id shift 91',9466600.00,0.00,0.00,0.00,0.00,'2022-06-14 17:49:56','',''),(2497,'21','221',NULL,3,'Sale Id shift 91',649236.00,0.00,0.00,0.00,0.00,'2022-06-14 17:49:56','',''),(2498,'21','221',NULL,1,'Sale Id shift 91',14537419.05,0.00,0.00,0.00,0.00,'2022-06-14 17:49:56','',''),(2499,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-14 17:58:28','',''),(2500,'21','221',NULL,1,'Reception corrector for bridging 241',0.00,0.00,0.00,40000.00,0.00,'2022-06-14 18:01:12','',''),(2501,'21','221','2',1,'Received from bridging 241',0.00,0.00,40000.00,0.00,0.00,'2022-06-14 18:01:12','',''),(2502,'21','221',NULL,1,'Reception corrector for bridging 240',0.00,0.00,0.00,10000.00,0.00,'2022-06-14 18:01:12','',''),(2503,'21','221','1',1,'Received from bridging 240',0.00,0.00,10000.00,0.00,0.00,'2022-06-14 18:01:12','',''),(2504,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-14 18:01:52','',''),(2505,'21','221',NULL,1,'Reception corrector for bridging 243',0.00,0.00,0.00,40000.00,0.00,'2022-06-14 18:04:08','',''),(2506,'21','221','3',1,'Received from bridging 243',0.00,0.00,40000.00,0.00,0.00,'2022-06-14 18:04:08','',''),(2507,'21','221',NULL,1,'Reception corrector for bridging 242',0.00,0.00,0.00,10000.00,0.00,'2022-06-14 18:04:08','',''),(2508,'21','221','1',1,'Received from bridging 242',0.00,0.00,10000.00,0.00,0.00,'2022-06-14 18:04:08','',''),(2509,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12000000.00,15000.00,0.00,0.00,'2022-06-14 18:04:30','',''),(2510,'21','221',NULL,2,'Reception corrector for bridging 244',0.00,0.00,0.00,15000.00,0.00,'2022-06-14 18:07:30','',''),(2511,'21','221','4',2,'Received from bridging 244',0.00,0.00,15000.00,0.00,0.00,'2022-06-14 18:07:30','',''),(2512,'21','221','1',1,'Sale Id shift 92',0.00,0.00,0.00,5270.86,0.00,'2022-06-15 05:56:37','',''),(2513,'21','221','2',1,'Sale Id shift 92',0.00,0.00,0.00,5357.72,0.00,'2022-06-15 05:56:37','',''),(2514,'21','221','2',1,'Sale Id shift 92',0.00,0.00,0.00,2597.60,0.00,'2022-06-15 05:56:37','',''),(2515,'21','221','3',1,'Sale Id shift 92',0.00,0.00,0.00,2753.98,0.00,'2022-06-15 05:56:37','',''),(2516,'21','221','3',1,'Sale Id shift 92',0.00,0.00,0.00,2498.22,0.00,'2022-06-15 05:56:37','',''),(2517,'21','221','3',1,'Sale Id shift 92',0.00,0.00,0.00,3040.18,0.00,'2022-06-15 05:56:37','',''),(2518,'21','221','3',1,'Sale Id shift 92',0.00,0.00,0.00,2411.93,0.00,'2022-06-15 05:56:37','',''),(2519,'21','221','3',1,'Sale Id shift 92',0.00,0.00,0.00,2933.86,0.00,'2022-06-15 05:56:37','',''),(2520,'21','221','3',1,'Sale Id shift 92',0.00,0.00,0.00,3763.21,0.00,'2022-06-15 05:56:37','',''),(2521,'21','221','3',1,'Sale Id shift 92',0.00,0.00,0.00,3020.57,0.00,'2022-06-15 05:56:37','',''),(2522,'21','221','1',1,'Sale Id shift 92',0.00,0.00,0.00,1776.30,0.00,'2022-06-15 05:56:37','',''),(2523,'21','221','4',2,'Sale Id shift 92',0.00,0.00,0.00,8456.89,0.00,'2022-06-15 05:56:37','',''),(2524,'21','221','4',2,'Sale Id shift 92',0.00,0.00,0.00,1957.29,0.00,'2022-06-15 05:56:37','',''),(2525,'21','221','4',2,'Sale Id shift 92',0.00,0.00,0.00,10708.40,0.00,'2022-06-15 05:56:37','',''),(2526,'21','221','5',3,'Sale Id shift 92',0.00,0.00,0.00,1712.76,0.00,'2022-06-15 05:56:37','',''),(2527,'21','221','3',1,'Sale Id shift 92',0.00,0.00,0.00,5424.58,0.00,'2022-06-15 05:56:37','',''),(2528,'21','221','1',1,'Sale Id shift 92',0.00,0.00,0.00,4011.68,0.00,'2022-06-15 05:56:37','',''),(2529,'21','221','1',1,'Sale Id shift 92',0.00,0.00,0.00,3921.55,0.00,'2022-06-15 05:56:37','',''),(2530,'21','221','2',1,'Sale Id shift 92',0.00,0.00,0.00,4078.60,0.00,'2022-06-15 05:56:37','',''),(2531,'21','221','2',1,'Sale Id shift 92',0.00,0.00,0.00,2457.22,0.00,'2022-06-15 05:56:37','',''),(2532,'21','221','2',1,'Sale Id shift 92',0.00,0.00,0.00,4495.41,0.00,'2022-06-15 05:56:37','',''),(2533,'21','221','2',1,'Sale Id shift 92',0.00,0.00,0.00,3694.82,0.00,'2022-06-15 05:56:37','',''),(2534,'21','221',NULL,1,'Sale Id shift 92',10478867.85,0.00,0.00,0.00,0.00,'2022-06-15 05:56:37','',''),(2535,'21','221',NULL,2,'Sale Id shift 92',16898064.00,0.00,0.00,0.00,0.00,'2022-06-15 05:56:37','',''),(2536,'21','221',NULL,3,'Sale Id shift 92',1198932.00,0.00,0.00,0.00,0.00,'2022-06-15 05:56:37','',''),(2537,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-15 12:35:40','',''),(2538,'21','221',NULL,1,'Reception corrector for bridging 247',0.00,0.00,0.00,20000.00,0.00,'2022-06-15 12:37:50','',''),(2539,'21','221','3',1,'Received from bridging 247',0.00,0.00,20000.00,0.00,0.00,'2022-06-15 12:37:50','',''),(2540,'21','221',NULL,1,'Reception corrector for bridging 246',0.00,0.00,0.00,20000.00,0.00,'2022-06-15 12:37:50','',''),(2541,'21','221','2',1,'Received from bridging 246',0.00,0.00,20000.00,0.00,0.00,'2022-06-15 12:37:50','',''),(2542,'21','221',NULL,1,'Reception corrector for bridging 245',0.00,0.00,0.00,20000.00,0.00,'2022-06-15 12:37:50','',''),(2543,'21','221','1',1,'Received from bridging 245',0.00,0.00,20000.00,0.00,0.00,'2022-06-15 12:37:50','',''),(2544,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,26000000.00,32500.00,0.00,0.00,'2022-06-15 12:38:03','',''),(2545,'21','221',NULL,2,'Reception corrector for bridging 248',0.00,0.00,0.00,32500.00,0.00,'2022-06-15 12:39:36','',''),(2546,'21','221','4',2,'Received from bridging 248',0.00,0.00,32500.00,0.00,0.00,'2022-06-15 12:39:36','',''),(2547,'21','221','1',1,'Sale Id shift 93',0.00,0.00,0.00,906.30,0.00,'2022-06-15 13:55:40','',''),(2548,'21','221','2',1,'Sale Id shift 93',0.00,0.00,0.00,2301.55,0.00,'2022-06-15 13:55:40','',''),(2549,'21','221','2',1,'Sale Id shift 93',0.00,0.00,0.00,1191.83,0.00,'2022-06-15 13:55:40','',''),(2550,'21','221','3',1,'Sale Id shift 93',0.00,0.00,0.00,966.46,0.00,'2022-06-15 13:55:40','',''),(2551,'21','221','3',1,'Sale Id shift 93',0.00,0.00,0.00,1041.14,0.00,'2022-06-15 13:55:40','',''),(2552,'21','221','3',1,'Sale Id shift 93',0.00,0.00,0.00,963.06,0.00,'2022-06-15 13:55:40','',''),(2553,'21','221','3',1,'Sale Id shift 93',0.00,0.00,0.00,1162.13,0.00,'2022-06-15 13:55:40','',''),(2554,'21','221','3',1,'Sale Id shift 93',0.00,0.00,0.00,716.25,0.00,'2022-06-15 13:55:40','',''),(2555,'21','221','3',1,'Sale Id shift 93',0.00,0.00,0.00,1216.78,0.00,'2022-06-15 13:55:40','',''),(2556,'21','221','3',1,'Sale Id shift 93',0.00,0.00,0.00,747.68,0.00,'2022-06-15 13:55:40','',''),(2557,'21','221','1',1,'Sale Id shift 93',0.00,0.00,0.00,551.36,0.00,'2022-06-15 13:55:40','',''),(2558,'21','221','4',2,'Sale Id shift 93',0.00,0.00,0.00,1720.52,0.00,'2022-06-15 13:55:40','',''),(2559,'21','221','4',2,'Sale Id shift 93',0.00,0.00,0.00,2346.92,0.00,'2022-06-15 13:55:40','',''),(2560,'21','221','5',3,'Sale Id shift 93',0.00,0.00,0.00,874.15,0.00,'2022-06-15 13:55:40','',''),(2561,'21','221','3',1,'Sale Id shift 93',0.00,0.00,0.00,2243.60,0.00,'2022-06-15 13:55:40','',''),(2562,'21','221','1',1,'Sale Id shift 93',0.00,0.00,0.00,1103.18,0.00,'2022-06-15 13:55:40','',''),(2563,'21','221','1',1,'Sale Id shift 93',0.00,0.00,0.00,1081.51,0.00,'2022-06-15 13:55:40','',''),(2564,'21','221','2',1,'Sale Id shift 93',0.00,0.00,0.00,1128.57,0.00,'2022-06-15 13:55:40','',''),(2565,'21','221','2',1,'Sale Id shift 93',0.00,0.00,0.00,1046.23,0.00,'2022-06-15 13:55:40','',''),(2566,'21','221','2',1,'Sale Id shift 93',0.00,0.00,0.00,1525.85,0.00,'2022-06-15 13:55:40','',''),(2567,'21','221','2',1,'Sale Id shift 93',0.00,0.00,0.00,196.52,0.00,'2022-06-15 13:55:40','',''),(2568,'21','221',NULL,2,'Sale Id shift 93',3253952.00,0.00,0.00,0.00,0.00,'2022-06-15 13:55:40','',''),(2569,'21','221',NULL,3,'Sale Id shift 93',611905.00,0.00,0.00,0.00,0.00,'2022-06-15 13:55:40','',''),(2570,'21','221',NULL,1,'Sale Id shift 93',3314850.00,0.00,0.00,0.00,0.00,'2022-06-15 13:55:40','',''),(2571,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-15 13:59:47','',''),(2572,'21','221',NULL,1,'Reception corrector for bridging 251',0.00,0.00,0.00,25000.00,0.00,'2022-06-15 14:05:35','',''),(2573,'21','221','3',1,'Received from bridging 251',0.00,0.00,25000.00,0.00,0.00,'2022-06-15 14:05:35','',''),(2574,'21','221',NULL,1,'Reception corrector for bridging 250',0.00,0.00,0.00,15000.00,0.00,'2022-06-15 14:05:35','',''),(2575,'21','221','2',1,'Received from bridging 250',0.00,0.00,15000.00,0.00,0.00,'2022-06-15 14:05:35','',''),(2576,'21','221',NULL,1,'Reception corrector for bridging 249',0.00,0.00,0.00,10000.00,0.00,'2022-06-15 14:05:35','',''),(2577,'21','221','1',1,'Received from bridging 249',0.00,0.00,10000.00,0.00,0.00,'2022-06-15 14:05:35','',''),(2578,'21','221','1',1,'Sale Id shift 94',0.00,0.00,0.00,3099.44,0.00,'2022-06-15 15:27:27','',''),(2579,'21','221','2',1,'Sale Id shift 94',0.00,0.00,0.00,5714.26,0.00,'2022-06-15 15:27:27','',''),(2580,'21','221','2',1,'Sale Id shift 94',0.00,0.00,0.00,4217.82,0.00,'2022-06-15 15:27:27','',''),(2581,'21','221','3',1,'Sale Id shift 94',0.00,0.00,0.00,3288.92,0.00,'2022-06-15 15:27:27','',''),(2582,'21','221','3',1,'Sale Id shift 94',0.00,0.00,0.00,2252.23,0.00,'2022-06-15 15:27:27','',''),(2583,'21','221','3',1,'Sale Id shift 94',0.00,0.00,0.00,3531.68,0.00,'2022-06-15 15:27:27','',''),(2584,'21','221','3',1,'Sale Id shift 94',0.00,0.00,0.00,3326.57,0.00,'2022-06-15 15:27:27','',''),(2585,'21','221','3',1,'Sale Id shift 94',0.00,0.00,0.00,1948.20,0.00,'2022-06-15 15:27:27','',''),(2586,'21','221','3',1,'Sale Id shift 94',0.00,0.00,0.00,4752.35,0.00,'2022-06-15 15:27:27','',''),(2587,'21','221','3',1,'Sale Id shift 94',0.00,0.00,0.00,2382.25,0.00,'2022-06-15 15:27:27','',''),(2588,'21','221','1',1,'Sale Id shift 94',0.00,0.00,0.00,2485.67,0.00,'2022-06-15 15:27:27','',''),(2589,'21','221','4',2,'Sale Id shift 94',0.00,0.00,0.00,4196.97,0.00,'2022-06-15 15:27:27','',''),(2590,'21','221','4',2,'Sale Id shift 94',0.00,0.00,0.00,12842.13,0.00,'2022-06-15 15:27:27','',''),(2591,'21','221','5',3,'Sale Id shift 94',0.00,0.00,0.00,878.82,0.00,'2022-06-15 15:27:27','',''),(2592,'21','221','3',1,'Sale Id shift 94',0.00,0.00,0.00,4957.51,0.00,'2022-06-15 15:27:27','',''),(2593,'21','221','1',1,'Sale Id shift 94',0.00,0.00,0.00,3505.08,0.00,'2022-06-15 15:27:27','',''),(2594,'21','221','1',1,'Sale Id shift 94',0.00,0.00,0.00,3226.64,0.00,'2022-06-15 15:27:27','',''),(2595,'21','221','2',1,'Sale Id shift 94',0.00,0.00,0.00,4286.85,0.00,'2022-06-15 15:27:27','',''),(2596,'21','221','2',1,'Sale Id shift 94',0.00,0.00,0.00,2884.21,0.00,'2022-06-15 15:27:27','',''),(2597,'21','221','2',1,'Sale Id shift 94',0.00,0.00,0.00,4785.13,0.00,'2022-06-15 15:27:27','',''),(2598,'21','221','2',1,'Sale Id shift 94',0.00,0.00,0.00,2449.36,0.00,'2022-06-15 15:27:27','',''),(2599,'21','221',NULL,2,'Sale Id shift 94',13631280.00,0.00,0.00,0.00,0.00,'2022-06-15 15:27:27','',''),(2600,'21','221',NULL,3,'Sale Id shift 94',615174.00,0.00,0.00,0.00,0.00,'2022-06-15 15:27:27','',''),(2601,'21','221',NULL,1,'Sale Id shift 94',10410538.05,0.00,0.00,0.00,0.00,'2022-06-15 15:27:27','',''),(2602,'21','221','1',1,'Sale Id shift 95',0.00,0.00,0.00,1728.40,0.00,'2022-06-16 14:16:54','',''),(2603,'21','221','2',1,'Sale Id shift 95',0.00,0.00,0.00,4484.24,0.00,'2022-06-16 14:16:54','',''),(2604,'21','221','2',1,'Sale Id shift 95',0.00,0.00,0.00,2692.32,0.00,'2022-06-16 14:16:54','',''),(2605,'21','221','3',1,'Sale Id shift 95',0.00,0.00,0.00,2314.59,0.00,'2022-06-16 14:16:54','',''),(2606,'21','221','3',1,'Sale Id shift 95',0.00,0.00,0.00,1901.82,0.00,'2022-06-16 14:16:54','',''),(2607,'21','221','3',1,'Sale Id shift 95',0.00,0.00,0.00,2836.11,0.00,'2022-06-16 14:16:54','',''),(2608,'21','221','3',1,'Sale Id shift 95',0.00,0.00,0.00,2217.78,0.00,'2022-06-16 14:16:54','',''),(2609,'21','221','3',1,'Sale Id shift 95',0.00,0.00,0.00,2285.79,0.00,'2022-06-16 14:16:54','',''),(2610,'21','221','3',1,'Sale Id shift 95',0.00,0.00,0.00,2153.92,0.00,'2022-06-16 14:16:54','',''),(2611,'21','221','3',1,'Sale Id shift 95',0.00,0.00,0.00,2221.34,0.00,'2022-06-16 14:16:54','',''),(2612,'21','221','1',1,'Sale Id shift 95',0.00,0.00,0.00,1904.91,0.00,'2022-06-16 14:16:54','',''),(2613,'21','221','4',2,'Sale Id shift 95',0.00,0.00,0.00,2305.98,0.00,'2022-06-16 14:16:54','',''),(2614,'21','221','4',2,'Sale Id shift 95',0.00,0.00,0.00,4993.32,0.00,'2022-06-16 14:16:54','',''),(2615,'21','221','5',3,'Sale Id shift 95',0.00,0.00,0.00,218.22,0.00,'2022-06-16 14:16:54','',''),(2616,'21','221','3',1,'Sale Id shift 95',0.00,0.00,0.00,4536.97,0.00,'2022-06-16 14:16:54','',''),(2617,'21','221','1',1,'Sale Id shift 95',0.00,0.00,0.00,1769.44,0.00,'2022-06-16 14:16:54','',''),(2618,'21','221','1',1,'Sale Id shift 95',0.00,0.00,0.00,2337.33,0.00,'2022-06-16 14:16:54','',''),(2619,'21','221','2',1,'Sale Id shift 95',0.00,0.00,0.00,3618.42,0.00,'2022-06-16 14:16:54','',''),(2620,'21','221','2',1,'Sale Id shift 95',0.00,0.00,0.00,2073.62,0.00,'2022-06-16 14:16:54','',''),(2621,'21','221','2',1,'Sale Id shift 95',0.00,0.00,0.00,3360.08,0.00,'2022-06-16 14:16:54','',''),(2622,'21','221','2',1,'Sale Id shift 95',0.00,0.00,0.00,3100.80,0.00,'2022-06-16 14:16:54','',''),(2623,'21','221',NULL,1,'Sale Id shift 95',7843750.20,0.00,0.00,0.00,0.00,'2022-06-16 14:16:54','',''),(2624,'21','221',NULL,2,'Sale Id shift 95',5839440.00,0.00,0.00,0.00,0.00,'2022-06-16 14:16:54','',''),(2625,'21','221',NULL,3,'Sale Id shift 95',152754.00,0.00,0.00,0.00,0.00,'2022-06-16 14:16:54','',''),(2626,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,16400000.00,20000.00,0.00,0.00,'2022-06-16 16:35:14','',''),(2627,'21','221',NULL,2,'Reception corrector for bridging 252',0.00,0.00,0.00,20000.00,0.00,'2022-06-16 16:44:54','',''),(2628,'21','221','4',2,'Received from bridging 252',0.00,0.00,20000.00,0.00,0.00,'2022-06-16 16:44:54','',''),(2629,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-16 16:46:14','',''),(2630,'21','221',NULL,1,'Reception corrector for bridging 254',0.00,0.00,0.00,40000.00,0.00,'2022-06-16 16:57:54','',''),(2631,'21','221','2',1,'Received from bridging 254',0.00,0.00,40000.00,0.00,0.00,'2022-06-16 16:57:54','',''),(2632,'21','221',NULL,1,'Reception corrector for bridging 253',0.00,0.00,0.00,10000.00,0.00,'2022-06-16 16:57:54','',''),(2633,'21','221','1',1,'Received from bridging 253',0.00,0.00,10000.00,0.00,0.00,'2022-06-16 16:57:54','',''),(2634,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-16 17:02:45','',''),(2635,'21','221',NULL,1,'Reception corrector for bridging 256',0.00,0.00,0.00,50000.00,0.00,'2022-06-16 17:09:25','',''),(2636,'21','221','3',1,'Received from bridging 256',0.00,0.00,50000.00,0.00,0.00,'2022-06-16 17:09:25','',''),(2637,'21','221',NULL,1,'Reception corrector for bridging 255',0.00,0.00,0.00,10000.00,0.00,'2022-06-16 17:09:25','',''),(2638,'21','221','1',1,'Received from bridging 255',0.00,0.00,10000.00,0.00,0.00,'2022-06-16 17:09:25','',''),(2639,'21','221','1',1,'Sale Id shift 96',0.00,0.00,0.00,3094.79,0.00,'2022-06-18 12:50:22','',''),(2640,'21','221','2',1,'Sale Id shift 96',0.00,0.00,0.00,4537.43,0.00,'2022-06-18 12:50:22','',''),(2641,'21','221','2',1,'Sale Id shift 96',0.00,0.00,0.00,3301.95,0.00,'2022-06-18 12:50:22','',''),(2642,'21','221','3',1,'Sale Id shift 96',0.00,0.00,0.00,2550.48,0.00,'2022-06-18 12:50:22','',''),(2643,'21','221','3',1,'Sale Id shift 96',0.00,0.00,0.00,1912.74,0.00,'2022-06-18 12:50:22','',''),(2644,'21','221','3',1,'Sale Id shift 96',0.00,0.00,0.00,2763.72,0.00,'2022-06-18 12:50:22','',''),(2645,'21','221','3',1,'Sale Id shift 96',0.00,0.00,0.00,2756.36,0.00,'2022-06-18 12:50:22','',''),(2646,'21','221','3',1,'Sale Id shift 96',0.00,0.00,0.00,2639.05,0.00,'2022-06-18 12:50:22','',''),(2647,'21','221','3',1,'Sale Id shift 96',0.00,0.00,0.00,2651.04,0.00,'2022-06-18 12:50:22','',''),(2648,'21','221','3',1,'Sale Id shift 96',0.00,0.00,0.00,3069.39,0.00,'2022-06-18 12:50:22','',''),(2649,'21','221','1',1,'Sale Id shift 96',0.00,0.00,0.00,2643.25,0.00,'2022-06-18 12:50:22','',''),(2650,'21','221','4',2,'Sale Id shift 96',0.00,0.00,0.00,6364.75,0.00,'2022-06-18 12:50:22','',''),(2651,'21','221','4',2,'Sale Id shift 96',0.00,0.00,0.00,4980.42,0.00,'2022-06-18 12:50:22','',''),(2652,'21','221','5',3,'Sale Id shift 96',0.00,0.00,0.00,136.26,0.00,'2022-06-18 12:50:22','',''),(2653,'21','221','5',3,'Sale Id shift 96',0.00,0.00,0.00,185.69,0.00,'2022-06-18 12:50:22','',''),(2654,'21','221','3',1,'Sale Id shift 96',0.00,0.00,0.00,2936.07,0.00,'2022-06-18 12:50:22','',''),(2655,'21','221','1',1,'Sale Id shift 96',0.00,0.00,0.00,2847.25,0.00,'2022-06-18 12:50:22','',''),(2656,'21','221','1',1,'Sale Id shift 96',0.00,0.00,0.00,2309.89,0.00,'2022-06-18 12:50:22','',''),(2657,'21','221','2',1,'Sale Id shift 96',0.00,0.00,0.00,3835.20,0.00,'2022-06-18 12:50:22','',''),(2658,'21','221','2',1,'Sale Id shift 96',0.00,0.00,0.00,1744.87,0.00,'2022-06-18 12:50:22','',''),(2659,'21','221','2',1,'Sale Id shift 96',0.00,0.00,0.00,2092.15,0.00,'2022-06-18 12:50:22','',''),(2660,'21','221','2',1,'Sale Id shift 96',0.00,0.00,0.00,2920.91,0.00,'2022-06-18 12:50:22','',''),(2661,'21','221',NULL,1,'Sale Id shift 96',8350079.10,0.00,0.00,0.00,0.00,'2022-06-18 12:50:22','',''),(2662,'21','221',NULL,2,'Sale Id shift 96',9303039.40,0.00,0.00,0.00,0.00,'2022-06-18 12:50:22','',''),(2663,'21','221',NULL,3,'Sale Id shift 96',241462.50,0.00,0.00,0.00,0.00,'2022-06-18 12:50:22','',''),(2664,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,36900000.00,45000.00,0.00,0.00,'2022-06-20 15:42:14','',''),(2665,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2062500.00,12500.00,0.00,0.00,'2022-06-20 15:43:35','',''),(2666,'21','221',NULL,1,'Reception corrector for bridging 258',0.00,0.00,0.00,12500.00,0.00,'2022-06-20 15:46:56','',''),(2667,'21','221','1',1,'Received from bridging 258',0.00,0.00,12500.00,0.00,0.00,'2022-06-20 15:46:56','',''),(2668,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-20 15:47:18','',''),(2669,'21','221',NULL,1,'Reception corrector for bridging 260',0.00,0.00,0.00,27100.00,0.00,'2022-06-20 15:49:57','',''),(2670,'21','221','3',1,'Received from bridging 260',0.00,0.00,27100.00,0.00,0.00,'2022-06-20 15:49:57','',''),(2671,'21','221',NULL,1,'Reception corrector for bridging 259',0.00,0.00,0.00,22700.00,0.00,'2022-06-20 15:49:57','',''),(2672,'21','221','2',1,'Received from bridging 259',0.00,0.00,22700.00,0.00,0.00,'2022-06-20 15:49:57','',''),(2673,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,16400000.00,20000.00,0.00,0.00,'2022-06-20 16:00:33','',''),(2674,'21','221',NULL,2,'Reception corrector for bridging 261',0.00,0.00,0.00,20000.00,0.00,'2022-06-20 16:01:58','',''),(2675,'21','221','4',2,'Received from bridging 261',0.00,0.00,20000.00,0.00,0.00,'2022-06-20 16:01:58','',''),(2676,'21','221','1',1,'Sale Id shift 97',0.00,0.00,0.00,2054.59,0.00,'2022-06-20 17:06:27','',''),(2677,'21','221','2',1,'Sale Id shift 97',0.00,0.00,0.00,4378.81,0.00,'2022-06-20 17:06:27','',''),(2678,'21','221','2',1,'Sale Id shift 97',0.00,0.00,0.00,3069.91,0.00,'2022-06-20 17:06:27','',''),(2679,'21','221','3',1,'Sale Id shift 97',0.00,0.00,0.00,2224.62,0.00,'2022-06-20 17:06:27','',''),(2680,'21','221','3',1,'Sale Id shift 97',0.00,0.00,0.00,1866.30,0.00,'2022-06-20 17:06:27','',''),(2681,'21','221','3',1,'Sale Id shift 97',0.00,0.00,0.00,1449.81,0.00,'2022-06-20 17:06:27','',''),(2682,'21','221','3',1,'Sale Id shift 97',0.00,0.00,0.00,1953.52,0.00,'2022-06-20 17:06:27','',''),(2683,'21','221','3',1,'Sale Id shift 97',0.00,0.00,0.00,3401.51,0.00,'2022-06-20 17:06:27','',''),(2684,'21','221','3',1,'Sale Id shift 97',0.00,0.00,0.00,4009.44,0.00,'2022-06-20 17:06:27','',''),(2685,'21','221','3',1,'Sale Id shift 97',0.00,0.00,0.00,1995.34,0.00,'2022-06-20 17:06:27','',''),(2686,'21','221','1',1,'Sale Id shift 97',0.00,0.00,0.00,2812.27,0.00,'2022-06-20 17:06:27','',''),(2687,'21','221','4',2,'Sale Id shift 97',0.00,0.00,0.00,7797.32,0.00,'2022-06-20 17:06:27','',''),(2688,'21','221','4',2,'Sale Id shift 97',0.00,0.00,0.00,7625.86,0.00,'2022-06-20 17:06:27','',''),(2689,'21','221','5',3,'Sale Id shift 97',0.00,0.00,0.00,916.43,0.00,'2022-06-20 17:06:27','',''),(2690,'21','221','3',1,'Sale Id shift 97',0.00,0.00,0.00,3254.31,0.00,'2022-06-20 17:06:27','',''),(2691,'21','221','1',1,'Sale Id shift 97',0.00,0.00,0.00,2485.56,0.00,'2022-06-20 17:06:27','',''),(2692,'21','221','1',1,'Sale Id shift 97',0.00,0.00,0.00,2470.95,0.00,'2022-06-20 17:06:27','',''),(2693,'21','221','2',1,'Sale Id shift 97',0.00,0.00,0.00,4082.56,0.00,'2022-06-20 17:06:27','',''),(2694,'21','221','2',1,'Sale Id shift 97',0.00,0.00,0.00,1922.52,0.00,'2022-06-20 17:06:27','',''),(2695,'21','221','2',1,'Sale Id shift 97',0.00,0.00,0.00,3733.35,0.00,'2022-06-20 17:06:27','',''),(2696,'21','221','2',1,'Sale Id shift 97',0.00,0.00,0.00,3401.95,0.00,'2022-06-20 17:06:27','',''),(2697,'21','221',NULL,1,'Sale Id shift 97',8343607.80,0.00,0.00,0.00,0.00,'2022-06-20 17:06:27','',''),(2698,'21','221',NULL,2,'Sale Id shift 97',12647007.60,0.00,0.00,0.00,0.00,'2022-06-20 17:06:27','',''),(2699,'21','221',NULL,3,'Sale Id shift 97',687322.50,0.00,0.00,0.00,0.00,'2022-06-20 17:06:27','',''),(2700,'21','221','1',1,'Sale Id shift 98',0.00,0.00,0.00,1625.04,0.00,'2022-06-24 20:04:22','',''),(2701,'21','221','2',1,'Sale Id shift 98',0.00,0.00,0.00,1728.88,0.00,'2022-06-24 20:04:22','',''),(2702,'21','221','2',1,'Sale Id shift 98',0.00,0.00,0.00,1387.92,0.00,'2022-06-24 20:04:22','',''),(2703,'21','221','3',1,'Sale Id shift 98',0.00,0.00,0.00,819.81,0.00,'2022-06-24 20:04:22','',''),(2704,'21','221','3',1,'Sale Id shift 98',0.00,0.00,0.00,833.92,0.00,'2022-06-24 20:04:22','',''),(2705,'21','221','3',1,'Sale Id shift 98',0.00,0.00,0.00,1048.27,0.00,'2022-06-24 20:04:22','',''),(2706,'21','221','3',1,'Sale Id shift 98',0.00,0.00,0.00,948.01,0.00,'2022-06-24 20:04:22','',''),(2707,'21','221','3',1,'Sale Id shift 98',0.00,0.00,0.00,1037.19,0.00,'2022-06-24 20:04:22','',''),(2708,'21','221','3',1,'Sale Id shift 98',0.00,0.00,0.00,1471.21,0.00,'2022-06-24 20:04:22','',''),(2709,'21','221','3',1,'Sale Id shift 98',0.00,0.00,0.00,1308.41,0.00,'2022-06-24 20:04:22','',''),(2710,'21','221','1',1,'Sale Id shift 98',0.00,0.00,0.00,896.86,0.00,'2022-06-24 20:04:22','',''),(2711,'21','221','4',2,'Sale Id shift 98',0.00,0.00,0.00,3449.20,0.00,'2022-06-24 20:04:22','',''),(2712,'21','221','4',2,'Sale Id shift 98',0.00,0.00,0.00,406.69,0.00,'2022-06-24 20:04:22','',''),(2713,'21','221','4',2,'Sale Id shift 98',0.00,0.00,0.00,7083.20,0.00,'2022-06-24 20:04:22','',''),(2714,'21','221','5',3,'Sale Id shift 98',0.00,0.00,0.00,856.03,0.00,'2022-06-24 20:04:22','',''),(2715,'21','221','3',1,'Sale Id shift 98',0.00,0.00,0.00,795.79,0.00,'2022-06-24 20:04:22','',''),(2716,'21','221','1',1,'Sale Id shift 98',0.00,0.00,0.00,1637.82,0.00,'2022-06-24 20:04:22','',''),(2717,'21','221','1',1,'Sale Id shift 98',0.00,0.00,0.00,718.09,0.00,'2022-06-24 20:04:22','',''),(2718,'21','221','2',1,'Sale Id shift 98',0.00,0.00,0.00,1919.49,0.00,'2022-06-24 20:04:22','',''),(2719,'21','221','2',1,'Sale Id shift 98',0.00,0.00,0.00,1099.14,0.00,'2022-06-24 20:04:22','',''),(2720,'21','221','2',1,'Sale Id shift 98',0.00,0.00,0.00,939.50,0.00,'2022-06-24 20:04:22','',''),(2721,'21','221','2',1,'Sale Id shift 98',0.00,0.00,0.00,797.08,0.00,'2022-06-24 20:04:22','',''),(2722,'21','221',NULL,1,'Sale Id shift 98',3467050.95,0.00,0.00,0.00,0.00,'2022-06-24 20:04:22','',''),(2723,'21','221',NULL,2,'Sale Id shift 98',8970053.80,0.00,0.00,0.00,0.00,'2022-06-24 20:04:22','',''),(2724,'21','221',NULL,3,'Sale Id shift 98',642022.50,0.00,0.00,0.00,0.00,'2022-06-24 20:04:22','',''),(2725,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-25 17:32:25','',''),(2726,'21','221',NULL,1,'Reception corrector for bridging 264',0.00,0.00,0.00,20000.00,0.00,'2022-06-25 17:37:39','',''),(2727,'21','221','3',1,'Received from bridging 264',0.00,0.00,20000.00,0.00,0.00,'2022-06-25 17:37:39','',''),(2728,'21','221',NULL,1,'Reception corrector for bridging 263',0.00,0.00,0.00,20000.00,0.00,'2022-06-25 17:37:39','',''),(2729,'21','221','2',1,'Received from bridging 263',0.00,0.00,20000.00,0.00,0.00,'2022-06-25 17:37:39','',''),(2730,'21','221',NULL,1,'Reception corrector for bridging 262',0.00,0.00,0.00,5000.00,0.00,'2022-06-25 17:37:39','',''),(2731,'21','221','1',1,'Received from bridging 262',0.00,0.00,5000.00,0.00,0.00,'2022-06-25 17:37:39','',''),(2732,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24600000.00,30000.00,0.00,0.00,'2022-06-25 17:38:04','',''),(2733,'21','221',NULL,2,'Reception corrector for bridging 265',0.00,0.00,0.00,30000.00,0.00,'2022-06-25 17:39:56','',''),(2734,'21','221','4',2,'Received from bridging 265',0.00,0.00,30000.00,0.00,0.00,'2022-06-25 17:39:56','',''),(2735,'21','221','1',1,'Sale Id shift 99',0.00,0.00,0.00,5783.80,0.00,'2022-06-27 14:17:42','',''),(2736,'21','221','2',1,'Sale Id shift 99',0.00,0.00,0.00,6384.12,0.00,'2022-06-27 14:17:42','',''),(2737,'21','221','2',1,'Sale Id shift 99',0.00,0.00,0.00,4800.85,0.00,'2022-06-27 14:17:42','',''),(2738,'21','221','3',1,'Sale Id shift 99',0.00,0.00,0.00,4263.13,0.00,'2022-06-27 14:17:42','',''),(2739,'21','221','3',1,'Sale Id shift 99',0.00,0.00,0.00,2899.55,0.00,'2022-06-27 14:17:42','',''),(2740,'21','221','3',1,'Sale Id shift 99',0.00,0.00,0.00,3545.26,0.00,'2022-06-27 14:17:42','',''),(2741,'21','221','3',1,'Sale Id shift 99',0.00,0.00,0.00,3766.30,0.00,'2022-06-27 14:17:42','',''),(2742,'21','221','3',1,'Sale Id shift 99',0.00,0.00,0.00,3680.10,0.00,'2022-06-27 14:17:42','',''),(2743,'21','221','3',1,'Sale Id shift 99',0.00,0.00,0.00,4004.82,0.00,'2022-06-27 14:17:42','',''),(2744,'21','221','3',1,'Sale Id shift 99',0.00,0.00,0.00,4605.13,0.00,'2022-06-27 14:17:42','',''),(2745,'21','221','1',1,'Sale Id shift 99',0.00,0.00,0.00,4704.61,0.00,'2022-06-27 14:17:42','',''),(2746,'21','221','4',2,'Sale Id shift 99',0.00,0.00,0.00,4320.61,0.00,'2022-06-27 14:17:42','',''),(2747,'21','221','4',2,'Sale Id shift 99',0.00,0.00,0.00,14449.87,0.00,'2022-06-27 14:17:42','',''),(2748,'21','221','5',3,'Sale Id shift 99',0.00,0.00,0.00,798.65,0.00,'2022-06-27 14:17:42','',''),(2749,'21','221','3',1,'Sale Id shift 99',0.00,0.00,0.00,4573.99,0.00,'2022-06-27 14:17:42','',''),(2750,'21','221','1',1,'Sale Id shift 99',0.00,0.00,0.00,4540.52,0.00,'2022-06-27 14:17:42','',''),(2751,'21','221','1',1,'Sale Id shift 99',0.00,0.00,0.00,5149.82,0.00,'2022-06-27 14:17:42','',''),(2752,'21','221','2',1,'Sale Id shift 99',0.00,0.00,0.00,6626.99,0.00,'2022-06-27 14:17:42','',''),(2753,'21','221','2',1,'Sale Id shift 99',0.00,0.00,0.00,3654.59,0.00,'2022-06-27 14:17:42','',''),(2754,'21','221','2',1,'Sale Id shift 99',0.00,0.00,0.00,4525.47,0.00,'2022-06-27 14:17:42','',''),(2755,'21','221','2',1,'Sale Id shift 99',0.00,0.00,0.00,3867.85,0.00,'2022-06-27 14:17:42','',''),(2756,'21','221',NULL,1,'Sale Id shift 99',13427188.50,0.00,0.00,0.00,0.00,'2022-06-27 14:17:42','',''),(2757,'21','221',NULL,2,'Sale Id shift 99',15391793.60,0.00,0.00,0.00,0.00,'2022-06-27 14:17:42','',''),(2758,'21','221',NULL,3,'Sale Id shift 99',598987.50,0.00,0.00,0.00,0.00,'2022-06-27 14:17:42','',''),(2759,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-27 15:25:03','',''),(2760,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-27 15:36:39','',''),(2761,'21','221',NULL,1,'Reception corrector for bridging 267',0.00,0.00,0.00,15000.00,0.00,'2022-06-27 15:38:59','',''),(2762,'21','221','2',1,'Received from bridging 267',0.00,0.00,15000.00,0.00,0.00,'2022-06-27 15:38:59','',''),(2763,'21','221',NULL,1,'Reception corrector for bridging 266',0.00,0.00,0.00,30000.00,0.00,'2022-06-27 15:38:59','',''),(2764,'21','221','1',1,'Received from bridging 266',0.00,0.00,30000.00,0.00,0.00,'2022-06-27 15:38:59','',''),(2765,'21','221',NULL,1,'Reception corrector for bridging 269',0.00,0.00,0.00,35000.00,0.00,'2022-06-27 15:39:37','',''),(2766,'21','221','3',1,'Received from bridging 269',0.00,0.00,35000.00,0.00,0.00,'2022-06-27 15:39:37','',''),(2767,'21','221',NULL,1,'Reception corrector for bridging 268',0.00,0.00,0.00,15000.00,0.00,'2022-06-27 15:39:37','',''),(2768,'21','221','2',1,'Received from bridging 268',0.00,0.00,15000.00,0.00,0.00,'2022-06-27 15:39:37','',''),(2769,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,16600000.00,20000.00,0.00,0.00,'2022-06-27 15:40:00','',''),(2770,'21','221',NULL,2,'Reception corrector for bridging 270',0.00,0.00,0.00,20000.00,0.00,'2022-06-27 15:42:18','',''),(2771,'21','221','4',2,'Received from bridging 270',0.00,0.00,20000.00,0.00,0.00,'2022-06-27 15:42:18','',''),(2772,'21','221','1',1,'Sale Id shift 100',0.00,0.00,0.00,3329.38,0.00,'2022-06-27 17:16:16','',''),(2773,'21','221','2',1,'Sale Id shift 100',0.00,0.00,0.00,6992.52,0.00,'2022-06-27 17:16:16','',''),(2774,'21','221','2',1,'Sale Id shift 100',0.00,0.00,0.00,3764.62,0.00,'2022-06-27 17:16:16','',''),(2775,'21','221','3',1,'Sale Id shift 100',0.00,0.00,0.00,2897.57,0.00,'2022-06-27 17:16:16','',''),(2776,'21','221','3',1,'Sale Id shift 100',0.00,0.00,0.00,3928.76,0.00,'2022-06-27 17:16:16','',''),(2777,'21','221','3',1,'Sale Id shift 100',0.00,0.00,0.00,3563.65,0.00,'2022-06-27 17:16:16','',''),(2778,'21','221','3',1,'Sale Id shift 100',0.00,0.00,0.00,3184.50,0.00,'2022-06-27 17:16:16','',''),(2779,'21','221','3',1,'Sale Id shift 100',0.00,0.00,0.00,1998.80,0.00,'2022-06-27 17:16:16','',''),(2780,'21','221','3',1,'Sale Id shift 100',0.00,0.00,0.00,3950.30,0.00,'2022-06-27 17:16:16','',''),(2781,'21','221','3',1,'Sale Id shift 100',0.00,0.00,0.00,3677.60,0.00,'2022-06-27 17:16:16','',''),(2782,'21','221','1',1,'Sale Id shift 100',0.00,0.00,0.00,2977.73,0.00,'2022-06-27 17:16:16','',''),(2783,'21','221','4',2,'Sale Id shift 100',0.00,0.00,0.00,3299.08,0.00,'2022-06-27 17:16:16','',''),(2784,'21','221','4',2,'Sale Id shift 100',0.00,0.00,0.00,3331.52,0.00,'2022-06-27 17:16:16','',''),(2785,'21','221','5',3,'Sale Id shift 100',0.00,0.00,0.00,841.62,0.00,'2022-06-27 17:16:16','',''),(2786,'21','221','3',1,'Sale Id shift 100',0.00,0.00,0.00,4489.12,0.00,'2022-06-27 17:16:16','',''),(2787,'21','221','1',1,'Sale Id shift 100',0.00,0.00,0.00,2906.29,0.00,'2022-06-27 17:16:16','',''),(2788,'21','221','1',1,'Sale Id shift 100',0.00,0.00,0.00,1972.87,0.00,'2022-06-27 17:16:16','',''),(2789,'21','221','2',1,'Sale Id shift 100',0.00,0.00,0.00,6265.00,0.00,'2022-06-27 17:16:16','',''),(2790,'21','221','2',1,'Sale Id shift 100',0.00,0.00,0.00,2813.18,0.00,'2022-06-27 17:16:16','',''),(2791,'21','221','2',1,'Sale Id shift 100',0.00,0.00,0.00,3458.75,0.00,'2022-06-27 17:16:16','',''),(2792,'21','221','2',1,'Sale Id shift 100',0.00,0.00,0.00,3759.65,0.00,'2022-06-27 17:16:16','',''),(2793,'21','221',NULL,1,'Sale Id shift 100',10878497.85,0.00,0.00,0.00,0.00,'2022-06-27 17:16:16','',''),(2794,'21','221',NULL,2,'Sale Id shift 100',5503398.00,0.00,0.00,0.00,0.00,'2022-06-27 17:16:16','',''),(2795,'21','221',NULL,3,'Sale Id shift 100',631215.00,0.00,0.00,0.00,0.00,'2022-06-27 17:16:16','',''),(2796,'21','221','1',1,'Sale Id shift 101',0.00,0.00,0.00,2484.34,0.00,'2022-06-28 16:28:12','',''),(2797,'21','221','2',1,'Sale Id shift 101',0.00,0.00,0.00,4152.36,0.00,'2022-06-28 16:28:12','',''),(2798,'21','221','2',1,'Sale Id shift 101',0.00,0.00,0.00,2044.07,0.00,'2022-06-28 16:28:12','',''),(2799,'21','221','3',1,'Sale Id shift 101',0.00,0.00,0.00,2386.83,0.00,'2022-06-28 16:28:12','',''),(2800,'21','221','3',1,'Sale Id shift 101',0.00,0.00,0.00,1592.79,0.00,'2022-06-28 16:28:12','',''),(2801,'21','221','3',1,'Sale Id shift 101',0.00,0.00,0.00,1882.45,0.00,'2022-06-28 16:28:12','',''),(2802,'21','221','3',1,'Sale Id shift 101',0.00,0.00,0.00,1803.62,0.00,'2022-06-28 16:28:12','',''),(2803,'21','221','3',1,'Sale Id shift 101',0.00,0.00,0.00,1744.63,0.00,'2022-06-28 16:28:12','',''),(2804,'21','221','3',1,'Sale Id shift 101',0.00,0.00,0.00,2475.89,0.00,'2022-06-28 16:28:12','',''),(2805,'21','221','3',1,'Sale Id shift 101',0.00,0.00,0.00,1400.03,0.00,'2022-06-28 16:28:12','',''),(2806,'21','221','1',1,'Sale Id shift 101',0.00,0.00,0.00,3151.78,0.00,'2022-06-28 16:28:12','',''),(2807,'21','221','4',2,'Sale Id shift 101',0.00,0.00,0.00,5800.88,0.00,'2022-06-28 16:28:12','',''),(2808,'21','221','4',2,'Sale Id shift 101',0.00,0.00,0.00,3750.57,0.00,'2022-06-28 16:28:12','',''),(2809,'21','221','5',3,'Sale Id shift 101',0.00,0.00,0.00,778.38,0.00,'2022-06-28 16:28:12','',''),(2810,'21','221','3',1,'Sale Id shift 101',0.00,0.00,0.00,2463.02,0.00,'2022-06-28 16:28:12','',''),(2811,'21','221','1',1,'Sale Id shift 101',0.00,0.00,0.00,3116.64,0.00,'2022-06-28 16:28:12','',''),(2812,'21','221','1',1,'Sale Id shift 101',0.00,0.00,0.00,2865.37,0.00,'2022-06-28 16:28:12','',''),(2813,'21','221','2',1,'Sale Id shift 101',0.00,0.00,0.00,3635.24,0.00,'2022-06-28 16:28:12','',''),(2814,'21','221','2',1,'Sale Id shift 101',0.00,0.00,0.00,1631.30,0.00,'2022-06-28 16:28:12','',''),(2815,'21','221','2',1,'Sale Id shift 101',0.00,0.00,0.00,3083.52,0.00,'2022-06-28 16:28:12','',''),(2816,'21','221','2',1,'Sale Id shift 101',0.00,0.00,0.00,2685.41,0.00,'2022-06-28 16:28:12','',''),(2817,'21','221',NULL,1,'Sale Id shift 101',7358882.85,0.00,0.00,0.00,0.00,'2022-06-28 16:28:12','',''),(2818,'21','221',NULL,2,'Sale Id shift 101',7927703.50,0.00,0.00,0.00,0.00,'2022-06-28 16:28:12','',''),(2819,'21','221',NULL,3,'Sale Id shift 101',583785.00,0.00,0.00,0.00,0.00,'2022-06-28 16:28:12','',''),(2820,'21','221','1',1,'Sale Id shift 102',0.00,0.00,0.00,3094.94,0.00,'2022-06-29 14:45:52','',''),(2821,'21','221','2',1,'Sale Id shift 102',0.00,0.00,0.00,3974.77,0.00,'2022-06-29 14:45:52','',''),(2822,'21','221','2',1,'Sale Id shift 102',0.00,0.00,0.00,1622.39,0.00,'2022-06-29 14:45:52','',''),(2823,'21','221','3',1,'Sale Id shift 102',0.00,0.00,0.00,3231.66,0.00,'2022-06-29 14:45:52','',''),(2824,'21','221','3',1,'Sale Id shift 102',0.00,0.00,0.00,2092.74,0.00,'2022-06-29 14:45:52','',''),(2825,'21','221','3',1,'Sale Id shift 102',0.00,0.00,0.00,2598.52,0.00,'2022-06-29 14:45:52','',''),(2826,'21','221','3',1,'Sale Id shift 102',0.00,0.00,0.00,2098.18,0.00,'2022-06-29 14:45:52','',''),(2827,'21','221','3',1,'Sale Id shift 102',0.00,0.00,0.00,2263.95,0.00,'2022-06-29 14:45:52','',''),(2828,'21','221','3',1,'Sale Id shift 102',0.00,0.00,0.00,2801.87,0.00,'2022-06-29 14:45:52','',''),(2829,'21','221','3',1,'Sale Id shift 102',0.00,0.00,0.00,1919.33,0.00,'2022-06-29 14:45:52','',''),(2830,'21','221','1',1,'Sale Id shift 102',0.00,0.00,0.00,723.38,0.00,'2022-06-29 14:45:52','',''),(2831,'21','221','4',2,'Sale Id shift 102',0.00,0.00,0.00,37.24,0.00,'2022-06-29 14:45:52','',''),(2832,'21','221','4',2,'Sale Id shift 102',0.00,0.00,0.00,1920.35,0.00,'2022-06-29 14:45:52','',''),(2833,'21','221','4',2,'Sale Id shift 102',0.00,0.00,0.00,1372.34,0.00,'2022-06-29 14:45:52','',''),(2834,'21','221','5',3,'Sale Id shift 102',0.00,0.00,0.00,546.91,0.00,'2022-06-29 14:45:52','',''),(2835,'21','221','3',1,'Sale Id shift 102',0.00,0.00,0.00,2773.22,0.00,'2022-06-29 14:45:52','',''),(2836,'21','221','1',1,'Sale Id shift 102',0.00,0.00,0.00,3877.48,0.00,'2022-06-29 14:45:52','',''),(2837,'21','221','1',1,'Sale Id shift 102',0.00,0.00,0.00,2750.26,0.00,'2022-06-29 14:45:52','',''),(2838,'21','221','2',1,'Sale Id shift 102',0.00,0.00,0.00,3624.64,0.00,'2022-06-29 14:45:52','',''),(2839,'21','221','2',1,'Sale Id shift 102',0.00,0.00,0.00,2143.36,0.00,'2022-06-29 14:45:52','',''),(2840,'21','221','2',1,'Sale Id shift 102',0.00,0.00,0.00,2426.70,0.00,'2022-06-29 14:45:52','',''),(2841,'21','221','2',1,'Sale Id shift 102',0.00,0.00,0.00,1616.42,0.00,'2022-06-29 14:45:52','',''),(2842,'21','221',NULL,1,'Sale Id shift 102',7529578.65,0.00,0.00,0.00,0.00,'2022-06-29 14:45:52','',''),(2843,'21','221',NULL,2,'Sale Id shift 102',2763841.90,0.00,0.00,0.00,0.00,'2022-06-29 14:45:52','',''),(2844,'21','221',NULL,3,'Sale Id shift 102',410182.50,0.00,0.00,0.00,0.00,'2022-06-29 14:45:52','',''),(2845,'21','221',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11250000.00,15000.00,0.00,0.00,'2022-06-29 15:14:17','',''),(2846,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-29 15:16:08','',''),(2847,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12450000.00,15000.00,0.00,0.00,'2022-06-29 15:18:09','',''),(2848,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-29 15:19:58','',''),(2849,'21','221',NULL,1,'Reception corrector for bridging 277',0.00,0.00,0.00,25000.00,0.00,'2022-06-29 15:22:56','',''),(2850,'21','221','3',1,'Received from bridging 277',0.00,0.00,25000.00,0.00,0.00,'2022-06-29 15:22:56','',''),(2851,'21','221',NULL,1,'Reception corrector for bridging 276',0.00,0.00,0.00,25000.00,0.00,'2022-06-29 15:22:56','',''),(2852,'21','221','2',1,'Received from bridging 276',0.00,0.00,25000.00,0.00,0.00,'2022-06-29 15:22:56','',''),(2853,'21','221',NULL,2,'Reception corrector for bridging 275',0.00,0.00,0.00,15000.00,0.00,'2022-06-29 15:23:10','',''),(2854,'21','221','4',2,'Received from bridging 275',0.00,0.00,15000.00,0.00,0.00,'2022-06-29 15:23:10','',''),(2855,'21','221',NULL,1,'Reception corrector for bridging 274',0.00,0.00,0.00,15000.00,0.00,'2022-06-29 15:23:24','',''),(2856,'21','221','3',1,'Received from bridging 274',0.00,0.00,15000.00,0.00,0.00,'2022-06-29 15:23:24','',''),(2857,'21','221',NULL,1,'Reception corrector for bridging 273',0.00,0.00,0.00,15000.00,0.00,'2022-06-29 15:23:24','',''),(2858,'21','221','2',1,'Received from bridging 273',0.00,0.00,15000.00,0.00,0.00,'2022-06-29 15:23:24','',''),(2859,'21','221',NULL,1,'Reception corrector for bridging 272',0.00,0.00,0.00,20000.00,0.00,'2022-06-29 15:23:24','',''),(2860,'21','221','1',1,'Received from bridging 272',0.00,0.00,20000.00,0.00,0.00,'2022-06-29 15:23:24','',''),(2861,'21','221',NULL,3,'Reception corrector for bridging 271',0.00,0.00,0.00,15000.00,0.00,'2022-06-29 15:23:37','',''),(2862,'21','221','5',3,'Received from bridging 271',0.00,0.00,15000.00,0.00,0.00,'2022-06-29 15:23:37','',''),(2863,'21','221','1',1,'Sale Id shift 103',0.00,0.00,0.00,2006.77,0.00,'2022-07-19 14:02:18','',''),(2864,'21','221','2',1,'Sale Id shift 103',0.00,0.00,0.00,5767.60,0.00,'2022-07-19 14:02:18','',''),(2865,'21','221','2',1,'Sale Id shift 103',0.00,0.00,0.00,1984.07,0.00,'2022-07-19 14:02:18','',''),(2866,'21','221','3',1,'Sale Id shift 103',0.00,0.00,0.00,2902.65,0.00,'2022-07-19 14:02:18','',''),(2867,'21','221','3',1,'Sale Id shift 103',0.00,0.00,0.00,2083.89,0.00,'2022-07-19 14:02:18','',''),(2868,'21','221','3',1,'Sale Id shift 103',0.00,0.00,0.00,2525.59,0.00,'2022-07-19 14:02:18','',''),(2869,'21','221','3',1,'Sale Id shift 103',0.00,0.00,0.00,1589.75,0.00,'2022-07-19 14:02:18','',''),(2870,'21','221','3',1,'Sale Id shift 103',0.00,0.00,0.00,2408.25,0.00,'2022-07-19 14:02:18','',''),(2871,'21','221','3',1,'Sale Id shift 103',0.00,0.00,0.00,3237.26,0.00,'2022-07-19 14:02:18','',''),(2872,'21','221','3',1,'Sale Id shift 103',0.00,0.00,0.00,1527.68,0.00,'2022-07-19 14:02:18','',''),(2873,'21','221','1',1,'Sale Id shift 103',0.00,0.00,0.00,1993.02,0.00,'2022-07-19 14:02:18','',''),(2874,'21','221','4',2,'Sale Id shift 103',0.00,0.00,0.00,1461.89,0.00,'2022-07-19 14:02:18','',''),(2875,'21','221','4',2,'Sale Id shift 103',0.00,0.00,0.00,2355.03,0.00,'2022-07-19 14:02:18','',''),(2876,'21','221','4',2,'Sale Id shift 103',0.00,0.00,0.00,7715.33,0.00,'2022-07-19 14:02:18','',''),(2877,'21','221','5',3,'Sale Id shift 103',0.00,0.00,0.00,713.34,0.00,'2022-07-19 14:02:18','',''),(2878,'21','221','3',1,'Sale Id shift 103',0.00,0.00,0.00,3922.44,0.00,'2022-07-19 14:02:18','',''),(2879,'21','221','1',1,'Sale Id shift 103',0.00,0.00,0.00,2809.15,0.00,'2022-07-19 14:02:18','',''),(2880,'21','221','1',1,'Sale Id shift 103',0.00,0.00,0.00,3372.45,0.00,'2022-07-19 14:02:18','',''),(2881,'21','221','2',1,'Sale Id shift 103',0.00,0.00,0.00,3918.65,0.00,'2022-07-19 14:02:18','',''),(2882,'21','221','2',1,'Sale Id shift 103',0.00,0.00,0.00,2038.62,0.00,'2022-07-19 14:02:18','',''),(2883,'21','221','2',1,'Sale Id shift 103',0.00,0.00,0.00,3267.84,0.00,'2022-07-19 14:02:18','',''),(2884,'21','221','2',1,'Sale Id shift 103',0.00,0.00,0.00,3071.11,0.00,'2022-07-19 14:02:18','',''),(2885,'21','221',NULL,1,'Sale Id shift 103',8320420.35,0.00,0.00,0.00,0.00,'2022-07-19 14:02:18','',''),(2886,'21','221',NULL,2,'Sale Id shift 103',9571767.50,0.00,0.00,0.00,0.00,'2022-07-19 14:02:18','',''),(2887,'21','221',NULL,3,'Sale Id shift 103',535005.00,0.00,0.00,0.00,0.00,'2022-07-19 14:02:18','',''),(2888,'21','221','1',1,'Sale Id shift 104',0.00,0.00,0.00,3311.84,0.00,'2022-07-19 16:09:52','',''),(2889,'21','221','2',1,'Sale Id shift 104',0.00,0.00,0.00,5889.37,0.00,'2022-07-19 16:09:52','',''),(2890,'21','221','2',1,'Sale Id shift 104',0.00,0.00,0.00,3125.64,0.00,'2022-07-19 16:09:52','',''),(2891,'21','221','3',1,'Sale Id shift 104',0.00,0.00,0.00,2321.17,0.00,'2022-07-19 16:09:52','',''),(2892,'21','221','3',1,'Sale Id shift 104',0.00,0.00,0.00,1947.87,0.00,'2022-07-19 16:09:52','',''),(2893,'21','221','3',1,'Sale Id shift 104',0.00,0.00,0.00,1595.67,0.00,'2022-07-19 16:09:52','',''),(2894,'21','221','3',1,'Sale Id shift 104',0.00,0.00,0.00,2754.36,0.00,'2022-07-19 16:09:52','',''),(2895,'21','221','3',1,'Sale Id shift 104',0.00,0.00,0.00,2298.26,0.00,'2022-07-19 16:09:52','',''),(2896,'21','221','3',1,'Sale Id shift 104',0.00,0.00,0.00,2537.73,0.00,'2022-07-19 16:09:52','',''),(2897,'21','221','3',1,'Sale Id shift 104',0.00,0.00,0.00,2341.46,0.00,'2022-07-19 16:09:52','',''),(2898,'21','221','1',1,'Sale Id shift 104',0.00,0.00,0.00,2649.30,0.00,'2022-07-19 16:09:52','',''),(2899,'21','221','4',2,'Sale Id shift 104',0.00,0.00,0.00,1028.97,0.00,'2022-07-19 16:09:52','',''),(2900,'21','221','4',2,'Sale Id shift 104',0.00,0.00,0.00,5753.62,0.00,'2022-07-19 16:09:52','',''),(2901,'21','221','5',3,'Sale Id shift 104',0.00,0.00,0.00,415.67,0.00,'2022-07-19 16:09:52','',''),(2902,'21','221','5',3,'Sale Id shift 104',0.00,0.00,0.00,514.59,0.00,'2022-07-19 16:09:52','',''),(2903,'21','221','3',1,'Sale Id shift 104',0.00,0.00,0.00,2205.16,0.00,'2022-07-19 16:09:52','',''),(2904,'21','221','1',1,'Sale Id shift 104',0.00,0.00,0.00,2767.84,0.00,'2022-07-19 16:09:52','',''),(2905,'21','221','1',1,'Sale Id shift 104',0.00,0.00,0.00,3312.42,0.00,'2022-07-19 16:09:52','',''),(2906,'21','221','2',1,'Sale Id shift 104',0.00,0.00,0.00,3840.06,0.00,'2022-07-19 16:09:52','',''),(2907,'21','221','2',1,'Sale Id shift 104',0.00,0.00,0.00,2541.76,0.00,'2022-07-19 16:09:52','',''),(2908,'21','221','2',1,'Sale Id shift 104',0.00,0.00,0.00,2281.97,0.00,'2022-07-19 16:09:52','',''),(2909,'21','221','2',1,'Sale Id shift 104',0.00,0.00,0.00,2648.52,0.00,'2022-07-19 16:09:52','',''),(2910,'21','221',NULL,1,'Sale Id shift 104',8311116.00,0.00,0.00,0.00,0.00,'2022-07-19 16:09:52','',''),(2911,'21','221',NULL,2,'Sale Id shift 104',5629549.70,0.00,0.00,0.00,0.00,'2022-07-19 16:09:52','',''),(2912,'21','221',NULL,3,'Sale Id shift 104',697695.00,0.00,0.00,0.00,0.00,'2022-07-19 16:09:52','',''),(2913,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-19 16:43:16','',''),(2914,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-07-19 16:48:27','',''),(2915,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24900000.00,30000.00,0.00,0.00,'2022-07-19 16:51:27','',''),(2916,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-19 16:55:43','',''),(2917,'21','221',NULL,1,'Reception corrector for bridging 279',0.00,0.00,0.00,25000.00,0.00,'2022-07-19 16:56:13','',''),(2918,'21','221','2',1,'Received from bridging 279',0.00,0.00,25000.00,0.00,0.00,'2022-07-19 16:56:13','',''),(2919,'21','221',NULL,1,'Reception corrector for bridging 278',0.00,0.00,0.00,20000.00,0.00,'2022-07-19 16:56:13','',''),(2920,'21','221','1',1,'Received from bridging 278',0.00,0.00,20000.00,0.00,0.00,'2022-07-19 16:56:13','',''),(2921,'21','221',NULL,1,'Reception corrector for bridging 280',0.00,0.00,0.00,60000.00,0.00,'2022-07-19 16:56:25','',''),(2922,'21','221','3',1,'Received from bridging 280',0.00,0.00,60000.00,0.00,0.00,'2022-07-19 16:56:25','',''),(2923,'21','221',NULL,2,'Reception corrector for bridging 281',0.00,0.00,0.00,20000.00,0.00,'2022-07-19 16:56:42','',''),(2924,'21','221','4',2,'Received from bridging 281',0.00,0.00,20000.00,0.00,0.00,'2022-07-19 16:56:42','',''),(2925,'21','221',NULL,1,'Reception corrector for bridging 283',0.00,0.00,0.00,30000.00,0.00,'2022-07-19 16:58:57','',''),(2926,'21','221','2',1,'Received from bridging 283',0.00,0.00,30000.00,0.00,0.00,'2022-07-19 16:58:57','',''),(2927,'21','221',NULL,1,'Reception corrector for bridging 282',0.00,0.00,0.00,15000.00,0.00,'2022-07-19 16:58:57','',''),(2928,'21','221','1',1,'Received from bridging 282',0.00,0.00,15000.00,0.00,0.00,'2022-07-19 16:58:57','',''),(2929,'21','221','1',1,'Sale Id shift 105',0.00,0.00,0.00,2765.54,0.00,'2022-07-19 17:59:57','',''),(2930,'21','221','2',1,'Sale Id shift 105',0.00,0.00,0.00,4708.00,0.00,'2022-07-19 17:59:57','',''),(2931,'21','221','2',1,'Sale Id shift 105',0.00,0.00,0.00,2560.10,0.00,'2022-07-19 17:59:57','',''),(2932,'21','221','3',1,'Sale Id shift 105',0.00,0.00,0.00,2383.09,0.00,'2022-07-19 17:59:57','',''),(2933,'21','221','3',1,'Sale Id shift 105',0.00,0.00,0.00,2120.09,0.00,'2022-07-19 17:59:57','',''),(2934,'21','221','3',1,'Sale Id shift 105',0.00,0.00,0.00,2505.78,0.00,'2022-07-19 17:59:57','',''),(2935,'21','221','3',1,'Sale Id shift 105',0.00,0.00,0.00,2232.11,0.00,'2022-07-19 17:59:57','',''),(2936,'21','221','3',1,'Sale Id shift 105',0.00,0.00,0.00,2912.94,0.00,'2022-07-19 17:59:57','',''),(2937,'21','221','3',1,'Sale Id shift 105',0.00,0.00,0.00,3282.88,0.00,'2022-07-19 17:59:57','',''),(2938,'21','221','3',1,'Sale Id shift 105',0.00,0.00,0.00,1659.10,0.00,'2022-07-19 17:59:57','',''),(2939,'21','221','1',1,'Sale Id shift 105',0.00,0.00,0.00,2260.18,0.00,'2022-07-19 17:59:57','',''),(2940,'21','221','4',2,'Sale Id shift 105',0.00,0.00,0.00,2049.33,0.00,'2022-07-19 17:59:57','',''),(2941,'21','221','4',2,'Sale Id shift 105',0.00,0.00,0.00,4510.23,0.00,'2022-07-19 17:59:57','',''),(2942,'21','221','5',3,'Sale Id shift 105',0.00,0.00,0.00,712.31,0.00,'2022-07-19 17:59:57','',''),(2943,'21','221','3',1,'Sale Id shift 105',0.00,0.00,0.00,3962.59,0.00,'2022-07-19 17:59:57','',''),(2944,'21','221','1',1,'Sale Id shift 105',0.00,0.00,0.00,2475.18,0.00,'2022-07-19 17:59:57','',''),(2945,'21','221','1',1,'Sale Id shift 105',0.00,0.00,0.00,3103.35,0.00,'2022-07-19 17:59:57','',''),(2946,'21','221','2',1,'Sale Id shift 105',0.00,0.00,0.00,3953.30,0.00,'2022-07-19 17:59:57','',''),(2947,'21','221','2',1,'Sale Id shift 105',0.00,0.00,0.00,1944.95,0.00,'2022-07-19 17:59:57','',''),(2948,'21','221','2',1,'Sale Id shift 105',0.00,0.00,0.00,2195.72,0.00,'2022-07-19 17:59:57','',''),(2949,'21','221','2',1,'Sale Id shift 105',0.00,0.00,0.00,2623.94,0.00,'2022-07-19 17:59:57','',''),(2950,'21','221',NULL,1,'Sale Id shift 105',8192058.60,0.00,0.00,0.00,0.00,'2022-07-19 17:59:57','',''),(2951,'21','221',NULL,2,'Sale Id shift 105',5444434.80,0.00,0.00,0.00,0.00,'2022-07-19 17:59:57','',''),(2952,'21','221',NULL,3,'Sale Id shift 105',534232.50,0.00,0.00,0.00,0.00,'2022-07-19 17:59:57','',''),(2953,'21','221','1',1,'Sale Id shift 106',0.00,0.00,0.00,2343.10,0.00,'2022-07-19 19:19:03','',''),(2954,'21','221','2',1,'Sale Id shift 106',0.00,0.00,0.00,4567.64,0.00,'2022-07-19 19:19:03','',''),(2955,'21','221','2',1,'Sale Id shift 106',0.00,0.00,0.00,2931.94,0.00,'2022-07-19 19:19:03','',''),(2956,'21','221','3',1,'Sale Id shift 106',0.00,0.00,0.00,2450.12,0.00,'2022-07-19 19:19:03','',''),(2957,'21','221','3',1,'Sale Id shift 106',0.00,0.00,0.00,1686.72,0.00,'2022-07-19 19:19:03','',''),(2958,'21','221','3',1,'Sale Id shift 106',0.00,0.00,0.00,2003.70,0.00,'2022-07-19 19:19:03','',''),(2959,'21','221','3',1,'Sale Id shift 106',0.00,0.00,0.00,1967.33,0.00,'2022-07-19 19:19:03','',''),(2960,'21','221','3',1,'Sale Id shift 106',0.00,0.00,0.00,2706.85,0.00,'2022-07-19 19:19:03','',''),(2961,'21','221','3',1,'Sale Id shift 106',0.00,0.00,0.00,2496.11,0.00,'2022-07-19 19:19:03','',''),(2962,'21','221','3',1,'Sale Id shift 106',0.00,0.00,0.00,1284.66,0.00,'2022-07-19 19:19:03','',''),(2963,'21','221','1',1,'Sale Id shift 106',0.00,0.00,0.00,2193.52,0.00,'2022-07-19 19:19:03','',''),(2964,'21','221','4',2,'Sale Id shift 106',0.00,0.00,0.00,4040.06,0.00,'2022-07-19 19:19:03','',''),(2965,'21','221','4',2,'Sale Id shift 106',0.00,0.00,0.00,5861.64,0.00,'2022-07-19 19:19:03','',''),(2966,'21','221','5',3,'Sale Id shift 106',0.00,0.00,0.00,610.14,0.00,'2022-07-19 19:19:03','',''),(2967,'21','221','3',1,'Sale Id shift 106',0.00,0.00,0.00,3396.02,0.00,'2022-07-19 19:19:03','',''),(2968,'21','221','1',1,'Sale Id shift 106',0.00,0.00,0.00,2338.44,0.00,'2022-07-19 19:19:03','',''),(2969,'21','221','1',1,'Sale Id shift 106',0.00,0.00,0.00,3115.71,0.00,'2022-07-19 19:19:03','',''),(2970,'21','221','2',1,'Sale Id shift 106',0.00,0.00,0.00,3667.76,0.00,'2022-07-19 19:19:03','',''),(2971,'21','221','2',1,'Sale Id shift 106',0.00,0.00,0.00,2502.99,0.00,'2022-07-19 19:19:03','',''),(2972,'21','221','2',1,'Sale Id shift 106',0.00,0.00,0.00,2517.25,0.00,'2022-07-19 19:19:03','',''),(2973,'21','221','2',1,'Sale Id shift 106',0.00,0.00,0.00,1711.55,0.00,'2022-07-19 19:19:03','',''),(2974,'21','221',NULL,1,'Sale Id shift 106',7570432.65,0.00,0.00,0.00,0.00,'2022-07-19 19:19:03','',''),(2975,'21','221',NULL,2,'Sale Id shift 106',8218411.00,0.00,0.00,0.00,0.00,'2022-07-19 19:19:03','',''),(2976,'21','221',NULL,3,'Sale Id shift 106',457605.00,0.00,0.00,0.00,0.00,'2022-07-19 19:19:03','',''),(2977,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-07-20 17:29:43','',''),(2978,'21','221',NULL,1,'Reception corrector for bridging 286',0.00,0.00,0.00,20000.00,0.00,'2022-07-20 17:34:04','',''),(2979,'21','221','3',1,'Received from bridging 286',0.00,0.00,20000.00,0.00,0.00,'2022-07-20 17:34:04','',''),(2980,'21','221',NULL,1,'Reception corrector for bridging 285',0.00,0.00,0.00,20000.00,0.00,'2022-07-20 17:34:04','',''),(2981,'21','221','2',1,'Received from bridging 285',0.00,0.00,20000.00,0.00,0.00,'2022-07-20 17:34:04','',''),(2982,'21','221',NULL,1,'Reception corrector for bridging 284',0.00,0.00,0.00,20000.00,0.00,'2022-07-20 17:34:04','',''),(2983,'21','221','1',1,'Received from bridging 284',0.00,0.00,20000.00,0.00,0.00,'2022-07-20 17:34:04','',''),(2984,'21','221',NULL,2,'Reception corrector for bridging 287',0.00,0.00,0.00,10000.00,0.00,'2022-07-20 19:18:36','',''),(2985,'21','221','4',2,'Received from bridging 287',0.00,0.00,10000.00,0.00,0.00,'2022-07-20 19:18:36','',''),(2986,'21','221','1',1,'Sale Id shift 107',0.00,0.00,0.00,3920.09,0.00,'2022-07-20 20:42:44','',''),(2987,'21','221','2',1,'Sale Id shift 107',0.00,0.00,0.00,6665.74,0.00,'2022-07-20 20:42:44','',''),(2988,'21','221','2',1,'Sale Id shift 107',0.00,0.00,0.00,3323.95,0.00,'2022-07-20 20:42:44','',''),(2989,'21','221','3',1,'Sale Id shift 107',0.00,0.00,0.00,2839.16,0.00,'2022-07-20 20:42:44','',''),(2990,'21','221','3',1,'Sale Id shift 107',0.00,0.00,0.00,1990.67,0.00,'2022-07-20 20:42:44','',''),(2991,'21','221','3',1,'Sale Id shift 107',0.00,0.00,0.00,3084.11,0.00,'2022-07-20 20:42:44','',''),(2992,'21','221','3',1,'Sale Id shift 107',0.00,0.00,0.00,1848.62,0.00,'2022-07-20 20:42:44','',''),(2993,'21','221','3',1,'Sale Id shift 107',0.00,0.00,0.00,2743.15,0.00,'2022-07-20 20:42:44','',''),(2994,'21','221','3',1,'Sale Id shift 107',0.00,0.00,0.00,3298.87,0.00,'2022-07-20 20:42:44','',''),(2995,'21','221','3',1,'Sale Id shift 107',0.00,0.00,0.00,2485.45,0.00,'2022-07-20 20:42:44','',''),(2996,'21','221','1',1,'Sale Id shift 107',0.00,0.00,0.00,2062.64,0.00,'2022-07-20 20:42:44','',''),(2997,'21','221','4',2,'Sale Id shift 107',0.00,0.00,0.00,3332.07,0.00,'2022-07-20 20:42:44','',''),(2998,'21','221','4',2,'Sale Id shift 107',0.00,0.00,0.00,2456.44,0.00,'2022-07-20 20:42:44','',''),(2999,'21','221','5',3,'Sale Id shift 107',0.00,0.00,0.00,587.48,0.00,'2022-07-20 20:42:44','',''),(3000,'21','221','3',1,'Sale Id shift 107',0.00,0.00,0.00,4216.28,0.00,'2022-07-20 20:42:44','',''),(3001,'21','221','1',1,'Sale Id shift 107',0.00,0.00,0.00,2289.13,0.00,'2022-07-20 20:42:44','',''),(3002,'21','221','1',1,'Sale Id shift 107',0.00,0.00,0.00,4211.16,0.00,'2022-07-20 20:42:44','',''),(3003,'21','221','2',1,'Sale Id shift 107',0.00,0.00,0.00,4588.18,0.00,'2022-07-20 20:42:44','',''),(3004,'21','221','2',1,'Sale Id shift 107',0.00,0.00,0.00,2232.09,0.00,'2022-07-20 20:42:44','',''),(3005,'21','221','2',1,'Sale Id shift 107',0.00,0.00,0.00,4522.59,0.00,'2022-07-20 20:42:44','',''),(3006,'21','221','2',1,'Sale Id shift 107',0.00,0.00,0.00,2475.12,0.00,'2022-07-20 20:42:44','',''),(3007,'21','221',NULL,1,'Sale Id shift 107',9701505.00,0.00,0.00,0.00,0.00,'2022-07-20 20:42:44','',''),(3008,'21','221',NULL,2,'Sale Id shift 107',4804463.30,0.00,0.00,0.00,0.00,'2022-07-20 20:42:44','',''),(3009,'21','221',NULL,3,'Sale Id shift 107',440610.00,0.00,0.00,0.00,0.00,'2022-07-20 20:42:44','',''),(3010,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-21 13:35:14','',''),(3011,'21','221',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12525000.00,16700.00,0.00,0.00,'2022-07-21 13:40:56','',''),(3012,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-21 13:44:35','',''),(3013,'21','221',NULL,1,'Reception corrector for bridging 290',0.00,0.00,0.00,20000.00,0.00,'2022-07-21 13:47:43','',''),(3014,'21','221','3',1,'Received from bridging 290',0.00,0.00,20000.00,0.00,0.00,'2022-07-21 13:47:43','',''),(3015,'21','221',NULL,1,'Reception corrector for bridging 289',0.00,0.00,0.00,20000.00,0.00,'2022-07-21 13:47:43','',''),(3016,'21','221','2',1,'Received from bridging 289',0.00,0.00,20000.00,0.00,0.00,'2022-07-21 13:47:43','',''),(3017,'21','221',NULL,1,'Reception corrector for bridging 288',0.00,0.00,0.00,10000.00,0.00,'2022-07-21 13:47:43','',''),(3018,'21','221','1',1,'Received from bridging 288',0.00,0.00,10000.00,0.00,0.00,'2022-07-21 13:47:43','',''),(3019,'21','221',NULL,3,'Reception corrector for bridging 291',0.00,0.00,0.00,16700.00,0.00,'2022-07-21 13:47:53','',''),(3020,'21','221','5',3,'Received from bridging 291',0.00,0.00,16700.00,0.00,0.00,'2022-07-21 13:47:53','',''),(3021,'21','221',NULL,1,'Reception corrector for bridging 293',0.00,0.00,0.00,27000.00,0.00,'2022-07-21 13:48:06','',''),(3022,'21','221','3',1,'Received from bridging 293',0.00,0.00,27000.00,0.00,0.00,'2022-07-21 13:48:06','',''),(3023,'21','221',NULL,1,'Reception corrector for bridging 292',0.00,0.00,0.00,23000.00,0.00,'2022-07-21 13:48:06','',''),(3024,'21','221','2',1,'Received from bridging 292',0.00,0.00,23000.00,0.00,0.00,'2022-07-21 13:48:06','',''),(3025,'21','221','1',1,'Sale Id shift 108',0.00,0.00,0.00,1665.53,0.00,'2022-07-21 15:42:19','',''),(3026,'21','221','2',1,'Sale Id shift 108',0.00,0.00,0.00,2430.54,0.00,'2022-07-21 15:42:19','',''),(3027,'21','221','2',1,'Sale Id shift 108',0.00,0.00,0.00,1520.78,0.00,'2022-07-21 15:42:19','',''),(3028,'21','221','3',1,'Sale Id shift 108',0.00,0.00,0.00,1490.01,0.00,'2022-07-21 15:42:19','',''),(3029,'21','221','3',1,'Sale Id shift 108',0.00,0.00,0.00,1299.25,0.00,'2022-07-21 15:42:19','',''),(3030,'21','221','3',1,'Sale Id shift 108',0.00,0.00,0.00,1856.63,0.00,'2022-07-21 15:42:19','',''),(3031,'21','221','3',1,'Sale Id shift 108',0.00,0.00,0.00,1355.08,0.00,'2022-07-21 15:42:19','',''),(3032,'21','221','3',1,'Sale Id shift 108',0.00,0.00,0.00,1774.74,0.00,'2022-07-21 15:42:19','',''),(3033,'21','221','3',1,'Sale Id shift 108',0.00,0.00,0.00,2550.31,0.00,'2022-07-21 15:42:19','',''),(3034,'21','221','3',1,'Sale Id shift 108',0.00,0.00,0.00,1126.67,0.00,'2022-07-21 15:42:19','',''),(3035,'21','221','1',1,'Sale Id shift 108',0.00,0.00,0.00,1796.63,0.00,'2022-07-21 15:42:19','',''),(3036,'21','221','4',2,'Sale Id shift 108',0.00,0.00,0.00,5681.71,0.00,'2022-07-21 15:42:19','',''),(3037,'21','221','4',2,'Sale Id shift 108',0.00,0.00,0.00,4263.01,0.00,'2022-07-21 15:42:19','',''),(3038,'21','221','5',3,'Sale Id shift 108',0.00,0.00,0.00,735.69,0.00,'2022-07-21 15:42:19','',''),(3039,'21','221','3',1,'Sale Id shift 108',0.00,0.00,0.00,1532.46,0.00,'2022-07-21 15:42:19','',''),(3040,'21','221','1',1,'Sale Id shift 108',0.00,0.00,0.00,1389.86,0.00,'2022-07-21 15:42:19','',''),(3041,'21','221','1',1,'Sale Id shift 108',0.00,0.00,0.00,1727.08,0.00,'2022-07-21 15:42:19','',''),(3042,'21','221','2',1,'Sale Id shift 108',0.00,0.00,0.00,1929.31,0.00,'2022-07-21 15:42:19','',''),(3043,'21','221','2',1,'Sale Id shift 108',0.00,0.00,0.00,1563.80,0.00,'2022-07-21 15:42:19','',''),(3044,'21','221','2',1,'Sale Id shift 108',0.00,0.00,0.00,1524.64,0.00,'2022-07-21 15:42:19','',''),(3045,'21','221','2',1,'Sale Id shift 108',0.00,0.00,0.00,1969.14,0.00,'2022-07-21 15:42:19','',''),(3046,'21','221',NULL,1,'Sale Id shift 108',5032905.90,0.00,0.00,0.00,0.00,'2022-07-21 15:42:19','',''),(3047,'21','221',NULL,2,'Sale Id shift 108',8254117.60,0.00,0.00,0.00,0.00,'2022-07-21 15:42:19','',''),(3048,'21','221',NULL,3,'Sale Id shift 108',551767.50,0.00,0.00,0.00,0.00,'2022-07-21 15:42:19','',''),(3049,'21','221','1',1,'Sale Id shift 109',0.00,0.00,0.00,3826.74,0.00,'2022-07-21 17:11:21','',''),(3050,'21','221','2',1,'Sale Id shift 109',0.00,0.00,0.00,5804.86,0.00,'2022-07-21 17:11:21','',''),(3051,'21','221','2',1,'Sale Id shift 109',0.00,0.00,0.00,3589.05,0.00,'2022-07-21 17:11:21','',''),(3052,'21','221','3',1,'Sale Id shift 109',0.00,0.00,0.00,2640.72,0.00,'2022-07-21 17:11:21','',''),(3053,'21','221','3',1,'Sale Id shift 109',0.00,0.00,0.00,2390.24,0.00,'2022-07-21 17:11:21','',''),(3054,'21','221','3',1,'Sale Id shift 109',0.00,0.00,0.00,2676.38,0.00,'2022-07-21 17:11:21','',''),(3055,'21','221','3',1,'Sale Id shift 109',0.00,0.00,0.00,2723.25,0.00,'2022-07-21 17:11:21','',''),(3056,'21','221','3',1,'Sale Id shift 109',0.00,0.00,0.00,3555.17,0.00,'2022-07-21 17:11:21','',''),(3057,'21','221','3',1,'Sale Id shift 109',0.00,0.00,0.00,3784.07,0.00,'2022-07-21 17:11:21','',''),(3058,'21','221','3',1,'Sale Id shift 109',0.00,0.00,0.00,3022.60,0.00,'2022-07-21 17:11:21','',''),(3059,'21','221','1',1,'Sale Id shift 109',0.00,0.00,0.00,3075.09,0.00,'2022-07-21 17:11:21','',''),(3060,'21','221','4',2,'Sale Id shift 109',0.00,0.00,0.00,2970.00,0.00,'2022-07-21 17:11:21','',''),(3061,'21','221','4',2,'Sale Id shift 109',0.00,0.00,0.00,1262.37,0.00,'2022-07-21 17:11:21','',''),(3062,'21','221','5',3,'Sale Id shift 109',0.00,0.00,0.00,584.06,0.00,'2022-07-21 17:11:21','',''),(3063,'21','221','3',1,'Sale Id shift 109',0.00,0.00,0.00,4108.34,0.00,'2022-07-21 17:11:21','',''),(3064,'21','221','1',1,'Sale Id shift 109',0.00,0.00,0.00,2764.15,0.00,'2022-07-21 17:11:21','',''),(3065,'21','221','1',1,'Sale Id shift 109',0.00,0.00,0.00,3355.09,0.00,'2022-07-21 17:11:21','',''),(3066,'21','221','2',1,'Sale Id shift 109',0.00,0.00,0.00,5530.07,0.00,'2022-07-21 17:11:21','',''),(3067,'21','221','2',1,'Sale Id shift 109',0.00,0.00,0.00,3603.82,0.00,'2022-07-21 17:11:21','',''),(3068,'21','221','2',1,'Sale Id shift 109',0.00,0.00,0.00,4652.81,0.00,'2022-07-21 17:11:21','',''),(3069,'21','221','2',1,'Sale Id shift 109',0.00,0.00,0.00,3076.13,0.00,'2022-07-21 17:11:21','',''),(3070,'21','221',NULL,1,'Sale Id shift 109',10589465.70,0.00,0.00,0.00,0.00,'2022-07-21 17:11:21','',''),(3071,'21','221',NULL,2,'Sale Id shift 109',3512867.10,0.00,0.00,0.00,0.00,'2022-07-21 17:11:21','',''),(3072,'21','221',NULL,3,'Sale Id shift 109',438045.00,0.00,0.00,0.00,0.00,'2022-07-21 17:11:21','',''),(3073,'21','221','1',1,'Sale Id shift 110',0.00,0.00,0.00,2253.51,0.00,'2022-07-21 19:45:32','',''),(3074,'21','221','2',1,'Sale Id shift 110',0.00,0.00,0.00,4170.34,0.00,'2022-07-21 19:45:32','',''),(3075,'21','221','2',1,'Sale Id shift 110',0.00,0.00,0.00,1937.52,0.00,'2022-07-21 19:45:32','',''),(3076,'21','221','3',1,'Sale Id shift 110',0.00,0.00,0.00,1843.86,0.00,'2022-07-21 19:45:32','',''),(3077,'21','221','3',1,'Sale Id shift 110',0.00,0.00,0.00,2128.07,0.00,'2022-07-21 19:45:32','',''),(3078,'21','221','3',1,'Sale Id shift 110',0.00,0.00,0.00,3125.65,0.00,'2022-07-21 19:45:32','',''),(3079,'21','221','3',1,'Sale Id shift 110',0.00,0.00,0.00,2201.68,0.00,'2022-07-21 19:45:32','',''),(3080,'21','221','3',1,'Sale Id shift 110',0.00,0.00,0.00,1905.49,0.00,'2022-07-21 19:45:32','',''),(3081,'21','221','3',1,'Sale Id shift 110',0.00,0.00,0.00,2934.78,0.00,'2022-07-21 19:45:32','',''),(3082,'21','221','3',1,'Sale Id shift 110',0.00,0.00,0.00,2158.51,0.00,'2022-07-21 19:45:32','',''),(3083,'21','221','1',1,'Sale Id shift 110',0.00,0.00,0.00,2994.76,0.00,'2022-07-21 19:45:32','',''),(3084,'21','221','4',2,'Sale Id shift 110',0.00,0.00,0.00,3397.70,0.00,'2022-07-21 19:45:32','',''),(3085,'21','221','4',2,'Sale Id shift 110',0.00,0.00,0.00,5031.72,0.00,'2022-07-21 19:45:32','',''),(3086,'21','221','5',3,'Sale Id shift 110',0.00,0.00,0.00,776.24,0.00,'2022-07-21 19:45:32','',''),(3087,'21','221','3',1,'Sale Id shift 110',0.00,0.00,0.00,5054.16,0.00,'2022-07-21 19:45:32','',''),(3088,'21','221','1',1,'Sale Id shift 110',0.00,0.00,0.00,2290.44,0.00,'2022-07-21 19:45:32','',''),(3089,'21','221','1',1,'Sale Id shift 110',0.00,0.00,0.00,2420.92,0.00,'2022-07-21 19:45:32','',''),(3090,'21','221','2',1,'Sale Id shift 110',0.00,0.00,0.00,3517.82,0.00,'2022-07-21 19:45:32','',''),(3091,'21','221','2',1,'Sale Id shift 110',0.00,0.00,0.00,2683.24,0.00,'2022-07-21 19:45:32','',''),(3092,'21','221','2',1,'Sale Id shift 110',0.00,0.00,0.00,3429.60,0.00,'2022-07-21 19:45:32','',''),(3093,'21','221','2',1,'Sale Id shift 110',0.00,0.00,0.00,2684.36,0.00,'2022-07-21 19:45:32','',''),(3094,'21','221',NULL,1,'Sale Id shift 110',8206227.15,0.00,0.00,0.00,0.00,'2022-07-21 19:45:32','',''),(3095,'21','221',NULL,2,'Sale Id shift 110',6996418.60,0.00,0.00,0.00,0.00,'2022-07-21 19:45:32','',''),(3096,'21','221',NULL,3,'Sale Id shift 110',582180.00,0.00,0.00,0.00,0.00,'2022-07-21 19:45:32','',''),(3097,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-22 15:02:39','',''),(3098,'21','221',NULL,1,'Reception corrector for bridging 295',0.00,0.00,0.00,20000.00,0.00,'2022-07-22 15:04:18','',''),(3099,'21','221','3',1,'Received from bridging 295',0.00,0.00,20000.00,0.00,0.00,'2022-07-22 15:04:18','',''),(3100,'21','221',NULL,1,'Reception corrector for bridging 294',0.00,0.00,0.00,30000.00,0.00,'2022-07-22 15:04:18','',''),(3101,'21','221','1',1,'Received from bridging 294',0.00,0.00,30000.00,0.00,0.00,'2022-07-22 15:04:18','',''),(3102,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12450000.00,15000.00,0.00,0.00,'2022-07-22 15:04:31','',''),(3103,'21','221',NULL,2,'Reception corrector for bridging 296',0.00,0.00,0.00,15000.00,0.00,'2022-07-22 15:06:28','',''),(3104,'21','221','4',2,'Received from bridging 296',0.00,0.00,15000.00,0.00,0.00,'2022-07-22 15:06:28','',''),(3105,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-22 15:06:40','',''),(3106,'21','221',NULL,1,'Reception corrector for bridging 297',0.00,0.00,0.00,50000.00,0.00,'2022-07-22 15:09:59','',''),(3107,'21','221','2',1,'Received from bridging 297',0.00,0.00,50000.00,0.00,0.00,'2022-07-22 15:09:59','',''),(3108,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-22 15:10:13','',''),(3109,'21','221',NULL,1,'Reception corrector for bridging 299',0.00,0.00,0.00,40000.00,0.00,'2022-07-22 15:12:11','',''),(3110,'21','221','3',1,'Received from bridging 299',0.00,0.00,40000.00,0.00,0.00,'2022-07-22 15:12:11','',''),(3111,'21','221',NULL,1,'Reception corrector for bridging 298',0.00,0.00,0.00,10000.00,0.00,'2022-07-22 15:12:11','',''),(3112,'21','221','2',1,'Received from bridging 298',0.00,0.00,10000.00,0.00,0.00,'2022-07-22 15:12:11','',''),(3113,'21','221','1',1,'Sale Id shift 111',0.00,0.00,0.00,2807.39,0.00,'2022-07-22 17:45:50','',''),(3114,'21','221','2',1,'Sale Id shift 111',0.00,0.00,0.00,4387.09,0.00,'2022-07-22 17:45:50','',''),(3115,'21','221','2',1,'Sale Id shift 111',0.00,0.00,0.00,2804.02,0.00,'2022-07-22 17:45:50','',''),(3116,'21','221','3',1,'Sale Id shift 111',0.00,0.00,0.00,1761.84,0.00,'2022-07-22 17:45:50','',''),(3117,'21','221','3',1,'Sale Id shift 111',0.00,0.00,0.00,1146.58,0.00,'2022-07-22 17:45:50','',''),(3118,'21','221','3',1,'Sale Id shift 111',0.00,0.00,0.00,1880.04,0.00,'2022-07-22 17:45:50','',''),(3119,'21','221','3',1,'Sale Id shift 111',0.00,0.00,0.00,1496.16,0.00,'2022-07-22 17:45:50','',''),(3120,'21','221','3',1,'Sale Id shift 111',0.00,0.00,0.00,1874.88,0.00,'2022-07-22 17:45:50','',''),(3121,'21','221','3',1,'Sale Id shift 111',0.00,0.00,0.00,3131.32,0.00,'2022-07-22 17:45:50','',''),(3122,'21','221','3',1,'Sale Id shift 111',0.00,0.00,0.00,1525.79,0.00,'2022-07-22 17:45:50','',''),(3123,'21','221','1',1,'Sale Id shift 111',0.00,0.00,0.00,2747.57,0.00,'2022-07-22 17:45:50','',''),(3124,'21','221','4',2,'Sale Id shift 111',0.00,0.00,0.00,5552.75,0.00,'2022-07-22 17:45:50','',''),(3125,'21','221','4',2,'Sale Id shift 111',0.00,0.00,0.00,4940.85,0.00,'2022-07-22 17:45:50','',''),(3126,'21','221','5',3,'Sale Id shift 111',0.00,0.00,0.00,712.01,0.00,'2022-07-22 17:45:50','',''),(3127,'21','221','3',1,'Sale Id shift 111',0.00,0.00,0.00,3418.15,0.00,'2022-07-22 17:45:50','',''),(3128,'21','221','1',1,'Sale Id shift 111',0.00,0.00,0.00,2713.19,0.00,'2022-07-22 17:45:50','',''),(3129,'21','221','1',1,'Sale Id shift 111',0.00,0.00,0.00,2592.51,0.00,'2022-07-22 17:45:50','',''),(3130,'21','221','2',1,'Sale Id shift 111',0.00,0.00,0.00,3295.32,0.00,'2022-07-22 17:45:50','',''),(3131,'21','221','2',1,'Sale Id shift 111',0.00,0.00,0.00,1927.54,0.00,'2022-07-22 17:45:50','',''),(3132,'21','221','2',1,'Sale Id shift 111',0.00,0.00,0.00,3923.23,0.00,'2022-07-22 17:45:50','',''),(3133,'21','221','2',1,'Sale Id shift 111',0.00,0.00,0.00,2812.00,0.00,'2022-07-22 17:45:50','',''),(3134,'21','221',NULL,1,'Sale Id shift 111',7630362.30,0.00,0.00,0.00,0.00,'2022-07-22 17:45:50','',''),(3135,'21','221',NULL,2,'Sale Id shift 111',8709688.00,0.00,0.00,0.00,0.00,'2022-07-22 17:45:50','',''),(3136,'21','221',NULL,3,'Sale Id shift 111',534007.50,0.00,0.00,0.00,0.00,'2022-07-22 17:45:50','',''),(3137,'21','221','1',1,'Sale Id shift 112',0.00,0.00,0.00,2347.54,0.00,'2022-07-22 19:24:40','',''),(3138,'21','221','2',1,'Sale Id shift 112',0.00,0.00,0.00,4694.13,0.00,'2022-07-22 19:24:40','',''),(3139,'21','221','2',1,'Sale Id shift 112',0.00,0.00,0.00,2229.98,0.00,'2022-07-22 19:24:40','',''),(3140,'21','221','3',1,'Sale Id shift 112',0.00,0.00,0.00,1853.77,0.00,'2022-07-22 19:24:40','',''),(3141,'21','221','3',1,'Sale Id shift 112',0.00,0.00,0.00,1275.26,0.00,'2022-07-22 19:24:40','',''),(3142,'21','221','3',1,'Sale Id shift 112',0.00,0.00,0.00,1541.96,0.00,'2022-07-22 19:24:40','',''),(3143,'21','221','3',1,'Sale Id shift 112',0.00,0.00,0.00,1923.50,0.00,'2022-07-22 19:24:40','',''),(3144,'21','221','3',1,'Sale Id shift 112',0.00,0.00,0.00,2449.59,0.00,'2022-07-22 19:24:40','',''),(3145,'21','221','3',1,'Sale Id shift 112',0.00,0.00,0.00,3629.89,0.00,'2022-07-22 19:24:40','',''),(3146,'21','221','3',1,'Sale Id shift 112',0.00,0.00,0.00,1177.43,0.00,'2022-07-22 19:24:40','',''),(3147,'21','221','1',1,'Sale Id shift 112',0.00,0.00,0.00,2862.31,0.00,'2022-07-22 19:24:40','',''),(3148,'21','221','4',2,'Sale Id shift 112',0.00,0.00,0.00,4136.97,0.00,'2022-07-22 19:24:40','',''),(3149,'21','221','4',2,'Sale Id shift 112',0.00,0.00,0.00,4926.61,0.00,'2022-07-22 19:24:40','',''),(3150,'21','221','5',3,'Sale Id shift 112',0.00,0.00,0.00,536.89,0.00,'2022-07-22 19:24:40','',''),(3151,'21','221','3',1,'Sale Id shift 112',0.00,0.00,0.00,6117.62,0.00,'2022-07-22 19:24:40','',''),(3152,'21','221','1',1,'Sale Id shift 112',0.00,0.00,0.00,2451.72,0.00,'2022-07-22 19:24:40','',''),(3153,'21','221','1',1,'Sale Id shift 112',0.00,0.00,0.00,2770.38,0.00,'2022-07-22 19:24:40','',''),(3154,'21','221','2',1,'Sale Id shift 112',0.00,0.00,0.00,3719.81,0.00,'2022-07-22 19:24:40','',''),(3155,'21','221','2',1,'Sale Id shift 112',0.00,0.00,0.00,1567.09,0.00,'2022-07-22 19:24:40','',''),(3156,'21','221','2',1,'Sale Id shift 112',0.00,0.00,0.00,4632.56,0.00,'2022-07-22 19:24:40','',''),(3157,'21','221','2',1,'Sale Id shift 112',0.00,0.00,0.00,2949.16,0.00,'2022-07-22 19:24:40','',''),(3158,'21','221',NULL,1,'Sale Id shift 112',8281960.50,0.00,0.00,0.00,0.00,'2022-07-22 19:24:40','',''),(3159,'21','221',NULL,2,'Sale Id shift 112',7522771.40,0.00,0.00,0.00,0.00,'2022-07-22 19:24:40','',''),(3160,'21','221',NULL,3,'Sale Id shift 112',402667.50,0.00,0.00,0.00,0.00,'2022-07-22 19:24:40','',''),(3161,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24900000.00,30000.00,0.00,0.00,'2022-07-22 19:44:41','',''),(3162,'21','221',NULL,2,'Reception corrector for bridging 300',0.00,0.00,0.00,30000.00,0.00,'2022-07-22 19:47:24','',''),(3163,'21','221','4',2,'Received from bridging 300',0.00,0.00,30000.00,0.00,0.00,'2022-07-22 19:47:24','',''),(3164,'21','221','1',1,'Sale Id shift 113',0.00,0.00,0.00,5222.20,0.00,'2022-07-25 12:45:44','',''),(3165,'21','221','2',1,'Sale Id shift 113',0.00,0.00,0.00,4327.21,0.00,'2022-07-25 12:45:44','',''),(3166,'21','221','2',1,'Sale Id shift 113',0.00,0.00,0.00,3037.47,0.00,'2022-07-25 12:45:44','',''),(3167,'21','221','3',1,'Sale Id shift 113',0.00,0.00,0.00,3506.99,0.00,'2022-07-25 12:45:44','',''),(3168,'21','221','3',1,'Sale Id shift 113',0.00,0.00,0.00,2462.48,0.00,'2022-07-25 12:45:44','',''),(3169,'21','221','3',1,'Sale Id shift 113',0.00,0.00,0.00,3230.21,0.00,'2022-07-25 12:45:44','',''),(3170,'21','221','3',1,'Sale Id shift 113',0.00,0.00,0.00,2633.08,0.00,'2022-07-25 12:45:44','',''),(3171,'21','221','3',1,'Sale Id shift 113',0.00,0.00,0.00,4768.62,0.00,'2022-07-25 12:45:44','',''),(3172,'21','221','3',1,'Sale Id shift 113',0.00,0.00,0.00,7717.54,0.00,'2022-07-25 12:45:44','',''),(3173,'21','221','3',1,'Sale Id shift 113',0.00,0.00,0.00,1662.01,0.00,'2022-07-25 12:45:44','',''),(3174,'21','221','1',1,'Sale Id shift 113',0.00,0.00,0.00,2527.35,0.00,'2022-07-25 12:45:44','',''),(3175,'21','221','4',2,'Sale Id shift 113',0.00,0.00,0.00,4631.14,0.00,'2022-07-25 12:45:44','',''),(3176,'21','221','4',2,'Sale Id shift 113',0.00,0.00,0.00,5072.03,0.00,'2022-07-25 12:45:44','',''),(3177,'21','221','5',3,'Sale Id shift 113',0.00,0.00,0.00,745.54,0.00,'2022-07-25 12:45:44','',''),(3178,'21','221','3',1,'Sale Id shift 113',0.00,0.00,0.00,4582.30,0.00,'2022-07-25 12:45:44','',''),(3179,'21','221','1',1,'Sale Id shift 113',0.00,0.00,0.00,4200.55,0.00,'2022-07-25 12:45:44','',''),(3180,'21','221','1',1,'Sale Id shift 113',0.00,0.00,0.00,4618.11,0.00,'2022-07-25 12:45:44','',''),(3181,'21','221','2',1,'Sale Id shift 113',0.00,0.00,0.00,3334.31,0.00,'2022-07-25 12:45:44','',''),(3182,'21','221','2',1,'Sale Id shift 113',0.00,0.00,0.00,1912.96,0.00,'2022-07-25 12:45:44','',''),(3183,'21','221','2',1,'Sale Id shift 113',0.00,0.00,0.00,4924.01,0.00,'2022-07-25 12:45:44','',''),(3184,'21','221','2',1,'Sale Id shift 113',0.00,0.00,0.00,2584.98,0.00,'2022-07-25 12:45:44','',''),(3185,'21','221',NULL,1,'Sale Id shift 113',11096642.70,0.00,0.00,0.00,0.00,'2022-07-25 12:45:44','',''),(3186,'21','221',NULL,2,'Sale Id shift 113',8053631.10,0.00,0.00,0.00,0.00,'2022-07-25 12:45:44','',''),(3187,'21','221',NULL,3,'Sale Id shift 113',559155.00,0.00,0.00,0.00,0.00,'2022-07-25 12:45:44','',''),(3188,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-07-25 13:19:17','',''),(3189,'21','221',NULL,1,'Reception corrector for bridging 302',0.00,0.00,0.00,20000.00,0.00,'2022-07-25 13:20:55','',''),(3190,'21','221','2',1,'Received from bridging 302',0.00,0.00,20000.00,0.00,0.00,'2022-07-25 13:20:55','',''),(3191,'21','221',NULL,1,'Reception corrector for bridging 301',0.00,0.00,0.00,40000.00,0.00,'2022-07-25 13:20:55','',''),(3192,'21','221','1',1,'Received from bridging 301',0.00,0.00,40000.00,0.00,0.00,'2022-07-25 13:20:55','',''),(3193,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-25 13:22:19','',''),(3194,'21','221',NULL,1,'Reception corrector for bridging 303',0.00,0.00,0.00,50000.00,0.00,'2022-07-25 13:25:09','',''),(3195,'21','221','3',1,'Received from bridging 303',0.00,0.00,50000.00,0.00,0.00,'2022-07-25 13:25:09','',''),(3196,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-25 13:25:31','',''),(3197,'21','221',NULL,1,'Reception corrector for bridging 305',0.00,0.00,0.00,5000.00,0.00,'2022-07-25 13:27:58','',''),(3198,'21','221','3',1,'Received from bridging 305',0.00,0.00,5000.00,0.00,0.00,'2022-07-25 13:27:58','',''),(3199,'21','221',NULL,1,'Reception corrector for bridging 304',0.00,0.00,0.00,40000.00,0.00,'2022-07-25 13:27:58','',''),(3200,'21','221','2',1,'Received from bridging 304',0.00,0.00,40000.00,0.00,0.00,'2022-07-25 13:27:58','',''),(3201,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24900000.00,30000.00,0.00,0.00,'2022-07-25 13:28:14','',''),(3202,'21','221',NULL,2,'Reception corrector for bridging 306',0.00,0.00,0.00,20000.00,0.00,'2022-07-25 13:29:25','',''),(3203,'21','221','4',2,'Received from bridging 306',0.00,0.00,20000.00,0.00,0.00,'2022-07-25 13:29:25','',''),(3204,'21','221','1',1,'Sale Id shift 114',0.00,0.00,0.00,2381.25,0.00,'2022-07-25 14:56:15','',''),(3205,'21','221','2',1,'Sale Id shift 114',0.00,0.00,0.00,3125.81,0.00,'2022-07-25 14:56:15','',''),(3206,'21','221','2',1,'Sale Id shift 114',0.00,0.00,0.00,1965.16,0.00,'2022-07-25 14:56:15','',''),(3207,'21','221','3',1,'Sale Id shift 114',0.00,0.00,0.00,1801.63,0.00,'2022-07-25 14:56:15','',''),(3208,'21','221','3',1,'Sale Id shift 114',0.00,0.00,0.00,1576.74,0.00,'2022-07-25 14:56:15','',''),(3209,'21','221','3',1,'Sale Id shift 114',0.00,0.00,0.00,1723.01,0.00,'2022-07-25 14:56:15','',''),(3210,'21','221','3',1,'Sale Id shift 114',0.00,0.00,0.00,2458.00,0.00,'2022-07-25 14:56:15','',''),(3211,'21','221','3',1,'Sale Id shift 114',0.00,0.00,0.00,1600.93,0.00,'2022-07-25 14:56:15','',''),(3212,'21','221','3',1,'Sale Id shift 114',0.00,0.00,0.00,3682.52,0.00,'2022-07-25 14:56:15','',''),(3213,'21','221','3',1,'Sale Id shift 114',0.00,0.00,0.00,1667.06,0.00,'2022-07-25 14:56:15','',''),(3214,'21','221','1',1,'Sale Id shift 114',0.00,0.00,0.00,2872.63,0.00,'2022-07-25 14:56:15','',''),(3215,'21','221','4',2,'Sale Id shift 114',0.00,0.00,0.00,2002.82,0.00,'2022-07-25 14:56:15','',''),(3216,'21','221','4',2,'Sale Id shift 114',0.00,0.00,0.00,7592.03,0.00,'2022-07-25 14:56:15','',''),(3217,'21','221','5',3,'Sale Id shift 114',0.00,0.00,0.00,658.83,0.00,'2022-07-25 14:56:15','',''),(3218,'21','221','3',1,'Sale Id shift 114',0.00,0.00,0.00,4871.63,0.00,'2022-07-25 14:56:15','',''),(3219,'21','221','1',1,'Sale Id shift 114',0.00,0.00,0.00,2691.15,0.00,'2022-07-25 14:56:15','',''),(3220,'21','221','1',1,'Sale Id shift 114',0.00,0.00,0.00,2879.92,0.00,'2022-07-25 14:56:15','',''),(3221,'21','221','2',1,'Sale Id shift 114',0.00,0.00,0.00,1663.04,0.00,'2022-07-25 14:56:15','',''),(3222,'21','221','2',1,'Sale Id shift 114',0.00,0.00,0.00,1074.05,0.00,'2022-07-25 14:56:15','',''),(3223,'21','221','2',1,'Sale Id shift 114',0.00,0.00,0.00,2413.75,0.00,'2022-07-25 14:56:15','',''),(3224,'21','221','2',1,'Sale Id shift 114',0.00,0.00,0.00,1219.60,0.00,'2022-07-25 14:56:15','',''),(3225,'21','221',NULL,1,'Sale Id shift 114',6875200.20,0.00,0.00,0.00,0.00,'2022-07-25 14:56:15','',''),(3226,'21','221',NULL,2,'Sale Id shift 114',7963725.50,0.00,0.00,0.00,0.00,'2022-07-25 14:56:15','',''),(3227,'21','221',NULL,3,'Sale Id shift 114',494122.50,0.00,0.00,0.00,0.00,'2022-07-25 14:56:15','',''),(3228,'21','221','1',1,'Sale Id shift 115',0.00,0.00,0.00,2749.38,0.00,'2022-07-25 16:40:35','',''),(3229,'21','221','2',1,'Sale Id shift 115',0.00,0.00,0.00,3683.39,0.00,'2022-07-25 16:40:35','',''),(3230,'21','221','2',1,'Sale Id shift 115',0.00,0.00,0.00,2150.10,0.00,'2022-07-25 16:40:35','',''),(3231,'21','221','3',1,'Sale Id shift 115',0.00,0.00,0.00,1350.62,0.00,'2022-07-25 16:40:35','',''),(3232,'21','221','3',1,'Sale Id shift 115',0.00,0.00,0.00,1968.77,0.00,'2022-07-25 16:40:35','',''),(3233,'21','221','3',1,'Sale Id shift 115',0.00,0.00,0.00,1619.03,0.00,'2022-07-25 16:40:35','',''),(3234,'21','221','3',1,'Sale Id shift 115',0.00,0.00,0.00,1988.23,0.00,'2022-07-25 16:40:35','',''),(3235,'21','221','3',1,'Sale Id shift 115',0.00,0.00,0.00,2062.05,0.00,'2022-07-25 16:40:35','',''),(3236,'21','221','3',1,'Sale Id shift 115',0.00,0.00,0.00,4777.00,0.00,'2022-07-25 16:40:35','',''),(3237,'21','221','3',1,'Sale Id shift 115',0.00,0.00,0.00,2451.12,0.00,'2022-07-25 16:40:35','',''),(3238,'21','221','1',1,'Sale Id shift 115',0.00,0.00,0.00,2740.17,0.00,'2022-07-25 16:40:35','',''),(3239,'21','221','4',2,'Sale Id shift 115',0.00,0.00,0.00,4130.05,0.00,'2022-07-25 16:40:35','',''),(3240,'21','221','4',2,'Sale Id shift 115',0.00,0.00,0.00,5618.82,0.00,'2022-07-25 16:40:35','',''),(3241,'21','221','5',3,'Sale Id shift 115',0.00,0.00,0.00,908.40,0.00,'2022-07-25 16:40:35','',''),(3242,'21','221','3',1,'Sale Id shift 115',0.00,0.00,0.00,5749.82,0.00,'2022-07-25 16:40:35','',''),(3243,'21','221','1',1,'Sale Id shift 115',0.00,0.00,0.00,2768.52,0.00,'2022-07-25 16:40:35','',''),(3244,'21','221','1',1,'Sale Id shift 115',0.00,0.00,0.00,2803.08,0.00,'2022-07-25 16:40:35','',''),(3245,'21','221','2',1,'Sale Id shift 115',0.00,0.00,0.00,3272.37,0.00,'2022-07-25 16:40:35','',''),(3246,'21','221','2',1,'Sale Id shift 115',0.00,0.00,0.00,1295.83,0.00,'2022-07-25 16:40:35','',''),(3247,'21','221','2',1,'Sale Id shift 115',0.00,0.00,0.00,4063.88,0.00,'2022-07-25 16:40:35','',''),(3248,'21','221','2',1,'Sale Id shift 115',0.00,0.00,0.00,2359.39,0.00,'2022-07-25 16:40:35','',''),(3249,'21','221',NULL,1,'Sale Id shift 115',8225703.75,0.00,0.00,0.00,0.00,'2022-07-25 16:40:35','',''),(3250,'21','221',NULL,2,'Sale Id shift 115',8091562.10,0.00,0.00,0.00,0.00,'2022-07-25 16:40:35','',''),(3251,'21','221',NULL,3,'Sale Id shift 115',681300.00,0.00,0.00,0.00,0.00,'2022-07-25 16:40:35','',''),(3252,'21','221',NULL,2,'Reception corrector for bridging 307',0.00,0.00,0.00,10000.00,0.00,'2022-07-26 11:08:19','',''),(3253,'21','221','4',2,'Received from bridging 307',0.00,0.00,10000.00,0.00,0.00,'2022-07-26 11:08:19','',''),(3254,'21','221',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,37500000.00,50000.00,0.00,0.00,'2022-07-26 11:17:21','',''),(3255,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-26 11:21:03','',''),(3256,'21','221',NULL,1,'Reception corrector for bridging 309',0.00,0.00,0.00,40000.00,0.00,'2022-07-26 11:22:49','',''),(3257,'21','221','3',1,'Received from bridging 309',0.00,0.00,40000.00,0.00,0.00,'2022-07-26 11:22:49','',''),(3258,'21','221',NULL,1,'Reception corrector for bridging 308',0.00,0.00,0.00,10000.00,0.00,'2022-07-26 11:22:49','',''),(3259,'21','221','1',1,'Received from bridging 308',0.00,0.00,10000.00,0.00,0.00,'2022-07-26 11:22:49','',''),(3260,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-26 11:31:37','',''),(3261,'21','221',NULL,1,'Reception corrector for bridging 312',0.00,0.00,0.00,10000.00,0.00,'2022-07-26 11:35:12','',''),(3262,'21','221','3',1,'Received from bridging 312',0.00,0.00,10000.00,0.00,0.00,'2022-07-26 11:35:12','',''),(3263,'21','221',NULL,1,'Reception corrector for bridging 311',0.00,0.00,0.00,30000.00,0.00,'2022-07-26 11:35:12','',''),(3264,'21','221','2',1,'Received from bridging 311',0.00,0.00,30000.00,0.00,0.00,'2022-07-26 11:35:12','',''),(3265,'21','221',NULL,1,'Reception corrector for bridging 310',0.00,0.00,0.00,10000.00,0.00,'2022-07-26 11:35:12','',''),(3266,'21','221','1',1,'Received from bridging 310',0.00,0.00,10000.00,0.00,0.00,'2022-07-26 11:35:12','',''),(3267,'21','221','1',1,'Sale Id shift 116',0.00,0.00,0.00,1476.08,0.00,'2022-07-26 12:32:31','',''),(3268,'21','221','2',1,'Sale Id shift 116',0.00,0.00,0.00,3659.88,0.00,'2022-07-26 12:32:31','',''),(3269,'21','221','2',1,'Sale Id shift 116',0.00,0.00,0.00,2438.42,0.00,'2022-07-26 12:32:31','',''),(3270,'21','221','3',1,'Sale Id shift 116',0.00,0.00,0.00,1975.84,0.00,'2022-07-26 12:32:31','',''),(3271,'21','221','3',1,'Sale Id shift 116',0.00,0.00,0.00,1638.72,0.00,'2022-07-26 12:32:31','',''),(3272,'21','221','3',1,'Sale Id shift 116',0.00,0.00,0.00,2225.13,0.00,'2022-07-26 12:32:31','',''),(3273,'21','221','3',1,'Sale Id shift 116',0.00,0.00,0.00,2490.95,0.00,'2022-07-26 12:32:31','',''),(3274,'21','221','3',1,'Sale Id shift 116',0.00,0.00,0.00,3628.37,0.00,'2022-07-26 12:32:31','',''),(3275,'21','221','3',1,'Sale Id shift 116',0.00,0.00,0.00,3761.61,0.00,'2022-07-26 12:32:31','',''),(3276,'21','221','3',1,'Sale Id shift 116',0.00,0.00,0.00,3345.87,0.00,'2022-07-26 12:32:31','',''),(3277,'21','221','1',1,'Sale Id shift 116',0.00,0.00,0.00,1764.43,0.00,'2022-07-26 12:32:31','',''),(3278,'21','221','4',2,'Sale Id shift 116',0.00,0.00,0.00,3745.17,0.00,'2022-07-26 12:32:31','',''),(3279,'21','221','4',2,'Sale Id shift 116',0.00,0.00,0.00,11023.97,0.00,'2022-07-26 12:32:31','',''),(3280,'21','221','5',3,'Sale Id shift 116',0.00,0.00,0.00,705.88,0.00,'2022-07-26 12:32:31','',''),(3281,'21','221','3',1,'Sale Id shift 116',0.00,0.00,0.00,4590.96,0.00,'2022-07-26 12:32:31','',''),(3282,'21','221','1',1,'Sale Id shift 116',0.00,0.00,0.00,1590.80,0.00,'2022-07-26 12:32:31','',''),(3283,'21','221','1',1,'Sale Id shift 116',0.00,0.00,0.00,1658.43,0.00,'2022-07-26 12:32:31','',''),(3284,'21','221','2',1,'Sale Id shift 116',0.00,0.00,0.00,2808.24,0.00,'2022-07-26 12:32:31','',''),(3285,'21','221','2',1,'Sale Id shift 116',0.00,0.00,0.00,1555.96,0.00,'2022-07-26 12:32:31','',''),(3286,'21','221','2',1,'Sale Id shift 116',0.00,0.00,0.00,4189.83,0.00,'2022-07-26 12:32:31','',''),(3287,'21','221','2',1,'Sale Id shift 116',0.00,0.00,0.00,2625.10,0.00,'2022-07-26 12:32:31','',''),(3288,'21','221',NULL,1,'Sale Id shift 116',7825062.30,0.00,0.00,0.00,0.00,'2022-07-26 12:32:31','',''),(3289,'21','221',NULL,2,'Sale Id shift 116',12258386.20,0.00,0.00,0.00,0.00,'2022-07-26 12:32:31','',''),(3290,'21','221',NULL,3,'Sale Id shift 116',529410.00,0.00,0.00,0.00,0.00,'2022-07-26 12:32:31','',''),(3291,'21','221','1',1,'Sale Id shift 117',0.00,0.00,0.00,2047.43,0.00,'2022-07-26 16:58:19','',''),(3292,'21','221','2',1,'Sale Id shift 117',0.00,0.00,0.00,8021.33,0.00,'2022-07-26 16:58:19','',''),(3293,'21','221','2',1,'Sale Id shift 117',0.00,0.00,0.00,3235.01,0.00,'2022-07-26 16:58:19','',''),(3294,'21','221','3',1,'Sale Id shift 117',0.00,0.00,0.00,4470.31,0.00,'2022-07-26 16:58:19','',''),(3295,'21','221','3',1,'Sale Id shift 117',0.00,0.00,0.00,3798.94,0.00,'2022-07-26 16:58:19','',''),(3296,'21','221','3',1,'Sale Id shift 117',0.00,0.00,0.00,3122.66,0.00,'2022-07-26 16:58:19','',''),(3297,'21','221','3',1,'Sale Id shift 117',0.00,0.00,0.00,3968.76,0.00,'2022-07-26 16:58:19','',''),(3298,'21','221','3',1,'Sale Id shift 117',0.00,0.00,0.00,5550.59,0.00,'2022-07-26 16:58:19','',''),(3299,'21','221','3',1,'Sale Id shift 117',0.00,0.00,0.00,4250.22,0.00,'2022-07-26 16:58:19','',''),(3300,'21','221','3',1,'Sale Id shift 117',0.00,0.00,0.00,5431.13,0.00,'2022-07-26 16:58:19','',''),(3301,'21','221','1',1,'Sale Id shift 117',0.00,0.00,0.00,3066.66,0.00,'2022-07-26 16:58:19','',''),(3302,'21','221','4',2,'Sale Id shift 117',0.00,0.00,0.00,4444.37,0.00,'2022-07-26 16:58:19','',''),(3303,'21','221','4',2,'Sale Id shift 117',0.00,0.00,0.00,4288.16,0.00,'2022-07-26 16:58:19','',''),(3304,'21','221','5',3,'Sale Id shift 117',0.00,0.00,0.00,866.00,0.00,'2022-07-26 16:58:19','',''),(3305,'21','221','3',1,'Sale Id shift 117',0.00,0.00,0.00,6645.23,0.00,'2022-07-26 16:58:19','',''),(3306,'21','221','1',1,'Sale Id shift 117',0.00,0.00,0.00,2793.02,0.00,'2022-07-26 16:58:19','',''),(3307,'21','221','1',1,'Sale Id shift 117',0.00,0.00,0.00,2421.97,0.00,'2022-07-26 16:58:19','',''),(3308,'21','221','2',1,'Sale Id shift 117',0.00,0.00,0.00,6522.68,0.00,'2022-07-26 16:58:19','',''),(3309,'21','221','2',1,'Sale Id shift 117',0.00,0.00,0.00,3413.21,0.00,'2022-07-26 16:58:19','',''),(3310,'21','221','2',1,'Sale Id shift 117',0.00,0.00,0.00,3601.59,0.00,'2022-07-26 16:58:19','',''),(3311,'21','221','2',1,'Sale Id shift 117',0.00,0.00,0.00,4325.34,0.00,'2022-07-26 16:58:19','',''),(3312,'21','221',NULL,1,'Sale Id shift 117',12653203.20,0.00,0.00,0.00,0.00,'2022-07-26 16:58:19','',''),(3313,'21','221',NULL,2,'Sale Id shift 117',7247999.90,0.00,0.00,0.00,0.00,'2022-07-26 16:58:19','',''),(3314,'21','221',NULL,3,'Sale Id shift 117',649500.00,0.00,0.00,0.00,0.00,'2022-07-26 16:58:19','',''),(3315,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-27 16:02:29','',''),(3316,'21','221',NULL,1,'Reception corrector for bridging 313',0.00,0.00,0.00,40000.00,0.00,'2022-07-27 16:05:04','',''),(3317,'21','221','3',1,'Received from bridging 313',0.00,0.00,40000.00,0.00,0.00,'2022-07-27 16:05:04','',''),(3318,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-07-27 16:05:22','',''),(3319,'21','221',NULL,1,'Reception corrector for bridging 316',0.00,0.00,0.00,5000.00,0.00,'2022-07-27 16:07:41','',''),(3320,'21','221','3',1,'Received from bridging 316',0.00,0.00,5000.00,0.00,0.00,'2022-07-27 16:07:41','',''),(3321,'21','221',NULL,1,'Reception corrector for bridging 315',0.00,0.00,0.00,40000.00,0.00,'2022-07-27 16:07:41','',''),(3322,'21','221','2',1,'Received from bridging 315',0.00,0.00,40000.00,0.00,0.00,'2022-07-27 16:07:41','',''),(3323,'21','221',NULL,1,'Reception corrector for bridging 314',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 16:07:41','',''),(3324,'21','221','1',1,'Received from bridging 314',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 16:07:41','',''),(3325,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,29050000.00,35000.00,0.00,0.00,'2022-07-27 16:20:07','',''),(3326,'21','221',NULL,2,'Reception corrector for bridging 317',0.00,0.00,0.00,35000.00,0.00,'2022-07-27 16:21:14','',''),(3327,'21','221','4',2,'Received from bridging 317',0.00,0.00,35000.00,0.00,0.00,'2022-07-27 16:21:14','',''),(3328,'21','221','2',1,'Sale Id shift 118',0.00,0.00,0.00,3598.78,0.00,'2022-07-27 17:21:51','',''),(3329,'21','221','2',1,'Sale Id shift 118',0.00,0.00,0.00,2400.98,0.00,'2022-07-27 17:21:51','',''),(3330,'21','221','3',1,'Sale Id shift 118',0.00,0.00,0.00,3577.64,0.00,'2022-07-27 17:21:51','',''),(3331,'21','221','3',1,'Sale Id shift 118',0.00,0.00,0.00,1866.12,0.00,'2022-07-27 17:21:51','',''),(3332,'21','221','3',1,'Sale Id shift 118',0.00,0.00,0.00,2913.91,0.00,'2022-07-27 17:21:51','',''),(3333,'21','221','3',1,'Sale Id shift 118',0.00,0.00,0.00,2349.81,0.00,'2022-07-27 17:21:51','',''),(3334,'21','221','3',1,'Sale Id shift 118',0.00,0.00,0.00,2625.64,0.00,'2022-07-27 17:21:51','',''),(3335,'21','221','3',1,'Sale Id shift 118',0.00,0.00,0.00,3440.75,0.00,'2022-07-27 17:21:51','',''),(3336,'21','221','3',1,'Sale Id shift 118',0.00,0.00,0.00,2352.93,0.00,'2022-07-27 17:21:51','',''),(3337,'21','221','1',1,'Sale Id shift 118',0.00,0.00,0.00,17671.38,0.00,'2022-07-27 17:21:51','',''),(3338,'21','221','4',2,'Sale Id shift 118',0.00,0.00,0.00,3256.44,0.00,'2022-07-27 17:21:51','',''),(3339,'21','221','4',2,'Sale Id shift 118',0.00,0.00,0.00,5816.62,0.00,'2022-07-27 17:21:51','',''),(3340,'21','221','5',3,'Sale Id shift 118',0.00,0.00,0.00,559.03,0.00,'2022-07-27 17:21:51','',''),(3341,'21','221','3',1,'Sale Id shift 118',0.00,0.00,0.00,3877.85,0.00,'2022-07-27 17:21:51','',''),(3342,'21','221','1',1,'Sale Id shift 118',0.00,0.00,0.00,9900.87,0.00,'2022-07-27 17:21:51','',''),(3343,'21','221','2',1,'Sale Id shift 118',0.00,0.00,0.00,5749.56,0.00,'2022-07-27 17:21:51','',''),(3344,'21','221','2',1,'Sale Id shift 118',0.00,0.00,0.00,1792.71,0.00,'2022-07-27 17:21:51','',''),(3345,'21','221','2',1,'Sale Id shift 118',0.00,0.00,0.00,1623.96,0.00,'2022-07-27 17:21:51','',''),(3346,'21','221','2',1,'Sale Id shift 118',0.00,0.00,0.00,2202.04,0.00,'2022-07-27 17:21:51','',''),(3347,'21','221',NULL,1,'Sale Id shift 118',11210913.45,0.00,0.00,0.00,0.00,'2022-07-27 17:21:51','',''),(3348,'21','221',NULL,2,'Sale Id shift 118',7530639.80,0.00,0.00,0.00,0.00,'2022-07-27 17:21:51','',''),(3349,'21','221',NULL,3,'Sale Id shift 118',419272.50,0.00,0.00,0.00,0.00,'2022-07-27 17:21:51','',''),(3350,'21','221','2',1,'Sale Id shift 119',0.00,0.00,0.00,7915.16,0.00,'2022-07-27 18:47:39','',''),(3351,'21','221','2',1,'Sale Id shift 119',0.00,0.00,0.00,4635.69,0.00,'2022-07-27 18:47:39','',''),(3352,'21','221','3',1,'Sale Id shift 119',0.00,0.00,0.00,3134.02,0.00,'2022-07-27 18:47:39','',''),(3353,'21','221','3',1,'Sale Id shift 119',0.00,0.00,0.00,3123.68,0.00,'2022-07-27 18:47:39','',''),(3354,'21','221','3',1,'Sale Id shift 119',0.00,0.00,0.00,3281.24,0.00,'2022-07-27 18:47:39','',''),(3355,'21','221','3',1,'Sale Id shift 119',0.00,0.00,0.00,3832.52,0.00,'2022-07-27 18:47:39','',''),(3356,'21','221','3',1,'Sale Id shift 119',0.00,0.00,0.00,2622.86,0.00,'2022-07-27 18:47:39','',''),(3357,'21','221','3',1,'Sale Id shift 119',0.00,0.00,0.00,3195.05,0.00,'2022-07-27 18:47:39','',''),(3358,'21','221','3',1,'Sale Id shift 119',0.00,0.00,0.00,3722.62,0.00,'2022-07-27 18:47:39','',''),(3359,'21','221','4',2,'Sale Id shift 119',0.00,0.00,0.00,2614.83,0.00,'2022-07-27 18:47:39','',''),(3360,'21','221','4',2,'Sale Id shift 119',0.00,0.00,0.00,3911.57,0.00,'2022-07-27 18:47:39','',''),(3361,'21','221','5',3,'Sale Id shift 119',0.00,0.00,0.00,723.85,0.00,'2022-07-27 18:47:39','',''),(3362,'21','221','3',1,'Sale Id shift 119',0.00,0.00,0.00,6095.44,0.00,'2022-07-27 18:47:39','',''),(3363,'21','221','2',1,'Sale Id shift 119',0.00,0.00,0.00,7725.81,0.00,'2022-07-27 18:47:39','',''),(3364,'21','221','2',1,'Sale Id shift 119',0.00,0.00,0.00,3498.82,0.00,'2022-07-27 18:47:39','',''),(3365,'21','221','2',1,'Sale Id shift 119',0.00,0.00,0.00,3525.99,0.00,'2022-07-27 18:47:39','',''),(3366,'21','221','2',1,'Sale Id shift 119',0.00,0.00,0.00,4678.51,0.00,'2022-07-27 18:47:39','',''),(3367,'21','221',NULL,1,'Sale Id shift 119',10062922.65,0.00,0.00,0.00,0.00,'2022-07-27 18:47:39','',''),(3368,'21','221',NULL,2,'Sale Id shift 119',5416912.00,0.00,0.00,0.00,0.00,'2022-07-27 18:47:39','',''),(3369,'21','221',NULL,3,'Sale Id shift 119',542887.50,0.00,0.00,0.00,0.00,'2022-07-27 18:47:39','',''),(3370,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-28 14:33:47','',''),(3371,'21','221',NULL,1,'Reception corrector for bridging 319',0.00,0.00,0.00,30000.00,0.00,'2022-07-28 14:36:23','',''),(3372,'21','221','2',1,'Received from bridging 319',0.00,0.00,30000.00,0.00,0.00,'2022-07-28 14:36:23','',''),(3373,'21','221',NULL,1,'Reception corrector for bridging 318',0.00,0.00,0.00,15000.00,0.00,'2022-07-28 14:36:23','',''),(3374,'21','221','1',1,'Received from bridging 318',0.00,0.00,15000.00,0.00,0.00,'2022-07-28 14:36:23','',''),(3375,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-28 14:36:50','',''),(3376,'21','221',NULL,1,'Reception corrector for bridging 320',0.00,0.00,0.00,45000.00,0.00,'2022-07-28 14:38:10','',''),(3377,'21','221','3',1,'Received from bridging 320',0.00,0.00,45000.00,0.00,0.00,'2022-07-28 14:38:10','',''),(3378,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-28 14:38:25','',''),(3379,'21','221',NULL,1,'Reception corrector for bridging 323',0.00,0.00,0.00,20000.00,0.00,'2022-07-28 14:40:14','',''),(3380,'21','221','3',1,'Received from bridging 323',0.00,0.00,20000.00,0.00,0.00,'2022-07-28 14:40:14','',''),(3381,'21','221',NULL,1,'Reception corrector for bridging 322',0.00,0.00,0.00,20000.00,0.00,'2022-07-28 14:40:14','',''),(3382,'21','221','2',1,'Received from bridging 322',0.00,0.00,20000.00,0.00,0.00,'2022-07-28 14:40:14','',''),(3383,'21','221',NULL,1,'Reception corrector for bridging 321',0.00,0.00,0.00,5000.00,0.00,'2022-07-28 14:40:14','',''),(3384,'21','221','1',1,'Received from bridging 321',0.00,0.00,5000.00,0.00,0.00,'2022-07-28 14:40:14','',''),(3385,'21','221','2',1,'Sale Id shift 120',0.00,0.00,0.00,5826.22,0.00,'2022-07-28 15:38:39','',''),(3386,'21','221','2',1,'Sale Id shift 120',0.00,0.00,0.00,3848.61,0.00,'2022-07-28 15:38:39','',''),(3387,'21','221','3',1,'Sale Id shift 120',0.00,0.00,0.00,3193.54,0.00,'2022-07-28 15:38:39','',''),(3388,'21','221','3',1,'Sale Id shift 120',0.00,0.00,0.00,2406.69,0.00,'2022-07-28 15:38:39','',''),(3389,'21','221','3',1,'Sale Id shift 120',0.00,0.00,0.00,2905.35,0.00,'2022-07-28 15:38:39','',''),(3390,'21','221','3',1,'Sale Id shift 120',0.00,0.00,0.00,2125.83,0.00,'2022-07-28 15:38:39','',''),(3391,'21','221','3',1,'Sale Id shift 120',0.00,0.00,0.00,2995.64,0.00,'2022-07-28 15:38:39','',''),(3392,'21','221','3',1,'Sale Id shift 120',0.00,0.00,0.00,2182.64,0.00,'2022-07-28 15:38:39','',''),(3393,'21','221','3',1,'Sale Id shift 120',0.00,0.00,0.00,3279.84,0.00,'2022-07-28 15:38:39','',''),(3394,'21','221','4',2,'Sale Id shift 120',0.00,0.00,0.00,3106.83,0.00,'2022-07-28 15:38:39','',''),(3395,'21','221','5',3,'Sale Id shift 120',0.00,0.00,0.00,695.90,0.00,'2022-07-28 15:38:39','',''),(3396,'21','221','3',1,'Sale Id shift 120',0.00,0.00,0.00,3536.71,0.00,'2022-07-28 15:38:39','',''),(3397,'21','221','2',1,'Sale Id shift 120',0.00,0.00,0.00,4129.98,0.00,'2022-07-28 15:38:39','',''),(3398,'21','221','2',1,'Sale Id shift 120',0.00,0.00,0.00,2674.00,0.00,'2022-07-28 15:38:39','',''),(3399,'21','221','2',1,'Sale Id shift 120',0.00,0.00,0.00,3201.50,0.00,'2022-07-28 15:38:39','',''),(3400,'21','221','2',1,'Sale Id shift 120',0.00,0.00,0.00,2985.63,0.00,'2022-07-28 15:38:39','',''),(3401,'21','221',NULL,1,'Sale Id shift 120',7473209.70,0.00,0.00,0.00,0.00,'2022-07-28 15:38:39','',''),(3402,'21','221',NULL,2,'Sale Id shift 120',2578668.90,0.00,0.00,0.00,0.00,'2022-07-28 15:38:39','',''),(3403,'21','221',NULL,3,'Sale Id shift 120',521925.00,0.00,0.00,0.00,0.00,'2022-07-28 15:38:39','',''),(3404,'21','221','1',1,'Sale Id shift 121',0.00,0.00,0.00,2326.39,0.00,'2022-07-28 17:59:49','',''),(3405,'21','221','2',1,'Sale Id shift 121',0.00,0.00,0.00,6988.90,0.00,'2022-07-28 17:59:49','',''),(3406,'21','221','2',1,'Sale Id shift 121',0.00,0.00,0.00,4251.97,0.00,'2022-07-28 17:59:49','',''),(3407,'21','221','3',1,'Sale Id shift 121',0.00,0.00,0.00,4498.10,0.00,'2022-07-28 17:59:49','',''),(3408,'21','221','3',1,'Sale Id shift 121',0.00,0.00,0.00,3967.39,0.00,'2022-07-28 17:59:49','',''),(3409,'21','221','3',1,'Sale Id shift 121',0.00,0.00,0.00,4120.72,0.00,'2022-07-28 17:59:49','',''),(3410,'21','221','3',1,'Sale Id shift 121',0.00,0.00,0.00,3764.43,0.00,'2022-07-28 17:59:49','',''),(3411,'21','221','3',1,'Sale Id shift 121',0.00,0.00,0.00,5427.58,0.00,'2022-07-28 17:59:49','',''),(3412,'21','221','3',1,'Sale Id shift 121',0.00,0.00,0.00,4051.68,0.00,'2022-07-28 17:59:49','',''),(3413,'21','221','3',1,'Sale Id shift 121',0.00,0.00,0.00,4006.26,0.00,'2022-07-28 17:59:49','',''),(3414,'21','221','4',2,'Sale Id shift 121',0.00,0.00,0.00,5985.12,0.00,'2022-07-28 17:59:49','',''),(3415,'21','221','5',3,'Sale Id shift 121',0.00,0.00,0.00,939.50,0.00,'2022-07-28 17:59:49','',''),(3416,'21','221','3',1,'Sale Id shift 121',0.00,0.00,0.00,5021.98,0.00,'2022-07-28 17:59:49','',''),(3417,'21','221','1',1,'Sale Id shift 121',0.00,0.00,0.00,16664.17,0.00,'2022-07-28 17:59:49','',''),(3418,'21','221','2',1,'Sale Id shift 121',0.00,0.00,0.00,11187.72,0.00,'2022-07-28 17:59:49','',''),(3419,'21','221','2',1,'Sale Id shift 121',0.00,0.00,0.00,3044.11,0.00,'2022-07-28 17:59:49','',''),(3420,'21','221','2',1,'Sale Id shift 121',0.00,0.00,0.00,4479.97,0.00,'2022-07-28 17:59:49','',''),(3421,'21','221','2',1,'Sale Id shift 121',0.00,0.00,0.00,4251.63,0.00,'2022-07-28 17:59:49','',''),(3422,'21','221',NULL,1,'Sale Id shift 121',14528745.00,0.00,0.00,0.00,0.00,'2022-07-28 17:59:49','',''),(3423,'21','221',NULL,2,'Sale Id shift 121',4967649.60,0.00,0.00,0.00,0.00,'2022-07-28 17:59:49','',''),(3424,'21','221',NULL,3,'Sale Id shift 121',704625.00,0.00,0.00,0.00,0.00,'2022-07-28 17:59:49','',''),(3425,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-29 14:58:44','',''),(3426,'21','221',NULL,1,'Reception corrector for bridging 326',0.00,0.00,0.00,20000.00,0.00,'2022-07-29 15:00:48','',''),(3427,'21','221','3',1,'Received from bridging 326',0.00,0.00,20000.00,0.00,0.00,'2022-07-29 15:00:48','',''),(3428,'21','221',NULL,1,'Reception corrector for bridging 325',0.00,0.00,0.00,20000.00,0.00,'2022-07-29 15:00:48','',''),(3429,'21','221','2',1,'Received from bridging 325',0.00,0.00,20000.00,0.00,0.00,'2022-07-29 15:00:48','',''),(3430,'21','221',NULL,1,'Reception corrector for bridging 324',0.00,0.00,0.00,10000.00,0.00,'2022-07-29 15:00:48','',''),(3431,'21','221','1',1,'Received from bridging 324',0.00,0.00,10000.00,0.00,0.00,'2022-07-29 15:00:48','',''),(3432,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-29 15:03:08','',''),(3433,'21','221',NULL,1,'Reception corrector for bridging 329',0.00,0.00,0.00,20000.00,0.00,'2022-07-29 15:05:49','',''),(3434,'21','221','3',1,'Received from bridging 329',0.00,0.00,20000.00,0.00,0.00,'2022-07-29 15:05:49','',''),(3435,'21','221',NULL,1,'Reception corrector for bridging 328',0.00,0.00,0.00,20000.00,0.00,'2022-07-29 15:05:49','',''),(3436,'21','221','2',1,'Received from bridging 328',0.00,0.00,20000.00,0.00,0.00,'2022-07-29 15:05:49','',''),(3437,'21','221',NULL,1,'Reception corrector for bridging 327',0.00,0.00,0.00,5000.00,0.00,'2022-07-29 15:05:49','',''),(3438,'21','221','1',1,'Received from bridging 327',0.00,0.00,5000.00,0.00,0.00,'2022-07-29 15:05:49','',''),(3439,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-29 15:07:55','',''),(3440,'21','221',NULL,1,'Reception corrector for bridging 331',0.00,0.00,0.00,20000.00,0.00,'2022-07-29 15:08:59','',''),(3441,'21','221','3',1,'Received from bridging 331',0.00,0.00,20000.00,0.00,0.00,'2022-07-29 15:08:59','',''),(3442,'21','221',NULL,1,'Reception corrector for bridging 330',0.00,0.00,0.00,20000.00,0.00,'2022-07-29 15:08:59','',''),(3443,'21','221','2',1,'Received from bridging 330',0.00,0.00,20000.00,0.00,0.00,'2022-07-29 15:08:59','',''),(3444,'21','221','1',1,'Sale Id shift 122',0.00,0.00,0.00,2423.66,0.00,'2022-07-29 16:32:42','',''),(3445,'21','221','2',1,'Sale Id shift 122',0.00,0.00,0.00,1132.66,0.00,'2022-07-29 16:32:42','',''),(3446,'21','221','2',1,'Sale Id shift 122',0.00,0.00,0.00,1193.83,0.00,'2022-07-29 16:32:42','',''),(3447,'21','221','3',1,'Sale Id shift 122',0.00,0.00,0.00,1642.34,0.00,'2022-07-29 16:32:42','',''),(3448,'21','221','3',1,'Sale Id shift 122',0.00,0.00,0.00,1267.46,0.00,'2022-07-29 16:32:42','',''),(3449,'21','221','3',1,'Sale Id shift 122',0.00,0.00,0.00,1869.16,0.00,'2022-07-29 16:32:42','',''),(3450,'21','221','3',1,'Sale Id shift 122',0.00,0.00,0.00,890.84,0.00,'2022-07-29 16:32:42','',''),(3451,'21','221','3',1,'Sale Id shift 122',0.00,0.00,0.00,1956.13,0.00,'2022-07-29 16:32:42','',''),(3452,'21','221','3',1,'Sale Id shift 122',0.00,0.00,0.00,1609.38,0.00,'2022-07-29 16:32:42','',''),(3453,'21','221','3',1,'Sale Id shift 122',0.00,0.00,0.00,1224.35,0.00,'2022-07-29 16:32:42','',''),(3454,'21','221','4',2,'Sale Id shift 122',0.00,0.00,0.00,4179.11,0.00,'2022-07-29 16:32:42','',''),(3455,'21','221','5',3,'Sale Id shift 122',0.00,0.00,0.00,652.95,0.00,'2022-07-29 16:32:42','',''),(3456,'21','221','3',1,'Sale Id shift 122',0.00,0.00,0.00,1976.90,0.00,'2022-07-29 16:32:42','',''),(3457,'21','221','1',1,'Sale Id shift 122',0.00,0.00,0.00,2387.89,0.00,'2022-07-29 16:32:42','',''),(3458,'21','221','2',1,'Sale Id shift 122',0.00,0.00,0.00,1231.22,0.00,'2022-07-29 16:32:42','',''),(3459,'21','221','2',1,'Sale Id shift 122',0.00,0.00,0.00,1094.07,0.00,'2022-07-29 16:32:42','',''),(3460,'21','221','2',1,'Sale Id shift 122',0.00,0.00,0.00,-50.00,0.00,'2022-07-29 16:32:42','',''),(3461,'21','221',NULL,1,'Sale Id shift 122',3605231.85,0.00,0.00,0.00,0.00,'2022-07-29 16:32:42','',''),(3462,'21','221',NULL,2,'Sale Id shift 122',3468661.30,0.00,0.00,0.00,0.00,'2022-07-29 16:32:42','',''),(3463,'21','221',NULL,3,'Sale Id shift 122',489712.50,0.00,0.00,0.00,0.00,'2022-07-29 16:32:42','',''),(3464,'21','221','1',1,'Sale Id shift 123',0.00,0.00,0.00,2949.73,0.00,'2022-07-29 18:02:14','',''),(3465,'21','221','2',1,'Sale Id shift 123',0.00,0.00,0.00,4727.54,0.00,'2022-07-29 18:02:14','',''),(3466,'21','221','2',1,'Sale Id shift 123',0.00,0.00,0.00,3394.26,0.00,'2022-07-29 18:02:14','',''),(3467,'21','221','3',1,'Sale Id shift 123',0.00,0.00,0.00,3245.06,0.00,'2022-07-29 18:02:14','',''),(3468,'21','221','3',1,'Sale Id shift 123',0.00,0.00,0.00,2439.30,0.00,'2022-07-29 18:02:14','',''),(3469,'21','221','3',1,'Sale Id shift 123',0.00,0.00,0.00,3473.21,0.00,'2022-07-29 18:02:14','',''),(3470,'21','221','3',1,'Sale Id shift 123',0.00,0.00,0.00,3735.09,0.00,'2022-07-29 18:02:14','',''),(3471,'21','221','3',1,'Sale Id shift 123',0.00,0.00,0.00,3243.05,0.00,'2022-07-29 18:02:14','',''),(3472,'21','221','3',1,'Sale Id shift 123',0.00,0.00,0.00,3571.63,0.00,'2022-07-29 18:02:14','',''),(3473,'21','221','3',1,'Sale Id shift 123',0.00,0.00,0.00,3488.59,0.00,'2022-07-29 18:02:14','',''),(3474,'21','221','4',2,'Sale Id shift 123',0.00,0.00,0.00,1522.62,0.00,'2022-07-29 18:02:14','',''),(3475,'21','221','5',3,'Sale Id shift 123',0.00,0.00,0.00,400.67,0.00,'2022-07-29 18:02:14','',''),(3476,'21','221','3',1,'Sale Id shift 123',0.00,0.00,0.00,5648.56,0.00,'2022-07-29 18:02:14','',''),(3477,'21','221','1',1,'Sale Id shift 123',0.00,0.00,0.00,4277.91,0.00,'2022-07-29 18:02:14','',''),(3478,'21','221','2',1,'Sale Id shift 123',0.00,0.00,0.00,4168.91,0.00,'2022-07-29 18:02:14','',''),(3479,'21','221','2',1,'Sale Id shift 123',0.00,0.00,0.00,2795.20,0.00,'2022-07-29 18:02:14','',''),(3480,'21','221','2',1,'Sale Id shift 123',0.00,0.00,0.00,2323.45,0.00,'2022-07-29 18:02:14','',''),(3481,'21','221','2',1,'Sale Id shift 123',0.00,0.00,0.00,3146.87,0.00,'2022-07-29 18:02:14','',''),(3482,'21','221',NULL,1,'Sale Id shift 123',9343679.40,0.00,0.00,0.00,0.00,'2022-07-29 18:02:14','',''),(3483,'21','221',NULL,2,'Sale Id shift 123',1263774.60,0.00,0.00,0.00,0.00,'2022-07-29 18:02:14','',''),(3484,'21','221',NULL,3,'Sale Id shift 123',300502.50,0.00,0.00,0.00,0.00,'2022-07-29 18:02:14','',''),(3485,'21','221','2',1,'Sale Id shift 124',0.00,0.00,0.00,6706.51,0.00,'2022-07-31 15:01:17','',''),(3486,'21','221','2',1,'Sale Id shift 124',0.00,0.00,0.00,5726.02,0.00,'2022-07-31 15:01:17','',''),(3487,'21','221','3',1,'Sale Id shift 124',0.00,0.00,0.00,4810.77,0.00,'2022-07-31 15:01:17','',''),(3488,'21','221','3',1,'Sale Id shift 124',0.00,0.00,0.00,2394.83,0.00,'2022-07-31 15:01:17','',''),(3489,'21','221','3',1,'Sale Id shift 124',0.00,0.00,0.00,4765.68,0.00,'2022-07-31 15:01:17','',''),(3490,'21','221','3',1,'Sale Id shift 124',0.00,0.00,0.00,3291.30,0.00,'2022-07-31 15:01:17','',''),(3491,'21','221','3',1,'Sale Id shift 124',0.00,0.00,0.00,3654.67,0.00,'2022-07-31 15:01:17','',''),(3492,'21','221','3',1,'Sale Id shift 124',0.00,0.00,0.00,4239.74,0.00,'2022-07-31 15:01:17','',''),(3493,'21','221','3',1,'Sale Id shift 124',0.00,0.00,0.00,3247.05,0.00,'2022-07-31 15:01:17','',''),(3494,'21','221','4',2,'Sale Id shift 124',0.00,0.00,0.00,2972.33,0.00,'2022-07-31 15:01:17','',''),(3495,'21','221','5',3,'Sale Id shift 124',0.00,0.00,0.00,713.14,0.00,'2022-07-31 15:01:17','',''),(3496,'21','221','3',1,'Sale Id shift 124',0.00,0.00,0.00,4206.27,0.00,'2022-07-31 15:01:17','',''),(3497,'21','221','1',1,'Sale Id shift 124',0.00,0.00,0.00,12.11,0.00,'2022-07-31 15:01:17','',''),(3498,'21','221','2',1,'Sale Id shift 124',0.00,0.00,0.00,8855.27,0.00,'2022-07-31 15:01:17','',''),(3499,'21','221','2',1,'Sale Id shift 124',0.00,0.00,0.00,2931.24,0.00,'2022-07-31 15:01:17','',''),(3500,'21','221','2',1,'Sale Id shift 124',0.00,0.00,0.00,2463.99,0.00,'2022-07-31 15:01:17','',''),(3501,'21','221','2',1,'Sale Id shift 124',0.00,0.00,0.00,3615.46,0.00,'2022-07-31 15:01:17','',''),(3502,'21','221',NULL,1,'Sale Id shift 124',10051950.15,0.00,0.00,0.00,0.00,'2022-07-31 15:01:17','',''),(3503,'21','221',NULL,2,'Sale Id shift 124',2467033.90,0.00,0.00,0.00,0.00,'2022-07-31 15:01:17','',''),(3504,'21','221',NULL,3,'Sale Id shift 124',534855.00,0.00,0.00,0.00,0.00,'2022-07-31 15:01:17','',''),(3505,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-07-31 15:03:18','',''),(3506,'21','221',NULL,1,'Reception corrector for bridging 332',0.00,0.00,0.00,50000.00,0.00,'2022-07-31 15:04:40','',''),(3507,'21','221','2',1,'Received from bridging 332',0.00,0.00,50000.00,0.00,0.00,'2022-07-31 15:04:40','',''),(3508,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-07-31 15:04:56','',''),(3509,'21','221',NULL,1,'Reception corrector for bridging 334',0.00,0.00,0.00,30000.00,0.00,'2022-07-31 15:06:56','',''),(3510,'21','221','3',1,'Received from bridging 334',0.00,0.00,30000.00,0.00,0.00,'2022-07-31 15:06:56','',''),(3511,'21','221',NULL,1,'Reception corrector for bridging 333',0.00,0.00,0.00,20000.00,0.00,'2022-07-31 15:06:56','',''),(3512,'21','221','1',1,'Received from bridging 333',0.00,0.00,20000.00,0.00,0.00,'2022-07-31 15:06:56','',''),(3513,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-07-31 15:07:21','',''),(3514,'21','221',NULL,1,'Reception corrector for bridging 337',0.00,0.00,0.00,40000.00,0.00,'2022-07-31 15:10:16','',''),(3515,'21','221','3',1,'Received from bridging 337',0.00,0.00,40000.00,0.00,0.00,'2022-07-31 15:10:16','',''),(3516,'21','221',NULL,1,'Reception corrector for bridging 336',0.00,0.00,0.00,11000.00,0.00,'2022-07-31 15:10:16','',''),(3517,'21','221','2',1,'Received from bridging 336',0.00,0.00,11000.00,0.00,0.00,'2022-07-31 15:10:16','',''),(3518,'21','221',NULL,1,'Reception corrector for bridging 335',0.00,0.00,0.00,9000.00,0.00,'2022-07-31 15:10:16','',''),(3519,'21','221','1',1,'Received from bridging 335',0.00,0.00,9000.00,0.00,0.00,'2022-07-31 15:10:16','',''),(3520,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,16600000.00,20000.00,0.00,0.00,'2022-07-31 15:10:29','',''),(3521,'21','221',NULL,2,'Reception corrector for bridging 338',0.00,0.00,0.00,20000.00,0.00,'2022-07-31 15:12:04','',''),(3522,'21','221','4',2,'Received from bridging 338',0.00,0.00,20000.00,0.00,0.00,'2022-07-31 15:12:04','',''),(3523,'21','221','1',1,'Sale Id shift 125',0.00,0.00,0.00,7648.55,0.00,'2022-08-01 15:16:09','',''),(3524,'21','221','2',1,'Sale Id shift 125',0.00,0.00,0.00,7997.92,0.00,'2022-08-01 15:16:09','',''),(3525,'21','221','2',1,'Sale Id shift 125',0.00,0.00,0.00,4738.71,0.00,'2022-08-01 15:16:09','',''),(3526,'21','221','3',1,'Sale Id shift 125',0.00,0.00,0.00,3143.65,0.00,'2022-08-01 15:16:09','',''),(3527,'21','221','3',1,'Sale Id shift 125',0.00,0.00,0.00,4771.54,0.00,'2022-08-01 15:16:09','',''),(3528,'21','221','3',1,'Sale Id shift 125',0.00,0.00,0.00,3877.92,0.00,'2022-08-01 15:16:09','',''),(3529,'21','221','3',1,'Sale Id shift 125',0.00,0.00,0.00,4078.08,0.00,'2022-08-01 15:16:09','',''),(3530,'21','221','3',1,'Sale Id shift 125',0.00,0.00,0.00,3919.51,0.00,'2022-08-01 15:16:09','',''),(3531,'21','221','3',1,'Sale Id shift 125',0.00,0.00,0.00,4085.07,0.00,'2022-08-01 15:16:09','',''),(3532,'21','221','3',1,'Sale Id shift 125',0.00,0.00,0.00,4514.34,0.00,'2022-08-01 15:16:09','',''),(3533,'21','221','4',2,'Sale Id shift 125',0.00,0.00,0.00,4082.82,0.00,'2022-08-01 15:16:09','',''),(3534,'21','221','5',3,'Sale Id shift 125',0.00,0.00,0.00,559.03,0.00,'2022-08-01 15:16:09','',''),(3535,'21','221','3',1,'Sale Id shift 125',0.00,0.00,0.00,6112.54,0.00,'2022-08-01 15:16:09','',''),(3536,'21','221','1',1,'Sale Id shift 125',0.00,0.00,0.00,6483.57,0.00,'2022-08-01 15:16:09','',''),(3537,'21','221','2',1,'Sale Id shift 125',0.00,0.00,0.00,7522.92,0.00,'2022-08-01 15:16:09','',''),(3538,'21','221','2',1,'Sale Id shift 125',0.00,0.00,0.00,3790.38,0.00,'2022-08-01 15:16:10','',''),(3539,'21','221','2',1,'Sale Id shift 125',0.00,0.00,0.00,3952.00,0.00,'2022-08-01 15:16:10','',''),(3540,'21','221','2',1,'Sale Id shift 125',0.00,0.00,0.00,5311.55,0.00,'2022-08-01 15:16:10','',''),(3541,'21','221',NULL,1,'Sale Id shift 125',15160426.25,0.00,0.00,0.00,0.00,'2022-08-01 15:16:10','',''),(3542,'21','221',NULL,2,'Sale Id shift 125',3388740.60,0.00,0.00,0.00,0.00,'2022-08-01 15:16:10','',''),(3543,'21','221',NULL,3,'Sale Id shift 125',419272.50,0.00,0.00,0.00,0.00,'2022-08-01 15:16:10','',''),(3544,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-08-01 16:20:52','',''),(3545,'21','221',NULL,1,'Reception corrector for bridging 340',0.00,0.00,0.00,40000.00,0.00,'2022-08-01 16:23:48','',''),(3546,'21','221','3',1,'Received from bridging 340',0.00,0.00,40000.00,0.00,0.00,'2022-08-01 16:23:48','',''),(3547,'21','221',NULL,1,'Reception corrector for bridging 339',0.00,0.00,0.00,10000.00,0.00,'2022-08-01 16:23:48','',''),(3548,'21','221','1',1,'Received from bridging 339',0.00,0.00,10000.00,0.00,0.00,'2022-08-01 16:23:48','',''),(3549,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-08-01 16:24:06','',''),(3550,'21','221',NULL,1,'Reception corrector for bridging 342',0.00,0.00,0.00,33000.00,0.00,'2022-08-01 16:26:39','',''),(3551,'21','221','2',1,'Received from bridging 342',0.00,0.00,33000.00,0.00,0.00,'2022-08-01 16:26:39','',''),(3552,'21','221',NULL,1,'Reception corrector for bridging 341',0.00,0.00,0.00,4000.00,0.00,'2022-08-01 16:26:39','',''),(3553,'21','221','1',1,'Received from bridging 341',0.00,0.00,4000.00,0.00,0.00,'2022-08-01 16:26:39','',''),(3554,'21','221','1',1,'Sale Id shift 126',0.00,0.00,0.00,11668.54,0.00,'2022-08-01 17:52:52','',''),(3555,'21','221','2',1,'Sale Id shift 126',0.00,0.00,0.00,7226.00,0.00,'2022-08-01 17:52:52','',''),(3556,'21','221','2',1,'Sale Id shift 126',0.00,0.00,0.00,4328.97,0.00,'2022-08-01 17:52:52','',''),(3557,'21','221','3',1,'Sale Id shift 126',0.00,0.00,0.00,3775.11,0.00,'2022-08-01 17:52:52','',''),(3558,'21','221','3',1,'Sale Id shift 126',0.00,0.00,0.00,3231.37,0.00,'2022-08-01 17:52:52','',''),(3559,'21','221','3',1,'Sale Id shift 126',0.00,0.00,0.00,4233.74,0.00,'2022-08-01 17:52:52','',''),(3560,'21','221','3',1,'Sale Id shift 126',0.00,0.00,0.00,2867.25,0.00,'2022-08-01 17:52:52','',''),(3561,'21','221','3',1,'Sale Id shift 126',0.00,0.00,0.00,3165.98,0.00,'2022-08-01 17:52:52','',''),(3562,'21','221','3',1,'Sale Id shift 126',0.00,0.00,0.00,4310.76,0.00,'2022-08-01 17:52:52','',''),(3563,'21','221','3',1,'Sale Id shift 126',0.00,0.00,0.00,4535.06,0.00,'2022-08-01 17:52:52','',''),(3564,'21','221','1',1,'Sale Id shift 126',0.00,0.00,0.00,10724.45,0.00,'2022-08-01 17:52:52','',''),(3565,'21','221','4',2,'Sale Id shift 126',0.00,0.00,0.00,4231.51,0.00,'2022-08-01 17:52:52','',''),(3566,'21','221','5',3,'Sale Id shift 126',0.00,0.00,0.00,672.52,0.00,'2022-08-01 17:52:52','',''),(3567,'21','221','3',1,'Sale Id shift 126',0.00,0.00,0.00,3236.52,0.00,'2022-08-01 17:52:52','',''),(3568,'21','221','1',1,'Sale Id shift 126',0.00,0.00,0.00,10841.78,0.00,'2022-08-01 17:52:52','',''),(3569,'21','221','1',1,'Sale Id shift 126',0.00,0.00,0.00,9973.98,0.00,'2022-08-01 17:52:52','',''),(3570,'21','221','2',1,'Sale Id shift 126',0.00,0.00,0.00,7952.83,0.00,'2022-08-01 17:52:52','',''),(3571,'21','221','2',1,'Sale Id shift 126',0.00,0.00,0.00,4201.03,0.00,'2022-08-01 17:52:52','',''),(3572,'21','221','2',1,'Sale Id shift 126',0.00,0.00,0.00,3592.49,0.00,'2022-08-01 17:52:52','',''),(3573,'21','221','2',1,'Sale Id shift 126',0.00,0.00,0.00,4493.93,0.00,'2022-08-01 17:52:52','',''),(3574,'21','221',NULL,1,'Sale Id shift 126',17219365.35,0.00,0.00,0.00,0.00,'2022-08-01 17:52:52','',''),(3575,'21','221',NULL,2,'Sale Id shift 126',3512153.30,0.00,0.00,0.00,0.00,'2022-08-01 17:52:52','',''),(3576,'21','221',NULL,3,'Sale Id shift 126',504390.00,0.00,0.00,0.00,0.00,'2022-08-01 17:52:52','',''),(3577,'21','221',NULL,1,'Reception corrector for bridging 343',0.00,0.00,0.00,13000.00,0.00,'2022-08-02 15:51:25','',''),(3578,'21','221','3',1,'Received from bridging 343',0.00,0.00,13000.00,0.00,0.00,'2022-08-02 15:51:25','',''),(3579,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-08-02 15:51:41','',''),(3580,'21','221',NULL,1,'Reception corrector for bridging 345',0.00,0.00,0.00,20000.00,0.00,'2022-08-02 15:53:32','',''),(3581,'21','221','2',1,'Received from bridging 345',0.00,0.00,20000.00,0.00,0.00,'2022-08-02 15:53:32','',''),(3582,'21','221',NULL,1,'Reception corrector for bridging 344',0.00,0.00,0.00,40000.00,0.00,'2022-08-02 15:53:32','',''),(3583,'21','221','1',1,'Received from bridging 344',0.00,0.00,40000.00,0.00,0.00,'2022-08-02 15:53:32','',''),(3584,'21','221','1',1,'Sale Id shift 127',0.00,0.00,0.00,7108.97,0.00,'2022-08-02 17:51:46','',''),(3585,'21','221','2',1,'Sale Id shift 127',0.00,0.00,0.00,5168.95,0.00,'2022-08-02 17:51:46','',''),(3586,'21','221','2',1,'Sale Id shift 127',0.00,0.00,0.00,3245.66,0.00,'2022-08-02 17:51:46','',''),(3587,'21','221','3',1,'Sale Id shift 127',0.00,0.00,0.00,2910.15,0.00,'2022-08-02 17:51:46','',''),(3588,'21','221','3',1,'Sale Id shift 127',0.00,0.00,0.00,1806.07,0.00,'2022-08-02 17:51:46','',''),(3589,'21','221','3',1,'Sale Id shift 127',0.00,0.00,0.00,3279.99,0.00,'2022-08-02 17:51:46','',''),(3590,'21','221','3',1,'Sale Id shift 127',0.00,0.00,0.00,2636.81,0.00,'2022-08-02 17:51:46','',''),(3591,'21','221','3',1,'Sale Id shift 127',0.00,0.00,0.00,2819.37,0.00,'2022-08-02 17:51:46','',''),(3592,'21','221','3',1,'Sale Id shift 127',0.00,0.00,0.00,3808.72,0.00,'2022-08-02 17:51:46','',''),(3593,'21','221','3',1,'Sale Id shift 127',0.00,0.00,0.00,3434.53,0.00,'2022-08-02 17:51:46','',''),(3594,'21','221','1',1,'Sale Id shift 127',0.00,0.00,0.00,23379.00,0.00,'2022-08-02 17:51:46','',''),(3595,'21','221','4',2,'Sale Id shift 127',0.00,0.00,0.00,2659.86,0.00,'2022-08-02 17:51:46','',''),(3596,'21','221','4',2,'Sale Id shift 127',0.00,0.00,0.00,3465.24,0.00,'2022-08-02 17:51:46','',''),(3597,'21','221','5',3,'Sale Id shift 127',0.00,0.00,0.00,382.25,0.00,'2022-08-02 17:51:46','',''),(3598,'21','221','3',1,'Sale Id shift 127',0.00,0.00,0.00,2455.09,0.00,'2022-08-02 17:51:46','',''),(3599,'21','221','1',1,'Sale Id shift 127',0.00,0.00,0.00,4728.27,0.00,'2022-08-02 17:51:46','',''),(3600,'21','221','1',1,'Sale Id shift 127',0.00,0.00,0.00,6000.00,0.00,'2022-08-02 17:51:46','',''),(3601,'21','221','2',1,'Sale Id shift 127',0.00,0.00,0.00,5756.96,0.00,'2022-08-02 17:51:46','',''),(3602,'21','221','2',1,'Sale Id shift 127',0.00,0.00,0.00,3827.68,0.00,'2022-08-02 17:51:46','',''),(3603,'21','221','2',1,'Sale Id shift 127',0.00,0.00,0.00,2370.65,0.00,'2022-08-02 17:51:46','',''),(3604,'21','221','2',1,'Sale Id shift 127',0.00,0.00,0.00,2538.14,0.00,'2022-08-02 17:51:46','',''),(3605,'21','221',NULL,1,'Sale Id shift 127',14400376.65,0.00,0.00,0.00,0.00,'2022-08-02 17:51:46','',''),(3606,'21','221',NULL,2,'Sale Id shift 127',5083833.00,0.00,0.00,0.00,0.00,'2022-08-02 17:51:46','',''),(3607,'21','221',NULL,3,'Sale Id shift 127',286687.50,0.00,0.00,0.00,0.00,'2022-08-02 17:51:46','',''),(3608,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-05 09:38:41','',''),(3609,'21','221',NULL,1,'Reception corrector for bridging 347',0.00,0.00,0.00,10000.00,0.00,'2022-08-05 09:40:58','',''),(3610,'21','221','2',1,'Received from bridging 347',0.00,0.00,10000.00,0.00,0.00,'2022-08-05 09:40:58','',''),(3611,'21','221',NULL,1,'Reception corrector for bridging 346',0.00,0.00,0.00,40000.00,0.00,'2022-08-05 09:40:58','',''),(3612,'21','221','1',1,'Received from bridging 346',0.00,0.00,40000.00,0.00,0.00,'2022-08-05 09:40:58','',''),(3613,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24900000.00,30000.00,0.00,0.00,'2022-08-05 09:41:14','',''),(3614,'21','221',NULL,2,'Reception corrector for bridging 348',0.00,0.00,0.00,28000.00,0.00,'2022-08-05 09:42:47','',''),(3615,'21','221','4',2,'Received from bridging 348',0.00,0.00,28000.00,0.00,0.00,'2022-08-05 09:42:47','',''),(3616,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-05 09:43:04','',''),(3617,'21','221',NULL,1,'Reception corrector for bridging 350',0.00,0.00,0.00,25000.00,0.00,'2022-08-05 09:45:23','',''),(3618,'21','221','3',1,'Received from bridging 350',0.00,0.00,25000.00,0.00,0.00,'2022-08-05 09:45:23','',''),(3619,'21','221',NULL,1,'Reception corrector for bridging 349',0.00,0.00,0.00,25000.00,0.00,'2022-08-05 09:45:23','',''),(3620,'21','221','2',1,'Received from bridging 349',0.00,0.00,25000.00,0.00,0.00,'2022-08-05 09:45:23','',''),(3621,'21','221','1',1,'Sale Id shift 128',0.00,0.00,0.00,4338.57,0.00,'2022-08-05 11:41:20','',''),(3622,'21','221','2',1,'Sale Id shift 128',0.00,0.00,0.00,4233.93,0.00,'2022-08-05 11:41:20','',''),(3623,'21','221','2',1,'Sale Id shift 128',0.00,0.00,0.00,3287.04,0.00,'2022-08-05 11:41:20','',''),(3624,'21','221','3',1,'Sale Id shift 128',0.00,0.00,0.00,3830.59,0.00,'2022-08-05 11:41:20','',''),(3625,'21','221','3',1,'Sale Id shift 128',0.00,0.00,0.00,3022.97,0.00,'2022-08-05 11:41:20','',''),(3626,'21','221','3',1,'Sale Id shift 128',0.00,0.00,0.00,2634.43,0.00,'2022-08-05 11:41:20','',''),(3627,'21','221','3',1,'Sale Id shift 128',0.00,0.00,0.00,2534.66,0.00,'2022-08-05 11:41:20','',''),(3628,'21','221','3',1,'Sale Id shift 128',0.00,0.00,0.00,2796.60,0.00,'2022-08-05 11:41:20','',''),(3629,'21','221','3',1,'Sale Id shift 128',0.00,0.00,0.00,3256.45,0.00,'2022-08-05 11:41:20','',''),(3630,'21','221','3',1,'Sale Id shift 128',0.00,0.00,0.00,3105.34,0.00,'2022-08-05 11:41:20','',''),(3631,'21','221','1',1,'Sale Id shift 128',0.00,0.00,0.00,2981.03,0.00,'2022-08-05 11:41:20','',''),(3632,'21','221','4',2,'Sale Id shift 128',0.00,0.00,0.00,744.52,0.00,'2022-08-05 11:41:20','',''),(3633,'21','221','4',2,'Sale Id shift 128',0.00,0.00,0.00,20927.11,0.00,'2022-08-05 11:41:20','',''),(3634,'21','221','5',3,'Sale Id shift 128',0.00,0.00,0.00,508.20,0.00,'2022-08-05 11:41:20','',''),(3635,'21','221','3',1,'Sale Id shift 128',0.00,0.00,0.00,3798.18,0.00,'2022-08-05 11:41:20','',''),(3636,'21','221','1',1,'Sale Id shift 128',0.00,0.00,0.00,8094.76,0.00,'2022-08-05 11:41:20','',''),(3637,'21','221','1',1,'Sale Id shift 128',0.00,0.00,0.00,1348.54,0.00,'2022-08-05 11:41:20','',''),(3638,'21','221','2',1,'Sale Id shift 128',0.00,0.00,0.00,7065.42,0.00,'2022-08-05 11:41:20','',''),(3639,'21','221','2',1,'Sale Id shift 128',0.00,0.00,0.00,3948.16,0.00,'2022-08-05 11:41:20','',''),(3640,'21','221','2',1,'Sale Id shift 128',0.00,0.00,0.00,3525.74,0.00,'2022-08-05 11:41:20','',''),(3641,'21','221','2',1,'Sale Id shift 128',0.00,0.00,0.00,4796.89,0.00,'2022-08-05 11:41:20','',''),(3642,'21','221',NULL,1,'Sale Id shift 128',12690870.50,0.00,0.00,0.00,0.00,'2022-08-05 11:41:20','',''),(3643,'21','221',NULL,2,'Sale Id shift 128',17987452.90,0.00,0.00,0.00,0.00,'2022-08-05 11:41:20','',''),(3644,'21','221',NULL,3,'Sale Id shift 128',381150.00,0.00,0.00,0.00,0.00,'2022-08-05 11:41:20','',''),(3645,'21','221',NULL,2,'Reception corrector for bridging 351',0.00,0.00,0.00,2000.00,0.00,'2022-08-05 11:56:14','',''),(3646,'21','221','4',2,'Received from bridging 351',0.00,0.00,2000.00,0.00,0.00,'2022-08-05 11:56:14','',''),(3647,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-05 11:56:32','',''),(3648,'21','221',NULL,1,'Reception corrector for bridging 354',0.00,0.00,0.00,15000.00,0.00,'2022-08-05 11:58:21','',''),(3649,'21','221','3',1,'Received from bridging 354',0.00,0.00,15000.00,0.00,0.00,'2022-08-05 11:58:21','',''),(3650,'21','221',NULL,1,'Reception corrector for bridging 353',0.00,0.00,0.00,15000.00,0.00,'2022-08-05 11:58:21','',''),(3651,'21','221','2',1,'Received from bridging 353',0.00,0.00,15000.00,0.00,0.00,'2022-08-05 11:58:21','',''),(3652,'21','221',NULL,1,'Reception corrector for bridging 352',0.00,0.00,0.00,15000.00,0.00,'2022-08-05 11:58:21','',''),(3653,'21','221','1',1,'Received from bridging 352',0.00,0.00,15000.00,0.00,0.00,'2022-08-05 11:58:21','',''),(3654,'21','221','1',1,'Sale Id shift 129',0.00,0.00,0.00,4078.10,0.00,'2022-08-06 12:25:37','',''),(3655,'21','221','2',1,'Sale Id shift 129',0.00,0.00,0.00,5732.11,0.00,'2022-08-06 12:25:37','',''),(3656,'21','221','2',1,'Sale Id shift 129',0.00,0.00,0.00,5863.99,0.00,'2022-08-06 12:25:37','',''),(3657,'21','221','3',1,'Sale Id shift 129',0.00,0.00,0.00,3237.05,0.00,'2022-08-06 12:25:37','',''),(3658,'21','221','3',1,'Sale Id shift 129',0.00,0.00,0.00,3483.97,0.00,'2022-08-06 12:25:37','',''),(3659,'21','221','3',1,'Sale Id shift 129',0.00,0.00,0.00,2930.16,0.00,'2022-08-06 12:25:37','',''),(3660,'21','221','3',1,'Sale Id shift 129',0.00,0.00,0.00,4288.65,0.00,'2022-08-06 12:25:37','',''),(3661,'21','221','3',1,'Sale Id shift 129',0.00,0.00,0.00,1966.39,0.00,'2022-08-06 12:25:37','',''),(3662,'21','221','3',1,'Sale Id shift 129',0.00,0.00,0.00,2449.26,0.00,'2022-08-06 12:25:37','',''),(3663,'21','221','3',1,'Sale Id shift 129',0.00,0.00,0.00,3707.50,0.00,'2022-08-06 12:25:37','',''),(3664,'21','221','1',1,'Sale Id shift 129',0.00,0.00,0.00,5108.86,0.00,'2022-08-06 12:25:37','',''),(3665,'21','221','4',2,'Sale Id shift 129',0.00,0.00,0.00,1155.08,0.00,'2022-08-06 12:25:37','',''),(3666,'21','221','4',2,'Sale Id shift 129',0.00,0.00,0.00,9191.29,0.00,'2022-08-06 12:25:37','',''),(3667,'21','221','5',3,'Sale Id shift 129',0.00,0.00,0.00,456.96,0.00,'2022-08-06 12:25:37','',''),(3668,'21','221','3',1,'Sale Id shift 129',0.00,0.00,0.00,3542.44,0.00,'2022-08-06 12:25:37','',''),(3669,'21','221','1',1,'Sale Id shift 129',0.00,0.00,0.00,1459.70,0.00,'2022-08-06 12:25:37','',''),(3670,'21','221','1',1,'Sale Id shift 129',0.00,0.00,0.00,6186.61,0.00,'2022-08-06 12:25:37','',''),(3671,'21','221','2',1,'Sale Id shift 129',0.00,0.00,0.00,5295.67,0.00,'2022-08-06 12:25:37','',''),(3672,'21','221','2',1,'Sale Id shift 129',0.00,0.00,0.00,6225.65,0.00,'2022-08-06 12:25:37','',''),(3673,'21','221','2',1,'Sale Id shift 129',0.00,0.00,0.00,2663.62,0.00,'2022-08-06 12:25:37','',''),(3674,'21','221','2',1,'Sale Id shift 129',0.00,0.00,0.00,822.52,0.00,'2022-08-06 12:25:37','',''),(3675,'21','221',NULL,1,'Sale Id shift 129',12772816.25,0.00,0.00,0.00,0.00,'2022-08-06 12:25:37','',''),(3676,'21','221',NULL,2,'Sale Id shift 129',8587487.10,0.00,0.00,0.00,0.00,'2022-08-06 12:25:37','',''),(3677,'21','221',NULL,3,'Sale Id shift 129',342720.00,0.00,0.00,0.00,0.00,'2022-08-06 12:25:37','',''),(3678,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-06 12:36:28','',''),(3679,'21','221',NULL,1,'Reception corrector for bridging 355',0.00,0.00,0.00,50000.00,0.00,'2022-08-06 12:37:54','',''),(3680,'21','221','3',1,'Received from bridging 355',0.00,0.00,50000.00,0.00,0.00,'2022-08-06 12:37:54','',''),(3681,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-06 12:38:54','',''),(3682,'21','221',NULL,1,'Reception corrector for bridging 357',0.00,0.00,0.00,25000.00,0.00,'2022-08-06 12:40:07','',''),(3683,'21','221','2',1,'Received from bridging 357',0.00,0.00,25000.00,0.00,0.00,'2022-08-06 12:40:07','',''),(3684,'21','221',NULL,1,'Reception corrector for bridging 356',0.00,0.00,0.00,20000.00,0.00,'2022-08-06 12:40:07','',''),(3685,'21','221','1',1,'Received from bridging 356',0.00,0.00,20000.00,0.00,0.00,'2022-08-06 12:40:07','',''),(3686,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24900000.00,30000.00,0.00,0.00,'2022-08-06 12:40:24','',''),(3687,'21','221',NULL,2,'Reception corrector for bridging 358',0.00,0.00,0.00,30000.00,0.00,'2022-08-06 12:54:38','',''),(3688,'21','221','4',2,'Received from bridging 358',0.00,0.00,30000.00,0.00,0.00,'2022-08-06 12:54:38','',''),(3689,'21','221','1',1,'Sale Id shift 131',0.00,0.00,0.00,2106.12,0.00,'2022-08-06 16:27:42','',''),(3690,'21','221','2',1,'Sale Id shift 131',0.00,0.00,0.00,3468.84,0.00,'2022-08-06 16:27:42','',''),(3691,'21','221','2',1,'Sale Id shift 131',0.00,0.00,0.00,2775.36,0.00,'2022-08-06 16:27:42','',''),(3692,'21','221','3',1,'Sale Id shift 131',0.00,0.00,0.00,3277.14,0.00,'2022-08-06 16:27:42','',''),(3693,'21','221','3',1,'Sale Id shift 131',0.00,0.00,0.00,2632.95,0.00,'2022-08-06 16:27:42','',''),(3694,'21','221','3',1,'Sale Id shift 131',0.00,0.00,0.00,1526.38,0.00,'2022-08-06 16:27:42','',''),(3695,'21','221','3',1,'Sale Id shift 131',0.00,0.00,0.00,2155.91,0.00,'2022-08-06 16:27:42','',''),(3696,'21','221','3',1,'Sale Id shift 131',0.00,0.00,0.00,1835.62,0.00,'2022-08-06 16:27:42','',''),(3697,'21','221','3',1,'Sale Id shift 131',0.00,0.00,0.00,3492.03,0.00,'2022-08-06 16:27:42','',''),(3698,'21','221','3',1,'Sale Id shift 131',0.00,0.00,0.00,3200.08,0.00,'2022-08-06 16:27:42','',''),(3699,'21','221','1',1,'Sale Id shift 131',0.00,0.00,0.00,3882.62,0.00,'2022-08-06 16:27:42','',''),(3700,'21','221','4',2,'Sale Id shift 131',0.00,0.00,0.00,2248.45,0.00,'2022-08-06 16:27:42','',''),(3701,'21','221','5',3,'Sale Id shift 131',0.00,0.00,0.00,293.90,0.00,'2022-08-06 16:27:42','',''),(3702,'21','221','3',1,'Sale Id shift 131',0.00,0.00,0.00,3658.90,0.00,'2022-08-06 16:27:42','',''),(3703,'21','221','1',1,'Sale Id shift 131',0.00,0.00,0.00,3743.14,0.00,'2022-08-06 16:27:42','',''),(3704,'21','221','1',1,'Sale Id shift 131',0.00,0.00,0.00,2720.77,0.00,'2022-08-06 16:27:42','',''),(3705,'21','221','2',1,'Sale Id shift 131',0.00,0.00,0.00,4843.20,0.00,'2022-08-06 16:27:42','',''),(3706,'21','221','2',1,'Sale Id shift 131',0.00,0.00,0.00,3539.34,0.00,'2022-08-06 16:27:42','',''),(3707,'21','221','2',1,'Sale Id shift 131',0.00,0.00,0.00,2874.53,0.00,'2022-08-06 16:27:42','',''),(3708,'21','221','2',1,'Sale Id shift 131',0.00,0.00,0.00,3164.42,0.00,'2022-08-06 16:27:42','',''),(3709,'21','221',NULL,1,'Sale Id shift 131',9607036.25,0.00,0.00,0.00,0.00,'2022-08-06 16:27:42','',''),(3710,'21','221',NULL,2,'Sale Id shift 131',1866213.50,0.00,0.00,0.00,0.00,'2022-08-06 16:27:42','',''),(3711,'21','221',NULL,3,'Sale Id shift 131',220425.00,0.00,0.00,0.00,0.00,'2022-08-06 16:27:42','',''),(3712,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-07 12:13:45','',''),(3713,'21','221',NULL,1,'Reception corrector for bridging 361',0.00,0.00,0.00,15000.00,0.00,'2022-08-07 12:15:01','',''),(3714,'21','221','3',1,'Received from bridging 361',0.00,0.00,15000.00,0.00,0.00,'2022-08-07 12:15:01','',''),(3715,'21','221',NULL,1,'Reception corrector for bridging 360',0.00,0.00,0.00,20000.00,0.00,'2022-08-07 12:15:01','',''),(3716,'21','221','2',1,'Received from bridging 360',0.00,0.00,20000.00,0.00,0.00,'2022-08-07 12:15:01','',''),(3717,'21','221',NULL,1,'Reception corrector for bridging 359',0.00,0.00,0.00,15000.00,0.00,'2022-08-07 12:15:01','',''),(3718,'21','221','1',1,'Received from bridging 359',0.00,0.00,15000.00,0.00,0.00,'2022-08-07 12:15:01','',''),(3719,'21','221','1',1,'Sale Id shift 132',0.00,0.00,0.00,3518.57,0.00,'2022-08-07 14:32:28','',''),(3720,'21','221','2',1,'Sale Id shift 132',0.00,0.00,0.00,7160.45,0.00,'2022-08-07 14:32:28','',''),(3721,'21','221','2',1,'Sale Id shift 132',0.00,0.00,0.00,2958.17,0.00,'2022-08-07 14:32:28','',''),(3722,'21','221','3',1,'Sale Id shift 132',0.00,0.00,0.00,4575.45,0.00,'2022-08-07 14:32:28','',''),(3723,'21','221','3',1,'Sale Id shift 132',0.00,0.00,0.00,3907.40,0.00,'2022-08-07 14:32:28','',''),(3724,'21','221','3',1,'Sale Id shift 132',0.00,0.00,0.00,4726.95,0.00,'2022-08-07 14:32:28','',''),(3725,'21','221','3',1,'Sale Id shift 132',0.00,0.00,0.00,3081.23,0.00,'2022-08-07 14:32:28','',''),(3726,'21','221','3',1,'Sale Id shift 132',0.00,0.00,0.00,4590.58,0.00,'2022-08-07 14:32:28','',''),(3727,'21','221','3',1,'Sale Id shift 132',0.00,0.00,0.00,3310.94,0.00,'2022-08-07 14:32:28','',''),(3728,'21','221','3',1,'Sale Id shift 132',0.00,0.00,0.00,4401.74,0.00,'2022-08-07 14:32:28','',''),(3729,'21','221','1',1,'Sale Id shift 132',0.00,0.00,0.00,2871.18,0.00,'2022-08-07 14:32:28','',''),(3730,'21','221','4',2,'Sale Id shift 132',0.00,0.00,0.00,649.16,0.00,'2022-08-07 14:32:28','',''),(3731,'21','221','4',2,'Sale Id shift 132',0.00,0.00,0.00,3293.08,0.00,'2022-08-07 14:32:28','',''),(3732,'21','221','5',3,'Sale Id shift 132',0.00,0.00,0.00,576.71,0.00,'2022-08-07 14:32:28','',''),(3733,'21','221','3',1,'Sale Id shift 132',0.00,0.00,0.00,4386.83,0.00,'2022-08-07 14:32:28','',''),(3734,'21','221','1',1,'Sale Id shift 132',0.00,0.00,0.00,3126.75,0.00,'2022-08-07 14:32:28','',''),(3735,'21','221','1',1,'Sale Id shift 132',0.00,0.00,0.00,3847.20,0.00,'2022-08-07 14:32:28','',''),(3736,'21','221','2',1,'Sale Id shift 132',0.00,0.00,0.00,7601.48,0.00,'2022-08-07 14:32:28','',''),(3737,'21','221','2',1,'Sale Id shift 132',0.00,0.00,0.00,2313.71,0.00,'2022-08-07 14:32:28','',''),(3738,'21','221','2',1,'Sale Id shift 132',0.00,0.00,0.00,5991.61,0.00,'2022-08-07 14:32:28','',''),(3739,'21','221','2',1,'Sale Id shift 132',0.00,0.00,0.00,6186.82,0.00,'2022-08-07 14:32:28','',''),(3740,'21','221',NULL,1,'Sale Id shift 132',14533056.10,0.00,0.00,0.00,0.00,'2022-08-07 14:32:28','',''),(3741,'21','221',NULL,2,'Sale Id shift 132',3272059.20,0.00,0.00,0.00,0.00,'2022-08-07 14:32:28','',''),(3742,'21','221',NULL,3,'Sale Id shift 132',432532.50,0.00,0.00,0.00,0.00,'2022-08-07 14:32:28','',''),(3743,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-08-08 13:54:14','',''),(3744,'21','221',NULL,1,'Reception corrector for bridging 364',0.00,0.00,0.00,20000.00,0.00,'2022-08-08 13:57:11','',''),(3745,'21','221','3',1,'Received from bridging 364',0.00,0.00,20000.00,0.00,0.00,'2022-08-08 13:57:11','',''),(3746,'21','221',NULL,1,'Reception corrector for bridging 363',0.00,0.00,0.00,26000.00,0.00,'2022-08-08 13:57:11','',''),(3747,'21','221','2',1,'Received from bridging 363',0.00,0.00,26000.00,0.00,0.00,'2022-08-08 13:57:11','',''),(3748,'21','221',NULL,1,'Reception corrector for bridging 362',0.00,0.00,0.00,14000.00,0.00,'2022-08-08 13:57:11','',''),(3749,'21','221','1',1,'Received from bridging 362',0.00,0.00,14000.00,0.00,0.00,'2022-08-08 13:57:11','',''),(3750,'21','221','1',1,'Sale Id shift 133',0.00,0.00,0.00,2476.22,0.00,'2022-08-08 18:47:48','',''),(3751,'21','221','2',1,'Sale Id shift 133',0.00,0.00,0.00,4185.20,0.00,'2022-08-08 18:47:48','',''),(3752,'21','221','2',1,'Sale Id shift 133',0.00,0.00,0.00,2989.61,0.00,'2022-08-08 18:47:48','',''),(3753,'21','221','3',1,'Sale Id shift 133',0.00,0.00,0.00,2363.94,0.00,'2022-08-08 18:47:48','',''),(3754,'21','221','3',1,'Sale Id shift 133',0.00,0.00,0.00,2188.23,0.00,'2022-08-08 18:47:48','',''),(3755,'21','221','3',1,'Sale Id shift 133',0.00,0.00,0.00,2681.30,0.00,'2022-08-08 18:47:48','',''),(3756,'21','221','3',1,'Sale Id shift 133',0.00,0.00,0.00,2053.87,0.00,'2022-08-08 18:47:48','',''),(3757,'21','221','3',1,'Sale Id shift 133',0.00,0.00,0.00,2479.61,0.00,'2022-08-08 18:47:48','',''),(3758,'21','221','3',1,'Sale Id shift 133',0.00,0.00,0.00,2256.77,0.00,'2022-08-08 18:47:48','',''),(3759,'21','221','3',1,'Sale Id shift 133',0.00,0.00,0.00,2511.82,0.00,'2022-08-08 18:47:48','',''),(3760,'21','221','1',1,'Sale Id shift 133',0.00,0.00,0.00,9948.09,0.00,'2022-08-08 18:47:48','',''),(3761,'21','221','4',2,'Sale Id shift 133',0.00,0.00,0.00,1927.95,0.00,'2022-08-08 18:47:48','',''),(3762,'21','221','4',2,'Sale Id shift 133',0.00,0.00,0.00,6128.97,0.00,'2022-08-08 18:47:48','',''),(3763,'21','221','5',3,'Sale Id shift 133',0.00,0.00,0.00,541.15,0.00,'2022-08-08 18:47:48','',''),(3764,'21','221','3',1,'Sale Id shift 133',0.00,0.00,0.00,2824.80,0.00,'2022-08-08 18:47:48','',''),(3765,'21','221','1',1,'Sale Id shift 133',0.00,0.00,0.00,21409.35,0.00,'2022-08-08 18:47:48','',''),(3766,'21','221','1',1,'Sale Id shift 133',0.00,0.00,0.00,10367.54,0.00,'2022-08-08 18:47:48','',''),(3767,'21','221','2',1,'Sale Id shift 133',0.00,0.00,0.00,4698.50,0.00,'2022-08-08 18:47:48','',''),(3768,'21','221','2',1,'Sale Id shift 133',0.00,0.00,0.00,2651.85,0.00,'2022-08-08 18:47:48','',''),(3769,'21','221','2',1,'Sale Id shift 133',0.00,0.00,0.00,2739.03,0.00,'2022-08-08 18:47:48','',''),(3770,'21','221','2',1,'Sale Id shift 133',0.00,0.00,0.00,1449.94,0.00,'2022-08-08 18:47:48','',''),(3771,'21','221',NULL,1,'Sale Id shift 133',15220998.95,0.00,0.00,0.00,0.00,'2022-08-08 18:47:48','',''),(3772,'21','221',NULL,2,'Sale Id shift 133',6687243.60,0.00,0.00,0.00,0.00,'2022-08-08 18:47:48','',''),(3773,'21','221',NULL,3,'Sale Id shift 133',405862.50,0.00,0.00,0.00,0.00,'2022-08-08 18:47:48','',''),(3774,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-09 11:53:50','',''),(3775,'21','221',NULL,1,'Reception corrector for bridging 366',0.00,0.00,0.00,1000.00,0.00,'2022-08-09 11:56:12','',''),(3776,'21','221','2',1,'Received from bridging 366',0.00,0.00,1000.00,0.00,0.00,'2022-08-09 11:56:12','',''),(3777,'21','221',NULL,1,'Reception corrector for bridging 365',0.00,0.00,0.00,44000.00,0.00,'2022-08-09 11:56:13','',''),(3778,'21','221','1',1,'Received from bridging 365',0.00,0.00,44000.00,0.00,0.00,'2022-08-09 11:56:13','',''),(3779,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,60000.00,0.00,0.00,'2022-08-09 11:56:32','',''),(3780,'21','221',NULL,1,'Reception corrector for bridging 368',0.00,0.00,0.00,30000.00,0.00,'2022-08-09 11:58:18','',''),(3781,'21','221','3',1,'Received from bridging 368',0.00,0.00,30000.00,0.00,0.00,'2022-08-09 11:58:18','',''),(3782,'21','221',NULL,1,'Reception corrector for bridging 367',0.00,0.00,0.00,30000.00,0.00,'2022-08-09 11:58:18','',''),(3783,'21','221','2',1,'Received from bridging 367',0.00,0.00,30000.00,0.00,0.00,'2022-08-09 11:58:18','',''),(3784,'21','221','1',1,'Sale Id shift 134',0.00,0.00,0.00,1421.71,0.00,'2022-08-09 14:44:43','',''),(3785,'21','221','2',1,'Sale Id shift 134',0.00,0.00,0.00,5917.05,0.00,'2022-08-09 14:44:43','',''),(3786,'21','221','2',1,'Sale Id shift 134',0.00,0.00,0.00,2534.63,0.00,'2022-08-09 14:44:43','',''),(3787,'21','221','3',1,'Sale Id shift 134',0.00,0.00,0.00,2586.99,0.00,'2022-08-09 14:44:43','',''),(3788,'21','221','3',1,'Sale Id shift 134',0.00,0.00,0.00,1366.31,0.00,'2022-08-09 14:44:43','',''),(3789,'21','221','3',1,'Sale Id shift 134',0.00,0.00,0.00,2861.15,0.00,'2022-08-09 14:44:43','',''),(3790,'21','221','3',1,'Sale Id shift 134',0.00,0.00,0.00,2046.81,0.00,'2022-08-09 14:44:43','',''),(3791,'21','221','3',1,'Sale Id shift 134',0.00,0.00,0.00,2801.38,0.00,'2022-08-09 14:44:43','',''),(3792,'21','221','3',1,'Sale Id shift 134',0.00,0.00,0.00,2821.52,0.00,'2022-08-09 14:44:43','',''),(3793,'21','221','3',1,'Sale Id shift 134',0.00,0.00,0.00,2762.84,0.00,'2022-08-09 14:44:43','',''),(3794,'21','221','1',1,'Sale Id shift 134',0.00,0.00,0.00,1616.94,0.00,'2022-08-09 14:44:43','',''),(3795,'21','221','4',2,'Sale Id shift 134',0.00,0.00,0.00,2586.91,0.00,'2022-08-09 14:44:43','',''),(3796,'21','221','4',2,'Sale Id shift 134',0.00,0.00,0.00,3254.87,0.00,'2022-08-09 14:44:43','',''),(3797,'21','221','5',3,'Sale Id shift 134',0.00,0.00,0.00,589.82,0.00,'2022-08-09 14:44:43','',''),(3798,'21','221','3',1,'Sale Id shift 134',0.00,0.00,0.00,3461.62,0.00,'2022-08-09 14:44:43','',''),(3799,'21','221','1',1,'Sale Id shift 134',0.00,0.00,0.00,1520.69,0.00,'2022-08-09 14:44:43','',''),(3800,'21','221','1',1,'Sale Id shift 134',0.00,0.00,0.00,6389.83,0.00,'2022-08-09 14:44:43','',''),(3801,'21','221','2',1,'Sale Id shift 134',0.00,0.00,0.00,5050.46,0.00,'2022-08-09 14:44:43','',''),(3802,'21','221','2',1,'Sale Id shift 134',0.00,0.00,0.00,2464.61,0.00,'2022-08-09 14:44:43','',''),(3803,'21','221','2',1,'Sale Id shift 134',0.00,0.00,0.00,3964.53,0.00,'2022-08-09 14:44:43','',''),(3804,'21','221','2',1,'Sale Id shift 134',0.00,0.00,0.00,3397.67,0.00,'2022-08-09 14:44:43','',''),(3805,'21','221',NULL,1,'Sale Id shift 134',9622679.50,0.00,0.00,0.00,0.00,'2022-08-09 14:44:43','',''),(3806,'21','221',NULL,2,'Sale Id shift 134',4848677.40,0.00,0.00,0.00,0.00,'2022-08-09 14:44:43','',''),(3807,'21','221',NULL,3,'Sale Id shift 134',442365.00,0.00,0.00,0.00,0.00,'2022-08-09 14:44:43','',''),(3808,'21','221',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12450000.00,15000.00,0.00,0.00,'2022-08-09 15:10:32','',''),(3809,'21','221',NULL,2,'Reception corrector for bridging 369',0.00,0.00,0.00,15000.00,0.00,'2022-08-09 15:13:02','',''),(3810,'21','221','4',2,'Received from bridging 369',0.00,0.00,15000.00,0.00,0.00,'2022-08-09 15:13:02','',''),(3811,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,60000.00,0.00,0.00,'2022-08-09 15:13:31','',''),(3812,'21','221',NULL,1,'Reception corrector for bridging 372',0.00,0.00,0.00,25000.00,0.00,'2022-08-09 15:17:02','',''),(3813,'21','221','3',1,'Received from bridging 372',0.00,0.00,25000.00,0.00,0.00,'2022-08-09 15:17:02','',''),(3814,'21','221',NULL,1,'Reception corrector for bridging 371',0.00,0.00,0.00,25000.00,0.00,'2022-08-09 15:17:02','',''),(3815,'21','221','2',1,'Received from bridging 371',0.00,0.00,25000.00,0.00,0.00,'2022-08-09 15:17:02','',''),(3816,'21','221',NULL,1,'Reception corrector for bridging 370',0.00,0.00,0.00,10000.00,0.00,'2022-08-09 15:17:02','',''),(3817,'21','221','1',1,'Received from bridging 370',0.00,0.00,10000.00,0.00,0.00,'2022-08-09 15:17:02','',''),(3818,'21','221','1',1,'Sale Id shift 135',0.00,0.00,0.00,2388.93,0.00,'2022-08-09 17:04:42','',''),(3819,'21','221','2',1,'Sale Id shift 135',0.00,0.00,0.00,6619.66,0.00,'2022-08-09 17:04:42','',''),(3820,'21','221','2',1,'Sale Id shift 135',0.00,0.00,0.00,3221.25,0.00,'2022-08-09 17:04:42','',''),(3821,'21','221','3',1,'Sale Id shift 135',0.00,0.00,0.00,3151.65,0.00,'2022-08-09 17:04:42','',''),(3822,'21','221','3',1,'Sale Id shift 135',0.00,0.00,0.00,3107.21,0.00,'2022-08-09 17:04:42','',''),(3823,'21','221','3',1,'Sale Id shift 135',0.00,0.00,0.00,2557.41,0.00,'2022-08-09 17:04:42','',''),(3824,'21','221','3',1,'Sale Id shift 135',0.00,0.00,0.00,2402.09,0.00,'2022-08-09 17:04:42','',''),(3825,'21','221','3',1,'Sale Id shift 135',0.00,0.00,0.00,3069.71,0.00,'2022-08-09 17:04:42','',''),(3826,'21','221','3',1,'Sale Id shift 135',0.00,0.00,0.00,4386.11,0.00,'2022-08-09 17:04:42','',''),(3827,'21','221','3',1,'Sale Id shift 135',0.00,0.00,0.00,3042.97,0.00,'2022-08-09 17:04:42','',''),(3828,'21','221','1',1,'Sale Id shift 135',0.00,0.00,0.00,1664.54,0.00,'2022-08-09 17:04:42','',''),(3829,'21','221','4',2,'Sale Id shift 135',0.00,0.00,0.00,206.00,0.00,'2022-08-09 17:04:42','',''),(3830,'21','221','4',2,'Sale Id shift 135',0.00,0.00,0.00,4140.47,0.00,'2022-08-09 17:04:42','',''),(3831,'21','221','5',3,'Sale Id shift 135',0.00,0.00,0.00,688.43,0.00,'2022-08-09 17:04:42','',''),(3832,'21','221','3',1,'Sale Id shift 135',0.00,0.00,0.00,5178.65,0.00,'2022-08-09 17:04:42','',''),(3833,'21','221','1',1,'Sale Id shift 135',0.00,0.00,0.00,2890.96,0.00,'2022-08-09 17:04:42','',''),(3834,'21','221','1',1,'Sale Id shift 135',0.00,0.00,0.00,2353.27,0.00,'2022-08-09 17:04:42','',''),(3835,'21','221','2',1,'Sale Id shift 135',0.00,0.00,0.00,5207.98,0.00,'2022-08-09 17:04:42','',''),(3836,'21','221','2',1,'Sale Id shift 135',0.00,0.00,0.00,3711.21,0.00,'2022-08-09 17:04:42','',''),(3837,'21','221','2',1,'Sale Id shift 135',0.00,0.00,0.00,3223.62,0.00,'2022-08-09 17:04:42','',''),(3838,'21','221','2',1,'Sale Id shift 135',0.00,0.00,0.00,2632.10,0.00,'2022-08-09 17:04:42','',''),(3839,'21','221',NULL,1,'Sale Id shift 135',10641631.00,0.00,0.00,0.00,0.00,'2022-08-09 17:04:42','',''),(3840,'21','221',NULL,2,'Sale Id shift 135',3607570.10,0.00,0.00,0.00,0.00,'2022-08-09 17:04:42','',''),(3841,'21','221',NULL,3,'Sale Id shift 135',516322.50,0.00,0.00,0.00,0.00,'2022-08-09 17:04:42','',''),(3842,'21','221','1',1,'Sale Id shift 136',0.00,0.00,0.00,1716.78,0.00,'2022-08-10 13:59:43','',''),(3843,'21','221','2',1,'Sale Id shift 136',0.00,0.00,0.00,4790.02,0.00,'2022-08-10 13:59:43','',''),(3844,'21','221','2',1,'Sale Id shift 136',0.00,0.00,0.00,2709.04,0.00,'2022-08-10 13:59:43','',''),(3845,'21','221','3',1,'Sale Id shift 136',0.00,0.00,0.00,2062.48,0.00,'2022-08-10 13:59:43','',''),(3846,'21','221','3',1,'Sale Id shift 136',0.00,0.00,0.00,1804.08,0.00,'2022-08-10 13:59:43','',''),(3847,'21','221','3',1,'Sale Id shift 136',0.00,0.00,0.00,2796.63,0.00,'2022-08-10 13:59:43','',''),(3848,'21','221','3',1,'Sale Id shift 136',0.00,0.00,0.00,1902.37,0.00,'2022-08-10 13:59:43','',''),(3849,'21','221','3',1,'Sale Id shift 136',0.00,0.00,0.00,2501.47,0.00,'2022-08-10 13:59:43','',''),(3850,'21','221','3',1,'Sale Id shift 136',0.00,0.00,0.00,2637.01,0.00,'2022-08-10 13:59:43','',''),(3851,'21','221','3',1,'Sale Id shift 136',0.00,0.00,0.00,2286.88,0.00,'2022-08-10 13:59:43','',''),(3852,'21','221','1',1,'Sale Id shift 136',0.00,0.00,0.00,1221.13,0.00,'2022-08-10 13:59:43','',''),(3853,'21','221','4',2,'Sale Id shift 136',0.00,0.00,0.00,2208.41,0.00,'2022-08-10 13:59:43','',''),(3854,'21','221','5',3,'Sale Id shift 136',0.00,0.00,0.00,474.02,0.00,'2022-08-10 13:59:43','',''),(3855,'21','221','3',1,'Sale Id shift 136',0.00,0.00,0.00,2762.21,0.00,'2022-08-10 13:59:43','',''),(3856,'21','221','1',1,'Sale Id shift 136',0.00,0.00,0.00,2223.47,0.00,'2022-08-10 13:59:43','',''),(3857,'21','221','1',1,'Sale Id shift 136',0.00,0.00,0.00,1262.00,0.00,'2022-08-10 13:59:43','',''),(3858,'21','221','2',1,'Sale Id shift 136',0.00,0.00,0.00,4358.12,0.00,'2022-08-10 13:59:43','',''),(3859,'21','221','2',1,'Sale Id shift 136',0.00,0.00,0.00,2039.66,0.00,'2022-08-10 13:59:43','',''),(3860,'21','221','2',1,'Sale Id shift 136',0.00,0.00,0.00,2672.53,0.00,'2022-08-10 13:59:43','',''),(3861,'21','221','2',1,'Sale Id shift 136',0.00,0.00,0.00,2720.49,0.00,'2022-08-10 13:59:43','',''),(3862,'21','221',NULL,1,'Sale Id shift 136',7781614.75,0.00,0.00,0.00,0.00,'2022-08-10 13:59:43','',''),(3863,'21','221',NULL,2,'Sale Id shift 136',1832980.30,0.00,0.00,0.00,0.00,'2022-08-10 13:59:43','',''),(3864,'21','221',NULL,3,'Sale Id shift 136',355515.00,0.00,0.00,0.00,0.00,'2022-08-10 13:59:43','',''),(3865,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,60000.00,0.00,0.00,'2022-08-10 14:22:16','',''),(3866,'21','221',NULL,1,'Reception corrector for bridging 375',0.00,0.00,0.00,25000.00,0.00,'2022-08-10 14:32:09','',''),(3867,'21','221','3',1,'Received from bridging 375',0.00,0.00,25000.00,0.00,0.00,'2022-08-10 14:32:09','',''),(3868,'21','221',NULL,1,'Reception corrector for bridging 374',0.00,0.00,0.00,25000.00,0.00,'2022-08-10 14:32:09','',''),(3869,'21','221','2',1,'Received from bridging 374',0.00,0.00,25000.00,0.00,0.00,'2022-08-10 14:32:09','',''),(3870,'21','221',NULL,1,'Reception corrector for bridging 373',0.00,0.00,0.00,10000.00,0.00,'2022-08-10 14:32:09','',''),(3871,'21','221','1',1,'Received from bridging 373',0.00,0.00,10000.00,0.00,0.00,'2022-08-10 14:32:09','',''),(3872,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-11 15:21:19','',''),(3873,'21','221',NULL,1,'Reception corrector for bridging 377',0.00,0.00,0.00,22500.00,0.00,'2022-08-11 15:26:53','',''),(3874,'21','221','3',1,'Received from bridging 377',0.00,0.00,22500.00,0.00,0.00,'2022-08-11 15:26:53','',''),(3875,'21','221',NULL,1,'Reception corrector for bridging 376',0.00,0.00,0.00,22500.00,0.00,'2022-08-11 15:26:53','',''),(3876,'21','221','2',1,'Received from bridging 376',0.00,0.00,22500.00,0.00,0.00,'2022-08-11 15:26:53','',''),(3877,'21','221','1',1,'Sale Id shift 137',0.00,0.00,0.00,5152.01,0.00,'2022-08-11 19:57:02','',''),(3878,'21','221','2',1,'Sale Id shift 137',0.00,0.00,0.00,6427.38,0.00,'2022-08-11 19:57:02','',''),(3879,'21','221','2',1,'Sale Id shift 137',0.00,0.00,0.00,5113.88,0.00,'2022-08-11 19:57:02','',''),(3880,'21','221','3',1,'Sale Id shift 137',0.00,0.00,0.00,4284.98,0.00,'2022-08-11 19:57:02','',''),(3881,'21','221','3',1,'Sale Id shift 137',0.00,0.00,0.00,3078.32,0.00,'2022-08-11 19:57:02','',''),(3882,'21','221','3',1,'Sale Id shift 137',0.00,0.00,0.00,4395.82,0.00,'2022-08-11 19:57:02','',''),(3883,'21','221','3',1,'Sale Id shift 137',0.00,0.00,0.00,2967.65,0.00,'2022-08-11 19:57:02','',''),(3884,'21','221','3',1,'Sale Id shift 137',0.00,0.00,0.00,5433.01,0.00,'2022-08-11 19:57:02','',''),(3885,'21','221','3',1,'Sale Id shift 137',0.00,0.00,0.00,5707.81,0.00,'2022-08-11 19:57:02','',''),(3886,'21','221','3',1,'Sale Id shift 137',0.00,0.00,0.00,5296.26,0.00,'2022-08-11 19:57:02','',''),(3887,'21','221','1',1,'Sale Id shift 137',0.00,0.00,0.00,5446.52,0.00,'2022-08-11 19:57:02','',''),(3888,'21','221','4',2,'Sale Id shift 137',0.00,0.00,0.00,9.76,0.00,'2022-08-11 19:57:02','',''),(3889,'21','221','4',2,'Sale Id shift 137',0.00,0.00,0.00,3048.79,0.00,'2022-08-11 19:57:02','',''),(3890,'21','221','5',3,'Sale Id shift 137',0.00,0.00,0.00,1024.00,0.00,'2022-08-11 19:57:02','',''),(3891,'21','221','3',1,'Sale Id shift 137',0.00,0.00,0.00,5283.94,0.00,'2022-08-11 19:57:02','',''),(3892,'21','221','1',1,'Sale Id shift 137',0.00,0.00,0.00,4569.47,0.00,'2022-08-11 19:57:02','',''),(3893,'21','221','1',1,'Sale Id shift 137',0.00,0.00,0.00,4987.65,0.00,'2022-08-11 19:57:02','',''),(3894,'21','221','2',1,'Sale Id shift 137',0.00,0.00,0.00,9154.23,0.00,'2022-08-11 19:57:02','',''),(3895,'21','221','2',1,'Sale Id shift 137',0.00,0.00,0.00,5073.06,0.00,'2022-08-11 19:57:02','',''),(3896,'21','221','2',1,'Sale Id shift 137',0.00,0.00,0.00,3983.73,0.00,'2022-08-11 19:57:02','',''),(3897,'21','221','2',1,'Sale Id shift 137',0.00,0.00,0.00,3548.04,0.00,'2022-08-11 19:57:02','',''),(3898,'21','221',NULL,1,'Sale Id shift 137',15733158.00,0.00,0.00,0.00,0.00,'2022-08-11 19:57:02','',''),(3899,'21','221',NULL,2,'Sale Id shift 137',2538596.50,0.00,0.00,0.00,0.00,'2022-08-11 19:57:02','',''),(3900,'21','221',NULL,3,'Sale Id shift 137',768000.00,0.00,0.00,0.00,0.00,'2022-08-11 19:57:02','',''),(3901,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8750000.00,50000.00,0.00,0.00,'2022-08-12 11:44:28','',''),(3902,'21','221',NULL,1,'Reception corrector for bridging 379',0.00,0.00,0.00,25000.00,0.00,'2022-08-12 11:48:11','',''),(3903,'21','221','2',1,'Received from bridging 379',0.00,0.00,25000.00,0.00,0.00,'2022-08-12 11:48:11','',''),(3904,'21','221',NULL,1,'Reception corrector for bridging 378',0.00,0.00,0.00,25000.00,0.00,'2022-08-12 11:48:11','',''),(3905,'21','221','1',1,'Received from bridging 378',0.00,0.00,25000.00,0.00,0.00,'2022-08-12 11:48:11','',''),(3906,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,60000.00,0.00,0.00,'2022-08-12 11:48:31','',''),(3907,'21','221',NULL,1,'Reception corrector for bridging 381',0.00,0.00,0.00,39000.00,0.00,'2022-08-12 11:51:11','',''),(3908,'21','221','3',1,'Received from bridging 381',0.00,0.00,39000.00,0.00,0.00,'2022-08-12 11:51:11','',''),(3909,'21','221',NULL,1,'Reception corrector for bridging 380',0.00,0.00,0.00,11000.00,0.00,'2022-08-12 11:51:11','',''),(3910,'21','221','2',1,'Received from bridging 380',0.00,0.00,11000.00,0.00,0.00,'2022-08-12 11:51:11','',''),(3911,'21','221','1',1,'Sale Id shift 138',0.00,0.00,0.00,2448.85,0.00,'2022-08-12 19:37:56','',''),(3912,'21','221','2',1,'Sale Id shift 138',0.00,0.00,0.00,5389.59,0.00,'2022-08-12 19:37:56','',''),(3913,'21','221','2',1,'Sale Id shift 138',0.00,0.00,0.00,3508.42,0.00,'2022-08-12 19:37:56','',''),(3914,'21','221','3',1,'Sale Id shift 138',0.00,0.00,0.00,3727.65,0.00,'2022-08-12 19:37:56','',''),(3915,'21','221','3',1,'Sale Id shift 138',0.00,0.00,0.00,3347.37,0.00,'2022-08-12 19:37:56','',''),(3916,'21','221','3',1,'Sale Id shift 138',0.00,0.00,0.00,3649.88,0.00,'2022-08-12 19:37:56','',''),(3917,'21','221','3',1,'Sale Id shift 138',0.00,0.00,0.00,3645.15,0.00,'2022-08-12 19:37:56','',''),(3918,'21','221','3',1,'Sale Id shift 138',0.00,0.00,0.00,2529.81,0.00,'2022-08-12 19:37:56','',''),(3919,'21','221','3',1,'Sale Id shift 138',0.00,0.00,0.00,3167.22,0.00,'2022-08-12 19:37:56','',''),(3920,'21','221','3',1,'Sale Id shift 138',0.00,0.00,0.00,3669.19,0.00,'2022-08-12 19:37:56','',''),(3921,'21','221','1',1,'Sale Id shift 138',0.00,0.00,0.00,3066.39,0.00,'2022-08-12 19:37:56','',''),(3922,'21','221','4',2,'Sale Id shift 138',0.00,0.00,0.00,1495.81,0.00,'2022-08-12 19:37:56','',''),(3923,'21','221','5',3,'Sale Id shift 138',0.00,0.00,0.00,477.39,0.00,'2022-08-12 19:37:56','',''),(3924,'21','221','3',1,'Sale Id shift 138',0.00,0.00,0.00,3414.30,0.00,'2022-08-12 19:37:56','',''),(3925,'21','221','1',1,'Sale Id shift 138',0.00,0.00,0.00,3035.27,0.00,'2022-08-12 19:37:56','',''),(3926,'21','221','1',1,'Sale Id shift 138',0.00,0.00,0.00,3266.52,0.00,'2022-08-12 19:37:56','',''),(3927,'21','221','2',1,'Sale Id shift 138',0.00,0.00,0.00,5200.19,0.00,'2022-08-12 19:37:56','',''),(3928,'21','221','2',1,'Sale Id shift 138',0.00,0.00,0.00,3259.59,0.00,'2022-08-12 19:37:56','',''),(3929,'21','221','2',1,'Sale Id shift 138',0.00,0.00,0.00,2484.55,0.00,'2022-08-12 19:37:56','',''),(3930,'21','221','2',1,'Sale Id shift 138',0.00,0.00,0.00,3891.37,0.00,'2022-08-12 19:37:56','',''),(3931,'21','221',NULL,1,'Sale Id shift 138',10972729.25,0.00,0.00,0.00,0.00,'2022-08-12 19:37:56','',''),(3932,'21','221',NULL,2,'Sale Id shift 138',1241522.30,0.00,0.00,0.00,0.00,'2022-08-12 19:37:56','',''),(3933,'21','221',NULL,3,'Sale Id shift 138',358042.50,0.00,0.00,0.00,0.00,'2022-08-12 19:37:56','',''),(3934,'21','221','1',1,'Sale Id shift 139',0.00,0.00,0.00,2035.03,0.00,'2022-08-15 00:29:21','',''),(3935,'21','221','2',1,'Sale Id shift 139',0.00,0.00,0.00,5609.04,0.00,'2022-08-15 00:29:21','',''),(3936,'21','221','2',1,'Sale Id shift 139',0.00,0.00,0.00,3171.53,0.00,'2022-08-15 00:29:21','',''),(3937,'21','221','3',1,'Sale Id shift 139',0.00,0.00,0.00,4071.26,0.00,'2022-08-15 00:29:21','',''),(3938,'21','221','3',1,'Sale Id shift 139',0.00,0.00,0.00,2121.65,0.00,'2022-08-15 00:29:21','',''),(3939,'21','221','3',1,'Sale Id shift 139',0.00,0.00,0.00,4099.28,0.00,'2022-08-15 00:29:21','',''),(3940,'21','221','3',1,'Sale Id shift 139',0.00,0.00,0.00,3870.25,0.00,'2022-08-15 00:29:21','',''),(3941,'21','221','3',1,'Sale Id shift 139',0.00,0.00,0.00,3120.13,0.00,'2022-08-15 00:29:21','',''),(3942,'21','221','3',1,'Sale Id shift 139',0.00,0.00,0.00,4260.34,0.00,'2022-08-15 00:29:21','',''),(3943,'21','221','3',1,'Sale Id shift 139',0.00,0.00,0.00,2075.55,0.00,'2022-08-15 00:29:21','',''),(3944,'21','221','1',1,'Sale Id shift 139',0.00,0.00,0.00,2530.64,0.00,'2022-08-15 00:29:21','',''),(3945,'21','221','4',2,'Sale Id shift 139',0.00,0.00,0.00,4812.57,0.00,'2022-08-15 00:29:21','',''),(3946,'21','221','5',3,'Sale Id shift 139',0.00,0.00,0.00,567.53,0.00,'2022-08-15 00:29:21','',''),(3947,'21','221','3',1,'Sale Id shift 139',0.00,0.00,0.00,3690.46,0.00,'2022-08-15 00:29:21','',''),(3948,'21','221','1',1,'Sale Id shift 139',0.00,0.00,0.00,1455.72,0.00,'2022-08-15 00:29:21','',''),(3949,'21','221','1',1,'Sale Id shift 139',0.00,0.00,0.00,3396.21,0.00,'2022-08-15 00:29:21','',''),(3950,'21','221','2',1,'Sale Id shift 139',0.00,0.00,0.00,5121.14,0.00,'2022-08-15 00:29:21','',''),(3951,'21','221','2',1,'Sale Id shift 139',0.00,0.00,0.00,2933.49,0.00,'2022-08-15 00:29:21','',''),(3952,'21','221','2',1,'Sale Id shift 139',0.00,0.00,0.00,2964.07,0.00,'2022-08-15 00:29:21','',''),(3953,'21','221','2',1,'Sale Id shift 139',0.00,0.00,0.00,3218.83,0.00,'2022-08-15 00:29:21','',''),(3954,'21','221',NULL,1,'Sale Id shift 139',10455308.50,0.00,0.00,0.00,0.00,'2022-08-15 00:29:21','',''),(3955,'21','221',NULL,2,'Sale Id shift 139',3994433.10,0.00,0.00,0.00,0.00,'2022-08-15 00:29:21','',''),(3956,'21','221',NULL,3,'Sale Id shift 139',425647.50,0.00,0.00,0.00,0.00,'2022-08-15 00:29:21','',''),(3957,'21','221','2',1,'Sale Id shift 140',0.00,0.00,0.00,1730.93,0.00,'2022-08-16 16:46:47','',''),(3958,'21','221','2',1,'Sale Id shift 140',0.00,0.00,0.00,817.78,0.00,'2022-08-16 16:46:47','',''),(3959,'21','221','3',1,'Sale Id shift 140',0.00,0.00,0.00,870.01,0.00,'2022-08-16 16:46:47','',''),(3960,'21','221','3',1,'Sale Id shift 140',0.00,0.00,0.00,758.78,0.00,'2022-08-16 16:46:47','',''),(3961,'21','221','3',1,'Sale Id shift 140',0.00,0.00,0.00,961.50,0.00,'2022-08-16 16:46:47','',''),(3962,'21','221','3',1,'Sale Id shift 140',0.00,0.00,0.00,873.57,0.00,'2022-08-16 16:46:47','',''),(3963,'21','221','3',1,'Sale Id shift 140',0.00,0.00,0.00,1261.95,0.00,'2022-08-16 16:46:47','',''),(3964,'21','221','3',1,'Sale Id shift 140',0.00,0.00,0.00,562.24,0.00,'2022-08-16 16:46:47','',''),(3965,'21','221','3',1,'Sale Id shift 140',0.00,0.00,0.00,1199.55,0.00,'2022-08-16 16:46:47','',''),(3966,'21','221','4',2,'Sale Id shift 140',0.00,0.00,0.00,20.59,0.00,'2022-08-16 16:46:47','',''),(3967,'21','221','4',2,'Sale Id shift 140',0.00,0.00,0.00,1613.17,0.00,'2022-08-16 16:46:47','',''),(3968,'21','221','5',3,'Sale Id shift 140',0.00,0.00,0.00,518.26,0.00,'2022-08-16 16:46:47','',''),(3969,'21','221','3',1,'Sale Id shift 140',0.00,0.00,0.00,896.21,0.00,'2022-08-16 16:46:47','',''),(3970,'21','221','2',1,'Sale Id shift 140',0.00,0.00,0.00,1535.48,0.00,'2022-08-16 16:46:47','',''),(3971,'21','221','2',1,'Sale Id shift 140',0.00,0.00,0.00,659.25,0.00,'2022-08-16 16:46:47','',''),(3972,'21','221','2',1,'Sale Id shift 140',0.00,0.00,0.00,1009.94,0.00,'2022-08-16 16:46:47','',''),(3973,'21','221','2',1,'Sale Id shift 140',0.00,0.00,0.00,1373.01,0.00,'2022-08-16 16:46:47','',''),(3974,'21','221',NULL,1,'Sale Id shift 140',2539285.00,0.00,0.00,0.00,0.00,'2022-08-16 16:46:47','',''),(3975,'21','221',NULL,2,'Sale Id shift 140',1323345.60,0.00,0.00,0.00,0.00,'2022-08-16 16:46:47','',''),(3976,'21','221',NULL,3,'Sale Id shift 140',388695.00,0.00,0.00,0.00,0.00,'2022-08-16 16:46:47','',''),(3977,'21','221','1',1,'Sale Id shift 141',0.00,0.00,0.00,3363.46,0.00,'2022-08-16 19:58:34','',''),(3978,'21','221','2',1,'Sale Id shift 141',0.00,0.00,0.00,3804.42,0.00,'2022-08-16 19:58:34','',''),(3979,'21','221','2',1,'Sale Id shift 141',0.00,0.00,0.00,2580.66,0.00,'2022-08-16 19:58:34','',''),(3980,'21','221','3',1,'Sale Id shift 141',0.00,0.00,0.00,3330.22,0.00,'2022-08-16 19:58:34','',''),(3981,'21','221','3',1,'Sale Id shift 141',0.00,0.00,0.00,3315.84,0.00,'2022-08-16 19:58:34','',''),(3982,'21','221','3',1,'Sale Id shift 141',0.00,0.00,0.00,2178.31,0.00,'2022-08-16 19:58:34','',''),(3983,'21','221','3',1,'Sale Id shift 141',0.00,0.00,0.00,2732.94,0.00,'2022-08-16 19:58:34','',''),(3984,'21','221','3',1,'Sale Id shift 141',0.00,0.00,0.00,2622.89,0.00,'2022-08-16 19:58:34','',''),(3985,'21','221','3',1,'Sale Id shift 141',0.00,0.00,0.00,2764.06,0.00,'2022-08-16 19:58:34','',''),(3986,'21','221','3',1,'Sale Id shift 141',0.00,0.00,0.00,1432.96,0.00,'2022-08-16 19:58:34','',''),(3987,'21','221','1',1,'Sale Id shift 141',0.00,0.00,0.00,2213.56,0.00,'2022-08-16 19:58:34','',''),(3988,'21','221','4',2,'Sale Id shift 141',0.00,0.00,0.00,560.93,0.00,'2022-08-16 19:58:34','',''),(3989,'21','221','4',2,'Sale Id shift 141',0.00,0.00,0.00,5265.41,0.00,'2022-08-16 19:58:34','',''),(3990,'21','221','5',3,'Sale Id shift 141',0.00,0.00,0.00,500.29,0.00,'2022-08-16 19:58:34','',''),(3991,'21','221','3',1,'Sale Id shift 141',0.00,0.00,0.00,2312.22,0.00,'2022-08-16 19:58:34','',''),(3992,'21','221','1',1,'Sale Id shift 141',0.00,0.00,0.00,2866.97,0.00,'2022-08-16 19:58:34','',''),(3993,'21','221','1',1,'Sale Id shift 141',0.00,0.00,0.00,2099.06,0.00,'2022-08-16 19:58:34','',''),(3994,'21','221','2',1,'Sale Id shift 141',0.00,0.00,0.00,4129.16,0.00,'2022-08-16 19:58:34','',''),(3995,'21','221','2',1,'Sale Id shift 141',0.00,0.00,0.00,2282.29,0.00,'2022-08-16 19:58:34','',''),(3996,'21','221','2',1,'Sale Id shift 141',0.00,0.00,0.00,2679.88,0.00,'2022-08-16 19:58:34','',''),(3997,'21','221','2',1,'Sale Id shift 141',0.00,0.00,0.00,3130.71,0.00,'2022-08-16 19:58:34','',''),(3998,'21','221',NULL,1,'Sale Id shift 141',8721931.75,0.00,0.00,0.00,0.00,'2022-08-16 19:58:34','',''),(3999,'21','221',NULL,2,'Sale Id shift 141',4719335.40,0.00,0.00,0.00,0.00,'2022-08-16 19:58:34','',''),(4000,'21','221',NULL,3,'Sale Id shift 141',417742.15,0.00,0.00,0.00,0.00,'2022-08-16 19:58:34','',''),(4001,'21','221',NULL,1,'Reception corrector for bridging 382',0.00,0.00,0.00,10000.00,0.00,'2022-08-17 12:32:32','',''),(4002,'21','221','1',1,'Received from bridging 382',0.00,0.00,10000.00,0.00,0.00,'2022-08-17 12:32:32','',''),(4003,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,60000.00,0.00,0.00,'2022-08-17 12:53:28','',''),(4004,'21','221',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,60000.00,0.00,0.00,'2022-08-17 12:57:30','',''),(4005,'21','221',NULL,1,'Reception corrector for bridging 383',0.00,0.00,0.00,60000.00,0.00,'2022-08-17 12:58:13','',''),(4006,'21','221','2',1,'Received from bridging 383',0.00,0.00,60000.00,0.00,0.00,'2022-08-17 12:58:13','',''),(4007,'21','221',NULL,1,'Reception corrector for bridging 384',0.00,0.00,0.00,60000.00,0.00,'2022-08-17 13:21:02','',''),(4008,'21','221','3',1,'Received from bridging 384',0.00,0.00,60000.00,0.00,0.00,'2022-08-17 13:21:02','',''),(4009,'21','221','1',1,'Sale Id shift 142',0.00,0.00,0.00,2451.29,0.00,'2022-08-17 14:59:04','',''),(4010,'21','221','2',1,'Sale Id shift 142',0.00,0.00,0.00,4947.73,0.00,'2022-08-17 14:59:04','',''),(4011,'21','221','2',1,'Sale Id shift 142',0.00,0.00,0.00,3614.15,0.00,'2022-08-17 14:59:04','',''),(4012,'21','221','3',1,'Sale Id shift 142',0.00,0.00,0.00,2466.62,0.00,'2022-08-17 14:59:04','',''),(4013,'21','221','3',1,'Sale Id shift 142',0.00,0.00,0.00,2329.00,0.00,'2022-08-17 14:59:04','',''),(4014,'21','221','3',1,'Sale Id shift 142',0.00,0.00,0.00,2367.46,0.00,'2022-08-17 14:59:04','',''),(4015,'21','221','3',1,'Sale Id shift 142',0.00,0.00,0.00,2001.18,0.00,'2022-08-17 14:59:04','',''),(4016,'21','221','3',1,'Sale Id shift 142',0.00,0.00,0.00,2516.75,0.00,'2022-08-17 14:59:04','',''),(4017,'21','221','3',1,'Sale Id shift 142',0.00,0.00,0.00,3385.82,0.00,'2022-08-17 14:59:04','',''),(4018,'21','221','3',1,'Sale Id shift 142',0.00,0.00,0.00,2554.96,0.00,'2022-08-17 14:59:04','',''),(4019,'21','221','1',1,'Sale Id shift 142',0.00,0.00,0.00,2367.74,0.00,'2022-08-17 14:59:04','',''),(4020,'21','221','4',2,'Sale Id shift 142',0.00,0.00,0.00,2104.93,0.00,'2022-08-17 14:59:04','',''),(4021,'21','221','4',2,'Sale Id shift 142',0.00,0.00,0.00,3077.82,0.00,'2022-08-17 14:59:04','',''),(4022,'21','221','5',3,'Sale Id shift 142',0.00,0.00,0.00,595.72,0.00,'2022-08-17 14:59:04','',''),(4023,'21','221','3',1,'Sale Id shift 142',0.00,0.00,0.00,3479.40,0.00,'2022-08-17 14:59:04','',''),(4024,'21','221','1',1,'Sale Id shift 142',0.00,0.00,0.00,2307.47,0.00,'2022-08-17 14:59:04','',''),(4025,'21','221','1',1,'Sale Id shift 142',0.00,0.00,0.00,2908.25,0.00,'2022-08-17 14:59:04','',''),(4026,'21','221','2',1,'Sale Id shift 142',0.00,0.00,0.00,4266.61,0.00,'2022-08-17 14:59:04','',''),(4027,'21','221','2',1,'Sale Id shift 142',0.00,0.00,0.00,187.63,0.00,'2022-0