-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_220
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_220`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_220` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_220`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,2500,'',0,'2','21','220','ZENITH BANK','','2022-03-02 13:49:26',5,0.00,0.00,'','763','2022-03-02 13:49:26','763',0,0),(2,2501,'',0,'2','21','220','GT BANK POS','','2022-03-02 13:49:42',5,0.00,0.00,'','763','2022-03-02 13:49:42','763',0,0),(3,2502,'',0,'2','21','220','ZENITH BANK POS','','2022-03-02 13:49:56',5,0.00,0.00,'','763','2022-03-02 13:49:56','763',0,0),(4,2503,'',0,'2','21','220','STANBIC POS','','2022-03-02 13:50:08',5,0.00,0.00,'','763','2022-03-02 13:50:08','763',0,0),(5,2504,'',0,'2','21','220','SUNTRUST POS','','2022-03-02 13:50:20',5,0.00,0.00,'','763','2022-03-02 13:50:20','763',0,0),(6,8000,'',0,'24','21','220','AGO CONSUMPTION','','2022-03-02 14:02:05',5,0.00,0.00,'','763','2022-03-02 14:02:05','763',0,0),(7,2505,'',0,'2','21','220','First Bank POS','','2022-03-03 08:19:53',5,0.00,0.00,'','764','2022-03-03 08:19:53','764',0,0),(8,2506,'',0,'2','21','220','Stanbic Bank POS','','2022-03-03 08:20:44',5,0.00,0.00,'','764','2022-03-03 08:20:44','764',0,0),(9,2507,'',0,'2','21','220','GTB POS','','2022-03-03 08:21:02',5,0.00,0.00,'','764','2022-03-03 08:21:02','764',0,0),(10,2508,'',0,'2','21','220','UBA Bank','','2022-03-03 08:21:29',5,0.00,0.00,'','764','2022-03-03 08:21:29','764',0,0),(11,2509,'',0,'2','21','220','Access Bank','','2022-03-03 08:22:55',5,0.00,0.00,'','764','2022-03-03 08:22:55','764',0,0),(12,4000,'',0,'22','21','220','PURCHASES','','2022-03-03 08:23:47',5,0.00,0.00,'','763','2022-03-03 08:23:47','763',0,0),(13,7000,'',0,'20','21','220','SALES','','2022-03-03 08:23:59',5,0.00,0.00,'','763','2022-03-03 08:23:59','763',0,0),(14,8001,'',0,'24','21','220','SALARIES & WAGES','','2022-03-03 08:24:13',5,0.00,0.00,'','763','2022-03-03 08:24:13','763',0,0),(15,8002,'',0,'24','21','220','PURCHASES','','2022-03-03 08:24:27',5,0.00,0.00,'','763','2022-03-03 08:24:27','763',0,0),(16,500,'',0,'6.1','21','220','CASH','','2022-03-03 08:26:16',5,0.00,0.00,'','763','2022-03-03 08:26:16','763',0,0),(17,2510,'',0,'2','21','220','Ecobank POS','','2022-03-26 17:53:25',5,0.00,0.00,'','764','2022-03-26 17:53:25','764',0,0),(18,2511,'',0,'2','21','220','Ecobank ','','2022-03-26 17:53:34',5,0.00,0.00,'','764','2022-03-26 17:53:34','764',0,0),(19,2512,'',0,'2','21','220','Ecobank Transfer account ','','2022-03-26 17:53:42',5,0.00,0.00,'','764','2022-03-26 17:53:42','764',0,0),(20,2513,'',0,'2','21','220','Unity Bank','','2022-03-26 17:53:52',5,0.00,0.00,'','764','2022-03-26 17:53:52','764',0,0),(21,2514,'',0,'2','21','220','Unity Bank POS','','2022-03-26 17:53:59',5,0.00,0.00,'','764','2022-03-26 17:53:59','764',0,0),(22,2515,'',0,'2','21','220','UNITY Bank Transfer account ','','2022-03-26 17:54:07',5,0.00,0.00,'','764','2022-03-26 17:54:07','764',0,0),(23,2516,'5',1,'2','21','220','SunTrust Pos','','2022-04-04 11:46:03',5,0.00,0.00,'','764','2022-04-04 11:46:03','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','21','220','KAMO','Aminu Abubakar','08066616786','kamo@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 13:53:21',5,'763','2022-04-12 15:16:48','763'),(2,'','21','220','TOTAL SECURE','TUNDE','08063097933','sales@totalsecureng.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 13:53:58',5,'763','2022-04-11 23:22:41','763'),(3,'','21','220','JRB Solar','Victoria','08037860178',' info@jrbsolar.com','ABUJA','ABUJA','Plot 739, Cadastral Zone\r\nB03 Muhammed M. Bello Way,\r\nWuye, Nigeria','Nigeria',0.00,0.00,0.00,'2022-03-27','2022-03-02 13:54:40',5,'763','2022-04-11 23:09:49','763'),(4,'','21','220','SWIFTLANE','Muhammad','08031561555','swift@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 13:55:06',5,'763','2022-04-11 23:16:11','763'),(5,'','21','220','CODE OF CONDUCT BUERAU','CCB','00000000','ccb@gmail.com','ABJ','ABJ','ABJ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 13:55:55',5,'763','2022-03-02 13:55:55','763'),(6,'','21','220','DPR','DPR','000000000','dpr@gmail.com','ABJ','ABJ','ABJ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 13:56:35',5,'763','2022-03-02 13:56:35','763'),(7,'','21','220','PACE SETTERS','PACE SETTERS','0000','support@pacesettersschools.sch','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-04 08:37:47',5,'764','2022-04-12 15:15:10','763'),(8,'','21','220','DRIVER SHORTAGE','HEAD OFFICE','07034515975','info@ayamshafaltd.com','BAUCHI','BAUCHI','BAUCHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-04 11:35:06',5,'764','2022-03-04 11:35:06','764'),(9,'','21','220','AGO CONSUMPTION','HEAD OFFICE','07034515975','info@ayamshafaltd.com','BAUCHI','BAUCHI','No B38 Jos Road/ Jolly Nyame Crescent Bauchi Bauchi','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 11:31:11',5,'764','2022-03-08 11:31:11','764'),(10,'','21','220','LISDON GARDEN','Harrison','08072794423','','Abuja','Abuja','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-08 20:58:15',5,'763','2022-04-11 23:19:08','763'),(11,'','21','220','Sambo','Sambo','08034803872','null@yahoo.com','Abuja','FCT','Julius Berger Yard','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-13 15:29:21',5,'763','2022-04-13 15:29:21','763'),(12,'','21','220','M&U','M&U','00000000','null@gmail.com','Abuja ','FCT','M&U','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-13 15:31:09',5,'763','2022-04-13 15:31:09','763'),(13,'','21','220','Earthfield','Earthfield ','000000000','null@yahoo.com','Abuja','Abuja','Earthfield ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-13 15:46:18',5,'763','2022-04-13 15:46:18','763'),(14,'','21','220','Federal Judicial Commission ','Oga Abdul','08065106658','fjc@yahoo.com','Abuja','Abuja','Federal Judicial Commission ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-13 16:19:31',5,'763','2022-04-13 16:19:31','763'),(15,'','21','220','WETLAND','wetland','000000000','wetland@gmail.com','ABUJA','FCT','Wetland','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-17 06:03:28',5,'763','2022-04-17 06:03:28','763'),(16,'','21','220','Church of Nigeria Anglican Com','Emmanuel','08133506730','null@yahoo.com','Abuja','FCT','Church of Nigeria Anglican Communion ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-25 17:34:45',5,'763','2022-04-25 17:34:45','763'),(17,'','21','220','Good Tiding','Niyi ','08119752768','null@yahoo.com','Abuja ','FCT','Good Tiding','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-25 17:36:40',5,'763','2022-04-25 17:36:40','763'),(18,'','21','220','Ginos ','Mr. Paul','07062151816','null@yahoo.com','Abuja','FCT','Ginos','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-25 17:37:47',5,'763','2022-04-25 17:37:47','763'),(19,'','21','220','Rumbu ','Rumbu','07036060439','null@yahoo.com','Abuja','FCT','Rumbu ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-25 17:38:46',5,'763','2022-04-25 17:38:46','763'),(20,'','21','220','Value Mart','Mr. Obi','09082000012','null@yahoo.com','Abuja ','FCT','Value Mart','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-25 17:39:56',5,'763','2022-04-25 17:39:56','763'),(21,'','21','220','Jay .O. Resources ','Baba Muhammad ','08034023098','null@yahoo.com','Abuja ','FCT','Jay O Resources ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-25 17:41:26',5,'763','2022-04-25 17:41:26','763'),(22,'','21','220','Wisman Environmental ','Wisman','0000000000','nil@yahoo.com','Abuja','FCt','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 17:01:48',5,'763','2022-05-26 17:01:48','763'),(23,'','21','220','Esseinbless','Esseinbless ','000000000','nil@nil.com','Abuja','FCT','Nil','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 16:51:17',5,'763','2022-05-28 16:51:17','763'),(24,'','21','220','Grab 24/7','Grab ','0000000000','null@nil.com','FCT','Abuja','Nil','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 16:53:31',5,'763','2022-05-28 16:53:31','763'),(25,'','21','220','Plan International ','Mr. Plan ','08033228176','nil@nil.com','Abuja','FCT','Plan International ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 13:36:21',5,'763','2022-05-30 13:36:21','763');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','220',9,'1',0.00,150.00,'2022-03-21','','2022-03-23 13:05:31','764','764',2022,'764','2022-03-23 13:05:31',5),('21','220',10,'2',0.00,400.00,'2022-03-21','','2022-03-23 13:06:10','764','764',2022,'764','2022-03-23 13:06:10',5),('21','220',11,'3',0.00,150.00,'2022-03-21','','2022-03-23 13:06:34','764','764',2022,'764','2022-03-23 13:06:34',5),('21','220',12,'4',0.00,50.00,'2022-03-21','','2022-03-23 13:06:53','764','764',2022,'764','2022-03-23 13:06:53',5),('21','220',13,'1',150.00,2550.00,'2022-03-20','','2022-03-23 18:26:42','763','763',2022,'763','2022-03-23 18:26:42',5),('21','220',14,'2',400.00,15800.00,'2022-03-20','','2022-03-23 18:29:39','763','763',2022,'763','2022-03-23 18:29:39',5),('21','220',15,'3',150.00,34550.00,'2022-03-20','','2022-03-23 18:30:44','763','763',2022,'763','2022-03-23 18:30:44',5),('21','220',16,'4',50.00,50.00,'2022-03-20','','2022-03-23 18:31:05','763','763',2022,'763','2022-03-23 18:31:05',5),('21','220',17,'4',50.00,100.00,'2022-03-20','','2022-03-23 18:31:41','763','763',2022,'763','2022-03-23 18:31:41',5),('21','220',18,'1',45444.81,50100.00,'2022-03-28','','2022-04-06 06:34:32','764','764',2022,'764','2022-04-06 06:34:32',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','220','1',1,'5','PMS PUMP 1',2366792.84,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-23 18:06:20','763'),('21','220','1',2,'5','PMS PUMP 2',2054057.14,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:06:54','763'),('21','220','1',3,'5','PMS PUMP 3',1783068.27,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-02 14:00:22','763'),('21','220','1',4,'5','PMS PUMP 4',2257120.62,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:07:51','763'),('21','220','3',9,'5','AGO PUMP 1',1323715.88,'AGO DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:08:29','763'),('21','220','3',10,'5','AGO PUMP 2',1517296.25,'AGO DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:09:03','763'),('21','220','4',11,'5','DPK PUMP',590873.13,'DPK DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:10:20','763'),('21','220','1',12,'5','PMS PUMP 5',2309707.09,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:10:59','763'),('21','220','1',13,'5','PMS PUMP 6',1503959.68,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:11:29','763'),('21','220','1',14,'5','PMS PUMP 7',1661445.88,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:12:13','763'),('21','220','1',15,'5','PMS PUMP 8',1833056.27,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:12:42','763'),('21','220','2',16,'5','PMS PUMP 9',2803705.07,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:13:11','763'),('21','220','2',17,'5','PMS PUMP 10',1831213.79,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:13:39','763'),('21','220','2',18,'5','PMS PUMP 11',1575737.15,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:14:05','763'),('21','220','2',19,'5','PMS PUMP 12',1679869.39,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:14:34','763'),('21','220','2',20,'5','PMS PUMP 13',2276122.85,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:15:22','763'),('21','220','2',21,'5','PMS PUMP 14',1687028.79,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:16:11','763'),('21','220','2',22,'5','PMS PUMP 15',2130850.19,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:16:35','763'),('21','220','2',23,'5','PMS PUMP 16',1860629.43,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:17:08','763'),('21','220','4',24,'5','DPK PUMP 2',70513.29,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-03-23 18:17:49','763');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=235 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','220',4,'DAILY SHIFT','2022-03-23','2022-03-23 19:47:34','2022-03-24 19:47:34','763',11030477.25,11030477.25,'763','2022-03-23 19:58:02','763','2022-03-23 21:06:56',10,0),('21','220',5,'DAILY SHIFT','2022-03-24','2022-03-24 21:35:11','2022-03-25 21:35:11','763',15686056.25,15686056.25,'763','2022-03-24 21:45:00','763','2022-03-24 23:09:16',10,0),('21','220',6,'DAILY SHIFT','2022-03-24','2022-03-24 23:16:26','2022-03-25 23:16:26','763',13253195.02,13253195.02,'763','2022-03-24 23:23:15','763','2022-03-25 00:11:36',10,0),('21','220',7,'DAILY SHIFT','2022-03-24','2022-03-27 21:06:23','2022-03-28 21:06:23','763',14389314.05,14389314.05,'763','2022-03-27 21:14:52','763','2022-03-27 22:11:17',10,0),('21','220',8,'DAILY SHIFT','2022-03-25','2022-03-27 22:56:46','2022-03-28 22:56:46','763',10818360.30,10818360.30,'763','2022-03-27 23:03:50','763','2022-03-27 23:05:22',10,0),('21','220',9,'DAILY SHIFT','2022-03-26','2022-03-28 21:37:56','2022-03-29 21:37:56','763',9251545.00,9251545.00,'763','2022-03-28 21:45:21','763','2022-03-28 22:28:17',10,0),('21','220',10,'DAILY SHIFT','2022-03-27','2022-03-28 22:32:16','2022-03-29 22:32:16','763',6068917.80,6068917.80,'763','2022-03-28 22:39:13','763','2022-03-29 14:00:57',10,0),('21','220',11,'DAILY SHIFT','2022-03-31','2022-03-31 19:54:45','2022-04-01 19:54:45','763',6646891.55,6646891.55,'763','2022-03-31 20:01:05','763','2022-03-31 20:03:22',10,0),('21','220',12,'DAILY SHIFT','2022-03-31','2022-03-31 21:28:07','2022-04-01 21:28:07','763',0.00,0.00,'764','2022-04-01 22:55:56','764','2022-04-01 22:56:44',10,0),('21','220',13,'DAILY SHIFT','2022-03-24','2022-04-06 17:36:02','2022-04-07 17:36:02','763',20422621.35,20422621.35,'763','2022-04-06 17:50:07','763','2022-04-07 14:34:20',10,0),('21','220',14,'Daily shift','2022-04-07','2022-04-07 15:22:05','2022-04-08 15:22:05','763',0.00,0.00,'763','2022-04-10 18:08:34','763','2022-04-10 18:08:55',10,0),('21','220',15,'DAILY SHIFT','2022-03-30','2022-04-10 18:10:58','2022-04-11 18:10:58','763',0.00,0.00,'763','2022-04-13 15:12:57','763','2022-04-13 15:13:17',10,0),('21','220',16,'Daily shift','2022-03-30','2022-04-13 15:17:52','2022-04-14 15:17:52','763',20572610.85,20572610.85,'763','2022-04-15 11:24:42','763','2022-04-15 11:25:18',10,0),('21','220',17,'DAILY SHIFT','2022-03-31','2022-04-15 11:28:40','2022-04-16 11:28:40','763',14989519.35,14989519.35,'763','2022-04-15 21:05:23','763','2022-04-15 22:07:06',10,0),('21','220',18,'DAILY SHIFT','2022-04-01','2022-04-16 12:24:41','2022-04-17 12:24:41','763',16315116.35,16315116.35,'763','2022-04-16 12:54:02','763','2022-04-16 12:55:48',10,0),('21','220',19,'DAILY SHIFT','2022-04-02','2022-04-16 15:43:24','2022-04-17 15:43:24','763',14238224.80,14238224.80,'763','2022-04-16 15:59:43','763','2022-04-16 17:09:26',10,0),('21','220',20,'DAILY SHIFT','2022-04-03','2022-04-16 17:27:24','2022-04-17 17:27:24','763',10915450.45,10915450.45,'763','2022-04-16 17:53:28','763','2022-04-16 18:18:22',10,0),('21','220',21,'DAILY SHIFT','2022-04-04','2022-04-17 05:57:43','2022-04-18 05:57:43','763',14845869.45,14845869.45,'763','2022-04-17 06:29:32','763','2022-04-17 13:47:50',10,0),('21','220',22,'DAILY SHIFT','2022-04-05','2022-04-17 14:15:21','2022-04-18 14:15:21','763',11158689.35,11158689.35,'763','2022-04-17 15:35:58','763','2022-04-17 16:25:43',10,0),('21','220',23,'DAILY SHIFT','2022-04-06','2022-04-17 16:32:32','2022-04-18 16:32:32','763',12377902.50,12377902.50,'763','2022-04-17 17:04:10','763','2022-04-17 17:41:16',10,0),('21','220',24,'DAILY SHIFT','2022-04-07','2022-04-17 20:22:13','2022-04-18 20:22:13','763',13609273.95,13609273.95,'763','2022-04-17 20:55:20','763','2022-04-17 21:52:46',10,0),('21','220',25,'DAILY SHIFT','2022-04-08','2022-04-18 14:30:16','2022-04-19 14:30:16','763',14917563.35,14917563.35,'763','2022-04-18 14:48:35','763','2022-04-18 15:52:32',10,0),('21','220',26,'DAILY SHIFT','2022-04-09','2022-04-18 16:51:37','2022-04-19 16:51:37','763',18547219.55,18547219.55,'763','2022-04-18 17:13:15','763','2022-04-18 17:51:09',10,0),('21','220',27,'DAILY SHIFT','2022-04-10','2022-04-18 17:54:02','2022-04-19 17:54:02','763',10366764.85,10366764.85,'763','2022-04-18 18:04:51','763','2022-04-18 18:06:45',10,0),('21','220',28,'DAILY SHIFT','2022-04-11','2022-04-18 20:30:03','2022-04-19 20:30:03','763',14548182.70,14548182.70,'763','2022-04-18 20:48:18','763','2022-04-18 21:34:52',10,0),('21','220',29,'DAILY SHIFT','2022-04-12','2022-04-19 00:39:52','2022-04-20 00:39:52','763',15551709.25,15551709.25,'763','2022-04-19 00:59:28','764','2022-04-19 09:43:26',10,0),('21','220',30,'DAILY SHIFT','2022-04-13','2022-04-19 13:33:56','2022-04-20 13:33:56','763',13604898.20,13604898.20,'763','2022-04-19 14:08:12','763','2022-04-19 14:53:19',10,0),('21','220',31,'DAILY SHIFT','2022-04-14','2022-04-19 15:14:51','2022-04-20 15:14:51','763',13143605.50,13143605.50,'763','2022-04-19 15:32:17','763','2022-04-19 15:51:16',10,0),('21','220',32,'DAILY SHIFT','2022-04-15','2022-04-19 15:52:33','2022-04-20 15:52:33','763',11283231.65,11283231.65,'763','2022-04-19 16:36:04','763','2022-04-19 17:24:19',10,0),('21','220',33,'DAILY SHIFT','2022-04-16','2022-04-19 17:36:52','2022-04-20 17:36:52','763',11651141.90,11651141.90,'763','2022-04-19 18:32:13','763','2022-04-19 21:00:16',10,0),('21','220',34,'DAILY SHIFT','2022-04-17','2022-04-19 21:31:16','2022-04-20 21:31:16','763',8488636.20,8488636.20,'763','2022-04-20 12:49:37','763','2022-04-20 13:37:12',10,0),('21','220',35,'DAILY SHIFT','2022-04-18','2022-04-20 13:42:45','2022-04-21 13:42:45','763',18593902.30,18593902.30,'763','2022-04-20 14:20:03','763','2022-04-20 15:38:47',10,0),('21','220',36,'DAILY SHIFT','2022-04-19','2022-04-20 15:39:59','2022-04-21 15:39:59','763',16468012.20,16468012.20,'763','2022-04-20 16:58:28','763','2022-04-20 17:57:42',10,0),('21','220',37,'DAILY SHIFT','2022-04-20','2022-04-21 17:15:20','2022-04-22 17:15:20','763',13251764.35,13251764.35,'763','2022-04-21 17:35:46','763','2022-04-21 19:51:03',10,0),('21','220',38,'DAILY SHIFT','2022-04-21','2022-04-22 20:52:50','2022-04-23 20:52:50','763',12382482.95,12382482.95,'763','2022-04-22 21:27:28','763','2022-04-23 16:25:12',10,0),('21','220',39,'DAILY SHIFT','2022-04-22','2022-04-23 20:30:02','2022-04-24 20:30:02','763',14919092.40,14919092.40,'763','2022-04-23 20:58:22','763','2022-04-23 21:16:05',10,0),('21','220',40,'DAILY SHIFT','2022-04-23','2022-04-24 20:53:52','2022-04-25 20:53:52','763',12338795.95,12338795.95,'763','2022-04-24 21:12:01','763','2022-04-24 21:31:05',10,0),('21','220',41,'Daily Shift ','2022-04-24','2022-04-26 17:15:47','2022-04-27 17:15:47','763',11083617.95,11083617.95,'763','2022-04-26 17:37:05','763','2022-04-26 17:57:45',10,0),('21','220',42,'Daily Shift ','2022-04-25','2022-04-26 18:00:12','2022-04-27 18:00:12','763',13113102.30,13113102.30,'763','2022-04-27 14:05:07','763','2022-04-28 10:09:16',10,0),('21','220',43,'Daily Shift ','2022-04-26','2022-04-28 11:33:33','2022-04-29 11:33:33','763',13994358.60,13994358.60,'763','2022-04-28 20:22:17','763','2022-04-28 20:24:55',10,0),('21','220',44,'Daily Shift ','2022-04-29','2022-04-29 10:37:18','2022-04-30 10:37:18','763',0.00,0.00,'763','2022-04-29 10:44:43','763','2022-04-29 10:57:48',10,0),('21','220',45,'Daily Shift ','2022-04-27','2022-04-29 11:00:39','2022-04-30 11:00:39','763',14219812.68,14219812.68,'763','2022-04-29 11:57:34','763','2022-04-29 13:10:04',10,0),('21','220',46,'Daily Shift ','2022-04-28','2022-04-29 20:33:24','2022-04-30 20:33:24','763',13149991.80,13149991.80,'763','2022-04-29 21:24:33','763','2022-04-30 10:02:30',10,0),('21','220',47,'Daily','2022-04-29','2022-04-30 20:31:17','2022-05-01 20:31:17','763',7749388.45,7749388.45,'763','2022-04-30 20:53:19','763','2022-04-30 23:00:45',10,0),('21','220',48,'Daily Shift','2022-04-30','2022-05-01 20:51:33','2022-05-02 20:51:33','763',7410212.70,7410212.70,'763','2022-05-01 22:34:03','763','2022-05-02 20:43:07',10,0),('21','220',49,'Daily shift','2022-05-01','2022-05-03 10:25:19','2022-05-04 10:25:19','763',7027834.80,7027834.80,'763','2022-05-03 11:04:32','763','2022-05-04 18:33:00',10,0),('21','220',50,'Daily shift ','2022-05-02','2022-05-04 19:44:21','2022-05-05 19:44:21','763',8896236.70,8896236.70,'763','2022-05-05 17:57:32','763','2022-05-05 18:07:06',10,0),('21','220',51,'Daily','2022-05-03','2022-05-05 18:14:12','2022-05-06 18:14:12','763',2555705.70,2555705.70,'763','2022-05-05 18:27:44','763','2022-05-05 18:56:12',10,0),('21','220',52,'Daily','2022-05-04','2022-05-05 19:05:42','2022-05-06 19:05:42','763',11713605.25,11713605.25,'763','2022-05-05 19:18:44','763','2022-05-05 20:31:00',10,0),('21','220',53,'Daily','2022-05-05','2022-05-06 20:01:51','2022-05-07 20:01:51','763',13619608.85,13619608.85,'763','2022-05-06 20:53:49','763','2022-05-07 14:37:40',10,0),('21','220',54,'Daily Shift','2022-05-06','2022-05-07 21:22:16','2022-05-08 21:22:16','763',11046739.65,11046739.65,'763','2022-05-07 22:42:48','763','2022-05-08 12:41:52',10,0),('21','220',55,'Daily','2022-05-07','2022-05-08 21:12:53','2022-05-09 21:12:53','763',13230929.75,13230929.75,'763','2022-05-09 09:17:01','763','2022-05-09 22:14:12',10,0),('21','220',56,'Daily','2022-05-08','2022-05-09 22:15:51','2022-05-10 22:15:51','763',7202839.80,7202839.80,'763','2022-05-09 22:29:08','763','2022-05-10 22:43:36',10,0),('21','220',57,'Daily Shift ','2022-05-09','2022-05-10 22:44:06','2022-05-11 22:44:06','763',11188778.20,11188778.20,'763','2022-05-10 23:17:12','763','2022-05-11 00:21:27',10,0),('21','220',58,'Daily','2022-05-10','2022-05-11 20:11:45','2022-05-12 20:11:45','763',9391930.70,9391930.70,'763','2022-05-11 20:28:26','763','2022-05-12 17:57:02',10,0),('21','220',59,'Daily','2022-05-11','2022-05-12 17:57:41','2022-05-13 17:57:41','763',12836616.10,12836616.10,'763','2022-05-17 16:50:48','763','2022-05-17 17:13:48',10,0),('21','220',60,'Daily','2022-05-12','2022-05-17 17:15:23','2022-05-18 17:15:23','763',9714941.10,9714941.10,'763','2022-05-17 17:33:22','763','2022-05-17 17:54:40',10,0),('21','220',61,'Daily','2022-05-13','2022-05-18 14:49:11','2022-05-19 14:49:11','763',14667438.30,14667438.30,'763','2022-05-18 15:36:17','763','2022-05-18 17:40:21',10,0),('21','220',62,'Daily','2022-05-14','2022-05-19 19:05:02','2022-05-20 19:05:02','763',12866847.15,12866847.15,'763','2022-05-19 19:29:35','763','2022-05-19 19:36:01',10,0),('21','220',63,'AGO post-price change sale 14/05/2022','2022-05-14','2022-05-19 21:08:32','2022-05-20 21:08:32','763',4363012.80,4363012.80,'763','2022-05-19 21:14:43','763','2022-05-19 21:15:02',10,0),('21','220',64,'Daily','2022-05-15','2022-05-20 12:28:38','2022-05-21 12:28:38','763',14294765.05,14294765.05,'763','2022-05-20 12:39:43','763','2022-05-20 13:02:00',10,0),('21','220',65,'Daily','2022-05-16','2022-05-20 13:06:26','2022-05-21 13:06:26','763',16745879.50,16745879.50,'763','2022-05-20 13:30:59','763','2022-05-20 18:26:23',10,0),('21','220',66,'Daily Shift','2022-05-17','2022-05-20 18:27:07','2022-05-21 18:27:07','763',15002114.80,15002114.80,'763','2022-05-20 18:39:17','763','2022-05-20 18:56:58',10,0),('21','220',67,'Daily','2022-05-18','2022-05-20 18:58:35','2022-05-21 18:58:35','763',16319136.55,16319136.55,'763','2022-05-20 19:28:52','763','2022-05-20 20:36:02',10,0),('21','220',68,'Daily Shift','2022-05-19','2022-05-20 21:43:36','2022-05-21 21:43:36','763',18770728.90,18770728.90,'763','2022-05-21 00:44:56','763','2022-05-21 00:50:03',10,0),('21','220',69,'Daily Shift','2022-05-20','2022-05-21 18:15:30','2022-05-22 18:15:30','763',14902277.85,14902277.85,'763','2022-05-21 18:43:41','763','2022-05-22 00:00:08',10,0),('21','220',70,'Daily Shift ','2022-05-21','2022-05-23 09:50:38','2022-05-24 09:50:38','763',13456104.35,13456104.35,'763','2022-05-23 10:13:27','763','2022-05-23 10:55:46',10,0),('21','220',71,'Daily Shift ','2022-05-22','2022-05-23 12:09:20','2022-05-24 12:09:20','763',9517716.20,9517716.20,'763','2022-05-23 12:41:23','763','2022-05-23 14:27:21',10,0),('21','220',72,'Daily Shift','2022-05-23','2022-05-24 20:45:23','2022-05-25 20:45:23','763',11253404.45,11253404.45,'763','2022-05-24 21:12:42','763','2022-05-24 21:47:24',10,0),('21','220',73,'AGO post price change Sales from 720 to 760 on 23/','2022-05-23','2022-05-24 21:48:44','2022-05-25 21:48:44','763',5537907.20,5537907.20,'763','2022-05-24 21:59:39','763','2022-05-24 22:05:41',10,0),('21','220',74,'Daily ','2022-05-24','2022-05-26 19:28:35','2022-05-27 19:28:35','763',14959074.85,14959074.85,'763','2022-05-26 19:51:34','763','2022-05-26 21:03:49',10,0),('21','220',75,'Daily ','2022-05-24','2022-05-26 21:16:07','2022-05-27 21:16:07','763',16224261.00,16224261.00,'763','2022-05-26 22:21:21','763','2022-05-27 01:00:55',10,0),('21','220',76,'Daily Shift ','2022-05-25','2022-05-27 17:00:32','2022-05-28 17:00:32','763',12410509.70,12410509.70,'763','2022-05-27 17:43:41','763','2022-05-28 16:49:07',10,0),('21','220',77,'Daily ','2022-05-27','2022-05-28 17:49:03','2022-05-29 17:49:03','763',11384445.65,11384445.65,'763','2022-05-30 11:01:42','763','2022-05-30 11:03:32',10,0),('21','220',78,'Daily Shift','2022-05-28','2022-05-30 11:04:29','2022-05-31 11:04:29','763',11546201.35,11546201.35,'763','2022-05-30 11:27:37','763','2022-05-30 17:25:57',10,0),('21','220',79,'Daily Shift','2022-05-29','2022-05-30 17:27:55','2022-05-31 17:27:55','763',11482891.80,11482891.80,'763','2022-05-30 17:43:12','763','2022-05-31 17:46:40',10,0),('21','220',80,'Daily Shift ','2022-05-30','2022-05-31 17:47:31','2022-06-01 17:47:31','763',15566938.85,15566938.85,'763','2022-05-31 18:33:25','763','2022-06-01 20:46:51',10,0),('21','220',81,'Daily Shift','2022-05-31','2022-06-01 20:48:17','2022-06-02 20:48:17','763',21924069.20,21924069.20,'763','2022-06-01 21:48:01','763','2022-06-02 10:28:16',10,0),('21','220',82,'Daily Shift ','2022-06-01','2022-06-02 17:36:45','2022-06-03 17:36:45','763',6156705.60,6156705.60,'763','2022-06-03 19:25:50','764','2022-06-04 13:37:33',10,0),('21','220',83,'Daily ','2022-06-02','2022-06-05 18:49:51','2022-06-06 18:49:51','763',16352339.40,16352339.40,'763','2022-06-05 19:12:25','763','2022-06-05 19:36:36',10,0),('21','220',84,'Daily Shift ','2022-06-03','2022-06-06 16:01:56','2022-06-07 16:01:56','763',14407411.40,14407411.40,'763','2022-06-06 16:58:41','763','2022-06-06 17:13:04',10,0),('21','220',85,'Daily Shift ','2022-06-04','2022-06-06 17:15:27','2022-06-07 17:15:27','763',8770974.90,8770974.90,'763','2022-06-06 20:09:10','763','2022-06-08 14:28:39',10,0),('21','220',86,'Daily Shift ','2022-06-05','2022-06-08 14:31:14','2022-06-09 14:31:14','763',10202165.15,10202165.15,'763','2022-06-08 15:23:16','763','2022-06-08 15:23:48',10,0),('21','220',87,'Daily Shift ','2022-06-06','2022-06-13 14:18:56','2022-06-14 14:18:56','763',19108839.85,19108839.85,'763','2022-06-13 15:53:33','763','2022-06-13 15:54:12',10,0),('21','220',88,'Daily Shift ','2022-06-07','2022-06-13 15:54:54','2022-06-14 15:54:54','763',16334211.70,16334211.70,'763','2022-06-13 17:04:36','763','2022-06-13 17:05:12',10,0),('21','220',89,'Daily Shift ','2022-06-08','2022-06-13 18:07:51','2022-06-14 18:07:51','763',4947838.00,4947838.00,'763','2022-06-13 19:45:44','763','2022-06-13 19:46:32',10,0),('21','220',90,'Daily Shift ','2022-06-08','2022-06-13 21:03:22','2022-06-14 21:03:22','763',4172175.50,4427012.30,'763','2022-06-13 21:09:17','763','2022-06-13 21:09:51',10,0),('21','220',91,'Daily Shift ','2022-06-09','2022-06-13 21:11:09','2022-06-14 21:11:09','763',19103512.00,19581743.20,'763','2022-06-13 21:31:30','763','2022-06-13 22:14:36',10,0),('21','220',92,'Daily Shift ','2022-06-10','2022-06-14 12:36:31','2022-06-15 12:36:31','763',18336826.60,19143429.80,'763','2022-06-14 12:56:06','763','2022-06-14 12:56:48',10,0),('21','220',93,'Daily Shift ','2022-06-11','2022-06-14 13:54:33','2022-06-15 13:54:33','763',15887275.80,16674127.80,'763','2022-06-14 14:18:10','763','2022-06-14 14:18:36',10,0),('21','220',94,'Daily Shift ','2022-06-12','2022-06-14 14:21:19','2022-06-15 14:21:19','763',10013880.15,10263110.55,'763','2022-06-14 15:09:14','763','2022-06-14 15:09:44',10,0),('21','220',95,'Daily Shift','2022-06-13','2022-06-16 15:26:39','2022-06-17 15:26:39','763',15508078.85,16269076.45,'763','2022-06-16 16:06:50','763','2022-06-16 17:20:30',10,0),('21','220',96,'Daily Shift','2022-06-14','2022-06-16 17:34:21','2022-06-17 17:34:21','763',13719743.10,13719743.10,'763','2022-06-16 18:05:02','763','2022-06-16 20:40:38',10,0),('21','220',97,'Daily Shift ','2022-06-15','2022-06-16 21:35:23','2022-06-17 21:35:23','763',14632965.25,14632965.25,'763','2022-06-17 17:23:46','763','2022-06-17 17:26:32',10,0),('21','220',98,'Daily Shift','2022-06-16','2022-06-17 17:57:40','2022-06-18 17:57:40','763',15787272.10,15787272.10,'763','2022-06-17 18:29:33','763','2022-06-17 18:31:24',10,0),('21','220',99,'Daily Shift','2022-06-17','2022-06-18 18:30:22','2022-06-19 18:30:22','763',17315220.20,17315220.20,'763','2022-06-19 17:58:25','763','2022-06-20 14:42:33',10,0),('21','220',100,'Daily Shift','2022-06-18','2022-06-20 17:38:41','2022-06-21 17:38:41','763',15316181.85,15316181.85,'763','2022-06-22 18:59:33','763','2022-06-22 19:24:25',10,0),('21','220',101,'Daily Shift','2022-06-22','2022-06-22 19:29:48','2022-06-23 19:29:48','763',10166565.90,10203779.40,'763','2022-06-22 20:14:23','763','2022-06-22 20:16:07',10,0),('21','220',102,'Daily Shift ','2022-06-27','2022-06-27 15:44:17','2022-06-28 15:44:17','763',0.00,0.00,'763','2022-06-28 15:19:20','763','2022-06-28 15:19:35',10,0),('21','220',103,'Daily Shift ','2022-06-20','2022-06-28 15:25:56','2022-06-29 15:25:56','763',13110049.75,13110049.75,'763','2022-06-28 15:55:47','763','2022-06-28 18:08:00',10,0),('21','220',104,'Daily Shift ','2022-06-21','2022-06-28 18:24:40','2022-06-29 18:24:40','763',11235692.35,11235692.35,'763','2022-06-28 18:49:51','763','2022-06-28 18:53:27',10,0),('21','220',105,'Daily Shift ','2022-06-22','2022-06-29 15:22:17','2022-06-30 15:22:17','763',9759771.80,9759771.80,'763','2022-06-29 16:58:14','763','2022-06-29 17:17:14',10,0),('21','220',106,'Daily Shift ','2022-06-23','2022-06-29 18:23:28','2022-06-30 18:23:28','763',8544590.50,8544590.50,'763','2022-06-29 18:44:25','763','2022-06-29 18:46:35',10,0),('21','220',107,'Daily Shift ','2022-06-24','2022-06-30 14:29:27','2022-07-01 14:29:27','763',12174036.55,12174036.55,'763','2022-06-30 15:06:55','763','2022-06-30 15:08:32',10,0),('21','220',108,'Daily Shift ','2022-06-25','2022-06-30 15:46:51','2022-07-01 15:46:51','763',10314347.30,10314347.30,'763','2022-06-30 16:23:36','763','2022-06-30 16:24:49',10,0),('21','220',109,'Daily Shift ','2022-06-26','2022-06-30 16:41:24','2022-07-01 16:41:24','763',9526571.70,9526571.70,'763','2022-06-30 17:09:36','763','2022-06-30 17:13:39',10,0),('21','220',110,'Daily Shift ','2022-06-27','2022-06-30 17:35:20','2022-07-01 17:35:20','763',8925936.21,8925936.21,'763','2022-06-30 18:09:32','763','2022-06-30 18:10:38',10,0),('21','220',111,'Daily Shift ','2022-06-28','2022-06-30 18:34:25','2022-07-01 18:34:25','763',16037740.35,16037740.35,'763','2022-06-30 18:57:10','763','2022-06-30 19:00:03',10,0),('21','220',112,'Daily Shift','2022-06-29','2022-07-01 15:31:04','2022-07-02 15:31:04','763',11629074.40,11629074.40,'763','2022-07-01 16:09:17','763','2022-07-01 16:10:12',10,0),('21','220',113,'Daily Shift','2022-06-30','2022-07-01 16:13:57','2022-07-02 16:13:57','763',12470507.30,12470507.30,'763','2022-07-02 07:52:26','763','2022-07-03 15:23:22',10,0),('21','220',114,'Daily Shift ','2022-07-01','2022-07-03 16:57:40','2022-07-04 16:57:40','763',8354071.50,8354071.50,'763','2022-07-03 17:33:21','763','2022-07-03 17:34:13',10,0),('21','220',115,'Daily Shift ','2022-07-03','2022-07-03 21:57:53','2022-07-04 21:57:53','763',12166974.07,12166974.07,'763','2022-07-04 15:37:56','763','2022-07-04 15:38:54',10,0),('21','220',116,'Daily Shift ','2022-07-03','2022-07-04 16:08:10','2022-07-05 16:08:10','763',9650176.20,9650176.20,'763','2022-07-04 16:29:52','763','2022-07-04 17:32:02',10,0),('21','220',117,'Daily Shift ','2022-07-04','2022-07-08 14:34:03','2022-07-09 14:34:03','763',11982554.15,11982554.15,'763','2022-07-08 15:14:32','763','2022-07-08 15:19:06',10,0),('21','220',118,'Daily Shift ','2022-07-05','2022-07-08 16:10:42','2022-07-09 16:10:42','763',13332806.00,13332806.00,'763','2022-07-08 18:16:43','763','2022-07-08 18:17:52',10,0),('21','220',119,'Daily Shift ','2022-07-06','2022-07-09 16:05:17','2022-07-10 16:05:17','763',11008486.55,11008486.55,'763','2022-07-09 16:29:17','763','2022-07-09 16:30:45',10,0),('21','220',120,'Daily shift','2022-07-07','2022-07-09 16:34:55','2022-07-10 16:34:55','763',10247091.20,10247091.20,'763','2022-07-09 17:39:03','763','2022-07-09 17:39:51',10,0),('21','220',121,'Daily Shift ','2022-07-08','2022-07-12 09:24:34','2022-07-13 09:24:34','763',13498951.60,13498951.60,'763','2022-07-12 12:33:47','763','2022-07-12 12:35:11',10,0),('21','220',122,'Daily Shift ','2022-07-09','2022-07-12 13:24:42','2022-07-13 13:24:42','763',7973397.20,7973397.20,'763','2022-07-12 13:42:48','763','2022-07-12 13:43:57',10,0),('21','220',123,'Daily Shift ','2022-07-10','2022-07-12 15:27:05','2022-07-13 15:27:05','763',2270906.39,2270906.39,'763','2022-07-12 15:47:38','763','2022-07-12 15:48:48',10,0),('21','220',124,'Daily Shift ','2022-07-11','2022-07-12 16:28:16','2022-07-13 16:28:16','763',9933786.40,9933786.40,'763','2022-07-12 16:52:28','763','2022-07-12 16:53:09',10,0),('21','220',125,'Daily Shift ','2022-07-12','2022-07-13 18:31:47','2022-07-14 18:31:47','763',638081.65,638081.65,'763','2022-07-13 18:59:47','763','2022-07-13 19:00:10',10,0),('21','220',126,'Daily Shift ','2022-07-12','2022-07-13 19:19:35','2022-07-14 19:19:35','763',14042086.00,14042086.00,'763','2022-07-13 19:42:06','763','2022-07-13 19:42:44',10,0),('21','220',127,'Daily Shift ','2022-07-13','2022-07-14 15:36:22','2022-07-15 15:36:22','763',16906137.45,16906137.45,'763','2022-07-14 16:43:58','763','2022-07-15 18:18:55',10,0),('21','220',128,'Daily Shift ','2022-07-14','2022-07-15 18:19:55','2022-07-16 18:19:55','763',13378805.35,13378805.35,'763','2022-07-15 18:54:29','763','2022-07-15 18:55:18',10,0),('21','220',129,'Daily Shift ','2022-07-15','2022-07-16 12:57:17','2022-07-17 12:57:17','763',10680485.95,10680485.95,'763','2022-07-16 13:38:00','763','2022-07-16 13:39:41',10,0),('21','220',130,'DAILY','2022-07-16','2022-07-16 16:25:36','2022-07-17 16:25:36','764',9527791.80,9527791.80,'763','2022-07-18 15:15:04','763','2022-07-18 15:44:41',10,0),('21','220',131,'DAILY SHIFT','2022-07-17','2022-07-18 15:45:06','2022-07-19 15:45:06','763',2357129.35,2357129.35,'763','2022-07-18 19:54:25','763','2022-07-19 12:50:08',10,0),('21','220',132,'Daily Shift ','2022-07-18','2022-07-19 18:19:26','2022-07-20 18:19:26','763',16213497.95,16213497.95,'763','2022-07-19 19:00:19','763','2022-07-19 19:00:54',10,0),('21','220',133,'Daily Shift ','2022-07-19','2022-07-20 17:41:03','2022-07-21 17:41:03','763',10878528.85,10878528.85,'763','2022-07-20 18:28:16','764','2022-07-20 20:20:10',10,0),('21','220',134,'Daily Shift ','2022-07-20','2022-07-22 14:01:28','2022-07-23 14:01:28','763',17957928.05,17957928.05,'763','2022-07-22 16:09:04','763','2022-07-22 16:09:41',10,0),('21','220',135,'Daily Shift ','2022-07-21','2022-07-22 17:50:02','2022-07-23 17:50:02','763',12639563.30,12639563.30,'763','2022-07-22 18:17:40','763','2022-07-22 18:18:30',10,0),('21','220',136,'Daily Shift ','2022-07-22','2022-07-23 15:24:45','2022-07-24 15:24:45','763',15623227.15,15623227.15,'763','2022-07-23 16:30:53','763','2022-07-23 16:32:03',10,0),('21','220',137,'Daily Shift ','2022-07-23','2022-07-24 13:26:11','2022-07-25 13:26:11','763',11365848.65,11365848.65,'763','2022-07-24 13:59:34','763','2022-07-24 14:01:51',10,0),('21','220',138,'Daily Shift ','2022-07-24','2022-07-25 13:48:35','2022-07-26 13:48:35','763',8538980.20,8538980.20,'763','2022-07-25 15:31:02','763','2022-07-25 17:28:18',10,0),('21','220',139,'Daily Shift ','2022-07-25','2022-07-26 12:18:48','2022-07-27 12:18:48','763',10611206.90,10611206.90,'763','2022-07-26 12:47:46','763','2022-07-26 12:48:36',10,0),('21','220',140,'Daily shift','2022-07-26','2022-07-27 13:03:13','2022-07-28 13:03:13','763',12211505.65,12211505.65,'763','2022-07-27 13:45:01','763','2022-07-28 14:38:52',10,0),('21','220',141,'Daily shift','2022-07-27','2022-07-28 14:40:05','2022-07-29 14:40:05','763',11038277.05,11038277.05,'763','2022-07-28 16:55:22','763','2022-07-28 17:35:51',10,0),('21','220',142,'Daily Shift ','2022-07-28','2022-07-29 15:45:05','2022-07-30 15:45:05','763',13369551.80,13369551.80,'763','2022-07-30 09:07:09','763','2022-07-30 09:07:56',10,0),('21','220',143,'Daily Shift ','2022-07-29','2022-07-30 12:51:22','2022-07-31 12:51:22','763',11143495.35,11143495.35,'763','2022-07-30 13:29:55','763','2022-07-30 13:30:36',10,0),('21','220',144,'Daily shift','2022-07-30','2022-07-31 14:58:12','2022-08-01 14:58:12','763',11543006.70,11543006.70,'763','2022-07-31 17:22:15','763','2022-07-31 17:22:47',10,0),('21','220',145,'Daily shift','2022-08-01','2022-08-01 12:21:30','2022-08-02 12:21:30','763',6232023.45,6232023.45,'763','2022-08-02 15:14:57','763','2022-08-02 15:15:59',10,0),('21','220',146,'Daily Shift ','2022-08-01','2022-08-02 15:17:41','2022-08-03 15:17:41','763',9250768.40,9250768.40,'763','2022-08-02 16:50:18','763','2022-08-02 16:51:32',10,0),('21','220',147,'Daily shift','2022-08-02','2022-08-03 11:00:02','2022-08-04 11:00:02','763',13259934.95,13259934.95,'763','2022-08-03 12:48:27','763','2022-08-03 12:49:24',10,0),('21','220',148,'Daily Shift ','2022-08-03','2022-08-04 15:35:21','2022-08-05 15:35:21','763',10650728.50,10650728.50,'763','2022-08-04 16:20:28','763','2022-08-04 16:21:01',10,0),('21','220',149,'Daily Shift ','2022-08-04','2022-08-05 13:10:32','2022-08-06 13:10:32','763',9121358.55,9121358.55,'763','2022-08-05 13:42:35','763','2022-08-05 13:43:24',10,0),('21','220',150,'Daily shift','2022-08-05','2022-08-06 13:22:53','2022-08-07 13:22:53','763',10784367.93,10784367.93,'763','2022-08-06 14:42:35','763','2022-08-06 14:43:05',10,0),('21','220',151,'Daily shift','2022-08-06','2022-08-08 08:01:46','2022-08-09 08:01:46','763',4494523.25,4494523.25,'763','2022-08-08 08:40:47','763','2022-08-08 08:43:08',10,0),('21','220',152,'Daily shift','2022-08-07','2022-08-08 08:44:50','2022-08-09 08:44:50','763',6527288.40,6527288.40,'763','2022-08-08 09:21:27','763','2022-08-08 09:22:02',10,0),('21','220',153,'Daily Shift ','2022-08-08','2022-08-09 08:33:55','2022-08-10 08:33:55','763',5494499.05,5494499.05,'763','2022-08-09 12:36:53','763','2022-08-09 12:38:28',10,0),('21','220',154,'Daily Shift ','2022-08-09','2022-08-10 07:10:59','2022-08-11 07:10:59','763',9982227.00,9982227.00,'763','2022-08-10 07:48:07','763','2022-08-10 07:48:47',10,0),('21','220',155,'Daily Shift ','2022-08-10','2022-08-11 07:13:22','2022-08-12 07:13:22','763',13111049.65,13111049.65,'763','2022-08-11 07:38:15','763','2022-08-11 07:38:40',10,0),('21','220',156,'Daily Shift ','2022-08-11','2022-08-12 07:33:41','2022-08-13 07:33:41','763',12285574.90,12285574.90,'763','2022-08-12 08:12:22','763','2022-08-12 08:12:55',10,0),('21','220',157,'Daily Shift ','2022-08-12','2022-08-13 09:09:15','2022-08-14 09:09:15','763',9168903.70,9168903.70,'763','2022-08-13 10:20:00','763','2022-08-13 10:21:06',10,0),('21','220',158,'Daily shift','2022-08-13','2022-08-15 16:28:26','2022-08-16 16:28:26','763',6655949.05,6655949.05,'763','2022-08-15 16:48:28','763','2022-08-15 17:21:10',10,0),('21','220',159,'Daily Shift','2022-08-14','2022-08-15 17:22:41','2022-08-16 17:22:41','763',1401240.10,1401240.10,'763','2022-08-15 17:35:10','763','2022-08-16 12:09:56',10,0),('21','220',160,'Daily Shift ','2022-08-15','2022-08-17 11:39:54','2022-08-18 11:39:54','763',13050832.90,13050832.90,'763','2022-08-17 12:42:54','763','2022-08-17 12:43:55',10,0),('21','220',161,'Daily Shift ','2022-08-16','2022-08-17 14:39:11','2022-08-18 14:39:11','763',9843808.95,9843808.95,'763','2022-08-17 15:41:35','763','2022-08-18 09:45:18',10,0),('21','220',162,'Daily Shift ','2022-08-17','2022-08-18 09:57:27','2022-08-19 09:57:27','763',15014620.95,15014620.95,'763','2022-08-18 10:34:05','763','2022-08-18 10:34:48',10,0),('21','220',163,'Daily Shift ','2022-08-18','2022-08-19 11:15:30','2022-08-20 11:15:30','763',13931379.29,13931379.29,'763','2022-08-19 12:39:01','763','2022-08-20 10:38:31',10,0),('21','220',164,'Daily Shift ','2022-08-19','2022-08-20 10:41:14','2022-08-21 10:41:14','763',7095174.10,7095174.10,'763','2022-08-20 11:05:12','763','2022-08-20 11:06:44',10,0),('21','220',165,'Daily Shift ','2022-08-20','2022-08-22 09:12:13','2022-08-23 09:12:13','763',4932557.34,4932557.34,'763','2022-08-22 09:36:00','763','2022-08-22 09:36:36',10,0),('21','220',166,'Daily Shift ','2022-08-21','2022-08-22 09:47:04','2022-08-23 09:47:04','763',6883168.76,6883168.76,'763','2022-08-22 10:00:32','763','2022-08-22 10:01:25',10,0),('21','220',167,'Daily Shift ','2022-08-22','2022-08-23 06:56:35','2022-08-24 06:56:35','763',10390935.32,10390935.32,'763','2022-08-23 09:31:11','763','2022-08-23 09:31:39',10,0),('21','220',168,'Daily Shift ','2022-08-23','2022-08-24 08:35:20','2022-08-25 08:35:20','763',12959609.71,12959609.71,'763','2022-08-24 09:42:51','763','2022-08-24 09:45:45',10,0),('21','220',169,'Daily Shift ','2022-08-24','2022-08-25 08:54:18','2022-08-26 08:54:18','763',8438346.18,8438346.18,'763','2022-08-25 09:44:30','763','2022-08-25 09:46:11',10,0),('21','220',170,'Daily Shift ','2022-08-25','2022-08-26 09:30:29','2022-08-27 09:30:29','763',11487826.84,11487826.84,'763','2022-08-26 10:00:25','763','2022-08-26 10:01:32',10,0),('21','220',171,'Daily Shift ','2022-08-26','2022-08-27 10:38:28','2022-08-28 10:38:28','763',8799947.93,8799947.93,'763','2022-08-27 10:54:39','763','2022-08-27 10:55:03',10,0),('21','220',172,'Daily Shift ','2022-08-27','2022-08-28 11:43:28','2022-08-29 11:43:28','763',8666713.87,8666713.87,'763','2022-08-28 12:28:07','763','2022-08-28 12:49:46',10,0),('21','220',173,'Daily Shift ','2022-08-28','2022-08-29 08:44:28','2022-08-30 08:44:28','763',9174176.03,9174176.03,'763','2022-08-29 09:19:59','763','2022-08-29 09:20:48',10,0),('21','220',174,'Daily Shift ','2022-08-29','2022-08-30 09:31:03','2022-08-31 09:31:03','763',9168623.64,9168623.64,'763','2022-08-30 10:01:08','763','2022-08-30 10:01:38',10,0),('21','220',175,'Daily shift','2022-08-30','2022-08-31 10:33:57','2022-09-01 10:33:57','763',8846879.34,8846879.34,'763','2022-08-31 11:09:24','763','2022-08-31 11:10:53',10,0),('21','220',176,'Daily Shift ','2022-08-31','2022-09-01 09:43:04','2022-09-02 09:43:04','763',5594036.55,5594036.55,'763','2022-09-01 10:17:25','763','2022-09-01 10:18:12',10,0),('21','220',177,'Daily Shift ','2022-09-01','2022-09-02 08:57:34','2022-09-03 08:57:34','763',7047657.00,7047657.00,'763','2022-09-02 12:22:39','763','2022-09-02 12:23:25',10,0),('21','220',178,'Daily Shift ','2022-09-02','2022-09-03 08:35:35','2022-09-04 08:35:35','763',11932163.28,11932163.28,'763','2022-09-03 09:00:07','763','2022-09-03 09:00:34',10,0),('21','220',179,'Daily Shift ','2022-09-03','2022-09-05 08:48:39','2022-09-06 08:48:39','763',10588062.61,10588062.61,'763','2022-09-05 09:21:29','763','2022-09-05 09:21:56',10,0),('21','220',180,'Daily Shift ','2022-09-04','2022-09-05 12:02:40','2022-09-06 12:02:40','763',7914902.92,7914902.92,'763','2022-09-05 12:48:26','763','2022-09-05 12:49:25',10,0),('21','220',181,'Daily Shift ','2022-09-05','2022-09-06 08:47:16','2022-09-07 08:47:16','763',9420670.93,9420670.93,'763','2022-09-06 09:10:42','763','2022-09-06 09:11:07',10,0),('21','220',182,'Daily Shift ','2022-09-06','2022-09-07 12:43:45','2022-09-08 12:43:45','763',6715789.04,6715789.04,'763','2022-09-07 13:00:55','763','2022-09-08 07:59:40',10,0),('21','220',183,'Daily Shift ','2022-09-07','2022-09-08 08:00:34','2022-09-09 08:00:34','763',10110068.79,10110068.79,'763','2022-09-08 08:39:55','763','2022-09-08 08:40:27',10,0),('21','220',184,'Daily Shift ','2022-09-08','2022-09-09 07:36:14','2022-09-10 07:36:14','763',12178232.02,12178232.02,'763','2022-09-09 08:00:38','763','2022-09-09 08:01:21',10,0),('21','220',185,'Daily Shift ','2022-09-09','2022-09-10 14:19:06','2022-09-11 14:19:06','763',11218530.06,11218530.06,'763','2022-09-10 14:41:03','763','2022-09-10 14:41:37',10,0),('21','220',186,'Daily Shift ','2022-09-10','2022-09-11 13:34:08','2022-09-12 13:34:08','763',0.00,0.00,'764','2022-09-11 18:03:53','764','2022-09-11 18:04:23',10,0),('21','220',187,'Daily Shift ','2022-09-10','2022-09-11 18:08:56','2022-09-12 18:08:56','763',11570800.19,11570800.19,'763','2022-09-12 15:41:23','763','2022-09-12 16:40:29',10,0),('21','220',188,'Daily Shift ','2022-09-11','2022-09-12 16:41:13','2022-09-13 16:41:13','763',11561119.00,11561119.00,'763','2022-09-12 17:47:19','763','2022-09-13 07:37:59',10,0),('21','220',189,'Daily shift','2022-09-12','2022-09-13 07:42:08','2022-09-14 07:42:08','763',18381207.25,18381207.25,'763','2022-09-13 08:09:24','763','2022-09-13 08:14:57',10,0),('21','220',190,'Daily Shift ','2022-09-13','2022-09-14 09:40:38','2022-09-15 09:40:38','763',12184964.28,12184964.28,'763','2022-09-14 09:56:22','763','2022-09-14 09:56:59',10,0),('21','220',191,'Daily shift','2022-09-14','2022-09-15 09:54:27','2022-09-16 09:54:27','763',9907635.87,9907635.87,'763','2022-09-15 10:34:40','763','2022-09-15 19:21:13',10,0),('21','220',192,'Daily shift ','2022-09-15','2022-09-16 10:37:15','2022-09-17 10:37:15','763',0.00,0.00,'763','2022-09-16 12:32:17','763','2022-09-16 12:33:11',10,0),('21','220',193,'Daily shift ','2022-09-15','2022-09-16 17:46:06','2022-09-17 17:46:06','763',11954963.44,11954963.44,'763','2022-09-17 06:29:07','763','2022-09-17 12:09:31',10,0),('21','220',194,'Daily shift ','2022-09-16','2022-09-17 12:20:11','2022-09-18 12:20:11','763',15062337.84,15062337.84,'763','2022-09-19 08:10:19','763','2022-09-19 08:11:12',10,0),('21','220',195,'Daily shift','2022-09-17','2022-09-19 09:46:53','2022-09-20 09:46:53','763',8955385.85,8955385.85,'763','2022-09-19 11:10:18','763','2022-09-19 12:30:17',10,0),('21','220',196,'Daily','2022-09-18','2022-09-19 12:55:25','2022-09-20 12:55:25','763',9230332.83,9230332.83,'763','2022-09-19 13:26:26','763','2022-09-19 16:47:48',10,0),('21','220',197,'Daily shift','2022-09-19','2022-09-20 11:36:06','2022-09-21 11:36:06','763',9701623.93,9701623.93,'763','2022-09-20 12:14:55','763','2022-09-21 10:38:45',10,0),('21','220',198,'Daily shift','2022-09-20','2022-09-21 10:39:46','2022-09-22 10:39:46','763',4590315.75,4590315.75,'763','2022-09-21 11:27:55','763','2022-09-21 11:28:51',10,0),('21','220',199,'Daily Shift ','2022-09-21','2022-09-22 14:10:58','2022-09-23 14:10:58','763',12788304.89,12788304.89,'763','2022-09-22 14:39:55','763','2022-09-23 09:10:11',10,0),('21','220',200,'Daily Shift ','2022-09-22','2022-09-23 09:11:04','2022-09-24 09:11:04','763',14461238.36,14461238.36,'763','2022-09-23 10:09:03','763','2022-09-23 10:09:34',10,0),('21','220',201,'Daily Shift ','2022-09-23','2022-09-24 11:48:24','2022-09-25 11:48:24','763',17314201.24,17314201.24,'763','2022-09-24 12:38:20','763','2022-09-24 12:38:50',10,0),('21','220',202,'Daily Shift ','2022-09-24','2022-09-25 17:38:56','2022-09-26 17:38:56','763',5716853.76,5716853.76,'763','2022-09-25 18:08:59','763','2022-09-25 18:23:49',10,0),('21','220',203,'Daily Shift ','2022-09-25','2022-09-26 10:02:17','2022-09-27 10:02:17','763',6719687.25,6719687.25,'763','2022-09-26 11:45:12','763','2022-09-26 11:52:39',10,0),('21','220',204,'Daily shift','2022-09-26','2022-09-27 12:32:11','2022-09-28 12:32:11','763',7766154.38,7766154.38,'763','2022-09-27 13:33:57','763','2022-09-27 13:35:36',10,0),('21','220',205,'Daily shift','2022-09-27','2022-09-28 08:36:17','2022-09-29 08:36:17','763',14029463.98,14029463.98,'763','2022-09-28 08:56:54','763','2022-09-28 08:57:23',10,0),('21','220',206,'Daily Shift ','2022-09-28','2022-09-29 08:37:33','2022-09-30 08:37:33','763',12092636.72,12092636.72,'763','2022-09-29 09:10:17','763','2022-09-29 09:37:08',10,0),('21','220',207,'Daily shift','2022-09-29','2022-10-10 12:50:30','2022-10-11 12:50:30','763',11360059.97,11360059.97,'763','2022-10-10 13:33:17','763','2022-10-10 14:16:05',10,0),('21','220',208,'Daily Shift ','2022-09-30','2022-10-10 14:17:03','2022-10-11 14:17:03','763',11574099.18,11574099.18,'763','2022-10-10 15:12:47','763','2022-10-10 15:13:23',10,0),('21','220',209,'Daily shift','2022-10-01','2022-10-10 15:20:35','2022-10-11 15:20:35','763',8659404.88,8659404.88,'763','2022-10-10 15:36:23','763','2022-10-10 15:46:06',10,0),('21','220',210,'Daily Shift ','2022-10-02','2022-10-10 15:48:35','2022-10-11 15:48:35','763',5294683.12,5294683.12,'763','2022-10-10 16:01:10','763','2022-10-10 16:05:13',10,0),('21','220',211,'Daily shift ','2022-10-03','2022-10-10 16:23:48','2022-10-11 16:23:48','763',7828434.88,7828434.88,'763','2022-10-12 16:57:05','763','2022-10-12 16:57:58',10,0),('21','220',212,'Daily Shift ','2022-10-04','2022-10-12 17:11:19','2022-10-13 17:11:19','763',9048726.49,9048726.49,'763','2022-10-12 17:22:32','763','2022-10-12 17:23:05',10,0),('21','220',213,'Daily Shift ','2022-10-05','2022-10-12 17:37:36','2022-10-13 17:37:36','763',3101222.10,3101222.10,'763','2022-10-12 18:02:18','763','2022-10-12 18:02:54',10,0),('21','220',214,'Daily shift ','2022-10-06','2022-10-14 10:38:56','2022-10-15 10:38:56','763',6631992.93,6631992.93,'763','2022-10-14 11:04:27','763','2022-10-14 11:04:54',10,0),('21','220',215,'Daily shift ','2022-10-07','2022-10-14 12:44:42','2022-10-15 12:44:42','763',2405252.33,2405252.33,'763','2022-10-14 12:58:34','763','2022-10-14 12:58:55',10,0),('21','220',216,'Daily Shift ','2022-10-08','2022-10-14 16:21:47','2022-10-15 16:21:47','763',4852992.11,4852992.11,'763','2022-10-14 16:34:41','763','2022-10-14 16:35:18',10,0),('21','220',217,'Daily Shift ','2022-10-09','2022-10-14 16:58:47','2022-10-15 16:58:47','763',903945.40,903945.40,'763','2022-10-15 16:42:52','763','2022-10-16 16:21:31',10,0),('21','220',218,'Daily Shift ','2022-10-10','2022-10-16 16:22:16','2022-10-17 16:22:16','763',5355855.89,5355855.89,'763','2022-10-17 06:38:28','763','2022-10-17 17:57:05',10,0),('21','220',219,'Daily shift','2022-10-11','2022-10-17 17:58:35','2022-10-18 17:58:35','763',9554318.92,9554318.92,'763','2022-10-17 18:41:40','763','2022-10-17 18:42:51',10,0),('21','220',220,'Daily Shift ','2022-10-12','2022-10-18 18:53:15','2022-10-19 18:53:15','763',5492391.81,5492391.81,'763','2022-10-18 19:08:48','763','2022-10-18 19:10:07',10,0),('21','220',221,'Daily Shift ','2022-10-13','2022-10-18 19:16:12','2022-10-19 19:16:12','763',10593137.17,10591273.12,'763','2022-10-18 19:36:56','763','2022-10-18 19:40:13',10,0),('21','220',222,'Daily Shift ','2022-10-14','2022-10-18 19:54:27','2022-10-19 19:54:27','763',5990459.39,5990459.39,'763','2022-10-18 20:24:04','763','2022-10-18 20:26:58',10,0),('21','220',223,'Daily Shift ','2022-10-15','2022-10-19 18:13:21','2022-10-20 18:13:21','763',7696087.16,7696087.16,'763','2022-10-19 18:32:21','763','2022-10-19 18:33:10',10,0),('21','220',224,'Daily Shift ','2022-10-16','2022-10-19 18:33:58','2022-10-20 18:33:58','763',10730852.64,10730852.64,'763','2022-10-19 18:46:41','763','2022-10-19 18:53:13',10,0),('21','220',225,'Daily Shift ','2022-10-17','2022-10-19 18:54:03','2022-10-20 18:54:03','763',6333920.94,6333920.94,'763','2022-10-19 19:14:46','763','2022-10-19 19:15:32',10,0),('21','220',226,'Daily Shift ','2022-10-18','2022-10-19 19:17:34','2022-10-20 19:17:34','763',10783393.91,10783393.91,'763','2022-10-19 19:48:35','763','2022-10-19 19:49:20',10,0),('21','220',227,'Daily shift','2022-10-19','2022-10-21 16:35:41','2022-10-22 16:35:41','763',10901269.48,10901269.48,'763','2022-10-21 16:51:28','763','2022-10-21 16:51:46',10,0),('21','220',228,'Daily shift ','2022-10-20','2022-10-21 16:55:30','2022-10-22 16:55:30','763',9066679.19,9066679.19,'763','2022-10-21 17:08:00','763','2022-10-21 17:08:19',10,0),('21','220',229,'Daily Shift ','2022-10-21','2022-10-22 18:10:56','2022-10-23 18:10:56','763',10921814.46,10921814.46,'763','2022-10-22 18:28:44','763','2022-10-22 18:30:53',10,0),('21','220',230,'Daily Shift ','2022-10-22','2022-10-24 17:22:30','2022-10-25 17:22:30','763',858609.31,858609.31,'763','2022-10-24 17:29:11','763','2022-10-24 17:30:03',10,0),('21','220',231,'Daily Shift ','2022-10-23','2022-10-24 19:44:10','2022-10-25 19:44:10','763',4258116.08,4258116.08,'763','2022-10-24 20:30:25','763','2022-10-24 22:09:07',10,0),('21','220',232,'Daily shift ','2022-10-24','2022-10-26 17:07:46','2022-10-27 17:07:46','763',3944007.17,3944007.17,'763','2022-10-26 17:20:54','763','2022-10-26 17:21:21',10,0),('21','220',233,'Daily shift ','2022-10-25','2022-10-26 17:34:59','2022-10-27 17:34:59','763',16149652.22,16149652.22,'763','2022-10-26 18:15:16','763','2022-10-26 18:15:37',10,0),('21','220',234,'Daily shift','2022-10-26','2022-10-27 12:28:17','2022-10-28 12:28:17','763',0.00,0.00,'763','2022-10-29 09:12:51','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4681 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','220','1','4',61,'1','1',1777865.94,1779218.27,1352.33,223134.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','4',62,'2','1',1393054.41,1394551.73,1497.32,247057.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','4',63,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','4',64,'4','1',1338645.83,1341352.27,2706.44,446562.60,0.00,0.00,0.00,0.00,0.00),('21','220','3','4',65,'9','2',1159383.96,1160042.19,658.23,460761.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','4',66,'10','2',782396.20,789450.43,7054.23,4937961.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','4',67,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','4',68,'12','1',1690786.93,1692728.13,1941.20,320298.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','4',69,'13','1',1115791.32,1116556.99,765.67,126335.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','4',70,'14','1',1256040.73,1256040.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','4',71,'15','1',1204262.44,1205987.94,1725.50,284707.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','4',72,'16','1',1907657.85,1911160.67,3502.82,577965.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','4',73,'17','1',1210470.64,1214138.99,3668.35,605277.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','4',74,'18','1',864725.58,867569.80,2844.22,469296.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','4',75,'19','1',1016479.64,1020124.30,3644.66,601368.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','4',76,'20','1',1514797.43,1519747.07,4949.64,816690.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','4',77,'21','1',1200423.85,1200425.21,1.36,224.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','4',78,'22','1',1353442.50,1357089.91,3647.41,601822.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','4',79,'23','1',1214074.84,1215959.77,1884.93,311013.45,0.00,0.00,0.00,0.00,0.00),('21','220','4','4',80,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','5',81,'1','1',1779218.27,1781572.22,2353.95,388401.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','5',82,'2','1',1394551.73,1398161.50,3609.77,595612.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','5',83,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','5',84,'4','1',1341352.27,1346230.14,4877.87,804848.55,0.00,0.00,0.00,0.00,0.00),('21','220','3','5',85,'9','2',1160042.19,1166461.82,6419.63,4493741.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','5',86,'10','2',789450.43,794711.47,5261.04,3682728.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','5',87,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','5',88,'12','1',1692728.13,1695474.79,2746.66,453198.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','5',89,'13','1',1116556.99,1118090.94,1533.95,253101.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','5',90,'14','1',1256040.73,1256040.94,0.21,34.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','5',91,'15','1',1205987.94,1210042.51,4054.57,669004.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','5',92,'16','1',1911160.67,1916338.53,5177.86,854346.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','5',93,'17','1',1214138.99,1217098.66,2959.67,488345.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','5',94,'18','1',867569.80,870774.91,3205.11,528843.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','5',95,'19','1',1020124.30,1023278.83,3154.53,520497.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','5',96,'20','1',1519747.07,1525894.25,6147.18,1014284.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','5',97,'21','1',1200425.21,1200425.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','5',98,'22','1',1357089.91,1359769.17,2679.26,442077.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','5',99,'23','1',1215959.77,1218971.83,3012.06,496989.90,0.00,0.00,0.00,0.00,0.00),('21','220','4','5',100,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','6',101,'1','1',1781572.22,1785437.16,3864.94,637715.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','6',102,'2','1',1398161.50,1401716.47,3554.97,586570.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','6',103,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','6',104,'4','1',1346230.14,1351983.42,5753.28,949291.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','6',105,'9','2',1166461.82,1169751.78,3289.96,2302972.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','6',106,'10','2',794711.47,794711.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','6',107,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','6',108,'12','1',1695474.79,1700291.00,4816.21,794674.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','6',109,'13','1',1118090.94,1118090.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','6',110,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','6',111,'15','1',1210042.51,1213945.75,3903.24,644034.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','6',112,'16','1',1916338.53,1924411.11,8072.58,1331975.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','6',113,'17','1',1217098.66,1220505.03,3406.37,562051.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','6',114,'18','1',870774.91,877213.07,6438.16,1062296.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','6',115,'19','1',1023278.83,1028900.81,5621.98,927626.37,0.00,0.00,0.00,0.00,0.00),('21','220','2','6',116,'20','1',1525894.25,1535379.20,9484.95,1565016.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','6',117,'21','1',1200425.21,1200425.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','6',118,'22','1',1359769.17,1366303.38,6534.21,1078144.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','6',119,'23','1',1218971.83,1223885.93,4914.10,810826.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','6',120,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','7',121,'1','1',1785437.16,1789842.46,4405.30,726874.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','7',122,'2','1',1401716.47,1406622.84,4906.37,809551.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','7',123,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','7',124,'4','1',1351983.42,1358239.79,6256.37,1032301.05,0.00,0.00,0.00,0.00,0.00),('21','220','3','7',125,'9','2',1169751.78,1175166.66,5414.88,3790416.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','7',126,'10','2',794711.47,796235.97,1524.50,1067150.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','7',127,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','7',128,'12','1',1700291.00,1706266.85,5975.85,986015.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','7',129,'13','1',1118090.94,1118090.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','7',130,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','7',131,'15','1',1213945.75,1219493.86,5548.11,915438.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','7',132,'16','1',1924411.11,1929267.64,4856.53,801327.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','7',133,'17','1',1220505.03,1225166.36,4661.33,769119.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','7',134,'18','1',877213.07,881420.17,4207.10,694171.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','7',135,'19','1',1028900.81,1032834.35,3933.54,649034.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','7',136,'20','1',1535379.20,1540458.40,5079.20,838068.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','7',137,'21','1',1200425.21,1200425.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','7',138,'22','1',1366303.38,1370296.59,3993.21,658879.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','7',139,'23','1',1223885.93,1227831.19,3945.26,650967.90,0.00,0.00,0.00,0.00,0.00),('21','220','4','7',140,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','8',141,'1','1',1789842.46,1794585.69,4743.23,782632.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','8',142,'2','1',1406622.84,1411652.41,5029.57,829879.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','8',143,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','8',144,'4','1',1358239.79,1362415.27,4175.48,688954.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','8',145,'9','2',1175166.66,1178438.61,3271.95,2290365.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','8',146,'10','2',796235.97,796235.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','8',147,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','8',148,'12','1',1706266.85,1709928.55,3661.70,604180.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','8',149,'13','1',1118090.94,1118090.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','8',150,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','8',151,'15','1',1219493.86,1225088.57,5594.71,923127.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','8',152,'16','1',1929267.64,1934621.89,5354.25,883451.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','8',153,'17','1',1225166.36,1229312.89,4146.53,684177.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','8',154,'18','1',881420.17,885421.46,4001.29,660212.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','8',155,'19','1',1032834.35,1036263.07,3428.72,565738.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','8',156,'20','1',1540458.40,1546765.46,6307.06,1040664.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','8',157,'21','1',1200425.21,1200425.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','8',158,'22','1',1370296.59,1374362.37,4065.78,670853.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','8',159,'23','1',1227831.19,1229007.69,1176.50,194122.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','8',160,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','9',161,'1','1',1794585.69,1798713.31,4127.62,681057.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','9',162,'2','1',1411652.41,1415348.64,3696.23,609877.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','9',163,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','9',164,'4','1',1362415.27,1366579.27,4164.00,687060.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','9',165,'9','2',1178438.61,1178438.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','9',166,'10','2',796235.97,796650.16,414.19,289933.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','9',167,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','9',168,'12','1',1709928.55,1714254.31,4325.76,713750.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','9',169,'13','1',1118090.94,1118090.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','9',170,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','9',171,'15','1',1225088.57,1229974.42,4885.85,806165.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','9',172,'16','1',1934621.89,1938793.33,4171.44,688287.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','9',173,'17','1',1229312.89,1234587.78,5274.89,870356.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','9',174,'18','1',885421.46,890049.46,4628.00,763620.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','9',175,'19','1',1036263.07,1041210.92,4947.85,816395.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','9',176,'20','1',1546765.46,1553804.97,7039.51,1161519.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','9',177,'21','1',1200425.21,1200426.18,0.97,160.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','9',178,'22','1',1374362.37,1378356.47,3994.10,659026.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','9',179,'23','1',1229007.69,1232064.27,3056.58,504335.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','9',180,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','10',181,'1','1',1798713.31,1800716.14,1982.83,327166.95,0.00,0.00,20.00,0.00,0.00),('21','220','1','10',182,'2','1',1415348.64,1416772.48,1423.84,234933.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','10',183,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','10',184,'4','1',1366579.27,1368630.26,2050.99,338413.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','10',185,'9','2',1178438.61,1178438.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','10',186,'10','2',796650.16,796650.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','10',187,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','10',188,'12','1',1714254.31,1715890.36,1616.05,266648.25,0.00,0.00,20.00,0.00,0.00),('21','220','1','10',189,'13','1',1118090.94,1118090.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','10',190,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','10',191,'15','1',1229974.42,1232752.95,2758.53,455157.45,0.00,0.00,20.00,0.00,0.00),('21','220','2','10',192,'16','1',1938793.33,1944587.10,5793.77,955972.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','10',193,'17','1',1234587.78,1234587.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','10',194,'18','1',890049.46,894447.98,4398.52,725755.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','10',195,'19','1',1041210.92,1045455.81,4244.89,700406.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','10',196,'20','1',1553804.97,1559899.65,6074.68,1002322.20,0.00,0.00,20.00,0.00,0.00),('21','220','2','10',197,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','10',198,'22','1',1378356.47,1381793.49,3437.02,567108.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','10',199,'23','1',1232064.27,1235072.47,3000.20,495033.00,0.00,0.00,8.00,0.00,0.00),('21','220','4','10',200,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','11',201,'1','1',1800716.14,1802294.30,1578.16,260396.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','11',202,'2','1',1416772.48,1418203.12,1430.64,236055.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','11',203,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','11',204,'4','1',1368630.26,1369794.99,1164.73,192180.45,0.00,0.00,0.00,0.00,0.00),('21','220','3','11',205,'9','2',1178438.61,1179610.61,1172.00,820400.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','11',206,'10','2',796650.16,796650.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','11',207,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','11',208,'12','1',1715890.36,1717461.39,1571.03,259219.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','11',209,'13','1',1118090.94,1118090.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','11',210,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','11',211,'15','1',1232752.95,1235727.11,2974.16,490736.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','11',212,'16','1',1944587.10,1949515.69,4928.59,813217.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','11',213,'17','1',1234587.78,1234587.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','11',214,'18','1',894447.98,898863.20,4415.22,728511.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','11',215,'19','1',1045455.81,1049929.93,4474.12,738229.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','11',216,'20','1',1559899.65,1566711.59,6811.94,1123970.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','11',217,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','11',218,'22','1',1381793.49,1385472.00,3678.51,606954.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','11',219,'23','1',1235072.47,1237357.44,2284.97,377020.05,0.00,0.00,0.00,0.00,0.00),('21','220','4','11',220,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','12',221,'1','1',1802294.30,1802294.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','12',222,'2','1',1418203.12,1418203.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','12',223,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','12',224,'4','1',1369794.99,1369794.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','12',225,'9','2',1179610.61,1179610.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','12',226,'10','2',796650.16,796650.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','12',227,'11','3',426198.87,426198.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','12',228,'12','1',1717461.39,1717461.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','12',229,'13','1',1118090.94,1118090.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','12',230,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','12',231,'15','1',1235727.11,1235727.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','12',232,'16','1',1949515.69,1949515.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','12',233,'17','1',1234587.78,1234587.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','12',234,'18','1',898863.20,898863.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','12',235,'19','1',1049929.93,1049929.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','12',236,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','12',237,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','12',238,'22','1',1385472.00,1385472.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','12',239,'23','1',1237357.44,1237357.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','12',240,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','13',241,'1','1',1802294.30,1811802.11,9507.81,1568788.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','13',242,'2','1',1418203.12,1426388.72,8185.60,1350624.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','13',243,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','13',244,'4','1',1369794.99,1381476.95,11681.96,1927523.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','13',245,'9','2',1179610.61,1179610.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','13',246,'10','2',796650.16,804700.26,8050.10,5635070.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','13',247,'11','3',426198.87,427390.86,1191.99,655595.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','13',248,'12','1',1717461.39,1728094.81,10633.42,1754514.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','13',249,'13','1',1118090.94,1118092.39,1.45,239.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','13',250,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','13',251,'15','1',1235727.11,1245697.06,9969.95,1645041.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','13',252,'16','1',1949515.69,1959105.11,9589.42,1582254.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','13',253,'17','1',1234587.78,1239075.52,4487.74,740477.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','13',254,'18','1',898863.20,907562.57,8699.37,1435396.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','13',255,'19','1',1049929.93,1054825.51,4895.58,807770.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','13',256,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','13',257,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','13',258,'22','1',1385472.00,1393467.37,7995.37,1319236.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','13',259,'23','1',1237357.44,1237357.99,0.55,90.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','13',260,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','14',261,'1','1',1811802.11,1811802.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','14',262,'2','1',1426388.72,1426388.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','14',263,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','14',264,'4','1',1381476.95,1381476.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','14',265,'9','2',1179610.61,1179610.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','14',266,'10','2',804700.26,804700.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','14',267,'11','3',427390.86,427390.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','14',268,'12','1',1728094.81,1728094.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','14',269,'13','1',1118092.39,1118092.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','14',270,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','14',271,'15','1',1245697.06,1245697.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','14',272,'16','1',1959105.11,1959105.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','14',273,'17','1',1239075.52,1239075.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','14',274,'18','1',907562.57,907562.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','14',275,'19','1',1054825.51,1054825.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','14',276,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','14',277,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','14',278,'22','1',1393467.37,1393467.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','14',279,'23','1',1237357.99,1237357.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','14',280,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','15',281,'1','1',1811802.11,1811802.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','15',282,'2','1',1426388.72,1426388.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','15',283,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','15',284,'4','1',1381476.95,1381476.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','15',285,'9','2',1179610.61,1179610.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','15',286,'10','2',804700.26,804700.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','15',287,'11','3',427390.86,427390.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','15',288,'12','1',1728094.81,1728094.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','15',289,'13','1',1118092.39,1118092.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','15',290,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','15',291,'15','1',1245697.06,1245697.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','15',292,'16','1',1959105.11,1959105.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','15',293,'17','1',1239075.52,1239075.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','15',294,'18','1',907562.57,907562.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','15',295,'19','1',1054825.51,1054825.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','15',296,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','15',297,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','15',298,'22','1',1393467.37,1393467.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','15',299,'23','1',1237357.99,1237357.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','15',300,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','16',301,'1','1',1811802.11,1820909.91,9107.80,1502787.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','16',302,'2','1',1426388.72,1433595.25,7206.53,1189077.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','16',303,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','16',304,'4','1',1381476.95,1393124.09,11647.14,1921778.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','16',305,'9','2',1179610.61,1181327.10,1716.49,1201543.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','16',306,'10','2',804700.26,813232.25,8531.99,5972393.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','16',307,'11','3',427390.86,429720.71,2329.85,1281419.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','16',308,'12','1',1728094.81,1736989.98,8895.17,1467703.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','16',309,'13','1',1118092.39,1118095.42,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','16',310,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','16',311,'15','1',1245697.06,1254784.71,9087.65,1499462.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','16',312,'16','1',1959105.11,1966717.73,7612.62,1256082.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','16',313,'17','1',1239075.52,1242002.52,2927.00,482955.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','16',314,'18','1',907562.57,910649.91,3087.34,509411.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','16',315,'19','1',1054825.51,1061777.04,6951.53,1147002.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','16',316,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','16',317,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','16',318,'22','1',1393467.37,1400348.89,6881.52,1135450.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','16',319,'23','1',1237357.99,1237388.57,30.58,5045.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','16',320,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','17',321,'1','1',1820909.91,1825602.02,4692.11,774198.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','17',322,'2','1',1433595.25,1438773.42,5178.17,854398.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','17',323,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','17',324,'4','1',1393124.09,1399241.13,6117.04,1009311.60,0.00,0.00,0.00,0.00,0.00),('21','220','3','17',325,'9','2',1181327.10,1182703.23,1376.13,963291.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','17',326,'10','2',813232.25,821037.80,7805.55,5463885.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','17',327,'11','3',429720.71,431485.38,1764.67,970569.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','17',328,'12','1',1736989.98,1742367.15,5377.17,887233.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','17',329,'13','1',1118095.42,1118095.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','17',330,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','17',331,'15','1',1254784.71,1260157.92,5373.21,886579.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','17',332,'16','1',1966717.73,1971094.85,4377.12,722224.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','17',333,'17','1',1242002.52,1245611.66,3609.14,595508.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','17',334,'18','1',910649.91,912817.27,2167.36,357614.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','17',335,'19','1',1061777.04,1065762.67,3985.63,657628.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','17',336,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','17',337,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','17',338,'22','1',1400348.89,1405482.69,5133.80,847077.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','17',339,'23','1',1237388.57,1237388.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','17',340,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','18',341,'1','1',1825602.02,1831033.15,5431.13,896136.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','18',342,'2','1',1438773.42,1443641.46,4868.04,803226.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','18',343,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','18',344,'4','1',1399241.13,1406787.36,7546.23,1245127.95,0.00,0.00,0.00,0.00,0.00),('21','220','3','18',345,'9','2',1182703.23,1186724.91,4021.68,2815176.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','18',346,'10','2',821037.80,828069.51,7031.71,4922197.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','18',347,'11','3',431485.38,433087.60,1602.22,881219.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','18',348,'12','1',1742367.15,1748738.78,6371.63,1051318.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','18',349,'13','1',1118095.42,1118095.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','18',350,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','18',351,'15','1',1260157.92,1266954.07,6796.15,1121364.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','18',352,'16','1',1971094.85,1973941.49,2846.64,469695.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','18',353,'17','1',1245611.66,1249327.57,3715.91,613125.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','18',354,'18','1',912817.27,915424.77,2607.50,430237.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','18',355,'19','1',1065762.67,1068582.33,2819.66,465243.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','18',356,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','18',357,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','18',358,'22','1',1405482.69,1409125.40,3642.71,601047.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','18',359,'23','1',1237388.57,1237388.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','18',360,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','19',361,'1','1',1831033.15,1834601.75,3568.60,588819.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','19',362,'2','1',1443641.46,1446835.77,3194.31,527061.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','19',363,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','19',364,'4','1',1406787.36,1410843.58,4056.22,669276.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','19',365,'9','2',1186724.91,1189097.39,2372.48,1660736.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','19',366,'10','2',828069.51,831073.63,3004.12,2102884.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','19',367,'11','3',433087.60,434829.77,1742.17,958193.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','19',368,'12','1',1748738.78,1752502.69,3763.91,621045.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','19',369,'13','1',1118095.42,1118095.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','19',370,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','19',371,'15','1',1266954.07,1272881.53,5927.46,978030.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','19',372,'16','1',1973941.49,1981909.88,7968.39,1314784.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','19',373,'17','1',1249327.57,1255485.27,6157.70,1016020.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','19',374,'18','1',915424.77,921237.53,5812.76,959105.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','19',375,'19','1',1068582.33,1073388.95,4806.62,793092.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','19',376,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','19',377,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','19',378,'22','1',1409125.40,1416290.89,7165.49,1182305.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','19',379,'23','1',1237388.57,1242642.33,5253.76,866870.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','19',380,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','20',381,'1','1',1834601.75,1838342.73,3740.98,617261.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','20',382,'2','1',1446835.77,1450470.67,3634.90,599758.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','20',383,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','20',384,'4','1',1410843.58,1415853.73,5010.15,826674.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','20',385,'9','2',1189097.39,1190419.65,1322.26,925582.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','20',386,'10','2',831073.63,834393.79,3320.16,2324112.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','20',387,'11','3',434829.77,435535.66,705.89,388238.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','20',388,'12','1',1752502.69,1756151.59,3648.90,602068.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','20',389,'13','1',1118095.42,1118095.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','20',390,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','20',391,'15','1',1272881.53,1277033.12,4151.59,685012.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','20',392,'16','1',1981909.88,1988459.84,6549.96,1080743.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','20',393,'17','1',1255485.27,1257436.76,1951.49,321995.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','20',394,'18','1',921237.53,925145.56,3908.03,644824.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','20',395,'19','1',1073388.95,1077353.91,3964.96,654218.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','20',396,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','20',397,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','20',398,'22','1',1416290.89,1418513.67,2222.78,366758.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','20',399,'23','1',1242642.33,1247964.76,5322.43,878200.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','20',400,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','21',401,'1','1',1838342.73,1844164.76,5822.03,960634.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','21',402,'2','1',1450470.67,1455443.06,4972.39,820444.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','21',403,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','21',404,'4','1',1415853.73,1423035.96,7182.23,1185067.95,0.00,0.00,0.00,0.00,0.00),('21','220','3','21',405,'9','2',1190419.65,1192542.76,2123.11,1486177.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','21',406,'10','2',834393.79,838832.22,4438.43,3106901.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','21',407,'11','3',435535.66,437352.38,1816.72,999195.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','21',408,'12','1',1756151.59,1762292.01,6140.42,1013169.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','21',409,'13','1',1118095.42,1118095.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','21',410,'14','1',1256040.94,1256040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','21',411,'15','1',1277033.12,1282842.50,5809.38,958547.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','21',412,'16','1',1988459.84,1995672.78,7212.94,1190135.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','21',413,'17','1',1257436.76,1259258.58,1821.82,300600.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','21',414,'18','1',925145.56,929861.15,4715.59,778072.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','21',415,'19','1',1077353.91,1081270.21,3916.30,646189.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','21',416,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','21',417,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','21',418,'22','1',1418513.67,1423492.42,4978.75,821493.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','21',419,'23','1',1247964.76,1251475.31,3510.55,579240.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','21',420,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','22',421,'1','1',1844164.76,1851910.61,7745.85,1278065.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','22',422,'2','1',1455443.06,1462406.13,6963.07,1148906.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','22',423,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','22',424,'4','1',1423035.96,1423035.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','22',425,'9','2',1192542.76,1194697.29,2154.53,1508171.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','22',426,'10','2',838832.22,838832.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','22',427,'11','3',437352.38,439222.03,1869.65,1028308.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','22',428,'12','1',1762292.01,1768905.49,6613.48,1091224.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','22',429,'13','1',1118095.42,1118941.63,846.21,139624.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','22',430,'14','1',1256040.94,1256736.47,695.53,114762.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','22',431,'15','1',1282842.50,1289046.32,6203.82,1023630.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','22',432,'16','1',1995672.78,2002137.94,6465.16,1066751.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','22',433,'17','1',1259258.58,1260628.91,1370.33,226104.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','22',434,'18','1',929861.15,934106.00,4244.85,700400.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','22',435,'19','1',1081270.21,1085310.49,4040.28,666646.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','22',436,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','22',437,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','22',438,'22','1',1423492.42,1428556.90,5064.48,835639.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','22',439,'23','1',1251475.31,1253478.07,2002.76,330455.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','22',440,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','23',441,'1','1',1851910.61,1857590.36,5679.75,937158.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','23',442,'2','1',1462406.13,1468646.76,6240.63,1029703.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','23',443,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','23',444,'4','1',1423035.96,1437991.30,14955.34,2467631.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','23',445,'9','2',1194697.29,1194697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','23',446,'10','2',838832.22,839653.91,821.69,575183.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','23',447,'11','3',439222.03,440170.06,948.03,521415.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','23',448,'12','1',1768905.49,1775892.68,6987.19,1152886.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','23',449,'13','1',1118941.63,1118941.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','23',450,'14','1',1256736.47,1259453.12,2716.65,448247.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','23',451,'15','1',1289046.32,1292700.82,3654.50,602992.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','23',452,'16','1',2002137.94,2007955.88,5817.94,959960.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','23',453,'17','1',1260628.91,1265004.26,4375.35,721932.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','23',454,'18','1',934106.00,938534.13,4428.13,730641.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','23',455,'19','1',1085310.49,1090071.91,4761.42,785634.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','23',456,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','23',457,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','23',458,'22','1',1428556.90,1434601.92,6045.02,997428.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','23',459,'23','1',1253478.07,1256187.69,2709.62,447087.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','23',460,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','24',461,'1','1',1857590.36,1862588.18,4997.82,824640.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','24',462,'2','1',1468646.76,1473332.84,4686.08,773203.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','24',463,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','24',464,'4','1',1437991.30,1444788.43,6797.13,1121526.45,0.00,0.00,0.00,0.00,0.00),('21','220','3','24',465,'9','2',1194697.29,1194697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','24',466,'10','2',839653.91,846405.40,6751.49,4726043.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','24',467,'11','3',440170.06,441256.86,1086.80,597741.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','24',468,'12','1',1775892.68,1781472.72,5580.04,920706.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','24',469,'13','1',1118941.63,1118941.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','24',470,'14','1',1259453.12,1264916.54,5463.42,901464.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','24',471,'15','1',1292700.82,1296034.12,3333.30,549994.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','24',472,'16','1',2007955.88,2013341.75,5385.87,888668.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','24',473,'17','1',1265004.26,1265004.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','24',474,'18','1',938534.13,941375.30,2841.17,468793.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','24',475,'19','1',1090071.91,1094488.10,4416.19,728671.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','24',476,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','24',477,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','24',478,'22','1',1434601.92,1440809.89,6207.97,1024315.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','24',479,'23','1',1256187.69,1256693.79,506.10,83506.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','24',480,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','25',481,'1','1',1862588.18,1868470.52,5882.34,970586.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','25',482,'2','1',1473332.84,1477888.69,4555.85,751715.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','25',483,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','25',484,'4','1',1444788.43,1451777.31,6988.88,1153165.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','25',485,'9','2',1194697.29,1197185.23,2487.94,1741558.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','25',486,'10','2',846405.40,850956.93,4551.53,3186071.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','25',487,'11','3',441256.86,443459.99,2203.13,1211721.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','25',488,'12','1',1781472.72,1787559.32,6086.60,1004289.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','25',489,'13','1',1118941.63,1118941.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','25',490,'14','1',1264916.54,1268108.80,3192.26,526722.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','25',491,'15','1',1296034.12,1300751.87,4717.75,778428.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','25',492,'16','1',2013341.75,2020119.80,6778.05,1118378.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','25',493,'17','1',1265004.26,1266590.55,1586.29,261737.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','25',494,'18','1',941375.30,946146.97,4771.67,787325.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','25',495,'19','1',1094488.10,1098487.99,3999.89,659981.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','25',496,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','25',497,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','25',498,'22','1',1440809.89,1445451.60,4641.71,765882.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','25',499,'23','1',1256693.79,1256693.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','25',500,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','26',501,'1','1',1868470.52,1873719.07,5248.55,866010.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','26',502,'2','1',1477888.69,1481262.30,3373.61,556645.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','26',503,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','26',504,'4','1',1451777.31,1457956.31,6179.00,1019535.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','26',505,'9','2',1197185.23,1200248.67,3063.44,2144408.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','26',506,'10','2',850956.93,860986.63,10029.70,7020790.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','26',507,'11','3',443459.99,446285.73,2825.74,1554157.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','26',508,'12','1',1787559.32,1792214.33,4655.01,768076.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','26',509,'13','1',1118941.63,1118941.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','26',510,'14','1',1268108.80,1272223.54,4114.74,678932.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','26',511,'15','1',1300751.87,1304320.69,3568.82,588855.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','26',512,'16','1',2020119.80,2025692.97,5573.17,919573.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','26',513,'17','1',1266590.55,1270460.29,3869.74,638507.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','26',514,'18','1',946146.97,948558.77,2411.80,397947.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','26',515,'19','1',1098487.99,1102585.42,4097.43,676075.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','26',516,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','26',517,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','26',518,'22','1',1445451.60,1449724.36,4272.76,705005.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','26',519,'23','1',1256693.79,1256770.76,76.97,12700.05,0.00,0.00,0.00,0.00,0.00),('21','220','4','26',520,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','27',521,'1','1',1873719.07,1879509.16,5790.09,955364.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','27',522,'2','1',1481262.30,1486628.34,5366.04,885396.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','27',523,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','27',524,'4','1',1457956.31,1465800.65,7844.34,1294316.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','27',525,'9','2',1200248.67,1200248.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','27',526,'10','2',860986.63,862952.94,1966.31,1376417.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','27',527,'11','3',446285.73,447118.80,833.07,458187.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','27',528,'12','1',1792214.33,1797918.03,5703.70,941110.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','27',529,'13','1',1118941.63,1118941.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','27',530,'14','1',1272223.54,1276872.03,4648.49,767000.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','27',531,'15','1',1304320.69,1305928.64,1607.95,265311.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','27',532,'16','1',2025692.97,2031213.27,5520.30,910849.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','27',533,'17','1',1270460.29,1274103.79,3643.50,601177.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','27',534,'18','1',948558.77,952655.43,4096.66,675948.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','27',535,'19','1',1102585.42,1105156.17,2570.75,424173.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','27',536,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','27',537,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','27',538,'22','1',1449724.36,1454642.60,4918.24,811509.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','27',539,'23','1',1256770.76,1256770.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','27',540,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','28',541,'1','1',1879509.16,1883649.35,4140.19,683131.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','28',542,'2','1',1486628.34,1488660.45,2032.11,335298.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','28',543,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','28',544,'4','1',1465800.65,1469778.51,3977.86,656346.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','28',545,'9','2',1200248.67,1201497.63,1248.96,874272.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','28',546,'10','2',862952.94,868118.07,5165.13,3615591.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','28',547,'11','3',447118.80,449958.23,2839.43,1561687.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','28',548,'12','1',1797918.03,1802154.79,4236.76,699065.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','28',549,'13','1',1118941.63,1118941.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','28',550,'14','1',1276872.03,1280505.59,3633.56,599537.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','28',551,'15','1',1305928.64,1309441.98,3513.34,579701.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','28',552,'16','1',2031213.27,2038878.90,7665.63,1264828.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','28',553,'17','1',1274103.79,1279121.28,5017.49,827885.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','28',554,'18','1',952655.43,957924.62,5269.19,869416.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','28',555,'19','1',1105156.17,1110116.26,4960.09,818414.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','28',556,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','28',557,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','28',558,'22','1',1454642.60,1461691.12,7048.52,1163005.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','28',559,'23','1',1256770.76,1256770.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','28',560,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','29',561,'1','1',1883649.35,1888652.48,5003.13,825516.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','29',562,'2','1',1488660.45,1494570.85,5910.40,975216.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','29',563,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','29',564,'4','1',1469778.51,1476757.70,6979.19,1151566.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','29',565,'9','2',1201497.63,1203808.04,2310.41,1617287.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','29',566,'10','2',868118.07,874009.59,5891.52,4124064.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','29',567,'11','3',449958.23,453072.53,3114.30,1712862.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','29',568,'12','1',1802154.79,1807579.34,5424.55,895050.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','29',569,'13','1',1118941.63,1118941.94,0.31,51.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','29',570,'14','1',1280505.59,1285199.81,4694.22,774546.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','29',571,'15','1',1309441.98,1313732.90,4290.92,708001.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','29',572,'16','1',2038878.90,2043431.69,4552.79,751210.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','29',573,'17','1',1279121.28,1281270.28,2149.00,354585.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','29',574,'18','1',957924.62,961271.43,3346.81,552223.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','29',575,'19','1',1110116.26,1113461.82,3345.56,552017.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','29',576,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','29',577,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','29',578,'22','1',1461691.12,1465069.97,3378.85,557510.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','29',579,'23','1',1256770.76,1256770.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','29',580,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','30',581,'1','1',1888652.48,1894355.89,5703.41,941062.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','30',582,'2','1',1494570.85,1500038.86,5468.01,902221.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','30',583,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','30',584,'4','1',1476757.70,1483391.53,6633.83,1094581.95,0.00,0.00,0.00,0.00,0.00),('21','220','3','30',585,'9','2',1203808.04,1203833.76,25.72,18004.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','30',586,'10','2',874009.59,878593.40,4583.81,3208667.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','30',587,'11','3',453072.53,455720.56,2648.03,1456416.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','30',588,'12','1',1807579.34,1814289.22,6709.88,1107130.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','30',589,'13','1',1118941.94,1118941.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','30',590,'14','1',1285199.81,1290497.83,5298.02,874173.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','30',591,'15','1',1313732.90,1318388.22,4655.32,768127.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','30',592,'16','1',2043431.69,2045859.73,2428.04,400626.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','30',593,'17','1',1281270.28,1286015.53,4745.25,782966.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','30',594,'18','1',961271.43,964226.73,2955.30,487624.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','30',595,'19','1',1113461.82,1118159.88,4698.06,775179.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','30',596,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','30',597,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','30',598,'22','1',1465069.97,1469846.43,4776.46,788115.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','30',599,'23','1',1256770.76,1256770.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','30',600,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','31',601,'1','1',1894355.89,1900992.00,6636.11,1094958.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','31',602,'2','1',1500038.86,1505953.41,5914.55,975900.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','31',603,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','31',604,'4','1',1483391.53,1491918.15,8526.62,1406892.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','31',605,'9','2',1203833.76,1203833.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','31',606,'10','2',878593.40,883102.17,4508.77,3156139.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','31',607,'11','3',455720.56,456630.25,909.69,500329.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','31',608,'12','1',1814289.22,1820729.12,6439.90,1062583.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','31',609,'13','1',1118941.94,1118941.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','31',610,'14','1',1290497.83,1296262.41,5764.58,951155.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','31',611,'15','1',1318388.22,1324251.66,5863.44,967467.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','31',612,'16','1',2045859.73,2050637.97,4778.24,788409.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','31',613,'17','1',1286015.53,1289363.71,3348.18,552449.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','31',614,'18','1',964226.73,967189.31,2962.58,488825.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','31',615,'19','1',1118159.88,1120780.82,2620.94,432455.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','31',616,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','31',617,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','31',618,'22','1',1469846.43,1474489.09,4642.66,766038.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','31',619,'23','1',1256770.76,1256770.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','31',620,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','32',621,'1','1',1900992.00,1905717.35,4725.35,779682.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','32',622,'2','1',1505953.41,1509618.86,3665.45,604799.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','32',623,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','32',624,'4','1',1491918.15,1497994.26,6076.11,1002558.15,0.00,0.00,0.00,0.00,0.00),('21','220','3','32',625,'9','2',1203833.76,1203833.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','32',626,'10','2',883102.17,887832.33,4730.16,3311112.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','32',627,'11','3',456630.25,459646.42,3016.17,1658894.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','32',628,'12','1',1820729.12,1825782.55,5053.43,833815.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','32',629,'13','1',1118941.94,1118941.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','32',630,'14','1',1296262.41,1300615.06,4352.65,718187.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','32',631,'15','1',1324251.66,1327178.86,2927.20,482988.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','32',632,'16','1',2050637.97,2052697.81,2059.84,339873.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','32',633,'17','1',1289363.71,1291340.75,1977.04,326211.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','32',634,'18','1',967189.31,969967.37,2778.06,458379.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','32',635,'19','1',1120780.82,1121976.67,1195.85,197315.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','32',636,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','32',637,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','32',638,'22','1',1474489.09,1477940.08,3450.99,569413.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','32',639,'23','1',1256770.76,1256770.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','32',640,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','33',641,'1','1',1905717.35,1910680.28,4962.93,818883.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','33',642,'2','1',1509618.86,1513961.44,4342.58,716525.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','33',643,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','33',644,'4','1',1497994.26,1503730.44,5736.18,946469.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','33',645,'9','2',1203833.76,1203833.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','33',646,'10','2',887832.33,891653.13,3820.80,2674560.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','33',647,'11','3',459646.42,461488.93,1842.51,1013379.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','33',648,'12','1',1825782.55,1831048.77,5266.22,868926.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','33',649,'13','1',1118941.94,1120793.30,1851.36,305474.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','33',650,'14','1',1300615.06,1305557.54,4942.48,815509.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','33',651,'15','1',1327178.86,1331525.05,4346.19,717121.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','33',652,'16','1',2052697.81,2058639.82,5942.01,980431.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','33',653,'17','1',1291340.75,1293246.61,1905.86,314466.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','33',654,'18','1',969967.37,972091.61,2124.24,350499.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','33',655,'19','1',1121976.67,1125418.03,3441.36,567824.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','33',656,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','33',657,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','33',658,'22','1',1477940.08,1480843.06,2902.98,478991.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','33',659,'23','1',1256770.76,1257268.20,497.44,82077.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','33',660,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','34',661,'1','1',1910680.28,1913410.60,2730.32,450502.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','34',662,'2','1',1513961.44,1513961.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','34',663,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','34',664,'4','1',1503730.44,1508389.94,4659.50,768817.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','34',665,'9','2',1203833.76,1203833.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','34',666,'10','2',891653.13,894512.25,2859.12,2001384.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','34',667,'11','3',461488.93,462558.69,1069.76,588366.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','34',668,'12','1',1831048.77,1831048.86,0.09,14.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','34',669,'13','1',1120793.30,1124940.77,4147.47,684332.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','34',670,'14','1',1305557.54,1309357.71,3800.17,627028.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','34',671,'15','1',1331525.05,1334295.89,2770.84,457188.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','34',672,'16','1',2058639.82,2061967.13,3327.31,549006.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','34',673,'17','1',1293246.61,1296867.37,3620.76,597425.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','34',674,'18','1',972091.61,974024.06,1932.45,318854.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','34',675,'19','1',1125418.03,1128478.23,3060.20,504933.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','34',676,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','34',677,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','34',678,'22','1',1480843.06,1483654.96,2811.90,463963.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','34',679,'23','1',1257268.20,1260158.01,2889.81,476818.65,0.00,0.00,0.00,0.00,0.00),('21','220','4','34',680,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','35',681,'1','1',1913410.60,1919994.65,6584.05,1086368.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','35',682,'2','1',1513961.44,1523657.85,9696.41,1599907.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','35',683,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','35',684,'4','1',1508389.94,1515566.86,7176.92,1184191.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','35',685,'9','2',1203833.76,1207367.94,3534.18,2473926.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','35',686,'10','2',894512.25,901464.22,6951.97,4866379.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','35',687,'11','3',462558.69,465453.50,2894.81,1592142.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','35',688,'12','1',1831048.86,1831976.04,927.18,152984.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','35',689,'13','1',1124940.77,1131653.03,6712.26,1107522.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','35',690,'14','1',1309357.71,1314434.55,5076.84,837678.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','35',691,'15','1',1334295.89,1339176.15,4880.26,805242.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','35',692,'16','1',2061967.13,2064386.87,2419.74,399257.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','35',693,'17','1',1296867.37,1300122.56,3255.19,537106.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','35',694,'18','1',974024.06,976995.48,2971.42,490284.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','35',695,'19','1',1128478.23,1130881.27,2403.04,396501.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','35',696,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','35',697,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','35',698,'22','1',1483654.96,1487348.64,3693.68,609457.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','35',699,'23','1',1260158.01,1262915.29,2757.28,454951.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','35',700,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','36',701,'1','1',1919994.65,1927197.51,7202.86,1188471.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','36',702,'2','1',1523657.85,1529430.46,5772.61,952480.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','36',703,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','36',704,'4','1',1515566.86,1524294.94,8728.08,1440133.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','36',705,'9','2',1207367.94,1207367.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','36',706,'10','2',901464.22,907107.83,5643.61,3950527.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','36',707,'11','3',465453.50,467121.78,1668.28,917556.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','36',708,'12','1',1831976.04,1838737.53,6761.49,1115645.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','36',709,'13','1',1131653.03,1136239.88,4586.85,756830.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','36',710,'14','1',1314434.55,1320010.56,5576.01,920041.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','36',711,'15','1',1339176.15,1344560.69,5384.54,888449.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','36',712,'16','1',2064386.87,2070736.72,6349.85,1047725.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','36',713,'17','1',1300122.56,1303984.18,3861.62,637167.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','36',714,'18','1',976995.48,981992.28,4996.80,824472.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','36',715,'19','1',1130881.27,1132861.64,1980.37,326761.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','36',716,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','36',717,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','36',718,'22','1',1487348.64,1493044.62,5695.98,939836.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','36',719,'23','1',1262915.29,1266320.83,3405.54,561914.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','36',720,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','37',721,'1','1',1927197.51,1933808.17,6610.66,1090758.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','37',722,'2','1',1529430.46,1535393.79,5963.33,983949.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','37',723,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','37',724,'4','1',1524294.94,1531259.75,6964.81,1149193.65,0.00,0.00,0.00,0.00,0.00),('21','220','3','37',725,'9','2',1207367.94,1207367.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','37',726,'10','2',907107.83,907322.11,214.28,149996.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','37',727,'11','3',467121.78,471662.15,4540.37,2497203.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','37',728,'12','1',1838737.53,1844786.50,6048.97,998080.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','37',729,'13','1',1136239.88,1140294.70,4054.82,669045.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','37',730,'14','1',1320010.56,1325139.51,5128.95,846276.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','37',731,'15','1',1344560.69,1349773.70,5213.01,860146.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','37',732,'16','1',2070736.72,2075160.46,4423.74,729917.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','37',733,'17','1',1303984.18,1308946.54,4962.36,818789.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','37',734,'18','1',981992.28,986546.14,4553.86,751386.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','37',735,'19','1',1132861.64,1135774.27,2912.63,480583.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','37',736,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','37',737,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','37',738,'22','1',1493044.62,1497382.08,4337.46,715680.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','37',739,'23','1',1266320.83,1269416.32,3095.49,510755.85,0.00,0.00,0.00,0.00,0.00),('21','220','4','37',740,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','38',741,'1','1',1933808.17,1941269.79,7461.62,1231167.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','38',742,'2','1',1535393.79,1541529.83,6136.04,1012446.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','38',743,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','38',744,'4','1',1531259.75,1538835.44,7575.69,1249988.85,0.00,0.00,0.00,0.00,0.00),('21','220','3','38',745,'9','2',1207367.94,1207367.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','38',746,'10','2',907322.11,908712.68,1390.57,973399.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','38',747,'11','3',471662.15,473691.88,2029.73,1116349.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','38',748,'12','1',1844786.50,1844786.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','38',749,'13','1',1140294.70,1144613.19,4318.49,712550.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','38',750,'14','1',1325139.51,1331649.95,6510.44,1074222.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','38',751,'15','1',1349773.70,1353808.91,4035.21,665809.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','38',752,'16','1',2075160.46,2081677.69,6517.23,1075342.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','38',753,'17','1',1308946.54,1313165.11,4218.57,696064.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','38',754,'18','1',986546.14,991234.23,4688.09,773534.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','38',755,'19','1',1135774.27,1140543.39,4769.12,786904.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','38',756,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','38',757,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','38',758,'22','1',1497382.08,1500334.68,2952.60,487179.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','38',759,'23','1',1269416.32,1272613.43,3197.11,527523.15,0.00,0.00,0.00,0.00,0.00),('21','220','4','38',760,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','39',761,'1','1',1941269.79,1946956.10,5686.31,938241.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','39',762,'2','1',1541529.83,1547929.53,6399.70,1055950.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','39',763,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','39',764,'4','1',1538835.44,1538835.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','39',765,'9','2',1207367.94,1208892.86,1524.92,1067444.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','39',766,'10','2',908712.68,911869.01,3156.33,2209431.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','39',767,'11','3',473691.88,475093.00,1401.12,770614.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','39',768,'12','1',1844786.50,1856685.38,11898.88,1963315.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','39',769,'13','1',1144613.19,1147850.65,3237.46,534180.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','39',770,'14','1',1331649.95,1335918.78,4268.83,704356.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','39',771,'15','1',1353808.91,1358067.47,4258.56,702662.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','39',772,'16','1',2081677.69,2089204.26,7526.57,1241884.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','39',773,'17','1',1313165.11,1317539.32,4374.21,721744.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','39',774,'18','1',991234.23,995289.76,4055.53,669162.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','39',775,'19','1',1140543.39,1145702.04,5158.65,851177.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','39',776,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','39',777,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','39',778,'22','1',1500334.68,1506325.79,5991.11,988533.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','39',779,'23','1',1272613.43,1275646.12,3032.69,500393.85,0.00,0.00,0.00,0.00,0.00),('21','220','4','39',780,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','40',781,'1','1',1946956.10,1950971.98,4015.88,662620.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','40',782,'2','1',1547929.53,1551795.20,3865.67,637835.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','40',783,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','40',784,'4','1',1538835.44,1552020.58,13185.14,2175548.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','40',785,'9','2',1208892.86,1208892.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','40',786,'10','2',911869.01,915071.46,3202.45,2241715.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','40',787,'11','3',475093.00,477742.84,2649.84,1457410.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','40',788,'12','1',1856685.38,1861568.97,4883.59,805792.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','40',789,'13','1',1147850.65,1150919.60,3068.95,506376.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','40',790,'14','1',1335918.78,1339235.80,3317.02,547308.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','40',791,'15','1',1358067.47,1361610.32,3542.85,584570.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','40',792,'16','1',2089204.26,2093046.97,3842.71,634047.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','40',793,'17','1',1317539.32,1319205.10,1665.78,274853.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','40',794,'18','1',995289.76,998211.55,2921.79,482095.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','40',795,'19','1',1145702.04,1147967.13,2265.09,373739.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','40',796,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','40',797,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','40',798,'22','1',1506325.79,1509720.39,3394.60,560109.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','40',799,'23','1',1275646.12,1278038.69,2392.57,394774.05,0.00,0.00,0.00,0.00,0.00),('21','220','4','40',800,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','41',801,'1','1',1950971.98,1954532.20,3560.22,587436.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','41',802,'2','1',1551795.20,1556510.23,4715.03,777979.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','41',803,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','41',804,'4','1',1552020.58,1556287.57,4266.99,704053.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','41',805,'9','2',1208892.86,1212642.95,3750.09,2625063.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','41',806,'10','2',915071.46,916351.51,1280.05,896035.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','41',807,'11','3',477742.84,478667.89,925.05,508779.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','41',808,'12','1',1861568.97,1866273.59,4704.62,776262.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','41',809,'13','1',1150919.60,1154234.63,3315.03,546979.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','41',810,'14','1',1339235.80,1342952.70,3716.90,613288.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','41',811,'15','1',1361610.32,1365026.48,3416.16,563666.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','41',812,'16','1',2093046.97,2095942.37,2895.40,477741.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','41',813,'17','1',1319205.10,1321407.13,2202.03,363334.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','41',814,'18','1',998211.55,1000370.11,2158.56,356162.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','41',815,'19','1',1147967.13,1150513.51,2546.38,420152.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','41',816,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','41',817,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','41',818,'22','1',1509720.39,1512702.47,2982.08,492043.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','41',819,'23','1',1278038.69,1280309.23,2270.54,374639.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','41',820,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','42',821,'1','1',1954532.20,1959223.13,4690.93,774003.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','42',822,'2','1',1556510.23,1561929.72,5419.49,894215.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','42',823,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','42',824,'4','1',1556287.57,1563859.20,7571.63,1249318.95,0.00,0.00,0.00,0.00,0.00),('21','220','3','42',825,'9','2',1212642.95,1212642.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','42',826,'10','2',916351.51,917851.61,1500.10,1050070.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','42',827,'11','3',478667.89,480979.01,2311.12,1271116.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','42',828,'12','1',1866273.59,1873052.98,6779.39,1118599.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','42',829,'13','1',1154234.63,1159345.96,5111.33,843369.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','42',830,'14','1',1342952.70,1349613.83,6661.13,1099086.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','42',831,'15','1',1365026.48,1370224.82,5198.34,857726.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','42',832,'16','1',2095942.37,2100643.37,4701.00,775665.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','42',833,'17','1',1321407.13,1325765.07,4357.94,719060.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','42',834,'18','1',1000370.11,1004195.56,3825.45,631199.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','42',835,'19','1',1150513.51,1153117.69,2604.18,429689.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','42',836,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','42',837,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','42',838,'22','1',1512702.47,1517263.85,4561.38,752627.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','42',839,'23','1',1280309.23,1284232.59,3923.36,647354.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','42',840,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','43',841,'1','1',1959223.13,1965984.93,6761.80,1115697.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','43',842,'2','1',1561929.72,1565844.28,3914.56,645902.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','43',843,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','43',844,'4','1',1563859.20,1572605.43,8746.23,1443127.95,0.00,0.00,0.00,0.00,0.00),('21','220','3','43',845,'9','2',1212642.95,1213408.24,765.29,535703.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','43',846,'10','2',917851.61,920202.02,2350.41,1645287.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','43',847,'11','3',480979.01,483553.91,2574.90,1416195.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','43',848,'12','1',1873052.98,1878972.94,5919.96,976793.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','43',849,'13','1',1159345.96,1164102.11,4756.15,784764.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','43',850,'14','1',1349613.83,1354512.01,4898.18,808199.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','43',851,'15','1',1370224.82,1376253.31,6028.49,994700.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','43',852,'16','1',2100643.37,2105564.36,4920.99,811963.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','43',853,'17','1',1325765.07,1328417.20,2652.13,437601.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','43',854,'18','1',1004195.56,1008015.35,3819.79,630265.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','43',855,'19','1',1153117.69,1156535.11,3417.42,563874.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','43',856,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','43',857,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','43',858,'22','1',1517263.85,1521246.58,3982.73,657150.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','43',859,'23','1',1284232.59,1287427.33,3194.74,527132.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','43',860,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','44',861,'1','1',1965984.93,1965984.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','44',862,'2','1',1565844.28,1565844.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','44',863,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','44',864,'4','1',1572605.43,1572605.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','44',865,'9','2',1213408.24,1213408.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','44',866,'10','2',920202.02,920202.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','44',867,'11','3',483553.91,483553.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','44',868,'12','1',1878972.94,1878972.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','44',869,'13','1',1164102.11,1164102.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','44',870,'14','1',1354512.01,1354512.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','44',871,'15','1',1376253.31,1376253.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','44',872,'16','1',2105564.36,2105564.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','44',873,'17','1',1328417.20,1328417.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','44',874,'18','1',1008015.35,1008015.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','44',875,'19','1',1156535.11,1156535.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','44',876,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','44',877,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','44',878,'22','1',1521246.58,1521246.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','44',879,'23','1',1287427.33,1287427.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','44',880,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','45',881,'1','1',1965984.93,1970060.56,4075.63,672478.13,0.00,0.00,0.00,0.00,0.00),('21','220','1','45',882,'2','1',1565844.28,1570494.75,4650.47,767327.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','45',883,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','45',884,'4','1',1572605.43,1579329.05,6723.62,1109397.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','45',885,'9','2',1213408.24,1213408.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','45',886,'10','2',920202.02,924824.39,4622.37,3235659.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','45',887,'11','3',483553.91,485939.19,2385.28,1311904.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','45',888,'12','1',1878972.94,1882651.12,3678.18,606899.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','45',889,'13','1',1164102.11,1168397.79,4295.68,708787.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','45',890,'14','1',1354512.01,1359750.44,5238.43,864340.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','45',891,'15','1',1376253.31,1381203.70,4950.39,816814.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','45',892,'16','1',2105564.36,2112268.84,6704.48,1106239.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','45',893,'17','1',1328417.20,1331113.66,2696.46,444915.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','45',894,'18','1',1008015.35,1011597.73,3582.38,591092.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','45',895,'19','1',1156535.11,1160763.55,4228.44,697692.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','45',896,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','45',897,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','45',898,'22','1',1521246.58,1525704.08,4457.50,735487.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','45',899,'23','1',1287427.33,1290765.37,3338.04,550776.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','45',900,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','46',901,'1','1',1970060.56,1975558.74,5498.18,907199.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','46',902,'2','1',1570494.75,1575220.41,4725.66,779733.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','46',903,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','46',904,'4','1',1579329.05,1586664.96,7335.91,1210425.15,0.00,0.00,0.00,0.00,0.00),('21','220','3','46',905,'9','2',1213408.24,1215491.30,2083.06,1458142.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','46',906,'10','2',924824.39,927842.14,3017.75,2112425.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','46',907,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','46',908,'12','1',1882651.12,1882651.34,0.22,36.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','46',909,'13','1',1168397.79,1175860.62,7462.83,1231366.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','46',910,'14','1',1359750.44,1365029.38,5278.94,871025.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','46',911,'15','1',1381203.70,1386986.67,5782.97,954190.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','46',912,'16','1',2112268.84,2117276.82,5007.98,826316.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','46',913,'17','1',1331113.66,1335249.29,4135.63,682378.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','46',914,'18','1',1011597.73,1014682.14,3084.41,508927.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','46',915,'19','1',1160763.55,1163199.39,2435.84,401913.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','46',916,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','46',917,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','46',918,'22','1',1525704.08,1529560.08,3856.00,636240.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','46',919,'23','1',1290765.37,1294217.92,3452.55,569670.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','46',920,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','47',921,'1','1',1975558.74,1979761.36,4202.62,693432.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','47',922,'2','1',1575220.41,1580056.89,4836.48,798019.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','47',923,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','47',924,'4','1',1586664.96,1591891.01,5226.05,862298.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','47',925,'9','2',1215491.30,1215491.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','47',926,'10','2',927842.14,928170.74,328.60,230020.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','47',927,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','47',928,'12','1',1882651.34,1882651.55,0.21,34.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','47',929,'13','1',1175860.62,1180702.98,4842.36,798989.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','47',930,'14','1',1365029.38,1369062.88,4033.50,665527.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','47',931,'15','1',1386986.67,1390664.94,3678.27,606914.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','47',932,'16','1',2117276.82,2121653.04,4376.22,722076.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','47',933,'17','1',1335249.29,1338512.72,3263.43,538465.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','47',934,'18','1',1014682.14,1017106.70,2424.56,400052.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','47',935,'19','1',1163199.39,1165690.17,2490.78,410978.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','47',936,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','47',937,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','47',938,'22','1',1529560.08,1532486.08,2926.00,482790.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','47',939,'23','1',1294217.92,1297489.37,3271.45,539789.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','47',940,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','48',941,'1','1',1979761.36,1984308.41,4547.05,750263.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','48',942,'2','1',1580056.89,1584803.78,4746.89,783236.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','48',943,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','48',944,'4','1',1591891.01,1598927.38,7036.37,1161001.05,0.00,0.00,0.00,0.00,0.00),('21','220','3','48',945,'9','2',1215491.30,1215491.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','48',946,'10','2',928170.74,928170.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','48',947,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','48',948,'12','1',1882651.55,1882651.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','48',949,'13','1',1180702.98,1186936.29,6233.31,1028496.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','48',950,'14','1',1369062.88,1373087.97,4025.09,664139.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','48',951,'15','1',1390664.94,1394348.29,3683.35,607752.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','48',952,'16','1',2121653.04,2124007.72,2354.68,388522.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','48',953,'17','1',1338512.72,1342311.52,3798.80,626802.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','48',954,'18','1',1017106.70,1019655.82,2549.12,420604.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','48',955,'19','1',1165690.17,1167438.44,1748.27,288464.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','48',956,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','48',957,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','48',958,'22','1',1532486.08,1535408.86,2922.78,482258.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','48',959,'23','1',1297489.37,1298754.04,1264.67,208670.55,0.00,0.00,0.00,0.00,0.00),('21','220','4','48',960,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','49',961,'1','1',1984308.41,1987343.15,3034.74,500732.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','49',962,'2','1',1584803.78,1587235.31,2431.53,401202.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','49',963,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','49',964,'4','1',1598927.38,1604205.65,5278.27,870914.55,0.00,0.00,0.00,0.00,0.00),('21','220','3','49',965,'9','2',1215491.30,1215491.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','49',966,'10','2',928170.74,928321.46,150.72,105504.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','49',967,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','49',968,'12','1',1882651.55,1882651.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','49',969,'13','1',1186936.29,1190716.11,3779.82,623670.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','49',970,'14','1',1373087.97,1375336.10,2248.13,370941.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','49',971,'15','1',1394348.29,1397592.77,3244.48,535339.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','49',972,'16','1',2124007.72,2128182.82,4175.10,688891.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','49',973,'17','1',1342311.52,1346551.20,4239.68,699547.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','49',974,'18','1',1019655.82,1024141.45,4485.63,740128.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','49',975,'19','1',1167438.44,1170574.71,3136.27,517484.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','49',976,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','49',977,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','49',978,'22','1',1535408.86,1538435.10,3026.24,499329.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','49',979,'23','1',1298754.04,1301627.67,2873.63,474148.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','49',980,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','50',981,'1','1',1987343.15,1990459.78,3116.63,514243.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','50',982,'2','1',1587235.31,1590656.77,3421.46,564540.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','50',983,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','50',984,'4','1',1604205.65,1609960.11,5754.46,949485.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','50',985,'9','2',1215491.30,1218491.30,3000.00,2100000.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','50',986,'10','2',928321.46,929793.15,1471.69,1030183.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','50',987,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','50',988,'12','1',1882651.55,1882651.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','50',989,'13','1',1190716.11,1196777.95,6061.84,1000203.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','50',990,'14','1',1375336.10,1379966.94,4630.84,764088.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','50',991,'15','1',1397592.77,1397592.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','50',992,'16','1',2128182.82,2133134.80,4951.98,817076.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','50',993,'17','1',1346551.20,1346551.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','50',994,'18','1',1024141.45,1025709.28,1567.83,258691.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','50',995,'19','1',1170574.71,1173244.44,2669.73,440505.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','50',996,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','50',997,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','50',998,'22','1',1538435.10,1541203.08,2767.98,456716.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','50',999,'23','1',1301627.67,1301630.70,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','50',1000,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','51',1001,'1','1',1990459.78,1990459.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','51',1002,'2','1',1590656.77,1592794.10,2137.33,352659.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','51',1003,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','51',1004,'4','1',1609960.11,1611661.72,1701.61,280765.65,0.00,0.00,0.00,0.00,0.00),('21','220','3','51',1005,'9','2',1218491.30,1218898.72,407.42,285194.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','51',1006,'10','2',929793.15,931176.25,1383.10,968170.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','51',1007,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','51',1008,'12','1',1882651.55,1882651.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','51',1009,'13','1',1196777.95,1198637.79,1859.84,306873.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','51',1010,'14','1',1379966.94,1380585.93,618.99,102133.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','51',1011,'15','1',1397592.77,1399167.98,1575.21,259909.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','51',1012,'16','1',2133134.80,2133134.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','51',1013,'17','1',1346551.20,1346551.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','51',1014,'18','1',1025709.28,1025709.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','51',1015,'19','1',1173244.44,1173244.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','51',1016,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','51',1017,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','51',1018,'22','1',1541203.08,1541203.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','51',1019,'23','1',1301630.70,1301630.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','51',1020,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','52',1021,'1','1',1990459.78,1996989.17,6529.39,1077349.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','52',1022,'2','1',1592794.10,1596793.10,3999.00,659835.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','52',1023,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','52',1024,'4','1',1611661.72,1619455.38,7793.66,1285953.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','52',1025,'9','2',1218898.72,1218898.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','52',1026,'10','2',931176.25,934849.22,3672.97,2571079.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','52',1027,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','52',1028,'12','1',1882651.55,1885654.18,3002.63,495433.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','52',1029,'13','1',1198637.79,1202754.98,4117.19,679336.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','52',1030,'14','1',1380585.93,1386417.97,5832.04,962286.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','52',1031,'15','1',1399167.98,1404313.37,5145.39,848989.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','52',1032,'16','1',2133134.80,2136313.29,3178.49,524450.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','52',1033,'17','1',1346551.20,1351254.11,4702.91,775980.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','52',1034,'18','1',1025709.28,1025709.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','52',1035,'19','1',1173244.44,1178730.62,5486.18,905219.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','52',1036,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','52',1037,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','52',1038,'22','1',1541203.08,1543743.20,2540.12,419119.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','52',1039,'23','1',1301630.70,1304712.95,3082.25,508571.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','52',1040,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','53',1041,'1','1',1996989.17,2000241.06,3251.89,536561.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','53',1042,'2','1',1596793.10,1601263.72,4470.62,737652.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','53',1043,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','53',1044,'4','1',1619455.38,1626728.49,7273.11,1200063.15,0.00,0.00,0.00,0.00,0.00),('21','220','3','53',1045,'9','2',1218898.72,1218924.44,25.72,18004.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','53',1046,'10','2',934849.22,940439.25,5590.03,3913021.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','53',1047,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','53',1048,'12','1',1885654.18,1891819.09,6164.91,1017210.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','53',1049,'13','1',1202754.98,1205886.46,3131.48,516694.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','53',1050,'14','1',1386417.97,1393580.39,7162.42,1181799.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','53',1051,'15','1',1404313.37,1408336.76,4023.39,663859.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','53',1052,'16','1',2136313.29,2142001.21,5687.92,938506.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','53',1053,'17','1',1351254.11,1353699.56,2445.45,403499.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','53',1054,'18','1',1025709.28,1030702.22,4992.94,823835.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','53',1055,'19','1',1178730.62,1181289.50,2558.88,422215.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','53',1056,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','53',1057,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','53',1058,'22','1',1543743.20,1548890.35,5147.15,849279.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','53',1059,'23','1',1304712.95,1307121.48,2408.53,397407.45,0.00,0.00,0.00,0.00,0.00),('21','220','4','53',1060,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','54',1061,'1','1',2000241.06,2003423.08,3182.02,525033.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','54',1062,'2','1',1601263.72,1605143.61,3879.89,640181.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','54',1063,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','54',1064,'4','1',1626728.49,1630935.54,4207.05,694163.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','54',1065,'9','2',1218924.44,1220452.74,1528.30,1069810.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','54',1066,'10','2',940439.25,942861.74,2422.49,1695743.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','54',1067,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','54',1068,'12','1',1891819.09,1895897.02,4077.93,672858.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','54',1069,'13','1',1205886.46,1208449.55,2563.09,422909.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','54',1070,'14','1',1393580.39,1397265.43,3685.04,608031.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','54',1071,'15','1',1408336.76,1411219.23,2882.47,475607.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','54',1072,'16','1',2142001.21,2147470.04,5468.83,902356.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','54',1073,'17','1',1353699.56,1358461.05,4761.49,785645.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','54',1074,'18','1',1030702.22,1034181.60,3479.38,574097.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','54',1075,'19','1',1181289.50,1185309.29,4019.79,663265.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','54',1076,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','54',1077,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','54',1078,'22','1',1548890.35,1552310.79,3420.44,564372.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','54',1079,'23','1',1307121.48,1311683.07,4561.59,752662.35,0.00,0.00,0.00,0.00,0.00),('21','220','4','54',1080,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','55',1081,'1','1',2003423.08,2009625.31,6202.23,1023367.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','55',1082,'2','1',1605143.61,1610142.58,4998.97,824830.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','55',1083,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','55',1084,'4','1',1630935.54,1638178.81,7243.27,1195139.55,0.00,0.00,0.00,0.00,0.00),('21','220','3','55',1085,'9','2',1220452.74,1220853.42,400.68,280476.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','55',1086,'10','2',942861.74,948164.38,5302.64,3711848.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','55',1087,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','55',1088,'12','1',1895897.02,1900750.48,4853.46,800820.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','55',1089,'13','1',1208449.55,1213405.77,4956.22,817776.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','55',1090,'14','1',1397265.43,1402583.67,5318.24,877509.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','55',1091,'15','1',1411219.23,1416366.42,5147.19,849286.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','55',1092,'16','1',2147470.04,2151314.08,3844.04,634266.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','55',1093,'17','1',1358461.05,1361089.26,2628.21,433654.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','55',1094,'18','1',1034181.60,1036483.44,2301.84,379803.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','55',1095,'19','1',1185309.29,1188250.94,2941.65,485372.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','55',1096,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','55',1097,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','55',1098,'22','1',1552310.79,1555629.05,3318.26,547512.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','55',1099,'23','1',1311683.07,1313921.04,2237.97,369265.05,0.00,0.00,0.00,0.00,0.00),('21','220','4','55',1100,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','56',1101,'1','1',2009625.31,2009824.81,199.50,32917.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','56',1102,'2','1',1610142.58,1612550.48,2407.90,397303.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','56',1103,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','56',1104,'4','1',1638178.81,1640376.43,2197.62,362607.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','56',1105,'9','2',1220853.42,1220853.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','56',1106,'10','2',948164.38,950888.59,2724.21,1906947.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','56',1107,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','56',1108,'12','1',1900750.48,1902928.62,2178.14,359393.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','56',1109,'13','1',1213405.77,1214932.71,1526.94,251945.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','56',1110,'14','1',1402583.67,1404727.52,2143.85,353735.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','56',1111,'15','1',1416366.42,1418252.12,1885.70,311140.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','56',1112,'16','1',2151314.08,2155497.75,4183.67,690305.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','56',1113,'17','1',1361089.26,1364425.31,3336.05,550448.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','56',1114,'18','1',1036483.44,1040382.86,3899.42,643404.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','56',1115,'19','1',1188250.94,1188577.59,326.65,53897.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','56',1116,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','56',1117,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','56',1118,'22','1',1555629.05,1559650.34,4021.29,663512.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','56',1119,'23','1',1313921.04,1317710.63,3789.59,625282.35,0.00,0.00,0.00,0.00,0.00),('21','220','4','56',1120,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','57',1121,'1','1',2009824.81,2014267.71,4442.90,733078.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','57',1122,'2','1',1612550.48,1617111.28,4560.80,752532.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','57',1123,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','57',1124,'4','1',1640376.43,1646518.67,6142.24,1013469.60,0.00,0.00,0.00,0.00,0.00),('21','220','3','57',1125,'9','2',1220853.42,1220853.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','57',1126,'10','2',950888.59,956279.54,5390.95,3773665.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','57',1127,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','57',1128,'12','1',1902928.62,1906740.83,3812.21,629014.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','57',1129,'13','1',1214932.71,1217984.67,3051.96,503573.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','57',1130,'14','1',1404727.52,1408790.19,4062.67,670340.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','57',1131,'15','1',1418252.12,1422172.40,3920.28,646846.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','57',1132,'16','1',2155497.75,2158884.46,3386.71,558807.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','57',1133,'17','1',1364425.31,1366478.68,2053.37,338806.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','57',1134,'18','1',1040382.86,1042791.60,2408.74,397442.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','57',1135,'19','1',1188577.59,1190691.99,2114.40,348876.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','57',1136,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','57',1137,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','57',1138,'22','1',1559650.34,1562243.49,2593.15,427869.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','57',1139,'23','1',1317710.63,1320101.28,2390.65,394457.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','57',1140,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','58',1141,'1','1',2014267.71,2018362.70,4094.99,675673.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','58',1142,'2','1',1617111.28,1621837.34,4726.06,779799.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','58',1143,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','58',1144,'4','1',1646518.67,1652987.57,6468.90,1067368.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','58',1145,'9','2',1220853.42,1220853.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','58',1146,'10','2',956279.54,958743.04,2463.50,1724450.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','58',1147,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','58',1148,'12','1',1906740.83,1911376.99,4636.16,764966.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','58',1149,'13','1',1217984.67,1222075.76,4091.09,675029.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','58',1150,'14','1',1408790.19,1413275.63,4485.44,740097.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','58',1151,'15','1',1422172.40,1425352.80,3180.40,524766.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','58',1152,'16','1',2158884.46,2162528.94,3644.48,601339.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','58',1153,'17','1',1366478.68,1368135.28,1656.60,273339.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','58',1154,'18','1',1042791.60,1044505.57,1713.97,282805.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','58',1155,'19','1',1190691.99,1193474.04,2782.05,459038.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','58',1156,'20','1',1566711.59,1566711.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','58',1157,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','58',1158,'22','1',1562243.49,1565552.89,3309.40,546051.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','58',1159,'23','1',1320101.28,1321781.32,1680.04,277206.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','58',1160,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','59',1161,'1','1',2018362.70,2018362.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','59',1162,'2','1',1621837.34,1630220.75,8383.41,1383262.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','59',1163,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','59',1164,'4','1',1652987.57,1662687.18,9699.61,1600435.65,0.00,0.00,0.00,0.00,0.00),('21','220','3','59',1165,'9','2',1220853.42,1220853.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','59',1166,'10','2',958743.04,962998.28,4255.24,2978668.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','59',1167,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','59',1168,'12','1',1911376.99,1918223.15,6846.16,1129616.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','59',1169,'13','1',1222075.76,1227691.02,5615.26,926517.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','59',1170,'14','1',1413275.63,1417604.28,4328.65,714227.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','59',1171,'15','1',1425352.80,1430289.42,4936.62,814542.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','59',1172,'16','1',2162528.94,2165602.32,3073.38,507107.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','59',1173,'17','1',1368135.28,1370213.26,2077.98,342866.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','59',1174,'18','1',1044505.57,1046558.52,2052.95,338736.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','59',1175,'19','1',1193474.04,1195775.13,2301.09,379679.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','59',1176,'20','1',1566711.59,1570952.56,4219.12,696154.80,0.00,0.00,21.85,0.00,0.00),('21','220','2','59',1177,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','59',1178,'22','1',1565552.89,1569257.28,3704.39,611224.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','59',1179,'23','1',1321781.32,1324287.84,2506.52,413575.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','59',1180,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','60',1181,'1','1',2018362.70,2018362.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','60',1182,'2','1',1630220.75,1634799.01,4578.26,755412.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','60',1183,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','60',1184,'4','1',1662687.18,1667347.86,4660.68,769012.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','60',1185,'9','2',1220853.42,1220853.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','60',1186,'10','2',962998.28,967786.46,4788.18,3351726.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','60',1187,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','60',1188,'12','1',1918223.15,1921127.59,2904.44,479232.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','60',1189,'13','1',1227691.02,1230055.43,2364.41,390127.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','60',1190,'14','1',1417604.28,1417863.18,258.90,42718.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','60',1191,'15','1',1430289.42,1434169.43,3880.01,640201.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','60',1192,'16','1',2165602.32,2169060.78,3458.46,570645.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','60',1193,'17','1',1370213.26,1371451.07,1237.81,204238.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','60',1194,'18','1',1046558.52,1049366.31,2807.79,463285.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','60',1195,'19','1',1195775.13,1197982.19,2207.06,364164.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','60',1196,'20','1',1570952.56,1575261.25,4308.69,710933.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','60',1197,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','60',1198,'22','1',1569257.28,1572247.01,2989.73,493305.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','60',1199,'23','1',1324287.84,1327196.54,2908.70,479935.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','60',1200,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','61',1201,'1','1',2018362.70,2018362.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','61',1202,'2','1',1634799.01,1642209.49,7410.48,1222729.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','61',1203,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','61',1204,'4','1',1667347.86,1674928.88,7581.02,1250868.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','61',1205,'9','2',1220853.42,1220853.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','61',1206,'10','2',967786.46,972962.12,5175.66,3622962.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','61',1207,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','61',1208,'12','1',1921127.59,1926671.70,5544.11,914778.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','61',1209,'13','1',1230055.43,1234950.43,4895.00,807675.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','61',1210,'14','1',1417863.18,1422572.73,4709.55,777075.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','61',1211,'15','1',1434169.43,1438599.48,4430.05,730958.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','61',1212,'16','1',2169060.78,2174877.95,5817.17,959833.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','61',1213,'17','1',1371451.07,1375802.39,4351.32,717967.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','61',1214,'18','1',1049366.31,1053121.88,3755.57,619669.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','61',1215,'19','1',1197982.19,1201455.47,3473.28,573091.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','61',1216,'20','1',1575261.25,1582468.17,7206.92,1189141.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','61',1217,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','61',1218,'22','1',1572247.01,1576012.06,3765.05,621233.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','61',1219,'23','1',1327196.54,1331193.24,3996.70,659455.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','61',1220,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','62',1221,'1','1',2018362.70,2018362.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','62',1222,'2','1',1642209.49,1650424.59,8215.10,1355491.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','62',1223,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','62',1224,'4','1',1674928.88,1684607.43,9678.55,1596960.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','62',1225,'9','2',1220853.42,1221098.40,244.98,171486.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','62',1226,'10','2',972962.12,974092.01,1129.89,790923.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','62',1227,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','62',1228,'12','1',1926671.70,1933763.30,7091.60,1170114.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','62',1229,'13','1',1234950.43,1237754.39,2803.96,462653.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','62',1230,'14','1',1422572.73,1428819.11,6246.38,1030652.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','62',1231,'15','1',1438599.48,1443292.24,4692.76,774305.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','62',1232,'16','1',2174877.95,2181447.20,6569.25,1083926.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','62',1233,'17','1',1375802.39,1380584.47,4782.08,789043.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','62',1234,'18','1',1053121.88,1059438.73,6316.85,1042280.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','62',1235,'19','1',1201455.47,1201455.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','62',1236,'20','1',1582468.17,1587761.69,5293.52,873430.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','62',1237,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','62',1238,'22','1',1576012.06,1580630.31,4618.25,762011.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','62',1239,'23','1',1331193.24,1337033.05,5839.81,963568.65,0.00,0.00,0.00,0.00,0.00),('21','220','4','62',1240,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','63',1241,'1','1',2018362.70,2018362.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','63',1242,'2','1',1650424.59,1650424.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','63',1243,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','63',1244,'4','1',1684607.43,1684607.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','63',1245,'9','2',1221098.40,1221286.56,188.16,135475.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','63',1246,'10','2',974092.01,979963.59,5871.58,4227537.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','63',1247,'11','3',485939.19,485939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','63',1248,'12','1',1933763.30,1933763.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','63',1249,'13','1',1237754.39,1237754.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','63',1250,'14','1',1428819.11,1428819.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','63',1251,'15','1',1443292.24,1443292.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','63',1252,'16','1',2181447.20,2181447.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','63',1253,'17','1',1380584.47,1380584.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','63',1254,'18','1',1059438.73,1059438.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','63',1255,'19','1',1201455.47,1201455.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','63',1256,'20','1',1587761.69,1587761.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','63',1257,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','63',1258,'22','1',1580630.31,1580630.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','63',1259,'23','1',1337033.05,1337033.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','63',1260,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','64',1261,'1','1',2018362.70,2018362.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','64',1262,'2','1',1650424.59,1658280.25,7855.66,1296183.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','64',1263,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','64',1264,'4','1',1684607.43,1692420.73,7813.30,1289194.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','64',1265,'9','2',1221286.56,1221286.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','64',1266,'10','2',979963.59,982662.60,2699.01,1943287.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','64',1267,'11','3',485939.19,487020.67,1081.48,702964.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','64',1268,'12','1',1933763.30,1941780.02,8016.72,1322758.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','64',1269,'13','1',1237754.39,1237754.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','64',1270,'14','1',1428819.11,1434954.48,6135.37,1012336.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','64',1271,'15','1',1443292.24,1449218.69,5926.45,977864.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','64',1272,'16','1',2181447.20,2188149.83,6702.63,1105933.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','64',1273,'17','1',1380584.47,1385910.05,5325.58,878720.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','64',1274,'18','1',1059438.73,1065162.87,5724.14,944483.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','64',1275,'19','1',1201455.47,1201455.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','64',1276,'20','1',1587761.69,1595265.55,7503.86,1238136.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','64',1277,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','64',1278,'22','1',1580630.31,1585977.22,5346.91,882240.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','64',1279,'23','1',1337033.05,1341279.48,4246.43,700660.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','64',1280,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','65',1281,'1','1',2018362.70,2021593.02,3220.13,531321.45,0.00,0.00,10.19,0.00,0.00),('21','220','1','65',1282,'2','1',1658280.25,1663151.53,4871.28,803761.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','65',1283,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','65',1284,'4','1',1692420.73,1701615.41,9184.48,1515439.20,0.00,0.00,10.20,0.00,0.00),('21','220','3','65',1285,'9','2',1221286.56,1221491.34,194.45,140004.00,0.00,0.00,10.33,0.00,0.00),('21','220','3','65',1286,'10','2',982662.60,987182.78,4509.98,3247185.60,0.00,0.00,10.20,0.00,0.00),('21','220','4','65',1287,'11','3',487020.67,488244.23,1223.56,795312.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','65',1288,'12','1',1941780.02,1947722.75,5932.58,978875.70,0.00,0.00,10.15,0.00,0.00),('21','220','1','65',1289,'13','1',1237754.39,1243767.68,5992.69,988793.85,0.00,0.00,20.60,0.00,0.00),('21','220','1','65',1290,'14','1',1434954.48,1437610.26,2634.88,434755.20,0.00,0.00,20.90,0.00,0.00),('21','220','1','65',1291,'15','1',1449218.69,1456230.16,7000.29,1155047.85,0.00,0.00,11.18,0.00,0.00),('21','220','2','65',1292,'16','1',2188149.83,2193839.31,5679.26,937077.90,0.00,0.00,10.22,0.00,0.00),('21','220','2','65',1293,'17','1',1385910.05,1391657.73,5737.49,946685.85,0.00,0.00,10.19,0.00,0.00),('21','220','2','65',1294,'18','1',1065162.87,1072403.17,7230.09,1192964.85,0.00,0.00,10.21,0.00,0.00),('21','220','2','65',1295,'19','1',1201455.47,1201455.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','65',1296,'20','1',1595265.55,1602959.31,7683.59,1267792.35,0.00,0.00,10.17,0.00,0.00),('21','220','2','65',1297,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','65',1298,'22','1',1585977.22,1592523.63,6536.23,1078477.95,0.00,0.00,10.18,0.00,0.00),('21','220','2','65',1299,'23','1',1341279.48,1345728.36,4438.69,732383.85,0.00,0.00,10.19,0.00,0.00),('21','220','4','65',1300,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','66',1301,'1','1',2021593.02,2027457.97,5864.95,967716.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','66',1302,'2','1',1663151.53,1669081.60,5930.07,978461.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','66',1303,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','66',1304,'4','1',1701615.41,1710835.85,9220.44,1521372.60,0.00,0.00,0.00,0.00,0.00),('21','220','3','66',1305,'9','2',1221491.34,1221491.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','66',1306,'10','2',987182.78,990634.30,3451.52,2485094.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','66',1307,'11','3',488244.23,489865.66,1621.43,1053927.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','66',1308,'12','1',1947722.75,1952498.89,4776.14,788063.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','66',1309,'13','1',1243767.68,1248291.45,4523.77,746422.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','66',1310,'14','1',1437610.26,1437610.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','66',1311,'15','1',1456230.16,1463969.70,7739.54,1277024.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','66',1312,'16','1',2193839.31,2199717.06,5877.75,969828.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','66',1313,'17','1',1391657.73,1395834.14,4176.41,689107.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','66',1314,'18','1',1072403.17,1078460.50,6057.33,999459.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','66',1315,'19','1',1201455.47,1201455.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','66',1316,'20','1',1602959.31,1608939.85,5980.54,986789.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','66',1317,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','66',1318,'22','1',1592523.63,1596491.60,3967.97,654715.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','66',1319,'23','1',1345728.36,1351086.74,5358.38,884132.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','66',1320,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','67',1321,'1','1',2027457.97,2033460.06,6002.09,990344.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','67',1322,'2','1',1669081.60,1674712.88,5631.28,929161.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','67',1323,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','67',1324,'4','1',1710835.85,1718661.98,7826.13,1291311.45,0.00,0.00,0.00,0.00,0.00),('21','220','3','67',1325,'9','2',1221491.34,1221491.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','67',1326,'10','2',990634.30,997261.55,6627.25,4771620.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','67',1327,'11','3',489865.66,491389.36,1523.70,990402.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','67',1328,'12','1',1952498.89,1958554.94,6056.05,999248.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','67',1329,'13','1',1248291.45,1253210.72,4919.27,811679.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','67',1330,'14','1',1437610.26,1437610.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','67',1331,'15','1',1463969.70,1471884.25,7914.55,1305900.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','67',1332,'16','1',2199717.06,2205419.01,5701.95,940821.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','67',1333,'17','1',1395834.14,1399480.37,3646.23,601627.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','67',1334,'18','1',1078460.50,1085056.89,6596.39,1088404.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','67',1335,'19','1',1201455.47,1201455.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','67',1336,'20','1',1608939.85,1608939.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','67',1337,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','67',1338,'22','1',1596491.60,1601613.95,5122.35,845187.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','67',1339,'23','1',1351086.74,1355652.96,4566.22,753426.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','67',1340,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','68',1341,'1','1',2033460.06,2039656.37,6196.31,1022391.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','68',1342,'2','1',1674712.88,1680543.38,5830.50,962032.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','68',1343,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','68',1344,'4','1',1718661.98,1727351.37,8689.39,1433749.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','68',1345,'9','2',1221491.34,1223439.73,1948.39,1402840.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','68',1346,'10','2',997261.55,1004665.25,7403.70,5330664.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','68',1347,'11','3',491389.36,492573.11,1183.75,769440.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','68',1348,'12','1',1958554.94,1963717.07,5162.13,851751.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','68',1349,'13','1',1253210.72,1255247.57,2036.85,336080.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','68',1350,'14','1',1437610.26,1437610.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','68',1351,'15','1',1471884.25,1478947.01,7062.76,1165355.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','68',1352,'16','1',2205419.01,2212907.89,7488.88,1235665.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','68',1353,'17','1',1399480.37,1400862.41,1382.04,228036.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','68',1354,'18','1',1085056.89,1090195.11,5138.22,847806.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','68',1355,'19','1',1201455.47,1201455.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','68',1356,'20','1',1608939.85,1618344.96,9405.11,1551843.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','68',1357,'21','1',1200426.18,1200426.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','68',1358,'22','1',1601613.95,1606513.86,4899.91,808485.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','68',1359,'23','1',1355652.96,1360650.46,4997.50,824587.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','68',1360,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','69',1361,'1','1',2039656.37,2041963.41,2307.04,380661.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','69',1362,'2','1',1680543.38,1680543.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','69',1363,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','69',1364,'4','1',1727351.37,1731643.67,4292.30,708229.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','69',1365,'9','2',1223439.73,1223439.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','69',1366,'10','2',1004665.25,1010555.56,5890.31,4241023.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','69',1367,'11','3',492573.11,493716.02,1142.91,742893.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','69',1368,'12','1',1963717.07,1966399.13,2682.06,442539.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','69',1369,'13','1',1255247.57,1257224.70,1977.13,326226.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','69',1370,'14','1',1437610.26,1437610.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','69',1371,'15','1',1478947.01,1481633.40,2686.39,443254.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','69',1372,'16','1',2212907.89,2219597.67,6689.78,1103813.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','69',1373,'17','1',1400862.41,1406062.38,5199.97,857995.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','69',1374,'18','1',1090195.11,1096263.00,6067.89,1001201.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','69',1375,'19','1',1201455.47,1205991.56,4536.09,748454.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','69',1376,'20','1',1618344.96,1626409.50,8064.54,1330649.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','69',1377,'21','1',1200426.18,1204028.63,3602.45,594404.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','69',1378,'22','1',1606513.86,1611938.95,5425.09,895139.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','69',1379,'23','1',1360650.46,1367231.01,6580.55,1085790.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','69',1380,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','70',1381,'1','1',2041963.41,2045946.59,3983.18,657224.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','70',1382,'2','1',1680543.38,1687650.92,7107.54,1172744.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','70',1383,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','70',1384,'4','1',1731643.67,1739482.85,7839.18,1293464.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','70',1385,'9','2',1223439.73,1223439.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','70',1386,'10','2',1010555.56,1014127.22,3571.66,2571595.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','70',1387,'11','3',493716.02,494455.61,739.59,480736.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','70',1388,'12','1',1966399.13,1968825.32,2426.19,400321.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','70',1389,'13','1',1257224.70,1263070.43,5845.73,964545.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','70',1390,'14','1',1437610.26,1437635.06,24.80,4092.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','70',1391,'15','1',1481633.40,1489129.51,7496.11,1236858.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','70',1392,'16','1',2219597.67,2225602.25,6004.58,990755.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','70',1393,'17','1',1406062.38,1406062.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','70',1394,'18','1',1096263.00,1096263.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','70',1395,'19','1',1205991.56,1212385.08,6393.52,1054930.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','70',1396,'20','1',1626409.50,1632257.79,5848.29,964967.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','70',1397,'21','1',1204028.63,1208105.64,4077.01,672706.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','70',1398,'22','1',1611938.95,1617945.99,6007.04,991161.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','70',1399,'23','1',1367231.01,1367231.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','70',1400,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','71',1401,'1','1',2045946.59,2049987.66,4041.07,666776.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','71',1402,'2','1',1687650.92,1687981.94,331.02,54618.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','71',1403,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','71',1404,'4','1',1739482.85,1739482.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','71',1405,'9','2',1223439.73,1223439.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','71',1406,'10','2',1014127.22,1016703.65,2576.43,1855029.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','71',1407,'11','3',494455.61,495813.48,1357.87,882615.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','71',1408,'12','1',1968825.32,1971459.65,2634.33,434664.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','71',1409,'13','1',1263070.43,1265453.55,2383.12,393214.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','71',1410,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','71',1411,'15','1',1489129.51,1492115.80,2986.29,492737.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','71',1412,'16','1',2225602.25,2229982.54,4380.29,722747.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','71',1413,'17','1',1406062.38,1408373.11,2310.73,381270.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','71',1414,'18','1',1096263.00,1097840.68,1577.68,260317.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','71',1415,'19','1',1212385.08,1218706.36,6321.28,1043011.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','71',1416,'20','1',1632257.79,1637378.21,5120.42,844869.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','71',1417,'21','1',1208105.64,1208349.63,243.99,40258.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','71',1418,'22','1',1617945.99,1623739.24,5793.25,955886.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','71',1419,'23','1',1367231.01,1370198.88,2967.87,489698.55,0.00,0.00,0.00,0.00,0.00),('21','220','4','71',1420,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','72',1421,'1','1',2049987.66,2054490.50,4502.84,742968.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','72',1422,'2','1',1687981.94,1692922.03,4940.09,815114.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','72',1423,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','72',1424,'4','1',1739482.85,1749380.86,9898.01,1633171.65,0.00,0.00,0.00,0.00,0.00),('21','220','3','72',1425,'9','2',1223439.73,1223439.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','72',1426,'10','2',1016703.65,1017326.07,622.42,448142.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','72',1427,'11','3',495813.48,497435.95,1622.47,1054603.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','72',1428,'12','1',1971459.65,1975844.51,4384.86,723501.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','72',1429,'13','1',1265453.55,1267035.39,1581.84,261003.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','72',1430,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','72',1431,'15','1',1492115.80,1497513.48,5397.68,890617.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','72',1432,'16','1',2229982.54,2231168.16,1185.62,195627.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','72',1433,'17','1',1408373.11,1413565.80,5192.69,856793.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','72',1434,'18','1',1097840.68,1100596.23,2755.55,454665.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','72',1435,'19','1',1218706.36,1221926.08,3219.72,531253.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','72',1436,'20','1',1637378.21,1643863.47,6485.26,1070067.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','72',1437,'21','1',1208349.63,1209863.47,1513.84,249783.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','72',1438,'22','1',1623739.24,1628429.50,4690.26,773892.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','72',1439,'23','1',1370198.88,1373545.52,3346.64,552195.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','72',1440,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','73',1441,'1','1',2054490.50,2054490.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','73',1442,'2','1',1692922.03,1692922.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','73',1443,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','73',1444,'4','1',1749380.86,1749380.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','73',1445,'9','2',1223439.73,1223499.36,59.63,45318.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','73',1446,'10','2',1017326.07,1024553.16,7227.09,5492588.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','73',1447,'11','3',497435.95,497435.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','73',1448,'12','1',1975844.51,1975844.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','73',1449,'13','1',1267035.39,1267035.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','73',1450,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','73',1451,'15','1',1497513.48,1497513.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','73',1452,'16','1',2231168.16,2231168.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','73',1453,'17','1',1413565.80,1413565.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','73',1454,'18','1',1100596.23,1100596.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','73',1455,'19','1',1221926.08,1221926.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','73',1456,'20','1',1643863.47,1643863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','73',1457,'21','1',1209863.47,1209863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','73',1458,'22','1',1628429.50,1628429.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','73',1459,'23','1',1373545.52,1373545.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','73',1460,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','74',1461,'1','1',2054490.50,2056585.56,2095.06,345684.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','74',1462,'2','1',1692922.03,1696028.89,3106.86,512631.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','74',1463,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','74',1464,'4','1',1749380.86,1752517.21,3136.35,517497.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','74',1465,'9','2',1223499.36,1223499.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','74',1466,'10','2',1024553.16,1032417.81,7864.65,5977134.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','74',1467,'11','3',497435.95,500394.15,2958.20,1922830.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','74',1468,'12','1',1975844.51,1978394.33,2549.82,420720.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','74',1469,'13','1',1267035.39,1267600.11,564.72,93178.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','74',1470,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','74',1471,'15','1',1497513.48,1500825.15,3311.67,546425.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','74',1472,'16','1',2231168.16,2234515.61,3347.45,552329.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','74',1473,'17','1',1413565.80,1415832.98,2267.18,374084.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','74',1474,'18','1',1100596.23,1103233.99,2637.76,435230.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','74',1475,'19','1',1221926.08,1225536.52,3610.44,595722.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','74',1476,'20','1',1643863.47,1648992.46,5128.99,846283.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','74',1477,'21','1',1209863.47,1212989.97,3126.50,515872.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','74',1478,'22','1',1628429.50,1631815.57,3386.07,558701.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','74',1479,'23','1',1373545.52,1378059.14,4513.62,744747.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','74',1480,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','75',1481,'1','1',2056585.56,2059349.88,2764.32,456112.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','75',1482,'2','1',1696028.89,1698215.15,2186.26,360732.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','75',1483,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','75',1484,'4','1',1752517.21,1755654.38,3137.17,517633.05,0.00,0.00,0.00,0.00,0.00),('21','220','3','75',1485,'9','2',1223499.36,1225503.97,2004.61,1523503.60,0.00,0.00,0.00,0.00,0.00),('21','220','3','75',1486,'10','2',1032417.81,1040109.44,7691.63,5845638.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','75',1487,'11','3',500394.15,502096.43,1702.28,1106482.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','75',1488,'12','1',1978394.33,1981018.96,2624.63,433063.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','75',1489,'13','1',1267600.11,1269256.03,1655.92,273226.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','75',1490,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','75',1491,'15','1',1500825.15,1503220.31,2395.16,395201.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','75',1492,'16','1',2234515.61,2238242.73,3727.12,614974.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','75',1493,'17','1',1415832.98,1416498.49,665.51,109809.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','75',1494,'18','1',1103233.99,1107576.49,4342.50,716512.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','75',1495,'19','1',1225536.52,1229982.92,4446.40,733656.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','75',1496,'20','1',1648992.46,1653762.91,4770.45,787124.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','75',1497,'21','1',1212989.97,1218093.19,5103.22,842031.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','75',1498,'22','1',1631815.57,1636803.28,4987.71,822972.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','75',1499,'23','1',1378059.14,1382214.20,4155.06,685584.90,0.00,0.00,0.00,0.00,0.00),('21','220','4','75',1500,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','76',1501,'1','1',2059349.88,2062998.87,3648.99,602083.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','76',1502,'2','1',1698215.15,1701718.02,3502.87,577973.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','76',1503,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','76',1504,'4','1',1755654.38,1759925.37,4270.99,704713.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','76',1505,'9','2',1225503.97,1225503.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','76',1506,'10','2',1040109.44,1042082.10,1972.66,1499221.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','76',1507,'11','3',502096.43,503341.94,1245.51,809578.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','76',1508,'12','1',1981018.96,1984396.11,3377.15,557229.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','76',1509,'13','1',1269256.03,1271488.50,2232.47,368357.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','76',1510,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','76',1511,'15','1',1503220.31,1507113.95,3893.64,642450.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','76',1512,'16','1',2238242.73,2243403.19,5160.46,851475.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','76',1513,'17','1',1416498.49,1416498.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','76',1514,'18','1',1107576.49,1112674.32,5097.83,841141.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','76',1515,'19','1',1229982.92,1235064.96,5082.04,838536.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','76',1516,'20','1',1653762.91,1660545.97,6783.06,1119204.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','76',1517,'21','1',1218093.19,1224354.32,6261.13,1033086.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','76',1518,'22','1',1636803.28,1643137.44,6334.16,1045136.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','76',1519,'23','1',1382214.20,1387791.89,5577.69,920318.85,0.00,0.00,0.00,0.00,0.00),('21','220','4','76',1520,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','77',1521,'1','1',2062998.87,2066172.91,3174.04,523716.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','77',1522,'2','1',1701718.02,1704961.38,3243.36,535154.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','77',1523,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','77',1524,'4','1',1759925.37,1765200.12,5274.75,870333.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','77',1525,'9','2',1225503.97,1225503.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','77',1526,'10','2',1042082.10,1042687.11,605.01,459807.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','77',1527,'11','3',503341.94,504432.86,1090.92,709098.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','77',1528,'12','1',1984396.11,1987938.76,3542.65,584537.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','77',1529,'13','1',1271488.50,1274264.55,2776.05,458048.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','77',1530,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','77',1531,'15','1',1507113.95,1510667.05,3553.10,586261.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','77',1532,'16','1',2243403.19,2248761.07,5357.88,884050.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','77',1533,'17','1',1416498.49,1416499.22,0.73,120.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','77',1534,'18','1',1112674.32,1118374.66,5700.34,940556.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','77',1535,'19','1',1235064.96,1240181.05,5116.09,844154.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','77',1536,'20','1',1660545.97,1668130.49,7584.52,1251445.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','77',1537,'21','1',1224354.32,1230501.93,6147.61,1014355.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','77',1538,'22','1',1643137.44,1648246.95,5109.51,843069.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','77',1539,'23','1',1387791.89,1393123.62,5331.73,879735.45,0.00,0.00,0.00,0.00,0.00),('21','220','4','77',1540,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','78',1541,'1','1',2066172.91,2067707.72,1534.81,253243.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','78',1542,'2','1',1704961.38,1706469.06,1507.68,248767.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','78',1543,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','78',1544,'4','1',1765200.12,1767526.11,2325.99,383788.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','78',1545,'9','2',1225503.97,1225503.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','78',1546,'10','2',1042687.11,1048768.27,6081.16,4621681.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','78',1547,'11','3',504432.86,505646.00,1213.14,788541.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','78',1548,'12','1',1987938.76,1990012.48,2073.72,342163.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','78',1549,'13','1',1274264.55,1275637.92,1373.37,226606.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','78',1550,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','78',1551,'15','1',1510667.05,1512280.90,1613.85,266285.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','78',1552,'16','1',2248761.07,2251943.74,3182.67,525140.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','78',1553,'17','1',1416499.22,1419692.05,3192.83,526816.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','78',1554,'18','1',1118374.66,1121476.71,3102.05,511838.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','78',1555,'19','1',1240181.05,1243491.32,3310.27,546194.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','78',1556,'20','1',1668130.49,1671399.12,3268.63,539323.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','78',1557,'21','1',1230501.93,1234104.01,3602.08,594343.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','78',1558,'22','1',1648246.95,1651815.72,3568.77,588847.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','78',1559,'23','1',1393123.62,1396654.65,3531.03,582619.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','78',1560,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','79',1561,'1','1',2067707.72,2071078.21,3370.49,556130.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','79',1562,'2','1',1706469.06,1709102.38,2633.32,434497.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','79',1563,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','79',1564,'4','1',1767526.11,1772751.44,5225.33,862179.45,0.00,0.00,0.00,0.00,0.00),('21','220','3','79',1565,'9','2',1225503.97,1225503.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','79',1566,'10','2',1048768.27,1051305.91,2537.64,1928606.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','79',1567,'11','3',505646.00,506605.34,959.34,623572.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','79',1568,'12','1',1990012.48,1993300.34,3287.86,542496.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','79',1569,'13','1',1275637.92,1278000.89,2362.97,389890.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','79',1570,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','79',1571,'15','1',1512280.90,1516523.09,4242.19,699961.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','79',1572,'16','1',2251943.74,2256638.25,4694.51,774594.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','79',1573,'17','1',1419692.05,1423658.15,3966.10,654406.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','79',1574,'18','1',1121476.71,1125584.34,4107.63,677758.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','79',1575,'19','1',1243491.32,1247597.31,4105.99,677488.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','79',1576,'20','1',1671399.12,1675418.14,4019.02,663138.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','79',1577,'21','1',1234104.01,1238584.73,4480.72,739318.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','79',1578,'22','1',1651815.72,1656243.47,4427.75,730578.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','79',1579,'23','1',1396654.65,1399856.30,3201.65,528272.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','79',1580,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','80',1581,'1','1',2071078.21,2075983.35,4905.14,809348.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','80',1582,'2','1',1709102.38,1713026.08,3923.70,647410.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','80',1583,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','80',1584,'4','1',1772751.44,1778927.99,6176.55,1019130.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','80',1585,'9','2',1225503.97,1225503.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','80',1586,'10','2',1051305.91,1058581.97,7276.06,5529805.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','80',1587,'11','3',506605.34,510111.42,3506.08,2278948.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','80',1588,'12','1',1993300.34,1997531.79,4231.45,698189.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','80',1589,'13','1',1278000.89,1281088.36,3087.47,509432.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','80',1590,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','80',1591,'15','1',1516523.09,1521761.83,5238.74,864392.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','80',1592,'16','1',2256638.25,2259522.84,2884.59,475957.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','80',1593,'17','1',1423658.15,1425048.11,1389.96,229343.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','80',1594,'18','1',1125584.34,1128065.25,2480.91,409350.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','80',1595,'19','1',1247597.31,1250276.44,2679.13,442056.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','80',1596,'20','1',1675418.14,1679008.33,3590.19,592381.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','80',1597,'21','1',1238584.73,1241033.80,2449.07,404096.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','80',1598,'22','1',1656243.47,1658589.23,2345.76,387050.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','80',1599,'23','1',1399856.30,1401492.94,1636.64,270045.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','80',1600,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','81',1601,'1','1',2075983.35,2077684.57,1701.22,280701.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','81',1602,'2','1',1713026.08,1717228.11,4202.03,693334.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','81',1603,'3','1',1779434.99,1779434.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','81',1604,'4','1',1778927.99,1783068.27,4140.28,683146.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','81',1605,'9','2',1225503.97,1227096.95,1592.98,1210664.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','81',1606,'10','2',1058581.97,1071016.27,12434.30,9450068.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','81',1607,'11','3',510111.42,514819.81,4708.39,3060455.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','81',1608,'12','1',1997531.79,2000410.57,2878.78,474998.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','81',1609,'13','1',1281088.36,1283061.07,1972.71,325497.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','81',1610,'14','1',1437635.06,1437635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','81',1611,'15','1',1521761.83,1525579.57,3817.74,629927.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','81',1612,'16','1',2259522.84,2263118.43,3595.59,593272.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','81',1613,'17','1',1425048.11,1429174.32,4126.21,680824.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','81',1614,'18','1',1128065.25,1131616.23,3550.98,585911.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','81',1615,'19','1',1250276.44,1253628.23,3351.79,553045.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','81',1616,'20','1',1679008.33,1684110.81,5102.48,841909.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','81',1617,'21','1',1241033.80,1244052.80,3019.00,498135.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','81',1618,'22','1',1658589.23,1662857.38,4268.15,704244.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','81',1619,'23','1',1401492.94,1405480.41,3987.47,657932.55,0.00,0.00,0.00,0.00,0.00),('21','220','4','81',1620,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','82',1621,'1','1',2077684.57,2079485.47,1800.90,297148.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','82',1622,'2','1',1717228.11,1718290.19,1062.08,175243.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','82',1623,'3','1',1779434.99,1783068.27,3633.28,599491.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','82',1624,'4','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','82',1625,'9','2',1227096.95,1227096.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','82',1626,'10','2',1071016.27,1071568.90,552.63,419998.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','82',1627,'11','3',514819.81,514819.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','82',1628,'12','1',2000410.57,2002119.66,1709.09,281999.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','82',1629,'13','1',1283061.07,1284128.45,1067.38,176117.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','82',1630,'14','1',1437635.06,1437653.15,18.09,2984.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','82',1631,'15','1',1525579.57,1527511.16,1931.59,318712.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','82',1632,'16','1',2263118.43,2266319.35,3200.92,528151.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','82',1633,'17','1',1429174.32,1431640.38,2466.06,406899.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','82',1634,'18','1',1131616.23,1134619.40,3003.17,495523.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','82',1635,'19','1',1253628.23,1256131.04,2502.81,412963.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','82',1636,'20','1',1684110.81,1687810.03,3699.22,610371.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','82',1637,'21','1',1244052.80,1247038.21,2985.41,492592.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','82',1638,'22','1',1662857.38,1665208.44,2351.06,387924.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','82',1639,'23','1',1405480.41,1408817.27,3336.86,550581.90,0.00,0.00,0.00,0.00,0.00),('21','220','4','82',1640,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','83',1641,'1','1',2079485.47,2082653.16,3167.69,522668.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','83',1642,'2','1',1718290.19,1721328.69,3038.50,501352.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','83',1643,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','83',1644,'4','1',1783068.27,1789157.19,6088.92,1004671.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','83',1645,'9','2',1227096.95,1227264.08,167.13,127018.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','83',1646,'10','2',1071568.90,1081633.63,10064.73,7649194.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','83',1647,'11','3',514819.81,514819.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','83',1648,'12','1',2002119.66,2006323.27,4203.61,693595.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','83',1649,'13','1',1284128.45,1284150.21,21.76,3590.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','83',1650,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','83',1651,'15','1',1527511.16,1530864.73,3353.57,553339.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','83',1652,'16','1',2266319.35,2270481.04,4161.69,686678.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','83',1653,'17','1',1431640.38,1435864.20,4223.82,696930.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','83',1654,'18','1',1134619.40,1138218.10,3598.70,593785.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','83',1655,'19','1',1256131.04,1259584.96,3453.92,569896.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','83',1656,'20','1',1687810.03,1693191.61,5381.58,887960.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','83',1657,'21','1',1247038.21,1250691.06,3652.85,602720.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','83',1658,'22','1',1665208.44,1668910.03,3701.59,610762.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','83',1659,'23','1',1408817.27,1412745.59,3928.32,648172.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','83',1660,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','84',1661,'1','1',2082653.16,2085531.79,2878.63,474973.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','84',1662,'2','1',1721328.69,1724041.90,2713.21,447679.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','84',1663,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','84',1664,'4','1',1789157.19,1793254.90,4097.71,676122.15,0.00,0.00,0.00,0.00,0.00),('21','220','3','84',1665,'9','2',1227264.08,1227264.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','84',1666,'10','2',1081633.63,1089541.89,7908.26,6010277.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','84',1667,'11','3',514819.81,514819.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','84',1668,'12','1',2006323.27,2009894.97,3571.70,589330.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','84',1669,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','84',1670,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','84',1671,'15','1',1530864.73,1534689.30,3824.57,631054.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','84',1672,'16','1',2270481.04,2274944.12,4463.08,736408.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','84',1673,'17','1',1435864.20,1439808.38,3944.18,650789.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','84',1674,'18','1',1138218.10,1142545.41,4327.31,714006.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','84',1675,'19','1',1259584.96,1262697.62,3112.66,513588.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','84',1676,'20','1',1693191.61,1698755.84,5564.23,918097.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','84',1677,'21','1',1250691.06,1254615.81,3924.75,647583.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','84',1678,'22','1',1668910.03,1673392.27,4482.24,739569.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','84',1679,'23','1',1412745.59,1416733.04,3987.45,657929.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','84',1680,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','85',1681,'1','1',2085531.79,2089384.74,3852.95,635736.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','85',1682,'2','1',1724041.90,1727324.19,3282.29,541577.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','85',1683,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','85',1684,'4','1',1793254.90,1797728.66,4473.76,738170.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','85',1685,'9','2',1227264.08,1227264.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','85',1686,'10','2',1089541.89,1089986.67,444.78,338032.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','85',1687,'11','3',514819.81,514819.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','85',1688,'12','1',2009894.97,2012708.55,2813.58,464240.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','85',1689,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','85',1690,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','85',1691,'15','1',1534689.30,1537931.19,3241.89,534911.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','85',1692,'16','1',2274944.12,2279695.74,4751.62,784017.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','85',1693,'17','1',1439808.38,1444114.46,4306.08,710503.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','85',1694,'18','1',1142545.41,1146272.70,3727.29,615002.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','85',1695,'19','1',1262697.62,1266934.09,4236.47,699017.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','85',1696,'20','1',1698755.84,1704611.56,5855.72,966193.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','85',1697,'21','1',1254615.81,1257157.07,2541.26,419307.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','85',1698,'22','1',1673392.27,1677207.50,3815.23,629512.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','85',1699,'23','1',1416733.04,1420943.64,4210.60,694749.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','85',1700,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','86',1701,'1','1',2089384.74,2092366.74,2982.00,492030.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','86',1702,'2','1',1727324.19,1728701.62,1377.43,227275.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','86',1703,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','86',1704,'4','1',1797728.66,1801213.75,3485.09,575039.85,0.00,0.00,0.00,0.00,0.00),('21','220','3','86',1705,'9','2',1227264.08,1227264.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','86',1706,'10','2',1089986.67,1093679.84,3693.17,2806809.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','86',1707,'11','3',514819.81,515365.48,545.67,354685.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','86',1708,'12','1',2012708.55,2015419.64,2711.09,447329.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','86',1709,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','86',1710,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','86',1711,'15','1',1537931.19,1541360.55,3429.36,565844.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','86',1712,'16','1',2279695.74,2283680.28,3984.54,657449.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','86',1713,'17','1',1444114.46,1446973.57,2859.11,471753.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','86',1714,'18','1',1146272.70,1150540.27,4267.57,704149.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','86',1715,'19','1',1266934.09,1269211.46,2277.37,375766.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','86',1716,'20','1',1704611.56,1709655.78,5044.22,832296.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','86',1717,'21','1',1257157.07,1259601.73,2444.66,403368.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','86',1718,'22','1',1677207.50,1681403.60,4196.10,692356.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','86',1719,'23','1',1420943.64,1424555.83,3612.19,596011.35,0.00,0.00,0.00,0.00,0.00),('21','220','4','86',1720,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','87',1721,'1','1',2092366.74,2093698.50,1331.76,219740.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','87',1722,'2','1',1728701.62,1730490.25,1788.63,295123.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','87',1723,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','87',1724,'4','1',1801213.75,1803530.18,2316.43,382210.95,0.00,0.00,0.00,0.00,0.00),('21','220','3','87',1725,'9','2',1227264.08,1233342.61,6078.53,4619682.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','87',1726,'10','2',1093679.84,1102619.83,8939.99,6794392.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','87',1727,'11','3',515365.48,519560.52,4195.04,2726774.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','87',1728,'12','1',2015419.64,2017156.04,1736.40,286506.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','87',1729,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','87',1730,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','87',1731,'15','1',1541360.55,1543505.07,2144.52,353845.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','87',1732,'16','1',2283680.28,2286678.35,2998.07,494681.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','87',1733,'17','1',1446973.57,1449283.01,2309.44,381057.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','87',1734,'18','1',1150540.27,1152900.52,2360.25,389441.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','87',1735,'19','1',1269211.46,1272192.02,2980.56,491792.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','87',1736,'20','1',1709655.78,1712464.63,2808.85,463460.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','87',1737,'21','1',1259601.73,1261922.47,2320.74,382922.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','87',1738,'22','1',1681403.60,1683673.31,2269.71,374502.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','87',1739,'23','1',1424555.83,1427299.50,2743.67,452705.55,0.00,0.00,0.00,0.00,0.00),('21','220','4','87',1740,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','88',1741,'1','1',2093698.50,2096389.56,2691.06,444024.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','88',1742,'2','1',1730490.25,1733089.62,2599.37,428896.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','88',1743,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','88',1744,'4','1',1803530.18,1806871.15,3340.97,551260.05,0.00,0.00,0.00,0.00,0.00),('21','220','3','88',1745,'9','2',1233342.61,1233342.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','88',1746,'10','2',1102619.83,1111668.33,9048.50,6876860.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','88',1747,'11','3',519560.52,525075.60,5515.08,3584798.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','88',1748,'12','1',2017156.04,2020194.83,3038.79,501400.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','88',1749,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','88',1750,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','88',1751,'15','1',1543505.07,1546095.56,2590.49,427430.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','88',1752,'16','1',2286678.35,2290202.78,3524.43,581530.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','88',1753,'17','1',1449283.01,1451488.23,2205.22,363861.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','88',1754,'18','1',1152900.52,1155616.19,2715.67,448085.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','88',1755,'19','1',1272192.02,1274656.94,2464.92,406711.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','88',1756,'20','1',1712464.63,1716173.09,3708.46,611895.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','88',1757,'21','1',1261922.47,1264026.76,2104.29,347207.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','88',1758,'22','1',1683673.31,1686224.76,2551.45,420989.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','88',1759,'23','1',1427299.50,1429355.61,2056.11,339258.15,0.00,0.00,0.00,0.00,0.00),('21','220','4','88',1760,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','89',1761,'1','1',2096389.56,2097175.13,785.57,129619.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','89',1762,'2','1',1733089.62,1734118.80,1029.18,169814.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','89',1763,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','89',1764,'4','1',1806871.15,1808197.99,1326.84,218928.60,0.00,0.00,0.00,0.00,0.00),('21','220','3','89',1765,'9','2',1233342.61,1233342.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','89',1766,'10','2',1111668.33,1111806.98,138.65,108147.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','89',1767,'11','3',525075.60,527024.27,1948.67,1266637.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','89',1768,'12','1',2020194.83,2021195.03,1000.20,165033.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','89',1769,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','89',1770,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','89',1771,'15','1',1546095.56,1548032.07,1936.51,319524.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','89',1772,'16','1',2290202.78,2292216.93,2014.15,332334.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','89',1773,'17','1',1451488.23,1453422.56,1934.33,319164.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','89',1774,'18','1',1155616.19,1158255.29,2639.10,435451.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','89',1775,'19','1',1274656.94,1275907.19,1250.25,206291.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','89',1776,'20','1',1716173.09,1718414.27,2241.18,369794.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','89',1777,'21','1',1264026.76,1265830.88,1804.12,297679.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','89',1778,'22','1',1686224.76,1688201.17,1976.41,326107.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','89',1779,'23','1',1429355.61,1431072.64,1717.03,283309.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','89',1780,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','90',1781,'1','1',2097175.13,2097175.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','90',1782,'2','1',1734118.80,1734118.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','90',1783,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','90',1784,'4','1',1808197.99,1808197.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','90',1785,'9','2',1233342.61,1233342.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','90',1786,'10','2',1111806.98,1114992.44,3185.46,2803204.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','90',1787,'11','3',527024.27,529344.00,2319.73,1623807.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','90',1788,'12','1',2021195.03,2021195.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','90',1789,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','90',1790,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','90',1791,'15','1',1548032.07,1548032.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','90',1792,'16','1',2292216.93,2292216.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','90',1793,'17','1',1453422.56,1453422.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','90',1794,'18','1',1158255.29,1158255.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','90',1795,'19','1',1275907.19,1275907.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','90',1796,'20','1',1718414.27,1718414.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','90',1797,'21','1',1265830.88,1265830.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','90',1798,'22','1',1688201.17,1688201.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','90',1799,'23','1',1431072.64,1431072.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','90',1800,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','91',1801,'1','1',2097175.13,2104685.44,7510.31,1239201.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','91',1802,'2','1',1734118.80,1740610.00,6491.20,1071048.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','91',1803,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','91',1804,'4','1',1808197.99,1817599.12,9401.13,1551186.45,0.00,0.00,0.00,0.00,0.00),('21','220','3','91',1805,'9','2',1233342.61,1233342.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','91',1806,'10','2',1114992.44,1120970.33,5977.89,5260543.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','91',1807,'11','3',529344.00,530548.43,1204.43,843102.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','91',1808,'12','1',2021195.03,2029155.78,7960.75,1313523.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','91',1809,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','91',1810,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','91',1811,'15','1',1548032.07,1554930.36,6898.29,1138217.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','91',1812,'16','1',2292216.93,2299703.11,7486.18,1235219.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','91',1813,'17','1',1453422.56,1455651.85,2229.29,367832.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','91',1814,'18','1',1158255.29,1163844.59,5589.30,922234.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','91',1815,'19','1',1275907.19,1280982.98,5075.79,837505.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','91',1816,'20','1',1718414.27,1724919.47,6505.20,1073358.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','91',1817,'21','1',1265830.88,1271319.29,5488.41,905587.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','91',1818,'22','1',1688201.17,1693581.43,5380.26,887742.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','91',1819,'23','1',1431072.64,1436741.97,5669.33,935439.45,0.00,0.00,0.00,0.00,0.00),('21','220','4','91',1820,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','92',1821,'1','1',2104685.44,2109642.45,4957.01,817906.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','92',1822,'2','1',1740610.00,1744338.68,3728.68,615232.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','92',1823,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','92',1824,'4','1',1817599.12,1824731.77,7132.65,1176887.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','92',1825,'9','2',1233342.61,1234148.86,806.25,709500.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','92',1826,'10','2',1120970.33,1130246.62,9276.29,8163135.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','92',1827,'11','3',530548.43,530548.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','92',1828,'12','1',2029155.78,2034206.84,5051.06,833424.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','92',1829,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','92',1830,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','92',1831,'15','1',1554930.36,1560054.42,5124.06,845469.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','92',1832,'16','1',2299703.11,2304468.54,4765.43,786295.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','92',1833,'17','1',1455651.85,1459598.06,3946.21,651124.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','92',1834,'18','1',1163844.59,1168003.68,4159.09,686249.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','92',1835,'19','1',1280982.98,1285060.16,4077.18,672734.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','92',1836,'20','1',1724919.47,1731121.05,6201.58,1023260.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','92',1837,'21','1',1271319.29,1274958.64,3639.35,600492.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','92',1838,'22','1',1693581.43,1698182.54,4601.11,759183.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','92',1839,'23','1',1436741.97,1441605.80,4863.83,802531.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','92',1840,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','93',1841,'1','1',2109642.45,2113309.42,3666.97,605050.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','93',1842,'2','1',1744338.68,1747595.98,3257.30,537454.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','93',1843,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','93',1844,'4','1',1824731.77,1829175.11,4443.34,733151.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','93',1845,'9','2',1234148.86,1235075.22,926.36,815196.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','93',1846,'10','2',1130246.62,1139155.91,8909.29,7840175.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','93',1847,'11','3',530548.43,530548.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','93',1848,'12','1',2034206.84,2038253.16,4046.32,667642.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','93',1849,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','93',1850,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','93',1851,'15','1',1560054.42,1564850.21,4795.79,791305.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','93',1852,'16','1',2304468.54,2308482.34,4013.80,662277.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','93',1853,'17','1',1459598.06,1461923.64,2325.58,383720.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','93',1854,'18','1',1168003.68,1171484.46,3480.78,574328.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','93',1855,'19','1',1285060.16,1288539.84,3479.68,574147.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','93',1856,'20','1',1731121.05,1735618.00,4496.95,741996.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','93',1857,'21','1',1274958.64,1278957.66,3999.02,659838.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','93',1858,'22','1',1698182.54,1701291.15,3108.61,512920.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','93',1859,'23','1',1441605.80,1445090.18,3484.38,574922.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','93',1860,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','94',1861,'1','1',2113309.42,2116270.30,2960.88,488545.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','94',1862,'2','1',1747595.98,1750808.71,3212.73,530100.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','94',1863,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','94',1864,'4','1',1829175.11,1832060.37,2885.26,476067.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','94',1865,'9','2',1235075.22,1235075.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','94',1866,'10','2',1139155.91,1142271.29,3115.38,2741534.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','94',1867,'11','3',530548.43,530548.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','94',1868,'12','1',2038253.16,2041410.95,3157.79,521035.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','94',1869,'13','1',1284150.21,1284150.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','94',1870,'14','1',1437653.15,1437653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','94',1871,'15','1',1564850.21,1567549.90,2699.69,445448.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','94',1872,'16','1',2308482.34,2312818.98,4336.64,715545.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','94',1873,'17','1',1461923.64,1463865.43,1941.79,320395.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','94',1874,'18','1',1171484.46,1175151.55,3667.09,605069.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','94',1875,'19','1',1288539.84,1292259.37,3719.53,613722.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','94',1876,'20','1',1735618.00,1740421.27,4803.27,792539.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','94',1877,'21','1',1278957.66,1283551.63,4593.97,758005.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','94',1878,'22','1',1701291.15,1705142.58,3851.43,635485.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','94',1879,'23','1',1445090.18,1448845.42,3755.24,619614.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','94',1880,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','95',1881,'1','1',2116270.30,2119210.26,2939.96,485093.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','95',1882,'2','1',1750808.71,1753347.09,2538.38,418832.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','95',1883,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','95',1884,'4','1',1832060.37,1836075.68,4015.31,662526.15,0.00,0.00,0.00,0.00,0.00),('21','220','3','95',1885,'9','2',1235075.22,1236607.36,1532.14,1348283.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','95',1886,'10','2',1142271.29,1150251.62,7980.33,7022690.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','95',1887,'11','3',530548.43,530548.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','95',1888,'12','1',2041410.95,2044209.72,2798.77,461797.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','95',1889,'13','1',1284150.21,1286240.20,2089.99,344848.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','95',1890,'14','1',1437653.15,1437653.35,0.20,33.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','95',1891,'15','1',1567549.90,1570300.59,2750.69,453863.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','95',1892,'16','1',2312818.98,2316961.06,4142.08,683443.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','95',1893,'17','1',1463865.43,1467447.36,3581.93,591018.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','95',1894,'18','1',1175151.55,1178928.60,3777.05,623213.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','95',1895,'19','1',1292259.37,1295410.41,3151.04,519921.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','95',1896,'20','1',1740421.27,1745398.01,4976.74,821162.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','95',1897,'21','1',1283551.63,1286733.63,3182.00,525030.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','95',1898,'22','1',1705142.58,1709231.38,4088.80,674652.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','95',1899,'23','1',1448845.42,1452679.77,3834.35,632667.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','95',1900,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','96',1901,'1','1',2119210.26,2120468.44,1258.18,207599.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','96',1902,'2','1',1753347.09,1754455.49,1108.40,182886.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','96',1903,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','96',1904,'4','1',1836075.68,1838717.42,2641.74,435887.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','96',1905,'9','2',1236607.36,1237393.17,785.81,644364.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','96',1906,'10','2',1150251.62,1159645.71,9394.09,7703153.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','96',1907,'11','3',530548.43,530548.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','96',1908,'12','1',2044209.72,2045506.08,1296.36,213899.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','96',1909,'13','1',1286240.20,1287174.95,934.75,154233.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','96',1910,'14','1',1437653.35,1437653.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','96',1911,'15','1',1570300.59,1571859.39,1558.80,257202.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','96',1912,'16','1',2316961.06,2319915.93,2954.87,487553.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','96',1913,'17','1',1467447.36,1470483.02,3035.66,500883.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','96',1914,'18','1',1178928.60,1182022.19,3093.59,510442.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','96',1915,'19','1',1295410.41,1298242.94,2832.53,467367.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','96',1916,'20','1',1745398.01,1748675.80,3277.79,540835.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','96',1917,'21','1',1286733.63,1289703.79,2970.16,490076.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','96',1918,'22','1',1709231.38,1711435.41,2204.03,363664.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','96',1919,'23','1',1452679.77,1456071.85,3392.08,559693.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','96',1920,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','97',1921,'1','1',2120468.44,2122773.43,2304.99,380323.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','97',1922,'2','1',1754455.49,1757030.46,2574.97,424870.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','97',1923,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','97',1924,'4','1',1838717.42,1843346.44,4629.02,763788.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','97',1925,'9','2',1237393.17,1239341.24,1948.07,1597417.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','97',1926,'10','2',1159645.71,1166543.36,6897.65,5656073.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','97',1927,'11','3',530548.43,530548.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','97',1928,'12','1',2045506.08,2047524.88,2018.80,333102.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','97',1929,'13','1',1287174.95,1288592.65,1417.70,233920.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','97',1930,'14','1',1437653.35,1437653.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','97',1931,'15','1',1571859.39,1574730.68,2871.29,473762.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','97',1932,'16','1',2319915.93,2323903.28,3987.35,657912.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','97',1933,'17','1',1470483.02,1474012.43,3529.41,582352.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','97',1934,'18','1',1182022.19,1185229.80,3207.61,529255.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','97',1935,'19','1',1298242.94,1301751.70,3508.76,578945.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','97',1936,'20','1',1748675.80,1753134.22,4458.42,735639.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','97',1937,'21','1',1289703.79,1292909.94,3206.15,529014.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','97',1938,'22','1',1711435.41,1714809.99,3374.58,556805.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','97',1939,'23','1',1456071.85,1459706.89,3635.04,599781.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','97',1940,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','98',1941,'1','1',2122773.43,2125547.16,2773.73,457665.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','98',1942,'2','1',1757030.46,1760518.94,3488.48,575599.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','98',1943,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','98',1944,'4','1',1843346.44,1847418.63,4072.19,671911.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','98',1945,'9','2',1239341.24,1239341.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','98',1946,'10','2',1166543.36,1174247.73,7704.37,6317583.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','98',1947,'11','3',530548.43,531511.10,962.67,722002.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','98',1948,'12','1',2047524.88,2049633.50,2108.62,347922.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','98',1949,'13','1',1288592.65,1291188.84,2596.19,428371.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','98',1950,'14','1',1437653.35,1437653.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','98',1951,'15','1',1574730.68,1578313.66,3582.98,591191.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','98',1952,'16','1',2323903.28,2328614.60,4711.32,777367.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','98',1953,'17','1',1474012.43,1477321.95,3309.52,546070.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','98',1954,'18','1',1185229.80,1189115.11,3885.31,641076.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','98',1955,'19','1',1301751.70,1305871.11,4119.41,679702.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','98',1956,'20','1',1753134.22,1759138.53,6004.31,990711.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','98',1957,'21','1',1292909.94,1296257.97,3348.03,552424.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','98',1958,'22','1',1714809.99,1719143.95,4333.96,715103.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','98',1959,'23','1',1459706.89,1464389.12,4682.23,772567.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','98',1960,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','99',1961,'1','1',2125547.16,2127169.21,1622.05,267638.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','99',1962,'2','1',1760518.94,1764016.15,3497.21,577039.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','99',1963,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','99',1964,'4','1',1847418.63,1850947.66,3529.03,582289.95,0.00,0.00,0.00,0.00,0.00),('21','220','3','99',1965,'9','2',1239341.24,1241693.91,2352.67,1929189.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','99',1966,'10','2',1174247.73,1182279.10,8031.37,6585723.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','99',1967,'11','3',531511.10,532808.94,1297.84,973382.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','99',1968,'12','1',2049633.50,2051572.92,1939.42,320004.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','99',1969,'13','1',1291188.84,1293272.34,2083.50,343777.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','99',1970,'14','1',1437653.35,1437653.67,0.32,52.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','99',1971,'15','1',1578313.66,1581489.82,3176.16,524066.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','99',1972,'16','1',2328614.60,2332410.63,3796.03,626344.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','99',1973,'17','1',1477321.95,1480961.59,3639.64,600540.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','99',1974,'18','1',1189115.11,1192990.14,3875.03,639379.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','99',1975,'19','1',1305871.11,1309236.58,3365.47,555302.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','99',1976,'20','1',1759138.53,1763902.05,4763.52,785980.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','99',1977,'21','1',1296257.97,1300453.97,4196.00,692340.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','99',1978,'22','1',1719143.95,1723457.93,4313.98,711806.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','99',1979,'23','1',1464389.12,1468027.67,3638.55,600360.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','99',1980,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','100',1981,'1','1',2127169.21,2128268.46,1099.25,181376.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','100',1982,'2','1',1764016.15,1766098.44,2082.29,343577.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','100',1983,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','100',1984,'4','1',1850947.66,1853756.60,2808.94,463475.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','100',1985,'9','2',1241693.91,1245790.25,4096.34,3358998.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','100',1986,'10','2',1182279.10,1186812.08,4532.98,3717043.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','100',1987,'11','3',532808.94,534010.68,1201.74,901305.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','100',1988,'12','1',2051572.92,2053964.20,2391.28,394561.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','100',1989,'13','1',1293272.34,1294447.13,1174.79,193840.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','100',1990,'14','1',1437653.67,1437653.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','100',1991,'15','1',1581489.82,1584384.32,2894.50,477592.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','100',1992,'16','1',2332410.63,2336779.82,4369.19,720916.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','100',1993,'17','1',1480961.59,1484049.68,3088.09,509534.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','100',1994,'18','1',1192990.14,1196384.27,3394.13,560031.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','100',1995,'19','1',1309236.58,1314038.38,4801.80,792297.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','100',1996,'20','1',1763902.05,1768350.25,4448.20,733953.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','100',1997,'21','1',1300453.97,1304640.60,4186.63,690793.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','100',1998,'22','1',1723457.93,1727475.58,4017.65,662912.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','100',1999,'23','1',1468027.67,1471748.71,3721.04,613971.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','100',2000,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','101',2001,'1','1',2128268.46,2128268.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','101',2002,'2','1',1766098.44,1769792.81,3694.37,609571.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','101',2003,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','101',2004,'4','1',1853756.60,1857665.17,3908.57,644914.05,0.00,0.00,0.00,0.00,0.00),('21','220','3','101',2005,'9','2',1245790.25,1245790.84,0.59,489.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','101',2006,'10','2',1186812.08,1190532.84,3720.76,3088230.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','101',2007,'11','3',534010.68,534508.82,498.14,373602.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','101',2008,'12','1',2053964.20,2056799.46,2835.26,467817.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','101',2009,'13','1',1294447.13,1294447.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','101',2010,'14','1',1437653.67,1437653.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','101',2011,'15','1',1584384.32,1587073.87,2689.55,443775.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','101',2012,'16','1',2336779.82,2340865.85,4086.03,674194.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','101',2013,'17','1',1484049.68,1487636.69,3587.01,591856.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','101',2014,'18','1',1196384.27,1197252.38,868.11,143238.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','101',2015,'19','1',1314038.38,1317753.40,3715.02,612978.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','101',2016,'20','1',1768350.25,1772540.60,4190.35,691407.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','101',2017,'21','1',1304640.60,1308526.04,3885.44,641097.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','101',2018,'22','1',1727475.58,1730914.95,3439.37,567496.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','101',2019,'23','1',1471748.71,1475706.94,3958.23,653107.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','101',2020,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','102',2021,'1','1',2128268.46,2128268.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','102',2022,'2','1',1769792.81,1769792.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','102',2023,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','102',2024,'4','1',1857665.17,1857665.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','102',2025,'9','2',1245790.84,1245790.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','102',2026,'10','2',1190532.84,1190532.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','102',2027,'11','3',534508.82,534508.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','102',2028,'12','1',2056799.46,2056799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','102',2029,'13','1',1294447.13,1294447.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','102',2030,'14','1',1437653.67,1437653.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','102',2031,'15','1',1587073.87,1587073.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','102',2032,'16','1',2340865.85,2340865.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','102',2033,'17','1',1487636.69,1487636.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','102',2034,'18','1',1197252.38,1197252.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','102',2035,'19','1',1317753.40,1317753.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','102',2036,'20','1',1772540.60,1772540.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','102',2037,'21','1',1308526.04,1308526.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','102',2038,'22','1',1730914.95,1730914.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','102',2039,'23','1',1475706.94,1475706.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','102',2040,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','103',2041,'1','1',2128268.46,2130931.30,2662.84,439368.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','103',2042,'2','1',1769792.81,1773004.66,3211.85,529955.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','103',2043,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','103',2044,'4','1',1857665.17,1862382.83,4717.66,778413.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','103',2045,'9','2',1245790.84,1245790.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','103',2046,'10','2',1190532.84,1195275.74,4742.90,3936607.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','103',2047,'11','3',534508.82,535518.27,1009.45,757089.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','103',2048,'12','1',2056799.46,2060325.97,3526.51,581874.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','103',2049,'13','1',1294447.13,1296697.10,2249.97,371245.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','103',2050,'14','1',1437653.67,1437653.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','103',2051,'15','1',1587073.87,1591801.30,4727.43,780025.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','103',2052,'16','1',2340865.85,2345408.23,4542.38,749492.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','103',2053,'17','1',1487636.69,1490828.37,3191.68,526627.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','103',2054,'18','1',1197252.38,1201205.53,3953.15,652269.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','103',2055,'19','1',1317753.40,1320399.66,2646.26,436632.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','103',2056,'20','1',1772540.60,1777032.67,4492.07,741191.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','103',2057,'21','1',1308526.04,1312457.38,3931.34,648671.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','103',2058,'22','1',1730914.95,1734865.49,3950.54,651839.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','103',2059,'23','1',1475706.94,1478911.46,3204.52,528745.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','103',2060,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','104',2061,'1','1',2130931.30,2133204.03,2272.73,375000.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','104',2062,'2','1',1773004.66,1775009.63,2004.97,330820.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','104',2063,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','104',2064,'4','1',1862382.83,1865365.62,2982.79,492160.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','104',2065,'9','2',1245790.84,1245790.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','104',2066,'10','2',1195275.74,1199877.10,4601.36,3819128.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','104',2067,'11','3',535518.27,536124.10,605.82,454368.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','104',2068,'12','1',2060325.97,2062104.62,1778.65,293477.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','104',2069,'13','1',1296697.10,1298506.22,1809.12,298504.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','104',2070,'14','1',1437653.67,1437653.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','104',2071,'15','1',1591801.30,1595161.74,3360.44,554472.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','104',2072,'16','1',2345408.23,2348830.15,3421.92,564616.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','104',2073,'17','1',1490828.37,1494381.13,3552.76,586205.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','104',2074,'18','1',1201205.53,1204066.54,2861.01,472066.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','104',2075,'19','1',1320399.66,1323943.62,3543.96,584753.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','104',2076,'20','1',1777032.67,1781060.53,4027.86,664596.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','104',2077,'21','1',1312457.38,1315942.94,3485.56,575117.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','104',2078,'22','1',1734865.49,1738680.28,3814.79,629440.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','104',2079,'23','1',1478911.46,1482190.02,3278.56,540962.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','104',2080,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','105',2081,'1','1',2133204.03,2134451.63,1247.60,205854.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','105',2082,'2','1',1775009.63,1776316.71,1307.08,215668.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','105',2083,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','105',2084,'4','1',1865365.62,1868009.78,2644.16,436286.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','105',2085,'9','2',1245790.84,1245790.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','105',2086,'10','2',1199877.10,1203717.65,3840.55,3187656.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','105',2087,'11','3',536124.10,537209.35,1085.25,813933.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','105',2088,'12','1',2062104.62,2063538.45,1433.83,236581.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','105',2089,'13','1',1298506.22,1299415.55,909.33,150039.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','105',2090,'14','1',1437653.67,1437653.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','105',2091,'15','1',1595161.74,1596802.31,1640.57,270694.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','105',2092,'16','1',2348830.15,2352302.02,3471.87,572858.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','105',2093,'17','1',1494381.13,1497227.32,2846.19,469621.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','105',2094,'18','1',1204066.54,1207508.46,3441.92,567916.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','105',2095,'19','1',1323943.62,1326879.27,2935.65,484382.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','105',2096,'20','1',1781060.53,1785373.42,4312.89,711626.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','105',2097,'21','1',1315942.94,1318668.39,2725.45,449699.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','105',2098,'22','1',1738680.28,1741374.88,2694.60,444609.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','105',2099,'23','1',1482190.02,1485476.95,3286.93,542343.45,0.00,0.00,0.00,0.00,0.00),('21','220','4','105',2100,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','106',2101,'1','1',2134451.63,2135951.04,1499.41,247402.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','106',2102,'2','1',1776316.71,1778062.79,1746.08,288103.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','106',2103,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','106',2104,'4','1',1868009.78,1869856.92,1847.14,304778.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','106',2105,'9','2',1245790.84,1245790.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','106',2106,'10','2',1203717.65,1209496.99,5779.34,4796852.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','106',2107,'11','3',537209.35,537796.61,587.26,440442.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','106',2108,'12','1',2063538.45,2064902.62,1364.17,225088.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','106',2109,'13','1',1299415.55,1299415.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','106',2110,'14','1',1437653.67,1437653.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','106',2111,'15','1',1596802.31,1599112.90,2310.59,381247.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','106',2112,'16','1',2352302.02,2353822.40,1520.38,250862.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','106',2113,'17','1',1497227.32,1498798.25,1570.93,259203.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','106',2114,'18','1',1207508.46,1208845.39,1336.93,220593.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','106',2115,'19','1',1326879.27,1328231.43,1352.16,223106.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','106',2116,'20','1',1785373.42,1787104.36,1730.94,285605.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','106',2117,'21','1',1318668.39,1319923.11,1254.72,207028.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','106',2118,'22','1',1741374.88,1742398.12,1023.24,168834.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','106',2119,'23','1',1485476.95,1486964.48,1487.53,245442.45,0.00,0.00,0.00,0.00,0.00),('21','220','4','106',2120,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','107',2121,'1','1',2135951.04,2135951.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','107',2122,'2','1',1778062.79,1780233.33,2170.54,358139.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','107',2123,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','107',2124,'4','1',1869856.92,1872294.71,2437.79,402235.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','107',2125,'9','2',1245790.84,1245876.22,85.38,70865.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','107',2126,'10','2',1209496.99,1216057.68,6560.69,5445372.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','107',2127,'11','3',537796.61,538227.75,431.14,323352.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','107',2128,'12','1',2064902.62,2066826.70,1924.08,317473.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','107',2129,'13','1',1299415.55,1300878.47,1462.92,241381.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','107',2130,'14','1',1437653.67,1437653.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','107',2131,'15','1',1599112.90,1603450.83,4337.93,715758.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','107',2132,'16','1',2353822.40,2357898.71,4076.31,672591.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','107',2133,'17','1',1498798.25,1501494.00,2695.75,444798.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','107',2134,'18','1',1208845.39,1211762.30,2916.91,481290.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','107',2135,'19','1',1328231.43,1331636.59,3405.16,561851.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','107',2136,'20','1',1787104.36,1791237.14,4132.78,681908.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','107',2137,'21','1',1319923.11,1322923.28,3000.17,495028.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','107',2138,'22','1',1742398.12,1745641.72,3243.60,535194.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','107',2139,'23','1',1486964.48,1489551.12,2586.64,426795.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','107',2140,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','108',2141,'1','1',2135951.04,2137301.59,1350.55,222840.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','108',2142,'2','1',1780233.33,1782110.70,1877.37,309766.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','108',2143,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','108',2144,'4','1',1872294.71,1874919.09,2624.38,433022.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','108',2145,'9','2',1245876.22,1246771.95,895.73,743455.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','108',2146,'10','2',1216057.68,1218852.98,2795.30,2320099.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','108',2147,'11','3',538227.75,538846.51,618.76,464068.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','108',2148,'12','1',2066826.70,2068689.71,1863.01,307396.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','108',2149,'13','1',1300878.47,1302744.83,1866.36,307949.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','108',2150,'14','1',1437653.67,1438347.45,693.78,114473.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','108',2151,'15','1',1603450.83,1607550.72,4099.89,676481.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','108',2152,'16','1',2357898.71,2361418.78,3520.07,580811.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','108',2153,'17','1',1501494.00,1504451.81,2957.81,488038.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','108',2154,'18','1',1211762.30,1215201.57,3439.27,567479.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','108',2155,'19','1',1331636.59,1334908.72,3272.13,539901.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','108',2156,'20','1',1791237.14,1795986.38,4749.24,783624.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','108',2157,'21','1',1322923.28,1325023.98,2100.70,346615.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','108',2158,'22','1',1745641.72,1749396.70,3754.98,619571.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','108',2159,'23','1',1489551.12,1492513.24,2962.12,488749.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','108',2160,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','109',2161,'1','1',2137301.59,2139982.54,2680.95,442356.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','109',2162,'2','1',1782110.70,1784427.75,2317.05,382313.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','109',2163,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','109',2164,'4','1',1874919.09,1878257.21,3338.12,550789.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','109',2165,'9','2',1246771.95,1246771.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','109',2166,'10','2',1218852.98,1221639.44,2786.46,2312761.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','109',2167,'11','3',538846.51,539467.44,620.93,465696.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','109',2168,'12','1',2068689.71,2071051.82,2362.11,389748.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','109',2169,'13','1',1302744.83,1302744.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','109',2170,'14','1',1438347.45,1440397.91,2050.46,338325.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','109',2171,'15','1',1607550.72,1610341.36,2790.64,460455.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','109',2172,'16','1',2361418.78,2365843.31,4424.53,730047.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','109',2173,'17','1',1504451.81,1504451.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','109',2174,'18','1',1215201.57,1219459.39,4257.82,702540.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','109',2175,'19','1',1334908.72,1335591.29,682.57,112624.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','109',2176,'20','1',1795986.38,1799891.81,3905.43,644395.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','109',2177,'21','1',1325023.98,1329673.35,4649.37,767146.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','109',2178,'22','1',1749396.70,1753244.40,3847.70,634870.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','109',2179,'23','1',1492513.24,1496104.15,3590.91,592500.15,0.00,0.00,0.00,0.00,0.00),('21','220','4','109',2180,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','110',2181,'1','1',2139982.54,2141919.35,1936.81,319573.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','110',2182,'2','1',1784427.75,1785991.40,1563.65,258002.91,0.00,0.00,0.00,0.00,0.00),('21','220','1','110',2183,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','110',2184,'4','1',1878257.21,1880851.47,2594.26,428052.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','110',2185,'9','2',1246771.95,1246771.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','110',2186,'10','2',1221639.44,1224100.94,2461.50,2043045.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','110',2187,'11','3',539467.44,540358.29,890.85,668137.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','110',2188,'12','1',2071051.82,2071722.07,670.25,110591.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','110',2189,'13','1',1302744.83,1304897.59,2152.76,355205.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','110',2190,'14','1',1440397.91,1442242.89,1844.98,304421.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','110',2191,'15','1',1610341.36,1611917.03,1575.67,259985.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','110',2192,'16','1',2365843.31,2369102.88,3259.57,537829.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','110',2193,'17','1',1504451.81,1507344.76,2892.95,477336.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','110',2194,'18','1',1219459.39,1222202.42,2743.03,452599.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','110',2195,'19','1',1335591.29,1338063.04,2471.75,407838.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','110',2196,'20','1',1799891.81,1803796.75,3904.94,644315.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','110',2197,'21','1',1329673.35,1333475.73,3802.38,627392.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','110',2198,'22','1',1753244.40,1756401.47,3157.07,520916.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','110',2199,'23','1',1496104.15,1499199.25,3095.10,510691.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','110',2200,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','111',2201,'1','1',2141919.35,2144663.62,2744.27,452804.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','111',2202,'2','1',1785991.40,1788533.74,2542.34,419486.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','111',2203,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','111',2204,'4','1',1880851.47,1883971.71,3120.24,514839.60,0.00,0.00,0.00,0.00,0.00),('21','220','3','111',2205,'9','2',1246771.95,1248426.61,1654.66,1373367.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','111',2206,'10','2',1224100.94,1231346.08,7245.14,6013466.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','111',2207,'11','3',540358.29,541341.07,982.78,737087.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','111',2208,'12','1',2071722.07,2074241.82,2519.75,415758.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','111',2209,'13','1',1304897.59,1306557.71,1660.12,273919.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','111',2210,'14','1',1442242.89,1443847.44,1604.55,264750.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','111',2211,'15','1',1611917.03,1614492.11,2575.08,424888.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','111',2212,'16','1',2369102.88,2374166.64,5063.76,835520.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','111',2213,'17','1',1507344.76,1509971.81,2627.05,433463.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','111',2214,'18','1',1222202.42,1224931.64,2729.22,450321.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','111',2215,'19','1',1338063.04,1342323.90,4260.86,703041.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','111',2216,'20','1',1803796.75,1808886.72,5089.97,839845.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','111',2217,'21','1',1333475.73,1336551.59,3075.86,507516.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','111',2218,'22','1',1756401.47,1761274.02,4872.55,803970.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','111',2219,'23','1',1499199.25,1502676.17,3476.92,573691.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','111',2220,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','112',2221,'1','1',2144663.62,2146905.82,2242.20,369963.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','112',2222,'2','1',1788533.74,1790821.65,2287.91,377505.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','112',2223,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','112',2224,'4','1',1883971.71,1886611.34,2639.63,435538.95,0.00,0.00,0.00,0.00,0.00),('21','220','3','112',2225,'9','2',1248426.61,1248426.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','112',2226,'10','2',1231346.08,1235079.06,3732.98,3098373.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','112',2227,'11','3',541341.07,542712.76,1371.69,1028769.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','112',2228,'12','1',2074241.82,2075826.88,1585.06,261534.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','112',2229,'13','1',1306557.71,1308564.72,2007.01,331156.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','112',2230,'14','1',1443847.44,1445568.89,1721.45,284039.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','112',2231,'15','1',1614492.11,1617676.56,3184.45,525434.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','112',2232,'16','1',2374166.64,2378263.73,4097.09,676019.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','112',2233,'17','1',1509971.81,1513014.96,3043.15,502119.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','112',2234,'18','1',1224931.64,1228579.63,3647.99,601918.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','112',2235,'19','1',1342323.90,1345548.05,3224.15,531984.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','112',2236,'20','1',1808886.72,1813360.26,4473.54,738134.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','112',2237,'21','1',1336551.59,1339914.90,3363.31,554946.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','112',2238,'22','1',1761274.02,1765365.38,4091.36,675074.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','112',2239,'23','1',1502676.17,1506534.12,3857.95,636561.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','112',2240,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','113',2241,'1','1',2146905.82,2147869.91,964.09,159074.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','113',2242,'2','1',1790821.65,1792041.62,1219.97,201295.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','113',2243,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','113',2244,'4','1',1886611.34,1888514.48,1903.14,314018.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','113',2245,'9','2',1248426.61,1248827.37,400.76,332630.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','113',2246,'10','2',1235079.06,1240513.76,5434.70,4510801.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','113',2247,'11','3',542712.76,543707.99,995.22,746418.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','113',2248,'12','1',2075826.88,2077195.30,1368.42,225789.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','113',2249,'13','1',1308564.72,1309598.69,1033.97,170605.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','113',2250,'14','1',1445568.89,1446750.55,1181.66,194973.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','113',2251,'15','1',1617676.56,1619265.73,1589.17,262213.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','113',2252,'16','1',2378263.73,2382572.60,4308.87,710963.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','113',2253,'17','1',1513014.96,1516526.86,3511.90,579463.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','113',2254,'18','1',1228579.63,1231827.71,3248.08,535933.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','113',2255,'19','1',1345548.05,1349521.96,3973.91,655695.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','113',2256,'20','1',1813360.26,1817513.36,4153.10,685261.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','113',2257,'21','1',1339914.90,1344142.25,4227.35,697512.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','113',2258,'22','1',1765365.38,1769420.54,4055.16,669101.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','113',2259,'23','1',1506534.12,1511496.28,4962.16,818756.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','113',2260,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','114',2261,'1','1',2147869.91,2148576.62,706.71,116607.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','114',2262,'2','1',1792041.62,1792926.87,885.25,146066.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','114',2263,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','114',2264,'4','1',1888514.48,1889745.35,1230.87,203093.55,0.00,0.00,0.00,0.00,0.00),('21','220','3','114',2265,'9','2',1248827.37,1248827.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','114',2266,'10','2',1240513.76,1245414.83,4901.07,4067888.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','114',2267,'11','3',543707.99,544497.67,789.68,592260.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','114',2268,'12','1',2077195.30,2078238.46,1043.16,172121.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','114',2269,'13','1',1309598.69,1310136.82,538.13,88791.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','114',2270,'14','1',1446750.55,1446750.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','114',2271,'15','1',1619265.73,1620133.40,867.67,143165.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','114',2272,'16','1',2382572.60,2384630.49,2057.89,339551.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','114',2273,'17','1',1516526.86,1518443.51,1916.65,316247.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','114',2274,'18','1',1231827.71,1233752.58,1924.87,317603.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','114',2275,'19','1',1349521.96,1351787.03,2265.07,373736.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','114',2276,'20','1',1817513.36,1820304.79,2791.43,460585.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','114',2277,'21','1',1344142.25,1346067.76,1925.51,317709.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','114',2278,'22','1',1769420.54,1771417.73,1997.19,329536.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','114',2279,'23','1',1511496.28,1513733.29,2237.01,369106.65,0.00,0.00,0.00,0.00,0.00),('21','220','4','114',2280,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','115',2281,'1','1',2148576.62,2150284.80,1708.18,281849.86,0.00,0.00,0.00,0.00,0.00),('21','220','1','115',2282,'2','1',1792926.87,1794517.60,1590.73,262470.45,0.00,0.00,0.00,0.00,0.00),('21','220','1','115',2283,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','115',2284,'4','1',1889745.35,1892131.15,2385.80,393657.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','115',2285,'9','2',1248827.37,1248827.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','115',2286,'10','2',1245414.83,1251626.19,6211.36,5155428.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','115',2287,'11','3',544497.67,545312.67,815.00,611246.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','115',2288,'12','1',2078238.46,2080104.20,1865.74,307847.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','115',2289,'13','1',1310136.82,1311480.61,1343.79,221725.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','115',2290,'14','1',1446750.55,1448494.49,1743.94,287750.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','115',2291,'15','1',1620133.40,1622460.52,2327.12,383974.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','115',2292,'16','1',2384630.49,2388256.72,3626.23,598327.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','115',2293,'17','1',1518443.51,1521169.41,2725.90,449773.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','115',2294,'18','1',1233752.58,1236299.16,2546.58,420185.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','115',2295,'19','1',1351787.03,1354581.58,2794.55,461100.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','115',2296,'20','1',1820304.79,1824291.70,3986.91,657840.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','115',2297,'21','1',1346067.76,1348813.50,2745.74,453047.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','115',2298,'22','1',1771417.73,1774981.58,3563.85,588035.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','115',2299,'23','1',1513733.29,1517567.92,3834.63,632713.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','115',2300,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','116',2301,'1','1',2150284.80,2150284.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','116',2302,'2','1',1794517.60,1797565.24,3047.64,502860.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','116',2303,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','116',2304,'4','1',1892131.15,1895385.33,3254.18,536939.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','116',2305,'9','2',1248827.37,1248827.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','116',2306,'10','2',1251626.19,1254350.94,2724.75,2261542.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','116',2307,'11','3',545312.67,546281.87,969.20,726902.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','116',2308,'12','1',2080104.20,2082755.51,2651.31,437466.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','116',2309,'13','1',1311480.61,1311480.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','116',2310,'14','1',1448494.49,1450951.67,2457.18,405434.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','116',2311,'15','1',1622460.52,1623210.77,750.25,123791.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','116',2312,'16','1',2388256.72,2392389.60,4132.88,681925.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','116',2313,'17','1',1521169.41,1524684.72,3515.31,580026.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','116',2314,'18','1',1236299.16,1240066.23,3767.07,621566.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','116',2315,'19','1',1354581.58,1357521.44,2939.86,485076.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','116',2316,'20','1',1824291.70,1828151.84,3860.14,636923.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','116',2317,'21','1',1348813.50,1352154.59,3341.09,551279.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','116',2318,'22','1',1774981.58,1778860.41,3878.83,640006.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','116',2319,'23','1',1517567.92,1520346.31,2778.39,458434.35,0.00,0.00,0.00,0.00,0.00),('21','220','4','116',2320,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','117',2321,'1','1',2150284.80,2153536.98,3252.18,536609.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','117',2322,'2','1',1797565.24,1799790.51,2225.27,367169.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','117',2323,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','117',2324,'4','1',1895385.33,1899440.12,4054.79,669040.35,0.00,0.00,0.00,0.00,0.00),('21','220','3','117',2325,'9','2',1248827.37,1248827.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','117',2326,'10','2',1254350.94,1258926.85,4575.91,3798005.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','117',2327,'11','3',546281.87,547232.19,950.32,712740.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','117',2328,'12','1',2082755.51,2085582.82,2827.31,466506.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','117',2329,'13','1',1311480.61,1311952.22,471.61,77815.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','117',2330,'14','1',1450951.67,1450951.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','117',2331,'15','1',1623210.77,1626746.60,3535.83,583411.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','117',2332,'16','1',2392389.60,2396771.06,4381.46,722940.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','117',2333,'17','1',1524684.72,1527907.49,3222.77,531757.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','117',2334,'18','1',1240066.23,1242923.77,2857.54,471494.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','117',2335,'19','1',1357521.44,1360876.27,3354.83,553546.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','117',2336,'20','1',1828151.84,1832355.83,4203.99,693658.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','117',2337,'21','1',1352154.59,1355374.21,3219.62,531237.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','117',2338,'22','1',1778860.41,1782894.10,4033.69,665558.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','117',2339,'23','1',1520346.31,1523989.11,3642.80,601062.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','117',2340,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','118',2341,'1','1',2153536.98,2155960.02,2423.04,399801.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','118',2342,'2','1',1799790.51,1801939.53,2149.02,354588.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','118',2343,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','118',2344,'4','1',1899440.12,1902209.60,2769.48,456964.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','118',2345,'9','2',1248827.37,1252178.75,3351.38,2781645.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','118',2346,'10','2',1258926.85,1262728.89,3802.04,3155693.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','118',2347,'11','3',547232.19,548277.51,1045.32,783990.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','118',2348,'12','1',2085582.82,2087544.03,1961.21,323599.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','118',2349,'13','1',1311952.22,1313052.42,1100.20,181533.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','118',2350,'14','1',1450951.67,1450951.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','118',2351,'15','1',1626746.60,1629806.27,3059.67,504845.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','118',2352,'16','1',2396771.06,2400371.88,3600.82,594135.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','118',2353,'17','1',1527907.49,1530797.08,2889.59,476782.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','118',2354,'18','1',1242923.77,1245847.36,2923.59,482392.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','118',2355,'19','1',1360876.27,1363506.83,2630.56,434042.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','118',2356,'20','1',1832355.83,1836560.02,4204.19,693691.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','118',2357,'21','1',1355374.21,1358741.26,3367.05,555563.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','118',2358,'22','1',1782894.10,1786252.88,3358.78,554198.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','118',2359,'23','1',1523989.11,1527621.47,3632.36,599339.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','118',2360,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','119',2361,'1','1',2155960.02,2157476.09,1516.07,250151.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','119',2362,'2','1',1801939.53,1805050.35,3110.82,513285.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','119',2363,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','119',2364,'4','1',1902209.60,1905611.52,3401.92,561316.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','119',2365,'9','2',1252178.75,1252178.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','119',2366,'10','2',1262728.89,1265135.35,2406.46,1997361.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','119',2367,'11','3',548277.51,549773.63,1496.12,1122087.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','119',2368,'12','1',2087544.03,2090261.61,2717.58,448400.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','119',2369,'13','1',1313052.42,1314596.44,1544.02,254763.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','119',2370,'14','1',1450951.67,1450951.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','119',2371,'15','1',1629806.27,1634035.01,4228.74,697742.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','119',2372,'16','1',2400371.88,2404385.27,4013.39,662209.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','119',2373,'17','1',1530797.08,1534772.39,3975.31,655926.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','119',2374,'18','1',1245847.36,1248709.11,2861.75,472188.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','119',2375,'19','1',1363506.83,1367879.72,4372.89,721526.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','119',2376,'20','1',1836560.02,1839306.26,2746.24,453129.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','119',2377,'21','1',1358741.26,1363237.93,4496.67,741950.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','119',2378,'22','1',1786252.88,1790692.93,4440.05,732608.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','119',2379,'23','1',1527621.47,1532008.37,4386.90,723838.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','119',2380,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','120',2381,'1','1',2157476.09,2158856.11,1380.02,227703.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','120',2382,'2','1',1805050.35,1806804.94,1754.59,289507.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','120',2383,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','120',2384,'4','1',1905611.52,1908305.50,2693.98,444506.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','120',2385,'9','2',1252178.75,1252178.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','120',2386,'10','2',1265135.35,1268656.46,3521.11,2922521.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','120',2387,'11','3',549773.63,550499.32,725.69,544264.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','120',2388,'12','1',2090261.61,2092113.59,1851.98,305576.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','120',2389,'13','1',1314596.44,1316315.81,1719.37,283696.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','120',2390,'14','1',1450951.67,1450951.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','120',2391,'15','1',1634035.01,1637821.80,3786.79,624820.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','120',2392,'16','1',2404385.27,2408682.80,4297.53,709092.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','120',2393,'17','1',1534772.39,1537867.23,3094.84,510648.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','120',2394,'18','1',1248709.11,1251916.72,3207.61,529255.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','120',2395,'19','1',1367879.72,1371565.59,3685.87,608168.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','120',2396,'20','1',1839306.26,1843393.94,4087.68,674467.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','120',2397,'21','1',1363237.93,1366247.00,3009.07,496496.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','120',2398,'22','1',1790692.93,1793726.62,3033.69,500558.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','120',2399,'23','1',1532008.37,1535498.11,3489.74,575807.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','120',2400,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','121',2401,'1','1',2158856.11,2161276.28,2420.17,399328.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','121',2402,'2','1',1806804.94,1808983.46,2178.52,359455.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','121',2403,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','121',2404,'4','1',1908305.50,1912215.76,3910.26,645192.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','121',2405,'9','2',1252178.75,1252482.20,303.45,251863.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','121',2406,'10','2',1268656.46,1274221.00,5564.54,4618568.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','121',2407,'11','3',550499.32,551221.28,721.96,541472.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','121',2408,'12','1',2092113.59,2094574.68,2461.09,406079.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','121',2409,'13','1',1316315.81,1318125.24,1809.43,298555.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','121',2410,'14','1',1450951.67,1450951.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','121',2411,'15','1',1637821.80,1642356.35,4534.55,748200.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','121',2412,'16','1',2408682.80,2412285.42,3602.62,594432.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','121',2413,'17','1',1537867.23,1542296.35,4429.12,730804.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','121',2414,'18','1',1251916.72,1255887.12,3970.40,655116.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','121',2415,'19','1',1371565.59,1375507.74,3942.15,650454.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','121',2416,'20','1',1843393.94,1847465.56,4071.62,671817.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','121',2417,'21','1',1366247.00,1370182.86,3935.86,649416.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','121',2418,'22','1',1793726.62,1797335.01,3608.39,595384.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','121',2419,'23','1',1535498.11,1539636.34,4138.23,682807.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','121',2420,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','122',2421,'1','1',2161276.28,2162858.78,1582.50,261112.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','122',2422,'2','1',1808983.46,1810616.51,1633.05,269453.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','122',2423,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','122',2424,'4','1',1912215.76,1914417.53,2201.77,363292.05,0.00,0.00,0.00,0.00,0.00),('21','220','3','122',2425,'9','2',1252482.20,1252482.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','122',2426,'10','2',1274221.00,1275574.16,1353.16,1123122.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','122',2427,'11','3',551221.28,552496.92,1275.64,956728.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','122',2428,'12','1',2094574.68,2096176.82,1602.14,264353.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','122',2429,'13','1',1318125.24,1319363.90,1238.66,204378.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','122',2430,'14','1',1450951.67,1450951.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','122',2431,'15','1',1642356.35,1644106.04,1749.69,288698.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','122',2432,'16','1',2412285.42,2415241.86,2956.44,487812.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','122',2433,'17','1',1542296.35,1544959.72,2663.37,439456.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','122',2434,'18','1',1255887.12,1259158.32,3271.20,539748.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','122',2435,'19','1',1375507.74,1379085.16,3577.42,590274.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','122',2436,'20','1',1847465.56,1851443.60,3978.04,656376.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','122',2437,'21','1',1370182.86,1373235.81,3052.95,503736.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','122',2438,'22','1',1797335.01,1800268.42,2933.41,484012.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','122',2439,'23','1',1539636.34,1542914.16,3277.82,540840.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','122',2440,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','123',2441,'1','1',2162858.78,2163174.55,315.77,52102.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','123',2442,'2','1',1810616.51,1810960.57,344.06,56769.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','123',2443,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','123',2444,'4','1',1914417.53,1915818.63,1401.10,231181.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','123',2445,'9','2',1252482.20,1252482.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','123',2446,'10','2',1275574.16,1276402.64,828.48,687638.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','123',2447,'11','3',552496.92,553140.45,643.53,482650.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','123',2448,'12','1',2096176.82,2096637.86,461.04,76071.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','123',2449,'13','1',1319363.90,1319791.35,427.45,70529.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','123',2450,'14','1',1450951.67,1450951.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','123',2451,'15','1',1644106.04,1644551.67,445.63,73528.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','123',2452,'16','1',2415241.86,2415649.16,407.30,67204.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','123',2453,'17','1',1544959.72,1545158.72,199.00,32835.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','123',2454,'18','1',1259158.32,1259527.81,369.49,60965.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','123',2455,'19','1',1379085.16,1379600.56,515.40,85041.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','123',2456,'20','1',1851443.60,1852140.91,697.31,115056.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','123',2457,'21','1',1373235.81,1373529.85,294.04,48516.43,0.00,0.00,0.00,0.00,0.00),('21','220','2','123',2458,'22','1',1800268.42,1800610.81,342.39,56494.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','123',2459,'23','1',1542914.16,1543364.59,450.43,74320.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','123',2460,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','124',2461,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','124',2462,'2','1',1810960.57,1813730.96,2770.39,512522.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','124',2463,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','124',2464,'4','1',1915818.63,1918968.87,3150.24,582794.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','124',2465,'9','2',1252482.20,1252482.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','124',2466,'10','2',1276402.64,1277376.11,973.47,807980.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','124',2467,'11','3',553140.45,553861.48,721.03,540774.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','124',2468,'12','1',2096637.86,2098936.12,2298.26,425178.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','124',2469,'13','1',1319791.35,1321682.91,1891.56,349938.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','124',2470,'14','1',1450951.67,1450951.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','124',2471,'15','1',1644551.67,1648428.02,3876.35,717124.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','124',2472,'16','1',2415649.16,2420590.85,4941.69,914212.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','124',2473,'17','1',1545158.72,1548885.57,3726.85,689467.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','124',2474,'18','1',1259527.81,1263253.80,3725.99,689308.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','124',2475,'19','1',1379600.56,1383301.78,3701.22,684725.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','124',2476,'20','1',1852140.91,1856814.60,4673.69,864632.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','124',2477,'21','1',1373529.85,1377241.29,3711.44,686616.40,0.00,0.00,0.00,0.00,0.00),('21','220','2','124',2478,'22','1',1800610.81,1804400.40,3789.59,701074.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','124',2479,'23','1',1543364.59,1547512.90,4148.31,767437.35,0.00,0.00,0.00,0.00,0.00),('21','220','4','124',2480,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','125',2481,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','125',2482,'2','1',1813730.96,1814022.49,291.53,53933.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','125',2483,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','125',2484,'4','1',1918968.87,1919387.21,418.34,77392.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','125',2485,'9','2',1252482.20,1252482.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','125',2486,'10','2',1277376.11,1277376.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','125',2487,'11','3',553861.48,553861.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','125',2488,'12','1',2098936.12,2099101.21,165.09,30541.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','125',2489,'13','1',1321682.91,1321894.45,211.54,39134.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','125',2490,'14','1',1450951.67,1451208.56,256.89,47524.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','125',2491,'15','1',1648428.02,1648660.31,232.29,42973.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','125',2492,'16','1',2420590.85,2420808.64,217.79,40291.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','125',2493,'17','1',1548885.57,1549161.36,275.79,51021.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','125',2494,'18','1',1263253.80,1263470.14,216.34,40022.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','125',2495,'19','1',1383301.78,1383451.04,149.26,27613.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','125',2496,'20','1',1856814.60,1857145.92,331.32,61294.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','125',2497,'21','1',1377241.29,1377410.19,168.90,31246.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','125',2498,'22','1',1804400.40,1804715.91,315.51,58369.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','125',2499,'23','1',1547512.90,1547711.40,198.50,36722.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','125',2500,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','126',2501,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','126',2502,'2','1',1814022.49,1821639.68,7617.19,1256836.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','126',2503,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','126',2504,'4','1',1919387.21,1929144.10,9756.89,1609886.85,0.00,0.00,0.00,0.00,0.00),('21','220','3','126',2505,'9','2',1252482.20,1252532.20,50.00,41500.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','126',2506,'10','2',1277376.11,1278769.85,1393.74,1156804.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','126',2507,'11','3',553861.48,554676.74,815.26,611445.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','126',2508,'12','1',2099101.21,2104495.92,5394.71,890127.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','126',2509,'13','1',1321894.45,1327255.96,5361.51,884649.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','126',2510,'14','1',1451208.56,1452027.54,818.98,135131.70,0.00,0.00,0.00,0.00,0.00),('21','220','1','126',2511,'15','1',1648660.31,1655717.57,7057.26,1164447.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','126',2512,'16','1',2420808.64,2426653.43,5844.79,964390.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','126',2513,'17','1',1549161.36,1553581.45,4420.09,729314.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','126',2514,'18','1',1263470.14,1267570.11,4099.97,676495.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','126',2515,'19','1',1383451.04,1388021.78,4570.74,754172.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','126',2516,'20','1',1857145.92,1862872.03,5726.11,944808.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','126',2517,'21','1',1377410.19,1382040.16,4629.97,763945.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','126',2518,'22','1',1804715.91,1808741.44,4025.53,664212.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','126',2519,'23','1',1547711.40,1552523.03,4811.63,793918.95,0.00,0.00,0.00,0.00,0.00),('21','220','4','126',2520,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','127',2521,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','127',2522,'2','1',1821639.68,1828187.65,6547.97,1080415.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','127',2523,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','127',2524,'4','1',1929144.10,1936129.71,6985.61,1152625.65,0.00,0.00,0.00,0.00,0.00),('21','220','3','127',2525,'9','2',1252532.20,1252532.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','127',2526,'10','2',1278769.85,1283245.76,4475.91,3715005.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','127',2527,'11','3',554676.74,555402.65,725.91,544433.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','127',2528,'12','1',2104495.92,2110566.14,6070.22,1001586.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','127',2529,'13','1',1327255.96,1333514.97,6259.01,1032736.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','127',2530,'14','1',1452027.54,1457770.20,5742.66,947538.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','127',2531,'15','1',1655717.57,1660738.38,5020.81,828433.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','127',2532,'16','1',2426653.43,2432633.30,5979.87,986678.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','127',2533,'17','1',1553581.45,1557765.17,4183.72,690313.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','127',2534,'18','1',1267570.11,1271724.60,4154.49,685490.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','127',2535,'19','1',1388021.78,1392768.62,4746.84,783228.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','127',2536,'20','1',1862872.03,1867703.00,4830.97,797110.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','127',2537,'21','1',1382040.16,1387277.17,5237.01,864106.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','127',2538,'22','1',1808741.44,1814546.59,5805.15,957849.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','127',2539,'23','1',1552523.03,1557605.36,5082.33,838584.45,0.00,0.00,0.00,0.00,0.00),('21','220','4','127',2540,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','128',2541,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','128',2542,'2','1',1828187.65,1834859.17,6671.52,1234231.20,0.00,0.00,0.00,0.00,0.00),('21','220','1','128',2543,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','128',2544,'4','1',1936129.71,1942705.96,6576.25,1216606.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','128',2545,'9','2',1252532.20,1252532.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','128',2546,'10','2',1283245.76,1285800.33,2554.57,2120293.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','128',2547,'11','3',555402.65,555911.64,508.99,381742.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','128',2548,'12','1',2110566.14,2116149.00,5582.86,1032829.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','128',2549,'13','1',1333514.97,1339086.33,5571.36,1030701.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','128',2550,'14','1',1457770.20,1463009.16,5238.96,969207.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','128',2551,'15','1',1660738.38,1665046.61,4308.23,797022.55,0.00,0.00,0.00,0.00,0.00),('21','220','2','128',2552,'16','1',2432633.30,2437207.21,4573.91,846173.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','128',2553,'17','1',1557765.17,1560444.29,2679.12,495637.20,0.00,0.00,0.00,0.00,0.00),('21','220','2','128',2554,'18','1',1271724.60,1275287.16,3562.56,659073.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','128',2555,'19','1',1392768.62,1395106.81,2338.19,432565.15,0.00,0.00,0.00,0.00,0.00),('21','220','2','128',2556,'20','1',1867703.00,1868630.71,927.71,171626.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','128',2557,'21','1',1387277.17,1392659.38,5382.21,995708.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','128',2558,'22','1',1814546.59,1816659.28,2112.69,390847.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','128',2559,'23','1',1557605.36,1560873.14,3267.78,604539.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','128',2560,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','129',2561,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','129',2562,'2','1',1834859.17,1838456.11,3596.94,665433.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','129',2563,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','129',2564,'4','1',1942705.96,1945664.36,2958.40,547304.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','129',2565,'9','2',1252532.20,1252532.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','129',2566,'10','2',1285800.33,1288482.30,2681.97,2226035.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','129',2567,'11','3',555911.64,556433.12,521.48,391113.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','129',2568,'12','1',2116149.00,2118559.28,2410.28,445901.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','129',2569,'13','1',1339086.33,1341471.96,2385.63,441341.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','129',2570,'14','1',1463009.16,1465683.85,2674.69,494817.65,0.00,0.00,0.00,0.00,0.00),('21','220','1','129',2571,'15','1',1665046.61,1667854.46,2807.85,519452.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','129',2572,'16','1',2437207.21,2441145.15,3937.94,728518.90,0.00,0.00,0.00,0.00,0.00),('21','220','2','129',2573,'17','1',1560444.29,1563717.35,3273.06,605516.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','129',2574,'18','1',1275287.16,1278693.22,3406.06,630121.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','129',2575,'19','1',1395106.81,1397840.76,2733.95,505780.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','129',2576,'20','1',1868630.71,1872195.58,3564.87,659500.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','129',2577,'21','1',1392659.38,1396399.24,3739.86,691874.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','129',2578,'22','1',1816659.28,1819615.98,2956.70,546989.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','129',2579,'23','1',1560873.14,1564012.52,3139.38,580785.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','129',2580,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','130',2581,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','130',2582,'2','1',1838456.11,1840869.14,2413.03,446410.55,0.00,0.00,0.00,0.00,0.00),('21','220','1','130',2583,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','130',2584,'4','1',1945664.36,1948691.14,3026.78,559954.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','130',2585,'9','2',1252532.20,1252532.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','130',2586,'10','2',1288482.30,1290264.19,1781.89,1478968.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','130',2587,'11','3',556433.12,557372.92,939.80,704848.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','130',2588,'12','1',2118559.28,2120456.69,1897.41,351020.85,0.00,0.00,0.00,0.00,0.00),('21','220','1','130',2589,'13','1',1341471.96,1342926.66,1454.70,269119.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','130',2590,'14','1',1465683.85,1467483.73,1799.88,332977.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','130',2591,'15','1',1667854.46,1670243.27,2388.81,441929.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','130',2592,'16','1',2441145.15,2445900.64,4755.49,879765.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','130',2593,'17','1',1563717.35,1566331.06,2613.71,483536.35,0.00,0.00,0.00,0.00,0.00),('21','220','2','130',2594,'18','1',1278693.22,1280440.31,1747.09,323211.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','130',2595,'19','1',1397840.76,1401461.69,3620.93,669872.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','130',2596,'20','1',1872195.58,1876520.56,4324.98,800121.30,0.00,0.00,0.00,0.00,0.00),('21','220','2','130',2597,'21','1',1396399.24,1399766.45,3367.21,622933.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','130',2598,'22','1',1819615.98,1823201.99,3586.01,663411.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','130',2599,'23','1',1564012.52,1566713.65,2701.13,499709.05,0.00,0.00,0.00,0.00,0.00),('21','220','4','130',2600,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','131',2601,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','131',2602,'2','1',1840869.14,1840869.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','131',2603,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','131',2604,'4','1',1948691.14,1948691.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','131',2605,'9','2',1252532.20,1252532.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','131',2606,'10','2',1290264.19,1292257.86,1993.67,1654746.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','131',2607,'11','3',557372.92,558014.69,641.77,481326.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','131',2608,'12','1',2120456.69,2120456.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','131',2609,'13','1',1342926.66,1342926.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','131',2610,'14','1',1467483.73,1467483.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','131',2611,'15','1',1670243.27,1670418.09,174.82,32341.70,0.00,0.00,0.00,0.00,0.00),('21','220','2','131',2612,'16','1',2445900.64,2445900.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','131',2613,'17','1',1566331.06,1566331.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','131',2614,'18','1',1280440.31,1280440.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','131',2615,'19','1',1401461.69,1402481.77,1020.08,188714.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','131',2616,'20','1',1876520.56,1876520.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','131',2617,'21','1',1399766.45,1399766.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','131',2618,'22','1',1823201.99,1823201.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','131',2619,'23','1',1566713.65,1566713.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','131',2620,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','132',2621,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','132',2622,'2','1',1840869.14,1845060.69,4191.55,775436.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','132',2623,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','132',2624,'4','1',1948691.14,1953690.72,4999.58,924922.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','132',2625,'9','2',1252532.20,1253523.15,990.95,822488.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','132',2626,'10','2',1292257.86,1297188.27,4930.41,4092240.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','132',2627,'11','3',558014.69,559563.36,1548.67,1161501.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','132',2628,'12','1',2120456.69,2123617.43,3160.74,584736.90,0.00,0.00,0.00,0.00,0.00),('21','220','1','132',2629,'13','1',1342926.66,1343490.77,564.11,104360.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','132',2630,'14','1',1467483.73,1470027.39,2543.66,470577.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','132',2631,'15','1',1670418.09,1673643.45,3225.36,596691.60,0.00,0.00,0.00,0.00,0.00),('21','220','2','132',2632,'16','1',2445900.64,2451019.39,5118.75,946968.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','132',2633,'17','1',1566331.06,1570006.47,3675.41,679950.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','132',2634,'18','1',1280440.31,1284489.98,4049.67,749188.95,0.00,0.00,0.00,0.00,0.00),('21','220','2','132',2635,'19','1',1402481.77,1406764.05,4282.28,792221.80,0.00,0.00,0.00,0.00,0.00),('21','220','2','132',2636,'20','1',1876520.56,1881742.09,5221.53,965983.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','132',2637,'21','1',1399766.45,1403877.71,4111.26,760583.10,0.00,0.00,0.00,0.00,0.00),('21','220','2','132',2638,'22','1',1823201.99,1828439.52,5237.53,968943.05,0.00,0.00,0.00,0.00,0.00),('21','220','2','132',2639,'23','1',1566713.65,1571128.26,4414.61,816702.85,0.00,0.00,0.00,0.00,0.00),('21','220','4','132',2640,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','133',2641,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','133',2642,'2','1',1845060.69,1847780.64,2719.95,475991.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','133',2643,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','133',2644,'4','1',1953690.72,1957224.64,3533.92,618436.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','133',2645,'9','2',1253523.15,1253523.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','133',2646,'10','2',1297188.27,1299462.79,2274.52,1887851.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','133',2647,'11','3',559563.36,560895.55,1332.19,999139.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','133',2648,'12','1',2123617.43,2126275.36,2657.93,465137.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','133',2649,'13','1',1343490.77,1345864.53,2373.76,415408.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','133',2650,'14','1',1470027.39,1472420.22,2392.83,418745.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','133',2651,'15','1',1673643.45,1676001.53,2358.08,412664.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','133',2652,'16','1',2451019.39,2455395.45,4376.06,765810.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','133',2653,'17','1',1570006.47,1572769.50,2763.03,483530.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','133',2654,'18','1',1284489.98,1288025.65,3535.67,618742.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','133',2655,'19','1',1406764.05,1409705.24,2941.19,514708.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','133',2656,'20','1',1881742.09,1886636.24,4894.15,856476.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','133',2657,'21','1',1403877.71,1406977.57,3099.86,542475.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','133',2658,'22','1',1828439.52,1831811.96,3372.44,590177.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','133',2659,'23','1',1571128.26,1575775.32,4647.06,813235.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','133',2660,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','134',2661,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','134',2662,'2','1',1847780.64,1857345.84,9565.20,1673910.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','134',2663,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','134',2664,'4','1',1957224.64,1968451.46,11226.82,1964693.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','134',2665,'9','2',1253523.15,1253523.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','134',2666,'10','2',1299462.79,1302905.30,3442.51,2857283.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','134',2667,'11','3',560895.55,561354.75,459.20,344401.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','134',2668,'12','1',2126275.36,2133839.69,7564.33,1323757.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','134',2669,'13','1',1345864.53,1348246.18,2381.65,416788.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','134',2670,'14','1',1472420.22,1481361.97,8941.75,1564806.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','134',2671,'15','1',1676001.53,1676002.33,0.80,140.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','134',2672,'16','1',2455395.45,2461228.86,5833.41,1020846.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','134',2673,'17','1',1572769.50,1578314.06,5544.56,970298.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','134',2674,'18','1',1288025.65,1293611.76,5586.11,977569.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','134',2675,'19','1',1409705.24,1412056.64,2351.40,411495.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','134',2676,'20','1',1886636.24,1893409.21,6772.97,1185269.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','134',2677,'21','1',1406977.57,1413682.78,6705.21,1173411.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','134',2678,'22','1',1831811.96,1837275.87,5463.91,956184.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','134',2679,'23','1',1575775.32,1582158.59,6383.27,1117072.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','134',2680,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','135',2681,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','135',2682,'2','1',1857345.84,1862547.88,5202.04,910357.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','135',2683,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','135',2684,'4','1',1968451.46,1974889.21,6437.75,1126606.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','135',2685,'9','2',1253523.15,1253523.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','135',2686,'10','2',1302905.30,1306251.16,3345.86,2777063.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','135',2687,'11','3',561354.75,561705.09,350.34,262752.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','135',2688,'12','1',2133839.69,2137664.09,3824.40,669270.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','135',2689,'13','1',1348246.18,1351196.81,2950.63,516360.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','135',2690,'14','1',1481361.97,1486770.10,5408.13,946422.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','135',2691,'15','1',1676002.33,1676002.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','135',2692,'16','1',2461228.86,2465705.67,4476.81,783441.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','135',2693,'17','1',1578314.06,1581290.64,2976.58,520901.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','135',2694,'18','1',1293611.76,1298485.86,4874.10,852967.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','135',2695,'19','1',1412056.64,1412056.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','135',2696,'20','1',1893409.21,1898396.01,4986.80,872690.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','135',2697,'21','1',1413682.78,1418296.71,4613.93,807437.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','135',2698,'22','1',1837275.87,1842053.05,4777.18,836006.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','135',2699,'23','1',1582158.59,1586485.94,4327.35,757286.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','135',2700,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','136',2701,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','136',2702,'2','1',1862547.88,1865507.10,2959.22,517863.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','136',2703,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','136',2704,'4','1',1974889.21,1979724.54,4835.33,846182.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','136',2705,'9','2',1253523.15,1255023.15,1500.00,1222500.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','136',2706,'10','2',1306251.16,1312692.62,6441.46,5249789.90,0.00,0.00,0.00,0.00,0.00),('21','220','4','136',2707,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','136',2708,'12','1',2137664.09,2141003.88,3339.79,584463.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','136',2709,'13','1',1351196.81,1354245.13,3048.32,533456.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','136',2710,'14','1',1486770.10,1490484.13,3714.03,649955.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','136',2711,'15','1',1676002.33,1676002.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','136',2712,'16','1',2465705.67,2470260.74,4555.07,797137.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','136',2713,'17','1',1581290.64,1584243.33,2952.69,516720.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','136',2714,'18','1',1298485.86,1302642.11,4156.25,727343.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','136',2715,'19','1',1412056.64,1415809.37,3752.73,656727.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','136',2716,'20','1',1898396.01,1904462.47,6066.46,1061630.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','136',2717,'21','1',1418296.71,1422685.77,4389.06,768085.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','136',2718,'22','1',1842053.05,1846230.25,4177.20,731010.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','136',2719,'23','1',1586485.94,1590830.86,4344.92,760361.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','136',2720,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','137',2721,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','137',2722,'2','1',1865507.10,1868985.73,3478.63,608760.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','137',2723,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','137',2724,'4','1',1979724.54,1983186.30,3461.76,605808.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','137',2725,'9','2',1255023.15,1255023.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','137',2726,'10','2',1312692.62,1316707.83,4015.21,3272396.15,0.00,0.00,0.00,0.00,0.00),('21','220','4','137',2727,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','137',2728,'12','1',2141003.88,2142895.66,1891.78,331061.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','137',2729,'13','1',1354245.13,1356447.73,2202.60,385455.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','137',2730,'14','1',1490484.13,1494793.38,4309.25,754118.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','137',2731,'15','1',1676002.33,1676002.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','137',2732,'16','1',2470260.74,2474775.87,4515.13,790147.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','137',2733,'17','1',1584243.33,1587274.04,3030.71,530374.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','137',2734,'18','1',1302642.11,1306078.67,3436.56,601398.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','137',2735,'19','1',1415809.37,1419073.31,3263.94,571189.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','137',2736,'20','1',1904462.47,1908773.97,4311.50,754512.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','137',2737,'21','1',1422685.77,1426613.38,3927.61,687331.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','137',2738,'22','1',1846230.25,1850099.06,3868.81,677041.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','137',2739,'23','1',1590830.86,1595380.88,4550.02,796253.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','137',2740,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','138',2741,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','138',2742,'2','1',1868985.73,1871881.21,2895.48,506709.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','138',2743,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','138',2744,'4','1',1983186.30,1986745.22,3558.92,622811.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','138',2745,'9','2',1255023.15,1255023.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','138',2746,'10','2',1316707.83,1318215.71,1507.88,1228922.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','138',2747,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','138',2748,'12','1',2142895.66,2145351.59,2455.93,429787.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','138',2749,'13','1',1356447.73,1358867.72,2419.99,423498.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','138',2750,'14','1',1494793.38,1498289.94,3496.56,611898.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','138',2751,'15','1',1676002.33,1676002.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','138',2752,'16','1',2474775.87,2478347.72,3571.85,625073.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','138',2753,'17','1',1587274.04,1590862.40,3588.36,627963.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','138',2754,'18','1',1306078.67,1307122.71,1044.04,182707.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','138',2755,'19','1',1419073.31,1423267.71,4194.40,734020.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','138',2756,'20','1',1908773.97,1912362.57,3588.60,628005.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','138',2757,'21','1',1426613.38,1430321.06,3707.68,648844.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','138',2758,'22','1',1850099.06,1853920.39,3821.33,668732.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','138',2759,'23','1',1595380.88,1598809.50,3428.62,600008.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','138',2760,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','139',2761,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','139',2762,'2','1',1871881.21,1875363.30,3482.09,609365.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','139',2763,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','139',2764,'4','1',1986745.22,1991669.51,4924.29,861750.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','139',2765,'9','2',1255023.15,1255023.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','139',2766,'10','2',1318215.71,1320930.10,2714.39,2198655.90,0.00,0.00,0.00,0.00,0.00),('21','220','4','139',2767,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','139',2768,'12','1',2145351.59,2148348.14,2996.55,524396.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','139',2769,'13','1',1358867.72,1360479.47,1611.75,282056.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','139',2770,'14','1',1498289.94,1501509.26,3219.32,563381.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','139',2771,'15','1',1676002.33,1676002.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','139',2772,'16','1',2478347.72,2483121.49,4773.77,835409.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','139',2773,'17','1',1590862.40,1593867.29,3004.89,525855.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','139',2774,'18','1',1307122.71,1311217.21,4094.50,716537.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','139',2775,'19','1',1423267.71,1426711.00,3443.29,602575.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','139',2776,'20','1',1912362.57,1916610.17,4247.60,743330.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','139',2777,'21','1',1430321.06,1434224.66,3903.60,683130.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','139',2778,'22','1',1853920.39,1857915.79,3995.40,699195.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','139',2779,'23','1',1598809.50,1603184.17,4374.67,765567.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','139',2780,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','140',2781,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','140',2782,'2','1',1875363.30,1878931.19,3567.89,624380.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','140',2783,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','140',2784,'4','1',1991669.51,1995791.09,4121.58,721276.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','140',2785,'9','2',1255023.15,1255023.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','140',2786,'10','2',1320930.10,1325741.84,4811.74,3897509.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','140',2787,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','140',2788,'12','1',2148348.14,2151625.25,3277.11,573494.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','140',2789,'13','1',1360479.47,1363097.66,2618.19,458183.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','140',2790,'14','1',1501509.26,1505306.80,3797.54,664569.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','140',2791,'15','1',1676002.33,1676002.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','140',2792,'16','1',2483121.49,2487227.46,4105.97,718544.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','140',2793,'17','1',1593867.29,1596994.45,3127.16,547253.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','140',2794,'18','1',1311217.21,1314766.35,3549.14,621099.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','140',2795,'19','1',1426711.00,1430451.26,3740.26,654545.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','140',2796,'20','1',1916610.17,1921426.53,4816.36,842863.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','140',2797,'21','1',1434224.66,1437892.42,3667.76,641858.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','140',2798,'22','1',1857915.79,1861283.79,3368.00,589400.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','140',2799,'23','1',1603184.17,1606935.76,3751.59,656528.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','140',2800,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','141',2801,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','141',2802,'2','1',1878931.19,1880811.15,1879.96,328993.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','141',2803,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','141',2804,'4','1',1995791.09,1998343.03,2551.94,446589.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','141',2805,'9','2',1255023.15,1255023.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','141',2806,'10','2',1325741.84,1329555.12,3813.28,3088756.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','141',2807,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','141',2808,'12','1',2151625.25,2153352.08,1726.83,302195.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','141',2809,'13','1',1363097.66,1364931.55,1833.89,320930.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','141',2810,'14','1',1505306.80,1507055.78,1748.98,306071.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','141',2811,'15','1',1676002.33,1676824.75,822.42,143923.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','141',2812,'16','1',2487227.46,2491325.66,4098.20,717185.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','141',2813,'17','1',1596994.45,1600566.05,3571.60,625030.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','141',2814,'18','1',1314766.35,1319252.72,4486.37,785114.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','141',2815,'19','1',1430451.26,1434936.31,4485.05,784883.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','141',2816,'20','1',1921426.53,1926454.77,5028.24,879942.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','141',2817,'21','1',1437892.42,1441907.32,4014.90,702607.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','141',2818,'22','1',1861283.79,1865874.53,4590.74,803379.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','141',2819,'23','1',1606935.76,1611522.47,4586.71,802674.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','141',2820,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','142',2821,'1','1',2163174.55,2163174.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','142',2822,'2','1',1880811.15,1882216.55,1405.40,245945.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','142',2823,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','142',2824,'4','1',1998343.03,2000225.99,1882.96,329518.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','142',2825,'9','2',1255023.15,1255121.32,98.17,79517.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','142',2826,'10','2',1329555.12,1336920.03,7364.91,5965577.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','142',2827,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','142',2828,'12','1',2153352.08,2154998.64,1646.56,288148.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','142',2829,'13','1',1364931.55,1365884.74,953.19,166808.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','142',2830,'14','1',1507055.78,1508166.20,1110.42,194323.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','142',2831,'15','1',1676824.75,1678085.56,1260.81,220641.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','142',2832,'16','1',2491325.66,2496035.74,4710.08,824264.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','142',2833,'17','1',1600566.05,1604163.31,3597.26,629520.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','142',2834,'18','1',1319252.72,1322308.87,3056.15,534826.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','142',2835,'19','1',1434936.31,1439627.43,4691.12,820946.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','142',2836,'20','1',1926454.77,1931842.41,5387.64,942837.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','142',2837,'21','1',1441907.32,1445358.90,3451.58,604026.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','142',2838,'22','1',1865874.53,1870178.03,4303.50,753112.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','142',2839,'23','1',1611522.47,1615919.84,4397.37,769539.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','142',2840,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','143',2841,'1','1',2163174.55,2169352.00,6177.45,1081053.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','143',2842,'2','1',1882216.55,1888591.93,6375.38,1115691.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','143',2843,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','143',2844,'4','1',2000225.99,2009670.90,9444.91,1652859.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','143',2845,'9','2',1255121.32,1255121.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','143',2846,'10','2',1336920.03,1339426.74,2506.71,2030435.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','143',2847,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','143',2848,'12','1',2154998.64,2160276.38,5277.74,923604.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','143',2849,'13','1',1365884.74,1371153.26,5268.52,921991.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','143',2850,'14','1',1508166.20,1514005.49,5839.29,1021875.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','143',2851,'15','1',1678085.56,1683834.68,5749.12,1006096.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','143',2852,'16','1',2496035.74,2497425.50,1389.76,243208.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','143',2853,'17','1',1604163.31,1604869.76,706.45,123628.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','143',2854,'18','1',1322308.87,1323385.37,1076.50,188387.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','143',2855,'19','1',1439627.43,1440499.54,872.11,152619.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','143',2856,'20','1',1931842.41,1933264.47,1422.06,248860.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','143',2857,'21','1',1445358.90,1446139.29,780.39,136568.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','143',2858,'22','1',1870178.03,1871197.20,1019.17,178354.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','143',2859,'23','1',1615919.84,1616595.62,675.78,118261.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','143',2860,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','144',2861,'1','1',2169352.00,2173000.32,3648.32,638456.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','144',2862,'2','1',1888591.93,1891201.29,2609.36,456638.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','144',2863,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','144',2864,'4','1',2009670.90,2014715.79,5044.89,882855.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','144',2865,'9','2',1255121.32,1255294.13,172.81,139976.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','144',2866,'10','2',1339426.74,1342432.85,3006.11,2434949.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','144',2867,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','144',2868,'12','1',2160276.38,2163377.18,3100.80,542640.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','144',2869,'13','1',1371153.26,1373435.32,2282.06,399360.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','144',2870,'14','1',1514005.49,1516232.39,2226.90,389707.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','144',2871,'15','1',1683834.68,1686031.17,2196.49,384385.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','144',2872,'16','1',2497425.50,2501806.32,4380.82,766643.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','144',2873,'17','1',1604869.76,1608624.40,3754.64,657062.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','144',2874,'18','1',1323385.37,1326349.68,2964.31,518754.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','144',2875,'19','1',1440499.54,1444224.35,3724.81,651841.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','144',2876,'20','1',1933264.47,1937999.17,4734.70,828572.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','144',2877,'21','1',1446139.29,1448467.21,2327.92,407386.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','144',2878,'22','1',1871197.20,1874940.61,3743.41,655096.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','144',2879,'23','1',1616595.62,1621102.37,4506.75,788681.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','144',2880,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','145',2881,'1','1',2173000.32,2173000.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','145',2882,'2','1',1891201.29,1892609.79,1408.50,246487.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','145',2883,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','145',2884,'4','1',2014715.79,2016398.22,1682.43,294425.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','145',2885,'9','2',1255294.13,1255294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','145',2886,'10','2',1342432.85,1343151.07,718.22,581758.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','145',2887,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','145',2888,'12','1',2163377.18,2164324.56,947.38,165791.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','145',2889,'13','1',1373435.32,1373990.24,554.92,97111.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','145',2890,'14','1',1516232.39,1517021.01,788.62,138008.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','145',2891,'15','1',1686031.17,1686961.12,929.95,162741.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','145',2892,'16','1',2501806.32,2505741.08,3934.76,688583.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','145',2893,'17','1',1608624.40,1611806.69,3182.29,556900.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','145',2894,'18','1',1326349.68,1329502.34,3152.66,551715.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','145',2895,'19','1',1444224.35,1446916.08,2691.73,471052.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','145',2896,'20','1',1937999.17,1942184.51,4185.34,732434.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','145',2897,'21','1',1448467.21,1451781.51,3314.30,580002.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','145',2898,'22','1',1874940.61,1877902.40,2961.79,518313.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','145',2899,'23','1',1621102.37,1623654.93,2552.56,446698.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','145',2900,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','146',2901,'1','1',2173000.32,2173000.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','146',2902,'2','1',1892609.79,1892609.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','146',2903,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','146',2904,'4','1',2016398.22,2016528.37,130.15,22776.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','146',2905,'9','2',1255294.13,1255294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','146',2906,'10','2',1343151.07,1345329.46,2178.39,1764495.90,0.00,0.00,0.00,0.00,0.00),('21','220','4','146',2907,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','146',2908,'12','1',2164324.56,2164324.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','146',2909,'13','1',1373990.24,1373990.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','146',2910,'14','1',1517021.01,1517021.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','146',2911,'15','1',1686961.12,1686961.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','146',2912,'16','1',2505741.08,2511483.75,5742.67,1004967.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','146',2913,'17','1',1611806.69,1616385.92,4579.23,801365.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','146',2914,'18','1',1329502.34,1335059.34,5557.00,972475.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','146',2915,'19','1',1446916.08,1452184.57,5268.49,921985.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','146',2916,'20','1',1942184.51,1947976.77,5792.26,1013645.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','146',2917,'21','1',1451781.51,1457406.76,5625.25,984418.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','146',2918,'22','1',1877902.40,1882846.54,4944.14,865224.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','146',2919,'23','1',1623654.93,1628794.44,5139.51,899414.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','146',2920,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','147',2921,'1','1',2173000.32,2176632.00,3631.68,635544.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','147',2922,'2','1',1892609.79,1895002.47,2392.68,418719.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','147',2923,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','147',2924,'4','1',2016528.37,2020388.16,3859.79,675463.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','147',2925,'9','2',1255294.13,1257150.60,1856.47,1503740.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','147',2926,'10','2',1345329.46,1348662.26,3332.80,2699568.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','147',2927,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','147',2928,'12','1',2164324.56,2166984.28,2659.72,465451.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','147',2929,'13','1',1373990.24,1376194.31,2204.07,385712.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','147',2930,'14','1',1517021.01,1519496.06,2475.05,433133.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','147',2931,'15','1',1686961.12,1688922.48,1961.36,343238.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','147',2932,'16','1',2511483.75,2516023.52,4539.77,794459.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','147',2933,'17','1',1616385.92,1619923.38,3537.46,619055.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','147',2934,'18','1',1335059.34,1337227.00,2167.66,379340.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','147',2935,'19','1',1452184.57,1457284.16,5099.59,892428.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','147',2936,'20','1',1947976.77,1953589.94,5613.17,982304.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','147',2937,'21','1',1457406.76,1460512.89,3106.13,543572.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','147',2938,'22','1',1882846.54,1887245.51,4398.97,769819.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','147',2939,'23','1',1628794.44,1632899.49,4105.05,718383.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','147',2940,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','148',2941,'1','1',2176632.00,2179400.12,2768.12,484421.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','148',2942,'2','1',1895002.47,1897521.98,2519.51,440914.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','148',2943,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','148',2944,'4','1',2020388.16,2024048.67,3660.51,640589.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','148',2945,'9','2',1257150.60,1259869.60,2719.00,2202390.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','148',2946,'10','2',1348662.26,1348662.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','148',2947,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','148',2948,'12','1',2166984.28,2169063.82,2079.54,363919.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','148',2949,'13','1',1376194.31,1377417.58,1223.27,214072.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','148',2950,'14','1',1519496.06,1522136.18,2640.12,462021.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','148',2951,'15','1',1688922.48,1690625.70,1703.22,298063.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','148',2952,'16','1',2516023.52,2520377.68,4354.16,761978.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','148',2953,'17','1',1619923.38,1623682.69,3759.31,657879.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','148',2954,'18','1',1337227.00,1340579.31,3352.31,586654.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','148',2955,'19','1',1457284.16,1461340.54,4056.38,709866.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','148',2956,'20','1',1953589.94,1959088.94,5499.00,962325.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','148',2957,'21','1',1460512.89,1463652.22,3139.33,549382.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','148',2958,'22','1',1887245.51,1890426.20,3180.69,556620.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','148',2959,'23','1',1632899.49,1637240.24,4340.75,759631.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','148',2960,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','149',2961,'1','1',2179400.12,2181340.02,1939.90,339482.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','149',2962,'2','1',1897521.98,1898701.31,1179.33,206382.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','149',2963,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','149',2964,'4','1',2024048.67,2025882.77,1834.10,320967.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','149',2965,'9','2',1259869.60,1260025.83,156.23,126546.30,0.00,0.00,0.00,0.00,0.00),('21','220','3','149',2966,'10','2',1348662.26,1352598.96,3936.70,3188727.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','149',2967,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','149',2968,'12','1',2169063.82,2170414.35,1350.53,236342.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','149',2969,'13','1',1377417.58,1378301.57,883.99,154698.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','149',2970,'14','1',1522136.18,1523093.93,957.75,167606.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','149',2971,'15','1',1690625.70,1691943.17,1317.47,230557.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','149',2972,'16','1',2520377.68,2523637.00,3259.32,570381.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','149',2973,'17','1',1623682.69,1626164.09,2481.40,434245.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','149',2974,'18','1',1340579.31,1343111.66,2532.35,443161.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','149',2975,'19','1',1461340.54,1463925.92,2585.38,452441.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','149',2976,'20','1',1959088.94,1962346.37,3257.43,570050.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','149',2977,'21','1',1463652.22,1466837.69,3185.47,557457.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','149',2978,'22','1',1890426.20,1893559.53,3133.33,548332.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','149',2979,'23','1',1637240.24,1640520.12,3279.88,573979.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','149',2980,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','150',2981,'1','1',2181340.02,2183290.01,1949.99,341248.42,0.00,0.00,0.00,0.00,0.00),('21','220','1','150',2982,'2','1',1898701.31,1901184.38,2483.07,434537.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','150',2983,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','150',2984,'4','1',2025882.77,2029132.01,3249.24,568617.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','150',2985,'9','2',1260025.83,1263631.48,3605.65,2920576.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','150',2986,'10','2',1352598.96,1352598.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','150',2987,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','150',2988,'12','1',2170414.35,2172425.16,2010.81,351891.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','150',2989,'13','1',1378301.57,1380231.45,1929.88,337729.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','150',2990,'14','1',1523093.93,1524716.54,1622.61,283956.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','150',2991,'15','1',1691943.17,1693678.02,1734.85,303598.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','150',2992,'16','1',2523637.00,2528921.34,5284.34,924759.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','150',2993,'17','1',1626164.09,1629191.45,3027.36,529788.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','150',2994,'18','1',1343111.66,1346079.46,2967.80,519365.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','150',2995,'19','1',1463925.92,1467378.77,3452.85,604248.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','150',2996,'20','1',1962346.37,1967392.19,5045.82,883018.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','150',2997,'21','1',1466837.69,1470007.84,3170.15,554776.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','150',2998,'22','1',1893559.53,1897419.63,3860.10,675517.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','150',2999,'23','1',1640520.12,1643667.20,3147.08,550739.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','150',3000,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','151',3001,'1','1',2183290.01,2184336.96,1046.95,183216.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','151',3002,'2','1',1901184.38,1901991.22,806.84,141197.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','151',3003,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','151',3004,'4','1',2029132.01,2030241.43,1109.42,194148.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','151',3005,'9','2',1263631.48,1264470.74,839.26,679800.60,0.00,0.00,0.00,0.00,0.00),('21','220','3','151',3006,'10','2',1352598.96,1354503.00,1904.04,1542272.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','151',3007,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','151',3008,'12','1',2172425.16,2173372.22,947.06,165735.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','151',3009,'13','1',1380231.45,1380786.75,555.30,97177.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','151',3010,'14','1',1524716.54,1525448.38,731.84,128072.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','151',3011,'15','1',1693678.02,1694475.68,797.66,139590.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','151',3012,'16','1',2528921.34,2529914.74,993.40,173845.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','151',3013,'17','1',1629191.45,1629918.74,727.29,127275.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','151',3014,'18','1',1346079.46,1346649.23,569.77,99709.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','151',3015,'19','1',1467378.77,1468198.73,819.96,143493.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','151',3016,'20','1',1967392.19,1968641.73,1249.54,218669.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','151',3017,'21','1',1470007.84,1470644.50,636.66,111415.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','151',3018,'22','1',1897419.63,1898607.75,1188.12,207921.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','151',3019,'23','1',1643667.20,1644472.82,805.62,140983.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','151',3020,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','152',3021,'1','1',2184336.96,2186202.01,1865.05,326383.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','152',3022,'2','1',1901991.22,1903489.95,1498.73,262277.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','152',3023,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','152',3024,'4','1',2030241.43,2032207.38,1965.95,344041.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','152',3025,'9','2',1264470.74,1265639.63,1168.89,946800.90,0.00,0.00,0.00,0.00,0.00),('21','220','3','152',3026,'10','2',1354503.00,1354503.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','152',3027,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','152',3028,'12','1',2173372.22,2174356.58,984.36,172263.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','152',3029,'13','1',1380786.75,1382490.92,1704.17,298229.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','152',3030,'14','1',1525448.38,1526801.82,1353.44,236852.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','152',3031,'15','1',1694475.68,1694594.31,118.63,20760.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','152',3032,'16','1',2529914.74,2533363.94,3449.20,603610.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','152',3033,'17','1',1629918.74,1632194.12,2275.38,398191.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','152',3034,'18','1',1346649.23,1348171.04,1521.81,266316.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','152',3035,'19','1',1468198.73,1471688.57,3489.84,610722.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','152',3036,'20','1',1968641.73,1972274.27,3632.54,635694.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','152',3037,'21','1',1470644.50,1473358.75,2714.25,474993.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','152',3038,'22','1',1898607.75,1901229.15,2621.40,458745.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','152',3039,'23','1',1644472.82,1647166.57,2693.75,471406.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','152',3040,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','153',3041,'1','1',2186202.01,2187200.01,998.00,174650.35,0.00,0.00,0.00,0.00,0.00),('21','220','1','153',3042,'2','1',1903489.95,1904320.22,830.27,145297.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','153',3043,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','153',3044,'4','1',2032207.38,2033517.80,1310.42,229323.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','153',3045,'9','2',1265639.63,1265639.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','153',3046,'10','2',1354503.00,1358404.22,3901.22,3159988.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','153',3047,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','153',3048,'12','1',2174356.58,2175618.18,1261.60,220780.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','153',3049,'13','1',1382490.92,1383325.19,834.27,145997.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','153',3050,'14','1',1526801.82,1527853.72,1051.90,184082.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','153',3051,'15','1',1694594.31,1695399.50,805.19,140908.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','153',3052,'16','1',2533363.94,2534386.62,1022.68,178969.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','153',3053,'17','1',1632194.12,1632515.28,321.16,56203.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','153',3054,'18','1',1348171.04,1348171.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','153',3055,'19','1',1471688.57,1472829.15,1140.58,199601.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','153',3056,'20','1',1972274.27,1973397.93,1123.66,196640.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','153',3057,'21','1',1473358.75,1474263.03,904.28,158249.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','153',3058,'22','1',1901229.15,1902092.66,863.51,151114.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','153',3059,'23','1',1647166.57,1648039.11,872.54,152694.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','153',3060,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','154',3061,'1','1',2187200.01,2189266.55,2066.54,361644.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','154',3062,'2','1',1904320.22,1906023.24,1703.02,298028.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','154',3063,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','154',3064,'4','1',2033517.80,2035724.59,2206.79,386188.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','154',3065,'9','2',1265639.63,1267414.05,1774.42,1437280.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','154',3066,'10','2',1358404.22,1360291.75,1887.53,1528899.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','154',3067,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','154',3068,'12','1',2175618.18,2177362.49,1744.31,305254.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','154',3069,'13','1',1383325.19,1383897.67,572.48,100184.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','154',3070,'14','1',1527853.72,1529473.78,1620.06,283510.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','154',3071,'15','1',1695399.50,1697385.30,1985.80,347515.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','154',3072,'16','1',2534386.62,2538203.66,3817.04,667982.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','154',3073,'17','1',1632515.28,1635270.00,2754.72,482076.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','154',3074,'18','1',1348171.04,1351638.36,3467.32,606781.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','154',3075,'19','1',1472829.15,1476326.46,3497.31,612029.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','154',3076,'20','1',1973397.93,1978267.54,4869.61,852181.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','154',3077,'21','1',1474263.03,1476838.71,2575.68,450744.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','154',3078,'22','1',1902092.66,1905882.43,3789.77,663209.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','154',3079,'23','1',1648039.11,1651460.36,3421.25,598718.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','154',3080,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','155',3081,'1','1',2189266.55,2192370.27,3103.72,543151.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','155',3082,'2','1',1906023.24,1908220.41,2197.17,384504.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','155',3083,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','155',3084,'4','1',2035724.59,2039221.38,3496.79,611938.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','155',3085,'9','2',1267414.05,1269508.07,2094.02,1696156.20,0.00,0.00,0.00,0.00,0.00),('21','220','3','155',3086,'10','2',1360291.75,1363233.17,2941.42,2382550.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','155',3087,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','155',3088,'12','1',2177362.49,2178669.04,1306.55,228646.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','155',3089,'13','1',1383897.67,1386374.67,2477.00,433475.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','155',3090,'14','1',1529473.78,1531795.68,2321.90,406332.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','155',3091,'15','1',1697385.30,1699241.03,1855.73,324752.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','155',3092,'16','1',2538203.66,2543356.76,5153.10,901792.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','155',3093,'17','1',1635270.00,1639082.39,3812.39,667168.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','155',3094,'18','1',1351638.36,1355021.65,3383.29,592075.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','155',3095,'19','1',1476326.46,1480017.96,3691.50,646012.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','155',3096,'20','1',1978267.54,1984720.57,6453.03,1129280.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','155',3097,'21','1',1476838.71,1480814.30,3975.59,695728.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','155',3098,'22','1',1905882.43,1910052.73,4170.30,729802.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','155',3099,'23','1',1651460.36,1655675.69,4215.33,737682.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','155',3100,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','156',3101,'1','1',2192370.27,2194783.51,2413.24,422317.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','156',3102,'2','1',1908220.41,1910565.46,2345.05,410383.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','156',3103,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','156',3104,'4','1',2039221.38,2042542.14,3320.76,581133.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','156',3105,'9','2',1269508.07,1271200.87,1692.80,1371168.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','156',3106,'10','2',1363233.17,1367500.21,4267.04,3456302.40,0.00,0.00,0.00,0.00,0.00),('21','220','4','156',3107,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','156',3108,'12','1',2178669.04,2180445.54,1776.50,310887.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','156',3109,'13','1',1386374.67,1387777.99,1403.32,245581.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','156',3110,'14','1',1531795.68,1533487.66,1691.98,296096.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','156',3111,'15','1',1699241.03,1700675.05,1434.02,250953.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','156',3112,'16','1',2543356.76,2548174.03,4817.27,843022.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','156',3113,'17','1',1639082.39,1642023.51,2941.12,514696.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','156',3114,'18','1',1355021.65,1358961.04,3939.39,689393.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','156',3115,'19','1',1480017.96,1482318.35,2300.39,402568.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','156',3116,'20','1',1984720.57,1988816.28,4095.71,716749.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','156',3117,'21','1',1480814.30,1484259.94,3445.64,602987.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','156',3118,'22','1',1910052.73,1913303.94,3251.21,568961.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','156',3119,'23','1',1655675.69,1659117.83,3442.14,602374.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','156',3120,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','157',3121,'1','1',2194783.51,2197128.43,2344.92,410361.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','157',3122,'2','1',1910565.46,1912651.84,2086.38,365116.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','157',3123,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','157',3124,'4','1',2042542.14,2046258.35,3716.21,650336.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','157',3125,'9','2',1271200.87,1272046.12,845.25,684652.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','157',3126,'10','2',1367500.21,1368771.18,1270.97,1029485.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','157',3127,'11','3',561705.09,561705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','157',3128,'12','1',2180445.54,2180445.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','157',3129,'13','1',1387777.99,1390398.98,2620.99,458673.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','157',3130,'14','1',1533487.66,1535328.66,1841.00,322175.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','157',3131,'15','1',1700675.05,1702318.80,1643.75,287656.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','157',3132,'16','1',2548174.03,2552315.91,4141.88,724829.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','157',3133,'17','1',1642023.51,1645193.82,3170.31,554804.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','157',3134,'18','1',1358961.04,1361989.22,3028.18,529931.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','157',3135,'19','1',1482318.35,1485734.56,3416.21,597836.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','157',3136,'20','1',1988816.28,1993088.24,4271.96,747593.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','157',3137,'21','1',1484259.94,1487447.20,3187.26,557770.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','157',3138,'22','1',1913303.94,1916556.68,3252.74,569229.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','157',3139,'23','1',1659117.83,1662994.70,3876.87,678452.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','157',3140,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','158',3141,'1','1',2197128.43,2198177.54,1049.11,183594.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','158',3142,'2','1',1912651.84,1913428.98,777.14,135999.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','158',3143,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','158',3144,'4','1',2046258.35,2047707.58,1449.23,253615.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','158',3145,'9','2',1272046.12,1272317.13,271.01,219518.10,0.00,0.00,0.00,0.00,0.00),('21','220','3','158',3146,'10','2',1368771.18,1370849.69,2078.51,1683593.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','158',3147,'11','3',561705.09,562278.91,548.04,465834.85,0.00,0.00,25.78,0.00,0.00),('21','220','1','158',3148,'12','1',2180445.54,2180447.75,2.21,386.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','158',3149,'13','1',1390398.98,1391667.44,1268.46,221980.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','158',3150,'14','1',1535328.66,1536205.45,876.79,153438.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','158',3151,'15','1',1702318.80,1703126.92,808.12,141421.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','158',3152,'16','1',2552315.91,2554684.01,2368.10,414417.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','158',3153,'17','1',1645193.82,1647405.02,2211.20,386960.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','158',3154,'18','1',1361989.22,1364394.00,2404.78,420836.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','158',3155,'19','1',1485734.56,1488208.85,2474.29,433000.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','158',3156,'20','1',1993088.24,1996231.27,3143.03,550030.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','158',3157,'21','1',1487447.20,1489370.90,1923.70,336647.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','158',3158,'22','1',1916556.68,1918351.44,1794.76,314083.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','158',3159,'23','1',1662994.70,1664940.94,1946.24,340592.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','158',3160,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','159',3161,'1','1',2198177.54,2198177.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','159',3162,'2','1',1913428.98,1913428.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','159',3163,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','159',3164,'4','1',2047707.58,2047741.87,34.29,6000.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','159',3165,'9','2',1272317.13,1272317.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','159',3166,'10','2',1370849.69,1371905.75,1056.06,855408.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','159',3167,'11','3',562278.91,562914.01,635.09,539830.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','159',3168,'12','1',2180447.75,2180447.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','159',3169,'13','1',1391667.44,1391667.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','159',3170,'14','1',1536205.45,1536205.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','159',3171,'15','1',1703126.92,1703126.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','159',3172,'16','1',2554684.01,2554684.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','159',3173,'17','1',1647405.02,1647405.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','159',3174,'18','1',1364394.00,1364394.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','159',3175,'19','1',1488208.85,1488208.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','159',3176,'20','1',1996231.27,1996231.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','159',3177,'21','1',1489370.90,1489370.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','159',3178,'22','1',1918351.44,1918351.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','159',3179,'23','1',1664940.94,1664940.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','159',3180,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','160',3181,'1','1',2198177.54,2201098.77,2921.23,511215.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','160',3182,'2','1',1913428.98,1916052.27,2623.29,459075.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','160',3183,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','160',3184,'4','1',2047741.87,2051669.43,3927.56,687323.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','160',3185,'9','2',1272317.13,1275592.71,3275.58,2653219.80,0.00,0.00,0.00,0.00,0.00),('21','220','3','160',3186,'10','2',1371905.75,1373270.07,1364.32,1105099.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','160',3187,'11','3',562914.01,563478.63,564.62,479930.40,0.00,0.00,0.00,0.00,0.00),('21','220','1','160',3188,'12','1',2180447.75,2180448.19,0.44,77.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','160',3189,'13','1',1391667.44,1394661.26,2993.82,523918.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','160',3190,'14','1',1536205.45,1539352.96,3147.51,550814.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','160',3191,'15','1',1703126.92,1705032.91,1905.99,333548.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','160',3192,'16','1',2554684.01,2558961.37,4277.36,748538.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','160',3193,'17','1',1647405.02,1650727.65,3322.63,581460.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','160',3194,'18','1',1364394.00,1368032.14,3638.14,636674.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','160',3195,'19','1',1488208.85,1491881.32,3672.47,642682.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','160',3196,'20','1',1996231.27,2001685.04,5453.77,954409.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','160',3197,'21','1',1489370.90,1493391.00,4020.10,703517.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','160',3198,'22','1',1918351.44,1922716.61,4365.17,763904.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','160',3199,'23','1',1664940.94,1669029.08,4088.14,715424.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','160',3200,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','161',3201,'1','1',2201098.77,2203747.12,2648.35,463461.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','161',3202,'2','1',1916052.27,1918007.57,1955.30,342177.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','161',3203,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','161',3204,'4','1',2051669.43,2054917.33,3247.90,568382.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','161',3205,'9','2',1275592.71,1276547.75,955.04,773582.40,0.00,0.00,0.00,0.00,0.00),('21','220','3','161',3206,'10','2',1373270.07,1374164.52,894.45,724504.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','161',3207,'11','3',563478.63,564166.62,687.99,584794.05,0.00,0.00,0.00,0.00,0.00),('21','220','1','161',3208,'12','1',2180448.19,2180448.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','161',3209,'13','1',1394661.26,1397857.14,3195.88,559279.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','161',3210,'14','1',1539352.96,1541795.81,2442.85,427498.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','161',3211,'15','1',1705032.91,1706653.14,1620.23,283540.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','161',3212,'16','1',2558961.37,2563190.43,4229.06,740085.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','161',3213,'17','1',1650727.65,1653395.49,2667.84,466872.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','161',3214,'18','1',1368032.14,1371535.97,3503.83,613170.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','161',3215,'19','1',1491881.32,1495385.13,3503.81,613166.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','161',3216,'20','1',2001685.04,2006641.29,4956.25,867343.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','161',3217,'21','1',1493391.00,1497166.39,3775.39,660693.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','161',3218,'22','1',1922716.61,1926490.64,3774.03,660455.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','161',3219,'23','1',1669029.08,1671856.52,2827.44,494802.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','161',3220,'24','3',65643.95,65643.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','162',3221,'1','1',2203747.12,2206039.12,2292.00,401100.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','162',3222,'2','1',1918007.57,1920267.17,2259.60,395430.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','162',3223,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','162',3224,'4','1',2054917.33,2058583.21,3665.88,641529.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','162',3225,'9','2',1276547.75,1279118.20,2570.45,2082064.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','162',3226,'10','2',1374164.52,1378389.25,4224.73,3422031.30,0.00,0.00,0.00,0.00,0.00),('21','220','4','162',3227,'11','3',564166.62,564802.63,636.01,540604.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','162',3228,'12','1',2180448.19,2180489.81,41.62,7283.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','162',3229,'13','1',1397857.14,1400923.16,3066.02,536553.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','162',3230,'14','1',1541795.81,1541795.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','162',3231,'15','1',1706653.14,1709987.87,3334.73,583577.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','162',3232,'16','1',2563190.43,2568208.64,5018.21,878186.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','162',3233,'17','1',1653395.49,1656995.58,3600.09,630015.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','162',3234,'18','1',1371535.97,1375864.17,4328.20,757435.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','162',3235,'19','1',1495385.13,1499150.50,3765.37,658939.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','162',3236,'20','1',2006641.29,2012495.43,5854.14,1024474.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','162',3237,'21','1',1497166.39,1500920.13,3753.74,656904.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','162',3238,'22','1',1926490.64,1931922.13,5431.49,950510.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','162',3239,'23','1',1671856.52,1676637.04,4780.52,836591.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','162',3240,'24','3',65643.95,65657.35,13.40,11389.15,0.00,0.00,0.00,0.00,0.00),('21','220','1','163',3241,'1','1',2206039.12,2206904.99,865.87,151527.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','163',3242,'2','1',1920267.17,1920869.23,602.06,105360.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','163',3243,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','163',3244,'4','1',2058583.21,2060319.78,1736.57,303899.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','163',3245,'9','2',1279118.20,1282565.65,3447.45,2757960.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','163',3246,'10','2',1378389.25,1384713.46,6324.21,5059368.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','163',3247,'11','3',564802.63,565545.67,743.04,639013.54,0.00,0.00,0.00,0.00,0.00),('21','220','1','163',3248,'12','1',2180489.81,2180817.09,327.28,57274.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','163',3249,'13','1',1400923.16,1401539.91,616.75,107931.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','163',3250,'14','1',1541795.81,1541795.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','163',3251,'15','1',1709987.87,1710212.06,224.19,39233.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','163',3252,'16','1',2568208.64,2572217.40,4008.76,701533.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','163',3253,'17','1',1656995.58,1659954.94,2959.36,517888.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','163',3254,'18','1',1375864.17,1379356.48,3492.31,611154.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','163',3255,'19','1',1499150.50,1502223.39,3072.89,537755.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','163',3256,'20','1',2012495.43,2016836.36,4340.93,759662.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','163',3257,'21','1',1500920.13,1503413.08,2492.95,436266.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','163',3258,'22','1',1931922.13,1935417.83,3495.70,611747.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','163',3259,'23','1',1676637.04,1679687.35,3050.31,533804.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','163',3260,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','164',3261,'1','1',2206904.99,2208868.30,1963.31,343579.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','164',3262,'2','1',1920869.23,1922445.30,1576.07,275812.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','164',3263,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','164',3264,'4','1',2060319.78,2062285.34,1965.56,343973.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','164',3265,'9','2',1282565.65,1282737.28,171.63,137304.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','164',3266,'10','2',1384713.46,1385922.61,1209.15,967320.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','164',3267,'11','3',565545.67,566035.38,489.71,421150.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','164',3268,'12','1',2180817.09,2182471.60,1654.51,289539.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','164',3269,'13','1',1401539.91,1402430.58,890.67,155867.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','164',3270,'14','1',1541795.81,1541795.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','164',3271,'15','1',1710212.06,1712152.34,1940.28,339549.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','164',3272,'16','1',2572217.40,2575047.32,2829.92,495236.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','164',3273,'17','1',1659954.94,1662382.90,2427.96,424893.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','164',3274,'18','1',1379356.48,1381552.26,2195.78,384261.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','164',3275,'19','1',1502223.39,1505298.67,3075.28,538174.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','164',3276,'20','1',2016836.36,2020385.98,3549.62,621183.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','164',3277,'21','1',1503413.08,1505603.28,2190.20,383285.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','164',3278,'22','1',1935417.83,1938255.01,2837.18,496506.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','164',3279,'23','1',1679687.35,1682416.15,2728.80,477540.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','164',3280,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','165',3281,'1','1',2208868.30,2210402.98,1534.68,268569.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','165',3282,'2','1',1922445.30,1923507.98,1062.68,185969.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','165',3283,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','165',3284,'4','1',2062285.34,2064269.66,1984.32,347256.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','165',3285,'9','2',1282737.28,1282737.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','165',3286,'10','2',1385922.61,1387686.06,1763.45,1410760.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','165',3287,'11','3',566035.38,566564.45,529.07,454999.34,0.00,0.00,0.00,0.00,0.00),('21','220','1','165',3288,'12','1',2182471.60,2182488.74,17.14,2999.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','165',3289,'13','1',1402430.58,1404112.25,1681.67,294292.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','165',3290,'14','1',1541795.81,1542910.72,1114.91,195109.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','165',3291,'15','1',1712152.34,1713682.65,1530.31,267804.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','165',3292,'16','1',2575047.32,2576301.63,1254.31,219504.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','165',3293,'17','1',1662382.90,1663010.66,627.76,109858.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','165',3294,'18','1',1381552.26,1382524.67,972.41,170171.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','165',3295,'19','1',1505298.67,1506159.23,860.56,150598.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','165',3296,'20','1',2020385.98,2021911.63,1525.65,266988.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','165',3297,'21','1',1505603.28,1506856.60,1253.32,219331.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','165',3298,'22','1',1938255.01,1939469.65,1214.64,212562.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','165',3299,'23','1',1682416.15,1683306.35,890.20,155785.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','165',3300,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','166',3301,'1','1',2210402.98,2210402.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','166',3302,'2','1',1923507.98,1924517.47,1009.49,176660.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','166',3303,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','166',3304,'4','1',2064269.66,2065553.22,1283.56,224623.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','166',3305,'9','2',1282737.28,1282737.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','166',3306,'10','2',1387686.06,1389452.42,1766.36,1413088.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','166',3307,'11','3',566564.45,566835.94,271.49,233482.26,0.00,0.00,0.00,0.00,0.00),('21','220','1','166',3308,'12','1',2182488.74,2182488.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','166',3309,'13','1',1404112.25,1404889.20,776.95,135966.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','166',3310,'14','1',1542910.72,1542910.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','166',3311,'15','1',1713682.65,1714854.46,1171.81,205066.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','166',3312,'16','1',2576301.63,2579479.85,3178.22,556188.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','166',3313,'17','1',1663010.66,1666193.58,3182.92,557011.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','166',3314,'18','1',1382524.67,1386041.68,3517.01,615476.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','166',3315,'19','1',1506159.23,1508999.89,2840.66,497115.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','166',3316,'20','1',2021911.63,2025745.92,3834.29,671000.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','166',3317,'21','1',1506856.60,1510268.53,3411.93,597087.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','166',3318,'22','1',1939469.65,1942013.79,2544.14,445224.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','166',3319,'23','1',1683306.35,1686478.79,3172.44,555177.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','166',3320,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','167',3321,'1','1',2210402.98,2211957.03,1554.05,271958.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','167',3322,'2','1',1924517.47,1925705.66,1188.19,207933.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','167',3323,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','167',3324,'4','1',2065553.22,2067493.34,1940.12,339521.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','167',3325,'9','2',1282737.28,1284084.01,1346.73,1077384.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','167',3326,'10','2',1389452.42,1392299.32,2846.90,2277520.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','167',3327,'11','3',566835.94,567338.15,502.21,431902.32,0.00,0.00,0.00,0.00,0.00),('21','220','1','167',3328,'12','1',2182488.74,2183359.76,871.02,152428.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','167',3329,'13','1',1404889.20,1405721.19,831.99,145598.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','167',3330,'14','1',1542910.72,1543883.37,972.65,170213.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','167',3331,'15','1',1714854.46,1715633.19,778.73,136277.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','167',3332,'16','1',2579479.85,2582902.03,3422.18,598881.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','167',3333,'17','1',1666193.58,1669740.91,3547.33,620782.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','167',3334,'18','1',1386041.68,1389643.52,3601.84,630322.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','167',3335,'19','1',1508999.89,1512415.21,3415.32,597681.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','167',3336,'20','1',2025745.92,2030662.98,4917.06,860485.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','167',3337,'21','1',1510268.53,1514081.01,3812.48,667184.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','167',3338,'22','1',1942013.79,1945730.22,3716.43,650375.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','167',3339,'23','1',1686478.79,1689647.28,3168.49,554485.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','167',3340,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','168',3341,'1','1',2211957.03,2216056.51,4099.48,717409.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','168',3342,'2','1',1925705.66,1928254.35,2548.69,446020.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','168',3343,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','168',3344,'4','1',2067493.34,2071857.91,4364.57,763799.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','168',3345,'9','2',1284084.01,1285184.01,1100.00,880000.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','168',3346,'10','2',1392299.32,1394835.16,2535.84,2028672.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','168',3347,'11','3',567338.15,567911.69,573.54,493240.96,0.00,0.00,0.00,0.00,0.00),('21','220','1','168',3348,'12','1',2183359.76,2186699.50,3339.74,584454.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','168',3349,'13','1',1405721.19,1407376.30,1655.11,289644.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','168',3350,'14','1',1543883.37,1546117.99,2234.62,391058.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','168',3351,'15','1',1715633.19,1717971.18,2337.99,409148.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','168',3352,'16','1',2582902.03,2589046.69,6144.66,1075315.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','168',3353,'17','1',1669740.91,1672081.02,2340.11,409519.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','168',3354,'18','1',1389643.52,1393863.58,4220.06,738510.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','168',3355,'19','1',1512415.21,1516173.89,3758.68,657769.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','168',3356,'20','1',2030662.98,2035839.62,5176.64,905912.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','168',3357,'21','1',1514081.01,1518348.20,4267.19,746758.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','168',3358,'22','1',1945730.22,1949528.29,3798.07,664662.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','168',3359,'23','1',1689647.28,1693977.08,4329.80,757715.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','168',3360,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','169',3361,'1','1',2216056.51,2217293.14,1236.63,216410.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','169',3362,'2','1',1928254.35,1929379.00,1124.65,196813.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','169',3363,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','169',3364,'4','1',2071857.91,2074124.27,2266.36,396613.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','169',3365,'9','2',1285184.01,1285184.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','169',3366,'10','2',1394835.16,1397596.05,2760.89,2208712.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','169',3367,'11','3',567911.69,568265.78,354.09,304515.68,0.00,0.00,0.00,0.00,0.00),('21','220','1','169',3368,'12','1',2186699.50,2188189.11,1489.61,260681.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','169',3369,'13','1',1407376.30,1408151.08,774.78,135586.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','169',3370,'14','1',1546117.99,1546807.58,689.59,120678.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','169',3371,'15','1',1717971.18,1719085.67,1114.49,195035.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','169',3372,'16','1',2589046.69,2591953.31,2906.62,508658.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','169',3373,'17','1',1672081.02,1675851.35,3770.33,659807.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','169',3374,'18','1',1393863.58,1397281.74,3418.16,598178.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','169',3375,'19','1',1516173.89,1518982.19,2808.30,491452.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','169',3376,'20','1',2035839.62,2040195.49,4355.87,762277.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','169',3377,'21','1',1518348.20,1520770.54,2422.34,423909.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','169',3378,'22','1',1949528.29,1952661.00,3132.71,548224.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','169',3379,'23','1',1693977.08,1696324.46,2347.38,410791.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','169',3380,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','170',3381,'1','1',2217293.14,2220511.27,3218.13,563172.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','170',3382,'2','1',1929379.00,1931581.87,2202.87,385502.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','170',3383,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','170',3384,'4','1',2074124.27,2077845.96,3721.69,651295.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','170',3385,'9','2',1285184.01,1285422.02,238.01,190408.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','170',3386,'10','2',1397596.05,1401510.54,3914.49,3131592.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','170',3387,'11','3',568265.78,568581.97,316.19,271926.84,0.00,0.00,0.00,0.00,0.00),('21','220','1','170',3388,'12','1',2188189.11,2189769.89,1580.78,276636.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','170',3389,'13','1',1408151.08,1410911.04,2759.96,482993.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','170',3390,'14','1',1546807.58,1549157.46,2349.88,411229.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','170',3391,'15','1',1719085.67,1720154.38,1068.71,187024.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','170',3392,'16','1',2591953.31,2594847.37,2894.06,506460.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','170',3393,'17','1',1675851.35,1680076.04,4224.69,739320.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','170',3394,'18','1',1397281.74,1399834.07,2552.33,446657.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','170',3395,'19','1',1518982.19,1522699.17,3716.98,650471.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','170',3396,'20','1',2040195.49,2044971.49,4776.00,835800.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','170',3397,'21','1',1520770.54,1524245.16,3474.62,608058.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','170',3398,'22','1',1952661.00,1956540.96,3879.96,678993.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','170',3399,'23','1',1696324.46,1699011.80,2687.34,470284.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','170',3400,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','171',3401,'1','1',2220511.27,2221479.67,968.40,169470.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','171',3402,'2','1',1931581.87,1932121.19,539.32,94381.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','171',3403,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','171',3404,'4','1',2077845.96,2079200.40,1354.44,237027.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','171',3405,'9','2',1285422.02,1285422.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','171',3406,'10','2',1401510.54,1404368.82,2858.28,2286624.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','171',3407,'11','3',568581.97,569040.30,458.33,394160.36,0.00,0.00,0.00,0.00,0.00),('21','220','1','171',3408,'12','1',2189769.89,2190663.80,893.91,156434.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','171',3409,'13','1',1410911.04,1411211.81,300.77,52634.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','171',3410,'14','1',1549157.46,1549808.45,650.99,113923.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','171',3411,'15','1',1720154.38,1720430.12,275.74,48254.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','171',3412,'16','1',2594847.37,2599197.11,4349.74,761204.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','171',3413,'17','1',1680076.04,1683375.21,3299.17,577354.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','171',3414,'18','1',1399834.07,1403611.92,3777.85,661123.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','171',3415,'19','1',1522699.17,1526211.80,3512.63,614710.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','171',3416,'20','1',2044971.49,2049708.20,4736.71,828924.08,0.00,0.00,0.00,0.00,0.00),('21','220','2','171',3417,'21','1',1524245.16,1527818.77,3573.61,625381.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','171',3418,'22','1',1956540.96,1960374.34,3833.38,670841.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','171',3419,'23','1',1699011.80,1701911.79,2899.99,507498.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','171',3420,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','172',3421,'1','1',2221479.67,2223703.67,2224.00,389200.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','172',3422,'2','1',1932121.19,1933828.52,1707.33,298782.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','172',3423,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','172',3424,'4','1',2079200.40,2081570.67,2370.27,414797.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','172',3425,'9','2',1285422.02,1285422.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','172',3426,'10','2',1404368.82,1406745.86,2377.04,1901632.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','172',3427,'11','3',569040.30,569497.22,456.92,392948.62,0.00,0.00,0.00,0.00,0.00),('21','220','1','172',3428,'12','1',2190663.80,2192598.19,1934.39,338518.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','172',3429,'13','1',1411211.81,1412593.47,1381.66,241790.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','172',3430,'14','1',1549808.45,1551426.50,1618.05,283158.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','172',3431,'15','1',1720430.12,1721930.25,1500.13,262522.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','172',3432,'16','1',2599197.11,2602835.54,3638.43,636725.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','172',3433,'17','1',1683375.21,1686364.69,2989.48,523159.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','172',3434,'18','1',1403611.92,1406065.75,2453.83,429420.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','172',3435,'19','1',1526211.80,1529929.57,3717.77,650609.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','172',3436,'20','1',2049708.20,2054295.05,4586.85,802698.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','172',3437,'21','1',1527818.77,1530756.56,2937.79,514113.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','172',3438,'22','1',1960374.34,1963726.55,3352.21,586636.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','172',3439,'23','1',1701911.79,1701911.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','172',3440,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','173',3441,'1','1',2223703.67,2227144.30,3440.63,602110.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','173',3442,'2','1',1933828.52,1937208.81,3380.29,591550.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','173',3443,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','173',3444,'4','1',2081570.67,2084701.67,3131.00,547925.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','173',3445,'9','2',1285422.02,1285422.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','173',3446,'10','2',1406745.86,1408969.89,2224.03,1779224.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','173',3447,'11','3',569497.22,569840.12,342.90,294892.28,0.00,0.00,0.00,0.00,0.00),('21','220','1','173',3448,'12','1',2192598.19,2196021.85,3423.66,599140.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','173',3449,'13','1',1412593.47,1413511.72,918.25,160693.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','173',3450,'14','1',1551426.50,1551641.75,215.25,37668.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','173',3451,'15','1',1721930.25,1725001.81,3071.56,537523.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','173',3452,'16','1',2602835.54,2608137.72,5302.18,927881.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','173',3453,'17','1',1686364.69,1686364.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','173',3454,'18','1',1406065.75,1410085.20,4019.45,703403.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','173',3455,'19','1',1529929.57,1530576.48,646.91,113209.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','173',3456,'20','1',2054295.05,2058256.53,3961.48,693259.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','173',3457,'21','1',1530756.56,1532928.80,2172.24,380142.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','173',3458,'22','1',1963726.55,1967248.97,3522.42,616423.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','173',3459,'23','1',1701911.79,1705278.24,3366.45,589128.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','173',3460,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','174',3461,'1','1',2227144.30,2229495.95,2351.65,411538.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','174',3462,'2','1',1937208.81,1938402.83,1194.02,208953.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','174',3463,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','174',3464,'4','1',2084701.67,2087675.76,2974.09,520465.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','174',3465,'9','2',1285422.02,1285989.30,567.28,453824.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','174',3466,'10','2',1408969.89,1411087.58,2117.69,1694152.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','174',3467,'11','3',569840.12,570345.62,505.50,434729.14,0.00,0.00,0.00,0.00,0.00),('21','220','1','174',3468,'12','1',2196021.85,2197999.91,1978.06,346160.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','174',3469,'13','1',1413511.72,1413983.56,471.84,82572.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','174',3470,'14','1',1551641.75,1553163.42,1521.67,266292.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','174',3471,'15','1',1725001.81,1725917.40,915.59,160228.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','174',3472,'16','1',2608137.72,2611624.06,3486.34,610109.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','174',3473,'17','1',1686364.69,1690250.62,3885.93,680037.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','174',3474,'18','1',1410085.20,1412758.85,2673.65,467888.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','174',3475,'19','1',1530576.48,1533582.61,3006.13,526072.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','174',3476,'20','1',2058256.53,2062499.65,4243.12,742546.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','174',3477,'21','1',1532928.80,1535564.15,2635.35,461186.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','174',3478,'22','1',1967248.97,1970762.22,3513.25,614818.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','174',3479,'23','1',1705278.24,1708061.37,2783.13,487047.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','174',3480,'24','3',65657.35,65657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','175',3481,'1','1',2229495.95,2231276.96,1781.01,311676.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','175',3482,'2','1',1938402.83,1939334.99,932.16,163128.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','175',3483,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','175',3484,'4','1',2087675.76,2090091.89,2416.13,422822.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','175',3485,'9','2',1285989.30,1286557.04,567.74,454192.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','175',3486,'10','2',1411087.58,1413286.55,2198.97,1759176.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','175',3487,'11','3',570345.62,570765.41,419.79,361018.54,0.00,0.00,0.00,0.00,0.00),('21','220','1','175',3488,'12','1',2197999.91,2200071.96,2072.05,362608.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','175',3489,'13','1',1413983.56,1414021.81,38.25,6693.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','175',3490,'14','1',1553163.42,1554213.35,1049.93,183737.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','175',3491,'15','1',1725917.40,1727235.50,1318.10,230667.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','175',3492,'16','1',2611624.06,2615162.50,3538.44,619227.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','175',3493,'17','1',1690250.62,1693549.58,3298.96,577318.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','175',3494,'18','1',1412758.85,1415938.10,3179.25,556368.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','175',3495,'19','1',1533582.61,1536604.96,3022.35,528911.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','175',3496,'20','1',2062499.65,2066873.41,4373.76,765408.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','175',3497,'21','1',1535564.15,1538160.89,2596.74,454429.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','175',3498,'22','1',1970762.22,1973511.45,2749.23,481115.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','175',3499,'23','1',1708061.37,1710662.69,2601.32,455231.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','175',3500,'24','3',65657.35,65835.43,178.08,153148.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','176',3501,'1','1',2231276.96,2232583.39,1306.43,228625.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','176',3502,'2','1',1939334.99,1940249.48,914.49,160035.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','176',3503,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','176',3504,'4','1',2090091.89,2091494.02,1402.13,245372.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','176',3505,'9','2',1286557.04,1289763.80,3206.76,2565408.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','176',3506,'10','2',1413286.55,1413287.89,1.34,1072.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','176',3507,'11','3',570765.41,570765.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','176',3508,'12','1',2200071.96,2201087.24,1015.28,177674.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','176',3509,'13','1',1414021.81,1414794.57,772.76,135233.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','176',3510,'14','1',1554213.35,1555055.46,842.11,147369.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','176',3511,'15','1',1727235.50,1729283.04,2047.54,358319.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','176',3512,'16','1',2615162.50,2615841.10,678.60,118755.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','176',3513,'17','1',1693549.58,1694663.46,1113.88,194929.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','176',3514,'18','1',1415938.10,1416668.13,730.03,127755.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','176',3515,'19','1',1536604.96,1537231.78,626.82,109693.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','176',3516,'20','1',2066873.41,2068154.71,1281.30,224227.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','176',3517,'21','1',1538160.89,1538937.82,776.93,135962.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','176',3518,'22','1',1973511.45,1973511.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','176',3519,'23','1',1710662.69,1711802.94,1140.25,199543.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','176',3520,'24','3',65835.43,66375.04,539.61,464060.30,0.00,0.00,0.00,0.00,0.00),('21','220','1','177',3521,'1','1',2232583.39,2234492.87,1909.48,334159.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','177',3522,'2','1',1940249.48,1940988.09,738.61,129256.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','177',3523,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','177',3524,'4','1',2091494.02,2093093.79,1599.77,279959.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','177',3525,'9','2',1289763.80,1291661.77,1897.97,1518376.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','177',3526,'10','2',1413287.89,1414234.10,946.21,756968.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','177',3527,'11','3',570765.41,570765.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','177',3528,'12','1',2201087.24,2202722.05,1634.81,286091.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','177',3529,'13','1',1414794.57,1416050.33,1255.76,219758.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','177',3530,'14','1',1555055.46,1556656.91,1601.45,280253.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','177',3531,'15','1',1729283.04,1730342.52,1059.48,185409.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','177',3532,'16','1',2615841.10,2618171.75,2330.65,407863.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','177',3533,'17','1',1694663.46,1696923.66,2260.20,395535.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','177',3534,'18','1',1416668.13,1419200.85,2532.72,443226.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','177',3535,'19','1',1537231.78,1539236.37,2004.59,350803.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','177',3536,'20','1',2068154.71,2071233.50,3078.79,538788.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','177',3537,'21','1',1538937.82,1540804.18,1866.36,326613.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','177',3538,'22','1',1973511.45,1973551.98,40.53,7092.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','177',3539,'23','1',1711802.94,1715160.10,3357.16,587503.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','177',3540,'24','3',66375.04,66375.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','178',3541,'1','1',2234492.87,2237131.20,2638.33,461707.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','178',3542,'2','1',1940988.09,1943234.70,2246.61,393156.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','178',3543,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','178',3544,'4','1',2093093.79,2096269.16,3175.37,555689.57,0.00,0.00,0.00,0.00,0.00),('21','220','3','178',3545,'9','2',1291661.77,1292353.73,691.96,553568.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','178',3546,'10','2',1414234.10,1417566.64,3332.54,2666032.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','178',3547,'11','3',570765.41,570765.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','178',3548,'12','1',2202722.05,2204514.76,1792.71,313724.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','178',3549,'13','1',1416050.33,1417418.16,1367.83,239370.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','178',3550,'14','1',1556656.91,1558765.14,2108.23,368940.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','178',3551,'15','1',1730342.52,1732031.91,1689.39,295643.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','178',3552,'16','1',2618171.75,2622608.06,4436.31,776354.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','178',3553,'17','1',1696923.66,1699967.83,3044.17,532729.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','178',3554,'18','1',1419200.85,1423521.30,4320.45,756079.45,0.00,0.00,0.00,0.00,0.00),('21','220','2','178',3555,'19','1',1539236.37,1542556.16,3319.79,580963.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','178',3556,'20','1',2071233.50,2075414.99,4181.49,731760.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','178',3557,'21','1',1540804.18,1544939.63,4135.45,723703.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','178',3558,'22','1',1973551.98,1976795.64,3243.66,567640.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','178',3559,'23','1',1715160.10,1718609.14,3449.04,603582.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','178',3560,'24','3',66375.04,67318.67,943.63,811517.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','179',3561,'1','1',2237131.20,2240096.99,2965.79,519013.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','179',3562,'2','1',1943234.70,1945089.63,1854.93,324612.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','179',3563,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','179',3564,'4','1',2096269.16,2099340.49,3071.33,537482.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','179',3565,'9','2',1292353.73,1293593.68,1239.95,991960.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','179',3566,'10','2',1417566.64,1419123.61,1556.97,1245576.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','179',3567,'11','3',570765.41,570765.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','179',3568,'12','1',2204514.76,2206585.32,2070.56,362348.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','179',3569,'13','1',1417418.16,1418817.74,1399.58,244926.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','179',3570,'14','1',1558765.14,1560501.29,1736.15,303826.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','179',3571,'15','1',1732031.91,1733595.36,1563.45,273603.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','179',3572,'16','1',2622608.06,2627957.86,5349.80,936215.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','179',3573,'17','1',1699967.83,1702767.16,2799.33,489882.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','179',3574,'18','1',1423521.30,1427050.60,3529.30,617627.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','179',3575,'19','1',1542556.16,1545577.78,3021.62,528783.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','179',3576,'20','1',2075414.99,2080811.82,5396.83,944445.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','179',3577,'21','1',1544939.63,1547881.24,2941.61,514781.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','179',3578,'22','1',1976795.64,1980921.35,4125.71,721999.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','179',3579,'23','1',1718609.14,1721456.90,2847.76,498358.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','179',3580,'24','3',67318.67,67938.00,619.33,532620.36,0.00,0.00,0.00,0.00,0.00),('21','220','1','180',3581,'1','1',2240096.99,2243649.16,3552.17,621629.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','180',3582,'2','1',1945089.63,1948142.32,3052.69,534220.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','180',3583,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','180',3584,'4','1',2099340.49,2101926.93,2586.44,452627.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','180',3585,'9','2',1293593.68,1293593.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','180',3586,'10','2',1419123.61,1419663.97,540.36,432288.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','180',3587,'11','3',570765.41,570776.81,11.40,9801.42,0.00,0.00,0.00,0.00,0.00),('21','220','1','180',3588,'12','1',2206585.32,2208439.31,1853.99,324448.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','180',3589,'13','1',1418817.74,1418817.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','180',3590,'14','1',1560501.29,1562271.75,1770.46,309830.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','180',3591,'15','1',1733595.36,1735395.76,1800.40,315070.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','180',3592,'16','1',2627957.86,2633451.47,5493.61,961381.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','180',3593,'17','1',1702767.16,1703785.34,1018.18,178181.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','180',3594,'18','1',1427050.60,1430116.81,3066.21,536586.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','180',3595,'19','1',1545577.78,1547335.38,1757.60,307580.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','180',3596,'20','1',2080811.82,2085679.97,4868.15,851926.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','180',3597,'21','1',1547881.24,1551068.69,3187.45,557803.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','180',3598,'22','1',1980921.35,1983715.90,2794.55,489046.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','180',3599,'23','1',1721456.90,1725656.08,4199.18,734856.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','180',3600,'24','3',67938.00,68284.08,346.08,297624.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','181',3601,'1','1',2243649.16,2248240.63,4591.47,803507.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','181',3602,'2','1',1948142.32,1952174.85,4032.53,705692.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','181',3603,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','181',3604,'4','1',2101926.93,2106870.87,4943.94,865189.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','181',3605,'9','2',1293593.68,1294492.10,898.42,718736.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','181',3606,'10','2',1419663.97,1419880.11,216.14,172912.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','181',3607,'11','3',570776.81,571058.22,281.41,242015.18,0.00,0.00,0.00,0.00,0.00),('21','220','1','181',3608,'12','1',2208439.31,2212255.99,3816.68,667919.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','181',3609,'13','1',1418817.74,1422271.91,3454.17,604479.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','181',3610,'14','1',1562271.75,1566876.77,4605.02,805878.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','181',3611,'15','1',1735395.76,1738733.10,3337.34,584034.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','181',3612,'16','1',2633451.47,2635836.22,2384.75,417331.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','181',3613,'17','1',1703785.34,1706810.10,3024.76,529333.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','181',3614,'18','1',1430116.81,1432492.44,2375.63,415735.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','181',3615,'19','1',1547335.38,1547642.26,306.88,53704.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','181',3616,'20','1',2085679.97,2088924.75,3244.78,567836.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','181',3617,'21','1',1551068.69,1553205.10,2136.41,373871.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','181',3618,'22','1',1983715.90,1986924.63,3208.73,561527.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','181',3619,'23','1',1725656.08,1727547.32,1891.24,330967.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','181',3620,'24','3',68284.08,68284.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','182',3621,'1','1',2248240.63,2249605.44,1364.81,238841.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','182',3622,'2','1',1952174.85,1953544.21,1369.36,239638.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','182',3623,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','182',3624,'4','1',2106870.87,2108644.85,1773.98,310446.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','182',3625,'9','2',1294492.10,1294988.04,495.94,396752.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','182',3626,'10','2',1419880.11,1423262.73,3382.62,2706096.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','182',3627,'11','3',571058.22,571058.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','182',3628,'12','1',2212255.99,2213571.15,1315.16,230153.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','182',3629,'13','1',1422271.91,1423229.81,957.90,167632.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','182',3630,'14','1',1566876.77,1567811.03,934.26,163495.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','182',3631,'15','1',1738733.10,1740698.82,1965.72,344001.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','182',3632,'16','1',2635836.22,2636715.43,879.21,153861.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','182',3633,'17','1',1706810.10,1707939.41,1129.31,197629.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','182',3634,'18','1',1432492.44,1433584.26,1091.82,191068.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','182',3635,'19','1',1547642.26,1548757.98,1115.72,195251.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','182',3636,'20','1',2088924.75,2090386.18,1461.43,255750.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','182',3637,'21','1',1553205.10,1554101.92,896.82,156943.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','182',3638,'22','1',1986924.63,1987808.94,884.31,154754.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','182',3639,'23','1',1727547.32,1728598.87,1051.55,184021.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','182',3640,'24','3',68284.08,68783.44,499.36,429453.04,0.00,0.00,0.00,0.00,0.00),('21','220','1','183',3641,'1','1',2249605.44,2251925.77,2320.33,406057.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','183',3642,'2','1',1953544.21,1955128.67,1584.46,277280.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','183',3643,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','183',3644,'4','1',2108644.85,2111457.28,2812.43,492175.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','183',3645,'9','2',1294988.04,1294988.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','183',3646,'10','2',1423262.73,1425913.18,2650.45,2120360.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','183',3647,'11','3',571058.22,571445.50,387.28,333064.24,0.00,0.00,0.00,0.00,0.00),('21','220','1','183',3648,'12','1',2213571.15,2215779.86,2208.71,386524.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','183',3649,'13','1',1423229.81,1424215.58,985.77,172509.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','183',3650,'14','1',1567811.03,1569828.29,2017.26,353020.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','183',3651,'15','1',1740698.82,1742256.88,1558.06,272660.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','183',3652,'16','1',2636715.43,2640023.23,3307.80,578865.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','183',3653,'17','1',1707939.41,1711888.07,3948.66,691015.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','183',3654,'18','1',1433584.26,1436959.09,3374.83,590595.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','183',3655,'19','1',1548757.98,1552477.34,3719.36,650888.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','183',3656,'20','1',2090386.18,2095600.05,5213.87,912427.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','183',3657,'21','1',1554101.92,1556821.34,2719.42,475898.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','183',3658,'22','1',1987808.94,1991548.21,3739.27,654372.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','183',3659,'23','1',1728598.87,1732014.41,3415.54,597719.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','183',3660,'24','3',68783.44,68951.62,168.18,144634.80,0.00,0.00,0.00,0.00,0.00),('21','220','1','184',3661,'1','1',2251925.77,2256336.32,4410.55,771846.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','184',3662,'2','1',1955128.67,1960236.02,5107.35,893786.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','184',3663,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','184',3664,'4','1',2111457.28,2118014.66,6557.38,1147541.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','184',3665,'9','2',1294988.04,1294988.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','184',3666,'10','2',1425913.18,1428822.43,2909.25,2327400.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','184',3667,'11','3',571445.50,571825.38,379.88,326698.52,0.00,0.00,0.00,0.00,0.00),('21','220','1','184',3668,'12','1',2215779.86,2220707.14,4927.28,862274.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','184',3669,'13','1',1424215.58,1428379.31,4163.73,728652.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','184',3670,'14','1',1569828.29,1574126.45,4298.16,752178.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','184',3671,'15','1',1742256.88,1745903.26,3646.38,638116.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','184',3672,'16','1',2640023.23,2641891.86,1868.63,327010.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','184',3673,'17','1',1711888.07,1715266.24,3378.17,591179.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','184',3674,'18','1',1436959.09,1438786.20,1827.11,319744.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','184',3675,'19','1',1552477.34,1555329.51,2852.17,499129.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','184',3676,'20','1',2095600.05,2099727.05,4127.00,722225.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','184',3677,'21','1',1556821.34,1559645.97,2824.63,494310.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','184',3678,'22','1',1991548.21,1994423.09,2874.88,503104.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','184',3679,'23','1',1732014.41,1733574.61,1560.20,273035.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','184',3680,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','185',3681,'1','1',2256336.32,2261951.08,5614.76,982583.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','185',3682,'2','1',1960236.02,1963822.43,3586.41,627621.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','185',3683,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','185',3684,'4','1',2118014.66,2123039.17,5024.51,879289.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','185',3685,'9','2',1294988.04,1294988.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','185',3686,'10','2',1428822.43,1430506.10,1683.67,1346936.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','185',3687,'11','3',571825.38,572256.52,431.14,370782.98,0.00,0.00,0.00,0.00,0.00),('21','220','1','185',3688,'12','1',2220707.14,2224460.26,3753.12,656796.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','185',3689,'13','1',1428379.31,1430555.48,2176.17,380829.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','185',3690,'14','1',1574126.45,1577318.37,3191.92,558586.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','185',3691,'15','1',1745903.26,1747972.88,2069.62,362183.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','185',3692,'16','1',2641891.86,2645665.58,3773.72,660401.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','185',3693,'17','1',1715266.24,1719100.58,3834.34,671009.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','185',3694,'18','1',1438786.20,1443036.85,4250.65,743863.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','185',3695,'19','1',1555329.51,1557576.30,2246.79,393188.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','185',3696,'20','1',2099727.05,2104146.86,4419.81,773466.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','185',3697,'21','1',1559645.97,1563188.36,3542.39,619918.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','185',3698,'22','1',1994423.09,1998524.44,4101.35,717736.07,0.00,0.00,0.00,0.00,0.00),('21','220','2','185',3699,'23','1',1733574.61,1736279.40,2704.79,473338.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','185',3700,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','186',3701,'1','1',2261951.08,2261951.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','186',3702,'2','1',1963822.43,1963822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','186',3703,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','186',3704,'4','1',2123039.17,2123039.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','186',3705,'9','2',1294988.04,1294988.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','186',3706,'10','2',1430506.10,1430506.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','186',3707,'11','3',572256.52,572256.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','186',3708,'12','1',2224460.26,2224460.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','186',3709,'13','1',1430555.48,1430555.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','186',3710,'14','1',1577318.37,1577318.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','186',3711,'15','1',1747972.88,1747972.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','186',3712,'16','1',2645665.58,2645665.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','186',3713,'17','1',1719100.58,1719100.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','186',3714,'18','1',1443036.85,1443036.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','186',3715,'19','1',1557576.30,1557576.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','186',3716,'20','1',2104146.86,2104146.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','186',3717,'21','1',1563188.36,1563188.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','186',3718,'22','1',1998524.44,1998524.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','186',3719,'23','1',1736279.40,1736279.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','186',3720,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','187',3721,'1','1',2261951.08,2267891.69,5940.61,1039606.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','187',3722,'2','1',1963822.43,1967286.86,3464.43,606275.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','187',3723,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','187',3724,'4','1',2123039.17,2129184.92,6145.75,1075506.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','187',3725,'9','2',1294988.04,1296197.94,1209.90,967920.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','187',3726,'10','2',1430506.10,1432741.17,2235.07,1788056.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','187',3727,'11','3',572256.52,572761.49,504.97,434273.34,0.00,0.00,0.00,0.00,0.00),('21','220','1','187',3728,'12','1',2224460.26,2229038.50,4578.24,801192.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','187',3729,'13','1',1430555.48,1433880.43,3324.95,581866.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','187',3730,'14','1',1577318.37,1581581.52,4263.15,746051.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','187',3731,'15','1',1747972.88,1751465.70,3492.82,611243.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','187',3732,'16','1',2645665.58,2648285.96,2620.38,458566.85,0.00,0.00,0.00,0.00,0.00),('21','220','2','187',3733,'17','1',1719100.58,1720423.55,1322.97,231519.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','187',3734,'18','1',1443036.85,1444825.34,1788.49,312985.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','187',3735,'19','1',1557576.30,1559672.49,2096.19,366833.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','187',3736,'20','1',2104146.86,2107110.72,2963.86,518675.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','187',3737,'21','1',1563188.36,1564894.38,1706.02,298553.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','187',3738,'22','1',1998524.44,2000989.30,2464.86,431350.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','187',3739,'23','1',1736279.40,1737995.54,1716.14,300324.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','187',3740,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','188',3741,'1','1',2267891.69,2270629.09,2737.40,479045.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','188',3742,'2','1',1967286.86,1971721.13,4434.27,775997.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','188',3743,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','188',3744,'4','1',2129184.92,2134639.69,5454.77,954584.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','188',3745,'9','2',1296197.94,1298469.03,2271.09,1816872.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','188',3746,'10','2',1432741.17,1434750.81,2009.64,1607712.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','188',3747,'11','3',572761.49,573116.09,354.60,304956.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','188',3748,'12','1',2229038.50,2233519.38,4480.88,784154.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','188',3749,'13','1',1433880.43,1436899.03,3018.60,528255.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','188',3750,'14','1',1581581.52,1581581.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','188',3751,'15','1',1751465.70,1755060.68,3594.98,629121.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','188',3752,'16','1',2648285.96,2653240.43,4954.47,867032.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','188',3753,'17','1',1720423.55,1720423.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','188',3754,'18','1',1444825.34,1448594.63,3769.29,659625.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','188',3755,'19','1',1559672.49,1559672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','188',3756,'20','1',2107110.72,2111653.84,4543.12,795046.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','188',3757,'21','1',1564894.38,1567715.30,2820.92,493661.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','188',3758,'22','1',2000989.30,2000989.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','188',3759,'23','1',1737995.54,1742938.72,4943.18,865056.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','188',3760,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','189',3761,'1','1',2270629.09,2276683.47,6054.38,1059516.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','189',3762,'2','1',1971721.13,1976267.36,4546.23,795590.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','189',3763,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','189',3764,'4','1',2134639.69,2141314.63,6674.94,1168114.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','189',3765,'9','2',1298469.03,1301029.28,2560.25,2048200.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','189',3766,'10','2',1434750.81,1442241.57,7490.76,5992608.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','189',3767,'11','3',573116.09,573745.09,629.00,540940.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','189',3768,'12','1',2233519.38,2236550.30,3030.92,530411.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','189',3769,'13','1',1436899.03,1441171.87,4272.84,747747.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','189',3770,'14','1',1581581.52,1585462.75,3881.23,679215.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','189',3771,'15','1',1755060.68,1759457.06,4396.38,769366.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','189',3772,'16','1',2653240.43,2657321.93,4081.50,714262.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','189',3773,'17','1',1720423.55,1722691.85,2268.30,396952.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','189',3774,'18','1',1448594.63,1451254.94,2660.31,465554.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','189',3775,'19','1',1559672.49,1562237.09,2564.60,448805.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','189',3776,'20','1',2111653.84,2117479.19,5825.35,1019436.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','189',3777,'21','1',1567715.30,1568073.78,358.48,62734.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','189',3778,'22','1',2000989.30,2004332.51,3343.21,585061.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','189',3779,'23','1',1742938.72,1744976.96,2038.24,356692.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','189',3780,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','190',3781,'1','1',2276683.47,2277925.04,1241.57,217274.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','190',3782,'2','1',1976267.36,1977143.83,876.47,153382.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','190',3783,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','190',3784,'4','1',2141314.63,2142686.23,1371.60,240030.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','190',3785,'9','2',1301029.28,1302376.02,1346.74,1077392.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','190',3786,'10','2',1442241.57,1445055.32,2813.75,2251000.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','190',3787,'11','3',573745.09,574296.11,551.02,473879.78,0.00,0.00,0.00,0.00,0.00),('21','220','1','190',3788,'12','1',2236550.30,2237748.48,1198.18,209681.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','190',3789,'13','1',1441171.87,1441171.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','190',3790,'14','1',1585462.75,1586713.74,1250.99,218923.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','190',3791,'15','1',1759457.06,1760396.91,939.85,164473.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','190',3792,'16','1',2657321.93,2663237.44,5915.51,1035214.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','190',3793,'17','1',1722691.85,1726725.28,4033.43,705850.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','190',3794,'18','1',1451254.94,1457134.95,5880.01,1029001.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','190',3795,'19','1',1562237.09,1566945.90,4708.81,824041.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','190',3796,'20','1',2117479.19,2123473.56,5994.37,1049014.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','190',3797,'21','1',1568073.78,1572790.49,4716.71,825424.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','190',3798,'22','1',2004332.51,2009837.08,5504.57,963299.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','190',3799,'23','1',1744976.96,1749245.99,4269.03,747080.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','190',3800,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','191',3801,'1','1',2277925.04,2280980.50,3055.46,534705.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','191',3802,'2','1',1977143.83,1979136.34,1992.51,348689.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','191',3803,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','191',3804,'4','1',2142686.23,2145379.93,2693.70,471397.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','191',3805,'9','2',1302376.02,1302376.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','191',3806,'10','2',1445055.32,1447222.59,2167.27,1733816.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','191',3807,'11','3',574296.11,574669.30,373.19,320945.12,0.00,0.00,0.00,0.00,0.00),('21','220','1','191',3808,'12','1',2237748.48,2239677.25,1928.77,337534.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','191',3809,'13','1',1441171.87,1442709.81,1537.94,269139.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','191',3810,'14','1',1586713.74,1588329.07,1615.33,282682.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','191',3811,'15','1',1760396.91,1762651.66,2254.75,394581.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','191',3812,'16','1',2663237.44,2666354.63,3117.19,545508.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','191',3813,'17','1',1726725.28,1731016.48,4291.20,750960.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','191',3814,'18','1',1457134.95,1460942.59,3807.64,666337.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','191',3815,'19','1',1566945.90,1569567.89,2621.99,458848.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','191',3816,'20','1',2123473.56,2128824.15,5350.59,936353.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','191',3817,'21','1',1572790.49,1575885.50,3095.01,541626.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','191',3818,'22','1',2009837.08,2013710.69,3873.61,677881.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','191',3819,'23','1',1749245.99,1752883.87,3637.88,636629.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','191',3820,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','192',3821,'1','1',2280980.50,2280980.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','192',3822,'2','1',1979136.34,1979136.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','192',3823,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','192',3824,'4','1',2145379.93,2145379.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','192',3825,'9','2',1302376.02,1302376.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','192',3826,'10','2',1447222.59,1447222.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','192',3827,'11','3',574669.30,574669.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','192',3828,'12','1',2239677.25,2239677.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','192',3829,'13','1',1442709.81,1442709.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','192',3830,'14','1',1588329.07,1588329.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','192',3831,'15','1',1762651.66,1762651.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','192',3832,'16','1',2666354.63,2666354.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','192',3833,'17','1',1731016.48,1731016.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','192',3834,'18','1',1460942.59,1460942.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','192',3835,'19','1',1569567.89,1569567.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','192',3836,'20','1',2128824.15,2128824.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','192',3837,'21','1',1575885.50,1575885.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','192',3838,'22','1',2013710.69,2013710.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','192',3839,'23','1',1752883.87,1752883.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','192',3840,'24','3',68951.62,68951.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','193',3841,'1','1',2280980.50,2285671.45,4690.95,820916.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','193',3842,'2','1',1979136.34,1982298.54,3162.20,553385.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','193',3843,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','193',3844,'4','1',2145379.93,2149833.15,4453.22,779313.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','193',3845,'9','2',1302376.02,1303401.31,1025.29,820232.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','193',3846,'10','2',1447222.59,1447863.80,641.21,512968.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','193',3847,'11','3',574669.30,575043.10,373.80,321468.86,0.00,0.00,0.00,0.00,0.00),('21','220','1','193',3848,'12','1',2239677.25,2242908.35,3231.10,565442.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','193',3849,'13','1',1442709.81,1444739.02,2029.21,355111.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','193',3850,'14','1',1588329.07,1591879.15,3550.08,621264.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','193',3851,'15','1',1762651.66,1764005.83,1354.17,236979.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','193',3852,'16','1',2666354.63,2671848.01,5493.38,961341.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','193',3853,'17','1',1731016.48,1736191.00,5174.52,905541.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','193',3854,'18','1',1460942.59,1465442.75,4500.16,787528.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','193',3855,'19','1',1569567.89,1573268.07,3700.18,647531.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','193',3856,'20','1',2128824.15,2133418.17,4594.02,803953.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','193',3857,'21','1',1575885.50,1580705.08,4819.58,843426.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','193',3858,'22','1',2013710.69,2017804.54,4093.85,716423.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','193',3859,'23','1',1752883.87,1756874.93,3991.06,698435.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','193',3860,'24','3',68951.62,68955.92,4.30,3700.58,0.00,0.00,0.00,0.00,0.00),('21','220','1','194',3861,'1','1',2285671.45,2291149.80,5478.35,958711.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','194',3862,'2','1',1982298.54,1986633.76,4335.22,758663.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','194',3863,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','194',3864,'4','1',2149833.15,2155639.36,5806.21,1016086.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','194',3865,'9','2',1303401.31,1303922.90,521.59,417272.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','194',3866,'10','2',1447863.80,1454474.88,6611.08,5288864.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','194',3867,'11','3',575043.10,575043.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','194',3868,'12','1',2242908.35,2246774.02,3865.67,676492.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','194',3869,'13','1',1444739.02,1447969.29,3230.27,565297.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','194',3870,'14','1',1591879.15,1596338.19,4459.04,780332.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','194',3871,'15','1',1764005.83,1768589.98,4584.15,802226.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','194',3872,'16','1',2671848.01,2673951.00,2102.99,368023.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','194',3873,'17','1',1736191.00,1739110.49,2919.49,510910.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','194',3874,'18','1',1465442.75,1467113.98,1671.23,292465.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','194',3875,'19','1',1573268.07,1575537.73,2269.66,397190.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','194',3876,'20','1',2133418.17,2136516.65,3098.48,542234.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','194',3877,'21','1',1580705.08,1582925.36,2220.28,388549.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','194',3878,'22','1',2017804.54,2020241.46,2436.92,426461.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','194',3879,'23','1',1756874.93,1759090.09,2215.16,387653.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','194',3880,'24','3',68955.92,69519.76,563.84,484905.84,0.00,0.00,0.00,0.00,0.00),('21','220','1','195',3881,'1','1',2291149.80,2293547.76,2397.96,419643.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','195',3882,'2','1',1986633.76,1987788.43,1154.67,202067.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','195',3883,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','195',3884,'4','1',2155639.36,2157585.73,1946.37,340614.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','195',3885,'9','2',1303922.90,1303987.54,64.64,51712.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','195',3886,'10','2',1454474.88,1457521.61,3046.73,2437384.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','195',3887,'11','3',575043.10,575687.54,644.44,554214.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','195',3888,'12','1',2246774.02,2246966.86,192.84,33747.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','195',3889,'13','1',1447969.29,1449566.49,1597.20,279510.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','195',3890,'14','1',1596338.19,1596338.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','195',3891,'15','1',1768589.98,1770294.70,1704.72,298326.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','195',3892,'16','1',2673951.00,2676563.18,2612.18,457131.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','195',3893,'17','1',1739110.49,1742479.35,3368.86,589550.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','195',3894,'18','1',1467113.98,1470540.01,3426.03,599555.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','195',3895,'19','1',1575537.73,1578589.29,3051.56,534023.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','195',3896,'20','1',2136516.65,2140459.58,3942.93,690012.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','195',3897,'21','1',1582925.36,1585736.21,2810.85,491898.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','195',3898,'22','1',2020241.46,2023844.84,3603.38,630591.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','195',3899,'23','1',1759090.09,1761063.83,1973.74,345404.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','195',3900,'24','3',69519.76,69519.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','196',3901,'1','1',2293547.76,2297724.34,4176.58,730901.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','196',3902,'2','1',1987788.43,1991328.38,3539.95,619491.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','196',3903,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','196',3904,'4','1',2157585.73,2162033.76,4448.03,778405.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','196',3905,'9','2',1303987.54,1303987.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','196',3906,'10','2',1457521.61,1458661.75,1140.14,912112.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','196',3907,'11','3',575687.54,576316.19,628.65,540641.58,0.00,0.00,0.00,0.00,0.00),('21','220','1','196',3908,'12','1',2246966.86,2251437.59,4470.73,782377.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','196',3909,'13','1',1449566.49,1449566.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','196',3910,'14','1',1596338.19,1600005.64,3667.45,641803.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','196',3911,'15','1',1770294.70,1770294.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','196',3912,'16','1',2676563.18,2681461.55,4898.37,857214.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','196',3913,'17','1',1742479.35,1742479.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','196',3914,'18','1',1470540.01,1473887.51,3347.50,585812.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','196',3915,'19','1',1578589.29,1582231.09,3641.80,637315.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','196',3916,'20','1',2140459.58,2145153.40,4693.82,821418.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','196',3917,'21','1',1585736.21,1587842.17,2105.96,368543.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','196',3918,'22','1',2023844.84,2026517.65,2672.81,467741.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','196',3919,'23','1',1761063.83,1763844.14,2780.31,486554.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','196',3920,'24','3',69519.76,69519.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','197',3921,'1','1',2297724.34,2300774.97,3050.63,533860.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','197',3922,'2','1',1991328.38,1993632.26,2303.88,403178.83,0.00,0.00,0.00,0.00,0.00),('21','220','1','197',3923,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','197',3924,'4','1',2162033.76,2165645.66,3611.90,632082.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','197',3925,'9','2',1303987.54,1303987.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','197',3926,'10','2',1458661.75,1459324.12,662.37,529896.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','197',3927,'11','3',576316.19,576671.32,355.13,305412.66,0.00,0.00,0.00,0.00,0.00),('21','220','1','197',3928,'12','1',2251437.59,2254260.57,2822.98,494021.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','197',3929,'13','1',1449566.49,1451384.75,1818.26,318195.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','197',3930,'14','1',1600005.64,1602087.80,2082.16,364378.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','197',3931,'15','1',1770294.70,1772195.62,1900.92,332661.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','197',3932,'16','1',2681461.55,2684169.79,2708.24,473942.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','197',3933,'17','1',1742479.35,1747564.41,5085.06,889885.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','197',3934,'18','1',1473887.51,1477722.22,3834.71,671074.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','197',3935,'19','1',1582231.09,1585895.41,3664.32,641256.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','197',3936,'20','1',2145153.40,2151373.38,6219.98,1088496.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','197',3937,'21','1',1587842.17,1590905.85,3063.68,536144.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','197',3938,'22','1',2026517.65,2031752.81,5235.16,916153.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','197',3939,'23','1',1763844.14,1767106.90,3262.76,570983.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','197',3940,'24','3',69519.76,69519.76,0.00,3.44,0.00,0.00,0.00,0.00,0.00),('21','220','1','198',3941,'1','1',2300774.97,2301228.25,453.28,79324.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','198',3942,'2','1',1993632.26,1994047.77,415.51,72714.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','198',3943,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','198',3944,'4','1',2165645.66,2166196.06,550.40,96320.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','198',3945,'9','2',1303987.54,1303987.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','198',3946,'10','2',1459324.12,1459425.12,101.00,80800.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','198',3947,'11','3',576671.32,577458.09,786.77,676623.92,0.00,0.00,0.00,0.00,0.00),('21','220','1','198',3948,'12','1',2254260.57,2254443.53,182.96,32018.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','198',3949,'13','1',1451384.75,1451930.75,546.00,95550.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','198',3950,'14','1',1602087.80,1602568.06,480.26,84045.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','198',3951,'15','1',1772195.62,1772448.97,253.35,44336.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','198',3952,'16','1',2684169.79,2686819.40,2649.61,463681.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','198',3953,'17','1',1747564.41,1749920.51,2356.10,412317.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','198',3954,'18','1',1477722.22,1480416.28,2694.06,471460.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','198',3955,'19','1',1585895.41,1587980.96,2085.55,364971.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','198',3956,'20','1',2151373.38,2154340.87,2967.49,519310.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','198',3957,'21','1',1590905.85,1592533.03,1627.18,284756.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','198',3958,'22','1',2031752.81,2034198.51,2445.70,427997.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','198',3959,'23','1',1767106.90,1769301.69,2194.79,384088.08,0.00,0.00,0.00,0.00,0.00),('21','220','4','198',3960,'24','3',69519.76,69519.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','199',3961,'1','1',2301228.25,2303733.45,2505.20,438410.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','199',3962,'2','1',1994047.77,1997391.98,3344.21,585236.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','199',3963,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','199',3964,'4','1',2166196.06,2171044.00,4847.94,848389.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','199',3965,'9','2',1303987.54,1304539.35,551.81,441448.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','199',3966,'10','2',1459425.12,1461461.96,2036.84,1629472.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','199',3967,'11','3',577458.09,577875.76,417.67,359199.64,0.00,0.00,0.00,0.00,0.00),('21','220','1','199',3968,'12','1',2254443.53,2259104.41,4660.88,815654.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','199',3969,'13','1',1451930.75,1454008.00,2077.25,363518.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','199',3970,'14','1',1602568.06,1605690.96,3122.90,546507.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','199',3971,'15','1',1772448.97,1775303.24,2854.27,499497.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','199',3972,'16','1',2686819.40,2692244.77,5425.37,949439.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','199',3973,'17','1',1749920.51,1753110.64,3190.13,558272.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','199',3974,'18','1',1480416.28,1483619.44,3203.16,560553.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','199',3975,'19','1',1587980.96,1592746.44,4765.48,833959.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','199',3976,'20','1',2154340.87,2160652.50,6311.63,1104535.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','199',3977,'21','1',1592533.03,1596139.47,3606.44,631127.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','199',3978,'22','1',2034198.51,2039572.93,5374.42,940523.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','199',3979,'23','1',1769301.69,1773202.04,3900.35,682561.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','199',3980,'24','3',69519.76,69519.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','200',3981,'1','1',2303733.45,2307922.48,4189.03,733080.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','200',3982,'2','1',1997391.98,2000509.29,3117.31,545529.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','200',3983,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','200',3984,'4','1',2171044.00,2176093.86,5049.86,883725.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','200',3985,'9','2',1304539.35,1307004.85,2465.50,1972400.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','200',3986,'10','2',1461461.96,1464330.49,2868.53,2294824.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','200',3987,'11','3',577875.76,578329.54,453.78,390246.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','200',3988,'12','1',2259104.41,2262894.14,3789.73,663202.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','200',3989,'13','1',1454008.00,1457390.82,3382.82,591993.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','200',3990,'14','1',1605690.96,1608757.54,3066.58,536651.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','200',3991,'15','1',1775303.24,1777986.56,2683.32,469581.11,0.00,0.00,0.00,0.00,0.00),('21','220','2','200',3992,'16','1',2692244.77,2697184.82,4940.05,864508.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','200',3993,'17','1',1753110.64,1756202.61,3091.97,541094.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','200',3994,'18','1',1483619.44,1487358.05,3738.61,654256.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','200',3995,'19','1',1592746.44,1595962.69,3216.25,562843.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','200',3996,'20','1',2160652.50,2166205.53,5553.03,971780.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','200',3997,'21','1',1596139.47,1599435.80,3296.33,576857.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','200',3998,'22','1',2039572.93,2043387.09,3814.16,667478.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','200',3999,'23','1',1773202.04,1776294.52,3092.48,541184.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','200',4000,'24','3',69519.76,69519.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','201',4001,'1','1',2307922.48,2312485.69,4563.21,798561.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','201',4002,'2','1',2000509.29,2004855.04,4345.75,760506.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','201',4003,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','201',4004,'4','1',2176093.86,2181688.40,5594.54,979044.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','201',4005,'9','2',1307004.85,1312283.53,5278.68,4222944.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','201',4006,'10','2',1464330.49,1467409.36,3078.87,2463096.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','201',4007,'11','3',578329.54,578807.70,478.16,411216.74,0.00,0.00,0.00,0.00,0.00),('21','220','1','201',4008,'12','1',2262894.14,2267353.62,4459.48,780409.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','201',4009,'13','1',1457390.82,1461438.96,4048.14,708424.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','201',4010,'14','1',1608757.54,1615332.02,6574.48,1150534.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','201',4011,'15','1',1777986.56,1777986.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','201',4012,'16','1',2697184.82,2701538.52,4353.70,761897.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','201',4013,'17','1',1756202.61,1759094.00,2891.39,505993.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','201',4014,'18','1',1487358.05,1491121.29,3763.24,658567.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','201',4015,'19','1',1595962.69,1599239.13,3276.44,573377.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','201',4016,'20','1',2166205.53,2169653.05,3447.52,603316.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','201',4017,'21','1',1599435.80,1603617.89,4182.09,731865.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','201',4018,'22','1',2043387.09,2047465.10,4078.01,713651.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','201',4019,'23','1',1776294.52,1779099.07,2804.55,490796.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','201',4020,'24','3',69519.76,69519.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','202',4021,'1','1',2312485.69,2313446.28,960.59,168103.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','202',4022,'2','1',2004855.04,2005267.88,412.84,72247.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','202',4023,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','202',4024,'4','1',2181688.40,2183182.90,1494.50,261537.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','202',4025,'9','2',1312283.53,1312579.14,295.61,236488.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','202',4026,'10','2',1467409.36,1468037.71,628.35,502680.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','202',4027,'11','3',578807.70,579213.02,405.32,348571.76,0.00,0.00,0.00,0.00,0.00),('21','220','1','202',4028,'12','1',2267353.62,2268155.68,802.06,140360.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','202',4029,'13','1',1461438.96,1461851.27,412.31,72154.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','202',4030,'14','1',1615332.02,1615653.15,321.13,56197.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','202',4031,'15','1',1777986.56,1778181.51,194.95,34116.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','202',4032,'16','1',2701538.52,2704127.95,2589.43,453150.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','202',4033,'17','1',1759094.00,1762079.20,2985.20,522410.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','202',4034,'18','1',1491121.29,1494290.60,3169.31,554629.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','202',4035,'19','1',1599239.13,1601656.52,2417.39,423043.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','202',4036,'20','1',2169653.05,2172537.79,2884.74,504829.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','202',4037,'21','1',1603617.89,1606262.51,2644.62,462808.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','202',4038,'22','1',2047465.10,2049950.03,2484.93,434862.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','202',4039,'23','1',1779099.07,1781777.15,2678.08,468664.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','202',4040,'24','3',69519.76,69519.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','203',4041,'1','1',2313446.28,2313446.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','203',4042,'2','1',2005267.88,2005267.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','203',4043,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','203',4044,'4','1',2183182.90,2183182.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','203',4045,'9','2',1312579.14,1312579.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','203',4046,'10','2',1468037.71,1469036.99,999.28,799424.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','203',4047,'11','3',579213.02,579745.97,532.95,458336.14,0.00,0.00,0.00,0.00,0.00),('21','220','1','203',4048,'12','1',2268155.68,2268155.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','203',4049,'13','1',1461851.27,1461851.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','203',4050,'14','1',1615653.15,1615653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','203',4051,'15','1',1778181.51,1778181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','203',4052,'16','1',2704127.95,2708802.21,4674.26,817995.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','203',4053,'17','1',1762079.20,1765561.86,3482.66,609465.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','203',4054,'18','1',1494290.60,1497925.99,3635.39,636193.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','203',4055,'19','1',1601656.52,1605324.13,3667.61,641831.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','203',4056,'20','1',2172537.79,2178038.31,5500.52,962591.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','203',4057,'21','1',1606262.51,1608899.37,2636.86,461450.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','203',4058,'22','1',2049950.03,2052984.70,3034.67,531067.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','203',4059,'23','1',1781777.15,1784841.85,3064.70,536322.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','203',4060,'24','3',69519.76,69827.91,308.15,265009.86,0.00,0.00,0.00,0.00,0.00),('21','220','1','204',4061,'1','1',2313446.28,2313948.82,502.54,87944.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','204',4062,'2','1',2005267.88,2005267.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','204',4063,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','204',4064,'4','1',2183182.90,2183626.29,443.39,77593.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','204',4065,'9','2',1312579.14,1314464.32,1885.18,1508144.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','204',4066,'10','2',1469036.99,1470821.95,1784.96,1427968.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','204',4067,'11','3',579745.97,579993.02,247.05,212459.56,0.00,0.00,0.00,0.00,0.00),('21','220','1','204',4068,'12','1',2268155.68,2268633.08,477.40,83545.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','204',4069,'13','1',1461851.27,1462011.44,160.17,28029.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','204',4070,'14','1',1615653.15,1615653.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','204',4071,'15','1',1778181.51,1778481.06,299.55,52421.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','204',4072,'16','1',2708802.21,2712345.43,3543.22,620063.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','204',4073,'17','1',1765561.86,1768085.02,2523.16,441553.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','204',4074,'18','1',1497925.99,1501021.91,3095.92,541786.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','204',4075,'19','1',1605324.13,1608412.54,3088.41,540471.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','204',4076,'20','1',2178038.31,2181456.90,3418.59,598253.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','204',4077,'21','1',1608899.37,1611323.92,2424.55,424296.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','204',4078,'22','1',2052984.70,2055909.71,2925.01,511876.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','204',4079,'23','1',1784841.85,1787353.04,2511.19,439458.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','204',4080,'24','3',69827.91,70025.92,198.01,170290.32,0.00,0.00,0.00,0.00,0.00),('21','220','1','205',4081,'1','1',2313948.82,2318176.82,4228.00,739900.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','205',4082,'2','1',2005267.88,2007827.13,2559.25,447868.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','205',4083,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','205',4084,'4','1',2183626.29,2187235.76,3609.47,631657.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','205',4085,'9','2',1314464.32,1318111.90,3647.58,2918064.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','205',4086,'10','2',1470821.95,1471562.02,740.07,592056.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','205',4087,'11','3',579993.02,580757.51,764.49,657463.98,0.00,0.00,0.00,0.00,0.00),('21','220','1','205',4088,'12','1',2268633.08,2270828.40,2195.32,384181.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','205',4089,'13','1',1462011.44,1464813.80,2802.36,490413.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','205',4090,'14','1',1615653.15,1618328.18,2675.03,468130.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','205',4091,'15','1',1778481.06,1781231.92,2750.86,481400.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','205',4092,'16','1',2712345.43,2717266.24,4920.81,861141.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','205',4093,'17','1',1768085.02,1771475.24,3390.22,593288.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','205',4094,'18','1',1501021.91,1506701.95,5680.04,994007.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','205',4095,'19','1',1608412.54,1611874.32,3461.78,605811.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','205',4096,'20','1',2181456.90,2186583.19,5126.29,897100.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','205',4097,'21','1',1611323.92,1616114.75,4790.83,838395.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','205',4098,'22','1',2055909.71,2060834.64,4924.93,861862.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','205',4099,'23','1',1787353.04,1790591.45,3238.41,566721.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','205',4100,'24','3',70025.92,70025.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','206',4101,'1','1',2318176.82,2320143.12,1966.30,344102.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','206',4102,'2','1',2007827.13,2009522.01,1694.88,296604.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','206',4103,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','206',4104,'4','1',2187235.76,2190315.41,3079.65,538938.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','206',4105,'9','2',1318111.90,1320472.52,2360.62,1888496.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','206',4106,'10','2',1471562.02,1475337.17,3775.15,3020120.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','206',4107,'11','3',580757.51,581095.24,337.73,290445.22,0.00,0.00,0.00,0.00,0.00),('21','220','1','206',4108,'12','1',2270828.40,2272790.52,1962.12,343371.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','206',4109,'13','1',1464813.80,1464813.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','206',4110,'14','1',1618328.18,1619525.24,1197.06,209485.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','206',4111,'15','1',1781231.92,1782415.65,1183.73,207152.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','206',4112,'16','1',2717266.24,2721874.78,4608.54,806494.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','206',4113,'17','1',1771475.24,1773990.72,2515.48,440209.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','206',4114,'18','1',1506701.95,1510646.58,3944.63,690310.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','206',4115,'19','1',1611874.32,1615238.52,3364.20,588735.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','206',4116,'20','1',2186583.19,2191105.82,4522.63,791460.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','206',4117,'21','1',1616114.75,1619225.38,3110.63,544360.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','206',4118,'22','1',2060834.64,2063782.99,2948.35,515961.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','206',4119,'23','1',1790591.45,1793885.11,3293.66,576390.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','206',4120,'24','3',70025.92,70025.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','207',4121,'1','1',2320143.12,2323685.68,3542.56,619948.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','207',4122,'2','1',2009522.01,2012365.20,2843.19,497558.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','207',4123,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','207',4124,'4','1',2190315.41,2194634.04,4318.63,755760.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','207',4125,'9','2',1320472.52,1320472.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','207',4126,'10','2',1475337.17,1479220.85,3883.68,3106944.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','207',4127,'11','3',581095.24,581371.77,276.53,237813.22,0.00,0.00,0.00,0.00,0.00),('21','220','1','207',4128,'12','1',2272790.52,2276055.52,3265.00,571375.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','207',4129,'13','1',1464813.80,1466840.58,2026.78,354686.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','207',4130,'14','1',1619525.24,1622737.67,3212.43,562175.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','207',4131,'15','1',1782415.65,1784224.45,1808.80,316540.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','207',4132,'16','1',2721874.78,2726068.38,4193.60,733880.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','207',4133,'17','1',1773990.72,1776381.40,2390.68,418369.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','207',4134,'18','1',1510646.58,1513164.07,2517.49,440560.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','207',4135,'19','1',1615238.52,1618203.21,2964.69,518820.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','207',4136,'20','1',2191105.82,2195793.86,4688.04,820407.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','207',4137,'21','1',1619225.38,1621246.74,2021.36,353738.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','207',4138,'22','1',2063782.99,2067070.25,3287.26,575270.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','207',4139,'23','1',1793885.11,1796606.33,2721.22,476213.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','207',4140,'24','3',70025.92,70025.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','208',4141,'1','1',2323685.68,2325051.65,1365.97,239044.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','208',4142,'2','1',2012365.20,2013483.82,1118.62,195758.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','208',4143,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','208',4144,'4','1',2194634.04,2196904.73,2270.69,397370.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','208',4145,'9','2',1320472.52,1322749.48,2276.96,1821568.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','208',4146,'10','2',1479220.85,1483896.23,4675.38,3740304.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','208',4147,'11','3',581371.77,581730.36,358.59,308385.68,0.00,0.00,0.00,0.00,0.00),('21','220','1','208',4148,'12','1',2276055.52,2277097.00,1041.48,182259.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','208',4149,'13','1',1466840.58,1467643.73,803.15,140551.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','208',4150,'14','1',1622737.67,1623789.35,1051.68,184044.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','208',4151,'15','1',1784224.45,1785298.20,1073.75,187906.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','208',4152,'16','1',2726068.38,2729598.67,3530.29,617800.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','208',4153,'17','1',1776381.40,1779171.85,2790.45,488328.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','208',4154,'18','1',1513164.07,1516277.59,3113.52,544866.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','208',4155,'19','1',1618203.21,1620984.23,2781.02,486678.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','208',4156,'20','1',2195793.86,2199715.37,3921.51,686264.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','208',4157,'21','1',1621246.74,1623736.85,2490.11,435769.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','208',4158,'22','1',2067070.25,2069763.38,2693.13,471297.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','208',4159,'23','1',1796606.33,1799154.34,2548.01,445901.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','208',4160,'24','3',70025.92,70025.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','209',4161,'1','1',2325051.65,2326571.76,1520.11,266019.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','209',4162,'2','1',2013483.82,2014098.75,614.93,107612.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','209',4163,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','209',4164,'4','1',2196904.73,2198431.79,1527.06,267235.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','209',4165,'9','2',1322749.48,1323166.89,417.41,333928.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','209',4166,'10','2',1483896.23,1484929.36,1033.13,826504.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','209',4167,'11','3',581730.36,582314.82,584.46,502633.88,0.00,0.00,0.00,0.00,0.00),('21','220','1','209',4168,'12','1',2277097.00,2278029.86,932.86,163250.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','209',4169,'13','1',1467643.73,1468613.78,970.05,169758.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','209',4170,'14','1',1623789.35,1624974.85,1185.50,207462.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','209',4171,'15','1',1785298.20,1786203.35,905.15,158401.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','209',4172,'16','1',2729598.67,2734878.78,5280.11,924019.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','209',4173,'17','1',1779171.85,1782079.98,2908.13,508922.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','209',4174,'18','1',1516277.59,1520667.97,4390.38,768316.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','209',4175,'19','1',1620984.23,1624512.97,3528.74,617529.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','209',4176,'20','1',2199715.37,2203997.10,4281.73,749302.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','209',4177,'21','1',1623736.85,1628252.77,4515.92,790286.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','209',4178,'22','1',2069763.38,2074270.30,4506.92,788711.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','209',4179,'23','1',1799154.34,1802065.83,2911.49,509510.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','209',4180,'24','3',70025.92,70025.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','210',4181,'1','1',2326571.76,2326571.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','210',4182,'2','1',2014098.75,2014098.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','210',4183,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','210',4184,'4','1',2198431.79,2198431.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','210',4185,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','210',4186,'10','2',1484929.36,1485013.64,84.28,67424.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','210',4187,'11','3',582314.82,582619.06,304.24,261648.12,0.00,0.00,0.00,0.00,0.00),('21','220','1','210',4188,'12','1',2278029.86,2278029.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','210',4189,'13','1',1468613.78,1469037.42,423.64,74137.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','210',4190,'14','1',1624974.85,1625679.05,704.20,123235.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','210',4191,'15','1',1786203.35,1786806.06,602.71,105474.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','210',4192,'16','1',2734878.78,2738632.77,3753.99,656948.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','210',4193,'17','1',1782079.98,1785325.42,3245.44,567952.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','210',4194,'18','1',1520667.97,1523402.91,2734.94,478614.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','210',4195,'19','1',1624512.97,1627783.22,3270.25,572293.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','210',4196,'20','1',2203997.10,2208467.80,4470.70,782372.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','210',4197,'21','1',1628252.77,1630716.05,2463.28,431074.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','210',4198,'22','1',2074270.30,2077576.90,3306.60,578655.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','210',4199,'23','1',1802065.83,1805465.00,3399.17,594854.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','210',4200,'24','3',70025.92,70025.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','211',4201,'1','1',2326571.76,2329440.28,2868.52,501991.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','211',4202,'2','1',2014098.75,2018433.46,4334.71,758574.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','211',4203,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','211',4204,'4','1',2198431.79,2203149.99,4718.20,825685.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','211',4205,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','211',4206,'10','2',1485013.64,1485405.97,392.33,313864.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','211',4207,'11','3',582619.06,582672.51,53.45,45963.56,0.00,0.00,0.00,0.00,0.00),('21','220','1','211',4208,'12','1',2278029.86,2281334.93,3305.07,578387.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','211',4209,'13','1',1469037.42,1471091.05,2053.63,359385.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','211',4210,'14','1',1625679.05,1628312.32,2633.27,460822.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','211',4211,'15','1',1786806.06,1788971.39,2165.33,378932.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','211',4212,'16','1',2738632.77,2742179.59,3546.82,620693.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','211',4213,'17','1',1785325.42,1787198.50,1873.08,327789.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','211',4214,'18','1',1523402.91,1525683.00,2280.09,399015.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','211',4215,'19','1',1627783.22,1629826.16,2042.94,357514.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','211',4216,'20','1',2208467.80,2211469.47,3001.67,525292.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','211',4217,'21','1',1630716.05,1632842.00,2125.95,372041.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','211',4218,'22','1',2077576.90,2079634.61,2057.71,360099.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','211',4219,'23','1',1805465.00,1807362.51,1897.51,332064.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','211',4220,'24','3',70025.92,70386.76,360.84,310319.82,0.00,0.00,0.00,0.00,0.00),('21','220','1','212',4221,'1','1',2329440.28,2334452.73,5012.45,877178.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','212',4222,'2','1',2018433.46,2022568.03,4134.57,723549.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','212',4223,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','212',4224,'4','1',2203149.99,2209310.84,6160.85,1078148.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','212',4225,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','212',4226,'10','2',1485405.97,1485918.08,512.11,409688.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','212',4227,'11','3',582672.51,583152.19,479.68,412522.22,0.00,0.00,0.00,0.00,0.00),('21','220','1','212',4228,'12','1',2281334.93,2286502.70,5167.77,904359.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','212',4229,'13','1',1471091.05,1475498.00,4406.95,771216.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','212',4230,'14','1',1628312.32,1632732.72,4420.40,773570.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','212',4231,'15','1',1788971.39,1793500.79,4529.40,792645.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','212',4232,'16','1',2742179.59,2744235.87,2056.28,359849.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','212',4233,'17','1',1787198.50,1788736.30,1537.80,269115.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','212',4234,'18','1',1525683.00,1527167.13,1484.13,259722.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','212',4235,'19','1',1629826.16,1631284.99,1458.83,255295.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','212',4236,'20','1',2211469.47,2213290.95,1821.48,318759.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','212',4237,'21','1',1632842.00,1634083.58,1241.58,217276.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','212',4238,'22','1',2079634.61,2081045.64,1411.03,246930.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','212',4239,'23','1',1807362.51,1808905.84,1543.33,270082.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','212',4240,'24','3',70386.76,70513.29,126.53,108817.52,0.00,0.00,0.00,0.00,0.00),('21','220','1','213',4241,'1','1',2334452.73,2335240.12,787.39,137793.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','213',4242,'2','1',2022568.03,2024039.40,1471.37,257489.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','213',4243,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','213',4244,'4','1',2209310.84,2211648.07,2337.23,409015.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','213',4245,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','213',4246,'10','2',1485918.08,1485980.03,61.95,50489.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','213',4247,'11','3',583152.19,583482.25,330.06,283851.60,0.00,0.00,0.00,0.00,0.00),('21','220','1','213',4248,'12','1',2286502.70,2286951.28,448.58,78501.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','213',4249,'13','1',1475498.00,1476344.55,846.55,148146.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','213',4250,'14','1',1632732.72,1633580.86,848.14,148424.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','213',4251,'15','1',1793500.79,1794623.51,1122.72,196476.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','213',4252,'16','1',2744235.87,2745070.66,834.79,146088.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','213',4253,'17','1',1788736.30,1789712.66,976.36,170863.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','213',4254,'18','1',1527167.13,1528077.18,910.05,159258.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','213',4255,'19','1',1631284.99,1632164.84,879.85,153973.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','213',4256,'20','1',2213290.95,2214636.86,1345.91,235534.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','213',4257,'21','1',1634083.58,1634906.58,823.00,144025.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','213',4258,'22','1',2081045.64,2082035.28,989.64,173187.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','213',4259,'23','1',1808905.84,1810095.01,1189.17,208104.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','213',4260,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','214',4261,'1','1',2335240.12,2337078.41,1838.29,321700.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','214',4262,'2','1',2024039.40,2026188.25,2148.85,376048.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','214',4263,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','214',4264,'4','1',2211648.07,2214745.52,3097.45,542053.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','214',4265,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','214',4266,'10','2',1485980.03,1486217.88,237.85,193847.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','214',4267,'11','3',583482.25,583827.86,345.61,297227.18,0.00,0.00,0.00,0.00,0.00),('21','220','1','214',4268,'12','1',2286951.28,2289218.05,2266.77,396684.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','214',4269,'13','1',1476344.55,1478026.18,1681.63,294285.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','214',4270,'14','1',1633580.86,1635410.31,1829.45,320153.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','214',4271,'15','1',1794623.51,1796810.72,2187.21,382761.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','214',4272,'16','1',2745070.66,2747975.33,2904.67,508317.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','214',4273,'17','1',1789712.66,1791387.80,1675.14,293149.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','214',4274,'18','1',1528077.18,1530268.31,2191.13,383447.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','214',4275,'19','1',1632164.84,1634845.29,2680.45,469078.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','214',4276,'20','1',2214636.86,2217453.51,2816.65,492913.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','214',4277,'21','1',1634906.58,1637640.97,2734.39,478518.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','214',4278,'22','1',2082035.28,2084369.12,2333.84,408422.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','214',4279,'23','1',1810095.01,1812800.05,2705.04,473382.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','214',4280,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','215',4281,'1','1',2337078.41,2337078.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','215',4282,'2','1',2026188.25,2026188.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','215',4283,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','215',4284,'4','1',2214745.52,2214745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','215',4285,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','215',4286,'10','2',1486217.88,1486340.37,122.49,99829.35,0.00,0.00,0.00,0.00,0.00),('21','220','4','215',4287,'11','3',583827.86,584495.34,667.48,574031.08,0.00,0.00,0.00,0.00,0.00),('21','220','1','215',4288,'12','1',2289218.05,2289218.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','215',4289,'13','1',1478026.18,1478026.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','215',4290,'14','1',1635410.31,1635410.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','215',4291,'15','1',1796810.72,1796810.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','215',4292,'16','1',2747975.33,2749175.54,1200.21,210036.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','215',4293,'17','1',1791387.80,1792480.25,1092.45,191178.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','215',4294,'18','1',1530268.31,1531472.15,1203.84,210672.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','215',4295,'19','1',1634845.29,1636965.21,2119.92,370985.65,0.00,0.00,0.00,0.00,0.00),('21','220','2','215',4296,'20','1',2217453.51,2218796.58,1343.07,235037.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','215',4297,'21','1',1637640.97,1638481.36,840.39,147068.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','215',4298,'22','1',2084369.12,2085277.88,908.76,159033.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','215',4299,'23','1',1812800.05,1813985.08,1185.03,207380.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','215',4300,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','216',4301,'1','1',2337078.41,2337078.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','216',4302,'2','1',2026188.25,2026188.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','216',4303,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','216',4304,'4','1',2214745.52,2214745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','216',4305,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','216',4306,'10','2',1486340.37,1486340.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','216',4307,'11','3',584495.34,584776.47,281.13,241768.36,0.00,0.00,0.00,0.00,0.00),('21','220','1','216',4308,'12','1',2289218.05,2289218.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','216',4309,'13','1',1478026.18,1478026.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','216',4310,'14','1',1635410.31,1635410.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','216',4311,'15','1',1796810.72,1796810.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','216',4312,'16','1',2749175.54,2752533.46,3357.92,587636.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','216',4313,'17','1',1792480.25,1795289.98,2809.73,491702.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','216',4314,'18','1',1531472.15,1535118.08,3645.93,638037.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','216',4315,'19','1',1636965.21,1640099.37,3134.16,548478.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','216',4316,'20','1',2218796.58,2222790.59,3994.01,698951.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','216',4317,'21','1',1638481.36,1641214.85,2733.49,478360.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','216',4318,'22','1',2085277.88,2088297.38,3019.50,528412.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','216',4319,'23','1',1813985.08,1817640.19,3655.11,639644.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','216',4320,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','217',4321,'1','1',2337078.41,2337078.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','217',4322,'2','1',2026188.25,2026188.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','217',4323,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','217',4324,'4','1',2214745.52,2214745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','217',4325,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','217',4326,'10','2',1486340.37,1486367.98,27.61,22502.15,0.00,0.00,0.00,0.00,0.00),('21','220','4','217',4327,'11','3',584776.47,585405.32,628.85,540811.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','217',4328,'12','1',2289218.05,2289218.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','217',4329,'13','1',1478026.18,1478026.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','217',4330,'14','1',1635410.31,1635410.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','217',4331,'15','1',1796810.72,1796810.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','217',4332,'16','1',2752533.46,2752533.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','217',4333,'17','1',1795289.98,1795289.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','217',4334,'18','1',1535118.08,1535118.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','217',4335,'19','1',1640099.37,1640099.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','217',4336,'20','1',2222790.59,2222790.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','217',4337,'21','1',1641214.85,1643161.32,1946.47,340632.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','217',4338,'22','1',2088297.38,2088297.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','217',4339,'23','1',1817640.19,1817640.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','217',4340,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','218',4341,'1','1',2337078.41,2340203.58,3125.17,546904.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','218',4342,'2','1',2026188.25,2028992.23,2803.98,490696.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','218',4343,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','218',4344,'4','1',2214745.52,2218299.59,3554.07,621962.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','218',4345,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','218',4346,'10','2',1486367.98,1486457.52,89.54,72975.10,0.00,0.00,0.00,0.00,0.00),('21','220','4','218',4347,'11','3',585405.32,585680.88,275.56,236985.04,0.00,0.00,0.00,0.00,0.00),('21','220','1','218',4348,'12','1',2289218.05,2292023.16,2805.11,490894.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','218',4349,'13','1',1478026.18,1480601.47,2575.29,450675.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','218',4350,'14','1',1635410.31,1638341.20,2930.89,512905.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','218',4351,'15','1',1796810.72,1799723.03,2912.31,509654.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','218',4352,'16','1',2752533.46,2753997.82,1464.36,256263.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','218',4353,'17','1',1795289.98,1795910.71,620.73,108627.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','218',4354,'18','1',1535118.08,1535600.25,482.17,84379.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','218',4355,'19','1',1640099.37,1640678.04,578.67,101267.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','218',4356,'20','1',2222790.59,2224329.15,1538.56,269248.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','218',4357,'21','1',1643161.32,1644663.58,1502.26,262895.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','218',4358,'22','1',2088297.38,2088951.92,654.54,114544.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','218',4359,'23','1',1817640.19,1818925.77,1285.58,224976.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','218',4360,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','219',4361,'1','1',2340203.58,2343079.39,2875.81,503266.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','219',4362,'2','1',2028992.23,2031129.38,2137.15,374001.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','219',4363,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','219',4364,'4','1',2218299.59,2221501.51,3201.92,560336.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','219',4365,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','219',4366,'10','2',1486457.52,1486557.52,100.00,81500.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','219',4367,'11','3',585680.88,586004.18,323.30,278035.42,0.00,0.00,0.00,0.00,0.00),('21','220','1','219',4368,'12','1',2292023.16,2294273.74,2250.58,393851.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','219',4369,'13','1',1480601.47,1482634.16,2032.69,355720.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','219',4370,'14','1',1638341.20,1641888.79,3547.59,620828.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','219',4371,'15','1',1799723.03,1802054.92,2331.89,408080.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','219',4372,'16','1',2753997.82,2759199.56,5201.74,910304.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','219',4373,'17','1',1795910.71,1799789.18,3878.47,678732.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','219',4374,'18','1',1535600.25,1539670.02,4069.77,712209.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','219',4375,'19','1',1640678.04,1643420.53,2742.49,479935.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','219',4376,'20','1',2224329.15,2230157.41,5828.26,1019945.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','219',4377,'21','1',1644663.58,1648704.29,4040.71,707124.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','219',4378,'22','1',2088951.92,2092949.48,3997.56,699573.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','219',4379,'23','1',1818925.77,1823330.76,4404.99,770873.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','219',4380,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','220',4381,'1','1',2343079.39,2344159.94,1080.55,189096.95,0.00,0.00,0.00,0.00,0.00),('21','220','1','220',4382,'2','1',2031129.38,2032117.27,987.89,172880.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','220',4383,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','220',4384,'4','1',2221501.51,2223139.00,1637.49,286560.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','220',4385,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','220',4386,'10','2',1486557.52,1486590.64,33.12,26992.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','220',4387,'11','3',586004.18,586289.58,285.40,245440.56,0.00,0.00,0.00,0.00,0.00),('21','220','1','220',4388,'12','1',2294273.74,2295366.70,1092.96,191268.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','220',4389,'13','1',1482634.16,1483351.65,717.49,125560.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','220',4390,'14','1',1641888.79,1642812.68,923.89,161680.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','220',4391,'15','1',1802054.92,1803195.28,1140.36,199563.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','220',4392,'16','1',2759199.56,2762572.57,3373.01,590276.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','220',4393,'17','1',1799789.18,1801872.23,2083.05,364533.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','220',4394,'18','1',1539670.02,1542672.89,3002.87,525502.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','220',4395,'19','1',1643420.53,1646124.72,2704.19,473233.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','220',4396,'20','1',2230157.41,2233207.70,3050.29,533800.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','220',4397,'21','1',1648704.29,1651254.98,2550.69,446370.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','220',4398,'22','1',2092949.48,2095857.50,2908.02,508903.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','220',4399,'23','1',1823330.76,1825906.34,2575.58,450726.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','220',4400,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','221',4401,'1','1',2344159.94,2349301.37,5141.43,899750.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','221',4402,'2','1',2032117.27,2036289.55,4172.28,730149.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','221',4403,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','221',4404,'4','1',2223139.00,2227804.09,4665.09,816390.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','221',4405,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','221',4406,'10','2',1486590.64,1486714.91,124.27,101280.05,0.00,0.00,0.00,0.00,0.00),('21','220','4','221',4407,'11','3',586289.58,587013.29,723.71,622392.32,0.00,0.00,0.00,0.00,0.00),('21','220','1','221',4408,'12','1',2295366.70,2295387.76,21.06,3685.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','221',4409,'13','1',1483351.65,1488444.18,5092.53,891192.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','221',4410,'14','1',1642812.68,1646417.48,3604.80,630840.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','221',4411,'15','1',1803195.28,1806969.27,3773.99,660448.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','221',4412,'16','1',2762572.57,2767571.12,4998.55,874746.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','221',4413,'17','1',1801872.23,1805066.42,3194.19,558983.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','221',4414,'18','1',1542672.89,1546057.16,3384.27,592247.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','221',4415,'19','1',1646124.72,1649091.55,2966.83,519195.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','221',4416,'20','1',2233207.70,2237859.92,4652.22,814138.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','221',4417,'21','1',1651254.98,1654624.52,3369.54,589669.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','221',4418,'22','1',2095857.50,2099706.59,3849.09,673590.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','221',4419,'23','1',1825906.34,1829406.76,3500.42,612573.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','221',4420,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','222',4421,'1','1',2349301.37,2351815.19,2513.82,439918.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','222',4422,'2','1',2036289.55,2037997.21,1707.66,298840.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','222',4423,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','222',4424,'4','1',2227804.09,2229901.45,2097.36,367038.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','222',4425,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','222',4426,'10','2',1486714.91,1486714.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','222',4427,'11','3',587013.29,587356.04,342.75,294764.14,0.00,0.00,0.00,0.00,0.00),('21','220','1','222',4428,'12','1',2295387.76,2296714.99,1327.23,232265.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','222',4429,'13','1',1488444.18,1489818.55,1374.37,240514.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','222',4430,'14','1',1646417.48,1648032.43,1614.95,282616.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','222',4431,'15','1',1806969.27,1808136.38,1167.11,204244.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','222',4432,'16','1',2767571.12,2770348.39,2777.27,486022.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','222',4433,'17','1',1805066.42,1808426.61,3360.19,588033.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','222',4434,'18','1',1546057.16,1548146.89,2089.73,365702.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','222',4435,'19','1',1649091.55,1651074.20,1982.65,346963.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','222',4436,'20','1',2237859.92,2241626.42,3766.50,659137.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','222',4437,'21','1',1654624.52,1656565.46,1940.94,339664.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','222',4438,'22','1',2099706.59,2102177.14,2470.55,432346.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','222',4439,'23','1',1829406.76,1831763.26,2356.50,412387.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','222',4440,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','223',4441,'1','1',2351815.19,2354329.09,2513.90,439932.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','223',4442,'2','1',2037997.21,2039792.07,1794.86,314100.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','223',4443,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','223',4444,'4','1',2229901.45,2232185.03,2283.58,399626.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','223',4445,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','223',4446,'10','2',1486714.91,1487025.15,310.24,257499.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','223',4447,'11','3',587356.04,587593.38,237.34,204108.96,0.00,0.00,0.00,0.00,0.00),('21','220','1','223',4448,'12','1',2296714.99,2298902.81,2187.82,382868.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','223',4449,'13','1',1489818.55,1490968.43,1149.88,201229.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','223',4450,'14','1',1648032.43,1649716.70,1684.27,294747.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','223',4451,'15','1',1808136.38,1810087.76,1951.38,341491.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','223',4452,'16','1',2770348.39,2774736.62,4388.23,767940.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','223',4453,'17','1',1808426.61,1811718.71,3292.10,576117.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','223',4454,'18','1',1548146.89,1551327.80,3180.91,556659.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','223',4455,'19','1',1651074.20,1653914.73,2840.53,497092.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','223',4456,'20','1',2241626.42,2245392.61,3766.19,659083.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','223',4457,'21','1',1656565.46,1660104.53,3539.07,619337.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','223',4458,'22','1',2102177.14,2105235.92,3058.78,535286.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','223',4459,'23','1',1831763.26,1835471.64,3708.38,648966.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','223',4460,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','224',4461,'1','1',2354329.09,2354329.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','224',4462,'2','1',2039792.07,2044077.33,4285.26,749920.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','224',4463,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','224',4464,'4','1',2232185.03,2237166.91,4981.88,871829.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','224',4465,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','224',4466,'10','2',1487025.15,1488337.78,1312.63,1089482.90,0.00,0.00,0.00,0.00,0.00),('21','220','4','224',4467,'11','3',587593.38,588050.64,457.26,393242.74,0.00,0.00,0.00,0.00,0.00),('21','220','1','224',4468,'12','1',2298902.81,2299231.72,328.91,57559.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','224',4469,'13','1',1490968.43,1495106.63,4138.20,724185.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','224',4470,'14','1',1649716.70,1649716.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','224',4471,'15','1',1810087.76,1814286.41,4198.65,734763.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','224',4472,'16','1',2774736.62,2780455.09,5718.47,1000732.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','224',4473,'17','1',1811718.71,1813151.63,1432.92,250761.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','224',4474,'18','1',1551327.80,1556533.13,5205.33,910932.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','224',4475,'19','1',1653914.73,1656047.09,2132.36,373163.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','224',4476,'20','1',2245392.61,2250778.40,5385.79,942513.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','224',4477,'21','1',1660104.53,1665065.91,4961.38,868241.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','224',4478,'22','1',2105235.92,2110272.07,5036.15,881326.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','224',4479,'23','1',1835471.64,1840512.78,5041.14,882199.50,0.00,0.00,0.00,0.00,0.00),('21','220','4','224',4480,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','225',4481,'1','1',2354329.09,2355449.08,1119.99,195998.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','225',4482,'2','1',2044077.33,2044825.30,747.97,130894.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','225',4483,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','225',4484,'4','1',2237166.91,2238709.05,1542.14,269874.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','225',4485,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','225',4486,'10','2',1488337.78,1491274.00,2936.22,2437062.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','225',4487,'11','3',588050.64,588671.28,620.64,533753.84,0.00,0.00,0.00,0.00,0.00),('21','220','1','225',4488,'12','1',2299231.72,2300431.45,1199.73,209952.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','225',4489,'13','1',1495106.63,1495837.91,731.28,127974.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','225',4490,'14','1',1649716.70,1650883.24,1166.54,204144.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','225',4491,'15','1',1814286.41,1815313.66,1027.25,179768.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','225',4492,'16','1',2780455.09,2781579.72,1124.63,196810.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','225',4493,'17','1',1813151.63,1813746.53,594.90,104107.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','225',4494,'18','1',1556533.13,1557216.16,683.03,119530.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','225',4495,'19','1',1656047.09,1660687.57,4640.48,812084.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','225',4496,'20','1',2250778.40,2252080.84,1302.44,227927.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','225',4497,'21','1',1665065.91,1665947.65,881.74,154304.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','225',4498,'22','1',2110272.07,2111530.49,1258.42,220223.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','225',4499,'23','1',1840512.78,1841709.98,1197.20,209510.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','225',4500,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','226',4501,'1','1',2355449.08,2356886.48,1437.40,251545.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','226',4502,'2','1',2044825.30,2045700.52,875.22,153163.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','226',4503,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','226',4504,'4','1',2238709.05,2240446.84,1737.79,304113.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','226',4505,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','226',4506,'10','2',1491274.00,1497322.26,6048.26,5020055.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','226',4507,'11','3',588671.28,588868.73,197.45,169807.86,0.00,0.00,0.00,0.00,0.00),('21','220','1','226',4508,'12','1',2300431.45,2301725.82,1294.37,226514.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','226',4509,'13','1',1495837.91,1496625.10,787.19,137758.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','226',4510,'14','1',1650883.24,1652435.78,1552.54,271694.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','226',4511,'15','1',1815313.66,1816917.21,1603.55,280621.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','226',4512,'16','1',2781579.72,2784136.40,2556.68,447419.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','226',4513,'17','1',1813746.53,1816460.41,2713.88,474929.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','226',4514,'18','1',1557216.16,1560109.69,2893.53,506367.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','226',4515,'19','1',1660687.57,1663006.96,2319.39,405893.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','226',4516,'20','1',2252080.84,2255531.83,3450.99,603923.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','226',4517,'21','1',1665947.65,1668991.79,3044.14,532724.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','226',4518,'22','1',2111530.49,2113945.40,2414.91,422609.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','226',4519,'23','1',1841709.98,1844991.43,3281.45,574253.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','226',4520,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','227',4521,'1','1',2356886.48,2358769.59,1883.11,329544.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','227',4522,'2','1',2045700.52,2047522.42,1821.90,318832.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','227',4523,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','227',4524,'4','1',2240446.84,2242627.93,2181.09,381690.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','227',4525,'9','2',1323166.89,1323166.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','227',4526,'10','2',1497322.26,1501749.60,4427.34,3674692.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','227',4527,'11','3',588868.73,589171.63,302.90,260490.56,0.00,0.00,0.00,0.00,0.00),('21','220','1','227',4528,'12','1',2301725.82,2303364.58,1638.76,286783.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','227',4529,'13','1',1496625.10,1498190.65,1565.55,273971.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','227',4530,'14','1',1652435.78,1654162.59,1726.81,302191.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','227',4531,'15','1',1816917.21,1818410.67,1493.46,261355.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','227',4532,'16','1',2784136.40,2787491.65,3355.25,587168.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','227',4533,'17','1',1816460.41,1819694.90,3234.49,566035.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','227',4534,'18','1',1560109.69,1563379.49,3269.80,572215.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','227',4535,'19','1',1663006.96,1666564.17,3557.21,622511.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','227',4536,'20','1',2255531.83,2259522.51,3990.68,698369.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','227',4537,'21','1',1668991.79,1672261.48,3269.69,572195.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','227',4538,'22','1',2113945.40,2117538.51,3593.11,628794.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','227',4539,'23','1',1844991.43,1848216.72,3225.29,564425.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','227',4540,'24','3',70513.29,70513.29,0.00,1.72,0.00,0.00,0.00,0.00,0.00),('21','220','1','228',4541,'1','1',2358769.59,2360588.49,1818.90,318307.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','228',4542,'2','1',2047522.42,2048789.88,1267.46,221805.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','228',4543,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','228',4544,'4','1',2242627.93,2244669.00,2041.07,357187.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','228',4545,'9','2',1323166.89,1323715.88,548.99,455661.70,0.00,0.00,0.00,0.00,0.00),('21','220','3','228',4546,'10','2',1501749.60,1507084.16,5334.56,4427684.80,0.00,0.00,0.00,0.00,0.00),('21','220','4','228',4547,'11','3',589171.63,589492.45,320.82,275904.34,0.00,0.00,0.00,0.00,0.00),('21','220','1','228',4548,'12','1',2303364.58,2304946.39,1581.81,276817.10,0.00,0.00,0.00,0.00,0.00),('21','220','1','228',4549,'13','1',1498190.65,1499569.22,1378.57,241249.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','228',4550,'14','1',1654162.59,1655624.87,1462.28,255899.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','228',4551,'15','1',1818410.67,1819970.39,1559.72,272951.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','228',4552,'16','1',2787491.65,2789163.11,1671.46,292505.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','228',4553,'17','1',1819694.90,1820458.52,763.62,133633.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','228',4554,'18','1',1563379.49,1564217.93,838.44,146727.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','228',4555,'19','1',1666564.17,1668008.87,1444.70,252822.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','228',4556,'20','1',2259522.51,2261266.95,1744.44,305277.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','228',4557,'21','1',1672261.48,1673728.51,1467.03,256730.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','228',4558,'22','1',2117538.51,2118857.40,1318.89,230805.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','228',4559,'23','1',1848216.72,1850186.49,1969.77,344709.75,0.00,0.00,0.00,0.00,0.00),('21','220','4','228',4560,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','229',4561,'1','1',2360588.49,2362245.47,1656.98,289971.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','229',4562,'2','1',2048789.88,2050818.08,2028.20,354935.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','229',4563,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','229',4564,'4','1',2244669.00,2247086.83,2417.83,423120.25,0.00,0.00,0.00,0.00,0.00),('21','220','3','229',4565,'9','2',1323715.88,1323715.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','229',4566,'10','2',1507084.16,1510026.88,2942.72,2442457.60,0.00,0.00,0.00,0.00,0.00),('21','220','4','229',4567,'11','3',589492.45,589805.20,312.75,268965.86,0.00,0.00,0.00,0.00,0.00),('21','220','1','229',4568,'12','1',2304946.39,2306237.73,1291.34,225984.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','229',4569,'13','1',1499569.22,1500992.75,1423.53,249117.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','229',4570,'14','1',1655624.87,1656271.93,647.06,113235.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','229',4571,'15','1',1819970.39,1823774.70,3804.31,665754.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','229',4572,'16','1',2789163.11,2794429.92,5266.81,921691.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','229',4573,'17','1',1820458.52,1824388.82,3930.30,687802.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','229',4574,'18','1',1564217.93,1567989.18,3771.25,659968.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','229',4575,'19','1',1668008.87,1671400.59,3391.72,593551.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','229',4576,'20','1',2261266.95,2266250.89,4983.94,872189.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','229',4577,'21','1',1673728.51,1678438.27,4709.76,824208.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','229',4578,'22','1',2118857.40,2122143.57,3286.17,575079.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','229',4579,'23','1',1850186.49,1854493.81,4307.32,753781.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','229',4580,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','230',4581,'1','1',2362245.47,2362245.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','230',4582,'2','1',2050818.08,2050818.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','230',4583,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','230',4584,'4','1',2247086.83,2250536.96,3450.13,603772.75,0.00,0.00,0.00,0.00,0.00),('21','220','3','230',4585,'9','2',1323715.88,1323715.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','230',4586,'10','2',1510026.88,1510175.07,148.19,122997.70,0.00,0.00,0.00,0.00,0.00),('21','220','4','230',4587,'11','3',589805.20,589958.50,153.30,131838.86,0.00,0.00,0.00,0.00,0.00),('21','220','1','230',4588,'12','1',2306237.73,2306237.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','230',4589,'13','1',1500992.75,1500992.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','230',4590,'14','1',1656271.93,1656271.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','230',4591,'15','1',1823774.70,1823774.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','230',4592,'16','1',2794429.92,2794429.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','230',4593,'17','1',1824388.82,1824388.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','230',4594,'18','1',1567989.18,1567989.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','230',4595,'19','1',1671400.59,1671400.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','230',4596,'20','1',2266250.89,2266250.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','230',4597,'21','1',1678438.27,1678438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','230',4598,'22','1',2122143.57,2122143.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','230',4599,'23','1',1854493.81,1854493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','230',4600,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','231',4601,'1','1',2362245.47,2362670.62,425.15,74401.25,0.00,0.00,0.00,0.00,0.00),('21','220','1','231',4602,'2','1',2050818.08,2050818.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','231',4603,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','231',4604,'4','1',2250536.96,2252130.78,1593.82,278918.50,0.00,0.00,0.00,0.00,0.00),('21','220','3','231',4605,'9','2',1323715.88,1323715.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','231',4606,'10','2',1510175.07,1510300.07,125.00,103750.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','231',4607,'11','3',589958.50,590173.75,215.25,185117.58,0.00,0.00,0.00,0.00,0.00),('21','220','1','231',4608,'12','1',2306237.73,2306237.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','231',4609,'13','1',1500992.75,1500992.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','231',4610,'14','1',1656271.93,1656271.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','231',4611,'15','1',1823774.70,1824661.82,887.12,155246.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','231',4612,'16','1',2794429.92,2797026.65,2596.73,454427.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','231',4613,'17','1',1824388.82,1826582.42,2193.60,383880.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','231',4614,'18','1',1567989.18,1570177.52,2188.34,382959.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','231',4615,'19','1',1671400.59,1673791.73,2391.14,418449.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','231',4616,'20','1',2266250.89,2269031.48,2780.59,486603.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','231',4617,'21','1',1678438.27,1681195.82,2757.55,482571.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','231',4618,'22','1',2122143.57,2124483.36,2339.79,409463.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','231',4619,'23','1',1854493.81,1857021.40,2527.59,442328.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','231',4620,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','232',4621,'1','1',2362670.62,2364354.78,1684.16,294728.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','232',4622,'2','1',2050818.08,2050818.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','232',4623,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','232',4624,'4','1',2252130.78,2252130.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','232',4625,'9','2',1323715.88,1323715.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','232',4626,'10','2',1510300.07,1512271.91,1971.84,1636627.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','232',4627,'11','3',590173.75,590539.75,366.00,314761.72,0.00,0.00,0.00,0.00,0.00),('21','220','1','232',4628,'12','1',2306237.73,2307852.47,1614.74,282579.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','232',4629,'13','1',1500992.75,1502071.19,1078.44,188727.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','232',4630,'14','1',1656271.93,1657979.39,1707.46,298805.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','232',4631,'15','1',1824661.82,1829963.41,5301.59,927778.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','232',4632,'16','1',2797026.65,2797026.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','232',4633,'17','1',1826582.42,1826582.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','232',4634,'18','1',1570177.52,1570177.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','232',4635,'19','1',1673791.73,1673791.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','232',4636,'20','1',2269031.48,2269031.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','232',4637,'21','1',1681195.82,1681195.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','232',4638,'22','1',2124483.36,2124483.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','232',4639,'23','1',1857021.40,1857021.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','232',4640,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','233',4641,'1','1',2364354.78,2366792.84,2438.06,426660.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','233',4642,'2','1',2050818.08,2054057.14,3239.06,566835.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','233',4643,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','233',4644,'4','1',2252130.78,2257120.62,4989.84,873222.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','233',4645,'9','2',1323715.88,1323715.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','233',4646,'10','2',1512271.91,1517296.25,5024.34,4170202.20,0.00,0.00,0.00,0.00,0.00),('21','220','4','233',4647,'11','3',590539.75,590873.13,333.38,286702.50,0.00,0.00,0.00,0.00,0.00),('21','220','1','233',4648,'12','1',2307852.47,2309707.09,1854.62,324558.52,0.00,0.00,0.00,0.00,0.00),('21','220','1','233',4649,'13','1',1502071.19,1503959.68,1888.49,330485.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','233',4650,'14','1',1657979.39,1661445.88,3466.49,606635.75,0.00,0.00,0.00,0.00,0.00),('21','220','1','233',4651,'15','1',1829963.41,1833056.27,3092.86,541250.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','233',4652,'16','1',2797026.65,2803705.07,6678.42,1168723.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','233',4653,'17','1',1826582.42,1831213.79,4631.37,810489.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','233',4654,'18','1',1570177.52,1575737.15,5559.63,972935.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','233',4655,'19','1',1673791.73,1679869.39,6077.66,1063590.50,0.00,0.00,0.00,0.00,0.00),('21','220','2','233',4656,'20','1',2269031.48,2276122.85,7091.37,1240989.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','233',4657,'21','1',1681195.82,1687028.79,5832.97,1020769.75,0.00,0.00,0.00,0.00,0.00),('21','220','2','233',4658,'22','1',2124483.36,2130850.19,6366.83,1114195.25,0.00,0.00,0.00,0.00,0.00),('21','220','2','233',4659,'23','1',1857021.40,1860629.43,3608.03,631405.25,0.00,0.00,0.00,0.00,0.00),('21','220','4','233',4660,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','234',4661,'1','1',2366792.84,2366792.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','234',4662,'2','1',2054057.14,2054057.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','234',4663,'3','1',1783068.27,1783068.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','234',4664,'4','1',2257120.62,2257120.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','234',4665,'9','2',1323715.88,1323715.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','3','234',4666,'10','2',1517296.25,1517296.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','234',4667,'11','3',590873.13,590873.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','234',4668,'12','1',2309707.09,2309707.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','234',4669,'13','1',1503959.68,1503959.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','234',4670,'14','1',1661445.88,1661445.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','1','234',4671,'15','1',1833056.27,1833056.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','234',4672,'16','1',2803705.07,2803705.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','234',4673,'17','1',1831213.79,1831213.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','234',4674,'18','1',1575737.15,1575737.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','234',4675,'19','1',1679869.39,1679869.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','234',4676,'20','1',2276122.85,2276122.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','234',4677,'21','1',1687028.79,1687028.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','234',4678,'22','1',2130850.19,2130850.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','2','234',4679,'23','1',1860629.43,1860629.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','220','4','234',4680,'24','3',70513.29,70513.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=703 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','220','4','2',700.00,700.00,7712.46,0.00,0.00,0.00,0.00,10),('21','220','4','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,11),('21','220','4','1',165.00,165.00,34131.85,0.00,0.00,0.00,0.00,12),('21','220','5','2',700.00,700.00,11680.67,0.00,0.00,0.00,0.00,13),('21','220','5','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,14),('21','220','5','1',165.00,165.00,45512.65,0.00,0.00,0.00,0.00,15),('21','220','6','2',700.00,700.00,3289.96,0.00,0.00,0.00,0.00,16),('21','220','6','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,17),('21','220','6','1',165.00,165.00,66364.99,0.00,0.00,0.00,0.00,18),('21','220','7','2',700.00,700.00,6939.38,0.00,0.00,0.00,0.00,19),('21','220','7','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,20),('21','220','7','1',165.00,165.00,57768.17,0.00,0.00,0.00,0.00,21),('21','220','8','2',700.00,700.00,3271.95,0.00,0.00,0.00,0.00,22),('21','220','8','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,23),('21','220','8','1',165.00,165.00,51684.82,0.00,0.00,0.00,0.00,24),('21','220','9','2',700.00,700.00,414.19,0.00,0.00,0.00,0.00,25),('21','220','9','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,26),('21','220','9','1',165.00,165.00,54312.80,0.00,0.00,0.00,0.00,27),('21','220','10','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,28),('21','220','10','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,29),('21','220','10','1',165.00,165.00,36781.32,0.00,0.00,0.00,0.00,30),('21','220','11','1',165.00,165.00,35312.07,0.00,0.00,0.00,0.00,31),('21','220','11','2',700.00,700.00,1172.00,0.00,0.00,0.00,0.00,32),('21','220','11','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,33),('21','220','12','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,34),('21','220','12','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,35),('21','220','12','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,36),('21','220','13','2',700.00,700.00,8050.10,0.00,0.00,0.00,0.00,37),('21','220','13','3',550.00,550.00,1191.99,0.00,0.00,0.00,0.00,38),('21','220','13','1',165.00,165.00,85648.22,0.00,0.00,0.00,0.00,39),('21','220','14','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,40),('21','220','14','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,41),('21','220','14','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,42),('21','220','15','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,43),('21','220','15','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,44),('21','220','15','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,45),('21','220','16','1',165.00,165.00,73437.91,0.00,0.00,0.00,0.00,46),('21','220','16','2',700.00,700.00,10248.48,0.00,0.00,0.00,0.00,47),('21','220','16','3',550.00,550.00,2329.85,0.00,0.00,0.00,0.00,48),('21','220','17','1',165.00,165.00,46010.75,0.00,0.00,0.00,0.00,49),('21','220','17','2',700.00,700.00,9181.68,0.00,0.00,0.00,0.00,50),('21','220','17','3',550.00,550.00,1764.67,0.00,0.00,0.00,0.00,51),('21','220','18','1',165.00,165.00,46645.60,0.00,0.00,0.00,0.00,52),('21','220','18','2',700.00,700.00,11053.39,0.00,0.00,0.00,0.00,53),('21','220','18','3',550.00,550.00,1602.22,0.00,0.00,0.00,0.00,54),('21','220','19','1',165.00,165.00,57675.22,0.00,0.00,0.00,0.00,55),('21','220','19','2',700.00,700.00,5376.60,0.00,0.00,0.00,0.00,56),('21','220','19','3',550.00,550.00,1742.17,0.00,0.00,0.00,0.00,57),('21','220','20','1',165.00,165.00,44106.17,0.00,0.00,0.00,0.00,58),('21','220','20','2',700.00,700.00,4642.42,0.00,0.00,0.00,0.00,59),('21','220','20','3',550.00,550.00,705.89,0.00,0.00,0.00,0.00,60),('21','220','21','2',700.00,700.00,6561.54,0.00,0.00,0.00,0.00,61),('21','220','21','3',550.00,550.00,1816.72,0.00,0.00,0.00,0.00,62),('21','220','21','1',165.00,165.00,56082.40,0.00,0.00,0.00,0.00,63),('21','220','22','1',165.00,165.00,52255.82,0.00,0.00,0.00,0.00,64),('21','220','22','2',700.00,700.00,2154.53,0.00,0.00,0.00,0.00,65),('21','220','22','3',550.00,550.00,1869.65,0.00,0.00,0.00,0.00,66),('21','220','23','1',165.00,165.00,68371.54,0.00,0.00,0.00,0.00,67),('21','220','23','2',700.00,700.00,821.69,0.00,0.00,0.00,0.00,68),('21','220','23','3',550.00,550.00,948.03,0.00,0.00,0.00,0.00,69),('21','220','24','2',700.00,700.00,6751.49,0.00,0.00,0.00,0.00,70),('21','220','24','3',550.00,550.00,1086.80,0.00,0.00,0.00,0.00,71),('21','220','24','1',165.00,165.00,50215.09,0.00,0.00,0.00,0.00,72),('21','220','25','1',165.00,165.00,53201.29,0.00,0.00,0.00,0.00,73),('21','220','25','2',700.00,700.00,7039.47,0.00,0.00,0.00,0.00,74),('21','220','25','3',550.00,550.00,2203.13,0.00,0.00,0.00,0.00,75),('21','220','26','1',165.00,165.00,47441.60,0.00,0.00,0.00,0.00,76),('21','220','26','2',700.00,700.00,13093.14,0.00,0.00,0.00,0.00,77),('21','220','26','3',550.00,550.00,2825.74,0.00,0.00,0.00,0.00,78),('21','220','27','1',165.00,165.00,51710.06,0.00,0.00,0.00,0.00,79),('21','220','27','2',700.00,700.00,1966.31,0.00,0.00,0.00,0.00,80),('21','220','27','3',550.00,550.00,833.07,0.00,0.00,0.00,0.00,81),('21','220','28','2',700.00,700.00,6414.09,0.00,0.00,0.00,0.00,82),('21','220','28','3',550.00,550.00,2839.43,0.00,0.00,0.00,0.00,83),('21','220','28','1',165.00,165.00,51494.74,0.00,0.00,0.00,0.00,84),('21','220','29','2',700.00,700.00,8201.93,0.00,0.00,0.00,0.00,85),('21','220','29','3',550.00,550.00,3114.30,0.00,0.00,0.00,0.00,86),('21','220','29','1',165.00,165.00,49075.73,0.00,0.00,0.00,0.00,87),('21','220','30','1',165.00,165.00,54071.58,0.00,0.00,0.00,0.00,88),('21','220','30','2',700.00,700.00,4609.53,0.00,0.00,0.00,0.00,89),('21','220','30','3',550.00,550.00,2648.03,0.00,0.00,0.00,0.00,90),('21','220','31','1',165.00,165.00,57497.80,0.00,0.00,0.00,0.00,91),('21','220','31','2',700.00,700.00,4508.77,0.00,0.00,0.00,0.00,92),('21','220','31','3',550.00,550.00,909.69,0.00,0.00,0.00,0.00,93),('21','220','32','2',700.00,700.00,4730.16,0.00,0.00,0.00,0.00,94),('21','220','32','3',550.00,550.00,3016.17,0.00,0.00,0.00,0.00,95),('21','220','32','1',165.00,165.00,38261.97,0.00,0.00,0.00,0.00,96),('21','220','33','1',165.00,165.00,48261.83,0.00,0.00,0.00,0.00,97),('21','220','33','2',700.00,700.00,3820.80,0.00,0.00,0.00,0.00,98),('21','220','33','3',550.00,550.00,1842.51,0.00,0.00,0.00,0.00,99),('21','220','34','2',700.00,700.00,2859.12,0.00,0.00,0.00,0.00,100),('21','220','34','3',550.00,550.00,1069.76,0.00,0.00,0.00,0.00,101),('21','220','34','1',165.00,165.00,35750.82,0.00,0.00,0.00,0.00,102),('21','220','35','1',165.00,165.00,58554.27,0.00,0.00,0.00,0.00,103),('21','220','35','2',700.00,700.00,10486.15,0.00,0.00,0.00,0.00,104),('21','220','35','3',550.00,550.00,2894.81,0.00,0.00,0.00,0.00,105),('21','220','36','1',165.00,165.00,70302.60,0.00,0.00,0.00,0.00,106),('21','220','36','2',700.00,700.00,5643.61,0.00,0.00,0.00,0.00,107),('21','220','36','3',550.00,550.00,1668.28,0.00,0.00,0.00,0.00,108),('21','220','37','1',165.00,165.00,64270.09,0.00,0.00,0.00,0.00,109),('21','220','37','2',700.00,700.00,214.28,0.00,0.00,0.00,0.00,110),('21','220','37','3',550.00,550.00,4540.37,0.00,0.00,0.00,0.00,111),('21','220','38','2',700.00,700.00,1390.57,0.00,0.00,0.00,0.00,112),('21','220','38','3',550.00,550.00,2029.73,0.00,0.00,0.00,0.00,113),('21','220','38','1',165.00,165.00,62380.21,0.00,0.00,0.00,0.00,114),('21','220','39','2',700.00,700.00,4681.25,0.00,0.00,0.00,0.00,115),('21','220','39','3',550.00,550.00,1401.12,0.00,0.00,0.00,0.00,116),('21','220','39','1',165.00,165.00,65888.50,0.00,0.00,0.00,0.00,117),('21','220','40','2',700.00,700.00,3202.45,0.00,0.00,0.00,0.00,118),('21','220','40','3',550.00,550.00,2649.84,0.00,0.00,0.00,0.00,119),('21','220','40','1',165.00,165.00,52361.64,0.00,0.00,0.00,0.00,120),('21','220','41','1',165.00,165.00,42749.94,0.00,0.00,0.00,0.00,121),('21','220','41','2',700.00,700.00,5030.14,0.00,0.00,0.00,0.00,122),('21','220','41','3',550.00,550.00,925.05,0.00,0.00,0.00,0.00,123),('21','220','42','1',165.00,165.00,65405.55,0.00,0.00,0.00,0.00,124),('21','220','42','2',700.00,700.00,1500.10,0.00,0.00,0.00,0.00,125),('21','220','42','3',550.00,550.00,2311.12,0.00,0.00,0.00,0.00,126),('21','220','43','2',700.00,700.00,3115.70,0.00,0.00,0.00,0.00,127),('21','220','43','3',550.00,550.00,2574.90,0.00,0.00,0.00,0.00,128),('21','220','43','1',165.00,165.00,63013.17,0.00,0.00,0.00,0.00,129),('21','220','44','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,130),('21','220','44','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,131),('21','220','44','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,132),('21','220','45','1',165.00,165.00,58619.70,0.00,0.00,0.00,0.00,133),('21','220','45','2',700.00,700.00,4622.37,0.00,0.00,0.00,0.00,134),('21','220','45','3',550.00,550.00,2385.28,0.00,0.00,0.00,0.00,135),('21','220','46','2',700.00,700.00,5100.81,0.00,0.00,0.00,0.00,136),('21','220','46','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,137),('21','220','46','1',165.00,165.00,58057.12,0.00,0.00,0.00,0.00,138),('21','220','47','2',700.00,700.00,328.60,0.00,0.00,0.00,0.00,139),('21','220','47','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,140),('21','220','47','1',165.00,165.00,45571.93,0.00,0.00,0.00,0.00,141),('21','220','48','1',165.00,165.00,44910.38,0.00,0.00,0.00,0.00,142),('21','220','48','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,143),('21','220','48','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,144),('21','220','49','1',165.00,165.00,41953.52,0.00,0.00,0.00,0.00,145),('21','220','49','2',700.00,700.00,150.72,0.00,0.00,0.00,0.00,146),('21','220','49','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,147),('21','220','50','1',165.00,165.00,34945.78,0.00,0.00,0.00,0.00,148),('21','220','50','2',700.00,700.00,4471.69,0.00,0.00,0.00,0.00,149),('21','220','50','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,150),('21','220','51','1',165.00,165.00,7892.98,0.00,0.00,0.00,0.00,151),('21','220','51','2',700.00,700.00,1790.52,0.00,0.00,0.00,0.00,152),('21','220','51','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,153),('21','220','52','2',700.00,700.00,3672.97,0.00,0.00,0.00,0.00,154),('21','220','52','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,155),('21','220','52','1',165.00,165.00,55409.25,0.00,0.00,0.00,0.00,156),('21','220','53','2',700.00,700.00,5615.75,0.00,0.00,0.00,0.00,157),('21','220','53','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,158),('21','220','53','1',165.00,165.00,58718.69,0.00,0.00,0.00,0.00,159),('21','220','54','1',165.00,165.00,50189.01,0.00,0.00,0.00,0.00,160),('21','220','54','2',700.00,700.00,3950.79,0.00,0.00,0.00,0.00,161),('21','220','54','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,162),('21','220','55','1',165.00,165.00,55991.55,0.00,0.00,0.00,0.00,163),('21','220','55','2',700.00,700.00,5703.32,0.00,0.00,0.00,0.00,164),('21','220','55','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,165),('21','220','56','2',700.00,700.00,2724.21,0.00,0.00,0.00,0.00,166),('21','220','56','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,167),('21','220','56','1',165.00,165.00,32096.32,0.00,0.00,0.00,0.00,168),('21','220','57','2',700.00,700.00,5390.95,0.00,0.00,0.00,0.00,169),('21','220','57','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,170),('21','220','57','1',165.00,165.00,44940.08,0.00,0.00,0.00,0.00,171),('21','220','58','1',165.00,165.00,46469.58,0.00,0.00,0.00,0.00,172),('21','220','58','2',700.00,700.00,2463.50,0.00,0.00,0.00,0.00,173),('21','220','58','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,174),('21','220','59','1',165.00,165.00,59745.14,0.00,0.00,0.00,0.00,175),('21','220','59','2',700.00,700.00,4255.24,0.00,0.00,0.00,0.00,176),('21','220','59','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,177),('21','220','60','1',165.00,165.00,38564.94,0.00,0.00,0.00,0.00,178),('21','220','60','2',700.00,700.00,4788.18,0.00,0.00,0.00,0.00,179),('21','220','60','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,180),('21','220','61','1',165.00,165.00,66936.22,0.00,0.00,0.00,0.00,181),('21','220','61','2',700.00,700.00,5175.66,0.00,0.00,0.00,0.00,182),('21','220','61','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,183),('21','220','62','1',165.00,165.00,72148.11,0.00,0.00,0.00,0.00,184),('21','220','62','2',700.00,700.00,1374.87,0.00,0.00,0.00,0.00,185),('21','220','62','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,186),('21','220','63','2',720.00,720.00,6059.74,0.00,0.00,0.00,0.00,187),('21','220','63','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,188),('21','220','63','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,189),('21','220','64','1',165.00,165.00,70597.05,0.00,0.00,0.00,0.00,190),('21','220','64','2',720.00,720.00,2699.01,0.00,0.00,0.00,0.00,191),('21','220','64','3',650.00,650.00,1081.48,0.00,0.00,0.00,0.00,192),('21','220','65','1',165.00,165.00,76141.68,0.00,0.00,0.00,0.00,193),('21','220','65','2',720.00,720.00,4704.43,0.00,0.00,0.00,0.00,194),('21','220','65','3',650.00,650.00,1223.56,0.00,0.00,0.00,0.00,195),('21','220','66','1',165.00,165.00,69473.29,0.00,0.00,0.00,0.00,196),('21','220','66','2',720.00,720.00,3451.52,0.00,0.00,0.00,0.00,197),('21','220','66','3',650.00,650.00,1621.43,0.00,0.00,0.00,0.00,198),('21','220','67','1',165.00,165.00,63982.51,0.00,0.00,0.00,0.00,199),('21','220','67','2',720.00,720.00,6627.25,0.00,0.00,0.00,0.00,200),('21','220','67','3',650.00,650.00,1523.70,0.00,0.00,0.00,0.00,201),('21','220','68','2',720.00,720.00,9352.09,0.00,0.00,0.00,0.00,202),('21','220','68','3',650.00,650.00,1183.75,0.00,0.00,0.00,0.00,203),('21','220','68','1',165.00,165.00,68289.60,0.00,0.00,0.00,0.00,204),('21','220','69','1',165.00,165.00,60111.28,0.00,0.00,0.00,0.00,205),('21','220','69','2',720.00,720.00,5890.31,0.00,0.00,0.00,0.00,206),('21','220','69','3',650.00,650.00,1142.91,0.00,0.00,0.00,0.00,207),('21','220','70','2',720.00,720.00,3571.66,0.00,0.00,0.00,0.00,208),('21','220','70','3',650.00,650.00,739.59,0.00,0.00,0.00,0.00,209),('21','220','70','1',165.00,165.00,63053.17,0.00,0.00,0.00,0.00,210),('21','220','71','2',720.00,720.00,2576.43,0.00,0.00,0.00,0.00,211),('21','220','71','3',650.00,650.00,1357.87,0.00,0.00,0.00,0.00,212),('21','220','71','1',165.00,165.00,41091.34,0.00,0.00,0.00,0.00,213),('21','220','72','2',720.00,720.00,622.42,0.00,0.00,0.00,0.00,214),('21','220','72','3',650.00,650.00,1622.47,0.00,0.00,0.00,0.00,215),('21','220','72','1',165.00,165.00,59094.90,0.00,0.00,0.00,0.00,216),('21','220','73','2',760.00,760.00,7286.72,0.00,0.00,0.00,0.00,217),('21','220','73','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,218),('21','220','73','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,219),('21','220','74','1',165.00,165.00,42782.49,0.00,0.00,0.00,0.00,220),('21','220','74','2',760.00,760.00,7864.65,0.00,0.00,0.00,0.00,221),('21','220','74','3',650.00,650.00,2958.20,0.00,0.00,0.00,0.00,222),('21','220','75','2',760.00,760.00,9696.24,0.00,0.00,0.00,0.00,223),('21','220','75','3',650.00,650.00,1702.28,0.00,0.00,0.00,0.00,224),('21','220','75','1',165.00,165.00,46961.43,0.00,0.00,0.00,0.00,225),('21','220','76','1',165.00,165.00,61222.48,0.00,0.00,0.00,0.00,226),('21','220','76','2',760.00,760.00,1972.66,0.00,0.00,0.00,0.00,227),('21','220','76','3',650.00,650.00,1245.51,0.00,0.00,0.00,0.00,228),('21','220','77','1',165.00,165.00,61912.36,0.00,0.00,0.00,0.00,229),('21','220','77','2',760.00,760.00,605.01,0.00,0.00,0.00,0.00,230),('21','220','77','3',650.00,650.00,1090.92,0.00,0.00,0.00,0.00,231),('21','220','78','1',165.00,165.00,37187.75,0.00,0.00,0.00,0.00,232),('21','220','78','2',760.00,760.00,6081.16,0.00,0.00,0.00,0.00,233),('21','220','78','3',650.00,650.00,1213.14,0.00,0.00,0.00,0.00,234),('21','220','79','1',165.00,165.00,54125.53,0.00,0.00,0.00,0.00,235),('21','220','79','2',760.00,760.00,2537.64,0.00,0.00,0.00,0.00,236),('21','220','79','3',650.00,650.00,959.34,0.00,0.00,0.00,0.00,237),('21','220','80','1',165.00,165.00,47019.30,0.00,0.00,0.00,0.00,238),('21','220','80','2',760.00,760.00,7276.06,0.00,0.00,0.00,0.00,239),('21','220','80','3',650.00,650.00,3506.08,0.00,0.00,0.00,0.00,240),('21','220','81','2',760.00,760.00,14027.28,0.00,0.00,0.00,0.00,241),('21','220','81','3',650.00,650.00,4708.39,0.00,0.00,0.00,0.00,242),('21','220','81','1',165.00,165.00,49714.43,0.00,0.00,0.00,0.00,243),('21','220','82','1',165.00,165.00,34767.92,0.00,0.00,0.00,0.00,244),('21','220','82','2',760.00,760.00,552.63,0.00,0.00,0.00,0.00,245),('21','220','82','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,246),('21','220','83','2',760.00,760.00,10231.86,0.00,0.00,0.00,0.00,247),('21','220','83','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,248),('21','220','83','1',165.00,165.00,51976.52,0.00,0.00,0.00,0.00,249),('21','220','84','1',165.00,165.00,50891.72,0.00,0.00,0.00,0.00,250),('21','220','84','2',760.00,760.00,7908.26,0.00,0.00,0.00,0.00,251),('21','220','84','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,252),('21','220','85','1',165.00,165.00,51108.74,0.00,0.00,0.00,0.00,253),('21','220','85','2',760.00,760.00,444.78,0.00,0.00,0.00,0.00,254),('21','220','85','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,255),('21','220','86','1',165.00,165.00,42670.73,0.00,0.00,0.00,0.00,256),('21','220','86','2',760.00,760.00,3693.17,0.00,0.00,0.00,0.00,257),('21','220','86','3',650.00,650.00,545.67,0.00,0.00,0.00,0.00,258),('21','220','87','1',165.00,165.00,30109.03,0.00,0.00,0.00,0.00,259),('21','220','87','2',760.00,760.00,15018.52,0.00,0.00,0.00,0.00,260),('21','220','87','3',650.00,650.00,4195.04,0.00,0.00,0.00,0.00,261),('21','220','88','1',165.00,165.00,35591.23,0.00,0.00,0.00,0.00,262),('21','220','88','2',760.00,760.00,9048.50,0.00,0.00,0.00,0.00,263),('21','220','88','3',650.00,650.00,5515.08,0.00,0.00,0.00,0.00,264),('21','220','89','1',165.00,165.00,21654.87,0.00,0.00,0.00,0.00,265),('21','220','89','2',780.00,780.00,138.65,0.00,0.00,0.00,0.00,266),('21','220','89','3',650.00,650.00,1948.67,0.00,0.00,0.00,0.00,267),('21','220','90','2',800.00,880.00,3185.46,0.00,0.00,0.00,0.00,268),('21','220','90','3',700.00,700.00,2319.73,0.00,0.00,0.00,0.00,269),('21','220','90','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,270),('21','220','91','2',800.00,880.00,5977.89,0.00,0.00,0.00,0.00,271),('21','220','91','3',700.00,700.00,1204.43,0.00,0.00,0.00,0.00,272),('21','220','91','1',165.00,165.00,81685.44,0.00,0.00,0.00,0.00,273),('21','220','92','1',165.00,165.00,62247.24,0.00,0.00,0.00,0.00,274),('21','220','92','2',800.00,880.00,10082.54,0.00,0.00,0.00,0.00,275),('21','220','92','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,276),('21','220','93','1',165.00,165.00,48598.52,0.00,0.00,0.00,0.00,277),('21','220','93','2',800.00,880.00,9835.65,0.00,0.00,0.00,0.00,278),('21','220','93','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,279),('21','220','94','1',165.00,165.00,45585.31,0.00,0.00,0.00,0.00,280),('21','220','94','2',800.00,880.00,3115.38,0.00,0.00,0.00,0.00,281),('21','220','94','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,282),('21','220','95','1',165.00,165.00,47867.29,0.00,0.00,0.00,0.00,283),('21','220','95','2',800.00,880.00,9512.47,0.00,0.00,0.00,0.00,284),('21','220','95','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,285),('21','220','96','1',165.00,165.00,32558.94,0.00,0.00,0.00,0.00,286),('21','220','96','2',820.00,820.00,10179.90,0.00,0.00,0.00,0.00,287),('21','220','96','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,288),('21','220','97','1',165.00,165.00,44724.09,0.00,0.00,0.00,0.00,289),('21','220','97','2',820.00,820.00,8845.72,0.00,0.00,0.00,0.00,290),('21','220','97','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,291),('21','220','98','1',165.00,165.00,53016.28,0.00,0.00,0.00,0.00,292),('21','220','98','2',820.00,820.00,7704.37,0.00,0.00,0.00,0.00,293),('21','220','98','3',750.00,750.00,962.67,0.00,0.00,0.00,0.00,294),('21','220','99','1',165.00,165.00,47435.91,0.00,0.00,0.00,0.00,295),('21','220','99','2',820.00,820.00,10384.04,0.00,0.00,0.00,0.00,296),('21','220','99','3',750.00,750.00,1297.84,0.00,0.00,0.00,0.00,297),('21','220','100','2',820.00,820.00,8629.32,0.00,0.00,0.00,0.00,298),('21','220','100','3',750.00,750.00,1201.74,0.00,0.00,0.00,0.00,299),('21','220','100','1',165.00,165.00,44477.78,0.00,0.00,0.00,0.00,300),('21','220','101','1',165.00,165.00,40857.31,0.00,0.00,0.00,0.00,301),('21','220','101','2',820.00,830.00,3721.35,0.00,0.00,0.00,0.00,302),('21','220','101','3',750.00,750.00,498.14,0.00,0.00,0.00,0.00,303),('21','220','102','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,304),('21','220','102','2',820.00,830.00,0.00,0.00,0.00,0.00,0.00,305),('21','220','102','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,306),('21','220','103','2',830.00,830.00,4742.90,0.00,0.00,0.00,0.00,307),('21','220','103','3',750.00,750.00,1009.45,0.00,0.00,0.00,0.00,308),('21','220','103','1',165.00,165.00,51008.20,0.00,0.00,0.00,0.00,309),('21','220','104','1',165.00,165.00,42195.12,0.00,0.00,0.00,0.00,310),('21','220','104','2',830.00,830.00,4601.36,0.00,0.00,0.00,0.00,311),('21','220','104','3',750.00,750.00,605.82,0.00,0.00,0.00,0.00,312),('21','220','105','2',830.00,830.00,3840.55,0.00,0.00,0.00,0.00,313),('21','220','105','3',750.00,750.00,1085.25,0.00,0.00,0.00,0.00,314),('21','220','105','1',165.00,165.00,34898.07,0.00,0.00,0.00,0.00,315),('21','220','106','1',165.00,165.00,20044.22,0.00,0.00,0.00,0.00,316),('21','220','106','2',830.00,830.00,5779.34,0.00,0.00,0.00,0.00,317),('21','220','106','3',750.00,750.00,587.26,0.00,0.00,0.00,0.00,318),('21','220','107','2',830.00,830.00,6646.07,0.00,0.00,0.00,0.00,319),('21','220','107','3',750.00,750.00,431.14,0.00,0.00,0.00,0.00,320),('21','220','107','1',165.00,165.00,38390.58,0.00,0.00,0.00,0.00,321),('21','220','108','1',165.00,165.00,41131.66,0.00,0.00,0.00,0.00,322),('21','220','108','2',830.00,830.00,3691.03,0.00,0.00,0.00,0.00,323),('21','220','108','3',750.00,750.00,618.76,0.00,0.00,0.00,0.00,324),('21','220','109','1',165.00,165.00,40897.66,0.00,0.00,0.00,0.00,325),('21','220','109','2',830.00,830.00,2786.46,0.00,0.00,0.00,0.00,326),('21','220','109','3',750.00,750.00,620.93,0.00,0.00,0.00,0.00,327),('21','220','110','1',165.00,165.00,37665.17,0.00,0.00,0.00,0.00,328),('21','220','110','2',830.00,830.00,2461.50,0.00,0.00,0.00,0.00,329),('21','220','110','3',750.00,750.00,890.85,0.00,0.00,0.00,0.00,330),('21','220','111','1',165.00,165.00,47962.54,0.00,0.00,0.00,0.00,331),('21','220','111','2',830.00,830.00,8899.80,0.00,0.00,0.00,0.00,332),('21','220','111','3',750.00,750.00,982.78,0.00,0.00,0.00,0.00,333),('21','220','112','2',830.00,830.00,3732.98,0.00,0.00,0.00,0.00,334),('21','220','112','3',750.00,750.00,1371.69,0.00,0.00,0.00,0.00,335),('21','220','112','1',165.00,165.00,45466.25,0.00,0.00,0.00,0.00,336),('21','220','113','1',165.00,165.00,41700.95,0.00,0.00,0.00,0.00,337),('21','220','113','2',830.00,830.00,5835.46,0.00,0.00,0.00,0.00,338),('21','220','113','3',750.00,750.00,995.22,0.00,0.00,0.00,0.00,339),('21','220','114','1',165.00,165.00,22387.41,0.00,0.00,0.00,0.00,340),('21','220','114','2',830.00,830.00,4901.07,0.00,0.00,0.00,0.00,341),('21','220','114','3',750.00,750.00,789.68,0.00,0.00,0.00,0.00,342),('21','220','115','2',830.00,830.00,6211.36,0.00,0.00,0.00,0.00,343),('21','220','115','3',750.00,750.00,815.00,0.00,0.00,0.00,0.00,344),('21','220','115','1',165.00,165.00,38789.69,0.00,0.00,0.00,0.00,345),('21','220','116','1',165.00,165.00,40374.13,0.00,0.00,0.00,0.00,346),('21','220','116','2',830.00,830.00,2724.75,0.00,0.00,0.00,0.00,347),('21','220','116','3',750.00,750.00,969.20,0.00,0.00,0.00,0.00,348),('21','220','117','1',165.00,165.00,45283.69,0.00,0.00,0.00,0.00,349),('21','220','117','2',830.00,830.00,4575.91,0.00,0.00,0.00,0.00,350),('21','220','117','3',750.00,750.00,950.32,0.00,0.00,0.00,0.00,351),('21','220','118','1',165.00,165.00,40069.56,0.00,0.00,0.00,0.00,352),('21','220','118','2',830.00,830.00,7153.42,0.00,0.00,0.00,0.00,353),('21','220','118','3',750.00,750.00,1045.32,0.00,0.00,0.00,0.00,354),('21','220','119','2',830.00,830.00,2406.46,0.00,0.00,0.00,0.00,355),('21','220','119','3',750.00,750.00,1496.12,0.00,0.00,0.00,0.00,356),('21','220','119','1',165.00,165.00,47812.35,0.00,0.00,0.00,0.00,357),('21','220','120','1',165.00,165.00,41092.76,0.00,0.00,0.00,0.00,358),('21','220','120','2',830.00,830.00,3521.11,0.00,0.00,0.00,0.00,359),('21','220','120','3',750.00,750.00,725.69,0.00,0.00,0.00,0.00,360),('21','220','121','2',830.00,830.00,5867.99,0.00,0.00,0.00,0.00,361),('21','220','121','3',750.00,750.00,721.96,0.00,0.00,0.00,0.00,362),('21','220','121','1',165.00,165.00,49012.41,0.00,0.00,0.00,0.00,363),('21','220','122','1',165.00,165.00,35718.46,0.00,0.00,0.00,0.00,364),('21','220','122','2',830.00,830.00,1353.16,0.00,0.00,0.00,0.00,365),('21','220','122','3',750.00,750.00,1275.64,0.00,0.00,0.00,0.00,366),('21','220','123','1',165.00,165.00,6670.41,0.00,0.00,0.00,0.00,367),('21','220','123','2',830.00,830.00,828.48,0.00,0.00,0.00,0.00,368),('21','220','123','3',750.00,750.00,643.53,0.00,0.00,0.00,0.00,369),('21','220','124','1',185.00,185.00,46405.58,0.00,0.00,0.00,0.00,370),('21','220','124','2',830.00,830.00,973.47,0.00,0.00,0.00,0.00,371),('21','220','124','3',750.00,750.00,721.03,0.00,0.00,0.00,0.00,372),('21','220','125','1',185.00,185.00,3449.09,0.00,0.00,0.00,0.00,373),('21','220','125','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,374),('21','220','125','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,375),('21','220','126','1',165.00,165.00,74135.37,0.00,0.00,0.00,0.00,376),('21','220','126','2',830.00,830.00,1443.74,0.00,0.00,0.00,0.00,377),('21','220','126','3',750.00,750.00,815.26,0.00,0.00,0.00,0.00,378),('21','220','127','1',165.00,165.00,76646.66,0.00,0.00,0.00,0.00,379),('21','220','127','2',830.00,830.00,4475.91,0.00,0.00,0.00,0.00,380),('21','220','127','3',750.00,750.00,725.91,0.00,0.00,0.00,0.00,381),('21','220','128','1',185.00,185.00,58793.35,0.00,0.00,0.00,0.00,382),('21','220','128','2',830.00,830.00,2554.57,0.00,0.00,0.00,0.00,383),('21','220','128','3',750.00,750.00,508.99,0.00,0.00,0.00,0.00,384),('21','220','129','1',185.00,185.00,43585.61,0.00,0.00,0.00,0.00,385),('21','220','129','2',830.00,830.00,2681.97,0.00,0.00,0.00,0.00,386),('21','220','129','3',750.00,750.00,521.48,0.00,0.00,0.00,0.00,387),('21','220','130','1',185.00,185.00,39697.16,0.00,0.00,0.00,0.00,388),('21','220','130','2',830.00,830.00,1781.89,0.00,0.00,0.00,0.00,389),('21','220','130','3',750.00,750.00,939.80,0.00,0.00,0.00,0.00,390),('21','220','131','1',185.00,185.00,1194.90,0.00,0.00,0.00,0.00,391),('21','220','131','2',830.00,830.00,1993.67,0.00,0.00,0.00,0.00,392),('21','220','131','3',750.00,750.00,641.77,0.00,0.00,0.00,0.00,393),('21','220','132','1',185.00,185.00,54796.04,0.00,0.00,0.00,0.00,394),('21','220','132','2',830.00,830.00,5921.36,0.00,0.00,0.00,0.00,395),('21','220','132','3',750.00,750.00,1548.67,0.00,0.00,0.00,0.00,396),('21','220','133','1',175.00,175.00,45665.93,0.00,0.00,0.00,0.00,397),('21','220','133','2',830.00,830.00,2274.52,0.00,0.00,0.00,0.00,398),('21','220','133','3',750.00,750.00,1332.19,0.00,0.00,0.00,0.00,399),('21','220','134','1',175.00,175.00,84321.39,0.00,0.00,0.00,0.00,400),('21','220','134','2',830.00,830.00,3442.51,0.00,0.00,0.00,0.00,401),('21','220','134','3',750.00,750.00,459.20,0.00,0.00,0.00,0.00,402),('21','220','135','1',175.00,175.00,54855.70,0.00,0.00,0.00,0.00,403),('21','220','135','2',830.00,830.00,3345.86,0.00,0.00,0.00,0.00,404),('21','220','135','3',750.00,750.00,350.34,0.00,0.00,0.00,0.00,405),('21','220','136','1',175.00,175.00,52291.07,0.00,0.00,0.00,0.00,406),('21','220','136','2',815.00,815.00,7941.46,0.00,0.00,0.00,0.00,407),('21','220','136','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,408),('21','220','137','1',175.00,175.00,46248.30,0.00,0.00,0.00,0.00,409),('21','220','137','2',815.00,815.00,4015.21,0.00,0.00,0.00,0.00,410),('21','220','137','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,411),('21','220','138','1',175.00,175.00,41771.76,0.00,0.00,0.00,0.00,412),('21','220','138','2',815.00,815.00,1507.88,0.00,0.00,0.00,0.00,413),('21','220','138','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,414),('21','220','139','1',175.00,175.00,48071.72,0.00,0.00,0.00,0.00,415),('21','220','139','2',810.00,810.00,2714.39,0.00,0.00,0.00,0.00,416),('21','220','139','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,417),('21','220','140','1',175.00,175.00,47508.55,0.00,0.00,0.00,0.00,418),('21','220','140','2',810.00,810.00,4811.74,0.00,0.00,0.00,0.00,419),('21','220','140','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,420),('21','220','141','1',175.00,175.00,45425.83,0.00,0.00,0.00,0.00,421),('21','220','141','2',810.00,810.00,3813.28,0.00,0.00,0.00,0.00,422),('21','220','141','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,423),('21','220','142','2',810.00,810.00,7463.08,0.00,0.00,0.00,0.00,424),('21','220','142','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,425),('21','220','142','1',175.00,175.00,41854.04,0.00,0.00,0.00,0.00,426),('21','220','143','2',810.00,810.00,2506.71,0.00,0.00,0.00,0.00,427),('21','220','143','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,428),('21','220','143','1',175.00,175.00,52074.63,0.00,0.00,0.00,0.00,429),('21','220','144','1',175.00,175.00,51246.18,0.00,0.00,0.00,0.00,430),('21','220','144','2',810.00,810.00,3178.92,0.00,0.00,0.00,0.00,431),('21','220','144','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,432),('21','220','145','1',175.00,175.00,32287.23,0.00,0.00,0.00,0.00,433),('21','220','145','2',810.00,810.00,718.22,0.00,0.00,0.00,0.00,434),('21','220','145','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,435),('21','220','146','1',175.00,175.00,42778.70,0.00,0.00,0.00,0.00,436),('21','220','146','2',810.00,810.00,2178.39,0.00,0.00,0.00,0.00,437),('21','220','146','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,438),('21','220','147','1',175.00,175.00,51752.15,0.00,0.00,0.00,0.00,439),('21','220','147','2',810.00,810.00,5189.27,0.00,0.00,0.00,0.00,440),('21','220','147','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,441),('21','220','148','1',175.00,175.00,48276.22,0.00,0.00,0.00,0.00,442),('21','220','148','2',810.00,810.00,2719.00,0.00,0.00,0.00,0.00,443),('21','220','148','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,444),('21','220','149','1',175.00,175.00,33177.63,0.00,0.00,0.00,0.00,445),('21','220','149','2',810.00,810.00,4092.93,0.00,0.00,0.00,0.00,446),('21','220','149','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,447),('21','220','150','1',175.00,175.00,44935.95,0.00,0.00,0.00,0.00,448),('21','220','150','2',810.00,810.00,3605.65,0.00,0.00,0.00,0.00,449),('21','220','150','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,450),('21','220','151','1',175.00,175.00,12985.43,0.00,0.00,0.00,0.00,451),('21','220','151','2',810.00,810.00,2743.30,0.00,0.00,0.00,0.00,452),('21','220','151','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,453),('21','220','152','1',175.00,175.00,31888.50,0.00,0.00,0.00,0.00,454),('21','220','152','2',810.00,810.00,1168.89,0.00,0.00,0.00,0.00,455),('21','220','152','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,456),('21','220','153','1',175.00,175.00,13340.06,0.00,0.00,0.00,0.00,457),('21','220','153','2',810.00,810.00,3901.22,0.00,0.00,0.00,0.00,458),('21','220','153','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,459),('21','220','154','1',175.00,175.00,40091.70,0.00,0.00,0.00,0.00,460),('21','220','154','2',810.00,810.00,3661.95,0.00,0.00,0.00,0.00,461),('21','220','154','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,462),('21','220','155','1',175.00,175.00,51613.39,0.00,0.00,0.00,0.00,463),('21','220','155','2',810.00,810.00,5035.44,0.00,0.00,0.00,0.00,464),('21','220','155','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,465),('21','220','156','1',175.00,175.00,42617.74,0.00,0.00,0.00,0.00,466),('21','220','156','2',810.00,810.00,5959.84,0.00,0.00,0.00,0.00,467),('21','220','156','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,468),('21','220','157','1',175.00,175.00,42598.66,0.00,0.00,0.00,0.00,469),('21','220','157','2',810.00,810.00,2116.22,0.00,0.00,0.00,0.00,470),('21','220','157','3',850.00,850.00,0.00,0.00,0.00,0.00,0.00,471),('21','220','158','2',810.00,810.00,2349.52,0.00,0.00,0.00,0.00,472),('21','220','158','3',850.00,850.00,548.04,0.00,0.00,0.00,0.00,473),('21','220','158','1',175.00,175.00,24497.16,0.00,0.00,0.00,0.00,474),('21','220','159','1',175.00,175.00,34.29,0.00,0.00,0.00,0.00,475),('21','220','159','2',810.00,810.00,1056.06,0.00,0.00,0.00,0.00,476),('21','220','159','3',850.00,850.00,635.09,0.00,0.00,0.00,0.00,477),('21','220','160','1',175.00,175.00,50357.62,0.00,0.00,0.00,0.00,478),('21','220','160','2',810.00,810.00,4639.90,0.00,0.00,0.00,0.00,479),('21','220','160','3',850.00,850.00,564.62,0.00,0.00,0.00,0.00,480),('21','220','161','1',175.00,175.00,44348.16,0.00,0.00,0.00,0.00,481),('21','220','161','2',810.00,810.00,1849.49,0.00,0.00,0.00,0.00,482),('21','220','161','3',850.00,850.00,687.99,0.00,0.00,0.00,0.00,483),('21','220','162','1',175.00,175.00,51191.61,0.00,0.00,0.00,0.00,484),('21','220','162','2',810.00,810.00,6795.18,0.00,0.00,0.00,0.00,485),('21','220','162','3',850.00,850.00,649.40,0.00,0.00,0.00,0.00,486),('21','220','163','1',175.00,175.00,31285.93,0.00,0.00,0.00,0.00,487),('21','220','163','2',800.00,800.00,9771.66,0.00,0.00,0.00,0.00,488),('21','220','163','3',860.00,860.00,743.04,0.00,0.00,0.00,0.00,489),('21','220','164','1',175.00,175.00,31825.14,0.00,0.00,0.00,0.00,490),('21','220','164','2',800.00,800.00,1380.78,0.00,0.00,0.00,0.00,491),('21','220','164','3',860.00,860.00,489.71,0.00,0.00,0.00,0.00,492),('21','220','165','1',175.00,175.00,17524.56,0.00,0.00,0.00,0.00,493),('21','220','165','2',800.00,800.00,1763.45,0.00,0.00,0.00,0.00,494),('21','220','165','3',860.00,860.00,529.07,0.00,0.00,0.00,0.00,495),('21','220','166','1',175.00,175.00,29923.42,0.00,0.00,0.00,0.00,496),('21','220','166','2',800.00,800.00,1766.36,0.00,0.00,0.00,0.00,497),('21','220','166','3',860.00,860.00,271.49,0.00,0.00,0.00,0.00,498),('21','220','167','2',800.00,800.00,4193.63,0.00,0.00,0.00,0.00,499),('21','220','167','3',860.00,860.00,502.21,0.00,0.00,0.00,0.00,500),('21','220','167','1',175.00,175.00,37737.88,0.00,0.00,0.00,0.00,501),('21','220','168','1',175.00,175.00,54615.41,0.00,0.00,0.00,0.00,502),('21','220','168','2',800.00,800.00,3635.84,0.00,0.00,0.00,0.00,503),('21','220','168','3',860.00,860.00,573.54,0.00,0.00,0.00,0.00,504),('21','220','169','1',175.00,175.00,33857.82,0.00,0.00,0.00,0.00,505),('21','220','169','2',800.00,800.00,2760.89,0.00,0.00,0.00,0.00,506),('21','220','169','3',860.00,860.00,354.09,0.00,0.00,0.00,0.00,507),('21','220','170','2',800.00,800.00,4152.50,0.00,0.00,0.00,0.00,508),('21','220','170','3',860.00,860.00,316.19,0.00,0.00,0.00,0.00,509),('21','220','170','1',175.00,175.00,45108.00,0.00,0.00,0.00,0.00,510),('21','220','171','1',175.00,175.00,34966.65,0.00,0.00,0.00,0.00,511),('21','220','171','2',800.00,800.00,2858.28,0.00,0.00,0.00,0.00,512),('21','220','171','3',860.00,860.00,458.33,0.00,0.00,0.00,0.00,513),('21','220','172','1',175.00,175.00,36412.19,0.00,0.00,0.00,0.00,514),('21','220','172','2',800.00,800.00,2377.04,0.00,0.00,0.00,0.00,515),('21','220','172','3',860.00,860.00,456.92,0.00,0.00,0.00,0.00,516),('21','220','173','1',175.00,175.00,40571.77,0.00,0.00,0.00,0.00,517),('21','220','173','2',800.00,800.00,2224.03,0.00,0.00,0.00,0.00,518),('21','220','173','3',860.00,860.00,342.90,0.00,0.00,0.00,0.00,519),('21','220','174','2',800.00,800.00,2684.97,0.00,0.00,0.00,0.00,520),('21','220','174','3',860.00,860.00,505.50,0.00,0.00,0.00,0.00,521),('21','220','174','1',175.00,175.00,37633.82,0.00,0.00,0.00,0.00,522),('21','220','175','1',175.00,175.00,34967.68,0.00,0.00,0.00,0.00,523),('21','220','175','2',800.00,800.00,2766.71,0.00,0.00,0.00,0.00,524),('21','220','175','3',860.00,860.00,597.87,0.00,0.00,0.00,0.00,525),('21','220','176','1',175.00,175.00,14648.55,0.00,0.00,0.00,0.00,526),('21','220','176','2',800.00,800.00,3208.10,0.00,0.00,0.00,0.00,527),('21','220','176','3',860.00,860.00,539.61,0.00,0.00,0.00,0.00,528),('21','220','177','1',175.00,175.00,27270.36,0.00,0.00,0.00,0.00,529),('21','220','177','2',800.00,800.00,2844.18,0.00,0.00,0.00,0.00,530),('21','220','177','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,531),('21','220','178','1',175.00,175.00,45148.83,0.00,0.00,0.00,0.00,532),('21','220','178','2',800.00,800.00,4024.50,0.00,0.00,0.00,0.00,533),('21','220','178','3',860.00,860.00,943.63,0.00,0.00,0.00,0.00,534),('21','220','179','1',175.00,175.00,44673.75,0.00,0.00,0.00,0.00,535),('21','220','179','2',800.00,800.00,2796.92,0.00,0.00,0.00,0.00,536),('21','220','179','3',860.00,860.00,619.33,0.00,0.00,0.00,0.00,537),('21','220','180','1',175.00,175.00,41001.08,0.00,0.00,0.00,0.00,538),('21','220','180','2',800.00,800.00,540.36,0.00,0.00,0.00,0.00,539),('21','220','180','3',860.00,860.00,357.47,0.00,0.00,0.00,0.00,540),('21','220','181','1',175.00,175.00,47354.33,0.00,0.00,0.00,0.00,541),('21','220','181','2',800.00,800.00,1114.56,0.00,0.00,0.00,0.00,542),('21','220','181','3',860.00,860.00,281.41,0.00,0.00,0.00,0.00,543),('21','220','182','1',175.00,175.00,18191.36,0.00,0.00,0.00,0.00,544),('21','220','182','2',800.00,800.00,3878.56,0.00,0.00,0.00,0.00,545),('21','220','182','3',860.00,860.00,499.36,0.00,0.00,0.00,0.00,546),('21','220','183','1',175.00,175.00,42925.77,0.00,0.00,0.00,0.00,547),('21','220','183','2',800.00,800.00,2650.45,0.00,0.00,0.00,0.00,548),('21','220','183','3',860.00,860.00,555.46,0.00,0.00,0.00,0.00,549),('21','220','184','2',800.00,800.00,2909.25,0.00,0.00,0.00,0.00,550),('21','220','184','3',860.00,860.00,379.88,0.00,0.00,0.00,0.00,551),('21','220','184','1',175.00,175.00,54423.62,0.00,0.00,0.00,0.00,552),('21','220','185','1',175.00,175.00,54290.35,0.00,0.00,0.00,0.00,553),('21','220','185','2',800.00,800.00,1683.67,0.00,0.00,0.00,0.00,554),('21','220','185','3',860.00,860.00,431.14,0.00,0.00,0.00,0.00,555),('21','220','186','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,556),('21','220','186','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,557),('21','220','186','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,558),('21','220','187','1',175.00,175.00,47888.86,0.00,0.00,0.00,0.00,559),('21','220','187','2',800.00,800.00,3444.97,0.00,0.00,0.00,0.00,560),('21','220','187','3',860.00,860.00,504.97,0.00,0.00,0.00,0.00,561),('21','220','188','1',175.00,175.00,44751.88,0.00,0.00,0.00,0.00,562),('21','220','188','2',800.00,800.00,4280.73,0.00,0.00,0.00,0.00,563),('21','220','188','3',860.00,860.00,354.60,0.00,0.00,0.00,0.00,564),('21','220','189','1',175.00,175.00,55996.91,0.00,0.00,0.00,0.00,565),('21','220','189','2',800.00,800.00,10051.01,0.00,0.00,0.00,0.00,566),('21','220','189','3',860.00,860.00,629.00,0.00,0.00,0.00,0.00,567),('21','220','190','1',175.00,175.00,47901.10,0.00,0.00,0.00,0.00,568),('21','220','190','2',800.00,800.00,4160.49,0.00,0.00,0.00,0.00,569),('21','220','190','3',860.00,860.00,551.02,0.00,0.00,0.00,0.00,570),('21','220','191','1',175.00,175.00,44873.57,0.00,0.00,0.00,0.00,571),('21','220','191','2',800.00,800.00,2167.27,0.00,0.00,0.00,0.00,572),('21','220','191','3',860.00,860.00,373.19,0.00,0.00,0.00,0.00,573),('21','220','192','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,574),('21','220','192','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,575),('21','220','192','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,576),('21','220','193','1',175.00,175.00,58837.68,0.00,0.00,0.00,0.00,577),('21','220','193','2',800.00,800.00,1666.50,0.00,0.00,0.00,0.00,578),('21','220','193','3',860.00,860.00,378.10,0.00,0.00,0.00,0.00,579),('21','220','194','2',800.00,800.00,7132.67,0.00,0.00,0.00,0.00,580),('21','220','194','3',860.00,860.00,563.84,0.00,0.00,0.00,0.00,581),('21','220','194','1',175.00,175.00,50693.12,0.00,0.00,0.00,0.00,582),('21','220','195','1',175.00,175.00,33783.29,0.00,0.00,0.00,0.00,583),('21','220','195','2',800.00,800.00,3111.37,0.00,0.00,0.00,0.00,584),('21','220','195','3',860.00,860.00,644.44,0.00,0.00,0.00,0.00,585),('21','220','196','1',175.00,175.00,44443.31,0.00,0.00,0.00,0.00,586),('21','220','196','2',800.00,800.00,1140.14,0.00,0.00,0.00,0.00,587),('21','220','196','3',860.00,860.00,628.65,0.00,0.00,0.00,0.00,588),('21','220','197','1',175.00,175.00,50664.64,0.00,0.00,0.00,0.00,589),('21','220','197','2',800.00,800.00,662.37,0.00,0.00,0.00,0.00,590),('21','220','197','3',860.00,860.00,355.14,0.00,0.00,0.00,0.00,591),('21','220','198','1',175.00,175.00,21902.24,0.00,0.00,0.00,0.00,592),('21','220','198','2',800.00,800.00,101.00,0.00,0.00,0.00,0.00,593),('21','220','198','3',860.00,860.00,786.77,0.00,0.00,0.00,0.00,594),('21','220','199','1',175.00,175.00,59189.63,0.00,0.00,0.00,0.00,595),('21','220','199','2',800.00,800.00,2588.65,0.00,0.00,0.00,0.00,596),('21','220','199','3',860.00,860.00,417.67,0.00,0.00,0.00,0.00,597),('21','220','200','1',175.00,175.00,56021.53,0.00,0.00,0.00,0.00,598),('21','220','200','2',800.00,800.00,5334.03,0.00,0.00,0.00,0.00,599),('21','220','200','3',860.00,860.00,453.78,0.00,0.00,0.00,0.00,600),('21','220','201','1',175.00,175.00,58382.54,0.00,0.00,0.00,0.00,601),('21','220','201','2',800.00,800.00,8357.55,0.00,0.00,0.00,0.00,602),('21','220','201','3',860.00,860.00,478.16,0.00,0.00,0.00,0.00,603),('21','220','202','1',175.00,175.00,26452.08,0.00,0.00,0.00,0.00,604),('21','220','202','2',800.00,800.00,923.96,0.00,0.00,0.00,0.00,605),('21','220','202','3',860.00,860.00,405.32,0.00,0.00,0.00,0.00,606),('21','220','203','2',800.00,800.00,999.28,0.00,0.00,0.00,0.00,607),('21','220','203','3',860.00,860.00,841.10,0.00,0.00,0.00,0.00,608),('21','220','203','1',175.00,175.00,29696.67,0.00,0.00,0.00,0.00,609),('21','220','204','1',175.00,175.00,25413.10,0.00,0.00,0.00,0.00,610),('21','220','204','2',800.00,800.00,3670.14,0.00,0.00,0.00,0.00,611),('21','220','204','3',860.00,860.00,445.06,0.00,0.00,0.00,0.00,612),('21','220','205','1',175.00,175.00,56353.60,0.00,0.00,0.00,0.00,613),('21','220','205','2',800.00,800.00,4387.65,0.00,0.00,0.00,0.00,614),('21','220','205','3',860.00,860.00,764.49,0.00,0.00,0.00,0.00,615),('21','220','206','1',175.00,175.00,39391.86,0.00,0.00,0.00,0.00,616),('21','220','206','2',800.00,800.00,6135.77,0.00,0.00,0.00,0.00,617),('21','220','206','3',860.00,860.00,337.73,0.00,0.00,0.00,0.00,618),('21','220','207','1',175.00,175.00,45801.73,0.00,0.00,0.00,0.00,619),('21','220','207','2',800.00,800.00,3883.68,0.00,0.00,0.00,0.00,620),('21','220','207','3',860.00,860.00,276.53,0.00,0.00,0.00,0.00,621),('21','220','208','1',175.00,175.00,32593.38,0.00,0.00,0.00,0.00,622),('21','220','208','2',800.00,800.00,6952.34,0.00,0.00,0.00,0.00,623),('21','220','208','3',860.00,860.00,358.59,0.00,0.00,0.00,0.00,624),('21','220','209','1',175.00,175.00,39979.08,0.00,0.00,0.00,0.00,625),('21','220','209','2',800.00,800.00,1450.54,0.00,0.00,0.00,0.00,626),('21','220','209','3',860.00,860.00,584.46,0.00,0.00,0.00,0.00,627),('21','220','210','1',175.00,175.00,28374.92,0.00,0.00,0.00,0.00,628),('21','220','210','2',800.00,800.00,84.28,0.00,0.00,0.00,0.00,629),('21','220','210','3',860.00,860.00,304.24,0.00,0.00,0.00,0.00,630),('21','220','211','2',800.00,800.00,392.33,0.00,0.00,0.00,0.00,631),('21','220','211','3',860.00,860.00,414.28,0.00,0.00,0.00,0.00,632),('21','220','211','1',175.00,175.00,40904.50,0.00,0.00,0.00,0.00,633),('21','220','212','1',175.00,175.00,46386.85,0.00,0.00,0.00,0.00,634),('21','220','212','2',800.00,800.00,512.11,0.00,0.00,0.00,0.00,635),('21','220','212','3',860.00,860.00,606.21,0.00,0.00,0.00,0.00,636),('21','220','213','1',175.00,175.00,15810.75,0.00,0.00,0.00,0.00,637),('21','220','213','2',815.00,815.00,61.95,0.00,0.00,0.00,0.00,638),('21','220','213','3',860.00,860.00,330.06,0.00,0.00,0.00,0.00,639),('21','220','214','1',175.00,175.00,35090.96,0.00,0.00,0.00,0.00,640),('21','220','214','2',815.00,815.00,237.85,0.00,0.00,0.00,0.00,641),('21','220','214','3',860.00,860.00,345.61,0.00,0.00,0.00,0.00,642),('21','220','215','1',175.00,175.00,9893.67,0.00,0.00,0.00,0.00,643),('21','220','215','2',815.00,815.00,122.49,0.00,0.00,0.00,0.00,644),('21','220','215','3',860.00,860.00,667.48,0.00,0.00,0.00,0.00,645),('21','220','216','1',175.00,175.00,26349.85,0.00,0.00,0.00,0.00,646),('21','220','216','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,647),('21','220','216','3',860.00,860.00,281.13,0.00,0.00,0.00,0.00,648),('21','220','217','1',175.00,175.00,1946.47,0.00,0.00,0.00,0.00,649),('21','220','217','2',815.00,815.00,27.61,0.00,0.00,0.00,0.00,650),('21','220','217','3',860.00,860.00,628.85,0.00,0.00,0.00,0.00,651),('21','220','218','1',175.00,175.00,28833.69,0.00,0.00,0.00,0.00,652),('21','220','218','2',815.00,815.00,89.54,0.00,0.00,0.00,0.00,653),('21','220','218','3',860.00,860.00,275.56,0.00,0.00,0.00,0.00,654),('21','220','219','1',175.00,175.00,52541.62,0.00,0.00,0.00,0.00,655),('21','220','219','2',815.00,815.00,100.00,0.00,0.00,0.00,0.00,656),('21','220','219','3',860.00,860.00,323.30,0.00,0.00,0.00,0.00,657),('21','220','220','1',175.00,175.00,29828.33,0.00,0.00,0.00,0.00,658),('21','220','220','2',815.00,815.00,33.12,0.00,0.00,0.00,0.00,659),('21','220','220','3',860.00,860.00,285.40,0.00,0.00,0.00,0.00,660),('21','220','221','1',175.00,175.00,56386.29,0.00,0.00,0.00,0.00,661),('21','220','221','2',830.00,815.00,124.27,0.00,0.00,0.00,0.00,662),('21','220','221','3',860.00,860.00,723.71,0.00,0.00,0.00,0.00,663),('21','220','222','1',175.00,175.00,32546.83,0.00,0.00,0.00,0.00,664),('21','220','222','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,665),('21','220','222','3',860.00,860.00,342.75,0.00,0.00,0.00,0.00,666),('21','220','223','1',175.00,175.00,41339.88,0.00,0.00,0.00,0.00,667),('21','220','223','2',830.00,830.00,310.24,0.00,0.00,0.00,0.00,668),('21','220','223','3',860.00,860.00,237.34,0.00,0.00,0.00,0.00,669),('21','220','224','1',175.00,175.00,52846.44,0.00,0.00,0.00,0.00,670),('21','220','224','2',830.00,830.00,1312.63,0.00,0.00,0.00,0.00,671),('21','220','224','3',860.00,860.00,457.26,0.00,0.00,0.00,0.00,672),('21','220','225','1',175.00,175.00,19217.74,0.00,0.00,0.00,0.00,673),('21','220','225','2',830.00,830.00,2936.22,0.00,0.00,0.00,0.00,674),('21','220','225','3',860.00,860.00,620.64,0.00,0.00,0.00,0.00,675),('21','220','226','2',830.00,830.00,6048.26,0.00,0.00,0.00,0.00,676),('21','220','226','3',860.00,860.00,197.45,0.00,0.00,0.00,0.00,677),('21','220','226','1',175.00,175.00,31963.03,0.00,0.00,0.00,0.00,678),('21','220','227','2',830.00,830.00,4427.34,0.00,0.00,0.00,0.00,679),('21','220','227','3',860.00,860.00,302.90,0.00,0.00,0.00,0.00,680),('21','220','227','1',175.00,175.00,39806.20,0.00,0.00,0.00,0.00,681),('21','220','228','1',175.00,175.00,22328.16,0.00,0.00,0.00,0.00,682),('21','220','228','2',830.00,830.00,5883.55,0.00,0.00,0.00,0.00,683),('21','220','228','3',860.00,860.00,320.82,0.00,0.00,0.00,0.00,684),('21','220','229','1',175.00,175.00,46916.52,0.00,0.00,0.00,0.00,685),('21','220','229','2',830.00,830.00,2942.72,0.00,0.00,0.00,0.00,686),('21','220','229','3',860.00,860.00,312.75,0.00,0.00,0.00,0.00,687),('21','220','230','1',175.00,175.00,3450.13,0.00,0.00,0.00,0.00,688),('21','220','230','2',830.00,830.00,148.19,0.00,0.00,0.00,0.00,689),('21','220','230','3',860.00,860.00,153.30,0.00,0.00,0.00,0.00,690),('21','220','231','2',830.00,830.00,125.00,0.00,0.00,0.00,0.00,691),('21','220','231','3',860.00,860.00,215.25,0.00,0.00,0.00,0.00,692),('21','220','231','1',175.00,175.00,22681.42,0.00,0.00,0.00,0.00,693),('21','220','232','1',175.00,175.00,11386.39,0.00,0.00,0.00,0.00,694),('21','220','232','2',830.00,830.00,1971.84,0.00,0.00,0.00,0.00,695),('21','220','232','3',860.00,860.00,366.00,0.00,0.00,0.00,0.00,696),('21','220','233','2',830.00,830.00,5024.34,0.00,0.00,0.00,0.00,697),('21','220','233','3',860.00,860.00,333.38,0.00,0.00,0.00,0.00,698),('21','220','233','1',175.00,175.00,66815.70,0.00,0.00,0.00,0.00,699),('21','220','234','1',175.00,175.00,0.00,0.00,0.00,0.00,0.00,700),('21','220','234','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,701),('21','220','234','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,702);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'220','PRODUCT TANK','TANK CONTAINING PETROLEUM PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','220','1',1,0,'1','PMS TANK 1 & TANK 2',90000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','763','2022-03-02 10:47:36','2022-03-02 10:50:53','763',5,0),('21','220','1',2,0,'1','PMS TANK 3 & 4',90000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','763','2022-03-02 10:54:01','2022-03-02 10:54:01','763',5,0),('21','220','1',3,0,'2','AGO TANK ',45000.00,0.00,NULL,'TANK CONTAINING DIESEL.','763','2022-03-02 10:57:37','2022-03-02 10:57:37','763',5,0),('21','220','1',4,0,'3','DPK TANK',45000.00,0.00,NULL,'TANK CONTAINING KEROSINE.','763','2022-03-02 10:59:47','2022-03-02 10:59:47','763',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=5406 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (67,'21','220','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 13:05:31','',''),(68,'21','220','1',0,'Inventory adjustment from tank dipping to 150',0.00,0.00,150.00,0.00,0.00,'2022-03-23 13:05:31','',''),(69,'21','220','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 13:06:10','',''),(70,'21','220','2',0,'Inventory adjustment from tank dipping to 400',0.00,0.00,400.00,0.00,0.00,'2022-03-23 13:06:10','',''),(71,'21','220','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 13:06:34','',''),(72,'21','220','3',0,'Inventory adjustment from tank dipping to 150',0.00,0.00,150.00,0.00,0.00,'2022-03-23 13:06:34','',''),(73,'21','220','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-23 13:06:53','',''),(74,'21','220','4',0,'Inventory adjustment from tank dipping to 50',0.00,0.00,50.00,0.00,0.00,'2022-03-23 13:06:53','',''),(75,'21','220','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,150.00,0.00,'2022-03-23 18:26:42','',''),(76,'21','220','1',0,'Inventory adjustment from tank dipping to 2550',0.00,0.00,2550.00,0.00,0.00,'2022-03-23 18:26:42','',''),(77,'21','220','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,400.00,0.00,'2022-03-23 18:29:39','',''),(78,'21','220','2',0,'Inventory adjustment from tank dipping to 15800',0.00,0.00,15800.00,0.00,0.00,'2022-03-23 18:29:39','',''),(79,'21','220','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,150.00,0.00,'2022-03-23 18:30:44','',''),(80,'21','220','3',0,'Inventory adjustment from tank dipping to 34550',0.00,0.00,34550.00,0.00,0.00,'2022-03-23 18:30:44','',''),(81,'21','220','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,50.00,0.00,'2022-03-23 18:31:05','',''),(82,'21','220','4',0,'Inventory adjustment from tank dipping to 50',0.00,0.00,50.00,0.00,0.00,'2022-03-23 18:31:05','',''),(83,'21','220','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,50.00,0.00,'2022-03-23 18:31:41','',''),(84,'21','220','4',0,'Inventory adjustment from tank dipping to 100',0.00,0.00,100.00,0.00,0.00,'2022-03-23 18:31:41','',''),(85,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,23485000.00,33550.00,0.00,0.00,'2022-03-23 18:35:36','',''),(86,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-23 18:36:00','',''),(87,'21','220',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,30000.00,0.00,'2022-03-23 18:41:19','',''),(88,'21','220','2',1,'Received from bridging 10',0.00,0.00,30000.00,0.00,0.00,'2022-03-23 18:41:19','',''),(89,'21','220','2',1,'Returned bridging 10',0.00,0.00,0.00,30000.00,0.00,'2022-03-23 19:24:42','',''),(90,'21','220',NULL,1,'Reception Return corrector for bridging 10',0.00,0.00,30000.00,0.00,0.00,'2022-03-23 19:24:42','',''),(91,'21','220',NULL,2,'Returned purchase #10 to AYM SHAFA NIGERIA LIMITED',23485000.00,0.00,0.00,33550.00,0.00,'2022-03-23 19:25:54','',''),(92,'21','220',NULL,1,'Returned purchase #9 to AYM SHAFA NIGERIA LIMITED',4950000.00,0.00,0.00,30000.00,0.00,'2022-03-23 19:26:50','',''),(93,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-03-23 19:33:35','',''),(94,'21','220',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,28000.00,0.00,'2022-03-23 19:37:51','',''),(95,'21','220','2',1,'Received from bridging 13',0.00,0.00,28000.00,0.00,0.00,'2022-03-23 19:37:51','',''),(96,'21','220',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,22000.00,0.00,'2022-03-23 19:37:51','',''),(97,'21','220','1',1,'Received from bridging 12',0.00,0.00,22000.00,0.00,0.00,'2022-03-23 19:37:51','',''),(98,'21','220','1',1,'Sale Id shift 4',0.00,0.00,0.00,1352.33,0.00,'2022-03-23 21:06:56','',''),(99,'21','220','1',1,'Sale Id shift 4',0.00,0.00,0.00,1497.32,0.00,'2022-03-23 21:06:56','',''),(100,'21','220','1',1,'Sale Id shift 4',0.00,0.00,0.00,2706.44,0.00,'2022-03-23 21:06:56','',''),(101,'21','220','3',2,'Sale Id shift 4',0.00,0.00,0.00,658.23,0.00,'2022-03-23 21:06:56','',''),(102,'21','220','3',2,'Sale Id shift 4',0.00,0.00,0.00,7054.23,0.00,'2022-03-23 21:06:56','',''),(103,'21','220','1',1,'Sale Id shift 4',0.00,0.00,0.00,1941.20,0.00,'2022-03-23 21:06:56','',''),(104,'21','220','1',1,'Sale Id shift 4',0.00,0.00,0.00,765.67,0.00,'2022-03-23 21:06:56','',''),(105,'21','220','1',1,'Sale Id shift 4',0.00,0.00,0.00,1725.50,0.00,'2022-03-23 21:06:56','',''),(106,'21','220','2',1,'Sale Id shift 4',0.00,0.00,0.00,3502.82,0.00,'2022-03-23 21:06:56','',''),(107,'21','220','2',1,'Sale Id shift 4',0.00,0.00,0.00,3668.35,0.00,'2022-03-23 21:06:56','',''),(108,'21','220','2',1,'Sale Id shift 4',0.00,0.00,0.00,2844.22,0.00,'2022-03-23 21:06:56','',''),(109,'21','220','2',1,'Sale Id shift 4',0.00,0.00,0.00,3644.66,0.00,'2022-03-23 21:06:56','',''),(110,'21','220','2',1,'Sale Id shift 4',0.00,0.00,0.00,4949.64,0.00,'2022-03-23 21:06:56','',''),(111,'21','220','2',1,'Sale Id shift 4',0.00,0.00,0.00,1.36,0.00,'2022-03-23 21:06:56','',''),(112,'21','220','2',1,'Sale Id shift 4',0.00,0.00,0.00,3647.41,0.00,'2022-03-23 21:06:56','',''),(113,'21','220','2',1,'Sale Id shift 4',0.00,0.00,0.00,1884.93,0.00,'2022-03-23 21:06:56','',''),(114,'21','220',NULL,2,'Sale Id shift 4',5398722.00,0.00,0.00,0.00,0.00,'2022-03-23 21:06:56','',''),(115,'21','220',NULL,1,'Sale Id shift 4',5631755.25,0.00,0.00,0.00,0.00,'2022-03-23 21:06:56','',''),(116,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-03-24 21:30:12','',''),(117,'21','220',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,40000.00,0.00,'2022-03-24 21:33:41','',''),(118,'21','220','2',1,'Received from bridging 15',0.00,0.00,40000.00,0.00,0.00,'2022-03-24 21:33:41','',''),(119,'21','220',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,20000.00,0.00,'2022-03-24 21:33:41','',''),(120,'21','220','1',1,'Received from bridging 14',0.00,0.00,20000.00,0.00,0.00,'2022-03-24 21:33:41','',''),(121,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-03-24 22:57:24','',''),(122,'21','220',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,30000.00,0.00,'2022-03-24 23:00:21','',''),(123,'21','220','2',1,'Received from bridging 17',0.00,0.00,30000.00,0.00,0.00,'2022-03-24 23:00:21','',''),(124,'21','220',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,20000.00,0.00,'2022-03-24 23:00:21','',''),(125,'21','220','1',1,'Received from bridging 16',0.00,0.00,20000.00,0.00,0.00,'2022-03-24 23:00:21','',''),(126,'21','220','1',1,'Sale Id shift 5',0.00,0.00,0.00,2353.95,0.00,'2022-03-24 23:09:16','',''),(127,'21','220','3',2,'Sale Id shift 5',0.00,0.00,0.00,5261.04,0.00,'2022-03-24 23:09:16','',''),(128,'21','220','1',1,'Sale Id shift 5',0.00,0.00,0.00,2746.66,0.00,'2022-03-24 23:09:16','',''),(129,'21','220','1',1,'Sale Id shift 5',0.00,0.00,0.00,1533.95,0.00,'2022-03-24 23:09:16','',''),(130,'21','220','1',1,'Sale Id shift 5',0.00,0.00,0.00,0.21,0.00,'2022-03-24 23:09:16','',''),(131,'21','220','1',1,'Sale Id shift 5',0.00,0.00,0.00,4054.57,0.00,'2022-03-24 23:09:16','',''),(132,'21','220','2',1,'Sale Id shift 5',0.00,0.00,0.00,5177.86,0.00,'2022-03-24 23:09:16','',''),(133,'21','220','2',1,'Sale Id shift 5',0.00,0.00,0.00,2959.67,0.00,'2022-03-24 23:09:16','',''),(134,'21','220','2',1,'Sale Id shift 5',0.00,0.00,0.00,3205.11,0.00,'2022-03-24 23:09:16','',''),(135,'21','220','2',1,'Sale Id shift 5',0.00,0.00,0.00,3154.53,0.00,'2022-03-24 23:09:16','',''),(136,'21','220','1',1,'Sale Id shift 5',0.00,0.00,0.00,3609.77,0.00,'2022-03-24 23:09:16','',''),(137,'21','220','2',1,'Sale Id shift 5',0.00,0.00,0.00,6147.18,0.00,'2022-03-24 23:09:16','',''),(138,'21','220','2',1,'Sale Id shift 5',0.00,0.00,0.00,2679.26,0.00,'2022-03-24 23:09:16','',''),(139,'21','220','2',1,'Sale Id shift 5',0.00,0.00,0.00,3012.06,0.00,'2022-03-24 23:09:16','',''),(140,'21','220','1',1,'Sale Id shift 5',0.00,0.00,0.00,4877.87,0.00,'2022-03-24 23:09:16','',''),(141,'21','220','3',2,'Sale Id shift 5',0.00,0.00,0.00,6419.63,0.00,'2022-03-24 23:09:16','',''),(142,'21','220',NULL,2,'Sale Id shift 5',8176469.00,0.00,0.00,0.00,0.00,'2022-03-24 23:09:16','',''),(143,'21','220',NULL,1,'Sale Id shift 5',7509587.25,0.00,0.00,0.00,0.00,'2022-03-24 23:09:16','',''),(144,'21','220','1',1,'Sale Id shift 6',0.00,0.00,0.00,3864.94,0.00,'2022-03-25 00:11:36','',''),(145,'21','220','1',1,'Sale Id shift 6',0.00,0.00,0.00,4816.21,0.00,'2022-03-25 00:11:36','',''),(146,'21','220','1',1,'Sale Id shift 6',0.00,0.00,0.00,3903.24,0.00,'2022-03-25 00:11:36','',''),(147,'21','220','2',1,'Sale Id shift 6',0.00,0.00,0.00,8072.58,0.00,'2022-03-25 00:11:36','',''),(148,'21','220','2',1,'Sale Id shift 6',0.00,0.00,0.00,3406.37,0.00,'2022-03-25 00:11:36','',''),(149,'21','220','2',1,'Sale Id shift 6',0.00,0.00,0.00,6438.16,0.00,'2022-03-25 00:11:36','',''),(150,'21','220','2',1,'Sale Id shift 6',0.00,0.00,0.00,5621.98,0.00,'2022-03-25 00:11:36','',''),(151,'21','220','1',1,'Sale Id shift 6',0.00,0.00,0.00,3554.97,0.00,'2022-03-25 00:11:36','',''),(152,'21','220','2',1,'Sale Id shift 6',0.00,0.00,0.00,9484.95,0.00,'2022-03-25 00:11:36','',''),(153,'21','220','2',1,'Sale Id shift 6',0.00,0.00,0.00,6534.21,0.00,'2022-03-25 00:11:36','',''),(154,'21','220','2',1,'Sale Id shift 6',0.00,0.00,0.00,4914.10,0.00,'2022-03-25 00:11:36','',''),(155,'21','220','1',1,'Sale Id shift 6',0.00,0.00,0.00,5753.28,0.00,'2022-03-25 00:11:36','',''),(156,'21','220','3',2,'Sale Id shift 6',0.00,0.00,0.00,3289.96,0.00,'2022-03-25 00:11:36','',''),(157,'21','220',NULL,2,'Sale Id shift 6',2302972.00,0.00,0.00,0.00,0.00,'2022-03-25 00:11:36','',''),(158,'21','220',NULL,1,'Sale Id shift 6',10950223.35,0.00,0.00,0.00,0.00,'2022-03-25 00:11:36','',''),(159,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-03-26 13:27:46','',''),(160,'21','220',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,30000.00,0.00,'2022-03-27 17:04:57','',''),(161,'21','220','2',1,'Received from bridging 19',0.00,0.00,30000.00,0.00,0.00,'2022-03-27 17:04:57','',''),(162,'21','220',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,30000.00,0.00,'2022-03-27 17:04:57','',''),(163,'21','220','1',1,'Received from bridging 18',0.00,0.00,30000.00,0.00,0.00,'2022-03-27 17:04:57','',''),(164,'21','220','1',1,'Sale Id shift 7',0.00,0.00,0.00,4405.30,0.00,'2022-03-27 22:11:17','',''),(165,'21','220','3',2,'Sale Id shift 7',0.00,0.00,0.00,1524.50,0.00,'2022-03-27 22:11:17','',''),(166,'21','220','1',1,'Sale Id shift 7',0.00,0.00,0.00,5975.85,0.00,'2022-03-27 22:11:17','',''),(167,'21','220','1',1,'Sale Id shift 7',0.00,0.00,0.00,5548.11,0.00,'2022-03-27 22:11:17','',''),(168,'21','220','2',1,'Sale Id shift 7',0.00,0.00,0.00,4856.53,0.00,'2022-03-27 22:11:17','',''),(169,'21','220','2',1,'Sale Id shift 7',0.00,0.00,0.00,4661.33,0.00,'2022-03-27 22:11:17','',''),(170,'21','220','2',1,'Sale Id shift 7',0.00,0.00,0.00,4207.10,0.00,'2022-03-27 22:11:17','',''),(171,'21','220','2',1,'Sale Id shift 7',0.00,0.00,0.00,3933.54,0.00,'2022-03-27 22:11:17','',''),(172,'21','220','1',1,'Sale Id shift 7',0.00,0.00,0.00,4906.37,0.00,'2022-03-27 22:11:17','',''),(173,'21','220','2',1,'Sale Id shift 7',0.00,0.00,0.00,5079.20,0.00,'2022-03-27 22:11:17','',''),(174,'21','220','2',1,'Sale Id shift 7',0.00,0.00,0.00,3993.21,0.00,'2022-03-27 22:11:17','',''),(175,'21','220','2',1,'Sale Id shift 7',0.00,0.00,0.00,3945.26,0.00,'2022-03-27 22:11:17','',''),(176,'21','220','1',1,'Sale Id shift 7',0.00,0.00,0.00,6256.37,0.00,'2022-03-27 22:11:17','',''),(177,'21','220','3',2,'Sale Id shift 7',0.00,0.00,0.00,5414.88,0.00,'2022-03-27 22:11:17','',''),(178,'21','220',NULL,2,'Sale Id shift 7',4857566.00,0.00,0.00,0.00,0.00,'2022-03-27 22:11:17','',''),(179,'21','220',NULL,1,'Sale Id shift 7',9531748.05,0.00,0.00,0.00,0.00,'2022-03-27 22:11:17','',''),(180,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-03-27 22:35:43','',''),(181,'21','220',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,33000.00,0.00,'2022-03-27 22:54:33','',''),(182,'21','220','2',1,'Received from bridging 21',0.00,0.00,33000.00,0.00,0.00,'2022-03-27 22:54:33','',''),(183,'21','220',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,17000.00,0.00,'2022-03-27 22:54:33','',''),(184,'21','220','1',1,'Received from bridging 20',0.00,0.00,17000.00,0.00,0.00,'2022-03-27 22:54:33','',''),(185,'21','220','1',1,'Sale Id shift 8',0.00,0.00,0.00,4743.23,0.00,'2022-03-27 23:05:22','',''),(186,'21','220','1',1,'Sale Id shift 8',0.00,0.00,0.00,3661.70,0.00,'2022-03-27 23:05:22','',''),(187,'21','220','1',1,'Sale Id shift 8',0.00,0.00,0.00,5594.71,0.00,'2022-03-27 23:05:22','',''),(188,'21','220','2',1,'Sale Id shift 8',0.00,0.00,0.00,5354.25,0.00,'2022-03-27 23:05:22','',''),(189,'21','220','2',1,'Sale Id shift 8',0.00,0.00,0.00,4146.53,0.00,'2022-03-27 23:05:22','',''),(190,'21','220','2',1,'Sale Id shift 8',0.00,0.00,0.00,4001.29,0.00,'2022-03-27 23:05:22','',''),(191,'21','220','2',1,'Sale Id shift 8',0.00,0.00,0.00,3428.72,0.00,'2022-03-27 23:05:22','',''),(192,'21','220','1',1,'Sale Id shift 8',0.00,0.00,0.00,5029.57,0.00,'2022-03-27 23:05:22','',''),(193,'21','220','2',1,'Sale Id shift 8',0.00,0.00,0.00,6307.06,0.00,'2022-03-27 23:05:22','',''),(194,'21','220','2',1,'Sale Id shift 8',0.00,0.00,0.00,4065.78,0.00,'2022-03-27 23:05:22','',''),(195,'21','220','2',1,'Sale Id shift 8',0.00,0.00,0.00,1176.50,0.00,'2022-03-27 23:05:22','',''),(196,'21','220','1',1,'Sale Id shift 8',0.00,0.00,0.00,4175.48,0.00,'2022-03-27 23:05:22','',''),(197,'21','220','3',2,'Sale Id shift 8',0.00,0.00,0.00,3271.95,0.00,'2022-03-27 23:05:22','',''),(198,'21','220',NULL,2,'Sale Id shift 8',2290365.00,0.00,0.00,0.00,0.00,'2022-03-27 23:05:22','',''),(199,'21','220',NULL,1,'Sale Id shift 8',8527995.30,0.00,0.00,0.00,0.00,'2022-03-27 23:05:22','',''),(200,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-28 21:26:54','',''),(201,'21','220',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,30000.00,0.00,'2022-03-28 21:31:28','',''),(202,'21','220','2',1,'Received from bridging 23',0.00,0.00,30000.00,0.00,0.00,'2022-03-28 21:31:28','',''),(203,'21','220',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,15000.00,0.00,'2022-03-28 21:31:28','',''),(204,'21','220','1',1,'Received from bridging 22',0.00,0.00,15000.00,0.00,0.00,'2022-03-28 21:31:28','',''),(205,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,10500000.00,15000.00,0.00,0.00,'2022-03-28 21:34:33','',''),(206,'21','220',NULL,2,'Reception corrector for bridging 24',0.00,0.00,0.00,15000.00,0.00,'2022-03-28 21:36:32','',''),(207,'21','220','3',2,'Received from bridging 24',0.00,0.00,15000.00,0.00,0.00,'2022-03-28 21:36:32','',''),(208,'21','220','1',1,'Sale Id shift 9',0.00,0.00,0.00,4127.62,0.00,'2022-03-28 22:28:17','',''),(209,'21','220','3',2,'Sale Id shift 9',0.00,0.00,0.00,414.19,0.00,'2022-03-28 22:28:17','',''),(210,'21','220','1',1,'Sale Id shift 9',0.00,0.00,0.00,4325.76,0.00,'2022-03-28 22:28:17','',''),(211,'21','220','1',1,'Sale Id shift 9',0.00,0.00,0.00,4885.85,0.00,'2022-03-28 22:28:17','',''),(212,'21','220','2',1,'Sale Id shift 9',0.00,0.00,0.00,4171.44,0.00,'2022-03-28 22:28:17','',''),(213,'21','220','2',1,'Sale Id shift 9',0.00,0.00,0.00,5274.89,0.00,'2022-03-28 22:28:17','',''),(214,'21','220','2',1,'Sale Id shift 9',0.00,0.00,0.00,4628.00,0.00,'2022-03-28 22:28:17','',''),(215,'21','220','2',1,'Sale Id shift 9',0.00,0.00,0.00,4947.85,0.00,'2022-03-28 22:28:17','',''),(216,'21','220','1',1,'Sale Id shift 9',0.00,0.00,0.00,3696.23,0.00,'2022-03-28 22:28:17','',''),(217,'21','220','2',1,'Sale Id shift 9',0.00,0.00,0.00,7039.51,0.00,'2022-03-28 22:28:17','',''),(218,'21','220','2',1,'Sale Id shift 9',0.00,0.00,0.00,0.97,0.00,'2022-03-28 22:28:17','',''),(219,'21','220','2',1,'Sale Id shift 9',0.00,0.00,0.00,3994.10,0.00,'2022-03-28 22:28:17','',''),(220,'21','220','2',1,'Sale Id shift 9',0.00,0.00,0.00,3056.58,0.00,'2022-03-28 22:28:17','',''),(221,'21','220','1',1,'Sale Id shift 9',0.00,0.00,0.00,4164.00,0.00,'2022-03-28 22:28:17','',''),(222,'21','220',NULL,2,'Sale Id shift 9',289933.00,0.00,0.00,0.00,0.00,'2022-03-28 22:28:17','',''),(223,'21','220',NULL,1,'Sale Id shift 9',8961612.00,0.00,0.00,0.00,0.00,'2022-03-28 22:28:17','',''),(224,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-28 22:30:44','',''),(225,'21','220',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,30000.00,0.00,'2022-03-28 22:31:46','',''),(226,'21','220','2',1,'Received from bridging 26',0.00,0.00,30000.00,0.00,0.00,'2022-03-28 22:31:46','',''),(227,'21','220',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,15000.00,0.00,'2022-03-28 22:31:46','',''),(228,'21','220','1',1,'Received from bridging 25',0.00,0.00,15000.00,0.00,0.00,'2022-03-28 22:31:46','',''),(229,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-29 13:56:23','',''),(230,'21','220',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,45000.00,0.00,'2022-03-29 13:58:52','',''),(231,'21','220','1',1,'Received from bridging 27',0.00,0.00,45000.00,0.00,0.00,'2022-03-29 13:58:52','',''),(232,'21','220','1',1,'Sale Id shift 10',0.00,0.00,0.00,1982.83,0.00,'2022-03-29 14:00:57','',''),(233,'21','220','1',1,'Sale Id shift 10',0.00,0.00,0.00,1616.05,0.00,'2022-03-29 14:00:57','',''),(234,'21','220','1',1,'Sale Id shift 10',0.00,0.00,0.00,2758.53,0.00,'2022-03-29 14:00:57','',''),(235,'21','220','2',1,'Sale Id shift 10',0.00,0.00,0.00,5793.77,0.00,'2022-03-29 14:00:57','',''),(236,'21','220','2',1,'Sale Id shift 10',0.00,0.00,0.00,4398.52,0.00,'2022-03-29 14:00:57','',''),(237,'21','220','2',1,'Sale Id shift 10',0.00,0.00,0.00,4244.89,0.00,'2022-03-29 14:00:57','',''),(238,'21','220','1',1,'Sale Id shift 10',0.00,0.00,0.00,1423.84,0.00,'2022-03-29 14:00:57','',''),(239,'21','220','2',1,'Sale Id shift 10',0.00,0.00,0.00,6074.68,0.00,'2022-03-29 14:00:57','',''),(240,'21','220','2',1,'Sale Id shift 10',0.00,0.00,0.00,3437.02,0.00,'2022-03-29 14:00:57','',''),(241,'21','220','2',1,'Sale Id shift 10',0.00,0.00,0.00,3000.20,0.00,'2022-03-29 14:00:57','',''),(242,'21','220','1',1,'Sale Id shift 10',0.00,0.00,0.00,2050.99,0.00,'2022-03-29 14:00:57','',''),(243,'21','220',NULL,1,'Sale Id shift 10',6068917.80,0.00,0.00,0.00,0.00,'2022-03-29 14:00:57','',''),(244,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-29 14:01:40','',''),(245,'21','220',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,45000.00,0.00,'2022-03-29 14:03:48','',''),(246,'21','220','2',1,'Received from bridging 28',0.00,0.00,45000.00,0.00,0.00,'2022-03-29 14:03:48','',''),(247,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,18550000.00,26500.00,0.00,0.00,'2022-03-29 14:04:19','',''),(248,'21','220',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,15000.00,0.00,0.00,'2022-03-29 14:09:47','',''),(249,'21','220',NULL,2,'Reception corrector for bridging 30',0.00,0.00,0.00,15000.00,0.00,'2022-03-29 14:10:33','',''),(250,'21','220','3',2,'Received from bridging 30',0.00,0.00,15000.00,0.00,0.00,'2022-03-29 14:10:33','',''),(251,'21','220','3',2,'Returned bridging 30',0.00,0.00,0.00,15000.00,0.00,'2022-03-29 14:13:14','',''),(252,'21','220',NULL,2,'Reception Return corrector for bridging 30',0.00,0.00,15000.00,0.00,0.00,'2022-03-29 14:13:14','',''),(253,'21','220',NULL,2,'Reception corrector for bridging 31',0.00,0.00,0.00,26500.00,0.00,'2022-03-29 14:14:07','',''),(254,'21','220','3',2,'Received from bridging 31',0.00,0.00,26500.00,0.00,0.00,'2022-03-29 14:14:07','',''),(255,'21','220','3',2,'Returned bridging 31',0.00,0.00,0.00,26500.00,0.00,'2022-03-29 14:14:23','',''),(256,'21','220',NULL,2,'Reception Return corrector for bridging 31',0.00,0.00,26500.00,0.00,0.00,'2022-03-29 14:14:23','',''),(257,'21','220','1',1,'Sale Id shift 11',0.00,0.00,0.00,1578.16,0.00,'2022-03-31 20:03:22','',''),(258,'21','220','1',1,'Sale Id shift 11',0.00,0.00,0.00,1571.03,0.00,'2022-03-31 20:03:22','',''),(259,'21','220','1',1,'Sale Id shift 11',0.00,0.00,0.00,2974.16,0.00,'2022-03-31 20:03:22','',''),(260,'21','220','2',1,'Sale Id shift 11',0.00,0.00,0.00,4928.59,0.00,'2022-03-31 20:03:22','',''),(261,'21','220','2',1,'Sale Id shift 11',0.00,0.00,0.00,4415.22,0.00,'2022-03-31 20:03:22','',''),(262,'21','220','2',1,'Sale Id shift 11',0.00,0.00,0.00,4474.12,0.00,'2022-03-31 20:03:22','',''),(263,'21','220','1',1,'Sale Id shift 11',0.00,0.00,0.00,1430.64,0.00,'2022-03-31 20:03:22','',''),(264,'21','220','2',1,'Sale Id shift 11',0.00,0.00,0.00,6811.94,0.00,'2022-03-31 20:03:22','',''),(265,'21','220','2',1,'Sale Id shift 11',0.00,0.00,0.00,3678.51,0.00,'2022-03-31 20:03:22','',''),(266,'21','220','2',1,'Sale Id shift 11',0.00,0.00,0.00,2284.97,0.00,'2022-03-31 20:03:22','',''),(267,'21','220','1',1,'Sale Id shift 11',0.00,0.00,0.00,1164.73,0.00,'2022-03-31 20:03:22','',''),(268,'21','220','3',2,'Sale Id shift 11',0.00,0.00,0.00,1172.00,0.00,'2022-03-31 20:03:22','',''),(269,'21','220',NULL,1,'Sale Id shift 11',5826491.55,0.00,0.00,0.00,0.00,'2022-03-31 20:03:22','',''),(270,'21','220',NULL,2,'Sale Id shift 11',820400.00,0.00,0.00,0.00,0.00,'2022-03-31 20:03:22','',''),(271,'21','220',NULL,3,'Reception corrector for bridging 32',0.00,0.00,0.00,15000.00,0.00,'2022-03-31 21:26:04','',''),(272,'21','220','4',3,'Received from bridging 32',0.00,0.00,15000.00,0.00,0.00,'2022-03-31 21:26:04','',''),(273,'21','220','1',1,'Returned bridging 27',0.00,0.00,0.00,45000.00,0.00,'2022-04-02 16:30:19','',''),(274,'21','220',NULL,1,'Reception Return corrector for bridging 27',0.00,0.00,45000.00,0.00,0.00,'2022-04-02 16:30:19','',''),(275,'21','220',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,45000.00,0.00,'2022-04-02 16:42:25','',''),(276,'21','220','1',1,'Received from bridging 33',0.00,0.00,45000.00,0.00,0.00,'2022-04-02 16:42:25','',''),(277,'21','220','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,45444.81,0.00,'2022-04-06 06:34:32','',''),(278,'21','220','1',0,'Inventory adjustment from tank dipping to 50100',0.00,0.00,50100.00,0.00,0.00,'2022-04-06 06:34:32','',''),(279,'21','220','1',1,'Sale Id shift 13',0.00,0.00,0.00,9507.81,0.00,'2022-04-07 14:34:20','',''),(280,'21','220','3',2,'Sale Id shift 13',0.00,0.00,0.00,8050.10,0.00,'2022-04-07 14:34:20','',''),(281,'21','220','4',3,'Sale Id shift 13',0.00,0.00,0.00,1191.99,0.00,'2022-04-07 14:34:20','',''),(282,'21','220','1',1,'Sale Id shift 13',0.00,0.00,0.00,10633.42,0.00,'2022-04-07 14:34:20','',''),(283,'21','220','1',1,'Sale Id shift 13',0.00,0.00,0.00,1.45,0.00,'2022-04-07 14:34:20','',''),(284,'21','220','1',1,'Sale Id shift 13',0.00,0.00,0.00,9969.95,0.00,'2022-04-07 14:34:20','',''),(285,'21','220','2',1,'Sale Id shift 13',0.00,0.00,0.00,9589.42,0.00,'2022-04-07 14:34:20','',''),(286,'21','220','2',1,'Sale Id shift 13',0.00,0.00,0.00,4487.74,0.00,'2022-04-07 14:34:20','',''),(287,'21','220','2',1,'Sale Id shift 13',0.00,0.00,0.00,8699.37,0.00,'2022-04-07 14:34:20','',''),(288,'21','220','2',1,'Sale Id shift 13',0.00,0.00,0.00,4895.58,0.00,'2022-04-07 14:34:20','',''),(289,'21','220','1',1,'Sale Id shift 13',0.00,0.00,0.00,8185.60,0.00,'2022-04-07 14:34:20','',''),(290,'21','220','2',1,'Sale Id shift 13',0.00,0.00,0.00,7995.37,0.00,'2022-04-07 14:34:20','',''),(291,'21','220','2',1,'Sale Id shift 13',0.00,0.00,0.00,0.55,0.00,'2022-04-07 14:34:20','',''),(292,'21','220','1',1,'Sale Id shift 13',0.00,0.00,0.00,11681.96,0.00,'2022-04-07 14:34:20','',''),(293,'21','220',NULL,2,'Sale Id shift 13',5635070.00,0.00,0.00,0.00,0.00,'2022-04-07 14:34:20','',''),(294,'21','220',NULL,3,'Sale Id shift 13',655594.50,0.00,0.00,0.00,0.00,'2022-04-07 14:34:20','',''),(295,'21','220',NULL,1,'Sale Id shift 13',14131956.30,0.00,0.00,0.00,0.00,'2022-04-07 14:34:20','',''),(296,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-07 14:45:55','',''),(297,'21','220',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,30000.00,0.00,'2022-04-07 15:18:40','',''),(298,'21','220','2',1,'Received from bridging 35',0.00,0.00,30000.00,0.00,0.00,'2022-04-07 15:18:40','',''),(299,'21','220',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,30000.00,0.00,'2022-04-07 15:18:40','',''),(300,'21','220','1',1,'Received from bridging 34',0.00,0.00,30000.00,0.00,0.00,'2022-04-07 15:18:40','',''),(301,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-10 18:02:30','',''),(302,'21','220',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,15000.00,0.00,'2022-04-10 18:07:21','',''),(303,'21','220','2',1,'Received from bridging 37',0.00,0.00,15000.00,0.00,0.00,'2022-04-10 18:07:21','',''),(304,'21','220',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,15000.00,0.00,'2022-04-10 18:07:21','',''),(305,'21','220','1',1,'Received from bridging 36',0.00,0.00,15000.00,0.00,0.00,'2022-04-10 18:07:21','',''),(306,'21','220',NULL,2,'Reception corrector for bridging 38',0.00,0.00,0.00,26500.00,0.00,'2022-04-13 17:05:00','',''),(307,'21','220','3',2,'Received from bridging 38',0.00,0.00,26500.00,0.00,0.00,'2022-04-13 17:05:00','',''),(308,'21','220',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,15000.00,0.00,'2022-04-15 10:48:41','',''),(309,'21','220','2',1,'Received from bridging 41',0.00,0.00,15000.00,0.00,0.00,'2022-04-15 10:48:41','',''),(310,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-15 11:13:48','',''),(311,'21','220',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,15000.00,0.00,'2022-04-15 11:14:55','',''),(312,'21','220','2',1,'Received from bridging 43',0.00,0.00,15000.00,0.00,0.00,'2022-04-15 11:14:55','',''),(313,'21','220',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,30000.00,0.00,'2022-04-15 11:14:55','',''),(314,'21','220','1',1,'Received from bridging 42',0.00,0.00,30000.00,0.00,0.00,'2022-04-15 11:14:55','',''),(315,'21','220','1',1,'Sale Id shift 16',0.00,0.00,0.00,9107.80,0.00,'2022-04-15 11:25:18','',''),(316,'21','220','3',2,'Sale Id shift 16',0.00,0.00,0.00,8531.99,0.00,'2022-04-15 11:25:18','',''),(317,'21','220','4',3,'Sale Id shift 16',0.00,0.00,0.00,2329.85,0.00,'2022-04-15 11:25:18','',''),(318,'21','220','1',1,'Sale Id shift 16',0.00,0.00,0.00,8895.17,0.00,'2022-04-15 11:25:18','',''),(319,'21','220','1',1,'Sale Id shift 16',0.00,0.00,0.00,3.03,0.00,'2022-04-15 11:25:18','',''),(320,'21','220','1',1,'Sale Id shift 16',0.00,0.00,0.00,9087.65,0.00,'2022-04-15 11:25:18','',''),(321,'21','220','2',1,'Sale Id shift 16',0.00,0.00,0.00,7612.62,0.00,'2022-04-15 11:25:18','',''),(322,'21','220','2',1,'Sale Id shift 16',0.00,0.00,0.00,2927.00,0.00,'2022-04-15 11:25:18','',''),(323,'21','220','2',1,'Sale Id shift 16',0.00,0.00,0.00,3087.34,0.00,'2022-04-15 11:25:18','',''),(324,'21','220','2',1,'Sale Id shift 16',0.00,0.00,0.00,6951.53,0.00,'2022-04-15 11:25:18','',''),(325,'21','220','1',1,'Sale Id shift 16',0.00,0.00,0.00,7206.53,0.00,'2022-04-15 11:25:18','',''),(326,'21','220','2',1,'Sale Id shift 16',0.00,0.00,0.00,6881.52,0.00,'2022-04-15 11:25:18','',''),(327,'21','220','2',1,'Sale Id shift 16',0.00,0.00,0.00,30.58,0.00,'2022-04-15 11:25:18','',''),(328,'21','220','1',1,'Sale Id shift 16',0.00,0.00,0.00,11647.14,0.00,'2022-04-15 11:25:18','',''),(329,'21','220','3',2,'Sale Id shift 16',0.00,0.00,0.00,1716.49,0.00,'2022-04-15 11:25:18','',''),(330,'21','220',NULL,1,'Sale Id shift 16',12117255.15,0.00,0.00,0.00,0.00,'2022-04-15 11:25:18','',''),(331,'21','220',NULL,2,'Sale Id shift 16',7173936.00,0.00,0.00,0.00,0.00,'2022-04-15 11:25:18','',''),(332,'21','220',NULL,3,'Sale Id shift 16',1281417.50,0.00,0.00,0.00,0.00,'2022-04-15 11:25:18','',''),(333,'21','220','1',1,'Sale Id shift 17',0.00,0.00,0.00,4692.11,0.00,'2022-04-15 22:07:06','',''),(334,'21','220','3',2,'Sale Id shift 17',0.00,0.00,0.00,7805.55,0.00,'2022-04-15 22:07:06','',''),(335,'21','220','4',3,'Sale Id shift 17',0.00,0.00,0.00,1764.67,0.00,'2022-04-15 22:07:06','',''),(336,'21','220','1',1,'Sale Id shift 17',0.00,0.00,0.00,5377.17,0.00,'2022-04-15 22:07:06','',''),(337,'21','220','1',1,'Sale Id shift 17',0.00,0.00,0.00,5373.21,0.00,'2022-04-15 22:07:06','',''),(338,'21','220','2',1,'Sale Id shift 17',0.00,0.00,0.00,4377.12,0.00,'2022-04-15 22:07:06','',''),(339,'21','220','2',1,'Sale Id shift 17',0.00,0.00,0.00,3609.14,0.00,'2022-04-15 22:07:06','',''),(340,'21','220','2',1,'Sale Id shift 17',0.00,0.00,0.00,2167.36,0.00,'2022-04-15 22:07:06','',''),(341,'21','220','2',1,'Sale Id shift 17',0.00,0.00,0.00,3985.63,0.00,'2022-04-15 22:07:06','',''),(342,'21','220','1',1,'Sale Id shift 17',0.00,0.00,0.00,5178.17,0.00,'2022-04-15 22:07:06','',''),(343,'21','220','2',1,'Sale Id shift 17',0.00,0.00,0.00,5133.80,0.00,'2022-04-15 22:07:06','',''),(344,'21','220','1',1,'Sale Id shift 17',0.00,0.00,0.00,6117.04,0.00,'2022-04-15 22:07:06','',''),(345,'21','220','3',2,'Sale Id shift 17',0.00,0.00,0.00,1376.13,0.00,'2022-04-15 22:07:06','',''),(346,'21','220',NULL,1,'Sale Id shift 17',7591773.75,0.00,0.00,0.00,0.00,'2022-04-15 22:07:06','',''),(347,'21','220',NULL,2,'Sale Id shift 17',6427176.00,0.00,0.00,0.00,0.00,'2022-04-15 22:07:06','',''),(348,'21','220',NULL,3,'Sale Id shift 17',970568.50,0.00,0.00,0.00,0.00,'2022-04-15 22:07:06','',''),(349,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-16 12:03:13','',''),(350,'21','220',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,40000.00,0.00,'2022-04-16 12:10:30','',''),(351,'21','220','2',1,'Received from bridging 45',0.00,0.00,40000.00,0.00,0.00,'2022-04-16 12:10:30','',''),(352,'21','220',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,20000.00,0.00,'2022-04-16 12:10:30','',''),(353,'21','220','1',1,'Received from bridging 44',0.00,0.00,20000.00,0.00,0.00,'2022-04-16 12:10:30','',''),(354,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-16 12:45:39','',''),(355,'21','220',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,20000.00,0.00,'2022-04-16 12:48:34','',''),(356,'21','220','1',1,'Received from bridging 46',0.00,0.00,20000.00,0.00,0.00,'2022-04-16 12:48:34','',''),(357,'21','220','1',1,'Sale Id shift 18',0.00,0.00,0.00,5431.13,0.00,'2022-04-16 12:55:48','',''),(358,'21','220','3',2,'Sale Id shift 18',0.00,0.00,0.00,7031.71,0.00,'2022-04-16 12:55:48','',''),(359,'21','220','4',3,'Sale Id shift 18',0.00,0.00,0.00,1602.22,0.00,'2022-04-16 12:55:48','',''),(360,'21','220','1',1,'Sale Id shift 18',0.00,0.00,0.00,6371.63,0.00,'2022-04-16 12:55:48','',''),(361,'21','220','1',1,'Sale Id shift 18',0.00,0.00,0.00,6796.15,0.00,'2022-04-16 12:55:48','',''),(362,'21','220','2',1,'Sale Id shift 18',0.00,0.00,0.00,2846.64,0.00,'2022-04-16 12:55:48','',''),(363,'21','220','2',1,'Sale Id shift 18',0.00,0.00,0.00,3715.91,0.00,'2022-04-16 12:55:48','',''),(364,'21','220','2',1,'Sale Id shift 18',0.00,0.00,0.00,2607.50,0.00,'2022-04-16 12:55:48','',''),(365,'21','220','2',1,'Sale Id shift 18',0.00,0.00,0.00,2819.66,0.00,'2022-04-16 12:55:48','',''),(366,'21','220','1',1,'Sale Id shift 18',0.00,0.00,0.00,4868.04,0.00,'2022-04-16 12:55:48','',''),(367,'21','220','2',1,'Sale Id shift 18',0.00,0.00,0.00,3642.71,0.00,'2022-04-16 12:55:48','',''),(368,'21','220','1',1,'Sale Id shift 18',0.00,0.00,0.00,7546.23,0.00,'2022-04-16 12:55:48','',''),(369,'21','220','3',2,'Sale Id shift 18',0.00,0.00,0.00,4021.68,0.00,'2022-04-16 12:55:48','',''),(370,'21','220',NULL,1,'Sale Id shift 18',7696524.00,0.00,0.00,0.00,0.00,'2022-04-16 12:55:48','',''),(371,'21','220',NULL,2,'Sale Id shift 18',7737373.00,0.00,0.00,0.00,0.00,'2022-04-16 12:55:48','',''),(372,'21','220',NULL,3,'Sale Id shift 18',881221.00,0.00,0.00,0.00,0.00,'2022-04-16 12:55:48','',''),(373,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-16 15:29:18','',''),(374,'21','220',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,30000.00,0.00,'2022-04-16 15:31:36','',''),(375,'21','220','2',1,'Received from bridging 49',0.00,0.00,30000.00,0.00,0.00,'2022-04-16 15:31:36','',''),(376,'21','220',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,15000.00,0.00,'2022-04-16 15:31:36','',''),(377,'21','220','1',1,'Received from bridging 48',0.00,0.00,15000.00,0.00,0.00,'2022-04-16 15:31:36','',''),(378,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,11200000.00,16000.00,0.00,0.00,'2022-04-16 15:39:31','',''),(379,'21','220',NULL,2,'Reception corrector for bridging 50',0.00,0.00,0.00,16000.00,0.00,'2022-04-16 15:42:29','',''),(380,'21','220','3',2,'Received from bridging 50',0.00,0.00,16000.00,0.00,0.00,'2022-04-16 15:42:29','',''),(381,'21','220','1',1,'Sale Id shift 19',0.00,0.00,0.00,3568.60,0.00,'2022-04-16 17:09:26','',''),(382,'21','220','3',2,'Sale Id shift 19',0.00,0.00,0.00,3004.12,0.00,'2022-04-16 17:09:26','',''),(383,'21','220','4',3,'Sale Id shift 19',0.00,0.00,0.00,1742.17,0.00,'2022-04-16 17:09:26','',''),(384,'21','220','1',1,'Sale Id shift 19',0.00,0.00,0.00,3763.91,0.00,'2022-04-16 17:09:26','',''),(385,'21','220','1',1,'Sale Id shift 19',0.00,0.00,0.00,5927.46,0.00,'2022-04-16 17:09:26','',''),(386,'21','220','2',1,'Sale Id shift 19',0.00,0.00,0.00,7968.39,0.00,'2022-04-16 17:09:26','',''),(387,'21','220','2',1,'Sale Id shift 19',0.00,0.00,0.00,6157.70,0.00,'2022-04-16 17:09:26','',''),(388,'21','220','2',1,'Sale Id shift 19',0.00,0.00,0.00,5812.76,0.00,'2022-04-16 17:09:26','',''),(389,'21','220','2',1,'Sale Id shift 19',0.00,0.00,0.00,4806.62,0.00,'2022-04-16 17:09:26','',''),(390,'21','220','1',1,'Sale Id shift 19',0.00,0.00,0.00,3194.31,0.00,'2022-04-16 17:09:26','',''),(391,'21','220','2',1,'Sale Id shift 19',0.00,0.00,0.00,7165.49,0.00,'2022-04-16 17:09:26','',''),(392,'21','220','2',1,'Sale Id shift 19',0.00,0.00,0.00,5253.76,0.00,'2022-04-16 17:09:26','',''),(393,'21','220','1',1,'Sale Id shift 19',0.00,0.00,0.00,4056.22,0.00,'2022-04-16 17:09:26','',''),(394,'21','220','3',2,'Sale Id shift 19',0.00,0.00,0.00,2372.48,0.00,'2022-04-16 17:09:26','',''),(395,'21','220',NULL,1,'Sale Id shift 19',9516411.30,0.00,0.00,0.00,0.00,'2022-04-16 17:09:26','',''),(396,'21','220',NULL,2,'Sale Id shift 19',3763620.00,0.00,0.00,0.00,0.00,'2022-04-16 17:09:26','',''),(397,'21','220',NULL,3,'Sale Id shift 19',958193.50,0.00,0.00,0.00,0.00,'2022-04-16 17:09:26','',''),(398,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-16 17:20:14','',''),(399,'21','220',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,30000.00,0.00,'2022-04-16 17:23:29','',''),(400,'21','220','2',1,'Received from bridging 52',0.00,0.00,30000.00,0.00,0.00,'2022-04-16 17:23:29','',''),(401,'21','220',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,30000.00,0.00,'2022-04-16 17:23:29','',''),(402,'21','220','1',1,'Received from bridging 51',0.00,0.00,30000.00,0.00,0.00,'2022-04-16 17:23:29','',''),(403,'21','220','1',1,'Sale Id shift 20',0.00,0.00,0.00,3740.98,0.00,'2022-04-16 18:18:22','',''),(404,'21','220','3',2,'Sale Id shift 20',0.00,0.00,0.00,3320.16,0.00,'2022-04-16 18:18:22','',''),(405,'21','220','4',3,'Sale Id shift 20',0.00,0.00,0.00,705.89,0.00,'2022-04-16 18:18:22','',''),(406,'21','220','1',1,'Sale Id shift 20',0.00,0.00,0.00,3648.90,0.00,'2022-04-16 18:18:22','',''),(407,'21','220','1',1,'Sale Id shift 20',0.00,0.00,0.00,4151.59,0.00,'2022-04-16 18:18:22','',''),(408,'21','220','2',1,'Sale Id shift 20',0.00,0.00,0.00,6549.96,0.00,'2022-04-16 18:18:22','',''),(409,'21','220','2',1,'Sale Id shift 20',0.00,0.00,0.00,1951.49,0.00,'2022-04-16 18:18:22','',''),(410,'21','220','2',1,'Sale Id shift 20',0.00,0.00,0.00,3908.03,0.00,'2022-04-16 18:18:22','',''),(411,'21','220','2',1,'Sale Id shift 20',0.00,0.00,0.00,3964.96,0.00,'2022-04-16 18:18:22','',''),(412,'21','220','1',1,'Sale Id shift 20',0.00,0.00,0.00,3634.90,0.00,'2022-04-16 18:18:22','',''),(413,'21','220','2',1,'Sale Id shift 20',0.00,0.00,0.00,2222.78,0.00,'2022-04-16 18:18:22','',''),(414,'21','220','2',1,'Sale Id shift 20',0.00,0.00,0.00,5322.43,0.00,'2022-04-16 18:18:22','',''),(415,'21','220','1',1,'Sale Id shift 20',0.00,0.00,0.00,5010.15,0.00,'2022-04-16 18:18:22','',''),(416,'21','220','3',2,'Sale Id shift 20',0.00,0.00,0.00,1322.26,0.00,'2022-04-16 18:18:22','',''),(417,'21','220',NULL,1,'Sale Id shift 20',7277518.05,0.00,0.00,0.00,0.00,'2022-04-16 18:18:22','',''),(418,'21','220',NULL,2,'Sale Id shift 20',3249694.00,0.00,0.00,0.00,0.00,'2022-04-16 18:18:22','',''),(419,'21','220',NULL,3,'Sale Id shift 20',388239.50,0.00,0.00,0.00,0.00,'2022-04-16 18:18:22','',''),(420,'21','220',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,16500000.00,30000.00,0.00,0.00,'2022-04-16 23:00:49','',''),(421,'21','220',NULL,3,'Reception corrector for bridging 53',0.00,0.00,0.00,30000.00,0.00,'2022-04-16 23:05:00','',''),(422,'21','220','4',3,'Received from bridging 53',0.00,0.00,30000.00,0.00,0.00,'2022-04-16 23:05:00','',''),(423,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-16 23:08:48','',''),(424,'21','220',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,30000.00,0.00,'2022-04-16 23:10:20','',''),(425,'21','220','2',1,'Received from bridging 55',0.00,0.00,30000.00,0.00,0.00,'2022-04-16 23:10:20','',''),(426,'21','220',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,30000.00,0.00,'2022-04-16 23:10:20','',''),(427,'21','220','1',1,'Received from bridging 54',0.00,0.00,30000.00,0.00,0.00,'2022-04-16 23:10:20','',''),(428,'21','220','1',1,'Sale Id shift 21',0.00,0.00,0.00,5822.03,0.00,'2022-04-17 13:47:50','',''),(429,'21','220','3',2,'Sale Id shift 21',0.00,0.00,0.00,4438.43,0.00,'2022-04-17 13:47:50','',''),(430,'21','220','4',3,'Sale Id shift 21',0.00,0.00,0.00,1816.72,0.00,'2022-04-17 13:47:50','',''),(431,'21','220','1',1,'Sale Id shift 21',0.00,0.00,0.00,6140.42,0.00,'2022-04-17 13:47:50','',''),(432,'21','220','1',1,'Sale Id shift 21',0.00,0.00,0.00,5809.38,0.00,'2022-04-17 13:47:50','',''),(433,'21','220','2',1,'Sale Id shift 21',0.00,0.00,0.00,7212.94,0.00,'2022-04-17 13:47:50','',''),(434,'21','220','2',1,'Sale Id shift 21',0.00,0.00,0.00,1821.82,0.00,'2022-04-17 13:47:50','',''),(435,'21','220','2',1,'Sale Id shift 21',0.00,0.00,0.00,4715.59,0.00,'2022-04-17 13:47:50','',''),(436,'21','220','2',1,'Sale Id shift 21',0.00,0.00,0.00,3916.30,0.00,'2022-04-17 13:47:50','',''),(437,'21','220','1',1,'Sale Id shift 21',0.00,0.00,0.00,4972.39,0.00,'2022-04-17 13:47:50','',''),(438,'21','220','2',1,'Sale Id shift 21',0.00,0.00,0.00,4978.75,0.00,'2022-04-17 13:47:50','',''),(439,'21','220','2',1,'Sale Id shift 21',0.00,0.00,0.00,3510.55,0.00,'2022-04-17 13:47:50','',''),(440,'21','220','1',1,'Sale Id shift 21',0.00,0.00,0.00,7182.23,0.00,'2022-04-17 13:47:50','',''),(441,'21','220','3',2,'Sale Id shift 21',0.00,0.00,0.00,2123.11,0.00,'2022-04-17 13:47:50','',''),(442,'21','220',NULL,2,'Sale Id shift 21',4593078.00,0.00,0.00,0.00,0.00,'2022-04-17 13:47:50','',''),(443,'21','220',NULL,3,'Sale Id shift 21',999196.00,0.00,0.00,0.00,0.00,'2022-04-17 13:47:50','',''),(444,'21','220',NULL,1,'Sale Id shift 21',9253596.00,0.00,0.00,0.00,0.00,'2022-04-17 13:47:50','',''),(445,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-17 14:02:45','',''),(446,'21','220',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,20000.00,0.00,'2022-04-17 14:07:25','',''),(447,'21','220','2',1,'Received from bridging 57',0.00,0.00,20000.00,0.00,0.00,'2022-04-17 14:07:25','',''),(448,'21','220',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,30000.00,0.00,'2022-04-17 14:07:25','',''),(449,'21','220','1',1,'Received from bridging 56',0.00,0.00,30000.00,0.00,0.00,'2022-04-17 14:07:25','',''),(450,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,14000000.00,20000.00,0.00,0.00,'2022-04-17 14:09:40','',''),(451,'21','220',NULL,2,'Reception corrector for bridging 58',0.00,0.00,0.00,20000.00,0.00,'2022-04-17 14:11:09','',''),(452,'21','220','3',2,'Received from bridging 58',0.00,0.00,20000.00,0.00,0.00,'2022-04-17 14:11:09','',''),(453,'21','220','1',1,'Sale Id shift 22',0.00,0.00,0.00,7745.85,0.00,'2022-04-17 16:25:43','',''),(454,'21','220','4',3,'Sale Id shift 22',0.00,0.00,0.00,1869.65,0.00,'2022-04-17 16:25:43','',''),(455,'21','220','1',1,'Sale Id shift 22',0.00,0.00,0.00,6613.48,0.00,'2022-04-17 16:25:43','',''),(456,'21','220','1',1,'Sale Id shift 22',0.00,0.00,0.00,846.21,0.00,'2022-04-17 16:25:43','',''),(457,'21','220','1',1,'Sale Id shift 22',0.00,0.00,0.00,695.53,0.00,'2022-04-17 16:25:43','',''),(458,'21','220','1',1,'Sale Id shift 22',0.00,0.00,0.00,6203.82,0.00,'2022-04-17 16:25:43','',''),(459,'21','220','2',1,'Sale Id shift 22',0.00,0.00,0.00,6465.16,0.00,'2022-04-17 16:25:43','',''),(460,'21','220','2',1,'Sale Id shift 22',0.00,0.00,0.00,1370.33,0.00,'2022-04-17 16:25:43','',''),(461,'21','220','2',1,'Sale Id shift 22',0.00,0.00,0.00,4244.85,0.00,'2022-04-17 16:25:43','',''),(462,'21','220','2',1,'Sale Id shift 22',0.00,0.00,0.00,4040.28,0.00,'2022-04-17 16:25:43','',''),(463,'21','220','1',1,'Sale Id shift 22',0.00,0.00,0.00,6963.07,0.00,'2022-04-17 16:25:43','',''),(464,'21','220','2',1,'Sale Id shift 22',0.00,0.00,0.00,5064.48,0.00,'2022-04-17 16:25:43','',''),(465,'21','220','2',1,'Sale Id shift 22',0.00,0.00,0.00,2002.76,0.00,'2022-04-17 16:25:43','',''),(466,'21','220','3',2,'Sale Id shift 22',0.00,0.00,0.00,2154.53,0.00,'2022-04-17 16:25:43','',''),(467,'21','220',NULL,1,'Sale Id shift 22',8622210.30,0.00,0.00,0.00,0.00,'2022-04-17 16:25:43','',''),(468,'21','220',NULL,2,'Sale Id shift 22',1508171.00,0.00,0.00,0.00,0.00,'2022-04-17 16:25:44','',''),(469,'21','220',NULL,3,'Sale Id shift 22',1028307.50,0.00,0.00,0.00,0.00,'2022-04-17 16:25:44','',''),(470,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-17 16:26:15','',''),(471,'21','220',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,17000.00,0.00,'2022-04-17 16:35:07','',''),(472,'21','220','2',1,'Received from bridging 60',0.00,0.00,17000.00,0.00,0.00,'2022-04-17 16:35:07','',''),(473,'21','220',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,33000.00,0.00,'2022-04-17 16:35:07','',''),(474,'21','220','1',1,'Received from bridging 59',0.00,0.00,33000.00,0.00,0.00,'2022-04-17 16:35:07','',''),(475,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,23415000.00,33450.00,0.00,0.00,'2022-04-17 16:43:58','',''),(476,'21','220','1',1,'Sale Id shift 23',0.00,0.00,0.00,5679.75,0.00,'2022-04-17 17:41:16','',''),(477,'21','220','3',2,'Sale Id shift 23',0.00,0.00,0.00,821.69,0.00,'2022-04-17 17:41:16','',''),(478,'21','220','4',3,'Sale Id shift 23',0.00,0.00,0.00,948.03,0.00,'2022-04-17 17:41:16','',''),(479,'21','220','1',1,'Sale Id shift 23',0.00,0.00,0.00,6987.19,0.00,'2022-04-17 17:41:16','',''),(480,'21','220','1',1,'Sale Id shift 23',0.00,0.00,0.00,2716.65,0.00,'2022-04-17 17:41:16','',''),(481,'21','220','1',1,'Sale Id shift 23',0.00,0.00,0.00,3654.50,0.00,'2022-04-17 17:41:16','',''),(482,'21','220','2',1,'Sale Id shift 23',0.00,0.00,0.00,5817.94,0.00,'2022-04-17 17:41:16','',''),(483,'21','220','2',1,'Sale Id shift 23',0.00,0.00,0.00,4375.35,0.00,'2022-04-17 17:41:16','',''),(484,'21','220','2',1,'Sale Id shift 23',0.00,0.00,0.00,4428.13,0.00,'2022-04-17 17:41:16','',''),(485,'21','220','2',1,'Sale Id shift 23',0.00,0.00,0.00,4761.42,0.00,'2022-04-17 17:41:16','',''),(486,'21','220','1',1,'Sale Id shift 23',0.00,0.00,0.00,6240.63,0.00,'2022-04-17 17:41:16','',''),(487,'21','220','2',1,'Sale Id shift 23',0.00,0.00,0.00,6045.02,0.00,'2022-04-17 17:41:16','',''),(488,'21','220','2',1,'Sale Id shift 23',0.00,0.00,0.00,2709.62,0.00,'2022-04-17 17:41:16','',''),(489,'21','220','1',1,'Sale Id shift 23',0.00,0.00,0.00,14955.34,0.00,'2022-04-17 17:41:16','',''),(490,'21','220',NULL,1,'Sale Id shift 23',11281304.10,0.00,0.00,0.00,0.00,'2022-04-17 17:41:16','',''),(491,'21','220',NULL,2,'Sale Id shift 23',575183.00,0.00,0.00,0.00,0.00,'2022-04-17 17:41:16','',''),(492,'21','220',NULL,3,'Sale Id shift 23',521416.50,0.00,0.00,0.00,0.00,'2022-04-17 17:41:16','',''),(493,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-17 17:45:55','',''),(494,'21','220',NULL,1,'Returned purchase #37 to AYM SHAFA NIGERIA LIMITED',8250000.00,0.00,0.00,50000.00,0.00,'2022-04-17 17:49:22','',''),(495,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7095000.00,43000.00,0.00,0.00,'2022-04-17 17:55:01','',''),(496,'21','220',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,20000.00,0.00,'2022-04-17 20:18:44','',''),(497,'21','220','2',1,'Received from bridging 64',0.00,0.00,20000.00,0.00,0.00,'2022-04-17 20:18:44','',''),(498,'21','220',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,23000.00,0.00,'2022-04-17 20:18:44','',''),(499,'21','220','1',1,'Received from bridging 63',0.00,0.00,23000.00,0.00,0.00,'2022-04-17 20:18:44','',''),(500,'21','220','1',1,'Sale Id shift 24',0.00,0.00,0.00,4997.82,0.00,'2022-04-17 21:52:46','',''),(501,'21','220','3',2,'Sale Id shift 24',0.00,0.00,0.00,6751.49,0.00,'2022-04-17 21:52:46','',''),(502,'21','220','4',3,'Sale Id shift 24',0.00,0.00,0.00,1086.80,0.00,'2022-04-17 21:52:46','',''),(503,'21','220','1',1,'Sale Id shift 24',0.00,0.00,0.00,5580.04,0.00,'2022-04-17 21:52:46','',''),(504,'21','220','1',1,'Sale Id shift 24',0.00,0.00,0.00,5463.42,0.00,'2022-04-17 21:52:46','',''),(505,'21','220','1',1,'Sale Id shift 24',0.00,0.00,0.00,3333.30,0.00,'2022-04-17 21:52:46','',''),(506,'21','220','2',1,'Sale Id shift 24',0.00,0.00,0.00,5385.87,0.00,'2022-04-17 21:52:46','',''),(507,'21','220','2',1,'Sale Id shift 24',0.00,0.00,0.00,2841.17,0.00,'2022-04-17 21:52:46','',''),(508,'21','220','2',1,'Sale Id shift 24',0.00,0.00,0.00,4416.19,0.00,'2022-04-17 21:52:46','',''),(509,'21','220','1',1,'Sale Id shift 24',0.00,0.00,0.00,4686.08,0.00,'2022-04-17 21:52:46','',''),(510,'21','220','2',1,'Sale Id shift 24',0.00,0.00,0.00,6207.97,0.00,'2022-04-17 21:52:46','',''),(511,'21','220','2',1,'Sale Id shift 24',0.00,0.00,0.00,506.10,0.00,'2022-04-17 21:52:46','',''),(512,'21','220','1',1,'Sale Id shift 24',0.00,0.00,0.00,6797.13,0.00,'2022-04-17 21:52:46','',''),(513,'21','220',NULL,2,'Sale Id shift 24',4726043.00,0.00,0.00,0.00,0.00,'2022-04-17 21:52:46','',''),(514,'21','220',NULL,3,'Sale Id shift 24',597740.00,0.00,0.00,0.00,0.00,'2022-04-17 21:52:46','',''),(515,'21','220',NULL,1,'Sale Id shift 24',8285489.85,0.00,0.00,0.00,0.00,'2022-04-17 21:52:46','',''),(516,'21','220',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,40000.00,0.00,'2022-04-18 05:11:20','',''),(517,'21','220','2',1,'Received from bridging 47',0.00,0.00,40000.00,0.00,0.00,'2022-04-18 05:11:20','',''),(518,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-18 14:14:27','',''),(519,'21','220',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,40000.00,0.00,'2022-04-18 14:16:20','',''),(520,'21','220','1',1,'Received from bridging 66',0.00,0.00,40000.00,0.00,0.00,'2022-04-18 14:16:20','',''),(521,'21','220','1',1,'Sale Id shift 25',0.00,0.00,0.00,5882.34,0.00,'2022-04-18 15:52:32','',''),(522,'21','220','3',2,'Sale Id shift 25',0.00,0.00,0.00,4551.53,0.00,'2022-04-18 15:52:32','',''),(523,'21','220','4',3,'Sale Id shift 25',0.00,0.00,0.00,2203.13,0.00,'2022-04-18 15:52:32','',''),(524,'21','220','1',1,'Sale Id shift 25',0.00,0.00,0.00,6086.60,0.00,'2022-04-18 15:52:32','',''),(525,'21','220','1',1,'Sale Id shift 25',0.00,0.00,0.00,3192.26,0.00,'2022-04-18 15:52:32','',''),(526,'21','220','1',1,'Sale Id shift 25',0.00,0.00,0.00,4717.75,0.00,'2022-04-18 15:52:32','',''),(527,'21','220','2',1,'Sale Id shift 25',0.00,0.00,0.00,6778.05,0.00,'2022-04-18 15:52:32','',''),(528,'21','220','2',1,'Sale Id shift 25',0.00,0.00,0.00,1586.29,0.00,'2022-04-18 15:52:32','',''),(529,'21','220','2',1,'Sale Id shift 25',0.00,0.00,0.00,4771.67,0.00,'2022-04-18 15:52:32','',''),(530,'21','220','2',1,'Sale Id shift 25',0.00,0.00,0.00,3999.89,0.00,'2022-04-18 15:52:32','',''),(531,'21','220','1',1,'Sale Id shift 25',0.00,0.00,0.00,4555.85,0.00,'2022-04-18 15:52:32','',''),(532,'21','220','2',1,'Sale Id shift 25',0.00,0.00,0.00,4641.71,0.00,'2022-04-18 15:52:32','',''),(533,'21','220','1',1,'Sale Id shift 25',0.00,0.00,0.00,6988.88,0.00,'2022-04-18 15:52:32','',''),(534,'21','220','3',2,'Sale Id shift 25',0.00,0.00,0.00,2487.94,0.00,'2022-04-18 15:52:32','',''),(535,'21','220',NULL,1,'Sale Id shift 25',8778212.85,0.00,0.00,0.00,0.00,'2022-04-18 15:52:32','',''),(536,'21','220',NULL,2,'Sale Id shift 25',4927629.00,0.00,0.00,0.00,0.00,'2022-04-18 15:52:32','',''),(537,'21','220',NULL,3,'Sale Id shift 25',1211721.50,0.00,0.00,0.00,0.00,'2022-04-18 15:52:32','',''),(538,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-18 16:48:24','',''),(539,'21','220',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,15000.00,0.00,'2022-04-18 16:50:49','',''),(540,'21','220','1',1,'Received from bridging 68',0.00,0.00,15000.00,0.00,0.00,'2022-04-18 16:50:49','',''),(541,'21','220',NULL,2,'Reception corrector for bridging 65',0.00,0.00,0.00,33450.00,0.00,'2022-04-18 17:10:02','',''),(542,'21','220','3',2,'Received from bridging 65',0.00,0.00,33450.00,0.00,0.00,'2022-04-18 17:10:02','',''),(543,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-18 17:11:29','',''),(544,'21','220',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,32000.00,0.00,'2022-04-18 17:12:57','',''),(545,'21','220','1',1,'Received from bridging 70',0.00,0.00,32000.00,0.00,0.00,'2022-04-18 17:12:57','',''),(546,'21','220',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,20000.00,0.00,'2022-04-18 17:14:32','',''),(547,'21','220','2',1,'Received from bridging 67',0.00,0.00,20000.00,0.00,0.00,'2022-04-18 17:14:32','',''),(548,'21','220','1',1,'Sale Id shift 26',0.00,0.00,0.00,5248.55,0.00,'2022-04-18 17:51:09','',''),(549,'21','220','3',2,'Sale Id shift 26',0.00,0.00,0.00,10029.70,0.00,'2022-04-18 17:51:09','',''),(550,'21','220','4',3,'Sale Id shift 26',0.00,0.00,0.00,2825.74,0.00,'2022-04-18 17:51:09','',''),(551,'21','220','1',1,'Sale Id shift 26',0.00,0.00,0.00,4655.01,0.00,'2022-04-18 17:51:09','',''),(552,'21','220','1',1,'Sale Id shift 26',0.00,0.00,0.00,4114.74,0.00,'2022-04-18 17:51:09','',''),(553,'21','220','1',1,'Sale Id shift 26',0.00,0.00,0.00,3568.82,0.00,'2022-04-18 17:51:09','',''),(554,'21','220','2',1,'Sale Id shift 26',0.00,0.00,0.00,5573.17,0.00,'2022-04-18 17:51:09','',''),(555,'21','220','2',1,'Sale Id shift 26',0.00,0.00,0.00,3869.74,0.00,'2022-04-18 17:51:09','',''),(556,'21','220','2',1,'Sale Id shift 26',0.00,0.00,0.00,2411.80,0.00,'2022-04-18 17:51:09','',''),(557,'21','220','2',1,'Sale Id shift 26',0.00,0.00,0.00,4097.43,0.00,'2022-04-18 17:51:09','',''),(558,'21','220','1',1,'Sale Id shift 26',0.00,0.00,0.00,3373.61,0.00,'2022-04-18 17:51:09','',''),(559,'21','220','2',1,'Sale Id shift 26',0.00,0.00,0.00,4272.76,0.00,'2022-04-18 17:51:09','',''),(560,'21','220','2',1,'Sale Id shift 26',0.00,0.00,0.00,76.97,0.00,'2022-04-18 17:51:09','',''),(561,'21','220','1',1,'Sale Id shift 26',0.00,0.00,0.00,6179.00,0.00,'2022-04-18 17:51:09','',''),(562,'21','220','3',2,'Sale Id shift 26',0.00,0.00,0.00,3063.44,0.00,'2022-04-18 17:51:09','',''),(563,'21','220',NULL,1,'Sale Id shift 26',7827864.00,0.00,0.00,0.00,0.00,'2022-04-18 17:51:09','',''),(564,'21','220',NULL,2,'Sale Id shift 26',9165198.00,0.00,0.00,0.00,0.00,'2022-04-18 17:51:09','',''),(565,'21','220',NULL,3,'Sale Id shift 26',1554157.00,0.00,0.00,0.00,0.00,'2022-04-18 17:51:09','',''),(566,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-18 17:54:27','',''),(567,'21','220',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,17000.00,0.00,'2022-04-18 17:56:31','',''),(568,'21','220','2',1,'Received from bridging 73',0.00,0.00,17000.00,0.00,0.00,'2022-04-18 17:56:31','',''),(569,'21','220',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,33000.00,0.00,'2022-04-18 17:56:32','',''),(570,'21','220','1',1,'Received from bridging 72',0.00,0.00,33000.00,0.00,0.00,'2022-04-18 17:56:32','',''),(571,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,21000000.00,30000.00,0.00,0.00,'2022-04-18 17:59:59','',''),(572,'21','220','1',1,'Sale Id shift 27',0.00,0.00,0.00,5790.09,0.00,'2022-04-18 18:06:45','',''),(573,'21','220','3',2,'Sale Id shift 27',0.00,0.00,0.00,1966.31,0.00,'2022-04-18 18:06:45','',''),(574,'21','220','4',3,'Sale Id shift 27',0.00,0.00,0.00,833.07,0.00,'2022-04-18 18:06:45','',''),(575,'21','220','1',1,'Sale Id shift 27',0.00,0.00,0.00,5703.70,0.00,'2022-04-18 18:06:45','',''),(576,'21','220','1',1,'Sale Id shift 27',0.00,0.00,0.00,4648.49,0.00,'2022-04-18 18:06:45','',''),(577,'21','220','1',1,'Sale Id shift 27',0.00,0.00,0.00,1607.95,0.00,'2022-04-18 18:06:45','',''),(578,'21','220','2',1,'Sale Id shift 27',0.00,0.00,0.00,5520.30,0.00,'2022-04-18 18:06:45','',''),(579,'21','220','2',1,'Sale Id shift 27',0.00,0.00,0.00,3643.50,0.00,'2022-04-18 18:06:45','',''),(580,'21','220','2',1,'Sale Id shift 27',0.00,0.00,0.00,4096.66,0.00,'2022-04-18 18:06:45','',''),(581,'21','220','2',1,'Sale Id shift 27',0.00,0.00,0.00,2570.75,0.00,'2022-04-18 18:06:45','',''),(582,'21','220','1',1,'Sale Id shift 27',0.00,0.00,0.00,5366.04,0.00,'2022-04-18 18:06:45','',''),(583,'21','220','2',1,'Sale Id shift 27',0.00,0.00,0.00,4918.24,0.00,'2022-04-18 18:06:45','',''),(584,'21','220','1',1,'Sale Id shift 27',0.00,0.00,0.00,7844.34,0.00,'2022-04-18 18:06:45','',''),(585,'21','220',NULL,1,'Sale Id shift 27',8532159.90,0.00,0.00,0.00,0.00,'2022-04-18 18:06:45','',''),(586,'21','220',NULL,2,'Sale Id shift 27',1376417.00,0.00,0.00,0.00,0.00,'2022-04-18 18:06:45','',''),(587,'21','220',NULL,3,'Sale Id shift 27',458188.50,0.00,0.00,0.00,0.00,'2022-04-18 18:06:45','',''),(588,'21','220','1',1,'Sale Id shift 28',0.00,0.00,0.00,4140.19,0.00,'2022-04-18 21:34:52','',''),(589,'21','220','3',2,'Sale Id shift 28',0.00,0.00,0.00,5165.13,0.00,'2022-04-18 21:34:52','',''),(590,'21','220','4',3,'Sale Id shift 28',0.00,0.00,0.00,2839.43,0.00,'2022-04-18 21:34:52','',''),(591,'21','220','1',1,'Sale Id shift 28',0.00,0.00,0.00,4236.76,0.00,'2022-04-18 21:34:52','',''),(592,'21','220','1',1,'Sale Id shift 28',0.00,0.00,0.00,3633.56,0.00,'2022-04-18 21:34:52','',''),(593,'21','220','1',1,'Sale Id shift 28',0.00,0.00,0.00,3513.34,0.00,'2022-04-18 21:34:52','',''),(594,'21','220','2',1,'Sale Id shift 28',0.00,0.00,0.00,7665.63,0.00,'2022-04-18 21:34:52','',''),(595,'21','220','2',1,'Sale Id shift 28',0.00,0.00,0.00,5017.49,0.00,'2022-04-18 21:34:52','',''),(596,'21','220','2',1,'Sale Id shift 28',0.00,0.00,0.00,5269.19,0.00,'2022-04-18 21:34:52','',''),(597,'21','220','2',1,'Sale Id shift 28',0.00,0.00,0.00,4960.09,0.00,'2022-04-18 21:34:52','',''),(598,'21','220','1',1,'Sale Id shift 28',0.00,0.00,0.00,2032.11,0.00,'2022-04-18 21:34:52','',''),(599,'21','220','2',1,'Sale Id shift 28',0.00,0.00,0.00,7048.52,0.00,'2022-04-18 21:34:52','',''),(600,'21','220','1',1,'Sale Id shift 28',0.00,0.00,0.00,3977.86,0.00,'2022-04-18 21:34:52','',''),(601,'21','220','3',2,'Sale Id shift 28',0.00,0.00,0.00,1248.96,0.00,'2022-04-18 21:34:52','',''),(602,'21','220',NULL,2,'Sale Id shift 28',4489863.00,0.00,0.00,0.00,0.00,'2022-04-18 21:34:52','',''),(603,'21','220',NULL,3,'Sale Id shift 28',1561686.50,0.00,0.00,0.00,0.00,'2022-04-18 21:34:52','',''),(604,'21','220',NULL,1,'Sale Id shift 28',8496632.10,0.00,0.00,0.00,0.00,'2022-04-18 21:34:52','',''),(605,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 00:35:13','',''),(606,'21','220',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,17000.00,0.00,'2022-04-19 00:36:56','',''),(607,'21','220','2',1,'Received from bridging 76',0.00,0.00,17000.00,0.00,0.00,'2022-04-19 00:36:56','',''),(608,'21','220',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,33000.00,0.00,'2022-04-19 00:36:56','',''),(609,'21','220','1',1,'Received from bridging 75',0.00,0.00,33000.00,0.00,0.00,'2022-04-19 00:36:56','',''),(610,'21','220',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 00:37:30','',''),(611,'21','220','2',1,'Received from bridging 69',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 00:37:30','',''),(612,'21','220','1',1,'Sale Id shift 29',0.00,0.00,0.00,5003.13,0.00,'2022-04-19 09:43:26','',''),(613,'21','220','3',2,'Sale Id shift 29',0.00,0.00,0.00,5891.52,0.00,'2022-04-19 09:43:26','',''),(614,'21','220','4',3,'Sale Id shift 29',0.00,0.00,0.00,3114.30,0.00,'2022-04-19 09:43:26','',''),(615,'21','220','1',1,'Sale Id shift 29',0.00,0.00,0.00,5424.55,0.00,'2022-04-19 09:43:26','',''),(616,'21','220','1',1,'Sale Id shift 29',0.00,0.00,0.00,0.31,0.00,'2022-04-19 09:43:26','',''),(617,'21','220','1',1,'Sale Id shift 29',0.00,0.00,0.00,4694.22,0.00,'2022-04-19 09:43:26','',''),(618,'21','220','1',1,'Sale Id shift 29',0.00,0.00,0.00,4290.92,0.00,'2022-04-19 09:43:26','',''),(619,'21','220','2',1,'Sale Id shift 29',0.00,0.00,0.00,4552.79,0.00,'2022-04-19 09:43:26','',''),(620,'21','220','2',1,'Sale Id shift 29',0.00,0.00,0.00,2149.00,0.00,'2022-04-19 09:43:26','',''),(621,'21','220','2',1,'Sale Id shift 29',0.00,0.00,0.00,3346.81,0.00,'2022-04-19 09:43:26','',''),(622,'21','220','2',1,'Sale Id shift 29',0.00,0.00,0.00,3345.56,0.00,'2022-04-19 09:43:26','',''),(623,'21','220','1',1,'Sale Id shift 29',0.00,0.00,0.00,5910.40,0.00,'2022-04-19 09:43:26','',''),(624,'21','220','2',1,'Sale Id shift 29',0.00,0.00,0.00,3378.85,0.00,'2022-04-19 09:43:26','',''),(625,'21','220','1',1,'Sale Id shift 29',0.00,0.00,0.00,6979.19,0.00,'2022-04-19 09:43:26','',''),(626,'21','220','3',2,'Sale Id shift 29',0.00,0.00,0.00,2310.41,0.00,'2022-04-19 09:43:26','',''),(627,'21','220',NULL,2,'Sale Id shift 29',5741351.00,0.00,0.00,0.00,0.00,'2022-04-19 09:43:26','',''),(628,'21','220',NULL,3,'Sale Id shift 29',1712865.00,0.00,0.00,0.00,0.00,'2022-04-19 09:43:26','',''),(629,'21','220',NULL,1,'Sale Id shift 29',8097495.45,0.00,0.00,0.00,0.00,'2022-04-19 09:43:26','',''),(630,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 12:08:41','',''),(631,'21','220',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,17000.00,0.00,'2022-04-19 12:11:47','',''),(632,'21','220','2',1,'Received from bridging 78',0.00,0.00,17000.00,0.00,0.00,'2022-04-19 12:11:47','',''),(633,'21','220',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,33000.00,0.00,'2022-04-19 12:11:47','',''),(634,'21','220','1',1,'Received from bridging 77',0.00,0.00,33000.00,0.00,0.00,'2022-04-19 12:11:47','',''),(635,'21','220',NULL,2,'Reception corrector for bridging 74',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 12:12:15','',''),(636,'21','220','3',2,'Received from bridging 74',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 12:12:15','',''),(637,'21','220','1',1,'Sale Id shift 30',0.00,0.00,0.00,5703.41,0.00,'2022-04-19 14:53:19','',''),(638,'21','220','3',2,'Sale Id shift 30',0.00,0.00,0.00,4583.81,0.00,'2022-04-19 14:53:19','',''),(639,'21','220','4',3,'Sale Id shift 30',0.00,0.00,0.00,2648.03,0.00,'2022-04-19 14:53:19','',''),(640,'21','220','1',1,'Sale Id shift 30',0.00,0.00,0.00,6709.88,0.00,'2022-04-19 14:53:19','',''),(641,'21','220','1',1,'Sale Id shift 30',0.00,0.00,0.00,5298.02,0.00,'2022-04-19 14:53:19','',''),(642,'21','220','1',1,'Sale Id shift 30',0.00,0.00,0.00,4655.32,0.00,'2022-04-19 14:53:19','',''),(643,'21','220','2',1,'Sale Id shift 30',0.00,0.00,0.00,2428.04,0.00,'2022-04-19 14:53:19','',''),(644,'21','220','2',1,'Sale Id shift 30',0.00,0.00,0.00,4745.25,0.00,'2022-04-19 14:53:19','',''),(645,'21','220','2',1,'Sale Id shift 30',0.00,0.00,0.00,2955.30,0.00,'2022-04-19 14:53:19','',''),(646,'21','220','2',1,'Sale Id shift 30',0.00,0.00,0.00,4698.06,0.00,'2022-04-19 14:53:19','',''),(647,'21','220','1',1,'Sale Id shift 30',0.00,0.00,0.00,5468.01,0.00,'2022-04-19 14:53:19','',''),(648,'21','220','2',1,'Sale Id shift 30',0.00,0.00,0.00,4776.46,0.00,'2022-04-19 14:53:19','',''),(649,'21','220','1',1,'Sale Id shift 30',0.00,0.00,0.00,6633.83,0.00,'2022-04-19 14:53:19','',''),(650,'21','220','3',2,'Sale Id shift 30',0.00,0.00,0.00,25.72,0.00,'2022-04-19 14:53:19','',''),(651,'21','220',NULL,1,'Sale Id shift 30',8921810.70,0.00,0.00,0.00,0.00,'2022-04-19 14:53:19','',''),(652,'21','220',NULL,2,'Sale Id shift 30',3226671.00,0.00,0.00,0.00,0.00,'2022-04-19 14:53:19','',''),(653,'21','220',NULL,3,'Sale Id shift 30',1456416.50,0.00,0.00,0.00,0.00,'2022-04-19 14:53:19','',''),(654,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 14:55:15','',''),(655,'21','220',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,17000.00,0.00,'2022-04-19 14:56:51','',''),(656,'21','220','2',1,'Received from bridging 80',0.00,0.00,17000.00,0.00,0.00,'2022-04-19 14:56:51','',''),(657,'21','220',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,33000.00,0.00,'2022-04-19 14:56:51','',''),(658,'21','220','1',1,'Received from bridging 79',0.00,0.00,33000.00,0.00,0.00,'2022-04-19 14:56:51','',''),(659,'21','220','1',1,'Sale Id shift 31',0.00,0.00,0.00,6636.11,0.00,'2022-04-19 15:51:16','',''),(660,'21','220','3',2,'Sale Id shift 31',0.00,0.00,0.00,4508.77,0.00,'2022-04-19 15:51:16','',''),(661,'21','220','4',3,'Sale Id shift 31',0.00,0.00,0.00,909.69,0.00,'2022-04-19 15:51:16','',''),(662,'21','220','1',1,'Sale Id shift 31',0.00,0.00,0.00,6439.90,0.00,'2022-04-19 15:51:16','',''),(663,'21','220','1',1,'Sale Id shift 31',0.00,0.00,0.00,5764.58,0.00,'2022-04-19 15:51:16','',''),(664,'21','220','1',1,'Sale Id shift 31',0.00,0.00,0.00,5863.44,0.00,'2022-04-19 15:51:16','',''),(665,'21','220','2',1,'Sale Id shift 31',0.00,0.00,0.00,4778.24,0.00,'2022-04-19 15:51:16','',''),(666,'21','220','2',1,'Sale Id shift 31',0.00,0.00,0.00,3348.18,0.00,'2022-04-19 15:51:16','',''),(667,'21','220','2',1,'Sale Id shift 31',0.00,0.00,0.00,2962.58,0.00,'2022-04-19 15:51:16','',''),(668,'21','220','2',1,'Sale Id shift 31',0.00,0.00,0.00,2620.94,0.00,'2022-04-19 15:51:16','',''),(669,'21','220','1',1,'Sale Id shift 31',0.00,0.00,0.00,5914.55,0.00,'2022-04-19 15:51:16','',''),(670,'21','220','2',1,'Sale Id shift 31',0.00,0.00,0.00,4642.66,0.00,'2022-04-19 15:51:16','',''),(671,'21','220','1',1,'Sale Id shift 31',0.00,0.00,0.00,8526.62,0.00,'2022-04-19 15:51:16','',''),(672,'21','220',NULL,1,'Sale Id shift 31',9487137.00,0.00,0.00,0.00,0.00,'2022-04-19 15:51:16','',''),(673,'21','220',NULL,2,'Sale Id shift 31',3156139.00,0.00,0.00,0.00,0.00,'2022-04-19 15:51:16','',''),(674,'21','220',NULL,3,'Sale Id shift 31',500329.50,0.00,0.00,0.00,0.00,'2022-04-19 15:51:16','',''),(675,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 15:53:08','',''),(676,'21','220',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,20000.00,0.00,'2022-04-19 15:58:45','',''),(677,'21','220','2',1,'Received from bridging 82',0.00,0.00,20000.00,0.00,0.00,'2022-04-19 15:58:45','',''),(678,'21','220',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 15:58:45','',''),(679,'21','220','1',1,'Received from bridging 81',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 15:58:45','',''),(680,'21','220','1',1,'Sale Id shift 32',0.00,0.00,0.00,4725.35,0.00,'2022-04-19 17:24:19','',''),(681,'21','220','3',2,'Sale Id shift 32',0.00,0.00,0.00,4730.16,0.00,'2022-04-19 17:24:19','',''),(682,'21','220','4',3,'Sale Id shift 32',0.00,0.00,0.00,3016.17,0.00,'2022-04-19 17:24:19','',''),(683,'21','220','1',1,'Sale Id shift 32',0.00,0.00,0.00,5053.43,0.00,'2022-04-19 17:24:19','',''),(684,'21','220','1',1,'Sale Id shift 32',0.00,0.00,0.00,4352.65,0.00,'2022-04-19 17:24:19','',''),(685,'21','220','1',1,'Sale Id shift 32',0.00,0.00,0.00,2927.20,0.00,'2022-04-19 17:24:19','',''),(686,'21','220','2',1,'Sale Id shift 32',0.00,0.00,0.00,2059.84,0.00,'2022-04-19 17:24:19','',''),(687,'21','220','2',1,'Sale Id shift 32',0.00,0.00,0.00,1977.04,0.00,'2022-04-19 17:24:19','',''),(688,'21','220','2',1,'Sale Id shift 32',0.00,0.00,0.00,2778.06,0.00,'2022-04-19 17:24:19','',''),(689,'21','220','2',1,'Sale Id shift 32',0.00,0.00,0.00,1195.85,0.00,'2022-04-19 17:24:19','',''),(690,'21','220','1',1,'Sale Id shift 32',0.00,0.00,0.00,3665.45,0.00,'2022-04-19 17:24:19','',''),(691,'21','220','2',1,'Sale Id shift 32',0.00,0.00,0.00,3450.99,0.00,'2022-04-19 17:24:19','',''),(692,'21','220','1',1,'Sale Id shift 32',0.00,0.00,0.00,6076.11,0.00,'2022-04-19 17:24:19','',''),(693,'21','220',NULL,2,'Sale Id shift 32',3311112.00,0.00,0.00,0.00,0.00,'2022-04-19 17:24:19','',''),(694,'21','220',NULL,3,'Sale Id shift 32',1658893.50,0.00,0.00,0.00,0.00,'2022-04-19 17:24:19','',''),(695,'21','220',NULL,1,'Sale Id shift 32',6313225.05,0.00,0.00,0.00,0.00,'2022-04-19 17:24:19','',''),(696,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 17:27:43','',''),(697,'21','220',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,20000.00,0.00,'2022-04-19 17:29:34','',''),(698,'21','220','2',1,'Received from bridging 84',0.00,0.00,20000.00,0.00,0.00,'2022-04-19 17:29:34','',''),(699,'21','220',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,30000.00,0.00,'2022-04-19 17:29:34','',''),(700,'21','220','1',1,'Received from bridging 83',0.00,0.00,30000.00,0.00,0.00,'2022-04-19 17:29:34','',''),(701,'21','220',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8305000.00,15100.00,0.00,0.00,'2022-04-19 17:30:49','',''),(702,'21','220',NULL,3,'Reception corrector for bridging 85',0.00,0.00,0.00,15100.00,0.00,'2022-04-19 17:31:44','',''),(703,'21','220','4',3,'Received from bridging 85',0.00,0.00,15100.00,0.00,0.00,'2022-04-19 17:31:44','',''),(704,'21','220','1',1,'Sale Id shift 33',0.00,0.00,0.00,4962.93,0.00,'2022-04-19 21:00:16','',''),(705,'21','220','3',2,'Sale Id shift 33',0.00,0.00,0.00,3820.80,0.00,'2022-04-19 21:00:16','',''),(706,'21','220','4',3,'Sale Id shift 33',0.00,0.00,0.00,1842.51,0.00,'2022-04-19 21:00:16','',''),(707,'21','220','1',1,'Sale Id shift 33',0.00,0.00,0.00,5266.22,0.00,'2022-04-19 21:00:16','',''),(708,'21','220','1',1,'Sale Id shift 33',0.00,0.00,0.00,1851.36,0.00,'2022-04-19 21:00:16','',''),(709,'21','220','1',1,'Sale Id shift 33',0.00,0.00,0.00,4942.48,0.00,'2022-04-19 21:00:16','',''),(710,'21','220','1',1,'Sale Id shift 33',0.00,0.00,0.00,4346.19,0.00,'2022-04-19 21:00:16','',''),(711,'21','220','2',1,'Sale Id shift 33',0.00,0.00,0.00,5942.01,0.00,'2022-04-19 21:00:16','',''),(712,'21','220','2',1,'Sale Id shift 33',0.00,0.00,0.00,1905.86,0.00,'2022-04-19 21:00:16','',''),(713,'21','220','2',1,'Sale Id shift 33',0.00,0.00,0.00,2124.24,0.00,'2022-04-19 21:00:16','',''),(714,'21','220','2',1,'Sale Id shift 33',0.00,0.00,0.00,3441.36,0.00,'2022-04-19 21:00:16','',''),(715,'21','220','1',1,'Sale Id shift 33',0.00,0.00,0.00,4342.58,0.00,'2022-04-19 21:00:16','',''),(716,'21','220','2',1,'Sale Id shift 33',0.00,0.00,0.00,2902.98,0.00,'2022-04-19 21:00:16','',''),(717,'21','220','2',1,'Sale Id shift 33',0.00,0.00,0.00,497.44,0.00,'2022-04-19 21:00:16','',''),(718,'21','220','1',1,'Sale Id shift 33',0.00,0.00,0.00,5736.18,0.00,'2022-04-19 21:00:16','',''),(719,'21','220',NULL,1,'Sale Id shift 33',7963201.95,0.00,0.00,0.00,0.00,'2022-04-19 21:00:16','',''),(720,'21','220',NULL,2,'Sale Id shift 33',2674560.00,0.00,0.00,0.00,0.00,'2022-04-19 21:00:16','',''),(721,'21','220',NULL,3,'Sale Id shift 33',1013380.50,0.00,0.00,0.00,0.00,'2022-04-19 21:00:16','',''),(722,'21','220',NULL,1,'Reception corrector for bridging 71',0.00,0.00,0.00,18000.00,0.00,'2022-04-19 21:13:36','',''),(723,'21','220','2',1,'Received from bridging 71',0.00,0.00,18000.00,0.00,0.00,'2022-04-19 21:13:36','',''),(724,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-19 21:22:27','',''),(725,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 21:25:41','',''),(726,'21','220',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,50000.00,0.00,'2022-04-19 21:27:36','',''),(727,'21','220','1',1,'Received from bridging 88',0.00,0.00,50000.00,0.00,0.00,'2022-04-19 21:27:36','',''),(728,'21','220','1',1,'Sale Id shift 34',0.00,0.00,0.00,2730.32,0.00,'2022-04-20 13:37:12','',''),(729,'21','220','3',2,'Sale Id shift 34',0.00,0.00,0.00,2859.12,0.00,'2022-04-20 13:37:12','',''),(730,'21','220','4',3,'Sale Id shift 34',0.00,0.00,0.00,1069.76,0.00,'2022-04-20 13:37:12','',''),(731,'21','220','1',1,'Sale Id shift 34',0.00,0.00,0.00,0.09,0.00,'2022-04-20 13:37:12','',''),(732,'21','220','1',1,'Sale Id shift 34',0.00,0.00,0.00,4147.47,0.00,'2022-04-20 13:37:12','',''),(733,'21','220','1',1,'Sale Id shift 34',0.00,0.00,0.00,3800.17,0.00,'2022-04-20 13:37:12','',''),(734,'21','220','1',1,'Sale Id shift 34',0.00,0.00,0.00,2770.84,0.00,'2022-04-20 13:37:12','',''),(735,'21','220','2',1,'Sale Id shift 34',0.00,0.00,0.00,3327.31,0.00,'2022-04-20 13:37:12','',''),(736,'21','220','2',1,'Sale Id shift 34',0.00,0.00,0.00,3620.76,0.00,'2022-04-20 13:37:12','',''),(737,'21','220','2',1,'Sale Id shift 34',0.00,0.00,0.00,1932.45,0.00,'2022-04-20 13:37:12','',''),(738,'21','220','2',1,'Sale Id shift 34',0.00,0.00,0.00,3060.20,0.00,'2022-04-20 13:37:12','',''),(739,'21','220','2',1,'Sale Id shift 34',0.00,0.00,0.00,2811.90,0.00,'2022-04-20 13:37:12','',''),(740,'21','220','2',1,'Sale Id shift 34',0.00,0.00,0.00,2889.81,0.00,'2022-04-20 13:37:12','',''),(741,'21','220','1',1,'Sale Id shift 34',0.00,0.00,0.00,4659.50,0.00,'2022-04-20 13:37:12','',''),(742,'21','220',NULL,2,'Sale Id shift 34',2001384.00,0.00,0.00,0.00,0.00,'2022-04-20 13:37:12','',''),(743,'21','220',NULL,3,'Sale Id shift 34',588368.00,0.00,0.00,0.00,0.00,'2022-04-20 13:37:12','',''),(744,'21','220',NULL,1,'Sale Id shift 34',5898885.30,0.00,0.00,0.00,0.00,'2022-04-20 13:37:12','',''),(745,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-20 14:16:01','',''),(746,'21','220',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,40000.00,0.00,'2022-04-20 14:17:33','',''),(747,'21','220','1',1,'Received from bridging 89',0.00,0.00,40000.00,0.00,0.00,'2022-04-20 14:17:33','',''),(748,'21','220','1',1,'Sale Id shift 35',0.00,0.00,0.00,6584.05,0.00,'2022-04-20 15:38:47','',''),(749,'21','220','3',2,'Sale Id shift 35',0.00,0.00,0.00,6951.97,0.00,'2022-04-20 15:38:47','',''),(750,'21','220','4',3,'Sale Id shift 35',0.00,0.00,0.00,2894.81,0.00,'2022-04-20 15:38:47','',''),(751,'21','220','1',1,'Sale Id shift 35',0.00,0.00,0.00,927.18,0.00,'2022-04-20 15:38:47','',''),(752,'21','220','1',1,'Sale Id shift 35',0.00,0.00,0.00,6712.26,0.00,'2022-04-20 15:38:47','',''),(753,'21','220','1',1,'Sale Id shift 35',0.00,0.00,0.00,5076.84,0.00,'2022-04-20 15:38:47','',''),(754,'21','220','1',1,'Sale Id shift 35',0.00,0.00,0.00,4880.26,0.00,'2022-04-20 15:38:47','',''),(755,'21','220','2',1,'Sale Id shift 35',0.00,0.00,0.00,2419.74,0.00,'2022-04-20 15:38:47','',''),(756,'21','220','2',1,'Sale Id shift 35',0.00,0.00,0.00,3255.19,0.00,'2022-04-20 15:38:47','',''),(757,'21','220','2',1,'Sale Id shift 35',0.00,0.00,0.00,2971.42,0.00,'2022-04-20 15:38:47','',''),(758,'21','220','2',1,'Sale Id shift 35',0.00,0.00,0.00,2403.04,0.00,'2022-04-20 15:38:47','',''),(759,'21','220','1',1,'Sale Id shift 35',0.00,0.00,0.00,9696.41,0.00,'2022-04-20 15:38:47','',''),(760,'21','220','2',1,'Sale Id shift 35',0.00,0.00,0.00,3693.68,0.00,'2022-04-20 15:38:47','',''),(761,'21','220','2',1,'Sale Id shift 35',0.00,0.00,0.00,2757.28,0.00,'2022-04-20 15:38:47','',''),(762,'21','220','1',1,'Sale Id shift 35',0.00,0.00,0.00,7176.92,0.00,'2022-04-20 15:38:47','',''),(763,'21','220','3',2,'Sale Id shift 35',0.00,0.00,0.00,3534.18,0.00,'2022-04-20 15:38:47','',''),(764,'21','220',NULL,1,'Sale Id shift 35',9661454.55,0.00,0.00,0.00,0.00,'2022-04-20 15:38:48','',''),(765,'21','220',NULL,2,'Sale Id shift 35',7340305.00,0.00,0.00,0.00,0.00,'2022-04-20 15:38:48','',''),(766,'21','220',NULL,3,'Sale Id shift 35',1592145.50,0.00,0.00,0.00,0.00,'2022-04-20 15:38:48','',''),(767,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-20 16:36:22','',''),(768,'21','220',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,30000.00,0.00,'2022-04-20 16:40:16','',''),(769,'21','220','1',1,'Received from bridging 91',0.00,0.00,30000.00,0.00,0.00,'2022-04-20 16:40:16','',''),(770,'21','220','1',1,'Sale Id shift 36',0.00,0.00,0.00,7202.86,0.00,'2022-04-20 17:57:42','',''),(771,'21','220','3',2,'Sale Id shift 36',0.00,0.00,0.00,5643.61,0.00,'2022-04-20 17:57:42','',''),(772,'21','220','4',3,'Sale Id shift 36',0.00,0.00,0.00,1668.28,0.00,'2022-04-20 17:57:42','',''),(773,'21','220','1',1,'Sale Id shift 36',0.00,0.00,0.00,6761.49,0.00,'2022-04-20 17:57:42','',''),(774,'21','220','1',1,'Sale Id shift 36',0.00,0.00,0.00,4586.85,0.00,'2022-04-20 17:57:42','',''),(775,'21','220','1',1,'Sale Id shift 36',0.00,0.00,0.00,5576.01,0.00,'2022-04-20 17:57:42','',''),(776,'21','220','1',1,'Sale Id shift 36',0.00,0.00,0.00,5384.54,0.00,'2022-04-20 17:57:42','',''),(777,'21','220','2',1,'Sale Id shift 36',0.00,0.00,0.00,6349.85,0.00,'2022-04-20 17:57:42','',''),(778,'21','220','2',1,'Sale Id shift 36',0.00,0.00,0.00,3861.62,0.00,'2022-04-20 17:57:42','',''),(779,'21','220','2',1,'Sale Id shift 36',0.00,0.00,0.00,4996.80,0.00,'2022-04-20 17:57:42','',''),(780,'21','220','2',1,'Sale Id shift 36',0.00,0.00,0.00,1980.37,0.00,'2022-04-20 17:57:42','',''),(781,'21','220','1',1,'Sale Id shift 36',0.00,0.00,0.00,5772.61,0.00,'2022-04-20 17:57:42','',''),(782,'21','220','2',1,'Sale Id shift 36',0.00,0.00,0.00,5695.98,0.00,'2022-04-20 17:57:42','',''),(783,'21','220','2',1,'Sale Id shift 36',0.00,0.00,0.00,3405.54,0.00,'2022-04-20 17:57:42','',''),(784,'21','220','1',1,'Sale Id shift 36',0.00,0.00,0.00,8728.08,0.00,'2022-04-20 17:57:42','',''),(785,'21','220',NULL,1,'Sale Id shift 36',11599929.00,0.00,0.00,0.00,0.00,'2022-04-20 17:57:42','',''),(786,'21','220',NULL,2,'Sale Id shift 36',3950527.00,0.00,0.00,0.00,0.00,'2022-04-20 17:57:42','',''),(787,'21','220',NULL,3,'Sale Id shift 36',917554.00,0.00,0.00,0.00,0.00,'2022-04-20 17:57:42','',''),(788,'21','220',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,45000.00,0.00,'2022-04-20 18:14:19','',''),(789,'21','220','2',1,'Received from bridging 87',0.00,0.00,45000.00,0.00,0.00,'2022-04-20 18:14:19','',''),(790,'21','220',NULL,1,'Reception corrector for bridging 92',0.00,0.00,0.00,15000.00,0.00,'2022-04-20 18:14:50','',''),(791,'21','220','2',1,'Received from bridging 92',0.00,0.00,15000.00,0.00,0.00,'2022-04-20 18:14:50','',''),(792,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-21 17:08:39','',''),(793,'21','220',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,33000.00,0.00,'2022-04-21 17:10:44','',''),(794,'21','220','1',1,'Received from bridging 93',0.00,0.00,33000.00,0.00,0.00,'2022-04-21 17:10:44','',''),(795,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9450000.00,13500.00,0.00,0.00,'2022-04-21 17:16:38','',''),(796,'21','220',NULL,2,'Reception corrector for bridging 96',0.00,0.00,0.00,13500.00,0.00,'2022-04-21 17:20:28','',''),(797,'21','220','3',2,'Received from bridging 96',0.00,0.00,13500.00,0.00,0.00,'2022-04-21 17:20:28','',''),(798,'21','220','1',1,'Sale Id shift 37',0.00,0.00,0.00,6610.66,0.00,'2022-04-21 19:51:03','',''),(799,'21','220','3',2,'Sale Id shift 37',0.00,0.00,0.00,214.28,0.00,'2022-04-21 19:51:03','',''),(800,'21','220','4',3,'Sale Id shift 37',0.00,0.00,0.00,4540.37,0.00,'2022-04-21 19:51:03','',''),(801,'21','220','1',1,'Sale Id shift 37',0.00,0.00,0.00,6048.97,0.00,'2022-04-21 19:51:03','',''),(802,'21','220','1',1,'Sale Id shift 37',0.00,0.00,0.00,4054.82,0.00,'2022-04-21 19:51:03','',''),(803,'21','220','1',1,'Sale Id shift 37',0.00,0.00,0.00,5128.95,0.00,'2022-04-21 19:51:03','',''),(804,'21','220','1',1,'Sale Id shift 37',0.00,0.00,0.00,5213.01,0.00,'2022-04-21 19:51:03','',''),(805,'21','220','2',1,'Sale Id shift 37',0.00,0.00,0.00,4423.74,0.00,'2022-04-21 19:51:03','',''),(806,'21','220','2',1,'Sale Id shift 37',0.00,0.00,0.00,4962.36,0.00,'2022-04-21 19:51:03','',''),(807,'21','220','2',1,'Sale Id shift 37',0.00,0.00,0.00,4553.86,0.00,'2022-04-21 19:51:03','',''),(808,'21','220','2',1,'Sale Id shift 37',0.00,0.00,0.00,2912.63,0.00,'2022-04-21 19:51:03','',''),(809,'21','220','1',1,'Sale Id shift 37',0.00,0.00,0.00,5963.33,0.00,'2022-04-21 19:51:03','',''),(810,'21','220','2',1,'Sale Id shift 37',0.00,0.00,0.00,4337.46,0.00,'2022-04-21 19:51:03','',''),(811,'21','220','2',1,'Sale Id shift 37',0.00,0.00,0.00,3095.49,0.00,'2022-04-21 19:51:03','',''),(812,'21','220','1',1,'Sale Id shift 37',0.00,0.00,0.00,6964.81,0.00,'2022-04-21 19:51:03','',''),(813,'21','220',NULL,1,'Sale Id shift 37',10604564.85,0.00,0.00,0.00,0.00,'2022-04-21 19:51:03','',''),(814,'21','220',NULL,2,'Sale Id shift 37',149996.00,0.00,0.00,0.00,0.00,'2022-04-21 19:51:03','',''),(815,'21','220',NULL,3,'Sale Id shift 37',2497203.50,0.00,0.00,0.00,0.00,'2022-04-21 19:51:03','',''),(816,'21','220',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,20000.00,0.00,'2022-04-21 19:52:57','',''),(817,'21','220','2',1,'Received from bridging 90',0.00,0.00,20000.00,0.00,0.00,'2022-04-21 19:52:57','',''),(818,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-22 16:07:47','',''),(819,'21','220',NULL,1,'Reception corrector for bridging 97',0.00,0.00,0.00,33000.00,0.00,'2022-04-22 16:09:23','',''),(820,'21','220','1',1,'Received from bridging 97',0.00,0.00,33000.00,0.00,0.00,'2022-04-22 16:09:23','',''),(821,'21','220',NULL,1,'Reception corrector for bridging 99',0.00,0.00,0.00,5000.00,0.00,'2022-04-22 18:12:02','',''),(822,'21','220','1',1,'Received from bridging 99',0.00,0.00,5000.00,0.00,0.00,'2022-04-22 18:12:02','',''),(823,'21','220','1',1,'Returned bridging 99',0.00,0.00,0.00,5000.00,0.00,'2022-04-22 18:13:03','',''),(824,'21','220',NULL,1,'Reception Return corrector for bridging 99',0.00,0.00,5000.00,0.00,0.00,'2022-04-22 18:13:03','',''),(825,'21','220',NULL,1,'Reception corrector for bridging 100',0.00,0.00,0.00,500.00,0.00,'2022-04-22 18:16:02','',''),(826,'21','220','1',1,'Received from bridging 100',0.00,0.00,500.00,0.00,0.00,'2022-04-22 18:16:02','',''),(827,'21','220','1',1,'Sale Id shift 38',0.00,0.00,0.00,7461.62,0.00,'2022-04-23 16:25:12','',''),(828,'21','220','3',2,'Sale Id shift 38',0.00,0.00,0.00,1390.57,0.00,'2022-04-23 16:25:12','',''),(829,'21','220','4',3,'Sale Id shift 38',0.00,0.00,0.00,2029.73,0.00,'2022-04-23 16:25:12','',''),(830,'21','220','1',1,'Sale Id shift 38',0.00,0.00,0.00,4318.49,0.00,'2022-04-23 16:25:12','',''),(831,'21','220','1',1,'Sale Id shift 38',0.00,0.00,0.00,6510.44,0.00,'2022-04-23 16:25:12','',''),(832,'21','220','1',1,'Sale Id shift 38',0.00,0.00,0.00,4035.21,0.00,'2022-04-23 16:25:12','',''),(833,'21','220','2',1,'Sale Id shift 38',0.00,0.00,0.00,6517.23,0.00,'2022-04-23 16:25:12','',''),(834,'21','220','2',1,'Sale Id shift 38',0.00,0.00,0.00,4218.57,0.00,'2022-04-23 16:25:12','',''),(835,'21','220','2',1,'Sale Id shift 38',0.00,0.00,0.00,4688.09,0.00,'2022-04-23 16:25:12','',''),(836,'21','220','2',1,'Sale Id shift 38',0.00,0.00,0.00,4769.12,0.00,'2022-04-23 16:25:12','',''),(837,'21','220','1',1,'Sale Id shift 38',0.00,0.00,0.00,6136.04,0.00,'2022-04-23 16:25:12','',''),(838,'21','220','2',1,'Sale Id shift 38',0.00,0.00,0.00,2952.60,0.00,'2022-04-23 16:25:12','',''),(839,'21','220','2',1,'Sale Id shift 38',0.00,0.00,0.00,3197.11,0.00,'2022-04-23 16:25:12','',''),(840,'21','220','1',1,'Sale Id shift 38',0.00,0.00,0.00,7575.69,0.00,'2022-04-23 16:25:12','',''),(841,'21','220',NULL,2,'Sale Id shift 38',973399.00,0.00,0.00,0.00,0.00,'2022-04-23 16:25:13','',''),(842,'21','220',NULL,3,'Sale Id shift 38',1116351.50,0.00,0.00,0.00,0.00,'2022-04-23 16:25:13','',''),(843,'21','220',NULL,1,'Sale Id shift 38',10292734.65,0.00,0.00,0.00,0.00,'2022-04-23 16:25:13','',''),(844,'21','220',NULL,1,'Reception corrector for bridging 94',0.00,0.00,0.00,17000.00,0.00,'2022-04-23 16:26:06','',''),(845,'21','220','2',1,'Received from bridging 94',0.00,0.00,17000.00,0.00,0.00,'2022-04-23 16:26:06','',''),(846,'21','220',NULL,1,'Reception corrector for bridging 101',0.00,0.00,0.00,16500.00,0.00,'2022-04-23 16:28:03','',''),(847,'21','220','2',1,'Received from bridging 101',0.00,0.00,16500.00,0.00,0.00,'2022-04-23 16:28:03','',''),(848,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-23 20:15:02','',''),(849,'21','220',NULL,1,'Reception corrector for bridging 102',0.00,0.00,0.00,30000.00,0.00,'2022-04-23 20:19:07','',''),(850,'21','220','1',1,'Received from bridging 102',0.00,0.00,30000.00,0.00,0.00,'2022-04-23 20:19:07','',''),(851,'21','220','1',1,'Sale Id shift 39',0.00,0.00,0.00,5686.31,0.00,'2022-04-23 21:16:05','',''),(852,'21','220','3',2,'Sale Id shift 39',0.00,0.00,0.00,3156.33,0.00,'2022-04-23 21:16:05','',''),(853,'21','220','4',3,'Sale Id shift 39',0.00,0.00,0.00,1401.12,0.00,'2022-04-23 21:16:05','',''),(854,'21','220','1',1,'Sale Id shift 39',0.00,0.00,0.00,11898.88,0.00,'2022-04-23 21:16:05','',''),(855,'21','220','1',1,'Sale Id shift 39',0.00,0.00,0.00,3237.46,0.00,'2022-04-23 21:16:05','',''),(856,'21','220','1',1,'Sale Id shift 39',0.00,0.00,0.00,4268.83,0.00,'2022-04-23 21:16:05','',''),(857,'21','220','1',1,'Sale Id shift 39',0.00,0.00,0.00,4258.56,0.00,'2022-04-23 21:16:05','',''),(858,'21','220','2',1,'Sale Id shift 39',0.00,0.00,0.00,7526.57,0.00,'2022-04-23 21:16:05','',''),(859,'21','220','2',1,'Sale Id shift 39',0.00,0.00,0.00,4374.21,0.00,'2022-04-23 21:16:05','',''),(860,'21','220','2',1,'Sale Id shift 39',0.00,0.00,0.00,4055.53,0.00,'2022-04-23 21:16:05','',''),(861,'21','220','2',1,'Sale Id shift 39',0.00,0.00,0.00,5158.65,0.00,'2022-04-23 21:16:05','',''),(862,'21','220','1',1,'Sale Id shift 39',0.00,0.00,0.00,6399.70,0.00,'2022-04-23 21:16:05','',''),(863,'21','220','2',1,'Sale Id shift 39',0.00,0.00,0.00,5991.11,0.00,'2022-04-23 21:16:05','',''),(864,'21','220','2',1,'Sale Id shift 39',0.00,0.00,0.00,3032.69,0.00,'2022-04-23 21:16:05','',''),(865,'21','220','3',2,'Sale Id shift 39',0.00,0.00,0.00,1524.92,0.00,'2022-04-23 21:16:05','',''),(866,'21','220',NULL,2,'Sale Id shift 39',3276875.00,0.00,0.00,0.00,0.00,'2022-04-23 21:16:05','',''),(867,'21','220',NULL,3,'Sale Id shift 39',770616.00,0.00,0.00,0.00,0.00,'2022-04-23 21:16:05','',''),(868,'21','220',NULL,1,'Sale Id shift 39',10871602.50,0.00,0.00,0.00,0.00,'2022-04-23 21:16:05','',''),(869,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-24 19:40:38','',''),(870,'21','220',NULL,1,'Reception corrector for bridging 104',0.00,0.00,0.00,40000.00,0.00,'2022-04-24 19:44:22','',''),(871,'21','220','1',1,'Received from bridging 104',0.00,0.00,40000.00,0.00,0.00,'2022-04-24 19:44:22','',''),(872,'21','220',NULL,1,'Reception corrector for bridging 103',0.00,0.00,0.00,20000.00,0.00,'2022-04-24 19:45:10','',''),(873,'21','220','2',1,'Received from bridging 103',0.00,0.00,20000.00,0.00,0.00,'2022-04-24 19:45:10','',''),(874,'21','220','1',1,'Sale Id shift 40',0.00,0.00,0.00,4015.88,0.00,'2022-04-24 21:31:05','',''),(875,'21','220','3',2,'Sale Id shift 40',0.00,0.00,0.00,3202.45,0.00,'2022-04-24 21:31:05','',''),(876,'21','220','4',3,'Sale Id shift 40',0.00,0.00,0.00,2649.84,0.00,'2022-04-24 21:31:05','',''),(877,'21','220','1',1,'Sale Id shift 40',0.00,0.00,0.00,4883.59,0.00,'2022-04-24 21:31:05','',''),(878,'21','220','1',1,'Sale Id shift 40',0.00,0.00,0.00,3068.95,0.00,'2022-04-24 21:31:05','',''),(879,'21','220','1',1,'Sale Id shift 40',0.00,0.00,0.00,3317.02,0.00,'2022-04-24 21:31:05','',''),(880,'21','220','1',1,'Sale Id shift 40',0.00,0.00,0.00,3542.85,0.00,'2022-04-24 21:31:05','',''),(881,'21','220','2',1,'Sale Id shift 40',0.00,0.00,0.00,3842.71,0.00,'2022-04-24 21:31:05','',''),(882,'21','220','2',1,'Sale Id shift 40',0.00,0.00,0.00,1665.78,0.00,'2022-04-24 21:31:05','',''),(883,'21','220','2',1,'Sale Id shift 40',0.00,0.00,0.00,2921.79,0.00,'2022-04-24 21:31:05','',''),(884,'21','220','2',1,'Sale Id shift 40',0.00,0.00,0.00,2265.09,0.00,'2022-04-24 21:31:05','',''),(885,'21','220','1',1,'Sale Id shift 40',0.00,0.00,0.00,3865.67,0.00,'2022-04-24 21:31:05','',''),(886,'21','220','2',1,'Sale Id shift 40',0.00,0.00,0.00,3394.60,0.00,'2022-04-24 21:31:05','',''),(887,'21','220','2',1,'Sale Id shift 40',0.00,0.00,0.00,2392.57,0.00,'2022-04-24 21:31:05','',''),(888,'21','220','1',1,'Sale Id shift 40',0.00,0.00,0.00,13185.14,0.00,'2022-04-24 21:31:05','',''),(889,'21','220',NULL,2,'Sale Id shift 40',2241715.00,0.00,0.00,0.00,0.00,'2022-04-24 21:31:05','',''),(890,'21','220',NULL,3,'Sale Id shift 40',1457412.00,0.00,0.00,0.00,0.00,'2022-04-24 21:31:05','',''),(891,'21','220',NULL,1,'Sale Id shift 40',8639670.60,0.00,0.00,0.00,0.00,'2022-04-24 21:31:05','',''),(892,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-25 20:06:55','',''),(893,'21','220',NULL,1,'Reception corrector for bridging 106',0.00,0.00,0.00,40000.00,0.00,'2022-04-25 20:09:01','',''),(894,'21','220','1',1,'Received from bridging 106',0.00,0.00,40000.00,0.00,0.00,'2022-04-25 20:09:01','',''),(895,'21','220',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,20000.00,0.00,'2022-04-25 20:09:36','',''),(896,'21','220','2',1,'Received from bridging 105',0.00,0.00,20000.00,0.00,0.00,'2022-04-25 20:09:36','',''),(897,'21','220','1',1,'Sale Id shift 41',0.00,0.00,0.00,3560.22,0.00,'2022-04-26 17:57:45','',''),(898,'21','220','3',2,'Sale Id shift 41',0.00,0.00,0.00,1280.05,0.00,'2022-04-26 17:57:45','',''),(899,'21','220','4',3,'Sale Id shift 41',0.00,0.00,0.00,925.05,0.00,'2022-04-26 17:57:45','',''),(900,'21','220','1',1,'Sale Id shift 41',0.00,0.00,0.00,4704.62,0.00,'2022-04-26 17:57:45','',''),(901,'21','220','1',1,'Sale Id shift 41',0.00,0.00,0.00,3315.03,0.00,'2022-04-26 17:57:45','',''),(902,'21','220','1',1,'Sale Id shift 41',0.00,0.00,0.00,3716.90,0.00,'2022-04-26 17:57:45','',''),(903,'21','220','1',1,'Sale Id shift 41',0.00,0.00,0.00,3416.16,0.00,'2022-04-26 17:57:45','',''),(904,'21','220','2',1,'Sale Id shift 41',0.00,0.00,0.00,2895.40,0.00,'2022-04-26 17:57:45','',''),(905,'21','220','2',1,'Sale Id shift 41',0.00,0.00,0.00,2202.03,0.00,'2022-04-26 17:57:45','',''),(906,'21','220','2',1,'Sale Id shift 41',0.00,0.00,0.00,2158.56,0.00,'2022-04-26 17:57:45','',''),(907,'21','220','2',1,'Sale Id shift 41',0.00,0.00,0.00,2546.38,0.00,'2022-04-26 17:57:45','',''),(908,'21','220','1',1,'Sale Id shift 41',0.00,0.00,0.00,4715.03,0.00,'2022-04-26 17:57:45','',''),(909,'21','220','2',1,'Sale Id shift 41',0.00,0.00,0.00,2982.08,0.00,'2022-04-26 17:57:45','',''),(910,'21','220','2',1,'Sale Id shift 41',0.00,0.00,0.00,2270.54,0.00,'2022-04-26 17:57:45','',''),(911,'21','220','1',1,'Sale Id shift 41',0.00,0.00,0.00,4266.99,0.00,'2022-04-26 17:57:45','',''),(912,'21','220','3',2,'Sale Id shift 41',0.00,0.00,0.00,3750.09,0.00,'2022-04-26 17:57:45','',''),(913,'21','220',NULL,1,'Sale Id shift 41',7053740.10,0.00,0.00,0.00,0.00,'2022-04-26 17:57:45','',''),(914,'21','220',NULL,2,'Sale Id shift 41',3521098.00,0.00,0.00,0.00,0.00,'2022-04-26 17:57:45','',''),(915,'21','220',NULL,3,'Sale Id shift 41',508777.50,0.00,0.00,0.00,0.00,'2022-04-26 17:57:45','',''),(916,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-26 19:51:32','',''),(917,'21','220',NULL,1,'Reception corrector for bridging 108',0.00,0.00,0.00,30000.00,0.00,'2022-04-26 19:53:58','',''),(918,'21','220','1',1,'Received from bridging 108',0.00,0.00,30000.00,0.00,0.00,'2022-04-26 19:53:58','',''),(919,'21','220',NULL,1,'Reception corrector for bridging 107',0.00,0.00,0.00,20000.00,0.00,'2022-04-26 19:55:08','',''),(920,'21','220','2',1,'Received from bridging 107',0.00,0.00,20000.00,0.00,0.00,'2022-04-26 19:55:08','',''),(921,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-28 10:06:39','',''),(922,'21','220',NULL,1,'Reception corrector for bridging 110',0.00,0.00,0.00,33500.00,0.00,'2022-04-28 10:08:39','',''),(923,'21','220','1',1,'Received from bridging 110',0.00,0.00,33500.00,0.00,0.00,'2022-04-28 10:08:39','',''),(924,'21','220','1',1,'Sale Id shift 42',0.00,0.00,0.00,4690.93,0.00,'2022-04-28 10:09:16','',''),(925,'21','220','3',2,'Sale Id shift 42',0.00,0.00,0.00,1500.10,0.00,'2022-04-28 10:09:16','',''),(926,'21','220','4',3,'Sale Id shift 42',0.00,0.00,0.00,2311.12,0.00,'2022-04-28 10:09:16','',''),(927,'21','220','1',1,'Sale Id shift 42',0.00,0.00,0.00,6779.39,0.00,'2022-04-28 10:09:16','',''),(928,'21','220','1',1,'Sale Id shift 42',0.00,0.00,0.00,5111.33,0.00,'2022-04-28 10:09:16','',''),(929,'21','220','1',1,'Sale Id shift 42',0.00,0.00,0.00,6661.13,0.00,'2022-04-28 10:09:16','',''),(930,'21','220','1',1,'Sale Id shift 42',0.00,0.00,0.00,5198.34,0.00,'2022-04-28 10:09:16','',''),(931,'21','220','2',1,'Sale Id shift 42',0.00,0.00,0.00,4701.00,0.00,'2022-04-28 10:09:16','',''),(932,'21','220','2',1,'Sale Id shift 42',0.00,0.00,0.00,4357.94,0.00,'2022-04-28 10:09:16','',''),(933,'21','220','2',1,'Sale Id shift 42',0.00,0.00,0.00,3825.45,0.00,'2022-04-28 10:09:16','',''),(934,'21','220','2',1,'Sale Id shift 42',0.00,0.00,0.00,2604.18,0.00,'2022-04-28 10:09:16','',''),(935,'21','220','1',1,'Sale Id shift 42',0.00,0.00,0.00,5419.49,0.00,'2022-04-28 10:09:16','',''),(936,'21','220','2',1,'Sale Id shift 42',0.00,0.00,0.00,4561.38,0.00,'2022-04-28 10:09:16','',''),(937,'21','220','2',1,'Sale Id shift 42',0.00,0.00,0.00,3923.36,0.00,'2022-04-28 10:09:16','',''),(938,'21','220','1',1,'Sale Id shift 42',0.00,0.00,0.00,7571.63,0.00,'2022-04-28 10:09:16','',''),(939,'21','220',NULL,1,'Sale Id shift 42',10791915.75,0.00,0.00,0.00,0.00,'2022-04-28 10:09:16','',''),(940,'21','220',NULL,2,'Sale Id shift 42',1050070.00,0.00,0.00,0.00,0.00,'2022-04-28 10:09:16','',''),(941,'21','220',NULL,3,'Sale Id shift 42',1271116.00,0.00,0.00,0.00,0.00,'2022-04-28 10:09:16','',''),(942,'21','220',NULL,1,'Reception corrector for bridging 111',0.00,0.00,0.00,16500.00,0.00,'2022-04-28 10:09:48','',''),(943,'21','220','2',1,'Received from bridging 111',0.00,0.00,16500.00,0.00,0.00,'2022-04-28 10:09:48','',''),(944,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-28 16:59:52','',''),(945,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,10500000.00,15000.00,0.00,0.00,'2022-04-28 20:07:16','',''),(946,'21','220',NULL,2,'Reception corrector for bridging 114',0.00,0.00,0.00,15000.00,0.00,'2022-04-28 20:08:41','',''),(947,'21','220','3',2,'Received from bridging 114',0.00,0.00,15000.00,0.00,0.00,'2022-04-28 20:08:41','',''),(948,'21','220','1',1,'Sale Id shift 43',0.00,0.00,0.00,6761.80,0.00,'2022-04-28 20:24:55','',''),(949,'21','220','3',2,'Sale Id shift 43',0.00,0.00,0.00,2350.41,0.00,'2022-04-28 20:24:55','',''),(950,'21','220','4',3,'Sale Id shift 43',0.00,0.00,0.00,2574.90,0.00,'2022-04-28 20:24:55','',''),(951,'21','220','1',1,'Sale Id shift 43',0.00,0.00,0.00,5919.96,0.00,'2022-04-28 20:24:55','',''),(952,'21','220','1',1,'Sale Id shift 43',0.00,0.00,0.00,4756.15,0.00,'2022-04-28 20:24:55','',''),(953,'21','220','1',1,'Sale Id shift 43',0.00,0.00,0.00,4898.18,0.00,'2022-04-28 20:24:55','',''),(954,'21','220','1',1,'Sale Id shift 43',0.00,0.00,0.00,6028.49,0.00,'2022-04-28 20:24:55','',''),(955,'21','220','2',1,'Sale Id shift 43',0.00,0.00,0.00,4920.99,0.00,'2022-04-28 20:24:55','',''),(956,'21','220','2',1,'Sale Id shift 43',0.00,0.00,0.00,2652.13,0.00,'2022-04-28 20:24:55','',''),(957,'21','220','2',1,'Sale Id shift 43',0.00,0.00,0.00,3819.79,0.00,'2022-04-28 20:24:55','',''),(958,'21','220','2',1,'Sale Id shift 43',0.00,0.00,0.00,3417.42,0.00,'2022-04-28 20:24:55','',''),(959,'21','220','1',1,'Sale Id shift 43',0.00,0.00,0.00,3914.56,0.00,'2022-04-28 20:24:55','',''),(960,'21','220','2',1,'Sale Id shift 43',0.00,0.00,0.00,3982.73,0.00,'2022-04-28 20:24:55','',''),(961,'21','220','2',1,'Sale Id shift 43',0.00,0.00,0.00,3194.74,0.00,'2022-04-28 20:24:55','',''),(962,'21','220','1',1,'Sale Id shift 43',0.00,0.00,0.00,8746.23,0.00,'2022-04-28 20:24:55','',''),(963,'21','220','3',2,'Sale Id shift 43',0.00,0.00,0.00,765.29,0.00,'2022-04-28 20:24:55','',''),(964,'21','220',NULL,2,'Sale Id shift 43',2180990.00,0.00,0.00,0.00,0.00,'2022-04-28 20:24:55','',''),(965,'21','220',NULL,3,'Sale Id shift 43',1416195.00,0.00,0.00,0.00,0.00,'2022-04-28 20:24:55','',''),(966,'21','220',NULL,1,'Sale Id shift 43',10397173.05,0.00,0.00,0.00,0.00,'2022-04-28 20:24:55','',''),(967,'21','220',NULL,1,'Reception corrector for bridging 109',0.00,0.00,0.00,30000.00,0.00,'2022-04-28 20:25:45','',''),(968,'21','220','2',1,'Received from bridging 109',0.00,0.00,30000.00,0.00,0.00,'2022-04-28 20:25:45','',''),(969,'21','220',NULL,1,'Reception corrector for bridging 112',0.00,0.00,0.00,30000.00,0.00,'2022-04-28 20:26:40','',''),(970,'21','220','1',1,'Received from bridging 112',0.00,0.00,30000.00,0.00,0.00,'2022-04-28 20:26:40','',''),(971,'21','220','1',1,'Sale Id shift 45',0.00,0.00,0.00,4075.63,0.00,'2022-04-29 13:10:04','',''),(972,'21','220','3',2,'Sale Id shift 45',0.00,0.00,0.00,4622.37,0.00,'2022-04-29 13:10:04','',''),(973,'21','220','4',3,'Sale Id shift 45',0.00,0.00,0.00,2385.28,0.00,'2022-04-29 13:10:04','',''),(974,'21','220','1',1,'Sale Id shift 45',0.00,0.00,0.00,3678.18,0.00,'2022-04-29 13:10:04','',''),(975,'21','220','1',1,'Sale Id shift 45',0.00,0.00,0.00,4295.68,0.00,'2022-04-29 13:10:04','',''),(976,'21','220','1',1,'Sale Id shift 45',0.00,0.00,0.00,5238.43,0.00,'2022-04-29 13:10:04','',''),(977,'21','220','1',1,'Sale Id shift 45',0.00,0.00,0.00,4950.39,0.00,'2022-04-29 13:10:04','',''),(978,'21','220','2',1,'Sale Id shift 45',0.00,0.00,0.00,6704.48,0.00,'2022-04-29 13:10:04','',''),(979,'21','220','2',1,'Sale Id shift 45',0.00,0.00,0.00,2696.46,0.00,'2022-04-29 13:10:04','',''),(980,'21','220','2',1,'Sale Id shift 45',0.00,0.00,0.00,3582.38,0.00,'2022-04-29 13:10:04','',''),(981,'21','220','2',1,'Sale Id shift 45',0.00,0.00,0.00,4228.44,0.00,'2022-04-29 13:10:04','',''),(982,'21','220','1',1,'Sale Id shift 45',0.00,0.00,0.00,4650.47,0.00,'2022-04-29 13:10:04','',''),(983,'21','220','2',1,'Sale Id shift 45',0.00,0.00,0.00,4457.50,0.00,'2022-04-29 13:10:04','',''),(984,'21','220','2',1,'Sale Id shift 45',0.00,0.00,0.00,3338.04,0.00,'2022-04-29 13:10:04','',''),(985,'21','220','1',1,'Sale Id shift 45',0.00,0.00,0.00,6723.62,0.00,'2022-04-29 13:10:04','',''),(986,'21','220',NULL,1,'Sale Id shift 45',9672250.50,0.00,0.00,0.00,0.00,'2022-04-29 13:10:04','',''),(987,'21','220',NULL,2,'Sale Id shift 45',3235659.00,0.00,0.00,0.00,0.00,'2022-04-29 13:10:04','',''),(988,'21','220',NULL,3,'Sale Id shift 45',1311904.00,0.00,0.00,0.00,0.00,'2022-04-29 13:10:04','',''),(989,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-29 17:48:00','',''),(990,'21','220',NULL,1,'Reception corrector for bridging 115',0.00,0.00,0.00,28500.00,0.00,'2022-04-29 17:50:27','',''),(991,'21','220','1',1,'Received from bridging 115',0.00,0.00,28500.00,0.00,0.00,'2022-04-29 17:50:27','',''),(992,'21','220',NULL,1,'Reception corrector for bridging 113',0.00,0.00,0.00,20000.00,0.00,'2022-04-29 17:50:50','',''),(993,'21','220','2',1,'Received from bridging 113',0.00,0.00,20000.00,0.00,0.00,'2022-04-29 17:50:50','',''),(994,'21','220',NULL,1,'Reception corrector for bridging 117',0.00,0.00,0.00,8000.00,0.00,'2022-04-29 21:23:28','',''),(995,'21','220','1',1,'Received from bridging 117',0.00,0.00,8000.00,0.00,0.00,'2022-04-29 21:23:28','',''),(996,'21','220','1',1,'Sale Id shift 46',0.00,0.00,0.00,5498.18,0.00,'2022-04-30 10:02:30','',''),(997,'21','220','3',2,'Sale Id shift 46',0.00,0.00,0.00,3017.75,0.00,'2022-04-30 10:02:30','',''),(998,'21','220','1',1,'Sale Id shift 46',0.00,0.00,0.00,0.22,0.00,'2022-04-30 10:02:30','',''),(999,'21','220','1',1,'Sale Id shift 46',0.00,0.00,0.00,7462.83,0.00,'2022-04-30 10:02:30','',''),(1000,'21','220','1',1,'Sale Id shift 46',0.00,0.00,0.00,5278.94,0.00,'2022-04-30 10:02:30','',''),(1001,'21','220','1',1,'Sale Id shift 46',0.00,0.00,0.00,5782.97,0.00,'2022-04-30 10:02:30','',''),(1002,'21','220','2',1,'Sale Id shift 46',0.00,0.00,0.00,5007.98,0.00,'2022-04-30 10:02:30','',''),(1003,'21','220','2',1,'Sale Id shift 46',0.00,0.00,0.00,4135.63,0.00,'2022-04-30 10:02:30','',''),(1004,'21','220','2',1,'Sale Id shift 46',0.00,0.00,0.00,3084.41,0.00,'2022-04-30 10:02:30','',''),(1005,'21','220','2',1,'Sale Id shift 46',0.00,0.00,0.00,2435.84,0.00,'2022-04-30 10:02:30','',''),(1006,'21','220','1',1,'Sale Id shift 46',0.00,0.00,0.00,4725.66,0.00,'2022-04-30 10:02:30','',''),(1007,'21','220','2',1,'Sale Id shift 46',0.00,0.00,0.00,3856.00,0.00,'2022-04-30 10:02:30','',''),(1008,'21','220','2',1,'Sale Id shift 46',0.00,0.00,0.00,3452.55,0.00,'2022-04-30 10:02:30','',''),(1009,'21','220','1',1,'Sale Id shift 46',0.00,0.00,0.00,7335.91,0.00,'2022-04-30 10:02:30','',''),(1010,'21','220','3',2,'Sale Id shift 46',0.00,0.00,0.00,2083.06,0.00,'2022-04-30 10:02:30','',''),(1011,'21','220',NULL,2,'Sale Id shift 46',3570567.00,0.00,0.00,0.00,0.00,'2022-04-30 10:02:30','',''),(1012,'21','220',NULL,1,'Sale Id shift 46',9579424.80,0.00,0.00,0.00,0.00,'2022-04-30 10:02:30','',''),(1013,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-30 16:41:06','',''),(1014,'21','220',NULL,1,'Reception corrector for bridging 118',0.00,0.00,0.00,26000.00,0.00,'2022-04-30 16:43:02','',''),(1015,'21','220','1',1,'Received from bridging 118',0.00,0.00,26000.00,0.00,0.00,'2022-04-30 16:43:02','',''),(1016,'21','220',NULL,1,'Reception corrector for bridging 121',0.00,0.00,0.00,8500.00,0.00,'2022-04-30 16:51:00','',''),(1017,'21','220','2',1,'Received from bridging 121',0.00,0.00,8500.00,0.00,0.00,'2022-04-30 16:51:00','',''),(1018,'21','220','1',1,'Sale Id shift 47',0.00,0.00,0.00,4202.62,0.00,'2022-04-30 23:00:45','',''),(1019,'21','220','3',2,'Sale Id shift 47',0.00,0.00,0.00,328.60,0.00,'2022-04-30 23:00:45','',''),(1020,'21','220','1',1,'Sale Id shift 47',0.00,0.00,0.00,0.21,0.00,'2022-04-30 23:00:45','',''),(1021,'21','220','1',1,'Sale Id shift 47',0.00,0.00,0.00,4842.36,0.00,'2022-04-30 23:00:45','',''),(1022,'21','220','1',1,'Sale Id shift 47',0.00,0.00,0.00,4033.50,0.00,'2022-04-30 23:00:45','',''),(1023,'21','220','1',1,'Sale Id shift 47',0.00,0.00,0.00,3678.27,0.00,'2022-04-30 23:00:45','',''),(1024,'21','220','2',1,'Sale Id shift 47',0.00,0.00,0.00,4376.22,0.00,'2022-04-30 23:00:45','',''),(1025,'21','220','2',1,'Sale Id shift 47',0.00,0.00,0.00,3263.43,0.00,'2022-04-30 23:00:45','',''),(1026,'21','220','2',1,'Sale Id shift 47',0.00,0.00,0.00,2424.56,0.00,'2022-04-30 23:00:45','',''),(1027,'21','220','2',1,'Sale Id shift 47',0.00,0.00,0.00,2490.78,0.00,'2022-04-30 23:00:45','',''),(1028,'21','220','1',1,'Sale Id shift 47',0.00,0.00,0.00,4836.48,0.00,'2022-04-30 23:00:45','',''),(1029,'21','220','2',1,'Sale Id shift 47',0.00,0.00,0.00,2926.00,0.00,'2022-04-30 23:00:45','',''),(1030,'21','220','2',1,'Sale Id shift 47',0.00,0.00,0.00,3271.45,0.00,'2022-04-30 23:00:45','',''),(1031,'21','220','1',1,'Sale Id shift 47',0.00,0.00,0.00,5226.05,0.00,'2022-04-30 23:00:45','',''),(1032,'21','220',NULL,2,'Sale Id shift 47',230020.00,0.00,0.00,0.00,0.00,'2022-04-30 23:00:45','',''),(1033,'21','220',NULL,1,'Sale Id shift 47',7519368.45,0.00,0.00,0.00,0.00,'2022-04-30 23:00:45','',''),(1034,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-01 20:09:11','',''),(1035,'21','220',NULL,1,'Reception corrector for bridging 123',0.00,0.00,0.00,15000.00,0.00,'2022-05-01 20:11:01','',''),(1036,'21','220','2',1,'Received from bridging 123',0.00,0.00,15000.00,0.00,0.00,'2022-05-01 20:11:01','',''),(1037,'21','220',NULL,1,'Reception corrector for bridging 122',0.00,0.00,0.00,30000.00,0.00,'2022-05-01 20:11:01','',''),(1038,'21','220','1',1,'Received from bridging 122',0.00,0.00,30000.00,0.00,0.00,'2022-05-01 20:11:01','',''),(1039,'21','220','1',1,'Sale Id shift 48',0.00,0.00,0.00,4547.05,0.00,'2022-05-02 20:43:07','',''),(1040,'21','220','1',1,'Sale Id shift 48',0.00,0.00,0.00,6233.31,0.00,'2022-05-02 20:43:07','',''),(1041,'21','220','1',1,'Sale Id shift 48',0.00,0.00,0.00,4025.09,0.00,'2022-05-02 20:43:07','',''),(1042,'21','220','1',1,'Sale Id shift 48',0.00,0.00,0.00,3683.35,0.00,'2022-05-02 20:43:07','',''),(1043,'21','220','2',1,'Sale Id shift 48',0.00,0.00,0.00,2354.68,0.00,'2022-05-02 20:43:07','',''),(1044,'21','220','2',1,'Sale Id shift 48',0.00,0.00,0.00,3798.80,0.00,'2022-05-02 20:43:07','',''),(1045,'21','220','2',1,'Sale Id shift 48',0.00,0.00,0.00,2549.12,0.00,'2022-05-02 20:43:07','',''),(1046,'21','220','2',1,'Sale Id shift 48',0.00,0.00,0.00,1748.27,0.00,'2022-05-02 20:43:07','',''),(1047,'21','220','1',1,'Sale Id shift 48',0.00,0.00,0.00,4746.89,0.00,'2022-05-02 20:43:07','',''),(1048,'21','220','2',1,'Sale Id shift 48',0.00,0.00,0.00,2922.78,0.00,'2022-05-02 20:43:07','',''),(1049,'21','220','2',1,'Sale Id shift 48',0.00,0.00,0.00,1264.67,0.00,'2022-05-02 20:43:07','',''),(1050,'21','220','1',1,'Sale Id shift 48',0.00,0.00,0.00,7036.37,0.00,'2022-05-02 20:43:07','',''),(1051,'21','220',NULL,1,'Sale Id shift 48',7410212.70,0.00,0.00,0.00,0.00,'2022-05-02 20:43:07','',''),(1052,'21','220',NULL,1,'Reception corrector for bridging 124',0.00,0.00,0.00,24000.00,0.00,'2022-05-03 10:23:54','',''),(1053,'21','220','1',1,'Received from bridging 124',0.00,0.00,24000.00,0.00,0.00,'2022-05-03 10:23:54','',''),(1054,'21','220','1',1,'Sale Id shift 49',0.00,0.00,0.00,3034.74,0.00,'2022-05-04 18:33:00','',''),(1055,'21','220','3',2,'Sale Id shift 49',0.00,0.00,0.00,150.72,0.00,'2022-05-04 18:33:00','',''),(1056,'21','220','1',1,'Sale Id shift 49',0.00,0.00,0.00,3779.82,0.00,'2022-05-04 18:33:00','',''),(1057,'21','220','1',1,'Sale Id shift 49',0.00,0.00,0.00,2248.13,0.00,'2022-05-04 18:33:00','',''),(1058,'21','220','1',1,'Sale Id shift 49',0.00,0.00,0.00,3244.48,0.00,'2022-05-04 18:33:00','',''),(1059,'21','220','2',1,'Sale Id shift 49',0.00,0.00,0.00,4175.10,0.00,'2022-05-04 18:33:00','',''),(1060,'21','220','2',1,'Sale Id shift 49',0.00,0.00,0.00,4239.68,0.00,'2022-05-04 18:33:00','',''),(1061,'21','220','2',1,'Sale Id shift 49',0.00,0.00,0.00,4485.63,0.00,'2022-05-04 18:33:00','',''),(1062,'21','220','2',1,'Sale Id shift 49',0.00,0.00,0.00,3136.27,0.00,'2022-05-04 18:33:00','',''),(1063,'21','220','1',1,'Sale Id shift 49',0.00,0.00,0.00,2431.53,0.00,'2022-05-04 18:33:00','',''),(1064,'21','220','2',1,'Sale Id shift 49',0.00,0.00,0.00,3026.24,0.00,'2022-05-04 18:33:00','',''),(1065,'21','220','2',1,'Sale Id shift 49',0.00,0.00,0.00,2873.63,0.00,'2022-05-04 18:33:00','',''),(1066,'21','220','1',1,'Sale Id shift 49',0.00,0.00,0.00,5278.27,0.00,'2022-05-04 18:33:00','',''),(1067,'21','220',NULL,1,'Sale Id shift 49',6922330.80,0.00,0.00,0.00,0.00,'2022-05-04 18:33:00','',''),(1068,'21','220',NULL,2,'Sale Id shift 49',105504.00,0.00,0.00,0.00,0.00,'2022-05-04 18:33:00','',''),(1069,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,26250000.00,37500.00,0.00,0.00,'2022-05-04 19:11:02','',''),(1070,'21','220',NULL,2,'Reception corrector for bridging 125',0.00,0.00,0.00,37500.00,0.00,'2022-05-04 19:14:13','',''),(1071,'21','220','3',2,'Received from bridging 125',0.00,0.00,37500.00,0.00,0.00,'2022-05-04 19:14:13','',''),(1072,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-04 19:16:56','',''),(1073,'21','220',NULL,1,'Reception corrector for bridging 127',0.00,0.00,0.00,23000.00,0.00,'2022-05-04 19:20:21','',''),(1074,'21','220','2',1,'Received from bridging 127',0.00,0.00,23000.00,0.00,0.00,'2022-05-04 19:20:21','',''),(1075,'21','220',NULL,1,'Reception corrector for bridging 126',0.00,0.00,0.00,37000.00,0.00,'2022-05-04 19:20:21','',''),(1076,'21','220','1',1,'Received from bridging 126',0.00,0.00,37000.00,0.00,0.00,'2022-05-04 19:20:21','',''),(1077,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-04 19:24:13','',''),(1078,'21','220','1',1,'Sale Id shift 50',0.00,0.00,0.00,3116.63,0.00,'2022-05-05 18:07:06','',''),(1079,'21','220','3',2,'Sale Id shift 50',0.00,0.00,0.00,1471.69,0.00,'2022-05-05 18:07:06','',''),(1080,'21','220','1',1,'Sale Id shift 50',0.00,0.00,0.00,6061.84,0.00,'2022-05-05 18:07:06','',''),(1081,'21','220','1',1,'Sale Id shift 50',0.00,0.00,0.00,4630.84,0.00,'2022-05-05 18:07:06','',''),(1082,'21','220','2',1,'Sale Id shift 50',0.00,0.00,0.00,4951.98,0.00,'2022-05-05 18:07:06','',''),(1083,'21','220','2',1,'Sale Id shift 50',0.00,0.00,0.00,1567.83,0.00,'2022-05-05 18:07:06','',''),(1084,'21','220','2',1,'Sale Id shift 50',0.00,0.00,0.00,2669.73,0.00,'2022-05-05 18:07:06','',''),(1085,'21','220','1',1,'Sale Id shift 50',0.00,0.00,0.00,3421.46,0.00,'2022-05-05 18:07:06','',''),(1086,'21','220','2',1,'Sale Id shift 50',0.00,0.00,0.00,2767.98,0.00,'2022-05-05 18:07:06','',''),(1087,'21','220','2',1,'Sale Id shift 50',0.00,0.00,0.00,3.03,0.00,'2022-05-05 18:07:06','',''),(1088,'21','220','1',1,'Sale Id shift 50',0.00,0.00,0.00,5754.46,0.00,'2022-05-05 18:07:06','',''),(1089,'21','220','3',2,'Sale Id shift 50',0.00,0.00,0.00,3000.00,0.00,'2022-05-05 18:07:06','',''),(1090,'21','220',NULL,1,'Sale Id shift 50',5766053.70,0.00,0.00,0.00,0.00,'2022-05-05 18:07:06','',''),(1091,'21','220',NULL,2,'Sale Id shift 50',3130183.00,0.00,0.00,0.00,0.00,'2022-05-05 18:07:06','',''),(1092,'21','220','3',2,'Sale Id shift 51',0.00,0.00,0.00,1383.10,0.00,'2022-05-05 18:56:12','',''),(1093,'21','220','1',1,'Sale Id shift 51',0.00,0.00,0.00,1859.84,0.00,'2022-05-05 18:56:12','',''),(1094,'21','220','1',1,'Sale Id shift 51',0.00,0.00,0.00,618.99,0.00,'2022-05-05 18:56:12','',''),(1095,'21','220','1',1,'Sale Id shift 51',0.00,0.00,0.00,1575.21,0.00,'2022-05-05 18:56:12','',''),(1096,'21','220','1',1,'Sale Id shift 51',0.00,0.00,0.00,2137.33,0.00,'2022-05-05 18:56:12','',''),(1097,'21','220','1',1,'Sale Id shift 51',0.00,0.00,0.00,1701.61,0.00,'2022-05-05 18:56:12','',''),(1098,'21','220','3',2,'Sale Id shift 51',0.00,0.00,0.00,407.42,0.00,'2022-05-05 18:56:12','',''),(1099,'21','220',NULL,1,'Sale Id shift 51',1302341.70,0.00,0.00,0.00,0.00,'2022-05-05 18:56:12','',''),(1100,'21','220',NULL,2,'Sale Id shift 51',1253364.00,0.00,0.00,0.00,0.00,'2022-05-05 18:56:12','',''),(1101,'21','220',NULL,1,'Reception corrector for bridging 129',0.00,0.00,0.00,20000.00,0.00,'2022-05-05 19:05:18','',''),(1102,'21','220','2',1,'Received from bridging 129',0.00,0.00,20000.00,0.00,0.00,'2022-05-05 19:05:18','',''),(1103,'21','220',NULL,1,'Reception corrector for bridging 128',0.00,0.00,0.00,40000.00,0.00,'2022-05-05 19:05:18','',''),(1104,'21','220','1',1,'Received from bridging 128',0.00,0.00,40000.00,0.00,0.00,'2022-05-05 19:05:18','',''),(1105,'21','220','1',1,'Sale Id shift 52',0.00,0.00,0.00,6529.39,0.00,'2022-05-05 20:31:00','',''),(1106,'21','220','3',2,'Sale Id shift 52',0.00,0.00,0.00,3672.97,0.00,'2022-05-05 20:31:00','',''),(1107,'21','220','1',1,'Sale Id shift 52',0.00,0.00,0.00,3002.63,0.00,'2022-05-05 20:31:00','',''),(1108,'21','220','1',1,'Sale Id shift 52',0.00,0.00,0.00,4117.19,0.00,'2022-05-05 20:31:00','',''),(1109,'21','220','1',1,'Sale Id shift 52',0.00,0.00,0.00,5832.04,0.00,'2022-05-05 20:31:00','',''),(1110,'21','220','1',1,'Sale Id shift 52',0.00,0.00,0.00,5145.39,0.00,'2022-05-05 20:31:00','',''),(1111,'21','220','2',1,'Sale Id shift 52',0.00,0.00,0.00,3178.49,0.00,'2022-05-05 20:31:00','',''),(1112,'21','220','2',1,'Sale Id shift 52',0.00,0.00,0.00,4702.91,0.00,'2022-05-05 20:31:00','',''),(1113,'21','220','2',1,'Sale Id shift 52',0.00,0.00,0.00,5486.18,0.00,'2022-05-05 20:31:00','',''),(1114,'21','220','1',1,'Sale Id shift 52',0.00,0.00,0.00,3999.00,0.00,'2022-05-05 20:31:00','',''),(1115,'21','220','2',1,'Sale Id shift 52',0.00,0.00,0.00,2540.12,0.00,'2022-05-05 20:31:00','',''),(1116,'21','220','2',1,'Sale Id shift 52',0.00,0.00,0.00,3082.25,0.00,'2022-05-05 20:31:00','',''),(1117,'21','220','1',1,'Sale Id shift 52',0.00,0.00,0.00,7793.66,0.00,'2022-05-05 20:31:00','',''),(1118,'21','220',NULL,2,'Sale Id shift 52',2571079.00,0.00,0.00,0.00,0.00,'2022-05-05 20:31:00','',''),(1119,'21','220',NULL,1,'Sale Id shift 52',9142526.25,0.00,0.00,0.00,0.00,'2022-05-05 20:31:00','',''),(1120,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-06 18:37:41','',''),(1121,'21','220',NULL,1,'Reception corrector for bridging 131',0.00,0.00,0.00,25000.00,0.00,'2022-05-06 20:47:42','',''),(1122,'21','220','2',1,'Received from bridging 131',0.00,0.00,25000.00,0.00,0.00,'2022-05-06 20:47:42','',''),(1123,'21','220',NULL,1,'Reception corrector for bridging 130',0.00,0.00,0.00,25000.00,0.00,'2022-05-06 20:47:42','',''),(1124,'21','220','1',1,'Received from bridging 130',0.00,0.00,25000.00,0.00,0.00,'2022-05-06 20:47:42','',''),(1125,'21','220','1',1,'Sale Id shift 53',0.00,0.00,0.00,3251.89,0.00,'2022-05-07 14:37:40','',''),(1126,'21','220','3',2,'Sale Id shift 53',0.00,0.00,0.00,5590.03,0.00,'2022-05-07 14:37:40','',''),(1127,'21','220','1',1,'Sale Id shift 53',0.00,0.00,0.00,6164.91,0.00,'2022-05-07 14:37:40','',''),(1128,'21','220','1',1,'Sale Id shift 53',0.00,0.00,0.00,3131.48,0.00,'2022-05-07 14:37:40','',''),(1129,'21','220','1',1,'Sale Id shift 53',0.00,0.00,0.00,7162.42,0.00,'2022-05-07 14:37:40','',''),(1130,'21','220','1',1,'Sale Id shift 53',0.00,0.00,0.00,4023.39,0.00,'2022-05-07 14:37:40','',''),(1131,'21','220','2',1,'Sale Id shift 53',0.00,0.00,0.00,5687.92,0.00,'2022-05-07 14:37:40','',''),(1132,'21','220','2',1,'Sale Id shift 53',0.00,0.00,0.00,2445.45,0.00,'2022-05-07 14:37:40','',''),(1133,'21','220','2',1,'Sale Id shift 53',0.00,0.00,0.00,4992.94,0.00,'2022-05-07 14:37:40','',''),(1134,'21','220','2',1,'Sale Id shift 53',0.00,0.00,0.00,2558.88,0.00,'2022-05-07 14:37:40','',''),(1135,'21','220','1',1,'Sale Id shift 53',0.00,0.00,0.00,4470.62,0.00,'2022-05-07 14:37:40','',''),(1136,'21','220','2',1,'Sale Id shift 53',0.00,0.00,0.00,5147.15,0.00,'2022-05-07 14:37:40','',''),(1137,'21','220','2',1,'Sale Id shift 53',0.00,0.00,0.00,2408.53,0.00,'2022-05-07 14:37:40','',''),(1138,'21','220','1',1,'Sale Id shift 53',0.00,0.00,0.00,7273.11,0.00,'2022-05-07 14:37:40','',''),(1139,'21','220','3',2,'Sale Id shift 53',0.00,0.00,0.00,25.72,0.00,'2022-05-07 14:37:40','',''),(1140,'21','220',NULL,2,'Sale Id shift 53',3931025.00,0.00,0.00,0.00,0.00,'2022-05-07 14:37:40','',''),(1141,'21','220',NULL,1,'Sale Id shift 53',9688583.85,0.00,0.00,0.00,0.00,'2022-05-07 14:37:40','',''),(1142,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-07 20:28:58','',''),(1143,'21','220',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,15000.00,0.00,'2022-05-07 20:32:04','',''),(1144,'21','220','2',1,'Received from bridging 133',0.00,0.00,15000.00,0.00,0.00,'2022-05-07 20:32:04','',''),(1145,'21','220',NULL,1,'Reception corrector for bridging 132',0.00,0.00,0.00,30000.00,0.00,'2022-05-07 20:32:04','',''),(1146,'21','220','1',1,'Received from bridging 132',0.00,0.00,30000.00,0.00,0.00,'2022-05-07 20:32:04','',''),(1147,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-07 20:35:26','',''),(1148,'21','220','1',1,'Sale Id shift 54',0.00,0.00,0.00,3182.02,0.00,'2022-05-08 12:41:52','',''),(1149,'21','220','3',2,'Sale Id shift 54',0.00,0.00,0.00,2422.49,0.00,'2022-05-08 12:41:52','',''),(1150,'21','220','1',1,'Sale Id shift 54',0.00,0.00,0.00,4077.93,0.00,'2022-05-08 12:41:52','',''),(1151,'21','220','1',1,'Sale Id shift 54',0.00,0.00,0.00,2563.09,0.00,'2022-05-08 12:41:52','',''),(1152,'21','220','1',1,'Sale Id shift 54',0.00,0.00,0.00,3685.04,0.00,'2022-05-08 12:41:52','',''),(1153,'21','220','1',1,'Sale Id shift 54',0.00,0.00,0.00,2882.47,0.00,'2022-05-08 12:41:52','',''),(1154,'21','220','2',1,'Sale Id shift 54',0.00,0.00,0.00,5468.83,0.00,'2022-05-08 12:41:52','',''),(1155,'21','220','2',1,'Sale Id shift 54',0.00,0.00,0.00,4761.49,0.00,'2022-05-08 12:41:52','',''),(1156,'21','220','2',1,'Sale Id shift 54',0.00,0.00,0.00,3479.38,0.00,'2022-05-08 12:41:52','',''),(1157,'21','220','2',1,'Sale Id shift 54',0.00,0.00,0.00,4019.79,0.00,'2022-05-08 12:41:52','',''),(1158,'21','220','1',1,'Sale Id shift 54',0.00,0.00,0.00,3879.89,0.00,'2022-05-08 12:41:52','',''),(1159,'21','220','2',1,'Sale Id shift 54',0.00,0.00,0.00,3420.44,0.00,'2022-05-08 12:41:52','',''),(1160,'21','220','2',1,'Sale Id shift 54',0.00,0.00,0.00,4561.59,0.00,'2022-05-08 12:41:52','',''),(1161,'21','220','1',1,'Sale Id shift 54',0.00,0.00,0.00,4207.05,0.00,'2022-05-08 12:41:52','',''),(1162,'21','220','3',2,'Sale Id shift 54',0.00,0.00,0.00,1528.30,0.00,'2022-05-08 12:41:52','',''),(1163,'21','220',NULL,1,'Sale Id shift 54',8281186.65,0.00,0.00,0.00,0.00,'2022-05-08 12:41:52','',''),(1164,'21','220',NULL,2,'Sale Id shift 54',2765553.00,0.00,0.00,0.00,0.00,'2022-05-08 12:41:52','',''),(1165,'21','220',NULL,1,'Reception corrector for bridging 135',0.00,0.00,0.00,22000.00,0.00,'2022-05-08 21:31:04','',''),(1166,'21','220','2',1,'Received from bridging 135',0.00,0.00,22000.00,0.00,0.00,'2022-05-08 21:31:04','',''),(1167,'21','220',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,23000.00,0.00,'2022-05-08 21:31:04','',''),(1168,'21','220','1',1,'Received from bridging 134',0.00,0.00,23000.00,0.00,0.00,'2022-05-08 21:31:04','',''),(1169,'21','220','2',1,'Returned bridging 135',0.00,0.00,0.00,22000.00,0.00,'2022-05-09 09:13:39','',''),(1170,'21','220',NULL,1,'Reception Return corrector for bridging 135',0.00,0.00,22000.00,0.00,0.00,'2022-05-09 09:13:39','',''),(1171,'21','220','1',1,'Returned bridging 134',0.00,0.00,0.00,23000.00,0.00,'2022-05-09 09:14:07','',''),(1172,'21','220',NULL,1,'Reception Return corrector for bridging 134',0.00,0.00,23000.00,0.00,0.00,'2022-05-09 09:14:07','',''),(1173,'21','220',NULL,1,'Reception corrector for bridging 137',0.00,0.00,0.00,15000.00,0.00,'2022-05-09 09:16:44','',''),(1174,'21','220','2',1,'Received from bridging 137',0.00,0.00,15000.00,0.00,0.00,'2022-05-09 09:16:44','',''),(1175,'21','220',NULL,1,'Reception corrector for bridging 136',0.00,0.00,0.00,30000.00,0.00,'2022-05-09 09:16:45','',''),(1176,'21','220','1',1,'Received from bridging 136',0.00,0.00,30000.00,0.00,0.00,'2022-05-09 09:16:45','',''),(1177,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-09 20:42:28','',''),(1178,'21','220',NULL,1,'Reception corrector for bridging 139',0.00,0.00,0.00,15000.00,0.00,'2022-05-09 20:44:08','',''),(1179,'21','220','2',1,'Received from bridging 139',0.00,0.00,15000.00,0.00,0.00,'2022-05-09 20:44:08','',''),(1180,'21','220',NULL,1,'Reception corrector for bridging 138',0.00,0.00,0.00,30000.00,0.00,'2022-05-09 20:44:08','',''),(1181,'21','220','1',1,'Received from bridging 138',0.00,0.00,30000.00,0.00,0.00,'2022-05-09 20:44:08','',''),(1182,'21','220','1',1,'Sale Id shift 55',0.00,0.00,0.00,6202.23,0.00,'2022-05-09 22:14:12','',''),(1183,'21','220','3',2,'Sale Id shift 55',0.00,0.00,0.00,5302.64,0.00,'2022-05-09 22:14:12','',''),(1184,'21','220','1',1,'Sale Id shift 55',0.00,0.00,0.00,4853.46,0.00,'2022-05-09 22:14:12','',''),(1185,'21','220','1',1,'Sale Id shift 55',0.00,0.00,0.00,4956.22,0.00,'2022-05-09 22:14:12','',''),(1186,'21','220','1',1,'Sale Id shift 55',0.00,0.00,0.00,5318.24,0.00,'2022-05-09 22:14:12','',''),(1187,'21','220','1',1,'Sale Id shift 55',0.00,0.00,0.00,5147.19,0.00,'2022-05-09 22:14:12','',''),(1188,'21','220','2',1,'Sale Id shift 55',0.00,0.00,0.00,3844.04,0.00,'2022-05-09 22:14:12','',''),(1189,'21','220','2',1,'Sale Id shift 55',0.00,0.00,0.00,2628.21,0.00,'2022-05-09 22:14:12','',''),(1190,'21','220','2',1,'Sale Id shift 55',0.00,0.00,0.00,2301.84,0.00,'2022-05-09 22:14:12','',''),(1191,'21','220','2',1,'Sale Id shift 55',0.00,0.00,0.00,2941.65,0.00,'2022-05-09 22:14:12','',''),(1192,'21','220','1',1,'Sale Id shift 55',0.00,0.00,0.00,4998.97,0.00,'2022-05-09 22:14:12','',''),(1193,'21','220','2',1,'Sale Id shift 55',0.00,0.00,0.00,3318.26,0.00,'2022-05-09 22:14:12','',''),(1194,'21','220','2',1,'Sale Id shift 55',0.00,0.00,0.00,2237.97,0.00,'2022-05-09 22:14:12','',''),(1195,'21','220','1',1,'Sale Id shift 55',0.00,0.00,0.00,7243.27,0.00,'2022-05-09 22:14:12','',''),(1196,'21','220','3',2,'Sale Id shift 55',0.00,0.00,0.00,400.68,0.00,'2022-05-09 22:14:12','',''),(1197,'21','220',NULL,1,'Sale Id shift 55',9238605.75,0.00,0.00,0.00,0.00,'2022-05-09 22:14:12','',''),(1198,'21','220',NULL,2,'Sale Id shift 55',3992324.00,0.00,0.00,0.00,0.00,'2022-05-09 22:14:12','',''),(1199,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-10 19:55:03','',''),(1200,'21','220',NULL,1,'Reception corrector for bridging 141',0.00,0.00,0.00,15000.00,0.00,'2022-05-10 19:56:29','',''),(1201,'21','220','2',1,'Received from bridging 141',0.00,0.00,15000.00,0.00,0.00,'2022-05-10 19:56:29','',''),(1202,'21','220',NULL,1,'Reception corrector for bridging 140',0.00,0.00,0.00,30000.00,0.00,'2022-05-10 19:56:29','',''),(1203,'21','220','1',1,'Received from bridging 140',0.00,0.00,30000.00,0.00,0.00,'2022-05-10 19:56:29','',''),(1204,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,21000000.00,30000.00,0.00,0.00,'2022-05-10 19:59:13','',''),(1205,'21','220',NULL,2,'Reception corrector for bridging 142',0.00,0.00,0.00,30000.00,0.00,'2022-05-10 20:00:44','',''),(1206,'21','220','3',2,'Received from bridging 142',0.00,0.00,30000.00,0.00,0.00,'2022-05-10 20:00:44','',''),(1207,'21','220','1',1,'Sale Id shift 56',0.00,0.00,0.00,199.50,0.00,'2022-05-10 22:43:36','',''),(1208,'21','220','3',2,'Sale Id shift 56',0.00,0.00,0.00,2724.21,0.00,'2022-05-10 22:43:36','',''),(1209,'21','220','1',1,'Sale Id shift 56',0.00,0.00,0.00,2178.14,0.00,'2022-05-10 22:43:36','',''),(1210,'21','220','1',1,'Sale Id shift 56',0.00,0.00,0.00,1526.94,0.00,'2022-05-10 22:43:36','',''),(1211,'21','220','1',1,'Sale Id shift 56',0.00,0.00,0.00,2143.85,0.00,'2022-05-10 22:43:36','',''),(1212,'21','220','1',1,'Sale Id shift 56',0.00,0.00,0.00,1885.70,0.00,'2022-05-10 22:43:36','',''),(1213,'21','220','2',1,'Sale Id shift 56',0.00,0.00,0.00,4183.67,0.00,'2022-05-10 22:43:36','',''),(1214,'21','220','2',1,'Sale Id shift 56',0.00,0.00,0.00,3336.05,0.00,'2022-05-10 22:43:36','',''),(1215,'21','220','2',1,'Sale Id shift 56',0.00,0.00,0.00,3899.42,0.00,'2022-05-10 22:43:36','',''),(1216,'21','220','2',1,'Sale Id shift 56',0.00,0.00,0.00,326.65,0.00,'2022-05-10 22:43:36','',''),(1217,'21','220','1',1,'Sale Id shift 56',0.00,0.00,0.00,2407.90,0.00,'2022-05-10 22:43:36','',''),(1218,'21','220','2',1,'Sale Id shift 56',0.00,0.00,0.00,4021.29,0.00,'2022-05-10 22:43:36','',''),(1219,'21','220','2',1,'Sale Id shift 56',0.00,0.00,0.00,3789.59,0.00,'2022-05-10 22:43:36','',''),(1220,'21','220','1',1,'Sale Id shift 56',0.00,0.00,0.00,2197.62,0.00,'2022-05-10 22:43:36','',''),(1221,'21','220',NULL,2,'Sale Id shift 56',1906947.00,0.00,0.00,0.00,0.00,'2022-05-10 22:43:36','',''),(1222,'21','220',NULL,1,'Sale Id shift 56',5295892.80,0.00,0.00,0.00,0.00,'2022-05-10 22:43:36','',''),(1223,'21','220','1',1,'Sale Id shift 57',0.00,0.00,0.00,4442.90,0.00,'2022-05-11 00:21:27','',''),(1224,'21','220','3',2,'Sale Id shift 57',0.00,0.00,0.00,5390.95,0.00,'2022-05-11 00:21:27','',''),(1225,'21','220','1',1,'Sale Id shift 57',0.00,0.00,0.00,3812.21,0.00,'2022-05-11 00:21:27','',''),(1226,'21','220','1',1,'Sale Id shift 57',0.00,0.00,0.00,3051.96,0.00,'2022-05-11 00:21:27','',''),(1227,'21','220','1',1,'Sale Id shift 57',0.00,0.00,0.00,4062.67,0.00,'2022-05-11 00:21:27','',''),(1228,'21','220','1',1,'Sale Id shift 57',0.00,0.00,0.00,3920.28,0.00,'2022-05-11 00:21:27','',''),(1229,'21','220','2',1,'Sale Id shift 57',0.00,0.00,0.00,3386.71,0.00,'2022-05-11 00:21:27','',''),(1230,'21','220','2',1,'Sale Id shift 57',0.00,0.00,0.00,2053.37,0.00,'2022-05-11 00:21:27','',''),(1231,'21','220','2',1,'Sale Id shift 57',0.00,0.00,0.00,2408.74,0.00,'2022-05-11 00:21:27','',''),(1232,'21','220','2',1,'Sale Id shift 57',0.00,0.00,0.00,2114.40,0.00,'2022-05-11 00:21:27','',''),(1233,'21','220','1',1,'Sale Id shift 57',0.00,0.00,0.00,4560.80,0.00,'2022-05-11 00:21:27','',''),(1234,'21','220','2',1,'Sale Id shift 57',0.00,0.00,0.00,2593.15,0.00,'2022-05-11 00:21:27','',''),(1235,'21','220','2',1,'Sale Id shift 57',0.00,0.00,0.00,2390.65,0.00,'2022-05-11 00:21:27','',''),(1236,'21','220','1',1,'Sale Id shift 57',0.00,0.00,0.00,6142.24,0.00,'2022-05-11 00:21:27','',''),(1237,'21','220',NULL,2,'Sale Id shift 57',3773665.00,0.00,0.00,0.00,0.00,'2022-05-11 00:21:27','',''),(1238,'21','220',NULL,1,'Sale Id shift 57',7415113.20,0.00,0.00,0.00,0.00,'2022-05-11 00:21:27','',''),(1239,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-11 17:53:45','',''),(1240,'21','220',NULL,1,'Reception corrector for bridging 144',0.00,0.00,0.00,20000.00,0.00,'2022-05-11 17:55:36','',''),(1241,'21','220','2',1,'Received from bridging 144',0.00,0.00,20000.00,0.00,0.00,'2022-05-11 17:55:36','',''),(1242,'21','220',NULL,1,'Reception corrector for bridging 143',0.00,0.00,0.00,40000.00,0.00,'2022-05-11 17:55:45','',''),(1243,'21','220','1',1,'Received from bridging 143',0.00,0.00,40000.00,0.00,0.00,'2022-05-11 17:55:45','',''),(1244,'21','220','1',1,'Sale Id shift 58',0.00,0.00,0.00,4094.99,0.00,'2022-05-12 17:57:02','',''),(1245,'21','220','3',2,'Sale Id shift 58',0.00,0.00,0.00,2463.50,0.00,'2022-05-12 17:57:02','',''),(1246,'21','220','1',1,'Sale Id shift 58',0.00,0.00,0.00,4636.16,0.00,'2022-05-12 17:57:02','',''),(1247,'21','220','1',1,'Sale Id shift 58',0.00,0.00,0.00,4091.09,0.00,'2022-05-12 17:57:02','',''),(1248,'21','220','1',1,'Sale Id shift 58',0.00,0.00,0.00,4485.44,0.00,'2022-05-12 17:57:02','',''),(1249,'21','220','1',1,'Sale Id shift 58',0.00,0.00,0.00,3180.40,0.00,'2022-05-12 17:57:02','',''),(1250,'21','220','2',1,'Sale Id shift 58',0.00,0.00,0.00,3644.48,0.00,'2022-05-12 17:57:02','',''),(1251,'21','220','2',1,'Sale Id shift 58',0.00,0.00,0.00,1656.60,0.00,'2022-05-12 17:57:02','',''),(1252,'21','220','2',1,'Sale Id shift 58',0.00,0.00,0.00,1713.97,0.00,'2022-05-12 17:57:02','',''),(1253,'21','220','2',1,'Sale Id shift 58',0.00,0.00,0.00,2782.05,0.00,'2022-05-12 17:57:02','',''),(1254,'21','220','1',1,'Sale Id shift 58',0.00,0.00,0.00,4726.06,0.00,'2022-05-12 17:57:02','',''),(1255,'21','220','2',1,'Sale Id shift 58',0.00,0.00,0.00,3309.40,0.00,'2022-05-12 17:57:02','',''),(1256,'21','220','2',1,'Sale Id shift 58',0.00,0.00,0.00,1680.04,0.00,'2022-05-12 17:57:02','',''),(1257,'21','220','1',1,'Sale Id shift 58',0.00,0.00,0.00,6468.90,0.00,'2022-05-12 17:57:02','',''),(1258,'21','220',NULL,1,'Sale Id shift 58',7667480.70,0.00,0.00,0.00,0.00,'2022-05-12 17:57:02','',''),(1259,'21','220',NULL,2,'Sale Id shift 58',1724450.00,0.00,0.00,0.00,0.00,'2022-05-12 17:57:02','',''),(1260,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-12 18:24:15','',''),(1261,'21','220',NULL,1,'Reception corrector for bridging 146',0.00,0.00,0.00,20000.00,0.00,'2022-05-12 18:26:42','',''),(1262,'21','220','2',1,'Received from bridging 146',0.00,0.00,20000.00,0.00,0.00,'2022-05-12 18:26:42','',''),(1263,'21','220',NULL,1,'Reception corrector for bridging 145',0.00,0.00,0.00,20000.00,0.00,'2022-05-12 18:26:42','',''),(1264,'21','220','1',1,'Received from bridging 145',0.00,0.00,20000.00,0.00,0.00,'2022-05-12 18:26:42','',''),(1265,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 20:59:17','',''),(1266,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 21:00:49','',''),(1267,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 21:01:27','',''),(1268,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 21:04:15','',''),(1269,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-16 21:07:49','',''),(1270,'21','220',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,15675000.00,28500.00,0.00,0.00,'2022-05-16 21:09:01','',''),(1271,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-16 21:10:21','',''),(1272,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-16 21:13:16','',''),(1273,'21','220','3',2,'Sale Id shift 59',0.00,0.00,0.00,4255.24,0.00,'2022-05-17 17:13:48','',''),(1274,'21','220','1',1,'Sale Id shift 59',0.00,0.00,0.00,6846.16,0.00,'2022-05-17 17:13:48','',''),(1275,'21','220','1',1,'Sale Id shift 59',0.00,0.00,0.00,5615.26,0.00,'2022-05-17 17:13:48','',''),(1276,'21','220','1',1,'Sale Id shift 59',0.00,0.00,0.00,4328.65,0.00,'2022-05-17 17:13:48','',''),(1277,'21','220','1',1,'Sale Id shift 59',0.00,0.00,0.00,4936.62,0.00,'2022-05-17 17:13:48','',''),(1278,'21','220','2',1,'Sale Id shift 59',0.00,0.00,0.00,3073.38,0.00,'2022-05-17 17:13:48','',''),(1279,'21','220','2',1,'Sale Id shift 59',0.00,0.00,0.00,2077.98,0.00,'2022-05-17 17:13:48','',''),(1280,'21','220','2',1,'Sale Id shift 59',0.00,0.00,0.00,2052.95,0.00,'2022-05-17 17:13:48','',''),(1281,'21','220','2',1,'Sale Id shift 59',0.00,0.00,0.00,2301.09,0.00,'2022-05-17 17:13:48','',''),(1282,'21','220','1',1,'Sale Id shift 59',0.00,0.00,0.00,8383.41,0.00,'2022-05-17 17:13:48','',''),(1283,'21','220','2',1,'Sale Id shift 59',0.00,0.00,0.00,4219.12,0.00,'2022-05-17 17:13:48','',''),(1284,'21','220','2',1,'Sale Id shift 59',0.00,0.00,0.00,3704.39,0.00,'2022-05-17 17:13:48','',''),(1285,'21','220','2',1,'Sale Id shift 59',0.00,0.00,0.00,2506.52,0.00,'2022-05-17 17:13:48','',''),(1286,'21','220','1',1,'Sale Id shift 59',0.00,0.00,0.00,9699.61,0.00,'2022-05-17 17:13:48','',''),(1287,'21','220',NULL,1,'Sale Id shift 59',9857948.10,0.00,0.00,0.00,0.00,'2022-05-17 17:13:48','',''),(1288,'21','220',NULL,2,'Sale Id shift 59',2978668.00,0.00,0.00,0.00,0.00,'2022-05-17 17:13:48','',''),(1289,'21','220',NULL,1,'Reception corrector for bridging 147',0.00,0.00,0.00,45000.00,0.00,'2022-05-17 17:32:29','',''),(1290,'21','220','1',1,'Received from bridging 147',0.00,0.00,45000.00,0.00,0.00,'2022-05-17 17:32:29','',''),(1291,'21','220',NULL,1,'Reception corrector for bridging 148',0.00,0.00,0.00,45000.00,0.00,'2022-05-17 17:32:49','',''),(1292,'21','220','2',1,'Received from bridging 148',0.00,0.00,45000.00,0.00,0.00,'2022-05-17 17:32:49','',''),(1293,'21','220','3',2,'Sale Id shift 60',0.00,0.00,0.00,4788.18,0.00,'2022-05-17 17:54:40','',''),(1294,'21','220','1',1,'Sale Id shift 60',0.00,0.00,0.00,2904.44,0.00,'2022-05-17 17:54:40','',''),(1295,'21','220','1',1,'Sale Id shift 60',0.00,0.00,0.00,2364.41,0.00,'2022-05-17 17:54:40','',''),(1296,'21','220','1',1,'Sale Id shift 60',0.00,0.00,0.00,258.90,0.00,'2022-05-17 17:54:40','',''),(1297,'21','220','1',1,'Sale Id shift 60',0.00,0.00,0.00,3880.01,0.00,'2022-05-17 17:54:40','',''),(1298,'21','220','2',1,'Sale Id shift 60',0.00,0.00,0.00,3458.46,0.00,'2022-05-17 17:54:40','',''),(1299,'21','220','2',1,'Sale Id shift 60',0.00,0.00,0.00,1237.81,0.00,'2022-05-17 17:54:40','',''),(1300,'21','220','2',1,'Sale Id shift 60',0.00,0.00,0.00,2807.79,0.00,'2022-05-17 17:54:40','',''),(1301,'21','220','2',1,'Sale Id shift 60',0.00,0.00,0.00,2207.06,0.00,'2022-05-17 17:54:40','',''),(1302,'21','220','1',1,'Sale Id shift 60',0.00,0.00,0.00,4578.26,0.00,'2022-05-17 17:54:40','',''),(1303,'21','220','2',1,'Sale Id shift 60',0.00,0.00,0.00,4308.69,0.00,'2022-05-17 17:54:40','',''),(1304,'21','220','2',1,'Sale Id shift 60',0.00,0.00,0.00,2989.73,0.00,'2022-05-17 17:54:40','',''),(1305,'21','220','2',1,'Sale Id shift 60',0.00,0.00,0.00,2908.70,0.00,'2022-05-17 17:54:40','',''),(1306,'21','220','1',1,'Sale Id shift 60',0.00,0.00,0.00,4660.68,0.00,'2022-05-17 17:54:40','',''),(1307,'21','220',NULL,1,'Sale Id shift 60',6363215.10,0.00,0.00,0.00,0.00,'2022-05-17 17:54:40','',''),(1308,'21','220',NULL,2,'Sale Id shift 60',3351726.00,0.00,0.00,0.00,0.00,'2022-05-17 17:54:40','',''),(1309,'21','220',NULL,3,'Reception corrector for bridging 151',0.00,0.00,0.00,28500.00,0.00,'2022-05-18 15:26:00','',''),(1310,'21','220','4',3,'Received from bridging 151',0.00,0.00,28500.00,0.00,0.00,'2022-05-18 15:26:00','',''),(1311,'21','220',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,20000.00,0.00,'2022-05-18 15:26:56','',''),(1312,'21','220','2',1,'Received from bridging 153',0.00,0.00,20000.00,0.00,0.00,'2022-05-18 15:26:56','',''),(1313,'21','220',NULL,1,'Reception corrector for bridging 152',0.00,0.00,0.00,40000.00,0.00,'2022-05-18 15:26:56','',''),(1314,'21','220','1',1,'Received from bridging 152',0.00,0.00,40000.00,0.00,0.00,'2022-05-18 15:26:56','',''),(1315,'21','220','3',2,'Sale Id shift 61',0.00,0.00,0.00,5175.66,0.00,'2022-05-18 17:40:21','',''),(1316,'21','220','1',1,'Sale Id shift 61',0.00,0.00,0.00,5544.11,0.00,'2022-05-18 17:40:21','',''),(1317,'21','220','1',1,'Sale Id shift 61',0.00,0.00,0.00,4895.00,0.00,'2022-05-18 17:40:21','',''),(1318,'21','220','1',1,'Sale Id shift 61',0.00,0.00,0.00,4709.55,0.00,'2022-05-18 17:40:21','',''),(1319,'21','220','1',1,'Sale Id shift 61',0.00,0.00,0.00,4430.05,0.00,'2022-05-18 17:40:21','',''),(1320,'21','220','2',1,'Sale Id shift 61',0.00,0.00,0.00,5817.17,0.00,'2022-05-18 17:40:21','',''),(1321,'21','220','2',1,'Sale Id shift 61',0.00,0.00,0.00,4351.32,0.00,'2022-05-18 17:40:21','',''),(1322,'21','220','2',1,'Sale Id shift 61',0.00,0.00,0.00,3755.57,0.00,'2022-05-18 17:40:21','',''),(1323,'21','220','2',1,'Sale Id shift 61',0.00,0.00,0.00,3473.28,0.00,'2022-05-18 17:40:21','',''),(1324,'21','220','1',1,'Sale Id shift 61',0.00,0.00,0.00,7410.48,0.00,'2022-05-18 17:40:21','',''),(1325,'21','220','2',1,'Sale Id shift 61',0.00,0.00,0.00,7206.92,0.00,'2022-05-18 17:40:21','',''),(1326,'21','220','2',1,'Sale Id shift 61',0.00,0.00,0.00,3765.05,0.00,'2022-05-18 17:40:21','',''),(1327,'21','220','2',1,'Sale Id shift 61',0.00,0.00,0.00,3996.70,0.00,'2022-05-18 17:40:21','',''),(1328,'21','220','1',1,'Sale Id shift 61',0.00,0.00,0.00,7581.02,0.00,'2022-05-18 17:40:21','',''),(1329,'21','220',NULL,1,'Sale Id shift 61',11044476.30,0.00,0.00,0.00,0.00,'2022-05-18 17:40:21','',''),(1330,'21','220',NULL,2,'Sale Id shift 61',3622962.00,0.00,0.00,0.00,0.00,'2022-05-18 17:40:21','',''),(1331,'21','220',NULL,1,'Reception corrector for bridging 155',0.00,0.00,0.00,20000.00,0.00,'2022-05-19 19:27:31','',''),(1332,'21','220','2',1,'Received from bridging 155',0.00,0.00,20000.00,0.00,0.00,'2022-05-19 19:27:31','',''),(1333,'21','220',NULL,1,'Reception corrector for bridging 154',0.00,0.00,0.00,30000.00,0.00,'2022-05-19 19:27:35','',''),(1334,'21','220','1',1,'Received from bridging 154',0.00,0.00,30000.00,0.00,0.00,'2022-05-19 19:27:35','',''),(1335,'21','220','3',2,'Sale Id shift 62',0.00,0.00,0.00,1129.89,0.00,'2022-05-19 19:36:01','',''),(1336,'21','220','1',1,'Sale Id shift 62',0.00,0.00,0.00,7091.60,0.00,'2022-05-19 19:36:01','',''),(1337,'21','220','1',1,'Sale Id shift 62',0.00,0.00,0.00,2803.96,0.00,'2022-05-19 19:36:01','',''),(1338,'21','220','1',1,'Sale Id shift 62',0.00,0.00,0.00,6246.38,0.00,'2022-05-19 19:36:01','',''),(1339,'21','220','1',1,'Sale Id shift 62',0.00,0.00,0.00,4692.76,0.00,'2022-05-19 19:36:01','',''),(1340,'21','220','2',1,'Sale Id shift 62',0.00,0.00,0.00,6569.25,0.00,'2022-05-19 19:36:01','',''),(1341,'21','220','2',1,'Sale Id shift 62',0.00,0.00,0.00,4782.08,0.00,'2022-05-19 19:36:01','',''),(1342,'21','220','2',1,'Sale Id shift 62',0.00,0.00,0.00,6316.85,0.00,'2022-05-19 19:36:01','',''),(1343,'21','220','1',1,'Sale Id shift 62',0.00,0.00,0.00,8215.10,0.00,'2022-05-19 19:36:01','',''),(1344,'21','220','2',1,'Sale Id shift 62',0.00,0.00,0.00,5293.52,0.00,'2022-05-19 19:36:01','',''),(1345,'21','220','2',1,'Sale Id shift 62',0.00,0.00,0.00,4618.25,0.00,'2022-05-19 19:36:01','',''),(1346,'21','220','2',1,'Sale Id shift 62',0.00,0.00,0.00,5839.81,0.00,'2022-05-19 19:36:01','',''),(1347,'21','220','1',1,'Sale Id shift 62',0.00,0.00,0.00,9678.55,0.00,'2022-05-19 19:36:01','',''),(1348,'21','220','3',2,'Sale Id shift 62',0.00,0.00,0.00,244.98,0.00,'2022-05-19 19:36:01','',''),(1349,'21','220',NULL,1,'Sale Id shift 62',11904438.15,0.00,0.00,0.00,0.00,'2022-05-19 19:36:01','',''),(1350,'21','220',NULL,2,'Sale Id shift 62',962409.00,0.00,0.00,0.00,0.00,'2022-05-19 19:36:01','',''),(1351,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 20:25:37','',''),(1352,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 20:30:12','',''),(1353,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,18550000.00,26500.00,0.00,0.00,'2022-05-19 20:32:12','',''),(1354,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-19 20:33:23','',''),(1355,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-19 20:36:26','',''),(1356,'21','220',NULL,1,'Reception corrector for bridging 150',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 20:38:16','',''),(1357,'21','220','1',1,'Received from bridging 150',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 20:38:16','',''),(1358,'21','220','3',2,'Sale Id shift 63',0.00,0.00,0.00,5871.58,0.00,'2022-05-19 21:15:02','',''),(1359,'21','220','3',2,'Sale Id shift 63',0.00,0.00,0.00,188.16,0.00,'2022-05-19 21:15:02','',''),(1360,'21','220',NULL,2,'Sale Id shift 63',4363012.80,0.00,0.00,0.00,0.00,'2022-05-19 21:15:02','',''),(1361,'21','220',NULL,1,'Reception corrector for bridging 160',0.00,0.00,0.00,60000.00,0.00,'2022-05-20 12:38:29','',''),(1362,'21','220','2',1,'Received from bridging 160',0.00,0.00,60000.00,0.00,0.00,'2022-05-20 12:38:29','',''),(1363,'21','220','3',2,'Sale Id shift 64',0.00,0.00,0.00,2699.01,0.00,'2022-05-20 13:02:00','',''),(1364,'21','220','4',3,'Sale Id shift 64',0.00,0.00,0.00,1081.48,0.00,'2022-05-20 13:02:00','',''),(1365,'21','220','1',1,'Sale Id shift 64',0.00,0.00,0.00,8016.72,0.00,'2022-05-20 13:02:00','',''),(1366,'21','220','1',1,'Sale Id shift 64',0.00,0.00,0.00,6135.37,0.00,'2022-05-20 13:02:00','',''),(1367,'21','220','1',1,'Sale Id shift 64',0.00,0.00,0.00,5926.45,0.00,'2022-05-20 13:02:00','',''),(1368,'21','220','2',1,'Sale Id shift 64',0.00,0.00,0.00,6702.63,0.00,'2022-05-20 13:02:00','',''),(1369,'21','220','2',1,'Sale Id shift 64',0.00,0.00,0.00,5325.58,0.00,'2022-05-20 13:02:00','',''),(1370,'21','220','2',1,'Sale Id shift 64',0.00,0.00,0.00,5724.14,0.00,'2022-05-20 13:02:00','',''),(1371,'21','220','1',1,'Sale Id shift 64',0.00,0.00,0.00,7855.66,0.00,'2022-05-20 13:02:00','',''),(1372,'21','220','2',1,'Sale Id shift 64',0.00,0.00,0.00,7503.86,0.00,'2022-05-20 13:02:00','',''),(1373,'21','220','2',1,'Sale Id shift 64',0.00,0.00,0.00,5346.91,0.00,'2022-05-20 13:02:00','',''),(1374,'21','220','2',1,'Sale Id shift 64',0.00,0.00,0.00,4246.43,0.00,'2022-05-20 13:02:00','',''),(1375,'21','220','1',1,'Sale Id shift 64',0.00,0.00,0.00,7813.30,0.00,'2022-05-20 13:02:00','',''),(1376,'21','220',NULL,1,'Sale Id shift 64',11648513.25,0.00,0.00,0.00,0.00,'2022-05-20 13:02:00','',''),(1377,'21','220',NULL,2,'Sale Id shift 64',1943287.20,0.00,0.00,0.00,0.00,'2022-05-20 13:02:00','',''),(1378,'21','220',NULL,3,'Sale Id shift 64',702962.00,0.00,0.00,0.00,0.00,'2022-05-20 13:02:00','',''),(1379,'21','220',NULL,1,'Reception corrector for bridging 161',0.00,0.00,0.00,30000.00,0.00,'2022-05-20 13:30:04','',''),(1380,'21','220','2',1,'Received from bridging 161',0.00,0.00,30000.00,0.00,0.00,'2022-05-20 13:30:04','',''),(1381,'21','220',NULL,1,'Reception corrector for bridging 157',0.00,0.00,0.00,45000.00,0.00,'2022-05-20 13:30:28','',''),(1382,'21','220','1',1,'Received from bridging 157',0.00,0.00,45000.00,0.00,0.00,'2022-05-20 13:30:28','',''),(1383,'21','220','1',1,'Sale Id shift 65',0.00,0.00,0.00,3220.13,0.00,'2022-05-20 18:26:23','',''),(1384,'21','220','3',2,'Sale Id shift 65',0.00,0.00,0.00,4509.98,0.00,'2022-05-20 18:26:23','',''),(1385,'21','220','4',3,'Sale Id shift 65',0.00,0.00,0.00,1223.56,0.00,'2022-05-20 18:26:23','',''),(1386,'21','220','1',1,'Sale Id shift 65',0.00,0.00,0.00,5932.58,0.00,'2022-05-20 18:26:23','',''),(1387,'21','220','1',1,'Sale Id shift 65',0.00,0.00,0.00,5992.69,0.00,'2022-05-20 18:26:23','',''),(1388,'21','220','1',1,'Sale Id shift 65',0.00,0.00,0.00,2634.88,0.00,'2022-05-20 18:26:23','',''),(1389,'21','220','1',1,'Sale Id shift 65',0.00,0.00,0.00,7000.29,0.00,'2022-05-20 18:26:23','',''),(1390,'21','220','2',1,'Sale Id shift 65',0.00,0.00,0.00,5679.26,0.00,'2022-05-20 18:26:23','',''),(1391,'21','220','2',1,'Sale Id shift 65',0.00,0.00,0.00,5737.49,0.00,'2022-05-20 18:26:23','',''),(1392,'21','220','2',1,'Sale Id shift 65',0.00,0.00,0.00,7230.09,0.00,'2022-05-20 18:26:23','',''),(1393,'21','220','1',1,'Sale Id shift 65',0.00,0.00,0.00,4871.28,0.00,'2022-05-20 18:26:23','',''),(1394,'21','220','2',1,'Sale Id shift 65',0.00,0.00,0.00,7683.59,0.00,'2022-05-20 18:26:23','',''),(1395,'21','220','2',1,'Sale Id shift 65',0.00,0.00,0.00,6536.23,0.00,'2022-05-20 18:26:23','',''),(1396,'21','220','2',1,'Sale Id shift 65',0.00,0.00,0.00,4438.69,0.00,'2022-05-20 18:26:23','',''),(1397,'21','220','1',1,'Sale Id shift 65',0.00,0.00,0.00,9184.48,0.00,'2022-05-20 18:26:23','',''),(1398,'21','220','3',2,'Sale Id shift 65',0.00,0.00,0.00,194.45,0.00,'2022-05-20 18:26:23','',''),(1399,'21','220',NULL,1,'Sale Id shift 65',12563377.20,0.00,0.00,0.00,0.00,'2022-05-20 18:26:23','',''),(1400,'21','220',NULL,2,'Sale Id shift 65',3387189.60,0.00,0.00,0.00,0.00,'2022-05-20 18:26:23','',''),(1401,'21','220',NULL,3,'Sale Id shift 65',795314.00,0.00,0.00,0.00,0.00,'2022-05-20 18:26:23','',''),(1402,'21','220','1',1,'Sale Id shift 66',0.00,0.00,0.00,5864.95,0.00,'2022-05-20 18:56:58','',''),(1403,'21','220','3',2,'Sale Id shift 66',0.00,0.00,0.00,3451.52,0.00,'2022-05-20 18:56:58','',''),(1404,'21','220','4',3,'Sale Id shift 66',0.00,0.00,0.00,1621.43,0.00,'2022-05-20 18:56:58','',''),(1405,'21','220','1',1,'Sale Id shift 66',0.00,0.00,0.00,4776.14,0.00,'2022-05-20 18:56:58','',''),(1406,'21','220','1',1,'Sale Id shift 66',0.00,0.00,0.00,4523.77,0.00,'2022-05-20 18:56:58','',''),(1407,'21','220','1',1,'Sale Id shift 66',0.00,0.00,0.00,7739.54,0.00,'2022-05-20 18:56:58','',''),(1408,'21','220','2',1,'Sale Id shift 66',0.00,0.00,0.00,5877.75,0.00,'2022-05-20 18:56:58','',''),(1409,'21','220','2',1,'Sale Id shift 66',0.00,0.00,0.00,4176.41,0.00,'2022-05-20 18:56:58','',''),(1410,'21','220','2',1,'Sale Id shift 66',0.00,0.00,0.00,6057.33,0.00,'2022-05-20 18:56:58','',''),(1411,'21','220','1',1,'Sale Id shift 66',0.00,0.00,0.00,5930.07,0.00,'2022-05-20 18:56:58','',''),(1412,'21','220','2',1,'Sale Id shift 66',0.00,0.00,0.00,5980.54,0.00,'2022-05-20 18:56:58','',''),(1413,'21','220','2',1,'Sale Id shift 66',0.00,0.00,0.00,3967.97,0.00,'2022-05-20 18:56:58','',''),(1414,'21','220','2',1,'Sale Id shift 66',0.00,0.00,0.00,5358.38,0.00,'2022-05-20 18:56:58','',''),(1415,'21','220','1',1,'Sale Id shift 66',0.00,0.00,0.00,9220.44,0.00,'2022-05-20 18:56:58','',''),(1416,'21','220',NULL,1,'Sale Id shift 66',11463092.85,0.00,0.00,0.00,0.00,'2022-05-20 18:56:58','',''),(1417,'21','220',NULL,2,'Sale Id shift 66',2485094.40,0.00,0.00,0.00,0.00,'2022-05-20 18:56:58','',''),(1418,'21','220',NULL,3,'Sale Id shift 66',1053929.50,0.00,0.00,0.00,0.00,'2022-05-20 18:56:58','',''),(1419,'21','220',NULL,1,'Reception corrector for bridging 162',0.00,0.00,0.00,15000.00,0.00,'2022-05-20 19:12:56','',''),(1420,'21','220','2',1,'Received from bridging 162',0.00,0.00,15000.00,0.00,0.00,'2022-05-20 19:12:56','',''),(1421,'21','220',NULL,1,'Reception corrector for bridging 159',0.00,0.00,0.00,60000.00,0.00,'2022-05-20 19:13:14','',''),(1422,'21','220','1',1,'Received from bridging 159',0.00,0.00,60000.00,0.00,0.00,'2022-05-20 19:13:14','',''),(1423,'21','220',NULL,1,'Reception corrector for bridging 156',0.00,0.00,0.00,45000.00,0.00,'2022-05-20 19:13:31','',''),(1424,'21','220','2',1,'Received from bridging 156',0.00,0.00,45000.00,0.00,0.00,'2022-05-20 19:13:31','',''),(1425,'21','220',NULL,2,'Reception corrector for bridging 158',0.00,0.00,0.00,26500.00,0.00,'2022-05-20 19:13:58','',''),(1426,'21','220','3',2,'Received from bridging 158',0.00,0.00,26500.00,0.00,0.00,'2022-05-20 19:13:58','',''),(1427,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-20 19:42:41','',''),(1428,'21','220','1',1,'Sale Id shift 67',0.00,0.00,0.00,6002.09,0.00,'2022-05-20 20:36:02','',''),(1429,'21','220','3',2,'Sale Id shift 67',0.00,0.00,0.00,6627.25,0.00,'2022-05-20 20:36:02','',''),(1430,'21','220','4',3,'Sale Id shift 67',0.00,0.00,0.00,1523.70,0.00,'2022-05-20 20:36:02','',''),(1431,'21','220','1',1,'Sale Id shift 67',0.00,0.00,0.00,6056.05,0.00,'2022-05-20 20:36:02','',''),(1432,'21','220','1',1,'Sale Id shift 67',0.00,0.00,0.00,4919.27,0.00,'2022-05-20 20:36:02','',''),(1433,'21','220','1',1,'Sale Id shift 67',0.00,0.00,0.00,7914.55,0.00,'2022-05-20 20:36:02','',''),(1434,'21','220','2',1,'Sale Id shift 67',0.00,0.00,0.00,5701.95,0.00,'2022-05-20 20:36:02','',''),(1435,'21','220','2',1,'Sale Id shift 67',0.00,0.00,0.00,3646.23,0.00,'2022-05-20 20:36:02','',''),(1436,'21','220','2',1,'Sale Id shift 67',0.00,0.00,0.00,6596.39,0.00,'2022-05-20 20:36:02','',''),(1437,'21','220','1',1,'Sale Id shift 67',0.00,0.00,0.00,5631.28,0.00,'2022-05-20 20:36:02','',''),(1438,'21','220','2',1,'Sale Id shift 67',0.00,0.00,0.00,5122.35,0.00,'2022-05-20 20:36:02','',''),(1439,'21','220','2',1,'Sale Id shift 67',0.00,0.00,0.00,4566.22,0.00,'2022-05-20 20:36:02','',''),(1440,'21','220','1',1,'Sale Id shift 67',0.00,0.00,0.00,7826.13,0.00,'2022-05-20 20:36:02','',''),(1441,'21','220',NULL,1,'Sale Id shift 67',10557114.15,0.00,0.00,0.00,0.00,'2022-05-20 20:36:02','',''),(1442,'21','220',NULL,2,'Sale Id shift 67',4771620.00,0.00,0.00,0.00,0.00,'2022-05-20 20:36:02','',''),(1443,'21','220',NULL,3,'Sale Id shift 67',990405.00,0.00,0.00,0.00,0.00,'2022-05-20 20:36:02','',''),(1444,'21','220',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,39000.00,0.00,'2022-05-20 20:42:59','',''),(1445,'21','220','2',1,'Received from bridging 164',0.00,0.00,39000.00,0.00,0.00,'2022-05-20 20:42:59','',''),(1446,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-20 22:10:35','',''),(1447,'21','220',NULL,1,'Reception corrector for bridging 167',0.00,0.00,0.00,6000.00,0.00,'2022-05-20 22:36:50','',''),(1448,'21','220','1',1,'Received from bridging 167',0.00,0.00,6000.00,0.00,0.00,'2022-05-20 22:36:50','',''),(1449,'21','220',NULL,1,'Reception corrector for bridging 165',0.00,0.00,0.00,37000.00,0.00,'2022-05-20 22:37:33','',''),(1450,'21','220','1',1,'Received from bridging 165',0.00,0.00,37000.00,0.00,0.00,'2022-05-20 22:37:33','',''),(1451,'21','220','1',1,'Sale Id shift 68',0.00,0.00,0.00,6196.31,0.00,'2022-05-21 00:50:03','',''),(1452,'21','220','3',2,'Sale Id shift 68',0.00,0.00,0.00,7403.70,0.00,'2022-05-21 00:50:03','',''),(1453,'21','220','4',3,'Sale Id shift 68',0.00,0.00,0.00,1183.75,0.00,'2022-05-21 00:50:03','',''),(1454,'21','220','1',1,'Sale Id shift 68',0.00,0.00,0.00,5162.13,0.00,'2022-05-21 00:50:03','',''),(1455,'21','220','1',1,'Sale Id shift 68',0.00,0.00,0.00,2036.85,0.00,'2022-05-21 00:50:03','',''),(1456,'21','220','1',1,'Sale Id shift 68',0.00,0.00,0.00,7062.76,0.00,'2022-05-21 00:50:03','',''),(1457,'21','220','2',1,'Sale Id shift 68',0.00,0.00,0.00,7488.88,0.00,'2022-05-21 00:50:03','',''),(1458,'21','220','2',1,'Sale Id shift 68',0.00,0.00,0.00,1382.04,0.00,'2022-05-21 00:50:03','',''),(1459,'21','220','2',1,'Sale Id shift 68',0.00,0.00,0.00,5138.22,0.00,'2022-05-21 00:50:03','',''),(1460,'21','220','1',1,'Sale Id shift 68',0.00,0.00,0.00,5830.50,0.00,'2022-05-21 00:50:03','',''),(1461,'21','220','2',1,'Sale Id shift 68',0.00,0.00,0.00,9405.11,0.00,'2022-05-21 00:50:03','',''),(1462,'21','220','2',1,'Sale Id shift 68',0.00,0.00,0.00,4899.91,0.00,'2022-05-21 00:50:03','',''),(1463,'21','220','2',1,'Sale Id shift 68',0.00,0.00,0.00,4997.50,0.00,'2022-05-21 00:50:03','',''),(1464,'21','220','1',1,'Sale Id shift 68',0.00,0.00,0.00,8689.39,0.00,'2022-05-21 00:50:03','',''),(1465,'21','220','3',2,'Sale Id shift 68',0.00,0.00,0.00,1948.39,0.00,'2022-05-21 00:50:03','',''),(1466,'21','220',NULL,2,'Sale Id shift 68',6733504.80,0.00,0.00,0.00,0.00,'2022-05-21 00:50:03','',''),(1467,'21','220',NULL,3,'Sale Id shift 68',769437.50,0.00,0.00,0.00,0.00,'2022-05-21 00:50:03','',''),(1468,'21','220',NULL,1,'Sale Id shift 68',11267784.00,0.00,0.00,0.00,0.00,'2022-05-21 00:50:03','',''),(1469,'21','220',NULL,1,'Reception corrector for bridging 166',0.00,0.00,0.00,23000.00,0.00,'2022-05-21 17:34:11','',''),(1470,'21','220','2',1,'Received from bridging 166',0.00,0.00,23000.00,0.00,0.00,'2022-05-21 17:34:11','',''),(1471,'21','220','1',1,'Sale Id shift 69',0.00,0.00,0.00,2307.04,0.00,'2022-05-22 00:00:08','',''),(1472,'21','220','3',2,'Sale Id shift 69',0.00,0.00,0.00,5890.31,0.00,'2022-05-22 00:00:08','',''),(1473,'21','220','4',3,'Sale Id shift 69',0.00,0.00,0.00,1142.91,0.00,'2022-05-22 00:00:08','',''),(1474,'21','220','1',1,'Sale Id shift 69',0.00,0.00,0.00,2682.06,0.00,'2022-05-22 00:00:08','',''),(1475,'21','220','1',1,'Sale Id shift 69',0.00,0.00,0.00,1977.13,0.00,'2022-05-22 00:00:08','',''),(1476,'21','220','1',1,'Sale Id shift 69',0.00,0.00,0.00,2686.39,0.00,'2022-05-22 00:00:08','',''),(1477,'21','220','2',1,'Sale Id shift 69',0.00,0.00,0.00,6689.78,0.00,'2022-05-22 00:00:08','',''),(1478,'21','220','2',1,'Sale Id shift 69',0.00,0.00,0.00,5199.97,0.00,'2022-05-22 00:00:08','',''),(1479,'21','220','2',1,'Sale Id shift 69',0.00,0.00,0.00,6067.89,0.00,'2022-05-22 00:00:08','',''),(1480,'21','220','2',1,'Sale Id shift 69',0.00,0.00,0.00,4536.09,0.00,'2022-05-22 00:00:08','',''),(1481,'21','220','2',1,'Sale Id shift 69',0.00,0.00,0.00,8064.54,0.00,'2022-05-22 00:00:08','',''),(1482,'21','220','2',1,'Sale Id shift 69',0.00,0.00,0.00,3602.45,0.00,'2022-05-22 00:00:08','',''),(1483,'21','220','2',1,'Sale Id shift 69',0.00,0.00,0.00,5425.09,0.00,'2022-05-22 00:00:08','',''),(1484,'21','220','2',1,'Sale Id shift 69',0.00,0.00,0.00,6580.55,0.00,'2022-05-22 00:00:08','',''),(1485,'21','220','1',1,'Sale Id shift 69',0.00,0.00,0.00,4292.30,0.00,'2022-05-22 00:00:08','',''),(1486,'21','220',NULL,1,'Sale Id shift 69',9918361.20,0.00,0.00,0.00,0.00,'2022-05-22 00:00:08','',''),(1487,'21','220',NULL,2,'Sale Id shift 69',4241023.20,0.00,0.00,0.00,0.00,'2022-05-22 00:00:08','',''),(1488,'21','220',NULL,3,'Sale Id shift 69',742891.50,0.00,0.00,0.00,0.00,'2022-05-22 00:00:08','',''),(1489,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-22 19:38:50','',''),(1490,'21','220',NULL,1,'Reception corrector for bridging 169',0.00,0.00,0.00,25000.00,0.00,'2022-05-22 19:40:37','',''),(1491,'21','220','2',1,'Received from bridging 169',0.00,0.00,25000.00,0.00,0.00,'2022-05-22 19:40:37','',''),(1492,'21','220',NULL,1,'Reception corrector for bridging 168',0.00,0.00,0.00,15000.00,0.00,'2022-05-22 19:40:37','',''),(1493,'21','220','1',1,'Received from bridging 168',0.00,0.00,15000.00,0.00,0.00,'2022-05-22 19:40:37','',''),(1494,'21','220','1',1,'Sale Id shift 70',0.00,0.00,0.00,3983.18,0.00,'2022-05-23 10:55:46','',''),(1495,'21','220','3',2,'Sale Id shift 70',0.00,0.00,0.00,3571.66,0.00,'2022-05-23 10:55:46','',''),(1496,'21','220','4',3,'Sale Id shift 70',0.00,0.00,0.00,739.59,0.00,'2022-05-23 10:55:46','',''),(1497,'21','220','1',1,'Sale Id shift 70',0.00,0.00,0.00,2426.19,0.00,'2022-05-23 10:55:46','',''),(1498,'21','220','1',1,'Sale Id shift 70',0.00,0.00,0.00,5845.73,0.00,'2022-05-23 10:55:46','',''),(1499,'21','220','1',1,'Sale Id shift 70',0.00,0.00,0.00,24.80,0.00,'2022-05-23 10:55:46','',''),(1500,'21','220','1',1,'Sale Id shift 70',0.00,0.00,0.00,7496.11,0.00,'2022-05-23 10:55:46','',''),(1501,'21','220','2',1,'Sale Id shift 70',0.00,0.00,0.00,6004.58,0.00,'2022-05-23 10:55:46','',''),(1502,'21','220','2',1,'Sale Id shift 70',0.00,0.00,0.00,6393.52,0.00,'2022-05-23 10:55:46','',''),(1503,'21','220','1',1,'Sale Id shift 70',0.00,0.00,0.00,7107.54,0.00,'2022-05-23 10:55:46','',''),(1504,'21','220','2',1,'Sale Id shift 70',0.00,0.00,0.00,5848.29,0.00,'2022-05-23 10:55:46','',''),(1505,'21','220','2',1,'Sale Id shift 70',0.00,0.00,0.00,4077.01,0.00,'2022-05-23 10:55:46','',''),(1506,'21','220','2',1,'Sale Id shift 70',0.00,0.00,0.00,6007.04,0.00,'2022-05-23 10:55:46','',''),(1507,'21','220','1',1,'Sale Id shift 70',0.00,0.00,0.00,7839.18,0.00,'2022-05-23 10:55:46','',''),(1508,'21','220',NULL,2,'Sale Id shift 70',2571595.20,0.00,0.00,0.00,0.00,'2022-05-23 10:55:46','',''),(1509,'21','220',NULL,3,'Sale Id shift 70',480733.50,0.00,0.00,0.00,0.00,'2022-05-23 10:55:46','',''),(1510,'21','220',NULL,1,'Sale Id shift 70',10403773.05,0.00,0.00,0.00,0.00,'2022-05-23 10:55:46','',''),(1511,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-23 11:36:33','',''),(1512,'21','220',NULL,1,'Reception corrector for bridging 171',0.00,0.00,0.00,25000.00,0.00,'2022-05-23 11:38:12','',''),(1513,'21','220','2',1,'Received from bridging 171',0.00,0.00,25000.00,0.00,0.00,'2022-05-23 11:38:12','',''),(1514,'21','220',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,15000.00,0.00,'2022-05-23 11:38:12','',''),(1515,'21','220','1',1,'Received from bridging 170',0.00,0.00,15000.00,0.00,0.00,'2022-05-23 11:38:12','',''),(1516,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,21600000.00,30000.00,0.00,0.00,'2022-05-23 11:38:29','',''),(1517,'21','220',NULL,2,'Reception corrector for bridging 172',0.00,0.00,0.00,30000.00,0.00,'2022-05-23 11:39:48','',''),(1518,'21','220','3',2,'Received from bridging 172',0.00,0.00,30000.00,0.00,0.00,'2022-05-23 11:39:48','',''),(1519,'21','220','1',1,'Sale Id shift 71',0.00,0.00,0.00,4041.07,0.00,'2022-05-23 14:27:21','',''),(1520,'21','220','3',2,'Sale Id shift 71',0.00,0.00,0.00,2576.43,0.00,'2022-05-23 14:27:21','',''),(1521,'21','220','4',3,'Sale Id shift 71',0.00,0.00,0.00,1357.87,0.00,'2022-05-23 14:27:21','',''),(1522,'21','220','1',1,'Sale Id shift 71',0.00,0.00,0.00,2634.33,0.00,'2022-05-23 14:27:21','',''),(1523,'21','220','1',1,'Sale Id shift 71',0.00,0.00,0.00,2383.12,0.00,'2022-05-23 14:27:21','',''),(1524,'21','220','1',1,'Sale Id shift 71',0.00,0.00,0.00,2986.29,0.00,'2022-05-23 14:27:21','',''),(1525,'21','220','2',1,'Sale Id shift 71',0.00,0.00,0.00,4380.29,0.00,'2022-05-23 14:27:21','',''),(1526,'21','220','2',1,'Sale Id shift 71',0.00,0.00,0.00,2310.73,0.00,'2022-05-23 14:27:21','',''),(1527,'21','220','2',1,'Sale Id shift 71',0.00,0.00,0.00,1577.68,0.00,'2022-05-23 14:27:21','',''),(1528,'21','220','2',1,'Sale Id shift 71',0.00,0.00,0.00,6321.28,0.00,'2022-05-23 14:27:21','',''),(1529,'21','220','1',1,'Sale Id shift 71',0.00,0.00,0.00,331.02,0.00,'2022-05-23 14:27:21','',''),(1530,'21','220','2',1,'Sale Id shift 71',0.00,0.00,0.00,5120.42,0.00,'2022-05-23 14:27:21','',''),(1531,'21','220','2',1,'Sale Id shift 71',0.00,0.00,0.00,243.99,0.00,'2022-05-23 14:27:21','',''),(1532,'21','220','2',1,'Sale Id shift 71',0.00,0.00,0.00,5793.25,0.00,'2022-05-23 14:27:21','',''),(1533,'21','220','2',1,'Sale Id shift 71',0.00,0.00,0.00,2967.87,0.00,'2022-05-23 14:27:21','',''),(1534,'21','220',NULL,2,'Sale Id shift 71',1855029.60,0.00,0.00,0.00,0.00,'2022-05-23 14:27:21','',''),(1535,'21','220',NULL,3,'Sale Id shift 71',882615.50,0.00,0.00,0.00,0.00,'2022-05-23 14:27:21','',''),(1536,'21','220',NULL,1,'Sale Id shift 71',6780071.10,0.00,0.00,0.00,0.00,'2022-05-23 14:27:21','',''),(1537,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-24 20:24:00','',''),(1538,'21','220',NULL,1,'Reception corrector for bridging 174',0.00,0.00,0.00,17500.00,0.00,'2022-05-24 20:25:50','',''),(1539,'21','220','2',1,'Received from bridging 174',0.00,0.00,17500.00,0.00,0.00,'2022-05-24 20:25:50','',''),(1540,'21','220',NULL,1,'Reception corrector for bridging 173',0.00,0.00,0.00,32000.00,0.00,'2022-05-24 20:25:50','',''),(1541,'21','220','1',1,'Received from bridging 173',0.00,0.00,32000.00,0.00,0.00,'2022-05-24 20:25:50','',''),(1542,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-24 20:26:10','',''),(1543,'21','220','1',1,'Sale Id shift 72',0.00,0.00,0.00,4502.84,0.00,'2022-05-24 21:47:24','',''),(1544,'21','220','3',2,'Sale Id shift 72',0.00,0.00,0.00,622.42,0.00,'2022-05-24 21:47:24','',''),(1545,'21','220','4',3,'Sale Id shift 72',0.00,0.00,0.00,1622.47,0.00,'2022-05-24 21:47:24','',''),(1546,'21','220','1',1,'Sale Id shift 72',0.00,0.00,0.00,4384.86,0.00,'2022-05-24 21:47:24','',''),(1547,'21','220','1',1,'Sale Id shift 72',0.00,0.00,0.00,1581.84,0.00,'2022-05-24 21:47:24','',''),(1548,'21','220','1',1,'Sale Id shift 72',0.00,0.00,0.00,5397.68,0.00,'2022-05-24 21:47:24','',''),(1549,'21','220','2',1,'Sale Id shift 72',0.00,0.00,0.00,1185.62,0.00,'2022-05-24 21:47:24','',''),(1550,'21','220','2',1,'Sale Id shift 72',0.00,0.00,0.00,5192.69,0.00,'2022-05-24 21:47:24','',''),(1551,'21','220','2',1,'Sale Id shift 72',0.00,0.00,0.00,2755.55,0.00,'2022-05-24 21:47:24','',''),(1552,'21','220','2',1,'Sale Id shift 72',0.00,0.00,0.00,3219.72,0.00,'2022-05-24 21:47:24','',''),(1553,'21','220','1',1,'Sale Id shift 72',0.00,0.00,0.00,4940.09,0.00,'2022-05-24 21:47:24','',''),(1554,'21','220','2',1,'Sale Id shift 72',0.00,0.00,0.00,6485.26,0.00,'2022-05-24 21:47:24','',''),(1555,'21','220','2',1,'Sale Id shift 72',0.00,0.00,0.00,1513.84,0.00,'2022-05-24 21:47:24','',''),(1556,'21','220','2',1,'Sale Id shift 72',0.00,0.00,0.00,4690.26,0.00,'2022-05-24 21:47:24','',''),(1557,'21','220','2',1,'Sale Id shift 72',0.00,0.00,0.00,3346.64,0.00,'2022-05-24 21:47:24','',''),(1558,'21','220','1',1,'Sale Id shift 72',0.00,0.00,0.00,9898.01,0.00,'2022-05-24 21:47:24','',''),(1559,'21','220',NULL,2,'Sale Id shift 72',448142.40,0.00,0.00,0.00,0.00,'2022-05-24 21:47:24','',''),(1560,'21','220',NULL,3,'Sale Id shift 72',1054605.50,0.00,0.00,0.00,0.00,'2022-05-24 21:47:24','',''),(1561,'21','220',NULL,1,'Sale Id shift 72',9750658.50,0.00,0.00,0.00,0.00,'2022-05-24 21:47:24','',''),(1562,'21','220','3',2,'Sale Id shift 73',0.00,0.00,0.00,7227.09,0.00,'2022-05-24 22:05:41','',''),(1563,'21','220','3',2,'Sale Id shift 73',0.00,0.00,0.00,59.63,0.00,'2022-05-24 22:05:41','',''),(1564,'21','220',NULL,2,'Sale Id shift 73',5537907.20,0.00,0.00,0.00,0.00,'2022-05-24 22:05:41','',''),(1565,'21','220',NULL,1,'Reception corrector for bridging 176',0.00,0.00,0.00,30000.00,0.00,'2022-05-25 13:49:24','',''),(1566,'21','220','2',1,'Received from bridging 176',0.00,0.00,30000.00,0.00,0.00,'2022-05-25 13:49:24','',''),(1567,'21','220',NULL,1,'Reception corrector for bridging 175',0.00,0.00,0.00,15000.00,0.00,'2022-05-25 13:49:24','',''),(1568,'21','220','1',1,'Received from bridging 175',0.00,0.00,15000.00,0.00,0.00,'2022-05-25 13:49:24','',''),(1569,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-26 20:18:26','',''),(1570,'21','220',NULL,1,'Reception corrector for bridging 178',0.00,0.00,0.00,40000.00,0.00,'2022-05-26 20:20:51','',''),(1571,'21','220','2',1,'Received from bridging 178',0.00,0.00,40000.00,0.00,0.00,'2022-05-26 20:20:51','',''),(1572,'21','220',NULL,1,'Reception corrector for bridging 177',0.00,0.00,0.00,20000.00,0.00,'2022-05-26 20:20:51','',''),(1573,'21','220','1',1,'Received from bridging 177',0.00,0.00,20000.00,0.00,0.00,'2022-05-26 20:20:51','',''),(1574,'21','220','1',1,'Sale Id shift 74',0.00,0.00,0.00,2095.06,0.00,'2022-05-26 21:03:49','',''),(1575,'21','220','3',2,'Sale Id shift 74',0.00,0.00,0.00,7864.65,0.00,'2022-05-26 21:03:49','',''),(1576,'21','220','4',3,'Sale Id shift 74',0.00,0.00,0.00,2958.20,0.00,'2022-05-26 21:03:49','',''),(1577,'21','220','1',1,'Sale Id shift 74',0.00,0.00,0.00,2549.82,0.00,'2022-05-26 21:03:49','',''),(1578,'21','220','1',1,'Sale Id shift 74',0.00,0.00,0.00,564.72,0.00,'2022-05-26 21:03:49','',''),(1579,'21','220','1',1,'Sale Id shift 74',0.00,0.00,0.00,3311.67,0.00,'2022-05-26 21:03:49','',''),(1580,'21','220','2',1,'Sale Id shift 74',0.00,0.00,0.00,3347.45,0.00,'2022-05-26 21:03:49','',''),(1581,'21','220','2',1,'Sale Id shift 74',0.00,0.00,0.00,2267.18,0.00,'2022-05-26 21:03:49','',''),(1582,'21','220','2',1,'Sale Id shift 74',0.00,0.00,0.00,2637.76,0.00,'2022-05-26 21:03:49','',''),(1583,'21','220','2',1,'Sale Id shift 74',0.00,0.00,0.00,3610.44,0.00,'2022-05-26 21:03:49','',''),(1584,'21','220','1',1,'Sale Id shift 74',0.00,0.00,0.00,3106.86,0.00,'2022-05-26 21:03:49','',''),(1585,'21','220','2',1,'Sale Id shift 74',0.00,0.00,0.00,5128.99,0.00,'2022-05-26 21:03:49','',''),(1586,'21','220','2',1,'Sale Id shift 74',0.00,0.00,0.00,3126.50,0.00,'2022-05-26 21:03:49','',''),(1587,'21','220','2',1,'Sale Id shift 74',0.00,0.00,0.00,3386.07,0.00,'2022-05-26 21:03:49','',''),(1588,'21','220','2',1,'Sale Id shift 74',0.00,0.00,0.00,4513.62,0.00,'2022-05-26 21:03:49','',''),(1589,'21','220','1',1,'Sale Id shift 74',0.00,0.00,0.00,3136.35,0.00,'2022-05-26 21:03:49','',''),(1590,'21','220',NULL,1,'Sale Id shift 74',7059110.85,0.00,0.00,0.00,0.00,'2022-05-26 21:03:49','',''),(1591,'21','220',NULL,2,'Sale Id shift 74',5977134.00,0.00,0.00,0.00,0.00,'2022-05-26 21:03:49','',''),(1592,'21','220',NULL,3,'Sale Id shift 74',1922830.00,0.00,0.00,0.00,0.00,'2022-05-26 21:03:49','',''),(1593,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-26 21:06:01','',''),(1594,'21','220','1',1,'Sale Id shift 75',0.00,0.00,0.00,2764.32,0.00,'2022-05-27 01:00:55','',''),(1595,'21','220','3',2,'Sale Id shift 75',0.00,0.00,0.00,7691.63,0.00,'2022-05-27 01:00:55','',''),(1596,'21','220','4',3,'Sale Id shift 75',0.00,0.00,0.00,1702.28,0.00,'2022-05-27 01:00:55','',''),(1597,'21','220','1',1,'Sale Id shift 75',0.00,0.00,0.00,2624.63,0.00,'2022-05-27 01:00:55','',''),(1598,'21','220','1',1,'Sale Id shift 75',0.00,0.00,0.00,1655.92,0.00,'2022-05-27 01:00:55','',''),(1599,'21','220','1',1,'Sale Id shift 75',0.00,0.00,0.00,2395.16,0.00,'2022-05-27 01:00:55','',''),(1600,'21','220','2',1,'Sale Id shift 75',0.00,0.00,0.00,3727.12,0.00,'2022-05-27 01:00:55','',''),(1601,'21','220','2',1,'Sale Id shift 75',0.00,0.00,0.00,665.51,0.00,'2022-05-27 01:00:55','',''),(1602,'21','220','2',1,'Sale Id shift 75',0.00,0.00,0.00,4342.50,0.00,'2022-05-27 01:00:55','',''),(1603,'21','220','2',1,'Sale Id shift 75',0.00,0.00,0.00,4446.40,0.00,'2022-05-27 01:00:55','',''),(1604,'21','220','1',1,'Sale Id shift 75',0.00,0.00,0.00,2186.26,0.00,'2022-05-27 01:00:55','',''),(1605,'21','220','2',1,'Sale Id shift 75',0.00,0.00,0.00,4770.45,0.00,'2022-05-27 01:00:55','',''),(1606,'21','220','2',1,'Sale Id shift 75',0.00,0.00,0.00,5103.22,0.00,'2022-05-27 01:00:55','',''),(1607,'21','220','2',1,'Sale Id shift 75',0.00,0.00,0.00,4987.71,0.00,'2022-05-27 01:00:55','',''),(1608,'21','220','2',1,'Sale Id shift 75',0.00,0.00,0.00,4155.06,0.00,'2022-05-27 01:00:55','',''),(1609,'21','220','1',1,'Sale Id shift 75',0.00,0.00,0.00,3137.17,0.00,'2022-05-27 01:00:55','',''),(1610,'21','220','3',2,'Sale Id shift 75',0.00,0.00,0.00,2004.61,0.00,'2022-05-27 01:00:55','',''),(1611,'21','220',NULL,2,'Sale Id shift 75',7369142.40,0.00,0.00,0.00,0.00,'2022-05-27 01:00:55','',''),(1612,'21','220',NULL,3,'Sale Id shift 75',1106482.00,0.00,0.00,0.00,0.00,'2022-05-27 01:00:55','',''),(1613,'21','220',NULL,1,'Sale Id shift 75',7748635.95,0.00,0.00,0.00,0.00,'2022-05-27 01:00:55','',''),(1614,'21','220',NULL,1,'Reception corrector for bridging 180',0.00,0.00,0.00,40000.00,0.00,'2022-05-27 17:42:23','',''),(1615,'21','220','2',1,'Received from bridging 180',0.00,0.00,40000.00,0.00,0.00,'2022-05-27 17:42:23','',''),(1616,'21','220',NULL,1,'Reception corrector for bridging 179',0.00,0.00,0.00,20000.00,0.00,'2022-05-27 17:42:23','',''),(1617,'21','220','1',1,'Received from bridging 179',0.00,0.00,20000.00,0.00,0.00,'2022-05-27 17:42:23','',''),(1618,'21','220','1',1,'Sale Id shift 76',0.00,0.00,0.00,3648.99,0.00,'2022-05-28 16:49:07','',''),(1619,'21','220','3',2,'Sale Id shift 76',0.00,0.00,0.00,1972.66,0.00,'2022-05-28 16:49:07','',''),(1620,'21','220','4',3,'Sale Id shift 76',0.00,0.00,0.00,1245.51,0.00,'2022-05-28 16:49:07','',''),(1621,'21','220','1',1,'Sale Id shift 76',0.00,0.00,0.00,3377.15,0.00,'2022-05-28 16:49:07','',''),(1622,'21','220','1',1,'Sale Id shift 76',0.00,0.00,0.00,2232.47,0.00,'2022-05-28 16:49:07','',''),(1623,'21','220','1',1,'Sale Id shift 76',0.00,0.00,0.00,3893.64,0.00,'2022-05-28 16:49:07','',''),(1624,'21','220','2',1,'Sale Id shift 76',0.00,0.00,0.00,5160.46,0.00,'2022-05-28 16:49:07','',''),(1625,'21','220','2',1,'Sale Id shift 76',0.00,0.00,0.00,5097.83,0.00,'2022-05-28 16:49:07','',''),(1626,'21','220','2',1,'Sale Id shift 76',0.00,0.00,0.00,5082.04,0.00,'2022-05-28 16:49:07','',''),(1627,'21','220','1',1,'Sale Id shift 76',0.00,0.00,0.00,3502.87,0.00,'2022-05-28 16:49:07','',''),(1628,'21','220','2',1,'Sale Id shift 76',0.00,0.00,0.00,6783.06,0.00,'2022-05-28 16:49:07','',''),(1629,'21','220','2',1,'Sale Id shift 76',0.00,0.00,0.00,6261.13,0.00,'2022-05-28 16:49:07','',''),(1630,'21','220','2',1,'Sale Id shift 76',0.00,0.00,0.00,6334.16,0.00,'2022-05-28 16:49:07','',''),(1631,'21','220','2',1,'Sale Id shift 76',0.00,0.00,0.00,5577.69,0.00,'2022-05-28 16:49:07','',''),(1632,'21','220','1',1,'Sale Id shift 76',0.00,0.00,0.00,4270.99,0.00,'2022-05-28 16:49:07','',''),(1633,'21','220',NULL,1,'Sale Id shift 76',10101709.20,0.00,0.00,0.00,0.00,'2022-05-28 16:49:07','',''),(1634,'21','220',NULL,2,'Sale Id shift 76',1499221.60,0.00,0.00,0.00,0.00,'2022-05-28 16:49:07','',''),(1635,'21','220',NULL,3,'Sale Id shift 76',809581.50,0.00,0.00,0.00,0.00,'2022-05-28 16:49:07','',''),(1636,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-28 17:43:02','',''),(1637,'21','220',NULL,1,'Reception corrector for bridging 182',0.00,0.00,0.00,33000.00,0.00,'2022-05-28 17:46:01','',''),(1638,'21','220','2',1,'Received from bridging 182',0.00,0.00,33000.00,0.00,0.00,'2022-05-28 17:46:01','',''),(1639,'21','220',NULL,1,'Reception corrector for bridging 181',0.00,0.00,0.00,17000.00,0.00,'2022-05-28 17:46:01','',''),(1640,'21','220','1',1,'Received from bridging 181',0.00,0.00,17000.00,0.00,0.00,'2022-05-28 17:46:01','',''),(1641,'21','220','1',1,'Sale Id shift 77',0.00,0.00,0.00,3174.04,0.00,'2022-05-30 11:03:32','',''),(1642,'21','220','3',2,'Sale Id shift 77',0.00,0.00,0.00,605.01,0.00,'2022-05-30 11:03:32','',''),(1643,'21','220','4',3,'Sale Id shift 77',0.00,0.00,0.00,1090.92,0.00,'2022-05-30 11:03:32','',''),(1644,'21','220','1',1,'Sale Id shift 77',0.00,0.00,0.00,3542.65,0.00,'2022-05-30 11:03:32','',''),(1645,'21','220','1',1,'Sale Id shift 77',0.00,0.00,0.00,2776.05,0.00,'2022-05-30 11:03:32','',''),(1646,'21','220','1',1,'Sale Id shift 77',0.00,0.00,0.00,3553.10,0.00,'2022-05-30 11:03:32','',''),(1647,'21','220','2',1,'Sale Id shift 77',0.00,0.00,0.00,5357.88,0.00,'2022-05-30 11:03:32','',''),(1648,'21','220','2',1,'Sale Id shift 77',0.00,0.00,0.00,0.73,0.00,'2022-05-30 11:03:32','',''),(1649,'21','220','2',1,'Sale Id shift 77',0.00,0.00,0.00,5700.34,0.00,'2022-05-30 11:03:32','',''),(1650,'21','220','2',1,'Sale Id shift 77',0.00,0.00,0.00,5116.09,0.00,'2022-05-30 11:03:32','',''),(1651,'21','220','1',1,'Sale Id shift 77',0.00,0.00,0.00,3243.36,0.00,'2022-05-30 11:03:32','',''),(1652,'21','220','2',1,'Sale Id shift 77',0.00,0.00,0.00,7584.52,0.00,'2022-05-30 11:03:32','',''),(1653,'21','220','2',1,'Sale Id shift 77',0.00,0.00,0.00,6147.61,0.00,'2022-05-30 11:03:32','',''),(1654,'21','220','2',1,'Sale Id shift 77',0.00,0.00,0.00,5109.51,0.00,'2022-05-30 11:03:32','',''),(1655,'21','220','2',1,'Sale Id shift 77',0.00,0.00,0.00,5331.73,0.00,'2022-05-30 11:03:32','',''),(1656,'21','220','1',1,'Sale Id shift 77',0.00,0.00,0.00,5274.75,0.00,'2022-05-30 11:03:32','',''),(1657,'21','220',NULL,1,'Sale Id shift 77',10215539.40,0.00,0.00,0.00,0.00,'2022-05-30 11:03:33','',''),(1658,'21','220',NULL,2,'Sale Id shift 77',459807.60,0.00,0.00,0.00,0.00,'2022-05-30 11:03:33','',''),(1659,'21','220',NULL,3,'Sale Id shift 77',709098.00,0.00,0.00,0.00,0.00,'2022-05-30 11:03:33','',''),(1660,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,22800000.00,30000.00,0.00,0.00,'2022-05-30 11:14:21','',''),(1661,'21','220',NULL,2,'Reception corrector for bridging 183',0.00,0.00,0.00,30000.00,0.00,'2022-05-30 11:15:48','',''),(1662,'21','220','3',2,'Received from bridging 183',0.00,0.00,30000.00,0.00,0.00,'2022-05-30 11:15:48','',''),(1663,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-30 11:16:00','',''),(1664,'21','220',NULL,1,'Reception corrector for bridging 185',0.00,0.00,0.00,33500.00,0.00,'2022-05-30 11:18:06','',''),(1665,'21','220','2',1,'Received from bridging 185',0.00,0.00,33500.00,0.00,0.00,'2022-05-30 11:18:06','',''),(1666,'21','220',NULL,1,'Reception corrector for bridging 184',0.00,0.00,0.00,16500.00,0.00,'2022-05-30 11:18:06','',''),(1667,'21','220','1',1,'Received from bridging 184',0.00,0.00,16500.00,0.00,0.00,'2022-05-30 11:18:06','',''),(1668,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7458000.00,45200.00,0.00,0.00,'2022-05-30 13:14:05','',''),(1669,'21','220',NULL,1,'Reception corrector for bridging 187',0.00,0.00,0.00,15700.00,0.00,'2022-05-30 13:17:38','',''),(1670,'21','220','2',1,'Received from bridging 187',0.00,0.00,15700.00,0.00,0.00,'2022-05-30 13:17:38','',''),(1671,'21','220','2',1,'Returned bridging 187',0.00,0.00,0.00,15700.00,0.00,'2022-05-30 13:18:47','',''),(1672,'21','220',NULL,1,'Reception Return corrector for bridging 187',0.00,0.00,15700.00,0.00,0.00,'2022-05-30 13:18:47','',''),(1673,'21','220',NULL,1,'Reception corrector for bridging 188',0.00,0.00,0.00,15200.00,0.00,'2022-05-30 13:20:25','',''),(1674,'21','220','2',1,'Received from bridging 188',0.00,0.00,15200.00,0.00,0.00,'2022-05-30 13:20:25','',''),(1675,'21','220',NULL,1,'Reception corrector for bridging 186',0.00,0.00,0.00,30000.00,0.00,'2022-05-30 13:20:25','',''),(1676,'21','220','1',1,'Received from bridging 186',0.00,0.00,30000.00,0.00,0.00,'2022-05-30 13:20:25','',''),(1677,'21','220','1',1,'Sale Id shift 78',0.00,0.00,0.00,1534.81,0.00,'2022-05-30 17:25:57','',''),(1678,'21','220','3',2,'Sale Id shift 78',0.00,0.00,0.00,6081.16,0.00,'2022-05-30 17:25:57','',''),(1679,'21','220','4',3,'Sale Id shift 78',0.00,0.00,0.00,1213.14,0.00,'2022-05-30 17:25:57','',''),(1680,'21','220','1',1,'Sale Id shift 78',0.00,0.00,0.00,2073.72,0.00,'2022-05-30 17:25:57','',''),(1681,'21','220','1',1,'Sale Id shift 78',0.00,0.00,0.00,1373.37,0.00,'2022-05-30 17:25:57','',''),(1682,'21','220','1',1,'Sale Id shift 78',0.00,0.00,0.00,1613.85,0.00,'2022-05-30 17:25:57','',''),(1683,'21','220','2',1,'Sale Id shift 78',0.00,0.00,0.00,3182.67,0.00,'2022-05-30 17:25:57','',''),(1684,'21','220','2',1,'Sale Id shift 78',0.00,0.00,0.00,3192.83,0.00,'2022-05-30 17:25:57','',''),(1685,'21','220','2',1,'Sale Id shift 78',0.00,0.00,0.00,3102.05,0.00,'2022-05-30 17:25:57','',''),(1686,'21','220','2',1,'Sale Id shift 78',0.00,0.00,0.00,3310.27,0.00,'2022-05-30 17:25:57','',''),(1687,'21','220','1',1,'Sale Id shift 78',0.00,0.00,0.00,1507.68,0.00,'2022-05-30 17:25:57','',''),(1688,'21','220','2',1,'Sale Id shift 78',0.00,0.00,0.00,3268.63,0.00,'2022-05-30 17:25:57','',''),(1689,'21','220','2',1,'Sale Id shift 78',0.00,0.00,0.00,3602.08,0.00,'2022-05-30 17:25:57','',''),(1690,'21','220','2',1,'Sale Id shift 78',0.00,0.00,0.00,3568.77,0.00,'2022-05-30 17:25:57','',''),(1691,'21','220','2',1,'Sale Id shift 78',0.00,0.00,0.00,3531.03,0.00,'2022-05-30 17:25:57','',''),(1692,'21','220','1',1,'Sale Id shift 78',0.00,0.00,0.00,2325.99,0.00,'2022-05-30 17:25:57','',''),(1693,'21','220',NULL,1,'Sale Id shift 78',6135978.75,0.00,0.00,0.00,0.00,'2022-05-30 17:25:57','',''),(1694,'21','220',NULL,2,'Sale Id shift 78',4621681.60,0.00,0.00,0.00,0.00,'2022-05-30 17:25:57','',''),(1695,'21','220',NULL,3,'Sale Id shift 78',788541.00,0.00,0.00,0.00,0.00,'2022-05-30 17:25:57','',''),(1696,'21','220','1',1,'Sale Id shift 79',0.00,0.00,0.00,3370.49,0.00,'2022-05-31 17:46:40','',''),(1697,'21','220','3',2,'Sale Id shift 79',0.00,0.00,0.00,2537.64,0.00,'2022-05-31 17:46:40','',''),(1698,'21','220','4',3,'Sale Id shift 79',0.00,0.00,0.00,959.34,0.00,'2022-05-31 17:46:40','',''),(1699,'21','220','1',1,'Sale Id shift 79',0.00,0.00,0.00,3287.86,0.00,'2022-05-31 17:46:40','',''),(1700,'21','220','1',1,'Sale Id shift 79',0.00,0.00,0.00,2362.97,0.00,'2022-05-31 17:46:40','',''),(1701,'21','220','1',1,'Sale Id shift 79',0.00,0.00,0.00,4242.19,0.00,'2022-05-31 17:46:40','',''),(1702,'21','220','2',1,'Sale Id shift 79',0.00,0.00,0.00,4694.51,0.00,'2022-05-31 17:46:40','',''),(1703,'21','220','2',1,'Sale Id shift 79',0.00,0.00,0.00,3966.10,0.00,'2022-05-31 17:46:40','',''),(1704,'21','220','2',1,'Sale Id shift 79',0.00,0.00,0.00,4107.63,0.00,'2022-05-31 17:46:40','',''),(1705,'21','220','2',1,'Sale Id shift 79',0.00,0.00,0.00,4105.99,0.00,'2022-05-31 17:46:40','',''),(1706,'21','220','1',1,'Sale Id shift 79',0.00,0.00,0.00,2633.32,0.00,'2022-05-31 17:46:40','',''),(1707,'21','220','2',1,'Sale Id shift 79',0.00,0.00,0.00,4019.02,0.00,'2022-05-31 17:46:40','',''),(1708,'21','220','2',1,'Sale Id shift 79',0.00,0.00,0.00,4480.72,0.00,'2022-05-31 17:46:40','',''),(1709,'21','220','2',1,'Sale Id shift 79',0.00,0.00,0.00,4427.75,0.00,'2022-05-31 17:46:40','',''),(1710,'21','220','2',1,'Sale Id shift 79',0.00,0.00,0.00,3201.65,0.00,'2022-05-31 17:46:40','',''),(1711,'21','220','1',1,'Sale Id shift 79',0.00,0.00,0.00,5225.33,0.00,'2022-05-31 17:46:40','',''),(1712,'21','220',NULL,1,'Sale Id shift 79',8930712.45,0.00,0.00,0.00,0.00,'2022-05-31 17:46:40','',''),(1713,'21','220',NULL,2,'Sale Id shift 79',1928606.40,0.00,0.00,0.00,0.00,'2022-05-31 17:46:40','',''),(1714,'21','220',NULL,3,'Sale Id shift 79',623571.00,0.00,0.00,0.00,0.00,'2022-05-31 17:46:40','',''),(1715,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-31 18:19:59','',''),(1716,'21','220',NULL,1,'Reception corrector for bridging 190',0.00,0.00,0.00,29500.00,0.00,'2022-05-31 18:23:58','',''),(1717,'21','220','2',1,'Received from bridging 190',0.00,0.00,29500.00,0.00,0.00,'2022-05-31 18:23:58','',''),(1718,'21','220',NULL,1,'Reception corrector for bridging 189',0.00,0.00,0.00,15500.00,0.00,'2022-05-31 18:23:58','',''),(1719,'21','220','1',1,'Received from bridging 189',0.00,0.00,15500.00,0.00,0.00,'2022-05-31 18:23:58','',''),(1720,'21','220','1',1,'Sale Id shift 80',0.00,0.00,0.00,4905.14,0.00,'2022-06-01 20:46:51','',''),(1721,'21','220','3',2,'Sale Id shift 80',0.00,0.00,0.00,7276.06,0.00,'2022-06-01 20:46:51','',''),(1722,'21','220','4',3,'Sale Id shift 80',0.00,0.00,0.00,3506.08,0.00,'2022-06-01 20:46:51','',''),(1723,'21','220','1',1,'Sale Id shift 80',0.00,0.00,0.00,4231.45,0.00,'2022-06-01 20:46:51','',''),(1724,'21','220','1',1,'Sale Id shift 80',0.00,0.00,0.00,3087.47,0.00,'2022-06-01 20:46:51','',''),(1725,'21','220','1',1,'Sale Id shift 80',0.00,0.00,0.00,5238.74,0.00,'2022-06-01 20:46:51','',''),(1726,'21','220','2',1,'Sale Id shift 80',0.00,0.00,0.00,2884.59,0.00,'2022-06-01 20:46:51','',''),(1727,'21','220','2',1,'Sale Id shift 80',0.00,0.00,0.00,1389.96,0.00,'2022-06-01 20:46:51','',''),(1728,'21','220','2',1,'Sale Id shift 80',0.00,0.00,0.00,2480.91,0.00,'2022-06-01 20:46:51','',''),(1729,'21','220','2',1,'Sale Id shift 80',0.00,0.00,0.00,2679.13,0.00,'2022-06-01 20:46:51','',''),(1730,'21','220','1',1,'Sale Id shift 80',0.00,0.00,0.00,3923.70,0.00,'2022-06-01 20:46:51','',''),(1731,'21','220','2',1,'Sale Id shift 80',0.00,0.00,0.00,3590.19,0.00,'2022-06-01 20:46:51','',''),(1732,'21','220','2',1,'Sale Id shift 80',0.00,0.00,0.00,2449.07,0.00,'2022-06-01 20:46:51','',''),(1733,'21','220','2',1,'Sale Id shift 80',0.00,0.00,0.00,2345.76,0.00,'2022-06-01 20:46:51','',''),(1734,'21','220','2',1,'Sale Id shift 80',0.00,0.00,0.00,1636.64,0.00,'2022-06-01 20:46:51','',''),(1735,'21','220','1',1,'Sale Id shift 80',0.00,0.00,0.00,6176.55,0.00,'2022-06-01 20:46:51','',''),(1736,'21','220',NULL,1,'Sale Id shift 80',7758184.50,0.00,0.00,0.00,0.00,'2022-06-01 20:46:51','',''),(1737,'21','220',NULL,2,'Sale Id shift 80',5529805.60,0.00,0.00,0.00,0.00,'2022-06-01 20:46:51','',''),(1738,'21','220',NULL,3,'Sale Id shift 80',2278952.00,0.00,0.00,0.00,0.00,'2022-06-01 20:46:51','',''),(1739,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-01 21:44:07','',''),(1740,'21','220',NULL,1,'Reception corrector for bridging 192',0.00,0.00,0.00,30000.00,0.00,'2022-06-01 21:47:08','',''),(1741,'21','220','2',1,'Received from bridging 192',0.00,0.00,30000.00,0.00,0.00,'2022-06-01 21:47:08','',''),(1742,'21','220',NULL,1,'Reception corrector for bridging 191',0.00,0.00,0.00,15000.00,0.00,'2022-06-01 21:47:08','',''),(1743,'21','220','1',1,'Received from bridging 191',0.00,0.00,15000.00,0.00,0.00,'2022-06-01 21:47:08','',''),(1744,'21','220','1',1,'Sale Id shift 81',0.00,0.00,0.00,1701.22,0.00,'2022-06-02 10:28:16','',''),(1745,'21','220','3',2,'Sale Id shift 81',0.00,0.00,0.00,12434.30,0.00,'2022-06-02 10:28:16','',''),(1746,'21','220','4',3,'Sale Id shift 81',0.00,0.00,0.00,4708.39,0.00,'2022-06-02 10:28:16','',''),(1747,'21','220','1',1,'Sale Id shift 81',0.00,0.00,0.00,2878.78,0.00,'2022-06-02 10:28:16','',''),(1748,'21','220','1',1,'Sale Id shift 81',0.00,0.00,0.00,1972.71,0.00,'2022-06-02 10:28:16','',''),(1749,'21','220','1',1,'Sale Id shift 81',0.00,0.00,0.00,3817.74,0.00,'2022-06-02 10:28:16','',''),(1750,'21','220','2',1,'Sale Id shift 81',0.00,0.00,0.00,3595.59,0.00,'2022-06-02 10:28:16','',''),(1751,'21','220','2',1,'Sale Id shift 81',0.00,0.00,0.00,4126.21,0.00,'2022-06-02 10:28:16','',''),(1752,'21','220','2',1,'Sale Id shift 81',0.00,0.00,0.00,3550.98,0.00,'2022-06-02 10:28:16','',''),(1753,'21','220','2',1,'Sale Id shift 81',0.00,0.00,0.00,3351.79,0.00,'2022-06-02 10:28:16','',''),(1754,'21','220','1',1,'Sale Id shift 81',0.00,0.00,0.00,4202.03,0.00,'2022-06-02 10:28:16','',''),(1755,'21','220','2',1,'Sale Id shift 81',0.00,0.00,0.00,5102.48,0.00,'2022-06-02 10:28:16','',''),(1756,'21','220','2',1,'Sale Id shift 81',0.00,0.00,0.00,3019.00,0.00,'2022-06-02 10:28:16','',''),(1757,'21','220','2',1,'Sale Id shift 81',0.00,0.00,0.00,4268.15,0.00,'2022-06-02 10:28:16','',''),(1758,'21','220','2',1,'Sale Id shift 81',0.00,0.00,0.00,3987.47,0.00,'2022-06-02 10:28:16','',''),(1759,'21','220','1',1,'Sale Id shift 81',0.00,0.00,0.00,4140.28,0.00,'2022-06-02 10:28:16','',''),(1760,'21','220','3',2,'Sale Id shift 81',0.00,0.00,0.00,1592.98,0.00,'2022-06-02 10:28:16','',''),(1761,'21','220',NULL,2,'Sale Id shift 81',10660732.80,0.00,0.00,0.00,0.00,'2022-06-02 10:28:16','',''),(1762,'21','220',NULL,3,'Sale Id shift 81',3060453.50,0.00,0.00,0.00,0.00,'2022-06-02 10:28:16','',''),(1763,'21','220',NULL,1,'Sale Id shift 81',8202880.95,0.00,0.00,0.00,0.00,'2022-06-02 10:28:16','',''),(1764,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-03 17:39:55','',''),(1765,'21','220',NULL,1,'Reception corrector for bridging 194',0.00,0.00,0.00,30000.00,0.00,'2022-06-03 17:50:33','',''),(1766,'21','220','2',1,'Received from bridging 194',0.00,0.00,30000.00,0.00,0.00,'2022-06-03 17:50:33','',''),(1767,'21','220',NULL,1,'Reception corrector for bridging 193',0.00,0.00,0.00,15000.00,0.00,'2022-06-03 17:50:33','',''),(1768,'21','220','1',1,'Received from bridging 193',0.00,0.00,15000.00,0.00,0.00,'2022-06-03 17:50:33','',''),(1769,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,13300000.00,17500.00,0.00,0.00,'2022-06-03 17:58:24','',''),(1770,'21','220',NULL,2,'Reception corrector for bridging 195',0.00,0.00,0.00,17500.00,0.00,'2022-06-03 18:03:30','',''),(1771,'21','220','3',2,'Received from bridging 195',0.00,0.00,17500.00,0.00,0.00,'2022-06-03 18:03:30','',''),(1772,'21','220','1',1,'Sale Id shift 82',0.00,0.00,0.00,1800.90,0.00,'2022-06-04 13:37:33','',''),(1773,'21','220','3',2,'Sale Id shift 82',0.00,0.00,0.00,552.63,0.00,'2022-06-04 13:37:33','',''),(1774,'21','220','1',1,'Sale Id shift 82',0.00,0.00,0.00,1709.09,0.00,'2022-06-04 13:37:33','',''),(1775,'21','220','1',1,'Sale Id shift 82',0.00,0.00,0.00,1067.38,0.00,'2022-06-04 13:37:33','',''),(1776,'21','220','1',1,'Sale Id shift 82',0.00,0.00,0.00,18.09,0.00,'2022-06-04 13:37:33','',''),(1777,'21','220','1',1,'Sale Id shift 82',0.00,0.00,0.00,1931.59,0.00,'2022-06-04 13:37:33','',''),(1778,'21','220','2',1,'Sale Id shift 82',0.00,0.00,0.00,3200.92,0.00,'2022-06-04 13:37:33','',''),(1779,'21','220','2',1,'Sale Id shift 82',0.00,0.00,0.00,2466.06,0.00,'2022-06-04 13:37:33','',''),(1780,'21','220','2',1,'Sale Id shift 82',0.00,0.00,0.00,3003.17,0.00,'2022-06-04 13:37:33','',''),(1781,'21','220','2',1,'Sale Id shift 82',0.00,0.00,0.00,2502.81,0.00,'2022-06-04 13:37:33','',''),(1782,'21','220','1',1,'Sale Id shift 82',0.00,0.00,0.00,1062.08,0.00,'2022-06-04 13:37:33','',''),(1783,'21','220','2',1,'Sale Id shift 82',0.00,0.00,0.00,3699.22,0.00,'2022-06-04 13:37:33','',''),(1784,'21','220','2',1,'Sale Id shift 82',0.00,0.00,0.00,2985.41,0.00,'2022-06-04 13:37:33','',''),(1785,'21','220','2',1,'Sale Id shift 82',0.00,0.00,0.00,2351.06,0.00,'2022-06-04 13:37:33','',''),(1786,'21','220','2',1,'Sale Id shift 82',0.00,0.00,0.00,3336.86,0.00,'2022-06-04 13:37:33','',''),(1787,'21','220','1',1,'Sale Id shift 82',0.00,0.00,0.00,3633.28,0.00,'2022-06-04 13:37:33','',''),(1788,'21','220',NULL,1,'Sale Id shift 82',5736706.80,0.00,0.00,0.00,0.00,'2022-06-04 13:37:33','',''),(1789,'21','220',NULL,2,'Sale Id shift 82',419998.80,0.00,0.00,0.00,0.00,'2022-06-04 13:37:33','',''),(1790,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-04 18:31:45','',''),(1791,'21','220',NULL,1,'Reception corrector for bridging 197',0.00,0.00,0.00,29500.00,0.00,'2022-06-04 18:36:13','',''),(1792,'21','220','2',1,'Received from bridging 197',0.00,0.00,29500.00,0.00,0.00,'2022-06-04 18:36:13','',''),(1793,'21','220',NULL,1,'Reception corrector for bridging 196',0.00,0.00,0.00,15500.00,0.00,'2022-06-04 18:36:13','',''),(1794,'21','220','1',1,'Received from bridging 196',0.00,0.00,15500.00,0.00,0.00,'2022-06-04 18:36:13','',''),(1795,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-05 18:44:44','',''),(1796,'21','220',NULL,1,'Reception corrector for bridging 199',0.00,0.00,0.00,33000.00,0.00,'2022-06-05 18:46:10','',''),(1797,'21','220','2',1,'Received from bridging 199',0.00,0.00,33000.00,0.00,0.00,'2022-06-05 18:46:10','',''),(1798,'21','220',NULL,1,'Reception corrector for bridging 198',0.00,0.00,0.00,17000.00,0.00,'2022-06-05 18:46:10','',''),(1799,'21','220','1',1,'Received from bridging 198',0.00,0.00,17000.00,0.00,0.00,'2022-06-05 18:46:10','',''),(1800,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,22800000.00,30000.00,0.00,0.00,'2022-06-05 18:48:23','',''),(1801,'21','220','1',1,'Sale Id shift 83',0.00,0.00,0.00,3167.69,0.00,'2022-06-05 19:36:36','',''),(1802,'21','220','3',2,'Sale Id shift 83',0.00,0.00,0.00,10064.73,0.00,'2022-06-05 19:36:36','',''),(1803,'21','220','1',1,'Sale Id shift 83',0.00,0.00,0.00,4203.61,0.00,'2022-06-05 19:36:36','',''),(1804,'21','220','1',1,'Sale Id shift 83',0.00,0.00,0.00,21.76,0.00,'2022-06-05 19:36:36','',''),(1805,'21','220','1',1,'Sale Id shift 83',0.00,0.00,0.00,3353.57,0.00,'2022-06-05 19:36:36','',''),(1806,'21','220','2',1,'Sale Id shift 83',0.00,0.00,0.00,4161.69,0.00,'2022-06-05 19:36:36','',''),(1807,'21','220','2',1,'Sale Id shift 83',0.00,0.00,0.00,4223.82,0.00,'2022-06-05 19:36:36','',''),(1808,'21','220','2',1,'Sale Id shift 83',0.00,0.00,0.00,3598.70,0.00,'2022-06-05 19:36:36','',''),(1809,'21','220','2',1,'Sale Id shift 83',0.00,0.00,0.00,3453.92,0.00,'2022-06-05 19:36:36','',''),(1810,'21','220','1',1,'Sale Id shift 83',0.00,0.00,0.00,3038.50,0.00,'2022-06-05 19:36:36','',''),(1811,'21','220','2',1,'Sale Id shift 83',0.00,0.00,0.00,5381.58,0.00,'2022-06-05 19:36:36','',''),(1812,'21','220','2',1,'Sale Id shift 83',0.00,0.00,0.00,3652.85,0.00,'2022-06-05 19:36:36','',''),(1813,'21','220','2',1,'Sale Id shift 83',0.00,0.00,0.00,3701.59,0.00,'2022-06-05 19:36:36','',''),(1814,'21','220','2',1,'Sale Id shift 83',0.00,0.00,0.00,3928.32,0.00,'2022-06-05 19:36:36','',''),(1815,'21','220','1',1,'Sale Id shift 83',0.00,0.00,0.00,6088.92,0.00,'2022-06-05 19:36:36','',''),(1816,'21','220','3',2,'Sale Id shift 83',0.00,0.00,0.00,167.13,0.00,'2022-06-05 19:36:36','',''),(1817,'21','220',NULL,2,'Sale Id shift 83',7776213.60,0.00,0.00,0.00,0.00,'2022-06-05 19:36:36','',''),(1818,'21','220',NULL,1,'Sale Id shift 83',8576125.80,0.00,0.00,0.00,0.00,'2022-06-05 19:36:36','',''),(1819,'21','220','1',1,'Sale Id shift 84',0.00,0.00,0.00,2878.63,0.00,'2022-06-06 17:13:04','',''),(1820,'21','220','3',2,'Sale Id shift 84',0.00,0.00,0.00,7908.26,0.00,'2022-06-06 17:13:04','',''),(1821,'21','220','1',1,'Sale Id shift 84',0.00,0.00,0.00,3571.70,0.00,'2022-06-06 17:13:04','',''),(1822,'21','220','1',1,'Sale Id shift 84',0.00,0.00,0.00,3824.57,0.00,'2022-06-06 17:13:04','',''),(1823,'21','220','2',1,'Sale Id shift 84',0.00,0.00,0.00,4463.08,0.00,'2022-06-06 17:13:04','',''),(1824,'21','220','2',1,'Sale Id shift 84',0.00,0.00,0.00,3944.18,0.00,'2022-06-06 17:13:04','',''),(1825,'21','220','2',1,'Sale Id shift 84',0.00,0.00,0.00,4327.31,0.00,'2022-06-06 17:13:04','',''),(1826,'21','220','2',1,'Sale Id shift 84',0.00,0.00,0.00,3112.66,0.00,'2022-06-06 17:13:04','',''),(1827,'21','220','1',1,'Sale Id shift 84',0.00,0.00,0.00,2713.21,0.00,'2022-06-06 17:13:04','',''),(1828,'21','220','2',1,'Sale Id shift 84',0.00,0.00,0.00,5564.23,0.00,'2022-06-06 17:13:04','',''),(1829,'21','220','2',1,'Sale Id shift 84',0.00,0.00,0.00,3924.75,0.00,'2022-06-06 17:13:04','',''),(1830,'21','220','2',1,'Sale Id shift 84',0.00,0.00,0.00,4482.24,0.00,'2022-06-06 17:13:04','',''),(1831,'21','220','2',1,'Sale Id shift 84',0.00,0.00,0.00,3987.45,0.00,'2022-06-06 17:13:04','',''),(1832,'21','220','1',1,'Sale Id shift 84',0.00,0.00,0.00,4097.71,0.00,'2022-06-06 17:13:04','',''),(1833,'21','220',NULL,1,'Sale Id shift 84',8397133.80,0.00,0.00,0.00,0.00,'2022-06-06 17:13:04','',''),(1834,'21','220',NULL,2,'Sale Id shift 84',6010277.60,0.00,0.00,0.00,0.00,'2022-06-06 17:13:04','',''),(1835,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,22800000.00,30000.00,0.00,0.00,'2022-06-06 18:55:37','',''),(1836,'21','220',NULL,2,'Reception corrector for bridging 200',0.00,0.00,0.00,30000.00,0.00,'2022-06-06 18:59:56','',''),(1837,'21','220','3',2,'Received from bridging 200',0.00,0.00,30000.00,0.00,0.00,'2022-06-06 18:59:56','',''),(1838,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-06 19:53:39','',''),(1839,'21','220',NULL,1,'Reception corrector for bridging 203',0.00,0.00,0.00,30000.00,0.00,'2022-06-06 20:03:13','',''),(1840,'21','220','2',1,'Received from bridging 203',0.00,0.00,30000.00,0.00,0.00,'2022-06-06 20:03:13','',''),(1841,'21','220',NULL,1,'Reception corrector for bridging 202',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 20:03:13','',''),(1842,'21','220','1',1,'Received from bridging 202',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 20:03:13','',''),(1843,'21','220','1',1,'Sale Id shift 85',0.00,0.00,0.00,3852.95,0.00,'2022-06-08 14:28:39','',''),(1844,'21','220','3',2,'Sale Id shift 85',0.00,0.00,0.00,444.78,0.00,'2022-06-08 14:28:39','',''),(1845,'21','220','1',1,'Sale Id shift 85',0.00,0.00,0.00,2813.58,0.00,'2022-06-08 14:28:39','',''),(1846,'21','220','1',1,'Sale Id shift 85',0.00,0.00,0.00,3241.89,0.00,'2022-06-08 14:28:39','',''),(1847,'21','220','2',1,'Sale Id shift 85',0.00,0.00,0.00,4751.62,0.00,'2022-06-08 14:28:39','',''),(1848,'21','220','2',1,'Sale Id shift 85',0.00,0.00,0.00,4306.08,0.00,'2022-06-08 14:28:39','',''),(1849,'21','220','2',1,'Sale Id shift 85',0.00,0.00,0.00,3727.29,0.00,'2022-06-08 14:28:39','',''),(1850,'21','220','2',1,'Sale Id shift 85',0.00,0.00,0.00,4236.47,0.00,'2022-06-08 14:28:39','',''),(1851,'21','220','1',1,'Sale Id shift 85',0.00,0.00,0.00,3282.29,0.00,'2022-06-08 14:28:39','',''),(1852,'21','220','2',1,'Sale Id shift 85',0.00,0.00,0.00,5855.72,0.00,'2022-06-08 14:28:39','',''),(1853,'21','220','2',1,'Sale Id shift 85',0.00,0.00,0.00,2541.26,0.00,'2022-06-08 14:28:39','',''),(1854,'21','220','2',1,'Sale Id shift 85',0.00,0.00,0.00,3815.23,0.00,'2022-06-08 14:28:39','',''),(1855,'21','220','2',1,'Sale Id shift 85',0.00,0.00,0.00,4210.60,0.00,'2022-06-08 14:28:39','',''),(1856,'21','220','1',1,'Sale Id shift 85',0.00,0.00,0.00,4473.76,0.00,'2022-06-08 14:28:39','',''),(1857,'21','220',NULL,1,'Sale Id shift 85',8432942.10,0.00,0.00,0.00,0.00,'2022-06-08 14:28:39','',''),(1858,'21','220',NULL,2,'Sale Id shift 85',338032.80,0.00,0.00,0.00,0.00,'2022-06-08 14:28:39','',''),(1859,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-08 15:04:48','',''),(1860,'21','220',NULL,1,'Reception corrector for bridging 205',0.00,0.00,0.00,30000.00,0.00,'2022-06-08 15:09:00','',''),(1861,'21','220','2',1,'Received from bridging 205',0.00,0.00,30000.00,0.00,0.00,'2022-06-08 15:09:00','',''),(1862,'21','220',NULL,1,'Reception corrector for bridging 204',0.00,0.00,0.00,15000.00,0.00,'2022-06-08 15:09:00','',''),(1863,'21','220','1',1,'Received from bridging 204',0.00,0.00,15000.00,0.00,0.00,'2022-06-08 15:09:00','',''),(1864,'21','220',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,10400000.00,16000.00,0.00,0.00,'2022-06-08 15:17:00','',''),(1865,'21','220',NULL,3,'Reception corrector for bridging 208',0.00,0.00,0.00,16000.00,0.00,'2022-06-08 15:22:16','',''),(1866,'21','220','4',3,'Received from bridging 208',0.00,0.00,16000.00,0.00,0.00,'2022-06-08 15:22:16','',''),(1867,'21','220','1',1,'Sale Id shift 86',0.00,0.00,0.00,2982.00,0.00,'2022-06-08 15:23:48','',''),(1868,'21','220','3',2,'Sale Id shift 86',0.00,0.00,0.00,3693.17,0.00,'2022-06-08 15:23:48','',''),(1869,'21','220','4',3,'Sale Id shift 86',0.00,0.00,0.00,545.67,0.00,'2022-06-08 15:23:48','',''),(1870,'21','220','1',1,'Sale Id shift 86',0.00,0.00,0.00,2711.09,0.00,'2022-06-08 15:23:48','',''),(1871,'21','220','1',1,'Sale Id shift 86',0.00,0.00,0.00,3429.36,0.00,'2022-06-08 15:23:48','',''),(1872,'21','220','2',1,'Sale Id shift 86',0.00,0.00,0.00,3984.54,0.00,'2022-06-08 15:23:48','',''),(1873,'21','220','2',1,'Sale Id shift 86',0.00,0.00,0.00,2859.11,0.00,'2022-06-08 15:23:48','',''),(1874,'21','220','2',1,'Sale Id shift 86',0.00,0.00,0.00,4267.57,0.00,'2022-06-08 15:23:48','',''),(1875,'21','220','2',1,'Sale Id shift 86',0.00,0.00,0.00,2277.37,0.00,'2022-06-08 15:23:48','',''),(1876,'21','220','1',1,'Sale Id shift 86',0.00,0.00,0.00,1377.43,0.00,'2022-06-08 15:23:48','',''),(1877,'21','220','2',1,'Sale Id shift 86',0.00,0.00,0.00,5044.22,0.00,'2022-06-08 15:23:48','',''),(1878,'21','220','2',1,'Sale Id shift 86',0.00,0.00,0.00,2444.66,0.00,'2022-06-08 15:23:48','',''),(1879,'21','220','2',1,'Sale Id shift 86',0.00,0.00,0.00,4196.10,0.00,'2022-06-08 15:23:48','',''),(1880,'21','220','2',1,'Sale Id shift 86',0.00,0.00,0.00,3612.19,0.00,'2022-06-08 15:23:48','',''),(1881,'21','220','1',1,'Sale Id shift 86',0.00,0.00,0.00,3485.09,0.00,'2022-06-08 15:23:48','',''),(1882,'21','220',NULL,1,'Sale Id shift 86',7040670.45,0.00,0.00,0.00,0.00,'2022-06-08 15:23:48','',''),(1883,'21','220',NULL,2,'Sale Id shift 86',2806809.20,0.00,0.00,0.00,0.00,'2022-06-08 15:23:48','',''),(1884,'21','220',NULL,3,'Sale Id shift 86',354685.50,0.00,0.00,0.00,0.00,'2022-06-08 15:23:48','',''),(1885,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-13 14:15:55','',''),(1886,'21','220',NULL,1,'Reception corrector for bridging 210',0.00,0.00,0.00,33500.00,0.00,'2022-06-13 14:18:59','',''),(1887,'21','220','2',1,'Received from bridging 210',0.00,0.00,33500.00,0.00,0.00,'2022-06-13 14:18:59','',''),(1888,'21','220',NULL,1,'Reception corrector for bridging 209',0.00,0.00,0.00,16500.00,0.00,'2022-06-13 14:18:59','',''),(1889,'21','220','1',1,'Received from bridging 209',0.00,0.00,16500.00,0.00,0.00,'2022-06-13 14:18:59','',''),(1890,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-13 14:20:41','',''),(1891,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,22800000.00,30000.00,0.00,0.00,'2022-06-13 14:24:31','',''),(1892,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-13 14:29:34','',''),(1893,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-13 14:33:29','',''),(1894,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-13 14:37:50','',''),(1895,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-13 14:41:40','',''),(1896,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,22800000.00,30000.00,0.00,0.00,'2022-06-13 14:44:17','',''),(1897,'21','220','1',1,'Sale Id shift 87',0.00,0.00,0.00,1331.76,0.00,'2022-06-13 15:54:12','',''),(1898,'21','220','3',2,'Sale Id shift 87',0.00,0.00,0.00,8939.99,0.00,'2022-06-13 15:54:12','',''),(1899,'21','220','4',3,'Sale Id shift 87',0.00,0.00,0.00,4195.04,0.00,'2022-06-13 15:54:12','',''),(1900,'21','220','1',1,'Sale Id shift 87',0.00,0.00,0.00,1736.40,0.00,'2022-06-13 15:54:12','',''),(1901,'21','220','1',1,'Sale Id shift 87',0.00,0.00,0.00,2144.52,0.00,'2022-06-13 15:54:12','',''),(1902,'21','220','2',1,'Sale Id shift 87',0.00,0.00,0.00,2998.07,0.00,'2022-06-13 15:54:12','',''),(1903,'21','220','2',1,'Sale Id shift 87',0.00,0.00,0.00,2309.44,0.00,'2022-06-13 15:54:12','',''),(1904,'21','220','2',1,'Sale Id shift 87',0.00,0.00,0.00,2360.25,0.00,'2022-06-13 15:54:12','',''),(1905,'21','220','2',1,'Sale Id shift 87',0.00,0.00,0.00,2980.56,0.00,'2022-06-13 15:54:12','',''),(1906,'21','220','1',1,'Sale Id shift 87',0.00,0.00,0.00,1788.63,0.00,'2022-06-13 15:54:12','',''),(1907,'21','220','2',1,'Sale Id shift 87',0.00,0.00,0.00,2808.85,0.00,'2022-06-13 15:54:12','',''),(1908,'21','220','2',1,'Sale Id shift 87',0.00,0.00,0.00,2320.74,0.00,'2022-06-13 15:54:12','',''),(1909,'21','220','2',1,'Sale Id shift 87',0.00,0.00,0.00,2269.71,0.00,'2022-06-13 15:54:12','',''),(1910,'21','220','2',1,'Sale Id shift 87',0.00,0.00,0.00,2743.67,0.00,'2022-06-13 15:54:12','',''),(1911,'21','220','1',1,'Sale Id shift 87',0.00,0.00,0.00,2316.43,0.00,'2022-06-13 15:54:12','',''),(1912,'21','220','3',2,'Sale Id shift 87',0.00,0.00,0.00,6078.53,0.00,'2022-06-13 15:54:12','',''),(1913,'21','220',NULL,1,'Sale Id shift 87',4967989.95,0.00,0.00,0.00,0.00,'2022-06-13 15:54:12','',''),(1914,'21','220',NULL,2,'Sale Id shift 87',11414075.20,0.00,0.00,0.00,0.00,'2022-06-13 15:54:12','',''),(1915,'21','220',NULL,3,'Sale Id shift 87',2726776.00,0.00,0.00,0.00,0.00,'2022-06-13 15:54:12','',''),(1916,'21','220',NULL,1,'Reception corrector for bridging 212',0.00,0.00,0.00,16000.00,0.00,'2022-06-13 16:37:54','',''),(1917,'21','220','2',1,'Received from bridging 212',0.00,0.00,16000.00,0.00,0.00,'2022-06-13 16:37:54','',''),(1918,'21','220',NULL,1,'Reception corrector for bridging 211',0.00,0.00,0.00,33000.00,0.00,'2022-06-13 16:37:54','',''),(1919,'21','220','1',1,'Received from bridging 211',0.00,0.00,33000.00,0.00,0.00,'2022-06-13 16:37:54','',''),(1920,'21','220','1',1,'Sale Id shift 88',0.00,0.00,0.00,2691.06,0.00,'2022-06-13 17:05:12','',''),(1921,'21','220','3',2,'Sale Id shift 88',0.00,0.00,0.00,9048.50,0.00,'2022-06-13 17:05:12','',''),(1922,'21','220','4',3,'Sale Id shift 88',0.00,0.00,0.00,5515.08,0.00,'2022-06-13 17:05:12','',''),(1923,'21','220','1',1,'Sale Id shift 88',0.00,0.00,0.00,3038.79,0.00,'2022-06-13 17:05:12','',''),(1924,'21','220','1',1,'Sale Id shift 88',0.00,0.00,0.00,2590.49,0.00,'2022-06-13 17:05:12','',''),(1925,'21','220','2',1,'Sale Id shift 88',0.00,0.00,0.00,3524.43,0.00,'2022-06-13 17:05:12','',''),(1926,'21','220','2',1,'Sale Id shift 88',0.00,0.00,0.00,2205.22,0.00,'2022-06-13 17:05:12','',''),(1927,'21','220','2',1,'Sale Id shift 88',0.00,0.00,0.00,2715.67,0.00,'2022-06-13 17:05:12','',''),(1928,'21','220','2',1,'Sale Id shift 88',0.00,0.00,0.00,2464.92,0.00,'2022-06-13 17:05:12','',''),(1929,'21','220','1',1,'Sale Id shift 88',0.00,0.00,0.00,2599.37,0.00,'2022-06-13 17:05:12','',''),(1930,'21','220','2',1,'Sale Id shift 88',0.00,0.00,0.00,3708.46,0.00,'2022-06-13 17:05:12','',''),(1931,'21','220','2',1,'Sale Id shift 88',0.00,0.00,0.00,2104.29,0.00,'2022-06-13 17:05:12','',''),(1932,'21','220','2',1,'Sale Id shift 88',0.00,0.00,0.00,2551.45,0.00,'2022-06-13 17:05:12','',''),(1933,'21','220','2',1,'Sale Id shift 88',0.00,0.00,0.00,2056.11,0.00,'2022-06-13 17:05:12','',''),(1934,'21','220','1',1,'Sale Id shift 88',0.00,0.00,0.00,3340.97,0.00,'2022-06-13 17:05:12','',''),(1935,'21','220',NULL,1,'Sale Id shift 88',5872552.95,0.00,0.00,0.00,0.00,'2022-06-13 17:05:12','',''),(1936,'21','220',NULL,2,'Sale Id shift 88',6876860.00,0.00,0.00,0.00,0.00,'2022-06-13 17:05:12','',''),(1937,'21','220',NULL,3,'Sale Id shift 88',3584802.00,0.00,0.00,0.00,0.00,'2022-06-13 17:05:12','',''),(1938,'21','220',NULL,1,'Reception corrector for bridging 217',0.00,0.00,0.00,30000.00,0.00,'2022-06-13 17:36:05','',''),(1939,'21','220','2',1,'Received from bridging 217',0.00,0.00,30000.00,0.00,0.00,'2022-06-13 17:36:05','',''),(1940,'21','220',NULL,1,'Reception corrector for bridging 216',0.00,0.00,0.00,20000.00,0.00,'2022-06-13 17:36:06','',''),(1941,'21','220','1',1,'Received from bridging 216',0.00,0.00,20000.00,0.00,0.00,'2022-06-13 17:36:06','',''),(1942,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,23400000.00,30000.00,0.00,0.00,'2022-06-13 17:44:08','',''),(1943,'21','220',NULL,2,'Reception corrector for bridging 223',0.00,0.00,0.00,30000.00,0.00,'2022-06-13 18:06:35','',''),(1944,'21','220','3',2,'Received from bridging 223',0.00,0.00,30000.00,0.00,0.00,'2022-06-13 18:06:35','',''),(1945,'21','220','1',1,'Sale Id shift 89',0.00,0.00,0.00,785.57,0.00,'2022-06-13 19:46:32','',''),(1946,'21','220','3',2,'Sale Id shift 89',0.00,0.00,0.00,138.65,0.00,'2022-06-13 19:46:32','',''),(1947,'21','220','4',3,'Sale Id shift 89',0.00,0.00,0.00,1948.67,0.00,'2022-06-13 19:46:32','',''),(1948,'21','220','1',1,'Sale Id shift 89',0.00,0.00,0.00,1000.20,0.00,'2022-06-13 19:46:32','',''),(1949,'21','220','1',1,'Sale Id shift 89',0.00,0.00,0.00,1936.51,0.00,'2022-06-13 19:46:32','',''),(1950,'21','220','2',1,'Sale Id shift 89',0.00,0.00,0.00,2014.15,0.00,'2022-06-13 19:46:32','',''),(1951,'21','220','2',1,'Sale Id shift 89',0.00,0.00,0.00,1934.33,0.00,'2022-06-13 19:46:32','',''),(1952,'21','220','2',1,'Sale Id shift 89',0.00,0.00,0.00,2639.10,0.00,'2022-06-13 19:46:32','',''),(1953,'21','220','2',1,'Sale Id shift 89',0.00,0.00,0.00,1250.25,0.00,'2022-06-13 19:46:32','',''),(1954,'21','220','1',1,'Sale Id shift 89',0.00,0.00,0.00,1029.18,0.00,'2022-06-13 19:46:32','',''),(1955,'21','220','2',1,'Sale Id shift 89',0.00,0.00,0.00,2241.18,0.00,'2022-06-13 19:46:32','',''),(1956,'21','220','2',1,'Sale Id shift 89',0.00,0.00,0.00,1804.12,0.00,'2022-06-13 19:46:32','',''),(1957,'21','220','2',1,'Sale Id shift 89',0.00,0.00,0.00,1976.41,0.00,'2022-06-13 19:46:32','',''),(1958,'21','220','2',1,'Sale Id shift 89',0.00,0.00,0.00,1717.03,0.00,'2022-06-13 19:46:32','',''),(1959,'21','220','1',1,'Sale Id shift 89',0.00,0.00,0.00,1326.84,0.00,'2022-06-13 19:46:32','',''),(1960,'21','220',NULL,1,'Sale Id shift 89',3573053.55,0.00,0.00,0.00,0.00,'2022-06-13 19:46:32','',''),(1961,'21','220',NULL,2,'Sale Id shift 89',108147.00,0.00,0.00,0.00,0.00,'2022-06-13 19:46:32','',''),(1962,'21','220',NULL,3,'Sale Id shift 89',1266635.50,0.00,0.00,0.00,0.00,'2022-06-13 19:46:32','',''),(1963,'21','220','3',2,'Sale Id shift 90',0.00,0.00,0.00,3185.46,0.00,'2022-06-13 21:09:51','',''),(1964,'21','220','4',3,'Sale Id shift 90',0.00,0.00,0.00,2319.73,0.00,'2022-06-13 21:09:51','',''),(1965,'21','220',NULL,2,'Sale Id shift 90',2548368.00,0.00,0.00,0.00,0.00,'2022-06-13 21:09:51','',''),(1966,'21','220',NULL,3,'Sale Id shift 90',1623811.00,0.00,0.00,0.00,0.00,'2022-06-13 21:09:51','',''),(1967,'21','220',NULL,1,'Reception corrector for bridging 215',0.00,0.00,0.00,30000.00,0.00,'2022-06-13 21:12:02','',''),(1968,'21','220','2',1,'Received from bridging 215',0.00,0.00,30000.00,0.00,0.00,'2022-06-13 21:12:02','',''),(1969,'21','220',NULL,1,'Reception corrector for bridging 214',0.00,0.00,0.00,15000.00,0.00,'2022-06-13 21:12:02','',''),(1970,'21','220','1',1,'Received from bridging 214',0.00,0.00,15000.00,0.00,0.00,'2022-06-13 21:12:02','',''),(1971,'21','220','1',1,'Sale Id shift 91',0.00,0.00,0.00,7510.31,0.00,'2022-06-13 22:14:36','',''),(1972,'21','220','3',2,'Sale Id shift 91',0.00,0.00,0.00,5977.89,0.00,'2022-06-13 22:14:36','',''),(1973,'21','220','4',3,'Sale Id shift 91',0.00,0.00,0.00,1204.43,0.00,'2022-06-13 22:14:36','',''),(1974,'21','220','1',1,'Sale Id shift 91',0.00,0.00,0.00,7960.75,0.00,'2022-06-13 22:14:36','',''),(1975,'21','220','1',1,'Sale Id shift 91',0.00,0.00,0.00,6898.29,0.00,'2022-06-13 22:14:36','',''),(1976,'21','220','2',1,'Sale Id shift 91',0.00,0.00,0.00,7486.18,0.00,'2022-06-13 22:14:36','',''),(1977,'21','220','2',1,'Sale Id shift 91',0.00,0.00,0.00,2229.29,0.00,'2022-06-13 22:14:36','',''),(1978,'21','220','2',1,'Sale Id shift 91',0.00,0.00,0.00,5589.30,0.00,'2022-06-13 22:14:36','',''),(1979,'21','220','2',1,'Sale Id shift 91',0.00,0.00,0.00,5075.79,0.00,'2022-06-13 22:14:36','',''),(1980,'21','220','1',1,'Sale Id shift 91',0.00,0.00,0.00,6491.20,0.00,'2022-06-13 22:14:36','',''),(1981,'21','220','2',1,'Sale Id shift 91',0.00,0.00,0.00,6505.20,0.00,'2022-06-13 22:14:36','',''),(1982,'21','220','2',1,'Sale Id shift 91',0.00,0.00,0.00,5488.41,0.00,'2022-06-13 22:14:36','',''),(1983,'21','220','2',1,'Sale Id shift 91',0.00,0.00,0.00,5380.26,0.00,'2022-06-13 22:14:36','',''),(1984,'21','220','2',1,'Sale Id shift 91',0.00,0.00,0.00,5669.33,0.00,'2022-06-13 22:14:36','',''),(1985,'21','220','1',1,'Sale Id shift 91',0.00,0.00,0.00,9401.13,0.00,'2022-06-13 22:14:36','',''),(1986,'21','220',NULL,2,'Sale Id shift 91',4782312.00,0.00,0.00,0.00,0.00,'2022-06-13 22:14:36','',''),(1987,'21','220',NULL,3,'Sale Id shift 91',843101.00,0.00,0.00,0.00,0.00,'2022-06-13 22:14:36','',''),(1988,'21','220',NULL,1,'Sale Id shift 91',13478097.60,0.00,0.00,0.00,0.00,'2022-06-13 22:14:36','',''),(1989,'21','220',NULL,1,'Reception corrector for bridging 219',0.00,0.00,0.00,30000.00,0.00,'2022-06-14 12:21:37','',''),(1990,'21','220','2',1,'Received from bridging 219',0.00,0.00,30000.00,0.00,0.00,'2022-06-14 12:21:37','',''),(1991,'21','220',NULL,1,'Reception corrector for bridging 218',0.00,0.00,0.00,15000.00,0.00,'2022-06-14 12:21:45','',''),(1992,'21','220','1',1,'Received from bridging 218',0.00,0.00,15000.00,0.00,0.00,'2022-06-14 12:21:45','',''),(1993,'21','220','1',1,'Sale Id shift 92',0.00,0.00,0.00,4957.01,0.00,'2022-06-14 12:56:48','',''),(1994,'21','220','3',2,'Sale Id shift 92',0.00,0.00,0.00,9276.29,0.00,'2022-06-14 12:56:48','',''),(1995,'21','220','1',1,'Sale Id shift 92',0.00,0.00,0.00,5051.06,0.00,'2022-06-14 12:56:48','',''),(1996,'21','220','1',1,'Sale Id shift 92',0.00,0.00,0.00,5124.06,0.00,'2022-06-14 12:56:48','',''),(1997,'21','220','2',1,'Sale Id shift 92',0.00,0.00,0.00,4765.43,0.00,'2022-06-14 12:56:48','',''),(1998,'21','220','2',1,'Sale Id shift 92',0.00,0.00,0.00,3946.21,0.00,'2022-06-14 12:56:48','',''),(1999,'21','220','2',1,'Sale Id shift 92',0.00,0.00,0.00,4159.09,0.00,'2022-06-14 12:56:48','',''),(2000,'21','220','2',1,'Sale Id shift 92',0.00,0.00,0.00,4077.18,0.00,'2022-06-14 12:56:48','',''),(2001,'21','220','1',1,'Sale Id shift 92',0.00,0.00,0.00,3728.68,0.00,'2022-06-14 12:56:48','',''),(2002,'21','220','2',1,'Sale Id shift 92',0.00,0.00,0.00,6201.58,0.00,'2022-06-14 12:56:48','',''),(2003,'21','220','2',1,'Sale Id shift 92',0.00,0.00,0.00,3639.35,0.00,'2022-06-14 12:56:48','',''),(2004,'21','220','2',1,'Sale Id shift 92',0.00,0.00,0.00,4601.11,0.00,'2022-06-14 12:56:48','',''),(2005,'21','220','2',1,'Sale Id shift 92',0.00,0.00,0.00,4863.83,0.00,'2022-06-14 12:56:48','',''),(2006,'21','220','1',1,'Sale Id shift 92',0.00,0.00,0.00,7132.65,0.00,'2022-06-14 12:56:48','',''),(2007,'21','220','3',2,'Sale Id shift 92',0.00,0.00,0.00,806.25,0.00,'2022-06-14 12:56:48','',''),(2008,'21','220',NULL,1,'Sale Id shift 92',10270794.60,0.00,0.00,0.00,0.00,'2022-06-14 12:56:48','',''),(2009,'21','220',NULL,2,'Sale Id shift 92',8066032.00,0.00,0.00,0.00,0.00,'2022-06-14 12:56:48','',''),(2010,'21','220',NULL,1,'Reception corrector for bridging 221',0.00,0.00,0.00,29500.00,0.00,'2022-06-14 13:57:45','',''),(2011,'21','220','2',1,'Received from bridging 221',0.00,0.00,29500.00,0.00,0.00,'2022-06-14 13:57:45','',''),(2012,'21','220',NULL,1,'Reception corrector for bridging 220',0.00,0.00,0.00,15500.00,0.00,'2022-06-14 13:57:45','',''),(2013,'21','220','1',1,'Received from bridging 220',0.00,0.00,15500.00,0.00,0.00,'2022-06-14 13:57:45','',''),(2014,'21','220','1',1,'Sale Id shift 93',0.00,0.00,0.00,3666.97,0.00,'2022-06-14 14:18:36','',''),(2015,'21','220','3',2,'Sale Id shift 93',0.00,0.00,0.00,8909.29,0.00,'2022-06-14 14:18:36','',''),(2016,'21','220','1',1,'Sale Id shift 93',0.00,0.00,0.00,4046.32,0.00,'2022-06-14 14:18:36','',''),(2017,'21','220','1',1,'Sale Id shift 93',0.00,0.00,0.00,4795.79,0.00,'2022-06-14 14:18:36','',''),(2018,'21','220','2',1,'Sale Id shift 93',0.00,0.00,0.00,4013.80,0.00,'2022-06-14 14:18:36','',''),(2019,'21','220','2',1,'Sale Id shift 93',0.00,0.00,0.00,2325.58,0.00,'2022-06-14 14:18:36','',''),(2020,'21','220','2',1,'Sale Id shift 93',0.00,0.00,0.00,3480.78,0.00,'2022-06-14 14:18:36','',''),(2021,'21','220','2',1,'Sale Id shift 93',0.00,0.00,0.00,3479.68,0.00,'2022-06-14 14:18:36','',''),(2022,'21','220','1',1,'Sale Id shift 93',0.00,0.00,0.00,3257.30,0.00,'2022-06-14 14:18:36','',''),(2023,'21','220','2',1,'Sale Id shift 93',0.00,0.00,0.00,4496.95,0.00,'2022-06-14 14:18:36','',''),(2024,'21','220','2',1,'Sale Id shift 93',0.00,0.00,0.00,3999.02,0.00,'2022-06-14 14:18:36','',''),(2025,'21','220','2',1,'Sale Id shift 93',0.00,0.00,0.00,3108.61,0.00,'2022-06-14 14:18:36','',''),(2026,'21','220','2',1,'Sale Id shift 93',0.00,0.00,0.00,3484.38,0.00,'2022-06-14 14:18:36','',''),(2027,'21','220','1',1,'Sale Id shift 93',0.00,0.00,0.00,4443.34,0.00,'2022-06-14 14:18:36','',''),(2028,'21','220','3',2,'Sale Id shift 93',0.00,0.00,0.00,926.36,0.00,'2022-06-14 14:18:36','',''),(2029,'21','220',NULL,1,'Sale Id shift 93',8018755.80,0.00,0.00,0.00,0.00,'2022-06-14 14:18:36','',''),(2030,'21','220',NULL,2,'Sale Id shift 93',7868520.00,0.00,0.00,0.00,0.00,'2022-06-14 14:18:36','',''),(2031,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,24000000.00,30000.00,0.00,0.00,'2022-06-14 14:41:45','',''),(2032,'21','220',NULL,2,'Reception corrector for bridging 224',0.00,0.00,0.00,30000.00,0.00,'2022-06-14 14:43:24','',''),(2033,'21','220','3',2,'Received from bridging 224',0.00,0.00,30000.00,0.00,0.00,'2022-06-14 14:43:24','',''),(2034,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-14 14:46:47','',''),(2035,'21','220',NULL,1,'Reception corrector for bridging 228',0.00,0.00,0.00,30000.00,0.00,'2022-06-14 14:51:37','',''),(2036,'21','220','2',1,'Received from bridging 228',0.00,0.00,30000.00,0.00,0.00,'2022-06-14 14:51:37','',''),(2037,'21','220',NULL,1,'Reception corrector for bridging 227',0.00,0.00,0.00,15000.00,0.00,'2022-06-14 14:51:37','',''),(2038,'21','220','1',1,'Received from bridging 227',0.00,0.00,15000.00,0.00,0.00,'2022-06-14 14:51:37','',''),(2039,'21','220','1',1,'Sale Id shift 94',0.00,0.00,0.00,2960.88,0.00,'2022-06-14 15:09:44','',''),(2040,'21','220','3',2,'Sale Id shift 94',0.00,0.00,0.00,3115.38,0.00,'2022-06-14 15:09:44','',''),(2041,'21','220','1',1,'Sale Id shift 94',0.00,0.00,0.00,3157.79,0.00,'2022-06-14 15:09:44','',''),(2042,'21','220','1',1,'Sale Id shift 94',0.00,0.00,0.00,2699.69,0.00,'2022-06-14 15:09:44','',''),(2043,'21','220','2',1,'Sale Id shift 94',0.00,0.00,0.00,4336.64,0.00,'2022-06-14 15:09:44','',''),(2044,'21','220','2',1,'Sale Id shift 94',0.00,0.00,0.00,1941.79,0.00,'2022-06-14 15:09:44','',''),(2045,'21','220','2',1,'Sale Id shift 94',0.00,0.00,0.00,3667.09,0.00,'2022-06-14 15:09:44','',''),(2046,'21','220','2',1,'Sale Id shift 94',0.00,0.00,0.00,3719.53,0.00,'2022-06-14 15:09:44','',''),(2047,'21','220','1',1,'Sale Id shift 94',0.00,0.00,0.00,3212.73,0.00,'2022-06-14 15:09:44','',''),(2048,'21','220','2',1,'Sale Id shift 94',0.00,0.00,0.00,4803.27,0.00,'2022-06-14 15:09:44','',''),(2049,'21','220','2',1,'Sale Id shift 94',0.00,0.00,0.00,4593.97,0.00,'2022-06-14 15:09:44','',''),(2050,'21','220','2',1,'Sale Id shift 94',0.00,0.00,0.00,3851.43,0.00,'2022-06-14 15:09:44','',''),(2051,'21','220','2',1,'Sale Id shift 94',0.00,0.00,0.00,3755.24,0.00,'2022-06-14 15:09:44','',''),(2052,'21','220','1',1,'Sale Id shift 94',0.00,0.00,0.00,2885.26,0.00,'2022-06-14 15:09:44','',''),(2053,'21','220',NULL,1,'Sale Id shift 94',7521576.15,0.00,0.00,0.00,0.00,'2022-06-14 15:09:44','',''),(2054,'21','220',NULL,2,'Sale Id shift 94',2492304.00,0.00,0.00,0.00,0.00,'2022-06-14 15:09:44','',''),(2055,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7383750.00,44750.00,0.00,0.00,'2022-06-15 15:45:29','',''),(2056,'21','220',NULL,1,'Reception corrector for bridging 230',0.00,0.00,0.00,28950.00,0.00,'2022-06-15 15:49:16','',''),(2057,'21','220','2',1,'Received from bridging 230',0.00,0.00,28950.00,0.00,0.00,'2022-06-15 15:49:16','',''),(2058,'21','220',NULL,1,'Reception corrector for bridging 233',0.00,0.00,0.00,15750.00,0.00,'2022-06-15 15:59:38','',''),(2059,'21','220','1',1,'Received from bridging 233',0.00,0.00,15750.00,0.00,0.00,'2022-06-15 15:59:38','',''),(2060,'21','220','1',1,'Sale Id shift 95',0.00,0.00,0.00,2939.96,0.00,'2022-06-16 17:20:30','',''),(2061,'21','220','3',2,'Sale Id shift 95',0.00,0.00,0.00,7980.33,0.00,'2022-06-16 17:20:30','',''),(2062,'21','220','1',1,'Sale Id shift 95',0.00,0.00,0.00,2798.77,0.00,'2022-06-16 17:20:30','',''),(2063,'21','220','1',1,'Sale Id shift 95',0.00,0.00,0.00,2089.99,0.00,'2022-06-16 17:20:30','',''),(2064,'21','220','1',1,'Sale Id shift 95',0.00,0.00,0.00,0.20,0.00,'2022-06-16 17:20:30','',''),(2065,'21','220','1',1,'Sale Id shift 95',0.00,0.00,0.00,2750.69,0.00,'2022-06-16 17:20:30','',''),(2066,'21','220','2',1,'Sale Id shift 95',0.00,0.00,0.00,4142.08,0.00,'2022-06-16 17:20:30','',''),(2067,'21','220','2',1,'Sale Id shift 95',0.00,0.00,0.00,3581.93,0.00,'2022-06-16 17:20:30','',''),(2068,'21','220','2',1,'Sale Id shift 95',0.00,0.00,0.00,3777.05,0.00,'2022-06-16 17:20:30','',''),(2069,'21','220','2',1,'Sale Id shift 95',0.00,0.00,0.00,3151.04,0.00,'2022-06-16 17:20:30','',''),(2070,'21','220','1',1,'Sale Id shift 95',0.00,0.00,0.00,2538.38,0.00,'2022-06-16 17:20:30','',''),(2071,'21','220','2',1,'Sale Id shift 95',0.00,0.00,0.00,4976.74,0.00,'2022-06-16 17:20:30','',''),(2072,'21','220','2',1,'Sale Id shift 95',0.00,0.00,0.00,3182.00,0.00,'2022-06-16 17:20:30','',''),(2073,'21','220','2',1,'Sale Id shift 95',0.00,0.00,0.00,4088.80,0.00,'2022-06-16 17:20:30','',''),(2074,'21','220','2',1,'Sale Id shift 95',0.00,0.00,0.00,3834.35,0.00,'2022-06-16 17:20:30','',''),(2075,'21','220','1',1,'Sale Id shift 95',0.00,0.00,0.00,4015.31,0.00,'2022-06-16 17:20:30','',''),(2076,'21','220','3',2,'Sale Id shift 95',0.00,0.00,0.00,1532.14,0.00,'2022-06-16 17:20:30','',''),(2077,'21','220',NULL,1,'Sale Id shift 95',7898102.85,0.00,0.00,0.00,0.00,'2022-06-16 17:20:30','',''),(2078,'21','220',NULL,2,'Sale Id shift 95',7609976.00,0.00,0.00,0.00,0.00,'2022-06-16 17:20:30','',''),(2079,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-16 17:25:23','',''),(2080,'21','220',NULL,1,'Reception corrector for bridging 235',0.00,0.00,0.00,30000.00,0.00,'2022-06-16 17:28:05','',''),(2081,'21','220','2',1,'Received from bridging 235',0.00,0.00,30000.00,0.00,0.00,'2022-06-16 17:28:05','',''),(2082,'21','220',NULL,1,'Reception corrector for bridging 234',0.00,0.00,0.00,15000.00,0.00,'2022-06-16 17:28:05','',''),(2083,'21','220','1',1,'Received from bridging 234',0.00,0.00,15000.00,0.00,0.00,'2022-06-16 17:28:05','',''),(2084,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,27470000.00,33500.00,0.00,0.00,'2022-06-16 17:29:57','',''),(2085,'21','220',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,12000000.00,16000.00,0.00,0.00,'2022-06-16 17:52:02','',''),(2086,'21','220',NULL,3,'Reception corrector for bridging 237',0.00,0.00,0.00,16000.00,0.00,'2022-06-16 17:54:50','',''),(2087,'21','220','4',3,'Received from bridging 237',0.00,0.00,16000.00,0.00,0.00,'2022-06-16 17:54:50','',''),(2088,'21','220','1',1,'Sale Id shift 96',0.00,0.00,0.00,1258.18,0.00,'2022-06-16 20:40:38','',''),(2089,'21','220','3',2,'Sale Id shift 96',0.00,0.00,0.00,9394.09,0.00,'2022-06-16 20:40:38','',''),(2090,'21','220','1',1,'Sale Id shift 96',0.00,0.00,0.00,1296.36,0.00,'2022-06-16 20:40:38','',''),(2091,'21','220','1',1,'Sale Id shift 96',0.00,0.00,0.00,934.75,0.00,'2022-06-16 20:40:38','',''),(2092,'21','220','1',1,'Sale Id shift 96',0.00,0.00,0.00,1558.80,0.00,'2022-06-16 20:40:38','',''),(2093,'21','220','2',1,'Sale Id shift 96',0.00,0.00,0.00,2954.87,0.00,'2022-06-16 20:40:38','',''),(2094,'21','220','2',1,'Sale Id shift 96',0.00,0.00,0.00,3035.66,0.00,'2022-06-16 20:40:38','',''),(2095,'21','220','2',1,'Sale Id shift 96',0.00,0.00,0.00,3093.59,0.00,'2022-06-16 20:40:38','',''),(2096,'21','220','2',1,'Sale Id shift 96',0.00,0.00,0.00,2832.53,0.00,'2022-06-16 20:40:38','',''),(2097,'21','220','1',1,'Sale Id shift 96',0.00,0.00,0.00,1108.40,0.00,'2022-06-16 20:40:38','',''),(2098,'21','220','2',1,'Sale Id shift 96',0.00,0.00,0.00,3277.79,0.00,'2022-06-16 20:40:38','',''),(2099,'21','220','2',1,'Sale Id shift 96',0.00,0.00,0.00,2970.16,0.00,'2022-06-16 20:40:38','',''),(2100,'21','220','2',1,'Sale Id shift 96',0.00,0.00,0.00,2204.03,0.00,'2022-06-16 20:40:38','',''),(2101,'21','220','2',1,'Sale Id shift 96',0.00,0.00,0.00,3392.08,0.00,'2022-06-16 20:40:38','',''),(2102,'21','220','1',1,'Sale Id shift 96',0.00,0.00,0.00,2641.74,0.00,'2022-06-16 20:40:38','',''),(2103,'21','220','3',2,'Sale Id shift 96',0.00,0.00,0.00,785.81,0.00,'2022-06-16 20:40:38','',''),(2104,'21','220',NULL,1,'Sale Id shift 96',5372225.10,0.00,0.00,0.00,0.00,'2022-06-16 20:40:38','',''),(2105,'21','220',NULL,2,'Sale Id shift 96',8347518.00,0.00,0.00,0.00,0.00,'2022-06-16 20:40:38','',''),(2106,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-16 21:21:34','',''),(2107,'21','220',NULL,1,'Reception corrector for bridging 239',0.00,0.00,0.00,30000.00,0.00,'2022-06-16 21:23:27','',''),(2108,'21','220','2',1,'Received from bridging 239',0.00,0.00,30000.00,0.00,0.00,'2022-06-16 21:23:27','',''),(2109,'21','220',NULL,1,'Reception corrector for bridging 238',0.00,0.00,0.00,15000.00,0.00,'2022-06-16 21:23:27','',''),(2110,'21','220','1',1,'Received from bridging 238',0.00,0.00,15000.00,0.00,0.00,'2022-06-16 21:23:27','',''),(2111,'21','220','1',1,'Sale Id shift 97',0.00,0.00,0.00,2304.99,0.00,'2022-06-17 17:26:32','',''),(2112,'21','220','3',2,'Sale Id shift 97',0.00,0.00,0.00,6897.65,0.00,'2022-06-17 17:26:32','',''),(2113,'21','220','1',1,'Sale Id shift 97',0.00,0.00,0.00,2018.80,0.00,'2022-06-17 17:26:32','',''),(2114,'21','220','1',1,'Sale Id shift 97',0.00,0.00,0.00,1417.70,0.00,'2022-06-17 17:26:32','',''),(2115,'21','220','1',1,'Sale Id shift 97',0.00,0.00,0.00,2871.29,0.00,'2022-06-17 17:26:32','',''),(2116,'21','220','2',1,'Sale Id shift 97',0.00,0.00,0.00,3987.35,0.00,'2022-06-17 17:26:32','',''),(2117,'21','220','2',1,'Sale Id shift 97',0.00,0.00,0.00,3529.41,0.00,'2022-06-17 17:26:32','',''),(2118,'21','220','2',1,'Sale Id shift 97',0.00,0.00,0.00,3207.61,0.00,'2022-06-17 17:26:32','',''),(2119,'21','220','2',1,'Sale Id shift 97',0.00,0.00,0.00,3508.76,0.00,'2022-06-17 17:26:32','',''),(2120,'21','220','1',1,'Sale Id shift 97',0.00,0.00,0.00,2574.97,0.00,'2022-06-17 17:26:32','',''),(2121,'21','220','2',1,'Sale Id shift 97',0.00,0.00,0.00,4458.42,0.00,'2022-06-17 17:26:32','',''),(2122,'21','220','2',1,'Sale Id shift 97',0.00,0.00,0.00,3206.15,0.00,'2022-06-17 17:26:32','',''),(2123,'21','220','2',1,'Sale Id shift 97',0.00,0.00,0.00,3374.58,0.00,'2022-06-17 17:26:32','',''),(2124,'21','220','2',1,'Sale Id shift 97',0.00,0.00,0.00,3635.04,0.00,'2022-06-17 17:26:32','',''),(2125,'21','220','1',1,'Sale Id shift 97',0.00,0.00,0.00,4629.02,0.00,'2022-06-17 17:26:32','',''),(2126,'21','220','3',2,'Sale Id shift 97',0.00,0.00,0.00,1948.07,0.00,'2022-06-17 17:26:32','',''),(2127,'21','220',NULL,1,'Sale Id shift 97',7379474.85,0.00,0.00,0.00,0.00,'2022-06-17 17:26:32','',''),(2128,'21','220',NULL,2,'Sale Id shift 97',7253490.40,0.00,0.00,0.00,0.00,'2022-06-17 17:26:32','',''),(2129,'21','220',NULL,2,'Reception corrector for bridging 236',0.00,0.00,0.00,33500.00,0.00,'2022-06-17 17:30:02','',''),(2130,'21','220','3',2,'Received from bridging 236',0.00,0.00,33500.00,0.00,0.00,'2022-06-17 17:30:02','',''),(2131,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-17 17:39:25','',''),(2132,'21','220',NULL,1,'Reception corrector for bridging 241',0.00,0.00,0.00,32000.00,0.00,'2022-06-17 17:54:15','',''),(2133,'21','220','2',1,'Received from bridging 241',0.00,0.00,32000.00,0.00,0.00,'2022-06-17 17:54:15','',''),(2134,'21','220',NULL,1,'Reception corrector for bridging 240',0.00,0.00,0.00,13000.00,0.00,'2022-06-17 17:54:15','',''),(2135,'21','220','1',1,'Received from bridging 240',0.00,0.00,13000.00,0.00,0.00,'2022-06-17 17:54:15','',''),(2136,'21','220','1',1,'Sale Id shift 98',0.00,0.00,0.00,2773.73,0.00,'2022-06-17 18:31:24','',''),(2137,'21','220','3',2,'Sale Id shift 98',0.00,0.00,0.00,7704.37,0.00,'2022-06-17 18:31:24','',''),(2138,'21','220','4',3,'Sale Id shift 98',0.00,0.00,0.00,962.67,0.00,'2022-06-17 18:31:24','',''),(2139,'21','220','1',1,'Sale Id shift 98',0.00,0.00,0.00,2108.62,0.00,'2022-06-17 18:31:24','',''),(2140,'21','220','1',1,'Sale Id shift 98',0.00,0.00,0.00,2596.19,0.00,'2022-06-17 18:31:24','',''),(2141,'21','220','1',1,'Sale Id shift 98',0.00,0.00,0.00,3582.98,0.00,'2022-06-17 18:31:24','',''),(2142,'21','220','2',1,'Sale Id shift 98',0.00,0.00,0.00,4711.32,0.00,'2022-06-17 18:31:24','',''),(2143,'21','220','2',1,'Sale Id shift 98',0.00,0.00,0.00,3309.52,0.00,'2022-06-17 18:31:24','',''),(2144,'21','220','2',1,'Sale Id shift 98',0.00,0.00,0.00,3885.31,0.00,'2022-06-17 18:31:24','',''),(2145,'21','220','2',1,'Sale Id shift 98',0.00,0.00,0.00,4119.41,0.00,'2022-06-17 18:31:24','',''),(2146,'21','220','1',1,'Sale Id shift 98',0.00,0.00,0.00,3488.48,0.00,'2022-06-17 18:31:24','',''),(2147,'21','220','2',1,'Sale Id shift 98',0.00,0.00,0.00,6004.31,0.00,'2022-06-17 18:31:24','',''),(2148,'21','220','2',1,'Sale Id shift 98',0.00,0.00,0.00,3348.03,0.00,'2022-06-17 18:31:24','',''),(2149,'21','220','2',1,'Sale Id shift 98',0.00,0.00,0.00,4333.96,0.00,'2022-06-17 18:31:24','',''),(2150,'21','220','2',1,'Sale Id shift 98',0.00,0.00,0.00,4682.23,0.00,'2022-06-17 18:31:24','',''),(2151,'21','220','1',1,'Sale Id shift 98',0.00,0.00,0.00,4072.19,0.00,'2022-06-17 18:31:24','',''),(2152,'21','220',NULL,1,'Sale Id shift 98',8747686.20,0.00,0.00,0.00,0.00,'2022-06-17 18:31:24','',''),(2153,'21','220',NULL,2,'Sale Id shift 98',6317583.40,0.00,0.00,0.00,0.00,'2022-06-17 18:31:24','',''),(2154,'21','220',NULL,3,'Sale Id shift 98',722002.50,0.00,0.00,0.00,0.00,'2022-06-17 18:31:24','',''),(2155,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-18 18:38:45','',''),(2156,'21','220',NULL,1,'Reception corrector for bridging 243',0.00,0.00,0.00,30000.00,0.00,'2022-06-18 18:46:21','',''),(2157,'21','220','2',1,'Received from bridging 243',0.00,0.00,30000.00,0.00,0.00,'2022-06-18 18:46:21','',''),(2158,'21','220',NULL,1,'Reception corrector for bridging 242',0.00,0.00,0.00,15000.00,0.00,'2022-06-18 18:46:21','',''),(2159,'21','220','1',1,'Received from bridging 242',0.00,0.00,15000.00,0.00,0.00,'2022-06-18 18:46:21','',''),(2160,'21','220','1',1,'Sale Id shift 99',0.00,0.00,0.00,1622.05,0.00,'2022-06-20 14:42:33','',''),(2161,'21','220','3',2,'Sale Id shift 99',0.00,0.00,0.00,8031.37,0.00,'2022-06-20 14:42:33','',''),(2162,'21','220','4',3,'Sale Id shift 99',0.00,0.00,0.00,1297.84,0.00,'2022-06-20 14:42:33','',''),(2163,'21','220','1',1,'Sale Id shift 99',0.00,0.00,0.00,1939.42,0.00,'2022-06-20 14:42:33','',''),(2164,'21','220','1',1,'Sale Id shift 99',0.00,0.00,0.00,2083.50,0.00,'2022-06-20 14:42:33','',''),(2165,'21','220','1',1,'Sale Id shift 99',0.00,0.00,0.00,0.32,0.00,'2022-06-20 14:42:33','',''),(2166,'21','220','1',1,'Sale Id shift 99',0.00,0.00,0.00,3176.16,0.00,'2022-06-20 14:42:33','',''),(2167,'21','220','2',1,'Sale Id shift 99',0.00,0.00,0.00,3796.03,0.00,'2022-06-20 14:42:33','',''),(2168,'21','220','2',1,'Sale Id shift 99',0.00,0.00,0.00,3639.64,0.00,'2022-06-20 14:42:33','',''),(2169,'21','220','2',1,'Sale Id shift 99',0.00,0.00,0.00,3875.03,0.00,'2022-06-20 14:42:33','',''),(2170,'21','220','2',1,'Sale Id shift 99',0.00,0.00,0.00,3365.47,0.00,'2022-06-20 14:42:33','',''),(2171,'21','220','1',1,'Sale Id shift 99',0.00,0.00,0.00,3497.21,0.00,'2022-06-20 14:42:33','',''),(2172,'21','220','2',1,'Sale Id shift 99',0.00,0.00,0.00,4763.52,0.00,'2022-06-20 14:42:33','',''),(2173,'21','220','2',1,'Sale Id shift 99',0.00,0.00,0.00,4196.00,0.00,'2022-06-20 14:42:33','',''),(2174,'21','220','2',1,'Sale Id shift 99',0.00,0.00,0.00,4313.98,0.00,'2022-06-20 14:42:33','',''),(2175,'21','220','2',1,'Sale Id shift 99',0.00,0.00,0.00,3638.55,0.00,'2022-06-20 14:42:33','',''),(2176,'21','220','1',1,'Sale Id shift 99',0.00,0.00,0.00,3529.03,0.00,'2022-06-20 14:42:33','',''),(2177,'21','220','3',2,'Sale Id shift 99',0.00,0.00,0.00,2352.67,0.00,'2022-06-20 14:42:33','',''),(2178,'21','220',NULL,1,'Sale Id shift 99',7826925.15,0.00,0.00,0.00,0.00,'2022-06-20 14:42:33','',''),(2179,'21','220',NULL,2,'Sale Id shift 99',8514912.80,0.00,0.00,0.00,0.00,'2022-06-20 14:42:33','',''),(2180,'21','220',NULL,3,'Sale Id shift 99',973380.00,0.00,0.00,0.00,0.00,'2022-06-20 14:42:33','',''),(2181,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,24600000.00,30000.00,0.00,0.00,'2022-06-22 18:28:47','',''),(2182,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-22 18:31:45','',''),(2183,'21','220',NULL,1,'Reception corrector for bridging 246',0.00,0.00,0.00,23000.00,0.00,'2022-06-22 18:34:12','',''),(2184,'21','220','2',1,'Received from bridging 246',0.00,0.00,23000.00,0.00,0.00,'2022-06-22 18:34:12','',''),(2185,'21','220',NULL,1,'Reception corrector for bridging 245',0.00,0.00,0.00,18000.00,0.00,'2022-06-22 18:34:12','',''),(2186,'21','220','1',1,'Received from bridging 245',0.00,0.00,18000.00,0.00,0.00,'2022-06-22 18:34:12','',''),(2187,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-22 18:37:22','',''),(2188,'21','220',NULL,1,'Reception corrector for bridging 248',0.00,0.00,0.00,30000.00,0.00,'2022-06-22 18:43:59','',''),(2189,'21','220','2',1,'Received from bridging 248',0.00,0.00,30000.00,0.00,0.00,'2022-06-22 18:43:59','',''),(2190,'21','220',NULL,1,'Reception corrector for bridging 247',0.00,0.00,0.00,15000.00,0.00,'2022-06-22 18:43:59','',''),(2191,'21','220','1',1,'Received from bridging 247',0.00,0.00,15000.00,0.00,0.00,'2022-06-22 18:43:59','',''),(2192,'21','220','1',1,'Sale Id shift 100',0.00,0.00,0.00,1099.25,0.00,'2022-06-22 19:24:25','',''),(2193,'21','220','3',2,'Sale Id shift 100',0.00,0.00,0.00,4532.98,0.00,'2022-06-22 19:24:25','',''),(2194,'21','220','4',3,'Sale Id shift 100',0.00,0.00,0.00,1201.74,0.00,'2022-06-22 19:24:25','',''),(2195,'21','220','1',1,'Sale Id shift 100',0.00,0.00,0.00,2391.28,0.00,'2022-06-22 19:24:25','',''),(2196,'21','220','1',1,'Sale Id shift 100',0.00,0.00,0.00,1174.79,0.00,'2022-06-22 19:24:25','',''),(2197,'21','220','1',1,'Sale Id shift 100',0.00,0.00,0.00,2894.50,0.00,'2022-06-22 19:24:25','',''),(2198,'21','220','2',1,'Sale Id shift 100',0.00,0.00,0.00,4369.19,0.00,'2022-06-22 19:24:25','',''),(2199,'21','220','2',1,'Sale Id shift 100',0.00,0.00,0.00,3088.09,0.00,'2022-06-22 19:24:25','',''),(2200,'21','220','2',1,'Sale Id shift 100',0.00,0.00,0.00,3394.13,0.00,'2022-06-22 19:24:25','',''),(2201,'21','220','2',1,'Sale Id shift 100',0.00,0.00,0.00,4801.80,0.00,'2022-06-22 19:24:25','',''),(2202,'21','220','1',1,'Sale Id shift 100',0.00,0.00,0.00,2082.29,0.00,'2022-06-22 19:24:25','',''),(2203,'21','220','2',1,'Sale Id shift 100',0.00,0.00,0.00,4448.20,0.00,'2022-06-22 19:24:25','',''),(2204,'21','220','2',1,'Sale Id shift 100',0.00,0.00,0.00,4186.63,0.00,'2022-06-22 19:24:25','',''),(2205,'21','220','2',1,'Sale Id shift 100',0.00,0.00,0.00,4017.65,0.00,'2022-06-22 19:24:25','',''),(2206,'21','220','2',1,'Sale Id shift 100',0.00,0.00,0.00,3721.04,0.00,'2022-06-22 19:24:25','',''),(2207,'21','220','1',1,'Sale Id shift 100',0.00,0.00,0.00,2808.94,0.00,'2022-06-22 19:24:25','',''),(2208,'21','220','3',2,'Sale Id shift 100',0.00,0.00,0.00,4096.34,0.00,'2022-06-22 19:24:25','',''),(2209,'21','220',NULL,2,'Sale Id shift 100',7076042.40,0.00,0.00,0.00,0.00,'2022-06-22 19:24:25','',''),(2210,'21','220',NULL,3,'Sale Id shift 100',901305.00,0.00,0.00,0.00,0.00,'2022-06-22 19:24:25','',''),(2211,'21','220',NULL,1,'Sale Id shift 100',7338833.70,0.00,0.00,0.00,0.00,'2022-06-22 19:24:25','',''),(2212,'21','220','3',2,'Sale Id shift 101',0.00,0.00,0.00,3720.76,0.00,'2022-06-22 20:16:07','',''),(2213,'21','220','4',3,'Sale Id shift 101',0.00,0.00,0.00,498.14,0.00,'2022-06-22 20:16:07','',''),(2214,'21','220','1',1,'Sale Id shift 101',0.00,0.00,0.00,2835.26,0.00,'2022-06-22 20:16:07','',''),(2215,'21','220','1',1,'Sale Id shift 101',0.00,0.00,0.00,2689.55,0.00,'2022-06-22 20:16:07','',''),(2216,'21','220','2',1,'Sale Id shift 101',0.00,0.00,0.00,4086.03,0.00,'2022-06-22 20:16:07','',''),(2217,'21','220','2',1,'Sale Id shift 101',0.00,0.00,0.00,3587.01,0.00,'2022-06-22 20:16:07','',''),(2218,'21','220','2',1,'Sale Id shift 101',0.00,0.00,0.00,868.11,0.00,'2022-06-22 20:16:07','',''),(2219,'21','220','2',1,'Sale Id shift 101',0.00,0.00,0.00,3715.02,0.00,'2022-06-22 20:16:07','',''),(2220,'21','220','1',1,'Sale Id shift 101',0.00,0.00,0.00,3694.37,0.00,'2022-06-22 20:16:07','',''),(2221,'21','220','2',1,'Sale Id shift 101',0.00,0.00,0.00,4190.35,0.00,'2022-06-22 20:16:07','',''),(2222,'21','220','2',1,'Sale Id shift 101',0.00,0.00,0.00,3885.44,0.00,'2022-06-22 20:16:07','',''),(2223,'21','220','2',1,'Sale Id shift 101',0.00,0.00,0.00,3439.37,0.00,'2022-06-22 20:16:07','',''),(2224,'21','220','2',1,'Sale Id shift 101',0.00,0.00,0.00,3958.23,0.00,'2022-06-22 20:16:07','',''),(2225,'21','220','1',1,'Sale Id shift 101',0.00,0.00,0.00,3908.57,0.00,'2022-06-22 20:16:07','',''),(2226,'21','220','3',2,'Sale Id shift 101',0.00,0.00,0.00,0.59,0.00,'2022-06-22 20:16:07','',''),(2227,'21','220',NULL,1,'Sale Id shift 101',6741456.15,0.00,0.00,0.00,0.00,'2022-06-22 20:16:07','',''),(2228,'21','220',NULL,2,'Sale Id shift 101',3051507.00,0.00,0.00,0.00,0.00,'2022-06-22 20:16:07','',''),(2229,'21','220',NULL,3,'Sale Id shift 101',373605.00,0.00,0.00,0.00,0.00,'2022-06-22 20:16:07','',''),(2230,'21','220',NULL,1,'Reception corrector for bridging 249',0.00,0.00,0.00,4000.00,0.00,'2022-06-22 20:23:11','',''),(2231,'21','220','2',1,'Received from bridging 249',0.00,0.00,4000.00,0.00,0.00,'2022-06-22 20:23:11','',''),(2232,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-22 20:23:48','',''),(2233,'21','220',NULL,1,'Reception corrector for bridging 251',0.00,0.00,0.00,30000.00,0.00,'2022-06-22 20:25:59','',''),(2234,'21','220','2',1,'Received from bridging 251',0.00,0.00,30000.00,0.00,0.00,'2022-06-22 20:25:59','',''),(2235,'21','220',NULL,1,'Reception corrector for bridging 250',0.00,0.00,0.00,15000.00,0.00,'2022-06-22 20:25:59','',''),(2236,'21','220','1',1,'Received from bridging 250',0.00,0.00,15000.00,0.00,0.00,'2022-06-22 20:25:59','',''),(2237,'21','220',NULL,2,'Reception corrector for bridging 244',0.00,0.00,0.00,30000.00,0.00,'2022-06-22 20:26:54','',''),(2238,'21','220','3',2,'Received from bridging 244',0.00,0.00,30000.00,0.00,0.00,'2022-06-22 20:26:54','',''),(2239,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-28 17:24:18','',''),(2240,'21','220',NULL,1,'Reception corrector for bridging 253',0.00,0.00,0.00,30000.00,0.00,'2022-06-28 17:26:09','',''),(2241,'21','220','2',1,'Received from bridging 253',0.00,0.00,30000.00,0.00,0.00,'2022-06-28 17:26:09','',''),(2242,'21','220',NULL,1,'Reception corrector for bridging 252',0.00,0.00,0.00,15000.00,0.00,'2022-06-28 17:26:09','',''),(2243,'21','220','1',1,'Received from bridging 252',0.00,0.00,15000.00,0.00,0.00,'2022-06-28 17:26:09','',''),(2244,'21','220','1',1,'Sale Id shift 103',0.00,0.00,0.00,2662.84,0.00,'2022-06-28 18:08:00','',''),(2245,'21','220','3',2,'Sale Id shift 103',0.00,0.00,0.00,4742.90,0.00,'2022-06-28 18:08:00','',''),(2246,'21','220','4',3,'Sale Id shift 103',0.00,0.00,0.00,1009.45,0.00,'2022-06-28 18:08:00','',''),(2247,'21','220','1',1,'Sale Id shift 103',0.00,0.00,0.00,3526.51,0.00,'2022-06-28 18:08:00','',''),(2248,'21','220','1',1,'Sale Id shift 103',0.00,0.00,0.00,2249.97,0.00,'2022-06-28 18:08:00','',''),(2249,'21','220','1',1,'Sale Id shift 103',0.00,0.00,0.00,4727.43,0.00,'2022-06-28 18:08:00','',''),(2250,'21','220','2',1,'Sale Id shift 103',0.00,0.00,0.00,4542.38,0.00,'2022-06-28 18:08:00','',''),(2251,'21','220','2',1,'Sale Id shift 103',0.00,0.00,0.00,3191.68,0.00,'2022-06-28 18:08:00','',''),(2252,'21','220','2',1,'Sale Id shift 103',0.00,0.00,0.00,3953.15,0.00,'2022-06-28 18:08:00','',''),(2253,'21','220','2',1,'Sale Id shift 103',0.00,0.00,0.00,2646.26,0.00,'2022-06-28 18:08:00','',''),(2254,'21','220','1',1,'Sale Id shift 103',0.00,0.00,0.00,3211.85,0.00,'2022-06-28 18:08:00','',''),(2255,'21','220','2',1,'Sale Id shift 103',0.00,0.00,0.00,4492.07,0.00,'2022-06-28 18:08:00','',''),(2256,'21','220','2',1,'Sale Id shift 103',0.00,0.00,0.00,3931.34,0.00,'2022-06-28 18:08:00','',''),(2257,'21','220','2',1,'Sale Id shift 103',0.00,0.00,0.00,3950.54,0.00,'2022-06-28 18:08:00','',''),(2258,'21','220','2',1,'Sale Id shift 103',0.00,0.00,0.00,3204.52,0.00,'2022-06-28 18:08:00','',''),(2259,'21','220','1',1,'Sale Id shift 103',0.00,0.00,0.00,4717.66,0.00,'2022-06-28 18:08:00','',''),(2260,'21','220',NULL,2,'Sale Id shift 103',3936607.00,0.00,0.00,0.00,0.00,'2022-06-28 18:08:00','',''),(2261,'21','220',NULL,3,'Sale Id shift 103',757087.50,0.00,0.00,0.00,0.00,'2022-06-28 18:08:00','',''),(2262,'21','220',NULL,1,'Sale Id shift 103',8416353.00,0.00,0.00,0.00,0.00,'2022-06-28 18:08:00','',''),(2263,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-28 18:36:17','',''),(2264,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-28 18:46:36','',''),(2265,'21','220','1',1,'Sale Id shift 104',0.00,0.00,0.00,2272.73,0.00,'2022-06-28 18:53:27','',''),(2266,'21','220','3',2,'Sale Id shift 104',0.00,0.00,0.00,4601.36,0.00,'2022-06-28 18:53:27','',''),(2267,'21','220','4',3,'Sale Id shift 104',0.00,0.00,0.00,605.82,0.00,'2022-06-28 18:53:27','',''),(2268,'21','220','1',1,'Sale Id shift 104',0.00,0.00,0.00,1778.65,0.00,'2022-06-28 18:53:27','',''),(2269,'21','220','1',1,'Sale Id shift 104',0.00,0.00,0.00,1809.12,0.00,'2022-06-28 18:53:27','',''),(2270,'21','220','1',1,'Sale Id shift 104',0.00,0.00,0.00,3360.44,0.00,'2022-06-28 18:53:27','',''),(2271,'21','220','2',1,'Sale Id shift 104',0.00,0.00,0.00,3421.92,0.00,'2022-06-28 18:53:27','',''),(2272,'21','220','2',1,'Sale Id shift 104',0.00,0.00,0.00,3552.76,0.00,'2022-06-28 18:53:27','',''),(2273,'21','220','2',1,'Sale Id shift 104',0.00,0.00,0.00,2861.01,0.00,'2022-06-28 18:53:27','',''),(2274,'21','220','2',1,'Sale Id shift 104',0.00,0.00,0.00,3543.96,0.00,'2022-06-28 18:53:27','',''),(2275,'21','220','1',1,'Sale Id shift 104',0.00,0.00,0.00,2004.97,0.00,'2022-06-28 18:53:27','',''),(2276,'21','220','2',1,'Sale Id shift 104',0.00,0.00,0.00,4027.86,0.00,'2022-06-28 18:53:27','',''),(2277,'21','220','2',1,'Sale Id shift 104',0.00,0.00,0.00,3485.56,0.00,'2022-06-28 18:53:27','',''),(2278,'21','220','2',1,'Sale Id shift 104',0.00,0.00,0.00,3814.79,0.00,'2022-06-28 18:53:27','',''),(2279,'21','220','2',1,'Sale Id shift 104',0.00,0.00,0.00,3278.56,0.00,'2022-06-28 18:53:27','',''),(2280,'21','220','1',1,'Sale Id shift 104',0.00,0.00,0.00,2982.79,0.00,'2022-06-28 18:53:27','',''),(2281,'21','220',NULL,1,'Sale Id shift 104',6962194.80,0.00,0.00,0.00,0.00,'2022-06-28 18:53:27','',''),(2282,'21','220',NULL,2,'Sale Id shift 104',3819128.80,0.00,0.00,0.00,0.00,'2022-06-28 18:53:27','',''),(2283,'21','220',NULL,3,'Sale Id shift 104',454365.00,0.00,0.00,0.00,0.00,'2022-06-28 18:53:27','',''),(2284,'21','220',NULL,1,'Reception corrector for bridging 255',0.00,0.00,0.00,30000.00,0.00,'2022-06-29 16:54:53','',''),(2285,'21','220','2',1,'Received from bridging 255',0.00,0.00,30000.00,0.00,0.00,'2022-06-29 16:54:53','',''),(2286,'21','220',NULL,1,'Reception corrector for bridging 254',0.00,0.00,0.00,15000.00,0.00,'2022-06-29 16:54:53','',''),(2287,'21','220','1',1,'Received from bridging 254',0.00,0.00,15000.00,0.00,0.00,'2022-06-29 16:54:53','',''),(2288,'21','220','1',1,'Sale Id shift 105',0.00,0.00,0.00,1247.60,0.00,'2022-06-29 17:17:14','',''),(2289,'21','220','3',2,'Sale Id shift 105',0.00,0.00,0.00,3840.55,0.00,'2022-06-29 17:17:14','',''),(2290,'21','220','4',3,'Sale Id shift 105',0.00,0.00,0.00,1085.25,0.00,'2022-06-29 17:17:14','',''),(2291,'21','220','1',1,'Sale Id shift 105',0.00,0.00,0.00,1433.83,0.00,'2022-06-29 17:17:14','',''),(2292,'21','220','1',1,'Sale Id shift 105',0.00,0.00,0.00,909.33,0.00,'2022-06-29 17:17:14','',''),(2293,'21','220','1',1,'Sale Id shift 105',0.00,0.00,0.00,1640.57,0.00,'2022-06-29 17:17:14','',''),(2294,'21','220','2',1,'Sale Id shift 105',0.00,0.00,0.00,3471.87,0.00,'2022-06-29 17:17:14','',''),(2295,'21','220','2',1,'Sale Id shift 105',0.00,0.00,0.00,2846.19,0.00,'2022-06-29 17:17:14','',''),(2296,'21','220','2',1,'Sale Id shift 105',0.00,0.00,0.00,3441.92,0.00,'2022-06-29 17:17:14','',''),(2297,'21','220','2',1,'Sale Id shift 105',0.00,0.00,0.00,2935.65,0.00,'2022-06-29 17:17:14','',''),(2298,'21','220','1',1,'Sale Id shift 105',0.00,0.00,0.00,1307.08,0.00,'2022-06-29 17:17:14','',''),(2299,'21','220','2',1,'Sale Id shift 105',0.00,0.00,0.00,4312.89,0.00,'2022-06-29 17:17:14','',''),(2300,'21','220','2',1,'Sale Id shift 105',0.00,0.00,0.00,2725.45,0.00,'2022-06-29 17:17:14','',''),(2301,'21','220','2',1,'Sale Id shift 105',0.00,0.00,0.00,2694.60,0.00,'2022-06-29 17:17:14','',''),(2302,'21','220','2',1,'Sale Id shift 105',0.00,0.00,0.00,3286.93,0.00,'2022-06-29 17:17:14','',''),(2303,'21','220','1',1,'Sale Id shift 105',0.00,0.00,0.00,2644.16,0.00,'2022-06-29 17:17:14','',''),(2304,'21','220',NULL,2,'Sale Id shift 105',3187656.50,0.00,0.00,0.00,0.00,'2022-06-29 17:17:14','',''),(2305,'21','220',NULL,3,'Sale Id shift 105',813937.50,0.00,0.00,0.00,0.00,'2022-06-29 17:17:14','',''),(2306,'21','220',NULL,1,'Sale Id shift 105',5758181.55,0.00,0.00,0.00,0.00,'2022-06-29 17:17:14','',''),(2307,'21','220','1',1,'Sale Id shift 106',0.00,0.00,0.00,1499.41,0.00,'2022-06-29 18:46:35','',''),(2308,'21','220','3',2,'Sale Id shift 106',0.00,0.00,0.00,5779.34,0.00,'2022-06-29 18:46:35','',''),(2309,'21','220','4',3,'Sale Id shift 106',0.00,0.00,0.00,587.26,0.00,'2022-06-29 18:46:35','',''),(2310,'21','220','1',1,'Sale Id shift 106',0.00,0.00,0.00,1364.17,0.00,'2022-06-29 18:46:35','',''),(2311,'21','220','1',1,'Sale Id shift 106',0.00,0.00,0.00,2310.59,0.00,'2022-06-29 18:46:35','',''),(2312,'21','220','2',1,'Sale Id shift 106',0.00,0.00,0.00,1520.38,0.00,'2022-06-29 18:46:35','',''),(2313,'21','220','2',1,'Sale Id shift 106',0.00,0.00,0.00,1570.93,0.00,'2022-06-29 18:46:35','',''),(2314,'21','220','2',1,'Sale Id shift 106',0.00,0.00,0.00,1336.93,0.00,'2022-06-29 18:46:35','',''),(2315,'21','220','2',1,'Sale Id shift 106',0.00,0.00,0.00,1352.16,0.00,'2022-06-29 18:46:35','',''),(2316,'21','220','1',1,'Sale Id shift 106',0.00,0.00,0.00,1746.08,0.00,'2022-06-29 18:46:35','',''),(2317,'21','220','2',1,'Sale Id shift 106',0.00,0.00,0.00,1730.94,0.00,'2022-06-29 18:46:35','',''),(2318,'21','220','2',1,'Sale Id shift 106',0.00,0.00,0.00,1254.72,0.00,'2022-06-29 18:46:35','',''),(2319,'21','220','2',1,'Sale Id shift 106',0.00,0.00,0.00,1023.24,0.00,'2022-06-29 18:46:35','',''),(2320,'21','220','2',1,'Sale Id shift 106',0.00,0.00,0.00,1487.53,0.00,'2022-06-29 18:46:35','',''),(2321,'21','220','1',1,'Sale Id shift 106',0.00,0.00,0.00,1847.14,0.00,'2022-06-29 18:46:35','',''),(2322,'21','220',NULL,1,'Sale Id shift 106',3307296.30,0.00,0.00,0.00,0.00,'2022-06-29 18:46:35','',''),(2323,'21','220',NULL,2,'Sale Id shift 106',4796852.20,0.00,0.00,0.00,0.00,'2022-06-29 18:46:35','',''),(2324,'21','220',NULL,3,'Sale Id shift 106',440445.00,0.00,0.00,0.00,0.00,'2022-06-29 18:46:35','',''),(2325,'21','220',NULL,1,'Reception corrector for bridging 257',0.00,0.00,0.00,24000.00,0.00,'2022-06-30 12:18:34','',''),(2326,'21','220','2',1,'Received from bridging 257',0.00,0.00,24000.00,0.00,0.00,'2022-06-30 12:18:34','',''),(2327,'21','220',NULL,1,'Reception corrector for bridging 256',0.00,0.00,0.00,16000.00,0.00,'2022-06-30 12:18:34','',''),(2328,'21','220','1',1,'Received from bridging 256',0.00,0.00,16000.00,0.00,0.00,'2022-06-30 12:18:34','',''),(2329,'21','220','3',2,'Sale Id shift 107',0.00,0.00,0.00,6560.69,0.00,'2022-06-30 15:08:32','',''),(2330,'21','220','4',3,'Sale Id shift 107',0.00,0.00,0.00,431.14,0.00,'2022-06-30 15:08:32','',''),(2331,'21','220','1',1,'Sale Id shift 107',0.00,0.00,0.00,1924.08,0.00,'2022-06-30 15:08:32','',''),(2332,'21','220','1',1,'Sale Id shift 107',0.00,0.00,0.00,1462.92,0.00,'2022-06-30 15:08:32','',''),(2333,'21','220','1',1,'Sale Id shift 107',0.00,0.00,0.00,4337.93,0.00,'2022-06-30 15:08:32','',''),(2334,'21','220','2',1,'Sale Id shift 107',0.00,0.00,0.00,4076.31,0.00,'2022-06-30 15:08:32','',''),(2335,'21','220','2',1,'Sale Id shift 107',0.00,0.00,0.00,2695.75,0.00,'2022-06-30 15:08:32','',''),(2336,'21','220','2',1,'Sale Id shift 107',0.00,0.00,0.00,2916.91,0.00,'2022-06-30 15:08:32','',''),(2337,'21','220','2',1,'Sale Id shift 107',0.00,0.00,0.00,3405.16,0.00,'2022-06-30 15:08:32','',''),(2338,'21','220','1',1,'Sale Id shift 107',0.00,0.00,0.00,2170.54,0.00,'2022-06-30 15:08:32','',''),(2339,'21','220','2',1,'Sale Id shift 107',0.00,0.00,0.00,4132.78,0.00,'2022-06-30 15:08:32','',''),(2340,'21','220','2',1,'Sale Id shift 107',0.00,0.00,0.00,3000.17,0.00,'2022-06-30 15:08:32','',''),(2341,'21','220','2',1,'Sale Id shift 107',0.00,0.00,0.00,3243.60,0.00,'2022-06-30 15:08:32','',''),(2342,'21','220','2',1,'Sale Id shift 107',0.00,0.00,0.00,2586.64,0.00,'2022-06-30 15:08:32','',''),(2343,'21','220','1',1,'Sale Id shift 107',0.00,0.00,0.00,2437.79,0.00,'2022-06-30 15:08:32','',''),(2344,'21','220','3',2,'Sale Id shift 107',0.00,0.00,0.00,85.38,0.00,'2022-06-30 15:08:32','',''),(2345,'21','220',NULL,2,'Sale Id shift 107',5516238.10,0.00,0.00,0.00,0.00,'2022-06-30 15:08:32','',''),(2346,'21','220',NULL,3,'Sale Id shift 107',323355.00,0.00,0.00,0.00,0.00,'2022-06-30 15:08:32','',''),(2347,'21','220',NULL,1,'Sale Id shift 107',6334445.70,0.00,0.00,0.00,0.00,'2022-06-30 15:08:32','',''),(2348,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-30 15:19:03','',''),(2349,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,16600000.00,20000.00,0.00,0.00,'2022-06-30 15:21:46','',''),(2350,'21','220',NULL,1,'Reception corrector for bridging 259',0.00,0.00,0.00,26500.00,0.00,'2022-06-30 15:23:17','',''),(2351,'21','220','2',1,'Received from bridging 259',0.00,0.00,26500.00,0.00,0.00,'2022-06-30 15:23:17','',''),(2352,'21','220',NULL,1,'Reception corrector for bridging 258',0.00,0.00,0.00,13500.00,0.00,'2022-06-30 15:23:17','',''),(2353,'21','220','1',1,'Received from bridging 258',0.00,0.00,13500.00,0.00,0.00,'2022-06-30 15:23:17','',''),(2354,'21','220',NULL,2,'Reception corrector for bridging 260',0.00,0.00,0.00,20000.00,0.00,'2022-06-30 15:23:27','',''),(2355,'21','220','3',2,'Received from bridging 260',0.00,0.00,20000.00,0.00,0.00,'2022-06-30 15:23:27','',''),(2356,'21','220','1',1,'Sale Id shift 108',0.00,0.00,0.00,1350.55,0.00,'2022-06-30 16:24:49','',''),(2357,'21','220','3',2,'Sale Id shift 108',0.00,0.00,0.00,2795.30,0.00,'2022-06-30 16:24:49','',''),(2358,'21','220','4',3,'Sale Id shift 108',0.00,0.00,0.00,618.76,0.00,'2022-06-30 16:24:49','',''),(2359,'21','220','1',1,'Sale Id shift 108',0.00,0.00,0.00,1863.01,0.00,'2022-06-30 16:24:49','',''),(2360,'21','220','1',1,'Sale Id shift 108',0.00,0.00,0.00,1866.36,0.00,'2022-06-30 16:24:49','',''),(2361,'21','220','1',1,'Sale Id shift 108',0.00,0.00,0.00,693.78,0.00,'2022-06-30 16:24:49','',''),(2362,'21','220','1',1,'Sale Id shift 108',0.00,0.00,0.00,4099.89,0.00,'2022-06-30 16:24:49','',''),(2363,'21','220','2',1,'Sale Id shift 108',0.00,0.00,0.00,3520.07,0.00,'2022-06-30 16:24:49','',''),(2364,'21','220','2',1,'Sale Id shift 108',0.00,0.00,0.00,2957.81,0.00,'2022-06-30 16:24:49','',''),(2365,'21','220','2',1,'Sale Id shift 108',0.00,0.00,0.00,3439.27,0.00,'2022-06-30 16:24:49','',''),(2366,'21','220','2',1,'Sale Id shift 108',0.00,0.00,0.00,3272.13,0.00,'2022-06-30 16:24:49','',''),(2367,'21','220','1',1,'Sale Id shift 108',0.00,0.00,0.00,1877.37,0.00,'2022-06-30 16:24:49','',''),(2368,'21','220','2',1,'Sale Id shift 108',0.00,0.00,0.00,4749.24,0.00,'2022-06-30 16:24:49','',''),(2369,'21','220','2',1,'Sale Id shift 108',0.00,0.00,0.00,2100.70,0.00,'2022-06-30 16:24:49','',''),(2370,'21','220','2',1,'Sale Id shift 108',0.00,0.00,0.00,3754.98,0.00,'2022-06-30 16:24:49','',''),(2371,'21','220','2',1,'Sale Id shift 108',0.00,0.00,0.00,2962.12,0.00,'2022-06-30 16:24:49','',''),(2372,'21','220','1',1,'Sale Id shift 108',0.00,0.00,0.00,2624.38,0.00,'2022-06-30 16:24:49','',''),(2373,'21','220','3',2,'Sale Id shift 108',0.00,0.00,0.00,895.73,0.00,'2022-06-30 16:24:49','',''),(2374,'21','220',NULL,1,'Sale Id shift 108',6786723.90,0.00,0.00,0.00,0.00,'2022-06-30 16:24:49','',''),(2375,'21','220',NULL,2,'Sale Id shift 108',3063554.90,0.00,0.00,0.00,0.00,'2022-06-30 16:24:49','',''),(2376,'21','220',NULL,3,'Sale Id shift 108',464070.00,0.00,0.00,0.00,0.00,'2022-06-30 16:24:49','',''),(2377,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-30 17:08:09','',''),(2378,'21','220',NULL,1,'Reception corrector for bridging 262',0.00,0.00,0.00,30000.00,0.00,'2022-06-30 17:09:25','',''),(2379,'21','220','2',1,'Received from bridging 262',0.00,0.00,30000.00,0.00,0.00,'2022-06-30 17:09:25','',''),(2380,'21','220',NULL,1,'Reception corrector for bridging 261',0.00,0.00,0.00,15000.00,0.00,'2022-06-30 17:09:25','',''),(2381,'21','220','1',1,'Received from bridging 261',0.00,0.00,15000.00,0.00,0.00,'2022-06-30 17:09:25','',''),(2382,'21','220',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,11250000.00,15000.00,0.00,0.00,'2022-06-30 17:13:28','',''),(2383,'21','220','1',1,'Sale Id shift 109',0.00,0.00,0.00,2680.95,0.00,'2022-06-30 17:13:39','',''),(2384,'21','220','3',2,'Sale Id shift 109',0.00,0.00,0.00,2786.46,0.00,'2022-06-30 17:13:39','',''),(2385,'21','220','4',3,'Sale Id shift 109',0.00,0.00,0.00,620.93,0.00,'2022-06-30 17:13:39','',''),(2386,'21','220','1',1,'Sale Id shift 109',0.00,0.00,0.00,2362.11,0.00,'2022-06-30 17:13:39','',''),(2387,'21','220','1',1,'Sale Id shift 109',0.00,0.00,0.00,2050.46,0.00,'2022-06-30 17:13:39','',''),(2388,'21','220','1',1,'Sale Id shift 109',0.00,0.00,0.00,2790.64,0.00,'2022-06-30 17:13:39','',''),(2389,'21','220','2',1,'Sale Id shift 109',0.00,0.00,0.00,4424.53,0.00,'2022-06-30 17:13:39','',''),(2390,'21','220','2',1,'Sale Id shift 109',0.00,0.00,0.00,4257.82,0.00,'2022-06-30 17:13:39','',''),(2391,'21','220','2',1,'Sale Id shift 109',0.00,0.00,0.00,682.57,0.00,'2022-06-30 17:13:39','',''),(2392,'21','220','1',1,'Sale Id shift 109',0.00,0.00,0.00,2317.05,0.00,'2022-06-30 17:13:39','',''),(2393,'21','220','2',1,'Sale Id shift 109',0.00,0.00,0.00,3905.43,0.00,'2022-06-30 17:13:39','',''),(2394,'21','220','2',1,'Sale Id shift 109',0.00,0.00,0.00,4649.37,0.00,'2022-06-30 17:13:39','',''),(2395,'21','220','2',1,'Sale Id shift 109',0.00,0.00,0.00,3847.70,0.00,'2022-06-30 17:13:39','',''),(2396,'21','220','2',1,'Sale Id shift 109',0.00,0.00,0.00,3590.91,0.00,'2022-06-30 17:13:39','',''),(2397,'21','220','1',1,'Sale Id shift 109',0.00,0.00,0.00,3338.12,0.00,'2022-06-30 17:13:39','',''),(2398,'21','220',NULL,1,'Sale Id shift 109',6748113.90,0.00,0.00,0.00,0.00,'2022-06-30 17:13:39','',''),(2399,'21','220',NULL,2,'Sale Id shift 109',2312761.80,0.00,0.00,0.00,0.00,'2022-06-30 17:13:39','',''),(2400,'21','220',NULL,3,'Sale Id shift 109',465697.50,0.00,0.00,0.00,0.00,'2022-06-30 17:13:39','',''),(2401,'21','220',NULL,3,'Reception corrector for bridging 263',0.00,0.00,0.00,15000.00,0.00,'2022-06-30 17:14:59','',''),(2402,'21','220','4',3,'Received from bridging 263',0.00,0.00,15000.00,0.00,0.00,'2022-06-30 17:14:59','',''),(2403,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-30 17:15:35','',''),(2404,'21','220',NULL,1,'Reception corrector for bridging 265',0.00,0.00,0.00,30000.00,0.00,'2022-06-30 17:18:18','',''),(2405,'21','220','2',1,'Received from bridging 265',0.00,0.00,30000.00,0.00,0.00,'2022-06-30 17:18:18','',''),(2406,'21','220',NULL,1,'Reception corrector for bridging 264',0.00,0.00,0.00,15000.00,0.00,'2022-06-30 17:18:18','',''),(2407,'21','220','1',1,'Received from bridging 264',0.00,0.00,15000.00,0.00,0.00,'2022-06-30 17:18:18','',''),(2408,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-30 17:18:30','',''),(2409,'21','220',NULL,1,'Reception corrector for bridging 267',0.00,0.00,0.00,30000.00,0.00,'2022-06-30 17:20:08','',''),(2410,'21','220','2',1,'Received from bridging 267',0.00,0.00,30000.00,0.00,0.00,'2022-06-30 17:20:08','',''),(2411,'21','220',NULL,1,'Reception corrector for bridging 266',0.00,0.00,0.00,15000.00,0.00,'2022-06-30 17:20:08','',''),(2412,'21','220','1',1,'Received from bridging 266',0.00,0.00,15000.00,0.00,0.00,'2022-06-30 17:20:08','',''),(2413,'21','220','1',1,'Sale Id shift 110',0.00,0.00,0.00,1936.81,0.00,'2022-06-30 18:10:38','',''),(2414,'21','220','3',2,'Sale Id shift 110',0.00,0.00,0.00,2461.50,0.00,'2022-06-30 18:10:38','',''),(2415,'21','220','4',3,'Sale Id shift 110',0.00,0.00,0.00,890.85,0.00,'2022-06-30 18:10:38','',''),(2416,'21','220','1',1,'Sale Id shift 110',0.00,0.00,0.00,670.25,0.00,'2022-06-30 18:10:38','',''),(2417,'21','220','1',1,'Sale Id shift 110',0.00,0.00,0.00,2152.76,0.00,'2022-06-30 18:10:38','',''),(2418,'21','220','1',1,'Sale Id shift 110',0.00,0.00,0.00,1844.98,0.00,'2022-06-30 18:10:38','',''),(2419,'21','220','1',1,'Sale Id shift 110',0.00,0.00,0.00,1575.67,0.00,'2022-06-30 18:10:38','',''),(2420,'21','220','2',1,'Sale Id shift 110',0.00,0.00,0.00,3259.57,0.00,'2022-06-30 18:10:38','',''),(2421,'21','220','2',1,'Sale Id shift 110',0.00,0.00,0.00,2892.95,0.00,'2022-06-30 18:10:38','',''),(2422,'21','220','2',1,'Sale Id shift 110',0.00,0.00,0.00,2743.03,0.00,'2022-06-30 18:10:38','',''),(2423,'21','220','2',1,'Sale Id shift 110',0.00,0.00,0.00,2471.75,0.00,'2022-06-30 18:10:38','',''),(2424,'21','220','1',1,'Sale Id shift 110',0.00,0.00,0.00,1563.65,0.00,'2022-06-30 18:10:38','',''),(2425,'21','220','2',1,'Sale Id shift 110',0.00,0.00,0.00,3904.94,0.00,'2022-06-30 18:10:38','',''),(2426,'21','220','2',1,'Sale Id shift 110',0.00,0.00,0.00,3802.38,0.00,'2022-06-30 18:10:38','',''),(2427,'21','220','2',1,'Sale Id shift 110',0.00,0.00,0.00,3157.07,0.00,'2022-06-30 18:10:38','',''),(2428,'21','220','2',1,'Sale Id shift 110',0.00,0.00,0.00,3095.10,0.00,'2022-06-30 18:10:38','',''),(2429,'21','220','1',1,'Sale Id shift 110',0.00,0.00,0.00,2594.26,0.00,'2022-06-30 18:10:38','',''),(2430,'21','220',NULL,1,'Sale Id shift 110',6214753.05,0.00,0.00,0.00,0.00,'2022-06-30 18:10:38','',''),(2431,'21','220',NULL,2,'Sale Id shift 110',2043045.00,0.00,0.00,0.00,0.00,'2022-06-30 18:10:38','',''),(2432,'21','220',NULL,3,'Sale Id shift 110',668137.50,0.00,0.00,0.00,0.00,'2022-06-30 18:10:38','',''),(2433,'21','220','1',1,'Sale Id shift 111',0.00,0.00,0.00,2744.27,0.00,'2022-06-30 19:00:03','',''),(2434,'21','220','3',2,'Sale Id shift 111',0.00,0.00,0.00,7245.14,0.00,'2022-06-30 19:00:03','',''),(2435,'21','220','4',3,'Sale Id shift 111',0.00,0.00,0.00,982.78,0.00,'2022-06-30 19:00:03','',''),(2436,'21','220','1',1,'Sale Id shift 111',0.00,0.00,0.00,2519.75,0.00,'2022-06-30 19:00:03','',''),(2437,'21','220','1',1,'Sale Id shift 111',0.00,0.00,0.00,1660.12,0.00,'2022-06-30 19:00:03','',''),(2438,'21','220','1',1,'Sale Id shift 111',0.00,0.00,0.00,1604.55,0.00,'2022-06-30 19:00:03','',''),(2439,'21','220','1',1,'Sale Id shift 111',0.00,0.00,0.00,2575.08,0.00,'2022-06-30 19:00:03','',''),(2440,'21','220','2',1,'Sale Id shift 111',0.00,0.00,0.00,5063.76,0.00,'2022-06-30 19:00:03','',''),(2441,'21','220','2',1,'Sale Id shift 111',0.00,0.00,0.00,2627.05,0.00,'2022-06-30 19:00:03','',''),(2442,'21','220','2',1,'Sale Id shift 111',0.00,0.00,0.00,2729.22,0.00,'2022-06-30 19:00:03','',''),(2443,'21','220','2',1,'Sale Id shift 111',0.00,0.00,0.00,4260.86,0.00,'2022-06-30 19:00:03','',''),(2444,'21','220','1',1,'Sale Id shift 111',0.00,0.00,0.00,2542.34,0.00,'2022-06-30 19:00:03','',''),(2445,'21','220','2',1,'Sale Id shift 111',0.00,0.00,0.00,5089.97,0.00,'2022-06-30 19:00:03','',''),(2446,'21','220','2',1,'Sale Id shift 111',0.00,0.00,0.00,3075.86,0.00,'2022-06-30 19:00:03','',''),(2447,'21','220','2',1,'Sale Id shift 111',0.00,0.00,0.00,4872.55,0.00,'2022-06-30 19:00:03','',''),(2448,'21','220','2',1,'Sale Id shift 111',0.00,0.00,0.00,3476.92,0.00,'2022-06-30 19:00:03','',''),(2449,'21','220','1',1,'Sale Id shift 111',0.00,0.00,0.00,3120.24,0.00,'2022-06-30 19:00:03','',''),(2450,'21','220','3',2,'Sale Id shift 111',0.00,0.00,0.00,1654.66,0.00,'2022-06-30 19:00:03','',''),(2451,'21','220',NULL,1,'Sale Id shift 111',7913819.10,0.00,0.00,0.00,0.00,'2022-06-30 19:00:03','',''),(2452,'21','220',NULL,2,'Sale Id shift 111',7386834.00,0.00,0.00,0.00,0.00,'2022-06-30 19:00:03','',''),(2453,'21','220',NULL,3,'Sale Id shift 111',737085.00,0.00,0.00,0.00,0.00,'2022-06-30 19:00:03','',''),(2454,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-01 16:01:03','',''),(2455,'21','220',NULL,1,'Reception corrector for bridging 269',0.00,0.00,0.00,29000.00,0.00,'2022-07-01 16:02:54','',''),(2456,'21','220','2',1,'Received from bridging 269',0.00,0.00,29000.00,0.00,0.00,'2022-07-01 16:02:54','',''),(2457,'21','220',NULL,1,'Reception corrector for bridging 268',0.00,0.00,0.00,11000.00,0.00,'2022-07-01 16:02:54','',''),(2458,'21','220','1',1,'Received from bridging 268',0.00,0.00,11000.00,0.00,0.00,'2022-07-01 16:02:54','',''),(2459,'21','220','2',1,'Returned bridging 269',0.00,0.00,0.00,29000.00,0.00,'2022-07-01 16:05:29','',''),(2460,'21','220',NULL,1,'Reception Return corrector for bridging 269',0.00,0.00,29000.00,0.00,0.00,'2022-07-01 16:05:29','',''),(2461,'21','220','1',1,'Returned bridging 268',0.00,0.00,0.00,11000.00,0.00,'2022-07-01 16:05:52','',''),(2462,'21','220',NULL,1,'Reception Return corrector for bridging 268',0.00,0.00,11000.00,0.00,0.00,'2022-07-01 16:05:52','',''),(2463,'21','220',NULL,1,'Reception corrector for bridging 271',0.00,0.00,0.00,28300.00,0.00,'2022-07-01 16:09:12','',''),(2464,'21','220','2',1,'Received from bridging 271',0.00,0.00,28300.00,0.00,0.00,'2022-07-01 16:09:12','',''),(2465,'21','220',NULL,1,'Reception corrector for bridging 270',0.00,0.00,0.00,11700.00,0.00,'2022-07-01 16:09:12','',''),(2466,'21','220','1',1,'Received from bridging 270',0.00,0.00,11700.00,0.00,0.00,'2022-07-01 16:09:12','',''),(2467,'21','220','1',1,'Sale Id shift 112',0.00,0.00,0.00,2242.20,0.00,'2022-07-01 16:10:12','',''),(2468,'21','220','3',2,'Sale Id shift 112',0.00,0.00,0.00,3732.98,0.00,'2022-07-01 16:10:12','',''),(2469,'21','220','4',3,'Sale Id shift 112',0.00,0.00,0.00,1371.69,0.00,'2022-07-01 16:10:12','',''),(2470,'21','220','1',1,'Sale Id shift 112',0.00,0.00,0.00,1585.06,0.00,'2022-07-01 16:10:12','',''),(2471,'21','220','1',1,'Sale Id shift 112',0.00,0.00,0.00,2007.01,0.00,'2022-07-01 16:10:12','',''),(2472,'21','220','1',1,'Sale Id shift 112',0.00,0.00,0.00,1721.45,0.00,'2022-07-01 16:10:12','',''),(2473,'21','220','1',1,'Sale Id shift 112',0.00,0.00,0.00,3184.45,0.00,'2022-07-01 16:10:12','',''),(2474,'21','220','2',1,'Sale Id shift 112',0.00,0.00,0.00,4097.09,0.00,'2022-07-01 16:10:12','',''),(2475,'21','220','2',1,'Sale Id shift 112',0.00,0.00,0.00,3043.15,0.00,'2022-07-01 16:10:12','',''),(2476,'21','220','2',1,'Sale Id shift 112',0.00,0.00,0.00,3647.99,0.00,'2022-07-01 16:10:12','',''),(2477,'21','220','2',1,'Sale Id shift 112',0.00,0.00,0.00,3224.15,0.00,'2022-07-01 16:10:12','',''),(2478,'21','220','1',1,'Sale Id shift 112',0.00,0.00,0.00,2287.91,0.00,'2022-07-01 16:10:12','',''),(2479,'21','220','2',1,'Sale Id shift 112',0.00,0.00,0.00,4473.54,0.00,'2022-07-01 16:10:12','',''),(2480,'21','220','2',1,'Sale Id shift 112',0.00,0.00,0.00,3363.31,0.00,'2022-07-01 16:10:12','',''),(2481,'21','220','2',1,'Sale Id shift 112',0.00,0.00,0.00,4091.36,0.00,'2022-07-01 16:10:12','',''),(2482,'21','220','2',1,'Sale Id shift 112',0.00,0.00,0.00,3857.95,0.00,'2022-07-01 16:10:12','',''),(2483,'21','220','1',1,'Sale Id shift 112',0.00,0.00,0.00,2639.63,0.00,'2022-07-01 16:10:12','',''),(2484,'21','220',NULL,2,'Sale Id shift 112',3098373.40,0.00,0.00,0.00,0.00,'2022-07-01 16:10:12','',''),(2485,'21','220',NULL,3,'Sale Id shift 112',1028767.50,0.00,0.00,0.00,0.00,'2022-07-01 16:10:12','',''),(2486,'21','220',NULL,1,'Sale Id shift 112',7501931.25,0.00,0.00,0.00,0.00,'2022-07-01 16:10:12','',''),(2487,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,3300000.00,20000.00,0.00,0.00,'2022-07-01 16:48:41','',''),(2488,'21','220',NULL,1,'Reception corrector for bridging 272',0.00,0.00,0.00,20000.00,0.00,'2022-07-01 16:49:41','',''),(2489,'21','220','2',1,'Received from bridging 272',0.00,0.00,20000.00,0.00,0.00,'2022-07-01 16:49:41','',''),(2490,'21','220','2',1,'Returned bridging 272',0.00,0.00,0.00,20000.00,0.00,'2022-07-01 16:54:56','',''),(2491,'21','220',NULL,1,'Reception Return corrector for bridging 272',0.00,0.00,20000.00,0.00,0.00,'2022-07-01 16:54:56','',''),(2492,'21','220',NULL,1,'Reception corrector for bridging 274',0.00,0.00,0.00,10700.00,0.00,'2022-07-01 16:57:01','',''),(2493,'21','220','2',1,'Received from bridging 274',0.00,0.00,10700.00,0.00,0.00,'2022-07-01 16:57:01','',''),(2494,'21','220',NULL,1,'Reception corrector for bridging 273',0.00,0.00,0.00,9300.00,0.00,'2022-07-01 16:57:01','',''),(2495,'21','220','1',1,'Received from bridging 273',0.00,0.00,9300.00,0.00,0.00,'2022-07-01 16:57:01','',''),(2496,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-01 17:01:01','',''),(2497,'21','220',NULL,1,'Reception corrector for bridging 275',0.00,0.00,0.00,580.00,0.00,'2022-07-01 17:02:02','',''),(2498,'21','220','2',1,'Received from bridging 275',0.00,0.00,580.00,0.00,0.00,'2022-07-01 17:02:02','',''),(2499,'21','220',NULL,1,'Reception corrector for bridging 277',0.00,0.00,0.00,1000.00,0.00,'2022-07-01 17:04:41','',''),(2500,'21','220','2',1,'Received from bridging 277',0.00,0.00,1000.00,0.00,0.00,'2022-07-01 17:04:41','',''),(2501,'21','220',NULL,1,'Reception corrector for bridging 276',0.00,0.00,0.00,1000.00,0.00,'2022-07-01 17:04:41','',''),(2502,'21','220','1',1,'Received from bridging 276',0.00,0.00,1000.00,0.00,0.00,'2022-07-01 17:04:41','',''),(2503,'21','220','1',1,'Returned bridging 276',0.00,0.00,0.00,1000.00,0.00,'2022-07-02 07:42:55','',''),(2504,'21','220',NULL,1,'Reception Return corrector for bridging 276',0.00,0.00,1000.00,0.00,0.00,'2022-07-02 07:42:55','',''),(2505,'21','220','2',1,'Returned bridging 277',0.00,0.00,0.00,1000.00,0.00,'2022-07-02 07:45:38','',''),(2506,'21','220',NULL,1,'Reception Return corrector for bridging 277',0.00,0.00,1000.00,0.00,0.00,'2022-07-02 07:45:38','',''),(2507,'21','220','2',1,'Returned bridging 275',0.00,0.00,0.00,580.00,0.00,'2022-07-02 07:46:02','',''),(2508,'21','220',NULL,1,'Reception Return corrector for bridging 275',0.00,0.00,580.00,0.00,0.00,'2022-07-02 07:46:02','',''),(2509,'21','220',NULL,1,'Returned purchase #150 to AYM SHAFA NIGERIA LIMITED',6600000.00,0.00,0.00,40000.00,0.00,'2022-07-02 07:46:28','',''),(2510,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6987750.00,42350.00,0.00,0.00,'2022-07-02 07:48:08','',''),(2511,'21','220',NULL,1,'Reception corrector for bridging 280',0.00,0.00,0.00,4888.53,0.00,'2022-07-02 07:52:12','',''),(2512,'21','220','2',1,'Received from bridging 280',0.00,0.00,4888.53,0.00,0.00,'2022-07-02 07:52:12','',''),(2513,'21','220','1',1,'Sale Id shift 113',0.00,0.00,0.00,964.09,0.00,'2022-07-03 15:23:22','',''),(2514,'21','220','3',2,'Sale Id shift 113',0.00,0.00,0.00,5434.70,0.00,'2022-07-03 15:23:22','',''),(2515,'21','220','4',3,'Sale Id shift 113',0.00,0.00,0.00,995.22,0.00,'2022-07-03 15:23:22','',''),(2516,'21','220','1',1,'Sale Id shift 113',0.00,0.00,0.00,1368.42,0.00,'2022-07-03 15:23:22','',''),(2517,'21','220','1',1,'Sale Id shift 113',0.00,0.00,0.00,1033.97,0.00,'2022-07-03 15:23:22','',''),(2518,'21','220','1',1,'Sale Id shift 113',0.00,0.00,0.00,1181.66,0.00,'2022-07-03 15:23:22','',''),(2519,'21','220','1',1,'Sale Id shift 113',0.00,0.00,0.00,1589.17,0.00,'2022-07-03 15:23:22','',''),(2520,'21','220','2',1,'Sale Id shift 113',0.00,0.00,0.00,4308.87,0.00,'2022-07-03 15:23:22','',''),(2521,'21','220','2',1,'Sale Id shift 113',0.00,0.00,0.00,3511.90,0.00,'2022-07-03 15:23:22','',''),(2522,'21','220','2',1,'Sale Id shift 113',0.00,0.00,0.00,3248.08,0.00,'2022-07-03 15:23:22','',''),(2523,'21','220','2',1,'Sale Id shift 113',0.00,0.00,0.00,3973.91,0.00,'2022-07-03 15:23:22','',''),(2524,'21','220','1',1,'Sale Id shift 113',0.00,0.00,0.00,1219.97,0.00,'2022-07-03 15:23:22','',''),(2525,'21','220','2',1,'Sale Id shift 113',0.00,0.00,0.00,4153.10,0.00,'2022-07-03 15:23:22','',''),(2526,'21','220','2',1,'Sale Id shift 113',0.00,0.00,0.00,4227.35,0.00,'2022-07-03 15:23:22','',''),(2527,'21','220','2',1,'Sale Id shift 113',0.00,0.00,0.00,4055.16,0.00,'2022-07-03 15:23:22','',''),(2528,'21','220','2',1,'Sale Id shift 113',0.00,0.00,0.00,4962.16,0.00,'2022-07-03 15:23:22','',''),(2529,'21','220','1',1,'Sale Id shift 113',0.00,0.00,0.00,1903.14,0.00,'2022-07-03 15:23:22','',''),(2530,'21','220','3',2,'Sale Id shift 113',0.00,0.00,0.00,400.76,0.00,'2022-07-03 15:23:22','',''),(2531,'21','220',NULL,1,'Sale Id shift 113',6880656.75,0.00,0.00,0.00,0.00,'2022-07-03 15:23:22','',''),(2532,'21','220',NULL,2,'Sale Id shift 113',4843431.80,0.00,0.00,0.00,0.00,'2022-07-03 15:23:22','',''),(2533,'21','220',NULL,3,'Sale Id shift 113',746415.00,0.00,0.00,0.00,0.00,'2022-07-03 15:23:22','',''),(2534,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7644233.85,46328.69,0.00,0.00,'2022-07-03 15:33:22','',''),(2535,'21','220',NULL,1,'Reception corrector for bridging 282',0.00,0.00,0.00,32394.98,0.00,'2022-07-03 15:35:48','',''),(2536,'21','220','2',1,'Received from bridging 282',0.00,0.00,32394.98,0.00,0.00,'2022-07-03 15:35:48','',''),(2537,'21','220',NULL,1,'Reception corrector for bridging 281',0.00,0.00,0.00,5066.49,0.00,'2022-07-03 15:35:48','',''),(2538,'21','220','1',1,'Received from bridging 281',0.00,0.00,5066.49,0.00,0.00,'2022-07-03 15:35:48','',''),(2539,'21','220','2',1,'Returned bridging 282',0.00,0.00,0.00,32394.98,0.00,'2022-07-03 15:36:52','',''),(2540,'21','220',NULL,1,'Reception Return corrector for bridging 282',0.00,0.00,32394.98,0.00,0.00,'2022-07-03 15:36:52','',''),(2541,'21','220',NULL,1,'Reception corrector for bridging 284',0.00,0.00,0.00,25824.39,0.00,'2022-07-03 15:46:10','',''),(2542,'21','220','2',1,'Received from bridging 284',0.00,0.00,25824.39,0.00,0.00,'2022-07-03 15:46:10','',''),(2543,'21','220',NULL,1,'Reception corrector for bridging 283',0.00,0.00,0.00,6570.59,0.00,'2022-07-03 15:46:10','',''),(2544,'21','220','1',1,'Received from bridging 283',0.00,0.00,6570.59,0.00,0.00,'2022-07-03 15:46:10','',''),(2545,'21','220',NULL,1,'Reception corrector for bridging 285',0.00,0.00,0.00,1328.69,0.00,'2022-07-03 15:48:06','',''),(2546,'21','220','1',1,'Received from bridging 285',0.00,0.00,1328.69,0.00,0.00,'2022-07-03 15:48:06','',''),(2547,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,28220000.00,34000.00,0.00,0.00,'2022-07-03 16:04:21','',''),(2548,'21','220',NULL,2,'Reception corrector for bridging 286',0.00,0.00,0.00,34000.00,0.00,'2022-07-03 16:05:30','',''),(2549,'21','220','3',2,'Received from bridging 286',0.00,0.00,34000.00,0.00,0.00,'2022-07-03 16:05:30','',''),(2550,'21','220','1',1,'Sale Id shift 114',0.00,0.00,0.00,706.71,0.00,'2022-07-03 17:34:13','',''),(2551,'21','220','3',2,'Sale Id shift 114',0.00,0.00,0.00,4901.07,0.00,'2022-07-03 17:34:13','',''),(2552,'21','220','4',3,'Sale Id shift 114',0.00,0.00,0.00,789.68,0.00,'2022-07-03 17:34:13','',''),(2553,'21','220','1',1,'Sale Id shift 114',0.00,0.00,0.00,1043.16,0.00,'2022-07-03 17:34:13','',''),(2554,'21','220','1',1,'Sale Id shift 114',0.00,0.00,0.00,538.13,0.00,'2022-07-03 17:34:13','',''),(2555,'21','220','1',1,'Sale Id shift 114',0.00,0.00,0.00,867.67,0.00,'2022-07-03 17:34:13','',''),(2556,'21','220','2',1,'Sale Id shift 114',0.00,0.00,0.00,2057.89,0.00,'2022-07-03 17:34:13','',''),(2557,'21','220','2',1,'Sale Id shift 114',0.00,0.00,0.00,1916.65,0.00,'2022-07-03 17:34:13','',''),(2558,'21','220','2',1,'Sale Id shift 114',0.00,0.00,0.00,1924.87,0.00,'2022-07-03 17:34:13','',''),(2559,'21','220','2',1,'Sale Id shift 114',0.00,0.00,0.00,2265.07,0.00,'2022-07-03 17:34:13','',''),(2560,'21','220','1',1,'Sale Id shift 114',0.00,0.00,0.00,885.25,0.00,'2022-07-03 17:34:13','',''),(2561,'21','220','2',1,'Sale Id shift 114',0.00,0.00,0.00,2791.43,0.00,'2022-07-03 17:34:13','',''),(2562,'21','220','2',1,'Sale Id shift 114',0.00,0.00,0.00,1925.51,0.00,'2022-07-03 17:34:13','',''),(2563,'21','220','2',1,'Sale Id shift 114',0.00,0.00,0.00,1997.19,0.00,'2022-07-03 17:34:13','',''),(2564,'21','220','2',1,'Sale Id shift 114',0.00,0.00,0.00,2237.01,0.00,'2022-07-03 17:34:13','',''),(2565,'21','220','1',1,'Sale Id shift 114',0.00,0.00,0.00,1230.87,0.00,'2022-07-03 17:34:13','',''),(2566,'21','220',NULL,1,'Sale Id shift 114',3693922.65,0.00,0.00,0.00,0.00,'2022-07-03 17:34:13','',''),(2567,'21','220',NULL,2,'Sale Id shift 114',4067888.10,0.00,0.00,0.00,0.00,'2022-07-03 17:34:13','',''),(2568,'21','220',NULL,3,'Sale Id shift 114',592260.00,0.00,0.00,0.00,0.00,'2022-07-03 17:34:13','',''),(2569,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-03 18:30:39','',''),(2570,'21','220',NULL,1,'Reception corrector for bridging 288',0.00,0.00,0.00,26500.00,0.00,'2022-07-03 18:33:15','',''),(2571,'21','220','2',1,'Received from bridging 288',0.00,0.00,26500.00,0.00,0.00,'2022-07-03 18:33:15','',''),(2572,'21','220',NULL,1,'Reception corrector for bridging 287',0.00,0.00,0.00,13500.00,0.00,'2022-07-03 18:33:15','',''),(2573,'21','220','1',1,'Received from bridging 287',0.00,0.00,13500.00,0.00,0.00,'2022-07-03 18:33:15','',''),(2574,'21','220','2',1,'Returned bridging 288',0.00,0.00,0.00,26500.00,0.00,'2022-07-04 14:52:17','',''),(2575,'21','220',NULL,1,'Reception Return corrector for bridging 288',0.00,0.00,26500.00,0.00,0.00,'2022-07-04 14:52:17','',''),(2576,'21','220','1',1,'Returned bridging 287',0.00,0.00,0.00,13500.00,0.00,'2022-07-04 14:53:02','',''),(2577,'21','220',NULL,1,'Reception Return corrector for bridging 287',0.00,0.00,13500.00,0.00,0.00,'2022-07-04 14:53:02','',''),(2578,'21','220',NULL,1,'Reception corrector for bridging 290',0.00,0.00,0.00,30000.00,0.00,'2022-07-04 14:55:55','',''),(2579,'21','220','2',1,'Received from bridging 290',0.00,0.00,30000.00,0.00,0.00,'2022-07-04 14:55:55','',''),(2580,'21','220',NULL,1,'Reception corrector for bridging 289',0.00,0.00,0.00,15000.00,0.00,'2022-07-04 14:55:55','',''),(2581,'21','220','1',1,'Received from bridging 289',0.00,0.00,15000.00,0.00,0.00,'2022-07-04 14:55:55','',''),(2582,'21','220','1',1,'Sale Id shift 115',0.00,0.00,0.00,1708.18,0.00,'2022-07-04 15:38:54','',''),(2583,'21','220','3',2,'Sale Id shift 115',0.00,0.00,0.00,6211.36,0.00,'2022-07-04 15:38:54','',''),(2584,'21','220','4',3,'Sale Id shift 115',0.00,0.00,0.00,815.00,0.00,'2022-07-04 15:38:54','',''),(2585,'21','220','1',1,'Sale Id shift 115',0.00,0.00,0.00,1865.74,0.00,'2022-07-04 15:38:54','',''),(2586,'21','220','1',1,'Sale Id shift 115',0.00,0.00,0.00,1343.79,0.00,'2022-07-04 15:38:54','',''),(2587,'21','220','1',1,'Sale Id shift 115',0.00,0.00,0.00,1743.94,0.00,'2022-07-04 15:38:54','',''),(2588,'21','220','1',1,'Sale Id shift 115',0.00,0.00,0.00,2327.12,0.00,'2022-07-04 15:38:54','',''),(2589,'21','220','2',1,'Sale Id shift 115',0.00,0.00,0.00,3626.23,0.00,'2022-07-04 15:38:54','',''),(2590,'21','220','2',1,'Sale Id shift 115',0.00,0.00,0.00,2725.90,0.00,'2022-07-04 15:38:54','',''),(2591,'21','220','2',1,'Sale Id shift 115',0.00,0.00,0.00,2546.58,0.00,'2022-07-04 15:38:54','',''),(2592,'21','220','2',1,'Sale Id shift 115',0.00,0.00,0.00,2794.55,0.00,'2022-07-04 15:38:54','',''),(2593,'21','220','1',1,'Sale Id shift 115',0.00,0.00,0.00,1590.73,0.00,'2022-07-04 15:38:54','',''),(2594,'21','220','2',1,'Sale Id shift 115',0.00,0.00,0.00,3986.91,0.00,'2022-07-04 15:38:54','',''),(2595,'21','220','2',1,'Sale Id shift 115',0.00,0.00,0.00,2745.74,0.00,'2022-07-04 15:38:54','',''),(2596,'21','220','2',1,'Sale Id shift 115',0.00,0.00,0.00,3563.85,0.00,'2022-07-04 15:38:54','',''),(2597,'21','220','2',1,'Sale Id shift 115',0.00,0.00,0.00,3834.63,0.00,'2022-07-04 15:38:54','',''),(2598,'21','220','1',1,'Sale Id shift 115',0.00,0.00,0.00,2385.80,0.00,'2022-07-04 15:38:54','',''),(2599,'21','220',NULL,2,'Sale Id shift 115',5155428.80,0.00,0.00,0.00,0.00,'2022-07-04 15:38:54','',''),(2600,'21','220',NULL,3,'Sale Id shift 115',611250.00,0.00,0.00,0.00,0.00,'2022-07-04 15:38:54','',''),(2601,'21','220',NULL,1,'Sale Id shift 115',6400298.85,0.00,0.00,0.00,0.00,'2022-07-04 15:38:54','',''),(2602,'21','220',NULL,1,'Reception corrector for bridging 292',0.00,0.00,0.00,26500.00,0.00,'2022-07-04 16:03:58','',''),(2603,'21','220','2',1,'Received from bridging 292',0.00,0.00,26500.00,0.00,0.00,'2022-07-04 16:03:58','',''),(2604,'21','220',NULL,1,'Reception corrector for bridging 291',0.00,0.00,0.00,13500.00,0.00,'2022-07-04 16:03:58','',''),(2605,'21','220','1',1,'Received from bridging 291',0.00,0.00,13500.00,0.00,0.00,'2022-07-04 16:03:58','',''),(2606,'21','220','3',2,'Sale Id shift 116',0.00,0.00,0.00,2724.75,0.00,'2022-07-04 17:32:02','',''),(2607,'21','220','4',3,'Sale Id shift 116',0.00,0.00,0.00,969.20,0.00,'2022-07-04 17:32:02','',''),(2608,'21','220','1',1,'Sale Id shift 116',0.00,0.00,0.00,2651.31,0.00,'2022-07-04 17:32:02','',''),(2609,'21','220','1',1,'Sale Id shift 116',0.00,0.00,0.00,2457.18,0.00,'2022-07-04 17:32:02','',''),(2610,'21','220','1',1,'Sale Id shift 116',0.00,0.00,0.00,750.25,0.00,'2022-07-04 17:32:02','',''),(2611,'21','220','2',1,'Sale Id shift 116',0.00,0.00,0.00,4132.88,0.00,'2022-07-04 17:32:02','',''),(2612,'21','220','2',1,'Sale Id shift 116',0.00,0.00,0.00,3515.31,0.00,'2022-07-04 17:32:02','',''),(2613,'21','220','2',1,'Sale Id shift 116',0.00,0.00,0.00,3767.07,0.00,'2022-07-04 17:32:02','',''),(2614,'21','220','2',1,'Sale Id shift 116',0.00,0.00,0.00,2939.86,0.00,'2022-07-04 17:32:02','',''),(2615,'21','220','1',1,'Sale Id shift 116',0.00,0.00,0.00,3047.64,0.00,'2022-07-04 17:32:02','',''),(2616,'21','220','2',1,'Sale Id shift 116',0.00,0.00,0.00,3860.14,0.00,'2022-07-04 17:32:02','',''),(2617,'21','220','2',1,'Sale Id shift 116',0.00,0.00,0.00,3341.09,0.00,'2022-07-04 17:32:02','',''),(2618,'21','220','2',1,'Sale Id shift 116',0.00,0.00,0.00,3878.83,0.00,'2022-07-04 17:32:02','',''),(2619,'21','220','2',1,'Sale Id shift 116',0.00,0.00,0.00,2778.39,0.00,'2022-07-04 17:32:02','',''),(2620,'21','220','1',1,'Sale Id shift 116',0.00,0.00,0.00,3254.18,0.00,'2022-07-04 17:32:02','',''),(2621,'21','220',NULL,1,'Sale Id shift 116',6661731.45,0.00,0.00,0.00,0.00,'2022-07-04 17:32:02','',''),(2622,'21','220',NULL,2,'Sale Id shift 116',2261542.50,0.00,0.00,0.00,0.00,'2022-07-04 17:32:02','',''),(2623,'21','220',NULL,3,'Sale Id shift 116',726900.00,0.00,0.00,0.00,0.00,'2022-07-04 17:32:02','',''),(2624,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-08 15:12:29','',''),(2625,'21','220',NULL,1,'Reception corrector for bridging 294',0.00,0.00,0.00,27000.00,0.00,'2022-07-08 15:13:59','',''),(2626,'21','220','2',1,'Received from bridging 294',0.00,0.00,27000.00,0.00,0.00,'2022-07-08 15:13:59','',''),(2627,'21','220',NULL,1,'Reception corrector for bridging 293',0.00,0.00,0.00,13000.00,0.00,'2022-07-08 15:13:59','',''),(2628,'21','220','1',1,'Received from bridging 293',0.00,0.00,13000.00,0.00,0.00,'2022-07-08 15:13:59','',''),(2629,'21','220','1',1,'Sale Id shift 117',0.00,0.00,0.00,3252.18,0.00,'2022-07-08 15:19:06','',''),(2630,'21','220','3',2,'Sale Id shift 117',0.00,0.00,0.00,4575.91,0.00,'2022-07-08 15:19:06','',''),(2631,'21','220','4',3,'Sale Id shift 117',0.00,0.00,0.00,950.32,0.00,'2022-07-08 15:19:06','',''),(2632,'21','220','1',1,'Sale Id shift 117',0.00,0.00,0.00,2827.31,0.00,'2022-07-08 15:19:06','',''),(2633,'21','220','1',1,'Sale Id shift 117',0.00,0.00,0.00,471.61,0.00,'2022-07-08 15:19:06','',''),(2634,'21','220','1',1,'Sale Id shift 117',0.00,0.00,0.00,3535.83,0.00,'2022-07-08 15:19:06','',''),(2635,'21','220','2',1,'Sale Id shift 117',0.00,0.00,0.00,4381.46,0.00,'2022-07-08 15:19:06','',''),(2636,'21','220','2',1,'Sale Id shift 117',0.00,0.00,0.00,3222.77,0.00,'2022-07-08 15:19:06','',''),(2637,'21','220','2',1,'Sale Id shift 117',0.00,0.00,0.00,2857.54,0.00,'2022-07-08 15:19:06','',''),(2638,'21','220','2',1,'Sale Id shift 117',0.00,0.00,0.00,3354.83,0.00,'2022-07-08 15:19:06','',''),(2639,'21','220','1',1,'Sale Id shift 117',0.00,0.00,0.00,2225.27,0.00,'2022-07-08 15:19:06','',''),(2640,'21','220','2',1,'Sale Id shift 117',0.00,0.00,0.00,4203.99,0.00,'2022-07-08 15:19:06','',''),(2641,'21','220','2',1,'Sale Id shift 117',0.00,0.00,0.00,3219.62,0.00,'2022-07-08 15:19:06','',''),(2642,'21','220','2',1,'Sale Id shift 117',0.00,0.00,0.00,4033.69,0.00,'2022-07-08 15:19:06','',''),(2643,'21','220','2',1,'Sale Id shift 117',0.00,0.00,0.00,3642.80,0.00,'2022-07-08 15:19:06','',''),(2644,'21','220','1',1,'Sale Id shift 117',0.00,0.00,0.00,4054.79,0.00,'2022-07-08 15:19:06','',''),(2645,'21','220',NULL,1,'Sale Id shift 117',7471808.85,0.00,0.00,0.00,0.00,'2022-07-08 15:19:06','',''),(2646,'21','220',NULL,2,'Sale Id shift 117',3798005.30,0.00,0.00,0.00,0.00,'2022-07-08 15:19:06','',''),(2647,'21','220',NULL,3,'Sale Id shift 117',712740.00,0.00,0.00,0.00,0.00,'2022-07-08 15:19:06','',''),(2648,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-08 15:54:23','',''),(2649,'21','220',NULL,1,'Reception corrector for bridging 296',0.00,0.00,0.00,30000.00,0.00,'2022-07-08 16:17:03','',''),(2650,'21','220','2',1,'Received from bridging 296',0.00,0.00,30000.00,0.00,0.00,'2022-07-08 16:17:03','',''),(2651,'21','220',NULL,1,'Reception corrector for bridging 295',0.00,0.00,0.00,15000.00,0.00,'2022-07-08 16:17:03','',''),(2652,'21','220','1',1,'Received from bridging 295',0.00,0.00,15000.00,0.00,0.00,'2022-07-08 16:17:03','',''),(2653,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-08 17:24:18','',''),(2654,'21','220','1',1,'Sale Id shift 118',0.00,0.00,0.00,2423.04,0.00,'2022-07-08 18:17:52','',''),(2655,'21','220','3',2,'Sale Id shift 118',0.00,0.00,0.00,3802.04,0.00,'2022-07-08 18:17:52','',''),(2656,'21','220','4',3,'Sale Id shift 118',0.00,0.00,0.00,1045.32,0.00,'2022-07-08 18:17:52','',''),(2657,'21','220','1',1,'Sale Id shift 118',0.00,0.00,0.00,1961.21,0.00,'2022-07-08 18:17:52','',''),(2658,'21','220','1',1,'Sale Id shift 118',0.00,0.00,0.00,1100.20,0.00,'2022-07-08 18:17:52','',''),(2659,'21','220','1',1,'Sale Id shift 118',0.00,0.00,0.00,3059.67,0.00,'2022-07-08 18:17:52','',''),(2660,'21','220','2',1,'Sale Id shift 118',0.00,0.00,0.00,3600.82,0.00,'2022-07-08 18:17:52','',''),(2661,'21','220','2',1,'Sale Id shift 118',0.00,0.00,0.00,2889.59,0.00,'2022-07-08 18:17:52','',''),(2662,'21','220','2',1,'Sale Id shift 118',0.00,0.00,0.00,2923.59,0.00,'2022-07-08 18:17:52','',''),(2663,'21','220','2',1,'Sale Id shift 118',0.00,0.00,0.00,2630.56,0.00,'2022-07-08 18:17:52','',''),(2664,'21','220','1',1,'Sale Id shift 118',0.00,0.00,0.00,2149.02,0.00,'2022-07-08 18:17:52','',''),(2665,'21','220','2',1,'Sale Id shift 118',0.00,0.00,0.00,4204.19,0.00,'2022-07-08 18:17:52','',''),(2666,'21','220','2',1,'Sale Id shift 118',0.00,0.00,0.00,3367.05,0.00,'2022-07-08 18:17:52','',''),(2667,'21','220','2',1,'Sale Id shift 118',0.00,0.00,0.00,3358.78,0.00,'2022-07-08 18:17:52','',''),(2668,'21','220','2',1,'Sale Id shift 118',0.00,0.00,0.00,3632.36,0.00,'2022-07-08 18:17:52','',''),(2669,'21','220','1',1,'Sale Id shift 118',0.00,0.00,0.00,2769.48,0.00,'2022-07-08 18:17:52','',''),(2670,'21','220','3',2,'Sale Id shift 118',0.00,0.00,0.00,3351.38,0.00,'2022-07-08 18:17:52','',''),(2671,'21','220',NULL,1,'Sale Id shift 118',6611477.40,0.00,0.00,0.00,0.00,'2022-07-08 18:17:52','',''),(2672,'21','220',NULL,2,'Sale Id shift 118',5937338.60,0.00,0.00,0.00,0.00,'2022-07-08 18:17:52','',''),(2673,'21','220',NULL,3,'Sale Id shift 118',783990.00,0.00,0.00,0.00,0.00,'2022-07-08 18:17:52','',''),(2674,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,13280000.00,16000.00,0.00,0.00,'2022-07-09 06:00:14','',''),(2675,'21','220',NULL,2,'Reception corrector for bridging 299',0.00,0.00,0.00,16000.00,0.00,'2022-07-09 06:01:19','',''),(2676,'21','220','3',2,'Received from bridging 299',0.00,0.00,16000.00,0.00,0.00,'2022-07-09 06:01:19','',''),(2677,'21','220',NULL,1,'Reception corrector for bridging 298',0.00,0.00,0.00,30000.00,0.00,'2022-07-09 16:24:56','',''),(2678,'21','220','2',1,'Received from bridging 298',0.00,0.00,30000.00,0.00,0.00,'2022-07-09 16:24:56','',''),(2679,'21','220',NULL,1,'Reception corrector for bridging 297',0.00,0.00,0.00,15000.00,0.00,'2022-07-09 16:24:56','',''),(2680,'21','220','1',1,'Received from bridging 297',0.00,0.00,15000.00,0.00,0.00,'2022-07-09 16:24:56','',''),(2681,'21','220','1',1,'Sale Id shift 119',0.00,0.00,0.00,1516.07,0.00,'2022-07-09 16:30:45','',''),(2682,'21','220','3',2,'Sale Id shift 119',0.00,0.00,0.00,2406.46,0.00,'2022-07-09 16:30:45','',''),(2683,'21','220','4',3,'Sale Id shift 119',0.00,0.00,0.00,1496.12,0.00,'2022-07-09 16:30:45','',''),(2684,'21','220','1',1,'Sale Id shift 119',0.00,0.00,0.00,2717.58,0.00,'2022-07-09 16:30:45','',''),(2685,'21','220','1',1,'Sale Id shift 119',0.00,0.00,0.00,1544.02,0.00,'2022-07-09 16:30:45','',''),(2686,'21','220','1',1,'Sale Id shift 119',0.00,0.00,0.00,4228.74,0.00,'2022-07-09 16:30:45','',''),(2687,'21','220','2',1,'Sale Id shift 119',0.00,0.00,0.00,4013.39,0.00,'2022-07-09 16:30:45','',''),(2688,'21','220','2',1,'Sale Id shift 119',0.00,0.00,0.00,3975.31,0.00,'2022-07-09 16:30:45','',''),(2689,'21','220','2',1,'Sale Id shift 119',0.00,0.00,0.00,2861.75,0.00,'2022-07-09 16:30:45','',''),(2690,'21','220','2',1,'Sale Id shift 119',0.00,0.00,0.00,4372.89,0.00,'2022-07-09 16:30:45','',''),(2691,'21','220','1',1,'Sale Id shift 119',0.00,0.00,0.00,3110.82,0.00,'2022-07-09 16:30:45','',''),(2692,'21','220','2',1,'Sale Id shift 119',0.00,0.00,0.00,2746.24,0.00,'2022-07-09 16:30:45','',''),(2693,'21','220','2',1,'Sale Id shift 119',0.00,0.00,0.00,4496.67,0.00,'2022-07-09 16:30:45','',''),(2694,'21','220','2',1,'Sale Id shift 119',0.00,0.00,0.00,4440.05,0.00,'2022-07-09 16:30:45','',''),(2695,'21','220','2',1,'Sale Id shift 119',0.00,0.00,0.00,4386.90,0.00,'2022-07-09 16:30:45','',''),(2696,'21','220','1',1,'Sale Id shift 119',0.00,0.00,0.00,3401.92,0.00,'2022-07-09 16:30:45','',''),(2697,'21','220',NULL,2,'Sale Id shift 119',1997361.80,0.00,0.00,0.00,0.00,'2022-07-09 16:30:45','',''),(2698,'21','220',NULL,3,'Sale Id shift 119',1122090.00,0.00,0.00,0.00,0.00,'2022-07-09 16:30:45','',''),(2699,'21','220',NULL,1,'Sale Id shift 119',7889037.75,0.00,0.00,0.00,0.00,'2022-07-09 16:30:45','',''),(2700,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-09 17:34:07','',''),(2701,'21','220',NULL,1,'Reception corrector for bridging 301',0.00,0.00,0.00,30000.00,0.00,'2022-07-09 17:38:00','',''),(2702,'21','220','2',1,'Received from bridging 301',0.00,0.00,30000.00,0.00,0.00,'2022-07-09 17:38:00','',''),(2703,'21','220',NULL,1,'Reception corrector for bridging 300',0.00,0.00,0.00,15000.00,0.00,'2022-07-09 17:38:04','',''),(2704,'21','220','1',1,'Received from bridging 300',0.00,0.00,15000.00,0.00,0.00,'2022-07-09 17:38:04','',''),(2705,'21','220','1',1,'Sale Id shift 120',0.00,0.00,0.00,1380.02,0.00,'2022-07-09 17:39:51','',''),(2706,'21','220','3',2,'Sale Id shift 120',0.00,0.00,0.00,3521.11,0.00,'2022-07-09 17:39:51','',''),(2707,'21','220','4',3,'Sale Id shift 120',0.00,0.00,0.00,725.69,0.00,'2022-07-09 17:39:51','',''),(2708,'21','220','1',1,'Sale Id shift 120',0.00,0.00,0.00,1851.98,0.00,'2022-07-09 17:39:51','',''),(2709,'21','220','1',1,'Sale Id shift 120',0.00,0.00,0.00,1719.37,0.00,'2022-07-09 17:39:51','',''),(2710,'21','220','1',1,'Sale Id shift 120',0.00,0.00,0.00,3786.79,0.00,'2022-07-09 17:39:51','',''),(2711,'21','220','2',1,'Sale Id shift 120',0.00,0.00,0.00,4297.53,0.00,'2022-07-09 17:39:51','',''),(2712,'21','220','2',1,'Sale Id shift 120',0.00,0.00,0.00,3094.84,0.00,'2022-07-09 17:39:51','',''),(2713,'21','220','2',1,'Sale Id shift 120',0.00,0.00,0.00,3207.61,0.00,'2022-07-09 17:39:51','',''),(2714,'21','220','2',1,'Sale Id shift 120',0.00,0.00,0.00,3685.87,0.00,'2022-07-09 17:39:51','',''),(2715,'21','220','1',1,'Sale Id shift 120',0.00,0.00,0.00,1754.59,0.00,'2022-07-09 17:39:51','',''),(2716,'21','220','2',1,'Sale Id shift 120',0.00,0.00,0.00,4087.68,0.00,'2022-07-09 17:39:51','',''),(2717,'21','220','2',1,'Sale Id shift 120',0.00,0.00,0.00,3009.07,0.00,'2022-07-09 17:39:51','',''),(2718,'21','220','2',1,'Sale Id shift 120',0.00,0.00,0.00,3033.69,0.00,'2022-07-09 17:39:51','',''),(2719,'21','220','2',1,'Sale Id shift 120',0.00,0.00,0.00,3489.74,0.00,'2022-07-09 17:39:51','',''),(2720,'21','220','1',1,'Sale Id shift 120',0.00,0.00,0.00,2693.98,0.00,'2022-07-09 17:39:51','',''),(2721,'21','220',NULL,1,'Sale Id shift 120',6780305.40,0.00,0.00,0.00,0.00,'2022-07-09 17:39:51','',''),(2722,'21','220',NULL,2,'Sale Id shift 120',2922521.30,0.00,0.00,0.00,0.00,'2022-07-09 17:39:51','',''),(2723,'21','220',NULL,3,'Sale Id shift 120',544267.50,0.00,0.00,0.00,0.00,'2022-07-09 17:39:51','',''),(2724,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-09 17:39:58','',''),(2725,'21','220',NULL,1,'Reception corrector for bridging 303',0.00,0.00,0.00,32500.00,0.00,'2022-07-09 17:43:07','',''),(2726,'21','220','2',1,'Received from bridging 303',0.00,0.00,32500.00,0.00,0.00,'2022-07-09 17:43:07','',''),(2727,'21','220',NULL,1,'Reception corrector for bridging 302',0.00,0.00,0.00,17500.00,0.00,'2022-07-09 17:43:07','',''),(2728,'21','220','1',1,'Received from bridging 302',0.00,0.00,17500.00,0.00,0.00,'2022-07-09 17:43:07','',''),(2729,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-12 11:16:59','',''),(2730,'21','220',NULL,1,'Reception corrector for bridging 305',0.00,0.00,0.00,30000.00,0.00,'2022-07-12 11:19:10','',''),(2731,'21','220','2',1,'Received from bridging 305',0.00,0.00,30000.00,0.00,0.00,'2022-07-12 11:19:10','',''),(2732,'21','220',NULL,1,'Reception corrector for bridging 304',0.00,0.00,0.00,15000.00,0.00,'2022-07-12 11:19:10','',''),(2733,'21','220','1',1,'Received from bridging 304',0.00,0.00,15000.00,0.00,0.00,'2022-07-12 11:19:10','',''),(2734,'21','220','1',1,'Sale Id shift 121',0.00,0.00,0.00,2420.17,0.00,'2022-07-12 12:35:11','',''),(2735,'21','220','3',2,'Sale Id shift 121',0.00,0.00,0.00,5564.54,0.00,'2022-07-12 12:35:11','',''),(2736,'21','220','4',3,'Sale Id shift 121',0.00,0.00,0.00,721.96,0.00,'2022-07-12 12:35:11','',''),(2737,'21','220','1',1,'Sale Id shift 121',0.00,0.00,0.00,2461.09,0.00,'2022-07-12 12:35:11','',''),(2738,'21','220','1',1,'Sale Id shift 121',0.00,0.00,0.00,1809.43,0.00,'2022-07-12 12:35:11','',''),(2739,'21','220','1',1,'Sale Id shift 121',0.00,0.00,0.00,4534.55,0.00,'2022-07-12 12:35:11','',''),(2740,'21','220','2',1,'Sale Id shift 121',0.00,0.00,0.00,3602.62,0.00,'2022-07-12 12:35:11','',''),(2741,'21','220','2',1,'Sale Id shift 121',0.00,0.00,0.00,4429.12,0.00,'2022-07-12 12:35:11','',''),(2742,'21','220','2',1,'Sale Id shift 121',0.00,0.00,0.00,3970.40,0.00,'2022-07-12 12:35:11','',''),(2743,'21','220','2',1,'Sale Id shift 121',0.00,0.00,0.00,3942.15,0.00,'2022-07-12 12:35:11','',''),(2744,'21','220','1',1,'Sale Id shift 121',0.00,0.00,0.00,2178.52,0.00,'2022-07-12 12:35:11','',''),(2745,'21','220','2',1,'Sale Id shift 121',0.00,0.00,0.00,4071.62,0.00,'2022-07-12 12:35:11','',''),(2746,'21','220','2',1,'Sale Id shift 121',0.00,0.00,0.00,3935.86,0.00,'2022-07-12 12:35:11','',''),(2747,'21','220','2',1,'Sale Id shift 121',0.00,0.00,0.00,3608.39,0.00,'2022-07-12 12:35:11','',''),(2748,'21','220','2',1,'Sale Id shift 121',0.00,0.00,0.00,4138.23,0.00,'2022-07-12 12:35:12','',''),(2749,'21','220','1',1,'Sale Id shift 121',0.00,0.00,0.00,3910.26,0.00,'2022-07-12 12:35:12','',''),(2750,'21','220','3',2,'Sale Id shift 121',0.00,0.00,0.00,303.45,0.00,'2022-07-12 12:35:12','',''),(2751,'21','220',NULL,2,'Sale Id shift 121',4870431.70,0.00,0.00,0.00,0.00,'2022-07-12 12:35:12','',''),(2752,'21','220',NULL,3,'Sale Id shift 121',541470.00,0.00,0.00,0.00,0.00,'2022-07-12 12:35:12','',''),(2753,'21','220',NULL,1,'Sale Id shift 121',8087047.65,0.00,0.00,0.00,0.00,'2022-07-12 12:35:12','',''),(2754,'21','220','1',1,'Sale Id shift 122',0.00,0.00,0.00,1582.50,0.00,'2022-07-12 13:43:57','',''),(2755,'21','220','3',2,'Sale Id shift 122',0.00,0.00,0.00,1353.16,0.00,'2022-07-12 13:43:57','',''),(2756,'21','220','4',3,'Sale Id shift 122',0.00,0.00,0.00,1275.64,0.00,'2022-07-12 13:43:57','',''),(2757,'21','220','1',1,'Sale Id shift 122',0.00,0.00,0.00,1602.14,0.00,'2022-07-12 13:43:57','',''),(2758,'21','220','1',1,'Sale Id shift 122',0.00,0.00,0.00,1238.66,0.00,'2022-07-12 13:43:57','',''),(2759,'21','220','1',1,'Sale Id shift 122',0.00,0.00,0.00,1749.69,0.00,'2022-07-12 13:43:57','',''),(2760,'21','220','2',1,'Sale Id shift 122',0.00,0.00,0.00,2956.44,0.00,'2022-07-12 13:43:57','',''),(2761,'21','220','2',1,'Sale Id shift 122',0.00,0.00,0.00,2663.37,0.00,'2022-07-12 13:43:57','',''),(2762,'21','220','2',1,'Sale Id shift 122',0.00,0.00,0.00,3271.20,0.00,'2022-07-12 13:43:57','',''),(2763,'21','220','2',1,'Sale Id shift 122',0.00,0.00,0.00,3577.42,0.00,'2022-07-12 13:43:57','',''),(2764,'21','220','1',1,'Sale Id shift 122',0.00,0.00,0.00,1633.05,0.00,'2022-07-12 13:43:57','',''),(2765,'21','220','2',1,'Sale Id shift 122',0.00,0.00,0.00,3978.04,0.00,'2022-07-12 13:43:57','',''),(2766,'21','220','2',1,'Sale Id shift 122',0.00,0.00,0.00,3052.95,0.00,'2022-07-12 13:43:57','',''),(2767,'21','220','2',1,'Sale Id shift 122',0.00,0.00,0.00,2933.41,0.00,'2022-07-12 13:43:57','',''),(2768,'21','220','2',1,'Sale Id shift 122',0.00,0.00,0.00,3277.82,0.00,'2022-07-12 13:43:57','',''),(2769,'21','220','1',1,'Sale Id shift 122',0.00,0.00,0.00,2201.77,0.00,'2022-07-12 13:43:57','',''),(2770,'21','220',NULL,1,'Sale Id shift 122',5893545.90,0.00,0.00,0.00,0.00,'2022-07-12 13:43:57','',''),(2771,'21','220',NULL,2,'Sale Id shift 122',1123122.80,0.00,0.00,0.00,0.00,'2022-07-12 13:43:57','',''),(2772,'21','220',NULL,3,'Sale Id shift 122',956730.00,0.00,0.00,0.00,0.00,'2022-07-12 13:43:57','',''),(2773,'21','220','1',1,'Sale Id shift 123',0.00,0.00,0.00,315.77,0.00,'2022-07-12 15:48:48','',''),(2774,'21','220','3',2,'Sale Id shift 123',0.00,0.00,0.00,828.48,0.00,'2022-07-12 15:48:48','',''),(2775,'21','220','4',3,'Sale Id shift 123',0.00,0.00,0.00,643.53,0.00,'2022-07-12 15:48:48','',''),(2776,'21','220','1',1,'Sale Id shift 123',0.00,0.00,0.00,461.04,0.00,'2022-07-12 15:48:48','',''),(2777,'21','220','1',1,'Sale Id shift 123',0.00,0.00,0.00,427.45,0.00,'2022-07-12 15:48:48','',''),(2778,'21','220','1',1,'Sale Id shift 123',0.00,0.00,0.00,445.63,0.00,'2022-07-12 15:48:48','',''),(2779,'21','220','2',1,'Sale Id shift 123',0.00,0.00,0.00,407.30,0.00,'2022-07-12 15:48:48','',''),(2780,'21','220','2',1,'Sale Id shift 123',0.00,0.00,0.00,199.00,0.00,'2022-07-12 15:48:48','',''),(2781,'21','220','2',1,'Sale Id shift 123',0.00,0.00,0.00,369.49,0.00,'2022-07-12 15:48:48','',''),(2782,'21','220','2',1,'Sale Id shift 123',0.00,0.00,0.00,515.40,0.00,'2022-07-12 15:48:48','',''),(2783,'21','220','1',1,'Sale Id shift 123',0.00,0.00,0.00,344.06,0.00,'2022-07-12 15:48:48','',''),(2784,'21','220','2',1,'Sale Id shift 123',0.00,0.00,0.00,697.31,0.00,'2022-07-12 15:48:48','',''),(2785,'21','220','2',1,'Sale Id shift 123',0.00,0.00,0.00,294.04,0.00,'2022-07-12 15:48:48','',''),(2786,'21','220','2',1,'Sale Id shift 123',0.00,0.00,0.00,342.39,0.00,'2022-07-12 15:48:48','',''),(2787,'21','220','2',1,'Sale Id shift 123',0.00,0.00,0.00,450.43,0.00,'2022-07-12 15:48:48','',''),(2788,'21','220','1',1,'Sale Id shift 123',0.00,0.00,0.00,1401.10,0.00,'2022-07-12 15:48:48','',''),(2789,'21','220',NULL,1,'Sale Id shift 123',1100617.65,0.00,0.00,0.00,0.00,'2022-07-12 15:48:48','',''),(2790,'21','220',NULL,2,'Sale Id shift 123',687638.40,0.00,0.00,0.00,0.00,'2022-07-12 15:48:48','',''),(2791,'21','220',NULL,3,'Sale Id shift 123',482647.50,0.00,0.00,0.00,0.00,'2022-07-12 15:48:48','',''),(2792,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-12 16:49:27','',''),(2793,'21','220',NULL,1,'Reception corrector for bridging 306',0.00,0.00,0.00,45000.00,0.00,'2022-07-12 16:50:47','',''),(2794,'21','220','2',1,'Received from bridging 306',0.00,0.00,45000.00,0.00,0.00,'2022-07-12 16:50:47','',''),(2795,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9250000.00,50000.00,0.00,0.00,'2022-07-12 16:50:59','',''),(2796,'21','220',NULL,1,'Reception corrector for bridging 307',0.00,0.00,0.00,50000.00,0.00,'2022-07-12 16:52:17','',''),(2797,'21','220','1',1,'Received from bridging 307',0.00,0.00,50000.00,0.00,0.00,'2022-07-12 16:52:17','',''),(2798,'21','220','3',2,'Sale Id shift 124',0.00,0.00,0.00,973.47,0.00,'2022-07-12 16:53:09','',''),(2799,'21','220','4',3,'Sale Id shift 124',0.00,0.00,0.00,721.03,0.00,'2022-07-12 16:53:09','',''),(2800,'21','220','1',1,'Sale Id shift 124',0.00,0.00,0.00,2298.26,0.00,'2022-07-12 16:53:09','',''),(2801,'21','220','1',1,'Sale Id shift 124',0.00,0.00,0.00,1891.56,0.00,'2022-07-12 16:53:09','',''),(2802,'21','220','1',1,'Sale Id shift 124',0.00,0.00,0.00,3876.35,0.00,'2022-07-12 16:53:09','',''),(2803,'21','220','2',1,'Sale Id shift 124',0.00,0.00,0.00,4941.69,0.00,'2022-07-12 16:53:09','',''),(2804,'21','220','2',1,'Sale Id shift 124',0.00,0.00,0.00,3726.85,0.00,'2022-07-12 16:53:09','',''),(2805,'21','220','2',1,'Sale Id shift 124',0.00,0.00,0.00,3725.99,0.00,'2022-07-12 16:53:09','',''),(2806,'21','220','2',1,'Sale Id shift 124',0.00,0.00,0.00,3701.22,0.00,'2022-07-12 16:53:09','',''),(2807,'21','220','1',1,'Sale Id shift 124',0.00,0.00,0.00,2770.39,0.00,'2022-07-12 16:53:09','',''),(2808,'21','220','2',1,'Sale Id shift 124',0.00,0.00,0.00,4673.69,0.00,'2022-07-12 16:53:09','',''),(2809,'21','220','2',1,'Sale Id shift 124',0.00,0.00,0.00,3711.44,0.00,'2022-07-12 16:53:09','',''),(2810,'21','220','2',1,'Sale Id shift 124',0.00,0.00,0.00,3789.59,0.00,'2022-07-12 16:53:09','',''),(2811,'21','220','2',1,'Sale Id shift 124',0.00,0.00,0.00,4148.31,0.00,'2022-07-12 16:53:09','',''),(2812,'21','220','1',1,'Sale Id shift 124',0.00,0.00,0.00,3150.24,0.00,'2022-07-12 16:53:09','',''),(2813,'21','220',NULL,1,'Sale Id shift 124',8585032.30,0.00,0.00,0.00,0.00,'2022-07-12 16:53:09','',''),(2814,'21','220',NULL,2,'Sale Id shift 124',807980.10,0.00,0.00,0.00,0.00,'2022-07-12 16:53:09','',''),(2815,'21','220',NULL,3,'Sale Id shift 124',540772.50,0.00,0.00,0.00,0.00,'2022-07-12 16:53:09','',''),(2816,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,11100000.00,60000.00,0.00,0.00,'2022-07-13 18:13:23','',''),(2817,'21','220',NULL,1,'Reception corrector for bridging 309',0.00,0.00,0.00,40000.00,0.00,'2022-07-13 18:14:32','',''),(2818,'21','220','2',1,'Received from bridging 309',0.00,0.00,40000.00,0.00,0.00,'2022-07-13 18:14:32','',''),(2819,'21','220',NULL,1,'Reception corrector for bridging 308',0.00,0.00,0.00,20000.00,0.00,'2022-07-13 18:14:32','',''),(2820,'21','220','1',1,'Received from bridging 308',0.00,0.00,20000.00,0.00,0.00,'2022-07-13 18:14:32','',''),(2821,'21','220','1',1,'Sale Id shift 125',0.00,0.00,0.00,165.09,0.00,'2022-07-13 19:00:10','',''),(2822,'21','220','1',1,'Sale Id shift 125',0.00,0.00,0.00,211.54,0.00,'2022-07-13 19:00:10','',''),(2823,'21','220','1',1,'Sale Id shift 125',0.00,0.00,0.00,256.89,0.00,'2022-07-13 19:00:10','',''),(2824,'21','220','1',1,'Sale Id shift 125',0.00,0.00,0.00,232.29,0.00,'2022-07-13 19:00:10','',''),(2825,'21','220','2',1,'Sale Id shift 125',0.00,0.00,0.00,217.79,0.00,'2022-07-13 19:00:10','',''),(2826,'21','220','2',1,'Sale Id shift 125',0.00,0.00,0.00,275.79,0.00,'2022-07-13 19:00:10','',''),(2827,'21','220','2',1,'Sale Id shift 125',0.00,0.00,0.00,216.34,0.00,'2022-07-13 19:00:10','',''),(2828,'21','220','2',1,'Sale Id shift 125',0.00,0.00,0.00,149.26,0.00,'2022-07-13 19:00:10','',''),(2829,'21','220','1',1,'Sale Id shift 125',0.00,0.00,0.00,291.53,0.00,'2022-07-13 19:00:10','',''),(2830,'21','220','2',1,'Sale Id shift 125',0.00,0.00,0.00,331.32,0.00,'2022-07-13 19:00:10','',''),(2831,'21','220','2',1,'Sale Id shift 125',0.00,0.00,0.00,168.90,0.00,'2022-07-13 19:00:10','',''),(2832,'21','220','2',1,'Sale Id shift 125',0.00,0.00,0.00,315.51,0.00,'2022-07-13 19:00:10','',''),(2833,'21','220','2',1,'Sale Id shift 125',0.00,0.00,0.00,198.50,0.00,'2022-07-13 19:00:10','',''),(2834,'21','220','1',1,'Sale Id shift 125',0.00,0.00,0.00,418.34,0.00,'2022-07-13 19:00:10','',''),(2835,'21','220',NULL,1,'Sale Id shift 125',638081.65,0.00,0.00,0.00,0.00,'2022-07-13 19:00:10','',''),(2836,'21','220','3',2,'Sale Id shift 126',0.00,0.00,0.00,1393.74,0.00,'2022-07-13 19:42:44','',''),(2837,'21','220','4',3,'Sale Id shift 126',0.00,0.00,0.00,815.26,0.00,'2022-07-13 19:42:44','',''),(2838,'21','220','1',1,'Sale Id shift 126',0.00,0.00,0.00,5394.71,0.00,'2022-07-13 19:42:44','',''),(2839,'21','220','1',1,'Sale Id shift 126',0.00,0.00,0.00,5361.51,0.00,'2022-07-13 19:42:44','',''),(2840,'21','220','1',1,'Sale Id shift 126',0.00,0.00,0.00,818.98,0.00,'2022-07-13 19:42:44','',''),(2841,'21','220','1',1,'Sale Id shift 126',0.00,0.00,0.00,7057.26,0.00,'2022-07-13 19:42:44','',''),(2842,'21','220','2',1,'Sale Id shift 126',0.00,0.00,0.00,5844.79,0.00,'2022-07-13 19:42:44','',''),(2843,'21','220','2',1,'Sale Id shift 126',0.00,0.00,0.00,4420.09,0.00,'2022-07-13 19:42:44','',''),(2844,'21','220','2',1,'Sale Id shift 126',0.00,0.00,0.00,4099.97,0.00,'2022-07-13 19:42:44','',''),(2845,'21','220','2',1,'Sale Id shift 126',0.00,0.00,0.00,4570.74,0.00,'2022-07-13 19:42:44','',''),(2846,'21','220','1',1,'Sale Id shift 126',0.00,0.00,0.00,7617.19,0.00,'2022-07-13 19:42:44','',''),(2847,'21','220','2',1,'Sale Id shift 126',0.00,0.00,0.00,5726.11,0.00,'2022-07-13 19:42:44','',''),(2848,'21','220','2',1,'Sale Id shift 126',0.00,0.00,0.00,4629.97,0.00,'2022-07-13 19:42:44','',''),(2849,'21','220','2',1,'Sale Id shift 126',0.00,0.00,0.00,4025.53,0.00,'2022-07-13 19:42:44','',''),(2850,'21','220','2',1,'Sale Id shift 126',0.00,0.00,0.00,4811.63,0.00,'2022-07-13 19:42:44','',''),(2851,'21','220','1',1,'Sale Id shift 126',0.00,0.00,0.00,9756.89,0.00,'2022-07-13 19:42:44','',''),(2852,'21','220','3',2,'Sale Id shift 126',0.00,0.00,0.00,50.00,0.00,'2022-07-13 19:42:44','',''),(2853,'21','220',NULL,1,'Sale Id shift 126',12232336.05,0.00,0.00,0.00,0.00,'2022-07-13 19:42:44','',''),(2854,'21','220',NULL,2,'Sale Id shift 126',1198304.20,0.00,0.00,0.00,0.00,'2022-07-13 19:42:44','',''),(2855,'21','220',NULL,3,'Sale Id shift 126',611445.00,0.00,0.00,0.00,0.00,'2022-07-13 19:42:44','',''),(2856,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2022-07-14 15:22:35','',''),(2857,'21','220',NULL,1,'Reception corrector for bridging 311',0.00,0.00,0.00,20000.00,0.00,'2022-07-14 15:24:54','',''),(2858,'21','220','2',1,'Received from bridging 311',0.00,0.00,20000.00,0.00,0.00,'2022-07-14 15:24:54','',''),(2859,'21','220',NULL,1,'Reception corrector for bridging 310',0.00,0.00,0.00,40000.00,0.00,'2022-07-14 15:24:54','',''),(2860,'21','220','1',1,'Received from bridging 310',0.00,0.00,40000.00,0.00,0.00,'2022-07-14 15:24:54','',''),(2861,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,12284000.00,14800.00,0.00,0.00,'2022-07-14 15:26:00','',''),(2862,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-15 17:39:45','',''),(2863,'21','220',NULL,1,'Reception corrector for bridging 314',0.00,0.00,0.00,30000.00,0.00,'2022-07-15 17:42:07','',''),(2864,'21','220','2',1,'Received from bridging 314',0.00,0.00,30000.00,0.00,0.00,'2022-07-15 17:42:07','',''),(2865,'21','220',NULL,1,'Reception corrector for bridging 313',0.00,0.00,0.00,15000.00,0.00,'2022-07-15 17:42:07','',''),(2866,'21','220','1',1,'Received from bridging 313',0.00,0.00,15000.00,0.00,0.00,'2022-07-15 17:42:07','',''),(2867,'21','220',NULL,2,'Reception corrector for bridging 312',0.00,0.00,0.00,14800.00,0.00,'2022-07-15 17:42:38','',''),(2868,'21','220','3',2,'Received from bridging 312',0.00,0.00,14800.00,0.00,0.00,'2022-07-15 17:42:38','',''),(2869,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,83000.00,100.00,0.00,0.00,'2022-07-15 17:47:15','',''),(2870,'21','220',NULL,2,'Reception corrector for bridging 315',0.00,0.00,0.00,100.00,0.00,'2022-07-15 17:48:53','',''),(2871,'21','220','3',2,'Received from bridging 315',0.00,0.00,100.00,0.00,0.00,'2022-07-15 17:48:53','',''),(2872,'21','220','3',2,'Sale Id shift 127',0.00,0.00,0.00,4475.91,0.00,'2022-07-15 18:18:55','',''),(2873,'21','220','4',3,'Sale Id shift 127',0.00,0.00,0.00,725.91,0.00,'2022-07-15 18:18:55','',''),(2874,'21','220','1',1,'Sale Id shift 127',0.00,0.00,0.00,6070.22,0.00,'2022-07-15 18:18:55','',''),(2875,'21','220','1',1,'Sale Id shift 127',0.00,0.00,0.00,6259.01,0.00,'2022-07-15 18:18:55','',''),(2876,'21','220','1',1,'Sale Id shift 127',0.00,0.00,0.00,5742.66,0.00,'2022-07-15 18:18:55','',''),(2877,'21','220','1',1,'Sale Id shift 127',0.00,0.00,0.00,5020.81,0.00,'2022-07-15 18:18:55','',''),(2878,'21','220','2',1,'Sale Id shift 127',0.00,0.00,0.00,5979.87,0.00,'2022-07-15 18:18:55','',''),(2879,'21','220','2',1,'Sale Id shift 127',0.00,0.00,0.00,4183.72,0.00,'2022-07-15 18:18:55','',''),(2880,'21','220','2',1,'Sale Id shift 127',0.00,0.00,0.00,4154.49,0.00,'2022-07-15 18:18:55','',''),(2881,'21','220','2',1,'Sale Id shift 127',0.00,0.00,0.00,4746.84,0.00,'2022-07-15 18:18:55','',''),(2882,'21','220','1',1,'Sale Id shift 127',0.00,0.00,0.00,6547.97,0.00,'2022-07-15 18:18:55','',''),(2883,'21','220','2',1,'Sale Id shift 127',0.00,0.00,0.00,4830.97,0.00,'2022-07-15 18:18:55','',''),(2884,'21','220','2',1,'Sale Id shift 127',0.00,0.00,0.00,5237.01,0.00,'2022-07-15 18:18:55','',''),(2885,'21','220','2',1,'Sale Id shift 127',0.00,0.00,0.00,5805.15,0.00,'2022-07-15 18:18:55','',''),(2886,'21','220','2',1,'Sale Id shift 127',0.00,0.00,0.00,5082.33,0.00,'2022-07-15 18:18:55','',''),(2887,'21','220','1',1,'Sale Id shift 127',0.00,0.00,0.00,6985.61,0.00,'2022-07-15 18:18:55','',''),(2888,'21','220',NULL,1,'Sale Id shift 127',12646698.90,0.00,0.00,0.00,0.00,'2022-07-15 18:18:55','',''),(2889,'21','220',NULL,2,'Sale Id shift 127',3715005.30,0.00,0.00,0.00,0.00,'2022-07-15 18:18:55','',''),(2890,'21','220',NULL,3,'Sale Id shift 127',544432.50,0.00,0.00,0.00,0.00,'2022-07-15 18:18:55','',''),(2891,'21','220','3',2,'Sale Id shift 128',0.00,0.00,0.00,2554.57,0.00,'2022-07-15 18:55:18','',''),(2892,'21','220','4',3,'Sale Id shift 128',0.00,0.00,0.00,508.99,0.00,'2022-07-15 18:55:18','',''),(2893,'21','220','1',1,'Sale Id shift 128',0.00,0.00,0.00,5582.86,0.00,'2022-07-15 18:55:18','',''),(2894,'21','220','1',1,'Sale Id shift 128',0.00,0.00,0.00,5571.36,0.00,'2022-07-15 18:55:18','',''),(2895,'21','220','1',1,'Sale Id shift 128',0.00,0.00,0.00,5238.96,0.00,'2022-07-15 18:55:18','',''),(2896,'21','220','1',1,'Sale Id shift 128',0.00,0.00,0.00,4308.23,0.00,'2022-07-15 18:55:18','',''),(2897,'21','220','2',1,'Sale Id shift 128',0.00,0.00,0.00,4573.91,0.00,'2022-07-15 18:55:18','',''),(2898,'21','220','2',1,'Sale Id shift 128',0.00,0.00,0.00,2679.12,0.00,'2022-07-15 18:55:18','',''),(2899,'21','220','2',1,'Sale Id shift 128',0.00,0.00,0.00,3562.56,0.00,'2022-07-15 18:55:18','',''),(2900,'21','220','2',1,'Sale Id shift 128',0.00,0.00,0.00,2338.19,0.00,'2022-07-15 18:55:18','',''),(2901,'21','220','1',1,'Sale Id shift 128',0.00,0.00,0.00,6671.52,0.00,'2022-07-15 18:55:18','',''),(2902,'21','220','2',1,'Sale Id shift 128',0.00,0.00,0.00,927.71,0.00,'2022-07-15 18:55:18','',''),(2903,'21','220','2',1,'Sale Id shift 128',0.00,0.00,0.00,5382.21,0.00,'2022-07-15 18:55:18','',''),(2904,'21','220','2',1,'Sale Id shift 128',0.00,0.00,0.00,2112.69,0.00,'2022-07-15 18:55:18','',''),(2905,'21','220','2',1,'Sale Id shift 128',0.00,0.00,0.00,3267.78,0.00,'2022-07-15 18:55:18','',''),(2906,'21','220','1',1,'Sale Id shift 128',0.00,0.00,0.00,6576.25,0.00,'2022-07-15 18:55:18','',''),(2907,'21','220',NULL,1,'Sale Id shift 128',10876769.75,0.00,0.00,0.00,0.00,'2022-07-15 18:55:18','',''),(2908,'21','220',NULL,2,'Sale Id shift 128',2120293.10,0.00,0.00,0.00,0.00,'2022-07-15 18:55:18','',''),(2909,'21','220',NULL,3,'Sale Id shift 128',381742.50,0.00,0.00,0.00,0.00,'2022-07-15 18:55:18','',''),(2910,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-16 12:50:04','',''),(2911,'21','220',NULL,1,'Reception corrector for bridging 317',0.00,0.00,0.00,30000.00,0.00,'2022-07-16 12:54:20','',''),(2912,'21','220','2',1,'Received from bridging 317',0.00,0.00,30000.00,0.00,0.00,'2022-07-16 12:54:20','',''),(2913,'21','220',NULL,1,'Reception corrector for bridging 316',0.00,0.00,0.00,15000.00,0.00,'2022-07-16 12:54:20','',''),(2914,'21','220','1',1,'Received from bridging 316',0.00,0.00,15000.00,0.00,0.00,'2022-07-16 12:54:20','',''),(2915,'21','220','3',2,'Sale Id shift 129',0.00,0.00,0.00,2681.97,0.00,'2022-07-16 13:39:41','',''),(2916,'21','220','4',3,'Sale Id shift 129',0.00,0.00,0.00,521.48,0.00,'2022-07-16 13:39:41','',''),(2917,'21','220','1',1,'Sale Id shift 129',0.00,0.00,0.00,2410.28,0.00,'2022-07-16 13:39:41','',''),(2918,'21','220','1',1,'Sale Id shift 129',0.00,0.00,0.00,2385.63,0.00,'2022-07-16 13:39:41','',''),(2919,'21','220','1',1,'Sale Id shift 129',0.00,0.00,0.00,2674.69,0.00,'2022-07-16 13:39:41','',''),(2920,'21','220','1',1,'Sale Id shift 129',0.00,0.00,0.00,2807.85,0.00,'2022-07-16 13:39:41','',''),(2921,'21','220','2',1,'Sale Id shift 129',0.00,0.00,0.00,3937.94,0.00,'2022-07-16 13:39:41','',''),(2922,'21','220','2',1,'Sale Id shift 129',0.00,0.00,0.00,3273.06,0.00,'2022-07-16 13:39:41','',''),(2923,'21','220','2',1,'Sale Id shift 129',0.00,0.00,0.00,3406.06,0.00,'2022-07-16 13:39:41','',''),(2924,'21','220','2',1,'Sale Id shift 129',0.00,0.00,0.00,2733.95,0.00,'2022-07-16 13:39:41','',''),(2925,'21','220','1',1,'Sale Id shift 129',0.00,0.00,0.00,3596.94,0.00,'2022-07-16 13:39:41','',''),(2926,'21','220','2',1,'Sale Id shift 129',0.00,0.00,0.00,3564.87,0.00,'2022-07-16 13:39:41','',''),(2927,'21','220','2',1,'Sale Id shift 129',0.00,0.00,0.00,3739.86,0.00,'2022-07-16 13:39:41','',''),(2928,'21','220','2',1,'Sale Id shift 129',0.00,0.00,0.00,2956.70,0.00,'2022-07-16 13:39:41','',''),(2929,'21','220','2',1,'Sale Id shift 129',0.00,0.00,0.00,3139.38,0.00,'2022-07-16 13:39:41','',''),(2930,'21','220','1',1,'Sale Id shift 129',0.00,0.00,0.00,2958.40,0.00,'2022-07-16 13:39:41','',''),(2931,'21','220',NULL,1,'Sale Id shift 129',8063337.85,0.00,0.00,0.00,0.00,'2022-07-16 13:39:41','',''),(2932,'21','220',NULL,2,'Sale Id shift 129',2226035.10,0.00,0.00,0.00,0.00,'2022-07-16 13:39:41','',''),(2933,'21','220',NULL,3,'Sale Id shift 129',391110.00,0.00,0.00,0.00,0.00,'2022-07-16 13:39:41','',''),(2934,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,1965915.45,10626.57,0.00,0.00,'2022-07-18 15:08:02','',''),(2935,'21','220',NULL,1,'Reception corrector for bridging 319',0.00,0.00,0.00,10490.57,0.00,'2022-07-18 15:09:28','',''),(2936,'21','220','2',1,'Received from bridging 319',0.00,0.00,10490.57,0.00,0.00,'2022-07-18 15:09:28','',''),(2937,'21','220',NULL,1,'Reception corrector for bridging 318',0.00,0.00,0.00,136.00,0.00,'2022-07-18 15:09:28','',''),(2938,'21','220','1',1,'Received from bridging 318',0.00,0.00,136.00,0.00,0.00,'2022-07-18 15:09:28','',''),(2939,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8710355.00,47083.00,0.00,0.00,'2022-07-18 15:12:09','',''),(2940,'21','220',NULL,1,'Reception corrector for bridging 321',0.00,0.00,0.00,32083.00,0.00,'2022-07-18 15:13:49','',''),(2941,'21','220','2',1,'Received from bridging 321',0.00,0.00,32083.00,0.00,0.00,'2022-07-18 15:13:49','',''),(2942,'21','220',NULL,1,'Reception corrector for bridging 320',0.00,0.00,0.00,15000.00,0.00,'2022-07-18 15:13:49','',''),(2943,'21','220','1',1,'Received from bridging 320',0.00,0.00,15000.00,0.00,0.00,'2022-07-18 15:13:49','',''),(2944,'21','220','3',2,'Sale Id shift 130',0.00,0.00,0.00,1781.89,0.00,'2022-07-18 15:44:41','',''),(2945,'21','220','4',3,'Sale Id shift 130',0.00,0.00,0.00,939.80,0.00,'2022-07-18 15:44:41','',''),(2946,'21','220','1',1,'Sale Id shift 130',0.00,0.00,0.00,1897.41,0.00,'2022-07-18 15:44:41','',''),(2947,'21','220','1',1,'Sale Id shift 130',0.00,0.00,0.00,1454.70,0.00,'2022-07-18 15:44:41','',''),(2948,'21','220','1',1,'Sale Id shift 130',0.00,0.00,0.00,1799.88,0.00,'2022-07-18 15:44:41','',''),(2949,'21','220','1',1,'Sale Id shift 130',0.00,0.00,0.00,2388.81,0.00,'2022-07-18 15:44:41','',''),(2950,'21','220','2',1,'Sale Id shift 130',0.00,0.00,0.00,4755.49,0.00,'2022-07-18 15:44:41','',''),(2951,'21','220','2',1,'Sale Id shift 130',0.00,0.00,0.00,2613.71,0.00,'2022-07-18 15:44:41','',''),(2952,'21','220','2',1,'Sale Id shift 130',0.00,0.00,0.00,1747.09,0.00,'2022-07-18 15:44:41','',''),(2953,'21','220','2',1,'Sale Id shift 130',0.00,0.00,0.00,3620.93,0.00,'2022-07-18 15:44:41','',''),(2954,'21','220','1',1,'Sale Id shift 130',0.00,0.00,0.00,2413.03,0.00,'2022-07-18 15:44:41','',''),(2955,'21','220','2',1,'Sale Id shift 130',0.00,0.00,0.00,4324.98,0.00,'2022-07-18 15:44:41','',''),(2956,'21','220','2',1,'Sale Id shift 130',0.00,0.00,0.00,3367.21,0.00,'2022-07-18 15:44:41','',''),(2957,'21','220','2',1,'Sale Id shift 130',0.00,0.00,0.00,3586.01,0.00,'2022-07-18 15:44:41','',''),(2958,'21','220','2',1,'Sale Id shift 130',0.00,0.00,0.00,2701.13,0.00,'2022-07-18 15:44:41','',''),(2959,'21','220','1',1,'Sale Id shift 130',0.00,0.00,0.00,3026.78,0.00,'2022-07-18 15:44:41','',''),(2960,'21','220',NULL,1,'Sale Id shift 130',7343974.60,0.00,0.00,0.00,0.00,'2022-07-18 15:44:41','',''),(2961,'21','220',NULL,2,'Sale Id shift 130',1478968.70,0.00,0.00,0.00,0.00,'2022-07-18 15:44:41','',''),(2962,'21','220',NULL,3,'Sale Id shift 130',704850.00,0.00,0.00,0.00,0.00,'2022-07-18 15:44:41','',''),(2963,'21','220','3',2,'Sale Id shift 131',0.00,0.00,0.00,1993.67,0.00,'2022-07-19 12:50:08','',''),(2964,'21','220','4',3,'Sale Id shift 131',0.00,0.00,0.00,641.77,0.00,'2022-07-19 12:50:08','',''),(2965,'21','220','1',1,'Sale Id shift 131',0.00,0.00,0.00,174.82,0.00,'2022-07-19 12:50:08','',''),(2966,'21','220','2',1,'Sale Id shift 131',0.00,0.00,0.00,1020.08,0.00,'2022-07-19 12:50:08','',''),(2967,'21','220',NULL,1,'Sale Id shift 131',221056.50,0.00,0.00,0.00,0.00,'2022-07-19 12:50:08','',''),(2968,'21','220',NULL,2,'Sale Id shift 131',1654746.10,0.00,0.00,0.00,0.00,'2022-07-19 12:50:08','',''),(2969,'21','220',NULL,3,'Sale Id shift 131',481327.50,0.00,0.00,0.00,0.00,'2022-07-19 12:50:08','',''),(2970,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-19 18:13:21','',''),(2971,'21','220',NULL,1,'Reception corrector for bridging 323',0.00,0.00,0.00,30000.00,0.00,'2022-07-19 18:57:24','',''),(2972,'21','220','2',1,'Received from bridging 323',0.00,0.00,30000.00,0.00,0.00,'2022-07-19 18:57:24','',''),(2973,'21','220',NULL,1,'Reception corrector for bridging 322',0.00,0.00,0.00,15000.00,0.00,'2022-07-19 18:57:24','',''),(2974,'21','220','1',1,'Received from bridging 322',0.00,0.00,15000.00,0.00,0.00,'2022-07-19 18:57:24','',''),(2975,'21','220','3',2,'Sale Id shift 132',0.00,0.00,0.00,4930.41,0.00,'2022-07-19 19:00:54','',''),(2976,'21','220','4',3,'Sale Id shift 132',0.00,0.00,0.00,1548.67,0.00,'2022-07-19 19:00:54','',''),(2977,'21','220','1',1,'Sale Id shift 132',0.00,0.00,0.00,3160.74,0.00,'2022-07-19 19:00:54','',''),(2978,'21','220','1',1,'Sale Id shift 132',0.00,0.00,0.00,564.11,0.00,'2022-07-19 19:00:54','',''),(2979,'21','220','1',1,'Sale Id shift 132',0.00,0.00,0.00,2543.66,0.00,'2022-07-19 19:00:54','',''),(2980,'21','220','1',1,'Sale Id shift 132',0.00,0.00,0.00,3225.36,0.00,'2022-07-19 19:00:54','',''),(2981,'21','220','2',1,'Sale Id shift 132',0.00,0.00,0.00,5118.75,0.00,'2022-07-19 19:00:54','',''),(2982,'21','220','2',1,'Sale Id shift 132',0.00,0.00,0.00,3675.41,0.00,'2022-07-19 19:00:54','',''),(2983,'21','220','2',1,'Sale Id shift 132',0.00,0.00,0.00,4049.67,0.00,'2022-07-19 19:00:54','',''),(2984,'21','220','2',1,'Sale Id shift 132',0.00,0.00,0.00,4282.28,0.00,'2022-07-19 19:00:54','',''),(2985,'21','220','1',1,'Sale Id shift 132',0.00,0.00,0.00,4191.55,0.00,'2022-07-19 19:00:54','',''),(2986,'21','220','2',1,'Sale Id shift 132',0.00,0.00,0.00,5221.53,0.00,'2022-07-19 19:00:54','',''),(2987,'21','220','2',1,'Sale Id shift 132',0.00,0.00,0.00,4111.26,0.00,'2022-07-19 19:00:54','',''),(2988,'21','220','2',1,'Sale Id shift 132',0.00,0.00,0.00,5237.53,0.00,'2022-07-19 19:00:54','',''),(2989,'21','220','2',1,'Sale Id shift 132',0.00,0.00,0.00,4414.61,0.00,'2022-07-19 19:00:54','',''),(2990,'21','220','1',1,'Sale Id shift 132',0.00,0.00,0.00,4999.58,0.00,'2022-07-19 19:00:54','',''),(2991,'21','220','3',2,'Sale Id shift 132',0.00,0.00,0.00,990.95,0.00,'2022-07-19 19:00:54','',''),(2992,'21','220',NULL,1,'Sale Id shift 132',10137267.40,0.00,0.00,0.00,0.00,'2022-07-19 19:00:54','',''),(2993,'21','220',NULL,2,'Sale Id shift 132',4914728.80,0.00,0.00,0.00,0.00,'2022-07-19 19:00:54','',''),(2994,'21','220',NULL,3,'Sale Id shift 132',1161502.50,0.00,0.00,0.00,0.00,'2022-07-19 19:00:54','',''),(2995,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8750000.00,50000.00,0.00,0.00,'2022-07-20 17:19:12','',''),(2996,'21','220',NULL,1,'Reception corrector for bridging 324',0.00,0.00,0.00,50000.00,0.00,'2022-07-20 17:22:48','',''),(2997,'21','220','1',1,'Received from bridging 324',0.00,0.00,50000.00,0.00,0.00,'2022-07-20 17:22:48','',''),(2998,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-20 17:27:21','',''),(2999,'21','220',NULL,1,'Reception corrector for bridging 325',0.00,0.00,0.00,45000.00,0.00,'2022-07-20 17:30:07','',''),(3000,'21','220','2',1,'Received from bridging 325',0.00,0.00,45000.00,0.00,0.00,'2022-07-20 17:30:07','',''),(3001,'21','220','3',2,'Sale Id shift 133',0.00,0.00,0.00,2274.52,0.00,'2022-07-20 20:20:10','',''),(3002,'21','220','4',3,'Sale Id shift 133',0.00,0.00,0.00,1332.19,0.00,'2022-07-20 20:20:10','',''),(3003,'21','220','1',1,'Sale Id shift 133',0.00,0.00,0.00,2657.93,0.00,'2022-07-20 20:20:10','',''),(3004,'21','220','1',1,'Sale Id shift 133',0.00,0.00,0.00,2373.76,0.00,'2022-07-20 20:20:10','',''),(3005,'21','220','1',1,'Sale Id shift 133',0.00,0.00,0.00,2392.83,0.00,'2022-07-20 20:20:10','',''),(3006,'21','220','1',1,'Sale Id shift 133',0.00,0.00,0.00,2358.08,0.00,'2022-07-20 20:20:10','',''),(3007,'21','220','2',1,'Sale Id shift 133',0.00,0.00,0.00,4376.06,0.00,'2022-07-20 20:20:10','',''),(3008,'21','220','2',1,'Sale Id shift 133',0.00,0.00,0.00,2763.03,0.00,'2022-07-20 20:20:10','',''),(3009,'21','220','2',1,'Sale Id shift 133',0.00,0.00,0.00,3535.67,0.00,'2022-07-20 20:20:10','',''),(3010,'21','220','2',1,'Sale Id shift 133',0.00,0.00,0.00,2941.19,0.00,'2022-07-20 20:20:10','',''),(3011,'21','220','1',1,'Sale Id shift 133',0.00,0.00,0.00,2719.95,0.00,'2022-07-20 20:20:10','',''),(3012,'21','220','2',1,'Sale Id shift 133',0.00,0.00,0.00,4894.15,0.00,'2022-07-20 20:20:10','',''),(3013,'21','220','2',1,'Sale Id shift 133',0.00,0.00,0.00,3099.86,0.00,'2022-07-20 20:20:10','',''),(3014,'21','220','2',1,'Sale Id shift 133',0.00,0.00,0.00,3372.44,0.00,'2022-07-20 20:20:10','',''),(3015,'21','220','2',1,'Sale Id shift 133',0.00,0.00,0.00,4647.06,0.00,'2022-07-20 20:20:10','',''),(3016,'21','220','1',1,'Sale Id shift 133',0.00,0.00,0.00,3533.92,0.00,'2022-07-20 20:20:10','',''),(3017,'21','220',NULL,1,'Sale Id shift 133',7991537.75,0.00,0.00,0.00,0.00,'2022-07-20 20:20:10','',''),(3018,'21','220',NULL,2,'Sale Id shift 133',1887851.60,0.00,0.00,0.00,0.00,'2022-07-20 20:20:10','',''),(3019,'21','220',NULL,3,'Sale Id shift 133',999142.50,0.00,0.00,0.00,0.00,'2022-07-20 20:20:10','',''),(3020,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-22 11:49:56','',''),(3021,'21','220',NULL,1,'Reception corrector for bridging 327',0.00,0.00,0.00,33500.00,0.00,'2022-07-22 11:53:12','',''),(3022,'21','220','2',1,'Received from bridging 327',0.00,0.00,33500.00,0.00,0.00,'2022-07-22 11:53:12','',''),(3023,'21','220',NULL,1,'Reception corrector for bridging 329',0.00,0.00,0.00,11500.00,0.00,'2022-07-22 15:21:30','',''),(3024,'21','220','1',1,'Received from bridging 329',0.00,0.00,11500.00,0.00,0.00,'2022-07-22 15:21:30','',''),(3025,'21','220','2',1,'Returned bridging 327',0.00,0.00,0.00,33500.00,0.00,'2022-07-22 15:28:42','',''),(3026,'21','220',NULL,1,'Reception Return corrector for bridging 327',0.00,0.00,33500.00,0.00,0.00,'2022-07-22 15:28:42','',''),(3027,'21','220','1',1,'Returned bridging 329',0.00,0.00,0.00,11500.00,0.00,'2022-07-22 15:29:07','',''),(3028,'21','220',NULL,1,'Reception Return corrector for bridging 329',0.00,0.00,11500.00,0.00,0.00,'2022-07-22 15:29:07','',''),(3029,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8750000.00,50000.00,0.00,0.00,'2022-07-22 15:29:22','',''),(3030,'21','220',NULL,1,'Reception corrector for bridging 331',0.00,0.00,0.00,33500.00,0.00,'2022-07-22 15:30:13','',''),(3031,'21','220','2',1,'Received from bridging 331',0.00,0.00,33500.00,0.00,0.00,'2022-07-22 15:30:13','',''),(3032,'21','220',NULL,1,'Reception corrector for bridging 330',0.00,0.00,0.00,16500.00,0.00,'2022-07-22 15:30:13','',''),(3033,'21','220','1',1,'Received from bridging 330',0.00,0.00,16500.00,0.00,0.00,'2022-07-22 15:30:13','',''),(3034,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,12367000.00,14900.00,0.00,0.00,'2022-07-22 16:07:39','',''),(3035,'21','220',NULL,2,'Reception corrector for bridging 332',0.00,0.00,0.00,14900.00,0.00,'2022-07-22 16:08:19','',''),(3036,'21','220','3',2,'Received from bridging 332',0.00,0.00,14900.00,0.00,0.00,'2022-07-22 16:08:19','',''),(3037,'21','220','3',2,'Sale Id shift 134',0.00,0.00,0.00,3442.51,0.00,'2022-07-22 16:09:41','',''),(3038,'21','220','4',3,'Sale Id shift 134',0.00,0.00,0.00,459.20,0.00,'2022-07-22 16:09:41','',''),(3039,'21','220','1',1,'Sale Id shift 134',0.00,0.00,0.00,7564.33,0.00,'2022-07-22 16:09:41','',''),(3040,'21','220','1',1,'Sale Id shift 134',0.00,0.00,0.00,2381.65,0.00,'2022-07-22 16:09:41','',''),(3041,'21','220','1',1,'Sale Id shift 134',0.00,0.00,0.00,8941.75,0.00,'2022-07-22 16:09:41','',''),(3042,'21','220','1',1,'Sale Id shift 134',0.00,0.00,0.00,0.80,0.00,'2022-07-22 16:09:41','',''),(3043,'21','220','2',1,'Sale Id shift 134',0.00,0.00,0.00,5833.41,0.00,'2022-07-22 16:09:41','',''),(3044,'21','220','2',1,'Sale Id shift 134',0.00,0.00,0.00,5544.56,0.00,'2022-07-22 16:09:41','',''),(3045,'21','220','2',1,'Sale Id shift 134',0.00,0.00,0.00,5586.11,0.00,'2022-07-22 16:09:41','',''),(3046,'21','220','2',1,'Sale Id shift 134',0.00,0.00,0.00,2351.40,0.00,'2022-07-22 16:09:41','',''),(3047,'21','220','1',1,'Sale Id shift 134',0.00,0.00,0.00,9565.20,0.00,'2022-07-22 16:09:41','',''),(3048,'21','220','2',1,'Sale Id shift 134',0.00,0.00,0.00,6772.97,0.00,'2022-07-22 16:09:41','',''),(3049,'21','220','2',1,'Sale Id shift 134',0.00,0.00,0.00,6705.21,0.00,'2022-07-22 16:09:41','',''),(3050,'21','220','2',1,'Sale Id shift 134',0.00,0.00,0.00,5463.91,0.00,'2022-07-22 16:09:41','',''),(3051,'21','220','2',1,'Sale Id shift 134',0.00,0.00,0.00,6383.27,0.00,'2022-07-22 16:09:41','',''),(3052,'21','220','1',1,'Sale Id shift 134',0.00,0.00,0.00,11226.82,0.00,'2022-07-22 16:09:41','',''),(3053,'21','220',NULL,1,'Sale Id shift 134',14756243.25,0.00,0.00,0.00,0.00,'2022-07-22 16:09:41','',''),(3054,'21','220',NULL,2,'Sale Id shift 134',2857283.30,0.00,0.00,0.00,0.00,'2022-07-22 16:09:41','',''),(3055,'21','220',NULL,3,'Sale Id shift 134',344400.00,0.00,0.00,0.00,0.00,'2022-07-22 16:09:41','',''),(3056,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-22 17:36:41','',''),(3057,'21','220',NULL,1,'Reception corrector for bridging 334',0.00,0.00,0.00,30000.00,0.00,'2022-07-22 17:42:42','',''),(3058,'21','220','2',1,'Received from bridging 334',0.00,0.00,30000.00,0.00,0.00,'2022-07-22 17:42:42','',''),(3059,'21','220',NULL,1,'Reception corrector for bridging 333',0.00,0.00,0.00,15000.00,0.00,'2022-07-22 17:42:42','',''),(3060,'21','220','1',1,'Received from bridging 333',0.00,0.00,15000.00,0.00,0.00,'2022-07-22 17:42:42','',''),(3061,'21','220','3',2,'Sale Id shift 135',0.00,0.00,0.00,3345.86,0.00,'2022-07-22 18:18:30','',''),(3062,'21','220','4',3,'Sale Id shift 135',0.00,0.00,0.00,350.34,0.00,'2022-07-22 18:18:30','',''),(3063,'21','220','1',1,'Sale Id shift 135',0.00,0.00,0.00,3824.40,0.00,'2022-07-22 18:18:30','',''),(3064,'21','220','1',1,'Sale Id shift 135',0.00,0.00,0.00,2950.63,0.00,'2022-07-22 18:18:30','',''),(3065,'21','220','1',1,'Sale Id shift 135',0.00,0.00,0.00,5408.13,0.00,'2022-07-22 18:18:30','',''),(3066,'21','220','2',1,'Sale Id shift 135',0.00,0.00,0.00,4476.81,0.00,'2022-07-22 18:18:30','',''),(3067,'21','220','2',1,'Sale Id shift 135',0.00,0.00,0.00,2976.58,0.00,'2022-07-22 18:18:30','',''),(3068,'21','220','2',1,'Sale Id shift 135',0.00,0.00,0.00,4874.10,0.00,'2022-07-22 18:18:30','',''),(3069,'21','220','1',1,'Sale Id shift 135',0.00,0.00,0.00,5202.04,0.00,'2022-07-22 18:18:30','',''),(3070,'21','220','2',1,'Sale Id shift 135',0.00,0.00,0.00,4986.80,0.00,'2022-07-22 18:18:30','',''),(3071,'21','220','2',1,'Sale Id shift 135',0.00,0.00,0.00,4613.93,0.00,'2022-07-22 18:18:30','',''),(3072,'21','220','2',1,'Sale Id shift 135',0.00,0.00,0.00,4777.18,0.00,'2022-07-22 18:18:30','',''),(3073,'21','220','2',1,'Sale Id shift 135',0.00,0.00,0.00,4327.35,0.00,'2022-07-22 18:18:30','',''),(3074,'21','220','1',1,'Sale Id shift 135',0.00,0.00,0.00,6437.75,0.00,'2022-07-22 18:18:30','',''),(3075,'21','220',NULL,1,'Sale Id shift 135',9599747.50,0.00,0.00,0.00,0.00,'2022-07-22 18:18:30','',''),(3076,'21','220',NULL,2,'Sale Id shift 135',2777063.80,0.00,0.00,0.00,0.00,'2022-07-22 18:18:30','',''),(3077,'21','220',NULL,3,'Sale Id shift 135',262755.00,0.00,0.00,0.00,0.00,'2022-07-22 18:18:30','',''),(3078,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-23 15:17:56','',''),(3079,'21','220',NULL,1,'Reception corrector for bridging 336',0.00,0.00,0.00,30000.00,0.00,'2022-07-23 15:22:55','',''),(3080,'21','220','2',1,'Received from bridging 336',0.00,0.00,30000.00,0.00,0.00,'2022-07-23 15:22:55','',''),(3081,'21','220',NULL,1,'Reception corrector for bridging 335',0.00,0.00,0.00,15000.00,0.00,'2022-07-23 15:22:55','',''),(3082,'21','220','1',1,'Received from bridging 335',0.00,0.00,15000.00,0.00,0.00,'2022-07-23 15:22:55','',''),(3083,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,12450000.00,15000.00,0.00,0.00,'2022-07-23 16:14:05','',''),(3084,'21','220',NULL,2,'Reception corrector for bridging 337',0.00,0.00,0.00,15000.00,0.00,'2022-07-23 16:15:26','',''),(3085,'21','220','3',2,'Received from bridging 337',0.00,0.00,15000.00,0.00,0.00,'2022-07-23 16:15:26','',''),(3086,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,12225000.00,15000.00,0.00,0.00,'2022-07-23 16:26:42','',''),(3087,'21','220',NULL,2,'Reception corrector for bridging 338',0.00,0.00,0.00,15000.00,0.00,'2022-07-23 16:28:06','',''),(3088,'21','220','3',2,'Received from bridging 338',0.00,0.00,15000.00,0.00,0.00,'2022-07-23 16:28:06','',''),(3089,'21','220','3',2,'Returned bridging 337',0.00,0.00,0.00,15000.00,0.00,'2022-07-23 16:28:49','',''),(3090,'21','220',NULL,2,'Reception Return corrector for bridging 337',0.00,0.00,15000.00,0.00,0.00,'2022-07-23 16:28:49','',''),(3091,'21','220',NULL,2,'Returned purchase #180 to AYM SHAFA NIGERIA LIMITED',12450000.00,0.00,0.00,15000.00,0.00,'2022-07-23 16:29:06','',''),(3092,'21','220','3',2,'Sale Id shift 136',0.00,0.00,0.00,6441.46,0.00,'2022-07-23 16:32:03','',''),(3093,'21','220','1',1,'Sale Id shift 136',0.00,0.00,0.00,3339.79,0.00,'2022-07-23 16:32:03','',''),(3094,'21','220','1',1,'Sale Id shift 136',0.00,0.00,0.00,3048.32,0.00,'2022-07-23 16:32:03','',''),(3095,'21','220','1',1,'Sale Id shift 136',0.00,0.00,0.00,3714.03,0.00,'2022-07-23 16:32:03','',''),(3096,'21','220','2',1,'Sale Id shift 136',0.00,0.00,0.00,4555.07,0.00,'2022-07-23 16:32:03','',''),(3097,'21','220','2',1,'Sale Id shift 136',0.00,0.00,0.00,2952.69,0.00,'2022-07-23 16:32:03','',''),(3098,'21','220','2',1,'Sale Id shift 136',0.00,0.00,0.00,4156.25,0.00,'2022-07-23 16:32:03','',''),(3099,'21','220','2',1,'Sale Id shift 136',0.00,0.00,0.00,3752.73,0.00,'2022-07-23 16:32:03','',''),(3100,'21','220','1',1,'Sale Id shift 136',0.00,0.00,0.00,2959.22,0.00,'2022-07-23 16:32:03','',''),(3101,'21','220','2',1,'Sale Id shift 136',0.00,0.00,0.00,6066.46,0.00,'2022-07-23 16:32:03','',''),(3102,'21','220','2',1,'Sale Id shift 136',0.00,0.00,0.00,4389.06,0.00,'2022-07-23 16:32:03','',''),(3103,'21','220','2',1,'Sale Id shift 136',0.00,0.00,0.00,4177.20,0.00,'2022-07-23 16:32:03','',''),(3104,'21','220','2',1,'Sale Id shift 136',0.00,0.00,0.00,4344.92,0.00,'2022-07-23 16:32:03','',''),(3105,'21','220','1',1,'Sale Id shift 136',0.00,0.00,0.00,4835.33,0.00,'2022-07-23 16:32:03','',''),(3106,'21','220','3',2,'Sale Id shift 136',0.00,0.00,0.00,1500.00,0.00,'2022-07-23 16:32:03','',''),(3107,'21','220',NULL,1,'Sale Id shift 136',9150937.25,0.00,0.00,0.00,0.00,'2022-07-23 16:32:03','',''),(3108,'21','220',NULL,2,'Sale Id shift 136',6472289.90,0.00,0.00,0.00,0.00,'2022-07-23 16:32:03','',''),(3109,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-24 13:21:47','',''),(3110,'21','220',NULL,1,'Reception corrector for bridging 340',0.00,0.00,0.00,30000.00,0.00,'2022-07-24 13:25:15','',''),(3111,'21','220','2',1,'Received from bridging 340',0.00,0.00,30000.00,0.00,0.00,'2022-07-24 13:25:15','',''),(3112,'21','220',NULL,1,'Reception corrector for bridging 339',0.00,0.00,0.00,15000.00,0.00,'2022-07-24 13:25:15','',''),(3113,'21','220','1',1,'Received from bridging 339',0.00,0.00,15000.00,0.00,0.00,'2022-07-24 13:25:15','',''),(3114,'21','220','3',2,'Sale Id shift 137',0.00,0.00,0.00,4015.21,0.00,'2022-07-24 14:01:51','',''),(3115,'21','220','1',1,'Sale Id shift 137',0.00,0.00,0.00,1891.78,0.00,'2022-07-24 14:01:51','',''),(3116,'21','220','1',1,'Sale Id shift 137',0.00,0.00,0.00,2202.60,0.00,'2022-07-24 14:01:51','',''),(3117,'21','220','1',1,'Sale Id shift 137',0.00,0.00,0.00,4309.25,0.00,'2022-07-24 14:01:51','',''),(3118,'21','220','2',1,'Sale Id shift 137',0.00,0.00,0.00,4515.13,0.00,'2022-07-24 14:01:51','',''),(3119,'21','220','2',1,'Sale Id shift 137',0.00,0.00,0.00,3030.71,0.00,'2022-07-24 14:01:51','',''),(3120,'21','220','2',1,'Sale Id shift 137',0.00,0.00,0.00,3436.56,0.00,'2022-07-24 14:01:51','',''),(3121,'21','220','2',1,'Sale Id shift 137',0.00,0.00,0.00,3263.94,0.00,'2022-07-24 14:01:51','',''),(3122,'21','220','1',1,'Sale Id shift 137',0.00,0.00,0.00,3478.63,0.00,'2022-07-24 14:01:51','',''),(3123,'21','220','2',1,'Sale Id shift 137',0.00,0.00,0.00,4311.50,0.00,'2022-07-24 14:01:51','',''),(3124,'21','220','2',1,'Sale Id shift 137',0.00,0.00,0.00,3927.61,0.00,'2022-07-24 14:01:51','',''),(3125,'21','220','2',1,'Sale Id shift 137',0.00,0.00,0.00,3868.81,0.00,'2022-07-24 14:01:51','',''),(3126,'21','220','2',1,'Sale Id shift 137',0.00,0.00,0.00,4550.02,0.00,'2022-07-24 14:01:51','',''),(3127,'21','220','1',1,'Sale Id shift 137',0.00,0.00,0.00,3461.76,0.00,'2022-07-24 14:01:51','',''),(3128,'21','220',NULL,1,'Sale Id shift 137',8093452.50,0.00,0.00,0.00,0.00,'2022-07-24 14:01:51','',''),(3129,'21','220',NULL,2,'Sale Id shift 137',3272396.15,0.00,0.00,0.00,0.00,'2022-07-24 14:01:51','',''),(3130,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8750000.00,50000.00,0.00,0.00,'2022-07-25 08:31:54','',''),(3131,'21','220',NULL,1,'Reception corrector for bridging 342',0.00,0.00,0.00,32000.00,0.00,'2022-07-25 08:35:35','',''),(3132,'21','220','2',1,'Received from bridging 342',0.00,0.00,32000.00,0.00,0.00,'2022-07-25 08:35:35','',''),(3133,'21','220',NULL,1,'Reception corrector for bridging 341',0.00,0.00,0.00,18000.00,0.00,'2022-07-25 08:35:35','',''),(3134,'21','220','1',1,'Received from bridging 341',0.00,0.00,18000.00,0.00,0.00,'2022-07-25 08:35:35','',''),(3135,'21','220','3',2,'Sale Id shift 138',0.00,0.00,0.00,1507.88,0.00,'2022-07-25 17:28:18','',''),(3136,'21','220','1',1,'Sale Id shift 138',0.00,0.00,0.00,2455.93,0.00,'2022-07-25 17:28:18','',''),(3137,'21','220','1',1,'Sale Id shift 138',0.00,0.00,0.00,2419.99,0.00,'2022-07-25 17:28:18','',''),(3138,'21','220','1',1,'Sale Id shift 138',0.00,0.00,0.00,3496.56,0.00,'2022-07-25 17:28:18','',''),(3139,'21','220','2',1,'Sale Id shift 138',0.00,0.00,0.00,3571.85,0.00,'2022-07-25 17:28:18','',''),(3140,'21','220','2',1,'Sale Id shift 138',0.00,0.00,0.00,3588.36,0.00,'2022-07-25 17:28:18','',''),(3141,'21','220','2',1,'Sale Id shift 138',0.00,0.00,0.00,1044.04,0.00,'2022-07-25 17:28:18','',''),(3142,'21','220','2',1,'Sale Id shift 138',0.00,0.00,0.00,4194.40,0.00,'2022-07-25 17:28:18','',''),(3143,'21','220','1',1,'Sale Id shift 138',0.00,0.00,0.00,2895.48,0.00,'2022-07-25 17:28:18','',''),(3144,'21','220','2',1,'Sale Id shift 138',0.00,0.00,0.00,3588.60,0.00,'2022-07-25 17:28:18','',''),(3145,'21','220','2',1,'Sale Id shift 138',0.00,0.00,0.00,3707.68,0.00,'2022-07-25 17:28:18','',''),(3146,'21','220','2',1,'Sale Id shift 138',0.00,0.00,0.00,3821.33,0.00,'2022-07-25 17:28:18','',''),(3147,'21','220','2',1,'Sale Id shift 138',0.00,0.00,0.00,3428.62,0.00,'2022-07-25 17:28:18','',''),(3148,'21','220','1',1,'Sale Id shift 138',0.00,0.00,0.00,3558.92,0.00,'2022-07-25 17:28:18','',''),(3149,'21','220',NULL,1,'Sale Id shift 138',7310058.00,0.00,0.00,0.00,0.00,'2022-07-25 17:28:18','',''),(3150,'21','220',NULL,2,'Sale Id shift 138',1228922.20,0.00,0.00,0.00,0.00,'2022-07-25 17:28:18','',''),(3151,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-26 09:48:59','',''),(3152,'21','220',NULL,1,'Reception corrector for bridging 344',0.00,0.00,0.00,29000.00,0.00,'2022-07-26 09:53:25','',''),(3153,'21','220','2',1,'Received from bridging 344',0.00,0.00,29000.00,0.00,0.00,'2022-07-26 09:53:25','',''),(3154,'21','220',NULL,1,'Reception corrector for bridging 343',0.00,0.00,0.00,16000.00,0.00,'2022-07-26 09:53:25','',''),(3155,'21','220','1',1,'Received from bridging 343',0.00,0.00,16000.00,0.00,0.00,'2022-07-26 09:53:25','',''),(3156,'21','220','3',2,'Sale Id shift 139',0.00,0.00,0.00,2714.39,0.00,'2022-07-26 12:48:36','',''),(3157,'21','220','1',1,'Sale Id shift 139',0.00,0.00,0.00,2996.55,0.00,'2022-07-26 12:48:36','',''),(3158,'21','220','1',1,'Sale Id shift 139',0.00,0.00,0.00,1611.75,0.00,'2022-07-26 12:48:36','',''),(3159,'21','220','1',1,'Sale Id shift 139',0.00,0.00,0.00,3219.32,0.00,'2022-07-26 12:48:36','',''),(3160,'21','220','2',1,'Sale Id shift 139',0.00,0.00,0.00,4773.77,0.00,'2022-07-26 12:48:36','',''),(3161,'21','220','2',1,'Sale Id shift 139',0.00,0.00,0.00,3004.89,0.00,'2022-07-26 12:48:36','',''),(3162,'21','220','2',1,'Sale Id shift 139',0.00,0.00,0.00,4094.50,0.00,'2022-07-26 12:48:36','',''),(3163,'21','220','2',1,'Sale Id shift 139',0.00,0.00,0.00,3443.29,0.00,'2022-07-26 12:48:36','',''),(3164,'21','220','1',1,'Sale Id shift 139',0.00,0.00,0.00,3482.09,0.00,'2022-07-26 12:48:36','',''),(3165,'21','220','2',1,'Sale Id shift 139',0.00,0.00,0.00,4247.60,0.00,'2022-07-26 12:48:36','',''),(3166,'21','220','2',1,'Sale Id shift 139',0.00,0.00,0.00,3903.60,0.00,'2022-07-26 12:48:36','',''),(3167,'21','220','2',1,'Sale Id shift 139',0.00,0.00,0.00,3995.40,0.00,'2022-07-26 12:48:36','',''),(3168,'21','220','2',1,'Sale Id shift 139',0.00,0.00,0.00,4374.67,0.00,'2022-07-26 12:48:36','',''),(3169,'21','220','1',1,'Sale Id shift 139',0.00,0.00,0.00,4924.29,0.00,'2022-07-26 12:48:36','',''),(3170,'21','220',NULL,1,'Sale Id shift 139',8412551.00,0.00,0.00,0.00,0.00,'2022-07-26 12:48:36','',''),(3171,'21','220',NULL,2,'Sale Id shift 139',2198655.90,0.00,0.00,0.00,0.00,'2022-07-26 12:48:36','',''),(3172,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-27 12:42:19','',''),(3173,'21','220',NULL,1,'Reception corrector for bridging 346',0.00,0.00,0.00,30000.00,0.00,'2022-07-27 12:45:36','',''),(3174,'21','220','2',1,'Received from bridging 346',0.00,0.00,30000.00,0.00,0.00,'2022-07-27 12:45:36','',''),(3175,'21','220',NULL,1,'Reception corrector for bridging 345',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 12:45:36','',''),(3176,'21','220','1',1,'Received from bridging 345',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 12:45:36','',''),(3177,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-28 14:36:14','',''),(3178,'21','220','3',2,'Sale Id shift 140',0.00,0.00,0.00,4811.74,0.00,'2022-07-28 14:38:52','',''),(3179,'21','220','1',1,'Sale Id shift 140',0.00,0.00,0.00,3277.11,0.00,'2022-07-28 14:38:52','',''),(3180,'21','220','1',1,'Sale Id shift 140',0.00,0.00,0.00,2618.19,0.00,'2022-07-28 14:38:52','',''),(3181,'21','220','1',1,'Sale Id shift 140',0.00,0.00,0.00,3797.54,0.00,'2022-07-28 14:38:52','',''),(3182,'21','220','2',1,'Sale Id shift 140',0.00,0.00,0.00,4105.97,0.00,'2022-07-28 14:38:52','',''),(3183,'21','220','2',1,'Sale Id shift 140',0.00,0.00,0.00,3127.16,0.00,'2022-07-28 14:38:52','',''),(3184,'21','220','2',1,'Sale Id shift 140',0.00,0.00,0.00,3549.14,0.00,'2022-07-28 14:38:52','',''),(3185,'21','220','2',1,'Sale Id shift 140',0.00,0.00,0.00,3740.26,0.00,'2022-07-28 14:38:52','',''),(3186,'21','220','1',1,'Sale Id shift 140',0.00,0.00,0.00,3567.89,0.00,'2022-07-28 14:38:52','',''),(3187,'21','220','2',1,'Sale Id shift 140',0.00,0.00,0.00,4816.36,0.00,'2022-07-28 14:38:52','',''),(3188,'21','220','2',1,'Sale Id shift 140',0.00,0.00,0.00,3667.76,0.00,'2022-07-28 14:38:52','',''),(3189,'21','220','2',1,'Sale Id shift 140',0.00,0.00,0.00,3368.00,0.00,'2022-07-28 14:38:52','',''),(3190,'21','220','2',1,'Sale Id shift 140',0.00,0.00,0.00,3751.59,0.00,'2022-07-28 14:38:52','',''),(3191,'21','220','1',1,'Sale Id shift 140',0.00,0.00,0.00,4121.58,0.00,'2022-07-28 14:38:52','',''),(3192,'21','220',NULL,1,'Sale Id shift 140',8313996.25,0.00,0.00,0.00,0.00,'2022-07-28 14:38:52','',''),(3193,'21','220',NULL,2,'Sale Id shift 140',3897509.40,0.00,0.00,0.00,0.00,'2022-07-28 14:38:52','',''),(3194,'21','220',NULL,1,'Reception corrector for bridging 347',0.00,0.00,0.00,45000.00,0.00,'2022-07-28 14:42:09','',''),(3195,'21','220','2',1,'Received from bridging 347',0.00,0.00,45000.00,0.00,0.00,'2022-07-28 14:42:09','',''),(3196,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,24300000.00,30000.00,0.00,0.00,'2022-07-28 15:34:16','',''),(3197,'21','220',NULL,2,'Reception corrector for bridging 348',0.00,0.00,0.00,30000.00,0.00,'2022-07-28 15:37:15','',''),(3198,'21','220','3',2,'Received from bridging 348',0.00,0.00,30000.00,0.00,0.00,'2022-07-28 15:37:15','',''),(3199,'21','220','2',1,'Returned bridging 346',0.00,0.00,0.00,30000.00,0.00,'2022-07-28 16:43:54','',''),(3200,'21','220',NULL,1,'Reception Return corrector for bridging 346',0.00,0.00,30000.00,0.00,0.00,'2022-07-28 16:43:54','',''),(3201,'21','220',NULL,1,'Reception corrector for bridging 349',0.00,0.00,0.00,477.12,0.00,'2022-07-28 16:47:53','',''),(3202,'21','220','1',1,'Received from bridging 349',0.00,0.00,477.12,0.00,0.00,'2022-07-28 16:47:53','',''),(3203,'21','220',NULL,1,'Reception corrector for bridging 350',0.00,0.00,0.00,1.00,0.00,'2022-07-28 16:52:10','',''),(3204,'21','220','1',1,'Received from bridging 350',0.00,0.00,1.00,0.00,0.00,'2022-07-28 16:52:10','',''),(3205,'21','220',NULL,1,'Reception corrector for bridging 351',0.00,0.00,0.00,100.00,0.00,'2022-07-28 16:55:13','',''),(3206,'21','220','1',1,'Received from bridging 351',0.00,0.00,100.00,0.00,0.00,'2022-07-28 16:55:13','',''),(3207,'21','220',NULL,1,'Reception corrector for bridging 352',0.00,0.00,0.00,5518.00,0.00,'2022-07-28 17:04:57','',''),(3208,'21','220','2',1,'Received from bridging 352',0.00,0.00,5518.00,0.00,0.00,'2022-07-28 17:04:57','',''),(3209,'21','220','3',2,'Sale Id shift 141',0.00,0.00,0.00,3813.28,0.00,'2022-07-28 17:35:51','',''),(3210,'21','220','1',1,'Sale Id shift 141',0.00,0.00,0.00,1726.83,0.00,'2022-07-28 17:35:51','',''),(3211,'21','220','1',1,'Sale Id shift 141',0.00,0.00,0.00,1833.89,0.00,'2022-07-28 17:35:51','',''),(3212,'21','220','1',1,'Sale Id shift 141',0.00,0.00,0.00,1748.98,0.00,'2022-07-28 17:35:51','',''),(3213,'21','220','1',1,'Sale Id shift 141',0.00,0.00,0.00,822.42,0.00,'2022-07-28 17:35:51','',''),(3214,'21','220','2',1,'Sale Id shift 141',0.00,0.00,0.00,4098.20,0.00,'2022-07-28 17:35:51','',''),(3215,'21','220','2',1,'Sale Id shift 141',0.00,0.00,0.00,3571.60,0.00,'2022-07-28 17:35:51','',''),(3216,'21','220','2',1,'Sale Id shift 141',0.00,0.00,0.00,4486.37,0.00,'2022-07-28 17:35:51','',''),(3217,'21','220','2',1,'Sale Id shift 141',0.00,0.00,0.00,4485.05,0.00,'2022-07-28 17:35:51','',''),(3218,'21','220','1',1,'Sale Id shift 141',0.00,0.00,0.00,1879.96,0.00,'2022-07-28 17:35:51','',''),(3219,'21','220','2',1,'Sale Id shift 141',0.00,0.00,0.00,5028.24,0.00,'2022-07-28 17:35:51','',''),(3220,'21','220','2',1,'Sale Id shift 141',0.00,0.00,0.00,4014.90,0.00,'2022-07-28 17:35:51','',''),(3221,'21','220','2',1,'Sale Id shift 141',0.00,0.00,0.00,4590.74,0.00,'2022-07-28 17:35:51','',''),(3222,'21','220','2',1,'Sale Id shift 141',0.00,0.00,0.00,4586.71,0.00,'2022-07-28 17:35:51','',''),(3223,'21','220','1',1,'Sale Id shift 141',0.00,0.00,0.00,2551.94,0.00,'2022-07-28 17:35:51','',''),(3224,'21','220',NULL,1,'Sale Id shift 141',7949520.25,0.00,0.00,0.00,0.00,'2022-07-28 17:35:51','',''),(3225,'21','220',NULL,2,'Sale Id shift 141',3088756.80,0.00,0.00,0.00,0.00,'2022-07-28 17:35:51','',''),(3226,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-29 11:41:30','',''),(3227,'21','220',NULL,1,'Reception corrector for bridging 353',0.00,0.00,0.00,45000.00,0.00,'2022-07-29 11:43:47','',''),(3228,'21','220','1',1,'Received from bridging 353',0.00,0.00,45000.00,0.00,0.00,'2022-07-29 11:43:47','',''),(3229,'21','220',NULL,1,'Reception corrector for bridging 355',0.00,0.00,0.00,5000.00,0.00,'2022-07-29 17:14:50','',''),(3230,'21','220','2',1,'Received from bridging 355',0.00,0.00,5000.00,0.00,0.00,'2022-07-29 17:14:50','',''),(3231,'21','220',NULL,1,'Reception corrector for bridging 354',0.00,0.00,0.00,5000.00,0.00,'2022-07-29 17:14:50','',''),(3232,'21','220','1',1,'Received from bridging 354',0.00,0.00,5000.00,0.00,0.00,'2022-07-29 17:14:50','',''),(3233,'21','220',NULL,1,'Reception corrector for bridging 357',0.00,0.00,0.00,6000.00,0.00,'2022-07-29 17:16:41','',''),(3234,'21','220','2',1,'Received from bridging 357',0.00,0.00,6000.00,0.00,0.00,'2022-07-29 17:16:41','',''),(3235,'21','220',NULL,1,'Reception corrector for bridging 356',0.00,0.00,0.00,6000.00,0.00,'2022-07-29 17:16:41','',''),(3236,'21','220','1',1,'Received from bridging 356',0.00,0.00,6000.00,0.00,0.00,'2022-07-29 17:16:41','',''),(3237,'21','220','1',1,'Returned bridging 356',0.00,0.00,0.00,6000.00,0.00,'2022-07-30 09:03:12','',''),(3238,'21','220',NULL,1,'Reception Return corrector for bridging 356',0.00,0.00,6000.00,0.00,0.00,'2022-07-30 09:03:12','',''),(3239,'21','220','1',1,'Returned bridging 354',0.00,0.00,0.00,5000.00,0.00,'2022-07-30 09:04:40','',''),(3240,'21','220',NULL,1,'Reception Return corrector for bridging 354',0.00,0.00,5000.00,0.00,0.00,'2022-07-30 09:04:40','',''),(3241,'21','220',NULL,1,'Reception corrector for bridging 359',0.00,0.00,0.00,12903.88,0.00,'2022-07-30 09:06:30','',''),(3242,'21','220','2',1,'Received from bridging 359',0.00,0.00,12903.88,0.00,0.00,'2022-07-30 09:06:30','',''),(3243,'21','220','3',2,'Sale Id shift 142',0.00,0.00,0.00,7364.91,0.00,'2022-07-30 09:07:56','',''),(3244,'21','220','1',1,'Sale Id shift 142',0.00,0.00,0.00,1646.56,0.00,'2022-07-30 09:07:56','',''),(3245,'21','220','1',1,'Sale Id shift 142',0.00,0.00,0.00,953.19,0.00,'2022-07-30 09:07:56','',''),(3246,'21','220','1',1,'Sale Id shift 142',0.00,0.00,0.00,1110.42,0.00,'2022-07-30 09:07:56','',''),(3247,'21','220','1',1,'Sale Id shift 142',0.00,0.00,0.00,1260.81,0.00,'2022-07-30 09:07:56','',''),(3248,'21','220','2',1,'Sale Id shift 142',0.00,0.00,0.00,4710.08,0.00,'2022-07-30 09:07:56','',''),(3249,'21','220','2',1,'Sale Id shift 142',0.00,0.00,0.00,3597.26,0.00,'2022-07-30 09:07:56','',''),(3250,'21','220','2',1,'Sale Id shift 142',0.00,0.00,0.00,3056.15,0.00,'2022-07-30 09:07:56','',''),(3251,'21','220','2',1,'Sale Id shift 142',0.00,0.00,0.00,4691.12,0.00,'2022-07-30 09:07:56','',''),(3252,'21','220','1',1,'Sale Id shift 142',0.00,0.00,0.00,1405.40,0.00,'2022-07-30 09:07:56','',''),(3253,'21','220','2',1,'Sale Id shift 142',0.00,0.00,0.00,5387.64,0.00,'2022-07-30 09:07:56','',''),(3254,'21','220','2',1,'Sale Id shift 142',0.00,0.00,0.00,3451.58,0.00,'2022-07-30 09:07:56','',''),(3255,'21','220','2',1,'Sale Id shift 142',0.00,0.00,0.00,4303.50,0.00,'2022-07-30 09:07:56','',''),(3256,'21','220','2',1,'Sale Id shift 142',0.00,0.00,0.00,4397.37,0.00,'2022-07-30 09:07:56','',''),(3257,'21','220','1',1,'Sale Id shift 142',0.00,0.00,0.00,1882.96,0.00,'2022-07-30 09:07:56','',''),(3258,'21','220','3',2,'Sale Id shift 142',0.00,0.00,0.00,98.17,0.00,'2022-07-30 09:07:56','',''),(3259,'21','220',NULL,2,'Sale Id shift 142',6045094.80,0.00,0.00,0.00,0.00,'2022-07-30 09:07:56','',''),(3260,'21','220',NULL,1,'Sale Id shift 142',7324457.00,0.00,0.00,0.00,0.00,'2022-07-30 09:07:56','',''),(3261,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8750000.00,50000.00,0.00,0.00,'2022-07-30 09:13:54','',''),(3262,'21','220',NULL,1,'Reception corrector for bridging 361',0.00,0.00,0.00,30000.00,0.00,'2022-07-30 09:15:48','',''),(3263,'21','220','2',1,'Received from bridging 361',0.00,0.00,30000.00,0.00,0.00,'2022-07-30 09:15:48','',''),(3264,'21','220',NULL,1,'Reception corrector for bridging 360',0.00,0.00,0.00,20000.00,0.00,'2022-07-30 09:15:48','',''),(3265,'21','220','1',1,'Received from bridging 360',0.00,0.00,20000.00,0.00,0.00,'2022-07-30 09:15:48','',''),(3266,'21','220','1',1,'Returned bridging 360',0.00,0.00,0.00,20000.00,0.00,'2022-07-30 09:17:22','',''),(3267,'21','220',NULL,1,'Reception Return corrector for bridging 360',0.00,0.00,20000.00,0.00,0.00,'2022-07-30 09:17:22','',''),(3268,'21','220',NULL,1,'Reception corrector for bridging 363',0.00,0.00,0.00,3000.00,0.00,'2022-07-30 13:26:34','',''),(3269,'21','220','2',1,'Received from bridging 363',0.00,0.00,3000.00,0.00,0.00,'2022-07-30 13:26:34','',''),(3270,'21','220',NULL,1,'Reception corrector for bridging 362',0.00,0.00,0.00,7000.00,0.00,'2022-07-30 13:26:34','',''),(3271,'21','220','1',1,'Received from bridging 362',0.00,0.00,7000.00,0.00,0.00,'2022-07-30 13:26:34','',''),(3272,'21','220',NULL,1,'Reception corrector for bridging 365',0.00,0.00,0.00,6000.00,0.00,'2022-07-30 13:29:30','',''),(3273,'21','220','2',1,'Received from bridging 365',0.00,0.00,6000.00,0.00,0.00,'2022-07-30 13:29:30','',''),(3274,'21','220',NULL,1,'Reception corrector for bridging 364',0.00,0.00,0.00,4000.00,0.00,'2022-07-30 13:29:30','',''),(3275,'21','220','1',1,'Received from bridging 364',0.00,0.00,4000.00,0.00,0.00,'2022-07-30 13:29:30','',''),(3276,'21','220','1',1,'Sale Id shift 143',0.00,0.00,0.00,6177.45,0.00,'2022-07-30 13:30:36','',''),(3277,'21','220','3',2,'Sale Id shift 143',0.00,0.00,0.00,2506.71,0.00,'2022-07-30 13:30:36','',''),(3278,'21','220','1',1,'Sale Id shift 143',0.00,0.00,0.00,5277.74,0.00,'2022-07-30 13:30:36','',''),(3279,'21','220','1',1,'Sale Id shift 143',0.00,0.00,0.00,5268.52,0.00,'2022-07-30 13:30:36','',''),(3280,'21','220','1',1,'Sale Id shift 143',0.00,0.00,0.00,5839.29,0.00,'2022-07-30 13:30:36','',''),(3281,'21','220','1',1,'Sale Id shift 143',0.00,0.00,0.00,5749.12,0.00,'2022-07-30 13:30:36','',''),(3282,'21','220','2',1,'Sale Id shift 143',0.00,0.00,0.00,1389.76,0.00,'2022-07-30 13:30:36','',''),(3283,'21','220','2',1,'Sale Id shift 143',0.00,0.00,0.00,706.45,0.00,'2022-07-30 13:30:36','',''),(3284,'21','220','2',1,'Sale Id shift 143',0.00,0.00,0.00,1076.50,0.00,'2022-07-30 13:30:36','',''),(3285,'21','220','2',1,'Sale Id shift 143',0.00,0.00,0.00,872.11,0.00,'2022-07-30 13:30:36','',''),(3286,'21','220','1',1,'Sale Id shift 143',0.00,0.00,0.00,6375.38,0.00,'2022-07-30 13:30:36','',''),(3287,'21','220','2',1,'Sale Id shift 143',0.00,0.00,0.00,1422.06,0.00,'2022-07-30 13:30:36','',''),(3288,'21','220','2',1,'Sale Id shift 143',0.00,0.00,0.00,780.39,0.00,'2022-07-30 13:30:36','',''),(3289,'21','220','2',1,'Sale Id shift 143',0.00,0.00,0.00,1019.17,0.00,'2022-07-30 13:30:36','',''),(3290,'21','220','2',1,'Sale Id shift 143',0.00,0.00,0.00,675.78,0.00,'2022-07-30 13:30:36','',''),(3291,'21','220','1',1,'Sale Id shift 143',0.00,0.00,0.00,9444.91,0.00,'2022-07-30 13:30:36','',''),(3292,'21','220',NULL,2,'Sale Id shift 143',2030435.10,0.00,0.00,0.00,0.00,'2022-07-30 13:30:36','',''),(3293,'21','220',NULL,1,'Sale Id shift 143',9113060.25,0.00,0.00,0.00,0.00,'2022-07-30 13:30:36','',''),(3294,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-07-31 14:14:07','',''),(3295,'21','220',NULL,1,'Reception corrector for bridging 367',0.00,0.00,0.00,30000.00,0.00,'2022-07-31 14:15:31','',''),(3296,'21','220','2',1,'Received from bridging 367',0.00,0.00,30000.00,0.00,0.00,'2022-07-31 14:15:31','',''),(3297,'21','220',NULL,1,'Reception corrector for bridging 366',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 14:15:31','',''),(3298,'21','220','1',1,'Received from bridging 366',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 14:15:31','',''),(3299,'21','220',NULL,1,'Reception corrector for bridging 368',0.00,0.00,0.00,5000.00,0.00,'2022-07-31 17:09:15','',''),(3300,'21','220','1',1,'Received from bridging 368',0.00,0.00,5000.00,0.00,0.00,'2022-07-31 17:09:15','',''),(3301,'21','220',NULL,1,'Reception corrector for bridging 369',0.00,0.00,0.00,5000.00,0.00,'2022-07-31 17:14:41','',''),(3302,'21','220','1',1,'Received from bridging 369',0.00,0.00,5000.00,0.00,0.00,'2022-07-31 17:14:41','',''),(3303,'21','220','1',1,'Sale Id shift 144',0.00,0.00,0.00,3648.32,0.00,'2022-07-31 17:22:47','',''),(3304,'21','220','3',2,'Sale Id shift 144',0.00,0.00,0.00,3006.11,0.00,'2022-07-31 17:22:47','',''),(3305,'21','220','1',1,'Sale Id shift 144',0.00,0.00,0.00,3100.80,0.00,'2022-07-31 17:22:47','',''),(3306,'21','220','1',1,'Sale Id shift 144',0.00,0.00,0.00,2282.06,0.00,'2022-07-31 17:22:47','',''),(3307,'21','220','1',1,'Sale Id shift 144',0.00,0.00,0.00,2226.90,0.00,'2022-07-31 17:22:47','',''),(3308,'21','220','1',1,'Sale Id shift 144',0.00,0.00,0.00,2196.49,0.00,'2022-07-31 17:22:47','',''),(3309,'21','220','2',1,'Sale Id shift 144',0.00,0.00,0.00,4380.82,0.00,'2022-07-31 17:22:47','',''),(3310,'21','220','2',1,'Sale Id shift 144',0.00,0.00,0.00,3754.64,0.00,'2022-07-31 17:22:47','',''),(3311,'21','220','2',1,'Sale Id shift 144',0.00,0.00,0.00,2964.31,0.00,'2022-07-31 17:22:47','',''),(3312,'21','220','2',1,'Sale Id shift 144',0.00,0.00,0.00,3724.81,0.00,'2022-07-31 17:22:47','',''),(3313,'21','220','1',1,'Sale Id shift 144',0.00,0.00,0.00,2609.36,0.00,'2022-07-31 17:22:47','',''),(3314,'21','220','2',1,'Sale Id shift 144',0.00,0.00,0.00,4734.70,0.00,'2022-07-31 17:22:47','',''),(3315,'21','220','2',1,'Sale Id shift 144',0.00,0.00,0.00,2327.92,0.00,'2022-07-31 17:22:47','',''),(3316,'21','220','2',1,'Sale Id shift 144',0.00,0.00,0.00,3743.41,0.00,'2022-07-31 17:22:47','',''),(3317,'21','220','2',1,'Sale Id shift 144',0.00,0.00,0.00,4506.75,0.00,'2022-07-31 17:22:47','',''),(3318,'21','220','1',1,'Sale Id shift 144',0.00,0.00,0.00,5044.89,0.00,'2022-07-31 17:22:47','',''),(3319,'21','220','3',2,'Sale Id shift 144',0.00,0.00,0.00,172.81,0.00,'2022-07-31 17:22:47','',''),(3320,'21','220',NULL,1,'Sale Id shift 144',8968081.50,0.00,0.00,0.00,0.00,'2022-07-31 17:22:47','',''),(3321,'21','220',NULL,2,'Sale Id shift 144',2574925.20,0.00,0.00,0.00,0.00,'2022-07-31 17:22:47','',''),(3322,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-01 13:14:40','',''),(3323,'21','220',NULL,1,'Reception corrector for bridging 370',0.00,0.00,0.00,45000.00,0.00,'2022-08-01 13:16:38','',''),(3324,'21','220','2',1,'Received from bridging 370',0.00,0.00,45000.00,0.00,0.00,'2022-08-01 13:16:38','',''),(3325,'21','220','3',2,'Sale Id shift 145',0.00,0.00,0.00,718.22,0.00,'2022-08-02 15:15:59','',''),(3326,'21','220','1',1,'Sale Id shift 145',0.00,0.00,0.00,947.38,0.00,'2022-08-02 15:15:59','',''),(3327,'21','220','1',1,'Sale Id shift 145',0.00,0.00,0.00,554.92,0.00,'2022-08-02 15:15:59','',''),(3328,'21','220','1',1,'Sale Id shift 145',0.00,0.00,0.00,788.62,0.00,'2022-08-02 15:15:59','',''),(3329,'21','220','1',1,'Sale Id shift 145',0.00,0.00,0.00,929.95,0.00,'2022-08-02 15:15:59','',''),(3330,'21','220','2',1,'Sale Id shift 145',0.00,0.00,0.00,3934.76,0.00,'2022-08-02 15:15:59','',''),(3331,'21','220','2',1,'Sale Id shift 145',0.00,0.00,0.00,3182.29,0.00,'2022-08-02 15:15:59','',''),(3332,'21','220','2',1,'Sale Id shift 145',0.00,0.00,0.00,3152.66,0.00,'2022-08-02 15:15:59','',''),(3333,'21','220','2',1,'Sale Id shift 145',0.00,0.00,0.00,2691.73,0.00,'2022-08-02 15:15:59','',''),(3334,'21','220','1',1,'Sale Id shift 145',0.00,0.00,0.00,1408.50,0.00,'2022-08-02 15:15:59','',''),(3335,'21','220','2',1,'Sale Id shift 145',0.00,0.00,0.00,4185.34,0.00,'2022-08-02 15:15:59','',''),(3336,'21','220','2',1,'Sale Id shift 145',0.00,0.00,0.00,3314.30,0.00,'2022-08-02 15:15:59','',''),(3337,'21','220','2',1,'Sale Id shift 145',0.00,0.00,0.00,2961.79,0.00,'2022-08-02 15:15:59','',''),(3338,'21','220','2',1,'Sale Id shift 145',0.00,0.00,0.00,2552.56,0.00,'2022-08-02 15:15:59','',''),(3339,'21','220','1',1,'Sale Id shift 145',0.00,0.00,0.00,1682.43,0.00,'2022-08-02 15:15:59','',''),(3340,'21','220',NULL,1,'Sale Id shift 145',5650265.25,0.00,0.00,0.00,0.00,'2022-08-02 15:15:59','',''),(3341,'21','220',NULL,2,'Sale Id shift 145',581758.20,0.00,0.00,0.00,0.00,'2022-08-02 15:15:59','',''),(3342,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-02 15:56:52','',''),(3343,'21','220',NULL,1,'Reception corrector for bridging 372',0.00,0.00,0.00,30000.00,0.00,'2022-08-02 15:58:11','',''),(3344,'21','220','2',1,'Received from bridging 372',0.00,0.00,30000.00,0.00,0.00,'2022-08-02 15:58:11','',''),(3345,'21','220',NULL,1,'Reception corrector for bridging 371',0.00,0.00,0.00,15000.00,0.00,'2022-08-02 15:58:11','',''),(3346,'21','220','1',1,'Received from bridging 371',0.00,0.00,15000.00,0.00,0.00,'2022-08-02 15:58:11','',''),(3347,'21','220','3',2,'Sale Id shift 146',0.00,0.00,0.00,2178.39,0.00,'2022-08-02 16:51:32','',''),(3348,'21','220','2',1,'Sale Id shift 146',0.00,0.00,0.00,5742.67,0.00,'2022-08-02 16:51:32','',''),(3349,'21','220','2',1,'Sale Id shift 146',0.00,0.00,0.00,4579.23,0.00,'2022-08-02 16:51:32','',''),(3350,'21','220','2',1,'Sale Id shift 146',0.00,0.00,0.00,5557.00,0.00,'2022-08-02 16:51:32','',''),(3351,'21','220','2',1,'Sale Id shift 146',0.00,0.00,0.00,5268.49,0.00,'2022-08-02 16:51:32','',''),(3352,'21','220','2',1,'Sale Id shift 146',0.00,0.00,0.00,5792.26,0.00,'2022-08-02 16:51:32','',''),(3353,'21','220','2',1,'Sale Id shift 146',0.00,0.00,0.00,5625.25,0.00,'2022-08-02 16:51:32','',''),(3354,'21','220','2',1,'Sale Id shift 146',0.00,0.00,0.00,4944.14,0.00,'2022-08-02 16:51:32','',''),(3355,'21','220','2',1,'Sale Id shift 146',0.00,0.00,0.00,5139.51,0.00,'2022-08-02 16:51:32','',''),(3356,'21','220','1',1,'Sale Id shift 146',0.00,0.00,0.00,130.15,0.00,'2022-08-02 16:51:32','',''),(3357,'21','220',NULL,1,'Sale Id shift 146',7486272.50,0.00,0.00,0.00,0.00,'2022-08-02 16:51:32','',''),(3358,'21','220',NULL,2,'Sale Id shift 146',1764495.90,0.00,0.00,0.00,0.00,'2022-08-02 16:51:32','',''),(3359,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-03 12:35:58','',''),(3360,'21','220',NULL,1,'Reception corrector for bridging 374',0.00,0.00,0.00,30000.00,0.00,'2022-08-03 12:40:17','',''),(3361,'21','220','2',1,'Received from bridging 374',0.00,0.00,30000.00,0.00,0.00,'2022-08-03 12:40:17','',''),(3362,'21','220',NULL,1,'Reception corrector for bridging 373',0.00,0.00,0.00,15000.00,0.00,'2022-08-03 12:40:17','',''),(3363,'21','220','1',1,'Received from bridging 373',0.00,0.00,15000.00,0.00,0.00,'2022-08-03 12:40:17','',''),(3364,'21','220','1',1,'Sale Id shift 147',0.00,0.00,0.00,3631.68,0.00,'2022-08-03 12:49:24','',''),(3365,'21','220','3',2,'Sale Id shift 147',0.00,0.00,0.00,3332.80,0.00,'2022-08-03 12:49:24','',''),(3366,'21','220','1',1,'Sale Id shift 147',0.00,0.00,0.00,2659.72,0.00,'2022-08-03 12:49:24','',''),(3367,'21','220','1',1,'Sale Id shift 147',0.00,0.00,0.00,2204.07,0.00,'2022-08-03 12:49:24','',''),(3368,'21','220','1',1,'Sale Id shift 147',0.00,0.00,0.00,2475.05,0.00,'2022-08-03 12:49:24','',''),(3369,'21','220','1',1,'Sale Id shift 147',0.00,0.00,0.00,1961.36,0.00,'2022-08-03 12:49:24','',''),(3370,'21','220','2',1,'Sale Id shift 147',0.00,0.00,0.00,4539.77,0.00,'2022-08-03 12:49:24','',''),(3371,'21','220','2',1,'Sale Id shift 147',0.00,0.00,0.00,3537.46,0.00,'2022-08-03 12:49:24','',''),(3372,'21','220','2',1,'Sale Id shift 147',0.00,0.00,0.00,2167.66,0.00,'2022-08-03 12:49:24','',''),(3373,'21','220','2',1,'Sale Id shift 147',0.00,0.00,0.00,5099.59,0.00,'2022-08-03 12:49:24','',''),(3374,'21','220','1',1,'Sale Id shift 147',0.00,0.00,0.00,2392.68,0.00,'2022-08-03 12:49:24','',''),(3375,'21','220','2',1,'Sale Id shift 147',0.00,0.00,0.00,5613.17,0.00,'2022-08-03 12:49:24','',''),(3376,'21','220','2',1,'Sale Id shift 147',0.00,0.00,0.00,3106.13,0.00,'2022-08-03 12:49:24','',''),(3377,'21','220','2',1,'Sale Id shift 147',0.00,0.00,0.00,4398.97,0.00,'2022-08-03 12:49:24','',''),(3378,'21','220','2',1,'Sale Id shift 147',0.00,0.00,0.00,4105.05,0.00,'2022-08-03 12:49:24','',''),(3379,'21','220','1',1,'Sale Id shift 147',0.00,0.00,0.00,3859.79,0.00,'2022-08-03 12:49:24','',''),(3380,'21','220','3',2,'Sale Id shift 147',0.00,0.00,0.00,1856.47,0.00,'2022-08-03 12:49:24','',''),(3381,'21','220',NULL,1,'Sale Id shift 147',9056626.25,0.00,0.00,0.00,0.00,'2022-08-03 12:49:24','',''),(3382,'21','220',NULL,2,'Sale Id shift 147',4203308.70,0.00,0.00,0.00,0.00,'2022-08-03 12:49:24','',''),(3383,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-04 13:39:42','',''),(3384,'21','220',NULL,1,'Reception corrector for bridging 376',0.00,0.00,0.00,30000.00,0.00,'2022-08-04 13:41:22','',''),(3385,'21','220','2',1,'Received from bridging 376',0.00,0.00,30000.00,0.00,0.00,'2022-08-04 13:41:22','',''),(3386,'21','220',NULL,1,'Reception corrector for bridging 375',0.00,0.00,0.00,15000.00,0.00,'2022-08-04 13:41:22','',''),(3387,'21','220','1',1,'Received from bridging 375',0.00,0.00,15000.00,0.00,0.00,'2022-08-04 13:41:22','',''),(3388,'21','220','1',1,'Sale Id shift 148',0.00,0.00,0.00,2768.12,0.00,'2022-08-04 16:21:01','',''),(3389,'21','220','1',1,'Sale Id shift 148',0.00,0.00,0.00,2079.54,0.00,'2022-08-04 16:21:01','',''),(3390,'21','220','1',1,'Sale Id shift 148',0.00,0.00,0.00,1223.27,0.00,'2022-08-04 16:21:01','',''),(3391,'21','220','1',1,'Sale Id shift 148',0.00,0.00,0.00,2640.12,0.00,'2022-08-04 16:21:01','',''),(3392,'21','220','1',1,'Sale Id shift 148',0.00,0.00,0.00,1703.22,0.00,'2022-08-04 16:21:01','',''),(3393,'21','220','2',1,'Sale Id shift 148',0.00,0.00,0.00,4354.16,0.00,'2022-08-04 16:21:01','',''),(3394,'21','220','2',1,'Sale Id shift 148',0.00,0.00,0.00,3759.31,0.00,'2022-08-04 16:21:01','',''),(3395,'21','220','2',1,'Sale Id shift 148',0.00,0.00,0.00,3352.31,0.00,'2022-08-04 16:21:01','',''),(3396,'21','220','2',1,'Sale Id shift 148',0.00,0.00,0.00,4056.38,0.00,'2022-08-04 16:21:01','',''),(3397,'21','220','1',1,'Sale Id shift 148',0.00,0.00,0.00,2519.51,0.00,'2022-08-04 16:21:01','',''),(3398,'21','220','2',1,'Sale Id shift 148',0.00,0.00,0.00,5499.00,0.00,'2022-08-04 16:21:01','',''),(3399,'21','220','2',1,'Sale Id shift 148',0.00,0.00,0.00,3139.33,0.00,'2022-08-04 16:21:01','',''),(3400,'21','220','2',1,'Sale Id shift 148',0.00,0.00,0.00,3180.69,0.00,'2022-08-04 16:21:01','',''),(3401,'21','220','2',1,'Sale Id shift 148',0.00,0.00,0.00,4340.75,0.00,'2022-08-04 16:21:01','',''),(3402,'21','220','1',1,'Sale Id shift 148',0.00,0.00,0.00,3660.51,0.00,'2022-08-04 16:21:01','',''),(3403,'21','220','3',2,'Sale Id shift 148',0.00,0.00,0.00,2719.00,0.00,'2022-08-04 16:21:01','',''),(3404,'21','220',NULL,1,'Sale Id shift 148',8448338.50,0.00,0.00,0.00,0.00,'2022-08-04 16:21:01','',''),(3405,'21','220',NULL,2,'Sale Id shift 148',2202390.00,0.00,0.00,0.00,0.00,'2022-08-04 16:21:01','',''),(3406,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-05 12:53:31','',''),(3407,'21','220',NULL,1,'Reception corrector for bridging 378',0.00,0.00,0.00,30000.00,0.00,'2022-08-05 12:57:51','',''),(3408,'21','220','2',1,'Received from bridging 378',0.00,0.00,30000.00,0.00,0.00,'2022-08-05 12:57:51','',''),(3409,'21','220',NULL,1,'Reception corrector for bridging 377',0.00,0.00,0.00,15000.00,0.00,'2022-08-05 12:57:51','',''),(3410,'21','220','1',1,'Received from bridging 377',0.00,0.00,15000.00,0.00,0.00,'2022-08-05 12:57:51','',''),(3411,'21','220','1',1,'Sale Id shift 149',0.00,0.00,0.00,1939.90,0.00,'2022-08-05 13:43:24','',''),(3412,'21','220','3',2,'Sale Id shift 149',0.00,0.00,0.00,3936.70,0.00,'2022-08-05 13:43:24','',''),(3413,'21','220','1',1,'Sale Id shift 149',0.00,0.00,0.00,1350.53,0.00,'2022-08-05 13:43:24','',''),(3414,'21','220','1',1,'Sale Id shift 149',0.00,0.00,0.00,883.99,0.00,'2022-08-05 13:43:24','',''),(3415,'21','220','1',1,'Sale Id shift 149',0.00,0.00,0.00,957.75,0.00,'2022-08-05 13:43:24','',''),(3416,'21','220','1',1,'Sale Id shift 149',0.00,0.00,0.00,1317.47,0.00,'2022-08-05 13:43:24','',''),(3417,'21','220','2',1,'Sale Id shift 149',0.00,0.00,0.00,3259.32,0.00,'2022-08-05 13:43:24','',''),(3418,'21','220','2',1,'Sale Id shift 149',0.00,0.00,0.00,2481.40,0.00,'2022-08-05 13:43:24','',''),(3419,'21','220','2',1,'Sale Id shift 149',0.00,0.00,0.00,2532.35,0.00,'2022-08-05 13:43:24','',''),(3420,'21','220','2',1,'Sale Id shift 149',0.00,0.00,0.00,2585.38,0.00,'2022-08-05 13:43:24','',''),(3421,'21','220','1',1,'Sale Id shift 149',0.00,0.00,0.00,1179.33,0.00,'2022-08-05 13:43:24','',''),(3422,'21','220','2',1,'Sale Id shift 149',0.00,0.00,0.00,3257.43,0.00,'2022-08-05 13:43:24','',''),(3423,'21','220','2',1,'Sale Id shift 149',0.00,0.00,0.00,3185.47,0.00,'2022-08-05 13:43:24','',''),(3424,'21','220','2',1,'Sale Id shift 149',0.00,0.00,0.00,3133.33,0.00,'2022-08-05 13:43:24','',''),(3425,'21','220','2',1,'Sale Id shift 149',0.00,0.00,0.00,3279.88,0.00,'2022-08-05 13:43:24','',''),(3426,'21','220','1',1,'Sale Id shift 149',0.00,0.00,0.00,1834.10,0.00,'2022-08-05 13:43:24','',''),(3427,'21','220','3',2,'Sale Id shift 149',0.00,0.00,0.00,156.23,0.00,'2022-08-05 13:43:24','',''),(3428,'21','220',NULL,1,'Sale Id shift 149',5806085.25,0.00,0.00,0.00,0.00,'2022-08-05 13:43:24','',''),(3429,'21','220',NULL,2,'Sale Id shift 149',3315273.30,0.00,0.00,0.00,0.00,'2022-08-05 13:43:24','',''),(3430,'21','220','2',1,'Returned bridging 378',0.00,0.00,0.00,30000.00,0.00,'2022-08-06 14:30:24','',''),(3431,'21','220',NULL,1,'Reception Return corrector for bridging 378',0.00,0.00,30000.00,0.00,0.00,'2022-08-06 14:30:24','',''),(3432,'21','220',NULL,1,'Reception corrector for bridging 380',0.00,0.00,0.00,27000.00,0.00,'2022-08-06 14:31:58','',''),(3433,'21','220','2',1,'Received from bridging 380',0.00,0.00,27000.00,0.00,0.00,'2022-08-06 14:31:58','',''),(3434,'21','220',NULL,1,'Reception corrector for bridging 379',0.00,0.00,0.00,3000.00,0.00,'2022-08-06 14:31:58','',''),(3435,'21','220','1',1,'Received from bridging 379',0.00,0.00,3000.00,0.00,0.00,'2022-08-06 14:31:58','',''),(3436,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,24300000.00,30000.00,0.00,0.00,'2022-08-06 14:37:45','',''),(3437,'21','220',NULL,2,'Reception corrector for bridging 381',0.00,0.00,0.00,30000.00,0.00,'2022-08-06 14:39:45','',''),(3438,'21','220','3',2,'Received from bridging 381',0.00,0.00,30000.00,0.00,0.00,'2022-08-06 14:39:45','',''),(3439,'21','220','1',1,'Sale Id shift 150',0.00,0.00,0.00,1949.99,0.00,'2022-08-06 14:43:05','',''),(3440,'21','220','1',1,'Sale Id shift 150',0.00,0.00,0.00,2010.81,0.00,'2022-08-06 14:43:05','',''),(3441,'21','220','1',1,'Sale Id shift 150',0.00,0.00,0.00,1929.88,0.00,'2022-08-06 14:43:05','',''),(3442,'21','220','1',1,'Sale Id shift 150',0.00,0.00,0.00,1622.61,0.00,'2022-08-06 14:43:05','',''),(3443,'21','220','1',1,'Sale Id shift 150',0.00,0.00,0.00,1734.85,0.00,'2022-08-06 14:43:05','',''),(3444,'21','220','2',1,'Sale Id shift 150',0.00,0.00,0.00,5284.34,0.00,'2022-08-06 14:43:05','',''),(3445,'21','220','2',1,'Sale Id shift 150',0.00,0.00,0.00,3027.36,0.00,'2022-08-06 14:43:05','',''),(3446,'21','220','2',1,'Sale Id shift 150',0.00,0.00,0.00,2967.80,0.00,'2022-08-06 14:43:05','',''),(3447,'21','220','2',1,'Sale Id shift 150',0.00,0.00,0.00,3452.85,0.00,'2022-08-06 14:43:05','',''),(3448,'21','220','1',1,'Sale Id shift 150',0.00,0.00,0.00,2483.07,0.00,'2022-08-06 14:43:05','',''),(3449,'21','220','2',1,'Sale Id shift 150',0.00,0.00,0.00,5045.82,0.00,'2022-08-06 14:43:05','',''),(3450,'21','220','2',1,'Sale Id shift 150',0.00,0.00,0.00,3170.15,0.00,'2022-08-06 14:43:05','',''),(3451,'21','220','2',1,'Sale Id shift 150',0.00,0.00,0.00,3860.10,0.00,'2022-08-06 14:43:05','',''),(3452,'21','220','2',1,'Sale Id shift 150',0.00,0.00,0.00,3147.08,0.00,'2022-08-06 14:43:05','',''),(3453,'21','220','1',1,'Sale Id shift 150',0.00,0.00,0.00,3249.24,0.00,'2022-08-06 14:43:05','',''),(3454,'21','220','3',2,'Sale Id shift 150',0.00,0.00,0.00,3605.65,0.00,'2022-08-06 14:43:05','',''),(3455,'21','220',NULL,1,'Sale Id shift 150',7863791.25,0.00,0.00,0.00,0.00,'2022-08-06 14:43:06','',''),(3456,'21','220',NULL,2,'Sale Id shift 150',2920576.50,0.00,0.00,0.00,0.00,'2022-08-06 14:43:06','',''),(3457,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-08 08:21:23','',''),(3458,'21','220',NULL,1,'Reception corrector for bridging 383',0.00,0.00,0.00,30000.00,0.00,'2022-08-08 08:25:26','',''),(3459,'21','220','2',1,'Received from bridging 383',0.00,0.00,30000.00,0.00,0.00,'2022-08-08 08:25:26','',''),(3460,'21','220',NULL,1,'Reception corrector for bridging 382',0.00,0.00,0.00,15000.00,0.00,'2022-08-08 08:25:26','',''),(3461,'21','220','1',1,'Received from bridging 382',0.00,0.00,15000.00,0.00,0.00,'2022-08-08 08:25:26','',''),(3462,'21','220','1',1,'Sale Id shift 151',0.00,0.00,0.00,1046.95,0.00,'2022-08-08 08:43:08','',''),(3463,'21','220','3',2,'Sale Id shift 151',0.00,0.00,0.00,1904.04,0.00,'2022-08-08 08:43:08','',''),(3464,'21','220','1',1,'Sale Id shift 151',0.00,0.00,0.00,947.06,0.00,'2022-08-08 08:43:08','',''),(3465,'21','220','1',1,'Sale Id shift 151',0.00,0.00,0.00,555.30,0.00,'2022-08-08 08:43:08','',''),(3466,'21','220','1',1,'Sale Id shift 151',0.00,0.00,0.00,731.84,0.00,'2022-08-08 08:43:08','',''),(3467,'21','220','1',1,'Sale Id shift 151',0.00,0.00,0.00,797.66,0.00,'2022-08-08 08:43:08','',''),(3468,'21','220','2',1,'Sale Id shift 151',0.00,0.00,0.00,993.40,0.00,'2022-08-08 08:43:08','',''),(3469,'21','220','2',1,'Sale Id shift 151',0.00,0.00,0.00,727.29,0.00,'2022-08-08 08:43:08','',''),(3470,'21','220','2',1,'Sale Id shift 151',0.00,0.00,0.00,569.77,0.00,'2022-08-08 08:43:08','',''),(3471,'21','220','2',1,'Sale Id shift 151',0.00,0.00,0.00,819.96,0.00,'2022-08-08 08:43:08','',''),(3472,'21','220','1',1,'Sale Id shift 151',0.00,0.00,0.00,806.84,0.00,'2022-08-08 08:43:08','',''),(3473,'21','220','2',1,'Sale Id shift 151',0.00,0.00,0.00,1249.54,0.00,'2022-08-08 08:43:08','',''),(3474,'21','220','2',1,'Sale Id shift 151',0.00,0.00,0.00,636.66,0.00,'2022-08-08 08:43:08','',''),(3475,'21','220','2',1,'Sale Id shift 151',0.00,0.00,0.00,1188.12,0.00,'2022-08-08 08:43:08','',''),(3476,'21','220','2',1,'Sale Id shift 151',0.00,0.00,0.00,805.62,0.00,'2022-08-08 08:43:08','',''),(3477,'21','220','1',1,'Sale Id shift 151',0.00,0.00,0.00,1109.42,0.00,'2022-08-08 08:43:08','',''),(3478,'21','220','3',2,'Sale Id shift 151',0.00,0.00,0.00,839.26,0.00,'2022-08-08 08:43:08','',''),(3479,'21','220',NULL,1,'Sale Id shift 151',2272450.25,0.00,0.00,0.00,0.00,'2022-08-08 08:43:08','',''),(3480,'21','220',NULL,2,'Sale Id shift 151',2222073.00,0.00,0.00,0.00,0.00,'2022-08-08 08:43:08','',''),(3481,'21','220','1',1,'Sale Id shift 152',0.00,0.00,0.00,1865.05,0.00,'2022-08-08 09:22:02','',''),(3482,'21','220','1',1,'Sale Id shift 152',0.00,0.00,0.00,984.36,0.00,'2022-08-08 09:22:02','',''),(3483,'21','220','1',1,'Sale Id shift 152',0.00,0.00,0.00,1704.17,0.00,'2022-08-08 09:22:02','',''),(3484,'21','220','1',1,'Sale Id shift 152',0.00,0.00,0.00,1353.44,0.00,'2022-08-08 09:22:02','',''),(3485,'21','220','1',1,'Sale Id shift 152',0.00,0.00,0.00,118.63,0.00,'2022-08-08 09:22:02','',''),(3486,'21','220','2',1,'Sale Id shift 152',0.00,0.00,0.00,3449.20,0.00,'2022-08-08 09:22:02','',''),(3487,'21','220','2',1,'Sale Id shift 152',0.00,0.00,0.00,2275.38,0.00,'2022-08-08 09:22:02','',''),(3488,'21','220','2',1,'Sale Id shift 152',0.00,0.00,0.00,1521.81,0.00,'2022-08-08 09:22:02','',''),(3489,'21','220','2',1,'Sale Id shift 152',0.00,0.00,0.00,3489.84,0.00,'2022-08-08 09:22:02','',''),(3490,'21','220','1',1,'Sale Id shift 152',0.00,0.00,0.00,1498.73,0.00,'2022-08-08 09:22:02','',''),(3491,'21','220','2',1,'Sale Id shift 152',0.00,0.00,0.00,3632.54,0.00,'2022-08-08 09:22:02','',''),(3492,'21','220','2',1,'Sale Id shift 152',0.00,0.00,0.00,2714.25,0.00,'2022-08-08 09:22:02','',''),(3493,'21','220','2',1,'Sale Id shift 152',0.00,0.00,0.00,2621.40,0.00,'2022-08-08 09:22:02','',''),(3494,'21','220','2',1,'Sale Id shift 152',0.00,0.00,0.00,2693.75,0.00,'2022-08-08 09:22:02','',''),(3495,'21','220','1',1,'Sale Id shift 152',0.00,0.00,0.00,1965.95,0.00,'2022-08-08 09:22:02','',''),(3496,'21','220','3',2,'Sale Id shift 152',0.00,0.00,0.00,1168.89,0.00,'2022-08-08 09:22:02','',''),(3497,'21','220',NULL,1,'Sale Id shift 152',5580487.50,0.00,0.00,0.00,0.00,'2022-08-08 09:22:02','',''),(3498,'21','220',NULL,2,'Sale Id shift 152',946800.90,0.00,0.00,0.00,0.00,'2022-08-08 09:22:02','',''),(3499,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-09 07:40:21','',''),(3500,'21','220',NULL,1,'Reception corrector for bridging 385',0.00,0.00,0.00,30000.00,0.00,'2022-08-09 07:42:59','',''),(3501,'21','220','2',1,'Received from bridging 385',0.00,0.00,30000.00,0.00,0.00,'2022-08-09 07:42:59','',''),(3502,'21','220',NULL,1,'Reception corrector for bridging 384',0.00,0.00,0.00,15000.00,0.00,'2022-08-09 07:42:59','',''),(3503,'21','220','1',1,'Received from bridging 384',0.00,0.00,15000.00,0.00,0.00,'2022-08-09 07:42:59','',''),(3504,'21','220','1',1,'Sale Id shift 153',0.00,0.00,0.00,998.00,0.00,'2022-08-09 12:38:28','',''),(3505,'21','220','3',2,'Sale Id shift 153',0.00,0.00,0.00,3901.22,0.00,'2022-08-09 12:38:28','',''),(3506,'21','220','1',1,'Sale Id shift 153',0.00,0.00,0.00,1261.60,0.00,'2022-08-09 12:38:28','',''),(3507,'21','220','1',1,'Sale Id shift 153',0.00,0.00,0.00,834.27,0.00,'2022-08-09 12:38:28','',''),(3508,'21','220','1',1,'Sale Id shift 153',0.00,0.00,0.00,1051.90,0.00,'2022-08-09 12:38:28','',''),(3509,'21','220','1',1,'Sale Id shift 153',0.00,0.00,0.00,805.19,0.00,'2022-08-09 12:38:28','',''),(3510,'21','220','2',1,'Sale Id shift 153',0.00,0.00,0.00,1022.68,0.00,'2022-08-09 12:38:28','',''),(3511,'21','220','2',1,'Sale Id shift 153',0.00,0.00,0.00,321.16,0.00,'2022-08-09 12:38:28','',''),(3512,'21','220','2',1,'Sale Id shift 153',0.00,0.00,0.00,1140.58,0.00,'2022-08-09 12:38:28','',''),(3513,'21','220','1',1,'Sale Id shift 153',0.00,0.00,0.00,830.27,0.00,'2022-08-09 12:38:28','',''),(3514,'21','220','2',1,'Sale Id shift 153',0.00,0.00,0.00,1123.66,0.00,'2022-08-09 12:38:28','',''),(3515,'21','220','2',1,'Sale Id shift 153',0.00,0.00,0.00,904.28,0.00,'2022-08-09 12:38:28','',''),(3516,'21','220','2',1,'Sale Id shift 153',0.00,0.00,0.00,863.51,0.00,'2022-08-09 12:38:28','',''),(3517,'21','220','2',1,'Sale Id shift 153',0.00,0.00,0.00,872.54,0.00,'2022-08-09 12:38:28','',''),(3518,'21','220','1',1,'Sale Id shift 153',0.00,0.00,0.00,1310.42,0.00,'2022-08-09 12:38:28','',''),(3519,'21','220',NULL,1,'Sale Id shift 153',2334510.50,0.00,0.00,0.00,0.00,'2022-08-09 12:38:28','',''),(3520,'21','220',NULL,2,'Sale Id shift 153',3159988.20,0.00,0.00,0.00,0.00,'2022-08-09 12:38:28','',''),(3521,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-10 07:07:00','',''),(3522,'21','220',NULL,1,'Reception corrector for bridging 387',0.00,0.00,0.00,30000.00,0.00,'2022-08-10 07:10:01','',''),(3523,'21','220','2',1,'Received from bridging 387',0.00,0.00,30000.00,0.00,0.00,'2022-08-10 07:10:01','',''),(3524,'21','220',NULL,1,'Reception corrector for bridging 386',0.00,0.00,0.00,15000.00,0.00,'2022-08-10 07:10:01','',''),(3525,'21','220','1',1,'Received from bridging 386',0.00,0.00,15000.00,0.00,0.00,'2022-08-10 07:10:01','',''),(3526,'21','220','1',1,'Sale Id shift 154',0.00,0.00,0.00,2066.54,0.00,'2022-08-10 07:48:47','',''),(3527,'21','220','3',2,'Sale Id shift 154',0.00,0.00,0.00,1887.53,0.00,'2022-08-10 07:48:47','',''),(3528,'21','220','1',1,'Sale Id shift 154',0.00,0.00,0.00,1744.31,0.00,'2022-08-10 07:48:47','',''),(3529,'21','220','1',1,'Sale Id shift 154',0.00,0.00,0.00,572.48,0.00,'2022-08-10 07:48:47','',''),(3530,'21','220','1',1,'Sale Id shift 154',0.00,0.00,0.00,1620.06,0.00,'2022-08-10 07:48:47','',''),(3531,'21','220','1',1,'Sale Id shift 154',0.00,0.00,0.00,1985.80,0.00,'2022-08-10 07:48:47','',''),(3532,'21','220','2',1,'Sale Id shift 154',0.00,0.00,0.00,3817.04,0.00,'2022-08-10 07:48:47','',''),(3533,'21','220','2',1,'Sale Id shift 154',0.00,0.00,0.00,2754.72,0.00,'2022-08-10 07:48:47','',''),(3534,'21','220','2',1,'Sale Id shift 154',0.00,0.00,0.00,3467.32,0.00,'2022-08-10 07:48:47','',''),(3535,'21','220','2',1,'Sale Id shift 154',0.00,0.00,0.00,3497.31,0.00,'2022-08-10 07:48:47','',''),(3536,'21','220','1',1,'Sale Id shift 154',0.00,0.00,0.00,1703.02,0.00,'2022-08-10 07:48:47','',''),(3537,'21','220','2',1,'Sale Id shift 154',0.00,0.00,0.00,4869.61,0.00,'2022-08-10 07:48:47','',''),(3538,'21','220','2',1,'Sale Id shift 154',0.00,0.00,0.00,2575.68,0.00,'2022-08-10 07:48:47','',''),(3539,'21','220','2',1,'Sale Id shift 154',0.00,0.00,0.00,3789.77,0.00,'2022-08-10 07:48:47','',''),(3540,'21','220','2',1,'Sale Id shift 154',0.00,0.00,0.00,3421.25,0.00,'2022-08-10 07:48:47','',''),(3541,'21','220','1',1,'Sale Id shift 154',0.00,0.00,0.00,2206.79,0.00,'2022-08-10 07:48:47','',''),(3542,'21','220','3',2,'Sale Id shift 154',0.00,0.00,0.00,1774.42,0.00,'2022-08-10 07:48:47','',''),(3543,'21','220',NULL,1,'Sale Id shift 154',7016047.50,0.00,0.00,0.00,0.00,'2022-08-10 07:48:47','',''),(3544,'21','220',NULL,2,'Sale Id shift 154',2966179.50,0.00,0.00,0.00,0.00,'2022-08-10 07:48:47','',''),(3545,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-11 07:05:48','',''),(3546,'21','220',NULL,1,'Reception corrector for bridging 389',0.00,0.00,0.00,30000.00,0.00,'2022-08-11 07:07:59','',''),(3547,'21','220','2',1,'Received from bridging 389',0.00,0.00,30000.00,0.00,0.00,'2022-08-11 07:07:59','',''),(3548,'21','220',NULL,1,'Reception corrector for bridging 388',0.00,0.00,0.00,15000.00,0.00,'2022-08-11 07:07:59','',''),(3549,'21','220','1',1,'Received from bridging 388',0.00,0.00,15000.00,0.00,0.00,'2022-08-11 07:07:59','',''),(3550,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,12150000.00,15000.00,0.00,0.00,'2022-08-11 07:09:35','',''),(3551,'21','220',NULL,2,'Reception corrector for bridging 390',0.00,0.00,0.00,15000.00,0.00,'2022-08-11 07:11:13','',''),(3552,'21','220','3',2,'Received from bridging 390',0.00,0.00,15000.00,0.00,0.00,'2022-08-11 07:11:13','',''),(3553,'21','220','1',1,'Sale Id shift 155',0.00,0.00,0.00,3103.72,0.00,'2022-08-11 07:38:40','',''),(3554,'21','220','3',2,'Sale Id shift 155',0.00,0.00,0.00,2941.42,0.00,'2022-08-11 07:38:40','',''),(3555,'21','220','1',1,'Sale Id shift 155',0.00,0.00,0.00,1306.55,0.00,'2022-08-11 07:38:40','',''),(3556,'21','220','1',1,'Sale Id shift 155',0.00,0.00,0.00,2477.00,0.00,'2022-08-11 07:38:40','',''),(3557,'21','220','1',1,'Sale Id shift 155',0.00,0.00,0.00,2321.90,0.00,'2022-08-11 07:38:40','',''),(3558,'21','220','1',1,'Sale Id shift 155',0.00,0.00,0.00,1855.73,0.00,'2022-08-11 07:38:40','',''),(3559,'21','220','2',1,'Sale Id shift 155',0.00,0.00,0.00,5153.10,0.00,'2022-08-11 07:38:40','',''),(3560,'21','220','2',1,'Sale Id shift 155',0.00,0.00,0.00,3812.39,0.00,'2022-08-11 07:38:40','',''),(3561,'21','220','2',1,'Sale Id shift 155',0.00,0.00,0.00,3383.29,0.00,'2022-08-11 07:38:40','',''),(3562,'21','220','2',1,'Sale Id shift 155',0.00,0.00,0.00,3691.50,0.00,'2022-08-11 07:38:40','',''),(3563,'21','220','1',1,'Sale Id shift 155',0.00,0.00,0.00,2197.17,0.00,'2022-08-11 07:38:40','',''),(3564,'21','220','2',1,'Sale Id shift 155',0.00,0.00,0.00,6453.03,0.00,'2022-08-11 07:38:40','',''),(3565,'21','220','2',1,'Sale Id shift 155',0.00,0.00,0.00,3975.59,0.00,'2022-08-11 07:38:40','',''),(3566,'21','220','2',1,'Sale Id shift 155',0.00,0.00,0.00,4170.30,0.00,'2022-08-11 07:38:40','',''),(3567,'21','220','2',1,'Sale Id shift 155',0.00,0.00,0.00,4215.33,0.00,'2022-08-11 07:38:40','',''),(3568,'21','220','1',1,'Sale Id shift 155',0.00,0.00,0.00,3496.79,0.00,'2022-08-11 07:38:40','',''),(3569,'21','220','3',2,'Sale Id shift 155',0.00,0.00,0.00,2094.02,0.00,'2022-08-11 07:38:40','',''),(3570,'21','220',NULL,1,'Sale Id shift 155',9032343.25,0.00,0.00,0.00,0.00,'2022-08-11 07:38:40','',''),(3571,'21','220',NULL,2,'Sale Id shift 155',4078706.40,0.00,0.00,0.00,0.00,'2022-08-11 07:38:40','',''),(3572,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-12 06:25:27','',''),(3573,'21','220',NULL,1,'Returned purchase #202 to AYM SHAFA NIGERIA LIMITED',7875000.00,0.00,0.00,45000.00,0.00,'2022-08-12 06:33:29','',''),(3574,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7000000.00,40000.00,0.00,0.00,'2022-08-12 06:36:19','',''),(3575,'21','220',NULL,1,'Reception corrector for bridging 392',0.00,0.00,0.00,26500.00,0.00,'2022-08-12 06:40:46','',''),(3576,'21','220','2',1,'Received from bridging 392',0.00,0.00,26500.00,0.00,0.00,'2022-08-12 06:40:46','',''),(3577,'21','220',NULL,1,'Reception corrector for bridging 391',0.00,0.00,0.00,13500.00,0.00,'2022-08-12 06:40:46','',''),(3578,'21','220','1',1,'Received from bridging 391',0.00,0.00,13500.00,0.00,0.00,'2022-08-12 06:40:46','',''),(3579,'21','220','1',1,'Sale Id shift 156',0.00,0.00,0.00,2413.24,0.00,'2022-08-12 08:12:55','',''),(3580,'21','220','3',2,'Sale Id shift 156',0.00,0.00,0.00,4267.04,0.00,'2022-08-12 08:12:55','',''),(3581,'21','220','1',1,'Sale Id shift 156',0.00,0.00,0.00,1776.50,0.00,'2022-08-12 08:12:55','',''),(3582,'21','220','1',1,'Sale Id shift 156',0.00,0.00,0.00,1403.32,0.00,'2022-08-12 08:12:55','',''),(3583,'21','220','1',1,'Sale Id shift 156',0.00,0.00,0.00,1691.98,0.00,'2022-08-12 08:12:55','',''),(3584,'21','220','1',1,'Sale Id shift 156',0.00,0.00,0.00,1434.02,0.00,'2022-08-12 08:12:55','',''),(3585,'21','220','2',1,'Sale Id shift 156',0.00,0.00,0.00,4817.27,0.00,'2022-08-12 08:12:55','',''),(3586,'21','220','2',1,'Sale Id shift 156',0.00,0.00,0.00,2941.12,0.00,'2022-08-12 08:12:55','',''),(3587,'21','220','2',1,'Sale Id shift 156',0.00,0.00,0.00,3939.39,0.00,'2022-08-12 08:12:55','',''),(3588,'21','220','2',1,'Sale Id shift 156',0.00,0.00,0.00,2300.39,0.00,'2022-08-12 08:12:55','',''),(3589,'21','220','1',1,'Sale Id shift 156',0.00,0.00,0.00,2345.05,0.00,'2022-08-12 08:12:55','',''),(3590,'21','220','2',1,'Sale Id shift 156',0.00,0.00,0.00,4095.71,0.00,'2022-08-12 08:12:55','',''),(3591,'21','220','2',1,'Sale Id shift 156',0.00,0.00,0.00,3445.64,0.00,'2022-08-12 08:12:55','',''),(3592,'21','220','2',1,'Sale Id shift 156',0.00,0.00,0.00,3251.21,0.00,'2022-08-12 08:12:55','',''),(3593,'21','220','2',1,'Sale Id shift 156',0.00,0.00,0.00,3442.14,0.00,'2022-08-12 08:12:55','',''),(3594,'21','220','1',1,'Sale Id shift 156',0.00,0.00,0.00,3320.76,0.00,'2022-08-12 08:12:55','',''),(3595,'21','220','3',2,'Sale Id shift 156',0.00,0.00,0.00,1692.80,0.00,'2022-08-12 08:12:55','',''),(3596,'21','220',NULL,1,'Sale Id shift 156',7458104.50,0.00,0.00,0.00,0.00,'2022-08-12 08:12:55','',''),(3597,'21','220',NULL,2,'Sale Id shift 156',4827470.40,0.00,0.00,0.00,0.00,'2022-08-12 08:12:55','',''),(3598,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7000000.00,40000.00,0.00,0.00,'2022-08-13 07:19:58','',''),(3599,'21','220',NULL,1,'Reception corrector for bridging 394',0.00,0.00,0.00,26500.00,0.00,'2022-08-13 07:24:01','',''),(3600,'21','220','2',1,'Received from bridging 394',0.00,0.00,26500.00,0.00,0.00,'2022-08-13 07:24:01','',''),(3601,'21','220',NULL,1,'Reception corrector for bridging 393',0.00,0.00,0.00,13500.00,0.00,'2022-08-13 07:24:01','',''),(3602,'21','220','1',1,'Received from bridging 393',0.00,0.00,13500.00,0.00,0.00,'2022-08-13 07:24:01','',''),(3603,'21','220',NULL,3,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,25500000.00,30000.00,0.00,0.00,'2022-08-13 07:26:23','',''),(3604,'21','220',NULL,3,'Reception corrector for bridging 395',0.00,0.00,0.00,30000.00,0.00,'2022-08-13 07:30:47','',''),(3605,'21','220','4',3,'Received from bridging 395',0.00,0.00,30000.00,0.00,0.00,'2022-08-13 07:30:47','',''),(3606,'21','220','1',1,'Sale Id shift 157',0.00,0.00,0.00,2344.92,0.00,'2022-08-13 10:21:06','',''),(3607,'21','220','3',2,'Sale Id shift 157',0.00,0.00,0.00,1270.97,0.00,'2022-08-13 10:21:06','',''),(3608,'21','220','1',1,'Sale Id shift 157',0.00,0.00,0.00,2620.99,0.00,'2022-08-13 10:21:06','',''),(3609,'21','220','1',1,'Sale Id shift 157',0.00,0.00,0.00,1841.00,0.00,'2022-08-13 10:21:06','',''),(3610,'21','220','1',1,'Sale Id shift 157',0.00,0.00,0.00,1643.75,0.00,'2022-08-13 10:21:06','',''),(3611,'21','220','2',1,'Sale Id shift 157',0.00,0.00,0.00,4141.88,0.00,'2022-08-13 10:21:06','',''),(3612,'21','220','2',1,'Sale Id shift 157',0.00,0.00,0.00,3170.31,0.00,'2022-08-13 10:21:06','',''),(3613,'21','220','2',1,'Sale Id shift 157',0.00,0.00,0.00,3028.18,0.00,'2022-08-13 10:21:06','',''),(3614,'21','220','2',1,'Sale Id shift 157',0.00,0.00,0.00,3416.21,0.00,'2022-08-13 10:21:06','',''),(3615,'21','220','1',1,'Sale Id shift 157',0.00,0.00,0.00,2086.38,0.00,'2022-08-13 10:21:06','',''),(3616,'21','220','2',1,'Sale Id shift 157',0.00,0.00,0.00,4271.96,0.00,'2022-08-13 10:21:06','',''),(3617,'21','220','2',1,'Sale Id shift 157',0.00,0.00,0.00,3187.26,0.00,'2022-08-13 10:21:06','',''),(3618,'21','220','2',1,'Sale Id shift 157',0.00,0.00,0.00,3252.74,0.00,'2022-08-13 10:21:06','',''),(3619,'21','220','2',1,'Sale Id shift 157',0.00,0.00,0.00,3876.87,0.00,'2022-08-13 10:21:06','',''),(3620,'21','220','1',1,'Sale Id shift 157',0.00,0.00,0.00,3716.21,0.00,'2022-08-13 10:21:06','',''),(3621,'21','220','3',2,'Sale Id shift 157',0.00,0.00,0.00,845.25,0.00,'2022-08-13 10:21:06','',''),(3622,'21','220',NULL,1,'Sale Id shift 157',7454765.50,0.00,0.00,0.00,0.00,'2022-08-13 10:21:06','',''),(3623,'21','220',NULL,2,'Sale Id shift 157',1714138.20,0.00,0.00,0.00,0.00,'2022-08-13 10:21:06','',''),(3624,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,8750000.00,50000.00,0.00,0.00,'2022-08-15 15:40:31','',''),(3625,'21','220',NULL,1,'Reception corrector for bridging 397',0.00,0.00,0.00,33000.00,0.00,'2022-08-15 15:42:47','',''),(3626,'21','220','2',1,'Received from bridging 397',0.00,0.00,33000.00,0.00,0.00,'2022-08-15 15:42:47','',''),(3627,'21','220',NULL,1,'Reception corrector for bridging 396',0.00,0.00,0.00,17000.00,0.00,'2022-08-15 15:42:47','',''),(3628,'21','220','1',1,'Received from bridging 396',0.00,0.00,17000.00,0.00,0.00,'2022-08-15 15:42:47','',''),(3629,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,12150000.00,15000.00,0.00,0.00,'2022-08-15 15:49:20','',''),(3630,'21','220',NULL,2,'Reception corrector for bridging 398',0.00,0.00,0.00,15000.00,0.00,'2022-08-15 15:50:09','',''),(3631,'21','220','3',2,'Received from bridging 398',0.00,0.00,15000.00,0.00,0.00,'2022-08-15 15:50:09','',''),(3632,'21','220','1',1,'Sale Id shift 158',0.00,0.00,0.00,1049.11,0.00,'2022-08-15 17:21:10','',''),(3633,'21','220','3',2,'Sale Id shift 158',0.00,0.00,0.00,2078.51,0.00,'2022-08-15 17:21:10','',''),(3634,'21','220','4',3,'Sale Id shift 158',0.00,0.00,0.00,548.04,0.00,'2022-08-15 17:21:10','',''),(3635,'21','220','1',1,'Sale Id shift 158',0.00,0.00,0.00,2.21,0.00,'2022-08-15 17:21:10','',''),(3636,'21','220','1',1,'Sale Id shift 158',0.00,0.00,0.00,1268.46,0.00,'2022-08-15 17:21:10','',''),(3637,'21','220','1',1,'Sale Id shift 158',0.00,0.00,0.00,876.79,0.00,'2022-08-15 17:21:10','',''),(3638,'21','220','1',1,'Sale Id shift 158',0.00,0.00,0.00,808.12,0.00,'2022-08-15 17:21:10','',''),(3639,'21','220','2',1,'Sale Id shift 158',0.00,0.00,0.00,2368.10,0.00,'2022-08-15 17:21:10','',''),(3640,'21','220','2',1,'Sale Id shift 158',0.00,0.00,0.00,2211.20,0.00,'2022-08-15 17:21:10','',''),(3641,'21','220','2',1,'Sale Id shift 158',0.00,0.00,0.00,2404.78,0.00,'2022-08-15 17:21:10','',''),(3642,'21','220','2',1,'Sale Id shift 158',0.00,0.00,0.00,2474.29,0.00,'2022-08-15 17:21:10','',''),(3643,'21','220','1',1,'Sale Id shift 158',0.00,0.00,0.00,777.14,0.00,'2022-08-15 17:21:10','',''),(3644,'21','220','2',1,'Sale Id shift 158',0.00,0.00,0.00,3143.03,0.00,'2022-08-15 17:21:10','',''),(3645,'21','220','2',1,'Sale Id shift 158',0.00,0.00,0.00,1923.70,0.00,'2022-08-15 17:21:10','',''),(3646,'21','220','2',1,'Sale Id shift 158',0.00,0.00,0.00,1794.76,0.00,'2022-08-15 17:21:10','',''),(3647,'21','220','2',1,'Sale Id shift 158',0.00,0.00,0.00,1946.24,0.00,'2022-08-15 17:21:10','',''),(3648,'21','220','1',1,'Sale Id shift 158',0.00,0.00,0.00,1449.23,0.00,'2022-08-15 17:21:10','',''),(3649,'21','220','3',2,'Sale Id shift 158',0.00,0.00,0.00,271.01,0.00,'2022-08-15 17:21:10','',''),(3650,'21','220',NULL,2,'Sale Id shift 158',1903111.20,0.00,0.00,0.00,0.00,'2022-08-15 17:21:10','',''),(3651,'21','220',NULL,3,'Sale Id shift 158',465834.00,0.00,0.00,0.00,0.00,'2022-08-15 17:21:10','',''),(3652,'21','220',NULL,1,'Sale Id shift 158',4287003.00,0.00,0.00,0.00,0.00,'2022-08-15 17:21:10','',''),(3653,'21','220','3',2,'Sale Id shift 159',0.00,0.00,0.00,1056.06,0.00,'2022-08-16 12:09:56','',''),(3654,'21','220','4',3,'Sale Id shift 159',0.00,0.00,0.00,635.09,0.00,'2022-08-16 12:09:56','',''),(3655,'21','220','1',1,'Sale Id shift 159',0.00,0.00,0.00,34.29,0.00,'2022-08-16 12:09:56','',''),(3656,'21','220',NULL,1,'Sale Id shift 159',6000.75,0.00,0.00,0.00,0.00,'2022-08-16 12:09:56','',''),(3657,'21','220',NULL,2,'Sale Id shift 159',855408.60,0.00,0.00,0.00,0.00,'2022-08-16 12:09:56','',''),(3658,'21','220',NULL,3,'Sale Id shift 159',539826.50,0.00,0.00,0.00,0.00,'2022-08-16 12:09:56','',''),(3659,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-17 10:59:40','',''),(3660,'21','220',NULL,1,'Reception corrector for bridging 400',0.00,0.00,0.00,30000.00,0.00,'2022-08-17 11:01:55','',''),(3661,'21','220','2',1,'Received from bridging 400',0.00,0.00,30000.00,0.00,0.00,'2022-08-17 11:01:55','',''),(3662,'21','220',NULL,1,'Reception corrector for bridging 399',0.00,0.00,0.00,15000.00,0.00,'2022-08-17 11:01:55','',''),(3663,'21','220','1',1,'Received from bridging 399',0.00,0.00,15000.00,0.00,0.00,'2022-08-17 11:01:55','',''),(3664,'21','220','1',1,'Sale Id shift 160',0.00,0.00,0.00,2921.23,0.00,'2022-08-17 12:43:55','',''),(3665,'21','220','3',2,'Sale Id shift 160',0.00,0.00,0.00,1364.32,0.00,'2022-08-17 12:43:55','',''),(3666,'21','220','4',3,'Sale Id shift 160',0.00,0.00,0.00,564.62,0.00,'2022-08-17 12:43:55','',''),(3667,'21','220','1',1,'Sale Id shift 160',0.00,0.00,0.00,0.44,0.00,'2022-08-17 12:43:55','',''),(3668,'21','220','1',1,'Sale Id shift 160',0.00,0.00,0.00,2993.82,0.00,'2022-08-17 12:43:55','',''),(3669,'21','220','1',1,'Sale Id shift 160',0.00,0.00,0.00,3147.51,0.00,'2022-08-17 12:43:55','',''),(3670,'21','220','1',1,'Sale Id shift 160',0.00,0.00,0.00,1905.99,0.00,'2022-08-17 12:43:55','',''),(3671,'21','220','2',1,'Sale Id shift 160',0.00,0.00,0.00,4277.36,0.00,'2022-08-17 12:43:55','',''),(3672,'21','220','2',1,'Sale Id shift 160',0.00,0.00,0.00,3322.63,0.00,'2022-08-17 12:43:55','',''),(3673,'21','220','2',1,'Sale Id shift 160',0.00,0.00,0.00,3638.14,0.00,'2022-08-17 12:43:55','',''),(3674,'21','220','2',1,'Sale Id shift 160',0.00,0.00,0.00,3672.47,0.00,'2022-08-17 12:43:55','',''),(3675,'21','220','1',1,'Sale Id shift 160',0.00,0.00,0.00,2623.29,0.00,'2022-08-17 12:43:55','',''),(3676,'21','220','2',1,'Sale Id shift 160',0.00,0.00,0.00,5453.77,0.00,'2022-08-17 12:43:55','',''),(3677,'21','220','2',1,'Sale Id shift 160',0.00,0.00,0.00,4020.10,0.00,'2022-08-17 12:43:55','',''),(3678,'21','220','2',1,'Sale Id shift 160',0.00,0.00,0.00,4365.17,0.00,'2022-08-17 12:43:55','',''),(3679,'21','220','2',1,'Sale Id shift 160',0.00,0.00,0.00,4088.14,0.00,'2022-08-17 12:43:55','',''),(3680,'21','220','1',1,'Sale Id shift 160',0.00,0.00,0.00,3927.56,0.00,'2022-08-17 12:43:55','',''),(3681,'21','220','3',2,'Sale Id shift 160',0.00,0.00,0.00,3275.58,0.00,'2022-08-17 12:43:55','',''),(3682,'21','220',NULL,1,'Sale Id shift 160',8812583.50,0.00,0.00,0.00,0.00,'2022-08-17 12:43:55','',''),(3683,'21','220',NULL,2,'Sale Id shift 160',3758319.00,0.00,0.00,0.00,0.00,'2022-08-17 12:43:55','',''),(3684,'21','220',NULL,3,'Sale Id shift 160',479927.00,0.00,0.00,0.00,0.00,'2022-08-17 12:43:55','',''),(3685,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7875000.00,45000.00,0.00,0.00,'2022-08-17 14:02:03','',''),(3686,'21','220',NULL,1,'Reception corrector for bridging 402',0.00,0.00,0.00,29000.00,0.00,'2022-08-17 14:09:51','',''),(3687,'21','220','2',1,'Received from bridging 402',0.00,0.00,29000.00,0.00,0.00,'2022-08-17 14:09:51','',''),(3688,'21','220',NULL,1,'Reception corrector for bridging 401',0.00,0.00,0.00,16000.00,0.00,'2022-08-17 14:09:51','',''),(3689,'21','220','1',1,'Received from bridging 401',0.00,0.00,16000.00,0.00,0.00,'2022-08-17 14:09:51','',''),(3690,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,5250000.00,30000.00,0.00,0.00,'2022-08-18 09:23:05','',''),(3691,'21','220','1',1,'Sale Id shift 161',0.00,0.00,0.00,2648.35,0.00,'2022-08-18 09:45:18','',''),(3692,'21','220','3',2,'Sale Id shift 161',0.00,0.00,0.00,894.45,0.00,'2022-08-18 09:45:18','',''),(3693,'21','220','4',3,'Sale Id shift 161',0.00,0.00,0.00,687.99,0.00,'2022-08-18 09:45:18','',''),(3694,'21','220','1',1,'Sale Id shift 161',0.00,0.00,0.00,3195.88,0.00,'2022-08-18 09:45:18','',''),(3695,'21','220','1',1,'Sale Id shift 161',0.00,0.00,0.00,2442.85,0.00,'2022-08-18 09:45:18','',''),(3696,'21','220','1',1,'Sale Id shift 161',0.00,0.00,0.00,1620.23,0.00,'2022-08-18 09:45:18','',''),(3697,'21','220','2',1,'Sale Id shift 161',0.00,0.00,0.00,4229.06,0.00,'2022-08-18 09:45:18','',''),(3698,'21','220','2',1,'Sale Id shift 161',0.00,0.00,0.00,2667.84,0.00,'2022-08-18 09:45:18','',''),(3699,'21','220','2',1,'Sale Id shift 161',0.00,0.00,0.00,3503.83,0.00,'2022-08-18 09:45:18','',''),(3700,'21','220','2',1,'Sale Id shift 161',0.00,0.00,0.00,3503.81,0.00,'2022-08-18 09:45:18','',''),(3701,'21','220','1',1,'Sale Id shift 161',0.00,0.00,0.00,1955.30,0.00,'2022-08-18 09:45:18','',''),(3702,'21','220','2',1,'Sale Id shift 161',0.00,0.00,0.00,4956.25,0.00,'2022-08-18 09:45:18','',''),(3703,'21','220','2',1,'Sale Id shift 161',0.00,0.00,0.00,3775.39,0.00,'2022-08-18 09:45:18','',''),(3704,'21','220','2',1,'Sale Id shift 161',0.00,0.00,0.00,3774.03,0.00,'2022-08-18 09:45:18','',''),(3705,'21','220','2',1,'Sale Id shift 161',0.00,0.00,0.00,2827.44,0.00,'2022-08-18 09:45:18','',''),(3706,'21','220','1',1,'Sale Id shift 161',0.00,0.00,0.00,3247.90,0.00,'2022-08-18 09:45:18','',''),(3707,'21','220','3',2,'Sale Id shift 161',0.00,0.00,0.00,955.04,0.00,'2022-08-18 09:45:18','',''),(3708,'21','220',NULL,1,'Sale Id shift 161',7760928.00,0.00,0.00,0.00,0.00,'2022-08-18 09:45:18','',''),(3709,'21','220',NULL,2,'Sale Id shift 161',1498086.90,0.00,0.00,0.00,0.00,'2022-08-18 09:45:18','',''),(3710,'21','220',NULL,3,'Sale Id shift 161',584791.50,0.00,0.00,0.00,0.00,'2022-08-18 09:45:18','',''),(3711,'21','220',NULL,1,'Reception corrector for bridging 403',0.00,0.00,0.00,30000.00,0.00,'2022-08-18 09:57:56','',''),(3712,'21','220','2',1,'Received from bridging 403',0.00,0.00,30000.00,0.00,0.00,'2022-08-18 09:57:56','',''),(3713,'21','220','1',1,'Sale Id shift 162',0.00,0.00,0.00,2292.00,0.00,'2022-08-18 10:34:48','',''),(3714,'21','220','3',2,'Sale Id shift 162',0.00,0.00,0.00,4224.73,0.00,'2022-08-18 10:34:48','',''),(3715,'21','220','4',3,'Sale Id shift 162',0.00,0.00,0.00,636.01,0.00,'2022-08-18 10:34:48','',''),(3716,'21','220','1',1,'Sale Id shift 162',0.00,0.00,0.00,41.62,0.00,'2022-08-18 10:34:48','',''),(3717,'21','220','1',1,'Sale Id shift 162',0.00,0.00,0.00,3066.02,0.00,'2022-08-18 10:34:48','',''),(3718,'21','220','1',1,'Sale Id shift 162',0.00,0.00,0.00,3334.73,0.00,'2022-08-18 10:34:48','',''),(3719,'21','220','2',1,'Sale Id shift 162',0.00,0.00,0.00,5018.21,0.00,'2022-08-18 10:34:48','',''),(3720,'21','220','2',1,'Sale Id shift 162',0.00,0.00,0.00,3600.09,0.00,'2022-08-18 10:34:48','',''),(3721,'21','220','2',1,'Sale Id shift 162',0.00,0.00,0.00,4328.20,0.00,'2022-08-18 10:34:48','',''),(3722,'21','220','2',1,'Sale Id shift 162',0.00,0.00,0.00,3765.37,0.00,'2022-08-18 10:34:48','',''),(3723,'21','220','1',1,'Sale Id shift 162',0.00,0.00,0.00,2259.60,0.00,'2022-08-18 10:34:48','',''),(3724,'21','220','2',1,'Sale Id shift 162',0.00,0.00,0.00,5854.14,0.00,'2022-08-18 10:34:48','',''),(3725,'21','220','2',1,'Sale Id shift 162',0.00,0.00,0.00,3753.74,0.00,'2022-08-18 10:34:48','',''),(3726,'21','220','2',1,'Sale Id shift 162',0.00,0.00,0.00,5431.49,0.00,'2022-08-18 10:34:48','',''),(3727,'21','220','2',1,'Sale Id shift 162',0.00,0.00,0.00,4780.52,0.00,'2022-08-18 10:34:48','',''),(3728,'21','220','4',3,'Sale Id shift 162',0.00,0.00,0.00,13.40,0.00,'2022-08-18 10:34:48','',''),(3729,'21','220','1',1,'Sale Id shift 162',0.00,0.00,0.00,3665.88,0.00,'2022-08-18 10:34:48','',''),(3730,'21','220','3',2,'Sale Id shift 162',0.00,0.00,0.00,2570.45,0.00,'2022-08-18 10:34:48','',''),(3731,'21','220',NULL,1,'Sale Id shift 162',8958531.75,0.00,0.00,0.00,0.00,'2022-08-18 10:34:48','',''),(3732,'21','220',NULL,2,'Sale Id shift 162',5504095.80,0.00,0.00,0.00,0.00,'2022-08-18 10:34:48','',''),(3733,'21','220',NULL,3,'Sale Id shift 162',551998.50,0.00,0.00,0.00,0.00,'2022-08-18 10:34:48','',''),(3734,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7000000.00,40000.00,0.00,0.00,'2022-08-19 07:36:48','',''),(3735,'21','220',NULL,1,'Reception corrector for bridging 405',0.00,0.00,0.00,26500.00,0.00,'2022-08-19 07:40:17','',''),(3736,'21','220','2',1,'Received from bridging 405',0.00,0.00,26500.00,0.00,0.00,'2022-08-19 07:40:17','',''),(3737,'21','220',NULL,1,'Reception corrector for bridging 404',0.00,0.00,0.00,13500.00,0.00,'2022-08-19 07:40:17','',''),(3738,'21','220','1',1,'Received from bridging 404',0.00,0.00,13500.00,0.00,0.00,'2022-08-19 07:40:17','',''),(3739,'21','220',NULL,2,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,24000000.00,30000.00,0.00,0.00,'2022-08-20 10:12:22','',''),(3740,'21','220','1',1,'Sale Id shift 163',0.00,0.00,0.00,865.87,0.00,'2022-08-20 10:38:31','',''),(3741,'21','220','3',2,'Sale Id shift 163',0.00,0.00,0.00,6324.21,0.00,'2022-08-20 10:38:31','',''),(3742,'21','220','4',3,'Sale Id shift 163',0.00,0.00,0.00,743.04,0.00,'2022-08-20 10:38:31','',''),(3743,'21','220','1',1,'Sale Id shift 163',0.00,0.00,0.00,327.28,0.00,'2022-08-20 10:38:31','',''),(3744,'21','220','1',1,'Sale Id shift 163',0.00,0.00,0.00,616.75,0.00,'2022-08-20 10:38:31','',''),(3745,'21','220','1',1,'Sale Id shift 163',0.00,0.00,0.00,224.19,0.00,'2022-08-20 10:38:31','',''),(3746,'21','220','2',1,'Sale Id shift 163',0.00,0.00,0.00,4008.76,0.00,'2022-08-20 10:38:31','',''),(3747,'21','220','2',1,'Sale Id shift 163',0.00,0.00,0.00,2959.36,0.00,'2022-08-20 10:38:31','',''),(3748,'21','220','2',1,'Sale Id shift 163',0.00,0.00,0.00,3492.31,0.00,'2022-08-20 10:38:31','',''),(3749,'21','220','2',1,'Sale Id shift 163',0.00,0.00,0.00,3072.89,0.00,'2022-08-20 10:38:31','',''),(3750,'21','220','1',1,'Sale Id shift 163',0.00,0.00,0.00,602.06,0.00,'2022-08-20 10:38:31','',''),(3751,'21','220','2',1,'Sale Id shift 163',0.00,0.00,0.00,4340.93,0.00,'2022-08-20 10:38:31','',''),(3752,'21','220','2',1,'Sale Id shift 163',0.00,0.00,0.00,2492.95,0.00,'2022-08-20 10:38:31','',''),(3753,'21','220','2',1,'Sale Id shift 163',0.00,0.00,0.00,3495.70,0.00,'2022-08-20 10:38:31','',''),(3754,'21','220','2',1,'Sale Id shift 163',0.00,0.00,0.00,3050.31,0.00,'2022-08-20 10:38:31','',''),(3755,'21','220','1',1,'Sale Id shift 163',0.00,0.00,0.00,1736.57,0.00,'2022-08-20 10:38:31','',''),(3756,'21','220','3',2,'Sale Id shift 163',0.00,0.00,0.00,3447.45,0.00,'2022-08-20 10:38:31','',''),(3757,'21','220',NULL,1,'Sale Id shift 163',5475037.75,0.00,0.00,0.00,0.00,'2022-08-20 10:38:31','',''),(3758,'21','220',NULL,2,'Sale Id shift 163',7817328.00,0.00,0.00,0.00,0.00,'2022-08-20 10:38:31','',''),(3759,'21','220',NULL,3,'Sale Id shift 163',639014.40,0.00,0.00,0.00,0.00,'2022-08-20 10:38:31','',''),(3760,'21','220',NULL,2,'Reception corrector for bridging 407',0.00,0.00,0.00,30000.00,0.00,'2022-08-20 10:40:32','',''),(3761,'21','220','3',2,'Received from bridging 407',0.00,0.00,30000.00,0.00,0.00,'2022-08-20 10:40:32','',''),(3762,'21','220','1',1,'Sale Id shift 164',0.00,0.00,0.00,1963.31,0.00,'2022-08-20 11:06:44','',''),(3763,'21','220','3',2,'Sale Id shift 164',0.00,0.00,0.00,1209.15,0.00,'2022-08-20 11:06:44','',''),(3764,'21','220','4',3,'Sale Id shift 164',0.00,0.00,0.00,489.71,0.00,'2022-08-20 11:06:44','',''),(3765,'21','220','1',1,'Sale Id shift 164',0.00,0.00,0.00,1654.51,0.00,'2022-08-20 11:06:44','',''),(3766,'21','220','1',1,'Sale Id shift 164',0.00,0.00,0.00,890.67,0.00,'2022-08-20 11:06:44','',''),(3767,'21','220','1',1,'Sale Id shift 164',0.00,0.00,0.00,1940.28,0.00,'2022-08-20 11:06:44','',''),(3768,'21','220','2',1,'Sale Id shift 164',0.00,0.00,0.00,2829.92,0.00,'2022-08-20 11:06:44','',''),(3769,'21','220','2',1,'Sale Id shift 164',0.00,0.00,0.00,2427.96,0.00,'2022-08-20 11:06:44','',''),(3770,'21','220','2',1,'Sale Id shift 164',0.00,0.00,0.00,2195.78,0.00,'2022-08-20 11:06:44','',''),(3771,'21','220','2',1,'Sale Id shift 164',0.00,0.00,0.00,3075.28,0.00,'2022-08-20 11:06:44','',''),(3772,'21','220','1',1,'Sale Id shift 164',0.00,0.00,0.00,1576.07,0.00,'2022-08-20 11:06:44','',''),(3773,'21','220','2',1,'Sale Id shift 164',0.00,0.00,0.00,3549.62,0.00,'2022-08-20 11:06:44','',''),(3774,'21','220','2',1,'Sale Id shift 164',0.00,0.00,0.00,2190.20,0.00,'2022-08-20 11:06:44','',''),(3775,'21','220','2',1,'Sale Id shift 164',0.00,0.00,0.00,2837.18,0.00,'2022-08-20 11:06:44','',''),(3776,'21','220','2',1,'Sale Id shift 164',0.00,0.00,0.00,2728.80,0.00,'2022-08-20 11:06:44','',''),(3777,'21','220','1',1,'Sale Id shift 164',0.00,0.00,0.00,1965.56,0.00,'2022-08-20 11:06:44','',''),(3778,'21','220','3',2,'Sale Id shift 164',0.00,0.00,0.00,171.63,0.00,'2022-08-20 11:06:44','',''),(3779,'21','220',NULL,1,'Sale Id shift 164',5569399.50,0.00,0.00,0.00,0.00,'2022-08-20 11:06:44','',''),(3780,'21','220',NULL,2,'Sale Id shift 164',1104624.00,0.00,0.00,0.00,0.00,'2022-08-20 11:06:44','',''),(3781,'21','220',NULL,3,'Sale Id shift 164',421150.60,0.00,0.00,0.00,0.00,'2022-08-20 11:06:44','',''),(3782,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,7000000.00,40000.00,0.00,0.00,'2022-08-22 09:10:04','',''),(3783,'21','220',NULL,1,'Reception corrector for bridging 409',0.00,0.00,0.00,26500.00,0.00,'2022-08-22 09:13:17','',''),(3784,'21','220','2',1,'Received from bridging 409',0.00,0.00,26500.00,0.00,0.00,'2022-08-22 09:13:17','',''),(3785,'21','220',NULL,1,'Reception corrector for bridging 408',0.00,0.00,0.00,13500.00,0.00,'2022-08-22 09:13:17','',''),(3786,'21','220','1',1,'Received from bridging 408',0.00,0.00,13500.00,0.00,0.00,'2022-08-22 09:13:17','',''),(3787,'21','220',NULL,1,'Purchased from AYM SHAFA NIGERIA LIMITED',0.00,5250000.00,30000.00,0.00,0.00,'2022-08-22 09:21:07','',''),(3788,'21','220',NULL,1,'Reception corrector for bridging 410',0.00,0.00,0.00,30000.00,0.00,'2022-08-22 09:24:01','',''),(3789,'21','220','2',1,'Received from bridging 410',0.00,0.00,30000.00,0.00,0.00,'2022-08-22 09:24:01','',''),(3790,'21','220','1',1,'Sale Id shift 165',0.00,0.00,0.00,1534.68,0.00,'2022-08-22 09:36:36','',''),(3791,'21','220','3',2,'Sale Id shift 165',0.00,0.00,0.00,1763.45,0.00,'2022-08-22 09:36:36','',''),(3792,'21','220','4',3,'Sale Id shift 165',0.00,0.00,0.00,529.07,0.00,'2022-08-22 09:36:36','',''),(3793,'21','220','1',1,'Sale Id shift 165',0.00,0.00,0.00,17.14,0.00,'2022-08-22 09:36:36','',''),(3794,'21','220','1',1,'Sale Id shift 165',0.00,0.00,0.00,1681.67,0.00,'2022-08-22 09:36:36','',''),(3795,'21','220','1',1,'Sale Id shift 165',0.00,0.00,0.00,1114.91,0.00,'2022-08-22 09:36:37','',''),(3796,'21','220','1',1,'Sale Id shift 165',0.00,0.00,0.00,1530.31,0.00,'2022-08-22 09:36:37','',''),(3797,'21','220','2',1,'Sale Id shift 165',0.00,0.00,0.00,1254.31,0.00,'2022-08-22 09:36:37','',''),(3798,'21','220','2',1,'Sale Id shift 165',0.00,0.00,0.00,627.76,0.00,'2022-08-22 09:36:37','',''),(3799,'21','220','2',1,'Sale Id shift 165',0.00,0.00,0.00,972.41,0.00,'2022-08-22 09:36:37','',''),(3800,'21','220','2',1,'Sale Id shift 165',0.00,0.00,0.00,860.56,0.00,'2022-08-22 09:36:37','',''),(3801,'21','220','1',1,'Sale Id shift 165',0.00,0.00,0.00,1062.68,0.00,'2022-08-22 09:36:37','',''),(3802,'21','220','2',1,'Sale Id shift 165',0.00,0.00,0.00,1525.65,0.