-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_72
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_72`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_72` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_72`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1750 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1721,4000,'',0,'24','1','72','PURCHASES','','2018-11-27 17:31:08',5,0.00,0.00,'','409','2018-11-27 17:31:08','409',0,1),(1722,4001,'',0,'24','1','72','STAFF RENT','','2018-11-27 17:31:40',5,0.00,0.00,'','409','2018-11-27 17:31:40','409',0,1),(1723,4002,'',0,'24','1','72','PUMP AND GENERATOR REPAIRS','','2018-11-27 17:32:48',5,0.00,0.00,'','409','2018-11-27 17:32:48','409',0,1),(1724,4003,'',0,'24','1','72','GENERATOR AGO CONSUMPTION','','2018-11-27 17:34:25',5,0.00,0.00,'','409','2018-11-27 17:34:25','409',0,1),(1725,4004,'',0,'24','1','72','COMPUTER REPAIRS AND INTERNET ','','2018-11-27 17:35:13',5,0.00,0.00,'','409','2018-11-27 17:35:13','409',0,1),(1726,4005,'',0,'24','1','72','OTHER OPERATING EXPENSES ','','2018-11-27 17:35:40',5,0.00,0.00,'','409','2018-11-27 17:35:40','409',0,1),(1727,4006,'',0,'24','1','72','WEIGHT AND MEASURE','','2018-11-27 17:36:15',5,0.00,0.00,'','409','2018-11-27 17:36:15','409',0,1),(1728,4007,'',0,'24','1','72','MEDICAL EXPENSES','','2018-11-27 17:36:54',5,0.00,0.00,'','409','2018-11-27 17:36:54','409',0,1),(1729,4008,'',0,'24','1','72','REPAIRS AND FUELING OF OFFICIA','','2018-11-27 17:39:57',5,0.00,0.00,'','409','2018-11-27 17:39:57','409',0,1),(1730,4009,'',0,'24','1','72','PUBLIC RELATION','','2018-11-27 17:40:33',5,0.00,0.00,'','409','2018-11-27 17:40:33','409',0,1),(1731,4010,'',0,'24','1','72','STATION REPAIR AND MAINTENANCE','','2018-11-27 17:41:42',5,0.00,0.00,'','409','2018-11-27 17:41:42','409',0,1),(1732,4011,'',0,'24','1','72','PRINTING AND STATIONARIES','','2018-11-28 10:15:47',5,0.00,0.00,'','409','2018-11-28 10:15:47','409',0,1),(1733,4012,'',0,'24','1','72','DISCOUNT ALLOWED','','2018-11-28 10:16:16',5,0.00,0.00,'','409','2018-11-28 10:16:16','409',0,1),(1734,4013,'',0,'24','1','72','CLEANING AND SANITARY ITEMS','','2018-11-28 10:17:00',5,0.00,0.00,'','409','2018-11-28 10:17:00','409',0,1),(1735,4014,'',0,'24','1','72','ELECTRICITY AND WATER BILL','','2018-11-28 10:19:27',5,0.00,0.00,'','409','2018-11-28 10:19:27','409',0,1),(1736,4015,'',0,'24','1','72','TRANSPORT FARE','','2018-11-28 10:20:23',5,0.00,0.00,'','409','2018-11-28 10:20:23','409',0,1),(1737,4016,'',0,'24','1','72','STAF TRAINING AND ACCOMMODATIO','','2018-11-28 10:22:27',5,0.00,0.00,'','409','2018-11-28 10:22:27','409',0,1),(1738,4017,'',0,'24','1','72','SALARIES AND WAGES','','2018-11-28 10:23:40',5,0.00,0.00,'','409','2018-11-28 10:23:40','409',0,1),(1739,4018,'',0,'24','1','72','MISCELLANEOUS EXPENSES','','2018-11-28 10:24:53',5,0.00,0.00,'','409','2018-11-28 10:24:53','409',0,1),(1740,4020,'',0,'2','1','72','FIRSTBANK 2005845329','','2018-11-28 10:28:25',5,0.00,0.00,'','409','2018-11-28 10:28:25','409',0,1),(1741,4021,'',0,'5','1','72','INVENTORY VALUE ADJUSTMENT','','2018-11-28 10:31:12',5,0.00,0.00,'','409','2018-11-28 10:31:12','409',0,1),(1742,4022,'',0,'20','1','72','SALES','','2018-11-28 10:32:05',5,0.00,0.00,'','409','2018-11-28 10:32:05','409',0,1),(1743,4023,'',0,'5','1','72','CASH','','2018-11-28 10:38:15',5,0.00,0.00,'','409','2018-11-28 10:38:15','409',0,1),(1744,4024,'',0,'24','1','72','FEES, FINES AND DUES','','2018-11-28 10:40:48',5,0.00,0.00,'','409','2018-11-28 10:40:48','409',0,1),(1745,4044,'',0,'24','1','72','DONATION ACCOUNT','','2018-11-28 10:42:06',5,0.00,0.00,'','409','2018-11-28 10:42:06','409',0,1),(1746,4045,'',0,'2','1','72','KEYSTONE BANK 1000300152','','2018-11-28 10:42:41',5,0.00,0.00,'','409','2018-11-28 10:42:41','409',0,1),(1747,4026,'',0,'6','1','72','CASH IMPRESS','','2018-11-28 10:47:09',5,0.00,0.00,'','409','2018-11-28 10:47:09','409',0,1),(1749,3000,'',0,'6.1','1','72','CASH','','2018-11-30 15:36:03',5,0.00,0.00,'','407','2018-11-30 15:36:03','407',0,1);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=76571 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (76039,'1','72','0000-00-00','2019-07-23 17:38:21',10,'408','','0000-00-00 00:00:00','409','2019-10-21 11:49:33'),(76143,'1','72','0000-00-00','2019-08-20 17:12:57',10,'408','','0000-00-00 00:00:00','409','2019-10-21 11:49:40'),(76218,'1','72','0000-00-00','2019-09-13 16:15:45',10,'408','','0000-00-00 00:00:00','409','2019-10-21 11:49:48'),(76445,'1','72','0000-00-00','2019-11-14 15:16:00',10,'408','','0000-00-00 00:00:00','409','2019-11-26 12:15:10'),(76570,'1','72','0000-00-00','2019-12-17 17:50:35',0,'408','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=160845 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (159717,'1','72','76039','98','supplier',28000.00,'PAYMENT FOR DRIVER SHORTAGE OF 200 LTRS OF PMS',0.00,'2019-07-17'),(159718,'1','72','76039','1749','6.1',0.00,'PAYMENT FOR DRIVER SHORTAGE OF 200 LTRS 0F PMS',28000.00,'2019-07-17'),(159934,'1','72','76143','98','supplier',176000.00,'PAYMENT FOR DRIVER SHOTAGE OF 800 LTRS OF AGO AT 220',0.00,'2019-08-16'),(159935,'1','72','76143','1749','6.1',0.00,'PAYMENT FOR DRIVER SHOTAGE OF 800 LTRS OF AGO AT 220',176000.00,'2019-08-16'),(160091,'1','72','76218','98','supplier',33000.00,'DRIVER SHOTAGE OF 150 LTRS OF AGO',0.00,'2019-08-22'),(160092,'1','72','76218','98','supplier',0.00,'DRIVER SHOTAGE  OF 150 LTRS OF AGO',33000.00,'2019-08-22'),(160139,'1','72','76218','98','supplier',107500.00,'PAYMENT F0R DRIVER SHOTAGE OF 500 LTRS OF AGO',0.00,'2019-09-18'),(160140,'1','72','76218','98','supplier',0.00,'PAYMENT F0R DRIVER SHOTAGE OF 500 LTRS OF AGO',107500.00,'2019-09-18'),(160577,'1','72','76445','1740','2',33000.00,'PAYMENT F0R DRIVER SHOTAGE OF 150 LTRS OF AGO',0.00,'2019-11-12'),(160578,'1','72','76445','1740','2',0.00,'PAYMENT F0R DRIVER SHOTAGE OF 150 LTRS OF AGO',33000.00,'2019-11-12'),(160843,'1','72','76570','1740','2',17875.00,'PAYMENT FOR DRIVER SHORTAGE OF  PMS 125 LITERS AT COST OF 143',0.00,'2019-12-14'),(160844,'1','72','76570','1740','2',0.00,'PAYMENT FOR DRIVER SHORTAGE OF PMS 125 LITERS AT COST  OF 143',17875.00,'2019-12-17');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=34130 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (30126,'1','72','2018-11-30','70659','1749',0.00,'2018-12-18 16:27:55',5,'408','','0000-00-00 00:00:00','409','2019-01-09 13:18:54'),(30127,'1','72','2018-12-03','70700','1749',0.00,'2018-12-18 16:32:43',5,'408','','0000-00-00 00:00:00','409','2019-01-09 13:19:46'),(30128,'1','72','2018-12-10','71118','1749',0.00,'2018-12-18 16:34:09',5,'408','','0000-00-00 00:00:00','409','2019-01-09 13:20:30'),(30129,'1','72','2018-12-17','72206','1749',0.00,'2018-12-18 16:35:41',5,'408','','0000-00-00 00:00:00','409','2019-01-09 13:21:21'),(30130,'1','72','2018-12-01','70697','1747',0.00,'2018-12-18 16:43:02',5,'408','','0000-00-00 00:00:00','409','2019-01-09 13:22:07'),(30131,'1','72','2018-12-01','70697','1747',0.00,'2018-12-18 16:49:00',5,'408','409','2019-01-09 13:22:41','409','2019-01-09 13:23:11'),(31588,'1','72','2019-02-28','','1749',0.00,'2019-02-28 16:10:05',5,'408','409','2019-03-05 11:43:52','409','2019-03-05 12:29:04'),(31589,'1','72','2019-02-28','','1749',0.00,'2019-02-28 16:12:03',5,'408','409','2019-03-05 11:44:29','409','2019-03-05 12:29:26'),(31590,'1','72','2019-02-28','','1749',0.00,'2019-02-28 16:23:32',5,'408','409','2019-03-05 12:27:12','409','2019-03-05 12:28:24'),(32976,'1','72','2019-04-30','','1749',0.00,'2019-05-02 20:25:15',0,'408','409','2019-07-01 11:20:52','','0000-00-00 00:00:00'),(34035,'1','72','2019-05-31','','1747',0.00,'2019-06-30 11:03:08',5,'408','409','2019-07-01 11:18:44','409','2019-07-01 11:25:09'),(34129,'1','72','2019-07-01','','1721',0.00,'2019-07-01 12:48:43',5,'408','','0000-00-00 00:00:00','409','2019-09-19 15:38:01');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=68328 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (62316,'1','72',30126,1738,'STAFF SALLARIES FOR THE MONTH OF NOVEMBER',40000.00),(62317,'1','72',30127,1724,'A G O CONSUMPTION FOR SEVEN DAYS',5200.00),(62318,'1','72',30128,1724,'A G O CONSUMPTION FOR SEVEN DAYS',5200.00),(62319,'1','72',30129,1724,'A G O CONSUMPTION FOR SEVEN DAYS',5200.00),(62320,'1','72',30130,1723,'CHANGE ENGINE OIL FOR THE MONTH OF NOVEMBER',3500.00),(62945,'1','72',30131,1729,'STATION CAR FUEL AND CHANGE OF ENGINE OIL',6500.00),(64664,'1','72',31588,1724,'A G O CONSUMPTION FOR SEVEN DAYS',4500.00),(64665,'1','72',31589,1724,'A G O CONSUMPTION FOR SEVEN DAYS',4500.00),(64667,'1','72',31590,1723,'CHANGE ENGINE OIL FOR THE MONTH OF JANUARY',3500.00),(68301,'1','72',34035,1723,'GEN. ENGINE OIL ',3500.00),(68302,'1','72',34035,1731,'CAR ENGINE OIL',4500.00),(68303,'1','72',34035,1730,'DISCOUNT ',1600.00),(68304,'1','72',34035,1732,'ROBBER BAND',400.00),(68306,'1','72',32976,1724,'CHANGE CAR ENGINE 0IL F0R THE MONTH OF MARCH',4500.00),(68324,'1','72',34129,1724,'03/06/2019',4500.00),(68325,'1','72',34129,1724,'10/06/2019',4500.00),(68326,'1','72',34129,1724,'17/06/2019',4500.00),(68327,'1','72',34129,1724,'24/06/2019',4500.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1429 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1379,'','1','72','CONCENSUS MOTORS','MURTALA','08032198330','','KATSINA','KATSINA','DANRIMI M/FASHI','Nigeria',0.00,0.00,140450.00,'0000-00-00','2018-12-12 15:30:23',5,'408','2019-02-19 14:49:53','409'),(1380,'','1','72','DANMA KAI MOTORS','ALH.MOHD','08039286928','','KATSINA','KATSINA','BARANKACHI M/FASHI','Nigeria',0.00,0.00,343000.00,'0000-00-00','2018-12-12 15:33:39',5,'408','2019-02-19 14:45:56','409'),(1381,'','1','72','SHAFIU TRASPORT','SHAFIU GARBA','08132690980','','KATSINA','KATSINA','LAYIN ALH. AMADU M/FASHI','Nigeria',0.00,0.00,30000.00,'0000-00-00','2018-12-12 15:41:19',5,'408','2019-02-19 16:50:40','409'),(1382,'','1','72','A.A.Y MOTORS COMP.','ALH. ABDULMALIK','07035238758','','KATSINA','KATSINA','UNGUWAN MATA M/FASHI','Nigeria',0.00,0.00,387885.00,'0000-00-00','2018-12-12 15:43:35',5,'408','2019-02-19 14:44:23','409'),(1383,'','1','72','KOFAR RUWA MOTORS','MANI SHAFIU','08123240635','','KATSINA','KATSINA','LAYIN ALH. AMADU','Nigeria',0.00,0.00,8000.00,'0000-00-00','2018-12-12 15:47:29',5,'408','2019-02-19 16:51:16','409'),(1384,'','1','72','MAMMAN TRANSPORT','ALH. MAMMAN','08032075587','','KATSINA','KATSINA','LAYIN ALH. AMADU M/FASHI','Nigeria',0.00,0.00,72480.00,'0000-00-00','2018-12-12 15:49:49',5,'408','2019-02-19 14:27:38','409'),(1385,'','1','72','ALIYU TRANSPORT','ALH. ALIYU MALUMFASHI','07031639607','','KATSINA','KATSINA','TSOHUWAR KASUWA M/FASHI','Nigeria',0.00,0.00,228500.00,'0000-00-00','2018-12-12 15:53:17',5,'408','2019-02-19 14:26:51','409'),(1386,'','1','72','SAGIR KARFI COMPANY','ALH. MUSTAFAH','08162425424','','KATSINA','KATSINA','UNGUWAN MATA M/FASHI','Nigeria',0.00,0.00,302750.00,'0000-00-00','2018-12-12 15:56:36',5,'408','2019-02-19 14:24:53','409'),(1387,'','1','72','B. A. L MOTORS','BASHIR ADAMU','08033842342','','KATSINA','KATSINA','KOFAR FADA TSOHUWAR KASUWA M/FASHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2018-12-12 15:58:40',5,'408','2018-12-12 15:58:40','408'),(1388,'','1','72','B. A. L MOTORS 1','ALH TIJJANI','08066106579','','KATSINA','KATSINA','DAN RIMI JUNCTION M/FASHI','Nigeria',0.00,0.00,115500.00,'0000-00-00','2018-12-12 16:01:50',5,'408','2019-02-19 12:25:26','407'),(1417,'','1','72','KURMI TRASPORT','AMINU KURMI','','','KATSINA','KATSINA','KAFUR L.G.A, KATSINA STATE','Nigeria',0.00,0.00,46500.00,'0000-00-00','2019-02-20 11:23:15',5,'409','2019-02-20 12:27:49','409'),(1418,'','1','72','JIKA TRASPORT','ALH ADO JIKA','07030508781','','KATSINA','KATSINA','DANJA, KATSINA STATE','Nigeria',0.00,0.00,27500.00,'0000-00-00','2019-02-20 11:28:40',5,'409','2019-02-20 12:26:36','409'),(1419,'','1','72','HAYIN DAGA TRASPORT','ALH SALES','08063429110','','KATSINA','KATSINA','MALUMFASHI , KASTINA','Nigeria',0.00,0.00,70000.00,'0000-00-00','2019-02-20 11:30:53',5,'409','2019-02-20 12:28:30','409'),(1420,'','1','72','DANGUGUA TRASPORT','MANSUR DANGUGUA','09055853846','','KAFUR','KATSINA','KAFUR, LGA KATSINA','Nigeria',0.00,0.00,99900.00,'0000-00-00','2019-02-20 11:32:47',5,'409','2019-02-20 12:30:04','409'),(1421,'','1','72','NANU TRASPORT','GHALI','08065581588','','MALUMFASHI','KATSINA','MALUMFASHI, KATSINA','Nigeria',0.00,0.00,60000.00,'0000-00-00','2019-02-20 11:36:51',5,'409','2019-02-20 12:30:38','409'),(1422,'','1','72','HABIB TRANSPORT','HABIBU','08033011043','','MALUMFASHI','KATSINA','MALUMFASHI','Nigeria',0.00,0.00,144500.00,'0000-00-00','2019-02-20 11:38:00',5,'409','2019-02-20 12:31:26','409'),(1423,'','1','72','ZAMANI IKON ALLAH TRASPORT','ZAMANI','09030137819','','MALUMFASHI','KATSINA','MALUMFASHI, ','Nigeria',0.00,0.00,276000.00,'0000-00-00','2019-02-20 11:39:45',5,'409','2019-02-20 12:32:09','409'),(1424,'','1','72','BARA BARAU','BABA BARAU','07067648541','','KAFUR','KATSINA','KAFUR','Nigeria',0.00,0.00,44800.00,'0000-00-00','2019-02-20 12:11:38',5,'409','2019-02-20 12:32:57','409'),(1425,'','1','72','TURA LINE TRASPORT','ALH SANI','08167244261','','MALUMFASHI','KATSINA','MALUMFASHI','Nigeria',0.00,0.00,19000.00,'0000-00-00','2019-02-20 12:13:00',5,'409','2019-02-20 12:35:50','409'),(1426,'','1','72','MUNSUR YAUZA','MANSUR YAUZA','','','MALUMFASHI','KATSINA','MALUMFASI','Nigeria',0.00,0.00,45000.00,'0000-00-00','2019-02-20 12:18:37',5,'409','2019-02-20 12:36:18','409'),(1427,'','1','72','CONCENSUS MOTORS TRANSPORT','IBRAHIM  MURTALA','09039496929','','MALUMFASHI','KATSINA','MALUMFASHI','Nigeria',0.00,0.00,196900.00,'0000-00-00','2019-02-20 12:22:48',5,'409','2019-02-20 12:40:54','409'),(1428,'','1','72','MUJAHIDA TRANSPORT','ALH ADO KATSINA','','','MALUMFASHI','KATSINA','MALUMFASHI','Nigeria',0.00,0.00,112500.00,'0000-00-00','2019-02-20 16:40:51',5,'409','2019-02-20 16:41:47','409');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=9517 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','72',6062,'592',0.00,11400.00,'2018-11-29','AGO DIPPING','2018-11-30 11:05:00','409','409',2018,'409','2018-11-30 11:05:00',5),('1','72',9516,'592',623.00,1208.00,'2019-08-16','','2019-08-17 17:27:13','408','408',2019,'408','2019-08-17 17:27:13',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1654 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','72','590',1649,'5','PUMP 1',0.00,'PMS PUMP 1',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','72','590',1650,'5','PUMP 2',0.00,'PMS PUMP 2',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','72','591',1651,'5','PUMP 3',0.00,'PMS PUMP 3',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','72','592',1652,'5','PUMP 4',52298.98,'AGO PUMP 4',NULL,NULL,NULL,NULL,5,'2020-02-27 17:08:11','125'),('1','72','593',1653,'5','PUMP 5',0.00,'DPK TANK 5',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=139818 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','72',70008,'EVENING SHIFT','2018-11-29','2018-11-29 00:00:00',NULL,'409',101033.40,101033.40,'408','2018-11-30 12:22:59','408','2018-12-06 08:18:26',10,0),('1','72',70659,'EVENING SHIFT','2018-11-30','2018-11-30 00:00:00',NULL,'408',276684.20,276684.20,'408','2018-12-06 11:11:35','408','2018-12-06 11:53:53',10,0),('1','72',70697,'EVENING','2018-12-01','2018-12-01 00:00:00',NULL,'408',304987.80,304987.80,'408','2018-12-06 12:02:06','408','2018-12-06 12:03:11',10,0),('1','72',70699,'EVENING','2018-12-02','2018-12-02 00:00:00',NULL,'408',458096.60,458096.60,'408','2018-12-06 12:09:06','408','2018-12-06 12:11:42',10,0),('1','72',70700,'EVENING SHIFT','2018-12-03','2018-12-03 00:00:00',NULL,'408',176888.40,176888.40,'408','2018-12-06 12:19:47','408','2018-12-06 12:26:03',10,0),('1','72',70702,'EVENING SHIFT','2018-12-04','2018-12-04 00:00:00',NULL,'408',95503.20,95503.20,'408','2018-12-06 12:44:38','408','2018-12-06 12:46:35',10,0),('1','72',70708,'EVENING SHIFT','2018-12-05','2018-12-05 00:00:00',NULL,'408',186105.40,186105.40,'408','2018-12-07 07:49:21','408','2018-12-07 07:50:42',10,0),('1','72',70783,'EVENING SHIFT','2018-12-06','2018-12-06 00:00:00',NULL,'408',235003.60,235003.60,'408','2018-12-07 07:54:37','408','2018-12-07 07:55:25',10,0),('1','72',70893,'EVENING SHIFT','2018-12-07','2018-12-07 00:00:00',NULL,'408',149640.40,149640.40,'408','2018-12-08 07:44:02','408','2018-12-08 07:45:28',10,0),('1','72',70896,'EVENING SHIFT','2018-12-08','2018-12-08 00:00:00',NULL,'408',97016.40,97016.40,'408','2018-12-09 16:35:36','408','2018-12-09 16:36:13',10,0),('1','72',71086,'EVENING SHIFT','2018-12-09','2018-12-09 00:00:00',NULL,'408',199963.40,199963.40,'408','2018-12-10 08:37:32','408','2018-12-10 08:38:13',10,0),('1','72',71118,'EVENING SHIFT','2018-12-10','2018-12-10 00:00:00',NULL,'408',88927.80,88927.80,'408','2018-12-11 10:10:49','408','2018-12-11 10:11:49',10,0),('1','72',71373,'EVENING SHIFT','2018-12-11','2018-12-11 00:00:00',NULL,'408',163264.40,163264.40,'408','2018-12-12 09:06:38','408','2018-12-12 09:07:23',10,0),('1','72',71374,'EVENING SHIFT','2018-12-12','2018-12-12 00:00:00',NULL,'408',157445.60,157445.60,'408','2018-12-13 08:14:10','408','2018-12-13 08:15:29',10,0),('1','72',71508,'EVENING SHIFT','2018-12-13','2018-12-13 00:00:00',NULL,'408',187608.20,187608.20,'408','2018-12-14 08:25:16','408','2018-12-14 08:26:01',10,0),('1','72',71638,'EVENING SHIFT','2018-12-14','2018-12-14 00:00:00',NULL,'408',453635.00,453635.00,'408','2018-12-17 17:02:26','408','2018-12-17 17:03:04',10,0),('1','72',72177,'EVENING SHIFT','2018-12-15','2018-12-15 00:00:00',NULL,'408',426735.40,426735.40,'408','2018-12-17 17:09:20','408','2018-12-17 17:12:13',10,0),('1','72',72179,'EVENING SHIFT','2018-12-16','2018-12-16 00:00:00',NULL,'408',288696.20,288696.20,'408','2018-12-17 17:15:12','408','2018-12-17 17:16:04',10,0),('1','72',72206,'EVENING SHIFT','2018-12-17','2018-12-17 00:00:00',NULL,'408',493022.40,493022.40,'408','2018-12-18 09:16:10','408','2018-12-18 09:16:48',10,0),('1','72',72209,'EVENING SHIFT','2018-12-18','2018-12-18 00:00:00',NULL,'408',142305.80,142305.80,'408','2018-12-19 07:52:19','408','2018-12-19 07:52:48',10,0),('1','72',72489,'EVENING SHIFT','2018-12-19','2018-12-19 00:00:00',NULL,'408',265266.30,265266.30,'408','2018-12-20 10:38:58','408','2018-12-20 10:40:15',10,0),('1','72',72713,'EVENING SHIFT','2018-12-20','2018-12-20 00:00:00',NULL,'408',210255.15,210255.15,'408','2018-12-21 16:31:09','408','2018-12-21 16:31:52',10,0),('1','72',72718,'EVENING SHIFT','2018-12-21','2018-12-21 00:00:00',NULL,'408',134012.70,134012.70,'408','2018-12-21 16:47:45','408','2018-12-21 16:48:28',10,0),('1','72',72799,'EVENING SHIFT','2018-12-21','2018-12-21 00:00:00',NULL,'408',26127.50,26127.50,'408','2018-12-22 12:57:42','408','2018-12-22 12:58:15',10,0),('1','72',72801,'EVENING SHIFT','2018-12-22','2018-12-22 00:00:00',NULL,'408',213807.50,213807.50,'408','2018-12-23 15:46:39','408','2018-12-23 15:47:13',10,0),('1','72',72955,'EVENING SHIFT','2018-12-23','2018-12-23 00:00:00',NULL,'408',193600.00,193600.00,'408','2018-12-24 15:22:06','408','2018-12-24 15:22:39',10,0),('1','72',73086,'EVENING SHIFT','2018-12-24','2018-12-24 00:00:00',NULL,'408',164130.00,164130.00,'408','2018-12-25 16:14:16','408','2018-12-25 16:14:48',10,0),('1','72',73203,'EVENING SHIFT','2018-12-25','2018-12-25 00:00:00',NULL,'408',19550.00,19550.00,'408','2018-12-25 16:18:51','408','2018-12-25 16:22:02',10,0),('1','72',73206,'EVENING SHIFT','2018-12-25','2018-12-25 00:00:00',NULL,'408',35547.05,35547.05,'408','2018-12-26 12:50:44','408','2018-12-26 12:52:44',10,0),('1','72',73319,'EVENING SHIFT','2018-12-26','2018-12-26 00:00:00',NULL,'408',166453.00,166453.00,'408','2018-12-27 09:39:04','408','2018-12-27 09:39:45',10,0),('1','72',73410,'EVENING SHIFT','2018-12-27','2018-12-27 00:00:00',NULL,'408',317348.50,317348.50,'408','2018-12-28 14:26:27','408','2018-12-28 14:27:03',10,0),('1','72',73567,'EVENING SHIFT','2018-12-28','2018-12-28 00:00:00',NULL,'408',353953.95,353953.95,'408','2018-12-30 08:23:21','408','2018-12-30 08:23:57',10,0),('1','72',73748,'EVENING SHIFT','2018-12-29','2018-12-29 00:00:00',NULL,'408',170934.05,170934.05,'408','2018-12-30 08:26:09','408','2018-12-30 08:26:46',10,0),('1','72',73750,'EVENING SHIFT','2018-12-30','2018-12-30 00:00:00',NULL,'408',118161.05,118161.05,'408','2018-12-31 08:11:54','408','2018-12-31 08:13:08',10,0),('1','72',73868,'EVENING SHIFT','2018-12-31','2018-12-31 00:00:00',NULL,'408',304074.40,304074.40,'408','2019-01-04 19:04:12','408','2019-01-04 19:05:04',10,0),('1','72',74467,'EVENING SHIFT','2019-01-01','2019-01-01 00:00:00',NULL,'408',168319.90,168319.90,'408','2019-01-04 19:09:49','408','2019-01-04 19:10:42',10,0),('1','72',74468,'EVENING SHIFT','2019-01-02','2019-01-02 00:00:00',NULL,'408',196053.90,196053.90,'408','2019-01-04 19:12:55','408','2019-01-04 19:13:51',10,0),('1','72',74469,'EVENING SHIFT','2019-01-03','2019-01-03 00:00:00',NULL,'408',319176.20,319176.20,'408','2019-01-04 19:20:50','408','2019-01-04 19:21:32',10,0),('1','72',74470,'EVENING SHIFT','2019-01-04','2019-01-04 00:00:00',NULL,'408',282100.35,282100.35,'408','2019-01-06 08:00:34','408','2019-01-06 08:01:14',10,0),('1','72',74585,'EVENING SHIFT','2019-01-05','2019-01-05 00:00:00',NULL,'408',129727.50,129727.50,'408','2019-01-06 08:04:01','408','2019-01-06 08:04:35',10,0),('1','72',74586,'EVENING SHIFT','2019-01-06','2019-01-06 00:00:00',NULL,'408',122426.50,122426.50,'408','2019-01-07 09:01:40','408','2019-01-07 09:02:23',10,0),('1','72',74705,'EVENING SHIFT','2019-01-07','2019-01-07 00:00:00',NULL,'408',497112.00,497112.00,'408','2019-01-09 14:45:17','408','2019-01-09 14:45:52',10,0),('1','72',75048,'EVENING SHIFT','2019-01-08','2019-01-08 00:00:00',NULL,'408',281044.80,281044.80,'408','2019-01-09 14:48:09','408','2019-01-09 14:48:45',10,0),('1','72',75050,'EVENING SHIFT','2019-01-09','2019-01-09 00:00:00',NULL,'408',180024.00,180024.00,'408','2019-01-10 08:30:27','408','2019-01-10 08:30:54',10,0),('1','72',75100,'EVENING SHIFT','2019-01-10','2019-01-10 00:00:00',NULL,'408',316185.60,316185.60,'408','2019-01-11 08:28:46','408','2019-01-11 08:29:18',10,0),('1','72',75233,'EVENING SHIFT','2019-01-11','2019-01-11 00:00:00',NULL,'408',196346.40,196346.40,'408','2019-01-12 11:41:59','408','2019-01-12 11:42:40',10,0),('1','72',75365,'EVENING SHIFT','2019-01-12','2019-01-12 00:00:00',NULL,'408',181812.00,181812.00,'408','2019-01-13 07:36:17','408','2019-01-13 07:36:53',10,0),('1','72',75446,'EVENING SHIFT','2019-01-13','2019-01-13 00:00:00',NULL,'408',58929.60,58929.60,'408','2019-01-14 11:21:37','408','2019-01-14 11:23:11',10,0),('1','72',75595,'EVENING SHIFT','2019-01-14','2019-01-14 00:00:00',NULL,'408',108602.40,108602.40,'408','2019-01-15 12:45:05','408','2019-01-15 12:46:21',10,0),('1','72',75737,'EVENING SHIFT','2019-01-15','2019-01-15 00:00:00',NULL,'408',292142.40,292142.40,'408','2019-01-16 09:15:37','408','2019-01-16 09:16:41',10,0),('1','72',75811,'EVENING SHIFT','2019-01-16','2019-01-16 00:00:00',NULL,'408',165345.60,165345.60,'408','2019-01-17 14:37:03','408','2019-01-17 14:38:32',10,0),('1','72',76011,'EVENING SHIFT','2019-01-17','2019-01-17 00:00:00',NULL,'408',395863.20,395863.20,'408','2019-01-18 08:12:37','408','2019-01-18 08:13:10',10,0),('1','72',76054,'EVENING SHIFT','2019-01-18','2019-01-18 00:00:00',NULL,'408',432336.00,432336.00,'408','2019-01-23 07:53:13','408','2019-01-23 07:53:58',10,0),('1','72',76689,'EVENING SHIFT','2019-01-19','2019-01-19 00:00:00',NULL,'408',128971.20,128971.20,'408','2019-01-23 07:57:40','408','2019-01-23 07:58:29',10,0),('1','72',76691,'EVENING SHIFT','2019-01-20','2019-01-20 00:00:00',NULL,'408',283996.80,283996.80,'408','2019-01-23 08:01:52','408','2019-01-23 08:02:39',10,0),('1','72',76692,'EVENING SHIFT','2019-01-21','2019-01-21 00:00:00',NULL,'408',147952.80,147952.80,'408','2019-01-23 08:10:01','408','2019-01-23 08:10:36',10,0),('1','72',76693,'EVENING SHIFT','2019-01-23','2019-01-23 00:00:00',NULL,'408',473832.00,473832.00,'408','2019-01-24 16:29:54','408','2019-01-24 16:30:26',10,0),('1','72',76903,'EVENING SHIFT','2019-01-24','2019-01-24 00:00:00',NULL,'408',215882.40,215882.40,'408','2019-01-25 08:37:42','408','2019-01-25 08:38:20',10,0),('1','72',76933,'EVENING SHIFT','2019-01-25','2019-01-25 00:00:00',NULL,'408',14599.20,14599.20,'408','2019-01-26 10:37:10','408','2019-01-26 10:37:44',10,0),('1','72',77064,'EVENING SHIFT','2019-01-25','2019-01-25 00:00:00',NULL,'408',125044.10,125044.10,'408','2019-01-26 10:46:06','408','2019-01-26 10:50:36',10,0),('1','72',77066,'EVENING SHIFT','2019-01-26','2019-01-26 00:00:00',NULL,'408',170471.40,170471.40,'408','2019-01-28 08:01:45','408','2019-01-28 08:02:24',10,0),('1','72',77272,'EVENING SHIFT','2019-01-27','2019-01-27 00:00:00',NULL,'408',65858.20,65858.20,'408','2019-01-28 11:24:57','408','2019-01-28 11:25:32',10,0),('1','72',77315,'EVENING SHIFT','2019-01-28','2019-01-28 00:00:00',NULL,'408',9666.90,9666.90,'408','2019-01-29 10:56:27','408','2019-01-29 10:57:01',10,0),('1','72',77462,'EVENING SHIFT','2019-01-28','2019-01-28 00:00:00',NULL,'408',65052.00,65052.00,'408','2019-01-29 11:00:58','408','2019-01-29 11:01:41',10,0),('1','72',77463,'EVENING SHIFT','2019-01-29','2019-01-29 00:00:00',NULL,'408',315677.25,315677.25,'408','2019-01-31 09:27:28','408','2019-01-31 09:28:55',10,0),('1','72',77687,'EVENING SHIFT','2019-01-30','2019-01-30 00:00:00',NULL,'408',757469.25,757469.25,'408','2019-01-31 09:31:23','408','2019-01-31 09:32:11',10,0),('1','72',77689,'EVENING SHIFT','2019-01-31','2019-01-31 00:00:00',NULL,'408',185688.00,185688.00,'408','2019-02-01 11:06:10','408','2019-02-01 11:06:46',10,0),('1','72',77823,'EVENING SHIFT','2019-02-01','2019-02-01 00:00:00',NULL,'408',63499.50,63499.50,'408','2019-02-03 08:19:16','408','2019-02-03 08:20:02',10,0),('1','72',78030,'EVENING SHIFT','2019-02-02','2019-02-02 00:00:00',NULL,'408',430571.25,430571.25,'408','2019-02-03 08:23:56','408','2019-02-03 08:25:12',10,0),('1','72',78034,'EVENING SHIFT','2019-02-03','2019-02-03 00:00:00',NULL,'408',419681.25,419681.25,'408','2019-02-04 12:08:02','408','2019-02-04 12:08:49',10,0),('1','72',78192,'EVENING SHIFT','2019-02-04','2019-02-04 00:00:00',NULL,'408',335342.25,335342.25,'408','2019-02-05 15:27:20','408','2019-02-05 15:28:12',10,0),('1','72',78387,'EVENING SHIFT','2019-02-05','2019-02-05 00:00:00',NULL,'408',152093.25,152093.25,'408','2019-02-06 12:24:50','408','2019-02-06 12:25:39',10,0),('1','72',78479,'EVENING SHIFT','2019-02-06','2019-02-06 00:00:00',NULL,'408',548732.25,548732.25,'408','2019-02-07 15:51:26','408','2019-02-07 15:52:35',10,0),('1','72',78655,'EVENING SHIFT','2019-02-07','2019-02-07 00:00:00',NULL,'408',431331.75,431331.75,'408','2019-02-10 09:47:57','408','2019-02-10 09:48:42',10,0),('1','72',78943,'EVENING SHIFT','2019-02-08','2019-02-08 00:00:00',NULL,'408',231099.75,231099.75,'408','2019-02-10 09:51:45','408','2019-02-10 09:53:43',10,0),('1','72',78944,'EVENING SHIFT','2019-02-09','2019-02-09 00:00:00',NULL,'408',83866.50,83866.50,'408','2019-02-10 09:59:32','408','2019-02-10 10:00:07',10,0),('1','72',78945,'EVENING SHIFT','2019-02-10','2019-02-10 00:00:00',NULL,'408',146448.00,146448.00,'408','2019-02-11 09:10:52','408','2019-02-11 09:11:41',10,0),('1','72',79065,'EVENING SHIFT','2019-02-11','2019-02-11 00:00:00',NULL,'408',45690.75,45690.75,'408','2019-02-12 11:29:03','408','2019-02-12 11:29:54',10,0),('1','72',79236,'EVENING SHIFT','2019-02-12','2019-02-12 00:00:00',NULL,'408',179255.25,179255.25,'408','2019-02-14 09:44:17','408','2019-02-14 09:51:22',10,0),('1','72',79453,'EVENING SHIFT','2019-02-13','2019-02-13 00:00:00',NULL,'408',221681.25,221681.25,'408','2019-02-14 10:10:13','408','2019-02-14 10:11:06',10,0),('1','72',79457,'EVENING SHIFT','2019-02-14','2019-02-14 00:00:00',NULL,'408',104172.75,104172.75,'408','2019-02-18 12:18:04','408','2019-02-18 12:18:38',10,0),('1','72',79929,'EVENING SHIFT','2019-02-15','2019-02-15 00:00:00',NULL,'408',166891.50,166891.50,'408','2019-02-18 12:21:13','408','2019-02-18 12:21:46',10,0),('1','72',79930,'EVENING SHIFT','2019-02-16','2019-02-16 00:00:00',NULL,'408',190514.25,190514.25,'408','2019-02-18 12:26:25','408','2019-02-18 12:27:13',10,0),('1','72',79931,'EVENING SHIFT','2019-02-17','2019-02-17 00:00:00',NULL,'408',130432.50,130432.50,'408','2019-02-18 12:29:50','408','2019-02-18 12:30:27',10,0),('1','72',79932,'EVENING SHIFT','2019-02-18','2019-02-18 00:00:00',NULL,'408',128112.75,128112.75,'408','2019-02-19 16:19:50','408','2019-02-19 16:21:14',10,0),('1','72',80134,'EVENING SHIFT','2019-02-19','2019-02-19 00:00:00',NULL,'408',56641.50,56641.50,'408','2019-02-20 14:41:10','408','2019-02-20 14:41:39',10,0),('1','72',80238,'EVENING SHIFT','2019-02-20','2019-02-20 00:00:00',NULL,'408',59584.50,59584.50,'408','2019-02-21 15:22:48','408','2019-02-21 15:23:26',10,0),('1','72',80378,'EVENING SHIFT','2019-02-21','2019-02-21 00:00:00',NULL,'408',25717.50,25717.50,'408','2019-02-22 14:18:46','408','2019-02-22 14:19:26',10,0),('1','72',80465,'EVENING SHIFT','2019-02-22','2019-02-22 00:00:00',NULL,'408',95949.00,95949.00,'408','2019-02-25 18:32:56','408','2019-02-25 18:33:58',10,0),('1','72',80754,'EVENING SHIFT','2019-02-24','2019-02-24 00:00:00',NULL,'408',23478.75,23478.75,'408','2019-02-25 18:37:34','408','2019-02-25 18:39:19',10,0),('1','72',80755,'EVENING SHIFT','2019-02-25','2019-02-25 00:00:00',NULL,'408',91179.00,91179.00,'408','2019-02-26 15:41:02','408','2019-02-26 15:44:12',10,0),('1','72',80854,'EVENING SHIFT','2019-02-26','2019-02-26 00:00:00',NULL,'408',140679.00,140679.00,'408','2019-02-28 15:28:10','408','2019-02-28 15:28:39',10,0),('1','72',81143,'EVENING SHIFT','2019-02-27','2019-02-27 00:00:00',NULL,'408',144483.75,144483.75,'408','2019-02-28 15:34:06','408','2019-02-28 15:35:00',10,0),('1','72',81145,'EVENING SHIFT','2019-02-28','2019-02-28 00:00:00',NULL,'408',21701.25,21701.25,'408','2019-03-01 15:24:21','408','2019-03-01 15:25:48',10,0),('1','72',81254,'EVENING SHIFT','2019-03-01','2019-03-01 00:00:00',NULL,'408',31401.00,31401.00,'408','2019-03-02 10:52:03','408','2019-03-02 10:52:33',10,0),('1','72',81306,'EVENING SHIFT','2019-03-02','2019-03-02 00:00:00',NULL,'408',56173.50,56173.50,'408','2019-03-04 08:10:36','408','2019-03-04 08:11:24',10,0),('1','72',81484,'EVENING SHIFT','2019-03-03','2019-03-03 00:00:00',NULL,'408',121209.75,121209.75,'408','2019-03-04 08:16:29','408','2019-03-04 08:17:11',10,0),('1','72',81486,'EVENING SHIFT','2019-03-04','2019-03-04 00:00:00',NULL,'408',62300.25,62300.25,'408','2019-03-05 08:25:51','408','2019-03-05 08:26:25',10,0),('1','72',82447,'EVENING SHIFT','2019-03-05','2019-03-05 00:00:00',NULL,'408',165055.50,165055.50,'408','2019-03-12 16:02:29','408','2019-03-12 16:30:16',10,0),('1','72',82452,'EVENING SHIFT','2019-03-06','2019-03-06 00:00:00',NULL,'408',73658.25,73658.25,'408','2019-03-12 16:32:46','408','2019-03-12 16:33:37',10,0),('1','72',82454,'EVENING SHIFT','2019-03-07','2019-03-07 00:00:00',NULL,'408',77550.75,77550.75,'408','2019-03-12 16:36:29','408','2019-03-12 16:37:36',10,0),('1','72',82457,'EVENING SHIFT','2019-03-08','2019-03-08 00:00:00',NULL,'408',12512.25,12512.25,'408','2019-03-12 16:41:47','408','2019-03-12 16:42:43',10,0),('1','72',82459,'EVENING SHIFT','2019-03-10','2019-03-10 00:00:00',NULL,'408',94272.75,94272.75,'408','2019-03-12 16:45:35','408','2019-03-12 16:46:24',10,0),('1','72',82461,'EVENING SHIFT','2019-03-11','2019-03-11 00:00:00',NULL,'408',171294.75,171294.75,'408','2019-03-12 16:49:18','408','2019-03-12 16:50:13',10,0),('1','72',82462,'EVENING SHIFT','2019-03-12','2019-03-12 00:00:00',NULL,'408',147998.25,147998.25,'408','2019-03-13 15:01:15','408','2019-03-13 15:01:50',10,0),('1','72',82564,'EVENING SHIFT','2019-03-13','2019-03-13 00:00:00',NULL,'408',49324.50,49324.50,'408','2019-03-14 16:12:00','408','2019-03-14 16:12:48',10,0),('1','72',82700,'EVENING SHIFT','2019-03-14','2019-03-14 00:00:00',NULL,'408',24662.25,24662.25,'408','2019-03-16 11:36:02','408','2019-03-16 11:36:47',10,0),('1','72',82876,'EVENING SHIFT','2019-03-15','2019-03-15 00:00:00',NULL,'408',50841.00,50841.00,'408','2019-03-16 11:38:48','408','2019-03-16 11:39:37',10,0),('1','72',82878,'EVENING SHIFT','2019-03-16','2019-03-16 00:00:00',NULL,'408',115485.75,115485.75,'408','2019-03-18 12:20:32','408','2019-03-18 12:21:04',10,0),('1','72',83188,'EVENING SHIFT','2019-03-17','2019-03-17 00:00:00',NULL,'408',36609.75,36609.75,'408','2019-03-19 09:25:46','408','2019-03-19 09:26:33',10,0),('1','72',83190,'EVENING SHIFT','2019-03-18','2019-03-18 00:00:00',NULL,'408',51945.75,51945.75,'408','2019-03-19 09:28:30','408','2019-03-19 09:29:03',10,0),('1','72',83192,'EVENING SHIFT','2019-03-19','2019-03-19 00:00:00',NULL,'408',73251.00,73251.00,'408','2019-03-20 14:53:33','408','2019-03-20 14:54:12',10,0),('1','72',83415,'EVENING SHIFT','2019-03-20','2019-03-20 00:00:00',NULL,'408',22900.50,22900.50,'408','2019-03-22 09:24:16','408','2019-03-22 09:24:54',10,0),('1','72',83580,'EVENING SHIFT','2019-03-21','2019-03-21 00:00:00',NULL,'408',29180.25,29180.25,'408','2019-03-22 09:27:46','408','2019-03-22 09:28:20',10,0),('1','72',83581,'EVENING SHIFT','2019-03-22','2019-03-22 00:00:00',NULL,'408',14748.75,14748.75,'408','2019-03-27 10:56:52','408','2019-03-27 10:57:31',10,0),('1','72',84187,'EVENING SHIFT','2019-03-23','2019-03-23 00:00:00',NULL,'408',21501.00,21501.00,'408','2019-03-27 11:00:19','408','2019-03-27 11:01:39',10,0),('1','72',84188,'EVENING SHIFT','2019-03-24','2019-03-24 00:00:00',NULL,'408',39658.50,39658.50,'408','2019-03-27 11:08:11','408','2019-03-27 11:09:36',10,0),('1','72',84190,'EVENING SHIFT','2019-03-25','2019-03-25 00:00:00',NULL,'408',22050.00,22050.00,'408','2019-03-27 11:12:19','408','2019-03-27 11:13:23',10,0),('1','72',84192,'EVENING SHIFT','2019-03-26','2019-03-26 00:00:00',NULL,'408',15399.00,15399.00,'408','2019-03-27 11:15:28','408','2019-03-27 11:16:10',10,0),('1','72',84193,'EVENING SHIFT','2019-03-27','2019-03-27 00:00:00',NULL,'408',55750.50,55750.50,'408','2019-03-28 14:32:44','408','2019-03-28 14:33:25',10,0),('1','72',84394,'EVENING SHIFT','2019-03-28','2019-03-28 00:00:00',NULL,'408',20949.75,20949.75,'408','2019-03-29 14:12:42','408','2019-03-29 14:13:18',10,0),('1','72',84496,'EVENING SHIFT','2019-03-29','2019-03-29 00:00:00',NULL,'408',15300.00,15300.00,'408','2019-04-01 09:09:02','408','2019-04-01 09:11:24',10,0),('1','72',84808,'EVENING SHIFT','2019-03-30','2019-03-30 00:00:00',NULL,'408',100350.00,100350.00,'408','2019-04-01 09:20:36','408','2019-04-01 09:22:17',10,0),('1','72',84809,'EVENING SHIFT','2019-03-31','2019-03-31 00:00:00',NULL,'408',13997.25,13997.25,'408','2019-04-01 09:25:59','408','2019-04-01 09:26:34',10,0),('1','72',84812,'EVENING SHIFT','2019-04-01','2019-04-01 00:00:00',NULL,'408',34195.50,34195.50,'408','2019-04-02 08:10:16','408','2019-04-02 08:10:49',10,0),('1','72',84908,'EVENING SHIFT','2019-04-02','2019-04-02 00:00:00',NULL,'408',7499.25,7499.25,'408','2019-04-04 08:08:45','408','2019-04-04 08:09:47',10,0),('1','72',85145,'EVENING SHIFT','2019-04-03','2019-04-03 00:00:00',NULL,'408',23199.75,23199.75,'408','2019-04-04 08:12:40','408','2019-04-04 08:13:46',10,0),('1','72',85147,'EVENING SHIFT','2019-04-04','2019-04-04 00:00:00',NULL,'408',35352.00,35352.00,'408','2019-04-05 09:06:28','408','2019-04-05 09:07:29',10,0),('1','72',85271,'EVENING SHIFT','2019-04-05','2019-04-05 00:00:00',NULL,'408',22002.75,22002.75,'408','2019-04-09 14:22:14','408','2019-04-09 14:22:49',10,0),('1','72',85841,'EVENING SHIFT','2019-04-06','2019-04-06 00:00:00',NULL,'408',203213.25,203213.25,'408','2019-04-09 14:25:58','408','2019-04-09 14:26:39',10,0),('1','72',85842,'EVENING SHIFT','2019-04-07','2019-04-07 00:00:00',NULL,'408',9702.00,9702.00,'408','2019-04-09 14:28:44','408','2019-04-09 14:29:35',10,0),('1','72',85843,'EVENING SHIFT','2019-04-08','2019-04-08 00:00:00',NULL,'408',15500.25,15500.25,'408','2019-04-09 14:33:02','408','2019-04-09 14:34:11',10,0),('1','72',85847,'EVENING SHIFT','2019-04-09','2019-04-09 00:00:00',NULL,'408',7998.75,7998.75,'408','2019-04-10 12:07:14','408','2019-04-10 12:07:42',10,0),('1','72',85940,'EVENING SHIFT','2019-04-10','2019-04-10 00:00:00',NULL,'408',63094.50,63094.50,'408','2019-04-11 14:25:50','408','2019-04-11 14:26:28',10,0),('1','72',86103,'EVENING SHIFT','2019-04-11','2019-04-11 00:00:00',NULL,'408',114050.25,114050.25,'408','2019-04-15 14:52:35','408','2019-04-15 14:53:16',10,0),('1','72',86601,'EVENING SHIFT','2019-04-12','2019-04-12 00:00:00',NULL,'408',41955.75,41955.75,'408','2019-04-15 14:55:07','408','2019-04-15 14:55:44',10,0),('1','72',86605,'EVENING SHIFT','2019-04-13','2019-04-13 00:00:00',NULL,'408',28750.50,28750.50,'408','2019-04-15 15:00:26','408','2019-04-15 15:01:17',10,0),('1','72',86608,'EVENING SHIFT','2019-04-14','2019-04-14 00:00:00',NULL,'408',10759.50,10759.50,'408','2019-04-15 15:03:21','408','2019-04-15 15:04:12',10,0),('1','72',86612,'EVENING SHIFT','2019-04-15','2019-04-15 00:00:00',NULL,'408',11101.50,11101.50,'408','2019-04-16 17:36:35','408','2019-04-16 17:37:08',10,0),('1','72',86783,'EVENING SHIFT','2019-04-16','2019-04-16 00:00:00',NULL,'408',87750.00,87750.00,'408','2019-04-17 13:08:22','408','2019-04-17 13:09:04',10,0),('1','72',86859,'EVENING SHIFT','2019-04-17','2019-04-17 00:00:00',NULL,'408',129330.00,129330.00,'408','2019-04-18 11:32:17','408','2019-04-18 11:32:55',10,0),('1','72',86964,'EVENING SHIFT','2019-04-18','2019-04-18 00:00:00',NULL,'408',316950.75,316950.75,'408','2019-04-23 16:39:11','408','2019-04-23 16:39:48',10,0),('1','72',87608,'EVENING SHIFT','2019-04-19','2019-04-19 00:00:00',NULL,'408',11972.25,11972.25,'408','2019-04-23 16:43:52','408','2019-04-23 16:44:31',10,0),('1','72',87609,'EVENING SHIFT','2019-04-20','2019-04-20 00:00:00',NULL,'408',11601.00,11601.00,'408','2019-04-23 16:46:34','408','2019-04-23 16:47:06',10,0),('1','72',87610,'EVENING SHIFT','2019-04-21','2019-04-21 00:00:00',NULL,'408',92452.50,92452.50,'408','2019-04-23 16:49:22','408','2019-04-23 16:49:59',10,0),('1','72',87611,'EVENING SHIFT','2019-04-22','2019-04-22 00:00:00',NULL,'408',15282.00,15282.00,'408','2019-04-23 16:52:38','408','2019-04-23 16:53:09',10,0),('1','72',87613,'EVENING SHIFT','2019-04-23','2019-04-23 00:00:00',NULL,'408',11400.75,11400.75,'408','2019-04-24 13:19:23','408','2019-04-24 13:20:29',10,0),('1','72',87698,'EVENING SHIFT','2019-04-24','2019-04-24 00:00:00',NULL,'408',107151.75,107151.75,'408','2019-04-25 16:24:48','408','2019-04-25 16:25:20',10,0),('1','72',87879,'EVENING SHIFT','2019-04-25','2019-04-25 00:00:00',NULL,'408',38281.50,38281.50,'408','2019-04-29 10:05:49','408','2019-04-29 10:06:21',10,0),('1','72',88299,'EVENING SHIFT','2019-04-26','2019-04-26 00:00:00',NULL,'408',23501.25,23501.25,'408','2019-04-29 10:08:20','408','2019-04-29 10:09:06',10,0),('1','72',88301,'EVENING SHIFT','2019-04-27','2019-04-27 00:00:00',NULL,'408',68199.75,68199.75,'408','2019-04-29 10:11:40','408','2019-04-29 10:12:24',10,0),('1','72',88303,'EVENING SHIFT','2019-04-28','2019-04-28 00:00:00',NULL,'408',48249.00,48249.00,'408','2019-04-29 10:15:40','408','2019-04-29 10:16:24',10,0),('1','72',88305,'EVENING SHIFT','2019-04-29','2019-04-29 00:00:00',NULL,'408',32809.50,32809.50,'408','2019-05-02 13:27:33','408','2019-05-02 13:28:26',10,0),('1','72',88733,'EVENING SHIFT','2019-04-30','2019-04-30 00:00:00',NULL,'408',12748.50,12748.50,'408','2019-05-02 13:32:54','408','2019-05-02 13:33:45',10,0),('1','72',88738,'EVENING SHIFT','2019-05-01','2019-05-01 00:00:00',NULL,'408',177810.75,177810.75,'408','2019-05-02 13:48:55','408','2019-05-02 13:50:01',10,0),('1','72',88741,'EVENING SHIFT','2019-05-02','2019-05-02 00:00:00',NULL,'408',247968.00,247968.00,'408','2019-05-07 15:25:22','408','2019-05-07 15:26:09',10,0),('1','72',89399,'EVENING SHIFT','2019-05-03','2019-05-03 00:00:00',NULL,'408',113420.25,113420.25,'408','2019-05-07 15:31:31','408','2019-05-07 15:33:25',10,0),('1','72',89401,'EVENING SHIFT','2019-05-04','2019-05-04 00:00:00',NULL,'408',23697.00,23697.00,'408','2019-05-07 15:35:41','408','2019-05-07 15:36:27',10,0),('1','72',89405,'EVENING SHIFT','2019-05-05','2019-05-05 00:00:00',NULL,'408',33750.00,33750.00,'408','2019-05-07 15:40:44','408','2019-05-07 15:41:29',10,0),('1','72',89406,'EVENING SHIFT','2019-05-06','2019-05-06 00:00:00',NULL,'408',27499.50,27499.50,'408','2019-05-07 15:44:22','408','2019-05-07 15:45:14',10,0),('1','72',89407,'EVENING SHIFT','2019-05-07','2019-05-07 00:00:00',NULL,'408',10894.50,10894.50,'408','2019-05-08 10:54:58','408','2019-05-08 10:55:34',10,0),('1','72',89471,'EVENING SHIFT','2019-05-08','2019-05-08 00:00:00',NULL,'408',7798.50,7798.50,'408','2019-05-13 13:20:53','408','2019-05-13 13:21:38',10,0),('1','72',90102,'EVENING SHIFT','2019-05-09','2019-05-09 00:00:00',NULL,'408',200715.75,200715.75,'408','2019-05-13 13:24:39','408','2019-05-13 13:25:39',10,0),('1','72',90104,'EVENING SHIFT','2019-05-10','2019-05-10 00:00:00',NULL,'408',33464.25,33464.25,'408','2019-05-13 13:27:38','408','2019-05-13 13:28:31',10,0),('1','72',90105,'EVENING SHIFT','2019-05-11','2019-05-11 00:00:00',NULL,'408',116914.50,116914.50,'408','2019-05-13 13:30:52','408','2019-05-13 13:31:24',10,0),('1','72',90108,'EVENING SHIFT','2019-05-12','2019-05-12 00:00:00',NULL,'408',22500.00,22500.00,'408','2019-05-13 13:33:22','408','2019-05-13 13:34:32',10,0),('1','72',90111,'EVENING SHIFT','2019-05-13','2019-05-13 00:00:00',NULL,'408',17448.75,17448.75,'408','2019-05-14 16:15:49','408','2019-05-14 16:16:38',10,0),('1','72',90307,'EVENING SHIFT','2019-05-14','2019-05-14 00:00:00',NULL,'408',21957.75,21957.75,'408','2019-05-15 14:13:44','408','2019-05-15 14:15:17',10,0),('1','72',90401,'EVENING SHIFT','2019-05-15','2019-05-15 00:00:00',NULL,'408',45483.75,45483.75,'408','2019-05-16 15:59:23','408','2019-05-16 16:00:01',10,0),('1','72',90554,'EVENING SHIFT','2019-05-16','2019-05-16 00:00:00',NULL,'408',96999.75,96999.75,'408','2019-05-17 10:00:26','408','2019-05-17 10:01:00',10,0),('1','72',90596,'EVENING SHIFT','2019-05-17','2019-05-17 00:00:00',NULL,'408',133049.25,133049.25,'408','2019-05-21 12:08:41','408','2019-05-21 12:09:14',10,0),('1','72',91136,'EVENING SHIFT','2019-05-18','2019-05-18 00:00:00',NULL,'408',114916.50,114916.50,'408','2019-05-21 12:11:33','408','2019-05-21 12:12:14',10,0),('1','72',91139,'EVENING SHIFT','2019-05-19','2019-05-19 00:00:00',NULL,'408',36477.00,36477.00,'408','2019-05-21 12:15:40','408','2019-05-21 12:16:17',10,0),('1','72',91140,'EVENING SHIFT','2019-05-20','2019-05-20 00:00:00',NULL,'408',20504.25,20504.25,'408','2019-05-21 12:18:37','408','2019-05-21 12:19:23',10,0),('1','72',91142,'EVENING SHIFT','2019-05-21','2019-05-21 00:00:00',NULL,'408',96075.00,96075.00,'408','2019-05-22 14:18:14','408','2019-05-22 14:18:52',10,0),('1','72',91295,'EVENING SHIFT','2019-05-22','2019-05-22 00:00:00',NULL,'408',170460.00,170460.00,'408','2019-05-23 11:53:28','408','2019-05-23 11:54:09',10,0),('1','72',91381,'EVENING SHIFT','2019-05-23','2019-05-23 00:00:00',NULL,'408',358251.75,358251.75,'408','2019-05-24 16:39:00','408','2019-05-24 16:39:59',10,0),('1','72',91551,'EVENING SHIFT','2019-05-24','2019-05-24 00:00:00',NULL,'408',74052.00,74052.00,'408','2019-05-28 12:08:02','408','2019-05-28 12:08:44',10,0),('1','72',91979,'EVENING SHIFT','2019-05-25','2019-05-25 00:00:00',NULL,'408',136694.25,136694.25,'408','2019-05-28 12:13:28','408','2019-05-28 12:15:31',10,0),('1','72',91981,'EVENING SHIFT','2019-05-26','2019-05-26 00:00:00',NULL,'408',20853.00,20853.00,'408','2019-05-28 12:19:26','408','2019-05-28 12:20:39',10,0),('1','72',91985,'EVENING SHIFT','2019-05-27','2019-05-27 00:00:00',NULL,'408',222657.75,222657.75,'408','2019-05-28 12:27:28','408','2019-05-28 12:28:23',10,0),('1','72',91986,'EVENING SHIFT','2019-05-28','2019-05-28 00:00:00',NULL,'408',37086.75,37086.75,'408','2019-06-10 15:16:30','408','2019-06-10 15:17:03',10,0),('1','72',93440,'EVENING SHIFT','2019-05-29','2019-05-29 00:00:00',NULL,'408',10305.00,10305.00,'408','2019-06-10 15:21:30','408','2019-06-10 15:22:01',10,0),('1','72',93573,'EVENING SHIFT','2019-05-30','2019-05-30 00:00:00',NULL,'408',31500.00,31500.00,'408','2019-06-11 12:43:31','408','2019-06-11 12:44:30',10,0),('1','72',93574,'EVENING SHIFT','2019-05-31','2019-05-31 00:00:00',NULL,'408',11400.75,11400.75,'408','2019-06-11 12:48:01','408','2019-06-11 12:48:51',10,0),('1','72',93576,'EVENING SHIFT','2019-06-01','2019-06-01 00:00:00',NULL,'408',109759.50,109759.50,'408','2019-06-11 16:07:09','408','2019-06-11 16:08:16',10,0),('1','72',93621,'EVENING SHIFT','2019-06-02','2019-06-02 00:00:00',NULL,'408',33423.75,33423.75,'408','2019-06-11 16:11:10','408','2019-06-11 16:11:42',10,0),('1','72',93622,'EVENING SHIFT','2019-06-03','2019-06-03 00:00:00',NULL,'408',11373.75,11373.75,'408','2019-06-11 16:13:45','408','2019-06-11 16:14:22',10,0),('1','72',93623,'EVENING SHIFT','2019-06-04','2019-06-04 00:00:00',NULL,'408',0.00,0.00,'408','2019-06-11 16:24:45','408','2019-06-11 16:25:23',10,0),('1','72',93624,'EVENING SHIFT','2019-06-05','2019-06-05 00:00:00',NULL,'408',12426.75,12426.75,'408','2019-06-11 16:28:06','408','2019-06-11 16:28:38',10,0),('1','72',93626,'EVENING SHIFT','2019-06-06','2019-06-06 00:00:00',NULL,'408',10399.50,10399.50,'408','2019-06-11 16:31:33','408','2019-06-11 16:31:59',10,0),('1','72',93629,'EVENING SHIFT','2019-06-07','2019-06-07 00:00:00',NULL,'408',40252.50,40252.50,'408','2019-06-11 16:33:50','408','2019-06-11 16:34:29',10,0),('1','72',93631,'EVENING SHIFT','2019-06-08','2019-06-08 00:00:00',NULL,'408',18769.50,18769.50,'408','2019-06-11 16:48:32','408','2019-06-11 16:49:11',10,0),('1','72',93632,'EVENING SHIFT','2019-06-09','2019-06-09 00:00:00',NULL,'408',130189.50,130189.50,'408','2019-06-11 16:51:21','408','2019-06-11 16:52:01',10,0),('1','72',93634,'EVENING SHIFT','2019-06-10','2019-06-10 00:00:00',NULL,'408',129251.25,129251.25,'408','2019-06-11 16:55:08','408','2019-06-11 16:55:40',10,0),('1','72',93635,'EVENING SHIFT','2019-06-11','2019-06-11 00:00:00',NULL,'408',164198.25,164198.25,'408','2019-06-13 09:18:09','408','2019-06-13 09:18:42',10,0),('1','72',93836,'EVENING SHIFT','2019-06-12','2019-06-12 00:00:00',NULL,'408',179991.00,179991.00,'408','2019-06-13 09:20:40','408','2019-06-13 09:21:08',10,0),('1','72',93839,'EVENING SHIFT','2019-06-13','2019-06-13 00:00:00',NULL,'408',81999.00,81999.00,'408','2019-06-14 10:17:22','408','2019-06-14 10:17:50',10,0),('1','72',93984,'EVENING SHIFT','2019-06-14','2019-06-14 00:00:00',NULL,'408',34789.50,34789.50,'408','2019-06-17 16:19:17','408','2019-06-17 16:20:14',10,0),('1','72',94397,'EVENING SHIFT','2019-06-15','2019-06-15 00:00:00',NULL,'408',20533.50,20533.50,'408','2019-06-17 16:23:24','408','2019-06-17 16:23:54',10,0),('1','72',94399,'EVENING SHIFT','2019-06-16','2019-06-16 00:00:00',NULL,'408',10001.25,10001.25,'408','2019-06-18 11:17:43','408','2019-06-18 11:18:43',10,0),('1','72',94480,'EVENING SHIFT','2019-06-17','2019-06-17 00:00:00',NULL,'408',22898.25,22898.25,'408','2019-06-18 11:44:26','408','2019-06-18 11:45:21',10,0),('1','72',94484,'EVENING SHIFT','2019-06-18','2019-06-18 00:00:00',NULL,'408',11484.00,11484.00,'408','2019-06-19 14:15:49','408','2019-06-19 14:16:41',10,0),('1','72',94635,'EVENING SHIFT','2019-06-19','2019-06-19 00:00:00',NULL,'408',18699.75,18699.75,'408','2019-06-20 21:19:20','408','2019-06-20 21:26:12',10,0),('1','72',94795,'EVENING SHIFT','2019-06-20','2019-06-20 00:00:00',NULL,'408',85396.50,85396.50,'408','2019-06-28 11:57:33','408','2019-06-28 11:58:11',10,0),('1','72',95487,'EVENING SHIFT','2019-06-21','2019-06-21 00:00:00',NULL,'408',18801.00,18801.00,'408','2019-06-28 12:00:20','408','2019-06-28 12:01:08',10,0),('1','72',95488,'EVENING SHIFT','2019-06-22','2019-06-22 00:00:00',NULL,'408',16701.75,16701.75,'408','2019-06-28 12:03:01','408','2019-06-28 12:03:36',10,0),('1','72',95490,'EVENING SHIFT','2019-06-23','2019-06-23 00:00:00',NULL,'408',45850.50,45850.50,'408','2019-06-28 12:06:29','408','2019-06-28 12:07:00',10,0),('1','72',95491,'EVENING SHIFT','2019-06-24','2019-06-24 00:00:00',NULL,'408',37325.25,37325.25,'408','2019-06-28 12:09:13','408','2019-06-29 10:21:26',10,0),('1','72',95598,'EVENING SHIFT','2019-06-25','2019-06-25 00:00:00',NULL,'408',67999.50,67999.50,'408','2019-06-29 10:25:54','408','2019-06-29 10:26:31',10,0),('1','72',95601,'EVENING SHIFT','2019-06-26','2019-06-26 00:00:00',NULL,'408',126099.00,126099.00,'408','2019-06-29 10:32:39','408','2019-06-29 10:33:18',10,0),('1','72',95602,'EVENING SHIFT','2019-06-27','2019-06-27 00:00:00',NULL,'408',27472.50,27472.50,'408','2019-06-29 10:36:17','408','2019-06-29 10:36:49',10,0),('1','72',95764,'EVENING SHIFT','2019-06-28','2019-06-28 00:00:00',NULL,'408',41463.00,41463.00,'408','2019-06-30 10:38:51','408','2019-06-30 10:39:46',10,0),('1','72',95766,'EVENING SHIFT','2019-06-29','2019-06-29 00:00:00',NULL,'408',250398.00,250398.00,'408','2019-06-30 22:01:42','408','2019-06-30 22:02:27',10,0),('1','72',95855,'EVENING SHIFT','2019-06-30','2019-06-30 00:00:00',NULL,'408',19248.75,19248.75,'408','2019-07-01 12:19:37','408','2019-07-01 12:20:36',10,0),('1','72',95935,'EVENING SHIFT','2019-07-01','2019-07-01 00:00:00',NULL,'408',83497.50,83497.50,'408','2019-07-04 09:38:31','408','2019-07-04 09:39:04',10,0),('1','72',96271,'EVENING SHIFT','2019-07-02','2019-07-02 00:00:00',NULL,'408',12001.50,12001.50,'408','2019-07-04 09:42:18','408','2019-07-04 09:42:53',10,0),('1','72',96272,'EVENING SHIFT','2019-07-03','2019-07-03 00:00:00',NULL,'408',54657.00,54657.00,'408','2019-07-04 09:45:30','408','2019-07-04 09:46:38',10,0),('1','72',96274,'EVENING SHIFT','2019-07-04','2019-07-04 00:00:00',NULL,'408',61035.75,61035.75,'408','2019-07-05 10:13:32','408','2019-07-05 10:14:35',10,0),('1','72',96399,'EVENING SHIFT','2019-07-05','2019-07-05 00:00:00',NULL,'408',210654.00,210654.00,'408','2019-07-09 09:48:26','408','2019-07-09 09:48:58',10,0),('1','72',96793,'EVENING SHIFT','2019-07-06','2019-07-06 00:00:00',NULL,'408',205922.25,205922.25,'408','2019-07-09 09:56:33','408','2019-07-09 09:57:17',10,0),('1','72',96795,'EVENING SHIFT','2019-07-07','2019-07-07 00:00:00',NULL,'408',29751.75,29751.75,'408','2019-07-09 10:00:31','408','2019-07-09 10:01:10',10,0),('1','72',96798,'EVENING SHIFT','2019-07-08','2019-07-08 00:00:00',NULL,'408',125574.75,125574.75,'408','2019-07-09 10:03:47','408','2019-07-09 10:04:53',10,0),('1','72',96800,'EVENING SHIFT','2019-07-09','2019-07-09 00:00:00',NULL,'408',175675.50,175675.50,'408','2019-07-10 12:54:00','408','2019-07-10 12:55:02',10,0),('1','72',96960,'EVENING SHIFT','2019-07-10','2019-07-10 00:00:00',NULL,'408',197201.25,197201.25,'408','2019-07-12 15:47:04','408','2019-07-12 15:47:39',10,0),('1','72',97388,'EVENING SHIFT','2019-07-11','2019-07-11 00:00:00',NULL,'408',6999.75,6999.75,'408','2019-07-12 15:49:59','408','2019-07-12 15:51:12',10,0),('1','72',97788,'EVENING SHIFT','2019-07-12','2019-07-12 00:00:00',NULL,'408',8694.00,8500.80,'408','2019-07-15 15:21:12','408','2019-07-15 15:22:25',10,0),('1','72',97790,'EVENING SHIFT','2019-07-13','2019-07-13 00:00:00',NULL,'408',28125.00,27500.00,'408','2019-07-15 15:24:51','408','2019-07-15 15:25:40',10,0),('1','72',97792,'EVENING SHIFT','2019-07-15','2019-07-15 00:00:00',NULL,'408',9409.50,9200.40,'408','2019-07-16 12:13:59','408','2019-07-16 12:14:55',10,0),('1','72',97873,'EVENING SHIFT','2019-07-16','2019-07-16 00:00:00',NULL,'408',214317.00,209554.40,'408','2019-07-18 13:23:26','408','2019-07-18 13:24:16',10,0),('1','72',99192,'EVENING SHIFT','2019-07-17','2019-07-17 00:00:00',NULL,'408',121806.00,119099.20,'408','2019-07-23 16:29:47','408','2019-07-23 16:30:33',10,0),('1','72',99196,'EVENING SHIFT','2019-07-18','2019-07-18 00:00:00',NULL,'408',80518.50,78729.20,'408','2019-07-23 16:33:15','408','2019-07-23 16:33:52',10,0),('1','72',99199,'EVENING SHIFT','2019-07-19','2019-07-19 00:00:00',NULL,'408',10723.50,10485.20,'408','2019-07-23 16:41:28','408','2019-07-23 16:42:04',10,0),('1','72',99201,'EVENING SHIFT','2019-07-20','2019-07-20 00:00:00',NULL,'408',128108.25,125261.40,'408','2019-07-23 16:44:35','408','2019-07-23 16:45:12',10,0),('1','72',99203,'EVENING SHIFT','2019-07-21','2019-07-21 00:00:00',NULL,'408',172453.50,168621.20,'408','2019-07-23 16:47:44','408','2019-07-23 16:48:22',10,0),('1','72',99517,'EVENING SHIFT','2019-07-24','2019-07-24 00:00:00',NULL,'408',16317.40,16317.40,'408','2019-07-26 09:00:59','408','2019-07-26 09:01:36',10,0),('1','72',99518,'EVENING SHIFT','2019-07-25','2019-07-25 00:00:00',NULL,'408',248470.20,248470.20,'408','2019-07-26 18:58:01','408','2019-07-26 18:59:19',10,0),('1','72',99616,'EVENING SHIFT','2019-07-26','2019-07-26 00:00:00',NULL,'408',114798.20,114798.20,'408','2019-07-30 11:58:45','408','2019-07-30 11:59:39',10,0),('1','72',100048,'EVENING SHIFT','2019-07-27','2019-07-27 00:00:00',NULL,'408',135282.40,135282.40,'408','2019-07-30 12:01:40','408','2019-07-30 12:02:17',10,0),('1','72',100049,'EVENING SHIFT','2019-07-28','2019-07-28 00:00:00',NULL,'408',168031.60,168031.60,'408','2019-07-30 12:09:19','408','2019-07-30 12:09:58',10,0),('1','72',100052,'EVENING SHIFT','2019-07-29','2019-07-29 00:00:00',NULL,'408',128913.40,128913.40,'408','2019-07-30 12:16:34','408','2019-07-30 12:17:22',10,0),('1','72',100053,'EVENING SHIFT','2019-07-30','2019-07-30 00:00:00',NULL,'408',292184.20,292184.20,'408','2019-08-01 13:07:52','408','2019-08-01 13:08:24',10,0),('1','72',100302,'EVENING SHIFT','2019-07-31','2019-07-31 00:00:00',NULL,'408',320524.60,320524.60,'408','2019-08-01 13:10:31','408','2019-08-01 13:11:27',10,0),('1','72',100303,'EVENING SHIFT','2019-08-01','2019-08-01 00:00:00',NULL,'408',130376.40,130376.40,'408','2019-08-03 09:11:18','408','2019-08-03 09:12:11',10,0),('1','72',100439,'EVENING SHIFT','2019-08-02','2019-08-02 00:00:00',NULL,'408',72558.20,72558.20,'408','2019-08-03 09:14:46','408','2019-08-03 09:15:27',10,0),('1','72',100441,'EVENING SHIFT','2019-08-03','2019-08-03 00:00:00',NULL,'408',360126.80,360126.80,'408','2019-08-05 15:16:03','408','2019-08-05 15:16:43',10,0),('1','72',100767,'EVENING SHIFT','2019-08-04','2019-08-04 00:00:00',NULL,'408',236225.00,236225.00,'408','2019-08-05 15:18:54','408','2019-08-05 15:19:37',10,0),('1','72',100768,'EVENING SHIFT','2019-08-05','2019-08-05 00:00:00',NULL,'408',117508.60,117508.60,'408','2019-08-07 12:12:07','408','2019-08-07 12:12:49',10,0),('1','72',100980,'EVENING SHIFT','2019-08-06','2019-08-06 00:00:00',NULL,'408',155339.80,155339.80,'408','2019-08-07 12:15:20','408','2019-08-07 12:16:09',10,0),('1','72',100981,'EVENING SHIFT','2019-08-07','2019-08-07 00:00:00',NULL,'408',56903.00,56903.00,'408','2019-08-08 14:06:47','408','2019-08-08 14:07:48',10,0),('1','72',101149,'EVENING SHIFT','2019-08-08','2019-08-08 00:00:00',NULL,'408',138958.60,138958.60,'408','2019-08-09 12:18:31','408','2019-08-09 12:19:04',10,0),('1','72',101249,'EVENING SHIFT','2019-08-09','2019-08-09 00:00:00',NULL,'408',19901.20,19901.20,'408','2019-08-14 14:47:28','408','2019-08-14 14:48:05',10,0),('1','72',101809,'EVENING SHIFT','2019-08-10','2019-08-10 00:00:00',NULL,'408',53037.60,53037.60,'408','2019-08-14 14:50:09','408','2019-08-14 14:50:43',10,0),('1','72',101811,'EVENING SHIFT','2019-08-11','2019-08-11 00:00:00',NULL,'408',8588.80,8784.00,'408','2019-08-14 14:53:04','408','2019-08-14 14:54:11',10,0),('1','72',101814,'EVENING SHIFT','2019-08-12','2019-08-12 00:00:00',NULL,'408',5500.00,5500.00,'408','2019-08-14 14:56:53','408','2019-08-14 14:57:44',10,0),('1','72',101815,'EVENING SHIFT','2019-08-13','2019-08-13 00:00:00',NULL,'408',5900.40,5900.40,'408','2019-08-14 15:01:03','408','2019-08-14 15:01:37',10,0),('1','72',101817,'EVENING SHIFT','2019-08-14','2019-08-14 00:00:00',NULL,'408',248001.60,248001.60,'408','2019-08-17 15:39:08','408','2019-08-17 15:40:17',10,0),('1','72',102244,'EVENING SHIFT','2019-08-15','2019-08-15 00:00:00',NULL,'408',265482.80,265482.80,'408','2019-08-17 17:28:09','408','2019-08-17 17:29:05',10,0),('1','72',102355,'EVENING SHIFT','2019-08-16','2019-08-16 00:00:00',NULL,'408',112151.60,112151.60,'408','2019-08-18 16:58:25','408','2019-08-18 16:59:03',10,0),('1','72',102357,'EVENING SHIFT','2019-08-17','2019-08-17 00:00:00',NULL,'408',93005.00,93005.00,'408','2019-08-20 16:07:16','408','2019-08-20 16:07:46',10,0),('1','72',102604,'EVENING SHIFT','2019-08-18','2019-08-18 00:00:00',NULL,'408',228428.20,228428.20,'408','2019-08-20 16:10:49','408','2019-08-20 16:11:33',10,0),('1','72',102606,'EVENING SHIFT','2019-08-19','2019-08-19 00:00:00',NULL,'408',11349.80,11349.80,'408','2019-08-20 16:16:48','408','2019-08-20 16:17:39',10,0),('1','72',102780,'EVENING SHIFT','2019-08-20','2019-08-20 00:00:00',NULL,'408',314439.40,314439.40,'408','2019-08-21 17:05:53','408','2019-08-21 17:07:04',10,0),('1','72',102781,'EVENING SHIFT','2019-08-21','2019-08-21 00:00:00',NULL,'408',264803.00,258784.75,'408','2019-08-26 19:17:18','408','2019-08-26 19:21:36',10,0),('1','72',103406,'EVENING SHIFT','2019-08-22','2019-08-22 00:00:00',NULL,'408',46972.20,45904.65,'408','2019-08-26 19:24:34','408','2019-08-26 19:25:16',10,0),('1','72',103407,'EVENING SHIFT','2019-08-23','2019-08-23 00:00:00',NULL,'408',28943.20,28285.40,'408','2019-08-26 19:27:58','408','2019-08-26 19:29:10',10,0),('1','72',103408,'EVENING SHIFT','2019-08-24','2019-08-24 00:00:00',NULL,'408',119369.80,116656.85,'408','2019-08-26 19:31:53','408','2019-08-26 19:32:26',10,0),('1','72',103409,'EVENING SHIFT','2019-08-25','2019-08-25 00:00:00',NULL,'408',154926.20,151405.15,'408','2019-08-26 19:35:01','408','2019-08-26 19:35:43',10,0),('1','72',103410,'EVENING SHIFT','2019-08-26','2019-08-26 00:00:00',NULL,'408',17648.40,17247.30,'408','2019-08-27 20:40:45','408','2019-08-27 20:42:10',10,0),('1','72',103546,'EVENING SHIFT','2019-08-27','2019-08-27 00:00:00',NULL,'408',517699.60,505933.70,'408','2019-08-28 14:10:20','408','2019-08-28 14:10:54',10,0),('1','72',103637,'EVENING SHIFT','2019-08-28','2019-08-28 00:00:00',NULL,'408',28432.80,27786.60,'408','2019-08-30 14:58:55','408','2019-08-30 14:59:34',10,0),('1','72',103939,'EVENING SHIFT','2019-08-29','2019-08-29 00:00:00',NULL,'408',54782.20,53537.15,'408','2019-08-30 15:01:32','408','2019-08-30 15:02:05',10,0),('1','72',103941,'EVENING SHIFT','2019-08-30','2019-08-30 00:00:00',NULL,'408',116644.00,113993.00,'408','2019-09-03 18:45:39','408','2019-09-03 18:47:29',10,0),('1','72',104452,'EVENING SHIFT','2019-08-31','2019-08-31 00:00:00',NULL,'408',347998.20,340089.15,'408','2019-09-03 18:50:27','408','2019-09-03 18:51:18',10,0),('1','72',104453,'EVENING SHIFT','2019-09-01','2019-09-01 00:00:00',NULL,'408',297924.00,291153.00,'408','2019-09-03 18:54:23','408','2019-09-03 18:55:12',10,0),('1','72',104454,'EVENING SHIFT','2019-09-02','2019-09-02 00:00:00',NULL,'408',575834.60,562747.45,'408','2019-09-10 16:14:24','408','2019-09-10 16:18:16',10,0),('1','72',105304,'EVENING SHIFT','2019-09-03','2019-09-03 00:00:00',NULL,'408',147113.75,147113.75,'408','2019-09-10 16:20:51','408','2019-09-10 16:21:27',10,0),('1','72',105307,'EVENING SHIFT','2019-09-04','2019-09-04 00:00:00',NULL,'408',272439.40,272439.40,'408','2019-09-10 16:23:55','408','2019-09-10 16:24:33',10,0),('1','72',105309,'EVENING SHIFT','2019-09-05','2019-09-05 00:00:00',NULL,'408',162879.70,162879.70,'408','2019-09-10 16:27:40','408','2019-09-10 16:28:25',10,0),('1','72',105311,'EVENING SHIFT','2019-09-06','2019-09-06 00:00:00',NULL,'408',335630.05,335630.05,'408','2019-09-10 16:30:24','408','2019-09-10 16:31:02',10,0),('1','72',105313,'EVENING SHIFT','2019-09-07','2019-09-07 00:00:00',NULL,'408',21801.00,21801.00,'408','2019-09-10 16:33:06','408','2019-09-10 16:33:43',10,0),('1','72',105316,'EVENING SHIFT','2019-09-08','2019-09-08 00:00:00',NULL,'408',174031.75,174031.75,'408','2019-09-10 16:35:37','408','2019-09-10 16:36:25',10,0),('1','72',105317,'EVENING SHIFT','2019-09-09','2019-09-09 00:00:00',NULL,'408',25475.35,25475.35,'408','2019-09-10 16:38:40','408','2019-09-10 16:39:18',10,0),('1','72',105319,'EVENING SHIFT','2019-09-10','2019-09-10 00:00:00',NULL,'408',318599.90,318599.90,'408','2019-09-11 16:31:51','408','2019-09-11 16:32:27',10,0),('1','72',105441,'EVENING SHIFT','2019-09-11','2019-09-11 00:00:00',NULL,'408',278014.35,278014.35,'408','2019-09-13 15:51:31','408','2019-09-13 15:52:01',10,0),('1','72',105704,'EVENING SHIFT','2019-09-12','2019-09-12 00:00:00',NULL,'408',670939.75,670939.75,'408','2019-09-13 15:54:36','408','2019-09-13 15:55:20',10,0),('1','72',105707,'EVENING SHIFT','2019-09-13','2019-09-13 00:00:00',NULL,'408',223359.20,223359.20,'408','2019-09-16 18:35:08','408','2019-09-16 18:36:07',10,0),('1','72',106101,'EVENING SHIFT','2019-09-14','2019-09-14 00:00:00',NULL,'408',187310.15,187310.15,'408','2019-09-16 18:38:28','408','2019-09-16 18:39:15',10,0),('1','72',106407,'EVENING SHIFT','2019-09-18','2019-09-18 00:00:00',NULL,'408',181008.50,181008.50,'408','2019-09-18 19:36:12','408','2019-09-18 19:37:04',10,0),('1','72',106408,'EVENING SHIFT','2019-09-19','2019-09-19 00:00:00',NULL,'408',34251.65,34251.65,'408','2019-09-20 10:38:07','408','2019-09-20 10:40:35',10,0),('1','72',106616,'EVENING SHIFT','2019-09-20','2019-09-20 00:00:00',NULL,'408',237979.20,237979.20,'408','2019-09-24 19:22:56','408','2019-09-24 19:23:39',10,0),('1','72',107245,'EVENING SHIFT','2019-09-21','2019-09-21 00:00:00',NULL,'408',143205.05,143205.05,'408','2019-09-24 19:26:24','408','2019-09-24 19:27:11',10,0),('1','72',107246,'EVENING SHIFT','2019-09-22','2019-09-22 00:00:00',NULL,'408',293752.35,293752.35,'408','2019-09-24 19:29:11','408','2019-09-24 19:30:05',10,0),('1','72',107247,'EVENING SHIFT','2019-09-23','2019-09-23 00:00:00',NULL,'408',294547.85,294547.85,'408','2019-09-24 19:32:25','408','2019-09-24 19:35:49',10,0),('1','72',108010,'EVENING SHIFT','2019-09-27','2019-09-27 00:00:00',NULL,'408',217111.30,217111.30,'408','2019-09-30 13:38:05','408','2019-09-30 13:39:24',10,0),('1','72',108013,'EVENING SHIFT','2019-09-28','2019-09-28 00:00:00',NULL,'408',169675.85,169675.85,'408','2019-09-30 13:43:06','408','2019-09-30 13:43:57',10,0),('1','72',108016,'EVENING SHIFT','2019-09-29','2019-09-29 00:00:00',NULL,'408',264198.45,264198.45,'408','2019-09-30 13:46:53','408','2019-09-30 13:48:17',10,0),('1','72',108017,'EVENING SHIFT','2019-09-30','2019-09-30 00:00:00',NULL,'408',13357.95,13357.95,'408','2019-10-02 21:46:23','408','2019-10-02 21:47:12',10,0),('1','72',108316,'EVENING SHIFT','2019-10-01','2019-10-01 00:00:00',NULL,'408',256428.35,256428.35,'408','2019-10-02 21:49:29','408','2019-10-02 21:50:30',10,0),('1','72',108317,'EVENING SHIFT','2019-10-02','2019-10-02 00:00:00',NULL,'408',125886.80,125886.80,'408','2019-10-03 20:46:26','408','2019-10-03 20:47:34',10,0),('1','72',108435,'EVENING SHIFT','2019-10-03','2019-10-03 00:00:00',NULL,'408',43148.35,43148.35,'408','2019-10-08 18:14:57','408','2019-10-08 18:15:46',10,0),('1','72',109098,'EVENING SHIFT','2019-10-04','2019-10-04 00:00:00',NULL,'408',23604.85,23604.85,'408','2019-10-08 18:17:53','408','2019-10-08 18:18:37',10,0),('1','72',109099,'EVENING SHIFT','2019-10-05','2019-10-05 00:00:00',NULL,'408',126267.35,126267.35,'408','2019-10-08 18:21:23','408','2019-10-08 18:22:01',10,0),('1','72',109100,'EVENING SHIFT','2019-10-06','2019-10-06 00:00:00',NULL,'408',196976.55,196976.55,'408','2019-10-08 18:24:26','408','2019-10-08 18:25:24',10,0),('1','72',109101,'EVENING SHIFT','2019-10-07','2019-10-07 00:00:00',NULL,'408',15499.35,15499.35,'408','2019-10-08 18:27:33','408','2019-10-08 18:28:38',10,0),('1','72',109102,'EVENING SHIFT','2019-10-08','2019-10-08 00:00:00',NULL,'408',142572.95,142572.95,'408','2019-10-09 19:11:48','408','2019-10-09 19:12:31',10,0),('1','72',109255,'EVENING SHIFT','2019-10-09','2019-10-09 00:00:00',NULL,'408',178073.75,178073.75,'408','2019-10-13 19:21:18','408','2019-10-13 19:22:07',10,0),('1','72',109723,'EVENING SHIFT','2019-10-10','2019-10-10 00:00:00',NULL,'408',14037.35,14037.35,'408','2019-10-13 19:26:15','408','2019-10-13 19:27:39',10,0),('1','72',109724,'EVENING SHIFT','2019-10-11','2019-10-11 00:00:00',NULL,'408',41918.55,41918.55,'408','2019-10-13 19:30:50','408','2019-10-13 19:31:36',10,0),('1','72',109725,'EVENING SHIFT','2019-10-12','2019-10-12 00:00:00',NULL,'408',44984.45,44984.45,'408','2019-10-13 19:35:04','408','2019-10-13 19:36:03',10,0),('1','72',109726,'EVENING SHIFT','2019-10-13','2019-10-13 00:00:00',NULL,'408',245164.50,245164.50,'408','2019-10-14 19:40:50','408','2019-10-14 19:41:33',10,0),('1','72',109875,'EVENING SHIFT','2019-10-14','2019-10-14 00:00:00',NULL,'408',185342.90,185342.90,'408','2019-10-16 18:24:22','408','2019-10-16 18:24:58',10,0),('1','72',110101,'EVENING SHIFT','2019-10-15','2019-10-15 00:00:00',NULL,'408',206010.85,206010.85,'408','2019-10-16 18:27:25','408','2019-10-16 18:28:28',10,0),('1','72',110102,'EVENING SHIFT','2019-10-16','2019-10-16 00:00:00',NULL,'408',16806.55,16806.55,'408','2019-10-18 18:22:57','408','2019-10-18 18:23:44',10,0),('1','72',110351,'EVENING SHIFT','2019-10-17','2019-10-17 00:00:00',NULL,'408',225648.95,225648.95,'408','2019-10-18 18:26:25','408','2019-10-18 18:27:14',10,0),('1','72',110352,'EVENING SHIFT','2019-10-18','2019-10-18 00:00:00',NULL,'408',72401.25,72401.25,'408','2019-10-21 21:03:26','408','2019-10-21 21:04:23',10,0),('1','72',110778,'EVENING SHIFT','2019-10-19','2019-10-19 00:00:00',NULL,'408',122042.60,122042.60,'408','2019-10-21 21:07:09','408','2019-10-21 21:08:08',10,0),('1','72',110779,'EVENING SHIFT','2019-10-20','2019-10-20 00:00:00',NULL,'408',275946.05,275946.05,'408','2019-10-21 21:10:32','408','2019-10-21 21:12:04',10,0),('1','72',111011,'EVENING SHIFT','2019-10-21','2019-10-21 00:00:00',NULL,'408',160903.85,160903.85,'408','2019-10-23 18:21:58','408','2019-10-23 18:23:24',10,0),('1','72',111013,'EVENING SHIFT','2019-10-22','2019-10-22 00:00:00',NULL,'408',195389.85,195389.85,'408','2019-10-23 18:27:06','408','2019-10-23 18:28:26',10,0),('1','72',111014,'EVENING SHIFT','2019-10-23','2019-10-23 00:00:00',NULL,'408',161652.05,161652.05,'408','2019-10-29 19:15:11','408','2019-10-29 19:15:45',10,0),('1','72',111745,'EVENING SHIFT','2019-10-24','2019-10-24 00:00:00',NULL,'408',247914.35,247914.35,'408','2019-10-29 19:18:10','408','2019-10-29 19:18:47',10,0),('1','72',111746,'EVENING SHIFT','2019-10-25','2019-10-25 00:00:00',NULL,'408',66245.80,66245.80,'408','2019-10-29 19:21:50','408','2019-10-29 19:22:30',10,0),('1','72',111747,'EVENING SHIFT','2019-10-26','2019-10-26 00:00:00',NULL,'408',37203.60,37203.60,'408','2019-10-29 19:24:41','408','2019-10-29 19:25:24',10,0),('1','72',111748,'EVENING SHIFT','2019-10-27','2019-10-27 00:00:00',NULL,'408',26999.70,26999.70,'408','2019-10-29 19:28:27','408','2019-10-29 19:29:30',10,0),('1','72',111750,'EVENING SHIFT','2019-10-28','2019-10-28 00:00:00',NULL,'408',69135.40,69135.40,'408','2019-10-29 19:32:13','408','2019-10-29 19:32:57',10,0),('1','72',111751,'EVENING SHIFT','2019-10-29','2019-10-29 00:00:00',NULL,'408',33613.10,33613.10,'408','2019-10-30 14:39:17','408','2019-10-30 14:40:02',10,0),('1','72',113467,'EVENING SHIFT','2019-11-13','2019-11-13 00:00:00',NULL,'408',174818.60,174818.60,'408','2019-11-14 14:58:41','408','2019-11-14 14:59:22',10,0),('1','72',113640,'EVENING SHIFT','2019-11-14','2019-11-14 00:00:00',NULL,'408',168601.40,168601.40,'408','2019-11-15 15:45:56','408','2019-11-15 15:47:02',10,0),('1','72',113770,'EVENING SHIFT','2019-11-15','2019-11-15 00:00:00',NULL,'408',112978.80,112978.80,'408','2019-11-18 08:58:56','408','2019-11-18 08:59:30',10,0),('1','72',114027,'EVENING SHIFT','2019-11-16','2019-11-16 00:00:00',NULL,'408',140056.40,140056.40,'408','2019-11-18 09:01:47','408','2019-11-18 09:02:26',10,0),('1','72',114029,'EVENING SHIFT','2019-11-17','2019-11-17 00:00:00',NULL,'408',345826.80,345826.80,'408','2019-11-18 09:04:54','408','2019-11-18 09:05:34',10,0),('1','72',114032,'EVENING SHIFT','2019-11-18','2019-11-18 00:00:00',NULL,'408',134270.40,134270.40,'408','2019-11-20 19:11:50','408','2019-11-20 19:12:33',10,0),('1','72',114379,'EVENING SHIFT','2019-11-19','2019-11-19 00:00:00',NULL,'408',114754.20,114754.20,'408','2019-11-20 19:15:04','408','2019-11-20 19:16:10',10,0),('1','72',114380,'EVENING SHIFT','2019-11-20','2019-11-20 00:00:00',NULL,'408',72080.80,72080.80,'408','2019-11-20 19:19:23','408','2019-11-20 19:20:26',10,0),('1','72',114381,'EVENING SHIFT','2019-11-21','2019-11-21 00:00:00',NULL,'408',251044.20,251044.20,'408','2019-11-21 18:13:48','408','2019-11-21 18:14:31',10,0),('1','72',114505,'EVENING SHIFT','2019-11-22','2019-11-22 00:00:00',NULL,'408',143902.00,143902.00,'408','2019-11-26 19:26:13','408','2019-11-26 19:27:01',10,0),('1','72',115235,'EVENING SHIFT','2019-11-23','2019-11-23 00:00:00',NULL,'408',164333.40,164333.40,'408','2019-11-26 19:29:09','408','2019-11-26 19:29:47',10,0),('1','72',115236,'EVENING SHIFT','2019-11-24','2019-11-24 00:00:00',NULL,'408',472507.20,472507.20,'408','2019-11-26 19:32:31','408','2019-11-26 19:33:40',10,0),('1','72',115237,'EVENING SHIFT','2019-11-25','2019-11-25 00:00:00',NULL,'408',582282.80,582282.80,'408','2019-11-26 19:37:29','408','2019-11-26 19:38:28',10,0),('1','72',115238,'EVENING SHIFT','2019-11-26','2019-11-26 00:00:00',NULL,'408',35305.60,35305.60,'408','2019-11-26 19:43:20','408','2019-11-26 19:44:00',10,0),('1','72',115239,'EVENING SHIFT','2019-11-27','2019-11-27 00:00:00',NULL,'408',172915.60,172915.60,'408','2019-11-27 18:40:21','408','2019-11-27 18:41:30',10,0),('1','72',115390,'EVENING SHIFT','2019-11-28','2019-11-28 00:00:00',NULL,'408',44759.00,44759.00,'408','2019-12-01 16:43:12','408','2019-12-01 16:43:59',10,0),('1','72',115783,'EVENING SHIFT','2019-11-29','2019-11-29 00:00:00',NULL,'408',47605.80,47605.80,'408','2019-12-01 16:48:22','408','2019-12-01 16:48:58',10,0),('1','72',115784,'EVENING SHIFT','2019-11-30','2019-11-30 00:00:00',NULL,'408',55250.80,55250.80,'408','2019-12-01 16:53:12','408','2019-12-01 16:58:20',10,0),('1','72',116802,'EVENING SHIPT','2019-12-09','2019-12-09 00:00:00',NULL,'408',28850.80,28850.80,'408','2019-12-10 07:57:35','408','2019-12-10 07:59:32',10,0),('1','72',116822,'EVENING SHIPT','2019-12-10','2019-12-10 00:00:00',NULL,'408',30276.40,30276.40,'408','2019-12-10 08:04:32','408','2019-12-10 12:22:06',10,0),('1','72',116869,'EVENING SHIPT','2019-12-10','2019-12-10 00:00:00',NULL,'408',302700.20,302700.20,'408','2019-12-10 12:26:07','408','2019-12-10 12:26:36',10,0),('1','72',116870,'EVENING SHIPT','2019-12-10','2019-12-10 00:00:00',NULL,'408',130805.40,130805.40,'408','2019-12-10 12:28:51','408','2019-12-10 12:29:40',10,0),('1','72',116953,'EVENING SHIPT','2019-12-10','2019-12-10 00:00:00',NULL,'408',47399.00,46321.75,'408','2019-12-10 17:40:53','408','2019-12-10 17:41:30',10,0),('1','72',116961,'EVENING SHIPT','2019-12-11','2019-12-11 00:00:00',NULL,'408',75902.20,74177.15,'408','2019-12-11 18:01:44','408','2019-12-11 18:02:22',10,0),('1','72',117099,'EVENING SHIPT','2019-12-12','2019-12-12 00:00:00',NULL,'408',106997.00,104565.25,'408','2019-12-12 18:52:12','408','2019-12-12 18:53:01',10,0),('1','72',117231,'EVENING SHIPT','2019-12-13','2019-12-13 00:00:00',NULL,'408',138465.80,135318.85,'408','2019-12-13 18:57:58','408','2019-12-13 18:59:09',10,0),('1','72',117392,'EVENING SHIPT','2019-12-14','2019-12-14 00:00:00',NULL,'408',504836.20,493362.65,'408','2019-12-14 17:56:08','408','2019-12-14 17:57:05',10,0),('1','72',117510,'EVENING SHIPT','2019-12-15','2019-12-15 00:00:00',NULL,'408',172469.00,168549.25,'408','2019-12-15 20:16:14','408','2019-12-15 20:23:41',10,0),('1','72',117613,'EVENING SHIPT','2019-12-16','2019-12-16 00:00:00',NULL,'408',442332.00,432279.00,'408','2019-12-16 17:54:52','408','2019-12-16 17:55:48',10,0),('1','72',117747,'EVENING SHIPT','2019-12-17','2019-12-17 00:00:00',NULL,'408',146795.00,143458.75,'408','2019-12-17 17:38:06','408','2019-12-17 17:38:49',10,0),('1','72',117908,'EVENING SHIPT','2019-12-18','2019-12-18 00:00:00',NULL,'408',138215.00,135073.75,'408','2019-12-18 19:07:56','408','2019-12-18 19:08:41',10,0),('1','72',118167,'EVENING SHIPT','2019-12-19','2019-12-19 00:00:00',NULL,'408',60574.80,59198.10,'408','2019-12-19 17:58:36','408','2019-12-19 17:59:13',10,0),('1','72',118311,'EVENING SHIPT','2019-12-20','2019-12-20 00:00:00',NULL,'408',16269.00,15899.25,'408','2019-12-20 18:48:14','408','2019-12-20 18:49:23',10,0),('1','72',126893,'EVENING SHIPT','2019-12-21','2019-12-21 00:00:00',NULL,'408',86818.60,84845.45,'408','2020-02-28 10:51:20','408','2020-02-28 11:08:44',10,0),('1','72',126896,'EVENING SHIFT','2019-12-22','2019-12-22 00:00:00',NULL,'408',344170.20,336348.15,'408','2020-02-28 11:15:26','408','2020-02-28 11:17:08',10,0),('1','72',126905,'EVENING SHIFT','2019-12-23','2019-12-23 00:00:00',NULL,'408',346176.60,338308.95,'408','2020-02-28 11:46:36','408','2020-02-28 11:47:19',10,0),('1','72',126908,'EVENING SHIFT','2019-12-24','2019-12-24 00:00:00',NULL,'408',88638.00,86623.50,'408','2020-02-28 11:57:13','408','2020-02-28 11:58:02',10,0),('1','72',126911,'EVENING SHIFT','2019-12-25','2019-12-25 00:00:00',NULL,'408',30771.40,30072.05,'408','2020-02-28 12:01:33','408','2020-02-28 12:02:37',10,0),('1','72',126912,'EVENING SHIPT','2019-12-26','2019-12-26 00:00:00',NULL,'408',157806.00,154219.50,'408','2020-02-28 12:06:12','408','2020-02-28 12:07:01',10,0),('1','72',126914,'EVENING SHIFT','2019-12-27','2019-12-27 00:00:00',NULL,'408',79180.20,77380.65,'408','2020-02-28 12:09:24','408','2020-02-28 12:10:11',10,0),('1','72',126916,'EVENING SHIFT','2019-12-28','2019-12-28 00:00:00',NULL,'408',35028.40,34232.30,'408','2020-02-28 12:14:02','408','2020-02-28 12:15:40',10,0),('1','72',126924,'EVENING SHIPT','2019-12-29','2019-12-29 00:00:00',NULL,'408',32744.80,32000.60,'408','2020-02-29 12:05:36','408','2020-02-29 12:06:08',10,0),('1','72',127015,'EVENING SHIPT','2019-12-30','2019-12-30 00:00:00',NULL,'408',39754.00,38850.50,'408','2020-02-29 12:09:54','408','2020-02-29 12:11:20',10,0),('1','72',127017,'EVENING SHIPT','2019-12-31','2019-12-31 00:00:00',NULL,'408',34544.40,33759.30,'408','2020-02-29 12:13:53','408','2020-02-29 12:14:32',10,0),('1','72',127018,'EVENING SHIFT','2020-01-01','2020-01-01 00:00:00',NULL,'408',13303.40,13001.05,'408','2020-02-29 12:17:10','408','2020-02-29 12:17:59',10,0),('1','72',127019,'EVENING SHIPT','2020-01-02','2020-01-02 00:00:00',NULL,'408',14020.60,13701.95,'408','2020-02-29 12:20:01','408','2020-02-29 12:21:00',10,0),('1','72',127021,'EVENING SHIPT','2020-01-03','2020-01-03 00:00:00',NULL,'408',75743.80,74022.35,'408','2020-02-29 12:24:19','408','2020-02-29 12:24:58',10,0),('1','72',127024,'EVENING SHIPT','2020-01-21','2020-01-21 00:00:00',NULL,'408',66077.00,67578.75,'408','2020-02-29 12:27:11','408','2020-02-29 12:27:45',10,0),('1','72',127026,'EVENING SHIPT','2020-01-22','2020-01-22 00:00:00',NULL,'408',156699.40,160260.75,'408','2020-02-29 12:30:41','408','2020-02-29 12:31:42',10,0),('1','72',127027,'EVENING SHIPT','2020-01-23','2020-01-23 00:00:00',NULL,'408',200809.40,205373.25,'408','2020-02-29 12:35:19','408','2020-02-29 12:36:37',10,0),('1','72',127029,'EVENING SHIPT','2020-02-24','2020-02-24 00:00:00',NULL,'408',101076.80,103374.00,'408','2020-02-29 12:39:05','408','2020-02-29 12:39:53',10,0),('1','72',127030,'EVENING SHIPT','2020-01-25','2020-01-25 00:00:00',NULL,'408',30437.00,31128.75,'408','2020-02-29 12:42:14','408','2020-02-29 12:42:49',10,0),('1','72',127032,'EVENING SHIPT','2020-01-26','2020-01-26 00:00:00',NULL,'408',89625.80,91662.75,'408','2020-02-29 12:45:35','408','2020-02-29 12:46:33',10,0),('1','72',127035,'EVENING SHIPT','2020-01-27','2020-01-27 00:00:00',NULL,'408',56548.80,57834.00,'408','2020-02-29 12:49:26','408','2020-02-29 12:50:00',10,0),('1','72',127036,'EVENING SHIPT','2020-01-28','2020-01-28 00:00:00',NULL,'408',210399.20,215181.00,'408','2020-02-29 12:52:14','408','2020-02-29 12:53:04',10,0),('1','72',127039,'EVENING SHIPT','2020-01-29','2020-01-29 00:00:00',NULL,'408',229233.40,234443.25,'408','2020-02-29 12:57:26','408','2020-02-29 12:58:08',10,0),('1','72',127041,'EVENING SHIPT','2020-01-30','2020-01-30 00:00:00',NULL,'408',71132.60,72749.25,'408','2020-02-29 13:01:37','408','2020-02-29 13:02:31',10,0),('1','72',127042,'EVENING SHIPT','2020-01-31','2020-01-31 00:00:00',NULL,'408',43806.40,44802.00,'408','2020-02-29 13:08:27','408','2020-02-29 13:09:48',10,0),('1','72',127044,'EVENING SHIPT','2020-02-01','2020-02-01 00:00:00',NULL,'408',58667.40,60000.75,'408','2020-02-29 13:14:19','408','2020-02-29 13:15:34',10,0),('1','72',127048,'EVENING SHIPT','2020-02-02','2020-02-02 00:00:00',NULL,'408',61564.80,62964.00,'408','2020-02-29 13:18:49','408','2020-02-29 13:19:56',10,0),('1','72',127051,'EVENING SHIPT','2020-02-03','2020-02-03 00:00:00',NULL,'408',139966.20,143147.25,'408','2020-02-29 13:23:06','408','2020-02-29 13:24:05',10,0),('1','72',127052,'EVENING SHIPT','2020-02-04','2020-02-04 00:00:00',NULL,'408',173016.80,176949.00,'408','2020-02-29 13:26:06','408','2020-02-29 13:26:48',10,0),('1','72',127054,'EVENING SHIPT','2020-02-05','2020-02-05 00:00:00',NULL,'408',192779.40,197160.75,'408','2020-02-29 13:29:03','408','2020-02-29 13:29:41',10,0),('1','72',127055,'EVENING SHIPT','2020-02-06','2020-02-06 00:00:00',NULL,'408',156736.80,160299.00,'408','2020-02-29 13:31:54','408','2020-02-29 13:32:29',10,0),('1','72',127056,'EVENING SHIPT','2020-02-07','2020-02-07 00:00:00',NULL,'408',56216.60,57494.25,'408','2020-02-29 13:34:13','408','2020-02-29 13:34:45',10,0),('1','72',127057,'EVENING SHIPT','2020-02-08','2020-02-08 00:00:00',NULL,'408',50256.80,51399.00,'408','2020-02-29 13:36:34','408','2020-02-29 13:37:05',10,0),('1','72',127060,'EVENING SHIPT','2020-02-09','2020-02-09 00:00:00',NULL,'408',133335.40,136365.75,'408','2020-02-29 13:39:02','408','2020-02-29 13:39:36',10,0),('1','72',127061,'EVENING SHIPT','2020-02-10','2020-02-10 00:00:00',NULL,'408',46285.80,47337.75,'408','2020-02-29 13:41:31','408','2020-02-29 13:42:07',10,0),('1','72',127062,'EVENING SHIPT','2020-02-11','2020-02-11 00:00:00',NULL,'408',165660.00,165660.00,'408','2020-02-29 13:44:35','408','2020-02-29 13:45:13',10,0),('1','72',127064,'EVENING SHIPT','2020-02-12','2020-02-12 00:00:00',NULL,'408',153610.60,153610.60,'408','2020-02-29 13:47:36','408','2020-02-29 13:48:08',10,0),('1','72',127122,'EVENING SHIPT','2020-02-13','2020-02-13 00:00:00',NULL,'408',54683.20,54683.20,'408','2020-02-29 19:31:46','408','2020-02-29 19:32:19',10,0),('1','72',127123,'EVENING SHIPT','2020-02-14','2020-02-14 00:00:00',NULL,'408',159889.40,159889.40,'408','2020-02-29 19:34:54','408','2020-02-29 19:35:49',10,0),('1','72',127124,'EVENING SHIPT','2020-02-15','2020-02-15 00:00:00',NULL,'408',239956.20,239956.20,'408','2020-02-29 19:38:35','408','2020-02-29 19:40:13',10,0),('1','72',127125,'EVENING SHIPT','2020-02-16','2020-02-16 00:00:00',NULL,'408',20996.80,20996.80,'408','2020-02-29 19:42:46','408','2020-02-29 19:43:28',10,0),('1','72',127126,'EVENING SHIPT','2020-02-17','2020-02-17 00:00:00',NULL,'408',20724.00,20724.00,'408','2020-02-29 19:46:18','408','2020-02-29 19:47:03',10,0),('1','72',127127,'EVENING SHIPT','2020-02-18','2020-02-18 00:00:00',NULL,'408',80592.60,80592.60,'408','2020-02-29 19:50:40','408','2020-02-29 19:55:12',10,0),('1','72',127128,'EVENING SHIPT','2020-02-19','2020-02-19 00:00:00',NULL,'408',89911.80,89911.80,'408','2020-02-29 19:59:03','408','2020-02-29 19:59:44',10,0),('1','72',127130,'EVENING SHIPT','2020-02-20','2020-02-20 00:00:00',NULL,'408',351826.20,351826.20,'408','2020-02-29 20:04:25','408','2020-02-29 20:05:07',10,0),('1','72',127131,'EVENING SHIPT','2020-02-20','2020-02-20 00:00:00',NULL,'408',59604.60,58249.95,'408','2020-02-29 20:08:29','408','2020-02-29 20:09:21',10,0),('1','72',127132,'EVENING SHIPT','2020-02-21','2020-02-21 00:00:00',NULL,'408',124652.00,121819.00,'408','2020-02-29 20:17:41','408','2020-02-29 20:18:24',10,0),('1','72',127133,'EVENING SHIPT','2020-02-22','2020-02-22 00:00:00',NULL,'408',58405.60,57078.20,'408','2020-02-29 20:21:25','408','2020-02-29 20:22:07',10,0),('1','72',127134,'EVENING SHIPT','2020-02-23','2020-02-23 00:00:00',NULL,'408',394598.60,385630.45,'408','2020-02-29 20:24:58','408','2020-02-29 20:25:42',10,0),('1','72',127135,'EVENING SHIPT','2020-02-24','2020-02-24 00:00:00',NULL,'408',14935.80,14596.35,'408','2020-02-29 20:28:20','408','2020-02-29 20:29:08',10,0),('1','72',127137,'EVENING SHIPT','2020-02-25','2020-02-25 00:00:00',NULL,'408',159264.60,155644.95,'408','2020-02-29 20:36:41','408','2020-02-29 20:37:32',10,0),('1','72',127138,'EVENING SHIPT','2020-02-26','2020-02-26 00:00:00',NULL,'408',112048.20,109501.65,'408','2020-02-29 20:40:33','408','2020-02-29 20:41:06',10,0),('1','72',127139,'EVENING SHIPT','2020-02-27','2020-02-27 00:00:00',NULL,'408',62451.40,61032.05,'408','2020-02-29 20:43:21','408','2020-02-29 20:45:02',10,0),('1','72',127140,'EVENING SHIPT','2020-02-28','2020-02-28 00:00:00',NULL,'408',153652.40,150160.30,'408','2020-02-29 20:47:57','408','2020-02-29 20:48:49',10,0),('1','72',127160,'EVENING SHIPT','2020-02-29','2020-02-29 00:00:00',NULL,'408',51279.80,50114.35,'408','2020-03-02 16:46:39','408','2020-03-02 16:47:53',10,0),('1','72',127345,'EVENING SHIPT','2020-03-01','2020-03-01 00:00:00',NULL,'408',110338.80,107831.10,'408','2020-03-02 16:52:53','408','2020-03-02 16:54:47',10,0),('1','72',127348,'EVENING SHIPT','2020-03-02','2020-03-02 00:00:00',NULL,'408',180439.60,176338.70,'408','2020-03-03 08:43:18','408','2020-03-03 08:44:29',10,0),('1','72',127398,'EVENING SHIFT','2020-03-03','2020-03-03 00:00:00',NULL,'408',130974.80,127998.10,'408','2020-03-07 09:48:43','408','2020-03-07 09:51:18',10,0),('1','72',127865,'EVENING SHIPT','2020-03-04','2020-03-04 00:00:00',NULL,'408',14326.40,14000.80,'408','2020-03-07 09:56:44','408','2020-03-07 09:58:08',10,0),('1','72',127867,'EVENING SHIPT','2020-03-05','2020-03-05 00:00:00',NULL,'408',125246.00,122399.50,'408','2020-03-07 10:02:25','408','2020-03-07 10:03:37',10,0),('1','72',127868,'EVENING SHIPT','2020-03-06','2020-03-06 00:00:00',NULL,'408',91986.40,89895.80,'408','2020-03-07 10:07:16','408','2020-03-07 10:09:22',10,0),('1','72',127869,'EVENING SHIPT','2020-03-07','2020-03-07 00:00:00',NULL,'408',103479.20,101127.40,'408','2020-03-08 11:39:43','408','2020-03-08 11:40:29',10,0),('1','72',127976,'EVENING SHIPT','2020-03-08','2020-03-08 00:00:00',NULL,'408',67601.60,66065.20,'408','2020-03-10 12:42:10','408','2020-03-10 12:42:36',10,0),('1','72',128233,'EVENING SHIPT','2020-03-09','2020-03-09 00:00:00',NULL,'408',42330.20,41368.15,'408','2020-03-10 12:44:16','408','2020-03-10 12:44:43',10,0),('1','72',128256,'EVENING SHIPT','2020-03-10','2020-03-10 00:00:00',NULL,'408',286484.00,279973.00,'408','2020-03-11 14:28:50','408','2020-03-11 14:29:31',10,0),('1','72',128384,'EVENING SHIPT','2020-03-11','2020-03-11 00:00:00',NULL,'408',218812.00,208866.00,'408','2020-03-12 14:03:30','408','2020-03-12 14:04:16',10,0),('1','72',128488,'EVENING SHIPT','2020-03-12','2020-03-12 00:00:00',NULL,'408',26582.60,25374.30,'408','2020-03-17 11:41:56','408','2020-03-17 11:43:09',10,0),('1','72',129160,'EVENING SHIPT','2020-03-13','2020-03-13 00:00:00',NULL,'408',226518.60,216222.30,'408','2020-03-17 11:46:03','408','2020-03-17 11:47:01',10,0),('1','72',129161,'EVENING SHIPT','2020-03-14','2020-03-14 00:00:00',NULL,'408',25093.20,23952.60,'408','2020-03-17 11:49:18','408','2020-03-17 11:49:58',10,0),('1','72',129163,'EVENING SHIPT','2020-03-15','2020-03-15 00:00:00',NULL,'408',11479.60,10957.80,'408','2020-03-17 11:52:19','408','2020-03-17 11:52:56',10,0),('1','72',129167,'EVENING SHIPT','2020-03-16','2020-03-16 00:00:00',NULL,'408',16594.60,15840.30,'408','2020-03-17 11:55:26','408','2020-03-17 11:56:01',10,0),('1','72',129169,'EVENING SHIPT','2020-03-17','2020-03-17 00:00:00',NULL,'408',53743.80,51300.90,'408','2020-03-18 12:07:23','408','2020-03-18 12:08:10',10,0),('1','72',129280,'EVENING SHIPT','2020-03-18','2020-03-18 00:00:00',NULL,'408',16027.00,15298.50,'408','2020-03-19 12:55:49','408','2020-03-19 12:57:56',10,0),('1','72',129442,'EVENING SHIPT','2020-03-19','2020-03-19 00:00:00',NULL,'408',63591.00,60700.50,'408','2020-03-24 12:36:24','408','2020-03-24 12:37:17',10,0),('1','72',130093,'EVENING SHIPT','2020-03-20','2020-03-20 00:00:00',NULL,'408',331641.20,316566.60,'408','2020-03-24 12:41:28','408','2020-03-24 12:42:43',10,0),('1','72',130096,'EVENING SHIPT','2020-03-22','2020-03-22 00:00:00',NULL,'408',9112.40,8698.20,'408','2020-03-24 12:46:48','408','2020-03-24 12:50:10',10,0),('1','72',130097,'EVENING SHIPT','2020-03-23','2020-03-23 00:00:00',NULL,'408',30324.80,28946.40,'408','2020-03-24 12:54:30','408','2020-03-24 12:58:00',10,0),('1','72',130100,'EVENING SHIPT','2020-03-24','2020-03-24 00:00:00',NULL,'408',13829.20,13200.60,'408','2020-03-25 12:38:47','408','2020-03-25 12:41:51',10,0),('1','72',130233,'EVENING SHIPT','2020-03-25','2020-03-25 00:00:00',NULL,'408',22627.00,21598.50,'408','2020-03-28 11:23:35','408','2020-03-28 11:24:04',10,0),('1','72',130534,'EVENING SHIPT','2020-03-26','2020-03-26 00:00:00',NULL,'408',27275.60,26035.80,'408','2020-03-28 11:25:47','408','2020-03-28 11:26:24',10,0),('1','72',130537,'EVENING SHIPT','2020-03-27','2020-03-27 00:00:00',NULL,'408',150999.20,144135.60,'408','2020-03-28 11:28:18','408','2020-03-28 11:29:06',10,0),('1','72',135118,'EVENING SHIPT','2020-05-09','2020-05-09 00:00:00',NULL,'408',145019.60,131836.00,'408','2020-05-10 08:26:53','408','2020-05-10 08:27:37',10,0),('1','72',135209,'EVENING SHIPT','2020-05-10','2020-05-10 00:00:00',NULL,'408',173221.40,157474.00,'408','2020-05-11 08:52:52','408','2020-05-11 08:54:30',10,0),('1','72',135322,'EVENING SHIPT','2020-05-11','2020-05-11 00:00:00',NULL,'408',89100.00,89100.00,'408','2020-05-12 08:09:51','408','2020-05-12 08:11:50',10,0),('1','72',135428,'EVENING SHIPT','2020-05-12','2020-05-12 00:00:00',NULL,'408',109640.00,109640.00,'408','2020-05-13 11:12:00','408','2020-05-13 11:15:07',10,0),('1','72',135560,'EVENING SHIPT','2020-05-13','2020-05-13 00:00:00',NULL,'408',132400.00,132400.00,'408','2020-05-15 10:11:24','408','2020-05-15 10:13:18',10,0),('1','72',135778,'EVENING SHIPT','2020-05-14','2020-05-14 00:00:00',NULL,'408',92900.00,92900.00,'408','2020-05-15 10:21:20','408','2020-05-15 10:22:29',10,0),('1','72',135780,'EVENING SHIPT','2020-05-15','2020-05-15 00:00:00',NULL,'408',10000.00,10000.00,'408','2020-05-18 11:51:07','408','2020-05-18 11:52:05',10,0),('1','72',136140,'EVENING SHIPT','2020-05-16','2020-05-16 00:00:00',NULL,'408',13000.00,13000.00,'408','2020-05-18 11:53:47','408','2020-05-18 11:54:12',10,0),('1','72',136142,'EVENING SHIPT','2020-05-17','2020-05-17 00:00:00',NULL,'408',102130.00,102130.00,'408','2020-05-18 12:00:08','408','2020-05-18 12:00:43',10,0),('1','72',136143,'EVENING SHIPT','2020-05-18','2020-05-18 00:00:00',NULL,'408',50530.00,50530.00,'408','2020-05-20 09:55:13','408','2020-05-20 09:57:36',10,0),('1','72',136329,'EVENING SHIPT','2020-05-19','2020-05-19 00:00:00',NULL,'408',112996.00,112996.00,'408','2020-05-20 10:26:11','408','2020-05-20 10:28:46',10,0),('1','72',136331,'EVENING SHIPT','2020-05-20','2020-05-20 00:00:00',NULL,'408',149508.00,149508.00,'408','2020-05-21 13:04:43','408','2020-05-21 13:05:14',10,0),('1','72',136570,'EVENING SHIPT','2020-05-21','2020-05-21 00:00:00',NULL,'408',20840.00,20319.00,'408','2020-05-22 07:40:04','408','2020-05-22 07:40:41',10,0),('1','72',136572,'EVENING SHIPT','2020-05-22','2020-05-22 00:00:00',NULL,'408',14226.00,13870.35,'408','2020-05-28 06:42:40','408','2020-05-28 06:43:57',10,0),('1','72',137251,'EVENING SHIPT','2020-05-23','2020-05-23 00:00:00',NULL,'408',36052.00,35150.70,'408','2020-05-28 06:46:36','408','2020-05-28 06:47:45',10,0),('1','72',137252,'EVENING SHIPT','2020-05-25','2020-05-25 00:00:00',NULL,'408',109086.00,106358.85,'408','2020-05-28 06:50:11','408','2020-05-28 06:52:20',10,0),('1','72',137253,'EVENING SHIPT','2020-05-26','2020-05-26 00:00:00',NULL,'408',75384.00,73499.40,'408','2020-05-28 06:56:46','408','2020-05-28 06:57:30',10,0),('1','72',137254,'EVENING SHIPT','2020-05-27','2020-05-27 00:00:00',NULL,'408',90256.00,87999.60,'408','2020-05-28 07:01:45','408','2020-05-28 07:02:46',10,0),('1','72',137255,'EVENING SHIPT','2020-05-28','2020-05-28 00:00:00',NULL,'408',49332.00,48098.70,'408','2020-05-29 09:21:03','408','2020-05-29 09:21:59',10,0),('1','72',137422,'EVENING SHIPT','2020-05-29','2020-05-29 00:00:00',NULL,'408',49336.00,48102.60,'408','2020-06-01 11:17:57','408','2020-06-01 11:20:16',10,0),('1','72',137768,'EVENING SHIPT','2020-05-31','2020-05-31 00:00:00',NULL,'408',90470.00,88208.25,'408','2020-06-01 11:24:19','408','2020-06-01 11:24:51',10,0),('1','72',137769,'EVENING SHIPT','2020-06-01','2020-06-01 00:00:00',NULL,'408',22052.00,21500.70,'408','2020-06-02 13:25:47','408','2020-06-02 13:28:07',10,0),('1','72',137910,'EVENING SHIPT','2020-06-02','2020-06-02 00:00:00',NULL,'408',122030.00,118979.25,'408','2020-06-03 14:44:19','408','2020-06-03 14:45:02',10,0),('1','72',138041,'EVENING SHIPT','2020-06-03','2020-06-03 00:00:00',NULL,'408',328832.00,320611.20,'408','2020-06-07 10:27:05','408','2020-06-07 10:36:08',10,0),('1','72',138462,'EVENING SHIPT','2020-06-04','2020-06-04 00:00:00',NULL,'408',25718.00,24432.10,'408','2020-06-07 10:38:18','408','2020-06-07 10:38:57',10,0),('1','72',138465,'EVENING SHIPT','2020-06-05','2020-06-05 00:00:00',NULL,'408',110258.00,104745.10,'408','2020-06-07 10:41:03','408','2020-06-07 10:42:28',10,0),('1','72',138468,'EVENING SHIPT','2020-06-06','2020-06-06 00:00:00',NULL,'408',32096.00,30491.20,'408','2020-06-07 10:45:36','408','2020-06-07 10:46:36',10,0),('1','72',138471,'EVENING SHIPT','2020-06-07','2020-06-07 00:00:00',NULL,'408',34628.00,32896.60,'408','2020-06-08 11:04:48','408','2020-06-08 11:05:55',10,0),('1','72',138605,'EVENING SHIPT','2020-06-08','2020-06-08 00:00:00',NULL,'408',30316.00,28800.20,'408','2020-06-17 15:33:03','408','2020-06-17 15:42:01',10,0),('1','72',139809,'EVENING SHIPT','2020-06-09','2020-06-09 00:00:00',NULL,'408',44104.00,41898.80,'408','2020-06-17 15:44:31','408','2020-06-17 15:45:21',10,0),('1','72',139812,'EVENING SHIPT','2020-06-10','2020-06-10 00:00:00',NULL,'408',59738.00,56751.10,'408','2020-06-17 15:48:31','408','2020-06-17 15:50:07',10,0),('1','72',139814,'EVENING SHIPT','2020-06-11','2020-06-11 00:00:00',NULL,'408',78740.00,74803.00,'408','2020-06-17 15:52:06','408','2020-06-17 15:52:54',10,0),('1','72',139816,'EVENING SHIPT','2020-06-12','2020-06-12 00:00:00',NULL,'408',21052.00,19999.40,'408','2020-06-17 15:56:13','408','2020-06-17 15:56:55',10,0),('1','72',139817,'EVENING SHIPT','2020-06-13','2020-06-13 00:00:00',NULL,'408',8668.00,8234.60,'408','2020-06-17 15:59:03','408','2020-06-17 15:59:31',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=2797435 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','72','590','70008',1398874,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70008',1398875,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70008',1398876,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70008',1398877,'1652','226',62074.17,62462.76,388.59,101033.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','70008',1398878,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70659',1411915,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70659',1411916,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70659',1411917,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70659',1411918,'1652','226',62462.76,63526.93,1064.17,276684.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','70659',1411919,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70697',1412692,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70697',1412693,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70697',1412694,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70697',1412695,'1652','226',63526.93,64699.96,1173.03,304987.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','70697',1412696,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70699',1412709,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70699',1412710,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70699',1412711,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70699',1412712,'1652','226',64699.96,66461.87,1761.91,458096.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','70699',1412713,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70700',1412714,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70700',1412715,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70700',1412716,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70700',1412717,'1652','226',66461.87,67142.21,680.34,176888.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','70700',1412718,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70702',1412745,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70702',1412746,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70702',1412747,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70702',1412748,'1652','226',67142.21,67509.53,367.32,95503.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','70702',1412749,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70708',1412820,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70708',1412821,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70708',1412822,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70708',1412823,'1652','226',67509.53,68225.32,715.79,186105.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','70708',1412824,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70783',1414271,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70783',1414272,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70783',1414273,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70783',1414274,'1652','226',68225.32,69129.18,903.86,235003.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','70783',1414275,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70893',1416512,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70893',1416513,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70893',1416514,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70893',1416515,'1652','226',69129.18,69704.72,575.54,149640.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','70893',1416516,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70896',1416561,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','70896',1416562,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','70896',1416563,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','70896',1416564,'1652','226',69704.72,70077.86,373.14,97016.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','70896',1416565,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71086',1420223,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71086',1420224,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','71086',1420225,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','71086',1420226,'1652','226',70077.86,70846.95,769.09,199963.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','71086',1420227,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71118',1420884,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71118',1420885,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','71118',1420886,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','71118',1420887,'1652','226',70846.95,71188.98,342.03,88927.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','71118',1420888,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71373',1425834,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71373',1425835,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','71373',1425836,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','71373',1425837,'1652','226',71188.98,71816.92,627.94,163264.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','71373',1425838,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71374',1425839,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71374',1425840,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','71374',1425841,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','71374',1425842,'1652','226',71816.92,72422.48,605.56,157445.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','71374',1425843,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71508',1428487,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71508',1428488,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','71508',1428489,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','71508',1428490,'1652','226',72422.48,73144.05,721.57,187608.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','71508',1428491,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71638',1430976,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','71638',1430977,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','71638',1430978,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','71638',1430979,'1652','226',73144.05,74888.80,1744.75,453635.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','71638',1430980,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72177',1440720,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72177',1440721,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72177',1440722,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72177',1440723,'1652','226',74888.80,76530.09,1641.29,426735.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','72177',1440724,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72179',1440753,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72179',1440754,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72179',1440755,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72179',1440756,'1652','226',76530.09,77640.46,1110.37,288696.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','72179',1440757,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72206',1441252,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72206',1441253,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72206',1441254,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72206',1441255,'1652','226',77640.46,79536.70,1896.24,493022.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','72206',1441256,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72209',1441303,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72209',1441304,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72209',1441305,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72209',1441306,'1652','226',79536.70,80084.03,547.33,142305.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','72209',1441307,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72489',1446934,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72489',1446935,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72489',1446936,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72489',1446937,'1652','226',80084.03,81124.29,1040.26,265266.30,0.00,0.00,0.00,0.00,0.00),('1','72','593','72489',1446938,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72713',1451499,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72713',1451500,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72713',1451501,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72713',1451502,'1652','226',81124.29,81948.82,824.53,210255.15,0.00,0.00,0.00,0.00,0.00),('1','72','593','72713',1451503,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72718',1451571,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72718',1451572,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72718',1451573,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72718',1451574,'1652','226',81948.82,82474.36,525.54,134012.70,0.00,0.00,0.00,0.00,0.00),('1','72','593','72718',1451575,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72799',1453247,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72799',1453248,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72799',1453249,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72799',1453250,'1652','226',82474.36,82578.87,104.51,26127.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','72799',1453251,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72801',1453274,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72801',1453275,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72801',1453276,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72801',1453277,'1652','226',82578.87,83434.10,855.23,213807.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','72801',1453278,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72955',1456259,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','72955',1456260,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','72955',1456261,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','72955',1456262,'1652','226',83434.10,84208.50,774.40,193600.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','72955',1456263,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73086',1458808,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73086',1458809,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73086',1458810,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73086',1458811,'1652','226',84208.50,84865.02,656.52,164130.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','73086',1458812,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73203',1461072,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73203',1461073,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73203',1461074,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73203',1461075,'1652','226',84865.02,84943.22,78.20,19550.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','73203',1461076,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73206',1461105,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73206',1461106,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73206',1461107,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73206',1461108,'1652','226',84943.22,85088.31,145.09,35547.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','73206',1461109,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73319',1463436,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73319',1463437,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73319',1463438,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73319',1463439,'1652','226',85088.31,85767.71,679.40,166453.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','73319',1463440,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73410',1465133,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73410',1465134,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73410',1465135,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73410',1465136,'1652','226',85767.71,87063.01,1295.30,317348.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','73410',1465137,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73567',1468384,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73567',1468385,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73567',1468386,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73567',1468387,'1652','226',87063.01,88507.72,1444.71,353953.95,0.00,0.00,0.00,0.00,0.00),('1','72','593','73567',1468388,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73748',1472157,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73748',1472158,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73748',1472159,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73748',1472160,'1652','226',88507.72,89205.41,697.69,170934.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','73748',1472161,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73750',1472175,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73750',1472176,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73750',1472177,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73750',1472178,'1652','226',89205.41,89687.70,482.29,118161.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','73750',1472179,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73868',1474448,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','73868',1474449,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','73868',1474450,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','73868',1474451,'1652','226',89687.70,90928.82,1241.12,304074.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','73868',1474452,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74467',1486418,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74467',1486419,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','74467',1486420,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','74467',1486421,'1652','226',90928.82,91615.84,687.02,168319.90,0.00,0.00,0.00,0.00,0.00),('1','72','593','74467',1486422,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74468',1486423,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74468',1486424,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','74468',1486425,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','74468',1486426,'1652','226',91615.84,92416.06,800.22,196053.90,0.00,0.00,0.00,0.00,0.00),('1','72','593','74468',1486427,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74469',1486428,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74469',1486429,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','74469',1486430,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','74469',1486431,'1652','226',92416.06,93718.82,1302.76,319176.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','74469',1486432,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74470',1486433,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74470',1486434,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','74470',1486435,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','74470',1486436,'1652','226',93718.82,94870.25,1151.43,282100.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','74470',1486437,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74585',1488779,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74585',1488780,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','74585',1488781,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','74585',1488782,'1652','226',94870.25,95399.75,529.50,129727.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','74585',1488783,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74586',1488784,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74586',1488785,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','74586',1488786,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','74586',1488787,'1652','226',95399.75,95899.45,499.70,122426.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','74586',1488788,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74705',1491059,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','74705',1491060,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','74705',1491061,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','74705',1491062,'1652','226',95899.45,97970.75,2071.30,497112.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','74705',1491063,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75048',1497703,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75048',1497704,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75048',1497705,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75048',1497706,'1652','226',97970.75,99141.77,1171.02,281044.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','75048',1497707,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75050',1497715,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75050',1497716,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75050',1497717,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75050',1497718,'1652','226',99141.77,99891.87,750.10,180024.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','75050',1497719,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75100',1498665,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75100',1498666,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75100',1498667,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75100',1498668,'1652','226',99891.87,101209.31,1317.44,316185.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','75100',1498669,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75233',1501228,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75233',1501229,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75233',1501230,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75233',1501231,'1652','226',101209.31,102027.42,818.11,196346.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','75233',1501232,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75365',1503788,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75365',1503789,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75365',1503790,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75365',1503791,'1652','226',102027.42,102784.97,757.55,181812.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','75365',1503792,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75446',1505181,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75446',1505182,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75446',1505183,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75446',1505184,'1652','226',102784.97,103030.51,245.54,58929.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','75446',1505185,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75595',1508193,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75595',1508194,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75595',1508195,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75595',1508196,'1652','226',103030.51,103483.02,452.51,108602.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','75595',1508197,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75737',1510967,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75737',1510968,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75737',1510969,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75737',1510970,'1652','226',103483.02,104700.28,1217.26,292142.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','75737',1510971,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75811',1512388,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','75811',1512389,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','75811',1512390,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','75811',1512391,'1652','226',104700.28,105389.22,688.94,165345.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','75811',1512392,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76011',1516455,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76011',1516456,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','76011',1516457,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','76011',1516458,'1652','226',105389.22,107038.65,1649.43,395863.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','76011',1516459,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76054',1517366,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76054',1517367,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','76054',1517368,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','76054',1517369,'1652','226',107038.65,108840.05,1801.40,432336.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','76054',1517370,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76689',1529939,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76689',1529940,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','76689',1529941,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','76689',1529942,'1652','226',108840.05,109377.43,537.38,128971.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','76689',1529943,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76691',1529953,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76691',1529954,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','76691',1529955,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','76691',1529956,'1652','226',109377.43,110560.75,1183.32,283996.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','76691',1529957,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76692',1529958,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76692',1529959,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','76692',1529960,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','76692',1529961,'1652','226',110560.75,111177.22,616.47,147952.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','76692',1529962,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76693',1529963,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76693',1529964,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','76693',1529965,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','76693',1529966,'1652','226',111177.22,113151.52,1974.30,473832.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','76693',1529967,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76903',1534230,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76903',1534231,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','76903',1534232,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','76903',1534233,'1652','226',113151.52,114051.03,899.51,215882.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','76903',1534234,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76933',1534826,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','76933',1534827,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','76933',1534828,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','76933',1534829,'1652','226',114051.03,114111.86,60.83,14599.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','76933',1534830,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77064',1537400,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77064',1537401,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77064',1537402,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77064',1537403,'1652','226',114111.86,114655.53,543.67,125044.10,0.00,0.00,0.00,0.00,0.00),('1','72','593','77064',1537404,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77066',1537426,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77066',1537427,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77066',1537428,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77066',1537429,'1652','226',114655.53,115396.71,741.18,170471.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','77066',1537430,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77272',1541502,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77272',1541503,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77272',1541504,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77272',1541505,'1652','226',115396.71,115683.05,286.34,65858.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','77272',1541506,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77315',1542355,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77315',1542356,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77315',1542357,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77315',1542358,'1652','226',115683.05,115725.08,42.03,9666.90,0.00,0.00,0.00,0.00,0.00),('1','72','593','77315',1542359,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77462',1545270,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77462',1545271,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77462',1545272,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77462',1545273,'1652','226',115725.08,116014.20,289.12,65052.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','77462',1545274,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77463',1545275,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77463',1545276,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77463',1545277,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77463',1545278,'1652','226',116014.20,117417.21,1403.01,315677.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','77463',1545279,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77687',1549592,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77687',1549593,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77687',1549594,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77687',1549595,'1652','226',117417.21,120783.74,3366.53,757469.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','77687',1549596,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77689',1549616,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77689',1549617,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77689',1549618,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77689',1549619,'1652','226',120783.74,121609.02,825.28,185688.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','77689',1549620,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77823',1552321,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','77823',1552322,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','77823',1552323,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','77823',1552324,'1652','226',121609.02,121891.24,282.22,63499.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','77823',1552325,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78030',1556312,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78030',1556313,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78030',1556314,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78030',1556315,'1652','226',121891.24,123804.89,1913.65,430571.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','78030',1556316,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78034',1556388,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78034',1556389,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78034',1556390,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78034',1556391,'1652','226',123804.89,125670.14,1865.25,419681.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','78034',1556392,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78192',1559444,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78192',1559445,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78192',1559446,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78192',1559447,'1652','226',125670.14,127160.55,1490.41,335342.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','78192',1559448,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78387',1563258,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78387',1563259,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78387',1563260,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78387',1563261,'1652','226',127160.55,127836.52,675.97,152093.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','78387',1563262,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78479',1565069,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78479',1565070,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78479',1565071,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78479',1565072,'1652','226',127836.52,130275.33,2438.81,548732.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','78479',1565073,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78655',1568466,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78655',1568467,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78655',1568468,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78655',1568469,'1652','226',130275.33,132192.36,1917.03,431331.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','78655',1568470,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78943',1574264,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78943',1574265,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78943',1574266,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78943',1574267,'1652','226',132192.36,133219.47,1027.11,231099.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','78943',1574268,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78944',1574269,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78944',1574270,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78944',1574271,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78944',1574272,'1652','226',133219.47,133592.21,372.74,83866.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','78944',1574273,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78945',1574274,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','78945',1574275,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','78945',1574276,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','78945',1574277,'1652','226',133592.21,134243.09,650.88,146448.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','78945',1574278,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79065',1576824,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79065',1576825,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','79065',1576826,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','79065',1576827,'1652','226',134243.09,134446.16,203.07,45690.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','79065',1576828,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79236',1580171,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79236',1580172,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','79236',1580173,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','79236',1580174,'1652','226',134446.16,135242.85,796.69,179255.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','79236',1580175,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79453',1584310,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79453',1584311,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','79453',1584312,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','79453',1584313,'1652','226',135242.85,136228.10,985.25,221681.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','79453',1584314,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79457',1584361,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79457',1584362,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','79457',1584363,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','79457',1584364,'1652','226',136228.10,136691.09,462.99,104172.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','79457',1584365,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79929',1594045,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79929',1594046,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','79929',1594047,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','79929',1594048,'1652','226',136691.09,137432.83,741.74,166891.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','79929',1594049,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79930',1594050,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79930',1594051,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','79930',1594052,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','79930',1594053,'1652','226',137432.83,138279.56,846.73,190514.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','79930',1594054,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79931',1594055,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79931',1594056,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','79931',1594057,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','79931',1594058,'1652','226',138279.56,138859.26,579.70,130432.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','79931',1594059,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79932',1594060,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','79932',1594061,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','79932',1594062,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','79932',1594063,'1652','226',138859.26,139428.65,569.39,128112.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','79932',1594064,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80134',1597748,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80134',1597749,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','80134',1597750,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','80134',1597751,'1652','226',139428.65,139680.39,251.74,56641.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','80134',1597752,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80238',1599821,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80238',1599822,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','80238',1599823,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','80238',1599824,'1652','226',139680.39,139945.21,264.82,59584.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','80238',1599825,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80378',1602453,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80378',1602454,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','80378',1602455,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','80378',1602456,'1652','226',139945.21,140059.51,114.30,25717.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','80378',1602457,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80465',1604175,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80465',1604176,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','80465',1604177,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','80465',1604178,'1652','226',140059.51,140485.95,426.44,95949.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','80465',1604179,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80754',1609813,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80754',1609814,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','80754',1609815,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','80754',1609816,'1652','226',140485.95,140590.30,104.35,23478.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','80754',1609817,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80755',1609818,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80755',1609819,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','80755',1609820,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','80755',1609821,'1652','226',140590.30,140995.54,405.24,91179.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','80755',1609822,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80854',1611687,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','80854',1611688,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','80854',1611689,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','80854',1611690,'1652','226',140995.54,141620.78,625.24,140679.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','80854',1611691,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81143',1617220,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81143',1617221,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','81143',1617222,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','81143',1617223,'1652','226',141620.78,142262.93,642.15,144483.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','81143',1617224,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81145',1617256,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81145',1617257,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','81145',1617258,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','81145',1617259,'1652','226',142262.93,142359.38,96.45,21701.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','81145',1617260,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81254',1619329,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81254',1619330,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','81254',1619331,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','81254',1619332,'1652','226',142359.38,142498.94,139.56,31401.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','81254',1619333,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81306',1620296,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81306',1620297,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','81306',1620298,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','81306',1620299,'1652','226',142498.94,142748.60,249.66,56173.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','81306',1620300,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81484',1623850,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81484',1623851,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','81484',1623852,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','81484',1623853,'1652','226',142748.60,143287.31,538.71,121209.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','81484',1623854,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81486',1623862,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','81486',1623863,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','81486',1623864,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','81486',1623865,'1652','226',143287.31,143564.20,276.89,62300.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','81486',1623866,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82447',1642752,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82447',1642753,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82447',1642754,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82447',1642755,'1652','226',0.00,733.58,733.58,165055.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','82447',1642756,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82452',1642818,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82452',1642819,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82452',1642820,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82452',1642821,'1652','226',733.58,1060.95,327.37,73658.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','82452',1642822,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82454',1642844,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82454',1642845,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82454',1642846,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82454',1642847,'1652','226',1060.95,1405.62,344.67,77550.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','82454',1642848,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82457',1642899,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82457',1642900,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82457',1642901,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82457',1642902,'1652','226',1405.62,1461.23,55.61,12512.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','82457',1642903,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82459',1642909,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82459',1642910,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82459',1642911,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82459',1642912,'1652','226',1461.23,1880.22,418.99,94272.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','82459',1642913,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82461',1642930,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82461',1642931,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82461',1642932,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82461',1642933,'1652','226',1880.22,2641.53,761.31,171294.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','82461',1642934,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82462',1642935,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82462',1642936,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82462',1642937,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82462',1642938,'1652','226',2641.53,3299.30,657.77,147998.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','82462',1642939,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82564',1644928,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82564',1644929,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82564',1644930,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82564',1644931,'1652','226',3299.30,3518.52,219.22,49324.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','82564',1644932,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82700',1647547,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82700',1647548,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82700',1647549,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82700',1647550,'1652','226',3518.52,3628.13,109.61,24662.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','82700',1647551,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82876',1651116,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82876',1651117,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82876',1651118,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82876',1651119,'1652','226',3628.13,3854.09,225.96,50841.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','82876',1651120,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82878',1651149,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','82878',1651150,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','82878',1651151,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','82878',1651152,'1652','226',3854.09,4367.36,513.27,115485.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','82878',1651153,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83188',1657250,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83188',1657251,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','83188',1657252,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','83188',1657253,'1652','226',4367.36,4530.07,162.71,36609.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','83188',1657254,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83190',1657271,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83190',1657272,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','83190',1657273,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','83190',1657274,'1652','226',4530.07,4760.94,230.87,51945.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','83190',1657275,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83192',1657298,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83192',1657299,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','83192',1657300,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','83192',1657301,'1652','226',4760.94,5086.50,325.56,73251.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','83192',1657302,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83415',1661572,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83415',1661573,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','83415',1661574,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','83415',1661575,'1652','226',5086.50,5188.28,101.78,22900.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','83415',1661576,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83580',1664742,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83580',1664743,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','83580',1664744,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','83580',1664745,'1652','226',5188.28,5317.97,129.69,29180.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','83580',1664746,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83581',1664747,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','83581',1664748,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','83581',1664749,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','83581',1664750,'1652','226',5317.97,5383.52,65.55,14748.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','83581',1664751,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84187',1676631,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84187',1676632,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84187',1676633,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84187',1676634,'1652','226',5383.52,5479.08,95.56,21501.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','84187',1676635,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84188',1676636,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84188',1676637,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84188',1676638,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84188',1676639,'1652','226',5479.08,5655.34,176.26,39658.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','84188',1676640,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84190',1676669,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84190',1676670,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84190',1676671,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84190',1676672,'1652','226',5655.34,5753.34,98.00,22050.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','84190',1676673,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84192',1676699,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84192',1676700,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84192',1676701,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84192',1676702,'1652','226',5753.34,5821.78,68.44,15399.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','84192',1676703,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84193',1676704,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84193',1676705,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84193',1676706,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84193',1676707,'1652','226',5821.78,6069.56,247.78,55750.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','84193',1676708,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84394',1680190,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84394',1680191,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84394',1680192,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84394',1680193,'1652','226',6069.56,6162.67,93.11,20949.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','84394',1680194,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84496',1682208,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84496',1682209,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84496',1682210,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84496',1682211,'1652','226',6162.67,6230.67,68.00,15300.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','84496',1682212,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84808',1688196,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84808',1688197,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84808',1688198,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84808',1688199,'1652','226',6230.67,6676.67,446.00,100350.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','84808',1688200,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84809',1688201,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84809',1688202,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84809',1688203,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84809',1688204,'1652','226',6676.67,6738.88,62.21,13997.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','84809',1688205,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84812',1688275,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84812',1688276,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84812',1688277,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84812',1688278,'1652','226',6738.88,6890.86,151.98,34195.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','84812',1688279,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84908',1690126,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','84908',1690127,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','84908',1690128,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','84908',1690129,'1652','226',6890.86,6924.19,33.33,7499.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','84908',1690130,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85145',1694758,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85145',1694759,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','85145',1694760,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','85145',1694761,'1652','226',6924.19,7027.30,103.11,23199.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','85145',1694762,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85147',1694785,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85147',1694786,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','85147',1694787,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','85147',1694788,'1652','226',7027.30,7184.42,157.12,35352.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','85147',1694789,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85271',1697280,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85271',1697281,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','85271',1697282,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','85271',1697283,'1652','226',7184.42,7282.21,97.79,22002.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','85271',1697284,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85841',1707880,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85841',1707881,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','85841',1707882,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','85841',1707883,'1652','226',7282.21,8185.38,903.17,203213.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','85841',1707884,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85842',1707885,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85842',1707886,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','85842',1707887,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','85842',1707888,'1652','226',8185.38,8228.50,43.12,9702.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','85842',1707889,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85843',1707890,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85843',1707891,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','85843',1707892,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','85843',1707893,'1652','226',8228.50,8297.39,68.89,15500.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','85843',1707894,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85847',1707948,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85847',1707949,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','85847',1707950,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','85847',1707951,'1652','226',8297.39,8332.94,35.55,7998.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','85847',1707952,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85940',1709899,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','85940',1709900,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','85940',1709901,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','85940',1709902,'1652','226',8332.94,8613.36,280.42,63094.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','85940',1709903,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86103',1713247,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86103',1713248,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','86103',1713249,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','86103',1713250,'1652','226',8613.36,9120.25,506.89,114050.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','86103',1713251,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86601',1722887,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86601',1722888,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','86601',1722889,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','86601',1722890,'1652','226',9120.25,9306.72,186.47,41955.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','86601',1722891,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86605',1722943,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86605',1722944,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','86605',1722945,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','86605',1722946,'1652','226',9306.72,9434.50,127.78,28750.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','86605',1722947,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86608',1722990,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86608',1722991,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','86608',1722992,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','86608',1722993,'1652','226',9434.50,9482.32,47.82,10759.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','86608',1722994,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86612',1723045,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86612',1723046,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','86612',1723047,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','86612',1723048,'1652','226',9482.32,9531.66,49.34,11101.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','86612',1723049,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86783',1726349,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86783',1726350,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','86783',1726351,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','86783',1726352,'1652','226',9531.66,9921.66,390.00,87750.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','86783',1726353,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86859',1727752,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86859',1727753,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','86859',1727754,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','86859',1727755,'1652','226',9921.66,10496.46,574.80,129330.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','86859',1727756,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86964',1729797,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','86964',1729798,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','86964',1729799,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','86964',1729800,'1652','226',10496.46,11905.13,1408.67,316950.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','86964',1729801,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87608',1742447,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87608',1742448,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','87608',1742449,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','87608',1742450,'1652','226',11905.13,11958.34,53.21,11972.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','87608',1742451,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87609',1742452,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87609',1742453,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','87609',1742454,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','87609',1742455,'1652','226',11958.34,12009.90,51.56,11601.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','87609',1742456,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87610',1742457,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87610',1742458,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','87610',1742459,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','87610',1742460,'1652','226',12009.90,12420.80,410.90,92452.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','87610',1742461,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87611',1742462,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87611',1742463,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','87611',1742464,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','87611',1742465,'1652','226',12420.80,12488.72,67.92,15282.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','87611',1742466,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87613',1742484,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87613',1742485,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','87613',1742486,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','87613',1742487,'1652','226',12488.72,12539.39,50.67,11400.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','87613',1742488,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87698',1744239,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87698',1744240,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','87698',1744241,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','87698',1744242,'1652','226',12539.39,13015.62,476.23,107151.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','87698',1744243,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87879',1747635,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','87879',1747636,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','87879',1747637,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','87879',1747638,'1652','226',13015.62,13185.76,170.14,38281.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','87879',1747639,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88299',1756540,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88299',1756541,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','88299',1756542,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','88299',1756543,'1652','226',13185.76,13290.21,104.45,23501.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','88299',1756544,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88301',1756567,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88301',1756568,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','88301',1756569,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','88301',1756570,'1652','226',13290.21,13593.32,303.11,68199.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','88301',1756571,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88303',1756590,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88303',1756591,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','88303',1756592,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','88303',1756593,'1652','226',13593.32,13807.76,214.44,48249.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','88303',1756594,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88305',1756617,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88305',1756618,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','88305',1756619,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','88305',1756620,'1652','226',13807.76,13953.58,145.82,32809.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','88305',1756621,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88733',1765792,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88733',1765793,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','88733',1765794,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','88733',1765795,'1652','226',13953.58,14010.24,56.66,12748.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','88733',1765796,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88738',1765883,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88738',1765884,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','88738',1765885,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','88738',1765886,'1652','226',14010.24,14800.51,790.27,177810.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','88738',1765887,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88741',1765925,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','88741',1765926,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','88741',1765927,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','88741',1765928,'1652','226',14800.51,15902.59,1102.08,247968.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','88741',1765929,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89399',1779115,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89399',1779116,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','89399',1779117,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','89399',1779118,'1652','226',15902.59,16406.68,504.09,113420.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','89399',1779119,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89401',1779136,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89401',1779137,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','89401',1779138,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','89401',1779139,'1652','226',16406.68,16512.00,105.32,23697.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','89401',1779140,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89405',1779204,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89405',1779205,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','89405',1779206,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','89405',1779207,'1652','226',16512.00,16662.00,150.00,33750.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','89405',1779208,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89406',1779209,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89406',1779210,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','89406',1779211,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','89406',1779212,'1652','226',16662.00,16784.22,122.22,27499.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','89406',1779213,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89407',1779214,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89407',1779215,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','89407',1779216,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','89407',1779217,'1652','226',16784.22,16832.64,48.42,10894.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','89407',1779218,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89471',1780571,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','89471',1780572,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','89471',1780573,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','89471',1780574,'1652','226',16832.64,16867.30,34.66,7798.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','89471',1780575,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90102',1793148,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90102',1793149,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90102',1793150,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90102',1793151,'1652','226',16867.30,17759.37,892.07,200715.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','90102',1793152,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90104',1793171,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90104',1793172,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90104',1793173,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90104',1793174,'1652','226',17759.37,17908.10,148.73,33464.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','90104',1793175,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90105',1793176,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90105',1793177,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90105',1793178,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90105',1793179,'1652','226',17908.10,18427.72,519.62,116914.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','90105',1793180,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90108',1793235,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90108',1793236,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90108',1793237,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90108',1793238,'1652','226',18427.72,18527.72,100.00,22500.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','90108',1793239,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90111',1793270,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90111',1793271,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90111',1793272,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90111',1793273,'1652','226',18527.72,18605.27,77.55,17448.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','90111',1793274,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90307',1797255,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90307',1797256,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90307',1797257,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90307',1797258,'1652','226',18605.27,18702.86,97.59,21957.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','90307',1797259,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90401',1799049,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90401',1799050,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90401',1799051,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90401',1799052,'1652','226',18702.86,18905.01,202.15,45483.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','90401',1799053,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90554',1802035,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90554',1802036,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90554',1802037,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90554',1802038,'1652','226',18905.01,19336.12,431.11,96999.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','90554',1802039,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90596',1803039,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','90596',1803040,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','90596',1803041,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','90596',1803042,'1652','226',19336.12,19927.45,591.33,133049.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','90596',1803043,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91136',1813907,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91136',1813908,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91136',1813909,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91136',1813910,'1652','226',19927.45,20438.19,510.74,114916.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','91136',1813911,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91139',1813934,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91139',1813935,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91139',1813936,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91139',1813937,'1652','226',20438.19,20600.31,162.12,36477.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','91139',1813938,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91140',1813939,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91140',1813940,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91140',1813941,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91140',1813942,'1652','226',20600.31,20691.44,91.13,20504.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','91140',1813943,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91142',1813961,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91142',1813962,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91142',1813963,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91142',1813964,'1652','226',20691.44,21118.44,427.00,96075.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','91142',1813965,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91295',1816931,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91295',1816932,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91295',1816933,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91295',1816934,'1652','226',21118.44,21876.04,757.60,170460.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','91295',1816935,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91381',1818782,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91381',1818783,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91381',1818784,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91381',1818785,'1652','226',21876.04,23468.27,1592.23,358251.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','91381',1818786,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91551',1822174,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91551',1822175,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91551',1822176,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91551',1822177,'1652','226',23468.27,23797.39,329.12,74052.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','91551',1822178,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91979',1830665,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91979',1830666,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91979',1830667,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91979',1830668,'1652','226',23797.39,24404.92,607.53,136694.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','91979',1830669,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91981',1830688,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91981',1830689,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91981',1830690,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91981',1830691,'1652','226',24404.92,24497.60,92.68,20853.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','91981',1830692,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91985',1830732,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91985',1830733,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91985',1830734,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91985',1830735,'1652','226',24497.60,25487.19,989.59,222657.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','91985',1830736,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91986',1830737,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','91986',1830738,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','91986',1830739,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','91986',1830740,'1652','226',25487.19,25652.02,164.83,37086.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','91986',1830741,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93440',1860091,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93440',1860092,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93440',1860093,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93440',1860094,'1652','226',25652.02,25697.82,45.80,10305.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','93440',1860095,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93573',1862838,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93573',1862839,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93573',1862840,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93573',1862841,'1652','226',25697.82,25837.82,140.00,31500.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','93573',1862842,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93574',1862843,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93574',1862844,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93574',1862845,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93574',1862846,'1652','226',25837.82,25888.49,50.67,11400.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','93574',1862847,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93576',1862866,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93576',1862867,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93576',1862868,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93576',1862869,'1652','226',25888.49,26376.31,487.82,109759.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','93576',1862870,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93621',1863652,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93621',1863653,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93621',1863654,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93621',1863655,'1652','226',26376.31,26524.86,148.55,33423.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','93621',1863656,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93622',1863657,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93622',1863658,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93622',1863659,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93622',1863660,'1652','226',26524.86,26575.41,50.55,11373.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','93622',1863661,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93623',1863662,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93623',1863663,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93623',1863664,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93623',1863665,'1652','226',26575.41,26575.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','93623',1863666,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93624',1863667,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93624',1863668,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93624',1863669,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93624',1863670,'1652','226',26575.41,26630.64,55.23,12426.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','93624',1863671,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93626',1863688,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93626',1863689,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93626',1863690,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93626',1863691,'1652','226',26630.64,26676.86,46.22,10399.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','93626',1863692,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93629',1863722,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93629',1863723,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93629',1863724,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93629',1863725,'1652','226',26676.86,26855.76,178.90,40252.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','93629',1863726,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93631',1863743,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93631',1863744,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93631',1863745,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93631',1863746,'1652','226',26855.76,26939.18,83.42,18769.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','93631',1863747,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93632',1863748,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93632',1863749,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93632',1863750,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93632',1863751,'1652','226',26939.18,27517.80,578.62,130189.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','93632',1863752,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93634',1863781,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93634',1863782,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93634',1863783,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93634',1863784,'1652','226',27517.80,28092.25,574.45,129251.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','93634',1863785,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93635',1863786,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93635',1863787,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93635',1863788,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93635',1863789,'1652','226',28092.25,28822.02,729.77,164198.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','93635',1863790,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93836',1867904,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93836',1867905,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93836',1867906,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93836',1867907,'1652','226',28822.02,29621.98,799.96,179991.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','93836',1867908,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93839',1867938,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93839',1867939,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93839',1867940,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93839',1867941,'1652','226',29621.98,29986.42,364.44,81999.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','93839',1867942,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93984',1870856,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','93984',1870857,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','93984',1870858,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','93984',1870859,'1652','226',29986.42,30141.04,154.62,34789.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','93984',1870860,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94397',1879150,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94397',1879151,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','94397',1879152,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','94397',1879153,'1652','226',30141.04,30232.30,91.26,20533.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','94397',1879154,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94399',1879179,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94399',1879180,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','94399',1879181,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','94399',1879182,'1652','226',30232.30,30276.75,44.45,10001.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','94399',1879183,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94480',1880918,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94480',1880919,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','94480',1880920,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','94480',1880921,'1652','226',30276.75,30378.52,101.77,22898.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','94480',1880922,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94484',1880984,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94484',1880985,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','94484',1880986,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','94484',1880987,'1652','226',30378.52,30429.56,51.04,11484.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','94484',1880988,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94635',1884150,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94635',1884151,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','94635',1884152,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','94635',1884153,'1652','226',30429.56,30512.67,83.11,18699.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','94635',1884154,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94795',1887377,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','94795',1887378,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','94795',1887379,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','94795',1887380,'1652','226',30512.67,30892.21,379.54,85396.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','94795',1887381,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95487',1901668,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95487',1901669,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95487',1901670,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95487',1901671,'1652','226',30892.21,30975.77,83.56,18801.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','95487',1901672,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95488',1901673,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95488',1901674,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95488',1901675,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95488',1901676,'1652','226',30975.77,31050.00,74.23,16701.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','95488',1901677,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95490',1901694,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95490',1901695,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95490',1901696,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95490',1901697,'1652','226',31050.00,31253.78,203.78,45850.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','95490',1901698,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95491',1901699,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95491',1901700,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95491',1901701,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95491',1901702,'1652','226',31253.78,31419.67,165.89,37325.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','95491',1901703,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95598',1903619,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95598',1903620,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95598',1903621,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95598',1903622,'1652','226',31419.67,31721.89,302.22,67999.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','95598',1903623,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95601',1903643,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95601',1903644,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95601',1903645,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95601',1903646,'1652','226',31721.89,32282.33,560.44,126099.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','95601',1903647,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95602',1903648,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95602',1903649,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95602',1903650,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95602',1903651,'1652','226',32282.33,32404.43,122.10,27472.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','95602',1903652,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95764',1906820,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95764',1906821,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95764',1906822,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95764',1906823,'1652','226',32404.43,32588.71,184.28,41463.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','95764',1906824,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95766',1906841,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95766',1906842,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95766',1906843,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95766',1906844,'1652','226',32588.71,33701.59,1112.88,250398.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','95766',1906845,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95855',1908212,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95855',1908213,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95855',1908214,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95855',1908215,'1652','226',33701.59,33797.14,85.55,19248.75,0.00,0.00,10.00,0.00,0.00),('1','72','593','95855',1908216,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95935',1909602,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','95935',1909603,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','95935',1909604,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','95935',1909605,'1652','226',33797.14,34168.24,371.10,83497.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','95935',1909606,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96271',1917014,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96271',1917015,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96271',1917016,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96271',1917017,'1652','226',34168.24,34221.58,53.34,12001.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','96271',1917018,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96272',1917019,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96272',1917020,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96272',1917021,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96272',1917022,'1652','226',34221.58,34464.50,242.92,54657.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','96272',1917023,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96274',1917043,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96274',1917044,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96274',1917045,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96274',1917046,'1652','226',34464.50,34735.77,271.27,61035.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','96274',1917047,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96399',1919261,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96399',1919262,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96399',1919263,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96399',1919264,'1652','226',34735.77,35672.01,936.24,210654.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','96399',1919265,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96793',1927300,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96793',1927301,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96793',1927302,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96793',1927303,'1652','226',35672.01,36597.22,915.21,205922.25,0.00,0.00,10.00,0.00,0.00),('1','72','593','96793',1927304,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96795',1927327,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96795',1927328,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96795',1927329,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96795',1927330,'1652','226',36597.22,36729.45,132.23,29751.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','96795',1927331,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96798',1927366,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96798',1927367,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96798',1927368,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96798',1927369,'1652','226',36729.45,37287.56,558.11,125574.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','96798',1927370,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96800',1927383,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96800',1927384,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96800',1927385,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96800',1927386,'1652','226',37287.56,38068.34,780.78,175675.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','96800',1927387,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96960',1930424,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','96960',1930425,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','96960',1930426,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','96960',1930427,'1652','226',38068.34,38944.79,876.45,197201.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','96960',1930428,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97388',1938995,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97388',1938996,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','97388',1938997,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','97388',1938998,'1652','226',38944.79,38975.90,31.11,6999.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','97388',1938999,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97788',1947065,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97788',1947066,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','97788',1947067,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','97788',1947068,'1652','226',38975.90,39014.54,38.64,8500.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','97788',1947069,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97790',1947087,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97790',1947088,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','97790',1947089,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','97790',1947090,'1652','226',39014.54,39139.54,125.00,27500.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','97790',1947091,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97792',1947114,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97792',1947115,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','97792',1947116,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','97792',1947117,'1652','226',39139.54,39181.36,41.82,9200.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','97792',1947118,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97873',1948747,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','97873',1948748,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','97873',1948749,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','97873',1948750,'1652','226',39181.36,40133.88,952.52,209554.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','97873',1948751,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99192',1967284,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99192',1967285,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','99192',1967286,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','99192',1967287,'1652','226',40133.88,40675.24,541.36,119099.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','99192',1967288,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99196',1967349,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99196',1967350,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','99196',1967351,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','99196',1967352,'1652','226',40675.24,41043.10,357.86,78729.20,0.00,0.00,10.00,0.00,0.00),('1','72','593','99196',1967353,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99199',1967387,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99199',1967388,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','99199',1967389,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','99199',1967390,'1652','226',41043.10,41090.76,47.66,10485.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','99199',1967391,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99201',1967422,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99201',1967423,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','99201',1967424,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','99201',1967425,'1652','226',41090.76,41660.13,569.37,125261.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','99201',1967426,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99203',1967432,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99203',1967433,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','99203',1967434,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','99203',1967435,'1652','226',41660.13,42426.59,766.46,168621.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','99203',1967436,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99517',1974173,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99517',1974174,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','99517',1974175,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','99517',1974176,'1652','226',42426.59,42500.76,74.17,16317.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','99517',1974177,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99518',1974178,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99518',1974179,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','99518',1974180,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','99518',1974181,'1652','226',42500.76,43640.17,1129.41,248470.20,0.00,0.00,10.00,0.00,0.00),('1','72','593','99518',1974182,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99616',1976288,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','99616',1976289,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','99616',1976290,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','99616',1976291,'1652','226',43640.17,44161.98,521.81,114798.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','99616',1976292,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100048',1985024,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100048',1985025,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100048',1985026,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100048',1985027,'1652','226',44161.98,44776.90,614.92,135282.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','100048',1985028,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100049',1985029,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100049',1985030,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100049',1985031,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100049',1985032,'1652','226',44776.90,45540.68,763.78,168031.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','100049',1985033,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100052',1985080,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100052',1985081,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100052',1985082,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100052',1985083,'1652','226',45540.68,46126.65,585.97,128913.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','100052',1985084,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100053',1985085,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100053',1985086,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100053',1985087,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100053',1985088,'1652','226',46126.65,47454.76,1328.11,292184.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','100053',1985089,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100302',1989937,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100302',1989938,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100302',1989939,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100302',1989940,'1652','226',47454.76,48911.69,1456.93,320524.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','100302',1989941,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100303',1989942,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100303',1989943,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100303',1989944,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100303',1989945,'1652','226',48911.69,49514.31,592.62,130376.40,0.00,0.00,10.00,0.00,0.00),('1','72','593','100303',1989946,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100439',1992603,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100439',1992604,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100439',1992605,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100439',1992606,'1652','226',49514.31,49844.12,329.81,72558.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','100439',1992607,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100441',1992624,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100441',1992625,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100441',1992626,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100441',1992627,'1652','226',49844.12,51481.06,1636.94,360126.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','100441',1992628,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100767',1999341,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100767',1999342,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100767',1999343,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100767',1999344,'1652','226',51481.06,52554.81,1073.75,236225.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','100767',1999345,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100768',1999346,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100768',1999347,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100768',1999348,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100768',1999349,'1652','226',52554.81,53088.94,534.13,117508.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','100768',1999350,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100980',2003783,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100980',2003784,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100980',2003785,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100980',2003786,'1652','226',53088.94,53795.03,706.09,155339.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','100980',2003787,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100981',2003788,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','100981',2003789,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','100981',2003790,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','100981',2003791,'1652','226',53795.03,54053.68,258.65,56903.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','100981',2003792,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101149',2006917,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101149',2006918,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','101149',2006919,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','101149',2006920,'1652','226',54053.68,54695.31,631.63,138958.60,0.00,0.00,10.00,0.00,0.00),('1','72','593','101149',2006921,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101249',2008891,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101249',2008892,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','101249',2008893,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','101249',2008894,'1652','226',54695.31,54785.77,90.46,19901.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','101249',2008895,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101809',2019542,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101809',2019543,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','101809',2019544,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','101809',2019545,'1652','226',54785.77,55026.85,241.08,53037.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','101809',2019546,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101811',2019569,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101811',2019570,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','101811',2019571,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','101811',2019572,'1652','226',55026.85,55065.89,39.04,8784.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','101811',2019573,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101814',2019615,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101814',2019616,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','101814',2019617,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','101814',2019618,'1652','226',55065.89,55090.89,25.00,5500.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','101814',2019619,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101815',2019620,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101815',2019621,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','101815',2019622,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','101815',2019623,'1652','226',55090.89,55117.71,26.82,5900.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','101815',2019624,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101817',2019644,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','101817',2019645,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','101817',2019646,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','101817',2019647,'1652','226',55117.71,56244.99,1127.28,248001.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','101817',2019648,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102244',2028580,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102244',2028581,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','102244',2028582,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','102244',2028583,'1652','226',56244.99,57451.73,1206.74,265482.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','102244',2028584,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102355',2031069,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102355',2031070,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','102355',2031071,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','102355',2031072,'1652','226',57451.73,57961.51,509.78,112151.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','102355',2031073,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102357',2031096,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102357',2031097,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','102357',2031098,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','102357',2031099,'1652','226',57961.51,58384.26,422.75,93005.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','102357',2031100,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102604',2035943,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102604',2035944,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','102604',2035945,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','102604',2035946,'1652','226',58384.26,59422.57,1038.31,228428.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','102604',2035947,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102606',2035956,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102606',2035957,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','102606',2035958,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','102606',2035959,'1652','226',59422.57,59484.16,51.59,11349.80,0.00,0.00,10.00,0.00,0.00),('1','72','593','102606',2035960,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102780',2039441,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102780',2039442,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','102780',2039443,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','102780',2039444,'1652','226',59484.16,60913.43,1429.27,314439.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','102780',2039445,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102781',2039446,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','102781',2039447,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','102781',2039448,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','102781',2039449,'1652','226',60913.43,62117.08,1203.65,258784.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','102781',2039450,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103406',2051958,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103406',2051959,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103406',2051960,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103406',2051961,'1652','226',62117.08,62330.59,213.51,45904.65,0.00,0.00,0.00,0.00,0.00),('1','72','593','103406',2051962,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103407',2051963,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103407',2051964,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103407',2051965,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103407',2051966,'1652','226',62330.59,62462.15,131.56,28285.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','103407',2051967,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103408',2051968,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103408',2051969,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103408',2051970,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103408',2051971,'1652','226',62462.15,63004.74,542.59,116656.85,0.00,0.00,0.00,0.00,0.00),('1','72','593','103408',2051972,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103409',2051973,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103409',2051974,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103409',2051975,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103409',2051976,'1652','226',63004.74,63708.95,704.21,151405.15,0.00,0.00,0.00,0.00,0.00),('1','72','593','103409',2051977,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103410',2051978,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103410',2051979,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103410',2051980,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103410',2051981,'1652','226',63708.95,63799.17,80.22,17247.30,0.00,0.00,10.00,0.00,0.00),('1','72','593','103410',2051982,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103546',2054804,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103546',2054805,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103546',2054806,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103546',2054807,'1652','226',63799.17,66152.35,2353.18,505933.70,0.00,0.00,0.00,0.00,0.00),('1','72','593','103546',2054808,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103637',2056547,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103637',2056548,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103637',2056549,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103637',2056550,'1652','226',66152.35,66281.59,129.24,27786.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','103637',2056551,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103939',2062819,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103939',2062820,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103939',2062821,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103939',2062822,'1652','226',66281.59,66530.60,249.01,53537.15,0.00,0.00,0.00,0.00,0.00),('1','72','593','103939',2062823,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103941',2062834,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','103941',2062835,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','103941',2062836,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','103941',2062837,'1652','226',66530.60,67060.80,530.20,113993.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','103941',2062838,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','104452',2073402,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','104452',2073403,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','104452',2073404,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','104452',2073405,'1652','226',67060.80,68642.61,1581.81,340089.15,0.00,0.00,0.00,0.00,0.00),('1','72','593','104452',2073406,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','104453',2073407,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','104453',2073408,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','104453',2073409,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','104453',2073410,'1652','226',68642.61,69996.81,1354.20,291153.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','104453',2073411,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','104454',2073412,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','104454',2073413,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','104454',2073414,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','104454',2073415,'1652','226',69996.81,72614.24,2617.43,562747.45,0.00,0.00,0.00,0.00,0.00),('1','72','593','104454',2073416,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105304',2090728,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105304',2090729,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105304',2090730,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105304',2090731,'1652','226',72614.24,73298.49,684.25,147113.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','105304',2090732,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105307',2090801,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105307',2090802,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105307',2090803,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105307',2090804,'1652','226',73298.49,74565.65,1267.16,272439.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','105307',2090805,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105309',2090835,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105309',2090836,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105309',2090837,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105309',2090838,'1652','226',74565.65,75323.23,757.58,162879.70,0.00,0.00,0.00,0.00,0.00),('1','72','593','105309',2090839,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105311',2090874,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105311',2090875,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105311',2090876,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105311',2090877,'1652','226',75323.23,76884.30,1561.07,335630.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','105311',2090878,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105313',2090900,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105313',2090901,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105313',2090902,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105313',2090903,'1652','226',76884.30,76985.70,101.40,21801.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','105313',2090904,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105316',2090954,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105316',2090955,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105316',2090956,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105316',2090957,'1652','226',76985.70,77795.15,809.45,174031.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','105316',2090958,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105317',2090959,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105317',2090960,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105317',2090961,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105317',2090962,'1652','226',77795.15,77913.64,118.49,25475.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','105317',2090963,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105319',2090994,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105319',2090995,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105319',2090996,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105319',2090997,'1652','226',77913.64,79395.50,1481.86,318599.90,0.00,0.00,0.00,0.00,0.00),('1','72','593','105319',2090998,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105441',2093225,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105441',2093226,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105441',2093227,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105441',2093228,'1652','226',79395.50,80688.59,1293.09,278014.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','105441',2093229,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105704',2098026,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105704',2098027,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105704',2098028,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105704',2098029,'1652','226',80688.59,83809.24,3120.65,670939.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','105704',2098030,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105707',2098044,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','105707',2098045,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','105707',2098046,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','105707',2098047,'1652','226',83809.24,84858.12,1038.88,223359.20,0.00,0.00,10.00,0.00,0.00),('1','72','593','105707',2098048,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','106101',2105878,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','106101',2105879,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','106101',2105880,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','106101',2105881,'1652','226',84858.12,85729.33,871.21,187310.15,0.00,0.00,0.00,0.00,0.00),('1','72','593','106101',2105882,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','106407',2111658,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','106407',2111659,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','106407',2111660,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','106407',2111661,'1652','226',85729.33,86571.23,841.90,181008.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','106407',2111662,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','106408',2111663,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','106408',2111664,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','106408',2111665,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','106408',2111666,'1652','226',86571.23,86750.54,159.31,34251.65,0.00,0.00,20.00,0.00,0.00),('1','72','593','106408',2111667,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','106616',2115564,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','106616',2115565,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','106616',2115566,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','106616',2115567,'1652','226',86750.54,87857.42,1106.88,237979.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','106616',2115568,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','107245',2127904,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','107245',2127905,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','107245',2127906,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','107245',2127907,'1652','226',87857.42,88523.49,666.07,143205.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','107245',2127908,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','107246',2127909,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','107246',2127910,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','107246',2127911,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','107246',2127912,'1652','226',88523.49,89889.78,1366.29,293752.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','107246',2127913,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','107247',2127914,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','107247',2127915,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','107247',2127916,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','107247',2127917,'1652','226',89889.78,91259.77,1369.99,294547.85,0.00,0.00,0.00,0.00,0.00),('1','72','593','107247',2127918,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108010',2142479,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108010',2142480,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','108010',2142481,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','108010',2142482,'1652','226',91259.77,92269.59,1009.82,217111.30,0.00,0.00,0.00,0.00,0.00),('1','72','593','108010',2142483,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108013',2142525,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108013',2142526,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','108013',2142527,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','108013',2142528,'1652','226',92269.59,93058.78,789.19,169675.85,0.00,0.00,0.00,0.00,0.00),('1','72','593','108013',2142529,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108016',2142578,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108016',2142579,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','108016',2142580,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','108016',2142581,'1652','226',93058.78,94287.61,1228.83,264198.45,0.00,0.00,0.00,0.00,0.00),('1','72','593','108016',2142582,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108017',2142583,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108017',2142584,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','108017',2142585,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','108017',2142586,'1652','226',94287.61,94349.74,62.13,13357.95,0.00,0.00,0.00,0.00,0.00),('1','72','593','108017',2142587,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108316',2148723,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108316',2148724,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','108316',2148725,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','108316',2148726,'1652','226',94349.74,95542.43,1192.69,256428.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','108316',2148727,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108317',2148728,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108317',2148729,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','108317',2148730,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','108317',2148731,'1652','226',95542.43,96127.95,585.52,125886.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','108317',2148732,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108435',2151121,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','108435',2151122,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','108435',2151123,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','108435',2151124,'1652','226',96127.95,96328.64,200.69,43148.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','108435',2151125,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109098',2164092,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109098',2164093,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109098',2164094,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109098',2164095,'1652','226',96328.64,96438.43,109.79,23604.85,0.00,0.00,0.00,0.00,0.00),('1','72','593','109098',2164096,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109099',2164097,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109099',2164098,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109099',2164099,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109099',2164100,'1652','226',96438.43,97025.72,587.29,126267.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','109099',2164101,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109100',2164102,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109100',2164103,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109100',2164104,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109100',2164105,'1652','226',97025.72,97941.89,916.17,196976.55,0.00,0.00,0.00,0.00,0.00),('1','72','593','109100',2164106,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109101',2164107,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109101',2164108,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109101',2164109,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109101',2164110,'1652','226',97941.89,98013.98,72.09,15499.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','109101',2164111,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109102',2164112,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109102',2164113,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109102',2164114,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109102',2164115,'1652','226',98013.98,98677.11,663.13,142572.95,0.00,0.00,0.00,0.00,0.00),('1','72','593','109102',2164116,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109255',2167107,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109255',2167108,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109255',2167109,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109255',2167110,'1652','226',98677.11,99515.36,828.25,178073.75,0.00,0.00,10.00,0.00,0.00),('1','72','593','109255',2167111,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109723',2176333,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109723',2176334,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109723',2176335,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109723',2176336,'1652','226',99515.36,99580.65,65.29,14037.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','109723',2176337,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109724',2176338,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109724',2176339,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109724',2176340,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109724',2176341,'1652','226',99580.65,99775.62,194.97,41918.55,0.00,0.00,0.00,0.00,0.00),('1','72','593','109724',2176342,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109725',2176343,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109725',2176344,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109725',2176345,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109725',2176346,'1652','226',99775.62,99984.85,209.23,44984.45,0.00,0.00,0.00,0.00,0.00),('1','72','593','109725',2176347,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109726',2176348,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109726',2176349,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109726',2176350,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109726',2176351,'1652','226',99984.85,101125.15,1140.30,245164.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','109726',2176352,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109875',2179461,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','109875',2179462,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','109875',2179463,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','109875',2179464,'1652','226',101125.15,101987.21,862.06,185342.90,0.00,0.00,0.00,0.00,0.00),('1','72','593','109875',2179465,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110101',2184030,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110101',2184031,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','110101',2184032,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','110101',2184033,'1652','226',101987.21,102945.40,958.19,206010.85,0.00,0.00,0.00,0.00,0.00),('1','72','593','110101',2184034,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110102',2184035,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110102',2184036,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','110102',2184037,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','110102',2184038,'1652','226',102945.40,103023.57,78.17,16806.55,0.00,0.00,0.00,0.00,0.00),('1','72','593','110102',2184039,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110351',2189006,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110351',2189007,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','110351',2189008,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','110351',2189009,'1652','226',103023.57,104073.10,1049.53,225648.95,0.00,0.00,0.00,0.00,0.00),('1','72','593','110351',2189010,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110352',2189011,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110352',2189012,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','110352',2189013,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','110352',2189014,'1652','226',104073.10,104419.85,336.75,72401.25,0.00,0.00,10.00,0.00,0.00),('1','72','593','110352',2189015,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110778',2197379,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110778',2197380,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','110778',2197381,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','110778',2197382,'1652','226',104419.85,104987.49,567.64,122042.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','110778',2197383,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110779',2197384,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','110779',2197385,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','110779',2197386,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','110779',2197387,'1652','226',104987.49,106270.96,1283.47,275946.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','110779',2197388,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111011',2202017,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111011',2202018,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111011',2202019,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111011',2202020,'1652','226',106270.96,107019.35,748.39,160903.85,0.00,0.00,0.00,0.00,0.00),('1','72','593','111011',2202021,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111013',2202052,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111013',2202053,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111013',2202054,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111013',2202055,'1652','226',107019.35,107928.14,908.79,195389.85,0.00,0.00,0.00,0.00,0.00),('1','72','593','111013',2202056,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111014',2202057,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111014',2202058,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111014',2202059,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111014',2202060,'1652','226',107928.14,108680.01,751.87,161652.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','111014',2202061,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111745',2216800,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111745',2216801,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111745',2216802,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111745',2216803,'1652','226',108680.01,109833.10,1153.09,247914.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','111745',2216804,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111746',2216805,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111746',2216806,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111746',2216807,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111746',2216808,'1652','226',109833.10,110141.22,308.12,66245.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','111746',2216809,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111747',2216810,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111747',2216811,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111747',2216812,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111747',2216813,'1652','226',110141.22,110314.26,173.04,37203.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','111747',2216814,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111748',2216815,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111748',2216816,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111748',2216817,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111748',2216818,'1652','226',110314.26,110439.84,125.58,26999.70,0.00,0.00,0.00,0.00,0.00),('1','72','593','111748',2216819,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111750',2216848,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111750',2216849,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111750',2216850,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111750',2216851,'1652','226',110439.84,110761.40,321.56,69135.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','111750',2216852,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111751',2216853,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','111751',2216854,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','111751',2216855,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','111751',2216856,'1652','226',110761.40,110917.74,156.34,33613.10,0.00,0.00,0.00,0.00,0.00),('1','72','593','111751',2216857,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','113467',2252103,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','113467',2252104,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','113467',2252105,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','113467',2252106,'1652','226',110917.74,111712.37,794.63,174818.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','113467',2252107,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','113640',2255365,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','113640',2255366,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','113640',2255367,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','113640',2255368,'1652','226',111712.37,112478.74,766.37,168601.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','113640',2255369,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','113770',2257999,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','113770',2258000,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','113770',2258001,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','113770',2258002,'1652','226',112478.74,112992.28,513.54,112978.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','113770',2258003,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114027',2263143,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114027',2263144,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','114027',2263145,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','114027',2263146,'1652','226',112992.28,113628.90,636.62,140056.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','114027',2263147,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114029',2263165,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114029',2263166,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','114029',2263167,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','114029',2263168,'1652','226',113628.90,115200.84,1571.94,345826.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','114029',2263169,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114032',2263195,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114032',2263196,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','114032',2263197,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','114032',2263198,'1652','226',115200.84,115811.16,610.32,134270.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','114032',2263199,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114379',2270203,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114379',2270204,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','114379',2270205,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','114379',2270206,'1652','226',115811.16,116332.77,521.61,114754.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','114379',2270207,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114380',2270208,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114380',2270209,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','114380',2270210,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','114380',2270211,'1652','226',116332.77,116670.41,327.64,72080.80,0.00,0.00,10.00,0.00,0.00),('1','72','593','114380',2270212,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114381',2270213,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114381',2270214,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','114381',2270215,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','114381',2270216,'1652','226',116670.41,117811.52,1141.11,251044.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','114381',2270217,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114505',2272708,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','114505',2272709,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','114505',2272710,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','114505',2272711,'1652','226',117811.52,118465.62,654.10,143902.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','114505',2272712,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115235',2286579,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115235',2286580,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','115235',2286581,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','115235',2286582,'1652','226',118465.62,119212.59,746.97,164333.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','115235',2286583,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115236',2286584,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115236',2286585,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','115236',2286586,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','115236',2286587,'1652','226',119212.59,121360.35,2147.76,472507.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','115236',2286588,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115237',2286589,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115237',2286590,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','115237',2286591,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','115237',2286592,'1652','226',121360.35,124007.09,2646.74,582282.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','115237',2286593,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115238',2286594,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115238',2286595,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','115238',2286596,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','115238',2286597,'1652','226',124007.09,124167.57,160.48,35305.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','115238',2286598,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115239',2286599,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115239',2286600,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','115239',2286601,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','115239',2286602,'1652','226',124167.57,124963.55,785.98,172915.60,0.00,0.00,10.00,0.00,0.00),('1','72','593','115239',2286603,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115390',2290083,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115390',2290084,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','115390',2290085,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','115390',2290086,'1652','226',124963.55,125167.00,203.45,44759.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','115390',2290087,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115783',2298719,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115783',2298720,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','115783',2298721,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','115783',2298722,'1652','226',125167.00,125383.39,216.39,47605.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','115783',2298723,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115784',2298724,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','115784',2298725,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','115784',2298726,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','115784',2298727,'1652','226',125383.39,125634.53,251.14,55250.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','115784',2298728,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116802',2319839,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116802',2319840,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','116802',2319841,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','116802',2319842,'1652','226',125634.53,125765.67,131.14,28850.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','116802',2319843,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116822',2320270,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116822',2320271,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','116822',2320272,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','116822',2320273,'1652','226',125765.67,125903.29,137.62,30276.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','116822',2320274,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116869',2321504,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116869',2321505,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','116869',2321506,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','116869',2321507,'1652','226',125903.29,127279.20,1375.91,302700.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','116869',2321508,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116870',2321509,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116870',2321510,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','116870',2321511,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','116870',2321512,'1652','226',127279.20,127873.77,594.57,130805.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','116870',2321513,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116953',2323284,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116953',2323285,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','116953',2323286,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','116953',2323287,'1652','226',127873.77,128089.22,215.45,46321.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','116953',2323288,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116961',2323399,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','116961',2323400,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','116961',2323401,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','116961',2323402,'1652','226',128089.22,128434.23,345.01,74177.15,0.00,0.00,0.00,0.00,0.00),('1','72','593','116961',2323403,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117099',2326209,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117099',2326210,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','117099',2326211,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','117099',2326212,'1652','226',128434.23,128920.58,486.35,104565.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','117099',2326213,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117231',2328913,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117231',2328914,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','117231',2328915,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','117231',2328916,'1652','226',128920.58,129559.97,629.39,135318.85,0.00,0.00,10.00,0.00,0.00),('1','72','593','117231',2328917,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117392',2332290,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117392',2332291,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','117392',2332292,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','117392',2332293,'1652','226',129559.97,131854.68,2294.71,493362.65,0.00,0.00,0.00,0.00,0.00),('1','72','593','117392',2332294,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117510',2334781,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117510',2334782,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','117510',2334783,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','117510',2334784,'1652','226',131854.68,132638.63,783.95,168549.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','117510',2334785,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117613',2336817,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117613',2336818,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','117613',2336819,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','117613',2336820,'1652','226',132638.63,134649.23,2010.60,432279.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','117613',2336821,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117747',2339670,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117747',2339671,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','117747',2339672,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','117747',2339673,'1652','226',134649.23,135316.48,667.25,143458.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','117747',2339674,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117908',2343106,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','117908',2343107,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','117908',2343108,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','117908',2343109,'1652','226',135316.48,135944.73,628.25,135073.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','117908',2343110,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','118167',2348282,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','118167',2348283,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','118167',2348284,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','118167',2348285,'1652','226',135944.73,136220.07,275.34,59198.10,0.00,0.00,0.00,0.00,0.00),('1','72','593','118167',2348286,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','118311',2351185,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','118311',2351186,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','118311',2351187,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','118311',2351188,'1652','226',136220.07,136294.02,73.95,15899.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','118311',2351189,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126893',2528381,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126893',2528382,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126893',2528383,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126893',2528384,'1652','226',0.00,394.63,394.63,84845.45,0.00,0.00,0.00,0.00,0.00),('1','72','593','126893',2528385,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126896',2528456,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126896',2528457,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126896',2528458,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126896',2528459,'1652','226',394.63,1959.04,1564.41,336348.15,0.00,0.00,0.00,0.00,0.00),('1','72','593','126896',2528460,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126905',2528592,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126905',2528593,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126905',2528594,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126905',2528595,'1652','226',1959.04,3532.57,1573.53,338308.95,0.00,0.00,0.00,0.00,0.00),('1','72','593','126905',2528596,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126908',2528624,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126908',2528625,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126908',2528626,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126908',2528627,'1652','226',3532.57,3935.47,402.90,86623.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','126908',2528628,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126911',2528676,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126911',2528677,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126911',2528678,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126911',2528679,'1652','226',3935.47,4075.34,139.87,30072.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','126911',2528680,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126912',2528681,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126912',2528682,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126912',2528683,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126912',2528684,'1652','226',4075.34,4792.64,717.30,154219.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','126912',2528685,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126914',2528716,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126914',2528717,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126914',2528718,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126914',2528719,'1652','226',4792.64,5152.55,359.91,77380.65,0.00,0.00,0.00,0.00,0.00),('1','72','593','126914',2528720,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126916',2528737,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126916',2528738,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126916',2528739,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126916',2528740,'1652','226',5152.55,5311.77,159.22,34232.30,0.00,0.00,0.00,0.00,0.00),('1','72','593','126916',2528741,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126924',2528867,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','126924',2528868,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','126924',2528869,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','126924',2528870,'1652','226',5311.77,5460.61,148.84,32000.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','126924',2528871,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127015',2530627,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127015',2530628,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127015',2530629,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127015',2530630,'1652','226',5460.61,5641.31,180.70,38850.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','127015',2530631,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127017',2530648,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127017',2530649,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127017',2530650,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127017',2530651,'1652','226',5641.31,5798.33,157.02,33759.30,0.00,0.00,0.00,0.00,0.00),('1','72','593','127017',2530652,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127018',2530653,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127018',2530654,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127018',2530655,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127018',2530656,'1652','226',5798.33,5858.80,60.47,13001.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','127018',2530657,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127019',2530658,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127019',2530659,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127019',2530660,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127019',2530661,'1652','226',5858.80,5922.53,63.73,13701.95,0.00,0.00,0.00,0.00,0.00),('1','72','593','127019',2530662,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127021',2530678,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127021',2530679,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127021',2530680,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127021',2530681,'1652','226',5922.53,6266.82,344.29,74022.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','127021',2530682,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127024',2530722,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127024',2530723,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127024',2530724,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127024',2530725,'1652','226',6266.82,6567.17,300.35,67578.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','127024',2530726,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127026',2530743,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127026',2530744,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127026',2530745,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127026',2530746,'1652','226',6567.17,7279.44,712.27,160260.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','127026',2530747,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127027',2530748,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127027',2530749,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127027',2530750,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127027',2530751,'1652','226',7279.44,8192.21,912.77,205373.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','127027',2530752,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127029',2530769,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127029',2530770,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127029',2530771,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127029',2530772,'1652','226',8192.21,8651.65,459.44,103374.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127029',2530773,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127030',2530774,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127030',2530775,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127030',2530776,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127030',2530777,'1652','226',8651.65,8790.00,138.35,31128.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','127030',2530778,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127032',2530796,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127032',2530797,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127032',2530798,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127032',2530799,'1652','226',8790.00,9207.39,407.39,91662.75,0.00,0.00,10.00,0.00,0.00),('1','72','593','127032',2530800,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127035',2530834,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127035',2530835,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127035',2530836,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127035',2530837,'1652','226',9207.39,9464.43,257.04,57834.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127035',2530838,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127036',2530839,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127036',2530840,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127036',2530841,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127036',2530842,'1652','226',9464.43,10420.79,956.36,215181.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127036',2530843,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127039',2530885,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127039',2530886,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127039',2530887,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127039',2530888,'1652','226',10420.79,11462.76,1041.97,234443.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','127039',2530889,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127041',2530918,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127041',2530919,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127041',2530920,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127041',2530921,'1652','226',11462.76,11786.09,323.33,72749.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','127041',2530922,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127042',2530923,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127042',2530924,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127042',2530925,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127042',2530926,'1652','226',11786.09,11985.21,199.12,44802.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127042',2530927,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127044',2530950,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127044',2530951,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127044',2530952,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127044',2530953,'1652','226',11985.21,12251.88,266.67,60000.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','127044',2530954,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127048',2531029,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127048',2531030,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127048',2531031,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127048',2531032,'1652','226',12251.88,12531.72,279.84,62964.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127048',2531033,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127051',2531069,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127051',2531070,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127051',2531071,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127051',2531072,'1652','226',12531.72,13167.93,636.21,143147.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','127051',2531073,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127052',2531074,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127052',2531075,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127052',2531076,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127052',2531077,'1652','226',13167.93,13954.37,786.44,176949.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127052',2531078,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127054',2531095,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127054',2531096,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127054',2531097,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127054',2531098,'1652','226',13954.37,14830.64,876.27,197160.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','127054',2531099,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127055',2531100,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127055',2531101,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127055',2531102,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127055',2531103,'1652','226',14830.64,15543.08,712.44,160299.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127055',2531104,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127056',2531105,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127056',2531106,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127056',2531107,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127056',2531108,'1652','226',15543.08,15798.61,255.53,57494.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','127056',2531109,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127057',2531110,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127057',2531111,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127057',2531112,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127057',2531113,'1652','226',15798.61,16027.05,228.44,51399.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127057',2531114,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127060',2531139,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127060',2531140,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127060',2531141,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127060',2531142,'1652','226',16027.05,16633.12,606.07,136365.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','127060',2531143,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127061',2531144,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127061',2531145,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127061',2531146,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127061',2531147,'1652','226',16633.12,16843.51,210.39,47337.75,0.00,0.00,0.00,0.00,0.00),('1','72','593','127061',2531148,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127062',2531149,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127062',2531150,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127062',2531151,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127062',2531152,'1652','226',16843.51,17596.51,753.00,165660.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127062',2531153,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127064',2531171,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127064',2531172,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127064',2531173,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127064',2531174,'1652','226',17596.51,18304.74,698.23,153610.60,0.00,0.00,10.00,0.00,0.00),('1','72','593','127064',2531175,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127122',2532292,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127122',2532293,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127122',2532294,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127122',2532295,'1652','226',18304.74,18553.30,248.56,54683.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','127122',2532296,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127123',2532297,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127123',2532298,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127123',2532299,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127123',2532300,'1652','226',18553.30,19280.07,726.77,159889.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','127123',2532301,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127124',2532302,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127124',2532303,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127124',2532304,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127124',2532305,'1652','226',19280.07,20370.78,1090.71,239956.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','127124',2532306,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127125',2532307,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127125',2532308,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127125',2532309,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127125',2532310,'1652','226',20370.78,20466.22,95.44,20996.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','127125',2532311,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127126',2532312,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127126',2532313,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127126',2532314,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127126',2532315,'1652','226',20466.22,20560.42,94.20,20724.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127126',2532316,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127127',2532317,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127127',2532318,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127127',2532319,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127127',2532320,'1652','226',20560.42,20926.75,366.33,80592.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','127127',2532321,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127128',2532322,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127128',2532323,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127128',2532324,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127128',2532325,'1652','226',20926.75,21335.44,408.69,89911.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','127128',2532326,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127130',2532355,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127130',2532356,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127130',2532357,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127130',2532358,'1652','226',21335.44,22934.65,1599.21,351826.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','127130',2532359,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127131',2532360,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127131',2532361,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127131',2532362,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127131',2532363,'1652','226',22934.65,23205.58,270.93,58249.95,0.00,0.00,0.00,0.00,0.00),('1','72','593','127131',2532364,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127132',2532365,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127132',2532366,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127132',2532367,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127132',2532368,'1652','226',23205.58,23772.18,566.60,121819.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','127132',2532369,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127133',2532370,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127133',2532371,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127133',2532372,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127133',2532373,'1652','226',23772.18,24037.66,265.48,57078.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','127133',2532374,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127134',2532375,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127134',2532376,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127134',2532377,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127134',2532378,'1652','226',24037.66,25831.29,1793.63,385630.45,0.00,0.00,0.00,0.00,0.00),('1','72','593','127134',2532379,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127135',2532380,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127135',2532381,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127135',2532382,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127135',2532383,'1652','226',25831.29,25899.18,67.89,14596.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','127135',2532384,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127137',2532390,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127137',2532391,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127137',2532392,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127137',2532393,'1652','226',25899.18,26633.11,723.93,155644.95,0.00,0.00,10.00,0.00,0.00),('1','72','593','127137',2532394,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127138',2532395,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127138',2532396,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127138',2532397,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127138',2532398,'1652','226',26633.11,27142.42,509.31,109501.65,0.00,0.00,0.00,0.00,0.00),('1','72','593','127138',2532399,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127139',2532400,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127139',2532401,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127139',2532402,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127139',2532403,'1652','226',27142.42,27426.29,283.87,61032.05,0.00,0.00,0.00,0.00,0.00),('1','72','593','127139',2532404,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127140',2532405,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127140',2532406,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127140',2532407,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127140',2532408,'1652','226',27426.29,28124.71,698.42,150160.30,0.00,0.00,0.00,0.00,0.00),('1','72','593','127140',2532409,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127160',2532811,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127160',2532812,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127160',2532813,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127160',2532814,'1652','226',28124.71,28357.80,233.09,50114.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','127160',2532815,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127345',2536375,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127345',2536376,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127345',2536377,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127345',2536378,'1652','226',28357.80,28859.34,501.54,107831.10,0.00,0.00,0.00,0.00,0.00),('1','72','593','127345',2536379,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127348',2536413,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127348',2536414,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127348',2536415,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127348',2536416,'1652','226',28859.34,29679.52,820.18,176338.70,0.00,0.00,0.00,0.00,0.00),('1','72','593','127348',2536417,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127398',2537608,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127398',2537609,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127398',2537610,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127398',2537611,'1652','226',29679.52,30274.86,595.34,127998.10,0.00,0.00,0.00,0.00,0.00),('1','72','593','127398',2537612,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127865',2547397,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127865',2547398,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127865',2547399,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127865',2547400,'1652','226',30274.86,30339.98,65.12,14000.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','127865',2547401,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127867',2547424,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127867',2547425,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127867',2547426,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127867',2547427,'1652','226',30339.98,30909.28,569.30,122399.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','127867',2547428,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127868',2547429,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127868',2547430,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127868',2547431,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127868',2547432,'1652','226',30909.28,31327.40,418.12,89895.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','127868',2547433,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127869',2547434,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127869',2547435,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127869',2547436,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127869',2547437,'1652','226',31327.40,31797.76,470.36,101127.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','127869',2547438,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127976',2549565,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','127976',2549566,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','127976',2549567,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','127976',2549568,'1652','226',31797.76,32105.04,307.28,66065.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','127976',2549569,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','128233',2554956,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','128233',2554957,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','128233',2554958,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','128233',2554959,'1652','226',32105.04,32297.45,192.41,41368.15,0.00,0.00,0.00,0.00,0.00),('1','72','593','128233',2554960,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','128256',2555390,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','128256',2555391,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','128256',2555392,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','128256',2555393,'1652','226',32297.45,33599.65,1302.20,279973.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','128256',2555394,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','128384',2557822,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','128384',2557823,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','128384',2557824,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','128384',2557825,'1652','226',33599.65,34604.25,994.60,208866.00,0.00,0.00,10.00,0.00,0.00),('1','72','593','128384',2557826,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','128488',2559794,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','128488',2559795,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','128488',2559796,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','128488',2559797,'1652','226',34604.25,34725.08,120.83,25374.30,0.00,0.00,0.00,0.00,0.00),('1','72','593','128488',2559798,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129160',2574296,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129160',2574297,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','129160',2574298,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','129160',2574299,'1652','226',34725.08,35754.71,1029.63,216222.30,0.00,0.00,0.00,0.00,0.00),('1','72','593','129160',2574300,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129161',2574301,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129161',2574302,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','129161',2574303,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','129161',2574304,'1652','226',35754.71,35868.77,114.06,23952.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','129161',2574305,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129163',2574313,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129163',2574314,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','129163',2574315,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','129163',2574316,'1652','226',35868.77,35920.95,52.18,10957.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','129163',2574317,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129167',2574349,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129167',2574350,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','129167',2574351,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','129167',2574352,'1652','226',35920.95,35996.38,75.43,15840.30,0.00,0.00,0.00,0.00,0.00),('1','72','593','129167',2574353,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129169',2574376,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129169',2574377,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','129169',2574378,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','129169',2574379,'1652','226',35996.38,36240.67,244.29,51300.90,0.00,0.00,0.00,0.00,0.00),('1','72','593','129169',2574380,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129280',2576549,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129280',2576550,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','129280',2576551,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','129280',2576552,'1652','226',36240.67,36313.52,72.85,15298.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','129280',2576553,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129442',2579638,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','129442',2579639,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','129442',2579640,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','129442',2579641,'1652','226',36313.52,36602.57,289.05,60700.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','129442',2579642,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130093',2593156,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130093',2593157,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','130093',2593158,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','130093',2593159,'1652','226',36602.57,38110.03,1507.46,316566.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','130093',2593160,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130096',2593207,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130096',2593208,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','130096',2593209,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','130096',2593210,'1652','226',38110.03,38151.45,41.42,8698.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','130096',2593211,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130097',2593212,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130097',2593213,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','130097',2593214,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','130097',2593215,'1652','226',38151.45,38289.29,137.84,28946.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','130097',2593216,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130100',2593245,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130100',2593246,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','130100',2593247,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','130100',2593248,'1652','226',38289.29,38352.15,62.86,13200.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','130100',2593249,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130233',2596148,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130233',2596149,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','130233',2596150,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','130233',2596151,'1652','226',38352.15,38455.00,102.85,21598.50,0.00,0.00,0.00,0.00,0.00),('1','72','593','130233',2596152,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130534',2602665,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130534',2602666,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','130534',2602667,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','130534',2602668,'1652','226',38455.00,38578.98,123.98,26035.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','130534',2602669,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130537',2602708,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','130537',2602709,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','130537',2602710,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','130537',2602711,'1652','226',38578.98,39265.34,686.36,144135.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','130537',2602712,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135118',2699620,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135118',2699621,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','135118',2699622,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','135118',2699623,'1652','226',39265.34,39924.52,659.18,131836.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','135118',2699624,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135209',2701426,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135209',2701427,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','135209',2701428,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','135209',2701429,'1652','226',39924.52,40711.89,787.37,157474.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','135209',2701430,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135322',2703856,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135322',2703857,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','135322',2703858,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','135322',2703859,'1652','226',40711.89,41157.39,445.50,89100.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','135322',2703860,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135428',2706071,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135428',2706072,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','135428',2706073,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','135428',2706074,'1652','226',41157.39,41705.59,548.20,109640.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','135428',2706075,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135560',2708603,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135560',2708604,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','135560',2708605,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','135560',2708606,'1652','226',41705.59,42367.59,662.00,132400.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','135560',2708607,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135778',2713434,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135778',2713435,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','135778',2713436,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','135778',2713437,'1652','226',42367.59,42832.09,464.50,92900.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','135778',2713438,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135780',2713454,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','135780',2713455,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','135780',2713456,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','135780',2713457,'1652','226',42832.09,42882.09,50.00,10000.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','135780',2713458,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136140',2721019,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136140',2721020,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','136140',2721021,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','136140',2721022,'1652','226',42882.09,42947.09,65.00,13000.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','136140',2721023,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136142',2721048,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136142',2721049,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','136142',2721050,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','136142',2721051,'1652','226',42947.09,43457.74,510.65,102130.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','136142',2721052,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136143',2721053,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136143',2721054,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','136143',2721055,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','136143',2721056,'1652','226',43457.74,43710.39,252.65,50530.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','136143',2721057,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136329',2725090,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136329',2725091,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','136329',2725092,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','136329',2725093,'1652','226',43710.39,44275.37,564.98,112996.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','136329',2725094,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136331',2725110,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136331',2725111,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','136331',2725112,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','136331',2725113,'1652','226',44275.37,45022.91,747.54,149508.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','136331',2725114,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136570',2730047,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136570',2730048,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','136570',2730049,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','136570',2730050,'1652','226',45022.91,45137.11,104.20,20319.00,0.00,0.00,10.00,0.00,0.00),('1','72','593','136570',2730051,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136572',2730065,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','136572',2730066,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','136572',2730067,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','136572',2730068,'1652','226',45137.11,45208.24,71.13,13870.35,0.00,0.00,0.00,0.00,0.00),('1','72','593','136572',2730069,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137251',2744568,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137251',2744569,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137251',2744570,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137251',2744571,'1652','226',45208.24,45388.50,180.26,35150.70,0.00,0.00,0.00,0.00,0.00),('1','72','593','137251',2744572,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137252',2744573,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137252',2744574,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137252',2744575,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137252',2744576,'1652','226',45388.50,45933.93,545.43,106358.85,0.00,0.00,0.00,0.00,0.00),('1','72','593','137252',2744577,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137253',2744578,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137253',2744579,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137253',2744580,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137253',2744581,'1652','226',45933.93,46310.85,376.92,73499.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','137253',2744582,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137254',2744583,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137254',2744584,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137254',2744585,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137254',2744586,'1652','226',46310.85,46762.13,451.28,87999.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','137254',2744587,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137255',2744588,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137255',2744589,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137255',2744590,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137255',2744591,'1652','226',46762.13,47008.79,246.66,48098.70,0.00,0.00,0.00,0.00,0.00),('1','72','593','137255',2744592,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137422',2748198,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137422',2748199,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137422',2748200,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137422',2748201,'1652','226',47008.79,47255.47,246.68,48102.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','137422',2748202,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137768',2755089,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137768',2755090,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137768',2755091,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137768',2755092,'1652','226',47255.47,47707.82,452.35,88208.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','137768',2755093,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137769',2755094,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137769',2755095,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137769',2755096,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137769',2755097,'1652','226',47707.82,47818.08,110.26,21500.70,0.00,0.00,0.00,0.00,0.00),('1','72','593','137769',2755098,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137910',2758223,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','137910',2758224,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','137910',2758225,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','137910',2758226,'1652','226',47818.08,48428.23,610.15,118979.25,0.00,0.00,0.00,0.00,0.00),('1','72','593','137910',2758227,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138041',2761148,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138041',2761149,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','138041',2761150,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','138041',2761151,'1652','226',48428.23,50072.39,1644.16,320611.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','138041',2761152,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138462',2769735,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138462',2769736,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','138462',2769737,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','138462',2769738,'1652','226',50072.39,50200.98,128.59,24432.10,0.00,0.00,0.00,0.00,0.00),('1','72','593','138462',2769739,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138465',2769805,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138465',2769806,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','138465',2769807,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','138465',2769808,'1652','226',50200.98,50752.27,551.29,104745.10,0.00,0.00,0.00,0.00,0.00),('1','72','593','138465',2769809,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138468',2769848,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138468',2769849,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','138468',2769850,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','138468',2769851,'1652','226',50752.27,50912.75,160.48,30491.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','138468',2769852,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138471',2769886,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138471',2769887,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','138471',2769888,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','138471',2769889,'1652','226',50912.75,51085.89,173.14,32896.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','138471',2769890,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138605',2772643,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','138605',2772644,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','138605',2772645,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','138605',2772646,'1652','226',51085.89,51237.47,151.58,28800.20,0.00,0.00,0.00,0.00,0.00),('1','72','593','138605',2772647,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139809',2797328,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139809',2797329,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','139809',2797330,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','139809',2797331,'1652','226',51237.47,51457.99,220.52,41898.80,0.00,0.00,0.00,0.00,0.00),('1','72','593','139809',2797332,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139812',2797388,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139812',2797389,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','139812',2797390,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','139812',2797391,'1652','226',51457.99,51756.68,298.69,56751.10,0.00,0.00,0.00,0.00,0.00),('1','72','593','139812',2797392,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139814',2797410,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139814',2797411,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','139814',2797412,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','139814',2797413,'1652','226',51756.68,52150.38,393.70,74803.00,0.00,0.00,0.00,0.00,0.00),('1','72','593','139814',2797414,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139816',2797425,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139816',2797426,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','139816',2797427,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','139816',2797428,'1652','226',52150.38,52255.64,105.26,19999.40,0.00,0.00,0.00,0.00,0.00),('1','72','593','139816',2797429,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139817',2797430,'1649','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','590','139817',2797431,'1650','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','591','139817',2797432,'1651','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','72','592','139817',2797433,'1652','226',52255.64,52298.98,43.34,8234.60,0.00,0.00,0.00,0.00,0.00),('1','72','593','139817',2797434,'1653','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=420601 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','72','70008','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,210988),('1','72','70008','226',260.00,260.00,388.59,0.00,0.00,0.00,0.00,210989),('1','72','70008','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,210990),('1','72','70659','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,212945),('1','72','70659','226',260.00,260.00,1064.17,0.00,0.00,0.00,0.00,212946),('1','72','70659','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,212947),('1','72','70697','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213061),('1','72','70697','226',260.00,260.00,1173.03,0.00,0.00,0.00,0.00,213062),('1','72','70697','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213063),('1','72','70699','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213067),('1','72','70699','226',260.00,260.00,1761.91,0.00,0.00,0.00,0.00,213068),('1','72','70699','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213069),('1','72','70700','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213070),('1','72','70700','226',260.00,260.00,680.34,0.00,0.00,0.00,0.00,213071),('1','72','70700','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213072),('1','72','70702','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213076),('1','72','70702','226',260.00,260.00,367.32,0.00,0.00,0.00,0.00,213077),('1','72','70702','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213078),('1','72','70708','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213094),('1','72','70708','226',260.00,260.00,715.79,0.00,0.00,0.00,0.00,213095),('1','72','70708','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213096),('1','72','70783','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213319),('1','72','70783','226',260.00,260.00,903.86,0.00,0.00,0.00,0.00,213320),('1','72','70783','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213321),('1','72','70893','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213650),('1','72','70893','226',260.00,260.00,575.54,0.00,0.00,0.00,0.00,213651),('1','72','70893','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213652),('1','72','70896','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213659),('1','72','70896','226',260.00,260.00,373.14,0.00,0.00,0.00,0.00,213660),('1','72','70896','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213661),('1','72','71086','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,214229),('1','72','71086','226',260.00,260.00,769.09,0.00,0.00,0.00,0.00,214230),('1','72','71086','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,214231),('1','72','71118','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,214327),('1','72','71118','226',260.00,260.00,342.03,0.00,0.00,0.00,0.00,214328),('1','72','71118','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,214329),('1','72','71373','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215093),('1','72','71373','226',260.00,260.00,627.94,0.00,0.00,0.00,0.00,215094),('1','72','71373','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215095),('1','72','71374','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215096),('1','72','71374','226',260.00,260.00,605.56,0.00,0.00,0.00,0.00,215097),('1','72','71374','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215098),('1','72','71508','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215500),('1','72','71508','226',260.00,260.00,721.57,0.00,0.00,0.00,0.00,215501),('1','72','71508','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215502),('1','72','71638','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215891),('1','72','71638','226',260.00,260.00,1744.75,0.00,0.00,0.00,0.00,215892),('1','72','71638','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215893),('1','72','72177','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217511),('1','72','72177','226',260.00,260.00,1641.29,0.00,0.00,0.00,0.00,217512),('1','72','72177','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217513),('1','72','72179','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217517),('1','72','72179','226',260.00,260.00,1110.37,0.00,0.00,0.00,0.00,217518),('1','72','72179','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217519),('1','72','72206','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217598),('1','72','72206','226',260.00,260.00,1896.24,0.00,0.00,0.00,0.00,217599),('1','72','72206','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217600),('1','72','72209','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217607),('1','72','72209','226',260.00,260.00,547.33,0.00,0.00,0.00,0.00,217608),('1','72','72209','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217609),('1','72','72489','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,218449),('1','72','72489','226',255.00,255.00,1040.26,0.00,0.00,0.00,0.00,218450),('1','72','72489','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,218451),('1','72','72713','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219123),('1','72','72713','226',255.00,255.00,824.53,0.00,0.00,0.00,0.00,219124),('1','72','72713','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219125),('1','72','72718','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219138),('1','72','72718','226',255.00,255.00,525.54,0.00,0.00,0.00,0.00,219139),('1','72','72718','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219140),('1','72','72799','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219381),('1','72','72799','226',250.00,250.00,104.51,0.00,0.00,0.00,0.00,219382),('1','72','72799','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219383),('1','72','72801','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219387),('1','72','72801','226',250.00,250.00,855.23,0.00,0.00,0.00,0.00,219388),('1','72','72801','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219389),('1','72','72955','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219851),('1','72','72955','226',250.00,250.00,774.40,0.00,0.00,0.00,0.00,219852),('1','72','72955','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219853),('1','72','73086','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220245),('1','72','73086','226',250.00,250.00,656.52,0.00,0.00,0.00,0.00,220246),('1','72','73086','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220247),('1','72','73203','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220597),('1','72','73203','226',250.00,250.00,78.20,0.00,0.00,0.00,0.00,220598),('1','72','73203','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220599),('1','72','73206','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220606),('1','72','73206','226',245.00,245.00,145.09,0.00,0.00,0.00,0.00,220607),('1','72','73206','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220608),('1','72','73319','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220945),('1','72','73319','226',245.00,245.00,679.40,0.00,0.00,0.00,0.00,220946),('1','72','73319','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220947),('1','72','73410','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,221219),('1','72','73410','226',245.00,245.00,1295.30,0.00,0.00,0.00,0.00,221220),('1','72','73410','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,221221),('1','72','73567','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,221692),('1','72','73567','226',245.00,245.00,1444.71,0.00,0.00,0.00,0.00,221693),('1','72','73567','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,221694),('1','72','73748','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,222235),('1','72','73748','226',245.00,245.00,697.69,0.00,0.00,0.00,0.00,222236),('1','72','73748','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,222237),('1','72','73750','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,222241),('1','72','73750','226',245.00,245.00,482.29,0.00,0.00,0.00,0.00,222242),('1','72','73750','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,222243),('1','72','73868','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,222595),('1','72','73868','226',245.00,245.00,1241.12,0.00,0.00,0.00,0.00,222596),('1','72','73868','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,222597),('1','72','74467','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224399),('1','72','74467','226',245.00,245.00,687.02,0.00,0.00,0.00,0.00,224400),('1','72','74467','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224401),('1','72','74468','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224402),('1','72','74468','226',245.00,245.00,800.22,0.00,0.00,0.00,0.00,224403),('1','72','74468','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224404),('1','72','74469','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224405),('1','72','74469','226',245.00,245.00,1302.76,0.00,0.00,0.00,0.00,224406),('1','72','74469','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224407),('1','72','74470','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224408),('1','72','74470','226',245.00,245.00,1151.43,0.00,0.00,0.00,0.00,224409),('1','72','74470','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224410),('1','72','74585','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224753),('1','72','74585','226',245.00,245.00,529.50,0.00,0.00,0.00,0.00,224754),('1','72','74585','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224755),('1','72','74586','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224756),('1','72','74586','226',245.00,245.00,499.70,0.00,0.00,0.00,0.00,224757),('1','72','74586','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224758),('1','72','74705','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,225113),('1','72','74705','226',240.00,240.00,2071.30,0.00,0.00,0.00,0.00,225114),('1','72','74705','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,225115),('1','72','75048','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226147),('1','72','75048','226',240.00,240.00,1171.02,0.00,0.00,0.00,0.00,226148),('1','72','75048','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226149),('1','72','75050','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226153),('1','72','75050','226',240.00,240.00,750.10,0.00,0.00,0.00,0.00,226154),('1','72','75050','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226155),('1','72','75100','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226303),('1','72','75100','226',240.00,240.00,1317.44,0.00,0.00,0.00,0.00,226304),('1','72','75100','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226305),('1','72','75233','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226703),('1','72','75233','226',240.00,240.00,818.11,0.00,0.00,0.00,0.00,226704),('1','72','75233','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226705),('1','72','75365','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227100),('1','72','75365','226',240.00,240.00,757.55,0.00,0.00,0.00,0.00,227101),('1','72','75365','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227102),('1','72','75446','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227344),('1','72','75446','226',240.00,240.00,245.54,0.00,0.00,0.00,0.00,227345),('1','72','75446','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227346),('1','72','75595','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227793),('1','72','75595','226',240.00,240.00,452.51,0.00,0.00,0.00,0.00,227794),('1','72','75595','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227795),('1','72','75737','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,228219),('1','72','75737','226',240.00,240.00,1217.26,0.00,0.00,0.00,0.00,228220),('1','72','75737','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,228221),('1','72','75811','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,228442),('1','72','75811','226',240.00,240.00,688.94,0.00,0.00,0.00,0.00,228443),('1','72','75811','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,228444),('1','72','76011','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,229043),('1','72','76011','226',240.00,240.00,1649.43,0.00,0.00,0.00,0.00,229044),('1','72','76011','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,229045),('1','72','76054','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,229172),('1','72','76054','226',240.00,240.00,1801.40,0.00,0.00,0.00,0.00,229173),('1','72','76054','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,229174),('1','72','76689','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231081),('1','72','76689','226',240.00,240.00,537.38,0.00,0.00,0.00,0.00,231082),('1','72','76689','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231083),('1','72','76691','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231087),('1','72','76691','226',240.00,240.00,1183.32,0.00,0.00,0.00,0.00,231088),('1','72','76691','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231089),('1','72','76692','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231090),('1','72','76692','226',240.00,240.00,616.47,0.00,0.00,0.00,0.00,231091),('1','72','76692','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231092),('1','72','76693','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231093),('1','72','76693','226',240.00,240.00,1974.30,0.00,0.00,0.00,0.00,231094),('1','72','76693','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231095),('1','72','76903','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231725),('1','72','76903','226',240.00,240.00,899.51,0.00,0.00,0.00,0.00,231726),('1','72','76903','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231727),('1','72','76933','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231815),('1','72','76933','226',240.00,240.00,60.83,0.00,0.00,0.00,0.00,231816),('1','72','76933','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231817),('1','72','77064','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232209),('1','72','77064','226',230.00,230.00,543.67,0.00,0.00,0.00,0.00,232210),('1','72','77064','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232211),('1','72','77066','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232215),('1','72','77066','226',230.00,230.00,741.18,0.00,0.00,0.00,0.00,232216),('1','72','77066','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232217),('1','72','77272','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232835),('1','72','77272','226',230.00,230.00,286.34,0.00,0.00,0.00,0.00,232836),('1','72','77272','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232837),('1','72','77315','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232964),('1','72','77315','226',230.00,230.00,42.03,0.00,0.00,0.00,0.00,232965),('1','72','77315','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232966),('1','72','77462','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233405),('1','72','77462','226',225.00,225.00,289.12,0.00,0.00,0.00,0.00,233406),('1','72','77462','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233407),('1','72','77463','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233408),('1','72','77463','226',225.00,225.00,1403.01,0.00,0.00,0.00,0.00,233409),('1','72','77463','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233410),('1','72','77687','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,234085),('1','72','77687','226',225.00,225.00,3366.53,0.00,0.00,0.00,0.00,234086),('1','72','77687','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,234087),('1','72','77689','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,234091),('1','72','77689','226',225.00,225.00,825.28,0.00,0.00,0.00,0.00,234092),('1','72','77689','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,234093),('1','72','77823','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,234494),('1','72','77823','226',225.00,225.00,282.22,0.00,0.00,0.00,0.00,234495),('1','72','77823','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,234496),('1','72','78030','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235117),('1','72','78030','226',225.00,225.00,1913.65,0.00,0.00,0.00,0.00,235118),('1','72','78030','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235119),('1','72','78034','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235129),('1','72','78034','226',225.00,225.00,1865.25,0.00,0.00,0.00,0.00,235130),('1','72','78034','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235131),('1','72','78192','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235603),('1','72','78192','226',225.00,225.00,1490.41,0.00,0.00,0.00,0.00,235604),('1','72','78192','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235605),('1','72','78387','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236188),('1','72','78387','226',225.00,225.00,675.97,0.00,0.00,0.00,0.00,236189),('1','72','78387','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236190),('1','72','78479','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236466),('1','72','78479','226',225.00,225.00,2438.81,0.00,0.00,0.00,0.00,236467),('1','72','78479','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236468),('1','72','78655','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236995),('1','72','78655','226',225.00,225.00,1917.03,0.00,0.00,0.00,0.00,236996),('1','72','78655','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236997),('1','72','78943','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237861),('1','72','78943','226',225.00,225.00,1027.11,0.00,0.00,0.00,0.00,237862),('1','72','78943','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237863),('1','72','78944','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237864),('1','72','78944','226',225.00,225.00,372.74,0.00,0.00,0.00,0.00,237865),('1','72','78944','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237866),('1','72','78945','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237867),('1','72','78945','226',225.00,225.00,650.88,0.00,0.00,0.00,0.00,237868),('1','72','78945','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237869),('1','72','79065','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,238228),('1','72','79065','226',225.00,225.00,203.07,0.00,0.00,0.00,0.00,238229),('1','72','79065','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,238230),('1','72','79236','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,238742),('1','72','79236','226',225.00,225.00,796.69,0.00,0.00,0.00,0.00,238743),('1','72','79236','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,238744),('1','72','79453','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,239395),('1','72','79453','226',225.00,225.00,985.25,0.00,0.00,0.00,0.00,239396),('1','72','79453','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,239397),('1','72','79457','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,239408),('1','72','79457','226',225.00,225.00,462.99,0.00,0.00,0.00,0.00,239409),('1','72','79457','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,239410),('1','72','79929','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240827),('1','72','79929','226',225.00,225.00,741.74,0.00,0.00,0.00,0.00,240828),('1','72','79929','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240829),('1','72','79930','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240830),('1','72','79930','226',225.00,225.00,846.73,0.00,0.00,0.00,0.00,240831),('1','72','79930','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240832),('1','72','79931','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240833),('1','72','79931','226',225.00,225.00,579.70,0.00,0.00,0.00,0.00,240834),('1','72','79931','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240835),('1','72','79932','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240836),('1','72','79932','226',225.00,225.00,569.39,0.00,0.00,0.00,0.00,240837),('1','72','79932','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240838),('1','72','80134','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241444),('1','72','80134','226',225.00,225.00,251.74,0.00,0.00,0.00,0.00,241445),('1','72','80134','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241446),('1','72','80238','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241757),('1','72','80238','226',225.00,225.00,264.82,0.00,0.00,0.00,0.00,241758),('1','72','80238','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241759),('1','72','80378','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,242178),('1','72','80378','226',225.00,225.00,114.30,0.00,0.00,0.00,0.00,242179),('1','72','80378','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,242180),('1','72','80465','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,242440),('1','72','80465','226',225.00,225.00,426.44,0.00,0.00,0.00,0.00,242441),('1','72','80465','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,242442),('1','72','80754','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243309),('1','72','80754','226',225.00,225.00,104.35,0.00,0.00,0.00,0.00,243310),('1','72','80754','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243311),('1','72','80755','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243312),('1','72','80755','226',225.00,225.00,405.24,0.00,0.00,0.00,0.00,243313),('1','72','80755','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243314),('1','72','80854','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243610),('1','72','80854','226',225.00,225.00,625.24,0.00,0.00,0.00,0.00,243611),('1','72','80854','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243612),('1','72','81143','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244478),('1','72','81143','226',225.00,225.00,642.15,0.00,0.00,0.00,0.00,244479),('1','72','81143','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244480),('1','72','81145','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244484),('1','72','81145','226',225.00,225.00,96.45,0.00,0.00,0.00,0.00,244485),('1','72','81145','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244486),('1','72','81254','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244813),('1','72','81254','226',225.00,225.00,139.56,0.00,0.00,0.00,0.00,244814),('1','72','81254','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244815),('1','72','81306','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244969),('1','72','81306','226',225.00,225.00,249.66,0.00,0.00,0.00,0.00,244970),('1','72','81306','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244971),('1','72','81484','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,245504),('1','72','81484','226',225.00,225.00,538.71,0.00,0.00,0.00,0.00,245505),('1','72','81484','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,245506),('1','72','81486','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,245510),('1','72','81486','226',225.00,225.00,276.89,0.00,0.00,0.00,0.00,245511),('1','72','81486','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,245512),('1','72','82447','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248401),('1','72','82447','226',225.00,225.00,733.58,0.00,0.00,0.00,0.00,248402),('1','72','82447','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248403),('1','72','82452','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248416),('1','72','82452','226',225.00,225.00,327.37,0.00,0.00,0.00,0.00,248417),('1','72','82452','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248418),('1','72','82454','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248422),('1','72','82454','226',225.00,225.00,344.67,0.00,0.00,0.00,0.00,248423),('1','72','82454','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248424),('1','72','82457','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248431),('1','72','82457','226',225.00,225.00,55.61,0.00,0.00,0.00,0.00,248432),('1','72','82457','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248433),('1','72','82459','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248437),('1','72','82459','226',225.00,225.00,418.99,0.00,0.00,0.00,0.00,248438),('1','72','82459','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248439),('1','72','82461','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248443),('1','72','82461','226',225.00,225.00,761.31,0.00,0.00,0.00,0.00,248444),('1','72','82461','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248445),('1','72','82462','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248446),('1','72','82462','226',225.00,225.00,657.77,0.00,0.00,0.00,0.00,248447),('1','72','82462','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248448),('1','72','82564','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248753),('1','72','82564','226',225.00,225.00,219.22,0.00,0.00,0.00,0.00,248754),('1','72','82564','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248755),('1','72','82700','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249162),('1','72','82700','226',225.00,225.00,109.61,0.00,0.00,0.00,0.00,249163),('1','72','82700','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249164),('1','72','82876','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249691),('1','72','82876','226',225.00,225.00,225.96,0.00,0.00,0.00,0.00,249692),('1','72','82876','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249693),('1','72','82878','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249697),('1','72','82878','226',225.00,225.00,513.27,0.00,0.00,0.00,0.00,249698),('1','72','82878','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249699),('1','72','83188','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250630),('1','72','83188','226',225.00,225.00,162.71,0.00,0.00,0.00,0.00,250631),('1','72','83188','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250632),('1','72','83190','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250636),('1','72','83190','226',225.00,225.00,230.87,0.00,0.00,0.00,0.00,250637),('1','72','83190','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250638),('1','72','83192','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250642),('1','72','83192','226',225.00,225.00,325.56,0.00,0.00,0.00,0.00,250643),('1','72','83192','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250644),('1','72','83415','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251313),('1','72','83415','226',225.00,225.00,101.78,0.00,0.00,0.00,0.00,251314),('1','72','83415','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251315),('1','72','83580','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251809),('1','72','83580','226',225.00,225.00,129.69,0.00,0.00,0.00,0.00,251810),('1','72','83580','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251811),('1','72','83581','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251812),('1','72','83581','226',225.00,225.00,65.55,0.00,0.00,0.00,0.00,251813),('1','72','83581','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251814),('1','72','84187','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253635),('1','72','84187','226',225.00,225.00,95.56,0.00,0.00,0.00,0.00,253636),('1','72','84187','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253637),('1','72','84188','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253638),('1','72','84188','226',225.00,225.00,176.26,0.00,0.00,0.00,0.00,253639),('1','72','84188','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253640),('1','72','84190','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253644),('1','72','84190','226',225.00,225.00,98.00,0.00,0.00,0.00,0.00,253645),('1','72','84190','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253646),('1','72','84192','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253650),('1','72','84192','226',225.00,225.00,68.44,0.00,0.00,0.00,0.00,253651),('1','72','84192','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253652),('1','72','84193','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253653),('1','72','84193','226',225.00,225.00,247.78,0.00,0.00,0.00,0.00,253654),('1','72','84193','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253655),('1','72','84394','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,254257),('1','72','84394','226',225.00,225.00,93.11,0.00,0.00,0.00,0.00,254258),('1','72','84394','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,254259),('1','72','84496','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,254563),('1','72','84496','226',225.00,225.00,68.00,0.00,0.00,0.00,0.00,254564),('1','72','84496','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,254565),('1','72','84808','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255502),('1','72','84808','226',225.00,225.00,446.00,0.00,0.00,0.00,0.00,255503),('1','72','84808','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255504),('1','72','84809','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255505),('1','72','84809','226',225.00,225.00,62.21,0.00,0.00,0.00,0.00,255506),('1','72','84809','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255507),('1','72','84812','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255514),('1','72','84812','226',225.00,225.00,151.98,0.00,0.00,0.00,0.00,255515),('1','72','84812','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255516),('1','72','84908','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255803),('1','72','84908','226',225.00,225.00,33.33,0.00,0.00,0.00,0.00,255804),('1','72','84908','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255805),('1','72','85145','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,256516),('1','72','85145','226',225.00,225.00,103.11,0.00,0.00,0.00,0.00,256517),('1','72','85145','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,256518),('1','72','85147','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,256522),('1','72','85147','226',225.00,225.00,157.12,0.00,0.00,0.00,0.00,256523),('1','72','85147','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,256524),('1','72','85271','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,256895),('1','72','85271','226',225.00,225.00,97.79,0.00,0.00,0.00,0.00,256896),('1','72','85271','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,256897),('1','72','85841','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258609),('1','72','85841','226',225.00,225.00,903.17,0.00,0.00,0.00,0.00,258610),('1','72','85841','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258611),('1','72','85842','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258612),('1','72','85842','226',225.00,225.00,43.12,0.00,0.00,0.00,0.00,258613),('1','72','85842','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258614),('1','72','85843','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258615),('1','72','85843','226',225.00,225.00,68.89,0.00,0.00,0.00,0.00,258616),('1','72','85843','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258617),('1','72','85847','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258627),('1','72','85847','226',225.00,225.00,35.55,0.00,0.00,0.00,0.00,258628),('1','72','85847','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258629),('1','72','85940','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258908),('1','72','85940','226',225.00,225.00,280.42,0.00,0.00,0.00,0.00,258909),('1','72','85940','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258910),('1','72','86103','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,259398),('1','72','86103','226',225.00,225.00,506.89,0.00,0.00,0.00,0.00,259399),('1','72','86103','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,259400),('1','72','86601','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260895),('1','72','86601','226',225.00,225.00,186.47,0.00,0.00,0.00,0.00,260896),('1','72','86601','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260897),('1','72','86605','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260907),('1','72','86605','226',225.00,225.00,127.78,0.00,0.00,0.00,0.00,260908),('1','72','86605','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260909),('1','72','86608','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260916),('1','72','86608','226',225.00,225.00,47.82,0.00,0.00,0.00,0.00,260917),('1','72','86608','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260918),('1','72','86612','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260928),('1','72','86612','226',225.00,225.00,49.34,0.00,0.00,0.00,0.00,260929),('1','72','86612','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260930),('1','72','86783','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261442),('1','72','86783','226',225.00,225.00,390.00,0.00,0.00,0.00,0.00,261443),('1','72','86783','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261444),('1','72','86859','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261672),('1','72','86859','226',225.00,225.00,574.80,0.00,0.00,0.00,0.00,261673),('1','72','86859','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261674),('1','72','86964','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261988),('1','72','86964','226',225.00,225.00,1408.67,0.00,0.00,0.00,0.00,261989),('1','72','86964','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261990),('1','72','87608','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263925),('1','72','87608','226',225.00,225.00,53.21,0.00,0.00,0.00,0.00,263926),('1','72','87608','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263927),('1','72','87609','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263928),('1','72','87609','226',225.00,225.00,51.56,0.00,0.00,0.00,0.00,263929),('1','72','87609','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263930),('1','72','87610','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263931),('1','72','87610','226',225.00,225.00,410.90,0.00,0.00,0.00,0.00,263932),('1','72','87610','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263933),('1','72','87611','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263934),('1','72','87611','226',225.00,225.00,67.92,0.00,0.00,0.00,0.00,263935),('1','72','87611','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263936),('1','72','87613','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263940),('1','72','87613','226',225.00,225.00,50.67,0.00,0.00,0.00,0.00,263941),('1','72','87613','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263942),('1','72','87698','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,264195),('1','72','87698','226',225.00,225.00,476.23,0.00,0.00,0.00,0.00,264196),('1','72','87698','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,264197),('1','72','87879','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,264740),('1','72','87879','226',225.00,225.00,170.14,0.00,0.00,0.00,0.00,264741),('1','72','87879','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,264742),('1','72','88299','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266001),('1','72','88299','226',225.00,225.00,104.45,0.00,0.00,0.00,0.00,266002),('1','72','88299','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266003),('1','72','88301','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266007),('1','72','88301','226',225.00,225.00,303.11,0.00,0.00,0.00,0.00,266008),('1','72','88301','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266009),('1','72','88303','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266013),('1','72','88303','226',225.00,225.00,214.44,0.00,0.00,0.00,0.00,266014),('1','72','88303','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266015),('1','72','88305','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266019),('1','72','88305','226',225.00,225.00,145.82,0.00,0.00,0.00,0.00,266020),('1','72','88305','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266021),('1','72','88733','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267305),('1','72','88733','226',225.00,225.00,56.66,0.00,0.00,0.00,0.00,267306),('1','72','88733','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267307),('1','72','88738','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267320),('1','72','88738','226',225.00,225.00,790.27,0.00,0.00,0.00,0.00,267321),('1','72','88738','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267322),('1','72','88741','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267329),('1','72','88741','226',225.00,225.00,1102.08,0.00,0.00,0.00,0.00,267330),('1','72','88741','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267331),('1','72','89399','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269308),('1','72','89399','226',225.00,225.00,504.09,0.00,0.00,0.00,0.00,269309),('1','72','89399','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269310),('1','72','89401','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269314),('1','72','89401','226',225.00,225.00,105.32,0.00,0.00,0.00,0.00,269315),('1','72','89401','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269316),('1','72','89405','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269326),('1','72','89405','226',225.00,225.00,150.00,0.00,0.00,0.00,0.00,269327),('1','72','89405','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269328),('1','72','89406','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269329),('1','72','89406','226',225.00,225.00,122.22,0.00,0.00,0.00,0.00,269330),('1','72','89406','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269331),('1','72','89407','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269332),('1','72','89407','226',225.00,225.00,48.42,0.00,0.00,0.00,0.00,269333),('1','72','89407','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269334),('1','72','89471','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269525),('1','72','89471','226',225.00,225.00,34.66,0.00,0.00,0.00,0.00,269526),('1','72','89471','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269527),('1','72','90102','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271419),('1','72','90102','226',225.00,225.00,892.07,0.00,0.00,0.00,0.00,271420),('1','72','90102','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271421),('1','72','90104','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271425),('1','72','90104','226',225.00,225.00,148.73,0.00,0.00,0.00,0.00,271426),('1','72','90104','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271427),('1','72','90105','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271428),('1','72','90105','226',225.00,225.00,519.62,0.00,0.00,0.00,0.00,271429),('1','72','90105','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271430),('1','72','90108','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271437),('1','72','90108','226',225.00,225.00,100.00,0.00,0.00,0.00,0.00,271438),('1','72','90108','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271439),('1','72','90111','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271446),('1','72','90111','226',225.00,225.00,77.55,0.00,0.00,0.00,0.00,271447),('1','72','90111','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271448),('1','72','90307','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272038),('1','72','90307','226',225.00,225.00,97.59,0.00,0.00,0.00,0.00,272039),('1','72','90307','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272040),('1','72','90401','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272320),('1','72','90401','226',225.00,225.00,202.15,0.00,0.00,0.00,0.00,272321),('1','72','90401','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272322),('1','72','90554','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272781),('1','72','90554','226',225.00,225.00,431.11,0.00,0.00,0.00,0.00,272782),('1','72','90554','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272783),('1','72','90596','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272907),('1','72','90596','226',225.00,225.00,591.33,0.00,0.00,0.00,0.00,272908),('1','72','90596','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272909),('1','72','91136','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274531),('1','72','91136','226',225.00,225.00,510.74,0.00,0.00,0.00,0.00,274532),('1','72','91136','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274533),('1','72','91139','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274540),('1','72','91139','226',225.00,225.00,162.12,0.00,0.00,0.00,0.00,274541),('1','72','91139','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274542),('1','72','91140','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274543),('1','72','91140','226',225.00,225.00,91.13,0.00,0.00,0.00,0.00,274544),('1','72','91140','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274545),('1','72','91142','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274549),('1','72','91142','226',225.00,225.00,427.00,0.00,0.00,0.00,0.00,274550),('1','72','91142','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274551),('1','72','91295','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275009),('1','72','91295','226',225.00,225.00,757.60,0.00,0.00,0.00,0.00,275010),('1','72','91295','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275011),('1','72','91381','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275268),('1','72','91381','226',225.00,225.00,1592.23,0.00,0.00,0.00,0.00,275269),('1','72','91381','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275270),('1','72','91551','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275778),('1','72','91551','226',225.00,225.00,329.12,0.00,0.00,0.00,0.00,275779),('1','72','91551','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275780),('1','72','91979','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277066),('1','72','91979','226',225.00,225.00,607.53,0.00,0.00,0.00,0.00,277067),('1','72','91979','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277068),('1','72','91981','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277072),('1','72','91981','226',225.00,225.00,92.68,0.00,0.00,0.00,0.00,277073),('1','72','91981','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277074),('1','72','91985','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277084),('1','72','91985','226',225.00,225.00,989.59,0.00,0.00,0.00,0.00,277085),('1','72','91985','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277086),('1','72','91986','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277087),('1','72','91986','226',225.00,225.00,164.83,0.00,0.00,0.00,0.00,277088),('1','72','91986','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277089),('1','72','93440','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281457),('1','72','93440','226',225.00,225.00,45.80,0.00,0.00,0.00,0.00,281458),('1','72','93440','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281459),('1','72','93573','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281860),('1','72','93573','226',225.00,225.00,140.00,0.00,0.00,0.00,0.00,281861),('1','72','93573','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281862),('1','72','93574','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281863),('1','72','93574','226',225.00,225.00,50.67,0.00,0.00,0.00,0.00,281864),('1','72','93574','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281865),('1','72','93576','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281869),('1','72','93576','226',225.00,225.00,487.82,0.00,0.00,0.00,0.00,281870),('1','72','93576','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281871),('1','72','93621','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282004),('1','72','93621','226',225.00,225.00,148.55,0.00,0.00,0.00,0.00,282005),('1','72','93621','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282006),('1','72','93622','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282007),('1','72','93622','226',225.00,225.00,50.55,0.00,0.00,0.00,0.00,282008),('1','72','93622','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282009),('1','72','93623','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282010),('1','72','93623','226',225.00,225.00,0.00,0.00,0.00,0.00,0.00,282011),('1','72','93623','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282012),('1','72','93624','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282013),('1','72','93624','226',225.00,225.00,55.23,0.00,0.00,0.00,0.00,282014),('1','72','93624','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282015),('1','72','93626','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282019),('1','72','93626','226',225.00,225.00,46.22,0.00,0.00,0.00,0.00,282020),('1','72','93626','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282021),('1','72','93629','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282028),('1','72','93629','226',225.00,225.00,178.90,0.00,0.00,0.00,0.00,282029),('1','72','93629','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282030),('1','72','93631','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282034),('1','72','93631','226',225.00,225.00,83.42,0.00,0.00,0.00,0.00,282035),('1','72','93631','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282036),('1','72','93632','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282037),('1','72','93632','226',225.00,225.00,578.62,0.00,0.00,0.00,0.00,282038),('1','72','93632','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282039),('1','72','93634','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282043),('1','72','93634','226',225.00,225.00,574.45,0.00,0.00,0.00,0.00,282044),('1','72','93634','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282045),('1','72','93635','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282046),('1','72','93635','226',225.00,225.00,729.77,0.00,0.00,0.00,0.00,282047),('1','72','93635','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282048),('1','72','93836','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282649),('1','72','93836','226',225.00,225.00,799.96,0.00,0.00,0.00,0.00,282650),('1','72','93836','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282651),('1','72','93839','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282658),('1','72','93839','226',225.00,225.00,364.44,0.00,0.00,0.00,0.00,282659),('1','72','93839','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282660),('1','72','93984','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,283095),('1','72','93984','226',225.00,225.00,154.62,0.00,0.00,0.00,0.00,283096),('1','72','93984','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,283097),('1','72','94397','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284336),('1','72','94397','226',225.00,225.00,91.26,0.00,0.00,0.00,0.00,284337),('1','72','94397','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284338),('1','72','94399','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284342),('1','72','94399','226',225.00,225.00,44.45,0.00,0.00,0.00,0.00,284343),('1','72','94399','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284344),('1','72','94480','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284585),('1','72','94480','226',225.00,225.00,101.77,0.00,0.00,0.00,0.00,284586),('1','72','94480','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284587),('1','72','94484','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284597),('1','72','94484','226',225.00,225.00,51.04,0.00,0.00,0.00,0.00,284598),('1','72','94484','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284599),('1','72','94635','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,285050),('1','72','94635','226',225.00,225.00,83.11,0.00,0.00,0.00,0.00,285051),('1','72','94635','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,285052),('1','72','94795','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,285530),('1','72','94795','226',225.00,225.00,379.54,0.00,0.00,0.00,0.00,285531),('1','72','94795','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,285532),('1','72','95487','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287606),('1','72','95487','226',225.00,225.00,83.56,0.00,0.00,0.00,0.00,287607),('1','72','95487','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287608),('1','72','95488','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287609),('1','72','95488','226',225.00,225.00,74.23,0.00,0.00,0.00,0.00,287610),('1','72','95488','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287611),('1','72','95490','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287615),('1','72','95490','226',225.00,225.00,203.78,0.00,0.00,0.00,0.00,287616),('1','72','95490','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287617),('1','72','95491','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287618),('1','72','95491','226',225.00,225.00,165.89,0.00,0.00,0.00,0.00,287619),('1','72','95491','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287620),('1','72','95598','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287939),('1','72','95598','226',225.00,225.00,302.22,0.00,0.00,0.00,0.00,287940),('1','72','95598','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287941),('1','72','95601','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287948),('1','72','95601','226',225.00,225.00,560.44,0.00,0.00,0.00,0.00,287949),('1','72','95601','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287950),('1','72','95602','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287951),('1','72','95602','226',225.00,225.00,122.10,0.00,0.00,0.00,0.00,287952),('1','72','95602','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287953),('1','72','95764','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288437),('1','72','95764','226',225.00,225.00,184.28,0.00,0.00,0.00,0.00,288438),('1','72','95764','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288439),('1','72','95766','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288443),('1','72','95766','226',225.00,225.00,1112.88,0.00,0.00,0.00,0.00,288444),('1','72','95766','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288445),('1','72','95855','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288710),('1','72','95855','226',225.00,225.00,85.55,0.00,0.00,0.00,0.00,288711),('1','72','95855','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288712),('1','72','95935','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288950),('1','72','95935','226',225.00,225.00,371.10,0.00,0.00,0.00,0.00,288951),('1','72','95935','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288952),('1','72','96271','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289958),('1','72','96271','226',225.00,225.00,53.34,0.00,0.00,0.00,0.00,289959),('1','72','96271','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289960),('1','72','96272','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289961),('1','72','96272','226',225.00,225.00,242.92,0.00,0.00,0.00,0.00,289962),('1','72','96272','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289963),('1','72','96274','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289967),('1','72','96274','226',225.00,225.00,271.27,0.00,0.00,0.00,0.00,289968),('1','72','96274','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289969),('1','72','96399','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,290342),('1','72','96399','226',225.00,225.00,936.24,0.00,0.00,0.00,0.00,290343),('1','72','96399','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,290344),('1','72','96793','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291524),('1','72','96793','226',225.00,225.00,915.21,0.00,0.00,0.00,0.00,291525),('1','72','96793','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291526),('1','72','96795','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291530),('1','72','96795','226',225.00,225.00,132.23,0.00,0.00,0.00,0.00,291531),('1','72','96795','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291532),('1','72','96798','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291539),('1','72','96798','226',225.00,225.00,558.11,0.00,0.00,0.00,0.00,291540),('1','72','96798','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291541),('1','72','96800','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291545),('1','72','96800','226',225.00,225.00,780.78,0.00,0.00,0.00,0.00,291546),('1','72','96800','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291547),('1','72','96960','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,292025),('1','72','96960','226',225.00,225.00,876.45,0.00,0.00,0.00,0.00,292026),('1','72','96960','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,292027),('1','72','97388','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,293309),('1','72','97388','226',225.00,225.00,31.11,0.00,0.00,0.00,0.00,293310),('1','72','97388','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,293311),('1','72','97788','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,294509),('1','72','97788','226',225.00,220.00,38.64,0.00,0.00,0.00,0.00,294510),('1','72','97788','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,294511),('1','72','97790','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,294515),('1','72','97790','226',225.00,220.00,125.00,0.00,0.00,0.00,0.00,294516),('1','72','97790','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,294517),('1','72','97792','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,294521),('1','72','97792','226',225.00,220.00,41.82,0.00,0.00,0.00,0.00,294522),('1','72','97792','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,294523),('1','72','97873','225',0.00,0.00,0.00,0.00,0.00,0.00,0.00,294764),('1','72','97873','226',225.00,220.00,952.52,0.00,0.00,0.00,0.00,294765),('1','72','97873','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,294766),('1','72','99192','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,298721),('1','72','99192','226',225.00,220.00,541.36,0.00,0.00,0.00,0.00,298722),('1','72','99192','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,298723),('1','72','99196','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,298733),('1','72','99196','226',225.00,220.00,357.86,0.00,0.00,0.00,0.00,298734),('1','72','99196','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,298735),('1','72','99199','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,298742),('1','72','99199','226',225.00,220.00,47.66,0.00,0.00,0.00,0.00,298743),('1','72','99199','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,298744),('1','72','99201','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,298748),('1','72','99201','226',225.00,220.00,569.37,0.00,0.00,0.00,0.00,298749),('1','72','99201','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,298750),('1','72','99203','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,298754),('1','72','99203','226',225.00,220.00,766.46,0.00,0.00,0.00,0.00,298755),('1','72','99203','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,298756),('1','72','99517','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,299696),('1','72','99517','226',220.00,220.00,74.17,0.00,0.00,0.00,0.00,299697),('1','72','99517','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,299698),('1','72','99518','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,299699),('1','72','99518','226',220.00,220.00,1129.41,0.00,0.00,0.00,0.00,299700),('1','72','99518','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,299701),('1','72','99616','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,299993),('1','72','99616','226',220.00,220.00,521.81,0.00,0.00,0.00,0.00,299994),('1','72','99616','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,299995),('1','72','100048','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,301289),('1','72','100048','226',220.00,220.00,614.92,0.00,0.00,0.00,0.00,301290),('1','72','100048','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,301291),('1','72','100049','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,301292),('1','72','100049','226',220.00,220.00,763.78,0.00,0.00,0.00,0.00,301293),('1','72','100049','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,301294),('1','72','100052','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,301301),('1','72','100052','226',220.00,220.00,585.97,0.00,0.00,0.00,0.00,301302),('1','72','100052','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,301303),('1','72','100053','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,301304),('1','72','100053','226',220.00,220.00,1328.11,0.00,0.00,0.00,0.00,301305),('1','72','100053','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,301306),('1','72','100302','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,302051),('1','72','100302','226',220.00,220.00,1456.93,0.00,0.00,0.00,0.00,302052),('1','72','100302','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,302053),('1','72','100303','225',140.00,140.00,0.00,0.00,0.00,0.00,0.00,302054),('1','72','100303','226',220.00,220.00,592.62,0.00,0.00,0.00,0.00,302055),('1','72','100303','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,302056),('1','72','100439','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,302462),('1','72','100439','226',220.00,220.00,329.81,0.00,0.00,0.00,0.00,302463),('1','72','100439','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,302464),('1','72','100441','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,302468),('1','72','100441','226',220.00,220.00,1636.94,0.00,0.00,0.00,0.00,302469),('1','72','100441','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,302470),('1','72','100767','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,303446),('1','72','100767','226',220.00,220.00,1073.75,0.00,0.00,0.00,0.00,303447),('1','72','100767','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,303448),('1','72','100768','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,303449),('1','72','100768','226',220.00,220.00,534.13,0.00,0.00,0.00,0.00,303450),('1','72','100768','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,303451),('1','72','100980','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,304085),('1','72','100980','226',220.00,220.00,706.09,0.00,0.00,0.00,0.00,304086),('1','72','100980','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,304087),('1','72','100981','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,304088),('1','72','100981','226',220.00,220.00,258.65,0.00,0.00,0.00,0.00,304089),('1','72','100981','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,304090),('1','72','101149','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,304592),('1','72','101149','226',220.00,220.00,631.63,0.00,0.00,0.00,0.00,304593),('1','72','101149','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,304594),('1','72','101249','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,304892),('1','72','101249','226',220.00,220.00,90.46,0.00,0.00,0.00,0.00,304893),('1','72','101249','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,304894),('1','72','101809','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,306572),('1','72','101809','226',220.00,220.00,241.08,0.00,0.00,0.00,0.00,306573),('1','72','101809','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,306574),('1','72','101811','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,306578),('1','72','101811','226',220.00,225.00,39.04,0.00,0.00,0.00,0.00,306579),('1','72','101811','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,306580),('1','72','101814','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,306587),('1','72','101814','226',220.00,220.00,25.00,0.00,0.00,0.00,0.00,306588),('1','72','101814','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,306589),('1','72','101815','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,306590),('1','72','101815','226',220.00,220.00,26.82,0.00,0.00,0.00,0.00,306591),('1','72','101815','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,306592),('1','72','101817','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,306596),('1','72','101817','226',220.00,220.00,1127.28,0.00,0.00,0.00,0.00,306597),('1','72','101817','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,306598),('1','72','102244','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,307877),('1','72','102244','226',220.00,220.00,1206.74,0.00,0.00,0.00,0.00,307878),('1','72','102244','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,307879),('1','72','102355','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,308210),('1','72','102355','226',220.00,220.00,509.78,0.00,0.00,0.00,0.00,308211),('1','72','102355','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,308212),('1','72','102357','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,308216),('1','72','102357','226',220.00,220.00,422.75,0.00,0.00,0.00,0.00,308217),('1','72','102357','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,308218),('1','72','102604','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,308957),('1','72','102604','226',220.00,220.00,1038.31,0.00,0.00,0.00,0.00,308958),('1','72','102604','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,308959),('1','72','102606','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,308963),('1','72','102606','226',220.00,220.00,51.59,0.00,0.00,0.00,0.00,308964),('1','72','102606','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,308965),('1','72','102780','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,309485),('1','72','102780','226',220.00,220.00,1429.27,0.00,0.00,0.00,0.00,309486),('1','72','102780','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,309487),('1','72','102781','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,309488),('1','72','102781','226',220.00,215.00,1203.65,0.00,0.00,0.00,0.00,309489),('1','72','102781','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,309490),('1','72','103406','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,311363),('1','72','103406','226',220.00,215.00,213.51,0.00,0.00,0.00,0.00,311364),('1','72','103406','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311365),('1','72','103407','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,311366),('1','72','103407','226',220.00,215.00,131.56,0.00,0.00,0.00,0.00,311367),('1','72','103407','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311368),('1','72','103408','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,311369),('1','72','103408','226',220.00,215.00,542.59,0.00,0.00,0.00,0.00,311370),('1','72','103408','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311371),('1','72','103409','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,311372),('1','72','103409','226',220.00,215.00,704.21,0.00,0.00,0.00,0.00,311373),('1','72','103409','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311374),('1','72','103410','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,311375),('1','72','103410','226',220.00,215.00,80.22,0.00,0.00,0.00,0.00,311376),('1','72','103410','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311377),('1','72','103546','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,311783),('1','72','103546','226',220.00,215.00,2353.18,0.00,0.00,0.00,0.00,311784),('1','72','103546','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311785),('1','72','103637','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,312056),('1','72','103637','226',220.00,215.00,129.24,0.00,0.00,0.00,0.00,312057),('1','72','103637','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,312058),('1','72','103939','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,312962),('1','72','103939','226',220.00,215.00,249.01,0.00,0.00,0.00,0.00,312963),('1','72','103939','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,312964),('1','72','103941','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,312968),('1','72','103941','226',220.00,215.00,530.20,0.00,0.00,0.00,0.00,312969),('1','72','103941','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,312970),('1','72','104452','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,314501),('1','72','104452','226',220.00,215.00,1581.81,0.00,0.00,0.00,0.00,314502),('1','72','104452','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,314503),('1','72','104453','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,314504),('1','72','104453','226',220.00,215.00,1354.20,0.00,0.00,0.00,0.00,314505),('1','72','104453','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,314506),('1','72','104454','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,314507),('1','72','104454','226',220.00,215.00,2617.43,0.00,0.00,0.00,0.00,314508),('1','72','104454','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,314509),('1','72','105304','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317057),('1','72','105304','226',215.00,215.00,684.25,0.00,0.00,0.00,0.00,317058),('1','72','105304','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317059),('1','72','105307','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317066),('1','72','105307','226',215.00,215.00,1267.16,0.00,0.00,0.00,0.00,317067),('1','72','105307','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317068),('1','72','105309','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317072),('1','72','105309','226',215.00,215.00,757.58,0.00,0.00,0.00,0.00,317073),('1','72','105309','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317074),('1','72','105311','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317078),('1','72','105311','226',215.00,215.00,1561.07,0.00,0.00,0.00,0.00,317079),('1','72','105311','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317080),('1','72','105313','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317084),('1','72','105313','226',215.00,215.00,101.40,0.00,0.00,0.00,0.00,317085),('1','72','105313','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317086),('1','72','105316','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317093),('1','72','105316','226',215.00,215.00,809.45,0.00,0.00,0.00,0.00,317094),('1','72','105316','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317095),('1','72','105317','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317096),('1','72','105317','226',215.00,215.00,118.49,0.00,0.00,0.00,0.00,317097),('1','72','105317','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317098),('1','72','105319','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317102),('1','72','105319','226',215.00,215.00,1481.86,0.00,0.00,0.00,0.00,317103),('1','72','105319','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317104),('1','72','105441','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,317468),('1','72','105441','226',215.00,215.00,1293.09,0.00,0.00,0.00,0.00,317469),('1','72','105441','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317470),('1','72','105704','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,318257),('1','72','105704','226',215.00,215.00,3120.65,0.00,0.00,0.00,0.00,318258),('1','72','105704','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,318259),('1','72','105707','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,318266),('1','72','105707','226',215.00,215.00,1038.88,0.00,0.00,0.00,0.00,318267),('1','72','105707','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,318268),('1','72','106101','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,319448),('1','72','106101','226',215.00,215.00,871.21,0.00,0.00,0.00,0.00,319449),('1','72','106101','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,319450),('1','72','106407','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,320366),('1','72','106407','226',215.00,215.00,841.90,0.00,0.00,0.00,0.00,320367),('1','72','106407','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,320368),('1','72','106408','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,320369),('1','72','106408','226',215.00,215.00,159.31,0.00,0.00,0.00,0.00,320370),('1','72','106408','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,320371),('1','72','106616','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,320993),('1','72','106616','226',215.00,215.00,1106.88,0.00,0.00,0.00,0.00,320994),('1','72','106616','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,320995),('1','72','107245','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,322894),('1','72','107245','226',215.00,215.00,666.07,0.00,0.00,0.00,0.00,322895),('1','72','107245','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,322896),('1','72','107246','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,322897),('1','72','107246','226',215.00,215.00,1366.29,0.00,0.00,0.00,0.00,322898),('1','72','107246','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,322899),('1','72','107247','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,322900),('1','72','107247','226',215.00,215.00,1369.99,0.00,0.00,0.00,0.00,322901),('1','72','107247','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,322902),('1','72','108010','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,325203),('1','72','108010','226',215.00,215.00,1009.82,0.00,0.00,0.00,0.00,325204),('1','72','108010','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,325205),('1','72','108013','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,325212),('1','72','108013','226',215.00,215.00,789.19,0.00,0.00,0.00,0.00,325213),('1','72','108013','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,325214),('1','72','108016','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,325221),('1','72','108016','226',215.00,215.00,1228.83,0.00,0.00,0.00,0.00,325222),('1','72','108016','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,325223),('1','72','108017','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,325224),('1','72','108017','226',215.00,215.00,62.13,0.00,0.00,0.00,0.00,325225),('1','72','108017','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,325226),('1','72','108316','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,326127),('1','72','108316','226',215.00,215.00,1192.69,0.00,0.00,0.00,0.00,326128),('1','72','108316','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,326129),('1','72','108317','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,326130),('1','72','108317','226',215.00,215.00,585.52,0.00,0.00,0.00,0.00,326131),('1','72','108317','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,326132),('1','72','108435','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,326486),('1','72','108435','226',215.00,215.00,200.69,0.00,0.00,0.00,0.00,326487),('1','72','108435','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,326488),('1','72','109098','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,328486),('1','72','109098','226',215.00,215.00,109.79,0.00,0.00,0.00,0.00,328487),('1','72','109098','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,328488),('1','72','109099','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,328489),('1','72','109099','226',215.00,215.00,587.29,0.00,0.00,0.00,0.00,328490),('1','72','109099','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,328491),('1','72','109100','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,328492),('1','72','109100','226',215.00,215.00,916.17,0.00,0.00,0.00,0.00,328493),('1','72','109100','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,328494),('1','72','109101','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,328495),('1','72','109101','226',215.00,215.00,72.09,0.00,0.00,0.00,0.00,328496),('1','72','109101','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,328497),('1','72','109102','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,328498),('1','72','109102','226',215.00,215.00,663.13,0.00,0.00,0.00,0.00,328499),('1','72','109102','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,328500),('1','72','109255','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,328958),('1','72','109255','226',215.00,215.00,828.25,0.00,0.00,0.00,0.00,328959),('1','72','109255','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,328960),('1','72','109723','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,330372),('1','72','109723','226',215.00,215.00,65.29,0.00,0.00,0.00,0.00,330373),('1','72','109723','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,330374),('1','72','109724','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,330375),('1','72','109724','226',215.00,215.00,194.97,0.00,0.00,0.00,0.00,330376),('1','72','109724','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,330377),('1','72','109725','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,330378),('1','72','109725','226',215.00,215.00,209.23,0.00,0.00,0.00,0.00,330379),('1','72','109725','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,330380),('1','72','109726','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,330381),('1','72','109726','226',215.00,215.00,1140.30,0.00,0.00,0.00,0.00,330382),('1','72','109726','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,330383),('1','72','109875','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,330830),('1','72','109875','226',215.00,215.00,862.06,0.00,0.00,0.00,0.00,330831),('1','72','109875','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,330832),('1','72','110101','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,331512),('1','72','110101','226',215.00,215.00,958.19,0.00,0.00,0.00,0.00,331513),('1','72','110101','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,331514),('1','72','110102','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,331515),('1','72','110102','226',215.00,215.00,78.17,0.00,0.00,0.00,0.00,331516),('1','72','110102','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,331517),('1','72','110351','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,332264),('1','72','110351','226',215.00,215.00,1049.53,0.00,0.00,0.00,0.00,332265),('1','72','110351','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,332266),('1','72','110352','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,332267),('1','72','110352','226',215.00,215.00,336.75,0.00,0.00,0.00,0.00,332268),('1','72','110352','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,332269),('1','72','110778','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,333509),('1','72','110778','226',215.00,215.00,567.64,0.00,0.00,0.00,0.00,333510),('1','72','110778','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,333511),('1','72','110779','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,333512),('1','72','110779','226',215.00,215.00,1283.47,0.00,0.00,0.00,0.00,333513),('1','72','110779','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,333514),('1','72','111011','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,334211),('1','72','111011','226',215.00,215.00,748.39,0.00,0.00,0.00,0.00,334212),('1','72','111011','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,334213),('1','72','111013','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,334217),('1','72','111013','226',215.00,215.00,908.79,0.00,0.00,0.00,0.00,334218),('1','72','111013','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,334219),('1','72','111014','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,334220),('1','72','111014','226',215.00,215.00,751.87,0.00,0.00,0.00,0.00,334221),('1','72','111014','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,334222),('1','72','111745','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,336412),('1','72','111745','226',215.00,215.00,1153.09,0.00,0.00,0.00,0.00,336413),('1','72','111745','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,336414),('1','72','111746','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,336415),('1','72','111746','226',215.00,215.00,308.12,0.00,0.00,0.00,0.00,336416),('1','72','111746','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,336417),('1','72','111747','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,336418),('1','72','111747','226',215.00,215.00,173.04,0.00,0.00,0.00,0.00,336419),('1','72','111747','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,336420),('1','72','111748','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,336421),('1','72','111748','226',215.00,215.00,125.58,0.00,0.00,0.00,0.00,336422),('1','72','111748','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,336423),('1','72','111750','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,336427),('1','72','111750','226',215.00,215.00,321.56,0.00,0.00,0.00,0.00,336428),('1','72','111750','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,336429),('1','72','111751','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,336430),('1','72','111751','226',215.00,215.00,156.34,0.00,0.00,0.00,0.00,336431),('1','72','111751','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,336432),('1','72','113467','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,341578),('1','72','113467','226',220.00,220.00,794.63,0.00,0.00,0.00,0.00,341579),('1','72','113467','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,341580),('1','72','113640','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,342101),('1','72','113640','226',220.00,220.00,766.37,0.00,0.00,0.00,0.00,342102),('1','72','113640','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,342103),('1','72','113770','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,342492),('1','72','113770','226',220.00,220.00,513.54,0.00,0.00,0.00,0.00,342493),('1','72','113770','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,342494),('1','72','114027','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,343263),('1','72','114027','226',220.00,220.00,636.62,0.00,0.00,0.00,0.00,343264),('1','72','114027','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,343265),('1','72','114029','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,343269),('1','72','114029','226',220.00,220.00,1571.94,0.00,0.00,0.00,0.00,343270),('1','72','114029','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,343271),('1','72','114032','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,343278),('1','72','114032','226',220.00,220.00,610.32,0.00,0.00,0.00,0.00,343279),('1','72','114032','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,343280),('1','72','114379','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,344326),('1','72','114379','226',220.00,220.00,521.61,0.00,0.00,0.00,0.00,344327),('1','72','114379','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,344328),('1','72','114380','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,344329),('1','72','114380','226',220.00,220.00,327.64,0.00,0.00,0.00,0.00,344330),('1','72','114380','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,344331),('1','72','114381','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,344332),('1','72','114381','226',220.00,220.00,1141.11,0.00,0.00,0.00,0.00,344333),('1','72','114381','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,344334),('1','72','114505','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,344694),('1','72','114505','226',220.00,220.00,654.10,0.00,0.00,0.00,0.00,344695),('1','72','114505','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,344696),('1','72','115235','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,346880),('1','72','115235','226',220.00,220.00,746.97,0.00,0.00,0.00,0.00,346881),('1','72','115235','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,346882),('1','72','115236','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,346883),('1','72','115236','226',220.00,220.00,2147.76,0.00,0.00,0.00,0.00,346884),('1','72','115236','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,346885),('1','72','115237','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,346886),('1','72','115237','226',220.00,220.00,2646.74,0.00,0.00,0.00,0.00,346887),('1','72','115237','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,346888),('1','72','115238','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,346889),('1','72','115238','226',220.00,220.00,160.48,0.00,0.00,0.00,0.00,346890),('1','72','115238','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,346891),('1','72','115239','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,346892),('1','72','115239','226',220.00,220.00,785.98,0.00,0.00,0.00,0.00,346893),('1','72','115239','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,346894),('1','72','115390','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,347345),('1','72','115390','226',220.00,220.00,203.45,0.00,0.00,0.00,0.00,347346),('1','72','115390','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,347347),('1','72','115783','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,348525),('1','72','115783','226',220.00,220.00,216.39,0.00,0.00,0.00,0.00,348526),('1','72','115783','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,348527),('1','72','115784','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,348528),('1','72','115784','226',220.00,220.00,251.14,0.00,0.00,0.00,0.00,348529),('1','72','115784','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,348530),('1','72','116802','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,351580),('1','72','116802','226',220.00,220.00,131.14,0.00,0.00,0.00,0.00,351581),('1','72','116802','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,351582),('1','72','116822','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,351640),('1','72','116822','226',220.00,220.00,137.62,0.00,0.00,0.00,0.00,351641),('1','72','116822','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,351642),('1','72','116869','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,351781),('1','72','116869','226',220.00,220.00,1375.91,0.00,0.00,0.00,0.00,351782),('1','72','116869','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,351783),('1','72','116870','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,351784),('1','72','116870','226',220.00,220.00,594.57,0.00,0.00,0.00,0.00,351785),('1','72','116870','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,351786),('1','72','116953','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,352032),('1','72','116953','226',220.00,215.00,215.45,0.00,0.00,0.00,0.00,352033),('1','72','116953','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,352034),('1','72','116961','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,352056),('1','72','116961','226',220.00,215.00,345.01,0.00,0.00,0.00,0.00,352057),('1','72','116961','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,352058),('1','72','117099','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,352472),('1','72','117099','226',220.00,215.00,486.35,0.00,0.00,0.00,0.00,352473),('1','72','117099','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,352474),('1','72','117231','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,352868),('1','72','117231','226',220.00,215.00,629.39,0.00,0.00,0.00,0.00,352869),('1','72','117231','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,352870),('1','72','117392','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,353350),('1','72','117392','226',220.00,215.00,2294.71,0.00,0.00,0.00,0.00,353351),('1','72','117392','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,353352),('1','72','117510','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,353703),('1','72','117510','226',220.00,215.00,783.95,0.00,0.00,0.00,0.00,353704),('1','72','117510','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,353705),('1','72','117613','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,354011),('1','72','117613','226',220.00,215.00,2010.60,0.00,0.00,0.00,0.00,354012),('1','72','117613','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,354013),('1','72','117747','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,354412),('1','72','117747','226',220.00,215.00,667.25,0.00,0.00,0.00,0.00,354413),('1','72','117747','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,354414),('1','72','117908','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,354895),('1','72','117908','226',220.00,215.00,628.25,0.00,0.00,0.00,0.00,354896),('1','72','117908','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,354897),('1','72','118167','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,355672),('1','72','118167','226',220.00,215.00,275.34,0.00,0.00,0.00,0.00,355673),('1','72','118167','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,355674),('1','72','118311','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,356104),('1','72','118311','226',220.00,215.00,73.95,0.00,0.00,0.00,0.00,356105),('1','72','118311','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,356106),('1','72','126893','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381830),('1','72','126893','226',220.00,215.00,394.63,0.00,0.00,0.00,0.00,381831),('1','72','126893','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381832),('1','72','126896','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381839),('1','72','126896','226',220.00,215.00,1564.41,0.00,0.00,0.00,0.00,381840),('1','72','126896','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381841),('1','72','126905','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381866),('1','72','126905','226',220.00,215.00,1573.53,0.00,0.00,0.00,0.00,381867),('1','72','126905','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381868),('1','72','126908','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381875),('1','72','126908','226',220.00,215.00,402.90,0.00,0.00,0.00,0.00,381876),('1','72','126908','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381877),('1','72','126911','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381884),('1','72','126911','226',220.00,215.00,139.87,0.00,0.00,0.00,0.00,381885),('1','72','126911','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381886),('1','72','126912','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381887),('1','72','126912','226',220.00,215.00,717.30,0.00,0.00,0.00,0.00,381888),('1','72','126912','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381889),('1','72','126914','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381893),('1','72','126914','226',220.00,215.00,359.91,0.00,0.00,0.00,0.00,381894),('1','72','126914','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381895),('1','72','126916','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381899),('1','72','126916','226',220.00,215.00,159.22,0.00,0.00,0.00,0.00,381900),('1','72','126916','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381901),('1','72','126924','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,381924),('1','72','126924','226',220.00,215.00,148.84,0.00,0.00,0.00,0.00,381925),('1','72','126924','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,381926),('1','72','127015','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382195),('1','72','127015','226',220.00,215.00,180.70,0.00,0.00,0.00,0.00,382196),('1','72','127015','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382197),('1','72','127017','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382201),('1','72','127017','226',220.00,215.00,157.02,0.00,0.00,0.00,0.00,382202),('1','72','127017','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382203),('1','72','127018','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382204),('1','72','127018','226',220.00,215.00,60.47,0.00,0.00,0.00,0.00,382205),('1','72','127018','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382206),('1','72','127019','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382207),('1','72','127019','226',220.00,215.00,63.73,0.00,0.00,0.00,0.00,382208),('1','72','127019','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382209),('1','72','127021','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382213),('1','72','127021','226',220.00,215.00,344.29,0.00,0.00,0.00,0.00,382214),('1','72','127021','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382215),('1','72','127024','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382222),('1','72','127024','226',220.00,225.00,300.35,0.00,0.00,0.00,0.00,382223),('1','72','127024','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382224),('1','72','127026','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382228),('1','72','127026','226',220.00,225.00,712.27,0.00,0.00,0.00,0.00,382229),('1','72','127026','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382230),('1','72','127027','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382231),('1','72','127027','226',220.00,225.00,912.77,0.00,0.00,0.00,0.00,382232),('1','72','127027','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382233),('1','72','127029','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382237),('1','72','127029','226',220.00,225.00,459.44,0.00,0.00,0.00,0.00,382238),('1','72','127029','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382239),('1','72','127030','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382240),('1','72','127030','226',220.00,225.00,138.35,0.00,0.00,0.00,0.00,382241),('1','72','127030','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382242),('1','72','127032','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382246),('1','72','127032','226',220.00,225.00,407.39,0.00,0.00,0.00,0.00,382247),('1','72','127032','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382248),('1','72','127035','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382255),('1','72','127035','226',220.00,225.00,257.04,0.00,0.00,0.00,0.00,382256),('1','72','127035','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382257),('1','72','127036','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382258),('1','72','127036','226',220.00,225.00,956.36,0.00,0.00,0.00,0.00,382259),('1','72','127036','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382260),('1','72','127039','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382267),('1','72','127039','226',220.00,225.00,1041.97,0.00,0.00,0.00,0.00,382268),('1','72','127039','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382269),('1','72','127041','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382273),('1','72','127041','226',220.00,225.00,323.33,0.00,0.00,0.00,0.00,382274),('1','72','127041','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382275),('1','72','127042','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382276),('1','72','127042','226',220.00,225.00,199.12,0.00,0.00,0.00,0.00,382277),('1','72','127042','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382278),('1','72','127044','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382282),('1','72','127044','226',220.00,225.00,266.67,0.00,0.00,0.00,0.00,382283),('1','72','127044','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382284),('1','72','127048','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382294),('1','72','127048','226',220.00,225.00,279.84,0.00,0.00,0.00,0.00,382295),('1','72','127048','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382296),('1','72','127051','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382303),('1','72','127051','226',220.00,225.00,636.21,0.00,0.00,0.00,0.00,382304),('1','72','127051','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382305),('1','72','127052','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382306),('1','72','127052','226',220.00,225.00,786.44,0.00,0.00,0.00,0.00,382307),('1','72','127052','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382308),('1','72','127054','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382312),('1','72','127054','226',220.00,225.00,876.27,0.00,0.00,0.00,0.00,382313),('1','72','127054','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382314),('1','72','127055','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382315),('1','72','127055','226',220.00,225.00,712.44,0.00,0.00,0.00,0.00,382316),('1','72','127055','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382317),('1','72','127056','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382318),('1','72','127056','226',220.00,225.00,255.53,0.00,0.00,0.00,0.00,382319),('1','72','127056','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382320),('1','72','127057','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382321),('1','72','127057','226',220.00,225.00,228.44,0.00,0.00,0.00,0.00,382322),('1','72','127057','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382323),('1','72','127060','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382330),('1','72','127060','226',220.00,225.00,606.07,0.00,0.00,0.00,0.00,382331),('1','72','127060','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382332),('1','72','127061','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382333),('1','72','127061','226',220.00,225.00,210.39,0.00,0.00,0.00,0.00,382334),('1','72','127061','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382335),('1','72','127062','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382336),('1','72','127062','226',220.00,220.00,753.00,0.00,0.00,0.00,0.00,382337),('1','72','127062','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382338),('1','72','127064','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382342),('1','72','127064','226',220.00,220.00,698.23,0.00,0.00,0.00,0.00,382343),('1','72','127064','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382344),('1','72','127122','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382515),('1','72','127122','226',220.00,220.00,248.56,0.00,0.00,0.00,0.00,382516),('1','72','127122','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382517),('1','72','127123','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382518),('1','72','127123','226',220.00,220.00,726.77,0.00,0.00,0.00,0.00,382519),('1','72','127123','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382520),('1','72','127124','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382521),('1','72','127124','226',220.00,220.00,1090.71,0.00,0.00,0.00,0.00,382522),('1','72','127124','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382523),('1','72','127125','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382524),('1','72','127125','226',220.00,220.00,95.44,0.00,0.00,0.00,0.00,382525),('1','72','127125','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382526),('1','72','127126','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382527),('1','72','127126','226',220.00,220.00,94.20,0.00,0.00,0.00,0.00,382528),('1','72','127126','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382529),('1','72','127127','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382530),('1','72','127127','226',220.00,220.00,366.33,0.00,0.00,0.00,0.00,382531),('1','72','127127','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382532),('1','72','127128','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382533),('1','72','127128','226',220.00,220.00,408.69,0.00,0.00,0.00,0.00,382534),('1','72','127128','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382535),('1','72','127130','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382539),('1','72','127130','226',220.00,220.00,1599.21,0.00,0.00,0.00,0.00,382540),('1','72','127130','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382541),('1','72','127131','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382542),('1','72','127131','226',220.00,215.00,270.93,0.00,0.00,0.00,0.00,382543),('1','72','127131','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382544),('1','72','127132','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382545),('1','72','127132','226',220.00,215.00,566.60,0.00,0.00,0.00,0.00,382546),('1','72','127132','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382547),('1','72','127133','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382548),('1','72','127133','226',220.00,215.00,265.48,0.00,0.00,0.00,0.00,382549),('1','72','127133','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382550),('1','72','127134','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382551),('1','72','127134','226',220.00,215.00,1793.63,0.00,0.00,0.00,0.00,382552),('1','72','127134','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382553),('1','72','127135','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382554),('1','72','127135','226',220.00,215.00,67.89,0.00,0.00,0.00,0.00,382555),('1','72','127135','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382556),('1','72','127137','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382560),('1','72','127137','226',220.00,215.00,723.93,0.00,0.00,0.00,0.00,382561),('1','72','127137','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382562),('1','72','127138','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382563),('1','72','127138','226',220.00,215.00,509.31,0.00,0.00,0.00,0.00,382564),('1','72','127138','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382565),('1','72','127139','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382566),('1','72','127139','226',220.00,215.00,283.87,0.00,0.00,0.00,0.00,382567),('1','72','127139','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382568),('1','72','127140','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382569),('1','72','127140','226',220.00,215.00,698.42,0.00,0.00,0.00,0.00,382570),('1','72','127140','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382571),('1','72','127160','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,382629),('1','72','127160','226',220.00,215.00,233.09,0.00,0.00,0.00,0.00,382630),('1','72','127160','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,382631),('1','72','127345','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,383180),('1','72','127345','226',220.00,215.00,501.54,0.00,0.00,0.00,0.00,383181),('1','72','127345','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,383182),('1','72','127348','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,383189),('1','72','127348','226',220.00,215.00,820.18,0.00,0.00,0.00,0.00,383190),('1','72','127348','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,383191),('1','72','127398','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,383339),('1','72','127398','226',220.00,215.00,595.34,0.00,0.00,0.00,0.00,383340),('1','72','127398','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,383341),('1','72','127865','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,384735),('1','72','127865','226',220.00,215.00,65.12,0.00,0.00,0.00,0.00,384736),('1','72','127865','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,384737),('1','72','127867','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,384741),('1','72','127867','226',220.00,215.00,569.30,0.00,0.00,0.00,0.00,384742),('1','72','127867','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,384743),('1','72','127868','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,384744),('1','72','127868','226',220.00,215.00,418.12,0.00,0.00,0.00,0.00,384745),('1','72','127868','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,384746),('1','72','127869','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,384747),('1','72','127869','226',220.00,215.00,470.36,0.00,0.00,0.00,0.00,384748),('1','72','127869','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,384749),('1','72','127976','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,385062),('1','72','127976','226',220.00,215.00,307.28,0.00,0.00,0.00,0.00,385063),('1','72','127976','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,385064),('1','72','128233','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,385829),('1','72','128233','226',220.00,215.00,192.41,0.00,0.00,0.00,0.00,385830),('1','72','128233','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,385831),('1','72','128256','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,385898),('1','72','128256','226',220.00,215.00,1302.20,0.00,0.00,0.00,0.00,385899),('1','72','128256','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,385900),('1','72','128384','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,386278),('1','72','128384','226',220.00,210.00,994.60,0.00,0.00,0.00,0.00,386279),('1','72','128384','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,386280),('1','72','128488','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,386590),('1','72','128488','226',220.00,210.00,120.83,0.00,0.00,0.00,0.00,386591),('1','72','128488','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,386592),('1','72','129160','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,388642),('1','72','129160','226',220.00,210.00,1029.63,0.00,0.00,0.00,0.00,388643),('1','72','129160','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,388644),('1','72','129161','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,388645),('1','72','129161','226',220.00,210.00,114.06,0.00,0.00,0.00,0.00,388646),('1','72','129161','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,388647),('1','72','129163','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,388651),('1','72','129163','226',220.00,210.00,52.18,0.00,0.00,0.00,0.00,388652),('1','72','129163','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,388653),('1','72','129167','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,388663),('1','72','129167','226',220.00,210.00,75.43,0.00,0.00,0.00,0.00,388664),('1','72','129167','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,388665),('1','72','129169','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,388669),('1','72','129169','226',220.00,210.00,244.29,0.00,0.00,0.00,0.00,388670),('1','72','129169','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,388671),('1','72','129280','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,389003),('1','72','129280','226',220.00,210.00,72.85,0.00,0.00,0.00,0.00,389004),('1','72','129280','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,389005),('1','72','129442','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,389479),('1','72','129442','226',220.00,210.00,289.05,0.00,0.00,0.00,0.00,389480),('1','72','129442','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,389481),('1','72','130093','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,391431),('1','72','130093','226',220.00,210.00,1507.46,0.00,0.00,0.00,0.00,391432),('1','72','130093','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,391433),('1','72','130096','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,391440),('1','72','130096','226',220.00,210.00,41.42,0.00,0.00,0.00,0.00,391441),('1','72','130096','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,391442),('1','72','130097','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,391443),('1','72','130097','226',220.00,210.00,137.84,0.00,0.00,0.00,0.00,391444),('1','72','130097','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,391445),('1','72','130100','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,391452),('1','72','130100','226',220.00,210.00,62.86,0.00,0.00,0.00,0.00,391453),('1','72','130100','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,391454),('1','72','130233','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,391852),('1','72','130233','226',220.00,210.00,102.85,0.00,0.00,0.00,0.00,391853),('1','72','130233','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,391854),('1','72','130534','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,392757),('1','72','130534','226',220.00,210.00,123.98,0.00,0.00,0.00,0.00,392758),('1','72','130534','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,392759),('1','72','130537','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,392766),('1','72','130537','226',220.00,210.00,686.36,0.00,0.00,0.00,0.00,392767),('1','72','130537','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,392768),('1','72','135118','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,406530),('1','72','135118','226',220.00,200.00,659.18,0.00,0.00,0.00,0.00,406531),('1','72','135118','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,406532),('1','72','135209','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,406803),('1','72','135209','226',220.00,200.00,787.37,0.00,0.00,0.00,0.00,406804),('1','72','135209','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,406805),('1','72','135322','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,407128),('1','72','135322','226',200.00,200.00,445.50,0.00,0.00,0.00,0.00,407129),('1','72','135322','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,407130),('1','72','135428','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,407453),('1','72','135428','226',200.00,200.00,548.20,0.00,0.00,0.00,0.00,407454),('1','72','135428','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,407455),('1','72','135560','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,407852),('1','72','135560','226',200.00,200.00,662.00,0.00,0.00,0.00,0.00,407853),('1','72','135560','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,407854),('1','72','135778','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,408510),('1','72','135778','226',200.00,200.00,464.50,0.00,0.00,0.00,0.00,408511),('1','72','135778','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,408512),('1','72','135780','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,408516),('1','72','135780','226',200.00,200.00,50.00,0.00,0.00,0.00,0.00,408517),('1','72','135780','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,408518),('1','72','136140','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,409595),('1','72','136140','226',200.00,200.00,65.00,0.00,0.00,0.00,0.00,409596),('1','72','136140','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,409597),('1','72','136142','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,409601),('1','72','136142','226',200.00,200.00,510.65,0.00,0.00,0.00,0.00,409602),('1','72','136142','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,409603),('1','72','136143','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,409604),('1','72','136143','226',200.00,200.00,252.65,0.00,0.00,0.00,0.00,409605),('1','72','136143','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,409606),('1','72','136329','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,410164),('1','72','136329','226',200.00,200.00,564.98,0.00,0.00,0.00,0.00,410165),('1','72','136329','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,410166),('1','72','136331','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,410170),('1','72','136331','226',200.00,200.00,747.54,0.00,0.00,0.00,0.00,410171),('1','72','136331','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,410172),('1','72','136570','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,410872),('1','72','136570','226',200.00,195.00,104.20,0.00,0.00,0.00,0.00,410873),('1','72','136570','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,410874),('1','72','136572','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,410878),('1','72','136572','226',200.00,195.00,71.13,0.00,0.00,0.00,0.00,410879),('1','72','136572','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,410880),('1','72','137251','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,412922),('1','72','137251','226',200.00,195.00,180.26,0.00,0.00,0.00,0.00,412923),('1','72','137251','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,412924),('1','72','137252','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,412925),('1','72','137252','226',200.00,195.00,545.43,0.00,0.00,0.00,0.00,412926),('1','72','137252','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,412927),('1','72','137253','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,412928),('1','72','137253','226',200.00,195.00,376.92,0.00,0.00,0.00,0.00,412929),('1','72','137253','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,412930),('1','72','137254','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,412931),('1','72','137254','226',200.00,195.00,451.28,0.00,0.00,0.00,0.00,412932),('1','72','137254','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,412933),('1','72','137255','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,412934),('1','72','137255','226',200.00,195.00,246.66,0.00,0.00,0.00,0.00,412935),('1','72','137255','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,412936),('1','72','137422','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,413438),('1','72','137422','226',200.00,195.00,246.68,0.00,0.00,0.00,0.00,413439),('1','72','137422','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,413440),('1','72','137768','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,414468),('1','72','137768','226',200.00,195.00,452.35,0.00,0.00,0.00,0.00,414469),('1','72','137768','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,414470),('1','72','137769','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,414471),('1','72','137769','226',200.00,195.00,110.26,0.00,0.00,0.00,0.00,414472),('1','72','137769','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,414473),('1','72','137910','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,414894),('1','72','137910','226',200.00,195.00,610.15,0.00,0.00,0.00,0.00,414895),('1','72','137910','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,414896),('1','72','138041','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,415280),('1','72','138041','226',200.00,195.00,1644.16,0.00,0.00,0.00,0.00,415281),('1','72','138041','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,415282),('1','72','138462','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,416546),('1','72','138462','226',200.00,190.00,128.59,0.00,0.00,0.00,0.00,416547),('1','72','138462','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,416548),('1','72','138465','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,416555),('1','72','138465','226',200.00,190.00,551.29,0.00,0.00,0.00,0.00,416556),('1','72','138465','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,416557),('1','72','138468','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,416564),('1','72','138468','226',200.00,190.00,160.48,0.00,0.00,0.00,0.00,416565),('1','72','138468','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,416566),('1','72','138471','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,416573),('1','72','138471','226',200.00,190.00,173.14,0.00,0.00,0.00,0.00,416574),('1','72','138471','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,416575),('1','72','138605','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,416977),('1','72','138605','226',200.00,190.00,151.58,0.00,0.00,0.00,0.00,416978),('1','72','138605','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,416979),('1','72','139809','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,420574),('1','72','139809','226',200.00,190.00,220.52,0.00,0.00,0.00,0.00,420575),('1','72','139809','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,420576),('1','72','139812','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,420583),('1','72','139812','226',200.00,190.00,298.69,0.00,0.00,0.00,0.00,420584),('1','72','139812','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,420585),('1','72','139814','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,420589),('1','72','139814','226',200.00,190.00,393.70,0.00,0.00,0.00,0.00,420590),('1','72','139814','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,420591),('1','72','139816','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,420595),('1','72','139816','226',200.00,190.00,105.26,0.00,0.00,0.00,0.00,420596),('1','72','139816','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,420597),('1','72','139817','225',140.00,0.00,0.00,0.00,0.00,0.00,0.00,420598),('1','72','139817','226',200.00,190.00,43.34,0.00,0.00,0.00,0.00,420599),('1','72','139817','227',0.00,0.00,0.00,0.00,0.00,0.00,0.00,420600);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=239 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',236,'72','PMS TANKS','Tank Containing Petroleum.'),('1',237,'72','AGO TANK','Tank Containing Diesel.'),('1',238,'72','DPK TANK','Tank Containing Kerosene.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=594 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','72','236',590,0,'225','PMS TANK 1',33000.00,1.00,0.00,'PMS TANK 1','404','2018-11-05 16:51:01','2018-11-05 16:51:01','404',5,1),('1','72','236',591,0,'225','PMS TANK 2',33000.00,1.00,14800.00,'PMS TANK 2','404','2018-11-05 16:52:34','2018-11-05 16:52:34','404',5,1),('1','72','237',592,0,'226','AGO TANK 3',33000.00,1.00,1919.00,'AGO TANK 3','404','2018-11-05 16:54:09','2018-11-05 16:54:09','404',5,1),('1','72','238',593,0,'227','DPK TANK 4',33000.00,1.00,0.00,'DPK TANK 4','404','2018-11-05 16:55:16','2018-11-05 16:55:16','404',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2613955 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2612746,'1','72',NULL,226,'Balance from closing inventory values 2021-11-31 23:59:59',58142644.35,58557000.00,259800.00,269868.00,0.00,'2021-11-30 23:59:59','',''),(2612993,'1','72',NULL,225,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,6650000.00,47500.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2612998,'1','72',NULL,227,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613213,'1','72','590',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613506,'1','72','591',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,14800.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613601,'1','72','593',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613954,'1','72','592',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,1919.00,0.00,0.00,'2021-11-30 23:59:59','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=370880 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (203061,'1','72',225,'Sale Id shift 70008',0.00,0.00,0.00,0.00,0.00,'2018-12-06 08:18:26'),(203062,'1','72',226,'Sale Id shift 70008',0.00,101033.40,260.00,101033.40,0.00,'2018-12-06 08:18:26'),(203063,'1','72',227,'Sale Id shift 70008',0.00,0.00,0.00,0.00,0.00,'2018-12-06 08:18:26'),(203167,'1','72',225,'Sale Id shift 70659',0.00,0.00,0.00,0.00,0.00,'2018-12-06 11:53:53'),(203168,'1','72',226,'Sale Id shift 70659',0.00,276684.20,260.00,276684.20,0.00,'2018-12-06 11:53:53'),(203169,'1','72',227,'Sale Id shift 70659',0.00,0.00,0.00,0.00,0.00,'2018-12-06 11:53:53'),(203173,'1','72',225,'Sale Id shift 70697',0.00,0.00,0.00,0.00,0.00,'2018-12-06 12:03:11'),(203174,'1','72',226,'Sale Id shift 70697',0.00,304987.80,260.00,304987.80,0.00,'2018-12-06 12:03:11'),(203175,'1','72',227,'Sale Id shift 70697',0.00,0.00,0.00,0.00,0.00,'2018-12-06 12:03:11'),(203176,'1','72',225,'Sale Id shift 70699',0.00,0.00,0.00,0.00,0.00,'2018-12-06 12:11:42'),(203177,'1','72',226,'Sale Id shift 70699',0.00,458096.60,260.00,458096.60,0.00,'2018-12-06 12:11:42'),(203178,'1','72',227,'Sale Id shift 70699',0.00,0.00,0.00,0.00,0.00,'2018-12-06 12:11:42'),(203188,'1','72',225,'Sale Id shift 70700',0.00,0.00,0.00,0.00,0.00,'2018-12-06 12:26:03'),(203189,'1','72',226,'Sale Id shift 70700',0.00,176888.40,260.00,176888.40,0.00,'2018-12-06 12:26:03'),(203190,'1','72',227,'Sale Id shift 70700',0.00,0.00,0.00,0.00,0.00,'2018-12-06 12:26:03'),(203203,'1','72',225,'Sale Id shift 70702',0.00,0.00,0.00,0.00,0.00,'2018-12-06 12:46:35'),(203204,'1','72',226,'Sale Id shift 70702',0.00,95503.20,260.00,95503.20,0.00,'2018-12-06 12:46:35'),(203205,'1','72',227,'Sale Id shift 70702',0.00,0.00,0.00,0.00,0.00,'2018-12-06 12:46:35'),(203410,'1','72',225,'Sale Id shift 70708',0.00,0.00,0.00,0.00,0.00,'2018-12-07 07:50:42'),(203411,'1','72',226,'Sale Id shift 70708',0.00,186105.40,260.00,186105.40,0.00,'2018-12-07 07:50:42'),(203412,'1','72',227,'Sale Id shift 70708',0.00,0.00,0.00,0.00,0.00,'2018-12-07 07:50:42'),(203413,'1','72',225,'Sale Id shift 70783',0.00,0.00,0.00,0.00,0.00,'2018-12-07 07:55:25'),(203414,'1','72',226,'Sale Id shift 70783',0.00,235003.60,260.00,235003.60,0.00,'2018-12-07 07:55:25'),(203415,'1','72',227,'Sale Id shift 70783',0.00,0.00,0.00,0.00,0.00,'2018-12-07 07:55:25'),(203730,'1','72',225,'Sale Id shift 70893',0.00,0.00,0.00,0.00,0.00,'2018-12-08 07:45:28'),(203731,'1','72',226,'Sale Id shift 70893',0.00,149640.40,260.00,149640.40,0.00,'2018-12-08 07:45:28'),(203732,'1','72',227,'Sale Id shift 70893',0.00,0.00,0.00,0.00,0.00,'2018-12-08 07:45:28'),(204297,'1','72',225,'Sale Id shift 70896',0.00,0.00,0.00,0.00,0.00,'2018-12-09 16:36:13'),(204298,'1','72',226,'Sale Id shift 70896',0.00,97016.40,260.00,97016.40,0.00,'2018-12-09 16:36:13'),(204299,'1','72',227,'Sale Id shift 70896',0.00,0.00,0.00,0.00,0.00,'2018-12-09 16:36:13'),(204382,'1','72',225,'Sale Id shift 71086',0.00,0.00,0.00,0.00,0.00,'2018-12-10 08:38:13'),(204383,'1','72',226,'Sale Id shift 71086',0.00,199963.40,260.00,199963.40,0.00,'2018-12-10 08:38:13'),(204384,'1','72',227,'Sale Id shift 71086',0.00,0.00,0.00,0.00,0.00,'2018-12-10 08:38:13'),(204801,'1','72',225,'Sale Id shift 71118',0.00,0.00,0.00,0.00,0.00,'2018-12-11 10:11:49'),(204802,'1','72',226,'Sale Id shift 71118',0.00,88927.80,260.00,88927.80,0.00,'2018-12-11 10:11:49'),(204803,'1','72',227,'Sale Id shift 71118',0.00,0.00,0.00,0.00,0.00,'2018-12-11 10:11:49'),(205128,'1','72',225,'Sale Id shift 71373',0.00,0.00,0.00,0.00,0.00,'2018-12-12 09:07:23'),(205129,'1','72',226,'Sale Id shift 71373',0.00,163264.40,260.00,163264.40,0.00,'2018-12-12 09:07:23'),(205130,'1','72',227,'Sale Id shift 71373',0.00,0.00,0.00,0.00,0.00,'2018-12-12 09:07:23'),(205492,'1','72',225,'Sale Id shift 71374',0.00,0.00,0.00,0.00,0.00,'2018-12-13 08:15:29'),(205493,'1','72',226,'Sale Id shift 71374',0.00,157445.60,260.00,157445.60,0.00,'2018-12-13 08:15:29'),(205494,'1','72',227,'Sale Id shift 71374',0.00,0.00,0.00,0.00,0.00,'2018-12-13 08:15:29'),(205856,'1','72',225,'Sale Id shift 71508',0.00,0.00,0.00,0.00,0.00,'2018-12-14 08:26:01'),(205857,'1','72',226,'Sale Id shift 71508',0.00,187608.20,260.00,187608.20,0.00,'2018-12-14 08:26:01'),(205858,'1','72',227,'Sale Id shift 71508',0.00,0.00,0.00,0.00,0.00,'2018-12-14 08:26:01'),(207427,'1','72',225,'Sale Id shift 71638',0.00,0.00,0.00,0.00,0.00,'2018-12-17 17:03:04'),(207428,'1','72',226,'Sale Id shift 71638',0.00,453635.00,260.00,453635.00,0.00,'2018-12-17 17:03:04'),(207429,'1','72',227,'Sale Id shift 71638',0.00,0.00,0.00,0.00,0.00,'2018-12-17 17:03:04'),(207433,'1','72',225,'Sale Id shift 72177',0.00,0.00,0.00,0.00,0.00,'2018-12-17 17:12:13'),(207434,'1','72',226,'Sale Id shift 72177',0.00,426735.40,260.00,426735.40,0.00,'2018-12-17 17:12:13'),(207435,'1','72',227,'Sale Id shift 72177',0.00,0.00,0.00,0.00,0.00,'2018-12-17 17:12:13'),(207439,'1','72',225,'Sale Id shift 72179',0.00,0.00,0.00,0.00,0.00,'2018-12-17 17:16:04'),(207440,'1','72',226,'Sale Id shift 72179',0.00,288696.20,260.00,288696.20,0.00,'2018-12-17 17:16:04'),(207441,'1','72',227,'Sale Id shift 72179',0.00,0.00,0.00,0.00,0.00,'2018-12-17 17:16:04'),(207523,'1','72',225,'Sale Id shift 72206',0.00,0.00,0.00,0.00,0.00,'2018-12-18 09:16:48'),(207524,'1','72',226,'Sale Id shift 72206',0.00,493022.40,260.00,493022.40,0.00,'2018-12-18 09:16:48'),(207525,'1','72',227,'Sale Id shift 72206',0.00,0.00,0.00,0.00,0.00,'2018-12-18 09:16:48'),(207842,'1','72',225,'Sale Id shift 72209',0.00,0.00,0.00,0.00,0.00,'2018-12-19 07:52:48'),(207843,'1','72',226,'Sale Id shift 72209',0.00,142305.80,260.00,142305.80,0.00,'2018-12-19 07:52:48'),(207844,'1','72',227,'Sale Id shift 72209',0.00,0.00,0.00,0.00,0.00,'2018-12-19 07:52:48'),(208281,'1','72',225,'Sale Id shift 72489',0.00,0.00,0.00,0.00,0.00,'2018-12-20 10:40:15'),(208282,'1','72',226,'Sale Id shift 72489',0.00,265266.30,255.00,265266.30,0.00,'2018-12-20 10:40:15'),(208283,'1','72',227,'Sale Id shift 72489',0.00,0.00,0.00,0.00,0.00,'2018-12-20 10:40:15'),(208874,'1','72',225,'Sale Id shift 72713',0.00,0.00,0.00,0.00,0.00,'2018-12-21 16:31:52'),(208875,'1','72',226,'Sale Id shift 72713',0.00,210255.15,255.00,210255.15,0.00,'2018-12-21 16:31:52'),(208876,'1','72',227,'Sale Id shift 72713',0.00,0.00,0.00,0.00,0.00,'2018-12-21 16:31:52'),(208892,'1','72',225,'Sale Id shift 72718',0.00,0.00,0.00,0.00,0.00,'2018-12-21 16:48:28'),(208893,'1','72',226,'Sale Id shift 72718',0.00,134012.70,255.00,134012.70,0.00,'2018-12-21 16:48:28'),(208894,'1','72',227,'Sale Id shift 72718',0.00,0.00,0.00,0.00,0.00,'2018-12-21 16:48:28'),(209094,'1','72',225,'Sale Id shift 72799',0.00,0.00,0.00,0.00,0.00,'2018-12-22 12:58:15'),(209095,'1','72',226,'Sale Id shift 72799',0.00,26127.50,250.00,26127.50,0.00,'2018-12-22 12:58:15'),(209096,'1','72',227,'Sale Id shift 72799',0.00,0.00,0.00,0.00,0.00,'2018-12-22 12:58:15'),(209548,'1','72',225,'Sale Id shift 72801',0.00,0.00,0.00,0.00,0.00,'2018-12-23 15:47:13'),(209549,'1','72',226,'Sale Id shift 72801',0.00,213807.50,250.00,213807.50,0.00,'2018-12-23 15:47:13'),(209550,'1','72',227,'Sale Id shift 72801',0.00,0.00,0.00,0.00,0.00,'2018-12-23 15:47:13'),(209906,'1','72',225,'Sale Id shift 72955',0.00,0.00,0.00,0.00,0.00,'2018-12-24 15:22:39'),(209907,'1','72',226,'Sale Id shift 72955',0.00,193600.00,250.00,193600.00,0.00,'2018-12-24 15:22:39'),(209908,'1','72',227,'Sale Id shift 72955',0.00,0.00,0.00,0.00,0.00,'2018-12-24 15:22:39'),(210240,'1','72',225,'Sale Id shift 73086',0.00,0.00,0.00,0.00,0.00,'2018-12-25 16:14:48'),(210241,'1','72',226,'Sale Id shift 73086',0.00,164130.00,250.00,164130.00,0.00,'2018-12-25 16:14:48'),(210242,'1','72',227,'Sale Id shift 73086',0.00,0.00,0.00,0.00,0.00,'2018-12-25 16:14:48'),(210246,'1','72',225,'Sale Id shift 73203',0.00,0.00,0.00,0.00,0.00,'2018-12-25 16:22:02'),(210247,'1','72',226,'Sale Id shift 73203',0.00,19550.00,250.00,19550.00,0.00,'2018-12-25 16:22:02'),(210248,'1','72',227,'Sale Id shift 73203',0.00,0.00,0.00,0.00,0.00,'2018-12-25 16:22:02'),(210534,'1','72',225,'Sale Id shift 73206',0.00,0.00,0.00,0.00,0.00,'2018-12-26 12:52:44'),(210535,'1','72',226,'Sale Id shift 73206',0.00,35547.05,245.00,35547.05,0.00,'2018-12-26 12:52:44'),(210536,'1','72',227,'Sale Id shift 73206',0.00,0.00,0.00,0.00,0.00,'2018-12-26 12:52:44'),(210772,'1','72',225,'Sale Id shift 73319',0.00,0.00,0.00,0.00,0.00,'2018-12-27 09:39:45'),(210773,'1','72',226,'Sale Id shift 73319',0.00,166453.00,245.00,166453.00,0.00,'2018-12-27 09:39:45'),(210774,'1','72',227,'Sale Id shift 73319',0.00,0.00,0.00,0.00,0.00,'2018-12-27 09:39:45'),(211222,'1','72',225,'Sale Id shift 73410',0.00,0.00,0.00,0.00,0.00,'2018-12-28 14:27:03'),(211223,'1','72',226,'Sale Id shift 73410',0.00,317348.50,245.00,317348.50,0.00,'2018-12-28 14:27:03'),(211224,'1','72',227,'Sale Id shift 73410',0.00,0.00,0.00,0.00,0.00,'2018-12-28 14:27:03'),(211732,'1','72',225,'Sale Id shift 73567',0.00,0.00,0.00,0.00,0.00,'2018-12-30 08:23:57'),(211733,'1','72',226,'Sale Id shift 73567',0.00,353953.95,245.00,353953.95,0.00,'2018-12-30 08:23:57'),(211734,'1','72',227,'Sale Id shift 73567',0.00,0.00,0.00,0.00,0.00,'2018-12-30 08:23:57'),(211738,'1','72',225,'Sale Id shift 73748',0.00,0.00,0.00,0.00,0.00,'2018-12-30 08:26:46'),(211739,'1','72',226,'Sale Id shift 73748',0.00,170934.05,245.00,170934.05,0.00,'2018-12-30 08:26:46'),(211740,'1','72',227,'Sale Id shift 73748',0.00,0.00,0.00,0.00,0.00,'2018-12-30 08:26:46'),(212059,'1','72',225,'Sale Id shift 73750',0.00,0.00,0.00,0.00,0.00,'2018-12-31 08:13:08'),(212060,'1','72',226,'Sale Id shift 73750',0.00,118161.05,245.00,118161.05,0.00,'2018-12-31 08:13:08'),(212061,'1','72',227,'Sale Id shift 73750',0.00,0.00,0.00,0.00,0.00,'2018-12-31 08:13:08'),(213818,'1','72',225,'Sale Id shift 73868',0.00,0.00,0.00,0.00,0.00,'2019-01-04 19:05:04'),(213819,'1','72',226,'Sale Id shift 73868',0.00,304074.40,245.00,304074.40,0.00,'2019-01-04 19:05:04'),(213820,'1','72',227,'Sale Id shift 73868',0.00,0.00,0.00,0.00,0.00,'2019-01-04 19:05:04'),(213821,'1','72',225,'Sale Id shift 74467',0.00,0.00,0.00,0.00,0.00,'2019-01-04 19:10:42'),(213822,'1','72',226,'Sale Id shift 74467',0.00,168319.90,245.00,168319.90,0.00,'2019-01-04 19:10:42'),(213823,'1','72',227,'Sale Id shift 74467',0.00,0.00,0.00,0.00,0.00,'2019-01-04 19:10:42'),(213824,'1','72',225,'Sale Id shift 74468',0.00,0.00,0.00,0.00,0.00,'2019-01-04 19:13:51'),(213825,'1','72',226,'Sale Id shift 74468',0.00,196053.90,245.00,196053.90,0.00,'2019-01-04 19:13:51'),(213826,'1','72',227,'Sale Id shift 74468',0.00,0.00,0.00,0.00,0.00,'2019-01-04 19:13:51'),(213827,'1','72',225,'Sale Id shift 74469',0.00,0.00,0.00,0.00,0.00,'2019-01-04 19:21:32'),(213828,'1','72',226,'Sale Id shift 74469',0.00,319176.20,245.00,319176.20,0.00,'2019-01-04 19:21:32'),(213829,'1','72',227,'Sale Id shift 74469',0.00,0.00,0.00,0.00,0.00,'2019-01-04 19:21:32'),(214178,'1','72',225,'Sale Id shift 74470',0.00,0.00,0.00,0.00,0.00,'2019-01-06 08:01:14'),(214179,'1','72',226,'Sale Id shift 74470',0.00,282100.35,245.00,282100.35,0.00,'2019-01-06 08:01:14'),(214180,'1','72',227,'Sale Id shift 74470',0.00,0.00,0.00,0.00,0.00,'2019-01-06 08:01:14'),(214181,'1','72',225,'Sale Id shift 74585',0.00,0.00,0.00,0.00,0.00,'2019-01-06 08:04:35'),(214182,'1','72',226,'Sale Id shift 74585',0.00,129727.50,245.00,129727.50,0.00,'2019-01-06 08:04:35'),(214183,'1','72',227,'Sale Id shift 74585',0.00,0.00,0.00,0.00,0.00,'2019-01-06 08:04:35'),(214523,'1','72',225,'Sale Id shift 74586',0.00,0.00,0.00,0.00,0.00,'2019-01-07 09:02:23'),(214524,'1','72',226,'Sale Id shift 74586',0.00,122426.50,245.00,122426.50,0.00,'2019-01-07 09:02:23'),(214525,'1','72',227,'Sale Id shift 74586',0.00,0.00,0.00,0.00,0.00,'2019-01-07 09:02:23'),(215522,'1','72',225,'Sale Id shift 74705',0.00,0.00,0.00,0.00,0.00,'2019-01-09 14:45:52'),(215523,'1','72',226,'Sale Id shift 74705',0.00,497112.00,240.00,497112.00,0.00,'2019-01-09 14:45:52'),(215524,'1','72',227,'Sale Id shift 74705',0.00,0.00,0.00,0.00,0.00,'2019-01-09 14:45:52'),(215525,'1','72',225,'Sale Id shift 75048',0.00,0.00,0.00,0.00,0.00,'2019-01-09 14:48:45'),(215526,'1','72',226,'Sale Id shift 75048',0.00,281044.80,240.00,281044.80,0.00,'2019-01-09 14:48:45'),(215527,'1','72',227,'Sale Id shift 75048',0.00,0.00,0.00,0.00,0.00,'2019-01-09 14:48:45'),(215678,'1','72',225,'Sale Id shift 75050',0.00,0.00,0.00,0.00,0.00,'2019-01-10 08:30:54'),(215679,'1','72',226,'Sale Id shift 75050',0.00,180024.00,240.00,180024.00,0.00,'2019-01-10 08:30:54'),(215680,'1','72',227,'Sale Id shift 75050',0.00,0.00,0.00,0.00,0.00,'2019-01-10 08:30:54'),(216064,'1','72',225,'Sale Id shift 75100',0.00,0.00,0.00,0.00,0.00,'2019-01-11 08:29:18'),(216065,'1','72',226,'Sale Id shift 75100',0.00,316185.60,240.00,316185.60,0.00,'2019-01-11 08:29:18'),(216066,'1','72',227,'Sale Id shift 75100',0.00,0.00,0.00,0.00,0.00,'2019-01-11 08:29:18'),(216428,'1','72',225,'Sale Id shift 75233',0.00,0.00,0.00,0.00,0.00,'2019-01-12 11:42:40'),(216429,'1','72',226,'Sale Id shift 75233',0.00,196346.40,240.00,196346.40,0.00,'2019-01-12 11:42:40'),(216430,'1','72',227,'Sale Id shift 75233',0.00,0.00,0.00,0.00,0.00,'2019-01-12 11:42:40'),(216670,'1','72',225,'Sale Id shift 75365',0.00,0.00,0.00,0.00,0.00,'2019-01-13 07:36:53'),(216671,'1','72',226,'Sale Id shift 75365',0.00,181812.00,240.00,181812.00,0.00,'2019-01-13 07:36:53'),(216672,'1','72',227,'Sale Id shift 75365',0.00,0.00,0.00,0.00,0.00,'2019-01-13 07:36:53'),(217122,'1','72',225,'Sale Id shift 75446',0.00,0.00,0.00,0.00,0.00,'2019-01-14 11:23:11'),(217123,'1','72',226,'Sale Id shift 75446',0.00,58929.60,240.00,58929.60,0.00,'2019-01-14 11:23:11'),(217124,'1','72',227,'Sale Id shift 75446',0.00,0.00,0.00,0.00,0.00,'2019-01-14 11:23:11'),(217528,'1','72',225,'Sale Id shift 75595',0.00,0.00,0.00,0.00,0.00,'2019-01-15 12:46:21'),(217529,'1','72',226,'Sale Id shift 75595',0.00,108602.40,240.00,108602.40,0.00,'2019-01-15 12:46:21'),(217530,'1','72',227,'Sale Id shift 75595',0.00,0.00,0.00,0.00,0.00,'2019-01-15 12:46:21'),(217748,'1','72',225,'Sale Id shift 75737',0.00,0.00,0.00,0.00,0.00,'2019-01-16 09:16:41'),(217749,'1','72',226,'Sale Id shift 75737',0.00,292142.40,240.00,292142.40,0.00,'2019-01-16 09:16:41'),(217750,'1','72',227,'Sale Id shift 75737',0.00,0.00,0.00,0.00,0.00,'2019-01-16 09:16:41'),(218280,'1','72',225,'Sale Id shift 75811',0.00,0.00,0.00,0.00,0.00,'2019-01-17 14:38:32'),(218281,'1','72',226,'Sale Id shift 75811',0.00,165345.60,240.00,165345.60,0.00,'2019-01-17 14:38:32'),(218282,'1','72',227,'Sale Id shift 75811',0.00,0.00,0.00,0.00,0.00,'2019-01-17 14:38:32'),(218415,'1','72',225,'Sale Id shift 76011',0.00,0.00,0.00,0.00,0.00,'2019-01-18 08:13:10'),(218416,'1','72',226,'Sale Id shift 76011',0.00,395863.20,240.00,395863.20,0.00,'2019-01-18 08:13:10'),(218417,'1','72',227,'Sale Id shift 76011',0.00,0.00,0.00,0.00,0.00,'2019-01-18 08:13:10'),(220206,'1','72',225,'Sale Id shift 76054',0.00,0.00,0.00,0.00,0.00,'2019-01-23 07:53:58'),(220207,'1','72',226,'Sale Id shift 76054',0.00,432336.00,240.00,432336.00,0.00,'2019-01-23 07:53:58'),(220208,'1','72',227,'Sale Id shift 76054',0.00,0.00,0.00,0.00,0.00,'2019-01-23 07:53:58'),(220212,'1','72',225,'Sale Id shift 76689',0.00,0.00,0.00,0.00,0.00,'2019-01-23 07:58:29'),(220213,'1','72',226,'Sale Id shift 76689',0.00,128971.20,240.00,128971.20,0.00,'2019-01-23 07:58:29'),(220214,'1','72',227,'Sale Id shift 76689',0.00,0.00,0.00,0.00,0.00,'2019-01-23 07:58:29'),(220215,'1','72',225,'Sale Id shift 76691',0.00,0.00,0.00,0.00,0.00,'2019-01-23 08:02:39'),(220216,'1','72',226,'Sale Id shift 76691',0.00,283996.80,240.00,283996.80,0.00,'2019-01-23 08:02:39'),(220217,'1','72',227,'Sale Id shift 76691',0.00,0.00,0.00,0.00,0.00,'2019-01-23 08:02:39'),(220218,'1','72',225,'Sale Id shift 76692',0.00,0.00,0.00,0.00,0.00,'2019-01-23 08:10:36'),(220219,'1','72',226,'Sale Id shift 76692',0.00,147952.80,240.00,147952.80,0.00,'2019-01-23 08:10:36'),(220220,'1','72',227,'Sale Id shift 76692',0.00,0.00,0.00,0.00,0.00,'2019-01-23 08:10:36'),(220835,'1','72',225,'Sale Id shift 76693',0.00,0.00,0.00,0.00,0.00,'2019-01-24 16:30:26'),(220836,'1','72',226,'Sale Id shift 76693',0.00,473832.00,240.00,473832.00,0.00,'2019-01-24 16:30:26'),(220837,'1','72',227,'Sale Id shift 76693',0.00,0.00,0.00,0.00,0.00,'2019-01-24 16:30:26'),(220925,'1','72',225,'Sale Id shift 76903',0.00,0.00,0.00,0.00,0.00,'2019-01-25 08:38:20'),(220926,'1','72',226,'Sale Id shift 76903',0.00,215882.40,240.00,215882.40,0.00,'2019-01-25 08:38:20'),(220927,'1','72',227,'Sale Id shift 76903',0.00,0.00,0.00,0.00,0.00,'2019-01-25 08:38:20'),(221290,'1','72',225,'Sale Id shift 76933',0.00,0.00,0.00,0.00,0.00,'2019-01-26 10:37:44'),(221291,'1','72',226,'Sale Id shift 76933',0.00,14599.20,240.00,14599.20,0.00,'2019-01-26 10:37:44'),(221292,'1','72',227,'Sale Id shift 76933',0.00,0.00,0.00,0.00,0.00,'2019-01-26 10:37:44'),(221296,'1','72',225,'Sale Id shift 77064',0.00,0.00,0.00,0.00,0.00,'2019-01-26 10:50:36'),(221297,'1','72',226,'Sale Id shift 77064',0.00,125044.10,230.00,125044.10,0.00,'2019-01-26 10:50:36'),(221298,'1','72',227,'Sale Id shift 77064',0.00,0.00,0.00,0.00,0.00,'2019-01-26 10:50:36'),(221913,'1','72',225,'Sale Id shift 77066',0.00,0.00,0.00,0.00,0.00,'2019-01-28 08:02:24'),(221914,'1','72',226,'Sale Id shift 77066',0.00,170471.40,230.00,170471.40,0.00,'2019-01-28 08:02:24'),(221915,'1','72',227,'Sale Id shift 77066',0.00,0.00,0.00,0.00,0.00,'2019-01-28 08:02:24'),(222036,'1','72',225,'Sale Id shift 77272',0.00,0.00,0.00,0.00,0.00,'2019-01-28 11:25:32'),(222037,'1','72',226,'Sale Id shift 77272',0.00,65858.20,230.00,65858.20,0.00,'2019-01-28 11:25:32'),(222038,'1','72',227,'Sale Id shift 77272',0.00,0.00,0.00,0.00,0.00,'2019-01-28 11:25:32'),(222405,'1','72',225,'Sale Id shift 77315',0.00,0.00,0.00,0.00,0.00,'2019-01-29 10:57:01'),(222406,'1','72',226,'Sale Id shift 77315',0.00,9666.90,230.00,9666.90,0.00,'2019-01-29 10:57:01'),(222407,'1','72',227,'Sale Id shift 77315',0.00,0.00,0.00,0.00,0.00,'2019-01-29 10:57:01'),(222408,'1','72',225,'Sale Id shift 77462',0.00,0.00,0.00,0.00,0.00,'2019-01-29 11:01:41'),(222409,'1','72',226,'Sale Id shift 77462',0.00,65052.00,225.00,65052.00,0.00,'2019-01-29 11:01:41'),(222410,'1','72',227,'Sale Id shift 77462',0.00,0.00,0.00,0.00,0.00,'2019-01-29 11:01:41'),(223056,'1','72',225,'Sale Id shift 77463',0.00,0.00,0.00,0.00,0.00,'2019-01-31 09:28:55'),(223057,'1','72',226,'Sale Id shift 77463',0.00,315677.25,225.00,315677.25,0.00,'2019-01-31 09:28:55'),(223058,'1','72',227,'Sale Id shift 77463',0.00,0.00,0.00,0.00,0.00,'2019-01-31 09:28:55'),(223065,'1','72',225,'Sale Id shift 77687',0.00,0.00,0.00,0.00,0.00,'2019-01-31 09:32:11'),(223066,'1','72',226,'Sale Id shift 77687',0.00,757469.25,225.00,757469.25,0.00,'2019-01-31 09:32:11'),(223067,'1','72',227,'Sale Id shift 77687',0.00,0.00,0.00,0.00,0.00,'2019-01-31 09:32:11'),(223459,'1','72',225,'Sale Id shift 77689',0.00,0.00,0.00,0.00,0.00,'2019-02-01 11:06:46'),(223460,'1','72',226,'Sale Id shift 77689',0.00,185688.00,225.00,185688.00,0.00,'2019-02-01 11:06:46'),(223461,'1','72',227,'Sale Id shift 77689',0.00,0.00,0.00,0.00,0.00,'2019-02-01 11:06:46'),(224047,'1','72',225,'Sale Id shift 77823',0.00,0.00,0.00,0.00,0.00,'2019-02-03 08:20:02'),(224048,'1','72',226,'Sale Id shift 77823',0.00,63499.50,225.00,63499.50,0.00,'2019-02-03 08:20:02'),(224049,'1','72',227,'Sale Id shift 77823',0.00,0.00,0.00,0.00,0.00,'2019-02-03 08:20:02'),(224050,'1','72',225,'Sale Id shift 78030',0.00,0.00,0.00,0.00,0.00,'2019-02-03 08:25:12'),(224051,'1','72',226,'Sale Id shift 78030',0.00,430571.25,225.00,430571.25,0.00,'2019-02-03 08:25:12'),(224052,'1','72',227,'Sale Id shift 78030',0.00,0.00,0.00,0.00,0.00,'2019-02-03 08:25:12'),(224515,'1','72',225,'Sale Id shift 78034',0.00,0.00,0.00,0.00,0.00,'2019-02-04 12:08:49'),(224516,'1','72',226,'Sale Id shift 78034',0.00,419681.25,225.00,419681.25,0.00,'2019-02-04 12:08:49'),(224517,'1','72',227,'Sale Id shift 78034',0.00,0.00,0.00,0.00,0.00,'2019-02-04 12:08:49'),(225077,'1','72',225,'Sale Id shift 78192',0.00,0.00,0.00,0.00,0.00,'2019-02-05 15:28:12'),(225078,'1','72',226,'Sale Id shift 78192',0.00,335342.25,225.00,335342.25,0.00,'2019-02-05 15:28:12'),(225079,'1','72',227,'Sale Id shift 78192',0.00,0.00,0.00,0.00,0.00,'2019-02-05 15:28:12'),(225345,'1','72',225,'Sale Id shift 78387',0.00,0.00,0.00,0.00,0.00,'2019-02-06 12:25:39'),(225346,'1','72',226,'Sale Id shift 78387',0.00,152093.25,225.00,152093.25,0.00,'2019-02-06 12:25:39'),(225347,'1','72',227,'Sale Id shift 78387',0.00,0.00,0.00,0.00,0.00,'2019-02-06 12:25:39'),(225835,'1','72',225,'Sale Id shift 78479',0.00,0.00,0.00,0.00,0.00,'2019-02-07 15:52:35'),(225836,'1','72',226,'Sale Id shift 78479',0.00,548732.25,225.00,548732.25,0.00,'2019-02-07 15:52:35'),(225837,'1','72',227,'Sale Id shift 78479',0.00,0.00,0.00,0.00,0.00,'2019-02-07 15:52:35'),(226612,'1','72',225,'Sale Id shift 78655',0.00,0.00,0.00,0.00,0.00,'2019-02-10 09:48:42'),(226613,'1','72',226,'Sale Id shift 78655',0.00,431331.75,225.00,431331.75,0.00,'2019-02-10 09:48:42'),(226614,'1','72',227,'Sale Id shift 78655',0.00,0.00,0.00,0.00,0.00,'2019-02-10 09:48:42'),(226615,'1','72',225,'Sale Id shift 78943',0.00,0.00,0.00,0.00,0.00,'2019-02-10 09:53:43'),(226616,'1','72',226,'Sale Id shift 78943',0.00,231099.75,225.00,231099.75,0.00,'2019-02-10 09:53:43'),(226617,'1','72',227,'Sale Id shift 78943',0.00,0.00,0.00,0.00,0.00,'2019-02-10 09:53:43'),(226621,'1','72',225,'Sale Id shift 78944',0.00,0.00,0.00,0.00,0.00,'2019-02-10 10:00:07'),(226622,'1','72',226,'Sale Id shift 78944',0.00,83866.50,225.00,83866.50,0.00,'2019-02-10 10:00:07'),(226623,'1','72',227,'Sale Id shift 78944',0.00,0.00,0.00,0.00,0.00,'2019-02-10 10:00:07'),(226956,'1','72',225,'Sale Id shift 78945',0.00,0.00,0.00,0.00,0.00,'2019-02-11 09:11:41'),(226957,'1','72',226,'Sale Id shift 78945',0.00,146448.00,225.00,146448.00,0.00,'2019-02-11 09:11:41'),(226958,'1','72',227,'Sale Id shift 78945',0.00,0.00,0.00,0.00,0.00,'2019-02-11 09:11:41'),(227442,'1','72',225,'Sale Id shift 79065',0.00,0.00,0.00,0.00,0.00,'2019-02-12 11:29:54'),(227443,'1','72',226,'Sale Id shift 79065',0.00,45690.75,225.00,45690.75,0.00,'2019-02-12 11:29:54'),(227444,'1','72',227,'Sale Id shift 79065',0.00,0.00,0.00,0.00,0.00,'2019-02-12 11:29:54'),(228095,'1','72',225,'Sale Id shift 79236',0.00,0.00,0.00,0.00,0.00,'2019-02-14 09:51:22'),(228096,'1','72',226,'Sale Id shift 79236',0.00,179255.25,225.00,179255.25,0.00,'2019-02-14 09:51:22'),(228097,'1','72',227,'Sale Id shift 79236',0.00,0.00,0.00,0.00,0.00,'2019-02-14 09:51:22'),(228108,'1','72',225,'Sale Id shift 79453',0.00,0.00,0.00,0.00,0.00,'2019-02-14 10:11:06'),(228109,'1','72',226,'Sale Id shift 79453',0.00,221681.25,225.00,221681.25,0.00,'2019-02-14 10:11:06'),(228110,'1','72',227,'Sale Id shift 79453',0.00,0.00,0.00,0.00,0.00,'2019-02-14 10:11:06'),(229498,'1','72',225,'Sale Id shift 79457',0.00,0.00,0.00,0.00,0.00,'2019-02-18 12:18:38'),(229499,'1','72',226,'Sale Id shift 79457',0.00,104172.75,225.00,104172.75,0.00,'2019-02-18 12:18:38'),(229500,'1','72',227,'Sale Id shift 79457',0.00,0.00,0.00,0.00,0.00,'2019-02-18 12:18:38'),(229504,'1','72',225,'Sale Id shift 79929',0.00,0.00,0.00,0.00,0.00,'2019-02-18 12:21:46'),(229505,'1','72',226,'Sale Id shift 79929',0.00,166891.50,225.00,166891.50,0.00,'2019-02-18 12:21:46'),(229506,'1','72',227,'Sale Id shift 79929',0.00,0.00,0.00,0.00,0.00,'2019-02-18 12:21:46'),(229507,'1','72',225,'Sale Id shift 79930',0.00,0.00,0.00,0.00,0.00,'2019-02-18 12:27:13'),(229508,'1','72',226,'Sale Id shift 79930',0.00,190514.25,225.00,190514.25,0.00,'2019-02-18 12:27:13'),(229509,'1','72',227,'Sale Id shift 79930',0.00,0.00,0.00,0.00,0.00,'2019-02-18 12:27:13'),(229510,'1','72',225,'Sale Id shift 79931',0.00,0.00,0.00,0.00,0.00,'2019-02-18 12:30:27'),(229511,'1','72',226,'Sale Id shift 79931',0.00,130432.50,225.00,130432.50,0.00,'2019-02-18 12:30:27'),(229512,'1','72',227,'Sale Id shift 79931',0.00,0.00,0.00,0.00,0.00,'2019-02-18 12:30:27'),(230099,'1','72',225,'Sale Id shift 79932',0.00,0.00,0.00,0.00,0.00,'2019-02-19 16:21:14'),(230100,'1','72',226,'Sale Id shift 79932',0.00,128112.75,225.00,128112.75,0.00,'2019-02-19 16:21:14'),(230101,'1','72',227,'Sale Id shift 79932',0.00,0.00,0.00,0.00,0.00,'2019-02-19 16:21:14'),(230391,'1','72',225,'Sale Id shift 80134',0.00,0.00,0.00,0.00,0.00,'2019-02-20 14:41:39'),(230392,'1','72',226,'Sale Id shift 80134',0.00,56641.50,225.00,56641.50,0.00,'2019-02-20 14:41:39'),(230393,'1','72',227,'Sale Id shift 80134',0.00,0.00,0.00,0.00,0.00,'2019-02-20 14:41:39'),(230809,'1','72',225,'Sale Id shift 80238',0.00,0.00,0.00,0.00,0.00,'2019-02-21 15:23:26'),(230810,'1','72',226,'Sale Id shift 80238',0.00,59584.50,225.00,59584.50,0.00,'2019-02-21 15:23:26'),(230811,'1','72',227,'Sale Id shift 80238',0.00,0.00,0.00,0.00,0.00,'2019-02-21 15:23:26'),(231080,'1','72',225,'Sale Id shift 80378',0.00,0.00,0.00,0.00,0.00,'2019-02-22 14:19:26'),(231081,'1','72',226,'Sale Id shift 80378',0.00,25717.50,225.00,25717.50,0.00,'2019-02-22 14:19:26'),(231082,'1','72',227,'Sale Id shift 80378',0.00,0.00,0.00,0.00,0.00,'2019-02-22 14:19:26'),(231928,'1','72',225,'Sale Id shift 80465',0.00,0.00,0.00,0.00,0.00,'2019-02-25 18:33:58'),(231929,'1','72',226,'Sale Id shift 80465',0.00,95949.00,225.00,95949.00,0.00,'2019-02-25 18:33:58'),(231930,'1','72',227,'Sale Id shift 80465',0.00,0.00,0.00,0.00,0.00,'2019-02-25 18:33:58'),(231931,'1','72',225,'Sale Id shift 80754',0.00,0.00,0.00,0.00,0.00,'2019-02-25 18:39:19'),(231932,'1','72',226,'Sale Id shift 80754',0.00,23478.75,225.00,23478.75,0.00,'2019-02-25 18:39:19'),(231933,'1','72',227,'Sale Id shift 80754',0.00,0.00,0.00,0.00,0.00,'2019-02-25 18:39:19'),(232223,'1','72',225,'Sale Id shift 80755',0.00,0.00,0.00,0.00,0.00,'2019-02-26 15:44:12'),(232224,'1','72',226,'Sale Id shift 80755',0.00,91179.00,225.00,91179.00,0.00,'2019-02-26 15:44:12'),(232225,'1','72',227,'Sale Id shift 80755',0.00,0.00,0.00,0.00,0.00,'2019-02-26 15:44:12'),(233068,'1','72',225,'Sale Id shift 80854',0.00,0.00,0.00,0.00,0.00,'2019-02-28 15:28:39'),(233069,'1','72',226,'Sale Id shift 80854',0.00,140679.00,225.00,140679.00,0.00,'2019-02-28 15:28:39'),(233070,'1','72',227,'Sale Id shift 80854',0.00,0.00,0.00,0.00,0.00,'2019-02-28 15:28:39'),(233077,'1','72',225,'Sale Id shift 81143',0.00,0.00,0.00,0.00,0.00,'2019-02-28 15:35:00'),(233078,'1','72',226,'Sale Id shift 81143',0.00,144483.75,225.00,144483.75,0.00,'2019-02-28 15:35:00'),(233079,'1','72',227,'Sale Id shift 81143',0.00,0.00,0.00,0.00,0.00,'2019-02-28 15:35:00'),(233394,'1','72',225,'Sale Id shift 81145',0.00,0.00,0.00,0.00,0.00,'2019-03-01 15:25:48'),(233395,'1','72',226,'Sale Id shift 81145',0.00,21701.25,225.00,21701.25,0.00,'2019-03-01 15:25:48'),(233396,'1','72',227,'Sale Id shift 81145',0.00,0.00,0.00,0.00,0.00,'2019-03-01 15:25:48'),(233550,'1','72',225,'Sale Id shift 81254',0.00,0.00,0.00,0.00,0.00,'2019-03-02 10:52:33'),(233551,'1','72',226,'Sale Id shift 81254',0.00,31401.00,225.00,31401.00,0.00,'2019-03-02 10:52:33'),(233552,'1','72',227,'Sale Id shift 81254',0.00,0.00,0.00,0.00,0.00,'2019-03-02 10:52:33'),(234079,'1','72',225,'Sale Id shift 81306',0.00,0.00,0.00,0.00,0.00,'2019-03-04 08:11:24'),(234080,'1','72',226,'Sale Id shift 81306',0.00,56173.50,225.00,56173.50,0.00,'2019-03-04 08:11:24'),(234081,'1','72',227,'Sale Id shift 81306',0.00,0.00,0.00,0.00,0.00,'2019-03-04 08:11:24'),(234085,'1','72',225,'Sale Id shift 81484',0.00,0.00,0.00,0.00,0.00,'2019-03-04 08:17:11'),(234086,'1','72',226,'Sale Id shift 81484',0.00,121209.75,225.00,121209.75,0.00,'2019-03-04 08:17:11'),(234087,'1','72',227,'Sale Id shift 81484',0.00,0.00,0.00,0.00,0.00,'2019-03-04 08:17:11'),(234500,'1','72',225,'Sale Id shift 81486',0.00,0.00,0.00,0.00,0.00,'2019-03-05 08:26:25'),(234501,'1','72',226,'Sale Id shift 81486',0.00,62300.25,225.00,62300.25,0.00,'2019-03-05 08:26:25'),(234502,'1','72',227,'Sale Id shift 81486',0.00,0.00,0.00,0.00,0.00,'2019-03-05 08:26:25'),(236918,'1','72',225,'Sale Id shift 82447',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:30:16'),(236919,'1','72',226,'Sale Id shift 82447',0.00,165055.50,225.00,165055.50,0.00,'2019-03-12 16:30:16'),(236920,'1','72',227,'Sale Id shift 82447',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:30:16'),(236927,'1','72',225,'Sale Id shift 82452',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:33:37'),(236928,'1','72',226,'Sale Id shift 82452',0.00,73658.25,225.00,73658.25,0.00,'2019-03-12 16:33:37'),(236929,'1','72',227,'Sale Id shift 82452',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:33:37'),(236933,'1','72',225,'Sale Id shift 82454',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:37:36'),(236934,'1','72',226,'Sale Id shift 82454',0.00,77550.75,225.00,77550.75,0.00,'2019-03-12 16:37:36'),(236935,'1','72',227,'Sale Id shift 82454',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:37:36'),(236936,'1','72',225,'Sale Id shift 82457',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:42:43'),(236937,'1','72',226,'Sale Id shift 82457',0.00,12512.25,225.00,12512.25,0.00,'2019-03-12 16:42:43'),(236938,'1','72',227,'Sale Id shift 82457',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:42:43'),(236945,'1','72',225,'Sale Id shift 82459',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:46:24'),(236946,'1','72',226,'Sale Id shift 82459',0.00,94272.75,225.00,94272.75,0.00,'2019-03-12 16:46:24'),(236947,'1','72',227,'Sale Id shift 82459',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:46:24'),(236948,'1','72',225,'Sale Id shift 82461',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:50:13'),(236949,'1','72',226,'Sale Id shift 82461',0.00,171294.75,225.00,171294.75,0.00,'2019-03-12 16:50:13'),(236950,'1','72',227,'Sale Id shift 82461',0.00,0.00,0.00,0.00,0.00,'2019-03-12 16:50:13'),(237249,'1','72',225,'Sale Id shift 82462',0.00,0.00,0.00,0.00,0.00,'2019-03-13 15:01:50'),(237250,'1','72',226,'Sale Id shift 82462',0.00,147998.25,225.00,147998.25,0.00,'2019-03-13 15:01:50'),(237251,'1','72',227,'Sale Id shift 82462',0.00,0.00,0.00,0.00,0.00,'2019-03-13 15:01:50'),(237634,'1','72',225,'Sale Id shift 82564',0.00,0.00,0.00,0.00,0.00,'2019-03-14 16:12:48'),(237635,'1','72',226,'Sale Id shift 82564',0.00,49324.50,225.00,49324.50,0.00,'2019-03-14 16:12:48'),(237636,'1','72',227,'Sale Id shift 82564',0.00,0.00,0.00,0.00,0.00,'2019-03-14 16:12:48'),(238145,'1','72',225,'Sale Id shift 82700',0.00,0.00,0.00,0.00,0.00,'2019-03-16 11:36:47'),(238146,'1','72',226,'Sale Id shift 82700',0.00,24662.25,225.00,24662.25,0.00,'2019-03-16 11:36:47'),(238147,'1','72',227,'Sale Id shift 82700',0.00,0.00,0.00,0.00,0.00,'2019-03-16 11:36:47'),(238151,'1','72',225,'Sale Id shift 82876',0.00,0.00,0.00,0.00,0.00,'2019-03-16 11:39:37'),(238152,'1','72',226,'Sale Id shift 82876',0.00,50841.00,225.00,50841.00,0.00,'2019-03-16 11:39:37'),(238153,'1','72',227,'Sale Id shift 82876',0.00,0.00,0.00,0.00,0.00,'2019-03-16 11:39:37'),(238864,'1','72',225,'Sale Id shift 82878',0.00,0.00,0.00,0.00,0.00,'2019-03-18 12:21:04'),(238865,'1','72',226,'Sale Id shift 82878',0.00,115485.75,225.00,115485.75,0.00,'2019-03-18 12:21:04'),(238866,'1','72',227,'Sale Id shift 82878',0.00,0.00,0.00,0.00,0.00,'2019-03-18 12:21:04'),(239068,'1','72',225,'Sale Id shift 83188',0.00,0.00,0.00,0.00,0.00,'2019-03-19 09:26:33'),(239069,'1','72',226,'Sale Id shift 83188',0.00,36609.75,225.00,36609.75,0.00,'2019-03-19 09:26:33'),(239070,'1','72',227,'Sale Id shift 83188',0.00,0.00,0.00,0.00,0.00,'2019-03-19 09:26:33'),(239071,'1','72',225,'Sale Id shift 83190',0.00,0.00,0.00,0.00,0.00,'2019-03-19 09:29:03'),(239072,'1','72',226,'Sale Id shift 83190',0.00,51945.75,225.00,51945.75,0.00,'2019-03-19 09:29:03'),(239073,'1','72',227,'Sale Id shift 83190',0.00,0.00,0.00,0.00,0.00,'2019-03-19 09:29:03'),(239724,'1','72',225,'Sale Id shift 83192',0.00,0.00,0.00,0.00,0.00,'2019-03-20 14:54:12'),(239725,'1','72',226,'Sale Id shift 83192',0.00,73251.00,225.00,73251.00,0.00,'2019-03-20 14:54:12'),(239726,'1','72',227,'Sale Id shift 83192',0.00,0.00,0.00,0.00,0.00,'2019-03-20 14:54:12'),(240230,'1','72',225,'Sale Id shift 83415',0.00,0.00,0.00,0.00,0.00,'2019-03-22 09:24:54'),(240231,'1','72',226,'Sale Id shift 83415',0.00,22900.50,225.00,22900.50,0.00,'2019-03-22 09:24:54'),(240232,'1','72',227,'Sale Id shift 83415',0.00,0.00,0.00,0.00,0.00,'2019-03-22 09:24:54'),(240233,'1','72',225,'Sale Id shift 83580',0.00,0.00,0.00,0.00,0.00,'2019-03-22 09:28:20'),(240234,'1','72',226,'Sale Id shift 83580',0.00,29180.25,225.00,29180.25,0.00,'2019-03-22 09:28:20'),(240235,'1','72',227,'Sale Id shift 83580',0.00,0.00,0.00,0.00,0.00,'2019-03-22 09:28:20'),(241973,'1','72',225,'Sale Id shift 83581',0.00,0.00,0.00,0.00,0.00,'2019-03-27 10:57:31'),(241974,'1','72',226,'Sale Id shift 83581',0.00,14748.75,225.00,14748.75,0.00,'2019-03-27 10:57:31'),(241975,'1','72',227,'Sale Id shift 83581',0.00,0.00,0.00,0.00,0.00,'2019-03-27 10:57:31'),(241976,'1','72',225,'Sale Id shift 84187',0.00,0.00,0.00,0.00,0.00,'2019-03-27 11:01:39'),(241977,'1','72',226,'Sale Id shift 84187',0.00,21501.00,225.00,21501.00,0.00,'2019-03-27 11:01:39'),(241978,'1','72',227,'Sale Id shift 84187',0.00,0.00,0.00,0.00,0.00,'2019-03-27 11:01:39'),(241982,'1','72',225,'Sale Id shift 84188',0.00,0.00,0.00,0.00,0.00,'2019-03-27 11:09:36'),(241983,'1','72',226,'Sale Id shift 84188',0.00,39658.50,225.00,39658.50,0.00,'2019-03-27 11:09:36'),(241984,'1','72',227,'Sale Id shift 84188',0.00,0.00,0.00,0.00,0.00,'2019-03-27 11:09:36'),(241994,'1','72',225,'Sale Id shift 84190',0.00,0.00,0.00,0.00,0.00,'2019-03-27 11:13:23'),(241995,'1','72',226,'Sale Id shift 84190',0.00,22050.00,225.00,22050.00,0.00,'2019-03-27 11:13:23'),(241996,'1','72',227,'Sale Id shift 84190',0.00,0.00,0.00,0.00,0.00,'2019-03-27 11:13:23'),(241997,'1','72',225,'Sale Id shift 84192',0.00,0.00,0.00,0.00,0.00,'2019-03-27 11:16:10'),(241998,'1','72',226,'Sale Id shift 84192',0.00,15399.00,225.00,15399.00,0.00,'2019-03-27 11:16:10'),(241999,'1','72',227,'Sale Id shift 84192',0.00,0.00,0.00,0.00,0.00,'2019-03-27 11:16:10'),(242565,'1','72',225,'Sale Id shift 84193',0.00,0.00,0.00,0.00,0.00,'2019-03-28 14:33:25'),(242566,'1','72',226,'Sale Id shift 84193',0.00,55750.50,225.00,55750.50,0.00,'2019-03-28 14:33:25'),(242567,'1','72',227,'Sale Id shift 84193',0.00,0.00,0.00,0.00,0.00,'2019-03-28 14:33:25'),(242871,'1','72',225,'Sale Id shift 84394',0.00,0.00,0.00,0.00,0.00,'2019-03-29 14:13:18'),(242872,'1','72',226,'Sale Id shift 84394',0.00,20949.75,225.00,20949.75,0.00,'2019-03-29 14:13:18'),(242873,'1','72',227,'Sale Id shift 84394',0.00,0.00,0.00,0.00,0.00,'2019-03-29 14:13:18'),(243785,'1','72',225,'Sale Id shift 84496',0.00,0.00,0.00,0.00,0.00,'2019-04-01 09:11:24'),(243786,'1','72',226,'Sale Id shift 84496',0.00,15300.00,225.00,15300.00,0.00,'2019-04-01 09:11:24'),(243787,'1','72',227,'Sale Id shift 84496',0.00,0.00,0.00,0.00,0.00,'2019-04-01 09:11:24'),(243794,'1','72',225,'Sale Id shift 84808',0.00,0.00,0.00,0.00,0.00,'2019-04-01 09:22:17'),(243795,'1','72',226,'Sale Id shift 84808',0.00,100350.00,225.00,100350.00,0.00,'2019-04-01 09:22:17'),(243796,'1','72',227,'Sale Id shift 84808',0.00,0.00,0.00,0.00,0.00,'2019-04-01 09:22:17'),(243800,'1','72',225,'Sale Id shift 84809',0.00,0.00,0.00,0.00,0.00,'2019-04-01 09:26:34'),(243801,'1','72',226,'Sale Id shift 84809',0.00,13997.25,225.00,13997.25,0.00,'2019-04-01 09:26:34'),(243802,'1','72',227,'Sale Id shift 84809',0.00,0.00,0.00,0.00,0.00,'2019-04-01 09:26:34'),(244102,'1','72',225,'Sale Id shift 84812',0.00,0.00,0.00,0.00,0.00,'2019-04-02 08:10:49'),(244103,'1','72',226,'Sale Id shift 84812',0.00,34195.50,225.00,34195.50,0.00,'2019-04-02 08:10:49'),(244104,'1','72',227,'Sale Id shift 84812',0.00,0.00,0.00,0.00,0.00,'2019-04-02 08:10:49'),(244774,'1','72',225,'Sale Id shift 84908',0.00,0.00,0.00,0.00,0.00,'2019-04-04 08:09:47'),(244775,'1','72',226,'Sale Id shift 84908',0.00,7499.25,225.00,7499.25,0.00,'2019-04-04 08:09:47'),(244776,'1','72',227,'Sale Id shift 84908',0.00,0.00,0.00,0.00,0.00,'2019-04-04 08:09:47'),(244780,'1','72',225,'Sale Id shift 85145',0.00,0.00,0.00,0.00,0.00,'2019-04-04 08:13:46'),(244781,'1','72',226,'Sale Id shift 85145',0.00,23199.75,225.00,23199.75,0.00,'2019-04-04 08:13:46'),(244782,'1','72',227,'Sale Id shift 85145',0.00,0.00,0.00,0.00,0.00,'2019-04-04 08:13:46'),(245160,'1','72',225,'Sale Id shift 85147',0.00,0.00,0.00,0.00,0.00,'2019-04-05 09:07:29'),(245161,'1','72',226,'Sale Id shift 85147',0.00,35352.00,225.00,35352.00,0.00,'2019-04-05 09:07:29'),(245162,'1','72',227,'Sale Id shift 85147',0.00,0.00,0.00,0.00,0.00,'2019-04-05 09:07:29'),(246761,'1','72',225,'Sale Id shift 85271',0.00,0.00,0.00,0.00,0.00,'2019-04-09 14:22:49'),(246762,'1','72',226,'Sale Id shift 85271',0.00,22002.75,225.00,22002.75,0.00,'2019-04-09 14:22:49'),(246763,'1','72',227,'Sale Id shift 85271',0.00,0.00,0.00,0.00,0.00,'2019-04-09 14:22:49'),(246767,'1','72',225,'Sale Id shift 85841',0.00,0.00,0.00,0.00,0.00,'2019-04-09 14:26:39'),(246768,'1','72',226,'Sale Id shift 85841',0.00,203213.25,225.00,203213.25,0.00,'2019-04-09 14:26:39'),(246769,'1','72',227,'Sale Id shift 85841',0.00,0.00,0.00,0.00,0.00,'2019-04-09 14:26:39'),(246770,'1','72',225,'Sale Id shift 85842',0.00,0.00,0.00,0.00,0.00,'2019-04-09 14:29:35'),(246771,'1','72',226,'Sale Id shift 85842',0.00,9702.00,225.00,9702.00,0.00,'2019-04-09 14:29:35'),(246772,'1','72',227,'Sale Id shift 85842',0.00,0.00,0.00,0.00,0.00,'2019-04-09 14:29:35'),(246776,'1','72',225,'Sale Id shift 85843',0.00,0.00,0.00,0.00,0.00,'2019-04-09 14:34:11'),(246777,'1','72',226,'Sale Id shift 85843',0.00,15500.25,225.00,15500.25,0.00,'2019-04-09 14:34:11'),(246778,'1','72',227,'Sale Id shift 85843',0.00,0.00,0.00,0.00,0.00,'2019-04-09 14:34:11'),(247044,'1','72',225,'Sale Id shift 85847',0.00,0.00,0.00,0.00,0.00,'2019-04-10 12:07:42'),(247045,'1','72',226,'Sale Id shift 85847',0.00,7998.75,225.00,7998.75,0.00,'2019-04-10 12:07:42'),(247046,'1','72',227,'Sale Id shift 85847',0.00,0.00,0.00,0.00,0.00,'2019-04-10 12:07:42'),(247492,'1','72',225,'Sale Id shift 85940',0.00,0.00,0.00,0.00,0.00,'2019-04-11 14:26:28'),(247493,'1','72',226,'Sale Id shift 85940',0.00,63094.50,225.00,63094.50,0.00,'2019-04-11 14:26:28'),(247494,'1','72',227,'Sale Id shift 85940',0.00,0.00,0.00,0.00,0.00,'2019-04-11 14:26:28'),(248907,'1','72',225,'Sale Id shift 86103',0.00,0.00,0.00,0.00,0.00,'2019-04-15 14:53:16'),(248908,'1','72',226,'Sale Id shift 86103',0.00,114050.25,225.00,114050.25,0.00,'2019-04-15 14:53:16'),(248909,'1','72',227,'Sale Id shift 86103',0.00,0.00,0.00,0.00,0.00,'2019-04-15 14:53:16'),(248916,'1','72',225,'Sale Id shift 86601',0.00,0.00,0.00,0.00,0.00,'2019-04-15 14:55:44'),(248917,'1','72',226,'Sale Id shift 86601',0.00,41955.75,225.00,41955.75,0.00,'2019-04-15 14:55:44'),(248918,'1','72',227,'Sale Id shift 86601',0.00,0.00,0.00,0.00,0.00,'2019-04-15 14:55:44'),(248928,'1','72',225,'Sale Id shift 86605',0.00,0.00,0.00,0.00,0.00,'2019-04-15 15:01:17'),(248929,'1','72',226,'Sale Id shift 86605',0.00,28750.50,225.00,28750.50,0.00,'2019-04-15 15:01:17'),(248930,'1','72',227,'Sale Id shift 86605',0.00,0.00,0.00,0.00,0.00,'2019-04-15 15:01:17'),(248937,'1','72',225,'Sale Id shift 86608',0.00,0.00,0.00,0.00,0.00,'2019-04-15 15:04:12'),(248938,'1','72',226,'Sale Id shift 86608',0.00,10759.50,225.00,10759.50,0.00,'2019-04-15 15:04:12'),(248939,'1','72',227,'Sale Id shift 86608',0.00,0.00,0.00,0.00,0.00,'2019-04-15 15:04:12'),(249427,'1','72',225,'Sale Id shift 86612',0.00,0.00,0.00,0.00,0.00,'2019-04-16 17:37:08'),(249428,'1','72',226,'Sale Id shift 86612',0.00,11101.50,225.00,11101.50,0.00,'2019-04-16 17:37:08'),(249429,'1','72',227,'Sale Id shift 86612',0.00,0.00,0.00,0.00,0.00,'2019-04-16 17:37:08'),(249643,'1','72',225,'Sale Id shift 86783',0.00,0.00,0.00,0.00,0.00,'2019-04-17 13:09:04'),(249644,'1','72',226,'Sale Id shift 86783',0.00,87750.00,225.00,87750.00,0.00,'2019-04-17 13:09:04'),(249645,'1','72',227,'Sale Id shift 86783',0.00,0.00,0.00,0.00,0.00,'2019-04-17 13:09:04'),(249947,'1','72',225,'Sale Id shift 86859',0.00,0.00,0.00,0.00,0.00,'2019-04-18 11:32:55'),(249948,'1','72',226,'Sale Id shift 86859',0.00,129330.00,225.00,129330.00,0.00,'2019-04-18 11:32:55'),(249949,'1','72',227,'Sale Id shift 86859',0.00,0.00,0.00,0.00,0.00,'2019-04-18 11:32:55'),(251816,'1','72',225,'Sale Id shift 86964',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:39:48'),(251817,'1','72',226,'Sale Id shift 86964',0.00,316950.75,225.00,316950.75,0.00,'2019-04-23 16:39:48'),(251818,'1','72',227,'Sale Id shift 86964',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:39:48'),(251819,'1','72',225,'Sale Id shift 87608',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:44:31'),(251820,'1','72',226,'Sale Id shift 87608',0.00,11972.25,225.00,11972.25,0.00,'2019-04-23 16:44:31'),(251821,'1','72',227,'Sale Id shift 87608',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:44:31'),(251822,'1','72',225,'Sale Id shift 87609',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:47:06'),(251823,'1','72',226,'Sale Id shift 87609',0.00,11601.00,225.00,11601.00,0.00,'2019-04-23 16:47:06'),(251824,'1','72',227,'Sale Id shift 87609',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:47:06'),(251825,'1','72',225,'Sale Id shift 87610',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:49:59'),(251826,'1','72',226,'Sale Id shift 87610',0.00,92452.50,225.00,92452.50,0.00,'2019-04-23 16:49:59'),(251827,'1','72',227,'Sale Id shift 87610',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:49:59'),(251831,'1','72',225,'Sale Id shift 87611',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:53:09'),(251832,'1','72',226,'Sale Id shift 87611',0.00,15282.00,225.00,15282.00,0.00,'2019-04-23 16:53:09'),(251833,'1','72',227,'Sale Id shift 87611',0.00,0.00,0.00,0.00,0.00,'2019-04-23 16:53:09'),(252084,'1','72',225,'Sale Id shift 87613',0.00,0.00,0.00,0.00,0.00,'2019-04-24 13:20:29'),(252085,'1','72',226,'Sale Id shift 87613',0.00,11400.75,225.00,11400.75,0.00,'2019-04-24 13:20:29'),(252086,'1','72',227,'Sale Id shift 87613',0.00,0.00,0.00,0.00,0.00,'2019-04-24 13:20:29'),(252602,'1','72',225,'Sale Id shift 87698',0.00,0.00,0.00,0.00,0.00,'2019-04-25 16:25:20'),(252603,'1','72',226,'Sale Id shift 87698',0.00,107151.75,225.00,107151.75,0.00,'2019-04-25 16:25:20'),(252604,'1','72',227,'Sale Id shift 87698',0.00,0.00,0.00,0.00,0.00,'2019-04-25 16:25:20'),(253819,'1','72',225,'Sale Id shift 87879',0.00,0.00,0.00,0.00,0.00,'2019-04-29 10:06:21'),(253820,'1','72',226,'Sale Id shift 87879',0.00,38281.50,225.00,38281.50,0.00,'2019-04-29 10:06:21'),(253821,'1','72',227,'Sale Id shift 87879',0.00,0.00,0.00,0.00,0.00,'2019-04-29 10:06:21'),(253825,'1','72',225,'Sale Id shift 88299',0.00,0.00,0.00,0.00,0.00,'2019-04-29 10:09:06'),(253826,'1','72',226,'Sale Id shift 88299',0.00,23501.25,225.00,23501.25,0.00,'2019-04-29 10:09:06'),(253827,'1','72',227,'Sale Id shift 88299',0.00,0.00,0.00,0.00,0.00,'2019-04-29 10:09:06'),(253828,'1','72',225,'Sale Id shift 88301',0.00,0.00,0.00,0.00,0.00,'2019-04-29 10:12:24'),(253829,'1','72',226,'Sale Id shift 88301',0.00,68199.75,225.00,68199.75,0.00,'2019-04-29 10:12:24'),(253830,'1','72',227,'Sale Id shift 88301',0.00,0.00,0.00,0.00,0.00,'2019-04-29 10:12:24'),(253834,'1','72',225,'Sale Id shift 88303',0.00,0.00,0.00,0.00,0.00,'2019-04-29 10:16:24'),(253835,'1','72',226,'Sale Id shift 88303',0.00,48249.00,225.00,48249.00,0.00,'2019-04-29 10:16:24'),(253836,'1','72',227,'Sale Id shift 88303',0.00,0.00,0.00,0.00,0.00,'2019-04-29 10:16:24'),(255074,'1','72',225,'Sale Id shift 88305',0.00,0.00,0.00,0.00,0.00,'2019-05-02 13:28:26'),(255075,'1','72',226,'Sale Id shift 88305',0.00,32809.50,225.00,32809.50,0.00,'2019-05-02 13:28:26'),(255076,'1','72',227,'Sale Id shift 88305',0.00,0.00,0.00,0.00,0.00,'2019-05-02 13:28:26'),(255080,'1','72',225,'Sale Id shift 88733',0.00,0.00,0.00,0.00,0.00,'2019-05-02 13:33:45'),(255081,'1','72',226,'Sale Id shift 88733',0.00,12748.50,225.00,12748.50,0.00,'2019-05-02 13:33:45'),(255082,'1','72',227,'Sale Id shift 88733',0.00,0.00,0.00,0.00,0.00,'2019-05-02 13:33:45'),(255098,'1','72',225,'Sale Id shift 88738',0.00,0.00,0.00,0.00,0.00,'2019-05-02 13:50:01'),(255099,'1','72',226,'Sale Id shift 88738',0.00,177810.75,225.00,177810.75,0.00,'2019-05-02 13:50:01'),(255100,'1','72',227,'Sale Id shift 88738',0.00,0.00,0.00,0.00,0.00,'2019-05-02 13:50:01'),(256969,'1','72',225,'Sale Id shift 88741',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:26:09'),(256970,'1','72',226,'Sale Id shift 88741',0.00,247968.00,225.00,247968.00,0.00,'2019-05-07 15:26:09'),(256971,'1','72',227,'Sale Id shift 88741',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:26:09'),(256978,'1','72',225,'Sale Id shift 89399',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:33:25'),(256979,'1','72',226,'Sale Id shift 89399',0.00,113420.25,225.00,113420.25,0.00,'2019-05-07 15:33:25'),(256980,'1','72',227,'Sale Id shift 89399',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:33:25'),(256987,'1','72',225,'Sale Id shift 89401',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:36:27'),(256988,'1','72',226,'Sale Id shift 89401',0.00,23697.00,225.00,23697.00,0.00,'2019-05-07 15:36:27'),(256989,'1','72',227,'Sale Id shift 89401',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:36:27'),(256990,'1','72',225,'Sale Id shift 89405',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:41:29'),(256991,'1','72',226,'Sale Id shift 89405',0.00,33750.00,225.00,33750.00,0.00,'2019-05-07 15:41:29'),(256992,'1','72',227,'Sale Id shift 89405',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:41:29'),(256993,'1','72',225,'Sale Id shift 89406',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:45:14'),(256994,'1','72',226,'Sale Id shift 89406',0.00,27499.50,225.00,27499.50,0.00,'2019-05-07 15:45:14'),(256995,'1','72',227,'Sale Id shift 89406',0.00,0.00,0.00,0.00,0.00,'2019-05-07 15:45:14'),(257162,'1','72',225,'Sale Id shift 89407',0.00,0.00,0.00,0.00,0.00,'2019-05-08 10:55:34'),(257163,'1','72',226,'Sale Id shift 89407',0.00,10894.50,225.00,10894.50,0.00,'2019-05-08 10:55:34'),(257164,'1','72',227,'Sale Id shift 89407',0.00,0.00,0.00,0.00,0.00,'2019-05-08 10:55:34'),(258987,'1','72',225,'Sale Id shift 89471',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:21:38'),(258988,'1','72',226,'Sale Id shift 89471',0.00,7798.50,225.00,7798.50,0.00,'2019-05-13 13:21:38'),(258989,'1','72',227,'Sale Id shift 89471',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:21:38'),(258996,'1','72',225,'Sale Id shift 90102',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:25:39'),(258997,'1','72',226,'Sale Id shift 90102',0.00,200715.75,225.00,200715.75,0.00,'2019-05-13 13:25:39'),(258998,'1','72',227,'Sale Id shift 90102',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:25:39'),(259005,'1','72',225,'Sale Id shift 90104',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:28:31'),(259006,'1','72',226,'Sale Id shift 90104',0.00,33464.25,225.00,33464.25,0.00,'2019-05-13 13:28:31'),(259007,'1','72',227,'Sale Id shift 90104',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:28:31'),(259011,'1','72',225,'Sale Id shift 90105',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:31:24'),(259012,'1','72',226,'Sale Id shift 90105',0.00,116914.50,225.00,116914.50,0.00,'2019-05-13 13:31:24'),(259013,'1','72',227,'Sale Id shift 90105',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:31:24'),(259017,'1','72',225,'Sale Id shift 90108',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:34:32'),(259018,'1','72',226,'Sale Id shift 90108',0.00,22500.00,225.00,22500.00,0.00,'2019-05-13 13:34:32'),(259019,'1','72',227,'Sale Id shift 90108',0.00,0.00,0.00,0.00,0.00,'2019-05-13 13:34:32'),(259592,'1','72',225,'Sale Id shift 90111',0.00,0.00,0.00,0.00,0.00,'2019-05-14 16:16:38'),(259593,'1','72',226,'Sale Id shift 90111',0.00,17448.75,225.00,17448.75,0.00,'2019-05-14 16:16:38'),(259594,'1','72',227,'Sale Id shift 90111',0.00,0.00,0.00,0.00,0.00,'2019-05-14 16:16:38'),(259863,'1','72',225,'Sale Id shift 90307',0.00,0.00,0.00,0.00,0.00,'2019-05-15 14:15:17'),(259864,'1','72',226,'Sale Id shift 90307',0.00,21957.75,225.00,21957.75,0.00,'2019-05-15 14:15:17'),(259865,'1','72',227,'Sale Id shift 90307',0.00,0.00,0.00,0.00,0.00,'2019-05-15 14:15:17'),(260312,'1','72',225,'Sale Id shift 90401',0.00,0.00,0.00,0.00,0.00,'2019-05-16 16:00:01'),(260313,'1','72',226,'Sale Id shift 90401',0.00,45483.75,225.00,45483.75,0.00,'2019-05-16 16:00:01'),(260314,'1','72',227,'Sale Id shift 90401',0.00,0.00,0.00,0.00,0.00,'2019-05-16 16:00:01'),(260444,'1','72',225,'Sale Id shift 90554',0.00,0.00,0.00,0.00,0.00,'2019-05-17 10:01:00'),(260445,'1','72',226,'Sale Id shift 90554',0.00,96999.75,225.00,96999.75,0.00,'2019-05-17 10:01:00'),(260446,'1','72',227,'Sale Id shift 90554',0.00,0.00,0.00,0.00,0.00,'2019-05-17 10:01:00'),(261976,'1','72',225,'Sale Id shift 90596',0.00,0.00,0.00,0.00,0.00,'2019-05-21 12:09:14'),(261977,'1','72',226,'Sale Id shift 90596',0.00,133049.25,225.00,133049.25,0.00,'2019-05-21 12:09:14'),(261978,'1','72',227,'Sale Id shift 90596',0.00,0.00,0.00,0.00,0.00,'2019-05-21 12:09:14'),(261982,'1','72',225,'Sale Id shift 91136',0.00,0.00,0.00,0.00,0.00,'2019-05-21 12:12:14'),(261983,'1','72',226,'Sale Id shift 91136',0.00,114916.50,225.00,114916.50,0.00,'2019-05-21 12:12:14'),(261984,'1','72',227,'Sale Id shift 91136',0.00,0.00,0.00,0.00,0.00,'2019-05-21 12:12:14'),(261988,'1','72',225,'Sale Id shift 91139',0.00,0.00,0.00,0.00,0.00,'2019-05-21 12:16:17'),(261989,'1','72',226,'Sale Id shift 91139',0.00,36477.00,225.00,36477.00,0.00,'2019-05-21 12:16:17'),(261990,'1','72',227,'Sale Id shift 91139',0.00,0.00,0.00,0.00,0.00,'2019-05-21 12:16:17'),(261997,'1','72',225,'Sale Id shift 91140',0.00,0.00,0.00,0.00,0.00,'2019-05-21 12:19:23'),(261998,'1','72',226,'Sale Id shift 91140',0.00,20504.25,225.00,20504.25,0.00,'2019-05-21 12:19:23'),(261999,'1','72',227,'Sale Id shift 91140',0.00,0.00,0.00,0.00,0.00,'2019-05-21 12:19:23'),(262443,'1','72',225,'Sale Id shift 91142',0.00,0.00,0.00,0.00,0.00,'2019-05-22 14:18:52'),(262444,'1','72',226,'Sale Id shift 91142',0.00,96075.00,225.00,96075.00,0.00,'2019-05-22 14:18:52'),(262445,'1','72',227,'Sale Id shift 91142',0.00,0.00,0.00,0.00,0.00,'2019-05-22 14:18:52'),(262696,'1','72',225,'Sale Id shift 91295',0.00,0.00,0.00,0.00,0.00,'2019-05-23 11:54:09'),(262697,'1','72',226,'Sale Id shift 91295',0.00,170460.00,225.00,170460.00,0.00,'2019-05-23 11:54:09'),(262698,'1','72',227,'Sale Id shift 91295',0.00,0.00,0.00,0.00,0.00,'2019-05-23 11:54:09'),(263198,'1','72',225,'Sale Id shift 91381',0.00,0.00,0.00,0.00,0.00,'2019-05-24 16:39:59'),(263199,'1','72',226,'Sale Id shift 91381',0.00,358251.75,225.00,358251.75,0.00,'2019-05-24 16:39:59'),(263200,'1','72',227,'Sale Id shift 91381',0.00,0.00,0.00,0.00,0.00,'2019-05-24 16:39:59'),(264489,'1','72',225,'Sale Id shift 91551',0.00,0.00,0.00,0.00,0.00,'2019-05-28 12:08:44'),(264490,'1','72',226,'Sale Id shift 91551',0.00,74052.00,225.00,74052.00,0.00,'2019-05-28 12:08:44'),(264491,'1','72',227,'Sale Id shift 91551',0.00,0.00,0.00,0.00,0.00,'2019-05-28 12:08:44'),(264495,'1','72',225,'Sale Id shift 91979',0.00,0.00,0.00,0.00,0.00,'2019-05-28 12:15:31'),(264496,'1','72',226,'Sale Id shift 91979',0.00,136694.25,225.00,136694.25,0.00,'2019-05-28 12:15:31'),(264497,'1','72',227,'Sale Id shift 91979',0.00,0.00,0.00,0.00,0.00,'2019-05-28 12:15:31'),(264501,'1','72',225,'Sale Id shift 91981',0.00,0.00,0.00,0.00,0.00,'2019-05-28 12:20:39'),(264502,'1','72',226,'Sale Id shift 91981',0.00,20853.00,225.00,20853.00,0.00,'2019-05-28 12:20:39'),(264503,'1','72',227,'Sale Id shift 91981',0.00,0.00,0.00,0.00,0.00,'2019-05-28 12:20:39'),(264507,'1','72',225,'Sale Id shift 91985',0.00,0.00,0.00,0.00,0.00,'2019-05-28 12:28:23'),(264508,'1','72',226,'Sale Id shift 91985',0.00,222657.75,225.00,222657.75,0.00,'2019-05-28 12:28:23'),(264509,'1','72',227,'Sale Id shift 91985',0.00,0.00,0.00,0.00,0.00,'2019-05-28 12:28:23'),(268736,'1','72',225,'Sale Id shift 91986',0.00,0.00,0.00,0.00,0.00,'2019-06-10 15:17:03'),(268737,'1','72',226,'Sale Id shift 91986',0.00,37086.75,225.00,37086.75,0.00,'2019-06-10 15:17:03'),(268738,'1','72',227,'Sale Id shift 91986',0.00,0.00,0.00,0.00,0.00,'2019-06-10 15:17:03'),(268745,'1','72',225,'Sale Id shift 93440',0.00,0.00,0.00,0.00,0.00,'2019-06-10 15:22:01'),(268746,'1','72',226,'Sale Id shift 93440',0.00,10305.00,225.00,10305.00,0.00,'2019-06-10 15:22:01'),(268747,'1','72',227,'Sale Id shift 93440',0.00,0.00,0.00,0.00,0.00,'2019-06-10 15:22:01'),(269135,'1','72',225,'Sale Id shift 93573',0.00,0.00,0.00,0.00,0.00,'2019-06-11 12:44:30'),(269136,'1','72',226,'Sale Id shift 93573',0.00,31500.00,225.00,31500.00,0.00,'2019-06-11 12:44:30'),(269137,'1','72',227,'Sale Id shift 93573',0.00,0.00,0.00,0.00,0.00,'2019-06-11 12:44:30'),(269138,'1','72',225,'Sale Id shift 93574',0.00,0.00,0.00,0.00,0.00,'2019-06-11 12:48:51'),(269139,'1','72',226,'Sale Id shift 93574',0.00,11400.75,225.00,11400.75,0.00,'2019-06-11 12:48:51'),(269140,'1','72',227,'Sale Id shift 93574',0.00,0.00,0.00,0.00,0.00,'2019-06-11 12:48:51'),(269279,'1','72',225,'Sale Id shift 93576',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:08:16'),(269280,'1','72',226,'Sale Id shift 93576',0.00,109759.50,225.00,109759.50,0.00,'2019-06-11 16:08:16'),(269281,'1','72',227,'Sale Id shift 93576',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:08:16'),(269282,'1','72',225,'Sale Id shift 93621',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:11:42'),(269283,'1','72',226,'Sale Id shift 93621',0.00,33423.75,225.00,33423.75,0.00,'2019-06-11 16:11:42'),(269284,'1','72',227,'Sale Id shift 93621',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:11:42'),(269285,'1','72',225,'Sale Id shift 93622',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:14:22'),(269286,'1','72',226,'Sale Id shift 93622',0.00,11373.75,225.00,11373.75,0.00,'2019-06-11 16:14:22'),(269287,'1','72',227,'Sale Id shift 93622',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:14:22'),(269291,'1','72',225,'Sale Id shift 93623',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:25:23'),(269292,'1','72',226,'Sale Id shift 93623',0.00,0.00,225.00,0.00,0.00,'2019-06-11 16:25:23'),(269293,'1','72',227,'Sale Id shift 93623',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:25:23'),(269297,'1','72',225,'Sale Id shift 93624',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:28:38'),(269298,'1','72',226,'Sale Id shift 93624',0.00,12426.75,225.00,12426.75,0.00,'2019-06-11 16:28:38'),(269299,'1','72',227,'Sale Id shift 93624',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:28:38'),(269303,'1','72',225,'Sale Id shift 93626',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:31:59'),(269304,'1','72',226,'Sale Id shift 93626',0.00,10399.50,225.00,10399.50,0.00,'2019-06-11 16:31:59'),(269305,'1','72',227,'Sale Id shift 93626',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:31:59'),(269306,'1','72',225,'Sale Id shift 93629',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:34:29'),(269307,'1','72',226,'Sale Id shift 93629',0.00,40252.50,225.00,40252.50,0.00,'2019-06-11 16:34:29'),(269308,'1','72',227,'Sale Id shift 93629',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:34:29'),(269315,'1','72',225,'Sale Id shift 93631',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:49:11'),(269316,'1','72',226,'Sale Id shift 93631',0.00,18769.50,225.00,18769.50,0.00,'2019-06-11 16:49:11'),(269317,'1','72',227,'Sale Id shift 93631',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:49:11'),(269321,'1','72',225,'Sale Id shift 93632',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:52:01'),(269322,'1','72',226,'Sale Id shift 93632',0.00,130189.50,225.00,130189.50,0.00,'2019-06-11 16:52:01'),(269323,'1','72',227,'Sale Id shift 93632',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:52:01'),(269324,'1','72',225,'Sale Id shift 93634',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:55:40'),(269325,'1','72',226,'Sale Id shift 93634',0.00,129251.25,225.00,129251.25,0.00,'2019-06-11 16:55:40'),(269326,'1','72',227,'Sale Id shift 93634',0.00,0.00,0.00,0.00,0.00,'2019-06-11 16:55:40'),(269886,'1','72',225,'Sale Id shift 93635',0.00,0.00,0.00,0.00,0.00,'2019-06-13 09:18:42'),(269887,'1','72',226,'Sale Id shift 93635',0.00,164198.25,225.00,164198.25,0.00,'2019-06-13 09:18:42'),(269888,'1','72',227,'Sale Id shift 93635',0.00,0.00,0.00,0.00,0.00,'2019-06-13 09:18:42'),(269889,'1','72',225,'Sale Id shift 93836',0.00,0.00,0.00,0.00,0.00,'2019-06-13 09:21:08'),(269890,'1','72',226,'Sale Id shift 93836',0.00,179991.00,225.00,179991.00,0.00,'2019-06-13 09:21:08'),(269891,'1','72',227,'Sale Id shift 93836',0.00,0.00,0.00,0.00,0.00,'2019-06-13 09:21:08'),(270290,'1','72',225,'Sale Id shift 93839',0.00,0.00,0.00,0.00,0.00,'2019-06-14 10:17:50'),(270291,'1','72',226,'Sale Id shift 93839',0.00,81999.00,225.00,81999.00,0.00,'2019-06-14 10:17:50'),(270292,'1','72',227,'Sale Id shift 93839',0.00,0.00,0.00,0.00,0.00,'2019-06-14 10:17:50'),(271474,'1','72',225,'Sale Id shift 93984',0.00,0.00,0.00,0.00,0.00,'2019-06-17 16:20:14'),(271475,'1','72',226,'Sale Id shift 93984',0.00,34789.50,225.00,34789.50,0.00,'2019-06-17 16:20:14'),(271476,'1','72',227,'Sale Id shift 93984',0.00,0.00,0.00,0.00,0.00,'2019-06-17 16:20:14'),(271480,'1','72',225,'Sale Id shift 94397',0.00,0.00,0.00,0.00,0.00,'2019-06-17 16:23:54'),(271481,'1','72',226,'Sale Id shift 94397',0.00,20533.50,225.00,20533.50,0.00,'2019-06-17 16:23:54'),(271482,'1','72',227,'Sale Id shift 94397',0.00,0.00,0.00,0.00,0.00,'2019-06-17 16:23:54'),(271715,'1','72',225,'Sale Id shift 94399',0.00,0.00,0.00,0.00,0.00,'2019-06-18 11:18:43'),(271716,'1','72',226,'Sale Id shift 94399',0.00,10001.25,225.00,10001.25,0.00,'2019-06-18 11:18:43'),(271717,'1','72',227,'Sale Id shift 94399',0.00,0.00,0.00,0.00,0.00,'2019-06-18 11:18:43'),(271736,'1','72',225,'Sale Id shift 94480',0.00,0.00,0.00,0.00,0.00,'2019-06-18 11:45:21'),(271737,'1','72',226,'Sale Id shift 94480',0.00,22898.25,225.00,22898.25,0.00,'2019-06-18 11:45:21'),(271738,'1','72',227,'Sale Id shift 94480',0.00,0.00,0.00,0.00,0.00,'2019-06-18 11:45:21'),(272168,'1','72',225,'Sale Id shift 94484',0.00,0.00,0.00,0.00,0.00,'2019-06-19 14:16:41'),(272169,'1','72',226,'Sale Id shift 94484',0.00,11484.00,225.00,11484.00,0.00,'2019-06-19 14:16:41'),(272170,'1','72',227,'Sale Id shift 94484',0.00,0.00,0.00,0.00,0.00,'2019-06-19 14:16:41'),(272638,'1','72',225,'Sale Id shift 94635',0.00,0.00,0.00,0.00,0.00,'2019-06-20 21:26:12'),(272639,'1','72',226,'Sale Id shift 94635',0.00,18699.75,225.00,18699.75,0.00,'2019-06-20 21:26:12'),(272640,'1','72',227,'Sale Id shift 94635',0.00,0.00,0.00,0.00,0.00,'2019-06-20 21:26:12'),(274543,'1','72',225,'Sale Id shift 94795',0.00,0.00,0.00,0.00,0.00,'2019-06-28 11:58:11'),(274544,'1','72',226,'Sale Id shift 94795',0.00,85396.50,225.00,85396.50,0.00,'2019-06-28 11:58:11'),(274545,'1','72',227,'Sale Id shift 94795',0.00,0.00,0.00,0.00,0.00,'2019-06-28 11:58:11'),(274549,'1','72',225,'Sale Id shift 95487',0.00,0.00,0.00,0.00,0.00,'2019-06-28 12:01:08'),(274550,'1','72',226,'Sale Id shift 95487',0.00,18801.00,225.00,18801.00,0.00,'2019-06-28 12:01:08'),(274551,'1','72',227,'Sale Id shift 95487',0.00,0.00,0.00,0.00,0.00,'2019-06-28 12:01:08'),(274552,'1','72',225,'Sale Id shift 95488',0.00,0.00,0.00,0.00,0.00,'2019-06-28 12:03:36'),(274553,'1','72',226,'Sale Id shift 95488',0.00,16701.75,225.00,16701.75,0.00,'2019-06-28 12:03:36'),(274554,'1','72',227,'Sale Id shift 95488',0.00,0.00,0.00,0.00,0.00,'2019-06-28 12:03:36'),(274555,'1','72',225,'Sale Id shift 95490',0.00,0.00,0.00,0.00,0.00,'2019-06-28 12:07:00'),(274556,'1','72',226,'Sale Id shift 95490',0.00,45850.50,225.00,45850.50,0.00,'2019-06-28 12:07:00'),(274557,'1','72',227,'Sale Id shift 95490',0.00,0.00,0.00,0.00,0.00,'2019-06-28 12:07:00'),(274864,'1','72',225,'Sale Id shift 95491',0.00,0.00,0.00,0.00,0.00,'2019-06-29 10:21:26'),(274865,'1','72',226,'Sale Id shift 95491',0.00,37325.25,225.00,37325.25,0.00,'2019-06-29 10:21:26'),(274866,'1','72',227,'Sale Id shift 95491',0.00,0.00,0.00,0.00,0.00,'2019-06-29 10:21:26'),(274870,'1','72',225,'Sale Id shift 95598',0.00,0.00,0.00,0.00,0.00,'2019-06-29 10:26:31'),(274871,'1','72',226,'Sale Id shift 95598',0.00,67999.50,225.00,67999.50,0.00,'2019-06-29 10:26:31'),(274872,'1','72',227,'Sale Id shift 95598',0.00,0.00,0.00,0.00,0.00,'2019-06-29 10:26:31'),(274876,'1','72',225,'Sale Id shift 95601',0.00,0.00,0.00,0.00,0.00,'2019-06-29 10:33:18'),(274877,'1','72',226,'Sale Id shift 95601',0.00,126099.00,225.00,126099.00,0.00,'2019-06-29 10:33:18'),(274878,'1','72',227,'Sale Id shift 95601',0.00,0.00,0.00,0.00,0.00,'2019-06-29 10:33:18'),(274882,'1','72',225,'Sale Id shift 95602',0.00,0.00,0.00,0.00,0.00,'2019-06-29 10:36:49'),(274883,'1','72',226,'Sale Id shift 95602',0.00,27472.50,225.00,27472.50,0.00,'2019-06-29 10:36:49'),(274884,'1','72',227,'Sale Id shift 95602',0.00,0.00,0.00,0.00,0.00,'2019-06-29 10:36:49'),(275362,'1','72',225,'Sale Id shift 95764',0.00,0.00,0.00,0.00,0.00,'2019-06-30 10:39:46'),(275363,'1','72',226,'Sale Id shift 95764',0.00,41463.00,225.00,41463.00,0.00,'2019-06-30 10:39:46'),(275364,'1','72',227,'Sale Id shift 95764',0.00,0.00,0.00,0.00,0.00,'2019-06-30 10:39:46'),(275620,'1','72',225,'Sale Id shift 95766',0.00,0.00,0.00,0.00,0.00,'2019-06-30 22:02:27'),(275621,'1','72',226,'Sale Id shift 95766',0.00,250398.00,225.00,250398.00,0.00,'2019-06-30 22:02:27'),(275622,'1','72',227,'Sale Id shift 95766',0.00,0.00,0.00,0.00,0.00,'2019-06-30 22:02:27'),(275860,'1','72',225,'Sale Id shift 95855',0.00,0.00,0.00,0.00,0.00,'2019-07-01 12:20:36'),(275861,'1','72',226,'Sale Id shift 95855',0.00,19248.75,225.00,19248.75,0.00,'2019-07-01 12:20:36'),(275862,'1','72',227,'Sale Id shift 95855',0.00,0.00,0.00,0.00,0.00,'2019-07-01 12:20:36'),(276845,'1','72',225,'Sale Id shift 95935',0.00,0.00,0.00,0.00,0.00,'2019-07-04 09:39:04'),(276846,'1','72',226,'Sale Id shift 95935',0.00,83497.50,225.00,83497.50,0.00,'2019-07-04 09:39:04'),(276847,'1','72',227,'Sale Id shift 95935',0.00,0.00,0.00,0.00,0.00,'2019-07-04 09:39:04'),(276848,'1','72',225,'Sale Id shift 96271',0.00,0.00,0.00,0.00,0.00,'2019-07-04 09:42:53'),(276849,'1','72',226,'Sale Id shift 96271',0.00,12001.50,225.00,12001.50,0.00,'2019-07-04 09:42:53'),(276850,'1','72',227,'Sale Id shift 96271',0.00,0.00,0.00,0.00,0.00,'2019-07-04 09:42:53'),(276854,'1','72',225,'Sale Id shift 96272',0.00,0.00,0.00,0.00,0.00,'2019-07-04 09:46:38'),(276855,'1','72',226,'Sale Id shift 96272',0.00,54657.00,225.00,54657.00,0.00,'2019-07-04 09:46:38'),(276856,'1','72',227,'Sale Id shift 96272',0.00,0.00,0.00,0.00,0.00,'2019-07-04 09:46:38'),(277219,'1','72',225,'Sale Id shift 96274',0.00,0.00,0.00,0.00,0.00,'2019-07-05 10:14:35'),(277220,'1','72',226,'Sale Id shift 96274',0.00,61035.75,225.00,61035.75,0.00,'2019-07-05 10:14:35'),(277221,'1','72',227,'Sale Id shift 96274',0.00,0.00,0.00,0.00,0.00,'2019-07-05 10:14:35'),(278362,'1','72',225,'Sale Id shift 96399',0.00,0.00,0.00,0.00,0.00,'2019-07-09 09:48:58'),(278363,'1','72',226,'Sale Id shift 96399',0.00,210654.00,225.00,210654.00,0.00,'2019-07-09 09:48:58'),(278364,'1','72',227,'Sale Id shift 96399',0.00,0.00,0.00,0.00,0.00,'2019-07-09 09:48:58'),(278368,'1','72',225,'Sale Id shift 96793',0.00,0.00,0.00,0.00,0.00,'2019-07-09 09:57:17'),(278369,'1','72',226,'Sale Id shift 96793',0.00,205922.25,225.00,205922.25,0.00,'2019-07-09 09:57:17'),(278370,'1','72',227,'Sale Id shift 96793',0.00,0.00,0.00,0.00,0.00,'2019-07-09 09:57:17'),(278377,'1','72',225,'Sale Id shift 96795',0.00,0.00,0.00,0.00,0.00,'2019-07-09 10:01:10'),(278378,'1','72',226,'Sale Id shift 96795',0.00,29751.75,225.00,29751.75,0.00,'2019-07-09 10:01:10'),(278379,'1','72',227,'Sale Id shift 96795',0.00,0.00,0.00,0.00,0.00,'2019-07-09 10:01:10'),(278383,'1','72',225,'Sale Id shift 96798',0.00,0.00,0.00,0.00,0.00,'2019-07-09 10:04:53'),(278384,'1','72',226,'Sale Id shift 96798',0.00,125574.75,225.00,125574.75,0.00,'2019-07-09 10:04:53'),(278385,'1','72',227,'Sale Id shift 96798',0.00,0.00,0.00,0.00,0.00,'2019-07-09 10:04:53'),(278851,'1','72',225,'Sale Id shift 96800',0.00,0.00,0.00,0.00,0.00,'2019-07-10 12:55:02'),(278852,'1','72',226,'Sale Id shift 96800',0.00,175675.50,225.00,175675.50,0.00,'2019-07-10 12:55:02'),(278853,'1','72',227,'Sale Id shift 96800',0.00,0.00,0.00,0.00,0.00,'2019-07-10 12:55:02'),(280087,'1','72',225,'Sale Id shift 96960',0.00,0.00,0.00,0.00,0.00,'2019-07-12 15:47:39'),(280088,'1','72',226,'Sale Id shift 96960',0.00,197201.25,225.00,197201.25,0.00,'2019-07-12 15:47:39'),(280089,'1','72',227,'Sale Id shift 96960',0.00,0.00,0.00,0.00,0.00,'2019-07-12 15:47:39'),(280090,'1','72',225,'Sale Id shift 97388',0.00,0.00,0.00,0.00,0.00,'2019-07-12 15:51:12'),(280091,'1','72',226,'Sale Id shift 97388',0.00,6999.75,225.00,6999.75,0.00,'2019-07-12 15:51:12'),(280092,'1','72',227,'Sale Id shift 97388',0.00,0.00,0.00,0.00,0.00,'2019-07-12 15:51:12'),(281221,'1','72',225,'Sale Id shift 97788',0.00,0.00,0.00,0.00,0.00,'2019-07-15 15:22:25'),(281222,'1','72',226,'Sale Id shift 97788',0.00,8694.00,220.00,8500.80,-193.20,'2019-07-15 15:22:25'),(281223,'1','72',227,'Sale Id shift 97788',0.00,0.00,0.00,0.00,0.00,'2019-07-15 15:22:25'),(281224,'1','72',225,'Sale Id shift 97790',0.00,0.00,0.00,0.00,0.00,'2019-07-15 15:25:40'),(281225,'1','72',226,'Sale Id shift 97790',0.00,28125.00,220.00,27500.00,-625.00,'2019-07-15 15:25:40'),(281226,'1','72',227,'Sale Id shift 97790',0.00,0.00,0.00,0.00,0.00,'2019-07-15 15:25:40'),(281479,'1','72',225,'Sale Id shift 97792',0.00,0.00,0.00,0.00,0.00,'2019-07-16 12:14:55'),(281480,'1','72',226,'Sale Id shift 97792',0.00,9409.50,220.00,9200.40,-209.10,'2019-07-16 12:14:55'),(281481,'1','72',227,'Sale Id shift 97792',0.00,0.00,0.00,0.00,0.00,'2019-07-16 12:14:55'),(282233,'1','72',225,'Sale Id shift 97873',0.00,0.00,0.00,0.00,0.00,'2019-07-18 13:24:16'),(282234,'1','72',226,'Sale Id shift 97873',0.00,214317.00,220.00,209554.40,-4762.60,'2019-07-18 13:24:16'),(282235,'1','72',227,'Sale Id shift 97873',0.00,0.00,0.00,0.00,0.00,'2019-07-18 13:24:16'),(284127,'1','72',225,'Sale Id shift 99192',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:30:33'),(284128,'1','72',226,'Sale Id shift 99192',0.00,121806.00,220.00,119099.20,-2706.80,'2019-07-23 16:30:33'),(284129,'1','72',227,'Sale Id shift 99192',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:30:33'),(284133,'1','72',225,'Sale Id shift 99196',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:33:52'),(284134,'1','72',226,'Sale Id shift 99196',0.00,80518.50,220.00,78729.20,-1789.30,'2019-07-23 16:33:52'),(284135,'1','72',227,'Sale Id shift 99196',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:33:52'),(284142,'1','72',225,'Sale Id shift 99199',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:42:04'),(284143,'1','72',226,'Sale Id shift 99199',0.00,10723.50,220.00,10485.20,-238.30,'2019-07-23 16:42:04'),(284144,'1','72',227,'Sale Id shift 99199',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:42:04'),(284145,'1','72',225,'Sale Id shift 99201',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:45:12'),(284146,'1','72',226,'Sale Id shift 99201',0.00,128108.25,220.00,125261.40,-2846.85,'2019-07-23 16:45:12'),(284147,'1','72',227,'Sale Id shift 99201',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:45:12'),(284148,'1','72',225,'Sale Id shift 99203',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:48:22'),(284149,'1','72',226,'Sale Id shift 99203',0.00,172453.50,220.00,168621.20,-3832.30,'2019-07-23 16:48:22'),(284150,'1','72',227,'Sale Id shift 99203',0.00,0.00,0.00,0.00,0.00,'2019-07-23 16:48:22'),(285042,'1','72',225,'Sale Id shift 99517',0.00,0.00,0.00,0.00,0.00,'2019-07-26 09:01:36'),(285043,'1','72',226,'Sale Id shift 99517',0.00,16317.40,220.00,16317.40,0.00,'2019-07-26 09:01:36'),(285044,'1','72',227,'Sale Id shift 99517',0.00,0.00,0.00,0.00,0.00,'2019-07-26 09:01:36'),(285310,'1','72',226,'Sale Id shift 99518',0.00,248470.20,220.00,248470.20,0.00,'2019-07-26 18:59:19'),(286277,'1','72',226,'Sale Id shift 99616',0.00,114798.20,220.00,114798.20,0.00,'2019-07-30 11:59:39'),(286278,'1','72',226,'Sale Id shift 100048',0.00,135282.40,220.00,135282.40,0.00,'2019-07-30 12:02:17'),(286282,'1','72',226,'Sale Id shift 100049',0.00,168031.60,220.00,168031.60,0.00,'2019-07-30 12:09:58'),(286283,'1','72',226,'Sale Id shift 100052',0.00,128913.40,220.00,128913.40,0.00,'2019-07-30 12:17:22'),(286870,'1','72',226,'Sale Id shift 100053',0.00,292184.20,220.00,292184.20,0.00,'2019-08-01 13:08:24'),(286871,'1','72',226,'Sale Id shift 100302',0.00,320524.60,220.00,320524.60,0.00,'2019-08-01 13:11:27'),(287168,'1','72',226,'Sale Id shift 100303',0.00,130376.40,220.00,130376.40,0.00,'2019-08-03 09:12:11'),(287169,'1','72',226,'Sale Id shift 100439',0.00,72558.20,220.00,72558.20,0.00,'2019-08-03 09:15:27'),(287890,'1','72',226,'Sale Id shift 100441',0.00,360126.80,220.00,360126.80,0.00,'2019-08-05 15:16:43'),(287891,'1','72',226,'Sale Id shift 100767',0.00,236225.00,220.00,236225.00,0.00,'2019-08-05 15:19:37'),(288321,'1','72',226,'Sale Id shift 100768',0.00,117508.60,220.00,117508.60,0.00,'2019-08-07 12:12:49'),(288324,'1','72',226,'Sale Id shift 100980',0.00,155339.80,220.00,155339.80,0.00,'2019-08-07 12:16:09'),(288686,'1','72',226,'Sale Id shift 100981',0.00,56903.00,220.00,56903.00,0.00,'2019-08-08 14:07:48'),(288915,'1','72',226,'Sale Id shift 101149',0.00,138958.60,220.00,138958.60,0.00,'2019-08-09 12:19:04'),(290116,'1','72',226,'Sale Id shift 101249',0.00,19901.20,220.00,19901.20,0.00,'2019-08-14 14:48:05'),(290119,'1','72',226,'Sale Id shift 101809',0.00,53037.60,220.00,53037.60,0.00,'2019-08-14 14:50:43'),(290120,'1','72',226,'Sale Id shift 101811',0.00,8588.80,225.00,8784.00,195.20,'2019-08-14 14:54:11'),(290121,'1','72',226,'Sale Id shift 101814',0.00,5500.00,220.00,5500.00,0.00,'2019-08-14 14:57:44'),(290126,'1','72',226,'Sale Id shift 101815',0.00,5900.40,220.00,5900.40,0.00,'2019-08-14 15:01:37'),(291054,'1','72',226,'Sale Id shift 101817',0.00,248001.60,220.00,248001.60,0.00,'2019-08-17 15:40:17'),(291113,'1','72',226,'Sale Id shift 102244',0.00,265482.80,220.00,265482.80,0.00,'2019-08-17 17:29:05'),(291303,'1','72',226,'Sale Id shift 102355',0.00,112151.60,220.00,112151.60,0.00,'2019-08-18 16:59:03'),(291796,'1','72',226,'Sale Id shift 102357',0.00,93005.00,220.00,93005.00,0.00,'2019-08-20 16:07:46'),(291800,'1','72',226,'Sale Id shift 102604',0.00,228428.20,220.00,228428.20,0.00,'2019-08-20 16:11:33'),(291811,'1','72',226,'Sale Id shift 102606',0.00,11349.80,220.00,11349.80,0.00,'2019-08-20 16:17:39'),(292155,'1','72',226,'Sale Id shift 102780',0.00,314439.40,220.00,314439.40,0.00,'2019-08-21 17:07:04'),(293381,'1','72',226,'Sale Id shift 102781',0.00,264803.00,215.00,258784.75,-6018.25,'2019-08-26 19:21:36'),(293382,'1','72',226,'Sale Id shift 103406',0.00,46972.20,215.00,45904.65,-1067.55,'2019-08-26 19:25:16'),(293383,'1','72',226,'Sale Id shift 103407',0.00,28943.20,215.00,28285.40,-657.80,'2019-08-26 19:29:10'),(293384,'1','72',226,'Sale Id shift 103408',0.00,119369.80,215.00,116656.85,-2712.95,'2019-08-26 19:32:26'),(293385,'1','72',226,'Sale Id shift 103409',0.00,154926.20,215.00,151405.15,-3521.05,'2019-08-26 19:35:43'),(293649,'1','72',226,'Sale Id shift 103410',0.00,17648.40,215.00,17247.30,-401.10,'2019-08-27 20:42:10'),(293814,'1','72',226,'Sale Id shift 103546',0.00,517699.60,215.00,505933.70,-11765.90,'2019-08-28 14:10:54'),(294385,'1','72',226,'Sale Id shift 103637',0.00,28432.80,215.00,27786.60,-646.20,'2019-08-30 14:59:34'),(294386,'1','72',226,'Sale Id shift 103939',0.00,54782.20,215.00,53537.15,-1245.05,'2019-08-30 15:02:05'),(295359,'1','72',226,'Sale Id shift 103941',0.00,116644.00,215.00,113993.00,-2651.00,'2019-09-03 18:47:29'),(295360,'1','72',226,'Sale Id shift 104452',0.00,347998.20,215.00,340089.15,-7909.05,'2019-09-03 18:51:18'),(295361,'1','72',226,'Sale Id shift 104453',0.00,297924.00,215.00,291153.00,-6771.00,'2019-09-03 18:55:12'),(297177,'1','72',226,'Sale Id shift 104454',0.00,575834.60,215.00,562747.45,-13087.15,'2019-09-10 16:18:16'),(297183,'1','72',226,'Sale Id shift 105304',0.00,147113.75,215.00,147113.75,0.00,'2019-09-10 16:21:27'),(297187,'1','72',226,'Sale Id shift 105307',0.00,272439.40,215.00,272439.40,0.00,'2019-09-10 16:24:33'),(297191,'1','72',226,'Sale Id shift 105309',0.00,162879.70,215.00,162879.70,0.00,'2019-09-10 16:28:25'),(297194,'1','72',226,'Sale Id shift 105311',0.00,335630.05,215.00,335630.05,0.00,'2019-09-10 16:31:02'),(297200,'1','72',226,'Sale Id shift 105313',0.00,21801.00,215.00,21801.00,0.00,'2019-09-10 16:33:43'),(297204,'1','72',226,'Sale Id shift 105316',0.00,174031.75,215.00,174031.75,0.00,'2019-09-10 16:36:25'),(297208,'1','72',226,'Sale Id shift 105317',0.00,25475.35,215.00,25475.35,0.00,'2019-09-10 16:39:18'),(297478,'1','72',226,'Sale Id shift 105319',0.00,318599.90,215.00,318599.90,0.00,'2019-09-11 16:32:27'),(298048,'1','72',226,'Sale Id shift 105441',0.00,278014.35,215.00,278014.35,0.00,'2019-09-13 15:52:01'),(298053,'1','72',226,'Sale Id shift 105704',0.00,670939.75,215.00,670939.75,0.00,'2019-09-13 15:55:20'),(298924,'1','72',226,'Sale Id shift 105707',0.00,223359.20,215.00,223359.20,0.00,'2019-09-16 18:36:07'),(298928,'1','72',226,'Sale Id shift 106101',0.00,187310.15,215.00,187310.15,0.00,'2019-09-16 18:39:15'),(299569,'1','72',226,'Sale Id shift 106407',0.00,181008.50,215.00,181008.50,0.00,'2019-09-18 19:37:04'),(299982,'1','72',226,'Sale Id shift 106408',0.00,34251.65,215.00,34251.65,0.00,'2019-09-20 10:40:35'),(301291,'1','72',226,'Sale Id shift 106616',0.00,237979.20,215.00,237979.20,0.00,'2019-09-24 19:23:39'),(301292,'1','72',226,'Sale Id shift 107245',0.00,143205.05,215.00,143205.05,0.00,'2019-09-24 19:27:11'),(301293,'1','72',226,'Sale Id shift 107246',0.00,293752.35,215.00,293752.35,0.00,'2019-09-24 19:30:05'),(301294,'1','72',226,'Sale Id shift 107247',0.00,294547.85,215.00,294547.85,0.00,'2019-09-24 19:35:49'),(302892,'1','72',226,'Sale Id shift 108010',0.00,217111.30,215.00,217111.30,0.00,'2019-09-30 13:39:24'),(302898,'1','72',226,'Sale Id shift 108013',0.00,169675.85,215.00,169675.85,0.00,'2019-09-30 13:43:57'),(302899,'1','72',226,'Sale Id shift 108016',0.00,264198.45,215.00,264198.45,0.00,'2019-09-30 13:48:17'),(303538,'1','72',226,'Sale Id shift 108017',0.00,13357.95,215.00,13357.95,0.00,'2019-10-02 21:47:12'),(303539,'1','72',226,'Sale Id shift 108316',0.00,256428.35,215.00,256428.35,0.00,'2019-10-02 21:50:30'),(303778,'1','72',226,'Sale Id shift 108317',0.00,125886.80,215.00,125886.80,0.00,'2019-10-03 20:47:34'),(305191,'1','72',226,'Sale Id shift 108435',0.00,43148.35,215.00,43148.35,0.00,'2019-10-08 18:15:46'),(305192,'1','72',226,'Sale Id shift 109098',0.00,23604.85,215.00,23604.85,0.00,'2019-10-08 18:18:37'),(305193,'1','72',226,'Sale Id shift 109099',0.00,126267.35,215.00,126267.35,0.00,'2019-10-08 18:22:01'),(305194,'1','72',226,'Sale Id shift 109100',0.00,196976.55,215.00,196976.55,0.00,'2019-10-08 18:25:24'),(305195,'1','72',226,'Sale Id shift 109101',0.00,15499.35,215.00,15499.35,0.00,'2019-10-08 18:28:38'),(305526,'1','72',226,'Sale Id shift 109102',0.00,142572.95,215.00,142572.95,0.00,'2019-10-09 19:12:31'),(306524,'1','72',226,'Sale Id shift 109255',0.00,178073.75,215.00,178073.75,0.00,'2019-10-13 19:22:07'),(306525,'1','72',226,'Sale Id shift 109723',0.00,14037.35,215.00,14037.35,0.00,'2019-10-13 19:27:39'),(306526,'1','72',226,'Sale Id shift 109724',0.00,41918.55,215.00,41918.55,0.00,'2019-10-13 19:31:36'),(306527,'1','72',226,'Sale Id shift 109725',0.00,44984.45,215.00,44984.45,0.00,'2019-10-13 19:36:03'),(306847,'1','72',226,'Sale Id shift 109726',0.00,245164.50,215.00,245164.50,0.00,'2019-10-14 19:41:33'),(307334,'1','72',226,'Sale Id shift 109875',0.00,185342.90,215.00,185342.90,0.00,'2019-10-16 18:24:58'),(307335,'1','72',226,'Sale Id shift 110101',0.00,206010.85,215.00,206010.85,0.00,'2019-10-16 18:28:28'),(307861,'1','72',226,'Sale Id shift 110102',0.00,16806.55,215.00,16806.55,0.00,'2019-10-18 18:23:44'),(307864,'1','72',226,'Sale Id shift 110351',0.00,225648.95,215.00,225648.95,0.00,'2019-10-18 18:27:14'),(308778,'1','72',226,'Sale Id shift 110352',0.00,72401.25,215.00,72401.25,0.00,'2019-10-21 21:04:23'),(308779,'1','72',226,'Sale Id shift 110778',0.00,122042.60,215.00,122042.60,0.00,'2019-10-21 21:08:08'),(308780,'1','72',226,'Sale Id shift 110779',0.00,275946.05,215.00,275946.05,0.00,'2019-10-21 21:12:04'),(309271,'1','72',226,'Sale Id shift 111011',0.00,160903.85,215.00,160903.85,0.00,'2019-10-23 18:23:24'),(309272,'1','72',226,'Sale Id shift 111013',0.00,195389.85,215.00,195389.85,0.00,'2019-10-23 18:28:26'),(310817,'1','72',226,'Sale Id shift 111014',0.00,161652.05,215.00,161652.05,0.00,'2019-10-29 19:15:45'),(310818,'1','72',226,'Sale Id shift 111745',0.00,247914.35,215.00,247914.35,0.00,'2019-10-29 19:18:47'),(310819,'1','72',226,'Sale Id shift 111746',0.00,66245.80,215.00,66245.80,0.00,'2019-10-29 19:22:30'),(310823,'1','72',226,'Sale Id shift 111747',0.00,37203.60,215.00,37203.60,0.00,'2019-10-29 19:25:24'),(310824,'1','72',226,'Sale Id shift 111748',0.00,26999.70,215.00,26999.70,0.00,'2019-10-29 19:29:30'),(310825,'1','72',226,'Sale Id shift 111750',0.00,69135.40,215.00,69135.40,0.00,'2019-10-29 19:32:57'),(311003,'1','72',226,'Sale Id shift 111751',0.00,33613.10,215.00,33613.10,0.00,'2019-10-30 14:40:02'),(314166,'1','72',226,'Sale Id shift 113467',0.00,174818.60,220.00,174818.60,0.00,'2019-11-14 14:59:22'),(314446,'1','72',226,'Sale Id shift 113640',0.00,168601.40,220.00,168601.40,0.00,'2019-11-15 15:47:02'),(314994,'1','72',226,'Sale Id shift 113770',0.00,112978.80,220.00,112978.80,0.00,'2019-11-18 08:59:30'),(314995,'1','72',226,'Sale Id shift 114027',0.00,140056.40,220.00,140056.40,0.00,'2019-11-18 09:02:26'),(314997,'1','72',226,'Sale Id shift 114029',0.00,345826.80,220.00,345826.80,0.00,'2019-11-18 09:05:34'),(315757,'1','72',226,'Sale Id shift 114032',0.00,134270.40,220.00,134270.40,0.00,'2019-11-20 19:12:33'),(315758,'1','72',226,'Sale Id shift 114379',0.00,114754.20,220.00,114754.20,0.00,'2019-11-20 19:16:10'),(315759,'1','72',226,'Sale Id shift 114380',0.00,72080.80,220.00,72080.80,0.00,'2019-11-20 19:20:26'),(316009,'1','72',226,'Sale Id shift 114381',0.00,251044.20,220.00,251044.20,0.00,'2019-11-21 18:14:31'),(317374,'1','72',226,'Sale Id shift 114505',0.00,143902.00,220.00,143902.00,0.00,'2019-11-26 19:27:01'),(317375,'1','72',226,'Sale Id shift 115235',0.00,164333.40,220.00,164333.40,0.00,'2019-11-26 19:29:47'),(317376,'1','72',226,'Sale Id shift 115236',0.00,472507.20,220.00,472507.20,0.00,'2019-11-26 19:33:40'),(317377,'1','72',226,'Sale Id shift 115237',0.00,582282.80,220.00,582282.80,0.00,'2019-11-26 19:38:28'),(317378,'1','72',226,'Sale Id shift 115238',0.00,35305.60,220.00,35305.60,0.00,'2019-11-26 19:44:00'),(317700,'1','72',226,'Sale Id shift 115239',0.00,172915.60,220.00,172915.60,0.00,'2019-11-27 18:41:30'),(318592,'1','72',226,'Sale Id shift 115390',0.00,44759.00,220.00,44759.00,0.00,'2019-12-01 16:43:59'),(318593,'1','72',226,'Sale Id shift 115783',0.00,47605.80,220.00,47605.80,0.00,'2019-12-01 16:48:58'),(318594,'1','72',226,'Sale Id shift 115784',0.00,55250.80,220.00,55250.80,0.00,'2019-12-01 16:58:20'),(320798,'1','72',226,'Sale Id shift 116802',0.00,28850.80,220.00,28850.80,0.00,'2019-12-10 07:59:32'),(320890,'1','72',226,'Sale Id shift 116822',0.00,30276.40,220.00,30276.40,0.00,'2019-12-10 12:22:06'),(320891,'1','72',226,'Sale Id shift 116869',0.00,302700.20,220.00,302700.20,0.00,'2019-12-10 12:26:36'),(320895,'1','72',226,'Sale Id shift 116870',0.00,130805.40,220.00,130805.40,0.00,'2019-12-10 12:29:40'),(321046,'1','72',226,'Sale Id shift 116953',0.00,47399.00,215.00,46321.75,-1077.25,'2019-12-10 17:41:30'),(321331,'1','72',226,'Sale Id shift 116961',0.00,75902.20,215.00,74177.15,-1725.05,'2019-12-11 18:02:22'),(321605,'1','72',226,'Sale Id shift 117099',0.00,106997.00,215.00,104565.25,-2431.75,'2019-12-12 18:53:01'),(321894,'1','72',226,'Sale Id shift 117231',0.00,138465.80,215.00,135318.85,-3146.95,'2019-12-13 18:59:09'),(322110,'1','72',226,'Sale Id shift 117392',0.00,504836.20,215.00,493362.65,-11473.55,'2019-12-14 17:57:05'),(322327,'1','72',226,'Sale Id shift 117510',0.00,172469.00,215.00,168549.25,-3919.75,'2019-12-15 20:23:41'),(322551,'1','72',226,'Sale Id shift 117613',0.00,442332.00,215.00,432279.00,-10053.00,'2019-12-16 17:55:48'),(322889,'1','72',226,'Sale Id shift 117747',0.00,146795.00,215.00,143458.75,-3336.25,'2019-12-17 17:38:49'),(323139,'1','72',226,'Sale Id shift 117908',0.00,138215.00,215.00,135073.75,-3141.25,'2019-12-18 19:08:41'),(323466,'1','72',226,'Sale Id shift 118167',0.00,60574.80,215.00,59198.10,-1376.70,'2019-12-19 17:59:13'),(323758,'1','72',226,'Sale Id shift 118311',0.00,16269.00,215.00,15899.25,-369.75,'2019-12-20 18:49:23'),(342718,'1','72',226,'Sale Id shift 126893',0.00,86818.60,215.00,84845.45,-1973.15,'2020-02-28 11:08:44'),(342724,'1','72',226,'Sale Id shift 126896',0.00,344170.20,215.00,336348.15,-7822.05,'2020-02-28 11:17:08'),(342729,'1','72',226,'Sale Id shift 126905',0.00,346176.60,215.00,338308.95,-7867.65,'2020-02-28 11:47:19'),(342736,'1','72',226,'Sale Id shift 126908',0.00,88638.00,215.00,86623.50,-2014.50,'2020-02-28 11:58:02'),(342737,'1','72',226,'Sale Id shift 126911',0.00,30771.40,215.00,30072.05,-699.35,'2020-02-28 12:02:37'),(342741,'1','72',226,'Sale Id shift 126912',0.00,157806.00,215.00,154219.50,-3586.50,'2020-02-28 12:07:01'),(342744,'1','72',226,'Sale Id shift 126914',0.00,79180.20,215.00,77380.65,-1799.55,'2020-02-28 12:10:11'),(342747,'1','72',226,'Sale Id shift 126916',0.00,35028.40,215.00,34232.30,-796.10,'2020-02-28 12:15:40'),(342975,'1','72',226,'Sale Id shift 126924',0.00,32744.80,215.00,32000.60,-744.20,'2020-02-29 12:06:08'),(342981,'1','72',226,'Sale Id shift 127015',0.00,39754.00,215.00,38850.50,-903.50,'2020-02-29 12:11:20'),(342982,'1','72',226,'Sale Id shift 127017',0.00,34544.40,215.00,33759.30,-785.10,'2020-02-29 12:14:32'),(342983,'1','72',226,'Sale Id shift 127018',0.00,13303.40,215.00,13001.05,-302.35,'2020-02-29 12:17:59'),(342987,'1','72',226,'Sale Id shift 127019',0.00,14020.60,215.00,13701.95,-318.65,'2020-02-29 12:21:00'),(342991,'1','72',226,'Sale Id shift 127021',0.00,75743.80,215.00,74022.35,-1721.45,'2020-02-29 12:24:58'),(342993,'1','72',226,'Sale Id shift 127024',0.00,66077.00,225.00,67578.75,1501.75,'2020-02-29 12:27:45'),(342994,'1','72',226,'Sale Id shift 127026',0.00,156699.40,225.00,160260.75,3561.35,'2020-02-29 12:31:42'),(342997,'1','72',226,'Sale Id shift 127027',0.00,200809.40,225.00,205373.25,4563.85,'2020-02-29 12:36:37'),(342998,'1','72',226,'Sale Id shift 127029',0.00,101076.80,225.00,103374.00,2297.20,'2020-02-29 12:39:53'),(343001,'1','72',226,'Sale Id shift 127030',0.00,30437.00,225.00,31128.75,691.75,'2020-02-29 12:42:49'),(343006,'1','72',226,'Sale Id shift 127032',0.00,89625.80,225.00,91662.75,2036.95,'2020-02-29 12:46:33'),(343007,'1','72',226,'Sale Id shift 127035',0.00,56548.80,225.00,57834.00,1285.20,'2020-02-29 12:50:00'),(343011,'1','72',226,'Sale Id shift 127036',0.00,210399.20,225.00,215181.00,4781.80,'2020-02-29 12:53:04'),(343013,'1','72',226,'Sale Id shift 127039',0.00,229233.40,225.00,234443.25,5209.85,'2020-02-29 12:58:08'),(343014,'1','72',226,'Sale Id shift 127041',0.00,71132.60,225.00,72749.25,1616.65,'2020-02-29 13:02:31'),(343021,'1','72',226,'Sale Id shift 127042',0.00,43806.40,225.00,44802.00,995.60,'2020-02-29 13:09:48'),(343024,'1','72',226,'Sale Id shift 127044',0.00,58667.40,225.00,60000.75,1333.35,'2020-02-29 13:15:34'),(343027,'1','72',226,'Sale Id shift 127048',0.00,61564.80,225.00,62964.00,1399.20,'2020-02-29 13:19:56'),(343028,'1','72',226,'Sale Id shift 127051',0.00,139966.20,225.00,143147.25,3181.05,'2020-02-29 13:24:05'),(343029,'1','72',226,'Sale Id shift 127052',0.00,173016.80,225.00,176949.00,3932.20,'2020-02-29 13:26:48'),(343033,'1','72',226,'Sale Id shift 127054',0.00,192779.40,225.00,197160.75,4381.35,'2020-02-29 13:29:41'),(343036,'1','72',226,'Sale Id shift 127055',0.00,156736.80,225.00,160299.00,3562.20,'2020-02-29 13:32:29'),(343037,'1','72',226,'Sale Id shift 127056',0.00,56216.60,225.00,57494.25,1277.65,'2020-02-29 13:34:45'),(343040,'1','72',226,'Sale Id shift 127057',0.00,50256.80,225.00,51399.00,1142.20,'2020-02-29 13:37:05'),(343041,'1','72',226,'Sale Id shift 127060',0.00,133335.40,225.00,136365.75,3030.35,'2020-02-29 13:39:36'),(343042,'1','72',226,'Sale Id shift 127061',0.00,46285.80,225.00,47337.75,1051.95,'2020-02-29 13:42:07'),(343043,'1','72',226,'Sale Id shift 127062',0.00,165660.00,220.00,165660.00,0.00,'2020-02-29 13:45:13'),(343046,'1','72',226,'Sale Id shift 127064',0.00,153610.60,220.00,153610.60,0.00,'2020-02-29 13:48:08'),(343180,'1','72',226,'Sale Id shift 127122',0.00,54683.20,220.00,54683.20,0.00,'2020-02-29 19:32:19'),(343181,'1','72',226,'Sale Id shift 127123',0.00,159889.40,220.00,159889.40,0.00,'2020-02-29 19:35:49'),(343182,'1','72',226,'Sale Id shift 127124',0.00,239956.20,220.00,239956.20,0.00,'2020-02-29 19:40:13'),(343183,'1','72',226,'Sale Id shift 127125',0.00,20996.80,220.00,20996.80,0.00,'2020-02-29 19:43:28'),(343184,'1','72',226,'Sale Id shift 127126',0.00,20724.00,220.00,20724.00,0.00,'2020-02-29 19:47:03'),(343185,'1','72',226,'Sale Id shift 127127',0.00,80592.60,220.00,80592.60,0.00,'2020-02-29 19:55:12'),(343188,'1','72',226,'Sale Id shift 127128',0.00,89911.80,220.00,89911.80,0.00,'2020-02-29 19:59:44'),(343189,'1','72',226,'Sale Id shift 127130',0.00,351826.20,220.00,351826.20,0.00,'2020-02-29 20:05:07'),(343190,'1','72',226,'Sale Id shift 127131',0.00,59604.60,215.00,58249.95,-1354.65,'2020-02-29 20:09:21'),(343191,'1','72',226,'Sale Id shift 127132',0.00,124652.00,215.00,121819.00,-2833.00,'2020-02-29 20:18:24'),(343192,'1','72',226,'Sale Id shift 127133',0.00,58405.60,215.00,57078.20,-1327.40,'2020-02-29 20:22:07'),(343193,'1','72',226,'Sale Id shift 127134',0.00,394598.60,215.00,385630.45,-8968.15,'2020-02-29 20:25:42'),(343194,'1','72',226,'Sale Id shift 127135',0.00,14935.80,215.00,14596.35,-339.45,'2020-02-29 20:29:08'),(343195,'1','72',226,'Sale Id shift 127137',0.00,159264.60,215.00,155644.95,-3619.65,'2020-02-29 20:37:32'),(343196,'1','72',226,'Sale Id shift 127138',0.00,112048.20,215.00,109501.65,-2546.55,'2020-02-29 20:41:06'),(343197,'1','72',226,'Sale Id shift 127139',0.00,62451.40,215.00,61032.05,-1419.35,'2020-02-29 20:45:02'),(343198,'1','72',226,'Sale Id shift 127140',0.00,153652.40,215.00,150160.30,-3492.10,'2020-02-29 20:48:49'),(343652,'1','72',226,'Sale Id shift 127160',0.00,51279.80,215.00,50114.35,-1165.45,'2020-03-02 16:47:53'),(343657,'1','72',226,'Sale Id shift 127345',0.00,110338.80,215.00,107831.10,-2507.70,'2020-03-02 16:54:47'),(343771,'1','72',226,'Sale Id shift 127348',0.00,180439.60,215.00,176338.70,-4100.90,'2020-03-03 08:44:29'),(344825,'1','72',226,'Sale Id shift 127398',0.00,130974.80,215.00,127998.10,-2976.70,'2020-03-07 09:51:18'),(344827,'1','72',226,'Sale Id shift 127865',0.00,14326.40,215.00,14000.80,-325.60,'2020-03-07 09:58:08'),(344828,'1','72',226,'Sale Id shift 127867',0.00,125246.00,215.00,122399.50,-2846.50,'2020-03-07 10:03:37'),(344829,'1','72',226,'Sale Id shift 127868',0.00,91986.40,215.00,89895.80,-2090.60,'2020-03-07 10:09:22'),(345061,'1','72',226,'Sale Id shift 127869',0.00,103479.20,215.00,101127.40,-2351.80,'2020-03-08 11:40:29'),(345670,'1','72',226,'Sale Id shift 127976',0.00,67601.60,215.00,66065.20,-1536.40,'2020-03-10 12:42:36'),(345673,'1','72',226,'Sale Id shift 128233',0.00,42330.20,215.00,41368.15,-962.05,'2020-03-10 12:44:43'),(345991,'1','72',226,'Sale Id shift 128256',0.00,286484.00,215.00,279973.00,-6511.00,'2020-03-11 14:29:31'),(346223,'1','72',226,'Sale Id shift 128384',0.00,218812.00,210.00,208866.00,-9946.00,'2020-03-12 14:04:16'),(347706,'1','72',226,'Sale Id shift 128488',0.00,26582.60,210.00,25374.30,-1208.30,'2020-03-17 11:43:09'),(347709,'1','72',226,'Sale Id shift 129160',0.00,226518.60,210.00,216222.30,-10296.30,'2020-03-17 11:47:01'),(347710,'1','72',226,'Sale Id shift 129161',0.00,25093.20,210.00,23952.60,-1140.60,'2020-03-17 11:49:58'),(347715,'1','72',226,'Sale Id shift 129163',0.00,11479.60,210.00,10957.80,-521.80,'2020-03-17 11:52:56'),(347718,'1','72',226,'Sale Id shift 129167',0.00,16594.60,210.00,15840.30,-754.30,'2020-03-17 11:56:01'),(347962,'1','72',226,'Sale Id shift 129169',0.00,53743.80,210.00,51300.90,-2442.90,'2020-03-18 12:08:10'),(348294,'1','72',226,'Sale Id shift 129280',0.00,16027.00,210.00,15298.50,-728.50,'2020-03-19 12:57:56'),(349737,'1','72',226,'Sale Id shift 129442',0.00,63591.00,210.00,60700.50,-2890.50,'2020-03-24 12:37:17'),(349742,'1','72',226,'Sale Id shift 130093',0.00,331641.20,210.00,316566.60,-15074.60,'2020-03-24 12:42:43'),(349746,'1','72',226,'Sale Id shift 130096',0.00,9112.40,210.00,8698.20,-414.20,'2020-03-24 12:50:10'),(349747,'1','72',226,'Sale Id shift 130097',0.00,30324.80,210.00,28946.40,-1378.40,'2020-03-24 12:58:00'),(350060,'1','72',226,'Sale Id shift 130100',0.00,13829.20,210.00,13200.60,-628.60,'2020-03-25 12:41:51'),(350703,'1','72',226,'Sale Id shift 130233',0.00,22627.00,210.00,21598.50,-1028.50,'2020-03-28 11:24:04'),(350706,'1','72',226,'Sale Id shift 130534',0.00,27275.60,210.00,26035.80,-1239.80,'2020-03-28 11:26:24'),(350707,'1','72',226,'Sale Id shift 130537',0.00,150999.20,210.00,144135.60,-6863.60,'2020-03-28 11:29:06'),(360853,'1','72',226,'Sale Id shift 135118',0.00,145019.60,200.00,131836.00,-13183.60,'2020-05-10 08:27:37'),(361090,'1','72',226,'Sale Id shift 135209',0.00,173221.40,200.00,157474.00,-15747.40,'2020-05-11 08:54:30'),(361334,'1','72',226,'Sale Id shift 135322',0.00,89100.00,200.00,89100.00,0.00,'2020-05-12 08:11:50'),(361625,'1','72',226,'Sale Id shift 135428',0.00,109640.00,200.00,109640.00,0.00,'2020-05-13 11:15:07'),(362082,'1','72',226,'Sale Id shift 135560',0.00,132400.00,200.00,132400.00,0.00,'2020-05-15 10:13:18'),(362090,'1','72',226,'Sale Id shift 135778',0.00,92900.00,200.00,92900.00,0.00,'2020-05-15 10:22:29'),(362868,'1','72',226,'Sale Id shift 135780',0.00,10000.00,200.00,10000.00,0.00,'2020-05-18 11:52:05'),(362869,'1','72',226,'Sale Id shift 136140',0.00,13000.00,200.00,13000.00,0.00,'2020-05-18 11:54:12'),(362873,'1','72',226,'Sale Id shift 136142',0.00,102130.00,200.00,102130.00,0.00,'2020-05-18 12:00:43'),(363271,'1','72',226,'Sale Id shift 136143',0.00,50530.00,200.00,50530.00,0.00,'2020-05-20 09:57:36'),(363280,'1','72',226,'Sale Id shift 136329',0.00,112996.00,200.00,112996.00,0.00,'2020-05-20 10:28:46'),(363617,'1','72',226,'Sale Id shift 136331',0.00,149508.00,200.00,149508.00,0.00,'2020-05-21 13:05:14'),(363806,'1','72',226,'Sale Id shift 136570',0.00,20840.00,195.00,20319.00,-521.00,'2020-05-22 07:40:41'),(365282,'1','72',226,'Sale Id shift 136572',0.00,14226.00,195.00,13870.35,-355.65,'2020-05-28 06:43:57'),(365283,'1','72',226,'Sale Id shift 137251',0.00,36052.00,195.00,35150.70,-901.30,'2020-05-28 06:47:45'),(365284,'1','72',226,'Sale Id shift 137252',0.00,109086.00,195.00,106358.85,-2727.15,'2020-05-28 06:52:20'),(365285,'1','72',226,'Sale Id shift 137253',0.00,75384.00,195.00,73499.40,-1884.60,'2020-05-28 06:57:30'),(365286,'1','72',226,'Sale Id shift 137254',0.00,90256.00,195.00,87999.60,-2256.40,'2020-05-28 07:02:46'),(365621,'1','72',226,'Sale Id shift 137255',0.00,49332.00,195.00,48098.70,-1233.30,'2020-05-29 09:21:59'),(366378,'1','72',226,'Sale Id shift 137422',0.00,49336.00,195.00,48102.60,-1233.40,'2020-06-01 11:20:16'),(366379,'1','72',226,'Sale Id shift 137768',0.00,90470.00,195.00,88208.25,-2261.75,'2020-06-01 11:24:51'),(366708,'1','72',226,'Sale Id shift 137769',0.00,22052.00,195.00,21500.70,-551.30,'2020-06-02 13:28:07'),(366995,'1','72',226,'Sale Id shift 137910',0.00,122030.00,195.00,118979.25,-3050.75,'2020-06-03 14:45:02'),(367899,'1','72',226,'Sale Id shift 138041',0.00,328832.00,195.00,320611.20,-8220.80,'2020-06-07 10:36:08'),(367904,'1','72',226,'Sale Id shift 138462',0.00,25718.00,190.00,24432.10,-1285.90,'2020-06-07 10:38:57'),(367909,'1','72',226,'Sale Id shift 138465',0.00,110258.00,190.00,104745.10,-5512.90,'2020-06-07 10:42:28'),(367915,'1','72',226,'Sale Id shift 138468',0.00,32096.00,190.00,30491.20,-1604.80,'2020-06-07 10:46:36'),(368203,'1','72',226,'Sale Id shift 138471',0.00,34628.00,190.00,32896.60,-1731.40,'2020-06-08 11:05:55'),(370865,'1','72',226,'Sale Id shift 138605',0.00,30316.00,190.00,28800.20,-1515.80,'2020-06-17 15:42:01'),(370869,'1','72',226,'Sale Id shift 139809',0.00,44104.00,190.00,41898.80,-2205.20,'2020-06-17 15:45:21'),(370874,'1','72',226,'Sale Id shift 139812',0.00,59738.00,190.00,56751.10,-2986.90,'2020-06-17 15:50:07'),(370875,'1','72',226,'Sale Id shift 139814',0.00,78740.00,190.00,74803.00,-3937.00,'2020-06-17 15:52:54'),(370878,'1','72',226,'Sale Id shift 139816',0.00,21052.00,190.00,19999.40,-1052.60,'2020-06-17 15:56:55'),(370879,'1','72',226,'Sale Id shift 139817',0.00,8668.00,190.00,8234.60,-433.40,'2020-06-17 15:59:31');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=3770351 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','72',700586,'','supplier','98',3055000.00,0.00,'Purchase Id 26693 for 11,750 litters of AGO - 002 from A.A Rano Nigeria Limited','2018-12-07 10:32:09','',''),('1','72',704946,'','customer','1740',101035.00,0.00,'Payment Id 29484 for invoice:70008, receipt:  by A.A Rano Nigeria Limited','2018-12-12 12:54:48','',''),('1','72',704947,'','supplier','98',0.00,101035.00,'Payment Id 29484 for invoice:70008, receipt:  by A.A Rano Nigeria Limited','2018-12-12 12:54:48','',''),('1','72',704948,'','customer','1740',366800.00,0.00,'Payment Id 29485 for invoice:70659, receipt:  by A.A Rano Nigeria Limited','2018-12-12 12:55:12','',''),('1','72',704949,'','supplier','98',0.00,366800.00,'Payment Id 29485 for invoice:70659, receipt:  by A.A Rano Nigeria Limited','2018-12-12 12:55:12','',''),('1','72',704956,'','customer','1740',128435.00,0.00,'Payment Id 29487 for invoice:70697, receipt:  by A.A Rano Nigeria Limited','2018-12-12 12:59:52','',''),('1','72',704957,'','supplier','98',0.00,128435.00,'Payment Id 29487 for invoice:70697, receipt:  by A.A Rano Nigeria Limited','2018-12-12 12:59:52','',''),('1','72',704958,'','customer','1740',258100.00,0.00,'Payment Id 29488 for invoice:70699, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:01:03','',''),('1','72',704959,'','supplier','98',0.00,258100.00,'Payment Id 29488 for invoice:70699, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:01:03','',''),('1','72',704960,'','customer','1740',176900.00,0.00,'Payment Id 29489 for invoice:70700, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:02:56','',''),('1','72',704961,'','supplier','98',0.00,176900.00,'Payment Id 29489 for invoice:70700, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:02:56','',''),('1','72',704964,'','customer','1740',95505.00,0.00,'Payment Id 29490 for invoice:70702, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:06:22','',''),('1','72',704965,'','supplier','98',0.00,95505.00,'Payment Id 29490 for invoice:70702, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:06:22','',''),('1','72',704966,'','customer','1740',186105.00,0.00,'Payment Id 29491 for invoice:70708, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:07:01','',''),('1','72',704967,'','supplier','98',0.00,186105.00,'Payment Id 29491 for invoice:70708, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:07:01','',''),('1','72',704981,'','customer','1740',511400.00,0.00,'Payment Id 29492 for invoice:70708, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:11:22','',''),('1','72',704982,'','supplier','98',0.00,511400.00,'Payment Id 29492 for invoice:70708, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:11:22','',''),('1','72',705007,'','customer','1740',235005.00,0.00,'Payment Id 30039 for invoice:71086, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:18:16','',''),('1','72',705008,'','supplier','98',0.00,235005.00,'Payment Id 30039 for invoice:71086, receipt:  by A.A Rano Nigeria Limited','2018-12-12 13:18:16','',''),('1','72',707789,'','customer','1740',149640.00,0.00,'Payment Id 30486 for invoice:70893, receipt:  by A.A Rano Nigeria Limited','2018-12-14 14:35:14','',''),('1','72',707790,'','supplier','98',0.00,149640.00,'Payment Id 30486 for invoice:70893, receipt:  by A.A Rano Nigeria Limited','2018-12-14 14:35:14','',''),('1','72',707793,'','customer','1740',97020.00,0.00,'Payment Id 30487 for invoice:70896, receipt:  by A.A Rano Nigeria Limited','2018-12-14 14:35:28','',''),('1','72',707794,'','supplier','98',0.00,97020.00,'Payment Id 30487 for invoice:70896, receipt:  by A.A Rano Nigeria Limited','2018-12-14 14:35:28','',''),('1','72',707797,'','customer','1740',199965.00,0.00,'Payment Id 30489 for invoice:71086, receipt:  by A.A Rano Nigeria Limited','2018-12-14 14:35:44','',''),('1','72',707798,'','supplier','98',0.00,199965.00,'Payment Id 30489 for invoice:71086, receipt:  by A.A Rano Nigeria Limited','2018-12-14 14:35:44','',''),('1','72',709958,'','customer','1740',88930.00,0.00,'Payment Id 31075 for invoice:71118, receipt:  by A.A Rano Nigeria Limited','2018-12-17 14:33:36','',''),('1','72',709959,'','supplier','98',0.00,88930.00,'Payment Id 31075 for invoice:71118, receipt:  by A.A Rano Nigeria Limited','2018-12-17 14:33:36','',''),('1','72',709960,'','customer','1740',163265.00,0.00,'Payment Id 31076 for invoice:71373, receipt:  by A.A Rano Nigeria Limited','2018-12-17 14:33:50','',''),('1','72',709961,'','supplier','98',0.00,163265.00,'Payment Id 31076 for invoice:71373, receipt:  by A.A Rano Nigeria Limited','2018-12-17 14:33:50','',''),('1','72',709962,'','customer','1740',157430.00,0.00,'Payment Id 31077 for invoice:71374, receipt:  by A.A Rano Nigeria Limited','2018-12-17 14:34:05','',''),('1','72',709963,'','supplier','98',0.00,157430.00,'Payment Id 31077 for invoice:71374, receipt:  by A.A Rano Nigeria Limited','2018-12-17 14:34:05','',''),('1','72',709964,'','customer','1740',187610.00,0.00,'Payment Id 31078 for invoice:71508, receipt:  by A.A Rano Nigeria Limited','2018-12-17 14:34:17','',''),('1','72',709965,'','supplier','98',0.00,187610.00,'Payment Id 31078 for invoice:71508, receipt:  by A.A Rano Nigeria Limited','2018-12-17 14:34:17','',''),('1','72',710657,'','customer','1740',418615.00,0.00,'Payment Id 31079 for invoice:71508, receipt:  by A.A Rano Nigeria Limited','2018-12-18 11:06:44','',''),('1','72',710658,'','supplier','98',0.00,418615.00,'Payment Id 31079 for invoice:71508, receipt:  by A.A Rano Nigeria Limited','2018-12-18 11:06:44','',''),('1','72',710659,'','customer','1740',453635.00,0.00,'Payment Id 31614 for invoice:71638, receipt:  by A.A Rano Nigeria Limited','2018-12-18 11:07:02','',''),('1','72',710660,'','supplier','98',0.00,453635.00,'Payment Id 31614 for invoice:71638, receipt:  by A.A Rano Nigeria Limited','2018-12-18 11:07:02','',''),('1','72',710661,'','customer','1740',426735.00,0.00,'Payment Id 31616 for invoice:72177, receipt:  by A.A Rano Nigeria Limited','2018-12-18 11:07:20','',''),('1','72',710662,'','supplier','98',0.00,426735.00,'Payment Id 31616 for invoice:72177, receipt:  by A.A Rano Nigeria Limited','2018-12-18 11:07:20','',''),('1','72',715712,'','supplier','98',3000000.00,0.00,'Purchase Id 27398 for 12,000 litters of AGO - 002 from A.A Rano Nigeria Limited','2018-12-24 15:45:23','',''),('1','72',715742,'','customer','1740',88700.00,0.00,'Payment Id 31821 for invoice:72179, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:39:49','',''),('1','72',715743,'','supplier','98',0.00,88700.00,'Payment Id 31821 for invoice:72179, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:39:49','',''),('1','72',715744,'','customer','1740',290025.00,0.00,'Payment Id 31822 for invoice:72206, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:40:20','',''),('1','72',715745,'','supplier','98',0.00,290025.00,'Payment Id 31822 for invoice:72206, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:40:20','',''),('1','72',715746,'','customer','1740',142305.00,0.00,'Payment Id 32090 for invoice:72209, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:40:34','',''),('1','72',715747,'','supplier','98',0.00,142305.00,'Payment Id 32090 for invoice:72209, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:40:34','',''),('1','72',715748,'','customer','1740',265270.00,0.00,'Payment Id 32851 for invoice:72489, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:40:48','',''),('1','72',715749,'','supplier','98',0.00,265270.00,'Payment Id 32851 for invoice:72489, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:40:48','',''),('1','72',715750,'','customer','1740',210255.00,0.00,'Payment Id 32852 for invoice:72713, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:41:02','',''),('1','72',715751,'','supplier','98',0.00,210255.00,'Payment Id 32852 for invoice:72713, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:41:02','',''),('1','72',715752,'','customer','1740',134015.00,0.00,'Payment Id 32857 for invoice:72799, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:41:30','',''),('1','72',715753,'','supplier','98',0.00,134015.00,'Payment Id 32857 for invoice:72799, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:41:30','',''),('1','72',715754,'','customer','1740',213810.00,0.00,'Payment Id 32858 for invoice:72801, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:41:50','',''),('1','72',715755,'','supplier','98',0.00,213810.00,'Payment Id 32858 for invoice:72801, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:41:50','',''),('1','72',715756,'','customer','1740',193600.00,0.00,'Payment Id 32861 for invoice:72955, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:42:04','',''),('1','72',715757,'','supplier','98',0.00,193600.00,'Payment Id 32861 for invoice:72955, receipt:  by A.A Rano Nigeria Limited','2018-12-24 16:42:04','',''),('1','72',729837,'','supplier','98',3600000.00,0.00,'Purchase Id 27944 for 15,000 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-01-09 12:53:04','',''),('1','72',730149,'','customer','1740',164130.00,0.00,'Payment Id 33368 for invoice:73086, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:33:26','',''),('1','72',730150,'','supplier','98',0.00,164130.00,'Payment Id 33368 for invoice:73086, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:33:26','',''),('1','72',730153,'','customer','1740',19550.00,0.00,'Payment Id 33369 for invoice:73203, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:34:02','',''),('1','72',730154,'','supplier','98',0.00,19550.00,'Payment Id 33369 for invoice:73203, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:34:02','',''),('1','72',730158,'','customer','1740',35560.00,0.00,'Payment Id 33374 for invoice:73206, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:34:35','',''),('1','72',730159,'','supplier','98',0.00,35560.00,'Payment Id 33374 for invoice:73206, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:34:35','',''),('1','72',730169,'','customer','1740',166455.00,0.00,'Payment Id 33375 for invoice:73319, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:35:10','',''),('1','72',730170,'','supplier','98',0.00,166455.00,'Payment Id 33375 for invoice:73319, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:35:10','',''),('1','72',730171,'','customer','1740',317350.00,0.00,'Payment Id 33690 for invoice:73410, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:35:37','',''),('1','72',730172,'','supplier','98',0.00,317350.00,'Payment Id 33690 for invoice:73410, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:35:37','',''),('1','72',730175,'','customer','1740',353955.00,0.00,'Payment Id 34185 for invoice:73567, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:36:06','',''),('1','72',730176,'','supplier','98',0.00,353955.00,'Payment Id 34185 for invoice:73567, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:36:06','',''),('1','72',730177,'','customer','1740',170935.00,0.00,'Payment Id 34186 for invoice:73748, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:36:27','',''),('1','72',730178,'','supplier','98',0.00,170935.00,'Payment Id 34186 for invoice:73748, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:36:27','',''),('1','72',730181,'','customer','1740',118160.00,0.00,'Payment Id 34188 for invoice:73750, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:36:54','',''),('1','72',730182,'','supplier','98',0.00,118160.00,'Payment Id 34188 for invoice:73750, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:36:54','',''),('1','72',730183,'','customer','1740',200000.00,0.00,'Payment Id 34190 for invoice:73750, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:37:10','',''),('1','72',730184,'','supplier','98',0.00,200000.00,'Payment Id 34190 for invoice:73750, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:37:10','',''),('1','72',730189,'','customer','1740',304075.00,0.00,'Payment Id 35118 for invoice:73868, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:37:27','',''),('1','72',730190,'','supplier','98',0.00,304075.00,'Payment Id 35118 for invoice:73868, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:37:27','',''),('1','72',730191,'','customer','1740',200000.00,0.00,'Payment Id 35119 for invoice:73868, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:37:58','',''),('1','72',730192,'','supplier','98',0.00,200000.00,'Payment Id 35119 for invoice:73868, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:37:58','',''),('1','72',730193,'','customer','1740',168320.00,0.00,'Payment Id 35120 for invoice:74467, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:38:21','',''),('1','72',730194,'','supplier','98',0.00,168320.00,'Payment Id 35120 for invoice:74467, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:38:21','',''),('1','72',730197,'','customer','1740',196055.00,0.00,'Payment Id 35121 for invoice:74468, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:38:41','',''),('1','72',730198,'','supplier','98',0.00,196055.00,'Payment Id 35121 for invoice:74468, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:38:41','',''),('1','72',730202,'','customer','1740',319175.00,0.00,'Payment Id 35122 for invoice:74469, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:39:02','',''),('1','72',730203,'','supplier','98',0.00,319175.00,'Payment Id 35122 for invoice:74469, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:39:02','',''),('1','72',730210,'','customer','1740',168320.00,0.00,'Payment Id 35123 for invoice:74469, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:39:45','',''),('1','72',730211,'','supplier','98',0.00,168320.00,'Payment Id 35123 for invoice:74469, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:39:45','',''),('1','72',730214,'','customer','1740',282100.00,0.00,'Payment Id 35581 for invoice:74470, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:40:23','',''),('1','72',730215,'','supplier','98',0.00,282100.00,'Payment Id 35581 for invoice:74470, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:40:23','',''),('1','72',730220,'','customer','1740',129725.00,0.00,'Payment Id 35875 for invoice:74585, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:41:00','',''),('1','72',730221,'','supplier','98',0.00,129725.00,'Payment Id 35875 for invoice:74585, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:41:00','',''),('1','72',730224,'','customer','1740',122425.00,0.00,'Payment Id 35876 for invoice:74586, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:41:22','',''),('1','72',730225,'','supplier','98',0.00,122425.00,'Payment Id 35876 for invoice:74586, receipt:  by A.A Rano Nigeria Limited','2019-01-09 14:41:22','',''),('1','72',732149,'','customer','1740',247100.00,0.00,'Payment Id 36060 for invoice:74705, receipt:  by A.A Rano Nigeria Limited','2019-01-11 14:02:54','',''),('1','72',732150,'','supplier','98',0.00,247100.00,'Payment Id 36060 for invoice:74705, receipt:  by A.A Rano Nigeria Limited','2019-01-11 14:02:54','',''),('1','72',737495,'','customer','1740',196345.00,0.00,'Payment Id 36912 for invoice:75233, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:51:41','',''),('1','72',737496,'','supplier','98',0.00,196345.00,'Payment Id 36912 for invoice:75233, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:51:41','',''),('1','72',737497,'','customer','1740',316185.00,0.00,'Payment Id 36909 for invoice:75100, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:52:00','',''),('1','72',737498,'','supplier','98',0.00,316185.00,'Payment Id 36909 for invoice:75100, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:52:00','',''),('1','72',737503,'','customer','1740',180025.00,0.00,'Payment Id 36904 for invoice:75050, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:52:14','',''),('1','72',737504,'','supplier','98',0.00,180025.00,'Payment Id 36904 for invoice:75050, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:52:14','',''),('1','72',737505,'','customer','1740',281045.00,0.00,'Payment Id 36428 for invoice:75048, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:52:28','',''),('1','72',737506,'','supplier','98',0.00,281045.00,'Payment Id 36428 for invoice:75048, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:52:28','',''),('1','72',737507,'','customer','1740',181810.00,0.00,'Payment Id 37170 for invoice:75365, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:52:46','',''),('1','72',737508,'','supplier','98',0.00,181810.00,'Payment Id 37170 for invoice:75365, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:52:46','',''),('1','72',737509,'','customer','1740',58930.00,0.00,'Payment Id 37211 for invoice:75446, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:53:01','',''),('1','72',737510,'','supplier','98',0.00,58930.00,'Payment Id 37211 for invoice:75446, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:53:01','',''),('1','72',737511,'','customer','1740',108600.00,0.00,'Payment Id 37214 for invoice:75595, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:53:19','',''),('1','72',737512,'','supplier','98',0.00,108600.00,'Payment Id 37214 for invoice:75595, receipt:  by A.A Rano Nigeria Limited','2019-01-16 16:53:19','',''),('1','72',740428,'','customer','1740',190000.00,0.00,'Payment Id 37333 for invoice:75737, receipt:  by A.A Rano Nigeria Limited','2019-01-19 16:13:24','',''),('1','72',740429,'','supplier','98',0.00,190000.00,'Payment Id 37333 for invoice:75737, receipt:  by A.A Rano Nigeria Limited','2019-01-19 16:13:24','',''),('1','72',740430,'','customer','1740',165345.00,0.00,'Payment Id 37637 for invoice:75811, receipt:  by A.A Rano Nigeria Limited','2019-01-19 16:13:34','',''),('1','72',740431,'','supplier','98',0.00,165345.00,'Payment Id 37637 for invoice:75811, receipt:  by A.A Rano Nigeria Limited','2019-01-19 16:13:34','',''),('1','72',740432,'','customer','1740',301265.00,0.00,'Payment Id 37736 for invoice:76011, receipt:  by A.A Rano Nigeria Limited','2019-01-19 16:13:45','',''),('1','72',740433,'','supplier','98',0.00,301265.00,'Payment Id 37736 for invoice:76011, receipt:  by A.A Rano Nigeria Limited','2019-01-19 16:13:45','',''),('1','72',743871,'','supplier','98',4740000.00,0.00,'Purchase Id 28594 for 19,750 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-01-24 08:30:40','',''),('1','72',744143,'','customer','1740',432335.00,0.00,'Payment Id 38893 for invoice:7605, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:28:28','',''),('1','72',744144,'','supplier','98',0.00,432335.00,'Payment Id 38893 for invoice:7605, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:28:28','',''),('1','72',744159,'','customer','1740',128970.00,0.00,'Payment Id 38897 for invoice:76689, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:29:02','',''),('1','72',744160,'','supplier','98',0.00,128970.00,'Payment Id 38897 for invoice:76689, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:29:02','',''),('1','72',744161,'','customer','1740',283995.00,0.00,'Payment Id 38898 for invoice:76691, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:29:40','',''),('1','72',744162,'','supplier','98',0.00,283995.00,'Payment Id 38898 for invoice:76691, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:29:40','',''),('1','72',744163,'','customer','1740',147950.00,0.00,'Payment Id 38900 for invoice:76692, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:30:17','',''),('1','72',744164,'','supplier','98',0.00,147950.00,'Payment Id 38900 for invoice:76692, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:30:17','',''),('1','72',744248,'','customer','1740',350000.00,0.00,'Payment Id 38901 for invoice:76692, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:45:39','',''),('1','72',744249,'','supplier','98',0.00,350000.00,'Payment Id 38901 for invoice:76692, receipt:  by A.A Rano Nigeria Limited','2019-01-24 10:45:39','',''),('1','72',749256,'','customer','1740',473835.00,0.00,'Payment Id 39213 for invoice:76693, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:08:51','',''),('1','72',749257,'','supplier','98',0.00,473835.00,'Payment Id 39213 for invoice:76693, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:08:51','',''),('1','72',749258,'','customer','1740',215880.00,0.00,'Payment Id 39777 for invoice:76903, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:09:07','',''),('1','72',749259,'','supplier','98',0.00,215880.00,'Payment Id 39777 for invoice:76903, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:09:07','',''),('1','72',749260,'','customer','1740',125010.00,0.00,'Payment Id 39779 for invoice:77064, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:09:23','',''),('1','72',749261,'','supplier','98',0.00,125010.00,'Payment Id 39779 for invoice:77064, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:09:23','',''),('1','72',749262,'','customer','1740',14600.00,0.00,'Payment Id 39781 for invoice:76933, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:10:05','',''),('1','72',749263,'','supplier','98',0.00,14600.00,'Payment Id 39781 for invoice:76933, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:10:05','',''),('1','72',749264,'','customer','1740',170500.00,0.00,'Payment Id 39784 for invoice:77066, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:10:27','',''),('1','72',749265,'','supplier','98',0.00,170500.00,'Payment Id 39784 for invoice:77066, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:10:27','',''),('1','72',749266,'','customer','1740',65860.00,0.00,'Payment Id 39861 for invoice:77272, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:10:43','',''),('1','72',749267,'','supplier','98',0.00,65860.00,'Payment Id 39861 for invoice:77272, receipt:  by A.A Rano Nigeria Limited','2019-01-29 16:10:43','',''),('1','72',759157,'','supplier','98',7425000.00,0.00,'Purchase Id 29163 for 33,000 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-02-08 13:59:44','',''),('1','72',759302,'','customer','1740',9670.00,0.00,'Payment Id 40455 for invoice:77315, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:21:45','',''),('1','72',759303,'','supplier','98',0.00,9670.00,'Payment Id 40455 for invoice:77315, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:21:45','',''),('1','72',759306,'','customer','1740',65050.00,0.00,'Payment Id 40457 for invoice:77462, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:22:14','',''),('1','72',759307,'','supplier','98',0.00,65050.00,'Payment Id 40457 for invoice:77462, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:22:14','',''),('1','72',759312,'','customer','1740',26150.00,0.00,'Payment Id 32855 for invoice:72718, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:24:03','',''),('1','72',759313,'','supplier','98',0.00,26150.00,'Payment Id 32855 for invoice:72718, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:24:03','',''),('1','72',759314,'','customer','1740',315680.00,0.00,'Payment Id 40459 for invoice:77463, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:24:35','',''),('1','72',759315,'','supplier','98',0.00,315680.00,'Payment Id 40459 for invoice:77463, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:24:35','',''),('1','72',759316,'','customer','1740',286000.00,0.00,'Payment Id 40530 for invoice:77687, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:25:00','',''),('1','72',759317,'','supplier','98',0.00,286000.00,'Payment Id 40530 for invoice:77687, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:25:00','',''),('1','72',759318,'','customer','1740',185690.00,0.00,'Payment Id 41195 for invoice:77689, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:25:16','',''),('1','72',759319,'','supplier','98',0.00,185690.00,'Payment Id 41195 for invoice:77689, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:25:16','',''),('1','72',759320,'','customer','1740',63500.00,0.00,'Payment Id 41196 for invoice:77823, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:25:31','',''),('1','72',759321,'','supplier','98',0.00,63500.00,'Payment Id 41196 for invoice:77823, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:25:31','',''),('1','72',759322,'','customer','1740',250070.00,0.00,'Payment Id 41197 for invoice:78030, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:26:18','',''),('1','72',759323,'','supplier','98',0.00,250070.00,'Payment Id 41197 for invoice:78030, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:26:18','',''),('1','72',759324,'','customer','1740',259680.00,0.00,'Payment Id 41198 for invoice:78034, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:28:00','',''),('1','72',759325,'','supplier','98',0.00,259680.00,'Payment Id 41198 for invoice:78034, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:28:00','',''),('1','72',759326,'','customer','1740',215345.00,0.00,'Payment Id 41548 for invoice:78192, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:28:11','',''),('1','72',759327,'','supplier','98',0.00,215345.00,'Payment Id 41548 for invoice:78192, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:28:11','',''),('1','72',759328,'','customer','1740',152095.00,0.00,'Payment Id 41752 for invoice:78387, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:28:36','',''),('1','72',759329,'','supplier','98',0.00,152095.00,'Payment Id 41752 for invoice:78387, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:28:36','',''),('1','72',759330,'','customer','1740',548735.00,0.00,'Payment Id 42027 for invoice:78479, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:29:39','',''),('1','72',759331,'','supplier','98',0.00,548735.00,'Payment Id 42027 for invoice:78479, receipt:  by A.A Rano Nigeria Limited','2019-02-08 15:29:39','',''),('1','72',766880,'','customer','1740',231100.00,0.00,'Payment Id 42707 for invoice:78943, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:09:15','',''),('1','72',766881,'','supplier','98',0.00,231100.00,'Payment Id 42707 for invoice:78943, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:09:15','',''),('1','72',766884,'','customer','1740',83870.00,0.00,'Payment Id 42709 for invoice:78944, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:09:29','',''),('1','72',766885,'','supplier','98',0.00,83870.00,'Payment Id 42709 for invoice:78944, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:09:29','',''),('1','72',766886,'','customer','1740',146450.00,0.00,'Payment Id 42906 for invoice:78945, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:09:44','',''),('1','72',766887,'','supplier','98',0.00,146450.00,'Payment Id 42906 for invoice:78945, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:09:44','',''),('1','72',766892,'','customer','1740',45690.00,0.00,'Payment Id 42908 for invoice:79065, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:10:11','',''),('1','72',766893,'','supplier','98',0.00,45690.00,'Payment Id 42908 for invoice:79065, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:10:11','',''),('1','72',766894,'','customer','1740',179255.00,0.00,'Payment Id 43391 for invoice:79236, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:10:24','',''),('1','72',766895,'','supplier','98',0.00,179255.00,'Payment Id 43391 for invoice:79236, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:10:24','',''),('1','72',766896,'','customer','1740',747595.00,0.00,'Payment Id 43392 for invoice:79236, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:10:49','',''),('1','72',766897,'','supplier','98',0.00,747595.00,'Payment Id 43392 for invoice:79236, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:10:49','',''),('1','72',766898,'','customer','1740',184350.00,0.00,'Payment Id 44076 for invoice:79453, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:13:48','',''),('1','72',766899,'','supplier','98',0.00,184350.00,'Payment Id 44076 for invoice:79453, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:13:48','',''),('1','72',766900,'','customer','1740',114585.00,0.00,'Payment Id 42272 for invoice:78655, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:15:04','',''),('1','72',766901,'','supplier','98',0.00,114585.00,'Payment Id 42272 for invoice:78655, receipt:  by A.A Rano Nigeria Limited','2019-02-18 13:15:04','',''),('1','72',767631,'','customer','1388',0.00,115500.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',767632,'','obe','obe',115500.00,0.00,'Opening balance of customer# 1388','0000-00-00 00:00:00','',''),('1','72',767773,'','customer','1386',0.00,302750.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',767774,'','obe','obe',302750.00,0.00,'Opening balance of customer# 1386','0000-00-00 00:00:00','',''),('1','72',767777,'','customer','1385',0.00,228500.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',767778,'','obe','obe',228500.00,0.00,'Opening balance of customer# 1385','0000-00-00 00:00:00','',''),('1','72',767781,'','customer','1384',0.00,72480.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',767782,'','obe','obe',72480.00,0.00,'Opening balance of customer# 1384','0000-00-00 00:00:00','',''),('1','72',767795,'','customer','1383',0.00,30000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',767796,'','obe','obe',30000.00,0.00,'Opening balance of customer# 1383','0000-00-00 00:00:00','',''),('1','72',767809,'','customer','1382',0.00,387885.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',767810,'','obe','obe',387885.00,0.00,'Opening balance of customer# 1382','0000-00-00 00:00:00','',''),('1','72',767811,'','customer','1380',0.00,343000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',767812,'','obe','obe',343000.00,0.00,'Opening balance of customer# 1380','0000-00-00 00:00:00','',''),('1','72',767813,'','customer','1379',0.00,140450.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',767814,'','obe','obe',140450.00,0.00,'Opening balance of customer# 1379','0000-00-00 00:00:00','',''),('1','72',768017,'','customer','1740',104175.00,0.00,'Payment Id 44168 for invoice:79457, receipt:  by A.A Rano Nigeria Limited','2019-02-19 16:21:16','',''),('1','72',768018,'','supplier','98',0.00,104175.00,'Payment Id 44168 for invoice:79457, receipt:  by A.A Rano Nigeria Limited','2019-02-19 16:21:16','',''),('1','72',768019,'','customer','1740',166890.00,0.00,'Payment Id 44169 for invoice:79929, receipt:  by A.A Rano Nigeria Limited','2019-02-19 16:21:32','',''),('1','72',768020,'','supplier','98',0.00,166890.00,'Payment Id 44169 for invoice:79929, receipt:  by A.A Rano Nigeria Limited','2019-02-19 16:21:32','',''),('1','72',768061,'','customer','1381',0.00,30000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768062,'','obe','obe',30000.00,0.00,'Opening balance of customer# 1381','0000-00-00 00:00:00','',''),('1','72',768063,'','customer','1383',30000.00,0.00,'Old opening balance','0000-00-00 00:00:00','',''),('1','72',768064,'','obe','obe',0.00,30000.00,'Old Opening balance of customer# 1383','0000-00-00 00:00:00','',''),('1','72',768065,'','customer','1383',0.00,8000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768066,'','obe','obe',8000.00,0.00,'Opening balance of customer# 1383','0000-00-00 00:00:00','',''),('1','72',768748,'','customer','1418',0.00,27500.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768749,'','obe','obe',27500.00,0.00,'Opening balance of customer# 1418','0000-00-00 00:00:00','',''),('1','72',768750,'','customer','1417',0.00,46500.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768751,'','obe','obe',46500.00,0.00,'Opening balance of customer# 1417','0000-00-00 00:00:00','',''),('1','72',768752,'','customer','1419',0.00,70000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768753,'','obe','obe',70000.00,0.00,'Opening balance of customer# 1419','0000-00-00 00:00:00','',''),('1','72',768754,'','customer','1420',0.00,99900.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768755,'','obe','obe',99900.00,0.00,'Opening balance of customer# 1420','0000-00-00 00:00:00','',''),('1','72',768756,'','customer','1421',0.00,60000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768757,'','obe','obe',60000.00,0.00,'Opening balance of customer# 1421','0000-00-00 00:00:00','',''),('1','72',768758,'','customer','1422',0.00,144500.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768759,'','obe','obe',144500.00,0.00,'Opening balance of customer# 1422','0000-00-00 00:00:00','',''),('1','72',768760,'','customer','1423',0.00,276000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768761,'','obe','obe',276000.00,0.00,'Opening balance of customer# 1423','0000-00-00 00:00:00','',''),('1','72',768762,'','customer','1424',0.00,44800.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768763,'','obe','obe',44800.00,0.00,'Opening balance of customer# 1424','0000-00-00 00:00:00','',''),('1','72',768764,'','customer','1425',0.00,19000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768765,'','obe','obe',19000.00,0.00,'Opening balance of customer# 1425','0000-00-00 00:00:00','',''),('1','72',768766,'','customer','1426',0.00,45000.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768767,'','obe','obe',45000.00,0.00,'Opening balance of customer# 1426','0000-00-00 00:00:00','',''),('1','72',768774,'','customer','1427',0.00,196900.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',768775,'','obe','obe',196900.00,0.00,'Opening balance of customer# 1427','0000-00-00 00:00:00','',''),('1','72',768782,'','customer','1740',190515.00,0.00,'Payment Id 44471 for invoice:79930, receipt:  by A.A Rano Nigeria Limited','2019-02-20 12:52:18','',''),('1','72',768783,'','supplier','98',0.00,190515.00,'Payment Id 44471 for invoice:79930, receipt:  by A.A Rano Nigeria Limited','2019-02-20 12:52:18','',''),('1','72',768786,'','customer','1740',130430.00,0.00,'Payment Id 44472 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 12:54:29','',''),('1','72',768787,'','supplier','98',0.00,130430.00,'Payment Id 44472 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 12:54:29','',''),('1','72',768788,'','customer','1740',107000.00,0.00,'Payment Id 44473 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 12:54:52','',''),('1','72',768789,'','supplier','98',0.00,107000.00,'Payment Id 44473 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 12:54:52','',''),('1','72',768792,'','customer','1740',70000.00,0.00,'Payment Id 44474 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:00:50','',''),('1','72',768793,'','supplier','98',0.00,70000.00,'Payment Id 44474 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:00:50','',''),('1','72',768796,'','customer','1740',58000.00,0.00,'Payment Id 44475 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:03:08','',''),('1','72',768797,'','supplier','98',0.00,58000.00,'Payment Id 44475 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:03:08','',''),('1','72',768798,'','customer','1740',112500.00,0.00,'Payment Id 44476 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:05:40','',''),('1','72',768799,'','supplier','98',0.00,112500.00,'Payment Id 44476 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:05:40','',''),('1','72',768800,'','customer','1740',35000.00,0.00,'Payment Id 44477 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:06:18','',''),('1','72',768801,'','supplier','98',0.00,35000.00,'Payment Id 44477 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:06:18','',''),('1','72',768804,'','customer','1740',125450.00,0.00,'Payment Id 44478 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:08:59','',''),('1','72',768805,'','supplier','98',0.00,125450.00,'Payment Id 44478 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:08:59','',''),('1','72',768808,'','customer','1740',20000.00,0.00,'Payment Id 44479 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:09:14','',''),('1','72',768809,'','supplier','98',0.00,20000.00,'Payment Id 44479 for invoice:79931, receipt:  by A.A Rano Nigeria Limited','2019-02-20 13:09:14','',''),('1','72',769212,'','customer','1427',125450.00,0.00,'Payment Id 77724 for invoice:, receipt:  by CONCENSUS MOTORS TRANSPORT','2019-02-20 15:45:26','',''),('1','72',769229,'','customer','1382',20000.00,0.00,'Payment Id 77729 for invoice:, receipt:  by A.A.Y MOTORS COMP.','2019-02-20 15:51:56','',''),('1','72',769231,'','customer','1386',107000.00,0.00,'Payment Id 77727 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-02-20 15:52:15','',''),('1','72',769380,'','customer','1428',0.00,112500.00,'Opening balance','0000-00-00 00:00:00','',''),('1','72',769381,'','obe','obe',112500.00,0.00,'Opening balance of customer# 1428','0000-00-00 00:00:00','',''),('1','72',772636,'','customer','1379',90000.00,0.00,'Payment Id 77728 for invoice:, receipt:  by CONCENSUS MOTORS','2019-02-25 17:13:34','',''),('1','72',772638,'','customer','1427',10000.00,0.00,'Payment Id 77725 for invoice:, receipt:  by CONCENSUS MOTORS TRANSPORT','2019-02-25 17:13:53','',''),('1','72',772640,'','customer','1382',100000.00,0.00,'Payment Id 77752 for invoice:, receipt:  by A.A.Y MOTORS COMP.','2019-02-25 17:14:24','',''),('1','72',772642,'','customer','1388',60000.00,0.00,'Payment Id 77753 for invoice:, receipt:  by B. A. L MOTORS 1','2019-02-25 17:14:53','',''),('1','72',772644,'','customer','1385',213500.00,0.00,'Payment Id 77751 for invoice:, receipt:  by ALIYU TRANSPORT','2019-02-25 17:15:03','',''),('1','72',772646,'','customer','1424',15000.00,0.00,'Payment Id 77754 for invoice:, receipt:  by BARA BARAU','2019-02-25 17:15:25','',''),('1','72',772650,'','customer','1381',20000.00,0.00,'Payment Id 77764 for invoice:, receipt:  by SHAFIU TRASPORT','2019-02-25 17:17:30','',''),('1','72',772652,'','customer','1420',30000.00,0.00,'Payment Id 77765 for invoice:, receipt:  by DANGUGUA TRASPORT','2019-02-25 17:17:41','',''),('1','72',774363,'','customer','1740',128115.00,0.00,'Payment Id 44663 for invoice:79932, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:08:16','',''),('1','72',774364,'','supplier','98',0.00,128115.00,'Payment Id 44663 for invoice:79932, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:08:16','',''),('1','72',774383,'','customer','1740',56640.00,0.00,'Payment Id 44664 for invoice:80134, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:10:50','',''),('1','72',774384,'','supplier','98',0.00,56640.00,'Payment Id 44664 for invoice:80134, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:10:50','',''),('1','72',774385,'','customer','1740',90000.00,0.00,'Payment Id 44683 for invoice:80134, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:11:27','',''),('1','72',774386,'','supplier','98',0.00,90000.00,'Payment Id 44683 for invoice:80134, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:11:27','',''),('1','72',774389,'','customer','1740',10000.00,0.00,'Payment Id 44684 for invoice:80134, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:11:52','',''),('1','72',774390,'','supplier','98',0.00,10000.00,'Payment Id 44684 for invoice:80134, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:11:52','',''),('1','72',774391,'','customer','1740',59585.00,0.00,'Payment Id 44929 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:12:51','',''),('1','72',774392,'','supplier','98',0.00,59585.00,'Payment Id 44929 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:12:51','',''),('1','72',774393,'','customer','1740',100000.00,0.00,'Payment Id 44932 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:13:29','',''),('1','72',774394,'','supplier','98',0.00,100000.00,'Payment Id 44932 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:13:29','',''),('1','72',774395,'','customer','1740',213500.00,0.00,'Payment Id 44934 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:15:00','',''),('1','72',774396,'','supplier','98',0.00,213500.00,'Payment Id 44934 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:15:00','',''),('1','72',774399,'','customer','1740',15000.00,0.00,'Payment Id 44936 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:15:32','',''),('1','72',774400,'','supplier','98',0.00,15000.00,'Payment Id 44936 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:15:32','',''),('1','72',774403,'','customer','1740',60000.00,0.00,'Payment Id 44939 for invoice:8O238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:16:24','',''),('1','72',774404,'','supplier','98',0.00,60000.00,'Payment Id 44939 for invoice:8O238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:16:24','',''),('1','72',774405,'','customer','1740',2500.00,0.00,'Payment Id 45111 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:16:35','',''),('1','72',774406,'','supplier','98',0.00,2500.00,'Payment Id 45111 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:16:35','',''),('1','72',774407,'','customer','1740',30000.00,0.00,'Payment Id 45112 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:17:03','',''),('1','72',774408,'','supplier','98',0.00,30000.00,'Payment Id 45112 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:17:03','',''),('1','72',774409,'','customer','1740',20000.00,0.00,'Payment Id 45113 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:17:27','',''),('1','72',774410,'','supplier','98',0.00,20000.00,'Payment Id 45113 for invoice:80238, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:17:27','',''),('1','72',774411,'','customer','1740',25720.00,0.00,'Payment Id 45512 for invoice:80378, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:17:52','',''),('1','72',774412,'','supplier','98',0.00,25720.00,'Payment Id 45512 for invoice:80378, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:17:52','',''),('1','72',774415,'','customer','1740',23480.00,0.00,'Payment Id 45514 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:18:52','',''),('1','72',774416,'','supplier','98',0.00,23480.00,'Payment Id 45514 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:18:52','',''),('1','72',774419,'','customer','1740',91450.00,0.00,'Payment Id 45513 for invoice:80465, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:19:07','',''),('1','72',774420,'','supplier','98',0.00,91450.00,'Payment Id 45513 for invoice:80465, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:19:07','',''),('1','72',774421,'','customer','1740',90000.00,0.00,'Payment Id 45515 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:19:24','',''),('1','72',774422,'','supplier','98',0.00,90000.00,'Payment Id 45515 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:19:24','',''),('1','72',774423,'','customer','1740',8000.00,0.00,'Payment Id 45516 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:19:43','',''),('1','72',774424,'','supplier','98',0.00,8000.00,'Payment Id 45516 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:19:43','',''),('1','72',774425,'','customer','1740',75000.00,0.00,'Payment Id 45520 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:19:56','',''),('1','72',774426,'','supplier','98',0.00,75000.00,'Payment Id 45520 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:19:56','',''),('1','72',774427,'','customer','1740',200000.00,0.00,'Payment Id 45524 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:20:12','',''),('1','72',774428,'','supplier','98',0.00,200000.00,'Payment Id 45524 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:20:12','',''),('1','72',774429,'','customer','1740',20000.00,0.00,'Payment Id 45525 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:20:24','',''),('1','72',774430,'','supplier','98',0.00,20000.00,'Payment Id 45525 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:20:24','',''),('1','72',774431,'','customer','1740',35000.00,0.00,'Payment Id 45526 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:21:16','',''),('1','72',774432,'','supplier','98',0.00,35000.00,'Payment Id 45526 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:21:16','',''),('1','72',774455,'','customer','1740',13000.00,0.00,'Payment Id 45527 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:25:55','',''),('1','72',774456,'','supplier','98',0.00,13000.00,'Payment Id 45527 for invoice:80754, receipt:  by A.A Rano Nigeria Limited','2019-02-26 17:25:55','',''),('1','72',774462,'','customer','1380',90000.00,0.00,'Payment Id 77807 for invoice:, receipt:  by DANMA KAI MOTORS','2019-02-26 17:27:14','',''),('1','72',774464,'','customer','1386',75000.00,0.00,'Payment Id 77808 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-02-26 17:27:39','',''),('1','72',774468,'','customer','1382',35000.00,0.00,'Payment Id 77809 for invoice:, receipt:  by A.A.Y MOTORS COMP.','2019-02-26 17:28:43','',''),('1','72',774470,'','customer','1381',20000.00,0.00,'Payment Id 77810 for invoice:, receipt:  by SHAFIU TRASPORT','2019-02-26 17:29:03','',''),('1','72',774477,'','customer','1423',200000.00,0.00,'Payment Id 77811 for invoice:, receipt:  by ZAMANI IKON ALLAH TRASPORT','2019-02-26 17:29:15','',''),('1','72',777279,'','customer','1740',86680.00,0.00,'Payment Id 45697 for invoice:80755, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:39:33','',''),('1','72',777280,'','supplier','98',0.00,86680.00,'Payment Id 45697 for invoice:80755, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:39:33','',''),('1','72',777281,'','customer','1740',140680.00,0.00,'Payment Id 46175 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:40:09','',''),('1','72',777282,'','supplier','98',0.00,140680.00,'Payment Id 46175 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:40:09','',''),('1','72',777289,'','customer','1740',20000.00,0.00,'Payment Id 46176 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:45:32','',''),('1','72',777290,'','supplier','98',0.00,20000.00,'Payment Id 46176 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:45:32','',''),('1','72',777291,'','customer','1740',134085.00,0.00,'Payment Id 46180 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:45:42','',''),('1','72',777292,'','supplier','98',0.00,134085.00,'Payment Id 46180 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:45:42','',''),('1','72',777293,'','customer','1740',157500.00,0.00,'Payment Id 46184 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:45:53','',''),('1','72',777294,'','supplier','98',0.00,157500.00,'Payment Id 46184 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:45:53','',''),('1','72',777295,'','customer','1740',26000.00,0.00,'Payment Id 46188 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:46:04','',''),('1','72',777296,'','supplier','98',0.00,26000.00,'Payment Id 46188 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:46:04','',''),('1','72',777299,'','customer','1740',50000.00,0.00,'Payment Id 46190 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:46:17','',''),('1','72',777300,'','supplier','98',0.00,50000.00,'Payment Id 46190 for invoice:81143, receipt:  by A.A Rano Nigeria Limited','2019-02-28 16:46:17','',''),('1','72',777304,'','customer','1380',157500.00,0.00,'Payment Id 77864 for invoice:, receipt:  by DANMA KAI MOTORS','2019-02-28 16:46:48','',''),('1','72',777306,'','customer','1423',26000.00,0.00,'Payment Id 77865 for invoice:, receipt:  by ZAMANI IKON ALLAH TRASPORT','2019-02-28 16:46:56','',''),('1','72',777308,'','customer','1384',50000.00,0.00,'Payment Id 77866 for invoice:, receipt:  by MAMMAN TRANSPORT','2019-02-28 16:47:01','',''),('1','72',777310,'','customer','1386',20000.00,0.00,'Payment Id 77867 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-02-28 16:47:08','',''),('1','72',779342,'','customer','1382',100000.00,0.00,'Payment Id 77900 for invoice:, receipt:  by A.A.Y MOTORS COMP.','2019-03-02 16:05:21','',''),('1','72',779344,'','customer','1425',10000.00,0.00,'Payment Id 77901 for invoice:, receipt:  by TURA LINE TRASPORT','2019-03-02 16:05:30','',''),('1','72',779345,'','customer','1740',21700.00,0.00,'Payment Id 46435 for invoice:81145, receipt:  by A.A Rano Nigeria Limited','2019-03-02 16:05:52','',''),('1','72',779346,'','supplier','98',0.00,21700.00,'Payment Id 46435 for invoice:81145, receipt:  by A.A Rano Nigeria Limited','2019-03-02 16:05:52','',''),('1','72',779358,'','customer','1740',10000.00,0.00,'Payment Id 46436 for invoice:81145, receipt:  by A.A Rano Nigeria Limited','2019-03-02 16:06:49','',''),('1','72',779359,'','supplier','98',0.00,10000.00,'Payment Id 46436 for invoice:81145, receipt:  by A.A Rano Nigeria Limited','2019-03-02 16:06:49','',''),('1','72',779360,'','customer','1740',100000.00,0.00,'Payment Id 46439 for invoice:81145, receipt:  by A.A Rano Nigeria Limited','2019-03-02 16:07:00','',''),('1','72',779361,'','supplier','98',0.00,100000.00,'Payment Id 46439 for invoice:81145, receipt:  by A.A Rano Nigeria Limited','2019-03-02 16:07:00','',''),('1','72',781242,'','customer','1428',112500.00,0.00,'Payment Id 77909 for invoice:, receipt:  by MUJAHIDA TRANSPORT','2019-03-05 10:14:08','',''),('1','72',781246,'','customer','1386',50000.00,0.00,'Payment Id 77932 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-03-05 10:14:21','',''),('1','72',781248,'','customer','1384',17000.00,0.00,'Payment Id 77944 for invoice:, receipt:  by MAMMAN TRANSPORT','2019-03-05 10:14:32','',''),('1','72',781249,'','customer','1740',31400.00,0.00,'Payment Id 46928 for invoice:81254, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:14:50','',''),('1','72',781250,'','supplier','98',0.00,31400.00,'Payment Id 46928 for invoice:81254, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:14:50','',''),('1','72',781251,'','customer','1740',121210.00,0.00,'Payment Id 46932 for invoice:81484, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:15:02','',''),('1','72',781252,'','supplier','98',0.00,121210.00,'Payment Id 46932 for invoice:81484, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:15:02','',''),('1','72',781253,'','customer','1740',50000.00,0.00,'Payment Id 46934 for invoice:81484, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:15:10','',''),('1','72',781254,'','supplier','98',0.00,50000.00,'Payment Id 46934 for invoice:81484, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:15:10','',''),('1','72',781255,'','customer','1740',16175.00,0.00,'Payment Id 47030 for invoice:81306, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:15:19','',''),('1','72',781256,'','supplier','98',0.00,16175.00,'Payment Id 47030 for invoice:81306, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:15:19','',''),('1','72',781257,'','customer','1740',17000.00,0.00,'Payment Id 47031 for invoice:81306, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:15:29','',''),('1','72',781258,'','supplier','98',0.00,17000.00,'Payment Id 47031 for invoice:81306, receipt:  by A.A Rano Nigeria Limited','2019-03-05 10:15:29','',''),('1','72',784350,'','customer','1386',42000.00,0.00,'Payment Id 77951 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-03-07 16:49:53','',''),('1','72',784352,'','customer','1427',30000.00,0.00,'Payment Id 77964 for invoice:, receipt:  by CONCENSUS MOTORS TRANSPORT','2019-03-07 16:50:05','',''),('1','72',784365,'','customer','1740',57800.00,0.00,'Payment Id 47209 for invoice:81486, receipt:  by A.A Rano Nigeria Limited','2019-03-07 16:57:43','',''),('1','72',784366,'','supplier','98',0.00,57800.00,'Payment Id 47209 for invoice:81486, receipt:  by A.A Rano Nigeria Limited','2019-03-07 16:57:43','',''),('1','72',784367,'','customer','1740',42000.00,0.00,'Payment Id 47210 for invoice:81486, receipt:  by A.A Rano Nigeria Limited','2019-03-07 16:57:52','',''),('1','72',784368,'','supplier','98',0.00,42000.00,'Payment Id 47210 for invoice:81486, receipt:  by A.A Rano Nigeria Limited','2019-03-07 16:57:52','',''),('1','72',784369,'','customer','1740',165055.00,0.00,'Payment Id 47414 for invoice:81624, receipt:  by A.A Rano Nigeria Limited','2019-03-07 16:58:04','',''),('1','72',784370,'','supplier','98',0.00,165055.00,'Payment Id 47414 for invoice:81624, receipt:  by A.A Rano Nigeria Limited','2019-03-07 16:58:04','',''),('1','72',784371,'','customer','1740',30000.00,0.00,'Payment Id 47415 for invoice:81624, receipt:  by A.A Rano Nigeria Limited','2019-03-07 16:58:15','',''),('1','72',784372,'','supplier','98',0.00,30000.00,'Payment Id 47415 for invoice:81624, receipt:  by A.A Rano Nigeria Limited','2019-03-07 16:58:15','',''),('1','72',788594,'','customer','1740',73660.00,0.00,'Payment Id 48440 for invoice:82452, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:29:32','',''),('1','72',788595,'','supplier','98',0.00,73660.00,'Payment Id 48440 for invoice:82452, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:29:32','',''),('1','72',788600,'','customer','1740',77500.00,0.00,'Payment Id 48442 for invoice:82454, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:36:24','',''),('1','72',788601,'','supplier','98',0.00,77500.00,'Payment Id 48442 for invoice:82454, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:36:24','',''),('1','72',788604,'','customer','1740',12500.00,0.00,'Payment Id 48443 for invoice:82457, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:38:07','',''),('1','72',788605,'','supplier','98',0.00,12500.00,'Payment Id 48443 for invoice:82457, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:38:07','',''),('1','72',788606,'','customer','1740',94275.00,0.00,'Payment Id 48445 for invoice:82459, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:38:21','',''),('1','72',788607,'','supplier','98',0.00,94275.00,'Payment Id 48445 for invoice:82459, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:38:21','',''),('1','72',788608,'','customer','1740',166795.00,0.00,'Payment Id 48446 for invoice:82461, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:39:30','',''),('1','72',788609,'','supplier','98',0.00,166795.00,'Payment Id 48446 for invoice:82461, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:39:30','',''),('1','72',788610,'','customer','1740',80000.00,0.00,'Payment Id 48447 for invoice:82461, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:41:29','',''),('1','72',788611,'','supplier','98',0.00,80000.00,'Payment Id 48447 for invoice:82461, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:41:29','',''),('1','72',788631,'','customer','1740',8000.00,0.00,'Payment Id 48448 for invoice:82461, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:49:06','',''),('1','72',788632,'','supplier','98',0.00,8000.00,'Payment Id 48448 for invoice:82461, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:49:06','',''),('1','72',788633,'','customer','1740',5000.00,0.00,'Payment Id 48449 for invoice:82461, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:51:05','',''),('1','72',788634,'','supplier','98',0.00,5000.00,'Payment Id 48449 for invoice:82461, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:51:05','',''),('1','72',788635,'','customer','1740',145750.00,0.00,'Payment Id 48638 for invoice:82462, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:51:22','',''),('1','72',788636,'','supplier','98',0.00,145750.00,'Payment Id 48638 for invoice:82462, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:51:22','',''),('1','72',788639,'','customer','1740',50000.00,0.00,'Payment Id 48640 for invoice:82462, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:51:53','',''),('1','72',788640,'','supplier','98',0.00,50000.00,'Payment Id 48640 for invoice:82462, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:51:53','',''),('1','72',788641,'','customer','1740',20000.00,0.00,'Payment Id 48641 for invoice:82462, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:52:25','',''),('1','72',788642,'','supplier','98',0.00,20000.00,'Payment Id 48641 for invoice:82462, receipt:  by A.A Rano Nigeria Limited','2019-03-13 15:52:25','',''),('1','72',788644,'','customer','1422',80000.00,0.00,'Payment Id 78032 for invoice:, receipt:  by HABIB TRANSPORT','2019-03-13 15:53:48','',''),('1','72',788646,'','customer','1383',8000.00,0.00,'Payment Id 78033 for invoice:, receipt:  by KOFAR RUWA MOTORS','2019-03-13 15:54:12','',''),('1','72',788648,'','customer','1423',50000.00,0.00,'Payment Id 78045 for invoice:, receipt:  by ZAMANI IKON ALLAH TRASPORT','2019-03-13 15:54:35','',''),('1','72',788650,'','customer','1386',20000.00,0.00,'Payment Id 78046 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-03-13 15:54:44','',''),('1','72',795322,'','customer','1419',25000.00,0.00,'Payment Id 78058 for invoice:, receipt:  by HAYIN DAGA TRASPORT','2019-03-19 15:48:54','',''),('1','72',795324,'','customer','1427',30000.00,0.00,'Payment Id 78095 for invoice:, receipt:  by CONCENSUS MOTORS TRANSPORT','2019-03-19 15:49:01','',''),('1','72',795501,'','customer','1740',48125.00,0.00,'Payment Id 48892 for invoice:82564, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:50:43','',''),('1','72',795502,'','supplier','98',0.00,48125.00,'Payment Id 48892 for invoice:82564, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:50:43','',''),('1','72',795503,'','customer','1740',25000.00,0.00,'Payment Id 48894 for invoice:82564, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:51:56','',''),('1','72',795504,'','supplier','98',0.00,25000.00,'Payment Id 48894 for invoice:82564, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:51:56','',''),('1','72',795505,'','customer','1740',13165.00,0.00,'Payment Id 49507 for invoice:82700, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:52:16','',''),('1','72',795506,'','supplier','98',0.00,13165.00,'Payment Id 49507 for invoice:82700, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:52:16','',''),('1','72',795507,'','customer','1740',48590.00,0.00,'Payment Id 49509 for invoice:82876, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:52:31','',''),('1','72',795508,'','supplier','98',0.00,48590.00,'Payment Id 49509 for invoice:82876, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:52:31','',''),('1','72',795513,'','customer','1740',115485.00,0.00,'Payment Id 49512 for invoice:82878, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:53:00','',''),('1','72',795514,'','supplier','98',0.00,115485.00,'Payment Id 49512 for invoice:82878, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:53:00','',''),('1','72',795515,'','customer','1740',30000.00,0.00,'Payment Id 49513 for invoice:82878, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:54:21','',''),('1','72',795516,'','supplier','98',0.00,30000.00,'Payment Id 49513 for invoice:82878, receipt:  by A.A Rano Nigeria Limited','2019-03-19 16:54:21','',''),('1','72',801654,'','customer','1740',36610.00,0.00,'Payment Id 49710 for invoice:83188, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:10:39','',''),('1','72',801655,'','supplier','98',0.00,36610.00,'Payment Id 49710 for invoice:83188, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:10:39','',''),('1','72',801662,'','customer','1740',47445.00,0.00,'Payment Id 50060 for invoice:83190, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:12:14','',''),('1','72',801663,'','supplier','98',0.00,47445.00,'Payment Id 50060 for invoice:83190, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:12:14','',''),('1','72',801664,'','customer','1740',5000.00,0.00,'Payment Id 50064 for invoice:83190, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:16:04','',''),('1','72',801665,'','supplier','98',0.00,5000.00,'Payment Id 50064 for invoice:83190, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:16:04','',''),('1','72',801666,'','customer','1740',63100.00,0.00,'Payment Id 50353 for invoice:83192, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:17:37','',''),('1','72',801667,'','supplier','98',0.00,63100.00,'Payment Id 50353 for invoice:83192, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:17:37','',''),('1','72',801670,'','customer','1740',22900.00,0.00,'Payment Id 50355 for invoice:83415, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:17:50','',''),('1','72',801671,'','supplier','98',0.00,22900.00,'Payment Id 50355 for invoice:83415, receipt:  by A.A Rano Nigeria Limited','2019-03-26 12:17:50','',''),('1','72',801673,'','customer','1379',5000.00,0.00,'Payment Id 78166 for invoice:, receipt:  by CONCENSUS MOTORS','2019-03-26 12:18:58','',''),('1','72',803715,'','customer','1740',5000.00,0.00,'Payment Id 50357 for invoice:83415, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:36:59','',''),('1','72',803716,'','supplier','98',0.00,5000.00,'Payment Id 50357 for invoice:83415, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:36:59','',''),('1','72',803721,'','customer','1740',29180.00,0.00,'Payment Id 51383 for invoice:83580, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:37:44','',''),('1','72',803722,'','supplier','98',0.00,29180.00,'Payment Id 51383 for invoice:83580, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:37:44','',''),('1','72',803725,'','customer','1740',14750.00,0.00,'Payment Id 51385 for invoice:83581, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:38:11','',''),('1','72',803726,'','supplier','98',0.00,14750.00,'Payment Id 51385 for invoice:83581, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:38:11','',''),('1','72',803727,'','customer','1740',21500.00,0.00,'Payment Id 51388 for invoice:84187, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:38:44','',''),('1','72',803728,'','supplier','98',0.00,21500.00,'Payment Id 51388 for invoice:84187, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:38:44','',''),('1','72',803731,'','customer','1740',39660.00,0.00,'Payment Id 51390 for invoice:84188, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:39:11','',''),('1','72',803732,'','supplier','98',0.00,39660.00,'Payment Id 51390 for invoice:84188, receipt:  by A.A Rano Nigeria Limited','2019-03-28 10:39:11','',''),('1','72',803831,'','customer','1740',17550.00,0.00,'Payment Id 51391 for invoice:84190, receipt:  by A.A Rano Nigeria Limited','2019-03-28 11:22:22','',''),('1','72',803832,'','supplier','98',0.00,17550.00,'Payment Id 51391 for invoice:84190, receipt:  by A.A Rano Nigeria Limited','2019-03-28 11:22:22','',''),('1','72',803835,'','customer','1740',15400.00,0.00,'Payment Id 51393 for invoice:84192, receipt:  by A.A Rano Nigeria Limited','2019-03-28 11:25:02','',''),('1','72',803836,'','supplier','98',0.00,15400.00,'Payment Id 51393 for invoice:84192, receipt:  by A.A Rano Nigeria Limited','2019-03-28 11:25:02','',''),('1','72',803837,'','customer','1740',3000.00,0.00,'Payment Id 51394 for invoice:84192, receipt:  by A.A Rano Nigeria Limited','2019-03-28 11:27:12','',''),('1','72',803838,'','supplier','98',0.00,3000.00,'Payment Id 51394 for invoice:84192, receipt:  by A.A Rano Nigeria Limited','2019-03-28 11:27:12','',''),('1','72',806852,'','customer','1740',55750.00,0.00,'Payment Id 51654 for invoice:84193, receipt:  by A.A Rano Nigeria Limited','2019-04-01 11:05:24','',''),('1','72',806853,'','supplier','98',0.00,55750.00,'Payment Id 51654 for invoice:84193, receipt:  by A.A Rano Nigeria Limited','2019-04-01 11:05:24','',''),('1','72',806854,'','customer','1740',30000.00,0.00,'Payment Id 51656 for invoice:84193, receipt:  by A.A Rano Nigeria Limited','2019-04-01 11:05:38','',''),('1','72',806855,'','supplier','98',0.00,30000.00,'Payment Id 51656 for invoice:84193, receipt:  by A.A Rano Nigeria Limited','2019-04-01 11:05:38','',''),('1','72',806856,'','customer','1740',15000.00,0.00,'Payment Id 51658 for invoice:84193, receipt:  by A.A Rano Nigeria Limited','2019-04-01 11:06:39','',''),('1','72',806857,'','supplier','98',0.00,15000.00,'Payment Id 51658 for invoice:84193, receipt:  by A.A Rano Nigeria Limited','2019-04-01 11:06:39','',''),('1','72',806858,'','customer','1740',20950.00,0.00,'Payment Id 51839 for invoice:84394, receipt:  by A.A Rano Nigeria Limited','2019-04-01 11:07:13','',''),('1','72',806859,'','supplier','98',0.00,20950.00,'Payment Id 51839 for invoice:84394, receipt:  by A.A Rano Nigeria Limited','2019-04-01 11:07:13','',''),('1','72',816946,'','supplier','98',0.00,15300.00,'Payment Id 52503 for invoice:84496, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:06:02','',''),('1','72',816948,'','supplier','98',0.00,49400.00,'Payment Id 52504 for invoice:84808, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:06:38','',''),('1','72',816950,'','supplier','98',0.00,14000.00,'Payment Id 52505 for invoice:84812, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:06:53','',''),('1','72',816952,'','supplier','98',0.00,29700.00,'Payment Id 52628 for invoice:84812, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:07:08','',''),('1','72',816954,'','supplier','98',0.00,7500.00,'Payment Id 52983 for invoice:84908, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:07:29','',''),('1','72',816956,'','supplier','98',0.00,23200.00,'Payment Id 52984 for invoice:85145, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:07:53','',''),('1','72',816958,'','supplier','98',0.00,10000.00,'Payment Id 52986 for invoice:85145, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:08:17','',''),('1','72',816960,'','supplier','98',0.00,10000.00,'Payment Id 52988 for invoice:85145, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:08:42','',''),('1','72',816962,'','supplier','98',0.00,35350.00,'Payment Id 54105 for invoice:85147, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:08:57','',''),('1','72',816964,'','supplier','98',0.00,22000.00,'Payment Id 54106 for invoice:85271, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:09:35','',''),('1','72',816966,'','supplier','98',0.00,203215.00,'Payment Id 54107 for invoice:85841, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:09:51','',''),('1','72',816968,'','supplier','98',0.00,9700.00,'Payment Id 54108 for invoice:85842, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:10:06','',''),('1','72',816970,'','supplier','98',0.00,23200.00,'Payment Id 54109 for invoice:85842, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:11:19','',''),('1','72',816972,'','supplier','98',0.00,70000.00,'Payment Id 54110 for invoice:85842, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:11:31','',''),('1','72',816974,'','supplier','98',0.00,11000.00,'Payment Id 54386 for invoice:85843, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:11:47','',''),('1','72',816976,'','supplier','98',0.00,8000.00,'Payment Id 54391 for invoice:85847, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:12:01','',''),('1','72',816981,'','supplier','98',0.00,60845.00,'Payment Id 54395 for invoice:85940, receipt:  by A.A Rano Nigeria Limited','2019-04-11 16:12:20','',''),('1','72',817314,'','customer','1388',30000.00,0.00,'Payment Id 78353 for invoice:, receipt:  by B. A. L MOTORS 1','2019-04-12 09:54:59','',''),('1','72',817324,'','customer','1385',15000.00,0.00,'Payment Id 78354 for invoice:, receipt:  by ALIYU TRANSPORT','2019-04-12 09:55:43','',''),('1','72',817333,'','customer','1421',10000.00,0.00,'Payment Id 78469 for invoice:, receipt:  by NANU TRASPORT','2019-04-12 09:58:00','',''),('1','72',817335,'','customer','1386',10000.00,0.00,'Payment Id 78470 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-04-12 09:59:44','',''),('1','72',817372,'','customer','1382',70000.00,0.00,'Payment Id 78564 for invoice:, receipt:  by A.A.Y MOTORS COMP.','2019-04-12 10:10:38','',''),('1','72',817376,'','customer','1380',23200.00,0.00,'Payment Id 78565 for invoice:, receipt:  by DANMA KAI MOTORS','2019-04-12 10:11:29','',''),('1','72',831028,'','supplier','98',0.00,41955.00,'Payment Id 55155 for invoice:86601, receipt:  by A.A Rano Nigeria Limited','2019-04-29 10:11:53','',''),('1','72',831032,'','supplier','98',0.00,28750.00,'Payment Id 55509 for invoice:86605, receipt:  by A.A Rano Nigeria Limited','2019-04-29 10:12:27','',''),('1','72',831034,'','supplier','98',0.00,17500.00,'Payment Id 55716 for invoice:86783, receipt:  by A.A Rano Nigeria Limited','2019-04-29 10:12:59','',''),('1','72',831036,'','supplier','98',0.00,129330.00,'Payment Id 55891 for invoice:86859, receipt:  by A.A Rano Nigeria Limited','2019-04-29 10:13:21','',''),('1','72',831040,'','supplier','98',0.00,11975.00,'Payment Id 56997 for invoice:87608, receipt:  by A.A Rano Nigeria Limited','2019-04-29 10:13:44','',''),('1','72',831042,'','supplier','98',0.00,11600.00,'Payment Id 56998 for invoice:87609, receipt:  by A.A Rano Nigeria Limited','2019-04-29 10:14:09','',''),('1','72',831044,'','supplier','98',0.00,92450.00,'Payment Id 57344 for invoice:87610, receipt:  by A.A Rano Nigeria Limited','2019-04-29 10:14:32','',''),('1','72',831046,'','supplier','98',0.00,11400.00,'Payment Id 57350 for invoice:87613, receipt:  by A.A Rano Nigeria Limited','2019-04-29 10:15:03','',''),('1','72',832965,'','supplier','98',0.00,114050.00,'Payment Id 55153 for invoice:86103, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:02:49','',''),('1','72',832971,'','supplier','98',0.00,3760.00,'Payment Id 55514 for invoice:86608, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:03:30','',''),('1','72',832975,'','supplier','98',0.00,6600.00,'Payment Id 55516 for invoice:86612, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:03:53','',''),('1','72',832981,'','supplier','98',0.00,85500.00,'Payment Id 55715 for invoice:86783, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:05:06','',''),('1','72',833027,'','supplier','98',0.00,10785.00,'Payment Id 57347 for invoice:87611, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:13:47','',''),('1','72',833031,'','supplier','98',0.00,107150.00,'Payment Id 57891 for invoice:87698, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:14:20','',''),('1','72',833036,'','supplier','98',0.00,31280.00,'Payment Id 57892 for invoice:87698, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:14:33','',''),('1','72',833038,'','supplier','98',0.00,38280.00,'Payment Id 57949 for invoice:87879, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:14:57','',''),('1','72',833040,'','supplier','98',0.00,23500.00,'Payment Id 57950 for invoice:88299, receipt:  by A.A Rano Nigeria Limited','2019-04-30 17:15:19','',''),('1','72',838900,'','supplier','98',0.00,48250.00,'Payment Id 58671 for invoice:88303, receipt:  by A.A Rano Nigeria Limited','2019-05-06 14:29:21','',''),('1','72',838902,'','supplier','98',0.00,314950.00,'Payment Id 56728 for invoice:86964, receipt:  by A.A Rano Nigeria Limited','2019-05-06 14:30:19','',''),('1','72',838904,'','supplier','98',0.00,28310.00,'Payment Id 58676 for invoice:88305, receipt:  by A.A Rano Nigeria Limited','2019-05-06 14:35:57','',''),('1','72',838906,'','supplier','98',0.00,12750.00,'Payment Id 58679 for invoice:88733, receipt:  by A.A Rano Nigeria Limited','2019-05-06 14:36:28','',''),('1','72',838908,'','customer','1388',17500.00,0.00,'Payment Id 78678 for invoice:, receipt:  by B. A. L MOTORS 1','2019-05-06 14:38:16','',''),('1','72',838910,'','customer','1422',31280.00,0.00,'Payment Id 78851 for invoice:, receipt:  by HABIB TRANSPORT','2019-05-06 14:38:31','',''),('1','72',845752,'','supplier','98',0.00,18720.00,'Payment Id 59862 for invoice:88738, receipt:  by A.A Rano Nigeria Limited','2019-05-14 13:03:27','',''),('1','72',845758,'','supplier','98',0.00,5000.00,'Payment Id 59864 for invoice:88738, receipt:  by A.A Rano Nigeria Limited','2019-05-14 13:04:04','',''),('1','72',845784,'','supplier','98',0.00,207970.00,'Payment Id 59924 for invoice:88741, receipt:  by A.A Rano Nigeria Limited','2019-05-14 13:05:59','',''),('1','72',845792,'','supplier','98',0.00,113420.00,'Payment Id 59925 for invoice:89399, receipt:  by A.A Rano Nigeria Limited','2019-05-14 13:07:39','',''),('1','72',845794,'','supplier','98',0.00,23700.00,'Payment Id 59926 for invoice:89401, receipt:  by A.A Rano Nigeria Limited','2019-05-14 13:08:07','',''),('1','72',845798,'','supplier','98',0.00,33750.00,'Payment Id 59927 for invoice:89405, receipt:  by A.A Rano Nigeria Limited','2019-05-14 13:09:19','',''),('1','72',845800,'','customer','1424',5000.00,0.00,'Payment Id 79098 for invoice:, receipt:  by BARA BARAU','2019-05-14 13:10:17','',''),('1','72',845802,'','supplier','98',0.00,147800.00,'Payment Id 59860 for invoice:88738, receipt:  by A.A Rano Nigeria Limited','2019-05-14 13:12:06','',''),('1','72',848101,'','customer','1422',18720.00,0.00,'Payment Id 79099 for invoice:, receipt:  by HABIB TRANSPORT','2019-05-16 13:30:06','',''),('1','72',848846,'','supplier','98',0.00,200715.00,'Payment Id 61423 for invoice:90102, receipt:  by A.A Rano Nigeria Limited','2019-05-17 10:03:27','',''),('1','72',848848,'','supplier','98',0.00,33465.00,'Payment Id 61629 for invoice:90104, receipt:  by A.A Rano Nigeria Limited','2019-05-17 10:04:07','',''),('1','72',848850,'','supplier','98',0.00,116915.00,'Payment Id 61737 for invoice:90105, receipt:  by A.A Rano Nigeria Limited','2019-05-17 10:04:40','',''),('1','72',848852,'','supplier','98',0.00,22500.00,'Payment Id 61738 for invoice:90108, receipt:  by A.A Rano Nigeria Limited','2019-05-17 10:05:04','',''),('1','72',848854,'','supplier','98',0.00,12950.00,'Payment Id 61742 for invoice:90111, receipt:  by A.A Rano Nigeria Limited','2019-05-17 10:05:39','',''),('1','72',848856,'','supplier','98',0.00,21960.00,'Payment Id 61743 for invoice:90307, receipt:  by A.A Rano Nigeria Limited','2019-05-17 10:06:32','',''),('1','72',848858,'','supplier','98',0.00,45485.00,'Payment Id 61885 for invoice:90401, receipt:  by A.A Rano Nigeria Limited','2019-05-17 10:07:53','',''),('1','72',848872,'','supplier','98',0.00,10000.00,'Payment Id 61887 for invoice:90401, receipt:  by A.A Rano Nigeria Limited','2019-05-17 10:13:29','',''),('1','72',851710,'','supplier','98',0.00,97000.00,'Payment Id 62008 for invoice:90554, receipt:  by A.A Rano Nigeria Limited','2019-05-20 14:40:34','',''),('1','72',852283,'','customer','1419',10000.00,0.00,'Payment Id 79242 for invoice:, receipt:  by HAYIN DAGA TRASPORT','2019-05-21 09:35:27','',''),('1','72',854908,'','supplier','98',4905000.00,0.00,'Purchase Id 32994 for 21,800 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-05-22 15:33:33','',''),('1','72',854914,'','supplier','98',0.00,133050.00,'Payment Id 62966 for invoice:90596, receipt:  by A.A Rano Nigeria Limited','2019-05-22 15:37:53','',''),('1','72',855060,'','supplier','98',0.00,65950.00,'Payment Id 58013 for invoice:88301, receipt:  by A.A Rano Nigeria Limited','2019-05-22 16:38:51','',''),('1','72',855062,'','supplier','98',0.00,23000.00,'Payment Id 59928 for invoice:89406, receipt:  by A.A Rano Nigeria Limited','2019-05-22 16:39:58','',''),('1','72',857917,'','supplier','98',0.00,114915.00,'Payment Id 63260 for invoice:91136, receipt:  by A.A Rano Nigeria Limited','2019-05-27 09:51:33','',''),('1','72',857919,'','supplier','98',0.00,36480.00,'Payment Id 63261 for invoice:91139, receipt:  by A.A Rano Nigeria Limited','2019-05-27 09:52:17','',''),('1','72',857921,'','supplier','98',0.00,16000.00,'Payment Id 63262 for invoice:91140, receipt:  by A.A Rano Nigeria Limited','2019-05-27 09:52:37','',''),('1','72',857925,'','supplier','98',0.00,96075.00,'Payment Id 63489 for invoice:91142, receipt:  by A.A Rano Nigeria Limited','2019-05-27 09:52:52','',''),('1','72',857927,'','supplier','98',0.00,10000.00,'Payment Id 63878 for invoice:91295, receipt:  by A.A Rano Nigeria Limited','2019-05-27 09:53:34','',''),('1','72',857929,'','customer','1386',10000.00,0.00,'Payment Id 79382 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-05-27 09:53:54','',''),('1','72',861200,'','supplier','98',0.00,358250.00,'Payment Id 64689 for invoice:, receipt:  by A.A Rano Nigeria Limited','2019-05-30 10:39:53','',''),('1','72',861206,'','supplier','98',0.00,168210.00,'Payment Id 63877 for invoice:91295, receipt:  by A.A Rano Nigeria Limited','2019-05-30 10:42:33','',''),('1','72',871179,'','supplier','98',0.00,74050.00,'Payment Id 67395 for invoice:91551, receipt:  by A.A Rano Nigeria Limited','2019-06-13 11:46:38','',''),('1','72',871185,'','supplier','98',0.00,136695.00,'Payment Id 67398 for invoice:91979, receipt:  by A.A Rano Nigeria Limited','2019-06-13 11:48:32','',''),('1','72',871187,'','supplier','98',0.00,20855.00,'Payment Id 67400 for invoice:91981, receipt:  by A.A Rano Nigeria Limited','2019-06-13 11:49:11','',''),('1','72',871215,'','supplier','98',0.00,222660.00,'Payment Id 67404 for invoice:91985, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:10:05','',''),('1','72',871217,'','supplier','98',0.00,37100.00,'Payment Id 67408 for invoice:91986, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:10:50','',''),('1','72',871219,'','supplier','98',0.00,10305.00,'Payment Id 67413 for invoice:93440, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:11:29','',''),('1','72',871223,'','supplier','98',0.00,1500.00,'Payment Id 67416 for invoice:93573, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:14:01','',''),('1','72',871227,'','supplier','98',0.00,11400.00,'Payment Id 67418 for invoice:93574, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:15:05','',''),('1','72',871231,'','supplier','98',0.00,109760.00,'Payment Id 67432 for invoice:93576, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:16:32','',''),('1','72',871233,'','supplier','98',0.00,33425.00,'Payment Id 67435 for invoice:93621, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:16:58','',''),('1','72',871235,'','supplier','98',0.00,6875.00,'Payment Id 67439 for invoice:93622, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:17:43','',''),('1','72',871237,'','supplier','98',0.00,12425.00,'Payment Id 67457 for invoice:93624, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:18:24','',''),('1','72',871239,'','supplier','98',0.00,10400.00,'Payment Id 67460 for invoice:93626, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:19:09','',''),('1','72',871245,'','supplier','98',0.00,40250.00,'Payment Id 67463 for invoice:93629, receipt:  by A.A Rano Nigeria Limited','2019-06-13 12:24:18','',''),('1','72',876803,'','supplier','98',0.00,18770.00,'Payment Id 68397 for invoice:93631, receipt:  by A.A Rano Nigeria Limited','2019-06-17 13:51:21','',''),('1','72',876807,'','supplier','98',0.00,130190.00,'Payment Id 68399 for invoice:93632, receipt:  by A.A Rano Nigeria Limited','2019-06-17 13:51:37','',''),('1','72',876821,'','supplier','98',0.00,124750.00,'Payment Id 68400 for invoice:93634, receipt:  by A.A Rano Nigeria Limited','2019-06-17 13:54:36','',''),('1','72',881775,'','supplier','98',0.00,164200.00,'Payment Id 69518 for invoice:93635, receipt:  by A.A Rano Nigeria Limited','2019-06-21 10:50:05','',''),('1','72',881783,'','supplier','98',0.00,180000.00,'Payment Id 69521 for invoice:93636, receipt:  by A.A Rano Nigeria Limited','2019-06-21 10:51:30','',''),('1','72',881787,'','supplier','98',0.00,82000.00,'Payment Id 70177 for invoice:93839, receipt:  by A.A Rano Nigeria Limited','2019-06-21 10:52:19','',''),('1','72',881795,'','supplier','98',0.00,34800.00,'Payment Id 70178 for invoice:93984, receipt:  by A.A Rano Nigeria Limited','2019-06-21 10:55:25','',''),('1','72',881829,'','customer','1388',8000.00,0.00,'Payment Id 79720 for invoice:, receipt:  by B. A. L MOTORS 1','2019-06-21 11:03:23','',''),('1','72',881835,'','supplier','98',0.00,8000.00,'Payment Id 70180 for invoice:94397, receipt:  by A.A Rano Nigeria Limited','2019-06-21 11:04:19','',''),('1','72',885535,'','supplier','98',0.00,10000.00,'Payment Id 70891 for invoice:94399, receipt:  by A.A Rano Nigeria Limited','2019-06-26 10:56:38','',''),('1','72',885537,'','supplier','98',0.00,18400.00,'Payment Id 70892 for invoice:94480, receipt:  by A.A Rano Nigeria Limited','2019-06-26 10:57:07','',''),('1','72',885539,'','supplier','98',0.00,11485.00,'Payment Id 70893 for invoice:94484, receipt:  by A.A Rano Nigeria Limited','2019-06-26 10:57:36','',''),('1','72',885541,'','supplier','98',0.00,18700.00,'Payment Id 70894 for invoice:94635, receipt:  by A.A Rano Nigeria Limited','2019-06-26 10:57:56','',''),('1','72',885543,'','supplier','98',0.00,22900.00,'Payment Id 70895 for invoice:94635, receipt:  by A.A Rano Nigeria Limited','2019-06-26 10:58:23','',''),('1','72',890379,'','supplier','98',0.00,83150.00,'Payment Id 71699 for invoice:94795, receipt:  by A.A Rano Nigeria Limited','2019-07-01 10:59:25','',''),('1','72',890383,'','supplier','98',0.00,18800.00,'Payment Id 71700 for invoice:95487, receipt:  by A.A Rano Nigeria Limited','2019-07-01 10:59:42','',''),('1','72',890385,'','supplier','98',0.00,16700.00,'Payment Id 71701 for invoice:95488, receipt:  by A.A Rano Nigeria Limited','2019-07-01 11:00:03','',''),('1','72',890387,'','supplier','98',0.00,45850.00,'Payment Id 71702 for invoice:95490, receipt:  by A.A Rano Nigeria Limited','2019-07-01 11:00:28','',''),('1','72',890393,'','supplier','98',0.00,32825.00,'Payment Id 71703 for invoice:95491, receipt:  by A.A Rano Nigeria Limited','2019-07-01 11:00:46','',''),('1','72',890399,'','supplier','98',0.00,68000.00,'Payment Id 71705 for invoice:95598, receipt:  by A.A Rano Nigeria Limited','2019-07-01 11:02:54','',''),('1','72',890405,'','supplier','98',0.00,5000.00,'Payment Id 71709 for invoice:95598, receipt:  by A.A Rano Nigeria Limited','2019-07-01 11:03:05','',''),('1','72',890407,'','supplier','98',0.00,15000.00,'Payment Id 71710 for invoice:95598, receipt:  by A.A Rano Nigeria Limited','2019-07-01 11:03:16','',''),('1','72',890409,'','supplier','98',0.00,5000.00,'Payment Id 71712 for invoice:95598, receipt:  by A.A Rano Nigeria Limited','2019-07-01 11:03:35','',''),('1','72',890413,'','customer','1382',22900.00,0.00,'Payment Id 79862 for invoice:, receipt:  by A.A.Y MOTORS COMP.','2019-07-01 11:03:58','',''),('1','72',890415,'','customer','1420',15000.00,0.00,'Payment Id 79863 for invoice:, receipt:  by DANGUGUA TRASPORT','2019-07-01 11:04:10','',''),('1','72',890417,'','customer','1421',5000.00,0.00,'Payment Id 79864 for invoice:, receipt:  by NANU TRASPORT','2019-07-01 11:04:20','',''),('1','72',891568,'','supplier','98',0.00,126100.00,'Payment Id 72327 for invoice:95601, receipt:  by A.A Rano Nigeria Limited','2019-07-02 16:46:44','',''),('1','72',891574,'','supplier','98',0.00,27475.00,'Payment Id 72329 for invoice:95602, receipt:  by A.A Rano Nigeria Limited','2019-07-02 16:47:35','',''),('1','72',891578,'','supplier','98',0.00,41465.00,'Payment Id 72331 for invoice:95764, receipt:  by A.A Rano Nigeria Limited','2019-07-02 16:48:04','',''),('1','72',893773,'','supplier','98',0.00,5895.00,'Payment Id 61037 for invoice:89407, receipt:  by A.A Rano Nigeria Limited','2019-07-04 13:18:53','',''),('1','72',893777,'','supplier','98',0.00,7800.00,'Payment Id 61043 for invoice:89471, receipt:  by A.A Rano Nigeria Limited','2019-07-04 13:22:19','',''),('1','72',893781,'','supplier','98',0.00,20540.00,'Payment Id 70179 for invoice:94397, receipt:  by A.A Rano Nigeria Limited','2019-07-04 13:23:48','',''),('1','72',904253,'','supplier','98',0.00,250400.00,'Payment Id 73226 for invoice:95766, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:33:28','',''),('1','72',904255,'','supplier','98',0.00,19250.00,'Payment Id 73227 for invoice:95855, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:35:10','',''),('1','72',904259,'','supplier','98',0.00,53500.00,'Payment Id 73230 for invoice:95935, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:37:49','',''),('1','72',904263,'','supplier','98',0.00,12000.00,'Payment Id 73231 for invoice:96271, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:38:45','',''),('1','72',904281,'','supplier','98',0.00,54660.00,'Payment Id 73233 for invoice:96272, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:43:23','',''),('1','72',904302,'','supplier','98',0.00,61035.00,'Payment Id 74194 for invoice:96274, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:45:31','',''),('1','72',904304,'','supplier','98',0.00,210655.00,'Payment Id 74195 for invoice:96399, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:46:01','',''),('1','72',904315,'','supplier','98',0.00,205925.00,'Payment Id 74521 for invoice:96793, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:50:05','',''),('1','72',904317,'','supplier','98',0.00,29750.00,'Payment Id 74523 for invoice:96795, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:52:56','',''),('1','72',904319,'','supplier','98',0.00,121075.00,'Payment Id 74524 for invoice:96798, receipt:  by A.A Rano Nigeria Limited','2019-07-15 15:54:04','',''),('1','72',908066,'','supplier','98',2072000.00,0.00,'Purchase Id 34982 for 14,800 litters of PMS - 001 from A.A Rano Nigeria Limited','2019-07-18 13:42:13','',''),('1','72',909018,'','supplier','98',0.00,155675.00,'Payment Id 75607 for invoice:96800, receipt:  by A.A Rano Nigeria Limited','2019-07-19 12:38:46','',''),('1','72',909020,'','supplier','98',0.00,7000.00,'Payment Id 75871 for invoice:97388, receipt:  by A.A Rano Nigeria Limited','2019-07-19 12:39:18','',''),('1','72',909022,'','supplier','98',0.00,8500.00,'Payment Id 75873 for invoice:97788, receipt:  by A.A Rano Nigeria Limited','2019-07-19 12:39:34','',''),('1','72',909024,'','supplier','98',0.00,9200.00,'Payment Id 75934 for invoice:97792, receipt:  by A.A Rano Nigeria Limited','2019-07-19 12:39:53','',''),('1','72',909026,'','supplier','98',0.00,27500.00,'Payment Id 75875 for invoice:97790, receipt:  by A.A Rano Nigeria Limited','2019-07-19 12:40:05','',''),('1','72',909771,'','supplier','98',0.00,197200.00,'Payment Id 75868 for invoice:96960, receipt:  by A.A Rano Nigeria Limited','2019-07-19 15:38:15','',''),('1','72',914415,'','supplier','98',2992000.00,0.00,'Purchase Id 35240 for 13,600 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-07-23 17:27:05','',''),('1','72',919711,'','supplier','98',0.00,20000.00,'Payment Id 75613 for invoice:96800, receipt:  by A.A Rano Nigeria Limited','2019-07-29 15:09:53','',''),('1','72',919716,'','supplier','98',0.00,135160.00,'Payment Id 77992 for invoice:99197, receipt:  by A.A Rano Nigeria Limited','2019-07-29 15:10:28','',''),('1','72',919718,'','supplier','98',0.00,28000.00,'Payment Id 77997 for invoice:99192, receipt:  by A.A Rano Nigeria Limited','2019-07-29 15:10:57','',''),('1','72',920448,'','supplier','98',4578000.00,0.00,'Purchase Id 35453 for 32,700 litters of PMS - 001 from A.A Rano Nigeria Limited','2019-07-30 14:05:03','',''),('1','72',922910,'','supplier','98',0.00,251750.00,'Payment Id 77984 for invoice:99192, receipt:  by A.A Rano Nigeria Limited','2019-08-01 13:57:44','',''),('1','72',922912,'','supplier','98',0.00,56695.00,'Payment Id 79502 for invoice:97792, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:01:08','',''),('1','72',922916,'','supplier','98',0.00,160755.00,'Payment Id 79508 for invoice:99517, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:03:06','',''),('1','72',922920,'','supplier','98',0.00,416655.00,'Payment Id 79511 for invoice:99518, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:04:13','',''),('1','72',922922,'','supplier','98',0.00,342500.00,'Payment Id 79516 for invoice:99616, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:05:09','',''),('1','72',922928,'','supplier','98',0.00,357280.00,'Payment Id 79520 for invoice:100049, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:06:18','',''),('1','72',922932,'','supplier','98',0.00,202660.00,'Payment Id 80072 for invoice:97873, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:07:49','',''),('1','72',922934,'','supplier','98',0.00,94600.00,'Payment Id 79523 for invoice:99203, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:08:36','',''),('1','72',922936,'','supplier','98',0.00,291290.00,'Payment Id 79505 for invoice:99201, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:09:50','',''),('1','72',922940,'','supplier','98',0.00,223955.00,'Payment Id 79521 for invoice:100052, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:13:42','',''),('1','72',922950,'','supplier','98',0.00,236270.00,'Payment Id 79506 for invoice:99203, receipt:  by A.A Rano Nigeria Limited','2019-08-01 14:21:38','',''),('1','72',927401,'','supplier','98',0.00,222580.00,'Payment Id 77988 for invoice:99196, receipt:  by A.A Rano Nigeria Limited','2019-08-07 11:44:59','',''),('1','72',932179,'','supplier','98',3003000.00,0.00,'Purchase Id 35934 for 13,650 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-08-14 15:35:11','',''),('1','72',942987,'','supplier','98',0.00,412210.00,'Payment Id 83795 for invoice:, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:00','',''),('1','72',942989,'','supplier','98',0.00,56695.00,'Payment Id 83793 for invoice:, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:01','',''),('1','72',942991,'','supplier','98',0.00,13410.00,'Payment Id 83792 for invoice:, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:01','',''),('1','72',942993,'','supplier','98',0.00,106080.00,'Payment Id 83791 for invoice:, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:01','',''),('1','72',942995,'','supplier','98',0.00,83670.00,'Payment Id 83790 for invoice:, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:01','',''),('1','72',942997,'','supplier','98',0.00,216115.00,'Payment Id 82659 for invoice:100302, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:01','',''),('1','72',942999,'','supplier','98',0.00,121415.00,'Payment Id 82651 for invoice:101819, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:01','',''),('1','72',943001,'','supplier','98',0.00,315620.00,'Payment Id 82650 for invoice:, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:01','',''),('1','72',943003,'','supplier','98',0.00,337860.00,'Payment Id 82647 for invoice:101249, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:52:02','',''),('1','72',943005,'','supplier','98',0.00,172190.00,'Payment Id 82653 for invoice:101814, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:53:49','',''),('1','72',943021,'','supplier','98',0.00,129000.00,'Payment Id 84693 for invoice:100048, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:57:13','',''),('1','72',943023,'','supplier','98',0.00,154000.00,'Payment Id 84342 for invoice:100980, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:57:13','',''),('1','72',943025,'','supplier','98',0.00,379530.00,'Payment Id 84321 for invoice:102357, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:57:13','',''),('1','72',943027,'','supplier','98',0.00,321085.00,'Payment Id 84315 for invoice:102355, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:57:13','',''),('1','72',943029,'','supplier','98',0.00,11000.00,'Payment Id 83796 for invoice:101815, receipt:  by A.A Rano Nigeria Limited','2019-08-26 10:57:13','',''),('1','72',943284,'','supplier','98',0.00,314030.00,'Payment Id 83794 for invoice:101817, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:13:46','',''),('1','72',943288,'','supplier','98',0.00,249085.00,'Payment Id 84330 for invoice:102606, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:15:26','',''),('1','72',943290,'','supplier','98',0.00,406800.00,'Payment Id 84326 for invoice:102604, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:15:26','',''),('1','72',943292,'','supplier','98',0.00,383845.00,'Payment Id 84694 for invoice:102780, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:15:58','',''),('1','72',943300,'','supplier','98',0.00,88000.00,'Payment Id 81912 for invoice:100053, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:19:39','',''),('1','72',943302,'','supplier','98',0.00,154000.00,'Payment Id 81747 for invoice:100053, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:19:39','',''),('1','72',943304,'','supplier','98',0.00,313490.00,'Payment Id 81740 for invoice:100981, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:19:39','',''),('1','72',943306,'','supplier','98',0.00,246180.00,'Payment Id 80804 for invoice:100439, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:19:39','',''),('1','72',943308,'','supplier','98',0.00,364675.00,'Payment Id 80803 for invoice:100303, receipt:  by A.A Rano Nigeria Limited','2019-08-26 12:19:39','',''),('1','72',943553,'','supplier','98',0.00,369145.00,'Payment Id 81736 for invoice:100768, receipt:  by A.A Rano Nigeria Limited','2019-08-26 13:00:32','',''),('1','72',947564,'','supplier','98',0.00,132000.00,'Payment Id 85981 for invoice:101149, receipt:  by A.A Rano Nigeria Limited','2019-08-28 08:57:28','',''),('1','72',947566,'','supplier','98',0.00,231540.00,'Payment Id 85980 for invoice:103410, receipt:  by A.A Rano Nigeria Limited','2019-08-28 08:57:28','',''),('1','72',947568,'','supplier','98',0.00,81400.00,'Payment Id 85732 for invoice:101149, receipt:  by A.A Rano Nigeria Limited','2019-08-28 08:57:28','',''),('1','72',947570,'','supplier','98',0.00,365220.00,'Payment Id 85731 for invoice:103409, receipt:  by A.A Rano Nigeria Limited','2019-08-28 08:57:28','',''),('1','72',947572,'','supplier','98',0.00,400810.00,'Payment Id 85730 for invoice:103408, receipt:  by A.A Rano Nigeria Limited','2019-08-28 08:57:28','',''),('1','72',947574,'','supplier','98',0.00,340285.00,'Payment Id 85729 for invoice:103407, receipt:  by A.A Rano Nigeria Limited','2019-08-28 08:57:28','',''),('1','72',947576,'','supplier','98',0.00,305360.00,'Payment Id 85728 for invoice:103406, receipt:  by A.A Rano Nigeria Limited','2019-08-28 08:57:28','',''),('1','72',947578,'','supplier','98',0.00,186445.00,'Payment Id 85727 for invoice:102781, receipt:  by A.A Rano Nigeria Limited','2019-08-28 08:59:38','',''),('1','72',947620,'','supplier','98',0.00,378050.00,'Payment Id 81911 for invoice:101149, receipt:  by A.A Rano Nigeria Limited','2019-08-28 09:15:20','',''),('1','72',947622,'','supplier','98',0.00,223240.00,'Payment Id 81738 for invoice:100980, receipt:  by A.A Rano Nigeria Limited','2019-08-28 09:15:20','',''),('1','72',947624,'','supplier','98',0.00,419800.00,'Payment Id 80808 for invoice:100767, receipt:  by A.A Rano Nigeria Limited','2019-08-28 09:15:20','',''),('1','72',947626,'','supplier','98',0.00,187380.00,'Payment Id 79518 for invoice:100048, receipt:  by A.A Rano Nigeria Limited','2019-08-28 09:15:21','',''),('1','72',949001,'','supplier','98',0.00,134000.00,'Payment Id 86091 for invoice:102604, receipt:  by A.A Rano Nigeria Limited','2019-08-29 12:32:51','',''),('1','72',949003,'','supplier','98',0.00,428575.00,'Payment Id 86089 for invoice:103410, receipt:  by A.A Rano Nigeria Limited','2019-08-29 12:32:51','',''),('1','72',949005,'','supplier','98',0.00,240000.00,'Payment Id 86087 for invoice:102780, receipt:  by A.A Rano Nigeria Limited','2019-08-29 12:32:52','',''),('1','72',949007,'','supplier','98',0.00,379925.00,'Payment Id 80806 for invoice:100441, receipt:  by A.A Rano Nigeria Limited','2019-08-29 12:32:52','',''),('1','72',949063,'','supplier','98',0.00,307035.00,'Payment Id 80071 for invoice:100302, receipt:  by A.A Rano Nigeria Limited','2019-08-29 13:31:44','',''),('1','72',955309,'','supplier','98',0.00,215000.00,'Payment Id 87829 for invoice:103546, receipt:  by A.A Rano Nigeria Limited','2019-09-04 10:04:11','',''),('1','72',955311,'','supplier','98',0.00,413025.00,'Payment Id 87824 for invoice:103941, receipt:  by A.A Rano Nigeria Limited','2019-09-04 10:04:11','',''),('1','72',955313,'','supplier','98',0.00,94600.00,'Payment Id 86781 for invoice:101817, receipt:  by A.A Rano Nigeria Limited','2019-09-04 10:04:11','',''),('1','72',955315,'','supplier','98',0.00,314375.00,'Payment Id 86780 for invoice:103939, receipt:  by A.A Rano Nigeria Limited','2019-09-04 10:04:11','',''),('1','72',955317,'','supplier','98',0.00,402170.00,'Payment Id 86779 for invoice:103637, receipt:  by A.A Rano Nigeria Limited','2019-09-04 10:04:12','',''),('1','72',957269,'','supplier','98',3407750.00,0.00,'Purchase Id 36755 for 15,850 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-09-06 12:46:56','',''),('1','72',963014,'','supplier','98',0.00,33000.00,'Payment Id 89598 for invoice:105309, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:18','',''),('1','72',963016,'','supplier','98',0.00,198000.00,'Payment Id 89596 for invoice:100441, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:18','',''),('1','72',963018,'','supplier','98',0.00,126850.00,'Payment Id 89590 for invoice:103409, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:18','',''),('1','72',963020,'','supplier','98',0.00,316265.00,'Payment Id 89349 for invoice:105316, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:19','',''),('1','72',963022,'','supplier','98',0.00,292200.00,'Payment Id 89346 for invoice:105313, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:19','',''),('1','72',963024,'','supplier','98',0.00,647165.00,'Payment Id 89345 for invoice:105311, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:19','',''),('1','72',963026,'','supplier','98',0.00,370635.00,'Payment Id 89344 for invoice:105309, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:19','',''),('1','72',963028,'','supplier','98',0.00,147115.00,'Payment Id 89331 for invoice:105304, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:19','',''),('1','72',963030,'','supplier','98',0.00,102270.00,'Payment Id 87830 for invoice:102781, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:53:19','',''),('1','72',963032,'','supplier','98',0.00,200145.00,'Payment Id 89587 for invoice:105319, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:57:13','',''),('1','72',963034,'','supplier','98',0.00,249860.00,'Payment Id 89339 for invoice:105307, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:57:13','',''),('1','72',963036,'','supplier','98',0.00,541495.00,'Payment Id 89321 for invoice:104454, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:57:13','',''),('1','72',963038,'','supplier','98',0.00,508680.00,'Payment Id 87828 for invoice:104453, receipt:  by A.A Rano Nigeria Limited','2019-09-12 12:57:13','',''),('1','72',963054,'','supplier','98',0.00,198875.00,'Payment Id 89351 for invoice:105317, receipt:  by A.A Rano Nigeria Limited','2019-09-12 13:10:32','',''),('1','72',963056,'','supplier','98',0.00,562400.00,'Payment Id 87827 for invoice:104452, receipt:  by A.A Rano Nigeria Limited','2019-09-12 13:10:32','',''),('1','72',963058,'','supplier','98',0.00,219320.00,'Payment Id 82655 for invoice:101815, receipt:  by A.A Rano Nigeria Limited','2019-09-12 13:10:32','',''),('1','72',963060,'','supplier','98',0.00,184740.00,'Payment Id 80070 for invoice:100053, receipt:  by A.A Rano Nigeria Limited','2019-09-12 13:10:32','',''),('1','72',963062,'','supplier','98',0.00,73585.00,'Payment Id 77982 for invoice:97873, receipt:  by A.A Rano Nigeria Limited','2019-09-12 13:10:32','',''),('1','72',963066,'','customer','1382',28000.00,0.00,'Payment Id 80571 for invoice:, receipt:  by A.A.Y MOTORS COMP.','2019-09-12 13:11:38','',''),('1','72',970202,'','supplier','98',5461000.00,0.00,'Purchase Id 37290 for 25,400 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-09-19 14:11:57','',''),('1','72',970224,'','supplier','98',0.00,107500.00,'Payment Id 91254 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:45','',''),('1','72',970226,'','supplier','98',0.00,90730.00,'Payment Id 91251 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:45','',''),('1','72',970228,'','supplier','98',0.00,244865.00,'Payment Id 91249 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:45','',''),('1','72',970230,'','supplier','98',0.00,107500.00,'Payment Id 90737 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:45','',''),('1','72',970232,'','supplier','98',0.00,331325.00,'Payment Id 90734 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:45','',''),('1','72',970234,'','supplier','98',0.00,494380.00,'Payment Id 90730 for invoice:106101, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:45','',''),('1','72',970236,'','supplier','98',0.00,139000.00,'Payment Id 90018 for invoice:104453, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:45','',''),('1','72',970238,'','supplier','98',0.00,215000.00,'Payment Id 90015 for invoice:104454, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:46','',''),('1','72',970240,'','supplier','98',0.00,132000.00,'Payment Id 90012 for invoice:102244, receipt:  by A.A Rano Nigeria Limited','2019-09-19 14:15:46','',''),('1','72',988054,'','supplier','98',0.00,95140.00,'Payment Id 94692 for invoice:108017, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:28','',''),('1','72',988056,'','supplier','98',0.00,190830.00,'Payment Id 94691 for invoice:108017, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988058,'','supplier','98',0.00,427800.00,'Payment Id 93996 for invoice:108016, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988060,'','supplier','98',0.00,458175.00,'Payment Id 93995 for invoice:108013, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988062,'','supplier','98',0.00,371155.00,'Payment Id 93993 for invoice:108010, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988064,'','supplier','98',0.00,130000.00,'Payment Id 93992 for invoice:107247, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988066,'','supplier','98',0.00,549700.00,'Payment Id 93989 for invoice:107247, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988068,'','supplier','98',0.00,20000.00,'Payment Id 92765 for invoice:107246, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988070,'','supplier','98',0.00,86000.00,'Payment Id 92764 for invoice:107246, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988072,'','supplier','98',0.00,399105.00,'Payment Id 92763 for invoice:107246, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988074,'','supplier','98',0.00,182140.00,'Payment Id 92762 for invoice:107245, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988076,'','supplier','98',0.00,517670.00,'Payment Id 92761 for invoice:106616, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988078,'','supplier','98',0.00,137720.00,'Payment Id 91502 for invoice:106407, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988080,'','supplier','98',0.00,267590.00,'Payment Id 91501 for invoice:106407, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:29','',''),('1','72',988082,'','supplier','98',0.00,321050.00,'Payment Id 91253 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:30','',''),('1','72',988084,'','supplier','98',0.00,326715.00,'Payment Id 90727 for invoice:105707, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:30','',''),('1','72',988086,'','supplier','98',0.00,483430.00,'Payment Id 90010 for invoice:105704, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:30','',''),('1','72',988088,'','supplier','98',0.00,413690.00,'Payment Id 90009 for invoice:105441, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:30','',''),('1','72',988090,'','supplier','98',0.00,285745.00,'Payment Id 94888 for invoice:108317, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:57','',''),('1','72',988092,'','supplier','98',0.00,84375.00,'Payment Id 94694 for invoice:108316, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:05:57','',''),('1','72',988104,'','supplier','98',0.00,618875.00,'Payment Id 94693 for invoice:108316, receipt:  by A.A Rano Nigeria Limited','2019-10-07 10:06:37','',''),('1','72',988106,'','customer','1380',20000.00,0.00,'Payment Id 81561 for invoice:, receipt:  by DANMA KAI MOTORS','2019-10-07 10:07:43','',''),('1','72',992399,'','supplier','98',0.00,116490.00,'Payment Id 95985 for invoice:109101, receipt:  by A.A Rano Nigeria Limited','2019-10-09 15:17:30','',''),('1','72',992401,'','supplier','98',0.00,369340.00,'Payment Id 95984 for invoice:109100, receipt:  by A.A Rano Nigeria Limited','2019-10-09 15:17:30','',''),('1','72',992403,'','supplier','98',0.00,237435.00,'Payment Id 95983 for invoice:109099, receipt:  by A.A Rano Nigeria Limited','2019-10-09 15:17:30','',''),('1','72',992405,'','supplier','98',0.00,123590.00,'Payment Id 95980 for invoice:109098, receipt:  by A.A Rano Nigeria Limited','2019-10-09 15:17:30','',''),('1','72',992407,'','supplier','98',0.00,194240.00,'Payment Id 95979 for invoice:108435, receipt:  by A.A Rano Nigeria Limited','2019-10-09 15:17:30','',''),('1','72',993564,'','supplier','98',0.00,86000.00,'Payment Id 96311 for invoice:109102, receipt:  by A.A Rano Nigeria Limited','2019-10-10 14:05:54','',''),('1','72',993566,'','supplier','98',0.00,86000.00,'Payment Id 96308 for invoice:109102, receipt:  by A.A Rano Nigeria Limited','2019-10-10 14:05:55','',''),('1','72',993568,'','supplier','98',0.00,139750.00,'Payment Id 96307 for invoice:109102, receipt:  by A.A Rano Nigeria Limited','2019-10-10 14:05:55','',''),('1','72',993570,'','supplier','98',0.00,217985.00,'Payment Id 96305 for invoice:109102, receipt:  by A.A Rano Nigeria Limited','2019-10-10 14:05:55','',''),('1','72',996662,'','supplier','98',0.00,8750.00,'Payment Id 97094 for invoice:109723, receipt:  by A.A Rano Nigeria Limited','2019-10-14 12:34:12','',''),('1','72',996664,'','supplier','98',0.00,87630.00,'Payment Id 97093 for invoice:109723, receipt:  by A.A Rano Nigeria Limited','2019-10-14 12:34:12','',''),('1','72',996666,'','supplier','98',0.00,155210.00,'Payment Id 97092 for invoice:109755, receipt:  by A.A Rano Nigeria Limited','2019-10-14 12:34:12','',''),('1','72',1003942,'','supplier','98',28000.00,0.00,'PAYMENT FOR DRIVER SHORTAGE OF 200 LTRS OF PMS','2019-07-17 00:00:00','',''),('1','72',1003944,'','supplier','98',176000.00,0.00,'PAYMENT FOR DRIVER SHOTAGE OF 800 LTRS OF AGO AT 220','2019-08-16 00:00:00','',''),('1','72',1003946,'','supplier','98',33000.00,0.00,'DRIVER SHOTAGE OF 150 LTRS OF AGO','2019-08-22 00:00:00','',''),('1','72',1003947,'','supplier','98',0.00,33000.00,'DRIVER SHOTAGE  OF 150 LTRS OF AGO','2019-08-22 00:00:00','',''),('1','72',1003948,'','supplier','98',107500.00,0.00,'PAYMENT F0R DRIVER SHOTAGE OF 500 LTRS OF AGO','2019-09-18 00:00:00','',''),('1','72',1003949,'','supplier','98',0.00,107500.00,'PAYMENT F0R DRIVER SHOTAGE OF 500 LTRS OF AGO','2019-09-18 00:00:00','',''),('1','72',1003951,'','supplier','98',0.00,318195.00,'Payment Id 98308 for invoice:110351, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003953,'','supplier','98',0.00,121805.00,'Payment Id 98307 for invoice:110102, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003955,'','supplier','98',0.00,378800.00,'Payment Id 97855 for invoice:110101, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003957,'','supplier','98',0.00,193500.00,'Payment Id 97429 for invoice:109726, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003959,'','supplier','98',0.00,129000.00,'Payment Id 97428 for invoice:109726, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003961,'','supplier','98',0.00,193500.00,'Payment Id 97427 for invoice:109726, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003963,'','supplier','98',0.00,102945.00,'Payment Id 97426 for invoice:109726, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003965,'','supplier','98',0.00,44720.00,'Payment Id 97425 for invoice:109725, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003967,'','supplier','98',0.00,132720.00,'Payment Id 97424 for invoice:109724, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:53:00','',''),('1','72',1003969,'','supplier','98',0.00,298070.00,'Payment Id 97854 for invoice:109875, receipt:  by A.A Rano Nigeria Limited','2019-10-21 11:54:36','',''),('1','72',1005970,'','supplier','98',0.00,217000.00,'Payment Id 99044 for invoice:110779, receipt:  by A.A Rano Nigeria Limited','2019-10-22 15:42:13','',''),('1','72',1005972,'','supplier','98',0.00,200280.00,'Payment Id 99042 for invoice:110778, receipt:  by A.A Rano Nigeria Limited','2019-10-22 15:42:13','',''),('1','72',1005976,'','supplier','98',0.00,372565.00,'Payment Id 91503 for invoice:106408, receipt:  by A.A Rano Nigeria Limited','2019-10-22 15:42:45','',''),('1','72',1009114,'','supplier','98',0.00,120200.00,'Payment Id 99687 for invoice:111013, receipt:  by A.A Rano Nigeria Limited','2019-10-25 12:53:29','',''),('1','72',1009116,'','supplier','98',0.00,236885.00,'Payment Id 99685 for invoice:111013, receipt:  by A.A Rano Nigeria Limited','2019-10-25 12:53:29','',''),('1','72',1009118,'','supplier','98',0.00,230255.00,'Payment Id 99682 for invoice:111011, receipt:  by A.A Rano Nigeria Limited','2019-10-25 12:53:29','',''),('1','72',1013731,'','supplier','98',0.00,210960.00,'Payment Id 101221 for invoice:111751, receipt:  by A.A Rano Nigeria Limited','2019-10-31 10:42:20','',''),('1','72',1013733,'','supplier','98',0.00,195685.00,'Payment Id 101219 for invoice:111750, receipt:  by A.A Rano Nigeria Limited','2019-10-31 10:42:20','',''),('1','72',1013735,'','supplier','98',0.00,281785.00,'Payment Id 101060 for invoice:111748, receipt:  by A.A Rano Nigeria Limited','2019-10-31 10:42:20','',''),('1','72',1013737,'','supplier','98',0.00,256980.00,'Payment Id 101059 for invoice:111747, receipt:  by A.A Rano Nigeria Limited','2019-10-31 10:42:20','',''),('1','72',1013739,'','supplier','98',0.00,231595.00,'Payment Id 101058 for invoice:111746, receipt:  by A.A Rano Nigeria Limited','2019-10-31 10:42:20','',''),('1','72',1013741,'','supplier','98',0.00,433035.00,'Payment Id 101057 for invoice:111745, receipt:  by A.A Rano Nigeria Limited','2019-10-31 10:42:20','',''),('1','72',1013743,'','supplier','98',0.00,227555.00,'Payment Id 101056 for invoice:111014, receipt:  by A.A Rano Nigeria Limited','2019-10-31 10:42:20','',''),('1','72',1025475,'','supplier','98',3267000.00,0.00,'Purchase Id 39659 for 14,850 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-11-13 11:06:33','',''),('1','72',1025488,'','supplier','98',0.00,109650.00,'Payment Id 103999 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 11:58:55','',''),('1','72',1025490,'','supplier','98',0.00,103345.00,'Payment Id 103379 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 11:58:55','',''),('1','72',1025492,'','supplier','98',0.00,110000.00,'Payment Id 103378 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 11:58:55','',''),('1','72',1025494,'','supplier','98',0.00,156830.00,'Payment Id 103376 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 11:58:55','',''),('1','72',1025496,'','supplier','98',0.00,199585.00,'Payment Id 103375 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 11:58:55','',''),('1','72',1025498,'','supplier','98',0.00,5000.00,'Payment Id 101834 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 11:58:55','',''),('1','72',1025500,'','supplier','98',0.00,195685.00,'Payment Id 101832 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 11:58:55','',''),('1','72',1025502,'','supplier','98',0.00,183865.00,'Payment Id 101828 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 11:58:55','',''),('1','72',1025628,'','supplier','98',0.00,127670.00,'Payment Id 101831 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-13 12:44:17','',''),('1','72',1033312,'','supplier','98',0.00,25660.00,'Payment Id 105401 for invoice:114027, receipt:  by A.A Rano Nigeria Limited','2019-11-20 12:10:25','',''),('1','72',1033314,'','supplier','98',0.00,110480.00,'Payment Id 105398 for invoice:113770, receipt:  by A.A Rano Nigeria Limited','2019-11-20 12:10:25','',''),('1','72',1033316,'','supplier','98',0.00,123600.00,'Payment Id 104748 for invoice:113640, receipt:  by A.A Rano Nigeria Limited','2019-11-20 12:10:25','',''),('1','72',1033318,'','supplier','98',0.00,33000.00,'Payment Id 104521 for invoice:113467, receipt:  by A.A Rano Nigeria Limited','2019-11-20 12:10:25','',''),('1','72',1033320,'','supplier','98',0.00,50000.00,'Payment Id 104519 for invoice:113467, receipt:  by A.A Rano Nigeria Limited','2019-11-20 12:10:25','',''),('1','72',1033322,'','supplier','98',0.00,23600.00,'Payment Id 104518 for invoice:113467, receipt:  by A.A Rano Nigeria Limited','2019-11-20 12:10:25','',''),('1','72',1033324,'','supplier','98',0.00,77400.00,'Payment Id 104001 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-11-20 12:10:25','',''),('1','72',1033326,'','supplier','98',0.00,258395.00,'Payment Id 99041 for invoice:110352, receipt:  by A.A Rano Nigeria Limited','2019-11-20 12:13:33','',''),('1','72',1035123,'','supplier','98',0.00,191100.00,'Payment Id 106168 for invoice:114380, receipt:  by A.A Rano Nigeria Limited','2019-11-22 10:18:17','',''),('1','72',1035125,'','supplier','98',0.00,151220.00,'Payment Id 105954 for invoice:114379, receipt:  by A.A Rano Nigeria Limited','2019-11-22 10:18:17','',''),('1','72',1035127,'','supplier','98',0.00,26755.00,'Payment Id 105953 for invoice:114379, receipt:  by A.A Rano Nigeria Limited','2019-11-22 10:18:17','',''),('1','72',1035129,'','supplier','98',0.00,118870.00,'Payment Id 105952 for invoice:114032, receipt:  by A.A Rano Nigeria Limited','2019-11-22 10:18:17','',''),('1','72',1035131,'','supplier','98',0.00,15825.00,'Payment Id 105403 for invoice:114029, receipt:  by A.A Rano Nigeria Limited','2019-11-22 10:18:17','',''),('1','72',1040133,'','supplier','98',0.00,283000.00,'Payment Id 107360 for invoice:115235, receipt:  by A.A Rano Nigeria Limited','2019-11-27 12:39:34','',''),('1','72',1040135,'','supplier','98',0.00,304100.00,'Payment Id 107358 for invoice:114505, receipt:  by A.A Rano Nigeria Limited','2019-11-27 12:39:34','',''),('1','72',1040137,'','supplier','98',0.00,226975.00,'Payment Id 107356 for invoice:114381, receipt:  by A.A Rano Nigeria Limited','2019-11-27 12:39:34','',''),('1','72',1041351,'','supplier','98',0.00,5000.00,'Payment Id 107709 for invoice:115238, receipt:  by A.A Rano Nigeria Limited','2019-11-28 12:10:15','',''),('1','72',1041353,'','supplier','98',0.00,222130.00,'Payment Id 107707 for invoice:115238, receipt:  by A.A Rano Nigeria Limited','2019-11-28 12:10:15','',''),('1','72',1041355,'','supplier','98',0.00,280050.00,'Payment Id 107704 for invoice:115237, receipt:  by A.A Rano Nigeria Limited','2019-11-28 12:10:15','',''),('1','72',1051623,'','supplier','98',3740000.00,0.00,'Purchase Id 40916 for 17,000 litters of AGO - 002 from A.A Rano Nigeria Limited','2019-12-09 19:48:26','',''),('1','72',1062273,'','supplier','98',0.00,13520.00,'Payment Id 112609 for invoice:117231, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062275,'','supplier','98',0.00,121800.00,'Payment Id 112608 for invoice:117231, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062277,'','supplier','98',0.00,104565.00,'Payment Id 111776 for invoice:117099, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062279,'','supplier','98',0.00,74180.00,'Payment Id 111775 for invoice:116961, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062281,'','supplier','98',0.00,44320.00,'Payment Id 111325 for invoice:116953, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062283,'','supplier','98',0.00,40605.00,'Payment Id 110942 for invoice:116870, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062285,'','supplier','98',0.00,82700.00,'Payment Id 110818 for invoice:116869, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062287,'','supplier','98',0.00,30275.00,'Payment Id 110815 for invoice:116822, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062289,'','supplier','98',0.00,418000.00,'Payment Id 110812 for invoice:116802, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:05','',''),('1','72',1062291,'','supplier','98',0.00,28850.00,'Payment Id 110808 for invoice:116802, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:06','',''),('1','72',1062293,'','supplier','98',0.00,145700.00,'Payment Id 109206 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:06','',''),('1','72',1062295,'','supplier','98',0.00,5000.00,'Payment Id 109205 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:06','',''),('1','72',1062297,'','supplier','98',0.00,215000.00,'Payment Id 109204 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:06','',''),('1','72',1062299,'','supplier','98',0.00,93785.00,'Payment Id 109203 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:06','',''),('1','72',1062301,'','supplier','98',0.00,226885.00,'Payment Id 109202 for invoice:115784, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:06','',''),('1','72',1062303,'','supplier','98',0.00,255475.00,'Payment Id 109200 for invoice:115783, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:42:06','',''),('1','72',1062308,'','supplier','98',0.00,132000.00,'Payment Id 108578 for invoice:115390, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:47:34','',''),('1','72',1062310,'','supplier','98',0.00,106755.00,'Payment Id 108577 for invoice:115390, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:47:34','',''),('1','72',1062312,'','supplier','98',0.00,245680.00,'Payment Id 108576 for invoice:115390, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:47:34','',''),('1','72',1062314,'','supplier','98',0.00,88000.00,'Payment Id 108080 for invoice:115239, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:47:34','',''),('1','72',1062316,'','supplier','98',0.00,45000.00,'Payment Id 108079 for invoice:115239, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:47:34','',''),('1','72',1062318,'','supplier','98',0.00,110000.00,'Payment Id 108078 for invoice:115239, receipt:  by A.A Rano Nigeria Limited','2019-12-17 15:47:34','',''),('1','72',1062324,'','customer','1386',8750.00,0.00,'Payment Id 81885 for invoice:, receipt:  by SAGIR KARFI COMPANY','2019-12-17 15:49:57','',''),('1','72',1062326,'','customer','1427',77400.00,0.00,'Payment Id 82395 for invoice:, receipt:  by CONCENSUS MOTORS TRANSPORT','2019-12-17 15:50:38','',''),('1','72',1062339,'','customer','1418',5000.00,0.00,'Payment Id 82597 for invoice:, receipt:  by JIKA TRASPORT','2019-12-17 15:51:22','',''),('1','72',1062810,'','supplier','98',0.00,534760.00,'Payment Id 107361 for invoice:115236, receipt:  by A.A Rano Nigeria Limited','2019-12-18 09:57:50','',''),('1','72',1062836,'','supplier','98',0.00,114400.00,'Payment Id 108076 for invoice:115239, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:04:23','',''),('1','72',1062838,'','supplier','98',0.00,289755.00,'Payment Id 108075 for invoice:115239, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:04:23','',''),('1','72',1062840,'','supplier','98',0.00,236255.00,'Payment Id 99043 for invoice:110779, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:04:23','',''),('1','72',1062844,'','supplier','98',0.00,44485.00,'Payment Id 112610 for invoice:117392, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:06:03','',''),('1','72',1062850,'','supplier','98',0.00,17875.00,'Payment Id 112857 for invoice:117613, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:07:33','',''),('1','72',1062852,'','supplier','98',0.00,220000.00,'Payment Id 112856 for invoice:117613, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:07:33','',''),('1','72',1062854,'','supplier','98',0.00,217410.00,'Payment Id 112855 for invoice:117613, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:07:34','',''),('1','72',1062856,'','supplier','98',0.00,2900.00,'Payment Id 112613 for invoice:117510, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:07:34','',''),('1','72',1062858,'','supplier','98',0.00,88000.00,'Payment Id 112612 for invoice:117510, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:07:34','',''),('1','72',1062860,'','supplier','98',0.00,269975.00,'Payment Id 112611 for invoice:117510, receipt:  by A.A Rano Nigeria Limited','2019-12-18 10:11:03','',''),('1','72',1081122,'','supplier','98',0.00,88000.00,'Payment Id 113861 for invoice:118167, receipt:  by A.A Rano Nigeria Limited','2020-01-09 15:33:40','',''),('1','72',1081124,'','supplier','98',0.00,220000.00,'Payment Id 113859 for invoice:118167, receipt:  by A.A Rano Nigeria Limited','2020-01-09 15:33:40','',''),('1','72',1081126,'','supplier','98',0.00,129000.00,'Payment Id 113858 for invoice:118167, receipt:  by A.A Rano Nigeria Limited','2020-01-09 15:33:40','',''),('1','72',1081128,'','supplier','98',0.00,250885.00,'Payment Id 113857 for invoice:118167, receipt:  by A.A Rano Nigeria Limited','2020-01-09 15:33:40','',''),('1','72',1081130,'','supplier','98',0.00,10000.00,'Payment Id 113439 for invoice:117908, receipt:  by A.A Rano Nigeria Limited','2020-01-09 15:33:41','',''),('1','72',1098261,'','supplier','98',3431250.00,0.00,'Purchase Id 42934 for 15,250 litters of AGO - 002 from A.A Rano Nigeria Limited','2020-01-24 11:17:46','',''),('1','72',1130649,'','supplier','98',3850000.00,0.00,'Purchase Id 44259 for 17,500 litters of Diesel - AGO from A.A Rano Nigeria Limited','2020-02-26 10:52:24','',''),('1','72',1135634,'','supplier','98',0.00,44800.00,'Payment Id 130639 for invoice:127042, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135636,'','supplier','98',0.00,142260.00,'Payment Id 130637 for invoice:127041, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135638,'','supplier','98',0.00,20000.00,'Payment Id 130636 for invoice:127041, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135640,'','supplier','98',0.00,10250.00,'Payment Id 130634 for invoice:127041, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135642,'','supplier','98',0.00,122500.00,'Payment Id 130633 for invoice:127039, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135644,'','supplier','98',0.00,125180.00,'Payment Id 130632 for invoice:127036, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135646,'','supplier','98',0.00,53335.00,'Payment Id 130631 for invoice:127035, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135648,'','supplier','98',0.00,91665.00,'Payment Id 130630 for invoice:127032, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135650,'','supplier','98',0.00,31130.00,'Payment Id 130629 for invoice:127030, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:15','',''),('1','72',1135652,'','supplier','98',0.00,103375.00,'Payment Id 130628 for invoice:127029, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135654,'','supplier','98',0.00,115375.00,'Payment Id 130627 for invoice:127027, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135656,'','supplier','98',0.00,18000.00,'Payment Id 130626 for invoice:127026, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135658,'','supplier','98',0.00,86000.00,'Payment Id 130625 for invoice:127024, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135660,'','supplier','98',0.00,67580.00,'Payment Id 130624 for invoice:127024, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135662,'','supplier','98',0.00,97600.00,'Payment Id 130623 for invoice:127021, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135664,'','supplier','98',0.00,96750.00,'Payment Id 130622 for invoice:127021, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135666,'','supplier','98',0.00,47875.00,'Payment Id 130621 for invoice:127021, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135668,'','supplier','98',0.00,13700.00,'Payment Id 130620 for invoice:127019, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135670,'','supplier','98',0.00,13000.00,'Payment Id 130619 for invoice:127018, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135672,'','supplier','98',0.00,21500.00,'Payment Id 130618 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:16','',''),('1','72',1135674,'','supplier','98',0.00,33760.00,'Payment Id 130617 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135676,'','supplier','98',0.00,30250.00,'Payment Id 130616 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135678,'','supplier','98',0.00,32000.00,'Payment Id 130615 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135680,'','supplier','98',0.00,34235.00,'Payment Id 130613 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135682,'','supplier','98',0.00,129000.00,'Payment Id 130611 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135684,'','supplier','98',0.00,193500.00,'Payment Id 130610 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135686,'','supplier','98',0.00,77380.00,'Payment Id 130609 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135688,'','supplier','98',0.00,56620.00,'Payment Id 130608 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135690,'','supplier','98',0.00,119325.00,'Payment Id 130607 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135692,'','supplier','98',0.00,170510.00,'Payment Id 130606 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:17','',''),('1','72',1135694,'','supplier','98',0.00,202695.00,'Payment Id 130605 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:18','',''),('1','72',1135696,'','supplier','98',0.00,242680.00,'Payment Id 130604 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:18','',''),('1','72',1135698,'','supplier','98',0.00,439330.00,'Payment Id 130603 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:18','',''),('1','72',1135700,'','supplier','98',0.00,258235.00,'Payment Id 130602 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:18','',''),('1','72',1135702,'','supplier','98',0.00,158850.00,'Payment Id 130601 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:18','',''),('1','72',1135704,'','supplier','98',0.00,86000.00,'Payment Id 130600 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:18','',''),('1','72',1135706,'','supplier','98',0.00,10000.00,'Payment Id 130599 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:18','',''),('1','72',1135708,'','supplier','98',0.00,24000.00,'Payment Id 130598 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-03 10:27:18','',''),('1','72',1141534,'','supplier','98',0.00,16320.00,'Payment Id 131998 for invoice:127126, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:28','',''),('1','72',1141536,'','supplier','98',0.00,21000.00,'Payment Id 131996 for invoice:127125, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:28','',''),('1','72',1141538,'','supplier','98',0.00,239960.00,'Payment Id 131994 for invoice:127124, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:28','',''),('1','72',1141540,'','supplier','98',0.00,49890.00,'Payment Id 131993 for invoice:127123, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:28','',''),('1','72',1141542,'','supplier','98',0.00,54685.00,'Payment Id 131738 for invoice:127122, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:28','',''),('1','72',1141544,'','supplier','98',0.00,153610.00,'Payment Id 131178 for invoice:127064, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:28','',''),('1','72',1141546,'','supplier','98',0.00,22550.00,'Payment Id 131177 for invoice:127062, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:28','',''),('1','72',1141548,'','supplier','98',0.00,8000.00,'Payment Id 131176 for invoice:127061, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141550,'','supplier','98',0.00,42840.00,'Payment Id 131175 for invoice:127061, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141552,'','supplier','98',0.00,111900.00,'Payment Id 131172 for invoice:127060, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141554,'','supplier','98',0.00,114200.00,'Payment Id 131170 for invoice:127060, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141556,'','supplier','98',0.00,19695.00,'Payment Id 131166 for invoice:127060, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141558,'','supplier','98',0.00,51400.00,'Payment Id 131164 for invoice:127057, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141560,'','supplier','98',0.00,57495.00,'Payment Id 131162 for invoice:127056, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141562,'','supplier','98',0.00,49500.00,'Payment Id 131159 for invoice:127055, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141564,'','supplier','98',0.00,5000.00,'Payment Id 131157 for invoice:127055, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141566,'','supplier','98',0.00,160300.00,'Payment Id 131156 for invoice:127055, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141568,'','supplier','98',0.00,8160.00,'Payment Id 131152 for invoice:127054, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141570,'','supplier','98',0.00,176950.00,'Payment Id 131150 for invoice:127052, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141572,'','supplier','98',0.00,62500.00,'Payment Id 130956 for invoice:127051, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:29','',''),('1','72',1141574,'','supplier','98',0.00,76400.00,'Payment Id 130953 for invoice:127051, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:30','',''),('1','72',1141576,'','supplier','98',0.00,10965.00,'Payment Id 130951 for invoice:127048, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:30','',''),('1','72',1141578,'','supplier','98',0.00,170000.00,'Payment Id 130948 for invoice:127048, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:30','',''),('1','72',1141580,'','supplier','98',0.00,11000.00,'Payment Id 130947 for invoice:127044, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:30','',''),('1','72',1141582,'','supplier','98',0.00,204480.00,'Payment Id 113437 for invoice:117908, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:42:30','',''),('1','72',1141586,'','supplier','98',0.00,121820.00,'Payment Id 132153 for invoice:127132, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141588,'','supplier','98',0.00,33000.00,'Payment Id 132148 for invoice:127131, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141590,'','supplier','98',0.00,50000.00,'Payment Id 132147 for invoice:127131, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141592,'','supplier','98',0.00,10000.00,'Payment Id 132146 for invoice:127131, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141594,'','supplier','98',0.00,101250.00,'Payment Id 132012 for invoice:127132, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141596,'','supplier','98',0.00,58250.00,'Payment Id 132011 for invoice:127132, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141598,'','supplier','98',0.00,4000.00,'Payment Id 132008 for invoice:127128, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141600,'','supplier','98',0.00,89910.00,'Payment Id 132006 for invoice:127128, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141602,'','supplier','98',0.00,87750.00,'Payment Id 132003 for invoice:127127, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141604,'','supplier','98',0.00,6750.00,'Payment Id 132001 for invoice:127127, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141606,'','supplier','98',0.00,116700.00,'Payment Id 132000 for invoice:127127, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:16','',''),('1','72',1141608,'','supplier','98',0.00,79100.00,'Payment Id 131999 for invoice:127127, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:48:17','',''),('1','72',1141610,'','supplier','98',0.00,107830.00,'Payment Id 132180 for invoice:127345, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:50','',''),('1','72',1141612,'','supplier','98',0.00,50000.00,'Payment Id 132179 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:50','',''),('1','72',1141614,'','supplier','98',0.00,1115.00,'Payment Id 132177 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:50','',''),('1','72',1141616,'','supplier','98',0.00,150160.00,'Payment Id 132175 for invoice:127140, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:50','',''),('1','72',1141618,'','supplier','98',0.00,61035.00,'Payment Id 132173 for invoice:127139, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:50','',''),('1','72',1141620,'','supplier','98',0.00,20000.00,'Payment Id 132172 for invoice:127138, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:50','',''),('1','72',1141622,'','supplier','98',0.00,109500.00,'Payment Id 132170 for invoice:127138, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:51','',''),('1','72',1141624,'','supplier','98',0.00,90300.00,'Payment Id 132166 for invoice:127137, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:51','',''),('1','72',1141626,'','supplier','98',0.00,37395.00,'Payment Id 132163 for invoice:127137, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:51','',''),('1','72',1141628,'','supplier','98',0.00,10300.00,'Payment Id 132161 for invoice:127137, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:51','',''),('1','72',1141630,'','supplier','98',0.00,67205.00,'Payment Id 132160 for invoice:127134, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:51','',''),('1','72',1141632,'','supplier','98',0.00,57080.00,'Payment Id 132158 for invoice:127133, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:51','',''),('1','72',1141634,'','supplier','98',0.00,143000.00,'Payment Id 132157 for invoice:127132, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:51','',''),('1','72',1141636,'','supplier','98',0.00,110000.00,'Payment Id 132155 for invoice:127132, receipt:  by A.A Rano Nigeria Limited','2020-03-10 10:51:51','',''),('1','72',1141776,'','supplier','98',0.00,310000.00,'Payment Id 132151 for invoice:127131, receipt:  by A.A Rano Nigeria Limited','2020-03-10 11:23:39','',''),('1','72',1151249,'','supplier','98',0.00,53335.00,'Payment Id 132690 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:53','',''),('1','72',1151251,'','supplier','98',0.00,91665.00,'Payment Id 132689 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:53','',''),('1','72',1151253,'','supplier','98',0.00,31130.00,'Payment Id 132688 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151255,'','supplier','98',0.00,103375.00,'Payment Id 132687 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151257,'','supplier','98',0.00,115375.00,'Payment Id 132686 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151259,'','supplier','98',0.00,18000.00,'Payment Id 132684 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151261,'','supplier','98',0.00,86000.00,'Payment Id 132680 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151263,'','supplier','98',0.00,67580.00,'Payment Id 132678 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151265,'','supplier','98',0.00,97600.00,'Payment Id 132676 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151267,'','supplier','98',0.00,96750.00,'Payment Id 132675 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151269,'','supplier','98',0.00,47875.00,'Payment Id 132674 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151271,'','supplier','98',0.00,13700.00,'Payment Id 132673 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151273,'','supplier','98',0.00,13000.00,'Payment Id 132672 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151275,'','supplier','98',0.00,10000.00,'Payment Id 132670 for invoice:127868, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:54','',''),('1','72',1151277,'','supplier','98',0.00,89900.00,'Payment Id 132669 for invoice:127868, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:55','',''),('1','72',1151279,'','supplier','98',0.00,99100.00,'Payment Id 132186 for invoice:127867, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:55','',''),('1','72',1151281,'','supplier','98',0.00,24000.00,'Payment Id 132185 for invoice:127867, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:55','',''),('1','72',1151283,'','supplier','98',0.00,25650.00,'Payment Id 132184 for invoice:127867, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:55','',''),('1','72',1151285,'','supplier','98',0.00,14000.00,'Payment Id 132183 for invoice:127865, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:55','',''),('1','72',1151287,'','supplier','98',0.00,19250.00,'Payment Id 132182 for invoice:127398, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:55','',''),('1','72',1151289,'','supplier','98',0.00,106960.00,'Payment Id 132181 for invoice:127348, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:56','',''),('1','72',1151291,'','supplier','98',0.00,197640.00,'Payment Id 130597 for invoice:127160, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:47:56','',''),('1','72',1151293,'','supplier','98',0.00,66065.00,'Payment Id 132731 for invoice:127976, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:49:46','',''),('1','72',1151295,'','supplier','98',0.00,101130.00,'Payment Id 132727 for invoice:127869, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:49:46','',''),('1','72',1151297,'','supplier','98',0.00,44800.00,'Payment Id 132699 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:49:46','',''),('1','72',1151299,'','supplier','98',0.00,142260.00,'Payment Id 132697 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:49:46','',''),('1','72',1151301,'','supplier','98',0.00,20000.00,'Payment Id 132696 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-18 14:49:46','',''),('1','72',1162768,'','supplier','98',0.00,100400.00,'Payment Id 137010 for invoice:130534, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162770,'','supplier','98',0.00,26040.00,'Payment Id 137009 for invoice:130534, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162772,'','supplier','98',0.00,21600.00,'Payment Id 137008 for invoice:130233, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162774,'','supplier','98',0.00,118250.00,'Payment Id 136489 for invoice:130100, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162776,'','supplier','98',0.00,13200.00,'Payment Id 136486 for invoice:130100, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162778,'','supplier','98',0.00,116000.00,'Payment Id 136134 for invoice:130097, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162780,'','supplier','98',0.00,24750.00,'Payment Id 136131 for invoice:130100, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162782,'','supplier','98',0.00,8700.00,'Payment Id 136129 for invoice:130096, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162784,'','supplier','98',0.00,216165.00,'Payment Id 136127 for invoice:130093, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:02','',''),('1','72',1162786,'','supplier','98',0.00,40700.00,'Payment Id 136125 for invoice:129442, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162788,'','supplier','98',0.00,50000.00,'Payment Id 134950 for invoice:129280, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162790,'','supplier','98',0.00,15300.00,'Payment Id 134949 for invoice:129280, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162792,'','supplier','98',0.00,79000.00,'Payment Id 134686 for invoice:129169, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162794,'','supplier','98',0.00,51300.00,'Payment Id 134685 for invoice:129169, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162796,'','supplier','98',0.00,11640.00,'Payment Id 134683 for invoice:129167, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162798,'','supplier','98',0.00,10960.00,'Payment Id 134682 for invoice:12163, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162800,'','supplier','98',0.00,96750.00,'Payment Id 134463 for invoice:129161, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162802,'','supplier','98',0.00,23950.00,'Payment Id 134462 for invoice:129161, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162804,'','supplier','98',0.00,4825.00,'Payment Id 134461 for invoice:129160, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162806,'','supplier','98',0.00,25375.00,'Payment Id 134460 for invoice:128488, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:19:03','',''),('1','72',1162808,'','supplier','98',0.00,208870.00,'Payment Id 133202 for invoice:128384, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:08','',''),('1','72',1162810,'','supplier','98',0.00,65100.00,'Payment Id 132978 for invoice:128256, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:08','',''),('1','72',1162812,'','supplier','98',0.00,108750.00,'Payment Id 132976 for invoice:128256, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:08','',''),('1','72',1162814,'','supplier','98',0.00,181015.00,'Payment Id 132975 for invoice:128256, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:09','',''),('1','72',1162816,'','supplier','98',0.00,30300.00,'Payment Id 132740 for invoice:128233, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:09','',''),('1','72',1162818,'','supplier','98',0.00,37070.00,'Payment Id 132733 for invoice:128233, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:09','',''),('1','72',1162820,'','supplier','98',0.00,10250.00,'Payment Id 132695 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:09','',''),('1','72',1162822,'','supplier','98',0.00,122500.00,'Payment Id 132693 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:09','',''),('1','72',1162824,'','supplier','98',0.00,125180.00,'Payment Id 132692 for invoice:123456, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:09','',''),('1','72',1162826,'','supplier','98',0.00,41830.00,'Payment Id 132010 for invoice:127131, receipt:  by A.A Rano Nigeria Limited','2020-03-30 12:21:09','',''),('1','72',1189442,'','supplier','98',2680000.00,0.00,'Purchase Id 47144 for 13,400 litters of Diesel - AGO from A.A Rano Nigeria Limited','2020-05-10 11:24:13','',''),('1','72',1197235,'','supplier','98',0.00,109640.00,'Payment Id 147401 for invoice:135428, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197237,'','supplier','98',0.00,5000.00,'Payment Id 146366 for invoice:135322, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197239,'','supplier','98',0.00,40875.00,'Payment Id 146365 for invoice:135209, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197241,'','supplier','98',0.00,50000.00,'Payment Id 145839 for invoice:135118, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197243,'','supplier','98',0.00,98960.00,'Payment Id 145838 for invoice:135118, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197245,'','supplier','98',0.00,20000.00,'Payment Id 145837 for invoice:135118, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197247,'','supplier','98',0.00,26200.00,'Payment Id 145836 for invoice:135118, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197249,'','supplier','98',0.00,41840.00,'Payment Id 145835 for invoice:135118, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197251,'','supplier','98',0.00,48300.00,'Payment Id 145657 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197253,'','supplier','98',0.00,92840.00,'Payment Id 145655 for invoice:12345, receipt:  by A.A Rano Nigeria Limited','2020-05-18 12:49:19','',''),('1','72',1197255,'','customer','1382',30300.00,0.00,'Payment Id 84583 for invoice:, receipt:  by A.A.Y MOTORS COMP.','2020-05-18 12:50:09','',''),('1','72',1197257,'','customer','1380',10000.00,0.00,'Payment Id 84585 for invoice:, receipt:  by DANMA KAI MOTORS','2020-05-18 12:50:30','',''),('1','72',1197259,'','customer','1421',10000.00,0.00,'Payment Id 83064 for invoice:, receipt:  by NANU TRASPORT','2020-05-18 12:50:42','',''),('1','72',1197261,'','customer','1387',110000.00,0.00,'Payment Id 82398 for invoice:, receipt:  by B. A. L MOTORS','2020-05-18 12:51:19','',''),('1','72',1215195,'','supplier','98',0.00,10130.00,'Payment Id 147959 for invoice:136142, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:08:39','',''),('1','72',1215197,'','supplier','98',0.00,13000.00,'Payment Id 147956 for invoice:136140, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:08:39','',''),('1','72',1215199,'','supplier','98',0.00,6000.00,'Payment Id 147951 for invoice:135780, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:08:39','',''),('1','72',1215201,'','supplier','98',0.00,72900.00,'Payment Id 147950 for invoice:135778, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:08:39','',''),('1','72',1215203,'','supplier','98',0.00,132400.00,'Payment Id 147407 for invoice:135560, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:08:39','',''),('1','72',1215223,'','supplier','98',0.00,20320.00,'Payment Id 148357 for invoice:136570, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:42:25','',''),('1','72',1215225,'','supplier','98',0.00,50530.00,'Payment Id 147962 for invoice:136143, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:42:26','',''),('1','72',1215241,'','supplier','98',0.00,32900.00,'Payment Id 151671 for invoice:138471, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215243,'','supplier','98',0.00,26590.00,'Payment Id 151656 for invoice:138468, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215245,'','supplier','98',0.00,104745.00,'Payment Id 151655 for invoice:138465, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215247,'','supplier','98',0.00,24440.00,'Payment Id 151654 for invoice:138462, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215249,'','supplier','98',0.00,12160.00,'Payment Id 151479 for invoice:138041, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215251,'','supplier','98',0.00,22300.00,'Payment Id 150798 for invoice:137910, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215253,'','supplier','98',0.00,21500.00,'Payment Id 150574 for invoice:137769, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215255,'','supplier','98',0.00,13500.00,'Payment Id 150269 for invoice:137768, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215257,'','supplier','98',0.00,92000.00,'Payment Id 150268 for invoice:137768, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215259,'','supplier','98',0.00,64300.00,'Payment Id 150266 for invoice:137768, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215261,'','supplier','98',0.00,48110.00,'Payment Id 150263 for invoice:137422, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:12','',''),('1','72',1215263,'','supplier','98',0.00,90000.00,'Payment Id 149743 for invoice:137255, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215265,'','supplier','98',0.00,120000.00,'Payment Id 149742 for invoice:137255, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215267,'','supplier','98',0.00,48100.00,'Payment Id 149741 for invoice:137255, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215269,'','supplier','98',0.00,84100.00,'Payment Id 149624 for invoice:137254, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215271,'','supplier','98',0.00,88000.00,'Payment Id 149623 for invoice:137254, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215273,'','supplier','98',0.00,90000.00,'Payment Id 149258 for invoice:137253, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215275,'','supplier','98',0.00,14250.00,'Payment Id 149257 for invoice:137253, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215277,'','supplier','98',0.00,106375.00,'Payment Id 149255 for invoice:137252, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215279,'','supplier','98',0.00,35150.00,'Payment Id 149254 for invoice:137251, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215281,'','supplier','98',0.00,9970.00,'Payment Id 149253 for invoice:136572, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215283,'','supplier','98',0.00,29500.00,'Payment Id 148356 for invoice:136331, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1215285,'','supplier','98',0.00,23000.00,'Payment Id 147972 for invoice:136329, receipt:  by A.A Rano Nigeria Limited','2020-06-09 15:53:13','',''),('1','72',1224318,'','supplier','98',0.00,94650.00,'Payment Id 154541 for invoice:139817, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1224320,'','supplier','98',0.00,117000.00,'Payment Id 154229 for invoice:139817, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1224322,'','supplier','98',0.00,20000.00,'Payment Id 154227 for invoice:139817, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1224324,'','supplier','98',0.00,8250.00,'Payment Id 154226 for invoice:139817, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1224326,'','supplier','98',0.00,16200.00,'Payment Id 154224 for invoice:139816, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1224328,'','supplier','98',0.00,74800.00,'Payment Id 154223 for invoice:139814, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1224330,'','supplier','98',0.00,56750.00,'Payment Id 154222 for invoice:139812, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1224332,'','supplier','98',0.00,41900.00,'Payment Id 154220 for invoice:139809, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1224334,'','supplier','98',0.00,28800.00,'Payment Id 154218 for invoice:138605, receipt:  by A.A Rano Nigeria Limited','2020-06-19 10:57:22','',''),('1','72',1238279,'','supplier','98',0.00,59250.00,'Payment Id 156047 for invoice:154541, receipt:  by A.A Rano Nigeria Limited','2020-07-01 13:25:40','',''),('1','72',1238281,'','supplier','98',0.00,88150.00,'Payment Id 155770 for invoice:154541, receipt:  by A.A Rano Nigeria Limited','2020-07-01 13:25:40','',''),('1','72',1238283,'','supplier','98',0.00,83300.00,'Payment Id 155765 for invoice:154541, receipt:  by A.A Rano Nigeria Limited','2020-07-01 13:25:40','',''),('1','72',3766541,'','24','1721',18000.00,65207000.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3766680,'','24','1725',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3766722,'','24','1733',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3766786,'','24','1744',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3766796,'','24','1737',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3767076,'','24','1722',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3767082,'','24','1723',0.00,10500.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3767124,'','24','1724',0.00,42600.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3767173,'','2','1740',65409375.00,2678000.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3767687,'','24','1734',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3767690,'','24','1728',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3767891,'','2','1746',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3768114,'','5','1741',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3768238,'','24','1736',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3768263,'','24','1738',0.00,40000.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3768326,'','24','1727',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3768651,'','24','1731',0.00,4500.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3768688,'','24','1732',0.00,400.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3769206,'','24','1726',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3769353,'','24','1739',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3769547,'','24','1730',0.00,1600.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3769575,'','24','1745',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3769753,'','24','1729',0.00,6500.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3769841,'','5','1743',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3770045,'','6','1747',20000.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3770316,'','20','1742',60550603.35,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3770319,'','6.1','1749',378100.00,60754603.35,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','72',3770350,'','24','1735',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=228 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (225,'1','72','PMS','Petrol','Litres',1,140.00,0.00,0.00,0.00,0.00,0,'2018-11-05 16:22:01','404','404','2018-11-05 16:22:01',1),(226,'1','72','AGO','Diesel','Litres',1,200.00,225.00,0.00,0.00,0.00,0,'2018-11-05 16:23:32','404','404','2018-11-05 16:23:32',1),(227,'1','72','DPK','Kerosene','Litres',1,0.00,0.00,0.00,0.00,0.00,0,'2018-11-05 16:23:55','404','404','2018-11-05 16:23:55',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=8020 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (4836,'1','72',226,260.00,260.00,0.00,0.00,'','2018-11-30 11:31:25','408'),(5024,'1','72',226,255.00,255.00,0.00,0.00,'decrement of pump price from 260 to 255','2018-12-20 10:19:02','408'),(5075,'1','72',226,250.00,250.00,0.00,0.00,'decrement of pump price from 255 to 250','2018-12-21 16:35:06','408'),(5077,'1','72',226,255.00,255.00,0.00,0.00,'decrement of pump price from 260 to 255','2018-12-21 16:45:44','408'),(5103,'1','72',226,250.00,250.00,0.00,0.00,'decrement of pump price from 255 to 250','2018-12-22 12:51:30','408'),(5132,'1','72',226,245.00,245.00,0.00,0.00,'decrement of pump price from 250 to 245','2018-12-25 16:25:07','408'),(5246,'1','72',226,240.00,240.00,0.00,0.00,'decrement of pump price from 245 to 240','2019-01-07 09:06:47','408'),(5372,'1','72',226,230.00,230.00,0.00,0.00,'decrement of pump price from 240 to 230','2019-01-26 10:40:18','408'),(5421,'1','72',226,225.00,225.00,0.00,0.00,'decrement of pump price from 230 to 225','2019-01-29 10:58:39','408'),(6264,'1','72',225,140.00,0.00,0.00,0.00,'Cost from purchase id #34982','2019-07-18 13:42:13','408'),(6272,'1','72',226,220.00,225.00,0.00,0.00,'Cost from purchase id #35240','2019-07-23 17:27:05','408'),(6549,'1','72',226,215.00,225.00,0.00,0.00,'Cost from purchase id #36755','2019-09-06 12:46:56','409'),(6964,'1','72',226,220.00,225.00,0.00,0.00,'Cost from purchase id #39659','2019-11-13 11:06:33','409'),(7397,'1','72',226,225.00,225.00,0.00,0.00,'Cost from purchase id #42934','2020-01-24 11:17:46','125'),(7590,'1','72',226,220.00,225.00,0.00,0.00,'Cost from purchase id #44259','2020-02-26 10:52:24','125'),(8019,'1','72',226,200.00,225.00,0.00,0.00,'Cost from purchase id #47144','2020-05-10 11:24:13','125');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=47145 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (26693,'1','72','2018-12-07',226,98,260.00,11750.00,0.00,0.00,3055000.00,0.00,'','174895','AA RANO 70','','','','2018-12-07 09:00:18',15,'PURCHASE OF A G O','408','','0000-00-00 00:00:00','409','2018-12-07 10:32:09'),(27398,'1','72','2018-12-22',226,98,250.00,12000.00,0.00,0.00,3000000.00,0.00,'','08039573952',' XH 227 DAL','','','','2018-12-23 15:56:11',15,'PURCHASE OF A G O','408','','0000-00-00 00:00:00','409','2018-12-24 15:45:23'),(27944,'1','72','2019-01-06',226,98,240.00,15000.00,0.00,0.00,3600000.00,0.00,'','165558','KUJ 873 XT','','','','2019-01-07 09:12:24',15,'DISCHARGE OF A G O','408','','0000-00-00 00:00:00','409','2019-01-09 12:53:04'),(28594,'1','72','2019-01-22',226,98,240.00,19750.00,0.00,0.00,4740000.00,0.00,'','170663','ksf 932 xs','','','','2019-01-23 15:36:18',15,'DISCHAGE OF A G O','408','','0000-00-00 00:00:00','409','2019-01-24 08:30:40'),(29163,'1','72','2019-02-07',226,98,225.00,33000.00,0.00,0.00,7425000.00,0.00,'','158137','RAN 827 XA','','','','2019-02-08 09:44:04',15,'DISCHARGE OF A G O','408','','0000-00-00 00:00:00','409','2019-02-08 13:59:44'),(32994,'1','72','2019-05-19',226,98,225.00,21800.00,0.00,0.00,4905000.00,0.00,'','09068823666','XF 187 FGE','','','','2019-05-21 12:41:16',15,'PURCHASE OF AGO','408','','0000-00-00 00:00:00','409','2019-05-22 15:33:33'),(34982,'1','72','2019-07-13',225,98,140.00,14800.00,0.00,0.00,2072000.00,0.00,'','181079','KG 873 ZT','','','','2019-07-15 14:59:10',15,'PURCHASES OF PMS','408','','0000-00-00 00:00:00','408','2019-07-18 13:42:13'),(35240,'1','72','2019-07-23',226,98,220.00,13600.00,0.00,0.00,2992000.00,0.00,'','15656','KZR 495 XA','','','','2019-07-23 17:25:43',15,'PURCHASE OF AGO','408','','0000-00-00 00:00:00','408','2019-07-23 17:27:05'),(35453,'1','72','2019-07-30',225,98,140.00,32700.00,0.00,0.00,4578000.00,0.00,'','16037','RAN 824 XA','','','','2019-07-30 12:24:41',5,'DISCHASE OF PMS','408','','0000-00-00 00:00:00','408','2019-07-30 14:05:03'),(35934,'1','72','2019-08-09',226,98,220.00,13650.00,0.00,0.00,3003000.00,0.00,'','31541','NSR 79 ZQ','','','','2019-08-14 15:29:04',15,'DISCHAGE OF AGO','408','','0000-00-00 00:00:00','408','2019-08-14 15:35:11'),(36755,'1','72','2019-08-22',226,98,215.00,15850.00,0.00,0.00,3407750.00,0.00,'','12345','RAN 509 XA','','','','2019-09-05 19:25:03',15,'PURCHASE OF AGO','408','','0000-00-00 00:00:00','409','2019-09-06 12:46:56'),(37290,'1','72','2019-09-17',226,98,215.00,25400.00,0.00,0.00,5461000.00,0.00,'','12345','TRN 35 XX','','','','2019-09-18 19:52:13',15,'PURCHASE OF AGO','408','','0000-00-00 00:00:00','409','2019-09-19 14:11:57'),(39659,'1','72','2019-11-12',226,98,220.00,14850.00,0.00,0.00,3267000.00,0.00,'','12345','TRN 88 YZ','','','','2019-11-12 18:09:29',15,'PURCHASE OF A G O','408','','0000-00-00 00:00:00','409','2019-11-13 11:06:33'),(40916,'1','72','2019-12-06',226,98,220.00,17000.00,0.00,0.00,3740000.00,0.00,'','61896','UGG 478 XA','','','','2019-12-09 18:29:28',15,'PURCHASE OF AGO','408','','0000-00-00 00:00:00','409','2019-12-09 19:48:26'),(42934,'1','72','2020-01-21',226,98,225.00,15250.00,0.00,0.00,3431250.00,0.00,'','12345','RAN 403 XA','','','','2020-01-21 16:06:41',15,'PURCHASE OF AGO','408','','0000-00-00 00:00:00','125','2020-01-24 11:17:46'),(44259,'1','72','2020-02-20',226,98,220.00,17500.00,0.00,0.00,3850000.00,0.00,'','12345','FGE 49 ZY','','','','2020-02-20 15:37:48',15,'PURCHASE OF AGO','408','','0000-00-00 00:00:00','125','2020-02-26 10:52:24'),(47144,'1','72','2020-03-27',226,98,200.00,13400.00,0.00,0.00,2680000.00,0.00,'','62738','NSL 515 ZY','','','','2020-05-10 08:44:25',15,'PURCHASE OF AGO','408','125','2020-05-10 11:23:32','125','2020-05-10 11:24:13');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=185521 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (29484,'1','72','2018-11-29',98,'','','5',101035.00,'70008','','','1740','MALUMFASH S/S','8054357105',0.00,'2018-12-07 08:16:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-12 12:54:48'),(29485,'1','72','2018-12-30',98,'','','5',366800.00,'70659','','','1740','MALUMFASH S/S','8054357120',0.00,'2018-12-07 08:20:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-12 12:55:12'),(29487,'1','72','2018-12-01',98,'','','5',128435.00,'70697','','','1740','MALUMFASH S/S','70697',0.00,'2018-12-07 08:28:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-12 12:59:52'),(29488,'1','72','2018-12-02',98,'','','5',258100.00,'70699','','','1740','MALUMFASH S/S','0054353851',0.00,'2018-12-07 08:32:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-12 13:01:03'),(29489,'1','72','2018-12-03',98,'','','5',176900.00,'70700','','','1740','MALUMFASH S/S','0054353850',0.00,'2018-12-07 08:37:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-12 13:02:56'),(29490,'1','72','2018-12-04',98,'','','5',95505.00,'70702','','','1740','MALUMFASH S/S','8054357115',0.00,'2018-12-07 08:42:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-12 13:06:22'),(29491,'1','72','2018-12-05',98,'','','5',186105.00,'70708','','','1740','MALUMFASH S/S','0054353853',0.00,'2018-12-07 08:45:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-12 13:07:01'),(29492,'1','72','2018-12-05',98,'','','5',511400.00,'70708','','','1740','MALUMFASH S/S','8054357111',0.00,'2018-12-07 08:49:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-12 13:11:22'),(30039,'1','72','2018-12-06',98,'','','5',235005.00,'71086','','','1740','','85616238',0.00,'2018-12-10 15:41:05',5,'payment on account','408','','0000-00-00 00:00:00','409','2018-12-12 13:18:16'),(30486,'1','72','2018-12-07',98,'','','5',149640.00,'70893','','','1740','MALUMFASH S/S','8054357117',0.00,'2018-12-12 14:44:09',5,'payment on account','408','','0000-00-00 00:00:00','409','2018-12-14 14:35:14'),(30487,'1','72','2018-12-08',98,'','','5',97020.00,'70896','','','1740','MALUMFASH S/S','8054357118',0.00,'2018-12-12 14:46:20',5,'payment on account','408','','0000-00-00 00:00:00','409','2018-12-14 14:35:28'),(30489,'1','72','2018-12-09',98,'','','5',199965.00,'71086','','','1740','MALUMFASH S/S','85616247',0.00,'2018-12-12 14:48:39',5,'payment on account','408','','0000-00-00 00:00:00','409','2018-12-14 14:35:44'),(31075,'1','72','2018-12-10',98,'','','5',88930.00,'71118','','','1740','MALUMFASH S/S','85616246',0.00,'2018-12-14 20:41:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-17 14:33:36'),(31076,'1','72','2018-12-11',98,'','','5',163265.00,'71373','','','1740','MALUMFASH S/S','85616245',0.00,'2018-12-14 20:47:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-17 14:33:50'),(31077,'1','72','2018-12-12',98,'','','5',157430.00,'71374','','','1740','MALUMFASH S/S','85616244',0.00,'2018-12-14 20:49:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-17 14:34:05'),(31078,'1','72','2018-12-13',98,'','','5',187610.00,'71508','','','1740','MALUMFASH S/S','85616241',0.00,'2018-12-14 20:52:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-17 14:34:17'),(31079,'1','72','2018-12-13',98,'','','5',418615.00,'71508','','','1740','MALUMFASH S/S','85616240',0.00,'2018-12-14 20:54:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-18 11:06:44'),(31614,'1','72','2018-12-14',98,'','','5',453635.00,'71638','','','1740','MALUMFASH S/S','85616235',0.00,'2018-12-17 17:19:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-18 11:07:02'),(31616,'1','72','2018-12-15',98,'','','5',426735.00,'72177','','','1740','MALUMFASH S/S','85616234',0.00,'2018-12-17 17:20:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-18 11:07:20'),(31821,'1','72','2018-12-16',98,'','','5',88700.00,'72179','','','1740','MALUMFASH S/S','85616348',0.00,'2018-12-18 15:24:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-24 16:39:49'),(31822,'1','72','2018-12-17',98,'','','5',290025.00,'72206','','','1740','MALUMFASH S/S','85616349',0.00,'2018-12-18 15:26:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-24 16:40:20'),(32090,'1','72','2018-12-18',98,'','','5',142305.00,'72209','','','1740','MALUMFASH S/S','85616346',0.00,'2018-12-19 19:00:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-24 16:40:34'),(32851,'1','72','2018-12-19',98,'','','5',265270.00,'72489','','','1740','MALUMFASH S/S','85616233',0.00,'2018-12-24 15:12:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-24 16:40:48'),(32852,'1','72','2018-12-20',98,'','','5',210255.00,'72713','','','1740','MALUMFASH S/S','85616230',0.00,'2018-12-24 15:13:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-24 16:41:02'),(32855,'1','72','2018-12-21',98,'','','5',26150.00,'72718','','','1740','MALUMFASH S/S','85616229',0.00,'2018-12-24 15:16:17',5,'PAYMENT ON ACCOUNT','408','409','2019-02-08 15:23:43','409','2019-02-08 15:24:03'),(32857,'1','72','2018-12-21',98,'','','5',134015.00,'72799','','','1740','MALUMFASH S/S','85616231',0.00,'2018-12-24 15:18:01',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-24 16:41:30'),(32858,'1','72','2018-12-22',98,'','','5',213810.00,'72801','','','1740','MALUMFASH S/S','85616232',0.00,'2018-12-24 15:20:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-24 16:41:50'),(32861,'1','72','2018-12-23',98,'','','5',193600.00,'72955','','','1740','MALUMFASH S/S','85616228',0.00,'2018-12-24 15:24:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2018-12-24 16:42:04'),(33368,'1','72','2018-12-24',98,'','','5',164130.00,'73086','','','1740','MALUMFASH S/S','8054357119',0.00,'2018-12-27 13:57:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:33:26'),(33369,'1','72','2018-12-25',98,'','','5',19550.00,'73203','','','1740','MALUMFASH S/S','85616298',0.00,'2018-12-27 13:58:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:34:02'),(33374,'1','72','2018-12-25',98,'','','5',35560.00,'73206','','','1740','MALUMFASH S/S','85616297',0.00,'2018-12-27 14:03:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:34:35'),(33375,'1','72','2018-12-26',98,'','','5',166455.00,'73319','','','1740','MALUMFASH S/S','85616296',0.00,'2018-12-27 14:05:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:35:10'),(33690,'1','72','2018-12-27',98,'','','5',317350.00,'73410','','','1740','MALUMFASH S/S','85616236',0.00,'2018-12-28 14:29:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:35:37'),(34185,'1','72','2018-12-28',98,'','','5',353955.00,'73567','','','1740','MALUMFASH S/S','85616227',0.00,'2018-12-31 16:01:09',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:36:06'),(34186,'1','72','2018-12-29',98,'','','5',170935.00,'73748','','','1740','MALUMFASH S/S','85616237',0.00,'2018-12-31 16:02:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:36:27'),(34188,'1','72','2018-12-30',98,'','','5',118160.00,'73750','','','1740','MALUMFASH S/S','85616239',0.00,'2018-12-31 16:04:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:36:54'),(34190,'1','72','2018-12-30',98,'','','5',200000.00,'73750','','','1740','MALUMFASH S/S','85616226',0.00,'2018-12-31 16:06:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:37:10'),(35118,'1','72','2018-12-31',98,'','','5',304075.00,'73868','','','1740','MALUMFASH S/S','85616357',0.00,'2019-01-04 19:28:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:37:27'),(35119,'1','72','2018-12-31',98,'','','5',200000.00,'73868','','','1740','MALUMFASH S/S','85616355',0.00,'2019-01-04 19:30:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:37:58'),(35120,'1','72','2019-01-01',98,'','','5',168320.00,'74467','','','1740','MALUMFASH S/S','85616356',0.00,'2019-01-04 19:31:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:38:21'),(35121,'1','72','2019-01-02',98,'','','5',196055.00,'74468','','','1740','MALUMFASH S/S','85616341',0.00,'2019-01-04 19:34:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:38:41'),(35122,'1','72','2019-01-03',98,'','','5',319175.00,'74469','','','1740','MALUMFASH S/S','85616299',0.00,'2019-01-04 19:36:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:39:02'),(35123,'1','72','2019-01-03',98,'','','5',168320.00,'74469','','','1740','MALUMFASH S/S','85616342',0.00,'2019-01-04 19:40:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:39:45'),(35581,'1','72','2019-01-04',98,'','','5',282100.00,'74470','','','1740','MALUMFASH S/S','85600093',0.00,'2019-01-07 15:22:54',5,'PAYMENT ON ACC0UNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:40:23'),(35875,'1','72','2019-01-05',98,'','','5',129725.00,'74585','','','1740','MALUMFASH S/S','85600091',0.00,'2019-01-09 08:57:23',5,'PAYMENT ON ACCOUNT','408','409','2019-01-09 14:40:45','409','2019-01-09 14:41:00'),(35876,'1','72','2019-01-06',98,'','','5',122425.00,'74586','','','1740','MALUMFASH S/S','85600090',0.00,'2019-01-09 08:59:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-09 14:41:22'),(36060,'1','72','2019-01-07',98,'','','5',247100.00,'74705','','','1740','MALUMFASH S/S','85600089',0.00,'2019-01-09 14:53:23',5,'PAYMENT ON ACCOUNT','408','409','2019-01-11 14:02:31','409','2019-01-11 14:02:54'),(36428,'1','72','2019-01-08',98,'','','5',281045.00,'75048','','','1740','MALUMFASH S/S','85600088',0.00,'2019-01-11 14:38:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-16 16:52:28'),(36904,'1','72','2019-01-09',98,'','','5',180025.00,'75050','','','1740','MALUMFASH S/S','85619827',0.00,'2019-01-14 11:34:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-16 16:52:14'),(36909,'1','72','2019-01-10',98,'','','5',316185.00,'75100','','','1740','MALUMFASH S/S','85600087',0.00,'2019-01-14 11:38:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-16 16:52:00'),(36912,'1','72','2019-01-11',98,'','','5',196345.00,'75233','','','1740','MALUMFASH S/S','85600082',0.00,'2019-01-14 11:42:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-16 16:51:41'),(37170,'1','72','2019-01-12',98,'','','5',181810.00,'75365','','','1740','MALUMFASH S/S','85619826',0.00,'2019-01-15 12:56:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-16 16:52:46'),(37211,'1','72','2019-01-13',98,'','','5',58930.00,'75446','','','1740','MALUMFASH S/S','85600086',0.00,'2019-01-15 16:01:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-16 16:53:01'),(37214,'1','72','2019-01-14',98,'','','5',108600.00,'75595','','','1740','MALUMFASH S/S','85619825',0.00,'2019-01-15 16:03:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-16 16:53:19'),(37333,'1','72','2019-01-15',98,'','','5',190000.00,'75737','','','1740','MALUMFASH S/S','85619823',0.00,'2019-01-16 09:26:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-19 16:13:24'),(37637,'1','72','2019-01-16',98,'','','5',165345.00,'75811','','','1740','MALUMFASH S/S','85619820',0.00,'2019-01-17 14:43:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-19 16:13:34'),(37736,'1','72','2019-01-17',98,'','','5',301265.00,'76011','','','1740','MALUMFASH S/S','85619817',0.00,'2019-01-18 08:16:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-19 16:13:45'),(38893,'1','72','2019-01-18',98,'','','5',432335.00,'7605','','','1740','MALUMFASH S/S','85604016',0.00,'2019-01-23 08:28:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-24 10:28:28'),(38897,'1','72','2019-01-19',98,'','','5',128970.00,'76689','','','1740','MALUMFASH S/S','85604019',0.00,'2019-01-23 08:30:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-24 10:29:02'),(38898,'1','72','2019-01-20',98,'','','5',283995.00,'76691','','','1740','MALUMFASH S/S','85605790',0.00,'2019-01-23 08:33:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-24 10:29:40'),(38900,'1','72','2019-01-21',98,'','','5',147950.00,'76692','','','1740','MALUMFASH S/S','85619816',0.00,'2019-01-23 08:36:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-24 10:30:17'),(38901,'1','72','2019-01-21',98,'','','5',350000.00,'76692','','','1740','MALUMFASH S/S','85619815',0.00,'2019-01-23 08:38:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-24 10:45:39'),(39213,'1','72','2019-01-23',98,'','','5',473835.00,'76693','','','1740','MALUMFASH S/S','85605878',0.00,'2019-01-24 16:34:18',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-29 16:08:51'),(39777,'1','72','2019-01-24',98,'','','5',215880.00,'76903','','','1740','MALUMFASH S/S','856190808',0.00,'2019-01-28 11:34:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-29 16:09:07'),(39779,'1','72','2019-01-25',98,'','','5',125010.00,'77064','','','1740','MALUMFASH S/S','85619809',0.00,'2019-01-28 11:36:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-29 16:09:23'),(39781,'1','72','2019-01-25',98,'','','5',14600.00,'76933','','','1740','MALUMFASH S/S','85619807',0.00,'2019-01-28 11:38:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-29 16:10:05'),(39784,'1','72','2019-01-26',98,'','','5',170500.00,'77066','','','1740','MALUMFASH S/S','85619810',0.00,'2019-01-28 11:40:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-29 16:10:27'),(39861,'1','72','2019-01-27',98,'','','5',65860.00,'77272','','','1740','MALUMFASH S/S','85619811',0.00,'2019-01-28 14:43:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-01-29 16:10:43'),(40455,'1','72','2019-01-28',98,'','','5',9670.00,'77315','','','1740','MALUMFASH S/S','85605879',0.00,'2019-01-31 09:35:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:21:45'),(40457,'1','72','2019-01-28',98,'','','5',65050.00,'77462','','','1740','MALUMFASH S/S','85605880',0.00,'2019-01-31 09:37:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:22:14'),(40459,'1','72','2019-01-29',98,'','','5',315680.00,'77463','','','1740','MALUMFASH S/S','85619801',0.00,'2019-01-31 09:39:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:24:35'),(40530,'1','72','2019-01-30',98,'','','5',286000.00,'77687','','','1740','MALUMFASH S/S','85619802',0.00,'2019-01-31 13:45:41',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:25:00'),(41195,'1','72','2019-01-31',98,'','','5',185690.00,'77689','','','1740','MALUMFASH S/S','85619806',0.00,'2019-02-04 12:17:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:25:16'),(41196,'1','72','2019-02-01',98,'','','5',63500.00,'77823','','','1740','MALUMFASH S/S','85619803',0.00,'2019-02-04 12:18:44',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:25:31'),(41197,'1','72','2019-02-02',98,'','','5',250070.00,'78030','','','1740','MALUMFASH S/S','85600005',0.00,'2019-02-04 12:20:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:26:18'),(41198,'1','72','2019-02-03',98,'','','5',259680.00,'78034','','','1740','MALUMFASH S/S','85619805',0.00,'2019-02-04 12:22:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:28:00'),(41548,'1','72','2019-02-04',98,'','','5',215345.00,'78192','','','1740','MALUMFASH S/S','85600004',0.00,'2019-02-05 15:32:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:28:11'),(41752,'1','72','2019-02-05',98,'','','5',152095.00,'78387','','','1740','MALUMFASH S/S','85600002',0.00,'2019-02-06 12:28:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:28:36'),(42027,'1','72','2019-02-06',98,'','','5',548735.00,'78479','','','1740','MALUMFASH S/S','285907',0.00,'2019-02-07 15:56:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-08 15:29:39'),(42272,'1','72','2019-02-07',98,'','','5',114585.00,'78655','','','1740','MALUMFASH S/S','040530',0.00,'2019-02-09 09:04:27',5,'PAYMENT ON ACCOUNT','408','409','2019-02-18 13:14:53','409','2019-02-18 13:15:04'),(42707,'1','72','2019-02-08',98,'','','5',231100.00,'78943','','','1740','MALUMFASH S/S','267679',0.00,'2019-02-11 15:28:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-18 13:09:15'),(42709,'1','72','2019-02-09',98,'','','5',83870.00,'78944','','','1740','MALUMFASH S/S','013842',0.00,'2019-02-11 15:30:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-18 13:09:29'),(42906,'1','72','2019-02-10',98,'','','5',146450.00,'78945','','','1740','MALUMFASH S/S','131905',0.00,'2019-02-12 11:33:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-18 13:09:44'),(42908,'1','72','2019-02-11',98,'','','5',45690.00,'79065','','','1740','MALUMFASH S/S','131079',0.00,'2019-02-12 11:35:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-18 13:10:11'),(43391,'1','72','2019-02-12',98,'','','5',179255.00,'79236','','','1740','MALUMFASH S/S','013842',0.00,'2019-02-14 10:16:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-18 13:10:24'),(43392,'1','72','2019-02-12',98,'','','5',747595.00,'79236','','','1740','MALUMFASH S/S','013842',0.00,'2019-02-14 10:18:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-18 13:10:49'),(44076,'1','72','2019-02-13',98,'','','5',184350.00,'79453','','','1740','MALUMFASH S/S','017327',0.00,'2019-02-18 12:34:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-18 13:13:48'),(44168,'1','72','2019-02-14',98,'','','5',104175.00,'79457','','','1740','MALUMFASH S/S','013842',0.00,'2019-02-18 15:32:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-19 16:21:16'),(44169,'1','72','2019-02-15',98,'','','5',166890.00,'79929','','','1740','MALUMFASH S/S','332145',0.00,'2019-02-18 15:34:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-19 16:21:32'),(44471,'1','72','2019-02-16',98,'','','5',190515.00,'79930','','','1740','MALUMFASH S/S','013842',0.00,'2019-02-19 16:26:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 12:52:18'),(44472,'1','72','2019-02-17',98,'','','5',130430.00,'79931','','','1740','MALUMFASH S/S','199298',0.00,'2019-02-19 16:28:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 12:54:29'),(44473,'1','72','2019-02-17',98,'','','5',107000.00,'79931','','','1740','MALUMFASH S/S','0138421',0.00,'2019-02-19 16:30:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 12:54:52'),(44474,'1','72','2019-02-17',98,'','','5',70000.00,'79931','','','1740','MALUMFASH S/S','48619',0.00,'2019-02-19 16:31:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 13:00:50'),(44475,'1','72','2019-02-17',98,'','','5',58000.00,'79931','','','1740','MALUMFASH S/S','49029',0.00,'2019-02-19 16:33:41',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 13:03:08'),(44476,'1','72','2019-02-17',98,'','','5',112500.00,'79931','','','1740','MALUMFASH S/S','013842',0.00,'2019-02-19 16:35:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 13:05:40'),(44477,'1','72','2019-02-17',98,'','','5',35000.00,'79931','','','1740','MALUMFASH S/S','200575',0.00,'2019-02-19 16:36:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 13:06:18'),(44478,'1','72','2019-02-17',98,'','','5',125450.00,'79931','','','1740','MALUMFASH S/S','214499',0.00,'2019-02-19 16:39:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 13:08:59'),(44479,'1','72','2019-02-17',98,'','','5',20000.00,'79931','','','1740','MALUMFASH S/S','201454',0.00,'2019-02-19 16:41:34',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 13:09:14'),(44663,'1','72','2019-02-18',98,'','','5',128115.00,'79932','','','1740','MALUMFASH S/S','301423',0.00,'2019-02-20 14:51:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:08:16'),(44664,'1','72','2019-02-19',98,'','','5',56640.00,'80134','','','1740','MALUMFASH S/S','302660',0.00,'2019-02-20 14:54:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:10:50'),(44683,'1','72','2019-02-19',98,'','','5',90000.00,'80134','','','1740','MALUMFASH S/S','301966',0.00,'2019-02-20 15:49:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:11:27'),(44684,'1','72','2019-02-19',98,'','','5',10000.00,'80134','','','1740','MALUMFASH S/S','300887',0.00,'2019-02-20 15:51:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:11:52'),(44929,'1','72','2019-02-20',98,'','','5',59585.00,'80238','','','1740','MALUMFASH S/S','234486',0.00,'2019-02-21 15:30:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:12:51'),(44932,'1','72','2019-02-20',98,'','','5',100000.00,'80238','','','1740','MALUMFASH S/S','234939',0.00,'2019-02-21 15:32:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:13:29'),(44934,'1','72','2019-02-20',98,'','','5',213500.00,'80238','','','1740','MALUMFASH S/S','237160',0.00,'2019-02-21 15:35:44',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:15:00'),(44936,'1','72','2019-02-20',98,'','','5',15000.00,'80238','','','1740','MALUMFASH S/S','233985',0.00,'2019-02-21 15:38:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:15:32'),(44939,'1','72','2019-02-20',98,'','','5',60000.00,'8O238','','','1740','MALUMFASH S/S','291964',0.00,'2019-02-21 15:40:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:16:24'),(45111,'1','72','2019-02-20',98,'','','5',2500.00,'80238','','','1740','MALUMFASH S/S','138048',0.00,'2019-02-22 14:24:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:16:35'),(45112,'1','72','2019-02-20',98,'','','5',30000.00,'80238','','','1740','MALUMFASH S/S','137250',0.00,'2019-02-22 14:26:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:17:03'),(45113,'1','72','2019-02-20',98,'','','5',20000.00,'80238','','','1740','MALUMFASH S/S','138643',0.00,'2019-02-22 14:27:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:17:27'),(45512,'1','72','2019-02-21',98,'','','5',25720.00,'80378','','','1740','MALUMFASH S/S','411325',0.00,'2019-02-25 18:50:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:17:52'),(45513,'1','72','2019-02-22',98,'','','5',91450.00,'80465','','','1740','MALUMFASH S/S','412297',0.00,'2019-02-25 18:52:09',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:19:07'),(45514,'1','72','2019-02-24',98,'','','5',23480.00,'80754','','','1740','MALUMFASH S/S','411063',0.00,'2019-02-25 19:02:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:18:52'),(45515,'1','72','2019-02-24',98,'','','5',90000.00,'80754','','','1740','MALUMFASH S/S','412041',0.00,'2019-02-25 19:04:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:19:24'),(45516,'1','72','2019-02-24',98,'','','5',8000.00,'80754','','','1740','MALUMFASH S/S','409681',0.00,'2019-02-25 19:05:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:19:43'),(45520,'1','72','2019-02-24',98,'','','5',75000.00,'80754','','','1740','MALUMFASH S/S','411827',0.00,'2019-02-25 19:08:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:19:56'),(45524,'1','72','2019-02-24',98,'','','5',200000.00,'80754','','','1740','MALUMFASH S/S','412498',0.00,'2019-02-25 19:10:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:20:12'),(45525,'1','72','2019-02-24',98,'','','5',20000.00,'80754','','','1740','MALUMFASH S/S','410144',0.00,'2019-02-25 19:12:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:20:24'),(45526,'1','72','2019-02-24',98,'','','5',35000.00,'80754','','','1740','MALUMFASH S/S','411608',0.00,'2019-02-25 19:14:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:21:16'),(45527,'1','72','2019-02-24',98,'','','5',13000.00,'80754','','','1740','MALUMFASH S/S','409976',0.00,'2019-02-25 19:15:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:25:55'),(45697,'1','72','2019-02-25',98,'','','5',86680.00,'80755','','','1740','MALUMFASH S/S','294300',0.00,'2019-02-26 15:51:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:39:33'),(46175,'1','72','2019-02-26',98,'','','5',140680.00,'81143','','','1740','MALUMFASH S/S','127183',0.00,'2019-02-28 15:42:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:40:09'),(46176,'1','72','2019-02-26',98,'','','5',20000.00,'81143','','','1740','MALUMFASH S/S','270674',0.00,'2019-02-28 15:44:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:45:32'),(46180,'1','72','2019-02-27',98,'','','5',134085.00,'81143','','','1740','MALUMFASH S/S','207023',0.00,'2019-02-28 15:47:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:45:42'),(46184,'1','72','2019-02-27',98,'','','5',157500.00,'81143','','','1740','MALUMFASH S/S','207689',0.00,'2019-02-28 15:49:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:45:53'),(46188,'1','72','2019-02-27',98,'','','5',26000.00,'81143','','','1740','MALUMFASH S/S','208219',0.00,'2019-02-28 15:50:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:46:04'),(46190,'1','72','2019-02-27',98,'','','5',50000.00,'81143','','','1740','MALUMFASH S/S','208829',0.00,'2019-02-28 15:52:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:46:17'),(46435,'1','72','2019-02-28',98,'','','5',21700.00,'81145','','','1740','MALUMFASH S/S','377704',0.00,'2019-03-01 15:31:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-02 16:05:52'),(46436,'1','72','2019-02-28',98,'','','5',10000.00,'81145','','','1740','MALUMFASH S/S','377003',0.00,'2019-03-01 15:33:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-02 16:06:49'),(46439,'1','72','2019-02-28',98,'','','5',100000.00,'81145','','','1740','MALUMFASH S/S','376036',0.00,'2019-03-01 15:35:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-02 16:07:00'),(46928,'1','72','2019-03-01',98,'','','5',31400.00,'81254','','','1740','MALUMFASH S/S','420398',0.00,'2019-03-04 16:49:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-05 10:14:50'),(46932,'1','72','2019-03-03',98,'','','5',121210.00,'81484','','','1740','MALUMFASH S/S','419194',0.00,'2019-03-04 16:51:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-05 10:15:02'),(46934,'1','72','2019-03-03',98,'','','5',50000.00,'81484','','','1740','MALUMFASH S/S','419876',0.00,'2019-03-04 16:52:27',5,'PAYMENT','408','','0000-00-00 00:00:00','409','2019-03-05 10:15:10'),(47030,'1','72','2019-03-02',98,'','','5',16175.00,'81306','','','1740','MALUMFASH S/S','418576',0.00,'2019-03-05 08:32:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-05 10:15:19'),(47031,'1','72','2019-03-02',98,'','','5',17000.00,'81306','','','1740','MALUMFASH S/S','417735',0.00,'2019-03-05 08:33:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-05 10:15:29'),(47209,'1','72','2019-03-04',98,'','','5',57800.00,'81486','','','1740','MALUMFASH S/S','013888',0.00,'2019-03-05 15:12:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-07 16:57:43'),(47210,'1','72','2019-03-04',98,'','','5',42000.00,'81486','','','1740','MALUMFASH S/S','244547',0.00,'2019-03-05 15:14:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-07 16:57:52'),(47414,'1','72','2019-03-05',98,'','','5',165055.00,'81624','','','1740','MALUMFASH S/S','233230',0.00,'2019-03-06 15:17:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-07 16:58:04'),(47415,'1','72','2019-03-05',98,'','','5',30000.00,'81624','','','1740','MALUMFASH S/S','233636',0.00,'2019-03-06 15:18:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-07 16:58:15'),(48440,'1','72','2019-03-06',98,'','','5',73660.00,'82452','','','1740','MALUMFASH S/S','58620',0.00,'2019-03-12 16:55:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:29:32'),(48442,'1','72','2019-03-07',98,'','','5',77500.00,'82454','','','1740','MALUMFASH S/S','104634',0.00,'2019-03-12 16:58:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:36:24'),(48443,'1','72','2019-03-08',98,'','','5',12500.00,'82457','','','1740','MALUMFASH S/S','106932',0.00,'2019-03-12 17:00:48',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:38:07'),(48445,'1','72','2019-03-10',98,'','','5',94275.00,'82459','','','1740','MALUMFASH S/S','105312',0.00,'2019-03-12 17:02:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:38:21'),(48446,'1','72','2019-03-11',98,'','','5',166795.00,'82461','','','1740','MALUMFASH S/S','106028',0.00,'2019-03-12 17:05:15',5,'PAYMENT ON ACCCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:39:30'),(48447,'1','72','2019-03-11',98,'','','5',80000.00,'82461','','','1740','MALUMFASH S/S','36194',0.00,'2019-03-12 17:13:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:41:29'),(48448,'1','72','2019-03-11',98,'','','5',8000.00,'82461','','','1740','MALUMFASH S/S','364194',0.00,'2019-03-12 17:15:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:49:06'),(48449,'1','72','2019-03-11',98,'','','5',5000.00,'82461','','','1740','MALUMFASH S/S','363450',0.00,'2019-03-12 17:16:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:51:05'),(48638,'1','72','2019-03-12',98,'','','5',145750.00,'82462','','','1740','MALUMFASH S/S','290661',0.00,'2019-03-13 15:32:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:51:22'),(48640,'1','72','2019-03-12',98,'','','5',50000.00,'82462','','','1740','MALUMFASH S/S','291544',0.00,'2019-03-13 15:33:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:51:53'),(48641,'1','72','2019-03-12',98,'','','5',20000.00,'82462','','','1740','MALUMFASH S/S','290005',0.00,'2019-03-13 15:34:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:52:25'),(48892,'1','72','2019-03-13',98,'','','5',48125.00,'82564','','','1740','MALUMFASH S/S','361002',0.00,'2019-03-14 16:16:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-19 16:50:43'),(48894,'1','72','2019-03-13',98,'','','5',25000.00,'82564','','','1740','MALUMFASH S/S','360569',0.00,'2019-03-14 16:17:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-19 16:51:56'),(49507,'1','72','2019-03-14',98,'','','5',13165.00,'82700','','','1740','MALUMFASH S/S','245643',0.00,'2019-03-18 12:23:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-19 16:52:16'),(49509,'1','72','2019-03-15',98,'','','5',48590.00,'82876','','','1740','MALUMFASH S/S','243649',0.00,'2019-03-18 12:24:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-19 16:52:31'),(49512,'1','72','2019-03-16',98,'','','5',115485.00,'82878','','','1740','MALUMFASH S/S','243069',0.00,'2019-03-18 12:26:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-19 16:53:00'),(49513,'1','72','2019-03-16',98,'','','5',30000.00,'82878','','','1740','MALUMFASH S/S','245160',0.00,'2019-03-18 12:27:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-19 16:54:21'),(49710,'1','72','2019-03-17',98,'','','5',36610.00,'83188','','','1740','MALUMFASH S/S','82295',0.00,'2019-03-19 09:31:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-26 12:10:39'),(50060,'1','72','2019-03-18',98,'','','5',47445.00,'83190','','','1740','MALUMFASH S/S','202181',0.00,'2019-03-20 14:56:41',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-26 12:12:14'),(50064,'1','72','2019-03-18',98,'','','5',5000.00,'83190','','','1740','MALUMFASH S/S','201555',0.00,'2019-03-20 14:57:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-26 12:16:04'),(50353,'1','72','2019-03-19',98,'','','5',63100.00,'83192','','','1740','MALUMFASH S/S','74901',0.00,'2019-03-22 09:32:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-26 12:17:37'),(50355,'1','72','2019-03-20',98,'','','5',22900.00,'83415','','','1740','MALUMFASH S/S','76714',0.00,'2019-03-22 09:33:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-26 12:17:50'),(50357,'1','72','2019-03-20',98,'','','5',5000.00,'83415','','','1740','MALUMFASH S/S','76085',0.00,'2019-03-22 09:35:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-28 10:36:59'),(51383,'1','72','2019-03-21',98,'','','5',29180.00,'83580','','','1740','MALUMFASH S/S','136272',0.00,'2019-03-27 11:21:21',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-28 10:37:44'),(51385,'1','72','2019-03-22',98,'','','5',14750.00,'83581','','','1740','MALUMFASH S/S','134176',0.00,'2019-03-27 11:23:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-28 10:38:11'),(51388,'1','72','2019-03-23',98,'','','5',21500.00,'84187','','','1740','MALUMFASH S/S','135839',0.00,'2019-03-27 11:25:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-28 10:38:44'),(51390,'1','72','2019-03-24',98,'','','5',39660.00,'84188','','','1740','MALUMFASH S/S','131400',0.00,'2019-03-27 11:27:06',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-28 10:39:11'),(51391,'1','72','2019-03-25',98,'','','5',17550.00,'84190','','','1740','MALUMFASH S/S','135397',0.00,'2019-03-27 11:28:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-28 11:22:22'),(51393,'1','72','2019-03-26',98,'','','5',15400.00,'84192','','','1740','MALUMFASH S/S','134674',0.00,'2019-03-27 11:30:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-28 11:25:02'),(51394,'1','72','2019-03-26',98,'','','5',3000.00,'84192','','','1740','MALUMFASH S/S','133206',0.00,'2019-03-27 11:32:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-28 11:27:12'),(51654,'1','72','2019-03-27',98,'','','5',55750.00,'84193','','','1740','MALUMFASH S/S','244756',0.00,'2019-03-28 14:36:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-01 11:05:24'),(51656,'1','72','2019-03-27',98,'','','5',30000.00,'84193','','','1740','MALUMFASH S/S','244059',0.00,'2019-03-28 14:37:30',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-01 11:05:38'),(51658,'1','72','2019-03-27',98,'','','5',15000.00,'84193','','','1740','MALUMFASH S/S','243010',0.00,'2019-03-28 14:38:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-01 11:06:39'),(51839,'1','72','2019-03-28',98,'','','5',20950.00,'84394','','','1740','MALUMFASH S/S','189380',0.00,'2019-03-29 14:16:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-01 11:07:13'),(52503,'1','72','2019-03-29',98,'','','5',15300.00,'84496','','','1740','MALUMFASH S/S','187387',0.00,'2019-04-02 08:16:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:06:02'),(52504,'1','72','2019-03-30',98,'','','5',49400.00,'84808','','','1740','MALUMFASH S/S','189676',0.00,'2019-04-02 08:18:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:06:38'),(52505,'1','72','2019-03-31',98,'','','5',14000.00,'84812','','','1740','MALUMFASH S/S','188035',0.00,'2019-04-02 08:20:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:06:53'),(52628,'1','72','2019-04-01',98,'','','5',29700.00,'84812','','','1740','MALUMFASH S/S','262579',0.00,'2019-04-02 14:31:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:07:08'),(52983,'1','72','2019-04-02',98,'','','5',7500.00,'84908','','','1740','MALUMFASH S/S','370174',7499.25,'2019-04-05 09:12:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:07:29'),(52984,'1','72','2019-04-03',98,'','','5',23200.00,'85145','','','1740','MALUMFASH S/S','327070',23199.25,'2019-04-05 09:15:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:07:53'),(52986,'1','72','2019-04-03',98,'','','5',10000.00,'85145','','','1740','MALUMFASH S/S','370653',10000.00,'2019-04-05 09:19:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:08:17'),(52988,'1','72','2019-04-03',98,'','','5',10000.00,'85145','','','1740','MALUMFASH S/S','371093',10000.00,'2019-04-05 09:21:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:08:42'),(54105,'1','72','2019-04-04',98,'','','5',35350.00,'85147','','','1740','MALUMFASH S/S','298235',35350.00,'2019-04-10 11:53:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:08:57'),(54106,'1','72','2019-04-05',98,'','','5',22000.00,'85271','','','1740','MALUMFASH S/S','297273',22000.00,'2019-04-10 11:55:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:09:35'),(54107,'1','72','2019-04-06',98,'','','5',203215.00,'85841','','','1740','MALUMFASH S/S','169609',203215.00,'2019-04-10 11:57:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:09:51'),(54108,'1','72','2019-04-07',98,'','','5',9700.00,'85842','','','1740','MALUMFASH S/S','169999',9700.00,'2019-04-10 11:58:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:10:06'),(54109,'1','72','2019-04-07',98,'','','5',23200.00,'85842','','','1740','MALUMFASH S/S','297720',23200.00,'2019-04-10 12:00:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:11:19'),(54110,'1','72','2019-04-07',98,'','','5',70000.00,'85842','','','1740','MALUMFASH S/S','296203',70000.00,'2019-04-10 12:01:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:11:31'),(54386,'1','72','2019-04-08',98,'','','5',11000.00,'85843','','','1740','MALUMFASH S/S','301244',15500.25,'2019-04-11 14:31:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:11:47'),(54391,'1','72','2019-04-09',98,'','','5',8000.00,'85847','','','1740','MALUMFASH S/S','303247',7998.75,'2019-04-11 14:33:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:12:01'),(54395,'1','72','2019-04-10',98,'','','5',60845.00,'85940','','','1740','MALUMFASH S/S','302400',63094.50,'2019-04-11 14:34:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-11 16:12:20'),(55153,'1','72','2019-04-11',98,'','','5',114050.00,'86103','','','1740','MALUMFASH S/S','371662',114050.00,'2019-04-15 15:08:47',5,'PAYMENT ON ACCOUNT','408','409','2019-04-30 17:02:37','409','2019-04-30 17:02:49'),(55155,'1','72','2019-04-12',98,'','','5',41955.00,'86601','','','1740','MALUMFASH S/S','370490',41955.75,'2019-04-15 15:11:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-29 10:11:53'),(55509,'1','72','2019-04-13',98,'','','5',28750.00,'86605','','','1740','MALUMFASH S/S','373627',28750.50,'2019-04-16 17:41:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-29 10:12:27'),(55514,'1','72','2019-04-14',98,'','','5',3760.00,'86608','','','1740','MALUMFASH S/S','374470',10759.50,'2019-04-16 17:44:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-30 17:03:30'),(55516,'1','72','2019-04-15',98,'','','5',6600.00,'86612','','','1740','MALUMFASH S/S','87894602',11101.50,'2019-04-16 17:47:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-30 17:03:53'),(55715,'1','72','2019-04-17',98,'','','5',85500.00,'86783','','','1740','MALUMFASH S/S','182674',87750.00,'2019-04-17 13:12:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-30 17:05:06'),(55716,'1','72','2019-04-17',98,'','','5',17500.00,'86783','','','1740','MALUMFASH S/S','181753',17500.00,'2019-04-17 13:14:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-29 10:12:59'),(55891,'1','72','2019-04-17',98,'','','5',129330.00,'86859','','','1740','MALUMFASH S/S','135170',129330.00,'2019-04-18 11:41:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-29 10:13:21'),(56728,'1','72','2019-04-18',98,'','','5',314950.00,'86964','','','1740','MALUMFASH S/S','8560094',316950.75,'2019-04-23 16:56:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-06 14:30:19'),(56997,'1','72','2019-04-19',98,'','','5',11975.00,'87608','','','1740','MALUMFASH S/S','117850',11972.50,'2019-04-24 13:25:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-29 10:13:44'),(56998,'1','72','2019-04-20',98,'','','5',11600.00,'87609','','','1740','MALUMFASH S/S','112371',11601.00,'2019-04-24 13:27:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-29 10:14:09'),(57344,'1','72','2019-04-21',98,'','','5',92450.00,'87610','','','1740','MALUMFASH S/S','362658',92452.80,'2019-04-25 16:30:21',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-29 10:14:32'),(57347,'1','72','2019-04-22',98,'','','5',10785.00,'87611','','','1740','MALUMFASH S/S','363096',15282.00,'2019-04-25 16:32:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-30 17:13:47'),(57350,'1','72','2019-04-23',98,'','','5',11400.00,'87613','','','1740','MALUMFASH S/S','363373',11400.75,'2019-04-25 16:33:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-29 10:15:03'),(57891,'1','72','2019-04-24',98,'','','5',107150.00,'87698','','','1740','MALUMFASH S/S','138148',107151.75,'2019-04-29 10:30:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-30 17:14:20'),(57892,'1','72','2019-04-24',98,'','','5',31280.00,'87698','','','1740','MALUMFASH S/S','139528',31280.00,'2019-04-29 10:33:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-30 17:14:33'),(57949,'1','72','2019-04-25',98,'','','5',38280.00,'87879','','','1740','MALUMFASH S/S','351795',38281.50,'2019-04-29 13:35:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-30 17:14:57'),(57950,'1','72','2019-04-26',98,'','','5',23500.00,'88299','','','1740','MALUMFASH S/S','352687',23501.25,'2019-04-29 13:40:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-30 17:15:19'),(58013,'1','72','2019-04-27',98,'','','5',65950.00,'88301','','','1740','MALUMFASH S/S','500764',68199.75,'2019-04-29 15:44:34',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-22 16:38:51'),(58671,'1','72','2019-04-28',98,'','','5',48250.00,'88303','','','1740','MALUMFASH S/S','208274',48250.00,'2019-05-02 13:39:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-06 14:29:21'),(58676,'1','72','2019-04-29',98,'','','5',28310.00,'88305','','','1740','MALUMFASH S/S','207697',32809.00,'2019-05-02 13:42:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-06 14:35:57'),(58679,'1','72','2019-04-30',98,'','','5',12750.00,'88733','','','1740','MALUMFASH S/S','206944',12748.50,'2019-05-02 13:44:44',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-06 14:36:28'),(59860,'1','72','2019-05-01',98,'','','5',147800.00,'88738','','','1740','MALUMFASH S/S','230834',177810.75,'2019-05-07 18:57:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-14 13:12:06'),(59862,'1','72','2019-05-01',98,'','','5',18720.00,'88738','','','1740','MALUMFASH S/S','230834',18720.00,'2019-05-07 19:01:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-14 13:03:27'),(59864,'1','72','2019-05-01',98,'','','5',5000.00,'88738','','','1740','MALUMFASH S/S','231590',5000.00,'2019-05-07 19:03:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-14 13:04:04'),(59924,'1','72','2019-05-02',98,'','','5',207970.00,'88741','','','1740','MALUMFASH S/S','134133',247968.00,'2019-05-08 10:59:34',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-14 13:05:59'),(59925,'1','72','2019-05-03',98,'','','5',113420.00,'89399','','','1740','MALUMFASH S/S','387254',113420.25,'2019-05-08 11:01:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-14 13:07:39'),(59926,'1','72','2019-05-04',98,'','','5',23700.00,'89401','','','1740','MALUMFASH S/S','388855',23697.00,'2019-05-08 11:03:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-14 13:08:07'),(59927,'1','72','2019-05-05',98,'','','5',33750.00,'89405','','','1740','MALUMFASH S/S','388145',33750.00,'2019-05-08 11:06:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-14 13:09:19'),(59928,'1','72','2019-05-06',98,'','','5',23000.00,'89406','','','1740','MALUMFASH S/S','151326',27499.50,'2019-05-08 11:09:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-22 16:39:58'),(61037,'1','72','2019-05-07',98,'','','5',5895.00,'89407','','','1740','MALUMFASH S/S','275948',10894.50,'2019-05-13 13:41:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-04 13:18:53'),(61043,'1','72','2019-05-08',98,'','','5',7800.00,'89471','','','1740','MALUMFASH S/S','276997',7798.50,'2019-05-13 13:54:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-04 13:22:19'),(61423,'1','72','2019-05-09',98,'','','5',200715.00,'90102','','','1740','MALUMFASH S/S','398342',200715.75,'2019-05-14 16:20:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-17 10:03:27'),(61629,'1','72','2019-05-10',98,'','','5',33465.00,'90104','','','1740','MALUMFASH S/S','279163',33464.25,'2019-05-15 14:11:17',5,'PAYMENT ON ACCCOUNT','408','','0000-00-00 00:00:00','409','2019-05-17 10:04:07'),(61737,'1','72','2019-05-11',98,'','','5',116915.00,'90105','','','1740','MALUMFASH S/S','9748766',116914.50,'2019-05-16 09:18:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-17 10:04:40'),(61738,'1','72','2019-05-12',98,'','','5',22500.00,'90108','','','1740','MALUMFASH S/S','38873778',22500.00,'2019-05-16 09:20:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-17 10:05:04'),(61742,'1','72','2019-05-13',98,'','','5',12950.00,'90111','','','1740','MALUMFASH S/S','38873777',17448.75,'2019-05-16 09:25:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-17 10:05:39'),(61743,'1','72','2019-05-14',98,'','','5',21960.00,'90307','','','1740','MALUMFASH S/S','38873779',21957.75,'2019-05-16 09:27:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-17 10:06:32'),(61885,'1','72','2019-05-15',98,'','','5',45485.00,'90401','','','1740','MALUMFASH S/S','305300',45483.75,'2019-05-16 15:52:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-17 10:07:53'),(61887,'1','72','2019-05-15',98,'','','5',10000.00,'90401','','','1740','MALUMFASH S/S','300876',10000.00,'2019-05-16 15:53:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-17 10:13:29'),(62008,'1','72','2019-05-16',98,'','','5',97000.00,'90554','','','1740','MALUMFASH S/S','90677',96999.75,'2019-05-17 10:03:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-20 14:40:34'),(62966,'1','72','2019-05-17',98,'','','5',133050.00,'90596','','','1740','MALUMFASH S/S','38864024',133048.25,'2019-05-21 12:23:18',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-22 15:37:53'),(63260,'1','72','2019-05-18',98,'','','5',114915.00,'91136','','','1740','MALUMFASH S/S','38869796',114916.50,'2019-05-22 14:24:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-27 09:51:33'),(63261,'1','72','2019-05-19',98,'','','5',36480.00,'91139','','','1740','MALUMFASH S/S','9748611',36477.00,'2019-05-22 14:25:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-27 09:52:17'),(63262,'1','72','2019-05-20',98,'','','5',16000.00,'91140','','','1740','MALUMFASH S/S','9748613',20504.25,'2019-05-22 14:27:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-27 09:52:37'),(63489,'1','72','2019-05-21',98,'','','5',96075.00,'91142','','','1740','MALUMFASH S/S','188221',96075.00,'2019-05-23 11:59:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-27 09:52:52'),(63877,'1','72','2019-05-22',98,'','','5',168210.00,'91295','','','1740','MALUMFASH S/S','234828',170460.00,'2019-05-24 16:46:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-30 10:42:33'),(63878,'1','72','2019-05-22',98,'','','5',10000.00,'91295','','','1740','MALUMFASH S/S','235845',10000.00,'2019-05-24 16:47:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-27 09:53:34'),(64689,'1','72','2019-05-23',98,'','','5',358250.00,'','','','1740','MALUMFASH S/S','234419',358251.75,'2019-05-28 12:23:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-30 10:39:53'),(67395,'1','72','2019-05-24',98,'','','5',74050.00,'91551','','','1740','Malumfashi','174158',74052.00,'2019-06-11 15:48:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 11:46:38'),(67398,'1','72','2019-05-25',98,'','','5',136695.00,'91979','','','1740','Malumfashi','174876',136694.25,'2019-06-11 15:51:21',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 11:48:32'),(67400,'1','72','2019-05-26',98,'','','5',20855.00,'91981','','','1740','Malumfashi','175523',20853.00,'2019-06-11 15:53:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 11:49:11'),(67404,'1','72','2019-05-27',98,'','','5',222660.00,'91985','','','1740','Malumfashi','426828',222657.75,'2019-06-11 15:55:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:10:05'),(67408,'1','72','2019-05-28',98,'','','5',37100.00,'91986','','','1740','Malumfashi','426312',37086.75,'2019-06-11 15:57:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:10:50'),(67413,'1','72','2019-05-29',98,'','','5',10305.00,'93440','','','1740','Malumfashi','424827',10305.00,'2019-06-11 15:59:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:11:29'),(67416,'1','72','2019-05-30',98,'','','5',1500.00,'93573','','','1740','Malumfashi','425332',31500.00,'2019-06-11 16:02:09',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:14:01'),(67418,'1','72','2019-05-31',98,'','','5',11400.00,'93574','','','1740','Malumfashi','425804',11400.75,'2019-06-11 16:04:01',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:15:05'),(67432,'1','72','2019-06-01',98,'','','5',109760.00,'93576','','','1740','Malumfashi','38860894',109759.50,'2019-06-11 16:16:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:16:32'),(67435,'1','72','2019-06-02',98,'','','5',33425.00,'93621','','','1740','Malumfashi','38860823',33425.00,'2019-06-11 16:20:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:16:58'),(67439,'1','72','2019-06-03',98,'','','5',6875.00,'93622','','','1740','Malumfashi','38860870',11373.75,'2019-06-11 16:21:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:17:43'),(67457,'1','72','2019-06-05',98,'','','5',12425.00,'93624','','','1740','Malumfashi','38860986',12426.75,'2019-06-11 16:38:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:18:24'),(67460,'1','72','2019-06-06',98,'','','5',10400.00,'93626','','','1740','Malumfashi','361823',10399.50,'2019-06-11 16:41:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:19:09'),(67463,'1','72','2019-06-07',98,'','','5',40250.00,'93629','','','1740','Malumfashi','363037',40252.50,'2019-06-11 16:43:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-13 12:24:18'),(68397,'1','72','2019-06-08',98,'','','5',18770.00,'93631','','','1740','Malumfashi','38860702',18769.50,'2019-06-14 10:24:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-17 13:51:21'),(68399,'1','72','2019-06-09',98,'','','5',130190.00,'93632','','','1740','Malumfashi','85272',130189.50,'2019-06-14 10:26:21',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-17 13:51:37'),(68400,'1','72','2019-06-10',98,'','','5',124750.00,'93634','','','1740','Malumfashi','85791',129251.25,'2019-06-14 10:28:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-17 13:54:36'),(69518,'1','72','2019-06-11',98,'','','5',164200.00,'93635','','','1740','Malumfashi','387837',164198.25,'2019-06-18 11:35:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-21 10:50:05'),(69521,'1','72','2019-06-12',98,'','','5',180000.00,'93636','','','1740','Malumfashi','203221',179991.00,'2019-06-18 11:38:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-21 10:51:30'),(70177,'1','72','2019-06-13',98,'','','5',82000.00,'93839','','','1740','Malumfashi','38861948',81999.00,'2019-06-20 20:50:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-21 10:52:19'),(70178,'1','72','2019-06-14',98,'','','5',34800.00,'93984','','','1740','Malumfashi','283457',34789.50,'2019-06-20 20:53:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-21 10:55:25'),(70179,'1','72','2019-06-15',98,'','','5',20540.00,'94397','','','1740','Malumfashi','303543',20533.50,'2019-06-20 20:54:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-04 13:23:48'),(70180,'1','72','2019-06-15',98,'','','5',8000.00,'94397','','','1740','Malumfashi','201737',8000.00,'2019-06-20 20:57:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-21 11:04:19'),(70891,'1','72','2019-06-16',98,'','','5',10000.00,'94399','','','1740','Malumfashi','75652',10001.25,'2019-06-24 19:18:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-26 10:56:38'),(70892,'1','72','2019-06-17',98,'','','5',18400.00,'94480','','','1740','Malumfashi','126811',22898.00,'2019-06-24 19:20:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-26 10:57:07'),(70893,'1','72','2019-06-18',98,'','','5',11485.00,'94484','','','1740','Malumfashi','76660',11484.00,'2019-06-24 19:22:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-26 10:57:36'),(70894,'1','72','2019-06-19',98,'','','5',18700.00,'94635','','','1740','Malumfashi','77157',18699.00,'2019-06-24 19:25:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-26 10:57:56'),(70895,'1','72','2019-06-19',98,'','','5',22900.00,'94635','','','1740','Malumfashi','76231',22900.00,'2019-06-24 19:26:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-26 10:58:23'),(71699,'1','72','2019-06-20',98,'','','5',83150.00,'94795','','','1740','Malumfashi','200815',85396.50,'2019-06-29 10:07:48',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 10:59:25'),(71700,'1','72','2019-06-21',98,'','','5',18800.00,'95487','','','1740','Malumfashi','73644',18800.00,'2019-06-29 10:09:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 10:59:42'),(71701,'1','72','2019-06-22',98,'','','5',16700.00,'95488','','','1740','Malumfashi','329250',16701.75,'2019-06-29 10:11:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:00:03'),(71702,'1','72','2019-06-23',98,'','','5',45850.00,'95490','','','1740','Malumfashi','330045',45850.50,'2019-06-29 10:13:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:00:28'),(71703,'1','72','2019-06-24',98,'','','5',32825.00,'95491','','','1740','Malumfashi','200231',37325.25,'2019-06-29 10:18:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:00:46'),(71705,'1','72','2019-06-25',98,'','','5',68000.00,'95598','','','1740','Malumfashi','314050',67999.50,'2019-06-29 10:30:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:02:54'),(71709,'1','72','2019-06-25',98,'','','5',5000.00,'95598','','','1740','Malumfashi','214384',5000.00,'2019-06-29 10:39:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:03:05'),(71710,'1','72','2019-06-25',98,'','','5',15000.00,'95598','','','1740','Malumfashi','213643',15000.00,'2019-06-29 10:40:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:03:16'),(71712,'1','72','2019-06-25',98,'','','5',5000.00,'95598','','','1740','Malumfashi','211596',5000.00,'2019-06-29 10:41:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:03:35'),(72327,'1','72','2019-06-26',98,'','','5',126100.00,'95601','','','1740','Malumfashi','199085',126099.00,'2019-07-01 12:26:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-02 16:46:44'),(72329,'1','72','2019-06-27',98,'','','5',27475.00,'95602','','','1740','Malumfashi','215054',27472.50,'2019-07-01 12:28:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-02 16:47:35'),(72331,'1','72','2019-06-28',98,'','','5',41465.00,'95764','','','1740','Malumfashi','198269',41463.00,'2019-07-01 12:30:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-02 16:48:04'),(73226,'1','72','2019-06-29',98,'','','5',250400.00,'95766','','','1740','Malumfashi','93538',250398.00,'2019-07-05 09:58:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:33:28'),(73227,'1','72','2019-06-30',98,'','','5',19250.00,'95855','','','1740','Malumfashi','99322',21498.75,'2019-07-05 10:02:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:35:10'),(73230,'1','72','2019-07-01',98,'','','5',53500.00,'95935','','','1740','Malumfashi','98645',83497.50,'2019-07-05 10:06:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:37:49'),(73231,'1','72','2019-07-02',98,'','','5',12000.00,'96271','','','1740','Malumfashi','98115',12001.50,'2019-07-05 10:08:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:38:45'),(73233,'1','72','2019-07-03',98,'','','5',54660.00,'96272','','','1740','Malumfashi','109804',54657.00,'2019-07-05 10:10:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:43:23'),(74194,'1','72','2019-06-04',98,'','','5',61035.00,'96274','','','1740','Malumfashi','74399',61035.75,'2019-07-09 09:50:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:45:31'),(74195,'1','72','2019-06-05',98,'','','5',210655.00,'96399','','','1740','Malumfashi','75119',210654.00,'2019-07-09 09:52:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:46:01'),(74521,'1','72','2019-07-06',98,'','','5',205925.00,'96793','','','1740','Malumfashi','217462',205925.00,'2019-07-10 12:46:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:50:05'),(74523,'1','72','2019-07-07',98,'','','5',29750.00,'96795','','','1740','Malumfashi','75582',29751.75,'2019-07-10 12:47:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:52:56'),(74524,'1','72','2019-07-08',98,'','','5',121075.00,'96798','','','1740','Malumfashi','216841',125574.75,'2019-07-10 12:49:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-15 15:54:04'),(75607,'1','72','2019-07-09',98,'','','5',155675.00,'96800','','','1740','Malumfashi','0053313693',175675.50,'2019-07-15 15:30:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-19 12:38:46'),(75613,'1','72','2019-07-09',98,'','','5',20000.00,'96800','','','1740','Malumfashi','0053313690',20000.00,'2019-07-15 15:32:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-29 15:09:53'),(75868,'1','72','2019-07-10',98,'','','5',197200.00,'96960','','','1740','Malumfashi','38868755',197201.25,'2019-07-16 12:00:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-19 15:38:15'),(75871,'1','72','2019-07-11',98,'','','5',7000.00,'97388','','','1740','Malumfashi','0053313696',6999.75,'2019-07-16 12:04:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-19 12:39:18'),(75873,'1','72','2019-07-12',98,'','','5',8500.00,'97788','','','1740','Malumfashi','38868760',8500.80,'2019-07-16 12:06:17',5,'PAYMENT ON  ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-19 12:39:34'),(75875,'1','72','2019-07-13',98,'','','5',27500.00,'97790','','','1740','Malumfashi','0053313694',27500.00,'2019-07-16 12:09:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-19 12:40:05'),(75934,'1','72','2019-07-15',98,'','','5',9200.00,'97792','','','1740','Malumfashi','398239',9200.50,'2019-07-16 15:10:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-19 12:39:53'),(77982,'1','72','2019-07-16',98,'','','5',73585.00,'97873','','','1740','Malumfashi','509718',280645.00,'2019-07-23 16:59:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 13:10:32'),(77984,'1','72','2019-07-17',98,'','','5',251750.00,'99192','','','1740','Malumfashi','275431',223750.00,'2019-07-23 17:01:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 13:57:44'),(77988,'1','72','2019-07-18',98,'','','5',222580.00,'99196','','','1740','Malumfashi','188346',224780.00,'2019-07-23 17:05:18',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-07 11:44:59'),(77992,'1','72','2019-07-19',98,'','','5',135160.00,'99197','','','1740','Malumfashi','187702',135160.00,'2019-07-23 17:08:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-29 15:10:28'),(77997,'1','72','2019-07-17',98,'','','5',28000.00,'99192','','','1740','Malumfashi','93319',28000.00,'2019-07-23 17:11:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-29 15:10:57'),(79502,'1','72','2019-07-15',98,'','','5',56695.00,'97792','','','1740','Malumfashi','510572',56693.00,'2019-07-30 14:10:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:01:08'),(79505,'1','72','2019-07-20',98,'','','5',291290.00,'99201','','','1740','Malumfashi','38870422',291290.00,'2019-07-30 14:17:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:09:50'),(79506,'1','72','2019-07-21',98,'','','5',236270.00,'99203','','','1740','Malumfashi','38870426',330870.00,'2019-07-30 14:19:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:21:38'),(79508,'1','72','2019-07-24',98,'','','5',160755.00,'99517','','','1740','Malumfashi','0053315375',160755.00,'2019-07-30 14:22:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:03:06'),(79511,'1','72','2019-07-25',98,'','','5',416655.00,'99518','','','1740','Malumfashi','386243',416655.00,'2019-07-30 14:24:44',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:04:13'),(79516,'1','72','2019-07-26',98,'','','5',342500.00,'99616','','','1740','Malumfashi','387723',342500.00,'2019-07-30 14:33:18',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:05:09'),(79518,'1','72','2019-07-27',98,'','','5',187380.00,'100048','','','1740','Malumfashi','388434',316380.00,'2019-07-30 14:35:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 09:15:21'),(79520,'1','72','2019-07-28',98,'','','5',357280.00,'100049','','','1740','Malumfashi','387028',357280.00,'2019-07-30 14:37:06',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:06:18'),(79521,'1','72','2019-07-29',98,'','','5',223955.00,'100052','','','1740','Malumfashi','126394',239355.00,'2019-07-30 14:39:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:13:42'),(79523,'1','72','2019-07-21',98,'','','5',94600.00,'99203','','','1740','Malumfashi','389195',94600.00,'2019-07-30 14:40:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:08:36'),(80070,'1','72','2019-07-30',98,'','','5',184740.00,'100053','','','1740','Malumfashi','227533',475740.00,'2019-08-01 13:16:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 13:10:32'),(80071,'1','72','2019-07-31',98,'','','5',307035.00,'100302','','','1740','Malumfashi','227035',523150.00,'2019-08-01 13:17:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-29 13:31:44'),(80072,'1','72','2019-07-16',98,'','','5',202660.00,'97873','','','1740','Malumfashi','122578',202660.00,'2019-08-01 13:19:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-01 14:07:49'),(80803,'1','72','2019-08-01',98,'','','5',364675.00,'100303','','','1740','Malumfashi','247044',364675.00,'2019-08-05 15:26:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:19:39'),(80804,'1','72','2019-08-02',98,'','','5',246180.00,'100439','','','1740','Malumfashi','249765',246180.00,'2019-08-05 15:28:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:19:39'),(80806,'1','72','2019-08-03',98,'','','5',379925.00,'100441','','','1740','Malumfashi','248108',577925.00,'2019-08-05 15:29:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-29 12:32:52'),(80808,'1','72','2019-08-04',98,'','','5',419800.00,'100767','','','1740','Malumfashi','248636',551800.00,'2019-08-05 15:31:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 09:15:20'),(81736,'1','72','2019-08-05',98,'','','5',369145.00,'100768','','','1740','Malumfashi','35524',386545.00,'2019-08-08 14:11:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 13:00:32'),(81738,'1','72','2019-08-06',98,'','','5',223240.00,'100980','','','1740','Malumfashi','109029',377240.00,'2019-08-08 14:13:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 09:15:20'),(81740,'1','72','2019-08-07',98,'','','5',313490.00,'100981','','','1740','Malumfashi','81089',313490.00,'2019-08-08 14:15:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:19:39'),(81747,'1','72','2019-07-30',98,'','','5',154000.00,'100053','','','1740','Malumfashi','109997',154000.00,'2019-08-08 14:20:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:19:39'),(81911,'1','72','2019-08-08',98,'','','5',378050.00,'101149','','','1740','Malumfashi','159983',461650.00,'2019-08-09 12:22:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 09:15:20'),(81912,'1','72','2019-07-30',98,'','','5',88000.00,'100053','','','1740','Malumfashi','159115',88000.00,'2019-08-09 12:24:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:19:39'),(82647,'1','72','2019-08-09',98,'','','5',337860.00,'101249','','','1740','Malumfashi','251733',337860.00,'2019-08-14 15:09:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:02'),(82650,'1','72','2019-08-10',98,'','','5',315620.00,'','','','1740','Malumfashi','253912',315617.40,'2019-08-14 15:12:41',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:01'),(82651,'1','72','2019-08-11',98,'','','5',121415.00,'101819','','','1740','Malumfashi','256423',121415.00,'2019-08-14 15:15:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:01'),(82653,'1','72','2019-08-12',98,'','','5',172190.00,'101814','','','1740','Malumfashi','255904',187590.00,'2019-08-14 15:17:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:53:49'),(82655,'1','72','2019-08-13',98,'','','5',219320.00,'101815','','','1740','Malumfashi','254524',229320.00,'2019-08-14 15:19:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 13:10:32'),(82659,'1','72','2019-07-31',98,'','','5',216115.00,'100302','','','1740','Malumfashi','251044',216115.00,'2019-08-14 15:22:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:01'),(83790,'1','72','2019-07-22',98,'','','5',83670.00,'','','','1740','Malumfashi','38868793',83670.00,'2019-08-18 17:03:21',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:01'),(83791,'1','72','2019-07-23',98,'','','5',106080.00,'','','','1740','Malumfashi','34737',106080.00,'2019-08-18 17:04:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:01'),(83792,'1','72','2019-07-14',98,'','','5',13410.00,'','','','1740','Malumfashi','508842',13410.00,'2019-08-18 17:05:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:01'),(83793,'1','72','2019-07-15',98,'','','5',56695.00,'','','','1740','Malumfashi','510572',56695.00,'2019-08-18 17:07:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:01'),(83794,'1','72','2019-08-14',98,'','','5',314030.00,'101817','','','1740','Malumfashi','272298',540630.00,'2019-08-18 17:13:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:13:46'),(83795,'1','72','2019-08-15',98,'','','5',412210.00,'','','','1740','Malumfashi','272763',412210.00,'2019-08-18 17:14:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:52:00'),(83796,'1','72','2019-08-13',98,'','','5',11000.00,'101815','','','1740','Malumfashi','273134',11000.00,'2019-08-18 17:18:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:57:13'),(84315,'1','72','2019-08-16',98,'','','5',321085.00,'102355','','','1740','Malumfashi','329366',321085.00,'2019-08-20 16:31:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:57:13'),(84321,'1','72','2019-08-17',98,'','','5',379530.00,'102357','','','1740','Malumfashi','328422',379530.00,'2019-08-20 16:34:05',5,'PAYMENT ON ACCOUNT ','408','','0000-00-00 00:00:00','409','2019-08-26 10:57:13'),(84326,'1','72','2019-08-18',98,'','','5',406800.00,'102604','','','1740','Malumfashi','328889',540800.00,'2019-08-20 16:35:41',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:15:26'),(84330,'1','72','2019-08-19',98,'','','5',249085.00,'102606','','','1740','Malumfashi','346715',266685.00,'2019-08-20 16:38:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:15:26'),(84342,'1','72','2019-08-06',98,'','','5',154000.00,'100980','','','1740','Malumfashi','350005',154000.00,'2019-08-20 16:44:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:57:13'),(84693,'1','72','2019-07-27',98,'','','5',129000.00,'100048','','','1740','Malumfashi','329891',129000.00,'2019-08-21 17:10:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 10:57:13'),(84694,'1','72','2019-08-20',98,'','','5',383845.00,'102780','','','1740','Malumfashi','308401',623845.00,'2019-08-21 17:12:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-26 12:15:58'),(85727,'1','72','2019-08-21',98,'','','5',186445.00,'102781','','','1740','Malumfashi','244366',426445.00,'2019-08-26 19:46:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 08:59:38'),(85728,'1','72','2019-08-22',98,'','','5',305360.00,'103406','','','1740','Malumfashi','25419',305360.00,'2019-08-26 19:49:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 08:57:28'),(85729,'1','72','2019-08-23',98,'','','5',340285.00,'103407','','','1740','Malumfashi','373623',340285.00,'2019-08-26 19:53:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 08:57:28'),(85730,'1','72','2019-08-24',98,'','','5',400810.00,'103408','','','1740','Malumfashi','374876',400810.00,'2019-08-26 19:55:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 08:57:28'),(85731,'1','72','2019-08-25',98,'','','5',365220.00,'103409','','','1740','Malumfashi','374343',365220.00,'2019-08-26 19:57:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 08:57:28'),(85732,'1','72','2019-08-08',98,'','','5',81400.00,'101149','','','1740','Malumfashi','373025',81400.00,'2019-08-26 19:59:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 08:57:28'),(85980,'1','72','2019-08-26',98,'','','5',231540.00,'103410','','','1740','Malumfashi','182374',254750.00,'2019-08-27 20:49:41',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 08:57:28'),(85981,'1','72','2019-08-08',98,'','','5',132000.00,'101149','','','1740','Malumfashi','372488',132000.00,'2019-08-27 20:51:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-28 08:57:28'),(86087,'1','72','2019-08-20',98,'','','5',240000.00,'102780','','','1740','Malumfashi','216066',240000.00,'2019-08-28 14:15:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-29 12:32:52'),(86089,'1','72','2019-08-27',98,'','','5',428575.00,'103410','','','1740','Malumfashi','213565',751075.00,'2019-08-28 14:17:18',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-29 12:32:51'),(86091,'1','72','2019-08-18',98,'','','5',134000.00,'102604','','','1740','Malumfashi','215561',134000.00,'2019-08-28 14:18:44',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-08-29 12:32:51'),(86779,'1','72','2019-08-28',98,'','','5',402170.00,'103637','','','1740','Malumfashi','182046',402170.00,'2019-08-30 15:05:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-04 10:04:12'),(86780,'1','72','2019-08-29',98,'','','5',314375.00,'103939','','','1740','Malumfashi','313722',314375.00,'2019-08-30 15:07:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-04 10:04:11'),(86781,'1','72','2019-08-14',98,'','','5',94600.00,'101817','','','1740','Malumfashi','314261',94600.00,'2019-08-30 15:08:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-04 10:04:11'),(87824,'1','72','2019-08-30',98,'','','5',413025.00,'103941','','','1740','Malumfashi','383334',413025.00,'2019-09-03 19:04:18',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-04 10:04:11'),(87827,'1','72','2019-08-31',98,'','','5',562400.00,'104452','','','1740','Malumfashi','384236',611400.00,'2019-09-03 19:07:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 13:10:32'),(87828,'1','72','2019-09-01',98,'','','5',508680.00,'104453','','','1740','Malumfashi','384847',657680.00,'2019-09-03 19:10:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:57:13'),(87829,'1','72','2019-08-27',98,'','','5',215000.00,'103546','','','1740','Malumfashi','362700',215000.00,'2019-09-03 19:12:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-04 10:04:11'),(87830,'1','72','2019-08-21',98,'','','5',102270.00,'102781','','','1740','Malumfashi','382456',102270.00,'2019-09-03 19:14:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:19'),(89321,'1','72','2019-09-02',98,'','','5',541495.00,'104454','','','1740','Malumfashi','362044',857545.00,'2019-09-10 16:44:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:57:13'),(89331,'1','72','2019-09-03',98,'','','5',147115.00,'105304','','','1740','Malumfashi','180824',147115.00,'2019-09-10 16:46:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:19'),(89339,'1','72','2019-09-04',98,'','','5',249860.00,'105307','','','1740','Malumfashi','181907',342735.00,'2019-09-10 16:48:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:57:13'),(89344,'1','72','2019-09-05',98,'','','5',370635.00,'105309','','','1740','Malumfashi','326585',370632.70,'2019-09-10 16:50:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:19'),(89345,'1','72','2019-09-06',98,'','','5',647165.00,'105311','','','1740','Malumfashi','78244',647165.00,'2019-09-10 16:52:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:19'),(89346,'1','72','2019-09-07',98,'','','5',292200.00,'105313','','','1740','Malumfashi','77922',292200.00,'2019-09-10 16:54:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:19'),(89349,'1','72','2019-09-08',98,'','','5',316265.00,'105316','','','1740','Malumfashi','330553',316265.00,'2019-09-10 16:57:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:19'),(89351,'1','72','2019-09-09',98,'','','5',198875.00,'105317','','','1740','Malumfashi','331323',234875.00,'2019-09-10 16:59:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 13:10:32'),(89587,'1','72','2019-09-10',98,'','','5',200145.00,'105319','','','1740','Malumfashi','244529',417144.50,'2019-09-11 16:36:30',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:57:13'),(89590,'1','72','2019-08-25',98,'','','5',126850.00,'103409','','','1740','Malumfashi','244099',126850.00,'2019-09-11 16:40:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:18'),(89596,'1','72','2019-08-03',98,'','','5',198000.00,'100441','','','1740','Malumfashi','77518',198000.00,'2019-09-11 16:45:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:18'),(89598,'1','72','2019-09-05',98,'','','5',33000.00,'105309','','','1740','Malumfashi','182413',33000.00,'2019-09-11 16:48:30',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 12:53:18'),(90009,'1','72','2019-09-11',98,'','','5',413690.00,'105441','','','1740','Malumfashi','204571',508830.00,'2019-09-13 16:00:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:30'),(90010,'1','72','2019-09-12',98,'','','5',483430.00,'105704','','','1740','Malumfashi','203980',957430.00,'2019-09-13 16:04:09',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:30'),(90012,'1','72','2019-08-14',98,'','','5',132000.00,'102244','','','1740','Malumfashi','340161',132000.00,'2019-09-13 16:08:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:46'),(90015,'1','72','2019-09-02',98,'','','5',215000.00,'104454','','','1740','Malumfashi','339676',215000.00,'2019-09-13 16:10:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:46'),(90018,'1','72','2019-09-01',98,'','','5',139000.00,'104453','','','1740','Malumfashi','202887',139000.00,'2019-09-13 16:12:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:45'),(90727,'1','72','2019-09-13',98,'','','5',326715.00,'105707','','','1740','Malumfashi','231982',468615.00,'2019-09-16 18:48:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:30'),(90730,'1','72','2019-09-14',98,'','','5',494380.00,'106101','','','1740','Malumfashi','230841',494380.00,'2019-09-16 18:51:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:45'),(90734,'1','72','2019-09-15',98,'','','5',331325.00,'12345','','','1740','Malumfashi','230098',331322.60,'2019-09-16 18:53:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:45'),(90737,'1','72','2019-09-15',98,'','','5',107500.00,'12345','','','1740','Malumfashi','231503',107500.00,'2019-09-16 18:55:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:45'),(91249,'1','72','2019-09-16',98,'','','5',244865.00,'12345','','','1740','Malumfashi','315091',244865.00,'2019-09-18 19:43:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:45'),(91251,'1','72','2019-09-16',98,'','','5',90730.00,'12345','','','1740','Malumfashi','315775',90730.00,'2019-09-18 19:45:01',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:45'),(91253,'1','72','2019-09-17',98,'','','5',321050.00,'12345','','','1740','Malumfashi','242159',336102.20,'2019-09-18 19:47:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:30'),(91254,'1','72','2019-09-18',98,'','','5',107500.00,'12345','','','1740','Malumfashi','242510',107500.00,'2019-09-18 19:49:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-19 14:15:45'),(91501,'1','72','2019-09-18',98,'','','5',267590.00,'106407','','','1740','Malumfashi','142334',437965.00,'2019-09-20 10:45:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(91502,'1','72','2019-09-18',98,'','','5',137720.00,'106407','','','1740','Malumfashi','142837',137720.00,'2019-09-20 10:46:50',5,'PAYMENT ON ACCOUT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(91503,'1','72','2019-09-19',98,'','','5',372565.00,'106408','','','1740','Malumfashi','99620',379665.00,'2019-09-20 10:55:06',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-22 15:42:45'),(92761,'1','72','2019-09-20',98,'','','5',517670.00,'106616','','','1740','Malumfashi','271395',517670.00,'2019-09-24 19:40:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(92762,'1','72','2019-09-21',98,'','','5',182140.00,'107245','','','1740','Malumfashi','264795',182140.00,'2019-09-24 19:42:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(92763,'1','72','2019-09-22',98,'','','5',399105.00,'107246','','','1740','Malumfashi','270528',678605.00,'2019-09-24 19:44:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(92764,'1','72','2019-09-22',98,'','','5',86000.00,'107246','','','1740','Malumfashi','264106',86000.00,'2019-09-24 19:45:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(92765,'1','72','2019-09-22',98,'','','5',20000.00,'107246','','','1740','Malumfashi','273272',20000.00,'2019-09-24 19:47:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(93989,'1','72','2019-09-23',98,'','','5',549700.00,'107247','','','1740','Malumfashi','276787',564535.00,'2019-09-30 13:53:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(93992,'1','72','2019-09-23',98,'','','5',130000.00,'107247','','','1740','Malumfashi','277721',130000.00,'2019-09-30 13:54:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(93993,'1','72','2019-09-27',98,'','','5',371155.00,'108010','','','1740','Malumfashi','310958',371155.00,'2019-09-30 13:56:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(93995,'1','72','2019-09-28',98,'','','5',458175.00,'108013','','','1740','Malumfashi','309958',458175.00,'2019-09-30 13:59:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(93996,'1','72','2019-09-29',98,'','','5',427800.00,'108016','','','1740','Malumfashi','311480',621300.00,'2019-09-30 14:01:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(94691,'1','72','2019-09-30',98,'','','5',190830.00,'108017','','','1740','Malumfashi','370821',256881.74,'2019-10-02 21:55:09',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:29'),(94692,'1','72','2019-09-30',98,'','','5',95140.00,'108017','','','1740','Malumfashi','529769',95140.00,'2019-10-02 21:57:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:28'),(94693,'1','72','2019-10-01',98,'','','5',618875.00,'108316','','','1740','Malumfashi','370359',620873.54,'2019-10-02 21:59:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:06:37'),(94694,'1','72','2019-10-01',98,'','','5',84375.00,'108316','','','1740','Malumfashi','371389',84375.00,'2019-10-02 22:02:09',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:57'),(94888,'1','72','2019-10-02',98,'','','5',285745.00,'108317','','','1740','Malumfashi','63794',285745.00,'2019-10-03 20:52:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:05:57'),(95979,'1','72','2019-10-03',98,'','','5',194240.00,'108435','','','1740','Malumfashi','123304',194240.00,'2019-10-08 18:32:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-09 15:17:30'),(95980,'1','72','2019-10-04',98,'','','5',123590.00,'109098','','','1740','Malumfashi','337373',123590.00,'2019-10-08 18:34:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-09 15:17:30'),(95983,'1','72','2019-10-05',98,'','','5',237435.00,'109099','','','1740','Malumfashi','335767',237435.00,'2019-10-08 18:36:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-09 15:17:30'),(95984,'1','72','2019-10-06',98,'','','5',369340.00,'109100','','','1740','Malumfashi','334371',369340.00,'2019-10-08 18:39:47',5,'PAYMENT ON ACCOUNT','408','409','2019-10-09 15:14:06','409','2019-10-09 15:17:30'),(95985,'1','72','2019-10-07',98,'','','5',116490.00,'109101','','','1740','Malumfashi','335078',116490.00,'2019-10-08 18:41:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-09 15:17:30'),(96305,'1','72','2019-10-08',98,'','','5',217985.00,'109102','','','1740','Malumfashi','182725',233035.00,'2019-10-09 19:16:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-10 14:05:55'),(96307,'1','72','2019-10-08',98,'','','5',139750.00,'109102','','','1740','Malumfashi','182195',139750.00,'2019-10-09 19:18:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-10 14:05:55'),(96308,'1','72','2019-10-08',98,'','','5',86000.00,'109102','','','1740','Malumfashi','181680',86000.00,'2019-10-09 19:20:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-10 14:05:55'),(96311,'1','72','2019-10-08',98,'','','5',86000.00,'109102','','','1740','Malumfashi','173788',86000.00,'2019-10-09 19:21:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-10 14:05:54'),(97092,'1','72','2019-10-09',98,'','','5',155210.00,'109755','','','1740','Malumfashi','326814',277560.00,'2019-10-13 19:42:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-14 12:34:12'),(97093,'1','72','2019-10-10',98,'','','5',87630.00,'109723','','','1740','Malumfashi','144778',87630.00,'2019-10-13 19:44:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-14 12:34:12'),(97094,'1','72','2019-10-10',98,'','','5',8750.00,'109723','','','1740','Malumfashi','142916',8750.00,'2019-10-13 19:45:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-14 12:34:12'),(97424,'1','72','2019-10-11',98,'','','5',132720.00,'109724','','','1740','Malumfashi','366831',132720.00,'2019-10-14 19:48:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(97425,'1','72','2019-10-12',98,'','','5',44720.00,'109725','','','1740','Malumfashi','364521',159170.00,'2019-10-14 19:54:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(97426,'1','72','2019-10-13',98,'','','5',102945.00,'109726','','','1740','Malumfashi','365550',320945.00,'2019-10-14 20:02:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(97427,'1','72','2019-10-13',98,'','','5',193500.00,'109726','','','1740','Malumfashi','367558',193500.00,'2019-10-14 20:06:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(97428,'1','72','2019-10-13',98,'','','5',129000.00,'109726','','','1740','Malumfashi','366166',129000.00,'2019-10-14 20:08:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(97429,'1','72','2019-10-13',98,'','','5',193500.00,'109726','','','1740','Malumfashi','367558',193500.00,'2019-10-14 20:10:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(97854,'1','72','2019-10-14',98,'','','5',298070.00,'109875','','','1740','Malumfashi','286919',313120.00,'2019-10-16 18:33:08',5,'PAYMENT ON ACCOUNT','408','409','2019-10-21 11:54:02','409','2019-10-21 11:54:36'),(97855,'1','72','2019-10-15',98,'','','5',378800.00,'110101','','','1740','Malumfashi','259968',378800.00,'2019-10-16 18:34:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(98307,'1','72','2019-10-16',98,'','','5',121805.00,'110102','','','1740','Malumfashi','126285',125455.00,'2019-10-18 18:31:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(98308,'1','72','2019-10-17',98,'','','5',318195.00,'110351','','','1740','Malumfashi','336259',395595.00,'2019-10-18 18:33:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-21 11:53:00'),(99041,'1','72','2019-10-18',98,'','','5',258395.00,'110352','','','1740','Malumfashi','197124',260545.00,'2019-10-21 21:15:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-20 12:13:33'),(99042,'1','72','2019-10-19',98,'','','5',200280.00,'110778','','','1740','Malumfashi','0053294386',303625.00,'2019-10-21 21:18:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-22 15:42:13'),(99043,'1','72','2019-10-20',98,'','','5',236255.00,'110779','','','1740','Malumfashi','350119',471255.00,'2019-10-21 21:22:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:04:23'),(99044,'1','72','2019-10-20',98,'','','5',217000.00,'110779','','','1740','Malumfashi','196478',217000.00,'2019-10-21 21:24:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-22 15:42:13'),(99682,'1','72','2019-10-21',98,'','','5',230255.00,'111011','','','1740','Malumfashi','310075',354955.00,'2019-10-23 18:31:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-25 12:53:29'),(99685,'1','72','2019-10-22',98,'','','5',236885.00,'111013','','','1740','Malumfashi','254305',393715.00,'2019-10-23 18:34:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-25 12:53:29'),(99687,'1','72','2019-10-22',98,'','','5',120200.00,'111013','','','1740','Malumfashi','254914',120200.00,'2019-10-23 18:35:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-25 12:53:29'),(101056,'1','72','2019-10-23',98,'','','5',227555.00,'111014','','','1740','Malumfashi','0053302118',337555.00,'2019-10-29 19:40:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-31 10:42:20'),(101057,'1','72','2019-10-24',98,'','','5',433035.00,'111745','','','1740','Malumfashi','340660',433035.00,'2019-10-29 19:44:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-31 10:42:20'),(101058,'1','72','2019-10-25',98,'','','5',231595.00,'111746','','','1740','Malumfashi','336988',231595.00,'2019-10-29 19:46:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-31 10:42:20'),(101059,'1','72','2019-10-26',98,'','','5',256980.00,'111747','','','1740','Malumfashi','345865',256980.00,'2019-10-29 19:51:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-31 10:42:20'),(101060,'1','72','2019-10-27',98,'','','5',281785.00,'111748','','','1740','Malumfashi','376154',281785.00,'2019-10-29 19:53:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-31 10:42:20'),(101219,'1','72','2019-10-28',98,'','','5',195685.00,'111750','','','1740','Malumfashi','229484',210735.00,'2019-10-30 14:42:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-31 10:42:20'),(101221,'1','72','2019-10-29',98,'','','5',210960.00,'111751','','','1740','Malumfashi','228895',210960.00,'2019-10-30 14:43:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-31 10:42:20'),(101828,'1','72','2019-10-30',98,'','','5',183865.00,'12345','','','1740','Malumfashi','156062',183865.00,'2019-11-02 11:17:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-13 11:58:55'),(101831,'1','72','2019-10-31',98,'','','5',127670.00,'12345','','','1740','Malumfashi','160480',178665.00,'2019-11-02 11:19:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-13 12:44:17'),(101832,'1','72','2019-11-01',98,'','','5',195685.00,'12345','','','1740','Malumfashi','229484',195685.00,'2019-11-02 11:21:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-13 11:58:55'),(101834,'1','72','2019-11-01',98,'','','5',5000.00,'12345','','','1740','Malumfashi','159555',5000.00,'2019-11-02 11:23:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-13 11:58:55'),(103375,'1','72','2019-11-01',98,'','','5',199585.00,'12345','','','1740','Malumfashi','124154',199585.00,'2019-11-10 12:50:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-13 11:58:55'),(103376,'1','72','2019-11-04',98,'','','5',156830.00,'12345','','','1740','Malumfashi','123432',156830.00,'2019-11-10 12:52:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-13 11:58:55'),(103378,'1','72','2019-11-07',98,'','','5',110000.00,'12345','','','1740','Malumfashi','108232',110000.00,'2019-11-10 12:54:06',5,'PAYMENT ON ACCOUNT','408','409','2019-11-12 09:29:31','409','2019-11-13 11:58:55'),(103379,'1','72','2019-11-01',98,'','','5',103345.00,'12345','','','1740','Malumfashi','394654',103345.00,'2019-11-10 13:02:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-13 11:58:55'),(103999,'1','72','2019-11-12',98,'','','5',109650.00,'12345','','','1740','Malumfashi','444459',109650.00,'2019-11-12 17:49:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-13 11:58:55'),(104001,'1','72','2019-11-12',98,'','','5',77400.00,'12345','','','1740','Malumfashi','445531',77400.00,'2019-11-12 17:51:30',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-20 12:10:25'),(104518,'1','72','2019-11-13',98,'','','5',23600.00,'113467','','','1740','Malumfashi','304009',174818.59,'2019-11-14 15:07:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-20 12:10:25'),(104519,'1','72','2019-11-13',98,'','','5',50000.00,'113467','','','1740','Malumfashi','305148',50000.00,'2019-11-14 15:09:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-20 12:10:25'),(104521,'1','72','2019-11-13',98,'','','5',33000.00,'113467','','','1740','Malumfashi','304600',33000.00,'2019-11-14 15:10:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-20 12:10:25'),(104748,'1','72','2019-11-14',98,'','','5',123600.00,'113640','','','1740','Malumfashi','215860',168600.00,'2019-11-15 15:50:17',5,'PAYMENT ON ACCOUNT','408','409','2019-11-18 10:20:31','409','2019-11-20 12:10:25'),(105398,'1','72','2019-11-15',98,'','','5',110480.00,'113770','','','1740','Malumfashi','325908',112978.80,'2019-11-18 15:47:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-20 12:10:25'),(105401,'1','72','2019-11-16',98,'','','5',25660.00,'114027','','','1740','Malumfashi','324456',140056.39,'2019-11-18 15:50:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-20 12:10:25'),(105403,'1','72','2019-11-17',98,'','','5',15825.00,'114029','','','1740','Malumfashi','325080',345825.00,'2019-11-18 15:53:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-22 10:18:17'),(105952,'1','72','2019-11-18',98,'','','5',118870.00,'114032','','','1740','Malumfashi','226400',134270.00,'2019-11-20 19:33:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-22 10:18:17'),(105953,'1','72','2019-11-19',98,'','','5',26755.00,'114379','','','1740','Malumfashi','245595',114755.00,'2019-11-20 19:35:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-22 10:18:17'),(105954,'1','72','2019-11-19',98,'','','5',151220.00,'114379','','','1740','Malumfashi','245218',151220.00,'2019-11-20 19:37:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-22 10:18:17'),(106168,'1','72','2019-11-20',98,'','','5',191100.00,'114380','','','1740','Malumfashi','12345',191100.00,'2019-11-21 18:20:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-22 10:18:17'),(107356,'1','72','2019-11-21',98,'','','5',226975.00,'114381','','','1740','Malumfashi','99920',397675.00,'2019-11-26 19:49:01',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-27 12:39:34'),(107358,'1','72','2019-11-22',98,'','','5',304100.00,'114505','','','1740','Malumfashi','350303',304100.00,'2019-11-26 19:50:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-27 12:39:34'),(107360,'1','72','2019-11-23',98,'','','5',283000.00,'115235','','','1740','Malumfashi','349607',283000.00,'2019-11-26 19:53:01',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-27 12:39:34'),(107361,'1','72','2019-11-24',98,'','','5',534760.00,'115236','','','1740','Malumfashi','209951',704160.00,'2019-11-26 19:55:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 09:57:50'),(107704,'1','72','2019-11-25',98,'','','5',280050.00,'115237','','','1740','Malumfashi','253720',786050.00,'2019-11-27 18:31:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-28 12:10:15'),(107707,'1','72','2019-11-26',98,'','','5',222130.00,'115238','','','1740','Malumfashi','252857',222130.00,'2019-11-27 18:32:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-28 12:10:15'),(107709,'1','72','2019-11-26',98,'','','5',5000.00,'115238','','','1740','Malumfashi','253223',5000.00,'2019-11-27 18:34:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-11-28 12:10:15'),(108075,'1','72','2019-11-27',98,'','','5',289755.00,'115239','','','1740','Malumfashi','184414',398710.00,'2019-11-28 16:12:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:04:23'),(108076,'1','72','2019-11-27',98,'','','5',114400.00,'115239','','','1740','Malumfashi','184011',114400.00,'2019-11-28 16:13:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:04:23'),(108078,'1','72','2019-11-27',98,'','','5',110000.00,'115239','','','1740','Malumfashi','183595',110000.00,'2019-11-28 16:15:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:47:34'),(108079,'1','72','2019-11-27',98,'','','5',45000.00,'115239','','','1740','Malumfashi','182671',45000.00,'2019-11-28 16:16:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:47:34'),(108080,'1','72','2019-11-27',98,'','','5',88000.00,'115239','','','1740','Malumfashi','183104',88000.00,'2019-11-28 16:18:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:47:34'),(108576,'1','72','2019-11-28',98,'','','5',245680.00,'115390','','','1740','Malumfashi','92320',245680.00,'2019-12-01 17:02:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:47:34'),(108577,'1','72','2019-11-28',98,'','','5',106755.00,'115390','','','1740','Malumfashi','340103',106755.00,'2019-12-01 17:04:06',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:47:34'),(108578,'1','72','2019-11-28',98,'','','5',132000.00,'115390','','','1740','Malumfashi','409916',132000.00,'2019-12-01 17:05:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:47:34'),(109200,'1','72','2019-11-29',98,'','','5',255475.00,'115783','','','1740','Malumfashi','467346',255475.00,'2019-12-04 09:45:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:06'),(109202,'1','72','2019-11-30',98,'','','5',226885.00,'115784','','','1740','Malumfashi','467346',275885.00,'2019-12-04 09:47:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:06'),(109203,'1','72','2019-12-01',98,'','','5',93785.00,'12345','','','1740','Malumfashi','467346',109183.80,'2019-12-04 09:50:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:06'),(109204,'1','72','2019-12-01',98,'','','5',215000.00,'12345','','','1740','Malumfashi','467346',215000.00,'2019-12-04 09:53:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:06'),(109205,'1','72','2019-12-01',98,'','','5',5000.00,'12345','','','1740','Malumfashi','467346',5000.00,'2019-12-04 09:55:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:06'),(109206,'1','72','2019-12-01',98,'','','5',145700.00,'12345','','','1740','Malumfashi','467346',145700.00,'2019-12-04 09:56:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:06'),(110808,'1','72','2019-12-06',98,'','','5',28850.00,'116802','','','1740','Malumfashi','289182',28850.00,'2019-12-10 12:35:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:06'),(110812,'1','72','2019-12-06',98,'','','5',418000.00,'116802','','','1740','Malumfashi','166805',418000.00,'2019-12-10 12:36:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(110815,'1','72','2019-12-07',98,'','','5',30275.00,'116822','','','1740','Malumfashi','287727',30275.00,'2019-12-10 12:38:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(110818,'1','72','2019-12-08',98,'','','5',82700.00,'116869','','','1740','Malumfashi','288561',302700.20,'2019-12-10 12:40:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(110942,'1','72','2019-12-09',98,'','','5',40605.00,'116870','','','1740','Malumfashi','344791',130805.40,'2019-12-10 17:51:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(111325,'1','72','2019-12-10',98,'','','5',44320.00,'116953','','','1740','Malumfashi','111516',46321.75,'2019-12-11 18:05:34',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(111775,'1','72','2019-12-11',98,'','','5',74180.00,'116961','','','1740','Malumfashi','111477',74177.15,'2019-12-13 13:19:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(111776,'1','72','2019-12-12',98,'','','5',104565.00,'117099','','','1740','Malumfashi','110684',104565.00,'2019-12-13 13:20:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(112608,'1','72','2019-12-13',98,'','','5',121800.00,'117231','','','1740','Malumfashi','476717',135320.00,'2019-12-16 20:23:34',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(112609,'1','72','2019-12-13',98,'','','5',13520.00,'117231','','','1740','Malumfashi','398616',13520.00,'2019-12-16 20:25:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:42:05'),(112610,'1','72','2019-12-14',98,'','','5',44485.00,'117392','','','1740','Malumfashi','396278',508585.00,'2019-12-16 20:27:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:06:03'),(112611,'1','72','2019-12-15',98,'','','5',269975.00,'117510','','','1740','Malumfashi','399430',398975.00,'2019-12-16 20:29:53',5,'PAYMENT ON ACCOUNT','408','125','2019-12-18 10:10:39','125','2019-12-18 10:11:03'),(112612,'1','72','2019-12-15',98,'','','5',88000.00,'117510','','','1740','Malumfashi','397765',88000.00,'2019-12-16 20:31:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:07:34'),(112613,'1','72','2019-12-15',98,'','','5',2900.00,'117510','','','1740','Malumfashi','400185',2900.00,'2019-12-16 20:33:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:07:34'),(112855,'1','72','2019-12-16',98,'','','5',217410.00,'117613','','','1740','Malumfashi','435953',626110.00,'2019-12-17 17:41:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:07:34'),(112856,'1','72','2019-12-16',98,'','','5',220000.00,'117613','','','1740','Malumfashi','437872',220000.00,'2019-12-17 17:43:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:07:33'),(112857,'1','72','2019-12-16',98,'','','5',17875.00,'117613','','','1740','Malumfashi','436968',17875.00,'2019-12-17 17:44:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2019-12-18 10:07:33'),(113213,'1','72','2019-12-17',98,'','','5',338825.00,'117747','','','1740','Malumfashi','255465',338825.00,'2019-12-18 19:11:17',0,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(113437,'1','72','2019-12-19',98,'','','5',204480.00,'117908','','','1740','Malumfashi','246020',323800.00,'2019-12-19 18:03:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:30'),(113439,'1','72','2019-12-18',98,'','','5',10000.00,'117908','','','1740','Malumfashi','247038',10000.00,'2019-12-19 18:05:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-01-09 15:33:41'),(113857,'1','72','2019-12-19',98,'','','5',250885.00,'118167','','','1740','Malumfashi','426245',250885.00,'2019-12-21 17:50:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-01-09 15:33:40'),(113858,'1','72','2019-12-19',98,'','','5',129000.00,'118167','','','1740','Malumfashi','424184',129000.00,'2019-12-21 17:52:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-01-09 15:33:40'),(113859,'1','72','2019-12-19',98,'','','5',220000.00,'118167','','','1740','Malumfashi','425248',220000.00,'2019-12-21 17:53:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-01-09 15:33:40'),(113861,'1','72','2019-12-19',98,'','','5',88000.00,'118167','','','1740','Malumfashi','423170',88000.00,'2019-12-21 17:54:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-01-09 15:33:40'),(130597,'1','72','2019-12-20',98,'','','5',197640.00,'127160','','','1740','Malumfashi','515044',15899.20,'2020-03-01 09:55:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:56'),(130598,'1','72','2019-12-20',98,'','','5',24000.00,'127160','','','1740','Malumfashi','517063',24000.00,'2020-03-01 09:58:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:18'),(130599,'1','72','2019-12-20',98,'','','5',10000.00,'127160','','','1740','Malumfashi','247038',10000.00,'2020-03-01 10:01:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:18'),(130600,'1','72','2019-12-20',98,'','','5',86000.00,'127160','','','1740','Malumfashi','508878',86000.00,'2020-03-01 10:02:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:18'),(130601,'1','72','2019-12-20',98,'','','5',158850.00,'127160','','','1740','Malumfashi','515698',158850.00,'2020-03-01 10:04:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:18'),(130602,'1','72','2019-12-21',98,'','','5',258235.00,'127160','','','1740','Malumfashi','514307',258235.00,'2020-03-01 10:07:48',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:18'),(130603,'1','72','2019-12-22',98,'','','5',439330.00,'127160','','','1740','Malumfashi','510141',439330.00,'2020-03-01 10:09:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:18'),(130604,'1','72','2019-12-23',98,'','','5',242680.00,'127160','','','1740','Malumfashi','356435',242680.00,'2020-03-01 10:11:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:18'),(130605,'1','72','2019-12-24',98,'','','5',202695.00,'127160','','','1740','Malumfashi','525422',202695.00,'2020-03-01 10:13:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:18'),(130606,'1','72','2019-12-25',98,'','','5',170510.00,'127160','','','1740','Malumfashi','525210',170510.00,'2020-03-01 10:15:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130607,'1','72','2019-12-25',98,'','','5',119325.00,'127160','','','1740','Malumfashi','528099',119325.00,'2020-03-01 10:17:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130608,'1','72','2019-12-26',98,'','','5',56620.00,'127160','','','1740','Malumfashi','277882',56620.00,'2020-03-01 10:18:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130609,'1','72','2019-12-27',98,'','','5',77380.00,'127160','','','1740','Malumfashi','281226',77380.00,'2020-03-01 10:20:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130610,'1','72','2019-12-27',98,'','','5',193500.00,'127160','','','1740','Malumfashi','274828',193500.00,'2020-03-01 10:22:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130611,'1','72','2019-12-27',98,'','','5',129000.00,'127160','','','1740','Malumfashi','526789',129000.00,'2020-03-01 10:23:51',5,'PAYMENT ON ACCCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130613,'1','72','2019-12-28',98,'','','5',34235.00,'127160','','','1740','Malumfashi','260075',34235.00,'2020-03-01 10:26:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130615,'1','72','2019-12-29',98,'','','5',32000.00,'127160','','','1740','Malumfashi','263771',32000.00,'2020-03-01 10:27:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130616,'1','72','2019-12-30',98,'','','5',30250.00,'127160','','','1740','Malumfashi','262036',30250.00,'2020-03-01 10:29:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130617,'1','72','2019-12-31',98,'','','5',33760.00,'127160','','','1740','Malumfashi','265739',33760.00,'2020-03-01 10:31:06',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:17'),(130618,'1','72','2019-12-31',98,'','','5',21500.00,'127160','','','1740','Malumfashi','140655',21500.00,'2020-03-01 10:33:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130619,'1','72','2020-01-01',98,'','','5',13000.00,'127018','','','1740','Malumfashi','266866',13000.00,'2020-03-01 10:38:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130620,'1','72','2020-01-02',98,'','','5',13700.00,'127019','','','1740','Malumfashi','135896',13700.00,'2020-03-01 10:39:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130621,'1','72','2020-01-03',98,'','','5',47875.00,'127021','','','1740','Malumfashi','240215',47875.00,'2020-03-01 10:41:58',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130622,'1','72','2020-01-03',98,'','','5',96750.00,'127021','','','1740','Malumfashi','235241',96750.00,'2020-03-01 10:43:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130623,'1','72','2020-01-03',98,'','','5',97600.00,'127021','','','1740','Malumfashi','276558',97600.00,'2020-03-01 10:46:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130624,'1','72','2020-01-21',98,'','','5',67580.00,'127024','','','1740','Malumfashi','253140',67580.00,'2020-03-01 10:49:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130625,'1','72','2020-01-21',98,'','','5',86000.00,'127024','','','1740','Malumfashi','202032',86000.00,'2020-03-01 10:51:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130626,'1','72','2020-01-22',98,'','','5',18000.00,'127026','','','1740','Malumfashi','252942',18000.00,'2020-03-01 10:52:34',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130627,'1','72','2020-01-23',98,'','','5',115375.00,'127027','','','1740','Malumfashi','184278',115375.00,'2020-03-01 10:54:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130628,'1','72','2020-01-24',98,'','','5',103375.00,'127029','','','1740','Malumfashi','244916',103375.00,'2020-03-01 10:55:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:16'),(130629,'1','72','2020-01-25',98,'','','5',31130.00,'127030','','','1740','Malumfashi','246783',31130.00,'2020-03-01 10:57:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130630,'1','72','2020-01-26',98,'','','5',91665.00,'127032','','','1740','Malumfashi','183143',91665.00,'2020-03-01 10:58:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130631,'1','72','2020-01-27',98,'','','5',53335.00,'127035','','','1740','Malumfashi','306756',53335.00,'2020-03-01 11:00:09',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130632,'1','72','2020-01-28',98,'','','5',125180.00,'127036','','','1740','Malumfashi','180312',125180.00,'2020-03-01 11:01:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130633,'1','72','2020-01-29',98,'','','5',122500.00,'127039','','','1740','Malumfashi','228934',122500.00,'2020-03-01 11:02:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130634,'1','72','2020-01-30',98,'','','5',10250.00,'127041','','','1740','Malumfashi','232113',10250.00,'2020-03-01 11:04:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130636,'1','72','2020-01-30',98,'','','5',20000.00,'127041','','','1740','Malumfashi','233685',20000.00,'2020-03-01 11:05:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130637,'1','72','2020-01-30',98,'','','5',142260.00,'127041','','','1740','Malumfashi','376803',142260.00,'2020-03-01 11:06:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130639,'1','72','2020-01-31',98,'','','5',44800.00,'127042','','','1740','Malumfashi','385480',44800.00,'2020-03-01 11:08:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-03 10:27:15'),(130947,'1','72','2020-02-01',98,'','','5',11000.00,'127044','','','1740','Malumfashi','382643',60000.75,'2020-03-02 17:05:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:30'),(130948,'1','72','2020-02-01',98,'','','5',170000.00,'127048','','','1740','Malumfashi','383894',170000.00,'2020-03-02 17:08:20',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:30'),(130951,'1','72','2020-02-02',98,'','','5',10965.00,'127048','','','1740','Malumfashi','386925',62963.99,'2020-03-02 17:10:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:30'),(130953,'1','72','2020-02-03',98,'','','5',76400.00,'127051','','','1740','Malumfashi','83659',143147.25,'2020-03-02 17:13:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:30'),(130956,'1','72','2020-02-03',98,'','','5',62500.00,'127051','','','1740','Malumfashi','85230',62500.00,'2020-03-02 17:15:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131150,'1','72','2020-02-04',98,'','','5',176950.00,'127052','','','1740','Malumfashi','184750',176949.00,'2020-03-03 13:08:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131152,'1','72','2020-02-05',98,'','','5',8160.00,'127054','','','1740','Malumfashi','356022',197160.75,'2020-03-03 13:11:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131156,'1','72','2020-02-06',98,'','','5',160300.00,'127055','','','1740','Malumfashi','354797',160299.00,'2020-03-03 13:13:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131157,'1','72','2020-02-06',98,'','','5',5000.00,'127055','','','1740','Malumfashi','356592',5000.00,'2020-03-03 13:15:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131159,'1','72','2020-02-06',98,'','','5',49500.00,'127055','','','1740','Malumfashi','355477',49500.00,'2020-03-03 13:16:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131162,'1','72','2020-02-07',98,'','','5',57495.00,'127056','','','1740','Malumfashi','384392',57494.25,'2020-03-03 13:18:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131164,'1','72','2020-02-08',98,'','','5',51400.00,'127057','','','1740','Malumfashi','381339',51399.00,'2020-03-03 13:20:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131166,'1','72','2020-02-09',98,'','','5',19695.00,'127060','','','1740','Malumfashi','383544',136365.00,'2020-03-03 13:22:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131170,'1','72','2020-02-09',98,'','','5',114200.00,'127060','','','1740','Malumfashi','382184',114200.00,'2020-03-03 13:26:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131172,'1','72','2020-02-09',98,'','','5',111900.00,'127060','','','1740','Malumfashi','382901',111900.00,'2020-03-03 13:28:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131175,'1','72','2020-02-10',98,'','','5',42840.00,'127061','','','1740','Malumfashi','294761',47337.75,'2020-03-03 13:30:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131176,'1','72','2020-02-10',98,'','','5',8000.00,'127061','','','1740','Malumfashi','292408',8000.00,'2020-03-03 13:32:06',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:29'),(131177,'1','72','2020-02-11',98,'','','5',22550.00,'127062','','','1740','Malumfashi','218132',165660.00,'2020-03-03 13:38:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:28'),(131178,'1','72','2020-02-12',98,'','','5',153610.00,'127064','','','1740','Malumfashi','129959',153610.00,'2020-03-03 13:44:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:28'),(131738,'1','72','2020-02-13',98,'','','5',54685.00,'127122','','','1740','Malumfashi','134286',54685.00,'2020-03-05 20:01:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:28'),(131993,'1','72','2020-02-14',98,'','','5',49890.00,'127123','','','1740','Malumfashi','383805',159890.00,'2020-03-07 10:22:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:28'),(131994,'1','72','2020-02-15',98,'','','5',239960.00,'127124','','','1740','Malumfashi','384525',239960.00,'2020-03-07 10:23:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:28'),(131996,'1','72','2020-02-16',98,'','','5',21000.00,'127125','','','1740','Malumfashi','383056',20996.80,'2020-03-07 10:26:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:28'),(131998,'1','72','2020-02-17',98,'','','5',16320.00,'127126','','','1740','Malumfashi','183124',20725.00,'2020-03-07 10:29:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:42:28'),(131999,'1','72','2020-02-18',98,'','','5',79100.00,'127127','','','1740','Malumfashi','17327',80592.59,'2020-03-07 10:31:35',5,'PAYMENT ON ACCOUNT','408','125','2020-03-10 10:43:25','125','2020-03-10 10:48:17'),(132000,'1','72','2020-02-18',98,'','','5',116700.00,'127127','','','1740','Malumfashi','184234',116700.00,'2020-03-07 10:34:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132001,'1','72','2020-02-18',98,'','','5',6750.00,'127127','','','1740','Malumfashi','183686',6750.00,'2020-03-07 10:36:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132003,'1','72','2020-02-18',98,'','','5',87750.00,'127127','','','1740','Malumfashi','250194',87750.00,'2020-03-07 10:38:34',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132006,'1','72','2020-02-19',98,'','','5',89910.00,'127128','','','1740','Malumfashi','214135',89911.80,'2020-03-07 10:41:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132008,'1','72','2020-02-19',98,'','','5',4000.00,'127128','','','1740','Malumfashi','215394',4000.00,'2020-03-07 10:43:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132010,'1','72','2020-02-20',98,'','','5',41830.00,'127131','','','1740','Malumfashi','197169',351826.20,'2020-03-07 10:45:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:09'),(132011,'1','72','2020-02-20',98,'','','5',58250.00,'127132','','','1740','Malumfashi','017327',58250.00,'2020-03-07 10:47:30',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132012,'1','72','2020-02-20',98,'','','5',101250.00,'127132','','','1740','Malumfashi','195363',101250.00,'2020-03-07 10:50:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132146,'1','72','2020-02-20',98,'','','5',10000.00,'127131','','','1740','Malumfashi','198086',10000.00,'2020-03-08 10:55:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132147,'1','72','2020-02-20',98,'','','5',50000.00,'127131','','','1740','Malumfashi','195924',50000.00,'2020-03-08 10:56:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132148,'1','72','2020-02-20',98,'','','5',33000.00,'127131','','','1740','Malumfashi','197617',33000.00,'2020-03-08 10:58:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132151,'1','72','2020-02-20',98,'','','2',310000.00,'127131','','','','','',310000.00,'2020-03-08 11:02:18',5,'PAYMENT F0R F I O FGE 49 ZY','408','125','2020-03-10 11:13:28','125','2020-03-10 11:23:39'),(132153,'1','72','2020-02-21',98,'','','5',121820.00,'127132','','','1740','Malumfashi','271868',121819.00,'2020-03-08 11:04:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:48:16'),(132155,'1','72','2020-02-21',98,'','','5',110000.00,'127132','','','1740','Malumfashi','272874',110000.00,'2020-03-08 11:05:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:51'),(132157,'1','72','2020-02-21',98,'','','5',143000.00,'127132','','','1740','Malumfashi','271299',143000.00,'2020-03-08 11:06:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:51'),(132158,'1','72','2020-02-22',98,'','','5',57080.00,'127133','','','1740','Malumfashi','295053',57078.20,'2020-03-08 11:08:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:51'),(132160,'1','72','2020-02-23',98,'','','5',67205.00,'127134','','','1740','Malumfashi','313398',385626.14,'2020-03-08 11:10:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:51'),(132161,'1','72','2020-02-24',98,'','','5',10300.00,'127137','','','1740','Malumfashi','294210',14600.00,'2020-03-08 11:11:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:51'),(132163,'1','72','2020-02-25',98,'','','5',37395.00,'127137','','','1740','Malumfashi','319328',157794.94,'2020-03-08 11:13:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:51'),(132166,'1','72','2020-02-25',98,'','','5',90300.00,'127137','','','1740','Malumfashi','316993',90300.00,'2020-03-08 11:14:35',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:51'),(132170,'1','72','2020-02-26',98,'','','5',109500.00,'127138','','','1740','Malumfashi','145155',109501.00,'2020-03-08 11:16:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:51'),(132172,'1','72','2020-02-26',98,'','','5',20000.00,'127138','','','1740','Malumfashi','148530',20000.00,'2020-03-08 11:17:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:50'),(132173,'1','72','2020-02-27',98,'','','5',61035.00,'127139','','','1740','Malumfashi','185099',61032.05,'2020-03-08 11:19:36',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:50'),(132175,'1','72','2020-02-28',98,'','','5',150160.00,'127140','','','1740','Malumfashi','307370',150160.29,'2020-03-08 11:21:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:50'),(132177,'1','72','2020-02-29',98,'','','5',1115.00,'127160','','','1740','Malumfashi','308029',50114.35,'2020-03-08 11:23:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:50'),(132179,'1','72','2020-02-29',98,'','','5',50000.00,'127160','','','1740','Malumfashi','17727',50000.00,'2020-03-08 11:24:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:50'),(132180,'1','72','2020-03-01',98,'','','5',107830.00,'127345','','','1740','Malumfashi','32997',107829.00,'2020-03-08 11:26:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-10 10:51:50'),(132181,'1','72','2020-03-02',98,'','','5',106960.00,'127348','','','1740','Malumfashi','275728',176338.69,'2020-03-08 11:28:41',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:56'),(132182,'1','72','2020-03-03',98,'','','5',19250.00,'127398','','','1740','Malumfashi','276876',127998.10,'2020-03-08 11:30:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:55'),(132183,'1','72','2020-03-04',98,'','','5',14000.00,'127865','','','1740','Malumfashi','728442',14000.00,'2020-03-08 11:32:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:55'),(132184,'1','72','2020-03-05',98,'','','5',25650.00,'127867','','','1740','Malumfashi','288227',122369.50,'2020-03-08 11:33:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:55'),(132185,'1','72','2020-03-05',98,'','','5',24000.00,'127867','','','1740','Malumfashi','173745',24000.00,'2020-03-08 11:35:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:55'),(132186,'1','72','2020-03-05',98,'','','5',99100.00,'127867','','','1740','Malumfashi','171752',99100.00,'2020-03-08 11:36:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:55'),(132669,'1','72','2020-03-06',98,'','','5',89900.00,'127868','','','1740','Malumfashi','297704',89900.00,'2020-03-10 12:47:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:55'),(132670,'1','72','2020-03-06',98,'','','5',10000.00,'127868','','','1740','Malumfashi','295935',10000.00,'2020-03-10 12:48:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132672,'1','72','2020-01-01',98,'','','5',13000.00,'123456','','','1740','Malumfashi','266866',13000.00,'2020-03-10 12:55:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132673,'1','72','2020-01-02',98,'','','5',13700.00,'123456','','','1740','Malumfashi','135896',13701.95,'2020-03-10 12:57:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132674,'1','72','2020-01-03',98,'','','5',47875.00,'123456','','','1740','Malumfashi','240215',74022.35,'2020-03-10 12:59:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132675,'1','72','2020-01-03',98,'','','5',96750.00,'123456','','','1740','Malumfashi','235241',96750.00,'2020-03-10 13:00:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132676,'1','72','2020-01-03',98,'','','5',97600.00,'123456','','','1740','Malumfashi','276558',97600.00,'2020-03-10 13:03:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132678,'1','72','2020-01-21',98,'','','5',67580.00,'123456','','','1740','Malumfashi','253140',67578.75,'2020-03-10 13:05:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132680,'1','72','2020-01-21',98,'','','5',86000.00,'123456','','','1740','Malumfashi','202032',86000.00,'2020-03-10 13:06:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132684,'1','72','2020-01-22',98,'','','5',18000.00,'123456','','','1740','Malumfashi','252942',160260.00,'2020-03-10 13:08:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132686,'1','72','2020-01-23',98,'','','5',115375.00,'123456','','','1740','Malumfashi','184278',205373.25,'2020-03-10 13:10:06',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132687,'1','72','2020-01-24',98,'','','5',103375.00,'123456','','','1740','Malumfashi','244916',103374.50,'2020-03-10 13:11:44',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132688,'1','72','2020-01-25',98,'','','5',31130.00,'123456','','','1740','Malumfashi','246783',31128.75,'2020-03-10 13:13:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:54'),(132689,'1','72','2020-01-26',98,'','','5',91665.00,'123456','','','1740','Malumfashi','183143',93912.75,'2020-03-10 13:15:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:53'),(132690,'1','72','2020-01-27',98,'','','5',53335.00,'123456','','','1740','Malumfashi','306756',57834.00,'2020-03-10 13:17:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:47:53'),(132692,'1','72','2020-01-28',98,'','','5',125180.00,'123456','','','1740','Malumfashi','180312',215181.00,'2020-03-10 13:19:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:09'),(132693,'1','72','2020-01-29',98,'','','5',122500.00,'123456','','','1740','Malumfashi','228934',234443.25,'2020-03-10 13:21:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:09'),(132695,'1','72','2020-01-30',98,'','','5',10250.00,'123456','','','1740','Malumfashi','232113',72749.25,'2020-03-10 13:22:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:09'),(132696,'1','72','2020-01-30',98,'','','5',20000.00,'123456','','','1740','Malumfashi','233685',20000.00,'2020-03-10 13:24:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:49:46'),(132697,'1','72','2020-01-30',98,'','','5',142260.00,'123456','','','1740','Malumfashi','376803',142260.00,'2020-03-10 13:26:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:49:46'),(132699,'1','72','2020-01-31',98,'','','5',44800.00,'123456','','','1740','Malumfashi','385480',44801.00,'2020-03-10 13:27:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:49:46'),(132727,'1','72','2020-03-07',98,'','','5',101130.00,'127869','','','1740','Malumfashi','272773',101127.40,'2020-03-10 14:31:48',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:49:46'),(132731,'1','72','2020-03-08',98,'','','5',66065.00,'127976','','','1740','Malumfashi','274778',66065.23,'2020-03-10 14:34:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-18 14:49:46'),(132733,'1','72','2020-03-09',98,'','','5',37070.00,'128233','','','1740','Malumfashi','274087',41368.15,'2020-03-10 14:36:21',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:09'),(132740,'1','72','2020-03-09',98,'','','5',30300.00,'128233','','','1740','Malumfashi','273459',30300.00,'2020-03-10 14:37:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:09'),(132975,'1','72','2020-03-10',98,'','','5',181015.00,'128256','','','1740','Malumfashi','271741',279973.60,'2020-03-11 14:40:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:09'),(132976,'1','72','2020-03-10',98,'','','5',108750.00,'128256','','','1740','Malumfashi','273223',108750.00,'2020-03-11 14:42:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:08'),(132978,'1','72','2020-03-10',98,'','','5',65100.00,'128256','','','1740','Malumfashi','272425',65100.00,'2020-03-11 14:43:23',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:08'),(133202,'1','72','2020-03-11',98,'','','5',208870.00,'128384','','','1740','Malumfashi','264174',208870.00,'2020-03-12 14:07:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:21:08'),(134460,'1','72','2020-03-12',98,'','','5',25375.00,'128488','','','1740','Malumfashi','125512',25374.30,'2020-03-17 11:59:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134461,'1','72','2020-03-13',98,'','','5',4825.00,'129160','','','1740','Malumfashi','159566',216222.30,'2020-03-17 12:01:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134462,'1','72','2020-03-14',98,'','','5',23950.00,'129161','','','1740','Malumfashi','160866',23952.60,'2020-03-17 12:03:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134463,'1','72','2020-03-14',98,'','','5',96750.00,'129161','','','1740','Malumfashi','158357',96750.00,'2020-03-17 12:05:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134682,'1','72','2020-03-15',98,'','','5',10960.00,'12163','','','1740','Malumfashi','166026',10957.80,'2020-03-18 12:13:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134683,'1','72','2020-03-16',98,'','','5',11640.00,'129167','','','1740','Malumfashi','168530',15840.00,'2020-03-18 12:15:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134685,'1','72','2020-03-17',98,'','','5',51300.00,'129169','','','1740','Malumfashi','167726',51300.96,'2020-03-18 12:17:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134686,'1','72','2020-03-17',98,'','','5',79000.00,'129169','','','1740','Malumfashi','166770',79000.00,'2020-03-18 12:19:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134949,'1','72','2020-03-18',98,'','','5',15300.00,'129280','','','1740','Malumfashi','183701',15298.40,'2020-03-19 13:01:48',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(134950,'1','72','2020-03-18',98,'','','5',50000.00,'129280','','','1740','Malumfashi','184363',50000.00,'2020-03-19 13:04:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(136125,'1','72','2020-03-19',98,'','','5',40700.00,'129442','','','1740','Malumfashi','131641',60700.50,'2020-03-24 13:03:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:03'),(136127,'1','72','2020-03-20',98,'','','5',216165.00,'130093','','','1740','Malumfashi','167663',316566.60,'2020-03-24 13:05:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(136129,'1','72','2020-03-22',98,'','','5',8700.00,'130096','','','1740','Malumfashi','166350',8698.20,'2020-03-24 13:07:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(136131,'1','72','2020-03-23',98,'','','5',24750.00,'130100','','','1740','Malumfashi','166698',28946.40,'2020-03-24 13:09:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(136134,'1','72','2020-03-23',98,'','','5',116000.00,'130097','','','1740','Malumfashi','165532',116000.00,'2020-03-24 13:11:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(136486,'1','72','2020-03-24',98,'','','5',13200.00,'130100','','','1740','Malumfashi','145718',13200.00,'2020-03-25 12:56:02',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(136489,'1','72','2020-03-24',98,'','','5',118250.00,'130100','','','1740','Malumfashi','143224',118250.00,'2020-03-25 12:59:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(137008,'1','72','2020-03-25',98,'','','5',21600.00,'130233','','','1740','Malumfashi','179844',21598.50,'2020-03-28 11:31:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(137009,'1','72','2020-03-26',98,'','','5',26040.00,'130534','','','1740','Malumfashi','66816',26035.80,'2020-03-28 11:33:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(137010,'1','72','2020-03-26',98,'','','5',100400.00,'130534','','','1740','Malumfashi','66211',100400.00,'2020-03-28 11:34:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-03-30 12:19:02'),(145655,'1','72','2020-03-27',98,'','','5',92840.00,'12345','','','1740','Malumfashi','66540',92840.00,'2020-05-10 08:35:21',5,'PAYMENT ON ACCOUNT','408','125','2020-05-11 11:34:27','125','2020-05-18 12:49:19'),(145657,'1','72','2020-04-06',98,'','','5',48300.00,'12345','','','1740','Malumfashi','39818',48300.00,'2020-05-10 08:37:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(145835,'1','72','2020-05-09',98,'','','5',41840.00,'135118','','','1740','Malumfashi','72180',131836.00,'2020-05-11 11:03:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(145836,'1','72','2020-05-09',98,'','','5',26200.00,'135118','','','1740','Malumfashi','73567',26200.00,'2020-05-11 11:05:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(145837,'1','72','2020-05-09',98,'','','5',20000.00,'135118','','','1740','Malumfashi','16760',20000.00,'2020-05-11 11:07:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(145838,'1','72','2020-05-09',98,'','','5',98960.00,'135118','','','1740','Malumfashi','17532',98960.00,'2020-05-11 11:09:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(145839,'1','72','2020-05-09',98,'','','5',50000.00,'135118','','','1740','Malumfashi','164997',50000.00,'2020-05-11 11:12:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(146365,'1','72','2020-05-10',98,'','','5',40875.00,'135209','','','1740','Malumfashi','65167',157475.00,'2020-05-13 11:22:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(146366,'1','72','2020-05-11',98,'','','5',5000.00,'135322','','','1740','Malumfashi','64192',89100.00,'2020-05-13 11:24:16',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(147401,'1','72','2020-05-12',98,'','','5',109640.00,'135428','','','1740','Malumfashi','49659',109640.00,'2020-05-18 11:55:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:49:19'),(147407,'1','72','2020-05-13',98,'','','5',132400.00,'135560','','','1740','Malumfashi','74671',132400.00,'2020-05-18 11:57:29',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:08:39'),(147950,'1','72','2020-05-14',98,'','','5',72900.00,'135778','','','1740','Malumfashi','36219',92900.00,'2020-05-20 10:04:59',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:08:39'),(147951,'1','72','2020-05-15',98,'','','5',6000.00,'135780','','','1740','Malumfashi','23442',10000.00,'2020-05-20 10:07:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:08:39'),(147956,'1','72','2020-05-16',98,'','','5',13000.00,'136140','','','1740','Malumfashi','25368',13000.00,'2020-05-20 10:13:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:08:39'),(147959,'1','72','2020-05-17',98,'','','5',10130.00,'136142','','','1740','Malumfashi','36797',102130.00,'2020-05-20 10:16:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:08:39'),(147962,'1','72','2020-05-18',98,'','','5',50530.00,'136143','','','1740','Malumfashi','37054',50530.00,'2020-05-20 10:19:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:42:26'),(147972,'1','72','2020-05-19',98,'','','5',23000.00,'136329','','','1740','Malumfashi','36503',112990.00,'2020-05-20 10:37:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(148356,'1','72','2020-05-20',98,'','','5',29500.00,'136331','','','1740','Malumfashi','116277',149508.00,'2020-05-22 07:42:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(148357,'1','72','2020-05-21',98,'','','5',20320.00,'136570','','','1740','Malumfashi','7286',20320.00,'2020-05-22 07:43:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:42:25'),(149253,'1','72','2020-05-22',98,'','','5',9970.00,'136572','','','1740','Malumfashi','169075',13870.00,'2020-05-28 07:08:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149254,'1','72','2020-05-23',98,'','','5',35150.00,'137251','','','1740','Malumfashi','168704',35150.00,'2020-05-28 07:10:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149255,'1','72','2020-05-25',98,'','','5',106375.00,'137252','','','1740','Malumfashi','167126',106374.00,'2020-05-28 07:11:37',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149257,'1','72','2020-05-26',98,'','','5',14250.00,'137253','','','1740','Malumfashi','168227',73499.40,'2020-05-28 07:13:21',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149258,'1','72','2020-05-26',98,'','','5',90000.00,'137253','','','1740','Malumfashi','167797',90000.00,'2020-05-28 07:16:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149623,'1','72','2020-05-27',98,'','','5',88000.00,'137254','','','1740','Malumfashi','126766',87999.00,'2020-05-29 09:25:19',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149624,'1','72','2020-05-27',98,'','','5',84100.00,'137254','','','1740','Malumfashi','125774',84100.00,'2020-05-29 09:26:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149741,'1','72','2020-05-28',98,'','','5',48100.00,'137255','','','1740','Malumfashi','49749',48098.70,'2020-05-29 15:39:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149742,'1','72','2020-05-28',98,'','','5',120000.00,'137255','','','1740','Malumfashi','103171',120000.00,'2020-05-29 15:40:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(149743,'1','72','2020-05-28',98,'','','5',90000.00,'137255','','','1740','Malumfashi','103809',90000.00,'2020-05-29 15:41:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:13'),(150263,'1','72','2020-05-29',98,'','','5',48110.00,'137422','','','1740','Malumfashi','121046',48102.60,'2020-06-01 12:02:45',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(150266,'1','72','2020-05-31',98,'','','5',64300.00,'137768','','','1740','Malumfashi','121432',88208.25,'2020-06-01 12:05:04',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(150268,'1','72','2020-05-31',98,'','','5',92000.00,'137768','','','1740','Malumfashi','120719',92000.00,'2020-06-01 12:06:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(150269,'1','72','2020-05-31',98,'','','5',13500.00,'137768','','','1740','Malumfashi','122370',13500.00,'2020-06-01 12:07:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(150574,'1','72','2020-06-01',98,'','','5',21500.00,'137769','','','1740','Malumfashi','63077',21500.00,'2020-06-02 13:31:22',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(150798,'1','72','2020-06-02',98,'','','5',22300.00,'137910','','','1740','Malumfashi','12345',118950.00,'2020-06-03 14:48:47',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(151479,'1','72','2020-06-03',98,'','','5',12160.00,'138041','','','1740','Malumfashi','100191',320610.00,'2020-06-07 10:52:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(151654,'1','72','2020-06-04',98,'','','5',24440.00,'138462','','','1740','Malumfashi','106673',24435.00,'2020-06-08 11:10:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(151655,'1','72','2020-06-05',98,'','','5',104745.00,'138465','','','1740','Malumfashi','106005',104745.00,'2020-06-08 11:12:42',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(151656,'1','72','2020-06-06',98,'','','5',26590.00,'138468','','','1740','Malumfashi','106363',30491.20,'2020-06-08 11:14:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(151671,'1','72','2020-06-07',98,'','','5',32900.00,'138471','','','1740','Malumfashi','107204',32896.00,'2020-06-08 11:28:18',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-09 15:53:12'),(154218,'1','72','2020-06-08',98,'','','5',28800.00,'138605','','','1740','Malumfashi','63205',28800.00,'2020-06-17 16:01:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(154220,'1','72','2020-06-09',98,'','','5',41900.00,'139809','','','1740','Malumfashi','22767',41898.00,'2020-06-17 16:03:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(154222,'1','72','2020-06-10',98,'','','5',56750.00,'139812','','','1740','Malumfashi','176975',56750.00,'2020-06-17 16:05:26',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(154223,'1','72','2020-06-11',98,'','','5',74800.00,'139814','','','1740','Malumfashi','176643',74800.00,'2020-06-17 16:07:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(154224,'1','72','2020-06-12',98,'','','5',16200.00,'139816','','','1740','Malumfashi','176037',20000.00,'2020-06-17 16:09:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(154226,'1','72','2020-06-13',98,'','','5',8250.00,'139817','','','1740','Malumfashi','175634',8234.60,'2020-06-17 16:11:17',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(154227,'1','72','2020-06-13',98,'','','5',20000.00,'139817','','','1740','Malumfashi','176316',20000.00,'2020-06-17 16:13:06',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(154229,'1','72','2020-06-13',98,'','','5',117000.00,'139817','','','1740','Malumfashi','177280',117000.00,'2020-06-17 16:14:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(154541,'1','72','2020-06-18',98,'','','5',94650.00,'139817','','','1740','Malumfashi','97861',94650.00,'2020-06-18 15:30:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-06-19 10:57:22'),(155765,'1','72','2020-06-24',98,'','','5',83300.00,'154541','','','1740','Malumfashi','102913',83300.00,'2020-06-24 11:54:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-07-01 13:25:40'),(155770,'1','72','2020-06-24',98,'','','5',88150.00,'154541','','','1740','Malumfashi','101739',88150.00,'2020-06-24 11:57:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-07-01 13:25:40'),(156047,'1','72','2020-06-25',98,'','','5',59250.00,'154541','','','1740','Malumfashi','81476',59250.00,'2020-06-25 11:10:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-07-01 13:25:40'),(162345,'1','72','2020-07-21',98,'','','5',71600.00,'156047','','','1740','Malumfashi','145109',71600.00,'2020-07-22 07:41:21',0,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(185520,'1','72','2020-10-13',98,'','','5',25000.00,'139817','','','1740','Malumfashi','109583',25000.00,'2020-10-13 15:41:57',0,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=72669 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (40065,'1',26693,'72',226,98,'2018-12-17 00:00:00',NULL,11750.00,11750.00,0.00,'174895','','592','AA RANO 70','SANUSI YAHAYA','08036215056','DISCHAGE OF A G O',5,'2018-12-17 16:58:55','408','0000-00-00 00:00:00','','2018-12-17 17:00:47','408'),(40558,'1',27398,'72',226,98,'2018-12-25 00:00:00',NULL,12000.00,12000.00,0.00,'08039573952','','592','XH 227 DAL','AUWALU','08039573952','DISCHAGE OF A G O',5,'2018-12-25 16:30:55','408','0000-00-00 00:00:00','','2018-12-27 09:37:24','408'),(41435,'1',27944,'72',226,98,'2019-01-09 00:00:00',NULL,15000.00,15000.00,0.00,'165558','','592','KUJ 873 XT','IBRAHIM','','DISCHAGE OF A G O',5,'2019-01-09 14:36:04','408','0000-00-00 00:00:00','','2019-01-09 14:43:34','408'),(42321,'1',28594,'72',226,98,'2019-01-24 00:00:00',NULL,19750.00,19750.00,0.00,'170663','','592','KSF932XS','BALA','08108028606','DISCHAGE OF A G O',5,'2019-01-24 16:24:27','408','0000-00-00 00:00:00','','2019-01-24 16:28:04','408'),(43249,'1',29163,'72',226,98,'2019-02-09 00:00:00',NULL,20000.00,20000.00,0.00,'158137','','592','RAN 827 XA','DAN ALHAJI ','08060547974','DISCHARGE OF AGO',5,'2019-02-09 10:39:26','408','0000-00-00 00:00:00','','2019-02-09 10:39:58','408'),(44537,'1',29163,'72',226,98,'2019-03-06 00:00:00',NULL,13000.00,13000.00,0.00,'158137','','592','RAN 827 XA','ABDULLAHI','08060547974','DISCHARGE OF AGO',5,'2019-03-06 12:21:20','408','0000-00-00 00:00:00','','2019-03-06 12:21:36','408'),(49310,'1',32994,'72',226,98,'2019-05-23 00:00:00',NULL,21800.00,21800.00,0.00,'0806882666','','592','XF187FGE','ABUBAKAR','08068823666','DISCHAGE OF A G O',5,'2019-05-23 11:49:52','408','0000-00-00 00:00:00','','2019-05-23 11:51:53','408'),(52510,'1',34982,'72',225,98,'2019-07-19 00:00:00',NULL,14800.00,14800.00,0.00,'181079','','591','KG 873 ZT','IBRAHIM','09039409329','DISCHAGE OF PMS',5,'2019-07-19 10:59:21','408','0000-00-00 00:00:00','','2019-07-19 11:01:00','408'),(52802,'1',35240,'72',226,98,'2019-07-23 00:00:00',NULL,13600.00,13600.00,0.00,'15656','','592','KZR 495 XA','ADAMU ZABIA','08102309124','DISCHAGE OF AGO',5,'2019-07-23 17:30:44','408','0000-00-00 00:00:00','','2019-07-26 18:51:14','408'),(54210,'1',35934,'72',226,98,'2019-08-17 00:00:00',NULL,13650.00,13650.00,0.00,'31541','','592','NSR 79 ZQ','AHAMED','08133600024','DISCHAGE OF AGO',5,'2019-08-17 17:41:09','408','0000-00-00 00:00:00','','2019-08-17 17:41:51','408'),(55779,'1',36755,'72',226,98,'2019-09-10 00:00:00',NULL,15850.00,15850.00,0.00,'12345','','592','RAN 509 XA','ALMUNKA','08140106010','DISCHAGE OF AGO',5,'2019-09-10 16:08:02','408','0000-00-00 00:00:00','','2019-09-10 16:09:27','408'),(56406,'1',37290,'72',226,98,'2019-09-20 00:00:00',NULL,25400.00,25400.00,0.00,'12345','','592','TRN 35 XX','SANUSI ABDULLAHI','08036581701','DISCHAGE OF AGO',5,'2019-09-20 10:35:16','408','0000-00-00 00:00:00','','2019-09-20 10:36:18','408'),(60291,'1',39659,'72',226,98,'2019-11-13 00:00:00',NULL,14850.00,14850.00,0.00,'12345','','592','TRN88 YZ','IDRIS ','08132664892','DISCHAGE OF AGO',5,'2019-11-13 11:57:16','408','0000-00-00 00:00:00','','2019-11-13 12:00:40','408'),(62139,'1',40916,'72',226,98,'2019-12-10 00:00:00',NULL,17000.00,17000.00,0.00,'61896','','592','UGG 478 XA','HAMISU  HASSAN','08104374838','DISCHAGE OF AGO',5,'2019-12-10 07:53:46','408','0000-00-00 00:00:00','','2019-12-10 07:55:09','408'),(65707,'1',42934,'72',226,98,'2020-01-24 00:00:00',NULL,15250.00,15250.00,0.00,'12345','','592','RAN 403 XA','ADAMU MUSA','08067781508','DISCHAGE OF AGO',5,'2020-01-24 20:08:34','408','0000-00-00 00:00:00','','2020-01-24 20:09:45','408'),(68172,'1',44259,'72',226,98,'2020-02-28 00:00:00','LAGOS',17500.00,17500.00,0.00,'12345','','592','FGE 49 ZY','SANI ADAMU','08035673042','DISCHAGE OF AGO',5,'2020-02-28 11:23:41','408','0000-00-00 00:00:00','','2020-02-29 20:15:50','408'),(72668,'1',47144,'72',226,98,'2020-05-11 00:00:00','LAGOS',13400.00,13400.00,0.00,'62738','','592','NSL 515 ZY','BABANGIDA','08062246668','DISCHAGE OF AGO',5,'2020-05-11 09:05:16','408','0000-00-00 00:00:00','','2020-05-11 09:06:19','408');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=84586 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
INSERT INTO `sales_payments` VALUES (77724,'1','72','2019-02-19',1427,'','','5',125450.00,'','','','1740','MALUMFASH S/S','214499','2019-02-20 15:04:53',5,'PAYMENT ON ACCOUNT','408','409','2019-02-20 15:45:05','409','2019-02-20 15:45:26'),(77725,'1','72','2019-02-20',1427,'','','5',10000.00,'','','','1740','MALUMFASH S/S','300887','2019-02-20 15:06:34',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-25 17:13:53'),(77727,'1','72','2019-02-19',1386,'','','5',107000.00,'','','','1740','MALUMFASH S/S','198831','2019-02-20 15:11:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 15:52:15'),(77728,'1','72','2019-02-20',1379,'','','5',90000.00,'','','','1740','MALUMFASH S/S','301966','2019-02-20 15:14:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-25 17:13:34'),(77729,'1','72','2019-02-19',1382,'','','5',20000.00,'','','','1740','MALUMFASH S/S','013842','2019-02-20 15:44:44',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-20 15:51:56'),(77751,'1','72','2019-02-20',1385,'','','5',213500.00,'','','','1740','MALUMFASH S/S','237160PA','2019-02-21 15:45:18',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-25 17:15:03'),(77752,'1','72','2019-02-20',1382,'','','5',100000.00,'','','','1740','MALUMFASH S/S','234939','2019-02-21 15:46:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-25 17:14:24'),(77753,'1','72','2019-02-20',1388,'','','5',60000.00,'','','','1740','MALUMFASH S/S','291964','2019-02-21 15:49:13',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-25 17:14:53'),(77754,'1','72','2019-02-20',1424,'','','5',15000.00,'','','','1740','MALUMFASH S/S','233985','2019-02-21 15:50:41',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-25 17:15:25'),(77764,'1','72','2019-02-22',1381,'','','5',20000.00,'','','','1740','MALUMFASH S/S','138643','2019-02-22 14:31:39',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-25 17:17:30'),(77765,'1','72','2019-02-20',1420,'','','5',30000.00,'','','','1740','MALUMFASH S/S','137250','2019-02-22 14:33:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-25 17:17:41'),(77807,'1','72','2019-02-24',1380,'','','5',90000.00,'','','','1740','MALUMFASH S/S','412041','2019-02-25 19:26:10',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:27:14'),(77808,'1','72','2019-02-24',1386,'','','5',75000.00,'','','','1740','MALUMFASH S/S','411827','2019-02-25 19:28:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:27:39'),(77809,'1','72','2019-02-24',1382,'','','5',35000.00,'','','','1740','MALUMFASH S/S','411608','2019-02-25 19:30:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:28:43'),(77810,'1','72','2019-02-24',1381,'','','5',20000.00,'','','','1740','MALUMFASH S/S','410144','2019-02-25 19:32:54',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:29:03'),(77811,'1','72','2019-02-24',1423,'','','5',200000.00,'','','','1740','MALUMFASH S/S','412498','2019-02-25 19:34:44',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-26 17:29:15'),(77864,'1','72','2019-02-26',1380,'','','5',157500.00,'','','','1740','MALUMFASH S/S','207689','2019-02-28 15:57:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:46:48'),(77865,'1','72','2019-02-27',1423,'','','5',26000.00,'','','','1740','MALUMFASH S/S','208219','2019-02-28 15:58:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:46:56'),(77866,'1','72','2019-02-27',1384,'','','5',50000.00,'','','','1740','MALUMFASH S/S','208829','2019-02-28 16:00:27',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:47:01'),(77867,'1','72','2019-02-27',1386,'','','5',20000.00,'','','','1740','MALUMFASH S/S','270674','2019-02-28 16:02:12',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-02-28 16:47:08'),(77900,'1','72','2019-03-01',1382,'','','5',100000.00,'','','','1740','MALUMFASH S/S','376036','2019-03-01 15:38:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-02 16:05:21'),(77901,'1','72','2019-03-01',1425,'','','5',10000.00,'','','','1740','MALUMFASH S/S','377003','2019-03-01 15:40:43',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-02 16:05:30'),(77909,'1','72','2019-03-02',1428,'','','5',112500.00,'','','','1740','MALUMFASH S/S','013842','2019-03-02 11:02:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-05 10:14:08'),(77932,'1','72','2019-03-03',1386,'','','5',50000.00,'','','','1740','MALUMFASH S/S','419876','2019-03-04 16:55:07',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-05 10:14:21'),(77944,'1','72','2019-03-02',1384,'','','5',17000.00,'','','','1740','MALUMFASH S/S','417735','2019-03-05 08:36:08',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-05 10:14:32'),(77951,'1','72','2019-03-04',1386,'','','5',42000.00,'','','','1740','MALUMFASH S/S','244547','2019-03-05 15:16:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-07 16:49:53'),(77964,'1','72','2019-03-05',1427,'','','5',30000.00,'','','','1740','MALUMFASH S/S','233636','2019-03-06 15:22:25',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-07 16:50:05'),(78032,'1','72','2019-03-11',1422,'','','5',80000.00,'','','','1740','MALUMFASH S/S','364839','2019-03-12 17:19:55',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:53:48'),(78033,'1','72','2019-03-11',1383,'','','5',8000.00,'','','','1740','MALUMFASH S/S','364194','2019-03-12 17:21:30',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:54:12'),(78045,'1','72','2019-03-12',1423,'','','5',50000.00,'','','','1740','MALUMFASH S/S','291544','2019-03-13 15:36:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:54:35'),(78046,'1','72','2019-03-12',1386,'','','5',20000.00,'','','','1740','MALUMFASH S/S','290005','2019-03-13 15:38:14',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-13 15:54:44'),(78058,'1','72','2019-03-13',1419,'','','5',25000.00,'','','','1740','MALUMFASH S/S','360569','2019-03-14 16:19:48',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-19 15:48:54'),(78095,'1','72','2019-03-16',1427,'','','5',30000.00,'','','','1740','MALUMFASH S/S','245160','2019-03-18 12:29:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-19 15:49:01'),(78166,'1','72','2019-03-18',1379,'','','5',5000.00,'','','','1740','MALUMFASH S/S','201555','2019-03-20 14:59:15',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-03-26 12:18:58'),(78353,'1','72','2019-03-27',1388,'','','5',30000.00,'','','','1740','MALUMFASH S/S','244059','2019-03-28 14:41:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-12 09:54:59'),(78354,'1','72','2019-03-27',1385,'','','5',15000.00,'','','','1740','MALUMFASH S/S','243010','2019-03-28 14:42:56',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-12 09:55:43'),(78469,'1','72','2019-04-03',1421,'','','5',10000.00,'','','','1740','MALUMFASH S/S','370653','2019-04-05 09:25:31',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-12 09:58:00'),(78470,'1','72','2019-04-03',1386,'','','5',10000.00,'','','','1740','MALUMFASH S/S','371093','2019-04-05 09:26:51',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-12 09:59:44'),(78564,'1','72','2019-04-07',1382,'','','5',70000.00,'','','','1740','MALUMFASH S/S','296203','2019-04-10 12:03:38',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-12 10:10:38'),(78565,'1','72','2019-04-07',1380,'','','5',23200.00,'','','','1740','MALUMFASH S/S','297720','2019-04-10 12:04:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-04-12 10:11:29'),(78678,'1','72','2019-04-17',1388,'','','5',17500.00,'','','','1740','MALUMFASH S/S','181753','2019-04-17 13:15:52',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-06 14:38:16'),(78851,'1','72','2019-04-24',1422,'','','5',31280.00,'','','','1740','MALUMFASH S/S','139528','2019-04-29 10:35:49',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-06 14:38:31'),(79098,'1','72','2019-05-01',1424,'','','5',5000.00,'','','','1740','MALUMFASH S/S','231590','2019-05-08 11:12:53',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-14 13:10:17'),(79099,'1','72','2019-05-01',1422,'','','5',18720.00,'','','','1740','MALUMFASH S/S','232574','2019-05-08 11:14:03',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-16 13:30:06'),(79242,'1','72','2019-05-15',1419,'','','5',10000.00,'','','','1740','MALUMFASH S/S','300876','2019-05-16 15:55:50',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-21 09:35:27'),(79382,'1','72','2019-05-22',1386,'','','5',10000.00,'','','','1740','MALUMFASH S/S','235845','2019-05-24 16:49:33',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-05-27 09:53:54'),(79720,'1','72','2019-06-15',1388,'','','5',8000.00,'','','','1740','Malumfashi','201737','2019-06-20 21:02:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-06-21 11:03:23'),(79862,'1','72','2019-06-19',1382,'','','5',22900.00,'','','','1740','Malumfashi','76231','2019-06-30 10:44:46',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:03:58'),(79863,'1','72','2019-06-25',1420,'','','5',15000.00,'','','','1740','Malumfashi','213643','2019-06-30 10:45:57',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:04:10'),(79864,'1','72','2019-06-25',1421,'','','5',5000.00,'','','','1740','Malumfashi','211596','2019-06-30 10:48:21',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-07-01 11:04:20'),(80571,'1','72','2019-07-17',1382,'','','5',28000.00,'','','','1740','Malumfashi','93319','2019-07-23 17:15:24',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-09-12 13:11:38'),(81561,'1','72','2019-09-22',1380,'','','5',20000.00,'','','','1740','Malumfashi','273272','2019-09-24 19:50:11',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-10-07 10:07:43'),(81885,'1','72','2019-10-10',1386,'','','5',8750.00,'','','','1740','Malumfashi','142916','2019-10-13 19:49:40',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:49:57'),(82394,'1','72','2019-11-12',1388,'','','5',156830.00,'','','','1740','Malumfashi','12345','2019-11-12 18:01:37',0,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82395,'1','72','2019-11-12',1427,'','','5',77400.00,'','','','1740','Malumfashi','445531','2019-11-12 18:03:05',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:50:38'),(82398,'1','72','2019-11-12',1387,'','','5',110000.00,'','','','1740','Malumfashi','444459','2019-11-12 18:04:30',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:51:19'),(82597,'1','72','2019-11-26',1418,'','','5',5000.00,'','','','1740','Malumfashi','253223','2019-11-27 18:37:00',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','409','2019-12-17 15:51:22'),(83064,'1','72','2019-12-18',1421,'','','5',10000.00,'','','','1740','Malumfashi','247038','2019-12-19 18:07:28',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:50:42'),(84583,'1','72','2020-03-09',1382,'','','5',30300.00,'','','','1740','Malumfashi','273459','2020-03-10 14:41:32',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:50:09'),(84585,'1','72','2020-03-09',1380,'','','5',10000.00,'','','','1740','Malumfashi','295935','2020-03-10 14:42:48',5,'PAYMENT ON ACCOUNT','408','','0000-00-00 00:00:00','125','2020-05-18 12:50:30');
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (98,'1','72','A.A Rano Nigeria Limited','MR Moo','+2348035450199','akaksus@gmail.com','Kano','Kano State','No7 A.A Rano House Hotoro, Opposite NNPC Depot Kano State.','Nigeria',0.00,0.00,'0000-00-00','2018-11-05 16:24:48',5,'404','2018-11-05 16:24:48','404');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:55:27
