-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_65
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_65`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_65` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_65`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3951 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1078,2010,'',0,'24','1','65','PURCHASES','','2017-04-25 10:55:35',5,0.00,0.00,'','134','2017-04-25 12:06:58','134',0,1),(1079,2030,'',0,'6.1','1','65','CASH','','2017-04-25 10:56:08',5,0.00,0.00,'','134','2017-04-25 12:35:38','134',0,1),(1080,2028,'',0,'20','1','65','SALES','','2017-04-25 10:56:36',5,0.00,0.00,'2017-04-25','134','2017-04-25 12:35:01','134',0,1),(1081,2012,'',0,'24','1','65','WEIGHT AND MEASURE','','2017-04-25 10:57:01',5,0.00,0.00,'','134','2017-04-25 12:08:23','134',0,1),(1082,2032,'',0,'2','1','65','FBN 2023855223','','2017-04-25 11:18:55',5,0.00,0.00,'','134','2017-04-25 12:39:20','134',0,1),(1083,2011,'',0,'24','1','65','AGO CONSUMPTION','','2017-04-25 12:09:17',5,0.00,0.00,'','134','2017-04-25 12:10:03','134',0,1),(1084,2013,'',0,'24','1','65','ELECTRICITY AND WATER BILLS','','2017-04-25 12:11:11',5,0.00,0.00,'','134','2017-04-25 12:11:11','134',0,1),(1085,2014,'',0,'24','1','65','FUELING AND REPAIR OF OFFICIAL','','2017-04-25 12:12:24',5,0.00,0.00,'','134','2017-04-25 12:12:24','134',0,1),(1086,2015,'',0,'24','1','65','PRITING AND STATIONARY','','2017-04-25 12:13:09',5,0.00,0.00,'','134','2017-04-25 12:13:09','134',0,1),(1087,2016,'',0,'24','1','65','PUMP REPAIRS AND GENERATOR','','2017-04-25 12:14:18',5,0.00,0.00,'','134','2017-04-25 12:14:18','134',0,1),(1088,2017,'',0,'24','1','65','STATION REPAIRS AND MAINTENANC','','2017-04-25 12:15:58',5,0.00,0.00,'','134','2017-04-25 12:15:58','134',0,1),(1089,2018,'',0,'24','1','65','PUBLIC RELATION','','2017-04-25 12:16:42',5,0.00,0.00,'','134','2017-04-25 12:16:42','134',0,1),(1090,2019,'',0,'24','1','65','COMPUTER AND ITERNET SUB','','2017-04-25 12:18:11',5,0.00,0.00,'','134','2017-04-25 12:18:11','134',0,1),(1091,2020,'',0,'24','1','65','DISCOUNT ALLOWED','','2017-04-25 12:19:05',5,0.00,0.00,'','134','2017-04-25 12:19:05','134',0,1),(1092,2021,'',0,'24','1','65','Administrative Expenses','','2017-04-25 12:22:09',5,0.00,0.00,'2018-07-17','134','2018-07-17 07:13:26','298',0,1),(1093,2022,'',0,'24','1','65','TRANSPORT FARE','','2017-04-25 12:23:12',5,0.00,0.00,'','134','2017-04-25 12:23:12','134',0,1),(1094,2023,'',0,'24','1','65','OTHER OPERATING EXPENSES','','2017-04-25 12:24:30',5,0.00,0.00,'','134','2017-04-25 12:24:30','134',0,1),(1095,2024,'',0,'24','1','65','STAFF RENT','','2017-04-25 12:25:23',5,0.00,0.00,'','134','2017-04-25 12:25:23','134',0,1),(1096,2035,'1092',1,'24','1','65','STAFF TRAINING AND ACCOMODATIO','','2017-04-25 12:28:47',5,0.00,0.00,'2018-07-18','134','2018-07-17 07:18:29','298',0,1),(1097,2026,'',0,'24','1','65','MEDICAL EXPENSES','','2017-04-25 12:31:56',5,0.00,0.00,'','134','2017-04-25 12:31:56','134',0,1),(1098,2027,'',0,'24','1','65','CLEANING AND SANITARY ITEMS','','2017-04-25 12:33:16',5,0.00,0.00,'','134','2017-04-25 12:33:16','134',0,1),(1099,2029,'',0,'2','1','65','ZENITH BANK 1011595101 SURPLUS','','2017-04-25 12:37:02',5,0.00,0.00,'','134','2017-04-25 12:37:02','134',0,1),(1100,2031,'',0,'5','1','65','INVENTORY VALUE ADJUSTMENT','','2017-04-25 12:38:28',5,0.00,0.00,'','134','2017-04-25 12:38:28','134',0,1),(1101,2025,'',0,'2','1','65','BANK  & CHARGES(CASH HANDLING)','','2017-04-26 11:48:53',5,0.00,0.00,'','134','2017-04-26 11:48:53','134',0,1),(1102,2030,'',0,'24','1','65','BANK  CHARGES(CASH HANDLING)','','2017-04-26 11:56:15',5,0.00,0.00,'','134','2017-04-26 11:56:15','134',0,1),(1591,3007,'',0,'2','1','65','TOTAL APPROVED EXPENSES','','2018-06-04 16:39:11',5,0.00,0.00,'','298','2018-06-04 16:39:11','298',0,1),(1624,3009,'1092',1,'24','1','65','Salaries & Wages','','2018-07-17 07:14:41',5,0.00,0.00,'','298','2018-07-17 07:14:41','298',0,1),(2872,400295,'',0,'2','1','65','E-BILL COLLECTION ACCOUNT','','2020-10-16 14:12:04',5,0.00,0.00,'','426','2020-10-16 14:12:04','426',0,1),(2873,400296,'',0,'2','1','65','UNITY BANK 0029983625','','2020-10-16 14:12:46',5,0.00,0.00,'','426','2020-10-16 14:12:46','426',0,1),(2874,40034,'',0,'6.1','1','65','CASH IMPRESS','','2020-10-18 15:27:25',5,0.00,0.00,'','426','2020-10-18 15:27:25','426',0,1),(3061,400427,'',0,'2','1','65','TRSP ACCT 1017823264','','2020-12-15 09:52:17',5,0.00,0.00,'','426','2020-12-15 09:52:17','426',0,1),(3193,400472,'',0,'2','1','65','POS ZENITH','','2021-02-23 10:59:00',5,0.00,0.00,'','426','2021-02-23 10:59:00','426',0,1),(3702,400652,'',0,'2','1','65','KEYSTONE SURPLUS','','2021-10-07 11:40:17',5,0.00,0.00,'','202','2021-10-07 11:40:17','202',0,1),(3703,400653,'',0,'2','1','65','ZENITH 1017823264','','2021-10-07 11:45:00',5,0.00,0.00,'','202','2021-10-07 11:45:00','202',0,1),(3894,40003,'',0,'2','1','65','CASH IMPREST','','2021-11-29 11:45:01',5,0.00,0.00,'','202','2022-04-05 14:50:40','202',0,0),(3948,40049,'',0,'6','1','65','CUSTOMER BALANCES','','2021-12-03 12:51:46',5,0.00,0.00,'','202','2021-12-03 12:51:46','202',0,0),(3949,2031,'',0,'24','1','65','RETAILS OPERATING EXPENSES','','2022-04-05 14:50:50',5,0.00,0.00,'','202','2022-04-05 14:50:50','202',0,0),(3950,400654,'',0,'2','1','65','ZENITH 1014717261','','2023-01-04 16:46:55',5,0.00,0.00,'','202','2023-01-04 16:46:55','202',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82491 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (80297,'1','65','0000-00-00','2021-09-29 18:21:35',10,'178','','0000-00-00 00:00:00','178','2021-09-30 16:28:22'),(80306,'1','65','0000-00-00','2021-09-30 16:31:08',10,'178','','0000-00-00 00:00:00','178','2021-09-30 16:32:36'),(80307,'1','65','0000-00-00','2021-09-30 16:42:09',10,'178','','0000-00-00 00:00:00','178','2021-09-30 16:43:25'),(80496,'1','65','0000-00-00','2021-10-16 10:41:24',10,'548','','0000-00-00 00:00:00','202','2021-10-18 10:19:10'),(80497,'1','65','0000-00-00','2021-10-16 10:42:54',10,'548','','0000-00-00 00:00:00','202','2021-10-18 10:19:16'),(80498,'1','65','0000-00-00','2021-10-16 10:44:16',10,'548','','0000-00-00 00:00:00','202','2021-10-18 10:19:22'),(81888,'1','65','0000-00-00','2021-12-03 12:51:00',10,'202','','0000-00-00 00:00:00','202','2021-12-03 13:03:11'),(81889,'1','65','0000-00-00','2021-12-03 12:53:46',10,'202','','0000-00-00 00:00:00','202','2021-12-03 13:03:11'),(81890,'1','65','0000-00-00','2021-12-03 12:55:56',10,'202','','0000-00-00 00:00:00','202','2021-12-03 13:03:11'),(81891,'1','65','0000-00-00','2021-12-03 12:56:53',10,'202','','0000-00-00 00:00:00','202','2021-12-03 13:03:11'),(81892,'1','65','0000-00-00','2021-12-03 12:59:02',10,'202','','0000-00-00 00:00:00','202','2021-12-03 13:03:11'),(81893,'1','65','0000-00-00','2021-12-03 13:00:20',10,'202','','0000-00-00 00:00:00','202','2021-12-03 13:03:11'),(81894,'1','65','0000-00-00','2021-12-03 13:01:31',10,'202','','0000-00-00 00:00:00','202','2021-12-03 13:03:11'),(82174,'1','65','0000-00-00','2021-12-29 20:22:57',10,'548','','0000-00-00 00:00:00','202','2022-01-10 14:26:14'),(82231,'1','65','0000-00-00','2022-01-10 16:01:14',10,'548','','0000-00-00 00:00:00','202','2022-01-11 10:24:26'),(82393,'1','65','0000-00-00','2022-01-24 12:57:05',10,'548','','0000-00-00 00:00:00','202','2022-02-03 12:34:25'),(82409,'1','65','0000-00-00','2022-01-25 12:10:28',10,'548','','0000-00-00 00:00:00','202','2022-02-03 12:34:32'),(82433,'1','65','0000-00-00','2022-01-26 17:35:22',10,'548','','0000-00-00 00:00:00','202','2022-02-03 12:34:36'),(82456,'1','65','0000-00-00','2022-01-28 10:34:51',10,'548','','0000-00-00 00:00:00','202','2022-02-03 12:34:40'),(82457,'1','65','0000-00-00','2022-02-02 14:22:43',10,'548','','0000-00-00 00:00:00','202','2022-02-03 12:34:09'),(82458,'1','65','0000-00-00','2022-02-04 16:59:06',10,'548','','0000-00-00 00:00:00','202','2022-02-24 12:19:30'),(82459,'1','65','0000-00-00','2022-02-08 17:41:52',10,'548','','0000-00-00 00:00:00','202','2022-02-24 12:19:25'),(82460,'1','65','0000-00-00','2022-02-09 16:19:00',10,'548','','0000-00-00 00:00:00','202','2022-02-10 12:42:59'),(82461,'1','65','0000-00-00','2022-02-12 16:06:45',10,'548','','0000-00-00 00:00:00','202','2022-02-24 12:19:21'),(82462,'1','65','0000-00-00','2022-02-16 13:52:03',10,'548','','0000-00-00 00:00:00','202','2022-02-24 12:19:16'),(82463,'1','65','0000-00-00','2022-02-23 15:35:34',10,'548','','0000-00-00 00:00:00','202','2022-02-24 12:19:01'),(82464,'1','65','0000-00-00','2022-03-04 17:33:36',10,'548','','0000-00-00 00:00:00','202','2022-03-08 15:49:52'),(82465,'1','65','0000-00-00','2022-03-05 17:47:58',10,'548','','0000-00-00 00:00:00','202','2022-03-08 15:50:01'),(82466,'1','65','0000-00-00','2022-03-06 20:24:28',10,'548','','0000-00-00 00:00:00','202','2022-03-08 15:49:45'),(82467,'1','65','0000-00-00','2022-03-08 17:47:14',10,'548','','0000-00-00 00:00:00','202','2022-03-14 12:03:49'),(82468,'1','65','0000-00-00','2022-03-13 20:11:42',10,'548','','0000-00-00 00:00:00','202','2022-03-14 12:03:07'),(82469,'1','65','0000-00-00','2022-03-14 17:44:01',10,'548','','0000-00-00 00:00:00','202','2022-03-28 11:30:53'),(82470,'1','65','0000-00-00','2022-03-17 20:12:07',10,'548','','0000-00-00 00:00:00','202','2022-03-28 11:30:49'),(82471,'1','65','0000-00-00','2022-04-03 11:10:02',10,'548','','0000-00-00 00:00:00','202','2022-04-04 12:07:07'),(82472,'1','65','0000-00-00','2022-04-09 14:45:35',10,'548','','0000-00-00 00:00:00','202','2022-04-11 11:21:45'),(82473,'1','65','0000-00-00','2022-04-16 13:41:38',10,'548','','0000-00-00 00:00:00','202','2022-04-18 11:44:19'),(82474,'1','65','0000-00-00','2022-09-03 07:17:40',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82475,'1','65','0000-00-00','2022-09-09 14:31:05',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82476,'1','65','0000-00-00','2022-09-16 15:05:18',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82477,'1','65','0000-00-00','2022-09-24 11:00:48',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82478,'1','65','0000-00-00','2022-10-07 10:41:24',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82479,'1','65','0000-00-00','2022-10-07 10:45:56',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82480,'1','65','0000-00-00','2023-01-05 07:04:23',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82481,'1','65','0000-00-00','2023-01-05 07:09:53',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82482,'1','65','0000-00-00','2023-01-12 13:53:30',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82483,'1','65','0000-00-00','2023-01-18 19:01:18',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82484,'1','65','0000-00-00','2023-01-19 07:31:23',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82485,'1','65','0000-00-00','2023-01-26 09:46:12',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82486,'1','65','0000-00-00','2023-01-31 08:42:42',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82487,'1','65','0000-00-00','2023-02-01 20:16:35',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82488,'1','65','0000-00-00','2023-02-21 19:02:52',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82489,'1','65','0000-00-00','2023-02-23 20:23:56',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82490,'1','65','0000-00-00','2023-03-01 21:25:00',5,'548','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=174686 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (169070,'1','65','80297','81','supplier',53154815.00,'Old Balance written off due to Migration to FSM',0.00,'2021-09-24'),(169088,'1','65','80297','1080','20',0.00,' 	Old Balance written off due to Migration to FSM',53154815.00,'2021-09-30'),(169089,'1','65','80306','80','supplier',0.00,'Old Balance written off due to Migration to FSM',39692041.00,'2021-09-28'),(169090,'1','65','80306','1080','20',39692041.00,'Old Balance written off due to Migration to FSM',0.00,'2021-09-28'),(169091,'1','65','80307','80','supplier',11028375.00,'Balance b/f as at 26/09/2021 (Analysis 11,401,538.00)',0.00,'2021-09-29'),(169092,'1','65','80307','1080','20',0.00,'Balance b/f as at 26/09/2021 (Analysis 11,401,538.00)',11028375.00,'2021-09-29'),(169530,'1','65','80496','80','supplier',0.00,'AGO CONSUMPTION 1W5@310',38750.00,'2021-10-01'),(169531,'1','65','80496','1083','24',38750.00,'AGO CONSUMPTION 125@310',0.00,'2021-10-01'),(169532,'1','65','80497','80','supplier',0.00,'AGO CONSUMPTION 125@320',40000.00,'2021-10-09'),(169533,'1','65','80497','1083','24',40000.00,'AGO CONSUMPTION 125@320',0.00,'2021-10-09'),(169534,'1','65','80498','80','supplier',0.00,'AGO CONSUMPTION 125 @330',41250.00,'2021-10-15'),(169535,'1','65','80498','1083','24',41250.00,'AGO CONSUMPTION 125@330',0.00,'2021-10-15'),(172787,'1','65','81888','792','customer',0.00,'Balance transfer to customer account, Nill off',2445000.00,'2021-12-03'),(172788,'1','65','81888','3948','6',2445000.00,'Balance transfer from ALH ADO POTISKUM	 customer account, Nill off',0.00,'2021-12-03'),(172790,'1','65','81889','835','customer',0.00,'Balance transfer to customer account, Nill off',2095000.00,'2021-12-03'),(172791,'1','65','81889','3948','6',2095000.00,'Balance transfer from ALH HABU	 customer account, Nill off',0.00,'2021-12-03'),(172792,'1','65','81890','836','customer',0.00,'Balance transfer to customer account, Nill off',6450.00,'2021-12-03'),(172793,'1','65','81890','3948','6',6450.00,'Balance transfer from alh nasiru	 customer account, Nill off',0.00,'2021-12-03'),(172794,'1','65','81891','808','customer',0.00,'Balance transfer to customer account, Nill off',95000.00,'2021-12-03'),(172795,'1','65','81891','3948','6',95000.00,'Balance transfer from ALH.BABAJI	 customer account, Nill off',0.00,'2021-12-03'),(172796,'1','65','81892','794','customer',0.00,'Balance transfer to customer account, Nill off',15000.00,'2021-12-03'),(172797,'1','65','81892','3948','6',15000.00,'Balance transfer from IBAL SERVICE STATION	 customer account, Nill off',0.00,'2021-12-03'),(172798,'1','65','81893','1957','customer',1696404.40,'Balance transfer to customer account, pending reconciliation',0.00,'2021-12-03'),(172799,'1','65','81893','3948','6',0.00,'Balance transfer from MB TECH GLOBAL	 customer account, pending reconciliation',1696404.40,'2021-12-03'),(172800,'1','65','81894','827','customer',28725946.55,'Balance transfer to customer account, pending reconciliation',0.00,'2021-12-03'),(172801,'1','65','81894','3948','6',0.00,'Balance transfer from UB COMPANY NIG LTD	 customer account, pending reconciliation',28725946.55,'2021-12-03'),(173502,'1','65','82174','80','supplier',0.00,'AGO CONSUMPTION 125 @350',43750.00,'2021-12-25'),(173503,'1','65','82174','1083','24',43750.00,'AGO CONSUMPTION 125 @350',0.00,'2021-12-25'),(173670,'1','65','82231','1083','24',43750.00,'Ago comsuption 125@350',0.00,'2022-01-09'),(173671,'1','65','82231','80','supplier',0.00,'Ago comsuption 125@350',43750.00,'2022-01-09'),(174334,'1','65','82393','1100','5',0.00,'Change of price from 350 to 355',93500.00,'2022-01-21'),(174335,'1','65','82393','80','supplier',93500.00,'Change of price from 350 to 355',0.00,'2022-01-21'),(174380,'1','65','82409','1100','5',0.00,'Change of price from 355 to 360  ',70000.00,'2022-01-25'),(174381,'1','65','82409','80','supplier',70000.00,'Change of price from 355 to 360  ',0.00,'2022-01-25'),(174437,'1','65','82433','1083','24',45000.00,'Ago comsuption 125@360',0.00,'2022-01-26'),(174438,'1','65','82433','80','supplier',0.00,'Ago comsuption 125@360',45000.00,'2022-01-26'),(174613,'1','65','82456','1100','5',0.00,'Change of price from 360  to 365  ',43000.00,'2022-01-28'),(174614,'1','65','82456','80','supplier',43000.00,'Change of price from 360  to 365',0.00,'2022-01-28'),(174615,'1','65','82457','1083','24',45625.00,'Ago consumption 125 ltrs @365',0.00,'2022-02-02'),(174616,'1','65','82457','80','supplier',0.00,'Ago consumption 125 ltrs @365',45625.00,'2022-02-02'),(174617,'1','65','82458','1100','5',0.00,'Change of price from 365 to 380 different 15',306000.00,'2022-02-04'),(174618,'1','65','82458','80','supplier',306000.00,'Change of price from 365 to 380 different 15',0.00,'2022-02-04'),(174619,'1','65','82459','1100','5',0.00,'Change of price from 380 to 390 different 10',173500.00,'2022-02-08'),(174622,'1','65','82459','80','supplier',173500.00,'Change of price from 380 to 390 different 10',0.00,'2022-02-08'),(174623,'1','65','82460','1083','24',48750.00,'Ago consumption 125 ltrs @390',0.00,'2022-02-09'),(174624,'1','65','82460','80','supplier',0.00,'Ago consumption 125 ltrs @390',48750.00,'2022-02-09'),(174625,'1','65','82461','1100','5',0.00,'Change of price from 390 to 410 different 20',240000.00,'2022-02-12'),(174626,'1','65','82461','80','supplier',240000.00,'Change of price from 390 to 410 different 20',0.00,'2022-02-12'),(174627,'1','65','82462','1083','24',51250.00,'Ago consumption 125 ltrs @410',0.00,'2022-02-16'),(174628,'1','65','82462','80','supplier',0.00,'Ago consumption 125 ltrs @410',51250.00,'2022-02-16'),(174629,'1','65','82463','1083','24',36900.00,'Ago consumption 90 ltrs @410',0.00,'2022-02-23'),(174630,'1','65','82463','80','supplier',0.00,'Ago consumption 90 ltrs @410',36900.00,'2022-02-23'),(174631,'1','65','82464','1100','5',0.00,'Change of price from 430 to 460 different 30',574500.00,'2022-03-04'),(174632,'1','65','82464','80','supplier',574500.00,'Change of price from 430 to 460 different 30',0.00,'2022-03-04'),(174633,'1','65','82465','1100','5',0.00,'Change of price from 460 to 500 different 40',618000.00,'2022-03-05'),(174634,'1','65','82465','80','supplier',618000.00,'Change of price from 460 to 500 different 40',0.00,'2022-03-05'),(174635,'1','65','82466','1083','24',45000.00,'Ago consumption 90 ltrs @500',0.00,'2022-03-06'),(174636,'1','65','82466','80','supplier',0.00,'Ago consumption 90 ltrs @500',45000.00,'2022-03-06'),(174637,'1','65','82467','1100','5',0.00,'Change of price from 500 to 600 different 100',1265000.00,'2022-03-08'),(174638,'1','65','82467','80','supplier',1265000.00,'Change of price from 500 to 600 different 100',0.00,'2022-03-08'),(174639,'1','65','82468','1083','24',54000.00,'Ago consumption 90 ltrs @600',0.00,'2022-03-13'),(174640,'1','65','82468','80','supplier',0.00,'Ago consumption 90 ltrs @600',54000.00,'2022-03-13'),(174641,'1','65','82469','1100','5',0.00,'Change of price from 600 to 650 different 50',392500.00,'2022-03-14'),(174642,'1','65','82469','80','supplier',392500.00,'Change of price from 600 to 650 different 50',0.00,'2022-03-14'),(174644,'1','65','82470','1083','24',63000.00,'Ago consumption 90 ltrs @700',0.00,'2022-03-27'),(174645,'1','65','82470','80','supplier',0.00,'Ago consumption 90 ltrs @700',63000.00,'2022-03-27'),(174646,'1','65','82471','1083','24',63000.00,'Ago consumption 90 ltrs @700',0.00,'2022-04-02'),(174647,'1','65','82471','80','supplier',0.00,'Ago consumption 90 ltrs @700',63000.00,'2022-04-02'),(174648,'1','65','82472','1083','24',63000.00,'Ago consumption 90 ltrs @700',0.00,'2022-04-09'),(174649,'1','65','82472','80','supplier',0.00,'Ago consumption 90 ltrs @700',63000.00,'2022-04-09'),(174650,'1','65','82473','1083','24',63000.00,'Ago consumption 90 ltrs @700',0.00,'2022-04-16'),(174651,'1','65','82473','80','supplier',0.00,'Ago consumption 90 ltrs @700',63000.00,'2022-04-16'),(174652,'1','65','82474','1083','24',80000.00,'Ago consumption  100 ltrs @800',0.00,'2022-09-02'),(174653,'1','65','82474','80','supplier',0.00,'Ago consumption 100 ltrs @800',80000.00,'2022-09-02'),(174654,'1','65','82475','1083','24',80000.00,'Ago consumption 100 ltrs @800',0.00,'2022-09-09'),(174655,'1','65','82475','80','supplier',0.00,'Ago consumption 100 ltrs @800',80000.00,'2022-09-09'),(174656,'1','65','82476','1083','24',80000.00,'Ago consumption 100 ltrs @800',0.00,'2022-09-16'),(174657,'1','65','82476','80','supplier',0.00,'Ago consumption 100 ltrs @800',80000.00,'2022-09-16'),(174658,'1','65','82477','1083','24',80000.00,'Ago consumption 100 ltrs @800',0.00,'2022-09-23'),(174659,'1','65','82477','80','supplier',0.00,'Ago consumption 100 ltrs @800',80000.00,'2022-09-23'),(174660,'1','65','82478','1100','5',145000.00,'Change of price from 810 to 800 difference 10',0.00,'2022-09-01'),(174661,'1','65','82478','80','supplier',0.00,'Change of price from 810 to 800 difference 10',145000.00,'2022-09-01'),(174662,'1','65','82479','1100','5',0.00,'Change of price from 800 to 815 difference 15',9000.00,'2022-09-29'),(174663,'1','65','82479','80','supplier',9000.00,'Change of price from 800 to 815 difference 15',0.00,'2022-09-29'),(174664,'1','65','82480','1083','24',80100.00,'Ago consumption 90 ltrs @900',0.00,'2023-01-04'),(174665,'1','65','82480','80','supplier',0.00,'Ago consumption 90 ltrs @900',80100.00,'2023-01-04'),(174666,'1','65','82481','1100','5',0.00,'Change of price from 890 to 900 difference 10',198500.00,'2023-01-05'),(174667,'1','65','82481','80','supplier',198500.00,'CHANGE OF PRICE FROM 890 TO 900 DIFFERENCE 10',0.00,'2023-01-05'),(174668,'1','65','82482','1083','24',72000.00,'Ago consumption 80 LTRs @900',0.00,'2023-01-11'),(174669,'1','65','82482','80','supplier',0.00,'Ago consumption 80 ltrs @900',72000.00,'2023-01-11'),(174670,'1','65','82483','1100','5',274000.00,'Change of price from 900 to 880 difference 20',0.00,'2023-01-17'),(174671,'1','65','82483','80','supplier',0.00,'Change of price from 900 to 880 different 20',274000.00,'2023-01-17'),(174672,'1','65','82484','1083','24',79200.00,'Ago consumption 90 ltrs @880',0.00,'2023-01-18'),(174673,'1','65','82484','80','supplier',0.00,'Ago consumption 90 ltrs @880',79200.00,'2023-01-18'),(174674,'1','65','82485','1083','24',79200.00,'Ago consumption 90 ltrs @880',0.00,'2023-01-25'),(174675,'1','65','82485','80','supplier',0.00,'Ago consumption 90 ltrs @880',79200.00,'2023-01-25'),(174676,'1','65','82486','1100','5',263000.00,'Change of price from 880 to 860 difference 20',0.00,'2023-01-30'),(174677,'1','65','82486','80','supplier',0.00,'Change of price from 880 to 860 difference 20',263000.00,'2023-01-30'),(174678,'1','65','82487','1083','24',77400.00,'Ago consumption 90 ltrs @860',0.00,'2023-02-01'),(174679,'1','65','82487','80','supplier',0.00,'Ago consumption 90 ltrs @860',77400.00,'2023-02-01'),(174680,'1','65','82488','1100','5',145500.00,'Change of price from 860 to 850 difference 10',0.00,'2023-02-21'),(174681,'1','65','82488','80','supplier',0.00,'Change of price from 860 to 850 difference 10',145500.00,'2023-02-21'),(174682,'1','65','82489','1100','5',275000.00,'Change of price from 850 to 830 DIFFERENCE 20',0.00,'2023-02-23'),(174683,'1','65','82489','80','supplier',0.00,'Change of price from 850 to 830 difference 20',275000.00,'2023-02-23'),(174684,'1','65','82490','1083','24',74700.00,'AGO FOR GEN 90@830',0.00,'2023-03-01'),(174685,'1','65','82490','80','supplier',0.00,'AGO FOR GEN 90@830',74700.00,'2023-03-01');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
INSERT INTO `attendants` VALUES ('1','65',85,'Ibrahim','Audu','Audu','7448221279','ak@yahoo.com','353 Wickham Lane, Abbey Wood','London','London','United Kingdom','Audu Ibrahim','07448221279','','',0,5,'0000-00-00 00:00:00','2017-07-02 14:44:19','134','2017-07-02 14:44:19','134');
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3300 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (792,'','1','65','ALH ADO POTISKUM','','','','POTISKUM','YOBE','','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-25 11:08:10',5,'134','2017-04-25 11:08:10','134'),(794,'','1','65','IBAL SERVICE STATION','','','','PATISKUM','YOBE ','','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-25 12:05:49',5,'134','2017-04-25 12:05:49','134'),(796,'','1','65','HAULAGE SERVICES','','','','KANO','KANO','','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-25 15:49:56',0,'134','2017-04-25 15:49:56','134'),(797,'','1','65','ATP','','','','KANO','KANO','','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-25 15:50:21',0,'134','2017-04-25 15:50:21','134'),(808,'','1','65','ALH.BABAJI','SANI','09066728526','','JALINGO','JALINGO','DUWALA JALINGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 11:10:27',5,'134','2017-04-27 11:10:27','134'),(809,'','1','65','GOV,T.HOUSE','ADAMU ADA','08039681475','','BAUCHI','BAUCHI','BAUCHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 11:18:24',0,'134','2017-04-27 11:18:24','134'),(810,'','1','65','alh bala','08036057188','08036057188','','jos','plateau','jos','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 11:23:10',0,'134','2017-04-27 11:23:10','134'),(811,'','1','65','AIRPORT BAUCHI','ALH ABDULHAMID','08035664252','','BAUCHI','BAUCHI','AIRPORT BAUCHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 11:32:52',0,'134','2017-04-27 11:32:52','134'),(825,'','1','65','karama motors','IBRAHIM BAFFA ','08174747474','','jos','','jos uplata','Nigeria',1500000.00,0.00,0.00,'0000-00-00','2017-04-27 14:19:09',0,'134','2017-04-27 14:19:09','134'),(826,'','1','65','A.POLICE','A.P0LICE','08084273952','','JALINGO','JALINGO','JALINGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 14:19:36',0,'134','2017-04-27 14:19:36','134'),(827,'','1','65','UB COMPANY NIG LTD','DADI','08104323089','','ADAMAWA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 14:20:59',5,'134','2017-04-27 14:20:59','134'),(834,'','1','65','ALHERI BREAD','DAN MALIKI','08067582976','','BAUCHI','BAUCHI','GADAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 14:53:46',0,'134','2017-04-27 14:53:46','134'),(835,'','1','65','ALH HABU','USMAN MUSA','08065641710','','KANO','','BAUCHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 15:07:50',5,'134','2017-04-27 15:07:50','134'),(836,'','1','65','alh nasiru','sani rano','070345526789','','kano','kano','kano','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-27 15:14:02',5,'134','2017-04-27 15:14:02','134'),(1957,'','1','65','MB TECH GLOBAL','MB TECH','0806693020','mbteachconcom@gmail.com','KANO','KANO','PLOT C 13 BUK NEW SITE GWARZO ROAD KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-01-05 10:12:32',5,'426','2021-01-05 10:12:32','426'),(3298,'','1','65','DRIVER SHORTAGE','UMAR TRANSPORT','08030647174','@gmail.com','kano','Kano','KANO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-09-17 08:23:18',5,'202','2021-09-17 08:23:18','202'),(3299,'','1','65','NIGERIA POLICE FORCE(ELECTION)','CP YUSUF ','08071785115','dopstransport@gmail.com','FCT','Abuja','NPF HEADQUARTER ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-22 09:40:36',5,'974','2023-02-22 09:40:36','974');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2376 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (469,'1','65','792',0,'TEMPORARY CLOSURE','2021-07-09 15:44:07'),(470,'1','65','794',0,'TEMPORARY CLOSURE','2021-07-09 15:44:14'),(471,'1','65','796',0,'TEMPORARY CLOSURE','2021-07-09 15:44:21'),(472,'1','65','797',0,'TEMPORARY CLOSURE','2021-07-09 15:44:30'),(473,'1','65','808',0,'TEMPORARY CLOSURE','2021-07-09 15:44:38'),(474,'1','65','809',0,'TEMPORARY CLOSURE','2021-07-09 15:44:47'),(475,'1','65','810',0,'TEMPORARY CLOSURE','2021-07-09 15:44:56'),(476,'1','65','811',0,'TEMPORARY CLOSURE','2021-07-09 15:45:04'),(477,'1','65','825',0,'TEMPORARY CLOSURE','2021-07-09 15:45:13'),(478,'1','65','826',0,'TEMPORARY CLOSURE','2021-07-09 15:45:22'),(479,'1','65','827',0,'TEMPORARY CLOSURE','2021-07-09 15:45:31'),(480,'1','65','827',5,'Active','2021-07-09 15:45:47'),(481,'1','65','834',0,'TEMPORARY CLOSURE','2021-07-09 15:45:57'),(482,'1','65','835',0,'TEMPORARY CLOSURE','2021-07-09 15:46:12'),(483,'1','65','836',0,'TEMPORARY CLOSURE','2021-07-09 15:46:21'),(484,'1','65','1957',0,'TEMPORARY CLOSURE','2021-07-09 15:46:29'),(488,'1','65','827',0,'TEMPORARY CLOSURE','2021-07-29 10:59:51'),(489,'1','65','827',5,'Active','2021-07-29 11:53:54'),(490,'1','65','827',0,'TEMPORARY CLOSURE','2021-07-30 11:10:59'),(2369,'1','65','792',5,'ACTIVE FOR RECONCILIATION PURPOSE','2021-12-03 12:46:21'),(2370,'1','65','1957',5,'ACTIVE FOR RECONCILIATION PURPOSE','2021-12-03 12:46:32'),(2371,'1','65','836',5,'ACTIVE FOR RECONCILIATION PURPOSE','2021-12-03 12:46:47'),(2372,'1','65','835',5,'ACTIVE FOR RECONCILIATION PURPOSE','2021-12-03 12:47:04'),(2373,'1','65','827',5,'ACTIVE FOR RECONCILIATION PURPOSE','2021-12-03 12:47:17'),(2374,'1','65','808',5,'ACTIVE FOR RECONCILIATION PURPOSE','2021-12-03 12:50:15'),(2375,'1','65','794',5,'ACTIVE FOR RECONCILIATION PURPOSE','2021-12-03 12:50:32');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18468 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','65',17307,'420',4748.16,100.00,'2021-10-30','','2021-10-30 14:49:43','202','202',2021,'202','2021-10-30 14:49:43',5),('1','65',17308,'421',0.00,100.00,'2021-10-30','','2021-10-30 14:50:01','202','202',2021,'202','2021-10-30 14:50:01',5),('1','65',17309,'422',0.00,5.00,'2021-10-30','','2021-10-30 14:50:15','202','202',2021,'202','2021-10-30 14:50:15',5),('1','65',17310,'423',24944.90,200.00,'2021-10-30','','2021-10-30 14:50:29','202','202',2021,'202','2021-10-30 14:50:29',5),('1','65',17787,'420',5030.63,70.00,'2021-11-26','','2021-11-26 11:09:02','202','202',2021,'202','2021-11-26 11:09:02',5),('1','65',17794,'420',70.00,4800.00,'2021-11-26','','2021-11-26 16:44:00','202','202',2021,'202','2021-11-26 16:44:00',5),('1','65',17853,'420',193.04,443.00,'2021-12-01','','2021-12-01 10:49:59','202','202',2021,'202','2021-12-01 10:49:59',5),('1','65',18462,'423',355.30,510.00,'2022-01-17','','2022-01-17 09:40:14','202','202',2022,'202','2022-01-17 09:40:14',5),('1','65',18463,'423',902.53,300.00,'2022-02-25','','2022-02-25 10:51:05','202','202',2022,'202','2022-02-25 10:51:05',5),('1','65',18464,'423',300.00,1200.00,'2022-02-25','','2022-02-25 13:51:05','202','202',2022,'202','2022-02-25 13:51:05',5),('1','65',18465,'423',0.14,1250.00,'2022-04-17','','2022-04-17 13:32:13','202','202',2022,'202','2022-04-17 13:32:13',5),('1','65',18466,'423',411.21,200.00,'2022-06-07','','2022-06-07 11:44:12','202','202',2022,'202','2022-06-07 11:44:12',5),('1','65',18467,'420',30.10,100.00,'2022-06-07','','2022-06-07 11:44:39','202','202',2022,'202','2022-06-07 11:44:39',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1138 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','65','420',1122,'5','PUMP 01',815480.71,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:09:06','178'),('1','65','420',1123,'5','PUMP 02',604283.23,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:13:36','178'),('1','65','420',1124,'5','PUMP 3',376484.66,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:14:03','178'),('1','65','420',1125,'5','PUMP 4',244062.98,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:14:28','178'),('1','65','420',1126,'5','PUMP 5',641560.30,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:14:59','178'),('1','65','420',1127,'5','PUMP 6',440082.68,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:15:24','178'),('1','65','421',1128,'5','PUMP 7',78226.23,'DISPNSING PMS','',NULL,NULL,'',5,'2020-10-15 13:57:10','178'),('1','65','421',1129,'5','PUMP 8',207241.44,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:16:04','178'),('1','65','421',1130,'5','PUMP 9',721485.87,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:16:29','178'),('1','65','421',1131,'5','PUMP 10',123851.16,'DISPENSING PMS','',NULL,NULL,'',5,'2020-12-31 11:16:57','178'),('1','65','421',1132,'5','PUMP 11',0.00,'DISPENSING PMS',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','65','421',1133,'5','PUMP 12',0.00,'DISPENSING PMS',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','65','423',1134,'5','PUMP 13',10348130.96,'DISPENSING AGO','',NULL,NULL,'',5,'2020-12-31 11:18:03','178'),('1','65','423',1135,'5','PUMP 14',684363.93,'DISPENSING AGO','',NULL,NULL,'',5,'2020-12-31 11:18:36','178'),('1','65','424',1136,'5','PUMP 1',0.00,'DISPENSING DPK',NULL,NULL,NULL,NULL,0,'0000-00-00 00:00:00',''),('1','65','424',1137,'5','PUMP 2',0.00,'DISPENSING DPK',NULL,NULL,NULL,NULL,0,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
INSERT INTO `depots_nozzles_status` VALUES (1,'1','65','1136',0,'Inactive','2019-07-30 11:23:24'),(2,'1','65','1137',0,'Inactive','2019-07-30 11:24:01');
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (4,'1','65','1126','420','DISPENSER SWAP','2019-07-30 11:13:14',0,'298'),(5,'1','65','1127','420','DISPENSER SWAP','2019-07-30 11:14:07',0,'298'),(6,'1','65','1131','421','DISPENSER SWAP','2019-07-30 11:15:57',0,'298'),(7,'1','65','1130','421','DISPENSER SWAP','2019-07-30 11:16:31',0,'298'),(8,'1','65','1132','421','DISPENSER SWAP','2019-07-30 11:17:02',0,'298'),(9,'1','65','1133','421','DISPENSER SWAP','2019-07-30 11:18:21',0,'298');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258017 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','65',157535,'MORNING ','2020-10-11','2020-10-11 00:00:00',NULL,'548',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',170280,'morning','2020-12-28','2020-12-28 00:00:00',NULL,'548',195652.50,216247.50,'548','2020-12-31 15:19:08','548','2020-12-31 15:21:38',10,0),('1','65',170865,'AFTERNOON','2020-12-28','2020-12-28 00:00:00',NULL,'548',252519.50,252519.50,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',171410,'AFTERNOON','2020-12-28','2020-12-28 00:00:00',NULL,'548',279100.50,279100.50,'548','2021-01-07 08:46:35','548','2021-01-07 11:37:13',10,0),('1','65',171468,'morning','2020-12-29','2020-12-29 00:00:00',NULL,'548',71702.40,71702.40,'548','2021-01-07 11:56:31','548','2021-01-07 12:00:26',10,0),('1','65',171479,'AFTERNOON','2020-12-29','2020-12-29 00:00:00',NULL,'548',167869.80,167869.80,'548','2021-01-07 12:16:45','548','2021-01-07 12:19:10',10,0),('1','65',175666,'morning','2020-12-30','2020-12-30 00:00:00',NULL,'548',261101.40,261101.40,'548','2021-01-30 13:13:18','548','2021-01-30 13:16:49',10,0),('1','65',175670,'AFTERNOON','2020-12-30','2020-12-30 00:00:00',NULL,'548',302870.40,302870.40,'548','2021-01-30 13:21:42','548','2021-01-30 13:23:01',10,0),('1','65',175672,'MORNING','2020-12-31','2020-12-31 00:00:00',NULL,'548',297483.90,297483.90,'548','2021-01-30 13:29:35','548','2021-01-30 13:30:49',10,0),('1','65',175673,'AFTERNOON','2020-12-31','2020-12-31 00:00:00',NULL,'548',118146.00,118146.00,'548','2021-01-30 13:35:03','548','2021-01-30 13:35:46',10,0),('1','65',175824,'MORNING','2021-01-01','2021-01-01 00:00:00',NULL,'548',37405.20,37405.20,'548','2021-01-31 11:29:50','548','2021-01-31 11:30:37',10,0),('1','65',175826,'AFTERNOON','2021-01-04','2021-01-04 00:00:00',NULL,'548',71580.60,71580.60,'548','2021-01-31 11:39:42','548','2021-01-31 11:40:34',10,0),('1','65',175828,'MORNING','2021-01-05','2021-01-05 00:00:00',NULL,'548',248770.20,248770.20,'548','2021-01-31 11:49:44','548','2021-01-31 11:51:06',10,0),('1','65',175831,'AFTERNOON','2021-01-05','2021-01-05 00:00:00',NULL,'548',252352.80,252352.80,'548','2021-01-31 11:58:53','548','2021-01-31 12:00:53',10,0),('1','65',175834,'MORNING','2021-01-06','2021-01-06 00:00:00',NULL,'548',339540.60,339540.60,'548','2021-01-31 12:06:22','548','2021-01-31 12:10:06',10,0),('1','65',175836,'AFTERNOON','2021-01-06','2021-01-06 00:00:00',NULL,'548',528644.14,528644.14,'548','2021-01-31 12:18:12','548','2021-01-31 12:19:10',10,0),('1','65',176121,'MORNING','2021-01-07','2021-01-07 00:00:00',NULL,'548',245341.96,245341.96,'548','2021-02-01 17:13:15','548','2021-02-01 17:14:12',10,0),('1','65',176124,'AFTERNOON','2021-01-07','2021-01-07 00:00:00',NULL,'548',573480.64,573480.64,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',176354,'AFTERNOON','2021-01-07','2021-01-07 00:00:00',NULL,'548',570868.72,570868.72,'548','2021-02-03 08:04:53','548','2021-02-03 08:10:12',10,0),('1','65',176357,'MORNING','2021-01-08','2021-01-08 00:00:00',NULL,'548',304595.02,304595.02,'548','2021-02-03 08:26:44','548','2021-02-03 08:27:19',10,0),('1','65',176360,'AFTERNOON','2021-01-08','2021-01-08 00:00:00',NULL,'548',199295.15,199295.15,'548','2021-02-03 08:31:17','548','2021-02-03 08:31:58',10,0),('1','65',176361,'MORNING','2021-01-09','2021-01-09 00:00:00',NULL,'548',765765.35,765765.35,'548','2021-02-03 08:55:50','548','2021-02-03 08:57:05',10,0),('1','65',176364,'AFTERNOON','2021-01-09','2021-01-09 00:00:00',NULL,'548',358904.11,358904.11,'548','2021-02-03 09:04:19','548','2021-02-03 09:05:29',10,0),('1','65',176367,'MORNING','2021-01-10','2021-01-10 00:00:00',NULL,'548',262735.64,262735.64,'548','2021-02-03 09:11:39','548','2021-02-03 09:12:22',10,0),('1','65',176368,'AFTERNOON','2021-01-10','2021-01-10 00:00:00',NULL,'548',363744.60,363744.60,'548','2021-02-03 09:16:42','548','2021-02-03 09:17:33',10,0),('1','65',176370,'MORNING','2021-01-11','2021-01-11 00:00:00',NULL,'548',511558.49,511558.49,'548','2021-02-03 09:22:28','548','2021-02-03 09:23:01',10,0),('1','65',176371,'AFTERNOON','2021-01-11','2021-01-11 00:00:00',NULL,'548',839188.57,839188.57,'548','2021-02-03 09:26:25','548','2021-02-03 09:27:03',10,0),('1','65',176373,'MORNING','2021-01-12','2021-01-12 00:00:00',NULL,'548',572848.87,572848.87,'548','2021-02-03 09:34:32','548','2021-02-03 09:35:07',10,0),('1','65',176376,'AFTERNOON','2021-01-12','2021-01-12 00:00:00',NULL,'548',382995.88,382995.88,'548','2021-02-03 09:42:28','548','2021-02-03 09:43:49',10,0),('1','65',176379,'MORNING','2021-01-13','2021-01-13 00:00:00',NULL,'548',321102.16,321102.16,'548','2021-02-03 09:49:46','548','2021-02-03 09:50:37',10,0),('1','65',176380,'AFTERNOON','2021-01-13','2021-01-13 00:00:00',NULL,'548',290295.15,290295.15,'548','2021-02-03 09:54:23','548','2021-02-03 09:55:03',10,0),('1','65',176383,'MORNING','2021-01-14','2021-01-14 00:00:00',NULL,'548',591196.25,591196.25,'548','2021-02-03 09:57:55','548','2021-02-03 09:58:31',10,0),('1','65',176385,'AFTERNOON','2021-01-14','2021-01-14 00:00:00',NULL,'548',381358.40,381358.40,'548','2021-02-03 10:05:13','548','2021-02-03 10:06:10',10,0),('1','65',176389,'MORNING','2021-01-15','2021-01-15 00:00:00',NULL,'548',153034.85,153034.85,'548','2021-02-03 10:10:42','548','2021-02-03 10:11:24',10,0),('1','65',176390,'AFTERNOON','2021-01-15','2021-01-15 00:00:00',NULL,'548',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',176392,'AFTERNOON','2021-01-15','2021-01-15 00:00:00',NULL,'548',599962.00,599962.00,'548','2021-02-03 10:22:08','548','2021-02-03 10:24:56',10,0),('1','65',176395,'MORNING','2021-01-16','2021-01-16 00:00:00',NULL,'548',35402.40,35402.40,'548','2021-02-03 10:31:15','548','2021-02-03 10:32:13',10,0),('1','65',176397,'AFTERNOON','2021-01-16','2021-01-16 00:00:00',NULL,'548',421911.60,421911.60,'548','2021-02-03 10:36:55','548','2021-02-03 10:37:46',10,0),('1','65',176401,'MORNING','2021-01-17','2021-01-17 00:00:00',NULL,'548',60852.00,60852.00,'548','2021-02-03 10:47:19','548','2021-02-03 10:48:18',10,0),('1','65',176403,'AFTERNOON','2021-01-17','2021-01-17 00:00:00',NULL,'548',536562.40,536562.40,'548','2021-02-03 10:52:12','548','2021-02-03 10:53:04',10,0),('1','65',176406,'MORNING','2021-01-18','2021-01-18 00:00:00',NULL,'548',254722.60,254722.60,'548','2021-02-03 10:57:54','548','2021-02-03 10:58:42',10,0),('1','65',176408,'AFTERNOON','2021-01-18','2021-01-18 00:00:00',NULL,'548',522328.40,522328.40,'548','2021-02-03 11:03:27','548','2021-02-03 11:04:55',10,0),('1','65',176410,'MORNING','2021-01-19','2021-01-19 00:00:00',NULL,'548',318667.80,318667.80,'548','2021-02-03 11:11:42','548','2021-02-03 11:12:29',10,0),('1','65',176415,'AFTERNOON','2021-01-19','2021-01-19 00:00:00',NULL,'548',534754.58,534754.58,'548','2021-02-03 11:32:49','548','2021-02-03 11:34:22',10,0),('1','65',176419,'MORNING','2021-01-20','2021-01-20 00:00:00',NULL,'548',493374.28,493374.28,'548','2021-02-03 11:42:50','548','2021-02-03 11:45:12',10,0),('1','65',176422,'AFTERNOON','2021-01-20','2021-01-20 00:00:00',NULL,'548',619144.01,619144.01,'548','2021-02-03 11:54:04','548','2021-02-03 12:05:21',10,0),('1','65',176905,'MORNING','2021-01-21','2021-01-21 00:00:00',NULL,'548',116864.48,116864.48,'548','2021-02-05 15:30:49','548','2021-02-05 15:31:50',10,0),('1','65',176907,'AFTERNOON','2021-01-21','2021-01-21 00:00:00',NULL,'548',155237.94,155237.94,'548','2021-02-05 15:37:08','548','2021-02-05 15:38:03',10,0),('1','65',176910,'MORNING','2021-01-22','2021-01-22 00:00:00',NULL,'548',288160.47,288160.47,'548','2021-02-05 15:43:35','548','2021-02-05 15:44:46',10,0),('1','65',176913,'AFTERNOON','2021-01-22','2021-01-22 00:00:00',NULL,'548',308517.79,308517.79,'548','2021-02-05 15:49:34','548','2021-02-05 15:50:33',10,0),('1','65',176914,'MORNING','2021-01-23','2021-01-23 00:00:00',NULL,'548',436350.22,436350.22,'548','2021-02-05 15:57:14','548','2021-02-05 15:58:20',10,0),('1','65',176917,'AFTERNOON','2021-01-23','2021-01-23 00:00:00',NULL,'548',525147.69,525147.69,'548','2021-02-05 16:04:21','548','2021-02-05 16:05:24',10,0),('1','65',176921,'MORNING','2021-01-24','2021-01-24 00:00:00',NULL,'548',761910.06,761910.06,'548','2021-02-05 16:10:44','548','2021-02-05 16:11:40',10,0),('1','65',176922,'AFTERNOON','2021-01-24','2021-01-24 00:00:00',NULL,'548',699178.29,699178.29,'548','2021-02-06 15:51:20','548','2021-02-06 15:52:06',10,0),('1','65',177162,'MORNING','2021-01-25','2021-01-25 00:00:00',NULL,'548',334473.29,339160.69,'548','2021-02-06 16:00:07','548','2021-02-06 16:01:35',10,0),('1','65',177168,'AFTERNOON','2021-01-25','2021-01-25 00:00:00',NULL,'548',206284.17,208295.92,'548','2021-02-06 16:07:12','548','2021-02-06 16:07:56',10,0),('1','65',177171,'MORNING','2021-01-26','2021-01-26 00:00:00',NULL,'548',555172.15,564998.45,'548','2021-02-06 16:16:55','548','2021-02-06 16:18:41',10,0),('1','65',177175,'AFTERNOON','2021-01-26','2021-01-26 00:00:00',NULL,'548',158756.67,158756.67,'548','2021-02-06 16:26:39','548','2021-02-06 16:27:49',10,0),('1','65',177178,'MORNING','2021-01-27','2021-01-27 00:00:00',NULL,'548',224933.14,224933.14,'548','2021-02-06 16:31:52','548','2021-02-06 16:32:31',10,0),('1','65',177180,'AFTERNOON','2021-01-27','2021-01-27 00:00:00',NULL,'548',862799.82,862799.82,'548','2021-02-06 16:39:10','548','2021-02-06 16:39:57',10,0),('1','65',177228,'MORNING','2021-01-28','2021-01-28 00:00:00',NULL,'548',613677.18,613677.18,'548','2021-02-07 05:58:21','548','2021-02-07 05:59:07',10,0),('1','65',177230,'AFTERNOON','2021-01-28','2021-01-28 00:00:00',NULL,'548',190809.84,190809.84,'548','2021-02-07 06:04:09','548','2021-02-07 06:05:06',10,0),('1','65',177232,'MORNING','2021-01-29','2021-01-29 00:00:00',NULL,'548',386282.69,386282.69,'548','2021-02-07 06:09:16','548','2021-02-07 06:10:42',10,0),('1','65',177233,'AFTERNOON','2021-01-29','2021-01-29 00:00:00',NULL,'548',230594.75,230594.75,'548','2021-02-07 06:15:32','548','2021-02-07 06:16:13',10,0),('1','65',177234,'MORNING','2021-01-30','2021-01-30 00:00:00',NULL,'548',117301.50,117301.50,'548','2021-02-07 06:24:26','548','2021-02-07 06:25:05',10,0),('1','65',177235,'AFTERNOON','2021-01-30','2021-01-30 00:00:00',NULL,'548',576533.25,576533.25,'548','2021-02-07 06:32:00','548','2021-02-07 06:33:42',10,0),('1','65',177237,'MORNING','2021-01-31','2021-01-31 00:00:00',NULL,'548',170741.25,170741.25,'548','2021-02-07 06:39:10','548','2021-02-07 06:39:48',10,0),('1','65',177238,'AFTERNOON','2021-01-31','2021-01-31 00:00:00',NULL,'548',995994.00,995994.00,'548','2021-02-07 06:49:11','548','2021-02-07 06:49:58',10,0),('1','65',177241,'MORNING','2021-02-01','2021-02-01 00:00:00',NULL,'548',197268.75,197268.75,'548','2021-02-07 06:57:44','548','2021-02-07 06:58:41',10,0),('1','65',177242,'AFTERNOON','2021-02-01','2021-02-01 00:00:00',NULL,'548',131496.75,131496.75,'548','2021-02-07 07:02:10','548','2021-02-07 07:02:44',10,0),('1','65',177243,'MORNING','2021-02-02','2021-02-02 00:00:00',NULL,'548',410121.81,410121.81,'548','2021-02-07 07:09:11','548','2021-02-07 07:11:15',10,0),('1','65',177244,'AFTERNOON','2021-02-02','2021-02-02 00:00:00',NULL,'548',252843.37,252843.37,'548','2021-02-09 10:03:57','548','2021-02-09 10:04:30',10,0),('1','65',177699,'MORNING','2021-02-03','2021-02-03 00:00:00',NULL,'548',244032.19,244032.19,'548','2021-02-09 10:29:39','548','2021-02-09 10:30:35',10,0),('1','65',177705,'AFTERNOON','2021-02-03','2021-02-03 00:00:00',NULL,'548',408545.45,407471.55,'548','2021-02-09 10:55:07','548','2021-02-09 10:55:53',10,0),('1','65',177715,'MORNING','2021-02-04','2021-02-04 00:00:00',NULL,'548',142403.32,142403.32,'548','2021-02-09 11:00:23','548','2021-02-09 11:00:49',10,0),('1','65',177717,'AFTERNOON','2021-02-04','2021-02-04 00:00:00',NULL,'548',185909.65,185909.65,'548','2021-02-09 11:04:45','548','2021-02-09 11:05:25',10,0),('1','65',177718,'MORNING','2021-02-05','2021-02-05 00:00:00',NULL,'548',202463.93,202463.93,'548','2021-02-09 11:10:14','548','2021-02-09 11:10:55',10,0),('1','65',177720,'AFTERNOON','2021-02-05','2021-02-05 00:00:00',NULL,'548',186753.99,186753.99,'548','2021-02-09 11:15:08','548','2021-02-09 11:18:14',10,0),('1','65',177724,'MORNING','2021-02-06','2021-02-06 00:00:00',NULL,'548',574972.36,574972.36,'548','2021-02-09 11:24:59','548','2021-02-09 11:25:30',10,0),('1','65',177726,'AFTERNOON','2021-02-06','2021-02-06 00:00:00',NULL,'548',515584.75,515584.75,'548','2021-02-09 11:29:26','548','2021-02-09 11:30:06',10,0),('1','65',177728,'MORNING','2021-02-07','2021-02-07 00:00:00',NULL,'548',589549.04,589549.04,'548','2021-02-09 11:36:20','548','2021-02-09 11:37:29',10,0),('1','65',177731,'AFTERNOON','2021-02-07','2021-02-07 00:00:00',NULL,'548',528548.56,528548.56,'548','2021-02-09 11:42:03','548','2021-02-09 11:43:02',10,0),('1','65',178234,'MORNING','2021-02-08','2021-02-08 00:00:00',NULL,'548',283717.30,283717.30,'548','2021-02-11 15:52:42','548','2021-02-11 15:53:15',10,0),('1','65',178238,'AFTERNOON','2021-02-08','2021-02-08 00:00:00',NULL,'548',205118.60,205118.60,'548','2021-02-11 15:58:51','548','2021-02-11 15:59:18',10,0),('1','65',178239,'MORNING','2021-02-09','2021-02-09 00:00:00',NULL,'548',386954.30,386954.30,'548','2021-02-11 16:02:50','548','2021-02-11 16:03:18',10,0),('1','65',178241,'AFTERNOON','2021-02-09','2021-02-09 00:00:00',NULL,'548',61853.90,61853.90,'548','2021-02-11 16:06:52','548','2021-02-11 16:07:15',10,0),('1','65',178242,'MORNING','2021-02-10','2021-02-10 00:00:00',NULL,'548',137334.78,137334.78,'548','2021-02-11 16:13:30','548','2021-02-11 16:14:04',10,0),('1','65',178244,'AFTERNOON','2021-02-10','2021-02-10 00:00:00',NULL,'548',672262.29,672262.29,'548','2021-02-11 16:22:49','548','2021-02-11 16:23:52',10,0),('1','65',178248,'MORNING','2021-02-11','2021-02-11 00:00:00',NULL,'548',829745.52,829745.52,'548','2021-02-11 16:32:02','548','2021-02-11 16:32:27',10,0),('1','65',178745,'MORNING','2021-02-12','2021-02-12 00:00:00',NULL,'548',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',178746,'AFTERNOON','2021-02-11','2021-02-11 00:00:00',NULL,'548',286898.06,286898.06,'548','2021-02-14 08:31:12','548','2021-02-14 08:31:38',10,0),('1','65',178750,'MORNING','2021-02-12','2021-02-12 00:00:00',NULL,'548',174478.46,174478.46,'548','2021-02-14 08:36:44','548','2021-02-14 08:37:16',10,0),('1','65',178752,'AFTERNOON','2021-02-12','2021-02-12 00:00:00',NULL,'548',179179.38,179179.38,'548','2021-02-14 08:39:57','548','2021-02-14 08:40:23',10,0),('1','65',178756,'MORNING','2021-02-13','2021-02-13 00:00:00',NULL,'548',160436.01,160436.01,'548','2021-02-14 08:42:43','548','2021-02-14 08:43:22',10,0),('1','65',178758,'AFTERNOON','2021-02-13','2021-02-13 00:00:00',NULL,'548',632635.60,632635.60,'548','2021-02-14 08:47:13','548','2021-02-14 08:47:46',10,0),('1','65',179229,'MORNING','2021-02-14','2021-02-14 00:00:00',NULL,'548',663477.79,663477.79,'548','2021-02-16 10:48:30','548','2021-02-16 10:49:00',10,0),('1','65',179230,'AFTERNOON','2021-02-14','2021-02-14 00:00:00',NULL,'548',524513.28,524513.28,'548','2021-02-16 10:53:02','548','2021-02-16 10:53:35',10,0),('1','65',179232,'MORNING','2021-02-15','2021-02-15 00:00:00',NULL,'548',1230633.99,1230633.99,'548','2021-02-16 10:56:39','548','2021-02-16 10:57:32',10,0),('1','65',179234,'AFTERNOON','2021-02-15','2021-02-15 00:00:00',NULL,'548',644684.18,644684.18,'548','2021-02-16 11:03:01','548','2021-02-16 11:03:28',10,0),('1','65',179854,'MORNING','2021-02-16','2021-02-16 00:00:00',NULL,'548',233859.89,233859.89,'548','2021-02-19 11:30:41','548','2021-02-19 11:31:56',10,0),('1','65',179856,'AFTERNOON','2021-02-16','2021-02-16 00:00:00',NULL,'548',226521.25,226521.25,'548','2021-02-19 11:36:17','548','2021-02-19 11:37:14',10,0),('1','65',179860,'MORNING','2021-02-17','2021-02-17 00:00:00',NULL,'548',1276917.34,1276917.34,'548','2021-02-19 11:47:29','548','2021-02-19 11:52:10',10,0),('1','65',179864,'AFTERNOON','2021-02-17','2021-02-17 00:00:00',NULL,'548',267662.59,267662.59,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',180584,'AFTERNOON','2021-02-17','2021-02-17 00:00:00',NULL,'548',274059.31,274059.31,'548','2021-02-23 09:33:57','548','2021-02-23 09:34:40',10,0),('1','65',180585,'MORNING','2021-02-18','2021-02-18 00:00:00',NULL,'548',288769.72,288769.72,'548','2021-02-23 09:38:45','548','2021-02-23 09:39:32',10,0),('1','65',180590,'AFTERNOON','2021-02-18','2021-02-18 00:00:00',NULL,'548',596884.16,596884.16,'548','2021-02-23 09:43:37','548','2021-02-23 09:45:25',10,0),('1','65',180595,'MORNING','2021-02-19','2021-02-19 00:00:00',NULL,'548',370627.67,370627.67,'548','2021-02-23 09:49:54','548','2021-02-23 09:50:43',10,0),('1','65',180596,'AFTERNOON','2021-02-19','2021-02-19 00:00:00',NULL,'548',257359.73,257359.73,'548','2021-02-23 09:55:39','548','2021-02-23 09:56:20',10,0),('1','65',180601,'MORNING','2021-02-20','2021-02-20 00:00:00',NULL,'548',760119.55,760119.55,'548','2021-02-23 10:03:44','548','2021-02-23 10:05:57',10,0),('1','65',180605,'AFTERNOON','2021-02-20','2021-02-20 00:00:00',NULL,'548',459029.32,459029.32,'548','2021-02-23 10:12:55','548','2021-02-23 10:13:38',10,0),('1','65',180611,'MORNING','2021-02-21','2021-02-21 00:00:00',NULL,'548',453366.77,453366.77,'548','2021-02-23 10:20:17','548','2021-02-23 10:20:57',10,0),('1','65',180614,'AFTERNOON','2021-02-21','2021-02-21 00:00:00',NULL,'548',442788.72,442788.72,'548','2021-02-23 10:28:21','548','2021-02-23 10:29:09',10,0),('1','65',180619,'MORNING','2021-02-22','2021-02-22 00:00:00',NULL,'548',184643.55,184643.55,'548','2021-02-23 10:45:51','548','2021-02-23 10:46:44',10,0),('1','65',180622,'AFTERNOON','2021-02-22','2021-02-22 00:00:00',NULL,'548',209418.87,209418.87,'548','2021-02-23 10:49:11','548','2021-02-23 10:50:05',10,0),('1','65',180815,'MORNING','2021-02-23','2021-02-23 00:00:00',NULL,'548',850258.05,850258.05,'548','2021-02-24 10:48:07','548','2021-02-24 10:48:47',10,0),('1','65',180817,'AFTERNOON','2021-02-23','2021-02-23 00:00:00',NULL,'548',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',180822,'AFTERNOON','2021-02-23','2021-02-23 00:00:00',NULL,'548',232259.74,232259.74,'548','2021-02-24 10:59:48','548','2021-02-24 11:00:28',10,0),('1','65',181800,'MORNING','2021-02-24','2021-02-24 00:00:00',NULL,'548',674217.33,674217.33,'548','2021-03-01 13:33:56','548','2021-03-01 13:34:59',10,0),('1','65',181803,'AFTERNOON','2021-02-24','2021-02-24 00:00:00',NULL,'548',493506.46,493506.46,'548','2021-03-01 13:45:38','548','2021-03-01 13:46:14',10,0),('1','65',181804,'MORNING','2021-02-25','2021-02-25 00:00:00',NULL,'548',630729.73,630729.73,'548','2021-03-01 16:07:07','548','2021-03-01 16:10:07',10,0),('1','65',181828,'AFTERNOON','2021-02-25','2021-02-25 00:00:00',NULL,'548',319081.90,319081.90,'548','2021-03-01 16:16:37','548','2021-03-01 16:18:10',10,0),('1','65',181831,'MORNING','2021-02-26','2021-02-26 00:00:00',NULL,'548',546218.21,546218.21,'548','2021-03-01 16:24:53','548','2021-03-01 16:25:17',10,0),('1','65',181833,'AFTERNOON','2021-02-26','2021-02-26 00:00:00',NULL,'548',298143.39,298143.39,'548','2021-03-01 16:29:09','548','2021-03-01 16:32:24',10,0),('1','65',181836,'MORNING','2021-02-27','2021-02-27 00:00:00',NULL,'548',272664.51,272664.51,'548','2021-03-01 16:37:11','548','2021-03-01 16:38:04',10,0),('1','65',181838,'AFTERNOON','2021-02-27','2021-02-27 00:00:00',NULL,'548',319655.63,319655.63,'548','2021-03-01 16:41:33','548','2021-03-01 16:42:15',10,0),('1','65',181841,'MORNING','2021-02-28','2021-02-28 00:00:00',NULL,'548',863620.60,863620.60,'548','2021-03-01 16:50:23','548','2021-03-01 16:52:32',10,0),('1','65',181845,'AFTERNOON','2021-02-28','2021-02-28 00:00:00',NULL,'548',45696.00,45696.00,'548','2021-03-01 16:56:19','548','2021-03-01 16:58:14',10,0),('1','65',181848,'MORNING','2021-03-01','2021-03-01 00:00:00',NULL,'548',291832.20,291832.20,'548','2021-03-01 17:01:23','548','2021-03-01 17:02:56',10,0),('1','65',181959,'AFTERNOON','2021-03-01','2021-03-01 00:00:00',NULL,'548',317151.15,317151.15,'548','2021-03-02 09:35:00','548','2021-03-02 09:37:34',10,0),('1','65',182242,'MORNING','2021-03-02','2021-03-02 00:00:00',NULL,'548',318811.20,318811.20,'548','2021-03-03 15:41:21','548','2021-03-03 15:42:14',10,0),('1','65',182244,'AFTERNOON','2021-03-02','2021-03-02 00:00:00',NULL,'548',341093.10,341093.10,'548','2021-03-03 15:46:08','548','2021-03-03 15:46:47',10,0),('1','65',182246,'MORNING','2021-03-03','2021-03-03 00:00:00',NULL,'548',256649.85,256649.85,'548','2021-03-03 15:50:44','548','2021-03-03 15:51:17',10,0),('1','65',183058,'MORNING','2021-03-07','2021-03-07 00:00:00',NULL,'548',112229.01,112229.01,'548','2021-03-08 10:54:43','548','2021-03-08 10:55:24',10,0),('1','65',183060,'AFTERNOON','2021-03-07','2021-03-07 00:00:00',NULL,'548',150618.97,150618.97,'548','2021-03-08 11:02:17','548','2021-03-08 11:02:56',10,0),('1','65',183177,'MORNING','2021-03-08','2021-03-08 00:00:00',NULL,'548',135807.74,135807.74,'548','2021-03-08 17:15:53','548','2021-03-08 17:24:42',10,0),('1','65',183292,'AFTERNOON','2021-03-08','2021-03-08 00:00:00',NULL,'548',130398.61,130398.61,'548','2021-03-09 11:02:05','548','2021-03-09 11:02:28',10,0),('1','65',183514,'MORNING','2021-03-09','2021-03-09 00:00:00',NULL,'548',132885.24,132885.24,'548','2021-03-10 11:39:58','548','2021-03-10 11:40:33',10,0),('1','65',183515,'AFTERNOON','2021-03-09','2021-03-09 00:00:00',NULL,'548',128478.11,128478.11,'548','2021-03-10 11:42:33','548','2021-03-10 11:43:16',10,0),('1','65',183677,'MORNING','2021-03-10','2021-03-10 00:00:00',NULL,'548',160927.88,160927.88,'548','2021-03-11 11:01:11','548','2021-03-11 11:02:22',10,0),('1','65',183735,'AFTERNOON','2021-03-10','2021-03-10 00:00:00',NULL,'548',0.00,0.00,'548','2021-03-11 11:06:25','548','2021-03-11 11:07:21',10,0),('1','65',183739,'AFTERNOON','2021-03-10','2021-03-10 00:00:00',NULL,'548',417416.50,417416.50,'548','2021-03-11 11:17:23','548','2021-03-11 11:18:11',10,0),('1','65',183740,'MORNING','2021-03-11','2021-03-11 00:00:00',NULL,'548',186149.89,186149.89,'548','2021-03-11 15:19:21','548','2021-03-11 15:20:02',10,0),('1','65',183889,'AFTERNOON','2021-03-11','2021-03-11 00:00:00',NULL,'548',203466.12,203466.12,'548','2021-03-12 06:53:20','548','2021-03-12 06:56:23',10,0),('1','65',183893,'MORNING','2021-03-12','2021-03-12 00:00:00',NULL,'548',232031.47,232031.47,'548','2021-03-12 13:09:16','548','2021-03-12 13:09:50',10,0),('1','65',184001,'AFTERNOON','2021-03-12','2021-03-12 00:00:00',NULL,'548',228290.67,228290.67,'548','2021-03-13 05:43:30','548','2021-03-13 13:14:20',10,0),('1','65',184151,'MORNING','2021-03-13','2021-03-13 00:00:00',NULL,'548',227746.25,227746.25,'548','2021-03-14 05:43:16','548','2021-03-14 05:44:41',10,0),('1','65',184260,'AFTERNOON','2021-03-13','2021-03-13 00:00:00',NULL,'548',170957.90,170957.90,'548','2021-03-14 16:10:47','548','2021-03-14 16:15:48',10,0),('1','65',184434,'MORNING','2021-03-14','2021-03-14 00:00:00',NULL,'548',233104.00,233104.00,'548','2021-03-15 05:38:08','548','2021-03-15 05:39:49',10,0),('1','65',184452,'AFTERNOON','2021-03-14','2021-03-14 00:00:00',NULL,'548',266736.80,266736.80,'548','2021-03-16 07:09:11','548','2021-03-16 07:09:40',10,0),('1','65',184705,'MORNING','2021-03-15','2021-03-15 00:00:00',NULL,'548',151974.90,151974.90,'548','2021-03-20 07:53:38','535','2021-03-22 07:33:53',10,0),('1','65',185964,'AFTERNOON','2021-03-15','2021-03-15 00:00:00',NULL,'548',126065.20,126065.20,'548','2021-03-22 12:00:17','535','2021-03-22 12:02:07',10,0),('1','65',185965,'MORNING','2021-03-20','2021-03-20 00:00:00',NULL,'548',56844.60,56844.60,'548','2021-03-22 12:07:26','535','2021-03-22 12:11:01',10,0),('1','65',185967,'AFTERNOON','2021-03-20','2021-03-20 00:00:00',NULL,'548',253319.55,253319.55,'548','2021-03-22 12:19:06','535','2021-03-22 12:24:14',10,0),('1','65',186111,'MORNING','2021-03-21','2021-03-21 00:00:00',NULL,'548',218400.60,218400.60,'548','2021-03-23 08:07:00','535','2021-03-23 08:15:44',10,0),('1','65',186116,'AFTERNOON','2021-03-21','2021-03-21 00:00:00',NULL,'548',160738.05,160738.05,'548','2021-03-23 08:27:22','535','2021-03-23 08:53:02',10,0),('1','65',186132,'MORNING','2021-03-22','2021-03-22 00:00:00',NULL,'548',172372.20,172372.20,'548','2021-03-23 09:11:21','535','2021-03-23 09:13:41',10,0),('1','65',186324,'AFTERNOON','2021-03-22','2021-03-22 00:00:00',NULL,'548',153402.15,153402.15,'548','2021-03-24 07:23:49','535','2021-03-24 07:36:26',10,0),('1','65',186338,'MORNING','2021-03-23','2021-03-23 00:00:00',NULL,'548',203152.95,203152.95,'548','2021-03-24 07:54:39','535','2021-03-24 08:03:49',10,0),('1','65',186343,'AFTERNOON','2021-03-23','2021-03-23 00:00:00',NULL,'548',136446.75,136446.75,'548','2021-03-24 08:09:44','535','2021-03-24 08:11:46',10,0),('1','65',186530,'MORNING','2021-03-24','2021-03-24 00:00:00',NULL,'548',196150.35,196150.35,'548','2021-03-25 13:02:50','535','2021-03-25 13:08:50',10,0),('1','65',186641,'AFTERNOON','2021-03-24','2021-03-24 00:00:00',NULL,'548',424826.60,412331.70,'548','2021-03-25 17:57:57','535','2021-03-25 19:04:19',10,0),('1','65',186714,'MORNING','2021-03-25','2021-03-25 00:00:00',NULL,'548',178545.90,173294.55,'548','2021-03-25 19:09:22','535','2021-03-25 19:10:57',10,0),('1','65',186740,'AFTERNOON','2021-03-25','2021-03-25 00:00:00',NULL,'548',201528.20,195600.90,'548','2021-03-26 13:55:31','535','2021-03-26 16:31:11',10,0),('1','65',186948,'MORNING','2021-03-26','2021-03-26 00:00:00',NULL,'548',218740.70,212307.15,'548','2021-03-26 19:01:41','535','2021-03-27 05:39:40',10,0),('1','65',186975,'AFTERNOON','2021-03-26','2021-03-26 00:00:00',NULL,'548',206879.80,200795.10,'548','2021-03-27 13:25:08','535','2021-03-27 13:30:52',10,0),('1','65',187078,'MORNING','2021-03-27','2021-03-27 00:00:00',NULL,'548',194549.70,188827.65,'548','2021-03-27 13:54:12','535','2021-03-27 14:20:09',10,0),('1','65',187156,'AFTERNOON','2021-03-27','2021-03-27 00:00:00',NULL,'548',218592.80,212163.60,'548','2021-03-29 12:59:33','535','2021-03-29 14:14:10',10,0),('1','65',187492,'MORNING','2021-03-28','2021-03-28 00:00:00',NULL,'548',170044.20,165042.90,'548','2021-03-29 14:19:38','535','2021-03-29 14:21:18',10,0),('1','65',187494,'AFTERNOON','2021-03-28','2021-03-28 00:00:00',NULL,'548',228974.70,222240.15,'548','2021-03-29 14:32:09','535','2021-03-29 14:34:03',10,0),('1','65',187566,'MORNING','2021-03-29','2021-03-29 00:00:00',NULL,'548',207918.50,201803.25,'548','2021-03-30 09:35:17','535','2021-03-30 09:37:30',10,0),('1','65',187651,'AFTERNOON','2021-03-29','2021-03-29 00:00:00',NULL,'548',141499.50,137337.75,'548','2021-03-30 09:42:04','535','2021-03-30 09:53:52',10,0),('1','65',187785,'MORNING','2021-03-30','2021-03-30 00:00:00',NULL,'548',165925.10,161044.95,'548','2021-03-31 11:59:20','535','2021-03-31 12:02:18',10,0),('1','65',187906,'AFTERNOON','2021-03-30','2021-03-30 00:00:00',NULL,'548',209599.80,203435.10,'548','2021-03-31 12:08:34','535','2021-03-31 14:20:20',10,0),('1','65',188035,'MORNING','2021-03-31','2021-03-31 00:00:00',NULL,'548',0.00,0.00,'548','2021-04-01 07:52:23','535','2021-04-01 08:07:38',10,0),('1','65',188047,'AFTERNOON','2021-03-31','2021-03-31 00:00:00',NULL,'548',437343.70,424480.65,'548','2021-04-01 08:23:48','535','2021-04-01 16:11:54',10,0),('1','65',189383,'MORNING','2021-04-07','2021-04-07 00:00:00',NULL,'548',142939.40,138735.30,'548','2021-04-07 19:03:37','535','2021-04-07 19:07:16',10,0),('1','65',189386,'AFTERNOON','2021-04-07','2021-04-07 00:00:00',NULL,'548',392398.05,392398.05,'548','2021-04-08 10:21:51','535','2021-04-08 10:26:33',10,0),('1','65',189536,'MORNING','2021-04-08','2021-04-08 00:00:00',NULL,'548',195906.15,195906.15,'548','2021-04-08 13:32:58','535','2021-04-08 15:15:45',10,0),('1','65',189606,'AFTERNOON','2021-04-08','2021-04-08 00:00:00',NULL,'548',144296.40,144296.40,'548','2021-04-09 14:23:58','535','2021-04-09 14:32:04',10,0),('1','65',189747,'MORNING','2021-04-09','2021-04-09 00:00:00',NULL,'548',252894.00,252894.00,'548','2021-04-09 15:13:35','535','2021-04-10 07:49:44',10,0),('1','65',189872,'AFTERNOON','2021-04-09','2021-04-09 00:00:00',NULL,'548',251082.60,251082.60,'548','2021-04-10 11:55:26','535','2021-04-10 13:34:59',10,0),('1','65',189988,'MORNING','2021-04-10','2021-04-10 00:00:00',NULL,'548',338689.50,338689.50,'548','2021-04-10 17:58:05','535','2021-04-11 07:42:22',10,0),('1','65',190186,'AFTERNOON','2021-04-10','2021-04-10 00:00:00',NULL,'548',410790.00,410790.00,'548','2021-04-12 08:07:07','535','2021-04-12 08:13:48',10,0),('1','65',190243,'MORNING','2021-04-11','2021-04-11 00:00:00',NULL,'548',582367.50,582367.50,'548','2021-04-12 08:24:43','535','2021-04-12 08:31:29',10,0),('1','65',190251,'AFTERNOON','2021-04-11','2021-04-11 00:00:00',NULL,'548',871646.25,871646.25,'548','2021-04-12 08:44:11','535','2021-04-12 08:48:31',10,0),('1','65',190621,'MORNING','2021-04-12','2021-04-12 00:00:00',NULL,'548',1067583.75,1067583.75,'548','2021-04-13 16:05:56','535','2021-04-13 16:08:08',10,0),('1','65',190630,'AFTERNOON','2021-04-12','2021-04-12 00:00:00',NULL,'548',557610.75,557610.75,'548','2021-04-13 16:35:23','535','2021-04-13 16:38:15',10,0),('1','65',190631,'MORNING','2021-04-13','2021-04-13 00:00:00',NULL,'548',119834.10,119834.10,'548','2021-04-13 16:42:43','535','2021-04-13 16:45:50',10,0),('1','65',190784,'AFTERNOON','2021-04-13','2021-04-13 00:00:00',NULL,'548',384623.10,384623.10,'548','2021-04-14 12:56:08','535','2021-04-14 13:10:36',10,0),('1','65',190860,'MORNING','2021-04-14','2021-04-14 00:00:00',NULL,'548',85760.10,85760.10,'548','2021-04-14 18:29:46','535','2021-04-15 07:58:23',10,0),('1','65',190981,'AFTERNOON','2021-04-14','2021-04-14 00:00:00',NULL,'548',293295.60,293295.60,'548','2021-04-15 11:56:48','535','2021-04-15 12:06:50',10,0),('1','65',191068,'MORNING','2021-04-15','2021-04-15 00:00:00',NULL,'548',295928.10,295928.10,'548','2021-04-16 10:53:25','535','2021-04-16 10:55:54',10,0),('1','65',191162,'AFTERNOON','2021-04-15','2021-04-15 00:00:00',NULL,'548',235585.80,235585.80,'548','2021-04-16 11:06:12','535','2021-04-16 11:15:56',10,0),('1','65',191278,'MORNING','2021-04-16','2021-04-16 00:00:00',NULL,'548',295188.30,295188.30,'548','2021-04-17 11:02:43','535','2021-04-17 12:31:53',10,0),('1','65',191393,'AFTERNOON','2021-04-16','2021-04-16 00:00:00',NULL,'548',69608.70,69608.70,'548','2021-04-17 12:47:35','535','2021-04-17 13:58:36',10,0),('1','65',191488,'MORNING','2021-04-17','2021-04-17 00:00:00',NULL,'548',129211.20,129211.20,'548','2021-04-18 18:20:46','535','2021-04-19 09:50:09',10,0),('1','65',191825,'AFTERNOON','2021-04-17','2021-04-17 00:00:00',NULL,'548',21724.20,21724.20,'548','2021-04-19 11:45:50','535','2021-04-19 12:20:16',10,0),('1','65',192094,'MORNING','2021-04-18','2021-04-18 00:00:00',NULL,'548',405013.50,405013.50,'548','2021-04-20 16:31:01','535','2021-04-20 16:36:51',10,0),('1','65',192098,'AFTERNOON','2021-04-18','2021-04-18 00:00:00',NULL,'548',323146.80,323146.80,'548','2021-04-20 16:39:57','535','2021-04-20 16:41:40',10,0),('1','65',192266,'MORNING','2021-04-19','2021-04-19 00:00:00',NULL,'548',587455.20,587455.20,'548','2021-04-21 14:15:32','535','2021-04-21 14:24:02',10,0),('1','65',192272,'AFTERNOON','2021-04-19','2021-04-19 00:00:00',NULL,'548',430280.10,430280.10,'548','2021-04-21 14:29:01','535','2021-04-22 07:17:49',10,0),('1','65',192645,'MORNING','2021-04-22','2021-04-22 00:00:00',NULL,'548',442800.00,442800.00,'548','2021-04-23 11:29:39','535','2021-04-23 14:16:24',10,0),('1','65',192745,'AFTERNOON','2021-04-22','2021-04-22 00:00:00',NULL,'548',96784.20,96784.20,'548','2021-04-24 13:26:34','535','2021-04-24 13:28:19',10,0),('1','65',192864,'MORNING','2021-04-23','2021-04-23 00:00:00',NULL,'548',80649.00,80649.00,'548','2021-04-24 13:33:54','535','2021-04-24 13:36:14',10,0),('1','65',192867,'AFTERNOON','2021-04-23','2021-04-23 00:00:00',NULL,'548',206158.50,206158.50,'548','2021-04-24 13:39:15','535','2021-04-24 13:41:44',10,0),('1','65',193078,'MORNING','2021-04-24','2021-04-24 00:00:00',NULL,'548',21872.70,21872.70,'548','2021-04-25 14:08:03','535','2021-04-25 14:10:27',10,0),('1','65',193080,'AFTERNOON','2021-04-24','2021-04-24 00:00:00',NULL,'548',100167.30,100167.30,'548','2021-04-25 14:12:39','535','2021-04-25 14:13:35',10,0),('1','65',193085,'MORNING','2021-04-25','2021-04-25 00:00:00',NULL,'548',310608.00,310608.00,'548','2021-04-25 14:17:37','535','2021-04-25 14:18:28',10,0),('1','65',193089,'AFTERNOON','2021-04-25','2021-04-25 00:00:00',NULL,'548',355241.70,355241.70,'548','2021-04-27 13:41:06','535','2021-04-27 13:44:59',10,0),('1','65',193543,'MORNING','2021-04-26','2021-04-26 00:00:00',NULL,'548',336447.00,336447.00,'548','2021-04-27 13:51:09','535','2021-04-27 13:52:46',10,0),('1','65',193546,'AFTERNOON','2021-04-26','2021-04-26 00:00:00',NULL,'548',7238.70,7238.70,'548','2021-04-27 13:56:50','535','2021-04-27 13:58:17',10,0),('1','65',193549,'MORNING','2021-04-27','2021-04-27 00:00:00',NULL,'548',116388.90,116388.90,'548','2021-04-27 14:00:56','535','2021-04-27 14:02:29',10,0),('1','65',193966,'AFTERNOON','2021-04-27','2021-04-27 00:00:00',NULL,'548',412651.80,412651.80,'548','2021-04-29 11:35:18','535','2021-04-29 11:44:07',10,0),('1','65',193992,'MORNING','2021-04-28','2021-04-28 00:00:00',NULL,'548',213075.90,213075.90,'548','2021-04-29 13:12:16','535','2021-04-29 13:42:53',10,0),('1','65',194080,'AFTERNOON','2021-04-28','2021-04-28 00:00:00',NULL,'548',53951.40,53951.40,'548','2021-04-30 06:32:36','535','2021-04-30 07:28:25',10,0),('1','65',194100,'MORNING','2021-04-29','2021-04-29 00:00:00',NULL,'548',277379.10,277379.10,'548','2021-04-30 07:42:44','535','2021-04-30 09:52:35',10,0),('1','65',194214,'AFTERNOON','2021-04-29','2021-04-29 00:00:00',NULL,'548',13170.60,13170.60,'548','2021-04-30 15:00:20','535','2021-04-30 15:59:07',10,0),('1','65',194383,'MORNING','2021-04-30','2021-04-30 00:00:00',NULL,'548',100421.10,100421.10,'548','2021-05-01 12:11:13','535','2021-05-01 15:01:57',10,0),('1','65',194540,'AFTERNOON','2021-05-01','2021-05-01 00:00:00',NULL,'548',333472.35,333472.35,'548','2021-05-02 10:05:58','535','2021-05-02 10:25:28',10,0),('1','65',194548,'MORNING','2021-05-01','2021-05-01 00:00:00',NULL,'548',117781.65,117781.65,'548','2021-05-02 10:31:37','535','2021-05-02 10:33:54',10,0),('1','65',194551,'AFTERNOON','2021-05-01','2021-05-01 00:00:00',NULL,'548',168267.30,168267.30,'548','2021-05-02 10:40:01','535','2021-05-02 13:31:00',10,0),('1','65',194582,'MORNING','2021-05-02','2021-05-02 00:00:00',NULL,'548',514956.00,514956.00,'548','2021-05-02 13:54:11','535','2021-05-02 15:19:58',10,0),('1','65',194749,'AFTERNOON','2021-05-02','2021-05-02 00:00:00',NULL,'548',583116.00,583116.00,'548','2021-05-03 09:50:26','535','2021-05-03 10:08:26',10,0),('1','65',194792,'MORNING','2021-05-03','2021-05-03 00:00:00',NULL,'548',248191.65,248191.65,'548','2021-05-03 12:46:09','535','2021-05-03 14:43:48',10,0),('1','65',194883,'AFTERNOON','2021-05-03','2021-05-03 00:00:00',NULL,'548',133754.55,133754.55,'548','2021-05-04 09:47:16','535','2021-05-04 13:01:01',10,0),('1','65',194952,'MORNING','2021-05-04','2021-05-04 00:00:00',NULL,'548',385786.20,385786.20,'548','2021-05-04 13:03:40','535','2021-05-04 13:06:56',10,0),('1','65',195103,'AFTERNOON','2021-05-04','2021-05-04 00:00:00',NULL,'548',190905.00,190905.00,'548','2021-05-05 10:01:14','535','2021-05-05 11:08:01',10,0),('1','65',195212,'MORNING','2021-05-05','2021-05-05 00:00:00',NULL,'548',313673.40,313673.40,'548','2021-05-05 13:07:24','535','2021-05-05 14:04:46',10,0),('1','65',195374,'AFTERNOON','2021-05-05','2021-05-05 00:00:00',NULL,'548',256532.10,256532.10,'548','2021-05-06 10:20:11','535','2021-05-06 10:32:02',10,0),('1','65',195445,'MORNING','2021-05-06','2021-05-06 00:00:00',NULL,'548',240727.20,240727.20,'548','2021-05-06 13:38:57','535','2021-05-06 14:40:12',10,0),('1','65',195572,'AFTERNOON','2021-05-06','2021-05-06 00:00:00',NULL,'548',119983.05,119983.05,'548','2021-05-07 08:39:11','535','2021-05-07 08:41:10',10,0),('1','65',195705,'MORNING','2021-05-07','2021-05-07 00:00:00',NULL,'548',267864.60,267864.60,'548','2021-05-07 15:46:28','535','2021-05-08 03:57:51',10,0),('1','65',195846,'AFTERNOON','2021-05-07','2021-05-07 00:00:00',NULL,'548',219273.15,219273.15,'548','2021-05-08 10:08:24','535','2021-05-08 11:00:01',10,0),('1','65',195930,'MORNING','2021-05-08','2021-05-08 00:00:00',NULL,'548',178950.45,178950.45,'548','2021-05-08 15:36:39','535','2021-05-08 20:32:22',10,0),('1','65',196168,'AFTERNOON','2021-05-08','2021-05-08 00:00:00',NULL,'548',272163.45,272163.45,'548','2021-05-09 16:04:38','535','2021-05-09 17:22:00',10,0),('1','65',196252,'MORNING','2021-05-09','2021-05-09 00:00:00',NULL,'548',205520.10,205520.10,'548','2021-05-10 07:29:16','535','2021-05-10 07:46:56',10,0),('1','65',196315,'AFTERNOON','2021-05-09','2021-05-09 00:00:00',NULL,'548',222201.90,222201.90,'548','2021-05-10 10:23:21','535','2021-05-10 10:35:19',10,0),('1','65',196345,'MORNING','2021-05-10','2021-05-10 00:00:00',NULL,'548',230871.75,230871.75,'548','2021-05-10 13:01:05','535','2021-05-10 13:22:10',10,0),('1','65',196438,'AFTERNOON','2021-05-10','2021-05-10 00:00:00',NULL,'548',181482.60,181482.60,'548','2021-05-11 05:13:37','535','2021-05-11 08:06:53',10,0),('1','65',196555,'MORNING','2021-05-11','2021-05-11 00:00:00',NULL,'548',197460.30,197460.30,'548','2021-05-11 14:16:19','535','2021-05-11 14:31:06',10,0),('1','65',196712,'AFTERNOON','2021-05-11','2021-05-11 00:00:00',NULL,'548',417734.85,417734.85,'548','2021-05-12 09:03:03','535','2021-05-12 09:57:42',10,0),('1','65',197471,'MORNING','2021-05-12','2021-05-12 00:00:00',NULL,'548',317363.70,317363.70,'548','2021-05-16 19:17:02','535','2021-05-17 12:08:36',10,0),('1','65',197717,'AFTERNOON','2021-05-12','2021-05-12 00:00:00',NULL,'548',360200.55,360200.55,'548','2021-05-17 13:34:05','535','2021-05-17 13:59:02',10,0),('1','65',197812,'MORNING','2021-05-13','2021-05-13 00:00:00',NULL,'548',377412.30,377412.30,'548','2021-05-17 17:06:22','535','2021-05-17 17:28:52',10,0),('1','65',197823,'AFTERNOON','2021-05-13','2021-05-13 00:00:00',NULL,'548',5602.50,5602.50,'548','2021-05-17 17:44:20','535','2021-05-17 17:48:02',10,0),('1','65',197828,'MORNING','2021-05-14','2021-05-14 00:00:00',NULL,'548',10608.30,10608.30,'548','2021-05-17 18:24:18','535','2021-05-17 18:25:23',10,0),('1','65',197830,'AFTERNOON','2021-05-14','2021-05-14 00:00:00',NULL,'548',22593.60,22593.60,'548','2021-05-17 18:30:33','535','2021-05-17 18:31:28',10,0),('1','65',197851,'MORNING','2021-05-15','2021-05-15 00:00:00',NULL,'548',191265.30,191265.30,'548','2021-05-17 22:07:29','535','2021-05-18 05:41:34',10,0),('1','65',197875,'AFTERNOON','2021-05-15','2021-05-15 00:00:00',NULL,'548',135270.45,135270.45,'548','2021-05-18 06:43:48','535','2021-05-18 06:48:01',10,0),('1','65',197884,'MORNING','2021-05-16','2021-05-16 00:00:00',NULL,'548',282930.30,282930.30,'548','2021-05-18 06:52:33','535','2021-05-18 07:03:01',10,0),('1','65',197900,'AFTERNOON','2021-05-16','2021-05-16 00:00:00',NULL,'548',312061.20,312061.20,'548','2021-05-18 07:53:35','535','2021-05-18 07:55:39',10,0),('1','65',197903,'MORNING','2021-05-17','2021-05-17 00:00:00',NULL,'548',406988.55,406988.55,'548','2021-05-18 08:00:56','535','2021-05-18 08:02:07',10,0),('1','65',197909,'AFTERNOON','2021-05-17','2021-05-17 00:00:00',NULL,'548',210706.80,210706.80,'548','2021-05-18 08:13:50','535','2021-05-18 08:21:14',10,0),('1','65',198188,'Morning','2021-05-18','2021-05-18 00:00:00',NULL,'548',239182.50,239182.50,'548','2021-05-19 10:15:48','535','2021-05-19 11:18:45',10,0),('1','65',198273,'Afternoon','2021-05-18','2021-05-18 00:00:00',NULL,'548',292977.00,292977.00,'548','2021-05-19 14:39:02','535','2021-05-19 14:43:59',10,0),('1','65',198302,'MORNING','2021-05-19','2021-05-19 00:00:00',NULL,'548',595820.85,595820.85,'548','2021-05-19 16:56:19','535','2021-05-19 20:26:48',10,0),('1','65',198512,'AFTERNOON','2021-05-19','2021-05-19 00:00:00',NULL,'548',300105.90,300105.90,'548','2021-05-20 15:47:31','535','2021-05-20 15:51:40',10,0),('1','65',198515,'MORNING','2021-05-20','2021-05-20 00:00:00',NULL,'548',210380.70,210380.70,'548','2021-05-20 15:59:18','535','2021-05-20 15:59:59',10,0),('1','65',198519,'AFTERNOON','2021-05-20','2021-05-20 00:00:00',NULL,'548',188616.45,188616.45,'548','2021-05-21 11:37:21','535','2021-05-21 14:10:03',10,0),('1','65',198734,'MORNING','2021-05-21','2021-05-21 00:00:00',NULL,'548',189162.60,189162.60,'548','2021-05-21 19:04:20','535','2021-05-22 08:15:55',10,0),('1','65',198868,'AFTERNOON','2021-05-21','2021-05-21 00:00:00',NULL,'548',145333.65,145333.65,'548','2021-05-22 11:12:38','535','2021-05-22 15:40:27',10,0),('1','65',198956,'MORNING','2021-05-22','2021-05-22 00:00:00',NULL,'548',679757.40,679757.40,'548','2021-05-22 19:00:52','535','2021-05-22 20:40:27',10,0),('1','65',199064,'AFTERNOON','2021-05-22','2021-05-22 00:00:00',NULL,'548',221428.35,221428.35,'548','2021-05-23 11:02:14','535','2021-05-23 11:25:05',10,0),('1','65',199328,'MORNING','2021-05-23','2021-05-23 00:00:00',NULL,'548',309469.35,309469.35,'548','2021-05-24 11:19:29','535','2021-05-24 11:29:29',10,0),('1','65',199333,'AFTERNOON','2021-05-23','2021-05-23 00:00:00',NULL,'548',803545.35,803545.35,'548','2021-05-24 11:34:30','535','2021-05-24 11:35:57',10,0),('1','65',199334,'MORNING','2021-05-24','2021-05-24 00:00:00',NULL,'548',474993.00,474993.00,'548','2021-05-24 18:53:45','535','2021-05-24 19:22:30',10,0),('1','65',199543,'AFTERNOON','2021-05-24','2021-05-24 00:00:00',NULL,'548',415864.80,415864.80,'548','2021-05-25 12:01:12','535','2021-05-25 12:08:14',10,0),('1','65',199556,'MORNING','2021-05-25','2021-05-25 00:00:00',NULL,'548',415483.65,415483.65,'548','2021-05-25 13:00:13','535','2021-05-25 13:32:02',10,0),('1','65',199759,'AFTERNOON','2021-05-25','2021-05-25 00:00:00',NULL,'548',458761.50,458761.50,'548','2021-05-26 10:38:19','535','2021-05-26 13:21:12',10,0),('1','65',199791,'MORNING','2021-05-26','2021-05-26 00:00:00',NULL,'548',316282.95,316282.95,'548','2021-05-26 13:26:31','535','2021-05-26 13:34:49',10,0),('1','65',199978,'AFTERNOON','2021-05-26','2021-05-26 00:00:00',NULL,'548',306561.90,306561.90,'548','2021-05-27 11:26:21','535','2021-05-27 13:21:28',10,0),('1','65',200167,'MORNING','2021-05-27','2021-05-27 00:00:00',NULL,'548',331920.75,331920.75,'548','2021-05-28 10:05:58','535','2021-05-28 10:08:15',10,0),('1','65',200177,'AFTERNOON','2021-05-27','2021-05-27 00:00:00',NULL,'548',582525.60,582525.60,'548','2021-05-28 10:37:26','535','2021-05-28 10:40:20',10,0),('1','65',200298,'MORNING','2021-05-28','2021-05-28 00:00:00',NULL,'548',311453.45,311453.45,'548','2021-05-29 06:47:55','535','2021-05-29 10:12:09',10,0),('1','65',200389,'AFTERNOON','2021-05-28','2021-05-28 00:00:00',NULL,'548',170742.00,170742.00,'548','2021-05-29 12:56:02','535','2021-05-29 13:20:40',10,0),('1','65',201036,'Morning Shift','2021-05-29','2021-05-29 00:00:00',NULL,'548',242624.25,242624.25,'548','2021-06-01 14:56:44','535','2021-06-01 14:57:39',10,0),('1','65',201049,'AFTERNOON SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'548',234297.80,234297.80,'548','2021-06-01 15:04:56','535','2021-06-01 15:06:08',10,0),('1','65',201052,'MORNING SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'548',320084.60,320084.60,'548','2021-06-01 15:08:14','535','2021-06-01 15:08:48',10,0),('1','65',201054,'AFTERNOON SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'548',419879.35,419879.35,'548','2021-06-01 15:11:22','535','2021-06-01 15:11:52',10,0),('1','65',201060,'MORNING SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'548',251108.00,251108.00,'548','2021-06-01 15:30:09','535','2021-06-01 15:30:38',10,0),('1','65',201062,'AFTERNOON SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'548',291869.60,291869.60,'548','2021-06-01 15:33:02','535','2021-06-01 15:33:44',10,0),('1','65',201063,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'548',350910.45,350910.45,'548','2021-06-01 15:36:05','535','2021-06-01 15:36:40',10,0),('1','65',201064,'AFTERNOON SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'548',263201.95,263201.95,'548','2021-06-02 11:11:43','535','2021-06-02 11:15:06',10,0),('1','65',201274,'MORNING','2021-06-02','2021-06-02 00:00:00',NULL,'548',205218.20,205218.20,'548','2021-06-03 08:50:40','535','2021-06-03 11:48:14',10,0),('1','65',201416,'AFTERNOON','2021-06-02','2021-06-02 00:00:00',NULL,'548',411664.55,411664.55,'548','2021-06-03 12:47:02','535','2021-06-03 12:48:52',10,0),('1','65',201418,'MORNING','2021-06-03','2021-06-03 00:00:00',NULL,'548',388268.65,388268.65,'548','2021-06-04 07:03:32','535','2021-06-04 10:12:12',10,0),('1','65',201614,'AFTERNOON','2021-06-03','2021-06-03 00:00:00',NULL,'548',372494.65,372494.65,'548','2021-06-04 11:29:34','535','2021-06-04 14:07:40',10,0),('1','65',201645,'MORNING','2021-06-04','2021-06-04 00:00:00',NULL,'548',305746.10,305746.10,'548','2021-06-04 15:42:13','535','2021-06-04 16:01:00',10,0),('1','65',201843,'AFTERNOON','2021-06-04','2021-06-04 00:00:00',NULL,'548',177717.10,177717.10,'548','2021-06-05 10:24:33','535','2021-06-05 11:34:26',10,0),('1','65',202103,'MORNING','2021-06-05','2021-06-05 00:00:00',NULL,'548',200765.30,200765.30,'548','2021-06-06 11:40:19','535','2021-06-06 13:46:49',10,0),('1','65',202181,'AFTERNOON','2021-06-05','2021-06-05 00:00:00',NULL,'548',344597.35,344597.35,'548','2021-06-06 19:15:54','535','2021-06-06 21:52:38',10,0),('1','65',202243,'MORNING','2021-06-06','2021-06-06 00:00:00',NULL,'548',356637.70,356637.70,'548','2021-06-07 07:48:02','535','2021-06-07 08:45:17',10,0),('1','65',202314,'AFTERNOON','2021-06-06','2021-06-06 00:00:00',NULL,'548',749036.90,749036.90,'548','2021-06-07 11:20:50','535','2021-06-07 11:46:42',10,0),('1','65',202384,'MORNING','2021-06-07','2021-06-07 00:00:00',NULL,'548',228936.60,228936.60,'548','2021-06-08 06:49:51','535','2021-06-08 09:46:16',10,0),('1','65',202613,'AFTERNOON','2021-06-07','2021-06-07 00:00:00',NULL,'548',181140.40,181140.40,'548','2021-06-08 18:23:17','535','2021-06-08 19:01:42',10,0),('1','65',202734,'MORNING','2021-06-08','2021-06-08 00:00:00',NULL,'548',17825.50,18149.60,'548','2021-06-09 10:34:02','535','2021-06-09 17:20:14',10,0),('1','65',202937,'AFTERNOON','2021-06-08','2021-06-08 00:00:00',NULL,'548',197564.40,199325.55,'548','2021-06-10 09:55:15','535','2021-06-10 10:20:37',10,0),('1','65',202957,'MORNING','2021-06-09','2021-06-09 00:00:00',NULL,'548',477395.05,481904.15,'548','2021-06-10 11:22:37','535','2021-06-10 14:02:47',10,0),('1','65',203052,'AFTERNOON','2021-06-09','2021-06-09 00:00:00',NULL,'548',460795.50,463845.45,'548','2021-06-10 16:08:37','535','2021-06-10 20:02:54',10,0),('1','65',203156,'MORNING','2021-06-10','2021-06-10 00:00:00',NULL,'548',300774.65,303619.15,'548','2021-06-11 09:04:56','535','2021-06-11 09:16:03',10,0),('1','65',203171,'AFTERNOON','2021-06-10','2021-06-10 00:00:00',NULL,'548',283574.50,285927.65,'548','2021-06-11 09:27:01','535','2021-06-11 13:15:55',10,0),('1','65',203420,'MORNING','2021-06-11','2021-06-11 00:00:00',NULL,'548',320316.15,322335.15,'548','2021-06-12 13:16:07','535','2021-06-12 13:20:19',10,0),('1','65',203425,'AFTERNOON','2021-06-11','2021-06-11 00:00:00',NULL,'548',204003.80,204842.20,'548','2021-06-12 13:23:27','535','2021-06-12 13:25:41',10,0),('1','65',203427,'MORNING','2021-06-12','2021-06-12 00:00:00',NULL,'548',159486.80,159745.75,'548','2021-06-12 13:28:22','535','2021-06-12 14:06:15',10,0),('1','65',203622,'AFTERNOON','2021-06-12','2021-06-12 00:00:00',NULL,'548',158015.00,158250.55,'548','2021-06-13 13:10:21','535','2021-06-13 13:41:55',10,0),('1','65',203672,'MORNING','2021-06-13','2021-06-13 00:00:00',NULL,'548',362758.55,367058.65,'548','2021-06-13 16:21:48','535','2021-06-13 20:41:15',10,0),('1','65',203786,'AFTERNOON','2021-06-13','2021-06-13 00:00:00',NULL,'548',296969.20,299094.65,'548','2021-06-14 08:52:21','535','2021-06-14 09:45:51',10,0),('1','65',204027,'MORNING','2021-06-14','2021-06-14 00:00:00',NULL,'548',405951.15,410015.55,'548','2021-06-15 09:24:51','535','2021-06-15 10:45:56',10,0),('1','65',204064,'AFTERNOON','2021-06-14','2021-06-14 00:00:00',NULL,'548',230445.05,232297.60,'548','2021-06-15 11:39:04','535','2021-06-15 13:44:25',10,0),('1','65',204118,'MORNING','2021-06-15','2021-06-15 00:00:00',NULL,'548',298711.60,302172.50,'548','2021-06-15 15:34:31','535','2021-06-15 17:09:01',10,0),('1','65',204278,'AFTERNOON','2021-06-15','2021-06-15 00:00:00',NULL,'548',491729.15,497968.75,'548','2021-06-16 10:30:59','535','2021-06-16 10:50:47',10,0),('1','65',204318,'MORNING','2021-06-16','2021-06-16 00:00:00',NULL,'548',193421.80,194456.15,'548','2021-06-16 13:48:09','535','2021-06-16 14:31:26',10,0),('1','65',204475,'AFTERNOON','2021-06-16','2021-06-16 00:00:00',NULL,'548',619345.65,624228.15,'548','2021-06-17 09:57:11','535','2021-06-17 10:42:27',10,0),('1','65',204519,'MORNING','2021-06-17','2021-06-17 00:00:00',NULL,'548',246305.40,248051.85,'548','2021-06-17 13:03:28','535','2021-06-17 14:53:00',10,0),('1','65',204663,'AFTERNOON','2021-06-17','2021-06-17 00:00:00',NULL,'548',318196.45,321512.90,'548','2021-06-18 08:21:35','535','2021-06-18 08:52:46',10,0),('1','65',204763,'MORNING','2021-06-18','2021-06-18 00:00:00',NULL,'548',245510.65,246833.30,'548','2021-06-18 15:49:48','535','2021-06-18 21:07:34',10,0),('1','65',204908,'AFTERNOON','2021-06-18','2021-06-18 00:00:00',NULL,'548',173276.95,173976.05,'548','2021-06-19 09:58:34','535','2021-06-19 11:13:15',10,0),('1','65',204949,'MORNING','2021-06-19','2021-06-19 00:00:00',NULL,'548',257009.50,259411.10,'548','2021-06-19 12:48:48','535','2021-06-19 13:22:07',10,0),('1','65',205194,'AFTERNOON','2021-06-19','2021-06-19 00:00:00',NULL,'548',164659.00,165634.55,'548','2021-06-20 18:30:36','535','2021-06-20 19:57:02',10,0),('1','65',205289,'MORNING','2021-06-20','2021-06-20 00:00:00',NULL,'548',567509.80,575143.25,'548','2021-06-21 08:48:40','535','2021-06-21 10:10:44',10,0),('1','65',205321,'AFTERNOON','2021-06-20','2021-06-20 00:00:00',NULL,'548',448052.00,453640.30,'548','2021-06-21 10:46:43','535','2021-06-21 10:55:31',10,0),('1','65',205349,'MORNING','2021-06-21','2021-06-21 00:00:00',NULL,'548',451618.20,456902.70,'548','2021-06-21 13:08:40','535','2021-06-21 13:56:24',10,0),('1','65',205512,'AFTERNOON','2021-06-21','2021-06-21 00:00:00',NULL,'548',806228.50,817989.95,'548','2021-06-22 08:00:44','535','2021-06-22 08:17:00',10,0),('1','65',205540,'AFTERNOON','2021-06-21','2021-06-21 00:00:00',NULL,'548',36767.50,37436.00,'548','2021-06-22 10:06:29','535','2021-06-22 12:50:38',10,0),('1','65',205606,'MORNING','2021-06-22','2021-06-22 00:00:00',NULL,'548',177969.90,177969.90,'548','2021-06-22 13:12:02','535','2021-06-22 13:22:39',10,0),('1','65',205654,'AFTERNOON','2021-06-22','2021-06-22 00:00:00',NULL,'548',155792.25,155792.25,'548','2021-06-23 09:06:45','535','2021-06-23 10:07:27',10,0),('1','65',205907,'MORNING','2021-06-23','2021-06-23 00:00:00',NULL,'548',422783.85,422783.85,'548','2021-06-23 17:18:39','535','2021-06-24 10:05:49',10,0),('1','65',206012,'AFTERNOON','2021-06-23','2021-06-23 00:00:00',NULL,'548',80335.80,80335.80,'548','2021-06-24 11:06:03','535','2021-06-24 13:37:32',10,0),('1','65',206117,'MORNING','2021-06-24','2021-06-24 00:00:00',NULL,'548',183673.95,183673.95,'548','2021-06-24 19:20:30','535','2021-06-25 06:42:11',10,0),('1','65',206285,'AFTERNOON','2021-06-24','2021-06-24 00:00:00',NULL,'548',541594.05,541594.05,'548','2021-06-25 14:24:37','535','2021-06-25 14:47:02',10,0),('1','65',206318,'MORNING','2021-06-25','2021-06-25 00:00:00',NULL,'548',92297.25,92297.25,'548','2021-06-25 16:41:10','535','2021-06-25 17:54:24',10,0),('1','65',206462,'AFTERNOON','2021-06-25','2021-06-25 00:00:00',NULL,'548',77830.65,77830.65,'548','2021-06-26 12:06:33','535','2021-06-26 17:37:01',10,0),('1','65',206536,'AFTERNOON','2021-06-26','2021-06-26 00:00:00',NULL,'548',160648.80,160648.80,'548','2021-06-26 19:09:20','535','2021-06-27 09:31:11',10,0),('1','65',206658,'AFTERNOON','2021-06-26','2021-06-26 00:00:00',NULL,'548',12622.65,12622.65,'548','2021-06-27 11:15:27','535','2021-06-27 14:05:56',10,0),('1','65',206893,'MORNING','2021-06-27','2021-06-27 00:00:00',NULL,'548',143085.60,143085.60,'548','2021-06-28 10:00:06','535','2021-06-28 10:17:38',10,0),('1','65',206908,'AFTERNOON','2021-06-27','2021-06-27 00:00:00',NULL,'548',568332.75,568332.75,'548','2021-06-28 10:45:03','535','2021-06-28 13:14:29',10,0),('1','65',206937,'MORNING','2021-06-28','2021-06-28 00:00:00',NULL,'548',537653.40,537653.40,'548','2021-06-28 13:18:05','535','2021-06-28 13:24:24',10,0),('1','65',207106,'AFTERNOON','2021-06-28','2021-06-28 00:00:00',NULL,'548',207708.75,207708.75,'548','2021-06-29 10:05:21','535','2021-06-29 12:57:06',10,0),('1','65',207166,'MORNING','2021-06-29','2021-06-29 00:00:00',NULL,'548',245673.00,245673.00,'548','2021-06-29 13:53:43','535','2021-06-29 14:06:44',10,0),('1','65',207312,'AFTERNOON','2021-06-29','2021-06-29 00:00:00',NULL,'548',139287.60,139287.60,'548','2021-06-30 08:55:18','535','2021-06-30 09:08:03',10,0),('1','65',207448,'MORNING','2021-06-30','2021-06-30 00:00:00',NULL,'548',427672.65,427672.65,'548','2021-06-30 19:16:35','535','2021-06-30 21:40:51',10,0),('1','65',207558,'AFTERNOON','2021-06-30','2021-06-30 00:00:00',NULL,'548',186817.05,186817.05,'548','2021-07-01 10:32:03','535','2021-07-01 13:03:46',10,0),('1','65',207606,'MORNING','2021-07-01','2021-07-01 00:00:00',NULL,'548',206370.90,206370.90,'548','2021-07-01 13:57:58','535','2021-07-01 15:58:32',10,0),('1','65',207765,'AFTERNOON','2021-07-01','2021-07-01 00:00:00',NULL,'548',204021.00,204021.00,'548','2021-07-02 11:01:28','535','2021-07-02 12:44:34',10,0),('1','65',207813,'MORNING','2021-07-02','2021-07-02 00:00:00',NULL,'548',234344.85,234344.85,'548','2021-07-02 13:03:22','535','2021-07-02 13:56:20',10,0),('1','65',207975,'AFTERNOON','2021-07-02','2021-07-02 00:00:00',NULL,'548',230222.40,230222.40,'548','2021-07-03 10:00:45','535','2021-07-03 11:02:15',10,0),('1','65',208072,'MORNING','2021-07-03','2021-07-03 00:00:00',NULL,'548',394259.85,394259.85,'548','2021-07-03 17:16:12','535','2021-07-03 19:21:40',10,0),('1','65',208169,'AFTERNOON','2021-07-03','2021-07-03 00:00:00',NULL,'548',162471.30,162471.30,'548','2021-07-04 09:33:36','535','2021-07-04 09:54:46',10,0),('1','65',208402,'MORNING','2021-07-04','2021-07-04 00:00:00',NULL,'548',216632.85,216632.85,'548','2021-07-05 09:18:15','535','2021-07-05 09:36:36',10,0),('1','65',208420,'AFTERNOON','2021-07-04','2021-07-04 00:00:00',NULL,'548',331806.90,331806.90,'548','2021-07-05 10:06:33','535','2021-07-05 10:21:33',10,0),('1','65',208460,'MORNING','2021-07-05','2021-07-05 00:00:00',NULL,'548',544404.00,544404.00,'548','2021-07-05 13:10:21','535','2021-07-05 14:26:17',10,0),('1','65',208624,'AFTERNOON','2021-07-05','2021-07-05 00:00:00',NULL,'548',128020.20,128020.20,'548','2021-07-06 10:09:58','535','2021-07-06 11:58:54',10,0),('1','65',208663,'MORNING','2021-07-06','2021-07-06 00:00:00',NULL,'548',360476.40,360476.40,'548','2021-07-06 13:00:10','535','2021-07-06 14:06:42',10,0),('1','65',208719,'AFTERNOON','2021-07-06','2021-07-06 00:00:00',NULL,'548',426241.95,426241.95,'548','2021-07-07 09:58:19','535','2021-07-07 10:06:18',10,0),('1','65',208906,'MORNING','2021-07-07','2021-07-07 00:00:00',NULL,'548',504562.80,504562.80,'548','2021-07-07 13:36:52','535','2021-07-07 13:56:56',10,0),('1','65',209053,'AFTERNOON','2021-07-07','2021-07-07 00:00:00',NULL,'548',404660.70,404660.70,'548','2021-07-08 09:20:13','535','2021-07-08 12:25:35',10,0),('1','65',209111,'MORNING','2021-07-08','2021-07-08 00:00:00',NULL,'548',234750.60,234750.60,'548','2021-07-08 12:59:35','535','2021-07-08 13:15:11',10,0),('1','65',209260,'AFTERNOON','2021-07-08','2021-07-08 00:00:00',NULL,'548',143238.00,143238.00,'548','2021-07-09 12:57:00','535','2021-07-09 13:43:25',10,0),('1','65',209384,'MORNING','2021-07-09','2021-07-09 00:00:00',NULL,'548',207885.45,207885.45,'548','2021-07-09 17:01:43','535','2021-07-10 07:58:25',10,0),('1','65',209542,'AFTERNOON','2021-07-09','2021-07-09 00:00:00',NULL,'548',301771.50,301771.50,'548','2021-07-10 13:18:14','535','2021-07-10 13:35:50',10,0),('1','65',209561,'MORNING','2021-07-10','2021-07-10 00:00:00',NULL,'548',15700.60,15700.60,'548','2021-07-10 13:40:09','535','2021-07-10 14:11:43',10,0),('1','65',209708,'AFTERNOON','2021-07-10','2021-07-10 00:00:00',NULL,'548',124091.00,124091.00,'548','2021-07-11 12:48:29','535','2021-07-11 12:53:39',10,0),('1','65',209937,'MORNING','2021-07-11','2021-07-11 00:00:00',NULL,'548',195439.70,195439.70,'548','2021-07-12 09:45:59','535','2021-07-12 09:52:03',10,0),('1','65',209943,'AFTERNOON','2021-07-11','2021-07-11 00:00:00',NULL,'548',672115.60,672115.60,'548','2021-07-12 09:56:20','535','2021-07-12 09:56:41',10,0),('1','65',209945,'MORNING','2021-07-12','2021-07-12 00:00:00',NULL,'548',234001.00,234001.00,'548','2021-07-12 13:37:45','535','2021-07-12 13:41:56',10,0),('1','65',210157,'AFTERNOON','2021-07-12','2021-07-12 00:00:00',NULL,'548',112491.00,112491.00,'548','2021-07-13 09:04:43','535','2021-07-13 09:57:38',10,0),('1','65',210205,'MORNING','2021-07-13','2021-07-13 00:00:00',NULL,'548',396253.10,396253.10,'548','2021-07-13 12:59:06','535','2021-07-13 13:41:26',10,0),('1','65',210259,'AFTERNOON','2021-07-13','2021-07-13 00:00:00',NULL,'548',217484.35,217484.35,'548','2021-07-14 09:16:03','535','2021-07-14 09:23:31',10,0),('1','65',210439,'MORNING','2021-07-14','2021-07-14 00:00:00',NULL,'548',490523.20,490523.20,'548','2021-07-14 14:27:53','535','2021-07-14 15:12:00',10,0),('1','65',210591,'AFTERNOON','2021-07-14','2021-07-14 00:00:00',NULL,'548',718574.60,718574.60,'548','2021-07-15 10:37:08','535','2021-07-15 11:15:06',10,0),('1','65',210632,'MORNING','2021-07-15','2021-07-15 00:00:00',NULL,'548',830638.00,830638.00,'548','2021-07-15 12:51:42','535','2021-07-15 14:25:15',10,0),('1','65',210787,'AFTERNOON','2021-07-15','2021-07-15 00:00:00',NULL,'548',505864.30,505864.30,'548','2021-07-16 09:17:53','535','2021-07-16 09:22:56',10,0),('1','65',210887,'MORNING','2021-07-16','2021-07-16 00:00:00',NULL,'548',456135.35,456135.35,'548','2021-07-16 16:22:49','535','2021-07-16 18:45:19',10,0),('1','65',211010,'AFTERNOON','2021-07-16','2021-07-16 00:00:00',NULL,'548',829823.25,829823.25,'548','2021-07-17 09:17:16','535','2021-07-17 10:19:30',10,0),('1','65',211094,'MORNING','2021-07-17','2021-07-17 00:00:00',NULL,'548',151452.50,151452.50,'548','2021-07-17 15:09:24','535','2021-07-17 15:17:45',10,0),('1','65',211341,'AFTERNOON','2021-07-17','2021-07-17 00:00:00',NULL,'548',155418.45,155418.45,'548','2021-07-18 19:28:49','535','2021-07-18 22:03:00',10,0),('1','65',211364,'MORNING','2021-07-18','2021-07-18 00:00:00',NULL,'548',440336.45,440336.45,'548','2021-07-19 05:58:29','535','2021-07-19 07:52:41',10,0),('1','65',211516,'AFTERNOON','2021-07-18','2021-07-18 00:00:00',NULL,'548',597782.40,597782.40,'548','2021-07-19 13:45:42','535','2021-07-19 15:05:31',10,0),('1','65',212076,'MORNING SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'548',169243.15,169243.15,'548','2021-07-22 16:51:59','535','2021-07-22 21:16:43',10,0),('1','65',212218,'Afternoon ','2021-07-19','2021-07-19 00:00:00',NULL,'548',329851.55,329851.55,'548','2021-07-23 05:26:22','535','2021-07-23 08:24:11',10,0),('1','65',212272,'Morning ','2021-07-20','2021-07-20 00:00:00',NULL,'548',732709.90,732709.90,'548','2021-07-23 08:31:48','535','2021-07-23 08:33:30',10,0),('1','65',212274,'Afternoon ','2021-07-20','2021-07-20 00:00:00',NULL,'548',119240.10,119240.10,'548','2021-07-23 08:36:05','535','2021-07-23 08:55:10',10,0),('1','65',212297,'Morning ','2021-07-21','2021-07-21 00:00:00',NULL,'548',145575.65,145575.65,'548','2021-07-23 09:20:58','535','2021-07-23 09:49:07',10,0),('1','65',212312,'Afternoon ','2021-07-21','2021-07-21 00:00:00',NULL,'548',120716.60,120716.60,'548','2021-07-23 10:11:43','535','2021-07-23 10:41:21',10,0),('1','65',212320,'Morning ','2021-07-22','2021-07-22 00:00:00',NULL,'548',161324.40,161324.40,'548','2021-07-23 10:49:48','535','2021-07-23 10:50:38',10,0),('1','65',212325,'Afternoon ','2021-07-22','2021-07-22 00:00:00',NULL,'548',358334.85,358334.85,'548','2021-07-23 10:54:56','535','2021-07-23 11:13:59',10,0),('1','65',212380,'Morning ','2021-07-23','2021-07-23 00:00:00',NULL,'548',384943.70,384943.70,'548','2021-07-24 05:26:27','535','2021-07-24 09:13:51',10,0),('1','65',212542,'Afternoon ','2021-07-23','2021-07-23 00:00:00',NULL,'548',194726.80,194726.80,'548','2021-07-24 12:53:18','535','2021-07-24 13:45:42',10,0),('1','65',212587,'Morning ','2021-07-24','2021-07-24 00:00:00',NULL,'548',457771.55,457771.55,'548','2021-07-24 15:23:42','535','2021-07-24 19:32:50',10,0),('1','65',212645,'AFTERNOON','2021-07-24','2021-07-24 00:00:00',NULL,'548',317786.15,317786.15,'548','2021-07-25 14:11:00','535','2021-07-25 14:46:23',10,0),('1','65',212890,'Morning ','2021-07-25','2021-07-25 00:00:00',NULL,'548',594324.10,594324.10,'548','2021-07-26 07:27:35','535','2021-07-26 08:14:03',10,0),('1','65',212931,'Afternoon ','2021-07-25','2021-07-25 00:00:00',NULL,'548',269683.80,269683.80,'548','2021-07-26 09:05:38','535','2021-07-26 09:50:09',10,0),('1','65',213149,'Morning ','2021-07-26','2021-07-26 00:00:00',NULL,'548',241221.75,241221.75,'548','2021-07-27 07:27:44','202','2021-07-27 10:19:51',10,0),('1','65',213266,'Afternoon ','2021-07-26','2021-07-26 00:00:00',NULL,'548',181691.35,181691.35,'548','2021-07-27 11:38:27','535','2021-07-27 13:30:03',10,0),('1','65',213348,'MORNING','2021-07-27','2021-07-27 00:00:00',NULL,'548',309440.10,309440.10,'548','2021-07-27 17:04:41','535','2021-07-27 23:28:05',10,0),('1','65',213449,'AFTERNOON','2021-07-27','2021-07-27 00:00:00',NULL,'548',651238.35,651238.35,'548','2021-07-28 09:09:36','535','2021-07-28 09:16:10',10,0),('1','65',213535,'MORNING','2021-07-28','2021-07-28 00:00:00',NULL,'548',223272.15,223272.15,'548','2021-07-28 13:54:10','535','2021-07-28 17:25:10',10,0),('1','65',213717,'AFTERNOON','2021-07-28','2021-07-28 00:00:00',NULL,'548',1103668.45,1103668.45,'548','2021-07-29 12:00:37','535','2021-07-29 13:43:33',10,0),('1','65',213839,'MORNING','2021-07-29','2021-07-29 00:00:00',NULL,'548',350951.00,350951.00,'548','2021-07-29 18:06:25','535','2021-07-29 19:01:24',10,0),('1','65',213919,'AFTERNOON','2021-07-29','2021-07-29 00:00:00',NULL,'548',884763.90,884763.90,'548','2021-07-30 08:04:51','535','2021-07-30 09:22:53',10,0),('1','65',214087,'MORNING','2021-07-30','2021-07-30 00:00:00',NULL,'548',955968.90,955968.90,'548','2021-07-31 05:56:27','535','2021-07-31 10:16:07',10,0),('1','65',214212,'AFTERNOON','2021-07-30','2021-07-30 00:00:00',NULL,'548',558578.15,558578.15,'548','2021-07-31 13:19:20','535','2021-07-31 14:04:30',10,0),('1','65',214269,'MORNING','2021-07-31','2021-07-31 00:00:00',NULL,'548',489684.65,489684.65,'548','2021-07-31 16:37:00','535','2021-07-31 17:16:01',10,0),('1','65',214530,'AFTERNOON','2021-07-31','2021-07-31 00:00:00',NULL,'548',483445.35,483445.35,'548','2021-08-02 13:16:19','535','2021-08-02 14:06:21',10,0),('1','65',214722,'MORNING','2021-08-01','2021-08-01 00:00:00',NULL,'548',194785.80,194785.80,'548','2021-08-02 15:57:10','535','2021-08-02 18:23:39',10,0),('1','65',214750,'AFTERNOON','2021-08-01','2021-08-01 00:00:00',NULL,'548',134809.95,134809.95,'548','2021-08-02 19:17:57','535','2021-08-02 20:14:35',10,0),('1','65',214824,'MORNING','2021-08-02','2021-08-02 00:00:00',NULL,'548',144173.70,144173.70,'548','2021-08-03 08:57:33','535','2021-08-03 09:44:38',10,0),('1','65',214851,'AFTERNOON','2021-08-02','2021-08-02 00:00:00',NULL,'548',205095.00,205095.00,'548','2021-08-03 09:56:01','535','2021-08-03 10:06:22',10,0),('1','65',214950,'MORNING','2021-08-03','2021-08-03 00:00:00',NULL,'548',160980.60,160980.60,'548','2021-08-03 15:57:34','535','2021-08-03 16:01:25',10,0),('1','65',215148,'AFTERNOON','2021-08-03','2021-08-03 00:00:00',NULL,'548',0.00,0.00,'548','2021-08-04 14:38:51','535','2021-08-04 14:39:27',10,0),('1','65',215160,'MORNING','2021-08-04','2021-08-04 00:00:00',NULL,'548',0.00,0.00,'548','2021-08-04 15:08:29','535','2021-08-04 17:01:46',10,0),('1','65',215205,'AFTERNOON','2021-08-04','2021-08-04 00:00:00',NULL,'548',120466.20,120466.20,'548','2021-08-05 08:52:07','535','2021-08-05 09:35:27',10,0),('1','65',215458,'MORNING','2021-08-05','2021-08-05 00:00:00',NULL,'548',219161.40,219161.40,'548','2021-08-06 07:13:30','535','2021-08-06 09:31:19',10,0),('1','65',215571,'AFTERNOON','2021-08-05','2021-08-05 00:00:00',NULL,'548',104099.60,104099.60,'548','2021-08-06 13:00:44','535','2021-08-06 14:15:33',10,0),('1','65',215612,'MORNING','2021-08-06','2021-08-06 00:00:00',NULL,'548',29175.50,29175.50,'548','2021-08-06 16:38:11','535','2021-08-06 20:29:38',10,0),('1','65',215731,'AFTERNOON','2021-08-06','2021-08-06 00:00:00',NULL,'548',31756.75,31756.75,'548','2021-08-07 09:56:14','535','2021-08-07 10:41:28',10,0),('1','65',215969,'MORNING','2021-08-07','2021-08-07 00:00:00',NULL,'548',14750.00,14750.00,'548','2021-08-08 10:05:44','535','2021-08-08 10:45:36',10,0),('1','65',216030,'AFTERNOON','2021-08-07','2021-08-07 00:00:00',NULL,'548',919340.95,919340.95,'548','2021-08-08 15:25:56','535','2021-08-08 16:03:34',10,0),('1','65',216199,'MORNING','2021-08-08','2021-08-08 00:00:00',NULL,'548',21747.40,21747.40,'548','2021-08-09 11:00:50','535','2021-08-09 13:24:52',10,0),('1','65',216266,'AFTERNOON','2021-08-08','2021-08-08 00:00:00',NULL,'548',252363.65,252363.65,'548','2021-08-09 15:22:18','535','2021-08-09 15:57:16',10,0),('1','65',216284,'MORNING','2021-08-09','2021-08-09 00:00:00',NULL,'548',205827.40,205827.40,'548','2021-08-09 17:18:17','535','2021-08-09 18:28:55',10,0),('1','65',216426,'AFTERNOON','2021-08-09','2021-08-09 00:00:00',NULL,'548',697524.55,697524.55,'548','2021-08-10 11:17:23','535','2021-08-10 13:42:11',10,0),('1','65',216565,'MORNING','2021-08-10','2021-08-10 00:00:00',NULL,'548',146128.25,146128.25,'548','2021-08-11 06:51:50','535','2021-08-11 09:21:33',10,0),('1','65',216670,'AFTERNOON','2021-08-10','2021-08-10 00:00:00',NULL,'548',231052.85,231052.85,'548','2021-08-11 12:56:25','535','2021-08-11 13:28:40',10,0),('1','65',216719,'AFTERNOON','2021-08-10','2021-08-10 00:00:00',NULL,'548',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',216732,'MORNING SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'548',567727.50,567727.50,'548','2021-08-11 16:07:47','535','2021-08-11 16:16:37',10,0),('1','65',216786,'AFTERNOON','2021-08-11','2021-08-11 00:00:00',NULL,'548',897800.95,897800.95,'548','2021-08-12 07:12:56','535','2021-08-12 09:55:24',10,0),('1','65',217028,'MORNING','2021-08-12','2021-08-12 00:00:00',NULL,'548',123597.40,123597.40,'548','2021-08-13 06:58:30','535','2021-08-13 08:43:57',10,0),('1','65',217094,'AFTERNOON','2021-08-12','2021-08-12 00:00:00',NULL,'548',969086.05,969086.05,'548','2021-08-13 11:51:28','535','2021-08-13 12:31:45',10,0),('1','65',217246,'MORNING','2021-08-13','2021-08-13 00:00:00',NULL,'548',156600.90,156600.90,'548','2021-08-13 19:12:05','535','2021-08-13 21:30:40',10,0),('1','65',217349,'AFTERNOON','2021-08-13','2021-08-13 00:00:00',NULL,'548',560671.10,560671.10,'548','2021-08-14 10:46:08','535','2021-08-14 10:52:16',10,0),('1','65',217413,'MORNING','2021-08-14','2021-08-14 00:00:00',NULL,'548',399317.80,399317.80,'548','2021-08-14 13:56:42','535','2021-08-14 14:03:28',10,0),('1','65',217575,'AFTERNOON','2021-08-14','2021-08-14 00:00:00',NULL,'548',352497.65,352497.65,'548','2021-08-15 13:08:30','535','2021-08-15 14:03:52',10,0),('1','65',217646,'MORNING','2021-08-15','2021-08-15 00:00:00',NULL,'548',398779.00,398779.00,'548','2021-08-15 18:14:05','535','2021-08-15 20:27:05',10,0),('1','65',217834,'AFTERNOON','2021-08-15','2021-08-15 00:00:00',NULL,'548',174984.50,174984.50,'548','2021-08-16 11:11:28','535','2021-08-16 14:29:34',10,0),('1','65',217938,'MORNING','2021-08-16','2021-08-16 00:00:00',NULL,'548',353350.60,353350.60,'548','2021-08-16 17:17:06','535','2021-08-17 09:47:45',10,0),('1','65',218060,'AFTERNOON','2021-08-16','2021-08-16 00:00:00',NULL,'548',141807.60,141807.60,'548','2021-08-17 09:57:17','535','2021-08-17 11:02:31',10,0),('1','65',218150,'MORNING','2021-08-17','2021-08-17 00:00:00',NULL,'548',122457.45,122457.45,'548','2021-08-17 15:20:24','535','2021-08-17 17:01:24',10,0),('1','65',218281,'AFTERNOON','2021-08-17','2021-08-17 00:00:00',NULL,'548',150518.05,150518.05,'548','2021-08-18 09:22:56','535','2021-08-18 09:53:23',10,0),('1','65',218367,'MORNING','2021-08-18','2021-08-18 00:00:00',NULL,'548',155318.30,155318.30,'548','2021-08-18 14:01:21','535','2021-08-18 14:02:17',10,0),('1','65',218540,'AFTERNOON','2021-08-18','2021-08-18 00:00:00',NULL,'548',247943.50,247943.50,'548','2021-08-19 10:48:54','535','2021-08-19 10:51:47',10,0),('1','65',218595,'MORNING','2021-08-19','2021-08-19 00:00:00',NULL,'548',359760.00,359760.00,'548','2021-08-19 14:54:48','535','2021-08-19 14:55:22',10,0),('1','65',218768,'AFTERNOON','2021-08-19','2021-08-19 00:00:00',NULL,'548',390435.45,390435.45,'548','2021-08-20 10:41:35','535','2021-08-20 11:22:03',10,0),('1','65',218876,'MORNING','2021-08-20','2021-08-20 00:00:00',NULL,'548',157303.95,157303.95,'548','2021-08-20 19:14:17','535','2021-08-20 21:17:25',10,0),('1','65',218957,'AFTERNOON','2021-08-20','2021-08-20 00:00:00',NULL,'548',131634.30,131634.30,'548','2021-08-21 13:37:02','535','2021-08-21 13:54:19',10,0),('1','65',219082,'MORNING','2021-08-21','2021-08-21 00:00:00',NULL,'548',121358.15,121358.15,'548','2021-08-21 18:24:50','535','2021-08-21 19:03:03',10,0),('1','65',219221,'AFTERNOON','2021-08-21','2021-08-21 00:00:00',NULL,'548',604356.45,604356.45,'548','2021-08-22 16:57:50','535','2021-08-23 06:42:14',10,0),('1','65',219423,'MORNING','2021-08-22','2021-08-22 00:00:00',NULL,'548',320767.90,320767.90,'548','2021-08-23 09:37:02','535','2021-08-23 10:18:55',10,0),('1','65',219467,'AFTERNOON','2021-08-22','2021-08-22 00:00:00',NULL,'548',399886.65,399886.65,'548','2021-08-23 11:44:24','535','2021-08-23 11:58:05',10,0),('1','65',219546,'MORNING','2021-08-23','2021-08-23 00:00:00',NULL,'548',400130.25,400130.25,'548','2021-08-23 17:16:52','535','2021-08-23 21:46:12',10,0),('1','65',219667,'AFTERNOON','2021-08-23','2021-08-23 00:00:00',NULL,'548',268361.65,268361.65,'548','2021-08-24 09:29:36','535','2021-08-24 11:44:33',10,0),('1','65',219747,'MORNING','2021-08-24','2021-08-24 00:00:00',NULL,'548',421698.30,421698.30,'548','2021-08-24 15:02:37','535','2021-08-24 15:09:35',10,0),('1','65',219906,'AFTERNOON','2021-08-24','2021-08-24 00:00:00',NULL,'548',640343.90,640343.90,'548','2021-08-25 10:47:16','535','2021-08-25 11:41:39',10,0),('1','65',220005,'MORNING','2021-08-25','2021-08-25 00:00:00',NULL,'548',287021.65,287021.65,'548','2021-08-25 19:01:08','535','2021-08-25 22:00:12',10,0),('1','65',220144,'AFTERNOON','2021-08-25','2021-08-25 00:00:00',NULL,'548',386141.10,386141.10,'548','2021-08-26 12:16:52','535','2021-08-26 12:26:40',10,0),('1','65',220214,'MORNING','2021-08-26','2021-08-26 00:00:00',NULL,'548',97865.30,97865.30,'548','2021-08-26 19:16:45','535','2021-08-26 21:45:00',10,0),('1','65',220316,'AFTERNOON','2021-08-26','2021-08-26 00:00:00',NULL,'548',384510.00,384510.00,'548','2021-08-27 09:46:25','535','2021-08-27 09:54:57',10,0),('1','65',220366,'MORNING','2021-08-27','2021-08-27 00:00:00',NULL,'548',120008.50,120008.50,'548','2021-08-27 13:02:18','535','2021-08-27 13:28:17',10,0),('1','65',220532,'AFTERNOON','2021-08-27','2021-08-27 00:00:00',NULL,'548',159174.35,159174.35,'548','2021-08-28 10:23:11','535','2021-08-28 11:00:48',10,0),('1','65',220659,'MORNING','2021-08-28','2021-08-28 00:00:00',NULL,'548',821263.55,821263.55,'548','2021-08-28 19:28:42','535','2021-08-28 21:10:56',10,0),('1','65',220768,'AFTERNOON','2021-08-28','2021-08-28 00:00:00',NULL,'548',320229.60,320229.60,'548','2021-08-29 11:47:15','535','2021-08-29 11:59:29',10,0),('1','65',220981,'MORNING','2021-08-29','2021-08-29 00:00:00',NULL,'548',140863.15,140863.15,'548','2021-08-30 09:17:38','535','2021-08-30 10:01:35',10,0),('1','65',221019,'AFTERNOON','2021-08-29','2021-08-29 00:00:00',NULL,'548',400553.20,400553.20,'548','2021-08-30 10:36:59','535','2021-08-30 11:33:55',10,0),('1','65',221244,'MORNING','2021-08-30','2021-08-30 00:00:00',NULL,'548',518937.05,518937.05,'548','2021-09-01 09:35:42','535','2021-09-01 10:04:53',10,0),('1','65',221472,'AFTERNOON','2021-08-30','2021-08-30 00:00:00',NULL,'548',343224.70,343224.70,'548','2021-09-01 10:18:37','535','2021-09-01 10:28:09',10,0),('1','65',221478,'MORNING','2021-08-31','2021-08-31 00:00:00',NULL,'548',298879.50,298879.50,'548','2021-09-01 10:40:51','535','2021-09-01 11:13:16',10,0),('1','65',221496,'AFTERNOON','2021-08-31','2021-08-31 00:00:00',NULL,'548',209762.05,209762.05,'548','2021-09-01 12:10:07','535','2021-09-01 13:22:34',10,0),('1','65',221585,'MORNING','2021-09-01','2021-09-01 00:00:00',NULL,'548',223307.45,223307.45,'548','2021-09-01 19:24:47','535','2021-09-02 07:43:17',10,0),('1','65',221680,'AFTERNOON','2021-09-01','2021-09-01 00:00:00',NULL,'548',604602.70,604602.70,'548','2021-09-02 09:23:06','535','2021-09-02 09:47:53',10,0),('1','65',221799,'MORNING','2021-09-02','2021-09-02 00:00:00',NULL,'548',225718.00,225718.00,'548','2021-09-03 10:19:28','535','2021-09-03 11:23:22',10,0),('1','65',221931,'AFTERNOON','2021-09-02','2021-09-02 00:00:00',NULL,'548',336120.70,336120.70,'548','2021-09-03 11:41:24','535','2021-09-03 11:46:04',10,0),('1','65',221946,'MORNING','2021-09-03','2021-09-03 00:00:00',NULL,'548',279805.30,279805.30,'548','2021-09-03 13:12:36','535','2021-09-03 14:19:42',10,0),('1','65',222170,'AFTERNOON','2021-09-03','2021-09-03 00:00:00',NULL,'548',277847.25,277847.25,'548','2021-09-04 13:33:22','535','2021-09-04 13:35:25',10,0),('1','65',222174,'MORNING','2021-09-04','2021-09-04 00:00:00',NULL,'548',326620.20,326620.20,'548','2021-09-04 13:42:13','535','2021-09-04 13:45:04',10,0),('1','65',222357,'AFTERNOON','2021-09-04','2021-09-04 00:00:00',NULL,'548',207250.10,207250.10,'548','2021-09-05 11:43:44','535','2021-09-05 13:09:04',10,0),('1','65',222433,'MORNING','2021-09-05','2021-09-05 00:00:00',NULL,'548',295586.05,295586.05,'548','2021-09-05 16:05:14','535','2021-09-05 19:09:01',10,0),('1','65',222563,'AFTERNOON','2021-09-05','2021-09-05 00:00:00',NULL,'548',131736.95,131736.95,'548','2021-09-06 09:44:51','535','2021-09-06 09:54:41',10,0),('1','65',222774,'MORNING','2021-09-06','2021-09-06 00:00:00',NULL,'548',136485.95,136485.95,'548','2021-09-07 08:56:51','535','2021-09-07 09:40:44',10,0),('1','65',222827,'AFTERNOON','2021-09-06','2021-09-06 00:00:00',NULL,'548',1000052.35,1000052.35,'548','2021-09-07 12:09:57','535','2021-09-07 12:11:05',10,0),('1','65',222921,'MORNING','2021-09-07','2021-09-07 00:00:00',NULL,'548',564452.65,564452.65,'548','2021-09-07 19:07:15','535','2021-09-07 22:09:45',10,0),('1','65',223019,'AFTERNOON','2021-09-07','2021-09-07 00:00:00',NULL,'548',343096.60,343096.60,'548','2021-09-08 10:26:29','535','2021-09-08 12:11:09',10,0),('1','65',223148,'MORNING','2021-09-08','2021-09-08 00:00:00',NULL,'548',614957.10,614957.10,'548','2021-09-08 19:12:33','535','2021-09-08 21:36:58',10,0),('1','65',223171,'AFTERNOON','2021-09-08','2021-09-08 00:00:00',NULL,'548',312630.45,312630.45,'548','2021-09-09 05:44:05','535','2021-09-09 09:03:37',10,0),('1','65',223358,'AFTERNOON','2021-09-08','2021-09-08 00:00:00',NULL,'548',248286.75,248286.75,'548','2021-09-09 16:24:37','535','2021-09-09 19:02:39',10,0),('1','65',223398,'MORNING','2021-09-09','2021-09-09 00:00:00',NULL,'548',153220.55,153220.55,'548','2021-09-09 21:25:23','535','2021-09-10 08:27:42',10,0),('1','65',223531,'AFTERNOON','2021-09-09','2021-09-09 00:00:00',NULL,'548',352404.65,352404.65,'548','2021-09-10 13:21:58','535','2021-09-10 16:56:26',10,0),('1','65',223623,'MORNING','2021-09-10','2021-09-10 00:00:00',NULL,'548',215208.90,215208.90,'548','2021-09-10 22:19:47','535','2021-09-11 07:14:29',10,0),('1','65',223825,'AFTERNOON','2021-09-10','2021-09-10 00:00:00',NULL,'548',87636.65,87636.65,'548','2021-09-11 16:56:14','535','2021-09-11 20:07:43',10,0),('1','65',224037,'MORNING','2021-09-11','2021-09-11 00:00:00',NULL,'548',277836.15,277836.15,'548','2021-09-12 18:17:34','535','2021-09-12 20:05:24',10,0),('1','65',224068,'AFTERNOON','2021-09-11','2021-09-11 00:00:00',NULL,'548',103876.40,103876.40,'548','2021-09-13 05:31:01','535','2021-09-13 09:07:14',10,0),('1','65',224151,'MORNING','2021-09-12','2021-09-12 00:00:00',NULL,'548',670388.85,670388.85,'548','2021-09-13 09:53:42','535','2021-09-13 10:05:48',10,0),('1','65',224160,'AFTERNOON','2021-09-12','2021-09-12 00:00:00',NULL,'548',581268.65,581268.65,'548','2021-09-13 11:25:26','535','2021-09-13 12:06:25',10,0),('1','65',224284,'MORNING','2021-09-13','2021-09-13 00:00:00',NULL,'548',149468.25,149468.25,'548','2021-09-13 19:39:29','535','2021-09-13 20:23:19',10,0),('1','65',224483,'AFTERNOON','2021-09-13','2021-09-13 00:00:00',NULL,'548',259961.40,259961.40,'548','2021-09-14 16:39:52','535','2021-09-14 19:31:22',10,0),('1','65',224516,'MORNING','2021-09-14','2021-09-14 00:00:00',NULL,'548',315780.10,315780.10,'548','2021-09-15 06:14:06','535','2021-09-15 09:01:27',10,0),('1','65',224597,'AFTERNOON','2021-09-14','2021-09-14 00:00:00',NULL,'548',135837.70,135837.70,'548','2021-09-15 09:26:19','535','2021-09-15 11:12:54',10,0),('1','65',224748,'MORNING','2021-09-15','2021-09-15 00:00:00',NULL,'548',133388.00,133388.00,'548','2021-09-15 18:57:52','535','2021-09-16 04:19:42',10,0),('1','65',224844,'AFTERNOON','2021-09-15','2021-09-15 00:00:00',NULL,'548',512419.55,512419.55,'548','2021-09-16 09:49:55','535','2021-09-16 10:39:53',10,0),('1','65',225149,'MORNING','2021-09-16','2021-09-16 00:00:00',NULL,'548',318107.80,318107.80,'548','2021-09-17 13:40:30','535','2021-09-17 13:51:41',10,0),('1','65',225157,'AFTERNOON','2021-09-16','2021-09-16 00:00:00',NULL,'548',412880.55,412880.55,'548','2021-09-17 13:58:09','535','2021-09-17 14:00:10',10,0),('1','65',225159,'MORNING','2021-09-17','2021-09-17 00:00:00',NULL,'548',99587.45,99587.45,'548','2021-09-17 14:04:16','535','2021-09-17 14:25:44',10,0),('1','65',225393,'AFTERNOON','2021-09-17','2021-09-17 00:00:00',NULL,'548',281275.35,281275.35,'548','2021-09-18 16:47:01','535','2021-09-18 19:31:12',10,0),('1','65',225635,'MORNING','2021-09-18','2021-09-18 00:00:00',NULL,'548',435463.25,435463.25,'548','2021-09-19 15:31:39','535','2021-09-19 20:28:48',10,0),('1','65',225693,'AFTERNOON','2021-09-18','2021-09-18 00:00:00',NULL,'548',758078.85,758078.85,'548','2021-09-20 06:05:43','535','2021-09-20 08:35:50',10,0),('1','65',225851,'MORNING','2021-09-19','2021-09-19 00:00:00',NULL,'548',142665.05,142665.05,'548','2021-09-20 12:41:29','535','2021-09-20 12:49:50',10,0),('1','65',225856,'AFTERNOON','2021-09-19','2021-09-19 00:00:00',NULL,'548',242430.45,242430.45,'548','2021-09-20 12:58:43','535','2021-09-20 13:03:06',10,0),('1','65',225919,'MORNING','2021-09-20','2021-09-20 00:00:00',NULL,'548',249722.90,249722.90,'548','2021-09-20 16:08:34','535','2021-09-20 16:47:01',10,0),('1','65',226062,'AFTERNOON','2021-09-20','2021-09-20 00:00:00',NULL,'548',259238.95,259238.95,'548','2021-09-21 10:22:23','535','2021-09-21 10:29:18',10,0),('1','65',226118,'MORNING','2021-09-21','2021-09-21 00:00:00',NULL,'548',121697.80,121697.80,'548','2021-09-21 13:04:12','535','2021-09-21 13:45:49',10,0),('1','65',226288,'AFTERNOON','2021-09-21','2021-09-21 00:00:00',NULL,'548',127495.90,127495.90,'548','2021-09-22 09:41:26','535','2021-09-22 10:33:41',10,0),('1','65',226350,'MORNING','2021-09-22','2021-09-22 00:00:00',NULL,'548',122954.80,122954.80,'548','2021-09-22 12:25:36','535','2021-09-22 13:49:42',10,0),('1','65',226551,'AFTERNOON','2021-09-22','2021-09-22 00:00:00',NULL,'548',509667.19,509667.19,'548','2021-09-23 09:47:12','535','2021-09-23 11:08:16',10,0),('1','65',226662,'MORNING','2021-09-23','2021-09-23 00:00:00',NULL,'548',271437.41,271437.41,'548','2021-09-23 18:50:48','535','2021-09-23 20:52:43',10,0),('1','65',226836,'AFTERNOON','2021-09-23','2021-09-23 00:00:00',NULL,'548',337061.29,337061.29,'548','2021-09-24 11:26:44','535','2021-09-24 12:53:40',10,0),('1','65',226858,'MORNING','2021-09-24','2021-09-24 00:00:00',NULL,'548',216985.03,216985.03,'548','2021-09-24 13:08:13','535','2021-09-24 15:14:43',10,0),('1','65',227039,'AFTERNOON','2021-09-24','2021-09-24 00:00:00',NULL,'548',638822.59,638822.59,'548','2021-09-25 10:53:48','535','2021-09-25 14:33:33',10,0),('1','65',227161,'MORNING','2021-09-25','2021-09-25 00:00:00',NULL,'548',378223.59,378223.59,'548','2021-09-25 18:47:39','535','2021-09-25 19:54:34',10,0),('1','65',227278,'AFTERNOON','2021-09-25','2021-09-25 00:00:00',NULL,'548',688148.01,688148.01,'548','2021-09-26 12:51:03','535','2021-09-26 13:01:39',10,0),('1','65',227344,'MORNING','2021-09-26','2021-09-26 00:00:00',NULL,'548',532550.72,532550.72,'548','2021-09-26 18:56:44','535','2021-09-27 08:52:27',10,0),('1','65',227471,'AFTERNOON','2021-09-26','2021-09-26 00:00:00',NULL,'548',1228896.77,1228896.77,'548','2021-09-27 10:25:25','535','2021-09-27 19:42:02',10,0),('1','65',227692,'MORNING','2021-09-26','2021-09-26 00:00:00',NULL,'548',485885.61,485885.61,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',229088,'MORNING','2021-09-27','2021-09-27 00:00:00',NULL,'548',485883.98,485883.98,'548','2021-10-04 15:06:56','535','2021-10-04 15:08:19',10,0),('1','65',229090,'AFTERNOON','2021-09-27','2021-09-27 00:00:00',NULL,'548',661092.74,661092.74,'548','2021-10-04 15:11:36','535','2021-10-04 15:13:22',10,0),('1','65',229091,'MORNING','2021-09-28','2021-09-28 00:00:00',NULL,'548',527762.22,527762.22,'548','2021-10-04 15:15:57','535','2021-10-04 15:17:08',10,0),('1','65',229093,'AFTERNOON','2021-09-28','2021-09-28 00:00:00',NULL,'548',875650.10,875650.10,'548','2021-10-04 15:19:54','535','2021-10-04 15:24:25',10,0),('1','65',229094,'MORNING','2021-09-29','2021-09-29 00:00:00',NULL,'548',129128.57,129128.57,'548','2021-10-04 15:27:13','535','2021-10-04 15:31:25',10,0),('1','65',229096,'AFTERNOON','2021-09-29','2021-09-29 00:00:00',NULL,'548',453870.24,453870.24,'548','2021-10-04 15:34:01','535','2021-10-04 15:35:37',10,0),('1','65',229099,'MORNING','2021-09-30','2021-09-30 00:00:00',NULL,'548',116409.71,116409.71,'548','2021-10-04 15:37:07','535','2021-10-04 15:38:07',10,0),('1','65',229102,'AFTERNOON','2021-09-30','2021-09-30 00:00:00',NULL,'548',106434.11,106434.11,'548','2021-10-04 15:42:09','535','2021-10-04 15:42:50',10,0),('1','65',229104,'MORNING','2021-10-01','2021-10-01 00:00:00',NULL,'548',144876.03,144876.03,'548','2021-10-04 15:45:04','535','2021-10-04 15:47:06',10,0),('1','65',229107,'AFTERNOON','2021-10-01','2021-10-01 00:00:00',NULL,'548',87258.79,87258.79,'548','2021-10-04 15:53:40','535','2021-10-04 15:54:43',10,0),('1','65',229109,'MORNING','2021-10-02','2021-10-02 00:00:00',NULL,'548',130590.71,130590.71,'548','2021-10-04 16:01:58','535','2021-10-04 16:04:48',10,0),('1','65',229112,'AFTERNOON','2021-10-02','2021-10-02 00:00:00',NULL,'548',202561.73,202561.73,'548','2021-10-04 16:08:57','535','2021-10-04 16:11:42',10,0),('1','65',229116,'MORNING','2021-10-03','2021-10-03 00:00:00',NULL,'548',179181.01,179181.01,'548','2021-10-04 16:15:53','535','2021-10-04 16:17:39',10,0),('1','65',229118,'AFTERNOON','2021-10-03','2021-10-03 00:00:00',NULL,'548',149211.83,149211.83,'548','2021-10-04 16:22:15','535','2021-10-04 16:24:14',10,0),('1','65',229136,'MORNING','2021-10-04','2021-10-04 00:00:00',NULL,'548',141992.56,141992.56,'548','2021-10-04 18:51:48','535','2021-10-04 20:52:35',10,0),('1','65',229297,'AFTERNOON','2021-10-04','2021-10-04 00:00:00',NULL,'548',107754.41,107754.41,'548','2021-10-05 13:24:59','535','2021-10-05 13:54:05',10,0),('1','65',229381,'MORNING','2021-10-05','2021-10-05 00:00:00',NULL,'548',117250.79,117250.79,'548','2021-10-05 18:49:05','535','2021-10-05 20:25:39',10,0),('1','65',229428,'AFTERNOON','2021-10-05','2021-10-05 00:00:00',NULL,'548',118272.80,118272.80,'548','2021-10-06 12:55:15','535','2021-10-06 13:10:08',10,0),('1','65',229630,'MORNING','2021-10-06','2021-10-06 00:00:00',NULL,'548',173598.26,173598.26,'548','2021-10-06 18:56:55','535','2021-10-06 22:14:07',10,0),('1','65',229744,'AFTERNOON','2021-10-06','2021-10-06 00:00:00',NULL,'548',544483.57,544483.57,'548','2021-10-07 11:03:08','535','2021-10-07 11:39:54',10,0),('1','65',229852,'MORNING','2021-10-07','2021-10-07 00:00:00',NULL,'548',101712.00,101712.00,'548','2021-10-07 18:42:31','535','2021-10-07 19:41:01',10,0),('1','65',229924,'AFTERNOON','2021-10-07','2021-10-07 00:00:00',NULL,'548',102238.49,102238.49,'548','2021-10-08 08:32:06','535','2021-10-08 08:49:10',10,0),('1','65',230052,'MORNING','2021-10-08','2021-10-08 00:00:00',NULL,'548',101674.51,101674.51,'548','2021-10-08 18:50:14','535','2021-10-08 19:45:36',10,0),('1','65',230157,'AFTERNOON','2021-10-08','2021-10-08 00:00:00',NULL,'548',89014.30,89014.30,'548','2021-10-09 10:25:13','535','2021-10-09 10:49:18',10,0),('1','65',230392,'MORNING','2021-10-09','2021-10-09 00:00:00',NULL,'548',113025.83,113025.83,'548','2021-10-10 12:05:57','535','2021-10-10 14:10:32',10,0),('1','65',230485,'MORNING','2021-10-09','2021-10-09 00:00:00',NULL,'548',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','65',230486,'AFTERNOON','2021-10-09','2021-10-09 00:00:00',NULL,'548',115405.63,115405.63,'548','2021-10-10 18:12:47','535','2021-10-10 20:32:31',10,0),('1','65',230583,'MORNING','2021-10-10','2021-10-10 00:00:00',NULL,'548',156598.99,156598.99,'548','2021-10-11 09:30:52','535','2021-10-11 09:40:04',10,0),('1','65',230594,'AFTERNOON','2021-10-10','2021-10-10 00:00:00',NULL,'548',200134.66,200134.66,'548','2021-10-11 09:51:21','535','2021-10-11 10:13:28',10,0),('1','65',230749,'MORNING','2021-10-11','2021-10-11 00:00:00',NULL,'548',137660.02,137660.02,'548','2021-10-11 18:50:22','535','2021-10-12 08:10:00',10,0),('1','65',230988,'AFTERNOON','2021-10-11','2021-10-11 00:00:00',NULL,'548',125971.29,125971.29,'548','2021-10-12 15:20:25','535','2021-10-12 17:05:38',10,0),('1','65',231030,'MORNING','2021-10-12','2021-10-12 00:00:00',NULL,'548',117245.90,117245.90,'548','2021-10-12 18:51:38','535','2021-10-12 20:18:52',10,0),('1','65',231302,'AFTERNOON','2021-10-12','2021-10-12 00:00:00',NULL,'548',90108.03,90108.03,'548','2021-10-13 15:58:36','535','2021-10-13 16:00:59',10,0),('1','65',231305,'MORNING','2021-10-13','2021-10-13 00:00:00',NULL,'548',127870.24,127870.24,'548','2021-10-13 16:04:46','535','2021-10-13 16:24:10',10,0),('1','65',231483,'AFTERNOON','2021-10-13','2021-10-13 00:00:00',NULL,'548',474015.41,474015.41,'548','2021-10-14 11:20:29','535','2021-10-14 13:00:19',10,0),('1','65',231608,'MORNING','2021-10-14','2021-10-14 00:00:00',NULL,'548',178082.39,178082.39,'548','2021-10-14 18:45:26','535','2021-10-15 05:08:15',10,0),('1','65',231745,'AFTERNOON','2021-10-14','2021-10-14 00:00:00',NULL,'548',150853.24,150853.24,'548','2021-10-15 11:20:18','535','2021-10-15 14:09:23',10,0),('1','65',231855,'MORNING','2021-10-15','2021-10-15 00:00:00',NULL,'548',169798.73,169798.73,'548','2021-10-15 18:51:29','535','2021-10-15 21:09:09',10,0),('1','65',231961,'AFTERNOON','2021-10-15','2021-10-15 00:00:00',NULL,'548',109278.46,109278.46,'548','2021-10-16 10:28:18','535','2021-10-16 11:00:58',10,0),('1','65',232254,'MORNING','2021-10-16','2021-10-16 00:00:00',NULL,'548',197221.85,197221.85,'548','2021-10-17 15:03:18','535','2021-10-17 16:04:32',10,0),('1','65',232290,'AFTERNOON','2021-10-16','2021-10-16 00:00:00',NULL,'548',126840.08,126840.08,'548','2021-10-17 18:48:08','535','2021-10-17 22:57:54',10,0),('1','65',232375,'MORNING','2021-10-17','2021-10-17 00:00:00',NULL,'548',211177.91,211177.91,'548','2021-10-18 08:13:50','535','2021-10-18 08:44:03',10,0),('1','65',232430,'AFTERNOON','2021-10-17','2021-10-17 00:00:00',NULL,'548',688710.86,688710.86,'548','2021-10-18 10:26:50','535','2021-10-18 10:30:26',10,0),('1','65',232547,'MORNING','2021-10-18','2021-10-18 00:00:00',NULL,'548',508690.40,508690.40,'548','2021-10-18 18:39:52','535','2021-10-18 21:01:45',10,0),('1','65',232767,'AFTERNOON','2021-10-18','2021-10-18 00:00:00',NULL,'548',530592.71,530592.71,'548','2021-10-19 17:14:15','535','2021-10-19 18:19:45',10,0),('1','65',232773,'MORNING','2021-10-19','2021-10-19 00:00:00',NULL,'548',158925.00,158925.00,'548','2021-10-19 18:28:05','535','2021-10-20 05:23:30',10,0),('1','65',232840,'AFTERNOON','2021-10-19','2021-10-19 00:00:00',NULL,'548',181867.95,181867.95,'548','2021-10-20 05:57:03','535','2021-10-20 09:07:07',10,0),('1','65',233077,'MORNING','2021-10-20','2021-10-20 00:00:00',NULL,'548',119638.20,119638.20,'548','2021-10-21 10:57:23','535','2021-10-21 10:58:50',10,0),('1','65',233254,'AFTERNOON','2021-10-20','2021-10-20 00:00:00',NULL,'548',471736.65,471736.65,'548','2021-10-21 13:01:08','535','2021-10-21 13:36:33',10,0),('1','65',233351,'MORNING','2021-10-21','2021-10-21 00:00:00',NULL,'548',128396.40,128396.40,'548','2021-10-22 00:22:55','535','2021-10-22 04:55:34',10,0),('1','65',233452,'AFTERNOON','2021-10-21','2021-10-21 00:00:00',NULL,'548',99547.80,99547.80,'548','2021-10-22 11:24:17','535','2021-10-22 12:31:42',10,0),('1','65',233581,'MORNING','2021-10-22','2021-10-22 00:00:00',NULL,'548',147176.70,147176.70,'548','2021-10-22 23:10:27','535','2021-10-22 23:43:36',10,0),('1','65',233818,'AFTERNOON','2021-10-22','2021-10-22 00:00:00',NULL,'548',108226.80,108226.80,'548','2021-10-23 21:53:17','535','2021-10-24 09:26:41',10,0),('1','65',234163,'MORNING','2021-10-23','2021-10-23 00:00:00',NULL,'548',55182.60,55182.60,'548','2021-10-25 10:52:45','535','2021-10-25 11:07:59',10,0),('1','65',234390,'AFTERNOON','2021-10-23','2021-10-23 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-27 07:45:45','535','2021-10-27 08:50:03',10,0),('1','65',234691,'MORNING','2021-10-24','2021-10-24 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-27 13:05:52','202','2021-10-27 13:10:39',10,0),('1','65',234715,'AFTERNOON','2021-10-24','2021-10-24 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-27 13:13:51','202','2021-10-27 13:19:18',10,0),('1','65',234723,'MORNING','2021-10-25','2021-10-25 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-27 13:23:18','202','2021-10-27 13:48:28',10,0),('1','65',234740,'AFTERNOON','2021-10-25','2021-10-25 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-27 14:17:33','202','2021-10-27 14:26:28',10,0),('1','65',234818,'MORNING','2021-10-26','2021-10-26 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-28 05:38:48','535','2021-10-28 07:11:45',10,0),('1','65',234958,'AFTERNOON','2021-10-26','2021-10-26 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-28 12:46:23','535','2021-10-28 13:25:50',10,0),('1','65',234998,'MORNING','2021-10-27','2021-10-27 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-28 16:06:14','535','2021-10-29 05:06:26',10,0),('1','65',235120,'AFTERNOON','2021-10-27','2021-10-27 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-29 07:37:04','535','2021-10-29 08:39:27',10,0),('1','65',235228,'MORNING','2021-10-28','2021-10-28 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-29 15:30:53','535','2021-10-29 16:42:59',10,0),('1','65',235375,'AFTERNOON','2021-10-28','2021-10-28 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-30 11:37:53','202','2021-10-30 13:20:23',10,0),('1','65',235446,'Morning','2021-10-29','2021-10-29 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-31 12:59:37','535','2021-10-31 13:26:52',10,0),('1','65',235677,'AFTERNOON','2021-10-29','2021-10-29 00:00:00',NULL,'548',0.00,0.00,'548','2021-10-31 15:27:38','535','2021-10-31 19:50:59',10,0),('1','65',235879,'MORNING','2021-10-30','2021-10-30 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-01 11:21:21','535','2021-11-01 14:10:46',10,0),('1','65',235986,'AFTERNOON','2021-10-30','2021-10-30 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-01 21:55:51','535','2021-11-02 05:47:23',10,0),('1','65',236438,'MORNING','2021-10-31','2021-10-31 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-03 17:19:01','535','2021-11-03 17:27:33',10,0),('1','65',236472,'AFTERNOON','2021-10-31','2021-10-31 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-03 21:05:00','535','2021-11-04 03:33:36',10,0),('1','65',236506,'MORNING','2021-11-01','2021-11-01 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-04 05:45:35','535','2021-11-04 08:53:46',10,0),('1','65',236798,'AFTERNOON','2021-11-01','2021-11-01 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-05 08:43:30','535','2021-11-05 09:09:31',10,0),('1','65',236907,'MORNING','2021-11-01','2021-11-01 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-05 18:48:55','535','2021-11-06 03:15:35',10,0),('1','65',237004,'AFTERNOON','2021-11-02','2021-11-02 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-06 08:24:30','535','2021-11-06 09:19:33',10,0),('1','65',237023,'MORNING','2021-11-03','2021-11-03 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-06 09:36:20','535','2021-11-06 09:57:53',10,0),('1','65',237039,'AFTERNOON','2021-11-03','2021-11-03 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-06 10:30:56','535','2021-11-06 11:18:43',10,0),('1','65',237119,'MORNING','2021-11-04','2021-11-04 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-06 17:47:56','535','2021-11-07 05:09:06',10,0),('1','65',237216,'AFTERNOON','2021-11-04','2021-11-04 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-07 08:11:53','535','2021-11-07 08:40:05',10,0),('1','65',237244,'MORNING','2021-11-05','2021-11-05 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-07 09:36:51','535','2021-11-07 10:10:24',10,0),('1','65',237265,'AFTERNOON','2021-11-05','2021-11-05 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-07 12:47:15','535','2021-11-07 13:20:17',10,0),('1','65',237382,'MORNING','2021-11-06','2021-11-06 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-08 05:45:25','535','2021-11-08 09:24:14',10,0),('1','65',237467,'AFTERNOON','2021-11-06','2021-11-06 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-08 09:25:34','535','2021-11-08 11:13:47',10,0),('1','65',237611,'MORNING','2021-11-07','2021-11-07 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-09 05:54:16','535','2021-11-09 08:45:18',10,0),('1','65',237790,'AFTERNOON','2021-11-07','2021-11-07 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-09 16:22:16','535','2021-11-09 17:03:53',10,0),('1','65',237795,'MORNING','2021-11-08','2021-11-08 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-09 17:13:14','535','2021-11-09 18:36:53',10,0),('1','65',237829,'AFTERNOON','2021-11-08','2021-11-08 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-09 20:26:23','535','2021-11-10 03:56:15',10,0),('1','65',237864,'MORNING','2021-11-09','2021-11-09 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-10 05:50:45','535','2021-11-10 08:13:11',10,0),('1','65',238018,'AFTERNOON','2021-11-09','2021-11-09 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-10 13:23:54','535','2021-11-10 14:02:29',10,0),('1','65',238041,'MORNING','2021-11-10','2021-11-10 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-10 14:50:09','535','2021-11-11 03:22:11',10,0),('1','65',238114,'AFTERNOON','2021-11-10','2021-11-10 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-11 05:44:25','535','2021-11-11 07:53:51',10,0),('1','65',238375,'MORNING','2021-11-11','2021-11-11 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-12 14:58:29','535','2021-11-12 17:20:37',10,0),('1','65',238768,'AFTERNOON','2021-11-11','2021-11-11 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-14 22:08:41','535','2021-11-15 01:17:53',10,0),('1','65',239454,'MORNING','2021-11-12','2021-11-12 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-16 16:27:23','535','2021-11-16 18:10:11',10,0),('1','65',239632,'AFTERNOON','2021-11-12','2021-11-12 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-17 11:24:11','535','2021-11-17 13:24:14',10,0),('1','65',239703,'MORNING','2021-11-13','2021-11-13 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-17 17:42:59','535','2021-11-17 20:15:35',10,0),('1','65',239869,'AFTERNOON','2021-11-13','2021-11-13 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-18 11:29:26','535','2021-11-18 12:03:41',10,0),('1','65',239885,'MORNING','2021-11-14','2021-11-14 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-18 12:34:37','535','2021-11-18 13:09:33',10,0),('1','65',239893,'AFTERNOON','2021-11-14','2021-11-14 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-18 13:15:30','535','2021-11-18 13:46:35',10,0),('1','65',239926,'MORNING','2021-11-15','2021-11-15 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-18 16:17:03','535','2021-11-18 17:41:12',10,0),('1','65',239953,'AFTERNOON','2021-11-15','2021-11-15 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-18 20:07:33','535','2021-11-19 03:07:02',10,0),('1','65',240009,'MORNING','2021-11-16','2021-11-16 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-19 06:36:08','535','2021-11-19 07:37:29',10,0),('1','65',240037,'AFTERNOON','2021-11-16','2021-11-16 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-19 07:51:13','535','2021-11-19 08:26:59',10,0),('1','65',240060,'MORNING','2021-11-17','2021-11-17 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-19 09:08:21','535','2021-11-19 09:18:15',10,0),('1','65',240062,'AFTERNOON','2021-11-17','2021-11-17 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-19 09:24:46','535','2021-11-19 09:27:10',10,0),('1','65',240076,'MORNING','2021-11-18','2021-11-18 00:00:00',NULL,'548',0.00,0.00,'548','2021-11-19 10:52:16','535','2021-11-19 11:07:32',10,0),('1','65',240098,'AFTERNOON','2021-11-18','2021-11-18 00:00:00',NULL,'548',54573.75,54573.75,'548','2021-11-19 13:17:15','535','2021-11-19 13:28:42',10,0),('1','65',240124,'MORNING','2021-11-19','2021-11-19 00:00:00',NULL,'548',362080.95,362080.95,'548','2021-11-19 15:51:20','535','2021-11-19 16:10:22',10,0),('1','65',240169,'AFTERNOON','2021-11-19','2021-11-19 00:00:00',NULL,'548',129330.30,129330.30,'548','2021-11-20 07:04:32','535','2021-11-20 08:27:08',10,0),('1','65',240305,'MORNING','2021-11-20','2021-11-20 00:00:00',NULL,'548',171088.50,171088.50,'548','2021-11-20 13:13:19','535','2021-11-20 15:13:10',10,0),('1','65',240426,'AFTERNOON','2021-11-20','2021-11-20 00:00:00',NULL,'548',135879.15,135879.15,'548','2021-11-21 07:54:53','535','2021-11-21 10:11:44',10,0),('1','65',240556,'MORNING','2021-11-21','2021-11-21 00:00:00',NULL,'548',275378.40,275378.40,'548','2021-11-22 00:06:41','535','2021-11-22 07:33:18',10,0),('1','65',240733,'AFTERNOON','2021-11-21','2021-11-21 00:00:00',NULL,'548',287240.25,287240.25,'548','2021-11-22 07:42:12','535','2021-11-22 09:53:08',10,0),('1','65',240915,'MORNING','2021-11-22','2021-11-22 00:00:00',NULL,'548',481780.20,481780.20,'548','2021-11-22 19:37:19','535','2021-11-22 21:05:10',10,0),('1','65',240974,'AFTERNOON','2021-11-22','2021-11-22 00:00:00',NULL,'548',585865.50,585865.50,'548','2021-11-23 06:20:13','535','2021-11-23 08:31:14',10,0),('1','65',241121,'MORNING','2021-11-23','2021-11-23 00:00:00',NULL,'548',256537.05,256537.05,'548','2021-11-23 13:50:28','535','2021-11-23 14:06:07',10,0),('1','65',241242,'AFTERNOON','2021-11-23','2021-11-23 00:00:00',NULL,'548',128516.85,128516.85,'548','2021-11-24 07:00:43','535','2021-11-24 11:01:11',10,0),('1','65',241396,'MORNING','2021-11-24','2021-11-24 00:00:00',NULL,'548',312237.75,312237.75,'548','2021-11-24 15:29:37','535','2021-11-24 16:27:50',10,0),('1','65',241539,'MORNING','2021-11-24','2021-11-24 00:00:00',NULL,'548',278524.95,278524.95,'548','2021-11-25 07:56:02','535','2021-11-25 08:38:29',10,0),('1','65',241707,'MORNING','2021-11-25','2021-11-25 00:00:00',NULL,'548',346405.95,346405.95,'548','2021-11-25 23:13:18','535','2021-11-26 08:03:09',10,0),('1','65',241798,'AFTERNOON','2021-11-25','2021-11-25 00:00:00',NULL,'548',331006.50,331006.50,'548','2021-11-26 08:15:13','535','2021-11-26 08:22:38',10,0),('1','65',241881,'MORNING','2021-11-26','2021-11-26 00:00:00',NULL,'548',42688.80,42688.80,'548','2021-11-26 16:47:41','535','2021-11-26 17:00:58',10,0),('1','65',241995,'AFTERNOON','2021-11-26','2021-11-26 00:00:00',NULL,'548',111328.80,111328.80,'548','2021-11-27 06:51:26','535','2021-11-27 09:22:36',10,0),('1','65',242122,'MORNING','2021-11-27','2021-11-27 00:00:00',NULL,'548',108695.40,108695.40,'548','2021-11-27 15:01:21','535','2021-11-27 17:08:09',10,0),('1','65',242223,'AFTERNOON','2021-11-27','2021-11-27 00:00:00',NULL,'548',60715.05,60715.05,'548','2021-11-28 13:08:48','535','2021-11-28 13:12:54',10,0),('1','65',242350,'MORNING','2021-11-28','2021-11-28 00:00:00',NULL,'548',133768.80,133768.80,'548','2021-11-28 15:55:41','535','2021-11-28 17:38:30',10,0),('1','65',242462,'AFTERNOON','2021-11-28','2021-11-28 00:00:00',NULL,'548',117150.00,117150.00,'548','2021-11-29 07:06:59','535','2021-11-29 07:41:52',10,0),('1','65',242595,'MORNING','2021-11-29','2021-11-29 00:00:00',NULL,'548',185801.55,185801.55,'548','2021-11-29 15:11:50','535','2021-11-29 15:49:40',10,0),('1','65',242659,'AFTERNOON','2021-11-29','2021-11-29 00:00:00',NULL,'548',68128.50,68128.50,'548','2021-12-01 10:52:35','535','2021-12-01 13:52:56',10,0),('1','65',243657,'MORNING','2021-11-30','2021-11-30 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-04 08:27:02','535','2021-12-04 13:07:01',10,0),('1','65',243740,'AFTERNOON','2021-11-30','2021-11-30 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-04 14:48:18','535','2021-12-04 17:40:43',10,0),('1','65',243772,'MORNING','2021-12-01','2021-12-01 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-04 18:52:56','535','2021-12-04 22:20:02',10,0),('1','65',243916,'AFTERNOON','2021-12-01','2021-12-01 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-05 11:04:47','535','2021-12-05 11:18:57',10,0),('1','65',244160,'MORNING','2021-12-02','2021-12-02 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-06 10:59:53','535','2021-12-06 14:06:15',10,0),('1','65',244210,'AFTERNOON','2021-12-02','2021-12-02 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-06 16:19:04','535','2021-12-06 16:23:38',10,0),('1','65',244242,'MORNING','2021-12-03','2021-12-03 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-06 19:48:34','535','2021-12-06 21:32:06',10,0),('1','65',244446,'AFTERNOON','2021-12-03','2021-12-03 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-07 16:11:50','535','2021-12-07 16:28:47',10,0),('1','65',244597,'MORNING','2021-12-04','2021-12-04 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-08 09:21:28','535','2021-12-08 12:03:37',10,0),('1','65',244673,'AFTERNOON','2021-12-04','2021-12-04 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-08 16:13:54','202','2021-12-08 17:36:59',10,0),('1','65',244710,'MORNING','2021-12-05','2021-12-05 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-08 20:50:40','535','2021-12-08 21:12:10',10,0),('1','65',244904,'AFTERNOON','2021-12-06','2021-12-06 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-09 16:16:40','535','2021-12-10 04:17:37',10,0),('1','65',245173,'MORNING','2021-12-06','2021-12-06 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-10 19:46:38','535','2021-12-10 20:22:40',10,0),('1','65',245470,'AFTERNOON','2021-12-06','2021-12-06 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-12 07:33:38','535','2021-12-12 08:35:56',10,0),('1','65',245522,'MORNING','2021-12-07','2021-12-07 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-12 10:42:43','535','2021-12-12 11:17:04',10,0),('1','65',245633,'AFTERNOON','2021-12-07','2021-12-07 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-12 20:10:38','535','2021-12-12 20:38:08',10,0),('1','65',245652,'MORNING','2021-12-08','2021-12-08 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-12 21:24:48','535','2021-12-12 22:44:38',10,0),('1','65',245736,'AFTERNOON','2021-12-08','2021-12-08 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-13 08:51:35','535','2021-12-13 11:01:08',10,0),('1','65',245803,'MORNING','2021-12-09','2021-12-09 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-13 13:30:14','535','2021-12-13 19:33:11',10,0),('1','65',245898,'AFTERNOON','2021-12-09','2021-12-09 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-13 20:30:25','535','2021-12-14 04:46:10',10,0),('1','65',245974,'MORNING','2021-12-10','2021-12-10 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-14 07:12:43','535','2021-12-14 09:41:02',10,0),('1','65',246053,'AFTERNOON','2021-12-10','2021-12-10 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-14 12:40:35','535','2021-12-14 12:56:10',10,0),('1','65',246113,'MORNING','2021-12-11','2021-12-11 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-14 15:44:59','535','2021-12-14 16:52:17',10,0),('1','65',246297,'AFTERNOON','2021-12-12','2021-12-12 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-15 10:06:23','535','2021-12-15 10:23:09',10,0),('1','65',246349,'MORNING','2021-12-12','2021-12-12 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-15 14:03:59','535','2021-12-15 14:05:50',10,0),('1','65',246528,'AFTERNOON','2021-12-12','2021-12-12 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-16 09:04:45','535','2021-12-16 09:54:19',10,0),('1','65',246623,'MORNING','2021-12-13','2021-12-13 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-16 15:44:52','535','2021-12-16 15:58:14',10,0),('1','65',246628,'AFTERNOON','2021-12-13','2021-12-13 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-16 16:03:10','535','2021-12-17 04:55:15',10,0),('1','65',246709,'MORNING','2021-12-14','2021-12-14 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-17 06:32:34','535','2021-12-17 07:53:16',10,0),('1','65',247002,'AFTERNOON','2021-12-14','2021-12-14 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-18 08:46:59','535','2021-12-18 09:14:32',10,0),('1','65',247073,'MORNING','2021-12-15','2021-12-15 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-18 13:33:32','535','2021-12-18 14:24:58',10,0),('1','65',247620,'AFTERNOON','2021-12-15','2021-12-15 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-20 20:13:23','535','2021-12-21 01:38:58',10,0),('1','65',247785,'MORNING','2021-12-16','2021-12-16 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-21 13:04:52','535','2021-12-21 15:03:54',10,0),('1','65',247826,'AFTERNOON','2021-12-16','2021-12-16 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-21 15:29:09','535','2021-12-21 21:57:23',10,0),('1','65',248105,'MORNING','2021-12-17','2021-12-17 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-22 20:19:35','535','2021-12-23 05:43:48',10,0),('1','65',248550,'AFTERNOON','2021-12-17','2021-12-17 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-24 15:31:14','535','2021-12-24 16:08:32',10,0),('1','65',248709,'MORNING','2021-12-19','2021-12-19 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 09:13:12','535','2021-12-25 09:46:33',10,0),('1','65',248717,'AFTERNOON','2021-12-19','2021-12-19 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 09:51:45','535','2021-12-25 13:13:13',10,0),('1','65',248783,'MORNING','2021-12-20','2021-12-20 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 14:41:51','535','2021-12-25 15:48:07',10,0),('1','65',248789,'AFTERNOON','2021-12-20','2021-12-20 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 15:54:31','535','2021-12-25 15:55:07',10,0),('1','65',248791,'MORNING','2021-12-21','2021-12-21 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 15:56:35','535','2021-12-25 15:58:58',10,0),('1','65',248792,'AFTERNOON','2021-12-21','2021-12-21 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 15:59:44','535','2021-12-25 16:01:27',10,0),('1','65',248794,'MORNING','2021-12-22','2021-12-22 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 16:02:21','535','2021-12-25 16:02:42',10,0),('1','65',248796,'AFTERNOON','2021-12-22','2021-12-22 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 16:03:47','535','2021-12-25 16:03:59',10,0),('1','65',248797,'MORNING','2021-12-23','2021-12-23 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 16:05:25','535','2021-12-25 16:06:51',10,0),('1','65',248798,'AFTERNOON','2021-12-23','2021-12-23 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 16:07:40','535','2021-12-25 16:07:56',10,0),('1','65',248799,'MORNING','2021-12-24','2021-12-24 00:00:00',NULL,'548',0.00,0.00,'548','2021-12-25 16:09:08','535','2021-12-25 16:09:20',10,0),('1','65',248952,'AFTERNOON','2021-12-24','2021-12-24 00:00:00',NULL,'548',148715.00,148715.00,'548','2021-12-26 10:36:51','535','2021-12-26 10:39:10',10,0),('1','65',249019,'MORNING','2021-12-25','2021-12-25 00:00:00',NULL,'548',18802.00,18802.00,'548','2021-12-26 15:14:53','535','2021-12-26 18:59:03',10,0),('1','65',249209,'AFTERNOON','2021-12-25','2021-12-25 00:00:00',NULL,'548',186347.00,186347.00,'548','2021-12-27 10:34:39','535','2021-12-27 14:07:23',10,0),('1','65',249249,'MORNING','2021-12-26','2021-12-26 00:00:00',NULL,'548',29711.50,29711.50,'548','2021-12-27 14:28:27','535','2021-12-27 15:04:37',10,0),('1','65',249421,'AFTERNOON','2021-12-26','2021-12-26 00:00:00',NULL,'548',204956.50,204956.50,'548','2021-12-28 09:07:30','535','2021-12-28 09:43:55',10,0),('1','65',249515,'MORNING','2021-12-27','2021-12-27 00:00:00',NULL,'548',117701.50,117701.50,'548','2021-12-28 15:25:11','535','2021-12-28 15:43:41',10,0),('1','65',249541,'AFTERNOON','2021-12-27','2021-12-27 00:00:00',NULL,'548',9219.00,9219.00,'548','2021-12-28 20:04:10','535','2021-12-28 20:51:32',10,0),('1','65',249635,'MORNING','2021-12-28','2021-12-28 00:00:00',NULL,'548',55996.50,55996.50,'548','2021-12-29 07:44:09','535','2021-12-29 08:59:54',10,0),('1','65',249686,'AFTERNOON','2021-12-28','2021-12-28 00:00:00',NULL,'548',57928.50,57928.50,'548','2021-12-29 09:42:47','535','2021-12-29 12:21:26',10,0),('1','65',249810,'MORNING','2021-12-29','2021-12-29 00:00:00',NULL,'548',7651.00,7651.00,'548','2021-12-29 20:17:34','535','2021-12-29 23:53:32',10,0),('1','65',250002,'AFTERNOON','2021-12-29','2021-12-29 00:00:00',NULL,'548',165203.50,165203.50,'548','2021-12-30 13:50:09','535','2021-12-30 15:12:51',10,0),('1','65',250034,'MORNING','2021-12-30','2021-12-30 00:00:00',NULL,'548',7199.50,7199.50,'548','2021-12-31 05:26:41','202','2021-12-31 10:35:37',10,0),('1','65',250519,'AFTERNOON','2021-12-30','2021-12-30 00:00:00',NULL,'548',0.00,0.00,'548','2022-01-01 19:32:07','535','2022-01-01 19:34:31',10,0),('1','65',250520,'MORNING','2021-12-31','2021-12-31 00:00:00',NULL,'548',11550.00,11550.00,'548','2022-01-01 19:59:03','535','2022-01-01 19:59:42',10,0),('1','65',250526,'AFTERNOON','2021-12-31','2021-12-31 00:00:00',NULL,'548',192199.00,192199.00,'548','2022-01-01 20:20:05','535','2022-01-01 20:20:19',10,0),('1','65',250529,'MORNING','2022-01-01','2022-01-01 00:00:00',NULL,'548',37551.50,37551.50,'548','2022-01-01 20:30:58','535','2022-01-01 20:32:24',10,0),('1','65',250530,'AFTERNOON','2022-01-01','2022-01-01 00:00:00',NULL,'548',2618.00,2618.00,'548','2022-01-01 20:35:03','535','2022-01-01 20:35:21',10,0),('1','65',250772,'MORNING','2022-01-02','2022-01-02 00:00:00',NULL,'548',27100.50,27100.50,'548','2022-01-02 21:18:13','535','2022-01-03 03:14:44',10,0),('1','65',250950,'AFTERNOON','2022-01-02','2022-01-02 00:00:00',NULL,'548',544530.00,544530.00,'548','2022-01-03 16:39:12','535','2022-01-03 16:40:16',10,0),('1','65',251102,'MORNING','2022-01-03','2022-01-03 00:00:00',NULL,'548',11301.50,11301.50,'548','2022-01-04 10:14:07','535','2022-01-04 10:45:37',10,0),('1','65',251190,'Afternoon','2022-01-03','2022-01-03 00:00:00',NULL,'548',43400.00,43400.00,'548','2022-01-04 15:37:10','535','2022-01-04 16:07:43',10,0),('1','65',251215,'Morning','2022-01-04','2022-01-04 00:00:00',NULL,'548',24479.00,24479.00,'548','2022-01-04 18:07:22','535','2022-01-04 18:59:47',10,0),('1','65',251358,'Afternoon','2022-01-04','2022-01-04 00:00:00',NULL,'548',25900.00,25900.00,'548','2022-01-05 11:06:32','535','2022-01-05 11:53:44',10,0),('1','65',251385,'Morning','2022-01-05','2022-01-05 00:00:00',NULL,'548',150451.00,150451.00,'548','2022-01-05 13:38:35','535','2022-01-05 16:06:13',10,0),('1','65',251462,'Afternoon','2022-01-05','2022-01-05 00:00:00',NULL,'548',337886.50,337886.50,'548','2022-01-05 20:10:32','535','2022-01-06 06:12:11',10,0),('1','65',251643,'Morning','2022-01-06','2022-01-06 00:00:00',NULL,'548',92746.50,92746.50,'548','2022-01-06 13:36:58','535','2022-01-06 14:11:57',10,0),('1','65',251794,'Afternoon','2022-01-06','2022-01-06 00:00:00',NULL,'548',159939.50,159939.50,'548','2022-01-07 08:14:43','535','2022-01-07 09:02:25',10,0),('1','65',251870,'Morning','2022-01-07','2022-01-07 00:00:00',NULL,'548',36662.50,36662.50,'548','2022-01-07 13:53:09','535','2022-01-07 14:54:57',10,0),('1','65',252058,'Afternoon','2022-01-07','2022-01-07 00:00:00',NULL,'548',204092.00,204092.00,'548','2022-01-08 10:17:37','535','2022-01-08 10:25:01',10,0),('1','65',252108,'Morning','2022-01-08','2022-01-08 00:00:00',NULL,'548',50102.50,50102.50,'548','2022-01-08 13:23:33','535','2022-01-08 14:15:28',10,0),('1','65',252290,'Afternoon','2022-01-08','2022-01-08 00:00:00',NULL,'548',111261.50,111261.50,'548','2022-01-09 09:45:56','535','2022-01-09 10:24:07',10,0),('1','65',252339,'Morning','2022-01-09','2022-01-09 00:00:00',NULL,'548',268996.00,268996.00,'548','2022-01-09 13:46:43','535','2022-01-09 14:50:24',10,0),('1','65',252553,'Afternoon','2022-01-09','2022-01-09 00:00:00',NULL,'548',219005.50,219005.50,'548','2022-01-10 09:44:26','535','2022-01-10 10:23:39',10,0),('1','65',252616,'Morning','2022-01-10','2022-01-10 00:00:00',NULL,'548',193249.00,193249.00,'548','2022-01-10 14:37:22','535','2022-01-10 15:47:01',10,0),('1','65',252782,'Afternoon','2022-01-10','2022-01-10 00:00:00',NULL,'548',534852.50,534852.50,'548','2022-01-11 09:49:09','535','2022-01-11 10:18:01',10,0),('1','65',252827,'Morning','2022-01-11','2022-01-11 00:00:00',NULL,'548',43652.00,43652.00,'548','2022-01-11 13:33:32','535','2022-01-11 15:44:24',10,0),('1','65',252906,'Afternoon','2022-01-11','2022-01-11 00:00:00',NULL,'548',332573.50,332573.50,'548','2022-01-11 19:54:17','535','2022-01-12 06:32:43',10,0),('1','65',253078,'Morning','2022-01-12','2022-01-12 00:00:00',NULL,'548',193371.50,193371.50,'548','2022-01-12 13:13:11','535','2022-01-12 14:45:58',10,0),('1','65',253128,'Afternoon','2022-01-12','2022-01-12 00:00:00',NULL,'548',156513.00,156513.00,'548','2022-01-13 10:06:26','535','2022-01-13 12:26:03',10,0),('1','65',253358,'Morning','2022-01-13','2022-01-13 00:00:00',NULL,'548',152344.50,152344.50,'548','2022-01-13 13:57:00','535','2022-01-13 14:30:35',10,0),('1','65',253422,'Afternoon','2022-01-13','2022-01-13 00:00:00',NULL,'548',141053.50,141053.50,'548','2022-01-13 20:49:40','535','2022-01-14 06:34:26',10,0),('1','65',253609,'Morning','2022-01-14','2022-01-14 00:00:00',NULL,'548',43953.00,43953.00,'548','2022-01-14 14:40:28','535','2022-01-14 18:06:34',10,0),('1','65',253656,'Afternoon','2022-01-14','2022-01-14 00:00:00',NULL,'548',295046.50,295046.50,'548','2022-01-14 19:51:17','535','2022-01-15 06:41:40',10,0),('1','65',253827,'Morning','2022-01-15','2022-01-15 00:00:00',NULL,'548',69636.00,69636.00,'548','2022-01-15 13:40:08','535','2022-01-15 14:27:25',10,0),('1','65',253879,'Afternoon','2022-01-15','2022-01-15 00:00:00',NULL,'548',178195.50,178195.50,'548','2022-01-15 20:02:42','535','2022-01-16 07:37:53',10,0),('1','65',254046,'Morning','2022-01-16','2022-01-16 00:00:00',NULL,'548',169512.00,169512.00,'548','2022-01-17 09:42:28','535','2022-01-17 10:52:45',10,0),('1','65',254320,'Afternoon','2022-01-16','2022-01-16 00:00:00',NULL,'548',0.00,0.00,'548','2022-01-17 13:36:08','535','2022-01-17 14:14:21',10,0),('1','65',254344,'Morning','2022-01-17','2022-01-17 00:00:00',NULL,'548',0.00,0.00,'548','2022-01-17 14:27:10','535','2022-01-17 16:01:45',10,0),('1','65',254400,'Afternoon','2022-01-17','2022-01-17 00:00:00',NULL,'548',0.00,0.00,'548','2022-01-17 20:43:59','535','2022-01-17 23:49:55',10,0),('1','65',254580,'Morning','2022-01-18','2022-01-18 00:00:00',NULL,'548',0.00,0.00,'548','2022-01-18 13:48:50','202','2022-01-18 15:13:42',10,0),('1','65',254775,'Afternoon','2022-01-18','2022-01-18 00:00:00',NULL,'548',0.00,0.00,'548','2022-01-19 09:49:09','535','2022-01-19 09:56:03',10,0),('1','65',254845,'Morning','2022-01-19','2022-01-19 00:00:00',NULL,'548',74445.00,74445.00,'548','2022-01-19 14:08:34','535','2022-01-19 16:31:20',10,0),('1','65',254976,'Afternoon','2022-01-19','2022-01-19 00:00:00',NULL,'548',262223.50,262223.50,'548','2022-01-20 08:03:55','535','2022-01-20 09:17:53',10,0),('1','65',255074,'Morning','2022-01-20','2022-01-20 00:00:00',NULL,'548',6394.50,6394.50,'548','2022-01-20 13:49:11','535','2022-01-20 14:30:24',10,0),('1','65',255139,'Afternoon','2022-01-20','2022-01-20 00:00:00',NULL,'548',23754.50,23754.50,'548','2022-01-20 19:55:07','535','2022-01-21 01:00:22',10,0),('1','65',255321,'Morning','2022-01-21','2022-01-21 00:00:00',NULL,'548',60335.80,60335.80,'548','2022-01-21 14:12:28','535','2022-01-21 15:55:58',10,0),('1','65',255408,'Afternoon','2022-01-21','2022-01-21 00:00:00',NULL,'548',159700.30,159700.30,'548','2022-01-21 19:54:42','535','2022-01-22 07:25:08',10,0),('1','65',255586,'Morning','2022-01-22','2022-01-22 00:00:00',NULL,'548',36089.30,36089.30,'548','2022-01-22 13:43:25','535','2022-01-22 14:41:06',10,0),('1','65',255663,'Afternoon','2022-01-22','2022-01-22 00:00:00',NULL,'548',258983.15,258983.15,'548','2022-01-22 20:00:59','535','2022-01-23 06:16:33',10,0),('1','65',255824,'Morning','2022-01-23','2022-01-23 00:00:00',NULL,'548',64542.55,64542.55,'548','2022-01-23 14:01:44','535','2022-01-23 16:32:24',10,0),('1','65',255882,'Afternoon','2022-01-23','2022-01-23 00:00:00',NULL,'548',490389.90,490389.90,'548','2022-01-23 20:22:45','535','2022-01-24 01:24:41',10,0),('1','65',256082,'Morning','2022-01-24','2022-01-24 00:00:00',NULL,'548',178813.50,178813.50,'548','2022-01-24 13:43:11','535','2022-01-24 14:29:55',10,0),('1','65',256136,'Afternoon','2022-01-24','2022-01-24 00:00:00',NULL,'548',495445.10,495445.10,'548','2022-01-24 20:07:14','535','2022-01-24 20:41:15',10,0),('1','65',256324,'Morning','2022-01-25','2022-01-25 00:00:00',NULL,'548',265568.40,265568.40,'548','2022-01-25 13:37:01','535','2022-01-25 14:53:44',10,0),('1','65',256421,'Afternoon','2022-01-25','2022-01-25 00:00:00',NULL,'548',420296.40,420296.40,'548','2022-01-25 19:57:28','535','2022-01-26 06:36:57',10,0),('1','65',256602,'Morning','2022-01-26','2022-01-26 00:00:00',NULL,'548',309351.60,309351.60,'548','2022-01-26 13:46:19','535','2022-01-26 15:53:14',10,0),('1','65',256674,'Afternoon','2022-01-26','2022-01-26 00:00:00',NULL,'548',549892.80,549892.80,'548','2022-01-26 20:06:27','535','2022-01-26 23:50:21',10,0),('1','65',256842,'Morning','2022-01-27','2022-01-27 00:00:00',NULL,'548',116287.20,116287.20,'548','2022-01-27 13:47:32','535','2022-01-27 14:43:40',10,0),('1','65',256903,'Afternoon','2022-01-27','2022-01-27 00:00:00',NULL,'548',18126.00,18126.00,'548','2022-01-27 19:55:55','535','2022-01-28 06:12:01',10,0),('1','65',257136,'Morning','2022-01-28','2022-01-28 00:00:00',NULL,'548',309301.20,309301.20,'548','2022-01-28 16:10:53','535','2022-01-28 23:13:38',10,0),('1','65',257287,'Afternoon','2022-01-28','2022-01-28 00:00:00',NULL,'548',149956.60,149956.60,'548','2022-01-29 09:55:59','535','2022-01-29 10:41:39',10,0),('1','65',257341,'Morning','2022-01-29','2022-01-29 00:00:00',NULL,'548',62203.30,62203.30,'548','2022-01-29 13:33:27','535','2022-01-29 14:15:31',10,0),('1','65',257429,'Afternoon','2022-01-29','2022-01-29 00:00:00',NULL,'548',135550.05,135550.05,'548','2022-01-29 20:05:27','535','2022-01-29 23:22:35',10,0),('1','65',257608,'Morning','2022-01-30','2022-01-30 00:00:00',NULL,'548',58564.25,58564.25,'548','2022-01-30 13:46:21','535','2022-01-30 14:14:15',10,0),('1','65',257666,'Afternoon ','2022-01-30','2022-01-30 00:00:00',NULL,'548',85942.90,85942.90,'548','2022-01-31 08:54:08','535','2022-01-31 13:10:50',10,0),('1','65',257667,'Morning','2022-01-31','2022-01-31 00:00:00',NULL,'548',444716.00,444716.00,'548','2022-01-31 13:33:48','535','2022-01-31 15:09:21',10,0),('1','65',257668,'Afternoon ','2022-01-31','2022-01-31 00:00:00',NULL,'548',99393.15,99393.15,'548','2022-01-31 20:45:14','535','2022-02-01 04:16:56',10,0),('1','65',257669,'Morning','2022-02-01','2022-02-01 00:00:00',NULL,'548',80858.45,80858.45,'548','2022-02-01 17:26:31','535','2022-02-01 19:48:20',10,0),('1','65',257670,'Afternoon ','2022-02-01','2022-02-01 00:00:00',NULL,'548',218908.75,218908.75,'548','2022-02-01 20:13:24','535','2022-02-01 20:33:16',10,0),('1','65',257671,'MORNING','2022-02-02','2022-02-02 00:00:00',NULL,'548',371697.75,371697.75,'548','2022-02-02 14:04:08','535','2022-02-02 15:37:50',10,0),('1','65',257672,'AFTERNOON','2022-02-02','2022-02-02 00:00:00',NULL,'548',32992.35,32992.35,'548','2022-02-03 10:01:15','535','2022-02-03 11:19:41',10,0),('1','65',257673,'MORNING','2022-02-03','2022-02-03 00:00:00',NULL,'548',39923.70,39923.70,'548','2022-02-03 14:58:35','535','2022-02-03 16:46:26',10,0),('1','65',257674,'AFTERNOON','2022-02-03','2022-02-03 00:00:00',NULL,'548',55804.85,55804.85,'548','2022-02-04 08:32:02','535','2022-02-04 10:17:48',10,0),('1','65',257675,'MORNING','2022-02-04','2022-02-04 00:00:00',NULL,'548',729802.90,729802.90,'548','2022-02-04 15:54:46','535','2022-02-04 16:08:54',10,0),('1','65',257676,'AFTERNOON','2022-02-04','2022-02-04 00:00:00',NULL,'548',328711.70,328711.70,'548','2022-02-04 19:59:28','535','2022-02-04 20:54:53',10,0),('1','65',257677,'MORNING','2022-02-05','2022-02-05 00:00:00',NULL,'548',19000.00,19000.00,'548','2022-02-05 15:04:20','535','2022-02-05 16:22:28',10,0),('1','65',257678,'AFTERNOON','2022-02-05','2022-02-05 00:00:00',NULL,'548',56779.60,56779.60,'548','2022-02-06 10:45:51','535','2022-02-06 12:10:21',10,0),('1','65',257679,'MORNING','2022-02-06','2022-02-06 00:00:00',NULL,'548',6935.00,6935.00,'548','2022-02-06 13:59:08','535','2022-02-06 14:23:17',10,0),('1','65',257680,'AFTERNOON','2022-02-06','2022-02-06 00:00:00',NULL,'548',101954.00,101954.00,'548','2022-02-07 07:38:22','535','2022-02-07 09:32:55',10,0),('1','65',257681,'MORNING','2022-02-07','2022-02-07 00:00:00',NULL,'548',330991.40,330991.40,'548','2022-02-07 13:54:47','535','2022-02-07 14:09:33',10,0),('1','65',257682,'AFTERNOON','2022-02-07','2022-02-07 00:00:00',NULL,'548',56950.60,56950.60,'548','2022-02-07 20:15:05','535','2022-02-08 06:09:10',10,0),('1','65',257683,'MORNING','2022-02-08','2022-02-08 00:00:00',NULL,'548',188685.20,188685.20,'548','2022-02-08 13:56:25','535','2022-02-08 14:46:14',10,0),('1','65',257684,'AFTERNOON','2022-02-08','2022-02-08 00:00:00',NULL,'548',410453.20,410453.20,'548','2022-02-08 19:57:37','535','2022-02-08 19:58:00',10,0),('1','65',257685,'MORNING','2022-02-09','2022-02-09 00:00:00',NULL,'548',125661.90,125661.90,'548','2022-02-09 16:14:31','535','2022-02-09 18:13:19',10,0),('1','65',257686,'AFTERNOON','2022-02-09','2022-02-09 00:00:00',NULL,'548',19815.90,19815.90,'548','2022-02-10 11:30:33','535','2022-02-10 13:50:51',10,0),('1','65',257687,'MORNING','2022-02-10','2022-02-10 00:00:00',NULL,'548',241776.60,241776.60,'548','2022-02-10 14:31:47','535','2022-02-10 15:43:26',10,0),('1','65',257688,'AFTERNOON','2022-02-10','2022-02-10 00:00:00',NULL,'548',362817.00,362817.00,'548','2022-02-11 11:25:59','535','2022-02-11 11:40:14',10,0),('1','65',257689,'MORNING','2022-02-11','2022-02-11 00:00:00',NULL,'548',365511.90,365511.90,'548','2022-02-11 15:30:02','535','2022-02-11 17:17:38',10,0),('1','65',257690,'AFTERNOON','2022-02-11','2022-02-11 00:00:00',NULL,'548',272836.20,272836.20,'548','2022-02-11 20:05:58','535','2022-02-11 20:46:09',10,0),('1','65',257691,'MORNING','2022-02-12','2022-02-12 00:00:00',NULL,'548',714101.70,714101.70,'548','2022-02-12 15:40:22','535','2022-02-12 15:56:41',10,0),('1','65',257692,'AFTERNOON','2022-02-12','2022-02-12 00:00:00',NULL,'548',20500.00,20500.00,'548','2022-02-12 20:04:06','535','2022-02-13 05:34:56',10,0),('1','65',257693,'MORNING','2022-02-13','2022-02-13 00:00:00',NULL,'548',8286.10,8286.10,'548','2022-02-13 13:55:20','535','2022-02-13 14:55:55',10,0),('1','65',257694,'AFTERNOON','2022-02-13','2022-02-13 00:00:00',NULL,'548',41205.00,41205.00,'548','2022-02-14 10:01:05','535','2022-02-14 13:46:19',10,0),('1','65',257695,'MORNING','2022-02-14','2022-02-14 00:00:00',NULL,'548',78703.60,78703.60,'548','2022-02-14 15:31:31','535','2022-02-14 16:32:41',10,0),('1','65',257696,'AFTERNOON','2022-02-14','2022-02-14 00:00:00',NULL,'548',217295.90,217295.90,'548','2022-02-15 10:53:39','535','2022-02-15 14:48:36',10,0),('1','65',257697,'MORNING','2022-02-15','2022-02-15 00:00:00',NULL,'548',145996.90,145996.90,'548','2022-02-15 17:59:57','535','2022-02-15 19:15:31',10,0),('1','65',257698,'AFTERNOON','2022-02-15','2022-02-15 00:00:00',NULL,'548',45259.90,45259.90,'548','2022-02-16 10:06:56','535','2022-02-16 12:11:25',10,0),('1','65',257699,'MORNING','2022-02-16','2022-02-16 00:00:00',NULL,'548',281399.40,281399.40,'548','2022-02-16 13:46:52','535','2022-02-16 14:42:55',10,0),('1','65',257700,'AFTERNOON','2022-02-16','2022-02-16 00:00:00',NULL,'548',417978.60,417978.60,'548','2022-02-16 20:08:33','535','2022-02-17 05:31:40',10,0),('1','65',257701,'MORNING','2022-02-17','2022-02-17 00:00:00',NULL,'548',149949.30,149949.30,'548','2022-02-17 13:56:30','535','2022-02-17 14:58:37',10,0),('1','65',257702,'AFTERNOON','2022-02-17','2022-02-17 00:00:00',NULL,'548',78683.10,78683.10,'548','2022-02-17 20:17:35','535','2022-02-18 07:43:45',10,0),('1','65',257703,'MORNING','2022-02-18','2022-02-18 00:00:00',NULL,'548',501737.50,501737.50,'548','2022-02-18 15:23:24','535','2022-02-18 17:19:40',10,0),('1','65',257704,'AFTERNOON','2022-02-18','2022-02-18 00:00:00',NULL,'548',217242.60,217242.60,'548','2022-02-18 20:06:47','535','2022-02-18 20:15:05',10,0),('1','65',257705,'MORNING','2022-02-19','2022-02-19 00:00:00',NULL,'548',34202.20,34202.20,'548','2022-02-19 13:50:25','535','2022-02-19 14:49:20',10,0),('1','65',257706,'AFTERNOON','2022-02-19','2022-02-19 00:00:00',NULL,'548',195873.40,195873.40,'548','2022-02-19 20:02:31','535','2022-02-19 22:21:17',10,0),('1','65',257707,'MORNING','2022-02-20','2022-02-20 00:00:00',NULL,'548',33763.50,33763.50,'548','2022-02-20 13:39:39','535','2022-02-20 15:07:34',10,0),('1','65',257708,'AFTERNOON','2022-02-20','2022-02-20 00:00:00',NULL,'548',228357.70,228357.70,'548','2022-02-21 10:48:04','535','2022-02-21 16:46:45',10,0),('1','65',257709,'MORNING','2022-02-21','2022-02-22 09:33:35','2022-02-23 09:33:35','548',164455.10,164455.10,'548','2022-02-22 09:34:56','535','2022-02-22 10:09:20',10,0),('1','65',257710,'AFTERNOON','2022-02-21','2022-02-22 10:46:10','2022-02-23 10:46:10','548',486817.60,486817.60,'548','2022-02-22 10:51:35','535','2022-02-22 12:24:04',10,0),('1','65',257711,'MORNING','2022-02-22','2022-02-22 16:28:41','2022-02-23 16:28:41','548',274999.30,274999.30,'548','2022-02-22 16:30:53','535','2022-02-22 18:38:17',10,0),('1','65',257712,'AFTERNOON','2022-02-22','2022-02-23 10:45:35','2022-02-24 10:45:35','548',205000.00,205000.00,'548','2022-02-23 10:51:08','535','2022-02-23 12:57:31',10,0),('1','65',257713,'MORNING','2022-02-23','2022-02-23 15:29:27','2022-02-24 15:29:27','548',134209.40,134209.40,'548','2022-02-23 15:31:29','535','2022-02-23 17:10:02',10,0),('1','65',257714,'AFTERNOON','2022-02-23','2022-02-24 10:15:22','2022-02-25 10:15:22','548',251133.20,251133.20,'548','2022-02-24 10:20:40','535','2022-02-24 11:46:32',10,0),('1','65',257715,'MORNING','2022-02-24','2022-02-24 13:08:03','2022-02-25 13:08:03','548',289103.30,289103.30,'548','2022-02-24 13:09:04','535','2022-02-24 15:13:11',10,0),('1','65',257716,'AFTERNOON','2022-02-24','2022-02-25 12:42:46','2022-02-26 12:42:46','548',478109.20,478109.20,'548','2022-02-25 13:55:11','535','2022-02-25 14:55:07',10,0),('1','65',257717,'MORNING','2022-02-25','2022-02-25 15:40:22','2022-02-26 15:40:22','548',0.00,0.00,'548','2022-02-25 15:40:46','535','2022-02-25 19:35:03',10,0),('1','65',257718,'AFTERNOON','2022-02-25','2022-02-26 07:06:55','2022-02-27 07:06:55','548',0.00,0.00,'548','2022-02-26 07:07:17','535','2022-02-26 07:49:27',10,0),('1','65',257719,'MORNING','2022-02-26','2022-02-26 17:28:39','2022-02-27 17:28:39','548',0.00,0.00,'548','2022-02-26 17:29:14','535','2022-02-26 19:32:35',10,0),('1','65',257720,'AFTERNOON','2022-02-26','2022-02-26 21:06:41','2022-02-27 21:06:41','548',0.00,0.00,'548','2022-02-26 21:07:02','535','2022-02-26 21:32:20',10,0),('1','65',257721,'MORNING','2022-02-27','2022-02-27 15:14:28','2022-02-28 15:14:28','548',0.00,0.00,'548','2022-02-27 15:14:54','535','2022-02-27 18:03:01',10,0),('1','65',257722,'AFTERNOON','2022-02-27','2022-02-27 18:46:01','2022-02-28 18:46:01','548',0.00,0.00,'548','2022-02-27 18:46:28','535','2022-02-28 06:21:58',10,0),('1','65',257723,'MORNING','2022-02-28','2022-02-28 15:00:03','2022-03-01 15:00:03','548',0.00,0.00,'548','2022-02-28 15:00:29','535','2022-02-28 15:10:39',10,0),('1','65',257724,'AFTERNOON','2022-02-28','2022-02-28 20:28:28','2022-03-01 20:28:28','548',0.00,0.00,'548','2022-02-28 20:28:56','535','2022-02-28 21:02:00',10,0),('1','65',257725,'MORNING','2022-03-01','2022-03-01 14:35:08','2022-03-02 14:35:08','548',0.00,0.00,'548','2022-03-01 14:35:33','535','2022-03-01 15:04:32',10,0),('1','65',257726,'AFTERNOON','2022-03-01','2022-03-01 20:48:42','2022-03-02 20:48:42','548',0.00,0.00,'548','2022-03-01 20:49:31','535','2022-03-01 22:45:58',10,0),('1','65',257727,'MORNING','2022-03-02','2022-03-02 14:03:59','2022-03-03 14:03:59','548',0.00,0.00,'548','2022-03-02 14:04:26','535','2022-03-02 14:12:07',10,0),('1','65',257728,'AFTERNOON','2022-03-02','2022-03-02 20:44:12','2022-03-03 20:44:12','548',0.00,0.00,'548','2022-03-02 20:44:44','535','2022-03-03 00:10:43',10,0),('1','65',257729,'MORNING','2022-03-03','2022-03-03 14:11:58','2022-03-04 14:11:58','548',0.00,0.00,'548','2022-03-03 14:12:33','535','2022-03-03 16:15:44',10,0),('1','65',257730,'AFTERNOON','2022-03-03','2022-03-03 20:03:49','2022-03-04 20:03:49','548',8608.60,8608.60,'548','2022-03-03 20:06:51','535','2022-03-03 20:25:59',10,0),('1','65',257731,'MORNING','2022-03-04','2022-03-04 17:11:32','2022-03-05 17:11:32','548',502842.00,502842.00,'548','2022-03-04 17:14:01','535','2022-03-04 17:50:26',10,0),('1','65',257732,'AFTERNOON','2022-03-04','2022-03-04 20:09:58','2022-03-05 20:09:58','548',840503.80,840503.80,'548','2022-03-04 20:16:48','535','2022-03-05 06:22:14',10,0),('1','65',257733,'MORNING','2022-03-05','2022-03-05 13:35:05','2022-03-06 13:35:05','548',33170.60,33170.60,'548','2022-03-05 13:39:48','535','2022-03-05 16:41:25',10,0),('1','65',257734,'AFTERNOON','2022-03-05','2022-03-05 20:02:18','2022-03-06 20:02:18','548',1784919.60,1784919.60,'548','2022-03-05 20:08:37','535','2022-03-06 00:28:48',10,0),('1','65',257735,'MORNING','2022-03-06','2022-03-06 14:08:01','2022-03-07 14:08:01','548',14755.00,14755.00,'548','2022-03-06 14:09:23','535','2022-03-06 14:53:23',10,0),('1','65',257736,'AFTERNOON','2022-03-06','2022-03-06 20:16:16','2022-03-07 20:16:16','548',239915.00,239915.00,'548','2022-03-06 20:20:51','535','2022-03-07 12:01:01',10,0),('1','65',257737,'MORNING','2022-03-07','2022-03-07 18:44:46','2022-03-08 18:44:46','548',341635.00,341635.00,'548','2022-03-07 18:46:09','535','2022-03-08 06:20:10',10,0),('1','65',257738,'AFTERNOON','2022-03-07','2022-03-08 09:30:17','2022-03-09 09:30:17','548',6900.00,6900.00,'548','2022-03-08 09:46:42','535','2022-03-08 15:08:40',10,0),('1','65',257739,'MORNING','2022-03-08','2022-03-08 17:25:23','2022-03-09 17:25:23','548',1002415.00,1002415.00,'548','2022-03-08 17:29:43','535','2022-03-09 06:21:08',10,0),('1','65',257740,'AFTERNOON','2022-03-08','2022-03-09 11:06:08','2022-03-10 11:06:08','548',25800.00,25800.00,'548','2022-03-09 11:12:23','535','2022-03-09 12:20:06',10,0),('1','65',257741,'MORNING','2022-03-09','2022-03-09 15:46:51','2022-03-10 15:46:51','548',24000.00,24000.00,'548','2022-03-09 15:49:16','535','2022-03-09 18:10:52',10,0),('1','65',257742,'AFTERNOON','2022-03-09','2022-03-10 09:41:50','2022-03-11 09:41:50','548',29526.00,29526.00,'548','2022-03-10 09:49:18','535','2022-03-10 12:30:51',10,0),('1','65',257743,'MORNING','2022-03-10','2022-03-10 13:34:45','2022-03-11 13:34:45','548',14946.00,14946.00,'548','2022-03-10 13:36:00','535','2022-03-10 16:27:58',10,0),('1','65',257744,'AFTERNOON','2022-03-10','2022-03-10 20:20:59','2022-03-11 20:20:59','548',70068.00,70068.00,'548','2022-03-10 20:27:34','535','2022-03-11 11:52:12',10,0),('1','65',257745,'MORNING','2022-03-11','2022-03-11 15:32:41','2022-03-12 15:32:41','548',178056.00,178056.00,'548','2022-03-11 15:34:35','535','2022-03-11 15:45:15',10,0),('1','65',257746,'AFTERNOON','2022-03-11','2022-03-11 23:28:51','2022-03-12 23:28:51','548',3252.00,3252.00,'548','2022-03-11 23:32:23','535','2022-03-12 10:34:02',10,0),('1','65',257747,'MORNING','2022-03-12','2022-03-12 17:04:34','2022-03-13 17:04:34','548',15402.00,15402.00,'548','2022-03-12 17:06:24','535','2022-03-13 06:08:37',10,0),('1','65',257748,'AFTERNOON','2022-03-13','2022-03-13 13:53:04','2022-03-14 13:53:04','548',68100.00,68100.00,'548','2022-03-13 13:59:17','535','2022-03-13 16:28:10',10,0),('1','65',257749,'MORNING','2022-03-13','2022-03-13 20:03:34','2022-03-14 20:03:34','548',275100.00,275100.00,'548','2022-03-13 20:05:03','535','2022-03-14 05:31:58',10,0),('1','65',257750,'AFTERNOON','2022-03-13','2022-03-14 10:30:31','2022-03-15 10:30:31','548',599208.00,599208.00,'548','2022-03-14 10:38:19','535','2022-03-14 19:21:00',10,0),('1','65',257751,'MORNING','2022-03-14','2022-03-14 19:33:03','2022-03-15 19:33:03','548',86988.00,86988.00,'548','2022-03-14 19:34:14','535','2022-03-15 07:19:59',10,0),('1','65',257752,'AFTERNOON','2022-03-14','2022-03-15 09:56:00','2022-03-16 09:56:00','548',1149318.00,1149318.00,'548','2022-03-15 10:02:34','535','2022-03-15 15:01:59',10,0),('1','65',257753,'MORNING','2022-03-15','2022-03-15 17:02:49','2022-03-16 17:02:49','548',432568.50,432568.50,'548','2022-03-15 17:04:46','535','2022-03-15 19:30:21',10,0),('1','65',257754,'AFTERNOON','2022-03-15','2022-03-15 20:09:31','2022-03-16 20:09:31','548',979348.50,979348.50,'548','2022-03-15 20:14:42','535','2022-03-16 07:19:11',10,0),('1','65',257755,'MORNING','2022-03-16','2022-03-16 14:27:13','2022-03-17 14:27:13','548',256275.50,256275.50,'548','2022-03-16 14:29:02','535','2022-03-16 17:51:18',10,0),('1','65',257756,'AFTERNOON','2022-03-16','2022-03-17 08:10:32','2022-03-18 08:10:32','548',1127100.00,1127100.00,'548','2022-03-17 08:22:00','535','2022-03-17 10:19:20',10,0),('1','65',257757,'MORNING','2022-03-17','2022-03-17 17:35:49','2022-03-18 17:35:49','548',532499.50,532499.50,'548','2022-03-17 17:37:07','202','2022-03-18 11:26:17',10,0),('1','65',257758,'AFTERNOON','2022-03-17','2022-03-18 11:39:33','2022-03-19 11:39:33','548',1540493.50,1540493.50,'548','2022-03-18 11:45:08','535','2022-03-18 12:23:20',10,0),('1','65',257759,'MORNING','2022-03-18','2022-03-18 20:03:31','2022-03-19 20:03:31','548',0.00,0.00,'548','2022-03-18 20:03:53','535','2022-03-19 07:36:53',10,0),('1','65',257760,'AFTERNOON','2022-03-18','2022-03-19 15:12:00','2022-03-20 15:12:00','548',0.00,0.00,'548','2022-03-19 15:12:51','535','2022-03-19 15:34:01',10,0),('1','65',257761,'MORNING','2022-03-19','2022-03-19 20:24:22','2022-03-20 20:24:22','548',0.00,0.00,'548','2022-03-19 20:25:11','535','2022-03-19 21:24:41',10,0),('1','65',257762,'AFTERNOON','2022-03-19','2022-03-20 14:10:48','2022-03-21 14:10:48','548',0.00,0.00,'548','2022-03-20 14:11:21','535','2022-03-20 14:38:06',10,0),('1','65',257763,'MORNING','2022-03-20','2022-03-20 18:47:56','2022-03-21 18:47:56','548',0.00,0.00,'548','2022-03-20 18:48:47','535','2022-03-21 07:19:44',10,0),('1','65',257764,'AFTERNOON','2022-03-20','2022-03-21 10:01:59','2022-03-22 10:01:59','548',0.00,0.00,'548','2022-03-21 10:02:33','535','2022-03-21 14:26:02',10,0),('1','65',257765,'MORNING','2022-03-21','2022-03-21 16:53:55','2022-03-22 16:53:55','548',0.00,0.00,'548','2022-03-21 16:54:28','535','2022-03-21 17:13:52',10,0),('1','65',257766,'AFTERNOON','2022-03-21','2022-03-22 06:14:06','2022-03-23 06:14:06','548',0.00,0.00,'548','2022-03-22 06:14:54','535','2022-03-22 10:00:46',10,0),('1','65',257767,'MORNING','2022-03-22','2022-03-22 13:09:08','2022-03-23 13:09:08','548',0.00,0.00,'548','2022-03-22 13:09:35','535','2022-03-22 14:57:39',10,0),('1','65',257768,'AFTERNOON','2022-03-22','2022-03-22 20:54:16','2022-03-23 20:54:16','548',0.00,0.00,'548','2022-03-22 20:54:57','535','2022-03-22 23:20:41',10,0),('1','65',257769,'MORNING','2022-03-23','2022-03-23 14:27:26','2022-03-24 14:27:26','548',0.00,0.00,'548','2022-03-23 14:27:43','535','2022-03-23 14:45:14',10,0),('1','65',257770,'AFTERNOON','2022-03-23','2022-03-23 20:18:59','2022-03-24 20:18:59','548',0.00,0.00,'548','2022-03-23 20:19:26','535','2022-03-23 21:22:35',10,0),('1','65',257771,'MORNING','2022-03-24','2022-03-24 20:00:29','2022-03-25 20:00:29','548',0.00,0.00,'548','2022-03-24 20:00:48','535','2022-03-25 07:12:27',10,0),('1','65',257772,'AFTERNOON','2022-03-24','2022-03-25 10:22:54','2022-03-26 10:22:54','548',0.00,0.00,'548','2022-03-25 10:23:38','535','2022-03-25 15:42:08',10,0),('1','65',257773,'MORNING','2022-03-25','2022-03-25 19:15:31','2022-03-26 19:15:31','548',0.00,0.00,'548','2022-03-25 19:15:58','535','2022-03-25 22:44:29',10,0),('1','65',257774,'AFTERNOON','2022-03-25','2022-03-26 13:00:51','2022-03-27 13:00:51','548',0.00,0.00,'548','2022-03-26 13:01:31','535','2022-03-26 16:55:31',10,0),('1','65',257775,'MORNING','2022-03-26','2022-03-26 16:59:34','2022-03-27 16:59:34','548',0.00,0.00,'548','2022-03-26 17:00:02','535','2022-03-26 19:11:17',10,0),('1','65',257776,'AFTERNOON','2022-03-26','2022-03-26 19:59:00','2022-03-27 19:59:00','548',0.00,0.00,'548','2022-03-26 19:59:43','535','2022-03-27 10:28:56',10,0),('1','65',257777,'MORNING','2022-03-27','2022-03-27 14:02:54','2022-03-28 14:02:54','548',0.00,0.00,'548','2022-03-27 14:06:40','535','2022-03-27 16:14:20',10,0),('1','65',257778,'AFTERNOON','2022-03-27','2022-03-28 10:42:13','2022-03-29 10:42:13','548',82999.00,82999.00,'548','2022-03-28 10:43:17','535','2022-03-28 11:17:43',10,0),('1','65',257779,'MORNING','2022-03-28','2022-03-28 21:33:28','2022-03-29 21:33:28','548',189994.00,189994.00,'548','2022-03-28 21:34:52','535','2022-03-29 06:19:03',10,0),('1','65',257780,'AFTERNOON','2022-03-28','2022-03-29 10:30:46','2022-03-30 10:30:46','548',105644.00,105644.00,'548','2022-03-29 10:32:30','535','2022-03-29 14:20:07',10,0),('1','65',257781,'MORNING','2022-03-29','2022-03-29 18:53:09','2022-03-30 18:53:09','548',686000.00,686000.00,'548','2022-03-29 18:53:54','535','2022-03-29 19:22:23',10,0),('1','65',257782,'AFTERNOON','2022-03-29','2022-03-30 09:54:22','2022-03-31 09:54:22','548',138789.00,138789.00,'548','2022-03-30 09:55:52','535','2022-03-30 12:19:29',10,0),('1','65',257783,'MORNING','2022-03-30','2022-03-30 13:40:27','2022-03-31 13:40:27','548',1222998.00,1222998.00,'548','2022-03-30 13:41:47','535','2022-03-30 18:16:42',10,0),('1','65',257784,'AFTERNOON','2022-03-30','2022-03-30 20:44:25','2022-03-31 20:44:25','548',1201648.00,1201648.00,'548','2022-03-30 20:49:23','535','2022-03-30 21:50:01',10,0),('1','65',257785,'MORNING','2022-03-31','2022-03-31 13:48:34','2022-04-01 13:48:34','548',399994.00,399994.00,'548','2022-03-31 13:49:49','535','2022-03-31 18:38:02',10,0),('1','65',257786,'AFTERNOON','2022-03-31','2022-03-31 22:37:09','2022-04-01 22:37:09','548',1029000.00,1029000.00,'548','2022-03-31 22:38:32','535','2022-04-01 11:07:36',10,0),('1','65',257787,'MORNING','2022-04-01','2022-04-01 13:59:47','2022-04-02 13:59:47','548',608209.00,608209.00,'548','2022-04-01 14:07:05','535','2022-04-01 17:43:46',10,0),('1','65',257788,'AFTERNOON','2022-04-01','2022-04-02 12:53:04','2022-04-03 12:53:04','548',399308.00,399308.00,'548','2022-04-02 12:58:17','535','2022-04-02 15:06:03',10,0),('1','65',257789,'MORNING','2022-04-02','2022-04-02 16:06:15','2022-04-03 16:06:15','548',5201.00,5201.00,'548','2022-04-02 16:07:56','535','2022-04-02 16:23:17',10,0),('1','65',257790,'AFTERNOON','2022-04-02','2022-04-03 10:34:36','2022-04-04 10:34:36','548',91000.00,91000.00,'548','2022-04-03 11:07:02','535','2022-04-03 14:10:52',10,0),('1','65',257791,'MORNING','2022-04-03','2022-04-03 17:12:24','2022-04-04 17:12:24','548',22246.00,22246.00,'548','2022-04-03 17:16:26','535','2022-04-03 18:09:56',10,0),('1','65',257792,'AFTERNOON','2022-04-03','2022-04-03 20:29:48','2022-04-04 20:29:48','548',653100.00,653100.00,'548','2022-04-03 20:44:37','535','2022-04-04 09:14:05',10,0),('1','65',257793,'MORNING','2022-04-04','2022-04-04 16:12:09','2022-04-05 16:12:09','548',833000.00,833000.00,'548','2022-04-04 16:13:57','535','2022-04-04 16:32:23',10,0),('1','65',257794,'AFTERNOON','2022-04-04','2022-04-05 10:43:18','2022-04-06 10:43:18','548',58450.00,58450.00,'548','2022-04-05 10:54:04','535','2022-04-05 13:07:39',10,0),('1','65',257795,'MORNING','2022-04-05','2022-04-05 14:48:49','2022-04-06 14:48:49','548',270585.00,270585.00,'548','2022-04-05 14:50:31','535','2022-04-05 15:45:02',10,0),('1','65',257796,'AFTERNOON','2022-04-05','2022-04-06 10:44:37','2022-04-07 10:44:37','548',289499.00,289499.00,'548','2022-04-06 10:46:47','535','2022-04-06 11:06:51',10,0),('1','65',257797,'MORNING','2022-04-06','2022-04-06 14:25:54','2022-04-07 14:25:54','548',75936.00,75936.00,'548','2022-04-06 14:27:13','535','2022-04-06 14:43:12',10,0),('1','65',257798,'AFTERNOON','2022-04-06','2022-04-06 22:01:54','2022-04-07 22:01:54','548',174412.00,174412.00,'548','2022-04-06 22:07:58','535','2022-04-07 07:01:01',10,0),('1','65',257799,'MORNING','2022-04-07','2022-04-07 15:27:44','2022-04-08 15:27:44','548',164997.00,164997.00,'548','2022-04-07 15:29:25','535','2022-04-08 05:11:16',10,0),('1','65',257800,'AFTERNOON','2022-04-07','2022-04-08 06:15:32','2022-04-09 06:15:32','548',392000.00,392000.00,'548','2022-04-08 06:18:36','535','2022-04-08 11:30:01',10,0),('1','65',257801,'MORNING','2022-04-08','2022-04-08 13:57:03','2022-04-09 13:57:03','548',864661.00,864661.00,'548','2022-04-08 14:00:00','535','2022-04-08 17:55:08',10,0),('1','65',257802,'AFTERNOON','2022-04-08','2022-04-09 04:06:23','2022-04-10 04:06:23','548',20139.00,20139.00,'548','2022-04-09 04:16:48','535','2022-04-09 07:59:37',10,0),('1','65',257803,'MORNING','2022-04-09','2022-04-09 08:26:19','2022-04-10 08:26:19','548',75404.00,75404.00,'548','2022-04-09 14:42:08','535','2022-04-09 16:42:11',10,0),('1','65',257804,'AFTERNOON','2022-04-09','2022-04-10 10:20:18','2022-04-11 10:20:18','548',179032.00,179032.00,'548','2022-04-10 10:21:53','535','2022-04-10 12:27:33',10,0),('1','65',257805,'MORNING','2022-04-10','2022-04-10 16:57:21','2022-04-11 16:57:21','548',3101.00,3101.00,'548','2022-04-10 16:58:32','535','2022-04-10 22:19:17',10,0),('1','65',257806,'AFTERNOON','2022-04-10','2022-04-11 05:38:27','2022-04-12 05:38:27','548',5208.00,5208.00,'548','2022-04-11 05:40:33','535','2022-04-11 09:55:58',10,0),('1','65',257807,'MORNING','2022-04-11','2022-04-11 15:58:15','2022-04-12 15:58:15','548',4578.00,4578.00,'548','2022-04-11 15:59:14','535','2022-04-11 16:32:52',10,0),('1','65',257808,'AFTERNOON','2022-04-11','2022-04-12 04:33:44','2022-04-13 04:33:44','548',8918.00,8918.00,'548','2022-04-12 04:35:23','535','2022-04-12 06:50:07',10,0),('1','65',257809,'MORNING','2022-04-12','2022-04-12 17:05:39','2022-04-13 17:05:39','548',42700.00,42700.00,'548','2022-04-12 17:06:53','535','2022-04-12 18:22:08',10,0),('1','65',257810,'AFTERNOON','2022-04-12','2022-04-13 09:29:17','2022-04-14 09:29:17','548',185500.00,185500.00,'548','2022-04-13 09:30:13','535','2022-04-13 11:03:34',10,0),('1','65',257811,'MORNING','2022-04-13','2022-04-13 14:05:52','2022-04-14 14:05:52','548',241500.00,241500.00,'548','2022-04-13 14:08:58','535','2022-04-13 15:37:39',10,0),('1','65',257812,'AFTERNOON','2022-04-13','2022-04-14 09:11:23','2022-04-15 09:11:23','548',386400.00,386400.00,'548','2022-04-14 09:15:56','535','2022-04-14 11:58:20',10,0),('1','65',257813,'MORNING','2022-04-14','2022-04-14 16:28:10','2022-04-15 16:28:10','548',104475.00,104475.00,'548','2022-04-14 16:29:23','535','2022-04-14 16:41:06',10,0),('1','65',257814,'AFTERNOON','2022-04-14','2022-04-15 08:04:49','2022-04-16 08:04:49','548',120925.00,120925.00,'548','2022-04-15 08:05:59','535','2022-04-15 12:48:28',10,0),('1','65',257815,'MORNING','2022-04-15','2022-04-15 13:59:16','2022-04-16 13:59:16','548',175875.00,175875.00,'548','2022-04-15 14:00:30','535','2022-04-15 17:27:18',10,0),('1','65',257816,'AFTERNOON','2022-04-15','2022-04-16 09:42:29','2022-04-17 09:42:29','548',112448.00,112448.00,'548','2022-04-16 09:43:40','535','2022-04-16 13:06:02',10,0),('1','65',257817,'MORNING','2022-04-16','2022-04-16 13:37:06','2022-04-17 13:37:06','548',246435.00,246435.00,'548','2022-04-16 13:38:48','535','2022-04-16 13:41:22',10,0),('1','65',257818,'AFTERNOON','2022-04-16','2022-04-17 09:17:57','2022-04-18 09:17:57','548',30100.00,30100.00,'548','2022-04-17 09:19:17','535','2022-04-17 10:43:34',10,0),('1','65',257819,'MORNING','2022-04-17','2022-04-17 13:54:00','2022-04-18 13:54:00','548',587153.00,587153.00,'548','2022-04-17 13:55:20','535','2022-04-17 15:28:45',10,0),('1','65',257820,'AFTERNOON','2022-04-17','2022-04-18 04:16:08','2022-04-19 04:16:08','548',0.00,0.00,'548','2022-04-18 04:16:50','535','2022-04-18 08:42:13',10,0),('1','65',257821,'MORNING','2022-04-18','2022-04-18 14:37:25','2022-04-19 14:37:25','548',0.00,0.00,'548','2022-04-18 14:37:49','535','2022-04-18 15:54:57',10,0),('1','65',257822,'AFTERNOON','2022-04-18','2022-04-19 09:29:37','2022-04-20 09:29:37','548',0.00,0.00,'548','2022-04-19 09:30:02','535','2022-04-19 10:35:30',10,0),('1','65',257823,'MORNING','2022-04-19','2022-04-19 16:10:28','2022-04-20 16:10:28','548',0.00,0.00,'548','2022-04-19 16:10:54','535','2022-04-19 16:22:42',10,0),('1','65',257824,'AFTERNOON','2022-04-19','2022-04-20 15:01:18','2022-04-21 15:01:18','548',0.00,0.00,'548','2022-04-20 15:02:12','535','2022-04-20 16:42:55',10,0),('1','65',257825,'MORNING','2022-04-20','2022-04-20 18:26:17','2022-04-21 18:26:17','548',0.00,0.00,'548','2022-04-20 18:26:36','535','2022-04-20 18:41:18',10,0),('1','65',257826,'AFTERNOON','2022-04-20','2022-04-20 20:52:30','2022-04-21 20:52:30','548',0.00,0.00,'548','2022-04-20 20:53:05','535','2022-04-21 05:54:45',10,0),('1','65',257827,'MORNING','2022-04-21','2022-04-21 16:55:55','2022-04-22 16:55:55','548',0.00,0.00,'548','2022-04-21 16:56:32','535','2022-04-21 17:58:37',10,0),('1','65',257828,'AFTERNOON','2022-04-21','2022-04-21 21:37:23','2022-04-22 21:37:23','548',0.00,0.00,'548','2022-04-22 03:54:38','535','2022-04-22 11:08:35',10,0),('1','65',257829,'MORNING','2022-04-22','2022-04-22 15:45:50','2022-04-23 15:45:50','548',0.00,0.00,'548','2022-04-22 15:46:18','535','2022-04-22 17:06:23',10,0),('1','65',257830,'AFTERNOON','2022-04-22','2022-04-23 09:16:01','2022-04-24 09:16:01','548',0.00,0.00,'548','2022-04-23 09:16:21','535','2022-04-23 12:42:49',10,0),('1','65',257831,'MORNING','2022-04-23','2022-04-23 14:08:12','2022-04-24 14:08:12','548',0.00,0.00,'548','2022-04-23 14:08:32','535','2022-04-23 15:21:49',10,0),('1','65',257832,'AFTERNOON','2022-04-23','2022-04-23 20:22:41','2022-04-24 20:22:41','548',0.00,0.00,'548','2022-04-23 20:23:14','535','2022-04-24 11:13:27',10,0),('1','65',257833,'MORNING','2022-04-24','2022-04-24 20:16:55','2022-04-25 20:16:55','548',0.00,0.00,'548','2022-04-24 20:17:16','535','2022-04-24 20:54:49',10,0),('1','65',257834,'AFTERNOON','2022-04-24','2022-04-25 10:10:03','2022-04-26 10:10:03','548',0.00,0.00,'548','2022-04-25 10:10:27','535','2022-04-25 13:48:37',10,0),('1','65',257835,'MORNING','2022-04-25','2022-04-25 20:24:42','2022-04-26 20:24:42','548',0.00,0.00,'548','2022-04-25 20:25:09','535','2022-04-26 06:16:09',10,0),('1','65',257836,'AFTERNOON','2022-04-25','2022-04-26 13:54:18','2022-04-27 13:54:18','548',0.00,0.00,'548','2022-04-26 13:54:43','535','2022-04-26 14:31:35',10,0),('1','65',257837,'MORNING','2022-04-26','2022-04-26 15:51:11','2022-04-27 15:51:11','548',0.00,0.00,'548','2022-04-26 15:51:38','535','2022-04-26 16:37:14',10,0),('1','65',257838,'AFTERNOON','2022-04-26','2022-04-26 20:07:06','2022-04-27 20:07:06','548',0.00,0.00,'548','2022-04-26 20:07:30','535','2022-04-27 13:22:47',10,0),('1','65',257839,'MORNING','2022-04-27','2022-04-27 18:13:37','2022-04-28 18:13:37','548',0.00,0.00,'548','2022-04-27 18:14:03','535','2022-04-27 23:46:09',10,0),('1','65',257840,'AFTERNOON','2022-04-27','2022-04-27 23:59:13','2022-04-28 23:59:13','548',0.00,0.00,'548','2022-04-27 23:59:34','535','2022-04-28 12:06:00',10,0),('1','65',257841,'MORNING','2022-04-28','2022-04-28 15:03:39','2022-04-29 15:03:39','548',0.00,0.00,'548','2022-04-28 15:04:37','535','2022-04-29 08:51:00',10,0),('1','65',257842,'AFTERNOON','2022-04-28','2022-04-30 13:03:45','2022-05-01 13:03:45','548',0.00,0.00,'548','2022-04-30 13:04:11','535','2022-04-30 14:57:05',10,0),('1','65',257843,'MORNING','2022-04-29','2022-04-30 15:15:13','2022-05-01 15:15:13','548',0.00,0.00,'548','2022-04-30 15:15:40','535','2022-04-30 20:42:07',10,0),('1','65',257844,'AFTERNOON','2022-04-29','2022-05-01 15:45:40','2022-05-02 15:45:40','548',0.00,0.00,'548','2022-05-01 15:46:12','535','2022-05-01 16:22:01',10,0),('1','65',257845,'MORNING','2022-04-30','2022-05-01 16:49:24','2022-05-02 16:49:24','548',0.00,0.00,'548','2022-05-01 16:50:47','535','2022-05-01 17:29:21',10,0),('1','65',257846,'AFTERNOON','2022-04-30','2022-05-01 19:16:00','2022-05-02 19:16:00','548',0.00,0.00,'548','2022-05-01 19:16:35','535','2022-05-01 21:03:35',10,0),('1','65',257847,'MORNING','2022-05-01','2022-05-01 22:14:16','2022-05-02 22:14:16','548',0.00,0.00,'548','2022-05-01 22:15:43','535','2022-05-02 00:43:31',10,0),('1','65',257848,'AFTERNOON','2022-05-01','2022-05-02 06:04:34','2022-05-03 06:04:34','548',0.00,0.00,'548','2022-05-02 06:05:08','535','2022-05-02 08:21:46',10,0),('1','65',257849,'MORNING','2022-05-02','2022-05-02 16:37:32','2022-05-03 16:37:32','548',0.00,0.00,'548','2022-05-02 16:38:00','535','2022-05-02 19:07:50',10,0),('1','65',257850,'AFTERNOON','2022-05-02','2022-05-02 19:11:23','2022-05-03 19:11:23','548',0.00,0.00,'548','2022-05-02 19:11:44','535','2022-05-03 06:35:15',10,0),('1','65',257851,'MORNING','2022-05-03','2022-05-03 14:06:30','2022-05-04 14:06:30','548',0.00,0.00,'548','2022-05-03 14:06:58','535','2022-05-03 14:09:37',10,0),('1','65',257852,'AFTERNOON','2022-05-03','2022-05-04 05:21:27','2022-05-05 05:21:27','548',0.00,0.00,'548','2022-05-04 05:21:59','535','2022-05-04 09:33:33',10,0),('1','65',257853,'MORNING','2022-05-04','2022-05-04 14:05:59','2022-05-05 14:05:59','548',0.00,0.00,'548','2022-05-04 14:06:29','535','2022-05-04 14:49:38',10,0),('1','65',257854,'AFTERNOON','2022-05-04','2022-05-04 20:08:01','2022-05-05 20:08:01','548',0.00,0.00,'548','2022-05-04 20:08:53','535','2022-05-05 08:39:27',10,0),('1','65',257855,'MORNING','2022-05-05','2022-05-05 19:02:54','2022-05-06 19:02:54','548',0.00,0.00,'548','2022-05-05 19:03:12','535','2022-05-05 21:29:24',10,0),('1','65',257856,'AFTERNOON','2022-05-05','2022-05-06 06:37:29','2022-05-07 06:37:29','548',0.00,0.00,'548','2022-05-06 06:37:57','535','2022-05-06 12:12:21',10,0),('1','65',257857,'MORNING','2022-05-06','2022-05-06 19:06:25','2022-05-07 19:06:25','548',0.00,0.00,'548','2022-05-06 19:06:49','535','2022-05-06 19:19:56',10,0),('1','65',257858,'AFTERNOON','2022-05-06','2022-05-07 19:07:20','2022-05-08 19:07:20','548',0.00,0.00,'548','2022-05-07 19:07:56','535','2022-05-08 05:59:35',10,0),('1','65',257859,'MORNING','2022-05-07','2022-05-08 08:28:33','2022-05-09 08:28:33','548',0.00,0.00,'548','2022-05-08 08:29:00','535','2022-05-08 10:52:14',10,0),('1','65',257860,'AFTERNOON','2022-05-07','2022-05-08 16:54:05','2022-05-09 16:54:05','548',0.00,0.00,'548','2022-05-08 16:54:34','535','2022-05-08 18:15:00',10,0),('1','65',257861,'MORNING','2022-05-08','2022-05-09 21:25:23','2022-05-10 21:25:23','548',0.00,0.00,'548','2022-05-09 21:25:41','535','2022-05-10 05:45:08',10,0),('1','65',257862,'AFTERNOON','2022-05-08','2022-05-10 13:06:50','2022-05-11 13:06:50','548',0.00,0.00,'548','2022-05-10 13:07:34','535','2022-05-10 16:17:28',10,0),('1','65',257863,'MORNING','2022-05-09','2022-05-10 16:57:52','2022-05-11 16:57:52','548',0.00,0.00,'548','2022-05-10 16:58:23','535','2022-05-11 06:42:49',10,0),('1','65',257864,'AFTERNOON','2022-05-09','2022-05-11 08:51:05','2022-05-12 08:51:05','548',0.00,0.00,'548','2022-05-11 08:51:22','535','2022-05-11 18:33:11',10,0),('1','65',257865,'MORNING','2022-05-10','2022-05-11 20:15:58','2022-05-12 20:15:58','548',0.00,0.00,'548','2022-05-11 20:16:24','535','2022-05-12 12:48:25',10,0),('1','65',257866,'AFTERNOON','2022-05-10','2022-05-12 13:34:38','2022-05-13 13:34:38','548',0.00,0.00,'548','2022-05-12 13:35:00','535','2022-05-13 09:28:23',10,0),('1','65',257867,'MORNING','2022-05-11','2022-05-13 19:23:14','2022-05-14 19:23:14','548',0.00,0.00,'548','2022-05-13 19:23:36','535','2022-05-14 06:31:13',10,0),('1','65',257868,'AFTERNOON','2022-05-11','2022-05-16 10:00:24','2022-05-17 10:00:24','548',0.00,0.00,'548','2022-05-16 10:00:43','535','2022-05-16 12:47:34',10,0),('1','65',257869,'MORNING','2022-05-12','2022-05-16 13:26:52','2022-05-17 13:26:52','548',0.00,0.00,'548','2022-05-16 13:27:16','535','2022-05-16 14:24:05',10,0),('1','65',257870,'AFTERNOON','2022-05-12','2022-05-16 17:27:19','2022-05-17 17:27:19','548',0.00,0.00,'548','2022-05-16 17:27:43','535','2022-05-17 00:20:15',10,0),('1','65',257871,'MORNING','2022-05-13','2022-05-17 05:15:51','2022-05-18 05:15:51','548',0.00,0.00,'548','2022-05-17 05:16:11','535','2022-05-17 09:03:02',10,0),('1','65',257872,'AFTERNOON','2022-05-13','2022-05-17 10:28:22','2022-05-18 10:28:22','548',0.00,0.00,'548','2022-05-17 10:28:58','535','2022-05-17 14:57:27',10,0),('1','65',257873,'MORNING','2022-05-14','2022-05-17 17:43:27','2022-05-18 17:43:27','548',0.00,0.00,'548','2022-05-17 17:44:11','535','2022-05-17 22:01:56',10,0),('1','65',257874,'AFTERNOON','2022-05-14','2022-05-18 18:12:53','2022-05-19 18:12:53','548',0.00,0.00,'548','2022-05-18 18:14:00','535','2022-05-19 04:07:26',10,0),('1','65',257875,'MORNING','2022-05-15','2022-05-19 05:13:45','2022-05-20 05:13:45','548',0.00,0.00,'548','2022-05-19 05:14:17','535','2022-05-19 11:27:08',10,0),('1','65',257876,'AFTERNOON','2022-05-15','2022-05-19 12:21:21','2022-05-20 12:21:21','548',0.00,0.00,'548','2022-05-19 12:27:33','535','2022-05-19 14:44:54',10,0),('1','65',257877,'MORNING','2022-05-16','2022-05-19 20:29:54','2022-05-20 20:29:54','548',0.00,0.00,'548','2022-05-19 20:30:13','535','2022-05-20 11:50:08',10,0),('1','65',257878,'AFTERNOON','2022-05-16','2022-05-20 13:20:06','2022-05-21 13:20:06','548',0.00,0.00,'548','2022-05-20 13:20:36','535','2022-05-20 15:49:05',10,0),('1','65',257879,'MORNING','2022-05-16','2022-05-22 18:20:07','2022-05-23 18:20:07','548',0.00,0.00,'548','2022-05-22 18:20:30','535','2022-05-22 21:53:37',10,0),('1','65',257880,'AFTERNOON','2022-05-17','2022-05-24 14:57:31','2022-05-25 14:57:31','548',0.00,0.00,'548','2022-05-24 14:57:55','535','2022-05-24 18:50:52',10,0),('1','65',257881,'MORNING','2022-05-18','2022-05-24 21:38:59','2022-05-25 21:38:59','548',0.00,0.00,'548','2022-05-24 21:39:30','535','2022-05-25 08:48:10',10,0),('1','65',257882,'AFTERNOON','2022-05-18','2022-05-25 09:22:11','2022-05-26 09:22:11','548',0.00,0.00,'548','2022-05-25 09:22:34','535','2022-05-25 12:22:11',10,0),('1','65',257883,'MORNING','2022-05-19','2022-05-25 15:16:49','2022-05-26 15:16:49','548',0.00,0.00,'548','2022-05-25 15:17:12','535','2022-05-25 18:47:49',10,0),('1','65',257884,'AFTERNOON','2022-05-19','2022-05-25 21:06:42','2022-05-26 21:06:42','548',0.00,0.00,'548','2022-05-25 21:07:05','535','2022-05-25 22:55:44',10,0),('1','65',257885,'MORNING','2022-05-20','2022-05-26 05:28:18','2022-05-27 05:28:18','548',0.00,0.00,'548','2022-05-26 05:28:45','535','2022-05-26 10:38:16',10,0),('1','65',257886,'AFTERNOON','2022-05-20','2022-05-26 15:07:10','2022-05-27 15:07:10','548',0.00,0.00,'548','2022-05-26 15:07:54','535','2022-05-26 19:16:24',10,0),('1','65',257887,'MORNING','2022-05-21','2022-05-26 20:33:44','2022-05-27 20:33:44','548',0.00,0.00,'548','2022-05-26 20:34:20','535','2022-05-27 14:38:19',10,0),('1','65',257888,'AFTERNOON','2022-05-21','2022-05-27 17:10:38','2022-05-28 17:10:38','548',0.00,0.00,'548','2022-05-27 17:11:11','535','2022-05-27 20:39:09',10,0),('1','65',257889,'MORNING','2022-05-22','2022-05-27 21:00:37','2022-05-28 21:00:37','548',0.00,0.00,'548','2022-05-27 21:01:10','535','2022-05-28 00:42:50',10,0),('1','65',257890,'AFTERNOON','2022-05-22','2022-05-28 21:52:38','2022-05-29 21:52:38','548',0.00,0.00,'548','2022-05-28 21:53:03','535','2022-05-29 12:29:16',10,0),('1','65',257891,'MORNING','2022-05-23','2022-05-29 14:37:43','2022-05-30 14:37:43','548',0.00,0.00,'548','2022-05-29 14:38:08','535','2022-05-29 16:59:31',10,0),('1','65',257892,'AFTERNOON','2022-05-23','2022-05-29 20:37:24','2022-05-30 20:37:24','548',0.00,0.00,'548','2022-05-29 20:37:49','535','2022-05-30 11:19:23',10,0),('1','65',257893,'MORNING','2022-05-24','2022-05-30 12:30:54','2022-05-31 12:30:54','548',0.00,0.00,'548','2022-05-30 12:31:20','535','2022-05-30 15:06:56',10,0),('1','65',257894,'AFTERNOON','2022-05-24','2022-05-30 20:28:08','2022-05-31 20:28:08','548',0.00,0.00,'548','2022-05-30 20:28:39','535','2022-05-31 07:03:08',10,0),('1','65',257895,'MORNING','2022-05-25','2022-06-01 17:25:18','2022-06-02 17:25:18','548',0.00,0.00,'548','2022-06-01 17:25:47','535','2022-06-02 01:32:15',10,0),('1','65',257896,'AFTERNOON','2022-05-25','2022-06-02 05:06:33','2022-06-03 05:06:33','548',0.00,0.00,'548','2022-06-02 05:06:58','535','2022-06-02 14:15:21',10,0),('1','65',257897,'MORNING','2022-05-26','2022-06-02 20:54:53','2022-06-03 20:54:53','548',0.00,0.00,'548','2022-06-02 20:56:01','535','2022-06-02 22:46:39',10,0),('1','65',257898,'AFTERNOON','2022-05-26','2022-06-03 09:44:25','2022-06-04 09:44:25','548',0.00,0.00,'548','2022-06-03 09:45:26','535','2022-06-03 11:07:26',10,0),('1','65',257899,'MORNING','2022-05-27','2022-06-03 19:17:11','2022-06-04 19:17:11','548',0.00,0.00,'548','2022-06-03 19:17:52','535','2022-06-04 09:48:53',10,0),('1','65',257900,'AFTERNOON','2022-05-27','2022-06-05 10:35:39','2022-06-06 10:35:39','548',0.00,0.00,'548','2022-06-05 10:35:57','535','2022-06-05 14:11:53',10,0),('1','65',257901,'MORNING','2022-05-28','2022-06-05 15:56:51','2022-06-06 15:56:51','548',0.00,0.00,'548','2022-06-05 15:57:13','535','2022-06-05 21:09:29',10,0),('1','65',257902,'AFTERNOON','2022-05-28','2022-06-06 02:31:21','2022-06-07 02:31:21','548',0.00,0.00,'548','2022-06-06 02:31:52','535','2022-06-06 11:54:40',10,0),('1','65',257903,'MORNING','2022-05-29','2022-06-06 15:20:46','2022-06-07 15:20:46','548',0.00,0.00,'548','2022-06-06 15:21:11','535','2022-06-06 16:30:25',10,0),('1','65',257904,'AFTERNOON','2022-05-29','2022-06-06 16:32:52','2022-06-07 16:32:52','548',0.00,0.00,'548','2022-06-06 16:33:21','535','2022-06-07 11:20:46',10,0),('1','65',257905,'MORNING','2022-05-30','2022-06-07 21:09:22','2022-06-08 21:09:22','548',0.00,0.00,'548','2022-06-07 21:09:41','535','2022-06-08 11:14:00',10,0),('1','65',257906,'AFTERNOON','2022-05-30','2022-06-08 11:43:20','2022-06-09 11:43:20','548',0.00,0.00,'548','2022-06-08 11:43:40','535','2022-06-08 16:07:06',10,0),('1','65',257907,'MORNING','2022-09-01','2022-09-01 14:31:53','2022-09-02 14:31:53','548',41160.00,41160.00,'548','2022-09-01 14:33:54','535','2022-09-01 18:01:27',10,0),('1','65',257908,'AFTERNOON','2022-09-01','2022-09-02 09:12:46','2022-09-03 09:12:46','548',39400.00,39400.00,'548','2022-09-02 09:15:35','535','2022-09-03 06:30:57',10,0),('1','65',257909,'MORNING','2022-09-02','2022-09-03 07:06:57','2022-09-04 07:06:57','548',285960.00,285960.00,'548','2022-09-03 07:09:38','535','2022-09-03 07:38:35',10,0),('1','65',257910,'AFTERNOON','2022-09-02','2022-09-03 07:54:47','2022-09-04 07:54:47','548',222728.00,222728.00,'548','2022-09-03 07:57:21','535','2022-09-03 09:08:33',10,0),('1','65',257911,'MORNING','2022-09-03','2022-09-03 17:37:08','2022-09-04 17:37:08','548',775848.00,775848.00,'548','2022-09-03 17:43:42','535','2022-09-03 18:16:58',10,0),('1','65',257912,'AFTERNOON','2022-09-03','2022-09-04 11:38:13','2022-09-05 11:38:13','548',1133856.00,1133856.00,'548','2022-09-04 11:40:10','535','2022-09-04 12:03:57',10,0),('1','65',257913,'MORNING','2022-09-04','2022-09-04 15:01:34','2022-09-05 15:01:34','548',617177.90,617177.90,'548','2022-09-04 15:12:59','535','2022-09-04 19:37:00',10,0),('1','65',257914,'AFTERNOON','2022-09-04','2022-09-05 06:25:12','2022-09-06 06:25:12','548',303874.60,303874.60,'548','2022-09-05 06:49:27','535','2022-09-05 09:10:02',10,0),('1','65',257915,'MORNING','2022-09-05','2022-09-05 14:20:32','2022-09-06 14:20:32','548',555144.20,555144.20,'548','2022-09-05 14:31:40','535','2022-09-05 18:55:20',10,0),('1','65',257916,'AFTERNOON','2022-09-05','2022-09-06 07:35:50','2022-09-07 07:35:50','548',222847.70,222847.70,'548','2022-09-06 08:02:58','535','2022-09-06 10:18:44',10,0),('1','65',257917,'MORNING','2022-09-06','2022-09-06 16:24:03','2022-09-07 16:24:03','548',1462315.60,1462315.60,'548','2022-09-06 16:30:29','535','2022-09-06 21:22:49',10,0),('1','65',257918,'AFTERNOON','2022-09-06','2022-09-07 07:16:45','2022-09-08 07:16:45','548',596281.40,596281.40,'548','2022-09-07 07:21:13','535','2022-09-07 11:41:07',10,0),('1','65',257919,'MORNING','2022-09-07','2022-09-07 15:13:13','2022-09-08 15:13:13','548',874631.60,874631.60,'548','2022-09-07 15:16:51','535','2022-09-07 18:14:16',10,0),('1','65',257920,'AFTERNOON','2022-09-07','2022-09-08 08:26:13','2022-09-09 08:26:13','548',705052.60,705052.60,'548','2022-09-08 08:33:28','535','2022-09-08 11:01:38',10,0),('1','65',257921,'MORNING','2022-09-08','2022-09-08 16:18:36','2022-09-09 16:18:36','548',820593.40,820593.40,'548','2022-09-08 16:35:07','535','2022-09-08 18:32:17',10,0),('1','65',257922,'AFTERNOON','2022-09-08','2022-09-09 09:10:57','2022-09-10 09:10:57','548',550024.30,550024.30,'548','2022-09-09 09:23:26','535','2022-09-09 09:46:32',10,0),('1','65',257923,'MORNING','2022-09-09','2022-09-09 14:06:05','2022-09-10 14:06:05','548',484000.00,484000.00,'548','2022-09-09 14:23:50','535','2022-09-09 15:58:33',10,0),('1','65',257924,'AFTERNOON','2022-09-09','2022-09-10 10:46:04','2022-09-11 10:46:04','548',321200.00,321200.00,'548','2022-09-10 10:54:20','535','2022-09-10 13:05:27',10,0),('1','65',257925,'MORNING','2022-09-10','2022-09-10 13:47:14','2022-09-11 13:47:14','548',75000.00,75000.00,'548','2022-09-10 13:49:23','535','2022-09-10 17:11:20',10,0),('1','65',257926,'AFTERNOON','2022-09-10','2022-09-11 09:25:47','2022-09-12 09:25:47','548',365176.00,365176.00,'548','2022-09-11 09:30:43','535','2022-09-11 12:02:08',10,0),('1','65',257927,'MORNING','2022-09-11','2022-09-11 13:58:26','2022-09-12 13:58:26','548',365208.00,365208.00,'548','2022-09-11 13:59:32','535','2022-09-11 14:40:13',10,0),('1','65',257928,'AFTERNOON','2022-09-11','2022-09-12 12:13:11','2022-09-13 12:13:11','548',24096.00,24096.00,'548','2022-09-12 12:17:24','535','2022-09-12 13:08:43',10,0),('1','65',257929,'MORNING','2022-09-12','2022-09-12 13:51:12','2022-09-13 13:51:12','548',1276824.00,1276824.00,'548','2022-09-12 13:56:06','535','2022-09-12 15:15:29',10,0),('1','65',257930,'AFTERNOON','2022-09-12','2022-09-13 10:06:20','2022-09-14 10:06:20','548',279000.00,279000.00,'548','2022-09-13 10:11:35','535','2022-09-13 11:45:21',10,0),('1','65',257931,'MORNING','2022-09-13','2022-09-13 14:42:12','2022-09-14 14:42:12','548',320000.00,320000.00,'548','2022-09-13 14:44:04','535','2022-09-13 15:51:50',10,0),('1','65',257932,'AFTERNOON','2022-09-13','2022-09-14 09:15:00','2022-09-15 09:15:00','548',1119105.30,1119105.30,'548','2022-09-14 09:22:22','535','2022-09-14 09:29:17',10,0),('1','65',257933,'MORNING','2022-09-14','2022-09-14 15:51:48','2022-09-15 15:51:48','548',308425.50,308425.50,'548','2022-09-14 15:53:18','535','2022-09-14 16:52:59',10,0),('1','65',257934,'AFTERNOON','2022-09-14','2022-09-15 07:57:48','2022-09-16 07:57:48','548',492322.30,492322.30,'548','2022-09-15 08:22:24','535','2022-09-15 09:31:27',10,0),('1','65',257935,'MORNING','2022-09-15','2022-09-15 15:58:30','2022-09-16 15:58:30','548',315317.60,315317.60,'548','2022-09-15 16:00:03','535','2022-09-15 16:04:13',10,0),('1','65',257936,'AFTERNOON','2022-09-15','2022-09-16 08:46:07','2022-09-17 08:46:07','548',410376.80,410376.80,'548','2022-09-16 08:52:25','535','2022-09-16 10:17:21',10,0),('1','65',257937,'MORNING','2022-09-16','2022-09-16 14:11:00','2022-09-17 14:11:00','548',564369.00,564369.00,'548','2022-09-16 15:01:38','535','2022-09-16 16:24:47',10,0),('1','65',257938,'AFTERNOON','2022-09-16','2022-09-17 10:00:11','2022-09-18 10:00:11','548',233211.50,233211.50,'548','2022-09-17 10:15:02','535','2022-09-17 11:36:50',10,0),('1','65',257939,'MORNING','2022-09-17','2022-09-17 14:37:30','2022-09-18 14:37:30','548',317783.80,317783.80,'548','2022-09-17 14:45:17','535','2022-09-17 17:22:58',10,0),('1','65',257940,'AFTERNOON','2022-09-17','2022-09-18 08:32:14','2022-09-19 08:32:14','548',254941.10,254941.10,'548','2022-09-18 08:44:07','535','2022-09-18 10:43:04',10,0),('1','65',257941,'MORNING','2022-09-18','2022-09-18 17:44:42','2022-09-19 17:44:42','548',670476.60,670476.60,'548','2022-09-18 17:48:22','535','2022-09-18 17:52:40',10,0),('1','65',257942,'AFTERNOON','2022-09-18','2022-09-19 10:11:42','2022-09-20 10:11:42','548',311646.00,311646.00,'548','2022-09-19 10:20:02','535','2022-09-19 10:31:35',10,0),('1','65',257943,'MORNING','2022-09-19','2022-09-19 14:27:07','2022-09-20 14:27:07','548',415077.80,415077.80,'548','2022-09-19 14:30:13','535','2022-09-19 16:24:34',10,0),('1','65',257944,'AFTERNOON','2022-09-19','2022-09-20 09:36:30','2022-09-21 09:36:30','548',196954.00,196954.00,'548','2022-09-20 09:44:49','535','2022-09-20 10:14:20',10,0),('1','65',257945,'MORNING','2022-09-20','2022-09-20 14:49:37','2022-09-21 14:49:37','548',356764.90,356764.90,'548','2022-09-20 14:53:12','535','2022-09-20 15:54:58',10,0),('1','65',257946,'AFTERNOON','2022-09-20','2022-09-21 10:23:23','2022-09-22 10:23:23','548',358590.80,358590.80,'548','2022-09-21 10:29:48','535','2022-09-21 12:10:58',10,0),('1','65',257947,'MORNING','2022-09-21','2022-09-21 14:32:09','2022-09-22 14:32:09','548',476333.80,476333.80,'548','2022-09-21 14:33:30','535','2022-09-21 16:53:43',10,0),('1','65',257948,'AFTERNOON','2022-09-21','2022-09-22 09:56:15','2022-09-23 09:56:15','548',274893.90,274893.90,'548','2022-09-22 10:04:10','535','2022-09-22 10:08:56',10,0),('1','65',257949,'MORNING','2022-09-22','2022-09-22 14:07:00','2022-09-23 14:07:00','548',423536.60,423536.60,'548','2022-09-22 14:08:20','535','2022-09-22 15:20:03',10,0),('1','65',257950,'AFTERNOON','2022-09-22','2022-09-23 09:53:27','2022-09-24 09:53:27','548',139376.40,139376.40,'548','2022-09-23 10:05:51','535','2022-09-23 12:08:33',10,0),('1','65',257951,'MORNING','2022-09-23','2022-09-23 14:32:18','2022-09-24 14:32:18','548',754428.30,754428.30,'548','2022-09-23 14:34:07','535','2022-09-23 15:38:35',10,0),('1','65',257952,'AFTERNOON','2022-09-23','2022-09-24 10:53:00','2022-09-25 10:53:00','548',190729.60,190729.60,'548','2022-09-24 10:57:38','535','2022-09-24 11:01:41',10,0),('1','65',257953,'MORNING','2022-09-24','2022-09-24 14:14:17','2022-09-25 14:14:17','548',224030.90,224030.90,'548','2022-09-24 14:15:37','535','2022-09-24 16:31:14',10,0),('1','65',257954,'AFTERNOON','2022-09-24','2022-09-25 11:04:47','2022-09-26 11:04:47','548',190809.40,190809.40,'548','2022-09-25 11:14:01','535','2022-09-25 11:34:24',10,0),('1','65',257955,'MORNING','2022-09-25','2022-09-25 14:26:32','2022-09-26 14:26:32','548',391533.00,391533.00,'548','2022-09-25 14:29:10','535','2022-09-25 15:08:42',10,0),('1','65',257956,'AFTERNOON','2022-09-25','2022-09-26 09:55:15','2022-09-27 09:55:15','548',190913.90,190913.90,'548','2022-09-26 10:06:00','535','2022-09-26 11:10:45',10,0),('1','65',257957,'MORNING','2022-10-01','2022-10-01 13:04:03','2022-10-02 13:04:03','548',200000.00,200000.00,'548','2022-10-01 13:05:19','535','2022-10-01 21:21:44',10,0),('1','65',257958,'MORNING','2023-01-04','2023-01-04 14:05:03','2023-01-05 14:05:03','548',134087.40,134087.40,'548','2023-01-04 14:19:43','535','2023-01-04 15:05:32',10,0),('1','65',257959,'MORNING/AFTERNOON','2023-01-05','2023-01-06 07:47:23','2023-01-07 07:47:23','548',70083.00,70083.00,'548','2023-01-06 08:58:54','535','2023-01-06 09:53:29',10,0),('1','65',257960,'MORNING/AFTERNOON','2023-01-06','2023-01-06 22:15:48','2023-01-07 22:15:48','548',423333.00,423333.00,'548','2023-01-06 22:17:53','535','2023-01-07 11:49:08',10,0),('1','65',257961,'MORNING/AFTERNOON','2023-01-07','2023-01-07 22:26:14','2023-01-08 22:26:14','548',392814.00,392814.00,'548','2023-01-07 22:27:56','535','2023-01-08 07:42:35',10,0),('1','65',257962,'MORNING/AFTERNOON','2023-01-08','2023-01-08 21:54:43','2023-01-09 21:54:43','548',353520.00,353520.00,'548','2023-01-08 21:56:30','535','2023-01-09 08:29:25',10,0),('1','65',257963,'MORNING/AFTERNOON','2023-01-09','2023-01-09 21:48:06','2023-01-10 21:48:06','548',999810.00,999810.00,'548','2023-01-09 21:50:48','535','2023-01-09 23:17:00',10,0),('1','65',257964,'MORNING/AFTERNOON','2023-01-10','2023-01-11 08:44:23','2023-01-12 08:44:23','548',422361.00,422361.00,'548','2023-01-11 08:45:10','535','2023-01-11 09:32:27',10,0),('1','65',257965,'MORNING/AFTERNOON','2023-01-11','2023-01-11 19:45:40','2023-01-12 19:45:40','548',304983.00,304983.00,'548','2023-01-11 19:46:36','535','2023-01-11 22:02:56',10,0),('1','65',257966,'MORNING/AFTERNOON','2023-01-12','2023-01-12 19:36:43','2023-01-13 19:36:43','548',180000.00,180000.00,'548','2023-01-12 19:37:40','535','2023-01-12 23:43:41',10,0),('1','65',257967,'MORNING/AFTERNOON','2023-01-13','2023-01-14 11:50:58','2023-01-15 11:50:58','548',1035297.00,1035297.00,'548','2023-01-14 11:57:33','535','2023-01-14 12:18:13',10,0),('1','65',257968,'MORNING/AFTERNOON','2023-01-14','2023-01-15 10:59:08','2023-01-16 10:59:08','548',848889.00,848889.00,'548','2023-01-15 11:00:38','535','2023-01-15 11:13:13',10,0),('1','65',257969,'MORNING/AFTERNOON','2023-01-15','2023-01-15 19:51:57','2023-01-16 19:51:57','548',462339.00,462339.00,'548','2023-01-15 19:52:44','535','2023-01-16 03:05:07',10,0),('1','65',257970,'MORNING/AFTERNOON','2023-01-16','2023-01-16 13:38:34','2023-01-17 13:38:34','548',275904.00,275904.00,'548','2023-01-16 19:56:52','535','2023-01-16 23:20:46',10,0),('1','65',257971,'MORNING/AFTERNOON','2023-01-17','2023-01-17 19:54:21','2023-01-18 19:54:21','548',96255.00,96255.00,'548','2023-01-17 19:55:22','535','2023-01-17 20:44:58',10,0),('1','65',257972,'MORNING/AFTERNOON','2023-01-18','2023-01-18 19:04:12','2023-01-19 19:04:12','548',528792.00,528792.00,'548','2023-01-19 07:23:48','535','2023-01-19 15:04:58',10,0),('1','65',257973,'MORNING/AFTERNOON','2023-01-19','2023-01-20 06:28:28','2023-01-21 06:28:28','548',2226364.80,2226364.80,'548','2023-01-20 06:30:25','535','2023-01-20 11:53:03',10,0),('1','65',257974,'MORNING/AFTERNOON','2023-01-20','2023-01-21 08:07:45','2023-01-22 08:07:45','548',1870237.60,1870237.60,'548','2023-01-21 08:10:09','535','2023-01-21 13:00:57',10,0),('1','65',257975,'MORNING/AFTERNOON','2023-01-21','2023-01-22 10:46:01','2023-01-23 10:46:01','548',1956248.80,1956248.80,'548','2023-01-22 10:46:59','535','2023-01-22 11:52:23',10,0),('1','65',257976,'MORNING/AFTERNOON','2023-01-22','2023-01-22 19:48:37','2023-01-23 19:48:37','548',595997.60,595997.60,'548','2023-01-22 19:49:39','535','2023-01-22 21:37:15',10,0),('1','65',257977,'MORNING/AFTERNOON\'','2023-01-23','2023-01-24 08:04:42','2023-01-25 08:04:42','548',1364000.00,1364000.00,'548','2023-01-24 08:06:04','535','2023-01-24 12:51:12',10,0),('1','65',257978,'MORNING/AFTERNOON','2023-01-24','2023-01-25 07:36:32','2023-01-26 07:36:32','548',441460.80,441460.80,'548','2023-01-25 07:38:16','535','2023-01-25 12:55:12',10,0),('1','65',257979,'MORNING/AFTERNOON','2023-01-25','2023-01-26 09:37:41','2023-01-27 09:37:41','548',938256.00,938256.00,'548','2023-01-26 09:38:44','535','2023-01-26 12:25:07',10,0),('1','65',257980,'MORNING/AFTERNOON','2023-01-26','2023-01-26 21:34:57','2023-01-27 21:34:57','548',669996.80,669996.80,'548','2023-01-26 21:38:26','535','2023-01-27 11:08:13',10,0),('1','65',257981,'MORNING/AFTERNOON','2023-01-27','2023-01-27 20:04:41','2023-01-28 20:04:41','548',1400845.60,1400845.60,'548','2023-01-27 20:07:03','535','2023-01-27 22:58:36',10,0),('1','65',257982,'MORNING/AFTERNOON','2023-01-28','2023-01-29 10:49:15','2023-01-30 10:49:15','548',699732.00,699732.00,'548','2023-01-29 10:50:11','535','2023-01-29 12:48:15',10,0),('1','65',257983,'MORNING/AFTERNOON','2023-01-29','2023-01-29 19:59:41','2023-01-30 19:59:41','548',206236.80,206236.80,'548','2023-01-29 20:00:48','535','2023-01-29 22:12:25',10,0),('1','65',257984,'MORNING/AFTERNOON','2023-01-30','2023-01-31 08:34:31','2023-02-01 08:34:31','548',298874.40,298874.40,'548','2023-01-31 08:36:11','535','2023-01-31 12:18:21',10,0),('1','65',257985,'MORNING/AFTERNOON','2023-01-31','2023-01-31 19:56:08','2023-02-01 19:56:08','548',366360.00,366360.00,'548','2023-01-31 19:56:48','535','2023-02-01 01:40:10',10,0),('1','65',257986,'MORNING/AFTERNOON','2023-02-01','2023-02-01 20:10:46','2023-02-02 20:10:46','548',989000.00,989000.00,'548','2023-02-01 20:11:57','535','2023-02-02 00:48:26',10,0),('1','65',257987,'MORNING/AFTERNOON','2023-02-02','2023-02-03 09:02:04','2023-02-04 09:02:04','548',295289.60,295289.60,'548','2023-02-03 09:10:32','535','2023-02-03 12:16:04',10,0),('1','65',257988,'MORNING/AFTERNOON','2023-02-03','2023-02-03 19:57:36','2023-02-04 19:57:36','548',2897486.20,2897486.20,'548','2023-02-03 19:58:39','535','2023-02-03 22:57:54',10,0),('1','65',257989,'MORNING/AFTERNOON','2023-02-04','2023-02-05 13:06:26','2023-02-06 13:06:26','548',603737.20,603737.20,'548','2023-02-05 13:07:28','535','2023-02-05 21:54:52',10,0),('1','65',257990,'MORNING/AFTERNOON','2023-02-05','2023-02-06 08:27:37','2023-02-07 08:27:37','548',178020.00,178020.00,'548','2023-02-06 08:29:23','535','2023-02-06 14:21:56',10,0),('1','65',257991,'MORNING/AFTERNOON','2023-02-06','2023-02-06 19:59:40','2023-02-07 19:59:40','548',172610.60,172610.60,'548','2023-02-06 20:00:30','535','2023-02-06 22:17:28',10,0),('1','65',257992,'MORNING/AFTERNOON','2023-02-07','2023-02-08 07:14:20','2023-02-09 07:14:20','548',395600.00,395600.00,'548','2023-02-08 07:15:45','535','2023-02-08 10:34:06',10,0),('1','65',257993,'MORNING/AFTERNOON','2023-02-08','2023-02-08 19:56:55','2023-02-09 19:56:55','548',868600.00,868600.00,'548','2023-02-08 19:58:48','535','2023-02-09 08:27:54',10,0),('1','65',257994,'MORNING/AFTERNOON','2023-02-09','2023-02-10 07:09:11','2023-02-11 07:09:11','548',817000.00,817000.00,'548','2023-02-10 07:10:08','535','2023-02-10 16:28:33',10,0),('1','65',257995,'MORNING/AFTERNOON','2023-02-10','2023-02-10 19:21:48','2023-02-11 19:21:48','548',720998.20,720998.20,'548','2023-02-10 19:22:30','535','2023-02-11 00:47:07',10,0),('1','65',257996,'MORNING/AFTERNOON','2023-02-11','2023-02-11 19:00:54','2023-02-12 19:00:54','548',1032000.00,1032000.00,'548','2023-02-11 19:02:22','535','2023-02-11 22:48:51',10,0),('1','65',257997,'MORNING/AFTERNOON','2023-02-12','2023-02-12 21:53:03','2023-02-13 21:53:03','548',516000.00,516000.00,'548','2023-02-12 21:54:22','535','2023-02-12 23:32:03',10,0),('1','65',257998,'MORNING/AFTERNOON','2023-02-13','2023-02-13 20:10:43','2023-02-14 20:10:43','548',180600.00,180600.00,'548','2023-02-13 20:11:42','535','2023-02-14 05:49:41',10,0),('1','65',257999,'MORNING/AFTERNOON','2023-02-14','2023-02-14 21:33:29','2023-02-15 21:33:29','548',215516.00,215516.00,'548','2023-02-14 21:36:16','535','2023-02-15 06:24:27',10,0),('1','65',258000,'MORNING/AFTERNOON','2023-02-15','2023-02-15 19:55:47','2023-02-16 19:55:47','548',387455.80,387455.80,'548','2023-02-15 20:02:59','535','2023-02-16 01:18:52',10,0),('1','65',258001,'MORNING/AFTERNOON','2023-02-16','2023-02-16 18:54:27','2023-02-17 18:54:27','548',752930.00,752930.00,'548','2023-02-16 18:57:00','535','2023-02-17 04:56:43',10,0),('1','65',258002,'MORNING/AFTERNOON','2023-02-17','2023-02-18 11:25:13','2023-02-19 11:25:13','548',40712.40,40712.40,'548','2023-02-18 11:26:08','535','2023-02-18 12:46:40',10,0),('1','65',258003,'MORNING/AFTERNOON','2023-02-18','2023-02-19 06:23:09','2023-02-20 06:23:09','548',59099.20,59099.20,'548','2023-02-19 06:25:10','535','2023-02-19 07:42:55',10,0),('1','65',258004,'MORNING/AFTERNOON','2023-02-19','2023-02-19 20:21:36','2023-02-20 20:21:36','548',86000.00,86000.00,'548','2023-02-19 20:22:42','535','2023-02-20 06:08:41',10,0),('1','65',258005,'MORNING/AFTERNOON','2023-02-20','2023-02-20 21:38:03','2023-02-21 21:38:03','548',170993.80,170993.80,'548','2023-02-20 21:39:11','535','2023-02-21 01:34:17',10,0),('1','65',258006,'MORNING/AFTERNOON','2023-02-21','2023-02-21 19:05:02','2023-02-22 19:05:02','548',187850.00,187850.00,'548','2023-02-21 20:01:58','535','2023-02-22 07:05:22',10,0),('1','65',258007,'MORNING/AFTERNOON','2023-02-22','2023-02-22 19:59:30','2023-02-23 19:59:30','548',233996.50,233996.50,'548','2023-02-22 20:00:20','535','2023-02-22 23:23:05',10,0),('1','65',258008,'MORNING/AFTERNOON','2023-02-23','2023-02-23 20:15:09','2023-02-24 20:15:09','548',215000.00,212500.00,'548','2023-02-23 20:16:13','535','2023-02-23 23:08:03',10,0),('1','65',258009,'MORNING/AFTERNOON','2023-02-24','2023-02-24 22:00:17','2023-02-25 22:00:17','548',0.00,0.00,'548','2023-02-24 22:39:32','535','2023-02-24 22:42:16',10,0),('1','65',258010,'MORNING/AFTERNOON','2023-02-24','2023-02-25 07:21:42','2023-02-26 07:21:42','548',1494315.40,1494315.40,'548','2023-02-25 07:23:13','535','2023-02-25 09:19:54',10,0),('1','65',258011,'MORNING/AFTERNOON','2023-02-26','2023-02-26 21:56:15','2023-02-27 21:56:15','548',498000.00,498000.00,'548','2023-02-26 21:57:25','535','2023-02-27 00:46:29',10,0),('1','65',258012,'MORNING/AFTERNOON','2023-02-27','2023-02-28 07:32:35','2023-03-01 07:32:35','548',913000.00,913000.00,'548','2023-02-28 07:33:55','535','2023-02-28 08:38:50',10,0),('1','65',258013,'MORNING/AFTERNOON','2023-02-28','2023-02-28 21:57:10','2023-03-01 21:57:10','548',2793049.60,2793049.60,'548','2023-02-28 21:59:15','535','2023-03-01 00:53:35',10,0),('1','65',258014,'MORNING/AFTERNOON','2023-03-01','2023-03-01 21:14:25','2023-03-02 21:14:25','548',1435468.40,1435468.40,'548','2023-03-01 21:16:23','535','2023-03-02 13:15:49',10,0),('1','65',258015,'MORNING/AFTERNOON','2023-03-02','2023-03-02 20:07:08','2023-03-03 20:07:08','548',2961249.10,2961249.10,'548','2023-03-02 20:08:19','535','2023-03-03 00:52:29',10,0),('1','65',258016,'MORNING/AFTERNOON','2023-03-03','2023-03-04 11:34:53','2023-03-05 11:34:53','548',1390250.00,1390250.00,'548','2023-03-04 11:37:22','535','2023-03-04 12:59:37',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4912464 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','65','420','157535',3129395,'1122','161',801340.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','157535',3129396,'1123','161',396095.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','157535',3129397,'1124','161',122592.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','157535',3129398,'1125','161',238817.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','157535',3129399,'1126','161',508915.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','157535',3129400,'1127','161',383069.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','157535',3129401,'1128','161',78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','157535',3129402,'1129','161',207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','157535',3129403,'1130','161',721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','157535',3129404,'1131','161',111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','157535',3129405,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','157535',3129406,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','157535',3129407,'1134','162',11671.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','157535',3129408,'1135','162',508206.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','157535',3129409,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','157535',3129410,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170280',3357393,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170280',3357394,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170280',3357395,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170280',3357396,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170280',3357397,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170280',3357398,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170280',3357399,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170280',3357400,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170280',3357401,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170280',3357402,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170280',3357403,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170280',3357404,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','170280',3357405,'1134','162',9982081.94,9983111.69,1029.75,216247.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','170280',3357406,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','170280',3357407,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','170280',3357408,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170865',3367531,'1122','161',801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170865',3367532,'1123','161',427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170865',3367533,'1124','161',139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170865',3367534,'1125','161',243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170865',3367535,'1126','161',563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','170865',3367536,'1127','161',403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170865',3367537,'1128','161',78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170865',3367538,'1129','161',207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170865',3367539,'1130','161',721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170865',3367540,'1131','161',111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170865',3367541,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','170865',3367542,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','170865',3367543,'1134','162',9983111.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','170865',3367544,'1135','162',508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','170865',3367545,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','170865',3367546,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171410',3377631,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171410',3377632,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171410',3377633,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171410',3377634,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171410',3377635,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171410',3377636,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171410',3377637,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171410',3377638,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171410',3377639,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171410',3377640,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171410',3377641,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171410',3377642,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','171410',3377643,'1134','162',9983111.69,9984440.74,1329.05,279100.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','171410',3377644,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','171410',3377645,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','171410',3377646,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171468',3378640,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171468',3378641,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171468',3378642,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171468',3378643,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171468',3378644,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171468',3378645,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171468',3378646,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171468',3378647,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171468',3378648,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171468',3378649,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171468',3378650,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171468',3378651,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','171468',3378652,'1134','162',9984440.74,9984782.18,341.44,71702.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','171468',3378653,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','171468',3378654,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','171468',3378655,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171479',3378886,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171479',3378887,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171479',3378888,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171479',3378889,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171479',3378890,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','171479',3378891,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171479',3378892,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171479',3378893,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171479',3378894,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171479',3378895,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171479',3378896,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','171479',3378897,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','171479',3378898,'1134','162',9984782.18,9985581.56,799.38,167869.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','171479',3378899,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','171479',3378900,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','171479',3378901,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175666',3455223,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175666',3455224,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175666',3455225,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175666',3455226,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175666',3455227,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175666',3455228,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175666',3455229,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175666',3455230,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175666',3455231,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175666',3455232,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175666',3455233,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175666',3455234,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175666',3455235,'1134','162',9985581.56,9986824.90,1243.34,261101.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','175666',3455236,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175666',3455237,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175666',3455238,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175670',3455328,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175670',3455329,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175670',3455330,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175670',3455331,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175670',3455332,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175670',3455333,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175670',3455334,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175670',3455335,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175670',3455336,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175670',3455337,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175670',3455338,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175670',3455339,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175670',3455340,'1134','162',9986824.90,9988267.14,1442.24,302870.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','175670',3455341,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175670',3455342,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175670',3455343,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175672',3455360,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175672',3455361,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175672',3455362,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175672',3455363,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175672',3455364,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175672',3455365,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175672',3455366,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175672',3455367,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175672',3455368,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175672',3455369,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175672',3455370,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175672',3455371,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175672',3455372,'1134','162',9988267.14,9989683.73,1416.59,297483.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','175672',3455373,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175672',3455374,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175672',3455375,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175673',3455376,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175673',3455377,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175673',3455378,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175673',3455379,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175673',3455380,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175673',3455381,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175673',3455382,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175673',3455383,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175673',3455384,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175673',3455385,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175673',3455386,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175673',3455387,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175673',3455388,'1134','162',9989683.73,9990266.33,562.60,118146.00,0.00,0.00,20.00,0.00,0.00),('1','65','423','175673',3455389,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175673',3455390,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175673',3455391,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175824',3458084,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175824',3458085,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175824',3458086,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175824',3458087,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175824',3458088,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175824',3458089,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175824',3458090,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175824',3458091,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175824',3458092,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175824',3458093,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175824',3458094,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175824',3458095,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175824',3458096,'1134','162',9990266.33,9990444.45,178.12,37405.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','175824',3458097,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175824',3458098,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175824',3458099,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175826',3458124,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175826',3458125,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175826',3458126,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175826',3458127,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175826',3458128,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175826',3458129,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175826',3458130,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175826',3458131,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175826',3458132,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175826',3458133,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175826',3458134,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175826',3458135,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175826',3458136,'1134','162',9990444.45,9990785.31,340.86,71580.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','175826',3458137,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175826',3458138,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175826',3458139,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175828',3458156,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175828',3458157,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175828',3458158,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175828',3458159,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175828',3458160,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175828',3458161,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175828',3458162,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175828',3458163,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175828',3458164,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175828',3458165,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175828',3458166,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175828',3458167,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175828',3458168,'1134','162',9990785.31,9991979.93,1184.62,248770.20,0.00,0.00,10.00,0.00,0.00),('1','65','423','175828',3458169,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175828',3458170,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175828',3458171,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175831',3458200,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175831',3458201,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175831',3458202,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175831',3458203,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175831',3458204,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175831',3458205,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175831',3458206,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175831',3458207,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175831',3458208,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175831',3458209,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175831',3458210,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175831',3458211,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175831',3458212,'1134','162',9991979.93,9993181.61,1201.68,252352.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','175831',3458213,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175831',3458214,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175831',3458215,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175834',3458247,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175834',3458248,'1123','161',427041.19,427041.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175834',3458249,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175834',3458250,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175834',3458251,'1126','161',563372.35,563372.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175834',3458252,'1127','161',403761.54,403761.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175834',3458253,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175834',3458254,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175834',3458255,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175834',3458256,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175834',3458257,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175834',3458258,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175834',3458259,'1134','162',9993181.61,9994798.47,1616.86,339540.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','175834',3458260,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175834',3458261,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175834',3458262,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175836',3458304,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175836',3458305,'1123','161',427041.19,428302.14,1240.95,205997.70,0.00,0.00,20.00,0.00,0.00),('1','65','420','175836',3458306,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175836',3458307,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','175836',3458308,'1126','161',563372.35,563613.11,220.76,36646.16,0.00,0.00,20.00,0.00,0.00),('1','65','420','175836',3458309,'1127','161',403761.54,404629.17,857.63,142366.58,0.00,0.00,10.00,0.00,0.00),('1','65','421','175836',3458310,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175836',3458311,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175836',3458312,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175836',3458313,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175836',3458314,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','175836',3458315,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','175836',3458316,'1134','162',9994798.47,9995492.44,683.97,143633.70,0.00,0.00,10.00,0.00,0.00),('1','65','423','175836',3458317,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175836',3458318,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','175836',3458319,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176121',3463542,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176121',3463543,'1123','161',428302.14,429033.18,731.04,121352.64,0.00,0.00,0.00,0.00,0.00),('1','65','420','176121',3463544,'1124','161',139595.21,139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176121',3463545,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176121',3463546,'1126','161',563613.11,563826.33,213.22,35394.52,0.00,0.00,0.00,0.00,0.00),('1','65','420','176121',3463547,'1127','161',404629.17,404629.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176121',3463548,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176121',3463549,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176121',3463550,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176121',3463551,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176121',3463552,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176121',3463553,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176121',3463554,'1134','162',9995492.44,9995914.32,421.88,88594.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','176121',3463555,'1135','162',508730.63,508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176121',3463556,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176121',3463557,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176124',3463613,'1122','161',801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176124',3463614,'1123','161',429033.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176124',3463615,'1124','161',139595.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176124',3463616,'1125','161',243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176124',3463617,'1126','161',563826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176124',3463618,'1127','161',404629.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176124',3463619,'1128','161',78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176124',3463620,'1129','161',207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176124',3463621,'1130','161',721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176124',3463622,'1131','161',111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176124',3463623,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176124',3463624,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176124',3463625,'1134','162',9995914.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176124',3463626,'1135','162',508730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176124',3463627,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176124',3463628,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176354',3467705,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176354',3467706,'1123','161',429033.18,429131.95,98.77,16099.51,0.00,0.00,0.00,0.00,0.00),('1','65','420','176354',3467707,'1124','161',139595.21,140096.14,500.93,81651.59,0.00,0.00,0.00,0.00,0.00),('1','65','420','176354',3467708,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176354',3467709,'1126','161',563826.33,564097.27,270.94,44163.22,0.00,0.00,0.00,0.00,0.00),('1','65','420','176354',3467710,'1127','161',404629.17,404629.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176354',3467711,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176354',3467712,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176354',3467713,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176354',3467714,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176354',3467715,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176354',3467716,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176354',3467717,'1134','162',9995914.32,9997933.15,2018.83,423954.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','176354',3467718,'1135','162',508730.63,508754.44,23.81,5000.10,0.00,0.00,0.00,0.00,0.00),('1','65','424','176354',3467719,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176354',3467720,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176357',3467766,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176357',3467767,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176357',3467768,'1124','161',140096.14,141011.40,915.26,149187.38,0.00,0.00,0.00,0.00,0.00),('1','65','420','176357',3467769,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176357',3467770,'1126','161',564097.27,564103.41,6.14,1000.82,0.00,0.00,0.00,0.00,0.00),('1','65','420','176357',3467771,'1127','161',404629.17,405153.81,524.64,85516.32,0.00,0.00,0.00,0.00,0.00),('1','65','421','176357',3467772,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176357',3467773,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176357',3467774,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176357',3467775,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176357',3467776,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176357',3467777,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176357',3467778,'1134','162',9997933.15,9998261.20,328.05,68890.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','176357',3467779,'1135','162',508754.44,508754.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176357',3467780,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176357',3467781,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176360',3467816,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176360',3467817,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176360',3467818,'1124','161',141011.40,141537.08,525.68,85685.84,0.00,0.00,0.00,0.00,0.00),('1','65','420','176360',3467819,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176360',3467820,'1126','161',564103.41,564504.48,401.07,65374.41,0.00,0.00,0.00,0.00,0.00),('1','65','420','176360',3467821,'1127','161',405153.81,405153.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176360',3467822,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176360',3467823,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176360',3467824,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176360',3467825,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176360',3467826,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176360',3467827,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176360',3467828,'1134','162',9998261.20,9998490.89,229.69,48234.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','176360',3467829,'1135','162',508754.44,508754.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176360',3467830,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176360',3467831,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176361',3467832,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176361',3467833,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176361',3467834,'1124','161',141537.08,142483.20,946.12,154217.56,0.00,0.00,0.00,0.00,0.00),('1','65','420','176361',3467835,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176361',3467836,'1126','161',564504.48,564738.91,234.43,38212.09,0.00,0.00,0.00,0.00,0.00),('1','65','420','176361',3467837,'1127','161',405153.81,405153.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176361',3467838,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176361',3467839,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176361',3467840,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176361',3467841,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176361',3467842,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176361',3467843,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176361',3467844,'1134','162',9998490.89,10001221.06,2730.17,573335.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','176361',3467845,'1135','162',508754.44,508754.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176361',3467846,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176361',3467847,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176364',3467874,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176364',3467875,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176364',3467876,'1124','161',142483.20,143159.48,676.28,110233.64,0.00,0.00,0.00,0.00,0.00),('1','65','420','176364',3467877,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176364',3467878,'1126','161',564738.91,564738.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176364',3467879,'1127','161',405153.81,405412.40,258.59,42150.17,0.00,0.00,0.00,0.00,0.00),('1','65','421','176364',3467880,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176364',3467881,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176364',3467882,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176364',3467883,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176364',3467884,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176364',3467885,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176364',3467886,'1134','162',10001221.06,10002204.49,983.43,206520.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','176364',3467887,'1135','162',508754.44,508754.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176364',3467888,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176364',3467889,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176367',3467917,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176367',3467918,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176367',3467919,'1124','161',143159.48,143794.71,635.23,103542.49,0.00,0.00,0.00,0.00,0.00),('1','65','420','176367',3467920,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176367',3467921,'1126','161',564738.91,565370.06,631.15,102877.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','176367',3467922,'1127','161',405412.40,405412.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176367',3467923,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176367',3467924,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176367',3467925,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176367',3467926,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176367',3467927,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176367',3467928,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176367',3467929,'1134','162',10002204.49,10002472.66,268.17,56315.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','176367',3467930,'1135','162',508754.44,508754.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176367',3467931,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176367',3467932,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176368',3467933,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176368',3467934,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176368',3467935,'1124','161',143794.71,144879.39,1084.68,176802.84,0.00,0.00,0.00,0.00,0.00),('1','65','420','176368',3467936,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176368',3467937,'1126','161',565370.06,565647.98,277.92,45300.96,0.00,0.00,0.00,0.00,0.00),('1','65','420','176368',3467938,'1127','161',405412.40,405412.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176368',3467939,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176368',3467940,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176368',3467941,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176368',3467942,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176368',3467943,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176368',3467944,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176368',3467945,'1134','162',10002472.66,10002957.28,484.62,101770.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','176368',3467946,'1135','162',508754.44,508944.30,189.86,39870.60,0.00,0.00,0.00,0.00,0.00),('1','65','424','176368',3467947,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176368',3467948,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176370',3467966,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176370',3467967,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176370',3467968,'1124','161',144879.39,145898.70,1019.31,166147.53,0.00,0.00,0.00,0.00,0.00),('1','65','420','176370',3467969,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176370',3467970,'1126','161',565647.98,565949.20,301.22,49098.86,0.00,0.00,0.00,0.00,0.00),('1','65','420','176370',3467971,'1127','161',405412.40,405412.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176370',3467972,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176370',3467973,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176370',3467974,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176370',3467975,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176370',3467976,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176370',3467977,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176370',3467978,'1134','162',10002957.28,10003680.75,723.47,151928.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','176370',3467979,'1135','162',508944.30,509631.84,687.54,144383.40,0.00,0.00,0.00,0.00,0.00),('1','65','424','176370',3467980,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176370',3467981,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176371',3467982,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176371',3467983,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176371',3467984,'1124','161',145898.70,146525.59,626.89,102183.07,0.00,0.00,0.00,0.00,0.00),('1','65','420','176371',3467985,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176371',3467986,'1126','161',565949.20,565949.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176371',3467987,'1127','161',405412.40,405412.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176371',3467988,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176371',3467989,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176371',3467990,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176371',3467991,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176371',3467992,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176371',3467993,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176371',3467994,'1134','162',10003680.75,10006549.33,2868.58,602401.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','176371',3467995,'1135','162',509631.84,510272.81,640.97,134603.70,0.00,0.00,0.00,0.00,0.00),('1','65','424','176371',3467996,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176371',3467997,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176373',3468015,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176373',3468016,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176373',3468017,'1124','161',146525.59,147217.83,682.24,111205.12,0.00,0.00,10.00,0.00,0.00),('1','65','420','176373',3468018,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176373',3468019,'1126','161',565949.20,566290.35,321.15,52347.45,0.00,0.00,20.00,0.00,0.00),('1','65','420','176373',3468020,'1127','161',405412.40,405412.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176373',3468021,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176373',3468022,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176373',3468023,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176373',3468024,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176373',3468025,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176373',3468026,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176373',3468027,'1134','162',10006549.33,10008508.36,1949.03,409296.30,0.00,0.00,10.00,0.00,0.00),('1','65','423','176373',3468028,'1135','162',510272.81,510272.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176373',3468029,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176373',3468030,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176376',3468061,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176376',3468062,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176376',3468063,'1124','161',147217.83,147762.49,544.66,88779.58,0.00,0.00,0.00,0.00,0.00),('1','65','420','176376',3468064,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176376',3468065,'1126','161',566290.35,566746.20,455.85,74303.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','176376',3468066,'1127','161',405412.40,405412.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176376',3468067,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176376',3468068,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176376',3468069,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176376',3468070,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176376',3468071,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176376',3468072,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176376',3468073,'1134','162',10008508.36,10009517.26,1008.90,216913.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','176376',3468074,'1135','162',510272.81,510286.76,13.95,2999.25,0.00,0.00,0.00,0.00,0.00),('1','65','424','176376',3468075,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176376',3468076,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176379',3468121,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176379',3468122,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176379',3468123,'1124','161',147762.49,148614.17,851.68,138823.84,0.00,0.00,0.00,0.00,0.00),('1','65','420','176379',3468124,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176379',3468125,'1126','161',566746.20,567418.38,672.18,109565.34,0.00,0.00,0.00,0.00,0.00),('1','65','420','176379',3468126,'1127','161',405412.40,405424.06,11.66,1900.58,0.00,0.00,0.00,0.00,0.00),('1','65','421','176379',3468127,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176379',3468128,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176379',3468129,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176379',3468130,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176379',3468131,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176379',3468132,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176379',3468133,'1134','162',10009517.26,10009846.62,329.36,70812.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','176379',3468134,'1135','162',510286.76,510286.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176379',3468135,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176379',3468136,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176380',3468137,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176380',3468138,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176380',3468139,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176380',3468140,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176380',3468141,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176380',3468142,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176380',3468143,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176380',3468144,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176380',3468145,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176380',3468146,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176380',3468147,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176380',3468148,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176380',3468149,'1134','162',10009846.62,10011196.83,1350.21,290295.15,0.00,0.00,0.00,0.00,0.00),('1','65','423','176380',3468150,'1135','162',510286.76,510286.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176380',3468151,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176380',3468152,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176383',3468181,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176383',3468182,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176383',3468183,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176383',3468184,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176383',3468185,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176383',3468186,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176383',3468187,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176383',3468188,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176383',3468189,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176383',3468190,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176383',3468191,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176383',3468192,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176383',3468193,'1134','162',10011196.83,10013946.58,2749.75,591196.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','176383',3468194,'1135','162',510286.76,510286.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176383',3468195,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176383',3468196,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176385',3468213,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176385',3468214,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176385',3468215,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176385',3468216,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176385',3468217,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176385',3468218,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176385',3468219,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176385',3468220,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176385',3468221,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176385',3468222,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176385',3468223,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176385',3468224,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176385',3468225,'1134','162',10013946.58,10015670.34,1723.76,370608.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','176385',3468226,'1135','162',510286.76,510336.76,50.00,10750.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176385',3468227,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176385',3468228,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176389',3468279,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176389',3468280,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176389',3468281,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176389',3468282,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176389',3468283,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176389',3468284,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176389',3468285,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176389',3468286,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176389',3468287,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176389',3468288,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176389',3468289,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176389',3468290,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176389',3468291,'1134','162',10015670.34,10016382.13,711.79,153034.85,0.00,0.00,0.00,0.00,0.00),('1','65','423','176389',3468292,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176389',3468293,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176389',3468294,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176390',3468295,'1122','161',801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176390',3468296,'1123','161',429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176390',3468297,'1124','161',148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176390',3468298,'1125','161',243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176390',3468299,'1126','161',567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176390',3468300,'1127','161',405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176390',3468301,'1128','161',78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176390',3468302,'1129','161',207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176390',3468303,'1130','161',721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176390',3468304,'1131','161',111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176390',3468305,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176390',3468306,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176390',3468307,'1134','162',10016382.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176390',3468308,'1135','162',510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176390',3468309,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176390',3468310,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176392',3468335,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176392',3468336,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176392',3468337,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176392',3468338,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176392',3468339,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176392',3468340,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176392',3468341,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176392',3468342,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176392',3468343,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176392',3468344,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176392',3468345,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176392',3468346,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176392',3468347,'1134','162',10016382.13,10019109.23,2727.10,599962.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176392',3468348,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176392',3468349,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176392',3468350,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176395',3468385,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176395',3468386,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176395',3468387,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176395',3468388,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176395',3468389,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176395',3468390,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176395',3468391,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176395',3468392,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176395',3468393,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176395',3468394,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176395',3468395,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176395',3468396,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176395',3468397,'1134','162',10019109.23,10019270.15,160.92,35402.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','176395',3468398,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176395',3468399,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176395',3468400,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176397',3468426,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176397',3468427,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176397',3468428,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176397',3468429,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176397',3468430,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176397',3468431,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176397',3468432,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176397',3468433,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176397',3468434,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176397',3468435,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176397',3468436,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176397',3468437,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176397',3468438,'1134','162',10019270.15,10021187.93,1917.78,421911.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','176397',3468439,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176397',3468440,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176397',3468441,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176401',3468525,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176401',3468526,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176401',3468527,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176401',3468528,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176401',3468529,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176401',3468530,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176401',3468531,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176401',3468532,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176401',3468533,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176401',3468534,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176401',3468535,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176401',3468536,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176401',3468537,'1134','162',10021187.93,10021464.53,276.60,60852.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176401',3468538,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176401',3468539,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176401',3468540,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176403',3468570,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176403',3468571,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176403',3468572,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176403',3468573,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176403',3468574,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176403',3468575,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176403',3468576,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176403',3468577,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176403',3468578,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176403',3468579,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176403',3468580,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176403',3468581,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176403',3468582,'1134','162',10021464.53,10023903.45,2438.92,536562.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','176403',3468583,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176403',3468584,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176403',3468585,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176406',3468639,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176406',3468640,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176406',3468641,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176406',3468642,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176406',3468643,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176406',3468644,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176406',3468645,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176406',3468646,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176406',3468647,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176406',3468648,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176406',3468649,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176406',3468650,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176406',3468651,'1134','162',10023903.45,10025061.28,1157.83,254722.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','176406',3468652,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176406',3468653,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176406',3468654,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176408',3468678,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176408',3468679,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176408',3468680,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176408',3468681,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176408',3468682,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176408',3468683,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176408',3468684,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176408',3468685,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176408',3468686,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176408',3468687,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176408',3468688,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176408',3468689,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176408',3468690,'1134','162',10025061.28,10027455.50,2374.22,522328.40,0.00,0.00,20.00,0.00,0.00),('1','65','423','176408',3468691,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176408',3468692,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176408',3468693,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176410',3468710,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176410',3468711,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176410',3468712,'1124','161',148614.17,148614.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176410',3468713,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176410',3468714,'1126','161',567418.38,567418.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176410',3468715,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176410',3468716,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176410',3468717,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176410',3468718,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176410',3468719,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176410',3468720,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176410',3468721,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176410',3468722,'1134','162',10027455.50,10028903.99,1448.49,318667.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','176410',3468723,'1135','162',510336.76,510336.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176410',3468724,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176410',3468725,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176415',3468796,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176415',3468797,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176415',3468798,'1124','161',148614.17,148975.06,340.89,55565.07,0.00,0.00,20.00,0.00,0.00),('1','65','420','176415',3468799,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176415',3468800,'1126','161',567418.38,567505.75,77.37,12611.31,0.00,0.00,10.00,0.00,0.00),('1','65','420','176415',3468801,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176415',3468802,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176415',3468803,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176415',3468804,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176415',3468805,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176415',3468806,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176415',3468807,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176415',3468808,'1134','162',10028903.99,10030354.80,1450.81,319178.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','176415',3468809,'1135','162',510336.76,511016.76,670.00,147400.00,0.00,0.00,10.00,0.00,0.00),('1','65','424','176415',3468810,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176415',3468811,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176419',3468873,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176419',3468874,'1123','161',429131.95,429131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176419',3468875,'1124','161',148975.06,149527.36,552.30,90024.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','176419',3468876,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176419',3468877,'1126','161',567505.75,567862.01,356.26,58070.38,0.00,0.00,0.00,0.00,0.00),('1','65','420','176419',3468878,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176419',3468879,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176419',3468880,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176419',3468881,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176419',3468882,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176419',3468883,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176419',3468884,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176419',3468885,'1134','162',10030354.80,10031924.25,1569.45,345279.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176419',3468886,'1135','162',511016.76,511016.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176419',3468887,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176419',3468888,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176422',3468932,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176422',3468933,'1123','161',429131.95,430185.71,1053.76,171762.88,0.00,0.00,0.00,0.00,0.00),('1','65','420','176422',3468934,'1124','161',149527.36,149992.83,465.47,75871.61,0.00,0.00,0.00,0.00,0.00),('1','65','420','176422',3468935,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176422',3468936,'1126','161',567862.01,568533.05,671.04,109379.52,0.00,0.00,0.00,0.00,0.00),('1','65','420','176422',3468937,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176422',3468938,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176422',3468939,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176422',3468940,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176422',3468941,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176422',3468942,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176422',3468943,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176422',3468944,'1134','162',10031924.25,10032830.20,905.95,199309.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176422',3468945,'1135','162',511016.76,511302.31,285.55,62821.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176422',3468946,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176422',3468947,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176905',3478145,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176905',3478146,'1123','161',430185.71,430662.44,476.73,77706.99,0.00,0.00,0.00,0.00,0.00),('1','65','420','176905',3478147,'1124','161',149992.83,150233.06,240.23,39157.49,0.00,0.00,0.00,0.00,0.00),('1','65','420','176905',3478148,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176905',3478149,'1126','161',568533.05,568533.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176905',3478150,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176905',3478151,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176905',3478152,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176905',3478153,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176905',3478154,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176905',3478155,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176905',3478156,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176905',3478157,'1134','162',10032830.20,10032830.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176905',3478158,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176905',3478159,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176905',3478160,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176907',3478173,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176907',3478174,'1123','161',430662.44,431249.23,586.79,95646.77,0.00,0.00,0.00,0.00,0.00),('1','65','420','176907',3478175,'1124','161',150233.06,150233.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176907',3478176,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176907',3478177,'1126','161',568533.05,568898.64,365.59,59591.17,0.00,0.00,0.00,0.00,0.00),('1','65','420','176907',3478178,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176907',3478179,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176907',3478180,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176907',3478181,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176907',3478182,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176907',3478183,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176907',3478184,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176907',3478185,'1134','162',10032830.20,10032830.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176907',3478186,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176907',3478187,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176907',3478188,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176910',3478216,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176910',3478217,'1123','161',431249.23,431859.66,610.43,99500.09,0.00,0.00,0.00,0.00,0.00),('1','65','420','176910',3478218,'1124','161',150233.06,150816.92,583.86,95169.18,0.00,0.00,0.00,0.00,0.00),('1','65','420','176910',3478219,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176910',3478220,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176910',3478221,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176910',3478222,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176910',3478223,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176910',3478224,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176910',3478225,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176910',3478226,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176910',3478227,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176910',3478228,'1134','162',10032830.20,10033255.16,424.96,93491.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','176910',3478229,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176910',3478230,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176910',3478231,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176913',3478279,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176913',3478280,'1123','161',431859.66,432512.68,653.02,106442.26,0.00,0.00,0.00,0.00,0.00),('1','65','420','176913',3478281,'1124','161',150816.92,151148.83,331.91,54101.33,0.00,0.00,0.00,0.00,0.00),('1','65','420','176913',3478282,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176913',3478283,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176913',3478284,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176913',3478285,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176913',3478286,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176913',3478287,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176913',3478288,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176913',3478289,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176913',3478290,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176913',3478291,'1134','162',10033255.16,10033927.77,672.61,147974.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','176913',3478292,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176913',3478293,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176913',3478294,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176914',3478295,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176914',3478296,'1123','161',432512.68,433380.16,857.48,139769.24,0.00,0.00,10.00,0.00,0.00),('1','65','420','176914',3478297,'1124','161',151148.83,151676.89,518.06,84443.78,0.00,0.00,10.00,0.00,0.00),('1','65','420','176914',3478298,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176914',3478299,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176914',3478300,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176914',3478301,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176914',3478302,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176914',3478303,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176914',3478304,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176914',3478305,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176914',3478306,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176914',3478307,'1134','162',10033927.77,10034902.03,964.26,212137.20,0.00,0.00,10.00,0.00,0.00),('1','65','423','176914',3478308,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176914',3478309,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176914',3478310,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176917',3478350,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176917',3478351,'1123','161',433380.16,433942.46,562.30,91654.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','176917',3478352,'1124','161',151676.89,151883.22,206.33,33631.79,0.00,0.00,0.00,0.00,0.00),('1','65','420','176917',3478353,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176917',3478354,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176917',3478355,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176917',3478356,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176917',3478357,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176917',3478358,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176917',3478359,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176917',3478360,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176917',3478361,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176917',3478362,'1134','162',10034902.03,10036719.58,1817.55,399861.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176917',3478363,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176917',3478364,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176917',3478365,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176921',3478422,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176921',3478423,'1123','161',433942.46,434369.02,426.56,69529.28,0.00,0.00,0.00,0.00,0.00),('1','65','420','176921',3478424,'1124','161',151883.22,152680.68,797.46,129985.98,0.00,0.00,0.00,0.00,0.00),('1','65','420','176921',3478425,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176921',3478426,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176921',3478427,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176921',3478428,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176921',3478429,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176921',3478430,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176921',3478431,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176921',3478432,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176921',3478433,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176921',3478434,'1134','162',10036719.58,10039275.92,2556.34,562394.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','176921',3478435,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176921',3478436,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176921',3478437,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176922',3478438,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176922',3478439,'1123','161',434369.02,435297.85,928.83,151399.29,0.00,0.00,0.00,0.00,0.00),('1','65','420','176922',3478440,'1124','161',152680.68,152903.48,222.80,36316.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','176922',3478441,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176922',3478442,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','176922',3478443,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176922',3478444,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176922',3478445,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176922',3478446,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176922',3478447,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176922',3478448,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','176922',3478449,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','176922',3478450,'1134','162',10039275.92,10041600.75,2324.83,511462.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','176922',3478451,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176922',3478452,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','176922',3478453,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177162',3483038,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177162',3483039,'1123','161',435297.85,435923.28,615.43,100315.09,0.00,0.00,10.00,0.00,0.00),('1','65','420','177162',3483040,'1124','161',152903.48,153113.48,200.00,32600.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','177162',3483041,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177162',3483042,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177162',3483043,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177162',3483044,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177162',3483045,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177162',3483046,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177162',3483047,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177162',3483048,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177162',3483049,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177162',3483050,'1134','162',10041600.75,10042548.23,937.48,206245.60,0.00,0.00,10.00,0.00,0.00),('1','65','423','177162',3483051,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177162',3483052,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177162',3483053,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177168',3483141,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177168',3483142,'1123','161',435923.28,436478.43,555.15,90489.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','177168',3483143,'1124','161',153113.48,153293.17,179.69,29289.47,0.00,0.00,0.00,0.00,0.00),('1','65','420','177168',3483144,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177168',3483145,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177168',3483146,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177168',3483147,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177168',3483148,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177168',3483149,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177168',3483150,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177168',3483151,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177168',3483152,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177168',3483153,'1134','162',10042548.23,10042950.58,402.35,88517.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177168',3483154,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177168',3483155,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177168',3483156,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177171',3483206,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177171',3483207,'1123','161',436478.43,436719.66,241.23,39320.49,0.00,0.00,0.00,0.00,0.00),('1','65','420','177171',3483208,'1124','161',153293.17,153865.69,572.52,93320.76,0.00,0.00,0.00,0.00,0.00),('1','65','420','177171',3483209,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177171',3483210,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177171',3483211,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177171',3483212,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177171',3483213,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177171',3483214,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177171',3483215,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177171',3483216,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177171',3483217,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177171',3483218,'1134','162',10042950.58,10044915.84,1965.26,432357.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','177171',3483219,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177171',3483220,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177171',3483221,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177175',3483277,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177175',3483278,'1123','161',436719.66,437201.05,481.39,78466.57,0.00,0.00,0.00,0.00,0.00),('1','65','420','177175',3483279,'1124','161',153865.69,154003.14,137.45,22404.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','177175',3483280,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177175',3483281,'1126','161',568898.64,568898.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177175',3483282,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177175',3483283,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177175',3483284,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177175',3483285,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177175',3483286,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177175',3483287,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177175',3483288,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177175',3483289,'1134','162',10044915.84,10045173.11,257.27,57885.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','177175',3483290,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177175',3483291,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177175',3483292,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177178',3483324,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177178',3483325,'1123','161',437201.05,437904.61,703.56,114680.28,0.00,0.00,0.00,0.00,0.00),('1','65','420','177178',3483326,'1124','161',154003.14,154003.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177178',3483327,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177178',3483328,'1126','161',568898.64,569160.61,261.97,42701.11,0.00,0.00,0.00,0.00,0.00),('1','65','420','177178',3483329,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177178',3483330,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177178',3483331,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177178',3483332,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177178',3483333,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177178',3483334,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177178',3483335,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177178',3483336,'1134','162',10045173.11,10045473.34,300.23,67551.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','177178',3483337,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177178',3483338,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177178',3483339,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177180',3483364,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177180',3483365,'1123','161',437904.61,438861.71,937.10,152747.30,0.00,0.00,20.00,0.00,0.00),('1','65','420','177180',3483366,'1124','161',154003.14,154003.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177180',3483367,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177180',3483368,'1126','161',569160.61,569908.65,738.04,120300.52,0.00,0.00,10.00,0.00,0.00),('1','65','420','177180',3483369,'1127','161',405424.06,405424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177180',3483370,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177180',3483371,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177180',3483372,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177180',3483373,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177180',3483374,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177180',3483375,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177180',3483376,'1134','162',10045473.34,10048104.46,2621.12,589752.00,0.00,0.00,10.00,0.00,0.00),('1','65','423','177180',3483377,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177180',3483378,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177180',3483379,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177228',3484218,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177228',3484219,'1123','161',438861.71,439728.47,866.76,141281.88,0.00,0.00,0.00,0.00,0.00),('1','65','420','177228',3484220,'1124','161',154003.14,154003.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177228',3484221,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177228',3484222,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177228',3484223,'1127','161',405424.06,405663.16,239.10,38973.30,0.00,0.00,0.00,0.00,0.00),('1','65','421','177228',3484224,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177228',3484225,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177228',3484226,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177228',3484227,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177228',3484228,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177228',3484229,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177228',3484230,'1134','162',10048104.46,10050030.78,1926.32,433422.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177228',3484231,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177228',3484232,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177228',3484233,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177230',3484256,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177230',3484257,'1123','161',439728.47,440418.71,690.24,112509.12,0.00,0.00,0.00,0.00,0.00),('1','65','420','177230',3484258,'1124','161',154003.14,154195.83,192.69,31408.47,0.00,0.00,0.00,0.00,0.00),('1','65','420','177230',3484259,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177230',3484260,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177230',3484261,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177230',3484262,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177230',3484263,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177230',3484264,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177230',3484265,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177230',3484266,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177230',3484267,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177230',3484268,'1134','162',10050030.78,10050239.19,208.41,46892.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','177230',3484269,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177230',3484270,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177230',3484271,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177232',3484274,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177232',3484275,'1123','161',440418.71,441386.86,968.15,157808.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','177232',3484276,'1124','161',154195.83,154534.56,338.73,55212.99,0.00,0.00,0.00,0.00,0.00),('1','65','420','177232',3484277,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177232',3484278,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177232',3484279,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177232',3484280,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177232',3484281,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177232',3484282,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177232',3484283,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177232',3484284,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177232',3484285,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177232',3484286,'1134','162',10050239.19,10051019.24,770.05,173261.25,0.00,0.00,10.00,0.00,0.00),('1','65','423','177232',3484287,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177232',3484288,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177232',3484289,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177233',3484290,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177233',3484291,'1123','161',441386.86,442362.04,975.18,158954.34,0.00,0.00,0.00,0.00,0.00),('1','65','420','177233',3484292,'1124','161',154534.56,154696.88,162.32,26458.16,0.00,0.00,0.00,0.00,0.00),('1','65','420','177233',3484293,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177233',3484294,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177233',3484295,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177233',3484296,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177233',3484297,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177233',3484298,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177233',3484299,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177233',3484300,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177233',3484301,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177233',3484302,'1134','162',10051019.24,10051220.05,200.81,45182.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','177233',3484303,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177233',3484304,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177233',3484305,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177234',3484306,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177234',3484307,'1123','161',442362.04,442362.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177234',3484308,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177234',3484309,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177234',3484310,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177234',3484311,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177234',3484312,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177234',3484313,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177234',3484314,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177234',3484315,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177234',3484316,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177234',3484317,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177234',3484318,'1134','162',10051220.05,10051741.39,521.34,117301.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','177234',3484319,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177234',3484320,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177234',3484321,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177235',3484322,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177235',3484323,'1123','161',442362.04,442362.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177235',3484324,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177235',3484325,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177235',3484326,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177235',3484327,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177235',3484328,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177235',3484329,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177235',3484330,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177235',3484331,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177235',3484332,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177235',3484333,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177235',3484334,'1134','162',10051741.39,10054303.76,2562.37,576533.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','177235',3484335,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177235',3484336,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177235',3484337,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177237',3484340,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177237',3484341,'1123','161',442362.04,442362.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177237',3484342,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177237',3484343,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177237',3484344,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177237',3484345,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177237',3484346,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177237',3484347,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177237',3484348,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177237',3484349,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177237',3484350,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177237',3484351,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177237',3484352,'1134','162',10054303.76,10055062.61,758.85,170741.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','177237',3484353,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177237',3484354,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177237',3484355,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177238',3484356,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177238',3484357,'1123','161',442362.04,442362.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177238',3484358,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177238',3484359,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177238',3484360,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177238',3484361,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177238',3484362,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177238',3484363,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177238',3484364,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177238',3484365,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177238',3484366,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177238',3484367,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177238',3484368,'1134','162',10055062.61,10059499.25,4426.64,995994.00,0.00,0.00,10.00,0.00,0.00),('1','65','423','177238',3484369,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177238',3484370,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177238',3484371,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177241',3484396,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177241',3484397,'1123','161',442362.04,442362.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177241',3484398,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177241',3484399,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177241',3484400,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177241',3484401,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177241',3484402,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177241',3484403,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177241',3484404,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177241',3484405,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177241',3484406,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177241',3484407,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177241',3484408,'1134','162',10059499.25,10060376.00,876.75,197268.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','177241',3484409,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177241',3484410,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177241',3484411,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177242',3484412,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177242',3484413,'1123','161',442362.04,442362.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177242',3484414,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177242',3484415,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177242',3484416,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177242',3484417,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177242',3484418,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177242',3484419,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177242',3484420,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177242',3484421,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177242',3484422,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177242',3484423,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177242',3484424,'1134','162',10060376.00,10060960.43,584.43,131496.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','177242',3484425,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177242',3484426,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177242',3484427,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177243',3484428,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177243',3484429,'1123','161',442362.04,442613.41,251.37,40973.31,0.00,0.00,0.00,0.00,0.00),('1','65','420','177243',3484430,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177243',3484431,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177243',3484432,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177243',3484433,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177243',3484434,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177243',3484435,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177243',3484436,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177243',3484437,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177243',3484438,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177243',3484439,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177243',3484440,'1134','162',10060960.43,10062601.09,1640.66,369148.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','177243',3484441,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177243',3484442,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177243',3484443,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177244',3484444,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177244',3484445,'1123','161',442613.41,443449.40,835.99,136266.37,0.00,0.00,0.00,0.00,0.00),('1','65','420','177244',3484446,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177244',3484447,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177244',3484448,'1126','161',569908.65,569908.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177244',3484449,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177244',3484450,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177244',3484451,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177244',3484452,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177244',3484453,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177244',3484454,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177244',3484455,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177244',3484456,'1134','162',10062601.09,10063119.21,518.12,116577.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177244',3484457,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177244',3484458,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177244',3484459,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177699',3493619,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177699',3493620,'1123','161',443449.40,443938.00,488.60,79641.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','177699',3493621,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177699',3493622,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177699',3493623,'1126','161',569908.65,570917.18,1008.53,164390.39,0.00,0.00,0.00,0.00,0.00),('1','65','420','177699',3493624,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177699',3493625,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177699',3493626,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177699',3493627,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177699',3493628,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177699',3493629,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177699',3493630,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177699',3493631,'1134','162',10063119.21,10063119.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177699',3493632,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177699',3493633,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177699',3493634,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177705',3493708,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177705',3493709,'1123','161',443938.00,444358.43,410.43,66900.09,0.00,0.00,10.00,0.00,0.00),('1','65','420','177705',3493710,'1124','161',154696.88,154696.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177705',3493711,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177705',3493712,'1126','161',570917.18,572730.10,1792.92,292245.96,0.00,0.00,20.00,0.00,0.00),('1','65','420','177705',3493713,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177705',3493714,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177705',3493715,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177705',3493716,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177705',3493717,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177705',3493718,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177705',3493719,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177705',3493720,'1134','162',10063119.21,10063353.99,214.78,48325.50,0.00,0.00,20.00,0.00,0.00),('1','65','423','177705',3493721,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177705',3493722,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177705',3493723,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177715',3493912,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177715',3493913,'1123','161',444358.43,444869.18,510.75,83252.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','177715',3493914,'1124','161',154696.88,155059.77,362.89,59151.07,0.00,0.00,0.00,0.00,0.00),('1','65','420','177715',3493915,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177715',3493916,'1126','161',572730.10,572730.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177715',3493917,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177715',3493918,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177715',3493919,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177715',3493920,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177715',3493921,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177715',3493922,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177715',3493923,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177715',3493924,'1134','162',10063353.99,10063353.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177715',3493925,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177715',3493926,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177715',3493927,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177717',3493949,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177717',3493950,'1123','161',444869.18,445638.13,768.95,125338.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','177717',3493951,'1124','161',155059.77,155171.17,111.40,18158.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','177717',3493952,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177717',3493953,'1126','161',572730.10,572990.30,260.20,42412.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','177717',3493954,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177717',3493955,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177717',3493956,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177717',3493957,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177717',3493958,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177717',3493959,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177717',3493960,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177717',3493961,'1134','162',10063353.99,10063353.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177717',3493962,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177717',3493963,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177717',3493964,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177718',3493965,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177718',3493966,'1123','161',445638.13,446411.33,773.20,126031.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','177718',3493967,'1124','161',155171.17,155640.08,468.91,76432.33,0.00,0.00,0.00,0.00,0.00),('1','65','420','177718',3493968,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177718',3493969,'1126','161',572990.30,572990.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177718',3493970,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177718',3493971,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177718',3493972,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177718',3493973,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177718',3493974,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177718',3493975,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177718',3493976,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177718',3493977,'1134','162',10063353.99,10063353.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177718',3493978,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177718',3493979,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177718',3493980,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177720',3493991,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177720',3493992,'1123','161',446411.33,447039.70,628.37,102424.31,0.00,0.00,0.00,0.00,0.00),('1','65','420','177720',3493993,'1124','161',155640.08,156157.44,517.36,84329.68,0.00,0.00,0.00,0.00,0.00),('1','65','420','177720',3493994,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177720',3493995,'1126','161',572990.30,572990.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177720',3493996,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177720',3493997,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177720',3493998,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177720',3493999,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177720',3494000,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177720',3494001,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177720',3494002,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177720',3494003,'1134','162',10063353.99,10063353.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177720',3494004,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177720',3494005,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177720',3494006,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177724',3494079,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177724',3494080,'1123','161',447039.70,447690.70,651.00,106113.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177724',3494081,'1124','161',156157.44,156566.26,408.82,66637.66,0.00,0.00,0.00,0.00,0.00),('1','65','420','177724',3494082,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177724',3494083,'1126','161',572990.30,572990.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177724',3494084,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177724',3494085,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177724',3494086,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177724',3494087,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177724',3494088,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177724',3494089,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177724',3494090,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177724',3494091,'1134','162',10063353.99,10065102.78,1748.79,402221.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','177724',3494092,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177724',3494093,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177724',3494094,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177726',3494113,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177726',3494114,'1123','161',447690.70,448306.17,615.47,100321.61,0.00,0.00,0.00,0.00,0.00),('1','65','420','177726',3494115,'1124','161',156566.26,156566.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177726',3494116,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177726',3494117,'1126','161',572990.30,573522.28,531.98,86712.74,0.00,0.00,0.00,0.00,0.00),('1','65','420','177726',3494118,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177726',3494119,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177726',3494120,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177726',3494121,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177726',3494122,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177726',3494123,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177726',3494124,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177726',3494125,'1134','162',10065102.78,10066531.26,1428.48,328550.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','177726',3494126,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177726',3494127,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177726',3494128,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177728',3494141,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177728',3494142,'1123','161',448306.17,449057.65,741.48,120861.24,0.00,0.00,10.00,0.00,0.00),('1','65','420','177728',3494143,'1124','161',156566.26,156745.66,169.40,27612.20,0.00,0.00,10.00,0.00,0.00),('1','65','420','177728',3494144,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177728',3494145,'1126','161',573522.28,573522.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177728',3494146,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177728',3494147,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177728',3494148,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177728',3494149,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177728',3494150,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177728',3494151,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177728',3494152,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177728',3494153,'1134','162',10066531.26,10068458.98,1917.72,441075.60,0.00,0.00,10.00,0.00,0.00),('1','65','423','177728',3494154,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177728',3494155,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177728',3494156,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177731',3494181,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177731',3494182,'1123','161',449057.65,450115.70,1058.05,172462.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','177731',3494183,'1124','161',156745.66,156745.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177731',3494184,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','177731',3494185,'1126','161',573522.28,574045.85,523.57,85341.91,0.00,0.00,0.00,0.00,0.00),('1','65','420','177731',3494186,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177731',3494187,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177731',3494188,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177731',3494189,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177731',3494190,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177731',3494191,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','177731',3494192,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','177731',3494193,'1134','162',10068458.98,10069636.13,1177.15,270744.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','177731',3494194,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177731',3494195,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','177731',3494196,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178234',3503674,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178234',3503675,'1123','161',450115.70,450762.29,646.59,105394.17,0.00,0.00,0.00,0.00,0.00),('1','65','420','178234',3503676,'1124','161',156745.66,157362.17,616.51,100491.13,0.00,0.00,0.00,0.00,0.00),('1','65','420','178234',3503677,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178234',3503678,'1126','161',574045.85,574045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178234',3503679,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178234',3503680,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178234',3503681,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178234',3503682,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178234',3503683,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178234',3503684,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178234',3503685,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178234',3503686,'1134','162',10069636.13,10069974.53,338.40,77832.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178234',3503687,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178234',3503688,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178234',3503689,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178238',3503716,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178238',3503717,'1123','161',450762.29,450762.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178238',3503718,'1124','161',157362.17,157362.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178238',3503719,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178238',3503720,'1126','161',574045.85,574045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178238',3503721,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178238',3503722,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178238',3503723,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178238',3503724,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178238',3503725,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178238',3503726,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178238',3503727,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178238',3503728,'1134','162',10069974.53,10070866.35,891.82,205118.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','178238',3503729,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178238',3503730,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178238',3503731,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178239',3503732,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178239',3503733,'1123','161',450762.29,450762.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178239',3503734,'1124','161',157362.17,157362.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178239',3503735,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178239',3503736,'1126','161',574045.85,574045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178239',3503737,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178239',3503738,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178239',3503739,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178239',3503740,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178239',3503741,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178239',3503742,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178239',3503743,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178239',3503744,'1134','162',10070866.35,10072548.76,1682.41,386954.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','178239',3503745,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178239',3503746,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178239',3503747,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178241',3503763,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178241',3503764,'1123','161',450762.29,450762.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178241',3503765,'1124','161',157362.17,157362.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178241',3503766,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178241',3503767,'1126','161',574045.85,574045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178241',3503768,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178241',3503769,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178241',3503770,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178241',3503771,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178241',3503772,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178241',3503773,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178241',3503774,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178241',3503775,'1134','162',10072548.76,10072817.69,268.93,61853.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','178241',3503776,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178241',3503777,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178241',3503778,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178242',3503779,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178242',3503780,'1123','161',450762.29,451036.71,274.42,44730.46,0.00,0.00,0.00,0.00,0.00),('1','65','420','178242',3503781,'1124','161',157362.17,157484.01,121.84,19859.92,0.00,0.00,0.00,0.00,0.00),('1','65','420','178242',3503782,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178242',3503783,'1126','161',574045.85,574045.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178242',3503784,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178242',3503785,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178242',3503786,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178242',3503787,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178242',3503788,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178242',3503789,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178242',3503790,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178242',3503791,'1134','162',10072817.69,10073133.97,316.28,72744.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','178242',3503792,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178242',3503793,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178242',3503794,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178244',3503810,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178244',3503811,'1123','161',451036.71,451823.32,786.61,128217.43,0.00,0.00,0.00,0.00,0.00),('1','65','420','178244',3503812,'1124','161',157484.01,158015.56,531.55,86642.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','178244',3503813,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178244',3503814,'1126','161',574045.85,574408.82,362.97,59164.11,0.00,0.00,0.00,0.00,0.00),('1','65','420','178244',3503815,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178244',3503816,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178244',3503817,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178244',3503818,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178244',3503819,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178244',3503820,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178244',3503821,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178244',3503822,'1134','162',10073133.97,10074865.44,1731.47,398238.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','178244',3503823,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178244',3503824,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178244',3503825,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178248',3503903,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178248',3503904,'1123','161',451823.32,452165.24,341.92,55732.96,0.00,0.00,0.00,0.00,0.00),('1','65','420','178248',3503905,'1124','161',158015.56,158614.48,598.92,97623.96,0.00,0.00,0.00,0.00,0.00),('1','65','420','178248',3503906,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178248',3503907,'1126','161',574408.82,574408.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178248',3503908,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178248',3503909,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178248',3503910,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178248',3503911,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178248',3503912,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178248',3503913,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178248',3503914,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178248',3503915,'1134','162',10074865.44,10077806.26,2940.82,676388.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','178248',3503916,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178248',3503917,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178248',3503918,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178745',3512870,'1122','161',801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178745',3512871,'1123','161',452165.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178745',3512872,'1124','161',158614.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178745',3512873,'1125','161',243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178745',3512874,'1126','161',574408.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178745',3512875,'1127','161',405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178745',3512876,'1128','161',78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178745',3512877,'1129','161',207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178745',3512878,'1130','161',721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178745',3512879,'1131','161',111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178745',3512880,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178745',3512881,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178745',3512882,'1134','162',10077806.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178745',3512883,'1135','162',511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178745',3512884,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178745',3512885,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178746',3512886,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178746',3512887,'1123','161',452165.24,452428.92,253.68,41349.84,0.00,0.00,10.00,0.00,0.00),('1','65','420','178746',3512888,'1124','161',158614.48,159054.92,430.44,70161.72,0.00,0.00,10.00,0.00,0.00),('1','65','420','178746',3512889,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178746',3512890,'1126','161',574408.82,574408.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178746',3512891,'1127','161',405663.16,405663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178746',3512892,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178746',3512893,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178746',3512894,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178746',3512895,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178746',3512896,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178746',3512897,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178746',3512898,'1134','162',10077806.26,10078578.81,762.55,175386.50,0.00,0.00,10.00,0.00,0.00),('1','65','423','178746',3512899,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178746',3512900,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178746',3512901,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178750',3512971,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178750',3512972,'1123','161',452428.92,452974.37,545.45,88908.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','178750',3512973,'1124','161',159054.92,159102.17,47.25,7701.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','178750',3512974,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178750',3512975,'1126','161',574408.82,574408.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178750',3512976,'1127','161',405663.16,406140.88,477.72,77868.36,0.00,0.00,0.00,0.00,0.00),('1','65','421','178750',3512977,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178750',3512978,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178750',3512979,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178750',3512980,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178750',3512981,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178750',3512982,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178750',3512983,'1134','162',10078578.81,10078578.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178750',3512984,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178750',3512985,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178750',3512986,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178752',3513003,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178752',3513004,'1123','161',452974.37,453539.42,565.05,92103.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','178752',3513005,'1124','161',159102.17,159102.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178752',3513006,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178752',3513007,'1126','161',574408.82,574943.03,534.21,87076.23,0.00,0.00,0.00,0.00,0.00),('1','65','420','178752',3513008,'1127','161',406140.88,406140.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178752',3513009,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178752',3513010,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178752',3513011,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178752',3513012,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178752',3513013,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178752',3513014,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178752',3513015,'1134','162',10078578.81,10078578.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178752',3513016,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178752',3513017,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178752',3513018,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178756',3513116,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178756',3513117,'1123','161',453539.42,454208.82,669.40,109112.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','178756',3513118,'1124','161',159102.17,159212.70,110.53,18016.39,0.00,0.00,0.00,0.00,0.00),('1','65','420','178756',3513119,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178756',3513120,'1126','161',574943.03,575147.37,204.34,33307.42,0.00,0.00,0.00,0.00,0.00),('1','65','420','178756',3513121,'1127','161',406140.88,406140.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178756',3513122,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178756',3513123,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178756',3513124,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178756',3513125,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178756',3513126,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178756',3513127,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178756',3513128,'1134','162',10078578.81,10078578.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178756',3513129,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178756',3513130,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178756',3513131,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178758',3513148,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178758',3513149,'1123','161',454208.82,455065.82,857.00,139691.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178758',3513150,'1124','161',159212.70,159400.45,187.75,30603.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','178758',3513151,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178758',3513152,'1126','161',575147.37,575147.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','178758',3513153,'1127','161',406140.88,406140.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178758',3513154,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178758',3513155,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178758',3513156,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178758',3513157,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178758',3513158,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','178758',3513159,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','178758',3513160,'1134','162',10078578.81,10080546.22,1967.41,462341.35,0.00,0.00,0.00,0.00,0.00),('1','65','423','178758',3513161,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178758',3513162,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','178758',3513163,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179229',3521934,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179229',3521935,'1123','161',455065.82,456005.05,929.23,151464.49,0.00,0.00,10.00,0.00,0.00),('1','65','420','179229',3521936,'1124','161',159400.45,159400.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179229',3521937,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179229',3521938,'1126','161',575147.37,575147.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179229',3521939,'1127','161',406140.88,406140.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179229',3521940,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179229',3521941,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179229',3521942,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179229',3521943,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179229',3521944,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179229',3521945,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179229',3521946,'1134','162',10080546.22,10082745.00,2178.78,512013.30,0.00,0.00,20.00,0.00,0.00),('1','65','423','179229',3521947,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179229',3521948,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179229',3521949,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179230',3521950,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179230',3521951,'1123','161',456005.05,456591.82,586.77,95643.51,0.00,0.00,0.00,0.00,0.00),('1','65','420','179230',3521952,'1124','161',159400.45,159400.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179230',3521953,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179230',3521954,'1126','161',575147.37,576070.96,923.59,150545.17,0.00,0.00,0.00,0.00,0.00),('1','65','420','179230',3521955,'1127','161',406140.88,406140.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179230',3521956,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179230',3521957,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179230',3521958,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179230',3521959,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179230',3521960,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179230',3521961,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179230',3521962,'1134','162',10082745.00,10083929.36,1184.36,278324.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','179230',3521963,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179230',3521964,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179230',3521965,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179232',3521981,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179232',3521982,'1123','161',456591.82,458016.85,1425.03,232279.89,0.00,0.00,0.00,0.00,0.00),('1','65','420','179232',3521983,'1124','161',159400.45,160413.25,1012.80,165086.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','179232',3521984,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179232',3521985,'1126','161',576070.96,576070.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179232',3521986,'1127','161',406140.88,406140.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179232',3521987,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179232',3521988,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179232',3521989,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179232',3521990,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179232',3521991,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179232',3521992,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179232',3521993,'1134','162',10083929.36,10087485.18,3545.82,833267.70,0.00,0.00,10.00,0.00,0.00),('1','65','423','179232',3521994,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179232',3521995,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179232',3521996,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179234',3522015,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179234',3522016,'1123','161',458016.85,460178.78,2161.93,352394.59,0.00,0.00,0.00,0.00,0.00),('1','65','420','179234',3522017,'1124','161',160413.25,160446.38,33.13,5400.19,0.00,0.00,0.00,0.00,0.00),('1','65','420','179234',3522018,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179234',3522019,'1126','161',576070.96,577614.76,1543.80,251639.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','179234',3522020,'1127','161',406140.88,406140.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179234',3522021,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179234',3522022,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179234',3522023,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179234',3522024,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179234',3522025,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179234',3522026,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179234',3522027,'1134','162',10087485.18,10087635.18,150.00,35250.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179234',3522028,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179234',3522029,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179234',3522030,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179854',3533866,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179854',3533867,'1123','161',460178.78,460474.58,295.80,48215.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','179854',3533868,'1124','161',160446.38,161226.01,779.63,127079.69,0.00,0.00,0.00,0.00,0.00),('1','65','420','179854',3533869,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179854',3533870,'1126','161',577614.76,577614.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179854',3533871,'1127','161',406140.88,406140.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179854',3533872,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179854',3533873,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179854',3533874,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179854',3533875,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179854',3533876,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179854',3533877,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179854',3533878,'1134','162',10087635.18,10087879.20,244.02,58564.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','179854',3533879,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179854',3533880,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179854',3533881,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179856',3533892,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179856',3533893,'1123','161',460474.58,460930.18,455.60,74262.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','179856',3533894,'1124','161',161226.01,161226.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179856',3533895,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179856',3533896,'1126','161',577614.76,577614.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179856',3533897,'1127','161',406140.88,406692.63,551.75,89935.25,0.00,0.00,0.00,0.00,0.00),('1','65','421','179856',3533898,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179856',3533899,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179856',3533900,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179856',3533901,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179856',3533902,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179856',3533903,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179856',3533904,'1134','162',10087879.20,10088138.88,259.68,62323.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','179856',3533905,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179856',3533906,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179856',3533907,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179860',3533956,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179860',3533957,'1123','161',460930.18,462228.31,1288.13,209965.19,0.00,0.00,10.00,0.00,0.00),('1','65','420','179860',3533958,'1124','161',161226.01,162075.86,839.85,136895.55,0.00,0.00,10.00,0.00,0.00),('1','65','420','179860',3533959,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179860',3533960,'1126','161',577614.76,577974.76,350.00,57050.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','179860',3533961,'1127','161',406692.63,406727.23,24.60,4009.80,0.00,0.00,10.00,0.00,0.00),('1','65','421','179860',3533962,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179860',3533963,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179860',3533964,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179860',3533965,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179860',3533966,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179860',3533967,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179860',3533968,'1134','162',10088138.88,10091769.70,3620.82,868996.80,0.00,0.00,10.00,0.00,0.00),('1','65','423','179860',3533969,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179860',3533970,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179860',3533971,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179864',3534030,'1122','161',801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179864',3534031,'1123','161',462228.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179864',3534032,'1124','161',162075.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179864',3534033,'1125','161',243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179864',3534034,'1126','161',577974.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','179864',3534035,'1127','161',406727.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179864',3534036,'1128','161',78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179864',3534037,'1129','161',207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179864',3534038,'1130','161',721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179864',3534039,'1131','161',111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179864',3534040,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','179864',3534041,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179864',3534042,'1134','162',10091769.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','179864',3534043,'1135','162',511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179864',3534044,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','179864',3534045,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180584',3547232,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180584',3547233,'1123','161',462228.31,463487.14,1258.83,210224.61,0.00,0.00,0.00,0.00,0.00),('1','65','420','180584',3547234,'1124','161',162075.86,162075.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180584',3547235,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180584',3547236,'1126','161',577974.76,577974.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180584',3547237,'1127','161',406727.23,406826.33,99.10,16549.70,0.00,0.00,0.00,0.00,0.00),('1','65','421','180584',3547238,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180584',3547239,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180584',3547240,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180584',3547241,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180584',3547242,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180584',3547243,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180584',3547244,'1134','162',10091769.70,10091962.70,193.00,47285.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180584',3547245,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180584',3547246,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180584',3547247,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180585',3547248,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180585',3547249,'1123','161',463487.14,464369.26,882.12,147314.04,0.00,0.00,0.00,0.00,0.00),('1','65','420','180585',3547250,'1124','161',162075.86,162356.95,281.09,46942.03,0.00,0.00,0.00,0.00,0.00),('1','65','420','180585',3547251,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180585',3547252,'1126','161',577974.76,577974.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180585',3547253,'1127','161',406826.33,406826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180585',3547254,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180585',3547255,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180585',3547256,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180585',3547257,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180585',3547258,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180585',3547259,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180585',3547260,'1134','162',10091962.70,10092348.47,385.77,94513.65,0.00,0.00,0.00,0.00,0.00),('1','65','423','180585',3547261,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180585',3547262,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180585',3547263,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180590',3547331,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180590',3547332,'1123','161',464369.26,464636.69,267.43,44660.81,0.00,0.00,0.00,0.00,0.00),('1','65','420','180590',3547333,'1124','161',162356.95,163451.40,1094.45,182773.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','180590',3547334,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180590',3547335,'1126','161',577974.76,577974.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180590',3547336,'1127','161',406826.33,406826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180590',3547337,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180590',3547338,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180590',3547339,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180590',3547340,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180590',3547341,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180590',3547342,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180590',3547343,'1134','162',10092348.47,10093856.43,1507.96,369450.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','180590',3547344,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180590',3547345,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180590',3547346,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180595',3547404,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180595',3547405,'1123','161',464636.69,465462.57,825.88,137921.96,0.00,0.00,0.00,0.00,0.00),('1','65','420','180595',3547406,'1124','161',163451.40,164156.28,704.88,117714.96,0.00,0.00,0.00,0.00,0.00),('1','65','420','180595',3547407,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180595',3547408,'1126','161',577974.76,577974.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180595',3547409,'1127','161',406826.33,406826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180595',3547410,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180595',3547411,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180595',3547412,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180595',3547413,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180595',3547414,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180595',3547415,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180595',3547416,'1134','162',10093856.43,10094325.78,469.35,114990.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','180595',3547417,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180595',3547418,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180595',3547419,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180596',3547420,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180596',3547421,'1123','161',465462.57,465999.88,537.31,89730.77,0.00,0.00,0.00,0.00,0.00),('1','65','420','180596',3547422,'1124','161',164156.28,164713.79,557.51,93104.17,0.00,0.00,0.00,0.00,0.00),('1','65','420','180596',3547423,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180596',3547424,'1126','161',577974.76,578035.53,60.77,10148.59,0.00,0.00,0.00,0.00,0.00),('1','65','420','180596',3547425,'1127','161',406826.33,406826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180596',3547426,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180596',3547427,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180596',3547428,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180596',3547429,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180596',3547430,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180596',3547431,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180596',3547432,'1134','162',10094325.78,10094588.54,262.76,64376.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','180596',3547433,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180596',3547434,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180596',3547435,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180601',3547516,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,10.00),('1','65','420','180601',3547517,'1123','161',465999.88,466392.41,392.53,65552.51,0.00,0.00,0.00,0.00,10.00),('1','65','420','180601',3547518,'1124','161',164713.79,165378.91,665.12,111075.04,0.00,0.00,0.00,0.00,0.00),('1','65','420','180601',3547519,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180601',3547520,'1126','161',578035.53,578035.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180601',3547521,'1127','161',406826.33,406826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180601',3547522,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180601',3547523,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180601',3547524,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180601',3547525,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180601',3547526,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180601',3547527,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180601',3547528,'1134','162',10094588.54,10096970.14,2381.60,583492.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180601',3547529,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180601',3547530,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180601',3547531,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180605',3547603,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180605',3547604,'1123','161',466392.41,467295.43,903.02,150804.34,0.00,0.00,0.00,0.00,0.00),('1','65','420','180605',3547605,'1124','161',165378.91,165378.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180605',3547606,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180605',3547607,'1126','161',578035.53,578563.47,527.94,88165.98,0.00,0.00,0.00,0.00,0.00),('1','65','420','180605',3547608,'1127','161',406826.33,406826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180605',3547609,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180605',3547610,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180605',3547611,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180605',3547612,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180605',3547613,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180605',3547614,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180605',3547615,'1134','162',10096970.14,10097868.34,898.20,220059.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180605',3547616,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180605',3547617,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180605',3547618,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180611',3547715,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180611',3547716,'1123','161',467295.43,468018.43,723.00,120741.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180611',3547717,'1124','161',165378.91,165656.62,277.71,46377.57,0.00,0.00,0.00,0.00,0.00),('1','65','420','180611',3547718,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180611',3547719,'1126','161',578563.47,578563.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180611',3547720,'1127','161',406826.33,406826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180611',3547721,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180611',3547722,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180611',3547723,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180611',3547724,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180611',3547725,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180611',3547726,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180611',3547727,'1134','162',10097868.34,10099036.70,1168.36,286248.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','180611',3547728,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180611',3547729,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180611',3547730,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180614',3547763,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180614',3547764,'1123','161',468018.43,468765.49,747.06,124759.02,0.00,0.00,0.00,0.00,0.00),('1','65','420','180614',3547765,'1124','161',165656.62,165656.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180614',3547766,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180614',3547767,'1126','161',578563.47,579137.02,573.55,95782.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','180614',3547768,'1127','161',406826.33,406826.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180614',3547769,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180614',3547770,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180614',3547771,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180614',3547772,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180614',3547773,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180614',3547774,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180614',3547775,'1134','162',10099036.70,10099943.83,907.13,222246.85,0.00,0.00,0.00,0.00,0.00),('1','65','423','180614',3547776,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180614',3547777,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180614',3547778,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180619',3547834,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180619',3547835,'1123','161',468765.49,468765.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180619',3547836,'1124','161',165656.62,166606.59,949.97,158644.99,0.00,0.00,0.00,0.00,0.00),('1','65','420','180619',3547837,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180619',3547838,'1126','161',579137.02,579137.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180619',3547839,'1127','161',406826.33,406982.01,155.68,25998.56,0.00,0.00,0.00,0.00,0.00),('1','65','421','180619',3547840,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180619',3547841,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180619',3547842,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180619',3547843,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180619',3547844,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180619',3547845,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180619',3547846,'1134','162',10099943.83,10099943.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180619',3547847,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180619',3547848,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180619',3547849,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180622',3547909,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180622',3547910,'1123','161',468765.49,469145.58,380.09,63475.03,0.00,0.00,0.00,0.00,0.00),('1','65','420','180622',3547911,'1124','161',166606.59,166765.56,158.97,26547.99,0.00,0.00,0.00,0.00,0.00),('1','65','420','180622',3547912,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180622',3547913,'1126','161',579137.02,579137.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180622',3547914,'1127','161',406982.01,406982.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180622',3547915,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180622',3547916,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180622',3547917,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180622',3547918,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180622',3547919,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180622',3547920,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180622',3547921,'1134','162',10099943.83,10100431.16,487.33,119395.85,0.00,0.00,0.00,0.00,0.00),('1','65','423','180622',3547922,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180622',3547923,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180622',3547924,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180815',3551469,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180815',3551470,'1123','161',469145.58,469676.87,521.29,87055.43,0.00,0.00,10.00,0.00,0.00),('1','65','420','180815',3551471,'1124','161',166765.56,166765.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180815',3551472,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180815',3551473,'1126','161',579137.02,579443.23,306.21,51137.07,0.00,0.00,0.00,0.00,0.00),('1','65','420','180815',3551474,'1127','161',406982.01,406982.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180815',3551475,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180815',3551476,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180815',3551477,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180815',3551478,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180815',3551479,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180815',3551480,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180815',3551481,'1134','162',10100431.16,10103347.55,2906.39,712065.55,0.00,0.00,10.00,0.00,0.00),('1','65','423','180815',3551482,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180815',3551483,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180815',3551484,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180817',3551497,'1122','161',801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180817',3551498,'1123','161',469676.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180817',3551499,'1124','161',166765.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180817',3551500,'1125','161',243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180817',3551501,'1126','161',579443.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180817',3551502,'1127','161',406982.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180817',3551503,'1128','161',78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180817',3551504,'1129','161',207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180817',3551505,'1130','161',721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180817',3551506,'1131','161',111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180817',3551507,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180817',3551508,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180817',3551509,'1134','162',10103347.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180817',3551510,'1135','162',511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180817',3551511,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180817',3551512,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180822',3551564,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180822',3551565,'1123','161',469676.87,470109.36,432.49,72225.83,0.00,0.00,0.00,0.00,0.00),('1','65','420','180822',3551566,'1124','161',166765.56,167099.79,334.23,55816.41,0.00,0.00,0.00,0.00,0.00),('1','65','420','180822',3551567,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180822',3551568,'1126','161',579443.23,579443.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','180822',3551569,'1127','161',406982.01,406982.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180822',3551570,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180822',3551571,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180822',3551572,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180822',3551573,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180822',3551574,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','180822',3551575,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','180822',3551576,'1134','162',10103347.55,10103764.42,416.87,104217.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','180822',3551577,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180822',3551578,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','180822',3551579,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181800',3569799,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181800',3569800,'1123','161',470109.36,471408.51,1299.15,216958.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','181800',3569801,'1124','161',167099.79,167099.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181800',3569802,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181800',3569803,'1126','161',579443.23,580055.08,601.85,100508.95,0.00,0.00,10.00,0.00,0.00),('1','65','420','181800',3569804,'1127','161',406982.01,407368.00,375.99,62790.33,0.00,0.00,10.00,0.00,0.00),('1','65','421','181800',3569805,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181800',3569806,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181800',3569807,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181800',3569808,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181800',3569809,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181800',3569810,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181800',3569811,'1134','162',10103764.42,10104950.26,1175.84,293960.00,0.00,0.00,10.00,0.00,0.00),('1','65','423','181800',3569812,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181800',3569813,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181800',3569814,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181803',3569839,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181803',3569840,'1123','161',471408.51,472678.16,1269.65,212031.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','181803',3569841,'1124','161',167099.79,167105.78,5.99,1000.33,0.00,0.00,0.00,0.00,0.00),('1','65','420','181803',3569842,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181803',3569843,'1126','161',580055.08,580161.32,106.24,17742.08,0.00,0.00,0.00,0.00,0.00),('1','65','420','181803',3569844,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181803',3569845,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181803',3569846,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181803',3569847,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181803',3569848,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181803',3569849,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181803',3569850,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181803',3569851,'1134','162',10104950.26,10106001.19,1050.93,262732.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','181803',3569852,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181803',3569853,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181803',3569854,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181804',3569855,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181804',3569856,'1123','161',472678.16,473276.65,598.49,99947.83,0.00,0.00,0.00,0.00,0.00),('1','65','420','181804',3569857,'1124','161',167105.78,167105.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181804',3569858,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181804',3569859,'1126','161',580161.32,580699.52,538.20,89879.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','181804',3569860,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181804',3569861,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181804',3569862,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181804',3569863,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181804',3569864,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181804',3569865,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181804',3569866,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181804',3569867,'1134','162',10106001.19,10107764.80,1763.61,440902.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','181804',3569868,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181804',3569869,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181804',3569870,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181828',3570256,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181828',3570257,'1123','161',473276.65,474070.67,794.02,132601.34,0.00,0.00,0.00,0.00,0.00),('1','65','420','181828',3570258,'1124','161',167105.78,167642.46,536.68,89625.56,0.00,0.00,0.00,0.00,0.00),('1','65','420','181828',3570259,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181828',3570260,'1126','161',580699.52,580699.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181828',3570261,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181828',3570262,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181828',3570263,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181828',3570264,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181828',3570265,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181828',3570266,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181828',3570267,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181828',3570268,'1134','162',10107764.80,10108152.22,387.42,96855.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181828',3570269,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181828',3570270,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181828',3570271,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181831',3570342,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181831',3570343,'1123','161',474070.67,475193.38,1122.71,187492.57,0.00,0.00,0.00,0.00,0.00),('1','65','420','181831',3570344,'1124','161',167642.46,167642.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181831',3570345,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181831',3570346,'1126','161',580699.52,581277.19,577.67,96470.89,0.00,0.00,0.00,0.00,0.00),('1','65','420','181831',3570347,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181831',3570348,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181831',3570349,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181831',3570350,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181831',3570351,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181831',3570352,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181831',3570353,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181831',3570354,'1134','162',10108152.22,10109180.67,1028.45,262254.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','181831',3570355,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181831',3570356,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181831',3570357,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181833',3570372,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181833',3570373,'1123','161',475193.38,475939.33,745.95,124573.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','181833',3570374,'1124','161',167642.46,167642.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181833',3570375,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181833',3570376,'1126','161',581277.19,581891.26,614.07,102549.69,0.00,0.00,0.00,0.00,0.00),('1','65','420','181833',3570377,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181833',3570378,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181833',3570379,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181833',3570380,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181833',3570381,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181833',3570382,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181833',3570383,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181833',3570384,'1134','162',10109180.67,10109459.18,278.51,71020.05,0.00,0.00,0.00,0.00,0.00),('1','65','423','181833',3570385,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181833',3570386,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181833',3570387,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181836',3570419,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181836',3570420,'1123','161',475939.33,476367.36,428.03,71481.01,0.00,0.00,0.00,0.00,0.00),('1','65','420','181836',3570421,'1124','161',167642.46,167776.61,134.15,22403.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','181836',3570422,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181836',3570423,'1126','161',581891.26,581939.16,47.90,7999.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','181836',3570424,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181836',3570425,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181836',3570426,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181836',3570427,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181836',3570428,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181836',3570429,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181836',3570430,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181836',3570431,'1134','162',10109459.18,10110128.91,669.73,170781.15,0.00,0.00,0.00,0.00,0.00),('1','65','423','181836',3570432,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181836',3570433,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181836',3570434,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181838',3570451,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181838',3570452,'1123','161',476367.36,476691.62,324.26,54151.42,0.00,0.00,0.00,0.00,0.00),('1','65','420','181838',3570453,'1124','161',167776.61,168548.44,771.83,128895.61,0.00,0.00,0.00,0.00,0.00),('1','65','420','181838',3570454,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181838',3570455,'1126','161',581939.16,581939.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181838',3570456,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181838',3570457,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181838',3570458,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181838',3570459,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181838',3570460,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181838',3570461,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181838',3570462,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181838',3570463,'1134','162',10110128.91,10110664.63,535.72,136608.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','181838',3570464,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181838',3570465,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181838',3570466,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181841',3570498,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181841',3570499,'1123','161',476691.62,478446.83,1745.21,291450.07,0.00,0.00,10.00,0.00,0.00),('1','65','420','181841',3570500,'1124','161',168548.44,169742.90,1184.46,197804.82,0.00,0.00,10.00,0.00,0.00),('1','65','420','181841',3570501,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181841',3570502,'1126','161',581939.16,582811.64,852.48,142364.16,0.00,0.00,20.00,0.00,0.00),('1','65','420','181841',3570503,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181841',3570504,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181841',3570505,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181841',3570506,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181841',3570507,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181841',3570508,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181841',3570509,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181841',3570510,'1134','162',10110664.63,10111584.44,909.81,232001.55,0.00,0.00,10.00,0.00,0.00),('1','65','423','181841',3570511,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181841',3570512,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181841',3570513,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181845',3570550,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181845',3570551,'1123','161',478446.83,478446.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181845',3570552,'1124','161',169742.90,169742.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181845',3570553,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181845',3570554,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181845',3570555,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181845',3570556,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181845',3570557,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181845',3570558,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181845',3570559,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181845',3570560,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181845',3570561,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181845',3570562,'1134','162',10111584.44,10111763.64,179.20,45696.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181845',3570563,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181845',3570564,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181845',3570565,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181848',3570577,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181848',3570578,'1123','161',478446.83,478446.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181848',3570579,'1124','161',169742.90,169742.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181848',3570580,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181848',3570581,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181848',3570582,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181848',3570583,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181848',3570584,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181848',3570585,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181848',3570586,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181848',3570587,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181848',3570588,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181848',3570589,'1134','162',10111763.64,10112908.08,1144.44,291832.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','181848',3570590,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181848',3570591,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181848',3570592,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181959',3572540,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181959',3572541,'1123','161',478446.83,478446.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181959',3572542,'1124','161',169742.90,169742.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181959',3572543,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181959',3572544,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','181959',3572545,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181959',3572546,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181959',3572547,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181959',3572548,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181959',3572549,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181959',3572550,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','181959',3572551,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','181959',3572552,'1134','162',10112908.08,10114151.81,1243.73,317151.15,0.00,0.00,0.00,0.00,0.00),('1','65','423','181959',3572553,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181959',3572554,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','181959',3572555,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182242',3577845,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182242',3577846,'1123','161',478446.83,478446.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182242',3577847,'1124','161',169742.90,169742.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182242',3577848,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182242',3577849,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182242',3577850,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182242',3577851,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182242',3577852,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182242',3577853,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182242',3577854,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182242',3577855,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182242',3577856,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','182242',3577857,'1134','162',10114151.81,10115402.05,1250.24,318811.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','182242',3577858,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','182242',3577859,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','182242',3577860,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182244',3577883,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182244',3577884,'1123','161',478446.83,478446.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182244',3577885,'1124','161',169742.90,169742.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182244',3577886,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182244',3577887,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182244',3577888,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182244',3577889,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182244',3577890,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182244',3577891,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182244',3577892,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182244',3577893,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182244',3577894,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','182244',3577895,'1134','162',10115402.05,10116739.67,1337.62,341093.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','182244',3577896,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','182244',3577897,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','182244',3577898,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182246',3577900,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182246',3577901,'1123','161',478446.83,478446.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182246',3577902,'1124','161',169742.90,169742.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182246',3577903,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182246',3577904,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','182246',3577905,'1127','161',407368.00,407368.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182246',3577906,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182246',3577907,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182246',3577908,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182246',3577909,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182246',3577910,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','182246',3577911,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','182246',3577912,'1134','162',10116739.67,10117746.14,1006.47,256649.85,0.00,0.00,0.00,0.00,0.00),('1','65','423','182246',3577913,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','182246',3577914,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','182246',3577915,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183058',3592854,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183058',3592855,'1123','161',478446.83,478639.38,192.55,32155.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','183058',3592856,'1124','161',169742.90,169742.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183058',3592857,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183058',3592858,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183058',3592859,'1127','161',407368.00,407847.48,479.48,80073.16,0.00,0.00,0.00,0.00,0.00),('1','65','421','183058',3592860,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183058',3592861,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183058',3592862,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183058',3592863,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183058',3592864,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183058',3592865,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183058',3592866,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183058',3592867,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183058',3592868,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183058',3592869,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183060',3592889,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183060',3592890,'1123','161',478639.38,479145.24,495.86,82808.62,0.00,0.00,10.00,0.00,0.00),('1','65','420','183060',3592891,'1124','161',169742.90,170168.95,406.05,67810.35,0.00,0.00,20.00,0.00,0.00),('1','65','420','183060',3592892,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183060',3592893,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183060',3592894,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183060',3592895,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183060',3592896,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183060',3592897,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183060',3592898,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183060',3592899,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183060',3592900,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183060',3592901,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183060',3592902,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183060',3592903,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183060',3592904,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183177',3594919,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183177',3594920,'1123','161',479145.24,479958.46,813.22,135807.74,0.00,0.00,0.00,0.00,0.00),('1','65','420','183177',3594921,'1124','161',170168.95,170168.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183177',3594922,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183177',3594923,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183177',3594924,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183177',3594925,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183177',3594926,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183177',3594927,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183177',3594928,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183177',3594929,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183177',3594930,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183177',3594931,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183177',3594932,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183177',3594933,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183177',3594934,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183292',3596763,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183292',3596764,'1123','161',479958.46,480414.87,456.41,76220.47,0.00,0.00,0.00,0.00,0.00),('1','65','420','183292',3596765,'1124','161',170168.95,170493.37,324.42,54178.14,0.00,0.00,0.00,0.00,0.00),('1','65','420','183292',3596766,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183292',3596767,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183292',3596768,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183292',3596769,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183292',3596770,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183292',3596771,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183292',3596772,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183292',3596773,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183292',3596774,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183292',3596775,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183292',3596776,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183292',3596777,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183292',3596778,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183514',3600762,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183514',3600763,'1123','161',480414.87,481210.59,795.72,132885.24,0.00,0.00,0.00,0.00,0.00),('1','65','420','183514',3600764,'1124','161',170493.37,170493.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183514',3600765,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183514',3600766,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183514',3600767,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183514',3600768,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183514',3600769,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183514',3600770,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183514',3600771,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183514',3600772,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183514',3600773,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183514',3600774,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183514',3600775,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183514',3600776,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183514',3600777,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183515',3600778,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183515',3600779,'1123','161',481210.59,481210.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183515',3600780,'1124','161',170493.37,171262.70,769.33,128478.11,0.00,0.00,0.00,0.00,0.00),('1','65','420','183515',3600781,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183515',3600782,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183515',3600783,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183515',3600784,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183515',3600785,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183515',3600786,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183515',3600787,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183515',3600788,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183515',3600789,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183515',3600790,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183515',3600791,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183515',3600792,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183515',3600793,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183677',3603811,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183677',3603812,'1123','161',481210.59,482174.23,963.64,160927.88,0.00,0.00,0.00,0.00,0.00),('1','65','420','183677',3603813,'1124','161',171262.70,171262.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183677',3603814,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183677',3603815,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183677',3603816,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183677',3603817,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183677',3603818,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183677',3603819,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183677',3603820,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183677',3603821,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183677',3603822,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183677',3603823,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183677',3603824,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183677',3603825,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183677',3603826,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183735',3604938,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183735',3604939,'1123','161',482174.23,482174.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183735',3604940,'1124','161',171262.70,171262.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183735',3604941,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183735',3604942,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183735',3604943,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183735',3604944,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183735',3604945,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183735',3604946,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183735',3604947,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183735',3604948,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183735',3604949,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183735',3604950,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183735',3604951,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183735',3604952,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183735',3604953,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183739',3605034,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183739',3605035,'1123','161',482174.23,483548.99,1374.76,229584.92,0.00,0.00,0.00,0.00,0.00),('1','65','420','183739',3605036,'1124','161',171262.70,172387.44,1124.74,187831.58,0.00,0.00,0.00,0.00,0.00),('1','65','420','183739',3605037,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183739',3605038,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183739',3605039,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183739',3605040,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183739',3605041,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183739',3605042,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183739',3605043,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183739',3605044,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183739',3605045,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183739',3605046,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183739',3605047,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183739',3605048,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183739',3605049,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183740',3605050,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183740',3605051,'1123','161',483548.99,484683.66,1114.67,186149.89,0.00,0.00,20.00,0.00,0.00),('1','65','420','183740',3605052,'1124','161',172387.44,172387.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183740',3605053,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183740',3605054,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183740',3605055,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183740',3605056,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183740',3605057,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183740',3605058,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183740',3605059,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183740',3605060,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183740',3605061,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183740',3605062,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183740',3605063,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183740',3605064,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183740',3605065,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183889',3607884,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183889',3607885,'1123','161',484683.66,485894.83,1211.17,202265.39,0.00,0.00,0.00,0.00,0.00),('1','65','420','183889',3607886,'1124','161',172387.44,172394.63,7.19,1200.73,0.00,0.00,0.00,0.00,0.00),('1','65','420','183889',3607887,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183889',3607888,'1126','161',582811.64,582811.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183889',3607889,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183889',3607890,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183889',3607891,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183889',3607892,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183889',3607893,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183889',3607894,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183889',3607895,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183889',3607896,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183889',3607897,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183889',3607898,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183889',3607899,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183893',3607947,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183893',3607948,'1123','161',485894.83,485894.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183893',3607949,'1124','161',172394.63,172423.97,29.34,4899.78,0.00,0.00,0.00,0.00,0.00),('1','65','420','183893',3607950,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','183893',3607951,'1126','161',582811.64,584181.71,1360.07,227131.69,0.00,0.00,10.00,0.00,0.00),('1','65','420','183893',3607952,'1127','161',407847.48,407847.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183893',3607953,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183893',3607954,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183893',3607955,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183893',3607956,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183893',3607957,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','183893',3607958,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183893',3607959,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','183893',3607960,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183893',3607961,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','183893',3607962,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184001',3609823,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184001',3609824,'1123','161',485894.83,487193.00,1298.17,216794.39,0.00,0.00,0.00,0.00,0.00),('1','65','420','184001',3609825,'1124','161',172423.97,172423.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184001',3609826,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184001',3609827,'1126','161',584181.71,584181.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184001',3609828,'1127','161',407847.48,407916.32,68.84,11496.28,0.00,0.00,0.00,0.00,0.00),('1','65','421','184001',3609829,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184001',3609830,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184001',3609831,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184001',3609832,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184001',3609833,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184001',3609834,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184001',3609835,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184001',3609836,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184001',3609837,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184001',3609838,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184151',3612432,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184151',3612433,'1123','161',487193.00,487482.45,289.45,48338.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','184151',3612434,'1124','161',172423.97,173040.27,596.30,99582.10,0.00,0.00,20.00,0.00,0.00),('1','65','420','184151',3612435,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184151',3612436,'1126','161',584181.71,584659.71,478.00,79826.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184151',3612437,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184151',3612438,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184151',3612439,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184151',3612440,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184151',3612441,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184151',3612442,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184151',3612443,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184151',3612444,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184151',3612445,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184151',3612446,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184151',3612447,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184260',3614498,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184260',3614499,'1123','161',487482.45,488506.15,1023.70,170957.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','184260',3614500,'1124','161',173040.27,173040.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184260',3614501,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184260',3614502,'1126','161',584659.71,584659.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184260',3614503,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184260',3614504,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184260',3614505,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184260',3614506,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184260',3614507,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184260',3614508,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184260',3614509,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184260',3614510,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184260',3614511,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184260',3614512,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184260',3614513,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184434',3617543,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184434',3617544,'1123','161',488506.15,489877.35,1371.20,233104.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184434',3617545,'1124','161',173040.27,173040.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184434',3617546,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184434',3617547,'1126','161',584659.71,584659.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184434',3617548,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184434',3617549,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184434',3617550,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184434',3617551,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184434',3617552,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184434',3617553,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184434',3617554,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184434',3617555,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184434',3617556,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184434',3617557,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184434',3617558,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184452',3617869,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184452',3617870,'1123','161',489877.35,490485.04,607.69,103307.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','184452',3617871,'1124','161',173040.27,173985.73,945.46,160728.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','184452',3617872,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184452',3617873,'1126','161',584659.71,584675.60,15.89,2701.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','184452',3617874,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184452',3617875,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184452',3617876,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184452',3617877,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184452',3617878,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184452',3617879,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184452',3617880,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184452',3617881,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184452',3617882,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184452',3617883,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184452',3617884,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184705',3622363,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184705',3622364,'1123','161',490485.04,490615.18,130.14,22123.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','184705',3622365,'1124','161',173985.73,173985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184705',3622366,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','184705',3622367,'1126','161',584675.60,585439.43,763.83,129851.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','184705',3622368,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184705',3622369,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184705',3622370,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184705',3622371,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184705',3622372,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184705',3622373,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','184705',3622374,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184705',3622375,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','184705',3622376,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184705',3622377,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','184705',3622378,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185964',3644691,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185964',3644692,'1123','161',490615.18,491302.81,687.63,116897.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','185964',3644693,'1124','161',173985.73,173985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185964',3644694,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185964',3644695,'1126','161',585439.43,585493.36,53.93,9168.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','185964',3644696,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185964',3644697,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185964',3644698,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185964',3644699,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185964',3644700,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185964',3644701,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185964',3644702,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','185964',3644703,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','185964',3644704,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','185964',3644705,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','185964',3644706,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185965',3644707,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185965',3644708,'1123','161',491302.81,491502.99,200.18,34030.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','185965',3644709,'1124','161',173985.73,173985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185965',3644710,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185965',3644711,'1126','161',585493.36,585627.56,134.20,22814.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185965',3644712,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185965',3644713,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185965',3644714,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185965',3644715,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185965',3644716,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185965',3644717,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185965',3644718,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','185965',3644719,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','185965',3644720,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','185965',3644721,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','185965',3644722,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185967',3644745,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185967',3644746,'1123','161',491502.99,492788.60,1285.61,212125.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','185967',3644747,'1124','161',173985.73,173985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185967',3644748,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','185967',3644749,'1126','161',585627.56,585877.22,249.66,41193.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','185967',3644750,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185967',3644751,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185967',3644752,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185967',3644753,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185967',3644754,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185967',3644755,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','185967',3644756,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','185967',3644757,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','185967',3644758,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','185967',3644759,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','185967',3644760,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186111',3647259,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186111',3647260,'1123','161',492788.60,493444.43,655.83,108211.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','186111',3647261,'1124','161',173985.73,173985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186111',3647262,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186111',3647263,'1126','161',585877.22,586545.03,667.81,110188.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','186111',3647264,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186111',3647265,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186111',3647266,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186111',3647267,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186111',3647268,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186111',3647269,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186111',3647270,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186111',3647271,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186111',3647272,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186111',3647273,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186111',3647274,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186116',3647335,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186116',3647336,'1123','161',493444.43,494250.73,786.30,129739.50,0.00,0.00,20.00,0.00,0.00),('1','65','420','186116',3647337,'1124','161',173985.73,173985.73,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','186116',3647338,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186116',3647339,'1126','161',586545.03,586742.90,197.87,32648.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','186116',3647340,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186116',3647341,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186116',3647342,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186116',3647343,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186116',3647344,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186116',3647345,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186116',3647346,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186116',3647347,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186116',3647348,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186116',3647349,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186116',3647350,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186132',3647553,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186132',3647554,'1123','161',494250.73,495270.63,1019.90,168283.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','186132',3647555,'1124','161',173985.73,173985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186132',3647556,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186132',3647557,'1126','161',586742.90,586767.68,24.78,4088.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','186132',3647558,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186132',3647559,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186132',3647560,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186132',3647561,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186132',3647562,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186132',3647563,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186132',3647564,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186132',3647565,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186132',3647566,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186132',3647567,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186132',3647568,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186324',3650749,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186324',3650750,'1123','161',495270.63,496200.34,929.71,153402.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','186324',3650751,'1124','161',173985.73,173985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186324',3650752,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186324',3650753,'1126','161',586767.68,586767.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186324',3650754,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186324',3650755,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186324',3650756,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186324',3650757,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186324',3650758,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186324',3650759,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186324',3650760,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186324',3650761,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186324',3650762,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186324',3650763,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186324',3650764,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186338',3650968,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186338',3650969,'1123','161',496200.34,496843.50,643.16,106121.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','186338',3650970,'1124','161',173985.73,173985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186338',3650971,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186338',3650972,'1126','161',586767.68,587355.75,588.07,97031.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','186338',3650973,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186338',3650974,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186338',3650975,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186338',3650976,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186338',3650977,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186338',3650978,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186338',3650979,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186338',3650980,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186338',3650981,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186338',3650982,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186338',3650983,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186343',3651033,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186343',3651034,'1123','161',496843.50,496843.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186343',3651035,'1124','161',173985.73,174011.80,26.07,4301.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','186343',3651036,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186343',3651037,'1126','161',587355.75,588156.63,800.88,132145.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','186343',3651038,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186343',3651039,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186343',3651040,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186343',3651041,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186343',3651042,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186343',3651043,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186343',3651044,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186343',3651045,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186343',3651046,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186343',3651047,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186343',3651048,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186530',3654358,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186530',3654359,'1123','161',496843.50,497481.61,638.11,105288.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','186530',3654360,'1124','161',174011.80,174011.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186530',3654361,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186530',3654362,'1126','161',588156.63,588707.31,550.68,90862.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','186530',3654363,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186530',3654364,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186530',3654365,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186530',3654366,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186530',3654367,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186530',3654368,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186530',3654369,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186530',3654370,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186530',3654371,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186530',3654372,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186530',3654373,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186641',3656318,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186641',3656319,'1123','161',497481.61,499135.89,1644.28,271306.20,0.00,0.00,10.00,0.00,0.00),('1','65','420','186641',3656320,'1124','161',174011.80,174011.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186641',3656321,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186641',3656322,'1126','161',588707.31,589582.01,854.70,141025.50,0.00,0.00,20.00,0.00,0.00),('1','65','420','186641',3656323,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186641',3656324,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186641',3656325,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186641',3656326,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186641',3656327,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186641',3656328,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186641',3656329,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186641',3656330,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186641',3656331,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186641',3656332,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186641',3656333,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186714',3657560,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186714',3657561,'1123','161',499135.89,499790.69,654.80,108042.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186714',3657562,'1124','161',174011.80,174310.65,298.85,49310.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','186714',3657563,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186714',3657564,'1126','161',589582.01,589678.63,96.62,15942.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','186714',3657565,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186714',3657566,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186714',3657567,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186714',3657568,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186714',3657569,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186714',3657570,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186714',3657571,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186714',3657572,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186714',3657573,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186714',3657574,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186714',3657575,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186740',3658032,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186740',3658033,'1123','161',499790.69,500713.71,923.02,152298.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','186740',3658034,'1124','161',174310.65,174310.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186740',3658035,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186740',3658036,'1126','161',589678.63,589941.07,262.44,43302.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','186740',3658037,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186740',3658038,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186740',3658039,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186740',3658040,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186740',3658041,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186740',3658042,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186740',3658043,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186740',3658044,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186740',3658045,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186740',3658046,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186740',3658047,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186948',3661500,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186948',3661501,'1123','161',500713.71,501701.39,987.68,162967.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','186948',3661502,'1124','161',174310.65,174310.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186948',3661503,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186948',3661504,'1126','161',589941.07,590240.10,299.03,49339.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','186948',3661505,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186948',3661506,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186948',3661507,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186948',3661508,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186948',3661509,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186948',3661510,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186948',3661511,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186948',3661512,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186948',3661513,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186948',3661514,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186948',3661515,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186975',3661845,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186975',3661846,'1123','161',501701.39,501701.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186975',3661847,'1124','161',174310.65,175036.67,726.02,119793.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','186975',3661848,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','186975',3661849,'1126','161',590240.10,590731.02,490.92,81001.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','186975',3661850,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186975',3661851,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186975',3661852,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186975',3661853,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186975',3661854,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186975',3661855,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','186975',3661856,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186975',3661857,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','186975',3661858,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186975',3661859,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','186975',3661860,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187078',3663546,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187078',3663547,'1123','161',501701.39,502322.41,621.02,102468.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','187078',3663548,'1124','161',175036.67,175036.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187078',3663549,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187078',3663550,'1126','161',590731.02,591254.41,523.39,86359.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','187078',3663551,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187078',3663552,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187078',3663553,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187078',3663554,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187078',3663555,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187078',3663556,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187078',3663557,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187078',3663558,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187078',3663559,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187078',3663560,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187078',3663561,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187156',3664992,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187156',3664993,'1123','161',502322.41,502322.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187156',3664994,'1124','161',175036.67,175753.93,717.26,118347.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','187156',3664995,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187156',3664996,'1126','161',591254.41,591822.99,568.58,93815.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','187156',3664997,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187156',3664998,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187156',3664999,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187156',3665000,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187156',3665001,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187156',3665002,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187156',3665003,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187156',3665004,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187156',3665005,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187156',3665006,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187156',3665007,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187492',3671016,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187492',3671017,'1123','161',502322.41,503322.67,1000.26,165042.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','187492',3671018,'1124','161',175753.93,175753.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187492',3671019,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187492',3671020,'1126','161',591822.99,591822.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187492',3671021,'1127','161',407916.32,407916.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187492',3671022,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187492',3671023,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187492',3671024,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187492',3671025,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187492',3671026,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187492',3671027,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187492',3671028,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187492',3671029,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187492',3671030,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187492',3671031,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187494',3671064,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187494',3671065,'1123','161',503322.67,504267.65,944.98,155921.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','187494',3671066,'1124','161',175753.93,175759.08,5.15,849.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','187494',3671067,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187494',3671068,'1126','161',591822.99,591822.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187494',3671069,'1127','161',407916.32,408313.10,396.78,65468.70,0.00,0.00,0.00,0.00,0.00),('1','65','421','187494',3671070,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187494',3671071,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187494',3671072,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187494',3671073,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187494',3671074,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187494',3671075,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187494',3671076,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187494',3671077,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187494',3671078,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187494',3671079,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187566',3672323,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187566',3672324,'1123','161',504267.65,504981.92,714.27,117854.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','187566',3672325,'1124','161',175759.08,175759.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187566',3672326,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187566',3672327,'1126','161',591822.99,591822.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187566',3672328,'1127','161',408313.10,408821.88,508.78,83948.70,0.00,0.00,0.00,0.00,0.00),('1','65','421','187566',3672329,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187566',3672330,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187566',3672331,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187566',3672332,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187566',3672333,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187566',3672334,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187566',3672335,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187566',3672336,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187566',3672337,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187566',3672338,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187651',3673729,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187651',3673730,'1123','161',504981.92,505538.27,556.35,91797.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','187651',3673731,'1124','161',175759.08,175759.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187651',3673732,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187651',3673733,'1126','161',591822.99,592098.99,276.00,45540.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187651',3673734,'1127','161',408821.88,408821.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187651',3673735,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187651',3673736,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187651',3673737,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187651',3673738,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187651',3673739,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187651',3673740,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187651',3673741,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187651',3673742,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187651',3673743,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187651',3673744,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187785',3676275,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187785',3676276,'1123','161',505538.27,506311.18,772.91,127530.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','187785',3676277,'1124','161',175759.08,175962.20,203.12,33514.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','187785',3676278,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187785',3676279,'1126','161',592098.99,592098.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187785',3676280,'1127','161',408821.88,408821.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187785',3676281,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187785',3676282,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187785',3676283,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187785',3676284,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187785',3676285,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187785',3676286,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187785',3676287,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187785',3676288,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187785',3676289,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187785',3676290,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187906',3678306,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187906',3678307,'1123','161',506311.18,507157.89,846.71,139707.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','187906',3678308,'1124','161',175962.20,175962.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187906',3678309,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187906',3678310,'1126','161',592098.99,592098.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','187906',3678311,'1127','161',408821.88,409208.11,386.23,63727.95,0.00,0.00,0.00,0.00,0.00),('1','65','421','187906',3678312,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187906',3678313,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187906',3678314,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187906',3678315,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187906',3678316,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','187906',3678317,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187906',3678318,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','187906',3678319,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187906',3678320,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','187906',3678321,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188035',3680458,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188035',3680459,'1123','161',507157.89,507157.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188035',3680460,'1124','161',175962.20,175962.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188035',3680461,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188035',3680462,'1126','161',592098.99,592098.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188035',3680463,'1127','161',409208.11,409208.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188035',3680464,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188035',3680465,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188035',3680466,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188035',3680467,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188035',3680468,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188035',3680469,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','188035',3680470,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','188035',3680471,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','188035',3680472,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','188035',3680473,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188047',3680610,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188047',3680611,'1123','161',507157.89,508653.45,1475.56,243467.40,0.00,0.00,20.00,0.00,0.00),('1','65','420','188047',3680612,'1124','161',175962.20,176461.56,489.36,80744.40,0.00,0.00,10.00,0.00,0.00),('1','65','420','188047',3680613,'1125','161',243412.79,243412.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','188047',3680614,'1126','161',592098.99,592716.68,607.69,100268.85,0.00,0.00,10.00,0.00,0.00),('1','65','420','188047',3680615,'1127','161',409208.11,409208.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188047',3680616,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188047',3680617,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188047',3680618,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188047',3680619,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188047',3680620,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','188047',3680621,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','188047',3680622,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','188047',3680623,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','188047',3680624,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','188047',3680625,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189383',3704564,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189383',3704565,'1123','161',508653.45,509179.33,505.88,83470.20,0.00,0.00,20.00,0.00,0.00),('1','65','420','189383',3704566,'1124','161',176461.56,176461.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189383',3704567,'1125','161',243412.79,243767.73,334.94,55265.10,0.00,0.00,20.00,0.00,0.00),('1','65','420','189383',3704568,'1126','161',592716.68,592716.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189383',3704569,'1127','161',409208.11,409208.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189383',3704570,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189383',3704571,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189383',3704572,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189383',3704573,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189383',3704574,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189383',3704575,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189383',3704576,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189383',3704577,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189383',3704578,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189383',3704579,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189386',3704609,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189386',3704610,'1123','161',509179.33,509179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189386',3704611,'1124','161',176461.56,177337.08,875.52,144460.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','189386',3704612,'1125','161',243767.73,243767.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189386',3704613,'1126','161',592716.68,594219.33,1502.65,247937.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','189386',3704614,'1127','161',409208.11,409208.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189386',3704615,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189386',3704616,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189386',3704617,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189386',3704618,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189386',3704619,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189386',3704620,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189386',3704621,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189386',3704622,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189386',3704623,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189386',3704624,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189536',3706958,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189536',3706959,'1123','161',509179.33,509179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189536',3706960,'1124','161',177337.08,177726.46,389.38,64247.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','189536',3706961,'1125','161',243767.73,244060.32,292.59,48277.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','189536',3706962,'1126','161',594219.33,594219.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189536',3706963,'1127','161',409208.11,409713.45,505.34,83381.10,0.00,0.00,0.00,0.00,0.00),('1','65','421','189536',3706964,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189536',3706965,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189536',3706966,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189536',3706967,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189536',3706968,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189536',3706969,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189536',3706970,'1134','162',10117746.14,10117746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189536',3706971,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189536',3706972,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189536',3706973,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189606',3708367,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189606',3708368,'1123','161',509179.33,509179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189606',3708369,'1124','161',177726.46,178131.64,405.18,66854.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','189606',3708370,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189606',3708371,'1126','161',594219.33,594630.01,410.68,67762.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','189606',3708372,'1127','161',409713.45,409713.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189606',3708373,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189606',3708374,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189606',3708375,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189606',3708376,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189606',3708377,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189606',3708378,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189606',3708379,'1134','162',10117746.14,10117781.99,35.85,9679.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','189606',3708380,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189606',3708381,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189606',3708382,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189747',3710619,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189747',3710620,'1123','161',509179.33,509179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189747',3710621,'1124','161',178131.64,178996.01,864.37,142621.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','189747',3710622,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189747',3710623,'1126','161',594630.01,594630.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189747',3710624,'1127','161',409713.45,410128.02,414.57,68404.05,0.00,0.00,0.00,0.00,0.00),('1','65','421','189747',3710625,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189747',3710626,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189747',3710627,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189747',3710628,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189747',3710629,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189747',3710630,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189747',3710631,'1134','162',10117781.99,10117937.06,155.07,41868.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','189747',3710632,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189747',3710633,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189747',3710634,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189872',3712752,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189872',3712753,'1123','161',509179.33,509189.33,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','189872',3712754,'1124','161',178996.01,179803.52,797.51,131589.15,0.00,0.00,10.00,0.00,0.00),('1','65','420','189872',3712755,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189872',3712756,'1126','161',594630.01,595153.66,523.65,86402.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','189872',3712757,'1127','161',410128.02,410128.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189872',3712758,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189872',3712759,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189872',3712760,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189872',3712761,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189872',3712762,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189872',3712763,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189872',3712764,'1134','162',10117937.06,10118079.62,122.56,33091.20,0.00,0.00,20.00,0.00,0.00),('1','65','423','189872',3712765,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189872',3712766,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189872',3712767,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189988',3715526,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189988',3715527,'1123','161',509189.33,509313.68,124.35,20517.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','189988',3715528,'1124','161',179803.52,180566.06,762.54,125819.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','189988',3715529,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','189988',3715530,'1126','161',595153.66,595299.03,145.37,23986.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','189988',3715531,'1127','161',410128.02,410128.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189988',3715532,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189988',3715533,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189988',3715534,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189988',3715535,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189988',3715536,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','189988',3715537,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','189988',3715538,'1134','162',10118079.62,10118703.20,623.58,168366.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','189988',3715539,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189988',3715540,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','189988',3715541,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190186',3719367,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190186',3719368,'1123','161',509313.68,509449.04,135.36,22334.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','190186',3719369,'1124','161',180566.06,181045.55,479.49,79115.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','190186',3719370,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190186',3719371,'1126','161',595299.03,595299.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190186',3719372,'1127','161',410128.02,410606.71,478.69,78983.85,0.00,0.00,0.00,0.00,0.00),('1','65','421','190186',3719373,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190186',3719374,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190186',3719375,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190186',3719376,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190186',3719377,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190186',3719378,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190186',3719379,'1134','162',10118703.20,10119556.37,853.17,230355.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','190186',3719380,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190186',3719381,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190186',3719382,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190243',3720116,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190243',3720117,'1123','161',509449.04,509449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190243',3720118,'1124','161',181045.55,181045.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190243',3720119,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190243',3720120,'1126','161',595299.03,596463.69,1164.66,192168.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','190243',3720121,'1127','161',410606.71,410606.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190243',3720122,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190243',3720123,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190243',3720124,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190243',3720125,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190243',3720126,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190243',3720127,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190243',3720128,'1134','162',10119556.37,10121001.55,1445.18,390198.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','190243',3720129,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190243',3720130,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190243',3720131,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190251',3720231,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190251',3720232,'1123','161',509449.04,509449.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190251',3720233,'1124','161',181045.55,181514.91,459.36,75794.40,0.00,0.00,10.00,0.00,0.00),('1','65','420','190251',3720234,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190251',3720235,'1126','161',596463.69,596463.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190251',3720236,'1127','161',410606.71,411630.60,1013.89,167291.85,0.00,0.00,10.00,0.00,0.00),('1','65','421','190251',3720237,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190251',3720238,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190251',3720239,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190251',3720240,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190251',3720241,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190251',3720242,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190251',3720243,'1134','162',10121001.55,10123329.55,2328.00,628560.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190251',3720244,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190251',3720245,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190251',3720246,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190621',3727293,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190621',3727294,'1123','161',509449.04,509648.38,199.34,32891.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','190621',3727295,'1124','161',181514.91,183673.74,2158.83,356206.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','190621',3727296,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190621',3727297,'1126','161',596463.69,598618.47,2154.78,355538.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','190621',3727298,'1127','161',411630.60,411630.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190621',3727299,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190621',3727300,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190621',3727301,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190621',3727302,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190621',3727303,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190621',3727304,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190621',3727305,'1134','162',10123329.55,10124525.65,1196.10,322947.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190621',3727306,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190621',3727307,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190621',3727308,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190630',3727472,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190630',3727473,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190630',3727474,'1124','161',183673.74,186534.74,2861.00,472065.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190630',3727475,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190630',3727476,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190630',3727477,'1127','161',411630.60,411779.47,148.87,24563.55,0.00,0.00,0.00,0.00,0.00),('1','65','421','190630',3727478,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190630',3727479,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190630',3727480,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190630',3727481,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190630',3727482,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190630',3727483,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190630',3727484,'1134','162',10124525.65,10124751.51,225.86,60982.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','190630',3727485,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190630',3727486,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190630',3727487,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190631',3727488,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190631',3727489,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190631',3727490,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190631',3727491,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190631',3727492,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190631',3727493,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190631',3727494,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190631',3727495,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190631',3727496,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190631',3727497,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190631',3727498,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190631',3727499,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190631',3727500,'1134','162',10124751.51,10125215.34,443.83,119834.10,0.00,0.00,20.00,0.00,0.00),('1','65','423','190631',3727501,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190631',3727502,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190631',3727503,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190784',3730286,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190784',3730287,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190784',3730288,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190784',3730289,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190784',3730290,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190784',3730291,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190784',3730292,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190784',3730293,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190784',3730294,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190784',3730295,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190784',3730296,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190784',3730297,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190784',3730298,'1134','162',10125215.34,10126639.87,1424.53,384623.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','190784',3730299,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190784',3730300,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190784',3730301,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190860',3731802,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190860',3731803,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190860',3731804,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190860',3731805,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190860',3731806,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190860',3731807,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190860',3731808,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190860',3731809,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190860',3731810,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190860',3731811,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190860',3731812,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190860',3731813,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190860',3731814,'1134','162',10126639.87,10126957.50,317.63,85760.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','190860',3731815,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190860',3731816,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190860',3731817,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190981',3733656,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190981',3733657,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190981',3733658,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190981',3733659,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190981',3733660,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','190981',3733661,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190981',3733662,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190981',3733663,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190981',3733664,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190981',3733665,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190981',3733666,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','190981',3733667,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','190981',3733668,'1134','162',10126957.50,10128043.78,1086.28,293295.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','190981',3733669,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190981',3733670,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','190981',3733671,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191068',3735397,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191068',3735398,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191068',3735399,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191068',3735400,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191068',3735401,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191068',3735402,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191068',3735403,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191068',3735404,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191068',3735405,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191068',3735406,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191068',3735407,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191068',3735408,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','191068',3735409,'1134','162',10128043.78,10129139.81,1096.03,295928.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','191068',3735410,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191068',3735411,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191068',3735412,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191162',3736842,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191162',3736843,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191162',3736844,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191162',3736845,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191162',3736846,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191162',3736847,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191162',3736848,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191162',3736849,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191162',3736850,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191162',3736851,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191162',3736852,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191162',3736853,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','191162',3736854,'1134','162',10129139.81,10130012.35,872.54,235585.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','191162',3736855,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191162',3736856,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191162',3736857,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191278',3739142,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191278',3739143,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191278',3739144,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191278',3739145,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191278',3739146,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191278',3739147,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191278',3739148,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191278',3739149,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191278',3739150,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191278',3739151,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191278',3739152,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191278',3739153,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','191278',3739154,'1134','162',10130012.35,10131105.64,1093.29,295188.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','191278',3739155,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191278',3739156,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191278',3739157,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191393',3740998,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191393',3740999,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191393',3741000,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191393',3741001,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191393',3741002,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191393',3741003,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191393',3741004,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191393',3741005,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191393',3741006,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191393',3741007,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191393',3741008,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191393',3741009,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','191393',3741010,'1134','162',10131105.64,10131363.45,257.81,69608.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','191393',3741011,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191393',3741012,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191393',3741013,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191488',3742869,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191488',3742870,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191488',3742871,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191488',3742872,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191488',3742873,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191488',3742874,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191488',3742875,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191488',3742876,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191488',3742877,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191488',3742878,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191488',3742879,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191488',3742880,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','191488',3742881,'1134','162',10131363.45,10131852.01,478.56,129211.20,0.00,0.00,10.00,0.00,0.00),('1','65','423','191488',3742882,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191488',3742883,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191488',3742884,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191825',3749348,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191825',3749349,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191825',3749350,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191825',3749351,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191825',3749352,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','191825',3749353,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191825',3749354,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191825',3749355,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191825',3749356,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191825',3749357,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191825',3749358,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','191825',3749359,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','191825',3749360,'1134','162',10131852.01,10131932.47,80.46,21724.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','191825',3749361,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191825',3749362,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','191825',3749363,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192094',3754324,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192094',3754325,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192094',3754326,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192094',3754327,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192094',3754328,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192094',3754329,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192094',3754330,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192094',3754331,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192094',3754332,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192094',3754333,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192094',3754334,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192094',3754335,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192094',3754336,'1134','162',10131932.47,10133432.52,1500.05,405013.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','192094',3754337,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192094',3754338,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192094',3754339,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192098',3754413,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192098',3754414,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192098',3754415,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192098',3754416,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192098',3754417,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192098',3754418,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192098',3754419,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192098',3754420,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192098',3754421,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192098',3754422,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192098',3754423,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192098',3754424,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192098',3754425,'1134','162',10133432.52,10134629.36,1196.84,323146.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','192098',3754426,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192098',3754427,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192098',3754428,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192266',3757580,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192266',3757581,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192266',3757582,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192266',3757583,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192266',3757584,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192266',3757585,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192266',3757586,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192266',3757587,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192266',3757588,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192266',3757589,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192266',3757590,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192266',3757591,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192266',3757592,'1134','162',10134629.36,10136805.12,2175.76,587455.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','192266',3757593,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192266',3757594,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192266',3757595,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192272',3757704,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192272',3757705,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192272',3757706,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192272',3757707,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192272',3757708,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192272',3757709,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192272',3757710,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192272',3757711,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192272',3757712,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192272',3757713,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192272',3757714,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192272',3757715,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192272',3757716,'1134','162',10136805.12,10138418.75,1593.63,430280.10,0.00,0.00,20.00,0.00,0.00),('1','65','423','192272',3757717,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192272',3757718,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192272',3757719,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192645',3764177,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192645',3764178,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192645',3764179,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192645',3764180,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192645',3764181,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192645',3764182,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192645',3764183,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192645',3764184,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192645',3764185,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192645',3764186,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192645',3764187,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192645',3764188,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192645',3764189,'1134','162',10138418.75,10140058.75,1640.00,442800.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192645',3764190,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192645',3764191,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192645',3764192,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192745',3766175,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192745',3766176,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192745',3766177,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192745',3766178,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192745',3766179,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192745',3766180,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192745',3766181,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192745',3766182,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192745',3766183,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192745',3766184,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192745',3766185,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192745',3766186,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192745',3766187,'1134','162',10140058.75,10140427.21,358.46,96784.20,0.00,0.00,10.00,0.00,0.00),('1','65','423','192745',3766188,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192745',3766189,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192745',3766190,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192864',3768238,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192864',3768239,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192864',3768240,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192864',3768241,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192864',3768242,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192864',3768243,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192864',3768244,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192864',3768245,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192864',3768246,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192864',3768247,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192864',3768248,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192864',3768249,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192864',3768250,'1134','162',10140427.21,10140725.91,298.70,80649.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192864',3768251,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192864',3768252,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192864',3768253,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192867',3768278,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192867',3768279,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192867',3768280,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192867',3768281,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192867',3768282,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','192867',3768283,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192867',3768284,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192867',3768285,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192867',3768286,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192867',3768287,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192867',3768288,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','192867',3768289,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','192867',3768290,'1134','162',10140725.91,10141489.46,763.55,206158.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','192867',3768291,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192867',3768292,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','192867',3768293,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193078',3772213,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193078',3772214,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193078',3772215,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193078',3772216,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193078',3772217,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193078',3772218,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193078',3772219,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193078',3772220,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193078',3772221,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193078',3772222,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193078',3772223,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193078',3772224,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193078',3772225,'1134','162',10141489.46,10141570.47,81.01,21872.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','193078',3772226,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193078',3772227,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193078',3772228,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193080',3772263,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193080',3772264,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193080',3772265,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193080',3772266,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193080',3772267,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193080',3772268,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193080',3772269,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193080',3772270,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193080',3772271,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193080',3772272,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193080',3772273,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193080',3772274,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193080',3772275,'1134','162',10141570.47,10141941.46,370.99,100167.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','193080',3772276,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193080',3772277,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193080',3772278,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193085',3772407,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193085',3772408,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193085',3772409,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193085',3772410,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193085',3772411,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193085',3772412,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193085',3772413,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193085',3772414,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193085',3772415,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193085',3772416,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193085',3772417,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193085',3772418,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193085',3772419,'1134','162',10141941.46,10143101.86,1150.40,310608.00,0.00,0.00,10.00,0.00,0.00),('1','65','423','193085',3772420,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193085',3772421,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193085',3772422,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193089',3772503,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193089',3772504,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193089',3772505,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193089',3772506,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193089',3772507,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193089',3772508,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193089',3772509,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193089',3772510,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193089',3772511,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193089',3772512,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193089',3772513,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193089',3772514,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193089',3772515,'1134','162',10143101.86,10144417.57,1315.71,355241.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','193089',3772516,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193089',3772517,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193089',3772518,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193543',3781270,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193543',3781271,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193543',3781272,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193543',3781273,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193543',3781274,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193543',3781275,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193543',3781276,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193543',3781277,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193543',3781278,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193543',3781279,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193543',3781280,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193543',3781281,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193543',3781282,'1134','162',10144417.57,10145663.67,1246.10,336447.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193543',3781283,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193543',3781284,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193543',3781285,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193546',3781331,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193546',3781332,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193546',3781333,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193546',3781334,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193546',3781335,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193546',3781336,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193546',3781337,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193546',3781338,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193546',3781339,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193546',3781340,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193546',3781341,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193546',3781342,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193546',3781343,'1134','162',10145663.67,10145690.48,26.81,7238.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','193546',3781344,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193546',3781345,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193546',3781346,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193549',3781401,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193549',3781402,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193549',3781403,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193549',3781404,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193549',3781405,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193549',3781406,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193549',3781407,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193549',3781408,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193549',3781409,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193549',3781410,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193549',3781411,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193549',3781412,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193549',3781413,'1134','162',10145690.48,10146121.55,431.07,116388.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','193549',3781414,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193549',3781415,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193549',3781416,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193966',3788896,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193966',3788897,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193966',3788898,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193966',3788899,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193966',3788900,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193966',3788901,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193966',3788902,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193966',3788903,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193966',3788904,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193966',3788905,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193966',3788906,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193966',3788907,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193966',3788908,'1134','162',10146121.55,10147649.89,1528.34,412651.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','193966',3788909,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193966',3788910,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193966',3788911,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193992',3789217,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193992',3789218,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193992',3789219,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193992',3789220,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193992',3789221,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','193992',3789222,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193992',3789223,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193992',3789224,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193992',3789225,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193992',3789226,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193992',3789227,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','193992',3789228,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','193992',3789229,'1134','162',10147649.89,10148439.06,789.17,213075.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','193992',3789230,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193992',3789231,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','193992',3789232,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194080',3790903,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194080',3790904,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194080',3790905,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194080',3790906,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194080',3790907,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194080',3790908,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194080',3790909,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194080',3790910,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194080',3790911,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194080',3790912,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194080',3790913,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194080',3790914,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194080',3790915,'1134','162',10148439.06,10148638.88,199.82,53951.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','194080',3790916,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194080',3790917,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194080',3790918,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194100',3791078,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194100',3791079,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194100',3791080,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194100',3791081,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194100',3791082,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194100',3791083,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194100',3791084,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194100',3791085,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194100',3791086,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194100',3791087,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194100',3791088,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194100',3791089,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194100',3791090,'1134','162',10148638.88,10149666.21,1027.33,277379.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','194100',3791091,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194100',3791092,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194100',3791093,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194214',3793332,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194214',3793333,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194214',3793334,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194214',3793335,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194214',3793336,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194214',3793337,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194214',3793338,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194214',3793339,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194214',3793340,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194214',3793341,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194214',3793342,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194214',3793343,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194214',3793344,'1134','162',10149666.21,10149714.99,48.78,13170.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','194214',3793345,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194214',3793346,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194214',3793347,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194383',3796375,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194383',3796376,'1123','161',509648.38,509648.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194383',3796377,'1124','161',186534.74,186534.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194383',3796378,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194383',3796379,'1126','161',598618.47,598618.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194383',3796380,'1127','161',411779.47,411779.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194383',3796381,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194383',3796382,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194383',3796383,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194383',3796384,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194383',3796385,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194383',3796386,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194383',3796387,'1134','162',10149714.99,10150086.92,371.93,100421.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','194383',3796388,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194383',3796389,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194383',3796390,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194540',3799108,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194540',3799109,'1123','161',509648.38,509981.14,322.11,53148.15,0.00,0.00,10.65,0.00,0.00),('1','65','420','194540',3799110,'1124','161',186534.74,186822.58,277.84,45843.60,0.00,0.00,10.00,0.00,0.00),('1','65','420','194540',3799111,'1125','161',244060.32,244060.32,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','194540',3799112,'1126','161',598618.47,598883.80,265.33,43779.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','194540',3799113,'1127','161',411779.47,411795.10,15.63,2578.95,0.00,0.00,0.00,0.00,0.00),('1','65','421','194540',3799114,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194540',3799115,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194540',3799116,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194540',3799117,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194540',3799118,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194540',3799119,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194540',3799120,'1134','162',10150086.92,10150789.78,702.86,189772.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','194540',3799121,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194540',3799122,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194540',3799123,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194548',3799250,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194548',3799251,'1123','161',509981.14,510319.31,338.17,55798.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','194548',3799252,'1124','161',186822.58,186822.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194548',3799253,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194548',3799254,'1126','161',598883.80,598883.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194548',3799255,'1127','161',411795.10,411886.62,91.52,15100.80,0.00,0.00,0.00,0.00,0.00),('1','65','421','194548',3799256,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194548',3799257,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194548',3799258,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194548',3799259,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194548',3799260,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194548',3799261,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194548',3799262,'1134','162',10150789.78,10150963.42,173.64,46882.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','194548',3799263,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194548',3799264,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194548',3799265,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194551',3799305,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194551',3799306,'1123','161',510319.31,510733.92,414.61,68410.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','194551',3799307,'1124','161',186822.58,186822.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194551',3799308,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194551',3799309,'1126','161',598883.80,599072.57,188.77,31147.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','194551',3799310,'1127','161',411886.62,411886.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194551',3799311,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194551',3799312,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194551',3799313,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194551',3799314,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194551',3799315,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194551',3799316,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194551',3799317,'1134','162',10150963.42,10151217.90,254.48,68709.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','194551',3799318,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194551',3799319,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194551',3799320,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194582',3799812,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194582',3799813,'1123','161',510733.92,511401.03,667.11,110073.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','194582',3799814,'1124','161',186822.58,186829.25,6.67,1100.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','194582',3799815,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194582',3799816,'1126','161',599072.57,599072.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194582',3799817,'1127','161',411886.62,411934.50,47.88,7900.20,0.00,0.00,0.00,0.00,0.00),('1','65','421','194582',3799818,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194582',3799819,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194582',3799820,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194582',3799821,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194582',3799822,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194582',3799823,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194582',3799824,'1134','162',10151217.90,10152684.13,1466.23,395882.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','194582',3799825,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194582',3799826,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194582',3799827,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194749',3803043,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194749',3803044,'1123','161',511401.03,511975.86,574.83,94846.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','194749',3803045,'1124','161',186829.25,186829.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194749',3803046,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194749',3803047,'1126','161',599072.57,599270.74,198.17,32698.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','194749',3803048,'1127','161',411934.50,411934.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194749',3803049,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194749',3803050,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194749',3803051,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194749',3803052,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194749',3803053,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194749',3803054,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194749',3803055,'1134','162',10152684.13,10154381.43,1687.30,455571.00,0.00,0.00,10.00,0.00,0.00),('1','65','423','194749',3803056,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194749',3803057,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194749',3803058,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194792',3803984,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194792',3803985,'1123','161',511975.86,512793.27,817.41,134872.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','194792',3803986,'1124','161',186829.25,186829.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194792',3803987,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194792',3803988,'1126','161',599270.74,599270.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194792',3803989,'1127','161',411934.50,411934.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194792',3803990,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194792',3803991,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194792',3803992,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194792',3803993,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194792',3803994,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194792',3803995,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194792',3803996,'1134','162',10154381.43,10154801.13,419.70,113319.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194792',3803997,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194792',3803998,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194792',3803999,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194883',3805900,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194883',3805901,'1123','161',512793.27,513260.81,467.54,77144.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','194883',3805902,'1124','161',186829.25,186829.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194883',3805903,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194883',3805904,'1126','161',599270.74,599270.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194883',3805905,'1127','161',411934.50,412004.19,69.69,11498.85,0.00,0.00,0.00,0.00,0.00),('1','65','421','194883',3805906,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194883',3805907,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194883',3805908,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194883',3805909,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194883',3805910,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194883',3805911,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194883',3805912,'1134','162',10154801.13,10154968.21,167.08,45111.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','194883',3805913,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194883',3805914,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194883',3805915,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194952',3807206,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194952',3807207,'1123','161',513260.81,513813.24,552.43,91150.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','194952',3807208,'1124','161',186829.25,186829.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194952',3807209,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','194952',3807210,'1126','161',599270.74,599490.85,220.11,36318.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','194952',3807211,'1127','161',412004.19,412004.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194952',3807212,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194952',3807213,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194952',3807214,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194952',3807215,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194952',3807216,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','194952',3807217,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','194952',3807218,'1134','162',10154968.21,10155924.94,956.73,258317.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','194952',3807219,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194952',3807220,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','194952',3807221,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195103',3809751,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195103',3809752,'1123','161',513813.24,514417.02,603.78,99623.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','195103',3809753,'1124','161',186829.25,186829.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195103',3809754,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195103',3809755,'1126','161',599490.85,599490.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195103',3809756,'1127','161',412004.19,412190.03,185.84,30663.60,0.00,0.00,0.00,0.00,0.00),('1','65','421','195103',3809757,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195103',3809758,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195103',3809759,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195103',3809760,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195103',3809761,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195103',3809762,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','195103',3809763,'1134','162',10155924.94,10156149.45,224.51,60617.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','195103',3809764,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195103',3809765,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195103',3809766,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195212',3811669,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195212',3811670,'1123','161',514417.02,515383.09,946.07,156101.55,0.00,0.00,20.00,0.00,0.00),('1','65','420','195212',3811671,'1124','161',186829.25,186829.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195212',3811672,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195212',3811673,'1126','161',599490.85,600148.44,647.59,106852.35,0.00,0.00,10.00,0.00,0.00),('1','65','420','195212',3811674,'1127','161',412190.03,412190.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195212',3811675,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195212',3811676,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195212',3811677,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195212',3811678,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195212',3811679,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195212',3811680,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','195212',3811681,'1134','162',10156149.45,10156347.30,187.85,50719.50,0.00,0.00,10.00,0.00,0.00),('1','65','423','195212',3811682,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195212',3811683,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195212',3811684,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195374',3814501,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195374',3814502,'1123','161',515383.09,516009.90,626.81,103423.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','195374',3814503,'1124','161',186829.25,187027.82,198.57,32764.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','195374',3814504,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195374',3814505,'1126','161',600148.44,600148.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195374',3814506,'1127','161',412190.03,412190.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195374',3814507,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195374',3814508,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195374',3814509,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195374',3814510,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195374',3814511,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195374',3814512,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','195374',3814513,'1134','162',10156347.30,10156793.02,445.72,120344.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','195374',3814514,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195374',3814515,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195374',3814516,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195445',3815716,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195445',3815717,'1123','161',516009.90,516592.13,582.23,96067.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','195445',3815718,'1124','161',187027.82,187027.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195445',3815719,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195445',3815720,'1126','161',600148.44,600232.23,83.79,13825.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','195445',3815721,'1127','161',412190.03,412190.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195445',3815722,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195445',3815723,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195445',3815724,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195445',3815725,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195445',3815726,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195445',3815727,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','195445',3815728,'1134','162',10156793.02,10157277.59,484.57,130833.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','195445',3815729,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195445',3815730,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195445',3815731,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195572',3817858,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195572',3817859,'1123','161',516592.13,516994.32,402.19,66361.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','195572',3817860,'1124','161',187027.82,187107.82,80.00,13200.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195572',3817861,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195572',3817862,'1126','161',600232.23,600232.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195572',3817863,'1127','161',412190.03,412263.47,73.44,12117.60,0.00,0.00,0.00,0.00,0.00),('1','65','421','195572',3817864,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195572',3817865,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195572',3817866,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195572',3817867,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195572',3817868,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195572',3817869,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','195572',3817870,'1134','162',10157277.59,10157382.42,104.83,28304.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','195572',3817871,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195572',3817872,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195572',3817873,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195705',3820166,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195705',3820167,'1123','161',516994.32,517770.55,776.23,128077.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','195705',3820168,'1124','161',187107.82,187107.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195705',3820169,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195705',3820170,'1126','161',600232.23,600332.52,100.29,16547.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','195705',3820171,'1127','161',412263.47,412263.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195705',3820172,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195705',3820173,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195705',3820174,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195705',3820175,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195705',3820176,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195705',3820177,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','195705',3820178,'1134','162',10157382.42,10157838.86,456.44,123238.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','195705',3820179,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195705',3820180,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195705',3820181,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195846',3822516,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195846',3822517,'1123','161',517770.55,518519.05,748.50,123502.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','195846',3822518,'1124','161',187107.82,187107.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195846',3822519,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195846',3822520,'1126','161',600332.52,600332.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195846',3822521,'1127','161',412263.47,412404.96,141.49,23345.85,0.00,0.00,0.00,0.00,0.00),('1','65','421','195846',3822522,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195846',3822523,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195846',3822524,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195846',3822525,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195846',3822526,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195846',3822527,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','195846',3822528,'1134','162',10157838.86,10158107.10,268.24,72424.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','195846',3822529,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195846',3822530,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195846',3822531,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195930',3824176,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195930',3824177,'1123','161',518519.05,519083.76,564.71,93177.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','195930',3824178,'1124','161',187107.82,187121.76,13.94,2300.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','195930',3824179,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195930',3824180,'1126','161',600332.52,600332.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','195930',3824181,'1127','161',412404.96,412404.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195930',3824182,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195930',3824183,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195930',3824184,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195930',3824185,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195930',3824186,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','195930',3824187,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','195930',3824188,'1134','162',10158107.10,10158416.26,309.16,83473.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','195930',3824189,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195930',3824190,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','195930',3824191,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196168',3828732,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196168',3828733,'1123','161',519083.76,519822.09,738.33,121824.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','196168',3828734,'1124','161',187121.76,187121.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196168',3828735,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196168',3828736,'1126','161',600332.52,600539.80,207.28,34201.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','196168',3828737,'1127','161',412404.96,412404.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196168',3828738,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196168',3828739,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196168',3828740,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196168',3828741,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196168',3828742,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196168',3828743,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','196168',3828744,'1134','162',10158416.26,10158846.40,430.14,116137.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','196168',3828745,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196168',3828746,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196168',3828747,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196252',3830167,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196252',3830168,'1123','161',519822.09,520318.49,486.40,80256.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','196252',3830169,'1124','161',187121.76,187396.82,265.06,43734.90,0.00,0.00,10.00,0.00,0.00),('1','65','420','196252',3830170,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196252',3830171,'1126','161',600539.80,600539.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196252',3830172,'1127','161',412404.96,412404.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196252',3830173,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196252',3830174,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196252',3830175,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196252',3830176,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196252',3830177,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196252',3830178,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','196252',3830179,'1134','162',10158846.40,10159158.36,301.96,81529.20,0.00,0.00,10.00,0.00,0.00),('1','65','423','196252',3830180,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196252',3830181,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196252',3830182,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196315',3831442,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196315',3831443,'1123','161',520318.49,521066.35,747.86,123396.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','196315',3831444,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196315',3831445,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196315',3831446,'1126','161',600539.80,600539.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196315',3831447,'1127','161',412404.96,412753.12,348.16,57446.40,0.00,0.00,0.00,0.00,0.00),('1','65','421','196315',3831448,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196315',3831449,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196315',3831450,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196315',3831451,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196315',3831452,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196315',3831453,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','196315',3831454,'1134','162',10159158.36,10159311.54,153.18,41358.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','196315',3831455,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196315',3831456,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196315',3831457,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196345',3831967,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196345',3831968,'1123','161',521066.35,522137.52,1071.17,176743.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','196345',3831969,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196345',3831970,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196345',3831971,'1126','161',600539.80,600539.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196345',3831972,'1127','161',412753.12,412807.18,54.06,8919.90,0.00,0.00,0.00,0.00,0.00),('1','65','421','196345',3831973,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196345',3831974,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196345',3831975,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196345',3831976,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196345',3831977,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196345',3831978,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','196345',3831979,'1134','162',10159311.54,10159478.98,167.44,45208.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','196345',3831980,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196345',3831981,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196345',3831982,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196438',3833687,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196438',3833688,'1123','161',522137.52,523001.59,864.07,142571.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','196438',3833689,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196438',3833690,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196438',3833691,'1126','161',600539.80,600708.37,168.57,27814.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','196438',3833692,'1127','161',412807.18,412807.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196438',3833693,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196438',3833694,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196438',3833695,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196438',3833696,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196438',3833697,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196438',3833698,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','196438',3833699,'1134','162',10159478.98,10159520.08,41.10,11097.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','196438',3833700,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196438',3833701,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196438',3833702,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196555',3835684,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196555',3835685,'1123','161',523001.59,523903.84,902.25,148871.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','196555',3835686,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196555',3835687,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196555',3835688,'1126','161',600708.37,600756.56,48.19,7951.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','196555',3835689,'1127','161',412807.18,412807.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196555',3835690,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196555',3835691,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196555',3835692,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196555',3835693,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196555',3835694,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196555',3835695,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','196555',3835696,'1134','162',10159520.08,10159670.59,150.51,40637.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','196555',3835697,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196555',3835698,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196555',3835699,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196712',3838362,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196712',3838363,'1123','161',523903.84,524718.55,814.71,134427.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','196712',3838364,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196712',3838365,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196712',3838366,'1126','161',600756.56,600756.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','196712',3838367,'1127','161',412807.18,412938.92,131.74,21737.10,0.00,0.00,0.00,0.00,0.00),('1','65','421','196712',3838368,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196712',3838369,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196712',3838370,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196712',3838371,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196712',3838372,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','196712',3838373,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','196712',3838374,'1134','162',10159670.59,10160639.37,968.78,261570.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','196712',3838375,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196712',3838376,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','196712',3838377,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197471',3851731,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197471',3851732,'1123','161',524718.55,525206.34,487.79,80485.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','197471',3851733,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197471',3851734,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197471',3851735,'1126','161',600756.56,601642.27,885.71,146142.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','197471',3851736,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197471',3851737,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197471',3851738,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197471',3851739,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197471',3851740,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197471',3851741,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197471',3851742,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197471',3851743,'1134','162',10160639.37,10160975.43,336.06,90736.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','197471',3851744,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197471',3851745,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197471',3851746,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197717',3855970,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197717',3855971,'1123','161',525206.34,526187.23,980.89,161846.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','197717',3855972,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197717',3855973,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197717',3855974,'1126','161',601642.27,602485.15,842.88,139075.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','197717',3855975,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197717',3855976,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197717',3855977,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197717',3855978,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197717',3855979,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197717',3855980,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197717',3855981,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197717',3855982,'1134','162',10160975.43,10161194.98,219.55,59278.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','197717',3855983,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197717',3855984,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197717',3855985,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197812',3857836,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197812',3857837,'1123','161',526187.23,527681.95,1494.72,246628.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','197812',3857838,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197812',3857839,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197812',3857840,'1126','161',602485.15,602817.55,332.40,54846.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197812',3857841,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197812',3857842,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197812',3857843,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197812',3857844,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197812',3857845,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197812',3857846,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197812',3857847,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197812',3857848,'1134','162',10161194.98,10161476.23,281.25,75937.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','197812',3857849,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197812',3857850,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197812',3857851,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197823',3858037,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197823',3858038,'1123','161',527681.95,527681.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197823',3858039,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197823',3858040,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197823',3858041,'1126','161',602817.55,602817.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197823',3858042,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197823',3858043,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197823',3858044,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197823',3858045,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197823',3858046,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197823',3858047,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197823',3858048,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197823',3858049,'1134','162',10161476.23,10161496.98,20.75,5602.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','197823',3858050,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197823',3858051,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197823',3858052,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197828',3858109,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197828',3858110,'1123','161',527681.95,527681.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197828',3858111,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197828',3858112,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197828',3858113,'1126','161',602817.55,602817.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197828',3858114,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197828',3858115,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197828',3858116,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197828',3858117,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197828',3858118,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197828',3858119,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197828',3858120,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197828',3858121,'1134','162',10161496.98,10161536.27,39.29,10608.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','197828',3858122,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197828',3858123,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197828',3858124,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197830',3858150,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197830',3858151,'1123','161',527681.95,527681.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197830',3858152,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197830',3858153,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197830',3858154,'1126','161',602817.55,602817.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197830',3858155,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197830',3858156,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197830',3858157,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197830',3858158,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197830',3858159,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197830',3858160,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197830',3858161,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197830',3858162,'1134','162',10161536.27,10161619.95,83.68,22593.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','197830',3858163,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197830',3858164,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197830',3858165,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197851',3858512,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197851',3858513,'1123','161',527681.95,527681.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197851',3858514,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197851',3858515,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197851',3858516,'1126','161',602817.55,602817.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197851',3858517,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197851',3858518,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197851',3858519,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197851',3858520,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197851',3858521,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197851',3858522,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197851',3858523,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197851',3858524,'1134','162',10161619.95,10162328.34,708.39,191265.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','197851',3858525,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197851',3858526,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197851',3858527,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197875',3858866,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197875',3858867,'1123','161',527681.95,528314.26,632.31,104331.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','197875',3858868,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197875',3858869,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197875',3858870,'1126','161',602817.55,602817.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197875',3858871,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197875',3858872,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197875',3858873,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197875',3858874,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197875',3858875,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197875',3858876,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197875',3858877,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197875',3858878,'1134','162',10162328.34,10162442.93,114.59,30939.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','197875',3858879,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197875',3858880,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197875',3858881,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197884',3858995,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197884',3858996,'1123','161',528314.26,529155.23,840.97,138760.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','197884',3858997,'1124','161',187396.82,187396.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197884',3858998,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197884',3858999,'1126','161',602817.55,602852.10,34.55,5700.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','197884',3859000,'1127','161',412938.92,412938.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197884',3859001,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197884',3859002,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197884',3859003,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197884',3859004,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197884',3859005,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197884',3859006,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197884',3859007,'1134','162',10162442.93,10162955.78,512.85,138469.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','197884',3859008,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197884',3859009,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197884',3859010,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197900',3859195,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197900',3859196,'1123','161',529155.23,529155.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197900',3859197,'1124','161',187396.82,187770.09,373.27,61589.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','197900',3859198,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197900',3859199,'1126','161',602852.10,602852.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197900',3859200,'1127','161',412938.92,413528.67,589.75,97308.75,0.00,0.00,0.00,0.00,0.00),('1','65','421','197900',3859201,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197900',3859202,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197900',3859203,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197900',3859204,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197900',3859205,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197900',3859206,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197900',3859207,'1134','162',10162955.78,10163523.05,567.27,153162.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','197900',3859208,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197900',3859209,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197900',3859210,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197903',3859244,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197903',3859245,'1123','161',529155.23,529835.81,680.58,112295.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','197903',3859246,'1124','161',187770.09,187770.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197903',3859247,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197903',3859248,'1126','161',602852.10,602981.79,129.69,21398.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','197903',3859249,'1127','161',413528.67,413528.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197903',3859250,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197903',3859251,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197903',3859252,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197903',3859253,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197903',3859254,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197903',3859255,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197903',3859256,'1134','162',10163523.05,10164535.25,1012.20,273294.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197903',3859257,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197903',3859258,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197903',3859259,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197909',3859343,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197909',3859344,'1123','161',529835.81,530377.37,541.56,89357.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','197909',3859345,'1124','161',187770.09,187770.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197909',3859346,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197909',3859347,'1126','161',602981.79,602981.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','197909',3859348,'1127','161',413528.67,413651.09,122.42,20199.30,0.00,0.00,0.00,0.00,0.00),('1','65','421','197909',3859349,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197909',3859350,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197909',3859351,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197909',3859352,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197909',3859353,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','197909',3859354,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','197909',3859355,'1134','162',10164535.25,10164909.88,374.63,101150.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','197909',3859356,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197909',3859357,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','197909',3859358,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198188',3864267,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198188',3864268,'1123','161',530377.37,531177.48,800.11,132018.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','198188',3864269,'1124','161',187770.09,187950.00,179.91,29685.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','198188',3864270,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198188',3864271,'1126','161',602981.79,602981.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198188',3864272,'1127','161',413651.09,413651.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198188',3864273,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198188',3864274,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198188',3864275,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198188',3864276,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198188',3864277,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198188',3864278,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198188',3864279,'1134','162',10164909.88,10165196.84,286.96,77479.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','198188',3864280,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198188',3864281,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198188',3864282,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198273',3865730,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198273',3865731,'1123','161',531177.48,531768.80,591.32,97567.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','198273',3865732,'1124','161',187950.00,187950.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198273',3865733,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198273',3865734,'1126','161',602981.79,603088.33,106.54,17579.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','198273',3865735,'1127','161',413651.09,413651.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198273',3865736,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198273',3865737,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198273',3865738,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198273',3865739,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198273',3865740,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198273',3865741,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198273',3865742,'1134','162',10165196.84,10165855.47,658.63,177830.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','198273',3865743,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198273',3865744,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198273',3865745,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198302',3866349,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198302',3866350,'1123','161',531768.80,533146.34,1377.54,227294.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','198302',3866351,'1124','161',187950.00,188520.80,570.80,94182.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198302',3866352,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198302',3866353,'1126','161',603088.33,603088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198302',3866354,'1127','161',413651.09,414014.12,363.03,59899.95,0.00,0.00,0.00,0.00,0.00),('1','65','421','198302',3866355,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198302',3866356,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198302',3866357,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198302',3866358,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198302',3866359,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198302',3866360,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198302',3866361,'1134','162',10165855.47,10166649.71,794.24,214444.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','198302',3866362,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198302',3866363,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198302',3866364,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198512',3869940,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198512',3869941,'1123','161',533146.34,533969.17,822.83,135766.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','198512',3869942,'1124','161',188520.80,188520.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198512',3869943,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198512',3869944,'1126','161',603088.33,603401.42,313.09,51659.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','198512',3869945,'1127','161',414014.12,414014.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198512',3869946,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198512',3869947,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198512',3869948,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198512',3869949,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198512',3869950,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198512',3869951,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198512',3869952,'1134','162',10166649.71,10167067.04,417.33,112679.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','198512',3869953,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198512',3869954,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198512',3869955,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198515',3870005,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198515',3870006,'1123','161',533969.17,534855.74,876.57,144634.05,0.00,0.00,10.00,0.00,0.00),('1','65','420','198515',3870007,'1124','161',188520.80,188789.47,258.67,42680.55,0.00,0.00,10.00,0.00,0.00),('1','65','420','198515',3870008,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198515',3870009,'1126','161',603401.42,603401.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198515',3870010,'1127','161',414014.12,414014.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198515',3870011,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198515',3870012,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198515',3870013,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198515',3870014,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198515',3870015,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198515',3870016,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198515',3870017,'1134','162',10167067.04,10167172.47,85.43,23066.10,0.00,0.00,20.00,0.00,0.00),('1','65','423','198515',3870018,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198515',3870019,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198515',3870020,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198519',3870067,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198519',3870068,'1123','161',534855.74,535589.14,733.40,121011.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198519',3870069,'1124','161',188789.47,188789.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198519',3870070,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198519',3870071,'1126','161',603401.42,603811.15,409.73,67605.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','198519',3870072,'1127','161',414014.12,414014.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198519',3870073,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198519',3870074,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198519',3870075,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198519',3870076,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198519',3870077,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198519',3870078,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198519',3870079,'1134','162',10167172.47,10167172.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198519',3870080,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198519',3870081,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198519',3870082,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198734',3873865,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198734',3873866,'1123','161',535589.14,536635.24,1046.10,172606.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','198734',3873867,'1124','161',188789.47,188789.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198734',3873868,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198734',3873869,'1126','161',603811.15,603911.49,100.34,16556.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','198734',3873870,'1127','161',414014.12,414014.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198734',3873871,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198734',3873872,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198734',3873873,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198734',3873874,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198734',3873875,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198734',3873876,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198734',3873877,'1134','162',10167172.47,10167172.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198734',3873878,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198734',3873879,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198734',3873880,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198868',3875694,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198868',3875695,'1123','161',536635.24,536865.17,229.93,37938.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','198868',3875696,'1124','161',188789.47,188981.15,191.68,31627.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','198868',3875697,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198868',3875698,'1126','161',603911.49,603911.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198868',3875699,'1127','161',414014.12,414473.32,459.20,75768.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198868',3875700,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198868',3875701,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198868',3875702,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198868',3875703,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198868',3875704,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198868',3875705,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198868',3875706,'1134','162',10167172.47,10167172.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198868',3875707,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198868',3875708,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198868',3875709,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198956',3877479,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198956',3877480,'1123','161',536865.17,536865.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198956',3877481,'1124','161',188981.15,189091.58,100.43,16570.95,0.00,0.00,10.00,0.00,0.00),('1','65','420','198956',3877482,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','198956',3877483,'1126','161',603911.49,604638.66,712.17,117508.05,0.00,0.00,15.00,0.00,0.00),('1','65','420','198956',3877484,'1127','161',414473.32,414784.92,301.60,49764.00,0.00,0.00,10.00,0.00,0.00),('1','65','421','198956',3877485,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198956',3877486,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198956',3877487,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198956',3877488,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198956',3877489,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','198956',3877490,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','198956',3877491,'1134','162',10167172.47,10169019.19,1836.72,495914.40,0.00,0.00,10.00,0.00,0.00),('1','65','423','198956',3877492,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198956',3877493,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','198956',3877494,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199064',3879308,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199064',3879309,'1123','161',536865.17,537134.03,268.86,44361.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','199064',3879310,'1124','161',189091.58,189091.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199064',3879311,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199064',3879312,'1126','161',604638.66,604754.41,115.75,19098.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','199064',3879313,'1127','161',414784.92,414982.16,197.24,32544.60,0.00,0.00,0.00,0.00,0.00),('1','65','421','199064',3879314,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199064',3879315,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199064',3879316,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199064',3879317,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199064',3879318,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199064',3879319,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199064',3879320,'1134','162',10169019.19,10169483.72,464.53,125423.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','199064',3879321,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199064',3879322,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199064',3879323,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199328',3883615,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199328',3883616,'1123','161',537134.03,537714.18,580.15,95724.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','199328',3883617,'1124','161',189091.58,189091.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199328',3883618,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199328',3883619,'1126','161',604754.41,605098.63,344.22,56796.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','199328',3883620,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199328',3883621,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199328',3883622,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199328',3883623,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199328',3883624,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199328',3883625,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199328',3883626,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199328',3883627,'1134','162',10169483.72,10170065.01,581.29,156948.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','199328',3883628,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199328',3883629,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199328',3883630,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199333',3883710,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199333',3883711,'1123','161',537714.18,538427.21,713.03,117649.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','199333',3883712,'1124','161',189091.58,189498.33,406.75,67113.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','199333',3883713,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199333',3883714,'1126','161',605098.63,605103.48,4.85,800.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','199333',3883715,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199333',3883716,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199333',3883717,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199333',3883718,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199333',3883719,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199333',3883720,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199333',3883721,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199333',3883722,'1134','162',10170065.01,10172353.83,2288.82,617981.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','199333',3883723,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199333',3883724,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199333',3883725,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199334',3883726,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199334',3883727,'1123','161',538427.21,539388.37,961.16,158591.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','199334',3883728,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199334',3883729,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199334',3883730,'1126','161',605103.48,605276.26,172.78,28508.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','199334',3883731,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199334',3883732,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199334',3883733,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199334',3883734,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199334',3883735,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199334',3883736,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199334',3883737,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199334',3883738,'1134','162',10172353.83,10173420.10,1066.27,287892.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','199334',3883739,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199334',3883740,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199334',3883741,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199543',3887226,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199543',3887227,'1123','161',539388.37,540014.59,626.22,103326.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','199543',3887228,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199543',3887229,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199543',3887230,'1126','161',605276.26,605276.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199543',3887231,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199543',3887232,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199543',3887233,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199543',3887234,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199543',3887235,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199543',3887236,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199543',3887237,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199543',3887238,'1134','162',10173420.10,10174577.65,1157.55,312538.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','199543',3887239,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199543',3887240,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199543',3887241,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199556',3887552,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199556',3887553,'1123','161',540014.59,540589.00,574.41,94777.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','199556',3887554,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199556',3887555,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199556',3887556,'1126','161',605276.26,605420.80,144.54,23849.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','199556',3887557,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199556',3887558,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199556',3887559,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199556',3887560,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199556',3887561,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199556',3887562,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199556',3887563,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199556',3887564,'1134','162',10174577.65,10175677.12,1099.47,296856.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','199556',3887565,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199556',3887566,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199556',3887567,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199759',3890652,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199759',3890653,'1123','161',540589.00,541473.04,884.04,145866.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','199759',3890654,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199759',3890655,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199759',3890656,'1126','161',605420.80,605420.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199759',3890657,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199759',3890658,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199759',3890659,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199759',3890660,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199759',3890661,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199759',3890662,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199759',3890663,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199759',3890664,'1134','162',10175677.12,10176835.99,1158.87,312894.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','199759',3890665,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199759',3890666,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199759',3890667,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199791',3891196,'1122','161',801352.73,801352.73,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','199791',3891197,'1123','161',541473.04,542551.22,1078.18,177899.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','199791',3891198,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199791',3891199,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199791',3891200,'1126','161',605420.80,605874.11,443.31,73146.15,0.00,0.00,10.00,0.00,0.00),('1','65','420','199791',3891201,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199791',3891202,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199791',3891203,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199791',3891204,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199791',3891205,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199791',3891206,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199791',3891207,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199791',3891208,'1134','162',10176835.99,10177093.72,247.73,66887.10,0.00,0.00,10.00,0.00,0.00),('1','65','423','199791',3891209,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199791',3891210,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199791',3891211,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199978',3894563,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199978',3894564,'1123','161',542551.22,543597.42,1046.20,172623.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199978',3894565,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199978',3894566,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199978',3894567,'1126','161',605874.11,605874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','199978',3894568,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199978',3894569,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199978',3894570,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199978',3894571,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199978',3894572,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199978',3894573,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','199978',3894574,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','199978',3894575,'1134','162',10177093.72,10177589.79,496.07,133938.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','199978',3894576,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199978',3894577,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','199978',3894578,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200167',3897999,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200167',3898000,'1123','161',543597.42,544691.66,1094.24,180549.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','200167',3898001,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200167',3898002,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200167',3898003,'1126','161',605874.11,605953.48,79.37,13096.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','200167',3898004,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200167',3898005,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200167',3898006,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200167',3898007,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200167',3898008,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200167',3898009,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200167',3898010,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','200167',3898011,'1134','162',10177589.79,10178101.92,512.13,138275.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','200167',3898012,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','200167',3898013,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','200167',3898014,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200177',3898164,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200177',3898165,'1123','161',544691.66,545484.92,793.26,130887.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','200177',3898166,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200177',3898167,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200177',3898168,'1126','161',605953.48,606022.26,68.78,11348.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','200177',3898169,'1127','161',414982.16,414982.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200177',3898170,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200177',3898171,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200177',3898172,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200177',3898173,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200177',3898174,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200177',3898175,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','200177',3898176,'1134','162',10178101.92,10179732.62,1630.70,440289.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','200177',3898177,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','200177',3898178,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','200177',3898179,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200298',3900237,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200298',3900238,'1123','161',545484.92,546593.11,1108.19,182851.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','200298',3900239,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200298',3900240,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200298',3900241,'1126','161',606022.26,606022.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200298',3900242,'1127','161',414982.16,415035.80,53.64,8850.60,0.00,0.00,0.00,0.00,0.00),('1','65','421','200298',3900243,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200298',3900244,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200298',3900245,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200298',3900246,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200298',3900247,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200298',3900248,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','200298',3900249,'1134','162',10179732.62,10180168.08,435.46,119751.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','200298',3900250,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','200298',3900251,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','200298',3900252,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200389',3901866,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200389',3901867,'1123','161',546593.11,547368.74,775.63,127978.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','200389',3901868,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200389',3901869,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','200389',3901870,'1126','161',606022.26,606062.03,39.77,6562.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','200389',3901871,'1127','161',415035.80,415035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200389',3901872,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200389',3901873,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200389',3901874,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200389',3901875,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200389',3901876,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','200389',3901877,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','200389',3901878,'1134','162',10180168.08,10180299.72,131.64,36201.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','200389',3901879,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','200389',3901880,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','200389',3901881,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201036',3913253,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201036',3913254,'1123','161',547368.74,548472.19,1103.45,182069.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','201036',3913255,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201036',3913256,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201036',3913257,'1126','161',606062.03,606265.43,203.40,33561.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201036',3913258,'1127','161',415035.80,415035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201036',3913259,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201036',3913260,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201036',3913261,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201036',3913262,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201036',3913263,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201036',3913264,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201036',3913265,'1134','162',10180299.72,10180397.88,98.16,26994.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201036',3913266,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201036',3913267,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201036',3913268,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201049',3913627,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201049',3913628,'1123','161',548472.19,549158.53,686.34,113246.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','201049',3913629,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201049',3913630,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201049',3913631,'1126','161',606265.43,606338.76,73.33,12099.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','201049',3913632,'1127','161',415035.80,415035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201049',3913633,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201049',3913634,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201049',3913635,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201049',3913636,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201049',3913637,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201049',3913638,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201049',3913639,'1134','162',10180397.88,10180794.07,396.19,108952.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','201049',3913640,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201049',3913641,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201049',3913642,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201052',3913660,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201052',3913661,'1123','161',549158.53,549605.72,447.19,73786.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','201052',3913662,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201052',3913663,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201052',3913664,'1126','161',606338.76,606709.96,371.20,61248.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201052',3913665,'1127','161',415035.80,415035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201052',3913666,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201052',3913667,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201052',3913668,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201052',3913669,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201052',3913670,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201052',3913671,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201052',3913672,'1134','162',10180794.07,10181466.98,672.91,185050.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','201052',3913673,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201052',3913674,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201052',3913675,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201054',3913705,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201054',3913706,'1123','161',549605.72,550847.05,1241.33,204819.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','201054',3913707,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201054',3913708,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201054',3913709,'1126','161',606709.96,606772.72,62.76,10355.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','201054',3913710,'1127','161',415035.80,415035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201054',3913711,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201054',3913712,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201054',3913713,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201054',3913714,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201054',3913715,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201054',3913716,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201054',3913717,'1134','162',10181466.98,10182211.36,744.38,204704.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','201054',3913718,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201054',3913719,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201054',3913720,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201060',3913812,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201060',3913813,'1123','161',550847.05,551958.40,1111.35,183372.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','201060',3913814,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201060',3913815,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201060',3913816,'1126','161',606772.72,606772.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201060',3913817,'1127','161',415035.80,415035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201060',3913818,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201060',3913819,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201060',3913820,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201060',3913821,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201060',3913822,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201060',3913823,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201060',3913824,'1134','162',10182211.36,10182457.67,246.31,67735.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','201060',3913825,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201060',3913826,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201060',3913827,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201062',3913851,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201062',3913852,'1123','161',551958.40,552653.84,695.44,114747.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','201062',3913853,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201062',3913854,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201062',3913855,'1126','161',606772.72,606856.87,84.15,13884.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','201062',3913856,'1127','161',415035.80,415035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201062',3913857,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201062',3913858,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201062',3913859,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201062',3913860,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201062',3913861,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201062',3913862,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201062',3913863,'1134','162',10182457.67,10183051.26,593.59,163237.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','201062',3913864,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201062',3913865,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201062',3913866,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201063',3913867,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201063',3913868,'1123','161',552653.84,553592.53,938.69,154883.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','201063',3913869,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201063',3913870,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201063',3913871,'1126','161',606856.87,607020.21,163.34,26951.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','201063',3913872,'1127','161',415035.80,415035.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201063',3913873,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201063',3913874,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201063',3913875,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201063',3913876,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201063',3913877,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201063',3913878,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201063',3913879,'1134','162',10183051.26,10183666.08,614.82,169075.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','201063',3913880,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201063',3913881,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201063',3913882,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201064',3913883,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201064',3913884,'1123','161',553592.53,553592.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201064',3913885,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201064',3913886,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201064',3913887,'1126','161',607020.21,607784.26,764.05,126068.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','201064',3913888,'1127','161',415035.80,415437.83,402.03,66334.95,0.00,0.00,0.00,0.00,0.00),('1','65','421','201064',3913889,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201064',3913890,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201064',3913891,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201064',3913892,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201064',3913893,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201064',3913894,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201064',3913895,'1134','162',10183666.08,10183923.53,257.45,70798.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','201064',3913896,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201064',3913897,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201064',3913898,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201274',3917497,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201274',3917498,'1123','161',553592.53,553592.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201274',3917499,'1124','161',189498.33,189498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201274',3917500,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201274',3917501,'1126','161',607784.26,608631.54,847.28,139801.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','201274',3917502,'1127','161',415437.83,415437.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201274',3917503,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201274',3917504,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201274',3917505,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201274',3917506,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201274',3917507,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201274',3917508,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201274',3917509,'1134','162',10183923.53,10184161.41,237.88,65417.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201274',3917510,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201274',3917511,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201274',3917512,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201416',3919860,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201416',3919861,'1123','161',553592.53,553957.42,364.89,60206.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','201416',3919862,'1124','161',189498.33,190084.36,586.03,96694.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','201416',3919863,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201416',3919864,'1126','161',608631.54,609690.79,1059.25,174776.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','201416',3919865,'1127','161',415437.83,415437.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201416',3919866,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201416',3919867,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201416',3919868,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201416',3919869,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201416',3919870,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201416',3919871,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201416',3919872,'1134','162',10184161.41,10184452.27,290.86,79986.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','201416',3919873,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201416',3919874,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201416',3919875,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201418',3919896,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201418',3919897,'1123','161',553957.42,554958.45,1001.03,165169.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','201418',3919898,'1124','161',190084.36,190084.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201418',3919899,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201418',3919900,'1126','161',609690.79,609746.82,56.03,9244.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','201418',3919901,'1127','161',415437.83,415437.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201418',3919902,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201418',3919903,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201418',3919904,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201418',3919905,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201418',3919906,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201418',3919907,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201418',3919908,'1134','162',10184452.27,10185229.92,777.65,213853.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','201418',3919909,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201418',3919910,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201418',3919911,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201614',3923520,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201614',3923521,'1123','161',554958.45,555909.61,951.16,156941.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','201614',3923522,'1124','161',190084.36,190084.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201614',3923523,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201614',3923524,'1126','161',609746.82,609746.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201614',3923525,'1127','161',415437.83,415437.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201614',3923526,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201614',3923527,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201614',3923528,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201614',3923529,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201614',3923530,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201614',3923531,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201614',3923532,'1134','162',10185229.92,10186013.75,783.83,215553.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','201614',3923533,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201614',3923534,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201614',3923535,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201645',3924214,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201645',3924215,'1123','161',555909.61,557107.53,1197.92,197656.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','201645',3924216,'1124','161',190084.36,190084.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201645',3924217,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201645',3924218,'1126','161',609746.82,609924.69,177.87,29348.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','201645',3924219,'1127','161',415437.83,415437.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201645',3924220,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201645',3924221,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201645',3924222,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201645',3924223,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201645',3924224,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201645',3924225,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201645',3924226,'1134','162',10186013.75,10186300.08,286.33,78740.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','201645',3924227,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201645',3924228,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201645',3924229,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201843',3927999,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201843',3928000,'1123','161',557107.53,558083.42,975.89,161021.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','201843',3928001,'1124','161',190084.36,190084.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201843',3928002,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201843',3928003,'1126','161',609924.69,609924.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','201843',3928004,'1127','161',415437.83,415437.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201843',3928005,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201843',3928006,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201843',3928007,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201843',3928008,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201843',3928009,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','201843',3928010,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','201843',3928011,'1134','162',10186300.08,10186360.79,60.71,16695.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','201843',3928012,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201843',3928013,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','201843',3928014,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202103',3932861,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202103',3932862,'1123','161',558083.42,558765.46,682.04,112536.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','202103',3932863,'1124','161',190084.36,190084.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202103',3932864,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202103',3932865,'1126','161',609924.69,610157.79,233.10,38461.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','202103',3932866,'1127','161',415437.83,415437.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202103',3932867,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202103',3932868,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202103',3932869,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202103',3932870,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202103',3932871,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202103',3932872,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202103',3932873,'1134','162',10186360.79,10186538.53,177.74,49767.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','202103',3932874,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202103',3932875,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202103',3932876,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202181',3934267,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202181',3934268,'1123','161',558765.46,559800.17,1034.71,170727.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','202181',3934269,'1124','161',190084.36,190084.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202181',3934270,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202181',3934271,'1126','161',610157.79,610157.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202181',3934272,'1127','161',415437.83,415485.71,47.88,7900.20,0.00,0.00,0.00,0.00,0.00),('1','65','421','202181',3934273,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202181',3934274,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202181',3934275,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202181',3934276,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202181',3934277,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202181',3934278,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202181',3934279,'1134','162',10186538.53,10187131.28,592.75,165970.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202181',3934280,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202181',3934281,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202181',3934282,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202243',3935089,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202243',3935090,'1123','161',559800.17,560478.67,678.50,111952.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','202243',3935091,'1124','161',190084.36,190120.72,36.36,5999.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','202243',3935092,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202243',3935093,'1126','161',610157.79,610473.51,315.72,52093.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','202243',3935094,'1127','161',415485.71,415485.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202243',3935095,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202243',3935096,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202243',3935097,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202243',3935098,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202243',3935099,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202243',3935100,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202243',3935101,'1134','162',10187131.28,10187797.68,666.40,186592.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202243',3935102,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202243',3935103,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202243',3935104,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202314',3936381,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202314',3936382,'1123','161',560478.67,561276.24,797.57,131599.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','202314',3936383,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202314',3936384,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202314',3936385,'1126','161',610473.51,610473.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202314',3936386,'1127','161',415485.71,415948.72,463.01,76396.65,0.00,0.00,0.00,0.00,0.00),('1','65','421','202314',3936387,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202314',3936388,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202314',3936389,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202314',3936390,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202314',3936391,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202314',3936392,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202314',3936393,'1134','162',10187797.68,10189729.97,1932.29,541041.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','202314',3936394,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202314',3936395,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202314',3936396,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202384',3937762,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202384',3937763,'1123','161',561276.24,562126.21,849.97,140245.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','202384',3937764,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202384',3937765,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202384',3937766,'1126','161',610473.51,610833.26,359.75,59358.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','202384',3937767,'1127','161',415948.72,415948.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202384',3937768,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202384',3937769,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202384',3937770,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202384',3937771,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202384',3937772,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202384',3937773,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202384',3937774,'1134','162',10189729.97,10189834.73,104.76,29332.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','202384',3937775,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202384',3937776,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202384',3937777,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202613',3941834,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202613',3941835,'1123','161',562126.21,562126.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202613',3941836,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202613',3941837,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202613',3941838,'1126','161',610833.26,610833.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202613',3941839,'1127','161',415948.72,415948.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202613',3941840,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202613',3941841,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202613',3941842,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202613',3941843,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202613',3941844,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202613',3941845,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202613',3941846,'1134','162',10189834.73,10190481.66,646.93,181140.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','202613',3941847,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202613',3941848,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202613',3941849,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202734',3943688,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202734',3943689,'1123','161',562126.21,562126.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202734',3943690,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202734',3943691,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202734',3943692,'1126','161',610833.26,610833.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202734',3943693,'1127','161',415948.72,415948.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202734',3943694,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202734',3943695,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202734',3943696,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202734',3943697,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202734',3943698,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202734',3943699,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202734',3943700,'1134','162',10190481.66,10190546.48,64.82,18149.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','202734',3943701,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202734',3943702,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202734',3943703,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202937',3947370,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202937',3947371,'1123','161',562126.21,562657.71,531.50,87697.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','202937',3947372,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202937',3947373,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202937',3947374,'1126','161',610833.26,610833.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202937',3947375,'1127','161',415948.72,416027.53,78.81,13003.65,0.00,0.00,0.00,0.00,0.00),('1','65','421','202937',3947376,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202937',3947377,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202937',3947378,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202937',3947379,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202937',3947380,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202937',3947381,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202937',3947382,'1134','162',10190546.48,10190898.71,352.23,98624.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','202937',3947383,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202937',3947384,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202937',3947385,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202957',3947768,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202957',3947769,'1123','161',562657.71,563503.94,826.23,136327.95,0.00,0.00,20.00,0.00,0.00),('1','65','420','202957',3947770,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202957',3947771,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','202957',3947772,'1126','161',610833.26,611407.30,564.04,93066.60,0.00,0.00,10.00,0.00,0.00),('1','65','420','202957',3947773,'1127','161',416027.53,416027.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202957',3947774,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202957',3947775,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202957',3947776,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202957',3947777,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202957',3947778,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','202957',3947779,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','202957',3947780,'1134','162',10190898.71,10191820.53,901.82,252509.60,0.00,0.00,20.00,0.00,0.00),('1','65','423','202957',3947781,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202957',3947782,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','202957',3947783,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203052',3949804,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203052',3949805,'1123','161',563503.94,564887.99,1384.05,228368.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','203052',3949806,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203052',3949807,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203052',3949808,'1126','161',611407.30,611799.30,392.00,64680.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203052',3949809,'1127','161',416027.53,416027.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203052',3949810,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203052',3949811,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203052',3949812,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203052',3949813,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203052',3949814,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203052',3949815,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203052',3949816,'1134','162',10191820.53,10192430.52,609.99,170797.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','203052',3949817,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203052',3949818,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203052',3949819,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203156',3951532,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203156',3951533,'1123','161',564887.99,565458.98,570.99,94213.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','203156',3951534,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203156',3951535,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203156',3951536,'1126','161',611799.30,612103.02,303.72,50113.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','203156',3951537,'1127','161',416027.53,416027.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203156',3951538,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203156',3951539,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203156',3951540,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203156',3951541,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203156',3951542,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203156',3951543,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203156',3951544,'1134','162',10192430.52,10192999.42,568.90,159292.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203156',3951545,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203156',3951546,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203156',3951547,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203171',3951861,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203171',3951862,'1123','161',565458.98,566151.54,692.56,114272.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','203171',3951863,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203171',3951864,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203171',3951865,'1126','161',612103.02,612103.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203171',3951866,'1127','161',416027.53,416269.22,241.69,39878.85,0.00,0.00,0.00,0.00,0.00),('1','65','421','203171',3951867,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203171',3951868,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203171',3951869,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203171',3951870,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203171',3951871,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203171',3951872,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203171',3951873,'1134','162',10192999.42,10193470.05,470.63,131776.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','203171',3951874,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203171',3951875,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203171',3951876,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203420',3956455,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203420',3956456,'1123','161',566151.54,567185.60,1034.06,170619.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','203420',3956457,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203420',3956458,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203420',3956459,'1126','161',612103.02,612337.27,234.25,38651.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','203420',3956460,'1127','161',416269.22,416269.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203420',3956461,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203420',3956462,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203420',3956463,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203420',3956464,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203420',3956465,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203420',3956466,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203420',3956467,'1134','162',10193470.05,10193873.85,403.80,113064.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203420',3956468,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203420',3956469,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203420',3956470,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203425',3956531,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203425',3956532,'1123','161',567185.60,567888.42,702.82,115965.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','203425',3956533,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203425',3956534,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203425',3956535,'1126','161',612337.27,612337.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203425',3956536,'1127','161',416269.22,416523.32,254.10,41926.50,0.00,0.00,0.00,0.00,0.00),('1','65','421','203425',3956537,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203425',3956538,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203425',3956539,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203425',3956540,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203425',3956541,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203425',3956542,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203425',3956543,'1134','162',10193873.85,10194051.53,167.68,46950.40,0.00,0.00,10.00,0.00,0.00),('1','65','423','203425',3956544,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203425',3956545,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203425',3956546,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203427',3956562,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203427',3956563,'1123','161',567888.42,568421.02,532.60,87879.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203427',3956564,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203427',3956565,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203427',3956566,'1126','161',612337.27,612681.91,344.64,56865.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','203427',3956567,'1127','161',416523.32,416526.35,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('1','65','421','203427',3956568,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203427',3956569,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203427',3956570,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203427',3956571,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203427',3956572,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203427',3956573,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203427',3956574,'1134','162',10194051.53,10194103.32,51.79,14501.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','203427',3956575,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203427',3956576,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203427',3956577,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203622',3960162,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203622',3960163,'1123','161',568421.02,569300.17,879.15,145059.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','203622',3960164,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203622',3960165,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203622',3960166,'1126','161',612681.91,612681.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203622',3960167,'1127','161',416526.35,416526.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203622',3960168,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203622',3960169,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203622',3960170,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203622',3960171,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203622',3960172,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203622',3960173,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203622',3960174,'1134','162',10194103.32,10194150.43,47.11,13190.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','203622',3960175,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203622',3960176,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203622',3960177,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203672',3961099,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203672',3961100,'1123','161',569300.17,570022.31,722.14,119153.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','203672',3961101,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203672',3961102,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203672',3961103,'1126','161',612681.91,612724.94,43.03,7099.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','203672',3961104,'1127','161',416526.35,416526.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203672',3961105,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203672',3961106,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203672',3961107,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203672',3961108,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203672',3961109,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203672',3961110,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203672',3961111,'1134','162',10194150.43,10195010.45,860.02,240805.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','203672',3961112,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203672',3961113,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203672',3961114,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203786',3962861,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203786',3962862,'1123','161',570022.31,570985.72,963.41,158962.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','203786',3962863,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203786',3962864,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203786',3962865,'1126','161',612724.94,612724.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','203786',3962866,'1127','161',416526.35,416654.27,127.92,21106.80,0.00,0.00,0.00,0.00,0.00),('1','65','421','203786',3962867,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203786',3962868,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203786',3962869,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203786',3962870,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203786',3962871,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','203786',3962872,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','203786',3962873,'1134','162',10195010.45,10195435.54,425.09,119025.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','203786',3962874,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203786',3962875,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','203786',3962876,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204027',3967120,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204027',3967121,'1123','161',570985.72,572021.36,1025.64,169230.60,0.00,0.00,10.00,0.00,0.00),('1','65','420','204027',3967122,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204027',3967123,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204027',3967124,'1126','161',612724.94,612814.81,79.87,13178.55,0.00,0.00,10.00,0.00,0.00),('1','65','420','204027',3967125,'1127','161',416654.27,416654.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204027',3967126,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204027',3967127,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204027',3967128,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204027',3967129,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204027',3967130,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204027',3967131,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204027',3967132,'1134','162',10195435.54,10196248.42,812.88,227606.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','204027',3967133,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204027',3967134,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204027',3967135,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204064',3967919,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204064',3967920,'1123','161',572021.36,572753.58,732.22,120816.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','204064',3967921,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204064',3967922,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204064',3967923,'1126','161',612814.81,612814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204064',3967924,'1127','161',416654.27,416701.17,46.90,7738.50,0.00,0.00,0.00,0.00,0.00),('1','65','421','204064',3967925,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204064',3967926,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204064',3967927,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204064',3967928,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204064',3967929,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204064',3967930,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204064',3967931,'1134','162',10196248.42,10196618.93,370.51,103742.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','204064',3967932,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204064',3967933,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204064',3967934,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204118',3969021,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204118',3969022,'1123','161',572753.58,573315.78,562.20,92763.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204118',3969023,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204118',3969024,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204118',3969025,'1126','161',612814.81,612909.35,94.54,15599.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','204118',3969026,'1127','161',416701.17,416701.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204118',3969027,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204118',3969028,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204118',3969029,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204118',3969030,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204118',3969031,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204118',3969032,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204118',3969033,'1134','162',10196618.93,10197311.11,692.18,193810.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','204118',3969034,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204118',3969035,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204118',3969036,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204278',3971847,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204278',3971848,'1123','161',573315.78,574062.48,746.70,123205.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','204278',3971849,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204278',3971850,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204278',3971851,'1126','161',612909.35,612909.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204278',3971852,'1127','161',416701.17,416854.78,153.61,25345.65,0.00,0.00,0.00,0.00,0.00),('1','65','421','204278',3971853,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204278',3971854,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204278',3971855,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204278',3971856,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204278',3971857,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204278',3971858,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204278',3971859,'1134','162',10197311.11,10198559.03,1247.92,349417.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','204278',3971860,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204278',3971861,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204278',3971862,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204318',3972553,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204318',3972554,'1123','161',574062.48,574774.60,712.12,117499.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','204318',3972555,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204318',3972556,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204318',3972557,'1126','161',612909.35,613024.70,115.35,19032.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','204318',3972558,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204318',3972559,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204318',3972560,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204318',3972561,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204318',3972562,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204318',3972563,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204318',3972564,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204318',3972565,'1134','162',10198559.03,10198765.90,206.87,57923.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','204318',3972566,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204318',3972567,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204318',3972568,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204475',3975352,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204475',3975353,'1123','161',574774.60,575807.79,1033.19,170476.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','204475',3975354,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204475',3975355,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204475',3975356,'1126','161',613024.70,614117.62,1092.92,180331.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','204475',3975357,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204475',3975358,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204475',3975359,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204475',3975360,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204475',3975361,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204475',3975362,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204475',3975363,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204475',3975364,'1134','162',10198765.90,10199742.40,976.50,273420.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204475',3975365,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204475',3975366,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204475',3975367,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204519',3976150,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204519',3976151,'1123','161',575807.79,576548.73,740.94,122255.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','204519',3976152,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204519',3976153,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204519',3976154,'1126','161',614117.62,614287.29,169.67,27995.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','204519',3976155,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204519',3976156,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204519',3976157,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204519',3976158,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204519',3976159,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204519',3976160,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204519',3976161,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204519',3976162,'1134','162',10199742.40,10200091.69,349.29,97801.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','204519',3976163,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204519',3976164,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204519',3976165,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204663',3978597,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204663',3978598,'1123','161',576548.73,577261.17,712.44,117552.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','204663',3978599,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204663',3978600,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204663',3978601,'1126','161',614287.29,614397.83,110.54,18239.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','204663',3978602,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204663',3978603,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204663',3978604,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204663',3978605,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204663',3978606,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204663',3978607,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204663',3978608,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204663',3978609,'1134','162',10200091.69,10200754.98,663.29,185721.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','204663',3978610,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204663',3978611,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204663',3978612,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204763',3980723,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204763',3980724,'1123','161',577261.17,577965.59,704.42,116229.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','204763',3980725,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204763',3980726,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204763',3980727,'1126','161',614397.83,614740.47,342.64,56535.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','204763',3980728,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204763',3980729,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204763',3980730,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204763',3980731,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204763',3980732,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204763',3980733,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204763',3980734,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204763',3980735,'1134','162',10200754.98,10201029.51,264.53,74068.40,0.00,0.00,10.00,0.00,0.00),('1','65','423','204763',3980736,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204763',3980737,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204763',3980738,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204908',3982733,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204908',3982734,'1123','161',577965.59,578710.44,744.85,122900.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','204908',3982735,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204908',3982736,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204908',3982737,'1126','161',614740.47,614812.75,72.28,11926.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','204908',3982738,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204908',3982739,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204908',3982740,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204908',3982741,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204908',3982742,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204908',3982743,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204908',3982744,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204908',3982745,'1134','162',10201029.51,10201169.33,139.82,39149.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','204908',3982746,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204908',3982747,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204908',3982748,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204949',3983429,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204949',3983430,'1123','161',578710.44,579419.06,708.62,116922.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','204949',3983431,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204949',3983432,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','204949',3983433,'1126','161',614812.75,614861.23,48.48,7999.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','204949',3983434,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204949',3983435,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204949',3983436,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204949',3983437,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204949',3983438,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204949',3983439,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','204949',3983440,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','204949',3983441,'1134','162',10201169.33,10201649.65,480.32,134489.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','204949',3983442,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204949',3983443,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','204949',3983444,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205194',3988185,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205194',3988186,'1123','161',579419.06,580014.47,595.41,98242.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','205194',3988187,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205194',3988188,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205194',3988189,'1126','161',614861.23,614938.57,77.34,12761.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','205194',3988190,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205194',3988191,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205194',3988192,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205194',3988193,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205194',3988194,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205194',3988195,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205194',3988196,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205194',3988197,'1134','162',10201649.65,10201844.76,195.11,54630.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','205194',3988198,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205194',3988199,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205194',3988200,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205289',3989595,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205289',3989596,'1123','161',580014.47,580810.52,786.05,129698.25,0.00,0.00,10.00,0.00,0.00),('1','65','420','205289',3989597,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205289',3989598,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205289',3989599,'1126','161',614938.57,615057.49,108.92,17971.80,0.00,0.00,10.00,0.00,0.00),('1','65','420','205289',3989600,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205289',3989601,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205289',3989602,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205289',3989603,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205289',3989604,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205289',3989605,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205289',3989606,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205289',3989607,'1134','162',10201844.76,10203381.45,1526.69,427473.20,0.00,0.00,10.00,0.00,0.00),('1','65','423','205289',3989608,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205289',3989609,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205289',3989610,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205321',3990157,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205321',3990158,'1123','161',580810.52,581619.33,808.81,133453.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','205321',3990159,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205321',3990160,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205321',3990161,'1126','161',615057.49,615101.38,43.89,7241.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','205321',3990162,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205321',3990163,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205321',3990164,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205321',3990165,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205321',3990166,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205321',3990167,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205321',3990168,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205321',3990169,'1134','162',10203381.45,10204499.11,1117.66,312944.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','205321',3990170,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205321',3990171,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205321',3990172,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205349',3990735,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205349',3990736,'1123','161',581619.33,582367.57,748.24,123459.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','205349',3990737,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205349',3990738,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205349',3990739,'1126','161',615101.38,615328.72,227.34,37511.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','205349',3990740,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205349',3990741,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205349',3990742,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205349',3990743,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205349',3990744,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205349',3990745,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205349',3990746,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205349',3990747,'1134','162',10204499.11,10205556.01,1056.90,295932.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205349',3990748,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205349',3990749,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205349',3990750,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205512',3993560,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205512',3993561,'1123','161',582367.57,583333.32,965.75,159348.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','205512',3993562,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205512',3993563,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205512',3993564,'1126','161',615328.72,615328.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205512',3993565,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205512',3993566,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205512',3993567,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205512',3993568,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205512',3993569,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205512',3993570,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205512',3993571,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205512',3993572,'1134','162',10205556.01,10207908.30,2352.29,658641.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','205512',3993573,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205512',3993574,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205512',3993575,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205540',3994146,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205540',3994147,'1123','161',583333.32,583333.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205540',3994148,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205540',3994149,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205540',3994150,'1126','161',615328.72,615328.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205540',3994151,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205540',3994152,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205540',3994153,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205540',3994154,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205540',3994155,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205540',3994156,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205540',3994157,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205540',3994158,'1134','162',10207908.30,10208052.00,133.70,37436.00,0.00,0.00,10.00,0.00,0.00),('1','65','423','205540',3994159,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205540',3994160,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205540',3994161,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205606',3995476,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205606',3995477,'1123','161',583333.32,583802.16,468.84,77358.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','205606',3995478,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205606',3995479,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205606',3995480,'1126','161',615328.72,615631.67,302.95,49986.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','205606',3995481,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205606',3995482,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205606',3995483,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205606',3995484,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205606',3995485,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205606',3995486,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205606',3995487,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205606',3995488,'1134','162',10208052.00,10208229.63,177.63,50624.55,0.00,0.00,0.00,0.00,0.00),('1','65','423','205606',3995489,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205606',3995490,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205606',3995491,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205654',3996613,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205654',3996614,'1123','161',583802.16,584465.90,663.74,109517.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','205654',3996615,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205654',3996616,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205654',3996617,'1126','161',615631.67,615750.02,108.35,17877.75,0.00,0.00,10.00,0.00,0.00),('1','65','420','205654',3996618,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205654',3996619,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205654',3996620,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205654',3996621,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205654',3996622,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205654',3996623,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205654',3996624,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205654',3996625,'1134','162',10208229.63,10208329.27,99.64,28397.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','205654',3996626,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205654',3996627,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205654',3996628,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205907',4000948,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205907',4000949,'1123','161',584465.90,585878.23,1412.33,233034.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','205907',4000950,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205907',4000951,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','205907',4000952,'1126','161',615750.02,616492.76,742.74,122552.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','205907',4000953,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205907',4000954,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205907',4000955,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205907',4000956,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205907',4000957,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205907',4000958,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','205907',4000959,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','205907',4000960,'1134','162',10208329.27,10208565.05,235.78,67197.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','205907',4000961,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205907',4000962,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','205907',4000963,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206012',4002692,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206012',4002693,'1123','161',585878.23,585878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206012',4002694,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206012',4002695,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206012',4002696,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206012',4002697,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206012',4002698,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206012',4002699,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206012',4002700,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206012',4002701,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206012',4002702,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206012',4002703,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206012',4002704,'1134','162',10208565.05,10208846.93,281.88,80335.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','206012',4002705,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206012',4002706,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206012',4002707,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206117',4004752,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206117',4004753,'1123','161',585878.23,585878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206117',4004754,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206117',4004755,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206117',4004756,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206117',4004757,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206117',4004758,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206117',4004759,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206117',4004760,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206117',4004761,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206117',4004762,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206117',4004763,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206117',4004764,'1134','162',10208846.93,10209506.40,644.47,183673.95,0.00,0.00,15.00,0.00,0.00),('1','65','423','206117',4004765,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206117',4004766,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206117',4004767,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206285',4007644,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206285',4007645,'1123','161',585878.23,585878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206285',4007646,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206285',4007647,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206285',4007648,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206285',4007649,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206285',4007650,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206285',4007651,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206285',4007652,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206285',4007653,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206285',4007654,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206285',4007655,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206285',4007656,'1134','162',10209506.40,10211406.73,1900.33,541594.05,0.00,0.00,0.00,0.00,0.00),('1','65','423','206285',4007657,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206285',4007658,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206285',4007659,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206318',4008246,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206318',4008247,'1123','161',585878.23,585878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206318',4008248,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206318',4008249,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206318',4008250,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206318',4008251,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206318',4008252,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206318',4008253,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206318',4008254,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206318',4008255,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206318',4008256,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206318',4008257,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206318',4008258,'1134','162',10211406.73,10211730.58,323.85,92297.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','206318',4008259,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206318',4008260,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206318',4008261,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206462',4010543,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206462',4010544,'1123','161',585878.23,585878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206462',4010545,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206462',4010546,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206462',4010547,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206462',4010548,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206462',4010549,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206462',4010550,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206462',4010551,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206462',4010552,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206462',4010553,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206462',4010554,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206462',4010555,'1134','162',10211730.58,10212003.67,273.09,77830.65,0.00,0.00,0.00,0.00,0.00),('1','65','423','206462',4010556,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206462',4010557,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206462',4010558,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206536',4012014,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206536',4012015,'1123','161',585878.23,585878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206536',4012016,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206536',4012017,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206536',4012018,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206536',4012019,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206536',4012020,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206536',4012021,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206536',4012022,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206536',4012023,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206536',4012024,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206536',4012025,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206536',4012026,'1134','162',10212003.67,10212567.35,563.68,160648.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','206536',4012027,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206536',4012028,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206536',4012029,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206658',4014032,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206658',4014033,'1123','161',585878.23,585878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206658',4014034,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206658',4014035,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206658',4014036,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206658',4014037,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206658',4014038,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206658',4014039,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206658',4014040,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206658',4014041,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206658',4014042,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206658',4014043,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206658',4014044,'1134','162',10212567.35,10212611.64,44.29,12622.65,0.00,0.00,0.00,0.00,0.00),('1','65','423','206658',4014045,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206658',4014046,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206658',4014047,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206893',4018176,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206893',4018177,'1123','161',585878.23,586175.83,297.60,49104.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206893',4018178,'1124','161',190120.72,190120.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206893',4018179,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206893',4018180,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206893',4018181,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206893',4018182,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206893',4018183,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206893',4018184,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206893',4018185,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206893',4018186,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206893',4018187,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206893',4018188,'1134','162',10212611.64,10212941.40,329.76,93981.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','206893',4018189,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206893',4018190,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206893',4018191,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206908',4018429,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206908',4018430,'1123','161',586175.83,586873.98,688.15,113544.75,0.00,0.00,10.00,0.00,0.00),('1','65','420','206908',4018431,'1124','161',190120.72,190336.33,205.61,33925.65,0.00,0.00,10.00,0.00,0.00),('1','65','420','206908',4018432,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206908',4018433,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206908',4018434,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206908',4018435,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206908',4018436,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206908',4018437,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206908',4018438,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206908',4018439,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206908',4018440,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206908',4018441,'1134','162',10212941.40,10214428.11,1476.71,420862.35,0.00,0.00,10.00,0.00,0.00),('1','65','423','206908',4018442,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206908',4018443,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206908',4018444,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206937',4019072,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206937',4019073,'1123','161',586873.98,587164.02,290.04,47856.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','206937',4019074,'1124','161',190336.33,190889.55,553.22,91281.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','206937',4019075,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206937',4019076,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','206937',4019077,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206937',4019078,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206937',4019079,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206937',4019080,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206937',4019081,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206937',4019082,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','206937',4019083,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','206937',4019084,'1134','162',10214428.11,10215826.41,1398.30,398515.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','206937',4019085,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206937',4019086,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','206937',4019087,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207106',4021923,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207106',4021924,'1123','161',587164.02,587794.67,630.65,104057.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','207106',4021925,'1124','161',190889.55,190971.37,81.82,13500.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','207106',4021926,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207106',4021927,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207106',4021928,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207106',4021929,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207106',4021930,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207106',4021931,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207106',4021932,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207106',4021933,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207106',4021934,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207106',4021935,'1134','162',10215826.41,10216142.73,316.32,90151.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','207106',4021936,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207106',4021937,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207106',4021938,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207166',4023148,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207166',4023149,'1123','161',587794.67,588404.45,609.78,100613.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','207166',4023150,'1124','161',190971.37,190971.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207166',4023151,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207166',4023152,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207166',4023153,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207166',4023154,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207166',4023155,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207166',4023156,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207166',4023157,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207166',4023158,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207166',4023159,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207166',4023160,'1134','162',10216142.73,10216651.71,508.98,145059.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','207166',4023161,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207166',4023162,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207166',4023163,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207312',4025698,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207312',4025699,'1123','161',588404.45,588914.90,510.45,84224.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','207312',4025700,'1124','161',190971.37,191266.31,294.94,48665.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','207312',4025701,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207312',4025702,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207312',4025703,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207312',4025704,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207312',4025705,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207312',4025706,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207312',4025707,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207312',4025708,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207312',4025709,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207312',4025710,'1134','162',10216651.71,10216674.16,22.45,6398.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','207312',4025711,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207312',4025712,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207312',4025713,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207448',4028272,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207448',4028273,'1123','161',588914.90,589746.63,821.73,135585.45,0.00,0.00,10.00,0.00,0.00),('1','65','420','207448',4028274,'1124','161',191266.31,192282.01,1005.70,165940.50,0.00,0.00,10.00,0.00,0.00),('1','65','420','207448',4028275,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207448',4028276,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207448',4028277,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207448',4028278,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207448',4028279,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207448',4028280,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207448',4028281,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207448',4028282,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207448',4028283,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207448',4028284,'1134','162',10216674.16,10217126.78,442.62,126146.70,0.00,0.00,10.00,0.00,0.00),('1','65','423','207448',4028285,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207448',4028286,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207448',4028287,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207558',4030077,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207558',4030078,'1123','161',589746.63,590229.76,483.13,79716.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','207558',4030079,'1124','161',192282.01,192616.43,334.42,55179.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','207558',4030080,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207558',4030081,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207558',4030082,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207558',4030083,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207558',4030084,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207558',4030085,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207558',4030086,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207558',4030087,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207558',4030088,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207558',4030089,'1134','162',10217126.78,10217308.96,182.18,51921.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','207558',4030090,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207558',4030091,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207558',4030092,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207606',4030997,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207606',4030998,'1123','161',590229.76,590841.11,611.35,100872.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','207606',4030999,'1124','161',192616.43,193182.49,566.06,93399.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','207606',4031000,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207606',4031001,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207606',4031002,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207606',4031003,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207606',4031004,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207606',4031005,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207606',4031006,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207606',4031007,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207606',4031008,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207606',4031009,'1134','162',10217308.96,10217351.41,42.45,12098.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','207606',4031010,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207606',4031011,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207606',4031012,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207765',4033584,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207765',4033585,'1123','161',590841.11,591371.27,530.16,87476.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','207765',4033586,'1124','161',193182.49,193599.71,417.22,68841.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','207765',4033587,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207765',4033588,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207765',4033589,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207765',4033590,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207765',4033591,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207765',4033592,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207765',4033593,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207765',4033594,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207765',4033595,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207765',4033596,'1134','162',10217351.41,10217518.79,167.38,47703.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','207765',4033597,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207765',4033598,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207765',4033599,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207813',4034398,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207813',4034399,'1123','161',591371.27,591995.69,624.42,103029.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','207813',4034400,'1124','161',193599.71,194107.09,507.38,83717.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','207813',4034401,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207813',4034402,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207813',4034403,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207813',4034404,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207813',4034405,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207813',4034406,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207813',4034407,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207813',4034408,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207813',4034409,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207813',4034410,'1134','162',10217518.79,10217685.80,167.01,47597.85,0.00,0.00,0.00,0.00,0.00),('1','65','423','207813',4034411,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207813',4034412,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207813',4034413,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207975',4037171,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207975',4037172,'1123','161',591995.69,592568.30,572.61,94480.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','207975',4037173,'1124','161',194107.09,194427.77,320.68,52912.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','207975',4037174,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207975',4037175,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','207975',4037176,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207975',4037177,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207975',4037178,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207975',4037179,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207975',4037180,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207975',4037181,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','207975',4037182,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','207975',4037183,'1134','162',10217685.80,10217976.43,290.63,82829.55,0.00,0.00,0.00,0.00,0.00),('1','65','423','207975',4037184,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207975',4037185,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','207975',4037186,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208072',4038930,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208072',4038931,'1123','161',592568.30,593197.85,619.55,102225.75,0.00,0.00,10.00,0.00,0.00),('1','65','420','208072',4038932,'1124','161',194427.77,194842.99,405.22,66861.30,0.00,0.00,10.00,0.00,0.00),('1','65','420','208072',4038933,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208072',4038934,'1126','161',616492.76,616492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208072',4038935,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208072',4038936,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208072',4038937,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208072',4038938,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208072',4038939,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208072',4038940,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208072',4038941,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208072',4038942,'1134','162',10217976.43,10218776.51,790.08,225172.80,0.00,0.00,10.00,0.00,0.00),('1','65','423','208072',4038943,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208072',4038944,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208072',4038945,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208169',4040548,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208169',4040549,'1123','161',593197.85,593211.75,13.90,2293.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','208169',4040550,'1124','161',194842.99,195528.14,685.15,113049.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','208169',4040551,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208169',4040552,'1126','161',616492.76,616665.68,172.92,28531.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','208169',4040553,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208169',4040554,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208169',4040555,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208169',4040556,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208169',4040557,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208169',4040558,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208169',4040559,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208169',4040560,'1134','162',10218776.51,10218841.76,65.25,18596.25,0.00,0.00,0.00,0.00,0.00),('1','65','423','208169',4040561,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208169',4040562,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208169',4040563,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208402',4044829,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208402',4044830,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208402',4044831,'1124','161',195528.14,195528.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208402',4044832,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208402',4044833,'1126','161',616665.68,617474.64,808.96,133478.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','208402',4044834,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208402',4044835,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208402',4044836,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208402',4044837,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208402',4044838,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208402',4044839,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208402',4044840,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208402',4044841,'1134','162',10218841.76,10219133.53,291.77,83154.45,0.00,0.00,0.00,0.00,0.00),('1','65','423','208402',4044842,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208402',4044843,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208402',4044844,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208420',4045096,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208420',4045097,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208420',4045098,'1124','161',195528.14,196335.92,807.78,133283.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','208420',4045099,'1125','161',244060.32,244060.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208420',4045100,'1126','161',617474.64,617868.10,393.46,64920.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','208420',4045101,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208420',4045102,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208420',4045103,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208420',4045104,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208420',4045105,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208420',4045106,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208420',4045107,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208420',4045108,'1134','162',10219133.53,10219602.31,468.78,133602.30,0.00,0.00,0.00,0.00,0.00),('1','65','423','208420',4045109,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208420',4045110,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208420',4045111,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208460',4045685,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208460',4045686,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208460',4045687,'1124','161',196335.92,197079.52,743.60,122694.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208460',4045688,'1125','161',244060.32,244062.98,2.66,438.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','208460',4045689,'1126','161',617868.10,617957.58,89.48,14764.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','208460',4045690,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208460',4045691,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208460',4045692,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208460',4045693,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208460',4045694,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208460',4045695,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208460',4045696,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208460',4045697,'1134','162',10219602.31,10221028.65,1426.34,406506.90,0.00,0.00,0.00,0.00,0.00),('1','65','423','208460',4045698,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208460',4045699,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208460',4045700,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208624',4048605,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208624',4048606,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208624',4048607,'1124','161',197079.52,197505.92,426.40,70356.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208624',4048608,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208624',4048609,'1126','161',617957.58,618271.72,314.14,51833.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','208624',4048610,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208624',4048611,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208624',4048612,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208624',4048613,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208624',4048614,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208624',4048615,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208624',4048616,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208624',4048617,'1134','162',10221028.65,10221049.11,20.46,5831.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','208624',4048618,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208624',4048619,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208624',4048620,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208663',4049301,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208663',4049302,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208663',4049303,'1124','161',197505.92,197505.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208663',4049304,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208663',4049305,'1126','161',618271.72,619106.13,834.41,137677.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','208663',4049306,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208663',4049307,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208663',4049308,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208663',4049309,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208663',4049310,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208663',4049311,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208663',4049312,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208663',4049313,'1134','162',10221049.11,10221830.86,781.75,222798.75,0.00,0.00,0.00,0.00,0.00),('1','65','423','208663',4049314,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208663',4049315,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208663',4049316,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208719',4050419,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208719',4050420,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208719',4050421,'1124','161',197505.92,197715.03,209.11,34503.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','208719',4050422,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208719',4050423,'1126','161',619106.13,619459.81,353.68,58357.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','208719',4050424,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208719',4050425,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208719',4050426,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208719',4050427,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208719',4050428,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208719',4050429,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208719',4050430,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208719',4050431,'1134','162',10221830.86,10223000.62,1169.76,333381.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','208719',4050432,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208719',4050433,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208719',4050434,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208906',4053571,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208906',4053572,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208906',4053573,'1124','161',197715.03,197715.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208906',4053574,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','208906',4053575,'1126','161',619459.81,620087.77,627.96,103613.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','208906',4053576,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208906',4053577,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208906',4053578,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208906',4053579,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208906',4053580,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208906',4053581,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','208906',4053582,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','208906',4053583,'1134','162',10223000.62,10224407.46,1406.84,400949.40,0.00,0.00,0.00,0.00,0.00),('1','65','423','208906',4053584,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208906',4053585,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','208906',4053586,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209053',4055956,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209053',4055957,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209053',4055958,'1124','161',197715.03,198975.26,1250.23,206287.95,0.00,0.00,10.00,0.00,0.00),('1','65','420','209053',4055959,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209053',4055960,'1126','161',620087.77,620942.57,844.80,139392.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','209053',4055961,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209053',4055962,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209053',4055963,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209053',4055964,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209053',4055965,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209053',4055966,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209053',4055967,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209053',4055968,'1134','162',10224407.46,10224624.41,206.95,58980.75,0.00,0.00,10.00,0.00,0.00),('1','65','423','209053',4055969,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209053',4055970,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209053',4055971,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209111',4056983,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209111',4056984,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209111',4056985,'1124','161',198975.26,198975.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209111',4056986,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209111',4056987,'1126','161',620942.57,621639.57,697.00,115005.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209111',4056988,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209111',4056989,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209111',4056990,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209111',4056991,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209111',4056992,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209111',4056993,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209111',4056994,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209111',4056995,'1134','162',10224624.41,10225044.57,420.16,119745.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','209111',4056996,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209111',4056997,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209111',4056998,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209260',4059649,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209260',4059650,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209260',4059651,'1124','161',198975.26,199364.26,389.00,64185.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209260',4059652,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209260',4059653,'1126','161',621639.57,621927.47,287.90,47503.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','209260',4059654,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209260',4059655,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209260',4059656,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209260',4059657,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209260',4059658,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209260',4059659,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209260',4059660,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209260',4059661,'1134','162',10225044.57,10225155.27,110.70,31549.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','209260',4059662,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209260',4059663,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209260',4059664,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209384',4062018,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209384',4062019,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209384',4062020,'1124','161',199364.26,199364.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209384',4062021,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209384',4062022,'1126','161',621927.47,622603.08,675.61,111475.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','209384',4062023,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209384',4062024,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209384',4062025,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209384',4062026,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209384',4062027,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209384',4062028,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209384',4062029,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209384',4062030,'1134','162',10225155.27,10225493.55,338.28,96409.80,0.00,0.00,0.00,0.00,0.00),('1','65','423','209384',4062031,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209384',4062032,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209384',4062033,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209542',4064648,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209542',4064649,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209542',4064650,'1124','161',199364.26,199704.35,340.09,56114.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','209542',4064651,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209542',4064652,'1126','161',622603.08,622837.01,233.93,38598.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','209542',4064653,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209542',4064654,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209542',4064655,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209542',4064656,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209542',4064657,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209542',4064658,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209542',4064659,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209542',4064660,'1134','162',10225493.55,10226220.07,726.52,207058.20,0.00,0.00,0.00,0.00,0.00),('1','65','423','209542',4064661,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209542',4064662,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209542',4064663,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209561',4064965,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209561',4064966,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209561',4064967,'1124','161',199704.35,199704.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209561',4064968,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209561',4064969,'1126','161',622837.01,622837.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209561',4064970,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209561',4064971,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209561',4064972,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209561',4064973,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209561',4064974,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209561',4064975,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209561',4064976,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209561',4064977,'1134','162',10226220.07,10226274.21,54.14,15700.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','209561',4064978,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209561',4064979,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209561',4064980,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209708',4067697,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209708',4067698,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209708',4067699,'1124','161',199704.35,199704.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209708',4067700,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209708',4067701,'1126','161',622837.01,622837.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209708',4067702,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209708',4067703,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209708',4067704,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209708',4067705,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209708',4067706,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209708',4067707,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209708',4067708,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209708',4067709,'1134','162',10226274.21,10226702.11,427.90,124091.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209708',4067710,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209708',4067711,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209708',4067712,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209937',4071806,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209937',4071807,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209937',4071808,'1124','161',199704.35,199704.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209937',4071809,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209937',4071810,'1126','161',622837.01,622837.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209937',4071811,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209937',4071812,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209937',4071813,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209937',4071814,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209937',4071815,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209937',4071816,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209937',4071817,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209937',4071818,'1134','162',10226702.11,10227376.04,673.93,195439.70,0.00,0.00,0.00,0.00,0.00),('1','65','423','209937',4071819,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209937',4071820,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209937',4071821,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209943',4071928,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209943',4071929,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209943',4071930,'1124','161',199704.35,199704.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209943',4071931,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209943',4071932,'1126','161',622837.01,622837.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209943',4071933,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209943',4071934,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209943',4071935,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209943',4071936,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209943',4071937,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209943',4071938,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209943',4071939,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209943',4071940,'1134','162',10227376.04,10229693.68,2317.64,672115.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','209943',4071941,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209943',4071942,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209943',4071943,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209945',4071963,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209945',4071964,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209945',4071965,'1124','161',199704.35,199704.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209945',4071966,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209945',4071967,'1126','161',622837.01,622837.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','209945',4071968,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209945',4071969,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209945',4071970,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209945',4071971,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209945',4071972,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209945',4071973,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','209945',4071974,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209945',4071975,'1134','162',10229693.68,10230500.58,806.90,234001.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','209945',4071976,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209945',4071977,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','209945',4071978,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210157',4075536,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210157',4075537,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210157',4075538,'1124','161',199704.35,199704.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210157',4075539,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210157',4075540,'1126','161',622837.01,622837.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210157',4075541,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210157',4075542,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210157',4075543,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210157',4075544,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210157',4075545,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210157',4075546,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210157',4075547,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210157',4075548,'1134','162',10230500.58,10230888.48,387.90,112491.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210157',4075549,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210157',4075550,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210157',4075551,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210205',4076394,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210205',4076395,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210205',4076396,'1124','161',199704.35,199704.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210205',4076397,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210205',4076398,'1126','161',622837.01,622837.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210205',4076399,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210205',4076400,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210205',4076401,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210205',4076402,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210205',4076403,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210205',4076404,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210205',4076405,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210205',4076406,'1134','162',10230888.48,10232254.87,1366.39,396253.10,0.00,0.00,0.00,0.00,0.00),('1','65','423','210205',4076407,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210205',4076408,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210205',4076409,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210259',4077467,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210259',4077468,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210259',4077469,'1124','161',199704.35,200060.28,355.93,58728.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','210259',4077470,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210259',4077471,'1126','161',622837.01,623099.23,262.22,43266.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','210259',4077472,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210259',4077473,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210259',4077474,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210259',4077475,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210259',4077476,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210259',4077477,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210259',4077478,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210259',4077479,'1134','162',10232254.87,10232653.11,398.24,115489.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','210259',4077480,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210259',4077481,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210259',4077482,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210439',4080705,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210439',4080706,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210439',4080707,'1124','161',200060.28,200060.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210439',4080708,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210439',4080709,'1126','161',623099.23,623756.07,656.84,108378.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','210439',4080710,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210439',4080711,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210439',4080712,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210439',4080713,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210439',4080714,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210439',4080715,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210439',4080716,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210439',4080717,'1134','162',10232653.11,10233970.85,1317.74,382144.60,0.00,0.00,0.00,0.00,0.00),('1','65','423','210439',4080718,'1135','162',511302.31,511302.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210439',4080719,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210439',4080720,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210591',4083416,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210591',4083417,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210591',4083418,'1124','161',200060.28,201121.92,1051.64,173520.60,0.00,0.00,10.00,0.00,0.00),('1','65','420','210591',4083419,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210591',4083420,'1126','161',623756.07,624961.11,1195.04,197181.60,0.00,0.00,10.00,0.00,0.00),('1','65','420','210591',4083421,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210591',4083422,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210591',4083423,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210591',4083424,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210591',4083425,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210591',4083426,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210591',4083427,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210591',4083428,'1134','162',10233970.85,10234005.84,24.99,7247.10,0.00,0.00,10.00,0.00,0.00),('1','65','423','210591',4083429,'1135','162',511302.31,512486.88,1174.57,340625.30,0.00,0.00,10.00,0.00,0.00),('1','65','424','210591',4083430,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210591',4083431,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210632',4084209,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210632',4084210,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210632',4084211,'1124','161',201121.92,201458.34,336.42,55509.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','210632',4084212,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210632',4084213,'1126','161',624961.11,625245.71,284.60,46959.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210632',4084214,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210632',4084215,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210632',4084216,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210632',4084217,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210632',4084218,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210632',4084219,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210632',4084220,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210632',4084221,'1134','162',10234005.84,10234005.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210632',4084222,'1135','162',512486.88,514997.81,2510.93,728169.70,0.00,0.00,0.00,0.00,0.00),('1','65','424','210632',4084223,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210632',4084224,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210787',4086869,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210787',4086870,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210787',4086871,'1124','161',201458.34,201866.41,408.07,67331.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','210787',4086872,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210787',4086873,'1126','161',625245.71,625724.02,478.31,78921.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','210787',4086874,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210787',4086875,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210787',4086876,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210787',4086877,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210787',4086878,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210787',4086879,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210787',4086880,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210787',4086881,'1134','162',10234005.84,10234005.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210787',4086882,'1135','162',514997.81,516237.85,1240.04,359611.60,0.00,0.00,0.00,0.00,0.00),('1','65','424','210787',4086883,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210787',4086884,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210887',4088687,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210887',4088688,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210887',4088689,'1124','161',201866.41,201866.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210887',4088690,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','210887',4088691,'1126','161',625724.02,626819.43,1095.41,180742.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','210887',4088692,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210887',4088693,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210887',4088694,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210887',4088695,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210887',4088696,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210887',4088697,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','210887',4088698,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210887',4088699,'1134','162',10234005.84,10234005.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','210887',4088700,'1135','162',516237.85,517187.48,949.63,275392.70,0.00,0.00,0.00,0.00,0.00),('1','65','424','210887',4088701,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','210887',4088702,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211010',4090501,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211010',4090502,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211010',4090503,'1124','161',201866.41,202039.89,173.48,28624.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','211010',4090504,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211010',4090505,'1126','161',626819.43,627491.80,672.37,110941.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','211010',4090506,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211010',4090507,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211010',4090508,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211010',4090509,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211010',4090510,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211010',4090511,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211010',4090512,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211010',4090513,'1134','162',10234005.84,10234005.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211010',4090514,'1135','162',517187.48,519567.68,2380.20,690258.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','211010',4090515,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','211010',4090516,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211094',4092261,'1122','161',801352.73,801352.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211094',4092262,'1123','161',593211.75,593211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211094',4092263,'1124','161',202039.89,202039.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211094',4092264,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211094',4092265,'1126','161',627491.80,628274.80,783.00,129195.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211094',4092266,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211094',4092267,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211094',4092268,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211094',4092269,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211094',4092270,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211094',4092271,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211094',4092272,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211094',4092273,'1134','162',10234005.84,10234074.44,68.60,19894.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211094',4092274,'1135','162',519567.68,519575.83,8.15,2363.50,0.00,0.00,0.00,0.00,0.00),('1','65','424','211094',4092275,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','211094',4092276,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211341',4096740,'1122','161',801352.73,801644.74,292.01,48181.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','211341',4096741,'1123','161',593211.75,593861.67,649.92,107236.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','211341',4096742,'1124','161',202039.89,202039.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211341',4096743,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211341',4096744,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211341',4096745,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211341',4096746,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211341',4096747,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211341',4096748,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211341',4096749,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211341',4096750,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211341',4096751,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211341',4096752,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211341',4096753,'1135','162',519575.83,519575.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','211341',4096754,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','211341',4096755,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211364',4097191,'1122','161',801644.74,801644.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211364',4097192,'1123','161',593861.67,594487.25,625.58,103220.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','211364',4097193,'1124','161',202039.89,202215.82,175.93,29028.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','211364',4097194,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211364',4097195,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211364',4097196,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211364',4097197,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211364',4097198,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211364',4097199,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211364',4097200,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211364',4097201,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211364',4097202,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211364',4097203,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211364',4097204,'1135','162',519575.83,520638.20,1062.37,308087.30,0.00,0.00,0.00,0.00,0.00),('1','65','424','211364',4097205,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','211364',4097206,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211516',4099609,'1122','161',801644.74,801644.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211516',4099610,'1123','161',594487.25,595264.47,777.22,128241.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','211516',4099611,'1124','161',202215.82,202755.18,539.36,88994.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','211516',4099612,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211516',4099613,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','211516',4099614,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211516',4099615,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211516',4099616,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211516',4099617,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211516',4099618,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211516',4099619,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','211516',4099620,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211516',4099621,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','211516',4099622,'1135','162',520638.20,521950.43,1312.23,380546.70,0.00,0.00,0.00,0.00,0.00),('1','65','424','211516',4099623,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','211516',4099624,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212076',4109404,'1122','161',801644.74,802240.49,595.75,98298.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','212076',4109405,'1123','161',595264.47,595264.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212076',4109406,'1124','161',202755.18,202909.40,154.22,25446.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','212076',4109407,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212076',4109408,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212076',4109409,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212076',4109410,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212076',4109411,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212076',4109412,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212076',4109413,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212076',4109414,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212076',4109415,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212076',4109416,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212076',4109417,'1135','162',521950.43,522107.32,156.89,45498.10,0.00,0.00,0.00,0.00,0.00),('1','65','424','212076',4109418,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212076',4109419,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212218',4112025,'1122','161',802240.49,802240.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212218',4112026,'1123','161',595264.47,596611.37,1346.90,222238.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','212218',4112027,'1124','161',202909.40,202909.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212218',4112028,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212218',4112029,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212218',4112030,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212218',4112031,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212218',4112032,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212218',4112033,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212218',4112034,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212218',4112035,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212218',4112036,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212218',4112037,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212218',4112038,'1135','162',522107.32,522472.11,364.79,107613.05,0.00,0.00,0.00,0.00,0.00),('1','65','424','212218',4112039,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212218',4112040,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212272',4112755,'1122','161',802240.49,805184.04,2943.55,485685.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','212272',4112756,'1123','161',596611.37,596611.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212272',4112757,'1124','161',202909.40,202909.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212272',4112758,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212272',4112759,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212272',4112760,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212272',4112761,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212272',4112762,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212272',4112763,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212272',4112764,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212272',4112765,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212272',4112766,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212272',4112767,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212272',4112768,'1135','162',522472.11,523309.48,837.37,247024.15,0.00,0.00,0.00,0.00,0.00),('1','65','424','212272',4112769,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212272',4112770,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212274',4112803,'1122','161',805184.04,805892.44,708.40,116886.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212274',4112804,'1123','161',596611.37,596611.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212274',4112805,'1124','161',202909.40,202909.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212274',4112806,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212274',4112807,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212274',4112808,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212274',4112809,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212274',4112810,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212274',4112811,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212274',4112812,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212274',4112813,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212274',4112814,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212274',4112815,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212274',4112816,'1135','162',523309.48,523317.46,7.98,2354.10,0.00,0.00,0.00,0.00,0.00),('1','65','424','212274',4112817,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212274',4112818,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212297',4113293,'1122','161',805892.44,806511.22,618.78,102098.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','212297',4113294,'1123','161',596611.37,596611.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212297',4113295,'1124','161',202909.40,202915.46,6.06,999.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','212297',4113296,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212297',4113297,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212297',4113298,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212297',4113299,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212297',4113300,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212297',4113301,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212297',4113302,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212297',4113303,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212297',4113304,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212297',4113305,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212297',4113306,'1135','162',523317.46,523461.45,143.99,42477.05,0.00,0.00,0.00,0.00,0.00),('1','65','424','212297',4113307,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212297',4113308,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212312',4113579,'1122','161',806511.22,806511.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212312',4113580,'1123','161',596611.37,597264.48,653.11,107763.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','212312',4113581,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212312',4113582,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212312',4113583,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212312',4113584,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212312',4113585,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212312',4113586,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212312',4113587,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212312',4113588,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212312',4113589,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212312',4113590,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212312',4113591,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212312',4113592,'1135','162',523461.45,523505.36,43.91,12953.45,0.00,0.00,0.00,0.00,0.00),('1','65','424','212312',4113593,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212312',4113594,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212320',4113751,'1122','161',806511.22,807425.76,914.54,150899.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','212320',4113752,'1123','161',597264.48,597264.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212320',4113753,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212320',4113754,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212320',4113755,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212320',4113756,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212320',4113757,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212320',4113758,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212320',4113759,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212320',4113760,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212320',4113761,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212320',4113762,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212320',4113763,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212320',4113764,'1135','162',523505.36,523540.70,35.34,10425.30,0.00,0.00,0.00,0.00,0.00),('1','65','424','212320',4113765,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212320',4113766,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212325',4113844,'1122','161',807425.76,809147.67,1721.91,284115.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','212325',4113845,'1123','161',597264.48,597422.30,157.82,26040.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','212325',4113846,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212325',4113847,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212325',4113848,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212325',4113849,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212325',4113850,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212325',4113851,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212325',4113852,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212325',4113853,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212325',4113854,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212325',4113855,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212325',4113856,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212325',4113857,'1135','162',523540.70,523704.02,163.32,48179.40,0.00,0.00,0.00,0.00,0.00),('1','65','424','212325',4113858,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212325',4113859,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212380',4114876,'1122','161',809147.67,809738.39,590.72,97468.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','212380',4114877,'1123','161',597422.30,597940.93,518.63,85573.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','212380',4114878,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212380',4114879,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212380',4114880,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212380',4114881,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212380',4114882,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212380',4114883,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212380',4114884,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212380',4114885,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212380',4114886,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212380',4114887,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212380',4114888,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212380',4114889,'1135','162',523704.02,524388.43,684.41,201900.95,0.00,0.00,0.00,0.00,0.00),('1','65','424','212380',4114890,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212380',4114891,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212542',4117791,'1122','161',809738.39,809738.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212542',4117792,'1123','161',597940.93,598690.75,749.82,123720.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','212542',4117793,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212542',4117794,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212542',4117795,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212542',4117796,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212542',4117797,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212542',4117798,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212542',4117799,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212542',4117800,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212542',4117801,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212542',4117802,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212542',4117803,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212542',4117804,'1135','162',524388.43,524629.13,240.70,71006.50,0.00,0.00,0.00,0.00,0.00),('1','65','424','212542',4117805,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212542',4117806,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212587',4118612,'1122','161',809738.39,809738.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212587',4118613,'1123','161',598690.75,599879.65,1188.90,196168.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','212587',4118614,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212587',4118615,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212587',4118616,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212587',4118617,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212587',4118618,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212587',4118619,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212587',4118620,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212587',4118621,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212587',4118622,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212587',4118623,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212587',4118624,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212587',4118625,'1135','162',524629.13,525515.92,886.79,261603.05,0.00,0.00,0.00,0.00,0.00),('1','65','424','212587',4118626,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212587',4118627,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212645',4119797,'1122','161',809738.39,809894.94,156.55,25830.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','212645',4119798,'1123','161',599879.65,600693.08,813.43,134215.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','212645',4119799,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212645',4119800,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212645',4119801,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212645',4119802,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212645',4119803,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212645',4119804,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212645',4119805,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212645',4119806,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212645',4119807,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212645',4119808,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212645',4119809,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212645',4119810,'1135','162',525515.92,526050.63,534.71,157739.45,0.00,0.00,0.00,0.00,0.00),('1','65','424','212645',4119811,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212645',4119812,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212890',4123854,'1122','161',809894.94,810415.23,520.29,85847.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','212890',4123855,'1123','161',600693.08,601161.09,468.01,77221.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','212890',4123856,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212890',4123857,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212890',4123858,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212890',4123859,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212890',4123860,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212890',4123861,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212890',4123862,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212890',4123863,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212890',4123864,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212890',4123865,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212890',4123866,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212890',4123867,'1135','162',526050.63,527512.51,1461.88,431254.60,0.00,0.00,0.00,0.00,0.00),('1','65','424','212890',4123868,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212890',4123869,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212931',4124639,'1122','161',810415.23,810415.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212931',4124640,'1123','161',601161.09,602212.51,1051.42,173484.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','212931',4124641,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212931',4124642,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212931',4124643,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','212931',4124644,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212931',4124645,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212931',4124646,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212931',4124647,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212931',4124648,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212931',4124649,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','212931',4124650,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212931',4124651,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','212931',4124652,'1135','162',527512.51,527838.61,326.10,96199.50,0.00,0.00,0.00,0.00,0.00),('1','65','424','212931',4124653,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','212931',4124654,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213149',4128342,'1122','161',810415.23,810415.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213149',4128343,'1123','161',602212.51,603140.51,928.00,153120.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213149',4128344,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213149',4128345,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213149',4128346,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213149',4128347,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213149',4128348,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213149',4128349,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213149',4128350,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213149',4128351,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213149',4128352,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213149',4128353,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213149',4128354,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213149',4128355,'1135','162',527838.61,528137.26,298.65,88101.75,0.00,0.00,0.00,0.00,0.00),('1','65','424','213149',4128356,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213149',4128357,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213266',4130299,'1122','161',810415.23,811352.62,937.39,154669.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','213266',4130300,'1123','161',603140.51,603140.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213266',4130301,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213266',4130302,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213266',4130303,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213266',4130304,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213266',4130305,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213266',4130306,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213266',4130307,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213266',4130308,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213266',4130309,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213266',4130310,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213266',4130311,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213266',4130312,'1135','162',528137.26,528228.86,91.60,27022.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213266',4130313,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213266',4130314,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213348',4131770,'1122','161',811352.62,811995.88,643.26,106137.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','213348',4131771,'1123','161',603140.51,603140.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213348',4131772,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213348',4131773,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213348',4131774,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213348',4131775,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213348',4131776,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213348',4131777,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213348',4131778,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213348',4131779,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213348',4131780,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213348',4131781,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213348',4131782,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213348',4131783,'1135','162',528228.86,528918.02,689.16,203302.20,0.00,0.00,0.00,0.00,0.00),('1','65','424','213348',4131784,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213348',4131785,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213449',4133262,'1122','161',811995.88,812816.65,820.77,135427.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','213449',4133263,'1123','161',603140.51,603710.92,570.41,94117.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','213449',4133264,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213449',4133265,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213449',4133266,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213449',4133267,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213449',4133268,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213449',4133269,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213449',4133270,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213449',4133271,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213449',4133272,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213449',4133273,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213449',4133274,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213449',4133275,'1135','162',528918.02,530347.49,1429.47,421693.65,0.00,0.00,0.00,0.00,0.00),('1','65','424','213449',4133276,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213449',4133277,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213535',4134767,'1122','161',812816.65,813830.68,1014.03,167314.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','213535',4134768,'1123','161',603710.92,603765.46,54.54,8999.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','213535',4134769,'1124','161',202915.46,202915.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213535',4134770,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213535',4134771,'1126','161',628274.80,628274.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213535',4134772,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213535',4134773,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213535',4134774,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213535',4134775,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213535',4134776,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213535',4134777,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213535',4134778,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213535',4134779,'1134','162',10234074.44,10234074.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213535',4134780,'1135','162',530347.49,530506.67,159.18,46958.10,0.00,0.00,0.00,0.00,0.00),('1','65','424','213535',4134781,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213535',4134782,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213717',4137859,'1122','161',813830.68,814271.82,441.14,72788.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','213717',4137860,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213717',4137861,'1124','161',202915.46,203438.62,523.16,86321.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','213717',4137862,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213717',4137863,'1126','161',628274.80,629113.86,839.06,138444.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','213717',4137864,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213717',4137865,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213717',4137866,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213717',4137867,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213717',4137868,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213717',4137869,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213717',4137870,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213717',4137871,'1134','162',10234074.44,10235207.14,1132.70,334146.50,0.00,0.00,0.00,0.00,0.00),('1','65','423','213717',4137872,'1135','162',530506.67,532106.56,1599.89,471967.55,0.00,0.00,0.00,0.00,0.00),('1','65','424','213717',4137873,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213717',4137874,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213839',4139888,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213839',4139889,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213839',4139890,'1124','161',203438.62,204723.63,1285.01,212026.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','213839',4139891,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213839',4139892,'1126','161',629113.86,629113.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213839',4139893,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213839',4139894,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213839',4139895,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213839',4139896,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213839',4139897,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213839',4139898,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213839',4139899,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213839',4139900,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213839',4139901,'1135','162',532106.56,532577.49,470.93,138924.35,0.00,0.00,0.00,0.00,0.00),('1','65','424','213839',4139902,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213839',4139903,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213919',4140948,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213919',4140949,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213919',4140950,'1124','161',204723.63,204853.58,129.95,21441.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','213919',4140951,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','213919',4140952,'1126','161',629113.86,629674.71,560.85,92540.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','213919',4140953,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213919',4140954,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213919',4140955,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213919',4140956,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213919',4140957,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213919',4140958,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','213919',4140959,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213919',4140960,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','213919',4140961,'1135','162',532577.49,535190.31,2612.82,770781.90,0.00,0.00,0.00,0.00,0.00),('1','65','424','213919',4140962,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','213919',4140963,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214087',4144051,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214087',4144052,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214087',4144053,'1124','161',204853.58,206049.27,1185.69,195638.85,0.00,0.00,10.00,0.00,0.00),('1','65','420','214087',4144054,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214087',4144055,'1126','161',629674.71,629674.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214087',4144056,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214087',4144057,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214087',4144058,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214087',4144059,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214087',4144060,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214087',4144061,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214087',4144062,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214087',4144063,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214087',4144064,'1135','162',535190.31,537777.70,2577.39,760330.05,0.00,0.00,10.00,0.00,0.00),('1','65','424','214087',4144065,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214087',4144066,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214212',4146042,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214212',4146043,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214212',4146044,'1124','161',206049.27,206049.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214212',4146045,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214212',4146046,'1126','161',629674.71,630479.39,804.68,132772.20,0.00,0.00,0.00,0.00,0.00),('1','65','420','214212',4146047,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214212',4146048,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214212',4146049,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214212',4146050,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214212',4146051,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214212',4146052,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214212',4146053,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214212',4146054,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214212',4146055,'1135','162',537777.70,539221.11,1443.41,425805.95,0.00,0.00,0.00,0.00,0.00),('1','65','424','214212',4146056,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214212',4146057,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214269',4147292,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214269',4147293,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214269',4147294,'1124','161',206049.27,207107.19,1057.92,174556.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','214269',4147295,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214269',4147296,'1126','161',630479.39,630479.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214269',4147297,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214269',4147298,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214269',4147299,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214269',4147300,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214269',4147301,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214269',4147302,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214269',4147303,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214269',4147304,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214269',4147305,'1135','162',539221.11,540289.34,1068.23,315127.85,0.00,0.00,0.00,0.00,0.00),('1','65','424','214269',4147306,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214269',4147307,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214530',4151563,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214530',4151564,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214530',4151565,'1124','161',207107.19,208056.80,949.61,156685.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','214530',4151566,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214530',4151567,'1126','161',630479.39,630479.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214530',4151568,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214530',4151569,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214530',4151570,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214530',4151571,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214530',4151572,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214530',4151573,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214530',4151574,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214530',4151575,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214530',4151576,'1135','162',540289.34,541397.00,1107.66,326759.70,0.00,0.00,0.00,0.00,0.00),('1','65','424','214530',4151577,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214530',4151578,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214722',4154971,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214722',4154972,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214722',4154973,'1124','161',208056.80,209237.32,1180.52,194785.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','214722',4154974,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214722',4154975,'1126','161',630479.39,630479.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214722',4154976,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214722',4154977,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214722',4154978,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214722',4154979,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214722',4154980,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214722',4154981,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214722',4154982,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214722',4154983,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214722',4154984,'1135','162',541397.00,541397.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214722',4154985,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214722',4154986,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214750',4155537,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214750',4155538,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214750',4155539,'1124','161',209237.32,210054.35,817.03,134809.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','214750',4155540,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214750',4155541,'1126','161',630479.39,630479.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214750',4155542,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214750',4155543,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214750',4155544,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214750',4155545,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214750',4155546,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214750',4155547,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214750',4155548,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214750',4155549,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214750',4155550,'1135','162',541397.00,541397.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214750',4155551,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214750',4155552,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214824',4156645,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214824',4156646,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214824',4156647,'1124','161',210054.35,210928.13,873.78,144173.70,0.00,0.00,0.00,0.00,0.00),('1','65','420','214824',4156648,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214824',4156649,'1126','161',630479.39,630479.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214824',4156650,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214824',4156651,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214824',4156652,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214824',4156653,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214824',4156654,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214824',4156655,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214824',4156656,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214824',4156657,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214824',4156658,'1135','162',541397.00,541397.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214824',4156659,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214824',4156660,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214851',4157141,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214851',4157142,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214851',4157143,'1124','161',210928.13,212171.13,1243.00,205095.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214851',4157144,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214851',4157145,'1126','161',630479.39,630479.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214851',4157146,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214851',4157147,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214851',4157148,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214851',4157149,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214851',4157150,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214851',4157151,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214851',4157152,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214851',4157153,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214851',4157154,'1135','162',541397.00,541397.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214851',4157155,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214851',4157156,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214950',4158832,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214950',4158833,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214950',4158834,'1124','161',212171.13,212851.67,680.54,112289.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','214950',4158835,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','214950',4158836,'1126','161',630479.39,630774.49,295.10,48691.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','214950',4158837,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214950',4158838,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214950',4158839,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214950',4158840,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214950',4158841,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214950',4158842,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','214950',4158843,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214950',4158844,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','214950',4158845,'1135','162',541397.00,541397.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214950',4158846,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','214950',4158847,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215148',4162191,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215148',4162192,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215148',4162193,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215148',4162194,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215148',4162195,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215148',4162196,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215148',4162197,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215148',4162198,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215148',4162199,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215148',4162200,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215148',4162201,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215148',4162202,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215148',4162203,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215148',4162204,'1135','162',541397.00,541397.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215148',4162205,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215148',4162206,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215160',4162401,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215160',4162402,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215160',4162403,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215160',4162404,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215160',4162405,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215160',4162406,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215160',4162407,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215160',4162408,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215160',4162409,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215160',4162410,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215160',4162411,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215160',4162412,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215160',4162413,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215160',4162414,'1135','162',541397.00,541397.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215160',4162415,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215160',4162416,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215205',4163233,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215205',4163234,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215205',4163235,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215205',4163236,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215205',4163237,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215205',4163238,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215205',4163239,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215205',4163240,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215205',4163241,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215205',4163242,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215205',4163243,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215205',4163244,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215205',4163245,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215205',4163246,'1135','162',541397.00,541805.36,408.36,120466.20,0.00,0.00,0.00,0.00,0.00),('1','65','424','215205',4163247,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215205',4163248,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215458',4167177,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215458',4167178,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215458',4167179,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215458',4167180,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215458',4167181,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215458',4167182,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215458',4167183,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215458',4167184,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215458',4167185,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215458',4167186,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215458',4167187,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215458',4167188,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215458',4167189,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215458',4167190,'1135','162',541805.36,542548.28,742.92,219161.40,0.00,0.00,0.00,0.00,0.00),('1','65','424','215458',4167191,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215458',4167192,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215571',4169125,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215571',4169126,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215571',4169127,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215571',4169128,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215571',4169129,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215571',4169130,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215571',4169131,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215571',4169132,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215571',4169133,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215571',4169134,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215571',4169135,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215571',4169136,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215571',4169137,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215571',4169138,'1135','162',542548.28,542901.16,352.88,104099.60,0.00,0.00,0.00,0.00,0.00),('1','65','424','215571',4169139,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215571',4169140,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215612',4170004,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215612',4170005,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215612',4170006,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215612',4170007,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215612',4170008,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215612',4170009,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215612',4170010,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215612',4170011,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215612',4170012,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215612',4170013,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215612',4170014,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215612',4170015,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215612',4170016,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215612',4170017,'1135','162',542901.16,543000.06,98.90,29175.50,0.00,0.00,0.00,0.00,0.00),('1','65','424','215612',4170018,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215612',4170019,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215731',4171912,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215731',4171913,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215731',4171914,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215731',4171915,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215731',4171916,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215731',4171917,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215731',4171918,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215731',4171919,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215731',4171920,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215731',4171921,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215731',4171922,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215731',4171923,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215731',4171924,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215731',4171925,'1135','162',543000.06,543107.71,107.65,31756.75,0.00,0.00,0.00,0.00,0.00),('1','65','424','215731',4171926,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215731',4171927,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215969',4176054,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215969',4176055,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215969',4176056,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215969',4176057,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215969',4176058,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','215969',4176059,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215969',4176060,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215969',4176061,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215969',4176062,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215969',4176063,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215969',4176064,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','215969',4176065,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215969',4176066,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','215969',4176067,'1135','162',543107.71,543157.71,50.00,14750.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215969',4176068,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','215969',4176069,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216030',4177169,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216030',4177170,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216030',4177171,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216030',4177172,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216030',4177173,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216030',4177174,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216030',4177175,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216030',4177176,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216030',4177177,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216030',4177178,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216030',4177179,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216030',4177180,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216030',4177181,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216030',4177182,'1135','162',543157.71,546274.12,3116.41,919340.95,0.00,0.00,0.00,0.00,0.00),('1','65','424','216030',4177183,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216030',4177184,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216199',4180034,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216199',4180035,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216199',4180036,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216199',4180037,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216199',4180038,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216199',4180039,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216199',4180040,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216199',4180041,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216199',4180042,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216199',4180043,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216199',4180044,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216199',4180045,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216199',4180046,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216199',4180047,'1135','162',546274.12,546347.84,73.72,21747.40,0.00,0.00,0.00,0.00,0.00),('1','65','424','216199',4180048,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216199',4180049,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216266',4181256,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216266',4181257,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216266',4181258,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216266',4181259,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216266',4181260,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216266',4181261,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216266',4181262,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216266',4181263,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216266',4181264,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216266',4181265,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216266',4181266,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216266',4181267,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216266',4181268,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216266',4181269,'1135','162',546347.84,547203.31,855.47,252363.65,0.00,0.00,0.00,0.00,0.00),('1','65','424','216266',4181270,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216266',4181271,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216284',4181691,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216284',4181692,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216284',4181693,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216284',4181694,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216284',4181695,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216284',4181696,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216284',4181697,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216284',4181698,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216284',4181699,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216284',4181700,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216284',4181701,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216284',4181702,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216284',4181703,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216284',4181704,'1135','162',547203.31,547901.03,697.72,205827.40,0.00,0.00,0.00,0.00,0.00),('1','65','424','216284',4181705,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216284',4181706,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216426',4183927,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216426',4183928,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216426',4183929,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216426',4183930,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216426',4183931,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216426',4183932,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216426',4183933,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216426',4183934,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216426',4183935,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216426',4183936,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216426',4183937,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216426',4183938,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216426',4183939,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216426',4183940,'1135','162',547901.03,550265.52,2364.49,697524.55,0.00,0.00,0.00,0.00,0.00),('1','65','424','216426',4183941,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216426',4183942,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216565',4186350,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216565',4186351,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216565',4186352,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216565',4186353,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216565',4186354,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216565',4186355,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216565',4186356,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216565',4186357,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216565',4186358,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216565',4186359,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216565',4186360,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216565',4186361,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216565',4186362,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216565',4186363,'1135','162',550265.52,550760.87,495.35,146128.25,0.00,0.00,0.00,0.00,0.00),('1','65','424','216565',4186364,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216565',4186365,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216670',4188175,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216670',4188176,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216670',4188177,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216670',4188178,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216670',4188179,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216670',4188180,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216670',4188181,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216670',4188182,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216670',4188183,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216670',4188184,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216670',4188185,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216670',4188186,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216670',4188187,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216670',4188188,'1135','162',550760.87,551544.10,783.23,231052.85,0.00,0.00,0.00,0.00,0.00),('1','65','424','216670',4188189,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216670',4188190,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216719',4189244,'1122','161',814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216719',4189245,'1123','161',603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216719',4189246,'1124','161',212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216719',4189247,'1125','161',244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216719',4189248,'1126','161',630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216719',4189249,'1127','161',416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216719',4189250,'1128','161',78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216719',4189251,'1129','161',207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216719',4189252,'1130','161',721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216719',4189253,'1131','161',111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216719',4189254,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216719',4189255,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216719',4189256,'1134','162',10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216719',4189257,'1135','162',551544.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216719',4189258,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216719',4189259,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216732',4189561,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216732',4189562,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216732',4189563,'1124','161',212851.67,212851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216732',4189564,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216732',4189565,'1126','161',630774.49,630774.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216732',4189566,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216732',4189567,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216732',4189568,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216732',4189569,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216732',4189570,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216732',4189571,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216732',4189572,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216732',4189573,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216732',4189574,'1135','162',551544.10,553468.60,1924.50,567727.50,0.00,0.00,0.00,0.00,0.00),('1','65','424','216732',4189575,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216732',4189576,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216786',4190477,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216786',4190478,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216786',4190479,'1124','161',212851.67,213861.62,1009.95,166641.75,0.00,0.00,0.00,0.00,10.00),('1','65','420','216786',4190480,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','216786',4190481,'1126','161',630774.49,631247.09,457.60,75504.00,0.00,0.00,15.00,0.00,15.00),('1','65','420','216786',4190482,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216786',4190483,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216786',4190484,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216786',4190485,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216786',4190486,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216786',4190487,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','216786',4190488,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216786',4190489,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','216786',4190490,'1135','162',553468.60,555701.16,2222.56,655655.20,0.00,0.00,10.00,0.00,0.00),('1','65','424','216786',4190491,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','216786',4190492,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217028',4194543,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217028',4194544,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217028',4194545,'1124','161',213861.62,214444.19,582.57,96124.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','217028',4194546,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217028',4194547,'1126','161',631247.09,631247.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217028',4194548,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217028',4194549,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217028',4194550,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217028',4194551,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217028',4194552,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217028',4194553,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217028',4194554,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217028',4194555,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217028',4194556,'1135','162',555701.16,555794.29,93.13,27473.35,0.00,0.00,0.00,0.00,0.00),('1','65','424','217028',4194557,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217028',4194558,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217094',4195579,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217094',4195580,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217094',4195581,'1124','161',214444.19,215130.08,685.89,113171.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','217094',4195582,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217094',4195583,'1126','161',631247.09,631384.46,137.37,22666.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','217094',4195584,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217094',4195585,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217094',4195586,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217094',4195587,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217094',4195588,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217094',4195589,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217094',4195590,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217094',4195591,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217094',4195592,'1135','162',555794.29,558638.86,2824.57,833248.15,0.00,0.00,20.00,0.00,0.00),('1','65','424','217094',4195593,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217094',4195594,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217246',4198910,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217246',4198911,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217246',4198912,'1124','161',215130.08,215702.81,572.73,94500.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','217246',4198913,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217246',4198914,'1126','161',631384.46,631384.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217246',4198915,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217246',4198916,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217246',4198917,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217246',4198918,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217246',4198919,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217246',4198920,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217246',4198921,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217246',4198922,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217246',4198923,'1135','162',558638.86,558849.37,210.51,62100.45,0.00,0.00,0.00,0.00,0.00),('1','65','424','217246',4198924,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217246',4198925,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217349',4200410,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217349',4200411,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217349',4200412,'1124','161',215702.81,216174.28,471.47,77792.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','217349',4200413,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217349',4200414,'1126','161',631384.46,631582.05,197.59,32602.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','217349',4200415,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217349',4200416,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217349',4200417,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217349',4200418,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217349',4200419,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217349',4200420,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217349',4200421,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217349',4200422,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217349',4200423,'1135','162',558849.37,560375.73,1526.36,450276.20,0.00,0.00,0.00,0.00,0.00),('1','65','424','217349',4200424,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217349',4200425,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217413',4201544,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217413',4201545,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217413',4201546,'1124','161',216174.28,216873.05,698.77,115297.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','217413',4201547,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217413',4201548,'1126','161',631582.05,631688.54,106.49,17570.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','217413',4201549,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217413',4201550,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217413',4201551,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217413',4201552,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217413',4201553,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217413',4201554,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217413',4201555,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217413',4201556,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217413',4201557,'1135','162',560375.73,561278.95,903.22,266449.90,0.00,0.00,0.00,0.00,0.00),('1','65','424','217413',4201558,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217413',4201559,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217575',4204341,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217575',4204342,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217575',4204343,'1124','161',216873.05,217487.11,614.06,101319.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','217575',4204344,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217575',4204345,'1126','161',631688.54,631688.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217575',4204346,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217575',4204347,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217575',4204348,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217575',4204349,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217575',4204350,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217575',4204351,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217575',4204352,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217575',4204353,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217575',4204354,'1135','162',561278.95,562130.40,851.45,251177.75,0.00,0.00,0.00,0.00,0.00),('1','65','424','217575',4204355,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217575',4204356,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217646',4205870,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217646',4205871,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217646',4205872,'1124','161',217487.11,218067.64,580.53,95787.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','217646',4205873,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217646',4205874,'1126','161',631688.54,631688.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217646',4205875,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217646',4205876,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217646',4205877,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217646',4205878,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217646',4205879,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217646',4205880,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217646',4205881,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217646',4205882,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217646',4205883,'1135','162',562130.40,563157.49,1027.09,302991.55,0.00,0.00,0.00,0.00,0.00),('1','65','424','217646',4205884,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217646',4205885,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217834',4209046,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217834',4209047,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217834',4209048,'1124','161',218067.64,218815.80,748.16,123446.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','217834',4209049,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217834',4209050,'1126','161',631688.54,631901.79,213.25,35186.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','217834',4209051,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217834',4209052,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217834',4209053,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217834',4209054,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217834',4209055,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217834',4209056,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217834',4209057,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217834',4209058,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217834',4209059,'1135','162',563157.49,563212.92,55.43,16351.85,0.00,0.00,0.00,0.00,0.00),('1','65','424','217834',4209060,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217834',4209061,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217938',4211089,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217938',4211090,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217938',4211091,'1124','161',218815.80,219205.12,389.32,64237.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','217938',4211092,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','217938',4211093,'1126','161',631901.79,631913.31,11.52,1900.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','217938',4211094,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217938',4211095,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217938',4211096,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217938',4211097,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217938',4211098,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217938',4211099,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','217938',4211100,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217938',4211101,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','217938',4211102,'1135','162',563212.92,564186.52,973.60,287212.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217938',4211103,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','217938',4211104,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218060',4212852,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218060',4212853,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218060',4212854,'1124','161',219205.12,219569.87,364.75,60183.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','218060',4212855,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218060',4212856,'1126','161',631913.31,632046.92,133.61,22045.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','218060',4212857,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218060',4212858,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218060',4212859,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218060',4212860,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218060',4212861,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218060',4212862,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218060',4212863,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218060',4212864,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218060',4212865,'1135','162',564186.52,564388.48,201.96,59578.20,0.00,0.00,0.00,0.00,0.00),('1','65','424','218060',4212866,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218060',4212867,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218150',4214554,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218150',4214555,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218150',4214556,'1124','161',219569.87,219991.13,421.26,69507.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','218150',4214557,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218150',4214558,'1126','161',632046.92,632046.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218150',4214559,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218150',4214560,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218150',4214561,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218150',4214562,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218150',4214563,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218150',4214564,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218150',4214565,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218150',4214566,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218150',4214567,'1135','162',564388.48,564567.97,179.49,52949.55,0.00,0.00,0.00,0.00,0.00),('1','65','424','218150',4214568,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218150',4214569,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218281',4216759,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218281',4216760,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218281',4216761,'1124','161',219991.13,220472.49,481.36,79424.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','218281',4216762,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218281',4216763,'1126','161',632046.92,632124.47,77.55,12795.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','218281',4216764,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218281',4216765,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218281',4216766,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218281',4216767,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218281',4216768,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218281',4216769,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218281',4216770,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218281',4216771,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218281',4216772,'1135','162',564567.97,564765.59,197.62,58297.90,0.00,0.00,0.00,0.00,0.00),('1','65','424','218281',4216773,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218281',4216774,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218367',4218396,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218367',4218397,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218367',4218398,'1124','161',220472.49,220921.02,448.53,74007.45,0.00,0.00,0.00,0.00,0.00),('1','65','420','218367',4218399,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218367',4218400,'1126','161',632124.47,632124.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218367',4218401,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218367',4218402,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218367',4218403,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218367',4218404,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218367',4218405,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218367',4218406,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218367',4218407,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218367',4218408,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218367',4218409,'1135','162',564765.59,565041.22,275.63,81310.85,0.00,0.00,0.00,0.00,0.00),('1','65','424','218367',4218410,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218367',4218411,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218540',4221510,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218540',4221511,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218540',4221512,'1124','161',220921.02,221534.47,613.45,101219.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','218540',4221513,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218540',4221514,'1126','161',632124.47,632980.06,855.59,141172.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','218540',4221515,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218540',4221516,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218540',4221517,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218540',4221518,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218540',4221519,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218540',4221520,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218540',4221521,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218540',4221522,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218540',4221523,'1135','162',565041.22,565060.04,18.82,5551.90,0.00,0.00,0.00,0.00,0.00),('1','65','424','218540',4221524,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218540',4221525,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218595',4222561,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218595',4222562,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218595',4222563,'1124','161',221534.47,222194.91,650.44,107322.60,0.00,0.00,10.00,0.00,0.00),('1','65','420','218595',4222564,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218595',4222565,'1126','161',632980.06,632980.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218595',4222566,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218595',4222567,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218595',4222568,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218595',4222569,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218595',4222570,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218595',4222571,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218595',4222572,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218595',4222573,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218595',4222574,'1135','162',565060.04,565925.76,855.72,252437.40,0.00,0.00,10.00,0.00,0.00),('1','65','424','218595',4222575,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218595',4222576,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218768',4225391,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218768',4225392,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218768',4225393,'1124','161',222194.91,222800.25,605.34,99881.10,0.00,0.00,0.00,0.00,0.00),('1','65','420','218768',4225394,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218768',4225395,'1126','161',632980.06,632980.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218768',4225396,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218768',4225397,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218768',4225398,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218768',4225399,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218768',4225400,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218768',4225401,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218768',4225402,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218768',4225403,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218768',4225404,'1135','162',565925.76,566910.69,984.93,290554.35,0.00,0.00,0.00,0.00,0.00),('1','65','424','218768',4225405,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218768',4225406,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218876',4227497,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218876',4227498,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218876',4227499,'1124','161',222800.25,223525.73,715.48,118054.20,0.00,0.00,10.00,0.00,0.00),('1','65','420','218876',4227500,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218876',4227501,'1126','161',632980.06,632980.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218876',4227502,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218876',4227503,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218876',4227504,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218876',4227505,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218876',4227506,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218876',4227507,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218876',4227508,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218876',4227509,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218876',4227510,'1135','162',566910.69,567043.74,133.05,39249.75,0.00,0.00,0.00,0.00,0.00),('1','65','424','218876',4227511,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218876',4227512,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218957',4228696,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218957',4228697,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218957',4228698,'1124','161',223525.73,224051.68,525.95,86781.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','218957',4228699,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','218957',4228700,'1126','161',632980.06,633106.11,126.05,20798.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','218957',4228701,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218957',4228702,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218957',4228703,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218957',4228704,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218957',4228705,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218957',4228706,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','218957',4228707,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218957',4228708,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','218957',4228709,'1135','162',567043.74,567125.28,81.54,24054.30,0.00,0.00,0.00,0.00,0.00),('1','65','424','218957',4228710,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','218957',4228711,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219082',4231024,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219082',4231025,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219082',4231026,'1124','161',224051.68,224619.88,558.20,92103.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','219082',4231027,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219082',4231028,'1126','161',633106.11,633106.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219082',4231029,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219082',4231030,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219082',4231031,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219082',4231032,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219082',4231033,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219082',4231034,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219082',4231035,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219082',4231036,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219082',4231037,'1135','162',567125.28,567244.45,99.17,29255.15,0.00,0.00,20.00,0.00,0.00),('1','65','424','219082',4231038,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219082',4231039,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219221',4233170,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219221',4233171,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219221',4233172,'1124','161',224619.88,225100.07,480.19,79231.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','219221',4233173,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219221',4233174,'1126','161',633106.11,633338.15,232.04,38286.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','219221',4233175,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219221',4233176,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219221',4233177,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219221',4233178,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219221',4233179,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219221',4233180,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219221',4233181,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219221',4233182,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219221',4233183,'1135','162',567244.45,568894.75,1650.30,486838.50,0.00,0.00,0.00,0.00,0.00),('1','65','424','219221',4233184,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219221',4233185,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219423',4236694,'1122','161',814271.82,814271.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219423',4236695,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219423',4236696,'1124','161',225100.07,225718.37,618.30,102019.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','219423',4236697,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219423',4236698,'1126','161',633338.15,633338.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219423',4236699,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219423',4236700,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219423',4236701,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219423',4236702,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219423',4236703,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219423',4236704,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219423',4236705,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219423',4236706,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219423',4236707,'1135','162',568894.75,569636.27,741.52,218748.40,0.00,0.00,0.00,0.00,0.00),('1','65','424','219423',4236708,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219423',4236709,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219467',4237581,'1122','161',814271.82,814824.79,552.97,91240.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','219467',4237582,'1123','161',603765.46,603765.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219467',4237583,'1124','161',225718.37,225718.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219467',4237584,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219467',4237585,'1126','161',633338.15,633627.16,289.01,47686.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','219467',4237586,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219467',4237587,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219467',4237588,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219467',4237589,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219467',4237590,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219467',4237591,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219467',4237592,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219467',4237593,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219467',4237594,'1135','162',569636.27,570520.88,884.61,260959.95,0.00,0.00,0.00,0.00,0.00),('1','65','424','219467',4237595,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219467',4237596,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219546',4239072,'1122','161',814824.79,814824.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219546',4239073,'1123','161',603765.46,604196.07,430.61,71050.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','219546',4239074,'1124','161',225718.37,225804.41,86.04,14196.60,0.00,0.00,0.00,0.00,0.00),('1','65','420','219546',4239075,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219546',4239076,'1126','161',633627.16,633627.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219546',4239077,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219546',4239078,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219546',4239079,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219546',4239080,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219546',4239081,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219546',4239082,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219546',4239083,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219546',4239084,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219546',4239085,'1135','162',570520.88,571588.28,1067.40,314883.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219546',4239086,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219546',4239087,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219667',4240918,'1122','161',814824.79,815480.71,655.92,108226.80,0.00,0.00,0.00,0.00,0.00),('1','65','420','219667',4240919,'1123','161',604196.07,604196.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219667',4240920,'1124','161',225804.41,225804.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219667',4240921,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219667',4240922,'1126','161',633627.16,633627.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219667',4240923,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219667',4240924,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219667',4240925,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219667',4240926,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219667',4240927,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219667',4240928,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219667',4240929,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219667',4240930,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219667',4240931,'1135','162',571588.28,572131.11,542.83,160134.85,0.00,0.00,0.00,0.00,0.00),('1','65','424','219667',4240932,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219667',4240933,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219747',4242653,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219747',4242654,'1123','161',604196.07,604283.23,87.16,14381.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','219747',4242655,'1124','161',225804.41,226415.57,611.16,100841.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','219747',4242656,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219747',4242657,'1126','161',633627.16,633627.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219747',4242658,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219747',4242659,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219747',4242660,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219747',4242661,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219747',4242662,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219747',4242663,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219747',4242664,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219747',4242665,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219747',4242666,'1135','162',572131.11,573170.01,1038.90,306475.50,0.00,0.00,0.00,0.00,0.00),('1','65','424','219747',4242667,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219747',4242668,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219906',4245259,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219906',4245260,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219906',4245261,'1124','161',226415.57,226837.23,421.66,69573.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','219906',4245262,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','219906',4245263,'1126','161',633627.16,633915.73,288.57,47614.05,0.00,0.00,0.00,0.00,0.00),('1','65','420','219906',4245264,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219906',4245265,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219906',4245266,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219906',4245267,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219906',4245268,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219906',4245269,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','219906',4245270,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219906',4245271,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','219906',4245272,'1135','162',573170.01,574953.42,1773.41,523155.95,0.00,0.00,10.00,0.00,0.00),('1','65','424','219906',4245273,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','219906',4245274,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220005',4247374,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220005',4247375,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220005',4247376,'1124','161',226837.23,227253.26,416.03,68644.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','220005',4247377,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220005',4247378,'1126','161',633915.73,633915.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220005',4247379,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220005',4247380,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220005',4247381,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220005',4247382,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220005',4247383,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220005',4247384,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220005',4247385,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220005',4247386,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220005',4247387,'1135','162',574953.42,575693.68,740.26,218376.70,0.00,0.00,0.00,0.00,0.00),('1','65','424','220005',4247388,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220005',4247389,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220144',4249621,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220144',4249622,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220144',4249623,'1124','161',227253.26,227864.74,601.48,99244.20,0.00,0.00,10.00,0.00,0.00),('1','65','420','220144',4249624,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220144',4249625,'1126','161',633915.73,634493.51,567.78,93683.70,0.00,0.00,10.00,0.00,0.00),('1','65','420','220144',4249626,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220144',4249627,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220144',4249628,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220144',4249629,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220144',4249630,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220144',4249631,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220144',4249632,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220144',4249633,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220144',4249634,'1135','162',575693.68,576348.64,654.96,193213.20,0.00,0.00,0.00,0.00,0.00),('1','65','424','220144',4249635,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220144',4249636,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220214',4251021,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220214',4251022,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220214',4251023,'1124','161',227864.74,228369.81,505.07,83336.55,0.00,0.00,0.00,0.00,0.00),('1','65','420','220214',4251024,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220214',4251025,'1126','161',634493.51,634493.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220214',4251026,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220214',4251027,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220214',4251028,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220214',4251029,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220214',4251030,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220214',4251031,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220214',4251032,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220214',4251033,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220214',4251034,'1135','162',576348.64,576397.89,49.25,14528.75,0.00,0.00,0.00,0.00,0.00),('1','65','424','220214',4251035,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220214',4251036,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220316',4252564,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220316',4252565,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220316',4252566,'1124','161',228369.81,228819.61,449.80,74217.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220316',4252567,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220316',4252568,'1126','161',634493.51,634764.50,270.99,44713.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','220316',4252569,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220316',4252570,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220316',4252571,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220316',4252572,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220316',4252573,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220316',4252574,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220316',4252575,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220316',4252576,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220316',4252577,'1135','162',576397.89,577298.16,900.27,265579.65,0.00,0.00,0.00,0.00,0.00),('1','65','424','220316',4252578,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220316',4252579,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220366',4253604,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220366',4253605,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220366',4253606,'1124','161',228819.61,229526.91,707.30,116704.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','220366',4253607,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220366',4253608,'1126','161',634764.50,634764.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220366',4253609,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220366',4253610,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220366',4253611,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220366',4253612,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220366',4253613,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220366',4253614,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220366',4253615,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220366',4253616,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220366',4253617,'1135','162',577298.16,577309.36,11.20,3304.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220366',4253618,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220366',4253619,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220532',4256488,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220532',4256489,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220532',4256490,'1124','161',229526.91,229915.80,388.89,64166.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','220532',4256491,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220532',4256492,'1126','161',634764.50,635019.20,254.70,42025.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','220532',4256493,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220532',4256494,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220532',4256495,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220532',4256496,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220532',4256497,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220532',4256498,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220532',4256499,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220532',4256500,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220532',4256501,'1135','162',577309.36,577488.96,179.60,52982.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220532',4256502,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220532',4256503,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220659',4258891,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220659',4258892,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220659',4258893,'1124','161',229915.80,230455.89,540.09,89114.85,0.00,0.00,0.00,0.00,0.00),('1','65','420','220659',4258894,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220659',4258895,'1126','161',635019.20,635019.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220659',4258896,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220659',4258897,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220659',4258898,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220659',4258899,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220659',4258900,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220659',4258901,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220659',4258902,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220659',4258903,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220659',4258904,'1135','162',577488.96,579985.82,2481.86,732148.70,0.00,0.00,15.00,0.00,0.00),('1','65','424','220659',4258905,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220659',4258906,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220768',4260506,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220768',4260507,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220768',4260508,'1124','161',230455.89,230733.25,277.36,45764.40,0.00,0.00,0.00,0.00,0.00),('1','65','420','220768',4260509,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220768',4260510,'1126','161',635019.20,635201.35,182.15,30054.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','220768',4260511,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220768',4260512,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220768',4260513,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220768',4260514,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220768',4260515,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220768',4260516,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220768',4260517,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220768',4260518,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220768',4260519,'1135','162',579985.82,580814.33,828.51,244410.45,0.00,0.00,0.00,0.00,0.00),('1','65','424','220768',4260520,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220768',4260521,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220981',4264522,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220981',4264523,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220981',4264524,'1124','161',230733.25,231172.50,439.25,72476.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','220981',4264525,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220981',4264526,'1126','161',635201.35,635201.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','220981',4264527,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220981',4264528,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220981',4264529,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220981',4264530,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220981',4264531,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220981',4264532,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','220981',4264533,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220981',4264534,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','220981',4264535,'1135','162',580814.33,581046.15,231.82,68386.90,0.00,0.00,0.00,0.00,0.00),('1','65','424','220981',4264536,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','220981',4264537,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221019',4265102,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221019',4265103,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221019',4265104,'1124','161',231172.50,231727.28,544.78,89888.70,0.00,0.00,10.00,0.00,0.00),('1','65','420','221019',4265105,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221019',4265106,'1126','161',635201.35,635556.50,345.15,56949.75,0.00,0.00,10.00,0.00,0.00),('1','65','420','221019',4265107,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221019',4265108,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221019',4265109,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221019',4265110,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221019',4265111,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221019',4265112,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221019',4265113,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221019',4265114,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221019',4265115,'1135','162',581046.15,581906.20,860.05,253714.75,0.00,0.00,0.00,0.00,0.00),('1','65','424','221019',4265116,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221019',4265117,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221244',4268952,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221244',4268953,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221244',4268954,'1124','161',231727.28,232318.10,590.82,97485.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','221244',4268955,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221244',4268956,'1126','161',635556.50,635556.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221244',4268957,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221244',4268958,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221244',4268959,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221244',4268960,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221244',4268961,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221244',4268962,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221244',4268963,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221244',4268964,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221244',4268965,'1135','162',581906.20,583334.85,1428.65,421451.75,0.00,0.00,0.00,0.00,0.00),('1','65','424','221244',4268966,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221244',4268967,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221472',4273115,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221472',4273116,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221472',4273117,'1124','161',232318.10,232759.70,431.60,71214.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','221472',4273118,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221472',4273119,'1126','161',635556.50,635568.02,1.52,250.80,0.00,0.00,10.00,0.00,0.00),('1','65','420','221472',4273120,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221472',4273121,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221472',4273122,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221472',4273123,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221472',4273124,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221472',4273125,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221472',4273126,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221472',4273127,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221472',4273128,'1135','162',583334.85,584266.07,921.22,271759.90,0.00,0.00,10.00,0.00,0.00),('1','65','424','221472',4273129,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221472',4273130,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221478',4273225,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221478',4273226,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221478',4273227,'1124','161',232759.70,233391.52,631.82,104250.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','221478',4273228,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221478',4273229,'1126','161',635568.02,635568.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221478',4273230,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221478',4273231,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221478',4273232,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221478',4273233,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221478',4273234,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221478',4273235,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221478',4273236,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221478',4273237,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221478',4273238,'1135','162',584266.07,584925.83,659.76,194629.20,0.00,0.00,0.00,0.00,0.00),('1','65','424','221478',4273239,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221478',4273240,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221496',4273644,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221496',4273645,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221496',4273646,'1124','161',233391.52,233922.98,531.46,87690.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','221496',4273647,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221496',4273648,'1126','161',635568.02,635953.13,385.11,63543.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','221496',4273649,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221496',4273650,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221496',4273651,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221496',4273652,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221496',4273653,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221496',4273654,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221496',4273655,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221496',4273656,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221496',4273657,'1135','162',584925.83,585124.23,198.40,58528.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221496',4273658,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221496',4273659,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221585',4275572,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221585',4275573,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221585',4275574,'1124','161',233922.98,234567.84,644.86,106401.90,0.00,0.00,0.00,0.00,0.00),('1','65','420','221585',4275575,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221585',4275576,'1126','161',635953.13,635953.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221585',4275577,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221585',4275578,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221585',4275579,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221585',4275580,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221585',4275581,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221585',4275582,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221585',4275583,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221585',4275584,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221585',4275585,'1135','162',585124.23,585520.52,396.29,116905.55,0.00,0.00,0.00,0.00,0.00),('1','65','424','221585',4275586,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221585',4275587,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221680',4277052,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221680',4277053,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221680',4277054,'1124','161',234567.84,235290.03,712.19,117511.35,0.00,0.00,10.00,0.00,0.00),('1','65','420','221680',4277055,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221680',4277056,'1126','161',635953.13,637218.77,1255.64,207180.60,0.00,0.00,10.00,0.00,0.00),('1','65','420','221680',4277057,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221680',4277058,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221680',4277059,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221680',4277060,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221680',4277061,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221680',4277062,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221680',4277063,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221680',4277064,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221680',4277065,'1135','162',585520.52,586479.37,948.85,279910.75,0.00,0.00,10.00,0.00,0.00),('1','65','424','221680',4277066,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221680',4277067,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221799',4279321,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221799',4279322,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221799',4279323,'1124','161',235290.03,235626.06,336.03,55444.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','221799',4279324,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221799',4279325,'1126','161',637218.77,637562.18,343.41,56662.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','221799',4279326,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221799',4279327,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221799',4279328,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221799',4279329,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221799',4279330,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221799',4279331,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221799',4279332,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221799',4279333,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221799',4279334,'1135','162',586479.37,586864.49,385.12,113610.40,0.00,0.00,0.00,0.00,0.00),('1','65','424','221799',4279335,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221799',4279336,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221931',4281418,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221931',4281419,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221931',4281420,'1124','161',235626.06,235990.07,364.01,60061.65,0.00,0.00,0.00,0.00,0.00),('1','65','420','221931',4281421,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221931',4281422,'1126','161',637562.18,637896.43,334.25,55151.25,0.00,0.00,0.00,0.00,0.00),('1','65','420','221931',4281423,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221931',4281424,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221931',4281425,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221931',4281426,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221931',4281427,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221931',4281428,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221931',4281429,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221931',4281430,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221931',4281431,'1135','162',586864.49,587613.33,748.84,220907.80,0.00,0.00,0.00,0.00,0.00),('1','65','424','221931',4281432,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221931',4281433,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221946',4281774,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221946',4281775,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221946',4281776,'1124','161',235990.07,236438.26,448.19,73951.35,0.00,0.00,0.00,0.00,0.00),('1','65','420','221946',4281777,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221946',4281778,'1126','161',637896.43,637896.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','221946',4281779,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221946',4281780,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221946',4281781,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221946',4281782,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221946',4281783,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221946',4281784,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','221946',4281785,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221946',4281786,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','221946',4281787,'1135','162',587613.33,588311.14,697.81,205853.95,0.00,0.00,0.00,0.00,0.00),('1','65','424','221946',4281788,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','221946',4281789,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222170',4285759,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222170',4285760,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222170',4285761,'1124','161',236438.26,236779.36,341.10,56281.50,0.00,0.00,0.00,0.00,0.00),('1','65','420','222170',4285762,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222170',4285763,'1126','161',637896.43,638105.38,208.95,34476.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','222170',4285764,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222170',4285765,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222170',4285766,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222170',4285767,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222170',4285768,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222170',4285769,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222170',4285770,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','222170',4285771,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','222170',4285772,'1135','162',588311.14,588945.34,634.20,187089.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','222170',4285773,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','222170',4285774,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222174',4285831,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222174',4285832,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222174',4285833,'1124','161',236779.36,237398.98,619.62,102237.30,0.00,0.00,0.00,0.00,0.00),('1','65','420','222174',4285834,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222174',4285835,'1126','161',638105.38,638105.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222174',4285836,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222174',4285837,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222174',4285838,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222174',4285839,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222174',4285840,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222174',4285841,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222174',4285842,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','222174',4285843,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','222174',4285844,'1135','162',588945.34,589705.96,760.62,224382.90,0.00,0.00,0.00,0.00,0.00),('1','65','424','222174',4285845,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','222174',4285846,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222357',4288849,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222357',4288850,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222357',4288851,'1124','161',237398.98,237618.01,219.03,36139.95,0.00,0.00,0.00,0.00,0.00),('1','65','420','222357',4288852,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222357',4288853,'1126','161',638105.38,638428.69,323.31,53346.15,0.00,0.00,0.00,0.00,0.00),('1','65','420','222357',4288854,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222357',4288855,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222357',4288856,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222357',4288857,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222357',4288858,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222357',4288859,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222357',4288860,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','222357',4288861,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','222357',4288862,'1135','162',589705.96,590105.16,399.20,117764.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','222357',4288863,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','222357',4288864,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222433',4290350,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222433',4290351,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222433',4290352,'1124','161',237618.01,238333.96,715.95,118131.75,0.00,0.00,0.00,0.00,0.00),('1','65','420','222433',4290353,'1125','161',244062.98,244062.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222433',4290354,'1126','161',638428.69,638428.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222433',4290355,'1127','161',416854.78,416854.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222433',4290356,'1128','161',78226.23,78226.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222433',4290357,'1129','161',207241.44,207241.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222433',4290358,'1130','161',721484.88,721484.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222433',4290359,'1131','161',111192.33,111192.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222433',4290360,'1132','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','421','222433',4290361,'1133','161',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','222433',4290362,'1134','162',10235207.14,10235207.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','423','222433',4290363,'1135','162',590105.16,590706.70,601.54,177454.30,0.00,0.00,0.00,0.00,0.00),('1','65','424','222433',4290364,'1136','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','424','222433',4290365,'1137','163',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222563',4292421,'1122','161',815480.71,815480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222563',4292422,'1123','161',604283.23,604283.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','65','420','222563',4292423,'1124','161',238333.96,238877.96,534.00,88110.00,0.00,0.00,10.00,0.00,0.00),('1','65','420','222563',4292424,'1125','161',244062.98,244062.98,0.00,0.00,0.0