-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_64
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_64`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_64` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_64`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3937 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1505,2010,'',0,'24','1','64','SALARIES AND WAGES','','2018-02-21 13:46:17',5,0.00,0.00,'','248','2018-02-21 13:46:17','248',0,1),(1506,2011,'',0,'24','1','64','GENERATOR AGO CONSUMPTION','','2018-02-21 13:46:39',5,0.00,0.00,'','248','2018-02-21 13:46:39','248',0,1),(1507,2012,'',0,'24','1','64','PUBLIC RELATION','','2018-02-21 13:46:57',5,0.00,0.00,'','248','2018-02-21 13:46:57','248',0,1),(1508,2013,'',0,'24','1','64','GENERATOR REPAIRS & MAINTAINAN','','2018-02-21 13:47:25',5,0.00,0.00,'','248','2018-02-21 13:47:25','248',0,1),(1509,2014,'',0,'24','1','64','INTERNET SUBSCRIPTION','','2018-02-21 13:47:46',5,0.00,0.00,'','248','2018-02-21 13:47:46','248',0,1),(1510,2015,'',0,'24','1','64','ELECTRICITY AND WATER BILLS','','2018-02-21 13:51:02',5,0.00,0.00,'','248','2018-02-21 13:51:02','248',0,1),(1511,2016,'',0,'24','1','64','WEIGHT & MEASURE','','2018-02-21 13:51:30',5,0.00,0.00,'','248','2018-02-21 13:51:30','248',0,1),(1512,2017,'',0,'24','1','64','MEDICAL EXPENSES','','2018-02-21 13:52:03',5,0.00,0.00,'','248','2018-02-21 13:52:03','248',0,1),(1513,2018,'',0,'24','1','64','FUELLING & REP OFFICIAL CAR','','2018-02-21 13:53:22',5,0.00,0.00,'','248','2018-02-21 13:53:22','248',0,1),(1514,2019,'',0,'24','1','64','PUMP & GENERATOR REPAIRS','','2018-02-21 14:15:29',5,0.00,0.00,'','248','2018-02-21 14:15:29','248',0,1),(1515,2020,'',0,'24','1','64','PRINTING & STATIONARY','','2018-02-21 14:16:43',5,0.00,0.00,'','248','2018-02-21 14:16:43','248',0,1),(1516,3000,'',0,'6.1','1','64','CASH','','2018-02-21 14:17:11',5,0.00,0.00,'','248','2018-02-21 14:17:11','248',0,1),(1517,3001,'',0,'6','1','64','CASH IMPREST','','2018-02-21 14:17:39',5,0.00,0.00,'','248','2018-02-21 14:17:39','248',0,1),(1518,2022,'',0,'24','1','64','CLEANING AND SANITARY ITEMS','','2018-02-21 14:19:14',5,0.00,0.00,'','248','2018-02-21 14:19:14','248',0,1),(1519,2023,'',0,'24','1','64','FEES,FINES& LEVIES','','2018-02-21 14:20:13',5,0.00,0.00,'','248','2018-02-21 14:20:13','248',0,1),(1520,2024,'',0,'24','1','64','TRANSPORT FARE','','2018-02-21 14:22:02',5,0.00,0.00,'','248','2018-02-21 14:22:02','248',0,1),(1521,3003,'',0,'2','1','64','UBA 1020811607','','2018-02-21 14:37:50',5,0.00,0.00,'','248','2018-02-21 14:37:50','248',0,1),(1522,3005,'',0,'24','1','64','PURCHASES','','2018-02-21 14:39:08',5,0.00,0.00,'2018-02-21','248','2018-02-21 14:41:46','248',0,1),(1523,3006,'',0,'20','1','64','SALES','','2018-02-21 14:39:37',5,0.00,0.00,'','248','2018-02-21 14:39:37','248',0,1),(1577,3007,'',0,'2','1','64','UBA 1020811580','','2018-04-25 13:23:33',5,0.00,0.00,'','250','2018-04-25 13:23:33','250',0,1),(2436,400157,'',0,'2','1','64','E-bills collection ','','2020-04-02 12:41:45',5,0.00,0.00,'','455','2020-04-02 12:41:45','455',0,1),(2437,400158,'',0,'2','1','64','IBAL PETROLEUM','','2020-04-02 12:41:58',5,0.00,0.00,'','455','2020-04-02 12:41:58','455',0,1),(2514,400194,'',0,'2','1','64','ZNB POS','','2020-07-08 09:09:25',5,0.00,0.00,'','455','2020-07-08 09:09:25','455',0,1),(2515,400195,'',0,'2','1','64','UBA POS ','','2020-07-08 09:14:07',5,0.00,0.00,'','455','2020-07-08 09:14:07','455',0,1),(2964,400359,'',0,'2','1','64','GTB POS  0430454432','','2020-11-25 08:28:47',5,0.00,0.00,'','455','2020-11-25 08:28:47','455',0,1),(3036,400410,'',0,'2','1','64','ZNB 1017823178','','2020-12-11 08:07:12',5,0.00,0.00,'','455','2020-12-11 08:07:12','455',0,1),(3806,400665,'',0,'2','1','64','ZNB 1014717261','','2021-10-26 15:54:20',5,0.00,0.00,'','540','2021-10-26 15:54:20','540',0,1),(3936,40043,'',0,'6','1','64','CUSTOMER BALANCES','','2021-11-30 12:19:47',5,0.00,0.00,'','455','2021-11-30 12:19:47','455',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81765 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (79454,'1','64','0000-00-00','2021-05-06 09:44:24',10,'455','','0000-00-00 00:00:00','455','2021-05-06 10:04:07'),(79628,'1','64','0000-00-00','2021-05-29 10:58:11',10,'455','','0000-00-00 00:00:00','455','2021-05-29 10:59:52'),(79761,'1','64','0000-00-00','2021-06-17 10:38:33',10,'540','','0000-00-00 00:00:00','540','2021-06-17 10:40:35'),(79973,'1','64','0000-00-00','2021-08-03 08:38:14',10,'540','','0000-00-00 00:00:00','540','2021-08-03 08:53:45'),(79974,'1','64','0000-00-00','2021-08-03 08:43:44',10,'540','','0000-00-00 00:00:00','540','2021-08-03 08:53:54'),(79975,'1','64','0000-00-00','2021-08-03 08:45:53',10,'540','','0000-00-00 00:00:00','540','2021-08-03 08:54:24'),(79976,'1','64','0000-00-00','2021-08-03 08:48:19',10,'540','','0000-00-00 00:00:00','540','2021-08-03 08:54:30'),(79977,'1','64','0000-00-00','2021-08-03 08:50:20',10,'540','','0000-00-00 00:00:00','540','2021-08-03 08:54:35'),(79978,'1','64','0000-00-00','2021-08-03 08:52:18',10,'540','','0000-00-00 00:00:00','540','2021-08-03 08:55:07'),(80040,'1','64','0000-00-00','2021-08-17 12:14:07',10,'540','','0000-00-00 00:00:00','540','2021-08-17 12:15:49'),(80041,'1','64','0000-00-00','2021-08-17 12:18:35',10,'540','','0000-00-00 00:00:00','540','2021-08-17 12:19:36'),(80547,'1','64','0000-00-00','2021-10-19 12:44:19',10,'540','','0000-00-00 00:00:00','540','2021-10-19 12:46:31'),(81338,'1','64','0000-00-00','2021-11-25 11:17:20',10,'540','','0000-00-00 00:00:00','540','2021-11-25 11:18:38'),(81343,'1','64','0000-00-00','2021-11-25 11:36:40',10,'540','','0000-00-00 00:00:00','540','2021-11-25 11:38:31'),(81359,'1','64','0000-00-00','2021-11-25 13:06:22',10,'540','','0000-00-00 00:00:00','540','2021-11-25 13:06:58'),(81761,'1','64','0000-00-00','2021-11-30 12:20:25',10,'455','','0000-00-00 00:00:00','455','2021-11-30 12:20:58'),(81762,'1','64','0000-00-00','2022-06-06 12:12:11',10,'540','','0000-00-00 00:00:00','540','2022-06-06 12:38:43'),(81763,'1','64','0000-00-00','2022-06-06 12:43:03',10,'540','','0000-00-00 00:00:00','540','2022-06-09 10:08:34'),(81764,'1','64','0000-00-00','2022-06-20 15:00:45',10,'248','','0000-00-00 00:00:00','540','2022-06-21 11:45:26');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=172520 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (167200,'1','64','79454','2632','customer',0.00,'Credit Sales for 8,100 Litres of Diesel from shift 194020 @260',2106000.00,'2021-04-29'),(167202,'1','64','79454','1523','20',2106000.00,'Credit Sales for 8,100 Litres of Diesel from shift 194020 @260',0.00,'2021-04-29'),(167580,'1','64','79628','1523','20',702250.00,'Credit Sales for 2,650 Litres of Diesel from shift 200279@265',0.00,'2021-05-28'),(167581,'1','64','79628','2632','customer',0.00,'Credit Sales for 2,650 Litres of Diesel from shift 200279@265',702250.00,'2021-05-28'),(167905,'1','64','79761','1523','20',1114765.00,'Credit Sales for 4128.76 Litres of Diesel from shift 204096 on 2021-06-14',0.00,'2021-06-14'),(167906,'1','64','79761','2564','customer',0.00,'	Credit Sales for 4128.76 Litres of Diesel from shift 204096 on 2021-06-14',1114765.00,'2021-06-14'),(168378,'1','64','79973','1523','20',1073000.00,'Credit Sales for 3,700.00 Litres of Diesel from shift 212574 on 2021-07-20',0.00,'2021-07-20'),(168379,'1','64','79973','2632','customer',0.00,'	Credit Sales for 3,700.00 Litres of Diesel from shift 212574 on 2021-07-20',1073000.00,'2021-07-20'),(168380,'1','64','79974','2632','customer',0.00,'Credit Sales for 2,700.00 Litres of Diesel from shift 212603 on 2021-07-23',783000.00,'2021-07-23'),(168381,'1','64','79974','1523','20',783000.00,'	Credit Sales for 2,700.00 Litres of Diesel from shift 212603 on 2021-07-23',0.00,'2021-08-03'),(168382,'1','64','79975','2632','customer',0.00,'	Credit Sales for 900 Litres of Diesel from shift 212781 on 2021-07-24',261000.00,'2021-07-24'),(168384,'1','64','79975','1523','20',261000.00,'	Credit Sales for 900 Litres of Diesel from shift 212781 on 2021-07-24',0.00,'2021-07-24'),(168385,'1','64','79976','2632','customer',0.00,'	Credit Sales for 900 Litres of Diesel from shift 213701 on 2021-07-28',261000.00,'2021-07-28'),(168386,'1','64','79976','1523','20',261000.00,'	Credit Sales for 900 Litres of Diesel from shift 213701 on 2021-07-28',0.00,'2021-07-28'),(168387,'1','64','79977','2632','customer',0.00,'	Credit Sales for 1800 Litres of Diesel from shift 213716 on 2021-07-28',522000.00,'2021-07-28'),(168388,'1','64','79977','1523','20',522000.00,'	Credit Sales for 1800 Litres of Diesel from shift 213716 on 2021-07-28',0.00,'2021-07-28'),(168389,'1','64','79978','2632','customer',0.00,'	Credit Sales for 950 Litres of Diesel from shift 214028 on 2021-07-29',275500.00,'2021-07-29'),(168390,'1','64','79978','1523','20',275500.00,'	Credit Sales for 950 Litres of Diesel from shift 214028 on 2021-07-29',0.00,'2021-07-29'),(168519,'1','64','80040','1523','20',232000.00,'Credit Sales for 800 Litres of Diesel from shift 217693 on 2021-08-13',0.00,'2021-08-13'),(168520,'1','64','80040','2632','customer',0.00,'	Credit Sales for 800 Litres of Diesel from shift 217693 on 2021-08-13',232000.00,'2021-08-13'),(168521,'1','64','80041','1523','20',1508000.00,'Credit Sales for 5,200 Litres of Diesel from shift 217812 on 2021-08-14',0.00,'2021-08-14'),(168522,'1','64','80041','2632','customer',0.00,'Credit Sales for 5,200 Litres of Diesel from shift 217812 on 2021-08-14',1508000.00,'2021-08-14'),(169675,'1','64','80547','1523','20',288000.00,'	Credit Sales for 900.00 Litres of Diesel from shift 231871 on 2021-10-15 17:07:12',0.00,'2021-10-15'),(169676,'1','64','80547','2632','customer',0.00,'	Credit Sales for 900.00 Litres of Diesel from shift 231871 on 2021-10-15 17:07:12',288000.00,'2021-10-15'),(171635,'1','64','81338','2632','customer',0.00,'Credit Sales for 7,500 Litres of Diesel from shift 237232 @340',2550000.00,'2021-11-16'),(171638,'1','64','81338','1523','20',2550000.00,'Credit Sales for 7,500 Litres of Diesel from shift 237232 @340',0.00,'2021-11-06'),(171645,'1','64','81343','2632','customer',0.00,'Credit Sales for 2750 Litres of Diesel from shift 194550 @340',935000.00,'2021-10-23'),(171646,'1','64','81343','1523','20',935000.00,'Credit Sales for 2750 Litres of Diesel from shift 194550 @340',0.00,'2021-10-23'),(171678,'1','64','81359','1523','20',2300500.00,'system harmonization with manual record',0.00,'2021-11-06'),(171679,'1','64','81359','2632','customer',0.00,'system harmonization with manual record',2300500.00,'2021-11-25'),(172509,'1','64','81761','1212','customer',0.00,'Balance transfer to customer account, Nill off',345512771.00,'2021-11-30'),(172510,'1','64','81761','3936','6',345512771.00,'Balance transfer from BENIN 2 SS	 account, Nill off',0.00,'2021-11-30'),(172511,'1','64','81762','2632','customer',42255.20,'system harmonization with manual record',0.00,'2022-03-30'),(172512,'1','64','81762','1523','20',0.00,'system harmonization with manual record',42255.20,'2022-03-30'),(172514,'1','64','81763','1523','20',665415.00,'Credit Sales for 950.59 Litres of Diesel from shift 257758 on 2022-05-21 07:55:13',0.00,'2022-05-21'),(172515,'1','64','81763','2564','customer',0.00,'Credit Sales for 950.59 Litres of Diesel from shift 257758 on 2022-05-21 07:55:13',665415.00,'2022-05-21'),(172518,'1','64','81764','2564','customer',0.00,'Credit sales for 237.66ltrs of Diesel @815 with shift I\'d 257813',193692.90,'2022-06-19'),(172519,'1','64','81764','1523','20',193692.90,'Credit sales for 237.66ltrs of Diesel @815 with shift I\'d 257813',0.00,'2022-06-19');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=26595 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (22401,'1','64','2018-02-23','39077','1516',0.00,'2018-02-26 18:57:19',5,'248','','0000-00-00 00:00:00','250','2018-05-03 14:10:25'),(22402,'1','64','2018-02-25','39230','1516',0.00,'2018-02-26 19:00:40',5,'248','','0000-00-00 00:00:00','250','2018-05-18 15:22:16'),(22533,'1','64','2018-02-27','39369','1516',0.00,'2018-02-28 11:15:21',5,'248','','0000-00-00 00:00:00','250','2018-05-18 15:22:01'),(22675,'1','64','2018-02-28','39497','1516',0.00,'2018-03-01 09:19:30',5,'248','250','2018-05-03 13:59:48','250','2018-05-18 15:21:32'),(26563,'1','64','2018-06-01','49711','1517',0.00,'2018-07-03 10:18:55',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:24:13'),(26564,'1','64','2018-06-02','49716','1517',0.00,'2018-07-03 10:23:59',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:23:57'),(26565,'1','64','2018-06-05','50073','1517',0.00,'2018-07-03 10:26:57',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:23:37'),(26567,'1','64','2018-06-07','50292','1517',0.00,'2018-07-03 10:30:18',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:23:02'),(26568,'1','64','2018-06-08','50727','1517',0.00,'2018-07-03 10:32:21',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:22:33'),(26569,'1','64','2018-06-11','50739','1517',0.00,'2018-07-03 10:34:20',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:22:11'),(26570,'1','64','2018-06-15','51288','1517',0.00,'2018-07-03 10:36:39',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:21:58'),(26571,'1','64','2018-06-21','51913','1517',0.00,'2018-07-03 10:38:41',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:21:39'),(26572,'1','64','2018-06-22','51915','1517',0.00,'2018-07-03 10:41:09',5,'248','','0000-00-00 00:00:00','250','2018-07-05 16:21:23'),(26573,'1','64','2022-09-02','257940','1506',0.00,'2022-09-02 15:19:41',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26574,'1','64','2022-09-08','257952','1506',0.00,'2022-09-08 13:46:55',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26575,'1','64','2022-09-15','257966','1506',0.00,'2022-09-15 15:02:17',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26576,'1','64','2022-09-22','257980','1506',0.00,'2022-09-22 14:02:44',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26577,'1','64','2022-09-29','257996','1506',0.00,'2022-09-30 09:04:53',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26578,'1','64','2022-10-07','258010','1506',0.00,'2022-10-07 10:23:55',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26579,'1','64','2022-10-14','258025','1506',0.00,'2022-10-14 11:17:10',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26580,'1','64','2022-10-20','258038','1506',0.00,'2022-10-21 10:14:13',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26581,'1','64','2022-10-30','258050','1506',0.00,'2022-10-31 12:49:27',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26582,'1','64','2022-11-06','258065','1506',0.00,'2022-11-07 10:47:11',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26583,'1','64','2022-11-14','258080','1506',0.00,'2022-11-14 12:38:26',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26584,'1','64','2022-11-20','258095','1506',0.00,'2022-11-22 14:09:40',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26585,'1','64','2022-11-27','258108','1506',0.00,'2022-11-28 09:03:03',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26586,'1','64','2022-12-10','258119','1506',0.00,'2022-12-14 20:24:52',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26587,'1','64','2022-12-17','258133','1506',0.00,'2022-12-17 14:13:36',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26588,'1','64','2022-12-31','258147','1506',0.00,'2022-12-31 14:11:33',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26589,'1','64','2023-01-07','258161','1506',0.00,'2023-01-14 14:42:41',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26590,'1','64','2023-01-14','258175','1506',0.00,'2023-01-14 14:43:31',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26591,'1','64','2023-01-21','258192','1506',0.00,'2023-02-15 09:04:28',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26592,'1','64','2023-01-31','258207','1506',0.00,'2023-02-15 09:06:27',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26593,'1','64','2023-02-07','258221','1506',0.00,'2023-02-15 09:07:59',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26594,'1','64','2023-02-14','258235','1506',0.00,'2023-02-15 09:09:13',0,'248','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=57069 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (50178,'1','64',22401,1513,'STATION CAR FUEL',8700.00),(50179,'1','64',22401,1509,'OFFICE SUBS & R/CARD',2200.00),(50180,'1','64',22401,1518,'WASTE DISPOSAL',2000.00),(50181,'1','64',22402,1506,'STATION GEN 90LTRS FOR 3DAYS ',18000.00),(50403,'1','64',22533,1518,'PUMSPS WASTE DISPOSAL BASKETS 8PCS',4000.00),(50404,'1','64',22533,1518,'STANDING BROOM FOR STATION PREMISES 3PCS',2100.00),(54608,'1','64',22675,1506,'STATION GEN 90LTRS FOR 3DAYS ',17550.00),(54609,'1','64',22675,1505,'FEBRUARY SALARY 2018',372000.00),(57036,'1','64',26563,1513,'STATION CAR FUEL',5005.00),(57037,'1','64',26564,1518,'WASTE DISPOSAL',2500.00),(57038,'1','64',26565,1509,'OFFICE SUBS',2200.00),(57041,'1','64',26567,1518,'STATION SANITARY ITEMS (LIQUID SOAP & IZAL)',2400.00),(57042,'1','64',26568,1513,'STATION CAR FUEL 35LTRS',5005.00),(57043,'1','64',26569,1518,'WASTE DISPOSAL',2500.00),(57044,'1','64',26570,1513,'STATION CAR FUEL',5005.00),(57045,'1','64',26571,1518,'WASTE DISPOSAL',2500.00),(57046,'1','64',26572,1513,'STATION CAR FUEL 35LTRS',5005.00),(57047,'1','64',26573,1506,'240LITERS TO GENERATOR',182400.00),(57048,'1','64',26574,1506,'AGO 150 LITERS TO GENERATOR FOR ONE WEEK',114000.00),(57049,'1','64',26575,1506,'AGO 150 LITERS TO GENERATOR FOR ONE WEEK',114000.00),(57050,'1','64',26576,1506,'AGO 150 LITERS TO GENERATOR FOR ONE WEEK',114000.00),(57051,'1','64',26577,1506,'AGO. 150LITERS TO GENERATOR FOR ONE WEEK ',115500.00),(57052,'1','64',26578,1506,'170 LITERS TO GENERATOR FOR ONE WEEK',132600.00),(57053,'1','64',26579,1506,'AGO 150 LITERS TO GENERATOR FOR ONE WEEK',120000.00),(57054,'1','64',26580,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',136000.00),(57055,'1','64',26581,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',136000.00),(57056,'1','64',26582,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',136000.00),(57057,'1','64',26583,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',146000.00),(57058,'1','64',26584,1506,'AGO TO GENERATOR FOR ONE WEEK',142800.00),(57059,'1','64',26585,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',141100.00),(57060,'1','64',26586,1506,'AGO. 170 LITERS TO GENERATOR FOR ONE WEEK',142800.00),(57061,'1','64',26587,1506,'AGO =170 LITERS TO GENERATOR FOR ONE WEEK',139400.00),(57062,'1','64',26588,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',227720.00),(57063,'1','64',26589,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',139400.00),(57064,'1','64',26590,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',139400.00),(57065,'1','64',26591,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',137700.00),(57066,'1','64',26592,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',134300.00),(57067,'1','64',26593,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',137700.00),(57068,'1','64',26594,1506,'AGO 170 LITERS TO GENERATOR FOR ONE WEEK',137700.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3813 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1212,'','1','64','BENIN 2 SS','','','','BENIN','EDO STATE','','Nigeria',0.00,0.00,0.00,'0000-00-00','2018-02-21 14:55:02',0,'248','2018-02-21 14:55:02','248'),(2564,'','1','64','BISWALL','MAHMUD FETIH','09087990010','biswaing@gmail.com','LAGOS','LAGOS','LAGOS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-15 13:40:02',5,'455','2021-04-15 13:40:02','455'),(2632,'','1','64','ZAMSON GLOBAL RESOURCES','ALH ZAYYANU MUSA','08038678868','@gmail.com','SOKOTO','SOKOTO','NO .1  B/KB Raod ,Bado Area Sokoto','Nigeria',40000000.00,0.00,0.00,'0000-00-00','2021-04-30 16:59:09',5,'455','2022-03-29 15:01:02','540'),(3452,'','1','64','DRIVER SHORTAGE','UMAR TRANSPORT','08030647174','@gmail.com','KANO','KANO','head office kano','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-11 15:59:14',5,'540','2021-10-11 15:59:14','540'),(3810,'','1','64','EFFCC','EFFCC','080****123','@gmail.com','BENIN','BENIN','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-18 14:11:22',5,'540','2021-11-18 14:11:22','540'),(3811,'','1','64','EFCC PMS','SANI AYUBA SHARRIF','08065310217','ayubasani@yahoo.com','ABUJA','FCT','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-11 11:18:35',5,'540','2022-02-11 11:18:35','540'),(3812,'','1','64','NIGERIA POLICE FORCE (ELECTION','ONOYIMA JUDE','08034505557','dopstransport@gmail.come','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:05:08',5,'975','2023-02-21 17:05:08','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (1,'1','64','1212',0,'CLOSED','2022-03-29 15:01:37');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18494 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','64',4823,'536',6924.00,700.00,'2018-08-12','ADDITIONAL OF PMS','2018-08-12 09:45:31','248','248',2018,'248','2018-08-12 09:45:31',5),('1','64',4824,'536',700.00,20.00,'2018-08-12','ADDITIONAL','2018-08-12 10:01:41','248','248',2018,'248','2018-08-12 10:01:41',5),('1','64',4825,'536',20.00,720.00,'2018-08-12','ADDITIONAL PMS','2018-08-12 10:11:53','248','248',2018,'248','2018-08-12 10:11:53',5),('1','64',4826,'536',720.00,7650.00,'2018-08-12','ADDITIONAL PMS ','2018-08-12 10:18:01','248','248',2018,'248','2018-08-12 10:18:01',5),('1','64',4827,'538',3807.00,4200.00,'2018-08-12','ADDITIONAL PMS','2018-08-12 10:54:54','248','248',2018,'248','2018-08-12 10:54:54',5),('1','64',5044,'537',1833.00,2037.00,'2018-09-03','ADDITIONAL OF PMS','2018-09-03 19:20:59','248','248',2018,'248','2018-09-03 19:20:59',5),('1','64',5146,'539',3113.00,3150.00,'2018-09-14','ADDITIONAL AGO','2018-09-14 10:11:09','248','248',2018,'248','2018-09-14 10:11:09',5),('1','64',5757,'538',1263.00,1383.00,'2018-11-03','ADDITIONAL PURCHASE OF PMS','2018-11-03 08:39:59','248','248',2018,'248','2018-11-03 08:39:59',5),('1','64',5758,'539',25.00,50.00,'2018-11-03','ADDITIONAL PURCHASE OF AGO','2018-11-03 08:54:05','248','248',2018,'248','2018-11-03 08:54:05',5),('1','64',5826,'536',11653.00,12267.00,'2018-11-06','ADDITIONAL OF PMS','2018-11-06 14:14:47','248','248',2018,'248','2018-11-06 14:14:47',5),('1','64',5867,'538',2161.00,2183.00,'2018-11-10','ADDITIONAL OF PMS','2018-11-10 10:20:02','248','248',2018,'248','2018-11-10 10:20:02',5),('1','64',5868,'536',3934.00,4437.00,'2018-11-10','ADDITIONAL OF PMS','2018-11-10 10:41:55','248','248',2018,'248','2018-11-10 10:41:55',5),('1','64',6103,'536',5460.00,507.00,'2018-12-03','ADDITIONAL OF PMS','2018-12-03 09:45:05','248','248',2018,'248','2018-12-03 09:45:05',5),('1','64',6104,'536',507.00,5967.00,'2018-12-03','ADDITIONAL OF PMS','2018-12-03 09:49:27','248','248',2018,'248','2018-12-03 09:49:27',5),('1','64',6105,'536',0.00,668.00,'2018-12-03','ADDITIONAL OF PMS','2018-12-03 10:01:01','248','248',2018,'248','2018-12-03 10:01:01',5),('1','64',6106,'536',668.00,1129.00,'2018-12-03','ADDITIONAL OF PMS','2018-12-03 10:06:49','248','248',2018,'248','2018-12-03 10:06:49',5),('1','64',6130,'538',4827.00,4958.00,'2018-12-04','ADDITIONAL OF PMS','2018-12-04 11:38:32','248','248',2018,'248','2018-12-04 11:38:32',5),('1','64',6163,'538',7204.00,7210.00,'2018-12-06','ADDITIONAL OF PMS','2018-12-06 08:49:52','248','248',2018,'248','2018-12-06 08:49:52',5),('1','64',6241,'539',1112.00,1460.00,'2018-12-12','ADDITIONAL OF AGO','2018-12-12 09:23:23','248','248',2018,'248','2018-12-12 09:23:23',5),('1','64',6250,'539',0.00,880.00,'2018-12-12','ADDITIONAL OF AGO','2018-12-12 11:34:56','248','248',2018,'248','2018-12-12 11:34:56',5),('1','64',6479,'538',897.00,2334.00,'2019-01-02','ADDITIONAL OF PMS','2019-01-02 14:00:13','248','248',2019,'248','2019-01-02 14:00:13',5),('1','64',6480,'536',8545.00,8672.00,'2019-01-02','ADDITIONAL OF PMS','2019-01-02 14:10:52','248','248',2019,'248','2019-01-02 14:10:52',5),('1','64',6672,'538',4050.00,4160.00,'2019-01-18','ADDITIONAL OF PMS','2019-01-18 14:29:06','248','248',2019,'248','2019-01-18 14:29:06',5),('1','64',6780,'538',4073.00,4903.00,'2019-01-30','ADDITIONAL OF PMS','2019-01-30 10:40:31','248','248',2019,'248','2019-01-30 10:40:31',5),('1','64',10038,'539',757.00,1000.00,'2019-09-27','ADDITIONAL AGO','2019-09-27 15:36:34','248','248',2019,'248','2019-09-27 15:36:34',5),('1','64',10046,'539',83.00,900.00,'2019-09-28','ADDITIONAL AGO','2019-09-28 09:50:38','248','248',2019,'248','2019-09-28 09:50:38',5),('1','64',10099,'538',469.00,665.00,'2019-10-02','ADDITIONAL OF PMS','2019-10-02 10:47:03','248','248',2019,'248','2019-10-02 10:47:03',5),('1','64',10779,'538',4439.00,4725.00,'2019-11-29','ADDITIONAL OF PMS','2019-11-29 19:28:46','248','248',2019,'248','2019-11-29 19:28:46',5),('1','64',12423,'539',559.00,2300.00,'2020-07-28','additional of AGO','2020-07-28 11:21:31','248','248',2020,'248','2020-07-28 11:21:31',5),('1','64',12424,'539',2300.00,2800.00,'2020-07-28','ADDITIONAL OF AGO','2020-07-28 11:22:43','248','248',2020,'248','2020-07-28 11:22:43',5),('1','64',12425,'539',119.00,252.00,'2020-07-28','ADDITIONAL OF AGO','2020-07-28 15:21:55','248','248',2020,'248','2020-07-28 15:21:55',5),('1','64',13633,'536',4297.00,4605.00,'2021-02-07','ADDITIONAL OF PMS','2021-02-07 23:18:34','248','248',2021,'248','2021-02-07 23:18:34',5),('1','64',13958,'539',273.00,1000.00,'2021-03-11','Additional of AGO','2021-03-11 23:11:12','248','248',2021,'248','2021-03-11 23:11:12',5),('1','64',14212,'536',4253.00,4500.00,'2021-03-28','Additional of pms','2021-03-28 06:50:13','248','248',2021,'248','2021-03-28 06:50:13',5),('1','64',14375,'536',2032.00,2070.00,'2021-04-06','Additional of PMS','2021-04-06 10:49:09','248','248',2021,'248','2021-04-06 10:49:09',5),('1','64',14525,'536',1425.00,1485.00,'2021-04-20','Additional of PMS','2021-04-20 13:17:12','248','248',2021,'248','2021-04-20 13:17:12',5),('1','64',14791,'536',1849.00,2172.00,'2021-05-04','Additional of PMS','2021-05-04 11:11:17','248','248',2021,'248','2021-05-04 11:11:17',5),('1','64',15020,'536',4114.00,4243.00,'2021-05-21','Additional of PMS','2021-05-21 08:17:51','248','248',2021,'248','2021-05-21 08:17:51',5),('1','64',15089,'536',1746.00,1810.00,'2021-05-26','Additional of PMS','2021-05-26 11:15:03','248','248',2021,'248','2021-05-26 11:15:03',5),('1','64',15706,'537',4081.00,7430.00,'2021-07-12','Additional of PMS','2021-07-12 14:13:17','248','248',2021,'248','2021-07-12 14:13:17',5),('1','64',15826,'537',2374.00,2645.00,'2021-07-24','Additional of PMS','2021-07-24 14:27:16','248','248',2021,'248','2021-07-24 14:27:16',5),('1','64',16070,'537',5406.00,6110.00,'2021-08-16','Additional of PMS','2021-08-16 12:23:20','248','248',2021,'248','2021-08-16 12:23:20',5),('1','64',17245,'536',24694.79,9550.00,'2021-10-30','','2021-10-30 11:23:27','540','540',2021,'540','2021-10-30 11:23:27',5),('1','64',17246,'537',7983.95,2100.00,'2021-10-30','','2021-10-30 11:23:43','540','540',2021,'540','2021-10-30 11:23:43',5),('1','64',17247,'538',4701.00,2700.00,'2021-10-30','','2021-10-30 11:23:54','540','540',2021,'540','2021-10-30 11:23:54',5),('1','64',17248,'539',3053.00,1450.00,'2021-10-30','','2021-10-30 11:24:11','540','540',2021,'540','2021-10-30 11:24:11',5),('1','64',17249,'540',2199.00,1350.00,'2021-10-30','','2021-10-30 11:24:27','540','540',2021,'540','2021-10-30 11:24:27',5),('1','64',18463,'536',41.61,273.00,'2022-01-17','','2022-01-17 10:33:17','540','540',2022,'540','2022-01-17 10:33:17',5),('1','64',18464,'539',293.00,308.00,'2022-01-31','','2022-01-31 11:35:58','540','540',2022,'540','2022-01-31 11:35:58',5),('1','64',18465,'539',0.00,260.00,'2022-01-31','','2022-01-31 12:10:47','540','540',2022,'540','2022-01-31 12:10:47',5),('1','64',18466,'536',827.00,1530.00,'2022-02-03','','2022-02-03 19:51:33','540','540',2022,'540','2022-02-03 19:51:33',5),('1','64',18467,'536',5550.00,5612.00,'2022-02-11','','2022-02-11 15:22:37','540','540',2022,'540','2022-02-11 15:22:37',5),('1','64',18468,'536',9338.00,9900.00,'2022-02-17','','2022-02-17 10:13:44','540','540',2022,'540','2022-02-17 10:13:44',5),('1','64',18469,'536',10716.00,11022.00,'2022-02-21','','2022-02-21 12:17:49','540','540',2022,'540','2022-02-21 12:17:49',5),('1','64',18470,'538',3715.00,21300.00,'2022-02-23','','2022-02-23 11:31:29','540','540',2022,'540','2022-02-23 11:31:29',5),('1','64',18471,'537',20223.21,2350.00,'2022-02-23','','2022-02-23 11:31:50','540','540',2022,'540','2022-02-23 11:31:50',5),('1','64',18472,'539',5642.00,5870.00,'2022-03-04','','2022-03-04 16:06:58','540','540',2022,'540','2022-03-04 16:06:58',5),('1','64',18473,'539',1.00,1025.00,'2022-03-05','','2022-03-05 14:03:39','540','540',2022,'540','2022-03-05 14:03:39',5),('1','64',18474,'536',4511.00,4650.00,'2022-03-24','','2022-03-24 19:46:16','540','540',2022,'540','2022-03-24 19:46:16',5),('1','64',18475,'539',1013.00,1170.00,'2022-04-01','','2022-04-01 16:17:28','540','540',2022,'540','2022-04-01 16:17:28',5),('1','64',18476,'536',4874.00,4920.00,'2022-04-07','','2022-04-07 16:15:07','540','540',2022,'540','2022-04-07 16:15:07',5),('1','64',18477,'536',2925.00,3145.00,'2022-04-12','','2022-04-12 10:02:40','540','540',2022,'540','2022-04-12 10:02:40',5),('1','64',18478,'539',218.00,250.00,'2022-04-13','','2022-04-13 13:12:21','540','540',2022,'540','2022-04-13 13:12:21',5),('1','64',18479,'536',101.00,273.00,'2022-05-04','','2022-05-04 21:25:13','648','648',2022,'648','2022-05-04 21:25:13',5),('1','64',18480,'536',2355.00,2730.00,'2022-05-15','','2022-05-15 07:16:41','648','648',2022,'648','2022-05-15 07:16:41',5),('1','64',18481,'539',1057.00,1836.00,'2022-05-16','','2022-05-16 09:26:16','648','648',2022,'648','2022-05-16 09:26:16',5),('1','64',18482,'536',3882.00,4257.00,'2022-05-25','','2022-05-25 14:03:19','648','648',2022,'648','2022-05-25 14:03:19',5),('1','64',18483,'539',1006.00,1205.00,'2022-06-05','','2022-06-05 12:38:15','648','648',2022,'648','2022-06-05 12:38:15',5),('1','64',18484,'536',6983.00,8900.00,'2022-06-07','system harmonization with manual record','2022-06-07 10:38:14','540','540',2022,'540','2022-06-07 10:38:14',5),('1','64',18485,'538',14119.00,13800.00,'2022-06-07','system harmonization with manual record','2022-06-07 10:38:32','540','540',2022,'540','2022-06-07 10:38:32',5),('1','64',18486,'539',2.00,1100.00,'2022-06-07','system harmonization with manual record','2022-06-07 10:39:46','540','540',2022,'540','2022-06-07 10:39:46',5),('1','64',18487,'536',2683.00,3390.00,'2022-09-01','','2022-09-01 19:24:47','648','648',2022,'648','2022-09-01 19:24:47',5),('1','64',18488,'536',3390.00,3390.00,'2022-09-01','','2022-09-01 19:24:47','648','648',2022,'648','2022-09-01 19:24:47',5),('1','64',18489,'536',2473.55,2709.00,'2022-10-22','','2022-10-22 09:50:29','648','648',2022,'648','2022-10-22 09:50:29',5),('1','64',18490,'538',1004.70,1049.00,'2023-01-04','','2023-01-04 12:59:46','648','648',2023,'648','2023-01-04 12:59:46',5),('1','64',18491,'538',117.50,200.00,'2023-03-01','','2023-03-01 09:05:25','648','648',2023,'648','2023-03-01 09:05:25',5),('1','64',18492,'536',4986.27,6070.00,'2023-03-09','','2023-03-09 10:00:33','648','648',2023,'648','2023-03-09 10:00:33',5),('1','64',18493,'536',4952.00,5584.00,'2023-03-13','','2023-03-13 13:05:26','648','648',2023,'648','2023-03-13 13:05:26',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1491 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','64','536',1480,'5','P 1',3688418.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','536',1481,'5','P 2',4648841.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','536',1482,'5','P 3',1773895.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','536',1483,'5','P 4',2524424.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','537',1484,'5','P 5',3226741.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','537',1485,'5','P 6',3909994.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','538',1486,'5','P 7',2512599.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','538',1487,'5','P 8',2723489.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','539',1488,'5','AGO 1',2348091.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','539',1489,'5','AGO 2',793913.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','64','540',1490,'5','DPK 1',117693.07,'',NULL,NULL,NULL,NULL,5,'2019-12-23 10:47:33','455');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258282 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','64',38985,'EVENING SHIFT','2018-02-22','2018-02-22 00:00:00',NULL,'248',783989.40,783989.40,'248','2018-02-23 11:02:46','248','2018-02-23 11:04:40',10,0),('1','64',39077,'EVENING SHIFT','2018-02-23','2018-02-23 00:00:00',NULL,'248',373815.00,373815.00,'248','2018-02-24 10:28:23','248','2018-02-24 10:29:44',10,0),('1','64',39078,'PRICE CHANGE SHIFT','2018-02-23','2018-02-23 00:00:00',NULL,'248',233123.50,233123.50,'248','2018-02-24 10:49:44','248','2018-02-24 10:51:29',10,0),('1','64',39227,'EVENING SHIFT','2018-02-24','2018-02-24 00:00:00',NULL,'248',532063.90,532063.90,'248','2018-02-25 18:33:59','248','2018-02-25 18:35:00',10,0),('1','64',39230,'EVENING SHIFT','2018-02-25','2018-02-25 00:00:00',NULL,'248',542685.70,542685.70,'248','2018-02-26 12:12:20','248','2018-02-26 12:13:25',10,0),('1','64',39291,'EVENING SHIFT','2018-02-26','2018-02-26 00:00:00',NULL,'248',182000.00,182000.00,'248','2018-02-26 12:16:12','248','2018-02-26 12:17:14',10,0),('1','64',39293,'PRICE CHANGE SHIFT','2018-02-26','2018-02-26 00:00:00',NULL,'248',579276.50,579276.50,'248','2018-02-27 08:43:36','248','2018-02-27 08:47:07',10,0),('1','64',39369,'EVENING SHIFT','2018-02-27','2018-02-27 00:00:00',NULL,'248',752936.70,752936.70,'248','2018-02-28 10:29:52','248','2018-02-28 10:32:42',10,0),('1','64',39497,'EVENING SHIFT','2018-02-28','2018-02-28 00:00:00',NULL,'248',2580558.30,2580558.30,'248','2018-03-01 09:02:46','248','2018-03-01 09:04:04',10,0),('1','64',39593,'EVENING SHIFT','2018-03-01','2018-03-01 00:00:00',NULL,'248',1548617.60,1548617.60,'248','2018-03-02 09:50:05','248','2018-03-02 09:54:10',10,0),('1','64',39829,'EVENING SHIFT','2018-03-02','2018-03-02 00:00:00',NULL,'248',1562250.30,1562250.30,'248','2018-03-03 13:26:33','248','2018-03-03 13:27:32',10,0),('1','64',39956,'EVENING SHIFT','2018-03-03','2018-03-03 00:00:00',NULL,'248',0.00,0.00,'248','2018-03-04 19:41:45','248','2018-03-04 19:42:56',10,0),('1','64',39957,'EVENING SHIFT','2018-03-04','2018-03-04 00:00:00',NULL,'248',3966776.70,3966776.70,'248','2018-03-05 12:29:49','248','2018-03-05 13:05:13',10,0),('1','64',40048,'EVENING SHIFT','2018-03-05','2018-03-05 00:00:00',NULL,'248',4273119.90,4273119.90,'248','2018-03-05 19:58:49','248','2018-03-05 20:33:33',10,0),('1','64',40096,'EVENING SHIFT','2018-03-06','2018-03-06 00:00:00',NULL,'248',3869066.30,3869066.30,'248','2018-03-10 14:16:28','248','2018-03-10 14:17:24',10,0),('1','64',40632,'EVENING SHIFT','2018-03-07','2018-03-07 00:00:00',NULL,'248',3872598.00,3872598.00,'248','2018-03-10 14:24:40','248','2018-03-10 14:25:56',10,0),('1','64',40634,'EVENING SHIFT','2018-03-08','2018-03-08 00:00:00',NULL,'248',4794025.60,4794025.60,'248','2018-03-10 14:32:45','248','2018-03-10 14:33:52',10,0),('1','64',40636,'EVENING SHIFT','2018-03-09','2018-03-09 00:00:00',NULL,'248',4173697.80,4173697.80,'248','2018-03-10 14:45:20','248','2018-03-10 14:46:11',10,0),('1','64',40638,'EVENING SHIFT','2018-03-10','2018-03-10 00:00:00',NULL,'248',4233040.10,4233040.10,'248','2018-03-11 10:26:09','248','2018-03-11 10:26:58',10,0),('1','64',40687,'EVENING SHIFT','2018-03-11','2018-03-11 00:00:00',NULL,'248',2560748.80,2560748.80,'248','2018-03-12 10:49:10','248','2018-03-12 10:50:16',10,0),('1','64',40794,'EVENING SHIFT','2018-03-12','2018-03-12 00:00:00',NULL,'248',3579347.40,3579347.40,'248','2018-03-14 19:01:16','248','2018-03-14 19:02:38',10,0),('1','64',41112,'EVENING SHIFT','2018-03-13','2018-03-13 00:00:00',NULL,'248',2386024.40,2386024.40,'248','2018-03-15 11:03:30','248','2018-03-15 11:06:55',10,0),('1','64',41150,'EVENING SHIFT','2018-03-14','2018-03-14 00:00:00',NULL,'248',2916169.40,2916169.40,'248','2018-03-15 11:13:42','248','2018-03-15 11:14:33',10,0),('1','64',41151,'EVENING SHIFT','2018-03-15','2018-03-15 00:00:00',NULL,'248',3032875.10,3032875.10,'248','2018-03-16 19:51:07','248','2018-03-16 19:51:59',10,0),('1','64',41319,'EVENING SHIFT','2018-03-16','2018-03-16 00:00:00',NULL,'248',3280329.40,3280329.40,'248','2018-03-17 10:51:23','248','2018-03-17 10:51:56',10,0),('1','64',41352,'EVENING SHIFT','2018-03-17','2018-03-17 00:00:00',NULL,'248',3625448.60,3625448.60,'248','2018-03-20 12:08:31','248','2018-03-20 12:10:04',10,0),('1','64',41693,'EVENING SHIFT','2018-03-18','2018-03-18 00:00:00',NULL,'248',3110033.20,3110033.20,'248','2018-03-20 12:13:40','248','2018-03-20 12:14:14',10,0),('1','64',41694,'EVENING SHIFT','2018-03-19','2018-03-19 00:00:00',NULL,'248',3747745.30,3747745.30,'248','2018-03-20 12:20:17','248','2018-03-20 12:20:57',10,0),('1','64',41696,'EVENING SHIFT','2018-03-20','2018-03-20 00:00:00',NULL,'248',3649820.10,3649820.10,'248','2018-03-21 12:38:25','248','2018-03-21 12:39:18',10,0),('1','64',41811,'EVENING SHIFT','2018-03-21','2018-03-21 00:00:00',NULL,'248',3608036.20,3608036.20,'248','2018-03-22 19:09:54','248','2018-03-22 19:12:10',10,0),('1','64',41968,'EVENING SHIFT','2018-03-22','2018-03-22 00:00:00',NULL,'248',3305848.10,3305848.10,'248','2018-03-24 10:30:01','248','2018-03-24 10:31:04',10,0),('1','64',42102,'EVENING SHIFT','2018-03-23','2018-03-23 00:00:00',NULL,'248',4016649.00,4016649.00,'248','2018-03-24 10:44:55','248','2018-03-24 10:45:39',10,0),('1','64',42104,'EVENING SHIFT','2018-03-24','2018-03-24 00:00:00',NULL,'248',4007713.80,4007713.80,'248','2018-03-27 13:21:58','248','2018-03-27 13:23:53',10,0),('1','64',42461,'EVENING SHIFT','2018-03-25','2018-03-25 00:00:00',NULL,'248',2952168.60,2952168.60,'248','2018-03-27 13:32:55','248','2018-03-27 13:34:27',10,0),('1','64',42462,'EVENING SHIFT','2018-03-26','2018-03-26 00:00:00',NULL,'248',3474601.80,3474601.80,'248','2018-03-27 13:41:58','248','2018-03-27 13:42:46',10,0),('1','64',42463,'EVENING SHIFT','2018-03-27','2018-03-27 00:00:00',NULL,'248',3586607.90,3586607.90,'248','2018-03-29 19:19:30','248','2018-03-29 19:20:18',10,0),('1','64',42741,'EVENING SHIFT','2018-03-28','2018-03-28 00:00:00',NULL,'248',3755725.50,3755725.50,'248','2018-03-29 20:01:33','248','2018-03-29 20:02:18',10,0),('1','64',42961,'EVENING SHIFT','2018-04-29','2018-04-29 00:00:00',NULL,'248',3831671.20,3831671.20,'248','2018-04-01 11:32:53','248','2018-04-01 11:39:38',10,0),('1','64',42964,'EVENING SHIFT','2018-03-30','2018-03-30 00:00:00',NULL,'248',2931322.10,2931322.10,'248','2018-04-02 19:56:49','248','2018-04-02 19:57:44',10,0),('1','64',43153,'EVENING SHIFT','2018-03-31','2018-03-31 00:00:00',NULL,'248',3378007.90,3378007.90,'248','2018-04-02 20:09:17','248','2018-04-02 20:11:22',10,0),('1','64',43154,'EVENING SHIFT','2018-04-01','2018-04-01 00:00:00',NULL,'248',3322527.00,3322527.00,'248','2018-04-04 08:34:57','248','2018-04-04 08:35:54',10,0),('1','64',43287,'EVENING SHIFT','2018-04-02','2018-04-02 00:00:00',NULL,'248',524030.00,524030.00,'248','2018-04-04 08:40:10','248','2018-04-04 08:41:41',10,0),('1','64',43288,'PRICE CHANGE SHIFT','2018-04-02','2018-04-02 00:00:00',NULL,'248',3042045.10,3042045.10,'248','2018-04-04 08:49:24','248','2018-04-04 08:51:20',10,0),('1','64',43291,'EVENING SHIFT','2018-04-03','2018-04-03 00:00:00',NULL,'248',3812163.00,3812163.00,'248','2018-04-04 09:43:38','248','2018-04-04 09:47:09',10,0),('1','64',43302,'EVENING SHIFT','2018-04-04','2018-04-04 00:00:00',NULL,'248',3541911.00,3541911.00,'248','2018-04-05 08:09:50','248','2018-04-05 08:16:15',10,0),('1','64',43388,'EVENING SHIFT','2018-04-05','2018-04-05 00:00:00',NULL,'248',4306481.40,4306481.40,'248','2018-04-15 21:11:04','248','2018-04-15 21:11:55',10,0),('1','64',44601,'EVENING SHIFT','2018-04-06','2018-04-06 00:00:00',NULL,'248',4242074.90,4242074.90,'248','2018-04-15 21:17:03','248','2018-04-15 21:17:59',10,0),('1','64',44602,'EVENING SHIFT','2018-04-07','2018-04-07 00:00:00',NULL,'248',3931025.30,3931025.30,'248','2018-04-15 21:24:57','248','2018-04-15 21:25:50',10,0),('1','64',44603,'EVENING SHIFT','2018-04-08','2018-04-08 00:00:00',NULL,'248',3108605.50,3108605.50,'248','2018-04-15 21:30:56','248','2018-04-15 21:31:42',10,0),('1','64',44604,'EVENING SHIFT','2018-04-09','2018-04-09 00:00:00',NULL,'248',3658962.00,3658962.00,'248','2018-04-16 09:38:14','248','2018-04-16 09:39:05',10,0),('1','64',44628,'EVENING SHIFT','2018-04-10','2018-04-10 00:00:00',NULL,'248',4489797.90,4489797.90,'248','2018-04-16 09:44:59','248','2018-04-16 09:45:41',10,0),('1','64',44631,'EVENING SHIFT','2018-04-11','2018-04-11 00:00:00',NULL,'248',4235885.30,4235885.30,'248','2018-04-16 09:49:46','248','2018-04-16 09:50:17',10,0),('1','64',44632,'EVENING SHIFT','2018-04-12','2018-04-12 00:00:00',NULL,'248',4113997.30,4113997.30,'248','2018-04-16 09:54:48','248','2018-04-16 09:55:27',10,0),('1','64',44633,'EVENING SHIFT','2018-04-13','2018-04-13 00:00:00',NULL,'248',687570.00,687570.00,'248','2018-04-16 09:57:56','248','2018-04-16 09:58:36',10,0),('1','64',44637,'PRICE CHANGE SHIFT','2018-04-13','2018-04-13 00:00:00',NULL,'248',3659614.10,3659614.10,'248','2018-04-16 10:06:15','248','2018-04-16 10:08:15',10,0),('1','64',44639,'EVENING SHIFT','2018-04-14','2018-04-14 00:00:00',NULL,'248',3783313.30,3783313.30,'248','2018-04-17 12:53:23','248','2018-04-17 13:01:41',10,0),('1','64',44803,'EVENING SHIFT','2018-04-15','2018-04-15 00:00:00',NULL,'248',144875.80,144875.80,'248','2018-04-17 13:15:54','248','2018-04-17 13:22:13',10,0),('1','64',44822,'PRICE CHANGE SHIFT','2018-04-15','2018-04-15 00:00:00',NULL,'248',3080155.00,3080155.00,'248','2018-04-17 14:08:34','248','2018-04-17 14:09:51',10,0),('1','64',44824,'EVENING SHIFT','2018-04-16','2018-04-16 00:00:00',NULL,'248',40350.00,40350.00,'248','2018-04-17 14:13:18','248','2018-04-17 14:17:13',10,0),('1','64',44830,'PRICE CHANGE SHIFT','2018-04-16','2018-04-16 00:00:00',NULL,'248',3524672.80,3524672.80,'248','2018-04-17 14:24:49','248','2018-04-17 14:28:38',10,0),('1','64',44832,'EVENING SHIFT','2018-04-17','2018-04-17 00:00:00',NULL,'248',3565207.80,3565207.80,'248','2018-04-18 20:32:56','248','2018-04-18 20:33:42',10,0),('1','64',44971,'EVENING SHIFT','2018-04-18','2018-04-18 00:00:00',NULL,'248',3170780.80,3170780.80,'248','2018-04-20 10:12:06','248','2018-04-20 10:12:43',10,0),('1','64',45113,'EVENING SHIFT','2018-04-19','2018-04-19 00:00:00',NULL,'248',3244945.00,3244945.00,'248','2018-04-20 10:17:53','248','2018-04-20 10:18:36',10,0),('1','64',45115,'EVENING SHIFT','2018-04-20','2018-04-20 00:00:00',NULL,'248',3899927.40,3899927.40,'248','2018-04-22 18:35:43','248','2018-04-22 18:37:06',10,0),('1','64',45389,'EVENING SHIFT','2018-04-21','2018-04-21 00:00:00',NULL,'248',4098338.00,4098338.00,'248','2018-04-22 18:41:33','248','2018-04-22 18:42:28',10,0),('1','64',45390,'EVENING SHIFT','2018-04-22','2018-04-22 00:00:00',NULL,'248',3439611.80,3439611.80,'248','2018-04-23 17:49:11','248','2018-04-23 17:51:37',10,0),('1','64',45509,'EVENING SHIFT','2018-04-23','2018-04-23 00:00:00',NULL,'248',4453266.40,4453266.40,'248','2018-04-24 08:43:54','248','2018-04-24 08:50:27',10,0),('1','64',45538,'EVENING SHIFT','2018-04-24','2018-04-24 00:00:00',NULL,'248',2302047.20,2302047.20,'248','2018-04-25 08:33:15','248','2018-04-25 08:34:17',10,0),('1','64',45643,'EVENING SHIFT','2018-04-25','2018-04-25 00:00:00',NULL,'248',18552.60,18552.60,'248','2018-04-26 08:00:43','248','2018-04-26 08:02:31',10,0),('1','64',45736,'PRICE CHANGE SHIFT','2018-04-25','2018-04-25 00:00:00',NULL,'248',1294697.50,1294697.50,'248','2018-04-27 09:06:14','248','2018-04-27 09:07:32',10,0),('1','64',45846,'EVENING SHIFT','2018-04-26','2018-04-26 00:00:00',NULL,'248',4440750.60,4440750.60,'248','2018-04-27 09:12:27','248','2018-04-27 09:13:09',10,0),('1','64',45848,'EVENING SHIFT','2018-04-27','2018-04-27 00:00:00',NULL,'248',4689649.00,4689649.00,'248','2018-04-28 11:36:22','248','2018-04-28 11:46:03',10,0),('1','64',45970,'EVENING SHIFT','2018-04-28','2018-04-28 00:00:00',NULL,'248',4074019.30,4074019.30,'248','2018-05-01 09:51:33','248','2018-05-01 09:52:18',10,0),('1','64',46265,'EVENING SHIFT','2018-04-29','2018-04-29 00:00:00',NULL,'248',3623004.20,3623004.20,'248','2018-05-01 10:00:36','248','2018-05-01 10:01:14',10,0),('1','64',46267,'EVENING SHIFT','2018-04-30','2018-04-30 00:00:00',NULL,'248',4737614.00,4737614.00,'248','2018-05-01 10:05:38','248','2018-05-01 10:06:23',10,0),('1','64',46268,'EVENING SHIFT','2018-05-01','2018-05-01 00:00:00',NULL,'248',4161333.20,4161333.20,'248','2018-05-03 08:48:45','248','2018-05-03 08:53:15',10,0),('1','64',46486,'EVENING SHIFT','2018-05-02','2018-05-02 00:00:00',NULL,'248',4534979.80,4534979.80,'248','2018-05-03 08:57:49','248','2018-05-03 08:59:07',10,0),('1','64',46488,'EVENING SHIFT','2018-05-03','2018-05-03 00:00:00',NULL,'248',4736050.30,4736050.30,'248','2018-05-07 08:10:05','248','2018-05-07 08:11:49',10,0),('1','64',46890,'EVENING SHIFT','2018-05-04','2018-05-04 00:00:00',NULL,'248',4608358.70,4608358.70,'248','2018-05-07 09:43:20','248','2018-05-07 09:44:12',10,0),('1','64',46903,'EVENING SHIFT','2018-05-05','2018-05-05 00:00:00',NULL,'248',4358200.60,4358200.60,'248','2018-05-07 09:53:07','248','2018-05-07 09:54:21',10,0),('1','64',46906,'EVENING SHIFT','2018-05-06','2018-05-06 00:00:00',NULL,'248',3772682.70,3772682.70,'248','2018-05-07 10:01:54','248','2018-05-07 10:02:38',10,0),('1','64',46907,'EVENING SHIFT','2018-05-07','2018-05-07 00:00:00',NULL,'248',3660487.90,3660487.90,'248','2018-05-10 10:36:28','248','2018-05-10 10:37:38',10,0),('1','64',47268,'EVENING SHIFT','2018-05-08','2018-05-08 00:00:00',NULL,'248',2752139.20,2752139.20,'248','2018-05-11 11:08:18','248','2018-05-11 11:08:57',10,0),('1','64',47386,'EVENING SHIFT','2018-05-09','2018-05-09 00:00:00',NULL,'248',2825499.10,2825499.10,'248','2018-05-11 11:20:53','248','2018-05-11 11:21:37',10,0),('1','64',47390,'EVENING SHIFT','2018-05-10','2018-05-10 00:00:00',NULL,'248',4125815.00,4125815.00,'248','2018-05-11 11:26:00','248','2018-05-11 11:26:44',10,0),('1','64',47391,'EVENING SHIFT','2018-05-11','2018-05-11 00:00:00',NULL,'248',265440.00,265440.00,'248','2018-05-11 11:28:59','248','2018-05-11 11:29:46',10,0),('1','64',47626,'PRICE CHANGE SHIFT','2018-05-11','2018-05-11 00:00:00',NULL,'248',4145320.00,4145320.00,'248','2018-05-13 17:52:58','248','2018-05-13 17:54:12',10,0),('1','64',47627,'EVENING SHIFT','2018-05-12','2018-05-12 00:00:00',NULL,'248',3552150.00,3552150.00,'248','2018-05-14 08:32:48','248','2018-05-14 08:33:54',10,0),('1','64',47648,'EVENING SHIFT','2018-05-13','2018-05-13 00:00:00',NULL,'248',3411023.00,3411023.00,'248','2018-05-14 08:37:37','248','2018-05-14 08:38:22',10,0),('1','64',47651,'EVENING SHIFT','2018-05-14','2018-05-14 00:00:00',NULL,'248',2778310.10,2778310.10,'248','2018-05-16 12:55:57','248','2018-05-16 12:56:53',10,0),('1','64',47934,'EVENING SHIFT','2018-05-15','2018-05-15 00:00:00',NULL,'248',4162596.00,4162596.00,'248','2018-05-16 13:04:05','248','2018-05-16 13:04:47',10,0),('1','64',47938,'EVENING SHIFT','2018-05-16','2018-05-16 00:00:00',NULL,'248',4294062.20,4294062.20,'248','2018-05-17 11:17:34','248','2018-05-17 11:18:26',10,0),('1','64',48018,'EVENING SHIFT','2018-05-17','2018-05-17 00:00:00',NULL,'248',3788750.00,3788750.00,'248','2018-05-19 10:34:11','248','2018-05-19 10:35:03',10,0),('1','64',48236,'EVENING SHIFT','2018-05-18','2018-05-18 00:00:00',NULL,'248',4548859.50,4548859.50,'248','2018-05-19 10:47:35','248','2018-05-19 10:48:31',10,0),('1','64',48238,'EVENING SHIFT','2018-05-19','2018-05-19 00:00:00',NULL,'248',4412165.40,4412165.40,'248','2018-05-21 09:03:35','248','2018-05-21 09:04:19',10,0),('1','64',48389,'EVENING SHIFT','2018-05-20','2018-05-20 00:00:00',NULL,'248',3730471.50,3730471.50,'248','2018-05-21 09:09:40','248','2018-05-21 09:10:17',10,0),('1','64',48391,'EVENING SHIFT','2018-05-21','2018-05-21 00:00:00',NULL,'248',4135756.40,4135756.40,'248','2018-05-23 16:59:41','248','2018-05-23 17:00:47',10,0),('1','64',48699,'EVENING SHIFT','2018-05-22','2018-05-22 00:00:00',NULL,'248',3622096.90,3622096.90,'248','2018-05-23 17:06:42','248','2018-05-23 17:07:54',10,0),('1','64',48700,'EVENING SHIFT','2018-05-23','2018-05-23 00:00:00',NULL,'248',3048710.70,3048710.70,'248','2018-05-25 10:07:55','248','2018-05-25 10:09:40',10,0),('1','64',48855,'EVENING SHIFT','2018-05-24','2018-05-24 00:00:00',NULL,'248',2385557.30,2385557.30,'248','2018-05-29 12:14:18','248','2018-05-29 12:15:26',10,0),('1','64',49324,'EVENING SHIFT','2018-05-25','2018-05-25 00:00:00',NULL,'248',3309056.20,3309056.20,'248','2018-05-29 12:23:14','248','2018-05-29 12:24:21',10,0),('1','64',49327,'EVENING SHIFT','2018-05-26','2018-05-26 00:00:00',NULL,'248',3037998.50,3037998.50,'248','2018-05-29 12:47:38','248','2018-05-29 12:49:05',10,0),('1','64',49328,'EVENING SHIFT','2018-05-27','2018-05-27 00:00:00',NULL,'248',2486066.00,2486066.00,'248','2018-05-29 12:53:14','248','2018-05-29 12:57:25',10,0),('1','64',49333,'EVENING SHIFT','2018-05-28','2018-05-28 00:00:00',NULL,'248',1657370.00,1657370.00,'248','2018-05-31 12:27:22','248','2018-05-31 12:30:32',10,0),('1','64',49541,'EVENING SHIFT','2018-05-29','2018-05-29 00:00:00',NULL,'248',3113768.00,3113768.00,'248','2018-06-02 10:46:29','248','2018-06-02 10:48:01',10,0),('1','64',49705,'EVENING SHIFT','2018-05-30','2018-05-30 00:00:00',NULL,'248',4063175.00,4063175.00,'248','2018-06-02 10:52:33','248','2018-06-02 10:53:21',10,0),('1','64',49706,'EVENING SHIFT','2018-05-31','2018-05-31 00:00:00',NULL,'248',3876364.00,3876364.00,'248','2018-06-02 10:57:48','248','2018-06-02 10:59:15',10,0),('1','64',49711,'EVENING SHIFT','2018-06-01','2018-06-01 00:00:00',NULL,'248',4324890.00,4324890.00,'248','2018-06-02 11:18:55','248','2018-06-02 11:19:27',10,0),('1','64',49716,'EVENING SHIFT','2018-06-02','2018-06-02 00:00:00',NULL,'248',3975531.00,3975531.00,'248','2018-06-04 09:29:03','248','2018-06-04 09:36:40',10,0),('1','64',49929,'EVENING SHIFT','2018-06-03','2018-06-03 00:00:00',NULL,'248',2850861.00,2850861.00,'248','2018-06-04 09:42:17','248','2018-06-04 09:43:25',10,0),('1','64',49931,'EVENING SHIFT','2018-06-04','2018-06-04 00:00:00',NULL,'248',2771959.00,2771959.00,'248','2018-06-05 12:17:58','248','2018-06-05 12:18:38',10,0),('1','64',50073,'EVENING SHIFT','2018-06-05','2018-06-05 00:00:00',NULL,'248',4624193.00,4624193.00,'248','2018-06-07 09:59:21','248','2018-06-07 10:00:52',10,0),('1','64',50280,'EVENING SHIFT','2018-06-06','2018-06-06 00:00:00',NULL,'248',3779915.00,3779915.00,'248','2018-06-07 10:44:01','248','2018-06-07 10:48:01',10,0),('1','64',50292,'MORNING SHIFT','2018-06-07','2018-06-07 00:00:00',NULL,'248',1854987.00,1854987.00,'248','2018-06-07 13:12:41','248','2018-06-07 13:13:38',10,0),('1','64',50311,'AFTERNOON SHIFT','2018-06-07','2018-06-07 00:00:00',NULL,'248',184230.00,184230.00,'248','2018-06-08 09:10:03','248','2018-06-08 09:11:00',10,0),('1','64',50383,'PRICE CHANGE SHIFT','2018-06-07','2018-06-07 00:00:00',NULL,'248',2069853.00,2069853.00,'248','2018-06-11 11:21:54','248','2018-06-11 11:23:16',10,0),('1','64',50727,'MORNING SHIFT','2018-06-08','2018-06-08 00:00:00',NULL,'248',1587423.00,1587423.00,'248','2018-06-11 11:26:05','248','2018-06-11 11:26:38',10,0),('1','64',50729,'AFTERNOON SHIFT','2018-06-08','2018-06-08 00:00:00',NULL,'248',2178469.00,2178469.00,'248','2018-06-11 11:29:52','248','2018-06-11 11:30:34',10,0),('1','64',50730,'MORNING SHIFT','2018-06-09','2018-06-09 00:00:00',NULL,'248',1993651.00,1993651.00,'248','2018-06-11 11:35:19','248','2018-06-11 11:35:56',10,0),('1','64',50731,'AFTERNOON SHIFT','2018-06-09','2018-06-09 00:00:00',NULL,'248',2224385.00,2224385.00,'248','2018-06-11 11:47:46','248','2018-06-11 11:48:28',10,0),('1','64',50734,'MORNING SHIFT','2018-06-10','2018-06-10 00:00:00',NULL,'248',1736238.00,1736238.00,'248','2018-06-11 11:53:36','248','2018-06-11 11:54:23',10,0),('1','64',50737,'AFTERNOON SHIFT','2018-06-10','2018-06-10 00:00:00',NULL,'248',1749555.00,1749555.00,'248','2018-06-11 12:01:04','248','2018-06-11 12:01:49',10,0),('1','64',50739,'MORNING SHIFT','2018-06-11','2018-06-11 00:00:00',NULL,'248',1791481.00,1791481.00,'248','2018-06-13 23:52:42','248','2018-06-13 23:53:22',10,0),('1','64',51025,'AFTERNOON SHIFT','2018-06-11','2018-06-11 00:00:00',NULL,'248',1851140.00,1851140.00,'248','2018-06-13 23:56:18','248','2018-06-13 23:57:08',10,0),('1','64',51026,'MORNING SHIFT','2018-06-12','2018-06-12 00:00:00',NULL,'248',1934536.00,1934536.00,'248','2018-06-14 00:01:11','248','2018-06-14 00:01:57',10,0),('1','64',51027,'AFTERNOON SHIFT','2018-06-12','2018-06-12 00:00:00',NULL,'248',2370460.00,2370460.00,'248','2018-06-14 00:05:18','248','2018-06-14 00:06:03',10,0),('1','64',51028,'MORNING SHIFT','2018-06-13','2018-06-13 00:00:00',NULL,'248',2181488.00,2181488.00,'248','2018-06-16 22:00:57','248','2018-06-16 22:01:38',10,0),('1','64',51285,'AFTERNOON SHIFT','2018-06-13','2018-06-13 00:00:00',NULL,'248',2174571.00,2174571.00,'248','2018-06-16 22:05:43','248','2018-06-16 22:06:38',10,0),('1','64',51286,'MORNING SHIFT','2018-06-14','2018-06-14 00:00:00',NULL,'248',1957713.00,1957713.00,'248','2018-06-16 22:10:36','248','2018-06-16 22:11:24',10,0),('1','64',51287,'AFTERNOON SHIFT','2018-06-14','2018-06-14 00:00:00',NULL,'248',2311230.00,2311230.00,'248','2018-06-16 22:15:21','248','2018-06-16 22:16:18',10,0),('1','64',51288,'MORNING SHIFT','2018-06-15','2018-06-15 00:00:00',NULL,'248',2126367.00,2126367.00,'248','2018-06-16 22:24:59','248','2018-06-16 22:26:20',10,0),('1','64',51289,'AFTERNOON SHIFT','2018-06-15','2018-06-15 00:00:00',NULL,'248',1648584.00,1648584.00,'248','2018-06-16 22:30:30','248','2018-06-16 22:31:14',10,0),('1','64',51290,'MORNING SHIFT','2018-06-16','2018-06-16 00:00:00',NULL,'248',1822337.00,1822337.00,'248','2018-06-16 22:45:10','248','2018-06-16 22:46:15',10,0),('1','64',51291,'AFTERNOON SHIFT','2018-06-16','2018-06-16 00:00:00',NULL,'248',1938079.00,1938079.00,'248','2018-06-21 17:39:53','248','2018-06-21 17:41:15',10,0),('1','64',51875,'MORNING SHIFT','2018-06-17','2018-06-17 00:00:00',NULL,'248',1344475.00,1344475.00,'248','2018-06-21 17:45:20','248','2018-06-21 17:46:21',10,0),('1','64',51876,'AFTERNOON SHIFT','2018-06-17','2018-06-17 00:00:00',NULL,'248',1445708.00,1445708.00,'248','2018-06-21 17:51:21','248','2018-06-21 17:52:13',10,0),('1','64',51877,'MORNING SHIFT','2018-06-18','2018-06-18 00:00:00',NULL,'248',1011439.00,1011439.00,'248','2018-06-21 17:57:02','248','2018-06-21 17:58:03',10,0),('1','64',51900,'AFTERNOON SHIFT','2018-06-18','2018-06-18 00:00:00',NULL,'248',2300870.00,2300870.00,'248','2018-06-22 09:41:36','248','2018-06-22 09:42:45',10,0),('1','64',51902,'MORNING SHIFT','2018-06-19','2018-06-19 00:00:00',NULL,'248',1731015.00,1731015.00,'248','2018-06-22 09:47:24','248','2018-06-22 09:49:38',10,0),('1','64',51905,'AFTERNOON SHIFT','2018-06-19','2018-06-19 00:00:00',NULL,'248',2096094.00,2096094.00,'248','2018-06-22 09:54:37','248','2018-06-22 09:55:29',10,0),('1','64',51908,'MORNING SHIFT','2018-06-20','2018-06-20 00:00:00',NULL,'248',1534664.00,1534664.00,'248','2018-06-22 09:59:48','248','2018-06-22 10:00:38',10,0),('1','64',51911,'AFTERNOON SHIFT','2018-06-20','2018-06-20 00:00:00',NULL,'248',1260402.00,1260402.00,'248','2018-06-22 10:04:03','248','2018-06-22 10:04:55',10,0),('1','64',51913,'MORNING SHIFT','2018-06-21','2018-06-21 00:00:00',NULL,'248',1203059.00,1203059.00,'248','2018-06-22 10:07:50','248','2018-06-22 10:08:40',10,0),('1','64',51914,'AFTERNOON SHIFT','2018-06-21','2018-06-21 00:00:00',NULL,'248',1271413.00,1271413.00,'248','2018-06-22 10:11:34','248','2018-06-22 10:12:21',10,0),('1','64',51915,'MORNING SHIFT','2018-06-22','2018-06-22 00:00:00',NULL,'248',101244.00,101244.00,'248','2018-06-22 22:51:25','248','2018-06-22 22:52:21',10,0),('1','64',51997,'AFTERNOON SHIFT','2018-06-22','2018-06-22 00:00:00',NULL,'248',0.00,0.00,'248','2018-06-26 10:53:46','248','2018-06-26 10:54:20',10,0),('1','64',52350,'MORNING SHIFT','2018-06-23','2018-06-23 00:00:00',NULL,'248',453388.00,453388.00,'248','2018-06-26 10:58:06','248','2018-06-26 10:58:46',10,0),('1','64',52354,'AFTERNOON SHIFT','2018-06-23','2018-06-23 00:00:00',NULL,'248',1564706.00,1564706.00,'248','2018-06-26 11:04:36','248','2018-06-26 11:05:47',10,0),('1','64',52355,'MORNING SHIFT','2018-06-24','2018-06-24 00:00:00',NULL,'248',1251107.00,1251107.00,'248','2018-06-26 11:10:00','248','2018-06-26 11:10:59',10,0),('1','64',52356,'AFTERNOON SHIFT','2018-06-24','2018-06-24 00:00:00',NULL,'248',1499069.00,1499069.00,'248','2018-06-26 11:15:29','248','2018-06-26 11:16:08',10,0),('1','64',52359,'MORNING SHIFT','2018-06-25','2018-06-25 00:00:00',NULL,'248',1539681.00,1539681.00,'248','2018-06-26 11:22:08','248','2018-06-26 11:23:11',10,0),('1','64',52362,'AFTERNOON SHIFT','2018-06-25','2018-06-25 00:00:00',NULL,'248',1897324.00,1897324.00,'248','2018-06-26 11:28:20','248','2018-06-26 11:29:11',10,0),('1','64',52365,'MORNING SHIFT','2018-06-26','2018-06-26 00:00:00',NULL,'248',1515704.00,1515704.00,'248','2018-06-27 12:49:48','248','2018-06-27 12:50:28',10,0),('1','64',52511,'AFTERNOON SHIFT','2018-06-26','2018-06-26 00:00:00',NULL,'248',1478763.00,1478763.00,'248','2018-06-29 08:18:27','248','2018-06-29 08:19:04',10,0),('1','64',52686,'MORNING SHIFT','2018-06-27','2018-06-27 00:00:00',NULL,'248',390962.00,390962.00,'248','2018-06-29 08:27:42','248','2018-06-29 08:29:01',10,0),('1','64',52687,'AFTERNOON SHIFT','2018-06-27','2018-06-27 00:00:00',NULL,'248',0.00,0.00,'248','2018-06-29 08:31:40','248','2018-06-29 08:32:24',10,0),('1','64',52689,'MORNING SHIFT','2018-06-28','2018-06-28 00:00:00',NULL,'248',589303.00,589303.00,'248','2018-06-29 08:36:50','248','2018-06-29 08:37:32',10,0),('1','64',52692,'AFTERNOON SHIFT','2018-06-28','2018-06-28 00:00:00',NULL,'248',1826539.00,1826539.00,'248','2018-06-29 08:50:27','248','2018-06-29 08:51:38',10,0),('1','64',52694,'MORNING SHIFT','2018-06-29','2018-06-29 00:00:00',NULL,'248',1415604.00,1415604.00,'248','2018-06-29 14:00:04','248','2018-06-29 14:03:00',10,0),('1','64',52745,'AFTERNOON SHIFT','2018-06-29','2018-06-29 00:00:00',NULL,'248',1977166.00,1977166.00,'248','2018-07-02 10:12:43','248','2018-07-02 10:13:45',10,0),('1','64',53002,'MORNING SHIFT','2018-06-30','2018-06-30 00:00:00',NULL,'248',1624305.00,1624305.00,'248','2018-07-02 10:20:52','248','2018-07-02 10:21:27',10,0),('1','64',53004,'AFTERNOON SHIFT','2018-06-30','2018-06-30 00:00:00',NULL,'248',1985073.00,1985073.00,'248','2018-07-02 10:25:26','248','2018-07-02 10:26:29',10,0),('1','64',53005,'MORNING SHIFT','2018-07-01','2018-07-01 00:00:00',NULL,'248',1524453.00,1524453.00,'248','2018-07-02 10:33:18','248','2018-07-02 10:34:28',10,0),('1','64',53006,'AFTERNOON SHIFT','2018-07-01','2018-07-01 00:00:00',NULL,'248',1618724.00,1618724.00,'248','2018-07-02 10:41:38','248','2018-07-02 10:45:39',10,0),('1','64',53008,'MORNING SHIFT','2018-07-02','2018-07-02 00:00:00',NULL,'248',1707372.00,1707372.00,'248','2018-07-03 09:45:33','248','2018-07-03 09:47:00',10,0),('1','64',53121,'AFTERNOON SHIFT','2018-07-02','2018-07-02 00:00:00',NULL,'248',2071691.00,2071691.00,'248','2018-07-03 09:50:58','248','2018-07-03 09:51:47',10,0),('1','64',53122,'MORNING SHIFT','2018-07-03','2018-07-03 00:00:00',NULL,'248',1543332.00,1543332.00,'248','2018-07-03 13:47:06','248','2018-07-03 13:47:51',10,0),('1','64',53156,'AFTERNOON SHIFT','2018-07-03','2018-07-03 00:00:00',NULL,'248',2147449.00,2147449.00,'248','2018-07-04 09:06:42','248','2018-07-04 09:07:40',10,0),('1','64',53224,'MORNING SHIFT','2018-07-04','2018-07-04 00:00:00',NULL,'248',1723740.00,1723740.00,'248','2018-07-06 09:53:28','248','2018-07-06 09:54:23',10,0),('1','64',53449,'AFTERNOON SHIFT','2018-07-04','2018-07-04 00:00:00',NULL,'248',1746420.00,1746420.00,'248','2018-07-06 10:10:08','248','2018-07-06 10:12:28',10,0),('1','64',53454,'MORNING SHIFT','2018-07-05','2018-07-05 00:00:00',NULL,'248',1599822.00,1599822.00,'248','2018-07-06 10:16:56','248','2018-07-06 10:17:42',10,0),('1','64',53457,'AFTERNOON SHIFT','2018-07-05','2018-07-05 00:00:00',NULL,'248',1778632.00,1778632.00,'248','2018-07-06 10:21:43','248','2018-07-06 10:22:36',10,0),('1','64',53458,'MORNING SHIFT','2018-07-06','2018-07-06 00:00:00',NULL,'248',2337198.00,2337198.00,'248','2018-07-09 08:49:56','248','2018-07-09 08:50:59',10,0),('1','64',53734,'AFTERNOON SHIFT','2018-07-06','2018-07-06 00:00:00',NULL,'248',2041761.00,2041761.00,'248','2018-07-09 09:17:14','248','2018-07-09 09:17:51',10,0),('1','64',53742,'MORNING SHIFT','2018-07-07','2018-07-07 00:00:00',NULL,'248',1699339.00,1699339.00,'248','2018-07-09 09:23:22','248','2018-07-09 09:24:22',10,0),('1','64',53743,'AFTERNOON SHIFT','2018-07-07','2018-07-07 00:00:00',NULL,'248',1899004.00,1899004.00,'248','2018-07-09 09:27:35','248','2018-07-09 09:28:10',10,0),('1','64',53744,'MORNING SHIFT','2018-07-08','2018-07-08 00:00:00',NULL,'248',1125772.00,1125772.00,'248','2018-07-09 09:33:03','248','2018-07-09 09:34:00',10,0),('1','64',53746,'AFTERNOON SHIFT','2018-07-08','2018-07-08 00:00:00',NULL,'248',1664606.00,1664606.00,'248','2018-07-10 11:50:00','248','2018-07-10 11:50:52',10,0),('1','64',53882,'MORNING SHIFT','2018-07-09','2018-07-09 00:00:00',NULL,'248',1868446.00,1868446.00,'248','2018-07-10 11:58:45','248','2018-07-10 12:03:41',10,0),('1','64',53885,'AFTERNOON SHIFT','2018-07-09','2018-07-09 00:00:00',NULL,'248',2313978.00,2313978.00,'248','2018-07-10 12:10:43','248','2018-07-10 12:12:37',10,0),('1','64',53889,'MORNING SHIFT','2018-07-10','2018-07-10 00:00:00',NULL,'248',1627581.00,1627581.00,'248','2018-07-11 09:57:21','248','2018-07-11 09:58:25',10,0),('1','64',53991,'AFTERNOON SHIFT','2018-07-10','2018-07-10 00:00:00',NULL,'248',2032405.00,2032405.00,'248','2018-07-11 11:59:07','248','2018-07-11 11:59:59',10,0),('1','64',54006,'MORNING SHIFT','2018-07-11','2018-07-11 00:00:00',NULL,'248',1504763.00,1504763.00,'248','2018-07-12 08:43:38','248','2018-07-12 08:44:33',10,0),('1','64',54095,'AFTERNOON SHIFT','2018-07-11','2018-07-11 00:00:00',NULL,'248',2076914.90,2076914.90,'248','2018-07-12 10:19:46','248','2018-07-12 10:21:04',10,0),('1','64',54108,'MORNING SHIFT','2018-07-12','2018-07-12 00:00:00',NULL,'248',1572219.70,1572219.70,'248','2018-07-13 09:41:31','248','2018-07-13 09:42:10',10,0),('1','64',54211,'AFTERNOON SHIFT','2018-07-12','2018-07-12 00:00:00',NULL,'248',1936887.30,1936887.30,'248','2018-07-13 09:53:33','248','2018-07-13 09:54:35',10,0),('1','64',54215,'MORNING SHIFT','2018-07-13','2018-07-13 00:00:00',NULL,'248',1616598.10,1616598.10,'248','2018-07-14 18:00:20','248','2018-07-14 18:01:02',10,0),('1','64',54404,'AFTERNOON SHIFT','2018-07-13','2018-07-13 00:00:00',NULL,'248',2285049.50,2285049.50,'248','2018-07-14 18:07:28','248','2018-07-14 18:08:09',10,0),('1','64',54406,'MORNING SHIFT','2018-07-14','2018-07-14 00:00:00',NULL,'248',1592026.10,1592026.10,'248','2018-07-14 18:19:54','248','2018-07-14 18:20:51',10,0),('1','64',54407,'AFTERNOON SHIFT','2018-07-14','2018-07-14 00:00:00',NULL,'248',2128228.50,2128228.50,'248','2018-07-16 08:38:13','248','2018-07-16 08:38:54',10,0),('1','64',54531,'MORNING SHIFT','2018-07-15','2018-07-15 00:00:00',NULL,'248',1543589.90,1543589.90,'248','2018-07-16 08:43:17','248','2018-07-16 08:44:00',10,0),('1','64',54533,'AFTERNOON SHIFT','2018-07-15','2018-07-15 00:00:00',NULL,'248',1730258.70,1730258.70,'248','2018-07-17 08:45:57','248','2018-07-17 08:50:58',10,0),('1','64',54678,'MORNING SHIFT','2018-07-16','2018-07-16 00:00:00',NULL,'248',1851948.40,1851948.40,'248','2018-07-18 18:52:57','248','2018-07-18 18:53:37',10,0),('1','64',54872,'AFTERNOON SHIFT','2018-07-16','2018-07-16 00:00:00',NULL,'248',2162439.30,2162439.30,'248','2018-07-18 18:58:56','248','2018-07-18 18:59:33',10,0),('1','64',54873,'MORNING SHIFT','2018-07-17','2018-07-17 00:00:00',NULL,'248',1793636.80,1793636.80,'248','2018-07-18 19:04:33','248','2018-07-18 19:05:19',10,0),('1','64',54875,'AFTERNOON SHIFT','2018-07-17','2018-07-17 00:00:00',NULL,'248',2197675.30,2197675.30,'248','2018-07-18 19:11:26','248','2018-07-18 19:14:04',10,0),('1','64',54877,'MORNING SHIFT','2018-07-18','2018-07-18 00:00:00',NULL,'248',1639017.00,1639017.00,'248','2018-07-18 19:20:11','248','2018-07-18 19:32:25',10,0),('1','64',54879,'AFTERNOON SHIFT','2018-07-18','2018-07-18 00:00:00',NULL,'248',2100649.60,2100649.60,'248','2018-07-20 10:05:26','248','2018-07-20 10:06:25',10,0),('1','64',55009,'MORNING SHIFT','2018-07-19','2018-07-19 00:00:00',NULL,'248',1743116.10,1743116.10,'248','2018-07-20 10:12:27','248','2018-07-20 10:13:16',10,0),('1','64',55012,'AFTERNOON SHIFT','2018-07-19','2018-07-19 00:00:00',NULL,'248',2486671.80,2486671.80,'248','2018-07-20 10:16:59','248','2018-07-20 10:23:40',10,0),('1','64',55016,'MORNING SHIFT','2018-07-20','2018-07-20 00:00:00',NULL,'248',1699282.10,1699282.10,'248','2018-07-20 18:37:45','248','2018-07-20 18:40:13',10,0),('1','64',55086,'AFTERNOON SHIFT','2018-07-20','2018-07-20 00:00:00',NULL,'248',2299794.60,2299794.60,'248','2018-07-22 11:40:32','248','2018-07-22 11:41:36',10,0),('1','64',55214,'MORNING SHIFT','2018-07-21','2018-07-21 00:00:00',NULL,'248',1974265.10,1974265.10,'248','2018-07-22 11:46:21','248','2018-07-22 11:46:56',10,0),('1','64',55216,'AFTERNOON SHIFT','2018-07-21','2018-07-21 00:00:00',NULL,'248',2337784.90,2337784.90,'248','2018-07-22 11:52:36','248','2018-07-22 11:53:44',10,0),('1','64',55217,'MORNING SHIFT','2018-07-22','2018-07-22 00:00:00',NULL,'248',1576735.20,1576735.20,'248','2018-07-25 08:54:49','248','2018-07-25 08:55:43',10,0),('1','64',55533,'AFTERNOON SHIFT','2018-07-22','2018-07-22 00:00:00',NULL,'248',1701771.70,1701771.70,'248','2018-07-25 09:02:12','248','2018-07-25 09:02:46',10,0),('1','64',55534,'MORNING SHIFT','2018-07-23','2018-07-23 00:00:00',NULL,'248',1771699.90,1771699.90,'248','2018-07-25 09:23:26','248','2018-07-25 09:25:02',10,0),('1','64',55540,'AFTERNOON SHIFT','2018-07-23','2018-07-23 00:00:00',NULL,'248',2267014.70,2267014.70,'248','2018-07-25 09:30:16','248','2018-07-25 09:31:49',10,0),('1','64',55541,'MORNING SHIFT','2018-07-24','2018-07-24 00:00:00',NULL,'248',1934117.80,1934117.80,'248','2018-07-25 09:37:03','248','2018-07-25 09:37:46',10,0),('1','64',55543,'AFTERNOON SHIFT','2018-07-24','2018-07-24 00:00:00',NULL,'248',1857562.30,1857562.30,'248','2018-07-26 11:32:01','248','2018-07-26 11:32:51',10,0),('1','64',55679,'MORNING SHIFT','2018-07-25','2018-07-25 00:00:00',NULL,'248',2023532.60,2023532.60,'248','2018-07-26 11:38:21','248','2018-07-26 11:44:32',10,0),('1','64',55681,'AFTERNOON SHIFT','2018-07-25','2018-07-25 00:00:00',NULL,'248',2138281.00,2138281.00,'248','2018-07-26 12:40:03','248','2018-07-26 12:45:09',10,0),('1','64',55685,'MORNING SHIFT','2018-07-26','2018-07-26 00:00:00',NULL,'248',1359974.30,1359974.30,'248','2018-07-28 12:33:13','248','2018-07-28 12:34:23',10,0),('1','64',55877,'AFTERNOON SHIFT','2018-07-26','2018-07-26 00:00:00',NULL,'248',2250839.90,2250839.90,'248','2018-07-28 12:37:28','248','2018-07-28 12:38:05',10,0),('1','64',55880,'MORNING SHIFT','2018-07-27','2018-07-27 00:00:00',NULL,'248',1649940.50,1649940.50,'248','2018-07-28 13:02:18','248','2018-07-28 13:04:13',10,0),('1','64',55887,'AFTERNOON SHIFT','2018-07-27','2018-07-27 00:00:00',NULL,'248',2392984.80,2392984.80,'248','2018-07-31 17:19:43','248','2018-07-31 17:20:50',10,0),('1','64',56244,'MORNING SHIFT','2018-07-28','2018-07-28 00:00:00',NULL,'248',1637579.30,1637579.30,'248','2018-07-31 17:35:15','248','2018-07-31 17:35:54',10,0),('1','64',56248,'AFTERNOON SHIFT','2018-07-28','2018-07-28 00:00:00',NULL,'248',2126533.00,2126533.00,'248','2018-07-31 17:39:58','248','2018-07-31 17:40:35',10,0),('1','64',56251,'MORNING SHIFT','2018-07-29','2018-07-29 00:00:00',NULL,'248',1539297.90,1539297.90,'248','2018-07-31 17:46:00','248','2018-07-31 17:46:38',10,0),('1','64',56253,'AFTERNOON SHIFT','2018-07-29','2018-07-29 00:00:00',NULL,'248',1536144.80,1536144.80,'248','2018-07-31 17:59:52','248','2018-07-31 18:00:40',10,0),('1','64',56255,'MORNING SHIFT','2018-07-30','2018-07-30 00:00:00',NULL,'248',1972289.70,1972289.70,'248','2018-07-31 18:19:02','248','2018-07-31 18:20:58',10,0),('1','64',56256,'AFTERNOON SHIFT','2018-07-30','2018-07-30 00:00:00',NULL,'248',2586320.20,2586320.20,'248','2018-07-31 18:25:59','248','2018-07-31 18:26:41',10,0),('1','64',56259,'MORNING SHIFT','2018-07-31','2018-07-31 00:00:00',NULL,'248',1727079.00,1727079.00,'248','2018-07-31 18:30:29','248','2018-07-31 18:31:17',10,0),('1','64',56261,'AFTERNOON SHIFT','2018-07-31','2018-07-31 00:00:00',NULL,'248',2584417.70,2584417.70,'248','2018-08-01 17:02:35','248','2018-08-01 17:03:16',10,0),('1','64',56342,'MORNING SHIFT','2018-08-01','2018-08-01 00:00:00',NULL,'248',1701454.70,1701454.70,'248','2018-08-01 17:07:03','248','2018-08-01 17:07:41',10,0),('1','64',56343,'AFTERNOON SHIFT','2018-08-01','2018-08-01 00:00:00',NULL,'248',2020312.80,2020312.80,'248','2018-08-04 09:59:44','248','2018-08-04 10:03:17',10,0),('1','64',56627,'MORNING SHIFT','2018-08-02','2018-08-02 00:00:00',NULL,'248',1618684.30,1618684.30,'248','2018-08-04 10:15:28','248','2018-08-04 10:16:21',10,0),('1','64',56630,'AFTERNOON SHIFT','2018-08-02','2018-08-02 00:00:00',NULL,'248',2081368.80,2081368.80,'248','2018-08-04 10:22:12','248','2018-08-04 10:23:27',10,0),('1','64',56632,'MORNING SHIFT','2018-08-03','2018-08-03 00:00:00',NULL,'248',1703819.50,1703819.50,'248','2018-08-04 10:30:31','248','2018-08-04 11:02:20',10,0),('1','64',56635,'AFTERNOON SHIFT','2018-08-03','2018-08-03 00:00:00',NULL,'248',2302380.30,2302380.30,'248','2018-08-06 08:55:49','248','2018-08-06 08:56:47',10,0),('1','64',56802,'MORNING SHIFT','2018-08-04','2018-08-04 00:00:00',NULL,'248',1838210.90,1838210.90,'248','2018-08-06 09:02:20','248','2018-08-06 09:03:23',10,0),('1','64',56805,'AFTERNOON SHIFT','2018-08-04','2018-08-04 00:00:00',NULL,'248',2111711.60,2111711.60,'248','2018-08-06 09:20:48','248','2018-08-06 09:21:58',10,0),('1','64',56812,'MORNING SHIFT','2018-08-05','2018-08-05 00:00:00',NULL,'248',1499495.20,1499495.20,'248','2018-08-06 09:32:17','248','2018-08-06 09:37:05',10,0),('1','64',56817,'AFTERNOON SHIFT','2018-08-05','2018-08-05 00:00:00',NULL,'248',1633736.50,1633736.50,'248','2018-08-07 08:57:51','248','2018-08-07 08:59:20',10,0),('1','64',56944,'MORNING SHIFT','2018-08-06','2018-08-06 00:00:00',NULL,'248',1789296.60,1789296.60,'248','2018-08-09 10:10:50','248','2018-08-09 10:11:49',10,0),('1','64',57185,'AFTERNOON SHIFT','2018-08-06','2018-08-06 00:00:00',NULL,'248',1722593.80,1722593.80,'248','2018-08-09 10:18:10','248','2018-08-09 10:19:33',10,0),('1','64',57188,'MORNING SHIFT','2018-08-07','2018-08-07 00:00:00',NULL,'248',1864522.70,1864522.70,'248','2018-08-09 10:24:47','248','2018-08-09 10:25:43',10,0),('1','64',57190,'AFTERNOON SHIFT','2018-08-07','2018-08-07 00:00:00',NULL,'248',2471828.20,2471828.20,'248','2018-08-09 10:31:52','248','2018-08-09 10:32:45',10,0),('1','64',57192,'MORNING SHIFT','2018-08-08','2018-08-08 00:00:00',NULL,'248',1669174.30,1669174.30,'248','2018-08-10 11:11:57','248','2018-08-10 11:19:12',10,0),('1','64',57312,'AFTERNOON SHIFT','2018-08-08','2018-08-08 00:00:00',NULL,'248',2080435.20,2080435.20,'248','2018-08-10 11:23:52','248','2018-08-10 11:27:08',10,0),('1','64',57314,'MORNING SHIFT','2018-08-09','2018-08-09 00:00:00',NULL,'248',1599191.30,1599191.30,'248','2018-08-10 12:08:06','248','2018-08-10 12:09:07',10,0),('1','64',57318,'AFTERNOON SHIFT','2018-08-09','2018-08-09 00:00:00',NULL,'248',2128238.40,2128238.40,'248','2018-08-12 10:23:54','248','2018-08-12 10:26:13',10,0),('1','64',57516,'MORNING SHIFT','2018-08-10','2018-08-10 00:00:00',NULL,'248',1612914.60,1612914.60,'248','2018-08-12 10:36:12','248','2018-08-12 10:36:52',10,0),('1','64',57519,'AFTERNOON SHIFT','2018-08-10','2018-08-10 00:00:00',NULL,'248',1621167.40,1621167.40,'248','2018-08-12 10:40:55','248','2018-08-12 10:41:43',10,0),('1','64',57520,'MORNING SHIFT','2018-08-11','2018-08-11 00:00:00',NULL,'248',803671.80,803671.80,'248','2018-08-12 10:59:55','248','2018-08-12 11:00:57',10,0),('1','64',57527,'AFTERNOON SHIFT','2018-08-11','2018-08-11 00:00:00',NULL,'248',163215.50,163215.50,'248','2018-08-12 11:04:02','248','2018-08-12 11:04:35',10,0),('1','64',57528,'MORNING SHIFT','2018-08-12','2018-08-12 00:00:00',NULL,'248',122738.50,122738.50,'248','2018-08-16 09:50:31','248','2018-08-16 09:51:15',10,0),('1','64',57937,'AFTERNOON SHIFT','2018-08-12','2018-08-12 00:00:00',NULL,'248',1441036.80,1441036.80,'248','2018-08-16 09:54:45','248','2018-08-16 09:55:23',10,0),('1','64',57942,'MORNING SHIFT','2018-08-13','2018-08-13 00:00:00',NULL,'248',2455991.40,2455991.40,'248','2018-08-16 10:03:32','248','2018-08-16 10:04:09',10,0),('1','64',57946,'AFTERNOON SHIFT','2018-08-13','2018-08-13 00:00:00',NULL,'248',2316505.60,2316505.60,'248','2018-08-16 10:13:47','248','2018-08-16 10:14:26',10,0),('1','64',57950,'MORNING SHIFT','2018-08-14','2018-08-14 00:00:00',NULL,'248',1707691.60,1707691.60,'248','2018-08-16 10:26:30','248','2018-08-16 10:27:08',10,0),('1','64',57959,'AFTERNOON SHIFT','2018-08-14','2018-08-14 00:00:00',NULL,'248',1923273.10,1923273.10,'248','2018-08-16 10:32:26','248','2018-08-16 10:33:17',10,0),('1','64',57966,'MORNING SHIFT','2018-08-15','2018-08-15 00:00:00',NULL,'248',1698293.70,1698293.70,'248','2018-08-16 10:37:28','248','2018-08-16 10:38:09',10,0),('1','64',57967,'AFTERNOON SHIFT','2018-08-15','2018-08-15 00:00:00',NULL,'248',2059925.60,2059925.60,'248','2018-08-16 10:41:44','248','2018-08-16 10:42:26',10,0),('1','64',57969,'MORNING SHIFT','2018-08-16','2018-08-16 00:00:00',NULL,'248',1779341.00,1779341.00,'248','2018-08-18 11:23:53','248','2018-08-18 11:24:26',10,0),('1','64',58208,'AFTERNOON SHIFT','2018-08-16','2018-08-16 00:00:00',NULL,'248',2045375.30,2045375.30,'248','2018-08-18 11:28:41','248','2018-08-18 11:30:06',10,0),('1','64',58209,'MORNING SHIFT','2018-08-17','2018-08-17 00:00:00',NULL,'248',1842408.40,1842408.40,'248','2018-08-18 11:38:43','248','2018-08-18 11:39:35',10,0),('1','64',58211,'AFTERNOON SHIFT','2018-08-17','2018-08-17 00:00:00',NULL,'248',1822360.70,1822360.70,'248','2018-08-18 11:44:20','248','2018-08-18 11:45:05',10,0),('1','64',58212,'MORNING SHIFT','2018-08-18','2018-08-18 00:00:00',NULL,'248',1825721.90,1825721.90,'248','2018-08-19 13:38:20','248','2018-08-19 13:39:05',10,0),('1','64',58346,'AFTERNOON SHIFT','2018-08-18','2018-08-18 00:00:00',NULL,'248',2000613.50,2000613.50,'248','2018-08-19 13:51:33','248','2018-08-19 13:53:31',10,0),('1','64',58348,'MORNING SHIFT','2018-08-19','2018-08-19 00:00:00',NULL,'248',1597503.80,1597503.80,'248','2018-08-27 15:07:02','248','2018-08-27 15:07:31',10,0),('1','64',59230,'AFTERNOON SHIFT','2018-08-19','2018-08-19 00:00:00',NULL,'248',1324923.90,1324923.90,'248','2018-08-27 15:14:57','248','2018-08-27 15:15:52',10,0),('1','64',59234,'MORNING SHIFT','2018-08-20','2018-08-20 00:00:00',NULL,'248',2000509.20,2000509.20,'248','2018-08-27 15:24:30','248','2018-08-27 15:25:21',10,0),('1','64',59236,'AFTERNOON SHIFT','2018-08-20','2018-08-20 00:00:00',NULL,'248',2324213.60,2324213.60,'248','2018-08-27 15:29:51','248','2018-08-27 15:30:39',10,0),('1','64',59238,'MORNING SHIFT','2018-08-21','2018-08-21 00:00:00',NULL,'248',1221644.10,1221644.10,'248','2018-08-27 15:43:55','248','2018-08-27 15:44:42',10,0),('1','64',59240,'AFTERNOON SHIFT','2018-08-21','2018-08-21 00:00:00',NULL,'248',1624286.80,1624286.80,'248','2018-08-27 15:59:11','248','2018-08-27 16:00:25',10,0),('1','64',59243,'MORNING SHIFT','2018-08-22','2018-08-22 00:00:00',NULL,'248',1273894.70,1273894.70,'248','2018-08-28 10:25:37','248','2018-08-28 10:26:11',10,0),('1','64',59297,'AFTERNOON SHIFT','2018-08-22','2018-08-22 00:00:00',NULL,'248',1638885.90,1638885.90,'248','2018-08-28 10:29:49','248','2018-08-28 10:30:56',10,0),('1','64',59298,'MORNING SHIFT','2018-08-23','2018-08-23 00:00:00',NULL,'248',1443793.80,1443793.80,'248','2018-08-28 10:37:23','248','2018-08-28 10:38:08',10,0),('1','64',59299,'AFTERNOON SHIFT','2018-08-23','2018-08-23 00:00:00',NULL,'248',2161369.90,2161369.90,'248','2018-08-28 10:42:07','248','2018-08-28 10:43:38',10,0),('1','64',59302,'MORNING SHIFT','2018-08-24','2018-08-24 00:00:00',NULL,'248',1481279.90,1481279.90,'248','2018-08-28 10:48:47','248','2018-08-28 10:49:30',10,0),('1','64',59304,'AFTERNOON SHIFT','2018-08-24','2018-08-24 00:00:00',NULL,'248',2021674.70,2021674.70,'248','2018-08-28 10:52:35','248','2018-08-28 10:53:26',10,0),('1','64',59305,'MORNING SHIFT','2018-08-25','2018-08-25 00:00:00',NULL,'248',1807809.60,1807809.60,'248','2018-08-28 10:59:19','248','2018-08-28 10:59:58',10,0),('1','64',59309,'AFTERNOON SHIFT','2018-08-25','2018-08-25 00:00:00',NULL,'248',2116426.80,2116426.80,'248','2018-08-28 11:07:53','248','2018-08-28 11:08:31',10,0),('1','64',59313,'MORNING SHIFT','2018-08-26','2018-08-26 00:00:00',NULL,'248',1334619.30,1334619.30,'248','2018-08-28 14:26:02','248','2018-08-28 14:26:36',10,0),('1','64',59344,'AFTERNOON SHIFT','2018-08-26','2018-08-26 00:00:00',NULL,'248',1693422.40,1693422.40,'248','2018-08-28 15:16:45','248','2018-08-28 15:17:37',10,0),('1','64',59350,'MORNING SHIFT','2018-08-27','2018-08-27 00:00:00',NULL,'248',1372924.40,1372924.40,'248','2018-08-28 15:22:33','248','2018-08-28 15:23:10',10,0),('1','64',59352,'AFTERNOON SHIFT','2018-08-27','2018-08-27 00:00:00',NULL,'248',2079594.80,2079594.80,'248','2018-08-28 15:27:02','248','2018-08-28 15:27:43',10,0),('1','64',59353,'MORNING SHIFT','2018-08-28','2018-08-28 00:00:00',NULL,'248',1739539.50,1739539.50,'248','2018-08-28 15:34:37','248','2018-08-28 15:35:36',10,0),('1','64',59354,'AFTERNOON SHIFT','2018-08-28','2018-08-28 00:00:00',NULL,'248',1999134.40,1999134.40,'248','2018-08-29 19:16:34','248','2018-08-29 19:17:09',10,0),('1','64',59514,'MORNING SHIFT','2018-08-29','2018-08-29 00:00:00',NULL,'248',1073422.90,1073422.90,'248','2018-08-29 19:26:41','248','2018-08-29 19:27:16',10,0),('1','64',59516,'AFTERNOON SHIFT','2018-08-29','2018-08-29 00:00:00',NULL,'248',1871251.10,1871251.10,'248','2018-09-01 13:23:34','248','2018-09-01 13:24:28',10,0),('1','64',59781,'MORNING SHIFT','2018-08-30','2018-08-30 00:00:00',NULL,'248',1613595.30,1613595.30,'248','2018-09-01 13:38:21','248','2018-09-01 13:39:37',10,0),('1','64',59789,'AFTERNOON SHIFT','2018-08-30','2018-08-30 00:00:00',NULL,'248',1796548.50,1796548.50,'248','2018-09-01 14:04:58','248','2018-09-01 14:06:01',10,0),('1','64',59792,'MORNING SHIFT','2018-08-31','2018-08-31 00:00:00',NULL,'248',1658014.70,1658014.70,'248','2018-09-01 18:15:32','248','2018-09-01 18:16:30',10,0),('1','64',59829,'AFTERNOON SHIFT','2018-08-31','2018-08-31 00:00:00',NULL,'248',2046185.20,2046185.20,'248','2018-09-01 18:23:47','248','2018-09-01 18:24:57',10,0),('1','64',59830,'MORNING SHIFT','2018-09-01','2018-09-01 00:00:00',NULL,'248',1819392.40,1819392.40,'248','2018-09-01 18:53:18','248','2018-09-01 18:54:56',10,0),('1','64',59831,'AFTERNOON SHIFT','2018-09-01','2018-09-01 00:00:00',NULL,'248',2021777.30,2021777.30,'248','2018-09-03 08:48:21','248','2018-09-03 08:49:22',10,0),('1','64',59945,'MORNING SHIFT','2018-09-02','2018-09-02 00:00:00',NULL,'248',1537514.20,1537514.20,'248','2018-09-03 08:55:08','248','2018-09-03 08:55:50',10,0),('1','64',59946,'AFTERNOON SHIFT','2018-09-02','2018-09-02 00:00:00',NULL,'248',1892558.90,1892558.90,'248','2018-09-03 19:23:49','248','2018-09-03 19:24:27',10,0),('1','64',60059,'MORNING SHIFT','2018-09-03','2018-09-03 00:00:00',NULL,'248',1834923.80,1834923.80,'248','2018-09-03 19:27:13','248','2018-09-03 19:27:55',10,0),('1','64',60117,'AFTERNOON SHIFT','2018-09-03','2018-09-03 00:00:00',NULL,'248',2106015.60,2106015.60,'248','2018-09-04 12:38:56','248','2018-09-04 12:39:47',10,0),('1','64',60119,'MORNING SHIFT','2018-09-04','2018-09-04 00:00:00',NULL,'248',1905849.10,1905849.10,'248','2018-09-04 14:30:28','248','2018-09-04 14:31:05',10,0),('1','64',60145,'AFTERNOON SHIFT','2018-09-04','2018-09-04 00:00:00',NULL,'248',2209334.70,2209334.70,'248','2018-09-05 11:18:11','248','2018-09-05 11:19:22',10,0),('1','64',60221,'MORNING SHIFT','2018-09-05','2018-09-05 00:00:00',NULL,'248',1665626.40,1665626.40,'248','2018-09-06 10:04:45','248','2018-09-06 10:05:17',10,0),('1','64',60318,'AFTERNOON SHIFT','2018-09-05','2018-09-05 00:00:00',NULL,'248',2085868.50,2085868.50,'248','2018-09-07 11:55:55','248','2018-09-07 11:56:46',10,0),('1','64',60442,'MORNING SHIFT','2018-09-06','2018-09-06 00:00:00',NULL,'248',1586720.10,1586720.10,'248','2018-09-07 12:01:13','248','2018-09-07 12:01:50',10,0),('1','64',60444,'AFTERNOON SHIFT','2018-09-06','2018-09-06 00:00:00',NULL,'248',1752330.50,1752330.50,'248','2018-09-07 12:07:42','248','2018-09-07 12:08:31',10,0),('1','64',60448,'MORNING SHIFT','2018-09-07','2018-09-07 00:00:00',NULL,'248',2347008.80,2347008.80,'248','2018-09-07 14:14:40','248','2018-09-07 14:15:51',10,0),('1','64',60464,'AFTERNOON SHIFT','2018-09-07','2018-09-07 00:00:00',NULL,'248',1967399.80,1967399.80,'248','2018-09-09 09:17:21','248','2018-09-09 09:19:43',10,0),('1','64',60624,'MORNING SHIFT','2018-09-08','2018-09-08 00:00:00',NULL,'248',1908820.80,1908820.80,'248','2018-09-10 13:28:32','248','2018-09-10 13:29:09',10,0),('1','64',60763,'AFTERNOON SHIFT','2018-09-08','2018-09-08 00:00:00',NULL,'248',2456786.80,2456786.80,'248','2018-09-10 13:33:23','248','2018-09-10 13:35:04',10,0),('1','64',60769,'MORNING SHIFT','2018-09-09','2018-09-09 00:00:00',NULL,'248',1678482.40,1678482.40,'248','2018-09-10 13:59:21','248','2018-09-10 14:00:06',10,0),('1','64',60778,'AFTERNOON SHIFT','2018-09-09','2018-09-09 00:00:00',NULL,'248',1608747.20,1608747.20,'248','2018-09-11 11:37:00','248','2018-09-11 11:37:46',10,0),('1','64',60871,'MORNING SHIFT','2018-09-10','2018-09-10 00:00:00',NULL,'248',1900206.60,1900206.60,'248','2018-09-11 11:41:39','248','2018-09-11 11:42:13',10,0),('1','64',60872,'AFTERNOON SHIFT','2018-09-10','2018-09-10 00:00:00',NULL,'248',2176196.00,2176196.00,'248','2018-09-11 11:48:41','248','2018-09-11 11:49:37',10,0),('1','64',60875,'MORNING SHIFT','2018-09-11','2018-09-11 00:00:00',NULL,'248',1851429.90,1851429.90,'248','2018-09-12 08:12:53','248','2018-09-12 08:13:39',10,0),('1','64',60959,'AFTERNOON SHIFT','2018-09-11','2018-09-11 00:00:00',NULL,'248',2081159.70,2081159.70,'248','2018-09-12 08:17:48','248','2018-09-12 08:18:46',10,0),('1','64',60960,'MORNING SHIFT','2018-09-12','2018-09-12 00:00:00',NULL,'248',2350185.60,2350185.60,'248','2018-09-13 08:45:36','248','2018-09-13 08:47:02',10,0),('1','64',61077,'AFTERNOON SHIFT','2018-09-12','2018-09-12 00:00:00',NULL,'248',2298541.50,2298541.50,'248','2018-09-14 10:02:02','248','2018-09-14 10:02:47',10,0),('1','64',61203,'MORNING SHIFT','2018-09-13','2018-09-13 00:00:00',NULL,'248',1993326.50,1993326.50,'248','2018-09-14 10:15:07','248','2018-09-14 10:15:57',10,0),('1','64',61206,'AFTERNOON SHIFT','2018-09-13','2018-09-13 00:00:00',NULL,'248',2188939.80,2188939.80,'248','2018-09-14 10:20:51','248','2018-09-14 10:21:29',10,0),('1','64',61207,'MORNING SHIFT','2018-09-14','2018-09-14 00:00:00',NULL,'248',1485152.00,1485152.00,'248','2018-09-15 08:24:40','248','2018-09-15 08:26:14',10,0),('1','64',61280,'AFTERNOON SHIFT','2018-09-14','2018-09-14 00:00:00',NULL,'248',2293116.90,2293116.90,'248','2018-09-15 08:29:41','248','2018-09-15 08:30:25',10,0),('1','64',61281,'MORNING SHIFT','2018-09-15','2018-09-15 00:00:00',NULL,'248',1655660.90,1655660.90,'248','2018-09-17 14:09:24','248','2018-09-17 14:12:21',10,0),('1','64',61594,'AFTERNOON SHIFT','2018-09-15','2018-09-15 00:00:00',NULL,'248',1612035.60,1612035.60,'248','2018-09-17 14:23:05','248','2018-09-17 14:24:23',10,0),('1','64',61654,'MORNING SHIFT','2018-09-16','2018-09-16 00:00:00',NULL,'248',1622430.50,1622430.50,'248','2018-09-18 08:33:29','248','2018-09-18 08:34:24',10,0),('1','64',61655,'AFTERNOON SHIFT','2018-09-16','2018-09-16 00:00:00',NULL,'248',1597546.10,1597546.10,'248','2018-09-18 08:37:24','248','2018-09-18 08:38:05',10,0),('1','64',61656,'MORNING SHIFT','2018-09-17','2018-09-17 00:00:00',NULL,'248',1473695.50,1473695.50,'248','2018-09-18 08:44:05','248','2018-09-18 09:01:12',10,0),('1','64',61662,'AFTERNOON SHIFT','2018-09-17','2018-09-17 00:00:00',NULL,'248',1537754.10,1537754.10,'248','2018-09-18 18:34:17','248','2018-09-18 18:34:52',10,0),('1','64',61764,'MORNING SHIFT','2018-09-18','2018-09-18 00:00:00',NULL,'248',1410581.00,1410581.00,'248','2018-09-18 18:38:20','248','2018-09-18 18:39:09',10,0),('1','64',61765,'AFTERNOON SHIFT','2018-09-18','2018-09-18 00:00:00',NULL,'248',1967288.70,1967288.70,'248','2018-09-19 12:41:34','248','2018-09-19 12:42:41',10,0),('1','64',61823,'MORNING SHIFT','2018-09-19','2018-09-19 00:00:00',NULL,'248',1452198.60,1452198.60,'248','2018-09-20 13:40:30','248','2018-09-20 13:41:07',10,0),('1','64',61979,'AFTERNOON SHIFT','2018-09-19','2018-09-19 00:00:00',NULL,'248',1960217.30,1960217.30,'248','2018-09-20 13:44:53','248','2018-09-20 13:45:53',10,0),('1','64',61980,'MORNING SHIFT','2018-09-20','2018-09-20 00:00:00',NULL,'248',1511747.50,1511747.50,'248','2018-09-21 09:18:44','248','2018-09-21 09:20:28',10,0),('1','64',62034,'AFTERNOON SHIFT','2018-09-20','2018-09-20 00:00:00',NULL,'248',2001009.70,2001009.70,'248','2018-09-21 10:02:22','248','2018-09-21 10:03:05',10,0),('1','64',62044,'MORNING SHIFT','2018-09-21','2018-09-21 00:00:00',NULL,'248',1400502.50,1400502.50,'248','2018-09-22 09:37:18','248','2018-09-22 09:37:50',10,0),('1','64',62140,'AFTERNOON SHIFT','2018-09-21','2018-09-21 00:00:00',NULL,'248',1719138.60,1719138.60,'248','2018-09-22 09:45:38','248','2018-09-22 09:46:23',10,0),('1','64',62144,'MORNING SHIFT','2018-09-22','2018-09-22 00:00:00',NULL,'248',1621817.40,1621817.40,'248','2018-09-23 09:37:18','248','2018-09-23 09:38:07',10,0),('1','64',62244,'AFTERNOON SHIFT','2018-09-22','2018-09-22 00:00:00',NULL,'248',1934464.40,1934464.40,'248','2018-09-24 09:15:46','248','2018-09-24 09:16:50',10,0),('1','64',62362,'MORNING SHIFT','2018-09-23','2018-09-23 00:00:00',NULL,'248',1487800.90,1487800.90,'248','2018-09-24 09:22:42','248','2018-09-24 09:23:23',10,0),('1','64',62365,'AFTERNOON SHIFT','2018-09-23','2018-09-23 00:00:00',NULL,'248',1518270.00,1518270.00,'248','2018-09-24 09:27:40','248','2018-09-24 09:28:14',10,0),('1','64',62368,'MORNING SHIFT','2018-09-24','2018-09-24 00:00:00',NULL,'248',1661331.10,1661331.10,'248','2018-09-25 09:42:18','248','2018-09-25 09:43:28',10,0),('1','64',62480,'AFTERNOON SHIFT','2018-09-24','2018-09-24 00:00:00',NULL,'248',2064205.80,2064205.80,'248','2018-09-26 17:30:15','248','2018-09-26 17:31:16',10,0),('1','64',62673,'MORNING SHIFT','2018-09-25','2018-09-25 00:00:00',NULL,'248',1957118.20,1957118.20,'248','2018-09-26 17:36:39','248','2018-09-26 17:37:26',10,0),('1','64',62676,'AFTERNOON SHIFT','2018-09-25','2018-09-25 00:00:00',NULL,'248',2041670.70,2041670.70,'248','2018-09-26 17:51:06','248','2018-09-26 17:51:49',10,0),('1','64',62677,'MORNING SHIFT','2018-09-26','2018-09-26 00:00:00',NULL,'248',1829692.60,1829692.60,'248','2018-09-26 18:03:21','248','2018-09-26 18:04:13',10,0),('1','64',62678,'AFTERNOON SHIFT','2018-09-26','2018-09-26 00:00:00',NULL,'248',2905710.00,2905710.00,'248','2018-09-28 09:13:50','248','2018-09-28 09:15:08',10,0),('1','64',62804,'MORNING SHIFT','2018-09-27','2018-09-27 00:00:00',NULL,'248',2702963.10,2702963.10,'248','2018-09-28 09:21:38','248','2018-09-28 09:22:26',10,0),('1','64',62806,'AFTERNOON SHIFT','2018-09-27','2018-09-27 00:00:00',NULL,'248',3044830.60,3044830.60,'248','2018-09-30 09:26:34','248','2018-09-30 09:27:13',10,0),('1','64',62994,'MORNING SHIFT','2018-09-28','2018-09-28 00:00:00',NULL,'248',2090819.70,2090819.70,'248','2018-10-02 10:37:50','248','2018-10-02 10:39:11',10,0),('1','64',63214,'AFTERNOON SHIFT','2018-10-28','2018-10-28 00:00:00',NULL,'248',2119098.80,2119098.80,'248','2018-10-02 10:49:08','248','2018-10-02 10:50:36',10,0),('1','64',63403,'MORNING SHIFT','2018-09-29','2018-09-29 00:00:00',NULL,'248',1460035.70,1460035.70,'248','2018-10-04 09:18:45','248','2018-10-04 09:19:52',10,0),('1','64',63426,'AFTERNOON SHIFT','2018-09-29','2018-09-29 00:00:00',NULL,'248',1645047.70,1645047.70,'248','2018-10-04 09:23:16','248','2018-10-04 09:24:04',10,0),('1','64',63427,'MORNING SHIFT','2018-09-30','2018-09-30 00:00:00',NULL,'248',1294707.50,1294707.50,'248','2018-10-04 09:27:23','248','2018-10-04 09:28:06',10,0),('1','64',63429,'AFTERNOON SHIFT','2018-09-30','2018-09-30 00:00:00',NULL,'248',1344902.80,1344902.80,'248','2018-10-04 09:34:11','248','2018-10-04 09:34:50',10,0),('1','64',63431,'MORNING SHIFT','2018-10-01','2018-10-01 00:00:00',NULL,'248',1265606.20,1265606.20,'248','2018-10-04 09:42:42','248','2018-10-04 09:43:58',10,0),('1','64',63435,'AFTERNOON SHIFT','2018-10-01','2018-10-01 00:00:00',NULL,'248',1687040.00,1687040.00,'248','2018-10-04 09:49:30','248','2018-10-04 09:50:18',10,0),('1','64',63436,'MORNING SHIFT','2018-10-02','2018-10-02 00:00:00',NULL,'248',1423502.00,1423502.00,'248','2018-10-04 10:11:27','248','2018-10-04 10:13:16',10,0),('1','64',63441,'AFTERNOON SHIFT','2018-10-02','2018-10-02 00:00:00',NULL,'248',2112522.30,2112522.30,'248','2018-10-05 10:12:53','248','2018-10-05 10:15:15',10,0),('1','64',63560,'MORNING SHIFT','2018-10-03','2018-10-03 00:00:00',NULL,'248',1800077.40,1800077.40,'248','2018-10-05 10:24:59','248','2018-10-05 10:27:13',10,0),('1','64',63562,'AFTERNOON SHIFT','2018-10-03','2018-10-03 00:00:00',NULL,'248',1800444.40,1800444.40,'248','2018-10-05 10:35:37','248','2018-10-05 10:36:18',10,0),('1','64',63565,'MORNING SHIFT','2018-10-04','2018-10-04 00:00:00',NULL,'248',1386498.80,1386498.80,'248','2018-10-05 10:56:53','248','2018-10-05 10:57:55',10,0),('1','64',63569,'AFTERNOON SHIFT','2018-10-04','2018-10-04 00:00:00',NULL,'248',2165445.20,2165445.20,'248','2018-10-05 11:04:29','248','2018-10-05 11:05:33',10,0),('1','64',63570,'MORNING SHIFT','2018-10-05','2018-10-05 00:00:00',NULL,'248',1742083.00,1742083.00,'248','2018-10-08 09:47:32','248','2018-10-08 09:48:15',10,0),('1','64',63859,'AFTERNOON SHIFT','2018-10-05','2018-10-05 00:00:00',NULL,'248',1793394.30,1793394.30,'248','2018-10-09 12:18:30','248','2018-10-09 12:22:25',10,0),('1','64',64002,'MORNING SHIFT','2018-10-06','2018-10-06 00:00:00',NULL,'248',1955183.70,1955183.70,'248','2018-10-09 12:27:15','248','2018-10-09 12:27:53',10,0),('1','64',64005,'AFTERNOON SHIFT','2018-10-06','2018-10-06 00:00:00',NULL,'248',1909609.80,1909609.80,'248','2018-10-09 12:33:16','248','2018-10-09 12:33:49',10,0),('1','64',64009,'MORNING SHIFT','2018-10-07','2018-10-07 00:00:00',NULL,'248',1505504.00,1505504.00,'248','2018-10-09 12:36:44','248','2018-10-09 12:37:17',10,0),('1','64',64011,'AFTERNOON SHIFT','2018-10-07','2018-10-07 00:00:00',NULL,'248',1699984.00,1699984.00,'248','2018-10-09 13:29:25','248','2018-10-09 13:30:06',10,0),('1','64',64022,'MORNING SHIFT','2018-10-08','2018-10-08 00:00:00',NULL,'248',1655771.00,1655771.00,'248','2018-10-09 13:33:52','248','2018-10-09 13:34:41',10,0),('1','64',64024,'AFTERNOON SHIFT','2018-10-08','2018-10-08 00:00:00',NULL,'248',2084469.90,2084469.90,'248','2018-10-09 13:40:33','248','2018-10-09 13:48:33',10,0),('1','64',64026,'MORNING SHIFT','2018-10-09','2018-10-09 00:00:00',NULL,'248',176015.00,176015.00,'248','2018-10-10 09:42:58','248','2018-10-10 09:43:46',10,0),('1','64',64101,'PRICE CHANGE SHIFT','2018-10-09','2018-10-09 00:00:00',NULL,'248',1652993.30,1652993.30,'248','2018-10-10 10:33:46','248','2018-10-10 10:35:07',10,0),('1','64',64107,'AFTERNOON SHIFT','2018-10-09','2018-10-09 00:00:00',NULL,'248',2334857.90,2334857.90,'248','2018-10-13 09:53:13','248','2018-10-13 09:53:53',10,0),('1','64',64467,'MORNING SHIFT','2018-10-10','2018-10-10 00:00:00',NULL,'248',1770542.60,1770542.60,'248','2018-10-13 10:08:29','248','2018-10-13 10:09:47',10,0),('1','64',64470,'AFTERNOON SHIFT','2018-10-10','2018-10-10 00:00:00',NULL,'248',2035844.70,2035844.70,'248','2018-10-13 10:13:57','248','2018-10-13 10:14:32',10,0),('1','64',64474,'MORNING SHIFT','2018-10-11','2018-10-11 00:00:00',NULL,'248',1707156.20,1707156.20,'248','2018-10-13 10:32:33','248','2018-10-13 10:34:01',10,0),('1','64',64479,'AFTERNOON SHIFT','2018-10-11','2018-10-11 00:00:00',NULL,'248',2452348.80,2452348.80,'248','2018-10-14 08:37:09','248','2018-10-14 08:38:11',10,0),('1','64',64557,'MORNING SHIFT','2018-10-12','2018-10-12 00:00:00',NULL,'248',1933999.40,1933999.40,'248','2018-10-14 08:41:49','248','2018-10-14 08:42:49',10,0),('1','64',64558,'AFTERNOON SHIFT','2018-10-12','2018-10-12 00:00:00',NULL,'248',1934606.80,1934606.80,'248','2018-10-16 09:56:56','248','2018-10-16 09:57:38',10,0),('1','64',64783,'MORNING SHIFT','2018-10-13','2018-10-13 00:00:00',NULL,'248',1923941.50,1923941.50,'248','2018-10-16 10:03:04','248','2018-10-16 10:04:06',10,0),('1','64',64785,'AFTERNOON SHIFT','2018-10-13','2018-10-13 00:00:00',NULL,'248',2633241.80,2633241.80,'248','2018-10-16 10:09:30','248','2018-10-16 10:10:11',10,0),('1','64',64786,'MORNING SHIFT','2018-10-14','2018-10-14 00:00:00',NULL,'248',1432916.40,1432916.40,'248','2018-10-16 10:15:30','248','2018-10-16 10:16:18',10,0),('1','64',64787,'AFTERNOON SHIFT','2018-10-14','2018-10-14 00:00:00',NULL,'248',1894081.60,1894081.60,'248','2018-10-16 10:20:29','248','2018-10-16 10:21:17',10,0),('1','64',64792,'MORNING SHIFT','2018-10-15','2018-10-15 00:00:00',NULL,'248',3269596.60,3269596.60,'248','2018-10-16 10:25:47','248','2018-10-16 10:26:45',10,0),('1','64',64794,'MORNING SHIFT','2018-10-15','2018-10-15 00:00:00',NULL,'248',2889979.20,2889979.20,'248','2018-10-16 11:31:32','248','2018-10-16 11:33:38',10,0),('1','64',64812,'MORNING SHIFT','2018-10-16','2018-10-16 00:00:00',NULL,'248',1401996.00,1401996.00,'248','2018-10-17 08:08:32','248','2018-10-17 08:09:22',10,0),('1','64',64928,'AFTERNOON SHIFT','2018-10-16','2018-10-16 00:00:00',NULL,'248',2366429.00,2366429.00,'248','2018-10-17 10:29:27','248','2018-10-17 10:30:14',10,0),('1','64',64961,'MORNING SHIFT','2018-10-17','2018-10-17 00:00:00',NULL,'248',1841928.00,1841928.00,'248','2018-10-17 14:11:20','248','2018-10-17 14:11:55',10,0),('1','64',65004,'AFTERNOON SHIFT','2018-10-17','2018-10-17 00:00:00',NULL,'248',2051016.00,2051016.00,'248','2018-10-18 11:17:49','248','2018-10-18 11:18:37',10,0),('1','64',65092,'MORNING SHIFT','2018-10-18','2018-10-18 00:00:00',NULL,'248',1829338.00,1829338.00,'248','2018-10-18 14:26:10','248','2018-10-18 14:27:32',10,0),('1','64',65119,'AFTERNOON SHIFT','2018-10-18','2018-10-18 00:00:00',NULL,'248',1927780.00,1927780.00,'248','2018-10-19 12:29:39','248','2018-10-19 12:30:21',10,0),('1','64',65214,'MORNING SHIFT','2018-10-19','2018-10-19 00:00:00',NULL,'248',1741123.00,1741123.00,'248','2018-10-19 14:19:56','248','2018-10-19 14:20:43',10,0),('1','64',65236,'AFTERNOON SHIFT','2018-10-19','2018-10-19 00:00:00',NULL,'248',2261237.00,2261237.00,'248','2018-10-21 10:08:26','248','2018-10-21 10:12:04',10,0),('1','64',65405,'MORNING SHIFT','2018-10-20','2018-10-20 00:00:00',NULL,'248',1878351.00,1878351.00,'248','2018-10-21 10:17:10','248','2018-10-21 10:19:28',10,0),('1','64',65407,'AFTERNOON SHIFT','2018-10-20','2018-10-20 00:00:00',NULL,'248',2101154.00,2101154.00,'248','2018-10-21 10:27:46','248','2018-10-21 10:30:32',10,0),('1','64',65410,'MORNING SHIFT','2018-10-21','2018-10-21 00:00:00',NULL,'248',1706075.00,1706075.00,'248','2018-10-22 09:00:25','248','2018-10-22 09:02:16',10,0),('1','64',65510,'AFTERNOON SHIFT','2018-10-21','2018-10-21 00:00:00',NULL,'248',1810485.00,1810485.00,'248','2018-10-22 10:17:04','248','2018-10-22 10:17:34',10,0),('1','64',65522,'MORNING SHIFT','2018-10-22','2018-10-22 00:00:00',NULL,'248',2001485.00,2001485.00,'248','2018-10-23 11:08:05','248','2018-10-23 11:08:40',10,0),('1','64',65657,'AFTERNOON SHIFT','2018-10-22','2018-10-22 00:00:00',NULL,'248',2412354.00,2412354.00,'248','2018-10-23 11:13:53','248','2018-10-23 11:17:28',10,0),('1','64',65658,'MORNING SHIFT','2018-10-23','2018-10-23 00:00:00',NULL,'248',1967826.00,1967826.00,'248','2018-10-24 11:03:21','248','2018-10-24 11:04:21',10,0),('1','64',65764,'AFTERNOON SHIFT','2018-10-23','2018-10-23 00:00:00',NULL,'248',2239056.00,2239056.00,'248','2018-10-24 12:05:20','248','2018-10-24 12:06:05',10,0),('1','64',65771,'MORNING SHIFT','2018-10-24','2018-10-24 00:00:00',NULL,'248',1872045.00,1872045.00,'248','2018-10-25 10:31:35','248','2018-10-25 10:32:32',10,0),('1','64',65864,'AFTERNOON SHIFT','2018-10-24','2018-10-24 00:00:00',NULL,'248',2110063.00,2110063.00,'248','2018-10-25 10:35:50','248','2018-10-25 10:36:29',10,0),('1','64',65868,'MORNING SHIFT','2018-10-25','2018-10-25 00:00:00',NULL,'248',1796017.00,1796017.00,'248','2018-10-26 08:58:36','248','2018-10-26 08:59:14',10,0),('1','64',65982,'AFTERNOON SHIFT','2018-10-25','2018-10-25 00:00:00',NULL,'248',2145015.00,2145015.00,'248','2018-10-26 09:02:55','248','2018-10-26 09:04:06',10,0),('1','64',65983,'MORNING SHIFT','2018-10-26','2018-10-26 00:00:00',NULL,'248',105500.00,105500.00,'248','2018-10-26 09:09:18','248','2018-10-26 09:10:01',10,0),('1','64',65987,'PRICE CHANGE SHIFT','2018-10-26','2018-10-26 00:00:00',NULL,'248',1731379.00,1731379.00,'248','2018-10-27 10:15:37','248','2018-10-27 10:19:15',10,0),('1','64',66102,'AFTERNOON SHIFT','2018-10-26','2018-10-26 00:00:00',NULL,'248',2352255.00,2352255.00,'248','2018-10-27 10:30:57','248','2018-10-27 10:32:37',10,0),('1','64',66106,'MORNING SHIFT','2018-10-27','2018-10-27 00:00:00',NULL,'248',2078345.00,2078345.00,'248','2018-10-28 09:28:37','248','2018-10-28 09:34:47',10,0),('1','64',66212,'AFTERNOON SHIFT','2018-10-27','2018-10-27 00:00:00',NULL,'248',2047998.00,2047998.00,'248','2018-10-28 09:43:22','248','2018-10-28 09:44:35',10,0),('1','64',66213,'MORNING SHIFT','2018-10-28','2018-10-28 00:00:00',NULL,'248',1844091.00,1844091.00,'248','2018-10-30 08:25:18','248','2018-10-30 08:26:02',10,0),('1','64',66434,'AFTERNOON SHIFT','2018-10-28','2018-10-28 00:00:00',NULL,'248',1893313.00,1893313.00,'248','2018-10-30 08:31:18','248','2018-10-30 08:32:19',10,0),('1','64',66438,'MORNING SHIFT','2018-10-29','2018-10-29 00:00:00',NULL,'248',2112575.00,2112575.00,'248','2018-10-30 08:43:02','248','2018-10-30 08:44:00',10,0),('1','64',66441,'AFTERNOON SHIFT','2018-10-29','2018-10-29 00:00:00',NULL,'248',2278669.00,2278669.00,'248','2018-10-31 09:28:12','248','2018-10-31 09:28:53',10,0),('1','64',66567,'MORNING SHIFT','2018-10-30','2018-10-30 00:00:00',NULL,'248',1811850.00,1811850.00,'248','2018-10-31 09:38:49','248','2018-10-31 09:39:31',10,0),('1','64',66570,'AFTERNOON SHIFT','2018-10-30','2018-10-30 00:00:00',NULL,'248',2361931.00,2361931.00,'248','2018-10-31 10:24:11','248','2018-10-31 10:24:51',10,0),('1','64',66582,'MORNING SHIFT','2018-10-31','2018-10-31 00:00:00',NULL,'248',1552408.00,1552408.00,'248','2018-11-01 09:43:16','248','2018-11-01 09:44:09',10,0),('1','64',66682,'AFTERNOON SHIFT','2018-10-31','2018-10-31 00:00:00',NULL,'248',2111109.00,2111109.00,'248','2018-11-01 09:49:23','248','2018-11-01 09:50:15',10,0),('1','64',66683,'MORNING SHIFT','2018-11-01','2018-11-01 00:00:00',NULL,'248',2043112.00,2043112.00,'248','2018-11-01 14:41:15','248','2018-11-01 14:41:44',10,0),('1','64',66735,'AFTERNOON SHIFT','2018-11-01','2018-11-01 00:00:00',NULL,'248',2338686.00,2338686.00,'248','2018-11-03 08:28:20','248','2018-11-03 08:29:47',10,0),('1','64',66899,'MORNING SHIFT','2018-11-02','2018-11-02 00:00:00',NULL,'248',2074555.00,2074555.00,'248','2018-11-03 08:44:12','248','2018-11-03 08:48:11',10,0),('1','64',66902,'AFTERNOON SHIFT','2018-11-02','2018-11-02 00:00:00',NULL,'248',2236114.00,2236114.00,'248','2018-11-03 09:00:29','248','2018-11-03 09:02:50',10,0),('1','64',66905,'MORNING SHIFT','2018-11-03','2018-11-03 00:00:00',NULL,'248',1961817.00,1961817.00,'248','2018-11-06 11:00:22','248','2018-11-06 11:04:36',10,0),('1','64',67267,'AFTERNOON SHIFT','2018-11-03','2018-11-03 00:00:00',NULL,'248',2243956.00,2243956.00,'248','2018-11-06 11:08:58','248','2018-11-06 11:10:19',10,0),('1','64',67270,'MORNING SHIFT','2018-11-04','2018-11-04 00:00:00',NULL,'248',1748604.00,1748604.00,'248','2018-11-06 11:19:03','248','2018-11-06 11:19:54',10,0),('1','64',67275,'AFTERNOON SHIFT','2018-11-04','2018-11-04 00:00:00',NULL,'248',1804086.00,1804086.00,'248','2018-11-06 11:32:38','248','2018-11-06 11:33:07',10,0),('1','64',67277,'MORNING SHIFT','2018-11-05','2018-11-05 00:00:00',NULL,'248',2555283.00,2555283.00,'248','2018-11-06 11:39:08','248','2018-11-06 11:40:49',10,0),('1','64',67278,'AFTERNOON SHIFT','2018-11-05','2018-11-05 00:00:00',NULL,'248',3991706.00,3991706.00,'248','2018-11-06 14:18:32','248','2018-11-06 14:19:48',10,0),('1','64',67311,'MORNING SHIFT','2018-11-06','2018-11-06 00:00:00',NULL,'248',1562746.00,1562746.00,'248','2018-11-06 15:26:43','248','2018-11-06 15:27:26',10,0),('1','64',67329,'AFTERNOON SHIFT','2018-11-06','2018-11-06 00:00:00',NULL,'248',1706844.00,1706844.00,'248','2018-11-10 09:46:35','248','2018-11-10 09:47:10',10,0),('1','64',67698,'MORNING SHIFT','2018-11-07','2018-11-07 00:00:00',NULL,'248',1866604.00,1866604.00,'248','2018-11-10 10:25:04','248','2018-11-10 10:25:39',10,0),('1','64',67707,'AFTERNOON SHIFT','2018-11-07','2018-11-07 00:00:00',NULL,'248',1450726.00,1450726.00,'248','2018-11-10 10:30:15','248','2018-11-10 10:30:49',10,0),('1','64',67709,'MORNING SHIFT','2018-11-08','2018-11-08 00:00:00',NULL,'248',1773789.00,1773789.00,'248','2018-11-10 10:33:32','248','2018-11-10 10:33:59',10,0),('1','64',67710,'AFTERNOON SHIFT','2018-11-08','2018-11-08 00:00:00',NULL,'248',849711.00,849711.00,'248','2018-11-10 10:45:32','248','2018-11-10 10:46:32',10,0),('1','64',67711,'MORNING SHIFT','2018-11-09','2018-11-09 00:00:00',NULL,'248',158865.00,158865.00,'248','2018-11-11 14:09:18','248','2018-11-11 14:10:14',10,0),('1','64',67851,'AFTERNOON SHIFT','2018-11-09','2018-11-09 00:00:00',NULL,'248',19125.00,19125.00,'248','2018-11-11 14:13:09','248','2018-11-11 14:13:59',10,0),('1','64',67854,'MORNING SHIFT','2018-11-10','2018-11-10 00:00:00',NULL,'248',1088488.00,1088488.00,'248','2018-11-12 13:47:46','248','2018-11-12 13:48:46',10,0),('1','64',67962,'AFTERNOON SHIFT','2018-11-10','2018-11-10 00:00:00',NULL,'248',2082153.00,2082153.00,'248','2018-11-12 13:56:40','248','2018-11-12 13:57:14',10,0),('1','64',67964,'MORNING SHIFT','2018-11-11','2018-11-11 00:00:00',NULL,'248',1842159.00,1842159.00,'248','2018-11-12 14:02:44','248','2018-11-12 14:03:42',10,0),('1','64',67965,'AFTERNOON SHIFT','2018-11-11','2018-11-11 00:00:00',NULL,'248',1709548.00,1709548.00,'248','2018-11-12 14:09:48','248','2018-11-12 14:10:44',10,0),('1','64',67972,'MORNING SHIFT','2018-11-12','2018-11-12 00:00:00',NULL,'248',1835818.00,1835818.00,'248','2018-11-13 11:05:55','248','2018-11-13 11:06:31',10,0),('1','64',68080,'AFTERNOON SHIFT','2018-11-12','2018-11-12 00:00:00',NULL,'248',2442970.00,2442970.00,'248','2018-11-13 11:14:08','248','2018-11-13 11:14:44',10,0),('1','64',68083,'MORNING SHIFT','2018-11-13','2018-11-13 00:00:00',NULL,'248',2217698.00,2217698.00,'248','2018-11-14 13:30:59','248','2018-11-14 13:33:16',10,0),('1','64',68211,'AFTERNOON SHIFT','2018-11-13','2018-11-13 00:00:00',NULL,'248',2673862.00,2673862.00,'248','2018-11-14 13:38:10','248','2018-11-14 13:38:53',10,0),('1','64',68213,'MORNING SHIFT','2018-11-14','2018-11-14 00:00:00',NULL,'248',2092248.00,2092248.00,'248','2018-11-17 12:08:08','248','2018-11-17 12:10:05',10,0),('1','64',68522,'AFTERNOON SHIFT','2018-11-14','2018-11-14 00:00:00',NULL,'248',2190930.00,2190930.00,'248','2018-11-17 13:00:39','248','2018-11-17 13:02:17',10,0),('1','64',68530,'MORNING SHIFT','2018-11-15','2018-11-15 00:00:00',NULL,'248',1868352.00,1868352.00,'248','2018-11-17 13:12:06','248','2018-11-17 13:13:55',10,0),('1','64',68536,'AFTERNOON SHIFT','2018-11-15','2018-11-15 00:00:00',NULL,'248',2362293.00,2362293.00,'248','2018-11-17 13:19:45','248','2018-11-17 13:22:31',10,0),('1','64',68537,'MORNING SHIFT','2018-11-16','2018-11-16 00:00:00',NULL,'248',2245922.00,2245922.00,'248','2018-11-17 13:31:49','248','2018-11-17 13:33:59',10,0),('1','64',68541,'AFTERNOON SHIFT','2018-11-16','2018-11-16 00:00:00',NULL,'248',2984412.00,2984412.00,'248','2018-11-17 14:20:48','248','2018-11-17 14:21:36',10,0),('1','64',68556,'MORNING SHIFT','2018-11-17','2018-11-17 00:00:00',NULL,'248',2330728.00,2330728.00,'248','2018-11-20 12:53:00','248','2018-11-20 12:54:11',10,0),('1','64',68869,'AFTERNOON SHIFT','2018-11-17','2018-11-17 00:00:00',NULL,'248',2415796.00,2415796.00,'248','2018-11-20 12:59:49','248','2018-11-20 13:01:03',10,0),('1','64',68872,'MORNING SHIFT','2018-11-18','2018-11-18 00:00:00',NULL,'248',2123946.00,2123946.00,'248','2018-11-20 13:27:34','248','2018-11-20 13:28:43',10,0),('1','64',68886,'AFTERNOON SHIFT','2018-11-18','2018-11-18 00:00:00',NULL,'248',2119397.00,2119397.00,'248','2018-11-20 13:36:00','248','2018-11-20 13:36:47',10,0),('1','64',68888,'MORNING SHIFT','2018-11-19','2018-11-19 00:00:00',NULL,'248',2478547.00,2478547.00,'248','2018-11-20 15:36:25','248','2018-11-20 15:37:23',10,0),('1','64',68911,'AFTERNOON SHIFT','2018-11-19','2018-11-19 00:00:00',NULL,'248',2871489.00,2871489.00,'248','2018-11-20 15:47:13','248','2018-11-20 15:48:08',10,0),('1','64',68915,'MORNING SHIFT','2018-11-20','2018-11-20 00:00:00',NULL,'248',2107819.00,2107819.00,'248','2018-11-20 16:06:28','248','2018-11-20 16:07:14',10,0),('1','64',68917,'AFTERNOON SHIFT','2018-11-20','2018-11-20 00:00:00',NULL,'248',2457067.00,2457067.00,'248','2018-11-21 11:44:40','248','2018-11-21 11:45:16',10,0),('1','64',68977,'MORNING SHIFT','2018-11-21','2018-11-21 00:00:00',NULL,'248',1969652.00,1969652.00,'248','2018-11-22 09:32:58','248','2018-11-22 09:36:16',10,0),('1','64',69071,'AFTERNOON SHIFT','2018-11-21','2018-11-21 00:00:00',NULL,'248',2935346.00,2935346.00,'248','2018-11-22 09:48:30','248','2018-11-22 09:49:59',10,0),('1','64',69075,'MORNING SHIFT','2018-11-22','2018-11-22 00:00:00',NULL,'248',2280272.00,2280272.00,'248','2018-11-22 15:28:13','248','2018-11-22 15:30:10',10,0),('1','64',69145,'AFTERNOON SHIFT','2018-11-22','2018-11-22 00:00:00',NULL,'248',2795944.00,2795944.00,'248','2018-11-24 09:05:02','248','2018-11-24 09:07:02',10,0),('1','64',69288,'MORNING SHIFT','2018-11-23','2018-11-23 00:00:00',NULL,'248',2429991.00,2429991.00,'248','2018-11-24 09:16:02','248','2018-11-24 09:17:17',10,0),('1','64',69289,'AFTERNOON SHIFT','2018-11-23','2018-11-23 00:00:00',NULL,'248',2949807.00,2949807.00,'248','2018-11-24 09:25:57','248','2018-11-24 09:27:05',10,0),('1','64',69290,'MORNING SHIFT','2018-11-24','2018-11-24 00:00:00',NULL,'248',2568043.00,2568043.00,'248','2018-11-26 13:38:09','248','2018-11-26 13:39:02',10,0),('1','64',69539,'AFTERNOON SHIFT','2018-11-24','2018-11-24 00:00:00',NULL,'248',2484721.00,2484721.00,'248','2018-11-26 13:49:51','248','2018-11-26 13:50:30',10,0),('1','64',69546,'MORNING SHIFT','2018-11-25','2018-11-25 00:00:00',NULL,'248',1841417.00,1841417.00,'248','2018-11-26 13:57:01','248','2018-11-26 13:57:57',10,0),('1','64',69547,'AFTERNOON SHIFT','2018-11-25','2018-11-25 00:00:00',NULL,'248',2156186.00,2156186.00,'248','2018-11-26 14:03:44','248','2018-11-26 14:04:42',10,0),('1','64',69549,'MORNING SHIFT','2018-11-26','2018-11-26 00:00:00',NULL,'248',2730912.00,2730912.00,'248','2018-11-26 14:11:29','248','2018-11-26 14:12:20',10,0),('1','64',69550,'AFTERNOON SHIFT','2018-11-26','2018-11-26 00:00:00',NULL,'248',2884670.00,2884670.00,'248','2018-11-27 11:39:30','248','2018-11-27 11:39:55',10,0),('1','64',69658,'MORNING SHIFT','2018-11-27','2018-11-27 00:00:00',NULL,'248',2143102.00,2143102.00,'248','2018-11-29 09:11:15','248','2018-11-29 09:12:09',10,0),('1','64',69860,'AFTERNOON SHIFT','2018-11-27','2018-11-27 00:00:00',NULL,'248',2858056.00,2858056.00,'248','2018-11-29 09:21:05','248','2018-11-29 09:23:16',10,0),('1','64',69863,'MORNING SHIFT','2018-11-28','2018-11-28 00:00:00',NULL,'248',2119762.00,2119762.00,'248','2018-11-29 09:32:31','248','2018-11-29 09:33:17',10,0),('1','64',69870,'AFTERNOON SHIFT','2018-11-28','2018-11-28 00:00:00',NULL,'248',2486849.00,2486849.00,'248','2018-11-29 09:47:48','248','2018-11-29 09:48:39',10,0),('1','64',69873,'MORNING SHIFT','2018-11-29','2018-11-29 00:00:00',NULL,'248',2207887.00,2207887.00,'248','2018-11-30 20:39:59','248','2018-11-30 20:41:11',10,0),('1','64',70082,'AFTERNOON SHIFT','2018-11-29','2018-11-29 00:00:00',NULL,'248',2739719.00,2739719.00,'248','2018-12-02 11:34:34','248','2018-12-02 11:35:12',10,0),('1','64',70175,'MORNING SHIFT','2018-11-30','2018-11-30 00:00:00',NULL,'248',2757862.00,2757862.00,'248','2018-12-02 11:40:46','248','2018-12-02 11:42:40',10,0),('1','64',70180,'AFTERNOON SHIFT','2018-11-30','2018-11-30 00:00:00',NULL,'248',2938949.00,2938949.00,'248','2018-12-02 11:53:46','248','2018-12-02 11:55:42',10,0),('1','64',70184,'MORNING SHIFT','2018-12-01','2018-12-01 00:00:00',NULL,'248',2566408.00,2566408.00,'248','2018-12-02 12:01:06','248','2018-12-02 12:01:49',10,0),('1','64',70187,'AFTERNOON SHIFT','2018-12-01','2018-12-01 00:00:00',NULL,'248',2609366.00,2609366.00,'248','2018-12-02 12:07:17','248','2018-12-02 12:08:21',10,0),('1','64',70190,'MORNING SHIFT','2018-12-02','2018-12-02 00:00:00',NULL,'248',1965649.00,1965649.00,'248','2018-12-03 09:56:09','248','2018-12-03 09:57:34',10,0),('1','64',70294,'AFTERNOON SHIFT','2018-12-02','2018-12-02 00:00:00',NULL,'248',2084903.00,2084903.00,'248','2018-12-03 10:47:34','248','2018-12-03 10:49:23',10,0),('1','64',70450,'MORNING SHIFT','2018-12-03','2018-12-03 00:00:00',NULL,'248',1861429.50,1861429.50,'248','2018-12-04 11:49:55','248','2018-12-04 12:01:17',10,0),('1','64',70454,'AFTERNOON SHIFT','2018-12-03','2018-12-03 00:00:00',NULL,'248',673653.70,673653.70,'248','2018-12-04 12:12:23','248','2018-12-04 12:14:54',10,0),('1','64',70456,'MORNING SHIFT','2018-12-04','2018-12-04 00:00:00',NULL,'248',397084.00,397084.00,'248','2018-12-05 18:31:37','248','2018-12-05 18:32:36',10,0),('1','64',70643,'AFTERNOON SHIFT','2018-12-04','2018-12-04 00:00:00',NULL,'248',178500.00,178500.00,'248','2018-12-05 18:34:57','248','2018-12-05 18:35:51',10,0),('1','64',70644,'MORNING SHIFT','2018-12-05','2018-12-05 00:00:00',NULL,'248',1543028.00,1543028.00,'248','2018-12-05 18:45:17','248','2018-12-05 18:46:04',10,0),('1','64',70645,'AFTERNOON SHIFT','2018-12-05','2018-12-05 00:00:00',NULL,'248',1286030.00,1286030.00,'248','2018-12-06 08:51:44','248','2018-12-06 08:52:42',10,0),('1','64',70664,'MORNING SHIFT','2018-12-06','2018-12-06 00:00:00',NULL,'248',1704368.00,1704368.00,'248','2018-12-07 10:39:45','248','2018-12-07 10:40:17',10,0),('1','64',70806,'AFTERNOON SHIFT','2018-12-06','2018-12-06 00:00:00',NULL,'248',2173230.00,2173230.00,'248','2018-12-07 10:43:14','248','2018-12-07 10:43:52',10,0),('1','64',70808,'MORNING SHIFT','2018-12-07','2018-12-07 00:00:00',NULL,'248',1896224.00,1896224.00,'248','2018-12-08 12:49:18','248','2018-12-08 12:51:10',10,0),('1','64',70941,'AFTERNOON SHIFT','2018-12-07','2018-12-07 00:00:00',NULL,'248',2758679.00,2758679.00,'248','2018-12-09 09:58:18','248','2018-12-09 09:59:15',10,0),('1','64',71018,'MORNING SHIFT','2018-12-08','2018-12-08 00:00:00',NULL,'248',2317873.00,2317873.00,'248','2018-12-09 10:06:23','248','2018-12-09 10:08:07',10,0),('1','64',71021,'AFTERNOON SHIFT','2018-12-08','2018-12-08 00:00:00',NULL,'248',2569585.50,2569585.50,'248','2018-12-09 10:14:02','248','2018-12-09 10:15:23',10,0),('1','64',71023,'MORNING SHIFT','2018-12-09','2018-12-09 00:00:00',NULL,'248',2517859.90,2517859.90,'248','2018-12-10 08:57:11','248','2018-12-10 08:58:03',10,0),('1','64',71120,'AFTERNOON SHIFT','2018-12-09','2018-12-09 00:00:00',NULL,'248',2721208.10,2721208.10,'248','2018-12-10 14:49:12','248','2018-12-10 14:50:00',10,0),('1','64',71186,'MORNING SHIFT','2018-12-10','2018-12-10 00:00:00',NULL,'248',2453047.10,2453047.10,'248','2018-12-10 15:07:06','248','2018-12-10 15:07:59',10,0),('1','64',71190,'AFTERNOON SHIFT','2018-12-10','2018-12-10 00:00:00',NULL,'248',3533221.80,3533221.80,'248','2018-12-11 10:39:40','248','2018-12-11 10:40:45',10,0),('1','64',71263,'MORNING SHIFT','2018-12-11','2018-12-11 00:00:00',NULL,'248',2280370.90,2280370.90,'248','2018-12-12 09:28:53','248','2018-12-12 09:30:28',10,0),('1','64',71378,'AFTERNOON SHIFT','2018-12-11','2018-12-11 00:00:00',NULL,'248',2653565.40,2653565.40,'248','2018-12-12 11:40:48','248','2018-12-12 11:42:22',10,0),('1','64',71415,'MORNING SHIFT','2018-12-12','2018-12-12 00:00:00',NULL,'248',2376961.70,2376961.70,'248','2018-12-14 10:36:20','248','2018-12-14 10:37:26',10,0),('1','64',71669,'AFTERNOON SHIFT','2018-12-12','2018-12-12 00:00:00',NULL,'248',8440.20,8440.20,'248','2018-12-14 10:46:44','248','2018-12-14 10:47:30',10,0),('1','64',71677,'PRICE CHANGE SHIFT','2018-12-12','2018-12-12 00:00:00',NULL,'248',2347506.00,2347506.00,'248','2018-12-14 11:14:27','248','2018-12-14 11:17:37',10,0),('1','64',71681,'MORNING SHIFT','2018-12-13','2018-12-13 00:00:00',NULL,'248',2421827.60,2421827.60,'248','2018-12-14 11:21:57','248','2018-12-14 11:23:40',10,0),('1','64',71684,'AFTERNOON SHIFT','2018-12-13','2018-12-13 00:00:00',NULL,'248',2785777.00,2785777.00,'248','2018-12-14 11:36:56','248','2018-12-14 12:16:02',10,0),('1','64',71691,'MORNING SHIFT','2018-12-14','2018-12-14 00:00:00',NULL,'248',2571731.60,2571731.60,'248','2018-12-17 10:18:53','248','2018-12-17 10:19:36',10,0),('1','64',72087,'AFTERNOON SHIFT','2018-12-14','2018-12-14 00:00:00',NULL,'248',2826342.80,2826342.80,'248','2018-12-17 10:24:59','248','2018-12-17 10:34:10',10,0),('1','64',72090,'MORNING SHIFT','2018-12-15','2018-12-15 00:00:00',NULL,'248',2643123.00,2643123.00,'248','2018-12-17 10:56:24','248','2018-12-17 10:57:15',10,0),('1','64',72093,'AFTERNOON SHIFT','2018-12-15','2018-12-15 00:00:00',NULL,'248',2645901.60,2645901.60,'248','2018-12-17 11:38:54','248','2018-12-17 11:44:58',10,0),('1','64',72101,'MORNING SHIFT','2018-12-16','2018-12-16 00:00:00',NULL,'248',2265980.20,2265980.20,'248','2018-12-17 11:52:39','248','2018-12-17 11:53:55',10,0),('1','64',72105,'AFTERNOON SHIFT','2018-12-16','2018-12-16 00:00:00',NULL,'248',2349314.20,2349314.20,'248','2018-12-17 11:58:45','248','2018-12-17 11:59:47',10,0),('1','64',72109,'MORNING SHIFT','2018-12-17','2018-12-17 00:00:00',NULL,'248',2222511.40,2222511.40,'248','2018-12-19 09:44:43','248','2018-12-19 09:45:44',10,0),('1','64',72359,'AFTERNOON SHIFT','2018-12-17','2018-12-17 00:00:00',NULL,'248',2186302.60,2186302.60,'248','2018-12-19 09:49:39','248','2018-12-19 09:50:29',10,0),('1','64',72362,'MORNING SHIFT','2018-12-18','2018-12-18 00:00:00',NULL,'248',2505291.80,2505291.80,'248','2018-12-19 09:56:42','248','2018-12-19 09:57:21',10,0),('1','64',72365,'AFTERNOON SHIFT','2018-12-18','2018-12-18 00:00:00',NULL,'248',2634828.40,2634828.40,'248','2018-12-19 10:02:43','248','2018-12-19 10:03:24',10,0),('1','64',72368,'MORNING SHIFT','2018-12-19','2018-12-19 00:00:00',NULL,'248',2534697.80,2534697.80,'248','2018-12-21 10:51:50','248','2018-12-21 10:52:53',10,0),('1','64',72634,'AFTERNOON SHIFT','2018-12-19','2018-12-19 00:00:00',NULL,'248',2905607.60,2905607.60,'248','2018-12-21 11:00:03','248','2018-12-21 11:02:29',10,0),('1','64',72636,'MORNING SHIFT','2018-12-20','2018-12-20 00:00:00',NULL,'248',2132013.60,2132013.60,'248','2018-12-21 11:50:13','248','2018-12-21 11:52:14',10,0),('1','64',72644,'AFTERNOON SHIFT','2018-12-20','2018-12-20 00:00:00',NULL,'248',2371821.50,2371821.50,'248','2018-12-21 12:24:43','248','2018-12-21 12:25:51',10,0),('1','64',72647,'MORNING SHIFT','2018-12-21','2018-12-21 00:00:00',NULL,'248',2050565.70,2050565.70,'248','2018-12-24 09:22:55','248','2018-12-24 09:23:43',10,0),('1','64',73010,'AFTERNOON SHIFT','2018-12-21','2018-12-21 00:00:00',NULL,'248',41250.00,41250.00,'248','2018-12-24 09:26:27','248','2018-12-24 09:27:12',10,0),('1','64',73013,'PRICE CHANGE SHIFT','2018-12-21','2018-12-21 00:00:00',NULL,'248',2620178.70,2620178.70,'248','2018-12-24 09:39:28','248','2018-12-24 09:40:44',10,0),('1','64',73014,'MORNING SHIFT','2018-12-22','2018-12-22 00:00:00',NULL,'248',2725548.10,2725548.10,'248','2018-12-24 10:02:51','248','2018-12-24 10:03:38',10,0),('1','64',73019,'AFTERNOON SHIFT','2018-12-22','2018-12-22 00:00:00',NULL,'248',2779930.40,2779930.40,'248','2018-12-24 10:08:17','248','2018-12-24 10:08:47',10,0),('1','64',73022,'MORNING SHIFT','2018-12-23','2018-12-23 00:00:00',NULL,'248',2066485.10,2066485.10,'248','2018-12-24 10:12:35','248','2018-12-24 10:13:16',10,0),('1','64',73036,'AFTERNOON SHIFT','2018-12-23','2018-12-23 00:00:00',NULL,'248',2448222.50,2448222.50,'248','2018-12-24 11:51:06','248','2018-12-24 11:52:19',10,0),('1','64',73053,'MORNING SHIFT','2018-12-24','2018-12-24 00:00:00',NULL,'248',1971954.85,1971954.85,'248','2018-12-26 11:02:57','248','2018-12-26 11:04:20',10,0),('1','64',73290,'AFTERNOON SHIFT','2018-12-24','2018-12-24 00:00:00',NULL,'248',1529364.35,1529364.35,'248','2018-12-26 11:10:17','248','2018-12-26 11:18:00',10,0),('1','64',73294,'MORNING SHIFT','2018-12-25','2018-12-25 00:00:00',NULL,'248',3378778.00,3378778.00,'248','2018-12-26 12:03:26','248','2018-12-26 12:04:07',10,0),('1','64',73309,'AFTERNOON SHIFT','2018-12-25','2018-12-25 00:00:00',NULL,'248',2263576.00,2263576.00,'248','2018-12-26 12:56:53','248','2018-12-26 13:13:21',10,0),('1','64',73369,'MORNING SHIFT','2018-12-26','2018-12-26 00:00:00',NULL,'248',1979466.00,1979466.00,'248','2018-12-28 10:20:14','248','2018-12-28 10:21:19',10,0),('1','64',73528,'AFTERNOON SHIFT','2018-12-26','2018-12-26 00:00:00',NULL,'248',1566444.00,1566444.00,'248','2018-12-28 10:27:36','248','2018-12-28 10:29:32',10,0),('1','64',73531,'MORNING SHIFT','2018-12-27','2018-12-27 00:00:00',NULL,'248',1846110.00,1846110.00,'248','2018-12-28 10:37:40','248','2018-12-28 10:38:21',10,0),('1','64',73537,'AFTERNOON SHIFT','2018-12-27','2018-12-27 00:00:00',NULL,'248',2217220.00,2217220.00,'248','2018-12-30 13:21:51','248','2018-12-30 13:22:57',10,0),('1','64',73793,'MORNING SHIFT','2018-12-28','2018-12-28 00:00:00',NULL,'248',1964840.00,1964840.00,'248','2018-12-30 13:28:21','248','2018-12-30 13:29:11',10,0),('1','64',73794,'AFTERNOON SHIFT','2018-12-28','2018-12-28 00:00:00',NULL,'248',2939354.00,2939354.00,'248','2018-12-30 13:36:14','248','2018-12-30 13:37:37',10,0),('1','64',73796,'MORNING SHIFT','2018-12-29','2018-12-29 00:00:00',NULL,'248',1982474.00,1982474.00,'248','2018-12-30 13:42:31','248','2018-12-30 13:43:19',10,0),('1','64',73798,'AFTERNOON SHIFT','2018-12-29','2018-12-29 00:00:00',NULL,'248',2171642.00,2171642.00,'248','2018-12-30 13:50:53','248','2018-12-30 13:52:47',10,0),('1','64',73800,'MORNING SHIFT','2018-12-30','2018-12-30 00:00:00',NULL,'248',1971528.00,1971528.00,'248','2018-12-31 08:59:57','248','2018-12-31 09:00:28',10,0),('1','64',73875,'AFTERNOON SHIFT','2018-12-30','2018-12-30 00:00:00',NULL,'248',2137526.00,2137526.00,'248','2018-12-31 12:36:52','248','2018-12-31 12:38:23',10,0),('1','64',73925,'MORNING SHIFT','2018-12-31','2018-12-31 00:00:00',NULL,'248',2293916.00,2293916.00,'248','2019-01-01 14:39:45','248','2019-01-01 14:41:26',10,0),('1','64',74101,'AFTERNOON SHIFT','2018-12-31','2018-12-31 00:00:00',NULL,'248',3458113.00,3458113.00,'248','2019-01-01 14:46:58','248','2019-01-01 14:47:45',10,0),('1','64',74103,'MORNING SHIFT','2019-01-01','2019-01-01 00:00:00',NULL,'248',3598044.00,3598044.00,'248','2019-01-02 13:56:32','248','2019-01-02 13:56:56',10,0),('1','64',74186,'AFTERNOON SHIFT','2019-01-01','2019-01-01 00:00:00',NULL,'248',2482678.00,2482678.00,'248','2019-01-02 14:02:28','248','2019-01-02 14:03:20',10,0),('1','64',74190,'MORNING SHIFT','2019-01-02','2019-01-02 00:00:00',NULL,'248',1644583.00,1644583.00,'248','2019-01-02 14:14:17','248','2019-01-02 14:15:20',10,0),('1','64',74196,'AFTERNOON SHIFT','2019-01-02','2019-01-02 00:00:00',NULL,'248',2204952.00,2204952.00,'248','2019-01-08 11:37:40','248','2019-01-08 11:38:24',10,0),('1','64',74857,'MORNING SHIFT','2019-01-03','2019-01-03 00:00:00',NULL,'248',1866524.00,1866524.00,'248','2019-01-08 11:41:04','248','2019-01-08 11:42:21',10,0),('1','64',74860,'AFTERNOON SHIFT','2019-01-03','2019-01-03 00:00:00',NULL,'248',2270344.00,2270344.00,'248','2019-01-08 11:46:43','248','2019-01-08 11:47:58',10,0),('1','64',74862,'MORNING SHIFT','2019-01-04','2019-01-04 00:00:00',NULL,'248',1703593.00,1703593.00,'248','2019-01-08 11:53:57','248','2019-01-08 11:55:10',10,0),('1','64',74866,'AFTERNOON SHIFT','2019-01-04','2019-01-04 00:00:00',NULL,'248',2482053.00,2482053.00,'248','2019-01-08 12:01:48','248','2019-01-08 12:02:42',10,0),('1','64',74869,'MORNING SHIFT','2019-01-05','2019-01-05 00:00:00',NULL,'248',1878844.00,1878844.00,'248','2019-01-08 12:08:19','248','2019-01-08 12:10:02',10,0),('1','64',74871,'AFTERNOON SHIFT','2019-01-05','2019-01-05 00:00:00',NULL,'248',2542746.00,2542746.00,'248','2019-01-08 12:39:05','248','2019-01-08 12:39:45',10,0),('1','64',74876,'MORNING SHIFT','2019-01-06','2019-01-06 00:00:00',NULL,'248',1836875.00,1836875.00,'248','2019-01-08 12:52:11','248','2019-01-08 12:53:16',10,0),('1','64',74880,'AFTERNOON SHIFT','2019-01-06','2019-01-06 00:00:00',NULL,'248',2117534.00,2117534.00,'248','2019-01-08 13:04:46','248','2019-01-08 13:05:52',10,0),('1','64',74883,'MORNING SHIFT','2019-01-07','2019-01-07 00:00:00',NULL,'248',2134349.00,2134349.00,'248','2019-01-08 13:17:58','248','2019-01-08 13:20:09',10,0),('1','64',74886,'AFTERNOON SHIFT','2019-01-07','2019-01-07 00:00:00',NULL,'248',2724829.00,2724829.00,'248','2019-01-08 13:33:29','248','2019-01-08 13:34:17',10,0),('1','64',74890,'MORNING SHIFT','2019-01-08','2019-01-08 00:00:00',NULL,'248',2114818.00,2114818.00,'248','2019-01-10 10:56:12','248','2019-01-10 10:56:43',10,0),('1','64',75121,'AFTERNOON SHIFT','2019-01-08','2019-01-08 00:00:00',NULL,'248',2541358.00,2541358.00,'248','2019-01-10 11:00:56','248','2019-01-10 11:01:53',10,0),('1','64',75123,'MORNING SHIFT','2019-01-09','2019-01-09 00:00:00',NULL,'248',1774275.00,1774275.00,'248','2019-01-10 11:22:34','248','2019-01-10 11:27:26',10,0),('1','64',75135,'AFTERNOON SHIFT','2019-01-09','2019-01-09 00:00:00',NULL,'248',2566671.00,2566671.00,'248','2019-01-10 11:39:07','248','2019-01-10 11:39:47',10,0),('1','64',75137,'MORNING SHIFT','2019-01-10','2019-01-10 00:00:00',NULL,'248',2088158.00,2088158.00,'248','2019-01-11 11:07:24','248','2019-01-11 11:08:44',10,0),('1','64',75256,'AFTERNOON SHIFT','2019-01-10','2019-01-10 00:00:00',NULL,'248',2261284.00,2261284.00,'248','2019-01-11 12:09:08','248','2019-01-11 12:14:09',10,0),('1','64',75260,'MORNING SHIFT','2019-01-11','2019-01-11 00:00:00',NULL,'248',2079683.00,2079683.00,'248','2019-01-12 14:05:54','248','2019-01-12 14:06:48',10,0),('1','64',75402,'AFTERNOON SHIFT','2019-01-11','2019-01-11 00:00:00',NULL,'248',2457612.00,2457612.00,'248','2019-01-12 14:17:09','248','2019-01-12 14:18:30',10,0),('1','64',75403,'MORNING SHIFT','2019-01-12','2019-01-12 00:00:00',NULL,'248',2122833.00,2122833.00,'248','2019-01-12 14:47:37','248','2019-01-12 14:49:08',10,0),('1','64',75410,'AFTERNOON SHIFT','2019-01-12','2019-01-12 00:00:00',NULL,'248',2349696.00,2349696.00,'248','2019-01-13 11:23:59','248','2019-01-13 11:25:28',10,0),('1','64',75473,'MORNING SHIFT','2019-01-13','2019-01-13 00:00:00',NULL,'248',2147879.00,2147879.00,'248','2019-01-14 08:10:01','248','2019-01-14 08:10:52',10,0),('1','64',75562,'AFTERNOON SHIFT','2019-01-13','2019-01-13 00:00:00',NULL,'248',2305323.00,2305323.00,'248','2019-01-14 10:50:18','248','2019-01-14 10:51:25',10,0),('1','64',75588,'MORNING SHIFT','2019-01-14','2019-01-14 00:00:00',NULL,'248',1950324.00,1950324.00,'248','2019-01-15 08:47:16','248','2019-01-15 08:49:00',10,0),('1','64',75685,'AFTERNOON SHIFT','2019-01-14','2019-01-14 00:00:00',NULL,'248',2698220.50,2698220.50,'248','2019-01-15 09:55:40','248','2019-01-15 09:57:43',10,0),('1','64',75703,'MORNING SHIFT','2019-01-15','2019-01-15 00:00:00',NULL,'248',2248623.50,2248623.50,'248','2019-01-17 09:15:32','248','2019-01-17 09:16:11',10,0),('1','64',75951,'AFTERNOON SHIFT','2019-01-15','2019-01-15 00:00:00',NULL,'248',2409919.00,2409919.00,'248','2019-01-17 09:20:10','248','2019-01-17 09:22:36',10,0),('1','64',75956,'MORNING SHIFT','2019-01-16','2019-01-16 00:00:00',NULL,'248',2196465.50,2196465.50,'248','2019-01-17 09:54:38','248','2019-01-17 09:55:53',10,0),('1','64',75957,'AFTERNOON SHIFT','2019-01-16','2019-01-16 00:00:00',NULL,'248',2251803.50,2251803.50,'248','2019-01-18 14:32:03','248','2019-01-18 14:32:47',10,0),('1','64',76125,'MORNING SHIFT','2019-01-17','2019-01-17 00:00:00',NULL,'248',2055411.00,2055411.00,'248','2019-01-18 14:35:40','248','2019-01-18 14:36:06',10,0),('1','64',76127,'AFTERNOON SHIFT','2019-01-17','2019-01-17 00:00:00',NULL,'248',2393164.00,2393164.00,'248','2019-01-18 14:39:00','248','2019-01-18 14:39:35',10,0),('1','64',76128,'MORNING SHIFT','2019-01-18','2019-01-18 00:00:00',NULL,'248',1403315.00,1403315.00,'248','2019-01-19 11:20:01','248','2019-01-19 11:29:31',10,0),('1','64',76207,'AFTERNOON SHIFT','2019-01-18','2019-01-18 00:00:00',NULL,'248',2924659.50,2924659.50,'248','2019-01-19 11:47:35','248','2019-01-19 11:48:31',10,0),('1','64',76210,'MORNING SHIFT','2019-01-19','2019-01-19 00:00:00',NULL,'248',1687759.50,1687759.50,'248','2019-01-20 14:58:53','248','2019-01-20 15:00:50',10,0),('1','64',76361,'AFTERNOON SHIFT','2019-01-19','2019-01-19 00:00:00',NULL,'248',1834075.00,1834075.00,'248','2019-01-21 12:49:20','248','2019-01-21 12:50:17',10,0),('1','64',76463,'MORNING SHIFT','2019-01-20','2019-01-20 00:00:00',NULL,'248',1998609.00,1998609.00,'248','2019-01-21 12:54:23','248','2019-01-21 12:54:58',10,0),('1','64',76464,'AFTERNOON SHIFT','2019-01-20','2019-01-20 00:00:00',NULL,'248',1832440.50,1832440.50,'248','2019-01-21 13:03:47','248','2019-01-21 13:05:35',10,0),('1','64',76466,'MORNING SHIFT','2019-01-21','2019-01-21 00:00:00',NULL,'248',1765533.00,1765533.00,'248','2019-01-22 09:58:27','248','2019-01-22 09:59:44',10,0),('1','64',76574,'AFTERNOON SHIFT','2019-01-21','2019-01-21 00:00:00',NULL,'248',2322561.63,2322561.63,'248','2019-01-23 09:05:37','248','2019-01-23 09:06:34',10,0),('1','64',76697,'MORNING SHIFT','2019-01-22','2019-01-22 00:00:00',NULL,'248',1900998.00,1900998.00,'248','2019-01-24 10:16:03','248','2019-01-24 10:16:44',10,0),('1','64',76831,'AFTERNOON SHIFT','2019-01-22','2019-01-22 00:00:00',NULL,'248',2748116.50,2748116.50,'248','2019-01-24 10:38:59','248','2019-01-24 10:39:31',10,0),('1','64',76841,'MORNING SHIFT','2019-01-23','2019-01-23 00:00:00',NULL,'248',1869882.50,1869882.50,'248','2019-01-24 10:43:45','248','2019-01-24 10:44:22',10,0),('1','64',76842,'AFTERNOON SHIFT','2019-01-23','2019-01-23 00:00:00',NULL,'248',2494661.00,2494661.00,'248','2019-01-24 10:49:11','248','2019-01-24 10:50:13',10,0),('1','64',76843,'MORNING SHIFT','2019-01-24','2019-01-24 00:00:00',NULL,'248',2058538.50,2058538.50,'248','2019-01-25 10:17:44','248','2019-01-25 10:20:38',10,0),('1','64',76952,'AFTERNOON SHIFT','2019-01-24','2019-01-24 00:00:00',NULL,'248',2401122.00,2401122.00,'248','2019-01-27 09:31:02','248','2019-01-27 09:31:43',10,0),('1','64',77177,'MORNING SHIFT','2019-01-25','2019-01-25 00:00:00',NULL,'248',2056778.00,2056778.00,'248','2019-01-27 09:35:10','248','2019-01-27 09:35:41',10,0),('1','64',77179,'AFTERNOON SHIFT','2019-01-25','2019-01-25 00:00:00',NULL,'248',2519956.00,2519956.00,'248','2019-01-27 09:39:06','248','2019-01-27 09:39:35',10,0),('1','64',77181,'MORNING SHIFT','2019-01-26','2019-01-26 00:00:00',NULL,'248',1843479.00,1843479.00,'248','2019-01-27 09:44:05','248','2019-01-27 09:46:53',10,0),('1','64',77182,'AFTERNOON SHIFT','2019-01-26','2019-01-26 00:00:00',NULL,'248',2409935.50,2409935.50,'248','2019-01-27 09:52:41','248','2019-01-27 09:53:42',10,0),('1','64',77183,'MORNING SHIFT','2019-01-27','2019-01-27 00:00:00',NULL,'248',1778466.50,1778466.50,'248','2019-01-28 09:37:23','248','2019-01-28 09:38:26',10,0),('1','64',77293,'AFTERNOON SHIFT','2019-01-27','2019-01-27 00:00:00',NULL,'248',2053509.50,2053509.50,'248','2019-01-28 09:46:21','248','2019-01-28 09:47:14',10,0),('1','64',77296,'MORNING SHIFT','2019-01-28','2019-01-28 00:00:00',NULL,'248',1783480.50,1783480.50,'248','2019-01-30 10:11:07','248','2019-01-30 10:11:47',10,0),('1','64',77567,'AFTERNOON SHIFT','2019-01-28','2019-01-28 00:00:00',NULL,'248',74495.00,74495.00,'248','2019-01-30 10:16:03','248','2019-01-30 10:16:51',10,0),('1','64',77569,'PRICE CHANGE SHIFT','2019-01-28','2019-01-28 00:00:00',NULL,'248',2318565.50,2318565.50,'248','2019-01-30 10:53:43','248','2019-01-30 10:59:31',10,0),('1','64',77574,'MORNING SHIFT','2019-01-29','2019-01-29 00:00:00',NULL,'248',1803678.50,1803678.50,'248','2019-01-30 11:38:37','248','2019-01-30 11:39:25',10,0),('1','64',77587,'AFTERNOON SHIFT','2019-01-29','2019-01-29 00:00:00',NULL,'248',2227346.00,2227346.00,'248','2019-01-30 11:44:18','248','2019-01-30 11:45:06',10,0),('1','64',77588,'MORNING SHIFT','2019-01-30','2019-01-30 00:00:00',NULL,'248',2017423.50,2017423.50,'248','2019-02-01 09:42:27','248','2019-02-01 09:46:58',10,0),('1','64',77800,'AFTERNOON SHIFT','2019-01-30','2019-01-30 00:00:00',NULL,'248',2261553.00,2261553.00,'248','2019-02-01 09:53:59','248','2019-02-01 09:54:50',10,0),('1','64',77802,'MORNING SHIFT','2019-01-31','2019-01-31 00:00:00',NULL,'248',1873756.00,1873756.00,'248','2019-02-02 08:49:26','248','2019-02-02 08:49:54',10,0),('1','64',77915,'AFTERNOON SHIFT','2019-01-31','2019-01-31 00:00:00',NULL,'248',2622103.00,2622103.00,'248','2019-02-02 09:00:41','248','2019-02-02 09:01:33',10,0),('1','64',77918,'MORNING SHIFT','2019-02-01','2019-02-01 00:00:00',NULL,'248',2336644.50,2336644.50,'248','2019-02-02 09:16:15','248','2019-02-02 09:16:50',10,0),('1','64',77920,'AFTERNOON SHIFT','2019-02-01','2019-02-01 00:00:00',NULL,'248',2748996.00,2748996.00,'248','2019-02-03 13:23:38','248','2019-02-03 13:24:08',10,0),('1','64',78066,'MORNING SHIFT','2019-02-02','2019-02-02 00:00:00',NULL,'248',2027232.00,2027232.00,'248','2019-02-03 13:37:42','248','2019-02-03 13:38:20',10,0),('1','64',78069,'AFTERNOON SHIFT','2019-02-02','2019-02-02 00:00:00',NULL,'248',2096246.00,2096246.00,'248','2019-02-03 13:42:22','248','2019-02-03 13:43:00',10,0),('1','64',78070,'MORNING SHIFT','2019-02-03','2019-02-03 00:00:00',NULL,'248',1737616.00,1737616.00,'248','2019-02-05 10:29:42','248','2019-02-05 10:30:16',10,0),('1','64',78335,'AFTERNOON SHIFT','2019-02-03','2019-02-03 00:00:00',NULL,'248',1737931.00,1737931.00,'248','2019-02-05 11:10:28','248','2019-02-05 11:12:07',10,0),('1','64',78340,'MORNING SHIFT','2019-02-04','2019-02-04 00:00:00',NULL,'248',1882299.00,1882299.00,'248','2019-02-07 09:17:57','248','2019-02-07 09:18:30',10,0),('1','64',78558,'AFTERNOON SHIFT','2019-02-04','2019-02-04 00:00:00',NULL,'248',2658249.50,2658249.50,'248','2019-02-07 09:23:55','248','2019-02-07 09:24:30',10,0),('1','64',78562,'MORNING SHIFT','2019-02-05','2019-02-05 00:00:00',NULL,'248',2035430.50,2035430.50,'248','2019-02-07 09:30:39','248','2019-02-07 09:31:11',10,0),('1','64',78564,'AFTERNOON SHIFT','2019-02-05','2019-02-05 00:00:00',NULL,'248',2504697.50,2504697.50,'248','2019-02-07 09:37:03','248','2019-02-07 09:37:39',10,0),('1','64',78566,'MORNING SHIFT','2019-02-06','2019-02-06 00:00:00',NULL,'248',1978611.50,1978611.50,'248','2019-02-07 09:45:21','248','2019-02-07 09:49:18',10,0),('1','64',78567,'AFTERNOON SHIFT','2019-02-06','2019-02-06 00:00:00',NULL,'248',2279325.50,2279325.50,'248','2019-02-08 10:48:36','248','2019-02-08 10:49:12',10,0),('1','64',78707,'MORNING SHIFT','2019-02-07','2019-02-07 00:00:00',NULL,'248',1874278.00,1874278.00,'248','2019-02-08 10:56:39','248','2019-02-08 10:57:12',10,0),('1','64',78709,'AFTERNOON SHIFT','2019-02-07','2019-02-07 00:00:00',NULL,'248',2491856.00,2491856.00,'248','2019-02-08 11:06:39','248','2019-02-08 11:08:35',10,0),('1','64',78713,'MORNING SHIFT','2019-02-08','2019-02-08 00:00:00',NULL,'248',2002674.50,2002674.50,'248','2019-02-09 13:48:49','248','2019-02-09 13:49:28',10,0),('1','64',78875,'AFTERNOON SHIFT','2019-02-08','2019-02-08 00:00:00',NULL,'248',2649886.00,2649886.00,'248','2019-02-09 13:52:50','248','2019-02-09 13:53:53',10,0),('1','64',78935,'MORNING SHIFT','2019-02-09','2019-02-09 00:00:00',NULL,'248',2134560.00,2134560.00,'248','2019-02-10 09:34:30','248','2019-02-10 09:35:58',10,0),('1','64',78939,'AFTERNOON SHIFT','2019-02-09','2019-02-09 00:00:00',NULL,'248',2382326.20,2382326.20,'248','2019-02-10 09:44:55','248','2019-02-10 09:45:41',10,0),('1','64',78941,'MORNING SHIFT','2019-02-10','2019-02-10 00:00:00',NULL,'248',1901739.30,1901739.30,'248','2019-02-11 08:31:38','248','2019-02-11 08:32:09',10,0),('1','64',79059,'AFTERNOON SHIFT','2019-02-10','2019-02-10 00:00:00',NULL,'248',1791580.20,1791580.20,'248','2019-02-11 09:06:09','248','2019-02-11 09:08:55',10,0),('1','64',79064,'MORNING SHIFT','2019-02-11','2019-02-11 00:00:00',NULL,'248',1814853.30,1814853.30,'248','2019-02-12 10:30:59','248','2019-02-12 10:31:47',10,0),('1','64',79220,'AFTERNOON SHIFT','2019-02-11','2019-02-11 00:00:00',NULL,'248',2372696.90,2372696.90,'248','2019-02-12 10:39:06','248','2019-02-12 10:39:47',10,0),('1','64',79221,'MORNING SHIFT','2019-02-12','2019-02-12 00:00:00',NULL,'248',1878791.90,1878791.90,'248','2019-02-12 18:17:30','248','2019-02-12 18:21:12',10,0),('1','64',79320,'AFTERNOON SHIFT','2019-02-12','2019-02-12 00:00:00',NULL,'248',2172654.80,2172654.80,'248','2019-02-13 10:25:20','248','2019-02-13 10:27:25',10,0),('1','64',79350,'MORNING SHIFT','2019-02-13','2019-02-13 00:00:00',NULL,'248',1736990.30,1736990.30,'248','2019-02-13 14:18:00','248','2019-02-13 14:18:40',10,0),('1','64',79396,'AFTERNOON SHIFT','2019-02-13','2019-02-13 00:00:00',NULL,'248',2390235.10,2390235.10,'248','2019-02-14 09:42:24','248','2019-02-14 09:45:36',10,0),('1','64',79451,'MORNING SHIFT','2019-02-14','2019-02-14 00:00:00',NULL,'248',2091738.60,2091738.60,'248','2019-02-14 15:19:12','248','2019-02-14 15:19:53',10,0),('1','64',79520,'AFTERNOON SHIFT','2019-02-14','2019-02-14 00:00:00',NULL,'248',2475698.70,2475698.70,'248','2019-02-15 11:26:29','248','2019-02-15 11:27:17',10,0),('1','64',79605,'MORNING SHIFT','2019-02-15','2019-02-15 00:00:00',NULL,'248',2141642.30,2141642.30,'248','2019-02-15 15:57:18','248','2019-02-15 15:57:50',10,0),('1','64',79647,'AFTERNOON SHIFT','2019-02-15','2019-02-15 00:00:00',NULL,'248',3139041.40,3139041.40,'248','2019-02-18 10:26:29','248','2019-02-18 10:26:56',10,0),('1','64',79889,'MORNING SHIFT','2019-02-16','2019-02-16 00:00:00',NULL,'248',774015.50,774015.50,'248','2019-02-18 10:29:33','248','2019-02-18 10:30:02',10,0),('1','64',79892,'AFTERNOON SHIFT','2019-02-16','2019-02-16 00:00:00',NULL,'248',1400594.00,1400594.00,'248','2019-02-18 10:32:32','248','2019-02-18 10:33:05',10,0),('1','64',79894,'MORNING SHIFT','2019-02-17','2019-02-17 00:00:00',NULL,'248',1147106.00,1147106.00,'248','2019-02-18 10:36:02','248','2019-02-18 10:36:31',10,0),('1','64',79896,'AFTERNOON SHIFT','2019-02-17','2019-02-17 00:00:00',NULL,'248',1337739.00,1337739.00,'248','2019-02-18 10:39:16','248','2019-02-18 10:39:46',10,0),('1','64',79899,'MORNING SHIFT','2019-02-18','2019-02-18 00:00:00',NULL,'248',1543027.00,1543027.00,'248','2019-02-18 13:58:28','248','2019-02-18 13:59:38',10,0),('1','64',79953,'AFTERNOON SHIFT','2019-02-18','2019-02-18 00:00:00',NULL,'248',2001514.00,2001514.00,'248','2019-02-19 08:52:10','248','2019-02-19 08:54:42',10,0),('1','64',80039,'MORNING SHIFT','2019-02-19','2019-02-19 00:00:00',NULL,'248',1751153.00,1751153.00,'248','2019-02-19 14:54:13','248','2019-02-19 14:54:42',10,0),('1','64',80117,'AFTERNOON SHIFT','2019-02-19','2019-02-19 00:00:00',NULL,'248',1878506.00,1878506.00,'248','2019-02-20 09:12:36','248','2019-02-20 09:13:41',10,0),('1','64',80171,'MORNING SHIFT','2019-02-20','2019-02-20 00:00:00',NULL,'248',1814353.00,1814353.00,'248','2019-02-20 15:26:45','248','2019-02-20 15:28:25',10,0),('1','64',80248,'AFTERNOON SHIFT','2019-02-20','2019-02-20 00:00:00',NULL,'248',2057047.00,2057047.00,'248','2019-02-27 18:39:11','248','2019-02-27 18:39:36',10,0),('1','64',81017,'MORNING SHIFT','2019-02-21','2019-02-21 00:00:00',NULL,'248',1791261.00,1791261.00,'248','2019-02-27 18:42:39','248','2019-02-27 18:44:40',10,0),('1','64',81018,'AFTERNOON SHIFT','2019-02-21','2019-02-21 00:00:00',NULL,'248',2463792.00,2463792.00,'248','2019-02-27 18:47:15','248','2019-02-27 18:47:57',10,0),('1','64',81019,'MORNING SHIFT','2019-02-22','2019-02-22 00:00:00',NULL,'248',2187507.00,2187507.00,'248','2019-02-27 18:50:52','248','2019-02-27 18:51:22',10,0),('1','64',81020,'AFTERNOON SHIFT','2019-02-22','2019-02-22 00:00:00',NULL,'248',2896352.00,2896352.00,'248','2019-02-27 19:08:51','248','2019-02-27 19:09:37',10,0),('1','64',81022,'MORNING SHIFT','2019-02-23','2019-02-23 00:00:00',NULL,'248',0.00,0.00,'248','2019-02-27 19:10:55','248','2019-02-27 19:11:21',10,0),('1','64',81023,'AFTERNOON SHIFT','2019-02-23','2019-02-23 00:00:00',NULL,'248',228931.00,228931.00,'248','2019-02-27 19:13:04','248','2019-02-27 19:13:36',10,0),('1','64',81024,'MORNING SHIFT','2019-02-24','2019-02-24 00:00:00',NULL,'248',1454011.00,1454011.00,'248','2019-02-27 19:16:19','248','2019-02-27 19:17:01',10,0),('1','64',81026,'AFTERNOON SHIFT','2019-02-24','2019-02-24 00:00:00',NULL,'248',1789927.00,1789927.00,'248','2019-02-27 19:19:22','248','2019-02-27 19:19:57',10,0),('1','64',81027,'MORNING SHIFT','2019-02-25','2019-02-25 00:00:00',NULL,'248',1811849.00,1811849.00,'248','2019-02-27 19:24:27','248','2019-02-27 19:24:56',10,0),('1','64',81028,'AFTERNOON SHIFT','2019-02-25','2019-02-25 00:00:00',NULL,'248',2244951.00,2244951.00,'248','2019-02-27 19:58:54','248','2019-02-27 19:59:38',10,0),('1','64',81029,'MORNING SHIFT','2019-02-26','2019-02-26 00:00:00',NULL,'248',1561144.00,1561144.00,'248','2019-02-27 20:02:31','248','2019-02-27 20:03:01',10,0),('1','64',81031,'AFTERNOON SHIFT','2019-02-26','2019-02-26 00:00:00',NULL,'248',1954941.00,1954941.00,'248','2019-02-27 20:05:51','248','2019-02-27 20:06:21',10,0),('1','64',81032,'MORNING SHIFT','2019-02-27','2019-02-27 00:00:00',NULL,'248',1660334.00,1660334.00,'248','2019-02-27 20:08:43','248','2019-02-27 20:09:18',10,0),('1','64',81033,'AFTERNOON SHIFT','2019-02-27','2019-02-27 00:00:00',NULL,'248',1744379.00,1744379.00,'248','2019-02-28 09:11:58','248','2019-02-28 09:12:28',10,0),('1','64',81051,'MORNING SHIFT','2019-02-28','2019-02-28 00:00:00',NULL,'248',1778522.00,1778522.00,'248','2019-02-28 16:24:24','248','2019-02-28 16:25:10',10,0),('1','64',81152,'AFTERNOON SHIFT','2019-02-28','2019-02-28 00:00:00',NULL,'248',1807384.00,1807384.00,'248','2019-03-01 09:20:08','248','2019-03-01 09:21:35',10,0),('1','64',81187,'MORNING SHIFT','2019-03-01','2019-03-01 00:00:00',NULL,'248',1653277.00,1653277.00,'248','2019-03-01 15:41:51','248','2019-03-01 15:42:42',10,0),('1','64',81256,'AFTERNOON SHIFT','2019-03-01','2019-03-01 00:00:00',NULL,'248',2332195.00,2332195.00,'248','2019-03-02 08:31:00','248','2019-03-02 08:33:51',10,0),('1','64',81284,'MORNING SHIFT','2019-03-02','2019-03-02 00:00:00',NULL,'248',1566396.00,1566396.00,'248','2019-03-02 13:13:13','248','2019-03-02 13:13:44',10,0),('1','64',81336,'AFTERNOON SHIFT','2019-03-02','2019-03-02 00:00:00',NULL,'248',2059922.00,2059922.00,'248','2019-03-03 08:26:18','248','2019-03-03 08:27:37',10,0),('1','64',81382,'MORNING SHIFT','2019-03-03','2019-03-03 00:00:00',NULL,'248',1381631.00,1381631.00,'248','2019-03-04 09:49:29','248','2019-03-04 09:49:58',10,0),('1','64',81500,'AFTERNOON SHIFT','2019-03-03','2019-03-03 00:00:00',NULL,'248',1748515.00,1748515.00,'248','2019-03-04 11:36:37','248','2019-03-04 11:40:16',10,0),('1','64',81524,'MORNING SHIFT','2019-03-04','2019-03-04 00:00:00',NULL,'248',1966948.00,1966948.00,'248','2019-03-04 13:23:40','248','2019-03-04 13:25:44',10,0),('1','64',81557,'AFTERNOON SHIFT','2019-03-04','2019-03-04 00:00:00',NULL,'248',2145188.00,2145188.00,'248','2019-03-05 09:22:00','248','2019-03-05 09:22:30',10,0),('1','64',81633,'MORNING SHIFT','2019-03-05','2019-03-05 00:00:00',NULL,'248',1640822.00,1640822.00,'248','2019-03-05 13:52:15','248','2019-03-05 13:52:56',10,0),('1','64',81687,'AFTERNOON SHIFT','2019-03-05','2019-03-05 00:00:00',NULL,'248',2201949.10,2201949.10,'248','2019-03-06 10:24:09','248','2019-03-06 10:33:55',10,0),('1','64',81791,'MORNING SHIFT','2019-03-06','2019-03-06 00:00:00',NULL,'248',1598438.00,1598438.00,'248','2019-03-06 13:23:17','248','2019-03-06 13:23:55',10,0),('1','64',81816,'AFTERNOON SHIFT','2019-03-06','2019-03-06 00:00:00',NULL,'248',2190418.00,2190418.00,'248','2019-03-07 09:02:24','248','2019-03-07 09:02:59',10,0),('1','64',81884,'MORNING SHIFT','2019-03-07','2019-03-07 00:00:00',NULL,'248',1675230.00,1675230.00,'248','2019-03-07 14:00:08','248','2019-03-07 14:00:39',10,0),('1','64',81967,'AFTERNOON SHIFT','2019-03-07','2019-03-07 00:00:00',NULL,'248',1735334.00,1735334.00,'248','2019-03-08 10:12:04','248','2019-03-08 10:12:42',10,0),('1','64',82030,'MORNING SHIFT','2019-03-08','2019-03-08 00:00:00',NULL,'248',1418591.00,1418591.00,'248','2019-03-08 15:48:18','248','2019-03-08 15:49:28',10,0),('1','64',82096,'AFTERNOON SHIFT','2019-03-08','2019-03-08 00:00:00',NULL,'248',1945483.00,1945483.00,'248','2019-03-10 10:57:24','248','2019-03-10 11:02:20',10,0),('1','64',82150,'MORNING SHIFT','2019-03-09','2019-03-09 00:00:00',NULL,'248',0.00,0.00,'248','2019-03-10 11:07:28','248','2019-03-10 11:07:53',10,0),('1','64',82151,'AFTERNOON SHIFT','2019-03-09','2019-03-09 00:00:00',NULL,'248',0.00,0.00,'248','2019-03-10 11:10:11','248','2019-03-10 11:10:43',10,0),('1','64',82152,'MORNING SHIFT','2019-03-10','2019-03-10 00:00:00',NULL,'248',1573125.00,1573125.00,'248','2019-03-13 10:41:13','248','2019-03-13 10:42:48',10,0),('1','64',82499,'AFTERNOON SHIFT','2019-03-10','2019-03-10 00:00:00',NULL,'248',1946117.00,1946117.00,'248','2019-03-13 10:45:23','248','2019-03-13 10:45:51',10,0),('1','64',82500,'MORNING SHIFT','2019-03-11','2019-03-11 00:00:00',NULL,'248',1593387.00,1593387.00,'248','2019-03-13 10:51:31','248','2019-03-13 10:52:51',10,0),('1','64',82502,'AFTERNOON SHIFT','2019-03-11','2019-03-11 00:00:00',NULL,'248',2278550.00,2278550.00,'248','2019-03-13 10:58:42','248','2019-03-13 10:59:09',10,0),('1','64',82503,'MORNING SHIFT','2019-03-12','2019-03-12 00:00:00',NULL,'248',1849278.00,1849278.00,'248','2019-03-13 11:04:04','248','2019-03-13 11:05:47',10,0),('1','64',82507,'AFTERNOON SHIFT','2019-03-12','2019-03-12 00:00:00',NULL,'248',2345964.00,2345964.00,'248','2019-03-13 11:17:19','248','2019-03-13 11:17:52',10,0),('1','64',82510,'MORNING SHIFT','2019-03-13','2019-03-13 00:00:00',NULL,'248',1838775.00,1838775.00,'248','2019-03-14 09:28:37','248','2019-03-14 09:29:16',10,0),('1','64',82616,'AFTERNOON SHIFT','2019-03-13','2019-03-13 00:00:00',NULL,'248',1933646.00,1933646.00,'248','2019-03-14 10:55:17','248','2019-03-14 10:57:09',10,0),('1','64',82633,'MORNING SHIFT','2019-03-14','2019-03-14 00:00:00',NULL,'248',1404641.00,1404641.00,'248','2019-03-14 13:50:55','248','2019-03-14 13:51:29',10,0),('1','64',82667,'AFTERNOON SHIFT','2019-03-14','2019-03-14 00:00:00',NULL,'248',1932645.00,1932645.00,'248','2019-03-15 09:36:31','248','2019-03-15 09:37:19',10,0),('1','64',82745,'MORNING SHIFT','2019-03-15','2019-03-15 00:00:00',NULL,'248',1433852.00,1433852.00,'248','2019-03-16 10:42:41','248','2019-03-16 10:43:13',10,0),('1','64',82865,'AFTERNOON SHIFT','2019-03-15','2019-03-15 00:00:00',NULL,'248',1554771.00,1554771.00,'248','2019-03-16 10:47:14','248','2019-03-16 10:47:56',10,0),('1','64',82866,'MORNING SHIFT','2019-03-16','2019-03-16 00:00:00',NULL,'248',1138137.00,1138137.00,'248','2019-03-17 10:26:29','248','2019-03-17 10:28:17',10,0),('1','64',82965,'AFTERNOON SHIFT','2019-03-16','2019-03-16 00:00:00',NULL,'248',981981.00,981981.00,'248','2019-03-17 12:16:55','248','2019-03-17 12:17:39',10,0),('1','64',82988,'MORNING SHIFT','2019-03-17','2019-03-17 00:00:00',NULL,'248',0.00,0.00,'248','2019-03-18 09:49:34','248','2019-03-18 09:49:55',10,0),('1','64',83089,'AFTERNOON SHIFT','2019-03-17','2019-03-17 00:00:00',NULL,'248',0.00,0.00,'248','2019-03-18 09:58:41','248','2019-03-18 09:59:10',10,0),('1','64',83091,'MORNING SHIFT','2019-03-18','2019-03-18 00:00:00',NULL,'248',33975.00,33975.00,'248','2019-03-18 18:18:32','248','2019-03-18 18:20:50',10,0),('1','64',83170,'AFTERNOON SHIFT','2019-03-18','2019-03-18 00:00:00',NULL,'248',1471364.00,1471364.00,'248','2019-03-19 10:01:03','248','2019-03-19 10:01:31',10,0),('1','64',83204,'MORNING SHIFT','2019-03-19','2019-03-19 00:00:00',NULL,'248',1422833.00,1422833.00,'248','2019-03-20 10:22:59','248','2019-03-20 10:23:57',10,0),('1','64',83335,'AFTERNOON SHIFT','2019-03-19','2019-03-19 00:00:00',NULL,'248',1943640.00,1943640.00,'248','2019-03-20 10:27:07','248','2019-03-20 10:28:01',10,0),('1','64',83336,'MORNING SHIFT','2019-03-20','2019-03-20 00:00:00',NULL,'248',1527653.00,1527653.00,'248','2019-03-20 12:50:47','248','2019-03-20 12:51:25',10,0),('1','64',83367,'AFTERNOON SHIFT','2019-03-20','2019-03-20 00:00:00',NULL,'248',2303131.00,2303131.00,'248','2019-03-21 09:27:17','248','2019-03-21 09:28:03',10,0),('1','64',83458,'MORNING SHIFT','2019-03-21','2019-03-21 00:00:00',NULL,'248',1651298.00,1651298.00,'248','2019-03-21 12:50:41','248','2019-03-21 12:53:27',10,0),('1','64',83498,'AFTERNOON SHIFT','2019-03-21','2019-03-21 00:00:00',NULL,'248',1821378.00,1821378.00,'248','2019-03-22 09:52:10','248','2019-03-22 09:53:26',10,0),('1','64',83585,'MORNING SHIFT','2019-03-22','2019-03-22 00:00:00',NULL,'248',1421824.00,1421824.00,'248','2019-03-22 14:18:56','248','2019-03-22 14:19:27',10,0),('1','64',83652,'AFTERNOON SHIFT','2019-03-22','2019-03-22 00:00:00',NULL,'248',2285375.00,2285375.00,'248','2019-03-23 10:49:34','248','2019-03-23 10:52:57',10,0),('1','64',83718,'MORNING SHIFT','2019-03-23','2019-03-23 00:00:00',NULL,'248',1641526.00,1641526.00,'248','2019-03-23 17:05:08','248','2019-03-23 17:05:45',10,0),('1','64',83762,'AFTERNOON SHIFT','2019-03-23','2019-03-23 00:00:00',NULL,'248',1745727.00,1745727.00,'248','2019-03-25 10:28:14','248','2019-03-25 10:28:54',10,0),('1','64',83887,'MORNING SHIFT','2019-03-24','2019-03-24 00:00:00',NULL,'248',1119628.00,1119628.00,'248','2019-03-25 10:35:15','248','2019-03-25 10:38:12',10,0),('1','64',83890,'AFTERNOON SHIFT','2019-03-24','2019-03-24 00:00:00',NULL,'248',1659676.00,1659676.00,'248','2019-03-25 10:53:10','248','2019-03-25 10:53:46',10,0),('1','64',83896,'MORNING SHIFT','2019-03-25','2019-03-25 00:00:00',NULL,'248',1402972.00,1402972.00,'248','2019-03-25 14:15:35','248','2019-03-25 14:16:33',10,0),('1','64',83952,'AFTERNOON SHIFT','2019-03-25','2019-03-25 00:00:00',NULL,'248',2324233.30,2324233.30,'248','2019-03-26 09:30:37','248','2019-03-26 09:32:14',10,0),('1','64',84035,'MORNING SHIFT','2019-03-26','2019-03-26 00:00:00',NULL,'248',1516314.80,1516314.80,'248','2019-03-27 12:46:03','248','2019-03-27 12:48:36',10,0),('1','64',84215,'AFTERNOON SHIFT','2019-03-26','2019-03-26 00:00:00',NULL,'248',1972679.60,1972679.60,'248','2019-03-27 12:59:30','248','2019-03-27 13:00:44',10,0),('1','64',84218,'MORNING SHIFT','2019-03-27','2019-03-27 00:00:00',NULL,'248',1645046.56,1645046.56,'248','2019-03-27 13:47:04','248','2019-03-27 13:56:13',10,0),('1','64',84248,'AFTERNOON SHIFT','2019-03-27','2019-03-27 00:00:00',NULL,'248',2024579.30,2024579.30,'248','2019-03-28 10:07:45','248','2019-03-28 10:09:17',10,0),('1','64',84329,'MORNING SHIFT','2019-03-28','2019-03-28 00:00:00',NULL,'248',1590088.30,1590088.30,'248','2019-03-29 09:24:32','248','2019-03-29 09:25:10',10,0),('1','64',84444,'AFTERNOON SHIFT','2019-03-28','2019-03-28 00:00:00',NULL,'248',2205255.10,2205255.10,'248','2019-03-29 09:31:55','248','2019-03-29 09:32:31',10,0),('1','64',84446,'MORNING SHIFT','2019-03-29','2019-03-29 00:00:00',NULL,'248',1811262.40,1811262.40,'248','2019-03-29 14:16:13','248','2019-03-29 14:19:00',10,0),('1','64',84500,'AFTERNOON SHIFT','2019-03-29','2019-03-29 00:00:00',NULL,'248',2168990.20,2168990.20,'248','2019-03-30 08:02:58','248','2019-03-30 08:03:36',10,0),('1','64',84560,'MORNING SHIFT','2019-03-30','2019-03-30 00:00:00',NULL,'248',1531809.90,1531809.90,'248','2019-03-31 09:51:17','248','2019-03-31 09:51:50',10,0),('1','64',84682,'AFTERNOON SHIFT','2019-03-30','2019-03-30 00:00:00',NULL,'248',1456321.40,1456321.40,'248','2019-03-31 14:41:38','248','2019-03-31 14:54:09',10,0),('1','64',84733,'MORNING SHIFT','2019-03-31','2019-03-31 00:00:00',NULL,'248',882509.70,882509.70,'248','2019-03-31 14:56:59','248','2019-03-31 14:57:43',10,0),('1','64',84735,'AFTERNOON SHIFT','2019-03-31','2019-03-31 00:00:00',NULL,'248',114150.60,114150.60,'248','2019-04-01 11:55:46','248','2019-04-01 11:56:39',10,0),('1','64',84832,'MORNING SHIFT','2019-04-01','2019-04-01 00:00:00',NULL,'248',246833.50,246833.50,'248','2019-04-02 09:20:31','248','2019-04-02 09:21:06',10,0),('1','64',84920,'AFTERNOON SHIFT','2019-04-01','2019-04-01 00:00:00',NULL,'248',1704570.10,1704570.10,'248','2019-04-02 09:26:37','248','2019-04-02 09:29:22',10,0),('1','64',84924,'MORNING SHIFT','2019-04-02','2019-04-02 00:00:00',NULL,'248',1708892.90,1708892.90,'248','2019-04-03 09:03:47','248','2019-04-03 09:05:50',10,0),('1','64',85035,'AFTERNOON SHIFT','2019-04-02','2019-04-02 00:00:00',NULL,'248',2654922.90,2654922.90,'248','2019-04-03 09:53:45','248','2019-04-03 09:54:18',10,0),('1','64',85046,'MORNING SHIFT','2019-04-03','2019-04-03 00:00:00',NULL,'248',1605220.00,1605220.00,'248','2019-04-04 08:51:44','248','2019-04-04 08:52:14',10,0),('1','64',85150,'AFTERNOON SHIFT','2019-04-03','2019-04-03 00:00:00',NULL,'248',2331575.00,2331575.00,'248','2019-04-04 08:55:06','248','2019-04-04 08:56:45',10,0),('1','64',85151,'MORNING SHIFT','2019-04-04','2019-04-04 00:00:00',NULL,'248',1497885.00,1497885.00,'248','2019-04-04 19:00:04','248','2019-04-04 19:01:24',10,0),('1','64',85245,'AFTERNOON SHIFT','2019-04-04','2019-04-04 00:00:00',NULL,'248',1833424.00,1833424.00,'248','2019-04-05 09:03:31','248','2019-04-05 09:04:09',10,0),('1','64',85272,'MORNING SHIFT','2019-04-05','2019-04-05 00:00:00',NULL,'248',1602387.00,1602387.00,'248','2019-04-05 14:34:54','248','2019-04-05 14:36:26',10,0),('1','64',85335,'AFTERNOON SHIFT','2019-04-05','2019-04-05 00:00:00',NULL,'248',2022513.00,2022513.00,'248','2019-04-06 09:33:06','248','2019-04-06 09:33:41',10,0),('1','64',85403,'MORNING SHIFT','2019-04-06','2019-04-06 00:00:00',NULL,'248',154350.00,154350.00,'248','2019-04-06 09:47:41','248','2019-04-06 09:48:13',10,0),('1','64',85411,'PRICE CHANGE SHIFT','2019-04-06','2019-04-06 00:00:00',NULL,'248',1530430.00,1530430.00,'248','2019-04-06 14:12:11','248','2019-04-06 14:14:49',10,0),('1','64',85462,'AFTERNOON SHIFT','2019-04-06','2019-04-06 00:00:00',NULL,'248',1839156.00,1839156.00,'248','2019-04-07 12:46:09','248','2019-04-07 12:48:14',10,0),('1','64',85551,'MORNING SHIFT','2019-04-07','2019-04-07 00:00:00',NULL,'248',979539.00,979539.00,'248','2019-04-08 09:58:26','248','2019-04-08 10:12:31',10,0),('1','64',85640,'AFTERNOON SHIFT','2019-04-07','2019-04-07 00:00:00',NULL,'248',1513710.00,1513710.00,'248','2019-04-08 10:18:48','248','2019-04-08 10:19:23',10,0),('1','64',85641,'MORNING SHIFT','2019-04-08','2019-04-08 00:00:00',NULL,'248',368027.00,368027.00,'248','2019-04-09 08:25:57','248','2019-04-09 08:26:38',10,0),('1','64',85784,'AFTERNOON SHIFT','2019-04-08','2019-04-08 00:00:00',NULL,'248',1703680.00,1703680.00,'248','2019-04-09 11:40:39','248','2019-04-09 11:41:10',10,0),('1','64',85809,'MORNING SHIFT','2019-04-09','2019-04-09 00:00:00',NULL,'248',1709664.00,1709664.00,'248','2019-04-11 09:40:01','248','2019-04-11 09:41:23',10,0),('1','64',86039,'AFTERNOON SHIFT','2019-04-09','2019-04-09 00:00:00',NULL,'248',2480170.00,2480170.00,'248','2019-04-11 09:44:35','248','2019-04-11 09:45:07',10,0),('1','64',86041,'MORNING SHIFT','2019-04-10','2019-04-10 00:00:00',NULL,'248',1546424.00,1546424.00,'248','2019-04-11 09:47:45','248','2019-04-11 09:48:56',10,0),('1','64',86042,'AFTERNOON SHIFT','2019-04-10','2019-04-10 00:00:00',NULL,'248',2258784.00,2258784.00,'248','2019-04-11 11:51:54','248','2019-04-11 11:53:54',10,0),('1','64',86070,'MORNING SHIFT','2019-04-11','2019-04-11 00:00:00',NULL,'248',1404535.00,1404535.00,'248','2019-04-12 09:37:35','248','2019-04-12 09:42:55',10,0),('1','64',86171,'AFTERNOON SHIFT','2019-04-11','2019-04-11 00:00:00',NULL,'248',1852972.00,1852972.00,'248','2019-04-12 10:28:55','248','2019-04-12 10:29:29',10,0),('1','64',86182,'MORNING SHIFT','2019-04-12','2019-04-12 00:00:00',NULL,'248',2019919.00,2019919.00,'248','2019-04-15 11:46:33','248','2019-04-15 11:47:21',10,0),('1','64',86563,'AFTERNOON SHIFT','2019-04-12','2019-04-12 00:00:00',NULL,'248',1346774.00,1346774.00,'248','2019-04-15 11:51:49','248','2019-04-15 11:52:34',10,0),('1','64',86566,'PRICE CHANGE SHIFT','2019-04-12','2019-04-12 00:00:00',NULL,'248',1126425.00,1126425.00,'248','2019-04-15 12:23:30','248','2019-04-15 12:24:44',10,0),('1','64',86571,'MORNING SHIFT','2019-04-13','2019-04-13 00:00:00',NULL,'248',1892540.00,1892540.00,'248','2019-04-15 12:32:54','248','2019-04-15 12:36:49',10,0),('1','64',86572,'AFTERNOON SHIFT','2019-04-13','2019-04-13 00:00:00',NULL,'248',1775475.00,1775475.00,'248','2019-04-15 13:08:08','248','2019-04-15 13:08:41',10,0),('1','64',86577,'MORNING SHIFT','2019-04-14','2019-04-14 00:00:00',NULL,'248',1460410.00,1460410.00,'248','2019-04-15 13:35:43','248','2019-04-15 13:36:13',10,0),('1','64',86584,'AFTERNOON SHIFT','2019-04-14','2019-04-14 00:00:00',NULL,'248',1015490.00,1015490.00,'248','2019-04-15 13:38:29','248','2019-04-15 13:39:10',10,0),('1','64',86586,'MORNING SHIFT','2019-04-15','2019-04-15 00:00:00',NULL,'248',183480.00,183480.00,'248','2019-04-16 13:58:38','248','2019-04-16 14:00:07',10,0),('1','64',86730,'AFTERNOON SHIFT','2019-04-15','2019-04-15 00:00:00',NULL,'248',200640.00,200640.00,'248','2019-04-16 14:03:31','248','2019-04-16 14:04:23',10,0),('1','64',86732,'MORNING SHIFT','2019-04-16','2019-04-16 00:00:00',NULL,'248',81620.00,81620.00,'248','2019-04-16 14:08:56','248','2019-04-16 14:09:24',10,0),('1','64',86735,'AFTERNOON SHIFT','2019-04-16','2019-04-16 00:00:00',NULL,'248',1003420.00,1003420.00,'248','2019-04-17 09:48:16','248','2019-04-17 09:48:39',10,0),('1','64',86813,'MORNING SHIFT','2019-04-17','2019-04-17 00:00:00',NULL,'248',2590330.00,2590330.00,'248','2019-04-17 15:18:19','248','2019-04-17 15:20:44',10,0),('1','64',86890,'AFTERNOON SHIFT','2019-04-17','2019-04-17 00:00:00',NULL,'248',3490385.00,3490385.00,'248','2019-04-18 11:40:45','248','2019-04-18 11:43:33',10,0),('1','64',86965,'MORNING SHIFT','2019-04-18','2019-04-18 00:00:00',NULL,'248',1130690.00,1130690.00,'248','2019-04-18 14:30:45','248','2019-04-18 15:12:58',10,0),('1','64',87007,'AFTERNOON SHIFT','2019-04-18','2019-04-18 00:00:00',NULL,'248',175620.00,175620.00,'248','2019-04-19 10:03:18','248','2019-04-19 10:07:42',10,0),('1','64',87061,'MORNING SHIFT','2019-04-19','2019-04-19 00:00:00',NULL,'248',52140.00,52140.00,'248','2019-04-20 10:41:56','248','2019-04-20 10:42:24',10,0),('1','64',87178,'AFTERNOON SHIFT','2019-04-19','2019-04-19 00:00:00',NULL,'248',98120.00,98120.00,'248','2019-04-20 10:46:01','248','2019-04-20 10:46:35',10,0),('1','64',87179,'MORNING SHIFT','2019-04-20','2019-04-20 00:00:00',NULL,'248',402160.00,402160.00,'248','2019-04-21 11:02:08','248','2019-04-21 11:02:36',10,0),('1','64',87289,'AFTERNOON SHIFT','2019-04-20','2019-04-20 00:00:00',NULL,'248',971520.00,971520.00,'248','2019-04-21 11:06:19','248','2019-04-21 11:06:55',10,0),('1','64',87290,'MORNING SHIFT','2019-04-21','2019-04-21 00:00:00',NULL,'248',1703660.00,1703660.00,'248','2019-04-23 09:37:03','248','2019-04-23 09:38:33',10,0),('1','64',87553,'AFTERNOON SHIFT','2019-04-21','2019-04-21 00:00:00',NULL,'248',1739970.00,1739970.00,'248','2019-04-23 10:56:29','248','2019-04-23 10:58:45',10,0),('1','64',87555,'MORNING SHIFT','2019-04-22','2019-04-22 00:00:00',NULL,'248',944655.00,944655.00,'248','2019-04-23 11:18:47','248','2019-04-23 11:19:20',10,0),('1','64',87556,'AFTERNOON SHIFT','2019-04-22','2019-04-22 00:00:00',NULL,'248',1862950.00,1862950.00,'248','2019-04-23 11:23:20','248','2019-04-23 11:37:53',10,0),('1','64',87559,'MORNING SHIFT','2019-04-23','2019-04-23 00:00:00',NULL,'248',1998630.00,1998630.00,'248','2019-04-24 09:38:33','248','2019-04-24 09:39:01',10,0),('1','64',87666,'AFTERNOON SHIFT','2019-04-23','2019-04-23 00:00:00',NULL,'248',2630980.00,2630980.00,'248','2019-04-24 10:30:49','248','2019-04-24 10:32:13',10,0),('1','64',87669,'MORNING SHIFT','2019-04-24','2019-04-24 00:00:00',NULL,'248',1663690.00,1663690.00,'248','2019-04-25 10:16:05','248','2019-04-25 10:16:37',10,0),('1','64',87798,'AFTERNOON SHIFT','2019-04-24','2019-04-24 00:00:00',NULL,'248',578115.00,578115.00,'248','2019-04-25 10:20:32','248','2019-04-25 10:23:10',10,0),('1','64',87800,'PRICE CHANGE SHIFT','2019-04-24','2019-04-24 00:00:00',NULL,'248',1310430.00,1310430.00,'248','2019-04-25 10:28:33','248','2019-04-25 10:30:20',10,0),('1','64',87801,'MORNING SHIFT','2019-04-25','2019-04-25 00:00:00',NULL,'248',1319716.75,1319716.75,'248','2019-04-25 14:04:32','248','2019-04-25 14:06:56',10,0),('1','64',87850,'AFTERNOON SHIFT','2019-04-25','2019-04-25 00:00:00',NULL,'248',1977580.00,1977580.00,'248','2019-04-26 10:51:43','248','2019-04-26 10:52:09',10,0),('1','64',87925,'MORNING SHIFT','2019-04-26','2019-04-26 00:00:00',NULL,'248',1637911.00,1637911.00,'248','2019-04-26 15:24:01','248','2019-04-26 15:25:56',10,0),('1','64',87978,'AFTERNOON SHIFT','2019-04-26','2019-04-26 00:00:00',NULL,'248',20460.00,20460.00,'248','2019-04-26 15:44:02','248','2019-04-26 15:44:31',10,0),('1','64',87980,'PRICE CHANGE SHIFT','2019-04-26','2019-04-26 00:00:00',NULL,'248',2318021.00,2318021.00,'248','2019-04-27 16:30:15','248','2019-04-27 16:33:30',10,0),('1','64',88102,'MORNING SHIFT','2019-04-27','2019-04-27 00:00:00',NULL,'248',1622958.00,1622958.00,'248','2019-04-27 16:48:52','248','2019-04-27 16:49:22',10,0),('1','64',88105,'AFTERNOON SHIFT','2019-04-27','2019-04-27 00:00:00',NULL,'248',1969765.00,1969765.00,'248','2019-04-28 13:43:43','248','2019-04-28 14:25:56',10,0),('1','64',88184,'MORNING SHIFT','2019-04-28','2019-04-28 00:00:00',NULL,'248',1251370.00,1251370.00,'248','2019-04-28 14:29:15','248','2019-04-28 14:29:52',10,0),('1','64',88187,'AFTERNOON SHIFT','2019-04-28','2019-04-28 00:00:00',NULL,'248',1514525.00,1514525.00,'248','2019-04-29 14:30:25','248','2019-04-29 14:32:26',10,0),('1','64',88363,'MORNING SHIFT','2019-04-29','2019-04-29 00:00:00',NULL,'248',1489697.00,1489697.00,'248','2019-04-29 14:54:01','248','2019-04-29 14:55:20',10,0),('1','64',88367,'AFTERNOON SHIFT','2019-04-29','2019-04-29 00:00:00',NULL,'248',1801237.00,1801237.00,'248','2019-04-30 10:11:16','248','2019-04-30 10:11:53',10,0),('1','64',88454,'MORNING SHIFT','2019-04-30','2019-04-30 00:00:00',NULL,'248',1440019.00,1440019.00,'248','2019-05-01 15:07:08','248','2019-05-01 15:07:37',10,0),('1','64',88620,'AFTERNOON SHIFT','2019-04-30','2019-04-30 00:00:00',NULL,'248',2373516.50,2373516.50,'248','2019-05-01 15:12:49','248','2019-05-01 15:28:17',10,0),('1','64',88627,'MORNING SHIFT','2019-05-01','2019-05-01 00:00:00',NULL,'248',1596093.20,1596093.20,'248','2019-05-01 15:44:10','248','2019-05-01 15:44:48',10,0),('1','64',88632,'AFTERNOON SHIFT','2019-05-01','2019-05-01 00:00:00',NULL,'248',2162532.80,2162532.80,'248','2019-05-02 12:58:55','248','2019-05-02 13:01:30',10,0),('1','64',88728,'MORNING SHIFT','2019-05-02','2019-05-02 00:00:00',NULL,'248',1712447.80,1712447.80,'248','2019-05-02 13:28:26','248','2019-05-02 13:29:14',10,0),('1','64',88732,'AFTERNOON SHIFT','2019-05-02','2019-05-02 00:00:00',NULL,'248',2635085.10,2635085.10,'248','2019-05-04 14:54:32','248','2019-05-04 14:57:13',10,0),('1','64',89033,'MORNING SHIFT','2019-05-03','2019-05-03 00:00:00',NULL,'248',1684107.70,1684107.70,'248','2019-05-04 22:57:40','248','2019-05-04 22:58:38',10,0),('1','64',89061,'AFTERNOON SHIFT','2019-05-03','2019-05-03 00:00:00',NULL,'248',2415726.20,2415726.20,'248','2019-05-04 23:06:26','248','2019-05-04 23:07:20',10,0),('1','64',89062,'MORNING SHIFT','2019-05-04','2019-05-04 00:00:00',NULL,'248',18450.00,18450.00,'248','2019-05-04 23:10:50','248','2019-05-04 23:11:39',10,0),('1','64',89063,'PRICE CHANGE SHIFT','2019-05-04','2019-05-04 00:00:00',NULL,'248',1620983.70,1620983.70,'248','2019-05-04 23:19:49','248','2019-05-04 23:21:37',10,0),('1','64',89064,'AFTERNOON SHIFT','2019-05-04','2019-05-04 00:00:00',NULL,'248',1986020.20,1986020.20,'248','2019-05-06 10:17:10','248','2019-05-06 10:20:26',10,0),('1','64',89206,'MORNING SHIFT','2019-05-05','2019-05-05 00:00:00',NULL,'248',1156989.00,1156989.00,'248','2019-05-06 10:37:33','248','2019-05-06 10:42:07',10,0),('1','64',89219,'AFTERNOON SHIFT','2019-05-05','2019-05-05 00:00:00',NULL,'248',1270817.30,1270817.30,'248','2019-05-07 13:42:57','248','2019-05-07 13:44:10',10,0),('1','64',89378,'MORNING SHIFT','2019-05-06','2019-05-06 00:00:00',NULL,'248',1036291.50,1036291.50,'248','2019-05-07 13:51:05','248','2019-05-07 13:54:56',10,0),('1','64',89381,'AFTERNOON SHIFT','2019-05-06','2019-05-06 00:00:00',NULL,'248',1979842.60,1979842.60,'248','2019-05-07 14:34:49','248','2019-05-07 14:36:44',10,0),('1','64',89390,'MORNING SHIFT','2019-05-07','2019-05-07 00:00:00',NULL,'248',1190944.80,1190944.80,'248','2019-05-07 15:13:40','248','2019-05-07 15:14:17',10,0),('1','64',89395,'AFTERNOON SHIFT','2019-05-07','2019-05-07 00:00:00',NULL,'248',34040.00,34040.00,'248','2019-05-08 13:58:23','248','2019-05-08 13:58:50',10,0),('1','64',89500,'PRICE CHANGE SHIFT','2019-05-07','2019-05-07 00:00:00',NULL,'248',2081443.50,2081443.50,'248','2019-05-08 14:03:48','248','2019-05-08 14:05:40',10,0),('1','64',89503,'MORNING SHIFT','2019-05-08','2019-05-08 00:00:00',NULL,'248',1493078.40,1493078.40,'248','2019-05-11 13:17:19','248','2019-05-11 13:18:13',10,0),('1','64',89778,'AFTERNOON SHIFT','2019-05-08','2019-05-08 00:00:00',NULL,'248',2021524.60,2021524.60,'248','2019-05-11 13:21:17','248','2019-05-11 13:21:50',10,0),('1','64',89780,'MORNING SHIFT','2019-05-09','2019-05-09 00:00:00',NULL,'248',1259534.80,1259534.80,'248','2019-05-13 08:06:56','248','2019-05-13 08:07:29',10,0),('1','64',90015,'AFTERNOON SHIFT','2019-05-09','2019-05-09 00:00:00',NULL,'248',1937346.00,1937346.00,'248','2019-05-13 08:11:19','248','2019-05-13 08:11:53',10,0),('1','64',90016,'MORNING SHIFT','2019-05-10','2019-05-10 00:00:00',NULL,'248',1730046.00,1730046.00,'248','2019-05-13 08:20:32','248','2019-05-13 08:21:02',10,0),('1','64',90017,'AFTERNOON SHIFT','2019-05-10','2019-05-10 00:00:00',NULL,'248',2107492.00,2107492.00,'248','2019-05-13 08:29:28','248','2019-05-13 08:30:08',10,0),('1','64',90024,'MORNING SHIFT','2019-05-11','2019-05-11 00:00:00',NULL,'248',1533201.50,1533201.50,'248','2019-05-13 09:05:48','248','2019-05-13 09:06:42',10,0),('1','64',90030,'AFTERNOON SHIFT','2019-05-11','2019-05-11 00:00:00',NULL,'248',1974104.40,1974104.40,'248','2019-05-13 09:14:54','248','2019-05-13 09:21:00',10,0),('1','64',90035,'MORNING SHIFT','2019-05-12','2019-05-12 00:00:00',NULL,'248',988544.00,988544.00,'248','2019-05-13 11:36:56','248','2019-05-13 11:37:29',10,0),('1','64',90081,'AFTERNOON SHIFT','2019-05-12','2019-05-12 00:00:00',NULL,'248',1527509.90,1527509.90,'248','2019-05-15 11:04:23','248','2019-05-15 11:04:48',10,0),('1','64',90364,'MORNING SHIFT','2019-05-13','2019-05-13 00:00:00',NULL,'248',1508372.90,1508372.90,'248','2019-05-15 11:07:54','248','2019-05-15 11:08:55',10,0),('1','64',90365,'AFTERNOON SHIFT','2019-05-13','2019-05-13 00:00:00',NULL,'248',2212919.80,2212919.80,'248','2019-05-15 11:11:41','248','2019-05-15 11:12:22',10,0),('1','64',90366,'MORNING SHIFT','2019-05-14','2019-05-14 00:00:00',NULL,'248',1326988.70,1326988.70,'248','2019-05-15 11:22:28','248','2019-05-15 11:23:48',10,0),('1','64',90368,'AFTERNOON SHIFT','2019-05-14','2019-05-14 00:00:00',NULL,'248',1938713.70,1938713.70,'248','2019-05-15 16:14:29','248','2019-05-15 16:15:00',10,0),('1','64',90426,'MORNING SHIFT','2019-05-15','2019-05-15 00:00:00',NULL,'248',1520912.80,1520912.80,'248','2019-05-15 16:18:45','248','2019-05-15 16:19:34',10,0),('1','64',90427,'AFTERNOON SHIFT','2019-05-15','2019-05-15 00:00:00',NULL,'248',1834396.60,1834396.60,'248','2019-05-17 11:55:34','248','2019-05-17 11:56:02',10,0),('1','64',90612,'MORNING SHIFT','2019-05-16','2019-05-16 00:00:00',NULL,'248',1565578.90,1565578.90,'248','2019-05-17 11:59:50','248','2019-05-17 12:00:29',10,0),('1','64',90613,'AFTERNOON SHIFT','2019-05-16','2019-05-16 00:00:00',NULL,'248',2060163.10,2060163.10,'248','2019-05-17 12:03:34','248','2019-05-17 12:04:04',10,0),('1','64',90738,'MORNING SHIFT47','2019-05-17','2019-05-17 00:00:00',NULL,'248',1567385.40,1567385.40,'248','2019-05-18 10:54:22','248','2019-05-18 10:55:26',10,0),('1','64',90742,'AFTERNOON SHIFT','2019-05-17','2019-05-17 00:00:00',NULL,'248',2055985.20,2055985.20,'248','2019-05-18 10:59:59','248','2019-05-18 11:00:37',10,0),('1','64',90745,'MORNING SHIFT','2019-05-18','2019-05-18 00:00:00',NULL,'248',1524923.20,1524923.20,'248','2019-05-18 14:13:18','248','2019-05-18 14:24:02',10,0),('1','64',90783,'AFTERNOON SHIFT','2019-05-18','2019-05-18 00:00:00',NULL,'248',1909831.00,1909831.00,'248','2019-05-19 14:53:02','248','2019-05-19 14:53:30',10,0),('1','64',90891,'MORNING SHIFT','2019-05-19','2019-05-19 00:00:00',NULL,'248',1313886.60,1313886.60,'248','2019-05-20 08:40:21','248','2019-05-20 08:40:55',10,0),('1','64',90939,'AFTERNOON SHIFT','2019-05-19','2019-05-19 00:00:00',NULL,'248',1665766.00,1665766.00,'248','2019-05-20 15:06:55','248','2019-05-20 15:07:40',10,0),('1','64',91042,'MORNING SHIFT','2019-05-20','2019-05-20 00:00:00',NULL,'248',1525256.00,1525256.00,'248','2019-05-20 15:24:02','248','2019-05-20 15:27:05',10,0),('1','64',91045,'AFTERNOON SHIFT','2019-05-20','2019-05-20 00:00:00',NULL,'248',2326888.10,2326888.10,'248','2019-05-21 12:03:32','248','2019-05-21 12:04:00',10,0),('1','64',91134,'MORNING SHIFT','2019-05-21','2019-05-21 00:00:00',NULL,'248',1570472.00,1570472.00,'248','2019-05-21 14:08:10','248','2019-05-21 14:14:05',10,0),('1','64',91167,'AFTERNOON SHIFT','2019-05-21','2019-05-21 00:00:00',NULL,'248',2135181.80,2135181.80,'248','2019-05-22 12:26:58','248','2019-05-22 12:27:33',10,0),('1','64',91261,'MORNING SHIFT','2019-05-22','2019-05-22 00:00:00',NULL,'248',1806529.30,1806529.30,'248','2019-05-24 10:28:51','248','2019-05-24 10:29:36',10,0),('1','64',91482,'AFTERNOON SHIFT','2019-05-22','2019-05-22 00:00:00',NULL,'248',1825190.80,1825190.80,'248','2019-05-25 11:16:08','248','2019-05-25 11:16:42',10,0),('1','64',91598,'MORNING SHIFT','2019-05-23','2019-05-23 00:00:00',NULL,'248',1489328.40,1489328.40,'248','2019-05-25 11:21:19','248','2019-05-25 11:22:03',10,0),('1','64',91600,'AFTERNOON SHIFT','2019-05-23','2019-05-23 00:00:00',NULL,'248',1841793.30,1841793.30,'248','2019-05-25 11:26:59','248','2019-05-25 11:27:36',10,0),('1','64',91601,'MORNING SHIFT','2019-05-24','2019-05-24 00:00:00',NULL,'248',1547665.60,1547665.60,'248','2019-05-25 11:39:14','248','2019-05-25 11:43:07',10,0),('1','64',91605,'AFTERNOON SHIFT','2019-05-24','2019-05-24 00:00:00',NULL,'248',2003280.00,2003280.00,'248','2019-05-25 11:49:43','248','2019-05-25 11:50:41',10,0),('1','64',91606,'MORNING SHIFT','2019-05-25','2019-05-25 00:00:00',NULL,'248',1440466.40,1440466.40,'248','2019-05-25 13:33:05','248','2019-05-25 13:33:34',10,0),('1','64',91630,'AFTERNOON SHIFT','2019-05-25','2019-05-25 00:00:00',NULL,'248',1784737.80,1784737.80,'248','2019-05-27 10:01:27','248','2019-05-27 10:03:49',10,0),('1','64',91807,'MORNING SHIFT','2019-05-26','2019-05-26 00:00:00',NULL,'248',1074185.20,1074185.20,'248','2019-05-27 10:06:28','248','2019-05-27 10:07:02',10,0),('1','64',91809,'AFTERNOON SHIFT','2019-05-26','2019-05-26 00:00:00',NULL,'248',1643005.40,1643005.40,'248','2019-05-27 10:09:55','248','2019-05-27 10:10:24',10,0),('1','64',91810,'MORNING SHIFT','2019-05-27','2019-05-27 00:00:00',NULL,'248',1340075.00,1340075.00,'248','2019-05-27 15:12:38','248','2019-05-27 15:13:05',10,0),('1','64',91892,'AFTERNOON SHIFT','2019-05-27','2019-05-27 00:00:00',NULL,'248',2297442.60,2297442.60,'248','2019-05-28 13:01:32','248','2019-05-28 13:02:11',10,0),('1','64',91990,'MORNING SHIFT','2019-05-28','2019-05-28 00:00:00',NULL,'248',1778642.00,1778642.00,'248','2019-05-29 14:42:48','248','2019-05-29 14:43:26',10,0),('1','64',92116,'AFTERNOON SHIFT','2019-05-28','2019-05-28 00:00:00',NULL,'248',2237991.80,2237991.80,'248','2019-05-30 14:14:06','248','2019-05-30 14:14:36',10,0),('1','64',92229,'MORNING SHIFT','2019-05-29','2019-05-29 00:00:00',NULL,'248',1206046.70,1206046.70,'248','2019-05-30 14:18:01','248','2019-05-30 14:18:30',10,0),('1','64',92231,'AFTERNOON SHIFT','2019-05-29','2019-05-29 00:00:00',NULL,'248',1799044.90,1799044.90,'248','2019-05-30 14:39:07','248','2019-05-30 14:39:40',10,0),('1','64',92243,'MORNING SHIFT','2019-05-30','2019-05-30 00:00:00',NULL,'248',1503953.80,1503953.80,'248','2019-05-30 14:45:06','248','2019-05-30 14:46:00',10,0),('1','64',92244,'AFTERNOON SHIFT','2019-05-30','2019-05-30 00:00:00',NULL,'248',1751578.90,1751578.90,'248','2019-05-31 10:31:10','248','2019-05-31 10:31:40',10,0),('1','64',92307,'MORNING SHIFT','2019-05-31','2019-05-31 00:00:00',NULL,'248',1523748.50,1523748.50,'248','2019-05-31 15:00:37','248','2019-05-31 15:01:15',10,0),('1','64',92355,'AFTERNOON SHIFT','2019-05-31','2019-05-31 00:00:00',NULL,'248',2204746.00,2204746.00,'248','2019-06-06 11:22:32','248','2019-06-06 11:23:13',10,0),('1','64',92841,'MORNING SHIFT','2019-06-01','2019-06-01 00:00:00',NULL,'248',1466137.10,1466137.10,'248','2019-06-06 11:27:07','248','2019-06-06 11:27:40',10,0),('1','64',92842,'AFTERNOON SHIFT','2019-06-01','2019-06-01 00:00:00',NULL,'248',1863347.10,1863347.10,'248','2019-06-06 11:32:13','248','2019-06-06 11:32:44',10,0),('1','64',92843,'MORNING SHIFT','2019-06-02','2019-06-02 00:00:00',NULL,'248',1175712.10,1175712.10,'248','2019-06-06 11:40:53','248','2019-06-06 11:41:56',10,0),('1','64',92844,'AFTERNOON SHIFT','2019-06-02','2019-06-02 00:00:00',NULL,'248',1532361.00,1532361.00,'248','2019-06-06 11:46:44','248','2019-06-06 11:48:50',10,0),('1','64',92847,'MORNING SHIFT','2019-06-03','2019-06-03 00:00:00',NULL,'248',1234396.00,1234396.00,'248','2019-06-06 12:09:14','248','2019-06-06 12:09:51',10,0),('1','64',92852,'AFTERNOON SHIFT','2019-06-03','2019-06-03 00:00:00',NULL,'248',2134601.00,2134601.00,'248','2019-06-11 17:28:12','248','2019-06-11 17:28:54',10,0),('1','64',93639,'MORNING SHIFT','2019-06-04','2019-06-04 00:00:00',NULL,'248',1129660.20,1129660.20,'248','2019-06-11 17:34:01','248','2019-06-11 17:35:03',10,0),('1','64',93640,'AFTERNOON SHIFT','2019-06-04','2019-06-04 00:00:00',NULL,'248',1058403.60,1058403.60,'248','2019-06-11 17:39:15','248','2019-06-11 17:39:53',10,0),('1','64',93641,'MORNING SHIFT','2019-06-05','2019-06-05 00:00:00',NULL,'248',231896.80,231896.80,'248','2019-06-11 17:44:37','248','2019-06-11 17:46:00',10,0),('1','64',93643,'AFTERNOON SHIFT','2019-06-05','2019-06-05 00:00:00',NULL,'248',10660.60,10660.60,'248','2019-06-11 17:48:17','248','2019-06-11 17:48:54',10,0),('1','64',93644,'MORNING SHIFT','2019-06-06','2019-06-06 00:00:00',NULL,'248',82048.90,82048.90,'248','2019-06-11 17:50:59','248','2019-06-11 17:51:33',10,0),('1','64',93645,'AFTERNOON SHIFT','2019-06-06','2019-06-06 00:00:00',NULL,'248',5931.60,5931.60,'248','2019-06-11 17:53:25','248','2019-06-11 17:54:07',10,0),('1','64',93646,'MORNING SHIFT','2019-06-07','2019-06-07 00:00:00',NULL,'248',1293840.50,1293840.50,'248','2019-06-11 17:57:57','248','2019-06-11 18:00:12',10,0),('1','64',93647,'AFTERNOON SHIFT','2019-06-07','2019-06-07 00:00:00',NULL,'248',1626770.60,1626770.60,'248','2019-06-11 18:09:22','248','2019-06-11 18:10:08',10,0),('1','64',93650,'MORNING SHIFT','2019-06-08','2019-06-08 00:00:00',NULL,'248',1123086.50,1123086.50,'248','2019-06-11 18:19:13','248','2019-06-11 18:20:02',10,0),('1','64',93651,'AFTERNOON SHIFT','2019-06-08','2019-06-08 00:00:00',NULL,'248',254135.80,254135.80,'248','2019-06-11 18:29:04','248','2019-06-11 18:32:04',10,0),('1','64',93652,'MORNING SHIFT','2019-06-09','2019-06-09 00:00:00',NULL,'248',23675.00,23675.00,'248','2019-06-11 18:35:17','248','2019-06-11 18:36:05',10,0),('1','64',93653,'AFTERNOON SHIFT','2019-06-09','2019-06-09 00:00:00',NULL,'248',3381.00,3381.00,'248','2019-06-11 18:43:39','248','2019-06-11 18:44:16',10,0),('1','64',93654,'MORNING SHIFT','2019-06-10','2019-06-10 00:00:00',NULL,'248',96300.00,96300.00,'248','2019-06-11 18:48:48','248','2019-06-11 18:49:25',10,0),('1','64',93655,'AFTERNOON SHIFT','2019-06-10','2019-06-10 00:00:00',NULL,'248',1254024.60,1254024.60,'248','2019-06-13 12:48:31','248','2019-06-13 12:49:04',10,0),('1','64',93871,'MORNING SHIFT','2019-06-11','2019-06-11 00:00:00',NULL,'248',1349553.00,1349553.00,'248','2019-06-13 12:51:56','248','2019-06-13 12:53:06',10,0),('1','64',93872,'AFTERNOON SHIFT','2019-06-11','2019-06-11 00:00:00',NULL,'248',2015081.80,2015081.80,'248','2019-06-13 12:56:38','248','2019-06-13 12:57:18',10,0),('1','64',93873,'MORNING SHIFT','2019-06-12','2019-06-12 00:00:00',NULL,'248',1168358.00,1168358.00,'248','2019-06-13 13:00:54','248','2019-06-13 13:02:14',10,0),('1','64',93876,'AFTERNOON SHIFT','2019-06-12','2019-06-12 00:00:00',NULL,'248',1022254.40,1022254.40,'248','2019-06-13 13:06:49','248','2019-06-13 13:07:29',10,0),('1','64',93878,'MORNING SHIFT','2019-06-13','2019-06-13 00:00:00',NULL,'248',1070456.20,1070456.20,'248','2019-06-14 09:19:51','248','2019-06-14 09:21:08',10,0),('1','64',93969,'AFTERNOON SHIFT','2019-06-13','2019-06-13 00:00:00',NULL,'248',1134955.70,1134955.70,'248','2019-06-14 09:30:22','248','2019-06-14 09:30:59',10,0),('1','64',93971,'MORNING SHIFT','2019-06-14','2019-06-14 00:00:00',NULL,'248',1508918.70,1508918.70,'248','2019-06-16 13:24:32','248','2019-06-16 13:25:35',10,0),('1','64',94243,'AFTERNOON SHIFT','2019-06-14','2019-06-14 00:00:00',NULL,'248',2263689.60,2263689.60,'248','2019-06-16 13:30:35','248','2019-06-16 13:31:49',10,0),('1','64',94245,'MORNING SHIFT','2019-06-15','2019-06-15 00:00:00',NULL,'248',154125.00,154125.00,'248','2019-06-16 13:37:16','248','2019-06-16 13:37:47',10,0),('1','64',94246,'PRICE CHANGE SHIFT','2019-06-15','2019-06-15 00:00:00',NULL,'248',1142660.70,1142660.70,'248','2019-06-16 13:42:05','248','2019-06-16 13:43:14',10,0),('1','64',94249,'AFTERNOON SHIFT','2019-06-15','2019-06-15 00:00:00',NULL,'248',1846866.50,1846866.50,'248','2019-06-16 14:19:38','248','2019-06-16 14:21:18',10,0),('1','64',94255,'MORNING SHIFT','2019-06-16','2019-06-16 00:00:00',NULL,'248',1168041.70,1168041.70,'248','2019-06-16 14:48:49','248','2019-06-16 14:49:36',10,0),('1','64',94264,'AFTERNOON SHIFT','2019-06-16','2019-06-16 00:00:00',NULL,'248',1572727.60,1572727.60,'248','2019-06-17 08:50:35','248','2019-06-17 08:51:09',10,0),('1','64',94308,'MORNING SHIFT','2019-06-17','2019-06-17 00:00:00',NULL,'248',1621544.60,1621544.60,'248','2019-06-18 13:41:04','248','2019-06-18 13:43:22',10,0),('1','64',94510,'AFTERNOON SHIFT','2019-06-17','2019-06-17 00:00:00',NULL,'248',1955713.50,1955713.50,'248','2019-06-18 13:48:06','248','2019-06-18 13:49:49',10,0),('1','64',94512,'MORNING SHIFT','2019-06-18','2019-06-18 00:00:00',NULL,'248',1438267.80,1438267.80,'248','2019-06-20 08:41:33','248','2019-06-20 08:42:11',10,0),('1','64',94702,'AFTERNOON SHIFT','2019-06-18','2019-06-18 00:00:00',NULL,'248',1837215.80,1837215.80,'248','2019-06-20 08:45:32','248','2019-06-20 08:46:18',10,0),('1','64',94705,'MORNING SHIFT','2019-06-19','2019-06-19 00:00:00',NULL,'248',1305167.10,1305167.10,'248','2019-06-20 08:49:40','248','2019-06-20 08:50:24',10,0),('1','64',94707,'AFTERNOON SHIFT','2019-06-19','2019-06-19 00:00:00',NULL,'248',1919989.40,1919989.40,'248','2019-06-20 08:53:54','248','2019-06-20 09:12:15',10,0),('1','64',94711,'MORNING SHIFT','2019-06-20','2019-06-20 00:00:00',NULL,'248',1332060.00,1332060.00,'248','2019-06-21 08:21:35','248','2019-06-21 08:26:17',10,0),('1','64',94803,'AFTERNOON SHIFT','2019-06-20','2019-06-20 00:00:00',NULL,'248',1835252.20,1835252.20,'248','2019-06-21 14:37:39','248','2019-06-21 14:38:24',10,0),('1','64',94872,'MORNING SHIFT','2019-06-21','2019-06-21 00:00:00',NULL,'248',1443548.30,1443548.30,'248','2019-06-21 14:44:08','248','2019-06-21 14:52:20',10,0),('1','64',94880,'AFTERNOON SHIFT','2019-06-21','2019-06-21 00:00:00',NULL,'248',2119991.80,2119991.80,'248','2019-06-23 08:07:40','248','2019-06-23 08:08:08',10,0),('1','64',95044,'MORNING SHIFT','2019-06-22','2019-06-22 00:00:00',NULL,'248',1488862.10,1488862.10,'248','2019-06-23 08:12:14','248','2019-06-23 08:12:47',10,0),('1','64',95045,'AFTERNOON SHIFT','2019-06-22','2019-06-22 00:00:00',NULL,'248',1702417.80,1702417.80,'248','2019-06-23 15:43:04','248','2019-06-23 15:46:31',10,0),('1','64',95103,'MORNING SHIFT','2019-06-23','2019-06-23 00:00:00',NULL,'248',1220546.30,1220546.30,'248','2019-06-23 15:53:51','248','2019-06-23 15:55:31',10,0),('1','64',95108,'AFTERNOON SHIFT','2019-06-23','2019-06-23 00:00:00',NULL,'248',1338921.70,1338921.70,'248','2019-07-04 15:23:23','248','2019-07-04 15:24:43',10,0),('1','64',96357,'MORNING SHIFT','2019-06-24','2019-06-24 00:00:00',NULL,'248',888657.00,888657.00,'248','2019-07-04 15:28:16','248','2019-07-04 15:28:59',10,0),('1','64',96359,'AFTERNOON SHIFT','2019-06-24','2019-06-24 00:00:00',NULL,'248',1879327.60,1879327.60,'248','2019-07-04 15:33:45','248','2019-07-08 08:11:10',10,0),('1','64',96657,'MORNING SHIFT','2019-06-25','2019-06-25 00:00:00',NULL,'248',1359620.90,1359620.90,'248','2019-07-08 08:18:05','248','2019-07-08 08:19:15',10,0),('1','64',96660,'AFTERNOON SHIFT','2019-06-25','2019-06-25 00:00:00',NULL,'248',2000571.40,2000571.40,'248','2019-07-08 08:24:22','248','2019-07-08 08:25:00',10,0),('1','64',96662,'MORNING SHIFT','2019-06-26','2019-06-26 00:00:00',NULL,'248',1214175.80,1214175.80,'248','2019-07-08 08:29:01','248','2019-07-08 08:29:42',10,0),('1','64',96663,'AFTERNOON SHIFT','2019-06-26','2019-06-26 00:00:00',NULL,'248',1414478.50,1414478.50,'248','2019-07-08 08:32:38','248','2019-07-08 08:33:14',10,0),('1','64',96664,'MORNING SHIFT','2019-06-27','2019-06-27 00:00:00',NULL,'248',1368042.50,1368042.50,'248','2019-07-08 08:36:50','248','2019-07-08 08:37:37',10,0),('1','64',96665,'AFTERNOON SHIFT','2019-06-27','2019-06-27 00:00:00',NULL,'248',1859521.40,1859521.40,'248','2019-07-08 08:41:36','248','2019-07-08 08:42:18',10,0),('1','64',96667,'MORNING SHIFT','2019-06-28','2019-06-28 00:00:00',NULL,'248',1394173.70,1394173.70,'248','2019-07-08 08:47:09','248','2019-07-08 08:47:57',10,0),('1','64',96668,'AFTERNOON SHIFT','2019-06-28','2019-06-28 00:00:00',NULL,'248',1940173.80,1940173.80,'248','2019-07-08 10:06:26','248','2019-07-08 10:07:00',10,0),('1','64',96676,'MORNING SHIFT','2019-06-29','2019-06-29 00:00:00',NULL,'248',1189506.90,1189506.90,'248','2019-07-08 10:39:44','248','2019-07-08 10:40:39',10,0),('1','64',96681,'AFTERNOON SHIFT','2019-06-29','2019-06-29 00:00:00',NULL,'248',1858506.90,1858506.90,'248','2019-07-08 10:44:22','248','2019-07-08 10:46:11',10,0),('1','64',96685,'MORNING SHIFT','2019-06-30','2019-06-30 00:00:00',NULL,'248',1146410.70,1146410.70,'248','2019-07-08 10:54:03','248','2019-07-08 10:54:55',10,0),('1','64',96690,'AFTERNOON SHIFT','2019-06-30','2019-06-30 00:00:00',NULL,'248',1820174.50,1820174.50,'248','2019-07-08 11:04:45','248','2019-07-08 11:05:31',10,0),('1','64',96695,'MORNING SHIFT','2019-07-01','2019-07-01 00:00:00',NULL,'248',1148784.70,1148784.70,'248','2019-07-08 11:09:49','248','2019-07-08 11:10:29',10,0),('1','64',96697,'AFTERNOON SHIFT','2019-07-01','2019-07-01 00:00:00',NULL,'248',1666506.20,1666506.20,'248','2019-07-08 11:17:40','248','2019-07-08 11:18:34',10,0),('1','64',96701,'MORNING SHIFT','2019-07-02','2019-07-02 00:00:00',NULL,'248',1209426.60,1209426.60,'248','2019-07-10 09:06:02','248','2019-07-10 09:06:48',10,0),('1','64',96921,'AFTERNOON SHIFT','2019-07-02','2019-07-02 00:00:00',NULL,'248',2020864.40,2020864.40,'248','2019-07-10 09:09:15','248','2019-07-10 09:09:51',10,0),('1','64',96922,'MORNING SHIFT','2019-07-03','2019-07-03 00:00:00',NULL,'248',1346263.30,1346263.30,'248','2019-07-10 09:33:20','248','2019-07-10 09:35:49',10,0),('1','64',96925,'AFTERNOON SHIFT','2019-07-03','2019-07-03 00:00:00',NULL,'248',1878899.20,1878899.20,'248','2019-07-10 10:02:24','248','2019-07-10 10:03:10',10,0),('1','64',96932,'MORNING SHIFT','2019-07-04','2019-07-04 00:00:00',NULL,'248',1543485.50,1543485.50,'248','2019-07-12 09:43:02','248','2019-07-12 09:45:16',10,0),('1','64',97303,'AFTERNOON SHIFT','2019-07-04','2019-07-04 00:00:00',NULL,'248',2004953.10,2004953.10,'248','2019-07-12 09:52:32','248','2019-07-12 10:08:31',10,0),('1','64',97307,'MORNING SHIFT','2019-07-05','2019-07-05 00:00:00',NULL,'248',1067697.20,1067697.20,'248','2019-07-12 10:18:00','248','2019-07-12 10:34:00',10,0),('1','64',97498,'AFTERNOON SHIFT','2019-07-05','2019-07-05 00:00:00',NULL,'248',1689359.50,1689359.50,'248','2019-07-13 12:10:43','248','2019-07-13 12:11:21',10,0),('1','64',97501,'MORNING SHIFT','2019-07-06','2019-07-06 00:00:00',NULL,'248',1164168.60,1164168.60,'248','2019-07-13 12:25:25','248','2019-07-13 12:26:25',10,0),('1','64',97505,'AFTERNOON SHIFT','2019-07-06','2019-07-06 00:00:00',NULL,'248',1738643.60,1738643.60,'248','2019-07-13 12:32:00','248','2019-07-13 12:33:18',10,0),('1','64',97506,'MORNING SHIFT','2019-07-07','2019-07-07 00:00:00',NULL,'248',850351.60,850351.60,'248','2019-07-15 11:33:54','248','2019-07-15 11:34:30',10,0),('1','64',97742,'AFTERNOON SHIFT','2019-07-07','2019-07-07 00:00:00',NULL,'248',1394043.20,1394043.20,'248','2019-07-15 11:41:47','248','2019-07-15 11:43:32',10,0),('1','64',97744,'MORNING SHIFT','2019-07-08','2019-07-08 00:00:00',NULL,'248',1375641.20,1375641.20,'248','2019-07-15 12:48:58','248','2019-07-15 12:49:41',10,0),('1','64',97750,'AFTERNOON SHIFT','2019-07-08','2019-07-08 00:00:00',NULL,'248',1763175.80,1763175.80,'248','2019-07-15 12:52:55','248','2019-07-15 12:53:39',10,0),('1','64',97752,'MORNING SHIFT','2019-07-09','2019-07-09 00:00:00',NULL,'248',1197765.30,1197765.30,'248','2019-07-15 12:59:38','248','2019-07-15 13:01:11',10,0),('1','64',97756,'AFTERNOON SHIFT','2019-07-09','2019-07-09 00:00:00',NULL,'248',1563885.50,1563885.50,'248','2019-07-15 13:42:54','248','2019-07-15 13:44:54',10,0),('1','64',97766,'MORNING SHIFT','2019-07-10','2019-07-10 00:00:00',NULL,'248',1348886.70,1348886.70,'248','2019-07-15 13:52:27','248','2019-07-15 13:53:19',10,0),('1','64',97770,'AFTERNOON SHIFT','2019-07-10','2019-07-10 00:00:00',NULL,'248',1667437.50,1667437.50,'248','2019-07-15 15:29:55','248','2019-07-15 15:30:34',10,0),('1','64',97794,'MORNING SHIFT','2019-07-11','2019-07-11 00:00:00',NULL,'248',164780.00,164780.00,'248','2019-07-15 15:34:08','248','2019-07-15 15:35:27',10,0),('1','64',97973,'PRICE CHANGE SHIFT','2019-07-11','2019-07-11 00:00:00',NULL,'248',921159.70,921159.70,'248','2019-07-17 10:16:05','248','2019-07-17 10:17:50',10,0),('1','64',97975,'AFTERNOON SHIFT','2019-07-11','2019-07-11 00:00:00',NULL,'248',1651370.20,1651370.20,'248','2019-07-17 10:23:43','248','2019-07-17 10:24:48',10,0),('1','64',97976,'MORNING SHIFT','2019-07-12','2019-07-12 00:00:00',NULL,'248',1384795.20,1384795.20,'248','2019-07-17 10:28:09','248','2019-07-17 10:30:06',10,0),('1','64',97977,'AFTERNOON SHIFT','2019-07-12','2019-07-12 00:00:00',NULL,'248',1936515.00,1936515.00,'248','2019-07-17 10:39:33','248','2019-07-17 10:40:10',10,0),('1','64',97980,'MORNING SHIFT','2019-07-13','2019-07-13 00:00:00',NULL,'248',1300729.20,1300729.20,'248','2019-07-17 10:43:41','248','2019-07-17 10:44:24',10,0),('1','64',97981,'AFTERNOON SHIFT','2019-07-13','2019-07-13 00:00:00',NULL,'248',1988807.50,1988807.50,'248','2019-07-17 10:47:20','248','2019-07-17 10:47:58',10,0),('1','64',97983,'MORNING SHIFT','2019-07-14','2019-07-14 00:00:00',NULL,'248',1014138.30,1014138.30,'248','2019-07-19 10:32:27','248','2019-07-19 10:32:58',10,0),('1','64',98531,'AFTERNOON SHIFT','2019-07-14','2019-07-14 00:00:00',NULL,'248',1578752.90,1578752.90,'248','2019-07-21 13:03:42','248','2019-07-21 13:04:17',10,0),('1','64',98885,'MORNING SHIFT','2019-07-15','2019-07-15 00:00:00',NULL,'248',1244442.80,1244442.80,'248','2019-07-21 13:08:06','248','2019-07-21 13:09:06',10,0),('1','64',98886,'MORNING SHIFT','2019-07-15','2019-07-15 00:00:00',NULL,'248',2130615.50,2130615.50,'248','2019-07-21 13:13:02','248','2019-07-21 13:20:29',10,0),('1','64',98891,'MORNING SHIFT','2019-07-16','2019-07-16 00:00:00',NULL,'248',1536890.70,1536890.70,'248','2019-07-21 13:27:42','248','2019-07-21 13:29:43',10,0),('1','64',98892,'AFTERNOON SHIFT','2019-07-16','2019-07-16 00:00:00',NULL,'248',2094505.70,2094505.70,'248','2019-07-21 13:32:48','248','2019-07-21 13:33:31',10,0),('1','64',98895,'MORNING SHIFT','2019-07-17','2019-07-17 00:00:00',NULL,'248',1361403.60,1361403.60,'248','2019-07-21 13:40:02','248','2019-07-21 13:40:48',10,0),('1','64',98898,'AFTERNOON SHIFT','2019-07-17','2019-07-17 00:00:00',NULL,'248',1929901.70,1929901.70,'248','2019-07-21 13:58:33','248','2019-07-21 14:00:02',10,0),('1','64',98905,'MORNING SHIFT','2019-07-18','2019-07-18 00:00:00',NULL,'248',1481944.30,1481944.30,'248','2019-07-21 14:08:30','248','2019-07-21 14:09:40',10,0),('1','64',98909,'AFTERNOON SHIFT','2019-07-18','2019-07-18 00:00:00',NULL,'248',1886075.00,1886075.00,'248','2019-07-21 14:14:09','248','2019-07-21 14:15:18',10,0),('1','64',98910,'MORNING SHIFT','2019-07-19','2019-07-19 00:00:00',NULL,'248',1220668.90,1220668.90,'248','2019-07-21 14:21:24','248','2019-07-21 14:22:04',10,0),('1','64',98914,'AFTERNOON SHIFT','2019-07-19','2019-07-19 00:00:00',NULL,'248',2289574.00,2289574.00,'248','2019-07-21 14:30:54','248','2019-07-21 14:31:43',10,0),('1','64',98916,'MORNING SHIFT','2019-07-20','2019-07-20 00:00:00',NULL,'248',1298346.10,1298346.10,'248','2019-07-21 15:53:03','248','2019-07-21 15:55:44',10,0),('1','64',98931,'AFTERNOON SHIFT','2019-07-20','2019-07-20 00:00:00',NULL,'248',2108238.30,2108238.30,'248','2019-07-21 16:04:22','248','2019-07-21 16:06:01',10,0),('1','64',98937,'MORNING SHIFT','2019-07-21','2019-07-21 00:00:00',NULL,'248',1108613.70,1108613.70,'248','2019-07-21 16:23:57','248','2019-07-21 16:26:34',10,0),('1','64',98943,'AFTERNOON SHIFT','2019-07-21','2019-07-21 00:00:00',NULL,'248',1544792.60,1544792.60,'248','2019-07-22 11:18:13','248','2019-07-22 11:18:50',10,0),('1','64',99025,'MORNING SHIFT','2019-07-22','2019-07-22 00:00:00',NULL,'248',1391013.80,1391013.80,'248','2019-07-23 11:01:39','248','2019-07-23 11:02:12',10,0),('1','64',99136,'AFTERNOON SHIFT','2019-07-22','2019-07-22 00:00:00',NULL,'248',2016292.40,2016292.40,'248','2019-07-23 11:06:14','248','2019-07-23 11:06:59',10,0),('1','64',99137,'MORNING SHIFT','2019-07-23','2019-07-23 00:00:00',NULL,'248',1436972.50,1436972.50,'248','2019-07-24 10:05:06','248','2019-07-24 10:05:52',10,0),('1','64',99268,'AFTERNOON SHIFT','2019-07-23','2019-07-23 00:00:00',NULL,'248',1997868.80,1997868.80,'248','2019-07-24 10:10:15','248','2019-07-24 10:10:59',10,0),('1','64',99269,'MORNING SHIFT','2019-07-24','2019-07-24 00:00:00',NULL,'248',1285377.90,1285377.90,'248','2019-07-27 12:02:32','248','2019-07-27 12:03:44',10,0),('1','64',99651,'AFTERNOON SHIFT','2019-07-24','2019-07-24 00:00:00',NULL,'248',2040250.80,2040250.80,'248','2019-07-27 12:19:48','248','2019-07-27 12:21:04',10,0),('1','64',99657,'MORNING SHIFT','2019-07-25','2019-07-25 00:00:00',NULL,'248',1271446.20,1271446.20,'248','2019-07-27 12:39:07','248','2019-07-27 12:39:37',10,0),('1','64',99664,'AFTERNOON SHIFT','2019-07-25','2019-07-25 00:00:00',NULL,'248',1666431.80,1666431.80,'248','2019-07-30 14:37:50','248','2019-07-30 14:38:35',10,0),('1','64',100087,'MORNING SHIFT','2019-07-26','2019-07-26 00:00:00',NULL,'248',967746.70,967746.70,'248','2019-07-30 14:41:00','248','2019-07-30 14:41:33',10,0),('1','64',100089,'AFTERNOON SHIFT','2019-07-26','2019-07-26 00:00:00',NULL,'248',1717149.80,1717149.80,'248','2019-07-30 14:44:47','248','2019-07-30 14:45:18',10,0),('1','64',100092,'MORNING SHIFT','2019-07-27','2019-07-27 00:00:00',NULL,'248',1103482.30,1103482.30,'248','2019-07-30 14:48:39','248','2019-07-30 14:49:23',10,0),('1','64',100093,'AFTERNOON SHIFT','2019-07-27','2019-07-27 00:00:00',NULL,'248',1656051.00,1656051.00,'248','2019-07-30 14:52:12','248','2019-07-30 14:52:44',10,0),('1','64',100094,'MORNING SHIFT','2019-07-28','2019-07-28 00:00:00',NULL,'248',670671.80,670671.80,'248','2019-07-30 15:02:32','248','2019-07-30 15:03:41',10,0),('1','64',100095,'AFTERNOON SHIFT','2019-07-28','2019-07-28 00:00:00',NULL,'248',1287615.10,1287615.10,'248','2019-07-30 15:06:58','248','2019-07-30 15:07:40',10,0),('1','64',100096,'MORNING SHIFT','2019-07-29','2019-07-29 00:00:00',NULL,'248',1096498.70,1096498.70,'248','2019-07-30 15:14:55','248','2019-07-30 15:15:47',10,0),('1','64',100097,'AFTERNOON SHIFT','2019-07-29','2019-07-29 00:00:00',NULL,'248',1815699.30,1815699.30,'248','2019-07-30 15:19:17','248','2019-07-30 15:20:11',10,0),('1','64',100098,'MORNING SHIFT','2019-07-30','2019-07-30 00:00:00',NULL,'248',994518.50,994518.50,'248','2019-07-30 15:22:45','248','2019-07-30 15:23:35',10,0),('1','64',100099,'AFTERNOON SHIFT','2019-07-30','2019-07-30 00:00:00',NULL,'248',1343814.00,1343814.00,'248','2019-08-01 12:13:28','248','2019-08-01 12:15:48',10,0),('1','64',100292,'MORNING SHIFT','2019-07-31','2019-07-31 00:00:00',NULL,'248',1437265.00,1437265.00,'248','2019-08-01 12:24:52','248','2019-08-01 12:25:28',10,0),('1','64',100295,'AFTERNOON SHIFT','2019-07-31','2019-07-31 00:00:00',NULL,'248',1749060.00,1749060.00,'248','2019-08-01 12:29:57','248','2019-08-01 12:30:27',10,0),('1','64',100297,'MORNING SHIFT','2019-08-01','2019-08-01 00:00:00',NULL,'248',1148675.00,1148675.00,'248','2019-08-01 16:54:19','248','2019-08-01 16:54:53',10,0),('1','64',100383,'AFTERNOON SHIFT','2019-08-01','2019-08-01 00:00:00',NULL,'248',1583830.00,1583830.00,'248','2019-08-02 11:08:12','248','2019-08-02 11:09:34',10,0),('1','64',100384,'MORNING SHIFT','2019-08-02','2019-08-02 00:00:00',NULL,'248',1089868.00,1089868.00,'248','2019-08-04 10:03:03','248','2019-08-04 10:03:41',10,0),('1','64',100578,'AFTERNOON SHIFT','2019-08-02','2019-08-02 00:00:00',NULL,'248',1871337.00,1871337.00,'248','2019-08-05 13:34:25','248','2019-08-05 13:38:06',10,0),('1','64',100837,'MORNING SHIFT','2019-08-03','2019-08-03 00:00:00',NULL,'248',1133218.00,1133218.00,'248','2019-08-06 12:58:18','248','2019-08-06 12:59:22',10,0),('1','64',100843,'AFTERNOON SHIFT','2019-08-03','2019-08-03 00:00:00',NULL,'248',1783072.00,1783072.00,'248','2019-08-06 13:06:51','248','2019-08-06 13:09:14',10,0),('1','64',100847,'MORNING SHIFT','2019-08-04','2019-08-04 00:00:00',NULL,'248',1098296.00,1098296.00,'248','2019-08-06 13:39:17','248','2019-08-06 13:40:05',10,0),('1','64',100857,'AFTERNOON SHIFT','2019-08-04','2019-08-04 00:00:00',NULL,'248',890214.00,890214.00,'248','2019-08-06 13:44:23','248','2019-08-06 13:46:11',10,0),('1','64',100859,'MORNING SHIFT','2019-08-05','2019-08-05 00:00:00',NULL,'248',260365.00,260365.00,'248','2019-08-06 13:51:05','248','2019-08-06 13:52:16',10,0),('1','64',100861,'AFTERNOON SHIFT','2019-08-05','2019-08-05 00:00:00',NULL,'248',149855.00,149855.00,'248','2019-08-06 13:58:18','248','2019-08-06 13:59:09',10,0),('1','64',100864,'MORNING SHIFT','2019-08-06','2019-08-06 00:00:00',NULL,'248',1057159.00,1057159.00,'248','2019-08-06 14:35:32','248','2019-08-06 17:14:09',10,0),('1','64',100921,'AFTERNOON SHIFT','2019-08-06','2019-08-06 00:00:00',NULL,'248',1516204.00,1516204.00,'248','2019-08-08 12:50:35','248','2019-08-08 12:51:04',10,0),('1','64',101121,'MORNING SHIFT','2019-08-07','2019-08-07 00:00:00',NULL,'248',1070477.00,1070477.00,'248','2019-08-08 12:58:12','248','2019-08-08 12:58:45',10,0),('1','64',101122,'AFTERNOON SHIFT','2019-08-07','2019-08-07 00:00:00',NULL,'248',1821015.00,1821015.00,'248','2019-08-08 13:09:19','248','2019-08-08 13:09:52',10,0),('1','64',101129,'MORNING SHIFT','2019-08-08','2019-08-08 00:00:00',NULL,'248',1203683.00,1203683.00,'248','2019-08-21 15:10:13','248','2019-08-21 15:11:01',10,0),('1','64',102752,'AFTERNOON SHIFT','2019-08-08','2019-08-08 00:00:00',NULL,'248',1710667.00,1710667.00,'248','2019-08-21 15:13:43','248','2019-08-21 15:14:26',10,0),('1','64',102755,'MORNING SHIFT','2019-08-09','2019-08-09 00:00:00',NULL,'248',1203748.00,1203748.00,'248','2019-08-21 15:23:21','248','2019-08-21 15:23:58',10,0),('1','64',102761,'AFTERNOON SHIFT','2019-08-09','2019-08-09 00:00:00',NULL,'248',2242268.00,2242268.00,'248','2019-08-21 15:41:48','248','2019-08-21 15:42:20',10,0),('1','64',102763,'MORNING SHIFT','2019-08-10','2019-08-10 00:00:00',NULL,'248',1184081.00,1184081.00,'248','2019-08-21 19:29:17','248','2019-08-21 19:29:54',10,0),('1','64',102788,'AFTERNOON SHIFT','2019-08-10','2019-08-10 00:00:00',NULL,'248',1824393.00,1824393.00,'248','2019-08-21 19:33:12','248','2019-08-21 19:33:44',10,0),('1','64',102789,'MORNING SHIFT','2019-08-11','2019-08-11 00:00:00',NULL,'248',1011115.00,1011115.00,'248','2019-08-21 19:42:22','248','2019-08-21 19:43:23',10,0),('1','64',102790,'AFTERNOON SHIFT','2019-08-11','2019-08-11 00:00:00',NULL,'248',1265721.00,1265721.00,'248','2019-08-21 20:33:42','248','2019-08-21 20:35:26',10,0),('1','64',102791,'MORNING SHIFT','2019-08-12','2019-08-12 00:00:00',NULL,'248',1335782.00,1335782.00,'248','2019-08-21 20:40:18','248','2019-08-21 20:42:16',10,0),('1','64',102792,'AFTERNOON SHIFT','2019-08-12','2019-08-12 00:00:00',NULL,'248',1439599.00,1439599.00,'248','2019-08-21 20:45:23','248','2019-08-21 20:46:46',10,0),('1','64',102793,'MORNING SHIFT','2019-08-13','2019-08-13 00:00:00',NULL,'248',926089.00,926089.00,'248','2019-08-23 15:26:15','248','2019-08-23 15:27:59',10,0),('1','64',103008,'AFTERNOON SHIFT','2019-08-13','2019-08-13 00:00:00',NULL,'248',1666391.00,1666391.00,'248','2019-08-23 15:35:41','248','2019-08-23 15:36:13',10,0),('1','64',103010,'MORNING SHIFT','2019-08-14','2019-08-14 00:00:00',NULL,'248',1180562.00,1180562.00,'248','2019-08-23 15:43:19','248','2019-08-23 15:44:38',10,0),('1','64',103013,'AFTERNOON SHIFT','2019-08-14','2019-08-14 00:00:00',NULL,'248',2018789.00,2018789.00,'248','2019-08-23 15:48:51','248','2019-08-23 15:49:30',10,0),('1','64',103014,'MORNING SHIFT','2019-08-15','2019-08-15 00:00:00',NULL,'248',1180323.00,1180323.00,'248','2019-08-23 15:56:25','248','2019-08-23 15:57:07',10,0),('1','64',103018,'AFTERNOON SHIFT','2019-08-15','2019-08-15 00:00:00',NULL,'248',1875668.00,1875668.00,'248','2019-08-25 11:38:12','248','2019-08-25 11:38:41',10,0),('1','64',103183,'MORNING SHIFT','2019-08-16','2019-08-16 00:00:00',NULL,'248',1450299.00,1450299.00,'248','2019-08-25 11:45:22','248','2019-08-25 11:46:15',10,0),('1','64',103184,'AFTERNOON SHIFT','2019-08-16','2019-08-16 00:00:00',NULL,'248',1918788.00,1918788.00,'248','2019-08-25 11:53:11','248','2019-08-25 11:53:51',10,0),('1','64',103185,'MORNING SHIFT','2019-08-17','2019-08-17 00:00:00',NULL,'248',1427247.00,1427247.00,'248','2019-08-25 12:02:39','248','2019-08-25 12:03:22',10,0),('1','64',103187,'AFTERNOON SHIFT1','2019-08-17','2019-08-17 00:00:00',NULL,'248',1783748.00,1783748.00,'248','2019-08-25 12:18:27','248','2019-08-25 12:19:31',10,0),('1','64',103191,'MORNING SHIFT','2019-08-18','2019-08-18 00:00:00',NULL,'248',905782.00,905782.00,'248','2019-08-25 12:28:23','248','2019-08-25 12:29:02',10,0),('1','64',103192,'AFTERNOON SHIFT','2019-08-18','2019-08-18 00:00:00',NULL,'248',1542023.00,1542023.00,'248','2019-08-25 13:32:54','248','2019-08-25 13:33:24',10,0),('1','64',103205,'MORNING SHIFT','2019-08-19','2019-08-19 00:00:00',NULL,'248',1334692.00,1334692.00,'248','2019-08-25 13:37:19','248','2019-08-25 13:37:47',10,0),('1','64',103208,'AFTERNOON SHIFT','2019-08-19','2019-08-19 00:00:00',NULL,'248',1489155.00,1489155.00,'248','2019-08-25 13:40:47','248','2019-08-25 13:41:28',10,0),('1','64',103209,'MORNING SHIFT','2019-08-20','2019-08-20 00:00:00',NULL,'248',1290278.00,1290278.00,'248','2019-08-25 13:45:01','248','2019-08-25 13:45:35',10,0),('1','64',103210,'AFTERNOON SHIFT','2019-08-20','2019-08-20 00:00:00',NULL,'248',1998299.00,1998299.00,'248','2019-08-25 13:48:26','248','2019-08-25 13:49:01',10,0),('1','64',103211,'MORNING SHIFT','2019-08-21','2019-08-21 00:00:00',NULL,'248',1119447.00,1119447.00,'248','2019-08-26 09:29:18','248','2019-08-26 09:31:01',10,0),('1','64',103282,'AFTERNOON SHIFT','2019-08-21','2019-08-21 00:00:00',NULL,'248',1603762.00,1603762.00,'248','2019-08-26 09:36:35','248','2019-08-26 09:39:12',10,0),('1','64',103283,'MORNING SHIFT','2019-08-22','2019-08-22 00:00:00',NULL,'248',1084203.00,1084203.00,'248','2019-08-26 09:42:46','248','2019-08-26 09:43:21',10,0),('1','64',103284,'AFTERNOON SHIFT','2019-08-22','2019-08-22 00:00:00',NULL,'248',1658324.00,1658324.00,'248','2019-08-26 11:58:21','248','2019-08-26 11:59:03',10,0),('1','64',103312,'MORNING SHIFT','2019-08-23','2019-08-23 00:00:00',NULL,'248',1178064.00,1178064.00,'248','2019-08-26 12:19:43','248','2019-08-26 12:20:13',10,0),('1','64',103317,'AFTERNOON SHIFT','2019-08-23','2019-08-23 00:00:00',NULL,'248',1882642.00,1882642.00,'248','2019-08-26 12:22:57','248','2019-08-26 12:23:36',10,0),('1','64',103318,'MORNING SHIFT','2019-08-24','2019-08-24 00:00:00',NULL,'248',1027416.00,1027416.00,'248','2019-08-26 12:34:51','248','2019-08-26 12:35:38',10,0),('1','64',103323,'AFTERNOON SHIFT','2019-08-24','2019-08-24 00:00:00',NULL,'248',1596847.00,1596847.00,'248','2019-08-26 12:56:29','248','2019-08-26 12:57:05',10,0),('1','64',103328,'MORNING SHIFT','2019-08-25','2019-08-25 00:00:00',NULL,'248',848683.00,848683.00,'248','2019-08-26 13:01:19','248','2019-08-26 13:01:57',10,0),('1','64',103329,'AFTERNOON SHIFT','2019-08-25','2019-08-25 00:00:00',NULL,'248',1210016.00,1210016.00,'248','2019-08-26 13:04:58','248','2019-08-26 13:07:49',10,0),('1','64',103332,'MORNING SHIFT','2019-08-26','2019-08-26 00:00:00',NULL,'248',1116781.00,1116781.00,'248','2019-08-26 15:08:52','248','2019-08-26 15:09:45',10,0),('1','64',103363,'AFTERNOON SHIFT','2019-08-26','2019-08-26 00:00:00',NULL,'248',1777907.00,1777907.00,'248','2019-08-27 11:28:41','248','2019-08-27 11:29:12',10,0),('1','64',103449,'MORNING SHIFT','2019-08-27','2019-08-27 00:00:00',NULL,'248',1143451.00,1143451.00,'248','2019-08-29 10:46:47','248','2019-08-29 10:47:20',10,0),('1','64',103743,'AFTERNOON SHIFT','2019-08-27','2019-08-27 00:00:00',NULL,'248',1646897.00,1646897.00,'248','2019-08-29 10:50:13','248','2019-08-29 10:50:43',10,0),('1','64',103745,'MORNING SHIFT','2019-08-28','2019-08-28 00:00:00',NULL,'248',1022480.95,1022480.95,'248','2019-08-29 11:02:06','248','2019-08-29 11:02:53',10,0),('1','64',103753,'AFTERNOON SHIFT','2019-08-28','2019-08-28 00:00:00',NULL,'248',1730342.00,1730342.00,'248','2019-08-30 11:24:34','248','2019-08-30 11:26:33',10,0),('1','64',103883,'MORNING SHIFT','2019-08-29','2019-08-29 00:00:00',NULL,'248',904327.00,904327.00,'248','2019-08-30 11:31:06','248','2019-08-30 11:31:45',10,0),('1','64',103885,'AFTERNOON SHIFT','2019-08-29','2019-08-29 00:00:00',NULL,'248',1667270.00,1667270.00,'248','2019-08-30 11:39:44','248','2019-08-30 11:40:47',10,0),('1','64',103888,'MORNING SHIFT','2019-08-30','2019-08-30 00:00:00',NULL,'248',1090177.00,1090177.00,'248','2019-09-01 12:29:21','248','2019-09-01 12:30:46',10,0),('1','64',104134,'AFTERNOON SHIFT','2019-08-30','2019-08-30 00:00:00',NULL,'248',1661517.00,1661517.00,'248','2019-09-01 12:34:42','248','2019-09-01 12:35:13',10,0),('1','64',104141,'MORNING SHIFT','2019-08-31','2019-08-31 00:00:00',NULL,'248',957000.00,957000.00,'248','2019-09-01 12:49:00','248','2019-09-01 12:49:31',10,0),('1','64',104142,'AFTERNOON SHIFT','2019-08-31','2019-08-31 00:00:00',NULL,'248',1673890.00,1673890.00,'248','2019-09-01 13:03:10','248','2019-09-01 13:03:43',10,0),('1','64',104146,'MORNING SHIFT','2019-09-01','2019-09-01 00:00:00',NULL,'248',918860.00,918860.00,'248','2019-09-05 09:45:00','248','2019-09-05 09:45:41',10,0),('1','64',104603,'AFTERNOON SHIFT','2019-09-01','2019-09-01 00:00:00',NULL,'248',1189300.00,1189300.00,'248','2019-09-05 10:09:14','248','2019-09-05 10:10:00',10,0),('1','64',104607,'MORNING SHIFT','2019-09-02','2019-09-02 00:00:00',NULL,'248',908170.00,908170.00,'248','2019-09-05 10:41:22','248','2019-09-05 10:42:01',10,0),('1','64',104610,'AFTERNOON SHIFT','2019-09-02','2019-09-02 00:00:00',NULL,'248',1784670.00,1784670.00,'248','2019-09-09 11:48:23','248','2019-09-09 12:06:48',10,0),('1','64',105097,'MORNING SHIFT','2019-09-03','2019-09-03 00:00:00',NULL,'248',1056159.00,1036875.00,'248','2019-09-09 12:10:59','248','2019-09-09 12:11:44',10,0),('1','64',105099,'AFTERNOON SHIFT','2019-09-03','2019-09-03 00:00:00',NULL,'248',1536547.00,1508935.00,'248','2019-09-10 10:31:36','248','2019-09-10 10:33:02',10,0),('1','64',105224,'MORNING SHIFT','2019-09-04','2019-09-04 00:00:00',NULL,'248',1194874.00,1173415.00,'248','2019-09-10 11:13:17','248','2019-09-10 11:14:25',10,0),('1','64',105230,'AFTERNOON SHIFT','2019-09-04','2019-09-04 00:00:00',NULL,'248',1673286.00,1641270.00,'248','2019-09-10 11:17:39','248','2019-09-10 11:20:19',10,0),('1','64',105234,'MORNING SHIFT','2019-09-05','2019-09-05 00:00:00',NULL,'248',1280192.00,1260560.00,'248','2019-09-11 11:58:59','248','2019-09-11 11:59:30',10,0),('1','64',105374,'AFTERNOON SHIFT','2019-09-05','2019-09-05 00:00:00',NULL,'248',1611064.00,1580620.00,'248','2019-09-11 12:02:21','248','2019-09-11 12:02:51',10,0),('1','64',105375,'MORNING SHIFT','2019-09-06','2019-09-06 00:00:00',NULL,'248',1173534.00,1151955.00,'248','2019-09-11 12:05:48','248','2019-09-11 12:06:43',10,0),('1','64',105377,'AFTERNOON SHIFT','2019-09-06','2019-09-06 00:00:00',NULL,'248',1802045.00,1802045.00,'248','2019-09-11 12:12:22','248','2019-09-11 12:12:57',10,0),('1','64',105380,'MORNING SHIFT','2019-09-07','2019-09-07 00:00:00',NULL,'248',1259960.00,1259960.00,'248','2019-09-11 12:18:20','248','2019-09-11 12:18:56',10,0),('1','64',105382,'AFTERNOON SHIFT','2019-09-07','2019-09-07 00:00:00',NULL,'248',1881305.00,1881305.00,'248','2019-09-11 12:31:40','248','2019-09-11 12:32:09',10,0),('1','64',105386,'MORNING SHIFT','2019-09-08','2019-09-08 00:00:00',NULL,'248',974535.00,974535.00,'248','2019-09-11 12:37:41','248','2019-09-11 12:38:21',10,0),('1','64',105387,'AFTERNOON SHIFT','2019-09-08','2019-09-08 00:00:00',NULL,'248',1637055.00,1637055.00,'248','2019-09-11 12:41:12','248','2019-09-11 12:41:44',10,0),('1','64',105389,'MORNING SHIFT','2019-09-09','2019-09-09 00:00:00',NULL,'248',1278035.00,1278035.00,'248','2019-09-11 12:45:11','248','2019-09-11 12:45:48',10,0),('1','64',105390,'AFTERNOON SHIFT','2019-09-09','2019-09-09 00:00:00',NULL,'248',1795190.00,1795190.00,'248','2019-09-16 14:56:30','248','2019-09-16 14:57:07',10,0),('1','64',106049,'MORNING SHIFT','2019-09-10','2019-09-10 00:00:00',NULL,'248',1251115.00,1251115.00,'248','2019-09-16 15:04:12','248','2019-09-16 15:07:15',10,0),('1','64',106056,'AFTERNOON SHIFT','2019-09-10','2019-09-10 00:00:00',NULL,'248',1939025.00,1939025.00,'248','2019-09-16 15:42:20','248','2019-09-16 15:42:58',10,0),('1','64',106068,'MORNING SHIFT','2019-09-11','2019-09-11 00:00:00',NULL,'248',1057055.00,1057055.00,'248','2019-09-16 16:12:29','248','2019-09-16 16:13:19',10,0),('1','64',106078,'AFTERNOON SHIFT','2019-09-11','2019-09-11 00:00:00',NULL,'248',1807755.00,1807755.00,'248','2019-09-16 16:16:23','248','2019-09-16 16:17:00',10,0),('1','64',106080,'MORNING SHIFT','2019-09-12','2019-09-12 00:00:00',NULL,'248',1496390.00,1496390.00,'248','2019-09-17 09:40:55','248','2019-09-17 09:41:42',10,0),('1','64',106134,'AFTERNOON SHIFT','2019-09-12','2019-09-12 00:00:00',NULL,'248',2022130.00,2022130.00,'248','2019-09-17 09:45:06','248','2019-09-17 09:45:37',10,0),('1','64',106135,'MORNING SHIFT','2019-09-13','2019-09-13 00:00:00',NULL,'248',1384155.00,1384155.00,'248','2019-09-17 09:49:29','248','2019-09-17 09:54:36',10,0),('1','64',106137,'AFTERNOON SHIFT','2019-09-13','2019-09-13 00:00:00',NULL,'248',2289940.00,2289940.00,'248','2019-09-17 09:57:03','248','2019-09-17 09:57:36',10,0),('1','64',106138,'MORNING SHIFT','2019-09-14','2019-09-14 00:00:00',NULL,'248',1327115.00,1327115.00,'248','2019-09-18 09:09:43','248','2019-09-18 09:10:30',10,0),('1','64',106269,'AFTERNOON SHIFT','2019-09-14','2019-09-14 00:00:00',NULL,'248',2220455.00,2220455.00,'248','2019-09-18 09:13:51','248','2019-09-18 09:14:28',10,0),('1','64',106271,'MORNING SHIFT','2019-09-15','2019-09-15 00:00:00',NULL,'248',1136755.00,1136755.00,'248','2019-09-18 09:19:20','248','2019-09-18 09:20:18',10,0),('1','64',106272,'AFTERNOON SHIFT','2019-09-15','2019-09-15 00:00:00',NULL,'248',1428415.00,1428415.00,'248','2019-09-21 13:13:49','248','2019-09-21 13:14:18',10,0),('1','64',106795,'MORNING SHIFT','2019-09-16','2019-09-16 00:00:00',NULL,'248',1333090.00,1333090.00,'248','2019-09-21 13:18:18','248','2019-09-21 13:18:56',10,0),('1','64',106798,'AFTERNOON SHIFT','2019-09-16','2019-09-16 00:00:00',NULL,'248',1867695.00,1867695.00,'248','2019-09-21 13:28:00','248','2019-09-21 13:29:14',10,0),('1','64',106799,'MORNING SHIFT','2019-09-17','2019-09-17 00:00:00',NULL,'248',1462775.00,1462775.00,'248','2019-09-21 13:34:22','248','2019-09-21 13:34:56',10,0),('1','64',106801,'AFTERNOON SHIFT','2019-09-17','2019-09-17 00:00:00',NULL,'248',2122370.00,2122370.00,'248','2019-09-21 14:27:48','248','2019-09-21 14:28:27',10,0),('1','64',106960,'MORNING SHIFT','2019-09-18','2019-09-18 00:00:00',NULL,'248',1197700.00,1197700.00,'248','2019-09-23 07:54:08','248','2019-09-23 07:54:46',10,0),('1','64',106963,'AFTERNOON SHIFT','2019-09-18','2019-09-18 00:00:00',NULL,'248',2028390.00,2028390.00,'248','2019-09-23 07:59:40','248','2019-09-23 08:00:27',10,0),('1','64',106965,'MORNING SHIFT','2019-09-19','2019-09-19 00:00:00',NULL,'248',1444170.00,1444170.00,'248','2019-09-23 08:04:01','248','2019-09-23 08:04:51',10,0),('1','64',106966,'AFTERNOON SHIFT','2019-09-19','2019-09-19 00:00:00',NULL,'248',1947190.00,1947190.00,'248','2019-09-23 08:09:03','248','2019-09-23 08:09:48',10,0),('1','64',106968,'MORNING SHIFT','2019-09-20','2019-09-20 00:00:00',NULL,'248',1571290.00,1571290.00,'248','2019-09-23 08:16:02','248','2019-09-23 08:16:53',10,0),('1','64',106971,'AFTERNOON SHIFT','2019-09-20','2019-09-20 00:00:00',NULL,'248',2468550.00,2468550.00,'248','2019-09-23 08:20:03','248','2019-09-23 08:27:38',10,0),('1','64',106974,'MORNING SHIFT','2019-09-21','2019-09-21 00:00:00',NULL,'248',1313760.00,1313760.00,'248','2019-09-23 09:13:15','248','2019-09-23 09:14:01',10,0),('1','64',106990,'AFTERNOON SHIFT','2019-09-21','2019-09-21 00:00:00',NULL,'248',2193870.00,2193870.00,'248','2019-09-23 09:18:03','248','2019-09-23 09:18:54',10,0),('1','64',106993,'MORNING SHIFT','2019-09-22','2019-09-22 00:00:00',NULL,'248',1287370.00,1287370.00,'248','2019-09-23 09:24:01','248','2019-09-23 09:24:56',10,0),('1','64',106997,'AFTERNOON SHIFT','2019-09-22','2019-09-22 00:00:00',NULL,'248',1791090.00,1791090.00,'248','2019-09-23 10:10:33','248','2019-09-23 10:11:06',10,0),('1','64',107011,'MORNING SHIFT','2019-09-23','2019-09-23 00:00:00',NULL,'248',1485610.00,1485610.00,'248','2019-09-24 09:49:34','248','2019-09-24 09:50:47',10,0),('1','64',107157,'AFTERNOON SHIFT','2019-09-23','2019-09-23 00:00:00',NULL,'248',68320.00,68320.00,'248','2019-09-24 09:57:36','248','2019-09-24 09:59:10',10,0),('1','64',107159,'PRICE CHANGE SHIFT','2019-09-23','2019-09-23 00:00:00',NULL,'248',1868746.00,1868746.00,'248','2019-09-24 10:13:06','248','2019-09-24 10:14:56',10,0),('1','64',107162,'MORNING SHIFT','2019-09-24','2019-09-24 00:00:00',NULL,'248',1742612.00,1742612.00,'248','2019-09-27 14:56:07','248','2019-09-27 14:57:05',10,0),('1','64',107647,'AFTERNOON SHIFT','2019-09-24','2019-09-24 00:00:00',NULL,'248',1470.00,1470.00,'248','2019-09-27 15:08:09','248','2019-09-27 15:09:06',10,0),('1','64',107651,'PRICE CHANGE SHIFT','2019-09-24','2019-09-24 00:00:00',NULL,'248',2157623.00,2157623.00,'248','2019-09-27 15:27:54','248','2019-09-27 15:28:59',10,0),('1','64',107660,'MORNING SHIFT','2019-09-25','2019-09-25 00:00:00',NULL,'248',1258824.00,1258824.00,'248','2019-09-27 15:59:33','248','2019-09-27 16:00:57',10,0),('1','64',107664,'AFTERNOON SHIFT','2019-09-25','2019-09-25 00:00:00',NULL,'248',1905039.00,1905039.00,'248','2019-09-27 17:07:11','248','2019-09-27 17:08:15',10,0),('1','64',107679,'MORNING SHIFT','2019-09-26','2019-09-26 00:00:00',NULL,'248',1254242.00,1254242.00,'248','2019-09-28 09:45:21','248','2019-09-28 09:45:59',10,0),('1','64',107700,'AFTERNOON SHIFT','2019-09-26','2019-09-26 00:00:00',NULL,'248',1866868.00,1866868.00,'248','2019-09-28 09:52:45','248','2019-09-28 09:53:31',10,0),('1','64',107703,'MORNING SHIFT','2019-09-27','2019-09-27 00:00:00',NULL,'248',1281124.00,1281124.00,'248','2019-09-28 09:57:30','248','2019-09-28 09:58:05',10,0),('1','64',107704,'AFTERNOON SHIFT','2019-09-27','2019-09-27 00:00:00',NULL,'248',1906792.00,1906792.00,'248','2019-09-28 10:08:12','248','2019-09-28 10:08:55',10,0),('1','64',107705,'MORNING SHIFT','2019-09-28','2019-09-28 00:00:00',NULL,'248',1246694.00,1246694.00,'248','2019-09-28 13:40:20','248','2019-09-28 13:44:35',10,0),('1','64',107768,'AFTERNOON SHIFT','2019-09-28','2019-09-28 00:00:00',NULL,'248',1633568.00,1633568.00,'248','2019-09-30 07:52:54','248','2019-09-30 07:53:31',10,0),('1','64',107945,'MORNING SHIFT','2019-09-29','2019-09-29 00:00:00',NULL,'248',1230013.00,1230013.00,'248','2019-09-30 07:56:42','248','2019-09-30 07:57:14',10,0),('1','64',107946,'AFTERNOON SHIFT','2019-09-29','2019-09-29 00:00:00',NULL,'248',1850022.00,1850022.00,'248','2019-09-30 13:36:24','248','2019-09-30 13:36:51',10,0),('1','64',108011,'MORNING SHIFT','2019-09-30','2019-09-30 00:00:00',NULL,'248',1414363.00,1414363.00,'248','2019-09-30 19:48:32','248','2019-09-30 19:49:08',10,0),('1','64',108074,'AFTERNOON SHIFT','2019-09-30','2019-09-30 00:00:00',NULL,'248',2174850.00,2174850.00,'248','2019-10-02 10:31:40','248','2019-10-02 10:32:26',10,0),('1','64',108215,'MORNING SHIFT','2019-10-01','2019-10-01 00:00:00',NULL,'248',1235012.00,1235012.00,'248','2019-10-02 10:39:11','248','2019-10-02 10:39:53',10,0),('1','64',108218,'AFTERNOON SHIFT','2019-10-01','2019-10-01 00:00:00',NULL,'248',1695288.00,1695288.00,'248','2019-10-02 10:49:07','248','2019-10-02 10:49:45',10,0),('1','64',108223,'MORNING SHIFT','2019-10-02','2019-10-02 00:00:00',NULL,'248',1229417.30,1229417.30,'248','2019-10-06 12:02:36','248','2019-10-06 12:07:25',10,0),('1','64',108751,'AFTERNOON SHIFT','2019-10-02','2019-10-02 00:00:00',NULL,'248',1953884.00,1953884.00,'248','2019-10-06 12:25:01','248','2019-10-06 12:25:40',10,0),('1','64',108753,'MORNING SHIFT','2019-10-03','2019-10-03 00:00:00',NULL,'248',1180882.00,1180882.00,'248','2019-10-06 12:29:54','248','2019-10-06 12:30:29',10,0),('1','64',108754,'AFTERNOON SHIFT','2019-10-03','2019-10-03 00:00:00',NULL,'248',1724870.00,1724870.00,'248','2019-10-06 12:32:49','248','2019-10-06 12:33:23',10,0),('1','64',108756,'MORNING SHIFT','2019-10-04','2019-10-04 00:00:00',NULL,'248',1218927.00,1218927.00,'248','2019-10-06 13:05:08','248','2019-10-06 13:05:55',10,0),('1','64',108764,'AFTERNOON SHIFT','2019-10-04','2019-10-04 00:00:00',NULL,'248',2008471.00,2008471.00,'248','2019-10-06 13:14:36','248','2019-10-06 13:15:26',10,0),('1','64',108766,'MORNING SHIFT','2019-10-05','2019-10-05 00:00:00',NULL,'248',1292446.00,1292446.00,'248','2019-10-06 13:20:16','248','2019-10-06 13:21:24',10,0),('1','64',108767,'AFTERNOON SHIFT','2019-10-05','2019-10-05 00:00:00',NULL,'248',1851718.30,1851718.30,'248','2019-10-06 13:26:58','248','2019-10-06 13:28:57',10,0),('1','64',108772,'MORNING SHIFT','2019-10-06','2019-10-06 00:00:00',NULL,'248',1259721.80,1259721.80,'248','2019-10-08 09:17:50','248','2019-10-08 09:18:43',10,0),('1','64',108981,'AFTERNOON SHIFT','2019-10-06','2019-10-06 00:00:00',NULL,'248',1631770.00,1631770.00,'248','2019-10-08 09:21:42','248','2019-10-08 09:22:23',10,0),('1','64',108988,'MORNING SHIFT','2019-10-07','2019-10-07 00:00:00',NULL,'248',1317622.00,1317622.00,'248','2019-10-08 09:40:50','248','2019-10-08 09:42:37',10,0),('1','64',108996,'AFTERNOON SHIFT','2019-10-07','2019-10-07 00:00:00',NULL,'248',2225678.50,2225678.50,'248','2019-10-08 09:47:11','248','2019-10-08 09:48:24',10,0),('1','64',109001,'MORNING SHIFT','2019-10-08','2019-10-08 00:00:00',NULL,'248',1154753.10,1154753.10,'248','2019-10-10 08:30:17','248','2019-10-10 08:31:02',10,0),('1','64',109269,'AFTERNOON SHIFT','2019-10-08','2019-10-08 00:00:00',NULL,'248',2096178.80,2096178.80,'248','2019-10-10 08:34:15','248','2019-10-10 08:35:14',10,0),('1','64',109270,'MORNING SHIFT','2019-10-09','2019-10-09 00:00:00',NULL,'248',1465547.30,1465547.30,'248','2019-10-10 08:43:59','248','2019-10-10 08:44:33',10,0),('1','64',109272,'AFTERNOON SHIFT','2019-10-09','2019-10-09 00:00:00',NULL,'248',1745296.70,1745296.70,'248','2019-10-11 08:55:32','248','2019-10-11 08:56:12',10,0),('1','64',109402,'MORNING SHIFT','2019-10-10','2019-10-10 00:00:00',NULL,'248',1241414.90,1241414.90,'248','2019-10-11 09:00:07','248','2019-10-11 09:01:04',10,0),('1','64',109404,'AFTERNOON SHIFT','2019-10-10','2019-10-10 00:00:00',NULL,'248',2174333.70,2174333.70,'248','2019-10-14 09:43:31','248','2019-10-14 09:44:04',10,0),('1','64',109760,'MORNING SHIFT','2019-10-11','2019-10-11 00:00:00',NULL,'248',1270540.40,1270540.40,'248','2019-10-14 09:48:03','248','2019-10-14 09:48:37',10,0),('1','64',109763,'AFTERNOON SHIFT','2019-10-11','2019-10-11 00:00:00',NULL,'248',2073874.30,2073874.30,'248','2019-10-14 09:54:13','248','2019-10-14 09:54:48',10,0),('1','64',109767,'MORNING SHIFT','2019-10-12','2019-10-12 00:00:00',NULL,'248',1619725.00,1619725.00,'248','2019-10-14 09:58:16','248','2019-10-14 09:58:47',10,0),('1','64',109770,'AFTERNOON SHIFT','2019-10-12','2019-10-12 00:00:00',NULL,'248',1778334.00,1778334.00,'248','2019-10-14 10:10:38','248','2019-10-14 10:11:19',10,0),('1','64',109775,'MORNING SHIFT','2019-10-13','2019-10-13 00:00:00',NULL,'248',1234525.00,1234525.00,'248','2019-10-14 10:14:37','248','2019-10-14 10:15:09',10,0),('1','64',109776,'AFTERNOON SHIFT','2019-10-13','2019-10-13 00:00:00',NULL,'248',1501666.00,1501666.00,'248','2019-10-14 10:19:29','248','2019-10-14 10:20:15',10,0),('1','64',109777,'MORNING SHIFT','2019-10-14','2019-10-14 00:00:00',NULL,'248',1542382.00,1542382.00,'248','2019-10-19 09:40:31','248','2019-10-19 10:06:11',10,0),('1','64',110411,'AFTERNOON SHIFT','2019-10-14','2019-10-14 00:00:00',NULL,'248',1812198.00,1812198.00,'248','2019-10-19 10:18:20','248','2019-10-19 10:20:49',10,0),('1','64',110414,'MORNING SHIFT','2019-10-15','2019-10-15 00:00:00',NULL,'248',1145132.00,1145132.00,'248','2019-10-19 10:28:54','248','2019-10-19 10:29:36',10,0),('1','64',110416,'AFTERNOON SHIFT','2019-10-15','2019-10-15 00:00:00',NULL,'248',2134715.00,2134715.00,'248','2019-10-21 11:29:20','248','2019-10-21 11:29:58',10,0),('1','64',110670,'MORNING SHIFT','2019-10-16','2019-10-16 00:00:00',NULL,'248',1392891.00,1392891.00,'248','2019-10-21 11:39:21','248','2019-10-21 11:42:24',10,0),('1','64',110674,'AFTERNOON SHIFT','2019-10-16','2019-10-16 00:00:00',NULL,'248',2105412.00,2105412.00,'248','2019-10-21 12:13:37','248','2019-10-21 12:14:25',10,0),('1','64',110678,'MORNING SHIFT','2019-10-17','2019-10-17 00:00:00',NULL,'248',1425885.00,1425885.00,'248','2019-10-21 12:23:27','248','2019-10-21 12:36:53',10,0),('1','64',110681,'AFTERNOON SHIFT','2019-10-17','2019-10-17 00:00:00',NULL,'248',1995625.00,1995625.00,'248','2019-10-21 12:59:22','248','2019-10-21 13:04:24',10,0),('1','64',110688,'MORNING SHIFT','2019-10-18','2019-10-18 00:00:00',NULL,'248',1344651.00,1344651.00,'248','2019-10-21 13:20:25','248','2019-10-21 13:21:46',10,0),('1','64',110695,'AFTERNOON SHIFT','2019-10-18','2019-10-18 00:00:00',NULL,'248',2000487.00,2000487.00,'248','2019-10-21 13:40:15','248','2019-10-21 13:49:19',10,0),('1','64',110700,'MORNING SHIFT','2019-10-19','2019-10-19 00:00:00',NULL,'248',1150323.00,1150323.00,'248','2019-10-22 09:47:15','248','2019-10-22 09:47:45',10,0),('1','64',110808,'AFTERNOON SHIFT','2019-10-19','2019-10-19 00:00:00',NULL,'248',1682732.00,1682732.00,'248','2019-10-22 09:51:13','248','2019-10-22 09:51:47',10,0),('1','64',110810,'MORNING SHIFT','2019-10-20','2019-10-20 00:00:00',NULL,'248',911782.00,911782.00,'248','2019-10-22 09:54:38','248','2019-10-22 09:55:03',10,0),('1','64',110811,'AFTERNOON SHIFT','2019-10-20','2019-10-20 00:00:00',NULL,'248',1559960.00,1559960.00,'248','2019-10-22 09:57:52','248','2019-10-22 09:58:24',10,0),('1','64',110812,'MORNING SHIFT','2019-10-21','2019-10-21 00:00:00',NULL,'248',1264224.00,1264224.00,'248','2019-10-26 13:06:51','248','2019-10-26 13:07:32',10,0),('1','64',111287,'AFTERNOON SHIFT','2019-10-21','2019-10-21 00:00:00',NULL,'248',1946432.00,1946432.00,'248','2019-10-26 13:11:43','248','2019-10-26 13:12:20',10,0),('1','64',111290,'MORNING SHIFT','2019-10-22','2019-10-22 00:00:00',NULL,'248',1189332.00,1189332.00,'248','2019-10-26 13:17:08','248','2019-10-26 13:17:45',10,0),('1','64',111292,'AFTERNOON SHIFT','2019-10-22','2019-10-22 00:00:00',NULL,'248',2059435.00,2059435.00,'248','2019-10-26 13:20:44','248','2019-10-26 13:21:21',10,0),('1','64',111293,'MORNING SHIFT','2019-10-23','2019-10-23 00:00:00',NULL,'248',1056366.00,1056366.00,'248','2019-10-26 13:23:53','248','2019-10-26 13:24:27',10,0),('1','64',111296,'AFTERNOON SHIFT','2019-10-23','2019-10-23 00:00:00',NULL,'248',1992490.00,1992490.00,'248','2019-10-26 13:33:36','248','2019-10-26 13:34:27',10,0),('1','64',111298,'MORNING SHIFT','2019-10-24','2019-10-24 00:00:00',NULL,'248',1140730.00,1140730.00,'248','2019-10-26 13:38:28','248','2019-10-26 13:39:09',10,0),('1','64',111300,'AFTERNOON SHIFT','2019-10-24','2019-10-24 00:00:00',NULL,'248',1927539.00,1927539.00,'248','2019-10-26 13:41:45','248','2019-10-26 13:42:32',10,0),('1','64',111301,'MORNING SHIFT','2019-10-25','2019-10-25 00:00:00',NULL,'248',1246704.00,1246704.00,'248','2019-10-26 13:55:46','248','2019-10-26 13:56:14',10,0),('1','64',111308,'AFTERNOON SHIFT','2019-10-25','2019-10-25 00:00:00',NULL,'248',1911740.00,1911740.00,'248','2019-10-26 13:59:03','248','2019-10-26 13:59:35',10,0),('1','64',111310,'MORNING SHIFT','2019-10-26','2019-10-26 00:00:00',NULL,'248',1293052.00,1293052.00,'248','2019-10-30 09:34:21','248','2019-10-30 09:34:54',10,0),('1','64',111780,'AFTERNOON SHIFT','2019-10-26','2019-10-26 00:00:00',NULL,'248',1768963.00,1768963.00,'248','2019-10-30 09:38:16','248','2019-10-30 09:38:44',10,0),('1','64',111782,'MORNING SHIFT','2019-10-27','2019-10-27 00:00:00',NULL,'248',1251392.00,1251392.00,'248','2019-10-30 09:41:09','248','2019-10-30 09:41:48',10,0),('1','64',111783,'AFTERNOON SHIFT','2019-10-27','2019-10-27 00:00:00',NULL,'248',1670250.00,1670250.00,'248','2019-10-30 09:44:03','248','2019-10-30 09:44:37',10,0),('1','64',111785,'MORNING SHIFT','2019-10-28','2019-10-28 00:00:00',NULL,'248',1189485.00,1189485.00,'248','2019-10-30 09:48:14','248','2019-10-30 09:48:52',10,0),('1','64',111786,'AFTERNOON SHIFT','2019-10-28','2019-10-28 00:00:00',NULL,'248',2199260.00,2199260.00,'248','2019-10-30 10:10:28','248','2019-10-30 10:10:59',10,0),('1','64',111789,'MORNING SHIFT','2019-10-29','2019-10-29 00:00:00',NULL,'248',1314560.15,1314560.15,'248','2019-10-30 10:19:54','248','2019-10-30 10:20:41',10,0),('1','64',111790,'AFTERNOON SHIFT','2019-10-29','2019-10-29 00:00:00',NULL,'248',2129512.00,2129512.00,'248','2019-10-31 07:53:15','248','2019-10-31 07:54:13',10,0),('1','64',111886,'MORNING SHIFT','2019-10-30','2019-10-30 00:00:00',NULL,'248',1419459.00,1419459.00,'248','2019-10-31 08:31:48','248','2019-10-31 08:33:43',10,0),('1','64',111895,'AFTERNOON SHIFT','2019-10-30','2019-10-30 00:00:00',NULL,'248',1747914.00,1747914.00,'248','2019-11-04 06:17:58','248','2019-11-04 06:18:39',10,0),('1','64',112314,'MORNING SHIFT','2019-10-31','2019-10-31 00:00:00',NULL,'248',1047045.00,1047045.00,'248','2019-11-04 06:22:52','248','2019-11-04 06:23:26',10,0),('1','64',112315,'AFTERNOON SHIFT','2019-10-31','2019-10-31 00:00:00',NULL,'248',1766365.00,1766365.00,'248','2019-11-04 06:25:38','248','2019-11-04 06:26:08',10,0),('1','64',112316,'MORNING SHIFT','2019-11-01','2019-11-01 00:00:00',NULL,'248',2180229.00,2180229.00,'248','2019-11-05 10:04:36','248','2019-11-05 10:05:28',10,0),('1','64',112492,'AFTERNOON SHIFT','2019-11-01','2019-11-01 00:00:00',NULL,'248',1950962.00,1950962.00,'248','2019-11-05 10:37:30','248','2019-11-05 10:39:12',10,0),('1','64',112499,'MORNING SHIFT','2019-11-02','2019-11-02 00:00:00',NULL,'248',1635038.00,1635038.00,'248','2019-11-05 10:47:27','248','2019-11-05 10:50:54',10,0),('1','64',112501,'AFTERNOON SHIFT','2019-11-02','2019-11-02 00:00:00',NULL,'248',1936836.00,1936836.00,'248','2019-11-05 10:56:11','248','2019-11-05 10:57:05',10,0),('1','64',112503,'MORNING SHIFT','2019-11-03','2019-11-03 00:00:00',NULL,'248',1339329.00,1339329.00,'248','2019-11-05 11:01:52','248','2019-11-05 11:04:28',10,0),('1','64',112505,'AFTERNOON SHIFT','2019-11-03','2019-11-03 00:00:00',NULL,'248',1715464.00,1715464.00,'248','2019-11-07 09:40:05','248','2019-11-07 09:41:27',10,0),('1','64',112701,'MORNING SHIFT','2019-11-04','2019-11-04 00:00:00',NULL,'248',1171544.00,1171544.00,'248','2019-11-07 09:47:57','248','2019-11-07 09:52:08',10,0),('1','64',112702,'AFTERNOON SHIFT','2019-11-04','2019-11-04 00:00:00',NULL,'248',2105050.00,2105050.00,'248','2019-11-07 10:10:29','248','2019-11-07 10:11:08',10,0),('1','64',112704,'MORNING SHIFT','2019-11-05','2019-11-05 00:00:00',NULL,'248',1219752.00,1219752.00,'248','2019-11-07 10:19:44','248','2019-11-07 10:20:22',10,0),('1','64',112708,'AFTERNOON SHIFT','2019-11-05','2019-11-05 00:00:00',NULL,'248',1955121.00,1955121.00,'248','2019-11-07 10:23:52','248','2019-11-07 10:25:32',10,0),('1','64',112710,'MORNING SHIFT','2019-11-06','2019-11-06 00:00:00',NULL,'248',1219402.00,1219402.00,'248','2019-11-07 10:33:35','248','2019-11-07 10:35:23',10,0),('1','64',112711,'AFTERNOON SHIFT','2019-11-06','2019-11-06 00:00:00',NULL,'248',1725790.00,1725790.00,'248','2019-11-07 10:38:31','248','2019-11-07 10:39:19',10,0),('1','64',112712,'MORNING SHIFT','2019-11-07','2019-11-07 00:00:00',NULL,'248',1325338.00,1325338.00,'248','2019-11-10 11:55:14','248','2019-11-10 11:55:50',10,0),('1','64',113068,'AFTERNOON SHIFT','2019-11-07','2019-11-07 00:00:00',NULL,'248',1596364.00,1596364.00,'248','2019-11-10 11:58:52','248','2019-11-10 11:59:41',10,0),('1','64',113070,'MORNING SHIFT','2019-11-08','2019-11-08 00:00:00',NULL,'248',1451499.00,1451499.00,'248','2019-11-10 15:02:23','248','2019-11-10 15:04:31',10,0),('1','64',113120,'AFTERNOON SHIFT','2019-11-08','2019-11-08 00:00:00',NULL,'248',1888742.00,1888742.00,'248','2019-11-10 15:08:14','248','2019-11-10 15:09:40',10,0),('1','64',113121,'MORNING SHIFT','2019-11-09','2019-11-09 00:00:00',NULL,'248',1171946.00,1171946.00,'248','2019-11-11 10:26:02','248','2019-11-11 10:26:48',10,0),('1','64',113184,'AFTERNOON SHIFT','2019-11-09','2019-11-09 00:00:00',NULL,'248',1740388.00,1740388.00,'248','2019-11-11 10:30:48','248','2019-11-11 10:31:26',10,0),('1','64',113185,'MORNING SHIFT','2019-11-10','2019-11-10 00:00:00',NULL,'248',1041144.00,1041144.00,'248','2019-11-11 10:41:13','248','2019-11-11 10:41:51',10,0),('1','64',113190,'AFTERNOON SHIFT','2019-11-10','2019-11-10 00:00:00',NULL,'248',1379032.00,1379032.00,'248','2019-11-11 20:48:53','248','2019-11-11 20:49:32',10,0),('1','64',113284,'MORNING SHIFT','2019-11-11','2019-11-11 00:00:00',NULL,'248',1054388.00,1054388.00,'248','2019-11-11 20:55:48','248','2019-11-11 20:56:25',10,0),('1','64',113285,'AFTERNOON SHIFT','2019-11-11','2019-11-11 00:00:00',NULL,'248',1883100.00,1883100.00,'248','2019-11-13 14:11:58','248','2019-11-13 14:12:29',10,0),('1','64',113498,'MORNING SHIFT','2019-11-12','2019-11-12 00:00:00',NULL,'248',1239753.00,1239753.00,'248','2019-11-13 14:16:42','248','2019-11-13 14:18:33',10,0),('1','64',113501,'AFTERNOON SHIFT','2019-11-12','2019-11-12 00:00:00',NULL,'248',1794056.00,1794056.00,'248','2019-11-13 14:23:19','248','2019-11-13 14:24:00',10,0),('1','64',113503,'MORNING SHIFT','2019-11-13','2019-11-13 00:00:00',NULL,'248',1262140.00,1262140.00,'248','2019-11-13 14:30:28','248','2019-11-13 14:32:03',10,0),('1','64',113508,'AFTERNOON SHIFT','2019-11-13','2019-11-13 00:00:00',NULL,'248',1654159.00,1654159.00,'248','2019-11-15 16:36:12','248','2019-11-15 16:36:58',10,0),('1','64',113778,'MORNING SHIFT','2019-11-14','2019-11-14 00:00:00',NULL,'248',1243816.00,1243816.00,'248','2019-11-15 16:41:19','248','2019-11-15 16:42:55',10,0),('1','64',113780,'AFTERNOON SHIFT','2019-11-14','2019-11-14 00:00:00',NULL,'248',1606874.00,1606874.00,'248','2019-11-15 16:45:42','248','2019-11-15 16:47:00',10,0),('1','64',113782,'MORNING SHIFT','2019-11-15','2019-11-15 00:00:00',NULL,'248',1103319.00,1103319.00,'248','2019-11-21 11:39:00','248','2019-11-21 11:41:28',10,0),('1','64',114442,'AFTERNOON SHIFT','2019-11-15','2019-11-15 00:00:00',NULL,'248',2319120.00,2319120.00,'248','2019-11-21 11:48:32','248','2019-11-21 11:49:15',10,0),('1','64',114443,'MORNING SHIFT','2019-11-16','2019-11-16 00:00:00',NULL,'248',1236307.00,1236307.00,'248','2019-11-21 12:09:49','248','2019-11-21 12:13:34',10,0),('1','64',114446,'AFTERNOON SHIFT','2019-11-16','2019-11-16 00:00:00',NULL,'248',1699211.00,1699211.00,'248','2019-11-21 12:34:01','248','2019-11-21 12:34:33',10,0),('1','64',114448,'MORNING SHIFT','2019-11-17','2019-11-17 00:00:00',NULL,'248',1204111.00,1204111.00,'248','2019-11-24 19:06:38','248','2019-11-24 19:07:09',10,0),('1','64',114852,'AFTERNOON SHIFT','2019-11-17','2019-11-17 00:00:00',NULL,'248',1633529.00,1633529.00,'248','2019-11-24 19:12:15','248','2019-11-24 19:12:48',10,0),('1','64',114853,'MORNING SHIFT','2019-11-18','2019-11-18 00:00:00',NULL,'248',1250236.00,1250236.00,'248','2019-11-24 19:16:08','248','2019-11-24 19:16:40',10,0),('1','64',114854,'AFTERNOON SHIFT','2019-11-18','2019-11-18 00:00:00',NULL,'248',2118912.00,2118912.00,'248','2019-11-24 19:22:35','248','2019-11-24 19:23:06',10,0),('1','64',114855,'MORNING SHIFT','2019-11-19','2019-11-19 00:00:00',NULL,'248',1078934.00,1078934.00,'248','2019-11-24 19:25:53','248','2019-11-24 19:26:29',10,0),('1','64',114856,'AFTERNOON SHIFT','2019-11-19','2019-11-19 00:00:00',NULL,'248',542925.00,542925.00,'248','2019-11-24 19:29:14','248','2019-11-24 19:29:42',10,0),('1','64',114857,'MORNING SHIFT','2019-11-20','2019-11-20 00:00:00',NULL,'248',810140.00,810140.00,'248','2019-11-27 11:01:12','248','2019-11-27 11:02:28',10,0),('1','64',115279,'AFTERNOON SHIFT','2019-11-20','2019-11-20 00:00:00',NULL,'248',1159774.00,1159774.00,'248','2019-11-27 11:11:36','248','2019-11-27 11:12:06',10,0),('1','64',115282,'MORNING SHIFT','2019-11-21','2019-11-21 00:00:00',NULL,'248',762966.00,762966.00,'248','2019-11-27 11:14:25','248','2019-11-27 11:15:02',10,0),('1','64',115285,'AFTERNOON SHIFT','2019-11-21','2019-11-21 00:00:00',NULL,'248',228620.00,228620.00,'248','2019-11-27 11:26:50','248','2019-11-27 11:27:18',10,0),('1','64',115286,'MORNING SHIFT','2019-11-22','2019-11-22 00:00:00',NULL,'248',335546.00,335546.00,'248','2019-11-27 11:30:14','248','2019-11-27 11:30:48',10,0),('1','64',115287,'AFTERNOON SHIFT','2019-11-22','2019-11-22 00:00:00',NULL,'248',1845110.00,1845110.00,'248','2019-11-27 11:33:17','248','2019-11-27 11:33:47',10,0),('1','64',115289,'MORNING SHIFT','2019-11-23','2019-11-23 00:00:00',NULL,'248',1268916.00,1268916.00,'248','2019-11-27 11:36:42','248','2019-11-27 11:37:16',10,0),('1','64',115290,'AFTERNOON SHIFT','2019-11-23','2019-11-23 00:00:00',NULL,'248',1716791.00,1716791.00,'248','2019-11-27 11:39:13','248','2019-11-27 11:39:37',10,0),('1','64',115292,'MORNING SHIFT','2019-11-24','2019-11-24 00:00:00',NULL,'248',1020190.00,1020190.00,'248','2019-11-27 11:42:03','248','2019-11-27 11:42:35',10,0),('1','64',115302,'AFTERNOON SHIFT','2019-11-24','2019-11-24 00:00:00',NULL,'248',1405317.00,1405317.00,'248','2019-11-27 12:28:11','248','2019-11-27 12:28:39',10,0),('1','64',115304,'MORNING SHIFT','2019-11-25','2019-11-25 00:00:00',NULL,'248',1166156.00,1166156.00,'248','2019-11-27 12:31:14','248','2019-11-27 12:32:55',10,0),('1','64',115307,'AFTERNOON SHIFT','2019-11-25','2019-11-25 00:00:00',NULL,'248',1928470.00,1928470.00,'248','2019-11-28 10:22:52','248','2019-11-28 10:23:41',10,0),('1','64',115442,'MORNING SHIFT','2019-11-26','2019-11-26 00:00:00',NULL,'248',1401710.00,1401710.00,'248','2019-11-28 10:26:31','248','2019-11-28 10:27:23',10,0),('1','64',115444,'AFTERNOON SHIFT','2019-11-26','2019-11-26 00:00:00',NULL,'248',2254210.00,2254210.00,'248','2019-11-28 10:33:09','248','2019-11-28 10:33:51',10,0),('1','64',115445,'MORNING SHIFT','2019-11-27','2019-11-27 00:00:00',NULL,'248',1237425.00,1237425.00,'248','2019-11-28 10:38:03','248','2019-11-28 10:39:24',10,0),('1','64',115446,'AFTERNOON SHIFT','2019-11-27','2019-11-27 00:00:00',NULL,'248',1825039.00,1825039.00,'248','2019-11-28 11:21:51','248','2019-11-28 11:22:48',10,0),('1','64',115457,'MORNING SHIFT','2019-11-28','2019-11-28 00:00:00',NULL,'248',1373014.00,1373014.00,'248','2019-11-28 18:19:56','248','2019-11-28 18:21:21',10,0),('1','64',115540,'AFTERNOON SHIFT','2019-11-28','2019-11-28 00:00:00',NULL,'248',1686589.00,1686589.00,'248','2019-11-29 19:30:47','248','2019-11-29 19:31:12',10,0),('1','64',115661,'MORNING SHIFT','2019-11-29','2019-11-29 00:00:00',NULL,'248',952208.00,952208.00,'248','2019-11-29 19:33:28','248','2019-11-29 19:33:59',10,0),('1','64',115662,'AFTERNOON SHIFT','2019-11-29','2019-11-29 00:00:00',NULL,'248',1796074.00,1796074.00,'248','2019-11-30 10:52:58','248','2019-11-30 10:53:56',10,0),('1','64',115690,'MORNING SHIFT','2019-11-30','2019-11-30 00:00:00',NULL,'248',1423393.00,1423393.00,'248','2019-12-04 11:12:22','248','2019-12-04 11:13:18',10,0),('1','64',116138,'AFTERNOON SHIFT','2019-11-30','2019-11-30 00:00:00',NULL,'248',1733110.00,1733110.00,'248','2019-12-04 11:18:36','248','2019-12-04 11:19:24',10,0),('1','64',116139,'MORNING SHIFT','2019-12-01','2019-12-01 00:00:00',NULL,'248',993290.00,993290.00,'248','2019-12-04 12:26:36','248','2019-12-04 12:27:22',10,0),('1','64',116155,'AFTERNOON SHIFT','2019-12-01','2019-12-01 00:00:00',NULL,'248',1493840.00,1493840.00,'248','2019-12-04 12:51:03','248','2019-12-04 12:51:45',10,0),('1','64',116157,'MORNING SHIFT','2019-12-02','2019-12-02 00:00:00',NULL,'248',1387883.00,1387883.00,'248','2019-12-04 12:58:26','248','2019-12-04 12:58:57',10,0),('1','64',116159,'AFTERNOON SHIFT','2019-12-02','2019-12-02 00:00:00',NULL,'248',2158474.00,2158474.00,'248','2019-12-04 13:02:00','248','2019-12-04 13:02:27',10,0),('1','64',116160,'MORNING SHIFT','2019-12-03','2019-12-03 00:00:00',NULL,'248',1231292.00,1231292.00,'248','2019-12-04 13:06:04','248','2019-12-04 13:06:40',10,0),('1','64',116161,'AFTERNOON SHIFT','2019-12-03','2019-12-03 00:00:00',NULL,'248',2109767.00,2109767.00,'248','2019-12-09 09:16:17','248','2019-12-09 09:17:10',10,0),('1','64',116994,'MORNING SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1124498.00,1124498.00,'248','2019-12-11 10:54:11','248','2019-12-11 10:59:59',10,0),('1','64',116999,'AFTERNOON SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1583868.00,1583868.00,'248','2019-12-11 11:02:00','248','2019-12-11 11:04:48',10,0),('1','64',117001,'MORNING SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1008422.00,1008422.00,'248','2019-12-11 11:06:57','248','2019-12-11 11:07:32',10,0),('1','64',117002,'AFTERNOON SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1031386.00,1031386.00,'248','2019-12-11 11:09:23','248','2019-12-11 11:09:59',10,0),('1','64',117003,'MORNING SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',780609.00,780609.00,'248','2019-12-11 11:43:48','248','2019-12-11 11:44:12',10,0),('1','64',117012,'AFTERNOON SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1905401.00,1905401.00,'248','2019-12-11 11:50:36','248','2019-12-11 11:52:26',10,0),('1','64',117014,'MORNING SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1208965.00,1208965.00,'248','2019-12-11 12:32:23','248','2019-12-11 12:32:56',10,0),('1','64',117025,'AFTERNOON SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1790461.00,1790461.00,'248','2019-12-11 12:35:39','248','2019-12-11 12:36:08',10,0),('1','64',117027,'MORNING SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1235844.00,1235844.00,'248','2019-12-11 12:38:35','248','2019-12-11 12:39:01',10,0),('1','64',117029,'AFTERNOON SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1551802.00,1551802.00,'248','2019-12-11 12:42:47','248','2019-12-11 12:43:28',10,0),('1','64',117031,'MORNING SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1243039.00,1243039.00,'248','2019-12-11 18:16:10','248','2019-12-11 18:16:40',10,0),('1','64',117088,'AFTERNOON SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',2183600.00,2183600.00,'248','2019-12-11 18:19:03','248','2019-12-11 18:19:40',10,0),('1','64',117089,'MORNING SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1484979.00,1484979.00,'248','2019-12-11 19:17:21','248','2019-12-11 19:17:52',10,0),('1','64',117093,'AFTERNOON SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',2308649.00,2308649.00,'248','2019-12-11 19:19:56','248','2019-12-11 19:20:27',10,0),('1','64',117094,'MORNING SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',1406518.00,1406518.00,'248','2019-12-11 19:24:27','248','2019-12-11 19:25:01',10,0),('1','64',117095,'AFTERNOON SHIFT','2019-12-11','2019-12-11 00:00:00',NULL,'248',2044674.00,2044674.00,'248','2019-12-12 10:55:48','248','2019-12-12 10:56:20',10,0),('1','64',117141,'MORNING SHIFT','2019-12-12','2019-12-12 00:00:00',NULL,'248',1502100.00,1502100.00,'248','2019-12-12 14:57:19','248','2019-12-12 15:05:58',10,0),('1','64',117195,'AFTERNOON SHIFT','2019-12-12','2019-12-12 00:00:00',NULL,'248',2764875.00,2764875.00,'248','2019-12-13 18:23:53','248','2019-12-13 18:25:54',10,0),('1','64',117375,'MORNING SHIFT','2019-12-13','2019-12-13 00:00:00',NULL,'248',1627074.00,1627074.00,'248','2019-12-13 18:35:13','248','2019-12-13 18:37:27',10,0),('1','64',117378,'AFTERNOON SHIFT','2019-12-13','2019-12-13 00:00:00',NULL,'248',2198586.00,2198586.00,'248','2019-12-14 12:18:43','248','2019-12-14 12:19:25',10,0),('1','64',117431,'MORNING SHIFT','2019-12-14','2019-12-14 00:00:00',NULL,'248',1310459.00,1310459.00,'248','2019-12-14 14:36:12','248','2019-12-14 14:38:21',10,0),('1','64',117459,'AFTERNOON SHIFT','2019-12-14','2019-12-14 00:00:00',NULL,'248',633320.00,633320.00,'248','2019-12-14 15:25:49','248','2019-12-14 15:26:19',10,0),('1','64',117472,'PRICE CHANGE SHIFT','2019-12-14','2019-12-14 00:00:00',NULL,'248',1343599.00,1343599.00,'248','2019-12-15 15:20:43','248','2019-12-15 15:21:37',10,0),('1','64',117580,'MORNING SHIFT','2019-12-15','2019-12-15 00:00:00',NULL,'248',1245043.00,1245043.00,'248','2019-12-15 15:36:38','248','2019-12-15 15:37:06',10,0),('1','64',117584,'AFTERNOON SHIFT','2019-12-15','2019-12-15 00:00:00',NULL,'248',1701265.00,1701265.00,'248','2019-12-16 09:15:26','248','2019-12-16 09:15:52',10,0),('1','64',117635,'MORNING SHIFT','2019-12-16','2019-12-16 00:00:00',NULL,'248',1333777.00,1333777.00,'248','2019-12-16 15:31:31','248','2019-12-16 15:32:27',10,0),('1','64',117717,'AFTERNOON SHIFT','2019-12-16','2019-12-16 00:00:00',NULL,'248',2264297.00,2264297.00,'248','2019-12-17 10:27:09','248','2019-12-17 10:27:52',10,0),('1','64',117785,'MORNING SHIFT','2019-12-17','2019-12-17 00:00:00',NULL,'248',1322906.00,1322906.00,'248','2019-12-18 10:42:16','248','2019-12-18 10:42:46',10,0),('1','64',117931,'AFTERNOON SHIFT','2019-12-17','2019-12-17 00:00:00',NULL,'248',2208628.00,2208628.00,'248','2019-12-18 10:45:16','248','2019-12-18 10:46:09',10,0),('1','64',117933,'MORNING SHIFT','2019-12-18','2019-12-18 00:00:00',NULL,'248',1250080.00,1250080.00,'248','2019-12-19 08:27:41','248','2019-12-19 08:28:15',10,0),('1','64',118037,'AFTERNOON SHIFT','2019-12-18','2019-12-18 00:00:00',NULL,'248',2061988.00,2061988.00,'248','2019-12-19 08:49:58','248','2019-12-19 08:54:27',10,0),('1','64',118040,'MORNING SHIFT','2019-12-19','2019-12-19 00:00:00',NULL,'248',1228261.00,1228261.00,'248','2019-12-20 10:02:02','248','2019-12-20 10:06:02',10,0),('1','64',118212,'AFTERNOON SHIFT','2019-12-19','2019-12-19 00:00:00',NULL,'248',2114469.00,2114469.00,'248','2019-12-20 10:13:28','248','2019-12-20 10:14:18',10,0),('1','64',118215,'MORNING SHIFT','2019-12-20','2019-12-20 00:00:00',NULL,'248',1194174.00,1194174.00,'248','2019-12-21 13:05:02','248','2019-12-21 13:05:33',10,0),('1','64',118354,'AFTERNOON SHIFT','2019-12-20','2019-12-20 00:00:00',NULL,'248',1820467.00,1820467.00,'248','2019-12-21 13:08:17','248','2019-12-21 13:08:55',10,0),('1','64',118355,'MORNING SHIFT','2019-12-21','2019-12-21 00:00:00',NULL,'248',1571114.00,1571114.00,'248','2019-12-22 12:13:48','248','2019-12-22 12:14:15',10,0),('1','64',118452,'AFTERNOON SHIFT','2019-12-21','2019-12-21 00:00:00',NULL,'248',1944256.00,1944256.00,'248','2019-12-22 12:17:15','248','2019-12-22 12:17:43',10,0),('1','64',118453,'MORNING SHIFT','2019-12-22','2019-12-22 00:00:00',NULL,'248',1324769.00,1324769.00,'248','2019-12-23 10:13:38','248','2019-12-23 10:15:00',10,0),('1','64',120670,'AFTERNOON SHIFT','2019-12-22','2019-12-22 00:00:00',NULL,'248',2132719.00,2132719.00,'248','2020-01-10 17:01:08','248','2020-01-10 17:01:54',10,0),('1','64',120673,'MORNING SHIFT','2019-01-23','2019-01-23 00:00:00',NULL,'248',1527806.00,1527806.00,'248','2020-01-10 17:06:22','248','2020-01-10 17:07:07',10,0),('1','64',120675,'AFTERNOON SHIFT','2019-12-23','2019-12-23 00:00:00',NULL,'248',2457677.90,2457677.90,'248','2020-01-10 17:12:41','248','2020-01-10 17:13:24',10,0),('1','64',120677,'MORNING SHIFT','2019-12-24','2019-12-24 00:00:00',NULL,'248',1691366.50,1691366.50,'248','2020-01-10 17:31:52','248','2020-01-10 17:33:33',10,0),('1','64',120680,'AFTERNOON SHIFT','2019-12-24','2019-12-24 00:00:00',NULL,'248',2706306.50,2706306.50,'248','2020-01-10 17:38:10','248','2020-01-10 17:38:59',10,0),('1','64',120681,'MORNING SHIFT','2019-12-25','2019-12-25 00:00:00',NULL,'248',1681253.60,1681253.60,'248','2020-01-10 17:46:23','248','2020-01-10 17:47:48',10,0),('1','64',120683,'AFTERNOON SHIFT','2019-12-25','2019-12-25 00:00:00',NULL,'248',2017849.30,2017849.30,'248','2020-01-10 18:17:53','248','2020-01-10 18:19:00',10,0),('1','64',120686,'MORNING SHIFT','2019-12-26','2019-12-26 00:00:00',NULL,'248',1061917.30,1061917.30,'248','2020-01-13 11:44:33','248','2020-01-13 11:45:02',10,0),('1','64',121012,'AFTERNOON SHIFT','2019-12-26','2019-12-26 00:00:00',NULL,'248',1236540.90,1236540.90,'248','2020-01-13 11:47:40','248','2020-01-13 11:48:07',10,0),('1','64',121013,'MORNING SHIFT','2019-12-27','2019-12-27 00:00:00',NULL,'248',1135533.10,1135533.10,'248','2020-01-13 12:27:57','248','2020-01-13 12:28:53',10,0),('1','64',121026,'AFTERNOON SHIFT','2019-12-27','2019-12-27 00:00:00',NULL,'248',1668951.00,1668951.00,'248','2020-01-13 12:32:11','248','2020-01-13 12:32:59',10,0),('1','64',121031,'MORNING SHIFT','2019-12-28','2019-12-28 00:00:00',NULL,'248',1196750.80,1196750.80,'248','2020-01-13 12:39:30','248','2020-01-13 12:42:40',10,0),('1','64',121033,'AFTERNOON SHIFT','2019-12-28','2019-12-28 00:00:00',NULL,'248',1664481.40,1664481.40,'248','2020-01-13 12:51:57','248','2020-01-13 12:52:26',10,0),('1','64',121035,'MORNING SHIFT','2019-12-29','2019-12-29 00:00:00',NULL,'248',1033746.50,1033746.50,'248','2020-01-13 12:57:22','248','2020-01-13 12:57:49',10,0),('1','64',121036,'AFTERNOON SHIFT','2019-12-29','2019-12-29 00:00:00',NULL,'248',1460936.70,1460936.70,'248','2020-01-13 13:04:07','248','2020-01-13 13:04:42',10,0),('1','64',121037,'MORNING SHIFT','2019-12-30','2019-12-30 00:00:00',NULL,'248',1172998.20,1172998.20,'248','2020-01-13 13:08:39','248','2020-01-13 13:09:18',10,0),('1','64',121039,'AFTERNOON SHIFT','2019-12-30','2019-12-30 00:00:00',NULL,'248',2020692.00,2020692.00,'248','2020-01-13 13:13:08','248','2020-01-13 13:13:35',10,0),('1','64',121040,'MORNING SHIFT','2019-12-31','2019-12-31 00:00:00',NULL,'248',1339823.90,1339823.90,'248','2020-01-13 13:16:18','248','2020-01-13 13:16:54',10,0),('1','64',121044,'AFTERNOON SHIFT','2019-12-31','2019-12-31 00:00:00',NULL,'248',2514027.70,2514027.70,'248','2020-01-13 13:20:08','248','2020-01-13 13:20:38',10,0),('1','64',121046,'MORNING SHIFT','2020-01-01','2020-01-01 00:00:00',NULL,'248',995741.60,995741.60,'248','2020-01-14 11:05:32','248','2020-01-14 11:06:07',10,0),('1','64',121149,'AFTERNOON SHIFT','2020-01-01','2020-01-01 00:00:00',NULL,'248',2412012.20,2412012.20,'248','2020-01-14 11:14:45','248','2020-01-14 11:15:12',10,0),('1','64',121152,'MORNING SHIFT','2020-01-02','2020-01-02 00:00:00',NULL,'248',909443.60,909443.60,'248','2020-01-14 11:21:42','248','2020-01-14 11:22:49',10,0),('1','64',121156,'AFTERNOON SHIFT','2020-01-02','2020-01-02 00:00:00',NULL,'248',1376104.50,1376104.50,'248','2020-01-14 11:24:47','248','2020-01-14 11:25:39',10,0),('1','64',121159,'MORNING SHIFT','2020-01-03','2020-01-03 00:00:00',NULL,'248',1153099.00,1153099.00,'248','2020-01-14 11:28:31','248','2020-01-14 11:30:46',10,0),('1','64',121161,'AFTERNOON SHIFT','2020-01-03','2020-01-03 00:00:00',NULL,'248',1419803.80,1419803.80,'248','2020-01-14 12:47:58','248','2020-01-14 12:55:32',10,0),('1','64',121180,'MORNING SHIFT','2020-01-04','2020-01-04 00:00:00',NULL,'248',1069691.80,1069691.80,'248','2020-01-14 12:59:41','248','2020-01-14 13:00:28',10,0),('1','64',121184,'AFTERNOON SHIFT','2020-01-04','2020-01-04 00:00:00',NULL,'248',1509755.30,1509755.30,'248','2020-01-14 13:02:49','248','2020-01-14 13:03:24',10,0),('1','64',121185,'MORNING SHIFT','2020-01-05','2020-01-05 00:00:00',NULL,'248',1014503.10,1014503.10,'248','2020-01-14 13:10:35','248','2020-01-14 13:11:31',10,0),('1','64',121188,'AFTERNOON SHIFT','2020-01-05','2020-01-05 00:00:00',NULL,'248',1322191.40,1322191.40,'248','2020-01-14 13:36:53','248','2020-01-14 13:37:22',10,0),('1','64',121199,'MORNING SHIFT','2020-01-06','2020-01-06 00:00:00',NULL,'248',1075654.20,1075654.20,'248','2020-01-15 08:34:26','248','2020-01-15 08:35:10',10,0),('1','64',121267,'AFTERNOON SHIFT','2020-01-06','2020-01-06 00:00:00',NULL,'248',1689200.80,1689200.80,'248','2020-01-15 08:38:59','248','2020-01-15 08:39:34',10,0),('1','64',121268,'MORNING SHIFT','2020-01-07','2020-01-07 00:00:00',NULL,'248',640304.00,640304.00,'248','2020-01-15 08:51:14','248','2020-01-15 09:23:59',10,0),('1','64',121275,'AFTERNOON SHIFT','2020-01-07','2020-01-07 00:00:00',NULL,'248',1497771.80,1497771.80,'248','2020-01-15 09:31:26','248','2020-01-15 09:32:10',10,0),('1','64',121277,'MORNING SHIFT','2020-01-08','2020-01-08 00:00:00',NULL,'248',1013528.70,1013528.70,'248','2020-01-15 09:38:37','248','2020-01-15 09:39:23',10,0),('1','64',121281,'AFTERNOON SHIFT','2020-01-08','2020-01-08 00:00:00',NULL,'248',1710390.10,1710390.10,'248','2020-01-15 10:08:44','248','2020-01-15 10:09:15',10,0),('1','64',121286,'MORNING SHIFT','2020-01-09','2020-01-09 00:00:00',NULL,'248',620603.00,620603.00,'248','2020-01-15 10:12:32','248','2020-01-15 10:13:00',10,0),('1','64',121287,'AFTERNOON SHIFT','2020-01-09','2020-01-09 00:00:00',NULL,'248',1683786.40,1683786.40,'248','2020-01-15 10:15:22','248','2020-01-15 10:16:08',10,0),('1','64',121289,'MORNING SHIFT','2020-01-10','2020-01-10 00:00:00',NULL,'248',1088034.90,1088034.90,'248','2020-01-15 10:33:41','248','2020-01-15 10:34:18',10,0),('1','64',121294,'AFTERNOON SHIFT','2020-01-10','2020-01-10 00:00:00',NULL,'248',2217057.50,2217057.50,'248','2020-01-15 10:36:46','248','2020-01-15 10:37:20',10,0),('1','64',121296,'MORNING SHIFT','2020-01-11','2020-01-11 00:00:00',NULL,'248',1277088.70,1277088.70,'248','2020-01-15 11:28:19','248','2020-01-15 11:29:00',10,0),('1','64',121301,'AFTERNOON SHIFT','2020-01-11','2020-01-11 00:00:00',NULL,'248',1995907.80,1995907.80,'248','2020-01-15 11:34:40','248','2020-01-15 11:35:21',10,0),('1','64',121302,'MORNING SHIFT','2020-01-12','2020-01-12 00:00:00',NULL,'248',1445862.10,1445862.10,'248','2020-01-15 11:40:48','248','2020-01-15 11:42:50',10,0),('1','64',121304,'AFTERNOON SHIFT','2020-01-12','2020-01-12 00:00:00',NULL,'248',1737306.80,1737306.80,'248','2020-01-15 11:54:55','248','2020-01-15 11:56:20',10,0),('1','64',121312,'MORNING SHIFT','2020-01-13','2020-01-13 00:00:00',NULL,'248',1171405.80,1171405.80,'248','2020-01-15 12:05:52','248','2020-01-15 12:13:24',10,0),('1','64',121314,'AFTERNOON SHIFT','2020-01-13','2020-01-13 00:00:00',NULL,'248',2143556.10,2143556.10,'248','2020-01-15 12:18:55','248','2020-01-15 12:19:38',10,0),('1','64',121315,'MORNING SHIFT','2020-01-14','2020-01-14 00:00:00',NULL,'248',1264303.10,1264303.10,'248','2020-01-15 12:29:47','248','2020-01-15 12:30:29',10,0),('1','64',121319,'AFTERNOON SHIFT','2020-01-14','2020-01-14 00:00:00',NULL,'248',2143858.40,2143858.40,'248','2020-01-18 09:29:44','248','2020-01-18 09:30:45',10,0),('1','64',121659,'MORNING SHIFT','2020-01-15','2020-01-15 00:00:00',NULL,'248',2036415.30,2036415.30,'248','2020-01-18 09:33:37','248','2020-01-18 09:35:39',10,0),('1','64',121661,'AFTERNOON SHIFT','2020-01-15','2020-01-15 00:00:00',NULL,'248',1913161.50,1913161.50,'248','2020-01-18 09:43:46','248','2020-01-18 09:44:18',10,0),('1','64',121665,'MORNING SHIFT','2020-01-16','2020-01-16 00:00:00',NULL,'248',1286332.40,1286332.40,'248','2020-01-18 22:04:52','248','2020-01-18 22:05:23',10,0),('1','64',121770,'AFTERNOON SHIFT','2020-01-16','2020-01-16 00:00:00',NULL,'248',2245459.10,2245459.10,'248','2020-01-18 22:09:53','248','2020-01-18 22:10:46',10,0),('1','64',121771,'MORNING SHIFT','2020-01-17','2020-01-17 00:00:00',NULL,'248',1479336.80,1479336.80,'248','2020-01-18 22:13:29','248','2020-01-18 22:14:02',10,0),('1','64',121772,'AFTERNOON SHIFT','2020-01-17','2020-01-17 00:00:00',NULL,'248',2043810.80,2043810.80,'248','2020-01-18 22:16:42','248','2020-01-18 22:17:08',10,0),('1','64',121773,'MORNING SHIFT','2020-01-18','2020-01-18 00:00:00',NULL,'248',1267910.90,1267910.90,'248','2020-01-18 22:21:55','248','2020-01-18 22:22:29',10,0),('1','64',121774,'AFTERNOON SHIFT','2020-01-18','2020-01-18 00:00:00',NULL,'248',1836014.50,1836014.50,'248','2020-02-02 18:24:26','248','2020-02-02 18:26:03',10,0),('1','64',123486,'MORNING SHIFT','2020-01-19','2020-01-19 00:00:00',NULL,'248',1058728.90,1058728.90,'248','2020-02-03 10:53:54','248','2020-02-03 10:55:15',10,0),('1','64',123549,'AFTERNOON SHIFT','2020-01-19','2020-01-19 00:00:00',NULL,'248',544266.20,544266.20,'248','2020-02-03 10:57:56','248','2020-02-03 10:58:35',10,0),('1','64',123550,'MORNING SHIFT','2020-01-20','2020-01-20 00:00:00',NULL,'248',163858.30,163858.30,'248','2020-02-03 11:10:34','248','2020-02-03 11:11:29',10,0),('1','64',123552,'AFTERNOON SHIFT','2020-01-20','2020-01-20 00:00:00',NULL,'248',194157.20,194157.20,'248','2020-02-03 11:18:41','248','2020-02-03 11:19:07',10,0),('1','64',123553,'MORNING SHIFT','2020-01-21','2020-01-21 00:00:00',NULL,'248',233716.70,233716.70,'248','2020-02-03 11:20:52','248','2020-02-03 11:22:35',10,0),('1','64',123568,'AFTERNOON SHIFT','2020-01-21','2020-01-21 00:00:00',NULL,'248',136046.70,136046.70,'248','2020-02-03 12:17:14','248','2020-02-03 12:17:46',10,0),('1','64',123572,'MORNING SHIFT','2020-01-22','2020-01-22 00:00:00',NULL,'248',137269.90,137269.90,'248','2020-02-03 12:25:32','248','2020-02-03 12:26:00',10,0),('1','64',123574,'AFTERNOON SHIFT','2020-01-22','2020-01-22 00:00:00',NULL,'248',2071263.10,2071263.10,'248','2020-02-03 16:51:42','248','2020-02-03 16:55:36',10,0),('1','64',123632,'MORNING SHIFT','2020-01-23','2020-01-23 00:00:00',NULL,'248',1086801.10,1086801.10,'248','2020-02-03 16:58:57','248','2020-02-03 16:59:23',10,0),('1','64',123634,'AFTERNOON SHIFT','2020-01-23','2020-01-23 00:00:00',NULL,'248',2225832.20,2225832.20,'248','2020-02-03 17:19:48','248','2020-02-03 17:20:27',10,0),('1','64',123642,'MORNING SHIFT','2020-01-24','2020-01-24 00:00:00',NULL,'248',1160969.90,1160969.90,'248','2020-02-05 18:32:01','248','2020-02-05 18:32:27',10,0),('1','64',123940,'AFTERNOON SHIFT','2020-01-24','2020-01-24 00:00:00',NULL,'248',1687819.60,1687819.60,'248','2020-02-05 18:49:47','248','2020-02-05 18:52:11',10,0),('1','64',123941,'MORNING SHIFT','2020-01-25','2020-01-25 00:00:00',NULL,'248',1293104.40,1293104.40,'248','2020-02-05 18:56:06','248','2020-02-05 18:57:46',10,0),('1','64',123942,'AFTERNOON SHIFT','2020-01-25','2020-01-25 00:00:00',NULL,'248',1748972.30,1748972.30,'248','2020-02-05 19:01:26','248','2020-02-05 19:02:07',10,0),('1','64',123943,'MORNING SHIFT','2020-01-26','2020-01-26 00:00:00',NULL,'248',1070934.40,1070934.40,'248','2020-02-05 19:06:21','248','2020-02-05 19:07:16',10,0),('1','64',123944,'AFTERNOON SHIFT','2020-01-26','2020-01-26 00:00:00',NULL,'248',1549394.90,1549394.90,'248','2020-02-05 19:10:50','248','2020-02-05 19:11:48',10,0),('1','64',123945,'MORNING SHIFT','2020-01-27','2020-01-27 00:00:00',NULL,'248',1480345.30,1480345.30,'248','2020-02-05 19:15:55','248','2020-02-05 19:16:51',10,0),('1','64',123946,'AFTERNOON SHIFT','2020-01-27','2020-01-27 00:00:00',NULL,'248',2069736.20,2069736.20,'248','2020-02-05 19:24:30','248','2020-02-05 19:25:07',10,0),('1','64',123949,'MORNING SHIFT','2020-01-28','2020-01-28 00:00:00',NULL,'248',1000455.10,1000455.10,'248','2020-02-07 07:17:42','248','2020-02-07 07:19:00',10,0),('1','64',124128,'AFTERNOON SHIFT','2020-01-28','2020-01-28 00:00:00',NULL,'248',1963082.60,1963082.60,'248','2020-02-07 07:21:35','248','2020-02-07 07:22:04',10,0),('1','64',124129,'MORNING SHIFT','2020-01-29','2020-01-29 00:00:00',NULL,'248',1074777.70,1074777.70,'248','2020-02-07 07:25:20','248','2020-02-07 07:27:23',10,0),('1','64',124130,'AFTERNOON SHIFT','2020-01-29','2020-01-29 00:00:00',NULL,'248',1870181.50,1870181.50,'248','2020-02-07 07:31:33','248','2020-02-07 07:32:03',10,0),('1','64',124402,'MORNING SHIFT','2020-01-30','2020-01-30 00:00:00',NULL,'248',1181995.20,1181995.20,'248','2020-02-09 12:01:16','248','2020-02-09 12:01:53',10,0),('1','64',124404,'AFTERNOON SHIFT','2020-01-30','2020-01-30 00:00:00',NULL,'248',1818025.00,1818025.00,'248','2020-02-09 12:05:31','248','2020-02-09 12:06:17',10,0),('1','64',124407,'MORNING SHIFT','2020-01-31','2020-01-31 00:00:00',NULL,'248',1160922.50,1160922.50,'248','2020-02-09 12:12:38','248','2020-02-09 12:17:42',10,0),('1','64',124410,'AFTERNOON SHIFT','2020-01-31','2020-01-31 00:00:00',NULL,'248',1948397.70,1948397.70,'248','2020-02-09 12:22:29','248','2020-02-09 12:23:23',10,0),('1','64',124411,'MORNING SHIFT','2020-02-01','2020-02-01 00:00:00',NULL,'248',1189785.50,1189785.50,'248','2020-02-09 12:32:02','248','2020-02-09 12:33:07',10,0),('1','64',124412,'AFTERNOON SHIFT','2020-02-01','2020-02-01 00:00:00',NULL,'248',1731644.00,1731644.00,'248','2020-02-09 13:12:30','248','2020-02-09 13:13:26',10,0),('1','64',124428,'MORNING SHIFT','2020-02-02','2020-02-02 00:00:00',NULL,'248',1066134.30,1066134.30,'248','2020-02-09 13:21:45','248','2020-02-09 13:22:20',10,0),('1','64',124430,'AFTERNOON SHIFT','2020-02-02','2020-02-02 00:00:00',NULL,'248',1641287.80,1641287.80,'248','2020-02-09 13:25:49','248','2020-02-09 13:26:25',10,0),('1','64',124432,'MORNING SHIFT','2020-02-03','2020-02-03 00:00:00',NULL,'248',1195979.40,1195979.40,'248','2020-02-09 13:32:50','248','2020-02-09 13:33:27',10,0),('1','64',124436,'AFTERNOON SHIFT','2020-02-03','2020-02-03 00:00:00',NULL,'248',1868847.70,1868847.70,'248','2020-02-09 13:36:48','248','2020-02-09 13:37:14',10,0),('1','64',124438,'MORNING SHIFT','2020-02-04','2020-02-04 00:00:00',NULL,'248',9675.00,9675.00,'248','2020-02-12 16:44:24','248','2020-02-12 16:44:55',10,0),('1','64',124856,'PRICE CHANGE SHIFT','2020-02-04','2020-02-04 00:00:00',NULL,'248',1172486.60,1172486.60,'248','2020-02-12 17:34:38','248','2020-02-12 17:35:29',10,0),('1','64',124857,'AFTERNOON SHIFT','2020-02-04','2020-02-04 00:00:00',NULL,'248',1971667.50,1971667.50,'248','2020-02-12 17:37:53','248','2020-02-12 17:39:50',10,0),('1','64',124859,'MORNING SHIFT','2020-02-05','2020-02-05 00:00:00',NULL,'248',1390447.10,1390447.10,'248','2020-02-12 18:00:52','248','2020-02-12 18:01:24',10,0),('1','64',124861,'AFTERNOON SHIFT','2020-02-05','2020-02-05 00:00:00',NULL,'248',1596787.90,1596787.90,'248','2020-02-12 18:04:32','248','2020-02-12 18:05:13',10,0),('1','64',124864,'MORNING SHIFT','2020-02-06','2020-02-06 00:00:00',NULL,'248',831580.10,831580.10,'248','2020-02-12 18:09:38','248','2020-02-12 18:10:09',10,0),('1','64',124865,'AFTERNOON SHIFT','2020-02-06','2020-02-06 00:00:00',NULL,'248',1492982.40,1492982.40,'248','2020-02-12 18:16:37','248','2020-02-12 18:17:13',10,0),('1','64',124869,'MORNING SHIFT','2020-02-07','2020-02-07 00:00:00',NULL,'248',1108557.50,1108557.50,'248','2020-02-12 18:27:52','248','2020-02-12 18:28:28',10,0),('1','64',124872,'AFTERNOON SHIFT','2020-02-07','2020-02-07 00:00:00',NULL,'248',2025316.70,2025316.70,'248','2020-02-12 18:32:19','248','2020-02-12 18:33:07',10,0),('1','64',124874,'MORNING SHIFT','2020-02-08','2020-02-08 00:00:00',NULL,'248',1411745.00,1411745.00,'248','2020-02-12 18:37:03','248','2020-02-12 18:37:40',10,0),('1','64',124875,'AFTERNOON SHIFT','2020-02-08','2020-02-08 00:00:00',NULL,'248',2091659.70,2091659.70,'248','2020-02-16 19:57:30','248','2020-02-16 19:57:56',10,0),('1','64',125414,'MORNING SHIFT','2020-02-09','2020-02-09 00:00:00',NULL,'248',1224851.70,1224851.70,'248','2020-02-16 20:05:14','248','2020-02-16 20:05:44',10,0),('1','64',125415,'AFTERNOON SHIFT','2020-02-09','2020-02-09 00:00:00',NULL,'248',2032287.10,2032287.10,'248','2020-02-16 20:08:41','248','2020-02-16 20:09:05',10,0),('1','64',125416,'MORNING SHIFT','2020-02-10','2020-02-10 00:00:00',NULL,'248',1115754.70,1115754.70,'248','2020-02-17 10:12:24','248','2020-02-17 10:12:58',10,0),('1','64',125462,'AFTERNOON SHIFT','2020-02-10','2020-02-10 00:00:00',NULL,'248',2193683.40,2193683.40,'248','2020-02-17 10:15:42','248','2020-02-17 10:16:10',10,0),('1','64',125464,'MORNING SHIFT','2020-02-11','2020-02-11 00:00:00',NULL,'248',1367888.50,1367888.50,'248','2020-02-17 10:26:10','248','2020-02-17 10:27:59',10,0),('1','64',125470,'AFTERNOON SHIFT','2020-02-11','2020-02-11 00:00:00',NULL,'248',2114506.30,2114506.30,'248','2020-02-17 19:40:34','248','2020-02-17 19:42:27',10,0),('1','64',125572,'MORNING SHIFT','2020-02-12','2020-02-12 00:00:00',NULL,'248',1184530.80,1184530.80,'248','2020-02-17 19:46:47','248','2020-02-17 19:47:23',10,0),('1','64',125573,'AFTERNOON SHIFT','2020-02-12','2020-02-12 00:00:00',NULL,'248',1859274.70,1859274.70,'248','2020-02-17 19:49:50','248','2020-02-17 19:50:18',10,0),('1','64',125574,'MORNING SHIFT','2020-02-13','2020-02-13 00:00:00',NULL,'248',1164773.80,1164773.80,'248','2020-02-17 19:57:03','248','2020-02-17 19:58:35',10,0),('1','64',125575,'AFTERNOON SHIFT','2020-02-13','2020-02-13 00:00:00',NULL,'248',2052084.10,2052084.10,'248','2020-02-17 20:01:27','248','2020-02-17 20:01:55',10,0),('1','64',125576,'MORNING SHIFT','2020-02-14','2020-02-14 00:00:00',NULL,'248',1231058.60,1231058.60,'248','2020-02-18 09:33:45','248','2020-02-18 09:36:02',10,0),('1','64',125610,'AFTERNOON SHIFT','2020-02-14','2020-02-14 00:00:00',NULL,'248',2064475.00,2064475.00,'248','2020-02-18 09:43:07','248','2020-02-18 10:22:20',10,0),('1','64',125621,'MORNING SHIFT','2020-02-15','2020-02-15 00:00:00',NULL,'248',1214599.30,1214599.30,'248','2020-02-18 10:27:13','248','2020-02-18 10:28:19',10,0),('1','64',125624,'AFTERNOON SHIFT','2020-02-15','2020-02-15 00:00:00',NULL,'248',2296572.00,2296572.00,'248','2020-02-18 10:35:50','248','2020-02-18 10:37:07',10,0),('1','64',125625,'MORNING SHIFT','2020-02-16','2020-02-16 00:00:00',NULL,'248',1197856.70,1197856.70,'248','2020-02-18 10:44:36','248','2020-02-18 11:11:02',10,0),('1','64',125633,'AFTERNOON SHIFT','2020-02-16','2020-02-16 00:00:00',NULL,'248',1977293.90,1977293.90,'248','2020-02-18 11:45:48','248','2020-02-18 11:46:29',10,0),('1','64',125638,'MORNING SHIFT','2020-02-17','2020-02-17 00:00:00',NULL,'248',1201742.70,1201742.70,'248','2020-02-18 12:14:11','248','2020-02-18 12:14:42',10,0),('1','64',125643,'AFTERNOON SHIFT','2020-02-17','2020-02-17 00:00:00',NULL,'248',2035679.50,2035679.50,'248','2020-02-18 12:29:23','248','2020-02-18 12:29:57',10,0),('1','64',125644,'MORNING SHIFT','2020-02-18','2020-02-18 00:00:00',NULL,'248',1252411.20,1252411.20,'248','2020-02-20 13:33:17','248','2020-02-20 13:34:04',10,0),('1','64',125920,'AFTERNOON SHIFT','2020-02-18','2020-02-18 00:00:00',NULL,'248',2076484.20,2076484.20,'248','2020-02-20 13:37:05','248','2020-02-20 13:38:11',10,0),('1','64',125921,'MORNING SHIFT','2020-02-19','2020-02-19 00:00:00',NULL,'248',1640195.60,1640195.60,'248','2020-02-20 14:42:58','248','2020-02-20 14:43:36',10,0),('1','64',125936,'AFTERNOON SHIFT','2020-02-19','2020-02-19 00:00:00',NULL,'248',2051468.50,2051468.50,'248','2020-02-20 14:46:43','248','2020-02-20 14:47:09',10,0),('1','64',125937,'MORNING SHIFT','2020-02-20','2020-02-20 00:00:00',NULL,'248',1341253.10,1341253.10,'248','2020-02-24 08:54:58','248','2020-02-24 08:55:24',10,0),('1','64',126312,'AFTERNOON SHIFT','2020-02-20','2020-02-20 00:00:00',NULL,'248',2051551.80,2051551.80,'248','2020-02-24 09:02:57','248','2020-02-24 09:03:59',10,0),('1','64',126313,'MORNING SHIFT','2020-02-21','2020-02-21 00:00:00',NULL,'248',1500467.60,1500467.60,'248','2020-02-24 09:07:28','248','2020-02-24 09:08:02',10,0),('1','64',126314,'AFTERNOON SHIFT','2020-02-21','2020-02-21 00:00:00',NULL,'248',2079878.00,2079878.00,'248','2020-02-24 09:12:30','248','2020-02-24 09:13:06',10,0),('1','64',126317,'MORNING SHIFT','2020-02-22','2020-02-22 00:00:00',NULL,'248',1414596.60,1414596.60,'248','2020-02-24 09:18:36','248','2020-02-24 09:19:15',10,0),('1','64',126322,'AFTERNOON SHIFT','2020-02-22','2020-02-22 00:00:00',NULL,'248',1777166.30,1777166.30,'248','2020-02-24 09:27:03','248','2020-02-24 09:27:38',10,0),('1','64',126323,'MORNING SHIFT','2020-02-23','2020-02-23 00:00:00',NULL,'248',1066056.20,1066056.20,'248','2020-02-24 09:31:47','248','2020-02-24 09:35:30',10,0),('1','64',126326,'AFTERNOON SHIFT','2020-02-23','2020-02-23 00:00:00',NULL,'248',1567663.50,1567663.50,'248','2020-02-24 11:13:54','248','2020-02-24 11:14:33',10,0),('1','64',126348,'MORNING SHIFT','2020-02-24','2020-02-24 00:00:00',NULL,'248',1435670.70,1435670.70,'248','2020-02-26 20:06:22','248','2020-02-26 20:06:48',10,0),('1','64',126718,'MORNING SHIFT','2020-02-24','2020-02-24 00:00:00',NULL,'248',2210303.10,2210303.10,'248','2020-02-26 20:08:58','248','2020-02-26 20:09:26',10,0),('1','64',126719,'MORNING SHIFT','2020-02-25','2020-02-25 00:00:00',NULL,'248',1210440.20,1210440.20,'248','2020-02-27 09:02:01','248','2020-02-27 09:02:28',10,0),('1','64',126739,'AFTERNOON SHIFT','2020-02-25','2020-02-25 00:00:00',NULL,'248',1800710.80,1800710.80,'248','2020-02-27 09:05:55','248','2020-02-27 09:08:51',10,0),('1','64',126742,'MORNING SHIFT','2020-02-26','2020-02-26 00:00:00',NULL,'248',1242862.20,1242862.20,'248','2020-02-27 09:12:48','248','2020-02-27 09:14:28',10,0),('1','64',126744,'AFTERNOON SHIFT','2020-02-26','2020-02-26 00:00:00',NULL,'248',190890.00,190890.00,'248','2020-02-27 09:15:48','248','2020-02-27 09:16:12',10,0),('1','64',126745,'PRICE CHANGE SHIFT','2020-02-26','2020-02-26 00:00:00',NULL,'248',1874348.80,1874348.80,'248','2020-02-27 09:20:57','248','2020-02-27 09:21:56',10,0),('1','64',126747,'MORNING SHIFT','2020-02-27','2020-02-27 00:00:00',NULL,'248',1221598.94,1221598.94,'248','2020-02-27 14:34:33','248','2020-02-27 14:37:27',10,0),('1','64',126882,'AFTERNOON SHIFT','2020-02-27','2020-02-27 00:00:00',NULL,'248',2129893.70,2129893.70,'248','2020-02-28 10:18:08','248','2020-02-28 10:19:16',10,0),('1','64',126886,'MORNING SHIFT','2020-02-28','2020-02-28 00:00:00',NULL,'248',1045274.30,1045274.30,'248','2020-03-02 09:12:15','248','2020-03-02 09:12:59',10,0),('1','64',127266,'AFTERNOON SHIFT','2020-02-28','2020-02-28 00:00:00',NULL,'248',2073773.90,2073773.90,'248','2020-03-02 09:20:17','248','2020-03-02 09:20:47',10,0),('1','64',127268,'MORNING SHIFT','2020-02-29','2020-02-29 00:00:00',NULL,'248',1170405.50,1170405.50,'248','2020-03-02 09:25:28','248','2020-03-02 09:25:57',10,0),('1','64',127270,'AFTERNOON SHIFT','2020-02-29','2020-02-29 00:00:00',NULL,'248',2000635.80,2000635.80,'248','2020-03-02 09:32:08','248','2020-03-02 09:32:34',10,0),('1','64',127272,'MORNING SHIFT','2020-03-01','2020-03-01 00:00:00',NULL,'248',1198335.20,1198335.20,'248','2020-03-02 09:36:53','248','2020-03-02 09:37:26',10,0),('1','64',127273,'AFTERNOON SHIFT','2020-03-01','2020-03-01 00:00:00',NULL,'248',1655228.80,1655228.80,'248','2020-03-02 09:40:29','248','2020-03-02 09:41:06',10,0),('1','64',127274,'MORNING SHIFT','2020-03-02','2020-03-02 00:00:00',NULL,'248',1201890.80,1201890.80,'248','2020-03-06 09:45:38','248','2020-03-06 09:46:24',10,0),('1','64',127745,'AFTERNOON SHIFT','2020-03-02','2020-03-02 00:00:00',NULL,'248',2142883.40,2142883.40,'248','2020-03-06 09:48:48','248','2020-03-06 09:49:18',10,0),('1','64',127746,'MORNING SHIFT','2020-03-03','2020-03-03 00:00:00',NULL,'248',1559389.30,1559389.30,'248','2020-03-06 09:53:02','248','2020-03-06 09:54:06',10,0),('1','64',127747,'AFTERNOON SHIFT','2020-03-03','2020-03-03 00:00:00',NULL,'248',2275180.90,2275180.90,'248','2020-03-11 07:46:24','248','2020-03-11 07:46:51',10,0),('1','64',128295,'MORNING SHIFT','2020-03-04','2020-03-04 00:00:00',NULL,'248',1331331.10,1331331.10,'248','2020-03-11 07:49:49','248','2020-03-11 07:50:36',10,0),('1','64',128296,'AFTERNOON SHIFT','2020-03-04','2020-03-04 00:00:00',NULL,'248',1914976.50,1914976.50,'248','2020-03-11 07:54:53','248','2020-03-11 07:55:22',10,0),('1','64',128297,'MORNING SHIFT','2020-03-05','2020-03-05 00:00:00',NULL,'248',1341369.10,1341369.10,'248','2020-03-11 08:16:34','248','2020-03-11 08:17:01',10,0),('1','64',128301,'AFTERNOON SHIFT','2020-03-05','2020-03-05 00:00:00',NULL,'248',2029149.60,2029149.60,'248','2020-03-11 10:29:19','248','2020-03-11 10:29:53',10,0),('1','64',128333,'MORNING SHIFT','2020-03-06','2020-03-06 00:00:00',NULL,'248',1514066.80,1522151.80,'248','2020-03-11 10:51:41','248','2020-03-11 10:52:18',10,0),('1','64',128334,'AFTERNOON SHIFT','2020-03-06','2020-03-06 00:00:00',NULL,'248',1735151.50,1741021.50,'248','2020-03-11 10:58:15','248','2020-03-11 11:00:31',10,0),('1','64',128336,'MORNING SHIFT','2020-03-07','2020-03-07 00:00:00',NULL,'248',1333131.50,1336626.50,'248','2020-03-11 11:06:52','248','2020-03-11 11:07:48',10,0),('1','64',128338,'AFTERNOON SHIFT','2020-03-07','2020-03-07 00:00:00',NULL,'248',2154994.80,2155994.80,'248','2020-03-11 11:21:50','248','2020-03-11 11:22:28',10,0),('1','64',128351,'MORNING SHIFT','2020-03-08','2020-03-08 00:00:00',NULL,'248',1143382.50,1143382.50,'248','2020-03-11 11:32:56','248','2020-03-11 11:34:20',10,0),('1','64',128352,'AFTERNOON SHIFT','2020-03-08','2020-03-08 00:00:00',NULL,'248',1773887.60,1773887.60,'248','2020-03-11 11:37:32','248','2020-03-11 11:38:07',10,0),('1','64',128353,'MORNING SHIFT','2020-03-09','2020-03-09 00:00:00',NULL,'248',1102214.60,1102214.60,'248','2020-03-11 11:54:11','248','2020-03-11 11:54:47',10,0),('1','64',128357,'AFTERNOON SHIFT','2020-03-09','2020-03-09 00:00:00',NULL,'248',1778221.20,1778221.20,'248','2020-03-11 12:10:52','248','2020-03-11 12:11:26',10,0),('1','64',128361,'MORNING SHIFT','2020-03-10','2020-03-10 00:00:00',NULL,'248',1198165.10,1198165.10,'248','2020-03-11 19:54:08','248','2020-03-11 19:54:43',10,0),('1','64',128410,'AFTERNOON SHIFT','2020-03-10','2020-03-10 00:00:00',NULL,'248',1901722.00,1901722.00,'248','2020-03-11 20:16:01','248','2020-03-11 20:16:31',10,0),('1','64',128411,'MORNING SHIFT','2020-03-11','2020-03-11 00:00:00',NULL,'248',1459755.50,1459755.50,'248','2020-03-11 20:22:29','248','2020-03-11 20:23:13',10,0),('1','64',128412,'AFTERNOON SHIFT','2020-03-11','2020-03-11 00:00:00',NULL,'248',1839385.20,1839385.20,'248','2020-03-18 09:45:02','248','2020-03-18 09:45:51',10,0),('1','64',129259,'MORNING SHIFT','2020-03-12','2020-03-12 00:00:00',NULL,'248',1270194.50,1270194.50,'248','2020-03-18 09:49:35','248','2020-03-18 09:50:10',10,0),('1','64',129260,'AFTERNOON SHIFT','2020-03-12','2020-03-12 00:00:00',NULL,'248',1953980.70,1953980.70,'248','2020-03-18 09:53:26','248','2020-03-18 09:54:00',10,0),('1','64',129261,'MORNING SHIFT','2020-03-13','2020-03-13 00:00:00',NULL,'248',1227076.90,1227076.90,'248','2020-03-18 10:00:30','248','2020-03-18 10:01:54',10,0),('1','64',129263,'AFTERNOON SHIFT','2020-03-13','2020-03-13 00:00:00',NULL,'248',2115800.60,2115800.60,'248','2020-03-18 10:06:57','248','2020-03-18 10:08:57',10,0),('1','64',129264,'MORNING SHIFT','2020-03-14','2020-03-14 00:00:00',NULL,'248',1371000.70,1371000.70,'248','2020-03-18 10:19:28','248','2020-03-18 10:20:05',10,0),('1','64',129266,'AFTERNOON SHIFT','2020-03-14','2020-03-14 00:00:00',NULL,'248',1900390.70,1900390.70,'248','2020-03-21 16:19:21','248','2020-03-21 16:19:44',10,0),('1','64',129745,'MORNING SHIFT','2020-03-15','2020-03-15 00:00:00',NULL,'248',993628.30,993628.30,'248','2020-03-21 16:22:09','248','2020-03-21 16:22:29',10,0),('1','64',129746,'AFTERNOON SHIFT','2020-03-15','2020-03-15 00:00:00',NULL,'248',1494825.40,1494825.40,'248','2020-03-21 16:26:38','248','2020-03-21 16:27:13',10,0),('1','64',129747,'MORNING SHIFT','2020-03-16','2020-03-16 00:00:00',NULL,'248',958093.00,958093.00,'248','2020-03-21 16:30:19','248','2020-03-21 16:31:38',10,0),('1','64',129750,'AFTERNOON SHIFT','2020-03-16','2020-03-16 00:00:00',NULL,'248',1878307.80,1878307.80,'248','2020-03-21 16:34:17','248','2020-03-21 16:34:43',10,0),('1','64',129752,'MORNING SHIFT','2020-03-17','2020-03-17 00:00:00',NULL,'248',1255685.40,1255685.40,'248','2020-03-21 16:37:12','248','2020-03-21 16:37:37',10,0),('1','64',129753,'AFTERNOON SHIFT','2020-03-17','2020-03-17 00:00:00',NULL,'248',1985952.10,1985952.10,'248','2020-03-21 16:46:48','248','2020-03-21 16:47:18',10,0),('1','64',129756,'MORNING SHIFT','2020-03-18','2020-03-18 00:00:00',NULL,'248',1579841.10,1579841.10,'248','2020-03-21 16:54:23','248','2020-03-21 16:54:51',10,0),('1','64',129757,'AFTERNOON SHIFT','2020-03-18','2020-03-18 00:00:00',NULL,'248',2298932.70,2298932.70,'248','2020-03-21 16:57:30','248','2020-03-21 16:58:03',10,0),('1','64',129758,'MORNING SHIFT','2020-03-19','2020-03-19 00:00:00',NULL,'248',16302.00,16302.00,'248','2020-03-21 16:59:51','248','2020-03-21 17:00:15',10,0),('1','64',129759,'PRICE CHANGE SHIFT','2020-03-19','2020-03-19 00:00:00',NULL,'248',1111596.80,1111596.80,'248','2020-03-21 17:03:57','248','2020-03-21 17:05:07',10,0),('1','64',129760,'AFTERNOON SHIFT','2020-03-19','2020-03-19 00:00:00',NULL,'248',2494179.50,2494179.50,'248','2020-03-21 17:11:10','248','2020-03-21 17:11:43',10,0),('1','64',129761,'MORNING SHIFT','2020-03-20','2020-03-20 00:00:00',NULL,'248',1714432.70,1714432.70,'248','2020-03-21 17:42:31','248','2020-03-21 17:43:05',10,0),('1','64',129767,'AFTERNOON SHIFT','2020-03-20','2020-03-20 00:00:00',NULL,'248',3062322.00,3062322.00,'248','2020-03-21 17:46:17','248','2020-03-21 17:46:47',10,0),('1','64',129768,'MORNING SHIFT','2020-03-21','2020-03-21 00:00:00',NULL,'248',2260668.20,2260668.20,'248','2020-03-21 17:51:45','248','2020-03-21 17:52:19',10,0),('1','64',129769,'AFTERNOON SHIFT','2020-03-21','2020-03-21 00:00:00',NULL,'248',2963969.90,2963969.90,'248','2020-03-23 12:34:31','248','2020-03-23 12:35:02',10,0),('1','64',129937,'MORNING SHIFT','2020-03-22','2020-03-22 00:00:00',NULL,'248',1708025.20,1708025.20,'248','2020-03-23 12:38:14','248','2020-03-23 12:38:45',10,0),('1','64',129939,'AFTERNOON SHIFT','2020-03-22','2020-03-22 00:00:00',NULL,'248',1025444.40,1025444.40,'248','2020-03-23 12:44:47','248','2020-03-23 12:45:19',10,0),('1','64',129942,'MORNING SHIFT','2020-03-23','2020-03-23 00:00:00',NULL,'248',1159368.90,1159368.90,'248','2020-03-28 15:24:42','248','2020-03-28 15:25:13',10,0),('1','64',130577,'AFTERNOON SHIFT','2020-03-23','2020-03-23 00:00:00',NULL,'248',1002319.90,1002319.90,'248','2020-03-28 15:28:01','248','2020-03-28 15:28:32',10,0),('1','64',130578,'MORNING SHIFT','2020-03-24','2020-03-24 00:00:00',NULL,'248',1874431.50,1874431.50,'248','2020-03-28 15:31:30','248','2020-03-28 15:32:05',10,0),('1','64',130580,'AFTERNOON SHIFT','2020-03-24','2020-03-24 00:00:00',NULL,'248',2644177.80,2644177.80,'248','2020-03-28 15:36:14','248','2020-03-28 15:37:00',10,0),('1','64',130582,'MORNING SHIFT','2020-03-25','2020-03-25 00:00:00',NULL,'248',1574197.70,1574197.70,'248','2020-03-28 15:39:40','248','2020-03-28 15:40:26',10,0),('1','64',130585,'AFTERNOON SHIFT','2020-03-25','2020-03-25 00:00:00',NULL,'248',2039732.20,2039732.20,'248','2020-03-28 15:42:57','248','2020-03-28 15:43:40',10,0),('1','64',130586,'MORNING SHIFT','2020-03-26','2020-03-26 00:00:00',NULL,'248',271700.50,271700.50,'248','2020-03-28 15:46:07','248','2020-03-28 15:46:37',10,0),('1','64',130587,'AFTERNOON SHIFT','2020-03-26','2020-03-26 00:00:00',NULL,'248',265803.50,265803.50,'248','2020-03-28 15:48:51','248','2020-03-28 15:49:24',10,0),('1','64',130589,'MORNING SHIFT','2020-03-27','2020-03-27 00:00:00',NULL,'248',247099.50,247099.50,'248','2020-03-28 15:50:57','248','2020-03-28 15:51:58',10,0),('1','64',130591,'AFTERNOON SHIFT','2020-03-27','2020-03-27 00:00:00',NULL,'248',193877.30,193877.30,'248','2020-03-28 15:54:43','248','2020-03-28 15:55:22',10,0),('1','64',130593,'MORNING SHIFT','2020-03-28','2020-03-28 00:00:00',NULL,'248',1167365.80,1167365.80,'248','2020-03-28 16:03:47','248','2020-03-28 16:04:17',10,0),('1','64',130596,'AFTERNOON SHIFT','2020-03-28','2020-03-28 00:00:00',NULL,'248',1716175.60,1716175.60,'248','2020-04-01 15:54:43','248','2020-04-01 15:55:13',10,0),('1','64',131017,'MORNING SHIFT','2020-03-29','2020-03-29 00:00:00',NULL,'248',881707.10,881707.10,'248','2020-04-01 16:26:18','248','2020-04-01 16:26:47',10,0),('1','64',131023,'AFTERNOON SHIFT','2020-03-29','2020-03-29 00:00:00',NULL,'248',1158771.30,1158771.30,'248','2020-04-01 16:31:54','248','2020-04-01 16:32:22',10,0),('1','64',131024,'MORNING SHIFT','2020-03-30','2020-03-30 00:00:00',NULL,'248',1104451.40,1104451.40,'248','2020-04-01 16:34:53','248','2020-04-01 16:35:40',10,0),('1','64',131028,'AFTERNOON SHIFT','2020-03-30','2020-03-30 00:00:00',NULL,'248',1139390.80,1139390.80,'248','2020-04-01 16:40:14','248','2020-04-01 16:40:47',10,0),('1','64',131030,'MORNING SHIFT','2020-03-31','2020-03-31 00:00:00',NULL,'248',108002.20,108002.20,'248','2020-04-01 16:44:07','248','2020-04-01 16:44:41',10,0),('1','64',131033,'AFTERNOON SHIFT','2020-03-31','2020-03-31 00:00:00',NULL,'248',592099.60,592099.60,'248','2020-04-01 16:51:19','248','2020-04-01 16:51:48',10,0),('1','64',131036,'MORNING SHIFT','2020-04-01','2020-04-01 00:00:00',NULL,'248',751947.20,751947.20,'248','2020-04-01 16:56:13','248','2020-04-01 16:56:47',10,0),('1','64',131037,'AFTERNOON SHIFT','2020-04-01','2020-04-01 00:00:00',NULL,'248',1538134.10,1538134.10,'248','2020-04-07 23:53:34','248','2020-04-07 23:54:16',10,0),('1','64',131766,'MORNING SHIFT','2020-04-02','2020-04-02 00:00:00',NULL,'248',881095.20,881095.20,'248','2020-04-08 00:00:01','248','2020-04-08 00:00:38',10,0),('1','64',131767,'AFTERNOON SHIFT','2020-04-02','2020-04-02 00:00:00',NULL,'248',1347995.50,1347995.50,'248','2020-04-08 00:09:20','248','2020-04-08 00:11:30',10,0),('1','64',131768,'MORNING SHIFT','2020-04-03','2020-04-03 00:00:00',NULL,'248',885583.10,885583.10,'248','2020-04-08 00:17:48','248','2020-04-08 00:18:57',10,0),('1','64',131769,'AFTERNOON SHIFT','2020-04-03','2020-04-03 00:00:00',NULL,'248',1408702.10,1408702.10,'248','2020-04-08 00:49:02','248','2020-04-08 00:50:47',10,0),('1','64',131770,'MORNING SHIFT','2020-04-04','2020-04-04 00:00:00',NULL,'248',844560.40,844560.40,'248','2020-04-08 00:55:22','248','2020-04-08 00:55:47',10,0),('1','64',131771,'AFTERNOON SHIFT','2020-04-04','2020-04-04 00:00:00',NULL,'248',1683031.40,1683031.40,'248','2020-04-08 01:00:47','248','2020-04-08 01:01:14',10,0),('1','64',131772,'MORNING SHIFT','2020-04-05','2020-04-05 00:00:00',NULL,'248',595944.10,595944.10,'248','2020-04-08 23:29:30','248','2020-04-08 23:29:55',10,0),('1','64',131889,'AFTERNOON SHIFT','2020-04-05','2020-04-05 00:00:00',NULL,'248',1316775.00,1316775.00,'248','2020-04-08 23:32:59','248','2020-04-08 23:33:27',10,0),('1','64',131890,'MORNING SHIFT','2020-04-06','2020-04-06 00:00:00',NULL,'248',994250.00,994250.00,'248','2020-04-08 23:38:01','248','2020-04-08 23:38:26',10,0),('1','64',131891,'AFTERNOON SHIFT','2020-04-06','2020-04-06 00:00:00',NULL,'248',1391875.00,1391875.00,'248','2020-04-08 23:42:02','248','2020-04-08 23:42:44',10,0),('1','64',131892,'MORNING SHIFT','2020-04-07','2020-04-07 00:00:00',NULL,'248',965275.00,965275.00,'248','2020-04-08 23:46:05','248','2020-04-08 23:46:44',10,0),('1','64',131893,'AFTERNOON SHIFT','2020-04-07','2020-04-07 00:00:00',NULL,'248',1586625.00,1586625.00,'248','2020-04-08 23:59:02','248','2020-04-09 00:00:07',10,0),('1','64',131894,'MORNING SHIFT','2020-04-08','2020-04-08 00:00:00',NULL,'248',776975.00,776975.00,'248','2020-04-09 00:08:27','248','2020-04-09 00:09:14',10,0),('1','64',131895,'AFTERNOON SHIFT','2020-04-08','2020-04-08 00:00:00',NULL,'248',1142225.00,1142225.00,'248','2020-04-09 15:21:11','248','2020-04-09 15:21:40',10,0),('1','64',131984,'MORNING SHIFT','2020-04-09','2020-04-09 00:00:00',NULL,'248',699700.00,699700.00,'248','2020-04-09 15:46:56','248','2020-04-09 15:47:57',10,0),('1','64',131991,'AFTERNOON SHIFT','2020-04-09','2020-04-09 00:00:00',NULL,'248',1368425.00,1368425.00,'248','2020-04-10 12:20:47','248','2020-04-10 12:21:21',10,0),('1','64',132055,'MORNING SHIFT','2020-04-10','2020-04-10 00:00:00',NULL,'248',532500.00,532500.00,'248','2020-04-11 19:58:01','248','2020-04-11 19:58:31',10,0),('1','64',132205,'AFTERNOON SHIFT','2020-04-10','2020-04-10 00:00:00',NULL,'248',1112250.00,1112250.00,'248','2020-04-11 20:01:47','248','2020-04-11 20:02:44',10,0),('1','64',132206,'MORNING SHIFT','2020-04-11','2020-04-11 00:00:00',NULL,'248',638450.00,638450.00,'248','2020-04-11 20:07:08','248','2020-04-11 20:07:54',10,0),('1','64',132207,'AFTERNOON SHIFT','2020-04-11','2020-04-11 00:00:00',NULL,'248',1409125.00,1409125.00,'248','2020-04-21 11:27:41','248','2020-04-21 11:29:02',10,0),('1','64',133130,'MORNING SHIFT','2020-04-12','2020-04-12 00:00:00',NULL,'248',602750.00,602750.00,'248','2020-04-21 15:26:57','248','2020-04-21 15:27:32',10,0),('1','64',133172,'AFTERNOON SHIFT','2020-04-12','2020-04-12 00:00:00',NULL,'248',908875.00,908875.00,'248','2020-04-21 15:31:32','248','2020-04-21 15:32:17',10,0),('1','64',133173,'MORNING SHIFT','2020-04-13','2020-04-13 00:00:00',NULL,'248',815650.00,815650.00,'248','2020-04-21 15:41:37','248','2020-04-21 15:42:55',10,0),('1','64',133176,'AFTERNOON SHIFT','2020-04-13','2020-04-13 00:00:00',NULL,'248',1206125.00,1206125.00,'248','2020-04-21 15:58:40','248','2020-04-21 15:59:23',10,0),('1','64',133179,'MORNING SHIFT','2020-04-14','2020-04-14 00:00:00',NULL,'248',746475.00,746475.00,'248','2020-04-22 15:03:30','248','2020-04-22 15:04:04',10,0),('1','64',133289,'AFTERNOON SHIFT','2020-04-14','2020-04-14 00:00:00',NULL,'248',1492250.00,1492250.00,'248','2020-04-22 15:06:51','248','2020-04-22 15:07:19',10,0),('1','64',133290,'MORNING SHIFT','2020-04-15','2020-04-15 00:00:00',NULL,'248',926350.00,926350.00,'248','2020-04-23 16:40:19','248','2020-04-23 16:41:01',10,0),('1','64',133403,'AFTERNOON SHIFT','2020-04-15','2020-04-15 00:00:00',NULL,'248',1442725.00,1442725.00,'248','2020-04-23 16:44:38','248','2020-04-23 16:45:37',10,0),('1','64',133404,'MORNING SHIFT','2020-04-16','2020-04-16 00:00:00',NULL,'248',846975.00,846975.00,'248','2020-04-23 16:48:56','248','2020-04-23 16:49:47',10,0),('1','64',133405,'AFTERNOON SHIFT','2020-04-16','2020-04-16 00:00:00',NULL,'248',1372925.00,1372925.00,'248','2020-04-23 16:58:56','248','2020-04-23 16:59:35',10,0),('1','64',133408,'MORNING SHIFT','2020-04-17','2020-04-17 00:00:00',NULL,'248',990575.00,990575.00,'248','2020-04-25 10:24:14','248','2020-04-25 10:24:42',10,0),('1','64',133556,'AFTERNOON SHIFT','2020-04-17','2020-04-17 00:00:00',NULL,'248',1324750.00,1324750.00,'248','2020-04-25 10:31:22','248','2020-04-25 10:32:09',10,0),('1','64',133558,'MORNING SHIFT','2020-04-18','2020-04-18 00:00:00',NULL,'248',799425.00,799425.00,'248','2020-04-25 10:36:27','248','2020-04-25 10:37:01',10,0),('1','64',133560,'AFTERNOON SHIFT','2020-04-18','2020-04-18 00:00:00',NULL,'248',1452800.00,1452800.00,'248','2020-04-25 10:42:53','248','2020-04-25 10:43:35',10,0),('1','64',133564,'MORNING SHIFT','2020-04-19','2020-04-19 00:00:00',NULL,'248',601725.00,601725.00,'248','2020-04-25 10:52:26','248','2020-04-25 10:56:17',10,0),('1','64',133568,'AFTERNOON SHIFT','2020-04-19','2020-04-19 00:00:00',NULL,'248',1096900.00,1096900.00,'248','2020-04-25 11:03:39','248','2020-04-25 11:07:02',10,0),('1','64',133571,'MORNING SHIFT','2020-04-20','2020-04-20 00:00:00',NULL,'248',742200.00,742200.00,'248','2020-04-25 11:27:29','248','2020-04-25 11:44:58',10,0),('1','64',133584,'AFTERNOON SHIFT','2020-04-20','2020-04-20 00:00:00',NULL,'248',1346875.00,1346875.00,'248','2020-04-25 12:05:59','248','2020-04-25 12:06:33',10,0),('1','64',133588,'MORNING SHIFT','2020-04-21','2020-04-21 00:00:00',NULL,'248',716925.00,716925.00,'248','2020-04-25 12:09:33','248','2020-04-25 12:10:27',10,0),('1','64',133591,'AFTERNOON SHIFT','2020-04-21','2020-04-21 00:00:00',NULL,'248',1369575.00,1369575.00,'248','2020-04-25 12:38:54','248','2020-04-25 12:39:32',10,0),('1','64',133595,'MORNING SHIFT','2020-04-22','2020-04-22 00:00:00',NULL,'248',932300.00,932300.00,'248','2020-04-25 12:47:01','248','2020-04-25 12:47:45',10,0),('1','64',133601,'AFTERNOON SHIFT','2020-04-22','2020-04-22 00:00:00',NULL,'248',1430275.00,1430275.00,'248','2020-04-25 12:51:33','248','2020-04-25 12:52:30',10,0),('1','64',133604,'MORNING SHIFT','2020-04-23','2020-04-23 00:00:00',NULL,'248',772750.00,772750.00,'248','2020-04-25 12:56:22','248','2020-04-25 12:56:54',10,0),('1','64',133607,'AFTERNOON SHIFT','2020-04-23','2020-04-23 00:00:00',NULL,'248',1313600.00,1313600.00,'248','2020-04-25 13:03:49','248','2020-04-25 13:04:47',10,0),('1','64',133609,'MORNING SHIFT','2020-04-24','2020-04-24 00:00:00',NULL,'248',625105.00,625105.00,'248','2020-04-25 13:12:36','248','2020-04-25 13:13:01',10,0),('1','64',133612,'AFTERNOON SHIFT','2020-04-24','2020-04-24 00:00:00',NULL,'248',1516730.00,1516730.00,'248','2020-04-25 13:15:42','248','2020-04-25 13:16:21',10,0),('1','64',133613,'MORNING SHIFT','2020-04-25','2020-04-25 00:00:00',NULL,'248',837215.00,837215.00,'248','2020-04-25 13:19:15','248','2020-04-25 13:19:47',10,0),('1','64',133614,'AFTERNOON SHIFT','2020-04-25','2020-04-25 00:00:00',NULL,'248',1150860.00,1150860.00,'248','2020-04-29 10:44:10','248','2020-04-29 10:44:36',10,0),('1','64',134061,'MORNING SHIFT','2020-04-26','2020-04-26 00:00:00',NULL,'248',710325.00,710325.00,'248','2020-04-29 10:48:10','248','2020-04-29 10:48:51',10,0),('1','64',134062,'AFTERNOON SHIFT','2020-04-26','2020-04-26 00:00:00',NULL,'248',782690.00,782690.00,'248','2020-04-29 10:52:42','248','2020-04-29 10:53:22',10,0),('1','64',134063,'MORNING SHIFT','2020-04-27','2020-04-27 00:00:00',NULL,'248',660250.00,660250.00,'248','2020-04-29 10:59:23','248','2020-04-29 11:00:20',10,0),('1','64',134065,'AFTERNOON SHIFT','2020-04-27','2020-04-27 00:00:00',NULL,'248',1223475.00,1223475.00,'248','2020-04-29 11:05:30','248','2020-04-29 11:06:34',10,0),('1','64',134066,'MORNING SHIFT','2020-04-28','2020-04-28 00:00:00',NULL,'248',682305.00,682305.00,'248','2020-04-29 11:09:11','248','2020-04-29 11:09:50',10,0),('1','64',134067,'AFTERNOON SHIFT','2020-04-28','2020-04-28 00:00:00',NULL,'248',1190935.00,1190935.00,'248','2020-04-29 11:14:24','248','2020-04-29 11:15:03',10,0),('1','64',134068,'MORNING SHIFT','2020-04-29','2020-04-29 00:00:00',NULL,'248',735320.55,735320.55,'248','2020-04-29 13:33:31','248','2020-04-29 13:34:15',10,0),('1','64',134095,'AFTERNOON SHIFT','2020-04-29','2020-04-29 00:00:00',NULL,'248',1282745.00,1282745.00,'248','2020-05-05 11:09:10','248','2020-05-05 11:09:51',10,0),('1','64',134458,'MORNING SHIFT','2020-04-30','2020-04-30 00:00:00',NULL,'248',612285.00,612285.00,'248','2020-05-05 11:29:19','248','2020-05-05 11:30:01',10,0),('1','64',134472,'AFTERNOON SHIFT','2020-04-30','2020-04-30 00:00:00',NULL,'248',1241020.00,1241020.00,'248','2020-05-05 12:01:44','248','2020-05-05 12:02:22',10,0),('1','64',134503,'MORNING SHIFT','2020-05-01','2020-05-01 00:00:00',NULL,'248',728115.00,728115.00,'248','2020-05-05 12:07:28','248','2020-05-05 12:09:35',10,0),('1','64',134510,'MORNING SHIFT','2020-05-01','2020-05-01 00:00:00',NULL,'248',1200625.00,1200625.00,'248','2020-05-05 12:14:11','248','2020-05-05 12:14:52',10,0),('1','64',134513,'MORNING SHIFT','2020-05-02','2020-05-02 00:00:00',NULL,'248',627975.00,627975.00,'248','2020-05-05 12:18:42','248','2020-05-05 12:20:52',10,0),('1','64',134516,'AFTERNOON SHIFT','2020-05-02','2020-05-02 00:00:00',NULL,'248',1120450.00,1120450.00,'248','2020-05-05 12:24:01','248','2020-05-05 12:25:04',10,0),('1','64',134518,'MORNING SHIFT','2020-05-03','2020-05-03 00:00:00',NULL,'248',506155.00,506155.00,'248','2020-05-05 12:32:21','248','2020-05-05 12:33:16',10,0),('1','64',134526,'AFTERNOON SHIFT','2020-05-03','2020-05-03 00:00:00',NULL,'248',789900.00,789900.00,'248','2020-05-05 12:37:52','248','2020-05-05 12:38:31',10,0),('1','64',134527,'MORNING SHIFT','2020-05-04','2020-05-04 00:00:00',NULL,'248',861030.00,861030.00,'248','2020-05-05 12:43:25','248','2020-05-05 12:45:25',10,0),('1','64',134530,'AFTERNOON SHIFT','2020-05-04','2020-05-04 00:00:00',NULL,'248',1352645.00,1352645.00,'248','2020-05-05 12:53:03','248','2020-05-05 12:54:35',10,0),('1','64',134534,'MORNING SHIFT','2020-05-05','2020-05-05 00:00:00',NULL,'248',791975.00,791975.00,'248','2020-05-05 13:28:50','248','2020-05-05 13:29:38',10,0),('1','64',134554,'AFTERNOON SHIFT','2020-05-05','2020-05-05 00:00:00',NULL,'248',400920.00,400920.00,'248','2020-05-16 09:47:53','248','2020-05-16 09:48:51',10,0),('1','64',135886,'MORNING SHIFT','2020-05-06','2020-05-06 00:00:00',NULL,'248',759090.00,759090.00,'248','2020-05-16 09:55:10','248','2020-05-16 09:55:48',10,0),('1','64',135887,'AFTERNOON SHIFT','2020-05-06','2020-05-06 00:00:00',NULL,'248',1324135.00,1324135.00,'248','2020-05-16 09:59:14','248','2020-05-16 10:00:12',10,0),('1','64',135888,'MORNING SHIFT','2020-05-07','2020-05-07 00:00:00',NULL,'248',783935.00,783935.00,'248','2020-05-16 10:05:31','248','2020-05-16 10:06:55',10,0),('1','64',135889,'AFTERNOON SHIFT','2020-05-07','2020-05-07 00:00:00',NULL,'248',1351565.00,1351565.00,'248','2020-05-16 10:10:24','248','2020-05-16 10:11:13',10,0),('1','64',135892,'MORNING SHIFT','2020-05-08','2020-05-08 00:00:00',NULL,'248',706745.00,706745.00,'248','2020-05-16 10:31:14','248','2020-05-16 10:35:15',10,0),('1','64',135896,'AFTERNOON SHIFT','2020-05-08','2020-05-08 00:00:00',NULL,'248',1304895.00,1304895.00,'248','2020-05-16 10:39:03','248','2020-05-16 10:46:21',10,0),('1','64',135899,'MORNING SHIFT','2020-05-09','2020-05-09 00:00:00',NULL,'248',785955.00,785955.00,'248','2020-05-16 10:51:27','248','2020-05-16 10:52:14',10,0),('1','64',135900,'AFTERNOON SHIFT','2020-05-09','2020-05-09 00:00:00',NULL,'248',1430780.00,1430780.00,'248','2020-05-16 10:57:23','248','2020-05-16 10:57:56',10,0),('1','64',135901,'MORNING SHIFT','2020-05-10','2020-05-10 00:00:00',NULL,'248',647180.00,647180.00,'248','2020-05-16 11:11:19','248','2020-05-16 11:12:07',10,0),('1','64',135904,'AFTERNOON SHIFT','2020-05-10','2020-05-10 00:00:00',NULL,'248',830780.00,830780.00,'248','2020-05-16 11:19:16','248','2020-05-16 11:22:14',10,0),('1','64',135906,'MORNING SHIFT','2020-05-11','2020-05-11 00:00:00',NULL,'248',927660.00,927660.00,'248','2020-05-16 11:42:38','248','2020-05-16 11:43:03',10,0),('1','64',135911,'AFTERNOON SHIFT','2020-05-11','2020-05-11 00:00:00',NULL,'248',1293140.00,1293140.00,'248','2020-05-16 11:46:14','248','2020-05-16 11:46:51',10,0),('1','64',135913,'MORNING SHIFT','2020-05-12','2020-05-12 00:00:00',NULL,'248',725940.00,725940.00,'248','2020-05-16 11:53:32','248','2020-05-16 11:53:59',10,0),('1','64',135915,'AFTERNOON SHIFT','2020-05-12','2020-05-12 00:00:00',NULL,'248',1156470.00,1156470.00,'248','2020-05-20 13:36:12','248','2020-05-20 13:36:40',10,0),('1','64',136375,'MORNING SHIFT','2020-05-13','2020-05-13 00:00:00',NULL,'248',809435.00,809435.00,'248','2020-05-20 13:39:33','248','2020-05-20 13:41:47',10,0),('1','64',136377,'AFTERNOON SHIFT','2020-05-13','2020-05-13 00:00:00',NULL,'248',1171725.00,1171725.00,'248','2020-05-20 13:54:28','248','2020-05-20 13:56:19',10,0),('1','64',136379,'MORNING SHIFT','2020-05-14','2020-05-14 00:00:00',NULL,'248',834380.00,834380.00,'248','2020-05-20 14:08:36','248','2020-05-20 14:09:18',10,0),('1','64',136381,'AFTERNOON SHIFT','2020-05-14','2020-05-14 00:00:00',NULL,'248',1319095.00,1319095.00,'248','2020-05-20 14:23:23','248','2020-05-20 14:23:56',10,0),('1','64',136386,'MORNING SHIFT','2020-05-15','2020-05-15 00:00:00',NULL,'248',826855.00,826855.00,'248','2020-06-08 08:55:03','248','2020-06-08 08:56:03',10,0),('1','64',138571,'AFTERNOON SHIFT','2020-05-15','2020-05-15 00:00:00',NULL,'248',1390650.00,1390650.00,'248','2020-06-08 08:58:57','248','2020-06-08 08:59:25',10,0),('1','64',138573,'MORNING SHIFT','2020-05-16','2020-05-16 00:00:00',NULL,'248',743935.00,743935.00,'248','2020-06-08 09:05:51','248','2020-06-08 09:06:26',10,0),('1','64',138577,'AFTERNOON SHIFT','2020-05-16','2020-05-16 00:00:00',NULL,'248',1290230.00,1290230.00,'248','2020-06-08 09:10:44','248','2020-06-08 09:11:18',10,0),('1','64',138581,'MORNING SHIFT','2020-05-17','2020-05-17 00:00:00',NULL,'248',587125.00,587125.00,'248','2020-06-08 09:42:19','248','2020-06-08 09:42:55',10,0),('1','64',138586,'AFTERNOON SHIFT','2020-05-17','2020-05-17 00:00:00',NULL,'248',972645.00,972645.00,'248','2020-06-08 09:47:22','248','2020-06-08 09:51:52',10,0),('1','64',138587,'MORNING SHIFT','2020-05-18','2020-05-18 00:00:00',NULL,'248',767535.00,767535.00,'248','2020-06-08 10:01:48','248','2020-06-08 10:03:38',10,0),('1','64',138591,'AFTERNOON SHIFT','2020-05-18','2020-05-18 00:00:00',NULL,'248',1171500.00,1171500.00,'248','2020-06-08 10:08:34','248','2020-06-08 10:09:47',10,0),('1','64',138592,'MORNING SHIFT','2020-05-19','2020-05-19 00:00:00',NULL,'248',719430.00,719430.00,'248','2020-06-08 10:14:50','248','2020-06-08 10:15:19',10,0),('1','64',138594,'AFTERNOON SHIFT','2020-05-19','2020-05-19 00:00:00',NULL,'248',1372620.00,1372620.00,'248','2020-06-08 10:30:19','248','2020-06-08 10:31:04',10,0),('1','64',138596,'MORNING SHIFT','2020-05-20','2020-05-20 00:00:00',NULL,'248',646445.00,646445.00,'248','2020-06-08 10:53:41','248','2020-06-08 10:54:12',10,0),('1','64',138600,'AFTERNOON SHIFT','2020-05-20','2020-05-20 00:00:00',NULL,'248',1144060.00,1144060.00,'248','2020-06-08 10:59:57','248','2020-06-08 11:00:50',10,0),('1','64',138603,'MORNING SHIFT','2020-05-21','2020-05-21 00:00:00',NULL,'248',701475.00,701475.00,'248','2020-06-08 16:38:15','248','2020-06-08 16:39:22',10,0),('1','64',138672,'AFTERNOON SHIFT','2020-05-21','2020-05-21 00:00:00',NULL,'248',1047835.00,1047835.00,'248','2020-06-08 16:41:41','248','2020-06-08 16:42:16',10,0),('1','64',138675,'MORNING SHIFT','2020-05-22','2020-05-22 00:00:00',NULL,'248',840920.00,840920.00,'248','2020-06-08 19:20:01','248','2020-06-08 19:20:31',10,0),('1','64',138690,'AFTERNOON SHIFT','2020-05-22','2020-05-22 00:00:00',NULL,'248',1216575.00,1216575.00,'248','2020-06-08 19:23:44','248','2020-06-08 19:25:55',10,0),('1','64',138691,'MORNING SHIFT','2020-05-23','2020-05-23 00:00:00',NULL,'248',705310.00,705310.00,'248','2020-06-08 19:29:24','248','2020-06-08 19:29:56',10,0),('1','64',138692,'AFTERNOON SHIFT','2020-05-23','2020-05-23 00:00:00',NULL,'248',1161320.00,1161320.00,'248','2020-06-08 19:32:03','248','2020-06-08 19:32:26',10,0),('1','64',138693,'MORNING SHIFT','2020-05-24','2020-05-24 00:00:00',NULL,'248',503625.00,503625.00,'248','2020-06-08 19:34:41','248','2020-06-08 19:35:13',10,0),('1','64',138694,'AFTERNOON SHIFT','2020-05-24','2020-05-24 00:00:00',NULL,'248',803080.00,803080.00,'248','2020-06-08 20:23:55','248','2020-06-08 20:24:41',10,0),('1','64',138695,'MORNING SHIFT','2020-05-25','2020-05-25 00:00:00',NULL,'248',703040.00,703040.00,'248','2020-06-09 08:53:00','248','2020-06-09 08:53:31',10,0),('1','64',138708,'AFTERNOON SHIFT','2020-05-25','2020-05-25 00:00:00',NULL,'248',1372240.00,1372240.00,'248','2020-06-09 09:00:08','248','2020-06-09 09:00:39',10,0),('1','64',138709,'MORNING SHIFT','2020-05-26','2020-05-26 00:00:00',NULL,'248',587315.00,587315.00,'248','2020-06-09 09:03:27','248','2020-06-09 09:04:35',10,0),('1','64',138710,'AFTERNOON SHIFT','2020-05-26','2020-05-26 00:00:00',NULL,'248',1296090.00,1296090.00,'248','2020-06-09 09:07:41','248','2020-06-09 09:58:39',10,0),('1','64',138721,'MORNING SHIFT','2020-05-27','2020-05-27 00:00:00',NULL,'248',733040.00,733040.00,'248','2020-06-09 10:01:53','248','2020-06-09 10:02:35',10,0),('1','64',138723,'AFTERNOON SHIFT','2020-05-27','2020-05-27 00:00:00',NULL,'248',1359985.00,1359985.00,'248','2020-06-09 10:09:22','248','2020-06-09 10:10:13',10,0),('1','64',138728,'MORNING SHIFT','2020-05-28','2020-05-28 00:00:00',NULL,'248',915590.00,915590.00,'248','2020-06-09 10:25:02','248','2020-06-09 10:25:33',10,0),('1','64',138733,'AFTERNOON SHIFT','2020-05-28','2020-05-28 00:00:00',NULL,'248',1182000.00,1182000.00,'248','2020-06-09 10:37:14','248','2020-06-09 10:37:47',10,0),('1','64',138737,'MORNING SHIFT','2020-05-29','2020-05-29 00:00:00',NULL,'248',769270.00,769270.00,'248','2020-06-09 10:41:25','248','2020-06-09 10:41:52',10,0),('1','64',138738,'AFTERNOON SHIFT','2020-05-29','2020-05-29 00:00:00',NULL,'248',1333245.00,1333245.00,'248','2020-06-09 10:44:45','248','2020-06-09 10:46:13',10,0),('1','64',138741,'MORNING SHIFT','2020-05-30','2020-05-30 00:00:00',NULL,'248',866495.00,866495.00,'248','2020-06-09 10:48:52','248','2020-06-09 10:49:21',10,0),('1','64',138744,'AFTERNOON SHIFT','2020-05-30','2020-05-30 00:00:00',NULL,'248',1279850.00,1279850.00,'248','2020-06-09 11:01:51','248','2020-06-09 11:02:22',10,0),('1','64',138748,'MORNING SHIFT','2020-05-31','2020-05-31 00:00:00',NULL,'248',633490.00,633490.00,'248','2020-06-09 11:10:41','248','2020-06-09 11:11:46',10,0),('1','64',138750,'AFTERNOON SHIFT','2020-05-31','2020-05-31 00:00:00',NULL,'248',987880.00,987880.00,'248','2020-06-09 11:14:05','248','2020-06-09 11:14:48',10,0),('1','64',138752,'MORNING SHIFT','2020-06-01','2020-06-01 00:00:00',NULL,'248',703860.00,703860.00,'248','2020-06-09 13:22:18','248','2020-06-09 13:22:51',10,0),('1','64',138784,'AFTERNOON SHIFT','2020-06-01','2020-06-01 00:00:00',NULL,'248',1426330.00,1426330.00,'248','2020-06-09 13:37:32','248','2020-06-09 13:38:07',10,0),('1','64',138787,'MORNING SHIFT','2020-06-02','2020-06-02 00:00:00',NULL,'248',654755.00,654755.00,'248','2020-06-09 14:09:16','248','2020-06-09 14:09:51',10,0),('1','64',138796,'AFTERNOON SHIFT','2020-06-02','2020-06-02 00:00:00',NULL,'248',1368755.00,1368755.00,'248','2020-06-09 14:13:31','248','2020-06-09 14:14:08',10,0),('1','64',138797,'MORNING SHIFT','2020-06-03','2020-06-03 00:00:00',NULL,'248',852527.00,852527.00,'248','2020-06-11 12:23:34','248','2020-06-11 12:25:15',10,0),('1','64',139030,'AFTERNOON SHIFT','2020-06-03','2020-06-03 00:00:00',NULL,'248',1626528.00,1626528.00,'248','2020-06-11 12:27:36','248','2020-06-11 12:28:06',10,0),('1','64',139032,'MORNING SHIFT','2020-06-04','2020-06-04 00:00:00',NULL,'248',887925.50,887925.50,'248','2020-06-11 12:32:43','248','2020-06-11 12:33:15',10,0),('1','64',139034,'AFTERNOON SHIFT','2020-06-04','2020-06-04 00:00:00',NULL,'248',1326717.00,1326717.00,'248','2020-06-11 14:07:14','248','2020-06-11 14:07:56',10,0),('1','64',139058,'MORNING SHIFT','2020-06-05','2020-06-05 00:00:00',NULL,'248',850762.50,850762.50,'248','2020-06-11 14:10:27','248','2020-06-11 14:10:57',10,0),('1','64',139059,'AFTERNOON SHIFT','2020-06-05','2020-06-05 00:00:00',NULL,'248',1417735.00,1417735.00,'248','2020-06-11 14:13:18','248','2020-06-11 14:13:42',10,0),('1','64',139061,'MORNING SHIFT','2020-06-06','2020-06-06 00:00:00',NULL,'248',728281.50,728281.50,'248','2020-06-11 14:15:54','248','2020-06-11 14:16:48',10,0),('1','64',139066,'AFTERNOON SHIFT','2020-06-06','2020-06-06 00:00:00',NULL,'248',1272735.00,1272735.00,'248','2020-06-11 14:20:35','248','2020-06-11 14:21:07',10,0),('1','64',139067,'MORNING SHIFT','2020-06-07','2020-06-07 00:00:00',NULL,'248',577933.50,577933.50,'248','2020-06-11 14:27:23','248','2020-06-11 14:27:53',10,0),('1','64',139071,'AFTERNOON SHIFT','2020-06-07','2020-06-07 00:00:00',NULL,'248',985490.50,985490.50,'248','2020-06-11 14:30:07','248','2020-06-11 14:30:36',10,0),('1','64',139073,'MORNING SHIFT','2020-06-08','2020-06-08 00:00:00',NULL,'248',951068.50,951068.50,'248','2020-06-11 14:33:48','248','2020-06-11 14:34:21',10,0),('1','64',139076,'AFTERNOON SHIFT','2020-06-08','2020-06-08 00:00:00',NULL,'248',1621886.00,1621886.00,'248','2020-06-11 14:47:39','248','2020-06-11 14:48:05',10,0),('1','64',139085,'MORNING SHIFT','2020-06-09','2020-06-09 00:00:00',NULL,'248',857582.50,857582.50,'248','2020-06-12 17:09:17','248','2020-06-12 17:09:49',10,0),('1','64',139230,'AFTERNOON SHIFT','2020-06-09','2020-06-09 00:00:00',NULL,'248',1587273.50,1587273.50,'248','2020-06-12 17:15:36','248','2020-06-12 17:17:04',10,0),('1','64',139231,'MORNING SHIFT','2020-06-10','2020-06-10 00:00:00',NULL,'248',874628.00,874628.00,'248','2020-06-12 17:21:40','248','2020-06-12 17:22:53',10,0),('1','64',139232,'AFTERNOON SHIFT','2020-06-10','2020-06-10 00:00:00',NULL,'248',1529663.00,1529663.00,'248','2020-06-12 17:55:44','248','2020-06-12 17:56:36',10,0),('1','64',139233,'MORNING SHIFT','2020-06-11','2020-06-11 00:00:00',NULL,'248',735035.00,735035.00,'248','2020-06-12 17:59:14','248','2020-06-12 18:01:26',10,0),('1','64',139235,'AFTERNOON SHIFT','2020-06-11','2020-06-11 00:00:00',NULL,'248',1590191.00,1590191.00,'248','2020-06-12 18:08:41','248','2020-06-12 18:09:31',10,0),('1','64',139236,'MORNING SHIFT','2020-06-12','2020-06-12 00:00:00',NULL,'248',721450.00,721450.00,'248','2020-06-12 18:12:18','248','2020-06-12 18:13:13',10,0),('1','64',139237,'AFTERNOON SHIFT','2020-06-12','2020-06-12 00:00:00',NULL,'248',1500595.00,1500595.00,'248','2020-06-16 09:42:54','248','2020-06-16 09:43:35',10,0),('1','64',139609,'MORNING SHIFT','2020-06-13','2020-06-13 00:00:00',NULL,'248',810032.00,810032.00,'248','2020-06-16 09:49:23','248','2020-06-16 09:49:47',10,0),('1','64',139699,'AFTERNOON SHIFT','2020-06-13','2020-06-13 00:00:00',NULL,'248',1222077.50,1222077.50,'248','2020-06-16 20:23:16','248','2020-06-16 20:23:48',10,0),('1','64',139700,'MORNING SHIFT','2020-06-14','2020-06-14 00:00:00',NULL,'248',526475.50,526475.50,'248','2020-06-18 09:39:25','248','2020-06-18 09:39:48',10,0),('1','64',139888,'AFTERNOON SHIFT','2020-06-14','2020-06-14 00:00:00',NULL,'248',1008293.50,1008293.50,'248','2020-06-18 10:00:15','248','2020-06-18 10:00:56',10,0),('1','64',139892,'MORNING SHIFT','2020-06-15','2020-06-15 00:00:00',NULL,'248',718616.50,718616.50,'248','2020-06-18 10:04:06','248','2020-06-18 10:04:40',10,0),('1','64',139893,'AFTERNOON SHIFT','2020-06-15','2020-06-15 00:00:00',NULL,'248',1622331.00,1622331.00,'248','2020-06-18 10:07:17','248','2020-06-18 10:07:51',10,0),('1','64',139894,'MORNING SHIFT','2020-06-16','2020-06-16 00:00:00',NULL,'248',684159.00,684159.00,'248','2020-06-18 10:12:34','248','2020-06-18 10:13:19',10,0),('1','64',139895,'AFTERNOON SHIFT','2020-06-16','2020-06-16 00:00:00',NULL,'248',1459608.00,1459608.00,'248','2020-06-18 10:18:02','248','2020-06-18 10:18:30',10,0),('1','64',139896,'MORNING SHIFT','2020-06-17','2020-06-17 00:00:00',NULL,'248',824258.50,824258.50,'248','2020-06-18 10:22:32','248','2020-06-18 10:22:58',10,0),('1','64',139897,'AFTERNOON SHIFT','2020-06-17','2020-06-17 00:00:00',NULL,'248',1375439.00,1375439.00,'248','2020-06-18 10:25:57','248','2020-06-18 10:26:26',10,0),('1','64',139898,'MORNING SHIFT','2020-06-18','2020-06-18 00:00:00',NULL,'248',571053.00,571053.00,'248','2020-06-18 18:05:46','248','2020-06-18 18:06:12',10,0),('1','64',139965,'AFTERNOON SHIFT','2020-06-18','2020-06-18 00:00:00',NULL,'248',1097198.00,1097198.00,'248','2020-06-19 10:02:25','248','2020-06-19 10:02:47',10,0),('1','64',140005,'MORNING SHIFT','2020-06-19','2020-06-19 00:00:00',NULL,'248',599854.00,599854.00,'248','2020-06-20 07:55:31','248','2020-06-20 07:58:49',10,0),('1','64',140084,'AFTERNOON SHIFT','2020-06-19','2020-06-19 00:00:00',NULL,'248',1627149.00,1627149.00,'248','2020-06-20 19:54:22','248','2020-06-20 19:55:04',10,0),('1','64',140194,'MORNING SHIFT','2020-06-20','2020-06-20 00:00:00',NULL,'248',496868.50,496868.50,'248','2020-06-20 19:58:48','248','2020-06-20 19:59:24',10,0),('1','64',140195,'MORNING SHIFT','2020-06-20','2020-06-20 00:00:00',NULL,'248',1090208.00,1090208.00,'248','2020-06-21 18:02:26','248','2020-06-21 18:03:08',10,0),('1','64',140309,'MORNING SHIFT','2020-06-21','2020-06-21 00:00:00',NULL,'248',621529.50,621529.50,'248','2020-06-21 18:13:05','248','2020-06-21 18:14:14',10,0),('1','64',140312,'AFTERNOON SHIFT','2020-06-21','2020-06-21 00:00:00',NULL,'248',1326058.00,1326058.00,'248','2020-06-24 08:04:56','248','2020-06-24 08:05:46',10,0),('1','64',140577,'MORNING SHIFT','2020-06-22','2020-06-22 00:00:00',NULL,'248',585831.00,585831.00,'248','2020-06-24 08:40:16','248','2020-06-24 08:40:45',10,0),('1','64',140583,'AFTERNOON SHIFT','2020-06-22','2020-06-22 00:00:00',NULL,'248',1700293.00,1700293.00,'248','2020-06-24 08:49:10','248','2020-06-24 08:49:37',10,0),('1','64',140586,'MORNING SHIFT','2020-06-23','2020-06-23 00:00:00',NULL,'248',570006.00,570006.00,'248','2020-06-24 08:52:47','248','2020-06-24 08:53:22',10,0),('1','64',140588,'AFTERNOON SHIFT','2020-06-23','2020-06-23 00:00:00',NULL,'248',1433454.00,1433454.00,'248','2020-06-24 08:59:48','248','2020-06-24 09:00:23',10,0),('1','64',140589,'MORNING SHIFT','2020-06-24','2020-06-24 00:00:00',NULL,'248',692783.00,692783.00,'248','2020-06-27 09:17:52','248','2020-06-27 09:18:26',10,0),('1','64',140972,'AFTERNOON SHIFT','2020-06-24','2020-06-24 00:00:00',NULL,'248',1408596.00,1408596.00,'248','2020-06-27 09:22:08','248','2020-06-27 10:10:24',10,0),('1','64',140984,'MORNING SHIFT','2020-06-25','2020-06-25 00:00:00',NULL,'248',693899.50,693899.50,'248','2020-06-27 10:27:18','248','2020-06-27 10:27:58',10,0),('1','64',140988,'AFTERNOON SHIFT','2020-06-25','2020-06-25 00:00:00',NULL,'248',1361708.00,1361708.00,'248','2020-06-27 10:33:52','248','2020-06-27 10:34:27',10,0),('1','64',140990,'MORNING SHIFT','2020-06-26','2020-06-26 00:00:00',NULL,'248',634931.00,634931.00,'248','2020-06-29 14:30:02','248','2020-06-29 14:30:36',10,0),('1','64',141257,'AFTERNOON SHIFT','2020-06-26','2020-06-26 00:00:00',NULL,'248',1251765.00,1251765.00,'248','2020-06-29 14:44:09','248','2020-06-29 14:45:34',10,0),('1','64',141266,'MORNING SHIFT','2020-06-27','2020-06-27 00:00:00',NULL,'248',576159.50,576159.50,'248','2020-06-29 14:48:53','248','2020-06-29 14:49:30',10,0),('1','64',141269,'AFTERNOON SHIFT','2020-06-27','2020-06-27 00:00:00',NULL,'248',1444037.00,1444037.00,'248','2020-06-29 14:54:48','248','2020-06-29 14:55:15',10,0),('1','64',141272,'MORNING SHIFT','2020-06-28','2020-06-28 00:00:00',NULL,'248',655773.00,655773.00,'248','2020-06-29 15:00:50','248','2020-06-29 15:01:39',10,0),('1','64',141275,'AFTERNOON SHIFT','2020-06-28','2020-06-28 00:00:00',NULL,'248',994768.50,994768.50,'248','2020-06-29 15:04:05','248','2020-06-29 15:05:03',10,0),('1','64',141277,'MORNING SHIFT','2020-06-29','2020-06-29 00:00:00',NULL,'248',701874.00,701874.00,'248','2020-06-29 15:09:29','248','2020-06-29 15:10:03',10,0),('1','64',141279,'AFTERNOON SHIFT','2020-06-29','2020-06-29 00:00:00',NULL,'248',1186665.50,1186665.50,'248','2020-06-30 10:31:53','248','2020-06-30 10:32:13',10,0),('1','64',141351,'MORNING SHIFT','2020-06-30','2020-06-30 00:00:00',NULL,'248',738066.50,738066.50,'248','2020-06-30 16:30:09','248','2020-06-30 16:31:31',10,0),('1','64',141427,'AFTERNOON SHIFT','2020-06-30','2020-06-30 00:00:00',NULL,'248',1187122.00,1187122.00,'248','2020-07-01 10:14:03','248','2020-07-01 10:15:32',10,0),('1','64',141502,'MORNING SHIFT','2020-07-01','2020-07-01 00:00:00',NULL,'248',661521.50,661521.50,'248','2020-07-02 09:38:09','248','2020-07-02 09:38:51',10,0),('1','64',141601,'AFTERNOON SHIFT','2020-07-01','2020-07-01 00:00:00',NULL,'248',1518879.50,1518879.50,'248','2020-07-02 09:43:40','248','2020-07-02 09:47:27',10,0),('1','64',142214,'MORNING SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'248',821751.60,821751.60,'248','2020-07-07 09:57:27','248','2020-07-07 09:58:25',10,0),('1','64',142216,'AFTERNOON SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'248',1382517.80,1382517.80,'248','2020-07-07 10:12:33','248','2020-07-07 10:13:08',10,0),('1','64',142220,'MORNING SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'248',762314.80,762314.80,'248','2020-07-07 10:17:46','248','2020-07-07 10:18:13',10,0),('1','64',142222,'AFTERNOON SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'248',1540734.00,1540734.00,'248','2020-07-07 11:14:19','248','2020-07-07 11:14:47',10,0),('1','64',142233,'MORNING SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'248',872344.60,872344.60,'248','2020-07-07 11:17:23','248','2020-07-07 11:19:30',10,0),('1','64',142235,'AFTERNOON SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'248',1578252.60,1578252.60,'248','2020-07-07 11:21:42','248','2020-07-07 11:22:31',10,0),('1','64',142236,'MORNING SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'248',611381.20,611381.20,'248','2020-07-07 11:29:16','248','2020-07-07 11:29:56',10,0),('1','64',142239,'AFTERNOON SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'248',1344366.80,1344366.80,'248','2020-07-07 11:59:22','248','2020-07-07 12:28:45',10,0),('1','64',142258,'MORNING SHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'248',786235.40,786235.40,'248','2020-07-07 18:34:18','248','2020-07-07 18:35:48',10,0),('1','64',142320,'AFTERNOON SHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'248',1546000.40,1546000.40,'248','2020-07-07 18:40:48','248','2020-07-07 18:42:26',10,0),('1','64',142321,'MORNING SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'248',875599.20,875599.20,'248','2020-07-07 18:49:34','248','2020-07-07 18:50:06',10,0),('1','64',142322,'AFTERNOON SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'248',1417422.20,1417422.20,'248','2020-07-08 14:21:58','248','2020-07-08 14:23:04',10,0),('1','64',142412,'MORNING SHIFT','2020-07-08','2020-07-08 00:00:00',NULL,'248',813355.00,813355.00,'248','2020-07-08 14:26:46','248','2020-07-08 14:27:41',10,0),('1','64',142584,'AFTERNOON SHIFT','2020-07-08','2020-07-08 00:00:00',NULL,'248',1446725.00,1446725.00,'248','2020-07-10 10:19:53','248','2020-07-10 10:20:46',10,0),('1','64',142625,'MORNING SHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'248',642419.80,642419.80,'248','2020-07-10 10:23:20','248','2020-07-10 10:23:48',10,0),('1','64',142627,'AFTERNOON SHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'248',1475013.80,1475013.80,'248','2020-07-10 10:49:29','248','2020-07-10 10:50:17',10,0),('1','64',142631,'MORNING SHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'248',760962.60,760962.60,'248','2020-07-10 18:39:29','248','2020-07-10 18:40:02',10,0),('1','64',142703,'AFTERNOON SHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'248',1219812.20,1219812.20,'248','2020-07-11 12:13:27','248','2020-07-11 12:13:58',10,0),('1','64',142764,'MORNING SHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'248',186364.80,186364.80,'248','2020-07-11 12:17:16','248','2020-07-11 12:21:24',10,0),('1','64',142770,'PRICE CHANGE SHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'248',455392.00,455392.00,'248','2020-07-11 12:40:56','248','2020-07-11 13:04:30',10,0),('1','64',142910,'AFTERNOON SHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'248',1369744.00,1369744.00,'248','2020-07-12 14:06:19','248','2020-07-12 14:06:55',10,0),('1','64',142914,'MORNING SHIFT','2020-07-12','2020-07-12 00:00:00',NULL,'248',513195.20,513195.20,'248','2020-07-12 14:09:39','248','2020-07-12 14:10:22',10,0),('1','64',142917,'AFTERNOON SHIFT','2020-07-12','2020-07-12 00:00:00',NULL,'248',1274781.20,1274781.20,'248','2020-07-13 18:43:00','248','2020-07-13 18:43:51',10,0),('1','64',143083,'MORNING SHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'248',598652.60,598652.60,'248','2020-07-13 18:47:12','248','2020-07-13 18:48:42',10,0),('1','64',143084,'AFTERNOON SHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'248',1612399.00,1612399.00,'248','2020-07-17 14:51:35','248','2020-07-17 14:52:07',10,0),('1','64',143560,'MORNING SHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'248',619318.00,619318.00,'248','2020-07-17 15:23:14','248','2020-07-17 15:26:01',10,0),('1','64',143567,'AFTERNOON SHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'248',1478760.00,1478760.00,'248','2020-07-17 15:39:54','248','2020-07-17 15:41:29',10,0),('1','64',143573,'MORNING SHIFT','2020-07-15','2020-07-15 00:00:00',NULL,'248',672187.60,672187.60,'248','2020-07-17 15:46:26','248','2020-07-17 15:47:36',10,0),('1','64',143574,'AFTERNOON SHIFT','2020-07-15','2020-07-15 00:00:00',NULL,'248',1490394.60,1490394.60,'248','2020-07-17 16:19:17','248','2020-07-17 16:19:52',10,0),('1','64',143592,'MORNING SHIFT','2020-07-16','2020-07-16 00:00:00',NULL,'248',688205.60,688205.60,'248','2020-07-17 16:24:24','248','2020-07-17 16:24:58',10,0),('1','64',143595,'AFTERNOON SHIFT','2020-07-16','2020-07-16 00:00:00',NULL,'248',1488222.80,1488222.80,'248','2020-07-17 16:31:51','248','2020-07-17 16:32:44',10,0),('1','64',143597,'MORNING SHIFT','2020-07-17','2020-07-17 00:00:00',NULL,'248',660545.40,660545.40,'248','2020-07-17 16:42:58','248','2020-07-17 16:43:50',10,0),('1','64',143600,'AFTERNOON SHIFT','2020-07-17','2020-07-17 00:00:00',NULL,'248',1518883.20,1518883.20,'248','2020-07-20 09:38:46','248','2020-07-20 09:39:26',10,0),('1','64',143922,'MORNING SHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'248',697878.60,697878.60,'248','2020-07-20 09:47:07','248','2020-07-20 09:47:40',10,0),('1','64',143923,'AFTERNOON SHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'248',1596686.00,1596686.00,'248','2020-07-20 09:50:49','248','2020-07-20 09:51:24',10,0),('1','64',143924,'MORNING SHIFT','2020-07-19','2020-07-19 00:00:00',NULL,'248',659180.40,659180.40,'248','2020-07-20 09:56:36','248','2020-07-20 09:57:10',10,0),('1','64',143927,'AFTERNOON SHIFT','2020-07-19','2020-07-19 00:00:00',NULL,'248',1071031.20,1071031.20,'248','2020-07-20 10:01:28','248','2020-07-20 10:02:45',10,0),('1','64',143930,'MORNING SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'248',696835.40,696835.40,'248','2020-07-21 17:32:38','248','2020-07-21 17:35:10',10,0),('1','64',144169,'AFTERNOON SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'248',1497336.60,1497336.60,'248','2020-07-21 17:40:52','248','2020-07-21 17:41:20',10,0),('1','64',144171,'MORNING SHIFT','2020-07-21','2020-07-21 00:00:00',NULL,'248',548154.00,548154.00,'248','2020-07-21 17:44:27','248','2020-07-21 17:44:56',10,0),('1','64',144172,'AFTERNOON SHIFT','2020-07-21','2020-07-21 00:00:00',NULL,'248',1589978.68,1589978.68,'248','2020-07-24 10:04:44','248','2020-07-24 10:05:58',10,0),('1','64',144486,'MORNING SHIFT','2020-07-22','2020-07-22 00:00:00',NULL,'248',722753.40,722753.40,'248','2020-07-24 10:13:41','248','2020-07-24 10:16:20',10,0),('1','64',144488,'AFTERNOON SHIFT','2020-07-22','2020-07-22 00:00:00',NULL,'248',1374559.60,1374559.60,'248','2020-07-24 10:53:22','248','2020-07-24 10:54:17',10,0),('1','64',144494,'MORNING SHIFT','2020-07-23','2020-07-23 00:00:00',NULL,'248',690346.20,690346.20,'248','2020-07-24 10:57:05','248','2020-07-24 11:04:35',10,0),('1','64',144496,'AFTERNOON SHIFT','2020-07-23','2020-07-23 00:00:00',NULL,'248',1521845.00,1521845.00,'248','2020-07-24 11:07:23','248','2020-07-24 11:07:54',10,0),('1','64',144499,'MORNING SHIFT','2020-07-24','2020-07-24 00:00:00',NULL,'248',786766.20,786766.20,'248','2020-07-24 14:42:57','248','2020-07-24 14:43:30',10,0),('1','64',144542,'AFTERNOON SHIFT','2020-07-24','2020-07-24 00:00:00',NULL,'248',1434335.60,1434335.60,'248','2020-07-25 10:27:43','248','2020-07-25 10:28:32',10,0),('1','64',144618,'MORNING SHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'248',829810.00,829810.00,'248','2020-07-25 18:24:05','248','2020-07-25 18:25:13',10,0),('1','64',144711,'AFTERNOON SHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'248',1513655.80,1513655.80,'248','2020-07-28 11:25:44','248','2020-07-28 11:26:15',10,0),('1','64',145038,'MORNING SHIFT','2020-07-26','2020-07-26 00:00:00',NULL,'248',708489.20,708489.20,'248','2020-07-28 11:57:37','248','2020-07-28 11:58:13',10,0),('1','64',145047,'AFTERNOON SHIFT','2020-07-26','2020-07-26 00:00:00',NULL,'248',966547.80,966547.80,'248','2020-07-28 12:12:58','248','2020-07-28 12:13:31',10,0),('1','64',145053,'MORNING SHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'248',719057.40,719057.40,'248','2020-07-28 12:21:44','248','2020-07-28 12:22:15',10,0),('1','64',145055,'AFTERNOON SHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'248',1227869.60,1227869.60,'248','2020-07-28 15:07:38','248','2020-07-28 15:15:21',10,0),('1','64',145091,'MORNING SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'248',704351.00,704351.00,'248','2020-07-28 15:25:33','248','2020-07-28 15:27:45',10,0),('1','64',145093,'AFTERNOON SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'248',26100.00,26100.00,'248','2020-08-05 23:59:21','248','2020-08-06 00:00:43',10,0),('1','64',146082,'PRICE CHANGE SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',146083,'PRICE CHANGE SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'248',1515599.40,1515599.40,'248','2020-08-06 00:09:33','248','2020-08-06 00:11:22',10,0),('1','64',146084,'MORNING SHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'248',921821.80,921821.80,'248','2020-08-06 00:16:14','248','2020-08-06 00:16:56',10,0),('1','64',146085,'AFTERNOON SHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'248',1391900.20,1391900.20,'248','2020-08-06 00:22:26','248','2020-08-06 00:22:57',10,0),('1','64',146087,'MORNING SHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'248',738905.60,738905.60,'248','2020-08-09 10:42:50','248','2020-08-09 10:43:50',10,0),('1','64',146486,'AFTERNOON SHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'248',1324200.20,1324200.20,'248','2020-08-09 10:47:39','248','2020-08-09 10:48:01',10,0),('1','64',146487,'MORNING SHIFT','2020-07-31','2020-07-31 00:00:00',NULL,'248',745689.20,745689.20,'248','2020-08-09 10:59:23','248','2020-08-09 11:00:00',10,0),('1','64',146489,'AFTERNOON SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',146491,'AFTERNOON SHIFT','2020-07-31','2020-07-31 00:00:00',NULL,'248',1309535.80,1309535.80,'248','2020-08-09 11:08:03','248','2020-08-09 11:08:33',10,0),('1','64',146493,'MORNING SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'248',656743.40,656743.40,'248','2020-08-09 11:14:10','248','2020-08-09 11:14:48',10,0),('1','64',146495,'AFTERNOON SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'248',1264173.00,1264173.00,'248','2020-08-09 11:17:50','248','2020-08-09 11:18:46',10,0),('1','64',146496,'MORNING SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'248',637931.00,637931.00,'248','2020-08-09 14:49:34','248','2020-08-09 14:50:13',10,0),('1','64',146540,'AFTERNOON SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'248',1131919.20,1131919.20,'248','2020-08-09 14:54:26','248','2020-08-09 14:55:40',10,0),('1','64',146613,'MORNING SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'248',811027.00,783223.00,'248','2020-08-10 07:28:25','248','2020-08-10 07:31:06',10,0),('1','64',146614,'AFTERNOON SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'248',1548809.80,1492109.80,'248','2020-08-10 07:34:44','248','2020-08-10 07:35:11',10,0),('1','64',146616,'MORNING SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'248',754914.80,729636.80,'248','2020-08-10 07:41:24','248','2020-08-10 07:41:58',10,0),('1','64',146618,'AFTERNOON SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'248',1239880.20,1196686.20,'248','2020-08-10 07:46:16','248','2020-08-10 07:46:39',10,0),('1','64',146619,'MORNING SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'248',651165.80,629577.80,'248','2020-08-10 07:52:30','248','2020-08-10 07:52:59',10,0),('1','64',146620,'AFTERNOON SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'248',506626.40,491824.40,'248','2020-08-10 07:57:11','248','2020-08-10 07:57:44',10,0),('1','64',146622,'MORNING SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'248',124490.20,124490.20,'248','2020-08-10 07:59:26','248','2020-08-10 07:59:54',10,0),('1','64',146624,'AFTERNOON SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'248',524654.60,510140.60,'248','2020-08-10 08:14:50','248','2020-08-10 08:15:15',10,0),('1','64',146625,'MORNING SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'248',109596.00,109596.00,'248','2020-08-10 08:17:27','248','2020-08-10 08:18:56',10,0),('1','64',146627,'AFTERNOON SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'248',160741.80,160741.80,'248','2020-08-10 08:21:02','248','2020-08-10 08:21:38',10,0),('1','64',146628,'MORNING SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'248',140600.00,140600.00,'248','2020-08-10 08:25:44','248','2020-08-10 08:26:10',10,0),('1','64',146629,'AFTERNOON SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'248',144196.40,144196.40,'248','2020-08-10 08:30:52','248','2020-08-10 08:31:19',10,0),('1','64',146630,'MORNING SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'248',761978.00,761978.00,'248','2020-08-10 08:46:49','248','2020-08-10 08:48:12',10,0),('1','64',146636,'AFTERNOON SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'248',1167650.40,1167650.40,'248','2020-08-10 11:37:30','248','2020-08-10 11:38:07',10,0),('1','64',146650,'MORNING SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'248',781077.80,781077.80,'248','2020-08-12 11:12:38','248','2020-08-12 11:19:04',10,0),('1','64',146955,'AFTERNOON SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'248',1530651.20,1530651.20,'248','2020-08-12 11:27:42','248','2020-08-12 11:28:18',10,0),('1','64',146964,'MORNING SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'248',783645.60,783645.60,'248','2020-08-12 11:31:34','248','2020-08-12 11:32:07',10,0),('1','64',146966,'AFTERNOON SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'248',1330355.80,1330355.80,'248','2020-08-12 11:35:38','248','2020-08-12 11:36:05',10,0),('1','64',146969,'MORNING SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'248',809239.80,809239.80,'248','2020-08-14 22:55:35','248','2020-08-14 22:56:13',10,0),('1','64',147438,'AFTERNOON SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'248',1188953.40,1188953.40,'248','2020-08-14 23:22:26','248','2020-08-14 23:23:13',10,0),('1','64',147439,'MORNING SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'248',826543.00,826543.00,'248','2020-08-14 23:28:16','248','2020-08-14 23:28:58',10,0),('1','64',147440,'AFTERNOON SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'248',1293065.20,1293065.20,'248','2020-08-15 21:33:03','248','2020-08-15 21:34:09',10,0),('1','64',147568,'MORNING SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'248',763941.00,763941.00,'248','2020-08-15 21:39:14','248','2020-08-15 21:40:53',10,0),('1','64',147569,'AFTERNOON SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'248',1307705.20,1307705.20,'248','2020-08-15 21:44:25','248','2020-08-15 21:44:57',10,0),('1','64',147570,'MORNING SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'248',841476.80,841476.80,'248','2020-08-15 21:53:10','248','2020-08-15 21:54:38',10,0),('1','64',147571,'AFTERNOON SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'248',1441012.20,1441012.20,'248','2020-08-17 15:08:32','248','2020-08-17 15:08:58',10,0),('1','64',147814,'MORNING SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'248',871557.60,871557.60,'248','2020-08-17 15:14:44','248','2020-08-17 15:15:13',10,0),('1','64',147816,'AFTERNOON SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'248',1105239.60,1105239.60,'248','2020-08-17 15:17:39','248','2020-08-17 15:18:11',10,0),('1','64',147817,'MORNING SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'248',783426.40,783426.40,'248','2020-08-17 15:26:46','248','2020-08-17 15:29:10',10,0),('1','64',147820,'AFTERNOON SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'248',1427531.60,1427531.60,'248','2020-08-20 18:33:15','248','2020-08-20 18:33:56',10,0),('1','64',148272,'MORNING SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'248',786620.00,786620.00,'248','2020-08-20 18:38:24','248','2020-08-20 18:39:06',10,0),('1','64',148273,'AFTERNOON SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'248',1398283.60,1398283.60,'248','2020-08-20 18:42:28','248','2020-08-20 18:43:09',10,0),('1','64',148274,'MORNING SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'248',659821.00,659821.00,'248','2020-08-20 18:46:13','248','2020-08-20 18:46:53',10,0),('1','64',148276,'AFTERNOON SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'248',1435030.20,1435030.20,'248','2020-08-20 18:49:57','248','2020-08-20 18:50:44',10,0),('1','64',148277,'MORNING SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'248',909241.40,909241.40,'248','2020-08-20 18:54:18','248','2020-08-20 18:54:53',10,0),('1','64',148278,'AFTERNOON SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'248',1435568.20,1435568.20,'248','2020-08-24 16:16:20','248','2020-08-24 16:17:17',10,0),('1','64',148778,'MORNING SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'248',835848.80,835848.80,'248','2020-08-24 16:21:39','248','2020-08-24 16:22:18',10,0),('1','64',148781,'AFTERNOON SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'248',1254111.40,1254111.40,'248','2020-08-24 16:28:51','248','2020-08-24 16:29:48',10,0),('1','64',148783,'MORNING SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'248',842911.80,842911.80,'248','2020-08-24 16:32:58','248','2020-08-24 16:33:30',10,0),('1','64',148785,'AFTERNOON SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'248',1463286.60,1463286.60,'248','2020-08-24 16:45:40','248','2020-08-24 16:47:47',10,0),('1','64',148788,'MORNING SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'248',670639.80,670639.80,'248','2020-08-24 17:01:16','248','2020-08-24 17:02:55',10,0),('1','64',148792,'AFTERNOON SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'248',1172267.60,1172267.60,'248','2020-08-24 17:07:38','248','2020-08-24 17:08:09',10,0),('1','64',148793,'MORNING SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'248',684327.00,684327.00,'248','2020-08-24 17:15:36','248','2020-08-24 17:16:16',10,0),('1','64',148794,'AFTERNOON SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'248',1318983.60,1318983.60,'248','2020-08-28 19:50:21','248','2020-08-28 19:50:52',10,0),('1','64',149463,'MORNING SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'248',837271.60,837271.60,'248','2020-08-28 19:56:42','248','2020-08-28 19:57:20',10,0),('1','64',149465,'AFTERNOON SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'248',1389144.20,1389144.20,'248','2020-08-28 20:03:44','248','2020-08-28 20:04:12',10,0),('1','64',149467,'MORNING SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'248',835261.70,835261.70,'248','2020-08-28 20:14:16','248','2020-08-28 20:15:13',10,0),('1','64',149469,'AFTERNOON SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'248',1415369.40,1415369.40,'248','2020-08-28 20:19:50','248','2020-08-28 20:21:09',10,0),('1','64',149470,'MORNING SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'248',682298.80,682298.80,'248','2020-08-28 20:26:13','248','2020-08-28 20:27:09',10,0),('1','64',149472,'AFTERNOON SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'248',1416487.80,1416487.80,'248','2020-08-28 20:30:11','248','2020-08-28 20:30:37',10,0),('1','64',149474,'MORNING SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'248',804619.60,804619.60,'248','2020-08-28 20:39:21','248','2020-08-28 20:39:50',10,0),('1','64',149476,'AFTERNOON SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'248',1484041.20,1484041.20,'248','2020-09-02 18:53:54','248','2020-09-02 18:54:36',10,0),('1','64',150143,'MORNING SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'248',823995.60,823995.60,'248','2020-09-02 19:00:18','248','2020-09-02 19:00:46',10,0),('1','64',150147,'AFTERNOON SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'248',1206785.60,1206785.60,'248','2020-09-02 19:12:42','248','2020-09-02 19:13:40',10,0),('1','64',150149,'MORNING SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'248',727437.60,727437.60,'248','2020-09-02 19:17:53','248','2020-09-02 19:18:56',10,0),('1','64',150151,'AFTERNOON SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'248',1117338.00,1117338.00,'248','2020-09-02 19:22:42','248','2020-09-02 19:23:18',10,0),('1','64',150152,'MORNING SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'248',664676.60,664676.60,'248','2020-09-02 19:27:23','248','2020-09-02 19:27:56',10,0),('1','64',150153,'AFTERNOON SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'248',1233977.80,1233977.80,'248','2020-09-02 19:33:42','248','2020-09-02 19:35:08',10,0),('1','64',150154,'MORNING SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'248',701790.70,701790.70,'248','2020-09-02 19:44:20','248','2020-09-02 19:45:23',10,0),('1','64',150156,'AFTERNOON SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'248',1786912.40,1786912.40,'248','2020-09-02 19:50:24','248','2020-09-02 19:51:00',10,0),('1','64',150157,'MORNING SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'248',767067.80,767067.80,'248','2020-09-07 17:37:13','248','2020-09-07 17:37:50',10,0),('1','64',150969,'AFTERNOON SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'248',1296745.00,1296745.00,'248','2020-09-07 17:41:04','248','2020-09-07 17:42:13',10,0),('1','64',150971,'MORNING SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',150973,'MORNING SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'248',817161.40,817161.40,'248','2020-09-07 17:46:28','248','2020-09-07 17:46:55',10,0),('1','64',150975,'AFTERNOON SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'248',1376774.40,1376774.40,'248','2020-09-07 17:51:05','248','2020-09-07 17:51:36',10,0),('1','64',150976,'MORNING SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'248',293490.00,293490.00,'248','2020-09-07 17:55:20','248','2020-09-07 17:56:13',10,0),('1','64',150978,'AFTERNOON SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'248',622817.00,622817.00,'248','2020-09-07 17:59:51','248','2020-09-07 18:00:18',10,0),('1','64',150979,'MORNING SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'248',787290.00,787290.00,'248','2020-09-07 18:06:31','248','2020-09-07 18:07:23',10,0),('1','64',150980,'AFTERNOON SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'248',1286551.20,1286551.20,'248','2020-09-07 18:13:46','248','2020-09-07 18:14:44',10,0),('1','64',150982,'MORNING SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'248',444841.00,444841.00,'248','2020-09-07 18:19:09','248','2020-09-07 18:19:43',10,0),('1','64',150984,'AFTERNOON SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'248',27954.40,27954.40,'248','2020-09-07 18:24:41','248','2020-09-07 18:25:14',10,0),('1','64',150985,'MORNING SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'248',91580.20,91580.20,'248','2020-09-07 18:30:53','248','2020-09-07 18:32:41',10,0),('1','64',150986,'AFTERNOON SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'248',824652.80,824652.80,'248','2020-09-10 19:57:58','248','2020-09-10 19:58:25',10,0),('1','64',151435,'MORNING SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'248',885736.60,885736.60,'248','2020-09-10 20:01:16','248','2020-09-10 20:01:40',10,0),('1','64',151436,'AFTERNOON SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'248',1099141.60,1099141.60,'248','2020-09-10 20:05:17','248','2020-09-10 20:06:05',10,0),('1','64',151437,'MORNING SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'248',677565.80,677565.80,'248','2020-09-10 20:10:37','248','2020-09-10 20:11:04',10,0),('1','64',151438,'AFTERNOON SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'248',1582321.20,1582321.20,'248','2020-09-10 20:14:15','248','2020-09-10 20:14:46',10,0),('1','64',151439,'MORNING SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'248',762069.40,762069.40,'248','2020-09-10 20:17:20','248','2020-09-10 20:17:51',10,0),('1','64',151440,'AFTERNOON SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'248',1509023.00,1509023.00,'248','2020-09-14 19:45:29','248','2020-09-14 19:45:54',10,0),('1','64',152009,'MORNING SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'248',706627.80,706627.80,'248','2020-09-14 19:48:30','248','2020-09-14 19:48:59',10,0),('1','64',152012,'AFTERNOON SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'248',1624273.60,1624273.60,'248','2020-09-14 19:55:18','248','2020-09-14 19:55:48',10,0),('1','64',152013,'MORNING SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'248',637544.40,637544.40,'248','2020-09-14 19:58:14','248','2020-09-14 19:58:39',10,0),('1','64',152014,'AFTERNOON SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'248',1040608.40,1040608.40,'248','2020-09-14 20:01:03','248','2020-09-14 20:01:31',10,0),('1','64',152015,'MORNING SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'248',708021.00,708021.00,'248','2020-09-14 20:05:53','248','2020-09-14 20:06:24',10,0),('1','64',152016,'AFTERNOON SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'248',570880.00,570880.00,'248','2020-09-14 20:09:45','248','2020-09-14 20:10:06',10,0),('1','64',152017,'PRICE CHANGE SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'248',747543.80,747543.80,'248','2020-09-14 20:14:02','248','2020-09-14 20:15:03',10,0),('1','64',152018,'MORNING SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'248',687115.20,687115.20,'248','2020-09-14 20:17:54','248','2020-09-14 20:18:37',10,0),('1','64',152019,'AFTERNOON SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'248',1316479.60,1316479.60,'248','2020-09-17 18:40:31','248','2020-09-17 18:41:24',10,0),('1','64',152466,'MORNING SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'248',886420.00,886420.00,'248','2020-09-17 18:44:58','248','2020-09-17 18:49:01',10,0),('1','64',152468,'AFTERNOON SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'248',1520882.20,1520882.20,'248','2020-09-17 18:55:15','248','2020-09-17 18:55:45',10,0),('1','64',152470,'MORNING SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'248',1083539.00,1083539.00,'248','2020-09-17 18:59:44','248','2020-09-17 19:00:14',10,0),('1','64',152471,'AFTERNOON SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'248',1969320.20,1969320.20,'248','2020-09-17 19:03:28','248','2020-09-17 19:04:14',10,0),('1','64',152474,'MORNING SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'248',1026263.60,1026263.60,'248','2020-09-22 20:44:14','248','2020-09-22 20:44:43',10,0),('1','64',153278,'AFTERNOON SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'248',1440958.40,1440958.40,'248','2020-09-22 20:50:33','248','2020-09-22 20:54:23',10,0),('1','64',153280,'MORNING SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'248',820663.60,820663.60,'248','2020-09-23 20:54:27','248','2020-09-23 20:54:53',10,0),('1','64',153475,'AFTERNOON SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'248',2485662.40,2485662.40,'248','2020-09-23 21:03:26','248','2020-09-23 21:04:05',10,0),('1','64',153476,'MORNING SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'248',306175.20,306175.20,'248','2020-09-23 21:07:09','248','2020-09-23 21:09:31',10,0),('1','64',153478,'AFTERNOON SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'248',1259967.40,1259967.40,'248','2020-09-23 21:13:12','248','2020-09-23 21:13:39',10,0),('1','64',153479,'MORNING SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'248',850246.60,850246.60,'248','2020-09-23 21:17:00','248','2020-09-23 21:17:46',10,0),('1','64',153480,'AFTERNOON SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'248',1878865.80,1878865.80,'248','2020-09-24 08:32:18','248','2020-09-24 08:33:09',10,0),('1','64',153506,'MORNING SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'248',1037776.80,1037776.80,'248','2020-09-24 08:36:00','248','2020-09-24 08:36:27',10,0),('1','64',153508,'AFTERNOON SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'248',1307710.60,1307710.60,'248','2020-09-24 08:39:29','248','2020-09-24 08:39:50',10,0),('1','64',153510,'MORNING SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'248',750108.40,750108.40,'248','2020-09-24 08:43:39','248','2020-09-24 08:44:05',10,0),('1','64',153513,'AFTERNOON SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'248',1153559.80,1153559.80,'248','2020-09-24 08:51:14','248','2020-09-24 08:51:52',10,0),('1','64',153516,'MORNING SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'248',687080.40,687080.40,'248','2020-09-24 09:03:15','248','2020-09-24 09:04:19',10,0),('1','64',153521,'AFTERNOON SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'248',1387515.80,1387515.80,'248','2020-09-24 09:07:26','248','2020-09-24 09:07:59',10,0),('1','64',153522,'MORNING SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'248',764175.60,764175.60,'248','2020-09-24 21:13:50','248','2020-09-24 21:14:21',10,0),('1','64',153651,'AFTERNOON SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'248',1298313.40,1298313.40,'248','2020-09-26 10:46:39','248','2020-09-26 10:47:17',10,0),('1','64',153836,'MORNING SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'248',967647.80,967647.80,'248','2020-09-26 11:06:00','248','2020-09-26 11:07:11',10,0),('1','64',153839,'AFTERNOON SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'248',1429546.20,1429546.20,'248','2020-09-26 11:22:39','248','2020-09-26 11:23:15',10,0),('1','64',153843,'MORNING SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'248',966460.00,966460.00,'248','2020-09-28 15:56:16','248','2020-09-28 15:56:43',10,0),('1','64',154206,'AFTERNOON SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'248',1530795.80,1530795.80,'248','2020-09-28 16:03:02','248','2020-09-28 16:03:46',10,0),('1','64',154211,'MORNING SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'248',673308.80,673308.80,'248','2020-09-28 16:07:54','248','2020-09-28 16:09:03',10,0),('1','64',154214,'AFTERNOON SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'248',1318482.20,1318482.20,'248','2020-09-28 16:24:46','248','2020-09-28 16:25:26',10,0),('1','64',154220,'MORNING SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'248',898896.40,898896.40,'248','2020-09-28 16:33:18','248','2020-09-28 16:33:53',10,0),('1','64',154223,'AFTERNOON SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'248',1405811.80,1405811.80,'248','2020-09-30 12:48:08','248','2020-09-30 12:49:16',10,0),('1','64',154499,'MORNING SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'248',758317.60,758317.60,'248','2020-09-30 12:53:23','248','2020-09-30 12:54:01',10,0),('1','64',154503,'AFTERNOON SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'248',1528012.40,1528012.40,'248','2020-09-30 12:59:11','248','2020-09-30 12:59:50',10,0),('1','64',154508,'MORNING SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'248',713187.60,713187.60,'248','2020-10-01 14:11:08','248','2020-10-01 14:11:45',10,0),('1','64',154669,'AFTERNOON SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'248',1399858.20,1399858.20,'248','2020-10-01 14:17:00','248','2020-10-01 14:17:32',10,0),('1','64',154674,'MORNING SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'248',801835.80,801835.80,'248','2020-10-01 14:20:21','248','2020-10-01 17:55:57',10,0),('1','64',154716,'AFTERNOON SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'248',1359358.00,1359358.00,'248','2020-10-06 10:22:05','248','2020-10-06 10:22:33',10,0),('1','64',155346,'MORNING SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'248',747463.60,747463.60,'248','2020-10-06 10:26:37','248','2020-10-06 10:27:14',10,0),('1','64',155347,'AFTERNOON SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'248',1472276.20,1472276.20,'248','2020-10-06 10:29:22','248','2020-10-06 10:29:49',10,0),('1','64',155348,'MORNING SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'248',880072.20,880072.20,'248','2020-10-06 10:32:48','248','2020-10-06 10:33:15',10,0),('1','64',155350,'AFTERNOON SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'248',1440949.80,1440949.80,'248','2020-10-06 10:35:50','248','2020-10-06 10:36:18',10,0),('1','64',155352,'MORNING SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'248',647273.00,647273.00,'248','2020-10-06 10:39:50','248','2020-10-06 10:40:23',10,0),('1','64',155355,'AFTERNOON SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'248',1099125.20,1099125.20,'248','2020-10-06 10:45:43','248','2020-10-06 10:46:08',10,0),('1','64',155356,'MORNING SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'248',752869.00,752869.00,'248','2020-10-06 10:56:02','248','2020-10-06 10:56:25',10,0),('1','64',155359,'AFTERNOON SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'248',1389776.20,1389776.20,'248','2020-10-06 10:59:38','248','2020-10-06 11:00:04',10,0),('1','64',155360,'MORNING SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'248',616176.40,616176.40,'248','2020-10-07 08:47:45','248','2020-10-07 08:48:21',10,0),('1','64',155480,'AFTERNOON SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'248',1406707.60,1406707.60,'248','2020-10-07 08:51:50','248','2020-10-07 08:52:22',10,0),('1','64',155481,'MORNING SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'248',688595.00,688595.00,'248','2020-10-09 09:53:46','248','2020-10-09 09:54:26',10,0),('1','64',155823,'AFTERNOON SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'248',1362398.00,1362398.00,'248','2020-10-09 09:58:40','248','2020-10-09 09:59:25',10,0),('1','64',155825,'MORNING SHIFT833','2020-10-08','2020-10-08 00:00:00',NULL,'248',671155.20,671155.20,'248','2020-10-09 10:02:58','248','2020-10-09 10:03:27',10,0),('1','64',155826,'AFTERNOON SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'248',1247689.20,1247689.20,'248','2020-10-09 10:11:29','248','2020-10-09 10:14:35',10,0),('1','64',155827,'MORNING SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'248',766107.20,766107.20,'248','2020-10-10 19:26:37','248','2020-10-10 19:27:06',10,0),('1','64',156077,'AFTERNOON SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'248',1173301.20,1173301.20,'248','2020-10-10 19:30:02','248','2020-10-10 19:30:38',10,0),('1','64',156080,'MORNING SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'248',634071.40,634071.40,'248','2020-10-10 19:34:50','248','2020-10-10 19:36:17',10,0),('1','64',156082,'AFTERNOON SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'248',1268792.80,1268792.80,'248','2020-10-11 17:49:51','248','2020-10-11 17:51:13',10,0),('1','64',156191,'MORNING SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'248',700315.20,700315.20,'248','2020-10-11 17:54:53','248','2020-10-11 17:56:06',10,0),('1','64',156193,'AFTERNOON SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'248',1530394.00,1530394.00,'248','2020-10-13 10:51:59','248','2020-10-13 10:52:26',10,0),('1','64',156475,'MORNING SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'248',678589.80,678589.80,'248','2020-10-13 10:57:06','248','2020-10-13 10:58:17',10,0),('1','64',156479,'AFTERNOON SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'248',1454651.60,1454651.60,'248','2020-10-13 11:15:37','248','2020-10-13 11:16:09',10,0),('1','64',156484,'MORNING SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'248',863596.20,863596.20,'248','2020-10-13 19:57:01','248','2020-10-13 19:57:52',10,0),('1','64',156577,'AFTERNOON SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'248',1407431.40,1407431.40,'248','2020-10-14 20:58:36','248','2020-10-14 20:59:26',10,0),('1','64',156737,'MORNING SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'248',815486.20,815486.20,'248','2020-10-14 21:05:23','248','2020-10-14 21:06:04',10,0),('1','64',156738,'AFTERNOON SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'248',1495884.80,1495884.80,'248','2020-10-15 21:02:09','248','2020-10-15 21:02:45',10,0),('1','64',156908,'MORNING SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'248',1060479.00,1060479.00,'248','2020-10-15 21:06:01','248','2020-10-15 21:06:28',10,0),('1','64',156909,'AFTERNOON SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'248',1441134.80,1441134.80,'248','2020-10-17 21:15:16','248','2020-10-17 21:15:51',10,0),('1','64',157278,'MORNING SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'248',765852.20,765852.20,'248','2020-10-17 21:19:26','248','2020-10-17 21:20:07',10,0),('1','64',157279,'AFTERNOON SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'248',661230.00,661230.00,'248','2020-10-17 21:22:52','248','2020-10-17 21:23:22',10,0),('1','64',157280,'MORNING SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',157281,'PRICE CHANGE SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'248',646336.00,646336.00,'248','2020-10-17 21:31:56','248','2020-10-17 21:33:08',10,0),('1','64',157283,'MORNING SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'248',895996.80,895996.80,'248','2020-10-17 21:38:10','248','2020-10-17 21:38:46',10,0),('1','64',157285,'AFTERNOON SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'248',1409562.80,1409562.80,'248','2020-10-24 13:24:40','248','2020-10-24 13:25:09',10,0),('1','64',158352,'MORNING SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'248',812114.80,812114.80,'248','2020-10-24 13:30:38','248','2020-10-24 13:31:06',10,0),('1','64',158355,'AFTERNOON SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'248',1440102.60,1440102.60,'248','2020-10-25 16:04:27','248','2020-10-25 16:06:02',10,0),('1','64',158543,'MORNING SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'248',130250.00,130250.00,'248','2020-10-25 16:09:29','248','2020-10-25 16:10:05',10,0),('1','64',158545,'AFTERNOON SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:21:06','248','2020-10-27 09:21:37',10,0),('1','64',158800,'MORNING SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:23:13','248','2020-10-27 09:23:37',10,0),('1','64',158802,'AFTERNOON SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:24:51','248','2020-10-27 09:25:14',10,0),('1','64',158803,'MORNING SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:26:10','248','2020-10-27 09:26:36',10,0),('1','64',158804,'AFTERNOON SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:28:59','248','2020-10-27 09:29:29',10,0),('1','64',158805,'MORNING SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:30:31','248','2020-10-27 09:30:52',10,0),('1','64',158806,'AFTERNOON SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:31:55','248','2020-10-27 09:32:23',10,0),('1','64',158807,'MORNING SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:34:09','248','2020-10-27 09:34:33',10,0),('1','64',158808,'AFTERNOON SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-27 09:35:29','248','2020-10-27 09:36:08',10,0),('1','64',158809,'MORNING SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'248',798593.60,798593.60,'248','2020-10-27 09:38:37','248','2020-10-27 09:39:13',10,0),('1','64',158810,'AFTERNOON SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'248',1005489.80,1005489.80,'248','2020-10-27 09:43:55','248','2020-10-27 09:44:29',10,0),('1','64',158811,'MORNING SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'248',782668.00,782668.00,'248','2020-10-27 09:50:09','248','2020-10-27 09:51:33',10,0),('1','64',158816,'AFTERNOON SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'248',754893.20,754893.20,'248','2020-10-27 09:53:43','248','2020-10-27 09:56:35',10,0),('1','64',158818,'MORNING SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'248',873885.00,873885.00,'248','2020-10-27 09:59:55','248','2020-10-27 10:00:33',10,0),('1','64',158820,'AFTERNOON SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'248',862477.20,862477.20,'248','2020-10-27 11:08:58','248','2020-10-27 11:09:29',10,0),('1','64',158838,'MORNING SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'248',636940.00,636940.00,'248','2020-10-28 13:08:36','248','2020-10-28 13:09:03',10,0),('1','64',159028,'AFTERNOON SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'248',828651.00,828651.00,'248','2020-10-28 13:11:37','248','2020-10-28 13:12:25',10,0),('1','64',159030,'MORNING SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'248',848137.00,848137.00,'248','2020-10-28 13:15:11','248','2020-10-28 13:15:35',10,0),('1','64',159036,'AFTERNOON SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'248',0.00,0.00,'248','2020-10-28 13:40:49','248','2020-10-28 13:41:26',10,0),('1','64',159040,'AFTERNOON SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'248',1147341.00,1147341.00,'248','2020-10-29 09:43:33','248','2020-10-29 09:43:59',10,0),('1','64',159163,'MORNING SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'248',697949.20,706105.20,'248','2020-10-30 16:02:12','248','2020-10-30 16:02:40',10,0),('1','64',159420,'AFTERNOON SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'248',898096.80,908942.80,'248','2020-10-30 16:05:11','248','2020-10-30 16:05:41',10,0),('1','64',159422,'MORNING SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'248',688896.00,696680.00,'248','2020-10-30 16:11:12','248','2020-10-30 16:12:13',10,0),('1','64',159423,'AFTERNOON SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'248',985545.80,997449.80,'248','2020-10-31 08:51:12','248','2020-10-31 08:52:02',10,0),('1','64',159480,'MORNING SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'248',920189.40,930731.40,'248','2020-10-31 18:08:46','248','2020-10-31 18:09:18',10,0),('1','64',159622,'AFTERNOON SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'248',1073263.20,1083885.20,'248','2020-11-01 18:11:45','248','2020-11-01 18:12:20',10,0),('1','64',159729,'MORNING SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'248',616046.80,623160.80,'248','2020-11-01 18:15:03','248','2020-11-01 18:15:27',10,0),('1','64',159730,'AFTERNOON SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'248',813939.60,823771.60,'248','2020-11-02 09:20:57','248','2020-11-02 09:21:24',10,0),('1','64',159786,'MORNING SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'248',644321.60,652319.60,'248','2020-11-02 12:14:23','248','2020-11-02 12:14:56',10,0),('1','64',159846,'AFTERNOON SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'248',972563.20,984345.20,'248','2020-11-03 09:11:35','248','2020-11-03 09:12:05',10,0),('1','64',159992,'MORNING SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'248',720599.20,720599.20,'248','2020-11-03 12:04:06','248','2020-11-03 12:04:32',10,0),('1','64',160035,'AFTERNOON SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'248',900409.60,900409.60,'248','2020-11-04 09:16:38','248','2020-11-04 09:18:30',10,0),('1','64',160169,'MORNING SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'248',114125.00,114125.00,'248','2020-11-04 13:09:43','248','2020-11-04 13:10:13',10,0),('1','64',160239,'AFTERNOON SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'248',1384363.40,1384363.40,'248','2020-11-05 11:21:30','248','2020-11-05 11:23:12',10,0),('1','64',160376,'MORNING SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'248',740581.80,740581.80,'248','2020-11-07 08:03:11','248','2020-11-07 08:03:39',10,0),('1','64',160619,'AFTERNOON SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'248',1228740.00,1228740.00,'248','2020-11-07 08:07:07','248','2020-11-07 08:07:39',10,0),('1','64',160620,'MORNING SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'248',618377.60,618377.60,'248','2020-11-07 08:10:51','248','2020-11-07 08:11:18',10,0),('1','64',160621,'AFTERNOON SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'248',1261526.40,1261526.40,'248','2020-11-07 08:14:48','248','2020-11-07 08:15:48',10,0),('1','64',160622,'MORNING SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'248',927140.20,927140.20,'248','2020-11-07 20:14:30','248','2020-11-07 20:14:58',10,0),('1','64',160756,'AFTERNOON SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'248',1225990.20,1225990.20,'248','2020-11-09 06:50:29','248','2020-11-09 06:50:56',10,0),('1','64',160911,'MORNING SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'248',615491.60,615491.60,'248','2020-11-09 06:54:05','248','2020-11-09 06:54:30',10,0),('1','64',160912,'AFTERNOON SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'248',1008812.20,1008812.20,'248','2020-11-09 08:28:57','248','2020-11-09 08:29:25',10,0),('1','64',160943,'MORNING SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'248',662570.00,662570.00,'248','2020-11-10 07:59:12','248','2020-11-10 07:59:41',10,0),('1','64',161121,'AFTERNOON SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'248',1425435.80,1425435.80,'248','2020-11-10 08:07:34','248','2020-11-10 08:08:11',10,0),('1','64',161123,'MORNING SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'248',1155939.60,1155939.60,'248','2020-11-10 20:28:43','248','2020-11-10 20:29:13',10,0),('1','64',161278,'AFTERNOON SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'248',1521296.20,1521296.20,'248','2020-11-11 08:56:57','248','2020-11-11 08:57:30',10,0),('1','64',161329,'MORNING SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',161358,'MORNING SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'248',755612.60,755612.60,'248','2020-11-12 08:03:45','248','2020-11-12 08:04:19',10,0),('1','64',161505,'AFTERNOON SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'248',1317636.80,1317636.80,'248','2020-11-12 08:12:45','248','2020-11-12 08:13:29',10,0),('1','64',161507,'MORNING SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'248',902214.00,902214.00,'248','2020-11-12 19:35:31','248','2020-11-12 19:35:56',10,0),('1','64',161673,'AFTERNOON SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'248',1156978.60,1156978.60,'248','2020-11-13 11:11:43','248','2020-11-13 11:12:12',10,0),('1','64',161742,'MORNING SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'248',543362.00,543362.00,'248','2020-11-13 14:08:28','248','2020-11-13 14:08:49',10,0),('1','64',161785,'PRICE CHANGE SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'248',301331.20,301331.20,'248','2020-11-13 14:13:37','248','2020-11-13 14:14:29',10,0),('1','64',161792,'AFTERNOON SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'248',1352933.20,1352933.20,'248','2020-11-15 09:55:26','248','2020-11-15 09:55:58',10,0),('1','64',162089,'MORNING SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'248',350080.00,350080.00,'248','2020-11-15 10:00:03','248','2020-11-15 10:00:30',10,0),('1','64',162091,'PRICE CHANGE SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',162093,'PRICE CHANGE SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'248',549858.20,549858.20,'248','2020-11-15 10:05:05','248','2020-11-15 10:05:43',10,0),('1','64',162097,'AFTERNOON SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'248',981541.40,981541.40,'248','2020-11-15 10:09:02','248','2020-11-15 10:09:42',10,0),('1','64',162098,'MORNING SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'248',361872.00,361872.00,'248','2020-11-15 10:14:30','248','2020-11-15 10:15:28',10,0),('1','64',162101,'PRICE CHANGE SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'248',311004.00,311004.00,'248','2020-11-15 17:18:44','248','2020-11-15 17:19:39',10,0),('1','64',162216,'AFTERNOON SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'248',847699.00,847699.00,'248','2020-11-17 08:02:29','248','2020-11-17 08:03:13',10,0),('1','64',162485,'MORNING SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'248',743384.80,743384.80,'248','2020-11-17 08:08:19','248','2020-11-17 08:44:45',10,0),('1','64',162499,'AFTERNOON SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'248',1082643.80,1082643.80,'248','2020-11-17 08:50:44','248','2020-11-17 08:51:58',10,0),('1','64',162501,'MORNING SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'248',627984.40,627984.40,'248','2020-11-17 11:57:39','248','2020-11-17 11:59:08',10,0),('1','64',162562,'AFTERNOON SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'248',1232279.80,1232279.80,'248','2020-11-18 13:46:06','248','2020-11-18 13:54:57',10,0),('1','64',162750,'MORNING SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'248',682784.80,682784.80,'248','2020-11-19 11:34:07','248','2020-11-19 11:34:36',10,0),('1','64',162899,'AFTERNOON SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'248',1176652.80,1176652.80,'248','2020-11-19 11:44:45','248','2020-11-19 13:53:39',10,0),('1','64',162947,'MORNING SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'248',724390.00,724390.00,'248','2020-11-19 13:57:03','248','2020-11-19 13:57:39',10,0),('1','64',162949,'AFTERNOON SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'248',1210131.40,1210131.40,'248','2020-11-20 19:47:52','248','2020-11-20 19:48:23',10,0),('1','64',163211,'MORNING SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'248',776180.60,776180.60,'248','2020-11-20 19:51:59','248','2020-11-20 19:52:30',10,0),('1','64',163212,'AFTERNOON SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'248',1161081.80,1161081.80,'248','2020-11-21 16:54:10','248','2020-11-21 16:54:45',10,0),('1','64',163357,'MORNING SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'248',786277.80,786277.80,'248','2020-11-21 17:02:12','248','2020-11-21 17:02:46',10,0),('1','64',163358,'AFTERNOON SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'248',1465772.40,1465772.40,'248','2020-11-23 09:53:50','248','2020-11-23 09:54:33',10,0),('1','64',163604,'MORNING SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'248',205435.00,205435.00,'248','2020-11-23 09:58:19','248','2020-11-23 09:59:55',10,0),('1','64',163606,'AFTERNOON SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'248',340964.00,340964.00,'248','2020-11-23 10:06:41','248','2020-11-23 10:10:04',10,0),('1','64',163610,'MORNING SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'248',90968.00,90968.00,'248','2020-11-24 09:12:05','248','2020-11-24 09:12:47',10,0),('1','64',163768,'AFTERNOON SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'248',305938.00,305938.00,'248','2020-11-24 09:15:31','248','2020-11-24 09:16:05',10,0),('1','64',163772,'MORNING SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'248',71689.20,71689.20,'248','2020-11-25 13:40:35','248','2020-11-25 13:41:24',10,0),('1','64',164006,'AFTERNOON SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'248',379476.00,379476.00,'248','2020-11-25 13:45:40','248','2020-11-25 13:46:31',10,0),('1','64',164008,'MORNING SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'248',92801.80,92801.80,'248','2020-11-25 13:50:39','248','2020-11-25 13:54:29',10,0),('1','64',164009,'AFTERNOON SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'248',314916.20,314916.20,'248','2020-11-26 22:24:08','248','2020-11-26 22:24:37',10,0),('1','64',164277,'MORNING SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'248',55942.00,55942.00,'248','2020-11-26 22:28:49','248','2020-11-26 22:29:20',10,0),('1','64',164280,'AFTERNOON SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'248',1015223.00,1015223.00,'248','2020-11-27 11:32:05','248','2020-11-27 11:35:33',10,0),('1','64',164355,'MORNING SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',164607,'MORNING SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'248',743569.80,743569.80,'248','2020-11-28 21:19:54','248','2020-11-28 21:20:46',10,0),('1','64',164608,'AFTERNOON SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'248',1195727.60,1195727.60,'248','2020-11-28 21:24:44','248','2020-11-28 21:25:30',10,0),('1','64',164609,'MORNING SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'248',822021.20,822021.20,'248','2020-11-28 21:31:04','248','2020-11-28 21:31:46',10,0),('1','64',164610,'AFTERNOON SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'248',969675.60,969675.60,'248','2020-11-29 17:41:54','248','2020-11-29 17:43:06',10,0),('1','64',164742,'MORNING SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'248',647302.40,647302.40,'248','2020-11-30 08:05:10','248','2020-11-30 08:08:06',10,0),('1','64',164788,'AFTERNOON SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'248',398958.00,398958.00,'248','2020-11-30 08:13:28','248','2020-11-30 08:14:39',10,0),('1','64',164790,'MORNING SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'248',146584.00,146584.00,'248','2020-12-01 11:27:31','248','2020-12-01 11:27:56',10,0),('1','64',165026,'AFTERNOON SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'248',422097.60,422097.60,'248','2020-12-01 11:31:15','248','2020-12-01 11:31:40',10,0),('1','64',165027,'MORNING SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'248',639093.60,639093.60,'248','2020-12-02 12:27:48','248','2020-12-02 12:28:36',10,0),('1','64',165195,'AFTERNOON SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'248',1313018.00,1313018.00,'248','2020-12-02 13:09:55','248','2020-12-02 13:10:29',10,0),('1','64',165204,'MORNING SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'248',676870.80,676870.80,'248','2020-12-02 22:36:56','248','2020-12-02 22:37:44',10,0),('1','64',165315,'AFTERNOON SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'248',1219005.00,1219005.00,'248','2020-12-04 22:36:20','248','2020-12-04 22:37:05',10,0),('1','64',165625,'MORNING SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'248',847116.60,847116.60,'248','2020-12-04 22:46:01','248','2020-12-04 22:48:57',10,0),('1','64',165626,'AFTERNOON SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'248',1218748.80,1218748.80,'248','2020-12-04 22:56:12','248','2020-12-04 22:56:44',10,0),('1','64',165628,'MORNING SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'248',906877.40,906877.40,'248','2020-12-04 23:01:19','248','2020-12-04 23:01:52',10,0),('1','64',165629,'AFTERNOON SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'248',1263546.80,1263546.80,'248','2020-12-06 22:02:16','248','2020-12-06 22:03:00',10,0),('1','64',165936,'MORNING SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'248',712519.40,712519.40,'248','2020-12-06 22:08:36','248','2020-12-06 22:09:10',10,0),('1','64',165937,'AFTERNOON SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'248',1491065.20,1491065.20,'248','2020-12-06 22:17:03','248','2020-12-06 22:17:33',10,0),('1','64',165938,'MORNING SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'248',607369.00,607369.00,'248','2020-12-07 22:30:14','248','2020-12-07 22:31:02',10,0),('1','64',166149,'AFTERNOON SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'248',1092938.40,1092938.40,'248','2020-12-07 22:35:19','248','2020-12-07 22:36:31',10,0),('1','64',166150,'MORNING SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'248',775803.80,775803.80,'248','2020-12-07 22:42:03','248','2020-12-07 22:42:35',10,0),('1','64',166151,'AFTERNOON SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'248',1177730.60,1177730.60,'248','2020-12-08 23:00:36','248','2020-12-08 23:01:17',10,0),('1','64',166327,'MORNING SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'248',683233.80,683233.80,'248','2020-12-08 23:04:58','248','2020-12-08 23:05:40',10,0),('1','64',166328,'AFTERNOON SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'248',1149619.60,1149619.60,'248','2020-12-10 12:39:24','248','2020-12-10 12:39:55',10,0),('1','64',166596,'MORNING SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'248',625904.80,625904.80,'248','2020-12-10 12:46:55','248','2020-12-10 12:47:22',10,0),('1','64',166597,'AFTERNOON SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'248',1285224.40,1285224.40,'248','2020-12-10 12:50:09','248','2020-12-10 12:50:35',10,0),('1','64',166599,'MORNING SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'248',744358.60,744358.60,'248','2020-12-10 12:53:21','248','2020-12-10 12:54:15',10,0),('1','64',166600,'AFTERNOON SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'248',1139493.00,1139493.00,'248','2020-12-14 17:05:11','248','2020-12-14 17:05:46',10,0),('1','64',167348,'MORNING SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'248',721466.40,721466.40,'248','2020-12-14 17:12:54','248','2020-12-14 17:14:51',10,0),('1','64',167353,'AFTERNOON SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'248',1161544.80,1161544.80,'248','2020-12-14 17:27:37','248','2020-12-14 17:28:03',10,0),('1','64',167354,'MORNING SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'248',723535.00,723535.00,'248','2020-12-14 17:31:40','248','2020-12-14 17:32:05',10,0),('1','64',167355,'AFTERNOON SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'248',1098263.20,1098263.20,'248','2020-12-14 17:36:14','248','2020-12-14 17:36:44',10,0),('1','64',167356,'MORNING SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'248',748204.40,748204.40,'248','2020-12-14 17:39:25','248','2020-12-14 17:39:47',10,0),('1','64',167357,'AFTERNOON SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'248',974794.20,974794.20,'248','2020-12-14 17:41:35','248','2020-12-14 17:42:03',10,0),('1','64',167358,'MORNING SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'248',554475.40,554475.40,'248','2020-12-14 17:43:45','248','2020-12-14 17:44:09',10,0),('1','64',167360,'AFTERNOON SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'248',30600.00,30600.00,'248','2020-12-14 17:50:42','248','2020-12-14 17:51:15',10,0),('1','64',167361,'PRICE CHANGE SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'248',848813.60,848813.60,'248','2020-12-15 19:15:55','248','2020-12-15 19:16:54',10,0),('1','64',167571,'MORNING SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'248',772781.20,772781.20,'248','2020-12-15 19:20:08','248','2020-12-15 19:20:30',10,0),('1','64',167572,'AFTERNOON SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'248',1353844.20,1353844.20,'248','2020-12-16 19:27:37','248','2020-12-16 19:28:04',10,0),('1','64',167735,'MORNING SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'248',786228.80,786228.80,'248','2020-12-16 19:30:19','248','2020-12-16 19:30:46',10,0),('1','64',167737,'AFTERNOON SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',167740,'AFTERNOON SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'248',1225271.60,1225271.60,'248','2020-12-18 19:52:51','248','2020-12-18 19:53:20',10,0),('1','64',168127,'MORNING SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'248',690320.00,690320.00,'248','2020-12-18 19:58:46','248','2020-12-18 19:59:23',10,0),('1','64',168128,'AFTERNOON SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'248',1265110.80,1265110.80,'248','2020-12-18 20:04:06','248','2020-12-18 20:05:46',10,0),('1','64',168130,'MORNING SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'248',833188.60,833188.60,'248','2020-12-18 20:09:09','248','2020-12-18 20:09:37',10,0),('1','64',168131,'AFTERNOON SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'248',1420223.60,1420223.60,'248','2020-12-21 09:58:29','248','2020-12-21 09:58:54',10,0),('1','64',168479,'MORNING SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'248',887173.40,887173.40,'248','2020-12-21 10:41:27','248','2020-12-21 10:41:54',10,0),('1','64',168499,'AFTERNOON SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'248',1354592.20,1354592.20,'248','2020-12-21 10:45:31','248','2020-12-21 10:45:53',10,0),('1','64',168501,'MORNING SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'248',669335.40,669335.40,'248','2020-12-21 10:51:06','248','2020-12-21 10:51:33',10,0),('1','64',168503,'AFTERNOON SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'248',1520588.20,1520588.20,'248','2020-12-21 11:04:25','248','2020-12-21 11:04:54',10,0),('1','64',168506,'MORNING SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'248',748391.00,748391.00,'248','2020-12-21 20:11:10','248','2020-12-21 20:11:38',10,0),('1','64',168620,'AFTERNOON SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'248',1569862.00,1569862.00,'248','2020-12-27 11:04:06','248','2020-12-27 11:04:47',10,0),('1','64',169491,'MORNING SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'248',828528.80,828528.80,'248','2020-12-27 11:10:25','248','2020-12-27 11:11:42',10,0),('1','64',169494,'AFTERNOON SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'248',602776.00,602776.00,'248','2020-12-27 11:14:36','248','2020-12-27 11:15:02',10,0),('1','64',169497,'MORNING SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'248',523377.00,523377.00,'248','2020-12-27 11:17:41','248','2020-12-27 11:18:10',10,0),('1','64',169498,'AFTERNOON SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'248',1652347.60,1652347.60,'248','2020-12-31 09:25:25','248','2020-12-31 09:25:48',10,0),('1','64',170187,'MORNING SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'248',1012806.60,1012806.60,'248','2020-12-31 09:44:41','248','2020-12-31 09:45:47',10,0),('1','64',170196,'AFTERNOON SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'248',1820643.20,1820643.20,'248','2020-12-31 09:51:43','248','2020-12-31 09:53:02',10,0),('1','64',170199,'MORNING SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'248',1206094.20,1206094.20,'248','2020-12-31 09:56:13','248','2020-12-31 09:56:55',10,0),('1','64',170202,'AFTERNOON SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'248',1793490.80,1793490.80,'248','2020-12-31 10:07:29','248','2020-12-31 10:08:01',10,0),('1','64',170203,'MORNING SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'248',791785.80,791785.80,'248','2020-12-31 10:12:45','248','2020-12-31 10:13:23',10,0),('1','64',170205,'AFTERNOON SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'248',519325.00,519325.00,'248','2020-12-31 10:15:29','248','2020-12-31 10:16:07',10,0),('1','64',170207,'MORNING SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'248',735499.20,735499.20,'248','2020-12-31 20:08:29','248','2020-12-31 20:10:09',10,0),('1','64',170335,'AFTERNOON SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'248',1349297.00,1349297.00,'248','2020-12-31 20:12:36','248','2020-12-31 20:13:01',10,0),('1','64',170336,'MORNING SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'248',596190.40,596190.40,'248','2020-12-31 20:16:46','248','2020-12-31 20:17:17',10,0),('1','64',170338,'AFTERNOON SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'248',1468111.20,1468111.20,'248','2020-12-31 20:30:07','248','2020-12-31 21:08:40',10,0),('1','64',170341,'MORNING SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'248',815250.80,815250.80,'248','2020-12-31 21:12:31','248','2020-12-31 21:13:02',10,0),('1','64',170342,'AFTERNOON SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'248',1481098.80,1481098.80,'248','2020-12-31 21:18:15','248','2020-12-31 21:18:57',10,0),('1','64',170343,'MORNING SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'248',771910.00,771910.00,'248','2020-12-31 21:25:33','248','2020-12-31 21:25:54',10,0),('1','64',170344,'AFTERNOON SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'248',1426785.60,1426785.60,'248','2021-01-01 09:17:06','248','2021-01-01 09:17:49',10,0),('1','64',170367,'MORNING SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'248',933211.80,933211.80,'248','2021-01-01 09:30:51','248','2021-01-01 09:31:35',10,0),('1','64',170369,'AFTERNOON SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'248',2079548.00,2079548.00,'248','2021-01-01 11:24:08','248','2021-01-01 11:25:05',10,0),('1','64',170405,'MORNING SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'248',892711.20,892711.20,'248','2021-01-04 12:01:04','248','2021-01-04 12:01:43',10,0),('1','64',170894,'AFTERNOON SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'248',2176241.40,2176241.40,'248','2021-01-04 12:08:10','248','2021-01-04 12:08:30',10,0),('1','64',170895,'MORNING SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'248',538129.40,538129.40,'248','2021-01-04 12:11:17','248','2021-01-04 12:11:48',10,0),('1','64',170897,'AFTERNOON SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'248',1146235.20,1146235.20,'248','2021-01-04 12:14:22','248','2021-01-04 12:14:48',10,0),('1','64',170898,'MORNING SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'248',524111.20,524111.20,'248','2021-01-04 12:18:04','248','2021-01-04 12:18:29',10,0),('1','64',170899,'AFTERNOON SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'248',979309.00,979309.00,'248','2021-01-04 12:23:55','248','2021-01-04 12:24:21',10,0),('1','64',170902,'MORNING SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'248',628387.60,628387.60,'248','2021-01-04 12:28:44','248','2021-01-04 12:29:39',10,0),('1','64',170904,'AFTERNOON SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'248',1132659.00,1132659.00,'248','2021-01-07 08:25:18','248','2021-01-07 08:25:46',10,0),('1','64',171402,'MORNING SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'248',697361.80,697361.80,'248','2021-01-07 08:27:50','248','2021-01-07 08:28:23',10,0),('1','64',171403,'AFTERNOON SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'248',1182868.60,1182868.60,'248','2021-01-07 08:30:23','248','2021-01-07 08:30:54',10,0),('1','64',171404,'MORNING SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'248',613161.00,613161.00,'248','2021-01-07 08:33:57','248','2021-01-07 08:34:20',10,0),('1','64',171406,'AFTERNOON SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'248',1240158.60,1240158.60,'248','2021-01-07 08:39:48','248','2021-01-07 08:40:11',10,0),('1','64',171409,'MORNING SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'248',865926.40,865926.40,'248','2021-01-08 15:42:00','248','2021-01-08 15:42:54',10,0),('1','64',171719,'AFTERNOON SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'248',1228660.60,1228660.60,'248','2021-01-08 15:44:58','248','2021-01-08 15:45:20',10,0),('1','64',171721,'MORNING SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'248',811609.60,811609.60,'248','2021-01-08 15:48:49','248','2021-01-08 15:49:19',10,0),('1','64',171722,'AFTERNOON SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'248',1453610.00,1453610.00,'248','2021-01-09 12:47:55','248','2021-01-09 12:48:20',10,0),('1','64',171874,'MORNING SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'248',765243.20,765243.20,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',171875,'MORNING SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'248',761769.20,761769.20,'248','2021-01-09 12:55:35','248','2021-01-09 12:55:57',10,0),('1','64',171876,'AFTERNOON SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'248',1479053.00,1479053.00,'248','2021-01-11 11:07:13','248','2021-01-11 11:07:43',10,0),('1','64',172167,'MORNING SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'248',639484.20,636298.20,'248','2021-01-11 11:22:58','248','2021-01-11 11:23:43',10,0),('1','64',172168,'AFTERNOON SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'248',1135081.40,1128597.40,'248','2021-01-11 11:30:56','248','2021-01-11 11:31:21',10,0),('1','64',172170,'MORNING SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'248',689386.20,686270.20,'248','2021-01-11 12:51:06','248','2021-01-11 12:51:41',10,0),('1','64',172187,'AFTERNOON SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'248',1348873.80,1341301.80,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',172464,'AFTERNOON SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'248',1316673.80,1309301.80,'248','2021-01-12 17:28:04','248','2021-01-12 17:28:43',10,0),('1','64',172466,'MORNING SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'248',627118.00,624000.00,'248','2021-01-12 17:32:39','248','2021-01-12 17:33:06',10,0),('1','64',172471,'AFTERNOON SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'248',1392419.00,1384817.00,'248','2021-01-13 10:34:08','248','2021-01-13 10:34:33',10,0),('1','64',172586,'MORNING SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'248',701105.60,697705.60,'248','2021-01-14 09:50:56','248','2021-01-14 09:52:09',10,0),('1','64',172745,'AFTERNOON SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'248',1345758.80,1338842.80,'248','2021-01-14 10:09:51','248','2021-01-14 10:12:25',10,0),('1','64',172755,'MORNING SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'248',605591.40,602610.40,'248','2021-01-15 08:30:21','248','2021-01-15 08:30:47',10,0),('1','64',172892,'AFTERNOON SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'248',1381692.20,1381692.20,'248','2021-01-15 08:37:31','248','2021-01-15 08:41:37',10,0),('1','64',172895,'MORNING SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'248',652001.80,652001.80,'248','2021-01-17 16:14:56','248','2021-01-17 16:15:25',10,0),('1','64',173333,'AFTERNOON SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'248',1355960.00,1355960.00,'248','2021-01-17 16:18:15','248','2021-01-17 16:19:18',10,0),('1','64',173335,'MORNING SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'248',864945.20,864945.20,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',173337,'MORNING SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'248',869800.20,869800.20,'248','2021-01-17 16:28:30','248','2021-01-17 16:29:06',10,0),('1','64',173338,'AFTERNOON SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'248',1527823.20,1527823.20,'248','2021-01-17 16:33:41','248','2021-01-17 16:34:18',10,0),('1','64',173340,'MORNING SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'248',638885.00,638885.00,'248','2021-01-17 16:42:27','248','2021-01-17 16:43:45',10,0),('1','64',173352,'AFTERNOON SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'248',1257557.40,1257557.40,'248','2021-01-18 13:18:06','248','2021-01-18 13:18:33',10,0),('1','64',173506,'MORNING SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'248',823492.80,823492.80,'248','2021-01-18 13:21:08','248','2021-01-18 13:21:35',10,0),('1','64',173510,'AFTERNOON SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'248',1358174.40,1358174.40,'248','2021-01-19 10:42:15','248','2021-01-19 10:42:44',10,0),('1','64',173658,'MORNING SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'248',758464.00,758464.00,'248','2021-01-19 12:35:13','248','2021-01-19 12:36:42',10,0),('1','64',173688,'AFTERNOON SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'248',1341798.60,1341798.60,'248','2021-01-21 10:18:35','248','2021-01-21 10:19:11',10,0),('1','64',174006,'MORNING SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'248',622352.40,622352.40,'248','2021-01-21 10:22:17','248','2021-01-21 10:22:43',10,0),('1','64',174008,'AFTERNOON SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'248',1340393.20,1340393.20,'248','2021-01-21 10:32:00','248','2021-01-21 10:32:52',10,0),('1','64',174013,'MORNING SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'248',740944.40,740944.40,'248','2021-01-22 18:32:56','248','2021-01-22 18:33:31',10,0),('1','64',174307,'AFTERNOON SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'248',1709395.20,1709395.20,'248','2021-01-22 18:36:19','248','2021-01-22 18:36:49',10,0),('1','64',174309,'MORNING SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'248',794843.60,794843.60,'248','2021-01-22 18:39:05','248','2021-01-22 18:39:57',10,0),('1','64',174312,'AFTERNOON SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'248',1341212.40,1341212.40,'248','2021-01-25 11:12:08','248','2021-01-25 11:12:37',10,0),('1','64',174717,'MORNING SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'248',740491.40,740491.40,'248','2021-01-25 11:18:42','248','2021-01-25 11:19:08',10,0),('1','64',174722,'AFTERNOON SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'248',1305434.20,1305434.20,'248','2021-01-25 11:21:58','248','2021-01-25 11:22:27',10,0),('1','64',174725,'MORNING SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'248',673922.20,673922.20,'248','2021-01-25 13:02:55','248','2021-01-25 13:03:27',10,0),('1','64',174766,'AFTERNOON SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'248',1177249.20,1177249.20,'248','2021-01-25 13:23:57','248','2021-01-25 13:24:39',10,0),('1','64',174770,'MORNING SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'248',685991.00,685991.00,'248','2021-01-27 09:59:55','248','2021-01-27 10:00:21',10,0),('1','64',175107,'AFTERNOON SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'248',1439849.00,1439849.00,'248','2021-01-27 10:03:15','248','2021-01-27 10:03:51',10,0),('1','64',175108,'MORNING SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'248',110905.00,110905.00,'248','2021-01-27 10:05:35','248','2021-01-27 10:06:05',10,0),('1','64',175112,'PRICE CHANGE SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'248',530880.40,530880.40,'248','2021-01-27 10:10:38','248','2021-01-27 10:13:27',10,0),('1','64',175114,'AFTERNOON SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'248',1475127.00,1475127.00,'248','2021-01-27 17:35:45','248','2021-01-27 17:36:35',10,0),('1','64',175218,'MORNING SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'248',663862.20,668822.20,'248','2021-01-27 17:38:50','248','2021-01-27 17:39:43',10,0),('1','64',175219,'AFTERNOON SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'248',1385155.60,1398895.60,'248','2021-01-29 09:46:41','248','2021-01-29 09:47:23',10,0),('1','64',175462,'MORNING SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'248',692909.20,698549.20,'248','2021-01-29 09:51:43','248','2021-01-29 09:52:15',10,0),('1','64',175466,'AFTERNOON SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'248',1294219.40,1305739.40,'248','2021-01-29 23:30:27','248','2021-01-29 23:31:24',10,0),('1','64',175599,'MORNING SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'248',728484.00,733904.00,'248','2021-01-29 23:38:15','248','2021-01-29 23:38:56',10,0),('1','64',175600,'AFTERNOON SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'248',1009935.20,1026415.20,'248','2021-02-01 13:21:10','248','2021-02-01 13:22:07',10,0),('1','64',176054,'MORNING SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'248',1103090.60,1118850.60,'248','2021-02-01 13:28:42','248','2021-02-01 13:29:36',10,0),('1','64',176056,'AFTERNOON SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'248',1408851.60,1415071.60,'248','2021-02-01 13:46:13','248','2021-02-01 13:46:58',10,0),('1','64',176058,'MORNING SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'248',819077.60,822867.60,'248','2021-02-01 14:34:05','248','2021-02-01 14:36:34',10,0),('1','64',176071,'AFTERNOON SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'248',1471982.40,1482542.40,'248','2021-02-01 14:49:18','248','2021-02-01 15:03:06',10,0),('1','64',176083,'MORNING SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'248',480610.40,487290.40,'248','2021-02-01 15:06:58','248','2021-02-01 15:07:41',10,0),('1','64',176085,'AFTERNOON SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'248',189507.60,197087.60,'248','2021-02-03 09:49:43','248','2021-02-03 09:50:26',10,0),('1','64',176381,'MORNING SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'248',89537.20,93427.20,'248','2021-02-03 10:01:12','248','2021-02-03 10:01:48',10,0),('1','64',176387,'AFTERNOON SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'248',975356.80,987816.80,'248','2021-02-04 22:39:30','248','2021-02-04 22:40:11',10,0),('1','64',176779,'MORNING SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'248',897270.80,902680.80,'248','2021-02-04 22:43:28','248','2021-02-04 22:44:02',10,0),('1','64',176780,'AFTERNOON SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'248',1640368.40,1651658.40,'248','2021-02-04 22:49:13','248','2021-02-04 22:49:41',10,0),('1','64',176781,'MORNING SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'248',895631.20,902781.20,'248','2021-02-04 22:52:39','248','2021-02-04 22:53:10',10,0),('1','64',176782,'AFTERNOON SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'248',1573641.60,1582961.60,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',176984,'AFTERNOON SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'248',1587621.60,1587621.60,'248','2021-02-05 23:51:53','248','2021-02-05 23:52:23',10,0),('1','64',176985,'MORNING SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'248',787957.80,787957.80,'248','2021-02-05 23:55:54','248','2021-02-05 23:56:25',10,0),('1','64',176986,'AFTERNOON SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'248',1372675.60,1372675.60,'248','2021-02-06 22:26:07','248','2021-02-06 22:26:46',10,0),('1','64',177223,'MORNING SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'248',780065.00,780065.00,'248','2021-02-06 22:31:20','248','2021-02-06 22:31:57',10,0),('1','64',177225,'AFTERNOON SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'248',896337.00,896337.00,'248','2021-02-07 23:21:14','248','2021-02-07 23:22:04',10,0),('1','64',177426,'MORNING SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'248',101180.20,101180.20,'248','2021-02-07 23:24:08','248','2021-02-07 23:24:41',10,0),('1','64',177427,'AFTERNOON SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'248',82185.40,82185.40,'248','2021-02-09 12:23:17','248','2021-02-09 12:23:46',10,0),('1','64',177745,'MORNING SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'248',289132.80,289132.80,'248','2021-02-09 12:25:48','248','2021-02-09 12:26:22',10,0),('1','64',177747,'AFTERNOON SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'248',202411.00,202411.00,'248','2021-02-09 12:28:36','248','2021-02-09 12:29:10',10,0),('1','64',177749,'MORNING SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'248',150909.00,150909.00,'248','2021-02-09 12:31:05','248','2021-02-09 12:31:34',10,0),('1','64',177751,'AFTERNOON SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'248',154820.60,154820.60,'248','2021-02-10 23:01:27','248','2021-02-10 23:02:06',10,0),('1','64',178073,'MORNING SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'248',327428.20,327428.20,'248','2021-02-10 23:04:51','248','2021-02-10 23:06:32',10,0),('1','64',178074,'AFTERNOON SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'248',208857.00,208857.00,'248','2021-02-15 08:55:56','248','2021-02-15 08:56:27',10,0),('1','64',178941,'MORNING SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'248',187693.00,187693.00,'248','2021-02-15 08:58:19','248','2021-02-15 08:59:39',10,0),('1','64',178945,'AFTERNOON SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'248',636750.40,636750.40,'248','2021-02-15 09:08:30','248','2021-02-15 09:09:02',10,0),('1','64',178948,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',178951,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'248',220639.40,220639.40,'248','2021-02-15 09:22:06','248','2021-02-15 09:22:59',10,0),('1','64',178956,'AFTERNOON SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'248',521043.20,521043.20,'248','2021-02-15 09:25:42','248','2021-02-15 09:26:47',10,0),('1','64',178959,'MORNING SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'248',180098.60,180098.60,'248','2021-02-15 09:33:15','248','2021-02-15 09:33:47',10,0),('1','64',178963,'AFTERNOON SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',178972,'AFTERNOON SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'248',1876796.80,1876796.80,'248','2021-02-15 21:37:30','248','2021-02-15 21:38:15',10,0),('1','64',179123,'MORNING SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'248',806204.60,806204.60,'248','2021-02-17 09:39:05','248','2021-02-17 10:08:27',10,0),('1','64',179413,'AFTERNOON SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'248',2622567.20,2622567.20,'248','2021-02-17 10:15:24','248','2021-02-17 10:16:11',10,0),('1','64',179415,'MORNING SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'248',1167247.80,1167247.80,'248','2021-02-17 10:51:49','248','2021-02-17 10:52:57',10,0),('1','64',179428,'AFTERNOON SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'248',4779641.40,4779641.40,'248','2021-02-17 11:00:00','248','2021-02-17 11:00:46',10,0),('1','64',179433,'MORNING SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'248',976307.00,976307.00,'248','2021-02-17 11:12:30','248','2021-02-17 11:13:18',10,0),('1','64',179436,'AFTERNOON SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'248',2254969.00,2254969.00,'248','2021-02-18 12:03:22','248','2021-02-18 12:04:11',10,0),('1','64',179665,'MORNING SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'248',1082431.00,1082431.00,'248','2021-02-18 12:08:10','248','2021-02-18 12:08:40',10,0),('1','64',179668,'AFTERNOON SHIFT hi','2021-02-17','2021-02-17 00:00:00',NULL,'248',1777394.00,1777394.00,'248','2021-02-18 12:42:42','248','2021-02-18 12:43:15',10,0),('1','64',179678,'MORNING SHIFT it','2021-02-18','2021-02-18 00:00:00',NULL,'248',1082835.00,1082835.00,'248','2021-02-19 15:17:42','248','2021-02-19 15:18:09',10,0),('1','64',179929,'AFTERNOON SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'248',2014588.00,2014588.00,'248','2021-02-19 15:22:43','248','2021-02-19 15:23:13',10,0),('1','64',179934,'MORNING SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'248',1038147.00,1038147.00,'248','2021-02-19 15:26:26','248','2021-02-19 15:27:00',10,0),('1','64',179935,'AFTERNOON SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'248',1237985.00,1237985.00,'248','2021-02-21 18:47:02','248','2021-02-21 18:47:34',10,0),('1','64',180311,'MORNING SHIFTS','2021-02-20','2021-02-20 00:00:00',NULL,'248',136770.00,136770.00,'248','2021-02-21 18:49:58','248','2021-02-21 18:50:28',10,0),('1','64',180312,'AFTERNOON SHIFT ','2021-02-20','2021-02-20 00:00:00',NULL,'248',124080.00,124080.00,'248','2021-02-21 18:52:27','248','2021-02-21 18:53:05',10,0),('1','64',180313,'MORNING SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'248',600694.00,600694.00,'248','2021-02-21 18:55:42','248','2021-02-21 18:56:13',10,0),('1','64',180315,'AFTERNOON SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'248',1504656.00,1504656.00,'248','2021-02-25 12:25:19','248','2021-02-25 12:26:05',10,0),('1','64',181033,'MORNING SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'248',1375227.00,1375227.00,'248','2021-02-25 12:33:24','248','2021-02-25 12:34:01',10,0),('1','64',181036,'AFTERNOON SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'248',3280573.00,3280573.00,'248','2021-02-25 12:41:38','248','2021-02-25 12:42:59',10,0),('1','64',181041,'MORNING SHIFT ','2021-02-23','2021-02-23 00:00:00',NULL,'248',1286351.00,1286351.00,'248','2021-02-25 12:54:38','248','2021-02-25 12:55:36',10,0),('1','64',181044,'AFTERNOON SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'248',53345.00,53345.00,'248','2021-02-25 12:57:51','248','2021-02-25 12:58:41',10,0),('1','64',181047,'PRICE CHANGE SHIFT ','2021-02-23','2021-02-23 00:00:00',NULL,'248',2087779.00,2087779.00,'248','2021-02-25 13:06:30','248','2021-02-25 13:10:04',10,0),('1','64',181049,'MORNING SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'248',1270840.00,1270840.00,'248','2021-02-25 14:25:13','248','2021-02-25 14:25:42',10,0),('1','64',181073,'AFTERNOON SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'248',1758259.00,1758259.00,'248','2021-02-25 14:32:27','248','2021-02-25 14:33:55',10,0),('1','64',181075,'MORNING SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'248',167520.00,167520.00,'248','2021-02-25 14:38:45','248','2021-02-25 14:39:11',10,0),('1','64',181076,'AFTERNOON SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'248',99600.00,99600.00,'248','2021-02-28 10:13:20','248','2021-02-28 10:13:48',10,0),('1','64',181563,'PRICE CHANGE SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',181566,'PRICE CHANGE SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'248',31360.00,31360.00,'248','2021-02-28 10:18:37','248','2021-02-28 10:19:10',10,0),('1','64',181567,'MORNING SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'248',156555.00,156555.00,'248','2021-02-28 10:21:01','248','2021-02-28 10:22:31',10,0),('1','64',181569,'AFTERNOON SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'248',189140.00,189140.00,'248','2021-02-28 10:25:03','248','2021-02-28 10:25:31',10,0),('1','64',181571,'MORNING SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'248',184730.00,184730.00,'248','2021-02-28 10:28:37','248','2021-02-28 10:29:07',10,0),('1','64',181573,'AFTERNOON SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'248',162435.00,162435.00,'248','2021-02-28 10:32:16','248','2021-02-28 10:32:55',10,0),('1','64',181574,'MORNING SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'248',516136.00,516136.00,'248','2021-02-28 21:26:34','248','2021-02-28 21:27:08',10,0),('1','64',181694,'AFTERNOON SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'248',1615609.00,1615609.00,'248','2021-03-02 10:44:11','248','2021-03-02 10:44:34',10,0),('1','64',181983,'MORNING SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'248',681447.00,681447.00,'248','2021-03-02 10:47:27','248','2021-03-02 10:47:58',10,0),('1','64',181986,'AFTERNOON SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'248',342510.00,342510.00,'248','2021-03-04 09:04:02','248','2021-03-04 09:04:30',10,0),('1','64',182341,'MORNING SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'248',1201015.00,1201015.00,'248','2021-03-04 09:27:28','248','2021-03-04 09:27:54',10,0),('1','64',182346,'AFTERNOON SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'248',3143890.00,3143890.00,'248','2021-03-04 09:33:04','248','2021-03-04 09:34:26',10,0),('1','64',182347,'MORNING SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'248',1345290.00,1345290.00,'248','2021-03-04 09:38:15','248','2021-03-04 09:38:43',10,0),('1','64',182351,'AFTERNOON SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'248',1042120.00,1042120.00,'248','2021-03-04 09:42:13','248','2021-03-04 09:43:31',10,0),('1','64',182354,'MORNING SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'248',134505.00,134505.00,'248','2021-03-06 10:46:00','248','2021-03-06 10:46:25',10,0),('1','64',182735,'AFTERNOON SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'248',214865.00,214865.00,'248','2021-03-06 10:48:11','248','2021-03-06 10:48:59',10,0),('1','64',182737,'MORNING SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-06 10:50:26','248','2021-03-06 10:50:53',10,0),('1','64',182739,'AFTERNOON SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-06 10:51:58','248','2021-03-06 10:52:17',10,0),('1','64',182740,'MORNING SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'248',52920.00,52920.00,'248','2021-03-08 10:58:51','248','2021-03-08 10:59:20',10,0),('1','64',183062,'AFTERNOON SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-08 11:00:50','248','2021-03-08 11:01:31',10,0),('1','64',183063,'MORNING SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-08 11:04:16','248','2021-03-08 11:04:40',10,0),('1','64',183064,'AFTERNOON SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-08 11:06:13','248','2021-03-08 11:06:41',10,0),('1','64',183066,'MORNING SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-08 11:07:53','248','2021-03-08 11:08:17',10,0),('1','64',183068,'AFTERNOON SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-10 10:11:18','248','2021-03-10 10:11:47',10,0),('1','64',183485,'MORNING SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-10 10:12:56','248','2021-03-10 10:13:18',10,0),('1','64',183487,'AFTERNOON SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-10 10:14:26','248','2021-03-10 10:14:51',10,0),('1','64',183488,'MORNING SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-10 10:16:15','248','2021-03-10 10:17:03',10,0),('1','64',183489,'AFTERNOON SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-11 08:21:40','248','2021-03-11 08:22:12',10,0),('1','64',183668,'MORNING SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-11 13:06:44','248','2021-03-11 13:07:14',10,0),('1','64',183762,'AFTERNOON SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'248',1493890.00,1493890.00,'248','2021-03-11 23:14:47','248','2021-03-11 23:15:21',10,0),('1','64',183862,'MORNING SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'248',1575750.00,1575750.00,'248','2021-03-12 15:16:15','248','2021-03-12 15:16:47',10,0),('1','64',184027,'AFTERNOON SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'248',1570470.00,1570470.00,'248','2021-03-12 19:33:46','248','2021-03-12 19:34:10',10,0),('1','64',184247,'MORNING SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'248',43560.00,43560.00,'248','2021-03-13 20:06:09','248','2021-03-13 20:06:29',10,0),('1','64',184248,'AFTERNOON SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'248',283196.00,283196.00,'248','2021-03-13 20:09:39','248','2021-03-13 20:10:02',10,0),('1','64',184254,'MORNING SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'248',1023158.00,1023158.00,'248','2021-03-15 06:58:03','248','2021-03-15 06:58:38',10,0),('1','64',184477,'AFTERNOON SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'248',1219436.00,1219436.00,'248','2021-03-15 07:01:50','248','2021-03-15 07:02:23',10,0),('1','64',184479,'MORNING SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'248',888266.00,888266.00,'248','2021-03-15 20:32:17','248','2021-03-15 20:32:53',10,0),('1','64',184666,'AFTERNOON SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'248',398732.00,398732.00,'248','2021-03-15 20:34:31','248','2021-03-15 20:34:55',10,0),('1','64',184711,'MORNING SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'248',934414.00,934414.00,'248','2021-03-16 18:39:25','248','2021-03-16 18:39:52',10,0),('1','64',184854,'AFTERNOON SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'248',1381383.94,1381383.94,'248','2021-03-16 18:47:03','248','2021-03-16 18:49:18',10,0),('1','64',184890,'MORNING SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'248',1032712.00,1032712.00,'248','2021-03-17 13:46:59','248','2021-03-17 13:47:39',10,0),('1','64',185010,'AFTERNOON SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'248',354576.00,354576.00,'248','2021-03-17 22:01:09','248','2021-03-17 22:02:11',10,0),('1','64',185120,'MORNING SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',185212,'MORNING SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'248',377190.00,377190.00,'248','2021-03-18 14:23:01','612','2021-03-19 09:13:14',10,0),('1','64',185362,'AFTERNOON SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'248',1546050.00,1546050.00,'248','2021-03-19 14:44:55','612','2021-03-19 15:10:19',10,0),('1','64',185371,'MORNING SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'248',937530.00,937530.00,'248','2021-03-19 15:14:17','612','2021-03-19 17:08:43',10,0),('1','64',185443,'AFTERNOON SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'248',1655240.00,1655240.00,'248','2021-03-20 11:34:25','612','2021-03-20 11:46:08',10,0),('1','64',185553,'MORNING SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'248',1070800.00,1070800.00,'248','2021-03-20 13:02:31','612','2021-03-20 15:07:22',10,0),('1','64',185734,'AFTERNOON SHIFT ','2021-03-20','2021-03-20 00:00:00',NULL,'248',224960.00,224960.00,'248','2021-03-21 10:17:51','612','2021-03-21 11:11:57',10,0),('1','64',185861,'MORNING SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'248',24700.00,24700.00,'248','2021-03-21 23:00:07','612','2021-03-22 11:14:39',10,0),('1','64',185955,'AFTERNOON SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'248',53040.00,53040.00,'248','2021-03-22 11:20:43','612','2021-03-22 14:38:10',10,0),('1','64',186004,'MORNING SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'248',2600.00,2600.00,'248','2021-03-22 15:01:44','612','2021-03-22 16:43:01',10,0),('1','64',186061,'AFTERNOON SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'248',31200.00,31200.00,'248','2021-03-22 20:54:26','612','2021-03-23 07:29:55',10,0),('1','64',186127,'MORNING SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',186129,'MORNING SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'248',0.00,0.00,'248','2021-03-24 11:03:41','612','2021-03-24 11:09:24',10,0),('1','64',186451,'AFTERNOON SHIFT ','2021-03-23','2021-03-23 00:00:00',NULL,'248',2069644.00,2069644.00,'248','2021-03-24 14:43:52','612','2021-03-24 15:19:41',10,0),('1','64',186507,'MORNING SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'248',1155008.00,1155008.00,'248','2021-03-24 20:32:31','612','2021-03-24 20:42:24',10,0),('1','64',186517,'AFTERNOON SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'248',2149996.00,2149996.00,'248','2021-03-24 23:41:44','612','2021-03-25 07:05:28',10,0),('1','64',186546,'MORNING SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'248',1129192.00,1129192.00,'248','2021-03-25 19:31:35','612','2021-03-25 23:18:22',10,0),('1','64',186756,'AFTERNOON SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'248',2038222.00,2038222.00,'248','2021-03-26 06:48:37','612','2021-03-26 07:42:35',10,0),('1','64',186797,'MORNING SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'248',1906180.00,1906180.00,'248','2021-03-26 16:32:59','612','2021-03-27 06:10:18',10,0),('1','64',186987,'AFTERNOON SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'248',1928350.00,1928350.00,'248','2021-03-27 07:04:32','612','2021-03-27 07:55:36',10,0),('1','64',187063,'MORNING SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'248',1596461.00,1596461.00,'248','2021-03-27 13:48:22','612','2021-03-27 17:11:31',10,0),('1','64',187127,'AFTERNOON SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'248',1453425.00,1453425.00,'248','2021-03-28 06:54:14','612','2021-03-28 07:51:05',10,0),('1','64',187408,'MORNING SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'248',1191030.00,1191030.00,'248','2021-03-29 09:13:06','612','2021-03-29 09:17:41',10,0),('1','64',187412,'AFTERNOON SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'248',2105568.00,2105568.00,'248','2021-03-29 09:21:18','612','2021-03-29 12:28:53',10,0),('1','64',187500,'MORNING SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'248',1188237.00,1188237.00,'248','2021-03-29 20:30:25','612','2021-03-29 20:53:00',10,0),('1','64',187638,'AFTERNOON SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'248',2340941.00,2340941.00,'248','2021-03-30 09:17:25','612','2021-03-30 09:22:46',10,0),('1','64',187649,'MORNING SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',187652,'MORNING SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'248',1009705.00,1009705.00,'248','2021-03-30 12:58:37','612','2021-03-30 16:55:15',10,0),('1','64',187753,'AFTERNOON SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'248',127140.00,127140.00,'248','2021-03-30 19:21:32','612','2021-03-31 07:20:14',10,0),('1','64',187824,'MORNING SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'248',43160.00,43160.00,'248','2021-03-31 12:44:41','612','2021-03-31 15:16:05',10,0),('1','64',187993,'AFTERNOON SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'248',99840.00,99840.00,'248','2021-03-31 20:19:13','612','2021-04-01 07:06:07',10,0),('1','64',188038,'MORNING SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'248',1144120.00,1144120.00,'248','2021-04-01 14:56:09','612','2021-04-01 17:38:58',10,0),('1','64',188240,'AFTERNOON SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'248',2129030.00,2129030.00,'248','2021-04-02 15:12:34','612','2021-04-02 16:20:06',10,0),('1','64',188388,'MORNING SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'248',1273520.00,1273520.00,'248','2021-04-02 19:55:04','612','2021-04-03 08:47:13',10,0),('1','64',188458,'AFTERNOON SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'248',2032505.00,2032505.00,'248','2021-04-03 15:01:14','612','2021-04-04 06:36:03',10,0),('1','64',188683,'MORNING SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'248',1202685.00,1202685.00,'248','2021-04-04 15:10:00','612','2021-04-04 15:37:36',10,0),('1','64',188789,'AFTERNOON SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'248',1822425.00,1822425.00,'248','2021-04-05 10:39:39','612','2021-04-05 13:39:07',10,0),('1','64',188974,'MORNING SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'248',956085.00,956085.00,'248','2021-04-06 09:20:06','612','2021-04-06 09:40:07',10,0),('1','64',189068,'AFTERNOON SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'248',1474935.00,1474935.00,'248','2021-04-06 10:51:20','612','2021-04-06 11:37:45',10,0),('1','64',189170,'MORNING SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'248',999405.00,999405.00,'248','2021-04-06 19:13:25','612','2021-04-07 08:11:24',10,0),('1','64',189381,'AFTERNOON SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'248',1406130.00,1406130.00,'248','2021-04-07 18:41:31','612','2021-04-08 07:42:47',10,0),('1','64',189567,'MORNING SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'248',1024980.00,1024980.00,'248','2021-04-08 16:13:46','612','2021-04-09 00:05:56',10,0),('1','64',189678,'AFTERNOON SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'248',1228825.00,1228825.00,'248','2021-04-09 13:56:03','612','2021-04-09 15:43:01',10,0),('1','64',189766,'MORNING SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'248',1226895.00,1226895.00,'248','2021-04-09 16:37:58','612','2021-04-09 19:21:55',10,0),('1','64',189799,'AFTERNOON SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'248',2064600.00,2064600.00,'248','2021-04-09 21:09:58','612','2021-04-10 05:20:52',10,0),('1','64',189850,'MORNING SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'248',1211465.00,1211465.00,'248','2021-04-10 08:48:27','612','2021-04-10 10:38:21',10,0),('1','64',189994,'AFTERNOON SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'248',2029250.00,2029250.00,'248','2021-04-10 18:20:56','612','2021-04-11 00:58:41',10,0),('1','64',190073,'MORNING SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'248',1020305.00,1020305.00,'248','2021-04-11 10:53:41','612','2021-04-11 13:48:25',10,0),('1','64',190129,'AFTERNOON SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'248',236600.00,236600.00,'248','2021-04-11 14:00:07','612','2021-04-11 22:16:17',10,0),('1','64',190262,'MORNING SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'248',1133765.00,1133765.00,'248','2021-04-12 14:07:05','612','2021-04-12 16:03:17',10,0),('1','64',190520,'AFTERNOON SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'248',1826200.00,1826200.00,'248','2021-04-13 12:06:35','612','2021-04-13 12:20:11',10,0),('1','64',190549,'MORNING SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'248',1079465.00,1079465.00,'248','2021-04-13 12:23:11','612','2021-04-13 12:25:09',10,0),('1','64',190552,'AFTERNOON SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'248',1384115.00,1384115.00,'248','2021-04-13 12:30:10','612','2021-04-13 12:39:59',10,0),('1','64',190553,'MORNING SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'248',125060.00,125060.00,'248','2021-04-13 12:44:30','612','2021-04-13 12:51:16',10,0),('1','64',190555,'AFTERNOON SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'248',138580.00,138580.00,'248','2021-04-13 12:53:47','612','2021-04-13 12:55:28',10,0),('1','64',190559,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'248',73060.00,73060.00,'248','2021-04-13 13:00:18','612','2021-04-13 13:04:42',10,0),('1','64',190563,'AFTERNOON SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'248',144820.00,144820.00,'248','2021-04-13 19:52:45','612','2021-04-14 07:27:47',10,0),('1','64',190770,'MORNING SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'248',74620.00,74620.00,'248','2021-04-14 12:30:58','612','2021-04-14 13:03:47',10,0),('1','64',190868,'AFTERNOON SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'248',1253460.00,1253460.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',191003,'AFTERNOON SHIFT ','2021-04-14','2021-04-14 00:00:00',NULL,'248',1253460.00,1253460.00,'248','2021-04-15 13:50:01','612','2021-04-15 13:52:40',10,0),('1','64',191055,'MORNING SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'248',172640.00,172640.00,'248','2021-04-15 20:45:09','612','2021-04-16 09:18:31',10,0),('1','64',191160,'AFTERNOON SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'248',391040.00,391040.00,'248','2021-04-16 11:35:58','612','2021-04-16 13:07:44',10,0),('1','64',191226,'MORNING SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'248',953910.00,953910.00,'248','2021-04-16 15:13:27','612','2021-04-16 17:05:08',10,0),('1','64',191270,'AFTERNOON SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'248',1692125.00,1692125.00,'248','2021-04-17 12:07:35','612','2021-04-17 14:00:02',10,0),('1','64',191448,'MORNING SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'248',1259835.00,1259835.00,'248','2021-04-17 21:22:28','612','2021-04-18 08:33:30',10,0),('1','64',191616,'AFTERNOON SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'248',1997610.00,1997610.00,'248','2021-04-19 11:38:36','612','2021-04-19 13:21:48',10,0),('1','64',191864,'MORNING SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'248',1448040.00,946840.00,'248','2021-04-19 13:48:12','612','2021-04-19 19:46:08',10,0),('1','64',192015,'AFTERNOON SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'248',2530040.00,1682840.00,'248','2021-04-20 11:21:15','612','2021-04-20 11:34:17',10,0),('1','64',192032,'MORNING SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'248',1619595.00,1067295.00,'248','2021-04-20 12:24:29','612','2021-04-20 13:12:08',10,0),('1','64',192046,'AFTERNOON SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'248',805610.00,657410.00,'248','2021-04-20 13:18:47','612','2021-04-20 13:26:11',10,0),('1','64',192058,'MORNING SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'248',85800.00,85800.00,'248','2021-04-20 13:47:33','612','2021-04-20 14:25:53',10,0),('1','64',192111,'AFTERNOON SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'248',221260.00,221260.00,'248','2021-04-20 19:44:58','612','2021-04-21 09:06:42',10,0),('1','64',192308,'MORNING SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'248',1460015.00,984515.00,'248','2021-04-22 12:29:52','612','2021-04-22 14:41:20',10,0),('1','64',192508,'AFTERNOON SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'248',1543895.00,1543895.00,'248','2021-04-22 15:14:58','612','2021-04-23 09:49:01',10,0),('1','64',192648,'MORNING SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'248',840650.00,840650.00,'248','2021-04-23 11:40:55','612','2021-04-23 16:11:59',10,0),('1','64',192735,'AFTERNOON SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'248',479500.00,479500.00,'248','2021-04-23 20:04:07','612','2021-04-24 09:54:10',10,0),('1','64',192847,'MORNING SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'248',56420.00,56420.00,'248','2021-04-24 13:16:51','612','2021-04-24 13:48:28',10,0),('1','64',192927,'AFTERNOON SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'248',181220.00,181220.00,'248','2021-04-24 18:39:30','612','2021-04-25 09:06:05',10,0),('1','64',193098,'MORNING SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'248',76440.00,76440.00,'248','2021-04-25 14:37:32','612','2021-04-25 17:03:28',10,0),('1','64',193231,'AFTERNOON SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'248',244920.00,244920.00,'248','2021-04-26 11:11:34','612','2021-04-26 11:57:51',10,0),('1','64',193275,'MORNING SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'248',731015.00,731015.00,'248','2021-04-26 12:37:45','612','2021-04-26 12:42:45',10,0),('1','64',193353,'AFTERNOON SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'248',1393140.00,1393140.00,'248','2021-04-26 16:18:25','612','2021-04-26 20:07:51',10,0),('1','64',193383,'MORNING SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'248',847470.00,847470.00,'248','2021-04-26 20:18:52','612','2021-04-27 08:59:02',10,0),('1','64',193495,'AFTERNOON SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'248',1546560.00,1546560.00,'248','2021-04-27 11:38:34','612','2021-04-27 14:47:31',10,0),('1','64',193729,'MORNING SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'248',843705.00,843705.00,'248','2021-04-28 12:30:05','612','2021-04-28 14:27:12',10,0),('1','64',193829,'AFTERNOON SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'248',1667080.00,1667080.00,'248','2021-04-28 20:03:35','612','2021-04-29 07:59:11',10,0),('1','64',193953,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'248',844295.00,844295.00,'248','2021-04-29 11:09:11','612','2021-04-29 11:24:35',10,0),('1','64',194002,'AFTERNOON SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'248',1494885.00,1494885.00,'248','2021-04-29 13:59:14','612','2021-04-29 14:55:38',10,0),('1','64',194017,'MORNING SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'248',917795.00,917795.00,'248','2021-04-29 15:00:47','612','2021-04-29 15:14:05',10,0),('1','64',194020,'AFTERNOON SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'248',3314385.00,3314385.00,'248','2021-04-30 20:33:42','612','2021-05-01 07:20:18',10,0),('1','64',194435,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'248',865450.00,865450.00,'248','2021-05-01 15:50:05','612','2021-05-01 16:19:42',10,0),('1','64',194447,'AFTERNOON SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'248',1897910.00,1897910.00,'248','2021-05-01 16:50:50','612','2021-05-02 05:48:51',10,0),('1','64',194784,'MORNING SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'248',1713135.00,1713135.00,'248','2021-05-03 12:09:30','612','2021-05-03 14:37:07',10,0),('1','64',194859,'AFTERNOON SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'248',1323630.00,1323630.00,'248','2021-05-03 19:51:06','612','2021-05-04 10:17:28',10,0),('1','64',194906,'MORNING SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'248',428840.00,428840.00,'248','2021-05-04 11:13:01','612','2021-05-04 11:24:12',10,0),('1','64',194998,'AFTERNOON SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'248',62660.00,62660.00,'248','2021-05-04 14:57:29','612','2021-05-04 17:44:47',10,0),('1','64',195058,'MORNING SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'248',75140.00,75140.00,'248','2021-05-04 20:13:50','612','2021-05-04 20:55:30',10,0),('1','64',195176,'AFTERNOON SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'248',72800.00,72800.00,'248','2021-05-05 11:18:15','612','2021-05-05 13:51:01',10,0),('1','64',195265,'MORNING SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'248',49920.00,49920.00,'248','2021-05-05 16:15:05','612','2021-05-05 17:02:39',10,0),('1','64',195381,'AFTERNOON SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'248',264420.00,264420.00,'248','2021-05-06 10:30:19','612','2021-05-06 11:08:31',10,0),('1','64',195392,'MORNING SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'248',80080.00,80080.00,'248','2021-05-06 11:09:38','612','2021-05-06 11:15:20',10,0),('1','64',195404,'AFTERNOON SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'248',0.00,0.00,'248','2021-05-06 11:39:11','612','2021-05-06 12:01:12',10,0),('1','64',195415,'MORNING SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'248',0.00,0.00,'248','2021-05-06 12:11:22','612','2021-05-06 13:07:00',10,0),('1','64',195479,'AFTERNOON SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'248',0.00,0.00,'248','2021-05-07 09:08:49','612','2021-05-07 13:19:25',10,0),('1','64',195691,'MORNING SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'248',788780.00,788780.00,'248','2021-05-07 14:36:50','612','2021-05-07 15:45:54',10,0),('1','64',195735,'AFTERNOON SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'248',1292940.00,1292940.00,'248','2021-05-08 09:15:48','612','2021-05-08 10:51:46',10,0),('1','64',195907,'MORNING SHIFT ','2021-05-08','2021-05-08 00:00:00',NULL,'248',649770.00,649770.00,'248','2021-05-08 13:51:58','612','2021-05-08 20:58:33',10,0),('1','64',195980,'AFTERNOON SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'248',1095270.00,1095270.00,'248','2021-05-08 21:14:14','612','2021-05-09 09:59:59',10,0),('1','64',196090,'MORNING SHIFT ','2021-05-09','2021-05-09 00:00:00',NULL,'248',686815.00,686815.00,'248','2021-05-09 12:24:23','612','2021-05-09 17:45:20',10,0),('1','64',196196,'AFTERNOON SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'248',1268685.00,1268685.00,'248','2021-05-10 13:34:01','455','2021-05-10 14:42:17',10,0),('1','64',196377,'MORNING SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'248',674235.00,674235.00,'248','2021-05-10 15:27:14','612','2021-05-10 20:52:30',10,0),('1','64',196422,'AFTERNOON SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'248',631620.00,631620.00,'248','2021-05-10 21:00:26','612','2021-05-11 07:18:40',10,0),('1','64',196481,'MORNING SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'248',682605.00,682605.00,'248','2021-05-11 15:44:03','612','2021-05-11 16:30:49',10,0),('1','64',196644,'AFTERNOON SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'248',1274790.00,1274790.00,'248','2021-05-12 08:15:48','612','2021-05-12 10:55:13',10,0),('1','64',196819,'MORNING SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'248',655875.00,655875.00,'248','2021-05-12 16:36:21','612','2021-05-12 18:30:38',10,0),('1','64',196856,'AFTERNOON SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'248',1323950.00,1323950.00,'248','2021-05-13 15:08:18','612','2021-05-13 15:40:18',10,0),('1','64',197091,'MORNING SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'248',712520.00,712520.00,'248','2021-05-14 09:04:28','612','2021-05-14 14:27:18',10,0),('1','64',197154,'AFTERNOON SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'248',1408805.00,1408805.00,'248','2021-05-14 15:44:23','612','2021-05-14 20:46:52',10,0),('1','64',197208,'MORNING SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'248',875585.00,875585.00,'248','2021-05-14 21:27:05','612','2021-05-16 11:53:04',10,0),('1','64',197549,'AFTERNOON SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'248',0.00,0.00,'248','2021-05-17 08:38:05','455','2021-05-17 08:44:12',10,0),('1','64',197565,'AFTERNOON SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'248',2648295.00,2648295.00,'248','2021-05-17 08:52:31','455','2021-05-17 08:55:44',10,0),('1','64',197568,'MORNING SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'248',1038040.00,1038040.00,'248','2021-05-17 08:59:48','455','2021-05-17 09:32:03',10,0),('1','64',197584,'AFTERNOON SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'248',1555060.00,1555060.00,'248','2021-05-17 10:07:52','455','2021-05-17 10:24:10',10,0),('1','64',197607,'MORNING SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'248',1463175.00,1463175.00,'248','2021-05-17 10:32:40','455','2021-05-17 10:40:49',10,0),('1','64',197627,'AFTERNOON SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'248',1333150.00,1333150.00,'248','2021-05-17 10:55:10','612','2021-05-17 11:52:50',10,0),('1','64',197700,'MORNING SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'248',884460.00,884460.00,'248','2021-05-17 13:15:59','612','2021-05-17 13:44:21',10,0),('1','64',197854,'AFTERNOON SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'248',2031335.00,2031335.00,'248','2021-05-18 08:44:05','612','2021-05-18 09:05:53',10,0),('1','64',198043,'MORNING SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'248',834250.00,834250.00,'248','2021-05-18 14:57:37','612','2021-05-18 16:14:59',10,0),('1','64',198149,'AFTERNOON SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'248',1685910.00,1685910.00,'248','2021-05-19 08:14:26','612','2021-05-19 08:24:57',10,0),('1','64',198191,'MORNING SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'248',814455.00,814455.00,'248','2021-05-19 13:04:21','612','2021-05-19 16:08:30',10,0),('1','64',198392,'AFTERNOON SHIFT ','2021-05-19','2021-05-19 00:00:00',NULL,'248',1370655.00,1370655.00,'248','2021-05-20 08:31:38','612','2021-05-20 09:00:21',10,0),('1','64',198501,'MORNING SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'248',661485.00,661485.00,'248','2021-05-20 16:18:48','612','2021-05-20 17:02:26',10,0),('1','64',198613,'AFTERNOON SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'248',1318845.00,1318845.00,'248','2021-05-21 08:20:50','612','2021-05-21 10:18:30',10,0),('1','64',198693,'MORNING SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'248',755785.00,755785.00,'248','2021-05-21 14:26:26','612','2021-05-21 14:41:25',10,0),('1','64',198764,'AFTERNOON SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'248',976800.00,976800.00,'248','2021-05-22 08:32:10','612','2021-05-22 09:03:28',10,0),('1','64',198859,'MORNING SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'248',713070.00,713070.00,'248','2021-05-22 14:13:16','612','2021-05-23 08:24:51',10,0),('1','64',199051,'AFTERNOON SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'248',1199880.00,1199880.00,'248','2021-05-23 10:22:34','612','2021-05-23 13:46:24',10,0),('1','64',199294,'MORNING SHIFTS','2021-05-23','2021-05-23 00:00:00',NULL,'248',652905.00,652905.00,'248','2021-05-24 09:20:42','612','2021-05-24 09:33:15',10,0),('1','64',199312,'AFTERNOON SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'248',1110780.00,1110780.00,'248','2021-05-24 09:58:53','612','2021-05-24 11:19:53',10,0),('1','64',199406,'MORNING SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'248',678645.00,678645.00,'248','2021-05-24 19:57:27','612','2021-05-25 05:56:42',10,0),('1','64',199471,'AFTERNOON SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'248',1137180.00,1137180.00,'248','2021-05-25 08:02:26','612','2021-05-25 09:27:05',10,0),('1','64',199623,'MORNING SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'248',689625.00,689625.00,'248','2021-05-26 01:29:25','612','2021-05-26 08:32:05',10,0),('1','64',199742,'AFTERNOON SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'248',1398650.00,1398650.00,'248','2021-05-26 11:19:00','612','2021-05-26 13:53:57',10,0),('1','64',199849,'MORNING SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'248',1166210.00,1166210.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',200029,'MORNING SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',200031,'MORNING SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'248',1166210.00,1166210.00,'248','2021-05-27 14:36:57','612','2021-05-27 14:47:46',10,0),('1','64',200046,'AFTERNOON SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'248',1427080.00,1427080.00,'248','2021-05-27 15:31:01','612','2021-05-27 16:48:02',10,0),('1','64',200076,'MORNING SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'248',921250.00,921250.00,'248','2021-05-27 20:11:30','612','2021-05-27 21:43:37',10,0),('1','64',200112,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'248',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','64',200123,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'248',1729545.00,1729545.00,'248','2021-05-28 08:52:57','455','2021-05-28 09:06:26',10,0),('1','64',200279,'MORNING SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'248',801360.00,801360.00,'248','2021-05-29 01:06:08','612','2021-05-29 05:31:37',10,0),('1','64',200477,'AFTERNOON SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'248',304485.00,304485.00,'248','2021-05-30 01:50:11','540','2021-05-30 10:18:44',10,0),('1','64',200586,'MORNING SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'248',640565.00,640565.00,'248','2021-05-30 12:26:42','612','2021-05-30 14:18:55',10,0),('1','64',200647,'AFTERNOON SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'248',1508700.00,1508700.00,'248','2021-05-30 16:13:44','612','2021-05-31 05:35:34',10,0),('1','64',200903,'MORNING SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'248',749300.00,749300.00,'248','2021-06-01 01:21:38','612','2021-06-01 05:46:38',10,0),('1','64',200979,'AFTERNOON SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'248',1200125.00,1200125.00,'248','2021-06-01 09:37:55','540','2021-06-01 09:47:56',10,0),('1','64',200982,'MORNING SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'248',733290.00,733290.00,'248','2021-06-01 09:58:30','540','2021-06-01 10:13:36',10,0),('1','64',200989,'AFTERNOON SHIFT ','2021-05-31','2021-05-31 00:00:00',NULL,'248',1452235.00,1452235.00,'248','2021-06-01 10:26:19','612','2021-06-01 10:43:31',10,0),('1','64',201051,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'248',537690.00,537690.00,'248','2021-06-01 16:22:29','612','2021-06-02 05:43:19',10,0),('1','64',201144,'AFTERNOON SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'248',1567895.00,1567895.00,'248','2021-06-02 08:10:42','612','2021-06-02 12:30:39',10,0),('1','64',201241,'MORNING SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'248',691060.00,691060.00,'248','2021-06-02 14:37:20','612','2021-06-02 16:21:28',10,0),('1','64',201290,'AFTERNOON SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'248',1367960.00,1367960.00,'248','2021-06-03 11:31:42','612','2021-06-03 14:17:34',10,0),('1','64',201438,'MORNING SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'248',780290.00,780290.00,'248','2021-06-03 17:06:56','612','2021-06-04 06:40:54',10,0),('1','64',201550,'AFTERNOON SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'248',1483930.00,1483930.00,'248','2021-06-04 10:13:15','612','2021-06-04 12:16:04',10,0),('1','64',201729,'MORNING SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'248',692585.00,692585.00,'248','2021-06-04 19:07:10','612','2021-06-05 06:38:32',10,0),('1','64',201801,'AFTERNOON SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'248',1520760.00,1520760.00,'248','2021-06-05 08:18:01','612','2021-06-05 13:38:06',10,0),('1','64',201933,'MORNING SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'248',723540.00,723540.00,'248','2021-06-05 15:05:04','612','2021-06-05 17:26:23',10,0),('1','64',202002,'AFTERNOON SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'248',1361280.00,1361280.00,'248','2021-06-05 20:57:25','612','2021-06-06 11:16:16',10,0),('1','64',202128,'MORNING SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'248',587550.00,587550.00,'248','2021-06-06 13:39:22','612','2021-06-06 15:03:17',10,0),('1','64',202324,'AFTERNOON SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'248',1293240.00,1293240.00,'248','2021-06-07 12:04:03','612','2021-06-07 14:19:36',10,0),('1','64',202405,'MORNING SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'248',270375.00,270375.00,'248','2021-06-07 21:02:07','612','2021-06-08 07:54:40',10,0),('1','64',202503,'AFTERNOON SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'248',782895.00,782895.00,'248','2021-06-08 10:53:34','612','2021-06-08 14:05:01',10,0),('1','64',202600,'MORNING SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'248',668235.00,668235.00,'248','2021-06-08 16:53:58','612','2021-06-09 07:52:04',10,0),('1','64',202736,'AFTERNOON SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'248',1189965.00,1189965.00,'248','2021-06-09 10:40:41','612','2021-06-09 12:47:56',10,0),('1','64',202824,'MORNING SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'248',827220.00,827220.00,'248','2021-06-09 20:33:35','612','2021-06-10 07:50:57',10,0),('1','64',203007,'AFTERNOON SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'248',1036170.00,1036170.00,'248','2021-06-10 13:57:21','612','2021-06-10 14:10:48',10,0),('1','64',203016,'MORNING SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'248',732705.00,732705.00,'248','2021-06-10 15:12:41','612','2021-06-11 07:59:53',10,0),('1','64',203185,'AFTERNOON SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'248',1281795.00,1281795.00,'248','2021-06-11 10:26:31','612','2021-06-11 19:04:38',10,0),('1','64',203377,'MORNING SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'248',887700.00,887700.00,'248','2021-06-12 10:44:29','612','2021-06-12 14:52:04',10,0),('1','64',203492,'AFTERNOON SHIFT ','2021-06-11','2021-06-11 00:00:00',NULL,'248',1443990.00,1443990.00,'248','2021-06-12 18:33:18','612','2021-06-12 18:36:53',10,0),('1','64',203494,'MORNING SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'248',36720.00,36720.00,'248','2021-06-12 18:55:54','612','2021-06-13 09:17:28',10,0),('1','64',203700,'AFTERNOON SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'248',275400.00,275400.00,'248','2021-06-13 20:16:51','612','2021-06-14 07:45:15',10,0),('1','64',203830,'MORNING SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'248',541935.00,541935.00,'248','2021-06-14 11:45:58','612','2021-06-14 12:43:15',10,0),('1','64',203936,'AFTERNOON SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'248',1011165.00,1011165.00,'248','2021-06-14 19:16:06','612','2021-06-15 08:47:58',10,0),('1','64',204045,'MORNING SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'248',704565.00,704565.00,'248','2021-06-15 10:24:56','612','2021-06-15 11:38:57',10,0),('1','64',204096,'AFTERNOON SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'248',2417370.00,2417370.00,'248','2021-06-15 13:50:12','612','2021-06-15 17:16:03',10,0),('1','64',204162,'MORNING SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'248',726525.00,726525.00,'248','2021-06-15 20:48:38','612','2021-06-16 08:14:07',10,0),('1','64',204239,'AFTERNOON SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'248',1474680.00,1474680.00,'248','2021-06-16 09:15:08','612','2021-06-16 15:23:34',10,0),('1','64',204378,'MORNING SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'248',723135.00,723135.00,'248','2021-06-17 13:27:39','612','2021-06-17 14:16:30',10,0),('1','64',204554,'AFTERNOON SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'248',420900.00,420900.00,'248','2021-06-17 14:50:28','612','2021-06-17 15:49:26',10,0),('1','64',204596,'MORNING SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'248',642165.00,642165.00,'248','2021-06-17 21:38:01','612','2021-06-18 07:35:18',10,0),('1','64',204710,'AFTERNOON SHIFT ','2021-06-17','2021-06-17 00:00:00',NULL,'248',1275630.00,1275630.00,'248','2021-06-18 11:32:57','612','2021-06-18 13:08:06',10,0),('1','64',204789,'MORNING SHIFT ','2021-06-18','2021-06-18 00:00:00',NULL,'248',820035.00,820035.00,'248','2021-06-18 20:24:31','612','2021-06-19 08:47:56',10,0),('1','64',204920,'AFTERNOON SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'248',1098150.00,1098150.00,'248','2021-06-19 10:39:44','612','2021-06-19 13:16:31',10,0),('1','64',205019,'MORNING SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'248',92340.00,92340.00,'248','2021-06-19 19:05:44','612','2021-06-20 09:03:33',10,0),('1','64',205188,'AFTERNOON SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'248',101250.00,101250.00,'248','2021-06-20 17:30:30','612','2021-06-21 06:30:54',10,0),('1','64',205328,'MORNING SHIFT ','2021-06-20','2021-06-20 00:00:00',NULL,'248',89910.00,89910.00,'248','2021-06-21 11:17:53','612','2021-06-21 13:45:39',10,0),('1','64',205434,'AFTERNOON SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'248',142020.00,142020.00,'248','2021-06-21 17:30:17','612','2021-06-22 11:09:18',10,0),('1','64',205601,'MORNING SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'248',140400.00,140400.00,'248','2021-06-22 12:59:53','612','2021-06-22 20:16:38',10,0),('1','64',205795,'AFTERNOON SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'248',43200.00,43200.00,'248','2021-06-23 09:43:02','612','2021-06-23 09:44:47',10,0),('1','64',205800,'PRICE CHANGE SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'248',709160.00,709160.00,'248','2021-06-23 10:03:09','612','2021-06-23 10:44:53',10,0),('1','64',205828,'MORNING SHIFT ','2021-06-22','2021-06-22 00:00:00',NULL,'248',749402.00,749402.00,'248','2021-06-23 11:47:49','612','2021-06-23 12:25:54',10,0),('1','64',205857,'AFTERNOON SHIFT ','2021-06-22','2021-06-22 00:00:00',NULL,'248',1900900.00,1900900.00,'248','2021-06-23 13:27:50','612','2021-06-23 13:32:53',10,0),('1','64',205861,'MORNING SHIFT ','2021-06-23','2021-06-23 00:00:00',NULL,'248',577950.00,577950.00,'248','2021-06-23 13:37:31','612','2021-06-23 13:39:21',10,0),('1','64',205873,'AFTERNOON SHIFT ','2021-06-23','2021-06-23 00:00:00',NULL,'248',1084668.00,1084668.00,'248','2021-06-24 12:01:46','612','2021-06-24 13:51:05',10,0),('1','64',206115,'MORNING SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'248',950615.00,950615.00,'248','2021-06-24 18:41:23','612','2021-06-25 07:12:38',10,0),('1','64',206228,'AFTERNOON SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'248',1357814.00,1357814.00,'248','2021-06-25 10:03:07','612','2021-06-25 13:10:22',10,0),('1','64',206338,'MORNING SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'248',693238.00,693238.00,'248','2021-06-25 21:24:22','612','2021-06-26 08:55:12',10,0),('1','64',206483,'AFTERNOON SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'248',1291117.00,1291117.00,'248','2021-06-26 13:31:55','612','2021-06-26 15:53:08',10,0),('1','64',206540,'Morning shift ','2021-06-26','2021-06-26 00:00:00',NULL,'248',717986.00,717986.00,'248','2021-06-27 20:59:01','612','2021-06-28 07:00:17',10,0),('1','64',206848,'AFTERNOON SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'248',1302927.00,1302927.00,'248','2021-06-28 15:16:03','612','2021-06-28 15:20:42',10,0),('1','64',206972,'MORNING SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'248',548103.00,548103.00,'248','2021-06-28 15:25:28','612','2021-06-28 16:06:33',10,0),('1','64',206992,'AFTERNOON SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'248',1030143.00,1030143.00,'248','2021-06-28 18:46:19','612','2021-06-29 05:42:13',10,0),('1','64',207067,'MORNING SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'248',661696.00,661696.00,'248','2021-06-29 08:20:29','612','2021-06-29 08:23:53',10,0),('1','64',207071,'AFTERNOON SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'248',1563240.00,1563240.00,'248','2021-06-29 08:30:23','612','2021-06-29 08:40:10',10,0),('1','64',207152,'MORNING SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'248',764889.00,764889.00,'248','2021-06-29 13:35:34','612','2021-06-29 15:16:38',10,0),('1','64',207355,'AFTERNOON SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'248',1216983.00,1216983.00,'248','2021-06-30 11:54:45','612','2021-06-30 11:57:49',10,0),('1','64',207382,'MORNING SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'248',800035.00,800035.00,'248','2021-06-30 13:18:45','612','2021-06-30 13:49:10',10,0),('1','64',207575,'AFTERNOON SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'248',1330901.00,1330901.00,'248','2021-07-01 12:11:38','612','2021-07-01 14:20:36',10,0),('1','64',207629,'MORNING SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'248',671935.00,671935.00,'248','2021-07-01 16:36:05','612','2021-07-01 17:00:15',10,0),('1','64',207801,'AFTERNOON SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'248',1483101.00,1483101.00,'248','2021-07-02 11:46:45','612','2021-07-02 11:51:33',10,0),('1','64',207855,'MORNING SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'248',766142.00,766142.00,'248','2021-07-02 16:05:33','612','2021-07-02 16:23:54',10,0),('1','64',207874,'AFTERNOON SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'248',1653945.00,1653945.00,'248','2021-07-03 14:53:22','612','2021-07-03 16:36:01',10,0),('1','64',208092,'MORNING SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'248',787262.00,787262.00,'248','2021-07-03 21:05:29','612','2021-07-04 08:10:33',10,0),('1','64',208253,'AFTERNOON SHIFT ','2021-07-03','2021-07-03 00:00:00',NULL,'248',1380769.00,1380769.00,'248','2021-07-04 16:50:14','612','2021-07-04 17:51:10',10,0),('1','64',208381,'MORNING SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'248',707127.00,707127.00,'248','2021-07-05 08:33:59','612','2021-07-05 10:36:54',10,0),('1','64',208443,'AFTERNOON SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'248',1305039.00,1305039.00,'248','2021-07-05 15:03:50','612','2021-07-05 15:34:45',10,0),('1','64',208528,'MORNING SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'248',684920.00,684920.00,'248','2021-07-05 20:14:30','612','2021-07-05 21:20:44',10,0),('1','64',208601,'AFTERNOON SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'248',1485962.00,1485962.00,'248','2021-07-06 08:56:48','612','2021-07-06 10:27:29',10,0),('1','64',208701,'MORNING SHIFT ','2021-07-06','2021-07-06 00:00:00',NULL,'248',780864.00,780864.00,'248','2021-07-06 14:49:39','612','2021-07-06 16:34:41',10,0),('1','64',208855,'AFTERNOON SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'248',1370990.00,1370990.00,'248','2021-07-08 01:05:11','612','2021-07-08 07:29:21',10,0),('1','64',209182,'MORNING SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'248',984155.00,984155.00,'248','2021-07-08 18:23:13','612','2021-07-08 19:21:39',10,0),('1','64',209191,'AFTERNOON SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'248',1717250.00,1717250.00,'248','2021-07-08 19:57:31','612','2021-07-08 20:00:08',10,0),('1','64',209195,'MORNING SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'248',672172.00,672172.00,'248','2021-07-08 20:51:46','612','2021-07-08 20:53:53',10,0),('1','64',209198,'AFTERNOON SHIFT ','2021-07-08','2021-07-08 00:00:00',NULL,'248',1590560.00,1590560.00,'248','2021-07-09 23:10:15','612','2021-07-10 09:27:29',10,0),('1','64',209602,'MORNING SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'248',53200.00,53200.00,'248','2021-07-10 17:04:12','612','2021-07-10 17:11:45',10,0),('1','64',209605,'PRICE CHANGE SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'248',568217.00,568217.00,'248','2021-07-10 17:23:59','612','2021-07-10 19:12:19',10,0),('1','64',209627,'AFTERNOON SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'248',1229670.00,1229670.00,'248','2021-07-10 22:20:00','612','2021-07-11 08:05:57',10,0),('1','64',209797,'MORNING SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'248',946022.00,946022.00,'248','2021-07-12 12:12:14','612','2021-07-12 13:14:09',10,0),('1','64',209998,'AFTERNOON SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'248',1393235.00,1393235.00,'248','2021-07-12 13:29:30','612','2021-07-12 13:32:36',10,0),('1','64',210007,'MORNING SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'248',655896.00,655896.00,'248','2021-07-12 13:54:29','612','2021-07-12 14:04:03',10,0),('1','64',210013,'AFTERNOON SHIFT ','2021-07-11','2021-07-11 00:00:00',NULL,'248',1075642.00,1075642.00,'248','2021-07-12 14:15:14','612','2021-07-12 14:26:34',10,0),('1','64',210020,'MORNING SHIFT ','2021-07-12','2021-07-12 00:00:00',NULL,'248',244320.00,244320.00,'248','2021-07-12 14:36:59','612','2021-07-12 14:53:04',10,0),('1','64',210027,'AFTERNOON SHIFT ','2021-07-12','2021-07-12 00:00:00',NULL,'248',56345.00,56345.00,'248','2021-07-12 19:41:34','612','2021-07-13 07:46:31',10,0),('1','64',210149,'MORNING SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'248',113575.00,113575.00,'248','2021-07-13 14:17:31','612','2021-07-13 19:45:25',10,0),('1','64',210284,'AFTERNOON SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'248',73750.00,73750.00,'248','2021-07-13 19:55:47','612','2021-07-14 09:47:57',10,0),('1','64',210483,'MORNING SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'248',48675.00,48675.00,'248','2021-07-14 23:28:24','612','2021-07-15 06:51:16',10,0),('1','64',210621,'AFTERNOON SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'248',1362015.00,1362015.00,'248','2021-07-15 17:34:12','612','2021-07-15 19:57:43',10,0),('1','64',210706,'MORNING SHIFT ','2021-07-15','2021-07-15 00:00:00',NULL,'248',61655.00,61655.00,'248','2021-07-15 20:15:26','612','2021-07-16 09:32:17',10,0),('1','64',210928,'AFTERNOON SHIFT ','2021-07-15','2021-07-15 00:00:00',NULL,'248',202075.00,202075.00,'248','2021-07-16 20:21:13','612','2021-07-17 09:02:52',10,0),('1','64',211100,'MORNING SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'248',78470.00,78470.00,'248','2021-07-17 15:33:22','612','2021-07-17 15:41:48',10,0),('1','64',211104,'AFTERNOON SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'248',84665.00,84665.00,'248','2021-07-17 15:48:48','612','2021-07-17 19:21:11',10,0),('1','64',211913,'MORNING SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'248',666060.00,666060.00,'248','2021-07-21 21:11:59','612','2021-07-22 07:41:09',10,0),('1','64',212210,'AFTERNOON SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'248',1089895.00,1089895.00,'248','2021-07-22 21:59:12','612','2021-07-23 08:39:51',10,0),('1','64',212441,'MORNING SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'248',699487.00,699487.00,'248','2021-07-24 10:33:25','612','2021-07-24 10:35:03',10,0),('1','64',212560,'AFTERNOON SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'248',1119401.00,1119401.00,'248','2021-07-24 12:51:45','612','2021-07-24 12:59:07',10,0),('1','64',212566,'MORNING SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'248',607644.00,607644.00,'248','2021-07-24 13:03:10','612','2021-07-24 13:04:26',10,0),('1','64',212572,'AFTERNOON SHIFT ','2021-07-19','2021-07-19 00:00:00',NULL,'248',1303620.00,1303620.00,'248','2021-07-24 13:10:37','612','2021-07-24 13:13:43',10,0),('1','64',212573,'MORNING SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'248',560550.00,560550.00,'248','2021-07-24 13:27:48','612','2021-07-24 13:29:47',10,0),('1','64',212574,'AFTERNOON SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'248',1810558.00,1810558.00,'248','2021-07-24 13:35:46','612','2021-07-24 13:38:30',10,0),('1','64',212583,'MORNING SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'248',505562.00,505562.00,'248','2021-07-24 13:53:51','612','2021-07-24 13:55:07',10,0),('1','64',212585,'AFTERNOON SHIFT ','2021-07-21','2021-07-21 00:00:00',NULL,'248',986850.00,986850.00,'248','2021-07-24 13:58:18','612','2021-07-24 14:19:12',10,0),('1','64',212594,'MORNING SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'248',491582.00,491582.00,'248','2021-07-24 14:29:10','612','2021-07-24 14:33:41',10,0),('1','64',212596,'AFTERNOON SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'248',92800.00,92800.00,'248','2021-07-24 14:39:17','612','2021-07-24 14:42:17',10,0),('1','64',212597,'MORNING SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'248',128760.00,128760.00,'248','2021-07-24 14:50:44','612','2021-07-24 14:53:04',10,0),('1','64',212603,'AFTERNOON SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'248',937860.00,937860.00,'248','2021-07-24 20:39:50','612','2021-07-25 09:11:19',10,0),('1','64',212781,'MORNING SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'248',294930.00,294930.00,'248','2021-07-25 14:08:25','612','2021-07-25 14:53:30',10,0),('1','64',212851,'AFTERNOON SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'248',22040.00,22040.00,'248','2021-07-25 21:44:28','612','2021-07-25 23:50:20',10,0),('1','64',213022,'MORNING SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'248',71630.00,71630.00,'248','2021-07-26 14:19:02','612','2021-07-26 20:18:03',10,0),('1','64',213111,'AFTERNOON SHIFT ','2021-07-25','2021-07-25 00:00:00',NULL,'248',795160.00,795160.00,'248','2021-07-27 10:04:07','612','2021-07-27 10:07:43',10,0),('1','64',213223,'MORNING SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'248',697498.00,697498.00,'248','2021-07-27 10:26:16','612','2021-07-27 10:27:54',10,0),('1','64',213234,'AFTERNOON SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'248',1320237.00,1320237.00,'248','2021-07-27 10:44:42','612','2021-07-27 10:47:11',10,0),('1','64',213239,'MORNING SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'248',468065.00,468065.00,'248','2021-07-27 13:48:45','612','2021-07-27 15:28:23',10,0),('1','64',213439,'AFTERNOON SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'248',1009414.00,1009414.00,'248','2021-07-28 14:24:10','612','2021-07-28 18:46:00',10,0),('1','64',213701,'MORNING SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'248',872524.00,872524.00,'248','2021-07-29 10:05:36','612','2021-07-29 10:43:18',10,0),('1','64',213716,'AFTERNOON SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'248',1449834.00,1449834.00,'248','2021-07-29 10:56:32','612','2021-07-29 10:58:20',10,0),('1','64',213722,'MORNING SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'248',768509.00,768509.00,'248','2021-07-29 13:20:33','612','2021-07-29 15:44:46',10,0),('1','64',214028,'AFTERNOON SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'248',1344818.00,1344818.00,'248','2021-07-30 14:51:22','612','2021-07-30 18:42:50',10,0),('1','64',214082,'MORNING SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'248',700606.00,700606.00,'248','2021-07-30 23:47:14','612','2021-07-31 08:41:00',10,0),('1','64',214166,'AFTERNOON SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'248',2187571.00,2187571.00,'248','2021-07-31 11:14:51','612','2021-07-31 11:42:41',10,0),('1','64',214200,'MORNING SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'248',570148.00,570148.00,'248','2021-07-31 12:33:11','612','2021-07-31 15:24:00',10,0),('1','64',214409,'AFTERNOON SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'248',1675330.00,1675330.00,'248','2021-08-01 10:43:29','612','2021-08-01 11:13:00',10,0),('1','64',214471,'MORNING SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'248',556122.00,556122.00,'248','2021-08-01 15:08:05','612','2021-08-01 21:44:01',10,0),('1','64',214581,'AFTERNOON SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'248',1092032.00,1092032.00,'248','2021-08-02 08:30:24','612','2021-08-02 08:46:16',10,0),('1','64',214655,'MORNING SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'248',558438.00,558438.00,'248','2021-08-02 12:11:56','612','2021-08-02 13:37:01',10,0),('1','64',214748,'AFTERNOON SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'248',1289561.00,1289561.00,'248','2021-08-03 10:03:55','612','2021-08-03 13:22:48',10,0),('1','64',214923,'MORNING SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'248',562676.00,562676.00,'248','2021-08-03 13:58:53','612','2021-08-03 20:42:16',10,0),('1','64',214985,'AFTERNOON SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'248',1042351.00,1042351.00,'248','2021-08-05 10:25:23','612','2021-08-05 10:49:09',10,0),('1','64',215591,'MORNING SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'248',538552.00,538552.00,'248','2021-08-06 14:43:15','612','2021-08-06 16:40:41',10,0),('1','64',215617,'AFTERNOON SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'248',909798.00,909798.00,'248','2021-08-06 18:44:09','612','2021-08-06 18:46:36',10,0),('1','64',215638,'MORNING SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'248',631814.00,631814.00,'248','2021-08-06 18:49:11','612','2021-08-06 18:51:35',10,0),('1','64',215642,'AFTERNOON SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'248',1116550.00,1116550.00,'248','2021-08-06 19:46:26','612','2021-08-07 07:19:08',10,0),('1','64',215758,'MORNING SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'248',610530.00,610530.00,'248','2021-08-07 11:02:18','612','2021-08-07 18:04:42',10,0),('1','64',215876,'AFTERNOON SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'248',1316856.00,1316856.00,'248','2021-08-07 19:30:32','612','2021-08-10 07:42:51',10,0),('1','64',217101,'MORNING SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'248',780515.00,780515.00,'248','2021-08-13 10:26:14','648','2021-08-13 10:46:13',10,0),('1','64',217117,'AFTERNOON SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'248',1040940.00,1040940.00,'248','2021-08-13 10:53:36','648','2021-08-13 11:06:31',10,0),('1','64',217126,'MORNING SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'248',648438.00,648438.00,'248','2021-08-13 11:17:10','648','2021-08-13 11:18:35',10,0),('1','64',217133,'AFTERNOON SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'248',778923.00,778923.00,'248','2021-08-13 11:32:59','648','2021-08-13 11:34:51',10,0),('1','64',217138,'MORNING SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'248',509757.00,509757.00,'248','2021-08-13 11:39:17','648','2021-08-13 11:41:59',10,0),('1','64',217146,'AFTERNOON SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'248',1253354.00,1253354.00,'248','2021-08-13 11:57:38','648','2021-08-13 12:15:35',10,0),('1','64',217372,'MORNING SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'248',667214.00,667214.00,'248','2021-08-14 11:16:03','648','2021-08-14 11:37:35',10,0),('1','64',217384,'AFTERNOON SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'248',1388122.00,1388122.00,'248','2021-08-14 11:56:06','648','2021-08-14 12:04:46',10,0),('1','64',217401,'MORNING SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'248',552069.00,552069.00,'248','2021-08-14 13:57:54','648','2021-08-14 14:30:40',10,0),('1','64',217447,'AFTERNOON SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'248',1114585.00,1114585.00,'248','2021-08-14 16:01:39','648','2021-08-14 21:32:02',10,0),('1','64',217576,'MORNING SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'248',657948.00,657948.00,'248','2021-08-15 13:19:50','648','2021-08-15 13:41:24',10,0),('1','64',217592,'AFTERNOON SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'248',1465430.00,1465430.00,'248','2021-08-15 13:47:58','648','2021-08-15 13:51:11',10,0),('1','64',217600,'MORNING SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'248',816354.00,816354.00,'248','2021-08-15 16:03:00','648','2021-08-15 18:25:04',10,0),('1','64',217693,'AFTERNOON SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'248',1408104.00,1408104.00,'248','2021-08-15 22:50:49','648','2021-08-16 07:55:57',10,0),('1','64',217790,'MORNING SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'248',662502.00,662502.00,'248','2021-08-16 09:30:54','648','2021-08-16 10:04:06',10,0),('1','64',217812,'AFTERNOON SHIFT ','2021-08-14','2021-08-14 00:00:00',NULL,'248',3415696.00,3415696.00,'248','2021-08-16 12:26:07','648','2021-08-16 12:33:22',10,0),('1','64',217862,'MORNING SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'248',1333710.00,1333710.00,'248','2021-08-16 12:40:37','648','2021-08-16 12:43:11',10,0),('1','64',217869,'AFTERNOON SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'248',32190.00,32190.00,'248','2021-08-16 13:02:53','648','2021-08-16 13:05:29',10,0),('1','64',217880,'MORNING SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'248',298410.00,298410.00,'248','2021-08-16 13:25:30','648','2021-08-16 13:48:28',10,0),('1','64',217964,'AFTERNOON SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'248',8700.00,8700.00,'248','2021-08-17 11:48:43','648','2021-08-17 14:09:23',10,0),('1','64',218151,'MORNING SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'248',337442.00,337442.00,'248','2021-08-19 13:09:14','648','2021-08-19 15:06:38',10,0),('1','64',218609,'AFTERNOON SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'248',1139196.00,1139196.00,'248','2021-08-19 15:48:59','648','2021-08-19 16:19:14',10,0),('1','64',218625,'MORNING SHIFT ','2021-08-18','2021-08-18 00:00:00',NULL,'248',752523.00,752523.00,'248','2021-08-19 17:00:59','648','2021-08-19 17:07:28',10,0),('1','64',218645,'AFTERNOON SHIFT ','2021-08-18','2021-08-18 00:00:00',NULL,'248',616941.00,616941.00,'248','2021-08-19 19:26:11','648','2021-08-19 19:54:41',10,0),('1','64',218660,'MORNING SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'248',533364.00,533364.00,'248','2021-08-19 21:38:30','648','2021-08-20 08:33:37',10,0),('1','64',218874,'MORNING SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'248',932283.00,932283.00,'248','2021-08-20 19:12:40','648','2021-08-20 21:20:41',10,0),('1','64',219273,'MORNING SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'248',498198.00,498198.00,'248','2021-08-22 15:48:44','648','2021-08-22 16:06:38',10,0),('1','64',219282,'AFTERNOON SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'248',1000428.00,1000428.00,'248','2021-08-22 16:17:24','648','2021-08-22 18:25:17',10,0),('1','64',219300,'MORNING SHIFT ','2021-08-21','2021-08-21 00:00:00',NULL,'248',644052.00,644052.00,'248','2021-08-22 18:47:34','648','2021-08-22 20:58:18',10,0),('1','64',219316,'AFTERNOON SHIFT ','2021-08-21','2021-08-21 00:00:00',NULL,'248',1183473.00,1183473.00,'248','2021-08-22 22:53:12','648','2021-08-23 06:55:15',10,0),('1','64',219452,'MORNING SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'248',668154.00,668154.00,'248','2021-08-23 11:00:42','648','2021-08-23 13:52:12',10,0),('1','64',219540,'AFTERNOON SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'248',744963.00,744963.00,'248','2021-08-23 16:40:14','648','2021-08-23 21:35:10',10,0),('1','64',219574,'MORNING SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'248',546684.00,546684.00,'248','2021-08-24 12:51:02','648','2021-08-24 14:54:09',10,0),('1','64',219767,'AFTERNOON SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'248',1327470.00,1327470.00,'248','2021-08-24 16:53:03','648','2021-08-24 21:43:54',10,0),('1','64',219850,'MORNING SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'248',2512842.00,2512842.00,'248','2021-08-25 10:50:38','648','2021-08-25 11:04:11',10,0),('1','64',219929,'AFTERNOON SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'248',823122.00,823122.00,'248','2021-08-25 12:22:27','648','2021-08-25 12:55:11',10,0),('1','64',219990,'MORNING SHIFT ','2021-08-25','2021-08-25 00:00:00',NULL,'248',1626318.00,1626318.00,'248','2021-08-25 20:29:24','648','2021-08-26 06:10:42',10,0),('1','64',220100,'AFTERNOON SHIFT ','2021-08-25','2021-08-25 00:00:00',NULL,'248',1765860.00,1765860.00,'248','2021-08-26 09:11:10','648','2021-08-26 13:40:58',10,0),('1','64',220220,'MORNING SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'248',1682082.00,1682082.00,'248','2021-08-26 20:26:42','648','2021-08-27 06:59:52',10,0),('1','64',220339,'AFTERNOON SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'248',1006866.00,1006866.00,'248','2021-08-27 19:02:57','648','2021-08-28 07:50:17',10,0),('1','64',220546,'MORNING SHIFT ','2021-08-27','2021-08-27 00:00:00',NULL,'248',528120.00,528120.00,'248','2021-08-28 13:36:05','648','2021-08-28 17:09:30',10,0),('1','64',220656,'AFTERNOON SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'248',972543.00,972543.00,'248','2021-08-28 19:18:20','648','2021-08-29 07:23:02',10,0),('1','64',220770,'MORNING SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'248',1180185.00,1180185.00,'248','2021-08-29 11:57:17','648','2021-08-29 13:28:29',10,0),('1','64',220827,'AFTERNOON SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'248',996795.00,996795.00,'248','2021-08-29 15:07:22','648','2021-08-30 10:12:28',10,0),('1','64',221049,'MORNING SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'248',995277.00,995277.00,'248','2021-08-30 13:05:18','648','2021-08-30 14:08:32',10,0),('1','64',221122,'AFTERNOON SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'248',989751.00,989751.00,'248','2021-08-31 12:02:06','648','2021-08-31 14:01:03',10,0),('1','64',221335,'MORNING SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'248',555102.00,555102.00,'248','2021-08-31 22:36:10','648','2021-09-01 07:30:35',10,0),('1','64',221428,'AFTERNOON SHIFT ','2021-08-30','2021-08-30 00:00:00',NULL,'248',1205352.00,1205352.00,'248','2021-09-01 07:57:29','648','2021-09-01 09:04:40',10,0),('1','64',221497,'MORNING SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'248',719430.00,719430.00,'248','2021-09-01 14:12:24','648','2021-09-01 18:09:49',10,0),('1','64',221576,'AFTERNOON SHIFT ','2021-08-31','2021-08-31 00:00:00',NULL,'248',1072383.00,1072383.00,'248','2021-09-01 18:16:53','648','2021-09-01 18:18:44',10,0),('1','64',221584,'MORNING SHIFT ','2021-09-01','2021-09-01 00:00:00',NULL,'248',1539696.00,1539696.00,'248','2021-09-01 19:07:40','648','2021-09-02 11:09:08',10,0),('1','64',221712,'AFTERNOON SHIFT ','2021-09-01','2021-09-01 00:00:00',NULL,'248',859137.00,859137.00,'248','2021-09-02 11:40:38','648','2021-09-02 14:24:24',10,0),('1','64',221798,'MORNING SHIFT ','2021-09-02','2021-09-02 00:00:00',NULL,'248',557553.00,557553.00,'248','2021-09-02 19:11:53','648','2021-09-03 07:08:07',10,0),('1','64',221887,'AFTERNOON SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'248',1068876.00,1068876.00,'248','2021-09-03 14:58:12','648','2021-09-03 16:37:41',10,0),('1','64',222034,'MORNING SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'248',591522.00,591522.00,'248','2021-09-03 19:52:12','648','2021-09-04 06:55:56',10,0),('1','64',222146,'AFTERNOON SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'248',993663.00,993663.00,'248','2021-09-04 11:35:06','648','2021-09-04 13:23:50',10,0),('1','64',222209,'MORNING SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'248',708135.00,708135.00,'248','2021-09-05 16:41:58','648','2021-09-06 07:34:26',10,0),('1','64',222579,'AFTERNOON SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'248',1310733.00,1310733.00,'248','2021-09-06 11:22:36','648','2021-09-06 17:33:14',10,0),('1','64',222913,'MORNING SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'248',648378.00,648378.00,'248','2021-09-07 18:12:52','648','2021-09-07 21:31:29',10,0),('1','64',222929,'AFTERNOON SHIFT ','2021-09-05','2021-09-05 00:00:00',NULL,'248',981744.00,981744.00,'248','2021-09-07 23:25:46','648','2021-09-08 14:16:47',10,0),('1','64',223108,'MORNING SHIFT ','2021-09-06','2021-09-06 00:00:00',NULL,'248',692850.00,692850.00,'248','2021-09-08 15:18:40','648','2021-09-08 17:40:26',10,0),('1','64',223142,'AFTERNOON SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'248',1284348.00,1284348.00,'248','2021-09-08 19:46:27','648','2021-09-09 05:29:42',10,0),('1','64',223282,'MORNING SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'248',635286.00,635286.00,'248','2021-09-09 13:12:00','648','2021-09-09 16:00:22',10,0),('1','64',223368,'AFTERNOON SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'248',1150944.00,1150944.00,'248','2021-09-09 16:52:12','648','2021-09-09 21:47:02',10,0),('1','64',223518,'MORNING SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'248',666939.00,666939.00,'248','2021-09-11 12:05:57','648','2021-09-11 19:26:17',10,0),('1','64',223851,'AFTERNOON SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'248',964074.00,964074.00,'248','2021-09-11 20:40:18','648','2021-09-12 09:54:11',10,0),('1','64',223977,'MORNING SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'248',683154.00,683154.00,'248','2021-09-12 17:39:24','648','2021-09-13 09:09:46',10,0),('1','64',224233,'AFTERNOON SHIFT ','2021-09-09','2021-09-09 00:00:00',NULL,'248',1129905.00,1129905.00,'248','2021-09-13 13:49:37','648','2021-09-13 14:18:36',10,0),('1','64',224250,'MORNING SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'248',1633590.00,1633590.00,'248','2021-09-13 15:01:37','648','2021-09-13 16:53:08',10,0),('1','64',224270,'AFTERNOON SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'248',992922.00,992922.00,'248','2021-09-13 17:37:53','648','2021-09-13 19:55:56',10,0),('1','64',224291,'MORNING SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'248',694089.00,694089.00,'248','2021-09-13 23:35:24','648','2021-09-14 08:37:02',10,0),('1','64',224384,'AFTERNOON SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'248',1176936.00,1176936.00,'248','2021-09-14 09:51:47','648','2021-09-14 14:16:46',10,0),('1','64',224462,'MORNING SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'248',197211.00,197211.00,'248','2021-09-14 14:33:26','648','2021-09-14 15:44:41',10,0),('1','64',224484,'MORNING SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'248',45030.00,45030.00,'248','2021-09-14 16:59:34','648','2021-09-14 18:22:52',10,0),('1','64',224497,'MORNING SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'248',111150.00,111150.00,'248','2021-09-14 19:29:29','648','2021-09-15 07:48:59',10,0),('1','64',224634,'AFTERNOON SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'248',160740.00,160740.00,'248','2021-09-15 10:53:20','648','2021-09-15 13:43:13',10,0),('1','64',224720,'MORNING SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'248',94050.00,94050.00,'248','2021-09-15 16:34:19','648','2021-09-15 19:25:23',10,0),('1','64',224761,'AFTERNOON SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'248',504246.00,504246.00,'248','2021-09-15 22:13:13','648','2021-09-16 10:58:41',10,0),('1','64',224918,'MORNING SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'248',1123974.00,1123974.00,'248','2021-09-16 14:49:19','648','2021-09-16 17:18:55',10,0),('1','64',224974,'AFTERNOON SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'248',856353.00,856353.00,'248','2021-09-16 17:22:20','648','2021-09-16 17:24:12',10,0),('1','64',224981,'MORNING SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'248',598260.00,598260.00,'248','2021-09-16 19:31:10','648','2021-09-17 07:31:41',10,0),('1','64',225127,'AFTERNOON SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'248',950559.00,950559.00,'248','2021-09-17 15:32:38','648','2021-09-17 15:36:44',10,0),('1','64',225203,'MORNING SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'248',987357.00,987357.00,'248','2021-09-17 16:18:29','648','2021-09-18 07:57:05',10,0),('1','64',225310,'AFTERNOON SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'248',92055.00,92055.00,'248','2021-09-18 08:29:03','648','2021-09-18 09:49:22',10,0),('1','64',225335,'PRICE CHANGE SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'248',957147.00,957147.00,'248','2021-09-18 09:55:50','648','2021-09-18 14:12:06',10,0),('1','64',225443,'MORNING SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'248',732662.00,732662.00,'248','2021-09-18 20:21:35','648','2021-09-19 11:08:36',10,0),('1','64',225626,'AFTERNOON SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'248',935858.00,935858.00,'248','2021-09-19 21:03:07','648','2021-09-19 22:17:43',10,0),('1','64',225767,'MORNING SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'248',558336.00,558336.00,'248','2021-09-20 09:03:08','648','2021-09-20 14:48:35',10,0),('1','64',225944,'AFTERNOON SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'248',24650.00,24650.00,'248','2021-09-20 19:25:32','648','2021-09-21 05:43:59',10,0),('1','64',226002,'MORNING SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'248',80620.00,80620.00,'248','2021-09-21 07:45:42','648','2021-09-21 09:04:21',10,0),('1','64',226034,'AFTERNOON SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'248',73660.00,73660.00,'248','2021-09-21 09:10:20','648','2021-09-21 09:41:00',10,0),('1','64',226063,'MORNING SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'248',90480.00,90480.00,'248','2021-09-21 15:55:31','648','2021-09-21 18:54:07',10,0),('1','64',226209,'PRICE CHANGE SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'248',11988.00,11988.00,'248','2021-09-21 19:06:18','648','2021-09-22 22:38:12',10,0),('1','64',226460,'AFTERNOON SHIFT ','2021-09-21','2021-09-21 00:00:00',NULL,'248',1143390.00,1143390.00,'248','2021-09-22 23:04:35','648','2021-09-23 13:09:58',10,0),('1','64',226716,'MORNING SHIFT ','2021-09-22','2021-09-22 00:00:00',NULL,'248',661224.00,661224.00,'248','2021-09-24 01:27:22','648','2021-09-24 03:59:12',10,0),('1','64',227085,'AFTERNOON SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'248',1121684.00,1121684.00,'248','2021-09-26 23:58:53','648','2021-09-27 07:46:47',10,0),('1','64',227506,'MORNING SHIFT ','2021-09-23','2021-09-23 00:00:00',NULL,'248',705040.00,705040.00,'248','2021-09-27 12:47:30','648','2021-09-27 12:55:00',10,0),('1','64',227511,'AFTERNOON SHIFT ','2021-09-23','2021-09-23 00:00:00',NULL,'248',1111930.00,1111930.00,'248','2021-09-27 13:02:35','648','2021-09-27 13:03:24',10,0),('1','64',227516,'MORNING SHIFT ','2021-09-24','2021-09-24 00:00:00',NULL,'248',687117.00,687117.00,'248','2021-09-27 13:13:58','648','2021-09-27 13:22:43',10,0),('1','64',227523,'AFTERNOON SHIFT ','2021-09-24','2021-09-24 00:00:00',NULL,'248',1348491.00,1348491.00,'248','2021-09-27 13:37:05','648','2021-09-27 13:43:30',10,0),('1','64',227537,'MORNING SHIFT ','2021-09-25','2021-09-25 00:00:00',NULL,'248',614302.00,614302.00,'248','2021-09-27 13:54:33','648','2021-09-27 13:58:09',10,0),('1','64',227552,'AFTERNOON SHIFT ','2021-09-25','2021-09-25 00:00:00',NULL,'248',1092058.00,1092058.00,'248','2021-09-27 14:34:28','648','2021-09-27 14:40:13',10,0),('1','64',227556,'MORNING SHIFT ','2021-09-26','2021-09-26 00:00:00',NULL,'248',634748.00,634748.00,'248','2021-09-27 14:47:19','648','2021-09-27 14:49:31',10,0),('1','64',227560,'AFTERNOON SHIFT ','2021-09-26','2021-09-26 00:00:00',NULL,'248',1021427.00,1021427.00,'248','2021-09-27 14:58:07','648','2021-09-27 15:10:04',10,0),('1','64',227571,'MORNING SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'248',744419.00,744419.00,'248','2021-09-27 17:37:54','648','2021-09-28 07:50:13',10,0),('1','64',227652,'AFTERNOON SHIFT ','2021-09-27','2021-09-27 00:00:00',NULL,'248',1258216.00,1258216.00,'248','2021-09-28 08:57:01','648','2021-09-28 14:31:38',10,0),('1','64',227814,'MORNING SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'248',578738.00,578738.00,'248','2021-09-28 18:51:56','648','2021-09-29 07:59:47',10,0),('1','64',227900,'AFTERNOON SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'248',26845.00,26845.00,'248','2021-09-29 08:34:56','648','2021-09-29 09:25:46',10,0),('1','64',227954,'PRICE CHANGE SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'248',1038054.00,1038054.00,'248','2021-09-29 12:21:44','648','2021-09-29 14:08:15',10,0),('1','64',228085,'MORNING SHIFT ','2021-09-29','2021-09-29 00:00:00',NULL,'248',634638.00,634638.00,'248','2021-09-29 18:45:10','648','2021-09-30 05:49:28',10,0),('1','64',228285,'AFTERNOON SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'248',1160118.00,1160118.00,'248','2021-09-30 16:36:22','648','2021-09-30 16:46:35',10,0),('1','64',228314,'MORNING SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'248',649591.44,649591.44,'248','2021-09-30 18:54:28','648','2021-10-01 10:21:54',10,0),('1','64',228431,'AFTERNOON SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'248',1118874.00,1118874.00,'248','2021-10-01 11:44:29','648','2021-10-02 07:26:13',10,0),('1','64',228574,'MORNING SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'248',706764.00,706764.00,'248','2021-10-02 09:10:59','648','2021-10-02 15:18:34',10,0),('1','64',228745,'AFTERNOON SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'248',1149774.00,1149774.00,'248','2021-10-03 05:50:33','648','2021-10-03 13:19:46',10,0),('1','64',228895,'MORNING SHIFT ','2021-10-02','2021-10-02 00:00:00',NULL,'248',656268.00,656268.00,'248','2021-10-03 16:31:01','648','2021-10-03 16:53:35',10,0),('1','64',228920,'AFTERNOON SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'248',1236174.00,1236174.00,'248','2021-10-03 21:16:34','648','2021-10-04 09:47:19',10,0),('1','64',229101,'MORNING SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'248',768840.00,768840.00,'248','2021-10-04 15:42:47','648','2021-10-04 16:49:42',10,0),('1','64',229125,'AFTERNOON SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'248',78174.00,78174.00,'248','2021-10-04 20:20:41','648','2021-10-04 22:01:23',10,0),('1','64',229185,'MORNING SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'248',55200.00,55200.00,'248','2021-10-05 06:57:20','648','2021-10-05 10:06:25',10,0),('1','64',229252,'AFTERNOON SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'248',60000.00,60000.00,'248','2021-10-05 10:57:36','648','2021-10-05 12:59:44',10,0),('1','64',229287,'MORNING SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'248',624552.00,624552.00,'248','2021-10-05 19:35:42','648','2021-10-05 20:28:02',10,0),('1','64',229421,'AFTERNOON SHIFT ','2021-10-05','2021-10-05 00:00:00',NULL,'248',57300.00,57300.00,'248','2021-10-06 06:50:57','648','2021-10-06 08:16:53',10,0),('1','64',229581,'PRICE CHANGE SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'248',1054553.00,1054553.00,'248','2021-10-06 18:52:48','648','2021-10-07 10:31:36',10,0),('1','64',229859,'MORNING SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'248',669954.00,669954.00,'248','2021-10-07 20:02:10','648','2021-10-08 05:31:39',10,0),('1','64',229886,'AFTERNOON SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'248',1098533.00,1098533.00,'248','2021-10-08 06:02:29','648','2021-10-08 07:58:38',10,0),('1','64',229957,'MORNING SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'248',2136725.00,2136725.00,'248','2021-10-08 11:16:53','648','2021-10-08 12:51:23',10,0),('1','64',230072,'AFTERNOON SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'248',1085342.00,1085342.00,'248','2021-10-08 22:45:10','648','2021-10-09 08:10:12',10,0),('1','64',230118,'MORNING SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'248',1608781.00,1608781.00,'248','2021-10-09 13:01:40','648','2021-10-09 20:22:23',10,0),('1','64',230343,'AFTERNOON SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'248',969458.00,969458.00,'248','2021-10-10 09:18:48','648','2021-10-10 12:56:06',10,0),('1','64',230464,'MORNING SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'248',589032.00,589032.00,'248','2021-10-10 15:52:37','648','2021-10-10 20:08:07',10,0),('1','64',230560,'AFTERNOON SHIFT ','2021-10-09','2021-10-09 00:00:00',NULL,'248',9150.00,9150.00,'248','2021-10-11 08:09:26','648','2021-10-11 09:56:43',10,0),('1','64',230673,'PRICE CHANGE SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'248',1022998.00,1022998.00,'248','2021-10-11 14:10:21','648','2021-10-11 16:11:12',10,0),('1','64',230731,'MORNING SHIFT ','2021-10-10','2021-10-10 00:00:00',NULL,'248',606220.00,606220.00,'248','2021-10-11 17:18:29','648','2021-10-12 10:35:56',10,0),('1','64',230873,'AFTERNOON SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'248',949458.00,949458.00,'248','2021-10-12 10:52:46','648','2021-10-12 14:01:53',10,0),('1','64',230966,'MORNING SHIFT ','2021-10-11','2021-10-11 00:00:00',NULL,'248',677506.00,677506.00,'248','2021-10-12 14:31:49','648','2021-10-12 22:06:58',10,0),('1','64',231120,'AFTERNOON SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'248',1242372.00,1242372.00,'248','2021-10-13 08:49:27','648','2021-10-13 10:21:04',10,0),('1','64',231169,'MORNING SHIFT ','2021-10-12','2021-10-12 00:00:00',NULL,'248',594342.00,594342.00,'248','2021-10-13 11:14:04','648','2021-10-13 13:27:28',10,0),('1','64',231333,'AFTERNOON SHIFT ','2021-10-12','2021-10-12 00:00:00',NULL,'248',910086.00,910086.00,'248','2021-10-13 18:11:43','648','2021-10-14 06:56:52',10,0),('1','64',231429,'MORNING SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'248',685246.00,685246.00,'248','2021-10-14 08:55:24','648','2021-10-14 14:23:58',10,0),('1','64',231550,'AFTERNOON SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'248',1107118.00,1107118.00,'248','2021-10-14 14:28:37','648','2021-10-14 14:57:45',10,0),('1','64',231581,'MORNING SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'248',678644.00,678644.00,'248','2021-10-14 16:24:32','648','2021-10-15 05:49:27',10,0),('1','64',231725,'AFTERNOON SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'248',1119574.00,1119574.00,'248','2021-10-15 10:15:09','648','2021-10-15 14:51:20',10,0),('1','64',231871,'MORNING SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'248',1043010.00,1043010.00,'248','2021-10-15 22:49:32','648','2021-10-16 07:57:56',10,0),('1','64',232027,'AFTERNOON SHIFT ','2021-10-15','2021-10-15 00:00:00',NULL,'248',1976772.00,1976772.00,'248','2021-10-16 15:13:58','648','2021-10-16 17:07:12',10,0),('1','64',232066,'MORNING SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'248',773874.00,773874.00,'248','2021-10-16 19:48:43','648','2021-10-17 07:06:19',10,0),('1','64',232217,'AFTERNOON SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'248',1082532.00,1082532.00,'248','2021-10-17 13:26:45','648','2021-10-17 16:13:42',10,0),('1','64',232649,'MORNING SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'248',1164546.00,1164546.00,'248','2021-10-19 09:02:21','648','2021-10-19 13:13:51',10,0),('1','64',232822,'AFTERNOON SHIFT ','2021-10-17','2021-10-17 00:00:00',NULL,'248',935310.00,935310.00,'248','2021-10-19 22:48:28','648','2021-10-20 06:59:23',10,0),('1','64',232871,'MORNING SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'248',683840.00,683840.00,'248','2021-10-20 07:15:47','648','2021-10-20 10:17:56',10,0),('1','64',233068,'AFTERNOON SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'248',176256.00,176256.00,'248','2021-10-20 18:54:45','648','2021-10-21 07:52:17',10,0),('1','64',233153,'PRICE CHANGE SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'248',1167856.00,1167856.00,'248','2021-10-21 08:16:24','648','2021-10-21 09:50:49',10,0),('1','64',233203,'MORNING SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'248',586905.00,586905.00,'248','2021-10-21 10:15:00','648','2021-10-21 22:02:30',10,0),('1','64',233353,'AFTERNOON SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'248',1435650.00,1435650.00,'248','2021-10-22 00:44:25','648','2021-10-22 08:27:34',10,0),('1','64',233564,'MORNING SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'248',2337978.00,2337978.00,'248','2021-10-22 19:21:56','648','2021-10-23 07:27:33',10,0),('1','64',233702,'AFTERNOON SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'248',1072019.00,1072019.00,'248','2021-10-23 11:10:23','648','2021-10-23 11:24:42',10,0),('1','64',233708,'MORNING SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'248',667246.00,667246.00,'248','2021-10-23 11:32:31','648','2021-10-23 13:13:02',10,0),('1','64',233742,'AFTERNOON SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'248',33835.00,33835.00,'248','2021-10-23 13:33:45','648','2021-10-23 15:40:19',10,0),('1','64',233785,'PRICE CHANGE SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'248',1397949.00,1396203.00,'248','2021-10-23 17:06:29','648','2021-10-24 08:43:09',10,0),('1','64',233915,'MORNING SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'248',683428.00,681718.00,'248','2021-10-24 11:07:35','648','2021-10-24 14:08:46',10,0),('1','64',233968,'AFTERNOON SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'248',1570783.00,1557535.00,'248','2021-10-24 14:42:23','648','2021-10-25 07:52:20',10,0),('1','64',234109,'MORNING SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'248',969868.00,960166.00,'248','2021-10-25 08:14:45','648','2021-10-25 13:02:02',10,0),('1','64',234198,'AFTERNOON SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'248',1904287.00,1879492.00,'248','2021-10-25 13:19:04','648','2021-10-25 16:54:56',10,0),('1','64',234251,'MORNING SHIFT ','2021-10-24','2021-10-24 00:00:00',NULL,'248',540772.00,540286.00,'248','2021-10-25 17:04:26','648','2021-10-25 17:09:19',10,0),('1','64',234255,'AFTERNOON SHIFT ','2021-10-24','2021-10-24 00:00:00',NULL,'248',937902.00,937902.00,'248','2021-10-25 17:17:54','648','2021-10-25 21:49:47',10,0),('1','64',234340,'MORNING SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'248',767767.00,766732.00,'248','2021-10-26 07:28:44','648','2021-10-26 09:10:15',10,0),('1','64',234414,'AFTERNOON SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'248',918675.00,916695.00,'248','2021-10-26 10:48:54','648','2021-10-26 13:54:44',10,0),('1','64',234488,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'248',616393.82,615601.82,'248','2021-10-26 15:36:05','648','2021-10-26 22:47:40',10,0),('1','64',234667,'AFTERNOON SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'248',1364186.00,1360280.00,'248','2021-10-27 10:46:02','648','2021-10-28 08:11:44',10,0),('1','64',234881,'MORNING SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'248',1327031.00,1309472.00,'248','2021-10-28 08:25:48','648','2021-10-28 08:55:39',10,0),('1','64',234898,'AFTERNOON SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'248',1390019.00,1386401.00,'248','2021-10-28 09:46:49','648','2021-10-28 09:52:32',10,0),('1','64',234929,'MORNING SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'248',1065488.00,1051664.00,'248','2021-10-28 12:47:26','648','2021-10-28 14:27:15',10,0),('1','64',235007,'AFTERNOON SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'248',1270948.00,1264045.00,'248','2021-10-29 09:22:04','648','2021-10-29 13:45:17',10,0),('1','64',235220,'MORNING SHIFT ','2021-10-29','2021-10-29 00:00:00',NULL,'248',1311432.00,1294683.00,'248','2021-10-29 14:46:05','648','2021-10-29 15:44:01',10,0),('1','64',235258,'AFTERNOON SHIFT ','2021-10-29','2021-10-29 00:00:00',NULL,'248',1626314.00,1609961.00,'248','2021-10-30 09:19:49','648','2021-10-30 09:34:29',10,0),('1','64',235408,'MORNING SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'248',725850.00,725463.00,'248','2021-10-30 20:30:19','648','2021-10-30 20:54:42',10,0),('1','64',235625,'AFTERNOON SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'248',1157969.00,1156304.00,'248','2021-10-31 15:48:06','648','2021-10-31 19:03:39',10,0),('1','64',235702,'MORNING SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'248',635537.00,635537.00,'248','2021-10-31 19:08:01','648','2021-10-31 19:26:51',10,0),('1','64',235836,'AFTERNOON SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'248',955017.00,955017.00,'248','2021-11-01 08:52:02','648','2021-11-01 10:00:02',10,0),('1','64',235887,'MORNING SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'248',676450.00,676450.00,'248','2021-11-01 14:52:38','648','2021-11-01 14:58:07',10,0),('1','64',235960,'AFTERNOON SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'248',801797.00,801797.00,'248','2021-11-02 08:04:22','648','2021-11-02 08:32:30',10,0),('1','64',236129,'AFTERNOON SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'248',631085.00,630635.00,'248','2021-11-02 15:29:55','648','2021-11-03 08:59:44',10,0),('1','64',236374,'AFTERNOON SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'248',1185855.00,1185855.00,'248','2021-11-03 11:57:52','648','2021-11-03 14:21:52',10,0),('1','64',236533,'MORNING SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'248',593986.00,593680.00,'248','2021-11-04 10:36:37','648','2021-11-04 11:01:55',10,0),('1','64',236644,'AFTERNOON SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'248',1070355.00,1070355.00,'248','2021-11-04 20:41:37','648','2021-11-05 08:33:18',10,0),('1','64',236823,'MORNING SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'248',604395.00,604395.00,'248','2021-11-05 10:16:39','648','2021-11-05 11:09:48',10,0),('1','64',236883,'AFTERNOON SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'248',1009165.00,1009165.00,'248','2021-11-05 16:05:25','648','2021-11-05 16:08:39',10,0),('1','64',236885,'MORNING SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'248',592665.00,592665.00,'248','2021-11-05 16:14:40','648','2021-11-05 16:26:08',10,0),('1','64',236893,'AFTERNOON SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'248',1306925.00,1306925.00,'248','2021-11-06 00:32:23','648','2021-11-06 08:08:24',10,0),('1','64',237008,'MORNING SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'248',905415.00,905415.00,'248','2021-11-06 12:35:12','648','2021-11-06 13:15:05',10,0),('1','64',237117,'AFTERNOON SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'248',3700680.00,3700680.00,'248','2021-11-07 07:11:43','648','2021-11-07 07:20:23',10,0),('1','64',237232,'MORNING SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'248',797595.00,797595.00,'248','2021-11-07 14:01:11','648','2021-11-07 14:31:52',10,0),('1','64',237356,'AFTERNOON SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'248',981145.00,981145.00,'248','2021-11-08 07:01:00','648','2021-11-08 07:45:37',10,0),('1','64',237432,'MORNING SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'248',650885.00,650885.00,'248','2021-11-08 12:46:50','648','2021-11-08 14:54:28',10,0),('1','64',237569,'AFTERNOON SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'248',1659360.00,1659360.00,'248','2021-11-08 20:51:24','648','2021-11-09 06:25:22',10,0),('1','64',237631,'MORNING SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'248',1067910.00,1067910.00,'248','2021-11-09 12:37:54','648','2021-11-09 13:05:54',10,0),('1','64',237820,'AFTERNOON SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'248',1072225.00,1072225.00,'248','2021-11-10 07:00:01','648','2021-11-10 07:35:23',10,0),('1','64',237939,'MORNING SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'248',678270.00,678270.00,'248','2021-11-10 14:18:33','648','2021-11-10 18:58:14',10,0),('1','64',238082,'AFTERNOON SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'248',891445.00,891445.00,'248','2021-11-11 07:01:02','648','2021-11-11 08:19:08',10,0),('1','64',238216,'MORNING SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'248',613475.00,613475.00,'248','2021-11-11 14:22:03','648','2021-11-12 07:31:23',10,0),('1','64',238399,'AFTERNOON SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'248',1488710.00,1488710.00,'248','2021-11-12 07:37:48','648','2021-11-12 07:50:28',10,0),('1','64',238462,'MORNING SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'248',895445.00,895445.00,'248','2021-11-12 14:24:26','648','2021-11-12 14:42:19',10,0),('1','64',238537,'AFTERNOON SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'248',1216810.00,1216810.00,'248','2021-11-13 05:59:36','648','2021-11-13 06:33:16',10,0),('1','64',238667,'MORNING SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'248',929350.00,929350.00,'248','2021-11-13 13:15:43','648','2021-11-13 13:53:35',10,0),('1','64',238778,'AFTERNOON SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'248',1261285.00,1261285.00,'248','2021-11-14 07:30:03','648','2021-11-14 08:36:43',10,0),('1','64',238930,'MORNING SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'248',867930.00,867930.00,'248','2021-11-14 13:02:44','648','2021-11-14 13:56:02',10,0),('1','64',239004,'AFTERNOON SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'248',1103465.00,1103465.00,'248','2021-11-14 20:24:38','648','2021-11-15 06:47:33',10,0),('1','64',239118,'MORNING SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'248',755830.00,755830.00,'248','2021-11-15 14:11:13','648','2021-11-15 14:23:13',10,0),('1','64',239260,'AFTERNOON SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'248',1848705.00,1848705.00,'248','2021-11-16 07:23:45','648','2021-11-16 07:27:17',10,0),('1','64',239336,'MORNING SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'248',547970.00,547970.00,'248','2021-11-16 13:48:26','648','2021-11-16 14:24:15',10,0),('1','64',239457,'AFTERNOON SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'248',663535.00,663535.00,'248','2021-11-16 19:53:01','648','2021-11-17 05:20:54',10,0),('1','64',239569,'MORNING SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'248',767590.00,767590.00,'248','2021-11-17 13:07:18','648','2021-11-17 13:40:49',10,0),('1','64',239682,'AFTERNOON SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'248',1360940.00,1360940.00,'248','2021-11-17 20:52:51','648','2021-11-17 21:10:49',10,0),('1','64',239831,'MORNING SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'248',764715.00,764715.00,'248','2021-11-18 12:47:50','648','2021-11-18 14:11:42',10,0),('1','64',239908,'AFTERNOON SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'248',1361295.00,1361295.00,'248','2021-11-18 20:47:51','648','2021-11-19 06:20:11',10,0),('1','64',240031,'MORNING SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'248',1029315.00,1029315.00,'248','2021-11-19 13:44:18','648','2021-11-19 14:14:06',10,0),('1','64',240155,'AFTERNOON SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'248',1417385.00,1417385.00,'248','2021-11-20 07:34:05','648','2021-11-20 10:51:37',10,0),('1','64',240288,'MORNING SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'248',709065.00,709065.00,'248','2021-11-20 12:24:19','648','2021-11-20 13:17:57',10,0),('1','64',240370,'AFTERNOON SHIFTING','2021-11-20','2021-11-20 00:00:00',NULL,'248',1535705.00,1535705.00,'248','2021-11-20 22:58:16','648','2021-11-21 06:15:41',10,0),('1','64',240501,'MORNING SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'248',727570.00,727570.00,'248','2021-11-21 12:44:35','648','2021-11-21 13:04:25',10,0),('1','64',240631,'AFTERNOON SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'248',1142425.00,1142425.00,'248','2021-11-21 21:32:03','648','2021-11-22 07:28:07',10,0),('1','64',240742,'MORNING SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'248',852425.00,852425.00,'248','2021-11-22 13:50:16','648','2021-11-22 13:53:38',10,0),('1','64',240931,'AFTERNOON SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'248',1578550.00,1578550.00,'248','2021-11-22 20:33:43','648','2021-11-22 20:44:57',10,0),('1','64',241003,'MORNING SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'248',1006219.70,1006219.70,'248','2021-11-23 14:20:00','648','2021-11-23 14:24:24',10,0),('1','64',241184,'AFTERNOON SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'248',1430190.00,1430190.00,'248','2021-11-23 20:33:31','648','2021-11-23 20:55:05',10,0),('1','64',241288,'MORNING SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'248',1026610.00,1026610.00,'248','2021-11-24 13:32:04','648','2021-11-24 14:17:52',10,0),('1','64',241443,'AFTERNOON SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'248',1350355.00,1350355.00,'248','2021-11-24 20:36:50','648','2021-11-25 05:12:02',10,0),('1','64',241523,'MORNING SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'248',809925.00,809925.00,'248','2021-11-25 12:06:47','648','2021-11-25 13:42:31',10,0),('1','64',241680,'AFTERNOON SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'248',748010.00,748010.00,'248','2021-11-25 19:23:57','648','2021-11-26 07:59:55',10,0),('1','64',241816,'MORNING SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'248',172190.00,172190.00,'248','2021-11-26 14:24:12','648','2021-11-26 19:49:09',10,0),('1','64',241923,'AFTERNOON SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'248',77050.00,77050.00,'248','2021-11-26 20:12:37','648','2021-11-26 22:51:48',10,0),('1','64',242047,'MORNING SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'248',242405.00,242405.00,'248','2021-11-27 20:19:50','648','2021-11-28 06:09:49',10,0),('1','64',242215,'AFTERNOON SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'248',1363070.00,1363070.00,'248','2021-11-28 06:37:44','648','2021-11-28 07:19:45',10,0),('1','64',242241,'MORNING SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'248',879575.00,879575.00,'248','2021-11-28 15:33:06','648','2021-11-28 23:08:49',10,0),('1','64',242429,'AFTERNOON SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'248',1312295.00,1312295.00,'248','2021-11-29 06:11:04','648','2021-11-29 07:03:26',10,0),('1','64',242502,'MORNING SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'248',880560.00,880560.00,'248','2021-11-29 13:29:31','648','2021-11-29 14:53:26',10,0),('1','64',242606,'AFTERNOON SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'248',2282540.00,2282540.00,'248','2021-11-29 20:19:00','648','2021-11-29 21:36:50',10,0),('1','64',242743,'MORNING SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'248',988500.00,988500.00,'248','2021-11-30 14:08:28','648','2021-11-30 14:22:25',10,0),('1','64',242891,'AFTERNOON SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'248',1838495.00,1838495.00,'248','2021-11-30 21:53:24','648','2021-12-01 03:41:22',10,0),('1','64',242985,'MORNING SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'248',905315.00,905315.00,'248','2021-12-01 15:24:47','648','2021-12-01 16:20:04',10,0),('1','64',243072,'AFTERNOON SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'248',188370.00,188370.00,'248','2021-12-01 20:55:45','648','2021-12-02 05:10:13',10,0),('1','64',243191,'MORNING SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'248',1069610.00,1069610.00,'248','2021-12-02 13:58:20','648','2021-12-02 14:22:32',10,0),('1','64',243297,'AFTERNOON SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'248',1884525.00,1884525.00,'248','2021-12-02 21:11:06','648','2021-12-02 22:31:17',10,0),('1','64',243404,'MORNING SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'248',758250.00,758250.00,'248','2021-12-03 11:29:32','648','2021-12-03 14:37:16',10,0),('1','64',243568,'AFTERNOON SHIFT ','2021-12-03','2021-12-03 00:00:00',NULL,'248',2112175.00,2112175.00,'248','2021-12-03 21:32:12','648','2021-12-04 04:58:01',10,0),('1','64',243665,'MORNING SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'248',974620.00,974620.00,'248','2021-12-04 15:07:49','648','2021-12-04 15:44:20',10,0),('1','64',243756,'AFTERNOON SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'248',1709715.00,1709715.00,'248','2021-12-05 08:22:41','648','2021-12-05 08:42:10',10,0),('1','64',243896,'MORNING SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'248',1378600.00,1378600.00,'248','2021-12-05 14:05:09','648','2021-12-05 21:18:15',10,0),('1','64',244102,'AFTERNOON SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'248',1268005.00,1268005.00,'248','2021-12-06 07:48:44','648','2021-12-06 09:07:03',10,0),('1','64',244136,'MORNING SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'248',820540.00,820540.00,'248','2021-12-06 12:13:56','648','2021-12-06 13:20:47',10,0),('1','64',244352,'AFTERNOON SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'248',2002735.00,2002735.00,'248','2021-12-07 08:15:38','648','2021-12-07 14:12:14',10,0),('1','64',244448,'MORNING SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'248',694345.00,694345.00,'248','2021-12-07 16:18:07','648','2021-12-07 17:02:59',10,0),('1','64',244485,'AFTERNOON SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'248',1771475.00,1771475.00,'248','2021-12-07 20:59:47','648','2021-12-08 03:42:26',10,0),('1','64',244578,'MORNING SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'248',686750.00,686750.00,'248','2021-12-08 13:12:21','648','2021-12-08 14:27:12',10,0),('1','64',244804,'AFTERNOON SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'248',747410.00,747410.00,'248','2021-12-09 08:46:44','648','2021-12-09 11:21:24',10,0),('1','64',244892,'MORNING SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'248',967370.00,967370.00,'248','2021-12-09 14:45:50','648','2021-12-09 15:30:50',10,0),('1','64',244944,'AFTERNOON SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'248',1593630.00,1593630.00,'248','2021-12-09 21:23:52','648','2021-12-10 04:09:50',10,0),('1','64',245036,'MORNING SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'248',862475.00,862475.00,'248','2021-12-10 14:08:41','648','2021-12-11 08:05:40',10,0),('1','64',245259,'AFTERNOON SHIFT ','2021-12-10','2021-12-10 00:00:00',NULL,'248',1417820.00,1417820.00,'248','2021-12-11 08:26:52','648','2021-12-11 08:29:45',10,0),('1','64',245281,'MORNING SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'248',702125.00,702125.00,'248','2021-12-11 12:50:05','648','2021-12-11 16:29:54',10,0),('1','64',245411,'AFTERNOON SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'248',1268125.00,1268125.00,'248','2021-12-11 21:18:06','648','2021-12-12 05:57:31',10,0),('1','64',245503,'MORNING SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'248',710490.00,710490.00,'248','2021-12-12 12:55:52','648','2021-12-12 14:23:15',10,0),('1','64',245637,'AFTERNOON SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'248',1074315.00,1074315.00,'248','2021-12-12 20:20:27','648','2021-12-13 04:05:46',10,0),('1','64',245725,'MORNING SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'248',544665.00,544665.00,'248','2021-12-13 12:18:08','648','2021-12-14 06:22:45',10,0),('1','64',245980,'AFTERNOON SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'248',702705.00,702705.00,'248','2021-12-14 07:35:03','648','2021-12-14 09:09:57',10,0),('1','64',246017,'MORNING SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'248',633765.00,633765.00,'248','2021-12-14 14:14:03','648','2021-12-14 15:58:49',10,0),('1','64',246141,'AFTERNOON SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'248',1183050.00,1183050.00,'248','2021-12-14 20:13:16','648','2021-12-15 14:01:50',10,0),('1','64',246375,'MORNING SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'248',593670.00,593670.00,'248','2021-12-15 15:20:33','648','2021-12-15 19:17:19',10,0),('1','64',246425,'AFTERNOON SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'248',1251525.00,1251525.00,'248','2021-12-15 21:17:02','648','2021-12-16 06:21:39',10,0),('1','64',246534,'MORNING SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'248',557370.00,557370.00,'248','2021-12-16 13:08:52','648','2021-12-16 14:50:57',10,0),('1','64',246672,'AFTERNOON SHIFT ','2021-12-16','2021-12-16 00:00:00',NULL,'248',1379235.00,1379235.00,'248','2021-12-16 20:52:28','648','2021-12-16 21:02:10',10,0),('1','64',246775,'MORNING SHIFT ','2021-12-17','2021-12-17 00:00:00',NULL,'248',664950.00,664950.00,'248','2021-12-17 14:29:13','648','2021-12-17 15:26:21',10,0),('1','64',246891,'AFTERNOON SHIFT ','2021-12-17','2021-12-17 00:00:00',NULL,'248',1400355.00,1400355.00,'248','2021-12-18 07:43:50','648','2021-12-18 09:11:13',10,0),('1','64',247021,'MORNING SHIFT ','2021-12-18','2021-12-18 00:00:00',NULL,'248',732765.00,732765.00,'248','2021-12-18 15:08:17','648','2021-12-19 05:25:39',10,0),('1','64',247212,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'248',1192290.00,1192290.00,'248','2021-12-19 08:33:34','648','2021-12-19 13:29:21',10,0),('1','64',247317,'MORNING SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'248',712965.00,712965.00,'248','2021-12-19 14:46:24','648','2021-12-20 05:11:18',10,0),('1','64',247460,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'248',1047585.00,1047585.00,'248','2021-12-20 08:14:05','648','2021-12-20 09:25:12',10,0),('1','64',247491,'MORNING SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'248',582625.00,582625.00,'248','2021-12-20 14:02:50','648','2021-12-20 14:22:33',10,0),('1','64',247593,'AFTERNOON SHIFT ','2021-12-20','2021-12-20 00:00:00',NULL,'248',1714275.00,1714275.00,'248','2021-12-21 08:34:46','648','2021-12-21 12:32:23',10,0),('1','64',247821,'MORNING SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'248',2808205.00,2808205.00,'248','2021-12-21 15:34:25','648','2021-12-21 15:45:03',10,0),('1','64',247840,'AFTERNOON SHIFT ','2021-12-21','2021-12-21 00:00:00',NULL,'248',1768840.00,1768840.00,'248','2021-12-21 21:49:48','648','2021-12-22 05:18:29',10,0),('1','64',247963,'MORNING SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'248',871450.00,871450.00,'248','2021-12-22 15:23:54','648','2021-12-22 19:14:32',10,0),('1','64',248128,'AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'248',4494765.00,4494765.00,'248','2021-12-23 12:16:16','648','2021-12-23 12:28:27',10,0),('1','64',248299,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'248',2217795.00,2217795.00,'248','2021-12-23 15:02:47','648','2021-12-23 18:14:30',10,0),('1','64',248341,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'248',1224325.00,1224325.00,'248','2021-12-23 21:40:13','648','2021-12-23 22:04:48',10,0),('1','64',248440,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'248',1166705.00,1166705.00,'248','2021-12-24 12:01:39','648','2021-12-24 13:36:38',10,0),('1','64',248611,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'248',3026235.00,3026235.00,'248','2021-12-24 21:48:14','648','2021-12-25 05:09:07',10,0),('1','64',248757,'MORNING SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'248',2566160.00,2566160.00,'248','2021-12-25 15:09:10','648','2021-12-25 15:24:06',10,0),('1','64',248843,'AFTERNOON SHIFT ','2021-12-25','2021-12-25 00:00:00',NULL,'248',2439650.00,2439650.00,'248','2021-12-25 21:16:58','648','2021-12-25 21:47:33',10,0),('1','64',248949,'MORNING SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'248',1088780.00,1088780.00,'248','2021-12-26 14:34:12','648','2021-12-26 14:34:41',10,0),('1','64',249069,'AFTERNOON SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'248',1217865.00,1217865.00,'248','2021-12-26 20:45:42','648','2021-12-26 23:36:11',10,0),('1','64',249184,'MORNING SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'248',664575.00,664575.00,'248','2021-12-27 18:20:43','648','2021-12-28 06:32:04',10,0),('1','64',249402,'AFTERNOON SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'248',1235435.00,1235435.00,'248','2021-12-28 08:20:52','648','2021-12-28 14:07:55',10,0),('1','64',249497,'MORNING SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'248',551905.00,551905.00,'248','2021-12-28 14:24:50','648','2021-12-28 15:08:53',10,0),('1','64',249520,'AFTERNOON SHIFT ','2021-12-28','2021-12-28 00:00:00',NULL,'248',1120215.00,1120215.00,'248','2021-12-29 10:16:12','648','2021-12-29 12:10:54',10,0),('1','64',249728,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'248',782295.00,782295.00,'248','2021-12-29 12:57:37','648','2021-12-29 13:27:10',10,0),('1','64',249819,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'248',2262530.00,2262530.00,'248','2021-12-29 21:12:57','648','2021-12-29 23:36:45',10,0),('1','64',249946,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'248',1772905.00,1772905.00,'248','2021-12-30 15:04:02','648','2021-12-30 15:19:54',10,0),('1','64',250016,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'248',2187865.00,2187865.00,'248','2021-12-30 21:54:31','648','2021-12-31 05:12:28',10,0),('1','64',250172,'MORNING SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'248',1326140.00,1326140.00,'248','2021-12-31 14:15:19','648','2021-12-31 16:07:46',10,0),('1','64',250300,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'248',4011630.00,4011630.00,'248','2021-12-31 21:08:46','648','2021-12-31 22:52:50',10,0),('1','64',250479,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'248',2993195.00,2993195.00,'248','2022-01-01 14:38:00','648','2022-01-01 14:38:43',10,0),('1','64',250523,'AFTERNOON SHIFT ','2022-01-01','2022-01-01 00:00:00',NULL,'248',2673155.00,2673155.00,'248','2022-01-01 20:39:51','648','2022-01-01 23:35:13',10,0),('1','64',250647,'MORNING SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'248',916040.00,916040.00,'248','2022-01-02 20:36:19','648','2022-01-02 22:13:34',10,0),('1','64',250776,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'248',851515.00,851515.00,'248','2022-01-03 09:01:45','648','2022-01-03 11:25:32',10,0),('1','64',250884,'MORNING SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'248',44555.00,44555.00,'248','2022-01-03 11:40:22','648','2022-01-03 14:16:40',10,0),('1','64',251090,'AFTERNOON SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'248',65995.00,65995.00,'248','2022-01-04 09:20:34','648','2022-01-04 10:14:33',10,0),('1','64',251121,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'248',554425.00,554425.00,'248','2022-01-04 13:20:45','648','2022-01-04 14:22:11',10,0),('1','64',251214,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'248',352755.00,352755.00,'248','2022-01-04 20:37:43','648','2022-01-05 07:47:39',10,0),('1','64',251329,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'248',50250.00,50250.00,'248','2022-01-05 12:38:44','648','2022-01-05 15:16:10',10,0),('1','64',251483,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'248',71690.00,71690.00,'248','2022-01-05 21:39:36','648','2022-01-06 07:57:29',10,0),('1','64',251618,'MORNING SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'248',572515.00,572515.00,'248','2022-01-06 13:19:29','648','2022-01-06 15:05:59',10,0),('1','64',251742,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'248',145390.00,145390.00,'248','2022-01-06 23:47:25','648','2022-01-07 08:29:23',10,0),('1','64',251843,'MORNING SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'248',835965.00,835965.00,'248','2022-01-07 15:35:49','648','2022-01-07 15:37:55',10,0),('1','64',251973,'AFTERNOON SHIFT ','2022-01-07','2022-01-07 00:00:00',NULL,'248',1689905.00,1689905.00,'248','2022-01-07 23:24:40','648','2022-01-08 10:25:27',10,0),('1','64',252096,'MORNING SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'248',976075.00,976075.00,'248','2022-01-08 13:53:11','648','2022-01-08 15:39:42',10,0),('1','64',252203,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'248',1957505.00,1957505.00,'248','2022-01-08 22:11:41','648','2022-01-09 10:25:26',10,0),('1','64',252320,'MORNING SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'248',850820.00,850820.00,'248','2022-01-09 16:26:05','648','2022-01-09 17:32:57',10,0),('1','64',252455,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'248',1734265.00,1734265.00,'248','2022-01-10 00:29:08','648','2022-01-10 08:39:42',10,0),('1','64',252557,'MORNING SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'248',634900.00,634900.00,'248','2022-01-10 15:07:44','648','2022-01-10 21:17:13',10,0),('1','64',252685,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'248',1693630.00,1693630.00,'248','2022-01-10 22:42:11','648','2022-01-11 08:35:17',10,0),('1','64',252781,'MORNING SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'248',600915.00,600915.00,'248','2022-01-11 20:48:10','648','2022-01-11 22:58:24',10,0),('1','64',252952,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'248',1415980.00,1415980.00,'248','2022-01-12 01:46:05','648','2022-01-12 10:00:06',10,0),('1','64',253058,'MORNING SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'248',632525.00,632525.00,'248','2022-01-12 13:54:42','648','2022-01-12 14:13:56',10,0),('1','64',253176,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'248',1693530.00,1693530.00,'248','2022-01-12 21:50:34','648','2022-01-13 00:36:30',10,0),('1','64',253317,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'248',607545.00,607545.00,'248','2022-01-13 15:36:56','648','2022-01-13 19:44:08',10,0),('1','64',253442,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'248',1604460.00,1604460.00,'248','2022-01-13 21:51:16','648','2022-01-14 07:01:36',10,0),('1','64',253558,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'248',722785.00,722785.00,'248','2022-01-14 15:01:03','648','2022-01-14 19:18:37',10,0),('1','64',253664,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'248',1686565.00,1686565.00,'248','2022-01-14 22:39:43','648','2022-01-15 06:53:44',10,0),('1','64',253808,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'248',865405.00,865405.00,'248','2022-01-15 13:12:02','648','2022-01-15 14:56:19',10,0),('1','64',253897,'AFTERNOON SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'248',1631525.00,1631525.00,'248','2022-01-15 21:56:57','648','2022-01-15 22:08:50',10,0),('1','64',253937,'MORNING SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'248',354570.00,354570.00,'248','2022-01-17 11:12:29','648','2022-01-17 11:20:18',10,0),('1','64',254298,'AFTERNOON SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'248',165825.00,165825.00,'248','2022-01-17 11:45:39','648','2022-01-17 13:44:42',10,0),('1','64',254328,'MORNING SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'248',58625.00,58625.00,'248','2022-01-17 14:38:10','648','2022-01-17 14:48:58',10,0),('1','64',254417,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'248',468665.00,468665.00,'248','2022-01-17 21:50:30','648','2022-01-18 10:30:42',10,0),('1','64',254586,'MORNING SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'248',92795.00,92795.00,'248','2022-01-18 14:20:27','648','2022-01-18 14:51:56',10,0),('1','64',254678,'AFTERNOON SHIFT ','2022-01-18','2022-01-18 00:00:00',NULL,'248',64655.00,64655.00,'248','2022-01-18 22:43:58','648','2022-01-19 06:32:14',10,0),('1','64',254739,'MORNING SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'248',34505.00,34505.00,'248','2022-01-19 14:43:57','648','2022-01-19 16:17:35',10,0),('1','64',254889,'AFTERNOON SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'248',511290.00,511290.00,'248','2022-01-19 22:21:39','648','2022-01-20 08:57:44',10,0),('1','64',255028,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'248',75555.00,75555.00,'248','2022-01-20 14:01:16','648','2022-01-20 16:11:01',10,0),('1','64',255173,'AFTERNOON SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'248',454980.00,454980.00,'248','2022-01-21 10:23:39','648','2022-01-21 15:31:52',10,0),('1','64',255349,'MORNING SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'248',394450.00,394450.00,'248','2022-01-21 16:40:05','648','2022-01-21 21:53:42',10,0),('1','64',255435,'AFTERNOON SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'248',1175450.00,1175450.00,'248','2022-01-22 11:16:45','648','2022-01-22 14:06:09',10,0),('1','64',255653,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'248',594450.00,594450.00,'248','2022-01-22 19:15:30','648','2022-01-23 08:23:16',10,0),('1','64',255789,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'248',1241135.00,1241135.00,'248','2022-01-23 11:18:42','648','2022-01-23 14:47:08',10,0),('1','64',255869,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'248',383610.00,383610.00,'248','2022-01-23 17:02:42','648','2022-01-23 21:59:07',10,0),('1','64',255924,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'248',1275075.00,1275075.00,'248','2022-01-24 10:24:31','648','2022-01-24 13:57:26',10,0),('1','64',256098,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'248',559870.00,559870.00,'248','2022-01-24 15:46:22','648','2022-01-24 15:47:21',10,0),('1','64',256283,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'248',1286635.00,1286635.00,'248','2022-01-25 10:10:39','648','2022-01-25 11:42:10',10,0),('1','64',256344,'MORNING SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'248',552250.00,552250.00,'248','2022-01-25 14:13:40','648','2022-01-25 15:37:55',10,0),('1','64',256425,'AFTERNOON SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'248',1337170.00,1337170.00,'248','2022-01-26 09:54:32','648','2022-01-26 10:02:33',10,0),('1','64',256569,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'248',1017870.00,1017870.00,'248','2022-01-26 16:15:59','648','2022-01-26 20:31:50',10,0),('1','64',256703,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'248',2129055.00,2129055.00,'248','2022-01-27 08:19:28','648','2022-01-27 09:37:15',10,0),('1','64',256840,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'248',2709485.00,2709485.00,'248','2022-01-27 16:23:39','648','2022-01-28 09:08:59',10,0),('1','64',257038,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'248',871740.00,871740.00,'248','2022-01-29 08:14:42','648','2022-01-29 09:28:58',10,0),('1','64',257302,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'248',111470.00,111470.00,'248','2022-01-29 10:16:06','648','2022-01-29 10:32:34',10,0),('1','64',257332,'AFTERNOON SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'248',359370.00,359370.00,'248','2022-01-29 12:12:43','648','2022-01-29 19:09:55',10,0),('1','64',257422,'MORNING SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'248',489225.00,489225.00,'248','2022-01-29 19:36:49','648','2022-01-30 11:17:00',10,0),('1','64',257582,'AFTERNOON SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'248',1138995.00,1138995.00,'248','2022-01-30 11:56:32','648','2022-01-30 14:59:00',10,0),('1','64',257583,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'248',537570.00,537570.00,'248','2022-01-31 11:41:31','648','2022-01-31 11:43:59',10,0),('1','64',257584,'AFTERNOON SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'248',1040835.00,1040835.00,'248','2022-01-31 12:05:22','648','2022-01-31 12:10:51',10,0),('1','64',257585,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'248',581460.00,581460.00,'248','2022-01-31 14:17:28','648','2022-01-31 14:22:48',10,0),('1','64',257586,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'248',1045935.00,1045935.00,'248','2022-02-01 09:43:35','648','2022-02-01 10:06:53',10,0),('1','64',257587,'MORNING SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'248',593835.00,593835.00,'248','2022-02-01 14:35:34','648','2022-02-01 14:58:01',10,0),('1','64',257588,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'248',1014090.00,1014090.00,'248','2022-02-02 10:12:14','648','2022-02-02 15:26:10',10,0),('1','64',257589,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'248',467115.00,467115.00,'248','2022-02-02 15:52:04','648','2022-02-03 06:38:03',10,0),('1','64',257590,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'248',1004355.00,1004355.00,'248','2022-02-03 08:33:30','648','2022-02-03 09:16:23',10,0),('1','64',257591,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'248',251955.00,251955.00,'248','2022-02-03 19:56:23','648','2022-02-04 09:10:02',10,0),('1','64',257592,'AFTERNOON SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'248',0.00,0.00,'248','2022-02-04 11:17:46','648','2022-02-06 12:18:39',10,0),('1','64',257593,'MORNING SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'248',203300.00,203300.00,'248','2022-02-07 19:38:47','648','2022-02-07 19:52:02',10,0),('1','64',257594,'AFTERNOON SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'248',71060.00,71060.00,'248','2022-02-07 20:38:14','648','2022-02-08 10:09:44',10,0),('1','64',257595,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'248',88160.00,88160.00,'248','2022-02-08 14:16:45','648','2022-02-08 20:29:40',10,0),('1','64',257596,'AFTERNOON SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'248',221160.00,221160.00,'248','2022-02-08 20:45:59','648','2022-02-09 08:54:44',10,0),('1','64',257597,'MORNING SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'248',156585.00,156585.00,'248','2022-02-09 20:34:56','648','2022-02-10 08:52:14',10,0),('1','64',257598,'AFTERNOON SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'248',1005235.00,1005235.00,'248','2022-02-10 14:40:38','648','2022-02-10 16:07:14',10,0),('1','64',257599,'MORNING SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'248',613140.00,613140.00,'248','2022-02-11 12:41:21','648','2022-02-11 12:44:15',10,0),('1','64',257600,'AFTERNOON SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'248',1053800.00,1053800.00,'248','2022-02-11 16:00:51','648','2022-02-11 16:05:49',10,0),('1','64',257601,'MORNING SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'248',376145.00,376145.00,'248','2022-02-11 16:23:25','648','2022-02-11 16:59:52',10,0),('1','64',257602,'AFTERNOON SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'248',0.00,0.00,'248','2022-02-11 22:46:21','648','2022-02-12 09:24:42',10,0),('1','64',257603,'MORNING SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'248',25025.00,25025.00,'248','2022-02-12 16:10:24','648','2022-02-12 16:14:45',10,0),('1','64',257604,'AFTERNOON SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'248',67760.00,67760.00,'248','2022-02-12 17:16:51','648','2022-02-13 10:26:14',10,0),('1','64',257605,'PRICE CHANGE SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'248',933625.00,933625.00,'248','2022-02-13 12:47:30','648','2022-02-13 15:38:55',10,0),('1','64',257606,'MORNING SHIFT ','2022-02-13','2022-02-13 00:00:00',NULL,'248',596365.00,596365.00,'248','2022-02-13 18:06:39','648','2022-02-14 08:54:00',10,0),('1','64',257607,'AFTERNOON SHIFT ','2022-02-13','2022-02-13 00:00:00',NULL,'248',1369830.00,1369830.00,'248','2022-02-14 09:39:09','648','2022-02-14 10:57:51',10,0),('1','64',257608,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'248',900425.00,900425.00,'248','2022-02-14 19:55:04','648','2022-02-14 22:50:50',10,0),('1','64',257609,'AFTERNOON SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'248',1978425.00,1978425.00,'248','2022-02-15 09:12:24','648','2022-02-15 11:26:23',10,0),('1','64',257610,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'248',2135105.00,2135105.00,'248','2022-02-15 15:21:36','648','2022-02-15 15:40:13',10,0),('1','64',257611,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'248',3668245.00,3668245.00,'248','2022-02-15 21:20:49','648','2022-02-16 08:48:26',10,0),('1','64',257612,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'248',1871460.00,1871460.00,'248','2022-02-16 15:30:01','648','2022-02-16 23:20:45',10,0),('1','64',257613,'AFTERNOON SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'248',2943890.00,2943890.00,'248','2022-02-17 10:14:34','648','2022-02-17 10:49:04',10,0),('1','64',257614,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'248',365200.00,365200.00,'248','2022-02-17 14:54:15','648','2022-02-17 15:13:51',10,0),('1','64',257615,'AFTERNOON SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'248',1579905.00,1579905.00,'248','2022-02-17 21:59:15','648','2022-02-17 22:04:27',10,0),('1','64',257616,'MORNING SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'248',1673610.00,1673610.00,'248','2022-02-18 18:24:12','648','2022-02-19 00:06:08',10,0),('1','64',257617,'AFTERNOON SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'248',971595.00,971595.00,'248','2022-02-19 14:03:56','648','2022-02-19 14:49:35',10,0),('1','64',257618,'MORNING SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'248',1624170.00,1624170.00,'248','2022-02-20 10:19:34','648','2022-02-20 13:09:43',10,0),('1','64',257619,'AFTERNOON SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'248',2983200.00,2983200.00,'248','2022-02-20 14:03:56','648','2022-02-20 14:34:24',10,0),('1','64',257620,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'248',2309055.00,2309055.00,'248','2022-02-21 01:07:43','648','2022-02-21 06:44:22',10,0),('1','64',257621,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'248',4098375.00,4098375.00,'248','2022-02-21 12:27:53','648','2022-02-21 14:30:51',10,0),('1','64',257622,'MORNING SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'248',414780.00,414780.00,'248','2022-02-21 15:15:04','648','2022-02-21 16:37:07',10,0),('1','64',257623,'AFTERNOON SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'248',2616960.00,2616960.00,'248','2022-02-23 11:58:37','648','2022-02-23 12:03:51',10,0),('1','64',257624,'MORNING SHIFT','2022-02-22','2022-02-23 12:11:17','2022-02-24 12:11:17','248',1434465.00,1434465.00,'248','2022-02-23 12:15:54','648','2022-02-23 12:17:44',10,0),('1','64',257625,'AFTERNOON SHIFT','2022-02-22','2022-02-23 12:22:42','2022-02-24 12:22:42','248',57105.00,57105.00,'248','2022-02-23 12:34:26','648','2022-02-23 12:45:43',10,0),('1','64',257626,'PRICE CHANGE SHIFT','2022-02-22','2022-02-23 13:09:50','2022-02-24 13:09:50','248',335135.00,335135.00,'248','2022-02-23 13:24:12','648','2022-02-23 13:50:26',10,0),('1','64',257627,'MORNING SHIFT','2022-02-23','2022-02-23 14:04:25','2022-02-24 14:04:25','248',85325.00,85325.00,'248','2022-02-23 14:11:29','648','2022-02-23 15:38:02',10,0),('1','64',257628,'AFTERNOON SHIFT','2022-02-23','2022-02-23 16:38:44','2022-02-24 16:38:44','248',532725.00,532725.00,'248','2022-02-24 09:34:15','648','2022-02-24 09:39:02',10,0),('1','64',257629,'MORNING SHIFT','2022-02-24','2022-02-24 13:54:37','2022-02-25 13:54:37','248',131200.00,131200.00,'248','2022-02-24 15:30:13','648','2022-02-24 16:26:12',10,0),('1','64',257630,'AFTERNOON SHIFT','2022-02-24','2022-02-24 18:19:33','2022-02-25 18:19:33','248',508400.00,508400.00,'248','2022-02-25 08:40:41','648','2022-02-25 09:00:47',10,0),('1','64',257631,'MORNING SHIFT','2022-02-25','2022-02-25 09:51:31','2022-02-26 09:51:31','248',589580.00,589580.00,'248','2022-02-25 15:33:30','648','2022-02-25 15:39:20',10,0),('1','64',257632,'AFTERNOON SHIFT','2022-02-25','2022-02-25 15:53:04','2022-02-26 15:53:04','248',598390.00,598390.00,'248','2022-02-25 22:16:54','648','2022-02-26 10:18:36',10,0),('1','64',257633,'MORNING SHIFT','2022-02-26','2022-02-26 16:06:00','2022-02-27 16:06:00','248',66320.00,66320.00,'248','2022-02-26 16:35:03','648','2022-02-27 06:43:24',10,0),('1','64',257634,'AFTERNOON SHIFT','2022-02-26','2022-02-27 09:03:01','2022-02-28 09:03:01','248',632670.00,632670.00,'248','2022-02-27 09:15:12','648','2022-02-27 09:45:13',10,0),('1','64',257635,'MORNING SHIFT','2022-02-27','2022-02-27 13:34:56','2022-02-28 13:34:56','248',2033085.00,2033085.00,'248','2022-02-27 13:46:18','648','2022-02-27 14:32:46',10,0),('1','64',257636,'AFTERNOON SHIFT ','2022-02-27','2022-02-27 19:30:25','2022-02-28 19:30:25','248',728740.00,728740.00,'248','2022-02-27 21:33:00','648','2022-02-28 09:46:18',10,0),('1','64',257637,'MORNING SHIFT','2022-02-28','2022-02-28 09:59:14','2022-03-01 09:59:14','248',144835.00,144835.00,'248','2022-02-28 15:51:38','648','2022-02-28 16:28:29',10,0),('1','64',257638,'AFTERNOON SHIFT','2022-02-28','2022-02-28 21:38:45','2022-03-01 21:38:45','248',242775.00,242775.00,'248','2022-02-28 21:40:29','648','2022-02-28 21:56:22',10,0),('1','64',257639,'MORNING SHIFT','2022-03-01','2022-03-01 13:03:09','2022-03-02 13:03:09','248',48555.00,48555.00,'248','2022-03-01 13:08:42','648','2022-03-01 16:01:21',10,0),('1','64',257640,'PRICE CHANGE SHIFT','2022-03-01','2022-03-01 17:31:45','2022-03-02 17:31:45','248',69300.00,69300.00,'248','2022-03-01 17:34:02','648','2022-03-01 22:34:50',10,0),('1','64',257641,'AFTERNOON SHIFT','2022-03-01','2022-03-01 23:00:38','2022-03-02 23:00:38','248',2294880.00,2294880.00,'248','2022-03-01 23:05:17','648','2022-03-02 08:57:00',10,0),('1','64',257642,'MORNING SHIFT','2022-03-02','2022-03-02 09:13:49','2022-03-03 09:13:49','248',171360.00,171360.00,'248','2022-03-02 17:08:36','648','2022-03-03 07:06:12',10,0),('1','64',257643,'AFTERNOON SHIFT','2022-03-02','2022-03-03 14:30:16','2022-03-04 14:30:16','248',1417280.00,1417280.00,'248','2022-03-03 15:28:07','648','2022-03-03 17:00:20',10,0),('1','64',257644,'MORNING SHIFT','2022-03-03','2022-03-03 19:57:47','2022-03-04 19:57:47','248',50740.00,50740.00,'248','2022-03-03 20:04:39','648','2022-03-04 10:25:32',10,0),('1','64',257645,'AFTERNOON SHIFT','2022-03-03','2022-03-04 13:09:35','2022-03-05 13:09:35','248',2546605.00,2546605.00,'248','2022-03-04 16:34:46','648','2022-03-04 19:29:18',10,0),('1','64',257646,'MORNING SHIFT ','2022-03-04','2022-03-04 20:25:51','2022-03-05 20:25:51','248',0.00,0.00,'248','2022-03-04 20:35:45','648','2022-03-05 08:46:42',10,0),('1','64',257647,'AFTERNOON SHIFT','2022-03-05','2022-03-05 10:34:02','2022-03-06 10:34:02','248',384420.00,384420.00,'248','2022-03-05 14:27:18','648','2022-03-05 14:36:06',10,0),('1','64',257648,'MORNING SHIFT','2022-03-05','2022-03-05 14:47:56','2022-03-06 14:47:56','248',0.00,0.00,'248','2022-03-07 09:01:06','648','2022-03-07 09:11:09',10,0),('1','64',257649,'AFTERNOON SHIFT','2022-03-05','2022-03-07 09:15:43','2022-03-08 09:15:43','248',48300.00,48300.00,'248','2022-03-07 09:17:13','648','2022-03-07 09:21:02',10,0),('1','64',257650,'MORNING SHIFT','2022-03-11','2022-03-11 15:02:07','2022-03-12 15:02:07','248',488730.00,488730.00,'248','2022-03-11 21:56:48','648','2022-03-11 22:33:15',10,0),('1','64',257651,'AFTERNOON SHIFT','2022-03-11','2022-03-11 23:56:07','2022-03-12 23:56:07','248',1341615.00,1341615.00,'248','2022-03-12 10:13:21','648','2022-03-12 17:28:53',10,0),('1','64',257652,'MORNING SHIFT','2022-03-12','2022-03-12 17:36:05','2022-03-13 17:36:05','248',3394725.00,3394725.00,'248','2022-03-12 21:29:51','648','2022-03-13 12:38:10',10,0),('1','64',257653,'AFTERNOON SHIFT ','2022-03-12','2022-03-13 14:49:19','2022-03-14 14:49:19','248',1817430.00,1817430.00,'248','2022-03-13 14:58:09','648','2022-03-13 16:58:25',10,0),('1','64',257654,'MORNING SHIFT','2022-03-13','2022-03-13 21:40:26','2022-03-14 21:40:26','248',2274210.00,2274210.00,'248','2022-03-13 21:48:13','648','2022-03-14 06:51:39',10,0),('1','64',257655,'AFTERNOON SHIFT','2022-03-13','2022-03-14 08:36:31','2022-03-15 08:36:31','248',1666965.00,1666965.00,'248','2022-03-14 14:18:48','648','2022-03-14 15:08:28',10,0),('1','64',257656,'MORNING SHIFT','2022-03-14','2022-03-14 16:19:54','2022-03-15 16:19:54','248',1196625.00,1196625.00,'248','2022-03-14 16:49:26','648','2022-03-14 16:52:09',10,0),('1','64',257657,'AFTERNOON SHIFT','2022-03-14','2022-03-14 23:47:25','2022-03-15 23:47:25','248',3243465.00,3243465.00,'248','2022-03-15 10:23:53','648','2022-03-15 10:26:03',10,0),('1','64',257658,'MORNING SHIFT','2022-03-15','2022-03-15 11:02:01','2022-03-16 11:02:01','248',2493900.00,2493900.00,'248','2022-03-15 15:05:52','648','2022-03-15 17:05:15',10,0),('1','64',257659,'AFTERNOON SHIFT','2022-03-15','2022-03-15 22:05:50','2022-03-16 22:05:50','248',1494925.00,1494925.00,'248','2022-03-16 09:12:04','648','2022-03-16 09:38:35',10,0),('1','64',257660,'MORNING SHIFT','2022-03-16','2022-03-16 14:20:17','2022-03-17 14:20:17','248',823845.00,823845.00,'248','2022-03-16 14:25:54','648','2022-03-16 15:59:57',10,0),('1','64',257661,'AFTERNOON SHIFT','2022-03-17','2022-03-17 21:26:34','2022-03-18 21:26:34','248',118300.00,118300.00,'248','2022-03-18 12:49:03','648','2022-03-19 07:18:20',10,0),('1','64',257662,'MORNING SHIFT','2022-03-23','2022-03-23 19:03:54','2022-03-24 19:03:54','248',1169190.00,1169190.00,'248','2022-03-24 01:11:25','648','2022-03-24 09:26:05',10,0),('1','64',257663,'AFTERNOON SHIFT','2022-03-23','2022-03-24 10:09:34','2022-03-25 10:09:34','248',1458270.00,1458270.00,'248','2022-03-24 10:14:10','648','2022-03-24 15:02:18',10,0),('1','64',257664,'MORNING SHIFT','2022-03-24','2022-03-24 19:06:59','2022-03-25 19:06:59','248',763620.00,763620.00,'248','2022-03-24 22:47:40','648','2022-03-25 09:03:12',10,0),('1','64',257665,'AFTERNOON SHIFT','2022-03-24','2022-03-25 10:34:30','2022-03-26 10:34:30','248',2351030.00,2351030.00,'248','2022-03-25 12:08:10','648','2022-03-25 16:36:24',10,0),('1','64',257666,'MORNING SHIFT','2022-03-25','2022-03-25 17:33:18','2022-03-26 17:33:18','248',543370.00,543370.00,'248','2022-03-25 17:41:08','648','2022-03-25 18:57:47',10,0),('1','64',257667,'AFTERNOON SHIFT','2022-03-25','2022-03-26 09:40:55','2022-03-27 09:40:55','248',3638485.00,3638485.00,'248','2022-03-26 09:56:44','648','2022-03-26 10:37:27',10,0),('1','64',257668,'MORNING SHIFT','2022-03-26','2022-03-26 10:46:15','2022-03-27 10:46:15','248',2443270.00,2443270.00,'248','2022-03-26 16:13:09','648','2022-03-26 17:58:11',10,0),('1','64',257669,'AFTERNOON SHIFT','2022-03-26','2022-03-27 08:50:42','2022-03-28 08:50:42','248',1421395.00,1421395.00,'248','2022-03-27 08:53:55','648','2022-03-27 10:51:07',10,0),('1','64',257670,'MORNING SHIFT','2022-03-27','2022-03-27 12:34:57','2022-03-28 12:34:57','248',73030.00,73030.00,'248','2022-03-27 12:45:08','648','2022-03-27 14:23:45',10,0),('1','64',257671,'AFTERNOON SHIFT','2022-03-27','2022-03-27 22:02:37','2022-03-28 22:02:37','248',28140.00,28140.00,'248','2022-03-27 22:03:26','648','2022-03-28 00:30:01',10,0),('1','64',257672,'MORNING SHIFT','2022-03-28','2022-03-28 11:38:45','2022-03-29 11:38:45','248',146060.00,146060.00,'248','2022-03-29 01:22:48','648','2022-03-29 10:31:51',10,0),('1','64',257673,'AFTERNOON SHIFT','2022-03-28','2022-03-29 14:14:43','2022-03-30 14:14:43','248',209930.00,209930.00,'248','2022-03-29 15:08:28','648','2022-03-30 00:29:35',10,0),('1','64',257674,'MORNING SHIFT','2022-03-29','2022-03-30 09:14:51','2022-03-31 09:14:51','248',43125.00,43125.00,'248','2022-03-30 09:18:22','648','2022-03-30 16:02:34',10,0),('1','64',257675,'AFTERNOON SHIFT','2022-03-30','2022-03-31 15:21:32','2022-04-01 15:21:32','248',197650.00,197650.00,'248','2022-03-31 17:28:57','648','2022-03-31 21:02:14',10,0),('1','64',257676,'AFTERNOON SHIFT','2022-03-31','2022-03-31 22:14:21','2022-04-01 22:14:21','248',786985.00,786985.00,'248','2022-04-01 16:40:28','648','2022-04-02 06:59:21',10,0),('1','64',257677,'MORNING SHIFT','2022-04-01','2022-04-02 10:55:34','2022-04-03 10:55:34','248',824505.00,824505.00,'248','2022-04-02 11:05:28','648','2022-04-02 20:17:17',10,0),('1','64',257678,'AFTERNOON SHIFT','2022-04-01','2022-04-02 20:47:28','2022-04-03 20:47:28','248',1086525.00,1086525.00,'248','2022-04-02 20:49:08','648','2022-04-03 07:45:45',10,0),('1','64',257679,'MORNING SHIFT','2022-04-02','2022-04-03 08:22:13','2022-04-04 08:22:13','248',3732805.00,3732805.00,'248','2022-04-03 08:58:04','648','2022-04-04 00:26:54',10,0),('1','64',257680,'AFTERNOON SHIFT','2022-04-02','2022-04-04 12:02:52','2022-04-05 12:02:52','248',2773800.00,2773800.00,'248','2022-04-04 12:06:04','648','2022-04-04 21:54:06',10,0),('1','64',257681,'MORNING SHIFT','2022-04-03','2022-04-04 22:03:24','2022-04-05 22:03:24','248',2546000.00,2546000.00,'248','2022-04-04 22:05:13','648','2022-04-04 23:12:56',10,0),('1','64',257682,'AFTERNOON SHIFT','2022-04-03','2022-04-04 23:38:48','2022-04-05 23:38:48','248',1500800.00,1500800.00,'248','2022-04-04 23:43:59','648','2022-04-05 06:20:53',10,0),('1','64',257683,'MORNING SHIFT','2022-04-04','2022-04-05 08:23:10','2022-04-06 08:23:10','248',108540.00,108540.00,'248','2022-04-05 14:34:04','648','2022-04-05 14:41:20',10,0),('1','64',257684,'AFTERNOON SHIFT','2022-04-04','2022-04-05 15:06:21','2022-04-06 15:06:21','248',791940.00,791940.00,'248','2022-04-05 18:11:04','648','2022-04-05 21:46:25',10,0),('1','64',257685,'MORNING SHIFT','2022-04-05','2022-04-05 23:05:22','2022-04-06 23:05:22','248',7688770.00,7688770.00,'248','2022-04-06 11:53:03','648','2022-04-06 14:21:42',10,0),('1','64',257686,'AFTERNOON SHIFT','2022-04-05','2022-04-06 15:12:15','2022-04-07 15:12:15','248',1077380.00,1077380.00,'248','2022-04-06 15:26:53','648','2022-04-07 06:39:58',10,0),('1','64',257687,'MORNING SHIFT','2022-04-06','2022-04-07 09:18:26','2022-04-08 09:18:26','248',1070895.00,1070895.00,'248','2022-04-07 09:26:31','648','2022-04-07 14:00:20',10,0),('1','64',257688,'AFTERNOON SHIFT','2022-04-06','2022-04-07 14:29:52','2022-04-08 14:29:52','248',2887645.00,2887645.00,'248','2022-04-07 16:24:44','648','2022-04-07 21:12:37',10,0),('1','64',257689,'MORNING SHIFT','2022-04-07','2022-04-07 21:37:09','2022-04-08 21:37:09','248',570840.00,570840.00,'248','2022-04-07 21:53:48','648','2022-04-07 22:09:02',10,0),('1','64',257690,'AFTERNOON SHIFT','2022-04-07','2022-04-07 23:52:42','2022-04-08 23:52:42','248',1513530.00,1513530.00,'248','2022-04-08 08:23:42','648','2022-04-08 12:38:49',10,0),('1','64',257691,'MORNING SHIFT','2022-04-08','2022-04-08 15:21:47','2022-04-09 15:21:47','248',3168430.00,3168430.00,'248','2022-04-08 17:20:16','648','2022-04-09 08:27:40',10,0),('1','64',257692,'AFTERNOON SHIFT','2022-04-08','2022-04-09 08:51:24','2022-04-10 08:51:24','248',438850.00,438850.00,'248','2022-04-09 13:26:37','648','2022-04-09 23:13:17',10,0),('1','64',257693,'MORNING SHIFT','2022-04-09','2022-04-10 09:55:12','2022-04-11 09:55:12','248',764470.00,764470.00,'248','2022-04-10 09:59:07','648','2022-04-10 10:18:14',10,0),('1','64',257694,'AFTERNOON SHIFT','2022-04-09','2022-04-10 10:31:32','2022-04-11 10:31:32','248',1139025.00,1139025.00,'248','2022-04-10 17:15:39','648','2022-04-11 06:20:41',10,0),('1','64',257695,'MORNING SHIFT','2022-04-10','2022-04-11 07:43:48','2022-04-12 07:43:48','248',973600.00,973600.00,'248','2022-04-11 07:51:14','648','2022-04-11 08:24:50',10,0),('1','64',257696,'AFTERNOON SHIFT','2022-04-10','2022-04-11 09:20:59','2022-04-12 09:20:59','248',1197245.00,1197245.00,'248','2022-04-11 09:25:31','648','2022-04-11 14:29:46',10,0),('1','64',257697,'MORNING SHIFT','2022-04-11','2022-04-11 14:41:40','2022-04-12 14:41:40','248',588735.00,588735.00,'248','2022-04-12 11:44:28','648','2022-04-12 14:19:16',10,0),('1','64',257698,'AFTERNOON SHIFT','2022-04-11','2022-04-12 14:57:31','2022-04-13 14:57:31','248',187600.00,187600.00,'248','2022-04-12 15:06:43','648','2022-04-12 17:13:36',10,0),('1','64',257699,'MORNING SHIFT','2022-04-12','2022-04-12 21:20:17','2022-04-13 21:20:17','248',84420.00,84420.00,'248','2022-04-12 21:22:13','648','2022-04-13 10:20:22',10,0),('1','64',257700,'AFTERNOON SHIFT ','2022-04-12','2022-04-13 13:00:10','2022-04-14 13:00:10','248',1104195.00,1104195.00,'248','2022-04-13 13:21:47','648','2022-04-13 17:17:10',10,0),('1','64',257701,'MORNING SHIFT','2022-04-13','2022-04-13 18:01:13','2022-04-14 18:01:13','248',804870.00,804870.00,'248','2022-04-13 18:13:29','648','2022-04-14 08:12:42',10,0),('1','64',257702,'AFTERNOON SHIFT','2022-04-13','2022-04-14 08:42:49','2022-04-15 08:42:49','248',1110780.00,1110780.00,'248','2022-04-14 08:46:13','648','2022-04-14 09:29:37',10,0),('1','64',257703,'MORNING SHIFT','2022-04-14','2022-04-14 14:08:31','2022-04-15 14:08:31','248',830445.00,830445.00,'248','2022-04-14 14:16:46','648','2022-04-14 15:44:11',10,0),('1','64',257704,'AFTERNOON SHIFT','2022-04-14','2022-04-14 21:12:46','2022-04-15 21:12:46','248',838365.00,838365.00,'248','2022-04-15 11:52:16','648','2022-04-15 12:27:53',10,0),('1','64',257705,'MORNING SHIFT','2022-04-15','2022-04-15 17:54:48','2022-04-16 17:54:48','248',796950.00,796950.00,'248','2022-04-15 18:01:37','648','2022-04-16 08:32:45',10,0),('1','64',257706,'AFTERNOON SHIFT','2022-04-15','2022-04-16 10:38:52','2022-04-17 10:38:52','248',1422860.00,1422860.00,'248','2022-04-16 13:33:20','648','2022-04-16 14:17:22',10,0),('1','64',257707,'MORNING SHIFT','2022-04-16','2022-04-16 16:09:10','2022-04-17 16:09:10','248',27885.00,27885.00,'248','2022-04-17 00:26:51','648','2022-04-17 11:50:11',10,0),('1','64',257708,'AFTERNOON SHIFT','2022-04-16','2022-04-17 13:10:42','2022-04-18 13:10:42','248',2192080.00,2192080.00,'248','2022-04-17 15:53:04','648','2022-04-17 16:42:24',10,0),('1','64',257709,'MORNING SHIFT','2022-04-17','2022-04-17 21:17:46','2022-04-18 21:17:46','248',1744630.00,1744630.00,'248','2022-04-18 12:17:35','648','2022-04-18 12:37:28',10,0),('1','64',257710,'AFTERNOON SHIFT','2022-04-17','2022-04-18 15:06:25','2022-04-19 15:06:25','248',304070.00,304070.00,'248','2022-04-18 15:09:48','648','2022-04-18 16:13:10',10,0),('1','64',257711,'MORNING SHIFT','2022-04-18','2022-04-18 19:56:17','2022-04-19 19:56:17','248',786235.00,786235.00,'248','2022-04-18 20:24:08','648','2022-04-18 22:59:30',10,0),('1','64',257712,'AFTERNOON SHIFT','2022-04-18','2022-04-19 11:20:53','2022-04-20 11:20:53','248',1876365.00,1876365.00,'248','2022-04-19 12:32:03','648','2022-04-19 14:55:16',10,0),('1','64',257713,'MORNING SHIFT','2022-04-19','2022-04-19 16:39:45','2022-04-20 16:39:45','248',121275.00,121275.00,'248','2022-04-19 16:42:57','648','2022-04-19 17:41:42',10,0),('1','64',257714,'AFTERNOON SHIFT','2022-04-19','2022-04-19 22:13:23','2022-04-20 22:13:23','248',683035.00,683035.00,'248','2022-04-19 22:15:30','648','2022-04-19 23:29:18',10,0),('1','64',257715,'MORNING SHIFT','2022-04-20','2022-04-20 12:23:18','2022-04-21 12:23:18','248',72435.00,72435.00,'248','2022-04-20 21:58:00','648','2022-04-21 04:55:00',10,0),('1','64',257716,'AFTERNOON SHIFT','2022-04-20','2022-04-21 11:25:14','2022-04-22 11:25:14','248',676860.00,676860.00,'248','2022-04-21 11:40:31','648','2022-04-21 16:48:23',10,0),('1','64',257717,'MORNING SHIFT','2022-04-21','2022-04-21 21:19:54','2022-04-22 21:19:54','248',644885.00,644885.00,'248','2022-04-21 21:36:13','648','2022-04-22 09:18:03',10,0),('1','64',257718,'AFTERNOON SHIFT','2022-04-21','2022-04-22 12:42:15','2022-04-23 12:42:15','248',1482245.00,1482245.00,'248','2022-04-22 12:50:33','648','2022-04-22 20:49:15',10,0),('1','64',257719,'MORNING SHIFT','2022-04-22','2022-04-22 21:23:45','2022-04-23 21:23:45','248',1145715.00,1145715.00,'248','2022-04-22 21:33:29','648','2022-04-22 22:29:31',10,0),('1','64',257720,'MORNING SHIFT','2022-04-23','2022-04-23 20:33:27','2022-04-24 20:33:27','248',84420.00,84420.00,'248','2022-04-23 20:34:45','648','2022-04-24 12:04:40',10,0),('1','64',257721,'AFTERNOON SHIFT','2022-04-23','2022-04-24 14:42:07','2022-04-25 14:42:07','248',1272205.00,1272205.00,'248','2022-04-24 20:13:39','648','2022-04-25 05:56:23',10,0),('1','64',257722,'MORNING SHIFT','2022-04-25','2022-04-25 16:17:35','2022-04-26 16:17:35','248',46210.00,46210.00,'248','2022-04-25 16:19:19','648','2022-04-26 07:47:43',10,0),('1','64',257723,'AFTERNOON SHIFT','2022-04-25','2022-04-26 15:15:43','2022-04-27 15:15:43','248',366460.00,366460.00,'248','2022-04-26 15:18:47','648','2022-04-26 22:31:18',10,0),('1','64',257724,'AFTERNOON SHIFT','2022-04-26','2022-04-27 08:44:58','2022-04-28 08:44:58','248',319905.00,319905.00,'248','2022-04-27 08:49:58','648','2022-04-27 10:50:59',10,0),('1','64',257725,'MORNING SHIFT','2022-04-27','2022-04-27 18:30:12','2022-04-28 18:30:12','248',88440.00,88440.00,'248','2022-04-27 18:31:59','648','2022-04-27 18:38:29',10,0),('1','64',257726,'AFTERNOON SHIFT','2022-04-27','2022-04-27 21:09:40','2022-04-28 21:09:40','248',291495.00,291495.00,'248','2022-04-27 21:10:59','648','2022-04-28 09:27:39',10,0),('1','64',257727,'AFTERNOON SHIFT','2022-04-29','2022-04-30 07:23:52','2022-05-01 07:23:52','248',1264330.00,1264330.00,'248','2022-04-30 15:51:51','648','2022-04-30 21:31:50',10,0),('1','64',257728,'MORNING SHIFT','2022-04-30','2022-05-01 08:50:15','2022-05-02 08:50:15','248',753095.00,753095.00,'248','2022-05-01 08:53:12','648','2022-05-01 09:39:39',10,0),('1','64',257729,'AFTERNOON SHIFT','2022-04-30','2022-05-01 14:09:47','2022-05-02 14:09:47','248',870710.00,870710.00,'248','2022-05-01 14:16:46','648','2022-05-02 17:49:06',10,0),('1','64',257730,'MORNING SHIFT','2022-05-01','2022-05-02 20:08:26','2022-05-03 20:08:26','248',599970.00,599970.00,'248','2022-05-02 20:11:44','648','2022-05-03 08:07:44',10,0),('1','64',257731,'AFTERNOON SHIFT','2022-05-01','2022-05-03 09:58:45','2022-05-04 09:58:45','248',749175.00,749175.00,'248','2022-05-03 10:12:27','648','2022-05-04 03:13:52',10,0),('1','64',257732,'MORNING SHIFT','2022-05-02','2022-05-04 09:05:45','2022-05-05 09:05:45','248',45045.00,45045.00,'248','2022-05-04 23:51:38','648','2022-05-05 10:17:35',10,0),('1','64',257733,'AFTERNOON SHIFT','2022-05-02','2022-05-05 11:26:59','2022-05-06 11:26:59','248',858880.00,858880.00,'248','2022-05-05 11:32:11','648','2022-05-05 11:55:59',10,0),('1','64',257734,'MORNING SHIFT','2022-05-03','2022-05-05 13:21:06','2022-05-06 13:21:06','248',553600.00,553600.00,'248','2022-05-05 13:45:11','648','2022-05-05 14:18:30',10,0),('1','64',257735,'MORNING SHIFT','2022-05-04','2022-05-05 15:58:54','2022-05-06 15:58:54','248',4219520.00,4219520.00,'248','2022-05-05 16:04:31','648','2022-05-05 18:44:58',10,0),('1','64',257736,'AFTERNOON SHIFT','2022-05-04','2022-05-06 09:40:45','2022-05-07 09:40:45','248',3456000.00,3456000.00,'248','2022-05-06 09:44:32','648','2022-05-06 10:06:09',10,0),('1','64',257737,'MORNING SHIFT','2022-05-05','2022-05-06 10:28:37','2022-05-07 10:28:37','248',110110.00,110110.00,'248','2022-05-06 10:30:27','648','2022-05-06 17:15:45',10,0),('1','64',257738,'AFTERNOON SHIFT','2022-05-05','2022-05-06 22:49:12','2022-05-07 22:49:12','248',2007040.00,2007040.00,'248','2022-05-06 22:56:58','648','2022-05-07 08:55:48',10,0),('1','64',257739,'PRICE CHANGE SHIFT','2022-05-05','2022-05-07 09:43:58','2022-05-08 09:43:58','248',1784970.00,1784970.00,'248','2022-05-07 09:55:32','648','2022-05-07 15:01:28',10,0),('1','64',257740,'MORNING SHIFT','2022-05-06','2022-05-08 01:29:21','2022-05-09 01:29:21','248',73920.00,73920.00,'248','2022-05-08 01:32:02','648','2022-05-08 10:12:27',10,0),('1','64',257741,'AFTERNOON SHIFT','2022-05-09','2022-05-10 09:21:27','2022-05-11 09:21:27','248',1260930.00,1260930.00,'248','2022-05-10 09:28:41','648','2022-05-10 12:40:58',10,0),('1','64',257742,'MORNING SHIFT','2022-05-10','2022-05-10 15:07:45','2022-05-11 15:07:45','248',660495.00,660495.00,'248','2022-05-10 15:16:10','648','2022-05-10 17:55:51',10,0),('1','64',257743,'AFTERNOON SHIFT','2022-05-10','2022-05-11 09:11:04','2022-05-12 09:11:04','248',1409760.00,1409760.00,'248','2022-05-11 09:16:25','648','2022-05-11 14:28:58',10,0),('1','64',257744,'MORNING SHIFT','2022-05-11','2022-05-11 15:30:24','2022-05-12 15:30:24','248',692175.00,692175.00,'248','2022-05-11 15:35:25','648','2022-05-12 09:39:23',10,0),('1','64',257745,'AFTERNOON SHIFT','2022-05-11','2022-05-12 10:09:36','2022-05-13 10:09:36','248',1088340.00,1088340.00,'248','2022-05-12 11:09:50','648','2022-05-12 17:19:32',10,0),('1','64',257746,'MORNING SHIFT','2022-05-12','2022-05-13 00:55:42','2022-05-14 00:55:42','248',534105.00,534105.00,'248','2022-05-13 01:03:51','648','2022-05-13 09:30:33',10,0),('1','64',257747,'AFTERNOON SHIFT','2022-05-12','2022-05-13 10:53:30','2022-05-14 10:53:30','248',4127145.00,4127145.00,'248','2022-05-13 10:59:48','648','2022-05-13 23:15:36',10,0),('1','64',257748,'MORNING SHIFT','2022-05-13','2022-05-14 01:32:05','2022-05-15 01:32:05','248',718245.00,718245.00,'248','2022-05-14 01:38:31','648','2022-05-14 07:55:13',10,0),('1','64',257749,'AFTERNOON SHIFT ','2022-05-13','2022-05-14 11:23:15','2022-05-15 11:23:15','248',429660.00,429660.00,'248','2022-05-14 11:26:14','648','2022-05-14 17:53:51',10,0),('1','64',257750,'PRICE CHANGE SHIFT','2022-05-13','2022-05-14 18:21:22','2022-05-15 18:21:22','248',461170.00,461170.00,'248','2022-05-16 08:58:34','648','2022-05-16 09:03:10',10,0),('1','64',257751,'MORNING SHIFT','2022-05-14','2022-05-16 09:07:40','2022-05-17 09:07:40','248',1230120.00,1230120.00,'248','2022-05-16 09:46:47','648','2022-05-16 15:04:08',10,0),('1','64',257752,'AFTERNOON SHIFT','2022-05-17','2022-05-18 12:16:16','2022-05-19 12:16:16','248',539715.00,539715.00,'248','2022-05-18 12:20:59','648','2022-05-18 16:30:20',10,0),('1','64',257753,'MORNING SHIFT','2022-05-18','2022-05-18 18:20:52','2022-05-19 18:20:52','248',576195.00,576195.00,'248','2022-05-18 18:44:32','648','2022-05-18 20:58:45',10,0),('1','64',257754,'AFTERNOON SHIFT','2022-05-18','2022-05-19 14:08:39','2022-05-20 14:08:39','248',1479885.00,1479885.00,'248','2022-05-19 19:43:27','648','2022-05-20 09:27:56',10,0),('1','64',257755,'MORNING SHIFT','2022-05-19','2022-05-20 10:05:41','2022-05-21 10:05:41','248',109065.00,109065.00,'248','2022-05-20 10:11:42','648','2022-05-20 14:30:24',10,0),('1','64',257756,'AFTERNOON SHIFT','2022-05-19','2022-05-20 17:34:29','2022-05-21 17:34:29','248',509190.00,509190.00,'248','2022-05-20 17:40:55','648','2022-05-21 09:49:46',10,0),('1','64',257757,'MORNING SHIFT','2022-05-20','2022-05-21 10:29:29','2022-05-22 10:29:29','248',241560.00,241560.00,'248','2022-05-21 11:50:30','648','2022-05-21 12:22:37',10,0),('1','64',257758,'MORNING SHIFT','2022-05-21','2022-05-21 18:48:57','2022-05-22 18:48:57','248',1061460.00,1061460.00,'248','2022-05-21 21:15:50','648','2022-05-22 09:47:50',10,0),('1','64',257759,'AFTERNOON SHIFT','2022-05-21','2022-05-22 12:56:05','2022-05-23 12:56:05','248',570735.00,570735.00,'248','2022-05-22 12:59:27','648','2022-05-22 16:25:36',10,0),('1','64',257760,'MORNING SHIFT','2022-05-22','2022-05-22 17:09:14','2022-05-23 17:09:14','248',543345.00,543345.00,'248','2022-05-22 17:12:13','648','2022-05-22 18:18:47',10,0),('1','64',257761,'AFTERNOON SHIFT','2022-05-22','2022-05-22 22:04:59','2022-05-23 22:04:59','248',860805.00,860805.00,'248','2022-05-23 09:02:05','648','2022-05-23 09:54:33',10,0),('1','64',257762,'MORNING SHIFT','2022-05-23','2022-05-23 14:24:02','2022-05-24 14:24:02','248',506550.00,506550.00,'248','2022-05-23 14:56:37','648','2022-05-23 19:25:19',10,0),('1','64',257763,'MORNING SHIFT','2022-05-23','2022-05-23 22:12:56','2022-05-24 22:12:56','248',1061115.00,1061115.00,'248','2022-05-23 22:14:28','648','2022-05-24 09:39:46',10,0),('1','64',257764,'MORNING SHIFT','2022-05-24','2022-05-24 11:18:46','2022-05-25 11:18:46','248',511665.00,511665.00,'248','2022-05-24 19:00:22','648','2022-05-25 13:21:23',10,0),('1','64',257765,'AFTERNOON SHIFT','2022-05-24','2022-05-25 13:43:19','2022-05-26 13:43:19','248',1039500.00,1039500.00,'248','2022-05-25 15:00:47','648','2022-05-25 16:34:52',10,0),('1','64',257766,'MORNING SHIFT','2022-05-25','2022-05-25 17:09:33','2022-05-26 17:09:33','248',595485.00,595485.00,'248','2022-05-25 17:14:09','648','2022-05-26 06:16:39',10,0),('1','64',257767,'AFTERNOON SHIFT ','2022-05-25','2022-05-26 10:14:20','2022-05-27 10:14:20','248',1880080.00,1880080.00,'248','2022-05-26 12:27:36','648','2022-05-26 14:19:02',10,0),('1','64',257768,'MORNING SHIFT','2022-05-26','2022-05-26 14:42:00','2022-05-27 14:42:00','248',123245.00,123245.00,'248','2022-05-27 10:34:40','648','2022-05-27 17:46:40',10,0),('1','64',257769,'AFTERNOON SHIFT','2022-05-26','2022-05-27 19:19:36','2022-05-28 19:19:36','248',460430.00,460430.00,'248','2022-05-27 19:23:21','648','2022-05-27 23:56:50',10,0),('1','64',257770,'MORNING SHIFT','2022-05-27','2022-05-28 10:09:31','2022-05-29 10:09:31','248',238170.00,238170.00,'248','2022-05-28 10:12:25','648','2022-05-28 22:02:59',10,0),('1','64',257771,'AFTERNOON SHIFT','2022-05-27','2022-05-29 10:44:36','2022-05-30 10:44:36','248',110960.00,110960.00,'248','2022-05-29 10:47:21','648','2022-05-29 13:10:29',10,0),('1','64',257772,'MORNING SHIFT','2022-05-28','2022-05-29 14:43:12','2022-05-30 14:43:12','248',56580.00,56580.00,'248','2022-05-29 14:49:24','648','2022-05-29 15:31:09',10,0),('1','64',257773,'AFTERNOON SHIFT','2022-05-28','2022-05-29 15:50:19','2022-05-30 15:50:19','248',753500.00,753500.00,'248','2022-05-29 15:53:10','648','2022-05-30 07:48:43',10,0),('1','64',257774,'MORNING SHIFT','2022-05-29','2022-05-30 09:33:52','2022-05-31 09:33:52','248',481550.00,481550.00,'248','2022-05-30 09:38:50','648','2022-05-30 11:24:22',10,0),('1','64',257775,'AFTERNOON SHIFT','2022-05-29','2022-05-30 16:20:30','2022-05-31 16:20:30','248',945995.00,945995.00,'248','2022-05-30 16:29:28','648','2022-05-30 17:30:05',10,0),('1','64',257776,'MORNING SHIFT','2022-05-30','2022-05-30 18:46:27','2022-05-31 18:46:27','248',496320.00,496320.00,'248','2022-05-31 10:06:14','648','2022-05-31 10:37:36',10,0),('1','64',257777,'AFTERNOON SHIFT','2022-05-30','2022-05-31 13:45:37','2022-06-01 13:45:37','248',940695.00,940695.00,'248','2022-05-31 14:27:17','648','2022-05-31 14:49:01',10,0),('1','64',257778,'MORNING SHIFT','2022-05-31','2022-05-31 17:56:19','2022-06-01 17:56:19','248',435435.00,435435.00,'248','2022-05-31 18:01:25','648','2022-05-31 22:14:39',10,0),('1','64',257779,'AFTERNOON SHIFT','2022-05-31','2022-05-31 22:17:50','2022-06-01 22:17:50','248',2514145.00,2514145.00,'248','2022-05-31 22:25:14','648','2022-05-31 22:34:24',10,0),('1','64',257780,'MORNING SHIFT','2022-06-01','2022-06-01 09:02:01','2022-06-02 09:02:01','248',783090.00,783090.00,'248','2022-06-01 22:15:27','648','2022-06-01 23:56:51',10,0),('1','64',257781,'AFTERNOON SHIFT','2022-06-01','2022-06-02 09:02:07','2022-06-03 09:02:07','248',3766730.00,3766730.00,'248','2022-06-02 09:14:53','648','2022-06-02 09:47:21',10,0),('1','64',257782,'MORNING SHIFT','2022-06-02','2022-06-02 11:06:28','2022-06-03 11:06:28','248',2064125.00,2064125.00,'248','2022-06-02 15:16:20','648','2022-06-02 16:35:18',10,0),('1','64',257783,'AFTERNOON SHIFT','2022-06-02','2022-06-02 21:35:14','2022-06-03 21:35:14','248',1128605.00,1128605.00,'248','2022-06-02 21:37:40','648','2022-06-03 08:14:32',10,0),('1','64',257784,'MORNING SHIFT','2022-06-03','2022-06-03 09:05:11','2022-06-04 09:05:11','248',1772645.00,1772645.00,'248','2022-06-03 14:56:59','648','2022-06-03 14:59:02',10,0),('1','64',257785,'AFTERNOON SHIFT','2022-06-03','2022-06-04 10:20:41','2022-06-05 10:20:41','248',1454090.00,1454090.00,'248','2022-06-04 11:32:18','648','2022-06-04 15:38:55',10,0),('1','64',257786,'MORNING SHIFT','2022-06-04','2022-06-04 22:38:47','2022-06-05 22:38:47','248',1483845.00,1483845.00,'248','2022-06-05 16:23:32','648','2022-06-05 19:42:58',10,0),('1','64',257787,'AFTERNOON SHIFT','2022-06-04','2022-06-05 21:03:38','2022-06-06 21:03:38','248',1043670.00,1043670.00,'248','2022-06-05 21:07:22','648','2022-06-06 06:26:44',10,0),('1','64',257788,'MORNING SHIFT','2022-06-05','2022-06-06 08:55:55','2022-06-07 08:55:55','248',672045.00,672045.00,'248','2022-06-06 09:06:48','648','2022-06-06 09:40:20',10,0),('1','64',257789,'AFTERNOON SHIFT','2022-06-05','2022-06-06 10:00:50','2022-06-07 10:00:50','248',646470.00,646470.00,'248','2022-06-06 10:04:48','648','2022-06-06 12:35:27',10,0),('1','64',257790,'MORNING SHIFT','2022-06-06','2022-06-06 13:57:58','2022-06-07 13:57:58','248',553080.00,553080.00,'248','2022-06-06 14:07:03','648','2022-06-06 16:20:48',10,0),('1','64',257791,'AFTERNOON SHIFT','2022-06-06','2022-06-06 21:43:28','2022-06-07 21:43:28','248',1091640.00,1091640.00,'248','2022-06-06 21:48:21','648','2022-06-07 05:55:03',10,0),('1','64',257792,'MORNING SHIFT','2022-06-07','2022-06-07 09:33:38','2022-06-08 09:33:38','248',443520.00,443520.00,'248','2022-06-07 16:24:47','648','2022-06-08 09:30:46',10,0),('1','64',257793,'MORNING SHIFT','2022-06-08','2022-06-08 12:55:50','2022-06-09 12:55:50','248',671220.00,671220.00,'248','2022-06-08 14:41:53','648','2022-06-09 08:54:05',10,0),('1','64',257794,'AFTERNOON SHIFT','2022-06-08','2022-06-09 08:58:11','2022-06-10 08:58:11','248',1087515.00,1087515.00,'248','2022-06-09 09:07:31','648','2022-06-09 09:44:19',10,0),('1','64',257795,'MORNING SHIFT','2022-06-09','2022-06-09 11:42:33','2022-06-10 11:42:33','248',538230.00,538230.00,'248','2022-06-09 13:47:45','648','2022-06-09 14:05:27',10,0),('1','64',257796,'AFTERNOON SHIFT ','2022-06-09','2022-06-09 20:24:50','2022-06-10 20:24:50','248',201630.00,201630.00,'248','2022-06-09 20:26:31','648','2022-06-09 21:28:18',10,0),('1','64',257797,'MORNING SHIFT','2022-06-12','2022-06-12 20:37:30','2022-06-13 20:37:30','248',280335.00,280335.00,'248','2022-06-12 20:40:27','648','2022-06-13 13:01:06',10,0),('1','64',257798,'AFTERNOON SHIFT','2022-06-12','2022-06-13 14:34:52','2022-06-14 14:34:52','248',0.00,0.00,'248','2022-06-13 19:41:52','648','2022-06-13 20:29:39',10,0),('1','64',257799,'AFTERNOON SHIFT','2022-06-12','2022-06-13 20:30:59','2022-06-14 20:30:59','248',676170.00,676170.00,'248','2022-06-13 20:36:19','648','2022-06-14 07:07:35',10,0),('1','64',257800,'MORNING SHIFT','2022-06-13','2022-06-14 07:54:46','2022-06-15 07:54:46','248',554895.00,554895.00,'248','2022-06-14 08:02:26','648','2022-06-14 09:17:36',10,0),('1','64',257801,'AFTERNOON SHIFT','2022-06-13','2022-06-14 11:16:08','2022-06-15 11:16:08','248',792495.00,792495.00,'248','2022-06-14 11:20:58','648','2022-06-14 13:13:34',10,0),('1','64',257802,'MORNING SHIFT','2022-06-14','2022-06-14 13:49:26','2022-06-15 13:49:26','248',697920.00,697920.00,'248','2022-06-14 14:26:47','648','2022-06-14 15:01:59',10,0),('1','64',257803,'AFTERNOON SHIFT','2022-06-14','2022-06-14 19:26:25','2022-06-15 19:26:25','248',989670.00,989670.00,'248','2022-06-14 21:39:13','648','2022-06-15 06:52:35',10,0),('1','64',257804,'MORNING SHIFT','2022-06-15','2022-06-15 11:23:41','2022-06-16 11:23:41','248',648450.00,648450.00,'248','2022-06-15 22:04:56','648','2022-06-16 09:16:34',10,0),('1','64',257805,'AFTERNOON SHIFT','2022-06-15','2022-06-16 12:09:01','2022-06-17 12:09:01','248',1032570.00,1032570.00,'248','2022-06-16 12:12:29','648','2022-06-16 15:59:13',10,0),('1','64',257806,'MORNING SHIFT ','2022-06-16','2022-06-16 18:37:08','2022-06-17 18:37:08','248',510180.00,510180.00,'248','2022-06-16 18:43:57','648','2022-06-17 09:25:50',10,0),('1','64',257807,'AFTERNOON SHIFT','2022-06-16','2022-06-17 09:47:08','2022-06-18 09:47:08','248',820050.00,820050.00,'248','2022-06-17 09:51:56','648','2022-06-17 10:09:55',10,0),('1','64',257808,'MORNING SHIFT','2022-06-17','2022-06-17 10:51:55','2022-06-18 10:51:55','248',612150.00,612150.00,'248','2022-06-18 10:36:22','648','2022-06-18 11:15:35',10,0),('1','64',257809,'AFTERNOON SHIFT','2022-06-17','2022-06-18 15:26:44','2022-06-19 15:26:44','248',1038840.00,1038840.00,'248','2022-06-18 15:29:21','648','2022-06-18 17:35:08',10,0),('1','64',257810,'MORNING SHIFT','2022-06-18','2022-06-18 19:38:18','2022-06-19 19:38:18','248',593505.00,593505.00,'248','2022-06-18 19:47:17','648','2022-06-19 00:19:37',10,0),('1','64',257811,'AFTERNOON SHIFT','2022-06-18','2022-06-19 09:39:30','2022-06-20 09:39:30','248',938355.00,938355.00,'248','2022-06-19 09:44:02','648','2022-06-19 11:18:02',10,0),('1','64',257812,'MORNING SHIFT','2022-06-19','2022-06-19 22:09:03','2022-06-20 22:09:03','248',797775.00,797775.00,'248','2022-06-19 22:42:44','648','2022-06-20 08:11:59',10,0),('1','64',257813,'AFTERNOON SHIFT','2022-06-19','2022-06-20 14:48:38','2022-06-21 14:48:38','248',503415.00,503415.00,'248','2022-06-20 15:25:13','648','2022-06-20 18:45:22',10,0),('1','64',257814,'MORNING SHIFT','2022-06-20','2022-06-20 21:58:32','2022-06-21 21:58:32','248',759225.00,759225.00,'248','2022-06-20 22:50:26','648','2022-06-21 08:52:15',10,0),('1','64',257815,'AFTERNOON SHIFT','2022-06-20','2022-06-21 10:29:17','2022-06-22 10:29:17','248',1668570.00,1668570.00,'248','2022-06-21 10:37:35','648','2022-06-21 13:31:52',10,0),('1','64',257816,'MORNING SHIFT','2022-06-21','2022-06-21 16:04:21','2022-06-22 16:04:21','248',1173255.00,1173255.00,'248','2022-06-21 16:20:30','648','2022-06-21 16:58:55',10,0),('1','64',257817,'AFTERNOON SHIFT','2022-06-21','2022-06-21 19:24:31','2022-06-22 19:24:31','248',1066540.00,1066540.00,'248','2022-06-22 12:36:29','648','2022-06-22 13:25:44',10,0),('1','64',257818,'MORNING SHIFT','2022-06-22','2022-06-22 18:40:23','2022-06-23 18:40:23','248',59200.00,59200.00,'248','2022-06-22 18:49:08','648','2022-06-23 08:08:23',10,0),('1','64',257819,'AFTERNOON SHIFT','2022-06-22','2022-06-23 16:10:34','2022-06-24 16:10:34','248',1609390.00,1609390.00,'248','2022-06-23 19:25:29','648','2022-06-24 10:36:00',10,0),('1','64',257820,'MORNING SHIFT','2022-06-23','2022-06-24 10:53:11','2022-06-25 10:53:11','248',965285.00,965285.00,'248','2022-06-24 10:56:55','648','2022-06-24 11:05:55',10,0),('1','64',257821,'AFTERNOON SHIFT','2022-06-23','2022-06-24 11:07:09','2022-06-25 11:07:09','248',1425100.00,1425100.00,'248','2022-06-24 11:11:26','648','2022-06-24 11:24:14',10,0),('1','64',257822,'MORNING SHIFT','2022-06-24','2022-06-24 12:54:39','2022-06-25 12:54:39','248',1050160.00,1050160.00,'248','2022-06-24 14:59:57','648','2022-06-24 15:06:22',10,0),('1','64',257823,'AFTERNOON SHIFT','2022-06-24','2022-06-24 16:25:35','2022-06-25 16:25:35','248',2254840.00,2254840.00,'248','2022-06-25 09:47:13','648','2022-06-25 10:19:40',10,0),('1','64',257824,'MORNING SHIFT','2022-06-25','2022-06-25 13:04:27','2022-06-26 13:04:27','248',1039550.00,1039550.00,'248','2022-06-25 14:46:36','648','2022-06-25 18:21:42',10,0),('1','64',257825,'AFTERNOON SHIFT','2022-06-25','2022-06-26 17:46:21','2022-06-27 17:46:21','248',1825200.00,1825200.00,'248','2022-06-26 18:02:24','648','2022-06-27 08:17:28',10,0),('1','64',257826,'MORNING SHIFT','2022-06-27','2022-06-27 21:15:11','2022-06-28 21:15:11','248',110400.00,110400.00,'248','2022-06-27 21:21:43','648','2022-06-27 21:34:54',10,0),('1','64',257827,'MORNING SHIFT','2022-06-28','2022-06-28 20:44:43','2022-06-29 20:44:43','248',409600.00,409600.00,'248','2022-06-28 20:50:21','648','2022-06-28 22:12:30',10,0),('1','64',257828,'MORNING SHIFT','2022-06-29','2022-06-29 18:26:33','2022-06-30 18:26:33','248',982070.00,982070.00,'248','2022-06-29 21:42:05','648','2022-06-30 10:44:14',10,0),('1','64',257829,'AFTERNOON SHIFT','2022-06-29','2022-06-30 13:35:49','2022-07-01 13:35:49','248',1375570.00,1375570.00,'248','2022-06-30 13:41:11','648','2022-06-30 17:10:46',10,0),('1','64',257830,'MORNING SHIFT','2022-06-30','2022-06-30 21:36:46','2022-07-01 21:36:46','248',953260.00,953260.00,'248','2022-06-30 21:50:25','648','2022-07-01 07:50:31',10,0),('1','64',257831,'AFTERNOON SHIFT','2022-06-30','2022-07-01 12:40:01','2022-07-02 12:40:01','248',1315625.00,1315625.00,'248','2022-07-01 12:47:06','648','2022-07-01 15:04:14',10,0),('1','64',257832,'MORNING SHIFT','2022-07-01','2022-07-01 17:41:03','2022-07-02 17:41:03','248',1358765.00,1358765.00,'248','2022-07-01 17:50:46','648','2022-07-02 00:59:31',10,0),('1','64',257833,'AFTERNOON SHIFT','2022-07-01','2022-07-02 10:08:37','2022-07-03 10:08:37','248',1184370.00,1184370.00,'248','2022-07-02 10:11:58','648','2022-07-02 11:36:17',10,0),('1','64',257834,'MORNING SHIFT','2022-07-03','2022-07-04 00:32:19','2022-07-05 00:32:19','248',534670.00,534670.00,'248','2022-07-04 00:35:20','648','2022-07-04 08:50:43',10,0),('1','64',257835,'AFTERNOON SHIFT','2022-07-03','2022-07-04 10:35:04','2022-07-05 10:35:04','248',103200.00,103200.00,'248','2022-07-04 10:36:00','648','2022-07-05 05:58:28',10,0),('1','64',257836,'MORNING SHIFT','2022-07-04','2022-07-05 12:07:03','2022-07-06 12:07:03','248',58400.00,58400.00,'248','2022-07-05 12:16:48','648','2022-07-06 02:01:17',10,0),('1','64',257837,'AFTERNOON SHIFT','2022-07-04','2022-07-06 10:07:15','2022-07-07 10:07:15','248',77600.00,77600.00,'248','2022-07-06 10:08:32','648','2022-07-06 11:03:45',10,0),('1','64',257838,'MORNING SHIFT','2022-07-06','2022-07-06 14:26:08','2022-07-07 14:26:08','248',248090.00,248090.00,'248','2022-07-06 14:36:06','648','2022-07-06 21:30:11',10,0),('1','64',257839,'AFTERNOON SHIFT','2022-07-07','2022-07-08 15:13:00','2022-07-09 15:13:00','248',185405.00,185405.00,'248','2022-07-08 15:18:15','648','2022-07-08 21:23:40',10,0),('1','64',257840,'MORNING SHIFT','2022-07-08','2022-07-09 19:07:59','2022-07-10 19:07:59','248',111200.00,111200.00,'248','2022-07-09 19:09:30','648','2022-07-10 13:42:53',10,0),('1','64',257841,'AFTERNOON SHIFT','2022-07-08','2022-07-10 22:22:36','2022-07-11 22:22:36','248',347200.00,347200.00,'248','2022-07-10 22:26:07','648','2022-07-11 08:17:26',10,0),('1','64',257842,'MORNING SHIFT','2022-07-09','2022-07-12 09:53:33','2022-07-13 09:53:33','248',513600.00,513600.00,'248','2022-07-12 09:54:55','648','2022-07-13 07:34:37',10,0),('1','64',257843,'MORNING SHIFT','2022-07-12','2022-07-14 01:19:36','2022-07-15 01:19:36','248',579200.00,579200.00,'248','2022-07-14 01:20:55','648','2022-07-15 09:44:14',10,0),('1','64',257844,'MORNING SHIFT','2022-07-13','2022-07-15 11:08:46','2022-07-16 11:08:46','248',84800.00,84800.00,'248','2022-07-15 11:09:51','648','2022-07-16 07:50:14',10,0),('1','64',257845,'AFTERNOON SHIFT','2022-07-13','2022-07-16 08:24:44','2022-07-17 08:24:44','248',52000.00,52000.00,'248','2022-07-16 08:25:34','648','2022-07-18 07:27:30',10,0),('1','64',257846,'MORNING SHIFT','2022-07-14','2022-07-18 09:30:33','2022-07-19 09:30:33','248',230400.00,230400.00,'248','2022-07-18 09:31:34','648','2022-07-20 04:18:03',10,0),('1','64',257847,'AFTERNOON SHIFT','2022-07-14','2022-07-20 08:07:08','2022-07-21 08:07:08','248',308000.00,308000.00,'248','2022-07-20 08:08:33','648','2022-07-20 10:05:09',10,0),('1','64',257848,'AFTERNOON SHIFT','2022-07-15','2022-07-20 12:15:26','2022-07-21 12:15:26','248',1304650.00,1304650.00,'248','2022-07-20 12:20:03','648','2022-07-20 16:17:11',10,0),('1','64',257849,'MORNING SHIFT','2022-07-16','2022-07-20 22:52:53','2022-07-21 22:52:53','248',1961800.00,1961800.00,'248','2022-07-20 22:57:30','648','2022-07-21 07:19:31',10,0),('1','64',257850,'AFTERNOON SHIFT','2022-07-16','2022-07-21 07:49:11','2022-07-22 07:49:11','248',1107175.00,1107175.00,'248','2022-07-21 07:53:09','648','2022-07-21 10:10:39',10,0),('1','64',257851,'MORNING SHIFT','2022-07-17','2022-07-21 11:09:08','2022-07-22 11:09:08','248',1181575.00,1181575.00,'248','2022-07-21 11:14:09','540','2022-07-21 11:14:38',10,0),('1','64',257852,'AFTERNOON SHIFT','2022-07-17','2022-07-21 11:17:07','2022-07-22 11:17:07','248',1155625.00,1155625.00,'248','2022-07-21 11:19:17','540','2022-07-21 11:20:52',10,0),('1','64',257853,'MORNING SHIFT','2022-07-18','2022-07-21 11:21:54','2022-07-22 11:21:54','248',1203975.00,1203975.00,'248','2022-07-21 11:23:41','540','2022-07-21 11:24:32',10,0),('1','64',257854,'AFTERNOON SHIFT','2022-07-18','2022-07-21 11:26:47','2022-07-22 11:26:47','248',1013725.00,1013725.00,'248','2022-07-21 11:28:32','540','2022-07-21 11:28:53',10,0),('1','64',257855,'MORNING SHIFT','2022-07-19','2022-07-21 11:30:03','2022-07-22 11:30:03','248',395200.00,395200.00,'248','2022-07-21 11:31:13','540','2022-07-21 11:32:49',10,0),('1','64',257856,'AFTERNOON SHIFT','2022-07-19','2022-07-21 11:36:30','2022-07-22 11:36:30','248',1375125.00,1375125.00,'248','2022-07-21 11:39:09','540','2022-07-21 11:41:06',10,0),('1','64',257857,'MORNING SHIFT','2022-07-20','2022-07-21 11:42:34','2022-07-22 11:42:34','248',915425.00,915425.00,'248','2022-07-21 11:59:46','540','2022-07-21 12:02:39',10,0),('1','64',257858,'AFTERNOON SHIFT','2022-07-20','2022-07-21 12:04:15','2022-07-22 12:04:15','248',1780075.00,1780075.00,'248','2022-07-21 12:08:16','540','2022-07-21 12:12:35',10,0),('1','64',257859,'MORNING SHIFT','2022-07-21','2022-07-21 20:03:26','2022-07-22 20:03:26','248',802575.00,802575.00,'248','2022-07-21 20:08:16','648','2022-07-22 08:12:35',10,0),('1','64',257860,'AFTERNOON SHIFT','2022-07-21','2022-07-22 09:07:22','2022-07-23 09:07:22','248',1108100.00,1108100.00,'248','2022-07-22 12:00:52','648','2022-07-22 15:59:19',10,0),('1','64',257861,'MORNING SHIFT','2022-07-22','2022-07-22 18:59:54','2022-07-23 18:59:54','248',23200.00,23200.00,'248','2022-07-22 19:01:00','648','2022-07-23 06:34:01',10,0),('1','64',257862,'PRICE CHANGE SHIFT','2022-07-22','2022-07-23 09:31:36','2022-07-24 09:31:36','248',1024660.00,1024660.00,'248','2022-07-23 09:34:58','648','2022-07-23 10:52:17',10,0),('1','64',257863,'AFTERNOON SHIFT','2022-07-22','2022-07-23 12:08:19','2022-07-24 12:08:19','248',1342980.00,1342980.00,'248','2022-07-23 12:13:33','648','2022-07-23 16:05:09',10,0),('1','64',257864,'MORNING SHIFT','2022-07-23','2022-07-24 09:49:38','2022-07-25 09:49:38','248',966300.00,966300.00,'248','2022-07-24 09:54:18','648','2022-07-24 09:56:17',10,0),('1','64',257865,'AFTERNOON SHIFT','2022-07-23','2022-07-24 10:23:13','2022-07-25 10:23:13','248',1400000.00,1400000.00,'248','2022-07-24 10:26:35','648','2022-07-24 15:02:15',10,0),('1','64',257866,'MORNING SHIFT','2022-07-24','2022-07-24 21:33:53','2022-07-25 21:33:53','248',886445.00,886445.00,'248','2022-07-24 21:37:51','648','2022-07-25 07:53:46',10,0),('1','64',257867,'AFTERNOON SHIFT','2022-07-24','2022-07-25 10:17:17','2022-07-26 10:17:17','248',1161790.00,1161790.00,'248','2022-07-25 14:59:58','648','2022-07-26 07:18:18',10,0),('1','64',257868,'MORNING SHIFT','2022-07-25','2022-07-26 10:08:30','2022-07-27 10:08:30','248',1019585.00,1019585.00,'248','2022-07-26 10:13:30','648','2022-07-26 10:21:08',10,0),('1','64',257869,'AFTERNOON SHIFT','2022-07-25','2022-07-26 15:49:46','2022-07-27 15:49:46','248',1228885.00,1228885.00,'248','2022-07-26 15:54:50','648','2022-07-27 09:04:12',10,0),('1','64',257870,'MORNING SHIFT','2022-07-26','2022-07-27 09:14:00','2022-07-28 09:14:00','248',986580.00,986580.00,'248','2022-07-27 09:17:31','648','2022-07-27 11:53:50',10,0),('1','64',257871,'AFTERNOON SHIFT','2022-07-26','2022-07-27 12:42:09','2022-07-28 12:42:09','248',1352050.00,1352050.00,'248','2022-07-27 12:58:23','648','2022-07-27 15:54:39',10,0),('1','64',257872,'MORNING SHIFT','2022-07-27','2022-07-27 17:45:17','2022-07-28 17:45:17','248',385525.00,385525.00,'248','2022-07-27 17:47:48','648','2022-07-28 07:51:47',10,0),('1','64',257873,'PRICE CHANGE SHIFT','2022-07-27','2022-07-28 10:20:38','2022-07-29 10:20:38','248',709800.00,709800.00,'248','2022-07-28 10:23:27','648','2022-07-28 14:45:59',10,0),('1','64',257874,'AFTERNOON SHIFT','2022-07-27','2022-07-28 15:01:43','2022-07-29 15:01:43','248',1326920.00,1326920.00,'248','2022-07-28 15:13:49','648','2022-07-28 15:43:55',10,0),('1','64',257875,'MORNING SHIFT','2022-07-28','2022-07-28 21:51:59','2022-07-29 21:51:59','248',857020.00,857020.00,'248','2022-07-28 22:06:56','648','2022-07-29 08:10:07',10,0),('1','64',257876,'AFTERNOON SHIFT','2022-07-28','2022-07-29 15:34:44','2022-07-30 15:34:44','248',920740.00,920740.00,'248','2022-07-29 15:37:19','648','2022-07-29 15:58:11',10,0),('1','64',257877,'MORNING SHIFT','2022-07-29','2022-07-29 20:34:05','2022-07-30 20:34:05','248',83930.00,83930.00,'248','2022-07-29 20:57:32','648','2022-07-30 05:58:10',10,0),('1','64',257878,'AFTERNOON SHIFT','2022-07-29','2022-07-30 11:11:40','2022-07-31 11:11:40','248',1600730.00,1600730.00,'248','2022-07-30 13:47:39','648','2022-07-30 13:58:30',10,0),('1','64',257879,'MORNING SHIFT','2022-07-30','2022-07-30 19:24:14','2022-07-31 19:24:14','248',2758960.00,2758960.00,'248','2022-07-30 19:45:51','648','2022-07-31 10:00:12',10,0),('1','64',257880,'AFTERNOON SHIFT','2022-07-30','2022-07-31 10:13:36','2022-08-01 10:13:36','248',1179850.00,1179850.00,'248','2022-07-31 10:18:25','648','2022-07-31 14:09:16',10,0),('1','64',257881,'MORNING SHIFT','2022-07-31','2022-07-31 14:36:40','2022-08-01 14:36:40','248',934020.00,934020.00,'248','2022-07-31 15:27:37','648','2022-07-31 15:31:08',10,0),('1','64',257882,'AFTERNOON SHIFT','2022-07-31','2022-07-31 22:38:16','2022-08-01 22:38:16','248',1004100.00,1004100.00,'248','2022-07-31 22:40:39','648','2022-07-31 23:05:26',10,0),('1','64',257883,'MORNING SHIFT','2022-08-01','2022-08-01 11:57:58','2022-08-02 11:57:58','248',753820.00,753820.00,'248','2022-08-01 15:28:50','648','2022-08-02 05:49:46',10,0),('1','64',257884,'AFTERNOON SHIFT','2022-08-01','2022-08-02 11:00:23','2022-08-03 11:00:23','248',1453050.00,1453050.00,'248','2022-08-02 11:08:48','648','2022-08-02 14:47:00',10,0),('1','64',257885,'MORNING SHIFT','2022-08-02','2022-08-02 20:26:17','2022-08-03 20:26:17','248',1116340.00,1116340.00,'248','2022-08-02 20:47:02','648','2022-08-03 06:56:58',10,0),('1','64',257886,'AFTERNOON SHIFT','2022-08-02','2022-08-03 21:10:08','2022-08-04 21:10:08','248',999960.00,999960.00,'248','2022-08-03 21:28:31','648','2022-08-04 06:05:02',10,0),('1','64',257887,'MORNING SHIFT','2022-08-05','2022-08-06 21:27:16','2022-08-07 21:27:16','248',8563170.00,8563170.00,'248','2022-08-06 21:35:10','648','2022-08-07 09:40:48',10,0),('1','64',257888,'MORNING SHIFT','2022-08-06','2022-08-07 20:34:59','2022-08-08 20:34:59','248',91630.00,91630.00,'248','2022-08-07 20:35:49','648','2022-08-08 09:20:44',10,0),('1','64',257889,'MORNING SHIFT','2022-08-07','2022-08-09 18:45:34','2022-08-10 18:45:34','248',103180.00,103180.00,'248','2022-08-09 18:47:03','648','2022-08-09 22:55:24',10,0),('1','64',257890,'AFTERNOON SHIFT','2022-08-07','2022-08-10 10:31:20','2022-08-11 10:31:20','248',50050.00,50050.00,'248','2022-08-10 10:32:13','648','2022-08-10 10:50:59',10,0),('1','64',257891,'MORNING SHIFT','2022-08-08','2022-08-10 19:42:09','2022-08-11 19:42:09','248',606760.00,606760.00,'248','2022-08-10 19:45:21','648','2022-08-11 06:31:55',10,0),('1','64',257892,'AFTERNOON SHIFT','2022-08-08','2022-08-11 10:34:14','2022-08-12 10:34:14','248',348810.00,348810.00,'248','2022-08-11 10:38:21','648','2022-08-11 19:53:08',10,0),('1','64',257893,'MORNING SHIFT','2022-08-09','2022-08-12 02:23:54','2022-08-13 02:23:54','248',104720.00,104720.00,'248','2022-08-12 02:24:35','648','2022-08-12 08:28:24',10,0),('1','64',257894,'AFTERNOON SHIFT','2022-08-09','2022-08-12 09:53:02','2022-08-13 09:53:02','248',649110.00,649110.00,'248','2022-08-12 09:53:59','648','2022-08-13 06:18:51',10,0),('1','64',257895,'MORNING SHIFT','2022-08-10','2022-08-13 10:05:08','2022-08-14 10:05:08','248',200200.00,200200.00,'248','2022-08-13 10:05:54','648','2022-08-13 10:13:26',10,0),('1','64',257896,'AFTERNOON SHIFT','2022-08-10','2022-08-13 12:17:00','2022-08-14 12:17:00','248',1339670.00,1339670.00,'248','2022-08-13 15:10:41','648','2022-08-13 18:11:23',10,0),('1','64',257897,'MORNING SHIFT','2022-08-11','2022-08-13 20:25:14','2022-08-14 20:25:14','248',949480.00,949480.00,'248','2022-08-13 20:30:16','648','2022-08-14 11:38:03',10,0),('1','64',257898,'AFTERNOON SHIFT','2022-08-11','2022-08-14 12:26:07','2022-08-15 12:26:07','248',1501440.00,1501440.00,'248','2022-08-14 12:33:31','648','2022-08-14 17:22:14',10,0),('1','64',257899,'MORNING SHIFT','2022-08-12','2022-08-14 19:21:55','2022-08-15 19:21:55','248',802960.00,802960.00,'248','2022-08-14 19:29:36','648','2022-08-15 09:49:29',10,0),('1','64',257900,'AFTERNOON SHIFT','2022-08-12','2022-08-15 10:04:12','2022-08-16 10:04:12','248',1375880.00,1375880.00,'248','2022-08-15 10:26:08','540','2022-08-15 11:29:34',10,0),('1','64',257901,'MORNING SHIFT','2022-08-13','2022-08-15 11:32:38','2022-08-16 11:32:38','248',691170.00,691170.00,'248','2022-08-15 11:36:09','540','2022-08-15 12:47:05',10,0),('1','64',257902,'AFTERNOON SHIFT','2022-08-13','2022-08-15 12:48:38','2022-08-16 12:48:38','248',701130.00,701130.00,'248','2022-08-15 12:51:34','540','2022-08-15 13:57:35',10,0),('1','64',257903,'MORNING SHIFT','2022-08-14','2022-08-15 14:05:20','2022-08-16 14:05:20','248',711640.00,711640.00,'248','2022-08-15 14:07:32','648','2022-08-15 18:33:23',10,0),('1','64',257904,'AFTERNOON SHIFT','2022-08-14','2022-08-16 11:06:24','2022-08-17 11:06:24','248',810350.00,810350.00,'248','2022-08-16 11:08:56','540','2022-08-16 11:55:39',10,0),('1','64',257905,'MORNING SHIFT','2022-08-15','2022-08-16 20:39:39','2022-08-17 20:39:39','248',807270.00,807270.00,'248','2022-08-16 20:50:33','648','2022-08-16 21:36:42',10,0),('1','64',257906,'AFTERNOON SHIFT','2022-08-15','2022-08-17 17:34:24','2022-08-18 17:34:24','248',275220.00,275220.00,'248','2022-08-17 17:39:53','648','2022-08-17 17:42:11',10,0),('1','64',257907,'MORNING SHIFT','2022-08-16','2022-08-18 01:26:06','2022-08-19 01:26:06','248',240240.00,240240.00,'248','2022-08-18 01:27:36','540','2022-08-18 10:12:56',10,0),('1','64',257908,'AFTERNOON SHIFT','2022-08-16','2022-08-18 11:19:40','2022-08-19 11:19:40','248',88550.00,88550.00,'248','2022-08-18 11:21:47','540','2022-08-18 11:51:23',10,0),('1','64',257909,'AFTERNOON SHIFT','2022-08-17','2022-08-18 20:52:55','2022-08-19 20:52:55','248',355740.00,355740.00,'248','2022-08-18 21:12:44','648','2022-08-18 22:52:42',10,0),('1','64',257910,'MORNING SHIFT','2022-08-18','2022-08-19 08:05:43','2022-08-20 08:05:43','248',681720.00,681720.00,'248','2022-08-19 08:09:40','648','2022-08-19 08:42:02',10,0),('1','64',257911,'AFTERNOON SHIFT','2022-08-18','2022-08-19 09:40:17','2022-08-20 09:40:17','248',437760.00,437760.00,'248','2022-08-19 09:41:50','648','2022-08-19 12:01:23',10,0),('1','64',257912,'MORNING SHIFT','2022-08-19','2022-08-19 21:55:24','2022-08-20 21:55:24','248',1447800.00,1447800.00,'248','2022-08-20 11:38:16','648','2022-08-20 17:01:30',10,0),('1','64',257913,'AFTERNOON SHIFT','2022-08-19','2022-08-20 17:34:45','2022-08-21 17:34:45','248',932060.00,932060.00,'248','2022-08-20 17:40:27','648','2022-08-20 23:18:53',10,0),('1','64',257914,'MORNING SHIFT','2022-08-20','2022-08-21 19:19:32','2022-08-22 19:19:32','248',792100.00,792100.00,'248','2022-08-21 19:22:43','648','2022-08-22 09:29:55',10,0),('1','64',257915,'AFTERNOON SHIFT','2022-08-20','2022-08-22 10:27:51','2022-08-23 10:27:51','248',955540.00,955540.00,'248','2022-08-22 10:34:17','648','2022-08-22 12:33:51',10,0),('1','64',257916,'MORNING SHIFT','2022-08-21','2022-08-22 13:17:54','2022-08-23 13:17:54','248',721580.00,721580.00,'248','2022-08-22 13:22:24','648','2022-08-22 14:19:18',10,0),('1','64',257917,'AFTERNOON SHIFT','2022-08-21','2022-08-22 14:23:27','2022-08-23 14:23:27','248',856640.00,856640.00,'248','2022-08-22 14:27:17','648','2022-08-23 06:09:24',10,0),('1','64',257918,'MORNING SHIFT','2022-08-22','2022-08-23 08:31:56','2022-08-24 08:31:56','248',709060.00,709060.00,'248','2022-08-23 08:37:00','648','2022-08-23 09:33:26',10,0),('1','64',257919,'AFTERNOON SHIFT','2022-08-22','2022-08-23 10:23:43','2022-08-24 10:23:43','248',1161400.00,1161400.00,'248','2022-08-23 10:27:36','648','2022-08-23 18:12:59',10,0),('1','64',257920,'MORNING SHIFT','2022-08-23','2022-08-23 21:19:42','2022-08-24 21:19:42','248',917820.00,917820.00,'248','2022-08-23 21:22:41','648','2022-08-24 08:32:44',10,0),('1','64',257921,'AFTERNOON SHIFT','2022-08-23','2022-08-24 15:19:46','2022-08-25 15:19:46','248',1026900.00,1026900.00,'248','2022-08-24 15:22:14','648','2022-08-24 19:45:48',10,0),('1','64',257922,'MORNING SHIFT ','2022-08-24','2022-08-25 08:47:32','2022-08-26 08:47:32','248',869000.00,869000.00,'248','2022-08-25 08:53:48','648','2022-08-25 09:14:49',10,0),('1','64',257923,'AFTERNOON SHIFT','2022-08-24','2022-08-25 15:00:33','2022-08-26 15:00:33','248',1238800.00,1238800.00,'248','2022-08-25 21:40:39','648','2022-08-26 08:07:49',10,0),('1','64',257924,'MORNING SHIFT','2022-08-25','2022-08-26 10:55:19','2022-08-27 10:55:19','248',912420.00,912420.00,'248','2022-08-26 11:03:13','648','2022-08-26 15:51:19',10,0),('1','64',257925,'AFTERNOON SHIFT','2022-08-25','2022-08-26 16:40:55','2022-08-27 16:40:55','248',1078600.00,1078600.00,'248','2022-08-26 16:54:37','648','2022-08-27 06:22:18',10,0),('1','64',257926,'MORNING SHIFT','2022-08-26','2022-08-27 13:20:18','2022-08-28 13:20:18','248',998980.00,998980.00,'248','2022-08-27 13:27:41','648','2022-08-27 16:00:32',10,0),('1','64',257927,'AFTERNOON SHIFT','2022-08-26','2022-08-27 20:35:13','2022-08-28 20:35:13','248',1165460.00,1165460.00,'248','2022-08-27 20:44:01','648','2022-08-28 07:25:22',10,0),('1','64',257928,'MORNING SHIFT','2022-08-27','2022-08-28 10:48:08','2022-08-29 10:48:08','248',992080.00,992080.00,'248','2022-08-28 10:53:07','648','2022-08-28 11:46:13',10,0),('1','64',257929,'AFTERNOON SHIFT','2022-08-27','2022-08-28 16:12:53','2022-08-29 16:12:53','248',1132060.00,1132060.00,'248','2022-08-28 16:27:46','648','2022-08-28 16:36:44',10,0),('1','64',257930,'MORNING SHIFT','2022-08-28','2022-08-29 01:48:39','2022-08-30 01:48:39','248',757700.00,757700.00,'248','2022-08-29 02:28:24','648','2022-08-29 08:23:44',10,0),('1','64',257931,'AFTERNOON SHIFT','2022-08-28','2022-08-29 18:34:09','2022-08-30 18:34:09','248',920160.00,920160.00,'248','2022-08-29 18:39:47','648','2022-08-30 06:20:00',10,0),('1','64',257932,'MORNING SHIFT','2022-08-29','2022-08-30 08:14:00','2022-08-31 08:14:00','248',783540.00,783540.00,'248','2022-08-30 08:19:13','648','2022-08-30 13:35:40',10,0),('1','64',257933,'AFTERNOON SHIFT','2022-08-29','2022-08-30 15:59:13','2022-08-31 15:59:13','248',995220.00,995220.00,'248','2022-08-30 16:09:36','648','2022-08-30 16:39:22',10,0),('1','64',257934,'MORNING SHIFT','2022-08-30','2022-08-31 11:38:56','2022-09-01 11:38:56','248',573480.00,573480.00,'248','2022-08-31 11:40:45','648','2022-08-31 12:29:20',10,0),('1','64',257935,'AFTERNOON SHIFT','2022-08-30','2022-08-31 12:48:08','2022-09-01 12:48:08','248',1472260.00,1472260.00,'248','2022-08-31 12:49:54','648','2022-08-31 13:02:37',10,0),('1','64',257936,'MORNING SHIFT','2022-08-31','2022-08-31 16:44:56','2022-09-01 16:44:56','248',737800.00,737800.00,'248','2022-08-31 17:14:29','648','2022-09-01 09:00:13',10,0),('1','64',257937,'AFTERNOON SHIFT','2022-08-31','2022-09-01 12:51:14','2022-09-02 12:51:14','248',1156040.00,1156040.00,'248','2022-09-01 20:07:56','648','2022-09-01 20:41:21',10,0),('1','64',257938,'MORNING','2022-09-01','2022-09-01 21:07:42','2022-09-02 21:07:42','248',210680.00,210680.00,'248','2022-09-01 21:11:51','648','2022-09-01 21:13:17',10,0),('1','64',257939,'AFTERNOON','2022-09-01','2022-09-01 21:40:32','2022-09-02 21:40:32','248',536040.00,536040.00,'248','2022-09-02 07:06:29','648','2022-09-02 10:30:20',10,0),('1','64',257940,'MOORNING','2022-09-02','2022-09-02 11:33:27','2022-09-03 11:33:27','248',860340.20,860340.20,'248','2022-09-02 15:14:04','648','2022-09-02 16:03:37',10,0),('1','64',257941,'AFTERNOON ','2022-09-02','2022-09-02 17:18:23','2022-09-03 17:18:23','248',1304200.00,1304200.00,'248','2022-09-02 22:06:14','648','2022-09-03 10:55:55',10,0),('1','64',257942,'MOORNING ','2022-09-03','2022-09-03 13:36:15','2022-09-04 13:36:15','248',999040.00,999040.00,'248','2022-09-03 14:15:34','648','2022-09-03 23:25:05',10,0),('1','64',257943,'AFTERNOON','2022-09-04','2022-09-04 07:39:38','2022-09-05 07:39:38','248',1299440.00,1299440.00,'248','2022-09-04 08:03:01','648','2022-09-04 08:13:27',10,0),('1','64',257944,'MOORNING ','2022-09-04','2022-09-04 10:10:33','2022-09-05 10:10:33','248',327600.00,327600.00,'248','2022-09-04 14:04:44','648','2022-09-04 18:19:14',10,0),('1','64',257945,'AFTERNOON','2022-09-04','2022-09-04 22:28:55','2022-09-05 22:28:55','248',114760.00,114760.00,'248','2022-09-04 22:30:17','648','2022-09-05 08:52:13',10,0),('1','64',257946,'MOORNING ','2022-09-05','2022-09-05 10:55:35','2022-09-06 10:55:35','248',191520.00,191520.00,'248','2022-09-05 13:50:24','648','2022-09-05 18:46:30',10,0),('1','64',257947,'AFTERNOON','2022-09-05','2022-09-05 19:03:35','2022-09-06 19:03:35','248',135280.00,135280.00,'248','2022-09-05 21:49:21','648','2022-09-06 11:18:18',10,0),('1','64',257948,'MORNING','2022-09-06','2022-09-06 12:03:28','2022-09-07 12:03:28','248',166440.00,166440.00,'248','2022-09-06 13:34:00','648','2022-09-06 16:02:55',10,0),('1','64',257949,'AFTERNOON','2022-09-06','2022-09-07 07:55:13','2022-09-08 07:55:13','248',193800.00,193800.00,'248','2022-09-07 07:58:21','648','2022-09-07 08:02:24',10,0),('1','64',257950,'MOORNING ','2022-09-07','2022-09-07 11:59:58','2022-09-08 11:59:58','248',161120.00,161120.00,'248','2022-09-07 13:33:24','648','2022-09-07 19:04:55',10,0),('1','64',257951,'AFTERNOON','2022-09-07','2022-09-07 21:39:40','2022-09-08 21:39:40','248',718944.80,718944.80,'248','2022-09-07 21:43:05','648','2022-09-08 08:59:21',10,0),('1','64',257952,'MOORNING ','2022-09-08','2022-09-08 09:42:29','2022-09-09 09:42:29','248',272080.00,272080.00,'248','2022-09-08 13:45:25','648','2022-09-08 23:07:16',10,0),('1','64',257953,'AFTERNOON','2022-09-09','2022-09-09 04:05:59','2022-09-10 04:05:59','248',304760.00,304760.00,'248','2022-09-09 04:09:51','648','2022-09-09 11:40:44',10,0),('1','64',257954,'MOORNING ','2022-09-09','2022-09-09 13:31:02','2022-09-10 13:31:02','248',380000.00,380000.00,'248','2022-09-09 13:32:54','648','2022-09-09 15:42:03',10,0),('1','64',257955,'AFTERNOON ','2022-09-09','2022-09-09 17:33:17','2022-09-10 17:33:17','248',264920.80,264920.80,'248','2022-09-09 21:16:47','648','2022-09-10 10:49:36',10,0),('1','64',257956,'MORNING','2022-09-10','2022-09-10 12:28:43','2022-09-11 12:28:43','248',819280.00,819280.00,'248','2022-09-10 13:31:01','648','2022-09-10 15:20:46',10,0),('1','64',257957,'AFTERNOON','2022-09-10','2022-09-10 20:43:05','2022-09-11 20:43:05','248',309320.00,309320.00,'248','2022-09-11 06:55:09','648','2022-09-11 11:02:14',10,0),('1','64',257958,'MORNING','2022-09-11','2022-09-11 13:36:35','2022-09-12 13:36:35','248',30400.00,30400.00,'248','2022-09-11 13:37:11','648','2022-09-11 16:21:57',10,0),('1','64',257959,'AFTERNOON ','2022-09-11','2022-09-11 19:18:19','2022-09-12 19:18:19','248',152760.00,152760.00,'248','2022-09-11 22:14:17','648','2022-09-12 07:25:00',10,0),('1','64',257960,'MOORNING ','2022-09-12','2022-09-12 09:46:47','2022-09-13 09:46:47','248',303880.00,303880.00,'248','2022-09-12 14:08:25','648','2022-09-12 14:18:21',10,0),('1','64',257961,'AFTERNOON','2022-09-12','2022-09-12 19:28:13','2022-09-13 19:28:13','248',216600.00,216600.00,'248','2022-09-12 21:48:11','648','2022-09-13 08:38:45',10,0),('1','64',257962,'MOORNING ','2022-09-13','2022-09-13 08:48:01','2022-09-14 08:48:01','248',887000.00,887000.00,'248','2022-09-13 14:15:25','648','2022-09-13 15:00:15',10,0),('1','64',257963,'AFTERNOON ','2022-09-13','2022-09-13 18:56:08','2022-09-14 18:56:08','248',941260.00,941260.00,'248','2022-09-13 21:05:49','648','2022-09-13 22:48:33',10,0),('1','64',257964,'MOORNING ','2022-09-14','2022-09-14 09:20:42','2022-09-15 09:20:42','248',979280.00,979280.00,'248','2022-09-14 14:11:25','648','2022-09-14 14:14:08',10,0),('1','64',257965,'AFTERNOON ','2022-09-14','2022-09-14 14:15:39','2022-09-15 14:15:39','248',1396200.00,1396200.00,'248','2022-09-14 21:47:24','648','2022-09-14 22:23:23',10,0),('1','64',257966,'MORNING','2022-09-15','2022-09-15 08:14:26','2022-09-16 08:14:26','248',1683380.20,1683380.20,'248','2022-09-15 14:31:17','648','2022-09-15 14:45:06',10,0),('1','64',257967,'AFTERNOON ','2022-09-15','2022-09-15 15:00:38','2022-09-16 15:00:38','248',1260600.00,1260600.00,'248','2022-09-15 22:50:44','648','2022-09-16 08:40:30',10,0),('1','64',257968,'MOORNING ','2022-09-16','2022-09-16 10:52:45','2022-09-17 10:52:45','248',969540.00,969540.00,'248','2022-09-16 13:56:30','648','2022-09-16 16:46:01',10,0),('1','64',257969,'AFTERNOON','2022-09-16','2022-09-17 07:37:47','2022-09-18 07:37:47','248',1340920.00,1340920.00,'248','2022-09-17 07:40:30','648','2022-09-17 09:34:27',10,0),('1','64',257970,'MOORNING ','2022-09-17','2022-09-17 10:01:08','2022-09-18 10:01:08','248',989021.60,989021.60,'248','2022-09-17 14:17:53','648','2022-09-17 18:35:41',10,0),('1','64',257971,'AFTERNOON','2022-09-17','2022-09-17 22:57:52','2022-09-18 22:57:52','248',1546680.00,1546680.00,'248','2022-09-17 23:01:18','648','2022-09-18 06:50:20',10,0),('1','64',257972,'MORNING','2022-09-18','2022-09-18 10:02:08','2022-09-19 10:02:08','248',843040.00,843040.00,'248','2022-09-18 14:02:09','648','2022-09-18 15:27:28',10,0),('1','64',257973,'AFTERNOON','2022-09-18','2022-09-19 09:07:49','2022-09-20 09:07:49','248',804420.00,804420.00,'248','2022-09-19 09:09:13','648','2022-09-19 09:25:51',10,0),('1','64',257974,'MORNING','2022-09-19','2022-09-19 13:32:53','2022-09-20 13:32:53','248',1012420.00,1012420.00,'248','2022-09-19 13:34:20','648','2022-09-19 15:51:05',10,0),('1','64',257975,'AFTERNOON','2022-09-19','2022-09-19 21:45:00','2022-09-20 21:45:00','248',2107640.00,2107640.00,'248','2022-09-19 21:48:34','648','2022-09-20 12:43:54',10,0),('1','64',257976,'MORNING','2022-09-20','2022-09-20 14:30:55','2022-09-21 14:30:55','248',1145800.00,1145800.00,'248','2022-09-20 14:34:16','648','2022-09-20 15:29:18',10,0),('1','64',257977,'AFTERNOON','2022-09-20','2022-09-20 21:43:43','2022-09-21 21:43:43','248',1251320.00,1251320.00,'248','2022-09-20 21:46:15','648','2022-09-21 08:48:13',10,0),('1','64',257978,'MOORNING ','2022-09-21','2022-09-21 09:08:15','2022-09-22 09:08:15','248',617120.00,617120.00,'248','2022-09-21 14:06:31','648','2022-09-21 20:28:41',10,0),('1','64',257979,'AFTERNOON','2022-09-21','2022-09-22 07:34:04','2022-09-23 07:34:04','248',1071660.00,1071660.00,'248','2022-09-22 07:35:53','648','2022-09-22 09:02:46',10,0),('1','64',257980,'MOORNING ','2022-09-22','2022-09-22 09:37:14','2022-09-23 09:37:14','248',935440.20,935440.20,'248','2022-09-22 13:59:26','648','2022-09-22 18:02:52',10,0),('1','64',257981,'AFTERNOON','2022-09-22','2022-09-22 21:52:22','2022-09-23 21:52:22','248',1093480.00,1093480.00,'248','2022-09-22 21:54:05','648','2022-09-23 08:45:49',10,0),('1','64',257982,'MOORNING ','2022-09-23','2022-09-23 13:36:31','2022-09-24 13:36:31','248',950340.00,950340.00,'248','2022-09-23 13:38:01','648','2022-09-23 16:57:48',10,0),('1','64',257983,'AFTERNOON','2022-09-23','2022-09-23 21:37:49','2022-09-24 21:37:49','248',1147900.00,1147900.00,'248','2022-09-23 21:40:48','648','2022-09-24 11:05:29',10,0),('1','64',257984,'MOORNING ','2022-09-24','2022-09-24 14:01:39','2022-09-25 14:01:39','248',1003760.00,1003760.00,'248','2022-09-24 14:03:41','648','2022-09-24 14:48:23',10,0),('1','64',257985,'AFTERNOON','2022-09-24','2022-09-24 21:35:20','2022-09-25 21:35:20','248',1483640.00,1483640.00,'248','2022-09-24 21:37:23','648','2022-09-25 09:56:49',10,0),('1','64',257986,'MOORNING ','2022-09-25','2022-09-25 10:28:46','2022-09-26 10:28:46','248',937860.00,937860.00,'248','2022-09-25 13:49:17','648','2022-09-25 21:08:34',10,0),('1','64',257987,'AFTERNOON','2022-09-25','2022-09-26 05:51:49','2022-09-27 05:51:49','248',1886580.00,1886580.00,'248','2022-09-26 06:14:36','648','2022-09-26 09:14:58',10,0),('1','64',257988,'MOORNING ','2022-09-26','2022-09-26 11:07:05','2022-09-27 11:07:05','248',1373180.00,1373180.00,'248','2022-09-26 14:09:40','648','2022-09-26 16:17:50',10,0),('1','64',257989,'AFTERNOON ','2022-09-26','2022-09-27 07:54:36','2022-09-28 07:54:36','248',1311240.20,1311240.20,'248','2022-09-27 07:56:32','648','2022-09-27 11:12:19',10,0),('1','64',257990,'MORNING','2022-09-27','2022-09-27 13:06:51','2022-09-28 13:06:51','248',884141.00,884141.00,'248','2022-09-27 14:12:10','648','2022-09-27 16:57:04',10,0),('1','64',257991,'AFTERNOON ','2022-09-27','2022-09-27 20:03:20','2022-09-28 20:03:20','248',2387480.20,2387480.20,'248','2022-09-28 06:16:59','648','2022-09-28 10:46:08',10,0),('1','64',257992,'MOORNING','2022-09-28','2022-09-28 14:17:43','2022-09-29 14:17:43','248',834580.00,834580.00,'248','2022-09-28 14:48:03','648','2022-09-29 07:07:25',10,0),('1','64',257993,'AFTERNOON','2022-09-28','2022-09-29 07:24:16','2022-09-30 07:24:16','248',1541300.00,1541300.00,'248','2022-09-29 07:30:16','648','2022-09-29 09:06:07',10,0),('1','64',257994,'MOORNING','2022-09-29','2022-09-29 09:10:50','2022-09-30 09:10:50','248',95760.00,95760.00,'248','2022-09-29 09:12:10','648','2022-09-29 09:16:14',10,0),('1','64',257995,'CHANGING OF PRICE SHIFT ','2022-09-29','2022-09-29 09:24:51','2022-09-30 09:24:51','248',769180.00,769180.00,'248','2022-09-29 14:32:24','648','2022-09-29 20:39:32',10,0),('1','64',257996,'AFTERNOON ','2022-09-29','2022-09-29 23:06:23','2022-09-30 23:06:23','248',1750690.00,1750690.00,'248','2022-09-29 23:08:15','648','2022-09-30 09:54:02',10,0),('1','64',257997,'MOORNING ','2022-09-30','2022-09-30 13:40:34','2022-10-01 13:40:34','248',1223380.00,1223380.00,'248','2022-09-30 13:42:21','648','2022-09-30 16:41:21',10,0),('1','64',257998,'AFTERNOON ','2022-09-30','2022-10-01 05:51:01','2022-10-02 05:51:01','248',2037690.00,2037690.00,'248','2022-10-01 05:59:15','648','2022-10-01 11:14:09',10,0),('1','64',257999,'MORNING','2022-10-01','2022-10-01 13:25:21','2022-10-02 13:25:21','248',1356910.00,1356910.00,'248','2022-10-01 14:40:52','648','2022-10-01 21:04:57',10,0),('1','64',258000,'AFTERNOON','2022-10-01','2022-10-01 21:29:28','2022-10-02 21:29:28','248',1829770.00,1829770.00,'248','2022-10-01 21:33:11','648','2022-10-02 12:57:54',10,0),('1','64',258001,'MOORNING ','2022-10-02','2022-10-02 14:43:36','2022-10-03 14:43:36','248',911641.20,911641.20,'248','2022-10-02 14:45:28','648','2022-10-02 20:54:16',10,0),('1','64',258002,'AFTERNOON','2022-10-02','2022-10-03 05:43:30','2022-10-04 05:43:30','248',1103860.40,1103860.40,'248','2022-10-03 05:51:14','648','2022-10-03 08:56:18',10,0),('1','64',258003,'MOORNING','2022-10-03','2022-10-03 09:44:13','2022-10-04 09:44:13','248',1572540.00,1572540.00,'248','2022-10-03 14:19:46','648','2022-10-03 17:46:28',10,0),('1','64',258004,'AFTERNOON','2022-10-03','2022-10-03 19:56:06','2022-10-04 19:56:06','248',1476310.00,1476310.00,'248','2022-10-03 21:35:59','648','2022-10-04 09:30:37',10,0),('1','64',258005,'MOORNING ','2022-10-04','2022-10-04 14:17:37','2022-10-05 14:17:37','248',1316930.00,1316930.00,'248','2022-10-04 14:25:40','648','2022-10-04 20:25:52',10,0),('1','64',258006,'AFTERNOON','2022-10-05','2022-10-05 07:02:59','2022-10-06 07:02:59','248',1240490.00,1240490.00,'248','2022-10-05 08:58:29','648','2022-10-05 10:36:31',10,0),('1','64',258007,'MOORNING ','2022-10-05','2022-10-05 12:54:30','2022-10-06 12:54:30','248',172480.00,172480.00,'248','2022-10-05 12:55:21','648','2022-10-05 13:00:12',10,0),('1','64',258008,'CHANGING OF PRICE SHIFT','2022-10-05','2022-10-05 13:36:04','2022-10-06 13:36:04','248',1902240.00,1902240.00,'248','2022-10-05 14:14:54','648','2022-10-05 16:47:17',10,0),('1','64',258009,'AFTERNOON ','2022-10-05','2022-10-06 08:36:09','2022-10-07 08:36:09','248',1245300.00,1245300.00,'248','2022-10-06 08:38:31','648','2022-10-06 08:58:07',10,0),('1','64',258010,'MOORNING ','2022-10-06','2022-10-06 11:24:21','2022-10-07 11:24:21','248',2226600.00,2226600.00,'248','2022-10-06 14:29:57','648','2022-10-07 06:36:26',10,0),('1','64',258011,'AFTERNOON','2022-10-06','2022-10-07 06:56:44','2022-10-08 06:56:44','248',1670340.00,1670340.00,'248','2022-10-07 06:59:34','648','2022-10-07 09:26:51',10,0),('1','64',258012,'MOORNING ','2022-10-07','2022-10-07 14:40:24','2022-10-08 14:40:24','248',1383720.00,1383720.00,'248','2022-10-07 14:41:07','648','2022-10-07 21:57:07',10,0),('1','64',258013,'AFTERNOON ','2022-10-07','2022-10-07 22:22:02','2022-10-08 22:22:02','248',292500.00,292500.00,'248','2022-10-07 22:23:12','648','2022-10-08 07:17:39',10,0),('1','64',258014,'MOORNING ','2022-10-08','2022-10-08 13:45:44','2022-10-09 13:45:44','248',290940.00,290940.00,'248','2022-10-08 13:46:24','648','2022-10-08 16:51:50',10,0),('1','64',258015,'AFTERNOON','2022-10-08','2022-10-09 08:49:28','2022-10-10 08:49:28','248',254280.00,254280.00,'248','2022-10-09 08:50:21','648','2022-10-09 09:12:36',10,0),('1','64',258016,'MOORNING ','2022-10-09','2022-10-09 12:46:01','2022-10-10 12:46:01','248',68640.00,68640.00,'248','2022-10-09 13:45:08','648','2022-10-09 16:47:09',10,0),('1','64',258017,'AFTERNOON ','2022-10-09','2022-10-10 07:12:28','2022-10-11 07:12:28','248',147420.00,147420.00,'248','2022-10-10 07:13:46','648','2022-10-10 08:09:45',10,0),('1','64',258018,'MOORNING ','2022-10-10','2022-10-10 13:24:16','2022-10-11 13:24:16','248',218400.00,218400.00,'248','2022-10-10 13:24:56','648','2022-10-10 15:25:34',10,0),('1','64',258019,'AFTERNOON','2022-10-10','2022-10-11 09:23:04','2022-10-12 09:23:04','248',188760.00,188760.00,'248','2022-10-11 09:24:11','648','2022-10-11 20:19:44',10,0),('1','64',258020,'MOORNING ','2022-10-11','2022-10-11 21:27:13','2022-10-12 21:27:13','248',354120.00,354120.00,'248','2022-10-11 21:28:11','648','2022-10-12 08:42:29',10,0),('1','64',258021,'AFTERNOON ','2022-10-11','2022-10-12 10:31:15','2022-10-13 10:31:15','248',283140.00,283140.00,'248','2022-10-12 10:32:17','648','2022-10-12 17:15:20',10,0),('1','64',258022,'MOORNING','2022-10-12','2022-10-12 20:24:52','2022-10-13 20:24:52','248',226980.00,226980.00,'248','2022-10-12 20:25:35','648','2022-10-13 07:53:51',10,0),('1','64',258023,'AFTERNOON','2022-10-12','2022-10-13 08:21:49','2022-10-14 08:21:49','248',285480.00,285480.00,'248','2022-10-13 08:22:40','648','2022-10-13 09:28:02',10,0),('1','64',258024,'MOORNING','2022-10-13','2022-10-13 09:34:14','2022-10-14 09:34:14','248',133600.00,133600.00,'248','2022-10-13 13:37:45','648','2022-10-13 21:42:06',10,0),('1','64',258025,'AFTERNOON','2022-10-13','2022-10-14 09:14:38','2022-10-15 09:14:38','248',1343200.00,1343200.00,'248','2022-10-14 09:15:52','648','2022-10-14 11:03:14',10,0),('1','64',258026,'MOORNING','2022-10-14','2022-10-14 13:31:02','2022-10-15 13:31:02','248',204800.00,204800.00,'248','2022-10-14 13:32:36','648','2022-10-14 20:32:46',10,0),('1','64',258027,'AFTERNOON ','2022-10-14','2022-10-14 22:13:48','2022-10-15 22:13:48','248',149600.00,149600.00,'248','2022-10-14 22:14:41','648','2022-10-15 14:33:28',10,0),('1','64',258028,'MOORNING ','2022-10-15','2022-10-15 20:44:11','2022-10-16 20:44:11','248',114400.00,114400.00,'248','2022-10-15 20:44:54','648','2022-10-15 23:54:01',10,0),('1','64',258029,'AFTERNOON ','2022-10-15','2022-10-16 07:22:57','2022-10-17 07:22:57','248',686400.00,686400.00,'248','2022-10-16 07:23:52','648','2022-10-16 09:40:32',10,0),('1','64',258030,'MOORNING ','2022-10-16','2022-10-16 11:38:50','2022-10-17 11:38:50','248',976800.00,976800.00,'248','2022-10-16 14:19:50','648','2022-10-16 16:52:52',10,0),('1','64',258031,'AFTERNOON','2022-10-16','2022-10-16 21:35:41','2022-10-17 21:35:41','248',712980.00,712980.00,'248','2022-10-16 21:37:19','648','2022-10-17 07:52:15',10,0),('1','64',258032,'MOORNING ','2022-10-17','2022-10-17 10:24:37','2022-10-18 10:24:37','248',645460.20,645460.20,'248','2022-10-17 13:57:15','648','2022-10-17 20:51:19',10,0),('1','64',258033,'AFTERNOON ','2022-10-17','2022-10-17 21:43:18','2022-10-18 21:43:18','248',964440.00,964440.00,'248','2022-10-17 21:45:40','648','2022-10-18 09:05:21',10,0),('1','64',258034,'MOORNING','2022-10-18','2022-10-18 09:28:37','2022-10-19 09:28:37','248',707040.00,707040.00,'248','2022-10-18 13:55:25','648','2022-10-19 07:29:14',10,0),('1','64',258035,'AFTERNOON ','2022-10-18','2022-10-19 10:17:03','2022-10-20 10:17:03','248',826380.00,826380.00,'248','2022-10-19 10:18:13','648','2022-10-19 15:51:42',10,0),('1','64',258036,'MOORNING','2022-10-19','2022-10-19 16:20:28','2022-10-20 16:20:28','248',682920.00,682920.00,'248','2022-10-19 16:23:27','648','2022-10-19 20:43:21',10,0),('1','64',258037,'AFTERNOON','2022-10-19','2022-10-19 21:06:39','2022-10-20 21:06:39','248',942840.00,942840.00,'248','2022-10-19 21:09:18','648','2022-10-20 13:34:50',10,0),('1','64',258038,'MOORNING ','2022-10-20','2022-10-20 14:17:14','2022-10-21 14:17:14','248',929021.20,929021.20,'248','2022-10-20 14:20:42','648','2022-10-21 04:06:20',10,0),('1','64',258039,'AFTERNOON','2022-10-20','2022-10-21 06:07:13','2022-10-22 06:07:13','248',740880.00,740880.00,'248','2022-10-21 06:10:14','648','2022-10-21 21:04:59',10,0),('1','64',258040,'MOORNING','2022-10-21','2022-10-21 21:24:10','2022-10-22 21:24:10','248',663840.00,663840.00,'248','2022-10-21 21:25:58','648','2022-10-22 09:38:34',10,0),('1','64',258041,'AFTERNOON','2022-10-21','2022-10-22 09:55:37','2022-10-23 09:55:37','248',991980.00,991980.00,'248','2022-10-22 09:57:12','648','2022-10-22 14:20:50',10,0),('1','64',258042,'MOORNING ','2022-10-22','2022-10-22 17:55:09','2022-10-23 17:55:09','248',654840.00,654840.00,'248','2022-10-22 17:57:25','648','2022-10-23 08:54:59',10,0),('1','64',258043,'AFTERNOON','2022-10-22','2022-10-23 09:10:18','2022-10-24 09:10:18','248',981000.00,981000.00,'248','2022-10-23 09:13:19','648','2022-10-23 13:03:37',10,0),('1','64',258044,'MOORNING ','2022-10-23','2022-10-23 14:07:58','2022-10-24 14:07:58','248',978989.40,978989.40,'248','2022-10-23 14:09:44','648','2022-10-23 14:16:26',10,0),('1','64',258045,'AFTERNOON','2022-10-23','2022-10-23 20:45:06','2022-10-24 20:45:06','248',1157500.80,1157500.80,'248','2022-10-23 20:55:45','648','2022-10-24 08:40:01',10,0),('1','64',258046,'MOORNING ','2022-10-24','2022-10-24 08:54:37','2022-10-25 08:54:37','248',1109340.00,1109340.00,'248','2022-10-24 13:59:26','648','2022-10-24 16:26:49',10,0),('1','64',258047,'AFTERNOON','2022-10-24','2022-10-24 18:56:27','2022-10-25 18:56:27','248',1046700.00,1046700.00,'248','2022-10-24 20:52:15','648','2022-10-25 08:04:02',10,0),('1','64',258048,'MOORNING','2022-10-25','2022-10-25 11:12:14','2022-10-26 11:12:14','248',1031760.00,1031760.00,'248','2022-10-25 13:57:35','648','2022-10-25 16:19:38',10,0),('1','64',258049,'AFTERNOON ','2022-10-25','2022-10-25 19:31:13','2022-10-26 19:31:13','248',960840.00,960840.00,'248','2022-10-25 19:33:52','648','2022-10-26 07:43:19',10,0),('1','64',258050,'MOORNING ','2022-10-30','2022-10-30 11:46:35','2022-10-31 11:46:35','248',1688440.00,1688440.00,'248','2022-10-30 16:03:43','648','2022-10-30 23:05:37',10,0),('1','64',258051,'AFTERNOON','2022-10-30','2022-10-31 06:02:41','2022-11-01 06:02:41','248',533840.40,533840.40,'248','2022-10-31 06:04:59','648','2022-10-31 08:17:51',10,0),('1','64',258052,'MOORNING ','2022-10-31','2022-10-31 13:02:14','2022-11-01 13:02:14','248',120000.00,120000.00,'248','2022-10-31 14:10:00','648','2022-10-31 14:25:24',10,0),('1','64',258053,'AFTERNOON','2022-10-31','2022-10-31 23:04:36','2022-11-01 23:04:36','248',105600.00,105600.00,'248','2022-10-31 23:06:41','648','2022-11-01 08:51:46',10,0),('1','64',258054,'MOORNING','2022-11-01','2022-11-01 10:36:18','2022-11-02 10:36:18','248',95200.00,95200.00,'248','2022-11-01 15:52:52','648','2022-11-01 18:14:11',10,0),('1','64',258055,'AFTERNOON','2022-11-01','2022-11-02 03:54:29','2022-11-03 03:54:29','248',0.00,0.00,'248','2022-11-02 03:55:29','648','2022-11-02 09:15:35',10,0),('1','64',258056,'AFTERNOON ','2022-11-01','2022-11-02 10:44:46','2022-11-03 10:44:46','248',268000.00,268000.00,'248','2022-11-02 10:45:24','648','2022-11-02 18:52:50',10,0),('1','64',258057,'MOORNING','2022-11-02','2022-11-02 21:19:23','2022-11-03 21:19:23','248',135200.00,135200.00,'248','2022-11-02 21:20:08','648','2022-11-03 09:16:17',10,0),('1','64',258058,'AFTERNOON ','2022-11-02','2022-11-03 09:52:18','2022-11-04 09:52:18','248',240800.00,240800.00,'248','2022-11-03 09:53:16','648','2022-11-03 13:47:09',10,0),('1','64',258059,'MOORNING','2022-11-03','2022-11-03 15:12:55','2022-11-04 15:12:55','248',430400.00,430400.00,'248','2022-11-03 15:13:35','648','2022-11-03 23:09:39',10,0),('1','64',258060,'AFTERNOON ','2022-11-03','2022-11-04 07:41:21','2022-11-05 07:41:21','248',509600.00,509600.00,'248','2022-11-04 07:42:17','648','2022-11-05 10:01:58',10,0),('1','64',258061,'MOORNING  ','2022-11-05','2022-11-05 11:22:27','2022-11-06 11:22:27','248',422400.00,422400.00,'248','2022-11-05 11:23:48','648','2022-11-06 11:12:18',10,0),('1','64',258062,'AFTERNOON ','2022-11-04','2022-11-06 14:10:30','2022-11-07 14:10:30','248',862400.00,862400.00,'248','2022-11-06 14:11:53','648','2022-11-06 14:17:00',10,0),('1','64',258063,'MOORNING ','2022-11-05','2022-11-06 14:32:10','2022-11-07 14:32:10','248',172800.00,172800.00,'248','2022-11-06 14:32:58','648','2022-11-06 14:37:40',10,0),('1','64',258064,'AFTERNOON ','2022-11-05','2022-11-06 14:45:41','2022-11-07 14:45:41','248',160000.00,160000.00,'248','2022-11-06 14:46:42','648','2022-11-06 14:48:55',10,0),('1','64',258065,'MOORNING ','2022-11-06','2022-11-06 15:03:12','2022-11-07 15:03:12','248',1293600.00,1293600.00,'248','2022-11-06 15:04:54','648','2022-11-06 16:10:30',10,0),('1','64',258066,'AFTERNOON','2022-11-06','2022-11-06 18:05:39','2022-11-07 18:05:39','248',130400.00,130400.00,'248','2022-11-06 21:14:14','648','2022-11-07 08:18:00',10,0),('1','64',258067,'MOORNING ','2022-11-07','2022-11-07 10:48:05','2022-11-08 10:48:05','248',187200.00,187200.00,'248','2022-11-07 13:39:05','648','2022-11-08 04:11:26',10,0),('1','64',258068,'AFTERNOON ','2022-11-07','2022-11-08 06:58:58','2022-11-09 06:58:58','248',201600.00,201600.00,'248','2022-11-08 07:01:06','648','2022-11-08 11:13:25',10,0),('1','64',258069,'MOORNING ','2022-11-08','2022-11-08 11:20:53','2022-11-09 11:20:53','248',259200.00,259200.00,'248','2022-11-08 14:28:53','648','2022-11-08 22:57:00',10,0),('1','64',258070,'AFTERNOON','2022-11-08','2022-11-09 05:13:59','2022-11-10 05:13:59','248',255200.00,255200.00,'248','2022-11-09 05:14:59','648','2022-11-09 11:02:52',10,0),('1','64',258071,'MOORNING','2022-11-09','2022-11-09 12:09:35','2022-11-10 12:09:35','248',175200.00,175200.00,'248','2022-11-09 14:15:57','648','2022-11-10 09:34:03',10,0),('1','64',258072,'AFTERNOON','2022-11-09','2022-11-10 10:18:57','2022-11-11 10:18:57','248',495400.00,495400.00,'248','2022-11-10 10:30:34','648','2022-11-10 13:02:30',10,0),('1','64',258073,'MOORNING ','2022-11-10','2022-11-10 13:44:25','2022-11-11 13:44:25','248',867200.00,867200.00,'248','2022-11-10 13:45:38','648','2022-11-10 14:52:35',10,0),('1','64',258074,'AFTERNOON ','2022-11-10','2022-11-10 16:58:59','2022-11-11 16:58:59','248',97180.00,97180.00,'248','2022-11-11 09:13:53','648','2022-11-11 12:38:02',10,0),('1','64',258075,'MOORNING','2022-11-11','2022-11-11 15:24:04','2022-11-12 15:24:04','248',141900.00,141900.00,'248','2022-11-11 15:24:50','648','2022-11-12 12:21:26',10,0),('1','64',258076,'AFTERNOON','2022-11-11','2022-11-12 13:52:30','2022-11-13 13:52:30','248',249400.00,249400.00,'248','2022-11-12 13:53:06','648','2022-11-13 06:23:50',10,0),('1','64',258077,'MOORNING','2022-11-12','2022-11-13 08:54:33','2022-11-14 08:54:33','248',335400.00,335400.00,'248','2022-11-13 08:55:58','648','2022-11-13 23:09:00',10,0),('1','64',258078,'AFTERNOON','2022-11-12','2022-11-14 06:27:37','2022-11-15 06:27:37','248',98040.00,98040.00,'248','2022-11-14 06:28:19','648','2022-11-14 07:51:13',10,0),('1','64',258079,'MOORNING ','2022-11-13','2022-11-14 08:13:31','2022-11-15 08:13:31','248',92880.00,92880.00,'248','2022-11-14 08:14:18','648','2022-11-14 08:32:20',10,0),('1','64',258080,'AFTERNOON','2022-11-13','2022-11-14 11:57:08','2022-11-15 11:57:08','248',363780.00,363780.00,'248','2022-11-14 11:58:21','648','2022-11-15 09:34:21',10,0),('1','64',258081,'MOORNING','2022-11-14','2022-11-15 10:07:57','2022-11-16 10:07:57','248',307020.00,307020.00,'248','2022-11-15 10:09:38','648','2022-11-15 10:30:56',10,0),('1','64',258082,'AFTERNOON','2022-11-14','2022-11-15 10:46:44','2022-11-16 10:46:44','248',252840.00,252840.00,'248','2022-11-15 10:48:49','648','2022-11-15 10:59:37',10,0),('1','64',258083,'MOORNING ','2022-11-15','2022-11-15 13:25:37','2022-11-16 13:25:37','248',104060.00,104060.00,'248','2022-11-15 13:26:45','648','2022-11-15 17:59:25',10,0),('1','64',258084,'AFTERNOON','2022-11-15','2022-11-15 19:15:39','2022-11-16 19:15:39','248',523740.00,523740.00,'248','2022-11-15 19:16:14','648','2022-11-15 21:44:00',10,0),('1','64',258085,'MOORNING ','2022-11-16','2022-11-16 09:33:33','2022-11-17 09:33:33','248',521160.00,521160.00,'248','2022-11-16 09:34:02','648','2022-11-16 23:28:25',10,0),('1','64',258086,'CHANGING OF PRICE SHIFT ','2022-11-17','2022-11-17 08:29:28','2022-11-18 08:29:28','248',119625.00,119625.00,'248','2022-11-17 08:30:17','648','2022-11-18 06:20:10',10,0),('1','64',258087,'AFTERNOON ','2022-11-16','2022-11-18 08:17:24','2022-11-19 08:17:24','248',679800.00,679800.00,'248','2022-11-18 08:18:23','648','2022-11-18 08:29:20',10,0),('1','64',258088,'MOORNING ','2022-11-17','2022-11-18 08:30:02','2022-11-19 08:30:02','248',155100.00,155100.00,'248','2022-11-18 08:31:24','648','2022-11-18 08:33:24',10,0),('1','64',258089,'AFTERNOON ','2022-11-17','2022-11-18 08:34:54','2022-11-19 08:34:54','248',551925.00,551925.00,'248','2022-11-18 08:36:30','648','2022-11-18 09:03:51',10,0),('1','64',258090,'MOORNING ','2022-11-18','2022-11-18 09:08:39','2022-11-19 09:08:39','248',266475.00,266475.00,'248','2022-11-18 14:27:33','648','2022-11-19 08:36:47',10,0),('1','64',258091,'AFTERNOON','2022-11-18','2022-11-19 08:51:57','2022-11-20 08:51:57','248',107250.00,107250.00,'248','2022-11-19 08:52:40','648','2022-11-19 13:09:38',10,0),('1','64',258092,'MOORNING','2022-11-19','2022-11-19 13:20:04','2022-11-20 13:20:04','248',402360.00,402360.00,'248','2022-11-19 13:22:19','648','2022-11-20 21:29:35',10,0),('1','64',258093,'AFTERNOON ','2022-11-19','2022-11-21 08:23:31','2022-11-22 08:23:31','248',230160.00,230160.00,'248','2022-11-21 08:25:05','648','2022-11-21 16:32:36',10,0),('1','64',258094,'MOORNING','2022-11-20','2022-11-21 17:34:59','2022-11-22 17:34:59','248',64680.00,64680.00,'248','2022-11-21 17:35:40','648','2022-11-22 10:13:08',10,0),('1','64',258095,'AFTERNOON','2022-11-20','2022-11-22 10:42:09','2022-11-23 10:42:09','248',831600.00,831600.00,'248','2022-11-22 10:43:26','648','2022-11-22 11:58:25',10,0),('1','64',258096,'MOORNING','2022-11-21','2022-11-22 13:16:52','2022-11-23 13:16:52','248',152880.00,152880.00,'248','2022-11-22 13:17:19','648','2022-11-22 13:27:45',10,0),('1','64',258097,'AFTERNOON','2022-11-21','2022-11-22 13:30:50','2022-11-23 13:30:50','248',35280.00,35280.00,'248','2022-11-22 13:31:47','648','2022-11-22 13:40:49',10,0),('1','64',258098,'MOORNING','2022-11-22','2022-11-22 13:46:55','2022-11-23 13:46:55','248',183120.00,183120.00,'248','2022-11-22 14:07:46','648','2022-11-23 01:27:03',10,0),('1','64',258099,'AFTERNOON ','2022-11-22','2022-11-23 08:33:47','2022-11-24 08:33:47','248',210000.00,210000.00,'248','2022-11-23 08:36:56','648','2022-11-24 04:21:48',10,0),('1','64',258100,'MOORNING ','2022-11-23','2022-11-24 06:07:37','2022-11-25 06:07:37','248',1744260.00,1744260.00,'248','2022-11-24 06:17:15','648','2022-11-24 09:03:30',10,0),('1','64',258101,'AFTERNOON','2022-11-23','2022-11-24 10:35:45','2022-11-25 10:35:45','248',1698291.00,1698291.00,'248','2022-11-24 10:39:26','648','2022-11-24 16:10:41',10,0),('1','64',258102,'MOORNING','2022-11-24','2022-11-24 17:59:17','2022-11-25 17:59:17','248',1271130.00,1271130.00,'248','2022-11-24 18:00:50','648','2022-11-24 23:23:45',10,0),('1','64',258103,'AFTERNOON','2022-11-24','2022-11-25 06:51:20','2022-11-26 06:51:20','248',1387890.00,1387890.00,'248','2022-11-25 07:56:37','648','2022-11-25 08:50:28',10,0),('1','64',258104,'MOORNING ','2022-11-25','2022-11-25 16:18:59','2022-11-26 16:18:59','248',1470630.00,1470630.00,'248','2022-11-25 16:20:28','648','2022-11-25 17:08:25',10,0),('1','64',258105,'AFTERNOON','2022-11-25','2022-11-25 20:23:55','2022-11-26 20:23:55','248',1517040.00,1517040.00,'248','2022-11-25 20:31:08','648','2022-11-26 09:39:42',10,0),('1','64',258106,'MOORNING ','2022-11-26','2022-11-26 18:17:41','2022-11-27 18:17:41','248',592620.00,592620.00,'248','2022-11-26 18:19:03','648','2022-11-27 09:16:55',10,0),('1','64',258107,'MOORNING','2022-11-27','2022-11-27 14:07:38','2022-11-28 14:07:38','248',1243970.00,1243970.00,'248','2022-11-27 17:43:18','648','2022-11-28 09:57:56',10,0),('1','64',258108,'AFTERNOON','2022-11-27','2022-11-28 12:45:52','2022-11-29 12:45:52','248',1030160.00,1030160.00,'248','2022-11-28 15:01:50','648','2022-11-29 11:11:21',10,0),('1','64',258109,'MOORNING','2022-11-28','2022-11-29 11:46:01','2022-11-30 11:46:01','248',921690.00,921690.00,'248','2022-11-29 11:48:15','648','2022-11-29 22:56:47',10,0),('1','64',258110,'AFTERNOON','2022-11-29','2022-11-30 06:00:00','2022-12-01 06:00:00','248',959280.00,959280.00,'248','2022-11-30 06:02:20','648','2022-11-30 11:29:02',10,0),('1','64',258111,'MOORNING ','2022-11-29','2022-11-30 13:28:10','2022-12-01 13:28:10','248',1195950.00,1195950.00,'248','2022-11-30 13:30:26','648','2022-12-01 08:42:01',10,0),('1','64',258112,'MOORNING  ','2022-12-06','2022-12-06 11:23:42','2022-12-07 11:23:42','248',611560.00,611560.00,'248','2022-12-06 11:25:35','648','2022-12-06 16:14:22',10,0),('1','64',258113,'AFTERNOON ','2022-12-06','2022-12-07 09:52:40','2022-12-08 09:52:40','248',17640.00,17640.00,'248','2022-12-07 09:54:00','648','2022-12-07 14:53:46',10,0),('1','64',258114,'MOORNING ','2022-12-07','2022-12-07 17:20:26','2022-12-08 17:20:26','248',8468880.00,8468880.00,'248','2022-12-08 09:39:25','648','2022-12-08 17:36:53',10,0),('1','64',258115,'MOORNING ','2022-12-08','2022-12-08 18:11:27','2022-12-09 18:11:27','248',277200.00,277200.00,'248','2022-12-08 18:12:49','648','2022-12-09 02:15:36',10,0),('1','64',258116,'AFTERNOON','2022-12-08','2022-12-09 04:24:28','2022-12-10 04:24:28','248',89880.00,89880.00,'248','2022-12-09 04:25:30','648','2022-12-09 12:25:05',10,0),('1','64',258117,'MOORNING','2022-12-09','2022-12-09 12:33:06','2022-12-10 12:33:06','248',70560.00,70560.00,'248','2022-12-09 13:31:56','648','2022-12-09 17:36:31',10,0),('1','64',258118,'AFTERNOON','2022-12-09','2022-12-09 18:59:53','2022-12-10 18:59:53','248',688800.00,688800.00,'248','2022-12-09 19:43:49','648','2022-12-11 05:52:06',10,0),('1','64',258119,'MOORNING','2022-12-10','2022-12-11 07:55:36','2022-12-12 07:55:36','248',1014720.00,1014720.00,'248','2022-12-11 07:58:04','648','2022-12-11 12:38:39',10,0),('1','64',258120,'AFTERNOON','2022-12-10','2022-12-11 15:02:21','2022-12-12 15:02:21','248',454440.00,454440.00,'248','2022-12-11 15:03:02','648','2022-12-11 17:03:54',10,0),('1','64',258121,'MOORNING ','2022-12-11','2022-12-11 18:01:54','2022-12-12 18:01:54','248',224280.00,224280.00,'248','2022-12-11 18:02:59','648','2022-12-12 11:20:51',10,0),('1','64',258122,'AFTERNOON','2022-12-11','2022-12-12 13:11:55','2022-12-13 13:11:55','248',151200.00,151200.00,'248','2022-12-12 13:13:08','648','2022-12-12 17:56:02',10,0),('1','64',258123,'MOORNING ','2022-12-12','2022-12-12 19:38:03','2022-12-13 19:38:03','248',132720.00,132720.00,'248','2022-12-12 19:40:20','648','2022-12-13 06:24:43',10,0),('1','64',258124,'AFTERNOON','2022-12-12','2022-12-13 08:35:57','2022-12-14 08:35:57','248',1053360.00,1053360.00,'248','2022-12-13 08:39:12','648','2022-12-13 12:02:32',10,0),('1','64',258125,'MOORNING','2022-12-13','2022-12-13 12:25:33','2022-12-14 12:25:33','248',187320.00,187320.00,'248','2022-12-13 14:10:23','648','2022-12-14 08:05:33',10,0),('1','64',258126,'AFTERNOON','2022-12-13','2022-12-14 08:35:16','2022-12-15 08:35:16','248',916440.00,916440.00,'248','2022-12-14 08:36:08','648','2022-12-14 09:31:55',10,0),('1','64',258127,'MOORNING','2022-12-14','2022-12-14 09:39:30','2022-12-15 09:39:30','248',437640.00,437640.00,'248','2022-12-14 14:10:44','648','2022-12-15 05:58:02',10,0),('1','64',258128,'AFTERNOON','2022-12-14','2022-12-15 07:45:44','2022-12-16 07:45:44','248',69700.00,69700.00,'248','2022-12-15 07:47:03','648','2022-12-15 10:03:03',10,0),('1','64',258129,'MOORNING','2022-12-15','2022-12-15 13:47:43','2022-12-16 13:47:43','248',150880.00,150880.00,'248','2022-12-15 15:26:08','648','2022-12-15 21:39:20',10,0),('1','64',258130,'AFTERNOON','2022-12-15','2022-12-16 07:22:45','2022-12-17 07:22:45','248',54940.00,54940.00,'248','2022-12-16 07:24:18','648','2022-12-16 15:03:36',10,0),('1','64',258131,'MOORNING','2022-12-16','2022-12-16 15:20:17','2022-12-17 15:20:17','248',299300.00,299300.00,'248','2022-12-16 15:21:04','648','2022-12-17 07:59:50',10,0),('1','64',258132,'AFTERNOON','2022-12-16','2022-12-17 08:15:35','2022-12-18 08:15:35','248',629890.00,629890.00,'248','2022-12-17 08:17:50','648','2022-12-17 10:18:26',10,0),('1','64',258133,'MOORNING','2022-12-17','2022-12-17 13:57:09','2022-12-18 13:57:09','248',1116840.00,1116840.00,'248','2022-12-17 14:11:13','648','2022-12-17 15:15:32',10,0),('1','64',258134,'AFTERNOON','2022-12-17','2022-12-17 22:13:35','2022-12-18 22:13:35','248',247640.00,247640.00,'248','2022-12-17 22:14:53','648','2022-12-18 09:43:54',10,0),('1','64',258135,'MOORNING ','2022-12-18','2022-12-18 10:50:48','2022-12-19 10:50:48','248',100860.00,100860.00,'248','2022-12-18 13:31:27','648','2022-12-18 20:43:08',10,0),('1','64',258136,'AFTERNOON ','2022-12-18','2022-12-19 08:51:32','2022-12-20 08:51:32','248',152520.00,152520.00,'248','2022-12-19 08:52:27','648','2022-12-19 11:48:44',10,0),('1','64',258137,'MOORNING','2022-12-19','2022-12-19 13:09:25','2022-12-20 13:09:25','248',362440.00,362440.00,'248','2022-12-19 13:29:43','648','2022-12-20 05:23:55',10,0),('1','64',258138,'AFTERNOON','2022-12-19','2022-12-20 06:11:59','2022-12-21 06:11:59','248',153340.00,153340.00,'248','2022-12-20 06:32:52','648','2022-12-20 10:02:55',10,0),('1','64',258139,'MOORNING  ','2022-12-20','2022-12-20 12:18:04','2022-12-21 12:18:04','248',2285670.00,2285670.00,'248','2022-12-20 15:30:53','648','2022-12-21 07:51:03',10,0),('1','64',258140,'AFTERNOON','2022-12-20','2022-12-21 08:30:00','2022-12-22 08:30:00','248',1108140.00,1108140.00,'248','2022-12-21 08:30:48','648','2022-12-21 08:41:09',10,0),('1','64',258141,'MOORNING  ','2022-12-21','2022-12-21 13:45:49','2022-12-22 13:45:49','248',694830.00,694830.00,'248','2022-12-21 13:48:33','648','2022-12-21 22:10:14',10,0),('1','64',258142,'AFTERNOON','2022-12-21','2022-12-22 03:04:45','2022-12-23 03:04:45','248',610682.20,610682.20,'248','2022-12-22 03:07:05','648','2022-12-22 06:25:08',10,0),('1','64',258143,'MOORNING ','2022-12-22','2022-12-22 11:48:21','2022-12-23 11:48:21','248',469660.00,469660.00,'248','2022-12-22 14:01:24','648','2022-12-22 20:41:27',10,0),('1','64',258144,'AFTERNOON','2022-12-22','2022-12-23 05:13:00','2022-12-24 05:13:00','248',423660.00,423660.00,'248','2022-12-23 09:47:26','648','2022-12-23 09:50:28',10,0),('1','64',258145,'MOORNING','2022-12-23','2022-12-23 12:47:33','2022-12-24 12:47:33','248',44160.00,44160.00,'248','2022-12-23 12:55:42','648','2022-12-24 06:50:41',10,0),('1','64',258146,'AFTERNOON','2022-12-30','2022-12-30 21:43:25','2022-12-31 21:43:25','248',446900.00,446900.00,'248','2022-12-30 21:44:29','648','2022-12-31 06:58:16',10,0),('1','64',258147,'MOORNING ','2022-12-31','2022-12-31 14:07:53','2023-01-01 14:07:53','248',378915.00,378915.00,'248','2022-12-31 14:09:30','648','2022-12-31 17:13:41',10,0),('1','64',258148,'AFTERNOON','2022-12-31','2023-01-01 08:38:38','2023-01-02 08:38:38','248',178760.00,178760.00,'248','2023-01-01 08:39:20','648','2023-01-01 10:04:04',10,0),('1','64',258149,'MOORNING ','2023-01-01','2023-01-01 12:37:54','2023-01-02 12:37:54','248',207460.00,207460.00,'248','2023-01-01 14:14:44','648','2023-01-01 19:02:18',10,0),('1','64',258150,'AFTERNOON','2023-01-01','2023-01-02 06:57:10','2023-01-03 06:57:10','248',39360.00,39360.00,'248','2023-01-02 06:58:19','648','2023-01-02 18:09:05',10,0),('1','64',258151,'MOORNING','2023-01-02','2023-01-02 22:09:47','2023-01-03 22:09:47','248',100860.00,100860.00,'248','2023-01-02 22:10:44','648','2023-01-04 09:00:31',10,0),('1','64',258152,'AFTERNOON','2023-01-02','2023-01-04 09:50:42','2023-01-05 09:50:42','248',41820.00,41820.00,'248','2023-01-04 09:51:41','648','2023-01-04 10:14:17',10,0),('1','64',258153,'MOORNING','2023-01-03','2023-01-04 10:26:45','2023-01-05 10:26:45','248',159900.00,159900.00,'248','2023-01-04 10:27:10','648','2023-01-04 10:54:41',10,0),('1','64',258154,'AFTERNOON','2023-01-03','2023-01-04 10:57:58','2023-01-05 10:57:58','248',900055.00,900055.00,'248','2023-01-04 13:18:57','648','2023-01-04 13:34:45',10,0),('1','64',258155,'MOORNING  ','2023-01-04','2023-01-04 13:36:17','2023-01-05 13:36:17','248',232880.00,232880.00,'248','2023-01-04 13:36:49','648','2023-01-04 16:50:27',10,0),('1','64',258156,'AFTERNOON','2023-01-04','2023-01-04 19:34:13','2023-01-05 19:34:13','248',150880.00,150880.00,'248','2023-01-04 19:34:54','648','2023-01-05 05:04:27',10,0),('1','64',258157,'MOORNING ','2023-01-05','2023-01-05 13:23:53','2023-01-06 13:23:53','248',209920.00,209920.00,'248','2023-01-05 13:24:31','648','2023-01-05 20:54:58',10,0),('1','64',258158,'AFTERNOON','2023-01-05','2023-01-06 06:32:38','2023-01-07 06:32:38','248',236980.00,236980.00,'248','2023-01-06 06:33:34','648','2023-01-06 10:11:48',10,0),('1','64',258159,'MOORNING  ','2023-01-06','2023-01-06 12:42:19','2023-01-07 12:42:19','248',227960.00,227960.00,'248','2023-01-06 13:21:29','648','2023-01-07 09:17:30',10,0),('1','64',258160,'AFTERNOON','2023-01-06','2023-01-07 11:08:37','2023-01-08 11:08:37','248',88560.00,88560.00,'248','2023-01-07 11:42:20','648','2023-01-07 16:36:08',10,0),('1','64',258161,'MOORNING','2023-01-07','2023-01-07 18:17:14','2023-01-08 18:17:14','248',335380.00,335380.00,'248','2023-01-07 18:18:09','648','2023-01-08 09:21:01',10,0),('1','64',258162,'AFTERNOON ','2023-01-07','2023-01-08 12:23:13','2023-01-09 12:23:13','248',667480.00,667480.00,'248','2023-01-08 12:24:34','648','2023-01-08 14:17:42',10,0),('1','64',258163,'MOORNING','2023-01-08','2023-01-08 19:12:09','2023-01-09 19:12:09','248',132020.00,132020.00,'248','2023-01-08 19:12:36','648','2023-01-09 06:11:16',10,0),('1','64',258164,'AFTERNOON','2023-01-08','2023-01-09 06:50:49','2023-01-10 06:50:49','248',81180.00,81180.00,'248','2023-01-09 06:51:36','648','2023-01-10 10:10:23',10,0),('1','64',258165,'MOORNING  ','2023-01-09','2023-01-10 12:56:45','2023-01-11 12:56:45','248',296020.00,296020.00,'248','2023-01-10 12:57:22','648','2023-01-10 13:21:54',10,0),('1','64',258166,'AFTERNOON ','2023-01-09','2023-01-10 13:55:43','2023-01-11 13:55:43','248',149240.00,149240.00,'248','2023-01-10 13:56:24','648','2023-01-10 15:01:17',10,0),('1','64',258167,'MOORNING ','2023-01-10','2023-01-10 16:39:44','2023-01-11 16:39:44','248',2491235.00,2491235.00,'248','2023-01-10 16:41:32','648','2023-01-11 06:59:00',10,0),('1','64',258168,'AFTERNOON','2023-01-10','2023-01-11 10:36:33','2023-01-12 10:36:33','248',2891255.00,2891255.00,'248','2023-01-11 11:18:06','648','2023-01-11 14:26:01',10,0),('1','64',258169,'MOORNING','2023-01-11','2023-01-11 17:06:42','2023-01-12 17:06:42','248',1723760.00,1723760.00,'248','2023-01-11 17:07:44','648','2023-01-12 06:59:41',10,0),('1','64',258170,'AFTERNOON ','2023-01-11','2023-01-12 10:45:14','2023-01-13 10:45:14','248',2657315.00,2657315.00,'248','2023-01-12 10:49:00','648','2023-01-12 13:09:15',10,0),('1','64',258171,'MOORNING  ','2023-01-12','2023-01-12 13:40:02','2023-01-13 13:40:02','248',1505340.00,1505340.00,'248','2023-01-12 13:42:25','648','2023-01-12 22:16:48',10,0),('1','64',258172,'AFTERNOON ','2023-01-12','2023-01-13 07:32:16','2023-01-14 07:32:16','248',1170525.00,1170525.00,'248','2023-01-13 07:34:44','648','2023-01-13 09:09:01',10,0),('1','64',258173,'MOORNING ','2023-01-13','2023-01-13 09:54:00','2023-01-14 09:54:00','248',2179620.00,2179620.00,'248','2023-01-13 15:11:58','648','2023-01-13 15:36:36',10,0),('1','64',258174,'AFTERNOON ','2023-01-13','2023-01-13 16:45:54','2023-01-14 16:45:54','248',184500.00,184500.00,'248','2023-01-13 19:42:21','648','2023-01-13 23:57:33',10,0),('1','64',258175,'MOORNING  ','2023-01-14','2023-01-14 14:39:34','2023-01-15 14:39:34','248',2161310.00,2161310.00,'248','2023-01-14 14:40:49','648','2023-01-14 14:55:25',10,0),('1','64',258176,'AFTERNOON ','2023-01-14','2023-01-14 17:03:55','2023-01-15 17:03:55','248',1073751.50,1073751.50,'248','2023-01-14 22:03:02','648','2023-01-15 12:34:30',10,0),('1','64',258177,'MOORNING ','2023-01-15','2023-01-15 15:29:43','2023-01-16 15:29:43','248',239440.00,239440.00,'248','2023-01-15 15:30:20','648','2023-01-15 21:33:18',10,0),('1','64',258178,'AFTERNOON ','2023-01-15','2023-01-16 09:08:27','2023-01-17 09:08:27','248',1873700.00,1873700.00,'248','2023-01-16 09:10:54','648','2023-01-16 13:30:32',10,0),('1','64',258179,'MOORNING ','2023-01-16','2023-01-16 14:15:14','2023-01-17 14:15:14','248',371460.00,371460.00,'248','2023-01-16 14:15:44','648','2023-01-17 06:09:06',10,0),('1','64',258180,'AFTERNOON','2023-01-16','2023-01-17 09:27:12','2023-01-18 09:27:12','248',356700.00,356700.00,'248','2023-01-17 09:29:05','648','2023-01-17 10:48:53',10,0),('1','64',258181,'MOORNING ','2023-01-17','2023-01-17 13:35:02','2023-01-18 13:35:02','248',817720.00,817720.00,'248','2023-01-17 13:36:51','648','2023-01-17 17:00:50',10,0),('1','64',258182,'AFTERNOON ','2023-01-17','2023-01-17 18:07:53','2023-01-18 18:07:53','248',96760.00,96760.00,'248','2023-01-17 18:08:52','648','2023-01-17 18:23:00',10,0),('1','64',258183,'CHANGING OF PRICE SHIFT','2023-01-17','2023-01-17 22:54:46','2023-01-18 22:54:46','248',0.00,0.00,'248','2023-01-18 13:54:28','648','2023-01-18 14:19:49',10,0),('1','64',258184,'CHANGING OF PRICE SHIFT','2023-01-17','2023-01-18 14:25:23','2023-01-19 14:25:23','248',470480.00,470480.00,'248','2023-01-18 14:28:34','648','2023-01-18 14:35:48',10,0),('1','64',258185,'MOORNING ','2023-01-18','2023-01-18 14:56:04','2023-01-19 14:56:04','248',0.00,0.00,'248','2023-01-18 15:00:51','648','2023-01-18 15:03:03',10,0),('1','64',258186,'MOORNING ','2023-01-18','2023-01-18 15:08:13','2023-01-19 15:08:13','248',434595.00,434595.00,'248','2023-01-18 15:09:10','648','2023-01-18 16:20:11',10,0),('1','64',258187,'AFTERNOON','2023-01-18','2023-01-18 19:24:28','2023-01-19 19:24:28','248',518015.00,518015.00,'248','2023-01-18 19:42:03','648','2023-01-18 23:38:50',10,0),('1','64',258188,'AFTERNOON ','2023-01-19','2023-01-19 13:52:47','2023-01-20 13:52:47','248',337770.00,337770.00,'248','2023-01-19 13:54:31','648','2023-01-19 18:20:23',10,0),('1','64',258189,'AFTERNOON ','2023-01-19','2023-01-19 20:12:53','2023-01-20 20:12:53','248',1159915.00,1159915.00,'248','2023-01-19 20:14:31','648','2023-01-20 09:13:47',10,0),('1','64',258190,'MOORNING  ','2023-01-20','2023-01-20 10:14:51','2023-01-21 10:14:51','248',370170.00,370170.00,'248','2023-01-20 13:28:56','648','2023-01-20 15:24:07',10,0),('1','64',258191,'AFTERNOON ','2023-01-20','2023-01-20 18:10:35','2023-01-21 18:10:35','248',610375.00,610375.00,'248','2023-01-20 19:28:59','648','2023-01-21 06:11:17',10,0),('1','64',258192,'MOORNING ','2023-01-21','2023-01-21 13:51:44','2023-01-22 13:51:44','248',365310.00,365310.00,'248','2023-01-21 13:52:33','648','2023-01-21 21:59:27',10,0),('1','64',258193,'AFTERNOON ','2023-01-21','2023-01-22 05:35:18','2023-01-23 05:35:18','248',192780.00,192780.00,'248','2023-01-22 05:36:39','648','2023-01-22 09:38:32',10,0),('1','64',258194,'MOORNING ','2023-01-22','2023-01-22 12:12:36','2023-01-23 12:12:36','248',165240.00,165240.00,'248','2023-01-22 13:44:35','648','2023-01-22 20:23:58',10,0),('1','64',258195,'AFTERNOON ','2023-01-22','2023-01-22 23:36:14','2023-01-23 23:36:14','248',170100.00,170100.00,'248','2023-01-23 08:02:29','648','2023-01-23 08:30:52',10,0),('1','64',258196,'MOORNING ','2023-01-23','2023-01-23 13:50:53','2023-01-24 13:50:53','248',240570.00,240570.00,'248','2023-01-23 13:51:39','648','2023-01-23 16:52:10',10,0),('1','64',258197,'AFTERNOON ','2023-01-23','2023-01-23 19:32:30','2023-01-24 19:32:30','248',1137240.00,1137240.00,'248','2023-01-23 19:33:06','648','2023-01-24 11:43:14',10,0),('1','64',258198,'MOORNING  ','2023-01-24','2023-01-24 14:22:02','2023-01-25 14:22:02','248',1003575.00,1003575.00,'248','2023-01-24 14:23:52','648','2023-01-24 15:24:49',10,0),('1','64',258199,'AFTERNOON ','2023-01-24','2023-01-24 19:37:16','2023-01-25 19:37:16','248',1227150.00,1227150.00,'248','2023-01-24 19:38:37','648','2023-01-25 08:33:49',10,0),('1','64',258200,'MOORNING ','2023-01-25','2023-01-25 14:11:59','2023-01-26 14:11:59','248',437400.00,437400.00,'248','2023-01-25 14:13:14','648','2023-01-25 14:31:30',10,0),('1','64',258201,'AFTERNOON ','2023-01-25','2023-01-25 18:24:01','2023-01-26 18:24:01','248',1352700.00,1352700.00,'248','2023-01-26 08:27:56','648','2023-01-26 19:26:14',10,0),('1','64',258202,'MOORNING','2023-01-26','2023-01-26 21:14:02','2023-01-27 21:14:02','248',758146.00,758146.00,'248','2023-01-26 21:15:44','648','2023-01-27 09:52:41',10,0),('1','64',258203,'MOORNING  ','2023-01-29','2023-01-29 09:55:31','2023-01-30 09:55:31','248',0.00,0.00,'248','2023-01-29 15:03:26','648','2023-01-30 17:45:45',10,0),('1','64',258204,'AFTERNOON ','2023-01-29','2023-01-30 17:47:31','2023-01-31 17:47:31','248',989725.00,989725.00,'248','2023-01-30 17:49:20','648','2023-01-31 09:46:18',10,0),('1','64',258205,'MOORNING','2023-01-30','2023-01-31 11:00:56','2023-02-01 11:00:56','248',1838170.00,1838170.00,'248','2023-01-31 11:02:16','648','2023-01-31 15:07:42',10,0),('1','64',258206,'MOORNING','2023-01-31','2023-01-31 15:11:20','2023-02-01 15:11:20','248',0.00,0.00,'248','2023-01-31 15:15:14','648','2023-02-01 14:31:43',10,0),('1','64',258207,'MOORNING','2023-01-31','2023-02-01 17:14:15','2023-02-02 17:14:15','248',986250.00,986250.00,'248','2023-02-01 17:16:09','648','2023-02-01 20:27:02',10,0),('1','64',258208,'MOORNING','2023-02-01','2023-02-02 07:09:52','2023-02-03 07:09:52','248',2172680.00,2172680.00,'248','2023-02-02 09:25:45','648','2023-02-02 21:38:06',10,0),('1','64',258209,'AFTERNOON','2023-02-01','2023-02-02 22:49:29','2023-02-03 22:49:29','248',1300000.00,1300000.00,'248','2023-02-02 22:52:27','648','2023-02-03 09:44:04',10,0),('1','64',258210,'MOORNING','2023-02-02','2023-02-03 10:40:00','2023-02-04 10:40:00','248',401500.00,401500.00,'248','2023-02-03 11:53:59','648','2023-02-03 13:16:06',10,0),('1','64',258211,'AFTERNOON','2023-02-02','2023-02-03 14:24:28','2023-02-04 14:24:28','248',1308750.00,1308750.00,'248','2023-02-03 14:25:37','648','2023-02-03 15:08:50',10,0),('1','64',258212,'MOORNING','2023-02-03','2023-02-03 15:19:52','2023-02-04 15:19:52','248',606900.00,606900.00,'248','2023-02-03 15:23:01','648','2023-02-03 21:29:57',10,0),('1','64',258213,'AFTERNOON','2023-02-03','2023-02-04 05:06:05','2023-02-05 05:06:05','248',982520.00,982520.00,'248','2023-02-04 12:26:54','648','2023-02-04 15:58:08',10,0),('1','64',258214,'MOORNING','2023-02-04','2023-02-04 18:14:00','2023-02-05 18:14:00','248',517705.00,517705.00,'248','2023-02-04 18:17:35','648','2023-02-05 06:33:01',10,0),('1','64',258215,'AFTERNOON','2023-02-04','2023-02-05 09:07:41','2023-02-06 09:07:41','248',342860.00,342860.00,'248','2023-02-05 09:09:50','648','2023-02-05 15:37:29',10,0),('1','64',258216,'MOORNING','2023-02-05','2023-02-05 21:35:14','2023-02-06 21:35:14','248',120080.00,120080.00,'248','2023-02-05 21:36:40','648','2023-02-05 22:39:12',10,0),('1','64',258217,'CHANGING OF PRICE SHIFT ','2023-02-05','2023-02-05 23:14:28','2023-02-06 23:14:28','248',269410.00,269410.00,'248','2023-02-05 23:15:58','648','2023-02-06 10:17:23',10,0),('1','64',258218,'AFTERNOON ','2023-02-05','2023-02-06 10:30:13','2023-02-07 10:30:13','248',161190.00,161190.00,'248','2023-02-06 10:31:13','648','2023-02-06 13:14:59',10,0),('1','64',258219,'MOORNING ','2023-02-06','2023-02-06 13:58:43','2023-02-07 13:58:43','248',703080.00,703080.00,'248','2023-02-06 14:02:15','648','2023-02-06 16:52:31',10,0),('1','64',258220,'AFTERNOON ','2023-02-06','2023-02-06 22:01:38','2023-02-07 22:01:38','248',187110.00,187110.00,'248','2023-02-06 22:03:12','648','2023-02-07 13:56:49',10,0),('1','64',258221,'MOORNING ','2023-02-07','2023-02-07 19:46:35','2023-02-08 19:46:35','248',2800060.00,2800060.00,'248','2023-02-07 19:54:44','648','2023-02-08 08:01:02',10,0),('1','64',258222,'AFTERNOON ','2023-02-07','2023-02-08 10:32:56','2023-02-09 10:32:56','248',2001345.00,2001345.00,'248','2023-02-08 10:38:58','648','2023-02-08 13:22:20',10,0),('1','64',258223,'MOORNING ','2023-02-08','2023-02-08 13:31:22','2023-02-09 13:31:22','248',3542240.00,3542240.00,'248','2023-02-08 18:39:00','648','2023-02-08 21:16:54',10,0),('1','64',258224,'AFTERNOON ','2023-02-08','2023-02-09 09:16:45','2023-02-10 09:16:45','248',180890.00,180890.00,'248','2023-02-09 09:18:11','648','2023-02-09 09:30:41',10,0),('1','64',258225,'MOORNING  ','2023-02-09','2023-02-09 18:42:24','2023-02-10 18:42:24','248',2899700.00,2899700.00,'248','2023-02-09 18:44:39','648','2023-02-09 23:31:09',10,0),('1','64',258226,'AFTERNOON ','2023-02-09','2023-02-10 08:51:35','2023-02-11 08:51:35','248',1215395.00,1215395.00,'248','2023-02-10 08:59:15','648','2023-02-10 11:48:10',10,0),('1','64',258227,'MOORNING ','2023-02-10','2023-02-10 13:21:40','2023-02-11 13:21:40','248',605880.00,605880.00,'248','2023-02-10 13:22:20','648','2023-02-11 06:16:48',10,0),('1','64',258228,'AFTERNOON','2023-02-10','2023-02-11 09:12:06','2023-02-12 09:12:06','248',810000.00,810000.00,'248','2023-02-11 09:12:57','648','2023-02-11 10:36:14',10,0),('1','64',258229,'MOORNING','2023-02-11','2023-02-11 12:59:57','2023-02-12 12:59:57','248',537345.50,537345.50,'248','2023-02-11 13:01:08','648','2023-02-11 15:01:34',10,0),('1','64',258230,'AFTERNOON','2023-02-11','2023-02-11 21:21:57','2023-02-12 21:21:57','248',118285.00,118285.00,'248','2023-02-11 21:23:04','648','2023-02-12 09:53:10',10,0),('1','64',258231,'MOORNING  ','2023-02-12','2023-02-12 13:02:51','2023-02-13 13:02:51','248',232470.00,232470.00,'248','2023-02-12 14:03:12','648','2023-02-13 08:52:09',10,0),('1','64',258232,'AFTERNOON ','2023-02-12','2023-02-13 10:54:11','2023-02-14 10:54:11','248',218455.00,218455.00,'248','2023-02-13 10:56:14','648','2023-02-13 15:15:32',10,0),('1','64',258233,'MOORNING','2023-02-14','2023-02-14 00:13:09','2023-02-15 00:13:09','248',820210.00,820210.00,'248','2023-02-14 00:14:42','648','2023-02-14 06:20:11',10,0),('1','64',258234,'AFTERNOON ','2023-02-13','2023-02-14 11:17:03','2023-02-15 11:17:03','248',241070.00,241070.00,'248','2023-02-14 11:18:07','648','2023-02-14 13:48:50',10,0),('1','64',258235,'MOORNING ','2023-02-14','2023-02-14 14:19:25','2023-02-15 14:19:25','248',1170200.00,1170200.00,'248','2023-02-14 14:20:43','648','2023-02-14 14:23:14',10,0),('1','64',258236,'AFTERNOON ','2023-02-14','2023-02-15 08:44:49','2023-02-16 08:44:49','248',301045.00,301045.00,'248','2023-02-15 08:48:32','648','2023-02-15 10:13:58',10,0),('1','64',258237,'MOORNING','2023-02-15','2023-02-15 20:30:27','2023-02-16 20:30:27','248',1707970.00,1707970.00,'248','2023-02-15 20:33:17','648','2023-02-16 08:21:44',10,0),('1','64',258238,'MOORNING ','2023-02-16','2023-02-16 15:06:05','2023-02-17 15:06:05','248',560385.45,560385.45,'248','2023-02-16 15:10:00','648','2023-02-16 17:52:32',10,0),('1','64',258239,'AFTERNOON','2023-02-16','2023-02-17 09:50:05','2023-02-18 09:50:05','248',180610.00,180610.00,'248','2023-02-17 09:51:53','648','2023-02-17 11:34:27',10,0),('1','64',258240,'MOORNING ','2023-02-17','2023-02-17 19:34:24','2023-02-18 19:34:24','248',1451735.00,1451735.00,'248','2023-02-17 19:36:10','648','2023-02-19 06:37:23',10,0),('1','64',258241,'AFTERNOON','2023-02-17','2023-02-19 11:37:28','2023-02-20 11:37:28','248',112750.00,112750.00,'248','2023-02-19 11:38:30','648','2023-02-19 15:32:56',10,0),('1','64',258242,'MOORNING','2023-02-18','2023-02-19 15:33:38','2023-02-20 15:33:38','248',1903690.00,1903690.00,'248','2023-02-19 15:52:02','648','2023-02-19 16:04:05',10,0),('1','64',258243,'MOORNING ','2023-02-19','2023-02-19 20:30:10','2023-02-20 20:30:10','248',1549770.00,1549770.00,'248','2023-02-19 20:33:24','648','2023-02-19 22:47:01',10,0),('1','64',258244,'AFTERNOON','2023-02-19','2023-02-20 11:17:45','2023-02-21 11:17:45','248',773425.00,773425.00,'248','2023-02-20 11:47:56','648','2023-02-20 16:59:47',10,0),('1','64',258245,'MOORNING','2023-02-20','2023-02-20 17:20:11','2023-02-21 17:20:11','248',758320.00,758320.00,'248','2023-02-20 17:23:01','648','2023-02-20 22:44:23',10,0),('1','64',258246,'MOORNING','2023-02-20','2023-02-20 22:55:54','2023-02-21 22:55:54','248',0.00,0.00,'248','2023-02-20 22:58:08','648','2023-02-21 11:37:19',10,0),('1','64',258247,'MOORNING','2023-02-27','2023-02-27 11:11:14','2023-02-28 11:11:14','248',0.00,0.00,'248','2023-02-28 23:46:38','648','2023-03-01 09:55:17',10,0),('1','64',258248,'MOORNING','2023-02-27','2023-03-01 10:17:48','2023-03-02 10:17:48','248',8078250.00,8078250.00,'248','2023-03-01 10:23:37','648','2023-03-01 14:40:06',10,0),('1','64',258249,'AFTERNOON','2023-02-28','2023-03-02 08:17:33','2023-03-03 08:17:33','248',0.00,0.00,'248','2023-03-02 09:10:57','648','2023-03-02 12:23:33',10,0),('1','64',258250,'AFTERNOON','2023-02-28','2023-03-02 15:04:27','2023-03-03 15:04:27','248',8924815.00,8924815.00,'248','2023-03-02 15:07:54','648','2023-03-02 15:37:19',10,0),('1','64',258251,'MOORNING','2023-03-02','2023-03-02 16:50:38','2023-03-03 16:50:38','248',1152070.00,1152070.00,'248','2023-03-02 17:22:48','648','2023-03-02 23:28:18',10,0),('1','64',258252,'AFTERNOON','2023-03-02','2023-03-03 09:06:46','2023-03-04 09:06:46','248',2427280.00,2427280.00,'248','2023-03-03 09:11:53','648','2023-03-03 09:53:02',10,0),('1','64',258253,'MOORNING','2023-03-03','2023-03-03 15:26:26','2023-03-04 15:26:26','248',645660.00,645660.00,'248','2023-03-03 15:28:25','648','2023-03-04 06:32:51',10,0),('1','64',258254,'AFTERNOON ','2023-03-03','2023-03-04 09:40:31','2023-03-05 09:40:31','248',2636920.00,2636920.00,'248','2023-03-04 09:43:47','648','2023-03-04 11:25:20',10,0),('1','64',258255,'MOORNING ','2023-03-04','2023-03-04 15:13:37','2023-03-05 15:13:37','248',1971210.00,1971210.00,'248','2023-03-04 15:16:33','648','2023-03-05 07:18:37',10,0),('1','64',258256,'AFTERNOON ','2023-03-04','2023-03-05 15:59:56','2023-03-06 15:59:56','248',1576005.00,1576005.00,'248','2023-03-05 16:03:00','648','2023-03-06 22:54:05',10,0),('1','64',258257,'MOORNING ','2023-03-05','2023-03-07 06:15:09','2023-03-08 06:15:09','248',694810.00,694810.00,'248','2023-03-07 06:16:58','648','2023-03-07 09:27:48',10,0),('1','64',258258,'AFTERNOON ','2023-03-05','2023-03-07 12:29:17','2023-03-08 12:29:17','248',2333196.70,2333196.70,'248','2023-03-07 12:31:41','648','2023-03-07 13:39:41',10,0),('1','64',258259,'AFTERNOON ','2023-03-06','2023-03-07 13:53:44','2023-03-08 13:53:44','248',2341775.00,2341775.00,'248','2023-03-07 14:42:28','648','2023-03-07 15:01:09',10,0),('1','64',258260,'M00RNING ','2023-03-07','2023-03-07 16:50:57','2023-03-08 16:50:57','248',697480.00,697480.00,'248','2023-03-08 10:29:50','648','2023-03-08 16:58:13',10,0),('1','64',258261,'AFTERNOON ','2023-03-07','2023-03-08 18:23:59','2023-03-09 18:23:59','248',2126645.00,2126645.00,'248','2023-03-08 18:26:24','648','2023-03-08 21:28:25',10,0),('1','64',258262,'MOORNING ','2023-03-08','2023-03-09 07:28:16','2023-03-10 07:28:16','248',1722290.00,1722290.00,'248','2023-03-09 10:40:45','648','2023-03-09 11:55:03',10,0),('1','64',258263,'AFTERNOON ','2023-03-08','2023-03-09 11:58:12','2023-03-10 11:58:12','248',217855.00,217855.00,'248','2023-03-09 12:00:00','648','2023-03-09 16:23:09',10,0),('1','64',258264,'AFTERNOON ','2023-03-09','2023-03-10 07:52:12','2023-03-11 07:52:12','248',3393515.00,3393515.00,'248','2023-03-10 07:56:52','648','2023-03-10 09:14:24',10,0),('1','64',258265,'MOORNING ','2023-03-10','2023-03-10 12:42:42','2023-03-11 12:42:42','248',1318550.00,1318550.00,'248','2023-03-10 17:39:49','648','2023-03-11 08:14:03',10,0),('1','64',258266,'AFTERNOON ','2023-03-10','2023-03-11 08:51:38','2023-03-12 08:51:38','248',2104575.00,2104575.00,'248','2023-03-11 08:53:52','648','2023-03-11 10:15:27',10,0),('1','64',258267,'AFTERNOON SHIFT','2023-03-11','2023-03-11 18:07:51','2023-03-12 18:07:51','248',2795070.00,2795070.00,'248','2023-03-12 08:29:09','648','2023-03-12 21:39:57',10,0),('1','64',258268,'MORNING SHIFT','2023-03-12','2023-03-13 06:57:01','2023-03-14 06:57:01','248',2229195.00,2229195.00,'248','2023-03-13 07:01:07','648','2023-03-13 07:03:48',10,0),('1','64',258269,'AFTERNOON  SHIFT','2023-03-12','2023-03-13 07:31:28','2023-03-14 07:31:28','248',1420650.00,1420650.00,'248','2023-03-13 07:44:29','648','2023-03-13 08:05:12',10,0),('1','64',258270,'MORNING SHIFT','2023-03-13','2023-03-13 09:32:56','2023-03-14 09:32:56','248',1297190.00,1297190.00,'248','2023-03-13 14:07:23','648','2023-03-13 17:42:42',10,0),('1','64',258271,'AFTERNOON  SHIFT','2023-03-13','2023-03-14 07:47:15','2023-03-15 07:47:15','248',273415.00,273415.00,'248','2023-03-14 07:49:33','648','2023-03-14 08:23:49',10,0),('1','64',258272,'MORNING SHIFT','2023-03-14','2023-03-14 14:08:35','2023-03-15 14:08:35','248',613040.00,613040.00,'248','2023-03-14 14:24:43','648','2023-03-14 18:21:47',10,0),('1','64',258273,'AFTERNOON  SHIFT','2023-03-14','2023-03-15 06:22:21','2023-03-16 06:22:21','248',343560.00,343560.00,'248','2023-03-15 07:03:57','648','2023-03-15 07:06:02',10,0),('1','64',258274,'MORNING SHIFT','2023-03-15','2023-03-15 13:06:35','2023-03-16 13:06:35','248',0.00,0.00,'248','2023-03-15 15:33:08','648','2023-03-15 18:04:51',10,0),('1','64',258275,'AFTERNOON  SHIFT','2023-03-15','2023-03-16 07:37:08','2023-03-17 07:37:08','248',3482640.00,3482640.00,'248','2023-03-16 09:11:45','975','2023-03-16 11:51:33',10,0),('1','64',258276,'MORNING SHIFT','2023-03-16','2023-03-16 14:12:29','2023-03-17 14:12:29','248',3002575.00,3002575.00,'248','2023-03-16 14:16:55','648','2023-03-16 16:17:23',10,0),('1','64',258277,'AFTERNOON  SHIFT','2023-03-17','2023-03-17 07:16:30','2023-03-18 07:16:30','248',1365345.00,1365345.00,'248','2023-03-17 08:07:54','648','2023-03-17 08:20:59',10,0),('1','64',258278,'MORNING SHIFT','2023-03-17','2023-03-17 13:36:48','2023-03-18 13:36:48','248',2512060.00,2512060.00,'248','2023-03-17 15:04:39','648','2023-03-17 21:20:06',10,0),('1','64',258279,'AFTERNOON  SHIFT','2023-03-17','2023-03-19 17:40:52','2023-03-20 17:40:52','248',225150.00,225150.00,'248','2023-03-19 17:42:57','648','2023-03-20 08:04:29',10,0),('1','64',258280,'AFTERNOON  SHIFT','2023-03-19','2023-03-20 08:06:51','2023-03-21 08:06:51','248',492170.00,492170.00,'248','2023-03-20 08:47:21','648','2023-03-20 13:19:54',10,0),('1','64',258281,'AFTERNOON  SHIFT','2023-03-20','2023-03-20 14:24:21','2023-03-21 14:24:21','248',1476045.00,1476045.00,'248','2023-03-20 14:36:30','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4912665 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','64','536','38985',787498,'1480','201',76925.00,76925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','38985',787499,'1481','201',66699.00,66699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','38985',787500,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','38985',787501,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','38985',787502,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','38985',787503,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','38985',787504,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','38985',787505,'1487','201',122597.00,122597.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','38985',787506,'1488','202',27668.00,29672.00,2004.00,390780.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','38985',787507,'1489','202',127555.00,129465.00,1910.00,372450.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','38985',787508,'1490','203',189644.09,189753.35,109.26,20759.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','39077',789302,'1480','201',76925.00,76925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39077',789303,'1481','201',66699.00,66699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39077',789304,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39077',789305,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39077',789306,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39077',789307,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39077',789308,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39077',789309,'1487','201',122597.00,122597.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39077',789310,'1488','202',29672.00,30663.00,991.00,193245.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39077',789311,'1489','202',129465.00,130391.00,926.00,180570.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39077',789312,'1490','203',189753.35,189753.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39078',789313,'1480','201',76925.00,76925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39078',789314,'1481','201',66699.00,66699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39078',789315,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39078',789316,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39078',789317,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39078',789318,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39078',789319,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39078',789320,'1487','201',122597.00,122597.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39078',789321,'1488','202',30663.00,31199.00,536.00,107200.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39078',789322,'1489','202',130391.00,130887.00,496.00,99200.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39078',789323,'1490','203',189753.35,189894.00,140.65,26723.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','39227',792407,'1480','201',76925.00,76925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39227',792408,'1481','201',66699.00,66699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39227',792409,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39227',792410,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39227',792411,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39227',792412,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39227',792413,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39227',792414,'1487','201',122597.00,122750.00,153.00,22185.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39227',792415,'1488','202',31199.00,32104.00,905.00,181000.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39227',792416,'1489','202',130887.00,132324.00,1437.00,287400.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39227',792417,'1490','203',189894.00,190112.31,218.31,41478.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','39230',792456,'1480','201',76925.00,76925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39230',792457,'1481','201',66699.00,66699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39230',792458,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39230',792459,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39230',792460,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39230',792461,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39230',792462,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39230',792463,'1487','201',122750.00,122781.00,31.00,4495.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39230',792464,'1488','202',32104.00,33222.00,1118.00,223600.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39230',792465,'1489','202',132324.00,133772.00,1448.00,289600.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39230',792466,'1490','203',190112.31,190243.84,131.53,24990.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','39291',793602,'1480','201',76925.00,76925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39291',793603,'1481','201',66699.00,66699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39291',793604,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39291',793605,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39291',793606,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39291',793607,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39291',793608,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39291',793609,'1487','201',122781.00,122781.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39291',793610,'1488','202',33222.00,33625.00,403.00,80600.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39291',793611,'1489','202',133772.00,134279.00,507.00,101400.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39291',793612,'1490','203',190243.84,190243.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39293',793635,'1480','201',76925.00,76925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39293',793636,'1481','201',66699.00,66699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39293',793637,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39293',793638,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39293',793639,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39293',793640,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39293',793641,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39293',793642,'1487','201',122781.00,123004.00,223.00,32335.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39293',793643,'1488','202',33625.00,34576.00,951.00,185445.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39293',793644,'1489','202',134279.00,135923.00,1644.00,320580.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39293',793645,'1490','203',190243.84,190459.19,215.35,40916.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','39369',795066,'1480','201',76925.00,76925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39369',795067,'1481','201',66699.00,66699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39369',795068,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39369',795069,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39369',795070,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39369',795071,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39369',795072,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39369',795073,'1487','201',123004.00,123097.00,93.00,13485.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39369',795074,'1488','202',34576.00,36361.00,1785.00,348075.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39369',795075,'1489','202',135923.00,137764.00,1841.00,358995.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39369',795076,'1490','203',190459.19,190629.62,170.43,32381.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','39497',797526,'1480','201',76925.00,81508.00,4583.00,664535.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39497',797527,'1481','201',66699.00,72378.00,5679.00,823455.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39497',797528,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39497',797529,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39497',797530,'1484','201',87596.00,87596.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39497',797531,'1485','201',47675.00,47675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39497',797532,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39497',797533,'1487','201',123097.00,123097.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39497',797534,'1488','202',36361.00,39733.00,3372.00,657540.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39497',797535,'1489','202',137764.00,139780.00,2016.00,393120.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39497',797536,'1490','203',190629.62,190850.19,220.57,41908.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','39593',799328,'1480','201',81508.00,83700.00,2182.00,316390.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','39593',799329,'1481','201',72378.00,74918.00,2530.00,366850.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','39593',799330,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39593',799331,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39593',799332,'1484','201',87596.00,90052.00,2446.00,354670.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','39593',799333,'1485','201',47675.00,50233.00,2548.00,369460.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','39593',799334,'1486','201',107762.00,107762.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39593',799335,'1487','201',123097.00,123097.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39593',799336,'1488','202',39733.00,39733.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39593',799337,'1489','202',139780.00,140345.00,565.00,110175.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39593',799338,'1490','203',190850.19,191023.73,163.54,31072.60,0.00,0.00,10.00,0.00,0.00),('1','64','536','39829',804298,'1480','201',83700.00,83700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39829',804299,'1481','201',74918.00,74918.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39829',804300,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39829',804301,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39829',804302,'1484','201',90052.00,94454.00,4402.00,638290.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39829',804303,'1485','201',50233.00,55052.00,4819.00,698755.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39829',804304,'1486','201',107762.00,108165.00,403.00,58435.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39829',804305,'1487','201',123097.00,123405.00,308.00,44660.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39829',804306,'1488','202',39733.00,39733.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39829',804307,'1489','202',140345.00,140794.00,449.00,87555.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39829',804308,'1490','203',191023.73,191205.60,181.87,34555.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','39956',806927,'1480','201',83700.00,83700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39956',806928,'1481','201',74918.00,74918.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39956',806929,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39956',806930,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39956',806931,'1484','201',94454.00,94454.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39956',806932,'1485','201',55052.00,55052.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39956',806933,'1486','201',108165.00,108165.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39956',806934,'1487','201',123405.00,123405.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39956',806935,'1488','202',39733.00,39733.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39956',806936,'1489','202',140794.00,140794.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39956',806937,'1490','203',191205.60,191205.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39957',806938,'1480','201',83700.00,90335.00,6635.00,962075.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39957',806939,'1481','201',74918.00,81752.00,6834.00,990930.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39957',806940,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','39957',806941,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39957',806942,'1484','201',94454.00,94876.00,422.00,61190.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','39957',806943,'1485','201',55052.00,58523.00,3471.00,503295.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39957',806944,'1486','201',108165.00,112456.00,4291.00,622195.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','39957',806945,'1487','201',123405.00,128638.00,5233.00,758785.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39957',806946,'1488','202',39733.00,39733.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','39957',806947,'1489','202',140794.00,140930.00,136.00,26520.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','39957',806948,'1490','203',191205.60,191425.53,219.93,41786.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','40048',808823,'1480','201',90335.00,94851.00,4516.00,654820.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40048',808824,'1481','201',81752.00,85709.00,3957.00,573765.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40048',808825,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40048',808826,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40048',808827,'1484','201',94876.00,99186.00,4310.00,624950.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40048',808828,'1485','201',58523.00,64562.00,6039.00,875655.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40048',808829,'1486','201',112456.00,117212.00,4756.00,689620.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40048',808830,'1487','201',128638.00,134141.00,5503.00,797935.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40048',808831,'1488','202',39733.00,39733.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40048',808832,'1489','202',140930.00,140930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','40048',808833,'1490','203',191425.53,191722.24,296.71,56374.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','40096',809751,'1480','201',94851.00,100639.00,5788.00,839260.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40096',809752,'1481','201',85709.00,91038.00,5329.00,772705.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40096',809753,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40096',809754,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40096',809755,'1484','201',99186.00,103027.00,3841.00,556945.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40096',809756,'1485','201',64562.00,67879.00,3317.00,480965.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40096',809757,'1486','201',117212.00,120099.00,2887.00,418615.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40096',809758,'1487','201',134141.00,138154.00,4013.00,581885.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40096',809759,'1488','202',39733.00,40472.00,739.00,144105.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40096',809760,'1489','202',140930.00,140979.00,49.00,9555.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','40096',809761,'1490','203',191722.24,192064.51,342.27,65031.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','40632',820538,'1480','201',100639.00,100639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40632',820539,'1481','201',91038.00,92524.00,1486.00,215470.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40632',820540,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40632',820541,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40632',820542,'1484','201',103027.00,109445.00,6418.00,930610.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40632',820543,'1485','201',67879.00,73824.00,5945.00,862025.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40632',820544,'1486','201',120099.00,123904.00,3805.00,551725.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40632',820545,'1487','201',138154.00,143187.00,5033.00,729785.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40632',820546,'1488','202',40472.00,41628.00,1156.00,225420.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40632',820547,'1489','202',140979.00,142526.00,1547.00,301665.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','40632',820548,'1490','203',192064.51,192358.71,294.20,55898.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40634',820568,'1480','201',100639.00,104301.00,3662.00,530990.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40634',820569,'1481','201',92524.00,96866.00,4342.00,629590.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40634',820570,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40634',820571,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40634',820572,'1484','201',109445.00,114727.00,5282.00,765890.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40634',820573,'1485','201',73824.00,79267.00,5443.00,789235.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40634',820574,'1486','201',123904.00,129014.00,5110.00,740950.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40634',820575,'1487','201',143187.00,147027.00,3840.00,556800.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40634',820576,'1488','202',41628.00,42771.00,1143.00,222885.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40634',820577,'1489','202',142526.00,145203.00,2677.00,522015.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','40634',820578,'1490','203',192358.71,192546.45,187.74,35670.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','40636',820593,'1480','201',104301.00,108645.00,4344.00,629880.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40636',820594,'1481','201',96866.00,102139.00,5273.00,764585.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40636',820595,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40636',820596,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40636',820597,'1484','201',114727.00,118654.00,3927.00,569415.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40636',820598,'1485','201',79267.00,83548.00,4281.00,620745.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40636',820599,'1486','201',129014.00,131108.00,2094.00,303630.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40636',820600,'1487','201',147027.00,151282.00,4255.00,616975.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40636',820601,'1488','202',42771.00,43824.00,1053.00,205335.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40636',820602,'1489','202',145203.00,147385.00,2182.00,425490.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','40636',820603,'1490','203',192546.45,192744.57,198.12,37642.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','40638',820633,'1480','201',108645.00,114075.00,5430.00,787350.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40638',820634,'1481','201',102139.00,108137.00,5998.00,869710.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40638',820635,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40638',820636,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40638',820637,'1484','201',118654.00,118654.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40638',820638,'1485','201',83548.00,88511.00,4963.00,719635.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40638',820639,'1486','201',131108.00,134006.00,2898.00,420210.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40638',820640,'1487','201',151282.00,155175.00,3893.00,564485.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40638',820641,'1488','202',43824.00,45489.00,1665.00,324675.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40638',820642,'1489','202',147385.00,149970.00,2585.00,504075.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','40638',820643,'1490','203',192744.57,192970.36,225.79,42900.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','40687',821612,'1480','201',114075.00,117640.00,3565.00,516925.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40687',821613,'1481','201',108137.00,111933.00,3796.00,550420.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40687',821614,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40687',821615,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40687',821616,'1484','201',118654.00,120012.00,1358.00,196910.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40687',821617,'1485','201',88511.00,89590.00,1079.00,156455.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40687',821618,'1486','201',134006.00,137370.00,3364.00,487780.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40687',821619,'1487','201',155175.00,159349.00,4174.00,605230.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40687',821620,'1488','202',45489.00,45489.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40687',821621,'1489','202',149970.00,149970.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','40687',821622,'1490','203',192970.36,193217.88,247.52,47028.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','40794',823766,'1480','201',117640.00,121141.00,3501.00,507645.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40794',823767,'1481','201',111933.00,115648.00,3715.00,538675.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40794',823768,'1482','201',33232.00,33232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','40794',823769,'1483','201',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40794',823770,'1484','201',120012.00,124311.00,4299.00,623355.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','40794',823771,'1485','201',89590.00,94382.00,4792.00,694840.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40794',823772,'1486','201',137370.00,140351.00,2981.00,432245.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','40794',823773,'1487','201',159349.00,162614.00,3265.00,473425.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40794',823774,'1488','202',45489.00,45489.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','40794',823775,'1489','202',149970.00,151232.00,1262.00,246090.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','40794',823776,'1490','203',193217.88,193549.84,331.96,63072.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','41112',830352,'1480','201',121141.00,121491.00,329.60,47792.00,0.00,0.00,20.40,0.00,0.00),('1','64','536','41112',830353,'1481','201',115648.00,116351.00,682.60,98977.00,0.00,0.00,20.40,0.00,0.00),('1','64','536','41112',830354,'1482','201',33232.00,33246.00,14.00,2030.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41112',830355,'1483','201',45.00,142.00,60.30,8743.50,0.00,0.00,36.70,0.00,0.00),('1','64','537','41112',830356,'1484','201',124311.00,129221.00,4910.00,711950.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41112',830357,'1485','201',94382.00,98631.00,4228.60,613147.00,0.00,0.00,20.40,0.00,0.00),('1','64','538','41112',830358,'1486','201',140351.00,142873.00,2522.00,365690.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41112',830359,'1487','201',162614.00,165964.00,3329.60,482792.00,0.00,0.00,20.40,0.00,0.00),('1','64','539','41112',830360,'1488','202',45489.00,45489.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41112',830361,'1489','202',151232.00,151329.00,97.00,18915.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','41112',830362,'1490','203',193549.84,193739.25,189.41,35987.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','41150',831090,'1480','201',121491.00,123779.00,2288.00,331760.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41150',831091,'1481','201',116351.00,118767.00,2416.00,350320.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41150',831092,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41150',831093,'1483','201',142.00,142.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41150',831094,'1484','201',129221.00,134267.00,5046.00,731670.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41150',831095,'1485','201',98631.00,104522.00,5891.00,854195.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41150',831096,'1486','201',142873.00,144727.00,1854.00,268830.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41150',831097,'1487','201',165964.00,167693.00,1729.00,250705.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41150',831098,'1488','202',45489.00,45489.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41150',831099,'1489','202',151329.00,151730.00,401.00,78195.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','41150',831100,'1490','203',193739.25,194005.01,265.76,50494.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','41151',831101,'1480','201',123779.00,127687.00,3908.00,566660.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41151',831102,'1481','201',118767.00,123855.00,5088.00,737760.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41151',831103,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41151',831104,'1483','201',142.00,142.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41151',831105,'1484','201',134267.00,137522.00,3255.00,471975.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41151',831106,'1485','201',104522.00,108049.00,3527.00,511415.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41151',831107,'1486','201',144727.00,146706.00,1979.00,286955.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41151',831108,'1487','201',167693.00,170548.00,2855.00,413975.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41151',831109,'1488','202',45489.00,45489.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41151',831110,'1489','202',151730.00,151730.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','41151',831111,'1490','203',194005.01,194237.30,232.29,44135.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','41319',834477,'1480','201',127687.00,131788.00,4101.00,594645.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41319',834478,'1481','201',123855.00,130628.00,6773.00,982085.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41319',834479,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41319',834480,'1483','201',142.00,142.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41319',834481,'1484','201',137522.00,139089.00,1567.00,227215.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41319',834482,'1485','201',108049.00,109732.00,1683.00,244035.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41319',834483,'1486','201',146706.00,150721.00,4015.00,582175.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41319',834484,'1487','201',170548.00,174325.00,3777.00,547665.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41319',834485,'1488','202',45489.00,45489.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41319',834486,'1489','202',151730.00,152139.00,409.00,79755.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','41319',834487,'1490','203',194237.30,194357.06,119.76,22754.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','41352',835080,'1480','201',131788.00,135646.00,3848.00,557960.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','41352',835081,'1481','201',130628.00,134831.00,4193.00,607985.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','41352',835082,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41352',835083,'1483','201',142.00,142.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41352',835084,'1484','201',139089.00,140837.00,1738.00,252010.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','41352',835085,'1485','201',109732.00,112857.00,3115.00,451675.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','41352',835086,'1486','201',150721.00,154058.00,3327.00,482415.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','41352',835087,'1487','201',174325.00,178857.00,4522.00,655690.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','41352',835088,'1488','202',45489.00,46907.00,1408.00,274560.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','41352',835089,'1489','202',152139.00,153750.00,1601.00,312195.00,0.00,0.00,10.00,0.00,0.00),('1','64','540','41352',835090,'1490','203',194357.06,194530.00,162.94,30958.60,0.00,0.00,10.00,0.00,0.00),('1','64','536','41693',841988,'1480','201',135646.00,135646.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41693',841989,'1481','201',134831.00,134831.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41693',841990,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41693',841991,'1483','201',142.00,142.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41693',841992,'1484','201',140837.00,146366.00,5529.00,801705.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41693',841993,'1485','201',112857.00,117642.00,4785.00,693825.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41693',841994,'1486','201',154058.00,157120.00,3062.00,443990.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41693',841995,'1487','201',178857.00,183051.00,4194.00,608130.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41693',841996,'1488','202',46907.00,48783.00,1876.00,365820.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41693',841997,'1489','202',153750.00,154596.00,846.00,164970.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','41693',841998,'1490','203',194530.00,194696.28,166.28,31593.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','41694',841999,'1480','201',135646.00,135646.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41694',842000,'1481','201',134831.00,134831.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41694',842001,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41694',842002,'1483','201',142.00,2176.00,2034.00,294930.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41694',842003,'1484','201',146366.00,151027.00,4661.00,675845.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41694',842004,'1485','201',117642.00,124075.00,6433.00,932785.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41694',842005,'1486','201',157120.00,161055.00,3935.00,570575.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41694',842006,'1487','201',183051.00,186819.00,3768.00,546360.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41694',842007,'1488','202',48783.00,49939.00,1156.00,225420.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41694',842008,'1489','202',154596.00,157003.00,2407.00,469365.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','41694',842009,'1490','203',194696.28,194867.15,170.87,32465.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','41696',842027,'1480','201',135646.00,139041.00,3395.00,492275.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41696',842028,'1481','201',134831.00,139046.00,4215.00,611175.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41696',842029,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41696',842030,'1483','201',2176.00,5013.00,2837.00,411365.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41696',842031,'1484','201',151027.00,152755.00,1728.00,250560.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41696',842032,'1485','201',124075.00,126467.00,2392.00,346840.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41696',842033,'1486','201',161055.00,163851.00,2796.00,405420.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41696',842034,'1487','201',186819.00,190137.00,3318.00,481110.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41696',842035,'1488','202',49939.00,49970.00,31.00,6045.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41696',842036,'1489','202',157003.00,160123.00,3120.00,608400.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','41696',842037,'1490','203',194867.15,195059.94,192.79,36630.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','41811',844358,'1480','201',139041.00,142215.00,3174.00,460230.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41811',844359,'1481','201',139046.00,142892.00,3846.00,557670.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41811',844360,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41811',844361,'1483','201',5013.00,7798.00,2785.00,403825.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41811',844362,'1484','201',152755.00,155069.00,2314.00,335530.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41811',844363,'1485','201',126467.00,129062.00,2595.00,376275.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41811',844364,'1486','201',163851.00,165395.00,1544.00,223880.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41811',844365,'1487','201',190137.00,193002.00,2865.00,415425.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41811',844366,'1488','202',49970.00,51767.00,1794.00,349830.00,0.00,0.00,3.00,0.00,0.00),('1','64','539','41811',844367,'1489','202',160123.00,162422.00,2284.00,445380.00,0.00,0.00,15.00,0.00,0.00),('1','64','540','41811',844368,'1490','203',195059.94,195270.42,210.48,39991.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','41968',847540,'1480','201',142215.00,145117.00,2902.00,420790.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41968',847541,'1481','201',142892.00,146169.00,3277.00,475165.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41968',847542,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','41968',847543,'1483','201',7798.00,12424.00,4626.00,670770.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41968',847544,'1484','201',155069.00,155667.00,598.00,86710.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','41968',847545,'1485','201',129062.00,131360.00,2298.00,333210.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41968',847546,'1486','201',165395.00,167615.00,2220.00,321900.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','41968',847547,'1487','201',193002.00,195173.00,2171.00,314795.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41968',847548,'1488','202',51767.00,53045.00,1278.00,249210.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','41968',847549,'1489','202',162422.00,164475.00,2053.00,400335.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','41968',847550,'1490','203',195270.42,195443.91,173.49,32963.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','42102',850197,'1480','201',145117.00,148519.00,3402.00,493290.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42102',850198,'1481','201',146169.00,150876.00,4707.00,682515.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42102',850199,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42102',850200,'1483','201',12424.00,18161.00,5737.00,831865.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42102',850201,'1484','201',155667.00,155667.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42102',850202,'1485','201',131360.00,131360.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42102',850203,'1486','201',167615.00,170350.00,2735.00,396575.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42102',850204,'1487','201',195173.00,200871.00,5698.00,826210.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42102',850205,'1488','202',53045.00,55392.00,2347.00,457665.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42102',850206,'1489','202',164475.00,165862.00,1387.00,270465.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','42102',850207,'1490','203',195443.91,195749.51,305.60,58064.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42104',850236,'1480','201',148519.00,149017.00,498.00,72210.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42104',850237,'1481','201',150876.00,156053.00,5177.00,750665.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42104',850238,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42104',850239,'1483','201',18161.00,21168.00,3007.00,436015.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42104',850240,'1484','201',155667.00,158913.00,3246.00,470670.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42104',850241,'1485','201',131360.00,134668.00,3308.00,479660.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42104',850242,'1486','201',170350.00,172748.00,2398.00,347710.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42104',850243,'1487','201',200871.00,204036.00,3165.00,458925.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42104',850244,'1488','202',55392.00,55414.00,22.00,4290.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42104',850245,'1489','202',165862.00,170658.00,4796.00,935220.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','42104',850246,'1490','203',195749.51,196025.03,275.52,52348.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','42461',857133,'1480','201',149017.00,151308.00,2271.00,329295.00,0.00,0.00,20.00,0.00,0.00),('1','64','536','42461',857134,'1481','201',156053.00,160109.00,4036.00,585220.00,0.00,0.00,20.00,0.00,0.00),('1','64','536','42461',857135,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42461',857136,'1483','201',21168.00,23548.00,2320.00,336400.00,0.00,0.00,60.00,0.00,0.00),('1','64','537','42461',857137,'1484','201',158913.00,160816.00,1893.00,274485.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','42461',857138,'1485','201',134668.00,137145.00,2467.00,357715.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','42461',857139,'1486','201',172748.00,172873.00,105.00,15225.00,0.00,0.00,20.00,0.00,0.00),('1','64','538','42461',857140,'1487','201',204036.00,207378.00,3322.00,481690.00,0.00,0.00,20.00,0.00,0.00),('1','64','539','42461',857141,'1488','202',55414.00,55862.00,428.00,83460.00,0.00,0.00,20.00,0.00,0.00),('1','64','539','42461',857142,'1489','202',170658.00,173055.00,2377.00,463515.00,0.00,0.00,20.00,0.00,0.00),('1','64','540','42461',857143,'1490','203',196025.03,196157.47,132.44,25163.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','42462',857144,'1480','201',151308.00,155070.00,3762.00,545490.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42462',857145,'1481','201',160109.00,165545.00,5436.00,788220.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42462',857146,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42462',857147,'1483','201',23548.00,23548.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42462',857148,'1484','201',160816.00,161740.00,924.00,133980.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42462',857149,'1485','201',137145.00,140962.00,3817.00,553465.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42462',857150,'1486','201',172873.00,174960.00,2087.00,302615.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42462',857151,'1487','201',207378.00,210907.00,3529.00,511705.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42462',857152,'1488','202',55862.00,57557.00,1695.00,330525.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42462',857153,'1489','202',173055.00,174385.00,1330.00,259350.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','42462',857154,'1490','203',196157.47,196416.69,259.22,49251.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','42463',857155,'1480','201',155070.00,158330.00,3260.00,472700.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42463',857156,'1481','201',165545.00,169965.00,4420.00,640900.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42463',857157,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42463',857158,'1483','201',23548.00,23548.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42463',857159,'1484','201',161740.00,164853.00,3113.00,451385.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42463',857160,'1485','201',140962.00,144682.00,3720.00,539400.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42463',857161,'1486','201',174960.00,175423.00,463.00,67135.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42463',857162,'1487','201',210907.00,214889.00,3982.00,577390.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42463',857163,'1488','202',57557.00,59021.00,1464.00,285480.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42463',857164,'1489','202',174385.00,176969.00,2584.00,503880.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','42463',857165,'1490','203',196416.69,196671.10,254.41,48337.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','42741',862862,'1480','201',158330.00,162451.00,4121.00,597545.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42741',862863,'1481','201',169965.00,174093.00,4128.00,598560.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42741',862864,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42741',862865,'1483','201',23548.00,23548.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42741',862866,'1484','201',164853.00,167124.00,2271.00,329295.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42741',862867,'1485','201',144682.00,147732.00,3050.00,442250.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42741',862868,'1486','201',175423.00,178007.00,2584.00,374680.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42741',862869,'1487','201',214889.00,218647.00,3758.00,544910.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42741',862870,'1488','202',59021.00,59174.00,153.00,29835.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42741',862871,'1489','202',176969.00,181035.00,4066.00,792870.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','42741',862872,'1490','203',196671.10,196912.05,240.95,45780.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','42961',867289,'1480','201',162451.00,164892.00,2421.00,351045.00,0.00,0.00,20.00,0.00,0.00),('1','64','536','42961',867290,'1481','201',174093.00,176764.00,2651.00,384395.00,0.00,0.00,20.00,0.00,0.00),('1','64','536','42961',867291,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42961',867292,'1483','201',23548.00,27410.00,3862.00,559990.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42961',867293,'1484','201',167124.00,167124.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42961',867294,'1485','201',147732.00,147732.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42961',867295,'1486','201',178007.00,182159.00,4152.00,602040.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42961',867296,'1487','201',218647.00,224601.00,5954.00,863330.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42961',867297,'1488','202',59174.00,61771.00,2567.00,500565.00,0.00,0.00,30.00,0.00,0.00),('1','64','539','42961',867298,'1489','202',181035.00,183701.00,2646.00,515970.00,0.00,0.00,20.00,0.00,0.00),('1','64','540','42961',867299,'1490','203',196912.05,197198.03,285.98,54336.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','42964',867380,'1480','201',164892.00,167416.00,2524.00,365980.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42964',867381,'1481','201',176764.00,179336.00,2572.00,372940.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42964',867382,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','42964',867383,'1483','201',27410.00,30675.00,3265.00,473425.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42964',867384,'1484','201',167124.00,169061.00,1937.00,280865.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','42964',867385,'1485','201',147732.00,150186.00,2454.00,355830.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42964',867386,'1486','201',182159.00,185831.00,3672.00,532440.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','42964',867387,'1487','201',224601.00,227740.00,3139.00,455155.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42964',867388,'1488','202',61771.00,61971.00,200.00,39000.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','42964',867389,'1489','202',183701.00,183701.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','42964',867390,'1490','203',197198.03,197491.12,293.09,55687.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','43153',871157,'1480','201',167416.00,170895.00,3479.00,504455.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43153',871158,'1481','201',179336.00,182169.00,2833.00,410785.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43153',871159,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43153',871160,'1483','201',30675.00,34368.00,3693.00,535485.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43153',871161,'1484','201',169061.00,170537.00,1476.00,214020.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43153',871162,'1485','201',150186.00,153613.00,3427.00,496915.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43153',871163,'1486','201',185831.00,187961.00,2130.00,308850.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43153',871164,'1487','201',227740.00,230851.00,3111.00,451095.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43153',871165,'1488','202',61971.00,62913.00,942.00,183690.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43153',871166,'1489','202',183701.00,184819.00,1118.00,218010.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','43153',871167,'1490','203',197491.12,197779.03,287.91,54702.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','43154',871168,'1480','201',170895.00,173650.00,2755.00,399475.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43154',871169,'1481','201',182169.00,185468.00,3299.00,478355.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43154',871170,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43154',871171,'1483','201',34368.00,37882.00,3514.00,509530.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43154',871172,'1484','201',170537.00,172930.00,2393.00,346985.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43154',871173,'1485','201',153613.00,155863.00,2250.00,326250.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43154',871174,'1486','201',187961.00,189728.00,1767.00,256215.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43154',871175,'1487','201',230851.00,232622.00,1771.00,256795.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43154',871176,'1488','202',62913.00,63721.00,808.00,157560.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43154',871177,'1489','202',184819.00,187693.00,2874.00,560430.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','43154',871178,'1490','203',197779.03,197941.83,162.80,30932.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43287',873811,'1480','201',173650.00,174118.00,468.00,67860.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43287',873812,'1481','201',185468.00,186413.00,945.00,137025.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43287',873813,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43287',873814,'1483','201',37882.00,38649.00,767.00,111215.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43287',873815,'1484','201',172930.00,173447.00,517.00,74965.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43287',873816,'1485','201',155863.00,155875.00,12.00,1740.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43287',873817,'1486','201',189728.00,190409.00,681.00,98745.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43287',873818,'1487','201',232622.00,232846.00,224.00,32480.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43287',873819,'1488','202',63721.00,63721.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43287',873820,'1489','202',187693.00,187693.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','43287',873821,'1490','203',197941.83,197941.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43288',873822,'1480','201',174118.00,176269.00,2151.00,307593.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43288',873823,'1481','201',186413.00,188702.00,2289.00,327327.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43288',873824,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43288',873825,'1483','201',38649.00,40918.00,2269.00,324467.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43288',873826,'1484','201',173447.00,175331.00,1884.00,269412.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43288',873827,'1485','201',155875.00,157758.00,1883.00,269269.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43288',873828,'1486','201',190409.00,192201.00,1792.00,256256.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43288',873829,'1487','201',232846.00,234726.00,1880.00,268840.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43288',873830,'1488','202',63721.00,66560.00,2839.00,553605.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43288',873831,'1489','202',187693.00,189921.00,2228.00,434460.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','43288',873832,'1490','203',197941.83,198104.02,162.19,30816.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','43291',873878,'1480','201',176269.00,180395.00,4126.00,590018.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43291',873879,'1481','201',188702.00,192174.00,3472.00,496496.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43291',873880,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43291',873881,'1483','201',40918.00,44061.00,3143.00,449449.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43291',873882,'1484','201',175331.00,175331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43291',873883,'1485','201',157758.00,161888.00,4130.00,590590.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43291',873884,'1486','201',192201.00,195489.00,3288.00,470184.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43291',873885,'1487','201',234726.00,236225.00,1499.00,214357.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43291',873886,'1488','202',66560.00,68950.00,2390.00,466050.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43291',873887,'1489','202',189921.00,192440.00,2519.00,491205.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','43291',873888,'1490','203',198104.02,198334.62,230.60,43814.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43302',874084,'1480','201',180395.00,183815.00,3420.00,489060.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43302',874085,'1481','201',192174.00,195833.00,3659.00,523237.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43302',874086,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43302',874087,'1483','201',44061.00,46016.00,1955.00,279565.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43302',874088,'1484','201',175331.00,178198.00,2867.00,409981.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43302',874089,'1485','201',161888.00,165110.00,3222.00,460746.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43302',874090,'1486','201',195489.00,197745.00,2256.00,322608.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43302',874091,'1487','201',236225.00,238850.00,2625.00,375375.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43302',874092,'1488','202',68950.00,70688.00,1718.00,335010.00,0.00,0.00,20.00,0.00,0.00),('1','64','539','43302',874093,'1489','202',192440.00,193854.00,1394.00,271830.00,0.00,0.00,20.00,0.00,0.00),('1','64','540','43302',874094,'1490','203',198334.62,198726.72,392.10,74499.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43388',875863,'1480','201',183815.00,188267.00,4452.00,636636.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43388',875864,'1481','201',195833.00,196802.00,969.00,138567.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43388',875865,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','43388',875866,'1483','201',46016.00,47085.00,1069.00,152867.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43388',875867,'1484','201',178198.00,182455.00,4257.00,608751.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','43388',875868,'1485','201',165110.00,170272.00,5162.00,738166.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43388',875869,'1486','201',197745.00,199701.00,1956.00,279708.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','43388',875870,'1487','201',238850.00,241781.00,2931.00,419133.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43388',875871,'1488','202',70688.00,72406.00,1718.00,335010.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','43388',875872,'1489','202',193854.00,198619.00,4765.00,929175.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','43388',875873,'1490','203',198726.72,199087.08,360.36,68468.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','44601',900328,'1480','201',188267.00,191746.00,3479.00,497497.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44601',900329,'1481','201',196802.00,200561.00,3759.00,537537.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44601',900330,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44601',900331,'1483','201',47085.00,51850.00,4765.00,681395.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44601',900332,'1484','201',182455.00,184966.00,2511.00,359073.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44601',900333,'1485','201',170272.00,172801.00,2529.00,361647.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44601',900334,'1486','201',199701.00,202309.00,2608.00,372944.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44601',900335,'1487','201',241781.00,244380.00,2599.00,371657.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44601',900336,'1488','202',72406.00,76252.00,3846.00,749970.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44601',900337,'1489','202',198619.00,199844.00,1225.00,238875.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44601',900338,'1490','203',199087.08,199463.29,376.21,71479.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','44602',900339,'1480','201',191746.00,194881.00,3135.00,448305.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44602',900340,'1481','201',200561.00,204837.00,4276.00,611468.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44602',900341,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44602',900342,'1483','201',51850.00,54623.00,2773.00,396539.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44602',900343,'1484','201',184966.00,186353.00,1387.00,198341.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44602',900344,'1485','201',172801.00,177244.00,4443.00,635349.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44602',900345,'1486','201',202309.00,206036.00,3727.00,532961.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44602',900346,'1487','201',244380.00,246438.00,2058.00,294294.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44602',900347,'1488','202',76252.00,78169.00,1917.00,373815.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44602',900348,'1489','202',199844.00,201819.00,1975.00,385125.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44602',900349,'1490','203',199463.29,199751.86,288.57,54828.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','44603',900350,'1480','201',194881.00,197179.00,2298.00,328614.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44603',900351,'1481','201',204837.00,209572.00,4735.00,677105.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44603',900352,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44603',900353,'1483','201',54623.00,57037.00,2414.00,345202.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44603',900354,'1484','201',186353.00,188345.00,1992.00,284856.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44603',900355,'1485','201',177244.00,179644.00,2400.00,343200.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44603',900356,'1486','201',206036.00,208322.00,2286.00,326898.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44603',900357,'1487','201',246438.00,248318.00,1880.00,268840.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44603',900358,'1488','202',78169.00,78169.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44603',900359,'1489','202',201819.00,204441.00,2622.00,511290.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44603',900360,'1490','203',199751.86,199870.81,118.95,22600.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','44604',900361,'1480','201',197179.00,199623.00,2444.00,349492.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44604',900362,'1481','201',209572.00,213532.00,3960.00,566280.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44604',900363,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44604',900364,'1483','201',57037.00,59543.00,2506.00,358358.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44604',900365,'1484','201',188345.00,190454.00,2109.00,301587.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44604',900366,'1485','201',179644.00,183385.00,3741.00,534963.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44604',900367,'1486','201',208322.00,209486.00,1164.00,166452.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44604',900368,'1487','201',248318.00,251056.00,2738.00,391534.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44604',900369,'1488','202',78169.00,80450.00,2281.00,444795.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44604',900370,'1489','202',204441.00,207012.00,2571.00,501345.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44604',900371,'1490','203',199870.81,200103.21,232.40,44156.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44628',900791,'1480','201',199623.00,202937.00,3314.00,473902.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44628',900792,'1481','201',213532.00,218435.00,4903.00,701129.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44628',900793,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44628',900794,'1483','201',59543.00,63634.00,4091.00,585013.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44628',900795,'1484','201',190454.00,193622.00,3168.00,453024.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44628',900796,'1485','201',183385.00,186809.00,3424.00,489632.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44628',900797,'1486','201',209486.00,209486.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44628',900798,'1487','201',251056.00,255622.00,4566.00,652938.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44628',900799,'1488','202',80450.00,84405.00,3955.00,771225.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44628',900800,'1489','202',207012.00,208512.00,1500.00,292500.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44628',900801,'1490','203',200103.21,200473.92,370.71,70434.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','44631',900824,'1480','201',202937.00,206145.00,3208.00,458744.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44631',900825,'1481','201',218435.00,223923.00,5488.00,784784.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44631',900826,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44631',900827,'1483','201',63634.00,68464.00,4830.00,690690.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44631',900828,'1484','201',193622.00,193643.00,21.00,3003.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44631',900829,'1485','201',186809.00,191491.00,4682.00,669526.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44631',900830,'1486','201',209486.00,212676.00,3190.00,456170.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44631',900831,'1487','201',255622.00,257691.00,2069.00,295867.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44631',900832,'1488','202',84405.00,86576.00,2171.00,423345.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44631',900833,'1489','202',208512.00,210181.00,1669.00,325455.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44631',900834,'1490','203',200473.92,201149.19,675.27,128301.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','44632',900835,'1480','201',206145.00,209453.00,3308.00,473044.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44632',900836,'1481','201',223923.00,228403.00,4480.00,640640.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44632',900837,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44632',900838,'1483','201',68464.00,73810.00,5346.00,764478.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44632',900839,'1484','201',193643.00,193643.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44632',900840,'1485','201',191491.00,195447.00,3956.00,565708.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44632',900841,'1486','201',212676.00,214558.00,1882.00,269126.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44632',900842,'1487','201',257691.00,260249.00,2558.00,365794.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44632',900843,'1488','202',86576.00,89286.00,2710.00,528450.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44632',900844,'1489','202',210181.00,212479.00,2298.00,448110.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44632',900845,'1490','203',201149.19,201457.86,308.67,58647.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','44633',900846,'1480','201',209453.00,209453.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44633',900847,'1481','201',228403.00,228403.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44633',900848,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44633',900849,'1483','201',73810.00,73810.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44633',900850,'1484','201',193643.00,193643.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44633',900851,'1485','201',195447.00,195447.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44633',900852,'1486','201',214558.00,214558.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44633',900853,'1487','201',260249.00,260249.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44633',900854,'1488','202',89286.00,91514.00,2228.00,434460.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44633',900855,'1489','202',212479.00,213777.00,1298.00,253110.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44633',900856,'1490','203',201457.86,201457.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44637',900945,'1480','201',209453.00,209453.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44637',900946,'1481','201',228403.00,232029.00,3626.00,518518.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44637',900947,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44637',900948,'1483','201',73810.00,73810.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44637',900949,'1484','201',193643.00,198049.00,4406.00,630058.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44637',900950,'1485','201',195447.00,201643.00,6196.00,886028.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44637',900951,'1486','201',214558.00,218994.00,4436.00,634348.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44637',900952,'1487','201',260249.00,264027.00,3778.00,540254.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44637',900953,'1488','202',91514.00,91882.00,368.00,80960.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44637',900954,'1489','202',213777.00,215205.00,1428.00,314160.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44637',900955,'1490','203',201457.86,201748.85,290.99,55288.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','44639',900978,'1480','201',209453.00,212408.00,2955.00,422565.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44639',900979,'1481','201',232029.00,236408.00,4379.00,626197.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44639',900980,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44639',900981,'1483','201',73810.00,78896.00,5086.00,727298.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44639',900982,'1484','201',198049.00,202039.00,3990.00,570570.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44639',900983,'1485','201',201643.00,203659.00,2016.00,288288.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44639',900984,'1486','201',218994.00,219029.00,35.00,5005.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44639',900985,'1487','201',264027.00,267193.00,3166.00,452738.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44639',900986,'1488','202',91882.00,93894.00,2012.00,442640.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44639',900987,'1489','202',215205.00,216099.00,894.00,196680.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44639',900988,'1490','203',201748.85,202019.02,270.17,51332.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','44803',904210,'1480','201',212408.00,212408.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44803',904211,'1481','201',236408.00,236408.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44803',904212,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44803',904213,'1483','201',78896.00,78896.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44803',904214,'1484','201',202039.00,202039.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44803',904215,'1485','201',203659.00,203659.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44803',904216,'1486','201',219029.00,219029.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44803',904217,'1487','201',267193.00,267193.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44803',904218,'1488','202',93894.00,93988.00,94.00,20680.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44803',904219,'1489','202',216099.00,216649.00,550.00,121000.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44803',904220,'1490','203',202019.02,202035.84,16.82,3195.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','44822',904541,'1480','201',212408.00,212408.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44822',904542,'1481','201',236408.00,240825.00,4417.00,631631.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44822',904543,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44822',904544,'1483','201',78896.00,82335.00,3439.00,491777.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44822',904545,'1484','201',202039.00,204780.00,2741.00,391963.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44822',904546,'1485','201',203659.00,208014.00,4355.00,622765.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44822',904547,'1486','201',219029.00,219029.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44822',904548,'1487','201',267193.00,270342.00,3149.00,450307.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44822',904549,'1488','202',93988.00,95828.00,1840.00,377200.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44822',904550,'1489','202',216649.00,217031.00,382.00,78310.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44822',904551,'1490','203',202035.84,202216.85,181.01,36202.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44824',904568,'1480','201',212408.00,212408.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44824',904569,'1481','201',240825.00,240825.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44824',904570,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44824',904571,'1483','201',82335.00,82335.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44824',904572,'1484','201',204780.00,204780.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44824',904573,'1485','201',208014.00,208014.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44824',904574,'1486','201',219029.00,219029.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44824',904575,'1487','201',270342.00,270342.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44824',904576,'1488','202',95828.00,95828.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44824',904577,'1489','202',217031.00,217031.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44824',904578,'1490','203',202216.85,202418.60,201.75,40350.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44830',904691,'1480','201',212408.00,214654.00,2246.00,321178.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44830',904692,'1481','201',240825.00,245919.00,5084.00,727012.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','44830',904693,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44830',904694,'1483','201',82335.00,88224.00,5879.00,840697.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','44830',904695,'1484','201',204780.00,208221.00,3431.00,490633.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','44830',904696,'1485','201',208014.00,211427.00,3413.00,488059.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44830',904697,'1486','201',219029.00,219071.00,42.00,6006.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44830',904698,'1487','201',270342.00,274639.00,4287.00,613041.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','44830',904699,'1488','202',95828.00,95828.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44830',904700,'1489','202',217031.00,217031.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44830',904701,'1490','203',202418.60,202601.54,172.94,38046.80,0.00,0.00,10.00,0.00,0.00),('1','64','536','44832',904730,'1480','201',214654.00,219368.00,4714.00,674102.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44832',904731,'1481','201',245919.00,250660.00,4741.00,677963.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44832',904732,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44832',904733,'1483','201',88224.00,93812.00,5588.00,799084.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44832',904734,'1484','201',208221.00,210128.00,1907.00,272701.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44832',904735,'1485','201',211427.00,214689.00,3262.00,466466.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44832',904736,'1486','201',219071.00,219831.00,760.00,108680.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44832',904737,'1487','201',274639.00,278312.00,3673.00,525239.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44832',904738,'1488','202',95828.00,95828.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44832',904739,'1489','202',217031.00,217031.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44832',904740,'1490','203',202601.54,202787.78,186.24,40972.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','44971',907540,'1480','201',219368.00,219508.00,140.00,20020.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44971',907541,'1481','201',250660.00,250952.00,292.00,41756.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44971',907542,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','44971',907543,'1483','201',93812.00,93812.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44971',907544,'1484','201',210128.00,215816.00,5688.00,813384.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','44971',907545,'1485','201',214689.00,220744.00,6055.00,865865.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44971',907546,'1486','201',219831.00,223609.00,3778.00,540254.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','44971',907547,'1487','201',278312.00,284017.00,5705.00,815815.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44971',907548,'1488','202',95828.00,95828.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','44971',907549,'1489','202',217031.00,217218.00,187.00,38335.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','44971',907550,'1490','203',202787.78,202948.47,160.69,35351.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','45113',910477,'1480','201',219508.00,220286.00,778.00,111254.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45113',910478,'1481','201',250952.00,251790.00,838.00,119834.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45113',910479,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45113',910480,'1483','201',93812.00,94714.00,902.00,128986.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45113',910481,'1484','201',215816.00,220916.00,5100.00,729300.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45113',910482,'1485','201',220744.00,226129.00,5385.00,770055.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45113',910483,'1486','201',223609.00,227785.00,4176.00,597168.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45113',910484,'1487','201',284017.00,289076.00,5059.00,723437.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45113',910485,'1488','202',95828.00,95828.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45113',910486,'1489','202',217218.00,217218.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45113',910487,'1490','203',202948.47,203243.52,295.05,64911.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45115',910505,'1480','201',220286.00,223641.00,3355.00,479765.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45115',910506,'1481','201',251790.00,257749.00,5959.00,852137.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45115',910507,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45115',910508,'1483','201',94714.00,100497.00,5783.00,826969.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45115',910509,'1484','201',220916.00,220916.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45115',910510,'1485','201',226129.00,229300.00,3171.00,453453.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45115',910511,'1486','201',227785.00,227785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45115',910512,'1487','201',289076.00,294970.00,5894.00,842842.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45115',910513,'1488','202',95828.00,96501.00,673.00,137965.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45115',910514,'1489','202',217218.00,218455.00,1237.00,253585.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45115',910515,'1490','203',203243.52,203485.39,241.87,53211.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','45389',916012,'1480','201',223641.00,223839.00,198.00,28314.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45389',916013,'1481','201',257749.00,263986.00,6237.00,891891.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45389',916014,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45389',916015,'1483','201',100497.00,106337.00,5840.00,835120.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45389',916016,'1484','201',220916.00,224516.00,3600.00,514800.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45389',916017,'1485','201',229300.00,232929.00,3629.00,518947.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45389',916018,'1486','201',227785.00,227785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45389',916019,'1487','201',294970.00,300013.00,5043.00,721149.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45389',916020,'1488','202',96501.00,97791.00,1290.00,264450.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45389',916021,'1489','202',218455.00,219755.00,1300.00,266500.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45389',916022,'1490','203',203485.39,203745.24,259.85,57167.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45390',916023,'1480','201',223839.00,226777.00,2938.00,420134.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45390',916024,'1481','201',263986.00,267550.00,3564.00,509652.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45390',916025,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45390',916026,'1483','201',106337.00,111228.00,4891.00,699413.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45390',916027,'1484','201',224516.00,224516.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45390',916028,'1485','201',232929.00,237246.00,4317.00,617331.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45390',916029,'1486','201',227785.00,228962.00,1177.00,168311.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45390',916030,'1487','201',300013.00,302469.00,2456.00,351208.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45390',916031,'1488','202',97791.00,98957.00,1166.00,239030.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45390',916032,'1489','202',219755.00,221586.00,1831.00,375355.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45390',916033,'1490','203',203745.24,204014.23,268.99,59177.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','45509',918397,'1480','201',226777.00,228752.00,1975.00,282425.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45509',918398,'1481','201',267550.00,270714.00,3164.00,452452.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45509',918399,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45509',918400,'1483','201',111228.00,114966.00,3738.00,534534.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45509',918401,'1484','201',224516.00,227042.00,2526.00,361218.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45509',918402,'1485','201',237246.00,242841.00,5595.00,800085.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45509',918403,'1486','201',228962.00,232521.00,3559.00,508937.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45509',918404,'1487','201',302469.00,306433.00,3964.00,566852.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45509',918405,'1488','202',98957.00,100698.00,1741.00,356905.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45509',918406,'1489','202',221586.00,224113.00,2527.00,518035.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45509',918407,'1490','203',204014.23,204340.70,326.47,71823.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','45538',918944,'1480','201',228752.00,228752.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45538',918945,'1481','201',270714.00,270714.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45538',918946,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45538',918947,'1483','201',114966.00,114966.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45538',918948,'1484','201',227042.00,229009.00,1967.00,281281.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45538',918949,'1485','201',242841.00,245454.00,2613.00,373659.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45538',918950,'1486','201',232521.00,235749.00,3228.00,461604.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45538',918951,'1487','201',306433.00,310413.00,3980.00,569140.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45538',918952,'1488','202',100698.00,100803.00,105.00,21525.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45538',918953,'1489','202',224113.00,226797.00,2684.00,550220.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45538',918954,'1490','203',204340.70,204543.51,202.81,44618.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','45643',921136,'1480','201',228752.00,228752.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45643',921137,'1481','201',270714.00,270714.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45643',921138,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45643',921139,'1483','201',114966.00,114966.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45643',921140,'1484','201',229009.00,229009.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45643',921141,'1485','201',245454.00,245454.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45643',921142,'1486','201',235749.00,235749.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45643',921143,'1487','201',310413.00,310413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45643',921144,'1488','202',100803.00,100803.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45643',921145,'1489','202',226797.00,226797.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45643',921146,'1490','203',204543.51,204627.84,84.33,18552.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','45736',923004,'1480','201',228752.00,229990.00,1238.00,177034.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45736',923005,'1481','201',270714.00,271874.00,1160.00,165880.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45736',923006,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45736',923007,'1483','201',114966.00,116692.00,1726.00,246818.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45736',923008,'1484','201',229009.00,229009.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45736',923009,'1485','201',245454.00,245454.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45736',923010,'1486','201',235749.00,235749.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45736',923011,'1487','201',310413.00,310413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45736',923012,'1488','202',100803.00,101712.00,909.00,186345.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45736',923013,'1489','202',226797.00,229129.00,2332.00,478060.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45736',923014,'1490','203',204627.84,204804.19,176.35,40560.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','45846',925178,'1480','201',229990.00,234925.00,4935.00,705705.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45846',925179,'1481','201',271874.00,278170.00,6296.00,900328.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45846',925180,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45846',925181,'1483','201',116692.00,127457.00,10765.00,1539395.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45846',925182,'1484','201',229009.00,229009.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45846',925183,'1485','201',245454.00,245454.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45846',925184,'1486','201',235749.00,235749.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45846',925185,'1487','201',310413.00,310413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45846',925186,'1488','202',101712.00,103772.00,2060.00,422300.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45846',925187,'1489','202',229129.00,233162.00,4033.00,826765.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45846',925188,'1490','203',204804.19,205005.31,201.12,46257.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','45848',925205,'1480','201',234925.00,238029.00,3094.00,442442.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','45848',925206,'1481','201',278170.00,282331.00,4151.00,593593.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','45848',925207,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45848',925208,'1483','201',127457.00,130958.00,3491.00,499213.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','45848',925209,'1484','201',229009.00,232158.00,3139.00,448877.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','45848',925210,'1485','201',245454.00,250742.00,5278.00,754754.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','45848',925211,'1486','201',235749.00,238528.00,2779.00,397397.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45848',925212,'1487','201',310413.00,314553.00,4130.00,590590.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','45848',925213,'1488','202',103772.00,106308.00,2526.00,517830.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','45848',925214,'1489','202',233162.00,235072.00,1900.00,389500.00,0.00,0.00,10.00,0.00,0.00),('1','64','540','45848',925215,'1490','203',205005.31,205256.41,241.10,55453.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','45970',927650,'1480','201',238029.00,240437.00,2408.00,344344.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45970',927651,'1481','201',282331.00,288769.00,6438.00,920634.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45970',927652,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','45970',927653,'1483','201',130958.00,137245.00,6287.00,899041.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45970',927654,'1484','201',232158.00,232158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','45970',927655,'1485','201',250742.00,256428.00,5686.00,813098.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45970',927656,'1486','201',238528.00,243613.00,5085.00,727155.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','45970',927657,'1487','201',314553.00,314553.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45970',927658,'1488','202',106308.00,106779.00,471.00,96555.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','45970',927659,'1489','202',235072.00,236040.00,968.00,198440.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','45970',927660,'1490','203',205256.41,205581.42,325.01,74752.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','46265',933484,'1480','201',240437.00,242962.00,2525.00,361075.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46265',933485,'1481','201',288769.00,293328.00,4559.00,651937.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46265',933486,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46265',933487,'1483','201',137245.00,142057.00,4812.00,688116.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46265',933488,'1484','201',232158.00,232161.00,3.00,429.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46265',933489,'1485','201',256428.00,261214.00,4786.00,684398.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46265',933490,'1486','201',243613.00,244204.00,591.00,84513.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46265',933491,'1487','201',314553.00,318480.00,3927.00,561561.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46265',933492,'1488','202',106779.00,107674.00,895.00,183475.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46265',933493,'1489','202',236040.00,237903.00,1863.00,381915.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','46265',933494,'1490','203',205581.42,205692.66,111.24,25585.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','46267',933500,'1480','201',242962.00,248071.00,5109.00,730587.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46267',933501,'1481','201',293328.00,297233.00,3905.00,558415.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46267',933502,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46267',933503,'1483','201',142057.00,147731.00,5674.00,811382.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46267',933504,'1484','201',232161.00,232321.00,160.00,22880.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46267',933505,'1485','201',261214.00,266222.00,5008.00,716144.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46267',933506,'1486','201',244204.00,244816.00,612.00,87516.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46267',933507,'1487','201',318480.00,323571.00,5091.00,728013.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46267',933508,'1488','202',107674.00,110815.00,3141.00,643905.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46267',933509,'1489','202',237903.00,239777.00,1874.00,384170.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','46267',933510,'1490','203',205692.66,205930.06,237.40,54602.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46268',933511,'1480','201',248071.00,252110.00,4039.00,577577.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46268',933512,'1481','201',297233.00,300524.00,3291.00,470613.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46268',933513,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46268',933514,'1483','201',147731.00,152986.00,5255.00,751465.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46268',933515,'1484','201',232321.00,235588.00,3267.00,467181.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46268',933516,'1485','201',266222.00,270111.00,3889.00,556127.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46268',933517,'1486','201',244816.00,244816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46268',933518,'1487','201',323571.00,326634.00,3063.00,438009.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46268',933519,'1488','202',110815.00,113127.00,2302.00,471910.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','46268',933520,'1489','202',239777.00,241605.00,1818.00,372690.00,0.00,0.00,10.00,0.00,0.00),('1','64','540','46268',933521,'1490','203',205930.06,206172.50,242.44,55761.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','46486',937560,'1480','201',252110.00,253986.00,1876.00,268268.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46486',937561,'1481','201',300524.00,306788.00,6264.00,895752.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46486',937562,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46486',937563,'1483','201',152986.00,159574.00,6588.00,942084.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46486',937564,'1484','201',235588.00,235588.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46486',937565,'1485','201',270111.00,276442.00,6331.00,905333.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46486',937566,'1486','201',244816.00,244816.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46486',937567,'1487','201',326634.00,331150.00,4516.00,645788.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46486',937568,'1488','202',113127.00,114618.00,1491.00,305655.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46486',937569,'1489','202',241605.00,244097.00,2492.00,510860.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','46486',937570,'1490','203',206172.50,206438.76,266.26,61239.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','46488',937594,'1480','201',253986.00,255420.00,1434.00,205062.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46488',937595,'1481','201',306788.00,307664.00,876.00,125268.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46488',937596,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46488',937597,'1483','201',159574.00,161475.00,1901.00,271843.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46488',937598,'1484','201',235588.00,241077.00,5489.00,784927.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46488',937599,'1485','201',276442.00,282020.00,5578.00,797654.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46488',937600,'1486','201',244816.00,248685.00,3869.00,553267.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46488',937601,'1487','201',331150.00,337026.00,5876.00,840268.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46488',937602,'1488','202',114618.00,115930.00,1312.00,268960.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46488',937603,'1489','202',244097.00,248048.00,3951.00,809955.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','46488',937604,'1490','203',206438.76,206781.57,342.81,78846.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','46890',945608,'1480','201',255420.00,255420.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46890',945609,'1481','201',307664.00,315875.00,8211.00,1174173.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46890',945610,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46890',945611,'1483','201',161475.00,167332.00,5857.00,837551.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46890',945612,'1484','201',241077.00,243199.00,2122.00,303446.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46890',945613,'1485','201',282020.00,287126.00,5106.00,730158.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46890',945614,'1486','201',248685.00,248687.00,2.00,286.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46890',945615,'1487','201',337026.00,341935.00,4909.00,701987.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46890',945616,'1488','202',115930.00,117403.00,1473.00,301965.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46890',945617,'1489','202',248048.00,250435.00,2387.00,489335.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','46890',945618,'1490','203',206781.57,207083.56,301.99,69457.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','46903',945801,'1480','201',255420.00,255430.00,10.00,1430.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46903',945802,'1481','201',315875.00,322426.00,6551.00,936793.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46903',945803,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46903',945804,'1483','201',167332.00,172937.00,5605.00,801515.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46903',945805,'1484','201',243199.00,243199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46903',945806,'1485','201',287126.00,293164.00,6038.00,863434.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46903',945807,'1486','201',248687.00,248687.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46903',945808,'1487','201',341935.00,346811.00,4876.00,697268.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46903',945809,'1488','202',117403.00,119913.00,2510.00,514550.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46903',945810,'1489','202',250435.00,252716.00,2281.00,467605.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','46903',945811,'1490','203',207083.56,207412.28,328.72,75605.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','46906',945846,'1480','201',255430.00,255430.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46906',945847,'1481','201',322426.00,327794.00,5368.00,767624.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46906',945848,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46906',945849,'1483','201',172937.00,179045.00,6108.00,873444.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46906',945850,'1484','201',243199.00,243199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46906',945851,'1485','201',293164.00,299024.00,5860.00,837980.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46906',945852,'1486','201',248687.00,250185.00,1498.00,214214.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46906',945853,'1487','201',346811.00,349104.00,2293.00,327899.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46906',945854,'1488','202',119913.00,120735.00,822.00,168510.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46906',945855,'1489','202',252716.00,255379.00,2663.00,545915.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','46906',945856,'1490','203',207412.28,207573.57,161.29,37096.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','46907',945857,'1480','201',255430.00,255430.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46907',945858,'1481','201',327794.00,327794.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46907',945859,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','46907',945860,'1483','201',179045.00,179045.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46907',945861,'1484','201',243199.00,249986.00,6787.00,970541.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','46907',945862,'1485','201',299024.00,305878.00,6854.00,980122.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46907',945863,'1486','201',250185.00,254557.00,4372.00,625196.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','46907',945864,'1487','201',349104.00,355840.00,6736.00,963248.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46907',945865,'1488','202',120735.00,120735.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','46907',945866,'1489','202',255379.00,255734.00,355.00,72775.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','46907',945867,'1490','203',207573.57,207784.90,211.33,48605.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','47268',953341,'1480','201',255430.00,255430.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47268',953342,'1481','201',327794.00,327794.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47268',953343,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47268',953344,'1483','201',179045.00,179045.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47268',953345,'1484','201',249986.00,253459.00,3473.00,496639.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47268',953346,'1485','201',305878.00,309991.00,4113.00,588159.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47268',953347,'1486','201',254557.00,259772.00,5215.00,745745.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47268',953348,'1487','201',355840.00,361506.00,5666.00,810238.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47268',953349,'1488','202',120735.00,120763.00,28.00,5740.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47268',953350,'1489','202',255734.00,256002.00,268.00,54940.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47268',953351,'1490','203',207784.90,208005.24,220.34,50678.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','47386',955695,'1480','201',255430.00,255619.00,189.00,27027.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47386',955696,'1481','201',327794.00,328156.00,362.00,51766.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47386',955697,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47386',955698,'1483','201',179045.00,179508.00,463.00,66209.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47386',955699,'1484','201',253459.00,253459.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47386',955700,'1485','201',309991.00,309991.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47386',955701,'1486','201',259772.00,266500.00,6728.00,962104.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47386',955702,'1487','201',361506.00,368794.00,7288.00,1042184.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47386',955703,'1488','202',120763.00,123370.00,2607.00,547470.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47386',955704,'1489','202',256002.00,256352.00,350.00,73500.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47386',955705,'1490','203',208005.24,208245.41,240.17,55239.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','47390',955788,'1480','201',255619.00,257397.00,1778.00,254254.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47390',955789,'1481','201',328156.00,333988.00,5832.00,833976.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47390',955790,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47390',955791,'1483','201',179508.00,184981.00,5473.00,782639.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47390',955792,'1484','201',253459.00,253459.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47390',955793,'1485','201',309991.00,316478.00,6487.00,927641.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47390',955794,'1486','201',266500.00,270127.00,3627.00,518661.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47390',955795,'1487','201',368794.00,368794.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47390',955796,'1488','202',123370.00,125746.00,2376.00,498960.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47390',955797,'1489','202',256352.00,257460.00,1108.00,232680.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47390',955798,'1490','203',208245.41,208580.21,334.80,77004.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47391',955799,'1480','201',257397.00,257397.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47391',955800,'1481','201',333988.00,333988.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47391',955801,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47391',955802,'1483','201',184981.00,184981.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47391',955803,'1484','201',253459.00,253459.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47391',955804,'1485','201',316478.00,316478.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47391',955805,'1486','201',270127.00,270127.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47391',955806,'1487','201',368794.00,368794.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47391',955807,'1488','202',125746.00,126042.00,296.00,62160.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47391',955808,'1489','202',257460.00,258428.00,968.00,203280.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47391',955809,'1490','203',208580.21,208580.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47626',960653,'1480','201',257397.00,261338.00,3941.00,563563.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47626',960654,'1481','201',333988.00,338959.00,4971.00,710853.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47626',960655,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47626',960656,'1483','201',184981.00,189096.00,4115.00,588445.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47626',960657,'1484','201',253459.00,257912.00,4453.00,636779.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47626',960658,'1485','201',316478.00,320800.00,4322.00,618046.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47626',960659,'1486','201',270127.00,270127.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47626',960660,'1487','201',368794.00,372409.00,3615.00,516945.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47626',960661,'1488','202',126042.00,127027.00,985.00,216700.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47626',960662,'1489','202',258428.00,259603.00,1175.00,258500.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47626',960663,'1490','203',208580.21,208734.51,154.30,35489.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47627',960664,'1480','201',261338.00,264911.00,3563.00,509509.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','47627',960665,'1481','201',338959.00,343098.00,4129.00,590447.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','47627',960666,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47627',960667,'1483','201',189096.00,195100.00,5994.00,857142.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','47627',960668,'1484','201',257912.00,258831.00,919.00,131417.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47627',960669,'1485','201',320800.00,324485.00,3685.00,526955.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47627',960670,'1486','201',270127.00,271647.00,1520.00,217360.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47627',960671,'1487','201',372409.00,373599.00,1190.00,170170.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47627',960672,'1488','202',127027.00,128929.00,1892.00,416240.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','47627',960673,'1489','202',259603.00,259823.00,210.00,46200.00,0.00,0.00,10.00,0.00,0.00),('1','64','540','47627',960674,'1490','203',208734.51,209121.51,377.00,86710.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','47648',961094,'1480','201',264911.00,269918.00,5007.00,716001.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47648',961095,'1481','201',343098.00,349835.00,6737.00,963391.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47648',961096,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47648',961097,'1483','201',195100.00,202342.00,7242.00,1035606.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47648',961098,'1484','201',258831.00,258831.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47648',961099,'1485','201',324485.00,324485.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47648',961100,'1486','201',271647.00,271647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47648',961101,'1487','201',373599.00,373599.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47648',961102,'1488','202',128929.00,129168.00,239.00,52580.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47648',961103,'1489','202',259823.00,262489.00,2666.00,586520.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47648',961104,'1490','203',209121.51,209369.01,247.50,56925.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47651',961131,'1480','201',269918.00,273331.00,3413.00,488059.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47651',961132,'1481','201',349835.00,353846.00,4011.00,573573.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47651',961133,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47651',961134,'1483','201',202342.00,208166.00,5824.00,832832.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47651',961135,'1484','201',258831.00,258831.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47651',961136,'1485','201',324485.00,324485.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47651',961137,'1486','201',271647.00,271647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47651',961138,'1487','201',373599.00,373599.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47651',961139,'1488','202',129168.00,130866.00,1698.00,373560.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47651',961140,'1489','202',262489.00,264500.00,2011.00,442420.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47651',961141,'1490','203',209369.01,209664.08,295.07,67866.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','47934',966612,'1480','201',273331.00,278678.00,5347.00,764621.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47934',966613,'1481','201',353846.00,360217.00,6371.00,911053.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47934',966614,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47934',966615,'1483','201',208166.00,215624.00,7458.00,1066494.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47934',966616,'1484','201',258831.00,258831.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47934',966617,'1485','201',324485.00,324485.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47934',966618,'1486','201',271647.00,273047.00,1400.00,200200.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47934',966619,'1487','201',373599.00,375784.00,2185.00,312455.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47934',966620,'1488','202',130866.00,133368.00,2502.00,550440.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47934',966621,'1489','202',264500.00,265914.00,1414.00,311080.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47934',966622,'1490','203',209664.08,209865.18,201.10,46253.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47938',966664,'1480','201',278678.00,278678.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47938',966665,'1481','201',360217.00,366571.00,6354.00,908622.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47938',966666,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','47938',966667,'1483','201',215624.00,220421.00,4797.00,685971.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47938',966668,'1484','201',258831.00,263877.00,5046.00,721578.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','47938',966669,'1485','201',324485.00,324485.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47938',966670,'1486','201',273047.00,276003.00,2956.00,422708.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','47938',966671,'1487','201',375784.00,379695.00,3911.00,559273.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47938',966672,'1488','202',133368.00,135676.00,2308.00,507760.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','47938',966673,'1489','202',265914.00,267877.00,1963.00,431860.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','47938',966674,'1490','203',209865.18,210109.92,244.74,56290.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','48018',968341,'1480','201',278678.00,282851.00,4173.00,596739.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48018',968342,'1481','201',366571.00,368653.00,2082.00,297726.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48018',968343,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48018',968344,'1483','201',220421.00,224413.00,3992.00,570856.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48018',968345,'1484','201',263877.00,267139.00,3262.00,466466.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48018',968346,'1485','201',324485.00,327671.00,3186.00,455598.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48018',968347,'1486','201',276003.00,276003.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48018',968348,'1487','201',379695.00,383593.00,3898.00,557414.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48018',968349,'1488','202',135676.00,137209.00,1533.00,337260.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48018',968350,'1489','202',267877.00,269986.00,2109.00,463980.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','48018',968351,'1490','203',210109.92,210295.62,185.70,42711.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48236',972665,'1480','201',282851.00,288907.00,6056.00,866008.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48236',972666,'1481','201',368653.00,368653.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48236',972667,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48236',972668,'1483','201',224413.00,229137.00,4724.00,675532.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48236',972669,'1484','201',267139.00,267139.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48236',972670,'1485','201',327671.00,334163.00,6492.00,928356.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48236',972671,'1486','201',276003.00,276003.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48236',972672,'1487','201',383593.00,389376.00,5783.00,826969.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48236',972673,'1488','202',137209.00,138942.00,1733.00,381260.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48236',972674,'1489','202',269986.00,273651.00,3665.00,806300.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','48236',972675,'1490','203',210295.62,210575.77,280.15,64434.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','48238',972705,'1480','201',288907.00,290232.00,1325.00,189475.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48238',972706,'1481','201',368653.00,375042.00,6389.00,913627.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48238',972707,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48238',972708,'1483','201',229137.00,235474.00,6337.00,906191.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48238',972709,'1484','201',267139.00,267139.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48238',972710,'1485','201',334163.00,340223.00,6060.00,866580.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48238',972711,'1486','201',276003.00,278092.00,2089.00,298727.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48238',972712,'1487','201',389376.00,392690.00,3314.00,473902.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48238',972713,'1488','202',138942.00,138942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48238',972714,'1489','202',273651.00,276786.00,3135.00,689700.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','48238',972715,'1490','203',210575.77,210897.35,321.58,73963.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','48389',975687,'1480','201',290232.00,293031.00,2799.00,400257.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48389',975688,'1481','201',375042.00,375056.00,14.00,2002.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48389',975689,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48389',975690,'1483','201',235474.00,235474.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48389',975691,'1484','201',267139.00,270378.00,3239.00,463177.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48389',975692,'1485','201',340223.00,346173.00,5950.00,850850.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48389',975693,'1486','201',278092.00,281623.00,3531.00,504933.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48389',975694,'1487','201',392690.00,397513.00,4823.00,689689.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48389',975695,'1488','202',138942.00,139709.00,767.00,168740.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48389',975696,'1489','202',276786.00,279403.00,2617.00,575740.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','48389',975697,'1490','203',210897.35,211223.80,326.45,75083.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','48391',975708,'1480','201',293031.00,293031.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48391',975709,'1481','201',375056.00,377066.00,2010.00,287430.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48391',975710,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48391',975711,'1483','201',235474.00,237313.00,1839.00,262977.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48391',975712,'1484','201',270378.00,273398.00,3020.00,431860.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48391',975713,'1485','201',346173.00,350017.00,3844.00,549692.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48391',975714,'1486','201',281623.00,284817.00,3194.00,456742.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48391',975715,'1487','201',397513.00,402376.00,4863.00,695409.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48391',975716,'1488','202',139709.00,143680.00,3971.00,873620.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48391',975717,'1489','202',279403.00,281830.00,2427.00,533940.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','48391',975718,'1490','203',211223.80,211415.48,191.68,44086.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','48699',981899,'1480','201',293031.00,297113.00,4072.00,582296.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','48699',981900,'1481','201',377066.00,382073.00,4997.00,714571.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','48699',981901,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48699',981902,'1483','201',237313.00,244612.00,7289.00,1042327.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','48699',981903,'1484','201',273398.00,273398.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48699',981904,'1485','201',350017.00,350017.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48699',981905,'1486','201',284817.00,289365.00,4538.00,648934.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','48699',981906,'1487','201',402376.00,405137.00,2751.00,393393.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','48699',981907,'1488','202',143680.00,143680.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48699',981908,'1489','202',281830.00,282571.00,721.00,158620.00,0.00,0.00,20.00,0.00,0.00),('1','64','540','48699',981909,'1490','203',211415.48,211781.81,356.33,81955.90,0.00,0.00,10.00,0.00,0.00),('1','64','536','48700',981910,'1480','201',297113.00,300298.00,3185.00,455455.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48700',981911,'1481','201',382073.00,386536.00,4463.00,638209.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48700',981912,'1482','201',33246.00,33246.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48700',981913,'1483','201',244612.00,249734.00,5122.00,732446.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48700',981914,'1484','201',273398.00,273398.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48700',981915,'1485','201',350017.00,350017.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48700',981916,'1486','201',289365.00,292463.00,3098.00,443014.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48700',981917,'1487','201',405137.00,409761.00,4624.00,661232.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48700',981918,'1488','202',143680.00,143680.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48700',981919,'1489','202',282571.00,282670.00,99.00,21780.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','48700',981920,'1490','203',211781.81,212201.70,419.89,96574.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','48855',984956,'1480','201',300298.00,303342.00,3044.00,435292.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48855',984957,'1481','201',386536.00,390228.00,3692.00,527956.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','48855',984958,'1482','201',33246.00,35731.00,2458.30,351536.90,0.00,0.00,26.70,0.00,0.00),('1','64','536','48855',984959,'1483','201',249734.00,251771.00,2017.00,288431.00,0.00,0.00,20.00,0.00,0.00),('1','64','537','48855',984960,'1484','201',273398.00,273398.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','48855',984961,'1485','201',350017.00,350017.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48855',984962,'1486','201',292463.00,294489.00,2026.00,289718.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','48855',984963,'1487','201',409761.00,412404.00,2643.00,377949.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48855',984964,'1488','202',143680.00,143680.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','48855',984965,'1489','202',282670.00,282778.00,108.00,23760.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','48855',984966,'1490','203',212201.70,212596.98,395.28,90914.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','49324',993969,'1480','201',303342.00,307041.00,3699.00,528957.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49324',993970,'1481','201',390228.00,394756.00,4528.00,647504.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49324',993971,'1482','201',35731.00,37617.00,1886.00,269698.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49324',993972,'1483','201',251771.00,257196.00,5425.00,775775.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49324',993973,'1484','201',273398.00,273398.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49324',993974,'1485','201',350017.00,350017.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49324',993975,'1486','201',294489.00,297762.00,3273.00,468039.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49324',993976,'1487','201',412404.00,416214.00,3810.00,544830.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49324',993977,'1488','202',143680.00,143680.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49324',993978,'1489','202',282778.00,282778.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49324',993979,'1490','203',212596.98,212919.82,322.84,74253.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','49327',993997,'1480','201',307041.00,307041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49327',993998,'1481','201',394756.00,396379.00,1623.00,232089.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49327',993999,'1482','201',37617.00,37617.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49327',994000,'1483','201',257196.00,258814.00,1618.00,231374.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49327',994001,'1484','201',273398.00,280372.00,6974.00,997282.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49327',994002,'1485','201',350017.00,357704.00,7687.00,1099241.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49327',994003,'1486','201',297762.00,299097.00,1335.00,190905.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49327',994004,'1487','201',416214.00,418079.00,1865.00,266695.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49327',994005,'1488','202',143680.00,143680.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49327',994006,'1489','202',282778.00,282778.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49327',994007,'1490','203',212919.82,213008.57,88.75,20412.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','49328',994008,'1480','201',307041.00,307041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49328',994009,'1481','201',396379.00,396379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49328',994010,'1482','201',37617.00,37617.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49328',994011,'1483','201',258814.00,258814.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49328',994012,'1484','201',280372.00,288159.00,7787.00,1113541.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49328',994013,'1485','201',357704.00,367159.00,9455.00,1352065.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49328',994014,'1486','201',299097.00,299097.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49328',994015,'1487','201',418079.00,418079.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49328',994016,'1488','202',143680.00,143680.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49328',994017,'1489','202',282778.00,282871.00,93.00,20460.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49328',994018,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49333',994071,'1480','201',307041.00,308336.00,1295.00,185185.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49333',994072,'1481','201',396379.00,398129.00,1750.00,250250.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49333',994073,'1482','201',37617.00,38576.00,959.00,137137.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49333',994074,'1483','201',258814.00,260421.00,1607.00,229801.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49333',994075,'1484','201',288159.00,289567.00,1408.00,201344.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49333',994076,'1485','201',367159.00,368868.00,1709.00,244387.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49333',994077,'1486','201',299097.00,300280.00,1183.00,169169.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49333',994078,'1487','201',418079.00,419758.00,1679.00,240097.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49333',994079,'1488','202',143680.00,143680.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49333',994080,'1489','202',282871.00,282871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49333',994081,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49541',998348,'1480','201',308336.00,311359.00,3023.00,432289.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49541',998349,'1481','201',398129.00,402481.00,4352.00,622336.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49541',998350,'1482','201',38576.00,41830.00,3254.00,465322.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49541',998351,'1483','201',260421.00,264014.00,3593.00,513799.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49541',998352,'1484','201',289567.00,289567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49541',998353,'1485','201',368868.00,368868.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49541',998354,'1486','201',300280.00,303636.00,3356.00,479908.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49541',998355,'1487','201',419758.00,421846.00,2088.00,298584.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49541',998356,'1488','202',143680.00,144903.00,1223.00,281290.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49541',998357,'1489','202',282871.00,282959.00,88.00,20240.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49541',998358,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49705',1001573,'1480','201',311359.00,315389.00,4030.00,576290.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49705',1001574,'1481','201',402481.00,405752.00,3271.00,467753.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49705',1001575,'1482','201',41830.00,43614.00,1784.00,255112.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49705',1001576,'1483','201',264014.00,268282.00,4268.00,610324.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49705',1001577,'1484','201',289567.00,292609.00,3042.00,435006.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49705',1001578,'1485','201',368868.00,373396.00,4528.00,647504.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49705',1001579,'1486','201',303636.00,304263.00,627.00,89661.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49705',1001580,'1487','201',421846.00,422881.00,1035.00,148005.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49705',1001581,'1488','202',144903.00,146190.00,1287.00,296010.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49705',1001582,'1489','202',282959.00,285296.00,2337.00,537510.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49705',1001583,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49706',1001584,'1480','201',315389.00,318030.00,2641.00,377663.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49706',1001585,'1481','201',405752.00,410948.00,5196.00,743028.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49706',1001586,'1482','201',43614.00,46305.00,2691.00,384813.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49706',1001587,'1483','201',268282.00,272648.00,4366.00,624338.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49706',1001588,'1484','201',292609.00,294855.00,2246.00,321178.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49706',1001589,'1485','201',373396.00,376181.00,2785.00,398255.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49706',1001590,'1486','201',304263.00,304263.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49706',1001591,'1487','201',422881.00,426874.00,3993.00,570999.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49706',1001592,'1488','202',146190.00,148173.00,1983.00,456090.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49706',1001593,'1489','202',285296.00,285296.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49706',1001594,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49711',1001681,'1480','201',318030.00,322383.00,4353.00,622479.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49711',1001682,'1481','201',410948.00,416526.00,5578.00,797654.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49711',1001683,'1482','201',46305.00,48242.00,1937.00,276991.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49711',1001684,'1483','201',272648.00,275247.00,2599.00,371657.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49711',1001685,'1484','201',294855.00,297699.00,2844.00,406692.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49711',1001686,'1485','201',376181.00,380378.00,4197.00,600171.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49711',1001687,'1486','201',304263.00,307601.00,3338.00,477334.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49711',1001688,'1487','201',426874.00,428978.00,2104.00,300872.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49711',1001689,'1488','202',148173.00,148173.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49711',1001690,'1489','202',285296.00,287344.00,2048.00,471040.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49711',1001691,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49716',1001763,'1480','201',322383.00,322568.00,185.00,26455.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49716',1001764,'1481','201',416526.00,416882.00,356.00,50908.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49716',1001765,'1482','201',48242.00,48242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49716',1001766,'1483','201',275247.00,275615.00,368.00,52624.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49716',1001767,'1484','201',297699.00,304657.00,6958.00,994994.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49716',1001768,'1485','201',380378.00,386720.00,6342.00,906906.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49716',1001769,'1486','201',307601.00,312342.00,4741.00,677963.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49716',1001770,'1487','201',428978.00,435085.00,6107.00,873301.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49716',1001771,'1488','202',148173.00,148707.00,534.00,122820.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49716',1001772,'1489','202',287344.00,288516.00,1172.00,269560.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49716',1001773,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49929',1006054,'1480','201',322568.00,322568.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49929',1006055,'1481','201',416882.00,416882.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49929',1006056,'1482','201',48242.00,48242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49929',1006057,'1483','201',275615.00,275615.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49929',1006058,'1484','201',304657.00,311543.00,6886.00,984698.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49929',1006059,'1485','201',386720.00,395528.00,8808.00,1259544.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49929',1006060,'1486','201',312342.00,312342.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49929',1006061,'1487','201',435085.00,436588.00,1503.00,214929.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49929',1006062,'1488','202',148707.00,150403.00,1696.00,390080.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49929',1006063,'1489','202',288516.00,288523.00,7.00,1610.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49929',1006064,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49931',1006075,'1480','201',322568.00,323403.00,835.00,119405.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49931',1006076,'1481','201',416882.00,418493.00,1611.00,230373.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49931',1006077,'1482','201',48242.00,49519.00,1277.00,182611.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','49931',1006078,'1483','201',275615.00,276949.00,1334.00,190762.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49931',1006079,'1484','201',311543.00,314545.00,3002.00,429286.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','49931',1006080,'1485','201',395528.00,398966.00,3438.00,491634.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49931',1006081,'1486','201',312342.00,313312.00,970.00,138710.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','49931',1006082,'1487','201',436588.00,438114.00,1526.00,218218.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49931',1006083,'1488','202',150403.00,151497.00,1094.00,251620.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','49931',1006084,'1489','202',288523.00,290781.00,2258.00,519340.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','49931',1006085,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50073',1008947,'1480','201',323403.00,326405.00,2992.00,427856.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','50073',1008948,'1481','201',418493.00,424652.00,6149.00,879307.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','50073',1008949,'1482','201',49519.00,50337.00,808.00,115544.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','50073',1008950,'1483','201',276949.00,281665.00,4706.00,672958.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','50073',1008951,'1484','201',314545.00,314545.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50073',1008952,'1485','201',398966.00,405266.00,6290.00,899470.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','50073',1008953,'1486','201',313312.00,317704.00,4382.00,626626.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','50073',1008954,'1487','201',438114.00,440148.00,2024.00,289432.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','50073',1008955,'1488','202',151497.00,152380.00,873.00,200790.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','50073',1008956,'1489','202',290781.00,293018.00,2227.00,512210.00,0.00,0.00,10.00,0.00,0.00),('1','64','540','50073',1008957,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50280',1013109,'1480','201',326405.00,330141.00,3736.00,534248.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50280',1013110,'1481','201',424652.00,430039.00,5387.00,770341.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50280',1013111,'1482','201',50337.00,50337.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50280',1013112,'1483','201',281665.00,286493.00,4828.00,690404.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50280',1013113,'1484','201',314545.00,316469.00,1924.00,275132.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50280',1013114,'1485','201',405266.00,409337.00,4071.00,582153.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50280',1013115,'1486','201',317704.00,317704.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50280',1013116,'1487','201',440148.00,444187.00,4039.00,577577.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50280',1013117,'1488','202',152380.00,152485.00,105.00,24150.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50280',1013118,'1489','202',293018.00,294435.00,1417.00,325910.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50280',1013119,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50292',1013324,'1480','201',330141.00,331443.00,1302.00,186186.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50292',1013325,'1481','201',430039.00,432707.00,2668.00,381524.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50292',1013326,'1482','201',50337.00,50337.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50292',1013327,'1483','201',286493.00,289061.00,2568.00,367224.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50292',1013328,'1484','201',316469.00,317615.00,1146.00,163878.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50292',1013329,'1485','201',409337.00,410910.00,1573.00,224939.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50292',1013330,'1486','201',317704.00,317704.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50292',1013331,'1487','201',444187.00,445959.00,1772.00,253396.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50292',1013332,'1488','202',152485.00,153693.00,1208.00,277840.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50292',1013333,'1489','202',294435.00,294435.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50292',1013334,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50311',1013679,'1480','201',331443.00,331443.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50311',1013680,'1481','201',432707.00,432707.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50311',1013681,'1482','201',50337.00,50337.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50311',1013682,'1483','201',289061.00,289061.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50311',1013683,'1484','201',317615.00,317615.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50311',1013684,'1485','201',410910.00,410910.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50311',1013685,'1486','201',317704.00,317704.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50311',1013686,'1487','201',445959.00,445959.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50311',1013687,'1488','202',153693.00,154262.00,569.00,130870.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50311',1013688,'1489','202',294435.00,294667.00,232.00,53360.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50311',1013689,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50383',1015078,'1480','201',331443.00,331502.00,59.00,8437.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50383',1015079,'1481','201',432707.00,433211.00,504.00,72072.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50383',1015080,'1482','201',50337.00,50337.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50383',1015081,'1483','201',289061.00,289371.00,310.00,44330.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50383',1015082,'1484','201',317615.00,321098.00,3483.00,498069.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50383',1015083,'1485','201',410910.00,414889.00,3979.00,568997.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50383',1015084,'1486','201',317704.00,319047.00,1343.00,192049.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50383',1015085,'1487','201',445959.00,449127.00,3168.00,453024.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50383',1015086,'1488','202',154262.00,154459.00,197.00,44325.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50383',1015087,'1489','202',294667.00,295505.00,838.00,188550.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50383',1015088,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50727',1021761,'1480','201',331502.00,331502.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50727',1021762,'1481','201',433211.00,433211.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50727',1021763,'1482','201',50337.00,50337.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50727',1021764,'1483','201',289371.00,289371.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50727',1021765,'1484','201',321098.00,325399.00,4301.00,615043.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50727',1021766,'1485','201',414889.00,419774.00,4885.00,698555.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50727',1021767,'1486','201',319047.00,319047.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50727',1021768,'1487','201',449127.00,449127.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50727',1021769,'1488','202',154459.00,154633.00,174.00,39150.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50727',1021770,'1489','202',295505.00,296548.00,1043.00,234675.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50727',1021771,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50729',1021778,'1480','201',331502.00,331502.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50729',1021779,'1481','201',433211.00,435902.00,2691.00,384813.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50729',1021780,'1482','201',50337.00,50337.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50729',1021781,'1483','201',289371.00,291838.00,2467.00,352781.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50729',1021782,'1484','201',325399.00,329775.00,4376.00,625768.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50729',1021783,'1485','201',419774.00,423748.00,3974.00,568282.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50729',1021784,'1486','201',319047.00,319047.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50729',1021785,'1487','201',449127.00,449127.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50729',1021786,'1488','202',154633.00,154970.00,337.00,75825.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50729',1021787,'1489','202',296548.00,297308.00,760.00,171000.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50729',1021788,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50730',1021789,'1480','201',331502.00,333498.00,1996.00,285428.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50730',1021790,'1481','201',435902.00,438080.00,2178.00,311454.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50730',1021791,'1482','201',50337.00,51619.00,1282.00,183326.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50730',1021792,'1483','201',291838.00,293962.00,2124.00,303732.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50730',1021793,'1484','201',329775.00,331195.00,1420.00,203060.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50730',1021794,'1485','201',423748.00,425955.00,2207.00,315601.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50730',1021795,'1486','201',319047.00,319047.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50730',1021796,'1487','201',449127.00,449127.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50730',1021797,'1488','202',154970.00,155261.00,291.00,65475.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50730',1021798,'1489','202',297308.00,298755.00,1447.00,325575.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50730',1021799,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50731',1021800,'1480','201',333498.00,335772.00,2274.00,325182.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50731',1021801,'1481','201',438080.00,440941.00,2861.00,409123.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50731',1021802,'1482','201',51619.00,53213.00,1594.00,227942.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50731',1021803,'1483','201',293962.00,297307.00,3345.00,478335.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50731',1021804,'1484','201',331195.00,331746.00,551.00,78793.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50731',1021805,'1485','201',425955.00,427866.00,1911.00,273273.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50731',1021806,'1486','201',319047.00,319047.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50731',1021807,'1487','201',449127.00,449786.00,659.00,94237.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50731',1021808,'1488','202',155261.00,156361.00,1100.00,247500.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50731',1021809,'1489','202',298755.00,299155.00,400.00,90000.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50731',1021810,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50734',1021866,'1480','201',335772.00,337609.00,1837.00,262691.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50734',1021867,'1481','201',440941.00,442812.00,1871.00,267553.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50734',1021868,'1482','201',53213.00,54486.00,1273.00,182039.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50734',1021869,'1483','201',297307.00,299566.00,2259.00,323037.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50734',1021870,'1484','201',331746.00,331746.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50734',1021871,'1485','201',427866.00,427866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50734',1021872,'1486','201',319047.00,320200.00,1153.00,164879.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50734',1021873,'1487','201',449786.00,451659.00,1873.00,267839.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50734',1021874,'1488','202',156361.00,156541.00,180.00,40500.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50734',1021875,'1489','202',299155.00,300167.00,1012.00,227700.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50734',1021876,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50737',1021916,'1480','201',337609.00,339528.00,1919.00,274417.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50737',1021917,'1481','201',442812.00,444982.00,2170.00,310310.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50737',1021918,'1482','201',54486.00,56215.00,1729.00,247247.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50737',1021919,'1483','201',299566.00,302314.00,2748.00,392964.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50737',1021920,'1484','201',331746.00,331746.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50737',1021921,'1485','201',427866.00,427866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50737',1021922,'1486','201',320200.00,321355.00,1155.00,165165.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50737',1021923,'1487','201',451659.00,453098.00,1439.00,205777.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50737',1021924,'1488','202',156541.00,156541.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50737',1021925,'1489','202',300167.00,300850.00,683.00,153675.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50737',1021926,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50739',1021957,'1480','201',339528.00,339528.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50739',1021958,'1481','201',444982.00,445637.00,655.00,93665.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50739',1021959,'1482','201',56215.00,56215.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','50739',1021960,'1483','201',302314.00,302751.00,437.00,62491.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50739',1021961,'1484','201',331746.00,331746.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','50739',1021962,'1485','201',427866.00,427866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50739',1021963,'1486','201',321355.00,325109.00,3754.00,536822.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','50739',1021964,'1487','201',453098.00,457644.00,4546.00,650078.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50739',1021965,'1488','202',156541.00,156696.00,155.00,34875.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','50739',1021966,'1489','202',300850.00,302688.00,1838.00,413550.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','50739',1021967,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51025',1027634,'1480','201',339528.00,339528.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51025',1027635,'1481','201',445637.00,445637.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51025',1027636,'1482','201',56215.00,56215.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51025',1027637,'1483','201',302751.00,302751.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51025',1027638,'1484','201',331746.00,331746.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51025',1027639,'1485','201',427866.00,427866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51025',1027640,'1486','201',325109.00,329856.00,4747.00,678821.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51025',1027641,'1487','201',457644.00,462777.00,5133.00,734019.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51025',1027642,'1488','202',156696.00,156871.00,175.00,39375.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51025',1027643,'1489','202',302688.00,304461.00,1773.00,398925.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51025',1027644,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51026',1027645,'1480','201',339528.00,341038.00,1510.00,215930.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51026',1027646,'1481','201',445637.00,447548.00,1911.00,273273.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51026',1027647,'1482','201',56215.00,57118.00,903.00,129129.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51026',1027648,'1483','201',302751.00,304625.00,1874.00,267982.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51026',1027649,'1484','201',331746.00,331746.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51026',1027650,'1485','201',427866.00,427866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51026',1027651,'1486','201',329856.00,331556.00,1700.00,243100.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51026',1027652,'1487','201',462777.00,464856.00,2079.00,297297.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51026',1027653,'1488','202',156871.00,158247.00,1376.00,309600.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51026',1027654,'1489','202',304461.00,305342.00,881.00,198225.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51026',1027655,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51027',1027656,'1480','201',341038.00,344492.00,3454.00,493922.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51027',1027657,'1481','201',447548.00,450452.00,2904.00,415272.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51027',1027658,'1482','201',57118.00,59899.00,2781.00,397683.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51027',1027659,'1483','201',304625.00,309081.00,4456.00,637208.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51027',1027660,'1484','201',331746.00,331746.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51027',1027661,'1485','201',427866.00,427866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51027',1027662,'1486','201',331556.00,331556.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51027',1027663,'1487','201',464856.00,464856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51027',1027664,'1488','202',158247.00,158864.00,617.00,138825.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51027',1027665,'1489','202',305342.00,306620.00,1278.00,287550.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51027',1027666,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51028',1027667,'1480','201',344492.00,345647.00,1155.00,165165.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51028',1027668,'1481','201',450452.00,452245.00,1793.00,256399.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51028',1027669,'1482','201',59899.00,61104.00,1205.00,172315.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51028',1027670,'1483','201',309081.00,310830.00,1749.00,250107.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51028',1027671,'1484','201',331746.00,332882.00,1136.00,162448.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51028',1027672,'1485','201',427866.00,429306.00,1440.00,205920.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51028',1027673,'1486','201',331556.00,332268.00,712.00,101816.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51028',1027674,'1487','201',464856.00,466182.00,1326.00,189618.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51028',1027675,'1488','202',158864.00,161355.00,2491.00,560475.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51028',1027676,'1489','202',306620.00,307141.00,521.00,117225.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51028',1027677,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51285',1032935,'1480','201',345647.00,345647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51285',1032936,'1481','201',452245.00,455127.00,2882.00,412126.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51285',1032937,'1482','201',61104.00,61104.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51285',1032938,'1483','201',310830.00,314446.00,3616.00,517088.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51285',1032939,'1484','201',332882.00,334709.00,1827.00,261261.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51285',1032940,'1485','201',429306.00,430597.00,1291.00,184613.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51285',1032941,'1486','201',332268.00,334064.00,1796.00,256828.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51285',1032942,'1487','201',466182.00,468342.00,2160.00,308880.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51285',1032943,'1488','202',161355.00,162266.00,911.00,204975.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51285',1032944,'1489','202',307141.00,307269.00,128.00,28800.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51285',1032945,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51286',1032946,'1480','201',345647.00,346891.00,1244.00,177892.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51286',1032947,'1481','201',455127.00,457668.00,2541.00,363363.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51286',1032948,'1482','201',61104.00,61104.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51286',1032949,'1483','201',314446.00,317152.00,2706.00,386958.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51286',1032950,'1484','201',334709.00,335792.00,1083.00,154869.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51286',1032951,'1485','201',430597.00,432768.00,2171.00,310453.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51286',1032952,'1486','201',334064.00,334064.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51286',1032953,'1487','201',468342.00,470138.00,1796.00,256828.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51286',1032954,'1488','202',162266.00,162716.00,450.00,101250.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51286',1032955,'1489','202',307269.00,308185.00,916.00,206100.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51286',1032956,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51287',1032957,'1480','201',346891.00,349155.00,2264.00,323752.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51287',1032958,'1481','201',457668.00,460019.00,2351.00,336193.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51287',1032959,'1482','201',61104.00,61125.00,21.00,3003.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51287',1032960,'1483','201',317152.00,320298.00,3146.00,449878.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51287',1032961,'1484','201',335792.00,338539.00,2747.00,392821.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51287',1032962,'1485','201',432768.00,433921.00,1153.00,164879.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51287',1032963,'1486','201',334064.00,334064.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51287',1032964,'1487','201',470138.00,472466.00,2328.00,332904.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51287',1032965,'1488','202',162716.00,163900.00,1184.00,266400.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51287',1032966,'1489','202',308185.00,308369.00,184.00,41400.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51287',1032967,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51288',1032968,'1480','201',349155.00,351059.00,1904.00,272272.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51288',1032969,'1481','201',460019.00,461938.00,1919.00,274417.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51288',1032970,'1482','201',61125.00,61125.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51288',1032971,'1483','201',320298.00,322759.00,2461.00,351923.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51288',1032972,'1484','201',338539.00,340333.00,1794.00,256542.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51288',1032973,'1485','201',433921.00,437004.00,3083.00,440869.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51288',1032974,'1486','201',334064.00,334064.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51288',1032975,'1487','201',472466.00,474499.00,2033.00,290719.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51288',1032976,'1488','202',163900.00,164965.00,1065.00,239625.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51288',1032977,'1489','202',308369.00,308369.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51288',1032978,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51289',1032979,'1480','201',351059.00,352972.00,1913.00,273559.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51289',1032980,'1481','201',461938.00,463512.00,1574.00,225082.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51289',1032981,'1482','201',61125.00,61125.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51289',1032982,'1483','201',322759.00,324630.00,1871.00,267553.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51289',1032983,'1484','201',340333.00,341600.00,1267.00,181181.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51289',1032984,'1485','201',437004.00,439074.00,2070.00,296010.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51289',1032985,'1486','201',334064.00,334064.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51289',1032986,'1487','201',474499.00,476442.00,1943.00,277849.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51289',1032987,'1488','202',164965.00,165531.00,566.00,127350.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51289',1032988,'1489','202',308369.00,308369.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51289',1032989,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51290',1032990,'1480','201',352972.00,352972.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51290',1032991,'1481','201',463512.00,465303.00,1791.00,256113.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51290',1032992,'1482','201',61125.00,61125.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51290',1032993,'1483','201',324630.00,326491.00,1861.00,266123.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51290',1032994,'1484','201',341600.00,343484.00,1884.00,269412.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51290',1032995,'1485','201',439074.00,441572.00,2498.00,357214.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51290',1032996,'1486','201',334064.00,334064.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51290',1032997,'1487','201',476442.00,479317.00,2875.00,411125.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51290',1032998,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51290',1032999,'1489','202',308369.00,309535.00,1166.00,262350.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51290',1033000,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51291',1033001,'1480','201',352972.00,356712.00,3740.00,534820.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51291',1033002,'1481','201',465303.00,465303.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51291',1033003,'1482','201',61125.00,62664.00,1539.00,220077.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51291',1033004,'1483','201',326491.00,327918.00,1427.00,204061.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51291',1033005,'1484','201',343484.00,345223.00,1739.00,248677.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51291',1033006,'1485','201',441572.00,443365.00,1793.00,256399.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51291',1033007,'1486','201',334064.00,336317.00,2253.00,322179.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51291',1033008,'1487','201',479317.00,480379.00,1062.00,151866.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51291',1033009,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51291',1033010,'1489','202',309535.00,309535.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51291',1033011,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51875',1044457,'1480','201',356712.00,358298.00,1586.00,226798.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51875',1044458,'1481','201',465303.00,467154.00,1851.00,264693.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51875',1044459,'1482','201',62664.00,62664.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51875',1044460,'1483','201',327918.00,329603.00,1685.00,240955.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51875',1044461,'1484','201',345223.00,345223.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51875',1044462,'1485','201',443365.00,445650.00,2285.00,326755.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51875',1044463,'1486','201',336317.00,336317.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51875',1044464,'1487','201',480379.00,482097.00,1718.00,245674.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51875',1044465,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51875',1044466,'1489','202',309535.00,309711.00,176.00,39600.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51875',1044467,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51876',1044468,'1480','201',358298.00,358298.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51876',1044469,'1481','201',467154.00,470322.00,3168.00,453024.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51876',1044470,'1482','201',62664.00,64358.00,1694.00,242242.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51876',1044471,'1483','201',329603.00,329603.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51876',1044472,'1484','201',345223.00,346991.00,1768.00,252824.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51876',1044473,'1485','201',445650.00,447620.00,1970.00,281710.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51876',1044474,'1486','201',336317.00,337048.00,731.00,104533.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51876',1044475,'1487','201',482097.00,482097.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51876',1044476,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51876',1044477,'1489','202',309711.00,310206.00,495.00,111375.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51876',1044478,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51877',1044479,'1480','201',358298.00,358298.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51877',1044480,'1481','201',470322.00,470322.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51877',1044481,'1482','201',64358.00,64358.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51877',1044482,'1483','201',329603.00,332133.00,2530.00,361790.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51877',1044483,'1484','201',346991.00,346991.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51877',1044484,'1485','201',447620.00,449617.00,1997.00,285571.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51877',1044485,'1486','201',337048.00,338400.00,1352.00,193336.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51877',1044486,'1487','201',482097.00,483291.00,1194.00,170742.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51877',1044487,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51877',1044488,'1489','202',310206.00,310206.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51877',1044489,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51900',1044855,'1480','201',358298.00,360585.00,2287.00,327041.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51900',1044856,'1481','201',470322.00,475360.00,5038.00,720434.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51900',1044857,'1482','201',64358.00,66088.00,1730.00,247390.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51900',1044858,'1483','201',332133.00,334024.00,1891.00,270413.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51900',1044859,'1484','201',346991.00,347910.00,919.00,131417.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51900',1044860,'1485','201',449617.00,451744.00,2127.00,304161.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51900',1044861,'1486','201',338400.00,338400.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51900',1044862,'1487','201',483291.00,485389.00,2098.00,300014.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51900',1044863,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51900',1044864,'1489','202',310206.00,310206.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51900',1044865,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51902',1044877,'1480','201',360585.00,362516.00,1931.00,276133.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51902',1044878,'1481','201',475360.00,477677.00,2317.00,331331.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51902',1044879,'1482','201',66088.00,66088.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51902',1044880,'1483','201',334024.00,336164.00,2140.00,306020.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51902',1044881,'1484','201',347910.00,349034.00,1124.00,160732.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51902',1044882,'1485','201',451744.00,453575.00,1831.00,261833.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51902',1044883,'1486','201',338400.00,339312.00,912.00,130416.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51902',1044884,'1487','201',485389.00,487239.00,1850.00,264550.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51902',1044885,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51902',1044886,'1489','202',310206.00,310206.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51902',1044887,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51905',1044936,'1480','201',362516.00,363224.00,708.00,101244.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51905',1044937,'1481','201',477677.00,478999.00,1322.00,189046.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51905',1044938,'1482','201',66088.00,66777.00,689.00,98527.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51905',1044939,'1483','201',336164.00,336983.00,819.00,117117.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51905',1044940,'1484','201',349034.00,351982.00,2948.00,421564.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51905',1044941,'1485','201',453575.00,457147.00,3572.00,510796.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51905',1044942,'1486','201',339312.00,341016.00,1704.00,243672.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51905',1044943,'1487','201',487239.00,490135.00,2896.00,414128.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51905',1044944,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51905',1044945,'1489','202',310206.00,310206.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51905',1044946,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51908',1044994,'1480','201',363224.00,363224.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51908',1044995,'1481','201',478999.00,478999.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51908',1044996,'1482','201',66777.00,66777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51908',1044997,'1483','201',336983.00,336983.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51908',1044998,'1484','201',351982.00,353110.00,1128.00,161304.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51908',1044999,'1485','201',457147.00,458600.00,1453.00,207779.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51908',1045000,'1486','201',341016.00,344765.00,3749.00,536107.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51908',1045001,'1487','201',490135.00,494378.00,4243.00,606749.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51908',1045002,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51908',1045003,'1489','202',310206.00,310307.00,101.00,22725.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51908',1045004,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51911',1045050,'1480','201',363224.00,363224.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51911',1045051,'1481','201',478999.00,478999.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51911',1045052,'1482','201',66777.00,66777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51911',1045053,'1483','201',336983.00,336983.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51911',1045054,'1484','201',353110.00,353110.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51911',1045055,'1485','201',458600.00,458600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51911',1045056,'1486','201',344765.00,349127.00,4362.00,623766.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51911',1045057,'1487','201',494378.00,498830.00,4452.00,636636.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51911',1045058,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51911',1045059,'1489','202',310307.00,310307.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51911',1045060,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51913',1045084,'1480','201',363224.00,363224.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51913',1045085,'1481','201',478999.00,478999.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51913',1045086,'1482','201',66777.00,66777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51913',1045087,'1483','201',336983.00,336983.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51913',1045088,'1484','201',353110.00,353110.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51913',1045089,'1485','201',458600.00,458600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51913',1045090,'1486','201',349127.00,353124.00,3997.00,571571.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51913',1045091,'1487','201',498830.00,503246.00,4416.00,631488.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51913',1045092,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51913',1045093,'1489','202',310307.00,310307.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51913',1045094,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51914',1045095,'1480','201',363224.00,363224.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51914',1045096,'1481','201',478999.00,478999.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51914',1045097,'1482','201',66777.00,66777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51914',1045098,'1483','201',336983.00,336983.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51914',1045099,'1484','201',353110.00,353110.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51914',1045100,'1485','201',458600.00,458600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51914',1045101,'1486','201',353124.00,357627.00,4503.00,643929.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51914',1045102,'1487','201',503246.00,507634.00,4388.00,627484.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51914',1045103,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51914',1045104,'1489','202',310307.00,310307.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51914',1045105,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51915',1045106,'1480','201',363224.00,363224.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51915',1045107,'1481','201',478999.00,478999.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51915',1045108,'1482','201',66777.00,66777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51915',1045109,'1483','201',336983.00,336983.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51915',1045110,'1484','201',353110.00,353110.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51915',1045111,'1485','201',458600.00,458600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51915',1045112,'1486','201',357627.00,357945.00,318.00,45474.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51915',1045113,'1487','201',507634.00,508024.00,390.00,55770.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51915',1045114,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51915',1045115,'1489','202',310307.00,310307.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51915',1045116,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51997',1046735,'1480','201',363224.00,363224.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51997',1046736,'1481','201',478999.00,478999.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51997',1046737,'1482','201',66777.00,66777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','51997',1046738,'1483','201',336983.00,336983.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51997',1046739,'1484','201',353110.00,353110.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','51997',1046740,'1485','201',458600.00,458600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51997',1046741,'1486','201',357945.00,357945.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','51997',1046742,'1487','201',508024.00,508024.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51997',1046743,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','51997',1046744,'1489','202',310307.00,310307.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','51997',1046745,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52350',1053724,'1480','201',363224.00,363615.00,391.00,55913.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52350',1053725,'1481','201',478999.00,479906.00,907.00,129701.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52350',1053726,'1482','201',66777.00,67156.00,379.00,54197.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52350',1053727,'1483','201',336983.00,337993.00,1010.00,144430.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52350',1053728,'1484','201',353110.00,353110.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52350',1053729,'1485','201',458600.00,458600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52350',1053730,'1486','201',357945.00,357945.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52350',1053731,'1487','201',508024.00,508303.00,279.00,39897.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52350',1053732,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52350',1053733,'1489','202',310307.00,310437.00,130.00,29250.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52350',1053734,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52354',1053780,'1480','201',363615.00,365201.00,1586.00,226798.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52354',1053781,'1481','201',479906.00,481719.00,1813.00,259259.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52354',1053782,'1482','201',67156.00,67177.00,11.00,1573.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','52354',1053783,'1483','201',337993.00,340546.00,2553.00,365079.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52354',1053784,'1484','201',353110.00,354380.00,1260.00,180180.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','52354',1053785,'1485','201',458600.00,460390.00,1790.00,255970.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52354',1053786,'1486','201',357945.00,357955.00,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','52354',1053787,'1487','201',508303.00,510242.00,1929.00,275847.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','52354',1053788,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52354',1053789,'1489','202',310437.00,310437.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52354',1053790,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52355',1053791,'1480','201',365201.00,366798.00,1597.00,228371.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52355',1053792,'1481','201',481719.00,483788.00,2069.00,295867.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52355',1053793,'1482','201',67177.00,67177.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52355',1053794,'1483','201',340546.00,342119.00,1573.00,224939.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52355',1053795,'1484','201',354380.00,355594.00,1214.00,173602.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52355',1053796,'1485','201',460390.00,461007.00,617.00,88231.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52355',1053797,'1486','201',357955.00,358727.00,772.00,110396.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52355',1053798,'1487','201',510242.00,511149.00,907.00,129701.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52355',1053799,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52355',1053800,'1489','202',310437.00,310437.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52355',1053801,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52356',1053802,'1480','201',366798.00,368227.00,1429.00,204347.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52356',1053803,'1481','201',483788.00,485937.00,2149.00,307307.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52356',1053804,'1482','201',67177.00,69301.00,2124.00,303732.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52356',1053805,'1483','201',342119.00,342119.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52356',1053806,'1484','201',355594.00,356692.00,1098.00,157014.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52356',1053807,'1485','201',461007.00,463089.00,2082.00,297726.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52356',1053808,'1486','201',358727.00,358727.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52356',1053809,'1487','201',511149.00,512750.00,1601.00,228943.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52356',1053810,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52356',1053811,'1489','202',310437.00,310437.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52356',1053812,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52359',1053857,'1480','201',368227.00,369371.00,1144.00,163592.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52359',1053858,'1481','201',485937.00,488486.00,2549.00,364507.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52359',1053859,'1482','201',69301.00,69301.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52359',1053860,'1483','201',342119.00,343791.00,1672.00,239096.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52359',1053861,'1484','201',356692.00,358048.00,1356.00,193908.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52359',1053862,'1485','201',463089.00,464956.00,1867.00,266981.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52359',1053863,'1486','201',358727.00,358727.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52359',1053864,'1487','201',512750.00,514929.00,2179.00,311597.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52359',1053865,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52359',1053866,'1489','202',310437.00,310437.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52359',1053867,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52362',1053917,'1480','201',369371.00,371834.00,2463.00,352209.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52362',1053918,'1481','201',488486.00,490955.00,2469.00,353067.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52362',1053919,'1482','201',69301.00,71742.00,2441.00,349063.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52362',1053920,'1483','201',343791.00,343791.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52362',1053921,'1484','201',358048.00,359461.00,1413.00,202059.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52362',1053922,'1485','201',464956.00,466945.00,1989.00,284427.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52362',1053923,'1486','201',358727.00,359720.00,993.00,141999.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52362',1053924,'1487','201',514929.00,516429.00,1500.00,214500.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52362',1053925,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52362',1053926,'1489','202',310437.00,310437.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52362',1053927,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52365',1053974,'1480','201',371834.00,373846.00,2012.00,287716.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52365',1053975,'1481','201',490955.00,493125.00,2170.00,310310.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52365',1053976,'1482','201',71742.00,71742.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52365',1053977,'1483','201',343791.00,345975.00,2184.00,312312.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52365',1053978,'1484','201',359461.00,361077.00,1616.00,231088.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52365',1053979,'1485','201',466945.00,468138.00,1193.00,170599.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52365',1053980,'1486','201',359720.00,359724.00,4.00,572.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52365',1053981,'1487','201',516429.00,517703.00,1274.00,182182.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52365',1053982,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52365',1053983,'1489','202',310437.00,310530.00,93.00,20925.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52365',1053984,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52511',1056879,'1480','201',373846.00,374591.00,745.00,106535.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52511',1056880,'1481','201',493125.00,493163.00,38.00,5434.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52511',1056881,'1482','201',71742.00,72286.00,544.00,77792.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52511',1056882,'1483','201',345975.00,346364.00,389.00,55627.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52511',1056883,'1484','201',361077.00,363930.00,2853.00,407979.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52511',1056884,'1485','201',468138.00,471948.00,3810.00,544830.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52511',1056885,'1486','201',359724.00,361192.00,1468.00,209924.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52511',1056886,'1487','201',517703.00,518197.00,494.00,70642.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52511',1056887,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52511',1056888,'1489','202',310530.00,310530.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52511',1056889,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52686',1060480,'1480','201',374591.00,374591.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52686',1060481,'1481','201',493163.00,493163.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52686',1060482,'1482','201',72286.00,72286.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52686',1060483,'1483','201',346364.00,346364.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52686',1060484,'1484','201',363930.00,365233.00,1303.00,186329.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52686',1060485,'1485','201',471948.00,473379.00,1431.00,204633.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52686',1060486,'1486','201',361192.00,361192.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52686',1060487,'1487','201',518197.00,518197.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52686',1060488,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52686',1060489,'1489','202',310530.00,310530.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52686',1060490,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52687',1060491,'1480','201',374591.00,374591.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52687',1060492,'1481','201',493163.00,493163.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52687',1060493,'1482','201',72286.00,72286.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52687',1060494,'1483','201',346364.00,346364.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52687',1060495,'1484','201',365233.00,365233.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52687',1060496,'1485','201',473379.00,473379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52687',1060497,'1486','201',361192.00,361192.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52687',1060498,'1487','201',518197.00,518197.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52687',1060499,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52687',1060500,'1489','202',310530.00,310530.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52687',1060501,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52689',1060512,'1480','201',374591.00,375228.00,637.00,91091.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52689',1060513,'1481','201',493163.00,494253.00,1090.00,155870.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52689',1060514,'1482','201',72286.00,72709.00,423.00,60489.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52689',1060515,'1483','201',346364.00,347255.00,891.00,127413.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52689',1060516,'1484','201',365233.00,365233.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52689',1060517,'1485','201',473379.00,473970.00,591.00,84513.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52689',1060518,'1486','201',361192.00,361258.00,66.00,9438.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52689',1060519,'1487','201',518197.00,518620.00,423.00,60489.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52689',1060520,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52689',1060521,'1489','202',310530.00,310530.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52689',1060522,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52692',1060553,'1480','201',375228.00,377150.00,1922.00,274846.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52692',1060554,'1481','201',494253.00,496441.00,2188.00,312884.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52692',1060555,'1482','201',72709.00,74365.00,1656.00,236808.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52692',1060556,'1483','201',347255.00,349177.00,1922.00,274846.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52692',1060557,'1484','201',365233.00,366590.00,1357.00,194051.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52692',1060558,'1485','201',473970.00,476165.00,2195.00,313885.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52692',1060559,'1486','201',361258.00,362791.00,1533.00,219219.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52692',1060560,'1487','201',518620.00,518620.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52692',1060561,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52692',1060562,'1489','202',310530.00,310530.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52692',1060563,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52694',1060580,'1480','201',377150.00,378668.00,1518.00,217074.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52694',1060581,'1481','201',496441.00,498191.00,1750.00,250250.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52694',1060582,'1482','201',74365.00,74380.00,15.00,2145.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52694',1060583,'1483','201',349177.00,351221.00,2044.00,292292.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52694',1060584,'1484','201',366590.00,367207.00,617.00,88231.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52694',1060585,'1485','201',476165.00,478099.00,1934.00,276562.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52694',1060586,'1486','201',362791.00,362791.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52694',1060587,'1487','201',518620.00,520495.00,1875.00,268125.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52694',1060588,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52694',1060589,'1489','202',310530.00,310623.00,93.00,20925.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52694',1060590,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52745',1061585,'1480','201',378668.00,380404.00,1736.00,248248.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52745',1061586,'1481','201',498191.00,500922.00,2731.00,390533.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52745',1061587,'1482','201',74380.00,76211.00,1831.00,261833.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','52745',1061588,'1483','201',351221.00,353695.00,2474.00,353782.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52745',1061589,'1484','201',367207.00,367207.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','52745',1061590,'1485','201',478099.00,480862.00,2763.00,395109.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52745',1061591,'1486','201',362791.00,364593.00,1802.00,257686.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','52745',1061592,'1487','201',520495.00,520495.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52745',1061593,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','52745',1061594,'1489','202',310623.00,310934.00,311.00,69975.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','52745',1061595,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53002',1066696,'1480','201',380404.00,380404.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53002',1066697,'1481','201',500922.00,504159.00,3237.00,462891.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53002',1066698,'1482','201',76211.00,76211.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53002',1066699,'1483','201',353695.00,355384.00,1689.00,241527.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53002',1066700,'1484','201',367207.00,368861.00,1654.00,236522.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53002',1066701,'1485','201',480862.00,482874.00,2012.00,287716.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53002',1066702,'1486','201',364593.00,364593.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53002',1066703,'1487','201',520495.00,522313.00,1818.00,259974.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53002',1066704,'1488','202',165531.00,165531.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53002',1066705,'1489','202',310934.00,311537.00,603.00,135675.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53002',1066706,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53004',1066729,'1480','201',380404.00,382019.00,1615.00,230945.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53004',1066730,'1481','201',504159.00,506075.00,1916.00,273988.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53004',1066731,'1482','201',76211.00,78496.00,2285.00,326755.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53004',1066732,'1483','201',355384.00,355384.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53004',1066733,'1484','201',368861.00,369575.00,714.00,102102.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53004',1066734,'1485','201',482874.00,485845.00,2971.00,424853.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53004',1066735,'1486','201',364593.00,365920.00,1327.00,189761.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53004',1066736,'1487','201',522313.00,524196.00,1883.00,269269.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53004',1066737,'1488','202',165531.00,166264.00,733.00,164925.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53004',1066738,'1489','202',311537.00,311548.00,11.00,2475.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53004',1066739,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53005',1066740,'1480','201',382019.00,383560.00,1541.00,220363.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53005',1066741,'1481','201',506075.00,508399.00,2324.00,332332.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53005',1066742,'1482','201',78496.00,78998.00,502.00,71786.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53005',1066743,'1483','201',355384.00,357043.00,1659.00,237237.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53005',1066744,'1484','201',369575.00,369575.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53005',1066745,'1485','201',485845.00,487669.00,1824.00,260832.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53005',1066746,'1486','201',365920.00,367316.00,1396.00,199628.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53005',1066747,'1487','201',524196.00,524196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53005',1066748,'1488','202',166264.00,166803.00,539.00,121275.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53005',1066749,'1489','202',311548.00,311908.00,360.00,81000.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53005',1066750,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53006',1066751,'1480','201',383560.00,385689.00,2129.00,304447.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53006',1066752,'1481','201',508399.00,509681.00,1282.00,183326.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53006',1066753,'1482','201',78998.00,80026.00,1028.00,147004.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53006',1066754,'1483','201',357043.00,359078.00,2035.00,291005.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53006',1066755,'1484','201',369575.00,371413.00,1838.00,262834.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53006',1066756,'1485','201',487669.00,487669.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53006',1066757,'1486','201',367316.00,367316.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53006',1066758,'1487','201',524196.00,525827.00,1631.00,233233.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53006',1066759,'1488','202',166803.00,167587.00,784.00,176400.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53006',1066760,'1489','202',311908.00,311999.00,91.00,20475.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53006',1066761,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53008',1066774,'1480','201',385689.00,387789.00,2100.00,300300.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53008',1066775,'1481','201',509681.00,511106.00,1425.00,203775.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53008',1066776,'1482','201',80026.00,80026.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53008',1066777,'1483','201',359078.00,361368.00,2290.00,327470.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53008',1066778,'1484','201',371413.00,372674.00,1261.00,180323.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53008',1066779,'1485','201',487669.00,489112.00,1443.00,206349.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53008',1066780,'1486','201',367316.00,367316.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53008',1066781,'1487','201',525827.00,527937.00,2110.00,301730.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53008',1066782,'1488','202',167587.00,168232.00,645.00,145125.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53008',1066783,'1489','202',311999.00,312187.00,188.00,42300.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53008',1066784,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53121',1068914,'1480','201',387789.00,389851.00,2062.00,294866.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53121',1068915,'1481','201',511106.00,512943.00,1837.00,262691.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53121',1068916,'1482','201',80026.00,81710.00,1684.00,240812.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53121',1068917,'1483','201',361368.00,363800.00,2432.00,347776.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53121',1068918,'1484','201',372674.00,373657.00,983.00,140569.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53121',1068919,'1485','201',489112.00,491507.00,2395.00,342485.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53121',1068920,'1486','201',367316.00,369671.00,2355.00,336765.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53121',1068921,'1487','201',527937.00,527951.00,14.00,2002.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53121',1068922,'1488','202',168232.00,168232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53121',1068923,'1489','202',312187.00,312648.00,461.00,103725.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53121',1068924,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53122',1068925,'1480','201',389851.00,391089.00,1238.00,177034.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53122',1068926,'1481','201',512943.00,514378.00,1435.00,205205.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53122',1068927,'1482','201',81710.00,82444.00,734.00,104962.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53122',1068928,'1483','201',363800.00,363847.00,47.00,6721.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53122',1068929,'1484','201',373657.00,375611.00,1954.00,279422.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53122',1068930,'1485','201',491507.00,493668.00,2161.00,309023.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53122',1068931,'1486','201',369671.00,369671.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53122',1068932,'1487','201',527951.00,529856.00,1905.00,272415.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53122',1068933,'1488','202',168232.00,169044.00,812.00,182700.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53122',1068934,'1489','202',312648.00,312674.00,26.00,5850.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53122',1068935,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53156',1069556,'1480','201',391089.00,394649.00,3560.00,509080.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53156',1069557,'1481','201',514378.00,514378.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53156',1069558,'1482','201',82444.00,84227.00,1783.00,254969.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53156',1069559,'1483','201',363847.00,366008.00,2161.00,309023.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53156',1069560,'1484','201',375611.00,377061.00,1450.00,207350.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53156',1069561,'1485','201',493668.00,495535.00,1867.00,266981.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53156',1069562,'1486','201',369671.00,372193.00,2522.00,360646.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53156',1069563,'1487','201',529856.00,529856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53156',1069564,'1488','202',169044.00,169539.00,495.00,111375.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53156',1069565,'1489','202',312674.00,313243.00,569.00,128025.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53156',1069566,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53224',1070891,'1480','201',394649.00,394649.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53224',1070892,'1481','201',514378.00,516963.00,2585.00,369655.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53224',1070893,'1482','201',84227.00,84227.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53224',1070894,'1483','201',366008.00,368661.00,2653.00,379379.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53224',1070895,'1484','201',377061.00,378176.00,1115.00,159445.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53224',1070896,'1485','201',495535.00,497869.00,2334.00,333762.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53224',1070897,'1486','201',372193.00,372193.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53224',1070898,'1487','201',529856.00,531774.00,1918.00,274274.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53224',1070899,'1488','202',169539.00,170223.00,684.00,153900.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53224',1070900,'1489','202',313243.00,313480.00,237.00,53325.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53224',1070901,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53449',1075376,'1480','201',394649.00,397737.00,3068.00,438724.00,0.00,0.00,20.00,0.00,0.00),('1','64','536','53449',1075377,'1481','201',516963.00,516963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53449',1075378,'1482','201',84227.00,85540.00,1293.00,184899.00,0.00,0.00,20.00,0.00,0.00),('1','64','536','53449',1075379,'1483','201',368661.00,370550.00,1879.00,268697.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','53449',1075380,'1484','201',378176.00,379188.00,1002.00,143286.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','53449',1075381,'1485','201',497869.00,499972.00,2093.00,299299.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','53449',1075382,'1486','201',372193.00,374283.00,2080.00,297440.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','53449',1075383,'1487','201',531774.00,531774.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53449',1075384,'1488','202',170223.00,170750.00,507.00,114075.00,0.00,0.00,20.00,0.00,0.00),('1','64','539','53449',1075385,'1489','202',313480.00,313480.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53449',1075386,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53454',1075494,'1480','201',397737.00,399556.00,1819.00,260117.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53454',1075495,'1481','201',516963.00,518304.00,1341.00,191763.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53454',1075496,'1482','201',85540.00,85540.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53454',1075497,'1483','201',370550.00,372260.00,1710.00,244530.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53454',1075498,'1484','201',379188.00,379188.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53454',1075499,'1485','201',499972.00,502853.00,2881.00,411983.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53454',1075500,'1486','201',374283.00,374283.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53454',1075501,'1487','201',531774.00,533752.00,1978.00,282854.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53454',1075502,'1488','202',170750.00,171213.00,463.00,104175.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53454',1075503,'1489','202',313480.00,313944.00,464.00,104400.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53454',1075504,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53457',1075545,'1480','201',399556.00,399556.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53457',1075546,'1481','201',518304.00,521614.00,3310.00,473330.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53457',1075547,'1482','201',85540.00,87130.00,1590.00,227370.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53457',1075548,'1483','201',372260.00,373865.00,1605.00,229515.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53457',1075549,'1484','201',379188.00,380739.00,1551.00,221793.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53457',1075550,'1485','201',502853.00,504829.00,1976.00,282568.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53457',1075551,'1486','201',374283.00,376250.00,1967.00,281281.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53457',1075552,'1487','201',533752.00,533752.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53457',1075553,'1488','202',171213.00,171213.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53457',1075554,'1489','202',313944.00,314223.00,279.00,62775.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53457',1075555,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53458',1075556,'1480','201',399556.00,401522.00,1966.00,281138.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53458',1075557,'1481','201',521614.00,524540.00,2926.00,418418.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53458',1075558,'1482','201',87130.00,87130.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53458',1075559,'1483','201',373865.00,376547.00,2682.00,383526.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53458',1075560,'1484','201',380739.00,381934.00,1195.00,170885.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53458',1075561,'1485','201',504829.00,506080.00,1251.00,178893.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53458',1075562,'1486','201',376250.00,376250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53458',1075563,'1487','201',533752.00,536443.00,2691.00,384813.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53458',1075564,'1488','202',171213.00,173505.00,2292.00,515700.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53458',1075565,'1489','202',314223.00,314240.00,17.00,3825.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53458',1075566,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53734',1080963,'1480','201',401522.00,404114.00,2592.00,370656.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53734',1080964,'1481','201',524540.00,526814.00,2274.00,325182.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53734',1080965,'1482','201',87130.00,89113.00,1983.00,283569.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53734',1080966,'1483','201',376547.00,378300.00,1753.00,250679.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53734',1080967,'1484','201',381934.00,381934.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53734',1080968,'1485','201',506080.00,508487.00,2407.00,344201.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53734',1080969,'1486','201',376250.00,376250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53734',1080970,'1487','201',536443.00,538886.00,2443.00,349349.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53734',1080971,'1488','202',173505.00,174002.00,497.00,111825.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53734',1080972,'1489','202',314240.00,314268.00,28.00,6300.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53734',1080973,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53742',1081081,'1480','201',404114.00,405779.00,1665.00,238095.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53742',1081082,'1481','201',526814.00,528576.00,1762.00,251966.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53742',1081083,'1482','201',89113.00,89113.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53742',1081084,'1483','201',378300.00,380628.00,2328.00,332904.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53742',1081085,'1484','201',381934.00,383479.00,1545.00,220935.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53742',1081086,'1485','201',508487.00,509795.00,1308.00,187044.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53742',1081087,'1486','201',376250.00,376250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53742',1081088,'1487','201',538886.00,540876.00,1990.00,284570.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53742',1081089,'1488','202',174002.00,174819.00,817.00,183825.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53742',1081090,'1489','202',314268.00,314268.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53742',1081091,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53743',1081092,'1480','201',405779.00,408282.00,2503.00,357929.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53743',1081093,'1481','201',528576.00,531198.00,2622.00,374946.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53743',1081094,'1482','201',89113.00,90904.00,1791.00,256113.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53743',1081095,'1483','201',380628.00,380628.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53743',1081096,'1484','201',383479.00,384787.00,1308.00,187044.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53743',1081097,'1485','201',509795.00,511970.00,2175.00,311025.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53743',1081098,'1486','201',376250.00,378429.00,2179.00,311597.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53743',1081099,'1487','201',540876.00,540876.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53743',1081100,'1488','202',174819.00,175265.00,446.00,100350.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53743',1081101,'1489','202',314268.00,314268.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53743',1081102,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53744',1081103,'1480','201',408282.00,409443.00,1161.00,166023.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53744',1081104,'1481','201',531198.00,531198.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53744',1081105,'1482','201',90904.00,90904.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53744',1081106,'1483','201',380628.00,381406.00,778.00,111254.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53744',1081107,'1484','201',384787.00,386336.00,1549.00,221507.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53744',1081108,'1485','201',511970.00,513363.00,1393.00,199199.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53744',1081109,'1486','201',378429.00,379359.00,930.00,132990.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53744',1081110,'1487','201',540876.00,542069.00,1193.00,170599.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53744',1081111,'1488','202',175265.00,175638.00,373.00,83925.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53744',1081112,'1489','202',314268.00,314447.00,179.00,40275.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53744',1081113,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53746',1081130,'1480','201',409443.00,411191.00,1748.00,249964.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53746',1081131,'1481','201',531198.00,533268.00,2070.00,296010.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53746',1081132,'1482','201',90904.00,93545.00,2641.00,377663.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53746',1081133,'1483','201',381406.00,381406.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53746',1081134,'1484','201',386336.00,386336.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53746',1081135,'1485','201',513363.00,515414.00,2051.00,293293.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53746',1081136,'1486','201',379359.00,379359.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53746',1081137,'1487','201',542069.00,543826.00,1757.00,251251.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53746',1081138,'1488','202',175638.00,176211.00,573.00,128925.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53746',1081139,'1489','202',314447.00,314747.00,300.00,67500.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53746',1081140,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53882',1083889,'1480','201',411191.00,411191.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53882',1083890,'1481','201',533268.00,536258.00,2980.00,426140.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','53882',1083891,'1482','201',93545.00,95210.00,1655.00,236665.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','53882',1083892,'1483','201',381406.00,383796.00,2390.00,341770.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53882',1083893,'1484','201',386336.00,386336.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53882',1083894,'1485','201',515414.00,517361.00,1937.00,276991.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','53882',1083895,'1486','201',379359.00,379359.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53882',1083896,'1487','201',543826.00,545871.00,2035.00,291005.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','53882',1083897,'1488','202',176211.00,176436.00,225.00,50625.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53882',1083898,'1489','202',314747.00,315847.00,1090.00,245250.00,0.00,0.00,10.00,0.00,0.00),('1','64','540','53882',1083899,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53885',1083936,'1480','201',411191.00,413500.00,2309.00,330187.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53885',1083937,'1481','201',536258.00,538930.00,2672.00,382096.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53885',1083938,'1482','201',95210.00,98174.00,2964.00,423852.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53885',1083939,'1483','201',383796.00,383796.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53885',1083940,'1484','201',386336.00,388067.00,1731.00,247533.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53885',1083941,'1485','201',517361.00,519798.00,2437.00,348491.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53885',1083942,'1486','201',379359.00,382117.00,2758.00,394394.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53885',1083943,'1487','201',545871.00,545871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53885',1083944,'1488','202',176436.00,177161.00,725.00,163125.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53885',1083945,'1489','202',315847.00,315955.00,108.00,24300.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53885',1083946,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53889',1083996,'1480','201',413500.00,414678.00,1178.00,168454.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53889',1083997,'1481','201',538930.00,540841.00,1911.00,273273.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53889',1083998,'1482','201',98174.00,98955.00,781.00,111683.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53889',1083999,'1483','201',383796.00,385509.00,1713.00,244959.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53889',1084000,'1484','201',388067.00,390485.00,2418.00,345774.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53889',1084001,'1485','201',519798.00,520358.00,560.00,80080.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53889',1084002,'1486','201',382117.00,382117.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53889',1084003,'1487','201',545871.00,547477.00,1606.00,229658.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53889',1084004,'1488','202',177161.00,177464.00,303.00,68175.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53889',1084005,'1489','202',315955.00,316424.00,469.00,105525.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53889',1084006,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53991',1086131,'1480','201',414678.00,417076.00,2398.00,342914.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53991',1086132,'1481','201',540841.00,542657.00,1816.00,259688.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53991',1086133,'1482','201',98955.00,100125.00,1170.00,167310.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','53991',1086134,'1483','201',385509.00,387923.00,2414.00,345202.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53991',1086135,'1484','201',390485.00,390485.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','53991',1086136,'1485','201',520358.00,522598.00,2240.00,320320.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53991',1086137,'1486','201',382117.00,384564.00,2447.00,349921.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','53991',1086138,'1487','201',547477.00,547477.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53991',1086139,'1488','202',177464.00,178561.00,1097.00,246825.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','53991',1086140,'1489','202',316424.00,316425.00,1.00,225.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','53991',1086141,'1490','203',213008.57,213008.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54006',1086420,'1480','201',417076.00,418827.00,1751.00,250393.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54006',1086421,'1481','201',542657.00,544512.00,1855.00,265265.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54006',1086422,'1482','201',100125.00,100125.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54006',1086423,'1483','201',387923.00,389916.00,1993.00,284999.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54006',1086424,'1484','201',390485.00,391398.00,913.00,130559.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54006',1086425,'1485','201',522598.00,523608.00,1010.00,144430.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54006',1086426,'1486','201',384564.00,384564.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54006',1086427,'1487','201',547477.00,548731.00,1254.00,179322.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54006',1086428,'1488','202',178561.00,179581.00,1020.00,229500.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54006',1086429,'1489','202',316425.00,316506.00,81.00,18225.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54006',1086430,'1490','203',213008.57,213045.12,9.00,2070.00,0.00,0.00,27.55,0.00,0.00),('1','64','536','54095',1088074,'1480','201',418827.00,420445.00,1618.00,231374.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54095',1088075,'1481','201',544512.00,547415.00,2903.00,415129.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54095',1088076,'1482','201',100125.00,101568.00,1443.00,206349.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54095',1088077,'1483','201',389916.00,392519.00,2603.00,372229.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54095',1088078,'1484','201',391398.00,391398.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54095',1088079,'1485','201',523608.00,525992.00,2384.00,340912.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54095',1088080,'1486','201',384564.00,386782.00,2218.00,317174.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54095',1088081,'1487','201',548731.00,548731.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54095',1088082,'1488','202',179581.00,180264.00,683.00,153675.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54095',1088083,'1489','202',316506.00,316506.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54095',1088084,'1490','203',213045.12,213219.35,174.23,40072.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','54108',1088320,'1480','201',420445.00,421564.00,1119.00,160017.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54108',1088321,'1481','201',547415.00,548484.00,1069.00,152867.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54108',1088322,'1482','201',101568.00,101568.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54108',1088323,'1483','201',392519.00,394362.00,1843.00,263549.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54108',1088324,'1484','201',391398.00,392732.00,1334.00,190762.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54108',1088325,'1485','201',525992.00,527785.00,1793.00,256399.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54108',1088326,'1486','201',386782.00,388399.00,1617.00,231231.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54108',1088327,'1487','201',548731.00,549397.00,666.00,95238.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54108',1088328,'1488','202',180264.00,181156.00,892.00,200700.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54108',1088329,'1489','202',316506.00,316506.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54108',1088330,'1490','203',213219.35,213312.64,93.29,21456.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','54211',1090400,'1480','201',421564.00,423942.00,2378.00,340054.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54211',1090401,'1481','201',548484.00,550943.00,2459.00,351637.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54211',1090402,'1482','201',101568.00,101568.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54211',1090403,'1483','201',394362.00,397375.00,3013.00,430859.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54211',1090404,'1484','201',392732.00,392732.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54211',1090405,'1485','201',527785.00,529958.00,2173.00,310739.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54211',1090406,'1486','201',388399.00,388399.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54211',1090407,'1487','201',549397.00,551998.00,2601.00,371943.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54211',1090408,'1488','202',181156.00,181694.00,538.00,121050.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54211',1090409,'1489','202',316506.00,316506.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54211',1090410,'1490','203',213312.64,213358.75,46.11,10605.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','54215',1090473,'1480','201',423942.00,424933.00,991.00,141713.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54215',1090474,'1481','201',550943.00,553000.00,2057.00,294151.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54215',1090475,'1482','201',101568.00,102768.00,1200.00,171600.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54215',1090476,'1483','201',397375.00,398230.00,855.00,122265.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54215',1090477,'1484','201',392732.00,394212.00,1480.00,211640.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54215',1090478,'1485','201',529958.00,531750.00,1792.00,256256.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54215',1090479,'1486','201',388399.00,388664.00,265.00,37895.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54215',1090480,'1487','201',551998.00,553044.00,1046.00,149578.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54215',1090481,'1488','202',181694.00,182529.00,835.00,187875.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54215',1090482,'1489','202',316506.00,316607.00,101.00,22725.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54215',1090483,'1490','203',213358.75,213449.62,90.87,20900.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','54404',1094240,'1480','201',424933.00,424933.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54404',1094241,'1481','201',553000.00,556533.00,3533.00,505219.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54404',1094242,'1482','201',102768.00,106308.00,3540.00,506220.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54404',1094243,'1483','201',398230.00,398230.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54404',1094244,'1484','201',394212.00,396040.00,1828.00,261404.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54404',1094245,'1485','201',531750.00,534576.00,2826.00,404118.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54404',1094246,'1486','201',388664.00,391399.00,2735.00,391105.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54404',1094247,'1487','201',553044.00,553044.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54404',1094248,'1488','202',182529.00,183382.00,853.00,191925.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54404',1094249,'1489','202',316607.00,316607.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54404',1094250,'1490','203',213449.62,213558.57,108.95,25058.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','54406',1094262,'1480','201',424933.00,426788.00,1855.00,265265.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54406',1094263,'1481','201',556533.00,558695.00,2162.00,309166.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54406',1094264,'1482','201',106308.00,107475.00,1167.00,166881.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54406',1094265,'1483','201',398230.00,400276.00,2046.00,292578.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54406',1094266,'1484','201',396040.00,396040.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54406',1094267,'1485','201',534576.00,536167.00,1591.00,227513.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54406',1094268,'1486','201',391399.00,392448.00,1049.00,150007.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54406',1094269,'1487','201',553044.00,553044.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54406',1094270,'1488','202',183382.00,184090.00,708.00,155760.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54406',1094271,'1489','202',316607.00,316607.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54406',1094272,'1490','203',213558.57,213666.64,108.07,24856.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','54407',1094273,'1480','201',426788.00,429607.00,2819.00,403117.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54407',1094274,'1481','201',558695.00,560797.00,2102.00,300586.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54407',1094275,'1482','201',107475.00,107475.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54407',1094276,'1483','201',400276.00,403419.00,3143.00,449449.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54407',1094277,'1484','201',396040.00,396040.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54407',1094278,'1485','201',536167.00,539183.00,3016.00,431288.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54407',1094279,'1486','201',392448.00,392469.00,21.00,3003.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54407',1094280,'1487','201',553044.00,555573.00,2529.00,361647.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54407',1094281,'1488','202',184090.00,184740.00,650.00,143000.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54407',1094282,'1489','202',316607.00,316649.00,42.00,9240.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54407',1094283,'1490','203',213666.64,213783.59,116.95,26898.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','54531',1096812,'1480','201',429607.00,431928.00,2321.00,331903.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54531',1096813,'1481','201',560797.00,560797.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54531',1096814,'1482','201',107475.00,108546.00,1071.00,153153.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54531',1096815,'1483','201',403419.00,405278.00,1859.00,265837.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54531',1096816,'1484','201',396040.00,396457.00,417.00,59631.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54531',1096817,'1485','201',539183.00,540438.00,1255.00,179465.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54531',1096818,'1486','201',392469.00,392886.00,417.00,59631.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54531',1096819,'1487','201',555573.00,557499.00,1926.00,275418.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54531',1096820,'1488','202',184740.00,185621.00,881.00,193820.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54531',1096821,'1489','202',316649.00,316649.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54531',1096822,'1490','203',213783.59,213891.12,107.53,24731.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','54533',1096835,'1480','201',431928.00,433813.00,1885.00,269555.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54533',1096836,'1481','201',560797.00,563095.00,2298.00,328614.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54533',1096837,'1482','201',108546.00,108546.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54533',1096838,'1483','201',405278.00,408002.00,2724.00,389532.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54533',1096839,'1484','201',396457.00,398854.00,2397.00,342771.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54533',1096840,'1485','201',540438.00,540452.00,14.00,2002.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54533',1096841,'1486','201',392886.00,392886.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54533',1096842,'1487','201',557499.00,559242.00,1743.00,249249.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54533',1096843,'1488','202',185621.00,186214.00,593.00,130460.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54533',1096844,'1489','202',316649.00,316649.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54533',1096845,'1490','203',213891.12,213969.71,78.59,18075.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','54678',1099486,'1480','201',433813.00,435353.00,1540.00,220220.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54678',1099487,'1481','201',563095.00,565022.00,1927.00,275561.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54678',1099488,'1482','201',108546.00,109818.00,1272.00,181896.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54678',1099489,'1483','201',408002.00,409462.00,1460.00,208780.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54678',1099490,'1484','201',398854.00,399658.00,804.00,114972.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54678',1099491,'1485','201',540452.00,541572.00,1120.00,160160.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54678',1099492,'1486','201',392886.00,395362.00,2476.00,354068.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54678',1099493,'1487','201',559242.00,559242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54678',1099494,'1488','202',186214.00,187664.00,1450.00,319000.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54678',1099495,'1489','202',316649.00,316649.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54678',1099496,'1490','203',213969.71,214044.89,75.18,17291.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','54872',1103483,'1480','201',435353.00,437327.00,1974.00,282282.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54872',1103484,'1481','201',565022.00,567755.00,2733.00,390819.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54872',1103485,'1482','201',109818.00,112706.00,2888.00,412984.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54872',1103486,'1483','201',409462.00,410440.00,978.00,139854.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54872',1103487,'1484','201',399658.00,399658.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54872',1103488,'1485','201',541572.00,544362.00,2790.00,398970.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54872',1103489,'1486','201',395362.00,398343.00,2981.00,426283.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54872',1103490,'1487','201',559242.00,559242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54872',1103491,'1488','202',187664.00,187664.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54872',1103492,'1489','202',316649.00,317059.00,410.00,90200.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54872',1103493,'1490','203',214044.89,214136.40,91.51,21047.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','54873',1103494,'1480','201',437327.00,438361.00,1034.00,147862.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54873',1103495,'1481','201',567755.00,568655.00,900.00,128700.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54873',1103496,'1482','201',112706.00,112706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54873',1103497,'1483','201',410440.00,411494.00,1054.00,150722.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54873',1103498,'1484','201',399658.00,402288.00,2630.00,376090.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54873',1103499,'1485','201',544362.00,546092.00,1730.00,247390.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54873',1103500,'1486','201',398343.00,399764.00,1421.00,203203.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54873',1103501,'1487','201',559242.00,561249.00,2007.00,287001.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54873',1103502,'1488','202',187664.00,188699.00,1035.00,227700.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54873',1103503,'1489','202',317059.00,317059.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54873',1103504,'1490','203',214136.40,214244.96,108.56,24968.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','54875',1103533,'1480','201',438361.00,438361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54875',1103534,'1481','201',568655.00,568655.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54875',1103535,'1482','201',112706.00,112706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54875',1103536,'1483','201',411494.00,411494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54875',1103537,'1484','201',402288.00,406218.00,3930.00,561990.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54875',1103538,'1485','201',546092.00,550158.00,4066.00,581438.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54875',1103539,'1486','201',399764.00,402191.00,2427.00,347061.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54875',1103540,'1487','201',561249.00,564380.00,3131.00,447733.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54875',1103541,'1488','202',188699.00,189660.00,961.00,211420.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54875',1103542,'1489','202',317059.00,317079.00,20.00,4400.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54875',1103543,'1490','203',214244.96,214434.67,189.71,43633.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','54877',1103556,'1480','201',438361.00,438361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54877',1103557,'1481','201',568655.00,568655.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54877',1103558,'1482','201',112706.00,112706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54877',1103559,'1483','201',411494.00,411494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54877',1103560,'1484','201',406218.00,408481.00,2263.00,323609.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54877',1103561,'1485','201',550158.00,552540.00,2382.00,340626.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54877',1103562,'1486','201',402191.00,404083.00,1892.00,270556.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54877',1103563,'1487','201',564380.00,567361.00,2981.00,426283.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54877',1103564,'1488','202',189660.00,190847.00,1187.00,261140.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54877',1103565,'1489','202',317079.00,317080.00,1.00,220.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54877',1103566,'1490','203',214434.67,214506.77,72.10,16583.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54879',1103580,'1480','201',438361.00,438361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54879',1103581,'1481','201',568655.00,568655.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54879',1103582,'1482','201',112706.00,112706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','54879',1103583,'1483','201',411494.00,411494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54879',1103584,'1484','201',408481.00,411696.00,3215.00,459745.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','54879',1103585,'1485','201',552540.00,555942.00,3402.00,486486.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54879',1103586,'1486','201',404083.00,407451.00,3368.00,481624.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','54879',1103587,'1487','201',567361.00,570115.00,2754.00,393822.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54879',1103588,'1488','202',190847.00,191852.00,1005.00,221100.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','54879',1103589,'1489','202',317080.00,317080.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','54879',1103590,'1490','203',214506.77,214758.39,251.62,57872.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','55009',1106083,'1480','201',438361.00,439459.00,1098.00,157014.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55009',1106084,'1481','201',568655.00,570537.00,1882.00,269126.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55009',1106085,'1482','201',112706.00,112706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55009',1106086,'1483','201',411494.00,414003.00,2509.00,358787.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55009',1106087,'1484','201',411696.00,412523.00,827.00,118261.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55009',1106088,'1485','201',555942.00,557319.00,1377.00,196911.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55009',1106089,'1486','201',407451.00,408694.00,1243.00,177749.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55009',1106090,'1487','201',570115.00,571994.00,1879.00,268697.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55009',1106091,'1488','202',191852.00,192578.00,726.00,159720.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55009',1106092,'1489','202',317080.00,317226.00,146.00,32120.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55009',1106093,'1490','203',214758.39,214778.96,20.57,4731.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','55012',1106158,'1480','201',439459.00,442706.00,3247.00,464321.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55012',1106159,'1481','201',570537.00,573424.00,2887.00,412841.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55012',1106160,'1482','201',112706.00,114935.00,2229.00,318747.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55012',1106161,'1483','201',414003.00,415555.00,1552.00,221936.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55012',1106162,'1484','201',412523.00,412523.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55012',1106163,'1485','201',557319.00,557742.00,423.00,60489.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55012',1106164,'1486','201',408694.00,410605.00,1911.00,273273.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55012',1106165,'1487','201',571994.00,575339.00,3345.00,478335.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55012',1106166,'1488','202',192578.00,193568.00,990.00,217800.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55012',1106167,'1489','202',317226.00,317226.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55012',1106168,'1490','203',214778.96,214948.22,169.26,38929.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','55016',1106236,'1480','201',442706.00,443913.00,1197.00,171171.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','55016',1106237,'1481','201',573424.00,575988.00,2554.00,365222.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','55016',1106238,'1482','201',114935.00,114935.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55016',1106239,'1483','201',415555.00,417405.00,1840.00,263120.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','55016',1106240,'1484','201',412523.00,413799.00,1266.00,181038.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','55016',1106241,'1485','201',557742.00,559161.00,1409.00,201487.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','55016',1106242,'1486','201',410605.00,412344.00,1729.00,247247.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','55016',1106243,'1487','201',575339.00,575339.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55016',1106244,'1488','202',193568.00,194791.00,1193.00,262460.00,0.00,0.00,30.00,0.00,0.00),('1','64','539','55016',1106245,'1489','202',317226.00,317226.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55016',1106246,'1490','203',214948.22,214991.29,32.77,7537.10,0.00,0.00,10.30,0.00,0.00),('1','64','536','55086',1107647,'1480','201',443913.00,446098.00,2185.00,312455.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55086',1107648,'1481','201',575988.00,578705.00,2717.00,388531.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55086',1107649,'1482','201',114935.00,115780.00,845.00,120835.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55086',1107650,'1483','201',417405.00,419329.00,1924.00,275132.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55086',1107651,'1484','201',413799.00,415463.00,1664.00,237952.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55086',1107652,'1485','201',559161.00,561571.00,2410.00,344630.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55086',1107653,'1486','201',412344.00,412344.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55086',1107654,'1487','201',575339.00,577959.00,2620.00,374660.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55086',1107655,'1488','202',194791.00,195796.00,1005.00,221100.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55086',1107656,'1489','202',317226.00,317226.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55086',1107657,'1490','203',214991.29,215097.81,106.52,24499.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','55214',1110224,'1480','201',446098.00,448080.00,1982.00,283426.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55214',1110225,'1481','201',578705.00,581149.00,2444.00,349492.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55214',1110226,'1482','201',115780.00,115780.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55214',1110227,'1483','201',419329.00,421405.00,2076.00,296868.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55214',1110228,'1484','201',415463.00,416402.00,939.00,134277.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55214',1110229,'1485','201',561571.00,563419.00,1848.00,264264.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55214',1110230,'1486','201',412344.00,412344.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55214',1110231,'1487','201',577959.00,579776.00,1817.00,259831.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55214',1110232,'1488','202',195796.00,197415.00,1619.00,356180.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55214',1110233,'1489','202',317226.00,317264.00,38.00,8360.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55214',1110234,'1490','203',215097.81,215191.58,93.77,21567.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','55216',1110251,'1480','201',448080.00,449913.00,1833.00,262119.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55216',1110252,'1481','201',581149.00,583442.00,2293.00,327899.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55216',1110253,'1482','201',115780.00,115787.00,7.00,1001.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55216',1110254,'1483','201',421405.00,423525.00,2120.00,303160.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55216',1110255,'1484','201',416402.00,419009.00,2607.00,372801.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55216',1110256,'1485','201',563419.00,565730.00,2311.00,330473.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55216',1110257,'1486','201',412344.00,412660.00,316.00,45188.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55216',1110258,'1487','201',579776.00,581744.00,1968.00,281424.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55216',1110259,'1488','202',197415.00,199229.00,1794.00,394680.00,0.00,0.00,20.00,0.00,0.00),('1','64','539','55216',1110260,'1489','202',317264.00,317351.00,77.00,16940.00,0.00,0.00,10.00,0.00,0.00),('1','64','540','55216',1110261,'1490','203',215191.58,215200.71,9.13,2099.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','55217',1110262,'1480','201',449913.00,451036.00,1123.00,160589.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55217',1110263,'1481','201',583442.00,585272.00,1830.00,261690.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55217',1110264,'1482','201',115787.00,116610.00,823.00,117689.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55217',1110265,'1483','201',423525.00,425206.00,1681.00,240383.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55217',1110266,'1484','201',419009.00,419813.00,804.00,114972.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55217',1110267,'1485','201',565730.00,567305.00,1575.00,225225.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55217',1110268,'1486','201',412660.00,412660.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55217',1110269,'1487','201',581744.00,583682.00,1938.00,277134.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55217',1110270,'1488','202',199229.00,199950.00,721.00,158620.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55217',1110271,'1489','202',317351.00,317351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55217',1110272,'1490','203',215200.71,215289.55,88.84,20433.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','55533',1116487,'1480','201',451036.00,452716.00,1680.00,240240.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55533',1116488,'1481','201',585272.00,587480.00,2208.00,315744.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55533',1116489,'1482','201',116610.00,118554.00,1944.00,277992.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55533',1116490,'1483','201',425206.00,426105.00,899.00,128557.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55533',1116491,'1484','201',419813.00,419813.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55533',1116492,'1485','201',567305.00,569710.00,2405.00,343915.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55533',1116493,'1486','201',412660.00,413942.00,1282.00,183326.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55533',1116494,'1487','201',583682.00,583682.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55533',1116495,'1488','202',199950.00,200853.00,903.00,198660.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55533',1116496,'1489','202',317351.00,317351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55533',1116497,'1490','203',215289.55,215347.54,57.99,13337.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','55534',1116498,'1480','201',452716.00,454412.00,1696.00,242528.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55534',1116499,'1481','201',587480.00,589577.00,2097.00,299871.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55534',1116500,'1482','201',118554.00,119694.00,1140.00,163020.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55534',1116501,'1483','201',426105.00,427879.00,1774.00,253682.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55534',1116502,'1484','201',419813.00,421601.00,1788.00,255684.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55534',1116503,'1485','201',569710.00,570913.00,1203.00,172029.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55534',1116504,'1486','201',413942.00,413942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55534',1116505,'1487','201',583682.00,583682.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55534',1116506,'1488','202',200853.00,202484.00,1631.00,358820.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55534',1116507,'1489','202',317351.00,317351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55534',1116508,'1490','203',215347.54,215460.87,113.33,26065.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','55540',1116590,'1480','201',454412.00,457465.00,3053.00,436579.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55540',1116591,'1481','201',589577.00,592409.00,2832.00,404976.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55540',1116592,'1482','201',119694.00,122345.00,2651.00,379093.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55540',1116593,'1483','201',427879.00,430095.00,2216.00,316888.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55540',1116594,'1484','201',421601.00,422072.00,471.00,67353.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55540',1116595,'1485','201',570913.00,572980.00,2067.00,295581.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55540',1116596,'1486','201',413942.00,413942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55540',1116597,'1487','201',583682.00,584931.00,1249.00,178607.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55540',1116598,'1488','202',202484.00,203263.00,779.00,171380.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55540',1116599,'1489','202',317351.00,317351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55540',1116600,'1490','203',215460.87,215532.86,71.99,16557.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','55541',1116601,'1480','201',457465.00,458076.00,611.00,87373.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55541',1116602,'1481','201',592409.00,593787.00,1378.00,197054.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55541',1116603,'1482','201',122345.00,123521.00,1176.00,168168.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55541',1116604,'1483','201',430095.00,431029.00,934.00,133562.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55541',1116605,'1484','201',422072.00,424048.00,1976.00,282568.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55541',1116606,'1485','201',572980.00,574706.00,1726.00,246818.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55541',1116607,'1486','201',413942.00,416212.00,2270.00,324610.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55541',1116608,'1487','201',584931.00,585113.00,182.00,26026.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55541',1116609,'1488','202',203263.00,204795.00,1532.00,337040.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55541',1116610,'1489','202',317351.00,317890.00,539.00,118580.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55541',1116611,'1490','203',215532.86,215586.42,53.56,12318.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','55543',1116627,'1480','201',458076.00,460353.00,2277.00,325611.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55543',1116628,'1481','201',593787.00,593787.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55543',1116629,'1482','201',123521.00,125171.00,1650.00,235950.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55543',1116630,'1483','201',431029.00,433463.00,2434.00,348062.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55543',1116631,'1484','201',424048.00,424048.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55543',1116632,'1485','201',574706.00,577745.00,3039.00,434577.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55543',1116633,'1486','201',416212.00,418765.00,2553.00,365079.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55543',1116634,'1487','201',585113.00,585113.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55543',1116635,'1488','202',204795.00,205347.00,552.00,121440.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55543',1116636,'1489','202',317890.00,317890.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55543',1116637,'1490','203',215586.42,215703.13,116.71,26843.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','55679',1119270,'1480','201',460353.00,461764.00,1411.00,201773.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55679',1119271,'1481','201',593787.00,595989.00,2202.00,314886.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55679',1119272,'1482','201',125171.00,126557.00,1386.00,198198.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55679',1119273,'1483','201',433463.00,435839.00,2376.00,339768.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55679',1119274,'1484','201',424048.00,424048.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55679',1119275,'1485','201',577745.00,579781.00,2036.00,291148.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55679',1119276,'1486','201',418765.00,420901.00,2136.00,305448.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55679',1119277,'1487','201',585113.00,585113.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55679',1119278,'1488','202',205347.00,207023.00,1636.00,359920.00,0.00,0.00,40.00,0.00,0.00),('1','64','539','55679',1119279,'1489','202',317890.00,317891.00,1.00,220.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55679',1119280,'1490','203',215703.13,215756.05,52.92,12171.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','55681',1119292,'1480','201',461764.00,463855.00,2091.00,299013.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55681',1119293,'1481','201',595989.00,598542.00,2553.00,365079.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55681',1119294,'1482','201',126557.00,128344.00,1787.00,255541.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55681',1119295,'1483','201',435839.00,438086.00,2247.00,321321.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55681',1119296,'1484','201',424048.00,424048.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55681',1119297,'1485','201',579781.00,582688.00,2907.00,415701.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55681',1119298,'1486','201',420901.00,420901.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55681',1119299,'1487','201',585113.00,586767.00,1654.00,236522.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55681',1119300,'1488','202',207023.00,207946.00,923.00,203060.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55681',1119301,'1489','202',317891.00,317891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55681',1119302,'1490','203',215756.05,215938.85,182.80,42044.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55685',1119354,'1480','201',463855.00,465473.00,1618.00,231374.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55685',1119355,'1481','201',598542.00,600790.00,2248.00,321464.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55685',1119356,'1482','201',128344.00,129584.00,1240.00,177320.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55685',1119357,'1483','201',438086.00,438846.00,760.00,108680.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55685',1119358,'1484','201',424048.00,424660.00,612.00,87516.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55685',1119359,'1485','201',582688.00,583824.00,1136.00,162448.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55685',1119360,'1486','201',420901.00,420901.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55685',1119361,'1487','201',586767.00,587405.00,638.00,91234.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55685',1119362,'1488','202',207946.00,208702.00,756.00,166320.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55685',1119363,'1489','202',317891.00,317891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55685',1119364,'1490','203',215938.85,215998.06,59.21,13618.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','55877',1123213,'1480','201',465473.00,467832.00,2359.00,337337.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55877',1123214,'1481','201',600790.00,603692.00,2902.00,414986.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55877',1123215,'1482','201',129584.00,130573.00,989.00,141427.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55877',1123216,'1483','201',438846.00,441561.00,2715.00,388245.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55877',1123217,'1484','201',424660.00,424660.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55877',1123218,'1485','201',583824.00,586055.00,2231.00,319033.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55877',1123219,'1486','201',420901.00,423920.00,3019.00,431717.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55877',1123220,'1487','201',587405.00,587405.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55877',1123221,'1488','202',208702.00,209516.00,814.00,179080.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55877',1123222,'1489','202',317891.00,317891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55877',1123223,'1490','203',215998.06,216167.69,169.63,39014.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','55880',1123249,'1480','201',467832.00,469233.00,1401.00,200343.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55880',1123250,'1481','201',603692.00,606168.00,2466.00,352638.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','55880',1123251,'1482','201',130573.00,131170.00,597.00,85371.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55880',1123252,'1483','201',441561.00,443149.00,1578.00,225654.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','55880',1123253,'1484','201',424660.00,425774.00,1114.00,159302.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55880',1123254,'1485','201',586055.00,587620.00,1555.00,222365.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','55880',1123255,'1486','201',423920.00,423920.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55880',1123256,'1487','201',587405.00,588585.00,1170.00,167310.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','55880',1123257,'1488','202',209516.00,210436.00,920.00,202400.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55880',1123258,'1489','202',317891.00,317891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55880',1123259,'1490','203',216167.69,216317.94,150.25,34557.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','55887',1123348,'1480','201',469233.00,470747.00,1514.00,216502.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55887',1123349,'1481','201',606168.00,607793.00,1625.00,232375.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55887',1123350,'1482','201',131170.00,132636.00,1466.00,209638.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','55887',1123351,'1483','201',443149.00,443149.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55887',1123352,'1484','201',425774.00,429236.00,3462.00,495066.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','55887',1123353,'1485','201',587620.00,590285.00,2665.00,381095.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55887',1123354,'1486','201',423920.00,427040.00,3120.00,446160.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','55887',1123355,'1487','201',588585.00,589854.00,1269.00,181467.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','55887',1123356,'1488','202',210436.00,211346.00,890.00,195800.00,0.00,0.00,20.00,0.00,0.00),('1','64','539','55887',1123357,'1489','202',317891.00,317891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','55887',1123358,'1490','203',216317.94,216469.60,151.66,34881.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','56244',1130375,'1480','201',470747.00,471087.00,340.00,48620.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56244',1130376,'1481','201',607793.00,608356.00,563.00,80509.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56244',1130377,'1482','201',132636.00,132636.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56244',1130378,'1483','201',443149.00,443939.00,790.00,112970.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56244',1130379,'1484','201',429236.00,433268.00,4032.00,576576.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56244',1130380,'1485','201',590285.00,593856.00,3571.00,510653.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56244',1130381,'1486','201',427040.00,427054.00,14.00,2002.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56244',1130382,'1487','201',589854.00,589962.00,108.00,15444.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56244',1130383,'1488','202',211346.00,212444.00,1098.00,241560.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56244',1130384,'1489','202',317891.00,317891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56244',1130385,'1490','203',216469.60,216683.71,214.11,49245.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','56248',1130439,'1480','201',471087.00,473548.00,2461.00,351923.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56248',1130440,'1481','201',608356.00,611629.00,3273.00,468039.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56248',1130441,'1482','201',132636.00,135593.00,2957.00,422851.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56248',1130442,'1483','201',443939.00,443939.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56248',1130443,'1484','201',433268.00,434909.00,1641.00,234663.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56248',1130444,'1485','201',593856.00,595359.00,1503.00,214929.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56248',1130445,'1486','201',427054.00,429119.00,2065.00,295295.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56248',1130446,'1487','201',589962.00,589962.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56248',1130447,'1488','202',212444.00,212823.00,379.00,83380.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56248',1130448,'1489','202',317891.00,317891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56248',1130449,'1490','203',216683.71,216924.81,241.10,55453.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56251',1130501,'1480','201',473548.00,475373.00,1825.00,260975.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56251',1130502,'1481','201',611629.00,612850.00,1221.00,174603.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56251',1130503,'1482','201',135593.00,135593.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56251',1130504,'1483','201',443939.00,445767.00,1828.00,261404.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56251',1130505,'1484','201',434909.00,436155.00,1246.00,178178.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56251',1130506,'1485','201',595359.00,597089.00,1730.00,247390.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56251',1130507,'1486','201',429119.00,429991.00,872.00,124696.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56251',1130508,'1487','201',589962.00,590640.00,678.00,96954.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56251',1130509,'1488','202',212823.00,213334.00,511.00,112420.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56251',1130510,'1489','202',317891.00,318127.00,236.00,51920.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56251',1130511,'1490','203',216924.81,217058.54,133.73,30757.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','56253',1130525,'1480','201',475373.00,475373.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56253',1130526,'1481','201',612850.00,615753.00,2903.00,415129.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56253',1130527,'1482','201',135593.00,137955.00,2362.00,337766.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56253',1130528,'1483','201',445767.00,445767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56253',1130529,'1484','201',436155.00,437562.00,1407.00,201201.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56253',1130530,'1485','201',597089.00,598694.00,1605.00,229515.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56253',1130531,'1486','201',429991.00,429991.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56253',1130532,'1487','201',590640.00,592354.00,1714.00,245102.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56253',1130533,'1488','202',213334.00,213612.00,278.00,61160.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56253',1130534,'1489','202',318127.00,318253.00,126.00,27720.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56253',1130535,'1490','203',217058.54,217139.20,80.66,18551.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','56255',1130566,'1480','201',475373.00,475373.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56255',1130567,'1481','201',615753.00,618670.00,2917.00,417131.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56255',1130568,'1482','201',137955.00,137955.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56255',1130569,'1483','201',445767.00,448518.00,2751.00,393393.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56255',1130570,'1484','201',437562.00,438872.00,1310.00,187330.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56255',1130571,'1485','201',598694.00,600695.00,2001.00,286143.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56255',1130572,'1486','201',429991.00,429991.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56255',1130573,'1487','201',592354.00,593982.00,1628.00,232804.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56255',1130574,'1488','202',213612.00,214863.00,1251.00,275220.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56255',1130575,'1489','202',318253.00,318987.00,734.00,161480.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56255',1130576,'1490','203',217139.20,217220.89,81.69,18788.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','56256',1130577,'1480','201',475373.00,477052.00,1679.00,240097.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56256',1130578,'1481','201',618670.00,620954.00,2284.00,326612.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56256',1130579,'1482','201',137955.00,141006.00,3051.00,436293.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56256',1130580,'1483','201',448518.00,448844.00,326.00,46618.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56256',1130581,'1484','201',438872.00,441089.00,2217.00,317031.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56256',1130582,'1485','201',600695.00,603021.00,2326.00,332618.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56256',1130583,'1486','201',429991.00,431606.00,1615.00,230945.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56256',1130584,'1487','201',593982.00,595849.00,1867.00,266981.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56256',1130585,'1488','202',214863.00,216442.00,1579.00,347380.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56256',1130586,'1489','202',318987.00,319027.00,40.00,8800.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56256',1130587,'1490','203',217220.89,217364.13,143.24,32945.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','56259',1130623,'1480','201',477052.00,477052.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56259',1130624,'1481','201',620954.00,620954.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56259',1130625,'1482','201',141006.00,141006.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56259',1130626,'1483','201',448844.00,448844.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56259',1130627,'1484','201',441089.00,443702.00,2613.00,373659.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56259',1130628,'1485','201',603021.00,606222.00,3201.00,457743.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56259',1130629,'1486','201',431606.00,433600.00,1994.00,285142.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56259',1130630,'1487','201',595849.00,598622.00,2773.00,396539.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56259',1130631,'1488','202',216442.00,217323.00,881.00,193820.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56259',1130632,'1489','202',319027.00,319038.00,11.00,2420.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56259',1130633,'1490','203',217364.13,217441.33,77.20,17756.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56261',1130652,'1480','201',477052.00,478716.00,1664.00,237952.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56261',1130653,'1481','201',620954.00,623491.00,2537.00,362791.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56261',1130654,'1482','201',141006.00,143137.00,2131.00,304733.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56261',1130655,'1483','201',448844.00,450908.00,2064.00,295152.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56261',1130656,'1484','201',443702.00,445898.00,2196.00,314028.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56261',1130657,'1485','201',606222.00,608427.00,2205.00,315315.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56261',1130658,'1486','201',433600.00,433600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56261',1130659,'1487','201',598622.00,601599.00,2977.00,425711.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56261',1130660,'1488','202',217323.00,218480.00,1157.00,254540.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56261',1130661,'1489','202',319038.00,319038.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56261',1130662,'1490','203',217441.33,217763.92,322.59,74195.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','56342',1132276,'1480','201',478716.00,478716.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56342',1132277,'1481','201',623491.00,623491.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56342',1132278,'1482','201',143137.00,143137.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56342',1132279,'1483','201',450908.00,450908.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56342',1132280,'1484','201',445898.00,448413.00,2515.00,359645.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56342',1132281,'1485','201',608427.00,611466.00,3039.00,434577.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56342',1132282,'1486','201',433600.00,435698.00,2098.00,300014.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56342',1132283,'1487','201',601599.00,604318.00,2719.00,388817.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56342',1132284,'1488','202',218480.00,219346.00,866.00,190520.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56342',1132285,'1489','202',319038.00,319074.00,36.00,7920.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56342',1132286,'1490','203',217763.92,217850.71,86.79,19961.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','56343',1132287,'1480','201',478716.00,479548.00,822.00,117546.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','56343',1132288,'1481','201',623491.00,624413.00,922.00,131846.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56343',1132289,'1482','201',143137.00,143526.00,379.00,54197.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','56343',1132290,'1483','201',450908.00,451934.00,1026.00,146718.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56343',1132291,'1484','201',448413.00,451229.00,2806.00,401258.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','56343',1132292,'1485','201',611466.00,614049.00,2573.00,367939.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','56343',1132293,'1486','201',435698.00,437749.00,2041.00,291863.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','56343',1132294,'1487','201',604318.00,606386.00,2058.00,294294.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','56343',1132295,'1488','202',219346.00,220131.00,745.00,163900.00,0.00,0.00,40.00,0.00,0.00),('1','64','539','56343',1132296,'1489','202',319074.00,319074.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56343',1132297,'1490','203',217850.71,218071.37,220.66,50751.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','56627',1137720,'1480','201',479548.00,479548.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56627',1137721,'1481','201',624413.00,626904.00,2491.00,356213.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56627',1137722,'1482','201',143526.00,143526.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56627',1137723,'1483','201',451934.00,453998.00,2064.00,295152.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56627',1137724,'1484','201',451229.00,452354.00,1125.00,160875.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56627',1137725,'1485','201',614049.00,615888.00,1839.00,262977.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56627',1137726,'1486','201',437749.00,438674.00,925.00,132275.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56627',1137727,'1487','201',606386.00,607753.00,1367.00,195481.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56627',1137728,'1488','202',220131.00,220168.00,37.00,8140.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56627',1137729,'1489','202',319074.00,319852.00,778.00,171160.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56627',1137730,'1490','203',218071.37,218229.68,158.31,36411.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','56630',1137769,'1480','201',479548.00,480974.00,1426.00,203918.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56630',1137770,'1481','201',626904.00,628908.00,2004.00,286572.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56630',1137771,'1482','201',143526.00,145513.00,1987.00,284141.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56630',1137772,'1483','201',453998.00,456787.00,2789.00,398827.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56630',1137773,'1484','201',452354.00,452354.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56630',1137774,'1485','201',615888.00,618547.00,2659.00,380237.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56630',1137775,'1486','201',438674.00,438674.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56630',1137776,'1487','201',607753.00,609833.00,2080.00,297440.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56630',1137777,'1488','202',220168.00,220483.00,315.00,69300.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56630',1137778,'1489','202',319852.00,320412.00,560.00,123200.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56630',1137779,'1490','203',218229.68,218393.74,164.06,37733.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','56632',1137805,'1480','201',480974.00,482202.00,1228.00,175604.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56632',1137806,'1481','201',628908.00,630448.00,1540.00,220220.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56632',1137807,'1482','201',145513.00,145513.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56632',1137808,'1483','201',456787.00,459387.00,2600.00,371800.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56632',1137809,'1484','201',452354.00,452958.00,604.00,86372.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56632',1137810,'1485','201',618547.00,619283.00,736.00,105248.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56632',1137811,'1486','201',438674.00,439831.00,1157.00,165451.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56632',1137812,'1487','201',609833.00,612169.00,2336.00,334048.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56632',1137813,'1488','202',220483.00,221358.00,875.00,192500.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56632',1137814,'1489','202',320412.00,320572.00,160.00,35200.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56632',1137815,'1490','203',218393.74,218469.29,75.55,17376.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','56635',1137844,'1480','201',482202.00,484675.00,2473.00,353639.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56635',1137845,'1481','201',630448.00,632773.00,2325.00,332475.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56635',1137846,'1482','201',145513.00,146740.00,1227.00,175461.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56635',1137847,'1483','201',459387.00,460534.00,1147.00,164021.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56635',1137848,'1484','201',452958.00,454689.00,1731.00,247533.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56635',1137849,'1485','201',619283.00,621781.00,2498.00,357214.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56635',1137850,'1486','201',439831.00,440575.00,744.00,106392.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56635',1137851,'1487','201',612169.00,614499.00,2330.00,333190.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56635',1137852,'1488','202',221358.00,222242.00,884.00,194480.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56635',1137853,'1489','202',320572.00,320572.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56635',1137854,'1490','203',218469.29,218634.40,165.11,37975.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','56802',1141273,'1480','201',484675.00,484675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56802',1141274,'1481','201',632773.00,633853.00,1080.00,154440.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56802',1141275,'1482','201',146740.00,146740.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56802',1141276,'1483','201',460534.00,461334.00,800.00,114400.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56802',1141277,'1484','201',454689.00,457167.00,2478.00,354354.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56802',1141278,'1485','201',621781.00,624743.00,2962.00,423566.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56802',1141279,'1486','201',440575.00,442388.00,1813.00,259259.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56802',1141280,'1487','201',614499.00,616638.00,2139.00,305877.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56802',1141281,'1488','202',222242.00,223062.00,820.00,180400.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56802',1141282,'1489','202',320572.00,320572.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56802',1141283,'1490','203',218634.40,218834.03,199.63,45914.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','56805',1141317,'1480','201',484675.00,486198.00,1523.00,217789.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56805',1141318,'1481','201',633853.00,636333.00,2480.00,354640.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56805',1141319,'1482','201',146740.00,147812.00,1072.00,153296.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56805',1141320,'1483','201',461334.00,463355.00,2021.00,289003.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56805',1141321,'1484','201',457167.00,458716.00,1549.00,221507.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56805',1141322,'1485','201',624743.00,626937.00,2194.00,313742.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56805',1141323,'1486','201',442388.00,443463.00,1075.00,153725.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56805',1141324,'1487','201',616638.00,618240.00,1602.00,229086.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56805',1141325,'1488','202',223062.00,223807.00,745.00,163900.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56805',1141326,'1489','202',320572.00,320572.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56805',1141327,'1490','203',218834.03,218899.35,65.32,15023.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','56812',1141382,'1480','201',486198.00,486198.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56812',1141383,'1481','201',636333.00,637958.00,1625.00,232375.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56812',1141384,'1482','201',147812.00,147812.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56812',1141385,'1483','201',463355.00,463355.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56812',1141386,'1484','201',458716.00,462437.00,3721.00,532103.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56812',1141387,'1485','201',626937.00,631126.00,4189.00,599027.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56812',1141388,'1486','201',443463.00,443463.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56812',1141389,'1487','201',618240.00,618240.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56812',1141390,'1488','202',223807.00,224338.00,531.00,116820.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56812',1141391,'1489','202',320572.00,320581.00,9.00,1980.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56812',1141392,'1490','203',218899.35,218974.09,74.74,17190.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','56817',1141464,'1480','201',486198.00,487723.00,1525.00,218075.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56817',1141465,'1481','201',637958.00,639278.00,1320.00,188760.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56817',1141466,'1482','201',147812.00,150435.00,2623.00,375089.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56817',1141467,'1483','201',463355.00,463355.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56817',1141468,'1484','201',462437.00,464295.00,1858.00,265694.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56817',1141469,'1485','201',631126.00,634008.00,2882.00,412126.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56817',1141470,'1486','201',443463.00,443463.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56817',1141471,'1487','201',618240.00,618240.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56817',1141472,'1488','202',224338.00,225057.00,719.00,158180.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56817',1141473,'1489','202',320581.00,320581.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56817',1141474,'1490','203',218974.09,219042.84,68.75,15812.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','56944',1143984,'1480','201',487723.00,487723.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56944',1143985,'1481','201',639278.00,640792.00,1514.00,216502.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56944',1143986,'1482','201',150435.00,150988.00,553.00,79079.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','56944',1143987,'1483','201',463355.00,464643.00,1288.00,184184.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56944',1143988,'1484','201',464295.00,467384.00,3089.00,441727.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','56944',1143989,'1485','201',634008.00,637648.00,3640.00,520520.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56944',1143990,'1486','201',443463.00,443463.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','56944',1143991,'1487','201',618240.00,618240.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56944',1143992,'1488','202',225057.00,226487.00,1430.00,314600.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','56944',1143993,'1489','202',320581.00,320625.00,44.00,9680.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','56944',1143994,'1490','203',219042.84,219142.86,100.02,23004.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','57185',1148654,'1480','201',487723.00,487723.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57185',1148655,'1481','201',640792.00,640792.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57185',1148656,'1482','201',150988.00,150988.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57185',1148657,'1483','201',464643.00,464643.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57185',1148658,'1484','201',467384.00,472358.00,4974.00,711282.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57185',1148659,'1485','201',637648.00,642788.00,5140.00,735020.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57185',1148660,'1486','201',443463.00,443463.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57185',1148661,'1487','201',618240.00,618240.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57185',1148662,'1488','202',226487.00,227431.00,944.00,207680.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57185',1148663,'1489','202',320625.00,320817.00,192.00,42240.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57185',1148664,'1490','203',219142.86,219257.52,114.66,26371.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','57188',1148698,'1480','201',487723.00,489692.00,1969.00,281567.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57188',1148699,'1481','201',640792.00,643254.00,2462.00,352066.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57188',1148700,'1482','201',150988.00,152040.00,1052.00,150436.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57188',1148701,'1483','201',464643.00,466702.00,2059.00,294437.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57188',1148702,'1484','201',472358.00,473401.00,1043.00,149149.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57188',1148703,'1485','201',642788.00,644777.00,1989.00,284427.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57188',1148704,'1486','201',443463.00,444513.00,1050.00,150150.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57188',1148705,'1487','201',618240.00,618240.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57188',1148706,'1488','202',227431.00,228272.00,841.00,185020.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57188',1148707,'1489','202',320817.00,320817.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57188',1148708,'1490','203',219257.52,219332.61,75.09,17270.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','57190',1148739,'1480','201',489692.00,489692.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57190',1148740,'1481','201',643254.00,647291.00,4037.00,577291.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57190',1148741,'1482','201',152040.00,154466.00,2426.00,346918.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57190',1148742,'1483','201',466702.00,469465.00,2763.00,395109.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57190',1148743,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57190',1148744,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57190',1148745,'1486','201',444513.00,446614.00,2101.00,300443.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57190',1148746,'1487','201',618240.00,620650.00,2410.00,344630.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57190',1148747,'1488','202',228272.00,229876.00,1604.00,352880.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57190',1148748,'1489','202',320817.00,321338.00,521.00,114620.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57190',1148749,'1490','203',219332.61,219506.25,173.64,39937.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','57192',1148764,'1480','201',489692.00,491165.00,1473.00,210639.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57192',1148765,'1481','201',647291.00,649400.00,2109.00,301587.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57192',1148766,'1482','201',154466.00,155824.00,1358.00,194194.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57192',1148767,'1483','201',469465.00,471263.00,1798.00,257114.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57192',1148768,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57192',1148769,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57192',1148770,'1486','201',446614.00,447746.00,1132.00,161876.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57192',1148771,'1487','201',620650.00,622458.00,1808.00,258544.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57192',1148772,'1488','202',229876.00,231026.00,1150.00,253000.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57192',1148773,'1489','202',321338.00,321442.00,104.00,22880.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57192',1148774,'1490','203',219506.25,219546.86,40.61,9340.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','57312',1151143,'1480','201',491165.00,493725.00,2560.00,366080.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57312',1151144,'1481','201',649400.00,652235.00,2835.00,405405.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57312',1151145,'1482','201',155824.00,155824.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57312',1151146,'1483','201',471263.00,474243.00,2980.00,426140.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57312',1151147,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57312',1151148,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57312',1151149,'1486','201',447746.00,449594.00,1848.00,264264.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57312',1151150,'1487','201',622458.00,625045.00,2587.00,369941.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57312',1151151,'1488','202',231026.00,231960.00,934.00,205480.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57312',1151152,'1489','202',321442.00,321505.00,63.00,13860.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57312',1151153,'1490','203',219546.86,219674.10,127.24,29265.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','57314',1151176,'1480','201',493725.00,493725.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57314',1151177,'1481','201',652235.00,655345.00,3110.00,444730.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57314',1151178,'1482','201',155824.00,155824.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57314',1151179,'1483','201',474243.00,477062.00,2819.00,403117.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57314',1151180,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57314',1151181,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57314',1151182,'1486','201',449594.00,451660.00,2066.00,295438.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57314',1151183,'1487','201',625045.00,627018.00,1973.00,282139.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57314',1151184,'1488','202',231960.00,232085.00,125.00,27500.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57314',1151185,'1489','202',321505.00,322116.00,611.00,134420.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57314',1151186,'1490','203',219674.10,219725.61,51.51,11847.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','57318',1151250,'1480','201',493725.00,497621.00,3886.00,555698.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','57318',1151251,'1481','201',655345.00,655352.00,7.00,1001.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57318',1151252,'1482','201',155824.00,158765.00,2921.00,417703.00,0.00,0.00,20.00,0.00,0.00),('1','64','536','57318',1151253,'1483','201',477062.00,477820.00,748.00,106964.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','57318',1151254,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57318',1151255,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57318',1151256,'1486','201',451660.00,454327.00,2657.00,379951.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','57318',1151257,'1487','201',627018.00,630116.00,3088.00,441584.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','57318',1151258,'1488','202',232085.00,232085.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57318',1151259,'1489','202',322116.00,323071.00,935.00,205700.00,0.00,0.00,20.00,0.00,0.00),('1','64','540','57318',1151260,'1490','203',219725.61,219820.99,85.38,19637.40,0.00,0.00,10.00,0.00,0.00),('1','64','536','57516',1155113,'1480','201',497621.00,497621.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57516',1155114,'1481','201',655352.00,655352.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57516',1155115,'1482','201',158765.00,158765.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57516',1155116,'1483','201',477820.00,477820.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57516',1155117,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57516',1155118,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57516',1155119,'1486','201',454327.00,458845.00,4518.00,646074.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57516',1155120,'1487','201',630116.00,634655.00,4539.00,649077.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57516',1155121,'1488','202',232085.00,233029.00,944.00,207680.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57516',1155122,'1489','202',323071.00,323501.00,430.00,94600.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57516',1155123,'1490','203',219820.99,219888.31,67.32,15483.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','57519',1155190,'1480','201',497621.00,497621.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57519',1155191,'1481','201',655352.00,655352.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57519',1155192,'1482','201',158765.00,158765.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57519',1155193,'1483','201',477820.00,477820.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57519',1155194,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57519',1155195,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57519',1155196,'1486','201',458845.00,463293.00,4448.00,636064.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57519',1155197,'1487','201',634655.00,639699.00,5044.00,721292.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57519',1155198,'1488','202',233029.00,234096.00,1067.00,234740.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57519',1155199,'1489','202',323501.00,323588.00,87.00,19140.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57519',1155200,'1490','203',219888.31,219931.49,43.18,9931.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','57520',1155201,'1480','201',497621.00,497621.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57520',1155202,'1481','201',655352.00,655352.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57520',1155203,'1482','201',158765.00,158765.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57520',1155204,'1483','201',477820.00,477820.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57520',1155205,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57520',1155206,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57520',1155207,'1486','201',463293.00,465277.00,1984.00,283712.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57520',1155208,'1487','201',639699.00,641723.00,2024.00,289432.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57520',1155209,'1488','202',234096.00,235029.00,933.00,205260.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57520',1155210,'1489','202',323588.00,323588.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57520',1155211,'1490','203',219931.49,220041.35,109.86,25267.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','57527',1155344,'1480','201',497621.00,497621.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57527',1155345,'1481','201',655352.00,655352.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57527',1155346,'1482','201',158765.00,158765.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57527',1155347,'1483','201',477820.00,477820.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57527',1155348,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57527',1155349,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57527',1155350,'1486','201',465277.00,465277.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57527',1155351,'1487','201',641723.00,641723.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57527',1155352,'1488','202',235029.00,235678.00,649.00,142780.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57527',1155353,'1489','202',323588.00,323588.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57527',1155354,'1490','203',220041.35,220130.20,88.85,20435.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','57528',1155355,'1480','201',497621.00,497621.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57528',1155356,'1481','201',655352.00,655352.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57528',1155357,'1482','201',158765.00,158765.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57528',1155358,'1483','201',477820.00,477820.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57528',1155359,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57528',1155360,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57528',1155361,'1486','201',465277.00,465277.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57528',1155362,'1487','201',641723.00,641723.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57528',1155363,'1488','202',235678.00,236191.00,513.00,112860.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57528',1155364,'1489','202',323588.00,323588.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57528',1155365,'1490','203',220130.20,220173.15,42.95,9878.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','57937',1163235,'1480','201',497621.00,499828.00,2207.00,315601.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57937',1163236,'1481','201',655352.00,657211.00,1859.00,265837.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57937',1163237,'1482','201',158765.00,161058.00,2293.00,327899.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57937',1163238,'1483','201',477820.00,480467.00,2647.00,378521.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57937',1163239,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57937',1163240,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57937',1163241,'1486','201',465277.00,465277.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57937',1163242,'1487','201',641723.00,641723.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57937',1163243,'1488','202',236191.00,236802.00,611.00,134420.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57937',1163244,'1489','202',323588.00,323588.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57937',1163245,'1490','203',220173.15,220254.71,81.56,18758.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','57942',1163340,'1480','201',499828.00,500804.00,976.00,139568.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57942',1163341,'1481','201',657211.00,660568.00,3357.00,480051.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57942',1163342,'1482','201',161058.00,162126.00,1068.00,152724.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57942',1163343,'1483','201',480467.00,484160.00,3693.00,528099.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57942',1163344,'1484','201',473401.00,473401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57942',1163345,'1485','201',644777.00,644777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57942',1163346,'1486','201',465277.00,466627.00,1350.00,193050.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57942',1163347,'1487','201',641723.00,643103.00,1380.00,197340.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57942',1163348,'1488','202',236802.00,239481.00,2679.00,589380.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57942',1163349,'1489','202',323588.00,324290.00,702.00,154440.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57942',1163350,'1490','203',220254.71,220347.49,92.78,21339.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','57946',1163435,'1480','201',500804.00,503056.00,2252.00,322036.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57946',1163436,'1481','201',660568.00,661137.00,569.00,81367.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57946',1163437,'1482','201',162126.00,164555.00,2429.00,347347.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57946',1163438,'1483','201',484160.00,484160.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57946',1163439,'1484','201',473401.00,475088.00,1687.00,241241.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57946',1163440,'1485','201',644777.00,646581.00,1804.00,257972.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57946',1163441,'1486','201',466627.00,469359.00,2732.00,390676.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57946',1163442,'1487','201',643103.00,646049.00,2946.00,421278.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57946',1163443,'1488','202',239481.00,240422.00,941.00,207020.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57946',1163444,'1489','202',324290.00,324290.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57946',1163445,'1490','203',220347.49,220554.31,206.82,47568.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','57950',1163509,'1480','201',503056.00,503056.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57950',1163510,'1481','201',661137.00,663425.00,2288.00,327184.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57950',1163511,'1482','201',164555.00,164555.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57950',1163512,'1483','201',484160.00,486684.00,2524.00,360932.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57950',1163513,'1484','201',475088.00,475088.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57950',1163514,'1485','201',646581.00,648918.00,2337.00,334191.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57950',1163515,'1486','201',469359.00,470792.00,1433.00,204919.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57950',1163516,'1487','201',646049.00,647357.00,1308.00,187044.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57950',1163517,'1488','202',240422.00,241504.00,1082.00,238040.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57950',1163518,'1489','202',324290.00,324477.00,187.00,41140.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57950',1163519,'1490','203',220554.31,220616.23,61.92,14241.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','57959',1163713,'1480','201',503056.00,503513.00,457.00,65351.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57959',1163714,'1481','201',663425.00,665699.00,2274.00,325182.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57959',1163715,'1482','201',164555.00,167545.00,2990.00,427570.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57959',1163716,'1483','201',486684.00,486684.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57959',1163717,'1484','201',475088.00,475833.00,745.00,106535.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57959',1163718,'1485','201',648918.00,651060.00,2142.00,306306.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57959',1163719,'1486','201',470792.00,471989.00,1197.00,171171.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57959',1163720,'1487','201',647357.00,649622.00,2265.00,323895.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57959',1163721,'1488','202',241504.00,242089.00,585.00,128700.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57959',1163722,'1489','202',324477.00,324658.00,181.00,39820.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57959',1163723,'1490','203',220616.23,220741.20,124.97,28743.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','57966',1163856,'1480','201',503513.00,503513.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57966',1163857,'1481','201',665699.00,668554.00,2855.00,408265.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57966',1163858,'1482','201',167545.00,167545.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57966',1163859,'1483','201',486684.00,489506.00,2822.00,403546.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57966',1163860,'1484','201',475833.00,475833.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57966',1163861,'1485','201',651060.00,653744.00,2684.00,383812.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57966',1163862,'1486','201',471989.00,471989.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57966',1163863,'1487','201',649622.00,651325.00,1703.00,243529.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57966',1163864,'1488','202',242089.00,243219.00,1130.00,248600.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57966',1163865,'1489','202',324658.00,324680.00,22.00,4840.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57966',1163866,'1490','203',220741.20,220765.99,24.79,5701.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','57967',1163867,'1480','201',503513.00,504936.00,1423.00,203489.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57967',1163868,'1481','201',668554.00,670515.00,1961.00,280423.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57967',1163869,'1482','201',167545.00,170216.00,2671.00,381953.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57967',1163870,'1483','201',489506.00,489506.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57967',1163871,'1484','201',475833.00,478212.00,2379.00,340197.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57967',1163872,'1485','201',653744.00,655268.00,1524.00,217932.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57967',1163873,'1486','201',471989.00,472943.00,954.00,136422.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57967',1163874,'1487','201',651325.00,653199.00,1874.00,267982.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57967',1163875,'1488','202',243219.00,243729.00,510.00,112200.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57967',1163876,'1489','202',324680.00,325055.00,375.00,82500.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57967',1163877,'1490','203',220765.99,220926.11,160.12,36827.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','57969',1163904,'1480','201',504936.00,504936.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57969',1163905,'1481','201',670515.00,673393.00,2878.00,411554.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57969',1163906,'1482','201',170216.00,170216.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','57969',1163907,'1483','201',489506.00,492416.00,2910.00,416130.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57969',1163908,'1484','201',478212.00,479323.00,1111.00,158873.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','57969',1163909,'1485','201',655268.00,656116.00,848.00,121264.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57969',1163910,'1486','201',472943.00,473468.00,525.00,75075.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','57969',1163911,'1487','201',653199.00,655339.00,2140.00,306020.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57969',1163912,'1488','202',243729.00,244791.00,1062.00,233640.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','57969',1163913,'1489','202',325055.00,325184.00,129.00,28380.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','57969',1163914,'1490','203',220926.11,221049.61,123.50,28405.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58208',1168377,'1480','201',504936.00,507798.00,2862.00,409266.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58208',1168378,'1481','201',673393.00,673393.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58208',1168379,'1482','201',170216.00,173547.00,3331.00,476333.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58208',1168380,'1483','201',492416.00,492416.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58208',1168381,'1484','201',479323.00,480903.00,1580.00,225940.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58208',1168382,'1485','201',656116.00,657989.00,1873.00,267839.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58208',1168383,'1486','201',473468.00,475159.00,1691.00,241813.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58208',1168384,'1487','201',655339.00,656774.00,1435.00,205205.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58208',1168385,'1488','202',244791.00,245293.00,502.00,110440.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58208',1168386,'1489','202',325184.00,325529.00,345.00,75900.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','58208',1168387,'1490','203',221049.61,221191.52,141.91,32639.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','58209',1168388,'1480','201',507798.00,507798.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58209',1168389,'1481','201',673393.00,675704.00,2311.00,330473.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58209',1168390,'1482','201',173547.00,173547.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58209',1168391,'1483','201',492416.00,495518.00,3102.00,443586.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58209',1168392,'1484','201',480903.00,482284.00,1381.00,197483.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58209',1168393,'1485','201',657989.00,659745.00,1756.00,251108.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58209',1168394,'1486','201',475159.00,475879.00,720.00,102960.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58209',1168395,'1487','201',656774.00,658367.00,1593.00,227799.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58209',1168396,'1488','202',245293.00,245959.00,666.00,146520.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58209',1168397,'1489','202',325529.00,326088.00,559.00,122980.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','58209',1168398,'1490','203',221191.52,221276.30,84.78,19499.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','58211',1168421,'1480','201',507798.00,509409.00,1611.00,230373.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58211',1168422,'1481','201',675704.00,678140.00,2436.00,348348.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58211',1168423,'1482','201',173547.00,173547.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58211',1168424,'1483','201',495518.00,497978.00,2460.00,351780.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58211',1168425,'1484','201',482284.00,483979.00,1695.00,242385.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58211',1168426,'1485','201',659745.00,661547.00,1802.00,257686.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58211',1168427,'1486','201',475879.00,477820.00,1941.00,277563.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58211',1168428,'1487','201',658367.00,658392.00,25.00,3575.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58211',1168429,'1488','202',245959.00,246373.00,414.00,91080.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58211',1168430,'1489','202',326088.00,326088.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','58211',1168431,'1490','203',221276.30,221361.39,85.09,19570.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','58212',1168432,'1480','201',509409.00,509409.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58212',1168433,'1481','201',678140.00,678140.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58212',1168434,'1482','201',173547.00,173547.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58212',1168435,'1483','201',497978.00,497978.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58212',1168436,'1484','201',483979.00,486668.00,2689.00,384527.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58212',1168437,'1485','201',661547.00,664678.00,3131.00,447733.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58212',1168438,'1486','201',477820.00,479895.00,2075.00,296725.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58212',1168439,'1487','201',658392.00,661315.00,2923.00,417989.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58212',1168440,'1488','202',246373.00,247518.00,1145.00,251900.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58212',1168441,'1489','202',326088.00,326088.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','58212',1168442,'1490','203',221361.39,221478.12,116.73,26847.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','58346',1171027,'1480','201',509409.00,509430.00,11.00,1573.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','58346',1171028,'1481','201',678140.00,679711.00,1561.00,223223.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','58346',1171029,'1482','201',173547.00,173547.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58346',1171030,'1483','201',497978.00,499388.00,1400.00,200200.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','58346',1171031,'1484','201',486668.00,488789.00,2111.00,301873.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','58346',1171032,'1485','201',664678.00,667193.00,2505.00,358215.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','58346',1171033,'1486','201',479895.00,482158.00,2253.00,322179.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','58346',1171034,'1487','201',661315.00,663846.00,2521.00,360503.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','58346',1171035,'1488','202',247518.00,247518.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58346',1171036,'1489','202',326088.00,327048.00,940.00,206800.00,0.00,0.00,20.00,0.00,0.00),('1','64','540','58346',1171037,'1490','203',221478.12,221601.37,113.25,26047.50,0.00,0.00,10.00,0.00,0.00),('1','64','536','58348',1171054,'1480','201',509430.00,509430.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58348',1171055,'1481','201',679711.00,682835.00,3124.00,446732.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58348',1171056,'1482','201',173547.00,173547.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','58348',1171057,'1483','201',499388.00,501755.00,2367.00,338481.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58348',1171058,'1484','201',488789.00,488789.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','58348',1171059,'1485','201',667193.00,669398.00,2205.00,315315.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58348',1171060,'1486','201',482158.00,483523.00,1365.00,195195.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','58348',1171061,'1487','201',663846.00,663846.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58348',1171062,'1488','202',247518.00,247610.00,92.00,20240.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','58348',1171063,'1489','202',327048.00,328172.00,1124.00,247280.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','58348',1171064,'1490','203',221601.37,221750.33,148.96,34260.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','59230',1188211,'1480','201',509430.00,510264.00,834.00,119262.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59230',1188212,'1481','201',682835.00,684561.00,1726.00,246818.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59230',1188213,'1482','201',173547.00,173547.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59230',1188214,'1483','201',501755.00,503963.00,2208.00,315744.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59230',1188215,'1484','201',488789.00,489829.00,1040.00,148720.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59230',1188216,'1485','201',669398.00,671072.00,1674.00,239382.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59230',1188217,'1486','201',483523.00,483986.00,463.00,66209.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59230',1188218,'1487','201',663846.00,663905.00,59.00,8437.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59230',1188219,'1488','202',247610.00,248378.00,768.00,168960.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59230',1188220,'1489','202',328172.00,328172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59230',1188221,'1490','203',221750.33,221799.86,49.53,11391.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','59234',1188280,'1480','201',510264.00,510264.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59234',1188281,'1481','201',684561.00,687780.00,3219.00,460317.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59234',1188282,'1482','201',173547.00,173547.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59234',1188283,'1483','201',503963.00,506011.00,2048.00,292864.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59234',1188284,'1484','201',489829.00,491413.00,1584.00,226512.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59234',1188285,'1485','201',671072.00,673315.00,2243.00,320749.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59234',1188286,'1486','201',483986.00,483986.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59234',1188287,'1487','201',663905.00,665776.00,1871.00,267553.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59234',1188288,'1488','202',248378.00,250150.00,1772.00,389840.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59234',1188289,'1489','202',328172.00,328172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59234',1188290,'1490','203',221799.86,221985.40,185.54,42674.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','59236',1188341,'1480','201',510264.00,513885.00,3621.00,517803.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59236',1188342,'1481','201',687780.00,687780.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59236',1188343,'1482','201',173547.00,176244.00,2697.00,385671.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59236',1188344,'1483','201',506011.00,506011.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59236',1188345,'1484','201',491413.00,494236.00,2823.00,403689.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59236',1188346,'1485','201',673315.00,675950.00,2635.00,376805.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59236',1188347,'1486','201',483986.00,487212.00,3226.00,461318.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59236',1188348,'1487','201',665776.00,666826.00,1050.00,150150.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59236',1188349,'1488','202',250150.00,250150.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59236',1188350,'1489','202',328172.00,328172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59236',1188351,'1490','203',221985.40,222110.52,125.12,28777.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','59238',1188377,'1480','201',513885.00,513885.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59238',1188378,'1481','201',687780.00,689596.00,1816.00,259688.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59238',1188379,'1482','201',176244.00,176820.00,576.00,82368.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59238',1188380,'1483','201',506011.00,507575.00,1564.00,223652.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59238',1188381,'1484','201',494236.00,495276.00,1040.00,148720.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59238',1188382,'1485','201',675950.00,677930.00,1980.00,283140.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59238',1188383,'1486','201',487212.00,487749.00,537.00,76791.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59238',1188384,'1487','201',666826.00,667723.00,897.00,128271.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59238',1188385,'1488','202',250150.00,250150.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59238',1188386,'1489','202',328172.00,328172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59238',1188387,'1490','203',222110.52,222193.19,82.67,19014.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','59240',1188442,'1480','201',513885.00,514962.00,1077.00,154011.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59240',1188443,'1481','201',689596.00,691082.00,1486.00,212498.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59240',1188444,'1482','201',176820.00,177722.00,902.00,128986.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59240',1188445,'1483','201',507575.00,509272.00,1697.00,242671.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59240',1188446,'1484','201',495276.00,496771.00,1495.00,213785.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59240',1188447,'1485','201',677930.00,679834.00,1904.00,272272.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59240',1188448,'1486','201',487749.00,489131.00,1382.00,197626.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59240',1188449,'1487','201',667723.00,668864.00,1141.00,163163.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59240',1188450,'1488','202',250150.00,250150.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59240',1188451,'1489','202',328172.00,328172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59240',1188452,'1490','203',222193.19,222363.95,170.76,39274.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','59243',1188486,'1480','201',514962.00,515351.00,389.00,55627.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59243',1188487,'1481','201',691082.00,692228.00,1146.00,163878.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59243',1188488,'1482','201',177722.00,177722.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59243',1188489,'1483','201',509272.00,510785.00,1513.00,216359.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59243',1188490,'1484','201',496771.00,498010.00,1239.00,177177.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59243',1188491,'1485','201',679834.00,681932.00,2098.00,300014.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59243',1188492,'1486','201',489131.00,489778.00,647.00,92521.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59243',1188493,'1487','201',668864.00,670208.00,1344.00,192192.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59243',1188494,'1488','202',250150.00,250341.00,191.00,42020.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59243',1188495,'1489','202',328172.00,328172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59243',1188496,'1490','203',222363.95,222512.24,148.29,34106.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','59297',1189438,'1480','201',515351.00,515351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59297',1189439,'1481','201',692228.00,694678.00,2450.00,350350.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59297',1189440,'1482','201',177722.00,180022.00,2300.00,328900.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59297',1189441,'1483','201',510785.00,510785.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59297',1189442,'1484','201',498010.00,499356.00,1346.00,192478.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59297',1189443,'1485','201',681932.00,683903.00,1971.00,281853.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59297',1189444,'1486','201',489778.00,491133.00,1355.00,193765.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59297',1189445,'1487','201',670208.00,672022.00,1814.00,259402.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59297',1189446,'1488','202',250341.00,250341.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59297',1189447,'1489','202',328172.00,328172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59297',1189448,'1490','203',222512.24,222651.97,139.73,32137.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','59298',1189449,'1480','201',515351.00,515838.00,487.00,69641.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59298',1189450,'1481','201',694678.00,696563.00,1885.00,269555.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59298',1189451,'1482','201',180022.00,180022.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59298',1189452,'1483','201',510785.00,512866.00,2081.00,297583.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59298',1189453,'1484','201',499356.00,500572.00,1216.00,173888.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59298',1189454,'1485','201',683903.00,685570.00,1667.00,238381.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59298',1189455,'1486','201',491133.00,492162.00,1029.00,147147.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59298',1189456,'1487','201',672022.00,672654.00,632.00,90376.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59298',1189457,'1488','202',250341.00,250363.00,22.00,4840.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59298',1189458,'1489','202',328172.00,328674.00,502.00,110440.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59298',1189459,'1490','203',222651.97,222834.33,182.36,41942.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','59299',1189460,'1480','201',515838.00,518188.00,2350.00,336050.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59299',1189461,'1481','201',696563.00,698302.00,1739.00,248677.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59299',1189462,'1482','201',180022.00,183287.00,3265.00,466895.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59299',1189463,'1483','201',512866.00,512866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59299',1189464,'1484','201',500572.00,502783.00,2211.00,316173.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59299',1189465,'1485','201',685570.00,687527.00,1957.00,279851.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59299',1189466,'1486','201',492162.00,493144.00,982.00,140426.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59299',1189467,'1487','201',672654.00,674922.00,2268.00,324324.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59299',1189468,'1488','202',250363.00,250363.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59299',1189469,'1489','202',328674.00,328674.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59299',1189470,'1490','203',222834.33,223047.26,212.93,48973.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','59302',1189511,'1480','201',518188.00,519398.00,1210.00,173030.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59302',1189512,'1481','201',698302.00,699742.00,1440.00,205920.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59302',1189513,'1482','201',183287.00,183287.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59302',1189514,'1483','201',512866.00,515420.00,2554.00,365222.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59302',1189515,'1484','201',502783.00,504088.00,1305.00,186615.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59302',1189516,'1485','201',687527.00,689233.00,1706.00,243958.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59302',1189517,'1486','201',493144.00,493614.00,470.00,67210.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59302',1189518,'1487','201',674922.00,676436.00,1514.00,216502.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59302',1189519,'1488','202',250363.00,250363.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59302',1189520,'1489','202',328674.00,328674.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59302',1189521,'1490','203',223047.26,223146.49,99.23,22822.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','59304',1189536,'1480','201',519398.00,520345.00,947.00,135421.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59304',1189537,'1481','201',699742.00,702642.00,2900.00,414700.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59304',1189538,'1482','201',183287.00,185552.00,2265.00,323895.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59304',1189539,'1483','201',515420.00,515840.00,420.00,60060.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59304',1189540,'1484','201',504088.00,505827.00,1739.00,248677.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59304',1189541,'1485','201',689233.00,692323.00,3090.00,441870.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59304',1189542,'1486','201',493614.00,494697.00,1083.00,154869.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59304',1189543,'1487','201',676436.00,677976.00,1540.00,220220.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59304',1189544,'1488','202',250363.00,250363.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59304',1189545,'1489','202',328674.00,328674.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59304',1189546,'1490','203',223146.49,223241.98,95.49,21962.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','59305',1189547,'1480','201',520345.00,521034.00,689.00,98527.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59305',1189548,'1481','201',702642.00,704117.00,1475.00,210925.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59305',1189549,'1482','201',185552.00,185552.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59305',1189550,'1483','201',515840.00,517483.00,1643.00,234949.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59305',1189551,'1484','201',505827.00,507786.00,1959.00,280137.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59305',1189552,'1485','201',692323.00,694443.00,2120.00,303160.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59305',1189553,'1486','201',494697.00,495467.00,770.00,110110.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59305',1189554,'1487','201',677976.00,680901.00,2925.00,418275.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59305',1189555,'1488','202',250363.00,250457.00,94.00,20680.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59305',1189556,'1489','202',328674.00,329103.00,429.00,94380.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59305',1189557,'1490','203',223241.98,223401.40,159.42,36666.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','59309',1189626,'1480','201',521034.00,522774.00,1740.00,248820.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59309',1189627,'1481','201',704117.00,706047.00,1930.00,275990.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59309',1189628,'1482','201',185552.00,187620.00,2068.00,295724.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59309',1189629,'1483','201',517483.00,518760.00,1277.00,182611.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59309',1189630,'1484','201',507786.00,509670.00,1884.00,269412.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59309',1189631,'1485','201',694443.00,696627.00,2184.00,312312.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59309',1189632,'1486','201',495467.00,497373.00,1906.00,272558.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59309',1189633,'1487','201',680901.00,682250.00,1349.00,192907.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59309',1189634,'1488','202',250457.00,250457.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59309',1189635,'1489','202',329103.00,329103.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59309',1189636,'1490','203',223401.40,223688.76,287.36,66092.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','59313',1189704,'1480','201',522774.00,522774.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59313',1189705,'1481','201',706047.00,708410.00,2363.00,337909.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59313',1189706,'1482','201',187620.00,187620.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59313',1189707,'1483','201',518760.00,521116.00,2356.00,336908.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59313',1189708,'1484','201',509670.00,509670.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59313',1189709,'1485','201',696627.00,699058.00,2431.00,347633.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59313',1189710,'1486','201',497373.00,497373.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59313',1189711,'1487','201',682250.00,684267.00,2017.00,288431.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59313',1189712,'1488','202',250457.00,250457.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59313',1189713,'1489','202',329103.00,329103.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59313',1189714,'1490','203',223688.76,223791.97,103.21,23738.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','59344',1190417,'1480','201',522774.00,525234.00,2460.00,351780.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59344',1190418,'1481','201',708410.00,708794.00,384.00,54912.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59344',1190419,'1482','201',187620.00,189429.00,1809.00,258687.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59344',1190420,'1483','201',521116.00,522751.00,1635.00,233805.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59344',1190421,'1484','201',509670.00,511117.00,1447.00,206921.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59344',1190422,'1485','201',699058.00,700475.00,1417.00,202631.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59344',1190423,'1486','201',497373.00,498821.00,1448.00,207064.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59344',1190424,'1487','201',684267.00,685251.00,984.00,140712.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59344',1190425,'1488','202',250457.00,250457.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59344',1190426,'1489','202',329103.00,329103.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59344',1190427,'1490','203',223791.97,223952.45,160.48,36910.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','59350',1190519,'1480','201',525234.00,525234.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59350',1190520,'1481','201',708794.00,711590.00,2796.00,399828.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59350',1190521,'1482','201',189429.00,189429.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59350',1190522,'1483','201',522751.00,525037.00,2286.00,326898.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59350',1190523,'1484','201',511117.00,512129.00,1012.00,144716.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59350',1190524,'1485','201',700475.00,702095.00,1620.00,231660.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59350',1190525,'1486','201',498821.00,499957.00,1136.00,162448.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59350',1190526,'1487','201',685251.00,685875.00,624.00,89232.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59350',1190527,'1488','202',250457.00,250457.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59350',1190528,'1489','202',329103.00,329103.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59350',1190529,'1490','203',223952.45,224031.33,78.88,18142.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','59352',1190549,'1480','201',525234.00,526891.00,1657.00,236951.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59352',1190550,'1481','201',711590.00,713260.00,1670.00,238810.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59352',1190551,'1482','201',189429.00,192863.00,3434.00,491062.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59352',1190552,'1483','201',525037.00,525037.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59352',1190553,'1484','201',512129.00,513859.00,1730.00,247390.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59352',1190554,'1485','201',702095.00,704433.00,2338.00,334334.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59352',1190555,'1486','201',499957.00,500910.00,953.00,136279.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59352',1190556,'1487','201',685875.00,687151.00,1276.00,182468.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59352',1190557,'1488','202',250457.00,250457.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59352',1190558,'1489','202',329103.00,329837.00,734.00,161480.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59352',1190559,'1490','203',224031.33,224252.29,220.96,50820.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','59353',1190560,'1480','201',526891.00,526891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59353',1190561,'1481','201',713260.00,715810.00,2550.00,364650.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59353',1190562,'1482','201',192863.00,192863.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59353',1190563,'1483','201',525037.00,527514.00,2477.00,354211.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59353',1190564,'1484','201',513859.00,513859.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59353',1190565,'1485','201',704433.00,706550.00,2117.00,302731.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59353',1190566,'1486','201',500910.00,502307.00,1397.00,199771.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59353',1190567,'1487','201',687151.00,689158.00,2007.00,287001.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59353',1190568,'1488','202',250457.00,251302.00,845.00,185900.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59353',1190569,'1489','202',329837.00,329837.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59353',1190570,'1490','203',224252.29,224449.14,196.85,45275.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','59354',1190571,'1480','201',526891.00,529515.00,2624.00,375232.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59354',1190572,'1481','201',715810.00,717346.00,1536.00,219648.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59354',1190573,'1482','201',192863.00,195577.00,2714.00,388102.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59354',1190574,'1483','201',527514.00,527514.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59354',1190575,'1484','201',513859.00,514691.00,832.00,118976.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59354',1190576,'1485','201',706550.00,708178.00,1628.00,232804.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59354',1190577,'1486','201',502307.00,503734.00,1427.00,204061.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59354',1190578,'1487','201',689158.00,690906.00,1748.00,249964.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59354',1190579,'1488','202',251302.00,252011.00,709.00,155980.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59354',1190580,'1489','202',329837.00,329837.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59354',1190581,'1490','203',224449.14,224685.52,236.38,54367.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','59514',1193583,'1480','201',529515.00,529515.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59514',1193584,'1481','201',717346.00,718143.00,797.00,113971.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59514',1193585,'1482','201',195577.00,195577.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59514',1193586,'1483','201',527514.00,528850.00,1336.00,191048.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59514',1193587,'1484','201',514691.00,514691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59514',1193588,'1485','201',708178.00,710428.00,2250.00,321750.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59514',1193589,'1486','201',503734.00,504644.00,910.00,130130.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59514',1193590,'1487','201',690906.00,692040.00,1134.00,162162.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59514',1193591,'1488','202',252011.00,252261.00,250.00,55000.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59514',1193592,'1489','202',329837.00,330263.00,426.00,93720.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59514',1193593,'1490','203',224685.52,224710.05,24.53,5641.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','59516',1193608,'1480','201',529515.00,531426.00,1911.00,273273.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59516',1193609,'1481','201',718143.00,720228.00,2085.00,298155.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59516',1193610,'1482','201',195577.00,196736.00,1159.00,165737.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59516',1193611,'1483','201',528850.00,530709.00,1859.00,265837.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59516',1193612,'1484','201',514691.00,516853.00,2162.00,309166.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59516',1193613,'1485','201',710428.00,710428.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59516',1193614,'1486','201',504644.00,505823.00,1179.00,168597.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59516',1193615,'1487','201',692040.00,693659.00,1619.00,231517.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59516',1193616,'1488','202',252261.00,252744.00,483.00,106260.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59516',1193617,'1489','202',330263.00,330263.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59516',1193618,'1490','203',224710.05,224939.22,229.17,52709.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','59781',1198671,'1480','201',531426.00,533049.00,1623.00,232089.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59781',1198672,'1481','201',720228.00,722701.00,2473.00,353639.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59781',1198673,'1482','201',196736.00,196736.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59781',1198674,'1483','201',530709.00,532936.00,2227.00,318461.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59781',1198675,'1484','201',516853.00,516853.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59781',1198676,'1485','201',710428.00,710428.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59781',1198677,'1486','201',505823.00,507034.00,1211.00,173173.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59781',1198678,'1487','201',693659.00,695786.00,2127.00,304161.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59781',1198679,'1488','202',252744.00,253009.00,265.00,58300.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59781',1198680,'1489','202',330263.00,330918.00,655.00,144100.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59781',1198681,'1490','203',224939.22,225068.23,129.01,29672.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','59789',1198775,'1480','201',533049.00,534097.00,1048.00,149864.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59789',1198776,'1481','201',722701.00,724344.00,1643.00,234949.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59789',1198777,'1482','201',196736.00,198853.00,2117.00,302731.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59789',1198778,'1483','201',532936.00,532936.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59789',1198779,'1484','201',516853.00,516853.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59789',1198780,'1485','201',710428.00,710428.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59789',1198781,'1486','201',507034.00,509762.00,2728.00,390104.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59789',1198782,'1487','201',695786.00,699045.00,3259.00,466037.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59789',1198783,'1488','202',253009.00,253471.00,462.00,101640.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59789',1198784,'1489','202',330918.00,331515.00,597.00,131340.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59789',1198785,'1490','203',225068.23,225154.68,86.45,19883.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','59792',1198828,'1480','201',534097.00,534097.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59792',1198829,'1481','201',724344.00,727062.00,2718.00,388674.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59792',1198830,'1482','201',198853.00,198853.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59792',1198831,'1483','201',532936.00,535606.00,2670.00,381810.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59792',1198832,'1484','201',516853.00,517966.00,1113.00,159159.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59792',1198833,'1485','201',710428.00,711939.00,1511.00,216073.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59792',1198834,'1486','201',509762.00,510765.00,1003.00,143429.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59792',1198835,'1487','201',699045.00,700241.00,1196.00,171028.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59792',1198836,'1488','202',253471.00,254267.00,796.00,175120.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59792',1198837,'1489','202',331515.00,331515.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59792',1198838,'1490','203',225154.68,225253.47,98.79,22721.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','59829',1199717,'1480','201',534097.00,536097.00,2000.00,286000.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59829',1199718,'1481','201',727062.00,729697.00,2635.00,376805.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59829',1199719,'1482','201',198853.00,201901.00,3048.00,435864.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59829',1199720,'1483','201',535606.00,535606.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59829',1199721,'1484','201',517966.00,521102.00,3136.00,448448.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59829',1199722,'1485','201',711939.00,711939.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59829',1199723,'1486','201',510765.00,510765.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59829',1199724,'1487','201',700241.00,702654.00,2413.00,345059.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59829',1199725,'1488','202',254267.00,254806.00,539.00,118580.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59829',1199726,'1489','202',331515.00,331515.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59829',1199727,'1490','203',225253.47,225407.51,154.04,35429.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','59830',1199728,'1480','201',536097.00,536410.00,313.00,44759.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59830',1199729,'1481','201',729697.00,732203.00,2506.00,358358.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59830',1199730,'1482','201',201901.00,201901.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59830',1199731,'1483','201',535606.00,538494.00,2888.00,412984.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59830',1199732,'1484','201',521102.00,521137.00,35.00,5005.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59830',1199733,'1485','201',711939.00,714327.00,2388.00,341484.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59830',1199734,'1486','201',510765.00,512039.00,1274.00,182182.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59830',1199735,'1487','201',702654.00,703981.00,1327.00,189761.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59830',1199736,'1488','202',254806.00,255962.00,1156.00,254320.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59830',1199737,'1489','202',331515.00,331515.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59830',1199738,'1490','203',225407.51,225540.29,132.78,30539.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','59831',1199739,'1480','201',536410.00,537530.00,1120.00,160160.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59831',1199740,'1481','201',732203.00,733484.00,1281.00,183183.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59831',1199741,'1482','201',201901.00,203124.00,1223.00,174889.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59831',1199742,'1483','201',538494.00,539654.00,1160.00,165880.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59831',1199743,'1484','201',521137.00,523990.00,2853.00,407979.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59831',1199744,'1485','201',714327.00,715874.00,1547.00,221221.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59831',1199745,'1486','201',512039.00,512767.00,728.00,104104.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59831',1199746,'1487','201',703981.00,704930.00,949.00,135707.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59831',1199747,'1488','202',255962.00,257237.00,1275.00,280500.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59831',1199748,'1489','202',331515.00,332098.00,583.00,128260.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59831',1199749,'1490','203',225540.29,225800.70,260.41,59894.30,0.00,0.00,0.00,0.00,0.00),('1','64','536','59945',1201788,'1480','201',537530.00,539049.00,1519.00,217217.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59945',1201789,'1481','201',733484.00,735704.00,2220.00,317460.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59945',1201790,'1482','201',203124.00,204042.00,918.00,131274.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59945',1201791,'1483','201',539654.00,541623.00,1969.00,281567.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59945',1201792,'1484','201',523990.00,523990.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59945',1201793,'1485','201',715874.00,718278.00,2404.00,343772.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59945',1201794,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59945',1201795,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59945',1201796,'1488','202',257237.00,257853.00,616.00,135520.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59945',1201797,'1489','202',332098.00,332448.00,350.00,77000.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59945',1201798,'1490','203',225800.70,225947.24,146.54,33704.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','59946',1201799,'1480','201',539049.00,541508.00,2459.00,351637.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59946',1201800,'1481','201',735704.00,738489.00,2785.00,398255.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59946',1201801,'1482','201',204042.00,205968.00,1926.00,275418.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','59946',1201802,'1483','201',541623.00,544645.00,3022.00,432146.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59946',1201803,'1484','201',523990.00,524661.00,671.00,95953.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','59946',1201804,'1485','201',718278.00,719643.00,1365.00,195195.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59946',1201805,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','59946',1201806,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59946',1201807,'1488','202',257853.00,258445.00,592.00,130240.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','59946',1201808,'1489','202',332448.00,332448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','59946',1201809,'1490','203',225947.24,226006.87,59.63,13714.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','60059',1204123,'1480','201',541508.00,543739.00,2231.00,319033.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60059',1204124,'1481','201',738489.00,741169.00,2680.00,383240.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60059',1204125,'1482','201',205968.00,208323.00,2355.00,336765.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60059',1204126,'1483','201',544645.00,547398.00,2753.00,393679.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60059',1204127,'1484','201',524661.00,524661.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60059',1204128,'1485','201',719643.00,719643.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60059',1204129,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60059',1204130,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60059',1204131,'1488','202',258445.00,259256.00,811.00,178420.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60059',1204132,'1489','202',332448.00,333349.00,901.00,198220.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60059',1204133,'1490','203',226006.87,226118.03,111.16,25566.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','60117',1205185,'1480','201',543739.00,546418.00,2679.00,383097.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60117',1205186,'1481','201',741169.00,744546.00,3377.00,482911.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60117',1205187,'1482','201',208323.00,210644.00,2321.00,331903.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60117',1205188,'1483','201',547398.00,550677.00,3279.00,468897.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60117',1205189,'1484','201',524661.00,525088.00,427.00,61061.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60117',1205190,'1485','201',719643.00,720222.00,579.00,82797.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60117',1205191,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60117',1205192,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60117',1205193,'1488','202',259256.00,260371.00,1115.00,245300.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60117',1205194,'1489','202',333349.00,333370.00,21.00,4620.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60117',1205195,'1490','203',226118.03,226315.55,197.52,45429.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','60119',1205226,'1480','201',546418.00,548110.00,1692.00,241956.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60119',1205227,'1481','201',744546.00,746628.00,2082.00,297726.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60119',1205228,'1482','201',210644.00,212178.00,1534.00,219362.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60119',1205229,'1483','201',550677.00,552055.00,1378.00,197054.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60119',1205230,'1484','201',525088.00,526668.00,1580.00,225940.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60119',1205231,'1485','201',720222.00,722090.00,1868.00,267124.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60119',1205232,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60119',1205233,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60119',1205234,'1488','202',260371.00,261502.00,1131.00,248820.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60119',1205235,'1489','202',333370.00,334175.00,805.00,177100.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60119',1205236,'1490','203',226315.55,226449.32,133.77,30767.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','60145',1205820,'1480','201',548110.00,550294.00,2164.00,309452.00,0.00,0.00,20.00,0.00,0.00),('1','64','536','60145',1205821,'1481','201',746628.00,749402.00,2764.00,395252.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','60145',1205822,'1482','201',212178.00,214400.00,2212.00,316316.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','60145',1205823,'1483','201',552055.00,554230.00,2165.00,309595.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','60145',1205824,'1484','201',526668.00,528844.00,2166.00,309738.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','60145',1205825,'1485','201',722090.00,724400.00,2290.00,327470.00,0.00,0.00,20.00,0.00,0.00),('1','64','538','60145',1205826,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60145',1205827,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60145',1205828,'1488','202',261502.00,261502.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60145',1205829,'1489','202',334175.00,335155.00,960.00,211200.00,0.00,0.00,20.00,0.00,0.00),('1','64','540','60145',1205830,'1490','203',226449.32,226591.11,131.79,30311.70,0.00,0.00,10.00,0.00,0.00),('1','64','536','60221',1207247,'1480','201',550294.00,551564.00,1270.00,181610.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60221',1207248,'1481','201',749402.00,751676.00,2274.00,325182.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60221',1207249,'1482','201',214400.00,215438.00,1038.00,148434.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60221',1207250,'1483','201',554230.00,556674.00,2444.00,349492.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60221',1207251,'1484','201',528844.00,529998.00,1154.00,165022.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60221',1207252,'1485','201',724400.00,725843.00,1443.00,206349.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60221',1207253,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60221',1207254,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60221',1207255,'1488','202',261502.00,262687.00,1185.00,260700.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60221',1207256,'1489','202',335155.00,335155.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60221',1207257,'1490','203',226591.11,226716.49,125.38,28837.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','60318',1209038,'1480','201',551564.00,553079.00,1515.00,216645.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60318',1209039,'1481','201',751676.00,753566.00,1890.00,270270.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60318',1209040,'1482','201',215438.00,216627.00,1189.00,170027.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60318',1209041,'1483','201',556674.00,558487.00,1813.00,259259.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60318',1209042,'1484','201',529998.00,532790.00,2792.00,399256.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60318',1209043,'1485','201',725843.00,728572.00,2729.00,390247.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60318',1209044,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60318',1209045,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60318',1209046,'1488','202',262687.00,263336.00,649.00,142780.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60318',1209047,'1489','202',335155.00,336030.00,875.00,192500.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60318',1209048,'1490','203',226716.49,226911.64,195.15,44884.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','60442',1211510,'1480','201',553079.00,554301.00,1222.00,174746.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60442',1211511,'1481','201',753566.00,755131.00,1565.00,223795.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60442',1211512,'1482','201',216627.00,218002.00,1375.00,196625.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60442',1211513,'1483','201',558487.00,560430.00,1943.00,277849.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60442',1211514,'1484','201',532790.00,534016.00,1226.00,175318.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60442',1211515,'1485','201',728572.00,730333.00,1761.00,251823.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60442',1211516,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60442',1211517,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60442',1211518,'1488','202',263336.00,263951.00,615.00,135300.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60442',1211519,'1489','202',336030.00,336651.00,621.00,136620.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60442',1211520,'1490','203',226911.64,226975.31,63.67,14644.10,0.00,0.00,0.00,0.00,0.00),('1','64','536','60444',1211543,'1480','201',554301.00,556136.00,1835.00,262405.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60444',1211544,'1481','201',755131.00,757690.00,2559.00,365937.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60444',1211545,'1482','201',218002.00,218002.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60444',1211546,'1483','201',560430.00,562697.00,2267.00,324181.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60444',1211547,'1484','201',534016.00,535685.00,1669.00,238667.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60444',1211548,'1485','201',730333.00,732523.00,2190.00,313170.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60444',1211549,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60444',1211550,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60444',1211551,'1488','202',263951.00,264945.00,994.00,218680.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60444',1211552,'1489','202',336651.00,336651.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60444',1211553,'1490','203',226975.31,227102.66,127.35,29290.50,0.00,0.00,0.00,0.00,0.00),('1','64','536','60448',1211604,'1480','201',556136.00,557737.00,1601.00,228943.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60448',1211605,'1481','201',757690.00,760255.00,2565.00,366795.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60448',1211606,'1482','201',218002.00,219691.00,1689.00,241527.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60448',1211607,'1483','201',562697.00,564624.00,1927.00,275561.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60448',1211608,'1484','201',535685.00,536983.00,1298.00,185614.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60448',1211609,'1485','201',732523.00,734946.00,2423.00,346489.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60448',1211610,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60448',1211611,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60448',1211612,'1488','202',264945.00,267157.00,2212.00,486640.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60448',1211613,'1489','202',336651.00,337216.00,565.00,124300.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60448',1211614,'1490','203',227102.66,227498.92,396.26,91139.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','60464',1211879,'1480','201',557737.00,560161.00,2414.00,345202.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','60464',1211880,'1481','201',760255.00,762128.00,1863.00,266409.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','60464',1211881,'1482','201',219691.00,221593.00,1892.00,270556.00,0.00,0.00,10.00,0.00,0.00),('1','64','536','60464',1211882,'1483','201',564624.00,566706.00,2072.00,296296.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','60464',1211883,'1484','201',536983.00,537917.00,924.00,132132.00,0.00,0.00,10.00,0.00,0.00),('1','64','537','60464',1211884,'1485','201',734946.00,737490.00,2534.00,362362.00,0.00,0.00,10.00,0.00,0.00),('1','64','538','60464',1211885,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60464',1211886,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60464',1211887,'1488','202',267157.00,267157.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60464',1211888,'1489','202',337216.00,338413.00,1177.00,258940.00,0.00,0.00,20.00,0.00,0.00),('1','64','540','60464',1211889,'1490','203',227498.92,227663.28,154.36,35502.80,0.00,0.00,10.00,0.00,0.00),('1','64','536','60624',1214821,'1480','201',560161.00,560944.00,783.00,111969.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60624',1214822,'1481','201',762128.00,764375.00,2247.00,321321.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60624',1214823,'1482','201',221593.00,221593.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60624',1214824,'1483','201',566706.00,569597.00,2891.00,413413.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60624',1214825,'1484','201',537917.00,540297.00,2380.00,340340.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60624',1214826,'1485','201',737490.00,740402.00,2912.00,416416.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60624',1214827,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60624',1214828,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60624',1214829,'1488','202',267157.00,268395.00,1238.00,272360.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60624',1214830,'1489','202',338413.00,338440.00,27.00,5940.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60624',1214831,'1490','203',227663.28,227780.94,117.66,27061.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','60763',1217602,'1480','201',560944.00,560944.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60763',1217603,'1481','201',764375.00,768258.00,3883.00,555269.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60763',1217604,'1482','201',221593.00,224618.00,3025.00,432575.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60763',1217605,'1483','201',569597.00,572896.00,3299.00,471757.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60763',1217606,'1484','201',540297.00,542255.00,1958.00,279994.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60763',1217607,'1485','201',740402.00,743316.00,2914.00,416702.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60763',1217608,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60763',1217609,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60763',1217610,'1488','202',268395.00,268969.00,564.00,124080.00,0.00,0.00,10.00,0.00,0.00),('1','64','539','60763',1217611,'1489','202',338440.00,339054.00,604.00,132880.00,0.00,0.00,10.00,0.00,0.00),('1','64','540','60763',1217612,'1490','203',227780.94,227970.20,189.26,43529.80,0.00,0.00,0.00,0.00,0.00),('1','64','536','60769',1217699,'1480','201',560944.00,560944.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60769',1217700,'1481','201',768258.00,771359.00,3101.00,443443.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60769',1217701,'1482','201',224618.00,226249.00,1631.00,233233.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60769',1217702,'1483','201',572896.00,575006.00,2110.00,301730.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60769',1217703,'1484','201',542255.00,544167.00,1912.00,273416.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60769',1217704,'1485','201',743316.00,744948.00,1632.00,233376.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60769',1217705,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60769',1217706,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60769',1217707,'1488','202',268969.00,269567.00,598.00,131560.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60769',1217708,'1489','202',339054.00,339190.00,136.00,29920.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60769',1217709,'1490','203',227970.20,228108.48,138.28,31804.40,0.00,0.00,0.00,0.00,0.00),('1','64','536','60778',1217871,'1480','201',560944.00,560944.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60778',1217872,'1481','201',771359.00,774591.00,3232.00,462176.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60778',1217873,'1482','201',226249.00,227804.00,1555.00,222365.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60778',1217874,'1483','201',575006.00,577279.00,2273.00,325039.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60778',1217875,'1484','201',544167.00,545261.00,1094.00,156442.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60778',1217876,'1485','201',744948.00,746876.00,1928.00,275704.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60778',1217877,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60778',1217878,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60778',1217879,'1488','202',269567.00,270183.00,616.00,135520.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60778',1217880,'1489','202',339190.00,339224.00,34.00,7480.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60778',1217881,'1490','203',228108.48,228212.92,104.44,24021.20,0.00,0.00,0.00,0.00,0.00),('1','64','536','60871',1219773,'1480','201',560944.00,560944.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60871',1219774,'1481','201',774591.00,777730.00,3139.00,448877.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60871',1219775,'1482','201',227804.00,229522.00,1718.00,245674.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60871',1219776,'1483','201',577279.00,579260.00,1981.00,283283.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60871',1219777,'1484','201',545261.00,547439.00,2178.00,311454.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60871',1219778,'1485','201',746876.00,749126.00,2250.00,321750.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60871',1219779,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60871',1219780,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60871',1219781,'1488','202',270183.00,271289.00,1106.00,243320.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60871',1219782,'1489','202',339224.00,339304.00,80.00,17600.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60871',1219783,'1490','203',228212.92,228335.74,122.82,28248.60,0.00,0.00,0.00,0.00,0.00),('1','64','536','60872',1219784,'1480','201',560944.00,562390.00,1446.00,206778.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60872',1219785,'1481','201',777730.00,780755.00,3025.00,432575.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60872',1219786,'1482','201',229522.00,231797.00,2275.00,325325.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60872',1219787,'1483','201',579260.00,583309.00,4049.00,579007.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60872',1219788,'1484','201',547439.00,547867.00,428.00,61204.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60872',1219789,'1485','201',749126.00,750011.00,885.00,126555.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60872',1219790,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60872',1219791,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60872',1219792,'1488','202',271289.00,273010.00,1721.00,378620.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60872',1219793,'1489','202',339304.00,339462.00,158.00,34760.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60872',1219794,'1490','203',228335.74,228472.14,136.40,31372.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60875',1219821,'1480','201',562390.00,562894.00,504.00,72072.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60875',1219822,'1481','201',780755.00,782235.00,1480.00,211640.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60875',1219823,'1482','201',231797.00,232914.00,1117.00,159731.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60875',1219824,'1483','201',583309.00,584728.00,1419.00,202917.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60875',1219825,'1484','201',547867.00,550080.00,2213.00,316459.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60875',1219826,'1485','201',750011.00,753131.00,3120.00,446160.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60875',1219827,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60875',1219828,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60875',1219829,'1488','202',273010.00,274078.00,1068.00,234960.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60875',1219830,'1489','202',339462.00,340168.00,706.00,155320.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60875',1219831,'1490','203',228472.14,228698.97,226.83,52170.90,0.00,0.00,0.00,0.00,0.00),('1','64','536','60959',1221492,'1480','201',562894.00,564578.00,1684.00,240812.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60959',1221493,'1481','201',782235.00,784558.00,2323.00,332189.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60959',1221494,'1482','201',232914.00,235140.00,2226.00,318318.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60959',1221495,'1483','201',584728.00,587244.00,2516.00,359788.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60959',1221496,'1484','201',550080.00,551701.00,1621.00,231803.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60959',1221497,'1485','201',753131.00,755034.00,1903.00,272129.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60959',1221498,'1486','201',512767.00,512767.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','538','60959',1221499,'1487','201',704930.00,704930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60959',1221500,'1488','202',274078.00,275205.00,1127.00,247940.00,0.00,0.00,0.00,0.00,0.00),('1','64','539','60959',1221501,'1489','202',340168.00,340333.00,165.00,36300.00,0.00,0.00,0.00,0.00,0.00),('1','64','540','60959',1221502,'1490','203',228698.97,228881.06,182.09,41880.70,0.00,0.00,0.00,0.00,0.00),('1','64','536','60960',1221503,'1480','201',564578.00,566883.00,2305.00,329615.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60960',1221504,'1481','201',784558.00,786762.00,2204.00,315172.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60960',1221505,'1482','201',235140.00,237276.00,2136.00,305448.00,0.00,0.00,0.00,0.00,0.00),('1','64','536','60960',1221506,'1483','201',587244.00,589594.00,2350.00,336050.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60960',1221507,'1484','201',551701.00,552921.00,1220.00,174460.00,0.00,0.00,0.00,0.00,0.00),('1','64','537','60960',1221508,'1485','201',755034.00,757187.00,2153.00,307879.0